﻿USE sofia;
DROP TABLE IF EXISTS sofia.rol_vpl;
CREATE TABLE rol_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES rol_vpl WRITE;
INSERT INTO rol_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Imaw ini ang listahan ng mga kalulo-lulohan ni Hesu-Kristo nga inapo ni David. Si David hay inapo ni Abraham. ");
INSERT INTO rol_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Si Abraham hay tatay ni Isaac, si Isaac hay tatay ni Jacob kag si Jacob hay tatay ni Juda kag ng iya mga hali nga lyaki. ");
INSERT INTO rol_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Si Juda ang tatay ni Perez kag ni Zera kag si Tamar ang inda nanay. Si Perez hay tatay ni Hezron kag si Hezron hay tatay ni Aram. ");
INSERT INTO rol_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Si Aram hay tatay ni Aminadab, si Aminadab hay tatay ni Nashon kag si Nashon hay tatay ni Salmon. ");
INSERT INTO rol_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Si Salmon nakapangasawa kay Rahab kag ang inda ungà hay si Boaz. Si Boaz nakapangasawa kay Ruth kag ang inda ungà hay si Obed. Si Obed hay tatay ni Jesse, ");
INSERT INTO rol_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","kag si Jesse hay tatay ni Haring David. Si Haring David hay tatay ni Solomon. Ang nanay ni Solomon hay asawa ni Uria nga namatay na. ");
INSERT INTO rol_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Si Solomon hay tatay ni Rehoboam, Si Rehoboam hay tatay ni Abia kag si Abia hay tatay ni Asa. ");
INSERT INTO rol_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Si Asa hay tatay ni Jehoshafat, si Jehoshafat hay tatay ni Joram kag si Joram hay tatay ni Uzia. ");
INSERT INTO rol_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Si Uzia hay tatay ni Jotam, si Jotam hay tatay ni Ahaz kag si Ahaz hay tatay ni Hezekia. ");
INSERT INTO rol_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Si Hezekia hay tatay ni Manase, si Manase hay tatay ni Amos, si Amos hay tatay ni Josia, ");
INSERT INTO rol_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","kag si Josia hay tatay ni Jeconia kag ng iya mga manghod nga lyaki. Nang adto nga tyempo, gingbihag ang mga Israelita pakadto sa Babilonia. ");
INSERT INTO rol_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Imaw ini ang mga kalulo-lulohan ni Hesus pagkatapos nga gingbihag ang mga Israelita pakadto sa Babilonia: Si Jeconia hay tatay ni Salatiel, si Salatiel hay tatay ni Zerubabel*, ");
INSERT INTO rol_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","kag si Zerubabel hay tatay ni Abiud. Si Abiud hay tatay ni Eliakim, si Eliakim hay tatay ni Azor, ");
INSERT INTO rol_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","kag si Azor hay tatay ni Zadok. Si Zadok hay tatay ni Akim kag si Akim hay tatay ni Eliud. ");
INSERT INTO rol_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Si Eliud hay tatay ni Eleazar, si Eleazar hay tatay ni Matan, si Matan hay tatay ni Jacob, ");
INSERT INTO rol_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","si Jacob hay tatay ni Jose nga asawa ni Maria. Si Maria ang nanay ni Hesus nga ginatawag nga Kristo*. ");
INSERT INTO rol_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nganì may 14 ka henerasyon halin kay Abraham hasta kay David. Kag may 14 da ka henerasyon halin kay David hasta sa pagkabihag ng mga Israelita sa Babilonia. Halin sa adto nga pagkabihag, may 14 pa ka henerasyon hasta sa pag-ungà kay Kristo. ");
INSERT INTO rol_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Imaw ini ang natabò nang pag-ungà kay Hesu-Kristo. Si Maria nga iya nanay hay kyasayon na kay Jose. Pero bago pa sinda makasay, nasayuran ni Maria nga nabdos na siya paagi sa gahom ng Espiritu Santo. ");
INSERT INTO rol_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Niyan, si Jose nga magiging asawa niya hay matarong nga tawo kag indì niya gusto nga mahuy-an si Maria. Nganì nagdesisyon siya nga buyagan si Maria ning pasikreto lang. ");
INSERT INTO rol_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Mintras ginahunahunà ni Jose ang iya humanon, nagpakità sa iya sa pananamgo ang anghel ng Ginoo nga naghambay, “Jose, inapo ni David, ayaw mahadlok nga pakasayan si Maria, kay ang iya ginanabdos hay paagi sa gahom ng Espiritu Santo. ");
INSERT INTO rol_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Magaungà siya ning lyaki kag pangayanan mo siya nga Hesus kay luwason niya ang mga tawo nga sakop sa inda mga salà.” ");
INSERT INTO rol_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Natabò ini para matuman ang ginghambay ng Ginoo paagi sa propeta*, ");
INSERT INTO rol_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Maganabdos ang isa ka birhen kag magaungà ning lyaki. Kag ini nga ungà pagatawagon, Emmanuel (ang gusto hambayon kaibahan naton ang Dios).” ");
INSERT INTO rol_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Nganì pagbatì ni Jose, gingtuman niya ang ginghambay ng anghel ng Ginoo kag gingpakasayan niya si Maria. ");
INSERT INTO rol_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pero wayà niya gingtandoga si Maria hasta nga nag-ungà siya ng iya panganay nga lyaki. Kag gingpangayanan ni Jose nga Hesus ang ungà. ");
INSERT INTO rol_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ging-ungà si Hesus sa Betlehem nga sakop ng Judea nang tyempo nga si Herodes ang harì didto. May nag-abot nga mga kamayad nga tawo sa Jerusalem halin sa este. ");
INSERT INTO rol_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Nagpangutana sinda, “Diin baya ging-ungà ang harì ng mga Judio? Nakità namon ang iya bituon sa este, nganì nagkari kami para magsamba sa iya.” ");
INSERT INTO rol_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nang mabatian ini ni Haring Herodes, nalibugan gid siya kag imaw da ang tanan nga mga tawo sa Jerusalem. ");
INSERT INTO rol_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nganì gingpatawag niya ang tanan nga pinunò nga parì kag mga eskriba* kag nagpangutana sa inda kung diin iungà ang Kristo. ");
INSERT INTO rol_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Nagsabat sinda, “Didto sa Betlehem nga sakop ng Judea, kay imaw ini ang gingsulat ng isa ka propeta: ");
INSERT INTO rol_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Kamo nga taga-Betlehem nga sakop ng Juda, ang indo banwa hay magiging pinakaimportante na sa mga banwa ng Juda; kay dirà sa indo magahalin ang pinunò nga magadumaya sa akon mga tawo nga Israelita.’ ” ");
INSERT INTO rol_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nang masayuran ini ni Herodes, gingpatawag niya ning sikreto adto nga mga tawo nga halin sa este kag gingpangutana kung kasan-o gid nagpakità ang bituon nga inda nakità. ");
INSERT INTO rol_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Pagkatapos gingpakadto niya sinda sa Betlehem kag ginghambay, “Panaw na kamo kag pangitaon nindo ang ungà. Kag kung makità nindo siya, pasayura ako, para makakadto da ako kag makasamba sa iya.” ");
INSERT INTO rol_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Pagkahambay ini ng harì, nagpanaw na sinda. Mintras nagapanaw sinda nakità ninda liwat ang bituon nga inda nakità sa este. Nag-una ini sa inda kag nagduyog sa bayay nga yadto ang ungà. ");
INSERT INTO rol_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Nalipay gid sinda nang makità ang bituon. ");
INSERT INTO rol_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Pagsuyod ninda sa bayay, nakità ninda ang ungà kag ang iya nanay nga si Maria. Nagluhod sinda kag nagsamba sa ungà. Kag gingbuksan ninda ang inda mga daya kag ginghalad sa ungà ang inda mga regalo nga bulawan, insenso kag mira*. ");
INSERT INTO rol_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Pagbalik ninda, nag-agi sinda sa iban nga dayan kay gingpaandaman sinda sa pananamgo nga indì na sinda magbalik kay Herodes. ");
INSERT INTO rol_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nang wayà na adto nga mga tawo, nagpakità ang anghel ng Ginoo kay Jose sa pananamgo kag naghambay, “Bangon na, day-a ang ungà kag ang iya nanay kag maglikaw kamo pakadto sa Egipto. Didto lang anay kamo hasta nga maghambay ako nga puydi na kamo makabalik, kay papangitaon na ni Herodes ang ungà para ipapatay.” ");
INSERT INTO rol_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Nganì adto nga daan, nagbangon si Jose kag gingdaya ang ungà kag ang iya nanay sa Egipto. ");
INSERT INTO rol_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Nagtinir sinda didto hasta nga namatay si Herodes. Natabò ini para matuman ang ginghambay ng Ginoo paagi sa propeta, “Gingtawag ko ang akon ungà halin sa Egipto.” ");
INSERT INTO rol_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Nang masayuran ni Herodes nga gingluko siya ng mga kamayad nga tawo, nahangit gid siya. Nagsugò siya nga patyon ang tanan nga ungà nga lyaki sa Betlehem kag sa palibot nga mga lugar nga nagaedad ning duha ka tuig paubos. Nasayuran niya ang edad ng ungà sa ginghambay ng mga tawo halin sa este nga duha na ka tuig ang nakaligad tunà nang inda makità ang bituon. ");
INSERT INTO rol_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Sa ini nga pagpamatay sa mga ungà, natuman ang gingpropesiya ni Propeta Jeremias: ");
INSERT INTO rol_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“May nabatian nga pag-inuwang kag tudo gid nga pagdinanguyngoy sa banwa ng Rama. Nagainuwang si Raquel sa iya mga ungà; kag indì gid siya mapalipay kay nagkamatay na sinda.” ");
INSERT INTO rol_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Nang patay na si Herodes, nagpakità ang anghel ng Ginoo kay Jose sa pananamgo didto sa Egipto. ");
INSERT INTO rol_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Naghambay siya, “Bangon na, day-a ang ungà kag ang iya nanay pabalik sa Israel, kay namatay na ang mga nagplano nga patyon ang ungà.” ");
INSERT INTO rol_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Nganì nagbangon si Jose kag gingdaya niya ang ungà kag ang iya nanay pabalik sa Israel. ");
INSERT INTO rol_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pero nang masayuran ni Jose nga si Arkelaus ang nagaharì sa Judea kabaylo ng iya tatay nga si Herodes, nahadlok siya nga magbalik didto. Kag nang gingpaandaman pa gid siya ng Dios paagi sa pananamgo, nagderitso siya kaibahan ang iya pamilya sa probinsya ng Galilea. ");
INSERT INTO rol_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Didto sinda nag-istar sa banwa ng Nazaret. Nganì natuman ang ginghambay ng propeta nang una, “Pagatawagon siya nga Nazareno.” ");
INSERT INTO rol_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nang adto nga tyempo nga nagaistar pa sina Hesus sa Nazaret, nagtunà si Juan nga Miyugbawtismo sa pagwali sa tiway nga lugar ng Judea. ");
INSERT INTO rol_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Hambay niya, “Talikuri nindo ang indo mga kasal-anan, kay malapit na ang oras nga magaharì ang Dios.” ");
INSERT INTO rol_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Si Juan imaw ang ginghambay ni Propeta Isaias nang naghambay siya: “May magasinggit sa tiway nga lugar. Magahambay siya sa mga tawo, ‘Ipreparar nindo ang agihan para sa Ginoo, tadlunga ang dayan nga iya pagaagihan!’ ” ");
INSERT INTO rol_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ang barò ni Juan hay himò sa buyboy ng kamelyo kag ang iya sinturon hay panit ng hayop. Ang iya pagkaon hay apan kag dugos. ");
INSERT INTO rol_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Madamò nga tawo ang nagkadto sa iya halin sa Jerusalem, sa tanan nga banwa nga sakop ng Judea kag sa tanan nga lugar sa palibot ng Subà ng Jordan. ");
INSERT INTO rol_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ging-akò ninda ang inda mga salà kag gingbawtismuhan niya sinda sa Subà ng Jordan. ");
INSERT INTO rol_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Pero nang makità ni Juan nga kadamò nga Pariseo* kag Saduceo* ang nagakadto sa iya para magpabawtismo, naghambay siya sa inda, “Mga inapo kamo ng sawa! Sin-o ang naghambay sa indo nga makalikaw kamo sa paabuton nga parusa ng Dios? ");
INSERT INTO rol_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kung matuod nga ginatalikuran nindo ang indo kasal-anan, pamatuuri ini paagi sa indo paghuman ning maayo. ");
INSERT INTO rol_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kag ayaw maghambay nga mga inapo kamo ni Abraham, makalikaw kamo sa parusa. Pero matuod ang akon ginahambay sa indo nga aber ang mga bato nga yari diri puydi humanon ng Dios nga mga inapo ni Abraham. ");
INSERT INTO rol_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Tandai nindo ini: ang wasay hay preparado na sa pagpukan ng mga kahoy. Nganì ang kada kahoy nga wayà nagapamunga ning maayo hay pagapukanon kag ipilak sa kalayo. ");
INSERT INTO rol_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Nagabawtismo ako sa indo sa tubì nga nagapakilaya nga nagatalikod na kamo sa indo mga salà, pero may maabot nga masunod sa akon nga mas makagagahom pa kaysa sa akon kag indì gid ako angay aber magbitbit ng iya mga sandalyas. Siya ang magabawtismo sa indo sa Espiritu Santo kag sa kalayo. ");
INSERT INTO rol_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Pareho siya sa miyug-ani nga nagapapalid ng iya inani para lainon ang matinggas sa upa. Ang matinggas tipunon niya kag ibutang sa kamalig, pero ang upa hay sunugon niya sa kalayo nga indì gid mamatay.” ");
INSERT INTO rol_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Niyan, naghalin si Hesus sa probinsya ng Galilea kag nagkadto sa Subà ng Jordan kay Juan para magpabawtismo. ");
INSERT INTO rol_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Indì kuntà magbawtismo si Juan sa iya. Hambay niya, “Basì magpabawtismo ka sa akon? Ako nganì ang kahinangyan nga magpabawtismo sa imo.” ");
INSERT INTO rol_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Pero nagsabat si Hesus sa iya, “Sige lang tuo, kay imaw ini ang dapat naton humanon para matuman ang tanan nga kabubut-on ng Dios.” Nganì nagsugot si Juan nga bawtismuhan si Hesus. ");
INSERT INTO rol_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nang mabawtismuhan na si Hesus, naghaw-as nga daan siya sa tubì. Niyan, gulpi lang nga nag-abri ang langit kag nakità niya ang Espiritu ng Dios nga daw salampati hay nagababà kag naghuyon sa iya. ");
INSERT INTO rol_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kag igwa ning boses nga nabatian halin sa langit nga naghambay, “Ini ang akon pinalanggà nga Ungà, nalilipay gid ako sa iya.” ");
INSERT INTO rol_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Pagkatapos adto, gingtuytuyan si Hesus ng Espiritu Santo sa tiway nga lugar para tintaron ng diyablo. ");
INSERT INTO rol_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Sa suyod ng 40 ka adlaw kag gab-i nagpuasa si Hesus, nganì ginggutom gid siya. ");
INSERT INTO rol_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Nagpalapit sa iya si Satanas kag naghambay, “Kung ikaw ang Ungà ng Dios, himua ining mga bato nga maging tinapay.” ");
INSERT INTO rol_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Pero nagsabat si Hesus, “Ginahambay ng Kasulatan, ‘Bukon lang sa pagkaon nabubuhì ang tawo, kundì sa kada hambay ng Dios.’ ” ");
INSERT INTO rol_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Pagkatapos gingdaya si Hesus ng diyablo sa balaan nga syudad, kag gingpatindog siya sa pinakamataas nga parte ng templo. ");
INSERT INTO rol_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Kag hambay niya, “Kung ikaw ang Ungà ng Dios, maglumpat ka. Kay ginahambay ng Kasulatan, ‘Susuguon ng Dios ang iya mga anghel nga magbantay sa imo kag hahawiran ka ninda ng inda mga kamot, para indì mabunggò ang imo siki sa bato.’ ” ");
INSERT INTO rol_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Pero naghambay si Hesus, “Nagahambay da ang Kasulatan, ‘Ayaw pagtintara ang Ginoo nga imo Dios.’ ” ");
INSERT INTO rol_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Pagkatapos gingdaya siya ng diyablo sa mataas gid nga bukid kag gingpakità sa iya ang tanan nga gingharian ng kalibutan kag ang inda manggad. ");
INSERT INTO rol_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Naghambay si Satanas sa iya, “Ini tanan itatao ko sa imo, kung maghapà ka kag magsamba sa akon.” ");
INSERT INTO rol_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Tapos naghambay si Hesus, “Lumayas ka, Satanas! Kay ginahambay ng Kasulatan, ‘Sambahon mo ang Ginoo nga imo Dios kag siya lang gid ang imo serbisyuhan.’ ” ");
INSERT INTO rol_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Pagkatapos adto, gingbayaan siya ng diyablo. Kag nag-abot ang mga anghel kag gingserbisyuhan siya. ");
INSERT INTO rol_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Niyan, nang mabatian ni Hesus nga napriso si Juan nga Miyugbawtismo, nagbalik siya sa Galilea. ");
INSERT INTO rol_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pero wayà na siya nagaistar sa Nazaret kundì didto na sa banwa ng Capernaum*. Ini nga banwa hay sa alihid ng Lawà ng Galilea* nga sakop ng lugar ng mga tribo ni Zebulun kag ni Naftali. ");
INSERT INTO rol_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Natabò ini para matuman ang gingpropesiya ni Propeta Isaias: ");
INSERT INTO rol_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ang mga dutà nga panublion ng mga tribo ni Zebulun kag ni Naftali, hay malapit sa dagat kag yadto sa kabuak ng Subà ng Jordan. Ini nga mga lugar hay sakop ng Galilea kag ginaistaran ng mga bukon Judio*. ");
INSERT INTO rol_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Pero aber ang mga tawo sa ini nga mga lugar hay yarà sa maduyom, makakakità na sinda ng kahayag. Kag ang yarà sa maduyom nga nahahadlok sa kamatayon, mahahayagan na sinda.” ");
INSERT INTO rol_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nang yadto nagaistar si Hesus sa Galilea, nagtunà na siya magwali. Hambay niya, “Talikuri nindo ang indo mga kasal-anan, kay malapit na ang paghaharì ng Dios.” ");
INSERT INTO rol_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Nang nagapanaw si Hesus sa alihid ng Lawà ng Galilea, nakità niya didto ang duha ka magmanghod nga sina Simon kag Andres nga nagataktak ng pukot kay sinda hay miyugpangisdà. Si Simon hay ginatawag da nga Pedro. ");
INSERT INTO rol_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Naghambay si Hesus sa inda, “Nunot kamo sa akon kay tudluan ta kamo sa pagpangisdà ng mga tawo.” ");
INSERT INTO rol_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Adto nga daan gingbayaan ninda ang inda mga pukot kag nagnunot sa iya. ");
INSERT INTO rol_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Mintras nagapadayon pa si Hesus sa pagpanaw, nakità niya ang duha ka magmanghod nga sina Santiago* kag Juan nga mga ungà ni Zebedee. Sinda hay yadto sa dyapang* nga nagahukot ng inda mga pukot kaibahan ng inda tatay. Ging-agda sinda ni Hesus, ");
INSERT INTO rol_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","kag adto nga daan gingbayaan ninda ang dyapang kag ang inda tatay kag nagnunot sinda sa iya. ");
INSERT INTO rol_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Niyan naglibot si Hesus sa bilog nga Galilea para magtudlò sa inda mga sinagoga*, magwali ng Maayong Balità* parti sa paghaharì ng Dios kag magpang-ayo ng tanan nga klasi ng sakit sa mga tawo. ");
INSERT INTO rol_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Naging bantog siya sa bilog nga Syria, nganì gingdaya sa iya ng mga tawo ang tanan nga may sarisarì nga sakit, ang mga ginasapian ng demonyo, ang mga may epilepsi kag ang mga paralisado. Gingpang-ayo sinda tanan ni Hesus. ");
INSERT INTO rol_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nganì nagsunod kay Hesus ang kadamò nga tawo halin sa Galilea, Decapolis, Jerusalem, Judea kag sa mga lugar sa kabuak ng Subà ng Jordan. ");
INSERT INTO rol_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Nang makità ni Hesus ang kadamò nga tawo, nagtukad siya sa bukid. Pagkapungkò niya, nagpalapit sa iya ang mga disipulo, ");
INSERT INTO rol_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","kag gingtudluan niya sinda. Hambay niya: ");
INSERT INTO rol_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Bulahan ang mga tawo nga nagakilaya nga maluya ang inda pagtuo; kay makapasakop sinda sa paghaharì ng Dios. ");
INSERT INTO rol_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Bulahan ang mga tawo nga nagakalisod sa kasal-anan; kay pagalipayon sinda ng Dios. ");
INSERT INTO rol_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Bulahan ang mga tawo nga mapainubuson; kay sinda ang magapanublì ng kalibutan. ");
INSERT INTO rol_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Bulahan ang mga tawo nga daw ginagutom kag ginauhaw nga maghuman ng kabubut-on ng Dios; kay buligan sinda ng Dios sa pagtuman ng inda ginahandom. ");
INSERT INTO rol_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Bulahan ang mga tawo nga maluluy-on; kay kaluy-an sinda ng Dios. ");
INSERT INTO rol_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Bulahan ang mga tawo nga malimpyo ang inda tagipusuon; kay makikità ninda ang Dios. ");
INSERT INTO rol_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Bulahan ang mga tawo nga nagabulig para magaayo ang relasyon ng isa kag isa; kay pagakabigon sinda nga mga ungà ng Dios. ");
INSERT INTO rol_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Bulahan ang mga tawo nga ginahingabot tungod sa inda pagsunod sa kabubut-on ng Dios; kay makapasakop sinda sa paghaharì ng Dios. ");
INSERT INTO rol_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Bulahan kamo kung insultuhon kamo ng mga tawo, pasakitan kag akusahan ning tanan nga kalainan nga bukon matuod, tungod sa indo pagsunod sa akon. ");
INSERT INTO rol_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Imaw da ini ang inda ginghuman sa mga propeta nang una. Nganì magkalipay gid kamo kay mababaton nindo ang kadakò gid nga premyo sa langit.” ");
INSERT INTO rol_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Kamo nga nagasunod sa akon hay pareho ng asin sa kalibutan. Pero kung maduyà na ang sabor ng asin, pauno pa mapabalik ang iya kaasin? Nganì indì na ini mapuslan kundì ginapilak na lang kag ginatimak-timakan ng mga tawo. ");
INSERT INTO rol_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Pareho kamo ng iwag nga nagatao ning kahayag sa mga tawo sa kalibutan. Kag ini hay makikità gid pareho sa syudad nga gingpatindog sa ibabaw ng bukid nga indì matagò. ");
INSERT INTO rol_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Wayà ning tawo nga nagasugà ning iwagan kag ginatakyuban, kundì ginabutang niya ini sa tungtungan para mahayagan ang tanan sa suyod ng bayay. ");
INSERT INTO rol_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nganì imaw da ang indo humanon. Pasigaha nindo ang indo iwag sa mga tawo, para makità ninda ang indo maayo nga mga ginahuman kag para dayawon ninda ang indo Amay sa langit.” ");
INSERT INTO rol_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ayaw kamo maghunahunà nga nagkari ako diri para duyaon ang Kasuguan kag ang mga gingsulat ng mga propeta. Nagkari ako diri para tumanon ini. ");
INSERT INTO rol_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Sa matuod lang ginahambay ko sa indo, maduduyà ang langit kag dutà, pero ang aber pinakamaisot nga litra o parte ng litra sa Kasuguan hay indì gid maduduyà mintras wayà ini natatabò. ");
INSERT INTO rol_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Nganì ang aber sin-o nga magsuway sa pinakamaisot nga sugò ng Dios kag magtudlò sa iban nga magsuway da, siya ang kabigon nga pinakamababà sa gingharian ng Dios. Pero ang aber sin-o nga magtuman diri kag magtudlò sa iban, siya ang kabigon nga importante sa gingharian ng Dios. ");
INSERT INTO rol_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nganì ginahambay ko sa indo, dapat gid nga ang indo pagtuman sa kabubut-on ng Dios hay mas maayo pa gid kaysa sa mga eskriba kag sa mga Pariseo. Kay kung indì, indì gid kamo makasuyod sa gingharian ng Dios.” ");
INSERT INTO rol_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Nabatian nindo ang ginghambay sa aton mga kalulo-lulohan, ‘Ayaw magpamatay, kay ang aber sin-o nga magpatay hay pagaparusahan.’ ");
INSERT INTO rol_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pero niyan ginahambay ko sa indo, ang aber sin-o nga nahahangit sa iya utod hay pagaparusahan. Kag ang aber sin-o nga nagainsulto sa iya utod nga nagahambay, ‘Wayà ka ning puyos’, hay pagaday-on sa Korte. Kag ang aber sin-o nga maghambay sa iya utod, ‘Buang’, hay parusahan sa impyerno. ");
INSERT INTO rol_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Nganì kung yarà ka na sa altar* nga nagadaya ng imo halad sa Dios kag nadumduman mo nga ang imo utod may malain nga buot sa imo tungod nga nakasalà ka sa iya, ");
INSERT INTO rol_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ibilin mo anay ang imo halad malapit sa altar kag kadtuon mo nga daan siya kag magpakighusay. Pagkatapos magbalik ka sa altar kag maghalad ka sa Dios.” ");
INSERT INTO rol_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Kung may mag-akusar sa imo, magpakighusay ka sa iya mintras wayà pa kamo makaabot sa korte. Kay basì kung itugyan ka niya sa husgado kag itugyan ka naman ng husgado sa gwardya para prisuhon ka. ");
INSERT INTO rol_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Sa matuod lang ginahambay ko sa imo, indì ka gid makaluwas sa prisuhan hasta indì mo mabayaran ang tanan nga bayaran.” ");
INSERT INTO rol_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Nabatian nindo ang ginghambay nang una, ‘Ayaw kamo magpangawatan.’ ");
INSERT INTO rol_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pero niyan ginahambay ko sa indo, kung ang lyaki magsirò sa babayi nga may lawasnon nga handom, nakasalà na siya ng pagpangawatan. ");
INSERT INTO rol_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nganì kung ang imo tuo nga mata ang kabangdanan nga nagakasalà ka, lukata inà kag ipilak. Kay mas maayo pa nga maduyà ang isa ka parte ng imo lawas kaysa sa kumpleto ini pero ipilak ka naman sa impyerno. ");
INSERT INTO rol_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kag kung ang imo tuo nga kamot ang kabangdanan nga nagakasalà ka, utura inà kag ipilak! Kay mas maayo pa nga maduyà ang isa ka parte ng imo lawas kaysa sa kumpleto ini pero ipilak ka naman sa impyerno.” ");
INSERT INTO rol_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ginghambay da nang una, ‘Kung ang lyaki gusto magbuyag sa iya asawa, kahinangyan taw-an niya ini ning papeles bilang katibayan ng inda pagbinuyagan.’ ");
INSERT INTO rol_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pero niyan ginahambay ko sa indo, ang aber sin-o nga lyaki nga magbuyag sa iya asawa sa aber ano nga kabangdanan puyra lang sa pagpangawatan, siya mismo ang kabangdanan nga magpangawatan ang iya asawa kung mag-asawa siya liwat. Kag ang aber sin-o nga mag-asawa sa babayi nga gingbuyagan hay nagapangawatan da.” ");
INSERT INTO rol_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Nabatian da nindo nga may ginghambay nang una sa aton kalulo-lulohan, ‘Kung ang tawo may gingpangakò kag gingsumpaan pa niya sa pangayan ng Ginoo, kahinangyan gid niya ini tumanon.’ ");
INSERT INTO rol_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pero niyan ginahambay ko sa indo, kung magpangakò kamo ayaw kamo magsumpà. Ayaw kamo maghambay, ‘Testigo ko ang langit’ kay imaw ini ang trono ng Dios, ");
INSERT INTO rol_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","o ‘Testigo ko ang dutà’ kay imaw ini ang ginatungtungan ng iya siki. Ayaw da kamo maggamit ng pangayan ng Jerusalem sa indo pagsumpà kay imaw ini ang syudad ng pinakamataas nga Harì. ");
INSERT INTO rol_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kag ayaw da kamo maghambay, ‘Aber mamatay pa ako’ kay indì ka makapaputì o makapaitom ng aber isa nga buhok. ");
INSERT INTO rol_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Maghambay ka lang, ‘Huo’ kung huo kag ‘Indì’ kung indì. Kay kung magsumpà pa kamo halin na inà kay Satanas.” ");
INSERT INTO rol_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Nabatian nindo ang ginghambay nang una, ‘Ang maglukat ng mata ng iya isigkatawo hay lukaton da ang iya mata kag ang magbingaw ng ngipon ng iya isigkatawo hay pagabingawon da.’ ");
INSERT INTO rol_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pero niyan ginahambay ko sa indo, ayaw kamo magbayos ning malain sa nagahuman ning malain sa indo. Kung tampaon ka sa tuo nga pisngi, ipatampà mo pa ang kabuak. ");
INSERT INTO rol_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kung may magkiha sa imo kag buy-on ang imo kamisita, taw-an pa sa iya aber ang imo pangsuy-ob. ");
INSERT INTO rol_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kag kung may sundalo nga magpilit sa imo magpas-an ng iya daya ng isa ka kilometro, pas-ana ini ning duha ka kilometro. ");
INSERT INTO rol_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Taw-i ang nagapangayò sa imo; kag kung may manghuyam sa imo, pahuyama.” ");
INSERT INTO rol_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Nabatian nindo ang ginahambay nang una, ‘Higugmaon nindo ang indo isigkatawo kag hangiti ang indo kaaway.’ ");
INSERT INTO rol_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pero niyan ginahambay ko sa indo, higugmaon nindo ang indo mga kaaway kag ipangamuyò ang mga nagahingabot sa indo. ");
INSERT INTO rol_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Kag kung humanon nindo ini, magiging matuod kamo nga mga ungà ng indo Amay sa langit. Kay pareho kamo sa iya nga maayo ang pagtratar sa tanan. Kay ginapasilak niya ang adlaw sa mga maayo kag sa malain nga mga tawo. Kag ginapauyan niya bukon lang sa mga matarong kundì imaw da sa mga bukon matarong. ");
INSERT INTO rol_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kung ang ginahigugmà lang nindo hay ang nagahigugmà sa indo, mababaton ba nindo ang premyo halin sa Dios? Indì! Kay dì ba imaw da inà ang ginahuman ng miyugsukot ning buhis? ");
INSERT INTO rol_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kag kung ang ginalihok nindo hay ang indo lang mga amigo, ano ang kaibahan nindo sa iban? Dì ba imaw da inà ang ginahuman ng mga tawo nga wayà nagakilaya sa Dios? ");
INSERT INTO rol_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nganì dapat maayo ang indo pagtratar sa indo isigkatawo pareho ng ginahuman ng indo Amay sa langit.” ");
INSERT INTO rol_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Mag-andam kamo kay basì kung ang indo pagkadiosnanon hay pagpadayaw lang sa tawo. Kay kung tiyad inà ang indo ginahuman, wayà kamo ning may mababaton nga premyo halin sa indo Amay sa langit. ");
INSERT INTO rol_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Nganì kung nagabulig kamo, ayaw nindo pagpamalitaan pareho ng ginahuman ng mga hipokrito sa mga sinagoga kag sa mga dayan. Ginahuman ninda inà para dayawon sinda ng mga tawo. Sa matuod lang ginahambay ko sa indo, nabaton na ninda ang inda premyo. ");
INSERT INTO rol_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Pero kung nagabulig kamo, ayaw nindo pagpasayura aber sa indo pinakamalapit nga amigo, ");
INSERT INTO rol_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","para sikreto ang indo pagbulig. Kag ang indo Amay nga nakakakità sa indo ginahuman hay imaw ang magapremyo sa indo.” ");
INSERT INTO rol_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Kung magpangamuyò kamo, ayaw nindo pagpatuyari ang ginahuman ng mga hipokrito. Gusto ninda magpangamuyò nga nagatindog sa mga sinagoga kag sa mga kanto ng karsada para ipakità sa mga tawo nga sinda hay diosnanon. Sa matuod lang ginahambay ko sa indo, nabaton na ninda ang inda premyo. ");
INSERT INTO rol_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pero kung magpangamuyò kamo, magsuyod kamo sa kwarto kag sarhan ang pwertahan. Didto kamo magpangamuyò sa indo Amay ning sikreto. Kag ang indo Amay nga nakakità ng indo ginahuman imaw ang magapremyo sa indo. ");
INSERT INTO rol_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Kung magpangamuyò kamo, ayaw kamo maggamit ning kadamò-damò nga hambay nga wayà ning puyos. Imaw inà ang ginahuman ng mga tawo nga wayà nakakakilaya sa Dios. Kay ang kagasi ninda ginapamatian sinda ng Dios kung mahabà ang inda mga pangamuyò. ");
INSERT INTO rol_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ayaw kamo magpatuyad sa inda ginahuman. Kay sayod na ng indo Amay ang indo mga kahinangyanon bago pa kamo magpangayò. ");
INSERT INTO rol_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Nganì tiyad ini kung magpangamuyò kamo: ‘Amay namon nga yarà sa langit, kabay pa nga tahuron ang imo balaan nga pangayan. ");
INSERT INTO rol_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kabay pa nga magharì ka sa amon. Kag kabay nga matuman ang imo kabubut-on diri sa dutà pareho ng sa langit. ");
INSERT INTO rol_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Taw-i kami ng amon kahinangyanon nga pagkaon sa ini nga adlaw. ");
INSERT INTO rol_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Patawara kami sa amon mga salà, pareho ng pagpatawad namon sa mga nagkasalà sa amon. ");
INSERT INTO rol_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kag ayaw kami pagtuguti nga matintar, kundì luwasa kami kay Satanas.’ Kay ikaw ang Harì, ang makagagahom kag Dios nga ginadayaw ng mga tawo hasta sa wayà katapusan. Kabay pa. ");
INSERT INTO rol_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Kung ginapatawad nindo ang mga nagakasalà sa indo, pagapatawaron da kamo ng indo Amay sa langit. ");
INSERT INTO rol_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pero kung wayà kamo nagapatawad sa iban, indì da patawaron ang indo mga salà ng indo Amay.” ");
INSERT INTO rol_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Kung magpuasa kamo, ayaw nindo pagpatuyari ang mga hipokrito nga nagapadayaw lang nga malisod ang inda hitsura. Kay ginahungod ninda nga indì sinda mag-ayos para masayuran ng iban nga nagapuasa sinda. Sa matuod lang ginahambay ko sa indo, nabaton na ninda ang inda premyo. ");
INSERT INTO rol_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pero kung magpuasa kamo, magpanglam-os kamo kag mag-ayos, ");
INSERT INTO rol_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","para wayà ning may makasayod nga nagapuasa kamo puyra lang ang indo Amay nga indì makità. Kag siya nga nakakakità ng indo mga ginahuman nga sikreto, imaw ang magapremyo sa indo.” ");
INSERT INTO rol_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ayaw kamo magtipon ning manggad para sa indo kaugalingon diri sa dutà kay siraon ini ng itiit kag tuktuk. O kundì man hay sudlon ng mga miyugpangawat ang indo bayay kag kawaton ini. ");
INSERT INTO rol_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kundì, magtipon kamo ng indo manggad sa langit, kay didto wayà ning itiit kag tuktuk nga makasirà kag wayà da ning miyugpangawat nga makasuyod. ");
INSERT INTO rol_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kay kung sa diin ang indo manggad, yadto da ang indo tagipusuon.” ");
INSERT INTO rol_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ang mata hay daw iwag nga nagatao ning kahayag sa lawas. Nganì kung mahayag ang indo mata, mahayagan gid ang indo bilog nga lawas. ");
INSERT INTO rol_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pero kung maduyom ang indo mata maduyuman da ang indo bilog nga lawas. Nganì kung ang iwag nga yarà sa indo, wayà na nagatao ning kahayag, magiging kaduyom-duyom gid ang indo kamutangan.” ");
INSERT INTO rol_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Wayà ning tawo nga nagaserbisyo sa duha ka amo, kay hangitan niya ang isa kag higugmaon niya ang isa. O kundì hay magiging matutom siya sa isa kag baliwayaon niya ang isa. Indì kamo makaserbisyo ning dungan sa Dios kag sa manggad. ");
INSERT INTO rol_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Nganì ginahambay ko sa indo, ayaw kamo magkalibog kung pauno kamo mabuhì, kung ano ang indo kaunon o inumon kag kung ano ang indo isuksok. Kay ang kabuhì hay mas importante kaysa sa pagkaon kag ang lawas kaysa sa mga barò. ");
INSERT INTO rol_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Tan-awa nindo ang mga pispis nga nagalupad. Wayà sinda nagatanom, wayà nagaani kag wayà da nagatipon ning pagkaon sa kamalig, pero ginapakaon sinda ng indo Amay sa langit. Dì ba mas importante pa kamo kaysa sa mga pispis? ");
INSERT INTO rol_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Kag sin-o sa indo ang makadugang ning aber isa ka oras lang ng indo kabuhì paagi sa pagpangalibog? Wayà gid! ");
INSERT INTO rol_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Kag basì nagapangalibog kamo parti sa indo barò? Tan-awa ang mga buyak kung pauno sinda nagatubò sa bukid. Wayà sinda nagapangabudlay o nagatahì. ");
INSERT INTO rol_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pero ginahambay ko sa indo, aber si Haring Solomon nga bantog kag manggaranon hay wayà nakabarò ning mas maayo pa kaysa sa isa sa ini nga mga buyak. ");
INSERT INTO rol_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Kung ginabaruan ng Dios ang mga gunahon sa bukid nga buhì niyan pero sa masunod nga adlaw hay ginapilak lang sa kalayo, kamo pa arà indì niya pabaruan? Kaisot-isot ang indo pagtuo! ");
INSERT INTO rol_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Nganì ayaw kamo magpangalibog kung ano ang indo kaunon kag inumon kag kung ano ang indo isuksok. ");
INSERT INTO rol_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kay imaw ini ang ginapangalibugan ng mga tawo nga wayà nagakilaya sa Dios. Pero sayod ng indo Amay sa langit nga kahinangyan nindo inà tanan nga mga butang. ");
INSERT INTO rol_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Nganì unaha nindo ang pagpasakop sa paghaharì ng Dios kag tumana ang iya kabubut-on kag itatao gid niya sa indo ang tanan nindo nga mga kahinangyan. ");
INSERT INTO rol_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nganì ayaw kamo magkabayaka parti sa kung ano ang maabot buwas, kay ang buwas may kaugalingon nga kabayak-on. Tamà na ang mga kabayak-on nga nagaabot sa kada adlaw.” ");
INSERT INTO rol_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ayaw nindo paghusgahi ang iban para indì da kamo paghusgahan ng Dios. ");
INSERT INTO rol_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kay kung pauno kamo maghusga sa iban, imaw da ang paghusga ng Dios sa indo. Ang pangsukoy nga ginagamit nindo sa iban hay imaw da ang pangsukoy nga gagamiton sa indo. ");
INSERT INTO rol_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Basì nakikità mo gid ang puling sa mata ng imo isigkatawo, pero ikaw wayà mo makità ang daw mabahoy nga kahoy nga yarà sa imo mata? ");
INSERT INTO rol_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Basì nagahambay ka pa sa imo isigkatawo, ‘Abi, buy-on ko ang maisot nga puling sa imo mata,’ mintras ang yarà sa imo mata hay daw mabahoy nga kahoy? ");
INSERT INTO rol_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Hipokrito! Buy-on mo anay ang daw mabahoy nga kahoy sa imo mata para makakità ka ning maayo, agud mabubuoy mo ang maisot nga puling sa mata ng imo isigkatawo. ");
INSERT INTO rol_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Ayaw nindo pagpilakan sa mga ayam ang mga butang nga balaan. Kay basì kung balikan kamo kag kagton. Kag ayaw nindo pagpilakan ang indo mga perlas sa mga baboy, kay basì kung timak-timakan lang inà ninda.” ");
INSERT INTO rol_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Magpangayò kamo sa Dios, kag taw-an kamo. Magpangità kamo, kag makakità kamo. Magpanuktok kamo, kag buksan ang pwertahan para sa indo. ");
INSERT INTO rol_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kay ang tanan nga nagapangayò hay makakabaton; kag ang tanan nga nagapangità hay makakakità; kag ang tanan nga nagapanuktok hay pagabuksan. ");
INSERT INTO rol_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Kamo nga mga tatay, kung magpangayò ang indo ungà ning tinapay, taw-an ba nindo ning bato? ");
INSERT INTO rol_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Kung magpangayò siya ning isdà, taw-an ba nindo ning sawa? Syempre indì! ");
INSERT INTO rol_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kung kamo nganì nga malain hay antigo magtao ning mga maayo nga regalo sa indo mga ungà, mas lalò pa gid ang indo Amay sa langit itatao gid niya ang mga maayo sa mga nagapangayò sa iya! ");
INSERT INTO rol_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Nganì humana nindo sa indo isigkatawo kung ano ang gusto nindo nga humanon ninda sa indo. Kay imaw gid ini ang gusto hambayon ng Kasuguan ni Moises kag ng mga gingsulat ng mga propeta.” ");
INSERT INTO rol_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Magsuyod kamo sa makitid nga pwertahan, kay malapad ang pwertahan kag malupos ang dayan nga pakadto sa impyerno kag didto kadamò ang nagasuyod. ");
INSERT INTO rol_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pero makitid ang pwertahan kag mahugà ang dayan pakadto sa kabuhì nga wayà katapusan kag malakà lang ang nagaagi didto.” ");
INSERT INTO rol_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Mag-andam kamo sa bukon matuod nga mga propeta. Nagapalapit sinda sa indo nga daw mabuot nga karnero, pero ang matuod pareho sinda sa mapintas nga mga hayop. ");
INSERT INTO rol_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Makikilaya nindo sinda paagi sa inda mga hinimuan. Pareho sinda ng tanom nga tunukon nga wayà nagapamunga ning igos* o ubas*. ");
INSERT INTO rol_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ang maayo nga kahoy nagapamunga ning maayo. Pero ang malain nga kahoy nagapamunga ning malain. ");
INSERT INTO rol_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kay ang maayo nga kahoy indì makapamunga ning malain kag ang malain nga kahoy indì makapamunga ning maayo. ");
INSERT INTO rol_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ang kada kahoy nga wayà nagapamunga ning maayo hay uturon kag ipilak sa kalayo. ");
INSERT INTO rol_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nganì makikilaya nindo ang bukon matuod nga mga propeta paagi sa inda mga hinimuan.” ");
INSERT INTO rol_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Bukon tanan nga nagatawag sa akon, ‘Ginoo, Ginoo’ hay makakasuyod sa gingharian ng Dios. Ang mga tawo lang nga nagatuman sa kabubut-on ng akon Amay sa langit, imaw lang ang makakasuyod sa gingharian ng Dios. ");
INSERT INTO rol_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Sa adlaw ng paghusga kadamò ang magahambay sa akon, ‘Ginoo, Ginoo, dì ba sa imo pangayan nagpropesiya kami, nagpalayas ng mga demonyo kag naghuman ning kadamò nga milagro?’ ");
INSERT INTO rol_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pero hambayon ko sinda, ‘Wayà ko kamo nakikilaya. Palayò kamo sa akon, kamo nga mga nagahuman ning malain!’ ” ");
INSERT INTO rol_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Nganì ang aber sin-o nga nagapamatì kag nagatuman ng akon mga ginatudlò, pareho siya sa mayad nga tawo nga nag-ugdok ng iya bayay sa pundasyon nga bato. ");
INSERT INTO rol_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Kag nang mag-uyan ning kadakò kag magpamahà kag maghuyop ang makusog nga hangin sa bayay, wayà ini nagubà kay ging-ugdok ini sa pundasyon nga bato. ");
INSERT INTO rol_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pero ang aber sin-o nga nagapamatì ng akon mga ginatudlò pero wayà nagatuman, pareho siya sa tawo nga buroy nga nag-ugdok ng iya bayay sa baybay. ");
INSERT INTO rol_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Kag nang mag-uyan ning kadakò kag magpamahà kag maghuyop ang makusog nga hangin sa bayay, matumba ini kag magubà gid.” ");
INSERT INTO rol_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Pagkatapos ng paghambay ni Hesus, natingaya gid ang mga tawo sa iya pagpanudlò, ");
INSERT INTO rol_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","kay nagatudlò siya nga may otoridad kag bukon pareho ng inda mga eskriba. ");
INSERT INTO rol_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Pagkatapos nagtugbong si Hesus halin sa bukid kag kadamò-damò gid nga tawo ang nagsunod sa iya. ");
INSERT INTO rol_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","May isa ka tawo nga kitungon* ang nagpalapit sa iya. Nagluhod siya sa iya atubangan kag naghambay, “Ginoo, kung gusto mo, paayuhon mo ako sa akon sakit nga kitong.” ");
INSERT INTO rol_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ging-unat ni Hesus ang iya kamot kag ginghawiran ang tawo kag ginghambay niya, “Gusto ko. Mag-ayo ka!” Adto nga daan naduyà ang kitong kag nalimpyo siya. ");
INSERT INTO rol_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Pagkatapos naghambay si Hesus sa iya, “Ayaw gid magpamalità aber kanin-o, kundì magderitso ka sa parì kag magpasirò. Kag maghalad ka ng gingsugò ni Moises para magpamatuod sa mga tawo nga nalimpyo ka na.” ");
INSERT INTO rol_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Niyan, nang nagapasuyod si Hesus sa banwa ng Capernaum, gingsugat siya ng isa ka kapitan ng mga sundalo ng Roma. Nagpakitluoy siya nga ang hambay, ");
INSERT INTO rol_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Ginoo, ang akon suluguon may sakit didto sa bayay. Indì na siya makahukay kag ginahugaan na gid siya.” ");
INSERT INTO rol_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Naghambay si Hesus sa iya, “Sige, makadto ako kag ayuhon siya.” ");
INSERT INTO rol_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Pero nagsabat ang kapitan, “Ginoo, bukon ako angay nga magpasuyod sa imo sa akon bayay. Maghambay ka lang kag magaayo ang akon ulipon. ");
INSERT INTO rol_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kay ako hay sakop ng may mataas nga rangko kag igwa da mga sundalo nga nasasakupan ko. Kung nagasugò ako sa isa ‘Kadto didto,’ nagakadto siya kag sa isa, ‘Kari diri,’ nagapalapit siya kag kung nagasugò ako sa akon ulipon, ‘Humana ini,’ ginahuman niya.” ");
INSERT INTO rol_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nang mabatian ini ni Hesus, natingaya gid siya. Kag naghambay siya sa mga nagasunod sa iya, “Sa matuod lang ginahambay ko sa indo, wayà pa gid ako nakakità ning tawo aber diri sa Israel nga igwa ning pagtuo pareho ng ini nga bukon taga-Israel. ");
INSERT INTO rol_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nganì ginahambay ko ini sa indo: kadamò ang mga tawo halin sa iba-iba nga parte ng kalibutan ang magapungkò sa punsyon kaibahan nina Abraham, Isaac kag Jacob sa gingharian ng Dios. ");
INSERT INTO rol_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pero kadamò ang mga Judio nga imaw kuntà ang makakaibahan sa gingharian ng Dios ang palayason sa luwas, didto sa kaduyom kung sa diin magadinanguyngoy kag magapinagot ang inda ngipon.” ");
INSERT INTO rol_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Pagkatapos naghambay si Hesus sa kapitan, “Balik na sa indo. Matatabò ang imo ginatuuhan.” Kag adto gid nga oras, nag-ayo ang suluguon ng kapitan. ");
INSERT INTO rol_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Isa ka adlaw, nagkadto si Hesus sa bayay ni Pedro. Pag-abot niya didto, nakità niya nga ang panugangan nga babayi ni Pedro hay nagahigdà kay may sagnat. ");
INSERT INTO rol_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ginghawiran ni Hesus ang iya kamot kag nahuwasan siya sa iya sagnat. Nagbangon siya kag gingserbisyuhan si Hesus. ");
INSERT INTO rol_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nang manayumsom na, kadamò ang tawo nga ginasapian ng mga demonyo ang gingdaya kay Hesus. Sa isa lang ka hambay, gingpalayas niya ang malain nga mga espiritu kag gingpang-ayo niya ang tanan nga may sakit. ");
INSERT INTO rol_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ginghuman niya ini para matuman ang gingpropesiya ni Propeta Isaias, “Siya gid ang nagbuoy ng aton mga sakit kag nag-ayo ng aton mga ginapamatyagan.” ");
INSERT INTO rol_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Isa ka adlaw, nang makità ni Hesus ang kadamò nga tawo nga nagatipon palibot sa iya, gingsugò niya ang iya mga disipulo nga magtabok sa kabuak. ");
INSERT INTO rol_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Pero bago sinda naghalin, may nagpalapit kay Hesus nga eskriba kag naghambay, “Maestro, masunod ako sa imo aber diin ka magkadto.” ");
INSERT INTO rol_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Nagsabat si Hesus sa iya, “Ang mga singgayong hay may mga buhò nga ginaistaran kag ang mga pispis hay may mga pugad, pero ako nga Ungà ng Tawo* hay wayà gid ning bayay nga akon mapahuwayan.” ");
INSERT INTO rol_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","May isa naman ka disipulo ang naghambay, “Ginoo, mabalik anay ako kay ipalubong ko ang akon tatay.” ");
INSERT INTO rol_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Pero nagsabat si Hesus, “Magsunod ka sa akon kag pabay-i ang mga patay nga maglubong sa inda mga patay.” ");
INSERT INTO rol_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Pagkatapos nagsakay si Hesus sa dyapang kag nagsunod sa iya ang iya mga disipulo. ");
INSERT INTO rol_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Nang nagabyahe na sinda, gulpi lang nga nagkusog ang hangin sa lawod kag nagdagkò ang humbak hasta nga nagsuyod sa dyapang. Pero si Hesus hay nagakatuyog. ");
INSERT INTO rol_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Nganì gingpalapitan siya ng iya mga disipulo kag gingpukaw nga ang hambay, “Ginoo, tabangi kami! Malulunod na kita!” ");
INSERT INTO rol_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Naghambay si Hesus sa inda, “Basì nahadlok kamo? Kaisot ang indo pagtuo!” Pagkatapos nagbangon siya kag gingsabyaw niya nga magpara ang hangin kag humbak. Kag nagkalma gid. ");
INSERT INTO rol_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Natingaya gid ang mga disipulo kag naghambay sinda, “Sin-o gid baya ini? Aber ang hangin kag ang humbak nagatuman sa iya!” ");
INSERT INTO rol_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Pag-abot ninda sa kabuak, sa lugar ng mga Gadareno, gingsumpong si Hesus ng duha ka lyaki nga halin sa mga lubungan. Ining duha hay ginasapian ning mga demonyo. Kaisog gid sinda nganì nahadlok ang mga tawo nga mag-agi didto. ");
INSERT INTO rol_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Pagkakità ninda kay Hesus, nagsinggit sinda, “Ikaw nga Ungà ng Dios, ano ang imo labot sa amon? Nagkari ka ba diri para pahugaan kami aber bukon pa ang tamà nga oras?” ");
INSERT INTO rol_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Didto sa unahan may kadamò nga baboy nga nagapangibok. ");
INSERT INTO rol_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nagpakitluoy ang mga demonyo nga ang hambay, “Kung palayason mo kami, tuguti na lang kami nga magsuyod didto sa mga baboy.” ");
INSERT INTO rol_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Naghambay si Hesus, “Sige, kadto kamo!” Nganì nagpangluwas sinda kag nagpangsuyod sa mga baboy. Gulpi nga nagdinagusò ang tanan nga baboy sa pangpang hasta sa nagkahuyog sa dagat kag nagkalumos. ");
INSERT INTO rol_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nagdyagan ang mga miyug-alilà ng mga baboy sa banwa kag gingpinamalità ninda ang tanan nga natabò sa mga baboy kag sa duha ka lyaki nga ginasapian ng mga demonyo. ");
INSERT INTO rol_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Nganì ang tanan nga tawo sa banwa hay nagkadto kay Hesus. Nang makità ninda siya, nagpakitluoy sinda kay Hesus nga maghalin sa inda lugar. ");
INSERT INTO rol_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Pagkatapos nagsakay si Hesus kag ang iya mga kaibahan sa dyapang pabalik sa kabuak. Pag-abot ninda didto nagbalik si Hesus sa iya banwa. ");
INSERT INTO rol_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Nang yadto na siya, may nag-abot nga mga tawo nga ginabayawan ang isa ka paralisado sa banig. Nang makità ni Hesus ang inda pagtuo, naghambay siya sa paralisado, “Amigo, ayaw mahadlok, kay napatawad na ang imo mga salà.” ");
INSERT INTO rol_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Nang mabatian ini ng mga eskriba, naghambay sinda sa inda kaugalingon, “Basì kung nagahambay siya hay daw kapareho gid niya ang Dios?” ");
INSERT INTO rol_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Pero nasayuran ni Hesus ang inda ginahunahunà, nganì nagpangutana siya sa inda, “Basì malain ang indo ginahunahunà? ");
INSERT INTO rol_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Diin baya ang mas malupos nga hambayon? ‘Napatawad na ang imo mga salà,’ o ‘Bangon kag pumanaw’! ");
INSERT INTO rol_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Niyan, pamatuuran ko sa indo nga ako nga Ungà ng Tawo hay may otoridad sa kalibutan nga magpatawad ng mga salà.” Tapos hambay niya sa paralisado, “Bangon, lukuta ang imo banig kag umulì na!” ");
INSERT INTO rol_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Kag nagtindog ang paralisado kag nag-ulì sa inda. ");
INSERT INTO rol_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nang makità ini ng kadamò nga tawo, hinadlukan gid sinda kag gingdayaw ninda ang Dios kay gingtao niya sa mga tawo ang tiyad ini nga otoridad. ");
INSERT INTO rol_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Nang nagapanaw na si Hesus halin didto, nakità niya si Mateo nga nagapungkò sa ginabayaran ning buhis. Naghambay si Hesus sa iya, “Magsunod ka sa akon.” Nagtindog siya kag nagsunod kay Hesus. ");
INSERT INTO rol_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Niyan, mintras nagakaon si Hesus kag ang iya mga disipulo sa bayay ni Mateo, kadamò ang miyugsukot ning buhis kag iban pa nga ginakabig nga mga makasasalà ang nag-abot kag nagdungan sa inda pagkaon. ");
INSERT INTO rol_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nakità ini ng mga Pariseo kag nagpangutana sinda sa iya mga disipulo, “Basì nagakaon ang indo maestro kaibahan ang mga miyugsukot ning buhis kag mga makasasalà?” ");
INSERT INTO rol_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Nabatian ini ni Hesus kag gingsabat niya sinda, “Wayà nagakahinangyan ning doktor ang mga tawo nga maayo ang lawas, kundì ang mga may sakit lang. ");
INSERT INTO rol_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Isipa nindo ning maayo kung ano ang gusto hambayon ng ining ginahambay ng Kasulatan, ‘Bukon ang indo mga halad ang akon gusto, kundì ang kaluoy sa indo isigkatawo.’ Wayà ako nagkari diri para pagatawagon ang mga nakakasayod nga sinda hay matarong, kundì ang mga makasasalà.” ");
INSERT INTO rol_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","May mga disipulo si Juan nga Miyugbawtismo nga nagpalapit kay Hesus kag nagpangutana, “Kami kag ang mga Pariseo hay permi nagapuasa, pero basì ang imo mga disipulo hay wayà?” ");
INSERT INTO rol_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Nagsabat si Hesus sa inda, “Puydi ba nga magkalisod ang mga bisita sa kasay* mintras kaibahan pa ninda ang kyasayon nga lyaki? Syempre indì! Pero magaabot ang adlaw, pag buy-on ang kyasayon nga lyaki sa inda, imaw na inà ang inda pagpuasa.” ");
INSERT INTO rol_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Naghambay pa gid si Hesus, “Wayà ning tawo nga nagahakyop ning bag-o nga tela sa lumà nga barò, kay magigisì ang lumà nga barò kag magapakabahoy pa ang gisì. ");
INSERT INTO rol_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Wayà da ning tawo nga nagabutang ning bag-o nga ilimnon sa lumà nga butangan nga panit ng hayop, kay malupok ang butangan kag mauuyak ang ilimnon kag masisirà ang butangan. Pero ang bag-o nga ilimnon dapat ibutang sa bag-o nga butangan nga panit, para ining duha hay magadugay.” ");
INSERT INTO rol_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Mintras nagahambay pa si Hesus, nag-abot ang isa ka opisyal ng sinagoga. Nagluhod siya sa atubangan ni Hesus kag nagpakitluoy nga naghambay, “Ang akon ungà nga babayi hay bag-o lang gid namatay, pero kung magkadto ka kag itungtong mo ang imo kamot sa iya, mabubuhì siya liwat.” ");
INSERT INTO rol_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Nganì nagtindog si Hesus kag nagnunot sa iya, kaibahan da ang iya mga disipulo. ");
INSERT INTO rol_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mintras nagapanaw sinda, may babayi nga nagpalapit sa likod ni Hesus. Ini nga babayi hay ginadinugò sa suyod ng dose ka tuig. Gingtandog niya ang gayad ng barò ni Hesus, ");
INSERT INTO rol_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","kay nagahunahunà siya sa iya kaugalingon, “Kung matandog ko lang ang barò niya magaayo gid ako.” ");
INSERT INTO rol_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Naglingig si Hesus kag pagkakità niya sa babayi naghambay siya, “Manang, pakusuga ang imo buot, nag-ayo ka tungod sa imo pagtuo.” Adto nga daan, nag-ayo siya. ");
INSERT INTO rol_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Pag-abot ni Hesus sa bayay ng opisyal, nakità niya ang mga musikero para sa lubong kag ang mga tawo nga nagakinagulo. ");
INSERT INTO rol_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Nganì naghambay siya sa mga tawo, “Luwas anay kamo! Kay ining dalagita hay bukon patay kundì nagakatuyog lang.” Gingngitlan ninda si Hesus. ");
INSERT INTO rol_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Nang nagluwas na ang mga tawo, nagsuyod si Hesus sa kwarto. Ginghawiran niya ang kamot kag nagbangon ini. ");
INSERT INTO rol_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Kag ang balità parti diri hay nagkayat sa tanan nga banwa. ");
INSERT INTO rol_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Paghalin ni Hesus sa adto nga lugar, may duha ka buta ang nagsunod sa iya nga nagasinggit, “Inapo ni David, kaluy-i kami!” ");
INSERT INTO rol_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Pag-abot ni Hesus sa bayay nga iya ginadayunan, nagpalapit ang duha ka buta. Gingpangutana sinda ni Hesus, “Nagatuo ba kamo nga kaya ko kamo ayuhon?” Nagsabat sinda, “Huo, Ginoo, nagatuo kami.” ");
INSERT INTO rol_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Pagkatapos gingtandog ni Hesus ang inda mga mata kag naghambay, “Matabò gid ini tungod sa indo pagtuo.” ");
INSERT INTO rol_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Kag nag-ayo ang inda mata kag nakakità na sinda. Gingsugò sinda ni Hesus nga indì gid magbalità aber kanin-o. ");
INSERT INTO rol_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pero nagpanaw sinda kag gingpinamalità ninda sa bilog nga lugar kung ano ang ginghuman ni Hesus sa inda. ");
INSERT INTO rol_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Mintras nagahalin na ang duha, may gingdaya kay Hesus nga apà kay ginasapian siya ning demonyo. ");
INSERT INTO rol_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kag nang napalayas na ni Hesus ang demonyo, nakahambay na ang apà. Natingaya ang kadamò nga tawo didto kag naghambay sinda, “Wayà pa gid ning may nakakità nga tiyad ini sa bilog nga Israel!” ");
INSERT INTO rol_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pero naghambay ang mga Pariseo, “Paagi sa gahom ng pinunò ng mga demonyo ginapalayas niya ang mga demonyo.” ");
INSERT INTO rol_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Naglibot si Hesus sa mga banwa kag mga baryo kag nagtudlò sa inda mga sinagoga. Gingwali niya ang Maayong Balità parti sa paghaharì ng Dios kag gingpang-ayo niya ang mga tawo sa tanan ninda nga mga sakit. ");
INSERT INTO rol_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nang makità niya ang kadamò nga tawo, naluoy gid siya sa inda kay ginahugaan gid sinda pero wayà ning may nagabulig. Daw pareho sinda sa mga karnero nga wayà ning pastor*. ");
INSERT INTO rol_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Nganì naghambay siya sa mga disipulo, “Kadakò-dakò ang anihon pero kalakà lang ang mga miyug-ani. ");
INSERT INTO rol_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Nganì magpangamuyò kamo sa Ginoo nga tag-iya ng anihon para suguon niya ang mga miyug-ani sa iya anihon.” ");
INSERT INTO rol_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Pagkatapos gingtawag ni Hesus ang iya dose nga disipulo kag gingtaw-an niya sinda ning otoridad para magpalayas ng malain nga mga espiritu. Gingtaw-an da niya sinda ning gahom para magpang-ayo ng aber ano nga klasi ng sakit. ");
INSERT INTO rol_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Imaw ini ang pangayan ng dose ka apostoles: si Simon (nga ginatawag Pedro), si Andres nga iya manghod, si Santiago kag si Juan nga mga ungà ni Zebedee, ");
INSERT INTO rol_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","si Felipe, si Bartolome, si Tomas kag si Mateo (nga miyugsukot ning buhis), si Santiago nga ungà ni Alfeus, si Tadeus, ");
INSERT INTO rol_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","si Simon nga dati hay nagrebelde sa gobyerno ng Roma kag si Judas Iscariote nga imaw ang nagtraidor kay Hesus. ");
INSERT INTO rol_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Bago gingpapanaw ni Hesus ang dose nga apostoles, gingsugò niya sinda, “Ayaw kamo magkadto sa mga lugar ng mga bukon Judio o sa mga banwa ng mga taga-Samaria, ");
INSERT INTO rol_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","kundì magkadto kamo sa mga inapo ni Israel. Pareho sinda sa karnero nga nagtayang. ");
INSERT INTO rol_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ibalità sa inda nga malapit na mag-abot ang paghaharì ng Dios. ");
INSERT INTO rol_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ayuha ang mga may sakit, buhia liwat ang mga patay, ayuha ang mga tawo nga may sakit nga kitong kag palayasa ang mga demonyo. Nakabaton kamo ning gahom nga wayà nindo gingbayari, nganì magtao da kamo ning bulig nga wayà ning bayad. ");
INSERT INTO rol_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ayaw kamo magbayon ning kwarta, ");
INSERT INTO rol_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","o magdaya ning bag, o ilislan nga barò, o sandalyas, o sungkod, kay ang nagapangabudlay hay angay gid nga taw-an ng iya mga kahinangyanon. ");
INSERT INTO rol_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Kung magsuyod kamo sa isa ka banwa o sa isa ka baryo, magpangità kamo ning tawo nga may kalipay nga nagabaton sa indo. Kag didto kamo magdayon hasta maghalin kamo sa inda lugar. ");
INSERT INTO rol_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Sa indo pagsuyod sa bayay nga magabaton sa indo, bendisyuni nindo ang mga nagaistar didto. ");
INSERT INTO rol_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kung ginabaton gid kamo ng pamilya, magakaigwa gid sinda ning katawhayan* nga indo gingpangabay sa Dios. Pero kung indì, ang indo gingpangabay nga katawhayan hay magabalik sa indo. ");
INSERT INTO rol_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kung may mga panimayay o banwa nga indì gid magbaton sa indo kag indì gid magpamatì, bayai nindo sinda. Paghalin nindo, pagpaga ang dapodapo sa indo siki. ");
INSERT INTO rol_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Sa matuod lang ginahambay ko sa indo, ang inda parusa sa adlaw ng paghusga hay mas sobra kaysa sa parusa nga nabaton ng mga taga-Sodom kag mga taga-Gomora.” ");
INSERT INTO rol_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Tandai nindo ini! Pareho kamo sa mga karnero nga akon ginasugò sa mapintas nga mga hayop. Nganì maging mayad kamo pareho ng mga sawa, o pareho ng mga salampati nga ignorante kung parti sa paghuman ng malain. ");
INSERT INTO rol_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mag-andam kamo sa mga tawo, kay dakpon ninda kamo kag itugyan sa mga husgado kag latiguhon ninda kamo sa inda mga sinagoga. ");
INSERT INTO rol_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Day-on ninda kamo sa mga gobernador kag mga harì tungod sa indo pagtuman sa akon kag didto magapamatuod kamo sa inda kag sa mga bukon Judio parti sa akon. ");
INSERT INTO rol_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kung itugyan na kamo para imbistigahan, ayaw kamo magkabayaka kung pauno kamo magsabat o ano ang indo ihambay. Kay sa adto gid nga oras, ang Espiritu Santo imaw ang matudlò sa indo kung ano ang indo isabat. ");
INSERT INTO rol_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kay bukon kamo ang magahambay kundì ang Espiritu ng indo Amay. Siya ang magahambay paagi sa indo.” ");
INSERT INTO rol_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Sa adto nga tyempo, may mga tawo nga ipapatay ang inda mga maguyáng kag manghod. May mga tatay nga ipapatay ang inda ungà. Kag may mga ungà nga magabatò sa inda mga ginikanan kag ipapatay sinda. ");
INSERT INTO rol_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Mahahangit gid sa indo ang tanan nga tawo tungod sa indo pagtuman sa akon. Pero ang nagatiis nga magtuman sa akon hasta sa katapusan imaw ang maluwas. ");
INSERT INTO rol_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kung hingabuton kamo sa isa ka banwa, maglikaw kamo kag magkadto sa iban nga banwa. Kay sa matuod lang ginahambay ko sa indo, wayà pa nindo nakakadtui ang tanan nga banwa ng Israel, mabalik na ako nga Ungà ng Tawo. ");
INSERT INTO rol_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Wayà ning disipulo nga mas labaw kaysa sa iya maestro kag wayà ning ulipon nga mas mataas kaysa sa iya amo. ");
INSERT INTO rol_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nganì tamà lang sa disipulo nga maging pareho sa iya maestro kag sa ulipon nga maging pareho sa iya amo. Kung ako nga nagapamunò sa indo ginatawag ninda nga Satanas mas malain pa gid ang inda itawag sa indo nga akon mga disipulo.” ");
INSERT INTO rol_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Nganì ayaw kamo mahadlok sa mga tawo. Kay wayà ning may ginatagò nga indì makikità kag wayà ning sikreto nga indì masasayuran. ");
INSERT INTO rol_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ang aber ano nga ginahambay ko sa indo sa kaduyom, ihambay nindo sa tanan. Kag ang aber ano nga akon ginahutik sa indo, isinggit nindo sa lugar nga kadamò ang makakabatì. ");
INSERT INTO rol_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ayaw kamo mahadlok sa mga tawo nga makapatay ng indo lawas pero indì makapatay sa indo kalag. Ang Dios lang ang dapat nindo kahadlukan, kay siya ang magaparusa ng indo lawas kag ng indo kalag sa impyerno. ");
INSERT INTO rol_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Dì ba ginabaligyà ang duha ka maya sa barato lang nga kantidad? Pero wayà ning aber isa sa inda nga nahuhuyog sa dutà nga bukon pagbuot ng indo Amay. ");
INSERT INTO rol_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Mas lalò na kamo, kay aber pa ang indo buhok sa uyo hay sayod niya kung pila ka bilog. ");
INSERT INTO rol_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Nganì ayaw kamo mahadlok, kay kamo hay mas importante kaysa sa madamò nga pispis nga maya.” ");
INSERT INTO rol_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Ang aber sin-o nga nagakilaya sa akon sa atubangan ng mga tawo nga ako ang iya Ginoo, kilayahon ko da siya sa atubangan ng akon Amay sa langit. ");
INSERT INTO rol_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pero ang aber sin-o nga wayà nagakilaya sa akon sa atubangan ng mga tawo, indì ko da siya kilayahon sa atubangan ng akon Amay sa langit.” ");
INSERT INTO rol_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ayaw kamo maghunahunà nga nagkari ako sa kalibutan para magtao ning katawhayan sa mga tawo. Nagkari ako diri para paawayon sinda. ");
INSERT INTO rol_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Tungod sa akon, magakontra ang mga ungà nga lyaki sa inda mga tatay, ang mga ungà nga babayi sa inda mga nanay kag ang mga umagad nga babayi sa inda mga panugangan nga babayi. ");
INSERT INTO rol_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ang magiging kalaban nindo imaw mismo ang indo kaugalingon nga mga pamilya. ");
INSERT INTO rol_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Pero ang aber sin-o nga mas nagahigugmà sa iya tatay o nanay kaysa sa akon, indì angay nga maging disipulo ko. Kag ang aber sin-o nga mas nagahigugmà sa iya mga ungà kaysa sa akon, indì angay nga maging disipulo ko. ");
INSERT INTO rol_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ang aber sin-o nga indì magpas-an ng iya krus kag magsunod sa akon, indì siya angay nga maging disipulo ko. ");
INSERT INTO rol_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ang nagapalabi ng iya kabuhì hay maduduyaan ini; pero ang nagahalad ng iya kabuhì tungod sa akon, makakabaton siya ning kabuhì nga wayà katapusan.” ");
INSERT INTO rol_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ang nagabaton sa indo hay nagabaton sa akon; kag ang nagabaton sa akon nagabaton da sa nagsugò sa akon. ");
INSERT INTO rol_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ang aber sin-o nga nagabaton sa propeta* tungod siya hay propeta, magabaton ning premyo halin sa Dios pareho ng pagabatunon ng propeta. Kag ang aber sin-o nga nagabaton sa matarong nga tawo tungod siya hay matarong, magabaton ng premyo halin sa Dios pareho ng pagabatunon ng matarong. ");
INSERT INTO rol_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kag ang aber sin-o nga magatao ning aber isa lang ka baso nga tubì sa isa sa akon pinakamababà nga disipulo tungod siya hay akon disipulo, inà nga tawo magabaton gid ning premyo.” ");
INSERT INTO rol_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Pagkatapos tugon ni Hesus sa iya dose nga disipulo, nagkadto siya sa palibot nga mga banwa para magtudlò kag magwali sa mga tawo didto. ");
INSERT INTO rol_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Nang yadto pa si Juan nga Miyugbawtismo sa prisuhan, nabatian niya ang parti sa mga ginahuman ni Kristo. Nganì gingpakadto niya kay Kristo ang iya mga disipulo para mangutana. ");
INSERT INTO rol_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Kag nagpangutana sinda kay Hesus, “Balitai kami, ikaw ba ang amon ginapaabot o mahuyat pa kami sa iban?” ");
INSERT INTO rol_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Nagsabat si Hesus, “Magbalik kamo kay Juan kag balitai siya ng indo nakità kag nabatian. ");
INSERT INTO rol_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Hambaya nindo siya nga ang mga buta nakakità, ang mga pakì nakapanaw, ang mga may sakit nga kitong nag-ayo, ang mga bungoy nakabatì, ang mga patay nabanhaw kag ang Maayong Balità ginawali sa mga pobre. ");
INSERT INTO rol_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Bulahan ang mga tawo nga wayà nagaduha-duha sa akon.” ");
INSERT INTO rol_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nang nagpanaw na ang mga disipulo ni Juan, nagpangutana si Hesus sa mga tawo, “Sa indo pagkadto kay Juan sa tiway nga lugar, ano ang indo ginaasahan nga makità? Nagkadto ba kamo didto para makità ang tawo nga pareho sa kugon nga ginahapay-hapay pag ginahuyop ng hangin? ");
INSERT INTO rol_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","O para makità nindo ang tawo nga nakasuksok ning mamahayon nga barò? Pero ang nagasuksok ning mamahayon nagaistar sa mga palasyo. ");
INSERT INTO rol_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Abi isipon nindo, basì nagkadto kamo didto? Dì ba para makità ang propeta? Huo kag ginahambay ko sa indo, mas sobra pa gid siya kaysa sa propeta. ");
INSERT INTO rol_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Kay siya imaw ang ginahambay ng Dios sa Kasulatan, ‘Ipapadaya ko ang akon mensahero nga mauna sa imo para magpreparar ng dayan bago ang imo pag-abot.’ ” ");
INSERT INTO rol_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Naghambay pa gid si Hesus, “Sa matuod lang ginahambay ko sa indo, wayà ning aber sin-o nga natawo sa kalibutan nga mas labaw pa kaysa kay Juan nga Miyugbawtismo. Pero ang tawo nga pinakamababà sa gingharian ng Dios hay mas labaw pa kaysa kay Juan. ");
INSERT INTO rol_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tunà nang pagwali ni Juan hasta niyan, nagapamilit ang mga tawo nga magpasakop sinda sa paghaharì ng Dios. ");
INSERT INTO rol_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kay nang wayà pa nag-abot si Juan, gingtudlò ng tanan nga mga propeta kag ng Kasuguan ang parti sa paghaharì ng Dios. ");
INSERT INTO rol_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kag kung patihan nindo ang inda mga mensahe, si Juan imaw si Elias nga gingpropesiya nga magaabot. ");
INSERT INTO rol_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kamo nga nagapamatì, dapat intindihon gid nindo maayo ang indo nababatian. ");
INSERT INTO rol_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Niyan, sa diin ko baya ikumpara ang mga tawo sa ini nga henerasyon? Pareho kamo sa mga ungà nga nagapungkò sa plasa kag nagahambay sa isa kag isa, ");
INSERT INTO rol_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nagpasunata kami para sa kasay pero wayà kamo nagsaot; nagkanta kami para sa lamay ng patay pero wayà kamo nagtangis.’ ");
INSERT INTO rol_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Kamo nga mga tawo sa ini nga henerasyon hay pareho da sa inda, kay nang pag-abot ni Juan, nakità nindo nga nagapuasa siya kag wayà nagainom ning ilimnon, nganì nagahambay kamo nga ginasapian siya ng demonyo. ");
INSERT INTO rol_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nag-abot ako nga Ungà ng Tawo, nakità nindo nga nagakaon kag nagainom nganì nagahambay kamo, ‘Hala, sirua ang tawo nga ini! Makagod siya kag buratso kag amigo ng mga miyugsukot ning buhis kag iban pa nga makasasalà.’ Pero pabay-i lang, ang kabubut-on ng Dios hay ginapamatuuran sa kabuhì ng tawo nga nagabaton sa iya ginapanudlò paagi sa amon.” ");
INSERT INTO rol_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tapos naghambay si Hesus kontra sa mga nagaistar sa mga banwa kung sa diin naghuman siya ning kadamò nga milagro, tungod wayà sinda nagtalikod sa inda mga salà. ");
INSERT INTO rol_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Naghambay siya, “Makaluluoy kamo, mga taga-Corazin! Imaw da kamo, mga taga-Betsaida! Kay kung ang mga milagro nga akon ginghuman sa indo, ginghuman ko sa mga tawo sa Tyre kag Sidon, kadugay na kuntà sinda nagsuksok ning kustal kag nagbutang ning abo sa inda mga uyo para ipakità nga nagatalikod na sinda sa inda mga salà. ");
INSERT INTO rol_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Pero matuod ang akon hambay sa indo nga sa adlaw ng paghusga, ang parusa nga para sa indo sobra pa sa parusa nga para sa mga taga-Tyre kag taga-Sidon. ");
INSERT INTO rol_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kamo mga taga-Capernaum! Ang kalaom ba nindo pagadayawon gid kamo? Ihuhuyog gid kamo sa impyerno! Kadamò ang mga milagro nga akon ginghuman sa indo banwa, pero wayà kamo naghinuysoy. Kung sa Sodom ginghuman ko ini nga mga milagro, hay naghinuysoy na sinda kag yari pa kuntà sinda hasta niyan! ");
INSERT INTO rol_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nganì matuod ang akon hambay sa indo nga sa adlaw ng paghusga ng Dios, ang parusa nga indo mababaton hay mas sobra pa kaysa sa parusa nga para sa mga taga-Sodom.” ");
INSERT INTO rol_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Adto nga oras, nagpangamuyò si Hesus, “Amay nga Ginoo ng langit kag dutà, ginadayaw ko ikaw kay ang kamatuuran hay imo gingtagò sa mga tawo nga ang kalaom ninda hay kamayad sinda kag may tinun-an; kag imo ini gingpasayod sa mga mapainubuson pareho ng ungà nga kaisot. ");
INSERT INTO rol_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Amay, dayawon ka, kay imaw ini ang ginakalipay mo.” ");
INSERT INTO rol_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Pagkatapos adto, naghambay si Hesus sa mga tawo didto, “Gingtao na ang tanan sa akon ng akon Amay. Wayà ning may nakakakilaya sa akon nga iya Ungà kundì ang Amay; kag wayà ning may nakakakilaya sa Amay kundì ang iya Ungà kag ang mga tawo nga gingpilì ng Ungà nga maipakilaya ang Amay. ");
INSERT INTO rol_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Magpalapit kamo tanan sa akon, kamo nga ginabudlayan kag ginabug-atan kag papahuwayon ko kamo. ");
INSERT INTO rol_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Magtuman kamo sa akon mga sugò kag magpatudlò sa akon kay mabuot ako kag mapinaubuson. Magakaigwa kamo ning matawhay nga hunahunà, ");
INSERT INTO rol_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","kay ang akon mga sugò hay bukon mahugà nga sunuron kag ang akon ginapahuman hay bukon gid mabug-at.” ");
INSERT INTO rol_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Isa ka adlaw, nag-agi sina Hesus sa uma ng trigo kag adto hay Adlaw nga Inugpahuway*. Ginggutom ang iya mga disipulo kag nagpinamuksì sinda ning mga uhay ng trigo kag gingkukot ini. ");
INSERT INTO rol_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nang makità adto ng mga Pariseo*, naghambay sinda kay Hesus, “Tan-awa ang ginahuman ng imo mga disipulo! Ginahuman ninda ang ginabawal ng Kasuguan sa Adlaw nga Inugpahuway!” ");
INSERT INTO rol_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Nagsabat si Hesus sa inda, “Wayà ba nindo nabasahi sa Kasulatan ang ginghuman ni David nang siya kag ang iya mga kaibahan hay nagutom? ");
INSERT INTO rol_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Nagsuyod siya sa tolda ng Dios kag gingkaon niya kag ng iya mga kaibahan ang tinapay nga ginghalad sa Dios. Pero aber ginabawal ng Kasuguan nga kaunon adtong tinapay puyra lang ng mga parì, ang ginghuman nina David hay wayà gingkunsidera nga kasal-anan. ");
INSERT INTO rol_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","“Kag isa pa, wayà da ba nindo nabasahi sa mga gingsulat ni Moises nga ang mga parì mismo sa templo hay nagatrabaho sa Adlaw nga Inugpahuway? Pero wayà sinda nagakasalà. ");
INSERT INTO rol_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ginahambay ko sa indo, yari na niyan ang mas importante kaysa sa templo. ");
INSERT INTO rol_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ang ginahambay ng Kasulatan hay imaw ini: ‘Bukon ang indo mga halad ang akon gusto kundì ang indo kaluoy sa indo isigkatawo.’ Kung naintindihan gid nindo ini, wayà kuntà nindo paghusgahi ang mga tawo nga wayà ning salà. ");
INSERT INTO rol_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kay ako nga Ungà ng Tawo* hay may otoridad sa paghambay kung ano ang puydi nga humanon sa Adlaw nga Inugpahuway.” ");
INSERT INTO rol_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Pagkatapos, naghalin didto si Hesus kag nagkadto sa inda sinagoga. ");
INSERT INTO rol_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","May tawo didto nga paralisado ang iya kamot. Kag may mga Pariseo da didto nga nagapangità gid kung ano ang iakusar kay Hesus. Nganì nagpangutana sinda sa iya, “Ginatugot ba ng Kasuguan ang pag-ayo ng may sakit sa Adlaw nga Inugpahuway?” ");
INSERT INTO rol_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Nagsabat si Hesus, “Halimbawà, igwa kamo ning karnero nga nahuyog sa buhò sa Adlaw nga Inugpahuway. Ano, pabay-an lang ba nindo kay Adlaw nga Inugpahuway? Syempre indì! Hahaw-ason nindo ini nga daan. ");
INSERT INTO rol_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Pero ang tawo hay mas importante pa kaysa sa karnero. Nganì ginatugot ng Kasuguan kung nagahuman kita ning maayo sa mga tawo aber pa sa Adlaw nga Inugpahuway.” ");
INSERT INTO rol_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Pagkatapos naghambay si Hesus sa tawo nga paralisado, “Unata ang imo kamot.” Ging-unat niya ang kamot kag nag-ayo ini, pareho ng isa niya nga kamot. ");
INSERT INTO rol_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Pagkatapos nagluwas ang mga Pariseo kag nagplano sinda kung pauno ninda patyon si Hesus. ");
INSERT INTO rol_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Nang masayuran ni Hesus ang plano ng mga Pariseo, naghalin siya didto. Kadamò nga tawo ang nagsunod sa iya kag ging-ayo niya ang tanan nga mga may sakit. ");
INSERT INTO rol_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Gingbawalan niya sinda nga magpasayod sa iban kung sin-o siya. ");
INSERT INTO rol_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Natuman ang ginghambay ng Dios paagi kay Propeta Isaias: ");
INSERT INTO rol_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Imaw ini ang akon gingpilì nga miyugserbisyo. Pinalanggà ko gid siya kag nalilipay gid ako sa iya. Itatao ko sa iya ang akon Espiritu. Iwali niya sa tanan nga mga nasyon ang hustisya. ");
INSERT INTO rol_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Indì siya magpakigdiskusyon sa mga tawo o magsinggit, ang iya boses hay indì mababatian sa mga dayan. ");
INSERT INTO rol_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Indì niya pagpasakitan ang mga maluya sa pagtuo, o pagduyaon ang paglaom ng mga nagaduha-duha. Indì siya magpara hasta nga matuman gid ang kabubut-on ng Dios. ");
INSERT INTO rol_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kag ang mga tawo sa tanan nga nasyon hay magasalig sa iya.” ");
INSERT INTO rol_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Niyan may gingdaya kay Hesus nga tawo nga buta kag apà kay ginasapian siya ning demonyo. Ging-ayo siya ni Hesus, nganì nakahambay na siya kag nakakità. ");
INSERT INTO rol_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Natingaya ang tanan nga tawo didto kag naghambay sinda, “Siya ba ang inapo ni Haring David nga aton ginapaabot?” ");
INSERT INTO rol_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pero nang mabatian ini ng mga Pariseo, nagsabat sinda, “Bukon! Paagi sa gahom ni Beelzebul nga pinunò ng mga demonyo, gingpalayas niya ang mga demonyo.” ");
INSERT INTO rol_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Pero sayod ni Hesus ang inda ginahunahunà, nganì naghambay siya sa inda, “Kung ang mga pinunò ng isa ka gingharian hay mag-iniyaiya kag mag-ininaway, inà nga gingharian hay maduduyà. Imaw da ang matatabò sa aber ano nga banwa o pamilya kung ang inda mga sakop hay mag-iniyaiya kag mag-ininaway. ");
INSERT INTO rol_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Nganì kung nagapalayas si Satanas ng iya gingsakupan, pauno makapadayon ang iya gingharian? ");
INSERT INTO rol_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kung matuod nga si Satanas ang nagatao sa akon ning gahom para magpalayas ng mga demonyo, sin-o naman ang nagatao ning gahom sa indo mga tagasunod para magpalayas da ng demonyo? Sinda da ang nagapamatuod nga salà kamo! ");
INSERT INTO rol_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Sa matuod lang, ang Espiritu ng Dios ang nagatao sa akon ning gahom para palayason ang mga demonyo. Ini hay nagapamatuod nga ang paghaharì ng Dios hay nag-abot na sa indo. ");
INSERT INTO rol_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Wayà ning aber sin-o nga makasuyod sa bayay ng makusog nga tawo kag magpangawat ning mga butang kung indì anay niya gapuson adtong makusog nga tawo. Tapos makabuoy na siya ning mga pagkabutang sa adto nga bayay.” ");
INSERT INTO rol_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ang wayà nagaapin sa akon, kontra sa akon. Kag ang wayà nagabulig sa akon pagtipon sa mga tawo hay imaw ang kabangdanan ng pagkawatakwatak. ");
INSERT INTO rol_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Nganì ginahambay ko sa indo, ang aber ano nga salà, aber pa ang paghambay ning malain kontra sa Dios, mapapatawad. Pero ang paghambay ning malain kontra sa Espiritu Santo indì gid mapatawad. ");
INSERT INTO rol_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ang aber sin-o nga maghambay kontra sa akon nga Ungà ng Tawo hay mapapatawad; pero ang aber sin-o nga maghambay kontra sa Espiritu Santo indì gid mapatawad hasta san-o.” ");
INSERT INTO rol_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Kung maayo ang kahoy, maayo da ang bunga kag kung malain ang kahoy, malain da ang bunga. Nganì makikilaya ang kahoy sa iya bunga. ");
INSERT INTO rol_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Pareho kamo sa inapo ng mga sawa! Kag tungod malain kamo, pauno kamo makahambay ning maayo? Kay kung ano gid ang yarà sa hunahunà imaw da ang nagaluwas sa bàbà. ");
INSERT INTO rol_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ang maayo nga tawo nagahambay ning maayo kay maayo ang iya hunahunà. Pero ang malain nga tawo nagahambay ning malain kay malain ang iya hunahunà. ");
INSERT INTO rol_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Ginahambay ko sa indo, sa adlaw ng paghusga, ang kada isa magapanabat sa Dios sa iya mga ginahambay nga wayà ning puyos. ");
INSERT INTO rol_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kay dependi sa imo mga ginahambay kung parusahan ka o indì.” ");
INSERT INTO rol_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Niyan, may pila ka mga eskriba* kag mga Pariseo ang naghambay kay Hesus, “Maestro, pakitai kami ning milagro halin sa langit.” ");
INSERT INTO rol_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Pero gingsabat sinda ni Hesus, “Ang mga tawo sa ini nga henerasyon hay sobra gid nga kalain kag wayà na nagasunod sa kabubut-on ng Dios. Nagapangayò kamo ning milagro, pero wayà ning milagro nga ipakità sa indo puyra lang ang milagro nga natabò kay Propeta Jonas. ");
INSERT INTO rol_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kay pareho sa natabò kay Jonas nga tuyo ka adlaw kag tuyo ka gab-i sa tiyan ng isdà, imaw da ang matatabò sa akon nga Ungà ng Tawo kay magapabilin ako sa suyod ng tuyo ka adlaw kag tuyo ka gab-i sa idayom ng dutà. ");
INSERT INTO rol_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Sa adlaw ng paghusga, mababanhaw ang mga taga-Nineve kaibahan ng mga tawo sa ini nga henerasyon kag husgahan ninda kamo. Kay nang mabatian ninda ang gingwali ni Jonas, nagtalikod sinda sa inda mga salà. Niyan yari diri ang mas importante pa kay Jonas, pero wayà kamo nagabaton ng iya ginawali. ");
INSERT INTO rol_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Sa adlaw ng paghusga, mababanhaw da ang Rayna sa sur kaibahan nindo nga mga tawo sa ini nga henerasyon kag husgahan niya kamo. Kay nang una naghalin pa siya sa malayò gid nga lugar para magpamatì ng kamayad ni Haring Solomon. Niyan, yari diri ang mas importante kaysa kay Solomon, pero wayà kamo nagabaton ng iya ginatudlò!” ");
INSERT INTO rol_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Pag magluwas ang malain nga espiritu sa isa ka tawo nga iya ginasapian, nagalibot siya sa mga lugar nga wayà ning tubì kay nagapangità siya ning lugar nga iya mapahuwayan. Pero pag wayà siya ning may makità, ");
INSERT INTO rol_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","nganì mahambay siya, ‘Mabalik ako sa tawo nga akon dati ginghalinan.’ Kag pagbalik niya, makikità niya nga wayà ning may nagaistar, malimpyo kag maayo na ang tanan. ");
INSERT INTO rol_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tapos mapanaw siya kag madaya pa ning pito ka espiritu nga mas malain pa kaysa sa iya. Masuyod sinda sa adto nga tawo kag didto matinir. Kag ang kamutangan niya hay magiging mas sobra pa gid kaysa sa dati. Imaw da ini ang matatabò sa malain nga mga tawo sa ini nga henerasyon, indì kamo magpati sa akon ginapanudlò nganì ang indo sitwasyon hay magiging malain gid.” ");
INSERT INTO rol_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Mintras nagahambay pa si Hesus, nag-abot ang iya nanay kag mga manghod nga lyaki. Nagatindog sinda didto sa luwas kay may ihambay kuntà sinda sa iya. ");
INSERT INTO rol_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","May naghambay kay Hesus, “Yarà sa luwas ang imo nanay kag mga manghod. Gusto ninda magpakig-istorya sa imo.” ");
INSERT INTO rol_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Nagsabat si Hesus sa iya, “Sayod ba nindo kung sin-o ang akon nanay kag mga manghod?” ");
INSERT INTO rol_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Tapos gingtudlò niya ang iya mga disipulo kag naghambay, “Imaw ini ang akon nanay kag mga manghod! ");
INSERT INTO rol_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kay ang aber sin-o nga nagahuman ng kabubut-on ng akon Amay sa langit, imaw ang akon mga manghod kag nanay.” ");
INSERT INTO rol_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Adto da nga adlaw, nagluwas si Hesus sa bayay kag nagkadto sa alihid ng dagat kag nagpungkò didto. ");
INSERT INTO rol_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kadamò gid nga tawo ang nagpalibot sa iya, nganì nagsakay siya sa dyapang kag didto siya nagpungkò kag nagtudlò. Ang mga tawo naman hay yadto sa alihid ng dagat nga nagapamatì sa iya. ");
INSERT INTO rol_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Madamò ang iya gingtudlò sa inda paagi sa mga parabola*. Naghambay siya: “May isa ka mangunguma ang nagkadto sa iya uma para magsabwag ning mga binhì. ");
INSERT INTO rol_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Sa iya pagsabwag, ang iban nagtupà sa alihid ng dayan kag gingpantukà ini ng mga pispis. ");
INSERT INTO rol_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ang iban nga binhì nagtupà sa kabatuhan. Manipis lang ang dutà didto, nganì nagtubò nga daan ang mga binhì kay mababaw lang ang dutà. ");
INSERT INTO rol_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pero nalayà ini nang nainitan ng adlaw, kay matag-od lang ang gamot. ");
INSERT INTO rol_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ang iban nga binhì nagtupà kag nagtubò sa dutà nga may mga bayagon nga tunukon, pero paglabog ng mga bayagon gingkamangan ang tanom. ");
INSERT INTO rol_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ang iban pa gid nga binhì nagtupà sa maayo nga dutà, nagtubò ini kag nagpamunga. Ang iban hay kadamò-damò gid ang bunga, ang iban naman hay kadamò da kag ang iban hay tamà-tamà lang ");
INSERT INTO rol_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Dapat intindihon gid nindo maayo ang indo nababatian.” ");
INSERT INTO rol_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Pagkatapos nagpalapit kay Hesus ang mga disipulo kag nagpangutana, “Basì nagahambay ka sa mga tawo paagi sa mga parabola?” ");
INSERT INTO rol_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Nagsabat si Hesus sa inda, “Sa indo lang gingtao ng Dios ang pang-intindi ng mga sikreto parti sa iya paghaharì, pero wayà ginataw-an sa iban. ");
INSERT INTO rol_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kay ang tawo nga igwa ning nabaton nga kamatuuran, taw-an pa gid ning pang-intindi kag madamò pa ang idudugang sa iya. Pero ang tawo nga wayà ning nabaton nga kamatuuran, aber ang iya naintindihan hay buy-on pa sa iya. ");
INSERT INTO rol_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nganì nagahambay ako sa inda paagi sa mga parabola* kay nagasirò man sinda, pero indì makakità; kag nagapamatì man sinda, pero indì makabatì o makaintindi. ");
INSERT INTO rol_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nganì natuman sa inda ang gingpropesiya ni Propeta Isaias, ‘Magapinamatì lang kamo nga magapinamatì, pero indì kamo makaintindi; magasinirò lang kamo nga magasinirò, pero indì kamo makakità. ");
INSERT INTO rol_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kay matugas ang uyo ng ini nga mga tawo, gingtabunan ninda ang inda mga talinga kag gingpiyong ang inda mga mata. Kay basì kung makakità sinda, makabatì kag makaintindi ang inda mga hunahunà, kag makabalik sa akon para paayuhon ko sinda.’ ");
INSERT INTO rol_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Pero bulahan kamo nga nagasunod sa akon, kay nakakakità kamo kag nakakabatì. ");
INSERT INTO rol_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Kay sa matuod lang ginahambay ko sa indo, kadamò nga propeta kag matarong nga mga tawo nang una ang gusto nga makakità ng indo nakikità, pero wayà sinda nakakità; kag gusto da ninda makapamatì ng indo nababatian, pero wayà sinda nakapamatì.” ");
INSERT INTO rol_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Nganì, pamatii nindo kag intindihon kung ano ang gusto hambayon ng parabola parti sa miyugsabwag. ");
INSERT INTO rol_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ang alihid ng dayan nga gingtupaan ng mga binhì imaw ang tawo nga nakabatì ng hambay parti sa paghaharì ng Dios pero wayà nakaintindi. Nag-abot si Satanas kag ging-agaw niya ang hambay ng Dios sa iya tagipusuon. ");
INSERT INTO rol_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ang kabatuhan nga gingtupaan ng mga binhì, imaw ang tawo nga nakabatì ng hambay ng Dios kag gingbaton niya ini nga daan nga may kalipay. ");
INSERT INTO rol_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pero bukon hugot sa iya tagipusuon ang pagbaton sa hambay ng Dios. Nganì wayà magdugay ang iya pagtuo. Pag-abot ng mga kahugaan o paghingabot tungod sa hambay ng Dios nga iya gingbaton, wayà siya nagpadayon sa iya pagtuo. ");
INSERT INTO rol_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ang dutà nga may mga bayagon nga tunukon nga gingtupaan ng mga binhì, imaw ang tawo nga nagpamatì ng hambay ng Dios. Pero tungod sa mga kabayak-on sa pangabuhì kag sa pagtinguhà nga magmanggaranon, nalimutan niya ang hambay ng Dios nga iya nabatian kag wayà ini nakapamunga sa iya kabuhì. ");
INSERT INTO rol_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pero ang maayo nga dutà nga gingtupaan ng mga binhì, imaw ang tawo nga nagpamatì gid kag nakaintindi ng hambay ng Dios. Nganì nakapamunga ini sa iya kabuhì. Ang iban hay kadamò-damò gid ang bunga, ang iban naman hay kadamò da kag ang iban tamà-tamà lang.” ");
INSERT INTO rol_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Nagpadayon si Hesus sa iya pagtudlò paagi sa parabola. Naghambay siya, “Ang paghaharì ng Dios hay pareho sa ini nga istorya: May tawo nga nagsabwag ning maayo nga binhì ng humay sa iya dutà. ");
INSERT INTO rol_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Mintras nagakatuyog ang mga tawo, ang iya kaaway hay nagkadto sa uma kag nagsabwag da ning binhì ng humay-humay sa tungà ng maayo nga binhì. ");
INSERT INTO rol_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nagtubò ang mga tanom kag nang nagabunga na nakità nga may mga humay-humay da didto. ");
INSERT INTO rol_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nganì nagkadto sa iya ang iya mga ulipon kag nagpangutana, ‘Nong, dì ba maayo nga binhì ang aton gingsabwag sa imo dutà? Diin naghalin ang mga humay-humay?’ ");
INSERT INTO rol_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Nagsabat ang inda amo, ‘Igwa kita ning kaaway kag imaw ang naghuman ini.’ Nganì nagpangutana ang iya mga ulipon, ‘Gabuton ba namon ang mga humay-humay?’ ");
INSERT INTO rol_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nagsabat ang inda amo, ‘Ayaw lang, kay basì kung magabot da nindo ang humay. ");
INSERT INTO rol_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pabay-i lang nindo hasta mag-abot ang tig-aani. Sa adto nga tyempo, suguon ko ang mga miyug-ani nga gabuton anay ang humay-humay kag bugkuson para sunugon. Pagkatapos, anihon ninda ang humay kag day-on sa akon kamalig.’ ” ");
INSERT INTO rol_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Nagtudlò pa gid si Hesus paagi sa ini nga parabola: “Ang paghaharì ng Dios hay pareho sa busoy ng mustasa* nga gingtanom ng isa ka tawo sa iya uma. ");
INSERT INTO rol_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ini hay pinakamaisot sa tanan nga busoy, pero pag nagtubò na, imaw ang pinakamabahoy sa tanan nga utanon kag magabahoy pa gid inà hasta ang iya kataas hay pareho na sa kahoy. Aber ang mga pispis puydi makapugad sa iya mga sanga.” ");
INSERT INTO rol_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Nagtudlò pa gid si Hesus paagi sa ini nga parabola: “Ang paghaharì ng Dios hay pareho sa pampaalsa nga ginghalò ng isa ka babayi sa kadakò nga arina nga iya pagamasahon, hasta mag-alsa gid ang bilog nga minasa.” ");
INSERT INTO rol_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Tanan nga gingtudlò ni Hesus sa mga tawo parti sa paghaharì ng Dios hay paagi sa mga parabola. Wayà siya nagatudlò sa inda nga bukon paagi sa mga parabola. ");
INSERT INTO rol_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nganì natuman ang ginghambay ng Dios paagi sa iya propeta: “Magahambay ako paagi sa mga parabola. Ipasayod ko ang mga butang nga wayà pa gid nasasayuri tunà pa nang pagtuga ng kalibutan.” ");
INSERT INTO rol_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Niyan gingbayaan ni Hesus ang mga tawo kag nagsuyod sa bayay. Nagpalapit ang iya mga disipulo kag naghambay, “Iisplikar mo abi sa amon kung ano ang gusto hambayon ng parabola parti sa humay-humay sa uma.” ");
INSERT INTO rol_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nagsabat si Hesus, “Ang tawo nga nagsabwag ng maayo nga binhì hay ako nga Ungà ng Tawo. ");
INSERT INTO rol_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ang uma hay ang kalibutan. Ang maayo nga binhì hay ang mga tawo nga nagapasakop sa paghaharì ng Dios. Kag ang humay-humay hay ang mga tawo nga nagapasakop sa diyablo. ");
INSERT INTO rol_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ang kaaway nga nagsabwag ng humay-humay hay ang diyablo. Ang tig-aani hay ang katapusan ng kalibutan kag ang mga miyug-ani hay ang mga anghel. ");
INSERT INTO rol_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kung pauno ginggabot ang humay-humay kag gingsunog, imaw da ang matatabò sa katapusan ng kalibutan. ");
INSERT INTO rol_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ako nga Ungà ng Tawo hay magapadaya ng akon mga anghel para tipunon kag paluwason halin sa akon gingharian ang tanan nga nagahuman ning malain nga sinda ang kabangdanan kung basì nagakasalà da ang iban. ");
INSERT INTO rol_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Pagkatapos ipilak sinda sa impyerno kung sa diin magadinanguyngoy sinda kag magapinagot ang inda ngipon. ");
INSERT INTO rol_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tapos ang mga matarong hay magahayag pareho ng adlaw sa paghaharì ng inda Amay. Dapat intindihon gid nindo maayo ang indo nababatian.” ");
INSERT INTO rol_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Ang paghaharì ng Dios pareho da sa manggad nga nakalubong sa dutà. Nakutkot ini ng isa ka tawo kag pagkatapos gingtambakan niya liwat kag nag-ulì siya nga may kalipay. Pagkatapos gingbaligyà niya ang tanan niya nga pagkabutang kag gingbakay niya adto nga dutà.” ");
INSERT INTO rol_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ang paghaharì ng Dios hay pareho da sa negosyante nga nagapangità ning mga perlas. ");
INSERT INTO rol_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Nang makità niya ang mamahayon gid nga perlas, nag-ulì siya kag gingbaligyà ang tanan niya nga pagkabutang kag pagkatapos gingbakay niya adto nga perlas.” ");
INSERT INTO rol_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ang paghaharì ng Dios pareho da sa pukot nga gingtaktak sa dagat kag iba-iba nga mga isdà ang nabuoy. ");
INSERT INTO rol_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nang kadamò na ang mga isdà sa pukot, gingbira ini pabaybay. Pagkatapos nagpungkò ang mga miyugpangisdà para pilion ang mga isdà. Ang maayo nga mga isdà gingbutang ninda sa mga basket, pero ang mga malain gingpamilak ninda. ");
INSERT INTO rol_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Imaw da ini ang matatabò sa katapusan ng kalibutan. Magaabot diri ang mga anghel para buyagon ang mga tawo nga malain sa mga tawo nga matarong. ");
INSERT INTO rol_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Kag ang mga tawo nga malain ipilak sa nagadabadaba nga kalayo. Magadanguyngoy sinda kag magapinagot ang inda ngipon didto.” ");
INSERT INTO rol_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Nagpangutana si Hesus sa inda, “Naintindihan ba nindo ang tanan ko nga gingtudlò?” Nagsabat sinda, “Huo.” ");
INSERT INTO rol_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Kag naghambay si Hesus, “Nganì ang kada eskriba nga nakatuon sa gingtudlò parti sa paghaharì ng Dios hay pareho sa tagbayay nga may mga manggad. Bukon lang ang lumà nga mga butang ang iya ginapaluwas sa bayay para gamiton kundì ang mga bag-o da.” ");
INSERT INTO rol_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Pagkatapos ng pagtudlò ni Hesus ng ining mga parabola, naghalin siya didto. ");
INSERT INTO rol_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Nagkadto siya sa iya kaugalingon nga banwa kag nagtudlò sa sinagoga. Natingaya ang mga tawo nga nakabatì sa iya kag nagpangutana sinda, “Sa diin baya siya nakabuoy ning tiyad inà nga kamayad kag gahom para maghuman ning mga milagro? ");
INSERT INTO rol_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Bukon ba imaw ini ang ungà ng karpentero? Dì ba si Maria ang iya nanay kag ang mga manghod niya hay sina Santiago, Jose, Simon kag Judas? ");
INSERT INTO rol_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Kag dì ba ang tanan niya nga manghod nga babayi hay kaibahan naton? Diin baya ini niya nabuoy?” ");
INSERT INTO rol_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Nganì wayà gid siya ninda gingbatuna. Pero naghambay si Hesus sa inda, “Ang propeta hay ginatahod ng mga tawo aber diin nga lugar puyra lang sa kaugalingon niya nga banwa kag sa iya pamilya.” ");
INSERT INTO rol_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Nganì wayà nakahuman si Hesus ning kadamò nga milagro sa lugar ng Nazaret kay wayà sinda magtuo sa iya. ");
INSERT INTO rol_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nang adto nga tyempo, nabatian ni Herodes nga gobernador ng Galilea ang mga balità parti kay Hesus. ");
INSERT INTO rol_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Nganì naghambay siya sa iya mga opisyales, “Si Hesus imaw si Juan nga Miyugbawtismo. Nabanhaw siya! Imaw inà ang rason nga may gahom siya sa paghuman ning mga milagro.” ");
INSERT INTO rol_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Tiyad ini ang ginghambay ni Herodes parti sa dati nga natabò: Ging-asawa ni Herodes si Herodias, aber ini hay asawa ng iya hali nga si Felipe. Nganì permi lang siya ginahambayan ni Juan, “Bawal sa Kasuguan nga asawahon mo ang asawa ng imo hali.” Nganì para lang kay Herodias, gingpadakop ni Herodes si Juan tapos gingpagapos kag gingpapriso. ");
INSERT INTO rol_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Gusto ni Herodes nga ipapatay si Juan, pero nahadlok siya sa mga Judio kay ginakilaya ninda nga propeta siya. ");
INSERT INTO rol_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pag-abot ng silibrasyon ng pag-ungà kay Herodes, nagsaot ang dalaga nga ungà ni Herodias para sa mga bisita nga nagakatipon didto kag nalipay gid si Herodes. ");
INSERT INTO rol_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Nganì nagsumpà siya nga itao sa dalaga ang aber ano nga iya pangayuon. ");
INSERT INTO rol_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Gingsugò ng iya nanay ang dalaga nga ihambay kay Herodes, “Itao mo sa akon arinyan ang uyo ni Juan nga Miyugbawtismo nga nakabutang sa plangganita.” ");
INSERT INTO rol_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Pagkabatì adto ni Herodes, nalisod siya. Pero tungod nga nakasumpà na busà siya kag nabatian da ini ng mga bisita, nagsugò siya nga humanon ang gingpangayò ng dalaga. ");
INSERT INTO rol_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Gingpapugutan niya si Juan didto sa prisuhan. ");
INSERT INTO rol_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Pagkatapos gingbutang niya ang uyo sa plangganita kag gingtao sa dalaga nga gingdaya naman sa iya nanay. ");
INSERT INTO rol_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Nagkadto ang mga disipulo ni Juan kag gingbuoy ninda ang lawas kag ginglubong. Pagkatapos, nagkadto sinda kay Hesus kag gingbalità sa iya ang natabò. ");
INSERT INTO rol_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Nang mabatian ini ni Hesus, naghalin siya kag nagsakay sa dyapang* pakadto sa tiway nga lugar. Pero nang masayuran ini ng kadamò nga tawo, naghalin sinda sa inda mga banwa kag nag-apas sinda nga nagabaktas. ");
INSERT INTO rol_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Pagsalta ni Hesus sa dyapang, nakità niya ang madamò gid nga tawo nga nagatipon didto kag naluoy gid siya sa inda, nganì gingpang-ayo niya ang mga may sakit. ");
INSERT INTO rol_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nang manayumsom na, nagpalapit ang mga disipulo kay Hesus. Hambay ninda, “Manayumsom na kag yari pa kita diri sa tiway nga lugar. Pakadtua na ang mga tawo sa mga baryo agud makabakay sinda ning pagkaon.” ");
INSERT INTO rol_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Naghambay si Hesus, “Indì na sinda kahinangyan nga pahalinon pa. Kamo mismo ang magtao ning pagkaon sa inda.” ");
INSERT INTO rol_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Naghambay sinda, “Pero lima lang ka bilog ang aton tinapay kag duha ka bilog nga isdà.” ");
INSERT INTO rol_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Naghambay si Hesus, “Abi day-a nindo diri sa akon.” ");
INSERT INTO rol_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Gingsugò niya ang mga tawo nga magpungkò sa gunahon. Gingbuoy niya ang lima ka bilog nga tinapay kag duha ka bilog nga isdà, naghangad siya sa langit kag nagpasalamat sa Dios. Pagkatapos gingbuak-buak niya ang tinapay kag gingtao sa iya mga disipulo kag gingpanao naman ninda ini sa mga tawo. ");
INSERT INTO rol_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nakakaon sinda tanan kag nabusog gid. Pagkatapos gingtipon ninda ang nabilin kag napunò pa ang dose ka ayat*. ");
INSERT INTO rol_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mga 5,000 ang lyaki nga nakakaon, puyra ang mga babayi kag mga ungà. ");
INSERT INTO rol_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Pagkatapos adto, gingsugò ni Hesus ang iya mga disipulo nga magsakay sa dyapang kag mag-una sa kabuak mintras ginapaulì niya ang mga tawo. ");
INSERT INTO rol_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nang makahalin na ang mga tawo, nagtukad siya sa bakuyod para magpangamuyò. Nang gab-i na, yadto pa si Hesus nga siya lang mag-isa. ");
INSERT INTO rol_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Pero sa adto da nga oras ang dyapang nga gingsakyan ng iya mga disipulo hay yadto na sa lawod kag ginatuyod-tuyod ng dagkò nga humbak kay sungsungon sa hangin. ");
INSERT INTO rol_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Nang aga-aga na, nagkadto si Hesus didto sa inda nga nagapanaw sa ibabaw ng dagat. ");
INSERT INTO rol_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Pero nang makità ng iya mga disipulo nga nagapanaw siya sa ibabaw ng dagat, hinadlukan gid sinda kag nagsinggit, “Muyto!” ");
INSERT INTO rol_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pero naghambay nga daan si Hesus sa inda, “Paisuga ang indo buot, ako ini! Ayaw kamo mahadlok.” ");
INSERT INTO rol_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pagkatapos naghambay si Pedro, “Ginoo, kung ikaw inà, pakaraa ako nga nagapanaw da sa ibabaw ng tubì.” ");
INSERT INTO rol_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Nagsabat si Hesus, “Kari!” Nganì nagpanaog si Pedro sa dyapang kag nagpanaw sa ibabaw ng tubì pakadto kay Hesus. ");
INSERT INTO rol_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pero nang namangnuhan ni Pedro nga makusog ang hangin, hinadlukan siya kag painot-inot nga naglugdang. Nganì nagsinggit siya, “Ginoo, tabangi ako!” ");
INSERT INTO rol_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Adto nga daan gingdawat ni Hesus ang iya kamot kag ginghawiran siya. Naghambay si Hesus sa iya, “Kaisot ang imo pagtuo! Basì nagaduha-duha ka?” ");
INSERT INTO rol_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Pagkasakay ninda sa dyapang nagduyog ang makusog nga hangin. ");
INSERT INTO rol_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Gingsamba siya ng mga disipulo sa dyapang nga nagahambay, “Matuod gid nga ikaw ang Ungà ng Dios.” ");
INSERT INTO rol_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Pag-abot ninda sa kabuak, nagdunggò sinda sa banwa ng Genesaret. ");
INSERT INTO rol_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nakilaya ng mga tawo didto si Hesus kag gingpasayod ninda sa palibot nga mga lugar nga yarà na siya. Nganì gingpangdaya ninda ang tanan nga may sakit sa iya. ");
INSERT INTO rol_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Nagpakitluoy sinda kay Hesus nga tugutan niya ang mga may sakit nga makatandog aber lang sa gayad ng iya barò. Kag ang tanan nga nakatandog hay nag-ayo. ");
INSERT INTO rol_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Pagkatapos adto, nagpalapit kay Hesus ang mga Pariseo kag mga eskriba halin sa Jerusalem kag nagpangutana, ");
INSERT INTO rol_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Basì ang imo mga disipulo hay wayà nagatuman ng mga tradisyon ng aton mga kalulo-lulohan? Wayà sinda nagapanghinaw ng inda mga kamot bago magkaon.” ");
INSERT INTO rol_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Nagsabat si Hesus, “Kamo da, basì ginasuway nindo ang sugò ng Dios tungod sa pagsunod sa indo mga tradisyon? ");
INSERT INTO rol_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kay gingsugò ng Dios, ‘Tahura ang imo tatay kag nanay,’ kag ‘Ang nagahambay ning malain sa iya tatay o nanay, dapat gid patyon.’ ");
INSERT INTO rol_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pero kamo nagatudlò nga kung ang tawo may ikakabulig sa iya tatay o nanay kag nagahambay siya sa inda, ‘Inughalad* ini sa Dios,’ indì na siya kahinangyan nga magbulig sa iya mga ginikanan. ");
INSERT INTO rol_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Tungod sa indo tradisyon, ginghuman nindo nga wayà ning puyos ang hambay ng Dios. ");
INSERT INTO rol_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mga hipokrito! Tamà gid ang gingpropesiya ni Isaias: ");
INSERT INTO rol_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ini nga mga tawo hay nagatahod sa akon sa bàbà lang, pero ang inda tagipusuon malayò sa akon. ");
INSERT INTO rol_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Wayà puyos ang inda pagsamba sa akon, kay ang inda mga ginatudlò hay mga tradisyon nga ginghuman lang ng mga tawo.’ ” ");
INSERT INTO rol_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Pagkatapos gingtawag ni Hesus ang mga tawo kag hambay niya, “Pamatì kamo kag intindihon nindo ang akon ihambay. ");
INSERT INTO rol_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Wayà ning butang nga nagasuyod sa bàbà ng tawo nga nagapahigkò sa iya kundì ang nagaluwas sa iya bàbà.” ");
INSERT INTO rol_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Pagkatapos nagpalapit sa iya ang mga disipulo kag naghambay, “Sayod mo ba nga naglain ang buot ng mga Pariseo sa adto nga mga ginghambay mo?” ");
INSERT INTO rol_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Nagsabat si Hesus, “Ang kada tanom nga wayà gingtanuman ng akon Amay sa langit pagagabuton. ");
INSERT INTO rol_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Pabay-i lang nindo sinda. Mga buta sinda nga miyugtuytoy. Kag kung magaagbay ang buta sa buta, pareho sinda nga mahuhuyog sa buhò.” ");
INSERT INTO rol_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Naghambay si Pedro kay Hesus, “Puydi ba iisplikar mo sa amon kung ano ang gusto hambayon ng adto nga hambayanon?” ");
INSERT INTO rol_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Naghambay si Hesus sa inda, “Wayà pa ba gihapon kamo makakaintindi? ");
INSERT INTO rol_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Wayà ba kamo makakasayod nga ang aber ano nga nagasuyod sa bàbà hay nagaderitso sa tiyan kag sa ulihi nagaluwas sa lawas? ");
INSERT INTO rol_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pero ang nagaluwas sa bàbà hay nagahalin sa tagipusuon kag imaw ini ang nagapahigkò sa tawo. ");
INSERT INTO rol_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kay sa tagipusuon ng tawo nagahalin ang malain nga mga panghunahunà nga imaw ang nagatuyod sa iya sa pagpatay, pagpangawatan, pagpakig-relasyon ning imoral, pagpangawat, pagtestigo ning pinusong kag pagpanirà sa iya isigkatawo. ");
INSERT INTO rol_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Imaw ini ang mga nagapahigkò sa tawo. Pero ang magkaon nga wayà nagapanghinaw hay indì makapahigkò sa tawo.” ");
INSERT INTO rol_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Naghalin si Hesus didto kag nagkadto sa mga lugar ng Tyre kag Sidon. ");
INSERT INTO rol_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Igwa ning isa ka babayi nga taga-Canaan nga nagaistar didto. Nagpalapit siya kay Hesus kag nagsinggit, “Ginoo, inapo ni David, kaluy-i ako! Ang akon ungà nga babayi ginasapian ng demonyo kag ginapahugaan gid!” ");
INSERT INTO rol_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pero wayà nagsabat si Hesus sa iya. Ang iya mga disipulo nagpalapit sa iya kag nagpangabay nga nagahambay, “Pahalina inang babayi, kay nagasinunod siya sa aton kag naganilingaw.” ");
INSERT INTO rol_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Pagkatapos nagsabat si Hesus, “Gingsugò ako diri para magbulig sa mga Israelita nga daw sa mga karnero nga nagkaduyà.” ");
INSERT INTO rol_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pero nagpalapit pa gid ang babayi kag nagsamba sa iya atubangan kag naghambay, “Ginoo, buligi ako!” ");
INSERT INTO rol_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Nagsabat si Hesus sa iya, “Bukon maayo nga buy-on ang pagkaon ng mga ungà kag ipilak sa mga ayam.” ");
INSERT INTO rol_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Nagsabat ang babayi, “Huo Ginoo, pero aber pa ang mga ayam hay nagakaon ning muhmo nga nagakahuyog sa lamisa ng inda amo.” ");
INSERT INTO rol_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Pagkatapos naghambay si Hesus sa iya, “Manang, kadakò ang imo pagtuo! Nganì mababaton mo ang imo ginapangayò sa akon.” Kag adto nga daan, nag-ayo ang iya ungà. ");
INSERT INTO rol_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Naghalin didto si Hesus kag nag-agi sa alihid ng Lawà ng Galilea*. Tapos nagtukad siya sa bakuyod kag nagpungkò didto. ");
INSERT INTO rol_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kadamò nga tawo ang nagpalapit sa iya. Gingdaya ninda ang mga pakì, pingkaw, buta, apà kag kadamò pa gid nga may sakit. Gingbutang ini ninda sa atubangan ni Hesus kag gingpang-ayo niya sinda tanan. ");
INSERT INTO rol_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Natingaya gid ang mga tawo kay nakità ninda ang mga apà hay nakahambay, maayo na ang kamot ng mga pingkaw, ang mga pakì hay nakapanaw kag ang mga buta hay nakakità. Kag gingdayaw ninda ang Dios ng Israel. ");
INSERT INTO rol_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Niyan gingtawag ni Hesus ang iya mga disipulo kag naghambay sa inda, “Naluluoy gid ako sa ini nga mga tawo. Kay tuyo na ka adlaw nga kaibahan ninda ako kag naubos na ang inda pagkaon. Indì ko gusto nga pabalikon sinda nga gutom kay basì kung malipungan sinda sa dayan.” ");
INSERT INTO rol_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nagpangutana ang mga disipulo sa iya, “Sa diin baya kita makabuoy ning pagkaon diri sa tiway nga lugar para ipakaon sa tiyad inà kadamò nga tawo?” ");
INSERT INTO rol_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Pero nagpangutana si Hesus sa inda, “Pila ka bilog ang indo tinapay dirà?” Nagsabat sinda, “Pito ka bilog kag pila lang ka maintik nga isdà.” ");
INSERT INTO rol_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Niyan gingpapungkò ni Hesus ang mga tawo sa dutà. ");
INSERT INTO rol_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Gingbuoy niya ang pito ka bilog nga tinapay kag ang isdà kag nagpasalamat sa Dios. Pagkatapos gingbuak-buak niya ang tinapay kag gingtao sa mga disipulo. Kag gingpanao ninda sa mga tawo. ");
INSERT INTO rol_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nakakaon sinda tanan kag nabusog gid. Pagkatapos, gingtipon ninda ang nabilin kag napunò pa ang pito ka bangkat*. ");
INSERT INTO rol_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Mga 4,000 nga lyaki ang nakakaon, puyra pa ang mga babayi kag mga ungà. ");
INSERT INTO rol_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Pagkatapos adto gingpabalik ni Hesus ang mga tawo kag nagsakay siya sa dyapang kag nagtabok pakadto sa lugar ng Magadan. ");
INSERT INTO rol_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","May pila ka Pariseo* kag Saduceo* ang nagpalapit kay Hesus. Gusto ninda nga tistingon siya, nganì nagpangayò sinda sa iya ning milagro halin sa langit para pamatuuran nga gingsugò siya ng Dios. ");
INSERT INTO rol_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Pero nagsabat si Hesus, “Pag nagatunod na ang adlaw kag ang langit hay mapuya, nagahambay kamo, ‘Maayo ang tyempo buwas.’ ");
INSERT INTO rol_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kag kung aga pa kag ang langit hay nagapuya kag nagakunom, nagahambay kamo, ‘Mauyan ini nga adlaw.’ Antigo kamo magsirò sa langit para masayuran nindo kung magainit o magauyan, pero indì kamo makaintindi kung ano ang gusto hambayon ng mga tandà parti sa ini nga tyempo. ");
INSERT INTO rol_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ang mga tawo niyan hay sobra gid kalain kag wayà na nagasunod sa kabubut-on ng Dios. Nagapangayò sinda ning milagro, pero wayà ning milagro nga ipakità sa inda puyra lang ang milagro nga natabò kay Propeta Jonas.” Pagkatapos naghalin si Hesus didto. ");
INSERT INTO rol_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nang nagtabok si Hesus kag ang iya mga disipulo sa kabuak, nalimutan ng iya mga kaibahan magdaya ning tinapay. ");
INSERT INTO rol_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Naghambay si Hesus sa inda, “Mag-andam gid kamo sa pampaalsa ng mga Pariseo kag mga Saduceo.” ");
INSERT INTO rol_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Nang mabatian ini ng iya mga disipulo, naghambay sinda sa isa kag isa, “Siguro ginghambay niya ini kay wayà kita nakadaya ning tinapay.” ");
INSERT INTO rol_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Nasayuran ni Hesus kung ano ang inda ginainistorya, nganì naghambay siya, “Kaisot ang indo pagtuo! Basì nagainistorya kamo nga wayà kamo tinapay? ");
INSERT INTO rol_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Wayà pa gid ba kamo makaintindi? Wayà ba nindo madumdumi ang lima ka bilog nga tinapay nga gingpakaon ko sa 5,000 ka tawo kag pila pa ka bangkat ang napunò? ");
INSERT INTO rol_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Wayà ba nindo nadumdumi ang pito ka bilog nga tinapay nga gingpakaon ko sa 4,000 ka tawo kag pila pa ka bangkat ang napunò? ");
INSERT INTO rol_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Wayà ba kamo makaintindi nga bukon tinapay ang akon gusto hambayon kaina? Mag-andam gid kamo sa pampaalsa ng mga Pariseo kag Saduceo!” ");
INSERT INTO rol_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Nganì naintindihan ninda nga bukon galì ang pampaalsa ng tinapay ang inda dapat andaman kundì ang ginatudlò ng mga Pariseo kag mga Saduceo. ");
INSERT INTO rol_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Nang mag-abot sina Hesus sa lugar ng Cesarea Filipos, nagpangutana siya sa iya mga disipulo, “Sin-o kuno ako nga Ungà ng Tawo*, sunò sa hambay ng mga tawo?” ");
INSERT INTO rol_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Nagsabat sinda, “May mga nagahambay nga ikaw si Juan nga Miyugbawtismo. Ang iban naman nagahambay nga ikaw hay si Elias. Ang iban pa gid nagahambay, ikaw hay si Jeremias o isa sa mga propeta.” ");
INSERT INTO rol_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Naghambay si Hesus sa inda, “Hay kamo, ano ang indo mahahambay, sin-o ako?” ");
INSERT INTO rol_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Nagsabat si Simon Pedro, “Ikaw imaw ang Kristo, ang Ungà ng Dios nga buhì!” ");
INSERT INTO rol_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Nagsabat si Hesus, “Simon nga ungà ni Jonas, bulahan ka! Kay ang nagpasayod sa imo sa ini nga butang bukon tawo kundì ang akon Amay sa langit. ");
INSERT INTO rol_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Kag imaw ini ang akon hambay sa imo: ginapangayanan ko ikaw nga Pedro kag sa ini nga bato patindugon ko ang akon iglesya. Kag aber ang gahom ng kamatayon indì makaperdi diri. ");
INSERT INTO rol_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Itao ko sa imo ang mga lyabi sa gingharian ng Dios. Nganì ang aber ano nga indì mo itugot sa dutà, indì da itugot ng Dios sa langit kag ang aber ano nga itugot mo sa dutà, itugot da ng Dios sa langit.” ");
INSERT INTO rol_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Pagkatapos gingpaandaman ni Hesus ang iya mga disipulo nga indì gid magbalità aber kanin-o nga siya ang Kristo. ");
INSERT INTO rol_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tunà adto, gingpasayod na ni Hesus sa iya mga disipulo kung ano ang matatabò sa iya. Hambay niya, “Dapat gid ako magkadto sa Jerusalem kag mag-agi ning sobra nga mga kahugaan nga humanon sa akon ng mga miyugdumaya ng Judio, mga pinunò nga parì kag mga eskriba. Ipapatay ninda ako, pero sa ikatuyo ka adlaw mababanhaw ako.” ");
INSERT INTO rol_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pagkabatì adto ni Pedro, gingdaya niya si Hesus sa alihid kag gingsabyaw, “Ginoo, kabay pa nga indì inà itugot ng Dios! Indì dapat matabò inà sa imo!” ");
INSERT INTO rol_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Naglingig si Hesus sa iya kag naghambay, “Lumayas ka, Satanas! Ginapunggan mo ako sa paghuman ng kabubut-on ng Dios! Ang imo ginahunahunà hay bukon halin sa Dios kundì sa tawo.” ");
INSERT INTO rol_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Pagkatapos, naghambay si Hesus sa iya mga disipulo, “Ang aber sin-o nga gusto magsunod sa akon, dapat indì niya palabihon ang iya kaugalingon, kundì pas-anon niya ang iya krus kag magsunod sa akon. ");
INSERT INTO rol_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kay ang aber sin-o nga nagapalabi ng iya kabuhì hay maduduyaan ini; pero ang aber sin-o nga nagahalad ng iya kabuhì tungod sa akon, makakabaton siya ning kabuhì nga wayà katapusan. ");
INSERT INTO rol_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kay ano gid baya ang mapupuslan ng tawo kung maangkon man niya ang tanan nga butang diri sa kalibutan, pero mawad-an naman siya ning kabuhì? Wayà gid! Kay wayà gid ning butang nga puydi niya itao agud mapapabalik niya ang iya kabuhì. ");
INSERT INTO rol_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kay ako nga Ungà ng Tawo, magabalik sa kalibutan nga may kasilaw nga gahom ng akon Amay kag kaibahan ko ang akon mga anghel. Adto nga adlaw, taw-an ko ning premyo ang kada isa sunò sa inda mga hinimuan. ");
INSERT INTO rol_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Sa matuod lang ginahambay ko sa indo, may mga tawo diri nga indì pa mamatay hasta nga makità ninda ako nga Ungà ng Tawo nga magabalik diri bilang harì.” ");
INSERT INTO rol_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Pagkaligad ng unom ka adlaw, gingdaya ni Hesus si Pedro kag ang magmanghod nga sina Santiago kag Juan sa mataas nga bakuyod nga sinda lang didto. ");
INSERT INTO rol_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Kag gulpi lang nagbaylo ang hitsura ni Hesus sa inda atubangan nga daw adlaw nga kasilaw-silaw kag ang iya barò hay kaputì-putì gid. ");
INSERT INTO rol_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Pagkatapos nagpakità sa inda sina Moises kag Elias nga nagapakig-istorya kay Hesus. ");
INSERT INTO rol_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Naghambay si Pedro kay Hesus, “Ginoo, maayo kay yari na kita diri. Kung gusto mo, mahuman ako diri ning tuyo ka bayay-bayay, ang isa para sa imo, ang isa kay Moises kag ang isa pa kay Elias.” ");
INSERT INTO rol_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Mintras nagahambay pa si Pedro, may nag-abot nga masilaw nga panganod kag gingtabunan sinda. Kag may nabatian sinda nga boses halin sa panganod nga nagahambay, “Imaw ini ang akon pinalanggà nga Ungà. Nalilipay gid ako sa iya. Pamatii nindo siya!” ");
INSERT INTO rol_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nang mabatian ini ng iya mga disipulo, naghapà sinda sa sobra nga kahadlok. ");
INSERT INTO rol_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Pero gingpalapitan sinda ni Hesus kag ginghawiran. Naghambay siya, “Tindog kamo! Ayaw kamo mahadlok!” ");
INSERT INTO rol_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Paghangad ninda, wayà na sinda ning may nakità kundì si Hesus lang. ");
INSERT INTO rol_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nang nagapatugbong na sinda sa bakuyod, gingbilinan sinda ni Hesus, “Ayaw kamo magpamalità aber kanin-o parti sa indo nakità hasta ako nga Ungà ng Tawo hay mabanhaw.” ");
INSERT INTO rol_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Pagkatapos, nagpangutana sa iya ang mga disipulo, “Basì nagahambay ang mga eskriba nga kahinangyan mag-abot anay si Elias bago mag-abot ang Kristo?” ");
INSERT INTO rol_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Nagsabat si Hesus, “Tamà inà, dapat mag-abot anay si Elias para ipreparar niya ang tanan nga butang. ");
INSERT INTO rol_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pero ginahambay ko sa indo, si Elias hay nag-abot na. Ugaling wayà lang siya nakilaya ng mga tawo, nganì ginghuman ninda sa iya ang inda gusto. Kag imaw da ang inda humanon sa akon nga Ungà ng Tawo. Pahugaan da ninda ako.” ");
INSERT INTO rol_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Kag naintindihan ng iya mga disipulo nga si Juan nga Miyugbawtismo ang iya ginatukoy. ");
INSERT INTO rol_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nang nagtugbong sina Hesus halin sa bakuyod, gingsugat sinda ng kadamò nga tawo. May isa ka lyaki nga nagpalapit sa iya kag nagluhod nga naghambay, ");
INSERT INTO rol_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Ginoo, kaluy-i ang akon ungà nga lyaki kay may epilepsi siya kag kung ginaabot hay ginahugaan gid siya. Permi siya natutumba sa kalayo kag permi nahuhuyog sa tubì. ");
INSERT INTO rol_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Gingdaya ko siya sa imo mga disipulo, pero indì sinda makapaayo sa iya.” ");
INSERT INTO rol_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Nagsabat si Hesus, “Kamo nga mga tawo niyan, wayà gid ning pagtuo kag salà gid ang indo panghunahunà. Hasta san-o pa baya ang akon pag-antos sa indo? Day-a diri sa akon ang ungà.” ");
INSERT INTO rol_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Gingsabyaw ni Hesus ang demonyo kag nagluwas ini. Adto gid nga oras, nag-ayo ang ungà. ");
INSERT INTO rol_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Gingpangutana si Hesus ng iya mga disipulo nang sinda na lang, “Basì baya indì namon mapalayas ang malain nga espiritu?” ");
INSERT INTO rol_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Nagsabat si Hesus sa inda, “Kay kuyang ang indo pagtuo. Sa matuod lang ginahambay ko sa indo, kung igwa kamo ning pagtuo aber pareho lang sa maisot nga busoy ng mustasa*, puydi kamo maghambay sa ini nga bukid, ‘Magsaylo ka didto!’ Kag ang bukid magasaylo. Wayà gid ning butang nga indì nindo mahuman.” ");
INSERT INTO rol_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pero ini nga klasi ng malain nga espiritu, indì nindo mapalayas kung indì kamo magpangamuyò kag magpuasa. ");
INSERT INTO rol_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Mintras nagatipon ang mga disipulo ni Hesus sa Galilea, naghambay siya sa inda, “Ako nga Ungà ng Tawo hay malapit na itugyan sa mga tawo ");
INSERT INTO rol_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","nga magapatay sa akon. Pero sa ikatuyo ka adlaw mababanhaw ako.” Nalisod gid ang iya mga disipulo sa iya ginghambay. ");
INSERT INTO rol_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Nang mag-abot sina Hesus sa Capernaum*, gingpalapitan si Pedro ng mga miyugsukot ning buhis sa templo kag gingpangutana, “Nagabayad ba ang indo maestro ning buhis para sa templo?” ");
INSERT INTO rol_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Nagsabat si Pedro, “Huo, nagabayad siya.” Pag-abot ni Pedro sa bayay nga ginaistaran ni Hesus, si Hesus gid ang una nga naghambay sa iya, “Ano sa isip mo, Simon? Sin-o ang ginapabayad ng mga harì sa kalibutan ning buhis? Ang inda ba mga pumuluyò o ang iban?” ");
INSERT INTO rol_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Nagsabat si Pedro, “Ang iban.” Tapos naghambay si Hesus, “Kung tiyad inà, ang mga ungà ng Dios indì kahinangyan magbayad ning buhis sa templo ng Dios. ");
INSERT INTO rol_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero kung indì kita magbayad, basì kung magalain ang inda buot sa aton. Nganì magkadto ka sa dagat kag magpamunit. Bukaa ang bàbà ng una nga isdà nga imo mabunit kag makikità mo didto ang bilog nga stater*. Buy-a adto kag bayari ang mga nagasukot ning buhis para sa aton nga duha.” ");
INSERT INTO rol_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Adto da nga adlaw, nagpalapit kay Hesus ang iya mga disipulo kag nagpangutana, “Sin-o gid ang labaw sa tanan nga sakop sa paghaharì ng Dios?” ");
INSERT INTO rol_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Gingtawag ni Hesus ang isa ka ungà kag gingpatindog niya sa inda tungà. ");
INSERT INTO rol_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Tapos naghambay siya, “Sa matuod lang ginahambay ko sa indo, kung indì kamo magbag-o kag maging pareho ng ungà, indì gid kamo makasuyod sa gingharian ng Dios. ");
INSERT INTO rol_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kay ang aber sin-o nga mapainubuson pareho sa ini nga ungà, imaw ang labaw sa tanan nga sakop sa paghaharì ng Dios. ");
INSERT INTO rol_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Kag ang aber sin-o nga nagabaton sa tawo nga mapinaubuson pareho sa ungà nga tiyad ini tungod sa iya pagtuo sa akon nagabaton da sa akon.” ");
INSERT INTO rol_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ang aber sin-o nga maging kabangdanan nga makasalà ang isa sa ining bag-o nga nagatuo sa akon, mas maayo pa sa iya nga higutan ning mabahoy nga galingan nga bato ang iya liog kag itagbong sa madayom nga dagat. ");
INSERT INTO rol_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Makaluluoy ang mga tawo sa kalibutan kay ang mga pagtintar hay sigurado nga magaabot. Pero makaluluoy gid ang mga tawo nga imaw ang nagapangtintar sa inda isigkatawo! ");
INSERT INTO rol_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Kung ang imo kamot o siki ang kabangdanan nga nagakasalà ka, utura inà kag ipilak! Mas maayo pa nga may kabuhì ka nga wayà katapusan nga isa lang ang imo kamot o siki, kaysa sa duha ang imo kamot kag siki, pero ipilak ka naman sa kalayo nga indì gid mamatay. ");
INSERT INTO rol_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Kag kung ang imo mata imaw ang kabangdanan nga nagakasalà ka, lukata inà kag ipilak! Mas maayo pa nga may kabuhì ka nga wayà katapusan nga isa lang ang imo mata, kaysa sa duha ang imo mata pero ipilak ka naman sa impyerno nga nagadabadaba.” ");
INSERT INTO rol_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Mag-andam kamo, ayaw gid nindo pagkabiga nga bukon importante aber ang isa sa ini nga maisot nga mga ungà. Ginahambay ko sa indo, ang mga anghel ng Dios nga nagabantay sa inda hay yadto permi sa atubangan ng akon Amay sa langit. ");
INSERT INTO rol_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Kay ang Ungà ng Tawo, nagkari sa kalibutan para pangitaon ang mga tawo nga naduyà. ");
INSERT INTO rol_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Kung ang isa ka tawo hay igwa ning 100 ka karnero kag naduyà ang isa, ano ang iya humanon? Syempre bayaan niya ang 99 sa mga kabukiran kag pangitaon niya ang naduyà. ");
INSERT INTO rol_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Sa matuod lang ginahambay ko sa indo, kung iya ini makità malilipay gid siya kag mas dakò ang iya kalipay sa isa, kaysa sa 99 nga wayà naduyà. ");
INSERT INTO rol_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Tiyad da ini ang kabubut-on ng indo Amay sa langit. Indì gid niya gusto nga maduyà ang aber isa lang ka maisot nga ungà.” ");
INSERT INTO rol_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Kung ang imo utod hay nakasalà sa imo, kadtui siya kag hambayi ng iya ginghuman nga salà. Humanon mo ini nga kamo lang. Kung magpamatì siya sa imo, magakaayos kamo liwat kag mapabalik mo siya sa Dios. ");
INSERT INTO rol_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pero kung indì siya magpamatì sa imo, magdaya ka ning isa o duha ka mga kauturan para ang mga butang nga indo maistoryahan hay mapamatuuran ng duha o tuyo nga testigo. ");
INSERT INTO rol_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Pero kung indì pa gid siya magpamatì, ipasayod mo ini sa kongregasyon. Kag kung indì gihapon siya magpamatì, kabiga siya nga daw wayà nakakilaya sa Dios o pareho sa mga miyugsukot ning buhis. ");
INSERT INTO rol_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Sa matuod lang ginahambay ko sa indo, ang aber ano nga indì nindo itugot diri sa dutà imaw da ang indì itugot ng Dios sa langit kag ang aber ano nga itugot nindo diri sa dutà imaw da ang itugot ng Dios sa langit. ");
INSERT INTO rol_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Sa matuod lang ginahambay ko sa indo, kung ang duha sa indo diri sa kalibutan, magkasugot parti sa aber ano nga indo pangayuon sa pangamuyò, humanon inà sa indo ng akon Amay sa langit. ");
INSERT INTO rol_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kay kung diin may duha o tuyo nga nagatipon sa akon pangayan, yadto ako sa inda tungà.” ");
INSERT INTO rol_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pagkatapos nagpalapit si Pedro kay Hesus kag nagpangutana, “Ginoo, kung ang akon utod permi nagakasalà sa akon, makapila ko siya patawaron? Makapito ba?” ");
INSERT INTO rol_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Nagsabat si Hesus, “Bukon lang makapito, kundì 70 ka pito. ");
INSERT INTO rol_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Kay ang paghaharì ng Dios hay pareho sa ini nga istorya: May isa ka harì nga gusto na magpanukot ng mga utang ng iya mga ulipon. ");
INSERT INTO rol_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Mintras nagapanukot siya ng iya mga pautang, may gingdaya sa iya nga ulipon nga ang iya utang hay milyones. ");
INSERT INTO rol_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kay indì siya makabayad, nagsugò ang harì nga ibaligyà siya kaibahan ang iya asawa kag ang iya mga ungà. Kag ibaligyà da ang tanan niya nga propidad para mabayaran ang iya utang. ");
INSERT INTO rol_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Nganì nagluhod ang ulipon sa harì kag nagpakitluoy nga ang hambay, ‘Pasensyaha lang anay ako, bayaran ta da ikaw!’ ");
INSERT INTO rol_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Naluoy ang harì sa iya, nganì gingpatawad siya kag wayà na pagpabayara sa iya utang. ");
INSERT INTO rol_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Pagkaluwas ng adto nga ulipon, nasumpong niya ang kapareho niya nga ulipon nga may utang sa iya ning isa ka gatos nga denarius*. Gingluok niya ini kag ginghambayan, ‘Bayari ako ng imo utang!’ ");
INSERT INTO rol_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nagluhod sa iya ang ulipon nga nagapakitluoy, ‘Pasensyaha lang anay ako kay bayaran ta da ikaw!’ ");
INSERT INTO rol_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pero wayà gid siya nagpasugot. Gingpapriso niya adtong ulipon hasta nga makabayad siya. ");
INSERT INTO rol_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nang makità ng iban nga mga ulipon ang iya ginghuman, naglain ang inda buot, nganì nagkadto sinda sa harì kag gingbalità ang tanan nga natabò. ");
INSERT INTO rol_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Gingpatawag ng harì ang ulipon kag naghambay, ‘Masyado ka nga ulipon! Gingpatawad ta ikaw sa imo utang kay nagpakitluoy ka. ");
INSERT INTO rol_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Basì wayà mo pagkaluy-i ang imo kapareho, pareho ng akon pagkaluoy sa imo?’ ");
INSERT INTO rol_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Sa tudo nga kahangit ng harì, gingpapriso niya adtong ulipon hasta mabayaran ang tanan niya nga utang.” ");
INSERT INTO rol_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Pagkatapos naghambay si Hesus sa inda, “Imaw da ini ang humanon sa indo ng akon Amay sa langit kung indì kamo magpatawad sa indo isigkatawo ning hugot sa indo tagipusuon.” ");
INSERT INTO rol_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Pagkahambay ni Hesus ini nga mga butang, naghalin siya sa Galilea kag nagkadto sa mga lugar nga sakop ng Judea kag nagtabok sa Subà ng Jordan. ");
INSERT INTO rol_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kadamò nga tawo ang nagsunod sa iya kag gingpang-ayo niya sinda sa inda mga sakit. ");
INSERT INTO rol_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Niyan may mga Pariseo nga nagkadto sa iya. Nagapangità sinda ning paagi para tistingon siya. Nganì nagpangutana sinda kay Hesus, “Ginatugutan ba ng Kasuguan nga buyagan ng lyaki ang iya asawa sa aber ano nga rason?” ");
INSERT INTO rol_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Nagsabat si Hesus, “Wayà ba kamo makabasa sa Kasulatan, nang gingtuga ng Dios ang tawo, ginghuman niya sinda nga lyaki kag babayi? ");
INSERT INTO rol_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Kag naghambay ang Dios, ‘Imaw ini ang rason nga bayaan ng lyaki ang iya tatay kag nanay kag magaiba sa iya asawa kag sinda nga duha maging isa ka lawas.’ ");
INSERT INTO rol_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Bukon na sinda duha kundì isa. Nganì indì dapat buyagon ng tawo ang ging-isa na ng Dios.” ");
INSERT INTO rol_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Nagpangutana pa gid ang mga Pariseo, “Kung tiyad inà, basì nagsugò si Moises nga puydi buyagan ng lyaki ang iya asawa, basta taw-an lang niya ning papeles ng pagbinuyagan, pagkatapos puydi na niya mabuyagan ang iya asawa?” ");
INSERT INTO rol_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Nagsabat si Hesus sa inda, “Gingtugutan ni Moises nga buyagan nindo ang indo asawa kay matugas ang indo uyo. Pero bukon tiyad inà ang plano ng Dios nang una. ");
INSERT INTO rol_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nganì imaw ini ang ginahambay ko sa indo. Ang aber sin-o nga lyaki nga magbuyag sa iya asawa sa aber ano nga rason puyra lang sa pagpangawatan kag mag-asawa ning iban hay nagapangawatan da.” ");
INSERT INTO rol_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Pagkatapos naghambay ang iya mga disipulo kay Hesus, “Kung tiyad galì inà ang sitwasyon sa pag-asawa, maayo pa nga indì na lang mag-asawa.” ");
INSERT INTO rol_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Pero nagsabat si Hesus, “Bukon tanan nga tawo hay makabaton ng ini nga pagpanudlò, kundì adto lang ang mga tawo nga gingtaw-an ng Dios. ");
INSERT INTO rol_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","May iba-iba nga rason kung basì may mga lyaki nga indì makaasawa. May mga natawo nga indì gid makaasawa kay may deperensya na sinda. Ang iban indì makaasawa kay mga yunuko, kag ang iban naman indì makaasawa kay gingpalabi ninda ang paghaharì ng Dios. Kung sin-o ang makabaton ng ini nga pagpanudlò, batunon lang.” ");
INSERT INTO rol_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Pagkatapos, may mga tawo nga nagdaya ng mga ungà kay Hesus para itungtong ang iya kamot sa inda kag ipangamuyò. Pero gingsabyaw ng iya mga disipulo ang mga nagdaya sa inda. ");
INSERT INTO rol_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Nganì naghambay si Hesus sa inda, “Pabay-i lang nindo ang mga ungà nga magpalapit sa akon. Ayaw nindo sinda pagpunggi, kay ang mga kapareho ninda hay imaw ang nagapasakop sa paghaharì ng Dios.” ");
INSERT INTO rol_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Tapos gingtungtong ni Hesus ang iya kamot sa mga ungà. Pagkatapos naghalin siya didto. ");
INSERT INTO rol_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","May isa ka lyaki nga nagpalapit kay Hesus kag nagpangutana, “Maestro, ano ang maayo ko nga humanon agud magkaigwa ako ning kabuhì nga wayà katapusan?” ");
INSERT INTO rol_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Nagsabat si Hesus sa iya, “Basì nagapangutana ka sa akon kung ano ang maayo? Isa lang ang maayo kag wayà na ning iban kundì ang Dios. Kung gusto mo magkaigwa ning kabuhì nga wayà katapusan, tumana ang mga sugò.” ");
INSERT INTO rol_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Nagpangutana siya liwat, “Diin didto nga mga sugò?” Naghambay si Hesus, “Ayaw magpamatay; ayaw magpangawatan; ayaw magpangawat; ayaw magtestigo ning pinusong; ");
INSERT INTO rol_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","tahura ang imo tatay kag nanay; kag higugmaon mo ang imo isigkatawo pareho ng paghigugmà mo sa imo kaugalingon.” ");
INSERT INTO rol_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nagsabat ang soltero, “Ini tanan hay natuman ko na. Ano pa ang kuyang ko?” ");
INSERT INTO rol_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Nagsabat si Hesus, “Kung gusto mo nga wayà ka na gid ning kuyang sa panirò ng Dios, mag-ulì ka kag ibaligyà ang imo mga propidad kag ipanao ang kwarta sa mga pobre para magkaigwa ka na ning manggad sa langit. Pagkatapos balik diri kag magsunod sa akon.” ");
INSERT INTO rol_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nang mabatian adto ng soltero, naghalin siya nga malisod kay madamò ang iya manggad. ");
INSERT INTO rol_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Nganì naghambay si Hesus sa iya mga disipulo, “Sa matuod lang ginahambay ko sa indo, mahugà gid para sa isa ka manggaranon ang makasuyod sa gingharian ng Dios. ");
INSERT INTO rol_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ginahambay ko sa indo, mas malupos pa nga mag-agi ang kamelyo sa buhò ng dayom kaysa sa magsuyod ang manggaranon sa gingharian ng Dios.” ");
INSERT INTO rol_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nang mabatian adto ng iya mga disipulo, natingaya gid sinda kag nagpangutana sa iya, “Kung tiyad inà, sin-o na lang ang maluwas?” ");
INSERT INTO rol_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Gingsirò sinda ni Hesus kag naghambay, “Kung sa mga tawo lang imposible gid ini, pero sa Dios ang tanan nga butang hay posible.” ");
INSERT INTO rol_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pagkatapos nagpangutana si Pedro sa iya, “Hay pauno kami? Gingbayaan namon ang tanan kag nagnunot sa imo? Ano naman ang para sa amon?” ");
INSERT INTO rol_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Naghambay si Hesus, “Sa matuod lang ginahambay ko sa indo, magaabot ang adlaw nga bag-uhon ng Dios ini nga kalibutan kag ako nga Ungà ng Tawo magapungkò sa akon trono para magharì. Adto nga adlaw, kamo nga nagasunod sa akon magapungkò da sa dose ka trono para husgahan ang dose ka tribo ng Israel. ");
INSERT INTO rol_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kag ang aber sin-o nga nagabayà ng iya mga bayay, mga maguyáng kag mga manghod, tatay kag nanay, mga ungà, o mga dutà para magsunod sa akon, magabaton ning ginatos ka doble nga bayos kag magapanublì ning kabuhì nga wayà katapusan. ");
INSERT INTO rol_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pero madamò nga tawo ang nauuna nga mauulihi kag nauulihi nga mauuna.” ");
INSERT INTO rol_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Nagpadayon si Hesus sa iya paghambay, “Ang paghaharì ng Dios hay tiyad ini. May isa ka tawo nga nagluwas ning aga pa gid para magpangità ning mga trabahador sa iya ubasan. ");
INSERT INTO rol_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nagkasugot sinda nga ang suhoy hay isa ka denarius ang isa ka adlaw. Ang mga trabahador hay gingpakadto niya sa iya tanuman. ");
INSERT INTO rol_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Nang mga alas nuwebe ng aga, nagkadto siya liwat sa merkado kag may iban naman siya nga nakità nga nagaistambay. ");
INSERT INTO rol_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Naghambay siya sa inda, ‘Kadto kamo sa akon ubasan, kay suhuyan ta kamo ning tamà.’ ");
INSERT INTO rol_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Nganì nagkadto sinda kag nagtrabaho. Nang mga alas dose na, nagkadto siya liwat sa merkado, imaw da ang iya ginghuman pag-abot nang mga alas tres ng hapon. ");
INSERT INTO rol_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Nang mga alas singko na, nagkadto siya liwat sa merkado kag may nakità pa gid siya nga mga nagaistambay. Hambay niya sa inda, ‘Basì nagaistambay lang kamo diri sa bilog nga adlaw?’ ");
INSERT INTO rol_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Nagsabat sinda, ‘Kay wayà busà may nagapatrabaho sa amon.’ Naghambay ang tag-iya sa inda, ‘Kadto kamo sa akon ubasan kag magtrabaho.’ ");
INSERT INTO rol_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Nang manayumsom na, naghambay ang tag-iya sa iya katiwalà, ‘Tawaga ang mga nagatrabaho kag suhuyan. Unaha ang naulihi hasta sa nauna.’ ");
INSERT INTO rol_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ang mga nagtrabaho nang alas singko hay gingsuhuyan ning isa ka denarius. ");
INSERT INTO rol_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nang magpalapit na ang mga nauna, ang kalaom ninda hay mas dakò ang inda mababaton kaysa sa mga ulihi nagtrabaho. Pero ang kada isa sa inda hay gingsuhuyan da ning tig-isa ka denarius. ");
INSERT INTO rol_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pagkabaton ninda ng suhoy, nagreklamo sinda sa tag-iya. ");
INSERT INTO rol_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Naghambay sinda, ‘Ang mga naulihi, isa lang ka oras ang inda trabaho, pero kami hay isa gid ka adlaw ang amon pag-antos sa init, pero basì pareho lang ang imo gingsuhoy sa amon?’ ");
INSERT INTO rol_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Pero nagsabat ang tag-iya sa isa sa inda, ‘Amigo, wayà ta ikaw pagdayaa. Dì ba nagkasugot kita nga isa ka denarius ang adlaw? ");
INSERT INTO rol_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Batuna ang imo suhoy kag mag-ulì ka na. Kay akon ini kagustuhan nga ang itao nga suhoy sa naulihi, imaw da ang itao ko sa imo! ");
INSERT INTO rol_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Dì ba pagusto ako sa akon kwarta kung unhon ko kay akon ini? Naili ka lang baya kay maatag ako sa inda.’ ” ");
INSERT INTO rol_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Pagkatapos naghambay si Hesus, “Imaw da inà ang matatabò sa katapusan nga mga adlaw. Ang mga naulihi niyan hay mauuna kag ang mga nauna niyan hay mauulihi.” ");
INSERT INTO rol_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Mintras nagatukad sina Hesus pa Jerusalem, gingbuyag niya ang iya dose nga disipulo sa mga tawo. ");
INSERT INTO rol_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Nang nagapanaw sinda, naghambay siya, “Pamatì kamo! Nagapatukad kita sa Jerusalem kag didto itugyan ako nga Ungà ng Tawo* sa mga pinunò nga parì kag mga eskriba kag husgahan ninda ako nga patyon. ");
INSERT INTO rol_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Kag itugyan ninda ako sa mga bukon Judio para insultuhon, latiguhon kag ilangsang sa krus. Pero sa ikatuyo ka adlaw mabanhaw ako.” ");
INSERT INTO rol_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Pagkatapos nagpalapit kay Hesus ang asawa ni Zebedee kaibahan ang iya duha ka ungà nga lyaki. Nagluhod siya sa atubangan ni Hesus para mangabay. ");
INSERT INTO rol_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Gingpangutana siya ni Hesus, “Ano ang imo gusto?” Nagsabat siya, “Kung puydi, pag magharì ka na sa imo gingharian, papungkua ang akon duha ka ungà sa imo alihid, ang isa sa imo tuo kag ang isa hay sa imo waya.” ");
INSERT INTO rol_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Pero nagsabat si Hesus sa inda, “Wayà nindo nasasayuri kung ano ang indo ginapangayò. Maagihan ba nindo ang mga kahugaan nga akon maagihan?” Nagsabat sinda, “Huo, kaya namon.” ");
INSERT INTO rol_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Naghambay si Hesus sa inda, “Matuod gid nga maagihan nindo ang kahugaan nga akon aagihan. Pero bukon ako ang magapilì kung sin-o ang papungkuon sa akon tuo kag waya. Kay may mga gingtagan-an na ang akon Amay para magpungkò didto.” ");
INSERT INTO rol_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nang mabatian ng napuyò ka disipulo kung ano ang inda gingpangayò, nahangit gid sinda sa duha nga magmanghod. ");
INSERT INTO rol_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Nganì gingtawag sinda tanan ni Hesus kag ginghambayan, “Sayod nindo nga ang mga miyugdumaya ng mga bukon Judio sa ini nga kalibutan hay may otoridad sa inda mga sinakupan kag pagusto lang sinda kung ano ang humanon sa inda. ");
INSERT INTO rol_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pero bukon tiyad inà sa indo. Kay kung sin-o sa indo ang gusto nga maging labaw sa tanan, dapat maging suluguon nindo. ");
INSERT INTO rol_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Kag kung sin-o sa indo ang gusto maging pinunò, dapat maging ulipon ng iban. ");
INSERT INTO rol_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Aber nganì ako nga Ungà ng Tawo hay wayà nagkari diri sa kalibutan para magpaserbisyo kundì magserbisyo kag magtao ng akon kabuhì agud matubos ang madamò nga tawo.” ");
INSERT INTO rol_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Mintras nagapaluwas sina Hesus sa Jerico, kadamò nga tawo ang nagasunod sa iya. ");
INSERT INTO rol_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Niyan, may duha ka buta didto nga nagapungkò sa alihid ng karsada. Pagkabatì ninda nga nagaagi si Hesus, nagsinggit sinda, “Ginoo! Inapo ni David, kaluy-i kami!” ");
INSERT INTO rol_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Gingsabyaw sinda ng mga tawo nga maghipos. Pero gingkusugan pa gid ninda ang pagsininggit, “Ginoo! Inapo ni David, kaluy-i kami!” ");
INSERT INTO rol_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Nagduyog si Hesus, gingtawag sinda kag gingpangutana, “Ano ang gusto nindo nga humanon ko para sa indo?” ");
INSERT INTO rol_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Nagsabat sinda, “Ginoo, gusto namon makakità!” ");
INSERT INTO rol_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Naluoy gid si Hesus sa inda, nganì gingtandog niya ang inda mga mata. Kag adto nga daan nakakità na sinda kag nagnunot sa iya. ");
INSERT INTO rol_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nang malapit na sina Hesus sa Jerusalem kag nag-abot sa baryo ng Betfage, sa Bukid ng mga Olibo*, gingpauna ni Hesus ang iya duha ka disipulo. ");
INSERT INTO rol_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Naghambay siya sa inda, “Mag-una kamo didto sa masunod nga baryo. Pagsuyod nindo didto, makikità nga daan nindo ang asno nga nakahigot kaibahan ang iya pitò. Hubara ang inda higot kag day-a sinda diri sa akon. ");
INSERT INTO rol_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kung may magpangutana sa indo, sabata nindo, ‘Kahinangyan ini ng Ginoo’ kag tugutan niya kamo nga daan.” ");
INSERT INTO rol_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ini hay natabò para matuman ang ginghambay ng propeta*. ");
INSERT INTO rol_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Hambayon nindo ang mga taga-Zion, pakarion na ang indo harì. Mapinaubuson siya kag nagasakay sa asno, sa batà nga asno.” ");
INSERT INTO rol_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Nganì nagpanaw ang duha ka disipulo kag gingtuman ninda ang gingbilin ni Hesus. ");
INSERT INTO rol_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Pagkatapos adto gingdaya ninda kay Hesus ang asno kaibahan ang iya pitò. Pag-abot didto, ginghapinan ninda ini ng inda mga barò nga pangsuy-ob kag nagsakay si Hesus. ");
INSERT INTO rol_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Madamò nga tawo ang naglatag ng inda mga pangsuy-ob sa karsada. Ang iban naman nagbutang ning mga sanga ng kahoy nga inda ging-utod. ");
INSERT INTO rol_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ang mga tawo nga nagauna kay Hesus kag ang nagasunod hay nagasinggit, “Hosana! Dayawon ang inapo ni David! Ginapakamaayo ng Ginoo ang iya gingsugò! Hosana! Dayawon ang Dios nga pinakamataas gid sa tanan!” ");
INSERT INTO rol_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Pagsuyod ni Hesus sa Jerusalem, nagkinagulo ang tanan nga tawo didto. Nagpangutana sinda, “Sin-o inà nga tawo?” ");
INSERT INTO rol_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Nagsabat ang kadamuan, “Siya ang propeta nga si Hesus, taga-Nazaret nga sakop ng Galilea.” ");
INSERT INTO rol_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Pag-abot nina Hesus sa Jerusalem, nagsuyod siya sa templo kag gingpalayas niya didto ang mga miyugbaligyà kag nagapamakay sa suyod ng templo. Gingpamaliskad niya ang mga lamisa ng mga miyugbaylo ning kwarta* kag ang mga pungkuan ng mga miyugbaligyà ning mga salampati nga panghalad. ");
INSERT INTO rol_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Hambay niya, “Ginahambay ng Kasulatan, ‘Tawagon ang akon bayay nga bayay nga pangamuyuan.’ Pero kamo! Ginahuman nindo nga panaguan ng mga tulisan!” ");
INSERT INTO rol_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","May mga buta kag mga pakì nga nagpalapit sa iya didto sa templo kag sinda hay gingpang-ayo niya. ");
INSERT INTO rol_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nahangit ang mga pinunò nga parì kag ang mga eskriba nang makità ninda ang mga makatitingaya nga butang nga iya ginahuman kag nang mabatian ninda ang ginasinggit ng mga kaungaan, “Dayawon ang inapo ni David!” ");
INSERT INTO rol_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Nganì naghambay sinda kay Hesus, “Nababatian mo ba ang inda ginahambay?” Nagsabat si Hesus, “Huo. Wayà ba nindo nabasahi ang ginahambay ng Kasulatan, ‘Ginatudluan mo ang mga ungà kag mga lapsag nga magdayaw ning maayo sa imo’?” ");
INSERT INTO rol_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Pagkatapos gingbayaan sinda ni Hesus. Tapos nagluwas siya sa syudad ng Jerusalem kag nagkadto sa Betania kag didto siya nagpaligad ning gab-i. ");
INSERT INTO rol_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Pagkaaga, nang pabalik si Hesus sa Jerusalem, nagutom siya. ");
INSERT INTO rol_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","May nakità siya nga kahoy nga igos* sa alihid ng dayan. Gingpalapitan niya ini kung may bunga. Pero wayà siya ning may makità nga bunga kundì puro lang dahon. Naghambay siya sa kahoy, “Tunà niyan, indì ka na makapamunga!” Kag adto nga daan nalayà ang kahoy. ");
INSERT INTO rol_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nang makità ini ng iya mga disipulo, natingaya gid sinda. Hambay ninda, “Basì nalayà nga daan ining kahoy nga igos?” ");
INSERT INTO rol_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Nagsabat si Hesus sa inda, “Sa matuod lang ginahambay ko sa indo, kung may pagtuo kamo kag wayà nagapangduha-duha, mahuhuman da nindo ang ginghuman ko sa kahoy. Kag bukon lang inà kundì makahambay kamo aber pa sa ini nga bukid, ‘Maghalin ka diri kag maglukso sa dagat,’ kag inà hay matatabò. ");
INSERT INTO rol_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kag kung nagatuo kamo, aber ano ang indo pangayuon sa pangamuyò, mababaton gid nindo.” ");
INSERT INTO rol_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Nagsuyod liwat si Hesus sa templo. Mintras nagatudlò siya sa mga tawo, may mga pinunò nga parì kag mga miyugdumaya ng Judio didto nga nagpalapit sa iya kag nagpangutana, “Ano ba ang imo otoridad para humanon ini nga mga butang? Kag sin-o ang nagtao sa imo ng ini nga otoridad?” ");
INSERT INTO rol_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Nagsabat si Hesus, “May ipangutana da ako sa indo. Sabata anay nindo ako, pagkatapos sabaton ko da kamo kung ano ang akon otoridad para humanon ini nga mga butang. ");
INSERT INTO rol_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Kay sin-o naghalin ang otoridad ni Juan para magbawtismo, sa Dios ba o sa tawo?” Kag nag-inistoryahan sinda kung ano ang inda isabat, “Kung magsabat kita, ‘Halin sa Dios’, mangutana naman siya sa aton, ‘Basì wayà kamo nagpati kay Juan?’ ");
INSERT INTO rol_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Pero kung maghambay kita, ‘Halin sa tawo’, mahahangit sa aton ang mga tawo. Nahadlok kita sa mga tawo kay madamò ang nagapati nga si Juan hay propeta.” ");
INSERT INTO rol_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nganì nagsabat sinda kay Hesus, “Wayà kami makasayod.” Naghambay naman si Hesus sa inda, “Indì ko da kamo pagbalitaan kung sin-o ang nagtao sa akon ning otoridad paghuman ng ini nga mga butang.” ");
INSERT INTO rol_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Pagkatapos naghambay pa gid si Hesus sa inda, “Ano sa indo isip ang gusto hambayon ng ini nga istorya? May isa ka tawo nga may duha ka ungà nga lyaki. Nagpalapit siya sa maguyáng kag naghambay, ‘Nonò, magkadto ka arinyan sa ubasan kag magtrabaho.’ ");
INSERT INTO rol_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Nagsabat siya, ‘Indì ako!’ Pero nang ulihi nagbag-o ang iya isip kag nagkadto da siya sa ubasan kag nagtrabaho. ");
INSERT INTO rol_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nagpalapit ang tatay sa manghod kag imaw da ang iya ginghambay. Nagsabat ang manghod, ‘Huo, Tay,’ pero wayà siya nagkadto. ");
INSERT INTO rol_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Diin sa duha ang nagtuman sa sugò ng inda tatay?” Nagsabat sinda, “Ang panganay.” Naghambay si Hesus sa inda, “Sa matuod lang ginahambay ko sa indo, nauna pa sa indo magpasakop sa paghaharì ng Dios ang mga miyugsukot ning buhis kag ang mga babayi nga nagapabayad. ");
INSERT INTO rol_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kay si Juan nga Miyugbawtismo nagkari diri kag nagtudlò sa indo ng tamà nga paagi para maging matarong kamo, pero wayà kamo nagpati sa iya. Ang mga miyugsukot ning buhis kag ang mga babayi nga nagapabayad imaw ang nagpati sa iya. Kag aber nakità na nindo ini, wayà gihapon nagbag-o ang indo isip kag magpati sa iya.” ");
INSERT INTO rol_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Naghambay si Hesus sa inda, “Pamatii nindo ang isa pa gid nga parabola*. May isa ka tawo nga nagpatanom ning ubas sa iya dutà. Gingpakurayan niya ini palibot kag nagpahuman siya ning buhò sa mabahoy nga bato para pugaan ning ubas*. Nagpaugdok da siya ning isa ka lantawan. Pagkatapos gingpabantayan niya ang ubasan kag nagkadto siya sa malayò nga lugar. ");
INSERT INTO rol_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Nang tyempo na ng tigpamupò ning ubas, gingsugò niya ang iya mga ulipon sa mga bantay para magbuoy ng iya parte. ");
INSERT INTO rol_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pero pag-abot didto ng mga ulipon, gingdakop sinda ng mga miyugbantay. Gingsinumbag ninda ang isa, gingpatay ang isa pa kag gingbugoy pa gid ninda ang isa. ");
INSERT INTO rol_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Pagkatapos gingsugò ng tag-iya ang mas kadamò pa gid nga ulipon kaysa sa una. Pero imaw da gihapon ang ginghuman sa inda. ");
INSERT INTO rol_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Nang ulihi gingsugò niya ang iya ungà nga lyaki kay nagahunahunà siya, ‘Tahuron ninda ang akon ungà.’ ");
INSERT INTO rol_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pero nang makità ng mga bantay ang iya ungà, naghambay sinda sa isa kag isa, ‘Yari na ang miyugpanublì. Kari, patyon ta para maging aton na ang iya panublion.’ ");
INSERT INTO rol_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Nganì gingdakop ninda siya kag gingpilak didto sa luwas ng ubasan kag gingpatay.” ");
INSERT INTO rol_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Pagkatapos nagpangutana si Hesus, “Kung magbalik ang tag-iya ng ubasan, ano baya ang iya humanon sa adto nga mga bantay?” ");
INSERT INTO rol_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Nagsabat sinda, “Patyon gid niya adtong malain nga mga bantay kag indì gid niya pagkaluy-an. Pagkatapos pabantayan niya ang iya ubasan sa iban nga mga bantay nga magatao ng iya parte sa kada ani.” ");
INSERT INTO rol_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Naghambay pa si Hesus sa inda, “Wayà ba nindo nabasahi ang ginahambay ng Kasulatan? ‘Ang bato nga gingpilak ng mga panday, imaw gid ang naging pinakaimportante nga bato sa pundasyon; ini hay ginghuman ng Ginoo kag makatitingaya ini sa aton!’ ” ");
INSERT INTO rol_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Naghambay pa gid si Hesus, “Nganì ginahambay ko sa indo, indì na kamo pagaharian ng Dios kundì ang mga tawo nga nagatuman sa iya mga ginapahuman. ");
INSERT INTO rol_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ang aber sin-o nga mahuyog sa ini nga bato hay mababalian kag ang aber sin-o nga mahuyugan ng ini nga bato hay matutumok.” ");
INSERT INTO rol_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nang mabatian ng mga pinunò nga parì kag mga Pariseo ang mga parabola ni Hesus, nasayuran ninda nga sinda ang ginapatamaan. ");
INSERT INTO rol_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Nganì gusto ninda nga dakpon si Hesus, pero nahadlok sinda sa mga tawo kay nagapati gid sinda nga propeta si Hesus. ");
INSERT INTO rol_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Nagtudlò liwat si Hesus sa inda paagi sa parabola. ");
INSERT INTO rol_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Hambay niya, “Ang paghaharì ng Dios puydi ikumpara sa isa ka harì nga nagpreparar ng punsyon para sa kasay ng iya ungà nga lyaki. ");
INSERT INTO rol_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Gingsugò niya ang iya mga ulipon nga agdahon na ang mga tawo nga iya gingpang-imbitar. Pero wayà nagkadto ang mga imbitado. ");
INSERT INTO rol_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Gingsugò niya liwat ang iban pa nga mga ulipon. Naghambay siya, ‘Hambaya nindo ang mga ging-imbitar nga naihaw ko na ang mga baka kag ang iban nga mga hayop nga akon gingpatambok kag preparado na ang pagkaon. Nganì magkari na kamo diri sa punsyon.’ ");
INSERT INTO rol_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pero ang mga imbitado hay wayà nagpanginano. Ang isa nagkadto sa iya uma kag ang isa sa iya negosyo. ");
INSERT INTO rol_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ang iban naman hay gingdakop ang mga gingsugò ng harì, gingsakit ninda kag gingpatay. ");
INSERT INTO rol_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Nganì nahangit gid ang harì. Gingsugò niya ang iya mga sundalo nga patyon ang nagpatay ng iya mga ulipon kag sunugon ang inda syudad. ");
INSERT INTO rol_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Pagkatapos gingtawag niya ang iya mga ulipon kag naghambay, ‘Ang punsyon sa kasay ng akon ungà hay preparado na, ugaling bukon angay ang mga ging-agda. ");
INSERT INTO rol_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Nganì kadto na lang kamo sa mga karsada nga may kadamò nga nagaagi kag imbitaron nindo ang tanan nga indo masumpong.’ ");
INSERT INTO rol_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Nagkadto ang mga ulipon sa mga karsada kag ang tanan nga inda nasumpong, maayo man o malain, hay gingpang-imbitar ninda. Kag napunò ng tawo ang lugar para sa kasayan. ");
INSERT INTO rol_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Malagat-lagat, nagsuyod ang harì kay gusto niya nga makità ang mga bisita. May nakità siya didto nga isa ka tawo nga wayà nakasuksok ning barò pangkasay. ");
INSERT INTO rol_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Nganì nagpangutana ang harì sa iya, ‘Amigo, basì nakasuyod ka diri nga wayà nakabarò ning pangkasay?’ Pero adtong tawo hay wayà gid ning may naisabat. ");
INSERT INTO rol_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Nganì naghambay ang harì sa iya mga suluguon, ‘Gapusa nindo ang iya kamot kag siki kag ipilak sa luwas, didto sa kaduyom-duyom kung sa diin magadinanguyngoy siya kag magapinagot ang iya ngipon.’ ” ");
INSERT INTO rol_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Pagkatapos, naghambay si Hesus, “Kadamò ang ginatawag ng Dios, pero kalakà lang ang gingpilì.” ");
INSERT INTO rol_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Pagkatapos naghalin ang mga Pariseo kag nagplano sinda kung pauno ninda maakusar si Hesus paagi sa iya ginapanghambay. ");
INSERT INTO rol_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nganì gingpakadto ninda kay Hesus ang inda mga disipulo kaibahan ang mga miyembro ng grupo ni Herodes. Nagpangutana sinda sa iya, “Maestro, nasayuran namon nga matuod ang imo ginahambay. Wayà ka nagapadaya-daya sa mga tawo aber sin-o pa sinda, kay wayà ka ning may ginapalabi. Kung ano ang kamatuuran parti sa kabubut-on ng Dios sa mga tawo imaw gid ang imo ginatudlò. ");
INSERT INTO rol_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ano baya sa imo, ginatugutan ba ng Kasuguan nga kita nga mga Judio hay magbayad ning buhis sa Emperador ng Roma o indì?” ");
INSERT INTO rol_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pero sayod ni Hesus ang inda malain nga hunahunà. Nganì naghambay siya sa inda, “Mga hipokrito! Basì baya ginatistingan nindo ako? ");
INSERT INTO rol_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Pakitaan sa akon ang isa ka denarius nga pambayad sa buhis.” Kag gingday-an siya ning isa ka bilog. ");
INSERT INTO rol_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Pagkatapos nagpangutana siya sa inda, “Kanin-o hitsura kag pangayan ang makikità diri?” ");
INSERT INTO rol_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Nagsabat sinda, “Sa Emperador.” Naghambay si Hesus sa inda, “Kung tiyad inà, itao nindo sa Emperador ang sa Emperador kag sa Dios ang sa Dios.” ");
INSERT INTO rol_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nang mabatian ninda ang sabat ni Hesus, natingaya gid sinda. Nganì naghalin na lang sinda. ");
INSERT INTO rol_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nang adto nga adlaw, may mga Saduceo* ang nagpalapit kay Hesus. Ini nga mga tawo hay wayà nagapati nga may pagkabanhaw. ");
INSERT INTO rol_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Nagpangutana sinda, “Maestro, gingtudlò ni Moises nga kung mamatay ang lyaki nga wayà makaungà, dapat ang iya manghod nga lyaki ang mag-asawa sa bayo agud makaungà siya para sa iya maguyáng nga namatay. ");
INSERT INTO rol_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Niyan, igwa ning pito ka magmanghod nga lyaki. Nag-asawa ang kamaguyangan kag namatay nga wayà ning ungà. Nganì ging-asawa ang bayo ng masunod nga manghod. ");
INSERT INTO rol_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Pero imaw da ang natabò sa ikaduha kag ikatuyo nga magmanghod, hasta sa ikapito. Namatay sinda tanan nga wayà gid makaungà. ");
INSERT INTO rol_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Nang ulihi namatay da ang babayi. ");
INSERT INTO rol_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Niyan, kung mag-abot na ang pagkabanhaw, sin-o gid sa pito ang iya asawa? Kay sinda tanan hay naasawa niya.” ");
INSERT INTO rol_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Pero nagsabat si Hesus sa inda, “Salà gid kamo, kay wayà kamo nakakaintindi ng Kasulatan kag ng gahom ng Dios. ");
INSERT INTO rol_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kay pag banhawon ang mga tawo, indì na sinda mag-asawa kundì pareho na sinda ng mga anghel sa langit. ");
INSERT INTO rol_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Kung parti sa pagkabanhaw, wayà ba nindo nabasahi sa Kasulatan ang ginghambay ng Dios sa indo? ");
INSERT INTO rol_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Hambay niya, ‘Ako ang Dios ni Abraham, ang Dios ni Isaac kag ang Dios ni Jacob.’ Ang Dios hay bukon Dios ng mga patay, kundì Dios ng mga buhì.” ");
INSERT INTO rol_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nang mabatian adto ng mga tawo natingaya gid sinda sa iya ginatudlò. ");
INSERT INTO rol_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Nang mabatian ng mga Pariseo nga napahipos ni Hesus ang mga Saduceo, nagtipon sinda liwat kag nagpalapit sa iya. ");
INSERT INTO rol_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ang isa sa inda nga miyugtudlò ng Kasuguan hay nagpangutana kay Hesus para tistingon siya. ");
INSERT INTO rol_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Naghambay siya, “Maestro, ano gid baya ang pinakaimportante nga sugò sa Kasuguan?” ");
INSERT INTO rol_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Nagsabat si Hesus sa iya, “ ‘Higugmaon mo ang Ginoo nga imo Dios sa bilog mo nga tagipusuon, sa bilog mo nga kabubut-on kag sa tanan mo nga hunahunà.’ ");
INSERT INTO rol_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Imaw ini ang pinakaimportante kag una nga sugò. ");
INSERT INTO rol_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Kag ang ikaduha hay imaw ini, ‘Higugmaon mo ang imo isigkatawo pareho ng paghigugmà mo sa imo kaugalingon.’ ");
INSERT INTO rol_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ang bilog nga Kasuguan ni Moises kag ang mga gingsulat ng mga propeta hay nakadepende sa ini nga duha ka sugò.” ");
INSERT INTO rol_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mintras nagatipon-tipon ang mga Pariseo didto, nagpangutana si Hesus sa inda, ");
INSERT INTO rol_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ano ang indo pagkakilaya kay Kristo? Kay sin-o siya inapo?” Nagsabat sinda, “Kay David.” ");
INSERT INTO rol_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Naghambay si Hesus, “Kung tiyad inà, basì si David nga ginatuytuyan ng Espiritu Santo hay nagtawag sa iya nga Ginoo? Tiyad ini ang iya hambay, ");
INSERT INTO rol_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Naghambay ang Ginoo sa akon Ginoo, Pungkò diri sa akon tuo hasta nga maperdi ko kag mapakahuy-an ang imo mga kaaway.’ ");
INSERT INTO rol_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Niyan, kung ginatawag siya ni David nga iya Ginoo, pauno baya nga siya hay inapo lang ni David*?” ");
INSERT INTO rol_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nganì wayà gid ning may nakasabat sa iya pangutana. Tunà adto, wayà na gid ning may nagpangahas nga magpangutana kay Hesus. ");
INSERT INTO rol_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Pagkatapos naghambay si Hesus sa mga tawo kag sa iya mga disipulo, ");
INSERT INTO rol_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Ang mga eskriba* kag mga Pariseo hay ginasaligan nga mag-isplikar ng Kasuguan ni Moises. ");
INSERT INTO rol_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nganì tumana nindo ang inda ginatudlò sa indo, pero ayaw nindo pagsunura ang inda ginahuman kay wayà da ninda ginasunura ang inda ginatudlò. ");
INSERT INTO rol_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ginapapas-an ninda ang mga tawo ning mabug-at nga mga kasuguan, pero wayà gid sinda may ginahuman para buligan ang mga tawo agud magagaan ang inda ginapas-an. ");
INSERT INTO rol_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ang tanan nga ginahuman ninda hay pakità-kità lang sa mga tawo. Ginapalapad ninda ang mga butangan ng hambay ng Dios halin sa Kasulatan sa inda agtang kag braso. Kag gingpahabà ninda ang mga pabitin sa gayad ng inda barò para hambayon nga sinda hay mga diosnanon. ");
INSERT INTO rol_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Sa mga punsyunan kag sa mga sinagoga*, gusto gid ninda magpungkò sa mga pungkuan nga para sa mga importante nga tawo. ");
INSERT INTO rol_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kag sa mga merkado, gusto gid ninda nga abi-abihon kag tahuron sinda kag tawagon nga mga maestro. ");
INSERT INTO rol_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Pero kamo, ayaw kamo magpatawag nga maestro, kay mag-utod kamo kag isa lang ang indo Maestro. ");
INSERT INTO rol_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ayaw da nindo pagtawaga nga amay ang aber sin-o diri sa dutà, kay isa lang gid ang indo Amay, ang Amay nga yadto sa langit. ");
INSERT INTO rol_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kag ayaw da kamo magpatawag nga maestro, kay isa lang ang indo Maestro, ang Kristo. ");
INSERT INTO rol_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ang nagaserbisyo sa iya mga utod, siya ang labaw sa tanan. ");
INSERT INTO rol_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ang aber sin-o nga nagapakataas ng iya kaugalingon hay ginapaubos, pero ang aber sin-o nga nagapaubos ng iya kaugalingon hay ginapataas.” ");
INSERT INTO rol_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Makaluluoy kamo, mga eskriba kag mga Pariseo! Mga hipokrito! Gingsarhan nindo ang pwertahan kung sa diin makasuyod kuntà ang mga tawo sa gingharian ng Dios. Kamo mismo hay indì magsuyod, tapos ginaharangan pa nindo ang mga nagatinguhà nga makasuyod. ");
INSERT INTO rol_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Makaluluoy kamo, mga eskriba kag mga Pariseo! Mga hipokrito! Ginaubos nindo buoy ang mga propidad ng mga bayo kag indo lang ginatabon-tabunan ang indo malain nga ginahuman paagi sa mahabà nga mga pangamuyò. Nganì mas dakò ang parusa nga indo mababaton! ");
INSERT INTO rol_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Makaluluoy kamo, mga eskriba kag mga Pariseo! Mga hipokrito! Nagatabok kamo sa dagat kag nagakadto sa mga lugar para makakumbinsi kamo ning aber isa lang ka tawo nga maging indo tagasunod. Pero ginghuman nindo sinda nga tagasunod nindo nga sobra pa kalain kaysa sa indo kag angay gid nga parusahan sa impyerno. ");
INSERT INTO rol_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Makaluluoy kamo nga mga buta nga miyugtuytoy! Nagatudlò kamo nga kung ang tawo manumpà paagi sa templo, indì na niya kahinangyan magtuman sa iya gingsumpaan. Pero kung manumpà siya paagi sa bulawan ng templo, kahinangyan tumanon gid niya ang iya gingsumpaan. ");
INSERT INTO rol_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mga buang-buang kamo kag buta! Diin ang mas importante, ang bulawan o ang templo nga nagapabalaan sa bulawan? ");
INSERT INTO rol_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Nagatudlò da kamo nga kung ang tawo manumpà sa altar*, indì na kahinangyan nga tumanon niya ang iya gingsumpaan. Pero kung manumpà siya paagi sa ginghalad nga yarà sa altar kahinangyan tumanon gid niya ang iya gingsumpaan. ");
INSERT INTO rol_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mga buta gid kamo! Diin ang mas importante, ang ginahalad o ang altar nga nagapabalaan sa halad? ");
INSERT INTO rol_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ang altar syempre! Nganì kung ang tawo manumpà paagi sa altar, nagapanumpà siya sa altar kag sa tanan nga halad didto. ");
INSERT INTO rol_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Kag kung ang tawo manumpà paagi sa templo, nagapanumpà siya bukon lang sa templo kundì sa Dios da nga nagaistar didto. ");
INSERT INTO rol_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kag kung ang tawo manumpà sa langit, nagapanumpà siya sa trono ng Dios kag sa Dios nga nagapungkò didto. ");
INSERT INTO rol_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Makaluluoy kamo, mga eskriba kag mga Pariseo! Mga hipokrito! Ginatao nindo sa Dios ang ikanapuyò aber ang mga panabyà, pero gingpabay-an nindo ang mas importante nga mga sugò parti sa matarong nga pagkabuhì, pagkamaluluy-on kag pagkamatutom. Dapat nga tiyad ini ang indo ginahuman, pero ayaw da nindo pagpabay-i ang iban nga mga sugò. ");
INSERT INTO rol_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Buta gid kamo nga mga miyugtuytoy! Kamo hay pareho sa tawo nga nagasayà ng sapat-sapat sa iya ginainom pero ginatuyon naman niya ang kabahoy nga sapat pareho sa kamelyo. ");
INSERT INTO rol_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Makaluluoy kamo, mga eskriba kag mga Pariseo! Mga hipokrito! Ginahugasan lang nindo ang luwas ng tasa kag pinggan para masunod ang indo patakaran, pero sa suyod ng indo tagipusuon hay punò ning pagkahakog kag pagkamakasarili. ");
INSERT INTO rol_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Buta kamo nga mga Pariseo! Hugasi anay ang suyod nga parte ng indo tasa kag pinggan, agud ang luwas hay maging malimpyo da. ");
INSERT INTO rol_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Makaluluoy kamo, mga eskriba kag mga Pariseo! Mga hipokrito! Pareho kamo sa mga lubungan nga napinturahan ning putì kag maayo siruon sa luwas, pero sa suyod hay kahigkò kag puro lang tuy-an. ");
INSERT INTO rol_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Tiyad inà kamo, kay sa sirò ng mga tawo daw mga matarong kamo, pero ang matuod, puro pakità-kità lang sa mga tawo kay sa suyod ng indo tagipusuon malain gid kamo.” ");
INSERT INTO rol_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Makaluluoy kamo, mga eskriba kag mga Pariseo! Mga hipokrito! Nagahuman kamo ning mga lubungan ng mga propeta kag mga matarong kag ginapakaayo gid nindo ini. ");
INSERT INTO rol_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Nagahambay kamo, ‘Kung buhì lang kami nang tyempo ng amon mga kalulo-lulohan, indì namon patyon ang mga propeta pareho ng inda ginghuman.’ ");
INSERT INTO rol_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Sa inà nindo nga ginahambay, ginaakò na nindo nga kamo ang mga inapo ng mga miyugpamatay sa mga propeta. ");
INSERT INTO rol_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Sige, tapusa nindo ang gingtunaan ng indo kalulo-lulohan! ");
INSERT INTO rol_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Pareho kamo sa mga sawa! Indì gid kamo makalikaw sa parusa sa impyerno! ");
INSERT INTO rol_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nganì magpamatì kamo! Pakaraon ko sa indo ang mga propeta kag mayad nga mga tawo kag mga manunudlò. Ang iban sa inda hay patyon nindo kag ipalangsang sa krus. Ang iban latiguhon sa indo mga sinagoga kag aber diin sinda magkadto pasakitan nindo sinda. ");
INSERT INTO rol_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Nganì kamo ang magapanabat ng kamatayon ng tanan nga tawo nga matarong magtunà kay Abel hasta kay Zacarias nga ungà ni Berekia. Gingpatay nindo siya didto sa tungà ng templo kag ng altar. ");
INSERT INTO rol_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Sa matuod lang ginahambay ko sa indo, ang parusa sa adto tanan nga pagpatay hay mababaton ng ini nga henerasyon.” ");
INSERT INTO rol_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Kamo nga mga taga-Jerusalem! Ginapatay nindo kag ginapambugoy hasta mamatay ang mga propeta nga gingsugò ng Dios sa indo. Madamò ka beses nga gusto ko kuntà tipunon kamo kag diparahon nga daw sa mungà nga ginakuuban ang iya mga isiw sa idayom ng iya pakpak, pero indì nindo gusto! ");
INSERT INTO rol_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Niyan, pabay-an na kamo ng Dios. ");
INSERT INTO rol_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Tandai nindo ini, indì na gid nindo ako makikità liwat hasta sa pag-abot ng adlaw nga magahambay kamo, ‘Malipayon ang gingpakari diri ng Ginoo.’ ” ");
INSERT INTO rol_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Nagluwas si Hesus sa templo kag nang pahalinon na siya, nagpalapit sa iya ang mga disipulo kag gingtudlò sa iya ang iba-iba nga parte ng templo. ");
INSERT INTO rol_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Naghambay si Hesus sa inda, “Nakikità ba nindo inà tanan? Sa matuod lang ginahambay ko sa indo, inà nga mga bato hay pagatumpagon kag wayà gid ning may mabibilin nga mga bato nga nagapamagtumbaw.” ");
INSERT INTO rol_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Mintras nagapungkò si Hesus didto sa Bukid ng mga Olibo, nagpalapit sa iya ang mga disipulo nang sinda na lang. Nagpangutana sinda, “Balitai kami kung san-o matabò ang mga butang nga imo ginghambay. Kag ano ang tandà nga ikaw hay madalì na lang magbalik diri kag matatapos na ini nga tyempo?” ");
INSERT INTO rol_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Nagsabat si Hesus sa inda, “Mag-andam kamo nga wayà ning may makapatayang sa indo. ");
INSERT INTO rol_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kay kadamò ang magaabot kag magahambay sinda, ‘Ako imaw ang Kristo,’ kag kadamò ang inda mapapatayang. ");
INSERT INTO rol_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Makakabatì kamo nga may mga gira malapit sa indo kag makakasayod kamo nga sa iban nga nasyon nagagira da, pero ayaw kamo mahadlok. Dapat gid ini tanan hay matabò, pero bukon pa ini ang katapusan ng kalibutan. ");
INSERT INTO rol_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Magaininaway ang mga nasyon kag imaw da ang mga gingharian. May magaabot nga mga taggutom kag mga linog sa iba-iba nga lugar. ");
INSERT INTO rol_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ini tanan hay daw pareho ng una nga kasakit nga nababatyagan ng babayi nga tig-uungà na gid. ");
INSERT INTO rol_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Sa adto nga tyempo, mahahangit gid sa indo ang mga tawo sa tanan nga mga nasyon tungod sa indo pagtuman sa akon. Dakpon ninda kamo kag itugyan sa mga tawo para parusahan kag ang iban sa indo hay pagapatyon. ");
INSERT INTO rol_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kag kung mag-abot na ang mga paghingabot, kadamò ang magatalikod sa inda pagtuo. Dumtan ninda kag traiduron ang inda mga kauturan. ");
INSERT INTO rol_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Kadamò ang magapakunukuno nga mga propeta kag kadamò ang inda mapapatayang. ");
INSERT INTO rol_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kag tungod sa pagdamò ng sobra nga kalainan, magapanglamig ang paghigugmà ng kadamuan. ");
INSERT INTO rol_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pero ang nagatiis nga magtuman sa akon hasta sa katapusan imaw ang maluluwas. ");
INSERT INTO rol_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Kag ang Maayong Balità parti sa paghaharì ng Dios hay iwali sa bilog nga kalibutan para makasayod ang tanan nga mga tawo, bago mag-abot ang katapusan.” ");
INSERT INTO rol_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Naghambay pa gid si Hesus, “Pag makità nindo nga ginapatindog na sa balaan nga lugar ang kalain-lain gid nga butang nga gingpropesiya ni Propeta Daniel (kamo nga nagabasa, intindihon gid nindo kung ano ang gusto hambayon ini), ");
INSERT INTO rol_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ang yadto sa Judea dapat magbakwit na pakadto sa kabukiran. ");
INSERT INTO rol_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ang matabuan nga yarà sa luwas ng iya bayay hay indì na dapat magsuyod para magbuoy ning aber ano. ");
INSERT INTO rol_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ang matabuan nga yadto sa uma hay indì na dapat magbalik para magbuoy ng iya pangsuy-ob. ");
INSERT INTO rol_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Sa adto nga tyempo, makaluluoy ang mga nabdos kag ang mga nagapasuso kay mahuhugaan gid sinda magbakwit! ");
INSERT INTO rol_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Magpangamuyò kamo nga ang indo pagbakwit hay indì matabò sa tiglalamig o sa Adlaw nga Inugpahuway*. ");
INSERT INTO rol_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kay sa adto nga tyempo, magaabot ang sobra nga kahugaan nga wayà pa gid natabò magtunà nang gingtuga ang kalibutan hasta niyan kag indì na matatabò pa hasta san-o. ");
INSERT INTO rol_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kung indì patag-uron ng Dios adto nga tyempo, wayà gid ning may maluwas. Pero tungod sa kaluoy niya sa iya mga gingpilì, patag-uron niya adto nga tyempo. ");
INSERT INTO rol_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Nganì kung may maghambay sa indo, ‘Yari ang Kristo!’ o ‘Yadto siya didto!’, ayaw kamo magpati. ");
INSERT INTO rol_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kay may magaabot nga bukon matuod nga mga kristo kag bukon matuod nga mga propeta. Magahuman sinda ning mga milagro kag makatitingaya nga butang para patayangon, kung puydi, aber pa ang mga gingpilì ng Dios. ");
INSERT INTO rol_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nganì tandai nindo, ginahambay ko na ini nga daan sa indo bago pa matabò. ");
INSERT INTO rol_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Nganì kung may maghambay sa indo, ‘Si Kristo hay yadto sa tiway nga lugar!’ ayaw kamo magkadto. Kag kung may maghambay, ‘Yadto siya sa tagò nga lugar,’ ayaw gid kamo magpati. ");
INSERT INTO rol_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kay ang pagbalik ko nga Ungà ng Tawo hay makikità ng tanan kay pareho ini sa kilat nga ang iya kahayag hay makità magtunà sa este hasta sa weste. ");
INSERT INTO rol_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","May hambayanon nga tiyad ini, ‘Kung diin ang may patay nga lawas, didto nagatipon ang mga buwitri.’ ” ");
INSERT INTO rol_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Pagkatapos ng mga kahugaan sa adto nga tyempo, sa nga daan magaduyom ang adlaw, indì na magahayag ang bulan kag magakahuyog ang mga bituon. Ang mga butang sa kalangitan hay magatayang sa inda dati nga mga pwesto. ");
INSERT INTO rol_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Pagkatapos makikità sa langit ang tandà ng Ungà ng Tawo kag magadinanguyngoy ang tanan nga mga tawo sa bilog nga kalibutan. Makikità ninda ako nga Ungà ng Tawo sa mga panganod nga nagabalik sa kalibutan nga may gahom kag may sobra nga kasilaw. ");
INSERT INTO rol_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Pagkatapos may mababatian nga makusog nga tunog ng trumpeta kag susuguon ko ang akon mga anghel para tipunon ang akon mga gingpilì halin sa tanan nga lugar ng kalibutan.” ");
INSERT INTO rol_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Magtuon kamo ng leksyon parti sa kahoy nga igos*. Kung nagapanaybos ang iya mga sanga, sayod na nindo nga malapit na ang tag-init. ");
INSERT INTO rol_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Imaw da, kung makità nindo nga nagakatabò na ini tanan ang akon ginahambay, masasayuran nindo nga madalì na lang ako mag-abot. ");
INSERT INTO rol_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Sa matuod lang ginahambay ko sa indo, magakatabò ini tanan bago mamatay ang mga tawo sa ini nga henerasyon. ");
INSERT INTO rol_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Maduduyà ang langit kag ang dutà, pero ang akon mga hambay hay indì maduyà kundì matutuman gid ini.” ");
INSERT INTO rol_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Kung parti sa adlaw kag oras ng akon pag-abot, wayà gid ning may nakakasayod aber ang mga anghel sa langit o ako nga Ungà ng Dios, kundì ang Amay lang gid. ");
INSERT INTO rol_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kung ano ang natabò nang tyempo ni Noe, imaw da ang matatabò sa mga adlaw ng pagbalik ko nga Ungà ng Tawo. ");
INSERT INTO rol_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Nang adto nga tyempo, bago nagbahà sa kalibutan, ang mga tawo hay nagakinaon, nagaininom kag nagainasawa hasta sa adlaw nga nagsuyod si Noe sa arka. ");
INSERT INTO rol_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Wayà gid sinda kamalay-malay kung ano ang matatabò hasta nag-abot ang bahà kag nagkalumos sinda tanan. Imaw da ini ang matatabò pag ako nga Ungà ng Tawo mag-abot. ");
INSERT INTO rol_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Adto nga adlaw, may duha ka lyaki nga nagatrabaho sa tanuman, ang isa hay pagabuy-on kag ang isa ibilin. ");
INSERT INTO rol_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Igwa ning duha ka babayi nga nagabayo, ang isa hay pagabuy-on kag ang isa ibilin. ");
INSERT INTO rol_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Nganì magbantay kamo, kay wayà kamo makakasayod kung ano nga adlaw magaabot ang indo Ginoo. ");
INSERT INTO rol_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Tandai nindo ini, kung sayod lang ng tag-iya ng bayay kung ano nga oras sa gab-i maabot ang miyugpangawat, babantayan gid niya ang iya bayay para indì ini masuyod. ");
INSERT INTO rol_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Nganì kamo da hay dapat magpreparar kay magaabot ang Ungà ng Tawo sa oras nga wayà nindo ginapaabot.” ");
INSERT INTO rol_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Ang masaligan kag kamayad nga ulipon imaw ang ginapilì ng amo agud magdumaya sa iban nga mga suluguon sa bayay. Siya ang nagatao sa inda ning pagkaon kada adlaw. ");
INSERT INTO rol_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Bulahan adto nga ulipon pag maabutan siya ng iya amo nga nagahuman ng iya trabaho. ");
INSERT INTO rol_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Sa matuod lang ginahambay ko sa indo, padumayahon siya ng iya amo sa tanan niya nga propidad. ");
INSERT INTO rol_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero kung malain adto nga ulipon, mahambay siya sa iya kaugalingon, ‘Madugay pa ang pagbalik ng akon amo.’ ");
INSERT INTO rol_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Tapos pagapintasan niya ang iya mga kapareho nga ulipon kag magakinaon siya, magaininom kaibahan ng mga buratso. ");
INSERT INTO rol_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Magaabot ang iya amo sa adlaw nga wayà niya ginapaabota kag sa oras nga wayà niya masasayuri, ");
INSERT INTO rol_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","kag parusahan gid siya ning sobra ng iya amo. Tapos ilalakot siya sa mga hipokrito kag didto sinda hay magadinanguyngoy kag magapinagot ang inda ngipon.” ");
INSERT INTO rol_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Nagpadayon si Hesus sa iya paghambay, “Ang paghaharì ng Dios hay puydi ikumpara sa ini nga parabola. May napuyò ka dalaga nga nagdaya ng inda mga iwagan para magsugat sa isa ka lyaki nga kyasayon. ");
INSERT INTO rol_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ang lima sa inda hay kaburoy kag ang lima hay kamayad. ");
INSERT INTO rol_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ang lima nga buroy, nagdaya ng inda iwagan, ugaling wayà sinda nagdaya ning reserba nga lana. ");
INSERT INTO rol_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ang mga dalaga nga mayad, nagdaya da ng inda mga iwagan kag igwa pa gid sinda ning reserba nga lana. ");
INSERT INTO rol_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kag tungod naatraso ang kyasayon nga lyaki pinilaw sinda nganì nakakatuyog. ");
INSERT INTO rol_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Nang tungang gab-i na may nagsinggit, ‘Yari na ang kyasayon! Luwas na kamo kag sugata nindo!’ ");
INSERT INTO rol_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nagbatì ang napuyò ka dalaga kag gingpreparar ninda ang inda mga iwagan. ");
INSERT INTO rol_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Pagkatapos ang mga dalaga nga buroy naghambay sa mga mayad, ‘Taw-i abi kami ng indo lana kay nagaandap-andap na ang amon iwagan.’ ");
INSERT INTO rol_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Pero nagsabat sinda, ‘Indì puydi, kay kung taw-an namon kamo pareho kita nga kukuyangon. Kadto na lang kamo sa mga tindahan kag magbakay ng para sa indo.’ ");
INSERT INTO rol_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Nganì nagpanaw sinda para magbakay kag imaw da adto ang oras nga nag-abot ang kyasayon. Ang lima nga nakapreparar hay nakaibahan sa iya sa punsyon. Pagsuyod ninda didto, gingsarhan na ang pwertahan. ");
INSERT INTO rol_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Wayà madugay, nag-abot naman ang lima ka dalaga nga nagbakay ning lana kag nagpanawag, ‘Ginoo, Ginoo, pasuyura kami!’ ");
INSERT INTO rol_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Pero nagsabat siya, ‘Sa matuod lang ginahambay ko sa indo, wayà ko kamo nakikilaya.’ ” ");
INSERT INTO rol_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Pagkatapos naghambay si Hesus, “Nganì magbantay gid kamo kay wayà kamo makakasayod kung ano nga adlaw o oras ako maabot.” ");
INSERT INTO rol_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Naghambay pa gid si Hesus, “Ang paghaharì ng Dios puydi ikumpara sa isa ka tawo nga mabyahe sa iban nga lugar. Bago siya naghalin, gingtawag niya ang iya mga ulipon kag gingbilin sa inda ang iya kwarta para inegosyo ninda. ");
INSERT INTO rol_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ang kada isa sa inda hay gingtaw-an kumpormi sa inda abilidad. Ang isa hay gingtaw-an niya ning 5,000. Ang isa hay 2,000. Kag ang isa pa gid hay gingtaw-an niya ning 1,000. Pagkatapos nagpanaw na siya. ");
INSERT INTO rol_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ang ulipon nga nakabaton ning 5,000 nagnegosyo nga daan kag nakaganansya siya ning 5,000. ");
INSERT INTO rol_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Imaw da ang ginghuman ng nakabaton ning 2,000 kag nakaganansya da siya ning 2,000. ");
INSERT INTO rol_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pero ang nakabaton ning 1,000 hay nagluwas kag nagkutkot sa dutà kag ginglubong ang kwarta nga gingbilin ng iya amo. ");
INSERT INTO rol_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Pagkaligad ng mahabà nga tyempo, nagbalik ang inda amo kag gingtawag niya ang iya mga ulipon para pangutan-on kung pila na ang inda naganansya. ");
INSERT INTO rol_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ang ulipon nga nakabaton ning 5,000 hay nagpalapit kag gingtao niya sa iya amo ang 5,000 nga kapital kag ang 5,000 nga iya ganansya. Naghambay siya, ‘Nong, yari ang 5,000 nga gingbilin mo sa akon kag yari da ang ganansya ko nga 5,000.’ ");
INSERT INTO rol_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Naghambay ang iya amo sa iya, ‘Maayo ka nga ulipon! Masaligan ka! Tungod masaligan ka sa maisot nga kantidad, niyan itugyan ko sa imo ang mas dakò pa gid nga kantidad. Kari na masilibrar kita!’ ");
INSERT INTO rol_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ang ulipon nga nakabaton ning 2,000 hay nagpalapit da. Naghambay siya, ‘Nong, yari ang 2,000 nga gingbilin mo sa akon kag yari da ang ganansya ko nga 2,000.’ ");
INSERT INTO rol_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Naghambay ang iya amo sa iya, ‘Maayo ka nga ulipon! Masaligan ka! Tungod masaligan ka sa maisot nga kantidad, niyan itugyan ko sa imo ang mas dakò pa gid nga kantidad. Kari na masilibrar kita!’ ");
INSERT INTO rol_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Nagpalapit da ang ulipon nga nakabaton ning 1,000. Naghambay siya, ‘Nong, sayod ko nga istrikto ka kag wayà ning kaluoy. Ginaani mo ang patubas aber bukon ikaw ang nagtanom kag ginabuoy mo da ang ganansya ng pinangabudlayan ng iban. ");
INSERT INTO rol_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Hinadlukan ako nganì ginglubong ko na lang sa dutà ang imo kwarta. Yari na ang gingbilin mo nga kwarta sa akon.’ ");
INSERT INTO rol_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Pero naghambay ang iya amo, ‘Malain ka kag matamad nga ulipon! Sayod mo galì nga ginaani ko ang patubas aber bukon ako ang nagtanom kag ginabuoy ko da ang ganansya ng pinangabudlayan ng iban. ");
INSERT INTO rol_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Basì wayà mo ginghuyog ang akon kwarta sa bangko para sa akon pagbalik, mabubuoy ko ang akon kwarta nga may tubò?’ ");
INSERT INTO rol_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Pagkatapos naghambay siya sa iban nga mga ulipon, ‘Buy-a sa iya ang kwarta kag itao sa ulipon nga may 10,000. ");
INSERT INTO rol_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kay ang masaligan taw-an pa gid kag madamò pa ang idudugang sa iya; pero ang indì masaligan, aber ang maisot nga yarà sa iya hay buy-on pa. ");
INSERT INTO rol_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ang ulipon nga wayà ning puyos hay ipilak sa luwas kag didto sa kaduyom-duyom hay magadinanguyngoy siya kag magapinagot ang iya ngipon.’ ” ");
INSERT INTO rol_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Pag-abot ko nga Ungà ng Tawo nga may gahom bilang harì, kaibahan ang tanan nga mga anghel, magapungkò ako sa akon trono. ");
INSERT INTO rol_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ang tanan nga tawo sa kalibutan pagatipunon sa akon atubangan. Pagkatapos lainon ko sinda pareho ng paglain ng pastor* sa iya mga karnero kag mga kambing. ");
INSERT INTO rol_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ang mga matarong nga pareho sa mga karnero hay ibubutang ko sa akon tuo kag ang mga malain nga pareho sa mga kambing hay ibubutang ko sa akon waya. ");
INSERT INTO rol_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Pagkatapos bilang Harì, magahambay ako sa mga tawo sa akon tuo, ‘Kari kamo nga gingpakamaayo ng akon Amay, batuna nindo ang indo panublion sa gingharian ng Dios nga gingpreparar niya para sa indo tunà pa nang gingtuga ang kalibutan. ");
INSERT INTO rol_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kay nang ginggutom ako, gingpakaon nindo; nang ging-uhaw ako gingpainom nindo. Nang naging istranghero ako, gingpadayon nindo; ");
INSERT INTO rol_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","nang wayà ako may gingbarò, gingbaruan nindo. Nang nagmasakit ako, ging-atamanan nindo; nang gingpriso ako, gingbisita nindo ako.’ ");
INSERT INTO rol_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Pagkatapos magahambay ang mga matarong, ‘Ginoo, kasan-o ka namon nakità nga ginggutom kag gingpakaon ka namon, o ging-uhaw kag gingpainom? ");
INSERT INTO rol_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kasan-o ka namon nakità nga naging istranghero kag gingpadayon, o wayà may gingbarò kag gingbaruan? ");
INSERT INTO rol_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kag kasan-o ka namon nakità nga nagmasakit o gingpriso kag gingbisita ka namon?’ ");
INSERT INTO rol_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Magasabat ang Harì, ‘Sa matuod lang ginahambay ko sa indo, kung ginghuman nindo ini sa isa sa kauturan ko, aber siya ang pinakapobre, ginghuman da nindo ini sa akon.’ ");
INSERT INTO rol_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Pagkatapos magahambay naman ako sa mga tawo sa akon waya, ‘Palayò kamo sa akon! Gingsumpà kamo para sa kalayo nga nagadabadaba nga wayà katapusan nga gingpreparar para sa diyablo kag sa iya mga anghel. ");
INSERT INTO rol_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kay ginggutom ako, pero wayà nindo ako gingpakaon, ging-uhaw ako, pero wayà nindo ako gingpainom. ");
INSERT INTO rol_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nang naging istranghero ako, wayà nindo ako gingpadayuna; nang wayà ako may gingbarò, wayà nindo ako gingbarui; nang nagmasakit ako kag gingpriso, wayà nindo ako ging-atamani.’ ");
INSERT INTO rol_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Pagkatapos magasabat sinda, ‘Ginoo, kasan-o ka namon nakità nga ginggutom o ging-uhaw, naging istranghero o wayà may gingbarò, nagmasakit o gingpriso nga wayà ka namon gingbuligi?’ ");
INSERT INTO rol_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Kag magasabat ang Harì, ‘Sa matuod lang ginahambay ko sa indo, kung wayà nindo pagbuligi ang isa sa mga kauturan ko, aber siya ang pinakapobre, ako da ang wayà nindo gingbuligi.’ ");
INSERT INTO rol_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Kag sinda hay pagapalayason kag pagaparusahan sa wayà katapusan. Pero ang mga matarong hay taw-an ning kabuhì nga wayà katapusan.” ");
INSERT INTO rol_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Pagkatapos ng pagtudlò ni Hesus ng adto nga mga butang, naghambay siya sa iya mga disipulo, ");
INSERT INTO rol_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Sayod nindo nga duha na lang ka adlaw bago mag-abot ang Pyesta ng Pagligad ng Anghel* kag ako nga Ungà ng Tawo hay itugyan sa mga tawo para ilangsang sa krus.” ");
INSERT INTO rol_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Adto nga oras didto sa palasyo ni Caifas nga Pinakamataas nga Parì, nagtipon ang mga pinunò nga parì kag ang mga miyugdumaya ng Judio. ");
INSERT INTO rol_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Nagplano sinda kung pauno ninda dakpon si Hesus nga indì masayuran ng mga tawo kag pagkatapos hay patyon. ");
INSERT INTO rol_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Naghambay sinda, “Indì lang naton itamà sa pyesta kay basì kung magkagulo ang mga tawo.” ");
INSERT INTO rol_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Nang yadto si Hesus sa banwa ng Betania, sa bayay ni Simon nga kitungon* dati, ");
INSERT INTO rol_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","may isa ka babayi ang nagpalapit sa iya. May daya siya nga maisot nga tibod nga himò sa alabastro, nga may suyod nga mamahayon gid nga pahumot. Mintras nagakaon si Hesus, gingbubuan niya ning pahumot ang iya uyo. ");
INSERT INTO rol_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nang makità adto ng iya mga disipulo, nahangit sinda kag naghambay, “Taya! Basì baya ginauyakan lang niya inà? ");
INSERT INTO rol_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Puydi kuntà inà ibaligyà sa dakò nga kantidad kag itao ang kwarta sa mga pobre!” ");
INSERT INTO rol_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Pero sayod ni Hesus kung ano ang inda ginahambay, nganì naghambay siya sa inda, “Basì ginagulo nindo ang babayi? Maayo ini ang iya ginahuman sa akon. ");
INSERT INTO rol_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ang mga pobre hay permi nindo kaibahan, pero ako hay indì nindo permi makaibahan. ");
INSERT INTO rol_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Gingbubuan niya ang akon lawas ning pahumot para ipreparar sa akon paglubong. ");
INSERT INTO rol_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Sa matuod lang ginahambay ko sa indo, aber diin iwali ining Maayong Balità sa bilog nga kalibutan, ang iya ginghuman sa akon hay ipamalità da para madumduman siya.” ");
INSERT INTO rol_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Niyan, ang isa sa dose nga disipulo nga ang pangayan hay Judas Iscariote, hay nagkadto sa mga pinunò nga parì. ");
INSERT INTO rol_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Nagpangutana siya sa inda, “Pila ang indo ibayad kung itugyan ko si Hesus sa indo?” Pagkatapos nagbayad sinda kay Judas ning 30 ka bilog nga pilak. ");
INSERT INTO rol_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tunà adto, nagapangità siya ning paagi kung pauno niya itugyan si Hesus sa inda. ");
INSERT INTO rol_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Sa una nga adlaw ng Pyesta ng Tinapay nga wayà ning Pampaalsa*, nagpalapit kay Hesus ang iya mga disipulo kag nagpangutana, “Sa diin mo gusto kami magpreparar ning ihapon para sa Pyesta ng Pagligad ng Anghel?” ");
INSERT INTO rol_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Nagsabat si Hesus, “Kadto kamo sa isa ka tawo sa syudad ng Jerusalem kag hambaya siya, ‘Ginapahambay ng amon Maestro nga nag-abot na ang oras nga pagapatyon siya. Masilibrar siya ng Pyesta ng Pagligad ng Anghel diri sa imo bayay kaibahan ang iya mga disipulo.’ ” ");
INSERT INTO rol_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Nagtuman ang iya mga disipulo kag didto ninda gingpreparar ang ihapon para sa Pyesta ng Pagligad ng Anghel. ");
INSERT INTO rol_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nang manayumsom na, nagpungkò si Hesus kaibahan ang iya dose nga disipulo para mag-ihapon. ");
INSERT INTO rol_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Mintras nagakaon sinda, naghambay si Hesus, “Sa matuod lang ginahambay ko sa indo, isa sa indo ang magatraidor sa akon.” ");
INSERT INTO rol_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nang mabatian ini ng iya mga disipulo, nalisod gid sinda kag kada isa sa inda hay nagpangutana sa iya, “Ginoo, bukon ako, dì ba?” ");
INSERT INTO rol_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Nagsabat si Hesus, “Ang magasawsaw ning tinapay sa hambawan kaibahan ko, imaw ang magatraidor sa akon. ");
INSERT INTO rol_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ako nga Ungà ng Tawo hay pagapatyon sunò sa ginahambay ng Kasulatan, pero makaluluoy gid ang tawo nga magatraidor sa akon nga Ungà ng Tawo. Maayo pa sa iya nga wayà ging-ungà.” ");
INSERT INTO rol_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Pagkatapos naghambay si Judas nga imaw ang magatraidor, “Maestro, bukon ako, dì ba?” Nagsabat si Hesus sa iya, “Ikaw ang naghambay inà.” ");
INSERT INTO rol_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mintras nagakaon sinda, nagbuoy si Hesus ning tinapay. Gingpasalamatan niya ini sa Dios kag gingbuak-buak. Pagkatapos gingtao niya ini sa iya mga disipulo kag naghambay, “Buy-a nindo ini kag kaunon, imaw ini ang akon lawas.” ");
INSERT INTO rol_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Pagkatapos nagbuoy siya ning tasa nga may ilimnon, nagpasalamat sa Dios kag gingtao sa inda nga nagahambay, “Tanan kamo mag-inom ini, ");
INSERT INTO rol_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","kay ini ang akon dugò nga ibubò para mapalig-on ang kasugtanan agud mapatawad ang mga salà ng madamò nga tawo. ");
INSERT INTO rol_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ginahambay ko sa indo, indì na ako ini mag-inom liwat nga ilimnon halin sa ubas hasta sa adlaw nga magainom ako ning bag-o nga klasi ng ilimnon kaibahan nindo sa gingharian ng akon Amay.” ");
INSERT INTO rol_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nagkanta sinda ning pagdayaw sa Dios, pagkatapos nagkadto sinda sa Bukid ng mga Olibo. ");
INSERT INTO rol_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Naghambay si Hesus sa inda, “Ini gid nga gab-i, bayaan nindo ako tanan, kay ginahambay ng Kasulatan, ‘Patyon ko ang pastor kag magkabuyag-buyag ang mga karnero.’ ");
INSERT INTO rol_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pero pagkatapos nga mabanhaw ako, mauna ako sa indo didto sa Galilea.” ");
INSERT INTO rol_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Naghambay si Pedro, “Aber bayaan ka ninda tanan, ako indì gid!” ");
INSERT INTO rol_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Naghambay si Hesus sa iya, “Sa matuod lang ginahambay ko sa imo, sa ini gid nga gab-i bago magtuktuyaok ang suyog, indì mo ako pagkilay-on ning tuyo ka beses.” ");
INSERT INTO rol_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pero naghambay si Pedro, “Indì gid ako maghambay nga wayà ta ikaw makilaya, aber patyon pa ako kaibahan ka!” Imaw da ang ginghambay ng tanan nga disipulo. ");
INSERT INTO rol_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Pagkatapos nagkadto sinda sa lugar nga ginatawag Getsemane. Pag-abot ninda didto, naghambay si Hesus sa iya mga disipulo, “Pungkò kamo diri mintras nagapangamuyò ako didto sa una-unahan.” ");
INSERT INTO rol_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pero gingdaya niya sina Pedro kag ang duha nga ungà ni Zebedee. Pagkatapos nagtunà siya magpangalisod kag naglain ang iya pamatyag. ");
INSERT INTO rol_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nganì naghambay siya sa inda, “Daw mamatay ako kay dakò gid ang akon kalisod. Pabilin kamo diri kag magpamuyaw kaibahan ko.” ");
INSERT INTO rol_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Pagkatapos nagkadto pa gid siya sa una-unahan, nagluhod kag nagpangamuyò. Hambay niya, “Amay, kung puydi lang palayuan ini nga kahugaan nga maabot sa akon. Pero bukon ang akon kabubut-on, kundì ang imo ang dapat matuman.” ");
INSERT INTO rol_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Pagbalik niya sa iya tuyo nga disipulo naabutan niya sinda nga nagakatuyog. Naghambay siya kay Pedro, “Indì ba kamo makapamuyaw kaibahan ko aber isa lang ka oras? ");
INSERT INTO rol_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Magpamuyaw kamo kag magpangamuyò para indì kamo madaog ng pagtintar. Gusto ng indo espiritu nga magtuman ng akon gingbilin sa indo, ugaling maluya ang indo lawas.” ");
INSERT INTO rol_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nagkadto liwat si Hesus sa una-unahan kag nagpangamuyò. Hambay niya, “Amay, kung indì gid puydi nga ilayò ini nga kahugaan kag kahinangyan nga tiison ko gid, ang imo kabubut-on ang matuman.” ");
INSERT INTO rol_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Pagkatapos nagbalik siya liwat sa iya mga disipulo kag naabutan na naman niya sinda nga nagakatuyog, kay ginapilaw gid sinda. ");
INSERT INTO rol_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Gingbayaan sinda liwat ni Hesus kag nagkadto sa una-unahan kag nagpangamuyò. Ikatuyo na niya ini nga pagpangamuyò kag imaw da gihapon ang iya ginghambay. ");
INSERT INTO rol_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Pagkatapos nagbalik siya sa iya mga disipulo kag naghambay, “Nagakatuyog pa ba gihapon kamo kag nagapahuway? Sirua, malapit na ang oras nga ako nga Ungà ng Tawo itugyan sa mga makasasalà! ");
INSERT INTO rol_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Bangon na kamo! Sirua, yari na ang tawo nga nagatraidor sa akon!” ");
INSERT INTO rol_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Mintras nagahambay pa si Hesus, nag-abot si Judas nga isa sa dose nga disipulo. Kaibahan niya ang kadamò gid nga tawo nga may daya nga mga sundang kag mga pamakang. Gingsugò sinda didto ng mga pinunò nga parì kag mga miyugdumaya ng Judio. ");
INSERT INTO rol_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Bago sinda nag-abot, gingbilinan na ng traidor ang mga madakop kung ano ang iya isinyas. Hambay niya “Ang tawo nga akon haruan imaw ang indo ginapangità. Dakpon nindo siya.” ");
INSERT INTO rol_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nganì pag-abot ni Judas, nagpalapit nga daan siya kay Hesus kag naghambay, “Maestro, maayo nga gab-i.” Kag gingharuan niya siya. ");
INSERT INTO rol_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Naghambay si Hesus sa iya, “Amigo, himua na kung ano ang imo gingkari.” Gingpalapitan ninda si Hesus kag gingdakop. ");
INSERT INTO rol_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Adto nga daan ang isa sa mga kaibahan ni Hesus hay naggabot ng iya sundang kag ginglabò ang ulipon ng Pinakamataas nga Parì kag nautod ang iya talinga. ");
INSERT INTO rol_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Naghambay si Hesus sa iya, “Balikan sa tagob ang imo sundang! Ang nagagamit ng sundang hay sa sundang da mamamatay. ");
INSERT INTO rol_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Wayà ka ba makakasayod nga kung magpangayò ako ning bulig sa akon Amay, sa nga daan paday-an niya ako ning dose ka batalyon nga mga anghel? ");
INSERT INTO rol_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero kung humanon ko ini, pauno matuman ang ginghambay ng Kasulatan nga imaw ini ang dapat matabò?” ");
INSERT INTO rol_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Pagkatapos naghambay si Hesus sa mga tawo, “Tulisan ba ako nga kahinangyan gid magdaya pa kamo ning mga sundang kag mga pamakang para dakpon ako? Adlaw-adlaw yadto ako sa templo nagatudlò, basì wayà nindo ako pagdakpa? ");
INSERT INTO rol_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pero ini tanan hay natatabò para matuman ang gingsulat ng mga propeta sa Kasulatan.” Pagkatapos gingbayaan siya ng tanan niya nga disipulo kag nagpangdyagan sinda palayò. ");
INSERT INTO rol_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Gingdaya si Hesus ng mga nagdakop kay Caifas nga Pinakamataas nga Parì. Didto nagatipon ang mga eskriba kag ang mga miyugdumaya ng Judio. ");
INSERT INTO rol_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Si Pedro hay nagsunod da pero malayò kay Hesus. Nagsuyod siya sa dyaag kag nagpungkò didto kaibahan ng mga gwardya. Gusto niya makità kung ano ang matatabò. ");
INSERT INTO rol_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ang mga pinunò nga parì kag ang tanan nga miyembro ng Korte ng mga Judio* hay nagpangità ning mga ebidensya nga bukon matuod kontra kay Hesus para ipapatay siya. ");
INSERT INTO rol_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pero aber kadamò ang nagpalapit kag nagtestigo ning pinusong kontra kay Hesus, wayà sinda ning may nakità nga ebidensya para ipapatay siya. Nang ulihi, may duha ka tawo nga nagpalapit. ");
INSERT INTO rol_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Naghambay sinda, “Nabatian namon ini nga tawo nga naghambay, ‘Kaya kuno niya gubaon ang templo ng Dios kag sa suyod ng tuyo ka adlaw patindugon niya ini liwat!’ ” ");
INSERT INTO rol_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nganì nagtindog ang Pinakamataas nga Parì kag nagpangutana kay Hesus, “Wayà ka ba ning maisasabat sa ini nga mga akusasyon kontra sa imo?” ");
INSERT INTO rol_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pero wayà gid nagsabat si Hesus. Nganì gingpangutana siya liwat ng Pinakamataas nga Parì, “Ginapasumpà ko ikaw sa pangayan ng buhì nga Dios, balitai kami kung ikaw ba ang Kristo nga Ungà ng Dios?” ");
INSERT INTO rol_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Nagsabat si Hesus sa iya, “Ikaw ang naghambay inà. Ginahambay ko sa indo tanan, tunà arinyan, makikità nindo ako nga Ungà ng Tawo nga nagapungkò hampig sa tuo ng Makagagahom nga Dios kag makikità da nindo ako sa mga panganod halin sa langit nga magaabot sa kalibutan.” ");
INSERT INTO rol_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Nang mabatian adto ng Pinakamataas nga Parì ginggisì niya ang iya barò sa kahangit kag naghambay, “Naghambay siya ning malain kontra sa Dios! Indì na kahinangyan ng mga testigo! Nabatian na nindo ang iya paghambay ning malain kontra sa Dios. ");
INSERT INTO rol_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ano ang indo desisyon?” Nagsabat sinda, “Angay gid siya nga patyon!” ");
INSERT INTO rol_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Pagkatapos gingpil-an ninda siya sa hitsura kag gingsumbag kag ang iban nga nagtampà sa iya ");
INSERT INTO rol_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","naghambay, “Kung ikaw ang Kristo, balitai kami kung sin-o ang nagtampà sa imo!” ");
INSERT INTO rol_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Mintras yadto pa si Pedro nagapungkò sa dyaag, may nagpalapit sa iya nga ulipon nga babayi ng Pinakamataas nga Parì kag naghambay, “Kaibahan ka da ni Hesus nga taga-Galilea!” ");
INSERT INTO rol_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pero nagbalibad si Pedro sa atubangan ng tanan. Hambay niya, “Wayà ko masasayuri kung ano ang imo ginahambay.” ");
INSERT INTO rol_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tapos nagkadto siya sa pwertahan paluwas. Nakità siya ng isa pa ka ulipon nga babayi kag naghambay siya sa mga tawo didto, “Ini nga lyaki hay kaibahan ni Hesus nga taga-Nazaret!” ");
INSERT INTO rol_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pero nagbalibad liwat si Pedro kag nagsumpà, “Wayà ko gid nakikilaya ang tawo nga indo ginahambay!” ");
INSERT INTO rol_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Malagat-lagat nagpalapit kay Pedro ang mga tawo didto kag naghambay, “Sigurado gid, ikaw hay isa sa iya mga kaibahan kay ang imo paghambay pareho sa iya.” ");
INSERT INTO rol_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pero nagsumpà gid si Pedro kag naghambay, “Aber mamatay pa ako, wayà ko gid nakikilaya inà nga tawo!” Kag adto nga daan nagtuktuyaok ang suyog. ");
INSERT INTO rol_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Kag nadumduman ni Pedro ang ginghambay ni Hesus, “Bago magtuktuyaok ang suyog, indì mo ako pagkilay-on ning tuyo ka beses.” Nganì nagluwas siya kag nagtinangis gid ning tudo. ");
INSERT INTO rol_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Pagkaaga, nagtipon ang tanan nga pinunò nga parì kag mga miyugdumaya ng Judio para magplano kung pauno ipapatay si Hesus. ");
INSERT INTO rol_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ginggapos ninda siya kag gingdaya agud itugyan kay Gobernador Pilato. ");
INSERT INTO rol_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Nang masayuran ni Judas nga imaw ang nagtraidor kay Hesus nga gingparusahan na siya nga patyon, gingbasoy niya ang iya kaugalingon. Nagkadto siya sa mga pinunò nga parì kag mga miyugdumaya ng Judio para ibalik ang 30 ka bilog nga pilak. ");
INSERT INTO rol_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Naghambay siya, “Nakasalà ako kay gingtugyan ko sa indo ang tawo nga wayà ning salà.” Nagsabat sinda, “Anong labot namon? Bahayà ka sa kabuhì mo!” ");
INSERT INTO rol_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Gingpilak ni Judas ang kwarta didto sa suyod ng templo. Pagkatapos nagluwas siya kag nagbikti. ");
INSERT INTO rol_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Gingpuyot ng mga pinunò nga parì ang kwarta kag naghambay, “Ini nga kwarta hay indì puydi ibutang sa tipunan ng kwarta ng templo kay kontra ini sa aton kasuguan kay ini nga kwarta hay gingbayad para patyon ang isa ka tawo.” ");
INSERT INTO rol_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Nagkasugot sinda nga ang kwarta hay gamiton para ibakay ning dutà ng miyughuman ning kuyon para humanon nga lubungan ng mga taga-iban nga lugar. ");
INSERT INTO rol_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nganì adto nga bukid hay ginatawag hasta arinyan, Dutà ng Dugò. ");
INSERT INTO rol_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Sa adto nga natabò natuman ang ginghambay ni Propeta Jeremias, “Gingbuoy ninda ang 30 ka bilog nga pilak nga gingkasugtanan ng mga inapo ni Israel nga ibakay sa iya. ");
INSERT INTO rol_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Kag ginggamit ninda ang kwarta para ibakay ning dutà ng miyughuman ning kuyon kumpormi sa gingsugò sa akon ng Ginoo.” ");
INSERT INTO rol_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Niyan, nang yadto na si Hesus kay Pilato, gingpangutana siya, “Ikaw ba ang harì ng mga Judio?” Nagsabat si Hesus, “Ikaw ang naghambay inà.” ");
INSERT INTO rol_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Pero aber ginaakusar siya ng mga pinunò nga parì kag ng mga miyugdumaya ng Judio, wayà siya nagsabat. ");
INSERT INTO rol_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Nganì naghambay si Pilato sa iya, “Basì wayà ka nagasabat sa inda mga akusasyon kontra sa imo?” ");
INSERT INTO rol_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pero wayà gid nagsabat si Hesus aber isa, nganì natingaya gid ang gobernador. ");
INSERT INTO rol_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kada Pyesta ng Pagligad ng Anghel ang ginahuman ng gobernador hay nagapaluwas ning isa ka priso nga gusto ng mga tawo paluwason. ");
INSERT INTO rol_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","May isa ka bantog nga priso nga ang pangayan hay Barabas. ");
INSERT INTO rol_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nganì nang nagtipon ang mga tawo, nagpangutana si Pilato sa inda, “Sin-o ang gusto nindo nga akon paluwason, si Barabas ba o si Hesus nga ginatawag nga Kristo?” ");
INSERT INTO rol_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Sayod ni Pilato nga naiili ang mga pinunò nga parì kay Hesus, nganì gingtugyan ninda siya sa iya. ");
INSERT INTO rol_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Mintras nagapungkò si Pilato sa lugar nga ginahusgahan, nagpadaya ang iya asawa ning mensahe sa iya, “Ayaw pagpasinlabot sa inà nga tawo nga wayà ning salà. Kay kagab-i nahugaan gid ako sa akon pananamgo parti sa iya.” ");
INSERT INTO rol_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pero gingsuysugan ng mga pinunò nga parì kag ng mga miyugdumaya ng Judio ang mga tawo nga si Barabas ang inda pangayuon nga paluwason kag si Hesus ang ipapatay. ");
INSERT INTO rol_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Nganì nagpangutana liwat si Pilato sa inda, “Sin-o sa inda nga duha ang indo gusto nga akon paluwason para sa indo?” Nagsabat sinda, “Si Barabas!” ");
INSERT INTO rol_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Nagpangutana si Pilato, “Hay ano ang akon humanon kay Hesus nga ginatawag nga Kristo?” Nagsabat sinda tanan, “Ilangsang siya sa krus!” ");
INSERT INTO rol_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pero nagpangutana si Pilato, “Basì, ano ba ang salà nga iya nahuman?” Pero gingtuduhan pa gid ninda ang pagsinggit, “Ilangsang siya sa krus!” ");
INSERT INTO rol_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Nang makità ni Pilato nga wayà na siya ning may mahuhuman kag basì kung magkinagulo ang mga tawo, nagpabuoy siya ning tubì kag nagpanghinaw sa atubangan ng mga tawo. Naghambay siya, “Wayà ako ning labot sa kamatayon ng ini nga tawo. Indo inà sabaton! Limpyo ang akon kamot.” ");
INSERT INTO rol_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nagsabat ang tanan nga mga tawo, “Kami kag ang amon mga ungà ang magapanabat ng iya kamatayon!” ");
INSERT INTO rol_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pagkatapos gingpaluwas ni Pilato si Barabas para sa inda. Pero si Hesus hay iya gingpalatigo kag gingtugyan sa iya mga sundalo agud ilangsang sa krus. ");
INSERT INTO rol_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Gingdaya ng mga sundalo si Hesus sa suyod ng palasyo ng gobernador kag nagtipon didto ang tanan nga batalyon ng mga sundalo nga nagapalibot sa iya. ");
INSERT INTO rol_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ging-ubahan ninda siya kag gingbutangan ning kapa nga puya. ");
INSERT INTO rol_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ginghumanan ninda ning korona nga tunukon kag gingsuksok ini sa iya uyo. Kag gingpahawid ninda sa iya tuo nga kamot ang daw baston. Pagkatapos gingluhod-luhuran ninda siya nga ginaininsulto. Hambay ninda, “Mabuhay, ang Harì ng mga Judio!” ");
INSERT INTO rol_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Gingpil-an ninda siya kag gingbuoy ang baston kag gingpinukoy siya sa uyo. ");
INSERT INTO rol_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pagkatapos ng inda pag-ininsulto, ging-uba ninda ang kapa kag gingsuksukan siya liwat ng iya barò. Tapos gingdaya ninda siya sa luwas para ilangsang sa krus. ");
INSERT INTO rol_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Mintras nagapanaw sinda paluwas, nasumpong ninda ang isa ka tawo nga taga-Cyrene. Ang iya pangayan hay si Simon. Gingpilit ninda siya nga magpas-an ng krus ni Hesus. ");
INSERT INTO rol_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Pag-abot ninda sa lugar nga ginatawag, Golgota (ang gusto hambayon, Lugar ng Bungò), ");
INSERT INTO rol_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","gingtaw-an ninda si Hesus ning ilimnon nga may halò nga mapait. Pero nang gingtilawan niya adto, wayà siya mag-inom. ");
INSERT INTO rol_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Pagkalangsang ng mga sundalo sa iya sa krus, gingparte-parte ninda ang iya mga barò paagi sa palabunutan. ");
INSERT INTO rol_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pagkatapos nagpungkò sinda kag nagbantay sa iya. ");
INSERT INTO rol_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Hampig sa ibabaw ng iya uyo nagbutang sinda ning karatula. Gingsulat ninda didto ang akusasyon kontra sa iya, “Ini si Hesus nga Harì ng mga Judio.” ");
INSERT INTO rol_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","May duha didto ka tulisan nga inda da ginglangsang sa krus, ang isa sa iya tuo kag ang isa sa waya. ");
INSERT INTO rol_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ang mga tawo nga nagapang-agi didto hay nagaliong-liong nga ginainsulto si Hesus. ");
INSERT INTO rol_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Hambay ninda, “Ikaw nga nagahambay nga gubaon mo ang templo kag sa suyod ng tuyo ka adlaw patindugon mo liwat, luwasa ang imo kaugalingon! Kung ikaw ang Ungà ng Dios, panaog dirà sa krus!” ");
INSERT INTO rol_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ginainsulto da siya ng mga pinunò nga parì, mga eskriba kag mga miyugdumaya ng Judio. ");
INSERT INTO rol_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Naghambay sinda, “Gingtabangan niya ang iban, pero indì niya kaya tabangan ang iya kaugalingon! Dì ba harì kuno siya ng Israel? Kung makapanaog siya dirà sa krus, mapati kita sa iya. ");
INSERT INTO rol_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nagasalig kuno siya sa Dios. Siruon ta abi kung luwason siya ng Dios, kay nagahambay siya nga Ungà siya ng Dios!” ");
INSERT INTO rol_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Patì ang mga tulisan nga ginglangsang kaibahan niya hay nagainsulto da sa iya. ");
INSERT INTO rol_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Magtunà nang alas dose ng adlaw, nagduyom ang bilog nga lugar hasta alas tres ng hapon. ");
INSERT INTO rol_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Nang alas tres na ng hapon, nagsinggit si Hesus ning makusog, “Eli, Eli, lema sabachtani?” Ang gusto hambayon hay, “Dios ko, Dios ko, basì gingpabay-an mo ako?” ");
INSERT INTO rol_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ang iban nga nagatindog didto nga nakabatì ng iya gingsinggit naghambay, “Ginatawag ng ini nga tawo si Elias!” ");
INSERT INTO rol_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Adto nga daan, ang isa sa mga tawo didto nagdyagan kag nagbuoy ning espongha kag gingsawsaw ini sa maaslom nga ilimnon. Gingtakod niya ini sa punta ng kuhit kag gingpalapit kay Hesus para supsupon niya. ");
INSERT INTO rol_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pero ang iban naghambay, “Pabay-i siya! Siruon ta abi kung maabot si Elias para luwason siya.” ");
INSERT INTO rol_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nagsinggit liwat si Hesus ning makusog kag nabugtuan siya ning ginhawa. ");
INSERT INTO rol_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Adto gid nga oras, nagisì sa tungà ning duha kaparte ang kurtina ng templo halin sa ibabaw paubos. Naglinog kag ang madagkò nga mga bato hay nagkabuak. ");
INSERT INTO rol_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Nabuksan ang mga lubungan kag kadamò nga balaan nga tawo ng Dios nga namatay na hay nabanhaw. ");
INSERT INTO rol_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Nagluwas sinda sa mga lubungan. Pagkatapos mabanhaw si Hesus, nagsuyod sinda sa balaan nga syudad ng Jerusalem kag kadamò nga tawo ang nakakità sa inda. ");
INSERT INTO rol_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nang mabatyagan ng kapitan kag ng mga sundalo nga nagabantay kay Hesus ang paglinog kag nang makità ninda ang mga natabò, hinadlukan gid sinda. Naghambay sinda, “Matuod gid ini nga tawo hay Ungà ng Dios!” ");
INSERT INTO rol_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Sa malayò-layò may mga babayi da nga nagatan-aw sa nagakatabò. Sinda ang nagasunod kag nagaserbisyo kay Hesus halin sa Galilea. ");
INSERT INTO rol_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Kaibahan ninda si Maria nga taga-Magdala, si Maria nga nanay nina Santiago kag Jose kag ang asawa ni Zebedee. ");
INSERT INTO rol_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nang manayumsom na, nag-abot ang isa ka manggaranon nga tawo nga taga-Arimatea. Ang iya pangayan hay Jose kag isa da siya nga disipulo ni Hesus. ");
INSERT INTO rol_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nagkadto siya kay Pilato para pangayuon ang lawas ni Hesus. Pagkatapos nagsugò si Pilato nga itao sa iya. ");
INSERT INTO rol_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Nganì gingpabuoy ni Jose ang lawas kag gingpaputos ning bag-o nga tela nga mahay kag maayo nga klasi. ");
INSERT INTO rol_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Gingpabutang niya ini sa iya bag-o nga lubungan nga iya gingpakutkot sa alihid ng bakuyod. Kag gingpapaligid niya ang mabahoy nga bato para masarhan ang pwertahan ng lubungan. Pagkatapos naghalin na siya. ");
INSERT INTO rol_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Nagpabilin didto si Maria nga taga-Magdala kag ang isa pa gid nga Maria. Nagapungkò sinda sa atubangan ng lubungan. ");
INSERT INTO rol_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Pagkaaga, pagkatapos ng adlaw ng Pagpreparar, nagkadto ang mga pinunò nga parì kag ang mga Pariseo kay Pilato. ");
INSERT INTO rol_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Naghambay sinda, “Nadumduman namon nang buhì pa adto nga miyugpanluko, naghambay siya nga mabanhaw kuno siya pagkaligad ng tuyo ka adlaw. ");
INSERT INTO rol_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nganì maayo siguro pabantayan mo ang lubungan niya sa suyod ng tuyo ka adlaw, kay basì kung ang iya patay nga lawas hay kawaton ng iya mga disipulo kag maghambay sinda sa mga tawo nga nabanhaw siya. Kung matabò ini nga kalukuhan, magiging mas malain pa ini kaysa sa una.” ");
INSERT INTO rol_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Naghambay si Pilato sa inda, “Day-a nindo didto ang mga gwardya. Kamo mismo ang magpabantay, bahayà na kamo.” ");
INSERT INTO rol_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nganì nagkadto sinda sa lubungan kag gingsilyuhan ninda ang bato nga nagasara sa lubungan. Pagkatapos gingbilin ninda didto ang mga gwardya. ");
INSERT INTO rol_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Pagkatapos ng Adlaw nga Inugpahuway*, aga pa gid ng una nga adlaw ng simana, nagkadto si Maria nga taga-Magdala kag ang isa pa nga Maria didto sa lubungan kay gusto ninda magsirò. ");
INSERT INTO rol_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Niyan, gulpi lang nga naglinog ning makusog kag nagbabà ang anghel ng Ginoo halin sa langit. Gingpaligid niya ang bato nga nagasara sa pwertahan ng lubungan kag gingpungkuan niya ini. ");
INSERT INTO rol_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ang iya hitsura hay sobra gid kasilaw nga daw sa kilat kag ang iya barò hay kaputì-putì gid. ");
INSERT INTO rol_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ang mga gwardya nga nagabantay sa lubungan hay nagpangurog sa kahadlok kag nabuy-an ning animo. ");
INSERT INTO rol_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Naghambay ang anghel sa mga babayi, “Ayaw kamo mahadlok. Sayod ko nga ginapangità nindo si Hesus nga ginglangsang sa krus. ");
INSERT INTO rol_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Wayà na siya diri kay nabanhaw na siya sunò sa iya ginghambay sa indo. Kari kag sirua nindo ang gingbutangan sa iya.” ");
INSERT INTO rol_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Pagkatapos adto naghambay ang anghel sa inda, “Kadto kamo nga daan kag balitai nindo ang iya mga disipulo nga nabanhaw na siya kag nauna na siya sa indo sa Galilea. Didto nindo siya makikità. Ayaw nindo paglimuti ang akon ginghambay sa indo.” ");
INSERT INTO rol_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Nganì dalì-dalì sinda nga naghalin sa lubungan. Aber ginahadlukan, nalipay gid sinda kag nagdyagan para ibalità ini sa mga disipulo. ");
INSERT INTO rol_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Malagat-lagat nasumpong ninda si Hesus. Naghambay siya sa inda, “Kamusta kamo?” Pagkatapos nagpalapit sinda kay Hesus. Ginghawiran ninda ang iya mga siki kag gingsamba siya. ");
INSERT INTO rol_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Hambay ni Hesus sa inda, “Ayaw kamo mahadlok. Kadto kamo sa akon mga manghod kag hambaya sinda nga magkadto didto sa Galilea. Didto ninda ako makikità.” ");
INSERT INTO rol_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Mintras nagapanaw ang mga babayi halin sa lubungan, ang iban nga mga gwardya nagkadto sa syudad kag gingbalità ninda sa mga pinunò nga parì ang tanan nga natabò didto sa lubungan. ");
INSERT INTO rol_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Nganì nagtipon ang mga pinunò nga parì kaibahan ng mga miyugdumaya ng Judio. Nagkasugot sinda nga taw-an ninda ning kadakò nga kwarta ang mga sundalo para indì sinda magpamalità kung ano gid ang matuod nga natabò. ");
INSERT INTO rol_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Gingtudluan ninda ang mga sundalo kung ano ang inda ihambay sa mga tawo. Naghambay sinda, “Balitai nindo ang mga tawo nga mintras nagakatuyog kamo kagab-i, nag-abot ang iya mga disipulo kag gingbuoy ninda ang lawas ni Hesus. ");
INSERT INTO rol_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kung mabatian ini ng gobernador, kami ang mahambay sa iya para indì kamo mauno.” ");
INSERT INTO rol_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Nganì gingbaton ninda ang kwarta kag gingtuman ninda ang ginghambay sa inda. Kag hasta niyan, imaw ini ang istorya nga ginapakayat ng mga Judio. ");
INSERT INTO rol_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Niyan, nagkadto ang onse nga disipulo ni Hesus sa Galilea, sa bukid nga iya gingtudlò sa inda. ");
INSERT INTO rol_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nang makità ninda si Hesus gingsamba ninda siya, pero ang iban nagduha-duha. ");
INSERT INTO rol_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Nagpalapit si Hesus sa inda kag naghambay, “Ang tanan nga otoridad sa langit kag sa dutà hay gingtao na sa akon. ");
INSERT INTO rol_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nganì magkadto kamo sa tanan nga tawo sa bilog nga kalibutan kag humana sinda nga akon mga disipulo. Bawtismuhi sinda sa pangayan ng Amay, ng Ungà kag ng Espiritu Santo. ");
INSERT INTO rol_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Tudlui nindo sinda nga tumanon ang tanan nga akon gingsugò sa indo. Tandai nindo, kaibahan nindo ako permi hasta sa katapusan ng kalibutan.”");
INSERT INTO rol_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Imaw ini ang Maayong Balità* parti kay Hesu-Kristo nga Ungà ng Dios. ");
INSERT INTO rol_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nagtunà ini nang matuman ang gingsulat ni Propeta* Isaias parti sa ginghambay ng Dios sa iya Ungà, “Ipapadaya ko ang akon mensahero nga mauna sa imo para magpreparar ng imo dayan. ");
INSERT INTO rol_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ini nga mensahero hay magasinggit sa tiway nga lugar. Magahambay siya sa mga tawo, ‘Ipreparar nindo ang agihan para sa Ginoo, tadlunga ang dayan nga iya pagaagihan.’ ” ");
INSERT INTO rol_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Nganì natabò ini nang mag-abot si Juan nga Miyugbawtismo sa tiway nga lugar. Nagawali siya sa inda nga nagahambay, “Talikuri nindo ang indo mga kasal-anan kag magpabawtismo para patawaron kamo ng Dios.” ");
INSERT INTO rol_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Madamò gid nga tawo ang nagkadto sa iya halin sa tanan nga banwa nga sakop ng Judea kag sa Jerusalem. Ging-akò ninda ang inda mga salà kag gingbawtismuhan niya sinda sa Subà ng Jordan. ");
INSERT INTO rol_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ang barò ni Juan hay himò sa buyboy ng kamelyo kag ang iya sinturon hay panit ng hayop. Ang iya pagkaon hay apan kag dugos. ");
INSERT INTO rol_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Imaw ini ang iya ginawali, “May maabot nga masunod sa akon nga mas makagagahom pa kaysa sa akon kag indì gid ako angay aber magdukò para magbaskad ng higot ng iya sandalyas. ");
INSERT INTO rol_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nagabawtismo ako sa indo sa tubì, pero siya ang magabawtismo sa indo sa Espiritu Santo.” ");
INSERT INTO rol_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Nang adto nga tyempo naghalin si Hesus sa Nazaret nga sakop ng probinsya ng Galilea kag nagpabawtismo kay Juan sa Subà ng Jordan. ");
INSERT INTO rol_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Paghaw-as ni Hesus sa tubì, nakità nga daan niya nga nag-abri ang langit kag ang Espiritu Santo nga daw salampati hay nagababà pakadto sa iya. ");
INSERT INTO rol_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kag igwa ning boses nga nabatian halin sa langit nga naghambay, “Ikaw ang akon pinalanggà nga Ungà; nalilipay gid ako sa imo.” ");
INSERT INTO rol_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Adto nga daan gingpakadto si Hesus ng Espiritu Santo sa tiway nga lugar. ");
INSERT INTO rol_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Kag didto siya nagtinir sa suyod ng 40 ka adlaw nga ginatinintar ni Satanas kag may mapintas nga mga sapat didto, pero gingserbisyuhan siya ng mga anghel. ");
INSERT INTO rol_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Nang mapriso si Juan nga Miyugbawtismo, nagkadto si Hesus sa Galilea kag nagwali ng Maayong Balità halin sa Dios. ");
INSERT INTO rol_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Hambay niya, “Nag-abot na ang tamà nga oras kag malapit na nga magaharì ang Dios. Nganì talikuran nindo ang indo mga kasal-anan kag magpati sa Maayong Balità.” ");
INSERT INTO rol_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Isa ka adlaw mintras nagapanaw si Hesus sa alihid ng Lawà ng Galilea*, nakità niya didto ang magmanghod nga sina Simon kag Andres nga nagataktak ng pukot kay sinda hay miyugpangisdà. ");
INSERT INTO rol_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Naghambay si Hesus sa inda, “Nunot kamo sa akon kay tudluan ta kamo sa pagpangisdà ng mga tawo.” ");
INSERT INTO rol_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Adto nga daan gingbayaan ninda ang inda mga pukot kag nagnunot sa iya. ");
INSERT INTO rol_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Mintras nagapadayon pa si Hesus sa pagpanaw, nakità niya ang magmanghod nga sina Santiago* kag Juan nga mga ungà ni Zebedee. Yadto sinda sa inda dyapang* nga nagahukot ng mga pukot, ");
INSERT INTO rol_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","kag ging-agda nga daan sinda ni Hesus. Gingbayaan ninda sa dyapang ang inda tatay kaibahan ang mga ginasuhuyan kag nagnunot sinda sa iya. ");
INSERT INTO rol_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Niyan, nagkadto si Hesus kag ang iya mga kaibahan sa banwa ng Capernaum*. Pag-abot ng Adlaw nga Inugpahuway*, nagsuyod nga daan siya sa sinagoga* kag nagtunà sa pagpanudlò. ");
INSERT INTO rol_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Natingaya gid sa iya pagpanudlò ang mga tawo nga nakabatì, kay nagtudlò siya nga may otoridad kag bukon pareho ng mga eskriba*. ");
INSERT INTO rol_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Adto nga daan may isa ka tawo nga ginasapian ng malain nga espiritu ang nagsuyod sa sinagoga kag nagsinggit, ");
INSERT INTO rol_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Hesus nga taga-Nazaret, ano ang humanon mo sa amon? Nagkari ka ba para parusahan kami? Kilaya ko kung sin-o ka: ikaw ang Balaan nga gingsugò ng Dios!” ");
INSERT INTO rol_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Pero gingsabyaw ni Hesus ang malain nga espiritu, “Maghipos ka kag magluwas sa iya!” ");
INSERT INTO rol_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Gingpakurog ng malain nga espiritu ang tawo kag nagasinggit ning tudo mintras nagluwas sa iya. ");
INSERT INTO rol_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Natingaya gid ang tanan nga tawo nganì nagpangutana sinda sa isa kag isa, “Ano baya ini? Bag-o ini nga pagpanudlò! May otoridad siya sa pagsugò aber sa malain nga mga espiritu kag nagatuman sinda sa iya.” ");
INSERT INTO rol_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nganì nabantog nga daan ang balità parti kay Hesus sa bilog nga probinsya ng Galilea. ");
INSERT INTO rol_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nagluwas si Hesus kag ang iya mga kaibahan sa sinagoga kag nagkadto sa bayay nina Simon kag Andres, kaibahan da sina Santiago kag Juan. ");
INSERT INTO rol_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Niyan, nagahigdà ang panugangan nga babayi ni Simon kay may sagnat siya. Kag adto nga daan gingpasayod ninda ini kay Hesus. ");
INSERT INTO rol_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Nganì gingpalapitan siya ni Hesus kag ginghawiran sa kamot kag gingpabangon. Nahuwasan siya sa iya sagnat kag gingserbisyuhan niya sina Hesus. ");
INSERT INTO rol_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Nang manayumsom na kag nagtunod na ang adlaw, gingdaya ng mga tawo kay Hesus ang tanan nga may sakit kag ang ginasapian ng mga demonyo. ");
INSERT INTO rol_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Tanan nga tawo sa banwa hay nagtipon sa atubangan ng bayay. ");
INSERT INTO rol_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Gingpang-ayo ni Hesus ang madamò nga may sarisarì nga sakit kag gingpalayas ang madamò nga demonyo. Wayà niya pagtuguti nga maghambay sinda kay sayod ninda kung sin-o siya. ");
INSERT INTO rol_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Nang masunod nga adlaw, maduyom pa, nagbangon si Hesus kag nagkadto sa tiway nga lugar kag nagpangamuyò. ");
INSERT INTO rol_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Gingpangità siya ni Simon kag ng iya mga kaibahan. ");
INSERT INTO rol_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Pagkakità ninda kay Hesus naghambay sinda, “Ginapinangità ka ng tanan nga tawo.” ");
INSERT INTO rol_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Pero nagsabat si Hesus sa inda, “Makadto na kita sa malapit nga mga banwa para makawali ako didto kay imaw ini ang akon gingkari sa kalibutan.” ");
INSERT INTO rol_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nganì naglibot si Hesus sa bilog nga Galilea para magwali sa mga sinagoga kag magpalayas ning mga demonyo. ");
INSERT INTO rol_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","May isa ka tawo nga kitungon* nga nagpalapit kay Hesus. Nagluhod siya kag nagpakitluoy nga buligan siya. Hambay niya, “Kung gusto mo, paayuha ako sa akon sakit nga kitong.” ");
INSERT INTO rol_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Naluoy gid si Hesus sa iya. Nganì ging-unat niya ang iya kamot kag ginghawiran siya. Hambay niya, “Gusto ko. Mag-ayo ka!” ");
INSERT INTO rol_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Adto nga daan naduyà ang iya kitong kag nalimpyo siya. ");
INSERT INTO rol_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Pagkatapos gingpaandaman siya ni Hesus, “Ayaw gid magpamalità aber kanin-o, kundì magderitso ka sa parì kag magpasirò sa iya. Kag maghalad* ka sunò sa gingsugò ni Moises para magpamatuod sa mga tawo nga nalimpyo ka na.” Pagkatapos, gingpapanaw nga daan siya ni Hesus. ");
INSERT INTO rol_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kag nagpanaw adto nga tawo pero nagpinamalità parti sa natabò sa iya. Nganì nabantog ang balità sa tanan nga lugar sa Galilea kag indì na makasuyod si Hesus sa mga banwa ning lantaran. Didto na lang siya nagtinir sa tiway nga lugar. Pero sige pa gihapon ang pagkadto ng mga tawo sa iya halin sa tanan nga lugar. ");
INSERT INTO rol_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Pagkaligad ng pila ka adlaw, nagbalik si Hesus sa Capernaum. Nabalitaan ng mga tawo nga yadto na siya sa bayay. ");
INSERT INTO rol_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Nganì kadamò ang tawo nga nagtipon didto kag napunò ang bayay hasta sa pwertahan. Gingwali ni Hesus sa inda ang mensahe ng Dios. ");
INSERT INTO rol_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Niyan, may nag-abot nga upat ka tawo nga ginabayawan ang isa ka paralisado. ");
INSERT INTO rol_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pero sa kadamò ng tawo, indì sinda makapalapit kay Hesus. Nganì nagsakà sinda sa pantay nga bubong kag gingbuhuan ang bubong sa tungod ni Hesus. Kag nang nabuhuan na, gingtunton ninda ang paralisado nga nagahigdà sa banig. ");
INSERT INTO rol_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nang makità ni Hesus ang inda pagtuo, naghambay siya sa paralisado, “Nonò, napatawad na ang imo mga salà!” ");
INSERT INTO rol_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Nang mabatian ini ng mga eskriba nga nagapungkò didto, naghunahunà sinda sa inda kaugalingon, ");
INSERT INTO rol_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Basì tiyad inà? Basì kung nagahambay siya hay daw pareho gid siya ng Dios? Wayà ning aber sin-o nga makapatawad ng mga salà kundì ang Dios lang!” ");
INSERT INTO rol_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Nasayuran nga daan ni Hesus ang inda ginahunahunà, nganì nagpangutana siya sa inda, “Basì tiyad inà ang indo ginahunahunà? ");
INSERT INTO rol_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Diin baya ang mas malupos nga hambayon sa ini nga paralisado, ‘Napatawad na ang imo mga salà,’ o ‘Bangon, lukuta ang imo banig kag pumanaw’? ");
INSERT INTO rol_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Niyan pamatuuran ko sa indo nga ako nga Ungà ng Tawo* hay may otoridad diri sa kalibutan nga magpatawad ng mga salà.” Tapos hambay niya sa paralisado, ");
INSERT INTO rol_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ginahambay ko sa imo, ‘Bangon, lukuta ang imo banig kag bumalik na!’ ” ");
INSERT INTO rol_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Nagtindog ang paralisado, ginglukot nga daan niya ang iya banig kag nag-agi sa inda atubangan paluwas. Nganì natingaya gid ang tanan nga tawo kag gingdayaw ninda ang Dios nga nagahambay, “Wayà pa kami ning may nakità nga tiyad ini!” ");
INSERT INTO rol_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Pagkatapos, nagbalik si Hesus sa alihid ng Lawà ng Galilea. Madamò nga tawo ang nagpalapit sa iya, nganì gingtudluan niya sinda. ");
INSERT INTO rol_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Mintras nagapanaw siya, nakità niya ang miyugsukot ning buhis nga si Levi nga ungà ni Alfeus. Nagapungkò siya sa ginabayaran ning buhis. Naghambay si Hesus sa iya, “Magsunod ka sa akon.” Nagtindog si Levi kag nagsunod sa iya. ");
INSERT INTO rol_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Niyan, mintras nagakaon si Hesus kag ang iya mga disipulo sa bayay ni Levi, madamò da nga miyugsukot ning buhis kag iban pa nga sayod nga mga makasasalà ang nagdungan sa inda pagkaon kay madamò na gid ang nagasunod sa iya. ");
INSERT INTO rol_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nang makità ng mga eskriba sa grupo ng mga Pariseo* si Hesus nga nagakaon kaibahan ng mga makasasalà kag ng mga miyugsukot ning buhis, nagpangutana sinda sa iya mga disipulo, “Basì nagakaon siya kaibahan ang mga miyugsukot ning buhis kag mga makasasalà?” ");
INSERT INTO rol_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Nabatian ni Hesus ang inda pangutana, nganì gingsabat niya sinda, “Wayà nagakahinangyan ning doktor ang mga tawo nga maayo ang lawas, kundì ang mga may sakit lang. Wayà ako nagkari para tawagon ang mga nakakasayod nga sinda hay matarong, kundì ang mga makasasalà.” ");
INSERT INTO rol_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Isa ka adlaw, ang mga disipulo ni Juan nga Miyugbawtismo kag ang mga Pariseo hay nagapuasa. May mga tawo nga nagpalapit kay Hesus kag nagpangutana, “Basì ang mga disipulo ni Juan kag ang mga disipulo ng mga Pariseo hay nagapuasa, pero ang imo mga disipulo hay wayà?” ");
INSERT INTO rol_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Nagsabat si Hesus sa inda, “Puydi ba arà nga indì pagpakaunon ang mga bisita sa kasay* mintras kaibahan pa ninda ang kyasayon nga lyaki? Syempre, indì gid puydi nga magpuasa sinda mintras kaibahan pa ang kyasayon nga lyaki. ");
INSERT INTO rol_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pero magaabot ang adlaw, pag buy-on ang kyasayon nga lyaki sa inda kag imaw na inà ang inda pagpuasa.” ");
INSERT INTO rol_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Naghambay pa gid si Hesus, “Wayà ning tawo nga nagahakyop ning bag-o nga tela nga wayà pa mag-ukyò sa lumà nga barò. Kay kung ihakyop ang bag-o nga tela, magigisì ang lumà nga barò kag magapakabahoy pa ang gisì. ");
INSERT INTO rol_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kag wayà da ning tawo nga nagabutang ning bag-o nga ilimnon sa lumà nga butangan nga panit ng hayop kay malupok ang butangan kag mauuyak ang ilimnon kag masisirà ang butangan. Pero ang bag-o nga ilimnon dapat ibutang sa bag-o nga butangan nga panit.” ");
INSERT INTO rol_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Isa ka Adlaw nga Inugpahuway*, mintras nagaagi sina Hesus sa uma ng trigo, nagpinamuksì ang iya mga disipulo ning mga uhay ng trigo. ");
INSERT INTO rol_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nganì naghambay ang mga Pariseo kay Hesus, “Tan-awa ang imo mga disipulo! Basì ginahuman ninda ang ginabawal ng Kasuguan sa Adlaw nga Inugpahuway?” ");
INSERT INTO rol_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Nagsabat si Hesus sa inda, “Wayà ba nindo nabasahi sa Kasulatan ang ginghuman ni David nang siya kag ang iya mga kaibahan hay nagkahinangyan ning pagkaon kay nagutom sinda? ");
INSERT INTO rol_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Nang si Abiatar imaw ang Pinakamataas nga Parì, nagsuyod si David sa tolda ng Dios kag gingkaon niya ang tinapay nga ginghalad sa Dios kag gingtaw-an da ang iya mga kaibahan. Pero wayà sinda nakasalà aber pa nga ginabawal ini ng Kasuguan kay ang mga parì lang ang puydi magkaon adto.” ");
INSERT INTO rol_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Kag naghambay pa gid si Hesus, “Ginghuman ang Adlaw nga Inugpahuway para sa kaayuhan ng tawo. Wayà ginghuman ang tawo para sa kaayuhan ng Adlaw nga Inugpahuway. ");
INSERT INTO rol_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nganì ako nga Ungà ng Tawo hay may otoridad sa paghambay kung ano ang puydi nga humanon aber sa Adlaw nga Inugpahuway.” ");
INSERT INTO rol_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Nagkadto liwat si Hesus sa sinagoga* kag didto, may tawo nga paralisado ang iya kamot. ");
INSERT INTO rol_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","May mga Pariseo didto nga nagapangità gid kung pauno ang pag-akusar kay Hesus. Nganì ginabantayan ninda kung paayuhon niya adto nga tawo sa Adlaw nga Inugpahuway. ");
INSERT INTO rol_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Naghambay si Hesus sa tawo nga paralisado ang kamot, “Kari diri sa atubangan ko.” ");
INSERT INTO rol_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Pagkatapos, nagpangutana siya sa inda, “Ano ang ginatugot ng Kasuguan sa Adlaw nga Inugpahuway, ang paghuman ning maayo sa mga tawo o ang paghuman ning malain? Ang pagluwas ng kabuhì o ang pagpatay?” Pero wayà gid ning may nagsabat. ");
INSERT INTO rol_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Gingsirò sinda ni Hesus nga may kahangit kag nalisod siya kay matugas gid ang inda uyo. Pagkatapos, naghambay siya sa tawo nga paralisado, “Unata ang imo kamot!” Ging-unat niya ang iya kamot kag nag-ayo gid ini. ");
INSERT INTO rol_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Pagkatapos adto nagluwas ang mga Pariseo kag nagpakigkità nga daan sa mga miyembro ng grupo ni Herodes. Nagplano sinda kung pauno ninda patyon si Hesus. ");
INSERT INTO rol_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Nagkadto si Hesus kag ang iya mga disipulo sa alihid ng dagat. Nagsunod sa inda ang madamò nga tawo halin sa probinsya ng Galilea kag Judea. ");
INSERT INTO rol_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Madamò da ang naghalin sa syudad ng Jerusalem, sa rehiyon ng Idumea, sa kabuak ng Subà ng Jordan kag sa palibot ng syudad ng Tyre kag Sidon, kay nabatian ninda ang iya ginapanghuman. ");
INSERT INTO rol_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Agud indì siya maipit, gingsugò niya ang mga disipulo nga magpreparar ning dyapang para masakyan niya kay madamò gid nga tawo ang nagadinagusò sa iya. ");
INSERT INTO rol_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Madamò ang iya gingpang-ayo, nganì ang tanan nga may sakit hay nagatinuyuran para makatandog sa iya. ");
INSERT INTO rol_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kag kung makità siya ng mga tawo nga ginasapian ng malain nga espiritu, nagahapà sinda sa iya atubangan kag nagasinggit, “Ikaw ang Ungà ng Dios!” ");
INSERT INTO rol_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pero gingbawalan gid niya sinda nga indì magpasayod sa iban kung sin-o siya. ");
INSERT INTO rol_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Pagkatapos adto, nagtukad si Hesus sa bakuyod kag gingtawag niya ang gusto niya nga makaibahan. Nganì nagpalapit sinda sa iya. ");
INSERT INTO rol_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Gingpilì niya ang dose nga iya gusto makaibahan nga gingtawag niya nga mga apostoles, agud iya suguon para magwali. ");
INSERT INTO rol_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Gingtaw-an niya sinda ning otoridad agud magpalayas ning mga demonyo. ");
INSERT INTO rol_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Imaw ini ang dose nga iya gingpilì: si Simon (nga gingpangayanan niya nga Pedro), ");
INSERT INTO rol_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","sina Santiago kag Juan nga mga ungà ni Zebedee (nga gingpangayanan niya nga Boanerges nga ang gusto hambayon, mga Ungà ng Dayugdog), ");
INSERT INTO rol_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","sina Andres, Felipe, Bartolome, Mateo, Tomas, Santiago nga ungà ni Alfeus, Tadeus, Simon (nga dati hay nagrebelde sa gobyerno ng Roma), ");
INSERT INTO rol_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","kag si Judas Iscariote nga sa ulihi imaw ang magatraidor kay Hesus. ");
INSERT INTO rol_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Pagkatapos nagbalik sina Hesus kag nagtipon liwat ang mga tawo didto, nganì si Hesus kag ang iya mga disipulo hay wayà na ning oras aber magkaon. ");
INSERT INTO rol_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nang masayuran ng iya pamilya ang parti sa mga ginahuman ni Hesus, nagkadto sinda didto agud sugaton siya kay naghambay ang mga tawo, “Nasiraan siya ning uyo!” ");
INSERT INTO rol_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Naghambay ang mga eskriba nga nag-abot halin sa syudad ng Jerusalem, “Ginasapian siya ni Beelzebul. Nganì paagi sa gahom ng pinunò ng mga demonyo, ginapalayas niya ang mga demonyo.” ");
INSERT INTO rol_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Nganì gingtawag ni Hesus ang mga tawo nga magpalapit sa iya. Kag nagtudlò siya sa inda paagi sa ini nga mga parabola*, “Pauno nga magpalayas si Satanas ng iya gingsakupan? Indì gid inà matabò! ");
INSERT INTO rol_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kung ang mga pinunò ng isa ka gingharian mag-iniyaiya kag mag-inaway, inà nga gingharian hay maduduyà. ");
INSERT INTO rol_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Imaw da ang matatabò sa pamilya, kung ang mga miyembro sa pamilya hay mag-iniyaiya kag mag-inaway, magakabuyag-buyag ini. ");
INSERT INTO rol_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Nganì kung si Satanas kag ang iya mga grupo hay mag-iniyaiya kag mag-inaway, ang iya gingharian hay indì makapadayon kag maduduyà. ");
INSERT INTO rol_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Wayà ning aber sin-o nga makasuyod sa bayay ng makusog nga tawo kag magpangawat ning mga butang kundì gapuson anay niya adtong makusog nga tawo. Pagkatapos makabuoy na siya ning mga pagkabutang sa adto nga bayay. ");
INSERT INTO rol_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Sa matuod lang ginahambay ko sa indo, ang aber ano nga salà, aber pa ang maghambay kontra sa Dios, mapapatawad. ");
INSERT INTO rol_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pero ang aber sin-o nga maghambay ning malain kontra sa Espiritu Santo, indì gid mapatawad. Ini nga salà hay wayà gid ning kapatawaran hasta san-o.” ");
INSERT INTO rol_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ginghambay ini ni Hesus kay nagahambay ang mga eskriba nga may malain siya nga espiritu. ");
INSERT INTO rol_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Niyan, nag-abot ang nanay kag mga manghod nga lyaki ni Hesus. Mintras nagatindog sinda didto sa luwas, gingpatawag ninda siya. ");
INSERT INTO rol_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Madamò nga tawo didto ang nagapungkò palibot kay Hesus. Hambay ng mga tawo sa iya, “Yarà sa luwas ang imo nanay kag mga manghod, ginapatawag ka ninda.” ");
INSERT INTO rol_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Nagsabat siya, “Sayod ba nindo kung sin-o ang akon nanay kag mga manghod?” ");
INSERT INTO rol_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Nagsirò siya sa mga tawo nga nagapungkò sa iya palibot kag naghambay, “Imaw ini ang akon nanay kag mga manghod! ");
INSERT INTO rol_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ang aber sin-o nga nagahuman ng kabubut-on ng Dios, imaw ang akon mga manghod kag nanay.” ");
INSERT INTO rol_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Nagpanudlò liwat si Hesus sa alihid ng dagat. Kadamò gid nga tawo ang nagtipon sa iya palibot, nganì nagsakay siya sa dyapang nga yadto sa bìbì ng dagat kag didto siya nagpungkò. Kag ang mga tawo naman hay nagpabilin sa baybay. ");
INSERT INTO rol_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Madamò ang iya gingtudlò sa inda paagi sa mga parabola. ");
INSERT INTO rol_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Hambay niya, “Pamatì kamo! May isa ka mangunguma nga nagkadto sa iya uma para magsabwag ning binhì. ");
INSERT INTO rol_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Sa iya pagsabwag, ang iban nagtupà sa alihid ng dayan kag gingpantukà ini ng mga pispis. ");
INSERT INTO rol_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ang iban nga binhì nagtupà sa kabatuhan. Manipis lang ang dutà diri, nganì nagtubò nga daan ang binhì kay mababaw lang ang dutà. ");
INSERT INTO rol_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pero nalayà ini nang nainitan ng adlaw kay matag-od lang ang gamot. ");
INSERT INTO rol_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ang iban nga binhì nagtupà kag nagtubò sa dutà nga may mga bayagon nga tunukon, pero paglabog ng mga bayagon gingkamangan ang tanom, nganì wayà nakapamunga. ");
INSERT INTO rol_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ang iban pa gid nga binhì nagtupà sa maayo nga dutà, nagtubò ini kag nagpamunga. Ang iban tamà-tamà lang ang bunga, ang iban kadamò kag ang iban hay kadamò-damò gid.” ");
INSERT INTO rol_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Hambay pa ni Hesus sa inda, “Dapat intindihon gid nindo maayo ang indo nababatian.” ");
INSERT INTO rol_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Paghalin ng mga tawo, nagpangabay ang dose nga disipulo kag ang iban pa gid nga yadto sa palibot ni Hesus nga iisplikar niya ang mga parabola. ");
INSERT INTO rol_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Naghambay siya sa inda, “Sa indo lang gingtao ng Dios ang pang-intindi ng mga sikreto parti sa iya paghaharì, pero sa iban, ang tanan nga butang ginahambay sa inda paagi sa mga parabola, ");
INSERT INTO rol_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","agud, ‘Magsinirò man sinda, pero indì makakità; kag magpinamatì man sinda, pero indì makaintindi. Kay kung makaintindi sinda, magatalikod sinda sa inda mga salà kag pagapatawaron sinda ng Dios.’ ” ");
INSERT INTO rol_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Nagpangutana si Hesus sa inda, “Kung indì kamo makaintindi ini nga parabola, pauno nindo maintindihan ang iban pa nga mga parabola? ");
INSERT INTO rol_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Imaw ini ang gusto hambayon ng parabola: Ang gingsabwag ng mangunguma hay wayà ning iban kundì ang hambay ng Dios. ");
INSERT INTO rol_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ang alihid ng dayan nga gingtupaan ng binhì imaw ang mga tawo nga pagkabatì ng hambay ng Dios, nag-abot da nga daan si Satanas kag ging-agaw niya ang hambay sa inda tagipusuon. ");
INSERT INTO rol_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ang kabatuhan nga gingtupaan ng binhì imaw ang mga tawo nga pagkabatì ninda ng hambay ng Dios, gingbaton ninda nga daan ini nga may kalipay, ");
INSERT INTO rol_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","pero bukon hugot sa inda tagipusuon ang hambay ng Dios. Nganì wayà magdugay ang inda pagtuo. Pag-abot ng mga kahugaan o mga paghingabot tungod sa hambay ng Dios nga inda gingbaton, nagtalikod nga daan sinda sa inda pagtuo. ");
INSERT INTO rol_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ang dutà nga may mga bayagon nga tunukon nga gingtupaan ng binhì, imaw ang mga tawo nga nagpamatì ng hambay ng Dios, ");
INSERT INTO rol_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","pero tungod sa mga kabayak-on sa pangabuhì, sa pagtinguhà nga magmanggaranon kag sa sobra nga handom ng iban nga mga butang, nganì nalimutan ninda ang hambay ng Dios kag wayà ini nakapamunga sa inda kabuhì. ");
INSERT INTO rol_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Pero ang maayo nga dutà nga gingtupaan ng binhì, imaw ang mga tawo nga nagpamatì ng hambay ng Dios kag gingbaton ninda sa inda tagipusuon. Nganì nakapamunga ini sa inda kabuhì. Ang iban tamà-tamà lang ang bunga, ang iban hay kadamò kag ang iban hay kadamò-damò gid.” ");
INSERT INTO rol_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Naghambay pa gid si Hesus, “Kung ang tawo magsugà ning iwagan, wayà niya ginatakyubi sa basket o ginabutangan sa idayom ng katri, kundì ginabutang niya ini sa tungtungan. ");
INSERT INTO rol_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kay wayà gid ning may ginatagò nga indì makikità sa ulihi kag wayà ning sikreto nga indì masasayuran. ");
INSERT INTO rol_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Dapat intindihon gid nindo ning maayo ang indo nababatian.” ");
INSERT INTO rol_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Naghambay pa gid siya, “Pamatì kamo ning maayo! Ang pangsukoy nga ginggamit nindo sa iban hay imaw da ang pangsukoy nga gamiton sa indo kag sobra pa. ");
INSERT INTO rol_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kay ang tawo nga igwa ning nabaton nga kamatuuran, taw-an pa gid ning pang-intindi. Pero ang tawo nga wayà ning nabaton nga kamatuuran, aber ang iya naintindihan hay buy-on pa sa iya.” ");
INSERT INTO rol_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Hambay pa gid ni Hesus, “Ang paghaharì ng Dios hay pareho ng tawo nga nagsabwag ng binhì sa dutà. ");
INSERT INTO rol_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Mintras siya nagatrabaho kada adlaw kag nagakatuyog kada gab-i, ang binhì nga iya gingsabwag nagatubò aber wayà niya masayuri kung pauno. ");
INSERT INTO rol_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ang dutà mismo imaw ang nagapatubò kag nagapauhay ng mga tanom: nauna ang pungango, tapos ang uhay kag sa ulihi ang madamò nga bunga. ");
INSERT INTO rol_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Kag kung hinog na, ginaani ng tag-iya kay anihon na.” ");
INSERT INTO rol_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Nagpangutana si Hesus sa inda, “Sa ano naton ikumpara ang paghaharì ng Dios? Ano nga parabola* ang aton gamiton agud maisplikar ini?” Naghambay pa gid siya, ");
INSERT INTO rol_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","“Pareho ini sa busoy ng mustasa*. Ini hay pinakamaisot sa tanan nga busoy sa kalibutan, ");
INSERT INTO rol_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","pero pag natanom na ini, magatubò kag maging pinakamabahoy sa tanan nga utanon kag aber ang mga pispis puydi makapugad sa iya mabahoy nga mga sanga.” ");
INSERT INTO rol_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Madamò pa gid nga parabola ang ginggamit ni Hesus sa iya pagpanudlò, kumpormi sa inda pang-intindi. ");
INSERT INTO rol_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Wayà siya nagatudlò sa inda nga wayà nagagamit ning parabola, pero ginaisplikar niya ini tanan sa iya mga disipulo kung sinda na lang. ");
INSERT INTO rol_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nang adto nga adlaw, manayumsom na, naghambay si Hesus sa iya mga disipulo, “Mos, matabok kita sa kabuak.” ");
INSERT INTO rol_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Nganì gingbayaan ng iya mga disipulo ang madamò nga tawo kag nagsakay sa dyapang nga ginasakyan ni Hesus kag naglarga sinda. May mga dyapang da didto nga nagdungan sa inda. ");
INSERT INTO rol_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kag mintras nagabyahe sinda, gulpi lang nga nagbaskog. Nagbasyada ang humbak sa dyapang kag malapit na mapunò ang inda ginasakyan. ");
INSERT INTO rol_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Pero si Hesus hay nagakatuyog nga may uyunan didto sa ulihi ng dyapang. Gingpukaw ninda siya kag naghambay sinda, “Maestro, basì daw wayà ka nagakabayaka nga malulunod na kita?” ");
INSERT INTO rol_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Nganì nagbangon siya kag gingsabyaw niya ang hangin kag ginghambayan niya ang humbak, “Kalma! Ayaw maghuyop!” Nagduyog ang hangin kag nagkalma gid. ");
INSERT INTO rol_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Pagkatapos naghambay si Hesus sa inda, “Basì nahadlok kamo? Wayà pa ba kamo pagtuo sa akon?” ");
INSERT INTO rol_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Sobra gid ang inda katingaya sa iya kag nagpinangutan-an sinda, “Sin-o gid baya ini nga aber ang hangin kag ang humbak nagatuman sa iya?” ");
INSERT INTO rol_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Pagkatapos adto, nag-abot sinda sa kabuak, sa lugar ng Geraseno. ");
INSERT INTO rol_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nang nakasalta na si Hesus sa dyapang, gingsumpong siya ng isa ka tawo nga halin sa mga lubungan. Siya hay ginasapian ning malain nga espiritu. ");
INSERT INTO rol_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Kag nagaistar siya sa mga lubungan. Indì na gid siya maigapos, aber kadina pa ang gamiton. ");
INSERT INTO rol_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Kay madamò na ka beses ginggapos ang iya mga siki kag kamot, pero ginapangbugtò lang niya ang mga kadina. Wayà gid ning may makapugong sa iya. ");
INSERT INTO rol_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Adlaw kag gab-i, sa mga lubungan o sa mga bakuyod, permi siya nagasininggit kag ginapinilas niya ang iya lawas ning bato. ");
INSERT INTO rol_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Pagkalantaw niya kay Hesus sa malayò, nagdyagan siya palapit kag nagahapà sa atubangan ni Hesus. ");
INSERT INTO rol_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Tapos nagsinggit siya ning makusog, “Hesus, Ungà ng Pinakamataas nga Dios, ano ang imo labot sa akon? Nagapakitluoy ako sa imo sa pangayan ng Dios, ayaw ako pagpahugai!” ");
INSERT INTO rol_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ginghambay niya ini kay gingsugò siya ni Hesus, “Ikaw malain nga espiritu, luwas sa inà nga tawo!” ");
INSERT INTO rol_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Gingpangutana siya ni Hesus, “Ano ang imo pangayan?” Nagsabat siya, “Batalyon kay kadamò-damò kami.” ");
INSERT INTO rol_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Kag nagapinakitluoy siya kay Hesus nga indì sinda palayason didto nga lugar. ");
INSERT INTO rol_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Malapit didto, may kadamò-damò nga baboy nga nagapangibok sa alihid ng bakuyod. ");
INSERT INTO rol_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nagpakitluoy ang malain nga mga espiritu kay Hesus kag naghambay, “Tuguti kami nga magsuyod sa mga baboy.” ");
INSERT INTO rol_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Kag gingtugutan niya sinda. Nagpangluwas ang malain nga mga espiritu kag nagpangsuyod sa mga baboy. Pagkatapos ang tanan nga baboy nga may mga 2,000 hay nagdinagusò sa pangpang hasta sa nagkahuyog sa dagat kag nagkalumos. ");
INSERT INTO rol_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nagdyagan ang mga miyug-alilà ng mga baboy kag gingpinamalità ini sa mga tawo sa banwa kag sa mga baryo. Nganì nagkadto ang mga tawo didto kay Hesus agud siruon kung ano ang natabò. ");
INSERT INTO rol_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pag-abot ninda didto, nakità ninda ang tawo nga dati anay gingsapian ng mga demonyo nga nagapungkò nga nakabarò kag maayo na ang iya isip. Nganì hinadlukan gid sinda. ");
INSERT INTO rol_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ang mga nakakità mismo ang nagbalità parti sa tawo nga dati anay hay may mga demonyo kag sa natabò sa mga baboy. ");
INSERT INTO rol_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Tungod diri, nagpakitluoy sinda kay Hesus nga maghalin sa inda lugar. ");
INSERT INTO rol_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Nang pasakayon na si Hesus sa dyapang, ang tawo nga dati anay gingsapian ng mga demonyo hay nagpangabay nga kung puydi siya magnunot. ");
INSERT INTO rol_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pero wayà siya pagtuguti ni Hesus kundì ang hambay sa iya, “Magbalik ka sa indo bayay kag ibalità sa imo mga kahalihan kung ano ang ginghuman ng Ginoo sa imo kag kung pauno siya naluoy sa imo dati nga kamutangan.” ");
INSERT INTO rol_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nganì nagpanaw ang tawo kag nagkadto sa Decapolis. Kag didto, gingpinamalità niya kung ano ang ginghuman ni Hesus sa iya. Natingaya gid ang tanan nga nakabatì. ");
INSERT INTO rol_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Pagtabok liwat ni Hesus sa kabuak sakay ng dyapang, madamò gid nga tawo ang nagtipon sa iya sa alihid ng dagat. ");
INSERT INTO rol_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Nag-abot da didto ang isa ka opisyal ng sinagoga nga ang pangayan hay Jairus. Pagkakità niya kay Hesus, naghapà siya sa atubangan ni Hesus ");
INSERT INTO rol_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","kag nagpakitluoy gid, “Ang akon ungà nga dalagita hay nagaagunisar na didto sa bayay. Kung puydi kadtua anay kag itungtong ang imo kamot sa iya agud magaayo siya kag mabuhì!” ");
INSERT INTO rol_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Nganì nagnunot si Hesus sa iya. Kag madamò da nga tawo ang nagsunod nga nagadinagusò sa iya. ");
INSERT INTO rol_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","May isa da ka babayi didto nga dose na ka tuig nga ginadinugò. ");
INSERT INTO rol_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Dakò na gid ang nagastos niya sa pagpinabuyong sa sarisarì nga miyugbuyong. Nagastos na niya ang tanan niya nga pagkabutang, pero wayà gid siya nag-ayo. Naggrabi pa gid nganì ang iya sakit. ");
INSERT INTO rol_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nabatian niya ang mga balità parti kay Hesus, nganì nag-itiot siya sa kadamuan agud makapalapit sa likod ni Hesus kag gingtandog niya ang iya barò. ");
INSERT INTO rol_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Kay naghambay siya sa iya kaugalingon, “Kung matandog ko lang aber ang iya barò, magaayo gid ako.” ");
INSERT INTO rol_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nganì gingtandog niya ang gayad ng barò ni Hesus kag nagpara nga daan ang iya pagdugò kag nabatyagan niya nga nag-ayo na siya sa iya sakit. ");
INSERT INTO rol_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nasayuran ni Hesus nga may gahom nga nagluwas halin sa iya, nganì naglingig siya kag nagpangutana, “Sin-o ang nagtandog sa akon barò?” ");
INSERT INTO rol_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Nagsabat ang iya mga disipulo, “Kadamò nga tawo ang nagadinagusò sa imo, basì nagapangutana ka pa kung sin-o ang nagtandog sa imo?” ");
INSERT INTO rol_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pero nagpanglikità pa siya kung sin-o ang nagtandog sa iya. ");
INSERT INTO rol_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nasayuran ng babayi kung ano ang natabò, nganì nagpalapit siya kay Hesus nga nagapangurog sa kahadlok. Naghapà siya kag nagbalità ning matuod. ");
INSERT INTO rol_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Niyan, naghambay si Hesus sa iya, “Nenè, ang imo pagtuo ang nag-ayo sa imo. Nganì magbalik ka kag ayaw na magkabayaka sa imo sakit kay maayo ka na.” ");
INSERT INTO rol_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Mintras nagahambay pa siya sa babayi, may nag-abot nga mga tawo halin sa bayay ni Jairus. Hambay ninda sa iya, “Patay na ang imo ungà. Ayaw na pag-awata ang maestro.” ");
INSERT INTO rol_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Pero wayà pagpanginanuha ni Hesus ang gingbalità. Hambay niya kay Jairus, “Ayaw mahadlok. Magtuo ka lang.” ");
INSERT INTO rol_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Nagderitso lang sinda kag wayà siya may gingpanunot kundì si Pedro kag ang magmanghod nga sina Santiago kag Juan. ");
INSERT INTO rol_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pag-abot ninda sa bayay ni Jairus, nakità ni Hesus nga nagakinagulo ang mga tawo. Ang iban nagatinangis kag ang iban hay nagadinanguyngoy. ");
INSERT INTO rol_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nagsuyod sina Hesus sa bayay kag naghambay siya sa mga tawo, “Basì nagakinagulo kag nagatinangis kamo? Bukon patay ang ungà kundì nagakatuyog lang.” ");
INSERT INTO rol_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Pero gingngitlan lang ninda si Hesus. Nganì gingpaluwas niya ang tanan nga tawo kag gingpasuyod niya sa kwarto ng ungà ang tatay kag nanay kag ang tuyo niya nga kaibahan. ");
INSERT INTO rol_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Pagkatapos ginghawiran niya ang kamot ng ungà kag naghambay, “Talitha, koum!” (ang gusto hambayon, ‘Nenè, bangon na!’) ");
INSERT INTO rol_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Adto nga daan nagbangon ang dalagita kag nagpanaw-panaw. Dakò gid ang katingaya ng tanan. (Siya hay nagaedad ning dose ka tuig.) ");
INSERT INTO rol_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Pero gingbilinan sinda ni Hesus nga indì gid magpamalità aber kanin-o parti sa natabò. Kag gingsugò niya sinda nga taw-an ning pagkaon ang ungà. ");
INSERT INTO rol_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Pagkatapos, naghalin si Hesus kag nagkadto sa iya kaugalingon nga banwa kag nagnunot ang iya mga disipulo. ");
INSERT INTO rol_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Pag-abot ng Adlaw nga Inugpahuway*, nagtudlò siya sa sinagoga. Madamò nga tawo didto ang nakabatì sa iya nga natingaya kag nagpangutana sinda, “Sa diin baya siya nakabuoy ning tiyad inà nga mga pagpanudlò? Ano nga kamayad ang gingtao sa iya? Kag basì nakakahuman siya ning mga milagro? ");
INSERT INTO rol_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Bukon ba imaw ini ang karpentero? Dì ba siya ang ungà ni Maria kag maguyáng nina Santiago, Joses, Judas kag Simon? Kag dì ba ang iya mga manghod nga babayi hay kaibahan naton?” Nganì wayà gid ninda siya gingbatuna. ");
INSERT INTO rol_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Pero naghambay si Hesus sa inda, “Ang propeta hay ginatahod ng mga tawo aber diin nga lugar puyra lang sa kaugalingon niya nga banwa, mga kahalihan kag iya pamilya.” ");
INSERT INTO rol_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Wayà nakahuman si Hesus ning mga milagro sa lugar ng Nazaret, puyra lang sa pila ka may sakit nga gingtungtungan niya ng iya kamot kag nag-ayo. ");
INSERT INTO rol_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Natingaya siya kay wayà sinda magtuo sa iya. Pagkatapos adto ginglibot ni Hesus ang mga baryo kag nagpanudlò siya didto. ");
INSERT INTO rol_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Gingtawag niya ang dose ka apostoles kag gingsugò sinda ning tigduha-duha. Gingtaw-an niya sinda ning otoridad kontra sa malain nga mga espiritu. ");
INSERT INTO rol_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Gingbilinan niya sinda nga indì magdaya ning aber ano sa inda pagpanaw kundì sungkod lang. Indì da sinda magdaya ning pagkaon, bag o kwarta sa inda hagkos. ");
INSERT INTO rol_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Puydi sinda makasuksok ning sandalyas, pero indì sinda magdaya ning ilislan nga barò. ");
INSERT INTO rol_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kag naghambay siya sa inda, “Kung padayunon kamo sa isa ka bayay, didto lang kamo magtinir hasta sa maghalin kamo sa adto nga lugar. ");
INSERT INTO rol_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Pero kung ang mga tawo sa isa ka lugar indì magbaton sa indo kag indì magpamatì ng indo ginawali, bayai nindo sinda. Paghalin nindo, pagpaga ang dapodapo sa indo siki para paandam kontra sa inda.” ");
INSERT INTO rol_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nganì nagpanaw sinda kag nagwali nga ang mga tawo dapat magtalikod sa inda mga salà. ");
INSERT INTO rol_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Madamò nga demonyo ang inda gingpalayas kag madamò nga may sakit ang inda gingpang-ayo nang gingpahiran ning lana. ");
INSERT INTO rol_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nabatian ni Haring Herodes ang mga balità parti kay Hesus kay nabantog na gid siya. Ang iban naghambay, “Si Hesus imaw si Juan nga Miyugbawtismo nga nabanhaw, imaw inà ang rason nga may gahom siya sa paghuman ng mga milagro.” ");
INSERT INTO rol_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Pero naghambay naman ang iban, “Siya hay si Elias nga propeta.” Kag naghambay pa gid ang iban, “Siya hay propeta nga pareho ng isa sa mga propeta nang una.” ");
INSERT INTO rol_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Pagkabatì ni Herodes ini nga balità, naghambay siya, “Nabanhaw si Juan nga akon gingpapugutan ning uyo.” ");
INSERT INTO rol_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Ginghuman ini ni Herodes kay Juan kay nahangit si Herodias sa iya. Tiyad ini ang natabò: Ging-asawa ni Herodes si Herodias, aber ini hay asawa ng iya hali nga si Felipe. Permi lang siya ginahambayan ni Juan, “Bawal sa Kasuguan nga asawahon mo ang asawa ng imo hali.” Nganì para lang kay Herodias, gingpadakop ni Herodes si Juan tapos gingpagapos kag gingpapriso. ");
INSERT INTO rol_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Kag tungod nagdumot si Herodias kay Juan, gusto niya nga ipapatay ini, pero indì niya mahuman kay indì magsugot si Herodes. ");
INSERT INTO rol_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Nahadlok si Herodes kay Juan kay nasayuran niya nga si Juan hay matarong kag diosnanon nga tawo. Nganì gingproteksyunan niya si Juan agud indì mauno. Gusto niya nga magpamatì sa mga wali ni Juan aber nalilito siya sa iya mga nabatian. ");
INSERT INTO rol_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nang ulihi, nag-abot gid ang tyempo nga ginahuyat ni Herodias. Natabò ini sa silibrasyon ng pag-ungà kay Herodes. Nagpapunsyon si Herodes kag ging-imbitar niya ang mga opisyales ng Galilea, mga kumander ng mga sundalo ng Roma kag ang mga kilaya nga tawo didto. ");
INSERT INTO rol_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Nagsuyod ang dalaga nga ungà ni Herodias kag nagsaot. Nalipay gid si Herodes kag ang iya mga bisita. Nganì naghambay si Herodes sa dalaga, “Pangayò sa akon ning aber ano nga imo magustuhan kay itao ko sa imo.” ");
INSERT INTO rol_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Kag gingpangakò niya sa dalaga, “Taw-an ta ikaw ning aber ano nga imo pangayuon, aber pa katungà ng akon nasasakupan.” ");
INSERT INTO rol_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nagluwas ang dalaga kag nagpangutana sa iya nanay, “Ano ang akon pangayuon?” Nagsabat ang iya nanay, “Ang uyo ni Juan nga Miyugbawtismo.” ");
INSERT INTO rol_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Kag adto nga daan nagbalik siya sa harì kag naghambay, “Gusto ko nga itao mo sa akon arinyan ang uyo ni Juan nga Miyugbawtismo nga nakabutang sa plangganita.” ");
INSERT INTO rol_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Pagkabatì adto ni Herodes, nalisod gid siya. Pero tungod nga nakasumpà na busà siya kag nabatian da ini ng mga bisita, indì niya gusto nga masirà ang iya ginghambay sa dalaga. ");
INSERT INTO rol_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Adto nga daan gingsugò niya ang isa ka sundalo nga day-on sa iya ang uyo ni Juan. Nganì nagkadto ang sundalo sa prisuhan kag gingpugutan ning uyo si Juan. ");
INSERT INTO rol_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Pagkatapos gingbutang niya ini sa plangganita kag gingtao sa dalaga nga gingtao naman sa iya nanay. ");
INSERT INTO rol_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Pagkabatì ng mga disipulo ni Juan parti sa natabò, nagkadto sinda kag gingbuoy ang lawas niya kag ginglubong. ");
INSERT INTO rol_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Niyan, nagbalik kay Hesus ang mga apostoles nga nagpanaw para magwali. Gingbalità ninda sa iya ang tanan nga inda ginghuman kag gingpanudlò. ");
INSERT INTO rol_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Tungod sa kadamò ng mga tawo nga nagaabot kag nagahalin, wayà na gid sinda ning oras aber magkaon. Nganì naghambay si Hesus sa iya mga apostoles, “Mos, makadto kita sa tiway nga lugar agud makapahuway-huway kita.” ");
INSERT INTO rol_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Nganì nagsakay sinda sa dyapang kag nagkadto sa tiway nga lugar. ");
INSERT INTO rol_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pero nakilaya sinda ng madamò nga tawo nga nakakità sa inda paglarga. Nganì nagdyagan ang mga tawo halin sa iba-iba nga mga banwa pakadto sa gingkadtuan nina Hesus kag nauna pa sinda pag-abot didto. ");
INSERT INTO rol_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Pagsalta ni Hesus sa dyapang, nakità niya ang madamò gid nga tawo nga nagatipon didto kag naluoy gid siya sa inda kay pareho sinda sa mga karnero nga wayà ning pastor*. Nganì gingtudluan niya sinda ning madamò nga butang. ");
INSERT INTO rol_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nang Manayumsom na, nagpalapit ang mga disipulo kay Hesus. Hambay ninda, “Manayumsom na kag yari pa kita diri sa tiway nga lugar. ");
INSERT INTO rol_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Pakadtua na ang mga tawo sa mga sityo kag sa mga baryo sa palibot agud makabakay sinda ning pagkaon.” ");
INSERT INTO rol_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Pero naghambay si Hesus sa inda, “Kamo mismo ang magtao ning pagkaon sa inda.” Nagpangutana sinda sa iya, “Ano? Mapanaw ba kami kag magbakay ning pagkaon nga duha ka gatos nga denarius* agud ipakaon sa inda?” ");
INSERT INTO rol_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nagsabat si Hesus, “Pila ka bilog ang indo tinapay dirà? Tan-awa abi nindo.” Nang makità ninda, naghambay sinda, “Lima lang kag duha nga isdà.” ");
INSERT INTO rol_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Pagkatapos gingsugò ni Hesus ang mga tawo nga magpungkò ning grupo-grupo sa gunahon. ");
INSERT INTO rol_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Nganì nagpungkò ang mga tawo ning tig-100 kag tig-50. ");
INSERT INTO rol_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Pagkatapos gingbuoy ni Hesus ang lima ka bilog nga tinapay kag duha ka bilog nga isdà, naghangad siya sa langit kag nagpasalamat sa Dios. Gingbuak-buak niya ang tinapay kag gingtao sa iya mga disipulo para ipanagtag sa mga tawo. Kag gingparte-parte da niya ang isdà para sa tanan. ");
INSERT INTO rol_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nakakaon sinda tanan kag nabusog gid. ");
INSERT INTO rol_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Pagkatapos gingtipon ninda ang mga nabilin nga tinapay kag isdà kag napunò ang dose pa ka ayat*. ");
INSERT INTO rol_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ang mga lyaki nga nakakaon hay 5,000. ");
INSERT INTO rol_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Adto nga daan gingsugò ni Hesus ang iya mga disipulo nga magsakay sa dyapang kag mag-una didto sa kabuak sa Betsaida, mintras ginapabalik niya ang mga tawo. ");
INSERT INTO rol_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Nang makahalin na ang mga tawo, nagtukad siya sa bakuyod para magpangamuyò. ");
INSERT INTO rol_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nang gab-i na, yadto na ang dyapang sa tungà ng dagat kag si Hesus yadto pa sa takas nga siya lang. ");
INSERT INTO rol_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Nakità niya nga ginahugaan sinda sa pagbugsay kay sungsungon sa hangin. Nang aga-aga na, nagkadto si Hesus didto sa inda nga nagapanaw sa ibabaw ng dagat. Malampas lang kuntà siya sa inda, ");
INSERT INTO rol_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","pero nang makità ninda nga nagapanaw siya sa ibabaw ng dagat, ang kalaom ninda hay muyto siya kag nagsinggit sinda, “Muyto!” ");
INSERT INTO rol_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Kay nang makità ninda siya, hinadlukan gid sinda. Pero naghambay nga daan si Hesus sa inda, “Paisuga ang indo tagipusuon, ako ini! Ayaw kamo mahadlok.” ");
INSERT INTO rol_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Kag nagsakay siya sa dyapang kag nagduyog ang makusog nga hangin. Kag natingaya gid sinda, ");
INSERT INTO rol_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","kay aber nakità na ninda ang milagro nga ginghuman niya sa tinapay, wayà pa gid sinda makaintindi ng gusto hambayon adto nga ginapakità kung sin-o siya, kay matugas ang inda uyo. ");
INSERT INTO rol_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Pag-abot nina Hesus sa kabuak, nagdunggò sinda sa banwa ng Genesaret kag gingpunduhan ninda ang dyapang. ");
INSERT INTO rol_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pagsalta ninda, nakilaya nga daan ng mga tawo si Hesus. ");
INSERT INTO rol_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Nganì nagdalì-dalì ang mga tawo nga nagkadto sa palibot nga mga lugar kag gingpangdaya ninda ang mga may sakit nga nagahigdà sa banig kung sa diin ninda nabatian nga yadto si Hesus. ");
INSERT INTO rol_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Aber diin siya magkadto: sa mga baryo, sa mga syudad o sa mga sityo man, basta mabatian ng mga tawo nga yadto siya, ginadaya ninda ang inda mga may sakit sa mga lugar nga bakyanan kag baligyaan. Nagpakitluoy sinda kay Hesus nga tugutan niya ang mga may sakit nga makatandog aber lang sa gayad ng iya barò. Kag ang tanan nga nakatandog hay nag-ayo. ");
INSERT INTO rol_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","May mga Pariseo* kag pila ka mga eskriba nga nag-abot halin sa Jerusalem ang nagtipon sa palibot ni Hesus. ");
INSERT INTO rol_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Nakità ninda nga ang iban nga iya mga disipulo hay nagakaon nga wayà nagapanghinaw ng inda mga kamot. Ini hay kontra sa tradisyon ng mga Pariseo. ");
INSERT INTO rol_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Bukon lang ang mga Pariseo kundì ang tanan nga Judio hay wayà nagakaon kung indì anay makahugas ng inda mga kamot sunò sa tradisyon ng inda mga kalulo-lulohan. ");
INSERT INTO rol_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Indì da sinda makakaon ning aber ano nga naghalin sa merkado kung indì anay ninda mahugasan. Madamò pa gid ang inda mga tradisyon pareho ng pagpanghugas ng mga tasa, kuyon kag kaldero nga lutuan.) ");
INSERT INTO rol_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Nganì nagpangutana kay Hesus ang mga Pariseo kag ang mga eskriba, “Basì ang imo mga disipulo hay wayà nagatuman ng mga tradisyon ng aton mga kalulo-lulohan? Nagakaon sinda nga wayà nagapanghinaw ng inda mga kamot.” ");
INSERT INTO rol_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Nagsabat si Hesus sa inda, “Tamà gid ang gingpropesiya ni Isaias parti sa indo nga mga hipokrito. Sunò sa gingsulat niya, ‘Ini nga mga tawo hay nagatahod sa akon sa bàbà lang, pero ang inda tagipusuon malayò sa akon. ");
INSERT INTO rol_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Wayà puyos ang inda pagsamba sa akon, kay ang inda mga ginatudlò hay mga tradisyon nga ginghuman lang ng mga tawo.’ ");
INSERT INTO rol_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Wayà nindo ginabatuna ang ginasugò ng Dios, kundì ang mga tradisyon ng mga tawo imaw ang indo ginatuman.” ");
INSERT INTO rol_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Naghambay pa gid si Hesus, “Maayo gid kamo maghuman ning paagi agud indì matuman ang sugò ng Dios para masunod lang ang indo mga tradisyon. ");
INSERT INTO rol_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Pareho abi ini: naghambay si Moises, ‘Tahura ang imo tatay kag nanay’ kag ‘Ang nagahambay ning malain sa iya tatay o nanay dapat gid patyon’. ");
INSERT INTO rol_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pero kamo nagatudlò nga kung ang tawo may ikakabulig sa iya tatay o nanay kag nagahambay siya sa inda, ‘Korban ini’ (ang gusto hambayon, inughalad* ini sa Dios), ");
INSERT INTO rol_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","wayà na nindo siya ginatuguti nga magbulig sa iya tatay o nanay. ");
INSERT INTO rol_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Paagi sa indo gingmana nga tradisyon, ginahuman nindo nga wayà ning puyos ang hambay ng Dios. Kag madamò pa gid nga tiyad ini ang indo ginahuman.” ");
INSERT INTO rol_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Pagkatapos gingtawag liwat ni Hesus ang mga tawo kag hambay niya, “Pamatì kamo tanan sa akon kag intindihon nindo ang akon ihambay. ");
INSERT INTO rol_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Wayà ning butang nga nagasuyod sa tawo nga nagapahigkò sa iya, kundì ang mga nagaluwas.” ");
INSERT INTO rol_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Dapat intindihon gid nindo maayo ang indo nababatian! ");
INSERT INTO rol_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Pagkatapos gingbayaan niya ang mga tawo kag nagsuyod siya sa bayay. Nang sa suyod na siya, ang iya mga disipulo hay nagpangutana sa iya kung ano ang gusto hambayon ng adto nga parabola. ");
INSERT INTO rol_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Nagsabat si Hesus sa inda, “Basì wayà pa ba kamo makaintindi? Wayà ba nindo masayuri nga ang aber ano nga nagasuyod sa tawo hay wayà nagapahigkò sa iya? ");
INSERT INTO rol_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kay wayà ini nagasuyod sa iya tagipusuon kundì sa iya tiyan kag sa ulihi nagaluwas sa iya lawas.” (Sa ini nga ginghambay ni Hesus ginapasayod niya nga puydi na kaunon ang tanan nga pagkaon.) ");
INSERT INTO rol_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Naghambay pa gid siya, “Ang nagaluwas sa tawo imaw ang nagapahigkò sa iya. ");
INSERT INTO rol_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kay sa tagipusuon ng tawo nagahalin ang malain nga mga panghunahunà nga imaw ang nagatuyod sa iya sa pagpakig-relasyon ning imoral, pagpangawat, pagpatay, ");
INSERT INTO rol_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","pagpangawatan, pagkahakog, paghuman ng tanan nga kalainan, pagpangluko, pag-inuyag, pagkaili, paghambay ning malain kontra sa isigkatawo, paghinambog kag paghuman ng mga kalukuhan. ");
INSERT INTO rol_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ini tanan nga kalainan hay nagahalin sa suyod ng tagipusuon ng tawo kag imaw ini ang nagapahigkò sa iya.” ");
INSERT INTO rol_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Naghalin si Hesus didto kag nagkadto sa mga lugar ng Tyre. Pag-abot niya didto nagdayon siya sa isa ka bayay kay indì niya gusto nga masayuran ng mga tawo nga yadto siya. Pero nasasayuran da gihapon ini ng mga tawo. ");
INSERT INTO rol_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Igwa ning isa ka babayi nga Griego nga taga-Fenicia nga sakop ng Syria. May maisot siya nga ungà nga babayi nga ginasapian ng malain nga espiritu. Nang mabatian niya nga yadto si Hesus, nagkadto nga daan siya didto. Naghapà siya kag nagpakitluoy nga kung puydi palayason niya ang malain nga espiritu sa iya ungà nga babayi. ");
INSERT INTO rol_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Pero naghambay si Hesus sa iya paagi sa parabola, “Dapat pakaunon anay ang mga ungà, kay bukon maayo nga buy-on ang pagkaon ng mga ungà kag ipilak sa mga ayam.” ");
INSERT INTO rol_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nagsabat ang babayi sa iya, “Huo Ginoo, pero aber pa ang mga ayam sa idayom ng lamisa hay nagakaon ning mga uyak ng mga ungà.” ");
INSERT INTO rol_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Naghambay si Hesus sa iya, “Tungod sa imo gingsabat, puydi ka na magbalik. Kay nagluwas na ang demonyo sa imo ungà!” ");
INSERT INTO rol_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nagbalik ang babayi kag nakità niya ang iya ungà nga nagahigdà sa katri kag ang demonyo hay nagluwas na. ");
INSERT INTO rol_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Paghalin ni Hesus sa mga lugar nga sakop ng Tyre, nag-agi siya sa Sidon kag sa probinsya ng Decapolis. Pagkatapos nagderitso siya sa Lawà ng Galilea*. ");
INSERT INTO rol_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","May isa ka tawo didto nga bungoy kag apà nga gingdaya ng mga tawo sa iya. Nagpakitluoy sinda kay Hesus nga paayuhon ang tawo. ");
INSERT INTO rol_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Gingbuyag siya ni Hesus sa kadamuan kag gingsuksok niya ang iya mga tudlò sa talinga ng tawo. Pagkatapos nagpilà siya sa iya kamot kag gingpahid sa dilà ng tawo. ");
INSERT INTO rol_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Pagkatapos naghangad si Hesus sa langit, nagginhawa ning madayom kag naghambay sa iya, “Effata!” ang gusto hambayon, ‘Magbukas!’ ");
INSERT INTO rol_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Adto nga daan nakabatì siya kag klaro na ang iya paghambay. ");
INSERT INTO rol_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Gingbilinan ni Hesus ang mga tawo nga indì gid sinda magpamalità aber kanin-o parti sa natabò. Pero aber gingbawalan sinda, lalò pa gid nga gingpinamalità ninda ang natabò. ");
INSERT INTO rol_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Sobra gid ang katingaya ng mga tawo. Hambay ninda, “Kaayo-ayo gid ang iya mga ginghuman! Aber ang bungoy hay napabatì niya kag ang apà hay napahambay niya!” ");
INSERT INTO rol_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Adto da nga mga adlaw, nagtipon liwat ang madamò nga tawo kay Hesus. Nang wayà na gid sinda ning pagkaon, gingtawag ni Hesus ang iya mga disipulo kag naghambay sa inda, ");
INSERT INTO rol_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Naluoy gid ako sa ini nga mga tawo. Kay tuyo na ka adlaw nga kaibahan ninda ako kag naubos na ang inda pagkaon. ");
INSERT INTO rol_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kung pabalikon ko sinda nga gutom, basì kung malipungan sinda sa dayan kay malayò gid ang ginghalinan ng iban sa inda.” ");
INSERT INTO rol_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Nagpangutana ang iya mga disipulo, “Sa diin baya kita makabuoy ning pagkaon diri sa tiway nga lugar para ipakaon sa ini nga mga tawo?” ");
INSERT INTO rol_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Pero nagpangutana si Hesus sa inda, “Pila ka bilog ang indo tinapay dirà?” Nagsabat sinda, “Pito.” ");
INSERT INTO rol_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Kag gingpapungkò ni Hesus ang mga tawo sa dutà. Gingbuoy niya ang pito ka tinapay kag nagpasalamat sa Dios. Pagkatapos gingbuak-buak niya ini kag gingtao sa iya mga disipulo agud ipanao sa mga tawo. Nganì nagpanao sinda sa mga tawo. ");
INSERT INTO rol_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Igwa da sinda ning pila ka bilog nga maintik nga mga isdà. Gingpasalamatan da niya ini kag gingtao sa iya mga disipulo agud ipanao sa mga tawo. ");
INSERT INTO rol_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nagkaon sinda kag nabusog gid. Pagkatapos, gingtipon ninda ang mga nabilin nga sobra kag napunò pa ang pito ka bangkat*. ");
INSERT INTO rol_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Kag mga 4,000 ang mga tawo nga nakakaon. Nang matapos adto, gingpabalik na ni Hesus ang mga tawo. ");
INSERT INTO rol_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Kag nagsakay nga daan siya sa dyapang* kaibahan ang iya mga disipulo kag nagtabok pakadto sa lugar ng Dalmanuta. ");
INSERT INTO rol_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pag-abot ninda didto, may mga Pariseo nga nagpalapit kay Hesus para magpakigdibati sa iya. Kay gusto ninda nga tistingon siya. Nganì nagpangayò sinda sa iya ning milagro halin sa langit para pamatuuran nga gingsugò siya ng Dios. ");
INSERT INTO rol_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Pero nagpanghaw-os si Hesus kag naghambay, “Basì baya nagapangayò ning milagro ang mga tawo sa ini nga henerasyon? Sa matuod lang ginahambay ko sa indo nga wayà ning milagro nga ipakità sa ini nga henerasyon!” ");
INSERT INTO rol_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Kag gingbayaan niya sinda. Nagsakay siya liwat kag ang iya mga disipulo sa dyapang kag nagtabok sa kabuak. ");
INSERT INTO rol_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Nalimutan ng iya mga disipulo nga magdaya ning tinapay puyra lang sa isa ka bilog nga nadaya ninda sa dyapang. ");
INSERT INTO rol_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Gingpaandaman sinda ni Hesus paagi sa parabola, “Magdahan kamo kag mag-andam sa pampaalsa ng mga Pariseo kag ni Herodes.” ");
INSERT INTO rol_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Nang mabatian ini ng iya mga disipulo, naghambay sinda sa isa kag isa, “Siguro ginghambay niya ini kay wayà kita ning tinapay.” ");
INSERT INTO rol_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Nasayuran ni Hesus kung ano ang inda ginainistorya. Nganì naghambay siya sa inda, “Basì nagainistorya kamo nga wayà tinapay? Wayà pa gid ba kamo makasayod o makaintindi? Matugas pa gid ang indo uyo? ");
INSERT INTO rol_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","Igwa kamo mga mata, pero indì kamo makakità. Igwa kamo mga talinga, pero indì kamo makabatì. Wayà ba nindo madumdumi nang gingbuak-buak ko ang lima ka tinapay para sa 5,000 nga tawo? Pila ba ka ayat ang napunò nang gingtipon nindo ang mga nabilin nga tinapay?” Nagsabat sinda, “Dose!” ");
INSERT INTO rol_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Nagpangutana pa gid si Hesus, “Kag nang gingbuak-buak ko ang pito ka tinapay para sa 4,000, pila ba ka bangkat ang napunò nang gingtipon nindo ang wayà maubos nga pagkaon?” Nagsabat sinda, “Pito!” ");
INSERT INTO rol_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Kag naghambay si Hesus, “Dapat naintindihan nindo nga bukon tinapay ang akon gusto hambayon kaina.” ");
INSERT INTO rol_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Pag-abot ninda sa Betsaida, may mga tawo didto nga nagdaya ning buta nga lyaki kay Hesus. Nagpakitluoy sinda sa iya nga kung puydi paayuhon niya ang tawo agud makakità. ");
INSERT INTO rol_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Nganì ginghawiran niya ang kamot ng tawo kag gingdaya pakadto sa luwas ng Betsaida. Pag-abot ninda sa luwas, gingpil-an niya sa mata ang buta. Kag gingbutang niya ang iya kamot sa buta kag nagpangutana, “May nakikità ka na ba?” ");
INSERT INTO rol_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nag-indahat ang lyaki kag naghambay, “Nakakakità na ako ning mga tawo, pero daw pareho ning mga kahoy nga nagapanaw.” ");
INSERT INTO rol_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Nganì gingbutang liwat ni Hesus ang iya kamot sa mata ng tawo. Pagkatapos nagsirò siya ning maayo kag nagbalik ang iya panirò. Mahayag na gid ang tanan sa iya panglikità. ");
INSERT INTO rol_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Gingpabalik siya ni Hesus kag gingbilinan, “Ayaw na magbalik sa Betsaida.” ");
INSERT INTO rol_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Pagkatapos adto, nagkadto si Hesus kag ang iya mga disipulo sa mga baryo nga sakop ng Cesarea Filipos. Mintras nagapanaw sinda, nagpangutana si Hesus sa iya mga disipulo, “Sin-o kuno ako sunò sa hambay ng mga tawo?” ");
INSERT INTO rol_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Nagsabat sinda, “May mga nagahambay nga ikaw si Juan nga Miyugbawtismo. Ang iban nagahambay nga ikaw si Elias; kag ang iban pa gid nagahambay nga ikaw hay isa sa mga propeta.” ");
INSERT INTO rol_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Pagkatapos nagpangutana siya sa inda, “Hay kamo, ano ang indo mahahambay, sin-o ako?” Nagsabat si Pedro, “Ikaw imaw ang Kristo*!” ");
INSERT INTO rol_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Nang mabatian ni Hesus ang sabat, gingpaandaman niya sinda nga indì gid magbalità aber kanin-o kung sin-o siya. ");
INSERT INTO rol_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Pagkatapos nagtudlò si Hesus sa inda, “Ako nga Ungà ng Tawo hay dapat gid mag-agi ning sobra nga mga kahugaan kag sikwayon ako ng mga miyugdumaya ng Judio, ng mga pinunò nga parì kag ng mga eskriba. Ipapatay ninda ako, pero pagkaligad ng tuyo ka adlaw mababanhaw ako.” ");
INSERT INTO rol_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Gingklaro gid niya ini sa inda. Pagkabatì adto ni Pedro, gingdaya niya si Hesus sa alihid kag gingsabyaw nga indì adto puydi. ");
INSERT INTO rol_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pero naglingig si Hesus, nagsirò sa iya mga disipulo kag gingsabyaw si Pedro, “Satanas, lumayas ka sa akon atubangan! Kay ang imo ginahunahunà bukon halin sa Dios kundì sa tawo.” ");
INSERT INTO rol_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kag gingtawag niya ang mga tawo kaibahan ang iya mga disipulo nga magpalapit. Naghambay siya sa inda, “Ang aber sin-o nga gusto magsunod sa akon, dapat indì niya palabihon ang iya kaugalingon, kundì pas-anon niya ang iya krus kag magsunod sa akon. ");
INSERT INTO rol_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kay ang aber sin-o nga nagapalabi ng iya kabuhì hay maduduyaan ini pero ang aber sin-o nga nagahalad ng iya kabuhì tungod sa akon kag sa Maayong Balità, makakabaton siya ning kabuhì nga wayà katapusan. ");
INSERT INTO rol_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Kay ano gid baya ang mapupuslan ng tawo kung maangkon man niya ang tanan nga butang diri sa kalibutan, pero mawad-an naman siya ning kabuhì? Wayà gid! ");
INSERT INTO rol_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Kay wayà gid ning butang nga puydi niya itao agud mapapabalik niya ang iya kabuhì. ");
INSERT INTO rol_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ang aber sin-o nga nagakahuyà sa akon kag sa akon mga ginatudlò sa ini nga tyempo nga ang mga tawo nga malain kag bukon diosnanon, ikahuyà ko da siya pag ako nga Ungà ng Tawo hay magbalik nga may kadakò nga kahimayaan ng akon Amay, kaibahan ang balaan nga mga anghel.” ");
INSERT INTO rol_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Naghambay pa gid si Hesus sa inda, “Sa matuod lang ginahambay ko sa indo, may pila ka tawo diri nga indì pa mamatay hasta nga makità ninda ang paghaharì ng Dios nga magaabot nga may gahom.” ");
INSERT INTO rol_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Pagkaligad ng unom ka adlaw, gingdaya ni Hesus sina Pedro, Santiago* kag Juan sa mataas nga bukid nga sinda lang. Kag gulpi lang nga nagbaylo ang hitsura ni Hesus sa inda atubangan. ");
INSERT INTO rol_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ang iya barò hay kasilaw-silaw sa kaputì. Wayà ning aber sin-o diri sa kalibutan ang makapaputì ng tiyad adto. ");
INSERT INTO rol_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Pagkatapos nagpakità sa inda sina Elias kag Moises nga nagapakig-istorya kay Hesus. ");
INSERT INTO rol_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Naghambay si Pedro kay Hesus, “Maestro, maayo gid kay yari na kita diri. Mahuman kami ning tuyo ka bayay-bayay, ang isa para sa imo, ang isa kay Moises kag ang isa pa kay Elias.” ");
INSERT INTO rol_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Wayà siya makasayod kung ano ang iya dapat ihambay kay ginahadlukan gid sinda. ");
INSERT INTO rol_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tapos may nag-abot nga panganod kag gingtabunan sinda. Kag may nabatian sinda nga boses halin sa panganod nga nagahambay, “Imaw ini ang akon pinalanggà nga Ungà. Pamatii nindo siya!” ");
INSERT INTO rol_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Dalì-dalì sinda nga nagsirò patiyog, pero wayà na sinda ning may nakità kundì si Hesus lang. ");
INSERT INTO rol_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nang nagapatugbong na sinda sa bukid, gingbilinan sinda ni Hesus nga indì gid magpamalità aber kanin-o kung ano ang inda nakità hasta siya nga Ungà ng Tawo hay mabanhaw. ");
INSERT INTO rol_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Nganì wayà gid ninda gingpamalità adto nga natabò, pero nang sinda na lang nga tuyo, nagpinangutan-an sinda kung ano ang gusto hambayon ng pagkabanhaw. ");
INSERT INTO rol_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Kag nagpangutana sinda kay Hesus, “Basì nagahambay ang mga eskriba nga kahinangyan mag-abot anay si Elias bago mag-abot ang Kristo?” ");
INSERT INTO rol_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Nagsabat siya, “Tamà inà, dapat mag-abot anay si Elias agud ipreparar niya ang tanan nga butang. Basì baya gingsulat da nga ang Ungà ng Tawo dapat mag-agi ning sobra nga mga kahugaan kag indì siya batunon ng mga tawo? ");
INSERT INTO rol_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pero ginahambay ko sa indo, si Elias hay nag-abot na kag ginghuman ng mga tawo sa iya ang inda gusto sunò sa gingsulat parti sa iya.” ");
INSERT INTO rol_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Pagbalik nina Hesus sa mga disipulo nga nabilin, nakità ninda nga madamò nga tawo ang nagatipon didto sa inda. May pila da ka mga eskriba nga nagapakigdibati sa mga disipulo. ");
INSERT INTO rol_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Pagkakità ng mga tawo kay Hesus, natingaya gid sinda. Adto nga daan nagdyagan sinda pakadto sa iya agud kamustahon siya. ");
INSERT INTO rol_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Nagpangutana si Hesus sa inda, “Ano ang indo ginadibatihan?” ");
INSERT INTO rol_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Kag may isa ka tawo didto sa mga nagatipon nga nagsabat, “Maestro, gingdaya ko diri sa imo ang akon ungà nga lyaki kay ginasapian siya ng malain nga espiritu. Nganì indì na siya makahambay. ");
INSERT INTO rol_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kada siya ginasapian, ginatumba siya sa dutà, nagabuyà ang iya bàbà kag nagapagot ang iya mga ngipon. Pagkatapos nagapanugas siya. Nagpabulig ako sa imo mga disipulo nga palayason ini, pero indì ninda mapalayas.” ");
INSERT INTO rol_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Nagsabat si Hesus, “Kamo nga mga tawo sa ini nga henerasyon hay wayà gid ning pagtuo! Hasta san-o pa baya ang akon pag-antos sa indo? Day-a diri sa akon ang ungà.” ");
INSERT INTO rol_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Nganì gingdaya ninda ang ungà sa iya. Pagkakità ng malain nga espiritu kay Hesus, adto nga daan gingpakurog niya ang ungà, gingtumba kag gingpaligid sa dutà nga nagabuyà ang iya bàbà. ");
INSERT INTO rol_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Gingpangutana ni Hesus ang tatay ng ungà, “Kasan-o pa siya nagtiyad ini?” Nagsabat ang tatay, “Tunà nang ungà pa siya. ");
INSERT INTO rol_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Permi siya ginatumba ng malain nga espiritu sa kalayo kag sa tubì agud patyon. Pero kung may mahuhuman ka, kaluy-i kag buligi abi kami!” ");
INSERT INTO rol_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Naghambay si Hesus sa iya, “Basì nagahambay ka nga ‘Kung may mahuhuman ako’? Ang tanan nga butang mahuhuman ko sa tawo nga nagatuo sa akon.” ");
INSERT INTO rol_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Kag nagsabat ang tatay ng ungà, “Nagatuo ako, pero buligi ako nga madugangan pa ang akon pagtuo.” ");
INSERT INTO rol_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Pagkakità ni Hesus nga nagapakadamò na ang mga tawo palapit sa iya, gingsabyaw niya ang malain nga espiritu, “Ikaw, espiritu nga nagapaapà kag nagapabungoy sa ini nga ungà, ginasugò ta ikaw, luwas dirà kag ayaw na gid magbalik!” ");
INSERT INTO rol_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nagsinggit ang malain nga espiritu kag gingpakurog niya ang ungà ning tudo kag nagluwas. Ang ungà daw patay na, nganì naghambay ang kadamuan, “Patay na siya!” ");
INSERT INTO rol_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pero ginghawiran ni Hesus ang kamot ng ungà, gingpabangon niya kag nagtindog siya. ");
INSERT INTO rol_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Pagsuyod nina Hesus sa bayay, nagpangutana ang iya mga disipulo nang sinda na lang, “Basì baya wayà namon mapalayas ang malain nga espiritu?” ");
INSERT INTO rol_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Nagsabat siya sa inda, “Adto nga klasi ng malain nga espiritu, mapalayas lang paagi sa pangamuyò.” ");
INSERT INTO rol_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Paghalin nina Hesus didto, nag-agi sinda sa probinsya ng Galilea. Indì niya gusto nga masayuran ng mga tawo nga yadto siya, ");
INSERT INTO rol_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kay nagatudlò siya sa iya mga disipulo. Naghambay siya sa inda, “Ako nga Ungà ng Tawo hay itugyan sa mga tawo nga magapatay sa akon, pero pagkaligad ng tuyo ka adlaw mababanhaw ako.” ");
INSERT INTO rol_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ang iya mga disipulo hay wayà makaintindi kung ano ang iya gusto hambayon. Pero nahadlok sinda magpangutana sa iya. ");
INSERT INTO rol_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Nag-abot sina Hesus sa Capernaum. Nang yadto na sinda sa bayay, nagpangutana si Hesus sa inda, “Ano ba ang indo ginainistorya sa dayan?” ");
INSERT INTO rol_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pero naghipos lang sinda kay ang gingdiniskusyunan ninda hay kung sin-o gid sa inda ang labaw sa tanan. ");
INSERT INTO rol_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Nganì nagpungkò si Hesus kag gingtawag niya ang dose nga disipulo. Kag naghambay siya sa inda, “Kung sin-o sa indo ang gusto nga maging pinunò, dapat mapainubuson siya kag maging suluguon ng tanan.” ");
INSERT INTO rol_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Pagkatapos nagbuoy siya ning isa ka ungà kag gingpatindog niya sa inda tungà. Tapos gingkugos niya ini kag naghambay sa inda, ");
INSERT INTO rol_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ang aber sin-o nga nagabaton sa ungà nga tiyad ini tungod sa akon hay nagabaton sa akon. Kag ang nagabaton sa akon, bukon lang sa akon kundì nagabaton da sa nagsugò sa akon.” ");
INSERT INTO rol_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Niyan naghambay si Juan sa iya, “Maestro, nakakità kami ning isa ka tawo nga nagapalayas ng mga demonyo kag ang pangayan mo ang iya ginagamit. Gingpapara namon siya kay bukon naton siya kaibahan.” ");
INSERT INTO rol_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Pero naghambay si Hesus, “Pabay-i lang nindo siya kay wayà ning may nagahuman ning milagro paagi sa akon pangayan kag malagat-lagat magahambay ning malain kontra sa akon. ");
INSERT INTO rol_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ang aber sin-o nga wayà nagakontra sa aton hay kaibahan naton. ");
INSERT INTO rol_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Sa matuod lang ginahambay ko sa indo, ang aber sin-o nga magtao sa indo ning bisan isa lang ka baso nga tubì tungod kamo hay nagasunod sa akon, siya hay makakabaton gid ng iya bayos. ");
INSERT INTO rol_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ang aber sin-o nga maging kabangdanan nga makasalà ang isa sa ini nga bag-o nga nagatuo sa akon, mas maayo pa sa iya nga higutan ang iya liog ning mabahoy nga galingan nga bato kag itagbong sa dagat. ");
INSERT INTO rol_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kung ang imo kamot imaw ang kabangdanan nga nagakasalà ka, utura inà! Mas maayo pa nga may kabuhì ka nga wayà katapusan nga isa lang ang imo kamot, kaysa sa duha ang imo kamot pero makadto ka naman sa impyerno. Ang kalayo didto indì gid mamatay. ");
INSERT INTO rol_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ang mga uyod didto wayà ning kamatayon kag ang kalayo indì mamatay. ");
INSERT INTO rol_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Kag kung ang imo siki imaw ang kabangdanan nga nagakasalà ka, utura inà! Mas maayo pa nga may kabuhì ka nga wayà katapusan nga isa lang ang imo siki, kaysa sa duha ang imo siki pero ipilak ka naman sa impyerno. ");
INSERT INTO rol_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ang mga uyod didto wayà ning kamatayon kag ang kalayo indì mamatay. ");
INSERT INTO rol_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kag kung ang imo mata imaw ang kabangdanan nga nagakasalà ka, lukata inà! Mas maayo pa nga magsuyod ka sa gingharian ng Dios nga isa lang ang imo mata, kaysa sa duha ang imo mata pero ipilak ka naman sa impyerno. ");
INSERT INTO rol_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ang mga uyod didto wayà ning kamatayon kag ang kalayo indì mamatay. ");
INSERT INTO rol_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Kay ang tanan limpyuhon paagi sa kalayo pareho ng ginatao sa Dios nga ginaasinan anay. ");
INSERT INTO rol_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ang asin hay maayo. Pero kung maduyà na ang sabor ng asin, indì na gid ini mapuslan kag pauno pa mapabalik ang iya kaasin? Dapat maging pareho kamo sa asin nga nagabulig sa kada isa nga maayo ang indo relasyon.” ");
INSERT INTO rol_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Pagkatapos adto naghalin si Hesus sa Capernaum* kag nagkadto siya sa mga lugar nga sakop ng Judea. Kag nagtabok siya sa Subà ng Jordan. Madamò nga tawo ang nagtipon didto liwat sa iya kag gingtudluan niya sinda pareho ng permi niya nga ginahuman. ");
INSERT INTO rol_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","May mga Pariseo* nga nagkadto da didto. Nagapangità sinda ning paagi para tistingon ninda siya. Nganì nagpangutana sinda kay Hesus, “Ginatugutan ba ng Kasuguan nga buyagan ng lyaki ang iya asawa?” ");
INSERT INTO rol_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Gingsabat sinda ni Hesus paagi sa isa ka pangutana, “Ano ba ang gingsugò sa indo ni Moises?” ");
INSERT INTO rol_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Nagsabat sinda, “Nagsugot si Moises nga makahuman ang lyaki ning papeles ng pagbinuyagan, pagkatapos puydi na niya mabuyagan ang iya asawa.” ");
INSERT INTO rol_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Naghambay si Hesus sa inda, “Kay matugas ang indo uyo, nganì gingsulat ni Moises sa indo ini nga sugò. ");
INSERT INTO rol_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero tunà ng pagtuga ng kalibutan, ‘ginghuman sinda ng Dios nga lyaki kag babayi.’ ");
INSERT INTO rol_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Imaw ini ang rason nga ‘bayaan ng lyaki ang iya tatay kag nanay kag magaiba sa iya asawa, ");
INSERT INTO rol_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","kag sinda nga duha maging isa ka lawas. Bukon na sinda duha kundì isa.’ ");
INSERT INTO rol_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nganì indì dapat buyagon ng tawo ang ging-isa na ng Dios.” ");
INSERT INTO rol_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Pag-abot ninda sa bayay, nagpangutana naman ang mga disipulo parti didto nga butang. ");
INSERT INTO rol_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Naghambay si Hesus sa inda, “Ang aber sin-o nga lyaki nga magbuyag sa iya asawa kag mag-asawa ning iban hay nagapangawatan kag nakasalà sa iya una nga asawa. ");
INSERT INTO rol_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Kag kung magbuyag ang babayi sa iya asawa kag mag-asawa ning iban, nagapangawatan da siya.” ");
INSERT INTO rol_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","May mga tawo nga nagdaya ng mga ungà kay Hesus para itungtong ang iya kamot kag bendisyunan sinda. Pero gingsabyaw ng iya mga disipulo ang mga nagdaya sa inda. ");
INSERT INTO rol_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Pagkakità ni Hesus sa natabò, nahangit siya kag naghambay sa iya mga disipulo, “Pabay-i lang nindo ang mga ungà nga magpalapit sa akon. Ayaw nindo sinda pagpunggi kay ang mga kapareho ninda hay imaw ang nagapasakop sa paghaharì ng Dios. ");
INSERT INTO rol_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Sa matuod lang ginahambay ko sa indo, ang aber sin-o nga indì magpasakop sa paghaharì ng Dios pareho ng isa ka ungà, indì gid makasuyod sa gingharian ng Dios.” ");
INSERT INTO rol_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Pagkatapos gingkugos niya ang mga ungà, gingtungtong niya ang iya kamot sa inda kag gingbendisyunan sinda. ");
INSERT INTO rol_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Nang papanawon na si Hesus, may isa ka tawo nga nagdyagan palapit sa iya kag nagluhod. Pagkatapos nagpangutana ang tawo, “Maayo nga Maestro, ano baya ang dapat ko humanon agud makapanublì ning kabuhì nga wayà katapusan?” ");
INSERT INTO rol_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Nagsabat si Hesus sa iya, “Basì gingtawag mo ako nga maayo? Wayà gid ning aber sin-o nga maayo kundì ang Dios lang. ");
INSERT INTO rol_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Parti sa imo pangutana, nasayuran mo na ang mga sugò ng Dios: Ayaw magpamatay, ayaw magpangawatan, ayaw magpangawat, ayaw magtestigo ning pinusong, ayaw magpangluko, tahura ang imo tatay kag nanay.” ");
INSERT INTO rol_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nagsabat siya kay Hesus, “Maestro, ini tanan hay natuman ko na magtunà nang ungà pa ako.” ");
INSERT INTO rol_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Gingsirò siya ni Hesus nga may pagpalanggà kag naghambay, “Isa pa ka butang ang kuyang sa imo. Magbalik ka kag ibaligyà ang imo mga propidad kag ipanao ang kwarta sa mga pobre. Sa ini nga paagi, magakaigwa ka ning manggad sa langit. Pagkatapos magbalik ka kag magsunod sa akon.” ");
INSERT INTO rol_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Naglain gid ang iya hitsura nang mabatian niya adto kag naghalin siya nga malisod kay madamò ang iya manggad. ");
INSERT INTO rol_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Nang makahalin na ang tawo, nagsirò si Hesus sa palibot kag naghambay sa iya mga disipulo, “Mahugà gid para sa mga manggaranon ang makasuyod sa gingharian ng Dios!” ");
INSERT INTO rol_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Natingaya ang mga disipulo sa iya ginghambay. Nganì nagpadayon siya sa paghambay, “Mga ungà, mahugà gid ang makasuyod sa gingharian ng Dios! ");
INSERT INTO rol_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mas malupos pa mag-agi ang kamelyo sa buhò ng dayom kaysa sa magsuyod ang manggaranon sa gingharian ng Dios.” ");
INSERT INTO rol_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Natingaya gid sinda kag nagpangutana sa iya, “Kung tiyad inà, sin-o lang ang maluwas?” ");
INSERT INTO rol_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Gingsirò sinda ni Hesus kag naghambay, “Kung sa mga tawo lang imposible gid ini, pero puydi sa Dios; kay ang tanan nga butang hay posible sa Dios.” ");
INSERT INTO rol_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Naghambay si Pedro sa iya, “Hay kami, gingbayaan namon ang tanan kag nagnunot sa imo.” ");
INSERT INTO rol_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Naghambay si Hesus sa inda, “Sa matuod lang ginahambay ko sa indo, wayà ning tawo nga nagbayà ng iya bayay, mga maguyáng kag mga manghod, nanay, tatay, mga ungà, o mga uma tungod sa akon kag sa Maayong Balità, ");
INSERT INTO rol_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nga indì makabaton ning ginatos ka doble nga bayos sa ini nga kabuhì: mga bayay, mga maguyáng kag mga manghod, mga nanay, mga ungà, mga uma kag patì sa mga paghingabot tungod sa pagtuo. Kag sa paabuton nga tyempo, makakabaton siya ning kabuhì nga wayà katapusan. ");
INSERT INTO rol_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pero madamò nga tawo ang nauuna nga mauulihi kag ang mga nauulihi nga mauuna.” ");
INSERT INTO rol_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Mintras nagapanaw sina Hesus patukad sa Jerusalem, nauna siya sa inda. Natingaya ang iya mga disipulo kag ginahadlukan naman ang iban nga nagasunod sa iya. Gingbuyag niya liwat ang dose nga disipulo sa mga tawo kag gingbalità niya kung ano ang matatabò sa iya. ");
INSERT INTO rol_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Naghambay siya sa inda, “Pamatì kamo! Nagapatukad kita sa Jerusalem kag didto itugyan ako nga Ungà ng Tawo* sa mga pinunò nga parì kag mga eskriba* kag parusahan ninda ako nga patyon. Kag itugyan ninda ako sa mga bukon Judio*. ");
INSERT INTO rol_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Insultuhon ninda ako, pilaan, latiguhon kag patyon. Pero pagkaligad ng tuyo ka adlaw mababanhaw ako.” ");
INSERT INTO rol_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Nagpalapit kay Hesus sina Santiago kag Juan, mga ungà ni Zebedee kag naghambay, “Maestro, may pangayuon kuntà kami sa imo.” ");
INSERT INTO rol_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Naghambay si Hesus sa inda, “Ano ang indo pangayuon sa akon?” ");
INSERT INTO rol_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Nagsabat sinda, “Pag magharì ka na sa imo mahimayaon nga gingharian, papungkua kami nga duha sa imo alihid; ang isa sa tuo kag ang isa sa waya.” ");
INSERT INTO rol_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Pero naghambay si Hesus sa inda, “Wayà nindo nasayuri kung ano ang indo ginapangayò. Maagwanta ba nindo ang mga kahugaan nga akon agwantahon? Kag matitiis da ba nindo ang kamatayon nga akon agihan?” ");
INSERT INTO rol_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Nagsabat sinda, “Huo, kaya namon.” Naghambay si Hesus sa inda, “Maagwanta nindo ang mga kahugaan nga akon agwantahon kag matitiis da ang kamatayon nga akon agihan. ");
INSERT INTO rol_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pero bukon ako ang magapilì kung sin-o ang papungkuon sa akon tuo o waya kay may mga gingtagan-an na para magpungkò didto.” ");
INSERT INTO rol_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Pagkabatì ng napuyò ka disipulo kung ano ang inda gingpangayò, nahangit gid sinda kana Santiago kag Juan. ");
INSERT INTO rol_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Nganì gingtawag sinda tanan ni Hesus kag ginghambayan, “Sayod nindo nga ang mga miyugdumaya sa ini nga kalibutan hay may otoridad sa inda mga sinakupan kag pagusto lang sinda kung ano ang humanon sa inda. ");
INSERT INTO rol_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pero bukon tiyad inà sa indo. Kay kung sin-o sa indo ang gusto nga maging labaw sa tanan, dapat maging suluguon nindo. ");
INSERT INTO rol_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Kag kung sin-o sa indo ang gusto maging pinunò, dapat maging ulipon ng tanan. ");
INSERT INTO rol_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kay aber pa nganì ako nga Ungà ng Tawo hay wayà nagkari diri sa kalibutan para magpaserbisyo kundì magserbisyo; kag magtao ng akon kabuhì agud matubos ang madamò nga tawo.” ");
INSERT INTO rol_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nag-abot sina Hesus sa Jerico. Nang nagapaluwas na siya sa banwa kaibahan ng iya mga disipulo kag ng madamò nga tawo, may isa ka buta didto nga si Bartimeus, ungà ni Timeus nga nagapungkò kag nagapalimos sa alihid ng karsada. ");
INSERT INTO rol_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Pagkabatì niya nga nagaagi si Hesus nga taga-Nazaret, nagsinggit siya, “Hesus, inapo ni David, kaluy-i ako!” ");
INSERT INTO rol_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Gingsabyaw siya ng madamò nga tawo nga maghipos. Pero gingkusugan pa gid nganì niya ang pagsininggit, “Inapo ni David, kaluy-i ako!” ");
INSERT INTO rol_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nagduyog si Hesus kag naghambay, “Day-a nindo siya diri sa akon.” Nganì gingtawag ninda ang buta kag naghambay sinda, “Magkalipay ka. Tindog na kay ginapatawag ka ni Hesus.” ");
INSERT INTO rol_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Gingpilak niya ang iya pangsuy-ob, naglukso kag nagkadto kay Hesus. ");
INSERT INTO rol_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Gingpangutana siya ni Hesus, “Ano ang gusto mo nga humanon ko para sa imo?” Nagsabat ang buta, “Maestro, gusto ko nga makakità liwat.” ");
INSERT INTO rol_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Pagkatapos naghambay si Hesus sa iya, “Panaw na. Ang imo pagtuo ang nag-ayo sa imo.” Adto nga daan nakakità na siya kag nagnunot kay Hesus sa karsada. ");
INSERT INTO rol_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Nang malapit na sina Hesus sa Jerusalem kag nag-abot sa mga baryo ng Betfage kag Betania sa Bukid ng mga Olibo*, gingpauna ni Hesus ang iya duha nga disipulo ");
INSERT INTO rol_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","kag gingbilinan sinda, “Mag-una kamo didto sa masunod nga baryo. Pagsuyod nga daan nindo, makikità nindo ang batà nga asno nga nakahigot. Wayà pa gid ini masasakyi. Hubara nindo ang higot kag day-a diri. ");
INSERT INTO rol_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kung may magpangutana sa indo, ‘Basì ginahuman nindo inà?’ sabata nindo, ‘Kahinangyan ini ng Ginoo, pagkatapos iulì da nga daan sa imo.’ ” ");
INSERT INTO rol_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Nganì nagpanaw sinda kag pag-abot ninda didto sa baryo, nakità ninda ang batà nga asno sa alihid ng dayan nga nakahigot sa pwertahan ng isa ka bayay. Mintras ginahubad ninda ang higot, ");
INSERT INTO rol_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","may mga nagatindog didto nga nagpangutana sa inda, “Hoy, ano ang indo ginahuman dirà? Basì ginahubad nindo ang higot ng asno?” ");
INSERT INTO rol_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Nagsabat sinda sa mga tawo sunò sa gingbilin ni Hesus. Nganì gingpabay-an na lang sinda ng mga tawo. ");
INSERT INTO rol_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Pagkatapos adto gingdaya ninda ang asno kay Hesus. Pag-abot didto, ginghapinan ninda ini ng inda pangsuy-ob kag nagsakay si Hesus. ");
INSERT INTO rol_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Madamò nga tawo ang naglatag ng inda pangsuy-ob sa karsada kag ang iban naman nagbutang ning mga madahon nga sanga nga inda ging-utod halin sa mga uma. ");
INSERT INTO rol_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ang mga nagauna kay Hesus kag ang mga nagasunod hay nagasinggit, “Hosana! Ginapakamaayo ng Ginoo ang iya gingsugò! ");
INSERT INTO rol_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ginapakamaayo ng Dios ang paabuton nga gingharian ni David nga aton kalulo-lulohan. Hosana! Dayawon ang Dios sa pinakamataas gid sa tanan!” ");
INSERT INTO rol_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Pag-abot ni Hesus sa Jerusalem, nagsuyod siya sa templo. Nagpanglikità siya sa tanan nga butang didto sa suyod. Pagkatapos, tungod madalì na lang magtunod ang adlaw, nagluwas siya kag nagkadto sa Betania kaibahan ang dose nga disipulo. ");
INSERT INTO rol_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pagkaaga, paghalin nina Hesus sa Betania pabalik sa Jerusalem, nagutom siya. ");
INSERT INTO rol_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","May nakità siya sa malayò nga kahoy nga igos* nga malabog ang dahon. Nganì gingpalapitan niya kung may bunga. Pero wayà siya ning may makità nga bunga kundì puro lang dahon, kay bukon pa tyempo ng tigbubunga. ");
INSERT INTO rol_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Naghambay si Hesus sa kahoy, “Tunà niyan, wayà na ning tawo nga makakaon ng imo bunga!” Nabatian ng iya mga disipulo ang iya ginghambay. ");
INSERT INTO rol_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Pag-abot nina Hesus sa Jerusalem, nagsuyod siya sa templo. Gingpalayas niya didto ang mga nagapamaligyà kag nagapamakay sa suyod ng templo. Gingpinamaliskad niya ang mga lamisa ng mga miyugbaylo ning kwarta* kag ang mga pungkuan ng mga miyugbaligyà ng mga salampati nga inughalad. ");
INSERT INTO rol_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Kag wayà niya pagtuguti nga mag-agi sinda sa suyod ng templo nga may daya nga mga inugbaligyà. ");
INSERT INTO rol_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kag gingtudluan niya sinda. Hambay niya, “Dì ba ginahambay ng Kasulatan, ‘Tawagon ang akon bayay nga pangamuyuan para sa tanan nga nasyon?’ Pero kamo! Ginghuman nindo nga panaguan ng mga tulisan!” ");
INSERT INTO rol_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Nabatian ng mga pinunò nga parì kag mga eskriba adtong ginghuman ni Hesus. Nganì nagpangità sinda ning paagi agud patyon siya. Pero hinadlukan sinda sa iya kay natingaya gid ang mga tawo sa iya mga ginatudlò. ");
INSERT INTO rol_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nang manayumsom na, nagluwas si Hesus kag ang iya mga disipulo sa syudad. ");
INSERT INTO rol_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Pagkaaga, nang pabalik na sinda pa-Jerusalem, didto da sinda nag-agi sa karsada nga inda ging-agihan dati kag nakità ninda ang kahoy nga igos nga nalayà kag patay na. ");
INSERT INTO rol_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nadumduman ni Pedro ang natabò, nganì naghambay siya kay Hesus, “Maestro, sirua ang kahoy nga igos nga imo gingsumpà! Layà na!” ");
INSERT INTO rol_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Nagsabat si Hesus sa inda, “Magtuo kamo sa Dios! ");
INSERT INTO rol_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Sa matuod lang ginahambay ko sa indo, ang aber sin-o nga maghambay sa ini nga bukid, ‘Maghalin ka diri kag maglukso sa dagat’ kag kung wayà siya nagapangduha-duha kundì nagatuo nga ini matabò, inà hay matatabò para sa iya. ");
INSERT INTO rol_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nganì ginahambay ko sa indo, aber ano ang indo pangayuon sa pangamuyò, magtuo kamo nga nabaton na ini nindo kag mababaton gid nindo. ");
INSERT INTO rol_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Kag kung nagapangamuyò kamo, patawara anay nindo ang mga nakasalà sa indo, agud patawaron da ang indo mga salà ng indo Amay sa langit.” ");
INSERT INTO rol_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kay kung wayà kamo nagapatawad sa iban, indì da kamo patawaron ng indo Amay sa langit. ");
INSERT INTO rol_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nagkadto liwat sina Hesus sa Jerusalem. Mintras nagapanaw siya sa templo, nagpalapit sa iya ang mga pinunò nga parì, mga eskriba kag mga miyugdumaya ng Judio. ");
INSERT INTO rol_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Nagpangutana sinda kay Hesus, “Ano ba ang imo otoridad para humanon ini nga mga butang? Kag sin-o ang nagtao sa imo ng ini nga otoridad para humanon ang mga ini?” ");
INSERT INTO rol_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Nagsabat si Hesus sa inda, “May ipangutana ako sa indo. Sabata anay nindo ako, pagkatapos sabaton ko da kamo kung ano ang akon otoridad para humanon ini nga mga butang. ");
INSERT INTO rol_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Kay sin-o ba naghalin ang otoridad ni Juan para magbawtismo, sa Dios ba o sa tawo? Sabata nindo ako.” ");
INSERT INTO rol_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Kag nagdiniskusyon sinda kung ano ang inda isabat, “Kung magsabat kita, ‘Halin sa Dios’, mangutana naman siya, ‘Basì wayà kamo nagpati kay Juan?’ ");
INSERT INTO rol_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Pero kung maghambay kita, ‘Halin sa tawo’, mahahangit sa aton ang mga tawo.” (Nahadlok sinda sa mga tawo kay madamò ang nagapati nga si Juan hay matuod nga propeta*.) ");
INSERT INTO rol_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nganì nagsabat sinda kay Hesus, “Wayà kami makasayod.” Naghambay naman si Hesus, “Indì ko da kamo pagbalitaan kung sin-o ang nagtao sa akon ning otoridad paghuman ng ini nga mga butang.” ");
INSERT INTO rol_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Pagkatapos naghambay si Hesus sa inda paagi sa mga parabola*, “May isa ka tawo nga nagpatanom ning ubas* sa iya dutà. Gingpakurayan niya ini palibot kag nagpahuman siya ning buhò sa mabahoy nga bato para pugaan ning ubas*. Nagpaugdok da siya ning isa ka lantawan. Pagkatapos gingpaarkila niya ang ubasan sa mga bantay kag nagkadto siya sa malayò nga lugar. ");
INSERT INTO rol_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Nang mag-abot ang tyempo ng tigpamupò ning ubas, gingsugò niya ang iya ulipon sa mga bantay para magbuoy ng iya parte ng ubas. ");
INSERT INTO rol_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pero pag-abot niya didto, gingdakop ninda siya kag gingbunay kag gingpabalik nga wayà gid ning daya. ");
INSERT INTO rol_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Gingsugò naman ng tag-iya ang isa pa ka ulipon, pero ginglampusan ninda siya sa uyo kag gingpakahuy-an. ");
INSERT INTO rol_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nagsugò pa gid siya ning isa pa ka ulipon kag inda ini gingpatay. Madamò pa gid ang gingsugò ng tag-iya. Ang iban gingbunay ninda kag ang iban gingpatay. ");
INSERT INTO rol_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Sa katapusan, wayà na siya ning ulipon nga masugò. Nganì gingsugò niya ang iya pinalanggà nga ungà nga lyaki kay nagahunahunà siya, ‘Tahuron ninda ang akon ungà.’ ");
INSERT INTO rol_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pero pagkakità ng mga bantay sa iya ungà, naghambay sinda sa isa kag isa, ‘Yari na ang miyugpanublì. Kari, patyon ta para maging aton na ang iya panublion.’ ");
INSERT INTO rol_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Nganì gingdakop ninda siya kag gingpatay. Gingpilak ninda ang iya lawas sa luwas ng ubasan.” ");
INSERT INTO rol_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Nagpangutana si Hesus, “Ano baya ang humanon ng tag-iya ng ubasan? Sigurado gid nga kadtuon niya ang mga bantay kag pamatyon. Pagkatapos pabantayan niya ang iya ubasan sa iban.” ");
INSERT INTO rol_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Naghambay pa si Hesus, “Wayà ba nindo ini nabasa sa Kasulatan? ‘Ang bato nga gingpilak ng mga panday, imaw gid ang naging pinakaimportante nga bato sa pundasyon; ");
INSERT INTO rol_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ini hay ginghuman ng Ginoo, kag makatitingaya ini sa aton!’ ” ");
INSERT INTO rol_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Nasayuran ng mga miyugdumaya ng Judio nga sinda ang ginapatamaan ng parabola. Nganì gusto ninda nga dakpon si Hesus pero nahadlok sinda sa mga tawo. Nganì gingpabay-an na lang ninda siya kag nagpanaw sinda. ");
INSERT INTO rol_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Niyan, gingsugò ninda ang pila ka mga Pariseo* kag pila ka mga miyembro ng grupo ni Herodes agud maakusar ninda si Hesus paagi sa iya paghambay. ");
INSERT INTO rol_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Nganì nagkadto sinda kay Hesus kag nagpangutana, “Maestro, nasayuran namon nga matuod ang imo ginahambay. Wayà ka nagapadaya-daya sa mga tawo aber sin-o pa sinda kay wayà ka ning may ginapalabi. Kundì kung ano ang kamatuuran parti sa kabubut-on ng Dios sa mga tawo imaw gid ang imo ginatudlò. Mangutana lang kami sa imo, ginatugutan ba ng Kasuguan nga kita nga mga Judio hay magbayad ning buhis sa Emperador ng Roma? Dapat ba kita magbayad o indì?” ");
INSERT INTO rol_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Pero sayod ni Hesus ang inda hunahunà, nganì naghambay siya sa inda, “Basì baya ginatistingan nindo ako? Day-a sa akon ang kwarta kay siruon ko.” ");
INSERT INTO rol_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Kag gingday-an siya ning isa ka bilog. Pagkatapos nagpangutana siya sa inda, “Kanin-o hitsura kag pangayan ang makikità diri?” Nagsabat sinda, “Sa Emperador.” ");
INSERT INTO rol_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Naghambay si Hesus sa inda, “Kung tiyad inà, itao nindo sa Emperador ang sa Emperador kag sa Dios ang sa Dios.” Kag natingaya gid sinda sa iya. ");
INSERT INTO rol_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Pagkatapos may mga Saduceo* nga nagpalapit kay Hesus. Ini nga mga tawo hay wayà nagapati nga may pagkabanhaw. ");
INSERT INTO rol_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Nagpangutana sinda, “Maestro, nagsulat si Moises sa aton nga kung mamatay ang lyaki kag buhì ang iya asawa nga wayà makaungà, dapat ang iya manghod nga lyaki ang mag-asawa sa bayo agud makaungà siya para sa iya maguyáng nga namatay. ");
INSERT INTO rol_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Niyan, igwa ning pito ka magmanghod nga lyaki. Nag-asawa ang kamaguyangan kag namatay nga wayà ning ungà. ");
INSERT INTO rol_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Nganì ging-asawa ang bayo ng pangaduha nga manghod kag namatay da siya nga wayà gihapon makaungà. Imaw da ang natabò sa ikatuyo, ");
INSERT INTO rol_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","hasta sa ikapito. Namatay sinda tanan nga wayà gid makaungà. Nang ulihi ang babayi namatay da. ");
INSERT INTO rol_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Niyan, kung mag-abot ang tyempo ng pagkabanhaw, kay sin-o gid siya asawa? Kay sinda nga pito hay naasawa niya.” ");
INSERT INTO rol_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Nagsabat si Hesus sa inda, “Salà gid kamo kay wayà kamo nakaintindi ng ginahambay ng Kasulatan kag ng gahom ng Dios. ");
INSERT INTO rol_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kay pag banhawon ang mga patay, indì na sinda mag-asawa kag indì na paasawahon kay pareho na sinda ng mga anghel sa kalangitan. ");
INSERT INTO rol_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kung parti sa pagkabanhaw, wayà ba nindo nabasa ang gingsulat ni Moises parti sa nagadayab nga kahoy nga mababà? Hambay ng Dios sa iya, ‘Ako ang Dios ni Abraham, ang Dios ni Isaac kag ang Dios ni Jacob.’ ");
INSERT INTO rol_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ang Dios hay bukon Dios ng mga patay, kundì Dios ng mga buhì. Nganì salà gid kamo.” ");
INSERT INTO rol_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","May isa ka eskriba didto nga nagpalapit kag nakabatì ng inda diskusyon. Nabatian niya nga maayo ang sabat ni Hesus. Nganì nagpangutana siya, “Ano gid baya ang pinakaimportante nga sugò ng Dios?” ");
INSERT INTO rol_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Nagsabat si Hesus, “Ang pinakaimportante nga sugò hay imaw ini: ‘Pamatì kamo, mga Israelita! Ang Ginoo nga aton Dios imaw lang ang Ginoo. ");
INSERT INTO rol_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nganì higugmaon mo ang Ginoo nga imo Dios sa bilog mo nga tagipusuon, sa bilog mo nga kabubut-on, sa tanan mo nga hunahunà kag sa tanan mo nga kusog.’ ");
INSERT INTO rol_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ang ikaduha hay imaw ini, ‘Higugmaon mo ang imo isigkatawo pareho ng paghigugmà mo sa imo kaugalingon.’ Wayà na ning sugò nga mas importante pa diri sa duha.” ");
INSERT INTO rol_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Naghambay ang eskriba sa iya, “Tamà ka, Maestro! Matuod ang imo ginghambay nga may isa lang nga Dios kag wayà na ning iban pa. ");
INSERT INTO rol_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kag higugmaon mo siya sa bilog nga tagipusuon, sa tanan nga pang-intindi kag sa tanan nga kusog; kag higugmaon mo ang imo isigkatawo pareho ng paghigugmà mo sa imo kaugalingon. Ining duha hay mas importante sa tanan nga halad* nga ginasunog kag sa iban pa nga mga sakripisyo.” ");
INSERT INTO rol_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Pagkabatì ni Hesus nga tamà ang iya sabat, naghambay siya sa iya, “Malapit ka na sa paghaharì ng Dios.” Pagkatapos adto, wayà na gid ning may nangahas nga magpangutana kay Hesus. ");
INSERT INTO rol_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Mintras nagatudlò si Hesus sa templo, nagpangutana siya, “Basì nagahambay ang mga eskriba nga ang Kristo hay inapo lang ni David? ");
INSERT INTO rol_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Si David mismo nga ginatuytuyan ng Espiritu Santo hay naghambay, ‘Naghambay ang Ginoo* sa akon Ginoo, Pungkò diri hampig sa akon tuo hasta nga maperdi ko kag pakahuy-an ang imo mga kaaway para sa imo.’ ");
INSERT INTO rol_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Kung gingtawag siya ni David nga iya Ginoo, pauno baya nga siya hay inapo lang ni David*?” Naluyag magpamatì kay Hesus ang madamò gid nga tawo. ");
INSERT INTO rol_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Sa iya mga pagpanudlò naghambay siya, “Mag-andam kamo sa mga eskriba nga gusto magpinanaw nga nagabarò ning mahabà para magpakità nga importante gid sinda. Gusto gid ninda nga abi-abihon kag tahuron sa lugar nga madamò ang tawo. ");
INSERT INTO rol_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Kag sa mga sinagoga* o sa mga punsyunan, ginapilì gid ninda ang mga pungkuan nga para sa mga kilaya. ");
INSERT INTO rol_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ginaubos ninda buoy ang mga pagkabutang ng mga babayi nga bayo patì inda bayay kag ginatabon-tabunan lang ninda ang inda malain nga ginahuman paagi sa mahabà nga mga pangamuyò. Sinda hay magabaton gid ning mas sobra nga parusa halin sa Dios!” ");
INSERT INTO rol_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Nagpungkò si Hesus sa atubangan ng ginabutangan ning kwarta didto sa templo kag ging-obserbahan niya ang mga tawo nga nagabutang ng inda mga kwarta. Madamò nga manggaranon ang nagabutang ning dakò nga mga kantidad. ");
INSERT INTO rol_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","May nagpalapit nga pobre nga babayi nga bayo kag nagbutang ning duha ka bilog nga leptos*. ");
INSERT INTO rol_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Gingtawag ni Hesus ang iya mga disipulo kag naghambay sa inda, “Sa matuod lang ginahambay ko sa indo, mas madakò ang gingbutang ng ini nga pobre nga bayo kaysa sa tanan nga nagtao. ");
INSERT INTO rol_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kay sinda madamò ang kwarta kag ang inda gingtao hay ang bukon na ninda kahinangyan. Pero ang bayo, aber pobre siya, gingtao niya ang tanan nga iya ginasaligan nga pangabuhian.” ");
INSERT INTO rol_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Mintras nagapaluwas si Hesus sa templo, ang isa sa iya mga disipulo naghambay, “Maestro, tan-awa! Kaayo-ayo ang templo kag kadagkò-dagkò ang mga bato.” ");
INSERT INTO rol_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Naghambay si Hesus sa iya, “Nakikità mo ba inà nga kabahoy-bahoy nga templo? Maabot ang tyempo nga inà nga mga bato hay pagatumpagon kag wayà gid ning may mabilin nga nagapamagtumbaw.” ");
INSERT INTO rol_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Mintras nagapungkò si Hesus sa Bukid ng mga Olibo paatubang sa templo, nagpalapit sina Pedro, Santiago, Juan kag Andres kag nagpangutana sa iya nang sinda na lang. ");
INSERT INTO rol_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Hambay ninda, “Balitai kami kung san-o matabò ang mga butang nga imo ginghambay. Kag ano baya ang tandà nga malapit na ini tanan matatabò?” ");
INSERT INTO rol_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Nagsabat si Hesus sa inda, “Mag-andam kamo nga wayà ning may makapatayang sa indo. ");
INSERT INTO rol_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kay kadamò ang magaabot kag magahambay sinda, ‘Ako imaw ang Kristo’ kag kadamò ang inda mapatayang. ");
INSERT INTO rol_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kag pag makabatì kamo nga may mga gira malapit sa indo kag makasayod kamo nga sa iban nga nasyon nagagira da, ayaw kamo mahadlok. Dapat gid ini tanan matabò, pero bukon pa ini ang katapusan. ");
INSERT INTO rol_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Magainaway ang mga nasyon kag imaw da ang mga gingharian. May magaabot nga mga linog sa iba-iba nga lugar kag may matabò nga mga taggutom. Ini nga mga butang hay daw pareho ng una nga kasakit nga nababatyagan ng babayi nga tig-uungà na gid. ");
INSERT INTO rol_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Mag-andam kamo, kay dakpon ninda kamo kag itugyan sa Korte ng mga Judio* kag latiguhon sa mga sinagoga. Magaatubang kamo sa mga gobernador kag sa mga harì tungod sa indo pagtuman sa akon kag didto magapamatuod kamo parti sa akon. ");
INSERT INTO rol_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Dapat iwali ang Maayong Balità sa tanan nga nasyon, bago mag-abot ang katapusan. ");
INSERT INTO rol_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kung day-on kamo kag itugyan sa korte, ayaw kamo magkabayaka kung ano ang indo ihambay. Kay sa adto gid nga oras, ihambay lang nindo kung ano ang ginapahambay sa indo ng Espiritu Santo. Kay bukon kamo ang magahambay kundì ang Espiritu Santo paagi sa indo. ");
INSERT INTO rol_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Sa adto nga tyempo, may mga tawo nga ipapatay ang inda mga maguyáng kag manghod. May mga tatay nga ipapatay ang inda ungà. Kag may mga ungà nga magabatò sa inda mga ginikanan kag ipapatay ninda. ");
INSERT INTO rol_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Mahahangit gid sa indo ang tanan nga tawo tungod sa indo pagtuman sa akon. Pero ang nagapadayon nga magtuman sa akon hasta sa katapusan imaw ang maluluwas.” ");
INSERT INTO rol_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Pag makità nindo nga ginapatindog na sa lugar nga indì dapat tindugan ang kalain-lain gid nga butang (kamo nga nagabasa intindihon gid nindo kung ano ang gusto hambayon ini), ang mga yarà sa Judea dapat magbakwit na pakadto sa kabukiran. ");
INSERT INTO rol_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ang matabuan nga yarà sa luwas ng iya bayay indì na dapat magsuyod para magbuoy ning aber ano. ");
INSERT INTO rol_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ang matabuan nga yadto sa uma hay indì na dapat magbalik para magbuoy ng iya pangsuy-ob. ");
INSERT INTO rol_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Sa adto nga tyempo, makaluluoy ang mga nabdos kag ang mga nagapasuso kay mahugaan gid sinda magbakwit. ");
INSERT INTO rol_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Magpangamuyò kamo nga indì ini matabò sa tiglalamig. ");
INSERT INTO rol_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kay sa adto nga tyempo, magaabot ang kahugaan nga wayà pa gid natabò magtunà nang gingtuga ng Dios ang kalibutan hasta niyan kag indì na matatabò pa hasta san-o. ");
INSERT INTO rol_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kag kung indì patag-uron ng Ginoo ang mga adlaw, wayà gid ning may maluwas. Pero tungod sa kaluoy niya sa iya mga gingpilì, patag-uron niya adto nga tyempo. ");
INSERT INTO rol_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Kung may maghambay sa indo, ‘Yari ang Kristo!’ o ‘Yadto siya didto!’, ayaw kamo magpati. ");
INSERT INTO rol_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kay may magaabot nga mga bukon matuod nga kristo kag mga bukon matuod nga mga propeta. Magahuman sinda ning mga milagro kag makatitingaya nga butang para patayangon, kung puydi, aber pa ang mga gingpilì ng Dios. ");
INSERT INTO rol_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nganì magbantay kamo! Ginahambay ko na nga daan ini nga mga butang sa indo bago pa matabò.” ");
INSERT INTO rol_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Pagkatapos ng mga kahugaan sa adto nga tyempo, magaduyom ang adlaw, indì na maghayag ang bulan, ");
INSERT INTO rol_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","kag magakahuyog ang mga bituon. Ang mga butang sa kalangitan hay magatayang sa inda dati nga mga pwesto. ");
INSERT INTO rol_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Pagkatapos makikità ng mga tawo ako nga Ungà ng Tawo sa mga panganod nga nagabalik sa kalibutan nga may madakò nga gahom kag may kasilaw. ");
INSERT INTO rol_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Suguon ko ang akon mga anghel, para tipunon ang akon mga gingpilì halin sa tanan nga lugar ng kalibutan.” ");
INSERT INTO rol_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Magtuon kamo ng leksyon parti sa kahoy nga igos*. Kung nagapanaybos ang iya mga sanga, sayod na nindo nga malapit na ang tag-init. ");
INSERT INTO rol_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Imaw da, kung makità nindo nga nagakatabò na ini nga mga butang nga akon ginahambay, masasayuran nindo nga madalì na lang ako mag-abot. ");
INSERT INTO rol_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Sa matuod lang ginahambay ko sa indo, magakatabò ini tanan nga butang, bago mamatay ang mga tawo sa ini nga henerasyon. ");
INSERT INTO rol_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Maduduyà ang langit kag ang dutà, pero ang akon mga hambay hay indì maduyà kundì matutuman gid ini.” ");
INSERT INTO rol_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Kung parti sa adlaw kag oras ng akon pag-abot, wayà gid ning may nakasayod aber ang mga anghel sa langit o ako nga Ungà ng Dios, kundì ang Amay lang gid. ");
INSERT INTO rol_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Nganì mag-andam kamo kag mag-alisto, kay wayà kamo makasayod kung san-o maabot adto nga oras. ");
INSERT INTO rol_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Pareho da ini sa isa ka tawo nga mabyahe sa iban nga lugar. Bago siya naghalin sa iya bayay, gingtaw-an niya ang iya mga ulipon ning otoridad kag kada isa sa inda hay may trabaho. Kag gingsugò niya ang bantay sa pwertahan nga magbantay. ");
INSERT INTO rol_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Nganì magbantay kamo kay wayà kamo makasayod kung san-o magaabot ang tag-iya ng bayay; puydi sa manayumsom, sa hanagob, sa aga-aga, o sa pagsubat ng adlaw. ");
INSERT INTO rol_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Basì kung gulpi lang ang iya pag-abot kag maabutan niya kamo nga nagakatuyog. ");
INSERT INTO rol_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ang ginahambay ko sa indo hay ginahambay ko da sa tanan. Magbantay kamo!” ");
INSERT INTO rol_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Duha na lang ka adlaw bago mag-abot ang Pyesta ng Pagligad ng Anghel* kag Pyesta ng Tinapay nga wayà ning Pampaalsa*. Ang mga pinunò nga parì kag ang mga eskriba* hay nagapangità ning paagi kung pauno ninda dakpon si Hesus nga indì masayuran ng mga tawo kag pagkatapos hay patyon. ");
INSERT INTO rol_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Naghambay sinda, “Indì lang naton itamà sa pyesta kay basì kung magkagulo ang mga tawo.” ");
INSERT INTO rol_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Nang yadto sina Hesus sa banwa ng Betania, mintras nagakaon siya sa bayay ni Simon nga kitungon* dati, may isa ka babayi nga nag-abot. May daya siya nga maisot nga tibod himò sa alabastro, nga may suyod nga kamahay gid kag maayo nga klasi nga pahumot. Ini nga pahumot hay halin sa tanom nga ginatawag, Nardo. Pagpalapit niya kay Hesus, ging-utod niya ang liog ng tibod kag gingbubuan niya ning pahumot ang uyo ni Hesus. ");
INSERT INTO rol_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","May mga tawo didto nga nahangit kag naghambay sa isa kag isa, “Taya! Basì baya ginauyakan lang niya ang pahumot? ");
INSERT INTO rol_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Puydi kuntà inà maibaligyà sa kantidad nga tuyo ka gatos nga denarius* kag itao ang kwarta sa mga pobre.” Kag gingnguyaban ninda ang babayi. ");
INSERT INTO rol_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Pero naghambay si Hesus sa inda, “Basì ginagulo nindo siya? Pabay-i lang siya. Maayo gid ang iya ginghuman sa akon! ");
INSERT INTO rol_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Permi nindo kaibahan ang mga pobre kag puydi kamo makabulig sa inda aber ano nga oras nga gusto nindo, pero ako hay bukon nindo permi kaibahan. ");
INSERT INTO rol_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ini nga babayi naghuman ng iya makakaya para sa akon. Gingbubuan niya ning pahumot ang akon lawas para ipreparar ang akon lubong. ");
INSERT INTO rol_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Sa matuod lang ginahambay ko sa indo, aber diin iwali ang Maayong Balità sa bilog nga kalibutan, ang iya ginghuman sa akon hay ipamalità da para madumduman siya.” ");
INSERT INTO rol_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Pagkatapos si Judas Iscariote, isa sa dose nga disipulo, hay nagkadto sa mga pinunò nga parì agud inda istoryahan kung pauno niya itugyan si Hesus sa inda. ");
INSERT INTO rol_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Pagkabatì ini ninda, nalipay gid sinda kag nagpangakò nga taw-an siya ning kwarta. Nganì tunà adto, nagapangità siya ning paagi kung pauno niya itugyan si Hesus sa inda. ");
INSERT INTO rol_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Nag-abot ang una nga adlaw ng Pyesta ng Tinapay nga wayà ning Pampaalsa. Imaw ini ang adlaw nga ginapatay ang kordero agud ihalad sa Dios, para magsilibrar sa Pyesta ng Pagligad ng Anghel. Nganì nagpangutana ang mga disipulo ni Hesus sa iya, “Sa diin mo gusto kami magpreparar ning ihapon para sa Pyesta ng Pagligad ng Anghel?” ");
INSERT INTO rol_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Nganì gingsugò niya ang iya duha nga disipulo. Hambay niya, “Kadto kamo didto sa syudad ng Jerusalem. Pag-abot nindo didto, may masumpong kamo nga lyaki nga nagapas-an ning bangà nga may tubì. Magsunod kamo sa iya ");
INSERT INTO rol_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","sa bayay nga iya pagasuyuran. Kag magpangutana kamo sa tag-iya ng bayay, ‘Nagapapangutana ang amon maestro kung sa diin ang kwarto nga pagakaunan niya kaibahan ng iya mga disipulo sa ihapon para sa Pyesta.’ ");
INSERT INTO rol_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ipakità niya sa indo ang malapad nga kwarto sa ibabaw nga kumplito ning mga gamit kag preparado na. Didto kamo magpreparar ng aton ihapon.” ");
INSERT INTO rol_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Nagpanaw ang duha kag pag-abot ninda sa syudad, nakità ninda ang tanan sunò sa ginghambay ni Hesus sa inda. Kag didto ninda gingpreparar ang ihapon para sa Pyesta ng Pagligad ng Anghel. ");
INSERT INTO rol_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nang manayumsom na, nag-abot si Hesus kag ang iya dose nga disipulo sa bayay. ");
INSERT INTO rol_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mintras nagakaon sinda, naghambay si Hesus, “Sa matuod lang ginahambay ko sa indo, isa sa indo nga akon kaibahan diri sa pagkaon ang magatraidor sa akon.” ");
INSERT INTO rol_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Pagkabatì ninda, nalisod gid sinda kag kada isa sa inda hay nagpangutana sa iya, “Bukon ako, dì ba?” ");
INSERT INTO rol_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Naghambay si Hesus sa inda, “Isa sa indo sa dose, nga magasawsaw ning tinapay sa hambawan kaibahan ko, imaw ang magatraidor sa akon. ");
INSERT INTO rol_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Kay ako nga Ungà ng Tawo hay pagapatyon sunò sa ginghambay ng Kasulatan, pero makaluluoy gid ang magatraidor sa akon. Maayo pa sa iya nga wayà ging-ungà.” ");
INSERT INTO rol_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mintras nagakaon sinda, nagbuoy si Hesus ning tinapay. Gingpasalamatan niya ini sa Dios kag gingbuak-buak. Pagkatapos gingtao niya sa iya mga disipulo kag naghambay, “Buy-a nindo ini, imaw ini ang akon lawas.” ");
INSERT INTO rol_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Pagkatapos nagbuoy siya ning tasa nga may ilimnon, nagpasalamat sa Dios kag gingtao sa inda. Kag sinda tanan hay nag-inom. ");
INSERT INTO rol_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Naghambay siya sa inda, “Ini ang akon dugò nga ibubò para mapalig-on ang kasugtanan agud mapatawad ang madamò nga tawo. ");
INSERT INTO rol_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Sa matuod lang ginahambay ko sa indo, indì na ako mag-inom liwat ning ilimnon halin sa ubas* hasta sa adlaw nga magainom ako ning bag-o nga klasi ng ilimnon sa gingharian ng Dios.” ");
INSERT INTO rol_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nagkanta sinda ning pagdayaw sa Dios. Pagkatapos nagkadto sinda sa Bukid ng mga Olibo. ");
INSERT INTO rol_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Naghambay si Hesus sa inda, “Bayaan nindo ako tanan kay ginahambay ng Kasulatan, ‘Patyon ko ang pastor* kag magakawatakwatak ang mga karnero.’ ");
INSERT INTO rol_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pero pagkatapos nga mabanhaw ako, mauna ako sa indo didto sa Galilea.” ");
INSERT INTO rol_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Naghambay si Pedro kay Hesus, “Aber bayaan ka ninda tanan, ako indì gid!” ");
INSERT INTO rol_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Naghambay si Hesus sa iya, “Sa matuod lang ginahambay ko sa indo, sa ini gid nga gab-i bago magtuktuyaok ang suyog ning pangaduha, indì mo ako pagkilay-on ning tuyo ka beses.” ");
INSERT INTO rol_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pero nagpilit pa gid si Pedro nga nagahambay, “Indì gid ako maghambay nga wayà ta ikaw makilaya, aber patyon pa ako ninda kaibahan ka.” Imaw da ang ginghambay ninda tanan. ");
INSERT INTO rol_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Pagkatapos nagkadto sinda sa lugar nga ginatawag, Getsemane. Pag-abot ninda didto, naghambay si Hesus sa iya mga disipulo, “Pungkò anay kamo diri mintras nagapangamuyò ako.” ");
INSERT INTO rol_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Gingdaya niya sina Pedro, Santiago* kag Juan sa una-unahan. Pagkatapos nagtunà siya magpangalisod kag naglain ang iya pamatyag. ");
INSERT INTO rol_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nganì naghambay siya sa inda, “Daw mamatay ako kay sobra gid ang akon kalisod. Pabilin kamo diri kag magpamuyaw.” ");
INSERT INTO rol_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Pagkatapos nagkadto pa gid siya sa una-unahan, naghapà siya hasta ang iya agtang nagduot sa dutà kag nagpangamuyò nga kung puydi lang, ipalampas ang oras ng iya kamatayon. ");
INSERT INTO rol_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Nagpangamuyò siya, “Abba, Amay, ang tanan nga butang posible sa imo. Nganì buy-a ini nga kahugaan sa akon. Pero bukon ang akon kagustuhan, kundì ang imo ang dapat matuman.” ");
INSERT INTO rol_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Pagbalik niya sa iya tuyo ka disipulo, naabutan niya sinda nga nagakatuyog. Naghambay siya kay Pedro, “Simon, nagakatuyog ka ba? Indì ka ba makapamuyaw aber isa lang ka oras? ");
INSERT INTO rol_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Magpamuyaw kamo kag magpangamuyò para indì kamo madaog ng pagtintar. Gusto ng imo espiritu nga magtuman ng akon gingbilin, ugaling maluya ang imo lawas.” ");
INSERT INTO rol_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nagkadto liwat si Hesus sa una-unahan kag nagpangamuyò. Imaw da gihapon ang iya ginghambay. ");
INSERT INTO rol_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Pagkatapos nagbalik siya liwat sa mga disipulo kag naabutan na naman niya sinda nga nagakatuyog kay ginapilaw gid sinda. Kag wayà sinda kasayod kung ano ang isabat sa iya. ");
INSERT INTO rol_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Sa ikatuyo nga pagbalik niya sa inda, naghambay siya, “Nagakatuyog pa ba gihapon kamo kag nagapahuway? Tamà na inà! Nag-abot na ang oras nga ako nga Ungà ng Tawo itugyan sa mga makasasalà. ");
INSERT INTO rol_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Bangon na! Sirua, yari na ang tawo nga nagatraidor sa akon.” ");
INSERT INTO rol_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Mintras nagahambay pa si Hesus, nag-abot si Judas nga isa sa dose nga disipulo. Kaibahan niya ang kadamò nga tawo nga may daya nga mga sundang kag mga pamakang. Gingsugò sinda didto ng mga pinunò nga parì, mga eskriba kag mga miyugdumaya ng Judio. ");
INSERT INTO rol_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Bago sinda nag-abot, gingbilinan na ng traidor ang mga madakop kung ano ang iya isinyas, “Ang tawo nga akon haruan imaw ang indo ginapangità. Dakpa nindo siya, day-a kag bantayi gid ning maayo.” ");
INSERT INTO rol_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Nganì pag-abot ni Judas, nagpalapit nga daan siya kay Hesus kag naghambay, “Maestro!” Kag gingharuan niya siya. ");
INSERT INTO rol_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Nganì gingdakop ninda si Hesus. ");
INSERT INTO rol_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Pero ang isa sa mga kaibahan ni Hesus nga nagatindog hay naggabot ng iya maisot nga sundang kag ginglabò ang ulipon ng Pinakamataas nga Parì kag nautod ang iya talinga. ");
INSERT INTO rol_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Naghambay si Hesus sa mga nagdakop sa iya, “Tulisan ba ako nga kahinangyan gid magdaya pa kamo ning mga sundang kag mga pamakang para dakpon ako? ");
INSERT INTO rol_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Adlaw-adlaw yadto ako sa templo nga nagatudlò kag yadto da kamo, wayà nindo ako pagdakpa. Pero natatabò ini para matuman ang mga ginahambay ng Kasulatan parti sa akon.” ");
INSERT INTO rol_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kag gingbayaan siya ng tanan niya nga disipulo kag nagdyagan sinda palayò. ");
INSERT INTO rol_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","May isa ka soltero didto nga nagsunod kay Hesus nga nagatapis lang ng tela. Nadakop kuntà siya ninda, ");
INSERT INTO rol_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ugaling nakahuyagpos siya, nganì nabilin ang tela kag nagdyagan siya nga nakauba. ");
INSERT INTO rol_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Gingdaya ninda si Hesus sa Pinakamataas nga Parì. Didto nagatipon ang tanan nga pinunò nga parì, ang mga miyugdumaya ng Judio kag ang mga eskriba. ");
INSERT INTO rol_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Si Pedro nagsunod da pero malayò-layò kay Hesus. Nagsuyod siya sa dyaag ng Pinakamataas nga Parì kag nagpungkò kaibahan ng mga gwardya malapit sa kalayo agud magpainit-init. ");
INSERT INTO rol_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ang mga pinunò nga parì kag ang tanan nga miyembro ng Korte ng mga Judio* hay nagpangità ning mga ebidensya kontra kay Hesus agud maipapatay ninda siya, pero wayà gid sinda ning may nakità. ");
INSERT INTO rol_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Madamò ang nagtestigo ning pinusong kontra sa iya, pero wayà nagapareho ang inda mga pamatuod. ");
INSERT INTO rol_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","May mga tawo pa gid didto nga nagtestigo ning pinusong kontra kay Hesus. Hambay ninda, ");
INSERT INTO rol_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nabatian namon siya nga naghambay, ‘Gubaon ko ini nga templo nga gingpatindog ng mga tawo kag sa suyod ng tuyo ka adlaw patindugon ko, ang iban nga templo nga bukon mga tawo ang magahuman.’ ” ");
INSERT INTO rol_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Bisan ano ang ginghambay ninda, ang inda mga pamatuod hay wayà nagapareho. ");
INSERT INTO rol_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nagtindog sa tungà ang Pinakamataas nga Parì kag nagpangutana kay Hesus, “Wayà ka ba ning maisabat sa ini nga mga akusasyon kontra sa imo?” ");
INSERT INTO rol_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Wayà gid nagsabat si Hesus. Nganì gingpangutana siya liwat ng Pinakamataas nga Parì, “Ikaw ba ang Kristo nga Ungà ng Dios nga ginadayaw ng mga tawo?” ");
INSERT INTO rol_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Nagsabat si Hesus sa iya, “Huo, ako! Kag makikità nindo ako nga Ungà ng Tawo nga nagapungkò hampig sa tuo ng Makagagahom nga Dios. Kag makikità da nindo ako sa mga panganod halin sa langit nga nagaabot sa kalibutan.” ");
INSERT INTO rol_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Pagkabatì adto ng Pinakamataas nga Parì, ginggisì niya ang iya barò sa kahangit kag naghambay, “Indì na kahinangyan ng mga testigo! ");
INSERT INTO rol_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nabatian nindo ang iya paghambay ning malain kontra sa Dios, ano ang indo desisyon?” Kag nagkaisa sinda nga sentensyahan siya nga patyon. ");
INSERT INTO rol_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Kag gingtunaan siya nga pilaan ng iban. Gingtabunan ninda ang iya hitsura kag gingsumbag. Pagkatapos naghambay sinda, “Sige, balitai kami! Sin-o ang nagsumbag sa imo?” Pagkatapos gingtinampà siya ng mga gwardya. ");
INSERT INTO rol_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Nang yadto pa si Pedro sa dyaag, may nag-abot nga isa sa mga ulipon nga babayi ng Pinakamataas nga Parì. ");
INSERT INTO rol_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pagkakità niya kay Pedro nga nagapainit-init sa kalayo, gingsirò niya siya ning maayo kag naghambay, “Kaibahan ka da ni Hesus nga taga-Nazaret!” ");
INSERT INTO rol_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pero nagbalibad si Pedro kag naghambay, “Wayà ako makakasayod ng imo ginahambay!” Pagkatapos nagkadto siya sa pwertahan paluwas. ");
INSERT INTO rol_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Didto nakità naman siya ng ulipon nga babayi kag naghambay liwat sa mga tawo didto, “Ini nga lyaki hay isa sa mga kaibahan ni Hesus.” ");
INSERT INTO rol_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pero nagbalibad liwat si Pedro. Malagat-lagat naghambay ang mga tawo didto kay Pedro, “Sigurado gid, ikaw hay isa sa iya mga kaibahan kay taga-Galilea ka da!” ");
INSERT INTO rol_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pero nagsumpà gid si Pedro kag naghambay, “Aber mamatay pa ako, wayà ko gid nakilaya ang tawo nga indo ginahambay!” ");
INSERT INTO rol_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Kag adto nga daan nagtuktuyaok ning pangaduha ang suyog. Kag nadumduman ni Pedro ang ginghambay ni Hesus sa iya, “Bago magtuktuyaok ang suyog ning pangaduha, indì mo ako pagkilay-on ning tuyo ka beses.” Nganì nagtinangis siya kag nagdanguyngoy gid. ");
INSERT INTO rol_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Pagsubat nga daan ng adlaw, nagtipon ang mga pinunò nga parì kaibahan ang mga miyugdumaya ng Judio, ang mga eskriba kag ang tanan nga miyembro ng Korte ng mga Judio, para magplano kung ano ang humanon kay Hesus. Ginggapos ninda si Hesus kag gingdaya agud itugyan kay Gobernador Pilato. ");
INSERT INTO rol_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Gingpangutana siya ni Pilato, “Ikaw ba ang harì ng mga Judio?” Nagsabat si Hesus sa iya, “Ikaw ang naghambay inà.” ");
INSERT INTO rol_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Madamò ang mga akusasyon ng mga pinunò nga parì kontra kay Hesus. ");
INSERT INTO rol_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Nganì gingpangutana siya liwat ni Pilato, “Wayà ba ikaw ning may maisabat sa ini nga mga butang? Madamò gid ang inda akusasyon kontra sa imo!” ");
INSERT INTO rol_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pero wayà gid nagsabat si Hesus, nganì natingaya gid si Pilato. ");
INSERT INTO rol_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kada Pyesta ng Pagligad ng Anghel, ang ginahuman ng gobernador hay nagapaluwas ning isa ka priso sunò sa ginapangayò ng mga tawo. ");
INSERT INTO rol_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","May isa ka priso didto nga ang pangayan hay Barabas. Ini nga tawo gingpriso kaibahan adtong mga nakapatay nang pagrebelde ninda kontra sa gobyerno. ");
INSERT INTO rol_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Madamò nga tawo ang nagpalapit kay Pilato kag gingpangayò ninda nga humanon niya liwat ang nagamnan niya kada Pyesta. ");
INSERT INTO rol_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Nagpangutana siya sa inda, “Gusto ba nindo nga buhian ko ang harì ng mga Judio para sa indo?” ");
INSERT INTO rol_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Nasayuran gid ni Pilato nga naiili ang mga pinunò nga parì kay Hesus, nganì gingtugyan ninda siya sa iya. ");
INSERT INTO rol_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pero gingsuysugan ng mga pinunò nga parì ang mga tawo nga si Barabas ang inda pangayuon nga paluwason, bukon si Hesus. ");
INSERT INTO rol_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Nagpangutana si Pilato sa inda liwat, “Ano ang akon humanon sa tawo nga indo ginatawag, Harì ng mga Judio?” ");
INSERT INTO rol_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Nagsinggit sinda, “Ilangsang siya sa krus!” ");
INSERT INTO rol_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pero nagpangutana si Pilato sa inda, “Basì, ano ba nga salà ang iya nahuman?” Pero gingtuduhan pa gid ninda ang pagsinggit, “Ilangsang siya sa krus!” ");
INSERT INTO rol_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Nganì tungod gusto ni Pilato nga paburan ang mga tawo, gingpaluwas niya si Barabas para sa inda. Pero si Hesus hay iya gingpalatigo kag gingtugyan sa mga sundalo agud ilangsang sa krus. ");
INSERT INTO rol_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Gingdaya ng mga sundalo si Hesus sa suyod ng palasyo ng gobernador nga ginatawag, Pretoryo, kag gingtawag ninda ang tanan nga batalyon ng mga sundalo nga magtipon didto. ");
INSERT INTO rol_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Kag gingbutangan ninda siya ning kapa nga maron. Ginghumanan ninda ning korona nga tunukon kag gingsuksok ini sa iya uyo. ");
INSERT INTO rol_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Pagkatapos ginatiaw-tiawan ninda siya, ginakamusta-kamusta nga ang hambay, “Mabuhay, ang Harì ng mga Judio!” ");
INSERT INTO rol_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Kag gingpinukoy ninda siya ning baston sa iya uyo kag gingpil-an da ninda siya. Gingluhod-luhuran ninda siya nga daw nagasamba. ");
INSERT INTO rol_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pagkatapos ng inda pag-ininsulto, ging-uba ninda ang kapa nga maron kag gingsuksukan ninda siya liwat ng iya barò. Tapos gingdaya ninda siya sa luwas para ilangsang sa krus. ");
INSERT INTO rol_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Mintras nagapanaw sinda paluwas, nasumpong ninda ang isa ka tawo nga halin sa baryo. Ang iya pangayan hay si Simon nga taga-Cyrene, tatay nina Alexander kag Rufus. Gingpilit ninda siya nga magpas-an ng krus ni Hesus. ");
INSERT INTO rol_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Pagkatapos gingdaya ninda si Hesus sa lugar nga ginatawag, Golgota (nga gusto hambayon, Lugar ng Bungò). ");
INSERT INTO rol_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Pag-abot ninda didto, gingtaw-an ninda si Hesus ning ilimnon nga may halò nga mira*, pero wayà siya mag-inom. ");
INSERT INTO rol_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Pagkatapos ginglangsang ninda siya sa krus kag gingparte ninda ang iya mga barò paagi sa palabunutan agud masayuran kung ano nga parte ang mabuoy ng kada isa. ");
INSERT INTO rol_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mga alas nuwebe ng aga, ginglangsang ninda si Hesus sa krus. ");
INSERT INTO rol_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","May karatula sa ibabaw ng iya uyo kag imaw ini ang nakasulat nga akusasyon kontra sa iya, ‘Ang Harì ng mga Judio.’ ");
INSERT INTO rol_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","May duha didto ka tulisan nga inda da ginglangsang sa krus, ang isa sa tuo ni Hesus kag ang isa sa iya waya. ");
INSERT INTO rol_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Sa ini nga paagi natuman ang ginahambay ng Kasulatan, ‘Gingtratar siya nga isa sa mga kriminal.’ ");
INSERT INTO rol_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ang mga tawo nga nagapang-agi didto hay nagaliong-liong nga ginainsulto si Hesus. Hambay ninda, “Hay! Ikaw nga nagahambay nga gubaon mo ang templo kag sa suyod ng tuyo ka adlaw patindugon mo liwat, ");
INSERT INTO rol_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","panaog dirà sa krus kag luwasa ang imo kaugalingon!” ");
INSERT INTO rol_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ginainsulto da siya ng mga pinunò nga parì kag mga eskriba. Naghambay sinda sa isa kag isa, “Gingtabangan niya ang iban, pero indì niya kaya nga tabangan ang iya kaugalingon! ");
INSERT INTO rol_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Siruon ta abi niyan kung makapanaog dirà sa krus ang Kristo nga Harì ng Israel, agud magpati kita sa iya.” Patì ang mga ginglangsang kaibahan niya hay nagainsulto da sa iya. ");
INSERT INTO rol_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Nang alas dose na ng adlaw, nagduyom ang bilog nga lugar hasta alas tres ng hapon. ");
INSERT INTO rol_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Nang alas tres na ng hapon, nagsinggit si Hesus ning makusog, “Eloi, Eloi lema sabachtani?” (Ang gusto ini hambayon, “Dios ko, Dios ko, basì gingpabay-an mo ako?”) ");
INSERT INTO rol_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ang iban nga nagatindog didto nga nakabatì ng iya gingsinggit naghambay, “Pamatì, ginatawag niya si Elias!” ");
INSERT INTO rol_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","May isa ka tawo didto nga nagdyagan, gingbuoy niya ang espongha kag ginglum-oy sa maaslom nga ilimnon. Gingtakod niya ini sa punta ng kuhit kag gingpalapit kay Hesus para supsupon niya. Naghambay siya, “Pabay-i siya! Siruon ta abi kung maabot si Elias para buy-on siya sa krus.” ");
INSERT INTO rol_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Nagsinggit si Hesus ning makusog kag nabugtuan siya ning ginhawa. ");
INSERT INTO rol_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kag nagisì sa tungà ning duha kaparte ang kurtina ng templo halin sa ibabaw paubos. ");
INSERT INTO rol_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nang makità ng kapitan ng mga sundalo nga nagatindog sa atubangan ng krus kung pauno nabuy-an ning ginhawa si Hesus, naghambay siya, “Matuod gid ini nga tawo hay Ungà ng Dios!” ");
INSERT INTO rol_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Sa malayò-layò may mga babayi da nga nagatan-aw sa nagakatabò. Kaibahan ninda sina Maria nga taga-Magdala, Maria nga nanay ni Santiago kag ng iya maguyáng nga si Joses kag si Salome. ");
INSERT INTO rol_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Sinda ang nagasunod kag nagaserbisyo kay Hesus, tunà nang yadto pa siya sa Galilea. Kag may madamò pa nga mga babayi nga nagtukad da sa Jerusalem nga kaibahan niya. ");
INSERT INTO rol_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Nang mamatay si Hesus hay Adlaw nga Inugpreparar, kay ang pagtunod ng adlaw imaw na ang Adlaw nga Inugpahuway*. Nganì nagpamuguso kag nagkadto si Jose nga taga-Arimatea kay Pilato para pangayuon ang lawas ni Hesus kay hapon na. Siya hay isa nga ginarespito nga miyembro sa Korte ng mga Judio kag nagahuyat siya sa paghaharì ng Dios. ");
INSERT INTO rol_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pagkabatì ni Pilato nga si Hesus hay patay na, natingaya siya. Nganì gingpatawag niya ang kapitan ng mga sundalo kag gingpangutana kung matuod ba nga patay na siya. ");
INSERT INTO rol_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Nang mabatian ni Pilato ang gingbalità ng kapitan, gingtugutan niya si Jose nga buy-on ang lawas. ");
INSERT INTO rol_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Nganì nagbakay si Jose ning mahay kag maayo nga klasi nga tela. Pagkatapos gingpatunton niya ang lawas ni Hesus sa krus kag gingpaputos ning tela. Gingpabutang niya ang lawas sa isa ka lubungan nga ginghuman sa alihid ng bakuyod. Kag gingpapaligid niya ang mabahoy nga bato para masarhan ang pwertahan ng lubungan. ");
INSERT INTO rol_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Nagatan-aw sina Maria nga taga-Magdala kag Maria nga nanay ni Joses kung sa diin ginglubong si Hesus. ");
INSERT INTO rol_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Pagkatapos ng Adlaw nga Inugpahuway, nang manayumsom na, si Maria nga taga-Magdala, si Maria nga nanay ni Santiago kag si Salome hay nagbakay ning pahumot para makadto sa lubungan kag pahiran ang lawas ni Hesus. ");
INSERT INTO rol_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Aga pa gid ng una nga adlaw ng simana, nagkadto sinda sa lubungan. ");
INSERT INTO rol_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Mintras nagapanaw sinda, nagpinangutan-an sinda, “Sin-o baya ang aton pangabayon nga magpaligid ng bato nga nagasara sa pwertahan ng lubungan?” (Kay sobra kabahoy ang bato.) Pero pag-abot ninda didto, nakità ninda nga napaligid na ang bato. ");
INSERT INTO rol_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Nganì nagsuyod sinda sa lubungan kag nakità ninda ang isa ka soltero nga nakabarò ning putì nga nagapungkò hampig sa tuo. Kag hinadlukan gid sinda. ");
INSERT INTO rol_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Pagkatapos naghambay ang soltero sa inda, “Ayaw kamo mahadlok! Sayod ko nga ginapangità nindo si Hesus nga taga-Nazaret nga ginglangsang sa krus. Wayà siya diri! Nabanhaw na siya! Sirua nindo ang gingbutangan sa iya. ");
INSERT INTO rol_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","“Kadto kamo, balitai nindo ang iya mga disipulo lalò na gid si Pedro, nga nauna na siya sa indo sa Galilea. Didto nindo siya makikità sunò sa iya ginghambay sa indo.” ");
INSERT INTO rol_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nganì nagluwas ang mga babayi sa lubungan kag nagdyagan nga nagapangurog kay sobra gid ang inda katingaya. Wayà sinda nagbalità aber kanin-o kay ginahadlukan gid sinda. ");
INSERT INTO rol_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Aga pa gid ng una nga adlaw ng simana, nabanhaw si Hesus. Una gid siya nagpakità kay Maria nga taga-Magdala, nga dati anay may pito nga demonyo nga gingpalayas ni Hesus. ");
INSERT INTO rol_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Nagkadto si Maria sa mga tagasunod ni Hesus nga nagakalisod kag nagatinangis kag gingbalitaan niya sinda. ");
INSERT INTO rol_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Pero wayà sinda nagpati sa iya gingbalità nga buhì si Hesus kag nagpakità sa iya. ");
INSERT INTO rol_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Pagkatapos adto, nagpakità si Hesus nga iba ang iya hitsura sa duha niya nga tagasunod nang nagapakadto sinda sa baryo. ");
INSERT INTO rol_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nganì nagbalik sinda sa Jerusalem kag gingbalitaan ninda ang iban nga mga kaibahan nga si Hesus hay nagpakità sa inda. Pero wayà da sinda nagpati. ");
INSERT INTO rol_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Nang ulihi nagpakità naman si Hesus sa onse nga disipulo mintras nagakaon sinda. Gingsabyaw niya sinda kay wayà sinda ning pagtuo kag matugas ang inda mga uyo, kay wayà sinda nagapati sa gingbalità ng mga nakakità sa iya nga nabanhaw na siya. ");
INSERT INTO rol_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Kag naghambay si Hesus sa inda, “Magkadto kamo sa tanan nga tawo sa bilog nga kalibutan kag iwali ang Maayong Balità sa tanan nga tawo. ");
INSERT INTO rol_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ang aber sin-o nga magtuo kag magpabawtismo maluwas, pero ang indì magtuo parusahan ng Dios. ");
INSERT INTO rol_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Kag ini nga mga milagro ang makikità sa mga tawo nga nagatuo sa akon: paagi sa akon pangayan magapalayas sinda ning mga demonyo; magahambay sinda ning iban nga mga linggwahe nga wayà ninda nasayuri; ");
INSERT INTO rol_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","kung makahawid sinda ning mga sawa o kung makainom ning aber ano nga hilò indì sinda mauno; kag kung itungtong ninda ang inda mga kamot sa may mga sakit, magaayo.” ");
INSERT INTO rol_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Pagkatapos maghambay ni Hesus sa inda, gingdaya siya palangit kag nagpungkò hampig sa tuo ng Dios. ");
INSERT INTO rol_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Kag nagwali ang iya mga tagasunod aber diin nga lugar. Gingbuligan sinda ng Ginoo kag gingpamatuuran ang gingwali ng mga tagasunod paagi sa mga milagro nga inda ginghuman. Kabay pa. (v 9) Nagkadto ang mga babayi kay Pedro kag sa iya mga kaibahan kag gingbalitaan ning matag-od parti sa ginghambay sa inda. (v 10) Pagkatapos adto, gingsugò ni Hesus ang iya mga tagasunod sa bilog nga kalibutan agud iwali ninda ang balità nga balaan kag indì maduduyà para sa kaluwasan nga wayà katapusan. Kabay pa.");
INSERT INTO rol_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Halangdon nga Teofilus: Kadamò na ang nagtinguhà nga magsulat parti sa mga natabò diri sa aton sa mga gingpahambay ng Dios paagi sa mga propeta* sa aton mga kalulo-lulohan. ");
INSERT INTO rol_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ang inda gingsulat hay halin sa gingbalità ng mga tawo nga imaw gid sinda ang nakakità magtunà pa nang una kung ano ang ginghuman ni Ginoong Hesus kag nagwali parti sa iya. ");
INSERT INTO rol_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ging-usisà ko gid maayo ini tanan halin sa gingtunaan. Nganì, halangdon nga Teofilus, naisip ko nga mas maayo kung pakaayuhon ko pa gid ang pagpasunod sa gingbalità ninda kag ipadaya sa imo. ");
INSERT INTO rol_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ginghuman ko ini kay gusto ko nga masayuran mo nga ang gingbalità sa imo hay matuod gid kag wayà kuyang. ");
INSERT INTO rol_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Nang si Herodes ang harì sa Judea, may parì didto nga ang iya pangayan hay si Zacarias nga halin sa grupo ng kaparian nga mga inapo ni Abia. Ang iya asawa nga si Elizabet hay isa sa mga inapo ni Aaron nga parì da. ");
INSERT INTO rol_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ini nga mag-asawa hay nagakabuhì ning matarong sa panirò ng Dios. Ginasunod ninda maayo ang tanan nga Kasuguan kag mga regulasyon ng Ginoo. ");
INSERT INTO rol_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pero wayà sinda ungà kay baog si Elizabet kag maguyang na sinda. ");
INSERT INTO rol_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Niyan, nag-abot ang adlaw nga si Zacarias kag ang iya grupo ang magaserbisyo sa suyod ng templo ng Dios. ");
INSERT INTO rol_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Paagi sa regulasyon ng mga parì nga pagbunot-bunutan, siya gid ang napilì nga magsunog ng insenso sa altar* ng Dios. Nganì nagsuyod siya sa templo. ");
INSERT INTO rol_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Mintras nagasunog siya ng insenso, kadamò nga tawo ang nagatipon sa luwas kag nagapangamuyò. ");
INSERT INTO rol_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Niyan, nagpakità sa iya ang anghel halin sa Ginoo nga nagatindog sa tuo ng altar nga ginasunugan ng insenso. ");
INSERT INTO rol_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nang makità ni Zacarias ang anghel, nangayag gid siya kag nagpangurog sa kahadlok. ");
INSERT INTO rol_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pero naghambay ang anghel sa iya, “Zacarias, ayaw mahadlok kay gingsabat na ng Dios ang imo pangamuyò. Si Elizabet nga imo asawa magaungà ng lyaki kag pangayanan mo siya ning Juan. ");
INSERT INTO rol_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Malilipay gid kamo sa iya kag madamò da ang malilipay kay matatawo siya, ");
INSERT INTO rol_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","kay magiging importante gid siya sa panirò ng Ginoo. Indì siya dapat mag-inom ning ilimnon o aber ano nga inumon nga nakakabayong. Kay tunà nang yadto pa siya sa tiyan ng iya nanay, napunò na siya ng Espiritu Santo. ");
INSERT INTO rol_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Kag pabalikon niya ang kadamò nga Israelita sa Ginoo nga inda Dios. ");
INSERT INTO rol_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Magauna siya sa Ginoo agud ipreparar ang mga tawo sa iya pag-abot. Humanon ini ni Juan paagi sa gahom ng Espiritu Santo nga pareho sa gingtao kay Elias nga propeta nang una. Pakaayuhon niya ang bukon maayo nga relasyon ng mga tatay kag mga ungà kag pabalikon niya ang mga tawo nga wayà nagatuman sa Dios sa maayo kag matarong nga pagkabuhì.” ");
INSERT INTO rol_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Niyan, nagpangutana si Zacarias sa anghel, “Pauno ko masiguro nga matatabò ang ginghambay mo kay maguyang na ako kag imaw da ang akon asawa?” ");
INSERT INTO rol_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Nagsabat ang anghel, “Ako si Gabriel nga miyugserbisyo ng Dios nga yadto permi sa iya presensya. Kag gingsugò niya ako diri para masayuran mo ining Maayong Balità*. ");
INSERT INTO rol_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pero tungod wayà ka nagpati ng akon ginghambay sa imo, magiging apà ka hasta sa adlaw nga matuman ang akon ginghambay. Matutuman gid ini sa adlaw nga gingpilì ng Dios.” ");
INSERT INTO rol_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Niyan, ang mga tawo sa luwas hay nagahinuyat kay Zacarias. Natingaya gid sinda kung basì kadugay siya sa suyod ng templo. ");
INSERT INTO rol_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Pagluwas niya indì na siya makahambay kag nagasinyas na lang siya sa mga tawo. Nganì nasayuran ninda nga may gingpakità ang Dios sa iya sa suyod. Tunà adto, naging apà na siya. ");
INSERT INTO rol_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Pagkatapos ng pagserbisyo ni Zacarias sa templo, nag-ulì siya sa inda. ");
INSERT INTO rol_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Wayà magdugay nagnabdos si Elizabet kag wayà na gid siya nagluwas sa inda bayay sa suyod ng lima ka bulan. ");
INSERT INTO rol_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Hambay ni Elizabet, “Gingkaluy-an gid ako ng Ginoo kay gingbuoy na niya ang akon kahuy-anan sa mga tawo kay baog ako.” ");
INSERT INTO rol_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Nang unom na ka bulan ang pagnabdos ni Elizabet, gingsugò liwat ng Dios ang anghel nga si Gabriel sa Nazaret nga isa sa mga banwa sa probinsya ng Galilea. ");
INSERT INTO rol_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Igwa siya gingpahambay sa isa ka birhen nga ang pangayan hay si Maria. Kyasayon na siya kay Jose nga isa sa mga inapo ni Haring David. ");
INSERT INTO rol_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Pag-abot ng anghel kay Maria, naghambay siya, “Maayo nga adlaw, Maria. Magkalipay ka kay ang Dios yarà sa imo! Ginataw-an ka niya ning kadakò nga pabor.” ");
INSERT INTO rol_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Nang mabatian ini ni Maria, nalibog gid siya kag ginahunahunà niya kung ano ang gusto hambayon ng anghel. ");
INSERT INTO rol_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Naghambay liwat ang anghel sa iya, “Maria, ayaw mahadlok. Ang Dios hay nalilipay gid sa imo. ");
INSERT INTO rol_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Maganabdos ka kag magaungà ning lyaki kag pangayanan mo siya nga Hesus. ");
INSERT INTO rol_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Magiging bantog siya kag pagatawagon nga Ungà ng Pinakamataas nga Dios. Kag humanon siya ng Ginoong Dios nga harì pareho ng iya kalulo-lulohan nga si Haring David. ");
INSERT INTO rol_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Magaharì siya sa mga inapo ni Jacob hasta sa wayà ning katapusan kag ang iya gingharian indì gid maduduyà.” ");
INSERT INTO rol_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Nagpangutana si Maria, “Pauno baya ini matabò kay birhen pa ako?” ");
INSERT INTO rol_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Nagsabat ang anghel, “Magaabot sa imo ang Espiritu Santo kag pagagamhan ka ng Pinakamataas nga Dios. Nganì ini nga ungà nga matatawo hay balaan kag pagatawagon siya nga Ungà ng Dios. ");
INSERT INTO rol_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Isipa na lang ang imo hali nga si Elizabet. Ginahambay ng iban nga baog siya. Pero niyan nabdos na siya ning unom ka bulan, aber maguyang na gid siya. ");
INSERT INTO rol_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kay sa Dios, wayà gid ning imposible!” ");
INSERT INTO rol_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Nagsabat si Maria, “Ulipon lang ako ng Ginoo. Kabay pa nga matuman sa akon ang imo ginghambay.” Pagkatapos, naghalin ang anghel. ");
INSERT INTO rol_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Wayà magdugay, nagpreparar si Maria kag dalì-dalì nga nagkadto sa isa ka banwa sa kabukiran ng Judea. ");
INSERT INTO rol_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Pag-abot niya didto, nagsuyod siya sa bayay ni Zacarias kag gingkamusta si Elizabet. ");
INSERT INTO rol_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Nang mabatian ni Elizabet ang boses ni Maria, naghinukay ang ungà sa suyod ng iya tiyan. Niyan napunò si Elizabet ng Espiritu Santo. ");
INSERT INTO rol_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Naghambay siya ning makusog kay Maria, “Sa tanan nga mga babayi, ikaw gid ang ginataw-an ng Dios ng pinakamadakò nga pagpakamaayo kag ining matatawo nga ungà hay taw-an da ning pagpakamaayo. ");
INSERT INTO rol_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Sin-o gid abi ako para taw-an importansya nga bisitahon ng nanay ng akon Ginoo? ");
INSERT INTO rol_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kay nang mabatian ko ang imo pagpangamusta, naghinukay ang ungà sa suyod ng akon tiyan sa sobra nga kalipay. ");
INSERT INTO rol_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Malipay ka gid kay gingpatihan mo nga matutuman ang gingpahambay sa imo ng Ginoo.” ");
INSERT INTO rol_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Naghambay si Maria, “Ginadayaw ko ang Ginoo halin sa akon tagipusuon! ");
INSERT INTO rol_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Kag nalilipay gid ang akon espiritu sa Dios nga Manluluwas nakon, ");
INSERT INTO rol_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","kay gingdumdom gid niya ako nga kubos niya nga ulipon! Nganì tunà niyan, magahambay ang tanan nga ako malipayon, ");
INSERT INTO rol_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","tungod sa mga makatitingaya nga butang nga ginghuman sa akon ng Dios nga makagagahom. Ang iya balaan nga pangayan dayawon! ");
INSERT INTO rol_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Naluluoy gid siya sa tanan nga matinahuron; tunà pa nang una hasta sa paabuton nga henerasyon. ");
INSERT INTO rol_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Gingpakità niya ang iya gahom kay gingpalayas niya ang mga hambugon para indì matuman ang inda handom. ");
INSERT INTO rol_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Gingpababà niya ang mga harì sa inda mga trono, kag gingpataas niya ang mga mapinaubuson. ");
INSERT INTO rol_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Gingtaw-an niya ng tanan nga maayo ang mga nagugutom, pero wayà gid may mabubuoy ang mga manggaranon. ");
INSERT INTO rol_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Gingtuman niya ang iya gingpromisa sa aton mga kalulo-lulohan, nganì ang iya suluguon nga mga Israelita iya gingbuligan. ");
INSERT INTO rol_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Wayà gid siya nalimot nga si Abraham kaluy-an kag ang iya mga inapo hasta sa wayà katapusan!” ");
INSERT INTO rol_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Kag nag-istar si Maria didto kana Elizabet ng tuyo pa ka bulan. Pagkatapos nag-ulì na siya sa inda. ");
INSERT INTO rol_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nag-abot na ang oras ng pagbatyag ni Elizabet kag nag-ungà siya ning lyaki. ");
INSERT INTO rol_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nang mabatian ng mga kalapit kag mga hali niya nga dakò ang kaluoy ng Dios sa iya, nalipay da sinda. ");
INSERT INTO rol_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nang wayo na ka adlaw ang ungà, nagtipon ang mga kalapit kag mga hali nina Elizabet sa inda bayay kay ipapaltak* na ang lapsag. Pangayanan kuntà ninda ini nga Zacarias pareho sa iya tatay ");
INSERT INTO rol_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","pero naghambay si Elizabet, “Bukon! Dapat Juan ang ipangayan sa iya.” ");
INSERT INTO rol_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Hambay ninda, “Basì? Wayà Juan nga pangayan aber sin-o sa indo mga hali!” ");
INSERT INTO rol_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Nganì gingsinyasan ninda ang tatay kung ano ang iya gusto nga ipangayan sa lapsag. ");
INSERT INTO rol_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Nagsinyas siya nga taw-an siya ning masusulatan kag gingsulat niya, Juan ang pangayan niya. Natingaya gid sinda tanan. ");
INSERT INTO rol_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Adto nga daan nakahambay si Zacarias kag nagdayaw siya sa Dios. ");
INSERT INTO rol_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Hinadlukan ang inda mga kalapit kag ang tanan nga natabò hay nakaabot sa tanan nga baryo sa kabukiran ng Judea. ");
INSERT INTO rol_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ging-inisip ng tanan nga tawo nga nakabatì ang parti sa natabò kag nagpinangutan-an sinda, “Ano baya ang matatabò sa ini nga ungà pagbahoy niya?” Kay ang gahom ng Ginoo nakikità gid nga yarà sa iya. ");
INSERT INTO rol_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Niyan, napunò ng Espiritu Santo si Zacarias nga tatay ni Juan kag imaw ini ang gingpahambay sa iya ng Dios: ");
INSERT INTO rol_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Dayawon ang Ginoo nga Dios ng Israel! Nagkari na siya sa aton nga iya gingpilì nga mga tawo para luwason kita sa aton kasal-anan. ");
INSERT INTO rol_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Kay gingpadaya niya sa aton ang makagagahom nga Manluluwas nga inapo ni David nga iya suluguon. ");
INSERT INTO rol_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Imaw ini ang iya gingpahambay paagi sa iya mga balaan nga propeta nang una pa gid. ");
INSERT INTO rol_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Nagpromisa siya nga luwason niya kita sa aton mga kaaway kag sa tanan nga nagabatò sa aton. ");
INSERT INTO rol_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Naghambay siya nga kaluy-an niya ang aton mga kalulo-lulohan, kag indì gid niya pagkalimutan ang iya gingpromisa sa iya balaan nga kasugtanan sa inda. ");
INSERT INTO rol_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Nagpanumpà siya sa aton kalulo-lulohan nga si Abraham nga ");
INSERT INTO rol_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","tabangan niya kita sa aton mga kaaway para makaserbisyo kita sa iya nga wayà gid ginakahadlukan ");
INSERT INTO rol_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","kag maging balaan kag matarong kita sa iya panirò hasta nga may ginhawa pa kita.” ");
INSERT INTO rol_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Niyan naghambay si Zacarias sa iya ungà, “Ikaw, Nonò, pagatawagon ka nga propeta ng Pinakamataas nga Dios. Magauna ka sa aton Ginoo para ipreparar ang mga tawo sa iya pag-abot. ");
INSERT INTO rol_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Tutudluan mo ang iya mga tawo para maluwas sinda kag mapatawad ng Dios ang inda kasal-anan, ");
INSERT INTO rol_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","kay ang aton Dios maluluy-on kag mapinalanggaon. Pareho sa pagsubat ng adlaw nga may daya nga kahayag ang pagpadaya ng Dios ng Manluluwas halin sa langit, ");
INSERT INTO rol_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","para mahayagan ang mga nagakabuhì sa kaduyom kag nahahadlok sa kamatayon. Magatudlò siya sa aton kung pauno magkaigwa maayo nga relasyon sa Dios kag sa aton isigkatawo.” ");
INSERT INTO rol_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kag nagbahoy si Juan nga makusog ang iya espiritu. Nag-istar siya sa tiway nga lugar hasta sa tyempo nga nagpakità siya kag nagwali sa mga Israelita. ");
INSERT INTO rol_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Nang adto nga tyempo, naghuman ang Emperador ng Roma nga si Augustus ning kasuguan nga ang tanan nga tawo nga sakop ng iya gingharian hay dapat magpalista. ");
INSERT INTO rol_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ini ang una nga sensos nang si Quirinius ang gobernador sa probinsya ng Syria. ");
INSERT INTO rol_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nganì nagpangbalik ang tanan nga mga tawo sa kaugalingon ninda nga banwa para magpalista. ");
INSERT INTO rol_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Niyan naghalin si Jose sa Nazaret nga sakop ng Galilea kag nagkadto sa Betlehem nga sakop ng Judea kung sa diin natawo si Haring David. Didto siya nagkadto kay isa siya sa mga inapo ni David. ");
INSERT INTO rol_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Gingdaya niya si Maria nga kyasayon na sa iya para magpalista da didto. Si Maria hay paungaon na ");
INSERT INTO rol_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","kag nang yadto na sinda sa Betlehem, nag-abot ang adlaw nga nagbatyag na siya. ");
INSERT INTO rol_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nag-ungà siya ning panganay nga lyaki kag gingputos niya ini ning hamo kag gingpahigdà sa ginabutangan ng sabsabon. Yadto sinda sa kug-ungan ng mga hayop kay wayà na sinda madayunan. ");
INSERT INTO rol_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Adto da nga gab-i, ang mga pastor* ng karnero hay yadto sa pasabsaban nga malapit sa Betlehem nga nagabantay ng inda mga hayop. ");
INSERT INTO rol_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kag gulpi lang nagpakità ang anghel ng Ginoo sa inda kag nahayagan sinda ning kahayag ng Ginoo. Hinadlukan gid sinda, ");
INSERT INTO rol_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","pero naghambay ang anghel, “Ayaw kamo mahadlok; nagkari ako sa indo para ipasayod ang Maayong Balità nga magatao ning dakò nga kalipay sa tanan nga tawo. ");
INSERT INTO rol_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kay sa ini nga adlaw, natawo sa banwa ni Haring David ang indo Manluluwas. Siya ang Ginoo nga ginatawag nga Kristo*. ");
INSERT INTO rol_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ini ang tandà nga matuod ang akon ginahambay: makikità nindo ang lapsag nga nakaputos ning hamo nga nagahigdà sa ginabutangan ng sabsabon.” ");
INSERT INTO rol_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kag gulpi lang nagpakità ang madamò pa gid nga mga anghel halin sa langit. Kaibahan ng nauna nga anghel, nagdayaw sinda tanan sa Dios. Nagkanta sinda, ");
INSERT INTO rol_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Dayawon ang Dios sa pinakamataas nga langit kag sa mga tawo nga nagapalipay sa iya, katawhayan*!” ");
INSERT INTO rol_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Pagbalik ng mga anghel sa langit, naghambay ang mga pastor ng karnero sa isa kag isa, “Mos, makadto kita sa Betlehem, tan-awon naton ining gingpasayod ng Ginoo sa aton.” ");
INSERT INTO rol_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nganì nagdalì-dalì sinda nga nagkadto sa Betlehem kag didto nakità ninda sina Maria kag Jose kag ang lapsag nga nagahigdà sa ginabutangan ng sabsabon. ");
INSERT INTO rol_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nang makità ng mga pastor ng karnero ang lapsag, gingpamalità ninda ang ginghambay ng anghel parti sa iya. ");
INSERT INTO rol_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kag natingaya gid ang tanan nga nakabatì sa gingbalità ninda. ");
INSERT INTO rol_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Pero gingtagò ni Maria sa iya tagipusuon ang tanan nga natabò kag ginahunahunà niya ini permi. ");
INSERT INTO rol_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Niyan, nagbalik ang mga pastor ng karnero sa pasabsaban nga nagakanta kag nagadayaw sa Dios tungod sa tanan nga inda nakità kag nabatian kay napamatuuran gid ninda ang ginghambay ng anghel. ");
INSERT INTO rol_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nang wayo na ka adlaw ang lapsag, gingpapaltak ninda ini kag gingpangayanan nga Hesus. Imaw ini ang pangayan nga ginghambay ng anghel kay Maria nang wayà pa siya naganabdos. ");
INSERT INTO rol_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Nag-abot ang adlaw nga kahinangyan tumanon ni Jose kag ni Maria ang Kasuguan ng Dios nga gingsulat ni Moises parti sa mga babayi nga bag-ong ungà para maging malimpyo sinda. Nganì nagkadto sinda sa Jerusalem para tumanon ini kag gingdaya ninda ang lapsag nga si Hesus para ihalad kay nakasulat sa Kasuguan ng Ginoo, ");
INSERT INTO rol_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","“Ang tanan nga panganay nga lyaki hay dapat ihalad sa Ginoo.” ");
INSERT INTO rol_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Nganì nagdaya da sinda ng duha ka salampati para tumanon ang Kasuguan ng Ginoo, “Duha ka pispis o duha ka pisò ng salampati ang dapat ihalad.” ");
INSERT INTO rol_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Niyan igwa tawo didto sa Jerusalem nga ang pangayan hay Simeon. Siya hay matarong kag diosnanon kag yarà sa iya ang Espiritu Santo. Ginahuyat niya nga luwason ng Dios sa kasal-anan ang mga Israelita. ");
INSERT INTO rol_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Gingpasayod sa iya ng Espiritu Santo nga indì siya mamamatay hasta wayà pa niya makikità ang gingsugò ng Dios nga Kristo nga iya gingpromisa. ");
INSERT INTO rol_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Adto nga adlaw, gingtuytuyan si Simeon ng Espiritu Santo nga magsuyod sa templo. Nganì yadto siya nang gingdaya si Hesus ng iya mga ginikanan sa suyod ng templo para tumanon ang gingsugò ng Kasuguan. ");
INSERT INTO rol_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Pagkakità ni Simeon sa lapsag, gingbuoy niya ini kag gingkugos. Nagdayaw siya sa Dios nga nagahambay, ");
INSERT INTO rol_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Ginoo, puydi mo na ako papahuwayon nga matawhay ang akon hunahunà kay natuman na ang imo gingpromisa sa akon. ");
INSERT INTO rol_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kay niyan, nakità ko na gid ang Manluluwas halin sa imo ");
INSERT INTO rol_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","nga gingpreparar mo para sa tanan nga tawo. ");
INSERT INTO rol_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Siya hay pareho sa iwag nga magadaya kahayag ng kamatuuran parti sa imo para sa mga bukon Judio*. Kag tungod sa iya padunggan* ang imo gingpilì nga mga Israelita.” ");
INSERT INTO rol_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Natingaya gid ang mga ginikanan ni Hesus tungod sa ginghambay ni Simeon parti sa ungà. ");
INSERT INTO rol_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Gingbendisyunan sinda ni Simeon pagkatapos naghambay pa kay Maria, “Ini nga ungà gingpilì ng Dios para parusahan o luwason ang kadamuan sa Israel. Magiging tandà siya halin sa Dios pero kadamò ang magahambay ning malain kontra sa iya. ");
INSERT INTO rol_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Nganì ang tanan nga malain nga ginahunahunà ng mga tawo hay masasayuran. Kag ikaw, Maria, magabatyag ka ning dakò gid nga kalisod nga daw ginabunò ang imo tagipusuon.” ");
INSERT INTO rol_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Yadto da sa templo ang babayi nga propeta nga ang pangayan hay Ana. Siya hay ungà ni Fanuel nga halin sa tribo ni Asher. Pito lang ka tuig ang inda pag-iba ng iya asawa ");
INSERT INTO rol_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","kag nabayo na siya. 84 ka años na ang iya edad kag yadto lang gid siya sa templo kag wayà siya nagaluwas kay adlaw kag gab-i nagasamba siya sa Dios nga nagapuasa kag nagapangamuyò. ");
INSERT INTO rol_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Adto nga oras, mintras yadto pa sina Jose sa templo, nagpalapit siya sa inda kag nagpasalamat sa Dios tungod sa ungà. Gingpamalità niya ang parti kay Hesus sa mga tawo nga nagahuyat ng tyempo nga luwason ng Dios ang mga Israelita. ");
INSERT INTO rol_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nang matuman na nina Jose kag Maria ang tanan nga dapat humanon nga nakasulat sa Kasuguan ng Ginoo, nag-ulì na sinda sa inda banwa ng Nazaret sa probinsya ng Galilea. ");
INSERT INTO rol_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Didto nagbahoy si Hesus kag nagkusog pa gid. Nadugangan pa ang iya kamayad kag gingpakamaayo siya ng Dios. ");
INSERT INTO rol_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kada tuig nagakadto ang mga ginikanan ni Hesus sa Jerusalem para magsilibrar ng Pyesta ng Pagligad ng Anghel*. ");
INSERT INTO rol_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Nang dose ka años na si Hesus, nagnunot siya sa iya mga ginikanan para magsilibrar ng ini nga Pyesta pareho ng inda permi ginahuman. ");
INSERT INTO rol_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pagkatapos, nag-ulì na sinda pero nagpabilin pa si Hesus sa Jerusalem. Wayà ini nasayuri ng iya mga ginikanan. ");
INSERT INTO rol_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Kalaom ninda nagnunot si Hesus sa inda mga kaibahan pagbalik. Isa ka adlaw na sinda nga nagapanaw bago ninda gingsugid si Hesus sa inda mga hali kag mga kakilaya. ");
INSERT INTO rol_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pero wayà ninda nakità si Hesus, nganì nagbalik sinda sa Jerusalem para sugiron siya. ");
INSERT INTO rol_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nang ikatuyo na ka adlaw, nakità ninda si Hesus didto sa templo nga nagapungkò kaibahan ng mga eskriba* nga nagapamatì kag nagapangutana sa inda. ");
INSERT INTO rol_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ang tanan nga nagapamatì sa iya hay natingaya gid kay maayo ang iya pang-intindi kag pagsabat sa mga pangutana. ");
INSERT INTO rol_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nang makità siya ng iya mga ginikanan, natingaya gid sinda. Hambay ng iya nanay, “Nonò, basì ginghuman mo ini sa amon? Nabayaka gid kami ng imo tatay sa kasusugid sa imo.” ");
INSERT INTO rol_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nagsabat si Hesus sa inda, “Basì baya ginasugid nindo ako? Wayà ba kamo makasayod nga dapat yari ako sa bayay ng akon Amay?” ");
INSERT INTO rol_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pero wayà ninda maintindihi kung ano ang gusto niya nga hambayon. ");
INSERT INTO rol_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Pagkatapos nagnunot si Hesus sa inda pagbalik sa Nazaret kag siya hay naging matinumanon sa iya mga ginikanan. Pero gingtagò ng iya nanay sa iya tagipusuon ang tanan nga mga butang nga natatabò. ");
INSERT INTO rol_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Nagbahoy si Hesus kag nagdugang pa gid ang iya kamayad kag nalipay gid sa iya ang Dios kag ang mga tawo. ");
INSERT INTO rol_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Nang 15 ka tuig na ang pagdumaya ni Tiberius nga Emperador sa Roma, si Poncio Pilato ang gobernador sa Judea, si Herodes ang pinunò sa Galilea kag ang hali niya nga si Felipe ang pinunò sa lugar ng Iturea kag Traconitis. Si Lisanias naman ang pinunò sa Abilenia, ");
INSERT INTO rol_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","kag sina Anas kag Caifas ang mga Pinakamataas nga Parì. Nang adto nga tyempo, may ginghambay ang Dios kay Juan nga ungà ni Zacarias didto sa tiway nga lugar. ");
INSERT INTO rol_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nganì nagkadto si Juan sa tanan nga lugar sa palibot ng subà ng Jordan kag nagwali. Hambay niya sa mga tawo, “Talikuri nindo ang indo kasal-anan kag magpabawtismo para patawaron kamo ng Dios.” ");
INSERT INTO rol_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Sa ini nga ginahuman ni Juan, natuman ang ginghambay ni Propeta Isaias nga nakasulat sa iya libro, “May magasinggit sa tiway nga lugar. Magahambay siya sa mga tawo, ‘Ipreparar nindo ang agihan para sa Ginoo, tadlunga ang dayan nga iya pagaagihan! ");
INSERT INTO rol_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tambaki ang tanan nga mababà nga lugar, pataga ang tanan nga mga bukid kag bakuyod. Tadlunga ang mga likuon nga karsada kag pantaya ang mga batuhon. ");
INSERT INTO rol_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Niyan makikità ng tanan nga tawo kung pauno sinda luwason ng Dios!’ ” ");
INSERT INTO rol_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Kadamò ang mga tawo nga nagkadto kay Juan para magpabawtismo. Naghambay siya sa inda, “Mga inapo kamo ng sawa! Sin-o ang naghambay sa indo nga makalikaw kamo sa paabuton nga parusa ng Dios? ");
INSERT INTO rol_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kung matuod nga ginatalikuran nindo ang indo mga kasal-anan, pamatuuri nindo ini paagi sa paghuman ning maayo. Kag ayaw maghambay nga mga inapo kamo ni Abraham, makalikaw kamo sa parusa. Pero ginahambay ko sa indo nga aber ang mga bato nga yari diri puydi humanon ng Dios nga mga inapo ni Abraham. ");
INSERT INTO rol_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Tandai nindo ini: preparado na ang wasay sa pagpukan sa punò ng mga kahoy. Nganì ang kada kahoy nga wayà nagapamunga ning maayo hay pagapukanon kag ipilak sa kalayo.” ");
INSERT INTO rol_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nagpangutana ang mga tawo kay Juan, “Hay ano galì ang amon humanon?” ");
INSERT INTO rol_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Nagsabat siya, “Kung igwa kamo duha nga barò, itao ang isa sa wayà kag kung igwa kamo pagkaon, taw-i ang wayà.” ");
INSERT INTO rol_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","May mga miyugsukot ng buhis nga nagkadto sa iya para magpabawtismo kag gingpangutana ninda si Juan, “Maestro, ano naman ang dapat namon humanon?” ");
INSERT INTO rol_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Nagsabat siya, “Ayaw kamo magpanukot ng sobra-sobra nga buhis kundì kung ano lang ang tamà.” ");
INSERT INTO rol_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","May mga sundalo nga nagpangutana sa iya, “Hay kami naman, ano ang dapat namon humanon?” Nagsabat si Juan sa inda, “Ayaw magpamahog kag magpangbintang para lang makakwarta, dapat makuntinto kamo sa indo sweldo.” ");
INSERT INTO rol_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Pagkabatì ng mga tawo sa ginghambay ni Juan, naghunahunà sinda nga si Juan imaw na ang Kristo nga inda ginahuyat. ");
INSERT INTO rol_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Pero naghambay si Juan sa inda tanan, “Nagabawtismo ako sa indo sa tubì, pero may maabot nga mas makagagahom pa kaysa sa akon kag indì gid ako angay aber magbaskad ng higot ng iya sandalyas. Siya ang magabawtismo sa indo sa Espiritu Santo kag sa kalayo. ");
INSERT INTO rol_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Pareho siya sa miyug-ani nga nagapahangin ng iya inani para lainon ang matinggas sa upa. Tipunon niya ang matinggas kag ibutang sa iya kamalig, pero sunugon niya ang upa sa kalayo nga indì gid mamatay.” ");
INSERT INTO rol_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Gingtudlò ni Juan ang Maayong Balità sa iba-iba nga paagi kag ginglaygayan niya ang mga tawo, “Tumana nindo ang mga butang nga ginatudlò ko.” ");
INSERT INTO rol_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Aber pa si Herodes nga gobernador ng Galilea hay ginghambayan ni Juan kay ging-iba niya si Herodias nga asawa ng iya hali kag tungod sa madamò pa nga kalainan ang iya ginahuman. ");
INSERT INTO rol_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Nadugangan pa gid ang kalainan nga ginahuman ni Herodes kay gingpapriso niya si Juan. ");
INSERT INTO rol_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Niyan nang mabawtismuhan ni Juan ang madamò nga tawo, nagpabawtismo da si Hesus. Pagkatapos ng pagbawtismo sa iya kag mintras nagapangamuyò siya, nag-abri ang langit ");
INSERT INTO rol_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","kag ang Espiritu Santo nga daw salampati hay nagbabà pakadto sa iya. Kag igwa boses nga nabatian halin sa langit nga naghambay, “Ikaw ang akon pinalanggà nga Ungà, nalilipay gid ako sa imo.” ");
INSERT INTO rol_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Nagtunà si Hesus sa pagpanudlò kag pagwali nang mga 30 ka años na siya. Ang pagkakilaya sa iya ng mga tawo hay ungà siya ni Jose nga ungà ni Eli. ");
INSERT INTO rol_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Si Eli hay ungà ni Matat nga ungà ni Levi. Si Levi hay ungà ni Melki nga ungà ni Janai. Si Janai hay ungà ni Jose ");
INSERT INTO rol_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","nga ungà ni Matatias. Si Matatias hay ungà ni Amos nga ungà ni Nahum. Si Nahum hay ungà ni Esli nga ungà ni Nagai. ");
INSERT INTO rol_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Si Nagai hay ungà ni Maat nga ungà ni Matatias. Si Matatias hay ungà ni Semein nga ungà ni Josec. Si Josec hay ungà ni Joda ");
INSERT INTO rol_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","nga ungà ni Joanan. Si Joanan hay ungà ni Resa nga ungà ni Zerubabel. Si Zerubabel hay ungà ni Shealtiel nga ungà ni Neri. ");
INSERT INTO rol_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Si Neri hay ungà ni Melki nga ungà ni Adi. Si Adi hay ungà ni Cosam nga ungà ni Elmadam. Si Elmadam hay ungà ni Er ");
INSERT INTO rol_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","nga ungà ni Josue*. Si Josue hay ungà ni Eliezer nga ungà ni Jorim. Si Jorim hay ungà ni Matat nga ungà ni Levi. ");
INSERT INTO rol_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Si Levi hay ungà ni Simeon nga ungà ni Juda. Si Juda hay ungà ni Jose nga ungà ni Jonam. Si Jonam hay ungà ni Eliakim ");
INSERT INTO rol_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","nga ungà ni Melea. Si Melea hay ungà ni Mena nga ungà ni Matata. Si Matata hay ungà ni Natan nga ungà ni David. ");
INSERT INTO rol_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Si David hay ungà ni Jesse nga ungà ni Obed. Si Obed hay ungà ni Boaz nga ungà ni Salmon. Si Salmon hay ungà ni Nashon ");
INSERT INTO rol_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","nga ungà ni Aminadab. Si Aminadab hay ungà ni Admin nga ungà ni Arni. Si Arni hay ungà ni Ezron nga ungà ni Perez. Si Perez hay ungà ni Juda ");
INSERT INTO rol_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","nga ungà ni Jacob. Si Jacob hay ungà ni Isaac nga ungà ni Abraham. Si Abraham hay ungà ni Tera nga ungà ni Nahor. ");
INSERT INTO rol_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Si Nahor hay ungà ni Serug nga ungà ni Reu. Si Reu hay ungà ni Peleg nga ungà ni Eber. Si Eber hay ungà ni Shela ");
INSERT INTO rol_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","nga ungà ni Cainan. Si Cainan hay ungà ni Arfaxad nga ungà ni Shem. Si Shem hay ungà ni Noe nga ungà ni Lamec. ");
INSERT INTO rol_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Si Lamec hay ungà ni Metusela nga ungà ni Enoc. Si Enoc hay ungà ni Jared nga ungà ni Mahalalel. Si Mahalalel hay ungà ni Cainan nga ungà ni Enosh. ");
INSERT INTO rol_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Si Enosh hay ungà ni Set nga ungà ni Adan. Si Adan hay ungà ng Dios. ");
INSERT INTO rol_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Pagkatapos adto, nagbalik si Hesus halin sa subà ng Jordan nga punò ng Espiritu Santo kag gingtuytuyan siya ng Espiritu Santo sa tiway nga lugar. ");
INSERT INTO rol_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Didto siya nagtinir sa suyod ng 40 ka adlaw, nga ginatinintar ng diyablo. Adto nga mga adlaw, wayà gid siya nagkaon. Nganì pagkatapos ng 40 ka adlaw, ginutom gid siya tudo. ");
INSERT INTO rol_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Naghambay ang diyablo sa iya, “Kung ikaw ang Ungà ng Dios, sugua ini nga bato nga maging tinapay.” ");
INSERT INTO rol_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Pero nagsabat si Hesus, “Ginahambay ng Kasulatan, ‘Bukon lang sa pagkaon nabubuhì ang tawo.’ ” ");
INSERT INTO rol_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Pagkatapos, gingdaya siya ng diyablo sa mataas nga lugar kag gingpakità sa iya ang tanan nga gingharian sa kalibutan sa matag-od lang nga oras. ");
INSERT INTO rol_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Naghambay si Satanas sa iya, “Sa imo ko itatao ang tanan nga otoridad kag manggad sa kalibutan. Kay gingtao ini tanan sa akon kag puydi ko da ini itao aber kanin-o nga gusto ko taw-an. ");
INSERT INTO rol_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nganì kung maghapà ka kag magsamba sa akon, sa imo na inà tanan.” ");
INSERT INTO rol_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Pero nagsabat si Hesus, “Ginahambay da ng Kasulatan, ‘Sambahon mo ang Ginoo nga imo Dios kag siya lang gid ang imo serbisyuhan.’ ” ");
INSERT INTO rol_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Pagkatapos gingdaya ni Satanas si Hesus sa pinakamataas nga parte ng templo sa Jerusalem. Kag hambay niya, “Kung ikaw ang Ungà ng Dios, maglumpat ka! ");
INSERT INTO rol_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kay ginahambay da ng Kasulatan, ‘Susuguon ng Dios ang iya mga anghel nga magbantay sa imo ning maayo.’ ");
INSERT INTO rol_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Kag ‘hahawiran ka ninda, para indì mabunggò ang imo siki sa bato.’ ” ");
INSERT INTO rol_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Pero nagsabat si Hesus, “Ginahambay da ng Kasulatan, ‘Ayaw pagtintara ang Ginoo nga imo Dios.’ ” ");
INSERT INTO rol_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nang mahuman na ng diyablo ang tanan nga pagtintar kay Hesus, gingbayaan niya anay siya. ");
INSERT INTO rol_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Pagkatapos, nagbalik si Hesus sa Galilea kag yarà sa iya ang gahom ng Espiritu Santo. Ang balità parti sa iya hay nasayuran gid sa bilog nga rehiyon. ");
INSERT INTO rol_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nagtudlò siya sa mga sinagoga* kag gingdayaw siya ng tanan nga mga tawo. ");
INSERT INTO rol_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Pagkatapos, nagkadto si Hesus sa Nazaret, ang lugar nga iya gingbahuyan. Pag-abot ng Adlaw nga Inugpahuway* nagkadto siya sa sinagoga pareho ng iya ginahuman permi. Nagtindog siya para magbasa ng Kasulatan. ");
INSERT INTO rol_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Gingtao sa iya ang nakalukot nga gingsulat ni Propeta Isaias. Gingbukyad niya kag pagkakità sa parte nga iya ginapangità, gingbasa niya ini: ");
INSERT INTO rol_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ang Espiritu ng Dios yari sa akon, kay gingpilì niya ako nga magwali ng Maayong Balità sa mga pobre. Gingpadaya niya ako diri para ibalità sa mga ginggapos ni Satanas nga buhian sinda ng Dios kag sa mga buta para makakità na sinda. Gingpadaya niya ako para buligan ang mga ginadaog-daog, ");
INSERT INTO rol_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","kag para ipasayod sa mga tawo nga nag-abot na ang tyempo nga luwason sinda ng Ginoo.” ");
INSERT INTO rol_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Pagkatapos mabasa ni Hesus ang gingsulat ni Isaias, ginglukot niya ini kag gingbalik sa opisyal ng sinagoga. Nagpungkò siya para mag-isplikar ng iya gingbasa. Nakatutok gid sa iya ang tanan nga tawo didto sa sinagoga. ");
INSERT INTO rol_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Hambay ni Hesus sa inda, “Ini nga parte ng Kasulatan nga gingbasa ko sa indo hay natuman na mintras ginapamatian nindo.” ");
INSERT INTO rol_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Gingdayaw siya ng tanan nga tawo kag dakò gid ang inda katingaya sa iya hambay nga kaayo-ayo. Pero nagpinangutan-an sinda, “Bukon ba ini ang ungà ni Jose?” ");
INSERT INTO rol_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Naghambay si Hesus sa inda, “Sigurado gid nga sambiton nindo sa akon ang hambayanon, ‘Doktor, buyunga anay ang imo kaugalingon’ nga ang gusto nindo hambayon sa akon, ‘Humanon mo da diri sa aton banwa ang nabatian namon nga imo ginghuman sa Capernaum*.’ ” ");
INSERT INTO rol_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Naghambay pa gid si Hesus, “Sa matuod lang ginahambay ko sa indo: Wayà ning propeta nga ginabaton ng mga tawo sa kaugalingon niya nga banwa. ");
INSERT INTO rol_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Sa matuod lang ginahambay ko sa indo, madamò ang mga bayo nga babayi sa bilog nga Israel nang tyempo ni Propeta Elias. Wayà pagpauyana ng Dios sa suyod ng tuyo ka tuig kag tungà. Kag sobra gid ang taggutom nga naagihan ng mga tawo. ");
INSERT INTO rol_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pero wayà gid pagsugua ng Dios si Elias para buligan ang aber sin-o sa inda, kundì gingpakadto siya sa isa ka bayo nga taga-Zarefat nga sakop ng Sidon. ");
INSERT INTO rol_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kag imaw pa ini ang natabò sa Israel ng tyempo ni Propeta Eliseo. Madamò ang mga tawo nga nagaantos sa sakit nga kitong, pero wayà gid may gingpaayo sa inda. Si Naaman lang nga taga-Syria ang gingpaayo.” ");
INSERT INTO rol_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nang mabatian ini ng mga tawo sa sinagoga, nahangit gid sinda. ");
INSERT INTO rol_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Nagpangtindog sinda kag gingbira si Hesus paluwas ng banwa kag gingdaya didto sa ibabaw ng bukid nga sakop ng inda banwa. Gusto kuntà ninda nga ituyod si Hesus sa pangpang. ");
INSERT INTO rol_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pero nag-agi si Hesus sa tungà ninda kag pumanaw. ");
INSERT INTO rol_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Halin didto, nagtugbong si Hesus sa Capernaum nga sakop ng Galilea. Didto siya permi nagatudlò sa mga Judio sa sinagoga sa Adlaw nga Inugpahuway. ");
INSERT INTO rol_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Natingaya gid ang mga tawo sa iya pagpanudlò kay may otoridad gid siya sa iya ginahambay. ");
INSERT INTO rol_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Didto sa sinagoga igwa ning isa ka tawo nga ginasapian ng demonyo – malain nga espiritu. Nagsinggit siya ning makusog, ");
INSERT INTO rol_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ah! Hesus nga taga-Nazaret, basì ginadisturbo mo kami? Paparusahan mo ba kami? Kilaya ta ikaw. Ikaw ang Balaan nga Ungà ng Dios!” ");
INSERT INTO rol_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Pero gingsabyaw ni Hesus ang demonyo, “Hipos! Luwas dirà!” Adto nga daan gingtumba ng demonyo ang tawo sa atubangan ng tanan kag nagluwas siya nga wayà ini pagsakita. ");
INSERT INTO rol_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Natingaya gid ang mga tawo kag naghambay sinda sa isa kag isa, “Taya! Ano adtong iya gingpanghambay? Kay may otoridad kag gahom ang iya sugò nga nagatuman kag nagalayas ang malain nga mga espiritu!” ");
INSERT INTO rol_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kag ang balità parti kay Hesus nabantog sa tanan nga lugar didto. ");
INSERT INTO rol_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Naghalin si Hesus sa sinagoga kag nagkadto sa bayay ni Simon. Nagkasakit ang iya panugangan nga babayi kay kataas gid ang iya sagnat. Nganì nagpangabay sina Simon kay Hesus nga paayuhon siya. ");
INSERT INTO rol_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Nagpalapit si Hesus kag nagtindog sa alihid ng iya higdaan kag gingsabyaw ang sagnat kag nahuwasan siya. Adto nga daan nagbangon siya kag gingserbisyuhan niya sina Hesus. ");
INSERT INTO rol_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Pagtunod ng adlaw, gingdaya ng mga tawo kay Hesus ang tanan nga may sarisarì nga sakit. Gingtungtong niya ang iya kamot sa kada isa sa inda kag gingpang-ayo sinda tanan. ");
INSERT INTO rol_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Gingpaluwas da niya ang mga demonyo sa madamò nga tawo. Nagasininggit sinda mintras nagaluwas, “Ikaw ang Ungà ng Dios!” Pero gingsabyaw sinda ni Hesus kag wayà niya pagtuguti nga maghambay sinda, kay sayod ninda nga siya ang Kristo. ");
INSERT INTO rol_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Nang aga pa gid, naghalin si Hesus sa adto nga banwa kag nagkadto sa tiway nga lugar. Pero gingsinugid siya ng mga tawo. Nang makità ninda si Hesus, nagpangabay sinda nga indì anay maghalin didto sa inda. ");
INSERT INTO rol_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pero naghambay si Hesus, “Kahinangyan nga magwali ako ng Maayong Balità parti sa gingharian ng Dios sa iban pa nga mga banwa kay imaw inà ang rason kung basì gingpakari niya ako diri.” ");
INSERT INTO rol_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Nganì nagpadayon si Hesus sa pagwali sa mga sinagoga sa bilog nga Judea. ");
INSERT INTO rol_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Isa ka adlaw, nagatindog si Hesus sa alihid ng Dagat ng Genesaret. Nagdinagusò sa iya ang madamò nga tawo kay gusto gid ninda magpamatì ng hambay ng Dios. ");
INSERT INTO rol_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","May nakità si Hesus nga duha ka dyapang* nga yadto sa alihid ng dagat. Wayà ini tawo kay nagawaswas ang mga miyugpangisdà ng inda pukot. ");
INSERT INTO rol_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Nagsakay si Hesus sa isa ka dyapang nga ang tag-iya hay si Simon. Nagpangabay siya kay Simon nga ituyod ning maisot ang dyapang sa dagat. Tapos nagpungkò siya kag nagtudlò sa mga tawo. ");
INSERT INTO rol_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nang matapos na ang iya pagtudlò, naghambay si Hesus kay Simon, “Sakay kamo sa dyapang kag itaktak ang pukot sa madayom para makabuoy kamo.” ");
INSERT INTO rol_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Nagsabat si Simon, “Bilog nga gab-i kami nagpinangisdà pero wayà gid kami may nabuoy! Pero kay ginghambay mo, sige itaktak ko.” ");
INSERT INTO rol_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nganì nagpalawod sinda kag gingtaktak ang pukot. Kag kadamò-damò gid ang inda nabuoy nga isdà hasta nga isutan lang magisì ang pukot. ");
INSERT INTO rol_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nganì gingpaypay ninda ang inda mga kaibahan nga miyugpangisdà nga yadto sa isa pa nga dyapang para buligan sinda. Pag-abot ninda, gingpunò gid ninda ning isdà ang duha ka dyapang hasta nga daw malunod na gid sinda kay sobra kadamò ang isdà. ");
INSERT INTO rol_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Nang makità ini ni Simon Pedro, naghapà siya sa atubangan ni Hesus kag naghambay, “Ginoo, palayò sa akon kay ako hay makasasalà!” ");
INSERT INTO rol_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ginghambay niya ini kay natingaya gid siya kag ang iya mga kaibahan tungod kadamò gid nga isdà ang inda nabuoy. ");
INSERT INTO rol_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Imaw da ang mga kasosyo ni Simon nga sina Santiago* kag Juan nga mga ungà ni Zebedee. Pagkatapos naghambay si Hesus kay Simon, “Ayaw mahadlok. Tunà niyan, bukon na isdà ang imo pangitaon kundì mga tawo para magsunod sa akon.” ");
INSERT INTO rol_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nganì gingguyod ninda ang inda mga dyapang sa alihid ng baybay, gingbayaan ninda ang tanan kag nagnunot sa iya. ");
INSERT INTO rol_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nang yadto si Hesus sa isa ka banwa, may isa ka tawo nga grabi na gid ang kitong*. Nang makità niya si Hesus, naghapà siya kag nagpakitluoy, “Ginoo, kung gusto mo, paayuhon mo ako sa sakit nga kitong.” ");
INSERT INTO rol_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ging-unat ni Hesus ang iya kamot kag ginghawiran siya nga nagahambay, “Gusto ko. Mag-ayo ka!” Adto nga daan naduyà ang iya kitong. ");
INSERT INTO rol_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Pagkatapos gingpaandaman siya ni Hesus, “Ayaw gid magpamalità aber kanin-o, kundì magderitso ka sa parì kag magpasirò sa iya. Maghalad* ka sunò sa gingsugò ni Moises para magpamatuod sa mga tawo nga nalimpyo ka na.” ");
INSERT INTO rol_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pero aber imaw adto ang ginghambay ni Hesus sa adto nga tawo ang balità parti sa iya hay nabantog gihapon hasta sa malayò nga mga lugar. Kag madamò gid nga tawo ang nagkadto didto para magpamatì ng pagpanudlò ni Hesus kag para paayuhon ang inda mga sakit. ");
INSERT INTO rol_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pero permi siya nagakadto sa mga tiway nga lugar para magpangamuyò. ");
INSERT INTO rol_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Isa ka adlaw, mintras nagatudlò si Hesus, may mga Pariseo* kag mga miyugtudlò ng Kasuguan nga nagapungkò malapit sa iya. Halin sinda sa iba-iba nga baryo ng Galilea kag Judea kag patì sa Jerusalem. Yarà kay Hesus ang gahom ng Dios para magpang-ayo ng mga may sakit. ");
INSERT INTO rol_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Niyan, may nag-abot nga mga tawo nga ginabayawan ang isa ka paralisado sa iya banig. Isuyod kuntà ninda siya kag day-on sa atubangan ni Hesus. ");
INSERT INTO rol_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pero wayà gid sinda may maagihan kay kadamò-damò gid ang mga tawo. Nganì nagsakà sinda sa pantay nga bubong ng bayay kag gingbuhos ini. Pagkatapos gingtunton ninda ang paralisado sa tungà ng mga tawo kag sa atubangan ni Hesus. ");
INSERT INTO rol_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nang makità ni Hesus ang inda pagtuo, naghambay siya sa paralisado, “Amigo, gingpatawad na ang imo mga salà.” ");
INSERT INTO rol_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Niyan nagahunahunà sa inda kaugalingon ang mga eskriba kag mga Pariseo, “Sin-o gid ini nga tawo nga kung nagahambay hay daw kapareho gid niya ang Dios? Wayà ning aber sin-o nga makapatawad ng mga salà kundì ang Dios lang!” ");
INSERT INTO rol_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Nasayuran ni Hesus ang inda ginahunahunà, nganì nagpangutana siya sa inda, “Basì nagahunahunà kamo ning tiyad inà? ");
INSERT INTO rol_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Diin ang mas malupos hambayon: ‘Napatawad na ang imo mga salà,’ o ‘Bangon kag pumanaw’? ");
INSERT INTO rol_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Niyan pamatuuran ko sa indo nga ako nga Ungà ng Tawo* hay may otoridad sa kalibutan nga magpatawad ng mga salà.” Tapos naghambay siya sa paralisado, “Ginahambay ko sa imo, bangon, lukuta ang imo banig kag magpaulì na!” ");
INSERT INTO rol_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Adto nga daan, nagtindog siya sa atubangan ninda, ginglukot ang iya banig kag nagpaulì nga nagadayaw sa Dios. ");
INSERT INTO rol_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Natingaya gid ang tanan nga tawo didto. Gingdayaw ninda ang Dios nga may pagtahod kag naghambay, “Abaw! Makatitingaya gid ang aton nakità arinyan!” ");
INSERT INTO rol_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Pagkatapos adto, naghalin si Hesus didto kag nakità niya ang miyugsukot ning buhis nga ang pangayan hay Levi nga nagapungkò sa ginabayaran ning buhis. Naghambay si Hesus sa iya, “Kari, nunot sa akon.” ");
INSERT INTO rol_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nagtindog si Levi kag gingbayaan niya ang tanan kag nagsunod kay Hesus. ");
INSERT INTO rol_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Niyan nagpreparar si Levi ning papunsyon para kay Hesus sa iya bayay. Kadamò nga miyugsukot ning buhis kag iban pa nga mga bisita nga nagkaon kaibahan ninda. ");
INSERT INTO rol_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Nang makità ini ng mga Pariseo kag ng inda kaibahan nga mga eskriba, nagreklamo sinda sa mga disipulo ni Hesus, “Basì nagakaon kag nagainom kamo kaibahan ang mga miyugsukot ning buhis kag mga makasasalà?” ");
INSERT INTO rol_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Nagsabat si Hesus sa inda, “Wayà nagakahinangyan ning doktor ang mga tawo nga maayo ang lawas, kundì ang mga may sakit lang. ");
INSERT INTO rol_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Wayà ako nagkari diri para tawagon ang mga tawo nga nagahunahunà nga sinda hay matarong, kundì ang mga makasasalà agud magtalikod sinda sa inda mga salà.” ");
INSERT INTO rol_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","May mga tawo didto nga naghambay kay Hesus, “Ang mga disipulo ni Juan nga Miyugbawtismo hay permi nagapuasa kag nagapangamuyò kag imaw da ang mga disipulo ng mga Pariseo. Pero ang imo mga disipulo hay permi nagakinaon kag nagaininom.” ");
INSERT INTO rol_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Nagsabat si Hesus, “Puydi ba arà nga indì pagpakaunon ang mga bisita sa kasay* mintras kaibahan pa ninda ang kyasayon nga lyaki? Syempre indì! ");
INSERT INTO rol_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pero magaabot ang adlaw nga buy-on ang kyasayon nga lyaki sa inda kag imaw na inà ang mga adlaw ng inda pagpuasa.” ");
INSERT INTO rol_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Gingtudluan pa gid sinda ni Hesus paagi sa mga parabola*, “Wayà ning tawo nga nagagunting ning bag-o nga barò para ihakyop sa lumà. Kay kung humanon niya ini, kanugon kay magigisì ang bag-o kag isa pa, indì mag-angay ang bag-o sa lumà. ");
INSERT INTO rol_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Wayà da ning tawo nga nagabutang ning bag-o nga ilimnon sa lumà nga butangan nga panit kay malupok ang butangan kag mauuyak ang ilimnon kag masisirà ang butangan. ");
INSERT INTO rol_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Pero ang bag-o nga ilimnon dapat ibutang sa bag-o nga butangan.” ");
INSERT INTO rol_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Hambay pa ni Hesus, “Wayà ning tawo nga nagainom ning kadugay na nga ilimnon, tapos nagapangità ning bag-o.” Kay hambay niya, “Mas manamit gid ang kadugay na.” ");
INSERT INTO rol_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Isa ka Adlaw nga Inugpahuway, mintras nagaagi sina Hesus sa uma ng trigo, nagpinamuksì ang iya mga disipulo ning mga uhay ng trigo kag ginakiskis ninda ini kag ginakaon. ");
INSERT INTO rol_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Pero may mga Pariseo didto nga naghambay sa inda, “Basì ginahuman nindo ang ginabawal ng Kasuguan sa Adlaw nga Inugpahuway?” ");
INSERT INTO rol_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Nagsabat si Hesus sa inda, “Wayà ba nindo nabasahi sa Kasulatan ang ginghuman ni David nang siya kag ang iya mga kaibahan hay nagutom? ");
INSERT INTO rol_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Nagsuyod siya sa tolda ng Dios kag gingbuoy niya ang tinapay nga ginghalad kag gingkaon. Gingtaw-an da niya ang iya mga kaibahan. Pero wayà sinda nakasalà aber pa nga ginabawal ini ng Kasuguan kay ang mga parì lang adto ang puydi magkaon.” ");
INSERT INTO rol_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Naghambay pa si Hesus sa inda, “Ako nga Ungà ng Tawo hay may otoridad maghambay kung ano ang puydi nga humanon sa Adlaw nga Inugpahuway.” ");
INSERT INTO rol_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Isa pa ka Adlaw nga Inugpahuway, nagsuyod si Hesus sa sinagoga para magtudlò. May tawo didto nga paralisado ang iya tuo nga kamot. ");
INSERT INTO rol_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Yadto da didto ang mga eskriba kag mga Pariseo. Nagapangità sinda ning paagi kung pauno iakusar si Hesus. Nganì ginabantayan ninda kung paayuhon niya adto nga tawo sa Adlaw nga Inugpahuway. ");
INSERT INTO rol_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pero sayod ni Hesus kung ano ang inda ginahunahunà. Nganì naghambay siya sa tawo nga paralisado ang kamot, “Magtindog ka kag magpalapit diri sa atubangan.” Nganì nagtindog siya kag nagkadto didto. ");
INSERT INTO rol_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Pagkatapos, naghambay si Hesus sa inda, “May pangutana ako sa indo. Ano ang ginatugot ng Kasuguan sa Adlaw nga Inugpahuway: ang paghuman ning maayo o ang paghuman ning malain? Ang pagluwas ng kabuhì o ang pagpatay?” ");
INSERT INTO rol_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Gingsirò sinda tanan ni Hesus. Pagkatapos naghambay siya sa tawo nga paralisado ang kamot, “Unata ang imo kamot.” Ging-unat niya ang iya kamot kag nag-ayo gid ini. ");
INSERT INTO rol_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pero sobra gid ang kahangit ng mga eskriba kag ng mga Pariseo, nganì nag-inistoryahan sinda kung ano ang humanon ninda kay Hesus. ");
INSERT INTO rol_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Nang adto nga tyempo, nagtukad si Hesus sa isa nga bukid para magpangamuyò. Kag nagpangamuyò siya didto ning bilog nga gab-i. ");
INSERT INTO rol_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Pagkaaga, gingtawag niya ang iya mga disipulo kag nagpilì siya ning dose sa inda kag gingtawag nga mga apostoles. ");
INSERT INTO rol_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ang inda mga pangayan hay si Simon (nga gingpangayanan da niya nga Pedro) kag ang iya hali nga si Andres; si Santiago kag si Juan, si Felipe kag si Bartolome, ");
INSERT INTO rol_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","si Mateo kag si Tomas, si Santiago nga ungà ni Alfeus, si Simon nga dati hay nagrebelde sa gobyerno ng Roma, ");
INSERT INTO rol_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","si Judas nga ungà ni Santiago kag si Judas Iscariote nga imaw ang nagtraidor kay Hesus. ");
INSERT INTO rol_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Pagkatapos nagtugbong si Hesus kaibahan ang iya mga apostoles hasta sa nakaabot sinda sa malapad nga kapatagan. Didto nagtipon ang madamò niya nga disipulo kag ang kadamò-damò nga tawo halin sa tanan nga lugar ng Judea kag sa Jerusalem. Igwa da ning halin sa mga syudad ng Tyre kag Sidon nga malapit sa dagat. ");
INSERT INTO rol_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Nagkadto sinda didto para magpamatì kay Hesus kag para ayuhon ang inda mga sakit. Ang iban nga ginapahugaan ng malain nga mga espiritu hay gingpaayo da niya. ");
INSERT INTO rol_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kag ang tanan nga tawo didto nagatinguhà gid nga makatandog sa iya kay may gahom nga yarà sa iya nga nagaayo sa inda tanan. ");
INSERT INTO rol_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Nagsirò si Hesus sa iya mga disipulo kag naghambay, “Bulahan kamo nga mga pobre; kay nagapasakop kamo sa paghaharì ng Dios. ");
INSERT INTO rol_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Bulahan kamo nga ginagutom niyan; kay taw-an kamo ng Dios ng tanan nga indo ginakahinangyan. Bulahan kamo nga nagatangis niyan; kay magahayakhak kamo! ");
INSERT INTO rol_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Bulahan kamo kung hangitan kamo ng mga tawo, sikwayon, insultuhon kag siraon ninda ang indo pangayan, tungod sa indo pagsunod sa akon nga Ungà ng Tawo! ");
INSERT INTO rol_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Kay imaw da inà ang ginghuman ng inda kalulo-lulohan sa mga propeta nang una. Nganì magkalipay kamo kag maglukso sa tudo nga kalipay kay mababaton nindo ang kadakò gid nga premyo sa langit. ");
INSERT INTO rol_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Pero makaluluoy gid kamo nga manggaranon niyan; kay nakatilaw na kamo ng maayo nga pagpangabuhì! ");
INSERT INTO rol_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Makaluluoy da kamo nga busog na niyan; kay magaabot ang adlaw nga magugutom kamo! Makaluluoy da kamo nga nagahayakhak niyan; kay magaabot ang adlaw nga magakalisod kag magadanguyngoy kamo! ");
INSERT INTO rol_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Makaluluoy da kamo kung ginadayaw kamo ng tanan nga tawo, kay imaw da inà ang ginghuman ng inda kalulo-lulohan sa mga bukon matuod nga propeta nang una!” ");
INSERT INTO rol_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Pero ginahambay ko sa indo nga nagapamatì sa akon, higugmaa nindo ang indo kaaway kag humani ning maayo ang nagadumot sa indo. ");
INSERT INTO rol_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Pakamaayuha ang nagasumpà sa indo kag ipangamuyò nindo ang nagamaltrato sa indo. ");
INSERT INTO rol_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kung tampaon ka sa pisngi, ipatampà mo pa ang kabuak. Kag kung may magbuoy ng imo barò nga pangsuy-ob, ayaw magpunggi kung buy-on patì ang imo kamisita. ");
INSERT INTO rol_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Taw-i ang tanan nga nagapangayò sa imo kag kung may magbuoy ng imo mga pagkabutang, ayaw na magbawia. ");
INSERT INTO rol_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Humana nindo sa indo isigkatawo kung ano ang gusto nindo nga humanon ninda sa indo. ");
INSERT INTO rol_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Kung ang ginahigugmà lang nindo hay ang nagahigugmà sa indo, mababaton ba nindo ang kaayuhan halin sa Dios? Indì! Kay aber ang mga makasasalà ginahigugmà da ninda ang nagahigugmà sa inda. ");
INSERT INTO rol_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kag kung ang indo ginapakitaan ning maayo hay ang nagahuman lang ning maayo sa indo, may kaayuhan ba kamo nga mababaton halin sa Dios? Wayà! Kay aber ang makasasalà imaw da ang inda ginahuman. ");
INSERT INTO rol_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kag kung ang ginapahuyam lang nindo hay ang sayod nindo nga imaw lang makakabayad, may kaayuhan ba kamo nga mababaton halin sa Dios? Wayà! Kay aber ang makasasalà nagapahuyam da sa inda isigkapareho kay sayod ninda nga bayaran gid sinda ng inda gingpahuyam. ");
INSERT INTO rol_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Imaw ini ang indo dapat humanon: higugmaa nindo ang indo kaaway kag humani sinda ning maayo. Kung magpahuyam kamo, pahuyamon nindo kag indì na maglaom nga bayaran pa. Kay kung humanon nindo ini, dakò gid ang premyo nga mababaton nindo kag magiging mga ungà kamo ng Pinakamataas nga Dios. Kay maayo gid ang Dios kag naluluoy siya aber sa mga tawo nga malain kag indì antigo magpasalamat sa iya. ");
INSERT INTO rol_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nganì maging maluluy-on kamo kay maluluy-on da ang indo Amay.” ");
INSERT INTO rol_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Nganì ayaw nindo paghusgahi ang iban para indì da kamo paghusgahan ng Dios. Ayaw kamo maghambay nga dapat sinda parusahan para indì da kamo pagparusahan ng Dios. Patawara nindo ang nakasalà sa indo para patawaron da kamo ng Dios. ");
INSERT INTO rol_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Maging maatag kamo para maatag da ang Dios sa indo. Kung nagatao ang Dios sa indo, ginasukoy gid niya ini ning maayo, ginadasok, ginayugoyugò kag nagapang-aawas pa. Kay ang pangsukoy nga ginggamit nindo sa iban imaw da ang pangsukoy nga gagamiton sa indo.” ");
INSERT INTO rol_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Pagkatapos adto, gingtudluan sinda ni Hesus paagi sa ini nga parabola: “Indì puydi mag-agbay ang buta sa buta kay pareho sinda nga mahuhuyog sa buhò. ");
INSERT INTO rol_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Wayà ning disipulo nga mas labaw pa sa iya maestro, pero kung natun-an na niya ang tanan, magiging pareho na siya ng iya maestro. ");
INSERT INTO rol_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Basì nakikità mo gid ang puling sa mata ng imo isigkatawo, pero ikaw wayà mo makità ang daw mabahoy nga kahoy nga yarà sa imo mata? ");
INSERT INTO rol_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Pauno ka makahambay, ‘Abi, buy-on ko ang puling sa imo mata,’ pero ang yarà sa imo mata hay daw mabahoy nga kahoy nga wayà mo makità? Hipokrito! Buy-a anay ang daw mabahoy nga kahoy sa imo mata para makakità ka maayo, agud mabuoy mo ang puling sa mata ng imo isigkatawo.” ");
INSERT INTO rol_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Ang maayo nga kahoy indì makapamunga ng malain kag ang malain nga kahoy indì makapamunga ng maayo. ");
INSERT INTO rol_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Makikilaya ang kada kahoy sa iya bunga. Ang tanom nga tunukon, wayà nagapamunga ng igos* o ubas*. ");
INSERT INTO rol_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Pareho da ini sa tawo; ang maayo nga tawo nagahambay maayo kay maayo ang iya hunahunà. Pero ang malain nga tawo, nagahambay malain kay malain ang iya hunahunà. Kay kung ano ang yarà sa hunahunà ng tawo, imaw da ang nagaluwas sa iya bàbà.” ");
INSERT INTO rol_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Basì ginatawag nindo ako, ‘Ginoo, Ginoo,’ pero wayà nindo ginasunura ang akon ginahambay? ");
INSERT INTO rol_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ipakità ko sa indo kung ano ang kapareho ng tawo nga nagapalapit sa akon, nagapamatì kag nagatuman ng akon mga ginatudlò. ");
INSERT INTO rol_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Pareho siya sa tawo nga bago iugdok ang iya bayay, nagkutkot anay siya ng kadayom kag gingbutang ang pundasyon sa bato, tapos ging-ugdok niya ang bayay didto. Nang nagbahà ang subà kag lumapaw ang tubì, ginghampas ang bayay pero wayà ini nagubà kay ging-ugdok sa matibay nga pundasyon. ");
INSERT INTO rol_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pero ang tawo nga nagapamatì ng akon mga ginatudlò pero wayà nagatuman, pareho siya sa tawo nga nag-ugdok ng iya bayay sa lugar nga wayà pundasyon. Nang ginghampas ng makusog nga bahà ang bayay, natumba ini nga daan kag nawasak gid.” ");
INSERT INTO rol_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Pagkatapos ng pagtudlò ni Hesus sa mga tawo, nagkadto siya sa Capernaum. ");
INSERT INTO rol_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Igwa didto ning kapitan ng mga sundalo ng Roma kag igwa siya ulipon nga palanggà gid niya. Nagmasakit siya kag malapit na mamatay. ");
INSERT INTO rol_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nang mabatian ng kapitan ang parti kay Hesus, gingpakadto niya ang mga miyugdumaya ng Judio kay Hesus para mangabay sa iya nga magkadto sa iya bayay para paayuhon ang iya ulipon. ");
INSERT INTO rol_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Nagkadto sinda kay Hesus kag nagpakitluoy gid sa iya, “Buligi abi ang kapitan kay maayo siya kag dapat gid nga buligan. ");
INSERT INTO rol_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Palanggà gid niya ang mga Judio kag siya ang nagpaugdok ng sinagoga para sa amon.” ");
INSERT INTO rol_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Nganì nagnunot si Hesus sa inda. Nang malapit na sinda sa bayay ng kapitan, gingpakadto niya ang iya mga amigo kag gingpahambay kay Hesus, “Ginoo, ayaw na pagbudlaya ang imo kaugalingon kay bukon ako angay nga magpasuyod sa imo sa akon bayay. ");
INSERT INTO rol_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nganì bukon ako ang nagkarà kay bukon ako angay nga mag-atubang sa imo. Sa imo lang hambay, magaayo ang akon ulipon. ");
INSERT INTO rol_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kay ako hay sakop ng may mataas nga rangko kag igwa da ako mga sundalo nga nasasakupan. Kung nagasugò ako sa isa, ‘Kadto didto,’ nagakadto siya kag sa isa, ‘Kari diri,’ nagapalapit siya kag kung nagasugò ako sa akon ulipon, ‘Humana ini,’ ginahuman niya.” ");
INSERT INTO rol_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nang mabatian ini ni Hesus, natingaya gid siya. Nag-atubang siya sa kadamò nga tawo kag naghambay, “Ginahambay ko sa indo, wayà pa gid ako ning may nakità nga tawo aber diin sa Israel nga igwa pagtuo nga pareho niya!” ");
INSERT INTO rol_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Pagbalik sa bayay ng mga gingsugò ng kapitan, nakità ninda nga nag-ayo na ang ulipon. ");
INSERT INTO rol_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Wayà magdugay nagkadto si Hesus sa banwa nga ginatawag, Nain. Kaibahan niya ang iya mga disipulo kag ang kadamò nga tawo. ");
INSERT INTO rol_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nang pasuyod na sinda sa banwa, nasumpong ninda ang kadamò nga tawo nga nagadapit sa patay nga ginahakwat pakadto sa luwas. Ang patay hay bugtong nga ungà nga lyaki ng bayo. ");
INSERT INTO rol_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Naluoy gid si Hesus sa iya kag naghambay siya, “Ayaw na magtangis.” ");
INSERT INTO rol_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Niyan nagpalapit siya kag gingtandog niya ang ginabutangan ng patay para magduyog ang nagahakwat. Pagduyog ninda, naghambay siya sa patay, “Nonò, bangon na!” ");
INSERT INTO rol_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nagbangon ang patay, nagpungkò kag naghambay. Tapos gingdaya siya ni Hesus sa iya nanay. ");
INSERT INTO rol_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ang tanan nga yadto hay natingaya gid kag gingdayaw ninda ang Dios. Naghambay sinda, “Yari na sa aton ang makagagahom nga propeta!” Naghambay pa ang iban, “Nagkari ang Dios para luwason kita sa aton kasal-anan!” ");
INSERT INTO rol_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ang balità parti sa ginghuman ni Hesus naglapnag sa bilog nga Judea kag sa tanan nga lugar sa palibot. ");
INSERT INTO rol_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Gingbalità kay Juan nga Miyugbawtismo ini tanan nga natabò ng iya mga disipulo. ");
INSERT INTO rol_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Nganì gingtawag niya ang duha sa iya mga disipulo kag gingpakadto sa Ginoo. Gingpapangutana niya sinda, “Ikaw ba ang ginahambay ni Juan nga gingpromisa ng Dios nga magaabot o mahuyat pa kami ng iban?” ");
INSERT INTO rol_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nganì nagkadto ang duha niya nga disipulo kay Hesus kag naghambay, “Gingpadaya kami ni Juan nga Miyugbawtismo sa imo para magpangutana. Ikaw ba ang ginghambay niya nga gingpromisa ng Dios nga magaabot o mahuyat pa kami ng iban?” ");
INSERT INTO rol_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Adto gid nga oras, ginapang-ayo ni Hesus ang kadamò nga tawo nga may iba-iba nga sakit kag ginasapian ng malain nga mga espiritu kag kadamò da nga buta ang nakakità na. ");
INSERT INTO rol_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Nagsabat si Hesus sa mga disipulo ni Juan, “Magbalik kamo kay Juan kag ihambay sa iya ang indo nakità kag nabatian diri: ang mga buta nakakità, ang mga pakì nakapanaw ning maayo, ang mga kitungon* nag-ayo, ang mga bungoy nakabatì, ang mga patay nabuhì kag ang Maayong Balità ginapanudlò sa mga pobre. ");
INSERT INTO rol_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ihambay pa nindo sa iya, ‘Bulahan ang mga tawo nga wayà nagaduha-duha parti sa akon.’ ” ");
INSERT INTO rol_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Nang maghalin na adtong duha nga disipulo ni Juan, nagtunà si Hesus sa pag-istorya parti kay Juan sa kadamò nga tawo didto. Hambay niya, “Nang nagpamatì kamo sa pagtudlò ni Juan nang yadto pa siya sa tiway nga lugar, ano ang indo ginapaabot nga makità? Ang tawo nga nagapangduha-duha nga pareho ng kugon nga ginahuyop-huyop ng hangin? ");
INSERT INTO rol_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ano kuntà ang gusto nindo makità? Ang tawo nga mamahayon ang barò? Syempre bukon! Kay ang tawo nga nagasuksok ng tiyad adto hay manggaranon kag nagaistar sa palasyo. ");
INSERT INTO rol_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Abi, isipa nindo, basì nagkadto kamo didto? Dì ba para makità ang propeta? Huo, pero sa matuod lang mas sobra pa gid siya kaysa sa propeta. ");
INSERT INTO rol_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Kay si Juan, imaw ang ginghambay ng Dios sa Kasulatan, ‘Ipapadaya ko ang akon mensahero nga mauna sa imo para magpreparar ng dayan bago ang imo pag-abot.’ ");
INSERT INTO rol_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ginahambay ko sa indo, wayà ning aber sin-o nga natawo sa kalibutan nga mas labaw pa kay Juan. Pero ang tawo nga pinakamababà sa gingharian ng Dios hay mas labaw pa kaysa kay Juan.” ");
INSERT INTO rol_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ang tanan nga tawo nga nagpamatì kag ang mga miyugsukot ning buhis hay nagkumpormi nga tamà ang tanan nga ginapahuman ng Dios kay nagpabawtismo na sinda kay Juan. ");
INSERT INTO rol_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pero ang mga Pariseo kag ang mga miyugtudlò ng Kasuguan naman hay wayà nagkumpormi sa kabubut-on ng Dios para sa inda kay indì gid sinda magpabawtismo kay Juan. ");
INSERT INTO rol_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Tapos naghambay pa gid si Hesus, “Sa diin ko baya ikumpara ang mga tawo sa ini nga henerasyon? Ano baya ang kapareho ninda? ");
INSERT INTO rol_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Pareho sinda sa mga ungà nga nagapungkò sa plasa kag nagahambay sa isa kag isa, ‘Nagpasunata kami para sa kasay pero wayà kamo nagsaot; nagkanta kami para sa patay pero wayà kamo nagtangis.’ ");
INSERT INTO rol_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Pareho da kamo sa inda, kay nang mag-abot si Juan nakità nindo nga nagapuasa siya kag wayà nagainom ilimnon, nganì nagahambay kamo, ‘Hala, ginasapian siya ng demonyo!’ ");
INSERT INTO rol_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ako naman nga Ungà ng Tawo, nakità nindo nga nagakaon kag nagainom nganì nagahambay kamo, ‘Hala, sirua ang tawo nga ini! Makagod kag buratso, amigo ng mga miyugsukot buhis kag iban pa nga makasasalà.’ ");
INSERT INTO rol_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pero pabay-i lang, ang kabubut-on ng Dios hay ginapamatuuran sa kabuhì ng tawo nga nagabaton sa iya ginapanudlò paagi sa amon.” ");
INSERT INTO rol_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Isa ka adlaw, may isa ka Pariseo nga nag-agda kay Hesus nga magkaon sa iya bayay. Nganì nagkadto siya kag nagkaon kaibahan ng mga imbitado. ");
INSERT INTO rol_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Sa adto nga banwa, igwa babayi nga makasasalà. Nabatian niya nga yadto si Hesus nagakaon sa bayay ng Pariseo, nganì nagkadto siya didto daya ang maisot nga tibod nga himò sa alabastro*, nga may suyod nga pahumot. ");
INSERT INTO rol_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Nagpalapit siya sa likod ni Hesus kag nagtindog sa may sikwayan niya kag nagtinangis. Nagtuyò ang iya luhà sa siki ni Hesus kag gingpunasan niya ini ng iya buhok. Pagkatapos gingharuan niya kag gingbubuan ng pahumot. ");
INSERT INTO rol_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nang makità ini ng Pariseo nga nag-agda kay Hesus, naghambay siya sa iya kaugalingon, “Kung matuod nga propeta ang tawo nga ini, dapat sayod niya kung sin-o ining babayi nga nagapunas sa iya siki; dapat sayod niya nga makasasalà siya!” ");
INSERT INTO rol_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Pero nasayuran ni Hesus kung ano ang iya ginahunahunà nganì naghambay siya, “Simon, igwa ako ihambay sa imo.” Sabat niya, “Ano inà, Maestro?” ");
INSERT INTO rol_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Naghambay si Hesus, “Igwa duha ka tawo nga nag-utang sa miyugpautang. Ang isa nag-utang lima ka gatos nga denarius kag ang isa 50. ");
INSERT INTO rol_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pero tungod indì sinda makabayad wayà sinda pagpabayara ng inda utang. Sin-o sa inda nga duha ang mas kadakò ang paghigugmà sa miyugpautang?” ");
INSERT INTO rol_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Nagsabat si Simon, “Siguro adtong mas kadakò ang utang.” Naghambay si Hesus, “Tamà ang imo sabat.” ");
INSERT INTO rol_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Niyan nag-atubang siya sa babayi kag naghambay kay Simon, “Sirua ining babayi, ging-agda mo ako sa imo bayay; pero wayà mo ako gingtaw-i tubì para makapanghugas ng akon siki. Pero siya, ginghugasan niya ang akon siki ng iya luhà kag gingpunasan ng iya buhok. ");
INSERT INTO rol_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Wayà mo ako pagharui pag-abot ko diri, pero siya, wayà nagpara sa kahaharò ng akon siki tunà ng pag-abot ko. ");
INSERT INTO rol_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Wayà mo pagpahiri lana ang akon uyo, pero gingbubuan niya pahumot ang akon siki. ");
INSERT INTO rol_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nganì ginahambay ko sa imo nga ang kadakò nga paghigugmà nga gingpakità niya nagapamatuod nga gingpatawad na siya ng iya madamò nga kasal-anan. Pero ang tawo nga maisot lang ang gingpatawad nga salà, maisot lang ang paghigugmà nga iya ipakità.” ");
INSERT INTO rol_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Pagkatapos naghambay si Hesus sa babayi, “Gingpatawad na ang imo mga salà.” ");
INSERT INTO rol_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ang iban nga nagakaon katupad ni Hesus naghambay sa inda kaugalingon, “Sin-o baya ini nga tawo nga aber ang mga salà ginapatawad niya?” ");
INSERT INTO rol_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Pero naghambay si Hesus sa babayi, “Ang pagtuo mo ang nagluwas sa imo. Magpaulì ka nga matawhay ang imo isip.” ");
INSERT INTO rol_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Pagkatapos adto, naglibot si Hesus sa mga banwa kag mga baryo nga nagatudlò ng Maayong Balità parti sa paghaharì ng Dios. Kaibahan da niya ang iya dose nga disipulo, ");
INSERT INTO rol_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","kag ang mga babayi nga gingpaluwasan niya ng malain nga mga espiritu kag gingpaayo sa iba-iba nga sakit. Ang isa sa inda hay si Maria nga taga-Magdala nga pito gid nga demonyo ang gingpaluwas sa iya. ");
INSERT INTO rol_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ang iban pa nga babayi nga nagsunod sa iya hay si Juana nga asawa ni Cuza nga opisyal sa palasyo ni Herodes, si Susana kag madamò pa gid nga babayi nga imaw sinda ang nagatao ng mga kahinangyanon ni Hesus kag ng iya mga disipulo halin sa inda gingpangabudlayan. ");
INSERT INTO rol_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kadamò nga tawo ang nagpangkadto kay Hesus halin sa iba-iba nga banwa kag nang nagtipon na sinda, nagtudlò siya paagi sa parabola: ");
INSERT INTO rol_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“May isa ka mangunguma nga nagkadto sa iya uma para magsabwag ning binhì. Sa iya pagsabwag, ang iban nagtupà sa alihid ng dayan kag natimakan ng mga nagaagi kag gingpantukà ng mga pispis. ");
INSERT INTO rol_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ang iban nga binhì nagtupà sa kabatuhan. Nagtubò ini pero naglayong kay uga ang dutà. ");
INSERT INTO rol_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ang iban nagtupà kag nagtubò sa dutà nga may mga bayagon nga tunukon, pero paglabog ng mga bayagon gingkamangan ang tanom, nganì wayà nakapamunga. ");
INSERT INTO rol_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ang iban nga binhì nagtupà sa maayo nga dutà, nagtubò kag nagpamunga gid ng kadamò-damò.” Pagkatapos mag-istorya ni Hesus, naghambay siya, “Dapat intindihon gid nindo maayo ang indo nababatian.” ");
INSERT INTO rol_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Gingpangutana ng iya mga disipulo si Hesus kung ano ang gusto hambayon ng adto nga parabola. ");
INSERT INTO rol_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Nagsabat siya, “Sa indo lang gingtao ng Dios ang pang-intindi ng mga sikreto parti sa iya paghaharì, pero sa iban, ginahambay niya ini paagi sa mga parabola, agud magsirò man sinda, indì makakità; kag magpamatì, pero indì makaintindi.” ");
INSERT INTO rol_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Imaw ini ang gusto hambayon ng parabola: Ang binhì, imaw ang hambay ng Dios. ");
INSERT INTO rol_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ang alihid ng dayan nga gingtupaan ng binhì imaw ang mga tawo nga nakabatì ng hambay ng Dios, pero nag-abot ang diyablo kag gingbuoy niya ini sa inda tagipusuon para indì sinda magtuo kag maluwas. ");
INSERT INTO rol_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ang kabatuhan nga gingtupaan ng binhì, imaw ang mga tawo nga pagkabatì sa hambay ng Dios gingbaton ini nga may kalipay. Pero bukon hugot sa inda tagipusuon, nganì wayà magdugay ang inda pagtuo. Pag-abot ng pagtilaw, wayà sinda nagpadayon sa inda pagtuo. ");
INSERT INTO rol_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ang dutà nga may mga bayagon nga tunukon nga gingtupaan ng binhì, imaw ang mga tawo nga nakabatì sa hambay ng Dios. Pero nadaog sinda ng mga kabayak-on, pagtinguhà nga magmanggaranon kag pagpangalipay sa kalibutan, nganì wayà ini nakapamunga sa inda kabuhì. ");
INSERT INTO rol_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pero ang maayo nga dutà nga gingtupaan ng binhì, imaw ang mga tawo nga nagpamatì ng hambay ng Dios kag gingtagò ini sa inda maayo nga tagipusuon. Ginatuman ninda ini nga may pag-antos hasta magpamunga sa inda kabuhì.” ");
INSERT INTO rol_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Naghambay pa gid si Hesus, “Wayà ning tawo nga nagasugà ning iwagan kag ginatakyuban ning kuyon o ginabutang sa idayom ng katri, kundì ginabutang ini sa tungtungan para mahayagan ang mga tawo nga nagasuyod sa bayay. ");
INSERT INTO rol_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Nganì wayà gid ning may ginatagò nga indì makikità sa ulihi kag wayà ning sikreto nga indì masasayuran kag indì makikità. ");
INSERT INTO rol_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Nganì pamatì kamo maayo sa akon ginahambay, kay ang tawo nga igwa nabaton nga kamatuuran, taw-an pa gid ng pang-intindi. Pero ang tawo nga wayà ning nabaton nga kamatuuran, aber ang ginaisip niya nga iya naintindihan hay buy-on pa sa iya.” ");
INSERT INTO rol_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Niyan, nag-abot ang nanay kag mga manghod nga lyaki ni Hesus, pero indì sinda makapalapit kay kadamò ang tawo nga nagatipon didto. ");
INSERT INTO rol_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","May naghambay sa iya, “Yarà sa luwas ang imo nanay kag mga manghod. Gusto ninda magpakigkità sa imo.” ");
INSERT INTO rol_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Pero nagsabat si Hesus sa mga tawo, “Ang akon nanay kag mga manghod hay ang nagapamatì kag nagatuman sa hambay ng Dios.” ");
INSERT INTO rol_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Isa ka adlaw, nagsakay si Hesus sa dyapang kaibahan ang iya mga disipulo. Hambay niya sa inda, “Mos, matabok kita sa kabuak.” Nganì nagsakay sinda sa dyapang. ");
INSERT INTO rol_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Mintras nagabyahe sinda, natuyugan si Hesus. Gulpi na lang nga nagkusog ang hangin sa lawod kag nagsuyod ang tubì sa dyapang, nganì sinda hay nabutang sa peligro. ");
INSERT INTO rol_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Gingpalapitan ng mga disipulo si Hesus kag gingpukaw, “Ginoo, Ginoo! Malulunod na kita!” Nagbangon si Hesus kag gingsabyaw ang hangin kag kadagkò nga humbak. Adto nga daan nagkalma ang bagyo. ");
INSERT INTO rol_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Pagkatapos naghambay si Hesus sa inda, “Diin ang indo pagtuo sa akon?” Pero natingaya gid sinda kag hinadlukan. Nagpinangutan-an sinda, “Sin-o gid baya ini nga tawo? Ginasugò niya ang hangin kag ang humbak; kag nagatuman ini sa iya!” ");
INSERT INTO rol_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Niyan, nag-abot sina Hesus sa lugar ng mga Geraseno nga nagaatubang sa Galilea. ");
INSERT INTO rol_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Nang makasalta na siya halin sa dyapang, gingsumpong siya ng isa ka tawo nga taga-Geraseno nga ginasapian ning mga demonyo. Kadugay na gid nga wayà siya nagasuksok ning barò kag wayà nagabalik sa iya bayay, kundì nagaistar siya sa mga lubungan. ");
INSERT INTO rol_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Nang makità niya si Hesus nagsinggit siya, nagluhod kag naghapà sa iya atubangan. Kag naghambay siya ning makusog, “Hesus, Ungà ng Pinakamataas nga Dios, ano ang imo labot sa akon? Nagapakitluoy ako sa imo, ayaw ako pagpahugai!” ");
INSERT INTO rol_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ginghambay niya ini kay gingsugò ni Hesus nga magluwas ang malain nga espiritu sa iya. (Kadugay na siya nga ginasapian ng malain nga espiritu. Aber siya ginabantayan kag ginakadinahan ang iya kamot kag siki, ginapangbugtò niya ini kag ginadaya siya ng demonyo sa tiway nga lugar.) ");
INSERT INTO rol_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Gingpangutana siya ni Hesus, “Ano ang imo pangayan?” Nagsabat siya, “Batalyon!” Kay kadamò-damò ang mga demonyo nga nagsapì sa iya. ");
INSERT INTO rol_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nagpakitluoy ang mga demonyo nga indì sinda ipadaya ni Hesus sa pinakaidayom nga lugar ng kalibutan. ");
INSERT INTO rol_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Malapit didto, may nagapangibok nga kadamò-damò nga baboy sa alihid ng bakuyod. Nagpakitluoy ang mga demonyo kay Hesus nga didto na lang sinda masuyod sa mga baboy kag gingtugutan niya sinda. ");
INSERT INTO rol_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Nganì nagpangluwas ang mga demonyo sa tawo kag nagpangsuyod sa mga baboy. Pagkatapos nagdinagusò ang mga baboy sa pangpang hasta sa nagkahuyog sa dagat kag nagkalumos. ");
INSERT INTO rol_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nang makità ng mga miyug-alilà ng baboy ang natabò, nagdinyagan sinda kag gingpinamalità ini sa mga tawo sa banwa kag sa mga baryo. ");
INSERT INTO rol_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nganì nagkadto ang mga tawo kay Hesus kay gusto ninda makità ang natabò. Pag-abot didto, nakità ninda ang tawo nga dati gingsapian ng mga demonyo. Nagapungkò siya sa atubangan ni Hesus nga nakabarò kag maayo na ang iya isip. Nganì hinadlukan gid sinda. ");
INSERT INTO rol_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Gingbalità ng mga nakakità ang natabò kung pauno nag-ayo ang tawo. ");
INSERT INTO rol_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Pagkatapos ang tanan nga nagaistar sa lugar ng Geraseno nagpakitluoy kay Hesus nga maghalin sa inda lugar kay dakò gid ang inda kahadlok. Nganì nagsakay si Hesus sa dyapang kag nagbalik sa iya ginghalinan. ");
INSERT INTO rol_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Nagpakitluoy kay Hesus ang tawo nga gingpaluwasan niya ng mga demonyo nga magnunot sa iya. Pero nagsabat si Hesus, ");
INSERT INTO rol_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Mas maayo kung magpaulì ka sa indo kag ipamalità ang ginghuman ng Dios sa imo.” Nganì nagbalik ang tawo kag naglibot siya sa bilog nga banwa kag gingpinamalità ang parti sa ginghuman ni Hesus sa iya. ");
INSERT INTO rol_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nang makatabok na sina Hesus sa kabuak, gingsugat siya ng mga tawo kay tanan sinda hay nagahuyat sa iya. ");
INSERT INTO rol_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Wayà madugay, nag-abot ang tawo nga ang pangayan hay Jairus. Siya hay opisyal ng sinagoga. Naghapà siya sa atubangan ni Hesus kag nagpakitluoy nga magkadto siya sa iya bayay, ");
INSERT INTO rol_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kay nagaagunisar na ang iya bugtong nga ungà nga babayi, nga dose ka años. Mintras nagapakadto si Hesus sa bayay ni Jairus, nagadinagusò ang kadamò nga tawo sa iya. ");
INSERT INTO rol_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Isa sa inda hay ang babayi nga ginadugò sa suyod ng dose ka tuig. Naubos na ang tanan niya nga manggad sa pagpabuyong, pero wayà gid siya nag-ayo. ");
INSERT INTO rol_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nagpalapit siya sa likod ni Hesus kag gingtandog ang gayad ng iya barò. Adto nga daan nagpara ang pagdugò. ");
INSERT INTO rol_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Pagkatapos nagpangutana si Hesus, “Sin-o ang nagtandog sa akon?” Nang wayà may nag-akò, naghambay si Pedro, “Ginoo, kadamò ang mga tawo nga nagapalibot kag nagadinagusò sa imo.” ");
INSERT INTO rol_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pero naghambay si Hesus, “May nagtandog gid sa akon kay nabatyagan ko nga may gahom nga nagluwas sa akon.” ");
INSERT INTO rol_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nang masayuran ng babayi nga indì niya maitagò ang iya ginghuman, nagpalapit siya kay Hesus nga nagapangurog kag naghapà sa iya atubangan. Nagbalità siya nga nababatian ng tanan kung basì gingtandog niya ang barò ni Hesus kag kung pauno siya nag-ayo nga daan sa iya sakit. ");
INSERT INTO rol_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Pagkatapos naghambay si Hesus sa iya, “Manang, nag-ayo ka tungod sa imo pagtuo. Magpaulì ka nga matawhay ang imo isip.” ");
INSERT INTO rol_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Mintras nagahambay pa si Hesus, may nag-abot nga tawo halin sa bayay ni Jairus kag naghambay sa iya, “Wayà na ang imo ungà, ayaw na pag-isturbuha ang maestro.” ");
INSERT INTO rol_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pero nabatian ini ni Hesus kag naghambay siya kay Jairus, “Ayaw mahadlok. Magtuo ka lang kag magaayo siya.” ");
INSERT INTO rol_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Pag-abot ninda sa bayay, wayà nagtugot si Hesus nga magnunot sa iya pasuyod ang aber sin-o, puyra lang kana Pedro, Juan, Santiago kag ang mga ginikanan ng ungà. ");
INSERT INTO rol_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nagatinangis kag nagadinanguyngoy didto ang tanan nga tawo. Pero naghambay si Hesus sa inda, “Ayaw kamo magtinangis. Bukon patay ang ungà, nagakatuyog lang siya.” ");
INSERT INTO rol_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Gingnginitlan ninda tanan si Hesus kay sayod ninda nga patay na ang ungà. ");
INSERT INTO rol_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Pero ginghawiran niya ang kamot ng ungà kag gingtawag, “Nenè, magbangon ka!” ");
INSERT INTO rol_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Adto da nga oras nagbalik ang iya espiritu kag nagbangon siya nga daan. Nagsugò si Hesus nga pakaunon ang ungà. ");
INSERT INTO rol_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Natingaya gid ang iya mga ginikanan, pero nagbilin si Hesus sa inda nga indì gid magpamalità aber kanin-o kung ano ang natabò. ");
INSERT INTO rol_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Isa ka adlaw, gingtawag ni Hesus ang dose nga apostoles kag gingtaw-an niya sinda ning gahom kag otoridad nga magpalayas ng tanan nga demonyo kag magpang-ayo ng mga may sakit. ");
INSERT INTO rol_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Tapos gingsugò niya sinda sa iba-iba nga lugar para magtudlò parti sa paghaharì ng Dios kag magpang-ayo ng mga may sakit. ");
INSERT INTO rol_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Bago sinda naghalin, gingbilinan sinda ni Hesus, “Ayaw kamo magdaya ning aber ano sa indo pagpanaw; aber sungkod, bag, pagkaon, kwarta o ilislan. ");
INSERT INTO rol_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kag kung diin nga bayay kamo magdayon, didto lang gid kamo mag-istar hasta nga maghalin kamo sa adto nga banwa. ");
INSERT INTO rol_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Pero kung indì magbaton sa indo ang mga tawo sa isa ka lugar, bayai nindo inà nga lugar kag ipagpag ang dapodapo sa indo siki para paandaman nga parusahan sinda ng Dios kay wayà sinda magbaton ng indo ginatudlò.” ");
INSERT INTO rol_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Nganì nagpanaw ang mga disipulo kag naglibot sa mga baryo nga nagawali ng Maayong Balità kag nagapang-ayo ng mga may sakit. ");
INSERT INTO rol_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Nang mabatian ni Herodes nga gobernador ng Galilea ang parti sa mga ginahuman ni Hesus, nalibugan gid siya kay may nagahambay nga nabanhaw si Juan nga Miyugbawtismo. ");
INSERT INTO rol_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","May iban da nga nagahambay nga si Propeta Elias hay nagbalik kag ang iban pa nagahambay nga ang isa sa mga propeta nang una hay nabanhaw. ");
INSERT INTO rol_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Naghambay si Herodes, “Gingpapugutan ko si Juan, pero sin-o baya ini nga tawo? Kay mga makatitingaya nga butang ang akon nababatian parti sa iya.” Nganì nagtinguhà gid si Herodes nga makità si Hesus. ");
INSERT INTO rol_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Pagbalik ng mga apostoles ni Hesus, gingbalità ninda sa iya ang tanan ninda nga ginghuman. Pagkatapos naghalin sinda kag nagkadto sa banwa ng Betsaida nga sinda lang. ");
INSERT INTO rol_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pero nang masayuran ini ng kadamò nga tawo, nag-apas sinda. Ging-abiabi sinda ni Hesus kag gingtudluan parti sa paghaharì ng Dios. Gingpang-ayo da niya ang mga may sakit. ");
INSERT INTO rol_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nang malapit na magtunod ang adlaw, nagpalapit ang Dose kay Hesus kag naghambay, “Pakadtua na ang mga tawo sa mga baryo kag sityo sa palibot agud makapangità sinda tuyugan kag makabakay pagkaon kay yari kita sa tiway nga lugar.” ");
INSERT INTO rol_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Pero nagsabat si Hesus, “Kamo mismo ang magtao pagkaon sa inda.” Nagpangutana sinda sa iya, “Pero lima lang ka bilog ang aton tinapay kag duha lang ang isdà. Mabakay pa ba kami ning pagkaon para sa inda tanan?” ");
INSERT INTO rol_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Tiyad ini ang inda hambay kay may mga 5,000 nga lyaki didto. Pero nagsabat si Hesus sa iya mga disipulo, “Papungkua ang mga tawo ng tig-50 ang kada grupo.” ");
INSERT INTO rol_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Gingtuman ninda ang gingsugò ni Hesus kag gingpapungkò ninda ang tanan nga tawo. ");
INSERT INTO rol_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Pagkatapos gingbuoy ni Hesus ang lima ka bilog nga tinapay kag duha ka bilog nga isdà kag naghangad siya sa langit kag nagpasalamat sa Dios. Gingbuak-buak niya ini kag gingtao sa mga disipulo para ipanagtag sa mga tawo. ");
INSERT INTO rol_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nakakaon sinda tanan kag nabusog gid. Pagkatapos gingtipon ninda ang mga nabilin kag napunò ang dose pa ka ayat*. ");
INSERT INTO rol_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Isa ka adlaw mintras nagapangamuyò si Hesus nga siya lang, yadto da malapit-lapit sa iya ang mga disipulo. Pagkatapos nagpangutana siya sa inda, “Sin-o kuno ako sunò sa hambay ng mga tawo?” ");
INSERT INTO rol_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nagsabat sinda, “May nagahambay nga ikaw si Juan nga Miyugbawtismo. Ang iban naman nagahambay nga ikaw si Elias; kag ang iban pa gid nagahambay nga ikaw isa sa mga propeta nang una nga nabanhaw.” ");
INSERT INTO rol_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Nagpangutana naman siya sa inda, “Hay kamo, ano ang indo mahahambay, sin-o ako?” Nagsabat si Pedro, “Ikaw imaw ang Kristo nga gingsugò ng Dios!” ");
INSERT INTO rol_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Niyan gingpaandaman ni Hesus ang mga disipulo nga indì gid ini ipamalità aber kanin-o. ");
INSERT INTO rol_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Kag naghambay pa gid siya, “Ako nga Ungà ng Tawo hay dapat gid mag-agi ning sobra nga kahugaan kag sikwayon ako ng mga miyugdumaya ng Judio, ng mga pinunò nga parì kag mga eskriba. Ipapatay ninda ako, pero sa ikatuyo ka adlaw mababanhaw ako.” ");
INSERT INTO rol_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Naghambay siya sa tanan, “Ang aber sin-o nga gusto magsunod sa akon, dapat indì niya palabihon ang iya kaugalingon, kundì pas-anon niya ang iya krus adlaw-adlaw kag magsunod sa akon. ");
INSERT INTO rol_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kay ang aber sin-o nga nagapalabi ng iya kabuhì hay maduduyaan ini; pero ang aber sin-o nga nagahalad ng iya kabuhì tungod sa akon, makakabaton siya kabuhì nga wayà katapusan. ");
INSERT INTO rol_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ano gid baya ang mapupuslan ng tawo kung maangkon man niya ang tanan nga butang diri sa kalibutan, pero mawad-an naman siya kabuhì? Wayà gid! ");
INSERT INTO rol_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Kay kung aber sin-o hay ginakahuyà ako nga Ungà ng Tawo kag ang akon mga ginatudlò, ikahuyà ko da sinda pagbalik ko sa kalibutan nga may gahom kag sa gahom ng akon Amay kag ng balaan nga mga anghel. ");
INSERT INTO rol_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Sa matuod lang ginahambay ko sa indo, may mga tawo diri nga indì pa mamatay hasta nga makità ninda ang paghaharì ng Dios.” ");
INSERT INTO rol_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Pagkaligad ng wayo ka adlaw, pagkatapos nga ginghambay ni Hesus ini, gingdaya niya sina Pedro, Juan kag Santiago sa bukid para magpangamuyò. ");
INSERT INTO rol_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Mintras nagapangamuyò si Hesus, nagbaylo ang iya hitsura kag ang iya barò hay nagputì gid nga kasilaw-silaw. ");
INSERT INTO rol_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Gulpi lang nga nagpakità ang duha ka tawo nga nagapakig-istorya kay Hesus. Sinda hay sina Moises kag Elias. ");
INSERT INTO rol_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Kasilaw-silaw gid sinda kag nagapakig-istorya kay Hesus parti sa iya kamatayon nga matatabò sa Jerusalem. ");
INSERT INTO rol_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Hamuok gid ang tuyog ni Pedro kag ng iya mga kaibahan pero gulpi lang sinda nga nakamangno kag nakità ninda si Hesus nga kasilaw-silaw kag imaw da ang duha ka tawo nga nagatindog katupad niya. ");
INSERT INTO rol_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nang pahalinon na ang duha, naghambay si Pedro kay Hesus, “Ginoo, maayo gid kay yari na kita diri. Mahuman kami tuyo ka bayay-bayay, ang isa para sa imo, isa kay Moises kag isa kay Elias.” (Sa matuod lang, wayà siya kasayod kung ano ang iya gingpanghambay.) ");
INSERT INTO rol_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Mintras nagahambay pa siya, may nag-abot nga panganod kag natabunan sinda. Hinadlukan gid ang mga disipulo nang yadto na sinda sa suyod ng panganod. ");
INSERT INTO rol_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Kag may boses nga nabatian halin sa panganod nga nagahambay, “Imaw ini ang akon Ungà nga gingpilì ko. Pamatii nindo siya!” ");
INSERT INTO rol_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nang wayà na ang boses, nakità ninda nga si Hesus na lang ang nabilin. Naghipos lang anay ang mga disipulo sa inda nakità kag wayà gid ninda ini gingpamalità aber kanin-o nang adto nga mga adlaw. ");
INSERT INTO rol_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Nang masunod nga adlaw, nagtugbong sina Hesus halin sa bukid. Gingsugat sinda ng madamò nga tawo. ");
INSERT INTO rol_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","May tawo didto sa mga nagatipon nga nagsinggit, “Maestro! Maluoy ka gid sa akon ungà nga lyaki, bugtong ko siya nga ungà! ");
INSERT INTO rol_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ginasapian siya permi ng malain nga espiritu. Pag ginasapian siya, gulpi lang nga nagasinggit, nagakurog kag nagabuyà ang iya bàbà. Indì gid maghalin ang malain nga espiritu kag permi niya ginapasakitan ang akon ungà. ");
INSERT INTO rol_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nagpakitluoy ako sa imo mga disipulo nga palayason ini, pero indì ninda mapalayas.” ");
INSERT INTO rol_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Nagsabat si Hesus, “Kamo nga mga tawo sa ini nga henerasyon, wayà gid pagtuo kag balingag gid ang indo panghunahunà! Hasta san-o pa baya ang akon pag-antos sa indo?” Tapos naghambay siya sa tatay, “Day-a diri ang imo ungà.” ");
INSERT INTO rol_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Mintras ginadaya ang ungà kay Hesus, gulpi siya nga gingtumba ng demonyo kag gingpakurog. Pero gingsabyaw ni Hesus ang malain nga espiritu nganì naghalin ini kag nag-ayo ang ungà. Pagkatapos gingbalik niya ang ungà sa tatay. ");
INSERT INTO rol_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Niyan natingaya gid ang tanan nga tawo didto sa kadakò nga gahom ng Dios. Mintras natitingaya pa ang mga tawo sa tanan nga ginghuman ni Hesus, naghambay siya sa mga disipulo, ");
INSERT INTO rol_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Tandai nindo ang akon ihambay sa indo! Ako nga Ungà ng Tawo hay malapit na itugyan sa mga tawo nga nagakontra sa akon.” ");
INSERT INTO rol_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pero wayà ninda maintindihi kung ano ang gusto hambayon ni Hesus. Wayà ini gingpasayura sa inda kay gingtagò ini ng Dios para indì ninda maintindihan. Kag nahadlok da sinda magpangutana sa ginghambay ni Hesus. ");
INSERT INTO rol_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Isa ka adlaw, nagdiniskusyon ang mga disipulo ni Hesus parti sa kung sin-o gid sa inda ang labaw sa tanan. ");
INSERT INTO rol_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Sayod ni Hesus kung ano ang inda ginahunahunà, nganì gingbuoy niya ang isa ka ungà kag gingpatindog sa iya alihid. ");
INSERT INTO rol_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Pagkatapos naghambay siya sa inda, “Ang aber sin-o nga nagabaton sa ini nga ungà tungod sa akon hay nagabaton da sa akon. Kag ang aber sin-o nga nagabaton sa akon nagabaton da sa nagsugò sa akon. Kay ang pinakamababà sa indo, imaw ang labaw sa tanan.” ");
INSERT INTO rol_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Pagkatapos naghambay si Juan kay Hesus, “Ginoo, nakakità kami ning tawo nga nagapalayas ng mga demonyo paagi sa imo pangayan. Gingpapara namon siya kay bukon naton siya kaibahan.” ");
INSERT INTO rol_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Pero nagsabat si Hesus sa iya kag sa iban pa nga disipulo, “Ayaw nindo siya pagparaha kay ang aber sin-o nga wayà nagakontra sa indo hay kaampin nindo.” ");
INSERT INTO rol_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Nang malapit na ang adlaw nga si Hesus hay day-on palangit, nagdesisyon siya nga magkadto sa Jerusalem. ");
INSERT INTO rol_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Nganì may gingpauna siya nga mga tawo sa isa ka baryo sa Samaria para magpreparar ng iya madayunan. ");
INSERT INTO rol_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pero ang mga taga-Samaria indì magbaton sa iya kay sayod ninda nga pakadto siya sa Jerusalem. ");
INSERT INTO rol_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nang mabatian ini ng iya mga disipulo nga sina Santiago kag Juan, naghambay sinda, “Ginoo, gusto mo ba nga pauyanan namon sinda ng kalayo halin sa langit para masunog sinda?” ");
INSERT INTO rol_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Pero nag-atubang si Hesus kag gingsabyaw sinda. Hambay niya, “Wayà kamo kasayod kung ano nga espiritu ang indo ginasunod. Ako nga Ungà ng Tawo hay nagkari diri, bukon para patyon ang mga tawo kundì taw-an sinda ning kabuhì nga wayà katapusan.” ");
INSERT INTO rol_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Pagkatapos nagderitso si Hesus kag ang iya mga disipulo sa iban nga banwa. ");
INSERT INTO rol_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Mintras nagapanaw sinda, may isa ka tawo nga naghambay kay Hesus, “Masunod ako sa imo aber diin ka magkadto.” ");
INSERT INTO rol_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Nagsabat si Hesus sa iya, “Ang singgayong hay may buhò nga ginaistaran kag ang pispis may pugad, pero ako nga Ungà ng Tawo wayà bayay nga mahihigdaan o mapapahuwayan.” ");
INSERT INTO rol_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Naghambay pa gid si Hesus sa isa pa ka tawo, “Magsunod ka sa akon.” Pero nagsabat siya, “Ginoo, mapaulì anay ako kay ipalubong ko ang akon tatay.” ");
INSERT INTO rol_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Pero nagsabat si Hesus, “Pabay-i lang ang patay nga maglubong sa inda mga patay. Pero ikaw, panaw na kag iwali ang parti sa gingharian ng Dios.” ");
INSERT INTO rol_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Igwa pa gid naghambay kay Hesus, “Ginoo, masunod ako sa imo, pero tuguti anay ako nga magpamuhon sa akon pamilya.” ");
INSERT INTO rol_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Nagsabat si Hesus sa iya, “Ang aber sin-o nga nagaarado kag naganilingig, bukon siya angay nga miyug-arado. Imaw da ang aber sin-o nga nagasunod sa akon. Kung nagabinalik-balik siya sa dati nga pagkabuhì bukon siya angay sa gingharian ng Dios.” ");
INSERT INTO rol_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Pagkatapos adto, gingpilì ni Hesus ang 72 ka disipulo kag gingpakadto niya sinda ning tigduha-duha sa tanan nga banwa kag lugar nga iya ginaplanuhan nga kadtuan. ");
INSERT INTO rol_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Naghambay siya sa inda, “Kadakò-dakò ang anihon pero kalakà lang ang mga miyug-ani. Nganì magpangamuyò kamo sa Ginoo nga tag-iya ng anihon para suguon niya ang mga miyug-ani sa iya anihon. ");
INSERT INTO rol_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Kadto na kamo! Pero mag-andam gid kamo kay ginapakadto ko kamo sa malain nga mga tawo nga daw kamo ang mga kordero nga nagakadto sa lugar nga may mapintas nga hayop. ");
INSERT INTO rol_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ayaw kamo magdaya ning supot, bag o sandalyas. Ayaw magduyog sa dayan kag mag-inistorya sa masumpong nindo nga mga tawo. ");
INSERT INTO rol_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Kung magsuyod kamo sa isa ka bayay, maghambay kamo, ‘Kabay pa nga taw-an ng Dios ning katawhayan ini nga pamilya.’ ");
INSERT INTO rol_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Kag kung batunon ng tagbayay ang katawhayan nga indo gingpangabay, magakaigwa gid sinda ini. Pero kung indì, ang indo gingpangabay nga katawhayan hay magabalik sa indo. ");
INSERT INTO rol_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kung may magpadayon sa indo, didto lang kamo kag ayaw kamo magsinaylo-saylo. Batuna nindo ang aber ano nga inda ginapakaon kag ginapainom kay ang nagatrabaho dapat suhuyan. ");
INSERT INTO rol_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Kung nagakadto kamo sa aber diin nga banwa kag ginabaton kamo ng mga tawo didto, kauna nindo ang aber ano nga inda ginapakaon sa indo. ");
INSERT INTO rol_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Paayuha ang mga nagamasakit didto kag balitai nindo ang mga tawo, ‘Malapit na ang oras nga magaharì sa indo ang Dios.’ ");
INSERT INTO rol_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pero kung magkadto kamo sa isa ka banwa nga ang mga tawo indì magbaton sa indo, lumuwas kamo sa karsada kag maghambay sa inda, ");
INSERT INTO rol_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Patì ang dapodapo sa indo banwa nga nagasapot sa amon siki hay amon ipagpag para masayuran nindo nga kamo ang manabat kung parusahan kamo ng Dios. Tandai nindo ini: malapit na ang oras nga magaharì ang Dios.’ ");
INSERT INTO rol_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ginahambay ko sa indo, sa adlaw ng paghusga, mas sobra pa ang parusa ng Dios sa mga tawo nga wayà nagbaton sa indo kaysa sa mga taga-Sodom!” ");
INSERT INTO rol_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Pagkatapos naghambay pa gid si Hesus, “Makaluluoy kamo, mga taga-Corazin! Imaw da kamo, mga taga-Betsaida! Kay kung ang mga milagro nga akon ginghuman sa indo, ginghuman ko sa mga tawo sa Tyre kag Sidon, kadugay na kuntà sinda nagsuksok ning kustal kag nagpungkò sa abo para ipasayod nga nagatalikod na sinda sa inda mga salà. ");
INSERT INTO rol_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Sa adlaw ng paghusga, mas sobra pa ang parusa nga itatao ng Dios sa indo kaysa sa taga-Tyre kag taga-Sidon. ");
INSERT INTO rol_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kamo nga mga taga-Capernaum! Ang kalaom ba nindo pagadayawon gid kamo? Ihuhuyog gid kamo sa impyerno!” ");
INSERT INTO rol_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Pagkatapos naghambay si Hesus, “Ang nagapamatì sa indo nagapamatì da sa akon. Ang nagasikway sa indo, nagasikway da sa akon; kag ang nagasikway sa akon, nagasikway da sa nagsugò sa akon.” ");
INSERT INTO rol_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Pagbalik ng 72 ka disipulo kay Hesus, nalipay gid sinda. Naghambay sinda, “Ginoo, aber ang mga demonyo hay nagatuman sa amon nang gingpalayas namon sinda paagi sa imo pangayan!” ");
INSERT INTO rol_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Nagsabat si Hesus sa inda, “Nakità ko si Satanas nga nahuyog halin sa langit nga pareho ning kilat. ");
INSERT INTO rol_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Pamatì kamo! Gingtaw-an ko kamo ning gahom agud bisan matimakan nindo ang mga sawa kag iwi, wayà gid ning may matatabò sa indo nga malain kag maperdi nindo ang tanan nga gahom ng aton kaaway nga si Satanas. ");
INSERT INTO rol_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pero ayaw kamo magkalipay kay nagatuman sa indo ang malain nga mga espiritu, kundì magkalipay kamo kay ang indo pangayan nakasulat na sa langit.” ");
INSERT INTO rol_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Adto nga oras, napunò gid si Hesus ning kalipay halin sa Espiritu Santo. Naghambay siya, “Amay nga Ginoo ng langit kag dutà, ginadayaw ko ikaw kay ang kamatuuran hay imo gingtagò sa mga tawo nga ang kalaom ninda hay kamayad sinda kag may tinun-an; kag imo ini gingpasayod sa mga mapainubuson nga pareho ng ungà nga kaisot. Amay, dayawon ka, kay imaw ini ang ginakalipay mo.” ");
INSERT INTO rol_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Pagkatapos adto, naghambay si Hesus sa mga tawo didto, “Gingtao na ang tanan sa akon ng akon Amay. Wayà ning may nakakakilaya sa akon nga iya Ungà kundì ang Amay; kag wayà ning may nakakakilaya sa Amay kundì ang iya Ungà kag ang mga tawo nga gingpilì ng Ungà nga maipakilaya ang Amay.” ");
INSERT INTO rol_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Pagkatapos nag-atubang si Hesus sa iya mga disipulo kag naghambay sa inda lang, “Bulahan kamo kay nakità gid nindo ang tanan nga ginapanghuman ko! ");
INSERT INTO rol_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ginahambay ko sa indo, kadamò nga propeta* kag harì nang una ang gusto makakità ng indo nakità, pero wayà sinda nakakità; kag gusto da ninda makapamatì ng indo nabatian, pero wayà sinda nakabatì.” ");
INSERT INTO rol_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","May isa ka miyugtudlò ng Kasuguan nga nagpalapit kay Hesus para tilawan siya. Nagpangutana siya, “Maestro, ano baya ang dapat ko humanon agud makapanublì ning kabuhì nga wayà katapusan?” ");
INSERT INTO rol_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Nagsabat si Hesus, “Ano ang hambay sa Kasuguan ng Dios? Ano ang nabasa mo?” ");
INSERT INTO rol_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nagsabat siya, “Higugmaon mo ang Ginoo nga imo Dios sa bilog mo nga tagipusuon, sa bilog mo nga kabubut-on, sa tanan mo nga kusog kag sa tanan mo nga hunahunà. Kag higugmaon mo ang imo isigkatawo pareho ng paghigugmà mo sa imo kaugalingon.” ");
INSERT INTO rol_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Nagsabat si Hesus, “Tamà gid ang imo sabat. Kung humanon mo ini tanan, makakabaton ka ng kabuhì nga wayà katapusan.” ");
INSERT INTO rol_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pero indì gusto ng eskriba* nga mapahuyà siya, nganì nagpangutana siya liwat kay Hesus, “Huo, pero sin-o gid ang akon isigkatawo?” ");
INSERT INTO rol_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Nagsabat si Hesus paagi sa isa ka istorya: “May tawo nga nagapakadto sa Jerico halin sa Jerusalem. Mintras nagapanaw siya, gulpi lang siya gingharangan ng mga miyugpangawat. Gingbuoy ninda ang tanan niya nga daya patì ang iya barò, gingsinumbag siya kag gingpabay-an didto sa karsada nga hayos himamatyon na. ");
INSERT INTO rol_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Natabuan nga may nag-agi nga parì sa adto nga karsada. Nang makità niya adto nga tawo, naglikaw siya sa kabuak. ");
INSERT INTO rol_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Imaw da ang natabò sa masunod nga nakaagi didto nga isa ka Levita*. Gingpalapitan niya ang tawo para siruon, pagkatapos nag-agi da siya sa kabuak. ");
INSERT INTO rol_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Malagat-lagat may nag-agi da didto nga taga-Samaria. Nang makità niya ang tawo, naluoy gid siya. ");
INSERT INTO rol_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Gingpalapitan niya kag gingbuyong. Gingbutangan niya ning lana kag ilimnon ang mga pilas kag gingbugkusan. Tapos gingpasakay niya ang tawo sa iya asno kag gingdaya sa lugar nga dayunan kag didto gingdipara. ");
INSERT INTO rol_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Nang masunod nga adlaw, gingtaw-an niya ang tag-iya ng dayunan ning kwarta kag naghambay, ‘Diparaha abi siya kag kung kuyang pa ang akon gingtao sa imo, dugangan ko ini pagbalik diri.’ ” ");
INSERT INTO rol_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Nang matapos na ang istorya ni Hesus, naghambay siya, “Kung sa imo, sin-o sa ini nga tuyo ang matuod nga isigkatawo ng adtong gingharangan ng mga miyugpangawat?” ");
INSERT INTO rol_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Nagsabat ang eskriba, “Adtong tawo nga naluoy sa iya.” ");
INSERT INTO rol_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Nagpadayon si Hesus kag ang mga disipulo sa inda pagpanaw hasta nga makaabot sinda sa isa ka banwa. Igwa didto babayi nga ang pangayan hay Marta. Gingpadayon niya sinda sa iya bayay. ");
INSERT INTO rol_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Igwa siya manghod nga si Maria. Si Maria hay nagpungkò sa alihid ni Hesus para magpamatì sa iya ginatudlò. ");
INSERT INTO rol_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pero si Marta naman hay habot-habot gid kag nagapinaugot sa pagpreparar ng pagkaon. Nganì, nagpalapit siya kay Hesus kag nagreklamo, “Ginoo, baliwayà lang ba sa imo nga ginapabay-an ako ng akon manghod nga ako lang isa ang nagatrinabaho? Hambayi abi siya nga buligan ako!” ");
INSERT INTO rol_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Pero nagsabat ang Ginoo sa iya, “Ay Marta! Nalilibog ka sa madamò nga butang, ");
INSERT INTO rol_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","pero isa lang gid ang kahinangyan kag gingpilì ni Maria ang tamà kag wayà gid may makabuoy ini sa iya.” ");
INSERT INTO rol_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Isa ka adlaw, nagapangamuyò si Hesus sa isa ka lugar. Pagkatapos ng iya pangamuyò, nagpalapit ang isa sa iya mga disipulo kag naghambay, “Ginoo, tudlui abi kami magpangamuyò pareho ng ginghuman ni Juan sa iya mga disipulo.” ");
INSERT INTO rol_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Naghambay si Hesus sa inda, “Kung magpangamuyò kamo tiyad ini ang indo ihambay: Amay namon, kabay pa nga tahuron ang imo balaan nga pangayan. Kabay pa nga magharì ka sa amon. ");
INSERT INTO rol_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Taw-i kami ng amon ginakahinangyan nga pagkaon sa adlaw-adlaw. ");
INSERT INTO rol_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Patawara kami sa amon mga salà, kay ginapatawad da namon ang tanan nga nakasalà sa amon. Kag ayaw kami pagtuguti nga matintar.” ");
INSERT INTO rol_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Pagkatapos, gingtudluan pa gid sinda ni Hesus parti sa pagpangamuyò. Hambay niya, “Halimbawà, igwa ka ning amigo kag sa tungang gab-i, makadto ka sa iya bayay kag mahambay sa iya, ‘Amigo, taw-i anay ako ning tuyo ka bilog nga tinapay. ");
INSERT INTO rol_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Kay may amigo ako nga bag-ong abot kag wayà gid ako ning ipakaon sa iya.’ ");
INSERT INTO rol_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Kag masabat ang imo amigo, ‘Ayaw na abi ako pag-isturbuha. Natrangkahan na ang amon pwertahan kag isa pa, nagahigdà na ako kag ang akon mga ungà. Indì ako makabangon para taw-an ka ng imo ginakahinangyan.’ ” ");
INSERT INTO rol_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Hambay pa ni Hesus, “Ginahambay ko sa indo, indì kuntà niya gusto magbangon kag magtao tungod lang sa inda pagiging mag-amigo. Pero mabangon siya kag magtao ng ginakahinangyan ng iya amigo tungod sa iya pagpamilit. ");
INSERT INTO rol_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Nganì tandai gid nindo ang akon ginahambay, ‘Magpangayò kamo sa Dios, kag taw-an kamo. Magpangità kamo, kag makakità kamo. Magpanuktok kamo, kag buksan ang pwertahan para sa indo.’ ");
INSERT INTO rol_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kay ang aber sin-o nga nagapangayò makakabaton; ang nagapangità makakakità; kag ang nagapanuktok pagabuksan. ");
INSERT INTO rol_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Kamo nga mga tatay, kung magpangayò ang indo ungà ning isdà, taw-an ba nindo ning sawa? ");
INSERT INTO rol_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Kung magpangayò ning itlog, taw-an ba nindo ning iwi? Syempre indì! ");
INSERT INTO rol_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kung kamo nganì nga mga malain hay antigo magtao ning maayo nga regalo sa indo mga ungà, mas lalò pa gid ang Amay sa langit, itatao gid niya ang Espiritu Santo sa nagapangayò sa iya!” ");
INSERT INTO rol_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Isa ka adlaw, gingpalayas ni Hesus ang demonyo nga nagpaapà sa isa ka tawo. Nang magluwas na ang demonyo, nakahambay na siya kag natingaya ang mga tawo. ");
INSERT INTO rol_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pero naghambay ang iban parti kay Hesus, “Ginapalayas niya ang mga demonyo paagi sa gahom ni Beelzebul nga pinunò ng mga demonyo.” ");
INSERT INTO rol_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ang iban naman hay gusto ninda nga tistingon si Hesus. Nganì nagpangayò sinda sa iya ning milagro para pamatuuran nga gingsugò siya ng Dios. ");
INSERT INTO rol_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pero sayod ni Hesus ang inda ginahunahunà nganì naghambay siya sa inda, “Kung ang mga pinunò ng isa ka gingharian mag-iniyaiya kag mag-inaway, inà nga gingharian hay maduduyà. Imaw da ang matatabò sa isa ka pamilya, kung ang mga miyembro hay mag-iniyaiya kag mag-inaway, magakabuyag-buyag sinda. ");
INSERT INTO rol_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nganì kung si Satanas kag ang iya mga grupo hay mag-iniyaiya kag mag-inaway, pauno makapadayon ang iya gingharian? Ginahambay ko ini kay hambay nindo ginapalayas ko ang mga demonyo paagi sa gahom ni Beelzebul. ");
INSERT INTO rol_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Kung matuod nga si Beelzebul ang nagatao sa akon ning gahom para magpalayas ng mga demonyo, sin-o naman ang nagatao ning gahom sa indo mga tagasunod para magpalayas da ng demonyo? Sinda da ang nagapamatuod nga salà kamo! ");
INSERT INTO rol_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Sa matuod lang, ang Dios ang nagatao sa akon ning gahom para palayason ang mga demonyo. Ini nagapamatuod nga ang paghaharì ng Dios hay nag-abot na sa indo.” ");
INSERT INTO rol_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Nagtudlò pa gid si Hesus, “Kung nagabantay ang makusog nga tawo sa iya bayay nga kumpleto ang iya armas, indì gid mabuoy ang iya mga pagkabutang. ");
INSERT INTO rol_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero kung labanan siya ng mas makusog sa iya, mapeperdi siya. Ang iya ginasaligan nga mga armas buy-on sa iya kag patì ang tanan niya nga pagkabutang hay parte-partehon. ");
INSERT INTO rol_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ang wayà nagaapin sa akon, kontra sa akon. Kag ang wayà nagabulig sa akon pagtipon sa mga tawo hay imaw ang kabangdanan ng pagkawatakwatak.” ");
INSERT INTO rol_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Naghambay pa si Hesus, “Kung magluwas ang malain nga espiritu sa isa ka tawo nga iya ginasapian, nagalibot siya sa mga lugar nga wayà tubì kay nagapangità ng lugar nga mapahuwayan. Pero kung wayà siya ning may makità, mahambay siya, ‘Mabalik ako sa tawo nga akon ginghalinan.’ ");
INSERT INTO rol_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Kag pagbalik niya, makikità nga malimpyo kag maayo na ang tanan, ");
INSERT INTO rol_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","nganì mapanaw siya kag madaya pa ng pito ka espiritu nga mas malain pa kaysa sa iya. Masuyod sinda sa adto nga tawo kag didto matinir. Kag ang kamutangan ng adto nga tawo hay magiging mas sobra pa gid kaysa dati.” ");
INSERT INTO rol_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Mintras nagahambay pa si Hesus, may babayi didto sa kadamuan nga nagsinggit sa iya, “Bulahan ang babayi nga nagnabdos kag nagpasuso sa imo!” ");
INSERT INTO rol_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Pero nagsabat si Hesus, “Mas bulahan ang nagapamatì kag nagatuman ng hambay ng Dios.” ");
INSERT INTO rol_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Mintras nagadamò pa gid ang mga tawo nga nagatipon kay Hesus, naghambay siya, “Sobra gid kalain ang mga tawo sa ini nga henerasyon. Nagapangayò sinda ng milagro, pero wayà milagro nga ipakità sa inda puyra lang ang natabò kay Propeta Jonas. ");
INSERT INTO rol_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kay ang natabò kay Jonas imaw ang tandà sa mga taga-Nineve nga ang Dios ang nagpadaya sa iya. Nganì ang matatabò sa akon nga Ungà ng Tawo hay tandà nga ako ang gingpadaya ng Dios sa indo sa ini nga henerasyon. ");
INSERT INTO rol_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Sa adlaw ng paghusga, mababanhaw ang Rayna sa sur kaibahan nindo nga mga tawo sa ini nga henerasyon kag husgahan niya kamo. Kay nang una naghalin pa siya sa malayò gid nga lugar para magpamatì ng kamayad ni Haring Solomon. Niyan, yari diri ang mas importante kaysa kay Solomon, pero wayà kamo nagabaton ng iya ginatudlò! ");
INSERT INTO rol_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Sa adlaw ng paghusga, mababanhaw ang mga taga-Nineve kaibahan nindo sa ini nga henerasyon kag husgahan ninda kamo. Kay nang mabatian ng mga taga-Nineve ang gingwali ni Jonas, nagtalikod sinda sa inda salà. Niyan yari diri ang mas importante pa kay Jonas, pero wayà kamo nagabaton ng iya ginawali!” ");
INSERT INTO rol_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Naghambay pa gid si Hesus, “Wayà tawo nga nagasugà ng iwagan kag ginatagò ini o ginatakyuban ng gantangan, kundì ginabutang niya sa tungtungan para mahayagan ang nagasuyod sa bayay. ");
INSERT INTO rol_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ang mata nindo hay daw iwag nga nagatao kahayag sa indo lawas. Kung mahayag ang indo mata, mahahayagan gid ang indo bilog nga lawas. Pero kung ang indo mata hay kaduyom, maduduyuman gid ang indo lawas. ");
INSERT INTO rol_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Nganì mag-andam kamo, kay basì kung ang kahayag nga yarà sa indo, hay kaduyom galì. ");
INSERT INTO rol_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kay kung yarà sa kahayag ang imo bilog nga lawas kag wayà parte nga maduyom, mahahayagan gid ini, nga daw ginahayagan kamo ng isa ka kahayag-hayag nga iwag.” ");
INSERT INTO rol_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Pagkahambay adto ni Hesus, may isa ka Pariseo nga nag-agda sa iya nga magkaon sa iya bayay. Nagkadto si Hesus sa inda kag pag-abot didto, nagsuyod siya sa bayay kag nagpungkò para magkaon. ");
INSERT INTO rol_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Natingaya ang Pariseo nang makità niya nga wayà nagpanghinaw si Hesus bago magkaon. ");
INSERT INTO rol_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Nganì naghambay ang Ginoo sa iya, “Kamo nga mga Pariseo, ginahugasan lang nindo ang luwas ng tasa kag plangganita para masunod ang indo patakaran, pero sa suyod ng indo tagipusuon punò ng kahakog kag kalainan. ");
INSERT INTO rol_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mga kuyang-kuyang siguro kamo! Dì ba ang Dios ang naghuman ng indo lawas kag ng yarà sa suyod? Dapat pareho ini nga limpyuhon. ");
INSERT INTO rol_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nganì dapat maging maatag kamo kag taw-an nindo ang mga pobre halin sa indo tagipusuon. Kay kung tiyad ini ang indo humanon, magiging malimpyo gid ang tanan para sa indo. ");
INSERT INTO rol_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Makaluluoy gid kamo nga mga Pariseo! Ginatao nindo ang ikanapuyò aber ng hilbabuyna, mga panabyà kag iban pa nga utanon, pero ginabaliwayà nindo ang matarong nga pagkabuhì kag ang paghigugmà sa Dios. Dapat nga tiyad ini ang indo ginahuman, pero ayaw da nindo pagbaliwayaa ang mas importante nga mga sugò. ");
INSERT INTO rol_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Makaluluoy gid kamo nga mga Pariseo! Kay sa mga sinagoga*, gusto gid nindo ang mga pungkuan para sa importante nga tawo. Kag sa mga lugar nga madamò ang tawo, gusto gid nindo nga abi-abihon kag tahuron kamo. ");
INSERT INTO rol_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Makaluluoy gid kamo! Pareho kamo ng lubungan nga wayà tandà kag ginatinimakan lang ng mga tawo nga wayà nakasayod nga lubungan galì adto.” ");
INSERT INTO rol_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Niyan naghambay ang isa sa mga miyugtudlò ng Kasuguan, “Maestro, patì kami hay naiinsulto da ng imo ginahambay.” ");
INSERT INTO rol_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Kag nagsabat si Hesus, “Makaluluoy gid patì kamo nga mga miyugtudlò ng Kasuguan! Kay ginapabug-atan nindo ang mga tawo sa mga layi nga gingdugang nindo sa Kasuguan, pero wayà gid kamo may ginahuman para buligan sinda agud magagaan ang inda ginapas-an. ");
INSERT INTO rol_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Makaluluoy gid kamo! Nagahuman kamo ng monyumento ng mga propeta nga gingpamatay ng indo kalulo-lulohan. ");
INSERT INTO rol_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nganì sa tiyad ini nga indo ginghuman, kamo na da ang nagapamatuod nga nagasugot kamo sa ginghuman ng indo kalulo-lulohan kay sinda ang nagpamatay ng mga propeta kag kamo ang nagpahuman ng inda mga monyumento. ");
INSERT INTO rol_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Nganì ang Dios nga pinakamayad kag nakakasayod ng tanan naghambay, ‘Pakadtuon ko sa inda ang mga propeta kag mga apostoles. Ang iban hay pagapatyon kag ang iban pa hay inda pagasakiton.’ ");
INSERT INTO rol_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Nganì ang mga tawo sa ini nga henerasyon hay paparusahan ng Dios tungod sa pagkamatay ng tanan nga propeta tunà pa ng pagtuga ng kalibutan, ");
INSERT INTO rol_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","kag magtunà kay Abel hasta kay Zacarias. Gingpatay ninda siya didto sa tungà ng altar kag ng templo. Matuod gid ang ginahambay ko sa indo, ang parusa sa adto tanan nga pagpatay hay mababaton ng ini nga henerasyon. ");
INSERT INTO rol_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Makaluluoy gid kamo nga mga miyugtudlò ng Kasuguan! Kay ginatagò nindo ang lyabi agud indì maintindihan ang kamatuuran parti sa Dios. Kamo mismo indì magsunod sa kamatuuran kag ginaharangan pa nindo ang nagatinguhà nga magsunod.” ");
INSERT INTO rol_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Nang magluwas ng bayay si Hesus, naglain ang buot ng mga eskriba kag mga Pariseo. Gingpinangutana gid ninda si Hesus parti sa kadamò nga butang ");
INSERT INTO rol_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","kag ginabinantayan gid ninda siya para dakpon sa iya mga ginahambay. ");
INSERT INTO rol_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Nang adto da nga oras, nagpangkadto didto kay Hesus ang nilibo-libo nga mga tawo kag sa sobra nga kadamò hay nagatinimakan na sinda. Naghambay si Hesus sa iya mga disipulo, “Mag-andam gid kamo sa pampaalsa ng mga Pariseo, ang akon gusto hambayon hay ang inda pagkahipokrito. ");
INSERT INTO rol_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kay wayà ning may ginatagò nga indì makikità kag wayà ning sikreto nga indì masasayuran. ");
INSERT INTO rol_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Nganì ang aber ano nga indo ginahambay sa kaduyom hay mababatian ng tanan kag ang aber ano nga indo ginahutik sa suyod ng kwarto hay isisinggit sa lugar nga kadamò ang makakabatì.” ");
INSERT INTO rol_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Mga amigo ko, tandai ang akon ginahambay sa indo. Ayaw kamo mahadlok sa tawo nga makakapatay lang ng indo lawas kag wayà na sinda ning mahuman pa sa indo. ");
INSERT INTO rol_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Pero ginahambay ko sa indo kung sin-o ang dapat nindo kahadlukan: kahadluki nindo ang Dios kay pagkatapos patyon ang lawas, igwa pa siya ning gahom nga magpilak sa impyerno. Matuod gid ang akon ginahambay sa indo, ang Dios ang dapat nindo kahadlukan! ");
INSERT INTO rol_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Dì ba ginabaligyà ang lima ka maya sa barato lang nga kantidad? Pero aber isa sa inda hay wayà ginakalimuti ng Dios! ");
INSERT INTO rol_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Aber ang indo mga buhok hay bilang niya tanan. Nganì ayaw kamo mahadlok kay kamo hay mas importante kaysa sa madamò nga pispis nga maya.” ");
INSERT INTO rol_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Naghambay pa si Hesus, “Tandai ang akon ginahambay sa indo, ang aber sin-o nga nagakilaya sa akon sa atubangan ng mga tawo, ako nga Ungà ng Tawo* hay magakilaya da sa iya sa atubangan ng mga anghel ng Dios. ");
INSERT INTO rol_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pero ang wayà nagakilaya sa akon sa atubangan ng mga tawo, indì ko da siya kilay-on sa atubangan ng mga anghel ng Dios. ");
INSERT INTO rol_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ang aber sin-o nga maghambay kontra sa akon nga Ungà ng Tawo hay mapapatawad; pero ang maghambay ning malain kontra sa Espiritu Santo indì gid mapatawad. ");
INSERT INTO rol_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Kung day-on kamo sa sinagoga para imbistigahan ng mga miyugdumaya ng banwa o ng mga may otoridad, ayaw kamo magkabayaka kung pauno kamo magsabat o ano ang indo ihambay. ");
INSERT INTO rol_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kay sa adto gid nga oras, ang Espiritu Santo ang magatudlò sa indo kung ano ang dapat nindo ihambay.” ");
INSERT INTO rol_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Naghambay kay Hesus ang isa sa mga nagapamatì didto, “Maestro, sugua abi ang akon maguyáng nga partehan ako ng amon panublion.” ");
INSERT INTO rol_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Pero nagsabat si Hesus sa iya, “Hukom ba ako para maghusga o maghusay ng indo partehon nga panublion?” ");
INSERT INTO rol_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Pagkatapos naghambay pa gid si Hesus, “Magbantay kamo kag mag-andam sa tanan nga klasi ng pagkahakog. Kay ang kabuhì nga maayo kag malipayon bukon lang tungod nga igwa kamo ning kadamò nga butang o kadakò nga kwarta.” ");
INSERT INTO rol_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Pagkatapos nagtudlò si Hesus paagi sa ini nga parabola*: “Igwa ning tawo nga manggaranon kag ang iya dutà hay abunda gid ang patubas. ");
INSERT INTO rol_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nganì naghambay siya sa iya kaugalingon, ‘Ano baya ang akon humanon? Wayà na ako ning may mabutangan ng akon mga patubas! ");
INSERT INTO rol_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Maayo pa, ipagubà ko ang akon mga kamalig kag mapaugdok ako ning mas mabahoy pa gid kag didto ko ibubutang ang akon mga tubas kag iban pa nga mga gamit. ");
INSERT INTO rol_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Pagkatapos hambayon ko sa akon kaugalingon, Parì, dakò na ang imo natipon para sa paabuton nga mga tuig. Pahuway-huway na lang, pagkaon, pag-inom kag pagkinalipay!’ ");
INSERT INTO rol_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pero naghambay ang Dios sa iya, ‘Kuyang-kuyang ka siguro! Ini da nga gab-i, babawion ko ang imo kabuhì. Kanin-o arà mapakadto ang imo tinipon nga manggad?’ ");
INSERT INTO rol_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Tiyad da ini ang matatabò sa mga tawo nga nagatinipon ning manggad para lang sa inda kaugalingon, pero pobre sa panirò ng Dios.” ");
INSERT INTO rol_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Pagkatapos, naghambay si Hesus sa iya mga disipulo, “Nganì ginahambay ko sa indo, ayaw kamo magkalibog kung pauno kamo mabuhì, kung ano ang indo kaunon kag kung ano ang indo isuksok. ");
INSERT INTO rol_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kay ang kabuhì mas importante kaysa sa pagkaon kag ang lawas kaysa sa barò. ");
INSERT INTO rol_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Tan-awa nindo ang mga uwak. Wayà sinda nagatanom, wayà nagaani kag wayà da nagatipon ning pagkaon sa kamalig, pero ginapakaon sinda ng Dios. Dì ba mas importante pa kamo kaysa sa mga pispis? ");
INSERT INTO rol_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Sin-o sa indo ang makadugang ning aber isa lang ka oras sa indo kabuhì paagi sa pagpangalibog? Wayà gid! ");
INSERT INTO rol_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kung indì kamo makahuman aber tiyad ini kaisot nga butang, basì nagapangalibog kamo sa iban nga mga butang? ");
INSERT INTO rol_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Tan-awa ang mga buyak kung pauno sinda nagatubò. Wayà sinda nagapangabudlay o nagatahì. Pero ginahambay ko sa indo, aber si Haring Solomon nga bantog kag manggaranon wayà siya nakabarò ning kaayo-ayo pareho ng isa sa ini nga mga buyak. ");
INSERT INTO rol_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kung ginabaruan ng Dios ang mga gunahon nga buhì niyan sa bukid pero sa masunod nga adlaw hay ginapilak lang sa kalayo, kamo pa arà indì niya pabaruan? Kaisot-isot ang indo pagtuo! ");
INSERT INTO rol_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Nganì ayaw kamo magpangalibog kag mag-inisip kung ano ang indo kaunon kag inumon. ");
INSERT INTO rol_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kay imaw ini ang ginapangalibugan ng mga tawo sa kalibutan nga wayà nagakilaya sa Dios. Pero sayod ng indo Amay nga kahinangyan nindo adto nga mga butang. ");
INSERT INTO rol_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nganì unaha nindo ang pagpasakop sa paghaharì ng Dios kag itatao gid niya sa indo ang indo mga kahinangyan.” ");
INSERT INTO rol_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Ayaw kamo mahadlok aber malakà lang kamo. Kay nalilipay ang aton Amay sa langit nga itao sa indo ang gingharian. ");
INSERT INTO rol_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nganì ibaligyà nindo ang indo mga pagkabutang kag itao sa mga pobre para makatipon kamo ning manggad didto sa langit nga indì gid maduyà. Kay didto hay wayà ning miyugpangawat nga makapalapit kag wayà da ning itiit nga makasirà. ");
INSERT INTO rol_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kay kung sa diin ang indo manggad yadto da ang indo tagipusuon.” ");
INSERT INTO rol_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Naghambay pa gid si Hesus, “Magpreparar kamo aber ano ang matabò kag pasigaha permi ang indo iwag. ");
INSERT INTO rol_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Patuyari nindo ang mga ulipon nga preparado kag nagahuyat sa pagbalik ng inda amo halin sa kasayan, para kung magpanuktok maabrihan nga daan ang pwertahan. ");
INSERT INTO rol_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Bulahan ang mga ulipon nga nagabantay sa pag-abot ng inda amo. Sa matuod lang ginahambay ko sa indo, pag-abot ng inda amo mailis siya, papungkuon niya sinda sa lamisa kag iya tahawan. ");
INSERT INTO rol_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Bulahan ang mga ulipon nga nakapreparar sa pag-abot ng inda amo aber sa tungang gab-i o aga-aga! ");
INSERT INTO rol_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Tandai nindo ini, kung sayod lang ng tag-iya ng bayay kung ano nga oras maabot ang miyugpangawat, indì gid siya maghalin sa iya bayay para indì ini masuyod. ");
INSERT INTO rol_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nganì kamo da hay dapat magpreparar kay magaabot ang Ungà ng Tawo sa oras nga wayà nindo ginapaabot.” ");
INSERT INTO rol_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Nagpangutana si Pedro, “Ginoo, sin-o ang imo ginatudluan sa ini nga parabola, kami o ang tanan?” ");
INSERT INTO rol_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Nagsabat ang Ginoo, “Ang masaligan kag mayad nga suluguon imaw ang gingpilì ng amo agud magdumaya sa iban nga mga ulipon sa bayay. Siya ang nagatao sa inda ning pagkaon kada adlaw. ");
INSERT INTO rol_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Bulahan adto nga ulipon kung maabutan siya ng iya amo nga nagahuman ng iya trabaho. ");
INSERT INTO rol_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Sa matuod lang ginahambay ko sa indo, padumayahon siya ng iya amo sa tanan niya nga propidad. ");
INSERT INTO rol_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pero kung maghambay adto nga ulipon sa iya kaugalingon, ‘Madugay pa magbalik ang akon amo,’ kag sakiton niya ang iya mga kapareho nga suluguon aber lyaki o babayi kag magkinaon siya, mag-ininom kag magbinayong, ");
INSERT INTO rol_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","niyan magaabot ang iya amo sa adlaw nga wayà niya ginapaabota kag sa oras nga wayà niya masayuri kag parusahan gid siya ning sobra ng iya amo. Tapos ilalakot siya sa mga tawo nga indì gid masaligan. ");
INSERT INTO rol_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ang ulipon nga nakakasayod kung ano ang gusto ng iya amo, pero bukon siya preparado o wayà niya ginahumana kung ano ang gusto ng iya amo, sobra gid ang parusa nga mababaton niya. ");
INSERT INTO rol_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pero ang ulipon nga wayà nakakasayod kung ano ang gusto ng iya amo, magkuyang man siya sa iya obligasyon magaan lang ang parusa sa iya. Kay ang ginataw-an ning madamò, madamò da ang papangitaon sa iya; kag ang ginasaligan ning mas madamò, papanabaton da ng mas madamò.” ");
INSERT INTO rol_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Nagkari ako sa kalibutan para husgahan ang mga tawo kag ini hay pareho ng kalayo kag gusto ko kuntà nga nagadayab na ini. ");
INSERT INTO rol_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Pero bago ini matabò, dapat anay magaagi ako ning sobra nga kahugaan kag kasakit. Kag ginabug-atan ako mintras wayà pa ini matabò. ");
INSERT INTO rol_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kalaom ba nindo nagkari ako sa kalibutan para magtao ning katawhayan sa mga tawo? Bukon, ang matuod nagkari ako diri para buyag-buyagon ang mga tawo. ");
INSERT INTO rol_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kay tunà niyan, tungod sa akon, magakinontrahan ang mga tawo sa isa kag isa. Ang lima sa isa ka pamilya hay matutungà, ang tuyo kontra sa duha kag ang duha naman kontra sa tuyo. ");
INSERT INTO rol_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Magakinontrahan ang mga tatay kag ang inda mga ungà nga lyaki. Magakinontrahan da ang mga nanay kag ang inda mga ungà nga babayi. Imaw da ang mga panugangan nga babayi kag ang inda mga umagad nga babayi.” ");
INSERT INTO rol_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Pagkatapos naghambay si Hesus sa kadamò nga tawo, “Kung makità nindo ang panganod halin sa weste, nagahambay kamo nga daan, ‘Mauyan na,’ kag imaw gid ang natatabò. ");
INSERT INTO rol_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kag kung magahuyop na halin sa sur nagahambay kamo, ‘Magainit na ini,’ kag imaw gid ang natatabò. ");
INSERT INTO rol_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mga hipokrito! Antigo kamo magsirò sa dutà kag sa langit para masayuran nindo kung magainit o magauyan, pero basì indì kamo makaintindi kung ano ang gusto hambayon ng mga tandà sa ini nga tyempo?” ");
INSERT INTO rol_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Basì indì kamo makadesisyon ning maayo kung ano ang tamà? ");
INSERT INTO rol_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Halimbawà, kung may mag-akusar sa imo, magpakighusay ka sa iya mintras nagakadto pa lang kamo sa korte. Kay basì kung piliton ka gid niya nga day-on sa hukom kag itugyan ka naman ng hukom sa gwardya para prisuhon. ");
INSERT INTO rol_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ginahambay ko sa imo, indì ka gid makaluwas sa prisuhan hasta indì mo mabayaran ang tanan nga multa.” ");
INSERT INTO rol_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","May nag-abot nga mga tawo nga nagbalità kay Hesus kung ano ang natabò sa mga taga-Galilea nga gingpapatay ni Pilato mintras nagahalad sinda sa Dios. ");
INSERT INTO rol_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Nagsabat si Hesus sa inda, “Kalaom ba nindo natabò ini sa inda kay mas kadakò ang inda salà kaysa sa iban nga taga-Galilea? ");
INSERT INTO rol_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Bukon! Tandai nindo ining akon ginahambay: kung indì kamo magtalikod sa indo salà, mamatay da kamo tanan pareho ninda. ");
INSERT INTO rol_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Dumduma nindo ang 18 ka tawo nga natumbahan ning tore sa Siloam. Kalaom ba nindo mas kadakò ang inda kasal-anan kaysa sa tanan nga taga-Jerusalem? ");
INSERT INTO rol_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Bukon! Tandai nindo ining akon ginahambay: kung indì kamo magtalikod sa indo salà, mamatay da kamo pareho ninda.” ");
INSERT INTO rol_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Pagkatapos gingtudluan sinda ni Hesus paagi sa ini nga parabola: “May tawo nga nagtanom ning igos* sa iya ubasan. Gingkadto niya ini kag gingtan-aw kung igwa ning bunga pero wayà siya may nakità. ");
INSERT INTO rol_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Nganì naghambay siya sa miyugbantay ng ubasan, ‘Tuyo na ka tuig ako gapabalik-balik diri para tan-awon kung igwa na ning bunga ining igos, pero wayà pa gihapon. Pukana na iton kay ginakaon lang ang abuno sa dutà.’ ");
INSERT INTO rol_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Pero nagsabat ang miyugbantay, ‘Nong, pabay-an ta lang anay ning isa pa ka tuig kay kutkutan ko ang alihid kag abunuhan. ");
INSERT INTO rol_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kung magbunga ini sa masunod nga tuig hay maayo gid, pero kung indì puydi mo na ini ipapukan.’ ” ");
INSERT INTO rol_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Isa ka Adlaw nga Inugpahuway*, nagkadto si Hesus sa sinagoga kag nagtudlò. ");
INSERT INTO rol_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Igwa didto ning babayi nga ginapasakitan ng malain nga espiritu sa suyod ng 18 ka tuig. Siya hay nagakòkò kag indì gid matadlong ang iya lawas. ");
INSERT INTO rol_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Nang makità siya ni Hesus, gingtawag niya nga magpalapit kag ginghambay, “Manang, magaayo ka na sa imo sakit.” ");
INSERT INTO rol_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Gingtungtong ni Hesus ang iya kamot sa babayi kag nagtadlong nga daan ang iya lawas kag gingdayaw niya ang Dios. ");
INSERT INTO rol_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pero ang opisyal ng sinagoga hay nahangit kay Hesus tungod nagpaayo siya sa Adlaw nga Inugpahuway. Naghambay siya sa mga tawo, “Igwa unom ka adlaw sa isa ka simana para magtrabaho. Dapat adto nga mga adlaw kamo magkari para paayuhon kamo, bukon sa Adlaw nga Inugpahuway.” ");
INSERT INTO rol_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Nagsabat ang Ginoo sa iya, “Mga hipokrito! Dì ba ginahubad nindo ang higot ng indo baka o asno kag day-on sa tubì para makainom aber sa Adlaw nga Inugpahuway? ");
INSERT INTO rol_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ini nga babayi hay inapo ni Abraham. Ginggapos siya ni Satanas sa suyod ng 18 ka tuig. Dì ba dapat buhian siya aber sa Adlaw nga Inugpahuway?” ");
INSERT INTO rol_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Nang ginghambay ini ni Hesus, napahuyà ang nagakontra sa iya. Ang iban naman nga mga tawo nalipay sa mga makatitingaya nga butang nga ginghuman ni Hesus. ");
INSERT INTO rol_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Nagpadayon pa gid si Hesus sa pagtudlò. Hambay niya, “Ano ang kapareho ng paghaharì ng Dios? Sa diin ko ini ikumpara? ");
INSERT INTO rol_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ang paghaharì ng Dios hay pareho sa maisot nga busoy ng mustasa* nga gingtanom ng tawo sa iya gardin. Nagatubò ini kag nagabahoy pareho sa kahoy kag aber ang mga pispis puydi makapugad sa sanga.” ");
INSERT INTO rol_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Naghambay pa si Hesus, “Sa diin ko pa ikumpara ang paghaharì ng Dios? ");
INSERT INTO rol_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Pareho ini sa pampaalsa nga ginahalò ng isa ka babayi sa kadakò nga arina nga iya pagamasahon, hasta nga magaalsa gid ang bilog nga minasa.” ");
INSERT INTO rol_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Mintras nagapakadto si Hesus sa Jerusalem, nag-agi anay siya sa mga banwa kag mga baryo kag nagpanudlò. ");
INSERT INTO rol_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","May nagpangutana sa iya, “Ginoo, kalakà lang ba ang mga tawo nga maluwas?” Nagsabat si Hesus paagi sa parabola, ");
INSERT INTO rol_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Magtinguhà gid kamo nga makasuyod sa makitid nga pwertahan. Kay ginahambay ko sa indo, kadamò ang nagatinguhà nga makasuyod pero indì makasuyod. ");
INSERT INTO rol_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kay kung ang tag-iya ng bayay hay magpanarangka na, kamo nga yarà sa luwas nga nagatinindog, aber magpinanuktok kamo kag maghambay, ‘Ginoo, pasuyura kami,’ masabat siya sa indo, ‘Wayà ko kamo nakikilaya kag wayà ko nasasayuri kung sa diin kamo maghalin!’ ");
INSERT INTO rol_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Niyan mahambay kamo, ‘Dì ba nagkaon kag nag-inom kami kaibahan mo kag nagtudlò ka pa sa amon banwa?’ ");
INSERT INTO rol_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Pero masabat siya sa indo, ‘Wayà ko kamo nakikilaya kag wayà ko nasasayuri kung sa diin kamo maghalin! Palayò kamo sa akon, tanan kamo nga mga nagahuman ning malain!’ ");
INSERT INTO rol_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Magadinanguyngoy kamo kag magapinagot ang indo ngipon kung makità nindo sina Abraham, Isaac, Jacob kag ang tanan nga propeta nga yadto sa gingharian ng Dios, pero kamo naman hay palayason! ");
INSERT INTO rol_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Kadamò-damò nga tawo halin sa tanan nga parte ng kalibutan ang magapungkò sa punsyon sa gingharian ng Dios. ");
INSERT INTO rol_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Matuod gid nga may mga nauulihi nga mauuna; kag may mga nauuna nga mauulihi.” ");
INSERT INTO rol_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Pagkahambay ini ni Hesus, nagpalapit ang iban nga mga Pariseo sa iya kag naghambay, “Mas maayo kung maghalin ka diri kay gusto ni Herodes nga ipapatay ka.” ");
INSERT INTO rol_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Pero nagsabat si Hesus sa inda, “Hambayi nindo adtong malain nga tawo, nagapalayas pa ako ng mga demonyo kag nagapang-ayo ng mga may sakit arinyan hasta buwas kag sa ikatuyo ka adlaw matatapos ko na ang akon ginahuman. ");
INSERT INTO rol_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pero kahinangyan gida nga magpadayon ang akon pagpanaw niyan, buwas kag sa masunod nga adlaw hasta mag-abot ako sa Jerusalem kay indì puydi nga patyon ang propeta sa iban nga lugar kundì dapat gid hay sa Jerusalem. ");
INSERT INTO rol_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Kamo nga mga taga-Jerusalem! Ginapamatay nindo kag ginapambugoy ang mga propeta nga gingsugò ng Dios sa indo. Madamò ka beses nga gusto ko kuntà kamo tipunon kag diparahon nga daw sa mungà nga ginakuuban ang iya isiw sa idayom ng iya pakpak, pero indì nindo gusto! ");
INSERT INTO rol_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Niyan, pabay-an na kamo ng Dios! Tandai nindo ini, indì na gid nindo ako makikità hasta mag-abot ang adlaw nga magahambay kamo, ‘Malipayon ang ginapakari diri ng Ginoo.’ ” ");
INSERT INTO rol_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Isa ka Adlaw nga Inugpahuway, ging-agda si Hesus ng isa ka pinunò ng mga Pariseo* nga magkaon sa iya bayay. Pag-abot niya didto, gingpanid-an siya maayo ng mga tawo nga nagakontra sa iya kung ano ang iya humanon. ");
INSERT INTO rol_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Adto da nga oras, may tawo sa atubangan ni Hesus nga ang bilog nga lawas hay nagapanghubag. ");
INSERT INTO rol_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Nagpangutana si Hesus sa mga miyugtudlò ng Kasuguan kag mga Pariseo, “Ginatugot ba ng Kasuguan nga magpang-ayo sa mga may sakit sa Adlaw nga Inugpahuway o wayà?” ");
INSERT INTO rol_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pero wayà sinda nagsabat. Nganì ginghawiran ni Hesus ang may sakit kag gingpaayo. Pagkatapos gingpapanaw na siya ni Hesus. ");
INSERT INTO rol_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Naghambay si Hesus sa mga tawo, “Halimbawà, igwa kamo ungà o baka nga nahuyog sa bal-ong, pabay-an lang ba nindo kay Adlaw nga Inugpahuway? Syempre indì! Haw-ason nindo nga daan.” ");
INSERT INTO rol_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Pero wayà sinda nakasabat sa iya pangutana. ");
INSERT INTO rol_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Nakità ni Hesus nga ang mga imbitado hay nagapilì ng pinakamaayo nga mga pungkuan. Nganì naghambay siya sa inda paagi sa parabola. ");
INSERT INTO rol_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Kung imbitaron ka sa kasayan, ayaw pagpilia ang pungkuan nga para sa mga halangdon nga tawo. Kay basì kung may ging-imbitar pa gid nga mas halangdon kaysa sa imo ");
INSERT INTO rol_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","kag ang nag-imbitar sa imo hay magapalapit sa imo kag maghambay, ‘Halin anay dirà kay nakatagana na ini nga pungkuan para sa ini nga tawo.’ Mapapahuyà ka kag didto ka lang mapungkò sa ordinaryo nga pungkuan. ");
INSERT INTO rol_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Nganì kung imbitaron ka, pilia ang pungkuan para sa mga ordinaryo, para pag-abot ng nag-imbitar, palapitan ka niya kag maghambay, ‘Amigo, didto ka sa maayo nga pungkuan.’ Niyan mapadunggan ka sa atubangan ng tanan nga mga imbitado. ");
INSERT INTO rol_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kay ang aber sin-o nga nagapakataas ng iya kaugalingon hay ginapaubos, pero ang nagapaubos ng iya kaugalingon hay ginapataas.” ");
INSERT INTO rol_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Niyan naghambay si Hesus sa nag-agda sa iya, “Kung magpang-agda ka nga mag-igmà o mag-ihapon, ayaw pag-agdaha ang imo mga amigo, maguyáng kag manghod, hali, o ang imo mga kalapit nga manggaranon kay agdahon ka da ninda kag mabaton mo na ang imo bayos. ");
INSERT INTO rol_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Pero kung may papunsyon ka, imbitaron mo ang mga pobre, mga lupog, mga pakì kag mga buta ");
INSERT INTO rol_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Kung tiyad ini ang imo humanon, bulahan ka kay indì sinda makabayos sa imo. Ang Dios imaw ang magabayos sa imo pag-abot ng adlaw nga banhawon ang mga matarong.” ");
INSERT INTO rol_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nang mabatian ini ng tawo nga katupad ni Hesus sa pagkaon, naghambay siya, “Bulahan ang tawo nga makakaibahan sa pagkaon sa papunsyon sa gingharian ng Dios!” ");
INSERT INTO rol_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nganì nagtudlò si Hesus sa iya paagi sa parabola. “May tawo nga nagpreparar ning dakò nga papunsyon kag kadamò ang iya gingpang-imbitar. ");
INSERT INTO rol_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Pag-abot ng oras nga makaon na sinda, gingsugò niya ang iya ulipon nga sugaton ang mga imbitado kag hambayon, ‘Kari na kamo! Kay preparado na ang tanan!’ ");
INSERT INTO rol_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pero ang kada isa sa inda hay nagbalibad nga indì sinda makakadto. Naghambay ang isa, ‘Bag-o lang ako nakabakay ng dutà kag kahinangyan nga kadtuon ko kag tan-awon. Pasensya lang gid kay indì ako makakarà.’ ");
INSERT INTO rol_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Hambay naman ng isa, ‘Bag-o lang ako nakabakay ng napuyò ka bilog nga baka kag siruon ko anay kung maayo. Pasensya lang gid kay indì ako makakarà.’ ");
INSERT INTO rol_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Naghambay pa gid ang isa, ‘Bag-o lang ako gingkasay, nganì indì ako makakarà.’ ");
INSERT INTO rol_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Nganì nagbalik ang ulipon sa iya amo kag gingbalità ang natabò. Nahangit gid ang amo kag naghambay sa iya, ‘Kadto nga daan sa mga karsada kag mga kalye ng aton banwa kag day-a diri ang mga pobre, mga lupog, mga buta kag mga pakì.’ ");
INSERT INTO rol_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Pagbalik ng ulipon, naghambay siya, ‘Nong, gingtuman ko na ang imo sugò, pero madamò pa gid bakanti nga pungkuan.’ ");
INSERT INTO rol_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Nganì naghambay ang amo sa iya, ‘Kadto sa mga dayan sa luwas ng banwa kag piliton mo ang mga tawo nga imo makità nga magkari diri para mapunò ang akon bayay. ");
INSERT INTO rol_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ginahambay ko sa indo, ang una nga ging-agda, indì gid makatilaw ng akon gingpreparar!’ ” ");
INSERT INTO rol_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Niyan kadamò ang tawo nga nagnunot kay Hesus; kag nag-atubang siya sa inda kag naghambay, ");
INSERT INTO rol_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Kung may tawo nga gusto magsunod sa akon, pero mas ginapalabi niya ang iya tatay kag nanay, asawa kag mga ungà, mga maguyáng kag manghod kag patì ang iya kaugalingon nga kabuhì, indì siya angay nga maging disipulo ko. ");
INSERT INTO rol_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kag ang aber sin-o nga indì magpas-an ng iya kaugalingon nga krus kag magsunod sa akon, indì siya angay nga maging disipulo ko. ");
INSERT INTO rol_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ang tawo nga gusto magsunod sa akon hay pareho sa tawo nga nagaplano nga magpatindog ning tore. Una, kwentahon anay niya kung pila ang magagastos kag kung mag-igò ang iya kwarta hasta matapos ini. ");
INSERT INTO rol_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Basì kung pundasyon lang ang iya mabutang kag indì naman niya ini mapatapos, nganì insultuhon lang siya ng tanan nga makakità. ");
INSERT INTO rol_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Mahambay sinda, ‘Gingpatunaan lang niya ang pagpaugdok, pero wayà da mapatapos.’ ");
INSERT INTO rol_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","O igwa ba harì nga gusto magpakiggira sa iban nga harì, nga wayà anay nagapungkò para magplano maayo kung ang iya sundalo nga 10,000 hay magadaog arà kontra sa 20,000? ");
INSERT INTO rol_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kung sa iya isip, indì siya magdaog, maayo pa nga mintras wayà pa ang iya kaaway, magsugò siya ning representanti para maghambay sa kaaway nga gusto niya magpakig-ayos. ");
INSERT INTO rol_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Imaw da inà ang dapat nindo humanon. Hunahunaon anay nindo maayo kung gusto gid nindo magsunod sa akon. Kay indì kamo angay nga maging disipulo ko kung indì nindo bayaan ang tanan nga indo ginapalabi.” ");
INSERT INTO rol_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Ang asin hay maayo, pero kung maduyà na ang sabor ng asin, pauno pa ini mapabalik? ");
INSERT INTO rol_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Wayà na gid ini puyos aber pang-abuno sa dutà. Nganì ginapilak na lang. Dapat intindihon gid nindo maayo ang indo nababatian.” ");
INSERT INTO rol_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Isa ka adlaw, kadamò nga miyugsukot ng buhis kag makasasalà ang nagpalapit kay Hesus para magpamatì ng iya mga ginatudlò. ");
INSERT INTO rol_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Pero nagreklamo ang mga Pariseo kag mga eskriba, hambay ninda, “Basì ginabaton ng ini nga tawo ang mga makasasalà kag nagakaon pa kaibahan ninda?” ");
INSERT INTO rol_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Nganì gingtudluan sinda ni Hesus paagi sa parabola. ");
INSERT INTO rol_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Kung ikaw igwa 100 nga karnero kag naduyà ang isa, ano ang imo humanon? Syempre bayaan mo ang 99 sa pasabsaban kag pangitaon ang naduyà hasta nga makità mo ini. ");
INSERT INTO rol_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Kung makità mo na, malilipay ka kag pas-anon mo ini pabalik. ");
INSERT INTO rol_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Pag-abot mo sa bayay, tawagon mo ang imo mga amigo kag mga kalapit kag mahambay sa inda, ‘Kari kamo, magkalipay kita kay nakità ko na ang akon karnero nga naduyà!’ ");
INSERT INTO rol_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ginahambay ko sa indo, mas kadakò ang kalipay sa langit tungod sa isa ka makasasalà nga nagtalikod kag nagbayà sa iya salà, kaysa sa 99 ka matarong nga wayà nagakahinangyan magtalikod sa salà.” ");
INSERT INTO rol_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Kung may babayi nga may napuyò ka bilog nga drachma*, ano baya ang humanon niya kung naduyà ang isa? Dì ba sug-an niya ang iwagan kag silhigan niya maayo ang iya bayay kag pangitaon ang isa ka bilog nga drachma hasta makità niya ini? ");
INSERT INTO rol_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Kung makità na ini, tawagon niya ang iya mga amiga kag mga kalapit kag mahambay sa inda, ‘Kari kamo, magkalipay kita kay nakità ko na ang akon isa ka drachma nga naduyà!’ ");
INSERT INTO rol_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ginahambay ko sa indo, magakalipay ang mga anghel ng Dios kung ang isa ka makasasalà hay magtalikod sa iya salà.” ");
INSERT INTO rol_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Pagkatapos naghambay pa gid si Hesus, “Igwa tatay nga may duha ka ungà nga lyaki. ");
INSERT INTO rol_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Naghambay ang manghod sa iya tatay, ‘Tay, taw-an na abi sa akon ang panublion ko.’ Nganì gingparte ng tatay ang iya mga pagkabutang sa iya duha ka ungà. ");
INSERT INTO rol_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Pagkaligad ng pila ka adlaw, gingpamaligyà ng manghod ang iya parte kag nagkadto sa malayò nga lugar. Kag didto ginggastos niya ang iya manggad sa wayà gid kapuyos-puyos. ");
INSERT INTO rol_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nang maubos na ang iya kwarta, nag-abot ang taggutom sa adto nga lugar. Nahugaan gid siya. ");
INSERT INTO rol_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nganì nagtrabaho siya didto kag ginghuman siya nga miyugbahog ng mga baboy sa uma. ");
INSERT INTO rol_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Sa sobra niya nga kagutom gusto kuntà niya magkaon aber bahog ng baboy, ugaling lang wayà gid may nagatao sa iya. ");
INSERT INTO rol_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Pero nang makatagumpaaw siya, naghambay siya sa iya kaugalingon, ‘Taya! Nagapanunubra ang pagkaon ng mga suluguon ng akon tatay, pero ako mamamatay na sa sobra nga kagutom! ");
INSERT INTO rol_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Maayo pa, mabalik na lang ako kag mahambay sa iya, “Tay, nakasalà ako sa Dios kag sa imo. ");
INSERT INTO rol_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Indì na ako angay nga tawagon mo nga imo ungà. Kabiga na lang ako nga isa sa imo suluguon.” ’ ");
INSERT INTO rol_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Nganì nag-ulì siya sa inda. Mintras malayò-layò pa, nakità siya ng iya tatay kag naluoy gid siya. Nganì sa sobra nga kaluoy, nagdyagan siya kag gingsumpong ang iya ungà, gingkupkupan kag gingharuan. ");
INSERT INTO rol_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Hambay ng iya ungà, ‘Tay, nakasalà ako sa Dios kag sa imo. Indì na ako angay nga tawagon mo nga imo ungà.’ ");
INSERT INTO rol_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pero gingtawag ng tatay ang iya mga ulipon kag naghambay, ‘Dalì, buy-a nindo ang pinakamaayo nga barò kag isuksok sa iya! Butangi da nindo siya ning singsing kag suksuki ng sandalyas. ");
INSERT INTO rol_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Pagkatapos buy-a nindo ang gingpatambok nga batà nga baka kag ihawon! Makaon kita kag magkalipay! ");
INSERT INTO rol_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kay ining akon ungà hay daw namatay na, pero arinyan siya hay nabuhì. Naduyà siya pero niyan nakità.’ Nganì nagkalipay sinda tanan! ");
INSERT INTO rol_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Natabò ini nang yadto pa sa uma ang iya panganay. Nang mag-ulì na siya kag malapit na sa bayay, nabatian niya ang sunata kag may nagasinaot. ");
INSERT INTO rol_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Gingtawag niya ang isa sa inda mga suluguon kag nagpangutana, ‘Basì, anong igwa sa aton?’ ");
INSERT INTO rol_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Nagsabat siya, ‘Ang imo manghod nagbalik na kag gingpaihawan ng imo tatay ng gingpatambok nga baka kay nakabalik kuno siya nga maayo ang kamutangan.’ ");
INSERT INTO rol_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Pagkabatì adto, nahangit gid siya kag wayà nagsuyod sa inda bayay. Nganì nagluwas ang iya tatay kag ging-ayam-ayaman siya nga magsuyod. ");
INSERT INTO rol_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Pero nagsabat siya, ‘Tay, pila ka tuig na ang akon pagtrabaho sa imo nga daw ako hay ulipon kag ginatuman ko ang tanan mo nga ginasugò. Pero aber kambing lang, wayà mo gid ako pagtaw-i para magkalipay kaibahan ng akon mga amigo! ");
INSERT INTO rol_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pero pagbalik ng imo ungà nga nagwaldas ng tanan mo nga manggad sa mga babayi nga bayaran, gingpaihawan mo pa siya ning gingpatambok nga baka!’ ");
INSERT INTO rol_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Pero nagsabat ang iya tatay, ‘Nonò, yari ka permi sa akon kag ang tanan nga akon hay imo da. ");
INSERT INTO rol_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pero dapat kita magkalipay, kay ang imo manghod nga ang kalaom naton namatay na hay buhì pa galì! Naduyà siya pero nakità na naton liwat!’ ” ");
INSERT INTO rol_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Pagkatapos adto, nagtudlò pa gid si Hesus sa iya mga disipulo. Hambay niya, “Igwa ning manggaranon nga may tagapamahayà ng iya manggad. Pero may nagbalità nga ginawaldas niya ang manggad ng iya amo. ");
INSERT INTO rol_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nganì gingpatawag ng manggaranon adtong tagapamahayà kag gingpangutana, ‘Ano ining nababatian ko parti sa imo? Sige, taw-an sa akon ang listahan ng akon mga manggad nga gingtugyan ko sa imo kay pahalinon ko na ikaw.’ ");
INSERT INTO rol_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Naghambay ang miyugpamahayà sa iya kaugalingon, ‘Ano baya ang akon humanon kay pahalinon na ako ng akon amo? Indì ko kaya ang mabug-at nga trabaho pareho ng pag-arado kag nahuyà da ako nga magpalimos. ");
INSERT INTO rol_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ah, sayod ko na ang akon humanon. Aber pahalinon ako, igwa pa ako may kadtuan nga tawo nga magabaton sa akon sa inda bayay.’ ");
INSERT INTO rol_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Nganì gingpatawag niya ang kada isa nga may utang sa iya amo. Nagpangutana siya sa una, ‘Pila ang imo utang sa akon amo?’ ");
INSERT INTO rol_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nagsabat siya, ‘100 ka lata nga lana.’ Naghambay ang miyugpamahayà, ‘Sige, yari ang imo resibo. Dalì! Pungkò kag isulat ang 50.’ ");
INSERT INTO rol_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Gingpangutana naman niya ang pangaduha nga may utang, ‘Pila ang imo utang sa akon amo?’ Nagsabat siya, ‘100 ka kustal nga trigo.’ Hambay ng miyugpamahayà sa iya, ‘Sige, yari ang imo resibo. Isulat nga 80 na lang.’ ");
INSERT INTO rol_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Nang masayuran ng amo ang ginghuman ng adto nga switik nga miyugpamahayà, gingpakadakò niya ini bukon tungod sa iya pagkaswitik kundì kay antigo siya magpreparar para sa iya paabuton. Kay ang mga tawo nga wayà nagatuo sa Dios hay mas mayad maghuman ng paagi kaysa sa mga nagatuo sa Dios.” ");
INSERT INTO rol_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Kag nagpadayon pa si Hesus, “Nganì ginahambay ko sa indo, gamita ang indo manggad sa kalibutan para sa kaayuhan ng iban. Agud kung mag-abot ang oras nga wayà na puyos ini nga manggad, malilipay gid kamo nga batunon sa istaran nga wayà katapusan. ");
INSERT INTO rol_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ang tawo nga masaligan sa maisot nga butang, masasaligan da sa madakò. Ang tawo nga madayà sa maisot nga butang, madayà da sa madakò. ");
INSERT INTO rol_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nganì kung indì kamo masaligan sa manggad diri sa kalibutan, masasaligan ba kamo sa matuod nga manggad didto sa langit? ");
INSERT INTO rol_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Kag kung indì kamo masaligan sa manggad ng iban, sin-o ang matao sa indo ning manggad nga para sa indo? ");
INSERT INTO rol_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Wayà suluguon nga nagaserbisyo sa duha ka amo, kay sikwayon niya ang isa kag higugmaon ang isa. O magiging matutom siya sa isa kag baliwayaon ang isa. Indì kamo makaserbisyo ng dungan sa Dios kag sa manggad.” ");
INSERT INTO rol_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Nang mabatian ini ng mga Pariseo, gingngitlan kag ging-insulto ninda si Hesus kay hakog sinda sa kwarta. ");
INSERT INTO rol_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Nganì naghambay si Hesus sa inda, “Kamo hay nagapakità-kità lang sa mga tawo nga daw maayo kamo. Pero sayod ng Dios kung ano gid ang yarà sa indo tagipusuon. Kay kung ano ang ginapalabi ng tawo hay kahigkò-higkò sa panirò ng Dios. ");
INSERT INTO rol_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Bago mag-abot si Juan nga Miyugbawtismo, ginasunod ng mga tawo ang Kasuguan ng Dios nga gingtao sa aton paagi kay Moises kag sa mga propeta. Pero tunà ng pag-abot ni Juan, ginatudlò na ang Maayong Balità parti sa gingharian ng Dios kag madamò gid ang nagapamilit nga magapasakop didto. ");
INSERT INTO rol_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Pero bukon gusto hambayon nga wayà na puyos ang Kasuguan. Mas madalì pa maduyà ang langit kag dutà kaysa maging wayà puyos ang aber kaisot nga parte ng litra sa Kasuguan. ");
INSERT INTO rol_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Ang aber sin-o nga lyaki nga magbuyag sa iya asawa kag mag-asawa ng iban hay nagapangawatan. Kag kung may lyaki nga mangasawa sa babayi nga gingbuyagan, nagapangawatan da.” ");
INSERT INTO rol_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Igwa manggaranon nga nagasuksok ng mamahayon nga barò kag abunda ang pagkaon adlaw-adlaw. ");
INSERT INTO rol_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Igwa naman pobre nga ang pangayan hay Lazaro. Ang iya lawas punò guyos. Yadto siya nagahigdà sa may pwertahan ng bayay ng manggaranon, ");
INSERT INTO rol_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","kay gusto kuntà niya makakaon aber uyak nga nagakahuyog sa lamisa ng manggaranon. Ginapalapitan siya ng mga ayam kag ginadinilaan ang iya guyos. ");
INSERT INTO rol_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Nang ulihi namatay si Lazaro kag gingdaya siya ng mga anghel sa alihid ni Abraham. Wayà magdugay, namatay da ang manggaranon kag ginglubong. ");
INSERT INTO rol_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Sa kahugaan nga iya nababatyagan sa Hades, nakità niya si Abraham sa malayò-layò kag yadto sa iya alihid si Lazaro. ");
INSERT INTO rol_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Nganì nagsinggit ang manggaranon, ‘Lolo Abraham, kaluy-i ako! Pakaria abi si Lazaro kag isawsaw sa tubì ang punta ng iya tudlò kag patuyuan ang akon dilà para malamigan kay sobra gid ang kainit diri ng kalayo!’ ");
INSERT INTO rol_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Pero gingsabat siya ni Abraham, ‘Apo ko, nadumduman mo ba nang yadto ka pa sa kalibutan? Abunda ka gid sa tanan nga butang. Pero si Lazaro naman hay nagtiis gid ng kahugaan. Pero niyan malipayon na siya diri kag ikaw naman hay ginahugaan dirà. ");
INSERT INTO rol_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Kag isa pa, ang imo ginapangabay indì gid puydi, kay sa tungà naton hay igwa malapad kag madayom gid nga pangpang. Nganì ang yari diri indì gid makakarà dirà kag ang yarà dirà indì gid makakari diri.’ ");
INSERT INTO rol_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Pero nagsabat ang manggaranon, ‘Lolo Abraham, kung tiyad inà nagapakitluoy gid ako sa imo. Pakadtua na lang abi si Lazaro sa bayay ng akon tatay, ");
INSERT INTO rol_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","kay may lima pa ako nga hali nga lyaki, para paandaman sinda agud indì makakari sa ini nga lugar nga punò ng kasakit.’ ");
INSERT INTO rol_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Pero nagsabat si Abraham, ‘Yadto na sa inda ang mga gingsulat ni Moises kag ng mga propeta. Dapat pamatian ninda adtong gingtudlò sa inda.’ ");
INSERT INTO rol_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Nagsabat naman ang manggaranon, ‘Lolo Abraham, indì siguro sinda magpati. Pero kung may namatay nga nabanhaw kag magkadto sa inda, matalikod sinda sa inda mga salà.’ ");
INSERT INTO rol_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Pero nagsabat si Abraham, ‘Kung indì sinda magsunod sa mga gingsulat ni Moises kag ng mga propeta, indì da sinda magpati aber may patay nga mabanhaw.’ ” ");
INSERT INTO rol_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Naghambay si Hesus sa iya mga disipulo, “Ang mga pagtintar para makasalà hay maabot gid. Pero makaluluoy gid ang mga tawo nga nagapangtintar sa iban para makasalà. ");
INSERT INTO rol_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mas maayo pa sa iya nga higutan ning galingan nga bato ang iya liog kag itagbong sa dagat kaysa siya ang maging kabangdanan nga makasalà ang isa sa ini nga bag-o nga nagatuo sa akon. ");
INSERT INTO rol_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Nganì bantayi ang indo ginahuman. “Kung makasalà ang imo utod sa imo, hambayi siya kag kung magtalikod siya sa kasal-anan, patawara siya. ");
INSERT INTO rol_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kag kung pito ka beses siya makasalà sa imo sa isa ka adlaw kag pito da siya ka beses magpalapit sa imo nga nagahambay, ‘Patawara ako,’ dapat patawaron mo.” ");
INSERT INTO rol_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Naghambay ang mga apostoles kay Hesus, “Ginoo, dugangi ang amon pagtuo!” ");
INSERT INTO rol_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Nagsabat ang Ginoo, “Kung igwa kamo ning pagtuo aber pareho lang kaisot sa busoy ng mustasa*, puydi kamo maghambay sa ini nga kahoy nga sikomoro, ‘Magabot ka kag magsaylo sa dagat!’ Kag masunod gid ini sa indo.” ");
INSERT INTO rol_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Naghambay pa si Hesus sa inda, “Sin-o sa indo ang nagahambay sa iya ulipon nga halin sa pag-arado sa uma o sa pagbantay ng mga karnero, ‘Kari, kaon na’? Syempre wayà! ");
INSERT INTO rol_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Pero ang amo magahambay, ‘Pag-ilis anay kag paglutò ng akon ihapon kag tahawi ako. Pagkatapos ikaw naman ang magkaon.’ ");
INSERT INTO rol_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ginapasalamatan ba ng amo ang ulipon tungod ginatuman niya ang sugò sa iya? Syempre wayà! ");
INSERT INTO rol_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Imaw da kamo, pagkatapos nga matuman na nindo ang akon mga sugò sa indo, hambaya lang, ‘Ulipon lang kami kag indì dapat dayawon. Nagatuman lang kami ng amon obligasyon.’ ” ");
INSERT INTO rol_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Mintras nagapanaw si Hesus pakadto sa Jerusalem, nag-agi siya sa duyunan ng probinsya ng Samaria kag Galilea. ");
INSERT INTO rol_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nang pasuyuron siya sa isa ka baryo, gingsumpong siya ng napuyò nga kitungon*. Nagatindog sinda sa malayò-layò ");
INSERT INTO rol_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","kag nagsininggit, “Hesus, Ginoo! Maluoy ka sa amon!” ");
INSERT INTO rol_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Pagkakità sa inda ni Hesus, naghambay siya, “Kadto kamo sa mga parì kag magpasirò sa inda.” Kag mintras nagapanaw sinda, nag-ayo na sinda tanan. ");
INSERT INTO rol_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Pagkakità ng isa sa inda nga maayo na siya, nagbalik siya kay Hesus nga nagasinggit ng pagdayaw sa Dios. ");
INSERT INTO rol_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Naghapà siya sa atubangan ni Hesus kag nagpasalamat. Ini nga tawo hay taga-Samaria. ");
INSERT INTO rol_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Pagkatapos naghambay si Hesus, “Bukon ba napuyò ang nag-ayo? Diin na ang siyam? ");
INSERT INTO rol_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Basì wayà sinda nagbalik para magpasalamat sa Dios, kundì ini lang ang dayuhan?” ");
INSERT INTO rol_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Nganì naghambay siya sa iya, “Magtindog ka kag magpaulì. Nag-ayo ka kay nagtuo ka sa akon.” ");
INSERT INTO rol_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Igwa mga Pariseo nga nagpangutana kay Hesus kung san-o maabot ang gingharian ng Dios. Nagsabat si Hesus sa inda, “Ang pag-abot ng gingharian ng Dios wayà tandà nga makità. ");
INSERT INTO rol_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Nganì wayà may makahambay, ‘Yari na diri!’ o ‘Yadto na didto!’ kay ang gingharian ng Dios yarà na sa indo tagipusuon.” ");
INSERT INTO rol_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Kag naghambay pa si Hesus sa iya mga disipulo, “Maabot ang tyempo nga handumon nindo nga makità ang adlaw ng pagbalik ng Ungà ng Tawo, pero indì nindo ini makikità. ");
INSERT INTO rol_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Igwa ning mga tawo nga magahambay sa indo, ‘Sirua yadto siya!’ o ‘Sirua yari siya!’ Ayaw kamo magkadto kag ayaw kamo magpati sa inda. ");
INSERT INTO rol_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kay ang pagbalik ko nga Ungà ng Tawo hay makikità ng tanan pareho ng kilat nga napapahayag ang bilog nga langit. ");
INSERT INTO rol_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero dapat anay ako mag-agi ng sobra nga mga kahugaan kag pagasikwayon ng mga tawo sa ini nga tyempo. ");
INSERT INTO rol_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Kag kung ano ang ginghuman ng mga tawo sa tyempo ni Noe, imaw da ang humanon ng mga tawo sa tyempo ng pagbalik ko nga Ungà ng Tawo. ");
INSERT INTO rol_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nang adto nga tyempo, ang mga tawo hay nagakinaon, nagaininom kag nagapinangasawa hasta sa adlaw nga nagsuyod si Noe sa arka. Nganì nag-abot ang bahà kag nagkalumos sinda tanan. ");
INSERT INTO rol_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Imaw da ang natabò nang tyempo ni Lot. Sinda hay nagakinaon, nagaininom, nagapinamakay, nagapinamaligyà, nagapinananom kag nagapinaugdok ning bayay. ");
INSERT INTO rol_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pero nang adlaw nga si Lot hay naghalin sa Sodom, nag-uyan ning kalayo kag asupre. Kag nasunog sinda tanan. ");
INSERT INTO rol_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Imaw da ini ang matatabò sa adlaw nga ako nga Ungà ng Tawo mag-abot. ");
INSERT INTO rol_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Adto nga adlaw, ang matabuan nga yarà sa luwas ng bayay hay indì na dapat magsuyod para magbuoy ng iya gamit. Patì da ang matabuan nga yadto sa uma hay indì na dapat magbalik para magbuoy ning aber ano. ");
INSERT INTO rol_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Dumduma nindo ang natabò sa asawa ni Lot! ");
INSERT INTO rol_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ang aber sin-o nga nagapalabi ng iya kabuhì hay maduduyaan ini; pero ang aber sin-o nga nagahalad ng iya kabuhì, makakabaton ng kabuhì nga wayà katapusan. ");
INSERT INTO rol_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ginahambay ko sa indo, sa adto nga gab-i, igwa duha nga nagakatuyog sa isa ka katri, ang isa buy-on kag ang isa ibilin. ");
INSERT INTO rol_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Igwa duha ka babayi nga nagabayo, ang isa buy-on kag ang isa ibilin. ");
INSERT INTO rol_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Igwa duha ka lyaki nga nagatrabaho sa uma, ang isa buy-on kag ang isa ibilin.” ");
INSERT INTO rol_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Nagpangutana ang mga disipulo kay Hesus, “Ginoo, diin ini matatabò?” Nagsabat si Hesus, “Kung diin ang may patay nga lawas, didto nagatipon ang mga buwitri.” ");
INSERT INTO rol_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Gingtudluan pa ni Hesus ang iya mga disipulo paagi sa parabola* agud permi sinda magpangamuyò kag indì maduyaan paglaom. ");
INSERT INTO rol_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Hambay niya, “Igwa hukom sa isa ka syudad nga wayà gid kahadlok sa Dios kag wayà gid pagtahod sa aber sin-o nga tawo. ");
INSERT INTO rol_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kag igwa da didto bayo nga permi nagabinalik-balik sa hukom nga nagahambay, ‘Buligi abi ako nga mataw-an hustisya ang akon kaso.’ ");
INSERT INTO rol_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Nang premiro, wayà gid magbulig ang hukom. Pero nang ulihi, nahambay niya sa iya kaugalingon, ‘Kung sa bagay, wayà ako kahadlok sa Dios kag wayà pagtahod sa aber sin-o nga tawo, ");
INSERT INTO rol_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","pero kay ginadinisturbo ako ng ini nga bayo, buligan ko na lang siya nga magkaigwa hustisya. Kay basì kung maugot lang ako sa iya pagbinalik-balik!’ ” ");
INSERT INTO rol_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Pagkatapos naghambay ang Ginoo sa inda, “Tan-awa nindo ang ginghuman ng adto nga malain nga hukom! Aber wayà siya kaluoy, gingbuligan gihapon niya adtong bayo. ");
INSERT INTO rol_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Niyan, iawà ba ng Dios ang hustisya sa iya mga gingpilì nga nagapanawag sa iya adlaw kag gab-i? Sigurado gid nga indì niya sinda pagpabay-an. ");
INSERT INTO rol_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ginahambay ko sa indo, itatao niya nga daan ang hustisya sa mga nagapangayò sa iya. Pero kung magbalik na ako nga Ungà ng Tawo diri sa kalibutan, may makikità arà ako nga mga tawo nga nagatuo sa akon?” ");
INSERT INTO rol_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","May mga tawo nga ang kalaom sinda lang gid ang maayo kag matarong sa panirò ng Dios kag ginapaubos ninda ang iban. Nganì ging-istorya sa inda ni Hesus ini nga parabola. Hambay niya, ");
INSERT INTO rol_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Igwa duha ka tawo nga nagkadto sa templo para magpangamuyò. Ang isa hay Pariseo* kag ang isa hay miyugsukot buhis. ");
INSERT INTO rol_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Nagtindog ang Pariseo kag nagpangamuyò parti sa iya kaugalingon. Hambay niya, ‘Dios ko, nagapasalamat ako sa imo nga bukon ako pareho ng iban nga tawo: mga tulisan, miyugpangluko, miyugpangawatan, o pareho ng inà nga miyugsukot buhis. ");
INSERT INTO rol_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Duha ka beses sa isa ka simana ako nagapuasa kag isa pa ginatao ko ang ikanapuyò ka parte ng tanan ko nga pinangabudlayan.’ ");
INSERT INTO rol_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Pero ang miyugsukot buhis naman hay yadto nagatindog sa malayò-layò kag indì siya makahangad sa langit, kundì ginapuypog niya ang iya dughan sa kalisod kag nagahambay, ‘Dios ko, maluoy ka sa akon nga makasasalà!’ ");
INSERT INTO rol_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ginahambay ko sa indo, nagpaulì adtong miyugsukot buhis nga ang iya kasal-anan hay gingpatawad na ng Dios. Pero ang kasal-anan ng adtong Pariseo hay wayà gingpatawad. Kay ang aber sin-o nga nagapakataas ng iya kaugalingon ginapaubos, pero ang nagapaubos ng iya kaugalingon ginapataas.” ");
INSERT INTO rol_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Isa ka adlaw, may mga tawo nga nagdaya ng inda mga ungà kay Hesus para itungtong ang iya kamot sa inda kag bendisyunan. Nang makità ini ng iya mga disipulo, gingsabyaw ninda adtong mga tawo. ");
INSERT INTO rol_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pero gingtawag ni Hesus ang mga ungà nga magpalapit sa iya kag naghambay sa iya mga disipulo, “Pabay-i lang nindo ang mga ungà nga magpalapit sa akon. Ayaw nindo sinda pagpunggi, kay ang mga kapareho ninda imaw ang nagapasakop sa paghaharì ng Dios. ");
INSERT INTO rol_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Sa matuod lang ginahambay ko sa indo, ang aber sin-o nga indì magpasakop sa paghaharì ng Dios pareho ng isa ka ungà, indì gid siya makasuyod sa gingharian ng Dios.” ");
INSERT INTO rol_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","May isa ka pinunò ang nagpangutana kay Hesus, “Maayo nga Maestro, ano baya ang dapat ko humanon agud makapanublì ning kabuhì nga wayà katapusan?” ");
INSERT INTO rol_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Nagsabat si Hesus sa iya, “Basì gingtawag mo ako nga maayo? Wayà gid ng iban nga maayo kundì ang Dios lang. ");
INSERT INTO rol_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Parti sa imo pangutana, nasayuran mo na ang mga sugò ng Dios: Ayaw magpangawatan, ayaw magpamatay, ayaw magpangawat, ayaw magtestigo ng pinusong, tahura ang imo tatay kag nanay.” ");
INSERT INTO rol_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Naghambay siya, “Ini tanan hay natuman ko na magtunà nang ungà pa ako.” ");
INSERT INTO rol_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nang mabatian ni Hesus ang iya sabat, naghambay siya, “Isa na lang ang kuyang sa imo. Baligyaan ang tanan mo nga propidad kag ipanao ang kwarta sa mga pobre. Sa ini nga paagi, magakaigwa ka manggad sa langit. Pagkatapos magbalik ka kag magsunod sa akon.” ");
INSERT INTO rol_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nang mabatian adto ng pinunò, nalisod gid siya kay sobra gid siya ka manggaranon. ");
INSERT INTO rol_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Pagkakità ini ni Hesus, naghambay siya, “Mahugà gid para sa manggaranon ang makasuyod sa gingharian ng Dios! ");
INSERT INTO rol_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Mas malupos pa nga mag-agi ang kamelyo sa buhò ng dayom kaysa sa manggaranon nga makasuyod sa gingharian ng Dios.” ");
INSERT INTO rol_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Nagpangutana ang mga nagapamatì, “Kung tiyad inà, sin-o lang ang maluwas?” ");
INSERT INTO rol_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Nagsabat si Hesus, “Ang imposible sa mga tawo posible sa Dios.” ");
INSERT INTO rol_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Niyan naghambay si Pedro, “Hay kami, gingbayaan namon ang amon pamilya kag nagnunot sa imo.” ");
INSERT INTO rol_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Naghambay si Hesus, “Sa matuod lang ginahambay ko sa indo, wayà tawo nga nagbayà ng iya bayay, asawa, mga maguyáng kag manghod, mga ginikanan kag mga ungà tungod sa gingharian ng Dios, ");
INSERT INTO rol_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","nga indì makabaton ng sobra pa gid sa ini nga kabuhì. Kag sa paabuton, makakabaton siya kabuhì nga wayà katapusan.” ");
INSERT INTO rol_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Gingbuyag ni Hesus ang iya dose nga disipulo sa mga tawo kag naghambay, “Pamatì kamo! Nagapatukad kita sa Jerusalem kag didto matuman ang tanan nga gingsulat ng mga propeta parti sa akon nga Ungà ng Tawo. ");
INSERT INTO rol_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kay dakpon ako kag itugyan sa mga bukon Judio* kag insultuhon, pakahuy-an kag pil-an. ");
INSERT INTO rol_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Latiguhon gid ninda ako ng tudo kag pagkatapos patyon. Pero sa ikatuyo ka adlaw, mabanhaw ako.” ");
INSERT INTO rol_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pero wayà gid makaintindi ang mga disipulo sa inda nabatian kay gingtagò sa inda kung ano ang gusto hambayon ng ginghambay ni Hesus. ");
INSERT INTO rol_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Nang malapit na si Hesus sa Jerico, may isa ka buta didto nga nagapungkò kag nagapalimos sa alihid ng karsada. ");
INSERT INTO rol_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Pagkabatì niya nga nagaagi ang madamò nga tawo, nagpangutana siya kung ano ang natatabò. ");
INSERT INTO rol_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Nagsabat ang mga tawo, “Nagaagi si Hesus nga taga-Nazaret.” ");
INSERT INTO rol_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Nganì nagsinggit siya, “Hesus, inapo ni David, kaluy-i ako!” ");
INSERT INTO rol_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Gingsabyaw siya nga maghipos ng mga nauna kay Hesus. Pero gingkusugan pa gid nganì niya ang pagsinggit, “Inapo ni David, kaluy-i ako!” ");
INSERT INTO rol_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nagduyog si Hesus kag nagsugò nga day-on ang buta sa iya. Pag-abot ng buta gingpangutana siya ni Hesus, ");
INSERT INTO rol_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ano ang gusto mo nga humanon ko para sa imo?” Nagsabat ang buta, “Ginoo, gusto ko kuntà nga makakità liwat.” ");
INSERT INTO rol_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Naghambay si Hesus sa iya, “Makakakità ka na. Ang imo pagtuo ang nag-ayo sa imo.” ");
INSERT INTO rol_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Kag adto nga daan nakakità na siya. Pagkatapos nagnunot siya kay Hesus nga nagadayaw sa Dios. Pagkakità ng mga tawo sa natabò, gingdayaw da ninda ang Dios. ");
INSERT INTO rol_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Nagsuyod si Hesus sa syudad ng Jerico, kay didto siya maagi pakadto sa Jerusalem. ");
INSERT INTO rol_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Igwa didto tawo nga ang pangayan hay Zaqueo. Siya ang miyugpamahayà ng mga miyugsukot buhis kag manggaranon siya. ");
INSERT INTO rol_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Gingtinguhà gid niya nga makità si Hesus kung sin-o siya. Ugaling indì niya makità si Hesus kay putot siya kag sobra gid kadamò ang tawo. ");
INSERT INTO rol_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nganì nagdyagan siya sa unahan kung sa diin maagi si Hesus kag nagsakà sa kahoy nga sikomoro. ");
INSERT INTO rol_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Pag-abot ni Hesus sa tungod ng kahoy, naghangad siya kag naghambay, “Zaqueo, dalia, panaog! Kay ini nga adlaw dapat didto ako madayon sa imo bayay.” ");
INSERT INTO rol_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nganì dalì-dalì nga nagpanaog si Zaqueo kag nalipay gid siya nga gingbaton si Hesus sa inda. ");
INSERT INTO rol_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Pero nang makità ini ng mga tawo, nagmuyumuyo sinda, “Ay taya! Nagadayon siya sa bayay ng tawo nga makasasalà!” ");
INSERT INTO rol_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nagtindog si Zaqueo sa inda atubangan kag naghambay, “Ginoo, tunà niyan, itao ko ang katungà ng akon manggad sa mga pobre. Kag kung igwa ako may gingluko, ibalik ko ang akon gingbuoy sa inda ng upat pa ka doble.” ");
INSERT INTO rol_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Naghambay si Hesus sa iya, “Ini nga adlaw nag-abot na ang kaluwasan ng ini nga pamilya. Kay gingpakità niya nga siya matuod nga inapo ni Abraham. ");
INSERT INTO rol_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kay ako nga Ungà ng Tawo* nagkari sa kalibutan agud pangitaon kag luwason sa kasal-anan ang tanan nga nagtayang.” ");
INSERT INTO rol_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Mintras nagapamatì pa ang mga tawo, nagtudlò pa gid si Hesus paagi sa parabola kay malapit na siya sa Jerusalem. Kag ang kalaom ninda matunà na nga daan ang gingharian ng Dios didto. ");
INSERT INTO rol_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Naghambay si Hesus sa inda, “Igwa halangdon nga tawo nga nagkadto sa malayò nga lugar agud koronahan siya bilang harì. Pagkatapos adto mabalik da siya. ");
INSERT INTO rol_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Bago siya naghalin, gingtawag niya ang napuyò niya nga ulipon. Gingtaw-an niya sinda ning tig-isa ka mina* kag nagtugon, ‘Inegosyo nindo ini nga kwarta mintras wayà ako.’ ");
INSERT INTO rol_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Pero hangit gid sa ini nga tawo ang iya mga kasimanwa. Nganì paghalin niya, may gingpakadto sinda didto sa gingkadtuan niya para maghambay sa miyugkorona, ‘Indì gid namon gusto ini nga tawo nga maging harì namon.’ ");
INSERT INTO rol_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pero gingkoronahan da gihapon siya. Pagbalik niya sa iya lugar, gingtawag niya ang mga ulipon nga iya gingtaw-an ning kwarta kay gusto niya masayuran kung pila na ang inda naganansya sa inda negosyo. ");
INSERT INTO rol_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Nagpalapit sa iya ang una nga ulipon kag naghambay, ‘Palanggà nga harì, ang imo kwarta nga gingtao sa akon hay nakaganansya ning napuyò ka doble.’ ");
INSERT INTO rol_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Nagsabat ang harì, ‘Maayo! Kaayo-ayo ka nga ulipon! Tungod nga masaligan ka sa maisot nga butang, magadumaya ka sa napuyò ka syudad.’ ");
INSERT INTO rol_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Nagpalapit ang pangaduha kag naghambay, ‘Palanggà nga harì, ang imo kwarta nga gingtao sa akon hay nakaganansya ning lima ka doble.’ ");
INSERT INTO rol_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Nagsabat ang harì sa iya, ‘Magadumaya ka sa lima ka syudad.’ ");
INSERT INTO rol_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Nagpalapit da sa iya ang isa pa kag naghambay, ‘Palanggà nga harì, yari ang imo kwarta nga gingtao sa akon. Gingputos ko sa panyò kag gingtagò. ");
INSERT INTO rol_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Kay hinadlukan ako sa imo kay istrikto ka. Ginabuoy mo ang ganansya ng pinangabudlayan ng iban kag ginaani mo da ang patubas aber bukon ikaw ang nagtanom.’ ");
INSERT INTO rol_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Naghambay ang harì sa iya, ‘Wayà ka puyos nga ulipon! Ang imo ginghambay imaw ang akon ihusga sa imo. Sayod mo galì nga istrikto ako kag ginabuoy ko ang ganansya ng pinangabudlayan ng iban kag ginaani ko da ang patubas aber bukon ako ang nagtanom. ");
INSERT INTO rol_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Basì wayà mo pagbutangan ang akon kwarta sa bangko para sa akon pagbalik mabuoy ko ang tubò?’ ");
INSERT INTO rol_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Pagkatapos naghambay siya sa mga nagatindog sa iya atubangan, ‘Buy-a sa iya ang kwarta kag itao sa ulipon nga nakaganansya ning napuyò!’ ");
INSERT INTO rol_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Pero nagsabat sinda, ‘Palanggà nga harì, basì dugangan mo pa ang kwarta niya? Igwa na nganì siya napuyò!’ ");
INSERT INTO rol_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Nagsabat ang harì, ‘Tandai nindo ini: ang masaligan taw-an pa gid; pero ang indì masaligan, aber ang maisot nga yarà sa iya buy-on pa. ");
INSERT INTO rol_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kag parti sa mga nagkontra sa akon kag indì gusto nga magharì ako sa inda, day-a nindo sinda diri kag pamatyon sa akon atubangan!’ ” ");
INSERT INTO rol_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Pagkahambay ini ni Hesus, nagpadayon siya kag ang iya mga kaibahan pakadto sa Jerusalem. ");
INSERT INTO rol_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nang malapit na sinda sa mga baryo ng Betfage kag Betania, sa bukid nga ginatawag, Bukid ng mga Olibo*, gingpauna ni Hesus ang iya duha nga disipulo. ");
INSERT INTO rol_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Nagbilin siya sa inda, “Mag-una kamo didto sa masunod nga baryo. Pagsuyod nindo didto, makikità nindo ang batà nga asno nga nakahigot. Wayà pa gid ini masakyi. Hubara nindo ang higot kag day-a diri. ");
INSERT INTO rol_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kung may magpangutana sa indo basì ginahubad nindo ang higot ng asno, sabata nindo, ‘Kahinangyan ini ng Ginoo.’ ” ");
INSERT INTO rol_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nganì nagpanaw sinda kag natuman gid ang ginghambay ni Hesus. ");
INSERT INTO rol_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Mintras ginahubad ninda ang higot, nagpangutana sa inda ang mga tag-iya, “Basì ginahubad nindo ang higot ng asno?” ");
INSERT INTO rol_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nagsabat sinda, “Kahinangyan ini ng Ginoo.” ");
INSERT INTO rol_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Pagkatapos gingdaya ninda ang asno kay Hesus. Pag-abot didto, ginghapinan ninda ini ng inda pangsuy-ob nga barò kag gingpasakay si Hesus. ");
INSERT INTO rol_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Mintras nagasakay siya pakadto sa Jerusalem, naglatag ang mga tawo ng inda pangsuy-ob sa karsada nga iya ginaagihan. ");
INSERT INTO rol_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Mintras nagapatugbong na si Hesus halin sa Bukid ng mga Olibo kag malapit na sa Jerusalem, nalilipay gid ang tanan niya nga disipulo. Nagsininggit sinda sa pagdayaw sa Dios tungod sa nakità ninda nga mga milagro nga ginahuman ni Hesus. ");
INSERT INTO rol_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Hambay ninda, “Ginapakamaayo ng Ginoo ang Harì nga iya gingsugò! Maayo na ang aton relasyon sa Dios. Dayawon ang Dios nga pinakamataas gid sa tanan!” ");
INSERT INTO rol_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Naghambay kay Hesus ang iban sa mga Pariseo nga yadto sa kadamuan, “Maestro, pahipusa ang imo mga disipulo!” ");
INSERT INTO rol_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Nagsabat si Hesus sa inda, “Ginahambay ko sa indo, kung maghipos sinda, ang mga bato naman ang magasininggit ng pagdayaw sa Dios.” ");
INSERT INTO rol_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Nang malapit na si Hesus sa Jerusalem kag makità niya ini, nagtangis siya kay naluoy gid siya sa mga tawo didto. ");
INSERT INTO rol_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Hambay niya, “Kung sayod lang kuntà nindo ini nga adlaw kung pauno kamo magkaigwa maayo nga relasyon sa Dios. Pero gingpaindian gihapon nindo siya, nganì ang kamatuuran hay ginatagò na sa indo. ");
INSERT INTO rol_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Magaabot ang adlaw nga palibutan kamo ning barekada ng indo mga kaaway. Kag palibutan ninda kamo para indì gid kamo makaluwas. ");
INSERT INTO rol_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Pamatyon ninda kamo tanan kag gubaon ang indo syudad nga wayà gid may mabilin nga mga bato nga nagapamagtumbaw. Matatabò ini tanan kay wayà nindo ako gingkilay-a nga gingsugò ng Dios bilang indo Manluluwas!” ");
INSERT INTO rol_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Pag-abot nina Hesus sa Jerusalem, nagsuyod siya sa templo. Gingpalayas niya didto ang mga miyugbaligyà. ");
INSERT INTO rol_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Hambay niya, “Ginahambay ng Kasulatan, ‘Ang akon bayay hay lugar nga pangamuyuan.’ Pero kamo! Ginghuman nindo nga panaguan ng mga tulisan!” ");
INSERT INTO rol_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Pagkatapos adto, nagpanudlò si Hesus sa templo adlaw-adlaw. Ang mga pinunò nga parì, mga eskriba kag mga miyugdumaya ng banwa hay nagpangità ning paagi para patyon si Hesus. ");
INSERT INTO rol_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pero wayà sinda mahuman kay kadamò ang nawiwili sa pagpinamatì sa iya ginatudlò. ");
INSERT INTO rol_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Isa ka adlaw, yadto si Hesus sa templo nga nagatudlò kag nagawali parti sa Maayong Balità sa mga tawo didto. Nagpalapit sa iya ang mga pinunò nga parì, mga eskriba* kag mga miyugdumaya ng Judio. ");
INSERT INTO rol_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Nagpangutana sinda, “Aber, balitai kami kung ano ang imo otoridad para humanon ini nga mga butang! Sin-o ang nagtao sa imo ng ini nga otoridad?” ");
INSERT INTO rol_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Nagsabat si Hesus, “May ipangutana da ako sa indo; sabata anay nindo ako. ");
INSERT INTO rol_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Diin halin ang otoridad ni Juan para magbawtismo, sa Dios ba o sa tawo?” ");
INSERT INTO rol_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Kag nagpinangutan-an sinda kung ano ang inda isabat, “Kung magsabat kita, ‘Halin sa Dios’, mangutana naman siya, ‘Basì wayà kamo nagpati kay Juan?’ ");
INSERT INTO rol_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Pero kung maghambay kita ‘Halin sa tawo’, buguyon naman kita ninda kay nagapati gid sinda nga si Juan hay propeta*.” ");
INSERT INTO rol_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nganì nagsabat sinda kay Hesus, “Wayà kami makasayod kung diin ini halin.” ");
INSERT INTO rol_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Naghambay naman si Hesus, “Indì ko da kamo pagbalitaan kung sin-o ang nagtao sa akon otoridad paghuman ng ini nga mga butang.” ");
INSERT INTO rol_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Pagkatapos nagtudlò si Hesus sa mga tawo paagi sa ini nga parabola*, “May tawo nga nagpatanom ng ubas* sa iya dutà. Pagkatapos gingpaarkila niya ang ubasan sa mga bantay kag nagkadto sa malayò nga lugar kag didto siya nagdugay. ");
INSERT INTO rol_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Pag-abot ng tigpamupò ng ubas, gingsugò niya ang iya ulipon sa mga bantay para magbuoy ng iya parte. Pero pag-abot niya didto, gingbunayan ninda kag gingpabalik nga wayà gid daya. ");
INSERT INTO rol_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Pagkatapos gingsugò naman ng tag-iya ang isa pa ka ulipon, pero imaw da gihapon ang natabò kay gingbunayan siya, gingpakahuy-an kag gingpabalik nga wayà gihapon ning daya. ");
INSERT INTO rol_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Gingsugò ng tag-iya sa ikatuyo ka beses ang isa pa ka ulipon, pero pag-abot niya didto, gingbunayan ninda hasta napilasan kag gingpalayas. ");
INSERT INTO rol_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Nganì naghunahunà ang tag-iya ng ubasan, ‘Ano baya ang akon humanon? Suguon ko na lang ang akon pinalanggà nga ungà nga lyaki. Siguro, tahuron ninda siya.’ ");
INSERT INTO rol_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pero nang makità ng mga bantay ang iya ungà, naghambay sinda sa isa kag isa, ‘Yari na ang miyugpanublì. Kari, patyon ta para maging aton na ang iya panublion.’ ");
INSERT INTO rol_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Nganì gingdaya ninda siya sa luwas ng ubasan kag gingpatay.” Pagkatapos nagpangutana si Hesus, “Ano baya ang humanon ng tag-iya ng ubasan sa inda? ");
INSERT INTO rol_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Sigurado gid nga kadtuon niya ini nga mga bantay kag pamatyon. Pagkatapos pabantayan niya ang iya ubasan sa iban.” Nang mabatian ini ng mga tawo didto sa templo, naghambay sinda, “Kabay pa nga indì pagtugutan ini ng Dios nga matabò!” ");
INSERT INTO rol_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Pero gingsirò sinda ni Hesus kag naghambay, “Ano ang gusto hambayon ng Kasulatan, ‘Ang bato nga gingpilak ng mga panday, imaw ang naging pinakaimportante nga bato sa pundasyon.’ ");
INSERT INTO rol_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ang aber sin-o nga mahuyog sa ini nga bato mababalian kag aber sin-o ang mahuyugan ng ini nga bato malulunot.” ");
INSERT INTO rol_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Nasayuran ng mga eskriba kag mga pinunò nga parì nga sinda ang ginapatamaan ng adto nga parabola. Nganì adto gid nga adlaw, dakpon kuntà ninda si Hesus. Pero nahadlok sinda sa mga tawo. ");
INSERT INTO rol_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Nganì naghuyat sinda ning tamà nga tyempo para dakpon siya. May gingsuhuyan sinda nga magapakunukuno nga mga sinsero gid sinda. Ginghuman ninda ini para may maibintang sinda kay Hesus paagi sa iya hambay, agud itugyan siya sa opisyal kag gobernador ng Roma. ");
INSERT INTO rol_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Nagpangutana adtong mga nagabantay kay Hesus, “Maestro, nasayuran namon nga matuod ang imo ginahambay kag ginatudlò kag wayà ka may ginapalabi aber sin-o. Kundì kung ano ang kamatuuran parti sa kabubut-on ng Dios sa mga tawo imaw gid ang imo ginatudlò. ");
INSERT INTO rol_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Mangutana lang kami sa imo, ginatugutan ba ng Kasuguan nga kita nga mga Judio hay magbayad ning buhis sa Emperador ng Roma o indì?” ");
INSERT INTO rol_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pero sayod ni Hesus ang inda malain nga hunahunà, nganì naghambay siya sa inda, ");
INSERT INTO rol_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Pakitaan sa akon ang denarius*. Kanin-o hitsura kag pangayan ang makikità diri?” Nagsabat sinda, “Sa Emperador.” ");
INSERT INTO rol_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Naghambay si Hesus sa inda, “Kung tiyad inà, itao nindo sa Emperador ang sa Emperador kag sa Dios ang sa Dios.” ");
INSERT INTO rol_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Wayà gid sinda may nakità nga salà sa ginghambay ni Hesus sa atubangan ng mga tawo. Nganì wayà gid sinda nakalihok kay natingaya gid sinda sa sabat ni Hesus. ");
INSERT INTO rol_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","May pila ka mga Saduceo* nga nagpalapit kay Hesus. Ini nga mga tawo hay wayà nagapati nga may pagkabanhaw. ");
INSERT INTO rol_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Nagpangutana sinda, “Maestro, nagsulat si Moises sa aton nga kung mamatay ang lyaki kag buhì ang iya asawa nga wayà makaungà, dapat ang iya manghod nga lyaki ang mangasawa sa bayo agud makaungà para sa iya maguyáng nga namatay. ");
INSERT INTO rol_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Niyan, igwa pito ka magmanghod nga lyaki. Nag-asawa ang kamaguyangan kag namatay nga wayà ungà. ");
INSERT INTO rol_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Nganì ging-asawa ang bayo ng pangaduha nga manghod kag namatay da siya. ");
INSERT INTO rol_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Pagkatapos ging-asawa naman ang babayi ng ikatuyo. Imaw da ang natabò sa tanan nga magmanghod hasta sa ikapito. Namatay sinda tanan nga wayà gid makaungà. ");
INSERT INTO rol_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Nang ulihi, namatay da ang babayi. ");
INSERT INTO rol_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Niyan, kung mag-abot na ang pagkabanhaw, kay sin-o gid asawa ang babayi? Kay sinda nga pito hay naasawa niya.” ");
INSERT INTO rol_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Nagsabat si Hesus sa inda, “Sa ini nga kalibutan, ang mga tawo hay nagapangasawa kag ginapangasawa. ");
INSERT INTO rol_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pero kung pagabanhawon ang mga patay, ang mga angay magkaigwa kabuhì nga wayà katapusan, hay indì na magpangasawa kag indì na magpaasawa. ");
INSERT INTO rol_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Kag isa pa, wayà na sinda kamatayon kay pareho na sinda ng mga anghel. Sinda hay mga ungà ng Dios kay kaibahan sinda sa mga gingbanhaw. ");
INSERT INTO rol_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kung parti sa pagkabanhaw, aber nganì si Moises hay nagpamatuod diri. Nang yadto siya sa nagadayab nga kahoy nga mababà, gingtawag niya ang Ginoo nga, ‘Dios ni Abraham, Dios ni Isaac kag Dios ni Jacob.’ ");
INSERT INTO rol_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ang Dios hay bukon Dios ng mga patay, kundì Dios ng mga buhì. Kay sa panirò ng Dios, buhì ang tanan nga namatay nga nagapati sa iya.” ");
INSERT INTO rol_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Pagkatapos naghambay ang iban sa mga eskriba, “Maestro, tamà gid ang imo sabat!” ");
INSERT INTO rol_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Nganì wayà na gid may nangahas magpangutana kay Hesus. ");
INSERT INTO rol_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Pagkatapos nagpangutana si Hesus sa mga tawo, “Basì nagahambay ang mga tawo nga ang Kristo hay inapo lang ni David? ");
INSERT INTO rol_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kay aber si David hay nagsulat sa Libro ng mga Salmo: ‘Naghambay ang Ginoo* sa akon Ginoo, Pungkò diri sa akon tuo, ");
INSERT INTO rol_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","hasta mapasukò ko sa imo ang imo mga kaaway.’ ");
INSERT INTO rol_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Kung gingtawag siya ni David nga iya Ginoo, pauno baya nga siya hay inapo lang ni David*?” ");
INSERT INTO rol_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Mintras nagapamatì ang mga tawo kay Hesus, naghambay siya sa iya mga disipulo, ");
INSERT INTO rol_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mag-andam kamo sa mga eskriba nga gusto magpinanaw nga nagabarò ning mahabà para magpakità nga importante gid sinda. Gusto gid ninda nga abi-abihon kag tahuron sa lugar nga madamò ang tawo. Kag sa mga sinagoga* o sa mga punsyunan, ginapilì gid ninda ang pungkuan nga para sa mga kilaya. ");
INSERT INTO rol_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ginaubos ninda buoy ang mga pagkabutang ng mga babayi nga bayo patì inda bayay kag ginatabon-tabunan lang ninda ang inda malain nga ginahuman paagi sa mahabà nga mga pangamuyò. Sinda hay magabaton gid ning mas sobra nga parusa halin sa Dios!” ");
INSERT INTO rol_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Mintras yadto si Hesus sa templo nakità niya ang mga manggaranon nga may mga daya nga halad* sa templo. ");
INSERT INTO rol_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Nakità da niya ang pobre nga bayo nga naghuyog ning duha lang ka bilog nga leptos*. ");
INSERT INTO rol_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Pagkatapos naghambay si Hesus sa iya mga disipulo, “Sa matuod lang ginahambay ko sa indo, mas kadakò ang ginghuyog ng adto nga pobre nga bayo kaysa sa ginghuyog ninda tanan. ");
INSERT INTO rol_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kay ang inda ginatao hay sobra na lang ng inda manggad, pero adtong bayo aber pobre hay gingtao ang tanan niya nga pangabuhian.” ");
INSERT INTO rol_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","May pila ka tawo naman ang nagaistorya parti sa templo. Ang inda ginaistoryahan hay ang mga kaayo-ayo gid nga mga bato kag ang mga dekorasyon nga gingtao ng mga nagasamba. Nganì naghambay si Hesus, ");
INSERT INTO rol_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Magaabot ang adlaw, inà tanan nga bato nga indo nakikità hay pangtumpagon. Kag wayà gid may mabilin nga bato nga nagapamagtumbaw.” ");
INSERT INTO rol_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Nagpangutana sinda kay Hesus, “Maestro, san-o ini matabò kag ano baya ang tandà nga malapit na ini matabò?” ");
INSERT INTO rol_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Nagsabat si Hesus, “Mag-andam kamo nga indì kamo maluko. Kay kadamò ang magaabot kag magahambay, ‘Ako imaw ang Kristo,’ kag mahambay pa sinda, ‘Nag-abot na ang katapusan ng kalibutan!’ Ayaw kamo magpati o magsunod sa inda. ");
INSERT INTO rol_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kag kung makabatì kamo nga may mga gira kag gulo, ayaw kamo mahadlok. Kay dapat gid anay ini tanan matabò, pero bukon ini gusto hambayon nga maabot na ang katapusan ng kalibutan.” ");
INSERT INTO rol_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Naghambay pa gid si Hesus, “Magaininaway ang mga nasyon kag imaw da ang mga gingharian. ");
INSERT INTO rol_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","May maabot nga makusog nga mga linog kag may matabò nga mga taggutom kag peste sa iba-iba nga lugar. Kag makità da nindo ang mga makahayadlok kag makatitingaya nga mga tandà halin sa langit. ");
INSERT INTO rol_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Pero bago matabò ini tanan, dakpon ninda kamo kag hingabuton. Itugyan ninda kamo sa mga sinagoga* para imbistigahan kag prisuhon. Kag day-on ninda kamo sa mga harì kag mga gobernador tungod sa indo pagtuman sa akon. ");
INSERT INTO rol_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Pero imaw ini ang tyempo nga makapamatuod kamo sa inda parti sa akon. ");
INSERT INTO rol_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nganì itanom gid nindo sa indo hunahunà nga kung matabò ini, ayaw nindo pag-isipa kung pauno nindo dipinsahan ang indo kaugalingon. ");
INSERT INTO rol_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Kay ako ang matao sa indo ning kamayad para makasabat kamo agud indì makarason o makabatò ang indo mga kaaway. ");
INSERT INTO rol_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Adto nga tyempo, itugyan kamo sa mga opisyales bisan ng indo mga ginikanan, mga maguyáng o manghod, mga kahalihan kag ng indo mga amigo. Kag ang iban sa indo hay ipapatay ninda. ");
INSERT INTO rol_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Mahahangit gid sa indo ang tanan nga tawo tungod sa indo pagtuman sa akon. ");
INSERT INTO rol_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pero ayaw kamo mahadlok kay aber isa ka nahot ng indo buhok indì gid mahuyog. ");
INSERT INTO rol_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kag kung magtiis kamo sa pagtuman sa akon, makakabaton gid kamo kabuhì nga wayà katapusan.” ");
INSERT INTO rol_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Kung makità nindo nga ginapalibutan na ang syudad ng Jerusalem ng mga sundalo, masasayuran nindo nga madalì na ini magubà. ");
INSERT INTO rol_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ang yarà sa Judea dapat magbakwit na pakadto sa kabukiran kag ang yarà sa syudad dapat maghalin. Ang yarà sa kaumahan indì na dapat magsuyod sa syudad ");
INSERT INTO rol_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kay imaw na inà ang mga adlaw nga parusahan ng Dios ang mga taga-Jerusalem para matuman ang tanan nga ginahambay ng Kasulatan. ");
INSERT INTO rol_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Sa adto nga tyempo, makaluluoy ang mga nabdos kag nagapasuso! Kay sobra gid ang kahugaan nga maabot sa kalibutan kag paparusahan ng Dios ang tanan nga tawo. ");
INSERT INTO rol_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ang iban hay mamamatay sa gira kag ang iban naman hay bihagon kag day-on sa iban nga nasyon. Kag ini nga syudad hay pagagubaon kag ang mga bukon Judio imaw ang magadumaya hasta matapos ang tyempo nga gingtao sa inda ng Ginoo.” ");
INSERT INTO rol_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Maabot ang tyempo nga may mga tandà nga makikità sa adlaw, sa bulan kag sa mga bituon. Kag ang tanan nga tawo sa kalibutan hay magugulpihan kag matataranta tungod sa dagunò ng mga madagkò nga humbak ng dagat. ");
INSERT INTO rol_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Magapanggutas ang mga tawo sa kahadlok tungod sa kaiisip ng malain nga matatabò sa kalibutan kay makikità ninda ang mga butang sa kalangitan hay magatayang sa inda dati nga mga pwesto. ");
INSERT INTO rol_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Pagkatapos makikità ng tanan nga ako nga Ungà ng Tawo* hay yarà sa panganod nga nagabalik sa kalibutan nga may gahom kag may sobra nga kasilaw. ");
INSERT INTO rol_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nganì kung ini nga mga butang hay nagakatabò na, pakusuga ang indo buot kag magkalipay kamo kay malapit na ang indo kaluwasan sa sobra nga kahugaan.” ");
INSERT INTO rol_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Pagkatapos naghambay si Hesus sa inda paagi sa parabola. “Isipon nindo ang kahoy nga igos* kag ang iban pa nga mga kahoy. ");
INSERT INTO rol_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kung makità nindo nga nagapanaybos ang iya mga sanga, sayod na nindo nga malapit na ang tag-init. ");
INSERT INTO rol_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Imaw da, kung makità nindo nga nagakatabò na ini nga mga butang nga akon ginahambay, masasayuran nindo nga ang gingharian ng Dios hay madalì na mag-abot. ");
INSERT INTO rol_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Sa matuod lang ginahambay ko sa indo, magakatabò ini tanan bago mamatay ang mga tawo sa ini nga henerasyon. ");
INSERT INTO rol_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Maduduyà ang langit kag ang dutà, pero ang akon mga hambay indì maduyà kundì matutuman gid ini.” ");
INSERT INTO rol_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Nganì bantayi gid nindo ang indo kaugalingon para indì kamo mawili sa pagpangalipay kag pag-ininom kag indì kamo magpangalibog parti sa indo kabuhì. Kay basì kung maabutan kamo nang adto nga adlaw, ");
INSERT INTO rol_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","nga pareho sa pispis nga nadakop sa siod. Tungod maabot adto sa tanan nga tawo diri sa kalibutan. ");
INSERT INTO rol_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Nganì maging alisto gid kamo sa tanan nga oras, permi kamo magpangamuyò nga magkaigwa kusog, agud indì kamo madaog ng tanan nga matatabò kag makaatubang sa Ungà ng Tawo nga wayà kahadlok.” ");
INSERT INTO rol_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kada adlaw, nagatudlò si Hesus sa templo kag pagkagab-i nagatinir siya sa Bukid ng mga Olibo. ");
INSERT INTO rol_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Aga pa gid kadamò na ang mga tawo nga nagakadto sa templo para magpamatì sa iya. ");
INSERT INTO rol_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Malapit na ang Pyesta ng Tinapay nga wayà Pampaalsa* nga ginatawag ng mga Israelita, Pyesta ng Pagligad ng Anghel*. ");
INSERT INTO rol_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ang mga pinunò nga parì kag ang mga eskriba hay nagapangità ng paagi kung pauno ninda ipapatay si Hesus nga wayà iban nga makasayod kay ginahadlukan sinda sa mga tawo. ");
INSERT INTO rol_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Adto da nga oras, gingsudlan ni Satanas si Judas nga ginatawag, Iscariote. Siya hay isa sa dose nga apostoles. ");
INSERT INTO rol_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Nagkadto siya sa mga pinunò nga parì kag sa mga pinunò ng gwardya sa templo, agud inda istoryahan kung pauno niya itugyan si Hesus sa inda. ");
INSERT INTO rol_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nalipay sinda kag gingpangakuan nga bayaran si Judas. ");
INSERT INTO rol_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Nagpasugot si Judas kag tunà adto, nagapangità siya ning paagi kung pauno niya itugyan si Hesus sa inda nga indì masayuran ng mga tawo. ");
INSERT INTO rol_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Nag-abot ang adlaw ng Pyesta ng Tinapay nga wayà Pampaalsa. Imaw ini ang adlaw nga ginapatay ang kordero agud ihalad sa Dios, para magsilibrar sa Pyesta ng Pagligad ng Anghel. ");
INSERT INTO rol_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Nganì gingsugò ni Hesus sina Pedro kag Juan, “Mag-una kamo kag ipreparar ang aton ihapon para sa Pyesta.” ");
INSERT INTO rol_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nagpangutana sinda, “Sa diin mo ini gusto namon ipreparar?” ");
INSERT INTO rol_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Nagsabat si Hesus, “Pag-abot nindo sa syudad ng Jerusalem, may masumpong kamo nga lyaki nga nagapas-an ning bangà nga may tubì. Sunod kamo sa iya sa bayay nga iya suyuran. ");
INSERT INTO rol_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Kag hambaya nindo ang tag-iya ng bayay, ‘Nagapapangutana ang amon Maestro kung diin ang kwarto nga pagakaunan niya kaibahan ng iya mga disipulo sa ihapon para sa Pyesta.’ ");
INSERT INTO rol_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ipakità niya sa indo ang malapad nga kwarto sa ibabaw nga kumplito na ng mga gamit. Didto kamo magpreparar ng aton ihapon.” ");
INSERT INTO rol_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Nagkadto ang duha kag nakità ninda ang tanan sunò sa ginghambay ni Hesus sa inda. Kag didto ninda gingpreparar ang ihapon para sa Pyesta ng Pagligad ng Anghel. ");
INSERT INTO rol_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Pag-abot ng oras nga maihapon na sinda, nagpungkò si Hesus kaibahan ang iya mga apostoles. ");
INSERT INTO rol_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Naghambay siya, “Gusto ko gid magkaon kaibahan kamo sa ini nga Pyesta ng Pagligad ng Anghel bago ako pahugaan. ");
INSERT INTO rol_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ginahambay ko sa indo, indì na ako magkaon liwat ini hasta matuman gid ang iya gusto hambayon sa gingharian ng Dios.” ");
INSERT INTO rol_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Pagkatapos nagbuoy si Hesus ning tasa nga may ilimnon kag nagpasalamat sa Dios. Hambay niya, “Batuna nindo ini kag mag-inom kamo. ");
INSERT INTO rol_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ginahambay ko sa indo, pagkatapos ini indì na ako mag-inom liwat ng ilimnon halin sa ubas hasta sa adlaw nga mag-abot ang gingharian ng Dios.” ");
INSERT INTO rol_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Pagkatapos nagbuoy siya ning tinapay kag nagpasalamat sa Dios. Gingbuak-buak niya ini kag gingtao sa inda kag naghambay, “Ini ang akon lawas nga ginatao para sa indo. Himua nindo ini bilang pagdumdom sa akon.” ");
INSERT INTO rol_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Pagkatapos ninda kaon ng ihapon, imaw da ang iya ginghuman sa tasa nga may ilimnon kag naghambay, “Ini nga ilimnon ang bag-o nga kasugtanan nga gingsilyuhan paagi sa akon dugò nga ibubò para sa indo. ");
INSERT INTO rol_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Pero pamatì kamo! Kaibahan naton diri sa lamisa ang tawo nga magatraidor sa akon. ");
INSERT INTO rol_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Kay ako nga Ungà ng Tawo hay pagapatyon sunò sa plano ng Dios, pero makaluluoy gid ang tawo nga magatraidor sa akon!” ");
INSERT INTO rol_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Pagkabatì ninda ini, nagpinangutan-an sinda kung sin-o sa inda ang magahuman ini. ");
INSERT INTO rol_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Pagkatapos adto nagdiskusyon ang mga disipulo kung sin-o gid sa inda ang labaw sa tanan. ");
INSERT INTO rol_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Pero naghambay si Hesus sa inda, “Ang mga harì nga nagadumaya sa kalibutan hay may otoridad sa inda mga sinakupan. Kag gusto ninda nga hambayon sinda ng mga tawo nga mabinuligon. ");
INSERT INTO rol_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pero bukon tiyad inà sa indo. Kay kung sin-o sa indo ang labaw sa tanan dapat maging pinakamababà. Kag kung sin-o sa indo ang nagadumaya, dapat magserbisyo. ");
INSERT INTO rol_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Sin-o sa duha ang mas labaw, ang nagapungkò kag nagakaon sa lamisa o ang nagatahaw? Syempre ang nagapungkò. Pero yari ako kaibahan nindo nga nagaserbisyo sa indo.” ");
INSERT INTO rol_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Naghambay pa si Hesus, “Kamo lang gid ang kaibahan ko sa tanan nga mga pagtilaw nga naagihan ko kag wayà nindo ako gingpabay-i. ");
INSERT INTO rol_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kung pauno nga gingtaw-an ako ng akon Amay ning otoridad para magharì, imaw da ang itao ko sa indo nga otoridad, ");
INSERT INTO rol_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","agud makaibahan ko kamo sa pagkaon kag pag-inom sa akon gingharian. Kag magapungkò kamo sa trono para husgahan ang dose ka tribo ng Israel.” ");
INSERT INTO rol_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Pagkatapos naghambay si Hesus kay Pedro, “Simon, Simon, pamatii ako! Nagpilit si Satanas nga tilawan niya ang pagtuo nindo nga daw pareho kamo sa trigo nga ginatahupan. ");
INSERT INTO rol_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pero gingpangamuyò ko na ikaw nga indì maduyà ang imo pagtuo sa akon. Kag kung magbalik ka na liwat, dapat pakusugon mo da ang pagtuo ng imo mga kauturan.” ");
INSERT INTO rol_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Naghambay si Pedro, “Ginoo, preparado gid ako nga mapriso kag mamatay kaibahan mo!” ");
INSERT INTO rol_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Pero naghambay si Hesus, “Ginahambay ko sa imo, Pedro, bago magtuktuyaok ang suyog sa ini nga adlaw, tuyo ka beses ka maghambay nga bukon mo ako kilaya.” ");
INSERT INTO rol_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Pagkatapos naghambay si Hesus sa inda, “Nang gingsugò ko kamo nang una nga magwali, ginghambayan ko kamo nga indì kamo magdaya ning kahita, bag o sandalyas. May nagkuyang ba sa indo?” Nagsabat sinda, “Wayà gid.” ");
INSERT INTO rol_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Naghambay pa si Hesus, “Pero niyan, kung kamo hay may kahita o bag, day-a nindo. Kung sin-o sa indo ang wayà sundang ibaligyà ang iya pangsuy-ob nga barò kag bumakay. ");
INSERT INTO rol_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ginahambay ko sa indo, dapat matuman ang ginahambay ng Kasulatan parti sa akon, ‘Gingbilang siya nga isa ka kriminal’, kay tanan nga gingsulat parti sa akon hay malapit na matuman.” ");
INSERT INTO rol_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Naghambay ang mga disipulo, “Ginoo, yari na ang duha ka sundang.” Nagsabat si Hesus, “Tamà na inà!” ");
INSERT INTO rol_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Pagkatapos nagluwas si Hesus sa syudad kag nagtukad sa Bukid ng mga Olibo, pareho ng permi niya ginahuman. Nagnunot da ang iya mga disipulo. ");
INSERT INTO rol_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Pag-abot ninda didto, naghambay siya sa inda, “Magpangamuyò kamo para indì kamo madaog ng pagtintar.” ");
INSERT INTO rol_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nagpalayò siya sa inda kag nagkadto sa unahan. Didto nagluhod siya kag nagpangamuyò. ");
INSERT INTO rol_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Naghambay siya, “Amay, kung gusto mo, buy-a ini nga paabuton nga kahugaan sa akon. Pero bukon ang akon kagustuhan ang matuman, kundì ang kagustuhan mo.” ");
INSERT INTO rol_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Pagkatapos nagpakità ang anghel halin sa langit kag gingpakusog ang iya buot. ");
INSERT INTO rol_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tungod sa sobra gid nga kalisod, lalò pa gid siya nga nagpangamuyò hasta ang iya gan-ot hay pareho sa dugò nga nagatuyò sa dutà. ");
INSERT INTO rol_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Pagkatapos niya pangamuyò, nagtindog siya kag nagpalapit sa mga disipulo. Naabutan niya sinda nga nagakatuyog kay nagapangluya gid sinda sa kalisod. ");
INSERT INTO rol_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Naghambay si Hesus, “Basì nagakatuyog kamo? Bangon kag magpangamuyò para indì kamo madaog ng pagtintar.” ");
INSERT INTO rol_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Mintras nagahambay pa si Hesus, nag-abot ang kadamò nga tawo. Si Judas nga isa sa dose nga disipulo hay nagauna sa inda. Nagpalapit siya kay Hesus kag gingharuan niya. ");
INSERT INTO rol_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Pero gingpangutana siya ni Hesus, “Judas, traiduron mo ba ako nga Ungà ng Tawo sa isa ka harò?” ");
INSERT INTO rol_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Nang makità ng mga kaibahan ni Hesus ang matatabò, naghambay sinda, “Ginoo, panglabuon ba namon sinda?” ");
INSERT INTO rol_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Pagkatapos ginglabò ng isa sa inda ang ulipon ng Pinakamataas nga Parì kag nautod ang iya tuo nga talinga. ");
INSERT INTO rol_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Pero naghambay si Hesus, “Tamà na inà!” Ginghawiran niya ang talinga ng tawo kag ang pilas hay nag-ayo nga daan. ");
INSERT INTO rol_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Pagkatapos naghambay si Hesus sa mga pinunò nga parì, mga pinunò ng gwardya ng templo kag mga miyugdumaya ng Judio nga nagadakop sa iya, “Tulisan ba ako nga kahinangyan gid magdaya pa kamo mga sundang kag mga pamakang para dakpon ako? ");
INSERT INTO rol_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Adlaw-adlaw yadto ako sa templo nga nagatudlò kag yadto da kamo kag wayà nindo ako pagdakpa. Pero imaw na ini ang oras para masunod ang kagustuhan ni Satanas nga harì ng kaduyom.” ");
INSERT INTO rol_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Gingdakop ninda si Hesus kag gingdaya sa bayay ng Pinakamataas nga Parì. Si Pedro naman nagnunot, pero malayò ang iya antad. ");
INSERT INTO rol_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nagdabok ang mga tawo sa tungà ng dyaag kag nagpungkò sa malapit para magpainit-init. Nagpalapit da si Pedro kag nagpungkò. ");
INSERT INTO rol_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nakità siya ng isa ka ulipon nga babayi nang mahayagan siya ng kalayo. Gingsirò niya si Pedro ning maayo kag naghambay, “Ini nga tawo hay kaibahan da ni Hesus!” ");
INSERT INTO rol_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pero nagbalibad si Pedro kag naghambay, “Taya! Wayà ko nganì siya makilaya!” ");
INSERT INTO rol_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Malagat-lagat may lyaki naman nga nakakità kay Pedro kag naghambay, “Ikaw, kaibahan ka da niya.” Pero nagsabat si Pedro, “Ano! Bukon ako adto!” ");
INSERT INTO rol_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Pagkaligad ng mga isa ka oras may naghambay naman, “Sigurado gid, ini nga tawo kaibahan ni Hesus kay taga-Galilea da siya.” ");
INSERT INTO rol_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pero nagsabat si Pedro, “Taya! Wayà gid ako nakasayod kung ano ang imo ginahambay!” Kag adto nga daan mintras nagahambay pa si Pedro, nagtuktuyaok ang suyog. ");
INSERT INTO rol_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Naglingig ang Ginoo kag gingsirò siya. Nadumduman ni Pedro ang ginghambay ng Ginoo sa iya, “Bago magtuktuyaok ang suyog sa ini nga gab-i, tuyo ka beses ka magahambay nga bukon mo ako kilaya.” ");
INSERT INTO rol_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Nganì nagluwas siya kag nagtinangis gid tudo. ");
INSERT INTO rol_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Niyan, ging-insulto kag gingbinalda si Hesus ng mga tawo nga nagagwardya sa iya. ");
INSERT INTO rol_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Gingtabunan ninda ang iya mata kag gingtiniaw-tiawan, “Sige, pintua abi! Sin-o ang nagsumbag sa imo?” ");
INSERT INTO rol_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Kag madamò pa gid ang inda ginahinambay nga pang-insulto sa iya. ");
INSERT INTO rol_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Pagkaaga, nagtipon ang mga miyugdumaya ng Judio, mga pinunò nga parì kag mga eskriba. Gingdaya ninda si Hesus sa inda Korte*. ");
INSERT INTO rol_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Nagpangutana sinda kay Hesus, “Balitai kami! Ikaw ba ang Kristo?” Pero nagsabat si Hesus, “Aber ibalità ko sa indo, indì da gihapon kamo magpati. ");
INSERT INTO rol_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Kag kung magpangutana da ako sa indo, indì da kamo magsabat. ");
INSERT INTO rol_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pero tunà arinyan, ako nga Ungà ng Tawo hay magapungkò hampig sa tuo ng Dios nga Makagagahom.” ");
INSERT INTO rol_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Pagkatapos nagpangutana sinda tanan, “Kung tiyad inà, ikaw ang Ungà ng Dios?” Nagsabat naman si Hesus, “Kamo mismo ang naghambay inà.” ");
INSERT INTO rol_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Naghambay sinda, “Ano pa nga pamatuod ang kinahangyan ta? Kita na mismo ang nakabatì halin sa iya bàbà!” ");
INSERT INTO rol_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Pagkatapos adto, nagtindog sinda tanan kag gingdaya si Hesus kay Pilato nga gobernador. ");
INSERT INTO rol_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Pag-abot didto, ging-akusar ninda si Hesus kay Pilato. Hambay ninda, “Naabutan namon ini nga tawo nga nagapangumbinsi sa amon mga kasimanwa para magbatò sa Emperyo ng Roma. Kag ginabawalan niya ang mga tawo nga magbayad ning buhis sa Emperador. Nagahambay pa siya nga siya ang Kristo nga isa ka harì.” ");
INSERT INTO rol_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Gingpangutana siya ni Pilato, “Ikaw ba ang harì ng mga Judio?” Nagsabat si Hesus sa iya, “Ikaw na ang naghambay inà.” ");
INSERT INTO rol_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pagkatapos naghambay si Pilato sa mga pinunò nga parì kag sa madamò nga tawo nga nagatipon didto, “Wayà da ako may nakità nga salà agud sentensyahan ng kamatayon ini nga tawo.” ");
INSERT INTO rol_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pero nagpilit gid sinda kag naghambay, “Paagi sa iya pagpanudlò, ginasuysugan niya nga magrebelde ang mga taga-Judea. Nagtunà siya sa Galilea kag niyan hay yari na diri sa Jerusalem.” ");
INSERT INTO rol_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Nang mabatian ini ni Pilato, nagpangutana siya kung taga-Galilea gid siya. ");
INSERT INTO rol_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Nang masayuran niya nga taga-didto si Hesus sa lugar nga sakop ni Herodes, gingpadaya niya si Hesus sa iya. Kay nang adto nga mga adlaw yadto da si Herodes sa Jerusalem. ");
INSERT INTO rol_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Nalipay gid si Herodes nang makità niya si Hesus. Dugay na niya gusto nga makità siya, kay kadamò ang iya nabatian parti sa iya. Gusto kuntà niya nga maghuman si Hesus ng mga milagro para makità niya. ");
INSERT INTO rol_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nganì gingpinangutana ni Herodes si Hesus. Pero wayà gid siya nagsabat. ");
INSERT INTO rol_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Yadto da ang mga pinunò nga parì kag mga eskriba kag wayà gid sinda nagpara sa pag-akusar kay Hesus. ");
INSERT INTO rol_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Gingpakamaisot kag ging-insulto siya ni Herodes kag ng iya mga sundalo. Gingsuksukan ninda siya ning mamahayon nga barò kag pagkatapos gingpabalik kay Pilato. ");
INSERT INTO rol_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Nang adto nga adlaw, naging mag-amigo na sina Herodes kag Pilato nga dati anay hay magkaaway. ");
INSERT INTO rol_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Gingpatawag ni Pilato ang mga pinunò nga parì, mga miyugdumaya ng banwa kag ang mga tawo. ");
INSERT INTO rol_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Naghambay siya sa inda, “Gingdaya nindo diri sa akon ini nga tawo nga indo ginaakusar nga nagapangsuysog agud magrebelde ang mga tawo sa Emperador. Pero sa akon pag-imbistigar sa indo atubangan, wayà gid ako may makità nga salà pareho ng indo ginaakusar. ");
INSERT INTO rol_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Patì da si Herodes, wayà da siya may makità nga salà, nganì gingpabalik siya sa aton. Wayà gid siya may malain nga ginghuman para siya patyon. ");
INSERT INTO rol_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ipalatigo ko na lang siya kag pagkatapos buhian.” ");
INSERT INTO rol_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ginahambay niya ini kay kada Pyesta ng Pagligad ng Anghel, kahinangyan niya magpaluwas ng isa ka priso nga mapilì ng mga tawo. ");
INSERT INTO rol_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pero nagsininggit sinda, “Patya inà nga tawo! Si Barabas ang paluwasa para sa amon!” ");
INSERT INTO rol_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Si Barabas hay napriso kay naglakot siya sa pagrebelde kontra sa Emperador nga natabò sa Jerusalem kag nakapatay pa siya.) ");
INSERT INTO rol_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Gusto kuntà ni Pilato nga buhian si Hesus nganì naghambay pa gid siya sa mga tawo. ");
INSERT INTO rol_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pero nagsininggit sinda, “Ilangsang siya sa krus! Ilangsang siya sa krus!” ");
INSERT INTO rol_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Nagpangutana pa gid sa inda si Pilato sa ikatuyo ka beses, “Basì, ano ba nga salà ang iya nahuman? Wayà gid ako may nakità nga salà para sentensyahan siya nga mamatay! Ipalatigo ko na lang siya kag buhian pagkatapos.” ");
INSERT INTO rol_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero lalò pa gid nga nagsininggit sinda nga dapat ilangsang siya sa krus. Nang ulihi, sinda gid ang nasunod. ");
INSERT INTO rol_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Nganì nagpasugot si Pilato sa gusto ng mga tawo nga ilangsang si Hesus sa krus. ");
INSERT INTO rol_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Gingpaluwas niya adtong tawo nga gingpriso tungod sa pagrebelde kag pagpatay kay imaw ang inda gingpangayò. Pero gingtugyan niya si Hesus sa mga tawo para himuon ninda ang inda gusto sa iya. ");
INSERT INTO rol_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Mintras ginadaya ng mga sundalo si Hesus paluwas, nasumpong ninda ang isa ka tawo nga halin sa baryo. Ang iya pangayan hay si Simon nga taga-Cyrene. Ginghawiran ninda siya kag gingpilit nga ipapas-an ang krus sa iya kag gingpasunod kay Hesus. ");
INSERT INTO rol_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kadamò da ang mga tawo nga nagasunod kay Hesus, patì ang mga babayi nga nagatinangis kag ginapinuypog ang inda dughan sa tudo nga kalisod. ");
INSERT INTO rol_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Pero ginglingig sinda ni Hesus kag naghambay, “Mga kababayihan nga taga-Jerusalem, ayaw nindo ako pagtangisi. Tangisi nindo ang indo mga kaugalingon kag ang indo mga ungà. ");
INSERT INTO rol_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kay maabot gid ang mga adlaw nga mahambay ang mga tawo, ‘Bulahan ang mga baog kag ang mga wayà ungà kag ang wayà nagpasuso!’ ");
INSERT INTO rol_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Sa adto nga mga adlaw, mahambay ang mga tawo sa mga bukid, ‘Tumpagi kami!’ Kag sa mga bakuyod, ‘Tabuni kami!’ ");
INSERT INTO rol_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kay kung ginahuman ninda ini sa akon nga wayà nganì salà, ano pa arà ang matatabò sa mga tawo nga may salà?” ");
INSERT INTO rol_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","May duha pa ka kriminal ang gingdaya ninda para patyon kaibahan ni Hesus. ");
INSERT INTO rol_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Pag-abot ninda sa lugar nga ginatawag, Bungò; ginglangsang ninda si Hesus sa krus. Ginglangsang da ninda ang duha ka kriminal, ang isa sa tuo kag ang isa sa waya. ");
INSERT INTO rol_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Pagkatapos naghambay si Hesus, “Amay, patawara sinda kay wayà ninda nasayuri ang inda ginahuman.” Gingparte-parte ninda ang iya mga barò paagi sa palabunutan. ");
INSERT INTO rol_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Mintras nagatindog didto ang mga tawo kag nagatan-aw, ginaininsulto ng mga pinunò si Hesus. Hambay ninda, “Gingtabangan niya ang iban, pero kung matuod nga siya ang Kristo nga gingpilì ng Dios, dapat tabangan da niya ang iya kaugalingon!” ");
INSERT INTO rol_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ging-insulto da siya ng mga sundalo. Nagpalapit sinda sa iya kag gingdawatan ning maaslom nga ilimnon. ");
INSERT INTO rol_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Hambay ninda, “Kung matuod nga ikaw ang Harì ng mga Judio, luwasa ang imo kaugalingon!” ");
INSERT INTO rol_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Kag may nakasulat sa karatula sa ibabaw ng iya uyo nga, Ini ang Harì ng mga Judio. ");
INSERT INTO rol_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ging-insulto da siya ng isa sa duha ka kriminal nga nalangsang sa krus. Hambay niya, “Dì ba ikaw ang Kristo? Tabangi ang imo kaugalingon kag patì da kami!” ");
INSERT INTO rol_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pero gingsabyaw siya ng isa pa nga kriminal, “Wayà ka ba nahadlok sa Dios? Kay pareho lang da kita nga ginaparusahan! ");
INSERT INTO rol_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Kita nga duha hay angay gid nga parusahan tungod sa aton nahuman nga mga salà, pero ini nga tawo hay wayà may nahuman nga malain.” ");
INSERT INTO rol_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Pagkatapos naghambay siya, “Hesus, dumduma ako kung magharì ka na!” ");
INSERT INTO rol_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Nagsabat si Hesus, “Sa matuod lang ginahambay ko sa imo, ini gid nga adlaw makakaibahan ta ikaw sa Paraiso.” ");
INSERT INTO rol_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Nang mga alas dose na ng adlaw, nagduyom ang bilog nga lugar hasta alas tres ng hapon. ");
INSERT INTO rol_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Wayà naghayag ang adlaw kag nagisì sa tungà ang kurtina ng templo halin sa ibabaw pakadto sa ubos. ");
INSERT INTO rol_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Pagkatapos nagsinggit si Hesus ng makusog, “Amay, ginatugyan ko sa imo ang akon espiritu!” Pagkahambay niya ini, nabugtuan siya ning ginhawa. ");
INSERT INTO rol_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nang makità ng kapitan ng mga sundalo ang natabò, nagdayaw siya sa Dios kag naghambay, “Matuod gid nga wayà ning salà ini nga tawo!” ");
INSERT INTO rol_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ang tanan nga mga tawo nga nagasirò didto sa mga natabò hay nagpinang-ulì nga ginapinuypog ang inda dughan tungod sa sobra nga kalisod. ");
INSERT INTO rol_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ang mga kaibahan ni Hesus, patì ang mga babayi nga nagasunod sa iya halin sa Galilea hay yadto da nagatindog sa malayò-layò kag nagatan-aw ng ini nga mga nagakatabò. ");
INSERT INTO rol_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","May isa ka tawo nga maayo kag matarong nga ang pangayan hay Jose. Aber miyembro siya sa Korte ng mga Judio*, ");
INSERT INTO rol_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","wayà siya nagsugot sa plano ninda nga patyon si Hesus. Siya hay taga-Arimatea nga sakop ng Judea kag nagahuyat siya sa paghaharì ng Dios. ");
INSERT INTO rol_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nagkadto siya kay Pilato kag gingpangayò ang lawas ni Hesus. ");
INSERT INTO rol_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pagkatapos gingpatunton niya ang lawas ni Hesus halin sa krus kag gingpaputos ng mahay kag maayo nga klasi nga tela nga linen. Gingpabutang niya ang lawas sa isa ka lubungan nga ginghuman sa alihid ng bakuyod. Ini hay wayà pa nalulubungi. ");
INSERT INTO rol_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Biyernes adto kag adlaw ng pagpreparar sa pagtunà ng Adlaw nga Inugpahuway*. ");
INSERT INTO rol_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Niyan, ang mga babayi nga kaibahan ni Hesus halin sa Galilea hay nagsunod kay Jose. Nakità ninda kung diin si Hesus ginglubong kag kung pauno ang pagbutang ng iya lawas. ");
INSERT INTO rol_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Pagkatapos nagpaulì sinda kag nagpreparar ng mga pahumot kag buyong nga panghibò sa lawas ni Hesus. Tungod Adlaw nga Inugpahuway na, nagpahuway sinda sunò sa Kasuguan. ");
INSERT INTO rol_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Aga pa gid ng una nga adlaw ng simana, nagkadto ang mga babayi sa lubungan daya ang gingpreparar nga mga pahumot. ");
INSERT INTO rol_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Pag-abot didto, nakità ninda nga ang bato nga nagasara sa pwertahan ng lubungan hay napaligid na. ");
INSERT INTO rol_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Nagsuyod sinda pero wayà ninda nakità ang lawas ni Ginoong Hesus. ");
INSERT INTO rol_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Mintras nagapangalibog sinda kung ano ang natabò, gulpi lang nagpakità ang duha ka lyaki nga nagatindog sa inda atubangan. Ang inda barò hay sobra gid nga kasilaw. ");
INSERT INTO rol_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Tungod sa tudo ninda nga kahadlok, naghapà sinda. Nagpangutana ang mga lyaki sa inda, “Basì ginapangità nindo ang buhì diri sa mga patay? ");
INSERT INTO rol_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Wayà siya diri. Nabanhaw na siya! Nadumduman ba nindo ang iya hambay sa indo nang yadto pa kamo sa Galilea? ");
INSERT INTO rol_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ang hambay niya, siya nga Ungà ng Tawo hay kahinangyan dakpon kag itao sa mga makasasalà para ilangsang sa krus kag mamatay. Pero sa ikatuyo ka adlaw mababanhaw siya.” ");
INSERT INTO rol_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Kag nadumduman ninda ang ginghambay nang una ni Hesus. ");
INSERT INTO rol_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Nganì nagpaulì sinda kag gingbalità ang tanan nga natabò sa onse ka disipulo kag sa inda mga kaibahan. ");
INSERT INTO rol_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ang mga nagbalità sa mga apostoles hay sina Maria nga taga-Magdala, Juana, Maria nga nanay ni Santiago kag ang iban pa nga mga babayi. ");
INSERT INTO rol_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pero wayà sinda nagpati kay ang kalaom ninda hay isto-istorya lang ini. ");
INSERT INTO rol_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pero nagtindog si Pedro kag nagdyagan pakadto sa lubungan. Pag-abot niya didto nagdukò siya kag naglìlì sa suyod. Ang nakità lang niya hay ang tela nga linen nga gingputos sa lawas ni Hesus. Nganì nagpaulì siya nga natingaya gid sa natabò. ");
INSERT INTO rol_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nang adto da nga adlaw ang duha ka disipulo ni Hesus hay nagapanaw pakadto sa baryo ng Emaus, mga onse ka kilometro halin sa Jerusalem. ");
INSERT INTO rol_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ang inda ginainistorya mintras nagapanaw hay ang tanan nga natabò. ");
INSERT INTO rol_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Mintras nagaistorya kag nagapinangutan-an sinda, nagpalapit si Hesus kag nagdungan sa inda. ");
INSERT INTO rol_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pero wayà ninda siya nakilaya kay daw natabunan ang inda mata. ");
INSERT INTO rol_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Nagpangutana si Hesus sa inda, “Ano gid ang indo ginainistorya mintras nagapanaw?” Nagduyog sinda nga may kalisod. ");
INSERT INTO rol_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Nagsabat ang isa sa inda nga ang pangayan hay Cleopas, “Ikaw lang siguro sa mga nagbisita sa Jerusalem ang wayà nakasayod kung ano ang bag-o lang nga natabò didto.” ");
INSERT INTO rol_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Nagpangutana si Hesus, “Basì, ano ang natabò?” Nagsabat sinda, “Ang parti kay Hesus nga taga-Nazaret. Siya hay propeta nga makagagahom sa panirò ng Dios kag ng tanan nga tawo. Gingpakità niya ini paagi sa iya gingpanghambay kag gingpanghuman. ");
INSERT INTO rol_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Pero ging-akusar siya ng aton mga pinunò nga parì kag ng iban pa nga pinunò naton para parusahan nga patyon. Kag gingpalangsang ninda siya sa krus. ");
INSERT INTO rol_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Siya pa naman ang amon ginalauman nga magahilway sa Israel sa pagharì ng mga taga-Roma. Kag tuyo na ini niyan ka adlaw tunà nang gingpatay siya. ");
INSERT INTO rol_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kag isa pa, nagulpihan gid kami sa gingbalità ng amon iban nga mga kaibahan nga babayi. Aga pa gid sinda nagkadto sa lubungan, ");
INSERT INTO rol_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","pero wayà na kuno didto ang lawas ni Hesus. Nagbalik nga daan sinda sa amon kag nagbalità nga nakità ninda ang mga anghel nga ang hambay buhì si Hesus! ");
INSERT INTO rol_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Pagkatapos ang iban sa amon mga kaibahan nagkadto da sa lubungan kag nakità ninda nga matuod gid ang gingbalità ng mga babayi, pero wayà ninda nakità si Hesus.” ");
INSERT INTO rol_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Pagkatapos naghambay si Hesus sa inda, “Wayà ba kamo nakaintindi? Basì indì nindo mapatihan ang tanan nga gingbalità ng mga propeta? ");
INSERT INTO rol_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Dì ba kahinangyan anay mag-agi sa kahugaan ang Kristo bago siya himayaon?” ");
INSERT INTO rol_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Kag ging-isplikar ni Hesus ang tanan nga ginghambay sa Kasulatan parti sa iya kaugalingon, tunà sa gingsulat ni Moises hasta sa gingsulat ng tanan nga propeta. ");
INSERT INTO rol_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nang malapit na sinda sa baryo nga inda kadtuan, si Hesus hay daw maderitso lang sa iya pagpanaw. ");
INSERT INTO rol_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Nganì ging-agda gid ninda siya, “Magnunot ka na lang anay sa amon kay hapon na kag malapit na magduyom.” Nganì nagnunot siya sa inda. ");
INSERT INTO rol_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nang nagapungkò na sinda para magkaon, gingbuoy ni Hesus ang tinapay kag nagpasalamat sa Dios. Pagkatapos, gingbuak-buak niya ini kag gingtao sa inda. ");
INSERT INTO rol_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kag nabuoy ang nagasagang sa inda mata kag nakilaya ninda si Ginoong Hesus. Pero gulpi lang siya naduyà sa inda panirò. ");
INSERT INTO rol_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Naghambay sinda sa isa kag isa, “Gai-galì kalipay-lipay gid ang aton pamatyag nang ginaisplikar niya ang hambay ng Dios nang kaibahan pa naton siya sa dayan!” ");
INSERT INTO rol_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Kag nagtindog sinda nga daan kag nagbalik sa Jerusalem. Naabutan ninda ang onse nga disipulo kag ang iban ninda nga mga kaibahan nga nagatipon didto. ");
INSERT INTO rol_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Hambay ninda nga duha, “Matuod gida galì nga nabanhaw ang Ginoo! Nagpakità siya kay Simon!” ");
INSERT INTO rol_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Pagkatapos gingbalità ng duha ang natabò didto sa dayan pakadto sa Emaus kag kung pauno ninda nakilaya si Hesus nang nagabuak-buak siya ng tinapay. ");
INSERT INTO rol_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Mintras nagaistorya pa ang duha, gulpi lang nagpakità si Hesus sa inda kag nagtindog sa tungà. Hambay niya, “Ang katawhayan yarà sa indo!” ");
INSERT INTO rol_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Pero nangayag kag hinadlukan sinda kay ang kalaom ninda muyto ang inda nakità. ");
INSERT INTO rol_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Naghambay si Hesus sa inda, “Basì ginahadlukan kamo kag nagapangduha-duha? ");
INSERT INTO rol_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Tan-awa nindo ang akon mga kamot kag siki! Hawiri kag sirua. Bukon ako muyto kay ang muyto wayà unod kag tuy-an pareho ng nakikità nindo sa akon.” ");
INSERT INTO rol_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Mintras ginahambay niya ini, gingpakità niya ang iya mga kamot kag siki. ");
INSERT INTO rol_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Daw indì gihapon sinda makapati tungod sa inda sobra nga kalipay kag katingaya. Nganì nagpangutana si Hesus sa inda, “May pagkaon ba kamo?” ");
INSERT INTO rol_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Gingtaw-an ninda siya ning inihaw nga isdà. ");
INSERT INTO rol_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Gingbuoy niya ini kag gingkaon sa inda atubangan. ");
INSERT INTO rol_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Pagkatapos naghambay siya, “Imaw ini ang akon ginghambay sa indo nang kaibahan pa nindo ako. Dapat matuman ang tanan nga nakasulat parti sa akon sa mga Kasuguan ni Moises, sa mga ginghambay ng mga propeta kag sa mga Salmo.” ");
INSERT INTO rol_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Pagkatapos gingbuksan ni Hesus ang inda isip para maintindihan ninda ang Kasulatan. ");
INSERT INTO rol_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Kag naghambay pa si Hesus sa inda, “Imaw ini ang nakasulat: ang Kristo hay kahinangyan gid mag-agi ng kahugaan kag mamatay pero sa ikatuyo ka adlaw mabanhaw siya. ");
INSERT INTO rol_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Dapat ipamalità sa tanan nga tawo sa bilog nga kalibutan magtunà sa Jerusalem nga paagi sa iya, patatawaron ng Dios ang mga tawo nga magahinuysoy sa inda kasal-anan. ");
INSERT INTO rol_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kamo ang mga testigo sa ini nga mga butang. ");
INSERT INTO rol_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Kag ipadaya ko sa indo ang Espiritu Santo nga gingpangakò ng akon Amay. Pero maghuyat anay kamo sa Jerusalem hasta mabaton nindo ang gahom ng Espiritu Santo halin sa langit.” ");
INSERT INTO rol_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Pagkatapos adto gingdaya sinda ni Hesus sa luwas ng Jerusalem. Pag-abot sa baryo ng Betania, gingtaas niya ang iya kamot kag gingbendisyunan sinda. ");
INSERT INTO rol_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Mintras ginabendisyunan niya sinda, painot-inot siya nga gingdaya pakadto sa langit. ");
INSERT INTO rol_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Gingsamba ninda siya kag pagkatapos kalipay-lipay gid sinda nga nagbalik sa Jerusalem. ");
INSERT INTO rol_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Permi sinda didto sa templo nga nagadayaw sa Dios.");
INSERT INTO rol_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Bago pa nagtunà ang tanan, yarà na ang ginatawag nga Hambay. Ini nga Hambay hay kaibahan na ng Dios kag ang Hambay mismo hay Dios. ");
INSERT INTO rol_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Kaibahan siya ng Dios bago pa magtunà ang tanan. ");
INSERT INTO rol_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ang tanan nga butang nahuman paagi sa iya kag wayà mahuman ang mga nahuman kung bukon siya. ");
INSERT INTO rol_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Siya ang ginghalinan ng matuod nga kabuhì. Ini nga kabuhì hay kahayag. Paagi diri, maiintindihan ng mga tawo ang kamatuuran. ");
INSERT INTO rol_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Siya hay nagahayag pareho ng iwag sa kaduyom kag wayà gid napeperdi ng kaduyom ang kahayag. ");
INSERT INTO rol_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Igwa ning tawo nga ang pangayan hay Juan nga gingsugò ng Dios. ");
INSERT INTO rol_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Gingsugò siya para magpamatuod parti sa kahayag nga nagkari sa kalibutan, agud ang tanan hay magtuo tungod sa iya pamatuod. ");
INSERT INTO rol_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Bukon si Juan ang kahayag, pero gingsugò siya para magpamatuod parti sa ini nga kahayag. ");
INSERT INTO rol_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Si Hesus ang matuod nga kahayag nga nagaabot sa kalibutan para mahayagan ang mga tawo agud maintindihan ang kamatuuran. ");
INSERT INTO rol_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nag-abot gid siya sa kalibutan, pero aber natuga ang kalibutan paagi sa iya, wayà siya gingkilay-a ng mga tawo kung sin-o siya. ");
INSERT INTO rol_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Nagkari siya sa kaugalingon niya nga nasyon, pero wayà siya gingbatuna ng kadamuan. ");
INSERT INTO rol_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pero ang tanan nga nagbaton kag nagtuo sa iya hay gingtaw-an niya ning pribilihiyo nga maging mga ungà ng Dios. ");
INSERT INTO rol_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nahuman sinda nga mga ungà ng Dios bukon paagi sa tawhanon, o sa kagustuhan ng lawas, o sa kagustuhan ng mag-asawa, kundì paagi sa kabubut-on ng Dios. ");
INSERT INTO rol_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ang ginatawag nga Hambay, siya hay naging tawo kag nag-istar diri sa kalibutan kaibahan naton. Maluluy-on gid siya kag matuod gid ang tanan nga iya ginahambay. Nakità namon ang iya gahom kag kahayag bilang bugtong nga Ungà halin sa Dios nga Amay. ");
INSERT INTO rol_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Nagpamatuod si Juan sa mga tawo, “Imaw ini ang akon gusto hambayon nang ginghambay ko, ‘May isa ka tawo nga kasunod ko nga maabot. Mas importante siya kaysa sa akon kay bago pa ako natawo, yarà na siya.’ ” ");
INSERT INTO rol_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Tungod sa iya madakò nga paghigugmà, padayon gid kita tanan nga nakabaton ng abunda nga pagpakamaayo. ");
INSERT INTO rol_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ang Kasuguan hay gingtao ng Dios paagi kay Moises, pero ang pagpakamaayo kag kamatuuran hay gingpasayod sa aton paagi kay Hesu-Kristo. ");
INSERT INTO rol_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Wayà gid ning bisan sin-o nga nakakità sa Dios. Pero gingpakilaya siya sa aton ng iya bugtong nga Ungà. Siya mismo hay Dios nga malapit sa tagipusuon ng iya Amay. ");
INSERT INTO rol_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Isa ka adlaw, ang mga miyugdumaya ng mga Judio hay nagsugò ng mga parì kag mga Levita* halin sa Jerusalem para pangutan-on si Juan kung sin-o siya. Naghambay sinda, “Sin-o ka?” ");
INSERT INTO rol_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Wayà si Juan nagbalibad kundì nagsabat ning matuod, “Bukon ako ang Kristo* nga indo ginahuyat.” ");
INSERT INTO rol_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Nganì gingpangutana ninda siya liwat, “Kung imaw inà, sin-o ka? Ikaw ba si Elias?” Nagsabat si Juan, “Bukon.” Kag nagpangutana pa gid sinda, “Ikaw ba ang propeta* nga magaabot?” Nagsabat siya, “Bukon!” ");
INSERT INTO rol_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Nganì gingpangutana pa gid ninda siya, “Sin-o ka gid galì? Balitai kami agud may maisabat da kami sa mga nagsugò sa amon. Ano ang mahahambay mo parti sa imo kaugalingon?” ");
INSERT INTO rol_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Nagsabat siya, “Ako adto ang ginghambay ni Propeta Isaias, ‘May magasinggit sa tiway nga lugar, “Tadlunga nindo ang agihan kay maabot ang Ginoo.” ’ ” ");
INSERT INTO rol_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Nganì ang mga gingsugò ng mga Pariseo* ");
INSERT INTO rol_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","nagpangutana liwat, “Kung bukon ikaw ang Kristo, o si Elias, o ang propeta, basì nagabawtismo ka?” ");
INSERT INTO rol_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Nagsabat si Juan, “Ako hay nagabawtismo sa tubì, pero may kaibahan kamo niyan nga wayà nindo nakikilaya kung sin-o siya. ");
INSERT INTO rol_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Siya ang ginahambay ko nga maabot masunod sa akon. Kag indì gid ako angay aber magbaskad ng higot ng iya sandalyas.” ");
INSERT INTO rol_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Natabò ini didto sa lugar ng Betania sa kabuak ng Subà ng Jordan kung sa diin si Juan nagabawtismo. ");
INSERT INTO rol_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Nang masunod nga adlaw, nakità ni Juan si Hesus nga nagapalapit sa iya; nganì naghambay siya, “Tan-awa! Yari na ang Kordero ng Dios nga halad* agud mapatawad ang kasal-anan ng mga tawo. ");
INSERT INTO rol_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Imaw ini ang akon ginghambay dati sa indo, ‘May isa ka tawo nga magaabot masunod sa akon nga mas importante kaysa sa akon, kay bago pa ako natawo, yarà na siya.’ ");
INSERT INTO rol_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nang una, aber ako mismo hay wayà nakakakilaya sa iya kung sin-o gid siya, pero ang rason kung basì nagabawtismo ako hay agud ipakilaya siya sa indo nga mga taga-Israel.” ");
INSERT INTO rol_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Kag imaw ini ang gingpamatuod ni Juan, “Nakità ko ang Espiritu Santo nga daw salampati nga nagababà pakadto sa iya halin sa langit kag nagtinir sa iya. ");
INSERT INTO rol_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Aber ako mismo hay wayà nakakakilaya sa iya, pero ang Dios nga nagsugò sa akon nga magbawtismo sa tubì ang naghambay sa akon, ‘Ang makitaan mo nga babaan kag tiniran ng Espiritu, siya ang magabawtismo sa Espiritu Santo.’ ");
INSERT INTO rol_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Kag nakità ko gid ini. Nganì ginapamatuuran ko nga si Hesus ang Ungà ng Dios.” ");
INSERT INTO rol_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Nang masunod nga adlaw, mintras nagatindog si Juan nga Miyugbawtismo kaibahan ang duha sa iya mga disipulo, ");
INSERT INTO rol_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","nakità niya si Hesus nga nagaagi. Kag naghambay si Juan, “Tan-awa nindo, ang Kordero ng Dios!” ");
INSERT INTO rol_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Pagkabatì ini ng duha nga disipulo, adto nga daan nagsunod sinda kay Hesus. ");
INSERT INTO rol_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Naglingig si Hesus kag nakità niya nga nagasunod sinda, nganì nagpangutana siya, “Ano ang indo kahinangyan?” Nagsabat sinda, “Rabi, sa diin ikaw nagadayon?” (Ang gusto hambayon ng Rabi hay Maestro.) ");
INSERT INTO rol_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Nagsabat si Hesus, “Kari, agud makità nindo.” Mga alas kwatro na adto ng hapon nang nagkadto sinda kaibahan siya. Nganì nagtinir sinda didto hasta magab-i. ");
INSERT INTO rol_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Isa sa duha nga nakabatì sa ginghambay ni Juan kag nagsunod kay Hesus, hay si Andres nga manghod ni Simon Pedro. ");
INSERT INTO rol_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ang una nga ginghuman ni Andres hay gingpangità niya si Simon kag gingbalitaan, “Nakità namon ang Mesias!” (Ang gusto hambayon hay Kristo*.) ");
INSERT INTO rol_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Kag gingdaya niya si Simon kay Hesus. Gingsirò siya ni Hesus kag ginghambay, “Ikaw si Simon nga ungà ni Juan. Pero niyan pagatawagon ka nga Cefas.” (Ang Cefas hay pareho da sa pangayan nga Pedro.) ");
INSERT INTO rol_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Nang masunod nga adlaw nagdesisyon si Hesus nga magkadto sa lugar ng Galilea. Didto nakità niya si Felipe kag ginghambayan niya, “Magsunod ka agud maging disipulo ko.” ");
INSERT INTO rol_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Si Felipe hay taga-Betsaida, nga banwa da nina Andres kag Pedro. ");
INSERT INTO rol_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Gingpangità ni Felipe si Natanael kag ginghambayan niya, “Nakità na namon ang tawo nga ginghambay sa Kasuguan ni Moises kag sa mga gingsulat ng mga propeta. Siya galì hay si Hesus nga taga-Nazaret, ang ungà ni Jose.” ");
INSERT INTO rol_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Naghambay si Natanael, “Nazaret! Igwa ba arà ning maayo nga magahalin didto?” Sabat naman ni Felipe, “Nunot anay sa akon agud makità mo.” ");
INSERT INTO rol_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Pagkakità ni Hesus kay Natanael nga nagapalapit sa iya, hambay ni Hesus, “Sirua, yari ang matuod nga Israelita, nga bukon madayà.” ");
INSERT INTO rol_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nagpangutana si Natanael, “Pauno mo ako nakilaya?” Nagsabat si Hesus, “Bago pa ikaw gingtawag ni Felipe, nakità ko na ikaw nga nagapungkò sa idayom ng punò ng igos*.” ");
INSERT INTO rol_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Naghambay si Natanael, “Maestro, ikaw gida ang Ungà ng Dios! Ikaw ang Harì ng Israel nga amon ginahuyat!” ");
INSERT INTO rol_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Naghambay si Hesus, “Nagatuo ka kay ginghambay ko nga nakità ko ikaw sa idayom ng punò ng igos*. Pero mas makatitingaya pa ang mga butang kaysa diri ang imo makikità.” ");
INSERT INTO rol_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Kag hambay pa gid ni Hesus sa inda, “Sa matuod lang ginahambay ko sa indo, makikità nindo ang langit nga bukas kag ang mga anghel ng Dios nga nagasinakà kag nagapinanaog paagi sa akon nga Ungà ng Tawo*.” ");
INSERT INTO rol_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Pagkaligad ng tuyo ka adlaw, may kasay* sa banwa ng Cana sa probinsya ng Galilea. Kag yadto ang nanay ni Hesus. ");
INSERT INTO rol_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ging-imbitar da sa kasayan si Hesus kag ang iya mga disipulo ");
INSERT INTO rol_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Nang malapit na maubos ang ilimnon, naghambay ang nanay ni Hesus sa iya, “Ubos na ang inda ning ilimnon.” ");
INSERT INTO rol_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Nagsabat si Hesus, “Babayi, basì ginahambay mo inà sa akon? Bukon pa ini ang oras agud ipakità ang akon gahom.” ");
INSERT INTO rol_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Pagkatapos naghambay ang iya nanay sa mga nagabulig, “Tumana lang nindo kung ano ang iya ihambay.” ");
INSERT INTO rol_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Igwa didto ning mabahoy nga mga tadyaw nga unom ka bilog. Nagasuyod ang kada isa ng 20 o 30 ka galon. Ginagamit ini sa panghugas sunò sa relihiyon ng mga Judio. ");
INSERT INTO rol_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Naghambay si Hesus sa mga nagabulig, “Pun-a nindo ng tubì ang mga tadyaw.” Nganì gingpunò ninda hasta sa bàbà. ");
INSERT INTO rol_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Pagkatapos naghambay si Hesus sa inda, “Magsandok na kamo kag day-on sa nagadumaya sa punsyon.” Nganì gingday-an ninda siya. ");
INSERT INTO rol_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Gingtigsiman ng nagadumaya ang tubì nga nahuman nga ilimnon. Wayà siya makasayod kung diin ini halin, kundì adto lang ang mga nagsandok ang nakakasayod. Gingtawag niya ang lyaki nga kinasay, ");
INSERT INTO rol_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","kag hambay niya, “Kadamuan nga tawo, ang kaayo-ayo nga ilimnon anay ang ginapainom. Kung bayong na ang mga bisita, imaw pa lang ang pagtao ng ordinaryo nga ilimnon. Pero ikaw, ginapaulihi mo galì ang pinakamaayo nga ilimnon.” ");
INSERT INTO rol_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Natabò ini sa Cana nga sakop sa probinsya ng Galilea. Imaw ini ang una sa mga milagro ni Hesus. Paagi diri, gingpakità niya ang iya gahom kag nagtuo ang mga disipulo sa iya. ");
INSERT INTO rol_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Pagkatapos ng kasayan, nagtugbong sa banwa ng Capernaum* si Hesus, ang iya nanay, ang iya mga manghod nga lyaki kag mga disipulo kag nagtinir sinda didto ning pila ka adlaw. ");
INSERT INTO rol_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Malapit na adto ang Pyesta ng mga Judio nga ginatawag, Pagligad ng Anghel*, nganì nagtukad si Hesus pakadto sa Jerusalem. ");
INSERT INTO rol_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Pag-abot niya sa templo, nakità niya nga may mga nagabaligyà ning mga baka, karnero kag salampati kag mga miyugbaylo ning kwarta*. ");
INSERT INTO rol_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Nganì naghuman siya ning pangbunay nga pisì kag gingpalayas niya sinda tanan sa templo. Gingpangbugaw niya paluwas ang mga karnero kag baka, gingpamilak naman niya ang mga kwarta nga sinsilyo ng mga miyugbaylo ning kwarta kag gingpamaliskad niya ang inda mga lamisa. ");
INSERT INTO rol_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Kag hambay niya sa mga miyugbaligyà ning salampati, “Day-a nindo ini tanan paluwas! Ayaw nindo paghumana nga baligyaan ang bayay ng akon Amay.” ");
INSERT INTO rol_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Nang makità ini ng iya mga disipulo, nadumduman ninda ang ginahambay ng Kasulatan, “Sa kadakò ng akon paghigugmà sa bayay ng akon Amay, ini ang magiging kabangdanan ng kamatayon ko.” ");
INSERT INTO rol_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Tungod sa ginghuman ni Hesus, nagpangutana ang mga miyugdumaya ng Judio sa iya, “Ano nga milagro ang imo maipapakità sa amon para pamatuuran nga ikaw hay may otoridad sa paghuman ini?” ");
INSERT INTO rol_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Nagsabat si Hesus, “Gubaa nindo ini nga templo kag sa suyod ng tuyo ka adlaw patindugon ko ini liwat!” ");
INSERT INTO rol_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Naghambay ang mga Judio, “Aba! 46 ka tuig ang pagpatindog ini nga templo, niyan nagahambay ka nga kaya mo patindugon liwat sa tuyo lang ka adlaw?” ");
INSERT INTO rol_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pero ang templo nga iya ginghambay hay ang iya lawas. ");
INSERT INTO rol_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Nganì nang nabanhaw si Hesus, nadumduman ng iya mga disipulo ang ginghambay niya. Nganì nagpati sinda sa Kasulatan kag sa mga butang nga ginghambay niya. ");
INSERT INTO rol_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Mintras yadto si Hesus sa Jerusalem, nang pyesta ng Pagligad ng Anghel, madamò ang nagtuo sa iya nang makità ninda ang mga milagro nga iya ginghuman. ");
INSERT INTO rol_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pero wayà gid nagsalig si Hesus sa inda kay sayod niya ang pagkatawo ng tanan. ");
INSERT INTO rol_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Nganì indì na siya kahinangyan nga balitaan ng aber sin-o parti sa kinaugalì ng tawo kay sayod gid niya ang inda tagipusuon. ");
INSERT INTO rol_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Niyan igwa isa ka tawo nga ang pangayan hay si Nicodemus. Siya hay miyembro ng grupo ng mga Pariseo kag isa sa mga pinunò ng Judio. ");
INSERT INTO rol_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Isa ka gab-i, nagkadto siya kay Hesus kag naghambay, “Maestro, sayod namon nga manunudlò ka nga gingsugò ng Dios. Kay wayà may makahuman ng mga milagro nga pareho ng imo ginahuman, kung wayà sa iya ang Dios.” ");
INSERT INTO rol_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Nagsabat si Hesus, “Sa matuod lang ginahambay ko sa imo, indì gid masakop sa paghaharì ng Dios ang aber sin-o kung indì siya matawo liwat.” ");
INSERT INTO rol_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nagsabat si Nicodemus, “Pauno baya matawo liwat ang isa nga tawo kung maguyang na siya? Imposible nga makasuyod pa siya liwat sa tiyan ng iya nanay agud matawo liwat!” ");
INSERT INTO rol_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Nagsabat naman si Hesus, “Sa matuod lang ginahambay ko sa imo, indì gid masakop sa paghaharì ng Dios ang isa nga tawo kung indì siya matawo sa tubì kag sa Espiritu Santo. ");
INSERT INTO rol_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Kay ang tawo nagaungà ng pisikal nga kabuhì, pero ang ging-ungà sa Espiritu Santo may espirituhanon nga kabuhì. ");
INSERT INTO rol_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","“Ayaw na matingaya sa ginghambay ko sa imo, ‘Kahinangyan tanan matawo liwat.’ ");
INSERT INTO rol_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Nagahuyop ang hangin aber diin niya gusto kag nabatian mo ang huni, pero indì mo masayuran kung sa diin ini nagahalin kag kung sa diin nagapakadto. Nganì imaw da ang aber sin-o nga natawo liwat paagi sa Espiritu Santo indì masayuran kung pauno ini natatabò.” ");
INSERT INTO rol_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nagpangutana si Nicodemus, “Pauno baya ini matabò?” ");
INSERT INTO rol_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Nagsabat si Hesus, “Dì ba kilaya ka nga manunudlò ng mga Israelita? Basì wayà mo pa ini maintindihi? ");
INSERT INTO rol_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Sa matuod lang ginahambay ko sa imo, ginabalità namon ang amon nasayuran kag ginapamatuuran namon ang amon nakità, ugaling wayà nindo ginapatihi ang amon pamatuod. ");
INSERT INTO rol_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Kung indì nganì nindo mapatihan ang akon ginghambay sa indo parti sa mga butang diri sa kalibutan, pauno nindo mapatihan kung ihambay nakon sa indo ang mga butang parti sa langit? ");
INSERT INTO rol_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Wayà gid tawo nga nakakadto sa langit, kundì ako lang, ang Ungà ng Tawo nga nagpanaog halin sa langit. ");
INSERT INTO rol_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Pareho nang gingpataas ni Moises ang sawa nga himò sa bronsi sa punta ng sungkod sa tiway nga lugar, kahinangyan da nga itaas ang Ungà ng Tawo sa kahoy. ");
INSERT INTO rol_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Agud ang aber sin-o nga magtuo sa iya hay magkaigwa ning kabuhì nga wayà katapusan. ");
INSERT INTO rol_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Kay ginghigugmà ng Dios ning sobra nga kadakò ang mga tawo sa kalibutan, nganì gingtao niya ang iya bugtong nga Ungà, agud ang aber sin-o nga magtuo sa iya hay indì mamatay kundì magkaigwa ning kabuhì nga wayà katapusan. ");
INSERT INTO rol_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kay gingsugò ng Dios ang iya Ungà diri sa kalibutan, indì para husgahan nga parusahan ang mga tawo, kundì luwason sinda paagi sa iya. ");
INSERT INTO rol_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Ang aber sin-o nga nagatuo sa iya hay wayà na ginahusgahi, pero ang aber sin-o nga wayà nagatuo hay nahusgahan na, kay wayà siya nagtuo sa bugtong nga Ungà ng Dios. ");
INSERT INTO rol_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Kag imaw ini ang basihan ng paghusga, nag-abot ang kahayag sa kalibutan, pero mas gingpalabi ng mga tawo ang kaduyom kaysa sa kahayag, kay malain ang inda mga hinimuan. ");
INSERT INTO rol_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ang aber sin-o nga nagahuman ning malain hay indì gusto sa iwag kay makikità nga malain ang inda mga ginahuman kung magpalapit sa iwag. ");
INSERT INTO rol_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pero ang aber sin-o nga nagakabuhì sa kamatuuran hay nagapalapit sa iwag, agud makità gid ng mga tawo ang inda maayo nga hinimuan nga pagsunod sa kabubut-on ng Dios.” ");
INSERT INTO rol_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Pagkatapos adto, nagkadto sina Hesus sa probinsya ng Judea. Didto siya nagtinir kaibahan ng iya mga disipulo kag nagabawtismo siya sa mga tawo. ");
INSERT INTO rol_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Si Juan hay nagabawtismo da didto sa Enon nga malapit sa Salim, kay dakò ang tubì didto kag nagakadto ang mga tawo para magpabawtismo. ");
INSERT INTO rol_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Nang adto nga tyempo, wayà pa napipriso si Juan.) ");
INSERT INTO rol_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Niyan, nagdiskusyon ang mga disipulo ni Juan kag isa ka Judio parti sa paglimpyo sunò sa layi ng inda relihiyon. ");
INSERT INTO rol_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Nganì nagpalapit sinda kay Juan kag naghambay, “Maestro, adtong nakaibahan mo sa kabuak ng Jordan nga gingpamatuuran mo sa amon, niyan nagabawtismo siya kag kadamò-damò ang nagakadto sa iya.” ");
INSERT INTO rol_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Nagsabat si Juan, “Wayà ning aber ano nga mababaton ang tawo, kung indì ini itao ng Dios sa iya. ");
INSERT INTO rol_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kamo mismo ang makapamatuod nang akon ginghambay nga bukon ako ang Kristo, kundì gingsugò ako ng Dios para ipreparar ang iya pag-abot. ");
INSERT INTO rol_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Pareho sa ginakasay, ang babayi nga kyasayon hay para sa lyaki nga kyasayon, pero ang amigo ng lyaki nga nagabulig sa inda pagpakasay hay nalilipay gid kung nababatian ang boses ng lyaki. Nganì pareho sa amigo ng lyaki nga kyasayon, tudo gid ang akon kalipay. ");
INSERT INTO rol_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Kahinangyan nga si Hesus lang ang mas maitaas kag ako mas magpakababà pa.” ");
INSERT INTO rol_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Yari ang mga tawo diri sa kalibutan, nganì ang aton ginahambay hay parti sa mga butang sa kalibutan. Pero ang halin sa langit hay makagagahom sa tanan. ");
INSERT INTO rol_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Aber pa ginapamatuuran niya ang iya nakità kag nabatian, pero wayà may nagapati sa iya ginapamatuod. ");
INSERT INTO rol_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ang aber sin-o nga nagapati sa iya ginghambay hay nagapamatuod nga ang hambay ng Dios hay matuod gid. ");
INSERT INTO rol_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kay ang gingsugò ng Dios hay nagahambay ng mensahe nga halin sa Dios, kay wayà gid limitasyon ang pagtao ng Dios sa iya ng Espiritu Santo. ");
INSERT INTO rol_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ginahigugmà ng Amay ang iya Ungà kag gingtao sa iya ang otoridad nga maggahom sa tanan. ");
INSERT INTO rol_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ang aber sin-o nga nagatuo sa Ungà, igwa kabuhì nga wayà katapusan. Pero ang wayà nagatuman sa Ungà hay wayà kabuhì, kundì magapadayon sa iya ang dakò nga kahangit ng Dios. ");
INSERT INTO rol_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Niyan, nabatian ng mga Pariseo nga mas madamò na ang mga disipulo ni Hesus kaysa kay Juan kag madamò na ang iya nababawtismuhan. ");
INSERT INTO rol_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Sa matuod lang, bukon mismo si Hesus ang nagapangbawtismo kundì ang iya mga disipulo.) ");
INSERT INTO rol_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Pagkasayod ni Hesus nga nabatian da ng mga Pariseo ang balità parti sa iya, naghalin siya sa probinsya ng Judea kag nagkadto sa Galilea. ");
INSERT INTO rol_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Kahinangyan niya nga mag-agi sa probinsya ng Samaria. ");
INSERT INTO rol_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Niyan nag-abot sinda sa isa ka syudad sa Samaria nga ginatawag, Sicar. Malapit didto ang uma nga gingtao ni Jacob sa iya ungà nga si Jose, ");
INSERT INTO rol_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","kag didto nga lugar yadto ang balon ni Jacob. Budlay na si Hesus sa pagpanaw, nganì nagpungkò siya sa alihid ng balon. Adto hay mga alas dose na. ");
INSERT INTO rol_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ang mga disipulo ni Hesus hay nagkadto sa banwa agud magbakay ning pagkaon. Mintras nagapungkò siya, may isa ka babayi nga taga-Samaria nga nag-abot para magsayok. Naghambay si Hesus, “Painom abi.” ");
INSERT INTO rol_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nagsabat ang babayi, “Ikaw hay Judio, babayi ako nga taga-Samaria, basì ginapangayuan mo ako tubì?” (Imaw ini ang ginghambay ng babayi kay wayà nagakaibahan ang mga Judio sa mga taga-Samaria.) ");
INSERT INTO rol_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Nagsabat si Hesus, “Kung nakasayod ka lang sa regalo nga halin sa Dios kag kung sin-o ako nga nagahambay sa imo, ‘Painom abi’, ikaw pa ang mangayò sa akon agud taw-an ta tubì nga nagatao kabuhì.” ");
INSERT INTO rol_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Naghambay naman ang babayi, “Nong, madayom ang balon kag wayà ka ning pangsandok. Pauno ka makabuoy tubì nga nagatao kabuhì? ");
INSERT INTO rol_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Basì, sobra ka pa ba sa amon kalulo-lulohan nga si Jacob nga nagtao ini nga balon sa amon? Nag-inom siya diri, ang iya mga ungà kag imaw da ang iya mga alilà nga hayop!” ");
INSERT INTO rol_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Nagsabat si Hesus, “Ang aber sin-o nga nagainom sa ini nga tubì hay mauuhaw liwat, ");
INSERT INTO rol_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","pero ang aber sin-o nga mag-inom ng tubì nga itao ko hay indì na gid mauuhaw hasta san-o. Kay ang tubì nga akon itao hay magiging kapareho ng tuburan sa suyod niya nga magaawas kag magatao sa iya ning kabuhì nga wayà katapusan.” ");
INSERT INTO rol_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Nganì naghambay ang babayi, “Nong, taw-i abi ako inà nga tubì agud indì na ako mauhaw o magbinalik-balik diri para magsayok.” ");
INSERT INTO rol_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Nagsabat si Hesus, “Balik anay sa indo kag day-a diri ang imo asawa.” ");
INSERT INTO rol_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Naghambay ang babayi, “Wayà ako asawa.” Naghambay naman si Hesus, “Tamà ang hambay mo nga, ‘Wayà ako asawa’, ");
INSERT INTO rol_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","kay igwa ka na lima nga naging asawa kag niyan bukon mo asawa ang imo ginaiba. Matuod gid ang ginghambay mo.” ");
INSERT INTO rol_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Tapos naghambay ang babayi, “Nong, sa sirò ko propeta ka. Puydi mangutana sa imo? ");
INSERT INTO rol_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ang amon mga kalulo-lulohan hay nagsamba sa Dios sa ini nga bukid. Pero kamo nga mga Judio nagahambay nga sa lugar ng Jerusalem kahinangyan sambahon ng mga tawo ang Dios.” ");
INSERT INTO rol_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Naghambay Si Hesus, “Patihi ang akon hambay! Magaabot ang oras nga sambahon nindo ang Dios nga Amay bukon sa ini nga bukid o sa Jerusalem. ");
INSERT INTO rol_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kamo nga mga taga-Samaria, wayà gid nindo makikilaya kung sin-o ang indo ginasamba. Pero kami nga mga Judio, kilaya namon ang amon ginasamba kay ang manluluwas magahalin sa mga Judio. ");
INSERT INTO rol_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Pero nag-abot na ang oras kag imaw na nganì ini, nga ang mga matuod nga nagasamba sa Dios nga Amay hay magasamba paagi sa bulig ng Espiritu Santo kag sunò sa kamatuuran kung sin-o gid siya. Kay imaw ini ang ginapangità ng Dios sa mga nagasamba sa iya. ");
INSERT INTO rol_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ang Dios hay espiritu, nganì ang mga nagasamba sa iya hay kahinangyan magsamba sa iya paagi sa bulig ng Espiritu Santo kag sunò sa kamatuuran kung sin-o gid siya.” ");
INSERT INTO rol_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Nagsabat naman ang babayi, “Sayod ko nga magaabot ang Mesias nga ginatawag da nga Kristo. Pag-abot niya, ipapasayod niya sa amon ang tanan nga butang.” ");
INSERT INTO rol_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Naghambay naman si Hesus, “Ako mismo nga nagapakig-istorya sa imo, ako ang Kristo.” ");
INSERT INTO rol_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Pagkatapos hambay ni Hesus, nag-abot ang iya mga disipulo halin sa banwa nga nagbakay ning pagkaon. Natingaya sinda kung basì nagapakig-istorya siya sa adto nga babayi. Pero wayà gid may nagpangutana sa iya, “Ano ang imo ginapangayò?” o “Basì nagapakig-istorya ka sa iya?” ");
INSERT INTO rol_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Niyan gingbilin ng babayi ang iya bangà kag nagbalik siya sa banwa. Pag-abot niya didto, nagpinamalità siya sa mga tawo. ");
INSERT INTO rol_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Hambay niya, “Kari anay kamo! Tan-awa nindo adtong tawo nga nakasayod ng tanan nga akon ginghuman! Siya na ba arà ang Kristo?” ");
INSERT INTO rol_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Nganì nagluwas ang mga tawo sa banwa kag nagkadto kay Hesus. ");
INSERT INTO rol_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Mintras wayà pa magaabot ang mga tawo didto kana Hesus, ginainagda siya ng mga disipulo nga magkaon kag hambay ninda, “Maestro, kaon na.” ");
INSERT INTO rol_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pero nagsabat si Hesus, “Igwa ako pagkaon nga wayà nindo nasasayuri.” ");
INSERT INTO rol_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Nganì nagpinangutan-an ang mga disipulo, “Sin-o baya ang nagdaya sa iya ning pagkaon?” ");
INSERT INTO rol_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Nagsabat si Hesus, “Ang pagkaon ko hay wayà iban kundì tumanon ang kabubut-on ng nagsugò sa akon kag tapuson ang ginapahuman niya. ");
INSERT INTO rol_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Dì ba hambay nindo, ‘Upat ka bulan pa bago magtig-aani?’ Pero ginahambay ko sa indo, lantawa nindo kag sirua ang mga tawo nga nagaabot. Daw sinda ang mga uhay sa mga uma nga maduyaw na kag kahinangyan na nga anihon. ");
INSERT INTO rol_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Pareho kamo ng mga miyug-ani nga suhuyan ng Dios. Ang mga tawo naman hay daw mga anihon, pagataw-an sinda ning kabuhì nga wayà katapusan. Nganì ang mga miyugtanom ng mensahe ng Dios kag ang mga miyug-ani hay pareho nga malilipay. ");
INSERT INTO rol_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Matuod gid ang hambayanon, ‘Iban ang miyugtanom kag iban naman ang miyug-ani.’ ");
INSERT INTO rol_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Pareho kamo ng mga miyug-ani nga akon ginasugò agud anihon ang wayà nindo gingpangabudlayi. Iban ang nagpangabudlay kag kamo ang nagaani sa inda gingpangabudlayan.” ");
INSERT INTO rol_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Madamò ang taga-Samaria sa adto nga banwa ang nagtuo kay Hesus tungod sa gingpamatuod ng babayi, “Siya ang nakasayod ng tanan nga akon ginghuman.” ");
INSERT INTO rol_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Nganì pag-abot ng mga taga-Samaria kay Hesus, nagpangabay sinda sa iya nga magtinir anay didto sa inda. Kag nagtinir siya didto ning duha ka adlaw. ");
INSERT INTO rol_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Tungod sa iya mensahe, mas kadamò ang nagtuo sa iya. ");
INSERT INTO rol_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Hambay ninda sa babayi, “Nagatuo kami niyan, bukon lang tungod sa imo ginghambay, kundì kami mismo ang nakabatì ng iya mensahe kag sayod namon nga siya gida ang Manluluwas ng mga tawo sa kalibutan.” ");
INSERT INTO rol_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Pagkatapos ng duha ka adlaw nga pagtinir didto ni Hesus, naghalin siya kag nagkadto sa Galilea. ");
INSERT INTO rol_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Si Hesus mismo ang nagpamatuod nga wayà propeta nga ginatahod ng mga tawo sa kaugalingon niya nga banwa.) ");
INSERT INTO rol_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Niyan pag-abot niya sa probinsya ng Galilea, maayo gid ang pagbaton sa iya ng mga tawo. Kay yadto da sinda sa pyesta sa Jerusalem kag nakità ninda ang tanan nga gingpanghuman niya didto. ");
INSERT INTO rol_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Nagkadto liwat si Hesus sa Cana nga sakop ng Galilea, kung sa diin ginghuman niya ang ilimnon halin sa tubì. Niyan sa banwa ng Capernaum, igwa isa ka opisyal ng gobyerno nga ang iya ungà nga lyaki hay may sakit. ");
INSERT INTO rol_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Nang mabatian niya nga nag-abot si Hesus sa Galilea, nagkadto siya kag nagpakitluoy sa iya nga kung puydi magtugbong siya kag paayuhon ang iya ungà, kay nagaagunisar na siya. ");
INSERT INTO rol_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Naghambay si Hesus sa iya, “Mintras indì kamo makakità ng mga milagro kag makatitingaya nga butang, indì kamo magtuo sa akon.” ");
INSERT INTO rol_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Nagsabat ang opisyal, “Nong, lusob na abi bago mamatay ang akon ungà.” ");
INSERT INTO rol_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Naghambay si Hesus, “Ulì na, kay nag-ayo na ang imo ungà.” Nagpati ang opisyal sa ginghambay ni Hesus, nganì nagpaulì na siya. ");
INSERT INTO rol_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Mintras nagatugbong siya, nasumpong niya ang iya mga ulipon kag gingbalità nga maayo na ang iya ungà. ");
INSERT INTO rol_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Nganì nagpangutana siya sa iya mga ulipon kung ano ang oras siya nag-ayo. Kag nagsabat sinda, “Kahapon, mga ala una nang hapon nahuwasan siya.” ");
INSERT INTO rol_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Nadumduman ng tatay nga imaw adto nga oras nang ginghambay ni Hesus, “Nag-ayo na ang imo ungà.” Nganì nagtuo siya kay Hesus kag imaw da ang iya bilog nga panimayay. ");
INSERT INTO rol_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Imaw ini ang pangaduha nga milagro nga ginghuman ni Hesus sa Galilea nang paghalin niya sa probinsya ng Judea. ");
INSERT INTO rol_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Pagkatapos adto, nagtukad naman si Hesus sa Jerusalem, para mag-atindir sa isa ka pyesta ng mga Judio. ");
INSERT INTO rol_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Niyan didto sa syudad ng Jerusalem, igwa ning pwertahan nga ginatawag, Agihan ng mga Karnero. Ini nga pwertahan hay may mataas nga pader nga bato. Malapit didto, igwa mabahoy nga dipusito ng tubì nga ginatawag sa Hebreo, Betesda. May lima nga balkon patiyog sa adto nga dipusito. ");
INSERT INTO rol_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Sa kada balkon, kadamò-damò ang nagatipon nga nagahigdà nga may mga sakit: mga buta, pakì kag paralisado. Nagahuyat sinda nga maghukay ang tubì. ");
INSERT INTO rol_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Kay kung kaamat, may nagababà nga anghel ng Ginoo kag ginakutaw ang tubì. Ang nauuna nga makalungoy pagkatapos makutaw ng anghel ang tubì, nagaayo ang aber ano nga sakit. ");
INSERT INTO rol_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Niyan may isa ka lyaki didto nga igwa ning sakit sa suyod ng 38 ka tuig. ");
INSERT INTO rol_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Nakità siya ni Hesus nga nagahigdà kag sayod niya nga madugay na siya didto. Nagpangutana si Hesus, “Gusto mo ba nga mag-ayo?” ");
INSERT INTO rol_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Nagsabat ang may sakit, “Huo, Nong, pero wayà ning tawo nga magdaya sa akon sa dipusito kung ginakutaw na ang tubì. Pakadto pa lang ako, may nauuna na sa akon.” ");
INSERT INTO rol_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Hambay ni Hesus, “Bangon, lukuta ang imo banig kag pumanaw na.” ");
INSERT INTO rol_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Adto nga daan, nag-ayo ang lyaki kag ginglukot niya ang iya banig kag nagpanaw-panaw. Natabò ini nang Adlaw nga Inugpahuway*. ");
INSERT INTO rol_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Nganì naghambay ang mga miyugdumaya ng Judio sa ini nga lyaki nga nag-ayo, “Hoy! Dì ba Adlaw nga Inugpahuway arinyan? Ginabawal inà ng aton Kasuguan nga day-on mo ang imo higdaan.” ");
INSERT INTO rol_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Pero nagsabat ang lyaki, “Ang tawo nga nagpaayo sa akon ang naghambay, ‘Lukuta ang imo banig kag pumanaw.’ ” ");
INSERT INTO rol_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Nagpangutana sinda, “Sin-o adto nga tawo ang naghambay sa imo, ‘Lukuta ang imo banig kag pumanaw’?” ");
INSERT INTO rol_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pero wayà makasayod adto nga lyaki nga ging-ayo kung sin-o ang nagpaayo sa iya, kay naghalin na si Hesus sa kadamò-damò nga tawo nga wayà nadiparahi. ");
INSERT INTO rol_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Pagkatapos, nakità liwat ni Hesus sa templo adto nga lyaki. Hambay ni Hesus sa iya, “O, maayo ka na. Ayaw na magpadayon sa pagpakasalà kay basì kung may mas malain pa gid nga matabò sa imo.” ");
INSERT INTO rol_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Nagpanaw ang lyaki kag nagkadto sa mga miyugdumaya ng Judio. Gingbalità niya sa inda nga si Hesus galì ang nagpaayo sa iya. ");
INSERT INTO rol_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Tungod sa ini nga ginghuman ni Hesus, tunà adto, ginahingabot na siya ng mga miyugdumaya ng Judio kay nagapaayo siya sa Adlaw nga Inugpahuway. ");
INSERT INTO rol_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pero gingsabat sinda ni Hesus, “Ang akon Amay padayon nga nagatrabaho hasta niyan, nganì nagatrabaho da ako.” ");
INSERT INTO rol_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Tungod sa ginghambay ni Hesus, mas lalò pa gid nga gingtinguhà ng mga miyugdumaya ng Judio nga patyon siya kay bukon lang ginglapas niya ang Adlaw nga Inugpahuway, kundì naghambay pa siya nga ang Dios ang iya Amay kung sa diin ginapapantay niya ang iya kaugalingon sa Dios. ");
INSERT INTO rol_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Nganì naghambay si Hesus sa inda, “Sa matuod lang ginahambay ko sa indo, ako nga Ungà ng Dios hay wayà gid may mahuhuman sa akon kaugalingon, kundì kung ano lang ang akon nakikità sa akon Amay, imaw ang akon ginahuman. Nganì kung ano ang ginahuman ng akon Amay, imaw da ang ginahuman ko nga iya Ungà. ");
INSERT INTO rol_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Kay ginapalanggà gid ako ng akon Amay, nganì ginapakità niya ang tanan nga iya ginahuman kag mas sobra pa gid diri nga mga butang ang iya ipapakità sa akon, agud matingaya gid kamo. ");
INSERT INTO rol_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kung pauno ang akon Amay hay nagabanhaw sa mga patay kag nagatao ng kabuhì, imaw da ako nga iya Ungà, nagatao ng kabuhì sa bisan sin-o nga gusto ko taw-an. ");
INSERT INTO rol_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Bukon ang akon Amay ang magahusga sa mga tawo, kundì ako nga iya Ungà ang gingtaw-an niya ng otoridad para maghusga. ");
INSERT INTO rol_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ginghuman niya ini, agud magrespito ang tanan sa akon nga iya Ungà pareho ng pagtahod sa akon Amay. Nganì ang wayà nagatahod sa akon nga iya Ungà, wayà da nagarespito sa akon Amay nga nagsugò sa akon. ");
INSERT INTO rol_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Sa matuod lang ginahambay ko sa indo, ang aber sin-o nga nagapamatì ng akon mensahe kag nagatuo sa akon Amay nga nagsugò sa akon hay may kabuhì nga wayà katapusan. Indì na siya pagaparusahan ning kamatayon kay wayà na siya sa gahom ni Satanas kundì sakop na ng gahom ng Dios kag igwa na siya bag-o nga kabuhì. ");
INSERT INTO rol_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Sa matuod lang ginahambay ko sa indo, magaabot ang oras kag imaw na nganì ini. Mababatian ng mga patay ang mensahe ng Ungà ng Dios kag ang mga nagatuman hay mabubuhì. ");
INSERT INTO rol_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kung pauno ang akon Amay hay may gahom sa pagtao kabuhì, imaw da ako nga Ungà hay gingtaw-an niya gahom sa pagtao kabuhì sa mga tawo. ");
INSERT INTO rol_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Gingtaw-an niya ako otoridad nga maghusga, kay ako ang Ungà ng Tawo. ");
INSERT INTO rol_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ayaw kamo matingaya sa ini nga mga butang kay nagaabot na ang oras nga mababatian ng tanan nga patay ang akon boses, ");
INSERT INTO rol_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","kag magaluwas sinda sa mga lubungan. Ang mga tawo nga naghuman ning maayo hay pagabanhawon para magkaigwa kabuhì nga wayà katapusan. Pero ang mga tawo nga naghuman ning malain hay pagabanhawon para maparusahan. ");
INSERT INTO rol_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Wayà gid ako may mahuhuman sa akon kaugalingon, kundì nagahusga ako kung ano ang ginahambay ng Amay sa akon. Ang paghusga ko hay tamà, kay bukon ko ini kaugalingon nga kagustuhan kundì ang kabubut-on ng nagsugò sa akon.” ");
INSERT INTO rol_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Naghambay pa gid si Hesus, “Niyan kung ako lang gid ang nagapamatuod parti sa akon kaugalingon, kabigon nindo nga bukon matuod ang akon ginahambay. ");
INSERT INTO rol_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pero igwa ning isa nga nagapamatuod parti sa akon kag sayod ko nga matuod ang ginahambay niya parti sa akon. ");
INSERT INTO rol_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Nagsugò kamo ning mga tawo para magpamatì kay Juan nga Miyugbawtismo kag matuod gid ang ginghambay niya parti sa akon. ");
INSERT INTO rol_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Pero ako, indì ko na kahinangyan ang pamatuod ng aber sin-o. Gingbalità ko lang ang pamatuod ni Juan kag kabay pa nga mapatihan nindo ini, agud maluwas kamo ng Dios. ");
INSERT INTO rol_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ang kapareho ni Juan hay iwagan nga nagasiga kag nagahayag. Nalipay kamo sa iya mensahe aber kadalì lang. ");
INSERT INTO rol_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Pero igwa pa gid ako pamatuod nga mas sobra sa gingpamatuod ni Juan parti sa akon. Ini hay ang ginapatrabaho ng Amay sa akon nga dapat tapuson ko. Ang mga makatitingaya nga ginahuman ko ang nagapamatuod nga ang akon Amay ang nagsugò sa akon. ");
INSERT INTO rol_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","“Kag ang akon Amay nga nagsugò sa akon, siya mismo ang nagpamatuod parti sa akon. Aber kasan-o wayà nindo mabatii ang iya boses kag wayà nindo makità ang iya hitsura. ");
INSERT INTO rol_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Kag wayà kamo nagakabuhì sunò sa iya mensahe kay wayà kamo nagatuo sa akon nga iya gingsugò para sa indo. ");
INSERT INTO rol_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Ginaistudyuhan gid nindo maayo ang mga Kasulatan kay nagalaom kamo nga paagi diri magkaigwa kamo kabuhì nga wayà katapusan. Ang Kasulatan mismo nagapamatuod parti sa akon. ");
INSERT INTO rol_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Pero indì da nindo gusto nga magsunod sa akon agud magkaigwa kamo kabuhì nga wayà katapusan. ");
INSERT INTO rol_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Wayà ko ginabatuna ang pagdayaw ng mga tawo. ");
INSERT INTO rol_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Kilaya ko gid kung ano nga klasi kamo nga tawo. Wayà kamo matuod nga paghigugmà sa Dios sa indo tagipusuon. ");
INSERT INTO rol_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nagkari ako nga may otoridad halin sa akon Amay, pero wayà nindo ako pagbatuna. Kung may iban nga mag-abot nga nagagamit ng iya kaugalingon nga otoridad, indo siya ginabaton. ");
INSERT INTO rol_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nganì indì kamo makatuo sa akon kay ang indo ginapinangità hay pagdayaw sa isa kag isa, imbis nga pagdayaw halin sa isa lang nga Dios. ");
INSERT INTO rol_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Ayaw nindo mag-isipa nga ako ang maakusar sa indo sa atubangan ng akon Amay. Si Moises nga indo ginasaligan, ang maakusar sa indo. ");
INSERT INTO rol_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kung matuod nga nagpati kamo kay Moises, dapat magtuo da kamo sa akon kay ang gingsulat niya hay parti sa akon. ");
INSERT INTO rol_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pero tungod wayà kamo nagapati sa iya mga gingsulat, pauno nindo mapatihan ang akon mga ginahambay?” ");
INSERT INTO rol_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Pagkatapos adto nga mga natabò, nagtabok sina Hesus sa Lawà ng Galilea* nga ginatawag da, Lawà ng Tiberias*. ");
INSERT INTO rol_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Kag kadamò-damò gid nga tawo ang nagasinunod sa iya, kay nakità ninda ang mga milagro nga pagpang-ayo niya sa mga may sakit. ");
INSERT INTO rol_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Niyan nagtukad si Hesus kag ang iya mga disipulo sa bakuyod kag nagpungkò didto. ");
INSERT INTO rol_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Malapit na adto ang pyesta ng mga Judio nga ginatawag, Pagligad ng Anghel. ");
INSERT INTO rol_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Pagtan-aw ni Hesus, nakità niya ang madamò gid nga mga tawo nga nagapalapit sa iya. Nganì naghambay siya kay Felipe, “Sa diin baya kita makabakay ning pagkaon agud makakaon ini tanan nga tawo?” ");
INSERT INTO rol_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Imaw ini ang pangutana ni Hesus kay gusto lang niya nga tistingon si Felipe. Pero sayod na ni Hesus kung ano ang iya humanon. ");
INSERT INTO rol_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Nagsabat si Felipe, “Ini nga kadamò nga tawo, aber wayo ka bulan nga sweldo ng ordinaryo nga trabahador, kuyang pa ini nga ibakay ning inda pagkaon aber tigmaintik!” ");
INSERT INTO rol_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Pagkatapos, si Andres nga manghod ni Simon Pedro, isa da sa mga disipulo ni Hesus naghambay, ");
INSERT INTO rol_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Igwa diri ning solterito nga may bayon nga lima ka bilog nga tinapay kag duha nga isdà. Pero ano lang ini sa tiyad inà kadamò nga tawo?” ");
INSERT INTO rol_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Hambay ni Hesus, “Papungkua nindo ang mga tawo.” Nganì gingpapungkò ninda sinda kay malapad da ang gunahon didto nga lugar. Sa kadamò ng tawo, mga 5,000 ang lyaki. ");
INSERT INTO rol_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Pagkatapos, gingbuoy ni Hesus ang tinapay kag nagpasalamat sa Dios kag gingpapanao niya ini sa mga tawo. Imaw da ang iya ginghuman sa isdà kag gingpapataw-an ang tanan hasta gusto ninda. ");
INSERT INTO rol_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Nang mabusog na sinda, naghambay si Hesus sa iya mga disipulo, “Tipuna nindo ang nabilin agud wayà may mauyak.” ");
INSERT INTO rol_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Nganì gingtipon ninda ang nabilin sa lima ka bilog nga tinapay nga gingpakaon sa mga tawo kag nakapunò pa ng dose ka ayat* nga sobra ng mga nagkaon. ");
INSERT INTO rol_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Pagkakità ng mga tawo sa milagro nga ginghuman ni Hesus, naghambay sinda, “Imaw na gida ini ang ginghambay nga propeta nga maabot sa kalibutan!” ");
INSERT INTO rol_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Nasayuran na nga daan ni Hesus nga gusto ng mga tawo nga piliton siya nga maging harì ninda, nganì naghalin siya didto kag nagpakadto sa bakuyod nga siya lang. ");
INSERT INTO rol_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Nang manayumsom na, naglusob sa baybay ang mga disipulo ni Hesus, ");
INSERT INTO rol_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","kag nagsakay sa dyapang* agud magtabok pakadto sa Capernaum. Maduyom na, pero wayà pa nag-abot si Hesus. ");
INSERT INTO rol_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Mintras nagabyahe sinda, nagkusog ang hangin kag nagdagkò ang humbak. ");
INSERT INTO rol_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Nang makabugsay na sinda ning mga lima o unom ka kilometro, nakità ninda si Hesus nga nagapanaw sa ibabaw ng dagat nga nagapalapit sa inda. Nganì hinadlukan gid sinda. ");
INSERT INTO rol_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pero naghambay si Hesus, “Ako ini! Ayaw kamo mahadlok.” ");
INSERT INTO rol_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Nganì nalipay gid sinda nga gingpasakay si Hesus. Pagkasakay ni Hesus, nakaabot nga daan sinda sa piliw nga inda kadtuan. ");
INSERT INTO rol_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Pagkaaga, nakità ng mga tawo nga nabilin sa kabuak ng dagat nga wayà ning iban nga dyapang didto, kundì adto lang ang gingsakyan ng mga disipulo. Sayod ninda nga si Hesus hay bukon kaibahan ng mga disipulo nang paglarga ninda. ");
INSERT INTO rol_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Niyan, halin sa Tiberias may nag-abot nga iban nga mga dyapang sa lugar nga didto nagpakaon ang Ginoo ning tinapay nga iya gingpasalamatan sa Dios. ");
INSERT INTO rol_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Nang makità ng mga tawo nga si Hesus wayà didto o ang iya mga disipulo, nagsakay sinda sa mga dyapang kag nagkadto sa Capernaum agud pangitaon si Hesus. ");
INSERT INTO rol_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nang makità ninda si Hesus sa kabuak, hambay ninda, “Maestro, kasan-o ka pa nag-abot diri?” ");
INSERT INTO rol_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Nagsabat si Hesus, “Sa matuod lang ginahambay ko sa indo, ginapinangità nindo ako bukon kay nakità nindo ang mga milagro nga akon ginghuman, kundì kay nakakaon kamo ning tinapay kag nabusog. ");
INSERT INTO rol_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ayaw kamo magpangabudlay para sa pagkaon nga nasisirà lang da, kundì ang tinguhaon nindo hay ang pagkaon nga indì masirà. Ako nga Ungà ng Tawo ang magtao ini sa indo, para magkaigwa kamo kabuhì nga wayà katapusan. Kay gingpakità ng Dios nga Amay nga ako ang gingtaw-an niya otoridad.” ");
INSERT INTO rol_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Nganì nagpangutana sinda, “Ano ang dapat namon nga humanon, agud masunod namon ang kabubut-on ng Dios?” ");
INSERT INTO rol_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Nagsabat si Hesus, “Imaw ini ang gusto ng Dios nga humanon nindo: magtuo kamo sa akon nga iya gingsugò.” ");
INSERT INTO rol_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","Pero naghambay sinda, “Niyan, ano nga milagro ang imo humanon agud makità namon para magtuo kami sa imo? Ang amon mga kalulo-lulohan hay nagkaon ng ginatawag, Manna*, didto sa tiway nga lugar, sunò sa gingsulat, ‘Gingtaw-an sinda ni Moises ning pagkaon nga halin sa langit!’ Niyan, ano ang imo humanon?” ");
INSERT INTO rol_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Nagsabat si Hesus, “Sa matuod lang ginahambay ko sa indo, bukon si Moises ang nagtao sa inda ning pagkaon nga halin sa langit, kundì ang akon Amay. Niyan siya da ang nagatao sa indo ning matuod nga pagkaon nga halin sa langit. ");
INSERT INTO rol_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kay ang matuod nga pagkaon nga ginatao ng Dios, wayà ning iban kundì siya nga naghalin sa langit kag nagatao ning kabuhì nga wayà katapusan sa mga tawo diri sa kalibutan.” ");
INSERT INTO rol_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Sa nga daan naghambay sinda, “Nong, taw-i abi kami permi inà nga pagkaon.” ");
INSERT INTO rol_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Naghambay si Hesus, “Ako mismo ang tinapay nga nagatao ning kabuhì. Ang aber sin-o nga nagapalapit sa akon hay indì na magutom kag ang nagatuo sa akon hay indì na mauhaw hasta san-o. ");
INSERT INTO rol_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pero pareho ng ginghambay ko sa indo, aber nakità na nindo ako, wayà pa gihapon kamo nagatuo sa akon. ");
INSERT INTO rol_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ang tanan nga ginatao ng Amay sa akon hay magapalapit sa akon kag ang aber sin-o nga magpalapit sa akon hay indì ko gid pagasikwayon. ");
INSERT INTO rol_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kay nagkari ako halin sa langit, bukon para tumanon ang akon kabubut-on, kundì ang kabubut-on ng nagsugò sa akon. ");
INSERT INTO rol_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Niyan imaw ini ang kabubut-on ng nagsugò sa akon: nga indì ko gid pabay-an ang mga tawo nga gingtao ng Dios sa akon, para wayà may maduyà aber isa, kundì akon sinda pagabanhawon sa ulihi nga adlaw. ");
INSERT INTO rol_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kay ini ang kabubut-on ng akon Amay: ang aber sin-o nga nagakilaya kag nagatuo sa akon nga Ungà ng Dios hay magkaigwa ning kabuhì nga wayà katapusan kag pagabanhawon ko siya sa ulihi nga adlaw.” ");
INSERT INTO rol_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Nganì nagminuyumuyo ang mga Judio parti sa ginghambay ni Hesus kay hambay niya, “Ako ang tinapay nga naghalin sa langit.” ");
INSERT INTO rol_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Naghambay sinda, “Dì ba ini si Hesus nga ungà ni Jose? Kilaya gid naton ang iya tatay kag nanay. Basì naghambay siya nga nagbabà siya halin sa langit?” ");
INSERT INTO rol_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Nagsabat si Hesus, “Ayaw kamo magminuyumuyo. ");
INSERT INTO rol_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Wayà ning aber isa nga makapalapit sa akon para magtuo, mintras indì siya day-on ng Amay nga nagsugò sa akon. Kag pagabanhawon ko siya sa ulihi nga adlaw. ");
INSERT INTO rol_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ini ang gingsulat ng mga propeta, ‘Pagatudluan ng Dios ang tanan nga mga tawo.’ Nganì ang tanan nga nagapamatì kag nagatuon sa ginatudlò ng akon Amay hay nagapalapit sa akon. ");
INSERT INTO rol_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Wayà gid ning aber isa nga nakakità sa Amay. Ako nga naghalin sa Dios nga Amay, imaw lang gid ang nakakità sa iya. ");
INSERT INTO rol_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Sa matuod lang ginahambay ko sa indo, ang nagatuo sa akon hay igwa ning kabuhì nga wayà katapusan. ");
INSERT INTO rol_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ako ang tinapay nga nagatao ning kabuhì. ");
INSERT INTO rol_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nagkaon ang indo mga kalulo-lulohan ning manna didto sa tiway nga lugar, pero nagkamatay gihapon sinda. ");
INSERT INTO rol_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pero ang aber sin-o nga magkaon ini nga tinapay nga nagbabà halin sa langit hay indì na mamatay. ");
INSERT INTO rol_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ako ang tinapay nga nagatao ning kabuhì nga nagbabà halin sa langit. Ang aber sin-o nga magkaon ini nga tinapay hay mabubuhì ng wayà katapusan. Ini nga tinapay nga itatao ko para sa mga tawo sa kalibutan hay wayà ning iban kundì ang akon unod.” ");
INSERT INTO rol_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Niyan nagdiniskusyon ang mga Judio nga nagahambay, “Imposible! Pauno niya itao ang iya unod para kaunon naton?” ");
INSERT INTO rol_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Nganì naghambay si Hesus, “Sa matuod lang ginahambay ko sa indo, mintras indì nindo kaunon ang unod ng Ungà ng Tawo kag inumon ang iya dugò, indì gid kamo magkaigwa ning kabuhì nga wayà katapusan. ");
INSERT INTO rol_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Pero ang aber sin-o nga magkaon ng akon unod kag mag-inom ng akon dugò hay igwa ng ini nga kabuhì kag pagabanhawon ko siya sa ulihi nga adlaw. ");
INSERT INTO rol_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kay ang akon unod ang matuod nga pagkaon kag ang akon dugò ang matuod nga ilimnon. ");
INSERT INTO rol_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ang bisan sin-o nga nagakaon ng akon unod kag nagainom ng akon dugò hay nagapabilin nga nagapakig-isa sa akon kag ako sa iya. ");
INSERT INTO rol_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ang akon Amay nga nagsugò sa akon ang ginahalinan ng kabuhì kag nagakabuhì ako tungod sa iya; imaw da ang nagakaon sa akon magakabuhì tungod sa akon. ");
INSERT INTO rol_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ako ang tinapay nga halin sa langit. Bukon ini pareho sa manna nga gingkaon ng indo mga kalulo-lulohan, kay nagkamatay gihapon sinda. Pero ang nagakaon ng ini nga tinapay nga akon ginahambay sa indo hay magakabuhì sa wayà katapusan.” ");
INSERT INTO rol_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ginghambay ini ni Hesus nang siya nagapanudlò didto sa sinagoga* sa Capernaum. ");
INSERT INTO rol_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Nang mabatian ini ng madamò nga disipulo ni Hesus, hambay ninda, “Kahugà-hugà ang iya ginatudlò, sin-o ang makakaintindi ini?” ");
INSERT INTO rol_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Aber wayà may nagbalità kay Hesus, sayod niya nga nagareklamo ang iya mga disipulo, nganì naghambay siya, “Naglain ba ang indo buot tungod sa akon ginatudlò? ");
INSERT INTO rol_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ano baya kung makità nindo ang Ungà ng Tawo nga nagabalik paibabaw sa iya ginghalinan? ");
INSERT INTO rol_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ang Espiritu Santo ang nagatao ning espirituhanon nga kabuhì, bukon ang unod. Kay wayà ning gahom ang lawas para magtao ini nga kabuhì. Ang akon ginghambay sa indo hay halin sa Espiritu Santo kag nagatao ning kabuhì. ");
INSERT INTO rol_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pero igwa dirà ning pila sa indo nga wayà nagatuo sa akon.” Ginghambay ini ni Hesus kay nang una pa lang sayod niya kung sin-o ang wayà nagatuo sa iya kag kung sin-o ang magatraidor sa iya. ");
INSERT INTO rol_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Naghambay pa siya, “Nganì naghambay ako sa indo nga wayà ning aber isa nga makapalapit sa akon mintras indì itugot sa iya ng akon Amay.” ");
INSERT INTO rol_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tunà adto, madamò sa mga disipulo ni Hesus ang nagbayà sa iya kag wayà na nagsunod. ");
INSERT INTO rol_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Nganì nagpangutana si Hesus sa iya dose nga apostoles, “Kamo, gusto da ba nindo nga bayaan ako?” ");
INSERT INTO rol_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Nagsabat si Simon Pedro, “Ginoo, kanin-o pa kami makadto? Ikaw lang ang may ginatudlò nga nagatao kabuhì nga wayà katapusan. ");
INSERT INTO rol_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nagatuo kami sa imo kag sayod namon nga ikaw imaw ang Balaan nga gingsugò ng Dios.” ");
INSERT INTO rol_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Naghambay si Hesus, “Dì ba gingpilì ko kamo nga dose? Pero ang isa sa indo hay ginasapian ng diyablo.” ");
INSERT INTO rol_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Si Judas nga ungà ni Simon Iscariote ang gusto niya hambayon. Siya hay isa sa dose nga apostoles, nga sa ulihi imaw ang magatraidor kay Hesus. ");
INSERT INTO rol_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Pagkatapos adto, ginglibot ni Hesus ang mga baryo sa probinsya ng Galilea. Indì niya gusto magkadto sa probinsya ng Judea, kay ang mga miyugdumaya nga Judio didto ginatinguhà siya nga patyon. ");
INSERT INTO rol_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Niyan malapit na ang pyesta ng mga Judio nga ginatawag, Pyesta ng mga Tolda*. ");
INSERT INTO rol_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Nganì naghambay ang mga manghod nga lyaki ni Hesus sa iya, “Sige! Panaw na kag magkadto sa Judea agud makità ng imo mga disipulo ang mga makatitingaya nga imo ginahuman. ");
INSERT INTO rol_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kay kung gusto ng tawo makilaya ng tanan, wayà niya ginatagua ang iya mga ginahuman. Nagahuman ka lang da ning mga makatitingaya, aba, basì indì ka magpakilaya sa bilog nga kalibutan?” ");
INSERT INTO rol_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ginghambay ini ng mga manghod ni Hesus kay aber sinda hay wayà nagatuo sa iya. ");
INSERT INTO rol_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Nagsabat si Hesus sa inda, “Wayà pa nagaabot ang akon oras, pero sa indo, puydi kamo magkadto aber ano nga oras. ");
INSERT INTO rol_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Wayà nahahangit sa indo ang mga tawo diri sa kalibutan. Pero sa akon, nahahangit gid sinda kay ginabisto ko ang inda malain nga mga hinimuan. ");
INSERT INTO rol_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kamo lang ang kadto sa pyesta, indì ako magkadto kay wayà pa nagaabot ang akon oras.” ");
INSERT INTO rol_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Pagkahambay ini ni Hesus, nagpabilin siya sa Galilea. ");
INSERT INTO rol_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Pero pagkahalin ng mga manghod ni Hesus, nagkadto da siya sa pyesta, ugaling patagò lang. ");
INSERT INTO rol_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ginapinangità siya ng mga miyugdumaya nga Judio sa pyesta. Naghambay sinda, “Diin baya adto nga tawo?” ");
INSERT INTO rol_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Niyan, may mga tawo nga nagahinutikan parti kay Hesus. Ang iban naghambay, “Maayo siya nga tawo.” Ang hambay naman ng iban, “Bukon! Ginapatayang lang niya ang mga tawo.” ");
INSERT INTO rol_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pero wayà gid sinda nagahambay ning makusog parti sa iya tungod sa kahadlok sa mga miyugdumaya nga Judio. ");
INSERT INTO rol_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Nang nagatungà-tungà na ang Pyesta, nagkadto si Hesus sa templo kag nagtudlò. ");
INSERT INTO rol_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Natingaya gid ang mga miyugdumaya nga Judio kag naghambay, “Pauno baya ini nga tawo nakatuon? Basì madamò siya nasasayuran?” ");
INSERT INTO rol_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Nganì nagsabat si Hesus sa inda, “Ang akon ginatudlò hay bukon halin sa akon, kundì halin sa Dios nga nagsugò sa akon. ");
INSERT INTO rol_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ang aber sin-o nga nagahandom nga tumanon ang kabubut-on ng Dios, masasayuran gid niya kung ang akon ginatudlò hay halin sa Dios o akon-akon lang. ");
INSERT INTO rol_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ang tawo nga nagatudlò sa iya kaugalingon nga kamayad hay nagahandom ng pagdayaw sa iya kaugalingon. Pero ang nagatinguhà ng pagdayaw sa nagsugò sa iya hay nagatudlò ning matuod kag wayà siya nagapinusong. ");
INSERT INTO rol_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Dì ba gingtao ni Moises sa indo ang Kasuguan? Pero wayà gid aber isa sa indo nga nagatuman. Kay kung nagatuman kamo, basì gusto nindo ako patyon?” ");
INSERT INTO rol_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Nagsabat ang mga tawo, “Ikaw hay ginasapian ng demonyo! Sin-o ang gusto magpatay sa imo?” ");
INSERT INTO rol_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Nagsabat si Hesus, “Natingaya gid kamo tanan kay may isa ka tawo nga ging-ayo ko sa Adlaw nga Inugpahuway. ");
INSERT INTO rol_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Pero kamo da nagatrabaho sa Adlaw nga Inugpahuway sa pagsunod nindo sa Kasuguan ni Moises parti sa pagpaltak* sa lapsag. (Sa matuod lang ining indo namat-an hay bukon halin kay Moises kundì sa indo mga kalulo-lulohan.) ");
INSERT INTO rol_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ginapaltak nindo ang lapsag sa Adlaw nga Inugpahuway, pero wayà nindo ini ginakabig nga paglapas sa Kasuguan ni Moises. Kung tiyad ini, basì nahahangit kamo sa akon kay ging-ayo ko gid ang isa ka tawo sa Adlaw nga Inugpahuway? ");
INSERT INTO rol_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ayaw magpanghusga sunò sa pangluwas nga indo nakikità, kundì hunahunaa anay ini ning maayo, agud makahusga kamo ning tamà.” ");
INSERT INTO rol_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Niyan naghambay ang iban nga mga taga-Jerusalem, “Dì ba, imaw ini ang tawo nga gusto patyon ng mga pinunò naton? ");
INSERT INTO rol_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Yarà siya ho, nagahambay sa publiko, basì wayà may nagahambay kontra sa iya? Siguro nagapati na ang mga pinunò nga siya ang Kristo. ");
INSERT INTO rol_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pero imposible, kay sayod naton kung diin naghalin ini nga tawo. Kung mag-abot na ang Kristo, wayà ning aber sin-o nga makasayod kung diin siya maghalin.” ");
INSERT INTO rol_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Nganì nang nagatudlò pa si Hesus sa templo, naghambay siya ning makusog, “Kilaya na ba nindo kung sin-o gid ako kag sayod ba nindo kung sa diin ako naghalin? Nagkari ako bukon sa akon kaugalingon nga kagustuhan, kundì ang Dios nga matuod ang nagsugò sa akon. Wayà nindo siya nakikilaya, ");
INSERT INTO rol_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","pero ako, kilaya ko gid siya kay halin ako sa iya kag siya mismo ang nagsugò sa akon.” ");
INSERT INTO rol_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Nganì nang mabatian ini ng mga miyugdumaya ng Judio, gingtinguhà ninda nga dakpon si Hesus. Pero wayà ning may nag-aristo sa iya kay wayà pa nag-abot ang oras nga ini hay matabò. ");
INSERT INTO rol_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Aber tiyad ini, madamò nga tawo ang nagtuo sa iya kag naghambay, “Pag-abot ng Kristo, makakahuman arà siya ning mas labaw nga mga milagro kaysa sa ginghuman ng ini nga tawo?” ");
INSERT INTO rol_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Nang mabatian ng mga Pariseo ang paghinutikan ng mga tawo parti kay Hesus, nagsugò sinda kag ang mga pinunò nga parì ning mga gwardya ng templo para dakpon siya. ");
INSERT INTO rol_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Naghambay si Hesus, “Matag-od na lang ang oras nga makaibahan nindo ako, pagkatapos mabalik na ako sa nagsugò sa akon. ");
INSERT INTO rol_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Pangitaon nindo ako pero indì nindo ako makità, kay indì kamo makakadto sa akon kadtuan.” ");
INSERT INTO rol_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Nganì nagpinangutan-an ang mga miyugdumaya ng Judio, “Diin baya ini nga tawo makadto nga indì na naton siya makikità? Makadto ba arà siya sa mga malayò nga lugar nga ginaistaran ng iban nga mga kasimanwa naton agud magtudlò sa mga Griego? ");
INSERT INTO rol_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ano ang gusto niya hambayon, ‘Pangitaon nindo ako pero indì nindo ako makità, kay indì kamo makakadto sa akon kadtuan’?” ");
INSERT INTO rol_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Niyan sa ulihi nga adlaw ng pyesta nga imaw ini ang pinakaimportante, nagtindog si Hesus kag naghambay ning makusog, “Ang bisan sin-o nga ginauhaw hay magpalapit sa akon kag mag-inom. ");
INSERT INTO rol_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Kay ginahambay ng Kasulatan, ‘Ang aber sin-o nga nagatuo sa akon, may tubì nga nagatao ning kabuhì nga magailig daw tuburan halin sa iya tagipusuon.’ ” ");
INSERT INTO rol_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","(Ang gusto hambayon ni Hesus sa tubì nga nagatao ning kabuhì hay ang Espiritu Santo nga malapit na itao sa mga nagatuo sa iya. Kay nang adto nga tyempo wayà pa maitao ang Espiritu Santo kay wayà pa si Hesus gingdaya palangit kag gingtaw-an ning pinakamataas nga pagdayaw.) ");
INSERT INTO rol_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nang mabatian ng kadamuan ang ginghambay ni Hesus, ang iban naghambay, “Imaw na gida ini ang propeta nga aton ginahuyat.” ");
INSERT INTO rol_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ang iban naman naghambay, “Siya ang Kristo!” Pero naghambay pa gid ang iban, “Bukon! Kay indì puydi nga maghalin ang Kristo sa Galilea! ");
INSERT INTO rol_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Dì ba ginahambay ng Kasulatan nga ang Kristo hay inapo ni David kag magahalin sa Betlehem, ang banwa nga didto natawo si David?” ");
INSERT INTO rol_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Nganì wayà nagkaisa ang mga tawo kung sin-o gid si Hesus. ");
INSERT INTO rol_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ang iban gusto siya dakpon, pero wayà ning may nag-aristo sa iya. ");
INSERT INTO rol_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Niyan, nagbalik ang mga gwardya ng templo sa mga pinunò nga parì kag sa mga Pariseo nga nagsugò sa inda agud dakpon si Hesus. Nagpangutana ang nagsugò sa inda, “Basì wayà nindo siya pagday-a diri?” ");
INSERT INTO rol_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Nagsabat ang mga gwardya, “Wayà pa ning aber sin-o nga nagahambay kumpara sa inà nga tawo!” ");
INSERT INTO rol_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Naghambay ang mga Pariseo, “Ang gusto nindo hambayon patì kamo, naluko na da niya? ");
INSERT INTO rol_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Nakakità na ba kamo ning aber isa sa amon nga pinunò o Pariseo nga nagatuo sa iya? Wayà gid! ");
INSERT INTO rol_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ang mga tawo lang gid nga wayà kasayod sa Kasuguan ang nagatuo sa iya. Parusahan gid sinda ng Dios!” ");
INSERT INTO rol_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ang isa diri sa mga Pariseo hay si Nicodemusnga dati anay nagpakigkità kay Hesus. Niyan naghambay siya sa inda, ");
INSERT INTO rol_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Dì ba, ginabawal ng aton Kasuguan nga husgahan ang isa ka tawo nga wayà pa maimbistigahi? Dapat anay mapamatian naton siya agud masayuran naton kung ano ang iya ginghuman.” ");
INSERT INTO rol_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nagsabat sinda, “Basì, taga-Galilea ka da? Usisaa ang mga Kasulatan kag masasayuran mo nga wayà ning propeta nga magahalin sa Galilea!” ");
INSERT INTO rol_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Pagkatapos adto, nagpaulì na sinda tanan. ");
INSERT INTO rol_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Niyan nagkadto si Hesus sa Bukid ng mga Olibo*. ");
INSERT INTO rol_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Aga pa gid nagkadto siya liwat sa templo kag tanan nga mga tawo nagpalapit sa iya. Nagpungkò siya kag gingtudluan sinda. ");
INSERT INTO rol_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Niyan, ang mga eskriba* kag mga Pariseo hay nagdaya ning babayi nga naabutan nga nagapangawatan kag gingpatindog ninda siya sa atubangan ng kadamuan. ");
INSERT INTO rol_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Naghambay sinda kay Hesus, “Maestro, naabot ini nga babayi sa akto nga nagapangawatan. ");
INSERT INTO rol_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Niyan sunò sa Kasuguan ni Moises, dapat buguyon ang tiyad ini nga babayi hasta sa mamatay. Para sa imo, ano ang imo mahahambay?” ");
INSERT INTO rol_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Imaw ini ang inda ginghambay para tistingon si Hesus, agud igwa sinda ning maiakusar kontra sa iya. Pero wayà nagsabat si Hesus, kundì nagdukò siya kag nagsulat sa dutà paagi sa iya tudlò. ");
INSERT INTO rol_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Kay padayon gihapon ang inda kapapangutana sa iya, nagtindog siya kag naghambay sa inda, “O sige, kung sin-o sa indo ang wayà ning salà, imaw ang una nga magbugoy ning bato sa iya.” ");
INSERT INTO rol_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Pagkatapos, nagdukò siya kag nagsulat liwat sa dutà. ");
INSERT INTO rol_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Nang mabatian ninda adto, isa-isa sinda nga naghalin, magtunà sa pinakamaguyang hasta nga si Hesus na lang ang nabilin kag ang babayi nga nagatindog sa iya atubangan. ");
INSERT INTO rol_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Pagkatapos, nagtindog si Hesus kag naghambay sa babayi, “Babayi, diin na sinda? Wayà ba ning may nagparusa sa imo?” ");
INSERT INTO rol_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Nagsabat siya, “Wayà, Nong.” Naghambay si Hesus, “Indì ko da ikaw parusahan. Umulì ka na kag tunà niyan ayaw na magpakasalà liwat.” ");
INSERT INTO rol_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Pagkatapos naghambay liwat si Hesus sa mga Pariseo, “Ako ang iwag nga nagahayag sa mga tawo sa kalibutan. Ang aber sin-o nga nagasunod sa akon agud maging disipulo ko hay igwa ning iwag nga nagatuytoy sa iya kabuhì kag indì na magkabuhì sa kaduyom.” ");
INSERT INTO rol_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Tapos naghambay sinda, “Ikaw lang da ang nagapamatuod parti sa imo kaugalingon. Nganì indì mapatihan ang imo pamatuod.” ");
INSERT INTO rol_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Nagsabat si Hesus, “Aber nagapamatuod ako parti sa akon kaugalingon, matuod gid ang ginahambay ko, kay sayod ko kung diin ako naghalin kag kung diin ako pakadto. Pero kamo wayà makakasayod kung diin ako naghalin kag kung diin ako pakadto. ");
INSERT INTO rol_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ang paghusga nindo hay indì masaligan kay sunò ini sa panghunahunà ng tawo, pero ako wayà nagahusga aber kanin-o. ");
INSERT INTO rol_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Bisan maghusga ako, tamà ang paghusga ko, kay bukon lang ako ang magahusga kundì ako kag ang akon Amay nga nagsugò sa akon. ");
INSERT INTO rol_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Dì ba nakasulat sa indo Kasuguan nga masaligan kung pareho ang pamatuod ng duha ka tawo? ");
INSERT INTO rol_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ako ang nagapamatuod sa akon kaugalingon kag ang akon Amay nga nagsugò sa akon, siya da mismo ang nagapamatuod parti sa akon.” ");
INSERT INTO rol_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Nganì nagpangutana sinda, “Diin ang imo Amay?” Nagsabat si Hesus, “Wayà nindo ako makilaya o ang akon Amay. Kung kilaya kuntà nindo ako, nakilaya da nindo ang akon Amay.” ");
INSERT INTO rol_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ining mga ginghambay ni Hesus hay gingtudlò niya didto hampig sa ginabutangan ning ginahalad nga kwarta sa templo. Pero wayà siya gingdakpa kay wayà pa nag-abot ang oras nga ini hay matabò. ");
INSERT INTO rol_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Naghambay si Hesus liwat sa mga miyugdumaya ng Judio, “Indì na ako magdugay, mahalin ako kag pangitaon nindo ako. Pero mamamatay gid kamo nga ang indo mga salà wayà napapatawad. Indì kamo makakadto sa akon kadtuan.” ");
INSERT INTO rol_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Nganì naghambay sinda sa isa kag isa, “Basì naghambay siya, ‘Indì kamo makakadto sa akon kadtuan?’ Mabikti ba arà siya?” ");
INSERT INTO rol_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Naghambay siya, “Kamo hay halin sa kalibutan pero ako hay halin sa langit. Kamo hay taga-diri sa kalibutan, pero ako hay bukon. ");
INSERT INTO rol_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Imaw ini ang rason nganì ginghambay ko sa indo nga mamamatay gid kamo nga ang indo mga salà wayà napapatawad. Sigurado nga matatabò ini sa indo kung kamo indì magtuo nga Ako imaw Ako.” ");
INSERT INTO rol_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Nagpangutana sinda, “Sin-o ka gid nganì?” Nagsabat si Hesus, “Ginghambay ko na sa indo tunà pa nang una kung sin-o ako. ");
INSERT INTO rol_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Madamò pa ako ning maihahambay kag maihuhusga kontra sa indo ginahuman. Pero ang akon lang ginahambay sa mga tawo diri sa kalibutan hay ang akon nabatian sa iya nga nagsugò sa akon. Kag ang iya ginahambay hay matuod.” ");
INSERT INTO rol_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Wayà gid sinda makaintindi nga parti sa iya Amay sa langit ang ginghambay ni Hesus. ");
INSERT INTO rol_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Nganì naghambay si Hesus, “Pag itaas na nindo ang Ungà ng Tawo sa kahoy, masasayuran nindo nga Ako imaw Ako. Wayà ako may ginghuman paagi sa akon kaugalingon nga otoridad, kundì kung ano ang gingtudlò ng akon Amay, imaw lang ang akon ginahambay. ");
INSERT INTO rol_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Kag siya nga nagsugò sa akon hay kaibahan ko, wayà gid niya ako ginabayai kay kung ano ang makapalipay sa iya imaw gid permi ang akon ginahuman.” ");
INSERT INTO rol_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Pagkabatì ng mga tawo sa mga ginghambay ni Hesus, madamò ang nagtuo sa iya. ");
INSERT INTO rol_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Nganì naghambay si Hesus sa mga Judio nga nagatuo sa iya, “Kung padayon nindo nga sundon ang akon ginatudlò, matuod gid kamo nga akon mga disipulo. ");
INSERT INTO rol_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Kag maiintindihan nindo ang kamatuuran kag ang kamatuuran imaw ang makapahilway sa indo.” ");
INSERT INTO rol_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Nagsabat sinda, “Ang kalulo-lulohan namon si Abraham kag wayà gid kami naulipon aber kanin-o. Basì ginghambay mo nga mahilway kami?” ");
INSERT INTO rol_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Nagsabat si Hesus, “Sa matuod lang ginahambay ko sa indo, ang aber sin-o nga nagapadayon sa pagpakasalà hay ulipon ng salà. ");
INSERT INTO rol_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ang ulipon hay bukon permanenti nga miyembro sa panimayay pero ang ungà hay permanenti gid. ");
INSERT INTO rol_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nganì kung pagahilwayon kamo ng Ungà ng Dios, matuod gid nga mahihilway kamo! ");
INSERT INTO rol_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","“Sayod ko nga kamo hay inapo ni Abraham. Ugaling ginatinguhà gid nindo nga ako patyon, kay wayà nindo ginabatuna ang akon ginatudlò. ");
INSERT INTO rol_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ginahambay ko ang mga butang nga akon nakità nang kaibahan ko ang akon Amay. Pero kamo, ginahuman nindo kung ano ang nabatian nindo sa indo tatay.” ");
INSERT INTO rol_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Naghambay ang mga miyugdumaya ng Judio, “Ang amon kalulo-lulohan si Abraham!” Nagsabat si Hesus, “Kung kamo hay inapo ni Abraham, dapat sundon kuntà nindo ang iya maayo nga ihimplo. ");
INSERT INTO rol_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Pero ang indo ginahuman hay ginatinguhà gid nindo ako nga patyon, aber ginahambay ko lang da ang kamatuuran nga akon nabatian sa Dios. Wayà ginghumana ni Abraham ang ginahuman nindo! ");
INSERT INTO rol_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ang indo ginahuman hay pareho da ng ginahuman ng indo tatay.” Nganì nagsabat sinda, “Bukon kami mga ungà sa luwas. Ang Dios lang mismo ang amon Amay.” ");
INSERT INTO rol_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Naghambay si Hesus, “Kung ang Dios ang indo Amay, dapat higugmaon kuntà nindo ako kay naghalin ako sa Dios. Nagkari ako bukon sa akon kaugalingon nga kagustuhan kundì sa iya nga nagsugò sa akon. ");
INSERT INTO rol_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Basì indì nindo maintindihan ang akon ginahambay? Kay indì nindo gusto batunon ang akon mensahe. ");
INSERT INTO rol_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Kamo hay mga ungà ng diyablo! Kag ang gusto nindo humanon hay ang mga hilig ng indo tatay. Miyugpamatay siya tunà pa nang una kag permi siya nagakontra sa kamatuuran, kay wayà ning kamatuuran nga makikità sa iya. Kung nagabinakak siya, sunò ini sa iya kinaugalì kay pusong siya kag tatay ng tanan nga bakakon. ");
INSERT INTO rol_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Pero ako, ang ginahambay ko sa indo hay ang kamatuuran gid kag inà ang rason nga wayà nindo ako ginapatihi. ");
INSERT INTO rol_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Sin-o sa indo ang makakapamatuod nga nakahuman ako salà? Wayà! Kung ginahambay ko ang kamatuuran, basì wayà nindo ako ginapatihi? ");
INSERT INTO rol_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ang mga ungà ng Dios hay nagapamatì sa iya mensahe. Indì kamo gusto magpamatì kay bukon kamo mga ungà ng Dios.” ");
INSERT INTO rol_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Nagsabat ang mga miyugdumaya ng Judio kay Hesus, “Matuod gid ang ginahambay namon nga ikaw hay taga-Samaria kag ginasapian ng demonyo.” ");
INSERT INTO rol_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Nagsabat si Hesus, “Wayà ako ginagamhi ng demonyo kundì ginapadunggan ko ang akon Amay, pero ginapakahuy-an nindo ako. ");
INSERT INTO rol_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Wayà ako nagatinguhà ng pagdayaw para sa akon kaugalingon, pero ang Dios imaw ang nagahandom ng pagdayaw para sa akon kag siya ang magahusga kontra sa indo. ");
INSERT INTO rol_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Sa matuod lang ginahambay ko sa indo, ang aber sin-o nga nagatuman ng akon ginatudlò, hay indì na makaagi ning kamatayon.” ");
INSERT INTO rol_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Naghambay ang mga miyugdumaya ng Judio, “Niyan sigurado gid kami nga ginasapian ka ng demonyo. Kay namatay na si Abraham kag imaw da ang mga propeta, pero ikaw nagahambay, ‘Ang aber sin-o nga nagatuman ng akon ginatudlò, hay indì na makaagi ning kamatayon.’ ");
INSERT INTO rol_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Aba! Sobra ka pa ba sa amon kalulo-lulohan nga si Abraham nga namatay? Namatay da ang mga propeta, kanin-o mo ginapapareho ang imo kaugalingon?” ");
INSERT INTO rol_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Nagsabat si Hesus, “Kung ginahakwat ko ang akon kaugalingon nga bangkò, wayà gid ini puyos. Ang akon Amay imaw ang nagadayaw sa akon. Siya ang ginahambay nindo nga indo Dios. ");
INSERT INTO rol_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Wayà nindo siya nakikilaya, pero ako, kilaya ko gid siya! Kung ginahambay ko nga wayà ko siya nakikilaya, pusong ako pareho nindo. Pero kilaya ko gid siya kag ginatuman ko ang iya ginasugò sa akon. ");
INSERT INTO rol_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Nalipay gid si Abraham nga indo kalulo-lulohan nang nasayuran niya nga makikità niya ang akon pag-abot. Nakità nganì niya ini kag nalipay gid siya.” ");
INSERT INTO rol_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Nganì naghambay ang mga miyugdumaya ng Judio, “Pauno mo mahambay nga nakità mo na si Abraham? Wayà ka pa nganì ning 50 ka años!” ");
INSERT INTO rol_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Nagsabat si Hesus, “Sa matuod lang ginahambay ko sa indo, bago natawo si Abraham, Ako imaw Ako.” ");
INSERT INTO rol_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tungod sa iya ginghambay, nagpuyot sinda ning bato agud buguyon siya, pero nakapanagò siya kag nakaluwas sa templo. ");
INSERT INTO rol_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Mintras nagapanaw si Hesus kag ang iya mga disipulo, nakità ninda ang isa ka tawo nga buta tunà nang ging-ungà. ");
INSERT INTO rol_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Nagpangutana ang mga disipulo sa iya, “Maestro, sin-o ang nakasalà nganì ging-ungà nga buta ini nga tawo, siya o ang iya mga ginikanan?” ");
INSERT INTO rol_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Nagsabat si Hesus, “Bukon tungod sa iya salà o sa salà ng iya mga ginikanan. Natabò ini sa iya agud makità ng mga tawo ang gahom ng Dios paagi sa pag-ayo sa iya. ");
INSERT INTO rol_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Mintras may adlaw pa, kahinangyan nga trabahuon naton ang mga ginapatrabaho sa aton ng Dios nga nagsugò sa akon. Kay kung gab-i na, indì na naton mahuman ang iya ginapahuman. ");
INSERT INTO rol_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Mintras yari pa ako sa kalibutan, ako ang iwag nga nagatao ning kahayag sa mga tawo.” ");
INSERT INTO rol_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Pagkahambay ini ni Hesus, nagpilà siya sa dutà kag ginghuman niya nga lunang ang pilà kag gingpahid niya ini sa mata ng tawo. ");
INSERT INTO rol_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Hambay ni Hesus, “Kadto sa dipusito ng tubì sa Siloam kag manghilam-os ka.” (Ang gusto hambayon ng Siloam, ‘Gingsugò’.) Nganì nagkadto siya kag nagpanghilam-os kag nagbalik siya nga nakakakità na. ");
INSERT INTO rol_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Nagpinangutan-an ang iya mga kalapit kag ang mga nakakità sa iya dati nang nagapinalimos pa siya, “Dì ba imaw ini ang tawo nga nagapungkò kag nagapinalimos dati?” ");
INSERT INTO rol_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Naghambay ang iban, “Siya nganì!” Pero naghambay naman ang iban, “Bukon, kahitsura lang niya.” Nganì nagsabat ang tawo, “Ako gida ang tawo nga indo ginahambay.” ");
INSERT INTO rol_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Nganì nagpangutana sinda sa iya, “Kung imaw, pauno ka nakakità?” ");
INSERT INTO rol_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Nagsabat siya, “Ang tawo nga ang pangayan Hesus hay naghuman ning lunang kag gingpahid sa akon mata kag naghambay sa akon, ‘Kadto sa dipusito ng tubì sa Siloam kag manghilam-os ka.’ Nganì nagkadto ako kag nagpanghilam-os, tapos nakakità na ako.” ");
INSERT INTO rol_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Nagpangutana pa gid sinda, “Diin na ang tawo nga nagpaayo sa imo?” Nagsabat siya, “Ilam kung diin, wayà ako kasayod.” ");
INSERT INTO rol_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Pagkatapos, gingdaya ninda ang tawo nga dati buta sa mga Pariseo. ");
INSERT INTO rol_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Adto hay Adlaw nga Inugpahuway nang ginghuman ni Hesus ang lunang kag ging-ayo niya ang buta. ");
INSERT INTO rol_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Nganì nagpangutana da ang mga Pariseo sa iya kung pauno siya nakakità. Nagsabat siya, “Gingpahiran niya ning lunang ang akon mata, pagkatapos nagpanghilam-os ako kag nakakakità na ako.” ");
INSERT INTO rol_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Naghambay ang iban nga mga Pariseo, “Bukon halin sa Dios adto nga tawo kay wayà siya nagasunod sa kasuguan parti sa Adlaw nga Inugpahuway.” Pero naghambay ang iban, “Pauno makahuman ning mga milagro ang makasasalà?” Kag wayà sinda nagkaisa. ");
INSERT INTO rol_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Nganì, nagpangutana sinda liwat sa tawo nga dati buta, “Ano ang mahahambay mo sa adto nga tawo, kay ginghambay mo nga ging-ayo niya ang imo mata?” Nagsabat ang tawo, “Siya hay propeta.” ");
INSERT INTO rol_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pero wayà nagpati ang mga miyugdumaya ng Judio nga buta siya dati kag niyan hay nakakakità na. Nganì gingpatawag ninda ang iya mga ginikanan. ");
INSERT INTO rol_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Pagkatapos, gingpangutana ninda sinda, “Imaw ba ini ang indo ungà? Matuod gida ba nga ging-ungà siya nga buta? Basì nakakakità na siya niyan?” ");
INSERT INTO rol_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Nagsabat ang iya mga ginikanan, “Huo, ungà namon siya kag matuod gid nga natawo siya nga buta. ");
INSERT INTO rol_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pero wayà na kami makasayod kung pauno siya nakakità niyan kag wayà da kami makasayod kung sin-o ang nagpaayo sa iya mata. Pangutan-a na lang nindo siya kay may edad na da siya, makakasabat na siya para sa iya kaugalingon.” ");
INSERT INTO rol_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Imaw ini ang sabat ng iya mga ginikanan kay nahadlok sinda sa mga miyugdumaya ng Judio. Kay nagkinasugtanan sinda nga ang aber sin-o nga mag-akò nga si Hesus ang Kristo hay indì na kabigon nga miyembro sa sinagoga. ");
INSERT INTO rol_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Nganì ginghambay ng mga ginikanan ng tawo, “May edad na da siya, makakasabat na siya para sa iya kaugalingon.” ");
INSERT INTO rol_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Nganì, gingpatawag ninda liwat ang tawo nga dati buta kag ginghambayan, “Magbalità ka ning matuod kay nagapamatì ang Dios. Sayod namon makasasalà adto nga tawo.” ");
INSERT INTO rol_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nagsabat siya, “Wayà ako makasayod kung siya hay makasasalà o bukon. Isa lang ang sayod ko, buta ako dati, pero niyan nakakakità na.” ");
INSERT INTO rol_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Nagpangutana sinda liwat, “Ano ang ginghuman niya sa imo? Pauno niya ging-ayo ang imo mata?” ");
INSERT INTO rol_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Nagsabat naman siya, “Gingbalità ko na sa indo, pero wayà kamo nagpati. Basì gusto na naman nindo nga mabatian liwat? Gusto da ba nindo nga maging disipulo niya?” ");
INSERT INTO rol_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tungod diri, tudo ang kahangit ng mga pinunò kag gingmulay ninda siya, “Ikaw ang disipulo ng adto nga tawo! Pero kami hay mga disipulo ni Moises. ");
INSERT INTO rol_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Sayod namon nga nagpakig-istorya ang Dios kay Moises nang una, pero adto nga tawo wayà nganì kami makasayod kung diin siya naghalin!” ");
INSERT INTO rol_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Nagsabat ang tawo nga dati buta, “Taya! Imaw nganì inà ang makatitingaya! Ging-ayo ng adto nga tawo ang akon mata, pero wayà kamo makasayod kung diin siya naghalin. ");
INSERT INTO rol_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Sayod naton nga ang Dios wayà nagapamatì sa mga makasasalà, pero nagasabat siya sa aber sin-o nga matutom nga nagahigugmà sa iya kag nagasunod sa iya kabubut-on. ");
INSERT INTO rol_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tunà pa nang gingtuga ang kalibutan, wayà pa gid kita nakabatì nga may tawo nga nakapaayo sa ging-ungà nga buta. ");
INSERT INTO rol_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kung adto nga tawo bukon halin sa Dios, indì siya makakahuman ning tiyad ini.” ");
INSERT INTO rol_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Nagsabat ang mga miyugdumaya ng Judio, “Ikaw hay makasasalà gid tunà nang ging-ungà. Tapos ikaw pa ba ang magtudlò sa amon?” Kag adto nga daan gingpalayas ninda siya paluwas sa sinagoga. ");
INSERT INTO rol_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Nabatian ni Hesus nga inda gingpalayas sa sinagoga ang tawo nga dati buta. Nganì gingpangità niya siya kag ging-istorya, “Ikaw, nagatuo ka ba sa Ungà ng Tawo?” ");
INSERT INTO rol_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Nagsabat ang tawo, “Nong, sin-o siya? Balitai abi ako agud magtuo ako sa iya.” ");
INSERT INTO rol_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Naghambay si Hesus, “Nakità mo na siya kag siya ang nagapakig-istorya sa imo niyan.” ");
INSERT INTO rol_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Naghambay ang tawo, “Ginoo, nagatuo ako sa imo!” Kag nagsamba siya kay Hesus. ");
INSERT INTO rol_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Naghambay naman si Hesus, “Nagkari ako diri sa kalibutan para husgahan ang mga tawo, agud makakità ang mga nakakasayod nga sinda buta sa kamatuuran kag mabuta ang mga nagahunahunà nga sinda hay nakakasayod ng kamatuuran.” ");
INSERT INTO rol_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Niyan, may iban nga mga Pariseo nga malapit hampig kay Hesus kag nakabatì sinda sa iya ginahambay. Naghambay sinda sa iya, “Ano? Gusto mo ba hambayon nga kami da hay mga buta?” ");
INSERT INTO rol_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Nagsabat si Hesus, “Kung mga buta kamo, mapatawad kuntà ang indo kasal-anan. Pero kay ginahambay nindo nga nakakakità kamo, imaw ini ang nagapamatuod nga may mga salà gihapon kamo.” ");
INSERT INTO rol_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Nagtudlò si Hesus paagi sa ini nga parabola*, “Sa matuod lang ginahambay ko sa indo, ang aber sin-o nga nagasuyod sa kulungan* ng karnero nga wayà nagaagi sa pwertahan, kundì nagasakà sa kuray hay miyugpangawat kag tulisan! ");
INSERT INTO rol_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Kay ang matuod nga pastor* ng karnero hay nagasuyod paagi sa pwertahan. ");
INSERT INTO rol_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ginaabrihan ng miyugbantay ang pwertahan para sa pastor kag ang mga karnero nagapamatì sa iya boses. Ginatawag ng pastor ang iya kaugalingon nga mga karnero sa inda mga pangayan kag nagauna siya sa inda paluwas. ");
INSERT INTO rol_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Kung mailuwas na tanan, nagapanaw siya nga nauuna sa inda. Ang mga karnero hay nagasunod sa iya kay kilaya gid ninda ang iya boses. ");
INSERT INTO rol_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pero indì sinda magsunod sa tawo nga bukon ninda kilaya, kundì madyagan sinda palayò sa iya kay wayà ninda nakilaya ang iya boses.” ");
INSERT INTO rol_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Gingtudluan ni Hesus ang mga tawo paagi sa ini nga parabola, pero wayà sinda makaintindi sa mga butang nga iya ginghambay. ");
INSERT INTO rol_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Nganì naghambay siya liwat sa inda, hambay niya, “Sa matuod lang ginahambay ko sa indo, ako hay pareho sa pwertahan para sa mga karnero. ");
INSERT INTO rol_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ang tanan nga nauuna sa akon hay mga miyugpangawat kag tulisan. Pero ang akon mga karnero hay wayà nagpamatì sa inda. ");
INSERT INTO rol_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ako ang pwertahan. Ang aber sin-o nga nagasuyod paagi sa akon hay magkaigwa ning kaluwasan. Bantayan ko gid siya sa iya pagsuyod kag pagluwas, pareho sa karnero nga makakakità ning maayo nga sabsabon. ");
INSERT INTO rol_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ang miyugpangawat hay nagakari agud mangawat, magpatay kag mangsirà. Pero ako hay nagkari agud magkaigwa ang akon mga karnero ning kabuhì nga kaayo-ayo kag wayà kuyang. ");
INSERT INTO rol_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ako ang maayo nga pastor. Ang maayo nga pastor hay isakripisyo niya aber ang iya kabuhì para sa mga karnero. ");
INSERT INTO rol_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ang ginasuhuyan hay madyagan palayò, kung makità niya nga may nagapalapit nga mapintas nga hayop. Ginabayaan lang niya ang mga karnero kay bukon ini iya kag bukon siya ang inda pastor. Nganì ang mapintas nga hayop hay ginapanglahay ang mga karnero kag nagakabuyag-buyag sinda. ");
INSERT INTO rol_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ang ginasuhuyan hay madyagan palayò kay suhuyan lang siya, nganì wayà ning kabayaka sa mga karnero. ");
INSERT INTO rol_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Ako ang maayo nga pastor. Kung pauno ang pagkakilaya ng Amay sa akon kag ang akon pagkakilaya sa iya, pareho da ini ng akon pagkakilaya sa akon mga karnero kag ng inda pagkakilaya sa akon. Kag isakripisyo ko aber ang akon kabuhì para sa mga karnero. ");
INSERT INTO rol_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Igwa da ako ning iban nga mga karnero nga wayà sa ini nga kulungan. Kahinangyan day-on ko da sinda pasuyod. Pamatian da ninda ang akon boses kag magiging isa sinda ka punà kag mababantayan sinda ng isa ka pastor. ");
INSERT INTO rol_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Ang rason nga ginahigugmà ako ng akon Amay, hay tungod isakripisyo ko ang akon kabuhì para pagkatapos banhawon ko ini. ");
INSERT INTO rol_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Wayà gid ning tawo nga makapatay sa akon kung indì ko gusto isakripisyo ang akon kabuhì. Pero kabubut-on ko nga ginatao ang akon kabuhì. Igwa ako ning otoridad nga isakripisyo ang akon kaugalingon nga kabuhì kag igwa da ako ning otoridad nga banhawon ko ini kay imaw ini ang gingsugò ng Amay sa akon.” ");
INSERT INTO rol_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Tungod sa mga ginghambay ni Hesus wayà nagkaisa ang mga Judio. ");
INSERT INTO rol_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Madamò sa inda ang naghambay, “Siya hay ginasapian ng demonyo kag buang, basì kamo mamatì sa iya?” ");
INSERT INTO rol_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ang iban nagahambay, “Ini nga mga hambay niya hay bukon halin sa ginasapian ng demonyo. Makakapaayo ba ang demonyo ng mata nga buta?” ");
INSERT INTO rol_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Pagkatapos adto, nag-abot ang Pyesta ng Pagdumdom sa Pagbendisyon ng Templo sa Jerusalem. Adto hay tiglalamig. ");
INSERT INTO rol_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Mintras nagapanaw si Hesus sa templo sa may lugar nga ginatawag, Balkon ni Solomon, ");
INSERT INTO rol_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","may pila nga mga Judio ang nagatipon palibot sa iya kag naghambay, “Hasta san-o mo kami pahunahunaon kung sin-o ka gid? Kung ikaw ang Kristo, balitai na kami ning deritso!” ");
INSERT INTO rol_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Nagsabat si Hesus, “Gingbalitaan ko na kamo, pero wayà kamo nagapati. Ang mga makatitingaya nga ginahuman ko paagi sa otoridad ng akon Amay hay nagapamatuod kung sin-o ako. ");
INSERT INTO rol_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pero wayà kamo nagapati kay bukon kamo akon mga karnero. ");
INSERT INTO rol_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ang akon mga karnero hay nagapamatì sa akon boses. Kilaya ko sinda kag ginasunod ninda ako. ");
INSERT INTO rol_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Taw-an ko sinda ning kabuhì nga wayà katapusan kag indì sinda mamatay. Kag wayà gid ning aber sin-o nga makaagaw sa inda sa akon kamot. ");
INSERT INTO rol_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ang mga karnero nga gingtao sa akon ng akon Amay ang pinakaimportante kaysa sa tanan, nganì indì gid sinda maagaw sa mga kamot ng akon Amay. ");
INSERT INTO rol_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ako kag ang akon Amay hay isa lang.” ");
INSERT INTO rol_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Pagkabatì adto ng mga Judio, nagpuyot liwat sinda ning mga bato agud buguyon siya. ");
INSERT INTO rol_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Pero naghambay si Hesus sa inda, “Gingpakità ko sa indo ang madamò nga maayo nga ginghuman ko nga gingsugò ng akon Amay. Diin sa mga ini ang kabangdanan nga gusto nindo ako buguyon?” ");
INSERT INTO rol_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Nagsabat ang mga Judio, “Bukon sa maayo nga hinimuan mo buguyon ka namon, kundì sa ginahambay mo nga malain kontra sa Dios, kay ikaw bilang tawo, ginahuman mo ang imo kaugalingon nga Dios!” ");
INSERT INTO rol_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Nagsabat naman si Hesus, “Dì ba gingsulat sa indo Kasulatan nga ginghambay ng Dios, ‘Ginahambay ko, kamo hay mga dios’? ");
INSERT INTO rol_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Sayod nindo nga matuod ang Kasulatan kag indì puydi baliwayaon. Nganì kung gingtawag ng Dios ang mga tawo nga nagbaton sa iya mensahe, ‘mga dios’, ");
INSERT INTO rol_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","basì ako nga gingpilì kag gingsugò ng Dios diri sa kalibutan, hay indo ginaakusar nga nagahambay malain kontra sa Dios, kay ginghambay ko nga ako Ungà ng Dios? ");
INSERT INTO rol_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kung wayà ko ginahumana ang mga ginasugò sa akon ng Amay, ayaw kamo magtuo sa akon. ");
INSERT INTO rol_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pero kung ginatuman ko ini, aber indì kamo magtuo sa akon, dapat magpati na lang kamo sa mga makatitingaya nga ginghuman ko. Paagi diri masasayuran kag maiintindihan gid nindo nga ang Amay yari sa akon kag ako yarà sa iya.” ");
INSERT INTO rol_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Nang inda ini mabatian, gingtinguhà liwat ninda nga dakpon si Hesus pero nakalikaw siya. ");
INSERT INTO rol_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Pagkatapos adto, nagkadto liwat si Hesus sa kabuak ng subà ng Jordan kung diin una nga nagpangbawtismo si Juan. Kag didto siya nagtinir. ");
INSERT INTO rol_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Madamò nga tawo ang nagakinadto sa iya kag nagahinambay sa isa kag isa, “Aber si Juan wayà gid may nahuman nga milagro, matuod gid ang tanan niya nga ginghambay parti sa ini nga tawo.” ");
INSERT INTO rol_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Kag madamò ang nagtuo kay Hesus didto. ");
INSERT INTO rol_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Igwa ning magmanghod nga taga-Betania, sina Marta, Maria kag Lazaro. Si Maria imaw ang magabubò ning pahumot sa siki ng Ginoo kag magapahid ng iya buhok. Niyan nagkasakit si Lazaro, ");
INSERT INTO rol_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","nganì nagsugò sina Maria kag Marta ng tawo kay Hesus kag gingpahambay, “Ginoo, ang imo palanggà nga amigo hay grabi ang sakit.” ");
INSERT INTO rol_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Pagkabatì ni Hesus sa pasayod, hambay niya, “Indì siya mamatay sa inà nga sakit, kundì natabò ini agud madayaw ang Dios kag paagi diri madayaw da ako nga Ungà ng Dios.” ");
INSERT INTO rol_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Palanggà gid ni Hesus ang tuyo nga magmanghod nga sina Marta, Maria kag Lazaro. ");
INSERT INTO rol_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Pero aber nabatian niya nga grabi si Lazaro, nagtinir siya ning duha pa ka adlaw sa lugar kung sa diin siya. ");
INSERT INTO rol_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Pagkatapos naghambay siya sa iya mga disipulo, “Kari na, makadto kita liwat sa probinsya ng Judea.” ");
INSERT INTO rol_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Pero naghambay ang iya mga disipulo, “Maestro, dì ba mga pila pa lang ka adlaw ang nagligad gingtinguhà ka nga buguyon ng mga Judio didto? Tapos gusto mo naman nga magkadto liwat!” ");
INSERT INTO rol_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Nagsabat si Hesus paagi sa parabola, “Dì ba, igwa ning dose ka oras ang isa ka adlaw? Ang aber sin-o nga nagapanaw kung adlaw, indì mapasuyaod kay nakikità niya ang kahayag sa kalibutan. ");
INSERT INTO rol_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pero ang aber sin-o nga nagapanaw kung gab-i, mapapasuyaod kay kaduyom.” ");
INSERT INTO rol_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Pagkatapos naghambay pa gid si Hesus, “Ang aton amigo nga si Lazaro hay nagakatuyog lang, nganì makadto ako agud pukawon siya.” ");
INSERT INTO rol_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Nagsabat ang iya mga disipulo, “Ginoo, kung nagakatuyog siya, maayo nganì adto agud magaayo gid siya.” ");
INSERT INTO rol_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ang kalaom ng mga disipulo sa ginghambay ni Hesus hay nagakatuyog lang matuod si Lazaro, pero ang gusto hambayon niya, patay na siya. ");
INSERT INTO rol_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Nganì gingklaro gid ni Hesus sa inda, “Patay na gida si Lazaro. ");
INSERT INTO rol_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Pero nalilipay ako para sa indo nga wayà ako didto nang namatay siya, agud magtuo kamo sa akon. Kari na, makadto na kita sa iya.” ");
INSERT INTO rol_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Si Tomas nga may hayò nga ‘Kapid’ naghambay sa iban nga mga disipulo, “Manunot kita agud mamatay kaibahan niya!” ");
INSERT INTO rol_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Niyan pag-abot nina Hesus, gingpasayod sa iya nga upat na ka adlaw nga nakalubong sa lubungan ang lawas ni Lazaro. ");
INSERT INTO rol_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ang Betania hay mga tuyo lang ka kilometro halin sa Jerusalem, ");
INSERT INTO rol_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","kag madamò nga Judio ang nagkadto kana Marta kag Maria, agud maglamay sa pagkamatay ng inda manghod. ");
INSERT INTO rol_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Pagkabatì ni Marta nga paabuton si Hesus, nagpanaw siya agud sugaton siya, pero nagpabilin si Maria sa suyod ng bayay nga nagapungkò. ");
INSERT INTO rol_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Pagkakità ni Marta kay Hesus, naghambay siya, “Ginoo, kung yari ka lang, wayà kuntà namatay ang manghod ko! ");
INSERT INTO rol_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pero sayod ko nga bisan arinyan, itatao sa imo ng Dios ang aber ano nga pangayuon mo sa iya.” ");
INSERT INTO rol_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Naghambay si Hesus, “Mababanhaw ang imo manghod.” ");
INSERT INTO rol_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Naghambay naman si Marta, “Sayod ko nga mabanhaw siya sa ulihi nga adlaw kung pagabanhawon ang tanan nga mga patay.” ");
INSERT INTO rol_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Tapos naghambay si Hesus, “Ako ang nagabanhaw sa mga patay kag nagatao ning kabuhì. Ang nagatuo sa akon aber siya mamatay, mababanhaw. ");
INSERT INTO rol_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ang bisan sin-o nga nagakabuhì kag nagatuo sa akon hay indì gid makabaton ning parusa nga wayà katapusan. Nagapati ka ba diri?” ");
INSERT INTO rol_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Nagsabat si Marta, “Huo, Ginoo. Nagapati gid ako nga ikaw ang Kristo, ang Ungà ng Dios nga nagkari diri sa kalibutan.” ");
INSERT INTO rol_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Pagkahambay adto ni Marta, nagbalik siya sa inda bayay agud tawagon si Maria. Ginghutikan niya, “Yari ang Maestro kag ginapatawag ka.” ");
INSERT INTO rol_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Nang mabatian niya ini, nagtindog siya nga daan kag nagkadto kay Hesus. ");
INSERT INTO rol_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Wayà pa makasuyod si Hesus sa baryo ng Betania, yadto pa siya sa lugar nga gingsumpungan ninda ni Marta. ");
INSERT INTO rol_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Pagkakità ng mga Judio nga yadto sa suyod ng bayay nga nagalipay kay Maria nga siya nagtindog kag dalì-dalì nga nagluwas, nagsunod sinda sa iya. Ang kalaom ninda makadto siya sa lubungan agud didto magtangis. ");
INSERT INTO rol_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Niyan pag-abot ni Maria sa lugar kung diin si Hesus, naghapà siya sa atubangan niya kag naghambay, “Ginoo, kung yari ka lang, wayà kuntà namatay ang akon manghod!” ");
INSERT INTO rol_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Nang makità ni Hesus nga nagatangis siya kag imaw da ang mga kaibahan niya, naglain gid ang iya pamatyag kag nalisod gid siya. ");
INSERT INTO rol_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Nganì nagpangutana si Hesus, “Sa diin nindo ginglubong si Lazaro?” Nagsabat sinda, “Ginoo, kari agud makità mo.” ");
INSERT INTO rol_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Nagtangis si Hesus. ");
INSERT INTO rol_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Nganì naghambay ang mga Judio sa isa kag isa, “Tan-awa, sobra gid ang iya pagpalanggà kay Lazaro!” ");
INSERT INTO rol_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Pero ang iban naghambay, “Dì ba napaayo niya ang mata ng buta? Basì wayà niya napigahi ang pagkamatay ni Lazaro?” ");
INSERT INTO rol_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Mintras nagapalapit si Hesus sa lubungan, naglain gid liwat ang iya pamatyag. Ini hay kuyba kag nasarhan ning kabahoy nga bato. ");
INSERT INTO rol_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Nganì gingsugò ni Hesus ang mga tawo didto, “Paligira nindo ang sara.” Hambay ni Marta nga maguyáng ng namatay, “Ginoo, mabahò na inà kay upat na ka adlaw nga nalubong.” ");
INSERT INTO rol_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Nagsabat si Hesus, “Dì ba ginghambay ko sa imo nga kung magpati ka, makikità mo ang gahom ng Dios?” ");
INSERT INTO rol_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Nganì gingpaligid ninda ang bato. Naghangad si Hesus sa langit kag nagpangamuyò, “Amay ko sa langit, nagapasalamat ako kay ginapamatian mo ako. ");
INSERT INTO rol_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Kag sayod ko nga permi ka nagapamatì sa akon. Pero ginahambay ko ini para sa mga tawo nga nagatindog diri agud magpati sinda nga ikaw ang nagsugò sa akon.” ");
INSERT INTO rol_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Pagkahambay niya ini, nagsinggit siya, “Lazaro, luwas dirà!” ");
INSERT INTO rol_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Kag nagluwas ang namatay! Nakaputos pa ng mahabà nga tela ang iya mga kamot kag siki. Kag ang iya uyo hay napuputos pa ng tela. Hambay ni Hesus sa inda, “Hubari nindo siya agud makapanaw.” ");
INSERT INTO rol_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Madamò ang mga Judio nga nagbisita kay Maria kag nakakità ng ginghuman ni Hesus, nganì nagtuo sinda sa iya. ");
INSERT INTO rol_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pero ang iban sa inda hay nagkadto sa mga Pariseo* kag gingbalità sa inda ang ginghuman ni Hesus kay Lazaro. ");
INSERT INTO rol_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Nganì nagtipon-tipon ang mga pinunò nga parì kag ang mga Pariseo sa Korte ng mga Judio* kag naghambay sinda, “Ano ang dapat naton nga humanon? Kay naghuman ning madamò nga milagro ini nga tawo! ");
INSERT INTO rol_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Kung pabay-an lang naton siya, magapati ang tanan sa iya. Kung tiyad ini, isipon ng gobyerno ng Roma nga nagarebelde kita kontra sa inda. Tapos, girahon kita diri kag gubaon ang aton nasyon kag ang aton balaan nga lugar.” ");
INSERT INTO rol_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Pero isa sa inda nga ang pangayan hay Caifas nga Pinakamataas nga Parì adto nga tuig, naghambay, “Ay, kamo! Wayà gid kamo kasayod kung ano ang indo ginapanghahambay! ");
INSERT INTO rol_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Wayà ba nindo naiisip nga mas maayo sa aton nga isa lang ang mamatay para sa mga tawo, kaysa sa masirà ang bilog nga nasyon?” ");
INSERT INTO rol_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ginghambay niya ini bukon halin sa iya kaugalingon nga hunahunà, kundì bilang Pinakamataas nga Parì adto nga tuig, gingpasayod ng Dios paagi sa iya nga kahinangyan mamatay si Hesus para sa nasyon ng Judio ");
INSERT INTO rol_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","kag bukon lang para sa inda nasyon kundì para sa tanan nga magiging ungà ng Dios nga nagaistar sa iba-iba nga mga nasyon, agud magiging isa sinda tanan. ");
INSERT INTO rol_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Magtunà adto, nagaplano ang mga miyugdumaya ng Judio kung pauno patyon si Hesus. ");
INSERT INTO rol_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Nganì wayà na si Hesus nagapanaw ning lantaran sa Judea, kundì naghalin siya didto kag nagkadto sa baryo malapit sa tiway nga lugar, nga sakop ng syudad nga ginatawag, Efraim. Kag didto siya nagtinir kaibahan ang iya mga disipulo. ");
INSERT INTO rol_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Niyan malapit na adto ang Pyesta ng Pagligad ng Anghel*. Nganì madamò nga Judio halin sa iba-iba nga mga probinsya ang nagkadto sa Jerusalem, agud bago mag-abot ang Pyesta, malimpyo na ninda ang inda kaugalingon sa templo sunò sa layi ng inda relihiyon. ");
INSERT INTO rol_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ginapinangità ng mga tawo si Hesus mintras nagatindog sinda sa templo kag nagpinangutan-an sinda, “Ano sa imo? Makari ba arà siya ini nga Pyesta?” ");
INSERT INTO rol_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ginahambay ninda ini kay nagsugò ang mga pinunò nga parì kag ang mga Pariseo nga kung aber sin-o ang makasayod kung diin si Hesus, dapat ipasayod sa inda agud maaristo na ninda siya. ");
INSERT INTO rol_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Niyan unom na lang ka adlaw kag Pyesta na ng Pagligad ng Anghel. Nagkadto sina Hesus sa Betania, kung sa diin nagaistar si Lazaro nga iya gingbanhaw. ");
INSERT INTO rol_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Didto nagpreparar sina Marta ning dakò nga ihapon para mapadunggan si Hesus. Si Lazaro hay nagakaon kaibahan si Hesus kag si Marta ang nagatahaw. ");
INSERT INTO rol_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mintras nagakaon sinda, si Maria hay nagbuoy naman ning bali tungà sa litro nga kamahay gid kag maayo nga klasi nga pahumot. Ini hay halin sa mahumot nga tanom nga ginatawag, Nardo. Gingbubuan niya ning pahumot ang siki ni Hesus kag gingpunasan niya ini ng iya buhok. Kag napunò ning kahumot ang suyod ng bayay. ");
INSERT INTO rol_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Pero si Judas Iscariote, isa sa mga disipulo ni Hesus, (nga imaw ang magatraidor sa iya) hay naghambay, ");
INSERT INTO rol_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Basì wayà pagbaligyaan ang pahumot kag itao ang kwarta sa mga pobre? Ang kantidad inà hay tuyo ka gatos nga denarius*!” ");
INSERT INTO rol_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ginghambay niya ini, bukon kay nagakabayaka siya sa inda, kundì siya hay miyugpangawat kay siya ang nagahawid ng inda kwarta kag permi siya diri nagakupit. ");
INSERT INTO rol_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Niyan naghambay si Hesus, “Pabay-i lang siya, gingtagana niya inà para ipreparar ang akon lawas sa adlaw ng akon paglubong. ");
INSERT INTO rol_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ang mga pobre hay permi nindo kaibahan, pero ako hay indì nindo permi makaibahan.” ");
INSERT INTO rol_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Pagkasayod ng madamò nga Judio nga yadto si Hesus sa Betania, nagkadto sinda bukon lang para makità si Hesus, kundì gusto da ninda makità si Lazaro nga iya gingbanhaw. ");
INSERT INTO rol_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Nganì ang mga pinunò nga parì hay nagplano nga patì si Lazaro hay patyon da, ");
INSERT INTO rol_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","kay siya ang naging kabangdanan kung basì ang madamò nga Judio hay nagabuyag sa inda grupo kag nagatuo kay Hesus. ");
INSERT INTO rol_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Nang masunod nga adlaw, kadamò-damò nga tawo nga nagapamista ang nakabatì nga si Hesus paabuton sa Jerusalem. ");
INSERT INTO rol_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Nganì nagbuoy sinda ning mga dahon ng palmera agud sugaton siya, nga nagasinggit, “Hosana! Ginapakamaayo ng Ginoo ang iya gingsugò nga magaharì sa Israel!” ");
INSERT INTO rol_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","May nakità si Hesus nga batà pa nga asno kag iya ini gingsakyan. Sa iya ginghuman, natabò ang ginahambay ng Kasulatan, ");
INSERT INTO rol_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ayaw kamo mahadlok mga taga-Zion, sirua ang indo Harì, nagaabot nga nagasakay sa batà pa nga asno!” ");
INSERT INTO rol_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Adto nga oras, wayà pa maintindihi ng mga disipulo ni Hesus kung ano ini ang gusto hambayon. Pero nang nabanhaw siya, imaw pa lang adto ang pagkadumdom ninda nga ini ang nakasulat parti kay Hesus kag natabò gid ini sa iya. ");
INSERT INTO rol_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Niyan nagapamatuod sa natabò ang madamò nga tawo nga kaibahan ni Hesus nang gingtawag niya si Lazaro sa lubungan kag gingbanhaw. ");
INSERT INTO rol_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Nganì kadamò-damò nga tawo ang nagsugat kay Hesus kay nabalitaan ninda adto nga milagro nga iya ginghuman. ");
INSERT INTO rol_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Nganì naghambay ang mga Pariseo sa isa kag isa, “Tan-awa nindo! Ang tanan nga mga tawo hay nagasunod na gid sa iya. Wayà na gid kita ning aber ano pa nga mahuhuman!” ");
INSERT INTO rol_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Niyan igwa ning pila nga mga Griego nga kaibahan sa mga nagkadto sa Jerusalem agud magsamba sa Dios sa Pyesta. ");
INSERT INTO rol_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Nagpalapit sinda kay Felipe nga taga-Betsaida nga sakop sa probinsya ng Galilea kag naghambay sa iya, “Nong, nagahandom kuntà kami nga mapakigkità kay Hesus.” ");
INSERT INTO rol_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Nagkadto si Felipe kag gingbalità ini kay Andres. Tapos nagkadto sinda nga duha kag ginghambay ini kay Hesus. ");
INSERT INTO rol_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Nagsabat si Hesus, “Nag-abot na ang tamà nga oras nga ako nga Ungà ng Tawo* hay pagadayawon, tungod sa akon pagkamatay. ");
INSERT INTO rol_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Sa matuod lang ginahambay ko sa indo, ang akon kabuhì hay pareho sa binhì ng humay. Kung indì ini ipugas sa dutà, indì ini magtubò; magapabilin ini nga isa lang ka binhì. Pero kung ini nga binhì ipugas, pareho ng ilubong kag mamatay, ini hay magatubò kag magauhay ning madamò. ");
INSERT INTO rol_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ang nagapalabi ng iya kabuhì hay maduduyaan ini; pero ang nagabaliwayà ng iya kabuhì diri sa kalibutan, makakabaton siya kabuhì nga wayà katapusan. ");
INSERT INTO rol_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ang aber sin-o nga nagaserbisyo sa akon hay kahinangyan nga magsunod sa akon kag kung diin ako, yadto da ang akon suluguon. Ang bisan sin-o nga nagaserbisyo sa akon hay padunggan* ng akon Amay.” ");
INSERT INTO rol_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Naghambay pa gid si Hesus, “Tudo gid ang kalisod ng akon tagipusuon! Amay, ano ang akon hambayon? Puydi ba luwason mo ako sa ini nga kahugaan? Pero indì puydi kay imaw ini ang kabangdanan ng akon pagkari, nga magtiis ng mga kahugaan sa ini nga oras.” ");
INSERT INTO rol_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tapos naghambay si Hesus, “Amay ko sa langit, ipakità mo sa mga tawo kung mauno kaayo ang imo kahimayaan*!” Pagkatapos may boses nga naghambay halin sa langit, “Gingpakità ko na ang akon kahimayaan paagi sa imo kag ipakità ko pa gid liwat.” ");
INSERT INTO rol_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nang mabatian ang boses ng madamò nga tawo nga nagatindog didto, ang kalaom ng iban hay dayugdog, pero ang iban naghambay, “May anghel nga naghambay sa iya.” ");
INSERT INTO rol_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Pero nagsabat si Hesus, “Gingpabatì sa indo ng Dios ang boses, bukon para sa akon kundì para sa indo. ");
INSERT INTO rol_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Imaw na ini ang oras nga husgahan ang mga tawo nga wayà relasyon sa akon kag oras na da nga si Satanas, ang nagagahom sa kalibutan hay maperdi. ");
INSERT INTO rol_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Kag kung itaas ako halin sa kalibutan, papalapiton ko ang madamò nga tawo nga magsunod sa akon.” ");
INSERT INTO rol_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Sa iya paghambay adto, gingpasayod niya kung pauno siya mamamatay.) ");
INSERT INTO rol_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nganì nagsabat ang mga tawo, “Sayod namon nga sunò sa Kasuguan, ang Kristo hay magakabuhì ng wayà katapusan. Pauno mo mahambay nga ang Ungà ng Tawo hay kahinangyan mamatay sa kahoy?” Nagpangutana pa gid sinda, “Sin-o gid ba ini nga Ungà ng Tawo?” ");
INSERT INTO rol_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Nganì nagsabat si Hesus liwat, “Madalì na lang maduyà ang iwag nga kaibahan nindo. Nganì magpadayon kamo nga magkabuhì kaibahan ng iwag mintras yari pa, kay basì kung maabutan kamo ning duyom. Kay ang nagapanaw sa maduyom hay wayà makasayod kung diin pakadto. ");
INSERT INTO rol_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Mintras kaibahan nindo ako, nga imaw ang iwag, magpati kamo sa akon agud magkabuhì kamo ning matarong.” Pagkatapos ni Hesus mahambay adto, nagpanaw siya kag nagpanagò sa mga tawo. ");
INSERT INTO rol_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Aber nakità na ninda ang madamò nga milagro nga gingpanghuman ni Hesus, wayà gihapon sinda nagtuo sa iya. ");
INSERT INTO rol_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Natabò ini agud matuman ang gingsulat nang una ni Propeta* Isaias, “Ginoo, wayà ning may nagapati sa amon ginabalità. Indì sinda makaintindi aber gingpakità mo na sa inda ang imo gahom.” ");
INSERT INTO rol_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Indì ninda gusto magpati, nganì indì da sinda makatuo. Imaw pa gid ini ang ginghambay ng Dios paagi kay Isaias: ");
INSERT INTO rol_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Gingbuta ko ang inda mga mata kag gingpatugas ko ang inda uyo. Kay basì kung makakità sinda, makaintindi ang inda mga hunahunà; kag makabalik sa akon para paayuhon ko sinda.” ");
INSERT INTO rol_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ginghambay ini ni Isaias, kay nakità niya ang kahimayaan ni Hesus kag nagsulat siya parti sa iya. ");
INSERT INTO rol_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Bisan tiyad adto ang ginghambay ni Isaias, madamò sa mga miyugdumaya ng Judio ang nagtuo kay Hesus. Pero wayà ninda ini ginaakua sa iban, kay nahadlok sinda sa mga Pariseo, basì kung sinda hay indì na kabigon nga miyembro sa sinagoga. ");
INSERT INTO rol_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Kay mas ginapalabi pa ninda ang pagdayaw ng mga tawo kaysa sa pagdayaw ng Dios. ");
INSERT INTO rol_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Pagkatapos naghambay ning makusog si Hesus sa madamò nga tawo, “Ang bisan sin-o nga nagatuo sa akon, bukon lang ako ang ginatuuhan, kundì patì ang nagsugò sa akon. ");
INSERT INTO rol_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ang aber sin-o nga nakakità sa akon, nakakità da sa nagsugò sa akon. ");
INSERT INTO rol_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nagkari ako bilang iwag sa mga tawo diri sa kalibutan, agud ang aber sin-o nga magtuo sa akon, indì magpadayon sa pagkabuhì sa kaduyom. ");
INSERT INTO rol_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Ang bisan sin-o nga nagapamatì ng akon mga ginahambay pero wayà nagatuman, bukon ako ang magahusga sa iya. Kay wayà ako nagkari sa kalibutan para husgahan ang mga tawo, kundì agud sinda luwason. ");
INSERT INTO rol_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Pero may magahusga sa aber sin-o nga wayà nagabaton sa akon kag wayà nagapati sa akon mga ginahambay. Ang akon mismo ginghambay kag gingtudlò, imaw ang magahusga sa iya sa ulihi nga adlaw! ");
INSERT INTO rol_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Kay ang akon ginatudlò hay bukon halin sa kaugalingon ko nga otoridad, kundì ang Amay ko nga nagpadaya sa akon, imaw ang nagsugò kung ano ang akon dapat ihambay kag itudlò. ");
INSERT INTO rol_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nganì ginahambay ko lang kung ano ang gingsugò ng akon Amay sa akon, kay sayod ko gid nga ang iya ginasugò hay imaw ang ginahalinan ng kabuhì nga wayà katapusan.” ");
INSERT INTO rol_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Niyan bisperas na ng Pyesta ng Pagligad ng Anghel. Sayod ni Hesus nga nag-abot na ang oras ng iya paghalin diri sa kalibutan kag mabalik na siya sa Dios nga iya Amay. Palanggà gid niya ang iya mga disipulo sa kalibutan kag niyan, gusto niya nga ipakità kung mauno kadakò ang iya pagpalanggà sa inda. ");
INSERT INTO rol_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Nang adto nga gab-i, nagaihapon si Hesus kag ang iya mga disipulo. Gingbutang na ng diyablo sa isip ni Judas nga ungà ni Simon Iscariote, nga traiduron niya si Hesus. ");
INSERT INTO rol_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Pero sayod ni Hesus nga gingtao na ng Amay ang tanan nga otoridad sa iya kag sayod da niya nga halin siya sa Dios kag magabalik da siya sa Dios. ");
INSERT INTO rol_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Nganì mintras nagakaon pa sinda, nagtindog si Hesus kag ging-uba niya ang iya pangsuy-ob. Tapos gingbuoy niya ang tualya kag gingbugkos ini sa iya hawak. ");
INSERT INTO rol_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Pagkatapos nagbubò siya ning tubì sa planggana kag gingtunaan niya nga hugasan ang mga siki ng iya mga disipulo kag gingpunasan ng tualya nga nakabugkos sa iya hawak. ");
INSERT INTO rol_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Paglapit niya kay Simon Pedro, naghambay si Pedro, “Ginoo, basì? Bukon dapat ikaw ang maghugas ng akon mga siki!” ");
INSERT INTO rol_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Nagsabat si Hesus, “Ang akon ginahuman niyan hay indì mo pa maintindihan, pero sa ulihi maiintindihan mo da.” ");
INSERT INTO rol_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Naghambay si Pedro, “Ayaw! Indì gid puydi nga ikaw ang maghugas ng akon siki!” Nagsabat si Hesus, “Kung indì ka magpahugas sa akon, wayà ka ning relasyon sa akon.” ");
INSERT INTO rol_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Nagsabat naman si Simon Pedro, “Ginoo, kung tiyad inà, bukon lang ang akon siki ang imo hugasan kundì patì ang akon kamot kag uyo.” ");
INSERT INTO rol_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Pero naghambay si Hesus, “Ang tawo nga nakapaligos hay limpyo na ang iya bilog nga lawas kag indì na kahinangyan nga hugasan pa, puyra lang sa iya siki. Malimpyo na kamo pero bukon tanan sa indo.” ");
INSERT INTO rol_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Kay sayod niya kung sin-o ang magatraidor sa iya, nganì ginghambay niya, “Bukon kamo tanan hay malimpyo.” ");
INSERT INTO rol_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Pagkatapos niya mahugasan ang inda mga siki, gingsuksok niya liwat ang iya pangsuy-ob kag nagbalik para magkaon. Nagpangutana siya, “Naintindihan ba nindo kung basì ginghuman ko ini sa indo? ");
INSERT INTO rol_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ginatawag nindo ako nga Maestro kag Ginoo; kag tamà kamo kay ako gida ang Maestro kag Ginoo. ");
INSERT INTO rol_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Aber nganì ako nga indo Ginoo kag Maestro hay naghugas ng indo mga siki, dapat da nga maghinugasan kamo ng indo mga siki. ");
INSERT INTO rol_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Gingtaw-an ko kamo ning ihimplo agud indo patuyaran ang akon ginghuman sa indo. ");
INSERT INTO rol_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Sa matuod lang ginahambay ko sa indo, wayà ulipon nga mas mataas pa sa iya amo kag wayà gingsugò nga mas importante pa sa nagsugò sa iya. ");
INSERT INTO rol_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Niyan nga naintindihan na nindo ini nga mga butang, bulahan kamo kung humanon nindo ini.” ");
INSERT INTO rol_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Hambay pa ni Hesus, “Ang akon ginahambay hay bukon para sa indo tanan, kay kilaya ko gid ang kada isa sa indo nga akon gingpilì. Pero dapat matabò ang ginahambay ng Kasulatan, ‘Ang tawo nga kaibahan ko nga nagakaon imaw ang magatraidor sa akon.’ ");
INSERT INTO rol_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ginahambay ko ini sa indo niyan bago matabò agud kung matabò na ini, magatuo kamo nga Ako imaw Ako. ");
INSERT INTO rol_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Sa matuod lang ginahambay ko sa indo, ang nagabaton sa aber sin-o nga suguon ko hay nagabaton sa akon; kag ang nagabaton sa akon nagabaton da sa nagsugò sa akon.” ");
INSERT INTO rol_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Pagkahambay ini ni Hesus, tudo gid ang iya kalisod, nganì gingpakità niya ang iya nababatyagan sa inda, “Sa matuod lang ginahambay ko sa indo, isa sa indo ang magatraidor sa akon.” ");
INSERT INTO rol_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ang mga disipulo hay nagsiniruan sa isa kag isa, kay wayà sinda makasayod kung sin-o sa inda ang ginahambay ni Hesus. ");
INSERT INTO rol_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Isa sa mga disipulo nga pinalanggà gid niya ang nagapungkò hampig sa iya alihid. ");
INSERT INTO rol_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Nganì gingsinyasan siya ni Simon Pedro nga pangutan-on si Hesus kung sin-o sa inda ang iya ginahambay. ");
INSERT INTO rol_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Nganì nag-islog pa gid siya kay Hesus, naghilig sa iya dughan kag nagpangutana, “Ginoo, sin-o adto?” ");
INSERT INTO rol_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Nagsabat si Hesus, “Kung sin-o ang taw-an ko ning tinapay nga akon isawsaw, siya ang magatraidor sa akon.” Nganì gingsawsaw niya ang tinapay kag gingtao kay Judas nga ungà ni Simon Iscariote. ");
INSERT INTO rol_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Pagkabaton niya ng tinapay, nagsuyod si Satanas sa iya. Nganì naghambay si Hesus kay Judas, “Himua na nga daan ang imo gusto nga humanon.” ");
INSERT INTO rol_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Didto sa mga nagaihapon, wayà gid ning may nakasayod kung basì ginghambay adto ni Hesus kay Judas. ");
INSERT INTO rol_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ang kalaom ng iban gingsugò lang ni Hesus si Judas para magbakay ng inda mga kahinangyanon sa pyesta, o magtao bulig sa mga pobre kay siya ang nagahawid ng inda kwarta. ");
INSERT INTO rol_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Nganì pagkakaon ni Judas ng tinapay, nagluwas siya nga daan. Adto hay gab-i na. ");
INSERT INTO rol_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Pagkahalin ni Judas, naghambay si Hesus, “Niyan pagadayawon na ako nga Ungà ng Tawo kag pagadayawon da ang Dios paagi sa matatabò sa akon. ");
INSERT INTO rol_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Kung pagadayawon ang Dios paagi sa akon, pagadayawon da niya ako didto sa langit kag ini hay humanon niya nga daan. ");
INSERT INTO rol_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Mga pinalanggà ko, matag-od na lang gid ang oras nga makaibahan nindo ako. Pangitaon nindo ako, pero pareho ng akon ginghambay sa mga Judio kag niyan ginahambay ko da sa indo, ‘Indì kamo makakadto sa akon kadtuan.’ ");
INSERT INTO rol_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nganì ginatao ko sa indo ini nga bag-o nga sugò: maghinigugmaan kamo. Kung pauno ko kamo ginghigugmà, dapat da kamo maghinigugmaan. ");
INSERT INTO rol_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Masasayuran ng tanan nga kamo akon mga disipulo, kung magahinigugmaan kamo.” ");
INSERT INTO rol_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Pagkatapos nagpangutana si Simon Pedro kay Hesus, “Ginoo, sa diin ka ba makadto?” Nagsabat si Hesus, “Indì ka niyan makakadto sa akon kadtuan, pero sa ulihi makakasunod ka da.” ");
INSERT INTO rol_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Nagpangutana liwat si Pedro, “Ginoo, basì indì ako makanunot sa imo niyan? Isakripisyo ko ang akon kabuhì para sa imo, aber mamatay pa ako.” ");
INSERT INTO rol_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Pero nagpangutana si Hesus, “Isakripisyo mo ang imo kabuhì para sa akon, aber mamatay ka pa? Sa matuod lang ginahambay ko sa imo, bago magtuktuyaok ang suyog, indì mo ako pagkilay-on ning tuyo ka beses.” ");
INSERT INTO rol_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Naghambay pa gid si Hesus sa inda, “Ayaw kamo magkabayaka, kundì magsalig kamo sa Dios kag magsalig da kamo sa akon. ");
INSERT INTO rol_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Didto sa langit nga ginaistaran ng akon Amay hay madamò ning istaran. Mauna ako didto agud magpreparar ning istaran para sa indo. Indì ko ini ihambay sa indo kung bukon ini matuod. ");
INSERT INTO rol_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Kag kung naipreparar ko na ang indo istaran, mabalik ako liwat agud day-on kamo para kung diin ako, yadto da kamo. ");
INSERT INTO rol_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Kag niyan sayod na nindo ang dayan pakadto sa lugar nga akon kadtuan.” ");
INSERT INTO rol_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Nagpangutana si Tomas, “Ginoo, wayà namon masayuri kung diin ka pakadto, pauno kami makasayod ng dayan?” ");
INSERT INTO rol_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Nagsabat si Hesus, “Ako ang dayan pakadto sa Dios nga Amay, ako ang ginahalinan ng kamatuuran parti sa iya kag ako ang nagatao ning kabuhì. Wayà gid may makakadto sa akon Amay kung bukon paagi sa pagtuo sa akon. ");
INSERT INTO rol_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kung nakilaya nindo ako, makikilaya da nindo ang akon Amay. Kag tunà nganì niyan, kilaya na gid nindo siya kag indo na da nakità.” ");
INSERT INTO rol_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Nagpangabay si Felipe, “Ginoo, ipakità mo abi sa amon ang imo Amay agud makuntinto na kami.” ");
INSERT INTO rol_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Nagsabat si Hesus, “Felipe, madugay na nindo ako nga kaibahan, wayà pa gid galì ikaw makakilaya sa akon? Ang nakakità sa akon hay nakakità na da sa akon Amay. Basì naghambay ka, ‘Ipakità mo abi sa amon ang imo Amay?’ ");
INSERT INTO rol_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Wayà ka ba nagapati nga ako yarà sa Amay kag ang Amay yari sa akon? Ang mga hambay nga akon ginatudlò sa indo hay bukon halin sa akon kaugalingon nga otoridad; kundì ang akon Amay nga nagaistar sa akon imaw ang nagahuman ng mga butang paagi sa akon. ");
INSERT INTO rol_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Magpati kamo sa akon nga ako yarà sa Amay kag ang Amay yari sa akon. Kung indì kamo magpati sa mga ginahambay ko, dapat aber pauno, magpati kamo sa akon tungod sa mga makatitingaya nga ginghuman ko. ");
INSERT INTO rol_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Sa matuod lang ginahambay ko sa indo, ang tawo nga nagatuo sa akon hay makakahuman da pareho ng mga ginahuman ko kag sobra pa gid, kay mabalik na ako sa akon Amay. ");
INSERT INTO rol_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Humanon ko aber ano ang indo pangayuon sa Dios kay igwa kamo relasyon sa akon, agud madayaw ang Amay paagi sa akon nga iya Ungà. ");
INSERT INTO rol_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kung magpangayò kamo ning aber ano, humanon ko ini kay igwa kamo relasyon sa akon.” ");
INSERT INTO rol_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Kung ginahigugmà nindo ako, kahinangyan tumanon nindo ang akon mga sugò. ");
INSERT INTO rol_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Kag mangamuyò ako sa akon Amay sa langit agud suguon sa indo ang kabaylo ko para magbulig sa indo kag makaibahan nindo sa wayà katapusan. ");
INSERT INTO rol_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Siya ang Espiritu Santo nga magatudlò sa indo ng kamatuuran parti sa Dios. Ang mga tawo nga wayà relasyon sa Dios, indì makabaton sa Espiritu Santo kay wayà ninda siya nakità o nakilaya. Pero kamo, kilaya nindo ang Espiritu Santo kay nagakabuhì siya sa indo kag magapabilin nga nagapakig-isa sa indo. ");
INSERT INTO rol_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Indì ko kamo pagbayaan pareho ng ilo, kay balikan ko gid kamo. ");
INSERT INTO rol_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Matag-od na lang gid nga oras kag indì na ako makità ng mga tawo sa kalibutan. Pero makikità gid ako nindo, kay ako hay mababanhaw. Kay ako hay mababanhaw, kamo da hay mababanhaw. ");
INSERT INTO rol_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Pag-abot nang adto nga adlaw, masasayuran gid nindo nga ako hay nagapakig-isa sa akon Amay kag kamo hay nagapakig-isa sa akon kag ako sa indo. ");
INSERT INTO rol_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Ang aber sin-o nga nagabaton kag nagatuman ng akon mga sugò, imaw ang nagahigugmà sa akon. Ang nagahigugmà sa akon hay pagahigugmaon da ng akon Amay, higugmaon ko da siya kag magapakilaya pa gid ako sa iya.” ");
INSERT INTO rol_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Nagpangutana si Judas (bukon si Judas Iscariote), “Ginoo, basì sa amon ka lang nagapakilaya kung sin-o ka? Basì wayà ka nagapakilaya sa iban nga mga tawo?” ");
INSERT INTO rol_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Nagsabat si Hesus, “Kay ang aber sin-o nga nagahigugmà sa akon, tumanon niya ang akon ginatudlò. Higugmaon siya ng akon Amay kag makadto kami sa iya, agud magatinir kami kaibahan niya. ");
INSERT INTO rol_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Pero ang tawo nga wayà nagahigugmà sa akon hay wayà nagasunod sa akon ginatudlò. Ang ginatudlò ko nga indo nabatian hay bukon halin sa akon kundì halin sa Amay nga nagsugò sa akon. ");
INSERT INTO rol_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Ini nga mga butang hay akon ginahambay sa indo mintras kaibahan pa nindo ako. ");
INSERT INTO rol_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Pero suguon ng akon Amay ang Espiritu Santo bilang kabaylo ko agud magbulig siya sa indo. Siya ang magatudlò kag magapadumdom sa indo ng tanan nga akon ginghambay. ");
INSERT INTO rol_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Ang akon katawhayan* hay ginabilin ko nga regalo sa indo. Ini nga katawhayan nga ginatao ko sa indo hay bukon pareho sa katawhayan nga ginatao ng ini nga kalibutan, nganì ayaw kamo magkabayaka o magkahadlok. ");
INSERT INTO rol_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Nabatian na nindo ang akon ginghambay dati sa indo, ‘Mahalin ako kag balikan ko gid kamo.’ Kung nagahigugmà kamo sa akon, dapat kamo magkalipay kay makadto ako sa Amay nga mas labaw kaysa sa akon. ");
INSERT INTO rol_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Kag niyan ginahambay ko ini sa indo bago matabò agud kung matabò na ini, magatuo kamo sa akon. ");
INSERT INTO rol_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Indì ko na pagpakahabaon ang akon paghambay sa indo kay nagaabot na si Satanas nga nagagahom sa mga tawo nga wayà relasyon sa Dios. Wayà siya gahom sa akon. ");
INSERT INTO rol_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Pero ginatuman ko gid ang ginasugò ng akon Amay agud masayuran ng tanan nga tawo nga ginahigugmà ko gid siya. “Kari na, kay mahalin na kita diri.” ");
INSERT INTO rol_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Nagtudlò si Hesus paagi sa isa ka parabola, “Ako ang matuod nga punò ng ubas* kag ang akon Amay ang miyugdipara sa ubasan. ");
INSERT INTO rol_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ang kada sanga nga wayà nagabunga hay iya ginautod kag ang kada sanga nga nagapamunga hay iya ginapungon, agud mas magabuyaboy pa gid ang bunga. ");
INSERT INTO rol_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kamo hay daw pareho sa mga sanga nga napungon kag nalimpyuhan na paagi sa akon mga hambay nga gingtudlò sa indo. ");
INSERT INTO rol_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Magpabilin kamo sa akon kag ako da sa indo. Ang mga sanga indì makabunga, puyra lang kung magapabilin sa bayagon. Imaw da kamo, indì kamo makabunga puyra lang kung kamo magpabilin sa akon. ");
INSERT INTO rol_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ako ang punò ng ubas, kamo ang mga sanga. Ang aber sin-o nga nagapabilin sa akon kag ako da sa iya, imaw ang magapamunga ning buyaboy. Kay kung buyag kamo sa akon, wayà gid kamo may mahuhuman. ");
INSERT INTO rol_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Kung wayà nagapabilin ang tawo sa akon, ipilak siya pareho sa sanga nga layà, ginatipon kag pagkatapos ginapilak sa kalayo agud masunog. ");
INSERT INTO rol_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Kung nagapabilin kamo sa akon kag ginakabuhì nindo ang akon mga ginatudlò, aber ano ang gusto nindo nga pangayuon, itatao ini. ");
INSERT INTO rol_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Kung magpamunga kamo ning buyaboy, ang akon Amay hay pagadayawon ng mga tawo. Paagi diri masasayuran ninda nga kamo hay akon mga disipulo. ");
INSERT INTO rol_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Kung pauno ang paghigugmà ng akon Amay sa akon, tiyad da inà ang akon paghigugmà sa indo. Magpabilin kamo sa akon agud indo mabatyagan ang akon paghigugmà. ");
INSERT INTO rol_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kung ginatuman nindo ang akon mga sugò, padayon nindo nga mababatyagan ang akon paghigugmà. Pareho ng akon pagtuman sa mga sugò ng akon Amay, padayon ko da nga mababatyagan ang iya paghigugmà. ");
INSERT INTO rol_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Ginahambay ko ini nga mga butang sa indo agud mabatyagan da nindo ang akon kalipay kag makumplito ang indo kalipay. ");
INSERT INTO rol_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Imaw ini ang akon sugò sa indo: maghinigugmaan kamo pareho ng akon paghigugmà sa indo. ");
INSERT INTO rol_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Wayà na ning paghigugmà nga mas sobra pa sa paghigugmà ng isa nga tawo nga nagasakripisyo ng iya kabuhì para sa iya mga amigo. ");
INSERT INTO rol_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Kamo ang akon matuod nga mga amigo kung ginatuman nindo ang akon ginasugò sa indo. ");
INSERT INTO rol_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Indì ko na kamo pagtawagon nga mga ulipon kay ang ulipon hay wayà makasayod kung ano ang ginahuman ng iya amo. Kundì ginatawag ko kamo nga mga amigo kay ang tanan nga nabatian ko sa akon Amay hay gingpasayod ko sa indo. ");
INSERT INTO rol_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Bukon kamo ang nagpilì sa akon kundì ako ang nagpilì sa indo. Gingsugò ko kamo para magpanaw kag magtudlò sa mga tawo, agud makapamunga kamo ning bunga nga nagapadayon. Kung tiyad ini, anuman ang indo pangayuon sa akon Amay sa akon pangayan, itatao gid niya ini sa indo. ");
INSERT INTO rol_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ginahambay ko liwat sa indo, imaw ini ang akon sugò: maghinigugmaan kamo.” ");
INSERT INTO rol_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Naghambay pa gid si Hesus sa iya mga disipulo, “Kung nahahangit sa indo ang mga tawo nga wayà relasyon sa Dios, dapat nindo masayuran nga sa akon anay sinda nahangit bago sa indo. ");
INSERT INTO rol_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kung pareho kuntà kamo ng mga tawo nga wayà relasyon sa Dios, palanggaon gid ninda kamo. Pero bukon na kamo pareho ninda kay gingpilì ko kamo agud ibuyag sa inda, nganì nahahangit sinda sa indo. ");
INSERT INTO rol_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Dumduma nindo ang akon ginghambay sa indo, ‘Wayà ning ulipon nga mas mataas sa iya amo.’ Kung ginghingabot ako ninda, papasakitan da ninda kamo. Kung gingtuman ninda ang akon gingtudlò, tumanon da ninda ang indo itudlò! ");
INSERT INTO rol_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Pero papasakitan ninda kamo kay may relasyon kamo sa akon kag wayà ninda nakikilaya ang nagsugò sa akon. ");
INSERT INTO rol_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kung wayà ako nagkari sa inda para ihambay ang mensahe ng akon Amay, wayà kuntà sinda nagkasalà bisan indì magtuo sa akon. Pero niyan wayà na sinda ning maibalibad sa inda salà. ");
INSERT INTO rol_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ang aber sin-o nga nahahangit sa akon hay nahahangit da sa akon Amay. ");
INSERT INTO rol_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Kung wayà ako naghuman sa inda ng makatitingaya nga butang nga wayà ning aber sin-o nga nakahuman, wayà kuntà sinda salà. Aber nakità na gid ninda ang akon mga ginghuman, nahangit pa gihapon sinda sa akon kag sa akon da Amay. ");
INSERT INTO rol_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Pero natabò ini agud matuman ang ginahambay sa inda Kasulatan, ‘Nahangit gid sinda sa akon aber wayà ning kabangdanan.’ ");
INSERT INTO rol_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Pero suguon ko diri sa indo ang kabaylo ko halin sa akon Amay agud magbulig sa indo. Siya ang Espiritu Santo nga magatudlò ng kamatuuran parti sa Dios. Pag-abot niya, magapamatuod siya parti sa akon. ");
INSERT INTO rol_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Kag kamo hay magapamatuod da parti sa akon kay kaibahan ko kamo tunà nang nagpanudlò ako sa mga tawo ng mga mensahe parti sa Dios.” ");
INSERT INTO rol_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Ginahambay ko ini tanan sa indo agud indì maduyà ang indo pagtuo sa akon. ");
INSERT INTO rol_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Kay palayason kamo ng indo mga kasimanwa sa mga sinagoga. Maabot ang oras nga madamò sa inda ang magapatay sa indo kag magahunahunà pa nga sinda nagaserbisyo sa Dios. ");
INSERT INTO rol_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Humanon ninda ini tanan sa indo kay wayà ninda ako nakikilaya o ang akon Amay. ");
INSERT INTO rol_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ginahambay ko ini agud pag-abot ng oras nga humanon ninda ini tanan sa indo, madudumduman nindo ang akon ginghambay.” “Wayà ko anay kamo gingbalitai ng ini nga mga butang kay kaibahan pa nindo ako. ");
INSERT INTO rol_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Pero niyan mabalik na ako sa nagsugò sa akon. Wayà gid ning aber isa sa indo ang nagpangutana kung sa diin ako makadto. ");
INSERT INTO rol_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Niyan tungod sa mga butang nga akon ginghambay sa indo, napunò gid ning kalisod ang indo tagipusuon. ");
INSERT INTO rol_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pero ginahambay ko sa indo ang matuod, ang akon paghalin hay para sa indo kaayuhan. Kay kung indì ako maghalin, indì mag-abot ang kabaylo ko para magbulig sa indo. Pero kung maghalin ako, susuguon ko siya sa indo. ");
INSERT INTO rol_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Kag kung mag-abot siya, pamatuuran niya sa mga tawo nga wayà relasyon sa Dios nga salà ang inda pang-intindi parti sa kasal-anan, sa akon pagiging matarong kag sa paabuton nga paghusga sa mga tawo. ");
INSERT INTO rol_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Parti sa kasal-anan, pamatuuran niya nga makasasalà sinda kay wayà sinda nagtuo sa akon. ");
INSERT INTO rol_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Parti sa akon pagiging matarong, pamatuuran niya nga matarong ako kay makadto na ako sa akon Amay kag indì na ninda ako makità. ");
INSERT INTO rol_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Kag parti sa paghusga sa mga tawo, pamatuuran niya nga matatabò gid ini kay ginghusgahan na ang Pinunò nga nagagahom sa mga tawo nga wayà relasyon sa Dios. ");
INSERT INTO rol_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Madamò pa kuntà ang akon ihambay sa indo, ugaling indì pa nindo ini maintindihan niyan. ");
INSERT INTO rol_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Pag-abot ng Espiritu Santo, siya ang magatudlò ng kamatuuran parti sa Dios. Kag buligan niya kamo nga maintindihan ang tanan nga kamatuuran. Indì siya magahambay sa iya lang kaugalingon, kundì ang ihahambay niya sa indo hay kung ano lang ang iya mabatian sa akon kag ipasayod da niya kung ano ang matatabò sa paabuton. ");
INSERT INTO rol_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Padunggan niya ako kay ipaintindi niya sa indo ang akon mga gingpanudlò kag gingpanghuman. ");
INSERT INTO rol_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Kay ang tanan nga igwa sa akon Amay hay yari da sa akon. Nganì ginghambay ko nga ipasayod ng Espiritu Santo sa indo ang akon mga gingpanudlò.” ");
INSERT INTO rol_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Matag-od na lang ang oras kag indì na nindo ako makità. Pero sa indì magdugay, makikità nindo ako liwat.” ");
INSERT INTO rol_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Nganì nagpinangutan-an sa isa kag isa ang iban niya nga mga disipulo, “Ano baya ang gusto niya hambayon, ‘Matag-od na lang ang oras kag indì na nindo ako makità. Pero sa indì magdugay, makikità nindo ako liwat kay makadto na ako sa akon Amay’?” ");
INSERT INTO rol_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Hambay pa ninda, “Ano baya ang gusto niya nga hambayon, ‘Matag-od na lang ang oras’? Indì naton ini maintindihan kung ano ang gusto hambayon!” ");
INSERT INTO rol_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Sayod ni Hesus nga gusto kuntà ninda magpangutana, nganì naghambay siya, “Dì ba, ang gusto nindo nga ipangutana hay kung ano ang gusto ko nga hambayon, ‘Matag-od na lang ang oras kag indì na nindo ako makità. Pero sa indì magdugay, makikità nindo ako liwat’? ");
INSERT INTO rol_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Sa matuod lang ginahambay ko sa indo, magauwang kamo pero magakalipay gid ang mga tawo nga wayà relasyon sa Dios. Magatangis kamo sa kalisod, pero ang indo kalisod hay maduduyà kag mababayluhan ning kalipay. ");
INSERT INTO rol_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Pareho ng babayi nga paungaon, nagatiis siya ning kasakit kay nag-abot na ang iya oras. Pero pagkatapos nga matawo ang iya lapsag, indì na niya madumduman ang kasakit. Nalilipay siya kay natawo na ang isa ka lapsag sa kalibutan. ");
INSERT INTO rol_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Pareho da ini sa indo, nalilisod gid kamo niyan pero mapakigkità ako sa indo liwat kag malilipay gid ang indo tagipusuon. Kag wayà gid ning bisan sin-o nga makaagaw sa indo ini nga kalipay. ");
INSERT INTO rol_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Pag-abot nang adto nga adlaw, indì na kahinangyan nga sa akon kamo magpangayò ning aber ano. Sa matuod lang ginahambay ko sa indo, anuman ang indo pangayuon sa akon Amay, itatao gid niya ini sa indo kay may relasyon kamo sa akon. ");
INSERT INTO rol_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hasta niyan wayà pa kamo ning ginapangayò sa Dios nga Amay paagi sa akon pangayan. Pangayò kamo sa iya agud makabaton kamo kag para makumplito ang indo kalipay.” ");
INSERT INTO rol_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ginghambay ko ini sa indo paagi sa mga parabola*. Pero maabot ang oras nga indì na ako maghambay ning parabola* kundì ipasayod ko na sa indo ning klaro ang parti sa akon Amay. ");
INSERT INTO rol_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Adto nga adlaw, kamo na mismo ang mangayò sa iya paagi sa akon pangayan. Indì na kahinangyan nga ako pa ang magpangayò sa akon Amay para sa indo. ");
INSERT INTO rol_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ang akon Amay mismo ang nagahigugmà sa indo kay naghigugmà kamo sa akon kag nagpati nga ako hay naghalin sa Dios. ");
INSERT INTO rol_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Naghalin ako sa akon Amay kag nagkari ako diri sa kalibutan. Niyan mahalin na ako diri sa kalibutan kag mabalik na ako sa akon Amay.” ");
INSERT INTO rol_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Naghambay ang iya mga disipulo, “Niyan klaro na gid ang imo mga ginahambay sa amon kag bukon na paagi sa mga parabola! ");
INSERT INTO rol_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Niyan sayod namon nga nasasayuran mo gid ang tanan nga butang kag aber nganì wayà kami nagapangutana, sayod mo ang amon ginahunahunà. Nganì nagapati kami nga ikaw hay halin sa Dios.” ");
INSERT INTO rol_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Naghambay si Hesus, “Nagatuo na ba kamo niyan? ");
INSERT INTO rol_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Madalì na lang ang oras kag imaw na gid ini, nga kamo hay magkabuyag-buyag kag magbalik sa indo lugar. Aber bayaan nindo ako, may kaibahan gihapon ako kay ibhan ako ng akon Amay. ");
INSERT INTO rol_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ginahambay ko ini sa indo agud magkaigwa kamo ning katawhayan sa pagpakig-isa sa akon. Makakaagi kamo ning mga kahugaan sa kalibutan, pero pakusuga ang indo kaugalingon! Naperdi ko na ang mga paagi ng kalibutan nga kontra sa kabubut-on ng Dios.” ");
INSERT INTO rol_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Pagkahambay adto ni Hesus, naghangad siya kag naghambay, “Amay ko sa langit, nag-abot na ang oras. Padunggi ako nga imo Ungà agud padunggan ko da ikaw. ");
INSERT INTO rol_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kay gingtaw-an mo ako ning otoridad para magdumaya sa tanan nga tawo, agud taw-an ko ning kabuhì nga wayà katapusan ang tanan nga tawo nga gingtao mo sa akon. ");
INSERT INTO rol_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Kag imaw ini ang kabuhì nga wayà katapusan: igwa sinda ning relasyon sa imo nga imaw lang ang matuod nga Dios kag sa akon nga imo gingsugò. ");
INSERT INTO rol_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Gingpadunggan ko ikaw sa mga tawo sa kalibutan paagi sa pagtapos ng gingpahuman mo sa akon. ");
INSERT INTO rol_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Nganì niyan, Amay ko sa langit, kung kaibahan ta na ikaw, taw-an sa akon ang kahimayaan nga igwa ako nang kaibahan ko ikaw bago pa natuga ang kalibutan.” ");
INSERT INTO rol_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Gingpakilaya ko ikaw sa mga tawo nga ginglain mo sa kalibutan kag gingtao mo sa akon. Nang una imo sinda kag gingsalig mo sinda sa akon. Kag gingtuman ninda ang imo gingpanudlò. ");
INSERT INTO rol_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Niyan sayod ninda nga ang tanan nga imo gingsalig sa akon hay halin sa imo. ");
INSERT INTO rol_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Gingtudlò ko sa inda ang ginghambay mo sa akon kag gingbaton ninda ini. Nganì sayod gid ninda nga ako hay naghalin sa imo kag nagpati sinda nga ikaw ang nagsugò sa akon. ");
INSERT INTO rol_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Amay ko, nagapangamuyò ako para sa ini nga mga disipulo ko. Ini nga pangamuyò bukon para sa mga tawo nga wayà relasyon sa akon, kundì para sa mga tawo nga gingsalig mo sa akon kay imo sinda. ");
INSERT INTO rol_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ang tanan nga tawo nga may relasyon sa akon hay imo kag ang tanan nga imo hay akon. Kag ako hay ginapadunggan tungod sa inda. ");
INSERT INTO rol_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Niyan mahalin na ako diri sa kalibutan kag mabalik na ako sa imo, pero mabilin pa sinda sa kalibutan. Amay ko nga Balaan, bantayi sinda paagi sa imo gahom nga gingtao mo sa akon, agud magakaisa sinda pareho naton nga nagakaisa. ");
INSERT INTO rol_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Mintras kaibahan ko sinda, gingbantayan ko gid sinda paagi sa imo gahom nga gingtao mo sa akon. Nganì aber isa sa inda wayà may namatay, puyra lang sa tawo nga ang kadtuan hay sa impyerno, agud matabò ang ginahambay ng Kasulatan. ");
INSERT INTO rol_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Niyan mabalik na ako sa imo. Ini nga mga butang hay akon ginapangamuyò mintras yari pa ako sa kalibutan, agud magkaigwa sinda ning kalipay pareho sa akon kag makumplito ini nga kalipay sa inda. ");
INSERT INTO rol_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ginghambay ko na sa inda ang imo mensahe, nganì nahangit sa inda ang mga tawo nga wayà relasyon sa imo. Kay wayà na sinda nagapasakop sa ini nga kalibutan, pareho ko da nga wayà nagapasakop sa kalibutan. ");
INSERT INTO rol_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Wayà ko ginapangamuyua nga buy-on mo na sinda sa kalibutan, kundì proteksyunan mo sinda kontra kay Satanas. ");
INSERT INTO rol_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Wayà na sinda nagapasakop sa ini nga kalibutan, pareho ko da nga wayà nagapasakop sa kalibutan. ");
INSERT INTO rol_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ilain mo sinda para sa pagserbisyo sa imo paagi sa pagtudlò ng kamatuuran. Ang imo hambay imaw ang kamatuuran. ");
INSERT INTO rol_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Kung pauno gingsugò mo ako diri sa mga tawo sa kalibutan para humanon ang imo kabubut-on, ginasugò ko da sinda sa kalibutan. ");
INSERT INTO rol_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ginalain ko ang akon kaugalingon para sa pagserbisyo sa imo, agud mailain da ninda ang inda kaugalingon paagi sa pagtudlò ng kamatuuran.” ");
INSERT INTO rol_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Bukon lang ang akon mga disipulo ang akon ginapangamuyò, kundì ang tanan da nga magatuo sa akon paagi sa inda pamatuod. ");
INSERT INTO rol_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Amay ko sa langit, ang akon pangamuyò sa imo nga kabay pa sinda tanan hay magakaisa. Kung pauno nga ikaw nagapakig-isa sa akon kag ako sa imo, kabay pa nga magapakig-isa da sinda sa aton, agud magpati ang mga tawo nga wayà nagatuo sa imo nga ikaw ang nagsugò sa akon. ");
INSERT INTO rol_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ginatao ko sa inda ang kahimayaan nga imo gingtao sa akon, agud magkaisa gid sinda pareho naton nga nagakaisa. ");
INSERT INTO rol_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ang gusto hambayon, nagapakig-isa ako sa inda kag ikaw sa akon, agud maging isa gid sinda. Paagi diri masasayuran ng mga tawo nga wayà nagatuo sa imo nga ikaw ang nagsugò sa akon kag ginahigugmà mo ang mga nagatuo sa akon pareho ng paghigugmà mo sa akon. ");
INSERT INTO rol_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Amay ko sa langit, gusto ko gid ini nga mga tawo nga gingtao mo sa akon hay makaibahan ko didto mismo sa langit, agud makità da ninda ang kahimayaan ko. Gingtao mo ini nga kahimayaan sa akon kay gingpalanggà mo ako bago pa natuga ang kalibutan. ");
INSERT INTO rol_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Matarong nga Amay, wayà ka nakilaya ng mga tawo nga wayà nagatuo sa imo. Pero kilaya ko gid ikaw kag sayod ini ng akon mga disipulo nga ikaw ang nagsugò sa akon. ");
INSERT INTO rol_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Gingpakilaya ko ikaw sa inda kag ipakilaya pa gid, para ang imo paghigugmà sa akon hay mabatyagan da ninda kag agud ako hay permi ninda makaibahan.” ");
INSERT INTO rol_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Pagkatapos pangamuyò ni Hesus, nagpanaw siya kaibahan ang iya mga disipulo kag nagtabok sinda sa kabuak ng sapà ng Kidron. Didto sinda nagkadto sa lugar nga may mga tanom nga kahoy nga olibo*. ");
INSERT INTO rol_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Niyan si Judas nga imaw ang magatraidor sa iya hay tundog da adto nga lugar kay permi didto nagatipon si Hesus kag ang iya mga disipulo. ");
INSERT INTO rol_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Nganì nagkadto didto si Judas kaibahan ang madamò nga sundalo kag ang mga gwardya ng templo, nga gingsugò ng mga pinunò nga parì kag mga Pariseo*. Igwa sinda daya nga mga muron, iwagan kag armas. ");
INSERT INTO rol_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Sayod ni Hesus ang tanan nga matatabò sa iya, nganì gingsumpong niya nga daan adto nga mga tawo kag gingpangutana, “Sin-o ang indo ginapangità?” ");
INSERT INTO rol_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Nagsabat sinda, “Si Hesus nga taga-Nazaret.” Nagsabat naman siya, “Ako si Hesus.” Yadto da ang traidor nga si Judas nga nagatindog kaibahan ninda. ");
INSERT INTO rol_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Pagkahambay niya nga, “Ako si Hesus,” napaatras sinda tanan kag nagkatumba sa dutà. ");
INSERT INTO rol_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Nganì gingpangutana sinda liwat ni Hesus, “Sin-o gid ba ang ginapangità nindo?” Nagsabat sinda liwat, “Si Hesus nga taga-Nazaret.” ");
INSERT INTO rol_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Naghambay si Hesus, “Ginghambay ko na nganì sa indo nga ako si Hesus. Niyan kung ako ang indo ginapangità, pabay-i lang nga makahalin ining akon mga kaibahan.” ");
INSERT INTO rol_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Imaw ini ang iya ginghambay agud matuman ang iya ginghambay sa Dios, “Indì ko gid pabay-an ang mga gingtao mo sa akon, para wayà may maduyà aber isa.” ");
INSERT INTO rol_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Niyan, si Simon Pedro hay may daya nga maisot nga sundang. Ginggabot niya ini kag ginglabò ang ulipon ng Pinakamataas nga Parì kag nautod ang iya tuo nga talinga. Ang pangayan ng ulipon hay si Malcus. ");
INSERT INTO rol_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Naghambay si Hesus kay Pedro, “Balikan sa tagob ang imo sundang! Wayà ka ba makasayod nga dapat ko antuson ang kahugaan nga gingtao ng akon Amay sa akon?” ");
INSERT INTO rol_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Pagkatapos, gingdakop kag ginggapos si Hesus ng mga sundalo nga ginapamunuan ng inda kumander, kaibahan ang mga gwardya ng templo nga gingsugò ng mga Judio. ");
INSERT INTO rol_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Gingdaya anay siya kay Anas nga panugangan ni Caifas nga imaw ang Pinakamataas nga Parì adto nga tuig. ");
INSERT INTO rol_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","(Si Caifas imaw ang naglaygay dati sa mga Judio, “Mas maayo nga isa lang ang mamatay para sa mga tawo.”) ");
INSERT INTO rol_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Niyan si Simon Pedro kag ang isa pa nga disipulo hay nagsunod kana Hesus. Ini nga disipulo hay kilaya ng Pinakamataas nga Parì, nganì nakasuyod siya sa dyaag ng iya bayay, kaibahan nina Hesus. ");
INSERT INTO rol_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pero si Pedro hay nabilin nga nagatindog sa luwas ng pwertahan. Nganì nagbalik adtong iya kaibahan nga disipulo kag nagpamuhon sa babayi nga miyugbantay ng pwertahan, tapos gingpasuyod niya si Pedro. ");
INSERT INTO rol_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Gingpangutana ng adtong babayi si Pedro, “Dì ba disipulo ka da ng inà nga tawo?” Nagsabat si Pedro, “Bukon.” ");
INSERT INTO rol_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tiglalamig adto, nganì may gingpabaga nga uling. Nagatindog ang mga ulipon kag ang mga gwardya ng templo palibot para magpainit-init. Si Pedro hay nagpalapit da kaibahan ninda nga nagatindog kag nagapadangga da. ");
INSERT INTO rol_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Niyan gingpangutana si Hesus ng Pinakamataas nga Parì parti sa iya mga disipulo kag sa iya ginatudlò. ");
INSERT INTO rol_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Nagsabat si Hesus, “Permi ako nagahambay sa atubangan ng tanan, kay nagatudlò ako sa sinagoga* kag sa templo kung sa diin nagatipon-tipon da ang tanan nga mga Judio. Kag wayà ako may ginahambay nga pasikreto. ");
INSERT INTO rol_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Basì ginapangutana mo ako? Pangutan-a ang mga nakabatì sa akon kay sayod ninda kung ano ang akon ginghambay.” ");
INSERT INTO rol_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Pagkahambay adto ni Hesus, tinampà siya ng isa sa mga gwardya ng templo nga nagatindog malapit sa iya kag ginghambayan siya, “Basì tiyad ka inà kung magsabat sa Pinakamataas nga Parì?” ");
INSERT INTO rol_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Nagsabat si Hesus, “Kung salà ang akon ginghambay, ihambay mo kung diin didto! Pero kung tamà ang akon ginghambay, basì gingtampà mo ako?” ");
INSERT INTO rol_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Pagkatapos adto, gingpadaya ni Anas si Hesus nga nakagapos pa kay Caifas nga Pinakamataas nga Parì. ");
INSERT INTO rol_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Mintras nagatindog gihapon didto si Simon Pedro kag nagapainit-init, may nagpangutana sa iya, “Dì ba disipulo ka da ng inà nga tawo?” Nagbalibad liwat si Pedro, “Bukon ako adto!” ");
INSERT INTO rol_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Niyan gingpangutana naman si Pedro ng isa sa mga ulipon ng Pinakamataas nga Parì, nga hali ng tawo nga ang talinga ging-utod niya, “Dì ba, ikaw adtong nakità ko nga kaibahan niya didto sa gardin?” ");
INSERT INTO rol_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pero nagbalibad na naman si Pedro, “Bukon!” Kag adto nga daan nagtuktuyaok ang suyog. ");
INSERT INTO rol_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Pagkaimbistigar kay Hesus sa bayay ni Caifas, gingdaya siya ng mga miyugdumaya ng Judio sa palasyo ng gobernador. Adto hay bago magsubat ang adlaw. Wayà sinda magsuyod sa palasyo, kay sunò sa inda mga layi, kung magsuyod sinda sa bayay ng bukon Judio*, indì na sinda pagtugutan nga magkaon ng ihapon nga para sa Pyesta ng Pagligad ng Anghel*. ");
INSERT INTO rol_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Nganì nagluwas si Pilato sa iya palasyo kag iya sinda gingpangutana, “Ano ang akusasyon nindo kontra sa ini nga tawo?” ");
INSERT INTO rol_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Nagsabat sinda, “Kung wayà siya may ginghuman nga malain, wayà namon siya pagday-a diri sa imo.” ");
INSERT INTO rol_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Naghambay si Pilato, “Day-a nindo siya kag husgahan sunò sa indo Kasuguan.” Nagsabat ang mga Judio, “Pero wayà kami otoridad nga magsentensya ning kamatayon aber kanin-o.” ");
INSERT INTO rol_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Natabò ini agud matuman ang ginghambay ni Hesus kung pauno siya mamatay. ");
INSERT INTO rol_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Nganì nang mabatian adto ni Pilato, nagsuyod siya liwat sa palasyo. Gingpatawag niya si Hesus kag gingpangutana, “Ikaw ba ang harì ng mga Judio?” ");
INSERT INTO rol_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Nagsabat si Hesus, “Imo gid ba inà pangutana o may iban nga nagbalità sa imo parti sa akon?” ");
INSERT INTO rol_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Nagsabat si Pilato, “Basì? Ano ba ang kalaom mo sa akon, Judio? Ang imo mga kasimanwa kag ang mga pinunò nga parì ang nagdaya sa imo diri sa akon. Ano ba ang imo nahuman?” ");
INSERT INTO rol_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Nagsabat si Hesus, “Ang akon gingharian hay bukon diri sa kalibutan. Kung diri sa kalibutan ang akon gingharian, nagbatò kuntà ang akon mga tagasunod agud indì ako maitugyan sa mga Judio. Pero ang akon gingharian hay bukon sa ini nga kalibutan.” ");
INSERT INTO rol_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Hambay ni Pilato, “Kung imaw, harì ka galì?” Nagsabat si Hesus, “Ikaw ang naghambay nga harì ako. Imaw ini ang kabangdanan kung basì ako natawo kag nagkari diri sa kalibutan agud magpamatuod parti sa kamatuuran. Ang aber sin-o nga gusto magsunod sa kamatuuran hay nagapamatì sa akon hambay.” ");
INSERT INTO rol_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Naghambay liwat si Pilato, “Ano gid galì ang kamatuuran?” Pagkahambay adto ni Pilato, nagluwas siya liwat kag naghambay sa mga Judio, “Wayà ako may nakità nga salà sa ini nga tawo. ");
INSERT INTO rol_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pero sunò sa indo tradisyon, kahinangyan ko magpaluwas ng isa ka priso sa Pyesta ng Pagligad ng Anghel. Gusto ba nindo nga buhian ko ang Harì ng mga Judio para sa indo?” ");
INSERT INTO rol_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Pero nagsinggit sinda liwat, “Indì! Bukon inà nga tawo! Si Barabas ang gusto namon!” (Si Barabas hay isa ka rebelde.) ");
INSERT INTO rol_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Nganì gingpabuoy ni Pilato si Hesus kag gingpalatigo. ");
INSERT INTO rol_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ginghumanan siya ng mga sundalo ning korona nga tunukon kag gingsuksok ini sa iya uyo. Gingpasuksukan da ninda siya kapa nga maron. ");
INSERT INTO rol_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Nagapinalapit sinda sa iya kag nagahambay, “Mabuhay ang Harì ng mga Judio!” Kag gingtinampà ninda siya. ");
INSERT INTO rol_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Nagluwas liwat si Pilato sa iya palasyo kag naghambay sa mga Judio, “Tan-awa nindo, paluwason ko siya agud masayuran nindo nga wayà ako may makità nga salà sa iya!” ");
INSERT INTO rol_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Gingpadaya sa luwas si Hesus nga nakasuksok ning korona nga tunukon kag kapa nga maron. Hambay ni Pilato, “Sirua nindo ini nga tawo!” ");
INSERT INTO rol_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Pagkakità ng mga pinunò nga parì kag ng mga gwardya sa templo, nagsinggit sinda, “Ilangsang siya sa krus! Ilangsang siya sa krus!” Naghambay si Pilato, “Kamo ang magbuoy sa iya diri kag kamo ang maglangsang sa iya, kay wayà gid ako may makità nga salà sa iya!” ");
INSERT INTO rol_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Nagsabat ang mga Judio, “May Kasuguan kami! Dapat siya mamatay sunò sa amon Kasuguan, kay ginahuman niya ang iya kaugalingon nga Ungà ng Dios!” ");
INSERT INTO rol_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pagkabatì adto ni Pilato, lalò na gid siya nga hinadlukan. ");
INSERT INTO rol_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Nganì gingpadaya niya liwat si Hesus sa suyod ng palasyo kag iya gingpangutana, “Taga-diin ka?” Pero wayà nagsabat si Hesus. ");
INSERT INTO rol_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Nganì naghambay si Pilato, “Basì indì ka magsabat sa akon? Wayà ka ba makasayod nga may otoridad ako nga buhian ka o ipalangsang sa krus?” ");
INSERT INTO rol_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Nagsabat si Hesus, “Wayà ka otoridad nga magsentensya ning kamatayon sa akon kung wayà ka gingtaw-i otoridad ng Dios. Nganì, mas madakò ang kasal-anan ng tawo nga nagtugyan sa akon diri sa imo.” ");
INSERT INTO rol_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pagkabatì adto ni Pilato, lalò pa gid niya nga gingtinguhà nga buhian si Hesus. Pero nagsinggit ang mga Judio sa luwas, “Kung buhian mo inà nga tawo, bukon ka amigo ng Emperador ng Roma! Kay ang aber sin-o nga ginahuman nga harì ang iya kaugalingon hay kaaway ng Emperador.” ");
INSERT INTO rol_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pagkabatì adto ni Pilato, gingpadaya niya si Hesus sa luwas. Tapos nagpungkò si Pilato sa pungkuan ng hukom sa lugar nga ginatawag, Plataporma nga Bato. (Sa Hebreo hay Gabbata.) ");
INSERT INTO rol_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Adto hay adlaw ng pagpreparar para sa Pyesta ng Pagligad ng Anghel* kag ang oras hay mga alas dose na. Naghambay si Pilato sa mga Judio, “Sirua nindo ang indo Harì!” ");
INSERT INTO rol_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pero nagsinggit sinda, “Patya inà! Patya inà! Ilangsang siya sa krus!” Nagpangutana si Pilato, “Gusto ba nindo nga ipalangsang ko sa krus ang indo Harì?” Nagsabat ang mga pinunò nga parì, “Wayà kami iban nga harì kundì ang Emperador!” ");
INSERT INTO rol_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Nganì gingtugyan si Hesus ni Pilato sa iya mga sundalo agud ilangsang sa krus. Pagkatapos adto, gingbuoy ninda si Hesus. ");
INSERT INTO rol_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Pagkatapos gingdaya si Hesus paluwas nga pas-an ang iya krus pakadto sa lugar nga ginatawag, Lugar ng Bungò. (Sa Hebreo hay Golgota.) ");
INSERT INTO rol_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Pag-abot didto, ginglangsang ninda si Hesus sa krus. May duha da ka tawo nga ginglangsang kaibahan niya. Ang isa sa tuo, ang isa sa waya kag si Hesus hay sa inda tungà. ");
INSERT INTO rol_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Nagpahuman si Pilato ng karatula kag gingpabutang sa ibabaw ng krus, nga may nakasulat, Si Hesus nga taga-Nazaret, ang Harì ng mga Judio. ");
INSERT INTO rol_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Nganì nabasa adto ng madamò nga Judio kay malapit sa Jerusalem ang ginglangsangan kay Hesus kag isa pa nakasulat adto sa linggwahe ng Hebreo, Latin kag Griego. ");
INSERT INTO rol_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Pagkabasa adto ng mga pinunò nga parì, nagreklamo sinda kay Pilato nga ang hambay, “Ayaw pagsulata nga ‘Harì ng mga Judio’, kundì ‘Hambay ng ini nga tawo siya ang Harì ng mga Judio.’ ” ");
INSERT INTO rol_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Nagsabat si Pilato, “Ang akon gingpasulat hay nakasulat na.” ");
INSERT INTO rol_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Niyan, bago ginglangsang ng mga sundalo si Hesus, gingbuoy anay ninda ang iya ginasuksok kag gingparte sa upat ka bilog, kada sundalo isa ka parte. Gingbuoy da ninda ang iya barò nga pang-idayom. Isa ini ka bilog nga wayà ning tahì halin sa liab hasta sa tuhod. ");
INSERT INTO rol_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Nganì naghambay sinda sa isa kag isa, “Indì naton ini tungaon, magbunot-bunutan na lang kita kung kay sin-o ini mapakadto.” Natabò ini agud matuman ang ginahambay ng Kasulatan, “Gingparte-parte ninda ang akon mga barò kag gingbunot-bunutan ninda ang akon barò nga pang-idayom.” Imaw nganì adto ang ginghuman ng mga sundalo. ");
INSERT INTO rol_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Nagatindog naman malapit sa krus ni Hesus ang iya nanay, ang manghod nga babayi ng iya nanay, ang asawa ni Clopas nga si Maria kag ang taga-Magdala nga si Maria. ");
INSERT INTO rol_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Nang makità ni Hesus ang iya nanay kag ang iya pinalanggà nga disipulo nga nagatindog didto, naghambay siya sa iya nanay, “Nay, kabiga inà nga disipulo ko nga imo ungà.” ");
INSERT INTO rol_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Naghambay naman siya sa disipulo, “Kabiga siya nga imo nanay.” Tunà adto, gingbaton siya ng disipulo bilang miyembro sa iya pamilya. ");
INSERT INTO rol_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Pagkatapos adto, sayod ni Hesus nga natapos na ang tanan nga gingpahuman ng iya Amay kag agud matuman ang Kasulatan, naghambay siya, “Ginauhaw ako!” ");
INSERT INTO rol_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Igwa didto hambawan nga punò ning maaslom nga ilimnon. Pagkabatì adto ng mga sundalo, nagbuoy sinda espongha kag gingsawsaw ini sa ilimnon kag gingpalapit sa bàbà ni Hesus. ");
INSERT INTO rol_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Pagkasupsop niya ng ilimnon, hambay niya, “Natapos na!” Kag nagdungok siya kag nabugtuan siya ginhawa. ");
INSERT INTO rol_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Adto hay adlaw ng pagpreparar para sa Adlaw nga Inugpahuway* kag indì gusto ng mga miyugdumaya ng Judio nga mabilin didto sa krus ang mga lawas nga ginglangsang. Kay ang masunod hay Adlaw nga Inugpahuway kag importante gid ini nga adlaw para sa mga Judio, kay natamà sa Pyesta ng Pagligad ng Anghel. Nganì gingpangabay ng mga Judio kay Pilato nga ipabalì na lang ang mga batiis ng mga ginglangsang, agud mamatay sinda nga daan kag mabuoy ang inda lawas sa krus. ");
INSERT INTO rol_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Nganì nagkadto ang mga sundalo kag gingpangbalì ang mga batiis ng duha ka tawo nga nakalangsang kaibahan ni Hesus. ");
INSERT INTO rol_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pero pag-abot ninda kay Hesus kag pagkakità nga patay na siya, wayà na ninda pagbalia ang iya mga siki. ");
INSERT INTO rol_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pero gingbunò ng isa nga sundalo si Hesus sa kilid ning bangkaw kag adto nga daan, nag-ilig ang dugò kag tubì. ");
INSERT INTO rol_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ang nakakità mismo sa natabò imaw ang nagpamatuod. Kag masaligan ang iya ginabalità kay sayod niya nga matuod ang iya ginahambay, agud magtuo kamo. ");
INSERT INTO rol_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Natabò ini nga mga butang agud matuman ang ginahambay ng Kasulatan, “Wayà gid bisan isa sa iya mga tuy-an ang mababalì.” ");
INSERT INTO rol_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Kag may ginahambay pa gid sa Kasulatan, “Tan-awon ninda ang tawo nga inda gingbunò.” ");
INSERT INTO rol_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Pagkatapos adto, si Jose nga taga-Arimatea hay nagkadto kay Pilato kag nagpamuhon nga kung puydi buy-on niya ang lawas ni Hesus didto sa krus. (Si Jose hay isa sa mga disipulo ni Hesus pero sikreto lang kay nahadlok siya sa mga miyugdumaya ng Judio.) Tapos gingtugutan siya ni Pilato, nganì gingpatunton niya ang lawas ni Hesus. ");
INSERT INTO rol_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nagnunot da sa iya si Nicodemus. (Siya ang nagkadto anay kay Hesus nang gab-i.) Nagdaya siya ning mga 100 ka litro nga pahumot nga ginghalò nga mira* kag aloe. ");
INSERT INTO rol_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Nganì gingpabuoy ninda ang lawas ni Hesus kag gingpabutangan ning pahumot mintras gingpasamburan ning mahay kag maayo nga klasi nga tela. (Imaw ini ang patakaran ng mga Judio sa paglubong.) ");
INSERT INTO rol_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Didto sa ginglangsangan kay Hesus, igwa malapit nga lugar nga may mga tanom. Igwa didto bag-o nga lubungan nga ginghuman sa alihid ng bakuyod. Ini hay wayà pa nalulubungi. ");
INSERT INTO rol_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Niyan, tungod adto hay adlaw ng pagpreparar ng mga Judio para sa Adlaw nga Inugpahuway kag malapit lang didto ang lubungan, didto na lang ninda ginglubong si Hesus. ");
INSERT INTO rol_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Aga pa gid ng una nga adlaw ng simana, maduyom-duyom pa, nagkadto na si Maria nga taga-Magdala sa ginglubungan kay Hesus. Pag-abot niya didto, nakità niya nga napaligid na ang bato nga nagasara sa pwertahan ng lubungan. ");
INSERT INTO rol_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Nganì nagdyagan siya kag nagkadto kay Simon Pedro kag sa disipulo nga pinalanggà ni Hesus kag nagbalità, “Gingbuoy ninda ang Ginoo sa lubungan kag wayà kami kasayod kung diin ninda siya gingbutang.” ");
INSERT INTO rol_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Nganì nagluwas si Pedro kaibahan adto nga disipulo kag nagkadto sa lubungan. ");
INSERT INTO rol_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Nagdyagan sinda nga duha, pero mas matulin adtong disipulo nga kaibahan ni Pedro, nganì siya ang una nga nakaabot sa lubungan. ");
INSERT INTO rol_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Nagdukò siya kag naglìlì sa suyod. Nakità niya nga yadto nakabutang ang tela nga ginggamit sa paglubong kay Hesus, pero wayà siya magsuyod. ");
INSERT INTO rol_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Malagat-lagat, umabot da si Simon Pedro kag deri-deritso siya nga nagsuyod sa lubungan. Nakità niya nga nakabutang didto ang tela ");
INSERT INTO rol_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","patì ang panyò nga gingputos sa uyo ni Hesus. Bukon ini kaibahan sa maayo nga klasi nga tela, kundì nakabuyag sa alihid kag nakalukot ini ning maayo. ");
INSERT INTO rol_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tapos nagsuyod da ang disipulo nga nauna mag-abot kag sa iya nakità, nagpati siya. ");
INSERT INTO rol_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Pero aber tiyad adto, wayà gihapon ninda naintindihi ang ginahambay ng Kasulatan nga kahinangyan mabanhaw si Hesus.) ");
INSERT INTO rol_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Pagkatapos nag-ulì ang duha nga disipulo sa inda lugar. ");
INSERT INTO rol_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Niyan si Maria nga taga-Magdala hay nagatindog gihapon didto sa luwas ng lubungan nga nagatangis. Mintras nagatangis, nagdukò siya kag naglìlì sa suyod ng lubungan ");
INSERT INTO rol_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","kag nakità niya ang duha nga anghel nga nakabarò ng putì kag nagapungkò sa dati nga gingbutangan ng lawas ni Hesus. Ang isa hay hampig sa uyuhan kag ang isa sa sikwayan. ");
INSERT INTO rol_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Nagpangutana sinda sa iya, “Nang, basì nagatangis ka?” Nagsabat siya, “Kay gingbuoy ninda ang akon Ginoo kag wayà ako kasayod kung diin ninda siya gingbutang.” ");
INSERT INTO rol_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Pagkahambay niya adto, naglingig siya kag nakità niya nga may tawo nga nagatindog, pero wayà niya nakilaya nga si Hesus adto. ");
INSERT INTO rol_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Naghambay si Hesus, “Nang, basì nagatangis ka? Sin-o ang imo ginapangità?” Ang kalaom ni Maria, siya ang miyugbantay ng lugar nga may mga tanom, nganì naghambay siya, “Nong, kung kamo ang nagbuoy sa iya, tudluan abi sa akon kung diin nindo siya gingbutang kay akon buy-on.” ");
INSERT INTO rol_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Gingtawag siya ni Hesus, “Maria.” Nag-atubang si Maria kag naghambay kay Hesus sa Hebreo nga linggwahe, “Rabboni!” (Ang gusto hambayon “Maestro”.) ");
INSERT INTO rol_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Hambay ni Hesus, “Ayaw ako paghawiri kay wayà pa ako makabalik sa akon Amay. Kadto sa akon mga kauturan kag balitai nga mabalik na ako sa akon Amay nga indo da Amay, sa akon Dios nga indo da Dios.” ");
INSERT INTO rol_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Nganì nagkadto si Maria nga taga-Magdala sa mga disipulo kag nagbalità, “Nakità ko ang Ginoo!” Kag ginghambay da niya sa inda ang gingbilin sa iya ni Hesus. ");
INSERT INTO rol_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Pagkagab-i, nang adto da nga adlaw ng Dominggo, nagtipon-tipon ang mga disipulo ni Hesus. Nakatrangka ang pwertahan ng bayay nga inda ginatipunan kay nahadlok sinda sa mga miyugdumaya ng Judio. Gulpi lang nga nag-abot si Hesus kag nagtindog sa tungà ninda. Hambay niya sa inda, “Ang katawhayan yarà sa indo.” ");
INSERT INTO rol_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Pagkahambay niya adto, gingpakità niya ang iya mga kamot kag ang iya kilid sa inda. Nganì nalipay gid ang mga disipulo nang makità ang Ginoo. ");
INSERT INTO rol_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Naghambay liwat si Hesus sa inda, “Ang katawhayan yarà sa indo. Kung pauno nga gingsugò ako ng akon Amay, ginasugò ko da kamo.” ");
INSERT INTO rol_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Pagkahambay niya adto, ginghuyupan niya sinda kag naghambay, “Batuna nindo ang Espiritu Santo, ");
INSERT INTO rol_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ang aber sin-o nga balitaan nindo nga ginapatawad na ang inda mga kasal-anan, gingpatawad na da ng Dios. Pero ang aber sin-o nga hambayan nindo nga wayà sinda ginapatawad sa inda mga kasal-anan, wayà da gingpatawad ng Dios.” ");
INSERT INTO rol_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Pero si Tomas nga may hayò nga ‘Kapid’, isa sa dose nga disipulo hay bukon ninda kaibahan nang magpakità si Hesus. ");
INSERT INTO rol_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Nganì gingbalitaan siya ng iban nga disipulo, “Nakità namon ang Ginoo!” Nagsabat si Tomas, “Indì ako magpati, mintras indì ko mismo makità kag matuslok ng akon tudlò ang ging-agihan ng langsang sa iya mga kamot kag matandog ng akon payad ang iya kilid.” ");
INSERT INTO rol_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Pagkaligad ng wayo ka adlaw, nagtipon-tipon liwat sa suyod ng bayay ang mga disipulo kag kaibahan ninda si Tomas. Aber nakatrangka ang pwertahan, gulpi lang nga nagsuyod si Hesus kag nagtindog sa inda tungà. Hambay niya sa inda, “Ang katawhayan yarà sa indo.” ");
INSERT INTO rol_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Pagkatapos hambay niya kay Tomas, “Sirua ang akon mga kamot kag tuslukan ang imo tudlò sa akon pilas. Kag haphapa ng imo payad ang akon kilid. Ayaw magduha-duha, magtuo ka na.” ");
INSERT INTO rol_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Hambay ni Tomas, “Ikaw ang akon Ginoo kag ang akon Dios!” ");
INSERT INTO rol_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Tapos naghambay si Hesus, “Tomas, nagatuo ka na ba kay nakità mo ako? Bulahan ang mga nagatuo sa akon aber wayà ninda ako makità.” ");
INSERT INTO rol_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Kadamò pa gid ang mga milagro nga ginghuman ni Hesus nga nakità ng iya mga disipulo, nga wayà gingsulatan sa ini nga libro. ");
INSERT INTO rol_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pero gingsulat ko ini nga mga butang agud magtuo kamo nga si Hesus ang Kristo, ang Ungà ng Dios. Kag paagi sa indo pagtuo, makakabaton kamo kabuhì nga wayà katapusan kay kamo hay may relasyon sa iya. ");
INSERT INTO rol_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Pagkatapos adto, nagpakità liwat si Hesus sa mga disipulo didto sa alihid ng Lawà ng Tiberias*. Tiyad ini ang natabò: ");
INSERT INTO rol_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Magkaibahan sina Simon Pedro, si Tomas nga ang hayò hay ‘Kapid’, si Natanael nga taga-Cana nga sakop sa probinsya ng Galilea, ang mga ungà ni Zebedee kag duha pa nga disipulo. ");
INSERT INTO rol_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Naghambay si Simon Pedro sa inda, “Mapalawod ako.” Nagsabat sinda, “Manunot kami.” Nganì nagsakay sinda sa dyapang* kag nagpalawod. Pero wayà gid sinda may nabuoy sa bilog nga gab-i. ");
INSERT INTO rol_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Nang pasubaton na ang adlaw, nagatindog si Hesus sa baybay pero wayà siya makilaya ng mga disipulo. ");
INSERT INTO rol_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Nganì hambay ni Hesus sa inda, “Mga amigo, igwa ba kamo ning buoy?” Nagsabat sinda, “Wayà gid!” ");
INSERT INTO rol_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Hambay niya, “Taktakan nindo ang pukot hampig sa tuo ng dyapang kag makakabuoy kamo.” Nganì gingtaktak ninda ang pukot kag sa kadamò ng tuyoy, hayos indì na ninda ini kaya batakon. ");
INSERT INTO rol_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Nganì hambay ng disipulo nga pinalanggà ni Hesus kay Pedro, “Ang Ginoo adto!” Pagkabatì niya adto, gingsuksok niya ang iya barò kay nakauba siya mintras nagatrabaho kag lumumpat sa tubì kag lumangoy pakadto sa takas. ");
INSERT INTO rol_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ang iban nga disipulo nga yadto sa dyapang hay nagbugsay papiliw kag gingguyod ang pukot nga kadamò tuyoy kay bukon sinda malayò sa baybay, mga 60 lang ka dupa ang kalayò. ");
INSERT INTO rol_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Pag-abot ninda sa takas, nakità ninda nga igwa ning baga nga may isdà nga ginaihaw kag igwa da ning tinapay. ");
INSERT INTO rol_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Hambay ni Hesus sa inda, “Magdaya kamo diri ning pila ka bilog nga isdà nga indo nabuoy.” ");
INSERT INTO rol_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Nganì nagbalik si Simon Pedro sa dyapang kag nagbulig sa pagbira ng pukot pabaybay. Punò gid ang pukot ning kadagkò nga tuyoy, ini hay 153 tanan. Aber tiyad adto kadamò ang isdà, wayà gid nagisì ang pukot. ");
INSERT INTO rol_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Hambay sa inda ni Hesus, “Kari na kamo, mamahaw kita.” Wayà gid may nagpangahas aber isa sa mga disipulo nga magpangutana kung sin-o siya. Kay kilaya ninda nga siya ang Ginoo. ");
INSERT INTO rol_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Nagpalapit si Hesus, gingbuoy niya ang tinapay kag gingtao sa inda, imaw da ang inihaw nga isdà. ");
INSERT INTO rol_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Imaw ini ang pangtuyo ka beses nga nagpakità si Hesus sa mga disipulo pagkatapos siya mabanhaw. ");
INSERT INTO rol_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Mintras nagapamahaw sinda, gingpangutana ni Hesus si Simon Pedro, “Simon, ungà ni Juan, ginahigugmà mo ba ako labaw pa sa paghigugmà sa akon ng imo mga kaibahan?” Nagsabat siya, “Huo, Ginoo, sayod mo nga ginahigugmà ko gid ikaw.” Hambay ni Hesus, “Pakauna ning maayo ang akon mga kordero.” ");
INSERT INTO rol_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Nagpangutana liwat si Hesus, “Simon, ungà ni Juan, ginahigugmà mo ba ako?” Nagsabat siya, “Huo, Ginoo, sayod mo nga ginahigugmà ko gid ikaw.” Hambay ni Hesus, “Diparaha ning maayo ang akon mga karnero.” ");
INSERT INTO rol_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Pangtuyo ka beses nagpangutana si Hesus, “Simon, ungà ni Juan, ginahigugmà mo ba ako?” Nalisod si Pedro kay tuyo na gid ka beses siya gingpangutana ni Hesus, “Ginahigugmà mo ba ako?” Nganì nagsabat siya kay Hesus, “Ginoo, sayod mo ang tanan nga butang. Sayod mo nga ginahigugmà ko gid ikaw.” Hambay ni Hesus, “Pakauna ning maayo ang akon mga karnero. ");
INSERT INTO rol_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Sa matuod lang ginahambay ko sa imo, nang batà ka pa, ikaw ang nagahugot ng imo kaugalingon nga sinturon kag nagapanaw ka kung diin mo gusto. Pero pag guyang mo, pagaunaton mo ang imo mga butkon. Tapos iban ang magapos sa imo kag day-on ka sa lugar nga indì mo gusto kadtuan.” ");
INSERT INTO rol_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Ginghambay ini ni Hesus agud ipasayod kay Pedro kung pauno siya mamatay kag kung pauno niya mapadunggan ang Dios paagi sa iya kamatayon.) Pagkatapos adto, hambay ni Hesus sa iya, “Magsunod ka sa akon.” ");
INSERT INTO rol_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Naglingig si Pedro kag nakità niya nga nagasunod sa inda ang disipulo nga pinalanggà ni Hesus. Siya adto ang nagapungkò hampig sa alihid ni Hesus nang nagaihapon sinda kag nag-islog pa gid siya kay Hesus, naghilig sa iya dughan kag nagpangutana, “Ginoo, sin-o adto ang magatraidor sa imo?” ");
INSERT INTO rol_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Niyan, pagkakità ni Pedro sa iya, nagpangutana siya kay Hesus, “Ginoo, pauno ini nga tawo, ano ang matatabò sa iya?” ");
INSERT INTO rol_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Nagsabat si Hesus, “Kung gusto ko nga mabuhì siya hasta nga magbalik ako diri sa kalibutan, ano adto sa imo? Basta ikaw, magsunod ka sa akon!” ");
INSERT INTO rol_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Nganì nabantog ang balità sa mga kauturan nga ini nga disipulo hay indì mamatay. Pero bukon tiyad adto ang ginghambay ni Hesus parti sa iya, kundì, “Kung gusto ko nga mabuhì siya hasta nga magbalik ako, ano adto sa imo?” ");
INSERT INTO rol_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ako ini nga disipulo ang nagapamatuod kag nagsulat ng ini nga mga butang. Sayod namon nga matuod ang akon ginabalità. ");
INSERT INTO rol_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Kadamò pa gid ang mga gingpanghuman ni Hesus. Kung isulat ini tanan, para sa akon, indì mag-igò ang mga libro nga masusulat aber pa sa bilog nga kalibutan.");
INSERT INTO rol_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Halangdon nga Teofilus: Sa akon una nga libro ging-istorya ko ang parti sa tanan nga ginghuman kag gingtudlò ni Hesus tunà pa sa premiro ");
INSERT INTO rol_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","hasta sa adlaw nga gingdaya siya sa langit. Bago ini natabò, igwa siya gingtugon paagi sa gahom ng Espiritu Santo sa mga apostoles nga iya gingpilì. ");
INSERT INTO rol_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Pagkatapos ng iya pagpakasakit kag pagkamatay sa krus, nagpakità siya sa inda kag nagpamatuod sa madamò nga paagi nga siya hay nabanhaw. Ginghuman niya ini sa suyod ng 40 ka adlaw kag gingtudluan sinda parti sa gingharian ng Dios. ");
INSERT INTO rol_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Isa ka adlaw mintras nagakaon sinda, ginghambayan sinda ni Hesus: “Ayaw anay kamo maghalin sa Jerusalem. Huyata nindo ang gingpromisa ng aton Amay nga ginghambay ko sa indo. ");
INSERT INTO rol_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Nagbawtismo si Juan sa tubì, pero pagkaligad ng pila ka adlaw, pagabawtismuhan kamo sa Espiritu Santo.” ");
INSERT INTO rol_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Isa ka adlaw mintras nagatipon ang mga apostoles kaibahan si Hesus, nagpangutana sinda sa iya, “Ginoo, imaw na ba ini ang tyempo nga ibalik mo liwat ang gingharian ng Israel?” ");
INSERT INTO rol_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Nagsabat siya, “Ang mga tyempo o adlaw hay gingtakdà ng Amay sa iya otoridad kag indì na kahinangyan nga masayuran pa nindo kung san-o ini matatabò. ");
INSERT INTO rol_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pero pag-abot ng Espiritu Santo sa indo, makakabaton kamo ning gahom. Pagkatapos, magapamatuod kamo parti sa akon sa Jerusalem, sa bilog nga Judea kag Samaria hasta sa bilog nga kalibutan.” ");
INSERT INTO rol_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Pagkahambay niya ini, gingdaya siya palangit kag mintras nagatan-aw sinda sa iya, naduyà siya kay natabunan ng mga panganod. ");
INSERT INTO rol_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Mintras nagahangad pa sinda sa langit kung sa diin naduyà si Hesus, gulpi lang nga nagtindog sa inda alihid ang duha nga lyaki nga nakaputì. ");
INSERT INTO rol_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Hambay ninda, “Mga taga-Galilea, basì nagatindog pa kamo diri kag nagahangad sa langit? Ining si Hesus nga indo nakità nga gingdaya palangit hay mabalik diri sa kalibutan. Kag kung pauno siya nagpaibabaw tiyad da ini ang iya pagbalik.” ");
INSERT INTO rol_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Niyan, nagbalik ang mga apostoles sa Jerusalem halin sa Bukid ng mga Olibo*. Ang kalayò ng ini nga bukid halin sa syudad ng Jerusalem hay isa ka kilometro. ");
INSERT INTO rol_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Pag-abot ninda didto, nagsakà sinda sa kwarto didto sa ibabaw ng bayay nga inda ginadayunan. Sinda hay sina Pedro, Juan, Santiago*, Andres, Felipe, Tomas, Bartolome, Mateo, Santiago nga ungà ni Alfeus, Simon nga dati hay nagrebelde sa gobyerno ng Roma kag si Judas nga ungà ni Santiago. ");
INSERT INTO rol_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Permi sinda nagatipon para magpangamuyò, kaibahan ang pila ka babayi patì si Maria nga nanay ni Hesus kag yadto da ang mga manghod niya nga lyaki. ");
INSERT INTO rol_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Pagkaligad ng pila ka adlaw, nagtipon ang 120 nga mga nagatuo kay Hesus. Nagtindog si Pedro sa inda tungà kag naghambay, ");
INSERT INTO rol_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Mga kauturan ko, kahinangyan nga matuman ang yarà sa Kasulatan nga ginghambay ng Espiritu Santo paagi kay David. Ini hay parti kay Judas nga imaw ang nagbulig sa mga nagdakop kay Hesus. ");
INSERT INTO rol_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Kaibahan siya sa amon grupo kag gingpilì nga miyugserbisyo sa ini nga ministeryo.” ");
INSERT INTO rol_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Nagbakay si Judas ning dutà sa kwarta nga iya nabaton sa iya malain nga ginghuman. Didto siya nahuyog nga una ang uyo. Nagbusdì ang iya tiyan kag nagluwas ang iya tinae. ");
INSERT INTO rol_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Nasayuran ini ng tanan nga nagaistar sa Jerusalem, nganì gingtawag ninda adto nga dutà sa inda linggwahe ng Akeldama, ang gusto hambayon, Dutà ng Dugò.) ");
INSERT INTO rol_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Naghambay pa si Pedro parti sa gingsulat ni David sa mga Salmo: “ ‘Pabay-i na lang ang iya ginaistaran, kag dapat wayà na gid ning may mag-istar didto.’ Kag nakasulat da, ‘Itao na lang sa iban ang iya ministeryo.’ ");
INSERT INTO rol_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Nganì niyan, kahinangyan nga magpilì kita ning kabaylo ni Judas. Ang dapat naton pilion hay adtong kaibahan naton sa tanan nga oras nang yari pa sa aton si Ginoong Hesus ");
INSERT INTO rol_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","tunà nang pagbawtismo ni Juan hasta sa pagdaya sa iya pakadto sa langit. Kay kahinangyan nga magpamatuod siya pareho naton sa pagkabanhaw ni Hesus.” ");
INSERT INTO rol_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Nganì duha ka tawo ang inda gingpilian: si Matias kag si Jose nga ginatawag da nga Barsabas o Justus. ");
INSERT INTO rol_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Pagkatapos nagpangamuyò sinda, “Ginoo, ikaw ang nakakasayod ng tagipusuon ng tanan nga tawo. Ipakità mo sa amon kung sin-o sa duha ang imo gingpilì ");
INSERT INTO rol_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","nga maging kabaylo ni Judas. Kay gingbayaan niya ang iya pagserbisyo bilang apostol* kag nagkadto sa lugar nga angay sa iya.” ");
INSERT INTO rol_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Pagkatapos nagbunot-bunutan sinda kag ang nabunot hay si Matias. Nganì siya ang gingdugang sa onse nga apostoles. ");
INSERT INTO rol_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Nang mag-abot ang adlaw ng Pentecostes* nagtipon ang tanan nga mga nagatuo sa isa ka lugar. ");
INSERT INTO rol_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Kag gulpi na lang may nabatian nga tunog halin sa langit nga pareho sa huni ng makusog nga hangin kag ang tanan nga yadto sa suyod ng bayay nakabatì. ");
INSERT INTO rol_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Pagkatapos may nakità sinda nga daw dilà ng kalayo kag ini hay nagtugpà sa kada isa sa inda. ");
INSERT INTO rol_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Gingpunò sinda tanan ng Espiritu Santo kag nagpanghambay sinda sa iba-iba nga mga linggwahe nga wayà ninda nasayuri nga gingtao sa inda ng Espiritu. ");
INSERT INTO rol_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Sa adto da nga tyempo, may mga diosnanon nga mga Judio nga nagatinir didto sa Jerusalem nga halin sa tanan nga mga nasyon sa bilog nga kalibutan. ");
INSERT INTO rol_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Pagkabatì ninda ng adto nga tunog, nagkadto sinda sa lugar nga ginatipunan ng mga nagatuo kag natingaya gid sinda kay ang kada isa sa inda hay nakabatì ng iya kaugalingon nga linggwahe nga ginahambay ng mga nagatuo. ");
INSERT INTO rol_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Natingaya gid sinda kag nagpinangutan-an, “Dì ba tanan inà sinda hay mga taga-Galilea? ");
INSERT INTO rol_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Basì nakakahambay sinda ng aton kaugalingon nga linggwahe? ");
INSERT INTO rol_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ang iban sa aton hay taga-Partia, Medes kag Elam. Igwa da ning mga taga-Mesopotamia, Judea, Capadosia, Pontus kag Asia. ");
INSERT INTO rol_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Ang iban hay taga-Frigia, Pamfilia, Egipto kag halin sa mga lugar nga sakop ng Libya nga malapit sa Cyrene. Igwa da mga bisita halin sa Roma, ");
INSERT INTO rol_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","mga Judio kag bukon nga nagbaton sa relihiyon ng mga Judio. Kag ang iban hay halin sa Crete kag Arabia. Pero nababatian naton sinda nga nagahambay sa aton kaugalingon nga mga linggwahe parti sa mga makatitingaya gid nga butang nga ginghuman ng Dios.” ");
INSERT INTO rol_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Natingaya ang tanan kag indì gid ninda maintindihan, nganì nagpinangutan-an sinda, “Ano ang gusto hambayon ini?” ");
INSERT INTO rol_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pero ging-insulto ng iban ang mga nagatuo kag naghambay, “Mga bayong inà nga mga tawo!” ");
INSERT INTO rol_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Nganì nagtindog si Pedro kaibahan ang onse nga apostoles kag naghambay ning makusog sa mga tawo, “Mga kapareho ko nga mga Judio kag kamo tanan nga nagaistar sa Jerusalem, pamatì kamo sa akon kay ihambay ko kung ano ang gusto hambayon ini. ");
INSERT INTO rol_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Salà ang indo ginahunahunà nga bayong ini nga mga tawo, kay alas nuwebe pa lang ng aga. ");
INSERT INTO rol_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Imaw ini ang gingpropesiya ni Propeta* Joel nang una, ");
INSERT INTO rol_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Naghambay ang Dios, “Ini ang akon humanon sa ulihi nga mga adlaw: Itatao ko ang akon Espiritu sa tanan nga tawo. Ang indo mga ungà nga lyaki kag babayi hay magapropesiya, ang indo mga soltero hay makakakità ning mga panan-awon, kag ang indo mga maguyang nga lyaki hay magapananamgo. ");
INSERT INTO rol_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Aber ang akon mga ulipon, lyaki o babayi, hay pagataw-an ko ng akon Espiritu sa adto nga tyempo, kag sinda hay magapropesiya. ");
INSERT INTO rol_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Kag magapakità ako ning mga milagro sa langit kag mga makatitingaya nga butang diri sa kalibutan: dugò, kalayo kag madakmoy nga aso. ");
INSERT INTO rol_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ang adlaw hay magaduyom kag magapuya ang bulan pareho ng dugò. Ini hay matatabò bago mag-abot ang makatitingaya gid nga adlaw ng Ginoo. ");
INSERT INTO rol_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Kag ang aber sin-o nga magatawag sa pangayan ng Ginoo hay maluluwas.” ’ ” ");
INSERT INTO rol_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Naghambay pa gid si Pedro, “Mga kapareho ko nga Israelita, pamatii nindo ako. Si Hesus nga taga-Nazaret hay gingsugò ng Dios sa indo kag gingpamatuuran ini ng Dios paagi sa mga pambihirà nga gahom, makatitingaya nga butang kag milagro nga ginghuman ng Dios paagi sa iya. Sayod gid ini nindo kay natabò ini tanan diri sa indo. ");
INSERT INTO rol_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Sayod gid ng Dios bago ini natabò nga si Hesus hay itugyan sa indo kag ini gid ang iya gingplano. Gingpapatay nindo siya sa mga makasasalà nga tawo nga naglangsang sa iya sa krus. ");
INSERT INTO rol_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pero gingbanhaw siya ng Dios kag gingluwas sa gahom ng kamatayon, kay ang kamatayon wayà gid ning gahom para pugungon siya. ");
INSERT INTO rol_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kay naghambay si David parti sa iya: ‘Nakità ko ang Ginoo yarà gid permi sa akon alihid, kag tungod yarà siya sa akon, indì ako mahadlok. ");
INSERT INTO rol_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Nganì nalilipay gid ako, kag indì mapunggan ang akon pagdayaw sa Dios, kag aber mamatay ako igwa ako ning paglaom. ");
INSERT INTO rol_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Kay sayod ko nga indì mo ako pagpabay-an didto sa lugar ng mga patay, kag indì mo tugutan nga malunot ang imo matinumanon nga suluguon. ");
INSERT INTO rol_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Gingtudlò mo sa akon ang dayan pakadto sa kabuhì, kag tungod ikaw permi ang akon kaibahan, ako hay napunò ning kalipay.’ ");
INSERT INTO rol_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Mga kapareho ko nga Judio, matuod gid ang akon ginahambay sa indo nga ang bantog nga kalulo-lulohan naton nga si David hay namatay kag ginglubong kag ang iya lubungan hay yari hasta arinyan. ");
INSERT INTO rol_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Siya hay propeta nganì nasayuran niya nga ang Dios nagpanumpà sa iya nga ang isa sa iya mga inapo magapanublì ng iya gingharian. ");
INSERT INTO rol_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Kag nasayuran da niya kung ano ang humanon ng Dios, nganì naghambay siya parti sa pagkabanhaw ni Kristo*: ‘Wayà siya gingpabay-i sa lugar ng mga patay, kag ang iya lawas hay wayà naglunot sa lubungan.’ ");
INSERT INTO rol_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ang iya ginahambay hay wayà ning iban kundì si Hesus nga gingbanhaw ng Dios kag tanan kami hay nagapamatuod sa ini nga natabò. ");
INSERT INTO rol_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Gingpapungkò siya hampig sa tuo ng Dios nga iya Amay kag nabaton niya ang Espiritu Santo nga gingpromisa sa iya ng Amay. Ini nga Espiritu Santo hay gingpadaya ni Hesus sa amon kag ang iya gahom imaw ang indo nakità kag nabatian niyan. ");
INSERT INTO rol_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Bukon si David ang gingtaas sa langit pero hambay niya, ‘Naghambay ang Ginoo sa akon Ginoo: Pungkò diri sa akon tuo, ");
INSERT INTO rol_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","hasta mapasukò ko sa imo ang imo mga kaaway.’ ");
INSERT INTO rol_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Nganì dapat gid nga masayuran ng tanan nga Israelita nga ini nga Hesus nga indo ginglangsang sa krus imaw ang gingpilì ng Dios nga maging Ginoo kag Kristo!” ");
INSERT INTO rol_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nang mabatian ini ninda, nakonsensya gid sinda kag nagpangutana kay Pedro kag sa iban nga apostoles, “Mga kapareho namon nga Judio, ano ang dapat namon humanon?” ");
INSERT INTO rol_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Nagsabat si Pedro, “Hinuysuyi nindo ang indo mga salà kag magpabawtismo sa pangayan ni Hesu-Kristo, agud patawaron ang indo mga salà kag mabaton nindo ang regalo ng Dios nga imaw ang Espiritu Santo. ");
INSERT INTO rol_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kay ini nga Espiritu Santo gingpromisa para sa indo, sa indo mga ungà, sa tanan nga yadto sa malayò kag sa tanan nga ginatawag ng Ginoo nga aton Dios para magpalapit sa iya.” ");
INSERT INTO rol_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Kag kadamò pa ang pagpamatuod ni Pedro paagi sa iya gingpanghambay kag nagpangabay siya sa inda, “Luwasa nindo ang indo kaugalingon sa parusa para sa malain nga mga tawo sa ini nga tyempo.” ");
INSERT INTO rol_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Kadamò ang nagpati sa iya mensahe kag nagpabawtismo. Sa adto nga adlaw mga 3,000 ang nadugang sa mga nagatuo kay Kristo. ");
INSERT INTO rol_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Mahugod sinda magtuon sa mga ginatudlò ng mga apostoles, magtipon-tipon bilang mag-utod, magbuak-buak ning tinapay kag magpangamuyò. ");
INSERT INTO rol_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Kadamò ang mga makatitingaya nga butang kag milagro nga ginghuman ng Dios paagi sa mga apostoles. Nganì nagkabuhì ang mga nagatuo nga may pagtahod kag kahadlok sa Dios. ");
INSERT INTO rol_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Kaayo ang inda pagsinundanan kag ang inda mga pagkabutang hay para sa tanan. ");
INSERT INTO rol_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Gingpamaligyà ninda ang inda mga pagkabutang kag propidad kag gingparte-parte ang kwarta sa tanan sunò sa inda mga kahinangyanon. ");
INSERT INTO rol_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Adlaw-adlaw nagatipon sinda sa templo kag nagabuak-buak ning tinapay sa inda mga bayay. Nagadungan da sinda sa pagkaon nga may kalipay kag may mapainubuson nga tagipusuon ");
INSERT INTO rol_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","kag nagadayaw sinda sa Dios. Ang tanan nga tawo hay may maayo nga kabubut-on sa inda. Kag adlaw-adlaw ginadugang ng Ginoo sa inda ang mga tawo nga iya ginaluwas. ");
INSERT INTO rol_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Isa ka adlaw nang mga alas tres ng hapon, nagkadto sina Pedro kag Juan sa templo. Oras adto ng pagpangamuyò. ");
INSERT INTO rol_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","May lyaki didto nga lupog tunà pa nang siya hay natawo. Adlaw-adlaw ginadaya siya ng mga tawo sa pwertahan ng templo nga ginatawag, Maayo nga Pwertahan, para magpalimos sa mga nagasuyod. ");
INSERT INTO rol_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nang makità niya sina Pedro kag Juan nga pasuyuron sa templo, nagpangayò siya ning limos. ");
INSERT INTO rol_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Gingtutok siya nina Pedro kag Juan kag naghambay si Pedro sa iya, “Tan-aw sa amon.” ");
INSERT INTO rol_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Kag nagsirò siya sa inda nga nagapaabot nga taw-an siya ning limos. ");
INSERT INTO rol_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pero naghambay si Pedro sa iya, “Wayà ako ning kwarta, pero itao ko sa imo ang igwa ako: sa pangayan ni Hesu-Kristo nga taga-Nazaret, tindog kag magpanaw!” ");
INSERT INTO rol_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pagkatapos ginghawiran ni Pedro ang iya tuo nga kamot kag gingpatindog siya. Kag adto nga daan nagkusog ang iya siki kag bukong-bukong. ");
INSERT INTO rol_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Palumpat siya nga nagtindog kag nagtunà nga magpanaw-panaw. Pagkatapos nagnunot siya sa inda pasuyod sa templo. Sige ang iya kapapanaw kag kalulumpat mintras nagadayaw sa Dios. ");
INSERT INTO rol_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Nakità siya ng tanan nga nagapanaw na kag nagadayaw sa Dios. ");
INSERT INTO rol_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Nasayuran ninda nga siya adto ang permi nagapungkò kag nagapalimos sa Maayo nga Pwertahan ng templo. Nganì natingaya gid sinda sa natabò sa iya. ");
INSERT INTO rol_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Mintras nagahawid ang lyaki kana Pedro kag Juan pakadto sa lugar nga ginatawag, Balkon ni Solomon, nagpangdyagan ang tanan nga tawo pakadto sa inda kay tudo gid ang inda katingaya. ");
INSERT INTO rol_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Nang makità ni Pedro ang mga tawo, naghambay siya, “Mga kapareho ko nga Israelita, basì natingaya gid kamo sa natabò? Basì nagasinirò kamo sa amon nga daw paagi sa amon kaugalingon nga gahom o pagkadiosnanon hay napapanaw namon siya? ");
INSERT INTO rol_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ang Dios nina Abraham, Isaac, Jacob kag ng aton mga kalulo-lulohan hay imaw ang nagpakadakò sa iya suluguon nga si Hesus. Imaw ini ang Hesus nga indo gingtugyan sa mga otoridad kag indo gingsikway sa atubangan ni Pilato, aber gusto kuntà niya nga siya hay buhian. ");
INSERT INTO rol_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Balaan kag Matarong siya, pero gingsikway nindo kag gingpangayò kay Pilato nga buhian ang miyugpatay ning tawo. ");
INSERT INTO rol_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Gingpapatay nindo ang nagatao ning kabuhì, pero gingbanhaw siya ng Dios. Kag kami hay makapamatuod sa iya pagkabanhaw. ");
INSERT INTO rol_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Paagi sa pangayan ni Hesu-Kristo kag pagtuo sa iya, nagkusog ini nga tawo nga indo nakikità kag nakikilaya. Ang pagtuo kay Hesus hay nagtao sa iya ning maayo nga lawas nga nakikità nindo tanan arinyan. ");
INSERT INTO rol_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Niyan, mga kapareho ko nga Judio, sayod ko nga kamo kag ang indo mga pinunò hay imaw ang naghuman ini kay Hesus kay wayà kamo nakasayod kung sin-o gid siya. ");
INSERT INTO rol_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Gingpasayod na ng Dios nang una paagi sa mga propeta nga si Kristo hay kahinangyan gid mag-agi ning kasakit kag sa indo ginghuman sa iya, natuman ang ginghambay ng Dios. ");
INSERT INTO rol_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Nganì hinuysuyi nindo ang indo salà kag magbalik sa Dios para patawaron niya ang indo mga kasal-anan ");
INSERT INTO rol_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","kag magaabot sa indo ang espirituhanon nga kusog halin sa Ginoo. Pagkatapos ipadaya niya si Kristo nga imaw si Hesus nga gingpilì na niya para sa indo. ");
INSERT INTO rol_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Pero kahinangyan anay siya nga magtinir sa langit hasta mag-abot ang tyempo nga bag-uhon ng Dios ang tanan nga butang nga imaw ang gingpahambay na niya nang una pa paagi sa iya mga propeta. ");
INSERT INTO rol_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Kay ginghambay ni Moises, ‘Ang Ginoo nga aton Dios hay magatao sa indo ng isa ka propeta pareho sa akon, nga sa indo da magahalin. Tumana gid nindo ang tanan nga ihambay niya sa indo. ");
INSERT INTO rol_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ang aber sin-o nga indì magtuman sa ini nga propeta hay parusahan ng Dios.’ ");
INSERT INTO rol_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Tiyad da ini ang ginghambay ng tanan nga mga propeta tunà kay Samuel. Sinda tanan naghambay parti sa mga butang nga matatabò sa ini nga tyempo. ");
INSERT INTO rol_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ang mga gingpromisa ng Dios paagi sa mga propeta hay para gid sa aton nga mga Judio kag kaibahan kita sa kasugtanan nga ginghuman ng Dios sa aton kalulo-lulohan. Kay naghambay siya kay Abraham, ‘Pakamaayuhon ko ang tanan nga tawo sa kalibutan paagi sa imo mga inapo.’ ");
INSERT INTO rol_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nganì nang gingsugò ng Dios ang iya gingpilì nga suluguon sa kalibutan, kita nga mga Judio ang iya una nga gingkadtuan para buligan niya kita nga magtalikod sa aton malain nga ginahuman.” ");
INSERT INTO rol_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Mintras nagahambay pa sina Pedro kag Juan sa mga tawo, gingpalapitan sinda ng mga parì, ng kapitan ng mga gwardya sa templo kag ng mga Saduceo*. ");
INSERT INTO rol_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Nahangit gid sinda sa duha nga apostoles kay nagatudlò sinda sa mga tawo nga nabanhaw si Hesus kag ini hay nagapamatuod nga may pagkabanhaw. ");
INSERT INTO rol_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Nganì gingdakop ninda sina Pedro kag Juan para imbistigahan. Pero tungod gab-i na, gingsuyod na lang anay sinda sa prisuhan hasta mag-aga. ");
INSERT INTO rol_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pero kadamò na sa mga nakabatì ng inda mga gingpanudlò ang nagtuo kay Hesus. Sa mga lyaki lang nga nagtuo nag-abot na sa 5,000. ");
INSERT INTO rol_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Pagkaaga, nagtipon sa Jerusalem ang mga pinunò nga parì, mga miyugdumaya ng Judio kag mga eskriba*. ");
INSERT INTO rol_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Kaibahan didto sina Anas nga Pinakamataas nga Parì, Caifas, Juan, Alexander kag ang iban pa nga mga miyembro ng pamilya ng Pinakamataas nga Parì. ");
INSERT INTO rol_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Gingpadaya ninda sina Pedro kag Juan sa inda atubangan kag gingpangutana, “Sa ano nga gahom o kanin-o pangayan nindo ginahuman ang mga butang nga ini?” ");
INSERT INTO rol_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Niyan si Pedro nga punò ng Espiritu Santo nagsabat sa inda, “Mga pinunò ng mga parì kag mga miyugdumaya ng Judio, ");
INSERT INTO rol_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","kung kami arinyan hay ginaimbistigahan nindo tungod sa maayo nga ginghuman namon sa ini nga lupog kag kung pauno siya nag-ayo, ");
INSERT INTO rol_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","dapat masayuran nindo tanan kag ng tanan nga Israelita nga ini nga tawo nga nagatindog sa indo atubangan hay nag-ayo paagi sa gahom ng pangayan ni Hesu-Kristo nga taga-Nazaret. Siya hay gingpalangsang nindo kag namatay, pero gingbanhaw ng aton Dios. ");
INSERT INTO rol_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Si Hesus imaw ang ginahambay ng Kasulatan: ‘Ang bato nga gingsikway nindo nga mga panday; imaw ang naging pinakaimportante nga bato ng pundasyon.’ ");
INSERT INTO rol_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ang kaluwasan hay paagi lang gid kay Hesus, kay wayà gid ning iban sa bilog nga kalibutan nga makaluwas sa aton.” ");
INSERT INTO rol_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Nang makità ninda nga wayà gid mahadlok sina Pedro kag Juan kag nasayuran ninda nga wayà sinda ning iniskwelahan kag mga ordinaryo lang nga mga tawo, natingaya gid sinda. Kag nasayuran ninda nga mga kaibahan galì ini ni Hesus nang una. ");
INSERT INTO rol_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Gusto kuntà ninda nga maghambay ning kontra sa milagro nga ginghuman nina Pedro, pero tungod ang lyaki nga ging-ayo hay nagatindog sa alihid ninda, naghipos na lang sinda. ");
INSERT INTO rol_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Nganì gingpahalin anay sina Pedro sa Korte ng mga Judio* kag pagkatapos nag-istorya sinda sa isa kag isa. ");
INSERT INTO rol_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Hambay ninda, “Ano ang aton humanon sa inda? Kay bantog na sa bilog nga Jerusalem nga nakahuman sinda ning milagro kag indì gid naton inà mabalibaran. ");
INSERT INTO rol_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pero para indì na magkayat ini nga balità, bawalan naton sinda nga mag-istorya aber kanin-o parti kay Hesus.” ");
INSERT INTO rol_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Nganì gingpatawag ninda sina Pedro kag Juan kag gingsugò nga indì na maghambay o magtudlò parti kay Hesus. ");
INSERT INTO rol_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pero nagsabat sina Pedro kag Juan sa inda, “Kamo na ang maghusga kung ano ang tamà sa panirò ng Dios, ang magtuman ba sa indo o ang magtuman sa Dios? ");
INSERT INTO rol_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Indì puydi nga magpara kami sa paghambay parti sa amon nakità kag nabatian.” ");
INSERT INTO rol_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Pero gingpaandaman gihapon sinda nga indì na gid magpamalità kag pagkatapos gingbuhian na sinda. Aber gusto ninda parusahan, indì ninda mahuman kay nagadayaw ang tanan nga tawo sa Dios tungod sa milagro nga natabò. ");
INSERT INTO rol_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Kay ang lyaki nga nag-ayo paagi sa milagro hay sobra na sa 40 ka años ang iya edad. ");
INSERT INTO rol_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pagkatapos buhian sina Pedro kag Juan, nagkadto sinda sa inda mga kaibahan kag nagbalità kung ano ang ginghambay ng mga Pinakamataas nga Parì kag ng mga miyugdumaya ng Judio. ");
INSERT INTO rol_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nang mabatian ninda ini, nagpangamuyò sinda tanan sa Dios, “O Ginoo nga makagagahom sa tanan, ikaw ang naghuman ng langit, ng dutà, ng dagat kag ng tanan nga butang nga yarà dirà. ");
INSERT INTO rol_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Paagi sa Espiritu Santo gingpahambay mo sa amon kalulo-lulohan nga si David nga imo suluguon: ‘Basì sobra gid ang kahangit ng mga bukon Judio*, kag basì ang mga tawo hay nagaplano ning wayà puyos? ");
INSERT INTO rol_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ang mga harì sa kalibutan kag ang mga pinunò hay nagatipon kag nagapreparar para magkontra sa Ginoo kag sa iya Kristo.’ ");
INSERT INTO rol_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Sayod namon nga matuod gid ang imo gingpahambay nang una, kay diri gid sa Jerusalem si Herodes, si Poncio Pilato, ang mga bukon Judio kag ang mga Israelita nagkatipon para kontrahon ang imo balaan nga suluguon nga si Hesus nga imo gingpilì nga maging harì. ");
INSERT INTO rol_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Sa inda ginghuman, natuman na ang imo gingplano nang una. Kag ini hay natabò paagi sa imo gahom kag kabubut-on. ");
INSERT INTO rol_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Kag niyan, Ginoo, ginapahog ninda kami. Buligi kami kag taw-i ning kaisog nga magwali ng imo hambay. ");
INSERT INTO rol_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Pakitaan ang imo gahom! Itugot nga paagì sa pangayan ng imo balaan nga suluguon nga si Hesus makapaayo kami ning mga may sakit kag makahuman ning mga milagro kag makatitingaya nga mga butang!” ");
INSERT INTO rol_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Pagkatapos ninda pangamuyò, ang lugar nga inda ginatipunan hay naghubog. Gingpunò sinda tanan ng Espiritu Santo kag nagwali ng hambay ng Dios nga wayà ning kahadlok. ");
INSERT INTO rol_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nagkaisa ang tanan nga mga nagatuo sa inda hunahunà kag tagipusuon. Wayà ninda ginasariliha ang inda mga pagkabutang kundì ang tanan nga igwa sinda hay para da sa tanan. ");
INSERT INTO rol_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Paagi sa dakò gid nga gahom, padayon nga nagapamatuod ang mga apostoles nga si Ginoong Hesus hay nabanhaw. Kag abunda gid ang bulig ng Dios sa tanan nga nagatuo. ");
INSERT INTO rol_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Wayà na may nagakuyang sa inda kay may mga kauturan nga nagbaligyà ng inda mga dutà kag mga pagkabutang ");
INSERT INTO rol_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","kag gingtao ninda ang kwarta sa mga apostoles. Kag gingpanagtag ini ninda sa mga nagatuo sunò sa kahinangyan ng isa kag isa. ");
INSERT INTO rol_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Imaw da ini ang ginghuman ni Jose nga taga-Cyprus nga inapo ni Levi. Ginatawag siya ng mga apostoles nga Bernabe nga ang gusto hambayon, ‘ang tawo nga nagapakusog ng buot’. ");
INSERT INTO rol_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Gingbaligyà niya ang iya dutà kag gingtao ang kwarta sa mga apostoles. ");
INSERT INTO rol_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","May mag-asawa nga nagbaligyà da ng inda dutà. Ang pangayan ng lyaki hay Ananias kag ang iya asawa hay Safira. ");
INSERT INTO rol_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Gingtagò ni Ananias ang iban nga bayad kag sayod da ini ng iya asawa. Gingdaya niya ang nabilin nga kwarta kag gingtao sa mga apostoles. ");
INSERT INTO rol_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pero naghambay si Pedro sa iya, “Ananias, basì nagpadaog ka kay Satanas? Nagpinusong ka sa Espiritu Santo kay ang iban nga bayad sa imo dutà gingtagò mo! ");
INSERT INTO rol_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Nang wayà mo pa nabaligyà ang dutà, dì ba sa imo adto? Kag nang nabaligyà mo na, dì ba ikaw ang magbuot kung unhon mo ang kwarta? Basì ginghungod mo gid nga humanon ini? Bukon ka sa amon nagpinusong kundì sa Dios!” ");
INSERT INTO rol_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Nang mabatian ini ni Ananias, natumba siya kag namatay. Kag ang tanan nga nakabatì sa natabò hay hinadlukan gid. ");
INSERT INTO rol_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Pagkatapos, gingpalapitan siya ng mga kabataan kag gingputos ang iya lawas. Gingbayawan ninda ini paluwas kag ginglubong. ");
INSERT INTO rol_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Pagkaligad ng mga tuyo ka oras, nag-abot ang iya asawa nga wayà kasayod sa natabò. ");
INSERT INTO rol_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Gingpangutana siya ni Pedro, “Balitaan sa akon, imaw lang gid ba ini tanan ang bayad nga nabaton nindo?” Kag nagsabat naman siya, “Huo, imaw lang gid inà.” ");
INSERT INTO rol_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pero hambay ni Pedro, “Basì nagkaisa kamo para tilawan ang Espiritu ng Ginoo? Sirua, yarà na sa pwertahan adtong mga kabataan nga naglubong sa imo asawa kag pagabayawan ka da ninda paluwas!” ");
INSERT INTO rol_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Adto nga daan natumba siya kag namatay. Pagsuyod ng mga kabataan, nakità ninda nga patay na da siya nganì gingbayawan siya paluwas kag ginglubong sa alihid ng iya asawa. ");
INSERT INTO rol_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kag hinadlukan gid ang tanan nga nagatuo kay Hesu-Kristo didto kag tanan nga nakabatì. ");
INSERT INTO rol_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Kadamò ang mga milagro kag makatitingaya nga butang ang ginghuman ng mga apostoles sa mga tawo. Kag nagatipon permi ang tanan nga nagatuo sa Balkon ni Solomon. ");
INSERT INTO rol_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ang iban nga wayà nagatuo hay wayà gid nagalakot pero ginatahod gid ang mga nagatuo ng tanan nga tawo sa Jerusalem. ");
INSERT INTO rol_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Kag kadamò pa nga mga tawo ang nadugang sa mga nagatuo sa Ginoo, mga lyaki kag mga babayi. ");
INSERT INTO rol_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Tungod sa mga milagro ng mga apostoles, gingdaya ng mga tawo ang mga may sakit sa alihid ng mga karsada kag gingbutang sa mga banig para malandungan ng anino ni Pedro kung mag-agi siya sa inda. ");
INSERT INTO rol_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Kadamò da ang mga tawo nga nagtipon didto halin sa mga banwa palibot sa Jerusalem. Kag gingdaya ninda ang mga may sakit kag ang mga ginasapian ning malain nga mga espiritu kag tanan sinda hay nag-ayo. ");
INSERT INTO rol_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Pero naili gid ang Pinakamataas nga Parì kag ang iya mga kaibahan nga miyembro ng sekta ng Saduceo. ");
INSERT INTO rol_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Nganì gingdakop ninda ang mga apostoles kag gingpriso. ");
INSERT INTO rol_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pero pagkagab-i gingbuksan ng anghel ng Ginoo ang mga pwertahan ng prisuhan kag gingpaluwas sinda. Hambay ng anghel sa inda, ");
INSERT INTO rol_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Kadto kamo sa templo kag tudlui ang mga tawo parti sa bag-o nga kabuhì nga ginatao ng Dios.” ");
INSERT INTO rol_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Gingtuman ninda ang gingsugò ng anghel nganì nang aga pa gid nagsuyod sinda sa templo kag nagtudlò sa mga tawo. Nang mag-abot ang Pinakamataas nga Parì kag ang iya mga kaibahan, gingpatawag ninda ang tanan nga miyembro ng Korte ng mga Judio kag ang tanan nga pinunò ng Israel para mitingon. Gingpabuoy ninda sa prisuhan ang mga apostoles. ");
INSERT INTO rol_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Pero pagkadto didto ng mga opisyales ng templo, wayà na sa prisuhan ang mga apostoles, nganì nagbalik sinda kag nagbalità, ");
INSERT INTO rol_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Nakità namon nga nakatrangka gid maayo ang prisuhan kag ang mga gwardya hay nagatindog sa may pwertahan, pero pagbukas namon wayà na ning tawo sa suyod!” ");
INSERT INTO rol_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Pagkabatì ng kapitan sa mga gwardya ng templo kag ng mga pinunò nga parì ng inda gingbalità, nagulpihan gid sinda kag natingaya kung ano ang natabò sa mga apostoles. ");
INSERT INTO rol_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Pagkatapos may tawo nga nag-abot kag nagbalità, “Ang mga lyaki nga indo gingpriso hay yadto na gidaw sa templo kag nagatudlò sa mga tawo!” ");
INSERT INTO rol_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Nganì nagkadto didto ang kapitan kag ang iya mga tawohan kag gingdaya pabalik ang mga apostoles. Pero wayà sinda gingsakita kay nahadlok nga basì kung buguyon sinda ng mga tawo. ");
INSERT INTO rol_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Gingdaya ninda ang mga apostoles kag gingpaatubang sa Korte ng mga Judio. Gingpangutana sinda ng Pinakamataas nga Parì, ");
INSERT INTO rol_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Dì ba gingbawalan na namon kamo nga magtudlò parti kay Hesus? Pero sirua ang indo ginghuman! Nasayuran na sa bilog nga Jerusalem ang indo ginatudlò kag kami pa ang indo ginapabintangan nga nagpatay sa iya.” ");
INSERT INTO rol_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pero nagsabat si Pedro kag ang mga apostoles, “Ang Dios ang dapat namon tumanon kag bukon ang mga tawo! ");
INSERT INTO rol_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Gingpatay nindo si Hesus paagi sa paglangsang sa krus. Pero gingbanhaw siya ng Dios ng aton kalulo-lulohan. ");
INSERT INTO rol_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Gingpataas ng Dios si Hesus kag gingpapungkò hampig sa iya tuo bilang Pinunò kag Manluluwas, para taw-an ning tsansa ang mga Israelita nga maghinuysoy sa inda kasal-anan agud patawaron ang inda mga salà. ");
INSERT INTO rol_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Kami ang nagapamatuod sa ini nga mga natabò. Kag ang Espiritu Santo nga gingtao ng Dios sa tanan nga mga nagatuman sa iya hay nagapamatuod da sa ini nga mga natabò.” ");
INSERT INTO rol_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Nang mabatian ninda ini, nahangit gid sinda kag gusto gid ninda nga patyon ang mga apostoles. ");
INSERT INTO rol_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pero nagtindog ang isa ka Pariseo* nga ang pangayan hay Gamaliel. Kaibahan siya sa Korte ng mga Judio. Miyugtudlò siya ng Kasuguan kag ginatahod ng tanan. Gingsugò niya nga paluwason anay ang mga apostoles. ");
INSERT INTO rol_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Niyan hambay niya sa konseho, “Mga kapareho ko nga Israelita, isipon anay nindo ning maayo kung ano ang indo humanon sa ini nga mga tawo. ");
INSERT INTO rol_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kay nang una, may isa ka tawo nga ang pangayan hay Teudas. Ginapakadakò niya ang iya kaugalingon kag igwa siya ning mga 400 nga tagasunod. Pero gingpatay siya kag ang iya mga tagasunod hay nagkabuyag-buyag kag naduyà lang da adto nga grupo. ");
INSERT INTO rol_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Pagkatapos niya, si Judas naman nga taga-Galilea kag nakakumbinsi da siya ning mga tagasunod nang tyempo ng pagsensus. Pero gingpatay da siya kag tanan niya nga tagasunod hay nagkabuyag-buyag da. ");
INSERT INTO rol_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Nganì sa ini nga kaso, ginahambay ko sa indo, buhii ini nga mga tawo kag ayaw sinda pagsakita. Kay kung ining inda ginahuman kag ginaplano hay halin sa tawo lang, indì ini magpadayon. ");
INSERT INTO rol_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pero kung ini hay halin sa Dios, indì naton sinda mapunggan. Kag isa pa, basì kung ang matabò, ang Dios na gid ang aton ginakontra!” Gingtuman ng konseho ang ginglaygay ni Gamaliel. ");
INSERT INTO rol_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Gingpatawag ninda liwat ang mga apostoles kag gingpalatigo. Pagkatapos gingbawalan sinda liwat nga maghambay o magtudlò parti kay Hesus kag gingbuhian sinda. ");
INSERT INTO rol_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Paghalin ninda sa Korte ng mga Judio, nalipay gid sinda kay sayod ninda nga gingtaw-an sinda ng Dios ning pribilihiyo nga makaagi ng kahugaan tungod sa inda pagsunod kay Hesus. ");
INSERT INTO rol_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kada adlaw, nagakadto sinda sa templo kag sa mga bayay kag padayon sinda nga nagatudlò kag nagawali ng Maayong Balità* nga si Hesus imaw ang Kristo. ");
INSERT INTO rol_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Nang adto nga mga adlaw, nagapakadamò na gid ang mga disipulo. Nagreklamo ang mga Judio nga ang inda linggwahe hay Griego kontra sa mga Judio nga ang inda linggwahe hay Hebreo. Kay wayà ginataw-i ning pang-adlaw-adlaw nga rasyon ang inda mga bayo nga babayi. ");
INSERT INTO rol_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Nganì gingpatawag ng dose nga apostoles ang tanan nga mga nagatuo kag naghambay, “Bukon tamà nga pabay-an namon ang pagwali ng hambay ng Dios kag asikasuhon ang mga kahinangyanon ng mga bayo. ");
INSERT INTO rol_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Nganì, mga kauturan, magpilì kamo halin sa indo ning pito ka lyaki nga ginarespito gid, punò ng Espiritu Santo kag kamayad. Sinda ang magadumaya sa mga materyal nga bulig. ");
INSERT INTO rol_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Kag kami naman, gamiton namon ang amon oras sa pagpangamuyò kag pagwali ng hambay ng Dios.” ");
INSERT INTO rol_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Nalipay ang tanan nga nagatuo sa ginghambay ng mga apostoles kag gingpilì ninda si Esteban, ang tawo nga hugot ang pagtuo kay Hesus kag punò ng Espiritu Santo. Gingpilì da ninda sina Felipe, Procorus, Nicanor, Timon, Parmenas kag Nicolas nga bukon Judio nga taga-Antioc pero nagbaton sa relihiyon ng mga Judio. ");
INSERT INTO rol_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Gingdaya ang mga napilì sa atubangan ng mga apostoles kag gingtungtungan ninda ng inda kamot kag gingpangamuyuan. ");
INSERT INTO rol_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Nganì padayon nga naglapnag ang hambay ng Dios. Nagdugang pa gid ang mga nagatuo sa Jerusalem kag kadamò da nga mga parì ang nagtuo kay Hesus. ");
INSERT INTO rol_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Gingtaw-an ng Dios ning dakò nga gahom si Esteban kag gingbuligan gid siya. Nganì kadamò nga makatitingaya nga butang kag milagro ang iya ginghuman nga nakità ng mga tawo. ");
INSERT INTO rol_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Pero may pila ka tawo nga nagkontra sa iya. Ini nga mga tawo hay mga Judio nga halin sa Cyrene, Alexandria, Cilicia kag Asia. Mga miyembro sinda ng sinagoga* nga kung tawagon hay Sinagoga ng mga Hilway nga Ulipon. Nagpakigdibati sinda kay Esteban. ");
INSERT INTO rol_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pero tungod gingtaw-an si Esteban ning kamayad ng Espiritu Santo, indì ninda siya maperdi. ");
INSERT INTO rol_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Nganì sikreto ninda nga gingsuysugan ang pila ka tawo kag inda gingpahambay, “Nabatian namon nga nagahambay si Esteban ning malain kontra kay Moises kag sa Dios.” ");
INSERT INTO rol_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Paagi diri gingpahangit ninda ang mga tawo, mga miyugdumaya ng Judio kag mga eskriba. Gingdakop ninda si Esteban kag gingdaya sa Korte ng mga Judio. ");
INSERT INTO rol_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","May gingdaya sinda nga pila ka tawo para magtestigo ning pinusong kontra kay Esteban. Naghambay sinda, “Ini nga lyaki hay wayà gid nagapara sa iya pag-insulto sa aton balaan nga lugar kag sa Kasuguan ni Moises. ");
INSERT INTO rol_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Kay nabatian namon siya nga nagahambay nga ang aton templo gubaon ni Hesus nga taga-Nazaret kag bayluhan niya ang mga tradisyon nga ginapasunod sa aton ni Moises.” ");
INSERT INTO rol_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Kag tanan nga nagapungkò sa Korte ng mga Judio hay nagsirò gid kay Esteban kag nakità ninda nga ang iya hitsura hay masilaw nga pareho sa hitsura ng anghel. ");
INSERT INTO rol_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Niyan nagpangutana ang Pinakamataas nga Parì kay Esteban, “Matuod ba ining inda ginaakusar sa imo?” ");
INSERT INTO rol_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Nagsabat si Esteban, “Mga kapareho ko nga Judio, pamatii nindo ako. Nagpakità ang mahimayaon nga Dios sa aton kalulo-lulohan nga si Abraham nang yadto pa siya sa Mesopotamia, bago siya nagsaylo sa Haran. ");
INSERT INTO rol_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Naghambay ang Dios kay Abraham, ‘Maghalin ka sa imo banwa kag bayai ang imo mga kahalihan kag magkadto sa lugar nga akon itudlò sa imo.’ ");
INSERT INTO rol_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Nganì naghalin siya sa lugar ng Caldea kag nag-istar sa Haran. Nang namatay ang iya tatay, gingpasaylo naman siya ng Dios sa ini nga lugar nga aton ginaistaran niyan. ");
INSERT INTO rol_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Adto nga tyempo wayà pa nataw-i ng Dios si Abraham aber maisot lang nga dutà. Pero nagpromisa ang Dios nga ini nga lugar hay itatao sa iya kag sa iya mga inapo. Wayà pa ning ungà si Abraham nang gingpromisa adto ng Dios. ");
INSERT INTO rol_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Naghambay ang Dios sa iya, ‘Ang imo mga inapo hay magiging istranghero sa iban nga lugar kag didto humanon sinda nga mga ulipon kag pahugaan sinda sa suyod ng 400 ka tuig. ");
INSERT INTO rol_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Pero pagaparusahan ko ang nasyon nga magaulipon sa inda. Pagkatapos makakahalin sinda didto kag makakabalik na sa ini nga lugar kag diri sinda magasamba sa akon.’ ");
INSERT INTO rol_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Kag bilang tandà ng iya promisa, nagsugò ang Dios kay Abraham nga ang tanan nga mga lyaki hay dapat papaltakan*. Nganì pagkatawo ng iya ungà nga si Isaac, gingpapaltakan niya nang wayo pa lang siya ka adlaw. Imaw da ini ang ginghuman ni Isaac sa iya ungà nga si Jacob. Kag imaw da ang ginghuman ni Jacob sa iya dose nga ungà nga imaw ang ginghalinan naton nga mga Judio. ");
INSERT INTO rol_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Niyan, si Jose nga isa sa dose nga ungà ni Jacob hay gingkailihan ng iya mga maguyáng. Nganì gingbaligyà ninda siya kag naging ulipon sa Egipto. Pero tungod ang Dios hay kaibahan niya, ");
INSERT INTO rol_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","gingbuligan siya sa tanan nga kahugaan nga iya naagihan. Gingtaw-an siya ng Dios ning kamayad nganì nagustuhan siya ng Faraon nga harì ng Egipto kag ginghuman siya nga gobernador sa bilog nga Egipto kag naging miyugpamahayà ng tanan nga manggad ng Faraon. ");
INSERT INTO rol_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Pagkatapos nagkaigwa ning taggutom sa bilog nga Egipto kag Canaan. Ginghugaan gid ang mga tawo didto kag ang aton mga kalulo-lulohan hay wayà gid ning may mabuy-an pagkaon. ");
INSERT INTO rol_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Pero nang mabatian ni Jacob nga may pagkaon sa Egipto, gingpakadto niya didto ang aton mga kalulo-lulohan. Imaw adto ang una ninda nga pagkadto sa Egipto. ");
INSERT INTO rol_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Sa ikaduha ninda nga pagkadto, nagpakilaya na si Jose sa iya mga hali kag nakilaya ng Faraon ang pamilya ni Jose. ");
INSERT INTO rol_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Pagkatapos gingtugon ni Jose nga pakadtuon ang iya tatay nga si Jacob sa Egipto kag patì ang tanan niya nga mga kahalihan. (75 sinda tanan.) ");
INSERT INTO rol_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Nganì nagkadto si Jacob kag ang aton kalulo-lulohan sa Egipto kag didto sinda nag-istar hasta sinda mamatay. ");
INSERT INTO rol_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ang inda mga tuy-an hay gingdaya sa Shekem kag ginglubong sa lubungan nga gingbakay ni Abraham nang una sa mga ungà ni Hamor. ");
INSERT INTO rol_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Pero nang malapit na gid ang oras nga matuman ang gingpromisa ng Dios kay Abraham, nagdamò pa gid ang aton mga kalulo-lulohan sa Egipto. ");
INSERT INTO rol_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Nag-abot da ang adlaw nga nagkaigwa ang Egipto ning harì nga wayà nakakilaya kay Jose. ");
INSERT INTO rol_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Gingluko niya ang aton mga kalulo-lulohan kag gingpahugaan. Gingpilit niya sinda nga bayaan ang inda mga lapsag agud magkamatay. ");
INSERT INTO rol_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Imaw da adto nga tyempo nga ging-ungà si Moises. Kaayo-ayo gid siya nga lapsag kag nalipay ang Dios sa iya. Gingdipara siya ng iya mga ginikanan sa suyod ng tuyo ka bulan. ");
INSERT INTO rol_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Kag nang napilitan na sinda nga bayaan siya sa luwas ng bayay, gingbuoy siya ng ungà nga babayi ng Faraon kag gingkabig pareho sa iya kaugalingon nga ungà. ");
INSERT INTO rol_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Nganì gingtudluan si Moises ng tanan nga kamayad sa Egipto kag naging bantog siya tungod sa iya mga paghambay kag sa iya mga ginahuman. ");
INSERT INTO rol_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Nang si Moises hay 40 ka años na, naisip niya nga bisitahon ang iya mga kapareho nga mga Israelita. ");
INSERT INTO rol_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Didto nakità niya ang isa sa inda nga ginapintasan ng Egiptuhanon. Ging-apinan niya ang iya kapareho nga Israelita kag bilang bayos gingpatay niya ang Egiptuhanon. ");
INSERT INTO rol_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Sa ginghuman ni Moises, kalaom niya maintindihan siya ng mga kapareho niya nga luwason sinda ng Dios paagi sa iya pero wayà galì. ");
INSERT INTO rol_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Nang masunod nga adlaw nakità niya ang duha ka Israelita nga nagaaway. Gusto kuntà niya nga husayon ang duha, nganì naghambay siya sa inda, ‘Pareho kamo nga Israelita. Basì nagainaway kamo?’ ");
INSERT INTO rol_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Pero gingtuyod siya ng lyaki nga nagapangsakit ng iya kapareho kag ginghambayan, ‘Sin-o ang naghuman sa imo nga maging pinunò kag miyughusay namon? ");
INSERT INTO rol_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ano, patyon mo da ba ako pareho ng imo ginghuman sa Egiptuhanon kahapon?’ ");
INSERT INTO rol_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nang mabatian adto ni Moises, naghalin siya sa Egipto kag nagkadto sa Midian. Didto siya nag-istar kag nakapangasawa. Kag didto da natawo ang iya duha nga ungà nga lyaki. ");
INSERT INTO rol_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Pagkaligad ng 40 ka tuig, may isa ka anghel nga nagpakità kay Moises nang yadto siya sa tiway nga lugar malapit sa Bukid ng Sinai. Nakità niya ang anghel sa nagadayab nga mababà nga kahoy. ");
INSERT INTO rol_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Natingaya gid si Moises sa iya nakità! Nang nagpalapit siya para siruon kung ano gid adto, nabatian niya ang boses ng Ginoo nga nagahambay, ");
INSERT INTO rol_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ako ang Dios ng imo kalulo-lulohan nga sina Abraham, Isaac kag Jacob.’ Nang mabatian adto ni Moises, nagpangurog siya sa kahadlok kag wayà siya nagpangahas nga magsirò. ");
INSERT INTO rol_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Pagkatapos naghambay ang Dios sa iya, ‘Ubaha ang imo sandalyas kay balaan ang lugar nga imo ginatindugan. ");
INSERT INTO rol_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nakità ko gid ang mga kahugaan nga ginatiis ng akon gingpilì nga mga tawo didto sa Egipto kag nabatian ko ang inda pag-uwang. Nganì nagpanaog ako para luwason sinda. Niyan, magpreparar ka kay ikaw ang akon suguon didto sa Egipto.’ ");
INSERT INTO rol_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Imaw ini ang Moises nga gingsikway ng iya mga kapareho nga Israelita nga naghambay, ‘Sin-o ang naghuman sa imo nga maging pinunò kag miyughusay namon?’ Imaw da ini ang Moises nga gingsugò ng Dios nga maging pinunò kag manluluwas ng mga Israelita sa bulig ng anghel nga nagpakità sa iya didto sa nagadayab nga mababà nga kahoy. ");
INSERT INTO rol_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Si Moises imaw ang nagdaya sa mga Israelita paluwas sa Egipto. Naghuman siya ning mga makatitingaya nga butang kag milagro sa Egipto, sa Dagat nga Puya kag sa tiway nga lugar nga inda ging-agihan sa suyod ng 40 ka tuig. ");
INSERT INTO rol_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Si Moises da ang naghambay sa mga Israelita, ‘Mapadaya ang Dios sa indo ning isa ka propeta nga pareho sa akon nga sa indo da magahalin.’ ");
INSERT INTO rol_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Nang yadto na ang aton mga kalulo-lulohan sa tiway nga lugar, si Moises ang kaibahan ninda. Siya ang ging-istorya ng anghel ng Dios sa Bukid ng Sinai. Didto niya sa bukid gingbaton ang hambay ng Dios nga imaw adto ang nagatao ning kabuhì para itao da niya sa aton. ");
INSERT INTO rol_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Pero wayà gingtumana si Moises ng aton mga kalulo-lulohan, kundì gingsikway pa ninda siya bilang inda pinunò kay gusto ninda nga magbalik sa Egipto. ");
INSERT INTO rol_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Nganì naghambay sinda kay Aaron, ‘Humani kami ning mga dios-diosan para magapanguna sa amon. Wayà na kami nakasayod kung ano na ang natabò kay Moises nga nagpaluwas sa amon sa Egipto.’ ");
INSERT INTO rol_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Nganì naghuman sinda ning dios-diosan nga ang hitsura hay batà nga baka. Ginghalaran ninda ini kag nagpyesta sinda para magsilibrar sa ginghuman ng inda kaugalingon nga kamot. ");
INSERT INTO rol_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Sa adto nga ginghuman ninda gingtalikuran sinda ng Dios. Gingpabay-an niya sinda nga magsamba sa mga bituon sa langit, pareho ng gingsulat ng mga propeta: ‘Kamo nga mga Israelita! Sa suyod ng 40 ka tuig nindo diri sa tiway nga lugar, nag-ihaw kamo ning mga hayop kag indo ginghalad. Pero bukon ako ang indo ginghalaran. ");
INSERT INTO rol_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Gingdaya-daya pa nindo ang tolda ng indo dios-diosan nga si Molec, kag ang rebulto nga bituon ng indo dios-diosan nga si Refan. Ginghuman nindo ini nga mga dios-diosan para sambahon. Nganì palayason ko kamo pakadto pa gid sa unahan ng Babilonia.’ ");
INSERT INTO rol_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Nang yadto pa sa tiway nga lugar ang aton mga kalulo-lulohan, daya ninda ang tolda nga yadto ang presensya ng Dios. Ini nga tolda hay ginghuman ni Moises nang gingsugò siya ng Dios kag gingsunod niya ang plano nga gingpakità sa iya. ");
INSERT INTO rol_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Nang ulihi, pagkamatay ng aton mga kalulo-lulohan, ang inda mga ungà naman ang nagdaya ng tolda. Ang pinunò ninda hay si Josue*. Nasakop ninda ang dutà nga gingpromisa ng Dios, pagkatapos mapalayas ng Dios ang mga nagaistar didto. Kag gingtinir na didto ang tolda nga gingdaya ng mga Israelita hasta sa tyempo ni Haring David. ");
INSERT INTO rol_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Nalipay gid ang Dios kay David nganì nagpamuhon siya sa Dios nga tugutan siya nga magpaugdok ning templo para sa Dios agud makasamba didto ang mga inapo ni Jacob. ");
INSERT INTO rol_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pero si Solomon imaw ang nagpaugdok ning templo ng Dios. ");
INSERT INTO rol_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Ugaling lang ang Pinakamataas nga Dios wayà nagaistar sa ginghuman ng tawo. Pareho sa ginghambay ng Dios paagi sa iya propeta, ");
INSERT INTO rol_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Ang langit ang akon trono, kag ang dutà ang tungtungan ng akon siki. Anong klasi nga templo ang ipaugdok mo para sa akon? Diin ba ang lugar nga akon istaran? ");
INSERT INTO rol_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ako gid ang naghuman ng ini tanan nga mga butang.’” ");
INSERT INTO rol_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Nagpadayon si Esteban sa iya paghambay, “Matugas gid ang indo mga uyo! Wayà nindo ginatumana kag ginapamatii ang mensahe ng Dios! Pareho kamo ng indo mga kalulo-lulohan kay permi lang nindo ginakontra ang Espiritu Santo! ");
INSERT INTO rol_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Igwa ba aber isa sa mga propeta nga wayà ginghingabot ng indo mga kalulo-lulohan? Gingpamatay ninda ang mga mensahero nga nagpropesiya parti sa pag-abot ng iya Matarong nga Suluguon. Kag niyan kamo ang nagtraidor kag nagpatay sa iya. ");
INSERT INTO rol_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Kamo ang nagbaton ng Kasuguan ng Dios paagi sa mga anghel pero wayà nindo ini pagtumana!” ");
INSERT INTO rol_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Nang mabatian ini ng mga tawo sa Korte ng mga Judio, nahangit gid sinda. Nagpagot gid ang inda ngipon sa kahangit kay Esteban. ");
INSERT INTO rol_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pero si Esteban nga punò gid ng Espiritu Santo naghangad sa langit kag nakità niya ang kahimayaan ng Dios kag si Hesus nga nagatindog sa tuo ng Dios. ");
INSERT INTO rol_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Hambay niya, “Sirua nindo, nakità ko nga bukas ang langit kag yadto si Hesus nga Ungà ng Tawo* nga nagatindog sa tuo ng Dios!” ");
INSERT INTO rol_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Nagsinggit sinda kag gingtabunan ninda ang inda mga talinga para indì ninda mabatian ang ginahambay ni Esteban kag nagdinagusò sinda tanan pakadto sa iya. ");
INSERT INTO rol_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Gingyudyod siya paluwas ng syudad para buguyon. Bago siya gingbugoy, ging-uba anay ng mga nagtestigo kontra kay Esteban ang inda mga pangsuy-ob nga barò kag gingbilin hampig sa ginatindugan ng isa ka soltero nga ang pangayan hay Saulo. ");
INSERT INTO rol_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Mintras ginabugoy si Esteban, nagpangamuyò siya, “Ginoong Hesus, batuna ang akon espiritu.” ");
INSERT INTO rol_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Pagkatapos nagluhod siya kag nagsinggit ning makusog, “Ginoo, ayaw na sinda pagpanabata sa ini nga kasal-anan!” Pagkahambay niya ini hay nabugtuan siya ning ginhawa. ");
INSERT INTO rol_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Kag nagsugot si Saulo sa inda pagpatay kay Esteban. Tunà adto nga adlaw sobra gid ang paghingabot sa mga nagatuo kay Kristo sa Jerusalem kag sinda tanan hay nagkabuyag-buyag sa bilog nga probinsya ng Judea kag Samaria. Ang mga apostoles lang ang wayà naghalin sa Jerusalem. ");
INSERT INTO rol_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ginglubong si Esteban ng mga diosnanon nga mga lyaki kag nagtangis gid sinda sa kalisod. ");
INSERT INTO rol_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Pero nagtinguhà gid si Saulo nga mawayà na ang mga nagatuo. Nganì nagpangbayay-bayay siya kag gingyudyod paluwas ang mga nagatuo mapalyaki man o mapababayi kag gingpapriso. ");
INSERT INTO rol_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Nagkabuyag-buyag ang mga nagatuo kag nagwali sinda ng Maayong Balità aber diin sinda magkadto. ");
INSERT INTO rol_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Isa sa mga nagatuo hay si Felipe. Nagkadto siya sa isa ka syudad ng Samaria kag didto nagwali sa mga tawo parti kay Kristo. ");
INSERT INTO rol_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Pagkabatì ng mga tawo sa mga ginghambay ni Felipe kag nang makità ninda ang mga milagro nga iya ginghuman, nagpamatì gid sinda ning maayo. ");
INSERT INTO rol_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Kadamò ang tawo nga may malain nga mga espiritu ang ging-ayo niya. Nagsininggit ang mga espiritu mintras nagaluwas sa mga tawo. Kadamò da nga mga paralisado kag mga lupog ang iya ging-ayo. ");
INSERT INTO rol_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Nganì tudo gid ang kalipay ng mga tawo sa adto nga syudad. ");
INSERT INTO rol_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","May isa ka tawo nga nagaistar didto nga ang pangayan hay Simon. Kadugay na nga natitingaya gid ang mga taga-Samaria sa iya abilidad sa madyik. Ginapakadakò niya permi ang iya kaugalingon nga siya kuno hay importante gid nga tawo. ");
INSERT INTO rol_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ang tanan nga tawo sa syudad tunà sa pinakamababà hasta sa pinakamataas hay nagapamatì gid ning maayo sa iya. Naghambay sinda, “Ini nga tawo hay may gahom ng Dios nga ginatawag, Dakò nga Gahom.” ");
INSERT INTO rol_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Nagpamatì gid sinda ning maayo sa iya kay kadugay na nga napahangà niya ang mga tawo sa iya madyik. ");
INSERT INTO rol_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pero nang magwali si Felipe ng Maayong Balità parti sa gingharian ng Dios kag sa pangayan ni Hesu-Kristo, nagtuo sinda kag nagpabawtismo mapalyaki man o mapababayi. ");
INSERT INTO rol_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Aber si Simon hay nagtuo da. Pagkabawtismo sa iya, permi na siya naganunot kay Felipe. Kag natingaya gid siya sa mga milagro kag makakatingaya nga butang nga ginghuman ni Felipe. ");
INSERT INTO rol_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Nang mabatian ng mga apostoles sa Jerusalem nga ang mga taga-Samaria hay nagbaton na sa hambay ng Dios, gingsugò ninda didto sina Pedro kag Juan. ");
INSERT INTO rol_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Pag-abot ninda didto, nagpangamuyò sinda para sa mga nagatuo nga mabaton ninda ang Espiritu Santo. ");
INSERT INTO rol_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Kay wayà pa sinda makabaton ng Espiritu Santo. Gingbawtismuhan pa lang sinda sa pangayan ni Ginoong Hesus. ");
INSERT INTO rol_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Nganì gingtungtong sa inda ni Pedro kag ni Juan ang inda mga kamot kag nabaton ninda ang Espiritu Santo. ");
INSERT INTO rol_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Nakità ni Simon nga pagtungtong ng mga apostoles ng inda mga kamot sa mga nagatuo hay nabaton ninda ang Espiritu Santo. Nganì gingday-an niya si Pedro kag si Juan ning kwarta ");
INSERT INTO rol_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","kag naghambay siya, “Taw-i da ako ning gahom nga tiyad inà para ang aber sin-o nga tungtungan ko ng akon kamot hay makabaton ng Espiritu Santo.” ");
INSERT INTO rol_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pero nagsabat si Pedro sa iya, “Kabay pa nga makadto ka sa impyerno kaibahan ang imo kwarta! Kay ang kalaom mo puydi mabakay ang regalo ng Dios! ");
INSERT INTO rol_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Wayà ka ning parte diri sa ministeryo kay ang imo tagipusuon hay bukon tamà sa panirò ng Dios. ");
INSERT INTO rol_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Nganì hinuysuyi ini nga kalainan mo kag magpangamuyò ka sa Ginoo nga patawaron ang imo isip nga malain. ");
INSERT INTO rol_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kay nakità ko nga sobra gid ang imo kaili kag nakagapos ka gid sa kasal-anan.” ");
INSERT INTO rol_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Nagsabat si Simon, “Pangamuyui abi nindo ako sa Ginoo para indì gid matabò sa akon ang indo ginahambay.” ");
INSERT INTO rol_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pagkatapos magpamatuod nina Pedro kag Juan parti kay Hesu-Kristo kag magwali ng mensahe ng Ginoo, nagbalik sinda sa Jerusalem nga nagawali ng Maayong Balità sa madamò nga baryo nga inda naagihan sa Samaria. ");
INSERT INTO rol_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Niyan, may anghel ng Ginoo nga naghambay kay Felipe, “Kadto nga daan sa sur kag mag-agi sa karsada halin sa Jerusalem pakadto sa Gaza.” (Ini nga karsada hay wayà na masyado ginaagihi.) ");
INSERT INTO rol_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Nganì nagpanaw si Felipe kag didto nakità niya ang isa ka tawo nga taga-Etiopia. Pabalik na siya halin sa Jerusalem kung sa diin nagsamba siya sa Dios. Importante siya nga opisyal sa palasyo ni Candace nga Rayna ng Etiopia kag miyugpamahayà ng tanan niya nga manggad. ");
INSERT INTO rol_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Nang pabalik na siya nga nagasakay sa karwahe, nagabasa siya ng libro ni Propeta Isaias. ");
INSERT INTO rol_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Pagkatapos naghambay ang Espiritu Santo kay Felipe, “Kadto didto kag magdungan sa iya karwahe.” ");
INSERT INTO rol_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Nganì nagdyagan si Felipe palapit sa karwahe. Nang naabutan niya, nabatian niya nga ginabasa ng opisyal ang libro ni Propeta Isaias. Gingpangutana siya ni Felipe, “Naintindihan mo ba ang imo ginabasa?” ");
INSERT INTO rol_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Nagsabat ang opisyal, “Pauno ko ini maintindihan kung wayà may mag-isplikar sa akon?” Kag ging-agda niya si Felipe sa karwahe nga magpungkò sa alihid niya. ");
INSERT INTO rol_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Imaw ini ang parte ng Kasulatan nga iya ginabasa: “Pareho siya ng karnero nga ginadaya sa ihawan, kag pareho sa kordero nga wayà gid nagalingaw mintras ginatupihan. Wayà gid siya ning reklamo. ");
INSERT INTO rol_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Gingpakahuy-an siya kag wayà gingtaw-i ning hustisya. Sin-o ang makakahambay parti sa iya kaapo-apuhan? Wayà! Kay ang iya kabuhì diri sa dutà hay katag-od lang.” ");
INSERT INTO rol_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Nagpangutana ang opisyal kay Felipe, “Iisplikar mo abi sa akon kung sin-o ini nga ginatukoy ng propeta, ang iya kaugalingon o ang iban nga tawo?” ");
INSERT INTO rol_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Nganì, tunà sa adto nga parte ng Kasulatan nga gingsulat ni Isaias, ging-isplikar ni Felipe ang Maayong Balità parti kay Hesus. ");
INSERT INTO rol_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Mintras nagabyahe sinda, nakaagi sinda sa lugar nga may tubì. Naghambay ang opisyal, “May tubì diri! Ano pa ang makakapugong sa akon para magpabawtismo?” ");
INSERT INTO rol_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Kag nagsabat si Felipe, “Puydi ka na magpabawtismo kung nagatuo ka gid ning hugot sa imo tagipusuon.” Kag nagsabat siya, “Huo, nagatuo ako nga si Hesu-Kristo ang Ungà ng Dios.” ");
INSERT INTO rol_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Nganì gingpaduyog ng opisyal ang karwahe. Naglusong si Felipe kag ang opisyal sa sapà kag gingbawtismuhan siya. ");
INSERT INTO rol_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Paghaw-as ninda sa tubì, gingbuoy si Felipe ng Espiritu ng Ginoo. Ang opisyal naman hay nalipay gid nga nagpadayon sa iya byahe, aber wayà na niya makità si Felipe. ");
INSERT INTO rol_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pero namangnuhan na lang ni Felipe nga yadto na siya sa Azotus. Nagwali siya ng Maayong Balità sa mga banwa nga iya ginaagihan hasta nakaabot siya sa Cesarea. ");
INSERT INTO rol_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Padayon pa gid ang pagpamahog ni Saulo sa mga nagatuo sa Ginoo nga patyon niya sinda. Nagkadto pa siya sa Pinakamataas nga Parì ");
INSERT INTO rol_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","kag nagpangayò ning mga sulat nga magatao sa iya ning otoridad kag magapakilaya sa iya sa mga sinagoga sa Damascus. Ini hay para kung may makità siya nga mga nagasunod ng Pamaagi nga ginatudlò ni Hesus, mapalyaki man o mapababayi, puydi sinda dakpon kag day-on pabalik sa Jerusalem. ");
INSERT INTO rol_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Nang malapit na si Saulo sa syudad ng Damascus, may kahayag nga halin sa langit nga gulpi lang nagsiga palibot sa iya. ");
INSERT INTO rol_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Natumba siya sa dutà kag nabatian niya ang boses nga nagahambay sa iya, “Saulo, Saulo, basì ginahingabot mo ako?” ");
INSERT INTO rol_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Nagpangutana siya, “Ginoo, sin-o ka?” Kag nabatian niya ang boses, “Ako si Hesus nga imo ginahingabot. ");
INSERT INTO rol_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Tindog kag kumadto ka sa syudad, kay didto may mahambay sa imo kung ano ang dapat mo nga humanon.” ");
INSERT INTO rol_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Wayà gid ning may nakahambay sa mga kaibahan niya kay nabatian ninda ang boses, pero wayà gid sinda may nakità. ");
INSERT INTO rol_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Nagtindog si Saulo, pero pagmukyat niya indì na siya makakità. Nganì ging-agbay na lang siya ng iya mga kaibahan hasta sa Damascus. ");
INSERT INTO rol_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Sa suyod ng tuyo ka adlaw indì gid siya makakità kag wayà siya magkaon o mag-inom. ");
INSERT INTO rol_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Didto sa Damascus, igwa ning nagatuo kay Hesus nga ang pangayan hay Ananias. Paagi sa panan-awon, naghambay ang Ginoo, “Ananias.” Nagsabat siya, “Ginoo, yari ako.” ");
INSERT INTO rol_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Naghambay ang Ginoo sa iya, “Kadto sa dayan nga ginatawag, Matadlong kag didto sa bayay ni Judas, sugiron mo ang tawo nga taga-Tarsus nga ang iya pangayan hay Saulo. Kay ini nga oras, nagapangamuyò siya ");
INSERT INTO rol_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","kag gingpakità ko na sa iya paagi sa panan-awon nga ikaw hay nagsuyod kag nagtungtong ng imo mga kamot sa iya para makakità siya liwat.” ");
INSERT INTO rol_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Pero nagsabat si Ananias, “Ginoo, kadamò na ako ning nabatian parti sa ini nga tawo. Kapintas kuno siya sa imo mga balaan nga tawo sa Jerusalem. ");
INSERT INTO rol_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Nagkari siya diri sa Damascus nga may otoridad halin sa Pinakamataas nga Parì para dakpon ang tanan nga nagasamba sa imo.” ");
INSERT INTO rol_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Pero naghambay ang Ginoo kay Ananias, “Kadto na kay gingpilì ko siya nga magserbisyo sa akon, para ipakilaya ang akon pangayan sa mga bukon Judio kag sa inda mga harì kag sa mga Israelita. ");
INSERT INTO rol_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Kag ipakità ko da sa iya ang mga kahugaan nga dapat niya maagihan tungod sa iya pagserbisyo sa akon.” ");
INSERT INTO rol_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Nganì gingkadtuan ni Ananias si Saulo sa bayay nga iya ginadayunan. Pagsuyod niya, gingtungtong niya ang iya mga kamot kay Saulo kag naghambay, “Saulo, utod ko, gingsugò ako ni Ginoong Hesus diri sa imo. Siya ang nagpakità sa imo sa dayan nang nagapakari ka diri. Gingsugò niya ako para makakità ka liwat kag para mapunò ka ng Espiritu Santo.” ");
INSERT INTO rol_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Kag adto nga daan may nahuyog nga pareho sa mga himbis ng isdà halin sa mga mata ni Saulo kag nakakità na siya liwat. Pagkatapos nagtindog siya kag nagpabawtismo. ");
INSERT INTO rol_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Nagkaon siya kag nagkusog liwat ang iya lawas. Nagtinir si Saulo ning mga pila ka adlaw sa Damascus kaibahan ang mga nagatuo. ");
INSERT INTO rol_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Nagkadto siya sa mga sinagoga kag nagtunà magwali parti kay Hesus. Hambay niya, “Siya ang Ungà ng Dios.” ");
INSERT INTO rol_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Natingaya gid ang tanan nga nakabatì sa iya kag naghambay, “Dì ba ini nga lyaki imaw ang nagapamatay sa mga nagatuo kay Hesus sa Jerusalem? Kag dì ba nagkari siya para dakpon ang mga nagatuo kag day-on sa mga pinunò nga parì?” ");
INSERT INTO rol_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Nagdugang pa gid ang gahom ni Saulo para magwali. Gingpamatuuran niya nga si Hesus imaw ang Kristo. Kag indì makasabat sa iya ang mga Judio nga nagaistar sa Damascus. ");
INSERT INTO rol_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Pagkaligad ng mga pila ka adlaw, nagtipon ang mga Judio para magplano nga patyon si Saulo. ");
INSERT INTO rol_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Pero nasayuran ni Saulo ang inda plano. Adlaw-gab-i nagabantay sinda sa mga pwertahan ng syudad kay patyon ninda siya kung inda makità. ");
INSERT INTO rol_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Nganì pagkagab-i, gingsuyod siya ng iya mga disipulo sa bangkat* kag gingtunton paluwas, paagi sa bintanà ng pader ng syudad. ");
INSERT INTO rol_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Pag-abot ni Saulo sa Jerusalem, gingtinguhà niya nga makaibahan sa grupo ng mga nagatuo didto. Pero nahadlok sinda sa iya kay indì sinda magpati nga nagatuo na siya kay Hesus. ");
INSERT INTO rol_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Pero gingbuligan siya ni Bernabe kag gingdaya sa mga apostoles. Ging-isplikar niya sa inda kung pauno nakità ni Saulo ang Ginoo sa dayan kag kung ano ang ginghambay sa iya. Kag ging-istorya da niya kung pauno nagwali si Saulo nga may kaisog sa pangayan ni Hesus sa Damascus. ");
INSERT INTO rol_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Nganì tunà adto nakaibahan na ninda si Saulo kag nagtiyog sinda sa bilog nga Jerusalem nga nagawali ng may kaisog parti sa Ginoo. ");
INSERT INTO rol_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Nagpakig-istorya siya kag nagpakigdibati sa mga Judio nga ang linggwahe hay Griego, pero nahangit sinda kag gingplanuhan siya nga patyon. ");
INSERT INTO rol_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Nang masayuran ini ng mga nagatuo, ginghatod ninda si Saulo sa Cesarea kag gingpabalik sa Tarsus. ");
INSERT INTO rol_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Pagkatapos adto, ang mga nagatuo sa bilog nga Judea, Galilea kag Samaria hay nagkaigwa na ning katawhayan* kag nagtibay pa gid ang inda pagtuo. Nagkabuhì sinda nga may kahadlok sa Ginoo kag sa bulig ng Espiritu Santo hay nagpakadamò pa gid sinda. ");
INSERT INTO rol_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Nagkadto si Pedro sa iba-iba nga lugar para magbisita sa mga balaan nga tawo ng Dios. Nagkadto da siya sa Lyda. ");
INSERT INTO rol_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Didto nakità niya ang isa ka tawo nga ang pangayan hay Eneas. Paralisado siya kag wayà gid nakakabangon sa suyod ng wayo ka tuig. ");
INSERT INTO rol_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Naghambay si Pedro sa iya, “Eneas, ging-ayo ka na ni Hesu-Kristo. Bangon na kag lukuta ang imo higdaan!” Kag adto nga daan nagbangon siya. ");
INSERT INTO rol_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Nakità ng tanan nga taga-Lyda kag taga-Sharon nga maayo na si Eneas nganì nagtuo da sinda sa Ginoo. ");
INSERT INTO rol_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Sa Jopa igwa ning nagatuo nga babayi nga ang pangayan hay Tabita. (Sa Griego ini hay Dorcas.) Ini nga babayi kadamò ang iya ginghuman nga maayo. Mabinuligon gid siya sa mga pobre. ");
INSERT INTO rol_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Nang adto nga tyempo, nagmasakit siya kag namatay. Gingpaligusan ninda ang iya lawas kag gingbutang sa kwarto sa ibabaw. ");
INSERT INTO rol_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Bukon malayò ang Jopa sa Lyda. Nganì nang mabatian ng mga nagatuo nga yadto si Pedro sa Lyda, gingpakadto ninda ang duha ka tawo kay Pedro para magpangabay, “Kung puydi, magkari ka diri sa amon nga daan.” ");
INSERT INTO rol_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Nganì nagnunot si Pedro sa inda kag pag-abot niya didto, gingdaya siya sa kwarto kung sa diin yadto ang patay. Yadto da ang mga bayo sa kwarto nga nagatinangis. Gingpakità ninda kay Pedro ang iba-iba nga barò nga gingtahì ni Dorcas nang buhì pa siya. ");
INSERT INTO rol_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Gingpaluwas anay sinda tanan ni Pedro bago siya nagpangamuyò. Pagkatapos nag-atubang siya sa patay kag naghambay, “Tabita, bangon na.” Nagmukyat si Tabita kag nang makità niya si Pedro, nagpungkò siya. ");
INSERT INTO rol_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ginghawiran ni Pedro ang iya kamot kag gingbuligan nga magtindog. Pagkatapos gingtawag ni Pedro ang tanan nga balaan nga tawo ng Dios patì ang inda kaibahan nga mga bayo didto kag gingpakità sa inda si Tabita nga buhì na. ");
INSERT INTO rol_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Nabantog ini sa bilog nga Jopa kag kadamò pa gid ang nagtuo sa Ginoo. ");
INSERT INTO rol_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Nagtinir pa si Pedro ning mga pila ka adlaw sa Jopa sa bayay ni Simon nga miyugbuyad ning panit ng hayop. ");
INSERT INTO rol_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Didto sa Cesarea, igwa ning isa ka tawo nga ang pangayan hay Cornelius. Siya hay kapitan ng mga sundalo ng Romano nga ginatawag, Batalyon ng mga taga-Italia. ");
INSERT INTO rol_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Diosnanon siya kag ang bilog niya nga panimayay kag sinda hay permi nagasamba. Maatag siya sa mga pobre nga Judio kag permi gid siya nagapangamuyò sa Dios. ");
INSERT INTO rol_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Isa ka adlaw nang mga alas tres ng hapon, klaro gid ang iya panan-awon nga isa ka anghel ng Dios ang nagsuyod sa iya bayay kag gingtawag siya, “Cornelius.” ");
INSERT INTO rol_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Pagkakità niya sa anghel hinadlukan siya kag naghambay, “Ano ang imo kahinangyan, Ginoo?” Nagsabat ang anghel, “Gingpamatian ng Dios ang imo pangamuyò kag nalipay gid siya sa imo pagbulig sa mga pobre. Nganì wayà ka gid gingkalimuti ng Dios. ");
INSERT INTO rol_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Kag arinyan pakadtua ang pila ka tawo sa Jopa kag ipasugat mo si Simon nga ginatawag nga Pedro. ");
INSERT INTO rol_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Didto siya nagadayon kay Simon nga miyugbuyad ning panit ng hayop. Ang iya bayay yadto sa alihid ng dagat.” ");
INSERT INTO rol_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Nang makahalin na ang anghel nga iya kaistorya, gingtawag niya ang duha sa iya mga kabulig kag ang diosnanon nga sundalo nga nagaserbisyo sa iya. ");
INSERT INTO rol_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ging-istorya niya ang natabò kag gingpakadto sinda sa Jopa. ");
INSERT INTO rol_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Nang masunod nga adlaw mga alas dose ng hapon, mintras malapit na sinda sa Jopa, nagsakà si Pedro sa pantay nga bubong ng bayay nga iya ginadayunan para magpangamuyò. ");
INSERT INTO rol_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ginagutom na siya kag gusto niya magkaon. Kag mintras ginapreparar ang pagkaon, may gingpakità sa iya ang Dios. ");
INSERT INTO rol_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Nakità niya nga nagbukas ang langit kag may ginatunton nga daw haboy nga malapad kag may higot sa upat nga kanto. ");
INSERT INTO rol_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Kag sa ini nga haboy nakità niya ang tanan nga klasi ng mga hayop. May mga nagapanaw, nagakamang kag nagalupad. ");
INSERT INTO rol_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Tapos may nabatian siya nga boses nga naghambay, “Pedro, tindog! Mag-ihaw ka kag kumaon!” ");
INSERT INTO rol_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pero nagsabat si Pedro, “Ginoo, indì puydi kay wayà gid ako nagakaon ning mga hayop nga tiyad inà nga mahigkò kag ginabawal nga kaunon.” ");
INSERT INTO rol_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Nabatian niya liwat ang boses nga nagahambay, “Ayaw pagtawaga nga mahigkò ang aber ano nga butang nga ginglimpyo na ng Dios.” ");
INSERT INTO rol_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Tuyo ka beses ini natabò kag pagkatapos gulpi ini nga nabatak palangit. ");
INSERT INTO rol_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Mintras ginainisip pa ni Pedro kung ano ang gusto hambayon ng iya panan-awon, nag-abot ang tuyo ka tawo nga gingsugò ni Cornelius. Kay natundugan na ninda ang bayay ni Simon nganì nagderitso sinda sa pwertahan ");
INSERT INTO rol_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","kag nagpanawag. Nagpangutana sinda kung didto nagadayon si Simon nga ginatawag nga Pedro. ");
INSERT INTO rol_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Mintras ginahunahunà pa ni Pedro kung ano ang gusto hambayon ng iya panan-awon, naghambay ang Espiritu Santo sa iya, “Pamatì! May tuyo ka tawo nga nagapangità sa imo. ");
INSERT INTO rol_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Panaog kag magnunot ka sa inda nga wayà ning pangduha-duha, kay ako ang nagsugò sa inda.” ");
INSERT INTO rol_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Nganì nagpanaog si Pedro kag naghambay sa mga tawo, “Ako ang indo ginapangità. Basì kamo nagkari?” ");
INSERT INTO rol_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Nagsabat sinda, “Gingpakari kami diri ni Cornelius nga kapitan ng mga sundalo. Maayo siya nga tawo kag diosnanon. Ginatahod siya ng tanan nga Judio. Naghambay sa iya ang anghel ng Dios nga sugaton ka kag day-on sa iya bayay para mabatian kung ano ang imo ihambay.” ");
INSERT INTO rol_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Nganì gingpadayon sinda ni Pedro kag didto sinda gingpatuyog. Nang masunod nga adlaw, pagkabatì ni Pedro, nagnunot siya sa inda. May pila da nga mga nagatuo sa Jopa ang nagnunot sa iya. ");
INSERT INTO rol_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Nang masunod nga adlaw, nag-abot sinda sa Cesarea. Nagahuyat sa inda si Cornelius kag ang iya mga kahalihan kag ang iya mga malapit nga amigo nga iya gingpang-agda. ");
INSERT INTO rol_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Nang pasuyuron si Pedro sa bayay, gingsugat siya ni Cornelius kag naghapà para sambahon. ");
INSERT INTO rol_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pero gingpatindog siya ni Pedro kag ginghambayan, “Pagtindog, kay tawo lang da ako.” ");
INSERT INTO rol_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Mintras nagairgo sinda pasuyod sa bayay, nakità ni Pedro nga kadamò na ang tawo nga nagakatipon didto. ");
INSERT INTO rol_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Naghambay si Pedro sa inda, “Sayod na nindo nga bawal gid sa amon nga mga Judio ang magbisita o magkaibahan sa mga bukon Judio. Pero gingpakità na sa akon ng Dios nga indì ko dapat pagkabigon nga mahigkò ang aber sin-o nga tawo kag indì pagbawalan ang pagkaibahan sa inda. ");
INSERT INTO rol_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Nganì nang gingpasugat nindo ako nga magkari diri, wayà ako nagpaindì. Pangutan-on ko na lang kamo kung basì gingpakari nindo ako diri?” ");
INSERT INTO rol_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Nagsabat si Cornelius, “Tuyo na ka adlaw ang nagligad mintras nagapangamuyò ako sa bayay ng mga tiyad ini nga oras, alas tres ng hapon. Gulpi nga nagpakità sa akon ang isa ka lyaki nga nakabarò ning masilaw kag nagtindog sa akon atubangan. ");
INSERT INTO rol_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Hambay niya, ‘Cornelius! Gingpamatian ng Dios ang imo pangamuyò kag ginadumdom niya ang imo pagbulig sa mga pobre. ");
INSERT INTO rol_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Nganì niyan, magsugò ka ning tawo pakadto sa Jopa kag ipasugat si Simon nga ginatawag, Pedro. Didto siya nagadayon sa bayay ni Simon nga miyugbuyad ning panit ng hayop. Nagaistar siya sa alihid ng dagat.’ ");
INSERT INTO rol_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Nganì gingpasugat ko ikaw nga daan. Salamat gid kay nagkari ka. Niyan, yari na kami tanan sa presensya ng Dios para magpamatì kung ano ang gingsugò ng Ginoo nga ihambay mo sa amon.” ");
INSERT INTO rol_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Nganì naghambay si Pedro, “Niyan, sayod ko nga matuod gid nga wayà ning may ginapalabi ang Dios. ");
INSERT INTO rol_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Kung ang tawo hay may kahadlok sa Dios kag tamà ang ginahuman, ginabaton niya aber ano ang iya lahì. ");
INSERT INTO rol_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Sayod nindo ang Maayong Balità nga gingpaabot niya sa amon nga mga Israelita hay imaw ini: ang mga tawo hay magkaigwa ning tamà nga relasyon sa Dios paagi sa pagtuo kay Hesu-Kristo. Siya ang Ginoo ng tanan. ");
INSERT INTO rol_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Sayod da nindo ang natabò sa bilog nga Judea parti kay Hesus, magtunà sa Galilea pagkatapos ng pagwali ni Juan parti sa pagbawtismo. ");
INSERT INTO rol_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Gingtaw-an ng Dios si Hesus nga taga-Nazaret ng Espiritu Santo kag gahom. Pagkatapos nagkadto siya sa iba-iba nga lugar kag tungod kaibahan niya ang Dios nakahuman siya ning kaayuhan kag nagpaayo ng tanan nga gingpahugaan ng diyablo. ");
INSERT INTO rol_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Kami gid ang makakapamatuod sa tanan nga iya ginghuman kay nakità namon ini sa Jerusalem kag sa iban nga mga banwa ng Judio. Pagkatapos gingpapatay siya ng mga miyugdumaya ng Judio sa Jerusalem paagi sa paglangsang sa krus. ");
INSERT INTO rol_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Pero gingbanhaw siya ng Dios sa ikatuyo ka adlaw kag gingtugutan siya nga magpakità sa amon. ");
INSERT INTO rol_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Wayà siya nagpakità sa tanan kundì sa amon lang nga mga gingpilì ng Dios nga mga saksi para ibalità sa iban ang parti sa iya. Nagkaon kag nag-inom kami kaibahan niya pagkatapos nga siya hay nabanhaw. ");
INSERT INTO rol_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Gingsugò niya kami para magwali sa mga tawo kag para pamatuuran nga siya ang gingpilì ng Dios nga maging hukom sa mga buhì kag sa mga patay. ");
INSERT INTO rol_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Si Hesu-Kristo imaw ang ginghambay ng tanan nga mga propeta nga ang tanan nga nagatuo sa iya hay patawaron sa inda mga kasal-anan paagi sa iya pangayan.” ");
INSERT INTO rol_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Mintras nagawali pa si Pedro, nag-abot ang Espiritu Santo sa tanan nga nagapamatì ng iya mensahe. ");
INSERT INTO rol_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ang mga nagatuo nga Judio nga nagnunot kay Pedro halin sa Jopa hay natingaya kay gingtao ng Dios ang iya regalo nga Espiritu Santo aber sa mga bukon Judio. ");
INSERT INTO rol_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Kay inda nabatian nga sinda hay nagahambay sa iba-iba nga linggwahe nga wayà ninda nasayuri kag nagadayaw sa Dios. Tapos naghambay si Pedro, ");
INSERT INTO rol_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Nakabaton na ini nga mga tawo ning Espiritu Santo pareho naton aber bukon sinda Judio. Nganì wayà na may makakapugong sa inda para sinda hay bawtismuhan sa tubì.” ");
INSERT INTO rol_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Kag nagsugò siya sa inda nga magpabawtismo sa pangayan ni Hesu-Kristo. Pagkatapos adto, gingpangabay ninda si Pedro nga magtinir anay sa inda ning pila ka adlaw. ");
INSERT INTO rol_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Nabatian ng mga apostoles kag mga nagatuo sa Judea nga ang mga bukon Judio* hay nagbaton na da sa hambay ng Dios. ");
INSERT INTO rol_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Nganì pagbalik ni Pedro sa Jerusalem, ginghambayan siya ng mga nagatuo nga mga Judio nga istrikto sa pagsunod sa inda patakaran. ");
INSERT INTO rol_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Hambay ninda, “Basì nagkadto ka didto kag nagkaon pa sa bayay ng mga bukon Judio nga bukon paltak?” ");
INSERT INTO rol_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Nganì ging-isplikar ni Pedro sa inda ang tanan nga natabò sa iya. ");
INSERT INTO rol_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Hambay niya, “Mintras nagapangamuyò ako sa syudad ng Jopa, may panan-awon nga gingpakità sa akon ang Dios. Nakità ko ang daw sa malapad nga haboy nga ginatunton halin sa langit. Nahigutan ini sa upat ka kanto kag gingduyog malapit sa akon. ");
INSERT INTO rol_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nang gingsirò ko ini ning maayo, nakità ko nga ang suyod iba-iba nga klasi ng mga hayop nga mga mapintas, may nagakamang kag may nagalupad. ");
INSERT INTO rol_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Kag may nabatian ako nga boses nga nagahambay, ‘Pedro, tindog! Mag-ihaw ka kag kumaon!’ ");
INSERT INTO rol_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Pero nagsabat ako, ‘Ginoo, indì ko ini mahuman kay wayà pa gid ako nakakaon ning mga hayop nga mahigkò kag ginabawal nga kaunon.’ ");
INSERT INTO rol_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Pagkatapos nabatian ko liwat adto nga boses halin sa langit, ‘Ayaw pagtawaga nga mahigkò ang aber ano nga ginglimpyo na ng Dios.’ ");
INSERT INTO rol_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Tuyo ka beses ini nga natabò kag pagkatapos gingbatak adto palangit. ");
INSERT INTO rol_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Adto da nga oras, may tuyo ka tawo halin sa Cesarea nga nag-abot sa bayay nga akon ginadayunan. Sinda hay gingsugò para pangitaon ako. ");
INSERT INTO rol_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Naghambay sa akon ang Espiritu Santo nga magnunot sa inda nga wayà ning pangduha-duha. May unom nga mga kauturan nga nagnunot sa akon pakadto sa bayay ni Cornelius sa Cesarea. ");
INSERT INTO rol_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Pag-abot namon didto ging-istorya niya sa amon kung pauno niya nakità ang isa ka anghel nga nagatindog sa iya bayay kag naghambay sa iya, ‘Magsugò ka ning tawo pakadto sa Jopa para sugaton si Simon nga ginatawag, Pedro. ");
INSERT INTO rol_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Mahambay siya sa imo kung pauno ikaw maluwas patì ang imo bilog nga panimayay.’ ");
INSERT INTO rol_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Kag nang nagahambay na ako, nag-abot ang Espiritu Santo sa inda pareho ng pag-abot niya sa aton nang una. ");
INSERT INTO rol_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Kag nadumduman ko ang ginghambay ng Ginoo, ‘Nagbawtismo si Juan sa tubì, pero pagabawtismuhan kamo sa Espiritu Santo.’ ");
INSERT INTO rol_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Gingtaw-an ng Dios ang mga bukon Judio ning regalo nga pareho sa gingtao niya sa aton nang nagtuo kita kay Ginoong Hesu-Kristo. Nganì kung imaw ini ang kabubut-on ng Dios, sin-o ako para magpugong sa iya!” ");
INSERT INTO rol_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Nang mabatian ninda ini, wayà na sinda ning may ginghambay pa nga kontra kay Pedro, kundì gingdayaw ninda ang Dios. Naghambay sinda, “Gingtaw-an da ng Dios ang mga bukon Judio ning tsansa nga maghinuysoy sa inda salà para magkaigwa sinda ning kabuhì nga wayà katapusan!” ");
INSERT INTO rol_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Tunà ng mamatay si Esteban, nagkabuyag-buyag ang kadamuan nga mga nagatuo tungod sa paghingabot. May nagkadto sa Fenicia kag ang iban sa Cyprus kag ang iban pa hay sa Antioc. Gingwali ninda ang Maayong Balità aber diin sinda magkadto, pero sa mga Judio lang. ");
INSERT INTO rol_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Pero may mga iban sa inda nga taga-Cyprus kag taga-Cyrene nga nagkadto sa Antioc para magwali ng Maayong Balità parti kay Ginoong Hesus sa mga bukon Judio. ");
INSERT INTO rol_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Yarà sa inda ang gahom ng Dios, nganì kadamò gid ang nagtuo sa Ginoo kag nagtalikod sa inda salà. ");
INSERT INTO rol_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ini nga natabò hay nasayuran ng mga nagatuo sa Jerusalem, nganì gingpakadto ninda si Bernabe sa Antioc. ");
INSERT INTO rol_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Pag-abot niya didto, nalipay siya kay nakità niya ang mga pagpakamaayo ng Dios sa mga tawo. Kag gingtudluan niya sinda nga maging matutom gid sa Ginoo kag magpadayon sa pagsunod sa Dios. ");
INSERT INTO rol_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Maayo gid nga tawo si Bernabe kag punò siya ng Espiritu Santo kag hugot gid ang iya pagtuo sa Dios. Nganì kadamò didto ang nagtuo sa Ginoo. ");
INSERT INTO rol_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Pagkatapos nagkadto si Bernabe sa Tarsus para sugiron si Saulo ");
INSERT INTO rol_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","kag nang nakità na siya, gingdaya niya pabalik sa Antioc. Isa gid ka tuig nga nakaibahan ninda ang mga nagatuo didto kag kadamò nga tawo ang inda gingtudluan. Ang mga nagatuo sa Antioc imaw ang una nga gingtawag nga Kristyano. ");
INSERT INTO rol_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Nang adto nga tyempo, may mga propeta* nga nagkadto sa Antioc halin sa Jerusalem. ");
INSERT INTO rol_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ang isa sa inda hay si Agabus. Nagtindog siya kag paagi sa gahom ng Espiritu Santo nagpropesiya siya nga may paabuton nga sobra nga taggutom sa bilog nga kalibutan. Natabò ini sa tyempo nang nagharì si Emperador Claudius sa Roma. ");
INSERT INTO rol_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Nganì nagkaisa ang mga nagatuo nga magpadaya ang kada isa ning bulig kumpormi sa inda kaya didto sa inda mga kauturan nga taga-Judea. ");
INSERT INTO rol_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Gingpadaya ninda ini kay Bernabe kag kay Saulo para itao sa mga miyugdumaya ng mga nagatuo sa Jerusalem. ");
INSERT INTO rol_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Nang adto nga tyempo, nagtunà si Haring Herodes sa paghingabot sa pila ka tawo nga mga nagatuo. ");
INSERT INTO rol_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Gingpapatay niya si Santiago, nga hali ni Juan paagi sa espada. ");
INSERT INTO rol_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Nang makità niya nga nalipay ang mga Judio sa iya ginghuman, si Pedro naman ang masunod niya nga gingpadakop. (Ini hay natabò ng Pyesta ng Tinapay nga wayà ning Pampaalsa*.) ");
INSERT INTO rol_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pagkatapos gingpapriso niya si Pedro kag gingpagwardyahan sa upat ka grupo ng mga sundalo nga tig-upat-upat. Ang plano ni Herodes hay bistahon si Pedro kag sentensyahan nga patyon sa publiko pagkatapos ng Pyesta ng Pagligad ng Anghel*. ");
INSERT INTO rol_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Mintras yadto sa prisuhan si Pedro, padayon nga nagpangamuyò ning hugot sa tagipusuon ang mga nagatuo para sa iya. ");
INSERT INTO rol_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Nang adto gid nga gab-i bago ipaatubang ni Herodes si Pedro sa mga tawo, nagakatuyog siya nga nakagapos ning duha ka kadina sa tungà ng duha ka sundalo. Kag may mga gwardya pa nga nagabantay sa pwertahan ng prisuhan. ");
INSERT INTO rol_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Gulpi nga nagpakità ang isa ka anghel ng Ginoo kag naghayag sa suyod ng selda. Gingyugoyugò niya si Pedro para pukawon nga ang hambay, “Dalì! Bangon dirà!” Kag natangsò ang mga kadina sa iya mga kamot. ");
INSERT INTO rol_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Kag naghambay pa ang anghel, “Paghagkos na kag suksukan ang imo sandalyas.” Kag gingsunod niya ini. Pagkatapos hambay pa gid ng anghel, “Suksukan ang imo pangsuy-ob kag sunod sa akon.” ");
INSERT INTO rol_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Kag nagsunod si Pedro sa iya paluwas ng prisuhan, aber wayà siya nakasayod kung matuod ba ini ang nagakatabò. Ang kalaom niya hay nakakità lang siya ning panan-awon. ");
INSERT INTO rol_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Nang makalampas na sinda sa una kag pangaduha nga gwardya, nakaabot sinda sa pwertahan nga saysayon nga nagaatubang sa syudad. Nag-abri ini ng iya lang kag nagluwas sinda. Nang nagapanaw sinda sa isa ka dayan, gulpi lang nga gingbayaan si Pedro ng anghel. ");
INSERT INTO rol_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Kag didto lang namangnuhan ni Pedro nga matuod galì ang tanan nga natabò sa iya kag naghambay siya, “Arinyan sigurado na gid ako nga ang Ginoo hay nagpadaya ng iya anghel para luwason ako sa kamot ni Herodes kag sa tanan nga ginapaabot ng mga Judio nga matabò sa akon.” ");
INSERT INTO rol_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Nang naintindihan na niya nga nakaluwas na siya, nagkadto siya sa bayay ni Maria nga nanay ni Juan nga ginatawag da nga Marcos. Kadamò nga tawo ang nagakatipon didto kag nagapangamuyò. ");
INSERT INTO rol_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Nagpanuktok si Pedro sa pwertahan nganì nagpalapit ang ulipon nga si Roda para magsirò kung sin-o ang nagapanuktok. ");
INSERT INTO rol_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Nakilaya niya ang boses ni Pedro kag sa iya kalipay, imbis nga abrihan niya ang pwertahan, nagdyagan siya pasuyod para ipasayod sa iya mga kaibahan nga si Pedro yarà sa luwas. ");
INSERT INTO rol_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Naghambay sinda sa iya, “Nagapinabuang ka lang!” Pero nagpilit gid si Roda nga matuod ang iya ginahambay. Nganì nagsabat sinda, “Basì kung anghel inà ni Pedro.” ");
INSERT INTO rol_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pero sige pa gid ang pagpanuktok ni Pedro kag nang ging-abrihan na ninda ang pwertahan, nakità ninda siya kag natingaya gid sinda! ");
INSERT INTO rol_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Gingsinyasan niya sinda nga maghipos kag ging-isplikar niya sa inda kung pauno siya gingpaluwas ng Ginoo sa prisuhan. Kag hambay pa niya, “Balitaan ini kay Santiago kag sa iban pa nga mga nagatuo.” Tapos naghalin siya kag nagkadto sa iban nga lugar. ");
INSERT INTO rol_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Pagkaaga, nagkinagulo gid ang mga sundalo kay wayà na si Pedro kag wayà sinda nakasayod kung ano ang natabò sa iya. ");
INSERT INTO rol_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Nagsugò si Herodes nga sugiron siya, pero wayà gid ninda siya makità. Nganì ging-imbistigahan niya ang mga sundalo kag pagkatapos gingpapatay niya sinda. Pagkatapos adto, naghalin si Herodes sa Judea kag nagkadto sa Cesarea kag didto nagtinir. ");
INSERT INTO rol_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Sobra gid ang kahangit ni Haring Herodes sa mga taga-Tyre kag taga-Sidon. Nganì may mga grupo halin sa inda nga nagkadto sa harì. Ging-amigo anay ninda si Blastus, isa sa mga importante nga opisyal ng harì, para buligan niya sinda. Tapos nagkadto sinda kay Herodes para magpakighusay, kay didto sa lugar ng harì sinda nagabuoy ng inda pagkaon. ");
INSERT INTO rol_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Pag-abot ng adlaw nga gingpilì niya nga magpakigkità sa mga taga-Tyre kag taga-Sidon, nagsuksok siya ng iya barò nga pangharì kag nagpungkò sa trono kag nagdiskurso ng iya mensahe. ");
INSERT INTO rol_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Nagsinggit ang mga tawo, “Ang nagahambay ini hay bukon tawo kundì dios!” ");
INSERT INTO rol_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Adto nga daan gingparusahan siya ng anghel ng Ginoo kay wayà niya gingtao ang pagdayaw para sa Dios. Ging-uyod siya hasta sa mamatay. ");
INSERT INTO rol_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Pero padayon nga naglapnag ang hambay ng Dios kag nagdamò pa gid ang mga nagatuo. ");
INSERT INTO rol_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Nang natapos na nina Bernabe kag Saulo ang gingpanghuman ninda didto sa Jerusalem, nagbalik sinda sa Antioc. Gingdaya da ninda si Juan nga ginatawag da nga Marcos. ");
INSERT INTO rol_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Sa Antioc hay may mga propeta kag mga manunudlò nga miyembro ng kongregasyon didto. Imaw ini ang inda pangayan: sina Bernabe, Simeon nga ang hayò hay Negro, Lucio nga taga-Cyrene, Manaen nga nagbahoy sa panimayay ni Gobernador Herodes kag si Saulo. ");
INSERT INTO rol_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Mintras nagasamba sinda sa Ginoo kag nagapuasa, naghambay ang Espiritu Santo sa inda, “Laina nindo para sa akon sina Bernabe kag Saulo kay may ipahuman ako sa inda.” ");
INSERT INTO rol_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Pagkatapos ng inda pagpuasa kag pagpangamuyò, gingtungtong ninda ang inda mga kamot kana Bernabe kag Saulo kag pagkatapos gingpapanaw na sinda. ");
INSERT INTO rol_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Nganì nagkadto sina Bernabe kag Saulo sa Seleucia kumpormi sa ginasugò ng Espiritu Santo. Halin didto naglarga sinda pakadto sa isla ng Cyprus. ");
INSERT INTO rol_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Pag-abot ninda sa Salamis, nagwali sinda ng hambay ng Dios sa mga sinagoga*. Kaibahan ninda si Juan Marcos para magbulig sa inda. ");
INSERT INTO rol_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Gingtiyog ninda ang bilog nga isla hasta makaabot sinda sa banwa ng Pafos. Nakità ninda didto ang isa ka madyikero nga si Bar-Hesus. Judio siya kag nagapakunukuno nga siya hay propeta. ");
INSERT INTO rol_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Amigo siya ni Sergius Paulus nga gobernador ng ini nga isla. Si Sergius Paulus hay kamayad nga tawo. Gingpatawag niya sina Bernabe kag Saulo kay gusto niya magpamatì ng hambay ng Dios. ");
INSERT INTO rol_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Pero gingkontra sinda ng madyikero nga si Elimas. (Ini ang pangayan ni Bar-Hesus sa linggwahe ng Griego.) Ginghuman niya ang tanan nga paagi para indì magtuo ang gobernador kay Hesus. ");
INSERT INTO rol_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Pero si Saulo nga kilaya da sa pangayan nga Pablo hay punò ng Espiritu Santo. Gingtutok gid niya si Elimas ");
INSERT INTO rol_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","kag naghambay, “Ungà ka ng Diyablo! Kaaway ka ng tanan nga mga matarong. Puro lang pandayà kag kalainan ang imo ginahuman! Ginabaliskad mo permi ang kamatuuran parti sa Ginoo! ");
INSERT INTO rol_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Arinyan pagaparusahan ka ng Ginoo. Mabubuta ka kag indì makakakità ning kahayag sa suyod ng pila ka adlaw.” Nagduyom nga daan ang panirò ni Elimas kag nabuta siya. Nagpanghaphap na lang siya nga nagapangità ng magaagbay sa iya. ");
INSERT INTO rol_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Nang makità ng gobernador ang natabò, nagtuo siya kay natingaya gid siya sa mga ginatudlò parti sa Ginoo. ");
INSERT INTO rol_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Naglarga si Pablo kag ang iya mga kaibahanan halin sa Pafos pakadto sa Perga nga syudad ng Pamfilia. Pag-abot ninda didto gingbayaan sinda ni Juan Marcos kag nagbalik siya sa Jerusalem. ");
INSERT INTO rol_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Pero nagpadayon sina Pablo halin sa Perga kag nagkadto sa Antioc nga sakop ng Pisidia. Pag-abot ng Adlaw nga Inugpahuway*, nagkadto sinda sa sinagoga kag nagpungkò didto. ");
INSERT INTO rol_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","May nagbasa ning Kasuguan ni Moises kag ng gingsulat ng mga propeta. Pagkatapos, may gingsugò ang pinunò ng sinagoga para maghambay kana Pablo, “Mga kauturan, kung igwa kamo ning gusto nga ihambay nga magapakusog ng buot ng mga tawo, ihambay na nindo.” ");
INSERT INTO rol_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Nganì nagtindog si Pablo kag gingsinyasan ang mga tawo nga magpamatì sa iya. Hambay niya, “Mga kapareho ko nga Israelita kag kamo tanan nga mga bukon Judio nga yari nagasamba da sa Dios, pamatii nindo ako. ");
INSERT INTO rol_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ang Dios ng mga Israelita imaw ang nagpilì sa aton mga kalulo-lulohan kag gingpadamò niya sinda nang yadto pa sinda nagaistar sa Egipto. Kag paagi sa iya dakò nga gahom gingbuligan niya sinda para makahalin didto. ");
INSERT INTO rol_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Mintras nagapanaw sinda sa tiway nga lugar, gingtiisan sinda ng Dios sa suyod ng 40 ka tuig. ");
INSERT INTO rol_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Pagkatapos gingpamatay niya ang pito ka mga lahì ng tawo sa lugar ng Canaan. Kag gingtao niya ang dutà sa aton mga kalulo-lulohan. ");
INSERT INTO rol_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ini tanan hay ginghuman ng Dios sa suyod ng 450 ka tuig. “Pagkatapos gingtaw-an niya sinda ning mga tawo nga magadumaya sa inda hasta sa tyempo ni Propeta Samuel. ");
INSERT INTO rol_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Niyan nagpangayò sinda ning harì kag gingtao sa inda ng Dios si Saulo nga ungà ni Kish, isa sa mga inapo ni Benjamin. Nagharì si Saulo sa inda sa suyod ng 40 ka tuig. ");
INSERT INTO rol_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Nang gingpahalin siya ng Dios, si David naman ang iya ging-ilis nga harì. Imaw ini ang hambay ng Dios parti sa iya: ‘Nalipay gid ako sa batasan ni David nga ungà ni Jesse kay nagatuman siya sa tanan ko nga ginapahuman sa iya.’ ” ");
INSERT INTO rol_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Kag naghambay pa gid si Pablo sa mga tawo, “Sa inapo ni David naghalin si Hesus nga imaw ang Manluluwas nga gingpromisa ng Dios sa Israel. ");
INSERT INTO rol_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Bago pa si Hesus nag-abot, nagwali si Juan sa tanan nga Israelita nga dapat maghinuysoy sinda sa inda salà kag magpabawtismo. ");
INSERT INTO rol_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Kag nang matatapos na ni Juan ang iya ministeryo, naghambay siya sa mga tawo, ‘Siguro nagahunahunà kamo nga ako imaw na ang indo ginapaabot. Pero bukon ako. May masunod sa akon kag indì nganì ako angay aber maging iya suluguon.’ ");
INSERT INTO rol_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Mga kauturan nga inapo ni Abraham kag tanan nga bukon Judio nga nagasamba sa Dios, kita imaw ang gingpaday-an ng Dios ng Maayong Balità parti sa kaluwasan. ");
INSERT INTO rol_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Pero ang mga tawo nga nagaistar sa Jerusalem kag ang inda mga pinunò wayà nagakilaya nga si Hesus ang Manluluwas. Wayà da sinda makaintindi ng ginahambay ng mga propeta nga ginabasa ninda kada Adlaw nga Inugpahuway. Pero sinda imaw gid ang nagpamatuod ng ginahambay ng mga propeta nang gingparusahan ninda si Hesus nga patyon. ");
INSERT INTO rol_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Kag aber wayà sinda may nakità nga rason para ipapatay siya, gingpangayò gihapon ninda kay Pilato nga ipapatay si Hesus. ");
INSERT INTO rol_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Nang mahuman na ninda ang tanan nga nakasulat sa Kasuguan nga matatabò kay Hesus, gingbuoy ninda siya sa krus kag gingbutang sa lubungan. ");
INSERT INTO rol_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Pero gingbanhaw siya ng Dios. ");
INSERT INTO rol_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Kag sa suyod ng kadamò nga adlaw, nagpakità siya sa mga tawo nga nagnunot sa iya halin sa Galilea pakadto sa Jerusalem kag ang mga tawo nga ini ang nagapamalità sa mga Israelita parti kay Hesus. ");
INSERT INTO rol_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Kag niyan yari kami para ipaabot sa indo ang Maayong Balità nga gingpromisa ng Dios sa aton mga kalulo-lulohan ");
INSERT INTO rol_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","nga gingtuman na niya sa aton nga inda mga inapo. Ginghuman niya ini nang gingbanhaw niya si Hesus. Imaw ini ang nakasulat sa pangaduha nga Salmo, ‘Ikaw ang akon Ungà; arinyan ipakità ko sa tanan nga ako ang imo Amay.’ ");
INSERT INTO rol_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Parti naman sa iya pagkabanhaw, indì na gid siya mamatay liwat kay naghambay ang Dios, ‘Itao ko gid sa indo ang kaayuhan nga gingpromisa ko kay David.’ ");
INSERT INTO rol_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Kag naghambay pa siya sa iban nga parte ng Salmo, ‘Indì ikaw magtugot nga malunot ang lawas ng imo matutom nga Suluguon.’ ");
INSERT INTO rol_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Bukon si David ang ginahambay diri kay pagkatapos ng iya pagserbisyo sa Dios nang iya tyempo, namatay siya kag ginglubong sa alihid ng iya mga kalulo-lulohan kag ang iya lawas hay nalunot. ");
INSERT INTO rol_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Pero si Hesus nga gingbanhaw ng Dios hay wayà gid nalunot ang lawas. ");
INSERT INTO rol_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Nganì mga kauturan ko, dapat nindo maintindihan ining amon ginapasayod sa indo nga paagi kay Hesus hay mapapatawad kita ng Dios sa aton mga salà. ");
INSERT INTO rol_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ang aber sin-o nga nagatuo kay Hesus hay ginakabig ng Dios nga matarong. Indì ini mahuman paagi sa pagtuman ng mga Kasuguan ni Moises. ");
INSERT INTO rol_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Nganì mag-andam kamo para indì matabò sa indo ang ginghambay ng mga propeta: ");
INSERT INTO rol_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Kamo nga mga nagahambay ning kontra sa akon! Matitingaya gid kamo kag mamamatay! Kay ang akon humanon arinyan hay indì gid nindo mapatihan, aber pa may mag-isplikar sa indo.’” ");
INSERT INTO rol_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Nang pahalinon na sina Pablo kag Bernabe sa sinagoga, nagpakitluoy ang mga tawo sa inda nga magbalik sa masunod nga Adlaw nga Inugpahuway para magtudlò pa gid parti sa ini nga mga butang. ");
INSERT INTO rol_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Nang maghalin na ang mga tawo sa inda pagtipon, gingsundan sina Pablo kag Bernabe ng kadamò nga Judio kag mga nagasamba sa Dios nga nagbaton sa relihiyon ng mga Judio. Ginghambayan sinda nina Pablo kag Bernabe kag ginglaygayan nga magpadayon sa pagsalig sa pagpakamaayo ng Dios. ");
INSERT INTO rol_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Nang masunod nga Adlaw nga Inugpahuway, hayos ang tanan nga taga-didto hay nagtipon para magpamatì ning hambay ng Dios. ");
INSERT INTO rol_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Pero nang makità ng mga Judio ang mga tawo, naili gid sinda kag gingkontra ang tanan nga ginahambay ni Pablo kag ging-insulto pa ninda siya. ");
INSERT INTO rol_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pero nagsabat sina Pablo kag Bernabe nga may kaisog. Naghambay sinda, “Kahinangyan gid nga iwali anay sa indo ang hambay ng Dios. Pero tungod ginasikway nindo ini, nagapakilaya nga bukon kamo angay nga magbaton ng kabuhì nga wayà katapusan. Nganì tunà niyan, sa mga bukon Judio na kami mawali ng Maayong Balità. ");
INSERT INTO rol_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Kay imaw ini ang sugò ng Ginoo sa amon: ‘Ginghuman ko ikaw nga daw iwag para sa mga bukon Judio, para paagi sa imo, ang kaluwasan magaabot gid sa bilog nga kalibutan.’” ");
INSERT INTO rol_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Nang mabatian ini ng mga bukon Judio, nalipay gid sinda kag gingdayaw ninda ang hambay ng Ginoo. Kag ang tanan nga gingpilì ng Dios para sa kabuhì nga wayà katapusan hay nagtuo. ");
INSERT INTO rol_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Kag naglapnag ang hambay ng Ginoo didto sa bilog nga lugar. ");
INSERT INTO rol_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Pero gingsuysugan ng iban nga mga Judio ang mga pinunò ng syudad patì ang kilaya nga mga babayi nga nagasamba sa Dios nga kontrahon sina Pablo kag Bernabe. Tapos ginghingabot sinda kag gingpalayas sa inda lugar. ");
INSERT INTO rol_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Nganì gingpagpag ng mga apostoles ang dapodapo sa inda siki para paandam sa inda. Pagkatapos nagpanaw sinda pakadto sa syudad ng Iconium. ");
INSERT INTO rol_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Kag ang mga nagatuo kay Hesus didto sa Antioc hay napunò ng Espiritu Santo kag nalipay gid sinda. ");
INSERT INTO rol_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ang natabò sa Iconium hay pareho da sa natabò sa Antioc. Nagkadto sina Pablo kag Bernabe sa sinagoga para magpasayod ng Maayong Balità. Maayo ang inda pagtudlò didto nganì kadamò ang nagtuo nga mga Judio kag mga Griego. ");
INSERT INTO rol_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Pero gingsuysugan ng mga wayà nagatuo nga mga Judio ang mga bukon Judio kag ginggulo ang inda hunahunà para kontrahon ang mga nagatuo. ");
INSERT INTO rol_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Nganì nadugay ang pagtinir didto nina Pablo kag Bernabe nga nagawali parti sa Ginoo nga wayà ning kahadlok. Gingpakità ng Ginoo nga matuod ang inda ginawali parti sa iya pagpakamaayo kay gingtaw-an niya sinda ning gahom nga makahuman ning mga milagro kag makatitingaya nga mga butang. ");
INSERT INTO rol_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Nganì ang mga tawo sa adto nga syudad hay natungà. May nag-apin sa mga Judio kag ang iban nag-apin sa mga apostoles. ");
INSERT INTO rol_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","May iban nga mga bukon Judio kag mga Judio, kaibahan ang inda mga pinunò nga nagplano nga sakiton kag buguyon ang mga apostoles. ");
INSERT INTO rol_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Nang masayuran ini ng mga apostoles, naglikaw sinda pakadto sa Lystra kag sa Derbe, mga syudad nga sakop ng Lycaonia kag sa palibot nga mga lugar. ");
INSERT INTO rol_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Kag didto, nagpadayon sinda sa pagwali ng Maayong Balità. ");
INSERT INTO rol_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Didto sa Lystra hay may isa ka tawo nga indì gid makapanaw kay lupog siya tunà pa nang siya hay ging-ungà. ");
INSERT INTO rol_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Nagapamatì siya nang ginawali ni Pablo. Gingtutok siya ni Pablo kag nakità niya nga may pagtuo ang lupog nga ang Ginoo makaayo sa iya. ");
INSERT INTO rol_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Nganì naghambay ning makusog si Pablo, “Pagtindog ning tadlong!” Naglumpat ang lyaki kag nagtunà panaw. ");
INSERT INTO rol_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Nang makità ng mga tawo ang ginghuman ni Pablo, nagsinggit sinda sa linggwahe ng Lycaonia. Hambay ninda, “Naging tawo ang mga dios kag nagpanaog sa aton!” ");
INSERT INTO rol_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Gingtawag ninda si Bernabe nga Zeus kag si Pablo nga Hermes kay siya ang miyughambay. ");
INSERT INTO rol_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ang templo ng inda dios nga si Zeus hay malapit lang sa luwas ng syudad. Nganì nagdaya ang parì ni Zeus ning toro nga mga baka nga may kulintas nga buyak didto sa pwertahan ng syudad. Gusto kuntà niya kag ng mga tawo nga ihalad adto sa mga apostoles. ");
INSERT INTO rol_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Nang masayuran ini nina Bernabe kag Pablo, ginggisì ninda ang inda mga barò sa kalisod kag nagdyagan sa tungà ng mga tawo nga nagasinggit, ");
INSERT INTO rol_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Mga amigo, basì nindo ginahuman ini? Kami hay mga tawo lang da pareho nindo! Yari kami para magwali ng Maayong Balità para bayaan nindo ini nga wayà puyos nga mga butang kag magpalapit sa Dios nga buhì. Siya imaw ang naghuman ng langit, dutà, dagat kag tanan nga mga butang nga yadto didto. ");
INSERT INTO rol_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Nang una pa nga mga tyempo, gingpabay-an lang ng Dios ang mga tawo nga sundon ang inda gusto. ");
INSERT INTO rol_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Pero sa tanan nga oras ginapakilaya ng Dios ang iya kaugalingon sa mga tawo paagi sa iya ginahuman nga maayo. Ginataw-an niya kamo ning uyan kag mga anihon sa tamà nga oras para igwa kamo ning pagkaon kag para malipay kamo.” ");
INSERT INTO rol_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Pero aber imaw ini ang ginahambay ng mga apostoles, indì ninda mapunggan ang mga tawo nga maghalad sa inda. ");
INSERT INTO rol_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Pero may mga Judio nga nag-abot halin sa Antioc nga sakop ng Pisidia kag sa Iconium kag gingsuysugan ninda ang mga tawo nga mag-ampin sa inda kontra sa mga apostoles. Tapos gingbugoy ninda si Pablo kag gingguyod paluwas ng syudad kay ang kalaom ninda patay na siya. ");
INSERT INTO rol_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Pero nang gingpalibutan siya ng mga nagatuo, nagbangon siya kag nagbalik sa syudad. Nang masunod nga adlaw nagkadto sina Pablo kag Bernabe sa Derbe. ");
INSERT INTO rol_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Gingwali nina Pablo kag Bernabe ang Maayong Balità didto sa Derbe kag kadamò ang inda nakumbinsi nga magsunod kay Hesu-Kristo. Pagkatapos nagbalik sinda sa Lystra, Iconium kag sa Antioc nga sakop ng Pisidia. ");
INSERT INTO rol_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Didto gingpakusog ninda ang buot ng mga nagatuo kag ginglaygayan sinda nga magpadayon sa inda pagtuo. Hambay ninda, “Kahinangyan nga makaagi gid kita ng kadamò nga kahugaan bago makasuyod sa gingharian ng Dios.” ");
INSERT INTO rol_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Sa kada lugar nga may mga nagatuo, nagpilì sina Pablo ning mga miyugdumaya para sa inda. Nagpuasa sinda kag nagpangamuyò, tapos gingtugyan sinda sa Ginoo nga inda ginatuuhan. ");
INSERT INTO rol_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pagkatapos nag-agi sinda sa mga lugar nga sakop ng Pisidia kag nag-abot sa Pamfilia. ");
INSERT INTO rol_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Nagwali sinda didto sa Perga, tapos nagkadto sa Atalia. ");
INSERT INTO rol_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Halin didto, naglarga sinda pabalik sa Antioc kung sa diin gingsalig sinda ng mga nagatuo nga pakamaayuhon sinda ng Dios sa ministeryo nga natapos na. ");
INSERT INTO rol_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Pag-abot nina Pablo sa Antioc, gingtipon ninda ang mga nagatuo kag gingbalità ang parti sa tanan nga gingpahuman ng Dios sa inda kag kung pauno ang Dios nagtao ning tsansa sa mga bukon Judio para magtuo da sinda. ");
INSERT INTO rol_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Kag nagtinir sinda didto ning madugay kaibahan ang mga nagatuo. ");
INSERT INTO rol_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","May mga tawo nga halin sa Judea nga nagkadto sa Antioc kag nagtudlò sa mga nagatuo. Hambay ninda, “Indì kamo maluwas kung indì kamo magpapaltak pareho sa patakaran nga gingtudlò ni Moises.” ");
INSERT INTO rol_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pero wayà gid magsugot sina Pablo kag Bernabe sa inda ginatudlò kag nagdinibati gid sinda ng adto nga mga tawo. Nganì nagdesisyon ang mga nagatuo didto nga pakadtuon sina Pablo kag Bernabe kag ang iban pa nga kauturan sa Jerusalem para ini nga problema hay ipaabot sa mga apostoles kag sa mga miyugdumaya ng kongregasyon didto. ");
INSERT INTO rol_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Nganì gingpakadto sina Pablo ng kongregasyon. Pag-agi ninda sa Fenicia kag sa Samaria, gingbalità ninda didto nga madamò na ang nakumbinsi nga bukon Judio nga magtuo kay Kristo. Nang mabatian ninda ini, nalipay gid sinda. ");
INSERT INTO rol_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pag-abot ninda sa Jerusalem nalipay ang mga nagatuo didto, mga apostoles kag mga miyugdumaya ng kongregasyon nang makità sinda. Gingbalità nina Pablo ang tanan nga ginghuman ng Dios paagi sa inda. ");
INSERT INTO rol_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Pero may mga nagatuo didto nga miyembro sa grupo ng mga Pariseo. Nagtindog sinda kag naghambay, “Dapat nga magpapaltak ang mga bukon Judio kag hambayan sinda nga magsunod sa Kasuguan ni Moises.” ");
INSERT INTO rol_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Nagtipon ang mga apostoles kag mga miyugdumaya para istoryahan ang parti sa ini nga butang. ");
INSERT INTO rol_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Pagkatapos ng mahabà nga dibati, nagtindog si Pedro kag naghambay, “Mga kauturan, nasayuran na nindo nang una pa nga isa ako sa mga gingpilì ng Dios para iwali ang Maayong Balità sa mga bukon Judio para sinda hay makabatì kag magtuo. ");
INSERT INTO rol_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Kag ang Dios nga nakakasayod ng tagipusuon ng kada isa, hay nagpamatuod nga gingbaton niya ang mga bukon Judio paagi sa pagtao sa inda ng Espiritu Santo pareho ng iya ginghuman sa aton. ");
INSERT INTO rol_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Pareho lang kita kag ang mga bukon Judio sa panirò ng Dios kay gingpatawad niya ang inda salà tungod nagtuo sinda. ");
INSERT INTO rol_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Nganì, basì ginatilawan nindo ang Dios paagi sa pagpilit nga ipatuman sa mga nagatuo ang mga patakaran kag layi ng mga Judio nga indì ta nganì matuman kag aber ng aton mga kalulo-lulohan? ");
INSERT INTO rol_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Paagi sa pagpakamaayo ni Ginoong Hesus, nagtuo kita nga maluwas pareho da ninda.” ");
INSERT INTO rol_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Nang mabatian ninda ang ginghambay ni Pedro, naghipos ang tanan nga nagatipon didto. Pagkatapos nagpamatì sinda kana Bernabe kag Pablo sa inda pagbalità ng tanan nga milagro kag makatitingaya nga butang nga ginghuman ng Dios sa mga bukon Judio paagi sa inda. ");
INSERT INTO rol_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Pagkatapos ninda maghambay, nagsabat si Santiago, “Mga kauturan, pamatii nindo ako. ");
INSERT INTO rol_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Ging-isplikar sa aton ni Simon Pedro ang una nga pagtawag ng Dios sa mga bukon Judio agud sinda da hay maging iya mga tawo nga sakop niya. ");
INSERT INTO rol_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ini hay nagakumpormi sa gingsulat ng mga propeta pareho ng ginahambay ng Kasulatan, ");
INSERT INTO rol_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Pagkatapos ini, mabalik ako kag akon ipatindog liwat ang gingharian ni David pareho sa tolda nga nagubà. Iugdok ko ini liwat halin sa pagkasirà, kag patibayon ko ini ");
INSERT INTO rol_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","agud ang iban pa nga mga tawo magpangità sa akon, patì tanan nga mga bukon Judio nga akon gingtawag para maging akon. ");
INSERT INTO rol_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Imaw gid ini ang ginghambay ng Ginoo nga gingpasayod na sa aton nang una pa gid.’” ");
INSERT INTO rol_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Nagpadayon si Santiago sa paghambay, “Nganì kung sa akon lang, indì na naton dapat pahugaan ang mga bukon Judio nga nagatuo na sa Dios. ");
INSERT INTO rol_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Dapat sulatan na lang naton sinda nga indì magkaon ning mga pagkaon nga ginghalad sa mga dios-diosan, indì mag-iba nga wayà pa makasay, indì magkaon ng aber ano nga hayop nga wayà napadugui kag indì da magkaon ning dugò. ");
INSERT INTO rol_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Kay tunà pa nang una nga tyempo ang Kasuguan ni Moises hay ginabasa na sa mga sinagoga kada Adlaw nga Inugpahuway. Kag ini hay ginatudlò ninda sa kada banwa.” ");
INSERT INTO rol_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Pagkatapos, ang mga apostoles kag ang mga miyugdumaya kaibahan ang tanan nga nagatuo hay nagkasugot nga magpilì ning pila ka tawo sa inda mga miyembro para pakadtuon sa Antioc kaibahan nina Pablo kag Bernabe. Gingpilì ninda ang duha ka tawo nga ginatahod gid ng mga nagatuo nga sina Judas nga ginatawag da nga Barsabas kag Silas. ");
INSERT INTO rol_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Kag gingpadaya da ninda ang sulat nga ang suyod hay imaw ini: “Kami nga mga apostoles kag mga miyugdumaya diri sa Jerusalem, nga indo mga kauturan, nagapangamusta sa indo nga mga bukon Judio dirà sa Antioc, Syria kag Cilicia. ");
INSERT INTO rol_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Nabatian namon nga may mga tawo halin diri sa amon nga nagkarà sa indo kag ginggulo ang indo mga hunahunà paagi sa inda mga ginghambay. Wayà kami nagsugò sa inda nga magkarà dirà kag magtudlò ning tiyad inà. ");
INSERT INTO rol_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Nganì nagtipon kami diri kag nagkaisa nga magpilì ning mga tawo para pakaraon dirà, kaibahan ang amon mga pinalanggà nga sina Bernabe kag Pablo. ");
INSERT INTO rol_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Gingtayà ninda ang inda kabuhì para magserbisyo sa aton Ginoong Hesu-Kristo. ");
INSERT INTO rol_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Gingpakarà da namon sina Judas kag Silas para iisplikar sa indo ang suyod ng sulat. ");
INSERT INTO rol_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Sa bulig ng Espiritu Santo hay nagkaisa kami nga indì na namon pagdugangan ang indo mga pas-anon, puyra lang sa mga dapat nindo tumanon: ");
INSERT INTO rol_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ayaw kamo magkaon ning mga pagkaon nga ginahalad sa mga dios-diosan, ayaw magkaon ning dugò, ayaw magkaon ning aber ano nga karne ng hayop nga wayà napadugui kag ayaw mag-iba nga wayà pa makasay. Maayo gid kung tumanon nindo ini nga mga butang. Hasta na lang diri.” ");
INSERT INTO rol_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Nganì nagpanaw ang mga tawo nga inda gingsugò. Pag-abot ninda sa Antioc, gingtipon ninda ang tanan nga mga nagatuo kag gingtao ninda ang sulat. ");
INSERT INTO rol_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Pagkabasa ninda ini, nalipay gid sinda sa mensahe nga imaw ang nagtao ning kakusog sa inda buot. ");
INSERT INTO rol_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Sina Judas kag Silas hay mga propeta da. Kadamò ang inda ginghambay nga imaw ang nagpalig-on ng inda pagtuo. ");
INSERT INTO rol_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Pagkatapos ng pila ka adlaw nga pagtinir ninda didto, nagbalik na sinda sa mga nagsugò sa inda. Bago sinda naghalin, gingpangamuyuan sinda ng mga nagatuo nga maging maayo ang inda pagbyahe. ");
INSERT INTO rol_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Nagpabilin si Silas didto. ");
INSERT INTO rol_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pero nagpabilin sina Pablo kag Bernabe ning madugay sa Antioc. Kadamò ang inda kaibahan nga nagtudlò kag nagwali ng hambay ng Ginoo. ");
INSERT INTO rol_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Pagkaligad ng pila ka adlaw, naghambay si Pablo kay Bernabe, “Kari, balikan naton kag bisitahon ang mga kauturan sa tanan nga banwa nga gingwalihan naton ng hambay ng Ginoo para masayuran naton kung ano na ang inda kamutangan.” ");
INSERT INTO rol_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Gusto kuntà ni Bernabe nga day-on si Juan nga ginatawag da nga Marcos. ");
INSERT INTO rol_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pero wayà nagpasugot si Pablo kay wayà siya nagpadayon hasta matapos ang inda misyon, kundì gingbayaan niya sinda sa Pamfilia. ");
INSERT INTO rol_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Sobra gid ang inda diniskusyon, nganì nagbinuyagan sinda. Gingdaya ni Bernabe si Marcos kag nagbyahe pakadto sa Cyprus. ");
INSERT INTO rol_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pero gingdaya naman ni Pablo si Silas. Bago sinda naghalin, gingpangamuyuan anay sinda ng mga nagatuo nga buligan sinda pagbyahe. ");
INSERT INTO rol_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Nagkadto sinda sa iba-iba nga mga banwa sa Syria kag sa Cilicia kag gingpakusog ninda ang buot ng mga nagatuo didto. ");
INSERT INTO rol_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Nagbyahe si Pablo pakadto sa Derbe kag Lystra kung sa diin igwa didto ning isa ka nagatuo nga ang pangayan hay si Timoteo. Ang iya nanay hay Judio nga matutom da nga nagatuo kag ang iya tatay hay Griego. ");
INSERT INTO rol_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Kag nagahambay ang mga nagatuo sa Lystra kag Iconium nga maayo nga tawo si Timoteo. ");
INSERT INTO rol_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Gusto ni Pablo nga day-on si Timoteo nganì gingpapaltakan siya para wayà may mahambay ang mga Judio didto kay sayod ninda nga Griego ang iya tatay. ");
INSERT INTO rol_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Sa kada banwa nga inda ginakadtuan, ginapasayod ninda ang desisyon ng mga apostoles kag ng mga miyugdumaya ng kongregasyon sa Jerusalem. Ginghambayan ninda ang mga nagatuo kag gingsugò nga tumanon ninda ini. ");
INSERT INTO rol_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Nganì nagkusog pa gid ang inda pagtuo kag adlaw-adlaw nadudugangan pa gid sinda. ");
INSERT INTO rol_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Nagkadto sina Pablo sa mga lugar nga sakop ng Frigia kag Galacia kay wayà sinda pagtuguti ng Espiritu Santo nga magwali ng hambay ng Dios sa probinsya ng Asia. ");
INSERT INTO rol_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Nang makaabot sinda sa duyunan ng Mysia, gingtinguhà ninda nga magsuyod sa Bitinia pero wayà sinda pagtuguti ng Espiritu ni Hesus. ");
INSERT INTO rol_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Nganì nag-agi na lang sinda sa Mysia kag nagderitso sa Troas. ");
INSERT INTO rol_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Kag adto nga gab-i, nagkaigwa si Pablo ning panan-awon. Nakità niya ang isa ka tawo nga taga-Macedonia nga nagatindog kag nagapakitluoy sa iya. Hambay niya, “Tabok diri sa Macedonia kag buligi kami.” ");
INSERT INTO rol_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pagkatapos ng adto nga panan-awon, nagpangità gid kami ning paagi nga makakadto kay nabatyagan gid namon nga ginatawag kami ng Dios para magwali sa Macedonia ng Maayong Balità. ");
INSERT INTO rol_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Nagbyahe kami halin sa Troas kag nagderitso sa isla ng Samotrace. Nang masunod nga adlaw nagkadto kami sa Neapolis. ");
INSERT INTO rol_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Halin didto nagkadto kami sa Filipos nga imaw ang pinakasentro nga syudad ng Macedonia kag sakop ng Imperyo ng Roma. Nagtinir kami sa Filipos ng pila ka adlaw. ");
INSERT INTO rol_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Nang Adlaw nga Inugpahuway, nagluwas kami sa syudad kag nagkadto sa alihid ng subà kay naisip namon nga may lugar didto nga ginatipunan ng mga Judio para magpangamuyò. Nagpungkò kami didto kag nagpakig-istorya sa mga babayi nga nagatipon didto. ");
INSERT INTO rol_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Isa sa mga nagapamatì hay si Lydia nga taga-Tiatira nga miyugbaligya ning mamahayon nga tela nga kolor ube kag nagasamba da siya sa Dios. Gingtandog ng Ginoo ang iya tagipusuon nga batunon ang ginawali ni Pablo. ");
INSERT INTO rol_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Nagpabawtismo siya kag patì ang iya panimayay. Pagkatapos hambay niya, “Kung nagapati kamo nga matuod gid nga nagatuo na ako sa Ginoo, kari kamo kag magdayon sa amon bayay.” Nganì napilitan kami. ");
INSERT INTO rol_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Isa ka adlaw, nang pakadto kami sa lugar nga ginatipunan para magpangamuyò, nakasumpong kami ning isa ka ulipon nga dalagita. Ginasapian siya ning malain nga espiritu nganì nakakapanghulà siya. Kadakò nga kwarta ang nababaton ng iya mga amo sa iya pagpanghulà. ");
INSERT INTO rol_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Nagasinunod-sunod sa amon ini nga babayi kag nagasininggit, “Ini nga mga tawo hay suluguon ng Pinakamataas nga Dios! Ginawali ninda sa indo kung pauno kamo maluwas!” ");
INSERT INTO rol_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Adlaw-adlaw imaw adto ang iya ginahuman hasta nga naugot si Pablo. Nganì ging-atubang siya kag ginghambayan ang malain nga espiritu, “Sa pangayan ni Hesu-Kristo, lumayas ka!” Adto gid nga daan naglayas ang malain nga espiritu. ");
INSERT INTO rol_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Nang makità ng iya mga amo nga naduyaan na sinda ng inda pagkakakitaan, gingdakop ninda sina Pablo kag Silas kag gingguyod pakadto sa plasa para iatubang sa otoridad. ");
INSERT INTO rol_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Hambay ninda sa mga pinunò ng syudad, “Ini hay mga Judio nga nagapanggulo sa aton. ");
INSERT INTO rol_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Nagatudlò sinda ning mga kaugalian nga kontra sa aton layi. Mga Romano kita nganì indì naton dapat sundon ang inda ginatudlò.” ");
INSERT INTO rol_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Nganì gingdakop sinda ng mga tawo didto; gingpaubahan ng mga opisyales kag gingpabunay. ");
INSERT INTO rol_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Pagkatapos sinda bunayan ng sobra, gingpapriso sinda kag gingpabantayan gid ning maayo. ");
INSERT INTO rol_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Nganì gingsuyod sinda ng gwardya sa pinakasuyod ng selda kag ginggapos pa ang inda mga siki sa tungà ng mabug-at nga kahoy. ");
INSERT INTO rol_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Nang mga tungang gab-i na, sina Pablo kag Silas hay nagapangamuyò kag nagakanta ning pagdayaw sa Dios. Kag ang iban nga mga priso hay nagapamatì sa inda. ");
INSERT INTO rol_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Gulpi na lang nga naglinog ning kakusog-kusog kag naghubog ang mga pundasyon ng prisuhan. Adto nga daan naabrihan ang tanan nga pwertahan sa prisuhan kag natangsò ang mga kadina ng tanan nga priso. ");
INSERT INTO rol_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Nakabatì ang gwardya kag nang makità niya nga bukas ang mga pwertahan, kalaom niya hay nakabuhì na ang mga priso. Nganì ginggabot niya ang iya espada para magpakamatay. ");
INSERT INTO rol_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pero nagsinggit si Pablo, “Ayaw gipakamatay! Yari kami tanan!” ");
INSERT INTO rol_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Nagpabuoy ning iwag ang gwardya kag dalì-dalì nga nagsuyod kag naghapà sa atubangan nina Pablo kag Silas nga nagapangurog. ");
INSERT INTO rol_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Pagkatapos gingdaya niya sinda paluwas kag gingpangutana, “Ano ang akon humanon para maluwas?” ");
INSERT INTO rol_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Nagsabat sinda, “Magtuo ka kay Ginoong Hesus kag maluluwas ka patì ang imo bilog nga panimayay.” ");
INSERT INTO rol_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Pagkatapos nagwali sinda ng hambay ng Ginoo sa iya kag sa tanan nga yadto sa iya bayay. ");
INSERT INTO rol_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Adto da nga gab-i, ginghugasan ng gwardya ang inda mga pilas kag nagpabawtismo siya patì ang iya bilog nga panimayay. ");
INSERT INTO rol_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Pagkatapos gingdaya niya sina Pablo kag Silas sa iya bayay kag gingpakaon. Nalipay gid ang gwardya kag ang iya bilog nga panimayay kay nagatuo na sinda sa Dios. ");
INSERT INTO rol_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Pagkaaga, nagpadaya ang mga opisyales ning mga pulis para maghambay, “Paluwasa na sinda.” ");
INSERT INTO rol_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Kag gingbalità ini ng gwardya kay Pablo. Hambay niya, “Nagpasugò ang mga opisyales nga buhian na kamo. Nganì luwas na kamo kag maayo lang nga pagpanaw.” ");
INSERT INTO rol_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pero nagsabat si Pablo sa mga pulis, “Gingpabunay ninda kami sa atubangan ng kadamò nga tawo aber wayà pa kami naimbistigahi. Kag pagkatapos gingpapriso pa ninda kami aber mga pumuluyò kami ng Roma! Tapos arinyan sikreto nga paluwason ninda kami? Indì puydi inà! Sinda mismo ang dapat magpaluwas sa amon.” ");
INSERT INTO rol_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Gingbalità ng mga pulis ang ginghambay ni Pablo sa mga opisyales kag hinadlukan gid sinda nang masayuran nga mga Romano galì sina Pablo kag Silas. ");
INSERT INTO rol_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Nganì nagkadto sinda kag nagpangayò ning patawad sa inda. Pagkatapos ginghatod ninda sina Pablo sa luwas ng prisuhan kag gingpangabay nga maghalin na sinda sa adto nga syudad. ");
INSERT INTO rol_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Nang makaluwas na sina Pablo kag Silas sa prisuhan, nagkadto sinda sa bayay ni Lydia. Nagpakigkità sinda sa mga nagatuo kag gingpalig-on ang inda pagtuo. Pagkatapos hay nagpanaw sinda. ");
INSERT INTO rol_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Nag-agi sina Pablo kag Silas sa Amfipolis kag sa Apolonia hasta nakaabot sa Tesalonica. Sa ini nga banwa hay may sinagoga ang mga Judio. ");
INSERT INTO rol_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Kag nagsuyod sina Pablo didto pareho ng iya permi ginahuman kag sa suyod ng tuyo ka Adlaw nga Inugpahuway, nagpakigdiskusyon siya sa mga tawo parti sa Kasulatan. ");
INSERT INTO rol_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ging-isplikar kag gingpamatuuran niya nga kahinangyan mag-agi ang Kristo ning kasakit kag mabanhaw. Hambay ni Pablo, “Ini nga Hesus nga akon ginawali sa indo imaw ang Kristo.” ");
INSERT INTO rol_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","May mga iban sa inda nga nakumbinsi kag nagsunod kana Pablo kag Silas. Nagtuo da ang kadamò nga diosnanon nga Griego kag mga kilaya nga babayi. ");
INSERT INTO rol_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Pero naili ang iban nga mga Judio nga wayà nagatuo. Nganì gingtipon ninda ang pila ka mga bugoy para buligan sinda sa pagpanggulo ng syudad. Gingsuyod ninda ang bayay ng isa ka tawo nga ang pangayan hay Jason para sugiron sina Pablo kag Silas agud iatubang sa kadamò nga tawo. ");
INSERT INTO rol_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Pero nang wayà ninda makità sinda nga duha, gingguyod ninda si Jason kag ang iban nga mga nagatuo sa atubangan ng mga opisyales ng syudad kag nagsinggit, “Ini nga mga tawo hay nagapanggulo aber diin magkadto! Yari na sinda arinyan sa aton syudad ");
INSERT INTO rol_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","kag gingpadayon pa sinda ni Jason sa iya bayay. Ginakontra ninda ang mga layi ng Emperador kay ginahambay ninda nga igwa pa isa ka harì nga ang pangayan hay Hesus!” ");
INSERT INTO rol_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Pagkabatì adto ng mga tawo kag ng mga opisyales hay nagkinagulo sinda. ");
INSERT INTO rol_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Pagkatapos nga gingpapyansa ninda si Jason kag ang iya mga kaibahan gingbuhian na sinda. ");
INSERT INTO rol_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Adto da nga gab-i, gingpakadto ng mga nagatuo sina Pablo kag Silas sa Berea. Pag-abot ninda didto, nagkadto sinda sa sinagoga ng mga Judio. ");
INSERT INTO rol_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Mas bukas ang hunahunà ng mga tawo didto bukon pareho ng mga taga-Tesalonica. Kay gusto gid ninda magpamatì ng mensahe kag ginaistudyuhan gid ninda ning maayo kada adlaw ang mga Kasulatan para makità kung ang ginatudlò ni Pablo hay matuod. ");
INSERT INTO rol_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Nganì kadamò sa inda ang nagtuo patì ang mga kilaya nga babayi nga Griego kag mga lyaki. ");
INSERT INTO rol_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Pero nang masayuran ng mga Judio nga taga-Tesalonica nga nagwali si Pablo ng hambay ng Dios sa Berea, nagkadto sinda didto kag gingsuysugan ang mga tawo nga manggulo. ");
INSERT INTO rol_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Nganì gingpakadto nga daan ng mga nagatuo si Pablo sa alihid ng dagat. Pero sina Silas kag Timoteo hay nagpabilin sa Berea. ");
INSERT INTO rol_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ang mga tawo nga naghatod kay Pablo hay nagnunot hasta sa Atenas. Pagkatapos nagbalik sinda sa Berea nga may tugon halin kay Pablo nga sina Silas kag Timoteo hay ginapaapas nga daan sa iya. ");
INSERT INTO rol_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Mintras nagahuyat si Pablo kana Silas kag Timoteo sa Atenas, naglain gid ang iya pamatyag nang makità niya nga kadamò gid ang inda mga dios-diosan. ");
INSERT INTO rol_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Nganì nagpakigdiskusyon siya didto sa suyod ng sinagoga, sa mga Judio kag sa mga diosnanon nga bukon Judio; imaw da ang iya ginahuman adlaw-adlaw didto sa plasa. ");
INSERT INTO rol_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","May duha ka klasi ng mga manunudlò ang nagpakigdibati kay Pablo. Ang isa hay ginatawag, mga Epicureo kag ang isa hay mga Estoico. Naghambay ang iban sa inda, “Ano ang ginahinambay ng ignorante nga ini?” Ang iban naman naghambay, “Daw labot nga mga dios ang iya ginawali.” Ginghambay ninda ini kay si Pablo hay nagawali parti kay Hesus kag sa iya pagkabanhaw. ");
INSERT INTO rol_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Nganì gingdaya ninda si Pablo sa ginatipunan ng konseho ng Atenas nga ginatawag, Areopagus. Naghambay sinda kay Pablo, “Gusto namon masayuran ining bag-o mo nga ginatudlò. ");
INSERT INTO rol_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Kay may iban ka nga mga butang nga ginatudlò nga bag-o sa amon nganì gusto namon masayuran kung ano ang gusto ini hambayon.” ");
INSERT INTO rol_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ginghambay ninda ini kay ang tanan nga taga-Atenas kag ang mga istranghero nga didto nagaistar hay mahilig gid sa pagpakig-istorya o pagpamatì permi parti sa mga bag-o nga mga pagpanudlò. ");
INSERT INTO rol_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Nganì nagtindog si Pablo sa atubangan ng mga tawo nga nagatipon didto sa Areopagus kag naghambay, “Mga taga-Atenas! Nakità ko nga kamo hay relihiyuso gid nga mga tawo. ");
INSERT INTO rol_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Kay sa akon paglibot diri sa indo syudad kag pagsirò sa mga lugar nga indo ginasambahan, may nakità ako nga isa ka altar* nga may nakasulat, ‘Para sa dios nga wayà nakikilaya.’ Ang Dios nga ginasamba nindo nga wayà pa nindo nakikilaya, imaw ang ginawali ko sa indo arinyan. ");
INSERT INTO rol_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Ang Dios nga nagtuga ng kalibutan kag ng tanan nga yari diri, siya ang Ginoo ng langit kag dutà kag wayà nagaistar sa mga templo nga ginghuman ng mga tawo. ");
INSERT INTO rol_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Wayà da siya nagakahinangyan ning bulig halin sa tawo tungod siya gid ang nagatao ning kabuhì kag ginhawa kag ng tanan nga aton ginakahinangyan. ");
INSERT INTO rol_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Halin sa isa lang ka tawo, ginghuman niya ang tanan nga lahì sa bilog nga kalibutan. Gingplano da ng Dios tunà pa nang una ang mga duyunan kung diin maistar ang mga tawo patì ang tyempo nga sinda hay magakabuhì. ");
INSERT INTO rol_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ginghuman niya ini para pangitaon naton siya kag basì pa na lang kung makità naton siya kay sa matuod lang, bukon malayò ang Dios sa kada isa sa aton, ");
INSERT INTO rol_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","kay ‘Sakop niya ang aton kabuhì, paghuyag kag pagkatawo.’ Pareho sa ginghambay ng iban nindo nga mga makatà, ‘Kita tanan hay mga ungà gid niya.’ ");
INSERT INTO rol_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Kag tungod kita hay mga ungà ng Dios, indì dapat naton isipon nga ang Dios hay pareho sa dios-diosan nga bulawan, pilak o bato nga himò ng mga tawo kag halin sa inda imahinasyon. ");
INSERT INTO rol_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Nang mga nagligad nga tyempo nga wayà pa kakilaya ang mga tawo sa Dios, wayà niya ging-intindiha ang inda mga kasal-anan pero niyan ginasugò niya sinda tanan nga maghinuysoy sa salà kag sa malain nga inda ginahuman. ");
INSERT INTO rol_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Kay may adlaw na nga gingpilì ang Dios para husgahan niya ning matarong ang tanan nga tawo sa kalibutan paagi sa isa ka tawo nga iya gingpilì. Gingpamatuuran niya ini tanan paagi sa pagbanhaw niya sa ini nga tawo.” ");
INSERT INTO rol_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Pagkahambay ni Pablo parti sa pagkabanhaw, ging-ngitlan siya ng iban. Pero ang iban nga nagapamatì hay naghambay, “Gusto ka namon nga mapamatian liwat parti diri.” ");
INSERT INTO rol_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Pagkatapos naghalin si Pablo sa inda ginatipunan. ");
INSERT INTO rol_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Pero may iban sa inda nga nagsunod kay Pablo kag nagtuo kay Hesus. Kaibahan didto si Dionisius nga miyembro ng Areopagus, ang isa ka babayi nga ang pangayan hay Damaris kag may iban pa gid. ");
INSERT INTO rol_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Pagkatapos adto, naghalin si Pablo sa Atenas kag nagkadto sa Corinto. ");
INSERT INTO rol_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Didto nakilaya niya si Aquila nga Judio nga taga-Pontus. Bag-o lang siya nag-abot halin sa Italia kaibahan ang iya asawa nga si Priscila, kay gingpalayas ni Emperador Claudius ang tanan nga Judio sa Roma. Gingbisita sinda ni Pablo sa inda bayay. ");
INSERT INTO rol_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Kag tungod pareho sinda nga miyughuman ning tolda nga panit, didto siya nagdayon kag nagbulig kaibahan ninda. ");
INSERT INTO rol_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Kada Adlaw nga Inugpahuway, nagapakigdibati siya didto sa sinagoga kag ginatinguhà nga makumbinsi ang mga Judio kag mga Griego nga magtuo kay Hesus. ");
INSERT INTO rol_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Nang mag-abot sina Silas kag Timoteo halin sa Macedonia, ginggamit ni Pablo ang tanan niya nga oras para magwali ng Maayong Balità. Gingpamatuuran niya sa mga Judio nga si Hesus imaw ang Kristo. ");
INSERT INTO rol_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Pero gingkontra kag ginghambayan ninda siya ning malain, nganì gingpagpag niya ang dapodapo sa iya barò bilang paandam kontra sa inda. Naghambay siya, “Kasal-anan gid nindo kung parusahan kamo ng Dios sa impyerno nga wayà katapusan. Wayà na ako ning panabton. Tunà niyan sa mga bukon Judio* na ako mawali.” ");
INSERT INTO rol_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Nganì naghalin siya didto kag nagdayon sa bayay ni Titius Justus. Ini nga tawo hay bukon Judio nga nagasamba sa Dios kag ang iya bayay hay yadto sa alihid ng sinagoga. ");
INSERT INTO rol_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Nagtuo da sa Ginoo si Crispus nga pinunò ng sinagoga kag ang iya bilog nga panimayay kag kadamò pa nga mga taga-Corinto nga nakabatì kay Pablo ang nagtuo kag nagpabawtismo. ");
INSERT INTO rol_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Isa ka gab-i, nagpakità ang Ginoo kay Pablo paagi sa panan-awon kag naghambay, “Ayaw mahadlok. Magpadayon ka sa imo pagwali ng Maayong Balità kag ayaw magpara ");
INSERT INTO rol_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","kay kaibahan mo ako. Kadamò ang akon gingpilì sa ini nga banwa nganì wayà ning may magpangahas nga magsakit sa imo.” ");
INSERT INTO rol_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Kag nag-istar didto si Pablo kag nagtudlò sa mga tawo ng hambay ng Dios sa suyod ng isa ka tuig kag tungà. ");
INSERT INTO rol_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Pero nang si Galio hay gobernador ng Acaya, nagkaisa ang mga Judio kontra kay Pablo kag inda gingdakop kag gingdaya sa korte. ");
INSERT INTO rol_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Naghambay sinda, “Ini nga lyaki hay nagapangumbinsi sa mga tawo nga magsamba sa Dios kung sa diin kontra ini sa aton Kasuguan.” ");
INSERT INTO rol_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Mahambay na kuntà si Pablo pero naghambay si Galio sa mga Judio, “Kung ini hay parti sa kalainan o kasal-anan nga iya nahimò, wayà ako ning rason nga indì maghusay sa indo nga mga Judio. ");
INSERT INTO rol_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Pero kay ang indo ginadiskusyonan hay parti lang sa mga hambay, mga pangayan kag sa indo Kasuguan, kamo na lang ang maghusay inà. Wayà ako labot sa inà nga mga butang.” ");
INSERT INTO rol_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Kag gingpaluwas niya sinda sa korte. ");
INSERT INTO rol_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Pagkatapos gingdakop ninda si Sostenes nga pinunò ng sinagoga kag inda gingbunay sa atubangan ng korte. Pero wayà ini ging-intindiha ni Galio. ");
INSERT INTO rol_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pagkatapos nagtinir si Pablo sa Corinto ning kadamò pa nga mga adlaw kaibahan ang mga kauturan didto. Tapos nagpamuhon siya sa inda kag naglarga pakadto sa Syria kaibahan sina Priscila kag Aquila. Nang yadto na siya sa Cencrea, nagpatupi siya pagkatapos matuman ang iya pangakò sa Dios. ");
INSERT INTO rol_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Pag-abot ninda sa Efeso gingbilin niya didto sina Priscila kag Aquila. Pero bago siya naghalin nagkadto anay siya sa sinagoga kag nagpakig-istorya sa mga Judio. ");
INSERT INTO rol_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Gingpangabay ninda siya nga magtinir lang anay didto, pero wayà siya magsugot. ");
INSERT INTO rol_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Nagpamuhon siya sa inda kag ang hambay niya, “Mabalik ako diri sa indo kung itugot ng Dios.” Pagkatapos naglarga siya halin sa Efeso. ");
INSERT INTO rol_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Pagdunggò ni Pablo sa Cesarea, nagkadto siya sa Jerusalem kag gingkamusta niya ang mga nagatuo didto. Tapos nagderitso siya sa Antioc. ");
INSERT INTO rol_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Wayà magdugay ang iya pagtinir didto kag nagpadayon siya sa pagbyahe. Ginglibot niya ang mga lugar nga sakop ng Galacia kag Frigia kag gingpakusog niya ang pagtuo ng mga disipulo didto. ");
INSERT INTO rol_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Niyan, may isa ka Judio nga taga-Alexandria nga nagkadto sa Efeso. Ang iya pangayan hay si Apolos. Maayo gid siya maghambay kag kadamò ang nasayuran niya sa mga Kasulatan. ");
INSERT INTO rol_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Natudluan na siya parti sa Pamaagi ng Ginoo kag kahugod siya magtudlò kag tamà gid ang iya ginatudlò parti kay Hesus. Pero ang bawtismo lang ni Juan ang iya nasayuran. ");
INSERT INTO rol_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Wayà siya nahadlok maghambay sa mga tawo sa sinagoga. Nang mabatian ini nina Priscila kag Aquila, ging-agda ninda siya sa inda bayay kag didto ging-isplikar ninda ning maayo ang Pamaagi ng Ginoo. ");
INSERT INTO rol_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Kag nang magplano si Apolos nga magkadto sa Acaya, gingbuligan siya ng mga nagatuo sa Efeso kag gingsulatan ninda ang mga nagatuo sa Acaya nga batunon ninda si Apolos. Pag-abot niya didto, kadakò gid ang iya naibulig sa mga nagatuo paagi sa kaayo ng Dios. ");
INSERT INTO rol_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Kay sa iya pagpakigdibati sa mga Judio sa publiko wayà gid sinda ning may mahuman kag gingpamatuuran niya sa inda paagi sa mga Kasulatan nga si Hesus gid ang Kristo. ");
INSERT INTO rol_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Mintras yadto si Apolos sa Corinto, si Pablo naman hay nag-agi sa mga bakuyod ng probinsya hasta nga nakaabot siya sa Efeso. May nakità siya didto nga mga nagatuo. ");
INSERT INTO rol_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Gingpangutana niya sinda, “Nabaton ba nindo ang Espiritu Santo nang nagtuo kamo?” Nagsabat sinda, “Wayà gid nganì kami makabatì nga may ginatawag nga Espiritu Santo.” ");
INSERT INTO rol_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Nganì nagpangutana si Pablo sa inda, “Kung tiyad inà, sa ano kamo nabawtismuhan?” Nagsabat sinda, “Sa bawtismo ni Juan.” ");
INSERT INTO rol_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Naghambay si Pablo, “Ang bawtismo ni Juan hay para sa mga nagahinuysoy sa inda salà. Pero naghambay da si Juan sa mga Judio nga kahinangyan magtuo sinda sa magasunod sa iya kag imaw ini si Hesus.” ");
INSERT INTO rol_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Nang mabatian ninda ini, nagpabawtismo sinda sa pangayan ni Ginoong Hesus. ");
INSERT INTO rol_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Nang gingtungtong ni Pablo ang iya kamot sa inda, nag-abot sa inda ang Espiritu Santo. Tapos naghambay sinda ng iba-iba nga mga linggwahe nga wayà ninda nasayuri kag nagpropesiya sinda. ");
INSERT INTO rol_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Mga dose sinda tanan nga lyaki. ");
INSERT INTO rol_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Sa suyod ng tuyo ka bulan, si Pablo hay nagakadto sa sinagoga. Wayà siya mahadlok maghambay sa mga tawo kag magpakigdibati sa inda para makumbinsi sinda parti sa gingharian ng Dios. ");
INSERT INTO rol_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Pero ang iban sa inda hay matugas gid ang uyo kag indì gid magtuo kag naghambay pa sinda ning malain parti sa Pamaagi ng Ginoo didto sa atubangan ng kadamuan. Nganì naghalin si Pablo sa inda kaibahan ang mga nagatuo. Kag didto na lang siya nagkadto adlaw-adlaw sa mabahoy nga kwarto kung sa diin nagatudlò si Tyranus para magpadayon sa pagtudlò sa mga tawo. ");
INSERT INTO rol_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Sa suyod ng duha ka tuig imaw ini ang iya ginahuman nganì ang tanan nga nagaistar didto sa probinsya ng Asia, Judio kag bukon Judio, hay nakabatì ng hambay ng Dios. ");
INSERT INTO rol_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Kadamò ang pambihirà nga milagro nga gingpanghuman ng Dios paagi kay Pablo. ");
INSERT INTO rol_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Kay aber ang mga panyò o mga barò nga iya ginggamit nga ginadaya sa mga may sakit hay nagapaayo kag nagapalayas ng malain nga mga espiritu sa inda. ");
INSERT INTO rol_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","May mga Judio nga nagalibot kag nagapalayas da ning malain nga mga espiritu. Gingpangahasan ninda nga gamiton ang pangayan ni Ginoong Hesus para palayason ang malain nga mga espiritu. Naghambay sinda, “Sa pangayan ni Hesus nga ginawali ni Pablo, layas kamo!” ");
INSERT INTO rol_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Kaibahan sa mga naghuman ini hay ang pito ka ungà nga lyaki ni Esceva, isa ka pinunò ng parì ng mga Judio. ");
INSERT INTO rol_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Pero gingsabat sinda ng malain nga espiritu, “Kilaya ko si Hesus kag kilaya ko da si Pablo, pero sin-o kamo?” ");
INSERT INTO rol_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Pagkatapos ginglumpatan sinda ng tawo nga ginasapian ng malain nga espiritu kag gingpangsakit. Nagdyagan sinda tanan paluwas sa bayay nga kadamò ang pilas kag nagkaubahan. ");
INSERT INTO rol_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ini nga natabò hay nabalitaan ng tanan nga mga Judio kag mga bukon Judio nga nagaistar sa Efeso, nganì hinadlukan gid sinda kag ang pangayan ni Ginoong Hesus hay inda pa gid gingdayaw. ");
INSERT INTO rol_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Kadamò ang mga nagtuo didto nga nag-akò ng inda malain nga ginahuman. ");
INSERT INTO rol_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Kag kadamò da nga madyikero ang nagdaya ng inda mga librita kag gingsunog sa atubangan ng tanan. Ang kantidad ini tanan hay umabot sa 50,000 drachma ");
INSERT INTO rol_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Paagi sa gahom ng Ginoo, naglapnag pa gid ang hambay ng Dios kag kadamò pa gid ang nagtuo. ");
INSERT INTO rol_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Pagkatapos ng adto nga mga natabò, nagdesisyon si Pablo nga mag-agi sa Macedonia kag Acaya bago magderitso sa Jerusalem. Hambay niya, “Pagkahalin ko sa Jerusalem, dapat makadto da ako sa Roma.” ");
INSERT INTO rol_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Gingpauna niya sa Macedonia sina Timoteo kag Erastus, ang duha sa mga nagabulig sa iya kag nagpabilin pa siya didto sa probinsya ng Asia sa suyod ng pila ka adlaw. ");
INSERT INTO rol_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Adto nga tyempo may natabò nga dakò nga kinagulo sa Efeso tungod sa Pamaagi ng Ginoo nga ginatudlò ni Pablo. ");
INSERT INTO rol_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","May isa ka platero nga ang pangayan hay Demetrius. Siya kag ang iya mga trabahador hay nagapanghuman ning maintik nga mga templo nga pilak ng inda diosa nga si Artemis. Paagi diri, nakakakwarta sinda ning dakò. ");
INSERT INTO rol_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Nganì gingpatipon niya ang iya mga trabahador kag ang iban nga mga platero kag naghambay siya sa inda, “Mga amigo, nasayuran gid nindo nga ining aton negosyo hay maayo gid nga pangabuhian. ");
INSERT INTO rol_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Niyan, nakità kag nabatian nindo ang ginahuman ng ini nga tawo nga si Pablo. Gingkumbinsi niya ang kadamò nga tawo diri sa Efeso kag sa bilog nga probinsya ng Asia nga ang mga dios nga ginghuman ng tawo hay bukon matuod nga dios kag nagpati gid sinda sa iya. ");
INSERT INTO rol_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Nganì basì kung masirà ang aton pangabuhian kag bukon lang inà, kundì delikado da ang templo ng aton bantog nga diosa nga si Artemis kay basì kung maging wayà puyos kag maduyà ang pagkabantog ng aton diosa nga ginasamba naton tanan sa Asia kag sa bilog nga kalibutan.” ");
INSERT INTO rol_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Nang mabatian ini ng mga tawo, nahangit gid sinda kag nagsininggit, “Makagagahom si Artemis nga diosa ng mga taga-Efeso!” ");
INSERT INTO rol_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Kag nagkinagulo pa gid sa bilog nga syudad. Nganì gingdakop ninda sina Gaius kag Aristarcus nga taga-Macedonia, mga kaibahan ni Pablo. Pagkatapos nagpangdyagan sinda pasuyod sa inda ginatipunan nga ginayudyod ang duha. ");
INSERT INTO rol_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Nagtinguhà kuntà si Pablo nga maghambay sa atubangan ng mga tawo, pero wayà siya gingtuguti ng mga nagatuo. ");
INSERT INTO rol_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Aber ang mga amigo ni Pablo nga opisyales sa probinsya ng Asia hay nagsugò para magpakitluoy sa iya nga indì gid siya magpakità didto sa inda ginatipunan. ");
INSERT INTO rol_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Niyan, ang mga tawo didto hay nagkinagulo pa gid. May nagasininggit ning isa ka butang kag ang iban naman hay labot ang inda ginasinggit. Ang kadamuan sa inda hay wayà kasayod kung basì nagatipon sinda didto. ");
INSERT INTO rol_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ang kalaom ng mga tawo didto si Alexander ang kabangdanan kay siya ang gingbutang ng mga Judio sa atubangan ng mga tawo. Gingtaas niya ang iya kamot para pahipuson ang mga tawo agud siya hay makaisplikar. ");
INSERT INTO rol_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Pero nang masayuran ninda nga Judio galì siya, dungan-dungan sinda nagsininggit sa suyod ng duha ka oras, “Makagagahom si Artemis ng mga taga-Efeso!” ");
INSERT INTO rol_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Nang ulihi, nag-abot ang pinunò ng banwa kag gingpahipos ang mga tawo. Hambay niya, “Mga kasimanwa ko, ang tanan nga mga tawo hay nakasayod nga kita nga taga-Efeso imaw ang miyugpamahayà ng templo ni Artemis nga makagagahom kag ng sagrado nga bato nga nahuyog halin sa langit. ");
INSERT INTO rol_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Wayà ning may makabalibad parti diri. Nganì kalma lang kamo kag magdahan-dahan! ");
INSERT INTO rol_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Gingdaya nindo ini nga mga tawo diri, aber wayà sinda nagpangawat sa aton templo kag naghambay ning malain kontra sa aton diosa. ");
INSERT INTO rol_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Kung si Demetrius kag ang iya mga kaibahan nga platero hay may reklamo kontra sa aber kanin-o, igwa kita ning mga korte kag mga husgado. Dapat day-on ninda didto ang inda mga kaso! ");
INSERT INTO rol_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Pero kung igwa pa gid kamo ning iban nga reklamo, inà hay kahinangyan nga husayon sa kabilugan nga pagtitipon ng mga pumuluyò sunò sa layi. ");
INSERT INTO rol_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Niyan, delikado kita sa aton ginahuman. Kay basì kung iakusar kita sa pinunò ng Roma nga kita ang nagpanggulo niyan nga adlaw. Wayà gid kita ning maitao nga rason kung basì natabò ini.” ");
INSERT INTO rol_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Nang matapos na siya maghambay, gingpaulì niya ang mga tawo. ");
INSERT INTO rol_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Nang wayà na ang gulo, gingpatawag ni Pablo ang mga disipulo kag gingpakusog niya ang inda buot. Pagkatapos nagpamuhon siya kag nagkadto sa Macedonia. ");
INSERT INTO rol_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Kadamò nga lugar ang iya gingkadtuan didto kag gingpakusog niya ang buot ng mga nagatuo paagi sa iya mga mensahe. Pagkatapos nagkadto na siya sa Grecia ");
INSERT INTO rol_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Nagtinir siya didto sa suyod ng tuyo ka bulan. Pahalinon na kuntà siya pakadto sa Syria ugaling nasayuran niya nga ang mga Judio hay nagaplano nga patyon siya. Nganì nagdesisyon siya nga sa Macedonia na liwat mag-agi pabalik. ");
INSERT INTO rol_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Nagnunot sa iya si Sopater nga ungà ni Pyrhus nga taga-Berea. Kaibahan da niya sina Aristarcus, Secundus nga taga-Tesalonica, Gaius nga taga-Derbe, Timoteo kag ang mga taga-Asia nga sina Tykicus kag Trofimus. ");
INSERT INTO rol_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Pag-abot namon sa Filipos, nag-una sinda sa amon sa Troas kag didto ninda kami ginghuyat. ");
INSERT INTO rol_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Nang matapos na ang Pyesta ng Tinapay nga wayà Pampaalsa*, naglarga kami halin sa Filipos pakadto sa Troas. Lima ka adlaw ang amon byahe bago nakaabot didto kag nag-apas kami sa amon mga kaibahan. Didto kami nagtinir ning pito ka adlaw. ");
INSERT INTO rol_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Nang Sabado nga gab-i, nagtipon kami para magbuak-buak ng tinapay agud dumdumon ang pagkamatay ni Hesu-Kristo. Nagtudlò si Pablo sa inda hasta magtungang gab-i, kay mahalin na siya pagkaaga. ");
INSERT INTO rol_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Kadamò ang mga iwag sa kwarto sa ibabaw nga amon ginatipunan. ");
INSERT INTO rol_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","May soltero didto nga ang iya pangayan hay Euticus nga nagapungkò sa bintanà. Tungod sa sobra nga kadugay ng paghambay ni Pablo, pinilaw siya kag nakatuyog ning hamuok. Nganì nahuyog siya sa bintanà halin sa ikatuyo ka iskalon. Patay na siya nang inda ginghakwat. ");
INSERT INTO rol_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pero nagpanaog si Pablo kag pag-abot niya kay Euticus, ginghapaan niya kag gingkupkupan. Hambay niya, “Ayaw kamo mabayaka, buhì siya.” ");
INSERT INTO rol_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Pagkatapos nagbalik si Pablo sa ibabaw, nagbuak-buak ng tinapay kag nagkaon. Nagpadayon siya sa pagwali sa inda hasta nga nagsubat ang adlaw, tapos naghalin na siya. ");
INSERT INTO rol_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ang soltero naman nga nahuyog hay gingdaya ninda pabalik sa iya bayay nga buhì kag ini hay nagtao sa inda ning dakò nga kalipay. ");
INSERT INTO rol_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Naglarga kami pakadto sa Asos kay didto kami magakità ni Pablo sunò sa iya tugon sa amon kay mabaktas lang siya pakadto didto. ");
INSERT INTO rol_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Nang magkità kami sa Asos, gingpasakay namon siya sa amon ginasakyan kag nagderitso kami sa Mitilene. ");
INSERT INTO rol_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Halin didto nagpadayon kami sa pagbyahe kag pagkaaga nag-abot kami sa Kios. Nang masunod nga adlaw, nakaabot kami sa Samos kag pagkaligad ng isa pa ka adlaw yadto na kami sa Miletus. ");
INSERT INTO rol_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Nagdesisyon si Pablo nga indì na lang siya mag-agi sa Efeso para indì na siya maawat sa probinsya ng Asia. Kay gusto gid niya nga kung puydi makaabot sa Jerusalem bago ang adlaw ng Pentecostes*. ");
INSERT INTO rol_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Halin sa Miletus may gingsugò si Pablo agud tawagon ang mga miyugdumaya ng kongregasyon sa Efeso. ");
INSERT INTO rol_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Pag-abot ninda didto, naghambay siya sa inda, “Sayod nindo kung pauno ang akon pagkabuhì nang ako hay kaibahan pa nindo, magtunà nang pag-abot ko diri sa probinsya ng Asia. ");
INSERT INTO rol_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Nagserbisyo ako sa Ginoo nga may pagpakababà kag pagtangis tungod sa kadamò nga pagtilaw nga akon ging-antos sa mga malain nga plano sa akon ng mga Judio. ");
INSERT INTO rol_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Nasayuran da nindo nga wayà gid ning pang-ayang-ayang ang akon pagbalità sa indo ng mga butang nga para sa indo kaayuhan nga akon gingtudlò sa publiko kag sa mga bayay-bayay. ");
INSERT INTO rol_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Gingpaandaman ko ang mga Judio kag mga bukon Judio nga kahinangyan maghinuysoy na sinda sa inda mga salà kag magbalik sa Dios kag magtuo sa aton Ginoong Hesu-Kristo. ");
INSERT INTO rol_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Niyan, makadto ako sa Jerusalem bilang pagsunod sa Espiritu Santo kag wayà ako makasayod kung ano ang matatabò sa akon didto. ");
INSERT INTO rol_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ang sayod ko lang, aber diin nga syudad ako magkadto, ginapasayod sa akon ng Espiritu Santo nga ang nagahuyat sa akon hay pagkapriso kag mga pagpasakit. ");
INSERT INTO rol_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Pero wayà ning kwenta aber ano ang matabò sa akon kabuhì basta matapos ko lang ang ministeryo nga gingtao sa akon ni Ginoong Hesus nga imaw ang pagwali ng Maayong Balità parti sa kaayo ng Dios para sa mga tawo. ");
INSERT INTO rol_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Gingkadtuan ko kamo tanan para magwali sa indo parti sa paghaharì ng Dios, pero niyan sayod ko nga indì na nindo ako makikità liwat. ");
INSERT INTO rol_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Nganì sa ini nga adlaw ginahambay ko gid sa indo, kung igwa sa indo ning indì maluwas, wayà na ako ning panabton sa Dios. ");
INSERT INTO rol_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Kay wayà ako ning gingtagò sa indo parti sa tanan nga gingplano ng Dios. ");
INSERT INTO rol_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Bantayi gid nindo ang indo kaugalingon kag ang tanan nga mga tawo ng Dios nga ginapadipara sa indo ng Espiritu Santo. Proteksyuni nindo ang iglesya ng Dios nga gingtubos niya paagi sa dugò ng iya Ungà. ");
INSERT INTO rol_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Kay sayod ko nga kung makahalin na ako, may mga manunudlò nga magasuyod sa indo grupo nga daw pareho sa mapintas nga hayop. Siraon ninda kamo paagi sa inda mga pagpanudlò nga bukon tamà. ");
INSERT INTO rol_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Magaabot ang oras nga sa indo mismo magahalin ang mga tawo nga magatudlò ning bukon tamà para ang mga nagatuo hay magatayang kag magasunod sa inda. ");
INSERT INTO rol_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Nganì mag-andam kamo kag dumduma nindo nga sa suyod ng tuyo ka tuig, adlaw-gab-i wayà ako nagpara pagwali sa indo tanan nga may pagtangis. ");
INSERT INTO rol_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Kag niy