﻿USE sofia;
DROP TABLE IF EXISTS sofia.rmyvlakh_vpl;
CREATE TABLE rmyvlakh_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES rmyvlakh_vpl WRITE;
INSERT INTO rmyvlakh_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Данглал о Дэл стердя о нэбо тай э пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Э пхув сас бимуестери и шушы, о калимос сас понадэ баря паенца, и о Духо лэ Дэвлэско вурялас понадэ паи. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","И пхэндя о Дэл: — Мэк авэл о вудуд, — и авиля о вудуд. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","О Дэл додикхля, со о вудуд драго, и розашадя лэс лэ калимастар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","О Дэл дя алав лэ вудудэсти «о дес», ай лэ калимасти «э рят». Сас вэчеро, и сас тэсара — дес англуно. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","И пхэндя о Дэл: — Мэк авэл сводо машкара пая, кай тэ розашавэл о паи лэ паестар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","О Дэл стердя о сводо тай розашавдя о паи понадэ сводо лэ паестар тала лэстэ, и ашыля кадя. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","О Дэл дя алав лэ сводости «нэбо». Сас вэчеро, и сас тэсара — дес дуйто. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","И пхэндя о Дэл: — Мэк истидэнпэ екхтанэ э пая понадэ нэбо, тай тэ авэл о шукимос, — и ашыля кадя. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","О Дэл дя алав лэ шукимасти «пхув», ай э паенди, савэ стидэпэ, дя алав «море». И додикхля о Дэл, со када драго. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","— Тэ барярэл пэ пхув баряримос: чяря, савэ анэн сымбуря, тай савори порода каштэндери, савэ анэн э плодуря кокалэнца, — пхэндя о Дэл, тай ашыля кадя. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Э пхув барярдя баряримос: савори порода чяряти, савэ анэн сымбуря, тай савори порода каштэндери, савэ анэн э плодуря кокалэнца. И додикхля о Дэл, со када драго. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Сас вэчеро, и сас тэсара — дес трито. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","И пхэндя о Дэл: — Мэк авэн вудуда по машкар нэбо, соп тэ розашавэл о дес ла рятятар, и мэк вонэ авэна э знакуря, соп тэ гатярэн э время, э деса тай э бэрша. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Мэк вонэ пхабон по машкар лэ нэбоско, соп тэ дичёл э пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","О Дэл стердя дуй барэ вудуда — баро вудуд, соп тэ хулаинас десэ, тай майцыкно вудуд, соп тэ хулаинас рятэ, ай кадя жэ Вов стердя э чергая. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","О Дэл стходя лэн по сводо лэ нэбоско, кай вонэ тэ дичёл э пхув, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","соп тэ хулаинэн десэ и рятэ тай тэ розашавэн о вудуд лэ калимастар. И додикхля о Дэл, со када драго. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Сас вэчеро, и сас тэсара — дес штарто. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","О Дэл пхэндя: — Мэк жувэл андо паи жундимос, ай понадэ пхув па нэбоско сводо тэ вурян э черэкля. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","О Дэл стердя барэ паенго жундимарэн тай савори порода ла жундимастери, сави пхэрдо жувэл андо паи, тай саворэ породуря пхакалэн черэклян. И додикхля о Дэл, со када драго. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","О Дэл бахталисардя лэн и пхэндя: — Анэн бэятонэн, кай тэ авэл тумэн майбут, кай тэ пхэрдён э барэ пая. Тай пэ пхув мэк авэна майбут э черэклян. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Сас вэчеро, сас тэсара — дес панчто. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","И пхэндя о Дэл: — Тэ виндярэл э пхув пэстар савори порода ла жундимастери: лэ череско скотос, цыкно пхуяко жундимос, тай саворэ породуря лэ вэшэско жундимаско, — и ашыля кадя. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","О Дэл стердя саворэ породуря лэ вэшэско жундимаско и саворэ породуря лэ череско скотоско, тай саворэ породуря цыкно пхуяко жундимаско. И додикхля о Дэл, со када драго. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Тунче о Дэл пхэндя: — Стерам лэ манушэс — па Амаро образо, сар Амэ — мэк авэл вов хулай пэ барэ паести маще и лэ нэбости черэкля, по черэско ското, пэ ся пхув тай пэ ся цыкно пхуяко жундимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Кадя о Дэл стердя лэ манушэс па Пэско образо, па образо лэ Дэвлэско Вов стердя лэс, лэ муршэс и ла жувля Вов стердя лэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","О Дэл бахталисардя лэн и пхэндя: — Анэн бэятонэн, кай тэ авэл тумэн майбут, кай тэ пхэрдён ся пхув и авэн раенца пэр латэ. Авэн хулаенца пэ барэ паести маще, и пэ нэбости черэкля, тай пэ ся жундимос, саво пхирэл пай пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Тунче о Дэл пхэндя: — Мэ дав тумэнди саворэ чяря лэ сымбуренца па ся пхув и саворэ кашта, савэ дэн плодуря кокалэнца. Вонэ авэна важ тумэнди хамаса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ай саворо жундимос пай ся пхув, и саворэ лэ нэбостерэ черэклянди, тай саворэ цыкно пхуяко жундимос — саворэнди, андэ кастэ пхурдэл о жувимос, — Мэ дав савори чяр тэ хан. И ашыля кадя. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","О Дэл подикхля пэ ся, со Вов стердя, и ся сас фартэ драго. Сас вэчеро, и сас тэсара — дес шовто. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Кадя сас стердо о нэбо тай э пхув и ся, со исы тай, со жувэл котэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Андо ефтато дес о Дэл стердя э бути, сави Вов терэлас, и андо ефтато дес Вов на терэлас бути, сави терэлас майанглал. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","О Дэл бахталисардя о ефтато дес и стердя лэс тэ авэл свынто, пала кода кай андэ кадыва дес о Дэл парашыля тэ терэл Пэстери бути, сави Вов терэлас. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Акэ э дума пала о нэбо тай э пхув, кала вонэ сас стердэ. Андо дэс, кала о РАЙ Дэл терэлас о нэбо тай э пхув, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","пэ пхув тунче инке на сас ни маляко кустарнико, ни маляти чяр. Тунче о РАЙ Дэл на бишалэлас пэ пхув брышынд, и на сас лэ манушэс, соп тэ терэл бути ла пхувяса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Кати э лэн ваздэласпэ андай пхув и тиндярэлас ла ся. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Тунче о РАЙ Дэл стердя лэ манушэс анда ла пхуятери чик и пхурдя лэсти андо нак пхурдимос жувимаско, и ашыля о мануш жундо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","О РАЙ Дэл вибарярдя садо пэ тэсарастери риг, андо Эдэмо, и стходя инчя лэ манушэс, савэс Вов стердя. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","О РАЙ Дэл вибарярдя андай пхув саворэ кашта, пэ савэ сас драго тэ дикхэс и тэ хас пар лэндэ. По машкар андо садо барёнас о кашт лэ жувимаско тай о кашт, саво дэл тэ ганэл о лашымос и о вырытимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Анда Эдэмо питялас бари лэн, сави тиндярэлас о садо, ай майанглэ вой росжаласпэ пэ штар аврэ лэна. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Пэрво лэн акхарэласпэ Пишоно: вой питял пай саворэ рига ся пхув Хавила, кай исы о сомнак. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","О сомнак анда кодыя пхув лашо, и инке котэ исы э смола, сави драго кхандэл, тай о кучютно бар шохамо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Э дуйто лэн акхарэласпэ Гихоно, вой обпитял пай саворэ рига ся пхув Кушо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Э трито лэн акхарэласпэ Тигро, вой питял каринг о тэсарастери риг лэ Ашурастар. Ай э штарто лэн — када о Евфрато. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","О РАЙ Дэл стходя лэ манушэс андо Эдэмско садо, кай вов тэ терэл бути андо садо и тэ фирий лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","О РАЙ Дэл припэндя лэ манушэсти: «Ту ха э плодуря па саворо кашт андо садо, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ай па кашт, саво дэл тэ ганэл о лашымос и о вырытимос, на ха, пала кода со андо дес, кала ту хаса о плодо, ту чячес мэрэса». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","О РАЙ Дэл пхэндя: «Найдраго лэ манушэсти тэ авэл екхжэно. Мэ терава лэсти помошникос кацавэс, сар вов». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","О РАЙ Дэл стердя андай пхув саворэн ла вэшэстерэн жундимарэн и саворэн лэ нэбостерэн черэклян. Вов андя лэн каринг о мануш, соп тэ дикхэл, сар о мануш дэла лэнди алава. Сар о мануш припхэндя кажнонэсти жундимарэсти о алав, кадя и ашыляпэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Кадя о мануш дя алава савэрэсти черэско скотости, саворэнди нэбостерэнди черэклянди тай саворэнди вэшонэнди жундимарэнди. Но важ о Адамо на аракхляпэ кацаво помошнико, сар вов. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Тунче о РАЙ Дэл совлярдя лэ манушэс, и кала вов совэлас, виля екх лэско рэбло и пхандадя кода тхан лэ масэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Анда рэбло, саво Вов виля анда мануш, О РАЙ Дэл стердя ла жувля и андя ла каринг лэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","О мануш пхэндя: — Акэ вой кокало мэрнэ кокалендар и мас мэрнэ масэндар: вой авэла тэ акхарэлпэ «ромни», пала кода кай ла линэ анда ром. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Акэ пала со о мануш ашавэла лэ дадэс и ла да и приашэла кай пэстери ромни, тай э дуй ашэна екх тила. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","О Адамо и лэсти ромни лэдуй саслэ нангэ и на лажанас. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","О сап сас майфранто саворэ вэшэнго жундимастар, савэн стердя о РАЙ Дэл. Вов пушля кай э жувли: — Чячес ли пхэндя о Дэл: «На хан ни па саво кашт андо садо»? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Э жувли пхэндя лэ сапэсти: — Амэ хас э плодуря саворэн каштэндар андо садо, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","но о Дэл пхэндя: «На хан э плодуря па кашт, саво помашкар садо, и на лэнпэ лэндэ, ай со тумэ мэрэна». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","— Най, тумэ на мэрэна, — пхэндя о сап лэ жувляти. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","— О Дэл ганэн, со кала тумэ хана лэн, пхэрнадёна тумарэ якха и тумэ ашэна, сар о дэвла, савэ ганэн о лашымос и о вырытимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Тунче э жувли додикхля, со о плодо лэ каштэско лашо тэ хас и драго тэ дикхэс. О кашт кодыва фартэ чялёлас, пала кода со дэлас годи. Жувли ля екх плодо и халя. Вой дя о плодо лэ ромэсти, саво сас паша латэ, и вов кадя ж лэс похаля. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Пхэрнадилэ э якха лэндэ, и вонэ полинэ, со саслэ нангэ. Тунче судэ инжырни листуря, соп тэ гаравэн пэско нангимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Андо вэчеро, кала ашыля майшудро, пхурдя балвалоры, и вонэ ашундэ, сар о РАЙ Дэл пхирэл па садо. О Адамо и лэсти ромни гарадилэ лэ РАЕСТАР Дэвлэстар машкара кашта андо садо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","О РАЙ Дэл акхардя лэ Адамости: — Кай ту сан? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","О Адамо пхэндя: — Мэ ашундэм Тут андо садо и пэрэдарайлэм, пала кода со мэ сым нанго, акэ мэ и гарадилэм. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Вов пушля лэстар: — Ко пхэндя тути, со ту нанго? Ту со, халян э плодуря па кашт, па саво Мэ припхэндэм тути тэ на хас? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","О Адамо пхэндя: — Э жувли, савя Ту дян манди, соп вой тэ авэл манца, — када вой дя манди о плодо па кодыва кашт, и мэ похалэм лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Тунче РАЙ Дэл пхэндя ла жувляти: — Со ж ту када тердян? Э жувли пхэндя: — Када о сап хохадя ман, и мэ халэм. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Тунче о РАЙ Дэл пхэндя лэ сапэсти: — Пала кода, со ту када тердян, дав амрая тут майбут, сар саворо черэско ското и саворо вэшэско жундимос! Ту авэса тэ пхирэс по йило и тэ хас э чик андэ саворэ терэ деса, скати жувэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Мэ стхава вырыцыя машкара тутэ и жувли и машкара терэ бэяцэ и лати бэяцэ: вов авэла тэ умарэ тут андо шэро, ай ту авэса тэ дэндалэс лэсти э талпа. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ай лэ жувляти пхэндя: — Мэ стерава, со теро пхаримос авэла андо грижа: ту анэса бэятонэн андэ дукх. Ту камэса тэ авэс э хулаи лэ ромэсти, ай вов авэла о хулай важ тутэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Лэ Адамости жэ Вов пхэндя: — Кадя сар ту канглян теря ромня и похалян о плодо па кашт, пала саво Мэ припхэндэм тути: «На ха лэстар», дав амрая пала тутэ э пхув: андэ пхари бути ту авэса тэ дорэсэс о марно латар андэ ся теро жувимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Э пхув вибарярэла тути пусавдэ и вырытонэ чяря, ту авэса тэ хас кода, со барёл пэ мал. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Андэ пхари бути авэса тэ затерэс пэсти о марно, жы кай на рисавэса андэ чик, анда сави санас лино. Ту сан чик, и андэ чик ту рисайвэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","О Адамо дя алав пэстя ромняти Ева, пала кода со вой ашыля дэй саворэнди, ко жувэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","О РАЙ Дэл стердя лэнди йида андай гаравля и стходя ла по Адамо и пэ лэсти ромни. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Тунче о РАЙ Дэл пхэндя: — О мануш угангля о лашымос тай о вырытимос и ашыля акана, сар екх Амэндар. Нащи, кай вов тэ процырдэл о васт тай тэ шынэл о плодо па кашт лэ жувимоско. Сар вов похала лэс, авэла тэ жувэл и на мэрэла. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","И о РАЙ Дэл витрадя лэ Адамос анда садо Эдэм, соб вов тэ терэл бути пэ пхув, анда сави сас лино. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Сар о РАЙ витрадя лэ манушэс, Вов стходя по тэсараско риг лэ Эдэмостар лэ херувимонэн и бари ягатери шури, сави марэлас андэ саворэ рига, соп тэ фирин о дром каринг о кашт лэ жувимаско. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","О Адамо сутя ла Еваса, пэстеря ромняса, и вой ашыля лэстар пхари и андя лэ Каинос. Вой пхэндя: «Сар о РАЙ, кадя и мэ тердэм манушэс». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Тунче вой андя лэ Авелёс, лэсти пхралэс. О Авелё барярэлас лэ бакрэн и бузнэн, ай о Каино терэлас бути ла пхувяса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Черэз сави-то время о Каино андя даро лэ РАЕСТИ э плодуря лэ пхуяти, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","ай о Авелё андя майчиченалэн англунэн аракхадэн бакрэн. О Авелё и лэско даро чялилэ лэ РАЕСТИ, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ай о Каино и лэско даро на чялилэ Лэсти. О Каино росхоляйля, и лэско муй калиля. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Тунче пхэндя о РАЙ лэ Каиности: — Состар ту холяйвэс? И состар теро муй калиля? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Сар кай ту терэс мишто, то на ваздэса ли о шэро? Ай сар терэс наймишто, то паша терэ вудара пригарадиля о бэзэх: вов камэл тэ авэс теро хулаеса, но ту трэбуй тэ хулаис пар лэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","О Каино пхэндя пэстерэ пхралэсти лэ Авелёсти: — Авэн манца андэ мал. И кала вонэ саслэ котэ, о Каино збисайля пэ пэско пхрал по Авелё и умардя лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Тунче о РАЙ пхэндя лэ Каиности: — Кай теро пхрал о Авелё? — На ганав, — пхэндя Каино. — Хэба мэ сым фирисари мэрнэ пхралэсти? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","О РАЙ пхэндя: — Со ж ту тердян? О рат терэ пхралэско цыпий каринг Мандэ андай пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Акана Мэ тут дав амрая, витрадав пай пхув, сави пхэрнадиля пэско муй, соп тэ прилэл о рат терэ пхралэско, савэс ту умардян пэстерэ вастэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Кала ту авэса тэ терэс бути ла пхувяса, вой на авэла тэ дэл тути плодуря. Ту авэса пай пхув пхирэл, сар бичерэско. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","О Каино пхэндя лэ РАЕСТИ: — Путинимос пала мэрни дош майпхаро, сар мэ трэбуй тэ заандярав. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Акана Ту витрадэс ман андай пхувяко муй, и Терэ муестар мэ гарадювава. Авава тэ пхирав пай пхув, сар бичерэско, и англуно мануш, саво попэрдёла по дром, умарэла ман. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Но о РАЙ пхэндя лэсти: — Най. Сар кай ко умарэла лэ Каинос, важ кода колэсти рисайвэла ефта молуря. И о РАЙ стердя лэ Каиности знако, кай нико, ко дикхэлапэ лэса, тэ на умарэл лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","О Каино жылятар лэ РАЕСТАР и жувэлас пэ пхув Нодо, сави сас каринг о востоко лэ Эдэмоско садостар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","О Каино сутя пэстеря ромняса, и вой ашыля лэстар пхари и андя лэ Ханохос. Андэ кодыя время о Каино стердя форо и дя лэсти алав па пэско шаво Ханохо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Кай о Ханохо аракхадилэпэ о Ирадо, кай о Ирадо аракхадиля Мехиаэло, кай о Мехиаэло аракхадиля Метушаэло, кай о Метушаэло аракхадиля о Ламехо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","О Ламехо ля пала пэстэ дуен ромнян: екха акхарэнас Ада, ай авря Цыла. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Э Ада андя лэ Ивалос: вов ашыля дадэса калэнди, ко жувэн андэ катунэ и вибарярэн о черэско ското. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Лэстерэ пхралэс акхарэнас Ювало: вов ашыля дадэса саворэнди, ко челэл па лира тай пэ свирели. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Кай э Цыла сас шаво Тувал-Каино, саво терэлас праматяти анда састри и андай харком. Кай о Тувал-Каино сас пхэй Наама. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","О Ламехо пхэндя пэстерэ ромнянди: — Адо и Цыло, ашунэн ман! Ромня лэ Ламехости, полэн мэрни дума! Мэ умардэм муршэс важ када, со вов шындя ман, тэрнэ манушэс важ када, со вов дядап ман. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Сар кай важ о Каино мардёна ефта молоря, то важ о Ламехо — ефтадэша ефта. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","О Адамо инке сутя пэстя ромняса, и вой андя шавэс и дя лэсти алав Сифо, вой пхэнэлас: «О Дэл дя манди андо даро аврэс бэятос важ о Авелё, савэс умардя о Каино». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Кай о Сифо кадя ж сас шаво, и вов дя лэсти алав Еносо. Андэ кодыя время э мануша линэ тэ тэлён РАЕСТИ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Акэ э дума пала Адамо тай лэстерэ потомкуря. Андо дес, кала о Дэл стердя лэ манушэс, Вов стердя лэс кацаво, сар о Дэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Вов стердя лэ муршэс и лэ жувля и бахталисардя лэн. Андо кодва дес о Дэл акхарда лэн «мануш». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Кала о Адамо прожудя 130 бэрша, лэстэ аракхадиля шаво, лэско образо, саво сас кацаво, сар вов, и вов дя лэсти алав Сифо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Тунче сар аракхадиляпэ о Сифо, о Адамо жудя 800 бэрша, и лэстэ сас инке шавэ и щея. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Ся о жувимос лэ Адамоско сас 930 бэрша, и вов муля. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Кала о Сифо прожудя 105 бэрша, лэстэ аракхадиля о Еносо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Тунче, сар аракхадиляпэ о Еносо, о Сифо жудя 807 бэрша, и лэстэ сас инке шавэ и щея. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Ся о жувимос лэ Сифоско сас 912 бэрша, и вов муля. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Кала о Еносо прожудя 90 бэрша, лэстэ аракадиля о Каинано. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Тунче, сар аракхадиляпэ о Каинано, о Еносо жудя 815 бэрша, и лэстэ сас инке шавэ и щея. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Ся о жувимос лэ Енососко сас 905 бэрша, и вов муля. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Кала о Каинано прожудя 70 бэрша, лэстэ аракхадиля о Махалалэло. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Тунче, сар аракхадиляпэ о Махалалэло, о Каинано жудя 840 бэрша, и лэстэ сас инке шавэ и щея. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Ся о жувимос лэ Каинаноско сас 910 бэрша, и вов муля. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Кала о Махалалэло прожудя 65 бэрша, лэстэ аракхадиля о Яредо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Тунче, сар аракхадиляпэ о Яредо, о Махалалэло жудя 830 бэрша, и лэстэ сас инке шавэ и щея. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Ся о жувимос лэ Махалалэлоско сас 895 бэрша, и вов муля. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Кала о Яредо прожудя 162 бэрша, лэстэ аракхадиля о Енохо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Тунче, сар аракхадиляпэ о Енохо, о Яредо жудя 800 бэрша, и лэстэ сас инке шавэ и щея. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Ся о жувимос лэ Яредоско сас 962 бэрша, и вов муля. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Кала о Енохо прожудя 65 бэрша, лэстэ аракхадиля о Мафусало. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Тунче, сар аракхадиляпэ о Мафусало, о Енохо пхирэлас лэ Дэвлэса 300 бэрша, и лэстэ сас инке шавэ и щея. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","О Енохо дожудя жы каринг э 365 бэрша. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","О Енохо жувэлас лэ Дэвлэса, тунче лэс на ашыля, пала кода со о Дэл заля лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Кала о Мафусало прожудя 187 бэрша, лэстэ аракхадиля о Ламехо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Тунче, сар аракхадиляпэ о Ламехо, о Мафусало жудя 782 бэрша, и лэстэ сас инке шавэ и щея. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Ся о жувимос лэ Мафусалоско сас 969 бэрша, и вов муля. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Кала о Ламехо прожудя 182 бэрша, лэстэ аракхадиля шаво. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Вов дя лэсти алав Ноё и пхэндя: «Вов дэла амэнди тэ отчиював андэ пхари бути пэ пхув, савяти о РАЙ дя амрая». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Тунче, сар аракхадиляпэ о Ноё, о Ламехо жудя 595 бэрша, и лэстэ сас инке шавэ и щея. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Ся о жувимос лэ Ламехоско сас 777 бэрша, и вов муля. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Кала лэ Ноёсти ашыля 500 бэрша, лэстэ аракхадилэ шавэ о Симо, о Хамо тай о Яфето. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Сар ашыля майбут лэ манушэн пэ пхув, лэндэ аракхадёнаспэ э щея. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Э шавэ лэ Дэвлэсти додикхлэ, со э щея лэ манушэнди шукарнэ, и ашыле лэн тэ лэн пала пэстэ, кажно лэлас кола, сави лэсти чялиля. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","О РАЙ пхэндя: — Най пэ всявори время авэла Мэрно Духо андо мануш. Вов исы тила, Мэ дав лэнди 120 бэршэн о жувимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Андэ кола деса ай тунче сас пэ пхув фартэ нефилимуря, кала э шавэ лэ Дэвлэсти лэнас пала пэстэ лэ манушэндерэ щеян и лэндэ аракхадёнас бэяцэ лэндар. Кода саслэ зоралэ тай ашундэ мурша лэ пхуранятеря времятар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","О РАЙ дикхля, со э мануша ашыле билажавардэ, и ся лэнди гындуря цырдэнас лэн каринг о холи. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","О РАЙ тынгосардя, со стердя лэ манушэс пэ пхув, и Лэско ди пхэрдиля дукхаса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","И пхэндя о РАЙ: — Мэ потасавава ся лэ манушэнди порода, сави Мэ стердэм. Мэ потасавава лэ манушэн, баро и цыкно пхуяко жундимос и лэ нэбостерэн черэклян. Мэ тынгой, со стердэм лэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ай о Ноё аракхля тынгимос англа лэ РАЕСТИ якха. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Акэ э дума пала Ноё тай лэстерэ родуря. Машкара э мануша кола времяти екх о Ноё сас чячюно и бидошако, вов пхирэлас лэ Дэвлэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Кай о Ноё сас трин шавэ: о Симо, Хамо тай Яфето. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Англа лэ Дэвлэсти якха э пхув римосайля и пхэрдиля холяса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","И о Дэл дикхэл, сар э пхув римосайля пала кода, кай саворо жундимос пэ пхув пэрэбандиле пэстерэ дрома. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Тунче о Дэл пхэндя лэ Ноёсти: — Миримос саворэнди, со жувэн! Пала лэндэ пхэрдиля э пхув вырытимаса. Мэ умарава лэн екхатанэ ла пхувяса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Стер тути ковчего анда кипарисово кашт, и стер андрэ лэстэ чера, и помакх лэс смоласа андрал и упрал. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Акэ, сар ту лэс стерэса: о ковчего трэбуй тэ авэл 150 метруря андо лунгимос, 25 метруря андо буглимос, и 15 метруря андо вучимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ушарав лэс, кай тэ авэл майупрэ пэ епаш метро лэ ковчегостар. Стхов ла ригатар э вудара и стер тылуно, машкаруно и упруно этажо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Мэ анава пэ пхув баро паи и потасавава ся, со жувэл тэла нэбо, ся, андэ кастэ пхурдэл жувимос. Ся, со исы пэ пхув, похасайвэла. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ай туса Мэ терава завето, и ту зажаса андо ковчего — ту, и терэ шавэ, и тери ромни, и э ромня терэ шавэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Заандяр андо ковчего саворо жундимос пай дуйжынэ, муршэс и жувляс, соп вонэ тэ ашэнпэ жундэ екхтанэ туса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Карик тутэ авэна, кай кадя жэ тэ ашэнпэ жундэ, по дуй саворэ породатар черэклян, саворэ породатар баро тай цыкно пхуяко жундимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Лэ пэса саворо хамос, стидэ лэ екхэтанэ, соп тэ правардёс ту и вонэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","О Ноё стердя ся кадя, сар пхэндя лэсти о Дэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","О РАЙ пхэндя лэ Ноёсти: — Зажа андо ковчего саворэ ереса. Мэ дикхав, со машкар саворэ, ко жувэл адес, екх ту кати чячюно сан англа Мандэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Лэ пэса пай ефта пай дуйжынэ саворэндар вужэндарэ жундиматар, лэс и ла, и пай дуйжынэ лэ найвужэндар жундиматар, лэс и ла, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","и пай ефта паруря саворэндар черэкляндар, лэс и ла, соп тэ фиринпэ лэндар инке пэ пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Черэзэ ефта деса Мэ бишалава брышынд пэ пхув пэ саранда деса тай пэ саранда рятя, и Мэ потасава ся, со исы жундо пэ пхув, ся, со Мэ стердэм. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","О Ноё стердя ся, сар припэндя лэсти о РАЙ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Кала о паи авиля пэ пхув, лэ Ноёсти сас шовшэла бэрша. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","О Ноё, лэсти шавэ, лэсти ромни тай э ромня лэсти шавэн зажылэ андо ковчего, соп тэ фиринпэ лэ паестар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Э вужэ тай э найвужэ жундимата, э черэкля тай саворо жундимос ");
INSERT INTO rmyvlakh_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","авилэ каринг о Ноё и зажылэ андо ковчего пай дуйжынэ, вов и вой, сар припхэндя о Дэл лэ Ноёсти. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Прожылэ ефта деса, и пэ пхув жыля о брышынд. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Кала лэ Ноёсти сас шовшэла бэрша, андо дэшуефтато дес дуйтонэ шонэстар, прошындилэ саворэ хаинга лэ барэ паёсти, отпхэрнадилэ э фэлястрэ лэ нэбости, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","и шорэлас пэ пхув о брышынд саранда деса тай саранда рятя. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Андэ кодыва жэ дес зажылэ андо ковчего о Ноё, лэстерэ шавэ о Симо, Хамо тай о Яфето, э ромни лэ Ноёсти и э трин ромня лэстерэ шавэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","И лэнца зажылэ саворэ породуря лэ жундимастерэ: саворэ породуря лэ вэшэстерэ жундимата, черутно ското, саворэ породуря пхуяко жундимос, саворэ породуря лэ черэклэн, саворо пхакало жундимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Саворэ, андэ кастэ пхурдэл жувимос, авилэ каринг о Ноё и зажылэ андо ковчего по дуй, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","вов и вой андай саворэ породуря, сар припхэндя о Дэл лэ Ноёсти. И тунче о РАЙ пхандадя пала лэстэ э вудара. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","О потопо сас пэ пхув саранда деса. О паи авэлас и звазгля о ковчего, и вов жыля па паи. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","О паи ся ваздэласпэ и ваздэласпэ, ай о ковчего жалас па паи. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","О паи кадя вучес вазгляпэ пэ пхув, со ушарадя саворэ вуче плая тэла нэбо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","О паи вазгляпэ и ушарадя саворэ плая майвучес, сар пэ ефта епашэса метруря. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Ся, со сас жундо пэ пхув, похасайля: э черэкля, о ското, о вэшэско жундимос, жундимос, саво пхирэл гуртоса пай пхув, тай саворэ мануша. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Ся, со сас пэ пхув жундо, со пхурдэлас и жувэлас, ся похасайля. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Похасайля ся, со сас жундо пэ пхув, сас ся хасайля ла пхувятар: э мануша тай э жундима, тай пхуяко жундимос, тай э черэкля лэ нэбости. Ашыляпэ екх о Ноё, тай кола, ко сас лэса по ковчего. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","О потопо лэлас зор пэ пхув шэл и панчдэша деса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","О Дэл на бистардя пала Ноё и палай саворэ вэшэско жундимос тай пала ското, савэ сас лэса андо ковчего. Вов бишалдя э балвал пэ пхув, и о паи ашыля тэ ужалтар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Э хаинга лэ барэ паести тай э фэлястрэ лэ нэбости запхандадилэпэ, и о брышынд парашыля тэ жал пай нэбо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","О паи найито ужалас пай пхув, и каринг о шэл панчдэшто дес вов фартэ ужылятар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","По ефтадэшто дес ефтатерэ шонэстар о ковчего тэрдиля пэ Араратски плая. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","О паи жаластар жы каринг о дэшто шон, и андо пэрво дес андо дэшто шон линэ тэ дичён о вэрхо лэ плаенго. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Прожылэ саранда деса, и о Ноё отпхандадя э фэлястра, сави вов стердя андо ковчего, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","и вяшадя лэ воронос, и вов вивурялас и привурялас палпалэ жы кола времятэ, сар вишутиля э пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Тунче о Ноё вяшадя лэ голубос, соп тэ дикхэл, ужыля ли о паи упрал пай пхув, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","но о голубо на аракхля шуко тхан, соп тэ прибэшэл, и рисайля каринг о Ноё андо ковчего, пала кода со о паи ушарадя ся пхув. О Ноё процырдя о васт и ля лэ голубос каринг пэстэ андо ковчего. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Прожылэ ефта деса, и вов упалэ вяшадя лэ голубос анда ковчего. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Кала увэчери о голубо рисайля, андо муй лэстэ сас тэрно листо анда оливково кашт. Тунче о Ноё поля, со о паи жылятар пай пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Вов поаштярдя инке ефта деса и упалэ вяшадя лэ голубос, и вов бутэр на рисайля. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Карик о англуно дес англунэ шонэско шовшэл екхэскэ бэршэско лэ Ноёстерэ жувимасти э пхув вишутиля лэ паестар. О Ноё одпхандадя ушарди лэ ковчегоско и дикхля, со э пхув шуки. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Карик биштай ефтато дес дуйтонэ шонэстар э пхув ся сас шуки. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Тунче о Дэл пхэндя лэ Ноёсти: ");
INSERT INTO rmyvlakh_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","— Вижа анда ковчего, ту и тери ромни, терэ шавэ и лэнди ромня. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Виндяр аври ся, со исы жундо, со исы туса, — э черэкля, э жундимос, саво пхирэл па пхув, соп вонэ тэ пхэрэн э пхув, и тэ анэн бэятонэн тэ ашэн майбут пэ пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","О Ноё вижыля анда ковчего екхтанэ пэстерэ шавэнца, ла ромняса и э ромня лэ шавэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Баро тай цыкно пхуяко жундимос, и саворэ черэкля, — ся, со пхирэл пай пхув, — вижылэ анда ковчего пэстеря породаса, екх пала екхэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","О Ноё стердя лэ РАЕСТИ жэртвенико и андя пэр лэстэ жэртва: ля коисавэн андай саворэ вужэ скотонэндар тай лэ черэкляндар, зашындя лэн тай спхабардя пэ яг. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","О РАЙ ашундя лэ накхэса лашо фано и пхэндя андо ди Пэсти: — Никала акана на авава Мэ тэ дав амрая э пхув пала мануш, хоть анда бэятонэндерэ времятар оди лэ манушэско цырдэлпэ каринг э холи. И никала акхана на умарава саворо жундимос, сар тердэм екхатар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Андэ саворэ деса ла пхуятерэ на парашэла время, кала росшон о ворзо и кала стидэн о ворзо; на парашэна о шудримос тай о татимос, о милай тай о йивэн, о дес тай э рят. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","О Дэл бахталисардя лэ Ноёс и лэстерэ шавэн и пхэндя лэнди: — Тэ анэн э бэятонэн, соп тумэн тэ авэл майбут пай пхув, тай пхэрэн ла. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Мэк саворо жундимос пэ пхув, и саворэ черэкля нэбостерэ, и саворо жундимос, саво пхирэл па пхув, и саворэ паестерэ маще даран тай издран тумэндар. Мэ отдэм лэн андэ тумарэ васта. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Саворо пхуяко жундимос, авэла важ тумэнди хамаса. Сар данглал Мэ дэм тумэнди э зэлэно чяр, кадя и екхатар Мэ отдав тумэнди ся. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Но на хан о мас, андэ саво исы инке о рат. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","И пала тумаро рат Мэ саекх мангава роспотинимос. Мэ мангава роспотинимос важ лэстэ кажнонэстар жундимостар, и кажнонэстар манушэстар Мэ кадя жэ пушава важ лэско жувимос лэско пхралэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Ко умарэла манушэс, колэс манушэс умарэла авэр мануш. Пала кода со о мануш стердо па образо лэ Дэвлэско. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Тумэ жэ анэн бэятонэн, соп тумэн тэ авэл майбут, розжанпэ пай пхув и терэнпэ майбут пэр латэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Тунче о Дэл пхэндя лэ Ноёсти и лэстерэ шавэнди: ");
INSERT INTO rmyvlakh_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","— Адес Мэ дав завето тумэнди и тумарэ бэяцэнди, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","и саворэ жундимасти, савэ сас тумэнца, — черэклянди, скотости и вэшэско жундимасти, — саворэнди, ко вижыля тумэнца анда ковчего, — саворэсти жундимасти пэ пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Мэ дав тути завето: никала упалэ ся, со исы жундо, на авэла тасавдо лэ паестерэ потопоса, никала упалэ о паи на затасавэла э пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","О Дэл пхэндя: — Акэ знако лэ заветоско, саво Мэ дав тумэнди, и кажнонэсти жундимасати, саво тумэнца, пэ саворэ родуря, савэ авэна. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Мэ стхав андэ тучюря Мэрни радуга, и вой авэла знако лэ заветоско машкара Мандэ и машкара э пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Кала Мэ бишалава э тучюря пэ пхув, андэ тучюря авэла э радуга, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","и Мэ сэрэсарава пала Мэрно завето машкара Мандэ и тумэндэ и кажнонэ жундимаса, никала акана э пайя на шорэнапэ, соп тэ потасавэн ся, со исы жундо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Всако разо, кала э радуга авэла андэ тучюря, Мэ додикхава ла и сэрэсарава о вико завето машкара Дэл и машкара саворэ жундимаса, савэ исы пэ пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Кадя пхэндя о Дэл лэ Ноёсти: — Акэ о знако лэ заветоско, саво Мэ дэм саворэсти, со исы жундо пэ пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Э шавэ лэ Ноёсти, савэ вижылэ анда ковчего, када о Симо, о Хамо тай о Яфето (о Хамо — када дад лэ Ханааности). ");
INSERT INTO rmyvlakh_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Акала э трин — шавэ лэ Ноёсти, и лэндар аракхадилэпэ э мануша, савэ розжылэпэ пай ся пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","О Ноё ашыля тэ терэл бути ла пхувяса и тэ барярэл о виноградо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Екхвар вов пиля о чехыри, матиля и пашлёлас нанго андэ пэсти катуна. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","О Хамо, о дад лэ Ханааности, дикхля нангэс пэстерэ дадэс и роспхэндя пала када пэстерэ пхралэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Ай о Симо тай о Яфето линэ э йида, стходэ ла пэсти пэ пхикэ и жылэ палпалэ думэнца, и ушарадэ пэстерэ нангэс дадэс. Лэндерэ муйя саслэ отрисардэ андэ авэр риг, соп вонэ тэ на дикхэн нангэс пэстерэ дадэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Кала о Ноё просутяпэ чехырятар и угангля, со тердя лэса лэско цыкно шаво, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","вов пхэндя: — Придав амраяти лэ Ханаанос! Вов авэла майпалуно лэ копэлендар важ пэстерэ пхралэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","И инке вов пхэндя: — Бахтало о РАЙ, о Дэл лэ Симоско! Тэ авэл о Ханаано лэско копэли. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Тэ дэл о Дэл Яфетости майбуглэ пхуя! Тэ жувэл о Яфето андэ катунэ лэ Симости, ай о Ханаано тэ авэл лэско копэли. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Сар прожыля о потопо, о Ноё жудя триншэла панчдэша бэрша. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Ся о жувимос лэ Ноёско сас иняшэла панчдэша бэрша, и вов муля. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Акэ э дума пала Ноёстерэ шавэ Симо, Хамо тай Яфето тай пала лэндерэ потомкуря. Сар прожыля о потопо, лэндэ аракхадилэпэ шавэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Шавэ лэ Яфетостерэ: о Гомеро, о Магого, о Мадаё, о Явано, о Тувало, о Мешэхо тай о Тирасо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Э шавэ лэ Гомерости: о Ашкеназо, о Рифато тай о Тогарма. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Э шавэ лэ Яваности: о Элиша, о Таршышо, о Китимо тай о Доданимо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","(Акалэндар аракхадилэпэ э народуря, савэ ашылэ тэ жувэл пэ пхув паша баро паи. Вонэ розжылэпэ па пэстерэ народуря, родуря тай шыба). ");
INSERT INTO rmyvlakh_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Э шавэ лэ Хамости: о Кушо, о Мицраимо, о Путо тай о Ханаано. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Э шавэ лэ Кушости: о Шэва, о Хавила, о Савта, о Раама тай о Савтеха. Э шавэ лэ Раамасти: о Шэва тай о Дедано. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","О Кушо сас кадя жэ дад лэ Нимродости, саво ашыля англуно зорало мануш пэ пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Вов сас зорало астаримари англа РАЙ, пала кода и дэлпэ дума: «Баро астаримари англа РАЙ, сар о Нимродо». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Англунэ форонэнца андэ лэско тхагаримос сас о Вавилоно, о Эрехо, о Акадо тай о Халне андо Шынаро. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Кола пхуятар вов пэрэжыля андэ Ашуро, кай стердя э форуря э Ниневия, о Реховото-Иро, о Калахо ");
INSERT INTO rmyvlakh_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","тай о Ресэно, машкара э Ниневия и о Калахо, — баро форо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Кай о Мицраимо аракхадилэпэ э лудея, э анамея, э легавея, э нафтухея, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","э патрусея, э каслухея (савэндар аракхадилэпэ э филистимлянуря) тай э кафторея. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","О Ханаано сас дад лэ Сидоности (када лэско англуно шаво) тай лэ Хетости. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Лэ Ханааностар аракхадилэпэ э евусея, э аморея, э гиргашэя, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","э хивея, э аркея, э синея, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","э арвадея, э цэмарея тай э хамафея. Прожыля время, и лэ ханааности породэ розлаглэпэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Э брягуря лэ Ханааности процырдэнаспэ лэ Сидоностар каринг о Гераро жы каринг э Газа, ай котар каринг о Содомо, э Гомора, э Адма и о Цэвоимо жы каринг э Лаша. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Акала аракхадилэпэ лэ Хамостар народуря па пэсти порода, пэстеря шыбаса, андэ пэстерэ пхуя. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Аракхадилэпэ шавэ и кай о Симо, кай о барэдэр пхрал лэ Яфетоско. О Симо сас пропапо саворэ шавэнго лэ Еверостерэнго. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Э шавэ лэ Симости: о Еламо, о Ашуро, о Арпахшадо, о Лудо тай о Арамо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Э шавэ лэ Арамости: о Уцо, о Хуло, о Гетэро тай о Мешэхо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Кай о Арпахшадо аракхадиля о Шэлахо, кай о Шэлахо аракхадиля о Еверо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Кай о Еверо аракхадилэ дуй шавэ: екхэс акхарэнас о Пелего (пала кода со андэ лэстерэ время э пхув росшындиля), ай лэсти пхралэс акхарэнас Ёктано. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Кай о Ёктано аракхадилэпэ о Алмодадо, о Шэлефо, о Хацармавето, о Ерахо, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","о Гадорама, о Узало, о Дикла, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","о Овало, о Авимаило, о Шэва, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","о Офиро, о Хавила тай о Ёваво. Саворэ вонэ сас шавэ лэ Ёктаности. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Э пхув, кай вонэ жувэнас, процырдэласпэ лэ Меша жы каринг о Сефаро, плаендери пхув пэ востоко. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Када шавэ лэ Симостерэ па пэстерэ породуря, пэстеря шыбаса, пэ пэстерэ пхуя, пэ пэстерэ народуря. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Кацавэ породуря лэ Ноёстерэ шавэндар, па лэндерэ еря тай па лэндерэ народуря, савэ вижылэ лэндар. Сар прожыля о потопо, лэндар вижылэ саворэ народуря пэ пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Пай ся люма сас екх шыб тай екх дума. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Кала э мануша жанас каринг о востоко, вонэ вижылэ пэ мал андо Шынари и ашылепэ тэ жувэн котэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Вонэ пхэндэ екх екхэсти: — Стерам бара анда чик и випхабарам лэн мишто. Э бара анда чик сас лэндэ пала бара, ай э смола сас, сар састимос важ э бара. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Тунче вонэ пхэндэ: — Стерам амэнди форо башняса жы каринг о нэбо. Кадя амэ ашараса пэстеро алав. Ай сар на тераса када, росжасапэ па ся пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","О РАЙ сжыля тэ дикхэл о форо тай э башня, савэ терэнас э шавэ манушэндерэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","И пхэндя о РАЙ: — Саворэ мануша — екх народо, дэн дума пэ екх шыб. Акэ акада качи майанглуно лэндеро рындо. Акана, со б вонэ на закамле, вонэ са терэна. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Авам жэ и сгамисараса лэнди э шыба, соп вонэ тэ на полэн екх екхэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","И о РАЙ розасадя лэн пай ся муй ла пхуяко, и вонэ парашылэ тэ терэн кодыва форо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Акэ состар кадва форо сас акхардо Вавилоно — котэ о РАЙ сгамисардя э шыба савора люмати, и котар о РАЙ розашардя лэн па ся муй ла пхуяко. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Акэ э дума пала Симо тай лэстерэ потомкуря. Лэ Симости сас шэл бэрша, кала лэстэ аракхадиля о Арпахшадо. Сар сас о потопо, прожылэ дуй бэрша. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Тунче, кала аракхадиля о Арпахшадо, о Симо жудя 500 бэрша, и лэстэ сас инке шавэ и щея. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Кала о Арпахшадо прожудя 35 бэрша, лэстэ аракхадиля о Шэлахо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Тунче, кала аракхадиля о Шэлахо, о Арпахшадо жудя 403 бэрша, и лэстэ инке сас шавэ и щея. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Кала о Шэлахо прожудя 30 бэрша, лэстэ аракхадиля о Еверо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Тунче, кала аракхадиля о Еверо, о Шэлахо жудя 403 бэрша, и лэстэ инке сас шавэ и шея. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Кала о Еверо прожудя 34 бэрша, лэстэ аракхадиля о Пелего. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Тунче, кала аракхадиля о Пелего, о Еверо жудя 430 бэрша, и лэстэ сас инке шавэ и шея. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Кала о Пелего прожудя 30 бэрша, лэстэ аракхадиля о Реуо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Тунче, кала аракхадиля о Реуо, о Пелего жудя 209 бэрша, и лэстэ сас инке шавэ и шея. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Кала о Реуо прожудя 32 бэрша, лэстэ аракхадиля о Серуго. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Тунче, кала аракхадиля о Серуго, о Реуо жудя 207 бэрша, и лэстэ сас инке шавэ и щея. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Кала о Серуго прожудя 30 бэрша, лэстэ аракхадиля о Нахоро. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Тунче, кала аракхадиля о Нахоро, о Серуго жудя 200 бэрша, и лэстэ сас инке шавэ и щея. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Кала о Нахоро прожудя 29 бэрша, лэстэ аракхадиля о Терахо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Тунче, кала аракхадиля о Терахо, о Нахоро жудя 119 бэрша, и лэстэ сас инке шавэ и щея. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Кала о Терахо прожудя 70 бэрша, лэстэ аракхадиля о Аврамо, о Нахоро тай о Арано. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Акэ э дума пала Терахо тай лэстерэ потомкуря. Кай о Терахо аракхадилэ о Аврамо, о Нахоро тай о Арано. Кай о Арано аракхадиля о Лото. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Кала лэско дад о Терахо сас инке жундо, о Арано муля андо Уро Халдеенго, пэ кодва тхан, кай аракхадилян. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","О Аврамо тай о Нахоро линэ пала пэстэ ромнян. Лэ Аврамостеря ромня акхарэнас Сара, ай лэ Нахоростеря ромня — Милка. Вой сас щей лэ Араности. Арано сас о дад ла Милкако тай ла Искако. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Э Сара сас бибэяцэндери, пала кода со вой нащи тэ анэл бэятонэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","О Терахо ля пэсти шавэс лэ Аврамос, Араностерэс шавэс Лотос ай пэстеря боря Сарас, ромня Аврамос, и екхтанэ вонэ вижылэ анда Уро Халдеенго андо Ханаано. Но кала дожылэ каринг о Харано, вонэ линэ тэ жувэн котэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","О Терахо жудя 205 бэрша и муля андо Харано. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","О РАЙ пхэндя лэ Аврамости: — Ашав тери тхан, кай аракхадилян, тери порода и о терэ дадэско чер и жа каринг э пхув, сави Мэ тути сыкавава. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Мэ терава тутар баро народо, бахталисарава тут, Мэ стерава теро алав жангло, и ту авэса бахталимаса важ авэр мануша. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Мэ бахталисарава колэн, ко бахталисарэл тут. Ай ко дэла тут амрая, колэс Мэ кадя жэ дава амрая. И черэз тутэ саворэ народуря пэ пхув прилэна бахт. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","О Аврамо жылятар черал па дром, сар пхэндя лэсти о РАЙ, и о Лото жыля екхтанэ лэса. Кала вов жылятар анда Харано, лэ Аврамости сас тунче ефтадэша панч бэрша. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Вов ля пэса пэстеря ромня ла Сара, и лэ шавэс пэстерэ пхралэс лэ Лотос, ся пэско хулаимос, саво сас лэндэ, и лэ манушэн, савэн вонэ тиндэ андо Харано. Вонэ жылэтар каринг э пхув лэ Ханааностери и авилэ инчя. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","О Аврамо прожыля па кодыя пхув жы колэ тханэстэ андо Шэхемо, кай тэрдёлас о баро кашт тэрэбинто Морэ. Андэ кодыя время котэ жувэнас э ханаанея. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","О РАЙ сыкадяпэ лэ Аврамости и пхэндя: — Мэ дава кадыя пхув терэ потомконэнди. О Аврамо стердя котэ жэртвенико лэ РАЕСТИ, Саво сыкадяпэ лэсти. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Котар вов жылятар каринг лэ плая, савэ сас по востоко лэ Вефилёстар и стходя э катуна машкара о Вефилё по западо, ай о Гаё по востоко. Котэ вов стердя жэртвенико лэ РАЕСТИ и тэлиля лэ РАЕСТИ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Тунче о Аврамо вазгляпэ па тхан и жылятар па дром каринг о юго, андо риг лэ Негевоско. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Пэ пхув сас бокх. Вой сас кацави бари, со Аврамо жыля тэ пожувэл андо Египто. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Кала вонэ поджанас каринг о Египто, о Аврамо пхэндя ла Сарати, пэстеря ромняти: — Всаворэнди дичёл, со ту шукарни жувли. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Кала э египтянуря дикхэна тут, вонэ гындосарэна, со ту мэрни ромни, и умарэна ман, ай тут ашавэна жундя. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Пхэн, со ту мэрни пхэй. Тунче важ тутэ и ман драго прилэна. И черэз тут мэ ашавапэ жундо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Кала о Аврамо авиля андо Египто, э египтянуря дикхлэ, со э Сара фартэ шукарни. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ай кала ла дикхлэ э рая, савэ сас паша о фараоно, вонэ розашардэ ла лэ фараоности, и залинэ ла Сара каринг лэстэ андо чер. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","О фараоно драго приля лэ Аврамос пала э Сара, и кав Аврамо ашыля бут бакрэн, бузнэн тай гурумнян, ослонэн и ослицэн, копэлен тай копэльницэн, и вэрблюдонэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Но о РАЙ бишалдя по фараоно и пэ саворэн, ко жувэлас андо лэско чер, пхаро насвалимос пала кода, со кодва ля андо пэско чер ла Сара, лэ Аврамости ромня. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Тунче о фараоно акхардя лэ Аврамос и пушля лэстар: — Со ту тердян манца? Состар ту на пхэндян манди, кай вой тери ромни? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Сости ту пхэндян, со вой тери пхэй? Кати пала када мэ ла лэм манди ромняса. Акэ тери ромни. Залэ ла и ужатар! ");
INSERT INTO rmyvlakh_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","О фараоно припхэндя, и лэстерэ мануша витрадэ котар лэ Аврамос екхтанэ ла ромняса и ся, со лэндэ сас. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","О Аврамо ла ромняса и саворэ барвалимаса жылятар анда Египто андо Негево, и о Лото жыля лэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Кай о Аврамо сас бут ското, руп и сомнак. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Анда Негево вов жалас англэ, покэ на авиля андо Вефилё, каринг кода тхан, кай варикала тэрдёлас лэсти катуна, машкара Вефилё и Гаё, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","каринг кода тхан, кай вов данглал стердя о жэртвенико. Котэ о Аврамо тэлиля лэ РАЕСТИ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Кай о Лото, саво пхирэлас лэ Аврамоса, кадя ж сас гурто бузнэн, бакрэн и гурувэн и катунэ, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","и э пхув нащи пропараварэлас лэн дуен: лэндэ сас кадя бут ското, со лэндэ на вижалас тэ жувэн екхэтанэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Машкара пастухуря лэ Аврамостерэ и лэ Лотостерэ тердяпэ чингар. Тунче котэ, пэ кодыя пхув, жувэнас э ханаанея и э перизея. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","О Аврамо пхэндя лэ Лотости: — На трэбуй амэнди тай амарэ пастухонэнди тэ терэл чингар, амэ ж туса сам родуря. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Дикх, ся пхув англа тутэ! Дэ розжампэ: сар ту жаса андэ екх риг, то мэ жава андэ авэр риг. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","О Лото подикхля и додикхля, со ся пхув паша Иордано жы каринг о Цоаро драго протиндёлас лэ брышындэндар, сар о садо лэ РАЕСКО, сар э пхув андо Египто. Када сас жы колэстэ, сар о РАЙ спхабардя о Содомо тай э Гомора. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","О Лото витидя пэсти ся пхув паша Иордано и жылятар по востоко. Вонэ розжылэпэ: ");
INSERT INTO rmyvlakh_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","о Аврамо жувэлас пэ пхув Ханаано, ай о Лото жувэлас машкара форуря пэ мал, стходя э катунэ найдур лэ Содомостар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Э мануша андо Содомо саслэ вырытэ и бут терэнас бэзэха англа РАЙ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Кала о Лото отжыля, о РАЙ пхэндя лэ Аврамости: — Обдикхпэ ригатар колэ тханэстар, кай ту екхатар. Подик по северо и по юго, по востоко и по западо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Ся пхув, сави ту дикхэс, Мэ дава тути и терэ потомконэнди пэ ся время. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Мэ стерава, со тутэ авэна бут бэяцэ, сар о чишай. Сар нащи тэ пэрэадиной о чишай, кадя и нащи авэла тэ пэрэадиной и терэ потомкуря. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Жа, прожа пай кадыя пхув дэлунга и дэбугла. Мэ дава ла тути. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","О Аврамо стидя э катунэ и жыля тэ жувэл найдур ла тэрэбинторо вэшоро Мамрэ андо Хевроно. Вов стердя котэ жэртвенико лэ РАЕСТИ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Андэ кодыя время о Амрафело, о тхагар лэ Шынароско, о Ариохо, о тхагар лэ Эласароско, о Кедорлаомеро, о тхагар лэ Эламоско, тай о Тидало, о тхагар лэ Гоимоско, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","екхтанэ жылэ маримаса по Бера, тхагарэс Содомоско, по Бирша, тхагарэс Гомораско, по Шынаво, тхагарэс Адмаско, по Шэмеверо, тхагарэс Цэвоимоско, тай по тхагар Беласко (када исы о Цоаро). ");
INSERT INTO rmyvlakh_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Кадыла тхагара стидэ екхэтанэ пэстерэ зорэса пэ мал Сидимоско (кай екхатар о Лондо баро паи). ");
INSERT INTO rmyvlakh_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Дэшудуй бэрша саслэ копэлэнца кай Кедорлаомеро, ай по дэшутрито бэрш вонэ на закамле тэ авэн копэленца. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Андо дэшуштарто бэрш о Кедорлаомеро и э тхагара пэстерэ амалэнца вижылэ и розмардэ лэ рефаёнэн андэ Аштерото-Карнаимо, лэ зузеёнэн андо Хамо, лэ эмеёнэн андо Шавэ-Кирьятаимо ");
INSERT INTO rmyvlakh_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","тай лэ хореёнэн андо Сеироско плая, па дром андо Эл-Парано, по бряго пэ мал. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Котар вонэ рисайлэ палпалэ и авилэ каринг о Эн-Мишпато (кода исы Кадэшо) и залинэ ся пхув кай э амалекея и кай э аморея, савэ жувэнас андо Хацэцон-Тамаро. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Англа лэндэ вижылэ по маримос о тхагар лэ Содомоско, о тхагар лэ Гомораско, о тхагар лэ Адмаско, о тхагар лэ Цэвоимоско тай о тхагар лэ Беласко (саво исы Цоаро). Андэ Сидимоско мал машкар э плая вонэ линэ тэ марэнпэ ");
INSERT INTO rmyvlakh_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","лэ Кедорлаомероса, лэ тхагарэса андай Эламо, лэ Тидалоса, лэ тхагарэса андай Гоимо, лэ Амрафелоса, лэ тхагарэса андай Шынаро, и лэ Ариохоса, лэ тхагарэса андай Эласаро, — штар тхагара жылэ пэ панч. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Пэ Сидимоско мал машкар пхувья сас бут хывья ла смоласа. Кала э тхагара анда Содомо тай анда Гомора линэ тэ нашэнтар, бут халавдэндар попэлинэ инчя, ай авэр нашлэтар андэ плая. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Э штар тхагара залинэ ся о хулаимос тай ся о хамос анда Содомо тай анда Гомора и жылэтар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Вонэ кадя жэ залинэ лэ Лотос, саво сас о шаво Аврамостерэ пхралэс и жувэлас андо Содомо, тай ся лэско хулаимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Екх лэндар, саво нашлятар, авиля и роспхэндя пала када лэ евреё Аврамости. О Аврамо жувэлас найдур лэ кашта тэрэбинто, савэ саслэ лэ амореёстерэ лэ Мамрэстерэ. Эшколо тай о Анеро саслэ лэстерэ пхрала, вонэ саслэ амала лэ Аврамостерэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Кала о Аврамо ашундя, со шавэс лэстерэ пхралэс залинэ, вов стидя триншэл дэшуохто муршэн, савэ аракхадилэпэ андо лэско чер и ганэнас, сар тэ марэнпэ. Вонэ прастае пала штар тхагара тай жанас пала лэндэ жы каринг о Дано. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Рятэ о Аврамо ростходя пэстерэ копэлен пэ дуй гуртуря и дя шутяпэ пэ ворогуря. Вонэ линэ тэ нашэнтар, ай Аврамо жалас пала лэндэ жы каринг э Хова, каринг о северо лэ Дамаскостар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Вов заля ся о хулаимос, а кадя ж лэ шавэс пэстерэ пхралэс лэ Лотос, тай ся лэско хулаимос, и лэ жувлян, и лэ манушэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Кала о Аврамо помардя лэ Кедорлаомерос тай лэ тхагарэн, савэ саслэ лэса, тай рисавэлас палпалэ, тунче о Содомоско тхагар вижыля тэ дикхэл лэс пэ мал машкар плая Шавэ, сави исы Тхагарэндери мал. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","О Мелхисэдэко, о тхагар лэ Салимоско, виндярдя о марно тай о чехыри. Вов сас о рашай лэ Дэвлэско лэ Майвуческо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Вов бахталисардя лэ Аврамос и пхэндя: — Мэк лэ Майвуческо Дэл, Саво стердя нэбо тай пхув, тэ бахталисарэл лэ Аврамос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Тэ авэл ашаримос лэ Дэвлэсти лэ Майвучести, Саво отдя терэ ворогонэн андэ терэ васта. О Аврамо дя лэсти дэшто котор саворэстар, со вов заля андо маримос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","О Содомоско тхагар пхэндя лэ Аврамости: — Отдэ манди марнэ манушэн, ай о хулалимос ашав тути. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ай о Аврамо пхэндя лэ Содомосконэсти тхагарэсти: — Мэ ваздав о васт каринг о РАЙ, каринг о Дэл о Майвуческо, Саво стердя о нэбо тай э пхув, тай солахав, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","со на прилава тутар ни тхаворо, ни кущик лэ пэрналэндар, со на лава нисо теро, соп ту тэ на пхэнэс: «Мэ дэм барвалимос лэ Аврамости». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Мэ лава кати кода, со похалэ мэрнэ мануша, ай ко жылясас манца — о Анеро, о Эшколо тай о Мамрэ — мэк лэн пэсти пай. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Тунче о РАЙ сыкадяпэ лэ Аврамости андо дикхлимос тай пхэндя: — На дара, Аврамо. Мэ сым теро щито, Мэ дава тути баро потинимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","О Аврамо пхэндя: — О Хулай, РАЙ, со Ту инке тэ дэс манди, сар кай мандэ нинай бэяцэ, и ся мэрно хулаимос доросэлапэ шавэсти Мэшэкоско, Элиезерости Дамаскоско? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","О Аврамо инке пхэндя: — Ту на дян манди бэятонэн, и о копэли, саво аракхадиляпэ андо мэрно чер, прилэла ся мэрно хулаимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Пэ лэсти дума сас о алав лэ РАЕСТАР: — Най, вов на прилэла теро хулаимос. Прилэла кодва, ко аракхадёлапэ тутар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","О РАЙ виндярдя лэс аврял и пхэндя: — Дикх по нэбо и пэ чергая, скати лэн! Ту пэрэангичеса лэн? — И пхэндя лэсти: — Акэ скати тутэ авэна бэяцэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","О Аврамо патяя лэ РАЕСТИ, и о РАЙ заангичля када лэсти андо чячимос. О РАЙ пхэндя: ");
INSERT INTO rmyvlakh_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","— Мэ сым о РАЙ, Саво виндярдя тут анда Уро халдеенго, соп тэ дав тути андо хулаимос кадыя пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Но о Аврамо пушля: — О Хулай, РАЙ, сар мэ уганава, со кадыя пхув ашэла мэрно хулаимос? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","О РАЙ пхэндя лэсти: — Ан Манди тринэбэршэндеря гуруня, тринэбэршэндеря бузня и тринэбэршэндерэс бакрэс, и кадя ж ан горлица тай тэрнэс голубос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","О Аврамо кадя и стердя. Вов росшындя лэн по епаш и ростходя э епаша екх англа екхатэ, ай лэ черэклян на росшындя по епаш. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","И привурянас барэ черэкля тэ хан э мулэ маса, ай о Аврамо отдаравэлас лэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Сар ашыля тэ бэшэл о кхам, по Аврамо дя састо совимос и змэкляпэ пэр лэстэ баро калимос и напэля пэр лэс бари дар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","О РАЙ пхэндя лэсти: — Ган жэ, со терэ бэяцэ авэна найчяченца андэ найпэстери пхув, лэн терэна копэлэнца и авэна тасавэн лэн штаршэла бэрша. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Но Мэ сындосарава колэн манушэн, савэ терэна лэн копэлэнца, и тунче вонэ вижана котар барэ барвалимаса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ай ту мэрэса андо миро и жасатар каринг тери порода, тут гаравэна, кала авэса фартэ пхуро. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Кардэ рисайвэна кати штарто родо терэ бэятонэн, пала кода со екхатар э бэзэхоско кхоро лэ амореенго инке на допхэрдиля кай упралимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Кала бэшля о кхам и ашыля калимос, и акэ авилэ яг и пири пхабардэ янгарэса и тхуваса. Вонэ прожылэ машкара епаша котора. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Андэ кодыва дес о РАЙ дя о завето лэ Аврамости и пхэндя: — Мэ отдав терэ бэяцэнди кадыя пхув, анда египтонстери лэн жы каринг э бари лэн Евфрато: ");
INSERT INTO rmyvlakh_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","э пхув лэ кенеенди, лэ кенизеенди, лэ кадмонеенди, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","лэ хетеенди, лэ перизеенди, лэ рефаенди, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","лэ амореенди, лэ ханаанеенди, лэ гиргашэенди, тай лэ евусеенди. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Э Сара, э ромни лэ Аврамости, на анэлас лэсти бэятонэн. Латэ сас копэльница египтянка, ла акхарэнас Агарь. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Э Сара пхэндя лэ Аврамости: — О РАЙ на дя манди бэятонэн. Жа, пэрэсов лэ копэльницаса: можэ тэ авэл латар мандэ авэна бэяцэ. О Аврамо стердя кадя, сар пхэндя э Сара. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Э Сара, лэсти ромни, ля пэстеря копэльница, ла египтянка Агарь, и отдя ла пэстерэ ромэсти. Кай кадва время Аврамо прожудя андо Ханаано дэш бэрша. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Вов сутя ла Агаряса, и вой ашыля пхари. Кала э Агарь угангля, со вой пхари, вой парашыля тэ обжал пативаса пэстеря хулая. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Тунче э Сара пхэндя лэ Аврамости: — Ту дошало сан андэ кода, со вой терэл манди вырытимос. Мэ отдэм тути ла копэльница андо теро пато, и акана, кала вой угангля, со сыни пхари, парашыля тэ обжал ман пативаса. Мэк о РАЙ россындосарэла амэн туса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","О Аврамо пхэндя: — Вой же тери копэльница, тер ласа ся, со камэс. Тунче э Сара ашыля кадя тэ тасавэл ла Агарь, со кодыя нашлятар латар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","О Янголо лэ РАЕСКО аракхля ла Агаря андэ шуки пхув, найдур ла хаингатар, кадва хаинг сас пашэ катар о дром каринг о Шуро. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Вов пушля: — Агарь, копэльница ла Сарати, катар ту авиля и каринг жас? — Мэ нашавтар мэрня хулаятар ла Саратар, — пхэндя вой. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Тунче о Янголо лэ РАЕСКО пхэндя лати: — Рисав каринг тери хулаи и кандэ ла. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","И инке пхэндя о Янголо РАЕСКО лати: — Мэ стерава кадя, со тутэ авэла бут бэятонэн, со лэн нащи авэла тэ пэрэадинос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Инке о Янголо лэ РАЕСКО пхэндя лати: — Ту екхатар сан пхари и анэса шавэс. Дэ лэсти алав Измаило, пала кода со о РАЙ ашундя пала терэ дукха. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Вов авэла, сар дыко осло: вов авэла пэ саворэн, и саворэ авэна пэр лэстэ. Вов авэла тэ жувэл андо холи пэстерэ пхралэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Вой дя алав лэ РАЕСТИ, Саво дэлас дума ласа, Эл-Рои, пала кода со вой пхэндя: — Екхатар мэ дикхлэм Колэс, Ко дикхэл ман. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Акэ состар кодылати хаингати динэ алав Бээр-Лахай-Рои. Вой и инке исы котэ, машкара Кадэшо тай Бередо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Э Агарь андя лэ Аврамости шавэс, и о Аврамо дя лэ шавэсти, савэс вой андя, алав Измаило. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Кала э Агарь андя лэсти лэ Измаилос, лэ Аврамости сас охтодэша шов бэрша. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Кала лэ Аврамости сас иняшэла иня бэрша, о РАЙ авиля лэстэ андо суно и пхэндя: — Мэ сым о Дэл Саворэзорэско, жув англа Мандэ и ав бидошако. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Акэ тути Мэрно завето: Мэ дава тути фартэ бут бэятонэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","О Аврамо тэлиля лэ Дэвлэсти лэ муеса жы каринг э пхув, и о Дэл пхэндя лэсти: ");
INSERT INTO rmyvlakh_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","— Акэ тути Мэрно завето: ту авэса о дад бутэ народонэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ту кала времятар на авэса тэ акхарэспэ Аврамо, теро алав авэла Авраамо, пала кода со Мэ стердэм тут дадэса важ бут мануша. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Мэ стерава кадя, со тутэ авэна фартэ бут бэятонэн. Мэ стерава кадя, со тутар авэна бут народуря, тай тутар авэна тхагара. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Мэ дав тути завето, када кадя ж авэла завето андай екх порода авря породати пэ саворэ бэрша, сар вечно завето: Мэ авава терэ Дэвлэса тай Дэвлэса терэ бэяцэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ся пхув лэ Ханааности, пэ сави ту екхатар жувэс, Мэ отдава тути и терэ бэяцэнди андо вечно хулаимос, тай Мэ авава лэнди Дэвлэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","О Дэл пхэндя лэ Авраамости: — Ай ту трэбуй тэ жувэс па Мэрно завето, ту тай терэ бэяцэ, савэ авэна тутар, пэ ся время. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Акэ Мэрно завето туса тай терэ бэяцэнца, савэ авэна тутар, па саво ту трэбуй тэ жувэс: кажно мурш трэбуй тэ авэл опшындо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Кажно тумэндар трэбуй тэ авэл опшындо, тай када авэла знако лэ заветоско машкара Мандэ и тумэндэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Кажно тумаро муршоро трэбуй тэ авэл опшындо, кала лэсти авэла охто деса. Кадя трэбуй тэ терэл ся породуря. И колэсти, ко аракхадёла андэ теро чер, тай кодыва, саво най терэ бэяцэндар, ай савэс ту тиндян важ э ловэ кай найчяче манушэстар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","И саво аракхадиляпэ андэ теро чер, тай савэс тиндян важ э ловэ, чячес трэбуй тэ авэл опшындо, и Мэрно завето пэ тумари тила авэла завето пэ ся вико. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Найопшындо мануш авэла опшындо пэстерэ народостар: вов на кангля Мэрно завето. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Инке о Дэл пхэндя лэ Авраамости: — Ай ла Сара, теря ромня, ту кала времятар на лэса тэ акхарэс ла Сара, лако алав авэла Сарра. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Мэ дава лати бахт и дава тути латар шавэс. Мэ дава кацави бахт, со вой терэлапэ дэй лэ народонэнди; латар аракхадёнапэ тхагара лэ народонэндерэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","О Авраамо тэлиля лэ Дэвлэсти жы каринг э пхув, розасаяпэ и погындосардя: «Аракхадёла ли шаво кай о мануш, савэсти шэл бэрша? Анэна ли бэятос э Сарра, савяти инядэша бэрша?» ");
INSERT INTO rmyvlakh_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","О Авраамо пхэндя лэ Дэвлэсти: — Мишто б о Измаило тэ авэл жундо! ");
INSERT INTO rmyvlakh_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","О Дэл пхэндя: — Чячес тери ромни э Сарра анэна тути шавэс, ай ту дэса лэсти алав Исаако. Мэ дава Мэрно завето лэсти тай лэстерэ породати, када авэла вечно завето. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","И пала Измаило Мэ ашундэм тут: Мэ йито дава лэсти бахт, Мэ стерава, со лэстэ авэна бут бэятонэн. Вов авэла дад дэшэдуендерэ барэдэрэн, тай Мэ стерава лэстар баро народо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Но Мэрно завето Мэ дава лэ Исаакости, савэс э Сарра анэна тути каринг кодыя время андэ авэр бэрш. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","О Дэл парашыля тэ дэл дума лэ Авраамоса и отжыля лэстар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Андэ кодыва жэ дес о Авраамо ля пэстерэ шавэс лэ Измаилос и саворэн, ко сас аракхадо лэстэ черэ, тай савэн, кас вов тиндя важ э ловэ, саворэ муршэн анда пэско чер, и опшындя лэн, сар пхэндя лэсти о Дэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Кала Авраамо сас опшындо, лэсти сас инядэша иня бэрша, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","ай лэсти шавэсти лэ Измаилости, кала вов сас опшындо, сас дэшутрин бэрша. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","О Авраамо и лэско шаво о Измаило дуйжэнэ сас опшындэ андэ екх дес. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Тай саворэ мурша, савэ аракхадилэпэ анда лэ Авраамоско чер, или тиндясас пала ловэ кай о найчяче манушэстар, саслэ опшындэ екхтанэ лэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Кала десэ пэкэлас о кхам, ай Авраамо бэшэлас англа пэсти катуна катар о тэрэбинтоско вэшоро Мамрэ, каринг лэстэ авиля о РАЙ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","О Авраамо вазгля э якха и додикхля англа пэстэ трин муршэн. Кала вов додикхля лэн, дя тэ прастэл ла катунатар каринг лэндэ и тэлиля лэнди жы каринг э пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Вов пхэндя: — Мэрно хулай, сар кай мэ аракхлэм тынгимос андэ терэ якха, на прожа ман, терэ копэлес. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Мэк анэн найбут паи, кай тэ халавэн тумэнди э пэрнэ тай тэ отчиён тэла кадыва кашт. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Кала тумэ ужэ авилэ каринг тумаро копэли, мэ анава тумэнди варисо тэ хан. Кала тумэ хана, подритярэна теро зор тай тунче жана пэстерэ дромэса. — Када фартэ мишто, — пхэндэ вонэ. — Стер кадя, сар пхэнэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Авраамо грабимаса жыля андэ катуна каринг э Сарра и пхэндя лати: — Майито, дорэс трин сатэ майлашо яро, загамисар хумэр и пэк биквасно марно. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Ай екхжэно прастая каринг о гурто, и витидя лашорэс тэрнорэс гурувурэс тай отдя лэс лэ копэлести, саво йито пригэтосардя лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Тунче вов андя тирал, тхуд тай пригэтосардя гурувано мас и стходя англа лэндэ. Кала вонэ ханас, вов тэрдёлас паша лэндэ тэла кашт. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","— Кай исы тери ромни э Сарра? — пушлэ вонэ. — Котэ андэ катуна, — пхэндя вов лэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Тунче о РАЙ пхэндя: — Мэ чячес рисайвапэ тутэ пэ авэр бэрш пашай кадыя время, и кай э Сарра, тери ромни, авэла шаво. Ай э Сарра ашунэлас, тэрдёлас лэстэ пала думо, андэ катуна пашай вудара. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","О Авраамо тай э Сарра саслэ ужэ пхурэ, андэ бэршэндэ, и кода, со исы кай э жувля, кай э Сарра парашыля. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Э Сарра розасаяпэ андэ пэстэ тай гындосардя: «Мэ ужэ спхурилэм, и о хулай мэрно пхуро, мандэ инке авэла кацави лош?» ");
INSERT INTO rmyvlakh_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Тунче о РАЙ пхэндя лэ Авраамости: — Состар э Сарра асал и пхэнэл: «Тай со, мандар, пхуранятар, чячес авэла бэято?» ");
INSERT INTO rmyvlakh_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Исин ли варисо, со нащи тэ терэл о РАЙ? Мэ рисайвапэ тутэ пэ авэр бэрш андэ время, сави трэбуй, и кай э Сарра авэла шаво. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Э Сарра пэрэдарайля, ашыля тэ отпхэндэпэ тай пхэндя: — Мэ на асаям. Ай Вов пхэндя: — Най, ту асасас. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Кала мурша вазглэпэ тай ашылэ тэ жалтар каринг о Содомо, о Авраамо жыля лэнца, тэ проандярэл лэн андо дром. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","О РАЙ погындосардэм: — Гаравава ли Мэ лэ Авраамостар кода, со камав тэ терав? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Лэ Авраамостар чячес авэла баро тай зорало народо, и черэз лэстэ прилэна бахт саворэ народуря пэ пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Мэ жэ витидэм лэс, соп вов тэ припхэндя пэстерэнди бэятонэнди, тэ фирисарэн о дром лэ РАЕСКО тай тэ жувэн пав лашымос тай чячимос. Тунче Мэ, РАЙ, стерава ся, со пхэндэм лэ Авраамости. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","О РАЙ пхэндя: — Андэ Содомо тай Гомора ашунэлпэ баро цыпипос, мануша котэ терэн пхаро бэзэх. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Тэ жав Мэ тэлэ и тэ подикхав, чячюно ли о цыпимос, саво дожыля жы Мандэ, кадя ли вырыто вонэ терэн. Мэ уганава, када чячимос чи на. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Э мурша бандилэ и жылэ каринг о Содомо, ай о Авраамо ашыляпэ тэ тэрдёл англа РАЙ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","О Авраамо пашыля каринг Лэстэ тай пхэндя: — Ту со, умарэса лэ чячюнэс екхтанэ лэ бэзэхэстерэса? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Ай со, сар кай андо форо исы панчдэша чячюнэ мануша? Ту со, саекх розмарэса и на потынгоса кодыва тхан важ э панчдэша чячюнэ манушэн? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Нащи Ту кацаво тэ стерэс, Ту на хасяйвэса лэ чячюнэс екхтанэ лэ бэзэхэстерэса, тэ на авэла лэ чячюнэса кода ж, со лэ бэзэхэстерэса. Нащи Ту кадя тэ стерэс! Хэба о Сындомари савора люмако стерэла найчячимос? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","О РАЙ пхэндя: — Сар кай Мэ аракхава андо Содомо панчдэша чячюнэн манушэн, то важ лэндэ Мэ потынгоя ся кода тхан. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Тунче о Авраамо инке пхэндя: — Акэ мэ сым пош пхуятар тай ватрако, ай саекх найдараса лэм тэ дав дума Туса, мэрно Хулай. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ай со, сар каринг э панчдэша чячюнэн на хутилэла панч мануш? Розмарэса ли Ту ся о форо пала кода, со на хутилэл панч мануша? — Сар кай Мэ аракхава котэ штардэша панч чячюнэ мануша, — пхэндя Вов, — тунче на розмарава лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","О Авраамо инке екхвар пушля Лэстар: — Ай со, сар котэ авэна кати штардэша? Вов пхэндя: — И пала э штардэша Мэ на стерава кода. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Тунче Авраамо пхэндя: — Мэк на холяйвэл о Хулай, ай дэл манди тэ пхэнав. Ай со сар котэ авэна кати триндэша? Вов пхэндя: — Мэ на стерава кода, сар аракхава котэ триндэша. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Авраамо пхэндя: — Акэ, мэ сымас кацаво састо, со камав тэ пхэнав лэ Хулаести. Ай со сар котэ авэна кати дуйдэша? О РАЙ пхэндя: — И пала э дуйдэша Мэ на розмарава лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Тунче Авраамо пхэндя: — Мэк на холяйвэл о Хулай, ай дэ манди тэ пхэнав инке кати екхвар. Ай со сар кай котэ авэна кати дэш? Вов пхэндя: — И пала э дэш Мэ на розмарава лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Кала о РАЙ парашыля тэ дэл дума лэ Авраамоса, Вов жылятар, ай о Авраамо рисайля черэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Каринг о вэчеро авилэ дуй янголуря андо Содомо, ай о Лото бэшэлас катар лэ форостерэ вудара. Кала вов додикхля лэн, ущиля лэндэ англал и тэлиля жы каринг э пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","— Мэрнэ хулая, — пхэндя вов, — мангав тумэн, зажан андо чер кай тумаро копэли. Тумэ халавэна э пэрнэ тай рятярэна, ай тэсараса жана пэстерэ дромэса. — Най, — пхэндэ вонэ, — амэ рятяраса пэ форо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ай вов лэн кадя мангэлас, со вонэ жылэ пала лэстэ и зажылэ андо чер. Вов пригэтосардя важ лэндэ лашо хамос, пэкля присно марно, и вонэ халэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Данглал сар вонэ тэ пэрэн тэ совэн, саворэ мурша анда форо Содомо, тэрнэ тай пхурэ, тэрдёнас паша чер саворэ ригэндар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Вонэ цыпинас лэ Лотости: — Кай сынэ кола мануша, савэ авилэ каринг тутэ вэчеряса? Виндяр лэн каринг амэндэ, амэ камас тэ пэрэсовас лэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","О Лото вижыля лэндэ и пхандадя пала пэстэ о вудар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Вов пхэндя: — Най, мэрнэ пхрала, на терэн кацаво вырытимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Ашунэн, мандэ исы дуй щея, савэ никала на сас муршэса. Дэн мэ виндярава лэн тумэндэ, и терэн лэнца, со камэн. Кати нисо на терэн калэ манушэнди, савэ авилэ талай упралимос мэрнэ черэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Вонэ пхэндэ: — Отжа па дром! И пхэндэ: — Акэ дикх, ту, найчячё, авиля кардэ, ай екхатар пхэнэс амэнди, со тэ терас! Амэ тераса туса инке майвырыто, сар лэнца. Вонэ ашылэ тэ отчювэл тай натасавэл пэ Лотос и поджылэ, тэ випхагэн о вудар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ай э мурша, савэ сас андрал, зацырдэ лэ Лотос андо чер и пхандадэ о вудар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ай колэн, ко сас пашай о вудар лэ черэсти, лэ тэрнэн тай лэ пхурэн, вонэ корардэ кадя, со колэ нащи аракхэнас о вудар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Ай кала дуй мурша пхэндэ лэ Лотости: — Ко инке тутэ катэ исы — э тэрнэ лэ щеянди, шавэ, щея, инке варико андо форо? Виндяр лэн катар, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","пала кода со амэ камас тэ розмарас кадыва тхан. О цыпимос каринг о РАЙ пэ кала мануша кадя баро, со Вов бишалдя амэн тэ розмарас лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","О Лото вижыля и пхэндя пэстерэ лэ тэрнэнди, савэ камэнас тэ лэн лэстерэ щеян: — Майито, ужантар катар! О РАЙ тидэлпэ тэ спхабарэл о форо! Ай кола гындосарэнас, со вов пхэрясуе. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Англай тэсара, э янголуря линэ тэ грабин лэ Лотос: — Грабисав! Ундяр катар теря ромня и дуен щеян, а то ту хасайвэса бэзэхэнца калэс фороса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ай вов на грабияспэ, тунче кола дуйжэнэ линэ пала васта лэс, лэстеря ромня тай лэ дуен щеян, и виндярдэ лэн аври пала форо, пала кода со о РАЙ тынгосардя лэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Кала виндярдэ лэн пала форо, екх лэндар пхэндя: — Фирисар пэско жувимос! На обдикхпэ палпалэ тай на притэрдю никай по дром! Прастэ андэ плая, а то ту хасайвэса! ");
INSERT INTO rmyvlakh_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Ай о Лото пхэндя лэнди: — Най, Хулай! ");
INSERT INTO rmyvlakh_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Ту кацаво лашо каринг мандэ, терэ копэлэстэ, и Ту сыкадян манди баро тынгимос, фирисардян мэрно жувимос. Андэ плая мэ на допрастава: э бида дорэсэла ман, тай мэ хасайвава. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Акэ кодыва форицэ найдур, инчя мэ йито допрастава, тай вов найбаро. Кордэ мэ и прастава — вов сыно цыкно, тай мэрно жувимос авэла фирисардо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Вов пхэндя: — Мишто, Мэ стерава и када: Мэ на спхабарава о форо, пала саво ту пхэнэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Майито прастэ инчя, пала кода со мэ нисо на стерава, жы кай ту на допрастэса жы лэстэ. Акэ состар кодыва форо сас акхардо Цоаро. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","О кхам ужэ ущиля, кала о Лото допрастая каринг о Цоаро. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Тунче о РАЙ шордя па нэбо, сар брышынд, сера ягаса по Содомо и Гомора. Вой авиля лэ РАЕСТАР анда нэбо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Вов розмардя э форуря и ся кадай риг, тай саворэн, ко котэ жувэлас, тай ся, со барёлас пэ пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ай э ромни лэ Лотости опдикхляпэ палпалэ и тердяпэ лонэско столбо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Тэсара пэ авэр дес о Авраамо вазгляпэ и рисайля каринг кодыва тхан, кай вов тэрдёлас англа РАЙ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Вов подикхля по Содомо тай по Гомора, и додикхля ся мал, и ля сама, со ла пхуятар ваздэлпэ тхув, сар о тхув анда бов. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Кадя, кала о Дэл спхабардя э форуря па кода тхан, кай жувэлас о Лото, Вов сэрдя пала Авраамо и фирисардя лэ Лотос ла бидатар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","О Лото даралас тэ ашэлпэ андо Цоаро, пала кода вов тай лэсти дуй щея нашлетар котар тай линэ тэ жувэн андэ плая. Вов жувэлас андэ пещера пэстерэ дуе щеянца. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Э барэдэр щей пхэндя лэ майцыкняти: — Амаро дад пхуро, ай пэ пхув нинай муршэс, саво жувэлас бы амэнца, сар трэбуй. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Матярам лэ дадэс чехыреса и совам лэса. Мэк и лэ дадэстар, но амэндэ авэна бэяцэ! ");
INSERT INTO rmyvlakh_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Андэ кодыя рят вонэ матярдэ пэстерэ дадэс чехыреса, тай э барэдэр щей зажыля и сутя лэса. Вов и на ганля, ни сар вой сутя лэса, ни сар ужыля. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Пэ авэр дес э барэдэр щей пхэндя ла майцыкняти: — Кодыла рятяса мэ сутэм лэ дадэса. Матярам лэс инке чехыреса адес пэ рят, и ту зажаса тай совэса лэса. Мэк и лэ дадэстар, но амэндэ авэна бэяцэ! ");
INSERT INTO rmyvlakh_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Вонэ матярдэ лэ дадэс чехыреса тай андэ кодыя рят, и э майцыкни щей зажыля и сутя лэса. Вов и на ганля, ни сар вой сутя лэса, ни сар ужыля. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Кадя лэдуй щея лэ Лотости ашылэ пхарэ пэстерэ дадэстар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Э барэдэр щей андя шавэс и дя лэсти алав Моаво. Вов — дад лэ адесутнэ моавитянэнго. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Э майцыкни щей андя шавэс и дя лэсти алав Бэн-Амми. Вов — дад лэ адесутнэ амонеенго. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","О Авраамо пэрэжыля катар андэ пхув Негево и жувэлас машкара Кадэшо тай Шуро. Тунче вов жувэлас андо Гераро. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Котэ Авраамо пхэндя пала пэстери ромни Сарра: «Вой сыни мэрни пхэй». Тунче о Авимелехо, о тхагар лэ Герароско, бишалдя пала Сарра и ля ла каринг пэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ай о Дэл авиля каринг о Авимелехо рятэ андо суно и пхэндя лэсти: — Тут мэрэса палай жувли, савя ту лян каринг пэстэ: вой сыни пала ромэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Но о Авимелехо на ляпэ латэ, и пала када вов пхэндя: — Хулай, ту жэ на умарэса найдошалэ манушэн? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ке вов пхэндя манди: «Вой — мэрни пхэй», и вой пхэндя: «Вов — мэрно пхрал». Андэ кадыя дила мэрнэ гындуря вужэ тай мэрнэ васта найдошалэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","О Дэл пхэндя лэсти андо суно: — Чячес, Мэ ганав, со терэ гындуря вужэ: када Мэ уритярдэм тут лэ бэзэхостар англа Мандэ, и пала када на мэклэм тут тэ лэспэ латэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Акана рисар лэ ромня лэ ромэсти, пала кода со вов сыно пророко. Вов мангэлапэ пала тутэ, и ту ашэсапэ жундо. Ай сар кай ту на рисарэса ла, ган, со тути тай терэ пашутнэ на унашэнатар лэ мэримастар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Пэ авэр дес кати кай э тэсара о Авимелехо стидя саворэн пэстерэ пашутнэ раен и роспхэндя лэнди, со тердяпэ, и вонэ фартэ пэрэдарайлэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Тунче о Авимелехо акхардя лэ Авраамос и пхэндя: — Со ту тердян амэнца? Саво бэзэх мэ тути тердэм, кай ту андян кацави пхари дош пэр мандэ тай пэ мэрно тхагаримос? Ту тердян манца кадя, сар нащи тэ терэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","И о Авимелехо пушля лэ Авраамостар: — Со сас тут андэ годи, кала ту стердян кацаво? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Авраамо пхэндя: — Мэ погындосардэм: «Андэ кадыва тхан нинай дар лэ Дэвлэстар, и вонэ умарэна ман важ мэрни ромни». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ай инке вой чячес сыни мэрни пхэй, щей мэрнэ дадэсти, тай най мэрня датар, и вой ашыля мэрни ромни. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Кала о Дэл бишалдя ман анда чер мэрнэ дадэско тэ пхирав пай пхуя, мэ пхэндэм лати: «Акэ стер манди кацаво тынгимос: каринг бы амэ тэ на авас, пхэн, со мэ теро пхрал». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Тунче о Авимелехо дя лэ Авраамости бакрэн тай гурувэн, копэлен тай копэлницэн, и рисардя лэсти лэстеря ромня, ла Сарра. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","О Авимелехо пхэндя: — Акэ мэрни пхув англа тутэ. Жув, кай камэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ай ла Саррати вов пхэндя: — Мэ дав терэ пхралэсти пангли шэкеля руп, соп тэ ушаравав теро лажаво англа саворэ манушэндерэ якха терэ черэско. Акана ту англа саворэ вужы. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","О Авраамо помангля лэ Дэвлэс, и о Дэл састярдя лэ Авимелехос и лэстеря ромня, тай лэ копэльницэн, кай лэндэ упалэ тэ авэн бэяцэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Ай жы колэстэ о РАЙ на дэлас бэятонэн ни екхати жувляти андэ лэ Авимелехоско чер, палай Сарра, лэ Авраамостери ромни. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","О РАЙ, сар Вов и пхэндя, сэрэсардя э Сарра и стердя па пэско алав: ");
INSERT INTO rmyvlakh_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","э Сарра ашыля пхари и андя лэ Авраамости шавэс, кала вов ужэ ашыля пхуро, андэ кодыя время, кала пхэндясас лэсти о Дэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","О Авраамо дя лэ шавэсти, савэс андя э Сарра, алав Исаако. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Кала лэстерэ шавэсти лэ Исаакости ашыля охто деса, о Авраамо опшындя лэс, сас пхэндясас лэсти о Дэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Лэ Авраамости сас шэл бэрша, кала лэстэ аракхадиляпэ о шаво Исаако. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Э Сарра пхэндя: — О Дэл тердя ман тэ асав. Саворэ, ко ашунэна пала када, розасалапэ екхтханэ манца. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","И инке пхэндя: — Тэ пхэнэн б варико лэ Авраамости, кай э Сарра авэла тэ праварэл лэ колинэса? Ай мэ андэм лэсти шавэс андэ лэско пхуримос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","О бэято вибариля и сас одлино лэ колинэстар. Андэ кодыва дес, кала о Исаако сас одлино лэ колинэстар, о Авраамо стходя лащи мисяля. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Э Сарра дикхля, со о шаво, савэс э египтянка Агарь андя лэ Авраамости, прясал лэ Исаакостар, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","тай пхэндя лэ Авраамости: — Витрадэ кала копэльница тай латерэ шавэс, пала кода со о шаво кала копэльницако на росшола о хулаимос мэрнэ шавэса лэ Исаакоса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Лэ Авраамости сас фартэ пхаро, пала кода со кода сас лэско шаво. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","О Дэл пхэндя лэсти: — На грижосав пала шаворо тай палай копэльница. Кандэ ла Сарра тай стер ся, сар вой пхэнэн, пала кода со тери порода жала лэ Исаакостар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ай ла копэльницатерэ шавэстар Мэ стерава екх народо, пала кода со и вов сыно теро шаво. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Пэ авэр дес кати кай э тэсара о Авраамо ля хамос тай гаравлицко гоно лэ паеса тай дя ла Агаряти: схтодя лати лэн пэ пхикэ и отбишалдя ла екхтанэ лэ бэятоса. Вой жылятар и пхирэлас андэ шуки пхув андэ Вирсавия и нащи аракхэлас о дром. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Кала о паи андо гаравлицко гоно на ашыля, вой ашадя лэ бэятос тэлай бур ");
INSERT INTO rmyvlakh_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","и отжыля, прибэшля найдур, сар тэ дэсдап анда луко, пала кода со вой гындосарэлас: «Нащи дикхав, сар о бэято мэрэл». Вой бэшля котэ и фартэ розровляпэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","О Дэл ашундя о ровимос лэ бэятоско, и о янголо лэ Дэвлэско акхардя каринг э Агарь па нэбо и пхэндя лати: — Со туса, Агарь? На дара, о Дэл ашундя, сар ровэл о бэято, савэс ту ашадян. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Ущи, ваздэ лэ бэятос и лэ лэс вастэстар. Мэ стерава лэстар баро народо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Тунче о Дэл пхэрнадя лати э якха, и вой додикхля э хаинг лэ паеса. Вой жыля, пхэрдя о гаравлицко гоно паеса тай паярэл лэ бэятос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","О Дэл сас лэ бэятоса. О Измаило вибариля. Вов жувэлас андэ шуки пхув тай ашыля мишто тэ марэл анда луко. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Вов жувэлас андэ шуки пхув Парано, и лэсти дэй ля лэсти ромня анда Египто. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Андэ кодыя время о Авимелехо тай о Фихоло, о барэдэр пэ лэстерэ халавдэ, пхэндэ лэ Авраамости: — О Дэл сыно туса андэ ся, со ту терэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Солаха жэ манди катэ англа Дэл, со ту на хохавэса ни ман, ни мэрнэ бэятонэн, ни мэрнэ бэятонэндерэ бэятонэн. Стер манди тай кала пхуяти, андэ сави ту жувэс, кодыва жэ тынгимос, саво мэ стердэмас тути. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","О Авраамо пхэндя: — Солахав. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Тунче о Авраамо мустрисардя лэ Авимелехос пала э хаинг лэ паеса, сави захутилдэ э бутярнэ лэ Авимелехости. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Ай о Авимелехо пхэндя: — Мэ на ганав, ко када тердя. Ту на пхэндянас манди, тай жы калэ десэстэ мэ на ашундэм пала када. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","О Авраамо андя гурувнэн тай бакрэн и дя лэн лэ Авимелехости, и вонэ допхэндэпэ екх екхэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","О Авраамо отходя ригатар анда гурто ефта тэрнэ бакрэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","О Авимелехо пушля лэ Авраамостар: — Со када ефта тэрнэ бакрэ, савэн ту отходян ригатар? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Вов пхэндя: — Прилэ мандар кадылэ ефта тэрнэ бакрэн, соп тэ сыкавэл кода, со мэ виганадэм кадыя хаинг, тай вой сыни мэрни. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Вонэ лэ дуй солахае котэ, и акэ пала со кодыва тхан акхардо сас Вирсавия. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Кала вонэ допхэндэпэ андэ Вирсавия, о Авимелехо тай о Фихоло, о барэдэр лэско пэ халавдэ, рисайлэ пэ филистимско пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","О Авраамо шутя тэ барёл тамариско кашт андэ Вирсавия и тэлиля лэ РАЕСТИ, лэ Вечнонэ Дэвлэсти. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","О Авраамо жувэлас пэ филистимско пхув бут время. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Прожыля сави-то время, тай о Дэл закамля тэ продикхэл патямос лэ Авраамоско. Вов пхэндя лэсти: — Авраамо! — Мэ катэ, — пхэндя о Авраамо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","О Дэл пхэндя: — Лэ терэ екхэ шавэс лэ Исаакос, савэс ту камэс, тай жа каринг э пхув Мориа, ан лэс котэ андэ жэртва тай спхабар лэс по плай, пэ саво Мэ тути сыкавава. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Пэ авэр дес кати кай э тэсара о Авраамо ущиля, стходя э зэн по осло, ля пэса дуен бутярнэн тай лэ Исаакос, пошындярдя э кашта важ э яг важ э жэртва и жыля каринг кодыва тхан, пала саво пхэндя лэсти о Дэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","По трито дес о Авраамо вазгля э якха и додихкля дэ дурал кодыва тхан. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Вов пхэндя лэ бутярнэнди: — Ашэнпэ катэ лэ ослоса, ай амэ лэ шаворэса жаса инчя тэлюваса лэ Дэвлэсти, ай тунче рисайваса тумэндэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","О Авраамо ля э кашта важ э яг важ э жэртва и стходя лэн по думо лэ Исаакости, ай екжэно андярэлас э яг тай э шури, и вонэ дуйжэнэ жылэтар андо дром. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","О Исаако пхэндя пэсти дадэсти лэ Авраамости: — Дадэ! — Со, мэрно шаво? — пхэндя о Авраамо. — Амэндэ исы э яг тай э кашт, — пхэндя о Исаако. — Ай кай жэ о бакроро важ э жэртва? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","О Авраамо пхэндя: — О Дэл Екжэно аракхэла Пэсти бакрорэс важ э жэртва, мэрно шаво. Вонэ дужэнэ жылэ майдур. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Кала вонэ дожылэ каринг о тхан, пала саво пхэндя лэсти о Дэл, о Авраамо стердя котэ жэртвенико и стходя пэр лэстэ э кашта. Вов спхангля пэстерэ шавэс лэ Исаакос тай стходя лэс по жэртвенико упрал пай кашта. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Вов процырдя о васт тай ля э шури, соп тэ зашынэн пэстерэ шавэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ай о Янголо лэ РАЕСКО узвисайля лэстэ па нэбо: — Авраамо! Авраамо! — Мэ катэ, — пхэндя вов. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","— На ваздэ о васт по шаворо, — пхэндя Вов, — на тер лэса нисо. Мэ акана ганав, со ту дарас лэ Дэвлэстар, пала кода со ту на тынгосардян важ Мандэ терэ шавэс, терэ екхэс шавэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","О Авраамо вазгля э якха и додикхля бакрэс, саво запхандиляпэ лэ рогонэнца андо бур. Вов жыля, ля лэ бакрэс тай андя лэс андэ жэртва пхабаримаса пала шаво. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","О Авраамо дя алав колэ тханэсти Яхва-Ирэ, пала кода и екхатар пхэнэн: «По плай лэ РАЕСКО аракхэлапэ». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","О Янголо лэ РАЕСКО узвисайля каринг о Авраамо па нэбо инке екхвар ");
INSERT INTO rmyvlakh_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","и пхэндя: — Кадя пхэнэл о Дэл: солахав Екжэно Пэса, сар ту стердян када тай на тынгосардян важ Мандэ терэ екхэ шавэс, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Мэ чячэс бахталисарава тут тай стерава терэ бэятонэн фартэ бут, сар э чергая по нэбо, сар о чишай пэ пхув катар э море, и терэ бэяцэ залэна э форуря пэстерэ ворогонэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Пала кода со ту патян Манди, саворэ мануша пэ пхув лэна бахталисардэ па терэ бэяцэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Тунче о Авраамо рисайля каринг пэстерэ бутярнэ, тай екхтанэ жылэтар андэ Вирсавия. О Авраамо ашыляпэ тэ жувэл андэ Вирсавия. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Прожыля время, и лэ Авраамости пхэндэ: — Э Милка, ашыля дэй, андя шавэн терэ пхралэсти лэ Нахорости: ");
INSERT INTO rmyvlakh_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","лэ Уцос, лэ англунос, лэ Бузос, лэсти пхралэс, лэ Кемуилос, лэ Арамостерэ дадэс, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","лэ Кеседос, лэ Хазос, лэ Пилдашос, лэ Идлафос тай лэ Бетуилос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","О Бетуило ашыля дад ла Ревэкако. Калэн охто шавэн э Милка андя лэ Авраамостерэ пхралэсти лэ Нахорости. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Лэсти копэльница-ромни Реума андя лэсти шавэн: лэ Тавахос, лэ Гахамос, Тахашос тай Маахас. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Э Сарра прожудя шэл биш ефта бэрша. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Вой муля андо Кирьят-Арба (када исы Хевроно), андэ пхув Ханаано, и о Авраамо авиля тэ грижойпэ тай тэ ровэл палай Сарра. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Тунче о Авраамо отжыля катар э мули ромни тай пхэндя лэ хетеенди: ");
INSERT INTO rmyvlakh_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","— Мэ машкара тумэндэ сым авря пхуятар. Битинэн манди котор пхув важ о прахомос, соп мэ тэ прахой ла муля. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Э хетея пхэндэ лэ Авраамости: ");
INSERT INTO rmyvlakh_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","— Хулай, ашун, ту — Дэвлэско рай сан машкара амэндэ. Прахосар теря муля по майлашо амаро прахомаско тхан. Ни екх амэндар на отпхэнэна тути о прахомаско тхан, соп тэ прахос теря муля. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Тунче о Авраамо ущиля тай тэлиля лэ манушэнди кодыла пхуяти, лэ хетеенди. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Вов пхэндя лэнди: — Сар кай тумэ камэн, соп мэ тэ прахой мэрня муля, тунче ашунэн ман тай помангэн важ мандэ лэ Эфронос, лэ Цохаростерэ шавэс, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","соп вов тэ битинэл манди э пещера Махпела. Вой сыни по бряго пэ лэстери мал. Мэк битинэл ла манди важэ лащи цэмин, сар прахомаско тхан. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","О хетеё о Эфроно бэшэлас машкара пэстерэ мануша тай пхэнэл лэ Авраамости англа саворэ хетея, савэ авилэ каринг лэ форостерэ вудара. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Вов пхэндя: — Най, мэрно хулай, ашун ман. Мэ отдав тути э мал тай э пещера, сави исы пэр латэ. Мэ отдав тути кадя англа мэрнэ мануша. Прахосар теря муля. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","О Авраамо упалэ тэлиля лэ манушэнди кодыла пхуяти ");
INSERT INTO rmyvlakh_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","тай пхэндя лэ Эфроности англа лэндэ: — Ашун жэ и ту ман, мангав тут. Мэ потинава ла маляти цэмин. Лэ мандар ла, соп мэ тэ прахой котэ ла муля. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","О Эфроно пхэндя лэ Авраамости: ");
INSERT INTO rmyvlakh_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","— Ашун ман, мэрно рай: цэмин ла пхуяти штаршэла шэкеля рупэса — када со бут важ тутэ чи важ мандэ? Прахосар теря муля. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","О Авраамо допхэндяпэ лэ Эфроноса тай потиндя лэсти э цэмин важ э мал, сави вов пхэндя англай хетея: штаршэла шэкеля рупэса, сар онгичэлпэ машкара э битинимаря. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Кадя лэ Эфроности мал андо Махпела пашай Мамрэ, э мал тай э пещера пэр латэ, тай саворэ кашта па брягуря ла маляти ся ашылэ ");
INSERT INTO rmyvlakh_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","лэ Авраамостерэ англа саворэ хетея, савэ авилэ каринг лэ форостерэ вудара. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Пала када о Авраамо прахосардя пэстеря ромня ла Сарра андэ пещера пэ мал Махпела пашай Мамрэ (кай сын Хевроно), андэ пхув Ханаано. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Кадя э мал тай э пещера пэр латэ лэ хетеендар ашылэ лэ Авраамостерэ, сар прахомаско тхан. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","О Авраамо сас андэ пхуранэ бэрша, и о РАЙ бахталисардя лэс саворэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","О Авраамо пхэндя лэ барэдэрэ бутярнэсти андэ пэско чер, саво хулаияс пэ ся, со сас лэстэ: — Стхов о васт теро мандэ пэ пулпа ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","тай солаха манди лэ РАЕСА, Саво сыно Дэл лэ нэбоско тай Дэл ла пхуяко, со ту на лэса мэрнэ шавэсти ромня кай э ханаанея, машкара савэ мэ жував, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","ай жаса каринг о тхан, кай мэ аракхадилэм, каринг мэрнэ родуря, тай котэ лэса ромня мэрнэ шавэсти лэ Исаакости. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","О бутярно пушля лэстар: — Ай со, сар кодыя жувли на закамэла тэ жал манца кардэ, андэ кадыя пхув? Со манди тунче тэ терав, тэ рисарав терэ шавэс андэ кодыва тхан, катар ту авилян? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","О Авраамо пхэндя: — Соп тэ на терэлпэ, на рисар инчя мэрнэ шавэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","О РАЙ, Дэл лэ нэбоско, Саво виндярдя ман анда чер лэ дадэско тай па тхан, кай аракхадилем, Саво дэлас дума манца тай солахаясас манди, пхэндя: «Мэ отдава кадыя пхув терэ бэяцэнди», Вов бишалэла Пэстерэ янголос англа тутэ, соп ту тэ лэс котар ромня важ мэрно шаво. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Сар кай э жувли на закамэла тэ жал туса, тунче ту авэса фирисардо кадыла солахатар. Дикх, на рисар инчя мэрнэ шавэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","О бутярно стходя о васт пэ пулпа лэ Авраамости, пэстерэ раести, и солахая лэсти. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Тунче о бутярно ля дэш вэрблюдонэн пэстерэ раестар, стходя пэр лэндэ майлашэ подаркуря и жылятар андо дром. Вов жылятар андо Арам-Нахараимо, па дром каринг форо, кай жувэлас о Нахоро. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Сар ля тэ рятёл, вов тэлярдя лэ вэрблюдонэн пэ чянга катар э хаинг палай бэли лэ форости, кала э жувля авэн пала паи. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Вов пхэндя: — О, РАЙ, Дэл мэрнэ хулаеско лэ Авраамоско! Дэ манди адес тэ полав тай сыкав о тынгимос мэрнэ хулаести лэ Авраамости. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Акэ, мэ тэрдював катар э хаинг, тай э щея лэ форостар авэн пала паи. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Мэк авэла кадя. Сар мэ пхэнава ла щяти: «Мангав тут, змэк о кхоро па пхико, соп мэ тэ пав паи», ай вой тэ пхэнэн: «Пи, ай мэ дава паи и терэ вэрблюдонэнди», кода вой авэла, савя Ту витидян важ о Исаако, Теро копэли. Кадя мэ уганава, со Ту сыкадян о тынгимос мэрнэ хулаести. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Вов инке мангэласпэ, сар каринг э хаинг авиля э Ревэка лэ кхорэса по пхико, вой сас щей лэ Бетуилости, саво сас шаво ла Милкако, э ромни лэ Нахорости, саво сас пхрал лэ Авраамости. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Вой сас фартэ шукарни щей, бахтали щеёры, сави инке на сас муршэса. Вой змэкляпэ тэлэ каринг э хаинг, пхэрдя о кхоро лэ паеса и жыля палпалэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","О бутярно подпрастая каринг латэ и пхэндя: — Мангав тут, дэ манди найбут паи тэ пав анда теро кхоро. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","— Пи, мэрно рай, — пхэндя вой, йито змэкля о кхоро пэ васта тай дя лэсти тэ пэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Кала вов пиля, чялиля, вой пхэндя: — Мэ пхэрава паеса э балая и важ терэ вэрблюдуря, жы кай вонэ на чялёна. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Вой йито вишутя о паи анда кхоро андэ балаи, прастая упалэ каринг э хаинг тэ лэл инке паи тай пхэрэл э балая важ саворэ лэстерэ вэрблюдуря. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Вов мулкумиш лэлас сама пала латэ, камэлас тэ полэл, дя ли о РАЙ бахт лэсти пала со вов авиля. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Кала э вэрблюдуря парашылэ тэ пэн о паи, кодыва мануш виля сомнакуни чен важ о нак, пхаримаса андэ екх бэка, тай дуй сомнакунэ базаликэ, пхаримаса андэ дэш шэкеля, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","и пушля: — Пхэн манди, касти щей ту сан? Исин ли кай теро дад андэ лэско чер тхан, соп амэнди тэ рятярас? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Вой пхэндя лэсти: — Мэ сым лэ Бетуилости щей, вов сыно шаво ла Милкако, савэс вой андя лэ Нахорости. — ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","И инке пхэндя: — Амэндэ исы бут сулума тай ворзо, тай исы тхан кай тэ рятярэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Тунче вов пэля пэ чянга, ля тэ ашарэл лэ РАЕС ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","тай пхэндя: — Бахталисарав лэ РАЕС, лэ Дэвлэс мэрнэ раеско лэ Авраамоско, Саво на ашадя би Пэстерэ тынгимаса тай чячимаса мэрнэ раес, пала кода со о РАЙ андя ман ворта каринг о чер каринг родо мэрнэ раеско. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Э щей прастая черэ и роспхэндя ся пэстеря дати. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Кай э Ревэка сас пхрал, лэс акхарэнас Лавано, тай вов грабимаса жыля каринг кодыва мануш катар э хаинг. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Кати вов дикхля э чэн важ о накх тай э базаликэ пэ васта кай пэсти пхэй и ашундя э дума ла Ревэкати пала кода, со пхэндя лати кодыва мануш, вов жыля каринг о копэли лэ Авраамоско, ай кодыва кадя и тэрдёлас лэ вэрблюдонэнца катар э хаинг. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","— Авэн амэндэ, бахталисардо лэ РАЕСТАР, — пхэндя о Лавано. — Состар ту тердёс аврял? Мэ гэтосардэм о чер тай о тхан важ э вэрблюдуря. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Кодыва мануш зажыля андо чер, тай пай вэрблюдуря излинэ о паримос. Лэ вэрблюдонэнди андэ сулум тай ворзо, ай лэсти тай лэстерэ манушэнди андэ паи тэ халавэн э пэрнэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Лэнди стходэ тэ хан, ай вов пхэндя: — Мэ на лава тэ хав, покэ на роспхэнава пала мэрнэ делуря. — Роспхэн амэди, — пхэндя о Лавано. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","— Мэ сым бутярно лэ Авраамоско. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","О РАЙ бут бахталисардя мэрнэ хулаес, тай вов ашыля барвало. Вов дя лэсти бакрэн, бузнэн тай гурувэн, руп тай сомнак, бутярнэн тай бутярнян, вэрблюдонэн тай ослонэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Мэрнэ хулаести ромни э Сарра андя шавэс, кала сас пхури, и вов отдя лэ шавэсти ся, со исы лэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Мэ солахаем мэрнэ раести, кала вов пхэндя манди: «На лэ ромня мэрнэ шавэсти, лэ щеян кай э ханаанея, пэ кастери пхув мэ жував. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Ай жа каринг мэрнэ дадэско ери, каринг мэрнэ родуря, и лэ котар ромня мэрнэ шавэсти». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Тунче мэ пушлэм мэрнэ раестар: «Ай со, сар кай кодыя жувли на закамэла тэ жал манца?» ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Вов пхэндя: «О РАЙ, англа Кастэ мэ пхирав, бишалэла туса Пэстерэ янголос тай дэла тути бахт, пала со ту жас, соп ту тэ лэс ромня мэрнэ шавэсти мэрнэ родостар тай анда мэрнэ дадэско ери. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","А кала ту жаса каринг мэрно родо, и сар кай вонэ на отдэна ла тути, тунче авэса фирисардо кадыла солахатар». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Кала мэ адес авилэм каринг э хаинг, мэ пхэндэм: «О РАЙ, Дэл мэрнэ раеско лэ Авраамоско, мангав Тут, дэ бахт колэсти, пала со сым бишалдо! ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Акэ мэ тердював катар э хаинг: сави щей авэла пала паи ай мэ пхэнава лати: «Мангав тут, дэ манди паи тэ пав анда теро кхоро», ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ай вой тэ пхэнэл манди: «Пи, ай мэ пхэрава э балая и терэ вэрблюдонэнди», кода кадыя, савя о РАЙ витидя важ о шаво мэрнэ раеско». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Инке мэ мангаваспэ андэ мэрно ди, кала вижыля э Ревэка лэ кхорэса по пхико. Вой змэкляпэ каринг э хаинг и ля о паи. Мэ пхэндэм лати: «Мангав тут, дэ манди паи тэ пав». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Вой йито змэкля о кхоро па пхико и пхэндя: «Пи, ай мэ дава паи терэ вэрблюдонэнди». Мэ пилэм паи, ай вой дэлас паи лэ вэрблюдонэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Мэ пушлэм латар: «Касти ту сан щей?» Вой пхэндя: «Мэ сым лэ Бетуилости щей, вов сыно лэ Нахороско шаво, савэс андя лэсти э Милка». Тунче мэ дэм лати э чен важ о нак тай э базаликэ пэ латерэ васта. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Мэ пэлэм пэ чянга тай лэм тэ бахталисарав лэ РАЕС мэрнэ раестерэ лэ Авраамостерэ Дэвлэс, Саво андя ман чячюнэ дромэса тэ лав мэрнэ раестерэ пхралэстеря внучка пала лэско шаво. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Акана, сар тумэ терэна чячимос тай тынгимос мэрнэ раести, кадя и пхэнэн манди, ай сар на камэн, пхэнэн манди, кай мэ тэ ганав, со манди тэ терав. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","О Лавано тай о Бетуило пхэндэ лэсти: — Кадыя дила жал лэ РАЕСТАР, най амэнди тэ пхэнас тути, тэ отдас чи тэ на отдас. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Акэ э Ревэка англа тутэ, залэ ла и жа, тай мэк вой авэла ромни терэ раестерэ шавэсти, сар пхэндя о РАЙ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Кала о бутярно лэ Авраамоско ашундя кадыя дума, вов тэлиля лэ РАЕСТИ жы каринг э пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Тунче вов виля лащи йида тай сомнакунэ тай рупунэ шукарима и дя лэн ла Ревэкати. И лати пхралэсти тай латеря дати дя кучютнэ подаркуря. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Вов тай лэстерэ мануша, ко сас лэса, халэ, пилэ тай ашэнпэ тэ рятярэн. Кала пэ авэр дес тэсара вонэ ущилэ, вов пхэндя: — Отмэкэн ман, мэ камав тэ жавтар каринг мэрно рай. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Ай лако пхрал тай э дэй пхэндэ: — Мэк э щей ашэлпэ амэнца инке деса пэ дэш, тунче жанатар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ай вов пхэндя: — На заритерэн ман, о РАЙ дя манди бахт тэ стерав кадыя дила. Отмэкэн ман андо дром, соп мэ рисайвав каринг мэрно рай. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Вонэ пхэндэ: — Акхарам ла щея тай пушаса латар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Вонэ акхардэ ла Ревэка тай пушэн латар: — Ту жаса кадылэ манушэса? — Жава, — пхэндя вой. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Ай вонэ бишалдэ пэстеря пхэя ла Ревэка андо дром екхтанэ ла бутярняса, сави барярдя ла, лэ Авраамостерэ бутярнэса тай лэстерэ манушэнца, савэ сас лэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Вонэ бахталисардэ ла Ревэка тай пхэндэ лати: — Пхэй амари, тэ авэн терэ бэяцэ адиномэ панглянца тай инке панглянца, тай тэ залэн терэ бэяцэ пэстерэ ворогонэдерэ форуря. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Э Ревэка тай лати бутярни стидэпэ, бэшлэ пэ вэрблюдуря тай жылэ пала копэли лэ Авраамоско. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","О Исаако рисайля анда Бээр-Лахай-Рои — вов жувэлас андо Негево, — ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","и акэ, вэчероса вов вижыля андэ мал, тай додикхля, со жан э вэрблюдуря. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","И э Ревэка додикхля лэ Исаакос, змэкляпэ па вэрблюдо тэлэ ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","тай пушля кай о бутярно: — Ко кода мануш, саво жал пай мал каринг амэндэ? — Кода мэрно хулай, — пхэндя о бутярно. Тунче вой ушардя о шэро лэ кхоснэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","О бутярно роспхэндя лэ Исаакости пала ся, со вов стердя. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","О Исаако зандярдя ла Ревэка андэ катуна пэстеря датэ ла Саратэ тай ля ла ромняса. Вой ашыля лэсти ромни, тай вов покамля ла. Кадя о Исаако уляпэ пэстеря грижатар тунче, сар муля лэстери дай. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","О Авраамо ля пэсти авря ромня, савя акхарэнас Хетура. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Латар лэстэ аракхадилэ о Зимрано, о Йокшано, о Медано, о Мидьяно, о Ишбако тай о Шуахо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","О Йокшано сас о дад лэ Шэваско тай лэ Деданоско. Э бэяцэ лэ Деданостерэ сас э ашурея, летушэя тай э леумея. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Э шавэ лэ Мидьяностерэ сас о Эфа, о Эферо, о Ханохо, о Авида тай о Элдага. Саворэ вонэ сас бэяцэ ла Хетурати. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","О Авраамо ашадя ся, со сас лэстэ, лэ Исаакости. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Ай лэ шавэнди лэ копэльницэндар-ромняндар, савэ сас кай о Авраамо, вов, сар сас инке жундо, дя подаркуря тай отбишалдя лэн пэстерэ шавэстар лэ Исаакостар по востоко, андэ восточно пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","О Авраамо прожудя 175 бэрша. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Вов атшадя пэстар о духо и муля андэ пэстерэ барэ бэрша, сас чяло лэ жувимастар и жылятар кай пэстерэ мулэ папуря. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Лэстерэ шавэ о Исаако тай о Измаило прахосардэ лэс андэ пещера Махпела катар о Мамрэ, пэ мал лэ хетеёстери лэ Эфроностери, саво сас шаво лэ Цохароско. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Кадыя мал о Авраамо тиндя кай э хетея. Котэ о Авраамо сас прахомэ катар пэстери ромни Сарра. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Кала Авраамо муля, о Дэл бахталисардя лэстерэ шавэс лэ Исаакос. О Исаако жувэлас катар о Бээр-Лахай-Рои. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Акэ э дума пала Измаило, шаво лэ Авраамоско, савэс андя лэ Авраамости э Агарь египтянка, ла Саррати копэльница, тай пала лэстерэ потомкуря. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Акэ лэ Измаилостерэ шавэнди алава, сар вонэ аракхадилэ екх пала екхэстэ: о Невайото, англуно шаво лэ Измаилоско, о Кедаро, о Адбеэло, о Мивсаимо, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","о Мишма, о Дума, о Маса, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","о Хададо, о Тема, о Етуро, о Нафишо тай о Кедма. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Када алава лэ Измаилостерэ шавэнго, дэшудуй барэдэра, лэнди породуря, гава тай таборуря. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","О Измаило прожудя 137 бэрша. Вов атшадя пэстар о духо и муля, и жылятар кай пэстерэ мулэ папуря. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Лэстерэ бэяцэ жувэнас пэ тхана пай пхув, сави цырдэласпэ ла Хавилатар жы каринг о Шуро, паша лэ египтоско бряго, па дром каринг о Ашуро. И вонэ жувэнас андэ холи саворэнца пэстерэ пхралэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Акэ э дума пала Исаако, шаво лэ Авраамоско, тай пала лэстерэ потомкуря. Кай о Авраамо аркхадиля о Исаако. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Лэ Исаакости сас саранда бэрша, кала вов ля ла Ревэка, лэ арамеёстеря лэ Бетуилостеря щя. Вов сас катар э пхув Падан-Арамо. Вой сас лэ арамеёстеря лэ Лаваностеря пхья. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","О Исаако мангэласпэ лэ РАЕСТИ пала пэстери ромни, пала кода со латэ на сас бэяцэ. О РАЙ ля сама пэ лэско мангимос, тай лэсти ромни э Ревэка ашыля пхари. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Э бэяцэ латэ андо йило линэ тэ марэн екх екхэс. Э Ревэка пхэндя: — Пала со када манди? Вой жыля тэ пушэл лэ РАЕСТАР. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","О РАЙ пхэндя лати: — Андэ теро йило исы дуй породуря, тутар авэна и росжанапэ дуй народуря. Екх народо авэла майзорало аврэстар, тай о барэдэр пхрал авэла копэли кай о цыкно пхрал. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Кала авиля лати э время тэ анэл бэятонэн, андэ лако йило чячес сас дуй шаворэ-близнецуря. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","О англуно аракхадиля лоло, тай ся лэстери тила сас ушаради андэ балэндэ, сар пислатери йида. Пала кода динэ лэсти алав Исаво. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Тунче сыкадиля лэско пхрал, саво ритярдёласпэ лэ вастэса пала пэрно лэ Исавоско, пала кода динэ лэсти алав Яково. Лэ Исаакости сас шовдэша бэрша, кала э Ревэка андя лэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Кала э бэяцэ вибариле, о Исаво тердяпэ лашо астаримари, малянго мануш, ай о Яково сас мануш ковло, саво жувэлас андэ катунэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Лэ Исаакости фартэ чялёлас тэ хал тадо дыко мас, тай вов будэр камэлас лэ Исавос, ай э Ревэка будэр камэлас лэ Яковос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Екхвар, кала о Яково тавэлас хамос, о Исаво авиля ла малятар фартэ бокхало. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Вов пхэндя лэ Яковости: — Майито, дэ манди найбут тэ хав кода лоло хамос, саво ту тавэс! Мэ мэрав бокхатар! Акэ состар лэсти инке динэ алав Эдомо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","О Яково пхэндя: — Данглал битин манди теро англуно тхан. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","— Мэ мэрав бокхатар, — пхэндя о Исаво. — Со манди кодылэ англунэ тханэстар? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","О Яково пхэндя: — Данглал солаха. Вов солахая тай кадя битиндя пэско англунимос лэ Яковости. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Тунче о Яково дя лэ Исавости марно тай чечевично хамос. Вов халя, пиля, ущиля и жылятар. Кадя о Исаво тходя андо нисо пэско англунимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Пэ пхув сас бокх, — най кодыя бокх сави сас, сар сас жундо о Авраамо, — тай жал о Исаако каринг о Авимелехо, о филистимско тхагар андо Гераро. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","О РАЙ сыкадиляпэ лэ Исаакости тай пхэндя: — На жа андо Египто. Жув пэ кадыя пхув, кай Мэ пхэнава тути тэ жувэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Жув ту пэ кадыя пхув пэ времятэ, ай Мэ авава туса тай бахталисарава тут. Мэ стерава кода, андэ со солахаем терэ дадэсти лэ Авраамости, тай дава саворэ кадыла пхуя тути тай терэ бэятонэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Мэ стерава, со тутэ авэна бут бэяцэ, сар э чергая по нэбо, тай дава лэнди саворэ кадыла пхуя, тай па терэ бэяцэ авэна бахталисардэ э народуря па ся пхув, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","пала кода со о Авраамо кандэлас Ман тай фирияс алава, савэнца Мэ сыкадэм, савэ Мэ устходэм тай припхэндэм. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","О Исаако ашыля тэ жувэл андо Гераро. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Кала э мануша, савэ жувэнас андэ кодыва тхан, пушлэ лэстар пала лэстери ромни, вов пхэндя: «Када мэрни пхэй». Вов дарайля тэ пхэнэл: «Када мэрни ромни». Вов гындосарэлас: «Э мануша кадылэ тханэсти умарэна ман важ э Ревэка, пала кода со вой шукарни». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Екхвар, кала о Исаако прожудя котэ бут время, о Авимелехо, о филистимско тхагар, дикхэлас тэлэ андай фэлястра тай додикхэл, сар о Исаако малий пэстеря ромня ла Ревэка. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Тунче о Авимелехо акхардя лэс пэстэ и пхэндя: — Акэ, пэ чячимастэ, вой сыни тери ромни! Пала со ж ту пхэндян: «Вой мэрни пхэй»? О Исаако пхэндя лэсти: — Мэ гындосарэлас, со пала латэ ман умарэна. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Тунче о Авимелехо пхэндя: — Со ж ту тердян амэнца? Екх лэ муршэндар камэлас тэ пашлилол теря ромняса, тай ту андя бы пар амэндэ дош. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","О Авимелехо пхэндя саворэ манушэнди: — Ко тумэндар терэла вырыто кадылэ манушэсти тай лэстеря ромняти, кодыва авэла умардо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","О Исаако шутя о ворзо пэ маля андэ кодыя пхув тай андэ кодыва жэ бэрш стидя шэлвар майбут. О РАЙ бахталисардя лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","О Исаако ашыля барвало, лэско барвалимос ашэлас майбут, тай вов ашыля фартэ барвало. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Лэстэ сас кацавэ барэ гуртуря цыкно тай баро ското тай скати бутярнэ, со э филистимлянуря ритярэнас холи пэр лэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Вонэ зашутэ саворэ хаинга ла пхуяса, савэ виганадэ лэсти дадэстерэ бутярнэ, кала инке лэско дад о Авраамо сас жундо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Тунче о Авимелехо пхэндя лэ Исаакости: — Жатар амэндар, ту ашылян майзор амэндар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","О Исаако жылятар котар, тай стходя э катунэ по машкарплаенго тхан Гераро и жувэлас котэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","О Исаако вужардя э хаинга, савэ сас виганадэ инке лэстерэ дадэса лэ Авраамоса, ай сар о Авраамо муля, лэн зашутэ пхуяса э филистимлянуря. О Исаако дэл лэнди кацавэ ж алава, савэ данглал дясас лэско дад. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Э бутярнэ лэ Исаакости линэ тэ ганавэн пэ кодыва тхан тай пхэрнавэн котэ хаинг паеса, саво марэлас андай пхув, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","ай э герароски пастухоря тердэ чингар лэ Исаакостерэ пастухонэнца. Вонэ пхэндэ: «Када амаро паи!» Вов дя ла хаингати алав Эсэко, пала кода со важ латэ сас чингар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Тунче вонэ виганадэ авэр хаинг, и важ латэ тердэ чингар. Вов дя лати алав Ситна. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Вов жылятар котар тай виганавдя инке екх хаинг, пала сави на сас чингар. Вов дя лати алав Рэховото тай пхэндя: «Акана о РАЙ дя амэнди бугло тхан. Амэ жуваса катэ, тай пэ кадыя пхув амэн авэла майбут». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Тунче о Исаако жылятар андэ Вирсавия. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Андэ кодыя ж рят о РАЙ сыкадиля лэсти тай пхэндя: — Мэ сым о Дэл лэ Авраамоско, терэ дадэско. На дара, Мэ сым туса. Мэ бахталисарава тут тай терава, со терэ бэятонэн авэла майбут важ Мэрно копэли о Авраамо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","О Исаако стердя котэ жэртвенико тай тэлиля лэ РАЕСТИ. Вов стходя пэсти катуна, ай лэстерэ бутярнэ линэ тэ ганабэн э хаинг. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Тунче авиля каринг лэстэ анда Гераро о Авимелехо екхтанэ лэ Ахузатоса, лэско подпхэндимарэса, тай лэ Фихолоса, о барэдэрэса пэ лэстерэ халавдэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","О Исаако пушля лэндар: — Ай со тумэ авилэ мандэ, ке тумэ сас холяти пэр мандэ тай витрадэ ман? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Вонэ пхэндэ: — Амэ мишто дикхлям, со туса о РАЙ, тай амэ камас, соп ту и амэ трэбуй тэ солахас тай тэ допхэнаспэ. Терам союзо, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","со ту нисо на терэса амэнди вырыто, сар и амэ на мардям тути, ай ся время обжасаспэ туса мишто тай отмэклям тут тэ жастар лашымаса. Ай акана ту сан бахталисардо лэ РАЕСА. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","О Исаако стходя лэнди лащи мисяля, и вонэ халэ тай пилэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Пэ авэр дес кати кай э тэсара вонэ солахае екх екхэсти, о Исаако отмукля лэн, тай вонэ жылэтар лашымаса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Андэ кодыва ж дес авилэ э бутярнэ лэ Исаакости тай роспхэнэн лэсти пала э хаинг, сави вонэ виганадэ. Вонэ пхэндэ: — Амэ аракхлям о паи! ");
INSERT INTO rmyvlakh_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Вов дя алав ла хаингати Шыва, тай жы адесутнэ десэстэ о алав кадылэ фороско исы Вирсавия. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Кала лэ Исавости ашыля саранда бэрша, вов ля пала пэстэ ла Ехудита, лэ хетеёстеря лэ Бээриёстеря щя, тай лэ Басемата, лэ хетеёстеря лэ Элоностеря щя, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","тай лэндар сас бут вырытимос лэ Исаакости тай ла Ревэкати. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Кала о Исаако пхуриля тай лэстерэ якха корайле, со вов будэр на дикхэлас, вов акхардя лэ Исавос, пэстерэ барэдэрэ шавэс, и пхэндя лэсти: — Мэрно шаво! — Мэ сым катэ, — пхэндя о Исаво. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","О Исаако пхэндя: — Мэ сым пхуро, тай на ганав, скаци манди ашыля тэ жував. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Лэ теро колчяно тай о луко тай жа андэ мал, астар манди варисо ла малятар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Гэтосар мэрно хамос, саво мэ камав, тай ан манди тэ хав, соп мэ тэ бахталисарав тут, данглал сар тэ мэрава. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ай э Ревэка ашундя, сар о Исаако дэлас дума пэстерэ шавэса лэ Исавоса, тай кала о Исаво жылятар андэ мал тэ астарэл тай тэ анэл варисо ла малятар, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","э Ревэка пхэндя пэстерэ шавэсти лэ Яковости: — Мэ ашундэм, сар теро дад пхэндя терэ пхралэсти лэ Исавости: ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","«Ан варисо ла малятар астар, ан тай гэтосар манди лашо хамос, соп мэ тэ бахталисарав тут англа РАЙ, данглал сар мэ мэрава». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Акана ашун ман мишто, мэрно шаво, тай тер кадя, сар мэ тути пхэнава. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Жа каринг о гурто тай ан манди дуен лашэ бузнорэн, соп мэ тэ гэтосарав лашо хамос терэ дадэсти, кацаво, сар вов камэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Тунче одындяр лэсти тэ хал, вов хала тай бахталисарэла тут, данглал сар тэ мэрэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","О Яково пхэндя ла Ревэкати, пэстеря дати: — Мэрно пхрал о Исаво ся андэ балэндэ, ай мандэ э морчи вужы. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ай со, сар мэрно дад малия ман? Тай мэ теравапэ англа лэстэ хохавно тай дэла ман амрая, ай на бахталимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Лэстери дэй пхэндя: — Кодыя амрая мэк пэрэл пэр мандэ, мэрно шаво, ай ту тер кадя, сар мэ пхэнав: жа тай ан лэ бузнорэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Тунче вов жыля ля лэ бузнорэн тай андя лэн пэстеря дати, ай вой гэтосардя лашо хамос, кацаво, саво камэлас лэско дад. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Тунче э Ревэка ля майлащи йида пэстерэ барэдэрэ шавэсти лэ Исавости, сави сас лэстэ андо чер, тай вурядя лэ цыкнэ шавэс лэ Яковос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Ай э васта тай э вужы кор ушарадя лэ бузнорэндеря морчянца. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Тунче вой дя пэстерэ шавэсти лэ Яковости о лашо хамос тай о марно, савэ гэтосардя. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Вов авиля каринг о дад тай пхэнэл: — Мэрно дад. — Мэ катэ, — пхэндя кодыва котар. — Ту саво сан мэрнэ шавэндар? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","О Яково пхэндя дадэсти: — Мэ сым о Исаво, теро барэдэр шаво. Мэ стердэм, сар ту пхэндян. Мангав тут, ваздэпэ, бэш тай лэ ха мэрно хамос, соп тутэ тэ авэл зор тэ бахталисарэс ман. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","О Исаако пушля лэ шавэстар: — Мэрно шаво, сар ту кадя йито аракхлян ла? — О РАЙ, теро Дэл, бишалдя ла манди, — пхэндя вов. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","О Исаако пхэндя лэ Яковости: — Мэрно шаво, поджа майпашэ мандэ, соп мэ помалий тут, тэ ганав чячес, ту мэрно шаво о Исаво чи най. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","О Яково поджыля майпашэ пэстерэ дадэстэ лэ Исаакостэ, саво помалисардя лэс и пхэндя: — О гласо — сар кай о Яково, ай э васта — сар кай о Исаво. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Вов на гатярдя лэс, пала кода со э васта сас лэстэ андэ балэндэ, сар кай о Исаво. И вов бахталисардя лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","— Чячес ту сан мэрно шаво о Исаво? — пушля о Исаако. Кодыва пхэндя: — Эгэ, када мэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Тунче о Исаако пхэндя: — Мэрно шаво, подындяр манди майпашэ теро хамос, тай мэ хава, ай тунче бахталисарава тут. О Яково дя лэсти тэ хал, и вов халя. Тунче андя лэсти чехыри, и вов пиля. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Тунче лэско дад о Исаако пхэндя лэсти: — Поджа мандэ, мэрно шаво, тай чюмидэ ман. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Вов поджыля тай чюмидя лэс. О Исаако гатярдя о фано лэстерэ гадэстар тай бахталисардя лэс, пхэндя: — О-о, о фано мэрнэ шавэско — сар о фано ла малятар, сави бахталисардя о РАЙ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Мэк дэл тути о Дэл лэ нэбостар э дросын тай о барвалимос, саво дэл э пхув бут марно тай тэрно чехыри. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Тэ авэн тутэ копэля э народуря, тай тэ тэлён вонэ тути. Ав раеса пэ терэ пхрала, тай тэ тэлён англа тутэ э шавэ теря дати. Кодыва, ко дэла амрая тут, тэ авэл дино амрая, ай ко бахталисарэла тут, тэ авэл бахталисардо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","О Исаако парашыля тэ бахталисарэл, тай кати о Яково жылятар пэстерэ дадэстар, сар авилятар лэско пхрал о Исаво па астаримос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Вов гэтосардя лашо хамос тай андя пэсти дадэсти. Вов пхэндя лэсти: — Дадэ, мангав тут, ваздэпэ, бэш тай лэ ха мэрно хамос, ай тунче бахталисарэса ман. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","О Исаако, лэско дад, пушля: — Ко ту сан? — Мэ сым теро шаво, — пхэндя вов, — теро англуно, о Исаво. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","О Исаако ся заздрая тай пхэнэл: — Ко сас кодыва авэр, саво астардя ла малятар тай андя манди хамос? Мэ халэм лэс англа кода, сар ту тэ авэс, тай бахталисардя лэс. Вов акана тай авэла бахталисардо! ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Кала о Исаво ашундя кадыя дума, кыркэс заровля, зацыписардя тай пхэндя пэсти дадэсти: — Бахталисар и ман, и ман, дадэ! ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ай кодыва пхэндя: — Теро пхрал авиля лэ хохаимаса тай отля тутар э бахталимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","О Исаво пхэндя: — Чячимаса, лэс кочя и акхарэн Яковоса? Вов дувар хохадя ман: заля мэрно англунимо тхан, ай акана тай мэрни бахталимос! Тай пушля: — Дадэ, на ашыляпэ тутэ и важ мандэ бахталимос? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","О Исаако пхэндя лэ Исавости: — Мэ стердэм лэс хулаеса тутэ, тай саворэн лэстерэн пхралэн отдэм лэсти андэ копэля, тай бахталисардэм лэс марнэса тай тэрнэ чехыреса. Со ж мэ терава акана важ тутэ, мэрно шаво? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","О Исаво пхэндя пэсти дадэсти: — Тутэ со, кати екх бахталимос, дад? Бахталисар и ман, мэрно дад! Тай фартэ маладя тэ ровэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Лэско дад о Исаако пхэндя лэсти: — Авэла о жувимос теро дур лэ барвалимастар, саво дэл э пхув, дур лэ нэбэснона дросынатар упрал. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ту лэса тэ жувэс ла шурятар тай авэса копэли терэ пхралэсти. Ай авэла время, кала ту ваздэсапэ, тай ту исшоса лэско гамо пэстар пай кор. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","О Исаво ритярэлас холи по Яково пала э бахталимос, сави дя лэсти лэско дад, тай вов пхэндя екхжэно пэсти: «Йито авэла время, кала лэна тэ ровэн пала мэримос лэ дадэско. Тунче мэ умарава мэрнэ пхралэс лэ Яковос». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Лэ Ревэкати пэрэдинэ э дума, со пхэндя лако барэдэр шаво о Исаво, тай вой бишалдя пала цыкно шаво, пала Яково, тай пхэндя лэсти: — Теро пхрал о Исаво стходя гындо тэ умарэл тут. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Мэрно шаво, акана стер кадя, сар мэ пхэнава: майито наштар андо Харано каринг мэрно пхрал, кай о Лавано. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Пожув лэстэ сави-то время, жы кай на улэлпэ э холи терэ пхралэсти. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Кала э холи терэ пхралэсти улэлапэ тай вов бистрэла кода, со лэсти тердян, тунче мэ бишалава тэ пхэнэн тути, со авиля время тэ рисайвэс черэ. Пала со мэ тэ хасарав тумэн лэ дуен андэ екх дес? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Тунче э Ревэка пхэндя лэ Исаакости: — Мэ найлошали лэ жувимасти пала кала хетеянкэ. Сар и о Яково лэла пэсти ромня хетеянка, сар кадыла, тунче пала со манди тэ жував? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","О Исаако акхардя лэ Яковос, бахталисардя лэс тай пхэндя лэсти: — На лэ пала пэстэ ханаанеянка. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Грабисав жатар андо Падан-Арамо, каринг о Бетуило, теря дако дад. Тай лэ котэ пэсти ромня лэ Лаваностерэ щеян, кай теря дако пхрал. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Тэ бахталисар тут о Дэл Саворэзорэско тай тэ стерэл тэ авэн тутэ бут бэяцэ, соп тэ жан тутар бут народуря. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Тэ дэл Вов тути тай терэ бэятонэнди лэ Авраамостери бахталимос, тай тэ залэс ту э пхув, пэ сави екхатар жувэс, э пхув, сави о Дэл дя лэ Авраамости. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Тунче о Исаако отмэкля лэ Яковос, ай кодыва жылятар андо Падан-Арамо, каринг о Лавано, лэ Бетуилоско шаво, ай о Бетуило о арамеё, пхрал ла Ревэкако, сави сас дэй лэ Яковости тай лэ Исавости. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","О Исаво угангля, со о Исаако бахталисардя лэ Яковос тай бишалдя лэс андо Падан-Арамо, соп тэ лэл котар пэсти ромня, тай со вов бахталисардя лэс, пхэндя лэсти: «На лэ ханаанеянка», ");
INSERT INTO rmyvlakh_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","тай со о Яково кангля пэстерэ дадэс тай ла да и жыля андо Падан-Арамо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Тунче о Исаво поля, сар на чялёнас лэ Исаакости, лэстерэ дадэсти, э ханаанеянкэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Вов жал каринг о Измаило тай лэл пэсти инке екха ромня, ла Махалата, сави сас пхэй лэ Невайотости ай щей лэ Измаилостери, о шаво лэ Авраамоско. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","О Яково ашадя э Вирсавия тай жылятар андо Харано. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Кала вов дожыля варисавэ тханэстэ, ашыляпэ тэ рятярэл, пала кода со о кхам бэшля. Вов ля екх бар, стходя лэс пэсти тэла шэро и пэля тэ совэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Лэсти дикхляпэ суно: вов дикхэл лесница, сави тэрдёлас пэ пхув, а о вэрхо лако дорэсэлас жы каринг о нэбо, тай э янголуря лэ Дэвлэстерэ ваздэнаспэ упрэ тай змэкэнаспэ тэлэ пар латэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Упрэ понадэ латэ тэрдёлас о РАЙ тай дэлас дума: — Мэ сым о РАЙ, Дэл терэ дадэско лэ Авраамоско тай Дэл лэ Исаакоско. Э пхув, пэ сави ту екхатар пашлёс, Мэ дава тути тай терэ бэятонэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Терэ бэятонэн авэла кадя бут, сар о прахо ла пхуяко, тай тутар авэна бэяцэ пэ саворэ ла люматерэ рига. Ту и терэ бэяцэ авэна бахталимаса важ всаворэ народуря пэ пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Мэ сым туса тай авава тут тэ фирисарав, каринг ту на жаса, тай рисарава тут кардэ пэ кадыя пхув. Мэ на ашавава тут тай стерава ся, со пхэндэм тути. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Кала о Яково просутяпэ, вов гындосарэлас: «Чячес, пэ када тхан о РАЙ, ай мэ на ганавас». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Лэсти сас дар, и вов пхэндя: — Сар даравэл кадыва тхан! Чячимаса, катэ о чер лэ Дэвлэско, тай када — э вудара лэ нэбости. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Кати кай о дес, о Яково ущиля, ля о бар, саво сас лэстэ тэла шэро, стходя лэс ворта и шутя пэр лэстэ о вулей. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Вов дя алав кодылэ тханэсти Вефиль, ай данглал кода форо акхарэласпэ Лузо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Тунче о Яково солахая и пхэндя: — Сар о Дэл авэла манца тай фирисарэла андэ кадыва дром, тай дэла о марно тэ хав тай э йида пэ пхикэ, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","кадя со мэ рисайвава тай лава тэ жував лошаса андо чер мэрнэ дадэско, тунче о РАЙ авэла мэрнэ Дэвлэса, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","тай кадыва бар, саво мэ стходэм ворта, авэла лэ Дэвлэско чер, тай саворэстар, со Ту дэса манди, мэ дава Тути дэшто котор. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","О Яково жаластар майдур тай авиля пэ пхув каринг э восточни народуря. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Котэ вов додикхля хаинг андэ мал тай катар латэ трин гуртуря бакрэн, пала кода со андай кодыя хаинг паярэнас лэ скотос. Э хаинг сас ушаради барэ барэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Кала саворэ гуртуря стидэнаспэ, э пастухоря злэнас о бар тай паярэнас лэ бакрэн, ай тунче стхонас о бар палпалэ по тхан. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","О Яково пушля кай э пастухоря: — Пхрала, катар тумэ? — Амэ сам анда Харано, — пхэндэ вонэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","О Яково пушля: — Ай тумэ ганэн лэ Лаванос, лэ Нахоростерэ внукос? — Эгэ, ганас, — пхэндэ вонэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","— Сар лэстэ ся мишто? — Ся мишто, — пхэндэ вонэ. — Ай акэ э Рахиль, лэстери щей, жал лэ бакрэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","— О кхам инке вучес сыно, — пхэндя вов. — Инке най время тэ стидэн о ското. Дэн паи лэ бакрэнди тай даравэн лэн палпалэ пэ мал. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","— Амэнди нащи, — пхэндэ вонэ. — Трэбуй тэ стидэнпэ ся гуртуря тай тэ злэн о бар пай хаинг, тунче амэ даса паи лэ бакрэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Вов инке дэлас дума лэнца, кала поджыля э Рахиль пэстерэ дадэстерэ бакрэнца — вой праварэлас лэ бакрэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Кала о Яково додикхля лэ Рахиля лэстерэ какостеря лэ Лаваностеря щя, лэ бакрэнца и бузнэнца, вов поджыля изля пай хаинг о бар тай дя паи лэ Лаваностерэ бакрэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Тунче о Яково чюмидя ла Рахиля тай фартэ заровля, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","и пхэндя лати, со вов родо лати дадэсти, ла Ревэкако шаво. Э Рахиль прастая тай роспхэнэн пэстерэ дадэсти. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Кала о Лавано ашундя, кай авиля лэстеря пхьяко шаво, вов прастая каринг лэстэ, обля лэс, чюмидя тай акхардя лэс пэстэ андо чер. О Яково роспхэндя лэсти пала ся, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","ай о Лавано пхэндя: — Ту сан мэрно чячё рат тай мэрни тила. Кала о Яково прожудя лэстэ шон, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","о Лавано пхэндя лэ Яковости: — Ту сан манди родо, ай пала со ту трэбуй тэ терэс бути важ мандэ йивья? Пхэн манди, соза тути тэ потинав. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Кай о Лавано сас дуй щея: ла барэдэря акхарэнас Лия, ай ла цыкня — Рахиль. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Кай Лия сас ковлэ якха, ай э Рахиль сас шукарни тай лащи пай муй и пэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","О Яково покамля ла Рахиля тай пхэндя лэ Лаваности: — Мэ лава тэ терав тути бути ефта бэрша пала тери цыкни щей, палай Рахиль. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","О Лавано пхэндя: — Фэдэр мэ отдава ла тути, ай най варикасти аврэсти. Ашпэ мандэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","О Яково терэлас бути ефта бэрша, соп тэ лэл ла Рахиля, и кадыла бэрша прожылэ важ лэстэ, сар найбут деса, пала кода со вов камэлас ла. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Тунче о Яково пхэндя лэ Лаваности: — Дэ манди мэрня ромня, соп мэ тэ жував ласа сар ромняса: авиля мэрни время. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","О Лавано акхардя саворэн, ко жувэлас найдур паша лэстэ, тай стходя лащи мисяля. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ай сар авиля э рят, о Лавано ля пэстеря щя ла Лия тай дя ла лэ Яковости, и о Яково сутя ласа. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","О Лавано дя ла щяти ла Лияти пэстеря бутярня ла Зелфа. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Кала десайля, о Яково дикхля, ай кода э Лия! Вов пхэндя лэ Лаваности: — Со ту тердян манца? Мэ жэ тердэм тути бути палай Рахиль. Пала со ту хохадян ман? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","О Лавано пхэндя: — Амэндэ на отдэн пала ром ла цыкня щя данглал ла барэдэрятар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Стер о ябьявэско курко кадыла щяса, ай тунче амэ отдава тути и ла цыкня, важ авэр ефта бэрша бути. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","О Яково кадя и тердя: прондярдя о курко лэ ябьявэско ла Лияса, ай тунче о Лавано отдя лэ Яковости пэстеря щя ла Рахиля. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","О Лавано дя ла Рахиляти пэстеря бутярня ла Вала. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","О Яково ля тэ жувэл ла Рахиляса тай камэлас ла майбут, сар ла Лия. Вов терэлас бути лэ Лаваности инке ефта бэрша. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Кала о РАЙ дикхля, со э Лия исы найкамли, Вов отпхандя лати э пэрь, соб тэ анэл бэятонэн. Ай э Рахиль сас бибэяцэндери. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Э Лия ашыля пхари тай андя шаворэс. Вой пхэндя: «О РАЙ додикхля мэрни бибахт. Акана мэрно ром чячес лэла ман тэ камэл», тай дя лэсти алав Рувимо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Вой упалэ ашыля пхари тай, кала андя шаворэс, пхэндя: «Акэ сар о РАЙ ашундя, со мэ найкамли, Вов дя манди инке кадылэ шаворэс». Вой дя лэсти алав Симеоно. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Вой упалэ ашыля пхари тай, кала андя шаворэс, пхэндя: «Акана мэрно ром приашэла каринг мандэ, пала кода со мэ андэм лэсти тринэн шавэн». Пала кода лэс акхарэнас Левиё. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Вой упалэ ашыля пхари тай, кала андя шаворэс, пхэндя: «Акана мэ ашарава лэ РАЕС». Пала кода дя лэсти алав Иуда. Тунче вой парашыля тэ анэл бэятонэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Э Рахиль дикхэлас, со вой на анэл лэ Яковости бэятонэн, тай ритярэлас холи пэ пэстери пхэй, пэ Лия. Вой пхэндя лэ Яковости: — Дэ манди бэятонэн, а то мэ мэрава! ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","О Яково холяйля пэр латэ и пхэндя: — Мэ со, сым о Дэл, Саво на дэл тути бэятонэн? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Тунче вой пхэндя: — Акэ э Вала, мэрни копэльница. Сов ласа, соб вой тэ анэл бэятос мандэ пэ чянга, тай кадя и мандэ авэна бэяцэ пар латэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Кадя вой дя лэсти пэстеря бутярня ла Вала, сар ромня, о Яково сутя ласа. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Вой ашыля пхари тай андя лэсти шавэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Тунче э Рахиль пхэндя: «О Дэл сыкадя мэрно чячимос, Вов ашундя мэрно мангимос тай дя манди шавэс». Пала кода вой дя лэсти алав Дано. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Э Вала, э бутярни ла Рахиляти, упалэ ашыля пхари тай андя лэ Яковости дуйтонэ шавэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Тунче э Рахиль пхэндя: «Барэ маримаса мэ мараваспэ мэрня пхьяса тай биросардэм». И вой дя лэсти алав Нефалимо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Кала э Лия дикхля, кай вой парашыля тэ анэл бэятонэн, вой ля пэстеря бутярня ла Зелфа тай дя ла лэ Яковости сар ромня. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Ла Лиятери бутярни э Зелфа андя лэ Яковости шавэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Э Лия пхэндя: «Сави бахт!» Тай дя лэсти алав Гадо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Лэ Лиятери бутярни э Зелфа андя лэ Яковости дуйтонэ шавэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Э Лия пхэндя: «Сави мэ сым бахтали! Э жувля пхэнэна пэр мандэ сави бахтали!» Тай дя лэсти алав Асиро. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Андэ кодыя время, кала э мануша стидэн э пшэница, о Рувимо жыля андэ мал, аракхля мандрагоруря тай андя лэн пэстеря дати. Э Рахиль пхэндя ла Лияти: — Мангав тут, дэ манди найбут терэ шавэсти мандрагоруря. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ай кадыя пхэндя лати: — Ту залян мандар лэ ромэс, ай акана камэс тэ залэс мэрнэ шавэстерэ мандрагоруря? — Драго, — пхэндя э Рахиль, — мэк вов совэл туса кадыя рят, ай ту отдэса манди терэ шавэстерэ мандрагоруря. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Кала каринг э рят о Яково авилятар лэ маляндар, э Лия вижыля англа лэстэ и пхэндя: — Ту трэбуй тэ совэс манца. Мэ потиндэм важ тутэ лэ шавэстерэ мандрагоронэнца. И вов сутя ласа андэ кодыя рят. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","О Дэл ашундя ла Лия, вой ашыля пхари тай андя лэ Яковости панчтонэ шавэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Тунче э Лия пхэндя: «О Дэл дя манди награда пала кода, со мэ дэм лэ ромэсти мэрня бутярня». Тай дэл лэсти алав Исахаро. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Э Лия упалэ ашыля пхари тай андя лэ Яковости шовтонэ шавэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Вой пхэндя: «О Дэл дя манди кучютно подарко. Акана мэрно ром дэла манди патив, пала кода со мэ андэм лэсти шовэн шавэн». И Лия дя лэсти алав Завулоно. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Пай варисави-то время вой андя щеёра и дя лати алав Дина. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","О Дэл сэрэсардя пала э Рахиль, ашундя лако мангимос тай терэл кадя, соп вой тэ анэл бэятонэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Вой ашыля пхари тай андя лэ шавэс и пхэндя: «О Дэл изля пар мандэ мэрно лажавимос». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Вой дя лэсти алав Иосифо, пала кода со вой пхэндя: «Тэ дэл манди о РАЙ инке екхэ шавэс». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Пала кода сар э Рахиль андя лэ Иосифос, о Яково пхэндя лэ Лаваности: — Отмэк ман, соп мэ тэ рисайвав пэ пхув, кай аракхадилэмас. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Дэ манди мэрнэ ромнян тай лэ бэятонэн, пала савэ мэ теравас бути тути, тай мэ жаватар андо дром. Ту ганэс, сар бут мэ теравас бути тути. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Ай о Лавано пхэндя лэсти: — Сар кай мэ аракхлэм лашымос англа терэ якха, мангав тут, ашпэ: мэ уганглэм пай врэжа, со о РАЙ бахталисардя ман пала тутэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Пхэн тери цымин, мэ потинава ла. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","О Яково пхэндя лэсти: — Ту ганэс, сар мэ теравас бути тути тай савэ терэ гуртуря ашылэ, сар мэ лэн праваравас. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Жы мандэ лэн на сас бут, ай акана вонэ тердэпэ пэ бутэстэ майбут, тай о РАЙ бахталисардя тут пала мандэ. Кала жэ акана мэ стидава варисо важ мэрно чер? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","О Лавано пушля: — Со тути тэ дав? — Манди нисо на трэбуй, — пхэндя о Яково. — Стер важ мандэ кати екх, тай мэ лава и майдур тэ праварав тай тэ фирисарав теро цыкно тай баро ското. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Мэк ман тэ обжав саворэ гуртуря тай тэ стхав ригатар саворэ пятнисти и э крапчяти бакрэн и бузнэн тай саворэ калэ бакрорэн. Вонэ авэна мэрно потинимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","О чячимос мэрно дичёлапэ ангэ, кала закамэса ту тэ дикхэс о потинимос, саво дян манди. Тай сар кай ту аракхэса мандэ най крапчято тай най пятнисто бузно тай кало бакроро, вонэ лэна тэ ангиченпэ чёрданэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","— Допхэндямпэ, — пхэндя о Лавано. — Мэк авэла кадя, сар ту пхэндян. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Тай андэ кодыва жэ дес вов отходя ригатар саворэ бузнэн лэ крапинэнца тай лэ латкэнца, саворэ пятнисти тай крапчяти бузнян — колэ, пэ савэ сас парнимос, — тай саворэн калэ бакрорэн тай отдя лэн тэ дикхэн лэсти шавэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Вов тердя тэ авэл машкара пэстэ и Яково тринэ десэнго дром, ай о Яково кадя ж праварэлас лэ Лаваностерэ бакрэн, савэ ашылэпэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","О Яково вишындя зэлэни рувля па тополи, миндалё тай пай чинаря, зля э шкорка и стердя пэр лэндэ парнэ тхана. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Вов стходя э опшындэ рувля андэ саворэ балая, соп вонэ тэ авэн ворта англа ското, кала о ското авэл тэ пэл паи. Андэ кодыя время, кала э бакря ашэн пхарэ, сар авэнас тэ пэн паи, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","вонэ терэнас кода англа рувля, тай э бакрорэ аркхадёнаспэ лэндэ пёстри, крапчяти тай пятнисти. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Инке о Яково бандярэлас лэ бакрэн каринг э пёстри тай каринг э калэ ското, саво сас лэ Лаваноско, ай лэ тэрнэн стхолас ригатар. Кадя лэстэ ашылэ пэсти гуртуря, тай вов ритярэлас лэн ригатар лэ Лаваностерэ бакрэндар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Кала авэнас тэ пэн зоралэ бакря тай бузня, о Яково шолас англа лэндэ андэ балая э рувля, кай вонэ тэ терэн бакрорэн англа э рувля. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ай кала авэнас э бакря найзоралэ, вов на шолас э рувля. Кадя ковло ското доросэласпэ лэ Лаваности, ай зорало лэ Яковости. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Кадя о Яково ашыля барвало, лэстэ сас акана бут цыкно тай баро ското, бутярнэ тай бутярня, вэрблюдоря тай ослуря. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","О Яково ашундя, сар э шавэ лэ Лаваностерэ дэнас дума: «О Яково заля ся, со сас кай амаро дад, стидя пэсти барвалимос катар амаро дад». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","О Яково ля сама, со о Лавано най кацаво каринг лэстэ, сар сас данглал. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","О РАЙ пхэндя лэ Яковости: — Рисав палпалэ пэ тхан, кай аракхадилян, каринг теро родо. Мэ авава туса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","О Яково бишалдя тэ пхэнэн ла Рахиляти тай Лияти, собы вонэ тэ авэн пэ мал, кай сас лэстерэ бакрэ и бузнэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Вов пхэндя лэнди: — Мэ дикхав, со тумаро дад най кацаво каринг мандэ, сар сас данглал. Ай о Дэл мэрнэ дадэско исы манца. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Тумэ ганэн, сар мэ теравас бути важ тумаро дад анда ся мэрно зор, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","ай тумаро дад хохадя ман, дэшвар парувэлас мэрно потинимос. Ай о Дэл на дя лэсти тэ терэл манди вырыто. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Сар кай вов пхэнэнас: «Теро потинимос авэна о крапчято ското», то ся о ското анэнас крапчятонэн, ай сар кай вов пхэнэнас: «Теро потинимос авэна о пёстро ското», то ся о ското анэнас пёстронэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Акадя о Дэл заля о ското кай тумаро дад тай отдя лэс манди. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Екхвар, андэ кодыя время, кала о ското ушаравэл екх екхэс, мэ дикхлэм суно: мэ вазглэм э якха тай додикхлэм, со э бузнэ, савэ ушаравэн лэ бузнян, саслэ пёстри, крапчяти тай пятнисти. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","О янголо лэ Дэвлэско пхэндя манди андо суно: «Яково». Мэ пхэндэм: «Мэ катэ». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Вов пхэндя: «Лэ сама тай дикхэса: саворэ бузнэ, савэ ушарадэ лэ бузнян, — пёстри, крапчяти тай пятнисти. Мэ дикхлэм ся, со терэл о Лавано туса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Мэ сым о Дэл, Саво сыкадиля тути андо Вефилё, кай ту шордян о вулей по бар тай солахаян Манди. Акана ашав майито кадыя пхув тай рисав палпалэ пэ пхув, кай ту аракхадилян». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Э Рахиль тай э Лия пхэндэ: — Исин ли амэндэ инке, саво котор андэ амарэ дадэско хаббэ? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Хэба на дичёл, со вов ангичел амэн, сар най пэстерэн? Вов битиндя амэн тай тратисардя ловэ, савэ ля важ амэндэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Ай сар, ся о барвалимос, саво о Дэл заля амарэ дадэстар, сыно амаро тай амарэ бэятонэнго. Стер кадя, сар пхэнэл тути о Дэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Тунче о Яково бэшля лэ бэятонэн тай лэ ромнян пэ вэрблюдуря, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","ля ся пэско мищимос, саво вов стидя андо Падан-Арамо, дарадя ся пэско ското англа пэстэ тай жылятар кай пэско дад Исаако андэ пхув Ханаано. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Кала о Лавано жыля тэ стрэжый лэ бакрэн, э Рахиль чёрдя лэстерэ черутнэн дэвлэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Ай Яково хохадя лэ арамеёс лэ Лаванос, на пхэндя лэсти, кай вов жалтар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Вов нашлятар ся пэстерэ мищимоса, пэрэжыля э лэн тай жыля каринг э плая лэ Галаадости. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","По трито дес лэ Лаваности пхэндэ, со о Яково нашлятар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Вов ля пэса пэстерэ родонэн, мэкляпэ пала Яково тай по ефтато дес дорэсля лэс катар э Галаадски плая. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Андэ кодыя рят о Дэл авиля андо суно каринг о арамеё Лавано тай пхэндя лэсти: «Фирисавпэ, на пхэн нисо лэ Яковости, ни лашо, ни вырыто». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","О Лавано дорэсля лэ Яковос. О Яково стходя э катуна катар э плая Галаадски, тай о Лавано пэстерэ родоса котэ ж стходэ э катунэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","О Лавано пхэндя лэ Яковости: — Со ту тердян? Ту хохадян ман тай ундярдян мэрнэ щеян, сар копэльницэн па маримос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Состар ту нашлянтар чёрял? Состар ту на пхэндян манди, кай мэ тэ мэкав тут лошаса тай дилянца, пэ бубно тай пэ арфа? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ту на дян манди тэ чюмидав лэ внуконэн тай лэ щеян. Ту тердян бигындоско. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Мандэ исы зор тэ терав тути вырытимос, ай андэ кодыя рят о Дэл терэ дадэско пхэндя манди: «Фирисавпэ, на пхэн нисо лэ Яковости, ни лашо, ни вырыто». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ту жылянтар, пала кода со тути фартэ камэласпэ тэ рисайвэс терэ дадэстэ черэ. Ай состар ту чёрдян мэрнэ дэвлэн? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","О Яково пхэндя лэ Лаваности: — Мэ дарайлэм, пала кода гындосарэлас, со ту зорэса одлэса мандар терэ щеян. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Сар кай ту аракхэса варикастэ котэ терэ дэвлэн, кодыва на жувэла. Англа терэ родуря родэ екжэно, исы варисо мандэ теро, тай сар исы, тунче залэ кода палпалэ. О Яково на ганэнас, со э Рахиль чёрдя лэ дэвлэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Тунче о Лавано зажыля андэ лэ Яковости катуна, андэ ла Лияти катуна тай дуен копэльницатерэ катуна, ай нисо на аракхля. Ла Лиятеря катунатар вов зажыля кай э Рахиль андэ катуна. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Ай э Рахиль англа кода ля лэ черутнэ дэвлэн, стходя лэн андэ лэ вэрблюдонэнди зэн тай бэшля пэр лэндэ. О Лавано обродя ся катуна, ай нисо на аракхля. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Э Рахиль пхэндя пэсти дадэсти: — На холяв, мэрно рай, манди нащи тэ ущяв англа тутэ, мандэ кодя, со терэлпэ лэ жувлянца. Кай вов кати на родя, вов нащи аракхэлас лэ черутнэн дэвлэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","О Яково сас фартэ холяко и ля тэ пхэнэл лэ Лаваности: — Андэ со мэрни дош? — пушля вов. — Саво бэзэх мэ тердэм, кай ту мэклянпэ пала мандэ тэ астарэс ман? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ту обродян ся мэрно мищимос — со ту аракхлян пэско? Стхов, со аракхлян, англа теро тай мэрно родо, и мэк вонэ амэн сындосарэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Дуйдэша бэрша мэ жудэм тутэ: терэ бакря тай бузня на шонас пэстар, мэ на халэм бакрэн анда теро гурто. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Мэ на анавас тутэ лэ бакрэн, савэн шынэнас о дыко зверо, мэ екжэно шавас палпалэ пала лэндэ анда мэрно гурто. Ту мангэсас мандар потинимо пала ся дош, со сас чёрдо, десэ ли када терэласпэ, чи рятяса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Акадя мэ жувавас: десэ пхабарэлас ман о кхам, ай рятэ пагосарэлас ман о шудримос, тай о совимос нашэлятар мэрнэ якхэндар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Кацавэ сас кодыла дуйдэша бэрша, сар мэ жувавас тутэ андо чер. Мэ теравас бути тути дэшуштар бэрша пала терэ дуй щея тай шов бэрша пала ското, ай ту дэшвар парувэсас мэрно потинимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Сар бы на авэлас манца мэрнэ дадэско Дэл, о Дэл лэ Авраамоско, Кодыва, Кастар даралас о Исаако, тунче ту отбишалдя б ман палпалэ шушэ вастэнца. Ай о Дэл дикхля мэрни бида тай э пхари бути мэрнэ вастэнди и сыкадя тути рятэ тери дош. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","О Лавано пхэндя лэ Яковости: — Кала щея исы мэрнэ щея, э бэяцэ исы мэрнэ бэяцэ, тай э гуртуря исы мэрнэ гуртуря. Ся, со ту дикхэс, ся мэрно. Со жэ мэ акана тэ терав мэрнэ щеянца тай лэ бэятонэнца, савэн вонэ аракхадэ? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Терам туса допхэндимос, ту и мэ, тай мэк вов авэла машкара амэндэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","О Яково ля о бар тай стходя лэс ворта. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Вов пхэндя пэстерэ родости: — Стидэн бара. Вонэ стидэ э бара, стходэ лэн плаёрэса тай бэшлэ паша латэ тэ хан. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","О Лавано дя алав лэ плаёрэсти Егар-Сахадута, ай о Яково — Гал-Эд. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","О Лавано пхэндя: — Мэк кадыва плаёро дикхэл тай ашунэл, со амэ катэ солахас екх екхэсти. Акэ пала со лэсти динэ алав Гал-Эд. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Лэсти инке динэ алав Мицпа, ке вов пхэндя: — Мэк о РАЙ дикхэл пала тутэ тай пала мандэ, кала амэ аваса дур екх екхэстар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Сар кай ту лэса вырыто пэс тэ андярэс мэрнэ щеянца тай лэса тути аврэ ромнян, тай сар кай амэнца никас на авэла, на бистри, со на мануш, ай о Дэл дикхэл тай ашунэл тут тай ман. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Инке о Лавано пхэндя лэ Яковости: — Акэ о плаёро анда бара, ай о баруно столбо, саво мэ стходэм ворта машкара тутэ тай мандэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Кала бара тай кадыва столбо дикхэн, со мэ солахав, со мэ на пэрэжава пала кадыва барэнго плаёро пэ тери риг, соп тэ терав тути чёрымос, тай ту на пэрэжаса пала лэндэ пэ мэрни риг, соп тэ терэс манди чёрымос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Мэк о Дэл лэ Авраамоско тай о Дэл лэ Нахороско, лэндерэ дадэско Дэл, тэ авэл сындомари машкара амэндэ. Ай о Яково солахая Колэса, Кастар даралас лэско дад о Исаако. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Вов андя жэртва котэ андэ плаендери пхув тай акхардя пэстерэ родонэн тэ хан. Вонэ халэ тай рятярэн котэ, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","ай тэсара о Лавано чюмидя пестерэ внуконэн тай лэ щеян, бахталисардя лэн тай рисайля черэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","О Яково жалас пэстерэ дромэса, тай лэ Дэвлэсти янголуря вижылэ англа лэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Кала о Яково додикхля лэн, вов пхэндя: — Када лэ Дэвлэско таборо! — тай дя алав кодылэ тханэсти Маханаимо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","О Яково бишалдя англа пэстэ манушэн каринг пэско пхрал кай о Исаво андэ пхув Сеиро, андо тхан Эдом. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Вов лэнди кадя припхэндя: — Пхэнэн кадя мэрнэ раести лэ Исавости: «Теро копэли о Яково пхэнэл: Мэ жувавас кай о Лавано тай сымас катэ жы кадылэ десэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Мандэ исы гурува, ослуря, бакрэ тай бузня, бутярнэ тай бутярня. Мэ бишалав кадыя дума мэрнэ раести, соп тэ аракхав тынгимос англа терэ якха». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Кодыла бишалдэ мануша рисайлэ палпалэ и пхэндэ лэ Яковости: — Амэ самас кай теро пхрал, кай о Исаво, тай акана вов екжэно авэл каринг тутэ, тай лэса жан штаршэла манушэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Андэ бари дар тай пхарэ одеса о Яково розтхадя пэстерэн манушэн, савэ сас лэса, пэ дуй таборуря, тай кадя жэ э гуртуря, о баро ското тай о цыкно ското, и лэ вэрблюдонэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Вов гындосарэлас: «Сар кай о Исаво помарэла екх таборо, тунче авэр ашэнапэ жундэ тай фиринапэ». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","О Яково ля тэ мангэлпэ: — О, Дэл мэрнэ дадэско лэ Авраамоско, Дэл мэрнэ дадэско лэ Исаакоско, о РАЙ, Саво пхэндя манди: «Рисав палпалэ пэ пхув, кай аракхадилян, каринг терэ родуря, тай Мэ дава тути мищимос». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Мэ на ашав кодыва тынгимос тай о чячимос, савэ Ту сыкадян Терэ копэлести. Мандэ нисо на сас, екх о дэсто, кала мэ пэрэжылэм о Иордано, ай акана мэ рисайвав палпалэ дуе таборурэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Мангав Тут, фирисар ман мэрнэ пхралэстерэ вастэндар лэ Исавостар, пала кода со мэ дарав, вов авэла тай помарэла ман и лэ бэятонэн лэ дэянца. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ке Ту пхэндян: «Мэ чячес дава тути мищимос тай терава терэ бэятонэн кадя бут, сар о чишай паша баро паи, саво нащи тэ пэрэадинос». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","О Яково прондярдя котэ ся рят. Колэстар, со сас лэстэ, вов витидя подарко пэстерэ пхралэсти лэ Исавости: ");
INSERT INTO rmyvlakh_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","дуйшэла бузнян тай дуйдэша бузнэн, дуйшэла бакрян тай дуйдэша бакрэн, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","триндэша вэрблюдицэ лэ вэрблюжонконэнца, саранда гурунян тай дэшэн гурувэн, дуйдэша ослицэн тай дэшэ ослонэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Вов тходя пэ кажно гурто пэ екх копэли тай пхэндя лэнди: — Жан англа мандэ тай ритярэн машкара э гуртуря варисави-то дуримос екх екхэстар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Вов сытярдя кодылэ манушэс, саво жалас англал: — Кала мэрно пхрал о Исаво поджала тутэ тай пушэла: «Каско сан? Каринг жас? Каско ското даравэс?» — ");
INSERT INTO rmyvlakh_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","тунче ту пхэн: «О ското терэ копэлеско лэ Яковоско. Када подарко лэстар мэрнэ раести лэ Исавости, ай екжэно вов жал пала амэндэ». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Вов сытярдя и лэ дуйтонэс, и лэ тритонэс, и саворэн аврэн, савэ жанас пала гурто: — Тай тумэ кадя жэ пхэнэн лэ Исавости, кала вов тумэнца дикхэлапэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Ай инке пхэнэн: «Теро копэли о Яково жал пала амэндэ». Пала кода со вов гындосарэлас: «Мэ ковлярава лэско ди кадылэ даронэнца, савэ бишалав англа мандэ. Ай тунче, кала амэ дикхасапэ, вов авэла лашо каринг мандэ». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Кадя лэ Яковости даруря сас бишалдэ англэ, ай вов рятярдя андо таборо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Кодыя рят о Яково ущиля тай ля пэстерэ дуен ромнян, дуен копэльницэн тай дэшуекхэ шавэн тай андо бродо пэрэжыля э лэн Ябоко. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Вов пэрэндярдя лэн тай ся пэско мищимос пэ авэр риг ла лэнако. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Тунче о Яково ашыляпэ екхжэно, тай Варико бирояспэ лэса жы каринг э тэсара. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Кала Кодыва дикхля, со нащи бирой, Вов ляпэ каринг ла кущикако кокало лэ Яковоко, кадя кай о кокало изля па тхан. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Вов пхэндя: — Мэк Ман, ваздэлпэ э тэсара. Ай о Яково пхэндя: — На мэкава, покэ на бахталисарэса ман. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Вов пушля: — Сар акхарэн тут? — Яково, — пхэндя вов. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Тунче Вов пхэндя: — Кадылэ десэстар тут на лэна тэ акхарэн Яково, ай Израилё, пала кода со ту биросайлян лэ Дэвлэса тай лэ манушэнца и биросардян. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","О Яково пхэндя: — Мангав Тут, пхэн манди Теро алав. Ай Вов пхэндя: — Состар ту пушэс Мэрно алав? Тай Вов бахталисардя лэс котэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","О Яково дя алав кодылэ тханэсти Пениэло. Вов пхэндя: «Мэ дикхлэм лэ Дэвлэс муй муестэ тай ашылэмпэ жундо». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","О кхам вазгляпэ понадэ лэстэ, кала вов прожалас о Пениэло. Вов лангалас пэ пэско пэрно. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Акэ пала со жы кадылэ десэстэ э израильтянуря на хан э жыла андо пулпа: ке Дэл ляпэ кай жыла андо пулпа лэ Яковости. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","О Яково вазгля э якха и дикхля, со жал о Исаво тай лэса штаршэла манушэн. Вов ростходя лэ бэятонэн машкара э Лия, э Рахиль тай дуен копэльницэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Вов стходя лэ копэльницэн тай лэндерэ бэятонэн англал, лэ Лия тай латерэ бэятонэн пала лэндэ, ай ла Рахиля лэ Иосифоса палал саворэндар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ай вов екжэно жыля англэ. Вов поджал каринг пэско пхрал тай тэлиля лэсти жы каринг э пхув ефтавар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ай о Исаво прастая каринг о Яково, обля лэс, шутяпэ лэсти каринг э кор тай росчюмидя лэс, тай вонэ лэдуй заровлэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","О Исаво додикхля лэ жувлян тай лэ бэятонэн тай пушэл: — Ко када туса? О Яково пхэндя: — Када э бэяцэ, савэн о Дэл па Пэско тынгимос дя терэ копэлести. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Поджылэ э копэльницэ пэстерэ бэятонэнца тай тэлён англа Исав. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Пала лэндэ поджылэ тай тэлилэ э Лия тай латерэ бэяцэ. Пала саворэндэ поджылэ о Иосифо тай э Рахиль, и вонэ тэлилэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","О Исаво пушля лэ Яковостар: — Состар ту бишалдян саворэ кадыла гуртуря каринг мандэ? — Мэ камав тэ аракхав лашымос англа терэ якха, мэрно рай, — пхэндя о Яково. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","О Исаво пхэндя: — Мандэ ся исы, пхрала. Ашав теро тути. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","— Най, мангав тут! — пхэндя о Яково. — Сар кай мэ аракхлэм лашымос англа терэ якха, тунче прилэ мандар кадыва даро. Важ мандэ тэ дикхав теро муй — када сар тэ дикхав о муй лэ Дэвлэско, ке ту прилян ман лашымаса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Мангав тут, прилэ мандар кадва бахталимос, пала кода кай о Дэл сас тынгомэ мандэ, тай мандэ исы ся, со манди трэбуй. Яково фартэ мангэлас Исавос тэ прилэл кадыла даруря, тай вов ля лэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Тунче о Исаво пхэндя: — Авэн, трэбуй тэ жас андо дром. Мэ лава тэ ритярдював паша тутэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Ай о Яково пхэндя лэсти: — Мэрно рай ганэл, со кай э бэяцэ найбут зор. Тай манди трэбуй тэ гындосарэл пала э бакря тай гуруня, савэ дэн о тхут. Сар кай тэ даравас лэн йито андэ екх дес, тунче о ското похасайвэла. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Мэк мэрно рай жал англа пэско копэли, ай мэ жава полокорэ, кадя сар жана англа мандэ э гуртуря тай сар жана э бэяцэ, жыпокэ авава каринг мэрно рай андо Сеиро. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","О Исаво пхэндя: — Дэ мэ дава тути варисавэ мэрнэ манушэн. — Состар тэ терэс када? — пушля о Яково. — Хутила и кода, кай мэ аракхлэм лашымос англа мэрнэ раестерэ якха. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Андэ кодва жэ дес о Исаво рисайля палпалэ каринг пэстэ андо Сеиро. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","О Яково жэ жыля андо Сукото, кай вов стходя пэстерэ катунэ тай стерэл катунэ важ о ското. Акэ пала со кодыва тхан акхарэлпэ Сукото. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Анда Падан-Арамо о Яково миштэс авилятар андо форо Шэхемо анда Ханаано тай стходя таборо паша форо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Пала шэл рупунэ ястря вов тиндя кай э шавэ лэ Хаморостерэ, саво сас лэ Шэхемоско дад, котор пхув, пэ саво вов стходя пэстери катуна. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Котэ вов стердя жэртвенико тай дя лэсти алав «Эл-Элохей-Йисраэл». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Э Дина, ла Лиятери щей лэ Яковостар, жыля тэ подикхэл щеян кодылэ тханэстар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Кала о Шэхемо, о шаво лэ Хаморско хивеёско, саво сас раеса пэ кодыя пхув, додикхля ла Дина, вов астардя ла тай асаяпэ латар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Лэско ди пряшыля каринг э Дина, кай э щей лэ Яковости, вов покамля ла тай дэлас дума ласа лашымаса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Тунче о Шэхемо пхэндя пэстерэ дадэсти лэ Хаморости: — Лэ манди кадыла щя пала мандэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Кала о Яково ашундя, со лэстеря щятар ла Динатар асаяпэ, лэстере шавэ саслэ андэ мал лэ гуртонэнца, тай вов ашэлас мулком пала када, жыпокэ вонэ на рисайлэ черэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Лэ Шэхемоско дад о Хаморо авиля тэ дэл дума лэ Яковоса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Кала э шавэ лэ Яковости ашундэ, со тердяпэ, вонэ рисайлэ пай маля. Вонэ саслэ фартэ холяти, пала кода со о Шэхемо тердя лажаво андо Израилё, кала асаяпэ лэ Яковостеря щятар, ай када нащи сас тэ терэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","О Хаморо пхэндя лэнди: — Мэрно шаво о Шэхемо саворэ одеса цырдэлпэ каринг тумари щей. Мангав тумэн, отдэн ла пала лэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Терэн амэнца ябъява: отдэн амэнди тумарэ щеян, тай отдаса пала тумэндэ амарэ щеян. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Тумэ жувэн машкара амэндэ. Амари пхув англа тумэндэ: жувэн пэр латэ, пхирэн пай латэ, каринг камэн, лэн пэсти андо хулаимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","О Шэхемо пхэндя ла Динатерэ дадэсти тай латерэ пхралэнди: — Мэ дава тумэнди ся, со тумэ пхэнэна, дэн мэ тэ аракхав лашымос англа тумарэ якха! ");
INSERT INTO rmyvlakh_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Мангэн важ э тэрни цэмин, сави бэ тэ на авэл бари, тай подаркуря — мэ потинава, кати отдэн ла пала мандэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Тунче э шавэ лэ Яковости пхэндэ лэ Шэхемости тай лэстерэ дадэсти лэ Хаморости хохаимаса, пала када со вов асаяпэ лэндеря пхьятар ла Динатар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Вонэ пхэндэ лэнди: — Амэнди нащи тэ терас кацаво. Тэ отдас амаря пхья найопшындэ муршэсти авэла важ амэндэ лажаво. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Амэ отдаса ла тумэнди кати пала кода, сар тумэ ашэна, сар амэ, тай терэна саворэ муршэнди опшындимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Тунче амэ ласа тэ отдас тумэнди амарэ щеян тай тэ лас пала амэндэ тумарэн. Амэ ласа тэ жувас машкара тумэндэ тай ашаса тумэнца екхэ народоса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ай сар на камэна тэ авэн опшынэндэ, амэ заласа амаря пхья тай жасатар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Лэндери дума пэля андо ди лэ Хаморости тай лэстерэ шавэсти лэ Шэхемости. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Кадыва тэрно мануш йито стердя кода, со вонэ пхэндэ, пала кода со вов фартэ покамля лэ Яковостеря щя. Вов, о Шэхемо, сас майпативало анда пэстерэ дадэско чер. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Тунче о Хаморо тай лэско шаво о Шэхемо авилэ каринг э вудара лэ форости тай дэнас дума лэ манушэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","— Кала мануша лашымаса каринг амэндэ, — пхэндэ вонэ. — Мэк жувэн пэ амари пхув тай пхирэн пай латэ, каринг камэн: пэ кадыя пхув бут тхан важ лэндэ. Амэ ласа пала амэндэ лэндерэ щеян, ай вонэ лэна пала пэстэ амарэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Кати кадя камэн кала мануша тэ жувэн амэнца, сар екх народо: сар кай амарэ мурша авэна опшындэ, сар и вонэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","На ашэна ли тунче лэндерэ гуртуря, лэнго мищимос тай ся лэнго ското амаро? Стерам жэ кода, со вонэ камэн, тай вонэ жувэна машкара амэндэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Саворэ, ко сас катар лэ форости вудара, допхэндэпэ лэ Хамороса тай лэстерэ шавэса лэ Шэхемоса, и саворэ мурша андо форо саслэ опшындэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Пай трин деса, кала вонэ инке сас дукхадэ лэ насвалимастар, лэ Яковости дуй шавэ, о Симеоно тай о Левиё, э пхрала ла Динати, линэ э шуря, чярял динэ по форо тай умардэ саворэн муршэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Вонэ умардэ ла шуряса лэ Хаморос тай лэстерэ шавэс лэ Шэхемос, залинэ ла Дина анда чер лэ Шэхемоско и жылэтар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Тунче э шавэ лэ Яковости зажылэ андэ лэ мулэндерэ чера тай опчёрэн о форо, кай лэнди пхэй сасли андо лажаво. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Вонэ залинэ лэ бакрэн, лэ бузнэн, лэ гурумнян тай лэ ослонэн. Ся, со сас андо форо тай андэ маля, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","тай ся лэнго барвалимос, тай лэ бэятонэн, тай лэ жувлян, тай ся, со сас андэ чера, вонэ залинэ пэсти андо хулаимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Тунче о Яково пхэндя лэ Симеоности тай лэ Левиёсти: — Тумэ тердэ пэр мандэ бари бида, тердэ тэ вырыцын ман э мануша пэ кадыя пхув, э ханаанея тай э перизея. Амэн сам найбут, тай сар кай вонэ стидэнапэ екхтанэ тай дэна пэр мандэ, мэ и мэрно ери аваса умардэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ай вонэ пхэндэ: — Хэба трэбуй сас кадя тэ терэл амаря пхьяса, сар лубняса? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","О Дэл пхэндя лэ Яковости: — Жа андо Вефилё, жув котэ тай стер котэ жэртвенико лэ Дэвлэсти, Саво сыкадилясас тути, кала ту нашлянастар терэ пхралэстэр лэ Исавостар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Тунче о Яково пхэндя лэ ерести тай саворэнди, ко сас лэса: — Вишон тумэндар найчяче дэвлэн, савэ исы тумэндэ пэса, вужардёнпэ тай парувэн пэр пэстэ э йида. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Тунче стидэнпэ андо дром, тай амэ жасатар андо Вефилё, котэ мэ стерава жэртвенико лэ Дэвлэсти, Саво дя манди зор андэ кодыва дес, кала манди сас вырыто, тай сас манца, каринг бэ мэ тэ на жав. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Тунче вонэ отдинэ лэ Яковости сарэ дэвэлэн, савэ сас лэндэ, тай э чея андай кана, ай о Яково заганадя лэн паша тэрэбинто кашт андо Шэхемо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Котар вонэ жылэтар андо дром, тай э дар лэ Дэвлэсти сас пэ саворэ форуря, кадя со нико на нашэлас пала лэ Яковостерэ бэяцэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","О Яково тай саворэ, ко сас лэса, авилэ андо Лузо (кода жэ исы Вефилё) пэ пхув Ханаано. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Котэ вов стердя жэртвенико тай дя алав кодылэ тханэсти Эл-Бет-Эл, пала кода со котэ о Дэл сыкадиляпэ лэсти, кала вов нашэластар пэстерэ пхралэстар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Э Девора, сави виправардя ла Ревэка, муля тай сасли прахосарди паша дубо найдур лэ Вефилёстар. Пала кода лэсти динэ алав Аллон-Бахут. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Кала о Яково рисайля анда Падан-Арамо, о Дэл инке екхвар сыкадиляпэ лэсти тай бахталисардя лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","О Дэл пхэндя лэсти: — Теро алав Яково, ай адесунэ десэсар тут на лэна тэ акхарэн Яково. Теро алав авэла Израилё. Кадя о Дэл дя лэсти алав Израилё. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Вов пхэндя лэсти: — Мэ сым — о Дэл Саворэзорэско. Анэн бэятонэн тай авэн майбут. Народо, бут народуря тай тхагара авэна тутар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Э пхув, сави Мэ дэм лэ Авраамости тай лэ Исаакости, Мэ отдава ла тути тай терэ бэятонэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Тунче о Дэл вазгляпэ лэстар котар, кай Вов дэлас дума лэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","О Яково стходя ворта баруно столбо пэ кодыва тхан, кай о Дэл дэлас дума лэса, тай шордя пэр лэстэ о чехыри тай о оливково вулей. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","О Яково дя алав кодылэ тханэсти, кай о Дэл дэлас дума лэса, Вефилё. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Вонэ ашадэ о Вефилё тай саслэ найдур лэ Эфратастар, кала кай э Рахиль ля тэ аракхадёл шаворо, тай сас лати фартэ пхарэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Вой фартэ пхарэс анэлас лэ бэятос, тай э жувли, сави дэлас лати зор, пхэндя лати: — На дара — тутэ авэла инке екх шаво. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Кала э Рахиль мэрэлас тай лако духо жаластар, вой дя алав лэ шавэсти Бен-Они, ай о дад дя лэсти алав Вениамино. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Э Рахиль муля тай сасли прахомэ па дром андо Эфрата (када исы Вифлеемо). ");
INSERT INTO rmyvlakh_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Пэ кодыва тхан о Яково стходя тэ тэрдёл о баруно столбо, ай жы калэ десэстэ кодыва бар сыкавэл, кай вой сас прахомэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","О Израилё жыля майдур тай стхол э катуна пала Мигдал-Эдеро. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Кала о Израилё жувэлас пэ кодыя пхув, о Рувимо сутя ластерэ дадэстеря копэльницаса-ромняса ла Валаса. О Израилё угангля пала када. Кай о Яково сас дэшудуй шавэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Ла Лиятар: о Рувимо, англуно лэ Яковоско шаво, о Симеоно, о Левиё, о Иуда, о Исахаро тай о Завулоно. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Ла Рахилятар: о Иосифо тай о Вениамино. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Ла Рахилятеря бутярнятар ла Валатар: о Дано тай о Нефалимо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Ла Лиятеря бутярнятар ла Зелфатар: о Гадо тай о Асиро. Када сас э шавэ, савэ аракхадилэпэ кай о Яково андо Падан-Арамо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","О Яково авилятар каринг пэско дад кай о Исаако андэ Мамрэ, кай исы паша Кирьят-Арба (кода исы Хевроно), кай жувэнас о Авраамо тай о Исаако. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","О Исаако жудя шэл охтодэша бэрша. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","О Исаако ашадя о духо, муля и отжыля каринг пестерэ мулэ папуря, пхуро тай чяло жувимастар. Лэстерэ шавэ о Исаво тай о Яково прахосардэ лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Акэ э дума пала Исаво (вов жэ сыно Эдомо) тай пала лэстерэ потомкуря. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","О Исаво ля пэсти ромнян анда Ханаано: лэ хетеёстеря лэ Элоностеря щя ла Ада, тай ла Оголивама, лэ Анастеря щя тай ла внучка лэ хивеёстеря лэ Цывеоностеря, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ай кадя жэ лэ Измаилостеря щя ла Басемата, сави сас пхэй лэ Невайотости. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Э Ада андя лэ Исавости лэ Элифазос, э Басемат андя лэ Рэуэлос, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","э Оголивама андя лэ Еушос, лэ Яламос тай лэ Корахос. Када шавэ лэ Исавости, савэ аракхадилэ лэстэ андо Ханаано. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","О Исаво ля пэстерэ ромнян, лэ шавэн, лэ щеян тай саворэн черутнэн, заля гуртуря, о ското тай ся пэско хаббэ, саво вов стидя андо Ханаано, тай жылятар пэ авэр пхув пэстерэ пхралэстар лэ Яковостар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Лэндэ сас фартэ бут хулаимос, ке вонэ нащи жувэнас екхтанэ. Лэндэ сас бут ското, кадя со э пхув, кай вонэ жувэнас, нащи проправарэлас лэ дуе пхралэндерэ гуртуря. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Кадя о Исаво (вов жэ Эдомо) ля тэ жувэл катар э плая пэ пхув Сеиро. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Акэ э дума пала Исаво, саво сас дад лэ эдомеенго тай жувэлас катар э плая пэ пхув Сеиро, тай пала лэстерэ потомкуря. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Акэ лэ Исавостерэ шавэнди алава: о Элифазо, шаво лэ Исавоско ла Адатар, о Рэуэло, шаво лэ Исавоско ла Басемататар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Э шавэ лэ Элифазостерэ: о Темано, о Омаро, о Цэфо, Гатамо тай о Кеназо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Кай лэ Исавоско шаво кай о Элифазо сас копэльница-ромни, савя акхарэнас Тимна, сави андя лэсти лэ Амалекос. Када сас лэ Исавостерэ внукуря лэстеря ромнятар ла Адатар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Лэ Рэуэлостерэ шавэ: о Нахато, о Зерахо, о Шама тай о Миза. Када сас лэ Исавостерэ внукуря лэстеря ромнятар ла Басемататар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Акэ лэ Исавости шавэ ла Оголиваматар, щей лэ Анастери тай внучка лэ Цывеоности, савэн вой андя лэ Исавости: о Еушо, о Яламо тай Корахо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Акэ барэдэра машкара лэ Исавостерэ потомкуря. Акэ э шавэ лэ Элифазостерэ, лэ Исавостерэ англунэ шавэско: о барэдэр о Темано, о барэдэр о Омаро, о барэдэр о Цэфо, о барэдэр о Кеназо, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","о барэдэр о Корахо, о барэдэр о Гатамо тай о барэдэр о Амалеко. Кадыла сас барэдэра, савэ аракхадилэ кай о Элифазо андо Эдомо, вонэ сас ла Адатерэ внукуря. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Акэ э шавэ лэ Рэуэлостерэ, лэ Исавостерэ шавэсти: о барэдэр о Нахато, о барэдэр о Зерахо, о барэдэр о Шама, тай о Миза. Кадыла сас барэдэра, савэ аракхадилэ кай о Рэуэло андо Эдомо, вонэ сас внукуря лэ Исавостеря ромняти ла Басематати. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Акэ лэ Исавости шавэ ла Оголиваматар: о барэдэр о Еушо, о барэдэр о Яламо тай о барэдэр о Корахо. Када э барэдэра, савэ аракхадилэ лэ Исавостеря ромнятар ла Оголиваматар, лэ Анастеря щятар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Кадыла сас шавэ лэ Исавостерэ (вов жэ Эдомо) тай лэндерэ барэдэра. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Акэ лэ Сеиростерэ лэ хореёстерэ шавэ, савэ жувэнас пэ кодыя пхув: о Лотано, о Шовало, о Цывеоно, о Ана, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","о Дишоно, о Эцэро тай о Дишано. Кадыла лэ Сеиростерэ шавэ андо Эдомо сас барэдэра лэ хореендерэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Лэ Лотаностерэ шавэ: о Хориё тай о Хемамо. Э Тимна сас лэ Лотаности пхэй. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Лэ Шовалостерэ шавэ: о Алвано, о Манахато, о Эвало, о Шэфо тай о Онамо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Лэ Цывеоностерэ шавэ: о Айя тай о Ана. Када кодыва Ана, саво аракхля андэ шуки пхув о пхабардо паи, кала праварэлас пэ мал пэстерэ дадэсти лэ Цывеоностерэ ослонэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Лэ Анастерэ бэяцэ: о Дишоно тай э Оголивама, лэ Анастери щей. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Лэ Дишаностерэ шавэ: о Хемдано, о Эшбано, о Йитрано тай о Керано. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Лэ Эцэростерэ шавэ: о Билхано, о Завано тай о Акано. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Лэ Дишаностерэ шавэ: о Уцо тай о Арано. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Акэ э барэдэра лэ хореенди: о барэдэр о Лотано, о барэдэр о Шовало, о барэдэр о Цывеоно, о барэдэр о Ана, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","о барэдэр о Дишоно, о барэдэр о Эцэро тай о барэдэр о Дишано. Вонэ сас барэдэра кай хорея пай породэ лэндэ пэ Сеирско пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Акэ э тхагара, савэ сас андо Эдомо, инке жы колэстэ, сар андо Израилё ашылэ э тхагара. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","О Бела, лэ Беороско шаво, сас тхагарэса андо Эдомо. Лэско форо акхарэласпэ Динхава. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Кала о Бела муля, тхагарэса ашыля о Ёваво, лэ Зерахоско шаво анда Боцра. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Кала о Ёваво муля, тхагарэса ашыля о Хушамо анда пхув лэ теманея. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Кала о Хушамо муля, тхагарэса ашыля о Хададо, шаво лэ Бедадоско, саво помардя лэ мидьянонэн пэ Моавско пхув. Лэско форо акхарэласпэ Авито. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Кала о Хададо муля, тхагарэса ашыля о Самла анда Масрэка. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Кала о Самла муля, тхагарэса ашыля о Сауло анда Реховото, кай сас катар э лэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Кала о Сауло муля, тхагарэса ашыля о Баал-Ханано, лэ Ахбороско шаво. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Кала о Баал-Ханано, лэ Ахбороско шаво, муля, тхагарэса ашыля о Хадаро. Лэско форо акхарэласпэ Пау, ай лэстеря ромня акхарэнас Мехетавель, вой сас щея лэ Матредастери, ай внучка лэ Ме-Захавостеря. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Акэ сар акхарэнас лэ барэдэрэн, лэ Исавостерэ бэятонэндар, па лэндерэ алава, породэ тай пхуя: о барэдэр о Тимна, о барэдэр о Алва, о барэдэр о Етето, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","о барэдэр о Оголивама, о барэдэр о Эла, о барэдэр о Пиноно, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","о барэдэр о Кеназо, о барэдэр о Темано, о барэдэр о Мивцаро, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","о барэдэр о Магдиэло тай о барэдэр о Ирамо. Када сас э барэдэра андо Эдомо па лэндерэ гава пэ пхув, сави вонэ линэ пэсти. Када сас о Исаво — о дад лэ эдомеенго. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","О Яково жувэлас пэ пхув Ханаано, пэ кодыя пхув, кай жувэлас лэско дад. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Акэ э дума пала Яково тай лэстерэ потомкуря. О Иосифо, савэсти сас дэшуефта бэрша, праварэлас лэ бакрэн пэ мал екхтанэ пэстерэ пхралэнца, лэ Яковостерэ шавэнца ла Валатар тай ла Зелфатар, э жувля, савэ сас лэ Иосифостерэ дадэсти ромня. О Иосифо роспхэнэлас пэсти дадэсти о вырытимос пэстерэ пхралэнго. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","О Израилё жэ камэлас лэ Иосифос майбут саворэ шавэндар, пала кода ке вов аракхадиля лэстэ по пхуримос. О Израилё стердя важ лэстэ барвалэ шукарнэ гада. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Кала лэ Иосифостерэ пхрала удикхле, кай лэнго дад камэл лэс майбут, сар аврэн, вонэ линэ тэ вырыцын лэс и лэндэ на вижанас тэ дэн дума лэса мишто. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Екхвар о Иосифо дикхля суно. Вов роспхэндя пала лэстэ пэстерэ пхралэнди, и вонэ завырыцысардэнас лэс инке майбут. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Акэ со вов пхэндя лэнди: — Ашунэн, саво манди снисайляпэ суно. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Амэ пхандасас э снопуря пэ мал, тай екхвар мэрно снопо вазгляпэ тай вортойпэ, ай тумарэ снопуря тэрдилэ саворэ ригэндар лэстар тай тэлиле лэсти. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Э пхрала пхэндэ лэсти: — Со, ту авэса тхагар пар амэндэ? Со, амэ аваса тут тэ кандас? Тай вонэ завырыцысардэ лэс инке майбут пала лэстерэ сунэ тай пала кадыва роспхэнимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Лэ Иосифости снисайля инке екх суно, тай вов упалэ роспхэндя пала лэстэ пэстерэ пхралэнди: — Ашунэн, манди снисайляпэ инке екх суно. Акана манди тэлилэ о кхам, о шон тай дэшуекх чергая. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Вов роспхэндя о суно най кати лэ пхралэнди, ай и лэ дадэсти, тай о дад мустрисардя лэс: — Со када за суно тути снисайля? Со када, мэ, тери дэй тай терэ пхрала чячес аваса тай тэлюваса тути жы каринг э пхув? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Э пхрала ритярэнас холи пэр лэстэ, ай о дад сэрэсарда када. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Э пхрала жылэтар тэ праварэн пэ мал лэ дадэстерэ гуртуря катар о Шэхемо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","О Израилё пхэндя лэ Иосифости: — Ту ганэс, со терэ пхрала праварэн пэ мал э гуртуря паша Шэхемо. Мэ камав тэ бишалав тут лэндэ. — Мишто, — пхэндя о Иосифо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Лэско дад пхэндя лэсти: — Жа дикх, ся сын мишто терэ пхралэнца тай лэ гуртонэнца, тай пхэнэса манди. Вов припхэндя када лэсти паша лэ Хевроноско машкарплаенго тхан, тай о Иосифо жыля андо Шэхемо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Котэ вов родэлас пай маля, жы кала екх мануш дикхляпэ лэса тай пушля лэстар: — Со ту родэс? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Вов пхэндя: — Мэ родав мэрнэ пхралэн. Мангав тут, пхэн манди, кай вонэ праварэн пэстерэ гуртуря? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","— Вонэ жылэтар катар, — пхэндя кодыва мануш. — Мэ ашундэм, сар вонэ дэнас дума: «Авэн андо Дотано». О Иосифо жыля пала пэсти пхрала тай аракхля лэн паша Дотано. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Вонэ додикхлэ лэс дэздурал тай, данглал сар вов поджыля каринг лэндэ, допхэндэпэ тэ умарэн лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","— Акэ авэл кодыва, саво дикхэл э сунэ! — пхэндэ вонэ екх екхэсти. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","— Умарам лэс тай шувидаса андэ шуки хаинг, ай пхэнаса, со лэс похаля вэшэско зверо. Тунче дикхаса, со авэла анда лэсти сунэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","О Рувимо ашундя када тай фирисардя лэс лэндерэ вастэндар. Вов пхэндя: — Най, на трэбуй тэ лас лэско жувимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","На шорэн о рат. Шувидэн лэс андэ кадыя шуки хаинг андэ пустыня, тай на ваздэн тумарэ васта пэр лэстэ. О Рувимо камэлас тэ фирисарэл лэс лэндар тай тэ рисарэл лэс палпалэ кай лэско дад. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Кала о Иосифо поджыля каринг пэстерэ пхрала, вонэ злинэ пар лэстэ э йида — кодыя барвали шукарни йида, кай сас пэр лэстэ, — ");
INSERT INTO rmyvlakh_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","тай шувидэ лэс андэ хаинг. Э хаинг сас шушы, бипаясти. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Вонэ бэшлэ тэ хан тай додикхлэ, сар э измаильтянуря жан анда Галаадо. Пэ вэрблюдуря сас пхаримата спецыяса, бальзамоса тай ладаноса, савэ вонэ андярэнас андо Египто. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","О Иуда пхэндя лэ пхралэнди: — Со амэнди колэстар, сар кай амэ умараса амарэ пхралэс тай гараваса када? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Фэдэр битинам лэс лэ измаильтянонэнди тай на ласа тэ ваздас пэр лэстэ амарэ васта, ке вов амаро пхрал, амаро рат тай амари тила. Э пхрала канглэ лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Кала э мидьянея э тинимаря прожанас пашэ, э пхрала вилинэ лэ Иосифос андай хаинг тай битиндэ лэ измаилеенди палай дуйдэша рупунэ ястря. Измаильтянуря линэ лэс андо Египто. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Кала о Рувимо рисайля, вов дикхля, со лэ Иосифос котэ нинай, тай росшындя пэр пэстэ э йида. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Вов авиля каринг э пхрала и пхэндя: — Лэ шаворэс котэ нинай! Каринг мэ акана тэ жав? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Тунче вонэ линэ лэ Иосифоско гат, шындэ бузнэс тай вымакхлэ о гат лэ ратэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Котар вонэ андярдэ лэ дадэсти о барвало шукарно гад и пхэндэ: — Акэ со амэ аракхлям. Дикх, када най терэ шавэско гат? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Вов галярдя лэс тай зацыпий: — Када о гат мэрнэ шавэско! Лэс халя вэшэско зверо! О Иосифо сас росшындо пэ котора! ");
INSERT INTO rmyvlakh_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","О Яково росшындя пэр пэстэ о гат, ля пэр пэстэ гонэстери йида тай бут деса ровэлас пала шаво. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Саворэ лэсти шавэ тай э щея авилэ тэ улэн лэс, ай вов на шолас сама тай пхэнэлас: — Най, мэ кадя грижатар жаватар пэ лэ мулэнди люма, каринг мэрно шаво. Кадя о дад ровэлас пала пэско шаво. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ай андэ кодыя время э мидьянея андярдэ лэ Иосифос андо Египто тай битиндэ лэс лэ раести лэ Потифарости, саво сас кай о фараоно барэдэр пэ фирисаря. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","О Иуда андэ кодыя время ашадя пэстерэ пхралэн тай жыля тэ жувэл каринг екх адуламеё, савэс акхарэнас Хира. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Котэ о Иуда дикхляпэ щяса ханаанеёстеря, савэс акхарэнас Шуа. О Иуда ля ла пала пэстэ тай ашыля тэ жувэл ласа. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Вой ашыля пхари тай андя шавэс, савэсти дя алав Эро. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Вой упалэ ашыля пхари тай андя шавэс тай дя лэсти алав Онано. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Вой андя инке екхэ шавэс тай дя лэсти алав Шэло. Вов аракхадиляпэ латэ андо Хезиво. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","О Иуда ля лэ Эрости, пэстерэ англунэ шавэсти, ромня, савя акхарэнас Фамарь. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","О Эро, лэ Иудаско англуно шаво, сас вырыто англа лэ РАЕСТИ якха, тай о РАЙ умардя лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Тунче о Иуда пхэндя лэ Онаности: — Ту трэбуй тэ совэс терэ пхралэстеря ромняса, ке сан пхрал латерэ ромэсти: трэбуй тэ стерэс бэятонэн важ теро пхрал. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ай о Онано ганэлас, со э бэяцэ авэна най лэстерэ, тай кала совэлас пэстерэ пхралэстеря ромняса, вов шолас пэ пхув, соп тэ на стерэл бэятонэн важ пэско пхрал. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Кода, со вов терэлас, сас вырыто англа лэ РАЕСТЕРЭ якха, пала кода Вов умардя и лэ Онанос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Тунче о Иуда пхэндя пэстеря боряти ла Фамаряти: — Жув сар пхивли андо чер кай теро дад, жыпокэ на вибарёла мэрно шаво о Шэло. О Иуда гындосарэлас: «Сар бэ тэ на мэрэл и о Шэло, сар лэстерэ пхрала». Э Фамарь жалтар тэ жувэл кай пэско дад. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Пай бут время лэ Иудасти ромни, лэ Шуастери щей, муля. Кала о Иуда уляпэ ла грижатар, вов жыля андэ Тимна каринг э мануша, савэ стрыжынас лэстерэ бакрэн, тай лэско амал о Хира адуламеё жыля лэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Ла Фамаряти пхэндэ: — Теро састро жал андэ Тимна тэ стрыжый пэстерэ бакрэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Тунче вой изля пар пэстэ э пхивликани йида, ушарадя пэско муй, соп тэ на гатярэн ла, тай бэшля паша лэ форости вудара паша Эноимо, о форо па дром каринг э Тимна. Вой дикхэлас, кай о Шэла вибариля, ай ла на отдинэ лэсти ромняса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Кала о Иуда додикхля ла, вов гындосардя, со кода лубни, пала кода со лако муй сас ушардо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Вов бандиля па дром, поджыля латэ тай пхэндя: — Авэн, дэ манди тэ совав туса. Вов на ганэлас, со кода лэсти бори. Вой пхэндя: — Ай со ту дэса манди пала кода, соп тэ совэс манца? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Вов пхэндя: — Мэ бишалава тут бузнорэс анда мэрно гурто. Вой пушля: — Ай ту дэса манди варисо, жы кай на бишалэса лэ бузнорэс? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Вов пхэндя: — Со тэ дав тути? Вой пхэндя: — Тери печять пэ дурюры тай о дэсто, саво тутэ андо васт. Вов дя лати кода, со вой мангэлас, сутя ласа, и Фамарь ашыля пхари лэстар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","О Фамарь ужыля котар, изля пар пэско косно тай упалэ ля пэр пэстэ э пхивликани йида. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Андэ кодыя время о Иуда бишалдя пэстерэ амалэса лэ адуламеёса бузнорэс, соп тэ залэл палпалэ э печять тай о дэсто кодыла жувлятар, ай о амал на аракхля ла. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Вов пушля кай э катутнэ мануша: — Кай сыни кодыя лубни, сави бэшэлас паша дром андо Эноимо? Вонэ пхэндэ: — Катэ на сас нисави лубни. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Вов рисайля каринг о Иуда и пхэндя: — Мэ на аракхлэм ла, ай э мануша колэ тханэстерэ пхэндэ: «Катэ на сас нисави лубни». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","О Иуда пхэндя: — Мэк ашавэл пэсти кода, со ля, ке э мануша асана амэндар. Ке мэ бишалдэмас лати лэ бузнорэс, ай ту ла на аракхлян. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Пай трин шона лэ Иудасти пхэндэ: — Тери бори э Фамарь тердя лажаво тай колэстар ашыля пхари. О Иуда пхэндя: — Мэк виндярэн ла тай спхабарэн! ");
INSERT INTO rmyvlakh_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Кала ла ундярэнас, вой бишалдя каринг о сатро кацавя думаса: — Мэ сым пхари колэ манушэстар, касти сынэ кадыя печять тай о дэсто. Инке вой пхэндя: — Дикх, на гатярэс, касти кадыя печять, э дури тай о дэсто? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","О Иуда гатярдя лэн тай пхэндя: — Вой май чячюни мандар, пала кода со мэ на отдэм ла пала мэрнэ шаво Шэло. О Иуда будэр на совэлас ласа. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Кала авиля Фамаряти время тэ анэн, латэ андо йило сас дуй шаворэ-близнецуря. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Кала вонэ аракхадёнас, екх лэндар вишутя о васт аври. Тунче э жувли, сави лэлас лэ бэятонэн, пхангля пэ кодыва васт лоло тхав и пхэндя: — Кадыва вижыля англуно. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ай вов цырдя о васт палпалэ, тай вижыля лэско пхрал. Тунче вой пхэндя: — Сар ту промардяпэ? Тай дя лэсти алав Парэцо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Пала лэстэ вижыля и кодыва, савэстэ по васт сас лоло тхав. Тай динэ лэсти алав Зарахо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Лэ Иосифос андэ андо Египто, тай о Потифаро египтянино, саво сас рай кай о фараоно тай барэдэр пэ фирисаря, тиндя лэ Иосифос кай измаильтянуря. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","О РАЙ сас лэ Иосифоса, тай лэстэ сас бахт, кала вов жувэлас андо чер кай пэско египтоско рай. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Лэско рай дикхля, со о РАЙ лэ Иосифоса тай дэл лэсти бахт андэ ся, со вов терэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","О Иосифо аракхля лашымос англа лэстерэ якха тай ашыля лэско пашутно бутярно. О Потифаро стходя лэс барэдэрэса пэ пэско чер тай тэ дикхэл пала ся лэско хулаимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Тай кодыла времятар, сар вов стходя лэ Иосифос барэдэрэса пэ пэско чер тай пэ ся пэско хулаимос, о РАЙ дя бахталимос лэ черэсти египтяниноско пала Иосифо. О РАЙ бахталисардя ся, со сас Потифаростэ, — и андо чер, и андэ мал. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","О Потифаро отдя ся, со сас лэстэ, лэ Иосифости тай пала лэстэ вов ни пала со на гындосарэлас, кати пала кода со тэ хал. О Иосифо сас лашо пэса тай шукарно, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","тай пай варисави то время о Иосифо ашыля тэ чялёл лэстерэ раестеря ромняти. Вой пхэндя: — Сов манца! ");
INSERT INTO rmyvlakh_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ай вов на закамля. — Пала мандэ мэрно рай ни пала со на гындосарэл. Ся, со лэстэ исы андо чер, вов дя манди тэ дикхав, — пхэндя о Иосифо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","— Андэ кадыва чер нинай майбаро мануш мандар. Мэрно рай на отпхэнэл манди ни андэр со, кати тут, пала кода со ту сан лэсти ромни. Сар мэ тэ терав кацави найлащи бути тай кацаво бэзэх англа Дэл? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Дес пала дес вой дэлас дума лэса пала кода, ай Иосифо на камэлас тэ совэл ласа тай тэ авэл паша латэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Екхвар вов зажыля андо чер тэ терэл пэстери бути, кала никас на сас черэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Вой хутилдя лэс пала гат тай пхэндя: — Сов манца! Ай вов вишындиля латар тай нашлятар, ай лэско упруно гат ашыляпэ латэ андэ васта. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Кала вой дикхля, со вов нашлятар анда чер тай ашадя пэско гат андэ лати васта, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","вой акхардя лэ черэстерэ бутярнэн тай пхэндя лэнди: — Дикхэн, кадылэ евреёс андэ амэндэ андо чер, ай вов асалпэ амэндар! Вов авиля кардэ тай камля тэ совэл манца, ай мэ лэм тэ цыпи. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Мэрнэ цыпимастар вов ашадя пэско упруно гат тай нашлятар анда чер. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Вой ритярэлас лэ Иосифоско гат пэстэ, жыпокэ авиля черэ лэ Иосифоско хулай. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Вой роспхэндя лэсти кодыя жэ дума: — Кадыва копэли-евреё, савэс ту андян амэндэ, авиля мандэ тай камля тэ асалпэ мандар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Сар мэ лэм тэ цыпи, вов ашадя пэско гат тай нашлятар анда чер. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Кала о рай лэ Иосифоско ашундя ла ромняти дума, сави роспхэндя: «Акэ сар теро копэли обжыляпэ манца», вов фартэ холяйля. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Вов ля лэ Иосифос тай запхандадя лэс андо баруно, кай сас запхандадэ лэ тхагарэсти барунаря. Акадя о Иосифо ашыляпэ андо баруно. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","О РАЙ сас Иосифоса. Вов сыкадя лэсти о тынгимос тай дя лэсти лашымос англа э якха лэ барэдэрэсти по баруно. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","О барэдэр стходя лэ Иосифос барэдэса пэ саворэ барунаря, тай вов дикхэлас пала ся андо баруно. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","О барэдэр по баруно майбут на лэлас сама пэ кода, со сас дино андэ лэ Иосифости васта, пала кода со о РАЙ сас лэ Иосифоса тай дэлас лэсти бахт андэ саворэ бутя. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Кала прожыля варисави время, лэ тхагарэстерэ о чехымари тай о пэклимари попэлэ андэ дош англа пэско рай, англа Египтоско тхагар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","О фараоно холяйля пэ пэстерэ дуй пашутнэ рая, по майбаро чехымари тай по майбаро пэклимари, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","тай запхандадя лэн андо баруно пашай о чер лэ барэдэрэс пэ фирисаря, инчя жэ, кай сас запхандадо о Иосифо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","О барэдэр пэ фирисаря отдя лэн лэ Иосифости, тай кодыва терэлас лэнди бути. Вонэ сас котэ варисави время, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","тай лэнди дуенди, лэ чехымарести тай лэ пэклимарести, савэ сас запхандадэ андо баруно, андэ екх рят снисайлэ сунэ, тай андэ екх и андэ авэр суно сас пэско гындо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Кала о Иосифо авиля лэндэ пэ авэр дес тэсара, вов дикхля, со вонэ варисоза загрижомэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Вов пушля лэ фараоностерэ пашунтнэ раендар, савэ сас екхэтханэ лэса андэ екх чер лэстерэ раеско: — Состар тумэ адес кацавэ загрижомэ? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","— Амэнди лэ дуенэнди снисайлэ сунэ, — пхэндэ вонэ, — ай тэ гатярэл лэн най касти. О Иосифо пхэндя: — Со, о Дэл на гатярэла э сунэ? Роспхэнэн лэн манди. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Тунче о майбаро чехымари роспхэндя лэ Иосифости пэско суно: — Мэ дикхлэм андо суно виноградно лоза, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ай пэр латэ сас трин веткэ. Кати пэр латэ сыкадилэ э почкэ, вой розмэкляпэ тай э лулудя катэ жэ тердэпэ виноградоса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Мандэ андо васт сас лэ фараоноско тахтай, мэ лэм о виноградо, витасадэм ла андо тахтай тай подэм о тахтай андо васт лэ фараоности. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","— Акэ со када, — пхэндя лэсти о Иосифо. — Трин веткэ — када трин деса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Пай трин деса о фараоно ваздэла тут тай рисарэла пэ теро тхан, тай ту подэса лэ фараоности лэско тахтай, сар сас данглал, кала ту санас лэско чехымари. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Тунче кала тутэ ся авэла мишто, на бистэр пала мандэ тай сыкав теро лашымос каринг мандэ: пхэн пала мандэ лэ фараоности тай виндяр ман анда кадыва баруно. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ке ман зораса ундярдэ пай еврейско пхув, тай катэ мэ нисо на тердэм кацаво вырыто, соп тэ бэшав андо баруно. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Кала о майбаро пэклимари дикхля, со о Иосифо драго роспхэндя о суно, вов пхэндя лэ Иосифости: — И манди снисайля суно: мэ ритяравас по шэро трин корзынэ марнэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Андэ упруни корзына сас пэклимата важ о фараоно, тай ла ханас э черэкля. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","— Акэ со када, — пхэндя о Иосифо. — Трин корзынэ — када трин деса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Пай трин деса о фараоно и тут ваздэла: тути отшынэна о шэро, ай тери тила амблавэна по кашт, тай э черэкля лэна тэ хан ла. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","По трито дес, андэ пэско аракхадимаско дес, о фараоно стходя бари мисяля важэ саворэ пэсти рая. Англа лэндэ вов вазгля лэ майбарэ чехымарес тай лэ майбарэ пэклимарес. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Лэ майбарэ чехымарес вов рисардя палпалэ пэ лэско тхан, тай кодыва упалэ подя о тахтай андэ лэ фараоноско васт. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Ай лэ майбарэ пэклимарес амбладя по кашт, сар о Иосифо пхэндясас лэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","О майбаро чехымари на сэрэсардя пала Иосифо, вов бистердя пала лэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Прожылэ дуй бэрша, тай снипэ лэ фараоности суно: вов тэрдёлас катар э лэн Нило, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","тай акэ андай лэн Нило вижылэ ефта гуруня — лашэ тай тхулэ — и линэ тэ правардён пэ чяр катар о комыш. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Пала лэндэ вижылэ анда Нило авэр ефта гуруня — чишлэ тай санэ — тай тэрдэ кодылэнца катар э лэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Э чишлэ, санэ гуруня похалэ ефта лашэн, тхулэн гурунян. Катэ о фараоно прошутяпэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Вов упалэ засутя, тай лэсти снисайля авэр суно: ефта колосуря — зоралэ тай тхулэ — барёнас пэ екх бур. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Пала лэндэ вибарилэ инке ефта колосуря — санэ тай попхабардэ ла восточнона балваляса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Э санэ колосуря накхадэ ефта зоралэн, тхулэн колосонэн. Катэ о фараоно прошутяпэ. Кода сас суно. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Тэсара лэс на ашавэнас пхарэ гындуря палай сунэ. Вов акхардя пэстэ саворэн врэжыторен тай лэ бутжангэн, савэ сас андо Египто, тай роспхэндя лэнди пэстерэ сунэ, ай нико лэндар на ганэлас, сар тэ отпхандэс лэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Тунче о майбаро чехымари пхэндя лэ фараоности: — Адес сэрэсардэм, со мэ сым дошало. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Екхвар о фараоно холяйляс пэ пэстерэ бутярнэ тай пхангля ман тай лэ майбарэс пэклимарес андо баруно. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Андэ екх рят манди тай лэсти снисайля суно, тай андэ екх суно и андэ авэр суно сас пэско гындо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Котэ амэнца сас екх тэрно евреё, бутярно лэ барэдэрэско по баруно. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Вов роспхэндя амэнди э сунэ, ай ся кадя тай терэлпэ, сар вов пхэндя амэнди: ман рисардэ палпалэ пэ мэрно тхан, ай аврэс манушэс амбладэ по кашт. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","О фараоно бишалдя пала Иосифо, тай лэс йито андэ анда баруно. Вов подшындя э бал, пэрэля пэр пэстэ авэр йида тай авиля каринг о фараоно. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","О фараоно пхэндя лэ Иосифости: — Манди снисайля суно, тай нико нащи роспхэнэл лэс манди. Ай мэ ашундэм пала тутэ, со ту полэс э сунэ тай ганэс, сар тэ роспхандэл лэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","О Иосифо пхэндя: — Най мэ, ай о Дэл пхэнэла лэ фараоности кода, со вов камэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","О фараоно пхэндя лэ Иосифости: — Манди снисайля андо суно, со мэ тэрдював катар э лэн Нило, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","тай вижыле андай лэн Нило ефта гуруня, тхулэ тай лашэ, тай линэ тэ правардён пэ чяр катар о комыш. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Пала лэндэ вижылэ авэр ефта гуруня, чишлэ, екх э кокала, ся абисавэ, кацавэн мэ никала данглал на дикхлэм па ся египтоско пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Э чишлэ тай абисавэ гуруня похалэ лэ ефта тхулэн гурунян, савэ вижылэ данглал. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Тай кала вонэ похалэ лэн, вонэ на тхулилэ, ай ашылэпэ кацавэ жэ абисавэ, сар саслэ данглал. Катэ мэ просутэмпэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Инке мэ дикхэлэм андо суно ефта колосуря пэ екх бур, пхэрди лашэ ворзоса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Пала лэндэ вибарилэ авэр ефта колосуря, шукэ, санэ тай попхабардэ ла восточнона балваляса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Э санэ колосуря накхадэ ефта лашэн колосонэн. Мэ роспхэндэм лэ врэжыторенди, тай нико лэндар на отпхандадя манди о суно. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","О Иосифо пхэндя лэ фараоности: — Андэ кадыла сунэ исы екх гындо. О Дэл сыкадя лэ фараоности, со Вов камэл тэ терэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Ефта лашэ гуруня — када ефта бэрша, тай ефта лашэ колосуря — када ефта бэрша. Када исы екх суно. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Э ефта чишлэ, абисавэ гуруня, савэ авилэ палал, — када ефта бэрша, тай кадя жэ э ефта санэ колосуря, попхабардэ ла восточнона балваляса — када ефта бокхалэ бэрша. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Акэ кода ворта, со мэ пхэндэм лэ фараоности: о Дэл сыкадя лэсти Пэско гындо, со Вов камэл тэ терэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Пай ся египтоско пхув авэна ефта бэрша баро барвалимос, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","ай пала лэндэ авэна ефта бокхалэ бэрша. Тунче ся о барвалимос ефта бэршэнго андо Египто авэна забистэрдэ, тай э бокх шушарэла э пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Нико на сэрэла пала барвалимос пэ кадыя пхув ла бокхатар, сави авэла фартэ чёры. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ай со сас сыкадо о суно лэ фараоности дувар, кода со о Дэл састэс камэл када йито тэ терэл па Пэско гындо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Ай акана мэк о фараоно аракхэла годявэрнэс манушэс тай мэк стхол лэс барэдэрэса пэ ся Египтоско пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Мэк о фараоно стхол раен па ся пхув, соп вонэ тэ стидэн панчто котор ся, со дэла э пхув андо Египто андэ кола ефта лашэ бэрша. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Мэк андэ кола лашэ бэрша стидэн лэ фараоностерэ алавэстар о ворзо тай фирисарэн лэс андэ форуря. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Трэбуй тэ фирисарэн кодыва хамос тай тунче тэ хан лэс, кала андо Египто авэна ефта бокхалэ бэрша, тэ на хасайвэн саворэ бокхатар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Кадыя дума чялиля лэ фараоности тай лэстерэ раенди. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","О фараоно пушля пэстерэ раендар: — Аракхаса инке кацавэс, сар кодыва манушэс, андэ савэстэ исы о Духо лэ Дэвлэско? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Тай о фараоно пхэндя лэ Иосифости: — Сар о Дэл отпхандадя када ся тути, нинай тутар май годявэрнэс манушэс, кай тэ дикхэл, со авэла англэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Мэ стхав тут барэдэрэса пэ ся мэрно чер, тай ся мэрно народо авэла тэ кандэл терэ алава. Кати мэрно троно авэла майупрэ тутар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","О фараоно пхэндя лэ Иосифости: — Дикх, мэ стхав тут пэ ся Египтоско пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Вов зля па най пэстери янгрусни тай стходя ла по най лэ Иосифоско, вурядя лэс андэ сани похтаницко йида тай амблавдя лэсти пэ кор сомнакуно цэпо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Вов пхэндя тэ пхиравэн лэс андо вурдон сар дуйтонэс пала пэстэ тай тэ цыпин англа лэстэ «Аврех!» Кадя вов стходя лэс пэ ся Египтоско пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","О фараоно пхэндя лэ Иосифости: — Мэ сым фараоно, ай би терэ алавэско нико андо Египто на ваздэла на о васт, на о пэрно. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Вов дя лэ Иосифости алав Цавнат-Панеахо тай дя лэсти ромня ла Асната, лэ Поти-Перастери щей, саво сас рашай по форо Оно. Тунче о Иосифо лагля андо дром па ся египтоско пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Кала о Иосифо ля тэ терэл бути по фараоно, по Египтоско тхагар, лэсти сас триндэша бэрша. Вов вижыля лэ фараоностар тай традэлас па ся Египто. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Ся ефта чялэ бэрша э пхув дэлас барвало хамос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","О Иосифо стидэлас ся, со дэлас э пхув андэ кадыла ефта бэрша андо Египто, тай стховэлас андэ форуря. Андэ саворэ форуря вов стидэлас хамос, саво барёлас пэ пашутнэ маля. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Вов стидэлас кадя бут ворзо, сар о чишай андо баро паи. Лэс сас кадя бут, кай вов парашыля тэ ангичел, пала када со лэс сас фартэ бут. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Англа када, сар авилэ э бокхалэ бэрша, кай о Иосифо аракхадилэ дуй шавэ ла Аснататар, лэ Поти-Перастеря щятар, саво сас рашай по форо Оно. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","О Иосифо дя алав пэстерэ англунэ шавэсти Манасия тай пхэндя: «О Дэл дя тэ бистрав ся мэрни грижа тай ся мэрнэ дадэско ери». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Лэ дуйтонэсти шавэсти вов дя алав Ефремо тай пхэндя: «О Дэл дя манди бэятонэн пэ пхув, кай сымас грижомэ». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Прожылэ ефта лашэ бэрша андо Египто, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","тай авилэ ефта бокхалэ бэрша, сар о Иосифо пхэндя. Э бокх сас андэ саворэ авэр пхуя, ай кати пэ Египтоско пхув сас хамос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Кала ся о Египто ашыля тэ бокхайвэл, э мануша линэпэ тэ мангэн лэ фараонос пала хамос, тай о фараоно пхэндя лэ египтянонэнди: — Жан каринг о Иосифо тай терэн, сар вов пхэнэла. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Кала э бокх росжыляпэ па ся пхув, о Иосифо пхэрнадя складуря тай ля тэ битинэл о ворзо лэ египтянонэнди. Э бокх андо Египто сас чёры. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Пала кода со па ся тхана сас бари бокх, э мануша анда саворэ тхана авэнас андо Египто тэ тинэн кай Иосифо о ворзо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Кала о Яково угангля, со андо Египто исы ворзо, вов пхэндя лэ шавэнди: — Со тумэ дикхэн екх пэ екхэстэ? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Мэ ашундэм, со андо Египто исы ворзо. Жан тай тинэн лэс амэнди, собы амэ тэ жувас тай тэ на мэрас. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Э дэш пхрала лэ Иосифости жылэтар андо Египто, соп тэ тинэн о ворзо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ай лэ Вениаминос, лэ Иосифостерэ пхралэс, о Яково на отмукля лэнца, пала кода со вов даралас, со лэса терэлапэ варисави бида. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Кадя э шавэ лэ Израилёсти авилэ машкара бутэн аврэ манушэн тэ тинэн о ворзо, ке пэ пхув Ханаано сас бокх. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","О Иосифо хулаияс пэ ся пхув, вов битинэлас о ворзо лэ народости па ся Египто. Пхрала авилэ лэ Иосифости тай тэлилэ лэсти жы кай э пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Сар кати о Иосифо додикхля пэстерэ пхралэн, вов гатярдя лэн, ай притердяпэ, со вов на ганэл лэн, и ля тэ дэл дума лэнца холяса. — Катар тумэ авилэ? — пушля вов. — Андай пхув Ханаано, соп тэ тинас хамос, — пхэндэ вонэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","О Иосифо гатярдя пэстерэ пхралэн, ай вонэ на гатярдэ лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Вов сэрэсардя пэсти сунэ пала лэндэ тай пхэндя: — Тумэ — шпионуря! Тумэ авилэ тэ дикхэн, кай андэ амари пхув исы найзоралэ тхана. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","— Со ту, рай, — пхэндэ вонэ. — Терэ копэля авилэ тэ тинэн хамос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Амэ сам саворэ екхэ дадэсти шавэ. Терэ копэля най хохавнэ мануша, амэ най шпионуря. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Вов пхэндя лэнди: — Най! Тумэ авилэ тэ дикхэн, кай андэ амари пхув исы найзоралэ тхана. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Вонэ пхэндэ: — Амэ, терэ копэля, — дэшудуй пхрала. Амэ — шавэ екхэ дадэсти, саво жувэл пэ пхув Ханаано. О майцыкно шаво екхатар лэ дадэса, ай екхэс амэндар бутэр нинай. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","О Иосифо пхэндя лэнди: — Мэ жэ пхэндэм, со тумэ — шпионуря! ");
INSERT INTO rmyvlakh_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Акэ сар мэ када тумэндар випхушава: солахав лэ фараоностерэ жувимаса, тумэ на жанатар катар, жыпокэ на авэла кардэ тумаро о майцыкно пхрал. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Бишалэн екхэс тумэндар пала пхрал, ай авэр бэшэна андо баруно. Кадя мэ уганава тумари дума — чячес ли тумэ пхэнэн манди. Ай сар най чячес, солахав лэ фараоностерэ жувимаса, тумэ — шпионуря! ");
INSERT INTO rmyvlakh_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Тай пхандадя лэн пэ трин дес андо баруно. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","По трито дес о Иосифо пхэндя лэнди: — Стерэн, со мэ пхэнав, тай тумэ жувэна, ке мэ дарав Дэвлэстар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Сар тумэ найхохавнэ мануша, мэк екх тумэндар ашэлпэ катэ андо баруно, ай авэр жана тай отдындярэна о ворзо тумарэ бокхалэ ерянди. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Тумэ трэбуй тэ анэн мандэ тумарэ лэ майцыкнэ пхралэс, собы тэ ганав, со тумари дума чячюни. Тунче тумэ ашэнапэ тэ жувэн. Вонэ кадя тай стерэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Вонэ пхэндэ екх екхэсти: — Дичёл, со пар амэндэ авиля кадыя бида пала дош англа амаро пхрал. Амэ дикхасас лэсти грижа, кала вов мангэлас амэн тэ фирисарас лэско жувимос, ай амэ на камлям тэ ашунас лэс, тай акэ пар амэндэ авиля кадыя бида. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","О Рувимо пхэндя: — Мэ жэ пхэнавас тумэнди — на терэн бэзэх пала шаворо, ай тумэ на канглэ ман! Акана потинаса пала лэско рат. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Вонэ на гындосарэнас, со о Иосифо полэл лэнди шыб, пала када со авэр мануш пэрэндярэлас лэстери дума пэ лэндери шыб. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Вов отбандиля лэндар тай заровдя, тунче обандиля тай ля тэ дэл дума лэнца. Вов ля лэндар лэ Симеонос тай спхандэля лэс англа лэнди якха. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","О Иосифо пхэндя тэ пхэрэн лэнди э гонэ ворзоса, тай тэ шон саворэнди палпалэ лэнго руп тай тэ дэн лэнди хамос по дром. Кадя и сас стердо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Вонэ постходэ э гонэ пэ ослуря тай жылэтар андо дром. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Кала вонэ тэрдилэ тэ рятярэ, екх лэндар роспхангля о гоно, соп тэ лэл о ворзо тэ праварэл лэ ослос, тай додикхэл андо гоно пэско руп. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","— Мэрно руп рисайля палпалэ! — пхэндя вов лэ пхралэнди. — Акэ вов, андэ мэрно гоно. Лэндерэ одя заморцосайлэ даратар, вонэ бандилэ екх каринг екхэстэ тай пхэндэ: — Со када тердя амэнца о Дэл? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Кала вонэ авилэ кай пэско дад каринг о Яково пэ пхув Ханаано, вонэ роспхэндэ лэсти пала ся, со лэнца тердяпэ. Вонэ пхэндэ: ");
INSERT INTO rmyvlakh_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","— О мануш, саво хулаи пэ кадыя пхув, дэлас дума амэнца холяса тай приля амэн палай шпионуря. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ай амэ пхэндям лэсти: «Амэ найхохавнэ мануша, най шпионуря. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Амэ — дэшудуй пхрала, шавэ екхэ дадэсти. Екхэс бутэр нинай, ай о майцыкно екхатар лэ дадэса андо Ханаано». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Тунче кодыва мануш, саво хулаи пэ кодыя пхув, пхэндя амэнди: «Акэ сар мэ уганава, найхохавнэ тумэ мануша чи хохавнэ: ашавэн екхэ пхралэс катэ манца, лэн хамос важ тумарэ бокхалэ еря тай жан тумарэ дромэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ай анэн мандэ тумарэс лэ майцыкнэ пхралэс — кадя мэ уганава, со тумэ най шпионуря, ай чячюнэ мануша. Тунче мэ отдава тумарэ пхралэс тай пхэнава, соп тумэ тэ пхирэн пэ кадыя пхув, каринг камэн». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Кала вонэ линэ тэ роспхандэн э гонэ, саворэ аракхлэ андэ пэско гоно о бужо лэ рупэса. Сар вонэ додикхлэ о руп, вонэ тай лэнго дад пэрэдарайлэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","О Яково пхэндя лэнди: — Тумэ залинэ мандар мэрнэ бэятонэн. Лэ Иосифос бутэр нинай, тай лэ Симеонос бутэр нинай, ай акана тумэ камэн тэ лэн лэ Вениаминос. Со када авиля пэр мандэ! ");
INSERT INTO rmyvlakh_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Тунче о Рувимо пхэндя пэсти дадэсти: — Мулярэса мэрнэ дуен шавэн, сар кай мэ на анава лэ Вениаминос тути палпалэ. Дэ лэс мандэ, тай мэ анава лэс кардэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","О Яково пхэндя: — Мэрно шаво на жала инчя туса. Лэско пхрал муля, вов ашыляпэ екжэно. Сар лэса дромэса терэлапэ глаба, тунче кадыла грижаса тумэ зындярна мэрно суро шэро пэ лэ мулэнди люма. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Э бокх сас инке пэ кодыя пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Кала вонэ похалэ ся о марно, саво андэ анда Египто, лэнго дад пхэндя: — Жан упалэ, тинэн амэнди инке найбут хамос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Нэ о Иуда пхэндя лэсти: — Кодыва мануш пхэндя амэнди холяса: «На сыкадён манди пэ якха, сар тумэнца на авэла тумаро пхрал». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Сар ту мэкэса амарэ пхралэ амэнца, тунче амэ жаса тай тинаса тути хамос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ай сар ту на мэкэса лэс, амэ на жаса, пала кода со кодыва мануш пхэндя амэнди: «На сыкадён манди пэ якха, сар тумэнца на авэла тумаро пхрал». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","О Израилё пушля лэндар: — Состар тумэ андэ манди кадыя глаба, пхэндэ кодылэ манушэсти, со тумэндэ исы инке екх пхрал? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Вонэ пхэндэ: — Кодыва мануш пушэлас ся пала амэндэ тай пала амаро ери: «Жундо инке тумаро дад? Исы тумэндэ инке пхрал?» Амэ роспхэндэ лэсти, со вов пушэлас. Катар амэ ганглям, со вов пхэнэла: «Анэн кардэ тумарэ пхралэс»? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","О Иуда пхэндя лэ Израилёсти, пэстерэ дадэсти: — Бишал лэ шаворэс манца, тай амэ жасатар, кай амэ саворэ тэ на хасайвас тай тэ жувас ту тай амарэ бэяцэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Мэ дав тути алав, со мэ екхжэно фирисарава лэс, мандар пушэса пала лэстэ. Сар мэ на анава лэс каринг тутэ тай на стхава лэс англа тутэ, тунче мэ авава дошало англа тутэ жыпокэ на мэрава. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Сар амэ тэ на цырдас э время, то дувар жылоп тай рисайлоп палпалэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Тунче лэнго дад о Израилё пхэндя лэнди: — Сар кадя, тунче акэ со терэн: стхон андэ трастэ майлашо хамос амаря пхуятар тай андярэн андо даро кодылэ манушэсти — бальзамо тай ядин, спецые тай ладано, фисташкэ тай миндалё. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Лэн тумэнца дувар майбут руп, лэс трэбуй тэ отдэн палпалэ, саво сас стходо андэ тумарэ гонэ. Файма, вонэ на прыдикхлэпэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Лэн тумэнца тумарэ пхралэс тай майито жан каринг кодыва мануш. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Мэк о Дэл Саворэзорэско дэл тумэнди тынгимос англа лэстэ, соп вов тэ мэкэл и аврэс тумарэ пхралэс тай лэ Вениаминос, тэ рисайвэн черэ екхтанэ. Ай сар манди трэбуй тэ ашавпэ би бэятонэнго, мэк кадя и авэла. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Тунче вонэ линэ э подаркуря, тай дуйвар майбут руп, тай лэ Вениаминос, майито жылэтар андо Египто тай авилэ англа Иосифо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Кала о Иосифо дикхля, со лэнца о Вениамино, вов пхэндя пэстерэ барэдэрэ бутярнэсти пэ пэско чер: — Одындяр кадылэ манушэн мандэ черэ, шын варисавэс скотос тай стхов мисяля. Вонэ хана манца андо епаш дес. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Кодыва мануш стердя, сар лэсти пхэндэ, тай андя лэн андо чер кай о Иосифо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Кала лэн андэ каринг о Иосифо черэ, вонэ пэрэдарайлэ. Вонэ гындосардэ: «Амэн андярдэ кордэ пала о руп, саво рисардапэ андэ амарэ гонэ андо англуно моло. Вов камэл тэ нахукэл пэ амэндэ, и тэ помарэл, и тэ залэл андэ копэля, и тэ залэл амарэн ослонэн». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Вонэ поджылэ кай о бутярно лэ Иосифоско тай линэ тэ дэн дума лэса паша вудар лэ черэско: ");
INSERT INTO rmyvlakh_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","— Ашун, рай, — пхэндэ вонэ, — амэ авэнас кардэ екхвар тэ тинас хамос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Кала амэ тэрдилям тэ рятярас тай роспханлям э гонэ, саворо амэндар аракхля котэ пэско руп, ворта скати сас. Амэ андям кодыва руп палпалэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Амэ андям пэса инке руп, соп тэ тинас хамос. Амэ на ганас, ко тунче стходя амаро руп палпалэ андэ гонэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Вов пхэндя: — Ся мишто, на даран. Мэ лэм тумаро руп. Кода тумаро Дэл, о Дэл тумарэ дадэско, дя тумэнди палпалэ кодыва руп андэ тумарэ гонэ. Тунче о барэдэр бутярно андя лэ Симеонос каринг лэндэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Вов андя лэ пхралэн андо чер кай о Иосифо, дя лэнди паи тэ халавэн э пэрнэ тай сулум лэ ослонэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Вонэ гэтосардэ лэ Иосифости э подаркуря, соп тэ дэн лэн, кала вов авэла андэ епаш дес, пала кода ке лэнди пхэндэ, со вонэ котэ бэшэна тэ хан. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Кала о Иосифо авилятар черэ, вонэ подындярдэ лэсти э подаркуря тай тэлилэ лэсти жы каринг э пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Вов пушля пала лэнго састимо, тунче пхэндя: — Ай и сар мишто котэ тумаро пхуро дад, пала саво тумэ пхэндэ манди? Вов жундо инке? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Вонэ пхэндэ: — Теро копэли, амаро дад, инке жундо тай зорало, — тай тэлилэ англа лэстэ, тэ сыкавэн пэстери патив лэсти. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","О Иосифо додикхля пэстерэ пхралэс лэ Вениаминос, пэстеря датерэ шавэс, тай пушля: — Када тумаро о майцыкно пхрал, пала кастэ тумэ пхэнэнас манди? О Дэл тэ авэл тынгомэ каринг тутэ, мэрно шаво! ");
INSERT INTO rmyvlakh_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Лэ Иосифоско ди сас най по тхан, кала вов дикхля пэстерэ пхралэс, вов йито жылятар тай родэлас тхан, кай тэ авэл екхжэно. Вов зажыля андэ пэско тхан андо чер тай котэ ашыля тэ ровэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Тунче вов халадя о муй тай упалэ вижыля, ритярэлас пэс, тэ на ровэл, тай пхэндя: — Подэн о хамос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Лэсти подинэ пэ екх скаминд, лэ пхралэнди пэ авэр скаминд, тай лэ египтянонэнди, савэ ханас лэса, кадя ж пэ пэско скаминд. Э египтянуря на хан екхтанэ лэ евреёнэнца, кода лэнди сас гряца. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Лэ пхралэн стходэ тэ бэшэн англа лэстэ па пхуримос, лэ англунэстар жы каринг о майцыкно. Вонэ дикхэнас екх пэ екхэстэ тай дивуинаспэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Лэнди подэнас о хамос пай мисяля лэ Иосифостар, лэ Вениаминости подэнас панчварэс майбут, сар аврэндэ. Вонэ ханас тай пэнас лэ Иосифоса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","О Иосифо пхэндя пэстерэ барэдэрэ бутярнэсти: — Пхэр э гонэ кадылэ манушэндерэ хамаса, скати ундярэна, тай стхов о руп саворэнди палпалэ андэ гонэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Стхов мэрно рупуно тахтай андо гоно лэ майцыкнэсти екхтанэ лэстерэ рупэса пала ворзо. Кодва стердя кадя, сар пхэндя лэсти о Иосифо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Кати десайля, лэ пхралэн бишалдэ андо дром пэстерэ ослонэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Вонэ сас инке найдур лэ форостар, кала о Иосифо пхэндя лэ барэдэрэ бутярнэсти: — Майито ладэ пала кодыла мануша. Кала дорэсэса, пхэн лэнди: «Состар тумэ потиндэ вырытимаса пала лашымос? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ке кода мэрнэ раеско тахтай, анда саво вов пэл тай пэ саво врэжый! Тумэ стердэ вырыто дило!» ");
INSERT INTO rmyvlakh_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Кала о барэдэр бутярно дорэсля лэн, вов пхэндя лэнди кадыла алава. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Э пхрала пхэндэ: — Состар о рай пхэнэл кацавэ алава? Терэ копэля на авэна кацаво тэ терэн! ");
INSERT INTO rmyvlakh_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ке амэ жэ андям тути палпалэ анда пхув Ханаано о руп, саво аракхлям андэ амарэ гонэ. Сости амэнди тэ чёрас о руп чи о сомнак анда чер терэ раестар? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Сар аракхэса о тахтай кай екх терэ копэлендар, мэк вов мэрэл, ай авэр ашэна терэ раести копэленца. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Вов пхэндя: — Мишто, мэк авэл кадя, сар тумэ пхэнэн: кастэ аракхава о тахтай, кодыва ашэла мэрно копэли, ай авэр авэна надошалэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Э пхрала йито стходэ э гонэ тэлэ пэ пхув тай роспхандэ лэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","О барэдэр бутярно ля тэ родэл, лэ майпхурэстар жы кай о майтэрно, тай аракхля о тахтай андо гоно кай о Вениамино. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Э пхрала росшындэ пэр пэстэ э гада, стходэ э гонэ пэ ослуря тай рисайлэ палпалэ андо форо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","О Иуда тай лэсти пхрала рисайлэ андо чер кай о Иосифо, саво сас инке котэ. Вонэ пэлинэ англа лэстэ пэ пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","О Иосифо пхэндя лэнди: — Со жэ тумэ тердэ? Тумэ со, на ганглэ, со кацаво мануш, сар мэ, ся ганэла пай врэжа? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","— Со амэ тэ пхэнас амарэ раести? — пхэндя о Иуда. — Сар тэ дас дума? Сар тэ сыкавас, со сам чячюнэ? О Дэл сыкавэл э дош терэ копэленди. Акана амэ терэ копэля, мэрно рай, — мэ тай кодыва, кастэ аракхлэ о тахтай. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","О Иосифо пхэндя: — Мэ на авава кода тэ терав! Кати кодыва, кастэ аракхлэ о тахтай, авэла мэрно копэли, ай тумэ лошаса рисайвэн палпалэ каринг тумаро дад. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Тунче о Иуда поджыля лэстэ тай пхэндя: — Мангав тут, мэрно рай, дэ терэ копэлести тэ дав дума туса. На холяйвэ пэ пэстрерэс копэли, ту ж кацаво, сар и фараоно. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Мэрно рай пушлясас кай пэстерэ копэля: «Исы тумэндэ дад чи пхрал?» ");
INSERT INTO rmyvlakh_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Тай амэ пхэндямас лэ раести: «Амэндэ исы пхуро дад тай лэстэ исы тэрно шаво, саво аракхадиля лэстэ андэ лэско пхуримос. Лэско пхрал муля, тай вов ашыляпэ екх лэ кай пэсти дэй лэ шавэндар, тай лэско дад камэл лэс». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Тунче ту пхэндян терэ копэленди: «Анэн лэс мандэ, соп мэ тэ дикхав пэр лэстэ». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ай амэ пхэндямас амарэ раести: «О шаворо на ашавэла пэстерэ дадэс. Ай сар ашавэла, тунче о дад мэрэла». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ай ту пхэндян терэ копэленди: «Жыпокэ тумаро пхрал на авэла кардэ тумэнца, на сыкадён манди пэ якха». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Кала амэ рисайлям каринг амаро дад, амэ роспхэндэ лэсти, со пхэндян мэрно рай. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Тунче амаро дад пхэндя: «Рисайвэн тай тинэн инке найбут хамос». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Амэ пхэндямас: «Амэнди нащи тэ жас, кати сар жала амэнца о цыкно пхрал, тунче амэ жаса. Амэнди нащи тэ сыкадювас пэ якха кодылэ манушэсти би лэ цыкнэ пхралэса». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Теро копэли, амаро дад, пхэндя амэнди: «Тумэ екхжэнэ ганэн, со мэрни ромни андя манди дуен шавэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Екх лэндар жалятар мандар, тай мэ пхэндэм: «Вов сас росшындо пэ котора», — тай кодыла времятар мэ лэс на дикхлэм. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Сар тумэ лэна мандар и аврэс, тай лэса терэлапэ глаба, тумэ зындярна мэрно суро шэро пэ лэ мулэнди люма грижатар». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Акана, сар о шаворо на рисайвэла амэнца каринг о дад, тай сар мэрно дад, саво фартэ камэл лэ шаворэс, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","дикхэла, со лэс нинай амэнца, вов мэрэла. Терэ копэля зындярна о суро шэро амарэ дадэско пэ лэ мулэнди люма грижатар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Теро копэли дя алав англа дад, со фирисарава лэ шаворэс. Мэ пхэндэм: «Сар мэ на анава лэс каринг тутэ, кадыя дош англа тутэ, дадэ, авэла пэр мандэ ся жувимос». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Ай акана мангав тут, дэ терэ копэлести тэ ашавпэ катэ копэлеса мэрнэ раести важ о шаворо, ай лэ шаворэс мэк тэ рисайвэл пэстерэ пхралэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Сар мэ рисайвава каринг о дад би лэ шаворэско? Тэ на дикхав мэ э грижа мэрнэ дадэсти. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Тунче о Иосифо нащи зритярэлас пэс англа э копэля тай зацыпий: — Жантар саворэ мандар! — тай никас на сас лэ Иосифоса, кала вов принджяндиля пэстерэ пхралэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Вов кадя фартэ ровэлас, со ашундэ э египтянуря, тай э дума пала кода дожыля каринг о фараоно. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","О Иосифо пхэндя пэстерэ пхралэнди: — Мэ сым о Иосифо! Жундо инке мэрно дад? Ай э пхрала нащи дэнас дума, вонэ саслэ пэрэтиносардэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Тунче о Иосифо пхэндя лэ пхралэнди: — Поджан мандэ. Тай кала вонэ поджылэ, вов пхэндя: — Мэ сым тумаро пхрал о Иосифо, савэс тумэ битиндэ андо Египто! ");
INSERT INTO rmyvlakh_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","На даран тай на дошалярэн бутэр пэс пала кода, со битиндэ ман кардэ: када о Дэл бишалдя ман англа тумэндэ тэ фирий тумаро жувимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Дуй бэрша, сар исы бокх пэ пхув, тай инке панч бэрша на шынэна э пхув тай на авэна тэ стидэн о ворзо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","О Дэл бишалдя ман англа тумэндэ, соп тэ фирисарэл пэ пхув тумарэ жувима тай тумари порода. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Акадя, ман кардэ бишалдэ най тумэ, ай о Дэл. Вов стходя ман тэ авав сар дад лэ фараоности, раеса пэ ся лэско чер тай тэ хулаи саворэ Египтоса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Акана грабинпэ тэ рисайвэн каринг мэрно дад тай роспхэнэн лэсти: «Акэ со дэл дума о Иосифо, теро шаво: \"О Дэл стходя ман тэ хулаи пэ ся Египто. Ав мандэ, на цырдэ э время. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ту жувэса пэ пхув лэ форости Гошэно тай авэса паша мандэ: ту, терэ шавэ, внукуря, терэ баро тай о цыкно ското, тай ся, со тутэ исы. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Котэ праварава тут, ке инке авэна панч бэрша бокх, ай тунче ту тай теро ери, тай ся, ко исы туса, авэна андо чёрымос\"». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Тумэ дикхэн тумарэ якхэнца, тай тумэ, тай мэрно пхрал о Вениамино, со када мэ чячес дав дума тумэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Роспхэнэн мэрнэ дадэсти пала кода, сар мэ ашардо сым андо Египто, тай пала ся, со тумэ дикхлэ. Тай майито анэн мэрнэ дадэс кардэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Вов обляпэ пэстерэ пхралэса лэ Вениаминоса тай заровдя. Тай о Вениамино обля лэс тай ровдя. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Вов чюмидэлас саворэн пхралэн, облэлас лэн тай ровэлас. Тунче э пхрала дэнас дума лэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Э дума пала кода, со авилэ лэ Иосифости пхрала, дожыля каринг о фараоно. Вов тай лэстерэ рая лошайлэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","О фараоно пхэндя лэ Иосифости: — Пхэн терэ пхралэнди: «Стхон э гонэ лэ хамаса пэ тумарэ ослуря, рисайвэн андэ пхув Ханаано ");
INSERT INTO rmyvlakh_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","тай анэн мандэ тумарэ дадэс тай тумарэ еря. Мэ дава тумэнди майлащи пхув андо Египто, тай тумэ авэн тэ хан майлашо, со дэла э пхув». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Инке со пхэн лэнди: «Лэн анда Египто вурдона важ тумарэ бэяцэ тай важ э ромня, лэн тумарэ дадэс тай авэн кардэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","На тынгон тумаро ашадо хаббэ, ке ся, со исы майлашо андо Египто, авэла тумаро». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Э шавэ лэ Израилёстерэ кадя тай стердэ. О Иосифо дя лэнди вурдона, сар пхэндя о фараоно, тай хамос по дром. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Саворэнди вов дя нэви йида, ай лэ Вениаминости вов дя триншэла рупунэ ястря тай панч йидэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Пэсти дадэсти вов бишалдя дэшэн ослонэн майлашэ мищимаса, кай сас андо Египто, тай дэшэ ослицэн ворзоса, марнэса тай аврэ хамаса андо дром. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Пала када вов бишалдя лэ пхралэн, тай кала вонэ жанастар, пхэндя лэнди: — На терэн чингар андо дром! ");
INSERT INTO rmyvlakh_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Вонэ жылэтар анда Египто тай авиле каринг пэско дад, кай о Яково пэ пхув Ханаано. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Вонэ пхэндэ лэсти: — О Иосифо жундо! Вов сыно хулай пэ ся Египто! Кай о Яково замуля оди, и вов на патялас лэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ай кала вонэ роспхэндэ лэсти ся, со пхэндя о Иосифо, тай дикхля э вурдона, савэ вов бишалдя тэ андярэн лэс, оди лэ Яковоско жундиля. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Тунче о Израилё пхэндя: — Хутила! Мэрно шаво о Иосифо жундо! Жава тай дикхава лэс, англа кода сар тэ мэрав. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","О Израилё жылятар ся пэстерэ мищимаса андо дром. Кала вов авиля андэ Вирсавия, вов андя котэ жэртва Дэвлэсти пэстерэ дадэстэ лэ Исаакостэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","О Дэл сыкадиляпэ лэ Израилёсти рятэ тай пхэндя: — Яково! Яково! — Акэтало мэ, — пхэндя вов. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","— Мэ сым о Дэл, о Дэл терэ дадэско. На дара тэ жас андо Египто, ке котэ Мэ стерава тутар баро народо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Мэ жава екхтанэ туса андо Египто, тай Мэ жэ анава тут палпалэ. Тай лэ Иосифоско васт пхандавэла терэ якха. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Тунче о Яково жылятар андай Вирсавия. Лэ Израилёстерэ шавэ бэшардэ пэсти дадэс, лэ бэятонэн тай лэ жувлян андэ вурдона, савэ бишалдясас о фараоно, кай тэ анэн лэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Вонэ линэ пэса лэ скотос тай ся пэско хулаимос, саво затердэ андо Ханаано. Кадя о Яково саворэ пэстерэ ереса авиля андо Египто. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Вов ля пэса андо Египто пэстерэ шавэн тай лэ внуконэн, лэ щеян тай лэ внучкэн — ся пэсти порода. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Акэ алава лэ Израилёстерэ шавэнди, савэ авилэ андо Египто. О Яково тай лэсти бэяцэ. О Рувимо, лэ Яковоско англуно шаво. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Лэ Рувимостерэ шавэ: о Ханохо, о Палу, о Хецроно тай о Кармиё. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Лэ Симеоностерэ шавэ: о Емуэло, о Ямино, о Охадо, о Яхино, о Цохаро тай о Шауло, шаво ла ханаанеянкако. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Лэ Левиёстерэ шавэ: о Гершоно, о Кехато тай о Мерариё. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Лэ Иудастерэ шавэ: о Эро, о Онано, о Шэла, о Парэцо тай о Зарахо (о Эро тай о Онано мулинэ андо Ханаано). Лэ Парэцостерэ шавэ сас о Хецроно тай о Хамуло. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Лэ Исахаростерэ шавэ: о Тола, о Пува, о Иово тай о Шымроно. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Лэ Завулоностерэ шавэ: о Середо, о Элоно тай о Яхлеэло. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Када ла Лиятерэ шавэ, савэн вой андя лэ Яковости андо Падан-Арамо. Вой инке андя и ла щя ла Дина. Саворэн лэн сас трянда трин мануша. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Лэ Гадостерэ шавэ: о Цэфоно, о Хагиё, о Шуниё, о Эцбоно, о Эриё, о Ародиё тай о Арелиё. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Лэ Асиростерэ шавэ: о Имна, о Ишва, о Ишвиё тай о Бриа. Тай лэнди пхэй э Серах. Лэ Берииёстерэ шавэ: о Хеверо тай о Малкиэло. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Кадыла бэяцэ аракхадилэ лэ Яковости ла Зелфатар, савя о Лавано дя пэстеря щяти ла Лияти. Саворэн лэн сас дэшушов мануша. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Лэ Яковостерэ шавэ ла Рахилятар: о Иосифо тай Вениамино. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Андо Египто э Аснат, э щей лэ Поти-Перасти, саво сас рашай андо форо Оно, андя лэ Иосифости лэ Манасияс тай лэ Ефремос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Лэ Вениаминостерэ шавэ: о Бела, о Бехеро, о Ашбело, о Гера, о Наамано, о Эхиё, о Рошо, о Мупимо, о Хупимо тай о Ардо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Када шавэ ла Рахилятерэ, савэн вой андя лэ Яковости. Саворэн лэн сас дэшуштар мануша. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Лэ Даноско шаво: о Хушымо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Лэ Нефалимостерэ шавэ: о Яхцээло, о Гуниё, о Ецэро тай Шылемо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Кадыла сас шавэ, кас андя лэ Яковости э Вала, савя о Лавано дя пэстеря щяти ла Рахиляти. Саворэн лэн сас ефта манушэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Саворэ, ко авиля андо Египто лэ Яковоса, — лэстерэ чяче бэятонэн, на ангичяс лэстерэ борян, — сас лэн шовдэша шов манушэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Инке сас дуй шавэ лэ Иосифостерэ, савэ аракхадилэпэ андо Египто. Ся лэ Яковоско ери, савэ авилэ андо Египто, сас ефтадэша манушэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","О Яково бишалдя англа пэстэ каринг о Иосифо лэ Иудас, соп тэ уганэн о дром андо Гошэно. Кала вонэ авилэ инчя, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","о Иосифо лагля андо Гошэно пэ вурдон, соп тэ дикхэлпэ пэстерэ дадэса лэ Израилёса. Кала вонэ дикхлэпэ, вов обля лэс тай бут ровэлас. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","О Израилё пхэндя лэ Иосифости: — Акана мэ сым гата и тэ мэрав, ке дикхлэм мэрнэ якхэнца, со ту сан жундо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","О Иосифо пхэндя пэстерэ пхралэнди тай пэсти дадэстерэ ерести: — Мэ жава каринг о фараоно тай пхэнава лэсти: «Мэрнэ пхрала тай мэрнэ дадэско ери, савэ жувэнас пэ пхув Ханаано, авилэ мандэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Кадыла мануша — пастухуря, барярэн лэ скотос, тай андэ пэса пэстерэ гуртуря тай ся пэско хаббэ». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Кала о фараоно акхарэла тумэн тай пушэла: «Соза тумэ залэнпэ?» — ");
INSERT INTO rmyvlakh_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","тумэ трэбуй тэ пхэнэн: «Сар амарэ дада, терэ копэля тэрнэвар жы калэ десэстэ барярас лэ скотос». Тунче тумэн мэкэна тэ жувэн пэ Гошэнско пхув, пала кода со э египтянуря гряцан лэ пастухонэндар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","О Иосифо жыля каринг о фараоно тай пхэндя лэсти: — Мэрно дад тай мэрнэ пхрала пэстерэ барэ тай о цыкнэ скотоса тай саворэ хаббэса авилэ пай пхув Ханаано тай екхатар сынэ андо Гошэно. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Вов витидя панчжэн пхралэн тай авиля лэнца кай о фараоно. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","О фараоно пушля лэ пхралэндар: — Соза тумэ залэнпэ? Вонэ пхэндэ лэ фараоности: — Сар амарэ дада, терэ копэля — пастухуря. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Амэ авилям кардэ тэ жувас, пала кода со пэ пхув Ханаано бари бокх, тай терэ копэленди най кай тэ праварэн э гуртуря. Мангас, мэк терэ копэлен тэ жувас андо Гошэно. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","О фараоно пхэндя лэ Иосифости: — Тутэ авилэ теро дад тай терэ пхрала. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Э Египтоско пхув ся сын англа тутэ. Стхов теро дадэс тай терэ пхралэн тэ жувэн по майлашо тхан пэ кадыя пхув. Мэк жувэн андо Гошэно. Сар ту ганэс машкара лэндэ исы лашэ бутярнэ, стхов лэн барэдэрэнца, кай тэ дикхэн и пала мэрно ското. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","О Иосифо андя пэсти дадэс лэ Яковос англа фараоно, тай о Яково бахталисардя лэ фараонос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","О фараоно пушля лэстар: — Скати тути бэрша? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","О Яково пхэндя лэ фараоности: — Мэрнэ пхиримастерэ деса шэл триндэша бэрша. Найбарэ тай кыркэ сас э бэрша мэрнэ жувимасти, най кацавэ лунги, сар сас кай амарэ дада. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","О Яково бахталисардя лэ фараонос тай жылятар лэстар черал. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","О Иосифо стходя пэстерэ дадэс тай лэ пхралэн тэ жувэн андо Египто тай дя лэнди э майлащи пхув андо тхан Раамсесо, сар пхэндясас о фараоно. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","О Иосифо андя бут хамос лэ дадэсти, тай лэ пхралэнди, тай саворэ пэстерэ дадэстерэ еренди, дя саворэнди скати, сас манушэн андо ери. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Никай на ашыля хамос, пала кода со бокх сас бари. О Египто тай Ханаано саслэ би зорати ла бокхатар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Э мануша потинэнас пала ворзо, саво тинэнас Иосифостар. Кадя о Иосифо стидя ся э ловэ, савэ сас андо Египто тай андо Ханаано тай гаравдя лэско руп андо чер кай о фараоно. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Кала кай э мануша андо Египто тай андо Ханаано на ашылэпэ э ловэ, саворэ египтянуря авилэ каринг о Иосифо тай пхэнэн: — Дэ амэнди марно. Пала со амэнди тэ мэрас англа терэ якха? Амэндэ руп нинай. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","О Иосифо пхэндя: — Сар тумэндэ руп нинай, анэн тумарэ скотос. Мэ парувава о марно по ското. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Вонэ андэ лэ скотос каринг о Иосифо, ай вов парудя лэнди о марно пэ граст, пэ бакрэ, пэ бузня, пэ гурува, пэ гуруня тай ослуря. Ся кодыва бэрш вов парувэлас лэнди о марно по ското. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Кала кодыва бэрш прожыля, вонэ авилэ тай пхэндэ: — Амэ на ласа тэ гаравас амарэ раестар, со руп амэндэ нинай, тай амаро ското ашыля тутэ, кадя со амэндэ нисо на ашыляпэ тэ дас амарэ раести, кати амэн тай амари пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Пала со амэ тэ хасайвас англа терэ якха, амэ тай амари пхув? Тин амэн тай амари пхув, парув по марно, ай амэ аваса лэ фараоности копэля савора амаря пхуяса. Дэ амэнди сымбуря важ э пхув, соп амэ тэ жувас тай тэ на мэрас тай соп кадыя пхув тэ на авэл шушы. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Кадя о Иосифо тиндя ся пхув андо Египто важ о фараоно. Э египтянуря саворэ битиндэ пэстерэ маля, пала кода со э бокх сас бари. Кадя э пхув ашыля лэ фараоностери, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","ай лэ манушэн о Иосифо стердя копэленца, екхэ брягостар андо Египто жы каринг авэр. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Вов кати на тиндя э пхув лэ рашаенго, пала кода со вонэ савори время прилэнас котор о хамос фараоностар, ай кадлэс которос, саво дэлас лэнди о фараоно, хутилэлас лэнди, кай тэ жувэн. Акэ пала со вонэ на битиндэ пэстери пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","О Иосифо пхэндя лэ народости: — Акана, кала мэ тиндэм тумэн тай тумари пхув лэ фараоности, акэ тумэнди э сымбуря, соп тэ шон лэн андэ пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Кала барёла о ворзо, отдэн панчто котор саворэ ворзостар лэ фараоности, ай авэр штар котора авэна тумэнди важ э сымбуря пэ маля тай тэ хан тумэ тай тумарэ бэяцэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Вонэ пхэндэ: — Ту фирисардян амаро жувимос. Тэ аракхас амэ лашымос англа амарэ раести якха. Амэ аваса лэ фараоности копэленца. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Тунче о Иосифо дя законо андо Египто пала э пхув, саво сас андо зор и екхатар: екх панчто котор саворэстар, со дэл э пхув, — кода лэ фараоности. Кати най лэ рашаендеря пхуятар, сави най исин лэ фараоностери хулаимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Тунче э израильтянуря линэ тэ жувэн андо Египто, пэ пхув Гошэно. Котэ лэндэ сас чера, лэндэ аракхадёнас бут бэяцэ, та лэн терэласпэ ся майбут. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","О Яково прожудя андо Египто дэшуефта бэрша. Кадя вов прожудя шэл штардэша ефта бэрша. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Кала авиля э время лэ Израилёсти тэ мэрэл, вов акхардя пэстерэ шавэс лэ Иосифос тай пхэндя лэсти: — Сар мэ аракхлэм лашымос англа терэ якха, стхов о васт манди пэ пулпа тай дэ манди алав, со терэса манди лашымос тай чячимос. На прахосар ман андо Египто, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","ай кала жаватар каринг э мулэ папуря, виндяр ман анда Египто тай прахосар ман котэ, кай прахомэ вонэ. О Иосифо пхэндя: — Мэ стерава кадя, сар ту пхэнэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","— Солаха, — пхэндя о Яково. О Иосифо солахая лэсти. О Израилё тэлиля лэ Дэвлэсти, мэкляпэ пэ шэро лэ патоско. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Па варисаво время лэ Иосифости пхэндэ: — Теро дад насвало. О Иосифо ля пэса лэ дуен шавэн, лэ Манасияс тай лэ Ефремос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Лэ Яковости пхэндэ: — Тутэ авиля теро шаво о Иосифо. О Израилё стидя пэско зор, вазгляпэ тай бэшля по тхан. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","О Яково пхэндя лэ Иосифости: — О Дэл Саворэзорэско сыкадилясас манди андо Лузо, пэ пхув Ханаано, тай бахталисардя ман. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Вов пхэндя манди: «Мэ терава, со тутэ авэла бут бэятонэн. Мэ терава, со тутар авэна бут народуря, тай дава кадыя пхув пэ ся время терэ бэятонэнди». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Кадыла времятар терэ дуй шавэ, савэ аракхадилэ андо Египто жы кай ман на сас катэ, авэна мэрнэ. О Ефремо тай о Манасия авэна мэрнэ, сар о Рувимо тай о Симеоно. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ай э бэяцэ, савэ аракхадёна тутэ инке, авэна терэ. Вонэ лэна тэ акхарэнпэ лэ пхралэндерэ алавэнца и лэна пэстерэ котора андай лэндерэ пхуя. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Кала мэ рисайвавас анда Падано, э Рахиль муля пэ мэрни грижа андэ пхув Ханаано, кала амэ самас инке андо дром, найдур лэ Эфратастар. Мэ прахосардэм ла котэ, паша дром андо Эфрата (кода исы о Вифлеемо). ");
INSERT INTO rmyvlakh_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Кала о Израилё додикхля лэ Иосифостерэ шавэн, вов пушля: — Ко када? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","О Иосифо пхэндя пэсти дадэсти: — Када э шавэ, савэн о Дэл дя манди катэ. О Израилё пхэндя: — Подандяр лэн каринг мандэ, соп мэ тэ бахталисарав лэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Пхуримостар о Израилё вырыто дикхэлас, вов сас сар коро. О Иосифо подындярдя лэ шавэн майпашэ каринг пэско дад, ай кодыва чюмидя тай обля лэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","О Израилё пхэндя лэ Иосифости: — Мэ и на гындосаравас тэ дикхав тут упалэ, ай о Дэл дя манди тэ дикхав и терэ бэятонэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","О Иосифо одындярдя лэ бэятонэн лэ Израилёстерэ чянгэндар тай тэлиля лэсти тэлэ жы кай э пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Тунче о Иосифо стходя лэ Ефремос па чячюни риг пэстар, па лево васт лэ Изралёстар, ай лэ Манасияс па лево риг пэстар, па чячюно васт лэ Израилёстар, тай пашардя лэн каринг пэско дад. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ай о Израилё процырдя чячюно васт тай стхол лэс по шэро лэ Ефремости, вов жэ сас майтэрно, ай о лево васт вов стходя по шэро лэ Манасиясти, вов жэ сас англуно. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Тунче вов бахталисардя лэ Иосифос тай пхэндя: — О Дэл, англа Кастэ пхирэнас мэрнэ дада о Авраамо тай о Исаако, о Дэл, Саво сас пастухо мэрно ся мэрно жувимос жы кадылэ десэстэ, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","о Янголо, Саво фирисарэлас ман саворэ вырытимастар, тэ бахталисарэл кадылэ бэятонэн. Мэк жал лэндар мэрно алав тай э алава мэрнэ дадэнди, лэ Авраамоско тай лэ Исаакоско, тай мэк авэн лэндэ бут бэяцэ па ся пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Кала о Иосифо дикхля, со о дад стходя о чячё васт по шэро лэ Ефремости, кода на чялиля лэсти, тай вов ля лэ дадэско чячё васт, соп тэ стхол лэс пэ лэ Манасияско шэро. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","О Иосифо пхэндя лэсти: — Най, дадэ, акэ кадыва — англуно, стхов о чячё васт пэ лэско шэро. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ай о дад на камля тай пхэндя: — Мэ ганав, мэрно шаво, ганав. И лэстар авэла народо, тай вов авэла ашундо. Ай лэско майтэрно пхрал авэла майбаро лэстар, тай лэстерэ бэятонэндар жана бут народуря. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Тай вов бахталисардя лэн андэ кодыва дес тай пхэндя: — Израильтянуря лэна тэ бахталисарэл екх екхэс тумарэ алавэнца: «Тэ стерэл тут о Дэл тэ авэс, сар о Ефремо тай о Манасия». Кадя вов стходя лэ Ефремос англа Манасия. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","О Израилё пхэндя лэ Иосифости: — Мэ мэрав. О Дэл авэла тумэнца тай рисарэла тумэн палпалэ пэ пхув тумарэ дадэндери. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Мэ дав тути пэ екх котор пхув майбут, сар терэ пхралэндар, плаенго тхан Шэхемо, саво мэ залэм кай э аморея лэ шурянца тай лэ луконэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","О Яково акхардя пэстерэ шавэн тай пхэндя: — Стидэнпэ мандэ, тай мэ роспхэнава, со авэла тумэнца майдур. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Стидэнпэ тай ашунэн, лэ Яковостерэ шавэ, ашунэн тумарэ дадэс лэ Израилёс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Рувимо, ту сан мэрно англуно, мэрно зор, англуно шаво катар мэрно муршано зор, англуно андэ патив, англуно па зор. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ту парудёс, сар о паи, бутэр на авэса англуно, пала кода со ту сутян пэ терэ дадэско тхан тай римосардян мэрни патив. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","О Симеоно тай о Левиё сынэ пхрала: лэндерэ шуря — марди лэ холяко. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Тэ на авэл мэрно ди екхэтанэ лэндерэ гында, тэ на пашував, кай вонэ стидэнпэ. Вонэ умардэ лэ муршэн андэ пэстери холи, сар камлэ, шындэ гурувэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Дав амрая лэндери холи, пала кода со вой фартэ бари, лэндери холи, пала кода со вой фартэ зорали. Мэ розшава лэн машкара лэ Яковостерэ бэяцэ тай розшувидава лэн андо Израилё. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Иуда, терэ пхрала наисарэна тут. Теро васт авэла пэ кор терэ ворогонэнди, э шавэ терэ дадэсти лэна тэ тэлён тути. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ту сан тэрно лево, Иуда, ту рисайвэс лэ астаримаса, мэрно шаво. Сар о лево гэтосарэлпэ тэ хутилэл, тай сар э львица пашлёл пэ пхув, ко камэла тэ здаравэл лэс? ");
INSERT INTO rmyvlakh_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","О дэсто лэ тхагарэнго на жалатар лэ Иудастар, тай лэсти бэяцэ ся время лэна тэ ритярэн о тхагаримос, жыпокэ на авэл Кодва, касти тэлёна саворэ народуря. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Вов припхандэла пэстери ослица каринг э виноградно лоза, пэстерэ ослёнкос — каринг о майлашо виноградно кашт. Вов халавэла пэстери йида андо чехыри, о вуряимос пэско — андо виноградно рат. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Лэсти якха авэна маймэлахнэ лэ чехырестар, ай лэсти данда — майпарнэ лэ тхудэстар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","О Завулоно авэла тэ жувэл паша баро паи, Вов авэла о тхан, каринг авэн э баркэ. Лэстерэ пхуя процырдэнапэ жы каринг о Сидоно. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","О Исахаро — зорало осло, саво пашлёл машкара дуй пхарэ гонэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Кала вов дикхля, сар лашо лэско тхан тэ отчиёл тай сави лащи лэсти пхув, вов бандярэла пэстерэ пхикэ тэла паримос тай авэла копэли. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","О Дано лэла тэ сындосарэл пэско народо, сар екх анда лэ Израилёсти порода. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","О Дано авэла сап ригатар катар о дром, сар сап пэ стэшка. Вов дэндалэл лэ грастэс пала пэрно, кадя со пратамари пэрэла пэ пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","О РАЙ, Тутар аштярав мэ фиримос! ");
INSERT INTO rmyvlakh_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Лэ Гадос лэна тэ опчёрэн, ай вов лэла тэ чёрэл лэндар палпалэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Кай о Асиро авэла пхэрди мисяля хамата, вов лэла тэ дэл лашэ хамата, савэ хан э тхагара. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","О Нефалимо — сар лань, савя вяшадэ аврял, тай сави анэл шукарнэ бэятонэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","О Иосифо — сар виноградно лоза, сави анэл бут виноградо пхэрдо виноградо паша паи, касти веткэ ваздэнпэ упрэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Вырыцымаса хукэнас пэр лэстэ лэ лукоса, вонэ холяса мукэнас андэ лэстэ стрелуря. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ай лэско луко ашэласпэ састо. О зор лэстерэ вастэнго — о зорало Дэл лэ Яковоско, о алав лэ Пастухоско, о Баруно Плай лэ Израилёско, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","о Дэл терэ дадэско, Саво дэл зор тути. О Саворэзорэско Дэл бахталисарэла тут, дэла тути бахталимос упрал нэбостар, и бахталимос ла пхуятар, тай бахталимос лэ йилэстар тай лэ колинэндар. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Терэ дадэсти бахталима исы майбарэ, сар э бахталима лэ пуранэ плаенго, сар о мищимос, савэ дэн э пуранэ плая. Тэ авэн вонэ саворэ по шэро лэ Иосифоско, по чикат кай о тхагар машкара пэстерэ пхрала. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","О Вениамино сыно бокхало рув, тэсара вов хал, со астардя, пэ рят ростхол, со заля. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Акэ савэ дэшудуй породэ лэ Израилёсти, тай акэ, со пхэндя лэнди лэнго дад, кала бахталисардя лэн тай дэлас саворэнди пэско бахталимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","О Яково пхэндя лэнди: — Мэ жавтар каринг мэрнэ мулэ папуря. Прахон ман паша мэрнэ дада андэ пещера, сави пэ мал лэ хетеёсти лэ Эфроности, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","андэ пещера пэ мал Махпела паша Мамрэ андо Ханаано, сави о Авраамо тиндя екхтханэ ла маляса, сар прахомаско тхан кай о хетеё Эфроно. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Котэ сас прахомэ о Авраамо тай лэсти ромни э Сарра, котэ сас прахомэ о Исаако тай лэсти ромни э Ревэка, тай котэ мэ прахосардэм ла Лия. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Э мал тай э пещера, сави саслэ тиндэ кай э хетея. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Кала о Яково парашыля тэ дэл дума лэ шавэнца, вов вазгля пэсти пэрнэ по тхан, пхурдя тай жалтар каринг пэсти мулэ папуря. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","О Иосифо пэля каринг о дад, ровэлас тай чюмидэлас лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Вов пхэндя пэстерэ копэленди-састимаренди тэ намакхэн лэ дадэс бальзамоса, тай э састимаря намакхлэ о Израилёс бальзамоса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Лэндэ жыля пэ када саранда деса. Тай ефтадэша деса э египтянуря ровэнас пала лэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Кала прожылэ э деса лэ ровимасти, о Иосифо пхэндя лэ фараоностерэ раенди: — Тэ аракхав мэ лашымос англа тумарэ якха, мангэн пала мандэ лэ фараонос тай пхэнэн лэсти: ");
INSERT INTO rmyvlakh_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","«Мэрно дад ля мандар солах тай пхэндя: \"Мэ йито мэрава, прахосар ман андэ кода тхан, саво мэ ганадэм пэсти пэ пхув Ханаано\". Мангав, мэк ман тэ жав тай тэ прахой мэрнэ дадэс. А тунче кадэлэс мэ рисайвава палпалэ». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","О фараоно пхэндя: — Жа тай прахосар терэ дадэс кадя, сар ту солахаян лэсти. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","О Иосифо жыля тэ прахой пэстерэ дадэс, тай лэса жылэ саворэ рая лэ фараоности тай э барэдэра, и саворэ рая лэ Египтости, ");
INSERT INTO rmyvlakh_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","тай ся о ери лэ Иосифоско, лэсти пхрала тай ся лэсти дадэско ери. Кати лэнди бэяцэ тай о баро тай о цыкно ското ашылэпэ андо Гошэно. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Лэнца ладэнас дуе ротэнди вурдона тай пратамаря. Котэ сас бут мануша. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Вонэ авилэ каринг о Горен-Атадо, саво исы паша Иордано, ай ашылэ фартэ тэ ровэн кыркэс ясвэнца. Котэ о Иосифо ефта деса ровэлас пала дад. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Кала э ханаанея, савэ жувэн пэ кодыя пхув, дикхлэ, сар ровэн паша Горен-Атадо, вонэ пхэндэ: «Кай э египтянуря бари грижа тай барэ ровимасти деса». Акэ состар пэ кодыва тхан паша Иордано акхарэлпэ Авел-Мицраимо. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Кадя лэ Яковостерэ шавэ тердэ, со вов лэнди пхэндясас: ");
INSERT INTO rmyvlakh_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","вонэ андярдэ лэс пэ пхув Ханаано тай прахосардэ андэ пещера пэ мал Махпела, катар э Мамрэ, сави о Авраамо тиндясас кай о хетеё Эфроно екхтанэ ла маляса сар прахомаско тхан. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Кала о Иосифо прахосардя пэсти дадэс, вов рисайля палпалэ андо Египто екхтанэ лэ пхралэнца тай саворэнца, ко сас лэса тэ прахон лэстерэ дадэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Кала о Яково муля, э пхрала лэ Иосифости гындосарэнас: «Файма, о Иосифо ритярэл пармэндэ холи тай акана потинэна амэнди пала ся амаро чёрымос, саво амэ лэсти тердям?». ");
INSERT INTO rmyvlakh_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Тай вонэ бишалдэ тэ пхэнэн лэ Иосифости: ");
INSERT INTO rmyvlakh_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","— Данглал, сар тэ мэрэл, о дад мангля амэн тэ пэрэдас тути лэстерэ алава: «Мэ мангав тут, на ритяр холи пэ терэ пхрала важ лэндери дош тай пала кода чёрымос, саво вонэ тердэ». Амэ мангас, отмэк о бэзэх лэ копэленди терэ дадэстерэ Дэвлэсти. Кала о Иосифо ашундя када, вов заровля. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Лэсти пхрала авилэ, пэлинэ англа лэстэ пэ пхув тай пхэнэн: — Амэ сам терэ копэля. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","О Иосифо пхэндя: — На даран. Мэ на сым Дэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Тумэ камэнас тэ терэн манди вырыто, ай о Дэл обрисардя кода по лашымос, соп тэ стерэл кода, со исы екхатар: тэ фирий лэ бутэнди о жувимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","На даран: мэ шава сама пала тумэн тай пала тумарэ бэяцэ. Вов уля лэн тай дэлас дума лэнца лашымаса. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","О Иосифо жувэлас андо Египто саворэ пэстерэ дадэстерэ ереса. Вов прожудя шэл дэша бэрша. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Вов дикхля правнуконэн, внуконэн лэ Ефремостерэ, тай ритярэлас пэстэ пэ чянга бэятонэн лэ Махиростерэ, о шавэс лэ Манасияско. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","О Иосифо пхэндя лэ пхралэнди: — Мэ йито мэрава, ай о Дэл чячес авэла тай поможысарэла тумэнди, кай тэ виндярэл тумэн анда кадыла тхан пэ пхув, сави Вов солахаса пхэндя тэ дэл лэ Авраамости, лэ Исаакости тай лэ Яковости. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","О Иосифо припхэндя лэ Израилёстерэ шавэнди тэ солахан тай пхэндя: — О Дэл чячес авэла тай поможысарэла тумэнди, тай тунче тумэ трэбуй тэ виндярэн катар мэрнэ кокала. ");
INSERT INTO rmyvlakh_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","О Иосифо муля, кала сас лэсти шэл дэша бэрша. Лэс бальзамосардэ и стходэ андо гробо андо Египто.");
INSERT INTO rmyvlakh_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Андэ кола деса, кала хулаинас э сындомаря, андэ кодыя пхув тердяпэ бок. Екх мануш анда Вифлеемо, кай андэ Иудея, пэрэжыля андэ Моавицко пхув екхтанэ ла ромняса тай дуе шавэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Кадылэ манушэс акхарэнас Элимелехо, лэстеря ромня — Наоми, ай лэстерэ дуе шавэн — Махлоно тай Килионо. Вонэ саслэ аракхадэ андо Эфрато — анда Вифлеемо, кай исин андэ Иудея. Вонэ авилэ андэ Моавицко пхув, кай тэ пожувэн котэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","О Элимелехо, о ром ла Наомияко, муля, и вой ашыляпэ екхжэни лэ дуе шавэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Вонэ линэ пэсти ромнян моавитянкэн — екха акхарэнас Орпа, ай авря Руфь. Кала прожылэ паша э дэш бэрша, ");
INSERT INTO rmyvlakh_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","о Махлоно тай о Килионо кадя жэ мулинэ, э Наоми ашыляпэ би ромэсти и би шавэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Кала пэ Моавицки маля э Наоми угангля, со о РАЙ сгындосардя пала Пэсти мануша тай дя лэнди хамос, вой закамля тэ рисайвэл андай Моавицко пхув черэ. Ласа жылэ и лати дуй боря. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Э Наоми мэкляпэ андо дром, и лати боря жылэ ласа. Па дром андэ Иудея ");
INSERT INTO rmyvlakh_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","э Наоми пхэндя пэстерэ дуен борянди: — Рисайвэн черэ каринг тумарэ чяче йиря! Мэк о РАЙ авэл тынгуно каринг тумэндэ, сар и тумэ саслэ лашэ важ тумарэ рома, савэ мулинэ, и важ мандэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Мэк о РАЙ дэл зор кажнонати тумэндар тэ аракхэл бах андо чер аврэ ромэско. Вой чюмидэлас лэн, сар ля тэ жалтар, ай вонэ заголосусардэ, заровлэ ");
INSERT INTO rmyvlakh_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","и пхэндэ лати: — Амэ рисайвэса туса каринг терэ мануша. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Э Наоми пхэндя: — Щеялэ, рисайвэн черэ. Пала со тумэ тэ жан манца? Мэ со, анава инке шавэн, савэ авэна тумэнди ромэнца? ");
INSERT INTO rmyvlakh_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Рисайвэн черэ, мэрнэ щея, мэ сым пхури, кай тэ жав пала ром. Кала мэ и гындоя, со мандэ инке исин надежда, — сар кай андэ кадыя рят мэ тэ совав ромэса, ай тунче тэ анав шавэн, — ");
INSERT INTO rmyvlakh_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","сар тумэнди трэбуй тэ аштярэн, кала вонэ вибарёна? Трэбуй ли тумэнди тэ ашэнпэ ся кадыя время би ромэнди?! Най, мэрнэ щея. Мэрни грижа фартэ пхари важ тумэндэ, о РАЙ шутя пэр мандэ Пэсти холи. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Вонэ упалэ заголосусардэ и заровлэ. Э Орпа чюмидя ла сасуя, сар ля тэ жалтар, ай э Руфь отпхэндяпэ тэ жалтар. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Э Наоми пхэндя: — Дикх, тери ятровка рисайвэл каринг пэстерэ мануша тай каринг пэсти дэвэла. Жа и ту ласа. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Ай э Руфь пхэндя: — На манг ман тэ ашавав тут и тэ рисайвав. Мэ жава инчя, каринг жаса ту, и ашавапэ котэ, кай ту ашэсапэ, терэ мануша авэна мэрнэ мануша, теро Дэл авэла мэрно Дэвэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Кай ту мэрэса, котэ и мэ мэрава, тай котэ мэк ман и прахона. Мэк кадя тай кадя тэ марэл ман о РАЙ, кати екх о мэримос розашавэла амэн туса! ");
INSERT INTO rmyvlakh_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Э Наоми поля, кай э Руфь састэс приля андо ди тэ жал ласа, и парашыля тэ отбишалэл ла. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Вонэ жанас дужэнэ жы каринг о Вифлеемо. Кала вонэ авилэ андо Вифлеемо, андо форо тердяпэ бари дума. — Када э Наоми?! — пушэнас э жувля. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Ай э Наоми пхэндя лэнди: — На акхарэн ман Наоми, ай пхэнэн Мара, пала кода со о Майзорало тердя мэрно жувимос кэрко! ");
INSERT INTO rmyvlakh_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Кала мэ жылэмастар, мандэ сас ся, ай о РАЙ андя ман палпалэ ни соза. Пала со ж тумэ акхарэн ман Наоми? О РАЙ сындосардя ман, о Майзорало бишалдя манди грижа. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Кадя рисайля э Наоми, и ласа андай Моавицко пхув авиля лати бори, э Руфь моавитянка. Вонэ авиле андо Вифлеемо, кала авиля время тэ стидэн о ячмэно. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Кай о ром ла Наомияко сас родо, савэс акхарэнас о Боазо. Вов сас мануш ашундо, андай кодыя жэ порода, сар и о Элимелехо. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Э Руфь моавитянка пхэндя ла Наомияти: — Мэк ман, мэ жава андэ маля тэ подтидав э колосуря пала колэс манушэс, андэ кастерэ якха аракхава тынгимос. Э Наоми пхэндя: — Жа, мэрни щей. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Э Руфь жыля и ля тэ подтидэл палай жнецуря э колосуря, савэ пэрэнас пэ мал. Тердяпэ кадя, кай кадыя мал сас лэ Боазости, саво сас анда порода лэ Элимелехости. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Андэ кодыва жэ дес екхжэно о Боазо авиля инчя анда Вифлеемо. — Тэ авэл о РАЙ тумэнца! — пхэндя вов лэ жнецонэнди. — Бахтало ту сан лэ РАЕСТАР! — пхэндэ вонэ лэсти. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","О Боазо пушля кай о бутярно, саво сас барэдэр пэ жнецуря: — Кастери када щей, кадыя тэрни жувли? ");
INSERT INTO rmyvlakh_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","О бутярно, саво сас барэдэр пэ жнецуря, пхэндя: — Када моавитянка, сави авиля ла Наомияса андай Моавицко пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Вой пхэндя: «Мэк ман, мэ лава тэ подтидав палай жнецуря э колосуря машкарай снопуря». Вой авиля тэсара и ашыляпэ катэ жы кала времятэ; кати найбут отчиеля андэ вушал. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Тунче о Боазо пхэндя ла Руфяти: — Щей мэрни, ашун ман. На жа тэ подтидэс э колосуря пэ авэр мал, на жатар катар, ай ашпэ мэрнэ бутярняса. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Дикх, кай терэн бути э жнецуря, и жа палай бутярнэ. Мэ припхэндэм мэрнэ манушэнди, тэ на цыпин пэр тутэ. Сар закамэса тэ пэс, поджа и пи андай кхорэ, савэ пхэрдэ мэрнэ бутярнэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Вой пэля тэлэ, тэлиля лэсти жы ла пхуятэ и пхэндя: — Пала со мэ аракхлем тынгимос андэ терэ якха, состар ту терэс кацаво лашымос манди, мэ жэ авря пхуятар? ");
INSERT INTO rmyvlakh_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","О Боазо пхэндя лати: — Манди роспхэндэ пала ся, со ту тердян важ тери сасуи, кала муля теро ром: сар ту ашадян ла да и лэ дадэс, ашадян о тхан, кай аракхадилян, и авилян каринг э мануша, савэн ту на ганэсас данглал. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Мэк о РАЙ дэл тути бах пала кода, со ту стердян, и мэк пхэрдо дэл тути о РАЙ, О Дэл лэ Израилеско, каринг Саво ту авилян тэ гарадёс тала Лэсти пхака. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Вой пхэндя: — Тэ авав мэ и майанглэ тэ аракхав тынгимос англа терэ якха, мэрно рай. Ту улян ман, теря копэльница, пхэндян манди лашэ алава, хоть мэ жэ и най терэ копэльницэндар. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Кала авиля э время тэ хан, о Боазо пхэндя ла Руфяти: — Поджа кардэ, бол о котор марно теро андо шукло чехыри и ха. Кала вой бэшля пашай э жнецуря, вов дя лати прыжымэ ворзо. Вой халя, чялиля, и латэ инке ашыляпэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Тунче э Руфь жыля тэ подтидэл э колосуря, ай о Боазо припхэндя пэстерэ манушэнди: — Мэк вой тидэл и машкарай снопуря, на цыпин пэр латэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Ай инке отшон важ латэ э колосуря андай снопуря тай ашавэн лати, мэк подтидэл, ай тумэ на дошалярэн ла. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Жы каринг о вэчеро э Руфь подтидэлас э колосуря пэ мал. Кала жэ вой обмардя э колосуря, стидяпэ каринг йипаш гоно о ячмэно. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Вой ля лэс, андя андо форо, и лати сасуи додикхля, сар бут вой стидя. Тунче вой дорэсля кода, со ашыляпэ латэ лэ хамастар, и отдя ла Наомияти. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Э сасуи пушля латар: — Кай жэ ту тидэсас? Кай ту тердян бути адес? Тэ авэл бахтало кодыва мануш, саво шутя тут сама. Э Руфь роспхэндя ла сасуяти, кастэ пэ мал вой тердя бути. — Лэ манушэс, пэ мал кастэ мэ адес тердэм бути, акхарэн Боазо, — пхэндя вой. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","— Мэк РАЙ дэла лэсти бахт! — пхэндя э Наоми пэстя боряти. — Вов на ашадя би тынгимаско ни лэ жундэн, ни лэ мулэн! Ай тунче инке пхэндя: — Кадыва мануш — амаро пашэ родо, во екх амарэ фиримарэндар. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Э Руфь моавитянка пхэндя: — Вов жэ пхэндя манди: «Ашпэ екхтанэ мэрнэ бутярнэнца, жы кай вонэ на злэна ся мэрно ворзо». ");
INSERT INTO rmyvlakh_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Э Наоми пхэндя ла Руфяти, пэстеря боряти: — Мэрни щей, драго, сар кай ту авэса лэстерэ бутярнянца. Тунче нико на цыпия пэр тутэ пэ авэр мал. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Э Руфь ритярдёлас екхэтанэ лэ Боазостерэ бутярнянца и подтидэлас э колосуря, жы кола времятэ, кала ся постидэ о ячмэно тай э див. Ай жувэлас вой тунче ла сасуяса. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Э Наоми пхэндя пэстеря боряти: — Мэрни щей, мэ камав тэ подродав тути лашо састо тхан. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Гэн акэ, амаро родо о Боазо, савэстэ лэ бутярнянца ту санас андэ мал, адес увэчери лэла тэ вужарэл о ячмэно по гумэно. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Ту халадю, макпэ, вурядю и жа по гумэно, ай лэ Боазости на сыкадю, жы покэ вов хала и пэла. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Роздикх, кай вов пэрэла тэ совэл, тунче поджа, розушарав лэстэ катар э пэрнэ о дияло и пэр. Вов пхэнэла тути, со тэ терэс майанглэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Э Руфь пхэндя: — Мэ стерава ся, сар ту пхэндян. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Вой жыля по гумэно и стердя ся, сар припхэндя лати э сасуи. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","О Боазо халя тай пиля, и пэля тэ совэл катар э куча лэ ворзоса. Э Руфь полокорэ поджыля, розушарадя лэстэ катар э пэрнэ о дияло и пэля. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Андэ машкар рят вов ля тэ мишкпэ, обрисайля и додикхля, со катар лэсти пэрнэ пашлёл жувли. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","— Ко ту? — пушля вов. Вой пхэндя: — Мэ э Руфь, тери копэльница, — пхэндя вой. — Лэ ман пала пэстэ, ту амаро фиримари. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Вов пхэндя лати: — Тэ дэл о РАЙ тути бахт, мэрни щей! Ту икхатар терэс майбаро лашымос колэстар, саво сас данглал: на лян тэ родэс тути тэрнэс — ни чёрэс, ни барвалэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","На дара, мэрни щей, мэ стерава ся, пала со ту ман мангэс. Андэ кадыва форо саворэ ганэн, кай ту лашы жувли. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Када чячес, мэ тумаро родо, но исин инке родо, майпашэ мандар. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Ашпэ пэ рят катэ, ай тэся, сар вов закамэла тэ авэл тумаро фиримари — драго, мэк авэл. Ай сар вов на закамэла, тунче, солахав лэ РАЕСА, када терава мэ. Сов катэ жы каринг э тэсара. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Вой сутя катар лэсти пэрнэ жы каринг э тэсара, и ущиля жы колэстэ, сар екх мануш тэ додикхэл аврэс. О Боазо гындояс: «Мэк нико на ганэн, кай жувли авилясас по гумэно». ");
INSERT INTO rmyvlakh_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Вов пхэндя лати: — Дэ теро косно и подритяр лэс. Э Руфь ростэлисардя о косно, и о Боазо шутя андо косно баро гоно о ячмэно. Вов тходя лати пэ пхикэ о ячмэно и жылятар андо форо. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Кала э Руфь авиля каринг э сасуи, э Наоми пушля латар: — Сар ту, мэрни щей? Э Руфь роспхэндя пала кода ся, со тердя лати о Боазо. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","И инке пхэндя: — Вов дя манди баро гоно ячмэно и пхэндя: «На рисав каринг тери сасуи шушэ вастэнца». ");
INSERT INTO rmyvlakh_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Э Наоми пхэндя: — Акана, мэрни щей, подаштяр, йито уганэса, соза э дила стерэлапэ. Кадыва мануш на улэлапэ, покэ адес жэ на стерэла сяй дила. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Ай о Боазо жыля и бэшля катар лэ форости вудара. И дикхэл: жал кодыва родо, пала кастэ вов пхэнэлас. О Боазо акхардя лэс и пхэндя: — Поджа кардэ, амал. Прибэш. Кодыва поджыля и бэшля. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Андэ форо о Боазо акхардя дэшэ барэдэра манушэн и пхэндя лэнди: — Бэшэн катэ. Вонэ бэшлэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","О Боазо пхэндя колэ родости: — Дума жал палай мал лэ Элимелехости, амарэ родости. Э Наоми рисайля андай Моавицко пхув и битинэл э мал. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Мэ погиндосадэм, кай трэбуй тэ пхэнав тути пала када. Ту трэбуй тэ витинэс кадыя мал англа саворэ, ко бэшэл, и англа э барэдэра амарэн манушэн. Камэс, витин, ай на камэс, пхэн манди, кай мэ тэ ганав. О чячё витинимос ашэлпэ пала тутэ, ту англуно, ай мэ тунче пала тутэ. — Мэ витинава, — пхэндя кодыва. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","О Боазо пхэндя: — Сар кай ту тинэса э мал кай э Наоми, ту кадя жэ трэбуй тэ лэс пала тутэ ла Руфя моавитянка, ла пхивля, соб латерэ бэяцэ тэ авэн хулая пэ лэско хаббэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Тунче кодыва пхэндя: — Най, мэ на витинав кадыя мал. Мэ дарав, со кадя римосарава мэрно хаббэ. Витин фэдэр ту, мэ на витинав. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","(Андэ пхурани время кай э израильтянуря сас обычаё, кала пэрэдэнас по чячё витинимос, соб тэ састярэн о допхэнимос, о мануш излэлас пар пэстэ э сандали и отдэлас аврэсти. Кадя э израильтянуря састярнас о допхэнимос.) ");
INSERT INTO rmyvlakh_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","— Тин ту, — пхэндя о родо лэ Боазости и изля о сандали. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","О Боазо пхэндя лэ барэдэрэнди тай саворэнди, ко бэшэлас: — Адес тумэ дикхэн и шунэн, икхатар мэ тинав кай э Наоми ся, со сас кай о Элимелехо, Килионо и кай о Махлоно. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Кадя жэ и ла Руфя моавитянка, ла пхивля лэ Махлоностеря, мэ лав пала мандэ, кай э бэяцэ лэ Махлоности тэ авэн хулая пэ лэско хаббэ, и кай тэ на пэрэшындёл лэско родо анда амаро форо. Адес тумэ екхжэнэ дикхэн и шунэн када! ");
INSERT INTO rmyvlakh_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Тунче саворэ, ко сас катар э вудара тай э барэдэра пхэндэ: — Кадя амэ дикхас и шунас! Мэк о РАЙ дэла кала жувляти, сави зажал андэ теро чер, бут бэяцэн. Сар Вов дя бут бэяцэн ла Рахиляти тай ла Лияти, савэндар аракхадилэ ся э израильски мануша! Зорало ав андо Эфрато тай гангло андо Вифлеемо! ");
INSERT INTO rmyvlakh_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Мэк черэз э терэ бэяцэн, савэн о РАЙ дэла тути кала тэрня жувлятар, тери порода авэла, сар э порода кай о Парэцо, савэс э Тамар аракхадя лэ Иудасти! ");
INSERT INTO rmyvlakh_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","О Боазо ля пала пэстэ ла Руфя. Вов сутя ласа, ай о РАЙ дя лати тэ авэл пхари, и вой андя шаворэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Э жувля пхэнэнас ла Наомияти: — Бахтало о РАЙ, Саво дя тути фиримарес! Тэ ашарэлпэ вов машкара израильтянуря! ");
INSERT INTO rmyvlakh_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Вов рисарэла тути э лош тай подритярэла тут андэ пхуранэ бэрша! Э бори тери, сави камэл тут, андя лэс! Вой важ тутэ фэдэр ефта шавэндар. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Э Наоми пхиравэлас лэ бэятос пэ васт и дикхэлас пала лэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Ай э жувля, савэ жувэнас котэ, пхэнэнас: — Шаворо аракхадиляпэ кай э Наоми. Вонэ динэ лэсти о алав Овидо. Вов ашыля дад лэ Иесеёско, саво сас о дад лэ Давидоско. ");
INSERT INTO rmyvlakh_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Акэ э порода лэ Фарецости: о Фарецо ашыля дадэса лэ Хецроноско, ");
INSERT INTO rmyvlakh_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","о Хецроно ашыля дадэса лэ Рамоско, о Рамо ашыля дадэса лэ Аминадавоско, ");
INSERT INTO rmyvlakh_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","о Аминадаво ашыля дадэса лэ Нахшоноско, о Нахшоно ашыля дадэса лэ Салмоноско, ");
INSERT INTO rmyvlakh_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","о Салмоно ашыля дадэса лэ Боазоско, о Боазо ашыля дадэса лэ Овидоско, ");
INSERT INTO rmyvlakh_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","о Овидо ашыля дадэса лэ Иесеёско, о Иесеё ашыля дадэса лэ Давидоско.");
INSERT INTO rmyvlakh_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Карик о Иона, лэ Амитаёско шаво, сас о алав лэ РАЕСТАР: ");
INSERT INTO rmyvlakh_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","— Ущи, жа андо баро форо Ниневия тай роспхэн котэ о алав. Мандэ дожыля дума пала лэндерэ холятерэ дилэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Ай о Иона тидяпэ тэ нашэлтар лэ РАЕСТАР андо Таршышо. Вов авиля андэ Яфа, тай аракхля э барка, сави жаластар андо Таршышо. Вов потиндя важ о дром, вазгляпэ пэ барка и лаглятар лэнца па паи, соп тэ нашэлтар лэ РАЕСТАР андо Таршышо. ");
INSERT INTO rmyvlakh_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Тунче о РАЙ бишалдя холяти балвал по баро паи. Вагляпэ кацаво зорало штормо, со э барка сас гата тэ розмардёлпэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Саворэ морякуря пэрэдарайлэ, вонэ линэ тэ мангэнпэ кажно пэстерэ дэвлэсти. Вонэ пошутэ пай барка ся о паримос андо баро паи, соп тэ авэл майвушэро. Ай англа када о Иона упрал змэкляпэ тэлэ, пэля и састэс засутя. ");
INSERT INTO rmyvlakh_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","О барэдэр ла баркако авиля каринг о Иона и пхэндя: — Со ж ту совэс? Ущи, акхар терэ Дэвлэс! Сар Вов шола пэр амэндэ само тай на дэла амэнди тэ хасайвас. ");
INSERT INTO rmyvlakh_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Тунче э морякуря пхэндэ екх екхэсти: — Шам э врэжа, кай тэ ганас, пала кастэ пар амэндэ авиля кадыя бида. Вонэ шутэ э врэжа, и вой пэля по Иона. ");
INSERT INTO rmyvlakh_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Тунче э морякуря пхэндэ лэсти: — Пхэн, пала кастэ пар амэндэ авиля кадыя бида? Соза залэспэ? Катар ту авилян? Савя пхувятар? Тай савэ манушэндар? ");
INSERT INTO rmyvlakh_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","О Иона пхэндя: — Мэ сым евреё, тэлював лэ РАЕСТИ, о Дэл лэ нэбоско, Саво стердя о баро паи тай э пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","О Иона роспхэндя лэнди, кай вов нашэлтар лэ РАЕСТАР. Калэ алавэндар вонэ фартэ пэрэдарайлэ и пхэндэ лэсти: — Со ж ту када тердян? ");
INSERT INTO rmyvlakh_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Ай о баро паи ся ваздэласпэ майфартэ и майфартэ. Тунче вонэ пушлэ лэстар: — Со амэ тэ терас туса, кай о баро паи тэ улэлпэ? Вов пхэндя лэнди: ");
INSERT INTO rmyvlakh_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","— Ваздэн ман и шон андо баро паи, тунче вов улэлапэ. Мэ ганав, со када баро штормо авиля пэр тумэндэ черэз мандэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Э морякуря линэ анда ся зор тэ примардён каринг э риг ла пхувяти. Ай пэ када на хутилэлас лэндэ зор, пала кода со о штормо фартэ ваздэласпэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Тунче вонэ линэ тэ мангэнпэ лэ РАЕСТИ: — РАЙ, на мар амэн пала кода, со амэ умараса калэ манушэс. На стов пар амэндэ э дош, кай умарас найдошалэ манушэс. Ту РАЙ, тай Ту терэс кода, со Ту камэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Вонэ линэ тай шон лэ Ионас пай барка, и о холяко баро паи уляпэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Бари дар авиля лэндэ англа РАЙ, вонэ андэ жэртва и динэ РАЕСТИ алав. ");
INSERT INTO rmyvlakh_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","О РАЙ бишалдя барэ мащес, тэ накавэл лэ Ионас. О Иона сас трин дес и трин ратя андо йило лэ мащеско. ");
INSERT INTO rmyvlakh_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","Анда йило лэ мащестар о Иона ля тэ мангэлпэ лэ РАЕСТИ, пэстерэ Дэвлэсти. ");
INSERT INTO rmyvlakh_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","О Иона пхэндя: — Пала мэрни бида акхаравас мэ лэ РАЕС, и Вов ашундя ман. Анда машкар лэ мулэнго тхагаримос цыпияс, и Ту ашундян мэрно гласо. ");
INSERT INTO rmyvlakh_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Шувидян ман Ту само тэлэ, андо ди лэ барэ паеско. О паи заболдя ман, понадэ мандэ прожылэ саворэ Терэ волнэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Гындояспэ манди: «Витрадян ман Терэ якхэндар. Но най, мэ саекх дикхава Теро свынто Храмо». ");
INSERT INTO rmyvlakh_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","О паи ушарадя ман, дур сым андэ барэ пая, тай э чяр лэ паести заболдя манди о шэро. ");
INSERT INTO rmyvlakh_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Само тэлэ, катар барён э плая, ужылэмтар мэ, о засовуря ла пхувяти запхандадилэ пала мандэ пэ ся время. Ай Ту РАЙ, мэрно Дэл, вилян ман жундэс андай могыла! ");
INSERT INTO rmyvlakh_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Кала мэрно жувимос мудардёлас андэр мандэ, мэ гындояс пала РАЙ, тай мэрно мангимос дожыля каринг Тутэ, андэ Теро свынто Храмо. ");
INSERT INTO rmyvlakh_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Кола, ко патял лэ хохавнэ дэвлэнди, хасардэ о тынгимос, саво саслэ тэ лэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Ай мэрни жэртва Тути — мэрнэ диля, савэнца ашарав тут. Мэ ся стерава, андэ со солахаем. О РАЙ анэл фиримос! ");
INSERT INTO rmyvlakh_vpl VALUES ("JH2_11","033_2_11","JON","2","11","11","И припхэндя о РАЙ лэ мащести, тэ вишункардэл андар пэстэ лэ Ионас пэ пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","И сас о алав лэ РАЕСТАР каринг о Иона до дуйто: ");
INSERT INTO rmyvlakh_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","— Ущи, жа андо баро форо Ниневия тай роспхэн котэ о алав, саво Мэ дэм тути. ");
INSERT INTO rmyvlakh_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","О Иона жыля па дром андэ Ниневия кадя, сар припхэндя лэсти о РАЙ. Э Ниневия сас баро форо кай о Дэл, соп тэ пэрэжал лэс анда екх риг андэ авэр, сас трэбуй пэ када трин дес. ");
INSERT INTO rmyvlakh_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","О Иона зажыля андо форо и ся о дес пхирэлас и роспхэнэлас лэ манушэнди: «Черэз э саранда деса о форо Ниневия авэла росшуто». ");
INSERT INTO rmyvlakh_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Э мануша андэ Ниневия патяе лэ Дэвлэстерэ алавэнди. И саворэ вонэ, лэ цыкнэндар жы каринг э барэ, линэ нисо тэ на хан и тэ пэн, тай саворэ линэ пэр пэстэ лэ гонэстири йида. ");
INSERT INTO rmyvlakh_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Кала дожыля о алав каринг о тхагар ла Ниневияко, вов ущиля па пэско троно, изля пар пэстэ э тхагарицко йида, ля пэр пэстэ лэ гонэстири йида тай бэшля по прахо. ");
INSERT INTO rmyvlakh_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Тунче о тхагар искрисардя лил и розбишалдя лэс па ся форо Ниневия. — Припхэнэн о тхагар и лэстерэ барэдэра: Мэк э мануша нисо на хан и на пэн. Кадя жэ и гуруня, бакрэ тай э бузнэ, тэ на пхирэн пай маля, тэ на хан и тэ на пэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Саворэ мануша тай сако хулаимос трэбуй тэ лэн пэр пэстэ лэ гонэстири йида. Мэк кажно анда ся зор мангэл лэ Дэвлэс. Мэк кажно обринпэ пэстерэ найлашэ дромэндар тай тэ на терэн холятерэ дила. ");
INSERT INTO rmyvlakh_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Ко ганэн? Можэ, о Дэл улэла Пэсти холи, тай потынгоя амэн, тай на домэкэла тэ похасайвас. ");
INSERT INTO rmyvlakh_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Сар о Дэл дикхля, кай вонэ парудилэ тай отжылэ пай пэсти бэзэхалэ дрома, тунче тынгосардя лэн и на бишалдя кодыя бида, сави пхэндя тэ бишалэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Ай о Иона холяйля, и лэсти када фартэ на чялиля. ");
INSERT INTO rmyvlakh_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Вов ля тэ мангэлпэ лэ РАЕСТИ: — О РАЙ, най пала када ли мэ пхэнавас, кала сымас инке черэ? Важ када мэ и нашлэмастар андо Таршышо. Мэ ганав, кай Ту Дэл тынгуно и лашо, Ту бут тэрпис, най йито холяйвэс и барвало сан по камлимос тай на камэс тэ бишалэл э бида. ");
INSERT INTO rmyvlakh_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","РАЙ, ай акана залэ мандар мэрно жувимос. Фэдэр мэ тэ мэрав, сар тэ жував. ");
INSERT INTO rmyvlakh_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","О РАЙ пхэндя лэсти: — Трэбуй ли тути кадя тэ холяйвэс? ");
INSERT INTO rmyvlakh_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","О Иона вижыля анда форо и бэшля каринг о востоко лэ форостар. Вов стердя пэсти катуна, бэшля андэ вушал и ля таштярэл, со терлапэ лэ фороса. ");
INSERT INTO rmyvlakh_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","О РАЙ Дэл стердя кадя, кай вибариля бари чяр, сави вазгляпэ понадэ Иона, соп э вушал понадэ лэско шэро тэ улэл лэсти холи. Вов сас фартэ лошало кала чяряти. ");
INSERT INTO rmyvlakh_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Ай каринг э тэсара пэ авэр дес о Дэл бишалдя лэ чермэс. О чермо потхаля э бари чяр, и вой зашутиля. ");
INSERT INTO rmyvlakh_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Кала ущиля о кхам, о Дэл бишалдя пхабарди восточно балвал, тай о кхам ля тэ пхабарэл о шэро лэ Ионаско кадя, со вов замэгнисайля. Вов закамля тэ мэрэл и пхэндя: — Фэдэр мэ тэ мэрав, сар тэ жував. ");
INSERT INTO rmyvlakh_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Ай о Дэл пхэндя лэ Ионасти: — Трэбуй ли тути кадя тэ холяйвэс палай бари чяр? — Трэбуй, — пхэндя о Иона, — най кати тэ холяйвав, ай и тэ мэрав. ");
INSERT INTO rmyvlakh_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","О РАЙ пхэндя: — Тути тынг э чяр, пала сави ту ни на дикхлян, ни на барярдян. Вой важ екх рят вибариля, тай важ екх рят и хасайля. ");
INSERT INTO rmyvlakh_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Манди ли тэ на тынгой о баро форо Ниневия, кай бут ското тай майбут, сар шэл биш пхангля мануша, савэ на полэн, кай о лашымос, ай кай о вырыто?");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Пативало Феофило, бут мануша линэ тэ стидэн и тэ запистросарэн роспхэнимос пала кода, со сас. Када роспхэндэ амэнди мануша, савэ майанглал дикхэнас вся пэстирэ якхэнца тай ашыле бутярнэ Лавэстирэ. Важ кода мэ тховдэм андо води мишто вся тэ ужанав, со сас майанглал, и екх пала авэр тэ запистросарав тути. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Тунчи ту полэса: кода, со ту ашундян, исин чячимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Андэ деса, кала андэ Иудея сас тхагараса Иродо, сас мануш, савэс акхарэнас Захария, андай рашая Авиястирэ стидимастар, и лэстэ сас ромни андав родо Аароноско, акхарэнас ла Елизавета. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Онэ лэдуй сас жужэ англав Дэл, жувэнас пав всаворо запхэнимос Раеско бидошако. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Лэндэ на сас бэяцэн, колэстар со Елизавета сас бибэяцэндири, и онэ лэдуй сас андэ бэрша пхурэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Екхвар авиля вряма рашаенди лэстирэ стидимастар тэ терэл бути англав Дэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Сар сас прилито машкар рашая, онэ шутэ жребиё, и прижыляпэ Захариясти тэ зажал андо храмо лэ Раеско тэ пхабарэл ладано. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Андэ кодья ж вряма, кала вов пхабарэлас ладано, всаворэ мануша мангэнаспэ Дэвлэс аври. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Тунчи вов удикхля ангелос Раестирэс, саво тэрдёлас пай право риг лэ жэртвеникоско, кай пхаболас о ладано. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Захария сар удикхля лэс, бари дар авиля пэр лэстэ, и вов на жангля, со тэ терэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ангело пхэндя лэсти: — На дара, Захария! Ашундя о Дэл мангимос тиро. И ромни тири, Елизавета, бэянэла тути шаворэс, и акхарэса лэс Иоано. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Авэла тути баро радомос, и бут мануша авэна тэ радонпэ, кай вов бэяндиля. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Вов авэла баро англав Рай, на авэла тэ пэл ни мол, ни матимаско пимо и пхэрдёла Свэнто Духоса майанглал, сар вов бэяндёла. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Бутэн Израилёстирэ шавэн вов рисарэла палпалэ кав лэнго Рай о Дэл ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","и авэла тэ жал англав Лэстэ андо духо и зор Илиястири, кай тэ рисарэл и водя лэ дадэндирэ кай лэнди бэяцэ, и найкандунэн кав гындо чячимастирэн манушэн, кай тэ гытосарэ манушэн, кала авэла о Рай Дэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Захария пхэндя ангелости: — Сар мэ ужанава када? Мэ пхуро, тай ромни мэрни найтэрни. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ангело пхэндя лэсти: — Мэ Гавриило, саво тэрдював англав Дэл, бишалдо тэ дав дума туса и тэ пхэнав тути кадва радосаво лав. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Акэ, ту авэса муто и на дэса дума кай кодва дес, кала када вся авэла, важ кода со ту на патяйлян мэрнэ лавэнди, савэ терэнапэ андэ пэсти вряма. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Андэ кадья вряма мануша ажутярэнас Захарияс и дивонаспэ, состар вов бут вряма на выжалас андав храмо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Кала Захария выжыля котар, вов на дэлас дума, и мануша полинэ, со вов андо храмо варисо дикхля. Вов сикавэлас вастэнца лэнди и ашэласпэ муто. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","А сар прожыле кола деса, кала вов терэлас рашаендири бути, тунчи рисайля пэстэ черэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Прожыля вряма, Елизавета, и ромни лэстири, ашыля пхари. Панч шон вой гарадёлас манушэндар и пхэнэлас: ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","— Акэ, со стердя манди Рай Дэл андэ кадэла деса, кала Вов обрисардя мандэ пэстирэ якха, кай тэ злэл пар мандэ о лажавимос мэрно англай мануша! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Кала Елизавета сас шов шон пхари, о Дэл бишалдя ангелос Гавриилос андо форо галилейско, саво акхарэлпэ Назарето, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","кай щиёры, савя акхарэнас Мария. Вой дя лав тэ жал палав ром палав Иосифо, саво сас андав родо лэ Давидоско. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ангело авиля латэ и пхэндя: — Тэ авэс бахтали! Тути дяпэ мищимос! О Рай Дэл туса! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Мария на жангля, со тэ пхэнэл, и гындолас, важ со вов кади пхэндя. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ангело пхэндя: — На дара, Мария! Ту аракхлян мищимос кав Дэл! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Акэ, ту авэса пхари, и бэянэса Шавэс, и акхарэса Лэс Исусо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Вов авэла баро, и Лэс акхарэна Шаво Майбарэско. Рай Дэл дэла Лэсти троно Давидоско, лэ прапапос Лэстирэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Вов по вако авэла Тхагараса англав родо Иаковоско, и тхагаримос Лэско никала на пэрэашэла тэ авэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Мария пхэндя ангелости: — Сар када авэла? Мэ инке на сымас палав ром! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ангело пхэндя лати: — Свэнто Духо сжала пэр тутэ, и зор Майбарэско ушарэла тут, и свэнто Бэято, Саво тутэ бэяндёла, акхарэлапэ Шаво Дэвлэско. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Акэ Елизавета андав родо тиро, палай сави пхэнэнас, со латэ на авэна бэяцэ, подикх, вой шовто шон пхари. Андо пхуримос лако бэяндёла латэ шаво. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","О Дэл терэла вся, со Вов закамэла. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Пхэндя Мария: — Мэ бутярни Рае Дэвлэстири. Мэк авэла манди, сар ту пхэндян. И ангело отжыля латар. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Андэ кадэла деса Мария вщиля и сыго жыля андо форо, саво сас андо плаенго тхан Иудеяко. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Вой зажыля андо чер кав Захария и пхэндя ла Елизаветати: — Тэ авэс бахтали! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Кала Елизавета ашундя лава Мариятирэ, подхукля о бэято андэ Елизавета, и пхэрдиля вой Свэнто Духоса. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Вой зацыписайля фартэ гласоса и пхэндя: — Тут авэна тэ лашарэн майбут аврэ жувляндар! И лашарэна тирэ Бэятос, Савэс ту пхиравэс! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Сости манди када, со мандэ авиля дэй мэрнэ Рае Дэвлэстири? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Кала мэ ашундэм, сар ту пхэндян манди, тэ авав бахтали, подхукля андэр мандэ о бэято радомостар. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Бахтали кодья, сави патяйля, со терэлапэ кода, со пхэндя лати Рай Дэл! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","И пхэндя Мария: — Лашарэл о води мэрно лэ Рае Дэвлэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","И радосайля о духо мэрно палав Дэл, Фэрисаримари мэрно. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Вов удикхля, со мэ цэкни бутярни Лэстири. Акала вряматар всаворэ родоря авэна тэ акхарэн ман бахталяса. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Со зорало Дэл тердя манди баро рындо, и свэнто алав Лэско! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Тангимос Лэско андэ всаворэ родоря, ко пативаса дарал Лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Вов тердя барэ рындоря Пэстирэ зоралэ вастэса, рострадя колэн, савэ пхутярдэ годяса и водеса, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Сшута раен пай лэндирэ троноря и вазгля упрэ цэкнэн машкар мануша. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Бокхалэн пхэрдярдя мищимаса и барвалэн отмэкля нисоса. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Вов сэрэсардя, со пхэнэлас лэ дадэнди, лэ Авраамости и лэстирэ бэяцэнди, тэ авэл тангимаско по вако, и подритярдя Израилёс, Пэстирэс бутярнэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Мария сас лэ Елизаветаса варикай трин шон и рисайля андо пэско чер. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Кала авиля вряма, Елизавета бэяндя шаворэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ашундэ мануша, савэ жувэнас паша лэндэ, и о родо лако, со дя Рай Дэл о тангимос Пэско лати, и радонаспэ ласа. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","По охто дес онэ авиле тэ обшынэн лэ бэятос и камле тэ акхарэн лэс, сар акхарэн лэсти дадэс — Захария, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","а лэстири дэй пхэндя: — Нат, акхараса лэс Иоаноса. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","И пхэндэ лати: — Никас на сас андо родо тиро, савэс акхарэнас кадя. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","И пушэнас, сикавэнас лэ вастэнца кав лэско дад, сар вов камэл тэ акхарэл лэ бэятос. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Захария мангля каштуни сандёры и пистросардя лэнди: «Алав лэско — Иоано». Всаворэ дивосайле. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Андэ кодья ж вряма отпхэрнэпэ лэстирэ ушта, и вов ля тэ дэл дума и тэ лашарэл Дэвлэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","И сас дар пэ всаворэ, ко жувэлас паша лэндэ, и роспхэнэнас пала када пав всаворэ плаендирэ тхана Иудеятирэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Всаворэ, ко ашундя када, тховдэ андо води пэско и пхэнэнас: — Каса авэла када бэято? И о васт лэ Рае Дэвлэско сас лэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","О Захария, дад лэско, пхэрдиля Свэнто Духоса и пхэндя лав Дэвлэстар: ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","— Бахтало исин Рай, Дэл Израилёско, со авиля кай пэстирэ мануша и вытиндя лэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Бишалдя амэнди зоралэс Фэрисаримарес андав чер и родо Давидоско, бутярнэс Пэстирэс, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","сар бут бэрша палпалэ пхэндя уштэнца свэнтонэ пророкэнца Пэстирэнца, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","со фэрисарэла амэн лэ вражымарендар амарэндар и вастэндар кодэлэндар, савэ амэн на камэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Вов тангосардя амарэ дадэн и сэрэсардя Пэско свэнто завето, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","сар Вов солахадя амарэ дадэсти Авраамости, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","со Вов фэрисарэла амэн лэ вастэндар амарэ вражымарендар, кай амэ бидарако тэ терас бути Лэсти, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","тэ жувас англав Лэстэ свэнто и жужо всаворо пэско жувимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","И тут, бэято, акхарэна пророкоса Майбарэстирэса, колэсти со ту авэса тэ жас англав Рай Дэл, кай тэ гытос о дром Лэсти, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","тэ роспхэнэ Пэстирэ манушэнди, со фэрисаримос дэлпэ, кала авэна эртисардэ лэндирэ бэзэха. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Амаро Дэл камэл и тангол, и Вов бишалэла амэнди дэнзорутно удуд упрал. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Вов дэла удуд колэнди, савэ жувэн андэ калимос, и миримос пхирэл паша лэндэ, и тэ тховэл пэрнэ амарэ по дром кав миро! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Бэято барёлас и терэласпэ майзор духоса, и жувэлас андэ мал жы кола вряматэ, кала сикавэла пэс манушэнди Израилёстирэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Андэ кодья вряма выжыля припхэнимос императоростар Августостар тэ пэрэбинэн и тэ запистросарэн манушэн пай всавори римско пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Када сас англуно запистросаримос манушэн, кала андэ Сирия сас рай Квириниё. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","И всаворэ жыле тэ запистросарэнпэ андэ пэстирэ фороря. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Иосифо жыля андай Галилея, андав форо Назарето тэ запистросарэлпэ андэ Иудея, андо форо Давидоско Вифлеемо, колэсти со вов сас андав чер и родо лэ Давидоско. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Вов жыля тэ запистролпэ екхэтанэ ла Марияса, сави дя лав тэ жал палав ром палав Иосифо. Андэ кодья вряма вой сас пхари и дожутярэлас лэ Бэятос. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Кала онэ сас андо Вифлеемо, авиля и вряма тэ бэяндёл о Бэято. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Вой бэяндя пэстирэс англатунэс Шавэс и андэ пхарнэ тховдя Лэс андэ пусын, колэстар со на сас лэнди тхан андо чер. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Надур котар андэ мал сас пасымаря, савэ дикхэнас и рят палай бакрэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Акэ, лэндэ авиля ангело Рае Дэвлэско, и баро удуд сар слава Рае Дэвлэстар авиля пэр лэндэ. Онэ фартэ дарайле. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Нэ ангело пхэндя лэнди: — На даран! Мэ андэм тумэнди радосаво лав, саво авэла всаворэ манушэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Адес андо форо Давидоско бэяндиля тумаро Фэрисаримари, Саво исин Христосо Рай. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","И акэ тумэнди шпэра: тумэ аракхэна лэ Бэятос андэ пхарнэ, саво пашлёла андэ пусын. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Акэ авиле лэ ангелоса фартэ бут ангелоря пав болыбэн, савэ лашарэнас лэ Дэвлэс: ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","— Слава лэ Дэвлэсти упрэ по болыбэн! И пэ пхув миро манушэнди, савэн Вов тангосардя! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Кала ангелоря ужыле лэндар по болыбэн, пасымаря пхэндэ екх екхэсти: — Авэн андо Вифлеемо, дикхаса, со тэрдиля котэ, пала со амэнди пхэндя о Рай Дэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Сыго жыле и аракхле лэ Иосифос лэ Марияса и лэ Бэятоса, саво пашлёлас андэ пусын. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Кала онэ удикхле Лэс, тунчи роспхэндэ лэнди вся, со ашундэ палав кадва Бэято. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Всаворэ, ко ашундя, дивосайле колэсти, со роспхэндэ лэнди пасымаря. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","А Мария гаравэлас кала лава андо пэско води и гындолас пала лэндэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Пасымаря рисайле, лашарэнас и фалисарэнас лэ Дэвлэс пала кода, со дикхле и со лэнди сас пхэндо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","По охто дес, кала авиля вряма тэ обшынэ лэ Бэятос, акхардэ Лэс «Исусо», алавэса, саво ангело дя Лэсти, инке сар Мария на сас пхари. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Кала прожыля вряма жужарэмасти пав Законо Моисеёско, Мария и Иосифо андэ Лэс андо Иерусалимо, кай тэ свэнтон Лэс лэ Рае Дэвлэсти. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Колэстар со запистросардо андо Законо лэ Рае Дэвлэско, кай англуно бэяндо бэято муршоро трэбуй сас тэ свэнтолпэ лэ Рае Дэвлэсти. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Лэнди трэбуй сас тэ анэ жэртва пав Законо лэ Рае Дэвлэско, дуен бакрэн или дуен цэкнорэн голубонэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Андо Иерусалимо андэ кадья вряма сас мануш, савэс акхарэнас Симеоно. Вов сас жужо дэвлэкуно мануш, ажутярэлас, кала о Дэл поможысарэла Израилёсти, и Свэнто Духо сас пэр лэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Свэнто Духо пхэндя лэсти, со вов на удикхэла миримос, жы кала на дикхэла лэ Христос Раес Дэвлэстирэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Духо андярдя Симеонос андо храмо. Кала дад и дэй андэ Бэятос Исусос тэ терэ пэр Лэстэ кода, со трэбуй сас пав Законо, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Симеоно ля Лэс пэ васт, лашардя Дэвлэс и пхэндя: ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","— Икхатар отмэкэс Ту, Хулаё Дэвла, пэстирэ бутярнэс лэ мироса, пав лав Тиро. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Колэсти со мэрнэ якха дикхле фэрисаримос Тиро, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","саво Ту гытосардян англай якха всаворэ манушэндирэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Вов — удуд важ всаворэ мануш и слава народости Тирэсти Израилёсти! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","О дад и дэй дивосайле, со сас пхэндо пала Лэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","И бахталисардя лавэса лэн Симеоно, пхэндя Марияти, дати Лэстиряти: — Акэ пашлёл Кодва, пала Саво бут мануша андо Израилё пэрэна и бут ваздёна. Вов авэла шпэраса, сави бут мануша на прилэна. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Тунчи отпхэрнавэлапэ кода, со онэ гындонас андэ водя. И тути ежэяти прожала шури андо води. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Котэ сас пхури манушни, савяти сас охтодэш тай штар бэрш, и сави пхэнэлас лав Дэвлэстар. Ла акхарэнас Анна, щей Фануилостири андав родо Асиростиро. Вой выжыля палав ром тэрноря щиёраса и прожудя пэсти ромэса эхта бэрш, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","нэ тунчи ашыля пхивли и прожудя ежэи. Дес и рят вой терэлас бути важ о Дэл, сас андо посто и мангимос, и на отжалас лэ храмостар. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Вой андэ кодья вряма пашыля колэндэ, ко андя лэ Бэятос, ашыля тэ лашарэл лэ Дэвлэс и роспхэнэлас пала Бэято всаворэнди, ко ажутярэлас фэрисаримос важ Иерусалимо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Кала онэ вся тердэ пав Законо Рае Дэвлэско, онэ рисайле андэ Галилея, андо форо пэско, Назарето. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Бэято барёлас зораса тай годяса, и мищимос лэ Дэвлэско сас пэр Лэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Кажно бэрш, по свэнко Патрадятиро, о дад и дэй лэ Исусостирэ пхирэнас андо Иерусалимо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Кала Лэсти сас дэшудуй бэрш, онэ, сар сас прилито, жыле по свэнко. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Кала прожыле деса свэнкостирэ, онэ жыле черэ, ай шаворо Исусо ашыляпэ андо Иерусалимо. О дад и дэй када на жанэнас, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","онэ гындонас, со Вов жал аврэнца пав дром. Сар прожыля дес, онэ линэ тэ родэ Лэс машкар пэско родо и машкар кола, савэн онэ жанэнас. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Кала на аракхле Лэс, жыле палпалэ андо Иерусалимо тэ родэн Лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Прожыля трин дес. Аракхле Исусос андо храмо. Вов бэшэлас машкар сытяримаря, ашунэлас и пушэлас лэндар. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Всаворэ, савэ ашунэнас Лэс, дивосайле Лэстиря годяти и лавэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Кала дад и дэй дикхле Лэс, онэ кадя ж дивосайле. И дэй пхэндя Лэсти: — Бэято! Со ту тердян амэнца? Акэ, дад Тиро и мэ грыжаса родасас Тут. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Вов пхэндя лэнди: — Пэр со тумэнди тэ родэ Ман? Сар тумэ на жанэнас, со Манди трэбуй тэ авав котэ, со исин Мэрнэ Дадэско? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Но онэ на полинэ, со Вов пхэндя лэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Вов жыля лэнца, рисайля андо Назарето и кандэлас лэн. Лэстири дэй гаравэлас всаворэ кадэла лава андо пэско води. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Исусо барёлас, терэласпэ майгодявэр, и барёлас лэстэ мищимос Дэвлэско и манушэндиро. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Кала Тибериё дэшупанч бэрш сас императороса, Понтиё Пилато сас баро рай андэ Иудея, Иродо сас рай тетрархо андэ Галилея, о Филипо, пхрал лэско, — рай тетрархо андэ Итурея и Трахонитско пхув, а Лисаниё — рай тетрархо андэ Авилиния. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Андэ кодья вряма сас барэ рашаенца Анас и Каиафа. Сас лав Дэвлэстар кав Иоано, шаво лэ Захарияско, андэ мал. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Иоано прожалас пай всавори пхув пашав Иордано и акхарэлас манушэн тэ каисавэн и тэ болэнпэ, кай о Дэл тэ эртисарэл лэндирэ бэзэха. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Сар запистрасордо андо лил пророкоско Исаяско: «Гласо цыписавэл андэ мал: Гытон о дром Раести, ворта терэн дрома важ Лэсти! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Всаворэ оврагоря пхэрдёна, всаворэ барэ и цэкнэ плая тэлёна, бангэ дрома тернапэ ворта, нагладосавэ дрома гладосавэна, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","и всаворэ мануша дикхэна фэрисаримос Дэвлэско». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Иоано пхэнэлас манушэнди, савэ авэнас тэ болэнпэ: — Родо сапано! Ко пхэндя тумэнди тэ нашэн холятар, сави жал пэр тумэндэ? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Сикавэн рындонэнца, со тумэ каисайле, и на гындон: «Дад амаро исин Авраамо». Пхэнав тумэнди, со Дэл ваздэла андай кадэла бара шаворэн Авраамости. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Акэ, товэр пашав корнё дрэвоско пашлёл: всаворэ дрэворя, савэ на анэн лашо плодо, пхагэн товэрэса и шон андэ яг. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Пушэнас лэстар и мануша: — Со амэнди тэ терас? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Вов пхэндя лэнди: — Кастэ исин дуй гада, мэк отдэл екх кодлэсти, кастэ нинай, кастэ исин хамос, мэк дэл епаш кодлэсти, кастэ нинай. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Авиле лэстэ тэ болэнпэ стидэмаря налогонэндирэ и пушэнас лэстар: — Сытяримари! Со амэнди тэ терас? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Вов пхэндя лэнди: — На лэн лэ манушэндар майбут колэстар, со трэбуй тумэнди тэ лэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Пушэнас лэс и халавдэ: — Со амэнди тэ терас? Вов пхэндя лэнди: — На залэн манушэндар зораса. На хохавэн лэ манушэн, жувэн пэ кола ловэ, савэ тумэнди потинэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Всаворэ мануша ажутярэнас и гындонас андэ пэсти водя пала Иоано, чи на вов о Христосо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Иоано пхэндя всаворэнди: — Мэ болав тумэн паеса, нэ авэла Кодва, Ко майзорало мандар. Мэ на ашав тэ роспхандав Лэсти тэраха. Вов болэла тумэн Свэнтонэ Духоса и ягаса. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","И андэ Лэстирэ васт ганавди, вов жужарэла пэско токо и стидэла ворзо Пэско андэ пусын, ай шэлуха спхабарэла андэ яг, сави на пэрэашэла тэ пхабол. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Кала и авэр будэр лава пхэнэлас лэнди Иоано, кала пхэнэлас лэнди Радосаво Лав. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Иоано ля тэ ужылисарэл раес тетрархос Иродос, важ кода со вов ля палав ром Иродиада, ромня пэстирэ пхралэстиря, и колэсти со вов терэлас найлашэ рындоря. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Тунчи Иродо тердя инке екх вырито рындо — пхандадя лэ Иоанос андо баруно. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Кала всаворэ мануша болдэпэ, кадя ж сас болдо и Исусо. Тунчи Вов мангляпэ Дэвлэс, и отпхэрнадяпэ болыбэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","И Свэнто Духо, сар голубо, сжыля по Исусо. Сас гласо упрал, саво пхэнэлас: — Ту Шаво Мэрно, савэс Мэ камав! Ту — Мэрно радомос! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Кала Исусо ля тэ терэл и бути важ о Дэл, Лэсти сас варикай трянда бэрш. Вов сас, сар гындонас, шаво Иосифоско. Андо лэско родо сас: Илиё, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Матфато, Левиё, Мелхиё, Ианаё, Иосифо, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Матафиё, Амосо, Наумо, Еслиё, Нагеё, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Маафо, Матафиё, Шымьё, Иосифо, Иодаё, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Иоханано, Риса, Зоровавелё, Шэалтиило, Нириё, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Мелхиё, Адиё, Косамо, Элмадамо, Иро, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Иосиё, Элиезеро, Иоримо, Матфато, Левиё, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Симеоно, Иуда, Иосифо, Ионамо, Элиакимо, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Мелеа, Мена, Матафа, Нафано, Давидо, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Иесеё, Овидо, Боазо, Сала, Нахшоно, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Аминадаво, Админо, Арниё, Хецроно, Фарецо, Иуда, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Иаково, Исаако, Авраамо, Терахо, Нахоро, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Серуго, Реуо, Пелего, Еверо, Шэлахо, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Каинано, Арпахшадо, Симо, Ноё, Ламехо, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Мафусало, Енохо, Иаредо, Мелелеило, Каинано, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Еносо, Сифо, Адамо, о Дэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Исусо, пхэрдярдо Свэнтонэ Духоса, авиля лэ Иорданостар и андярдо сас лэ Духоса андэ мал. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Котэ Лэс саранда дес зумавэлас Бэнг. Всавори кадья вряма Исусо нисо на халас. И сар прожыле кала деса, Лэсти фартэ закамляпэ тэ хал. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Бэнг пхэндя Лэсти: — Сар ту Дэвлэско Шаво, пхэн калэ барэсти тэ терэлпэ марнэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Исусо пхэндя лэсти: — Пистросардо, со на екхэ марнэса авэла тэ жувэл мануш. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Тунчи Бэнг вазгля Лэс по баро плай и сыго сикадя Лэсти всаворэ тхагарима пхувьятирэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","И пхэндя Лэсти: — Мэ пэрэдава Тути всаворо баримос и слава калэ тхагаримастирэ. Када вся отдино манди, и касти закамава, колэсти и дава лэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Сар Ту тэлёса манди, тунчи када вся авэла тиро. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Исусо пхэндя лэсти: — Запистросардо: «Тэлюв Рае, Дэвлэсти тирэсти, качи Лэсти ав бутярнэса». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Тунчи Бэнг андярда лэ Исусос андо Иерусалимо, тховдя пэ майучё тхан храмоско и пхэндя: — Сар ту Шаво Дэвлэско, хук катар тэлэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Важ кода со пистросардо: «Пэстирэ ангелонэнди пала тутэ припхэнэла, кай онэ тэ дикхэн пала Тутэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Пэ васт андярэна тут, кай тэ на арэсэспэ тирэ пэрнэса андо бар». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Исусо пхэндя лэсти: — Кадя пхэндо: «На зумав лэ Рае Дэвлэс пэстирэс». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Тунчи Бэнг пэрэашыля тэ зумавэл Исусос и отжыля Лэстар пэ вряма. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Исусо рисайля андэ Галилея, пхэрдо зораса Духостиряса. Дума пала Лэстэ разжыляпэ пав всавори кодья пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Вов ситярэлас андэ синагоги, и всаворэ лашарэнас Лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Исусо авиля андо Назарето, кай выбариля, и андэ субота, сар Вов всавори вряма терэлас, зажыля андэ синагога и вщиля тэ бинэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Лэсти подинэ лил, саво запистросардя пророко Исая. Вов отпхэрнадя лил и аракхля тхан, кай сас запистросардо: ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Духо лэ Рае Дэвлэско пэр Мандэ, важ кода со Вов помакхля Ман тэ роспхэнав Радосаво Лав чёрорэнди. Вов бишалдя Ман тэ роспхэнав спханглэнди, со онэ авэна роспханглэ, корэнди, со онэ авэна тэ дикхэн, тэ отмэкав колэн, савэ грыжонпэ, пэ воля, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","тэ роспхэнав, кай авиля вряма лащи Рае Дэвлэстири». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Исусо запхандадя лил, отдя бутярнэсти и бэшля. Всаворэ андэ синагога дикхэнас пэр Лэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","И Вов ля тэ пхэнэл лэнди: — Адес, тердэпэ кола запистросардэ лава, савэ тумэ икхатар ашундэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Всаворэ лашарэнас Лэс, дивосавэнас Лэстирэ лашэ лавэнди и пушэнас: — Дикхэнтэ, на Иосифоско када шаво? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Вов пхэндя лэнди: — Акэ, тумэ пхэнэна манди дума: «Врачё! Састяр ежэно пэс». И пхэнэна манди: «Амэ ашундэ, со Ту тердян андо Капернаумо. Стер кадя ж и катэ, кай Ту барилян». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Пхэнав тумэнди чячимаса: нисавэ пророкос на прилэн котэ, кай вов бариля. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Чячимаса пхэнав тумэнди: андэ вряма, кала сас о Илия, сар на сас трин бэрш епашэса брышынд пай всавори кодья пхув, и сас баро бокхалимос, андо Израилё сас бут пхивлэ жувля. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Но на екхатэ лэндар на сас бишалдо Илия, а качи кай пхивли андэ Сарепта Сидоноско. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Бут сас насвалэ проказаса андо Израилё, кала сас пророко Елисеё, и ни екх лэндар на жужардиля, качи Неемано сирийцо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Всаворэ андэ синагога фартэ холяйле, сар ашундэ када. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Онэ линэ и выцырдэ Лэс андав форо, и андярдэ по баро плай, кай сас тердо лэнго форо, кай тэ сшон котар Лэс тэлэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Но Вов прожыля машкар лэндэ тай ужыля. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Исусо жыля андо галилейско форо Капернаумо и сытярэлас андэ суботни деса. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","И дивосавэнас Лэстирэ сытяримасти, колэсти со андо лав Лэско сас бари зор. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Сас андэ синагога мануш, андэ лэстэ сас духо найжужэ бэнгэско, и вов зацыписайля фартэ: ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","— Эй, со тути амэндар трэбуй, Исусо андав Назарето? Ту авилян тэ умарэс амэн? Мэ жанав, ко Ту! Ту Свэнто Дэвлэско! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","— Ашмулком! — припхэндя лэсти Исусо. — Выжа андар лэстэ! Бэнг шута манушэс машкар синагога и выжыля андар лэстэ. И на тердя лэсти ни сави бида. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Всаворэ дарайле и дэнас дума машкар пэстэ: — Со када кацаво? Вов баримаса и зораса припхэнэл найжужэ духонэнди, и онэ выжан! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Дума пала Лэстэ розжыляпэ пав всавори кодья пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Исусо выжыля андай синагога и зажыля андо чер Симоноско. Кай ромни Симоностири сас насвали дэй, всавори пхаболас, и мангэнас Лэс кай Вов варисо тэ терэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Вов поджыля латэ, запхэндя насвалимасти, и насвалимос ужыля. Вой андэ кодья вряма вщиля и ля тэ подэл пэ мэсали. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Кала бэшэлас кхам, всаворэ, кастэ сас насвалэ, линэ тэ андярэн лэн кав Иисусо. Вов тховэлас пэ кажно васт и састярэлас лэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Бэнга выжанас манушэндар и цыпинас: — Ту — Шаво Дэвлэско! А Вов запхэнэлас лэнди тэ пхэнэн, колэстар со онэ жанэнас, со Вов — Христосо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Сар авиля дес, Вов выжыля андав форо и жыля андэ мал. Мануша линэ тэ родэн Лэс, и кала аракхле, мангэнас Лэс, соб Вов тэ ашэлпэ лэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Но Вов пхэндя лэнди: — Манди трэбуй тэ роспхэнав Радосаво Лав палав Тхагаримос Дэвлэско и андэ авэр фороря. Пэ када Мэ бишалдо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","И Вов пхэнэлас лав андэ синагоги Иудеятирэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Екхвар Исусо тэрдёлас пашай лэн Генисаретско, бут мануша стидэпэ и стасавэнас Лэс всаворэ ригэндар тэ ашунэ Лав Дэвлэско. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Исусо удикхля пашав бэрэго дуй чёвноря и мащярэн, савэ выжыле андай чёвноря и выхалавэнас пэстирэ сетки. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Вов зажыля андо чёвно лэ Симоноско, мангля лэс тэ отплывисарэл найдур бэрэгостар и бэшля, кай тэ сытярэл манушэн пав чёвно. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Кала Исусо пэрэашыля тэ сытярэл, пхэндя Симоности: — Плывисар майдур, кай майбут паи, и шув сетки тумарэ, кай тэ астарэн мащё. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Симоно пхэндя: — Сытяримари амаро! Амэ всавори рят бут терасас и нисо на астардэ. Но сар Ту пхэнэс, тунчи шава сетки. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Онэ стердэ кадя и астардэ фартэ бут мащё, кай сетки линэ тэ шындён. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Акхардэ вастэнца аврэн мащярэн, савэ сас андэ авэр чёвно, кай кола тэ поджан тай тэ поможысарэн лэнди. Онэ авиле и екхэтанэ стидэ мащен андэ лэдуй чёвноря скачи, со чёвноря линэ тэ тасон. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Симоно Пэтро дикхля када, пэля кай пэрнэ лэ Исусостирэ и пхэндя: — Выжа мандар, Рай, колэстар со мэ мануш бэзэхало! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Важ кода со пэ лэстэ и пэ лэстирэ амала, авиля бари дар, сар дикхле, со кадя бут астардэ мащё. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Кадя и пэ Иаково лэ Иоаноса, шавэн Зэведеёстирэн, савэ сас амала Симоностирэ пай бути. Исусо пхэндя Симоности: — На дара! Кала вряматар авэса тэ астарэс манушэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Онэ выцырдэ чёвноря по бэрэго, ашадэ вся и жыле пала Лэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Кала Исусо сас андэ екх форо, авиля Лэстэ мануш всаворо андэ проказа. Удикхля Исусос, пэля кай Лэстирэ пэрнэ и фартэ мангля: — Рай! Сар Ту камэс, Тутэ исин зор тэ жужарэс ман! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Исусо процырдя васт, ляпэ калэ манушэстэ и пхэндя: — Камав, ав жужо! Проказа андэ кодья вряма ужыля манушэстар. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Исусо припхэндя лэсти: — Никасти на роспхэн пала када, жа сикавпэ рашаести и ан жэртва пала пэско жужаримос, сар пхэндя Моисеё. Мэк онэ када удикхэна. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Нэ инке майбут розжаласпэ дума палав Исусо, фартэ бут мануша авэнас Лэстэ тэ ашунэн и тэ састярэнпэ насвалимастар. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Но Исусо жалас андэ биманушэндирэ тхана и мангэласпэ Дэвлэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Екхвар, кала Исусо сытярэлас, котэ бэшэнас фарисеёря, сытяримаря Законостирэ, савэ авиле андай бут тхана андэ Галилея, Иудея и андав Иерусалимо. Зор Рае Дэвлэстири авэлас Исусоса тэ састярэл насвалэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Акэ, авиле мануша, савэ андярэнас насвалэс пэрнэнца по паринд, камэнас тэ заандярэн андо чер, кай тэ тховэн англав Исусо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Нащи сас тэ проандярэн лэс, колэстар со бут мануша сас котэ. Загульдэ по чер, розлинэ ушарди пав чер, змукле по паринд насвалэс машкар о чер, англав Исусо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Исусо дикхля лэнго патимос и пхэндя колэсти манушэсти: — Эртисарэнпэ тути тирэ бэзэха! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Фарисеёря и сытяримаря Законостирэ гындонас пэсти: «Ко Кала Мануш, Саво дэл думэл бэзэхалэ лава? Со, на екх о Дэл эртисарэл бэзэха?» ");
INSERT INTO rmyvlakh_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Исусо поля, со онэ гындон, тай пхэндя лэнди: — Со тумэ гындосарэн андэ тумарэ водя? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Со майлокхо: тэ пхэнэ: «Эртисарав тути тирэ бэзэха», — чи тэ пхэнэ: «Вщи и пхир»? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Кай тумэ тэ жанэн, со кав Шаво Манушыкано исин зор пэ пхув тэ эртисарэл бэзэха. Тунчи пхэндя насвалэсти манушэсти: — Пхэнав тути: вщи, лэ пэско паринд и жа черэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Андэ кодья ж вряма вов вщиля англай лэндэ, ля пэр со пашлёлас, тай жыля пэстэ черэ, лашарэлас лэ Дэвлэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","И всаворэ дивосавэнас, лашарэнас лэ Дэвлэс и дараса пхэнэнас: — Адес амэ дикхлям кода, со никала на сас. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Сар выжыля андав чер, Исусо удикхля стидэмарес налогонэндирэс, савэс акхарэнас Левиё. Вов бэшэлас по тхан, кай стидэнас налогоря. — Жа пала Мандэ, — пхэндя лэсти Исусо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Вов вщиля, ашадя вся и жыля пала Лэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Тунчи Левиё тховдя пэстэ черэ бари мэсали хамаса важ о Исусо. Котэ бут стидэмаря налогонэндирэ тай авэр мануша, сас палай мэсали лэ Исусоса. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Фарисеёря и сытяримаря Законостирэ пушэнас найлашымаса Исусостирэ сытярнэндар: — Состар тумэ хан и пэн стидэмаренца налогонэндирэ и бэзэхалэ манушэнца? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Исусо пхэндя лэнди: — На састэ манушэнди трэбуй врачё, ай насвалэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Мэ авилем тэ акхарав на жужэн манушэн, а бэзэхалэн, кай тэ каисавэн андэ пэстирэ бэзэха. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Тунчи онэ пхэндэ Лэсти: — Иоаностирэ и фарисеёнэндирэ сытярнэ бут молоря терэн мангимос лэ постоса, а Тирэ сытярнэ хан и пэн! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Исусо пхэндя лэнди: — Чи мишто тэ мангэ манушэн пэ бьяв тэ авэн андо посто кала тэрно паша лэндэ? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Но авэна деса, кала залэлапэ лэндар тэрно. Тунчи андэ кола деса авэна тэ терэн посто. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Вов роспхэндя лэнди кацави дума: — Нико на отшынэл котор нэвя йидатар, важ кода, кай тэ присувэл кай пураи. Сар вов када терэла, то и нэви йида хасавэла, и кай пураи йида кодва котор на поджала. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Нико на шол тэрни мол андэ пхуранэ морцянэ гонэ, колэстар со тэрни мол росшынэла лэн и вышолапэ, ай гонэ хасавэна. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Най, тэрно мол шон андэ нэвэ морцянэ гонэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","И нико, ко пэл пхурано мол, на закамэла тэ пэл тэрно, колэстар со пхэнэла: «Пхурано мол фэдэр». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Екхвар андэ субота, кала Исусо прожалас маляса, кай барёлас див, Лэстирэ сытярнэ сшынэнас о ворзо, кхосэнас андэ васт и ханас. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Варисавэ андай фарисеёря пхэндэ: — Сости тумэ терэн кода, со нащи тэ терэ андэ субота? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Исусо пхэндя лэнди: — Чи тумэ на бинэнас, со тердя Давидо, сар вов и лэстирэ мануша бокхайле? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Вов зажыля андо чер Дэвлэско, ля марно, саво тховэнас англав Дэл и саво нащи сас тэ хал никасти, сар качи лэ рашаенди, халя ежэно и дя тэ хал пэстирэ манушэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Исусо пхэндя лэнди: — Шаво Манушыкано исин Хулай ла суботнё! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Андэ авэр субота Исусо зажыля андэ синагога и сытярэлас. Котэ сас мануш шукэ правонэ вастэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Сытяримаря Законостирэ и фарисеёря дикхэнас пала Лэстэ, на авэла ли Вов тэ састярэл андэ субота, колэстар со родэнас тэ ужылисарэн Лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Нэ Исусо жангля, со онэ гындонас, и пхэнэл манушэсти шукэ вастэса: — Вщи, выжа по машкар! Мануш вщиля и выжыля англэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Исусо пхэндя лэнди: — Мэ пушав тумэндар: со домукэлпэ тэ терэс андэ субота, лашымос чи выритимос? Тэ фэрисарэл жувимос чи тэ хасавэл? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Вов подикхля пэр лэндэ и пхэндя колэсти манушэсти: — Процырдэ тиро васт. Вов процырдя, и лэско васт ашыля састярдо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Онэ жэ фартэ холяйле и дэнас дума машкар пэстэ, со тэ терэн лэ Исусоса. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Андэ кодья вряма Исусо жыля по плай тэ мангэлпэ Дэвлэс и всавори рят сас андо мангимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Сар авиля дес, Вов акхардя Пэстирэн сытярнэн и вытидя лэндар дэшудуй, савэн проакхардя апостолонэнца: ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Симонос, савэс проакхардя Пэтро, пхралэс Симоностирэс Андреёс, Иаковос и Иоанос, Филипос и Варфоломеёс, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Матфеёс и Фомас, шавэс Алфеёстирэс Иаковос, Симонос, проакхардо Зилото, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","шавэс Иаковостирэс Иудас и Иудас Искариотос, саво прэдя лэ Исусос. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Исусо сжыля плаестар лэнца тэлэ и тэрдиля по биплаенго тхан. Котэ стидэпэ бут Лэстирэ сытярнэ и фартэ бут мануша пай всавори Иудея и Иерусалимо, а кадя ж андай фороря Тиро и Сидоно, савэ по брэго барэ паеско. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Онэ авиле тэ ашунэн Исусос и тэ састярэн насвалимастар. Мануша, савэ грыжонаспэ найжужэндар духондар, састярэнаспэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Всаворэ мануша камэнас тэ лэнпэ Исусостэ, важ кода со Лэстар сжалас зор и састярэлас всаворэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Вов вазгля якха пэ сытярнэ и ля тэ пхэнэл: — Бахталэ тумэ, чёрэ! Тумаро исин Тхагаримос Дэвлэско! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Бахталэ тумэ, ко бокхалэ икхатар! Тумэ чялёна! Бахталэ тумэ, ко икхатар ровэл! Тумэ авэна тэ радонпэ! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Бахталэ тумэ, сар мануша тумэн фартэ на камэна, кала тумэн вытрадэна, акушэна и магрисарэна тумаро алав палав Шаво Манушыкано. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Челэн андэ кодва дес баря лошаса! Баро потинимос тумэнди по болыбэн! Кадя терэнас пророконэнца дада калэ манушэндирэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Нэ бида тумэнди, барвалэ! Тумэ ужэ линэ пэско путинимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Бида тумэнди, ко чялэ икхатар! Тумэ авэна бокхалэ. Бида тумэнди, ко икхатар асалпэ! Тумэ авэна тэ грыжонпэ и тэ ровэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Бида тумэнди, кала всаворэ дэн дума пала тумэндэ лашымос! Кадя лэндирэ папоря лашарэнас хохавнэн пророконэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","— Мэ пхэнав тумэнди, ко ашунэн Ман: камэн тумарэн вражымарен, терэн лашымос колэнди, ко на камэл тумэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Бахталисарэн колэн, ко дэл амрая тумэн, и мангэн Дэвлэс палай кола, савэ терэн тумэнди наймишто. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Колэсти, ко арэсэла тут пай чям, подтхов авэр. Колэсти, ко залэл тутар упраи йида, отдэ лэсти и пэско гад. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Всаворэнди, ко тутэ мангэл, дэ; и сар ко залэла тиро, на манг палпалэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Терэн лэ манушэнди кода, со тумэ камэн, соб онэ тэ терэн тумэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Сар тумэ камэн качи колэн, ко тумэн камэл, пала со тумэн тэ наисарэ? И бэзэхалэ мануша камэн колэн, ко лэн камэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Сар тумэ терэн лашымос колэнди, ко терэл мишто тумэнди, пала со тумэнди тэ наисарэ? И бэзэхалэ мануша терэн кадя жэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Сар тумэ дэн ловэ андо ужылимос качи колэнди, савэндар патян, со залэна палпалэ, пала со тумэнди тэ наисарэ? И бэзэхалэ мануша дэн андо ужылимос бэзэхалэнди и ажутярэн тэ залэн палпалэ вся, скачи динэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ай тумэ камэн тумарэн вражымарен, терэн лэнди лашымос и дэн андо вужылимос, на ажутярэн, кай онэ отдэна палпалэ. Тунчи тумаро потинимос авэла баро, тумэ авэна шавэнца Майбарэстирэнца. Колэстар со Вов тангосарэл и колэн, савэ на наисарэн, и холятирэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Авэнтэ тангимасти, сар тангимаско Дад тумаро. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","На сындосарэн, и тумэ на авэна сындосардэ. На осындосарэн, и тумэ на авэна осындосардэ. Эртисарэн, и тумэ авэна эртисардэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Дэнтэ, и тумэнди кадя ж дэлапэ. Пхэрдэ гонэса шона и инке притасавэна, дэна тумэнди андо брэк, со авэла тэ росшолдёл. Савя мераса тумэ бинэн, кадя бинэна и тумэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Исусо роспхэндя лэнди кацави дума: — Сар коро андярэла корэс? На пэрэна ли онэ лэдуй андэ ганади? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Сытярно на майбаро пэстирэ сытяримарестар. Нэ сар высытёла, тунчи авэла, сар пэско сытяримари. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Со дикхэс по кашторо андэ якх пэстирэ пхралэстэ, ай андэ пэстири якх на додикхэс баро кашт? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Сар ту пхэнэса пэстирэ пхралэсти: «Пхрала, дэ, мэ вылава кашторо андай якх тири»? Сар ту на дикхэс баро кашт андэ пэстири якх? Ту, дуемуенго! Вылэ майанглал баро кашт андай якх тири, и тунчи дикхэса, сар тэ вылэ кашторо андай якх пэстирэ пхралэстар. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","По лашо дрэво на барёл найлашо плодо, и вырито дрэво на анэн лашо плодо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Кажно дрэво ужанэлпэ пай пэско плодо. На стидэн инжыро пав тэрно и виноградо пав пусаимаско кустарнико. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Андав води, пхэрдярдо лашымаса, лашо мануш выандярэл лашымос, а холяко мануш выандярэл холи андав пэско води, пхэрдярдо холяса. Со кав мануш андо води, кода лэстэ и пэ шыб. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Со тумэ акхарэн Ман: «Рай! Рай!» — а на терэн кода, со Мэ пхэнав? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Мэ пхэнава тумэнди, пэр кастэ мэзимэ кодва, ко авэл Мандэ, ашунэн лава Мэрнэ и терэл кадя, сар Мэ пхэнав. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Вов мэзимэ по мануш, саво терэлас чер. Вов выганадя бари ганади и тховдя фундаменто по бар. Кала паи вазгляпэ и лэн выжыля андав брэго и жыля по чер, вой на схаладя лэс, колэстар со сас тердо мишто. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ай кодва, ко ашунэл Мэрнэ лава и на терэл кадя, сар Мэ пхэнав, вов мэзимэ по мануш, саво тердя чер пэ пхув бифундаментоско. Сар качи лэн жыля по чер, вов андэ кодья вряма роспхагляпэ и роспэляпэ всаворо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Сар пэрэашыля тэ дэл дума кай мануша, Исусо жыля андо Капернаумо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Котэ, кав екх халавдо, пхурэдэр англай шэл халавдэ, сас бутярно, вов лэс фартэ танголас. Вов сас фартэ насвало и мэрэлас. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Кала халавдо ашундя палав Исусо, бишалдя Лэстэ иудеёндирэн пхурэдэрэн тэ мангэн Лэс, кай тэ авэл и тэ састярэл лэстирэ бутярнэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Пхурэдэра авиле кав Исусо и линэ тэ мангэн Лэс: — Кадва мануш ашэл, кай Ту тэ терэс када важ лэсти. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Вов камэл амарэн манушэн и тердя амэнди синагога. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Исусо жыля лэнца. Кала Вов поджалас кав чер, пхурэдэр шэлэнго бишалдя Лэстэ пэстирэ амалэн тэ пхэнэн: — Рай, на лэ пэр пэстэ пхаримос. Мэ на ашав, кай ту тэ зажас талай ушарди мэрнэ черэстирэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Мэ ежэно на ашав тэ авав Тутэ. Нэ пхэн качи лав, и мэрно бутярно састёла. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Мэ ежэно кандав, со припхэнэн манди мэрнэ пхурэдэра. И мандэ исин майцэкнэ мандар халавдэ, савэ кандэн ман. Мэ пхэнав екхэсти: «Жа!» — и жал, аврэсти: «Ав кардэ!» — и кодва авэл. Бутярнэсти пэстирэсти пхэнав: «Стер када!» — и вов терэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Исусо шундя када, дивосайля, обрисайля кай мануша, савэ жанас пала Лэстэ, пхэндя: — Пхэнав тумэнди, со и андэ Израилё Мэ на аракхлем кацаво патимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Кола, савэн бишалдэ, рисайле андо чер, аракхле бутярнэс састярдэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","На прожыля бут вряма, тунчи Исусо жыля андо форо, саво акхарэлпэ Наино. Лэса жанас Лэстирэ сытярнэ и бут авэр мануша. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Кала Вов поджыля кай форости удар, котар выандярэнас мулэс. Вов сас екх шаво кай дэй, ай вой сас пхивли. Екхэтанэ ласа андав форо выжанас бут мануша. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Кала Рай удикхля кала жувля, Вов тангосардя ла. — На ров, — пхэндя Вов лати. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Тунчи Вов поджыля, ляпэ кав сикрио. Кола, ко андярэлас лэс, ашыле. Исусо пхэндя: — Шаворо, пхэнав тути: вщи! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Муло бэшля и ля тэ дэл дума. Исусо отдя лэс лэстиря дати. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Пэ всаворэ, ко сас котэ, авиля бари дар, и мануша линэ тэ лашарэн Дэвлэс и тэ пхэнэн: — Баро пророко авиля амэндэ! Дэл авиля кай Пэстирэ мануш! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Кацави дума розжыляпэ пала Лэстэ пай всавори Иудея и всавори пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Сытярнэ Иоаностирэ роспхэндэ лэсти пала вся кода. Тунчи Иоано акхардя пэстэ дуен андар лэндэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","И бишалдя лэн кав Рай тэ пушэн: — Ту кодва, Ко трэбуй тэ авэл, или амэнди тэ ажутярас аврэс? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Кала мурша авиле кав Исусо и пхэндэ: — Иоано Болдэмарё бишалдя амэн Тутэ тэ пушас: «Ту Кодва, Ко трэбуй тэ авэл, или амэнди тэ ажутярас аврэс?» ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Андэ кодья вряма Исусо састярдя бутэн манушэн насвалимастар, дукхатар и холятирэ духондар, и бутэнди корэнди отпхэрнадя якха. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Исусо пхэндя бишалдэнди: — Жантэ, роспхэнэнтэ Иоаности, со тумэ дикхле и шундэ: корэ дикхэн, бангэ пхирэн, насвалэ проказаса жужарэнпэ латар, кашукэ ашунэн, мулэ жундён, и чёрэнди роспхэнэлпэ Радосаво Лав. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Бахтало кодва, ко на хасарэла патимо андэ Мандэ! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Кала бишалдэ сытярнэ Иоаностирэ ужыле, Исусо ля тэ дэл дума манушэнди палав Иоано: — Со тумэ пхирдэ тэ дикхэн андэ мал? Чяр, сави тинолпэ балвалятар? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Тунчи, со тумэ пхирдэ тэ дикхэн? Манушэс, урявдэс андэ барвали йида? Най! Кола, савэ урявдэ андэ ковли йида, жувэн барвалэс андэ тхагарэндирэ чера. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Тунчи, со тумэ пхирдэ тэ дикхэн? Пророкос? Кадя, пхэнав тумэнди, со майбарэс, сар пророко. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Вов кодва, пала кастэ пистросардо: «Акэ, Мэ бишалав англав Тутэ Мэрнэс ангелос, саво гытола англав Тутэ Тиро дром». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Пхэнав тумэнди: колэндар, савэн бэяндэ жувля, нинай майбарэс пророкос, сар Иоано. Но майцэкно андэ Тхагаримос Дэвлэско — майбаро лэстар. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Всаворэ мануша тай стидэмаря налогонэндирэ, ашундэ и прижангле Дэвлэско дром чячюно и прилинэ болдимос Иоаноско. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","А фарисеёря и сытяримаря Законостирэ отпхэндэпэ тэ терэ, со пхэндя о Дэл, и на болдэпэ Иоаностар. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Исусо пхэндя: — Пэр кастэ тунчи шонпэ мануша кала родостар? Пэр кастэ онэ мэзимэ? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Онэ — сар бэяцэ, савэ бэшэн пэ тарго и цыписавэн ек екхэсти: «Амэ дилабасас тумэнди пэ дудка, и тумэ на цэлэнас. Амэ дилабасас тумэнди ровиканэ диля, и тумэ на ровэнас». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Акэ, авиля Иоано Болдэмарё, на хал марно и на пэл мол, и тумэ пхэнэн: «Андэр лэстэ бэнг». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Авиля Шаво Манушыкано, хал и пэл, и тумэ пхэнэн: «Акэ мануш, саво обхалпэ, и матимари, амал стидэмаренго налогонэндиро и бэзэхалэ манушэнго». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Нэ допхэнэлпэ годи рындонца всаворэ бэяцэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Екх андай фарисеёря акхардя Исусос пэстэ черэ тэ хал. Исусо авиля лэстэ черэ и бэшля палай мэсаля. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Андэ кадья вряма екх жувли колэ форостар, савя жанэнас сар бэзэхаля, ужангля, кай Исусо хал андо чер фарисеёско, андя кордэ кхоро андай алебастро лэ духонэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Жувли тэрдиля палал паша пэрнэ кав Исусо, фартэ ровэлас, и ясва прастэнас Лэсти пэ пэрнэ. Вой ля тэ выкхосэл Лэсти пэрнэ пэсти балэнца, чюминдэлас лэн и макхэлас духонэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Кала фарисеё, саво акхардя Исусос, дикхля када, вов гындосардя: «Сар Кадва Мануш чячес тэ авэл пророкоса, то Вов жанэлас бы, со манушни, сави Лэстэ лэлпэ, — бэзэхали». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Тунчи Исусо пхэндя лэсти: — Симоно, Мэ камав тути варисо тэ пхэнав. Кодва пхэндя: — Пхэн, Сытяримари. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","— Дуй мануша сас ужылэ екхэ и колэсти манушэсти. Екх ужыло сас панч шэл динария, а авэр — пандэша. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","И екхэсти, и аврэсти на сас, соса тэ рисарэн ужылимос. Колэстар вов эртисардя дуенди. Ко лэндар авэла майфартэ тэ камэл лэс? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Симоно пхэндя: — Гындосарав, кодва, касти сас будэр ужылимос эртисардо. — Ту чячес полэс, — пхэндя Исусо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Обрисайля кай жувли, пхэндя Симоности: — Ту дикхэс акала жувля? Мэ авилем адо чер тиро. Ту паи манди на дян, кай тэ выхалавав пэрнэ, а вой выхаладя Мэрнэ пэрнэ ясвэнца и выкхосля пэстирэ балэнца! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ту на чюминдян Ман, сар авилем тутэ, а кадья жувли кола вряматар, сар Мэ зажылем тутэ, на пэрэашэл тэ чюминдэл Манди пэрнэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ту на дян Манди оливково дзэто тэ макхав шэро, а вой кучютнэ духонэнца помакхля Манди пэрнэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Важ кода Мэ пхэнав тути: лати эртисардэпэ бут бэзэха, пала кода вой покамля кадя бут. А кодва, касти цыра эртисардо, и камэл майцыра. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Тунчи Иисусо пхэндя жувляти: — Тирэ бэзэха эртисардэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Нэ авэр мануша, савэ сас паша мэсали, гындонас: «Ко Вов кацаво, со и бэзэха эртисарэл?» ");
INSERT INTO rmyvlakh_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Исусо пхэндя жувляти: — Тиро патимос фэрисардя тут. Жа лэ мироса. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Тунчи Исусо жыля пай фороря и гава, пхэнэлас Радосаво Лав палав Тхагаримос лэ Дэвлэско. Лэса сас дэшудуй ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","и кадя ж сас жувля, савэн Вов састярдя холятирэ духонэндар и насвалимастар: Мария, проакхарди Магдалина, савятар выжыле эхта бэнга, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Иоана, ромни лэ Хузастири, саво сас пхурэдэр андо чер Иродоско, Сусана и бут авэр. Кала жувля поможысарэнас Исусости и Лэстирэ сытярнэнди андай кода, со лэндэ сас. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Кав Исусо авэнас мануша андай бут фороря. Сар стидиле бут мануша, Вов роспхэндя лэнди дума: ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","— Мануш выжыля тэ шол ворзо андэ пхув. Кала вов шолас, екх ворзо пэля пашав дром, и мануша пэрнэнца потасадэ, ай чирикля упралимастирэ похале лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Авэр, со пэля пэ баруи пхув, подбариля тай зашутиля, колэстар со котэ на сас паи. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Трито пэля андэ чяр, и кодья розбариляпэ тай замардя лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Авэр пэля пэ лащи пхув, бариля и андя андэ шэл молоря майбут колэстар, со сас шуто. Тунчи Исусо вазгля гласо тай пхэндя: — Кастэ исин кана, кай тэ ашунэл, мэк ашунэл! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Лэстирэ сытярнэ пушле Лэстар: — Сар тэ полэ кадья дума? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Исусо пхэндя: — Тумэнди дяпэ тэ жанэн гарадо пала Тхагаримос Дэвлэско, ай аврэнди вся ашэлпэ гарадя думаса, кай онэ тэ дикхэн и тэ на удикхэн, тэ ашунэн и тэ на полэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Акэ, сар тэ полэ кадья дума: ворзо — када лав Дэвлэско. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Кодва, саво пэля паша дром, исин кола, савэ ашунэн лав, нэ тунчи авэл Бэнг и чёрэл лав андай лэнго води, соб онэ тэ на патян и тэ на фэрисарэнпэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ворзо, саво пэля пэ баруи пхув, исин кола, ко радомаса прилэл лав, кала ашунэл лэс. Нэ лэндэ нинай корнё. Сави-то вряма патян, нэ сар авэл зумавимос, онэ отпэрэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ворзо, саво пэля андэ чяр, исин кола мануша, савэ ашунэн лав. Нэ авэн жувимастирэ рындоря, тай лэнди камэлпэ тэ авэн барвалэнца и шукар тэ жувэн. Вся када на дэл тэ барёл лавэсти, и вов на анэл плодо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ворзо, саво пэля пэ лащи пхув, — када мануша, савэ ашунэн лав, ритярэн лэс андо лашо и жужо води и анэн плодо, тэрписаримаса андэ вся вряма. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Нико на запхабарэл каганцо и на тховэл лэс талай пири или талав пато, а тховэл лэс упрэ пэ вучё тхан. Тунчи, ко зажала, дикхэла удуд. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Нинай нисо чёрэхано, со на авэла удикхло, и гарадо, со на ужанэна и со на выжала аври. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Дикхэн, сар тумэ ашунэн. Кастэ исин, колэсти инке авэла дино, а кастэ нинай, колэстар отлэлапэ и кода, со, сар лэсти гындолпэ, лэстэ исин. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Кав Исусо авиле Лэстири дэй и пхрала, и на сас сар тэ поджан, колэстар со паша Лэстэ сас фартэ бут мануша. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Исусости роспхэндэ: — Дэй Тири и пхрала Тирэ тэрдён аври, камэн тэ дикхэн Тут. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Исусо пхэндя лэнди: — Мэрни дэй и пхрала исин кола, ко ашунэл лав Дэвлэско и терэл кадя, сар вов пхэнэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Екхвар Исусо пхэндя Пэстирэ сытярнэнди: — Пэрэплывисараса пэ авэр риг. Онэ бэшле андо чёвно, отплывисардэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Сар онэ плывисарэнас, Исусо засутя. Вазгляпэ по паи бари балвал, и чёвно ля тэ зашол паеса кадя, со лэнди авэлас бида. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Сытярнэ поджыле кав Исусо, вазгле Лэс и пхэндэ: — Сытяримари! Сытяримари! Амэ хасавас! Вов просутяпэ и запхэндя балваляти и паести, саво ваздёлас. Вся пэрэашыля, и ашыля тыхо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","— Кай патимос тумаро? — пхэндя Исусо сытярнэнди. Онэ ж пэрэдарайле тай дивосайле, и пушэнас екх екхэстар: — Ко Вов, со и балваляти, и паести припхэнэл, и онэ кандэн Лэс? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Онэ приплывисардэ андэ пхув Гераса, сави сас англай Галилея. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Кала Исусо авиля по бэрэго, Лэсти по дром выжыля мануш андав форо, андэр лэстэ сас бут бэнга. Пэр лэстэ дэлмут на сас йида, жувэлас на андо чер, а андэ склэпоря важ мулэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Кала вов удикхля Исусос, вов пэля кай Лэсти пэрнэ и фартэ зацыписайля: — Со Ту мандар камэс, Исусо, Шаво Барэ Дэвлэско? Мангав Тут, на хасар ман! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Исусо припхэндя найжужэ духости тэ выжал андав кадва мануш. Бэнг бут вряма хасарэлас лэс. Лэсти спхандэнас лэпунзэнца васт и пэрнэ, нэ вов росшынэлас лэн, и бэнг затрадэлас лэс андэ мал. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Исусо пушля лэс: — Сар тут акхарэн? — Легионо, — пхэндя кодва, колэстар со бут бэнга вжыле андэр лэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Онэ линэ тэ мангэнпэ Исусостар тэ на бишалэл лэн андэ бездна. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Найдур котар по плай пасынаспэ бут балэ, и бэнга мангэнас Исусос, кай онэ тэ вжан андэр лэндэ. Вов пхэндя лэнди: «Жан». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Кала бэнга выжыле андав мануш и вжыле андэ балэ, и кола всаворэ шутэпэ пай кручя андо паи и тасиле. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Пасымаря, савэ сас пашай балэ, дикхле, со тердяпэ, прастае и роспхэндэ вся андо форо и андэ гава. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Сжылепэ мануша тэ дикхэн, со тердяпэ. Онэ поджыле кав Исусо и удикхле, со кодва мануш, андэ савэстэ сас бэнга, бэшэл пашай пэрнэ кав Исусо, урявдо и андэ пэсти годи, и авиля пэр лэндэ дар. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Кола, савэ вся дикхле, роспхэндэ лэнди, сар сас састярдо мануш андэ савэстэ сас бэнга. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Тунчи всаворэ мануша, савэ жувэнас андэ пхув Гераса, линэ тэ мангэн Исусос тэ ужал лэндар, колэстар со онэ фартэ здарайле. Исусо бэшля андэ чёвно и рисайля палпалэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Мануш, савэстар выжыле бэнга, мангля Исусос тэ лэл лэс Пэса. Но Исусо отмэкля лэс и пхэндя: ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","— Рисав пэстэ черэ и роспхэн, со тердя важ тути Дэл. Кодва жыля, роспхэнэлас пав всаворо форо пала кода, со тердя важ лэсти Исусо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Кала Исусо рисайля палпалэ, Лэс радомаса прилинэ бут мануша, колэстар со всаворэ ажутярэнас Лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Тунчи Лэстэ поджыля мануш, савэс акхарэнас Иаиро, саво сас пхурэдэр андэ синагога, и пэля кай Исусостирэ пэрнэ, ля тэ мангэл Лэс, кай тэ авэл лэстэ черэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Лэстэ сас екх щей, савяти сас дэшудуй бэрш, и вой мэрэлас. Исусо жыля лэса, и Лэс всаворэ ригэндар стасавэнас мануша. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Машкар лэндэ сас жувли, савятэ дэшудуй бэрш жалас рат. Вой отдя вся, со латэ сас, врачёнэнди, и никастэ на сас зор тэ састярэл ла. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Вой поджыля палал кав Исусо и ляпэ кай риг Лэстиря йидатэ. Рат андэ кодья ж вряма пэрэашыля тэ жал. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","— Ко Мандэ ляпэ? — пушля Исусо. Нико на прижандёлас. Пэтро пхэндя: — Сытяримари, паша Тутэ бут мануша и стасавэн всаворэ ригэндар! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Исусо пхэндя: — Варико Мандэ ляпэ. Мэ полем, со Мандар выжыля зор. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Тунчи кадья жувли поля, со вой на гарадёла, тиносайля, поджыля и пэля англав Исусо. Англай всаворэ мануша роспхэндя, состар вой Лэстэ ляпэ, и сар вой састярдяпэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Тунчи Исусо пхэндя лати: — Щей Мэрни! Тиро патимос фэрисардя тут. Жа лэ мироса. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Кала Исусо инкэ на допхэндя када, авиля мануш андав чер пхурэдэр синагогако. — Щей тири муля, — пхэндя вов, — на залэ будэр Сытяримарес. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ашундя када, Исусо пхэндя Иаирости: — На дара, качи патя, и щей тири авэла фэрисарди. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Сар Вов зажыля андо чер, на дя никасти тэ зажан Лэса, качи о Пэтро, Иоано, Иаково, дад и дэй щиёратирэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Всаворэ ровэнас и грыжонаспэ пала щиёры. — Пэрэашэн тэ ровэн, — пхэндя Исусо. — Вой на муля, а совэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Онэ линэ тэ асан Лэстар, колэстар со жанэнас: вой муля. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Исусо ля ла палав васт и пхэндя: — Бэята, вщи! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Духо щиёрако рисайля латэ, и андэ кодья вряма вой вщиля. Исусо пхэндя тэ дэн лати тэ хас. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","О дад и дэй латирэ дивосайле. Исусо пхэндя лэнди, никасти тэ на роспхэнэн пала када, со тердяпэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Исусо стидя екхэтанэ дэшудуен апостолонэн и дя лэнди зор и баримос тэ вытрадэн бэнгэн и тэ састярэн насвалимастар. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","И бишалдя лэн тэ роспхэнэн палав Дэвлэско Тхагаримос и тэ састярэн насвалэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Пхэндя лэнди: — Нисо на лэнтэ пэса андо дром: ни дэсто, ни траста, ни марно, ни ловэ, ни авэр йида. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Андэ саво чер тумэ тэ зажан, котэ ашэнпэ и котар жан майдур. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Сар мануша тумэн на прилэна, тунчи, сар авэна тэ выжан колэ форостар, обмарэн пош тумарэ пэрнэндар, мэк када авэла важ лэнди шпэра. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Дэшудуй жыле андо дром, пэрэжанас гав гавэстэ, роспхэнэнас Радосаво Лав, и андэ всаворэ тхана састярэнас насвалэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Дума пала вся када дожыля кав рай тетрархо Иродо. Вов дивосайля, колэстар со екх пхэнэнас: када Иоано жундиля андай мулэ, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","авэр — со када сикадяпэ Илия, ай авэр — со када жундиля андай мулэ екх андай дэлмутно пророко. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Иродо пхэндя: — Иоаности мэ отшындэм шэро. А ко тунчи Кадва Мануш, пала саво мэ ашунав? И вов родэлас тэ дикхэл Исусос. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Апостолоря рисайле и роспхэндэ Исусости пала вся, со онэ стердэ. Тунчи Вов ля лэн Пэса, и онэ жыле ежэнэ биманушэнго кав форо, саво акхарэлпэ Вифсаида. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Нэ бут мануша ужангле пала када и жыле палав Исусо. Вов мишто лэн приля, пхэнэлас лэнди палав Дэвлэско Тхагаримос и кадя ж састярэлас колэн, касти када сас трэбуй. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Вряма жалас кай рят, и дэшудуй поджыле кав Исусо и пхэндэ: — Отмук манушэн, соб онэ тэ жан андэ пашэ тхана и гава тэ аракхэн, кай тэ ратярэн и тэ хан, колэстар со амэ катэ андэ биманушэнго тхан. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Исусо пхэндя лэнди: — Тумэ дэнтэ лэнди тэ хан. Сытярнэ дивосайле: — Амэндэ качи панч марнэ и дуй маще. Со амэнди, тэ жас тэ тинас хамос важ всаворэ акала мануш? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Котэ сас екхэн муршэн варикай панч мии. Исусо пхэндя сытярнэнди: — Розбэшлярэн манушэн по пандэша. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Сытярнэ кадя тердэ. Кала всаворэ бэшле, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Исусо ля панч марнэ и дуй маще, вазгля якха по болыбэн и пхэндя наис палав хамос. Тунчи Вов ля тэ пхагэл марно и мащё и тэ дэл Пэстирэ сытярнэнди, кай кола тэ роздэн манушэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Всаворэ ханас и чялиле, и стидэ инке котора савэ ашылепэ, андэ дэшудуй барэ трасты. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Екхварэс, кала Исусо мангэласпэ Дэвлэс ежэно, найдур Лэстар сас Лэстирэ сытярнэ. Вов пушля лэндар: — Пала кастэ прилэн Ман мануша? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Онэ пхэндэ: — Палав Иоано Болдэмарё, ай авэр — палав Илия, ай авэр пхэнэн, со екх андай дэлмутно пророко жундиля. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","— А тумэ важ касти прилэн Ман? — пушля лэн Исусо. — Дэвлэско Христосо, — пхэндя Пэтро. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Нэ Исусо припхэндя лэнди, кай никасти тэ на роспхэнэн пала када. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Пхэндя: — Шаво Манушыкано авэла андэ бари грыжа, и Лэс на прилэна пхурэдэра, барэ рашая и сытяримаря Законостирэ. Вов авэла умардо, ай по трито дес жундёла. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Тунчи Исусо пхэндя лэнди: — Сар ко камэл тэ жал пала Мандэ, мэк отпхэндёл ежэно пэстар, кажно дес лэл пэско трушул и жал пала Мандэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Кодва, ко камэл тэ фэрисарэл пэско жувимос, хасарэла лэс, а ко хасарэла пэско жувимос важ Манди, кодва фэрисарэла лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Со за мищимос манушэсти, сар вов лэла всавори люма, а ежэно хасавэла и терэла грыжа пэсти? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ко лажала Мандар и Мэрнэ лавэндар, колэстар лажала и Шаво Манушыкано, кала авэла андэ Пэстири слава и андэ слава лэ Дадэстири, и свэнтонэнца ангелонэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Пхэнав тумэнди чячимос: исин машкар тумэндэ кола, савэ тэрдён катэ, онэ на мэрэна, сар удикхэна о Тхагаримос Дэвлэско. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Кала прожыля варикай охта деса, сар Исусо пхэндя кала лава, Вов ля Пэтрос, Иоанос и Иаковос и вазгляпэ по плай тэ мангэлпэ Дэвлэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Андэ кодья вряма, сар мангэласпэ, Лэско муй парудиля, Лэстири йида ашыля парни тай свэтосавэлас. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","И акэ, авиле дуй мурш, савэ линэ тэ дэн дума Исусоса, — када сас Моисеё и Илия. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Онэ авиле андэ бари слава и пхэнэнас, со Лэсти трэбуй тэ жал андо Иерусалимо кай тэ ашавэл кадья люма. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Пэтро и ко сас лэса засутэ. Но сар просутэпэ, удикхле слава Исусостири и дуен муршэн, савэ тэрдёнас паша Лэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Кала мурша линэ тэ жантар, Пэтро пхэндя Исусости: — Сытяримари! Амэнди катэ фартэ мишто! Амэ стераса трин катуны: екх Тути, екх Моисеёсти и екх Илиясти. Ежэно на полэлас, со дэлас дума. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Кала вов дэлас дума, авиля облако пэр лэндэ и онэ попэле талав лэстэ. Сар попэле андо облако, онэ фартэ пэрэдарайле. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Андав облако пхэндя гласо: — Када Мэрно Шаво, Мэрно вытидо. Лэс ашунэн! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Сар гласо на ашыля, онэ удикхле екхэс Исусос. Онэ ашэнас мулком пала кода и андэ кодья вряма никасти на роспхэнэнас, со онэ дикхле. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Пэ авэр дес, кала онэ змукэнаспэ пав плай, Исусос ажутярэнас фартэ бут мануша. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","И екх мануш андар лэндэ зацыписайля: — Сытяримари! Мангав Тут, подикх по мэрно шаво, вов екх мандэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Лэс схутилэл и тасавэл духо, и тунчи шаворо лэл тэ цыписавэл, тэ тиносавэл и тэ мукэл саля. Духо фартэ марэл лэс и тунчи цыра отжал лэстар. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Мэ манглем Тирэн сытярнэн тэ вытрадэн лэс, но онэ на вытрадэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","— Напатимаско и билажавардо родо, — пхэндя Исусо. — Скачи Манди тэ авав тумэнца и тэ тэрписарав тумэн? Ан тирэс шавэс кардэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Кала шаворо инке жалас, бэнг шутя лэс пэ пхув и ля тэ марэл лэс. Но Исусо запхэндя найжужэ духости, састярдя шаворэс и отдя лэстирэ дадэсти. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Всаворэ дивосайле, саво баро Дэл. Андэ кодья вряма, сар всаворэ дивосавэнас колэсти, со тердя Исусо, Вов пхэндя Пэстирэ сытярнэнди: ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","— Ашунэн мишто, со Мэ тумэнди икхатар пхэнава: Шаво Манушыкано сыго авэла отдино андэ васт манушэндирэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Но онэ на полинэ, со Вов пхэндя. Лэнди када сас затердо, и онэ на полинэ, со сас пхэндо, а тэ пушэн Лэс пала када лав даранас. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Машкар сытярнэ екхвар сас дума пала кода, ко лэндар майбаро. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Исусо жангля, со онэ гындонас андэ водя, ля цэкнэс бэятос и тходя паша Пэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","— Ко важ Мэрно алав прилэл акацавэс бэятос, — пхэндя Исусо, — кодва и Ман прилэл, а ко прилэл Ман, кодва прилэл Колэс, ко Бишалдя Ман. Ко машкар тумэндэ майцэкно всаворэндар, кодва и майбаро. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Иоано пхэндя Лэсти: — Сытяримари! Амэ дикхле манушэс, саво Тирэ алавэса вытрадэл бэнгэн. Амэ запхэндэ лэсти, колэстар со вов на пхирэл пала Тутэ екхэтанэ амэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","— На запхэнэн, — пхэндя лэсти Исусо. — Ко на жал пэ тумэндэ, кодва пала тумэндэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Кала Исусости поджыля вряма тэ ваздэлпэ по болыбэн, Вов ля андэ годи со трэбуй тэ жал андо Иерусалимо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Англал Пэстэ Вов бишалдя пэстирэ манушэн, онэ жыле андо екх андай самариятирэ гава тэ пригытон вся. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Нэ мануша, савэ жувэнас котэ, на прилинэ Лэс, колэстар со Вов жалас андо Иерусалимо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Лэстирэ сытярнэ, Иаково тай Иоано, дикхле када и пхэндэ: — Рай! Камэс, амэ припхэнаса ягати тэ сжал пав болыбэн и всаворэн лэн тэ спхабарэл? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","56","Исусо обрисайля, запхэндя лэнди. И онэ жыле андэ авэр гав. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Сар онэ жанас пав дром, екх мануш пхэндя Исусости: — Мэ жава пала Тутэ андо всаворэ тхана, кай Ту жаса. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Исусо пхэндя лэсти: — Кай лисоря исин тхана, кай онэ жувэн, и кай чирикля болыбнастирэ — пэско тхан, а Шавэсти Манушыканэсти най кай шэро тэ тховэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Аврэсти манушэсти Исусо пхэндя: — Жа пала Мандэ. Кодва пхэндя: — Рай, дэ манди майанглал тэ жав и тэ гаравав пэстирэ дадэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","— Мэк мулэ ежэнэ гаравэн пэстирэн мулэн, а ту жа и роспхэн пала Тхагаримос Дэвлэско, — пхэндя лэсти Исусо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Инке екх мануш пхэндя Лэсти: — Рай, Мэ жава пала Тутэ! Нэ дэ манди майанглал тэ жав и тэ дикхав пэско йири. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Исусо пхэндя: — Ни екх мануш, саво тховэла васт пэско по плуго и обдикхэлпэ палпалэ, на поджал важ Тхагаримос Дэвлэско. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Тунчи о Рай вытидя инке эхтадэш сытярнэн и бишалдя по дуй англал Пэстэ андэ всаворэ фороря и тхана, каринг камэлас Ежэно тэ жал. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Вов пхэндя лэнди: — Пэ мал вся выбариля, трэбуй тэ стидэ, а бутярнэн цыра. Мангэн Хулас, кай Вов тэ выбишалэл бутярнэн пэ мал тэ стидэ вся, со бариля. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Жантэ! Мэ бишалав тумэн, сар бакрорэн машкар рува. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","На лэн пэса ни тышыла, ни траста, ни пэрналэ, и никаса пав дром на ашэн тэ дэн дума. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Кала авэна тэ зажан андо чер, майанглал пхэнэн: «Тэ авэн бахталэ». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Сар андэ кодва чер жувэл шаво бахтатиро, тунчи авэла пэр лэстэ бахт тумари, а сар на прилэла, тунчи тумари бахт рисавэла тумэндэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Андо кодва чер ашэнпэ, на пэрэжан андав чер черэстэ, хантэ и пэнтэ кода, со лэндэ исин. Ко терэл бути, вов ашэл, кай лэсти тэ потинэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Сар тумэ зажана андо форо и тумэн котэ прилэна, хантэ вся, со тумэнди дэна, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","састярэн лэндирэ насвалэн, савэ котэ исин, тай пхэнэнтэ лэнди: «Тхагаримос лэ Дэвлэско пашыля тумэндэ». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Сар тумэ зажана андо екх форо и тумэн котэ на прилэна, жан пай гасы калэ форостирэ и пхэнэн: ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","«И о прахо тумарэ форостар, саво приашыля кай амарэ пэрнэ, амэ обмарас пэр тумэндэ. Нэ жанэн: Тхагаримос Дэвлэско пашэ!» ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Пхэнав тумэнди, со андо кодва дес Содомостирэ манушэнди авэла майлокхо, сар калэ форости. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Бида тути, форо Хоразино! Бида тути, форо Вифсаида! Сар андэ фороря Тиро и Сидоно тэ авэл тердо скачи диворя, сар тумэндэ, то дэлмут онэ урявдэпэ андэ кали йида и бэшэнас андо пепло, каисавэнас. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Но Тирости и Сидоности авэла фэдэр по сындо, сар тумэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","И ту, Капернаумо, гындос, кай авэса вазгло кав болыбэн? Най, ту авэса сшуто андо адо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Тунчи Вов пхэндя сытярнэнди: — Ко ашунэл тумэн, ашунэл Ман, а ко отпхэндёл тумэндар, и Мандар отпхэндёл. А ко отпхэндёл Мандар, отпхэндёл Колэстар, ко бишалдя Ман. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Эхтадэш сытярнэн рисайле кав Исусо радомаса: — Рай, — пхэнэнас онэ, — и бэнга кандэн амэн, кала амэ припхэнас лэнди Тирэ алавэса! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Исусо пхэндя: — Мэ дикхлем, сар о Сатана пэля пав болыбэн, сар молния! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Акэ, Мэ дав тумэнди баримос тэ тасавэн сапэн и скорпионон, тай всавори вражымастири зор, ай тумэнди нико на терла бида. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Нэ радосавэн на колэсти, со духоря кандэн тумэн, ай радосавэн колэсти, со тумарэ алава запистросардэ по болыбэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Андэ кодья вряма Исусо радосайля андо Свэнто Духо и пхэндя: — Мэ лашарав Тут, Дадэ, Рай Дэл по болыбэн и пэ пхув, пала кода, со Ту гаравдян када годявэр и сытярнэ манушэндар и отпхэрнадян када бэяцэнди. Кадя, Дадэ, када сас Тири лащи воля! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Дад отдя Манди вся. Нико на жанэл, ко исин Шаво, качи о Дад. И нико на жанэл, ко исин Дад, сар качи о Шаво и кодва, касти Шаво камэл тэ отпхэрнавэл Лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Тунчи Вов обрисайля кай Пэстирэ сытярнэ, пхэндя кадя: — Бахталэ якха, савэ дикхэн кода, со тумэ дикхэн! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Мэ пхэнав тумэнди, со бут пророкоря и тхагара камэнас тэ дикхэн кода, со тумэ дикхэн, и на дикхле, и камэнас тэ шунэн кода, со тумэ ашунэн, и на ашундэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Катэ вщиля екх сытяримари Законоско и пушля кав Исусо, камля тэ астарэл Лэс по лав. — Сытяримари, со манди тэ терав, кай мэ тэ лав жувимос вакоско? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","— А со пхэнэлпэ андо Законо? — пушля лэстар Исусо. — Со ту котэ бинэс? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Вов пхэндя: — Кам Раес, Дэвлэс тирэс, всаворэ водеса тирэса, и всаворэ жувимаса тирэса, и всаворя зораса тиряса, и годяса тиряса. И кам пашэс тирэс, сар ежэно пэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","— Чячес ту пхэндян, — пхэндя лэсти Исусо. — Тер кадя, и ту авэса тэ жувэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Сытяримари Законоско камля тэ допхэнэл, кай вов на ужыло, пхэндя Исусости: — А ко мэрно пашо? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Пэ када пхэндя Исусо: — Екх мануш жалас андав Иерусалимо андо Иерихоно. Пав дром пэр лэстэ хукле прахаря, савэ злинэ пар лэстэ йида, мардэ фартэ и ужыле, ашадэ лэс тэ мэрэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Кадя прижыляпэ, пав кода дром жалас рашай. Сар удикхля калэ манушэс, обжыля лэс пай авэр риг дром. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Кадя ж тердя и левито: дожыля кай кадва тхан, удикхля лэс и обжыля ригаса. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Колэ дромэса прожалас и самарянино, удикхля лэс и тангосардя. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Вов поджыля, прохаладя и помакхля оливково дзэтоса и молэса раноря, пэрэпхангля лэн. Тунчи тходя лэс пэ пэско осло, андя лэс андэ гостиница и котэ инке додикхэлас пала лэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Пэ авэр дес, кала вов уладэлас, дя хуласти андай гостиница дуй динария и пхэндя: «Придикх пала лэстэ, ай сар мэ авава тэ рисавав, сар ту потинэса майбут, мэ роспотиндювава туса». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ко андай кала трин, пав тиро, сас майпашэ калэсти манушэсти, саво попэля кай прахаря? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Сытяримари Законоско пхэндя: — Кодва, ко сикадя лэсти тангимос. Тунчи Исусо пхэндя лэсти: — Жа и ту тер кадя ж. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Пав дром Исусо лэ сытярнэнца зажыля андэ екх гав. Котэ жувли, савя акхарэнас Марфа, акхардя Лэс андо пэско чер. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Латэ сас пхэй, савя акхарэнас Мария. Вой бэшля пашай пэрнэ Раестирэ и шунэлас, со Вов пхэнэлас. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Марфа прастэлас кордэ палпалэ, терэлас и подэлас о хамос пэ мэсали. Вой поджыля кав Исусо и пхэндя: — Рай! Ту на дикхэс, кай мэрни пхэй екха ман ашадя тэ терав бути? Пхэн лати, кай вой тэ поможысарэл манди! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","— Марфо, Марфо, — пхэндя Рай, — ту гындос и терэс бут со. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","А трэбуй качи екх. Мария вытидя, со майфэдэр, и када латар на залэлапэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Екхварэс Исусо андэ екх тхан мангэлас Дэвлэс, и сар Вов пэрэашыля, екх андай сытярнэ мангля Лэс: — Рай! Сытяр амэн тэ мангас Дэвлэс, сар о Иоано сытярдя пэстирэ сытярнэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Вов пхэндя лэнди: — Кала тумэ мангэн Дэвлэс, пхэнэн кадя: Дадэ! Мэк всаворэ лашарэн Тиро свэнто алав! Мэк авэл Тхагаримос Тиро! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Марно, саво трэбуй амэнди, подэ амэнди пэ кадва дес. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","И эртисар амэнди амарэ бэзэха, колэсти со и амэ эртисарас всаворэнди, ко амэнди ужыло. И на домук тэ подаспэ кав бэзэх. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Тунчи Исусо пхэндя лэнди: — Сар варикастэ тумэндар исин амал, и тумэ авэна лэстэ андэ епаш рят и пхэнэна: «Амал, дэ манди андо ужылимос трин марнэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Мандэ дромэстар залагля амал мэрно, и манди нинай, со тэ дав лэсти». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","А кодва андрал андав чер пхэнэла лэсти: «На замисар ман! Удар затердэ, и бэяцэ мэрнэ манца по пато. Най сар тэ вщав и тэ дав тути». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Пхэнав тумэнди, сар вов на вщела и на дэла колэсти, со вов исин лэско амал, пала кода со тумэ на пэрэашэн тэ мангэн, вов вщела и дэла, со тумэнди трэбуй, кай лэсти тэ на авэл лажаво. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Пхэнав тумэнди: мангэн — и о Дэл дэла тумэнди, родэн — и аракхэна, марэн андэ удар — и о Дэл отпхэрнавэла тумэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Кодва, ко мангэл — лэл, ко родэл — аракхэл, и ко марэл андэ удар — колэсти отпхэрнавэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Исин машкар тумэндэ кацаво дад, саво дэла пэстирэ шавэсти сапэс, сар вов мангэл мащё? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Сар мангэла парноро, дэла лэсти скорпионо? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Кала тумэ холятирэ, ай пэстирэ бэяцэнди дэн лашымос, майфартэ Дад тумаро болыбнаско дэла Свэнтонэс Духос колэнди, ко мангэл Лэстар. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Екхвар Исусо вытрадя бэнгэс, саво терэлас манушэс мутонэса. И кала бэнг выжыля, мануш, саво сас муто, задя дума. Мануша дивосайле. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Коисавэ пхэнэнас: — Вов вытрадэл бэнгэн зораса, сави дэл Веельзевуло, пхурэдэр бэнг. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ай авэр камэнас тэ зумавэн лэ Исусос, тай мангле, кай Вов тэ сикавэл шпэра пав болыбэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Исусо жангля, со онэ гындон, пхэндя лэнди: — Кажно тхагаримос, саво машкар пэстэ вражымари, авэла шушо, и чер, кай вражымаря машкар пэстэ, пэрэла. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Сар о Сатана вражымари ежэно пэсти, сар утэрдёла тхагаримос лэско? Тумэ пхэнэн, со Мэ зораса, сави дэл Веельзевуло вытрадав бэнгэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Сар Мэ вытрадав бэнгэн зораса, сави дэл Веельзевуло, тунчи савя зораса вытрадэн лэн тумарэ шавэ? Колэсти онэ авэна тумэнди сындомаренца. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","А сар Мэ вытрадав бэнгэн Дэвлэстиря зораса, тунчи авиля тумэндэ Тхагаримос Дэвлэско. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Кала зорало мануш лэ мардянца мишто дикхэл пала пэско чер, тунчи лэско хулаимос нико на обчёрэла. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Кала майзор лэстар хукэла пэр лэстэ, тунчи помарэла лэс тай залэла лэстар мардя, савэнца вов гындолас тэ фэрисарэлпэ, вся, со исин андо чер, залэла и роздэла. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ко на екхэтанэ Манца, кодва жал пэр Мандэ; и ко на стидэл Манца, кодва росшол. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Кала найжужо духо выжал андав мануш, вов пхирэл пай бипаестирэ тхана, родэл, кай тэ отчиёл, и на аракхэл. Тунчи вов пхэнэл: «Рисавава мэ андо чер, катар выжылем». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Кала вов рисавэл, дикхэл, со чер лэско жужардо и притидо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Тунчи вов жал и лэл пэса эхта аврэн духон, майхолятирэн пэстар, и онэ зажан и жувэн котэ. И када важо мануш инке майвырито, сар сас майанглэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Сар Вов инке дэлас дума, тунчи екх жувли зацыписайля андай мануша, савэ стидэпэ котэ: — Бахтали кодья дэй, сави бэяндя и выправардя Тут! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Исусо пхэндя пэ када: — Бахталэ кола, ко ашунэн Дэвлэско лав и терэн, сар Вов пхэнэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Сар манушэн стидяпэ майбут, Исусо ля тэ дэл дума: — Кадва родо — холяко. Вов родэл шпэра, нэ лэсти на дэлапэ нисави шпэра, качи шпэра Ионастири. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","И сар Иона сас шпэра важ ниневитяноря, кадя Шаво Манушыкано авэла шпэра важ кадва родо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Тхагарни пав юго ваздёла по сындо манушэнца калэ родостар и сындосарэла лэн, колэсти со вой пай авэр риг пхув авэлас тэ пошунэл годяримос Соломоноско, и акэ, катэ майбаро Соломоностар. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ниневитяноря ваздёна по сындо лэ манушэнца калэ родостар и сындосарэна лэн, колэсти со онэ ашадэ бэзэх пэско лавэндар, савэ пхэндя Иона. И акэ, катэ майбаро Ионастар. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Нико, ко запхабарэл каганцо, на тховэл лэс по тхан, кай лэс нико на дикхэла, или талай кхоро. Нэ тховэн лэс упрэ, кадя, кай, ко зажала, тэ дикхэл удуд. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Тирэ якха — удуд важ тиро тило. Кала тирэ якха жужэ, тунчи и ту всаворо пхэрдо удудэса. Ай сар тутэ найлашэ якха, тунчи тило тиро пхэрдо калимаса. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Колэстар дикх, удуд, саво андэр тутэ, на калимос? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Акэ, сар тиро тило пхэрдо удудэса и андэр лэстэ нинай нисаво калимос, тунчи ту всаворо авэса пхэрдо удудэса, сар молниятар шолпэ пэр тутэ лако удуд. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Кала Исусо када пхэнэлас, екх фарисеё акхарда Лэс пэстэ тэ хал. Исусо жыля тай бэшля палай мэсали. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Фарисеё дивосайля, со Вов на халадя и васт, англал сар тэ бэшэл тэ хас. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Рай пхэндя лэсти: — Акэ тумэ, фарисеёря, жужарэн чярэ и тарелки упрал, ай андрал тумэ исин скумпо и холятирэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Бигодятирэ! Кодва, Ко тердя упрал, на тердя ли и андрал? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Дэнтэ чёрорэнди, колэстар, со тумэндэ исин, и тунчи вся важ тумэнди авэла жужо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Бида тумэнди, фарисеёря! Тумэ дэн дэшто котор пай мята, рута и пай всавори зэлэнь, ай чячимос и камлимос Дэвлэско забистарэн. И када трэбуй тэ терэн, и кода тэ на ашавэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Бида тумэнди, фарисеёря! Тумэ камэн тэ залэн майлашэ тхана андэ синагоги и кай мануша тумэнди тэ пхэнэн пэ барэ грады: «Тэ авэн бахталэ». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Бида тумэнди! Тумэ — сар склэпоря, савэ на душон, пай савэ мануша пхирэн и на жанэн, кай онэ котэ исин. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Екх андай сытяримаря Законостирэ пхэндя Лэсти: — Сытяримари! Кала думаса и амэн обмукэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Исусо пхэндя: — Бида и тумэнди, сытяримаря Законостирэ! Тумэ тховэн пэ мануш траста, сави пхарэс тэ андярэ, ай ежэнэ и наеса кадэла трастатэ на лэнпэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Бида тумэнди! Тумэ тховэн шукарнэ памятникоря пророконэнди, савэн умардэ тумарэ дада. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Калэса тумэ подритярэн рындоря тумарэ дадэндирэ. Онэ умардэ пророкон, а тумэ терэн важ лэнди памятникоря. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Колэсти годяримос Дэвлэско пхэндя: «Мэ бишалава лэндэ пророкон и апостолонэн, и онэ екхэн умарэна, ай аврэн вытрадэна». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Колэстар кадва родо потинэла палав всаворо рат пророкэндиро, саво сас прошуто кола вряматар, кала тердяпэ люма, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","лэ ратэстар Авилёстирэстар кав рат Захарияско, саво сас умардо машкар жэртвенико и храмо. Кадя, пхэнав тумэнди, пушэлапэ калэ родостар. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Бида тумэнди, сытяримаря Законостирэ! Тумэ залинэ тии лэ джянглимастар, нэ ежэнэ на зажыле и затердэ дром колэнди, ко зажал. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Кала Исусо выжыля андав чер, сытяримаря Законостирэ и фарисеёря фартэ холяйле пэр Лэстэ, долэнас Лэс и бут пушэнас Лэстар. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Онэ родэнас, сар тэ астарэн Лэс по лав. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Андэ кодья вряма стидэпэ бут мануша, кадя со тасавэнаспэ машкар пэстэ. Исусо ля тэ пхэнэл майанглал Пэстирэ сытярнэнди: — Фэрисавэн фарисеёнэндиря закваскатар, кай тэ на авэн тумэ дуемуендирэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Нинай нисо гарадо, со на отпхэрнавэлапэ, и нисо чёрэхано, со на ужандёла. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Со тумэ пхэнэн чёрэханэс рятяса, кода ашундёла десэ; и со тумэ пхэнэнас тыхо андрэ андо чер, авэла тэ цыписавэлпэ упрал пай чера. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Мэ пхэнав тумэнди, Мэрнэ амалэнди: на даран колэндар, ко умарэла тило и будэр нисо на терэла. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Мэ сикавава тумэнди, Кастар трэбуй тэ даран: даран Колэстар, Ко на качи умарэла, но исин Лэстэ баримос тэ шол андо геена. Чячес пхэнав тумэнди, Лэстар даран. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Най панч цэкнэ чирикля битиндён пала дуй копийки? И ни пала екх лэндар о Дэл на бистардя. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","А тумэндэ и бал по шэро всаворэ побиндэ! На даран — тумэ майкуч бутэ цэкнэ чирикляндар. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Пхэнав тумэнди: всаворэ, ко прижанэна Ман англай мануша, и Шаво Манушыкано прижанэла колэс англай ангелоря Дэвлэстирэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","А ко отпхэндёла Мандар англай мануш, колэстар и Вов отпхэндёла англай ангелоря Дэвлэстирэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Всаворэ, ко пхэнэла вырито лав по Шаво Манушыкано, эртисардёла лэсти, а ко пхэнэла вырито лав пэ Свэнто Духо, колэсти на эртисардёла. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Кала тумэн андярэна андэ синагоги, кай пхурэдэра и барэ рая, на гындон пала кода, сар тэ фэрисарэн пэс и со тэ пхэнэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Свэнто Духо сытярэла тумэн, со андэ кодья вряма трэбуй тэ пхэнэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Варико андай мануш пхэндя Исусости: — Сытяримари! Пхэн мэрнэ пхралэсти, кай вов тэ дэл котор андар хулаимос, саво ашыляпэ амэнди дадэстар. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Исусо пхэндя: — Мануш, ко тховдя Ман тэ сындосарав тумэн и тэ роздав тумаро хулаимос машкар тумэндэ? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Вов пхэндя лэнди: — Дикхэн, кай тэ на стидэн бут барвалимос. Вов тумаро жувимос бахталэса на терэла. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Тай Исусо роспхэндя лэнди дума: — Екхэ барвалэ манушэстэ бариля пэ мал бут ворзо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Тай вов гындолас пэсти: «Со манди тэ терав? Най кай мандэ тэ тхав кода, со выбариля». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Тунчи Вов пхэндя: «Акэ со мэ терава: пхагава пусына мэрнэ и терава авэр майбарэ, стидава тай тхава о ворзо и всаворо барвалимос мэрно кордэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Тунчи мэ пхэнава пэстирэ жувимасти: \"Ай, жувимос мэрно! Акана бут барвалимос пашлёл тутэ, пэ бут бэрша хутилэла. Отчиюв, ха, пи и радосав!\"» ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","О Дэл пхэндя лэсти: «Бигодяко! Адес андэ кадья рят залэна тутар жувимос тиро. Касти доросэлапэ када, со ту гытосардян?» ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Кадя авэла всаворэнца, ко стидэл барвалимос важ пэсти, а на стидэл барвалимос важ о Дэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Тунчи Исусо пхэндя пэстирэ сытярнэнди: — Важ кода Мэ пхэнав тумэнди: на пэрэжувэн пала тумаро жувимос, со тумэнди тэ ха, и пала тило, андэр со тумэнди тэ урядён. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Жувимос майкуч хамастар, и тумаро тило майкуч йидатар. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Подикхэн пэ вороноря: онэ на шон ворзо и на стидэн, нинай пэстирэ пусына и амбароря, но о Дэл праварэл лэн. Пэ скачи тумэ фэдэр чирикляндар! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ко ж тумэндар, грыжатар, терэла майлунго пэско жувимос пэ екх чясо? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Сар тумэ на стерна када найбаро рындо, состар грыжонпэ пала вся авэр? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Подикхэн, сар барён лулудя. Онэ на терэн бути и на сувэн пэсти йида, нэ пхэнав тумэнди, со Соломоно андай всаворо пэско барвалимос и баримос на урявдяпэ кадя, сар екх лэндар. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Сар о Дэл кадя урявэл чяр пэ мал, сави адес исин, а тэся шона ла андо бов, чи на урявэла Вов и тумэн, ко цыра патял? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","На родэн, со тумэнди тэ ха тай со тэ пэ, и на грыжавэн пала када. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Всаворэ народоря кала люматирэ качи гындосарэн пала када. Ай тумаро Дад жанэл, со тумэнди трэбуй вся када. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Родэн фэдэр Лэско Тхагаримос, а када вся додэна тумэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","На даран, найбаро стадо! Дад тумаро камэл тэ дэл тумэнди Тхагаримос. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Битинэн тумаро хабэ и дэн чёрорэнди. Терэн пэсти кацавэ тышылы, савэ на спхиравэнпэ, барвалимос по болыбэн, саво на цэкнёл, каринг ни чёр на дожала, ни моль на схала. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Кай тумаро барвалимос, котэ авэла и води тумаро. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Авэнтэ гытомэ: йида пэр тумэндэ мэк авэла пэрэпхангли кущикаса, и мэк пхабон тумарэ каганцоря. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Авэнтэ сар бутярнэ, савэ ажутярэн пэстирэс хулас пав ябьяв. Кала хулай авэла и марэла андэ удар, онэ андэ кодья вряма отпхэрнавэна лэсти. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Бахталэ кола бутярнэ, савэн о хулай, сар рисавэла, аракхэла лэн, кай на совэн. Чячимаса пхэнав тумэнди, вов тунчи ежэно пэрэпхандёла кущикаса, бэшлярэла лэн палай мэсали и авэла тэ подэл важ лэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Бахталэ кола бутярнэ, савэн хулай аракхэла, кай онэ ажутярэн лэс андэ епаш рят, и тэсара. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Жанэнтэ, сар тэ жанэл о хулай лэ черэско, андэ сави вряма авэла чёр, вов на домэкэлас бы, кай вов тэ загулел андо чер. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","И тумэ авэнтэ гытомэ, колэстар со Шаво Манушыкано авэла андэ кодья вряма, андэ сави тумэ на ажутярэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Пэтро пхэндя: — Рай, Ту пхэнэс кадья дума качи амэнди чи всаворэнди? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Рай пхэндя: — Саво исин патимаско и годяко пхурэдэр бутярно андо чер, савэс о хулай тховдя пашай пэстирэ бутярнэ, кай тэ роздэл хамос лэнди пай вряма? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Бахтало кодва бутярно, савэс о хулай, кала рисавэла, удикхэла, со вов кадя терэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Пхэнав тумэнди чячимаса, калэс бутярнэс хулай тховэла пэ всаворо пэско хабэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","А сар кодва бутярно пхэнэла андэ води: «Мэрно хулай авэла на сыго», — и авэла тэ марэ бутярнэн и бутярнян, тэ ха и тэ пэ, кай тэ матёл, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","тунчи авэла лэско хулай андо дес, кала вов на ажутярэл, и андэ кодья вряма, кала вов на жанэл. Вов росшынэла по епаш лэс и дэла лэсти екх шана найпатимастирэ манушэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Кодва бутярно, саво жанэлас, со камэл хулай, и на терэлас, сар камля хулай, нэ на сас гытомэ и на терэлас, авэла фартэ мардо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","А кодва, саво на жанэлас, и терэлас кода, пала со трэбуй тэ марэн, мардо авэла цыра. Касти сас бут дино, колэстар и бут замангэна, и касти бут дэласпэ, майбут пушэлапэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Мэ авилем тэ анав яг пэ пхув, и сар Мэ камав, соб вой икхатар тэ роспхаболпэ! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Манди трэбуй тэ прожав болдимос, и сар Мэ грыжосавав, кала када терэлапэ! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Тумэ гындосарэн, Мэ авилем, кай тэ анав пэ пхув миро? Най, пхэнав тумэнди, мэ авилем тэ анав вражымос. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Йири андай панч мануш розжалапэ: трин англай дуй, и дуй англай трин. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Дад розжалапэ лэ шавэса, ай шаво лэ дадэса; дэй розжалапэ ла щяса, ай и щей пэстиря даса; свэкруха розжалапэ ла боряса, ай и бори ла свэкрухаса. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Исусо пхэндя лэ манушэнди: — Сар тумэ дикхэн по западо тучя, андэ кодья вряма пхэнэн, со авэла брышынд, и кадя терэлпэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Кала пхурдэл тати балвал пав юго, тумэ пхэнэн: «Авэла фартэ тато», — и кади терэлпэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Дуемуендирэ! Тумэ жанэн, сар тэ полэн шпэры по болыбэн и пэ пхув, а состар на полэн, сави икхатар авиля вряма? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Важ со тумэ ежэнэ на сындосарэн, андэр со о чячимос? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Сар жас тирэса вражымареса кав пхурэдэр, допхэнпэ лэса пав дром. Сар када на терэса, вов тут андярэла кав сындомари, ай о сындомари отдэла тут халавдэнди, а халавдэ бэшлярэна тут андо баруно. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Пхэнав тути, со на выжаса котар, аж сар на выпотинэса всаворэ ловэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Тунчи кав Исусо авиле варисавэ мануша и роспхэндэ Лэсти пала галилеяноря, савэн Пилато припхэндя тэ умарэн андэ кодья вряма, кала онэ анэнас жэртворя. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Исусо пхэндя: — Тумэ гындосарэн, со кала галилеяноря хасайле, колэстар со онэ сас майбэзэхалэ всаворэндар? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Най, пхэнав тумэнди! Нэ сар тумэ на каинапэ, тумэ кадя ж всаворэ хасавэна. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ай кола дэшуохто мануша, савэ хасайле, кала пэля пэр лэндэ Силоамоско башня? Тумэ гындосарэн, онэ сас майужылэ всаворэндар колэндар, ко жувэлас андо Иерусалимо? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Най, пхэнав тумэнди! Нэ сар тумэ на каинапэ, кадя хасавэна. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Тунчи Исусо роспхэндя лэнди дума: — Екхэ манушэстэ андо винограднико барёлас дрэво инжыроско. Екхвар вов жыля тэ родэл пэр лэстэ плодоря и нисо на аракхля. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Тунчи вов пхэндя пэстирэсти виноградорести: «Акэ, трин бэрш мэ авав тэ родав пэ кадва инжыро плодоря и нисо на аракхав. Спхаг лэс, пэр со вов залэл пхув?» ");
INSERT INTO rmyvlakh_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","«Хулай, — пхэндя кодва, — ашав лэс инке пэ кадва бэрш. Мэ лэс обганавава, тхава пэрэгноё, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","и ко жанэл, чи вов на анэла плодоря пэ авэр бэрш? Ай сар на анэла, тунчи спхагэса лэс». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Андэ субота Исусо сытярэлас андэ екх синагога. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Котэ сас жувли, савятэ дэшуохто бэрш сас духо насвалимаско. Латэ сас банго думо, и вой нисар на тэрдёлас ворта. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Кала Исусо удикхля ла, Вов выакхардя ла англэ тай пхэндя: — Жувлиё! Ту састярэспэ пэстирэстар насвалимастар. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Вов тховдя пэр латэ васта, и вой андэ кодья вряма тэрдиля ворта и ля тэ лашарэл лэ Дэвлэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Пхурэдэр синагогако холяйля, со Исусо састярдя андэ субота, и пхэндя лэ манушэнди: — Исин шов деса, андэ савэ трэбуй тэ терэ бути. Андэ кола деса авэн и састярэнпэ, нэ на андэ субота. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Пэ када Рай пхэндя лэсти: — Дуемуендирэ! Кажно тумэндар андэ субота чи на отпхандэл пэстирэс гурувэс тай ослос и на выандярэл лэн андай пусын и на андярэл тэ дэл паи? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ай када исин екх андай щея Авраамостирэ, савя спхангля Сатана дэшуохто бэрша. На трэбуй ли сас тэ роспхандэ андэ субота лэпунзэ кала жувляти? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Кала Вов пхэндя када, всаворэнди Лэстирэ вражымаренди тердяпэ лажаво, а всаворэ мануш радонаспэ пала барэ рындоря, савэ Вов терэлас. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Исусо пхэндя: — Пэр со мэзимэ Тхагаримос Дэвлэско? Сар тэ роспхэнав пала лэс? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Вов — сар горчично ворзо, саво о мануш ля тай шутя андэ пэстирэ баря. Ворзо выбариля и ашыля барэ дрэвоса, кадя, со чирикля болыбнастирэ жувэнас пэр лэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Инке Вов пхэндя: — Пэр со мэзимэ Тхагаримос Дэвлэско? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Вов — сар заквашэно хумэр, саво и жувли ля и тховдя андэ трин толоря варо, тай всаворо хумэр вазгляпэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Исусо прожалас пай фороря тай гава, сытярэлас лэ манушэн. Вов жалас андо Иерусалимо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Варико пхэндя Лэсти: — Рай! Качи цыра манушэн авэна фэрисардэ? Исусо пхэндя: ");
INSERT INTO rmyvlakh_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","— Терэн вся, кай тэ зажан андэ санэ удара. Пхэнав тумэнди, бут авэна тэ родэн, кай тэ зажан, тай на зажана. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Кала о хулай лэ черэско вщела тай затерэла и удар, тумэ авэна тэ тэрдён андрал, тэ марэн андэ удар и тэ мангэнпэ: «Хулай, отпхэрнав амэнди!» Ай Вов пхэнэла: «На жанав тумэн, катар тумэ». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Тунчи тумэ пхэнэна: «Амэ хасас и пасас англай Тирэ якха, ай Ту сытярэсас пэ амарэ гасы». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Нэ Вов пхэнэла: «Мэ на жанав тумэн, катар тумэ, отжан Мандар, всаворэ, савэ терэн найлашэ рындоря». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Котэ авэла ровимос и бари грыжа, кала дикхэна лэ Авраамос, Исаакос и Иаковос, и всаворэн пророкон андо Тхагаримос Дэвлэско, ай тумэ авэна вытрадэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Авэна мануша пав востоко и западо, северо и юго и бэшэна палай мэсали андо Тхагаримос Дэвлэско. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Тунчи палатунэ авэна англал, ай англатунэ авэна палал. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Тунчи кав Исусо поджыле фарисеёря и пхэндэ: — Ужа, ашав кадва тхан, колэсти со Иродо камэл Тут тэ умарэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Исусо пхэндя: — Жантэ и пэрэдэнтэ калэсти хрантимарести: «Адес и тэся мэ авава тэ вытрадав бэнгэн и тэ састярав манушэн, ай по трито дес Мэ дотерава Пэско рындо». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Нэ адес, тэся и палтэся Мэ трэбуй тэ жав, колэсти со на терэлпэ кадя, кай пророкос тэ умарэн на андо Иерусалимо! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Иерусалимо! Иерусалимо! Ту умарэс лэ пророкон и марэс барэнца колэн, кас бишалэн тутэ! Скачи молоря Мэ камлем тэ стидав тирэн бэяцэн, сар и кагни стидэл пэстирэ пуёнэн паша пэстэ, а тумэ на закамле! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Акана тумаро чер ашэлпэ шушо. Пхэнав тумэнди, кала тумэ удикхэна Ман андэ авэр моло, тунчи пхэнэна: «Лашардо Кодва, Ко авэл важ алав Рае Дэвлэско!» ");
INSERT INTO rmyvlakh_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Екхвар андэ субота Исусо авиля екхэстэ андай пхурэдэр фарисеёря тэ хал марно, и онэ дикхэнас пала Лэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Котэ бэшэлас англав Исусо мануш, савэстэ сас паеско насвалимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Исусо пушля кай фарисеёря и сытяримаря Законостирэ: — Домукэлпэ тэ састярэл андэ субота? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Онэ ашэнас мулком. Исусо ляпэ кав мануш, састярдя лэс и отмэкля. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Тунчи Вов пхэндя лэнди: — Сар варикастэ тумэндар шаво или гурув пэрэла андэ хаинг, на вылэна тумэ андэ кодья ж вряма андэ субота? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Лэнди найсо сас тэ пхэнэн пэ када. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Исусо додикхля, сар кола, кас акхардэ, вытидэнас майфэдэр тхана палай мэсали, тай роспхэндя екх дума: ");
INSERT INTO rmyvlakh_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","— Кала варико акхарэла тут по ябьяв, на бэш пэ англуно тхан. Колэсти со котэ авэла мануш майфэдэр тутар, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","и хулай, саво акхардя тут и лэс, поджала тутэ и пхэнэла: «Дэ тхан калэсти манушэсти». И тути прижалапэ лажаимаса тэ бэшэс по палатуно тхан. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Нэ сар тут акхардэ, жа и бэш по палатуно тхан. Тунчи о хулай поджала тутэ и пхэнэла: «Амал, пэрэбэш по майфэдэр тхан». Тунчи тути авэла бари шана англай мануша, савэ бэшэн туса палай мэсали. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Всаворэ, ко ваздэл пэс, авэла тэлярдо, а ко тэлярэл пэс, авэла вазгло. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Тунчи Исусо пхэндя манушэсти, саво акхардя Лэс: — Кала тховэс мэсали, на акхар лэ амалэн, лэ пхралэн, манушэн тирэ родостар тай лэ барвалэн, савэ паша тутэ жувэн. Колэсти со и онэ акхарэна тут пэстэ и рисарэна тути тиро лашымос. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Нэ сар ту тховэс мэсали важ мануша, акхар чёрэн, попхаглэн, бангэн тай корэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Тунчи ту авэса бахтало, колэстар со онэ на отдэна тути кода, со ту дян, и тунчи тути потинэлапэ, кала жундёна чячимастирэ мануша. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Кала екх андай кола, ко бэшэлас палай мэсали, ашундя када, вов пхэндя Исусости: — Бахтало, ко авэла тэ хал марно андэ Тхагаримос Дэвлэско! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Исусо пхэндя лэсти: — Екх мануш тердя баро свэнко и акхардя бутэн манушэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Кала авиля и вряма тэ бэшэн палай мэсали тэ хан, вов бишалдя пэстирэс бутярнэс тэ акхарэл акхардэн: «Авэнтэ, вся гытомэ». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Онэ екх палай аврэстэ линэ тэ мангэн патив. Екх пхэндя: «Мэ тиндэм пхув, и манди трэбуй тэ жав тай тэ дикхав ла. Мангав тут, эртисар ман». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Авэр пхэндя: «Мэ тиндэм дэшэн гурувэн тай жав тэ дикхав лэн, савэ онэ андэ бути. Мангав тут, эртисар ман». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Трито пхэндя: «Мэ лем ромня, колэсти най сар тэ авав тутэ». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Бутярно рисайля и роспхэндя пэстирэсти хуласти. Тунчи о хулай лэ черэско холяйля и пхэндя пэстирэсти бутярнэсти: «Жа майсыго пай барэ и цэкнэ гасы форостирэ и ан кардэ чёрэн, попхаглэн, корэн тай бангэн». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","«Хулай, — пхэндя бутярно, — кода, со ту припхэндян, вся тердэм, и инке исин тхан». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Тунчи хулай пхэндя пэстирэ бутярнэсти: «Жа пай дрома и паша грады и манг, кай тэ авэн кардэ, кай о чер мэрно тэ авэл пхэрдо манушэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Пхэнав тумэнди, со нико колэндар, кас мэ акхаравас майанглал, на хала пай мэрни мэсали». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Лэ Исусоса жанас бут мануша, и Вов обрисайля лэндэ тай пхэндя: ");
INSERT INTO rmyvlakh_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","— Сар ко авэл Мандэ и на камэла Ман майфартэ пэстирэ дадэстар, датар, ромнятар, бэяцэндар, пхралэндар, пхэяндар и пэстирэ жувимастар, кодва нисар на авэла Мэрнэса сытярнэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Кодва, ко на андярэл пэско трушул и на жал пала Мандэ, нисар на авэла Мэрнэ сытярнэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ко тумэндар закамэла тэ терэл башня и майанглал на бэшэла тэ пэрэбинэл, скачи када авэла тэ ашэл, хутилэла лэстэ ловэ, кай тэ стерэл ла? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Кала тховэла фундаменто, нэ на дотерэла, кола, савэ дикхэна када, авэна лэстар тэ асан ");
INSERT INTO rmyvlakh_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","и тэ дэн дума: «Кадва мануш ля тэ терэл и на дотердя». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Саво тхагар жала маримаса пэ авэр тхагар, майанглал на бэшэла и на пэрэбинэла, исин лэстэ зор дэшэ барянца халавдэнца тэ утэрдёл англай дуй дэша баря халавдэ? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","А сар най, то кала о вражымари инке дур, лэла и бишалэла пэстирэ манушэн тэ мангэн миро. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Кадя, ко тумэндар на отпхэндёла всаворэстар, со лэстэ исин, нисар на авэла Мэрнэ сытярнэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Лон — лашо, нэ сар о лон хасарэла пэско лондимос, сар терэса, кай тэ авэл лондо? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ни андэ пхув, ни андэ пэрэгноё на поджал; и вышон лэс аври. Кастэ исин кана тэ ашунэн, мэк ашунэн! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Тэ пошунэн Исусос стидёнас всаворэ стидэмаря налогонэндирэ тай авэр бэзэхалэ мануша. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Фарисеёнэнди тай сытяримаренди Законостирэ на чялёлас када, и онэ пхэнэнас: — Вов прилэл бэзэхалэн манушэн тай хал лэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Тунчи Исусо роспхэндя лэнди кацави дума: ");
INSERT INTO rmyvlakh_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","— Ко тумэндар, кастэ исин шэл бакрэ, и хасардиля екх лэндар, на ашавэла инядэш иня бакрэн андэ мал и на жала тэ родэл кола, сави хасайля, жы кодла вряматэ, кала аракхэла ла? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","А сар аракхэла ла, радомаса лэла пэ пэстирэ пхикхэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Сар авэла черэ, заакхарэла пэстирэ амалэн и ко жувэл пашэ паша лэстэ, и пхэнэла лэнди: «Радосавэн манца, мэ аракхлем бакрёра, сави сас хасарди!» ");
INSERT INTO rmyvlakh_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Пхэнав тумэнди, со по болыбэн майбут радонпэ палай екх бэзэхало мануш, саво каисавэл андэ пэстирэ бэзэха, сар важ инядэш иня жужэ водеса мануша, савэнди на трэбуй тэ каинпэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Сар жувлятэ исин дэш драхморя, и вой екх лэндар хасарэла, на запхабарэла вой каганцо и на лэлапэ тэ притидэл чер ай мишто тэ родэл жы кала, сар аракхэла драхма? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","А сар аракхэла драхма, акхарэла пэстирэ амалэн и ко жувэл пашэ, и пхэнэла: «Радосавэн манца: мэ аракхлем хасарди драхма!» ");
INSERT INTO rmyvlakh_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Акэ, Мэ пхэнав тумэнди, со Дэвлэстирэ ангелоря кадя радосавэн пала екх бэзэхало мануш, саво каисавэл андэ пэстирэ бэзэха! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Исусо дэлас дума: — Екхэ манушэстэ сас дуй шавэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Майцэкно пхэндя пэстирэ дадэсти: «Дад, дэ манди тирэ хулаимастар котор, саво авэла мэрно». И о дад роздя хулаимос машкар шавэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Прожыля найбут деса. Майцэкно шаво стидя вся, со лэстэ сас, жылятар майдур андэ авэр пхув. Котэ вов ростердя вся пэско хулаимос, колэсти со жувэлас найлашэ жувимаса. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Кала вов вся ростердя, андэ кодья пхув авиля баро бокхалимос, и вов ашыля чёрорэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Тунчи вов жыля тай мангляпэ пэ бути екхэ манушэстэ, саво жувэлас котэ. А кодва мануш бишалдя лэс пэ маля пэстирэ тэ пасый лэ балэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Вов сас бокхало и камэлас тэ хал кода, соса праварэнас лэ балэн, но лэсти и кода на дэнас. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Кала вов авиля андэр пэстэ, пхэндя: «Скачи бутярнэ мэрнэ дадэстэ чялён марнэстар, ай мэ мэрав бокхатар! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Жава, рисавава кав мэрно дад и пхэнава лэсти: \"Дад! Мэ тердэм бэзэх англав Болыбэн и англав тутэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Мэ будэр на ашав тэ акхаравпэ тирэ шавэса, прилэ ман андэ бутярнэ тирэ\"». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Вов вщиля и жыля кав пэско дад. Кала вов сас инке дур, дад удикхля лэс, и тангосардя пэстирэ шавэс. Вов прастая майанглэ кав пэско шаво, обля лэс и ля тэ чюминдэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Шаво пхэндя лэсти: «Дад! Мэ тердэм бэзэх англав Болыбэн и англав тутэ. Мэ будэр на ашав тэ акхаравпэ тирэ шавэса». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ай о дад пхэндя пэстирэ бутярнэнди: «Жантэ майсыго, анэн со майфэдэр йида и урявэнтэ лэс. Дэн ангрусни пэ лэско васт и пэрналэ пэ лэстирэ пэрнэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Анэн тай зашынэн отправардэс гуруворэс, тераса свэнко, аваса тэ хас и тэ радосавас! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Мэрно шаво сас муло и жундиля! Вов сас хасардо и аракхадиля!» И линэ тэ радосавэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","О пхурэдэр шаво андэ кадья вряма сас андэ мал. Кала вов поджалас кав чер, ашундя, кай андо чер дилабэн диля тай челэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Вов акхардя екхэс андай бутярнэ и пушля лэс, со котэ кацаво тердяпэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","«Тиро пхрал рисайля, — пхэндя лэсти кодва, — и тиро дад зашындя отправардэс гурувурэс, колэстар со лэско шаво рисайля жундо и састо». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Пхурэдэр шаво холяйля и на камля тэ зажал андо чер. Тунчи дад выжыля и акхарэлас лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Нэ шаво пхэндя дадэсти: «Всаворэ кала бэрша мэ теравас бути пэр тутэ, и никала на выжавас тирэ лавэстар. Ай ту никала на дян манди бузнорэс, кай мэ тэ радосавав пэстирэ амалэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","А кала кадва шаво тиро ростердя о хулаимос тиро лэ лубнянца, ту зашындян важ лэсти отправардэс гуруворэс!» ");
INSERT INTO rmyvlakh_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","«Шаво мэрно! — пхэндя тунчи дад. — Ту всавори вряма манца, и вся, со мандэ, исин тиро. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ай пала када трэбуй сас тэ радосавас, со пхрал тиро сас муло и жундиля, хасавэлас и аракхляпэ!» ");
INSERT INTO rmyvlakh_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Исусо пхэндя Пэстирэ сытярнэнди: — Екхэ барвалэ манушэстэ сас пхурэдэр бутярно, саво дикхэлас палав лэско хулаимос. Пала лэстэ роспхэндэ, со вов ростерэл о барвалимос лэ хуласко. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Хулай выакхардя лэс пэстэ тай пхэндя: «Со када мэ шунав пала тутэ? Здэ и бути, колэстар со ту будэр на авэса тэ дикхэс пала мэрно хулаимос». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Пхурэдэр бутярно гындосардя: «Со манди акана тэ терав? Хулай вытрадэл ман пай бути. Тэ жав тэ ганавав и пхув нинай зор мандэ, тэ мангав манди лажаво. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Мэ жанав, со манди трэбуй тэ терав кадя, соб, сар ман вытрадэна кала бутятар, тэ аракхадён кацавэ мануша, савэ прилэна ман пэстэ». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","И вов ля тэ акхарэл екх пала екхэстэ пэстирэ хуластирэн ужылимарен. Екхэстэ пушля: «Скачи ту ужыло мэрнэ хуласти?» ");
INSERT INTO rmyvlakh_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","«Шэл кхорэ оливково дзэто», — пхэндя кодва. Бутярно пхэндя лэсти: «Лэ пэско запистросаримос, бэш и майсыго пэрэпистросар пэ пандэша». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Тунчи вов пушля аврэстэ ужылимарестэ: «Ай ту скачи ужыло?» «Мия гонэ ворзо», — пхэндя кодва. Бутярно пхэндя лэсти: «Залэ пэско запистросаримос и пэрэпистросар пэ охтошэла». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Хулай лашардя пэстирэс хохавнэс пхурэдэр бутярнэс, со годяварнэс тердя. Кала люматирэ шавэ майбут полэн, сар тэ андярэн пэс аврэ манушэнца, сар шавэ Дэвлэстирэ, Саво исин Удуд. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ай Мэ пхэнав тумэнди: терэн пэсти амалэн найчячимастирэ барвалимаса, кай, кала лэс на авэла, тумэн тэ прилэн андэ чера пэ вако. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ко патимаско андэ найбари бути, кодва авэла патимаско андэ бари бути. Ай ко найпатимаско андэ найбари бути, кодва авэла найпатимаско и андэ бари бути. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","И сар тумэ найпатимастирэ андо найжужо барвалимос, ко дэла тумэнди чячюно? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","И сар тумэ сас найпатимастирэ, кала терэнас бути на андо пэско хулаимос, ко дэла тумэнди тумаро? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Нисаво бутярно на авэла тэ терэл бути пэ дуй хулая. Вов екхэс авэла фартэ тэ на камэл, ай аврэс тэ камэл, екхэсти авэла чячюнэса, ай пэ авэр на тховэла патив. Тумэ нисар на авэна тэ терэн бути андэ екх вряма важ о Дэл и важ о барвалимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Фарисеёря, савэ камэнас ловэ, шундэ када вся и асанаспэ Исусостар. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Исусо пхэндя лэнди: — Англай мануша тумэ сикавэн пэс, кай тумэ жужэ водеса, нэ о Дэл жанэл тумарэ водя. Кода, со учес кай мануша исин выритимос англав Дэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Вряма Законоско ай пророконго сас жыкай Иоано, ай икхатар роспхэнэлпэ Радосаво Лав палав Тхагаримос Дэвлэско, и всаворэ тховэн зора, соб тэ зажа андэр лэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Майсыго болыбэн и пхув ужана, сар екх майцэкни пистросарди андав Законо хасардёла! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ко розжалпэ пэстиря ромняса и лэл авря ромня, кодва терэл лубимос, и ко лэл ромня, сави розжыляпэ пэстирэ ромэса, терэл лубимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Жувэлас екх барвало мануш. Вов урявэласпэ андэ майкучютни йида, и всаворо жувимос лэстэ сас сар радосаво свэнко. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ай паша лэстирэ градатирэ удар пашлёлас чёроро, савэс акхарэнас Лазарё, всаворо обшуто насвалимаса. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Вов фартэ камэлас тэ хал кода, со пэрэлас пай мэсали кав барвало. Риконэ авэнас и шыбаса жужарэнас лэстирэ дукха. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","О чёроро муля, и ангелоря одандярдэ лэс кав Авраамо. Муля и барвало, тай гарадэ лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Барвало сас андо адо андэ бари грыжа. Вов вазгля якха тай удикхля дур пэстар лэ Авраамос, ай паша лэстэ Лазарёс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Вов акхардя: «Дад Авраамо, тангосар ман и бишал лэ Лазарёс, мэк вов тховэл пэско най андо паи и шол пэ шыб мэрни, а то мэ фартэ грыжавав андэ кадья яг». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Нэ Авраамо пхэндя: «Бэято, гындосар, со ту лян андо тиро жувимос лашымос, а Лазарё ля выритимос. Икхатар вов катэ радолпэ, а ту грыжоспэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Тай инкэ, машкар амэндэ ай тумэндэ — бари выганавди, и кала варико закамэла тэ пэрэжал катар тумэндэ ай тумэндар амэндэ, на пэрэжана». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Барвало пхэндя: «Тунчи мангав тут, дадэ, бишал Лазарёс андо чер мэрнэ дадэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Мандэ исин панч пхрала, мэк вов умангэл лэн, кай и онэ тэ на попэрэн кардэ, андо тхан грыжако». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Авраамо пхэндя: «Лэндэ исин Моисеё и пророкоря, мэк лэн ашунэн». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","«Нат, дад Авраамо, — пхэндя барвало, — сар авэла варико андай мулэ лэндэ, тунчи онэ каисавэна». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Пэ када Авраамо пхэндя лэсти: «Сар лэ Моисеёс и лэ пророкон на ашунэн, тунчи, кала ко андай мулэ жундёла, онэ на патяна». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Исусо пхэндя пэстирэ сытярнэнди: — Всавори вряма авэла кода, со зумавэла тумэн, но грыжа колэсти, кастар авэл о зумавимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ко екхэс андай кала цэкнэ шола кав бэзэх, авэлас бы лэсти фэдэр тэ пхандэн пэ кор бар и тэ шон лэс андэ лэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Дикхэн пала пэстэ! Сар тиро пхрал стердя бэзэх, выпхэн лэсти, ай сар каисавэл, эртисар лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","И сар эхта молоря андо дес терэла англав тутэ бэзэх, и эхта молоря андо дес авэла тутэ и пхэнэла: «Мэ каисавав», — эртисар лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Апостолоря мангле Раес: — Тер андэ амэндэ майбаро патимос! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Рай пхэндя: — Сар тумэндэ исин патимос, сар горчично ворзо, тумэ пхэнэнас бы акала тютинати: «Вышындюв корнёса и тховпэ андэ лэн», — то вой кандэлас бы тумэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Пхэнаса, тумэндэ исин бутярно, саво ганавэл и пхув или пасый бакрэн. Чи пхэнэна тумэ лэсти, кала вов авэла пай бути: «Майсыго зажа, бэш тэ хас»? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Най, тумэ майсыго пхэнэна лэсти: «Гытосар манди тэ хас ай дикх пала мандэ, кала мэ хава и пава, а тунчи авэса тэ хас и тэ пэс ежэно». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Чи тумэ авэна тэ пхэнэн «наис» лэ бутярнэсти пала лэстирэ рындоря? Най. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Кадя и тумэ, сар стирэна вся, со тумэнди сас припхэндо, пхэнэн: «Амэ бутярнэ, савэ нисо на ашас. Амэ качи тердям кода, со трэбуй сас тэ терас». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Пав дром андо Иерусалимо Исусо прожалас машкар Самария и Галилея. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Кала Вов зажалас андэ екх гав, Лэс удикхле дэш насвалэ проказаса. Онэ тэрдиле найдур ");
INSERT INTO rmyvlakh_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","и фартэ цыпинас: — Исусо, Сытяримари! Тангосар амэн! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Кала Исусо лэн удикхля, Вов пхэндя: — Жантэ ай сикавэнпэ кай рашая. Онэ жыле и пав дром састярдиле. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Екх лэндар, сар качи удикхля, кай вов састярдо, рисайля, барэ гласоса лашарэлас Дэвлэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Вов пэля кай и пэрнэ Исусостирэ, пхэнэлас «наис» Лэсти. И кадва мануш сас самарянино. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","— Чи на дэш мануша сас жужардэ? — пушля Исусо. — Кай кола иня? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Состар нико лэндар, сар акадва мануш андай авэр пхув, на рисайля, кай тэ лашарэл Дэвлэс? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","И пхэндя самаряниности: — Вщи и жа. Тиро патимос фэрисардя тут. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Екхвар фарисеёря пушле Иисусостар, кала авэла о Тхагаримос Дэвлэско. Вов пхэндя лэнди: — Тхагаримос Дэвлэско на авэла кадя, со тумэ дикхэна лэс якхэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Нико на пхэнэла: «Акэ, вов катэ» чи «Акэ, котэ». Тхагаримос Дэвлэско икхатар исин машкар тумэндэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Тунчи Вов пхэндя сытярнэнди: — Авэла кацави вряма, кала тумэ закамэна тэ удикхэ екх дес андай деса Шавэс Манушыканэс и на удикхэна. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Тумэнди авэна тэ пхэнэн: «Акэ, Вов котэ» чи «Акэ, Вов катэ». Нэ тумэ на прастэн тэ дикхэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Колэстар со, сар молния, сави запхабол и дэл удуд по болыбэн екха ригатар кай авэр риг, кадя авэла Шаво Манушыкано андо дес Пэско. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Нэ майанглал Лэсти трэбуй авэла тэ пэрэандярэл бари грыжа и Лэстар отпхэнэнапэ кала мануша. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Сар сас андэ деса лэ Ноёстирэ, кадя авэла и андэ деса Шавэс Манушыканэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Мануша ханас, пэнас, лэнас ромнян, жанас палав ром кав кодва дес, кала Ноё зажыля андо ковчего. Тунчи жыля фартэ баро брышынд, и всаворэ хасайле. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Кадя сас и андэ деса Лотостирэ. Мануша ханас, пэнас, тинэнас, битинэнас, шонас ворзо, терэнас чера. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Нэ андо дес, кала Лото выжыля андав Содомо, жыле пав болыбэн ягуно брышынд и сера, тай всаворэ хасайле. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Кадя авэла и андэ кодва дес, кала сикадёла Шаво Манушыкано. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Андэ кодва дес, ко авэла упрэ по чер, а йида авэла андо чер, мэк на жал тэ лэл ла. Ай ко авэла пэ мал, мэк и вов на жал палпалэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Сэрэн палай ромни Лотостири! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ко камэла тэ фэрисарэл пэско жувимос, кодва хасарэла лэс, ай ко хасарэла пэско жувимос, кодва фэрисарэла лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Пхэнав тумэнди: андэ кодья рят дуй авэна пэ екх пато, екх авэла залино, ай авэр ашэлапэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Дуй жувля авэна екхэтанэ тэ марэн ворзо, екх авэла залити, ай авэр ашэлапэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","— Кай, Рай? — пушле онэ. Исусо пхэндя: — Кай о трупо, кордэ стидёна и орлоря. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Тунчи Исусо роспхэндя лэнди дума, со трэбуй тэ на пэрэашэн тэ мангэнпэ Дэвлэс ай тэ на грыжонпэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","— Андэ екх форо сас сындомари, саво на даралас Дэвлэстар и на лажалас манушэндар. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Андэ кодва форо сас екх пхивли. Вой авэлас кав сындомари, мангэлас: «Фэрисар ман мэрнэ вражымарестар». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Сындомари бут вряма на камэлас тэ поможысарэл лати, ай тунчи пхэндя ежэно пэсти: «Мэк мэ Дэвлэстар на дарав и манушэндар на лажав. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Нэ сар кадья пхивли дохаля манди пэстирэ мангимаса, терава, со вой мангэл, кай вой тэ пэрэашэл тэ дохал ман». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ай о Рай пхэндя: — Шундэ, со пхэнэл сындомари найчячимаско? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Сар о Дэл на фэрисарэла колэн, кас Вов вытидя, и ко фартэ мангэн Лэс о дес и рят? Чи ашавэла лэн о Дэл? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Пхэнав тумэнди: Вов грабисавэла пав чячимос тэ фэрисарэл лэн. Нэ кала Шаво Манушыкано авэла, аракхэла патимос пэ пхув? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Колэнди, савэ гындонас пала пэстэ, кай онэ жужэ, и пхутярдэс дикхэнас пэ авэр мануша, Исусо роспхэндя кацави дума: ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","— Дуй мануша зажыле андо храмо тэ мангэнпэ Дэвлэс. Екх лэндар сас фарисеё, ай авэр — стидэмарё налогонэндиро. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Фарисеё тэрдёлас и мангэласпэ Дэвлэс кадя: «Дэвла, наис Тути, со мэ на кацаво, сар авэр мануша: прахаря, найжужэ, лубаря, и на кацаво, сар акадва стидэмарё налогонэндиро. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Мэ ритярав посто дувар андо курко, дав дэшто котор андар вся, со затерав». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ай стидэмарё налогонэндиро тэрдёлас андэ риг и на ваздэлас якха пэстирэ кав болыбэн, нэ марэлас пэс андо колин и пхэнэлас: «Дэвла, тангосар ман, бэзэхалэс манушэс!» ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Пхэнав тумэнди, со кадва мануш жыля черэ майэртисардо, сар кодва. Кодва, ко ваздэл пэс, авэла обмэкло, а ко обмэкэл пэс, ваздёла. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Мануша анэнас кав Исусо цэкнэн бэяцэн, кай Вов тэ лэлпэ лэндэ. Сытярнэ удикхле када и камле тэ запхэнэн лэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Исусо акхардя лэн Пэстэ ай пхэндя: — Мэк бэяцэ авэн Мандэ, и на запхэнэн лэнди, колэсти со Тхагаримос Дэвлэско важ кацавэ, сар онэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Пхэнав тумэнди чячимаса: ко на прилэла о Тхагаримос Дэвлэско, сар бэято, кодва на зажала андэр лэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Екх пхурэдэр пушля Лэстар: — Лашо Сытяримари, со тэ терав, кай манди тэ дэлпэ жувимос вакоско? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","— Сости ту акхарэс Ман «лашо»? — пхэндя Исусо. — Нико на лашо, качи екх о Дэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ту жанэс запхэнимос: на тер лубимос, на умар, на чёр, на пхэн хохавимаско лав, пативаса обжапэ дадэса и лэ даса. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","— Вся када мэ терав пай тэрнэ пэстирэ бэрша, — пхэндя вов. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Исусо ашундя када ай пхэндя лэсти: — Екх тути инке на хутилэл. Битин вся, со тутэ исин, и роздэ ловэ чёрорэнди, и тунчи тутэ авэла барвалимос по болыбэн. Тунчи ав и жа пала Мандэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Кала пхурэдэр ашундя када, вов грыжосайля, колэсти со сас фартэ барвало. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Кала Исусо удикхля, со кодва грыжосайля, Вов пхэндя: — Сар пхарэс барвалэнди тэ зажан андо Тхагаримос Дэвлэско! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Майлокхо лэ верблюдости тэ прожал андэ сувьяко кан, сар лэ барвалэсти тэ вжал андо Тхагаримос Дэвлэско. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Кола, ко ашундя када, пхэндэ: — Ко тунчи авэла фэрисардо? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Исусо пхэндя: — Сар кав мануш нинай зор тэ стерэл варисо, кав Дэл исин зор кода тэ стерэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Тунчи Пэтро пхэндя: — Акэ, амэ ашадэ вся, со амэндэ сас, и жылям пала Тутэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Исусо пхэндя лэнди: — Пхэнав тумэнди чячимаса: всаворэ, ко ашадя чер, и ла ромня, и лэ пхралэн, лэ дадэс и ла да, тай лэ бэяцэн важ о Дэвлэско Тхагаримос, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","онэ лэна майбут андэ кадья вряма, ай андэ вряма, сави авэла, — жувимос вакоско. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Тунчи Исусо отакхардя дэшудуен андэ риг ай пхэндя лэнди: — Акэ, амэ зажас андо Иерусалимо. Котэ терэлапэ вся, со запистросардо пророконца пала Шаво Манушыкано. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Вов авэла отдино андэ васта манушэнди авря народостар, и кола авэна тэ асанпэ Лэстар, обмукэна Лэс и шунгардэна пэр Лэстэ, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","авэна тэ марэн чюкнянца и умарэна. Нэ по трито дес Вов жундёла. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Сытярнэ нисо калэстар на полинэ. Вся, со Вов пхэндя, сас важ лэнди запхандадо, и онэ на полэнас, со Вов камэлас лэнди тэ пхэнэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Кала Исусо поджалас кав форо Иерихоно, пашав дром бэшэлас тай мангэлас коро мануш. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Вов ашундя, со паша лэстэ прожан бут мануша, пушля, со када кацаво. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","— Жал Исусо андав Назарето, — пхэндэ лэсти. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Тунчи коро зацыписайля: — Исусо, Шаво Давидоско! Тангосар ман! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Кола, ко жалас майанглал, линэ тэ пхэнэн, кай вов тэ ашэл мулком, нэ коро инке майфартэ ля тэ цыписавэл: — Шаво Давидоско! Тангосар ман! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Исусо ашыля и припхэндя, кай калэ манушэс тэ анэн Лэстэ. Кала кодва поджыля, Исусо пушля лэс: ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","— Со ту камэс, кай Мэ тэ терав важ тути? — Рай, мэ камав тэ дикхав, — пхэндя коро. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Исусо пхэндя лэсти: — Мэк отпхэрнавэнпэ тутэ якха! Патимос тиро састярдя тут. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Коро андэ кодья вряма ля тэ дикхэл. Вов жыля палав Исусо и лашарэлас лэ Дэвлэс. Всаворэ мануша, ко дикхля када, линэ кадя ж тэ лашарэн лэ Дэвлэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Тунчи Исусо зажыля андо форо Иерихоно и прожалас пар лэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","И акэ, екх мануш, савэс акхарэнас Закхеё, пхурэдэр стидэмарё налогонэндиро, барвало мануш, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","родэлас тэ дикхэл лэ Исусос, ко Вов кацаво, нэ на сас сар, колэстар со фартэ бут мануша сас пашав Исусо, ай Закхеё сас цэкно ростоса. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Вов запрастая майанглэ, загульдя пэ тютина, сави барёлас пэ кодва тхан, кай прожалас Исусо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Кала Исусо поджыля кав кадва тхан, Вов подикхля упрэ и пхэндя лэсти: — Закхеё! Згуль майсыго! Манди трэбуй адес тэ авав андо тиро чер. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Закхеё сыго згульдя и лошаса приля Лэс андо пэско чер. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Всаворэ, ко дикхля када, холяйле и лине тэ дэн дума, со Вов зажыля кав бэзэхало мануш. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Закхеё вщиля и пхэндя Раести: — Рай! Акэ, епаш всаворэстар, со мандэ исин, мэ роздава чёрорэнди, и кастар лем хохавимаса, отдава андэ штарвар майбут! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Исусо пхэндя лэсти: — Адес авиля фэрисаримос андэ кадва чер, колэсти со и вов исин шаво лэ Авраамоско. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Шаво Манушыкано авиля тэ аракхэл и тэ фэрисарэл колэн, ко хасавэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Колэнди, ко ашунэлас Исусос, Вов пхэндя екх дума. Колэстар со онэ сас пашав Иерусалимо, и онэ гындонас, со сыго отпхэрнавэлапэ Тхагаримос Дэвлэско. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Иисусо пхэндя кадя: — Екх барвало мануш ладэлас андэ дурутни пхув, кай тэ лэл пэсти тхагаримос и тунчи тэ рисавэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Вов акхардя дэшэн пэстирэн слугонэн, дя лэнди по шэл драхморя тай пхэндя: «Терэн арли, жы кала мэ рисавава». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Нэ мануша кола пхувьятар на камэнас лэс и бишалдэ пала лэстэ пхурэдэрэн манушэн, кай онэ тэ пхэнэн: «На камас, соб вов тэ авэл амарэ тхагараса». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Нэ вов тэрдиля тхагараса тай рисайля черэ. Вов припхэндя тэ акхарэл лэ слугонэн, касти вов дя руп, кай тэ ужанэл, ко скачи затердя. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Авиля англуно и пхэндя: «Хулай! Тирэ шэл драхморя андэ манди дэш шэла». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Хулай пхэндя лэсти: «Мишто, лашо бутярно! Пала кода, со ту патимаско андэ кадва цэкно рындо, тути авэла баримос пэ дэш фороря». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Авиля авэр и пхэндя: «Хулай! Тирэ шэл драхморя андэ панчшэл». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Хулай пхэндя лэсти: «И ту ав пхурэдэр андэ панч фороря». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Авиля трито и пхэндя: «Хулай! Акэ тути тирэ шэл драхморя. Мэ ритяравас лэн андо кхосноро. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Мэ даравас тутар, ту мануш, саво бут мангэл: лэс кода, со на тховэсас, и стидэс кода, со ту на шосас андэ пхув». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Хулай пхэндя лэсти: «Тирэ лавэнца авава тэ сындосарав тут, хохавно бутярно! Ту жанэсас, кай мэ бут мангав, лав кода, со мэ на тховавас, и стидав кода, со на шавас андэ пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Состар ту на дян руп мэрно андэ арли, сар мэ рисавава, тэ авэл руп будэр?» ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","И вов пхэндя колэнди, ко котэ ашэлас: «Залэнтэ лэстар шэл драхморя и отдэн колэсти, кастэ дэш шэла». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Онэ пхэндэ лэсти: «Хулай! Лэстэ ж исин дэш шэла драхморя». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Хулай дя дума: «Пхэнав тумэнди, со всаворэнди колэнди, кастэ исин, дэлапэ инке, а кастэ нинай, залэлапэ и кода, со лэстэ исин. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","А мэрнэн вражымарен, ко на камэлас, кай мэ тэ авав лэндирэ тхагараса, анэн и умарэнтэ англав мандэ». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Исусо пхэндя када тай жыля майдур кав Иерусалимо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","И сар поджыля кай и гава, савэ акхарэнпэ Вифагия и Вифания, пашав плай, саво акхарэлпэ Оливково, бишалдя дуен сытярнэн Пэстирэн ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","и пхэндя лэнди: — Жан андо гав, саво англай тумэндэ, ай сар зажана андэ лэстэ, аракхэна припхангле осликос, пэ саво нико никала на бэшэлас. Отпхандэн лэс и анэн Мандэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Сар ко пушэла тумэндар: «Пэр со отпхандэн лэс?» — пхэнэн лэсти кадя: «Вов трэбуй Раести». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Сытярнэ, савэн Вов бишалдя, жыле и аракхле, сар Вов пхэндя лэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Кала онэ отпхандэнас осликос, хулая пушле лэн: — Пэр со тумэ отпхандэн лэс? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Онэ пхэндэ: — Вов трэбуй Раести. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Онэ андэ лэс кав Исусо, шутэ йида пэ ослико и тховдэ пэр лэстэ лэ Исусос. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Кала Вов ладэлас, онэ шонас йида пэстири пав дром. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","А кала Вов подлагля кав тхан, кай о дром змукэлпэ пав плай Оливково, фартэ бут сытярнэ радосавэнас и зоралэ гласоса лашарэнас лэ Дэвлэс пала диворя, савэ онэ дикхле. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Онэ пхэнэнас: — Лашардо Тхагар, саво жал важ алав Рае Дэвлэско! Миро по болыбэн, слава упрэ по болыбэн! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Коисавэ фарисеёря, савэ сас машкар мануша, пхэндэ Лэсти: — Сытяримари, припхэн Пэстирэ сытярнэнди тэ ашэн мулком! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Нэ Вов пхэндя: — Пхэнав тумэнди, сар онэ ашэна мулком, и бара лэна тэ цыписавэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Кала Исусо поджалас кав Иерусалимо, Вов удикхля о форо и заровдя. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Тунчи пхэнэлас: — О, сар ту адес тэ ужанэс, со анэлас бы тути миро! Нэ икхатар када сгарадо тирэ якхэндар. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Авэна кацавэ деса, кала вражымаря тирэ жана пэр тутэ маримаса, тэрдёна тай стасавэна тут всаворэ ригэндар. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Онэ розмарэна тут, умарэна тирэ бэяцэн и на ашавэна бар по бар, пала кода со ту на ужанглян вряма, кала о Дэл авиля тутэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Тунчи Исусо зажыля андо храмо и ля тэ вытрадэл битимарен. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","— Пистросардо, — пхэндя Вов лэнди, — со Мэрно чер авэла черэса, кай мангэнпэ Дэвлэс. А тумэ тердэ андар лэстэ прахарицко тхан. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Кажно дес Исусо сытярэлас андо храмо. Барэ рашая, сытяримаря Законостирэ и майбарэдэр машкар и мануша родэнас тэ умарэн Лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Нэ на аракхэнас, сар када тэ терэн, колэстар со всаворэ мануша на камэнас тэ промукэн ни екх лав Лэско. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Андэ екх дес, кала Исусо сытярэлас андо храмо и пхэнэлас Радосаво Лав, Лэстэ авиле барэ рашая, сытяримаря Законостирэ и пхурэдэра. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","— Пхэн амэнди, савэ баримаса Ту када терэс? Ко дя тути кацаво баримос? — пушле онэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Исусо пхэндя лэнди: — Тунчи и Мэ пушава тумэндар. Пхэнэн Манди, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","болдимос Иоаноско сас пав болыбэн чи манушэндар? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Онэ линэ тэ дэн дума машкар пэстэ: — Сар пхэнаса: «Пав упралимос», — то Вов пхэнэла: «Состар тумэ на патяйле лэсти?» ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Сар пхэнаса: «Манушэндар», тунчи всаворэ мануша марэна амэн лэ барэнца, колэстар со онэ патян, кай Иоано сас пророко. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","И пхэнэнас онэ Лэсти: — На жанас, катар. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Исусо пхэндя лэнди: — И Мэ на пхэнава тумэнди, савэ баримаса Мэ када терав. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Вов ля тэ роспхэнэл манушэнди кацави дума: — Екх мануш ганадя винограднико, ашадя пэ вряма лэ бутярнэнди, а ежэно улагля пэ бут вряма. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Кала поджыля и вряма, бишалдя лэндэ пэстирэс бутярнэс, кай онэ тэ дэн лэско котор пав винограднико, нэ онэ помардэ лэн и отмэкле шушэ вастэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Инке бишалдя аврэс бутярнэс, нэ онэ и кадалэс помардэ, акушле и отмэкле шушэ вастэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","И тритонэс бутярнэс бишалдя, нэ онэ и кодлэс помардэ жы кав рат и вышутэ андай винограднико. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Тоди пхэндя о хулай виноградникоско: — Со манди тэ терав? Бишалава пэстирэс шавэс, савэс мэ камав. Ко жанэл, чи на лажана лэстар? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Кала бутярнэ удикхле лэ шавэс, пхэндэ машкар пэстэ: «Акэ лэско шаво, саво авэла хулай лэ виноградникоско. Авэн, умараса лэс, и всаворо хулаимос заласа пэсти». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Онэ выандярдэ лэс андав винограднико и умардэ. Со терэла лэнца о хулай виноградникоско? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Вов авэла тай умарэла колэн бутярнэн, ай винограднико отдэла аврэнди. Ко шунэлас, кала пхэндэ: — Мэк на авэл кадя! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Нэ Исус подикхля пэр лэндэ и пхэндя: — Сар тэ полэ кала лава андай Пистросаримос: «Бар, саво отшутэ кола, ко терэнас о чер, ашыля англунэ барэса, пэ саво ритярдёл всаворо чер»? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Кожно, ко пэрэла пэ кадва бар, розмардёла, и пэр кастэ пэрэла кадва бар, колэс ростасавэла. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Сытяримаря Законостирэ и барэ рашая полинэ, со кадья дума Исусо роспхэндя пала лэндэ, и камле сыго тэ лэн Лэс, нэ даранас манушэндар. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Онэ линэ тэ дикхэн палав Исусо тай подбишалдэ Лэстэ хохавнэн манушэн, савэ притердэпэ, кай онэ пативалэ, тэ астарэн Лэс андэ лава и тэ отдэн Лэс андэ васта барэ раести андав Римо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Кола пушле Лэс: — Сытяримари! Амэ жанас, кай Ту чячес пхэнэс и сытярэс. И на дикхэс, ко англав тутэ ашэл, нэ чячимаса сытярэс Дэвлэстирэ дромэсти. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Трэбуй тэ дас налогоря лэ императорости чи нат? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Вов поля лэнго хрантимос и пхэндя: ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","— Сикавэнтэ Манди динариё. Каско муй пэр лэстэ вымардо, и каско пэр лэстэ алав? — Императороско, — пхэндэ онэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","— Акэ и отдэн императороско императорости, а Дэвлэско — Дэвлэсти, — пхэндя Вов. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","И кадя онэ на астардэ Лэс англай мануша пала Лэстирэ лава. Онэ дивосайле Лэстирэ лавэнди и ашыле мулком. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Кав Исусо поджыле коисавэ садукеёря. Онэ сытярэнас, кай мулэ на жундён. Тай пушле Лэстар: ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","— Сытяримари! Моисеё пистросардя, сар кастэ мэрэла пхрал, савэстэ ашэлапэ ромни и на сас бэяцэ, тунчи авэр пхрал трэбуй тэ лэл ла пэстиря ромняса, кай тэ авэн бэяцэ андо лэндиро родо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Сас эхта пхрала. Англуно ля пэсти ромня, нэ муля бибэяцэнго. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","И авэр, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","и трито лэнас ла пэстиря ромняса, и кадя всаворэ эхта пхрала муле и на ашадэ бэяцэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Тунчи муля и ромни. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Сар жундёна андай мулэ, кастири вой авэла ромни? Акэ, всаворэ эхта пхрала сас латирэ ромэнца! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Исусо пхэндя лэнди: — Икхатар мануша лэн пэсти ромнян и выжан палав ром. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ай кола, савэ авэна тэ жувэн андэ авэр люма тай жундёна андай мулэ, на авэна тэ лэн пэсти ромнян и тэ жан палав ром. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Онэ на мэрэна, нэ авэна, сар ангелоря. Онэ — шавэ Дэвлэстирэ, савэ жундиле. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ай со мулэ жундён, андо роспхэнимос, сар пхаболас о пусаимаско кустарнико, сикадя Моисеё, кала акхардя Раес Дэвлэс «Дэл Авраамоско, Дэл Исаакоско и Дэл Иаковоско». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Дэл исин Дэл на мулэнго, ай жундэнго. Важ Лэсти всаворэ жундэ! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Коисавэ андай сытяримаря Законостирэ пхэндэ: — Мишто Ту пхэндян, Сытяримари! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","И будэр нико на пушэлас Лэстар. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Тунчи Исусо пушля лэндар: — Состар дэн дума, со Христосо — шаво лэ Давидоско? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ай ежэно Давидо пхэнэл андо пэско лил псалморя: Пхэндя Рай Дэл мэрнэ Раести: «Бэш пай право риг Мандар, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","кола вряматэ, кала шава тирэ вражымарен кай и пэрнэ Тирэ». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Сар Давидо акхарэл Лэс Раеса, сар жэ Вов Шаво лэсти? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Кала всаворэ мануша ашунэнас Лэс, Вов пхэндя Пэстирэ сытярнэнди: ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","— Фэрисавэн лэ сытяримарендар Законостирэ. Лэнди чялёл тэ урявэнпэ андэ лунго йида, онэ камэн, кай мануша лэнди тэ пхэнэн пэ форо: «Тэ авэн бахталэ», и соб тэ бэшэн пэ англунэ тхана андэ синагоги ай пэ свэнкоря. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Онэ залэн чера кай пхивля и бут мангэнпэ Дэвлэс, кай тэ удикхэн лэн мануша. Лэн ажутярэл майбаро сындо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Исусо дикхэлас, сар и барвалэ шонас ловэ андо храмоско сартари. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Вов дикхля, сар чёроры пхивли шутя андо сартари дуй хурдэ ловэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","— Пхэнав тумэнди чячимаса, — пхэндя Исусо, — со кадья чёроры пхивли шутя майбут всаворэндар. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Колэстар со всаворэ дэнас ловэ пэстирэ барвалимастар, нэ вой пэстирэ чёримастар дя вся, со латэ сас по жувимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Кала мануша, савэ котэ сас, дэнас дума палав храмо, сар вов стердо андай кучютнэ бара и шукар дароря, савэ анэнас Дэвлэсти, Исусо пхэндя: ");
INSERT INTO rmyvlakh_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","— Авэла вряма, кала всаворэстар, со тумэ катэ дикхэн, на ашэлапэ бар по бар, вся авэла розмардо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Лэстар пушле: — Сытяримари! Кала када авэла? И сави шпэра сикавэла, со када сыго авэла? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Вов пхэндя: — Дикхэн, кай нико тэ на дилярэл тумэн. Бут авэна талав Мэрно алав и авэна тэ пхэнэн: «Када Мэ» и «Вряма авиля». На жан пала лэндэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Кала ашунэна палав маримос и пала кода, сар ваздэнпэ мануша екх пэ екх, на даран. Вся када трэбуй тэ авэл майанглал, нэ када инке най вся. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Исусо пхэнэлас: — Мануша екха пхувьятар авэна тэ вражысарэн манушэнца авря пхувьятар, и екх тхагаримос ваздёла пэ авэр. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Авэла фартэ тэ тинолпэ и пхув, пай бут тхана авэла бокх и бут насвалимос, авэна тэ терэнпэ рындоря, савэ даравэна манушэн, и по болыбэн авэна барэ шпэры. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Нэ майанглал тумэн авэна тэ традэн, тэ залэн, тэ анэн андэ синагоги, тэ пхандавэн андо бар, и андярэна тумэн кай и тхагара и кай барэ рая пала алав Мэрно. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Када авэла допхэнимос важ тумэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Тховэнтэ андэ пэстирэ водя тэ на гытонпэ, со тумэнди тэ пхэнэн пала пэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Мэ дава тумэнди кацавэ лава и кацави годи, со никастэ андай тумарэ вражымаря на авэла, со тэ пхэнэл тумэнди, и онэ на утэрдёна англай тумэндэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Тумэн авэна тэ прэдэн дада и дэя, пхрала тумарэ, родо тумаро и амала тумарэ, и варикас тумэндар умарэна. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Всаворэ авэна тэ на камэн тумэн пала Мэрно алав. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Нэ ни екх бал на пэрэла пав тумаро шэро. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Тумарэ терписаримаса фэрисарэна пэстирэ водя. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Кала дикхэна, со бут халавдэ тэрдён всаворэ ригэндар Иерусалимостар, тунчи жанэнтэ, со авиля вряма, кала вов авэла розмардо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Тунчи кола, ко исин андэ Иудея, мэк нашэн андэ плая, а ко андо форо — мэк нашэн андар лэстэ, а ко исин пашав форо — мэк на зажан андэр лэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Када исин деса, кала Дэл пушэла пала лэндирэ рындоря, мэк терэлпэ кода, со запистросардо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Андэ кодья вряма авэла бида жувлянди, савэ пхарэ и савэ праварэн чючяса бэяцэн. Пэ пхув авэла бари грыжа, и пэ кала мануша сжала холи. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Екх мэрэна мечёстар, аврэн схутилэна и андярэна андэ авэр пхувья. Иерусалимо авэла помардо манушэнца аврэ народостар, жы кала прожала лэндири вряма. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","По кхам, по шон и пэ чиргая авэна шпэры. Мануша пай всавори пхув ашунэна, сар шумисарэл и ваздёл море, и авэна тэ тинонпэ даратар. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Мануша авэна тэ ажутярэн биды, савэ жан андэ люма, онэ даратар авэна тэ пэрэн бизоратирэ, и болыбнастирэ зора тинонапэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Тунчи мануша удикхэна лэ Шавэс Манушыканэс, Саво жал пэ облако баря зораса и славаса. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Кала акада вся авэла тэ терэлпэ, вщен ворта и ваздэн шэрэ пэстирэ, колэсти со авэл тумэндэ майпашэ тумаро фэрисаримос. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Тунчи Вов пхэндя лэнди кацави дума: — Подикхэн пэ инжыро и пэ авэр дрэворя. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Кала онэ лэн тэ розмукэнпэ, тумэ дикхэн пэр лэндэ и жанэн, со милай пашэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Кала тумэ дикхэна, со када терэлпэ, жанэн, со Дэвлэско Тхагаримос пашэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Пхэнав тумэнди чячимос: на прожала кадва родо, сар вся када терэлапэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Болыбэн и пхув прожана, нэ лава Мэрнэ на прожана. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Дикхэн пала пэстэ, мэк тумарэ водя на авэн залитэ лубимаса, матимаса, и грыжаса пала жувимастирэ рындоря, кай о дес кадва тэ на авэл тунчи, кала тумэ лэс на ажутярэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Кодва дес авэла, сар фэли важ чирикля, кадя ж важ всаворэ мануша, савэ жувэн пай пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Авэнтэ гытомэ и всавори вряма мангэнпэ Дэвлэс, кай тумэндэ тэ авэл зор тэ унашэн всаворэстар, со сыго авэла, и тэ ашэн англав Шаво Манушыкано. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Исусо десэ сытярэлас андо храмо, ай пэ рят жалас по плай Оливково. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Всаворэ мануша, кала качи авэлас дес, авэнас андо храмо тэ ашунэн Лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Поджалас свэнко Бизакваскатирэн марнэн, саво инке акхарэласпэ Патради. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Барэ рашая и сытяримаря Законостирэ родэнас, сар тэ умарэн Исусос, нэ даранас манушэндар. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Тунчи Сатана вжыля андо Иуда, савэс акхарэнас Искариото, екх андай дэшудуй. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Вов жыля и дя дума лэ барэ рашаенца и пхурэдэрэ халавдэнца, сар тэ здэл лэнди Исусос. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Онэ радосайле и допхэндэпэ тэ дэн лэсти ловэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Вов дя лав и родэлас лащи вряма, сар тэ здэл Исусос, кала пашэ на авэла манушэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Авиля дес Бизакваскатирэн марнэн, кала трэбуй сас тэ зашынэн патрадятирэс бакрорэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Исусо бишалдя лэ Пэтрос тай лэ Иоанос, пхэндя лэнди: — Жантэ, пригытон важ амэнди патрадяко хамос. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","— Кай Ту камэс, соб амэ тэ гытосарас? — пушле онэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Вов пхэндя лэнди: — Кала тумэ зажана андо форо, дикхэна манушэс, саво андярэл кхоро паеса. Жантэ пала лэстэ андо чер, андэ саво вов зажала, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","и пхэнэн лэ хуласти пав чер: «Сытяримари пхэнэл тути: \"Кай тхан андо чер, соб Манди тэ хав патрадяко хамос лэ сытярнэнца Мэрнэнца?\"» ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","И вов сикавэла тумэнди баро, гытосардо тхан упрэ андо чер, котэ гытон. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Онэ жыле и вся удикхле кадя, сар пхэндя лэнди Исусо, и гытосардэ патрадяко хамос. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Кала авиля вряма Исусо бэшля лэ апостолонэнца палай мэсали. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Тунчи Исусо пхэндя лэнди: — Сар фартэ Мэ камавас тэ хав кадва патрадяко хамос тумэнца майанглал, сар Манди авэла бари грыжа. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Пхэнав тумэнди, со Мэ будэр на авава тэ хав патрадяко хамос жы кала кадья Патради терэлапэ андо Тхагаримос Дэвлэско. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Тунчи Вов ля о тахтай молэса, наисардя и пхэндя: — Лэнтэ и пэнтэ андар лэстэ всаворэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Пхэнав тумэнди, со Мэ будэр на авава тэ пав пимос виноградостар жы кола вряматэ, кала авэла Тхагаримос Дэвлэско. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Тунчи Вов ля о марно, наисардя пала лэстэ Дэвлэс, пэрэпхагля и дя лэнди. Вов пхэндя: — Када исин тило Мэрно, саво пала тумэндэ отдэлпэ. Терэн када, кай сэрэн пала Мандэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Кала онэ хале, упалэ ля о тахтай и пхэндя: — Кадва тахтай исин нэво завето андо Мэрно рат, саво пала тумэндэ питял. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Акэ, васт колэско, ко Ман прэдэла, Манца палай мэсали. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Нэ Шаво Манушыкано жал, сар Лэсти трэбуй. Тай бида колэсти манушэсти, саво прэдэл Лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Тунчи апостолоря линэ тэ пушэн екх екхэстар, ко лэндар када терэла. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Тунчи онэ линэ тэ ханпэ машкар пэстэ, ко лэндар авэла пхурэдэр. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Исусо пхэндя лэнди: — Тхагара аврэ пхувьяндар припхэнэн пэстирэ народонэнди, кола, савэндэ исин баримос, пхэнэн, кай онэ терэн мищимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ай тумэ на авэн кацавэ, сар онэ. Тумэндэ мэк майпхурэдэр авэла, сар майцэкно, и рай — сар бутярно. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ко майпхурэдэр? Кодва, ко бэшэл палай мэсали? Ай бутярно? Чи най кодва, саво бэшэл палай мэсали? Нэ Мэ машкар тумэндэ, сар бутярно. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Тумэ ашылепэ Манца, сар Манди сас бида. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Сар Мэрно Дад дя Манди Тхагаримос, кадя Мэ икхатар дав лэс тумэнди, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","кай и тумэ тэ хан и тэ пэн палай Мэрни мэсали андо Тхагаримос Мэрно, и бэшэна тумэ пэ троноря, кай тэ сындосарэн дэшудуй родоря лэ Израилёстирэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","— Симоно! Симоно! Акэ, Сатана мангэлас тэ зумавэл тумэн и тэ жужарэл, сар о ворзо жужарэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Нэ Мэ манглем пала тутэ Дэвлэс, кай тэ на хасарэс патимос тиро. Ай ту ежэно, кала рисавэса Мандэ, подритяр лэ пхралэн тирэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Пэтро пхэндя Лэсти: — Рай, Туса мэ гытомэ тэ жав Туса андо баруно и по миримос! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Нэ Исусо пхэндя: — Пхэнав тути, Пэтро, на задилабэла адес башно, сар ту тривар пхэнэса, со на жанэс Ман. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Тунчи Исусо пхэндя лэнди: — Кала Мэ бишалавас тумэн битышылако, и битрастако, и бипэрналэнго, со тумэнди на хутилэлас? Онэ пхэндэ: — Най, вся хутилэлас. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","— Нэ икхатар, — пхэндя Исусо, — сар кастэ исин тышыла, лэ пэса, кадя ж лэ и траста; а кастэ нинай, битин пэстири йида и тин мечё. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Пхэнав тумэнди, со Манца трэбуй тэ стерэлпэ вся, со запистросардо: «И Вов сас забиндо сар прахари». Вся, со пала Мандэ сас пистросардо, трэбуй тэ авэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Апостолоря пхэндэ: — Рай, акэ дикх, амэндэ дуй мечёря. Исус пхэндя лэнди: — Када хутила. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Исусо выжыля тай, сар Лэстэ сас прилито, жыля по плай Оливково. Лэстирэ сытярнэ жыле Лэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Кала Исусо авиля по тхан, Вов пхэндя лэнди: — Мангэнпэ Дэвлэс, соб тэ на попэрэн андо зумавимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Тунчи Вов отжыля лэндар пэ скачи шонас о бар, тэрдиля пэ чянга и ля тэ мангэлпэ Дэвлэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Вов пхэндя: — Дадэ! Андэ Тири зор тэ залэс кадва тахтай Мандар. Нэ мэк вся авэл на кадя, сар Мэ камав, а сар Ту камэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Тунчи пав болыбэн Лэстэ авиля ангело и подритярэлас Лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Андэ пхари грыжа Исусо зоралэс мангэласпэ. Лэско пото сас сар рат, саво капленца питялас пэ пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Кала Вов пэрэашыля тэ мангэлпэ, рисайля кай сытярнэ и удикхля лэн сутэнца, колэсти со онэ чиеле грыжатар. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","— Состар тумэ совэн? — пушля Исусо. — Вщен и мангэнпэ, соб тэ на попэрэн андо зумавимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Кала Вов инке дэлас дума, сикадэпэ мануша, и англал жалас екх андай дэшудуй, савэс акхарэнас Иуда. Вов поджыля кав Исусо, соб тэ чюминдэл Лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Исусо пхэндя лэсти: — Иуда, ту чюминдэс и калэса прэдэс Шавэс Манушыканэс? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Тунчи кола, ко сас лэ Исусоса, дикхле, со икхатар авэла, и пушле: — Рай! Ай со, сар амэ арэсаса мечёса? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Екх лэндар арэсля барэ рашаестирэс бутярнэс и отшындя лэсти право кан. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Нэ Исусо пхэндя: — На терэн, хутила! Вов ляпэ палав кан и састярдя бутярнэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Тунчи Исусо пхэндя барэ рашаенди, пхурэдэрэ халавдэнди храмостар и пхурэдэрэнди, савэ авиле пала Лэстэ: — Сар по прахари тумэ авиле мечёнэнца и рулянца? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Мэ кажно дес сымас тумэнца андо храмо, и тумэ на схутилдэ Ман. Нэ икхатар тумари вряма, икхатар баримос калимаско. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Онэ схутилдэ Лэс и андярдэ андо чер барэ рашаеско. Пэтро дурал жалас пала лэндэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Машкар града роспхабардэ яг, и Пэтро екхэтанэ аврэ манушэнца бэшля пашай яг. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Екх бутярни удикхля лэ Пэтрос, пэ удуд ягако, придикхляпэ лэстэ ай пхэндя: — И кадва мануш сас Лэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Нэ Пэтро отпхэндяпэ. — Мэ на жанав Лэс, жувлиё, — пхэндя вов. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Тунчи инке авэр мануш удикхля лэс и пхэндя: — И ту екх лэндар. — Най, мануш, — пхэндя о Пэтро. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Прожыля варикай екх чясо вряма, и инке екх мануш ашыля тэ допхэнэл: — Чячес, и кадва мануш сас Лэса. И вов кацаво жэ галилеянино. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Нэ Пэтро пхэндя: — Мануш, мэ на жанав, пала со ту пхэнэс! И андэ кодья ж вряма, кала вов инке дэлас дума, продилабайдя башно. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Рай обрисайля и подикхля по Пэтро. Тунчи Пэтро гындосардя лава Раестирэ, сар Вов пхэндя лэсти: «На задилабэла адес башно, сар ту тривар пхэнэса, со на жанэс Ман». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Пэтро выжыля котар и грыжатар заровдя. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Мануша, савэ ритярэнас лэ Исусос, линэ тэ аса Лэстар и тэ марэ Лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Онэ запхангле Лэсти якха, пушэнас Лэс: — Пхэн пророкоско лав! Ко арэсля Тут? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","И пхэнэнас Лэсти авэр бут акушэмос. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Сар авиля дес, манушэндирэ пхурэдэра, барэ рашая и сытяримаря Законостирэ стидиле и заандярдэ Исусос андо синедрионо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","— Ту исин Христосо? Пхэн амэнди, — пушэнас онэ. Исусо пхэндя: — Сар Мэ пхэнава тумэнди, тумэ на патяна. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","И сар пушава тумэндар, тумэ на пхэнэна Манди. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Акала вряматар Шаво Манушыкано авэла тэ бэшэл пав право васт Дэвлэстиря зоратар. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Онэ всаворэ линэ тэ пушэн: — Када Ту исин Дэвлэско Шаво? Вов пхэндя: — Тумэ ежэнэ пхэнэн, со када Мэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Тунчи онэ пхэндэ: — Саво инке амэнди трэбуй допхэнимос? Амэ ежэнэ ашундэ, со Вов пхэндя. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Тунчи всаворэ онэ подлинэпэ и андярдэ Лэс кав Пилато. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Котэ онэ линэ тэ ужылисарэн Лэс: — Амэ удикхле, со Вов змарэл чячюнэ дромэстар амарэ манушэн. И запхэнэл тэ потинэн налогоря лэ императорости, и пхэнэл, со Вов — Христосо, Тхагар. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Пилато пушля Исусос: — Ту Тхагар иудеёско? — Ту ежэно кадя пхэнэс, — пхэндя Исусо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Тунчи Пилато пхэндя барэ рашаенди и манушэнди, савэ сас котэ: — Мэ на аракхав нисаво ужылимос андэ Кадва Мануш. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Но онэ тэрдёнас пэ пэско, пхэнэнас: — Вов ваздэл лэ манушэн, сар сытярэл пай всавори Иудея, лэ Галилеятар жыкай кадва тхан. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","— Кадва Мануш — галилеянино? — пушля Пилато, сар ашундя када. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","И ужангля, со Вов андай пхув, кай сас тхагар Иродо, бишалдя Лэс кав Иродо, саво сас андэ кола деса андо Иерусалимо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Сар Иродо удикхля лэ Исусос, фартэ радосайля, колэсти со дэлмут камля тэ дикхэл Лэс. Тай бут ашундя пала Лэстэ и гындолас, со Исусо сикавэла важ лэсти варисави шпэра. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Вов пушэлас Лэстар бут со, нэ Исусо нисо на пхэнэлас лэсти. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Барэ рашая и сытяримаря Законостирэ тэрдёнас и фартэ ужылисарэнас Исусос. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","О Иродо пэстирэ халавдэнца акушле и обсае Лэс, урявдэ пэр Лэстэ шукар йида и рисардэ палпалэ кав Пилато. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Андэ кодва дес Иродо и Пилато ашыле амала, а жы кола вряматар онэ сас вражымаря. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Тунчи Пилато стидя барэ рашаен, пхурэдэрэн раен и манушэн ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","и пхэндя лэнди: — Тумэ андэ манди Калэс Манушэс, и пхэнэн, кай Вов ваздэл манушэн. И акэ, мэ допушлем Лэс англай тумэндэ, тай на аракхлем андэр Лэстэ нисаво ужылимос, андэ со тумэ Лэс ужылисарэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Иродо кадя ж на аракхля андэр Лэстэ нисаво ужылимос и бишалдя Лэс палпалэ амэндэ. Сар дикхэн, Вов на стердя нисо кацаво, пала со Лэс трэбуй тэ умарэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Мэ припхэнава, кай тэ марэн Лэс чюкняса, и тунчи отмукава Лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Нэ всаворэ линэ тэ цыписавэн: — Залэ Лэс! Отмук амэнди Варавас! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Варава бэшэлас андо баруно пала умаримос и пала кода, со ваздэлас манушэн андо форо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Пилато жэ камэлас тэ отмэкэл Исусос и инке дэлас дума лэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Нэ онэ цыписавэнас: — Примар, примар Лэс кав трушул! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Пилато трито моло пхэндя лэнди: — Со вырито Вов тердя? Мэ на аракхлем пала Лэстэ нисо, пала со Лэс трэбуй тэ умарэ. Мэ припхэнава, кай тэ марэн Лэс чюкнянца, и тунчи отмэкава Лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Нэ мануша цыпимаса домардёнас пэско, кай Исусос тэ примарэн кав трушул. Тунчи онэ домардэпэ пэско. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Пилато сындосардя тэ терэл кадя, сар онэ камэнас. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Вов отмэкля, сар онэ мангэнас, колэс, ко сас андо баруно пала кода, со ваздэлас лэ манушэн и тердя умаримос. Ай лэ Исусос отдя андэ лэндирэ васта. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Кала онэ андярэнас Лэс, линэ варисавэс Симонос Киринеятар, саво жалас пай мал, и тховдэ пэр лэстэ трушул, кай тэ андярэл палав Исусо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Пала Лэстэ жанас бут мануша и жувля, савэ марэнас пэс андэ кулин и ровэнас пала Лэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Исусо обрисайля лэндэ и пхэндя: — Щея Иерусалимостирэ, на ровэн пала Мандэ, нэ ровэн пала пэстэ и пала пэстирэ бэяцэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Авэла кацави вряма, кала авэна тэ пхэнэн: «Бахталэ бибэяцэндирэ, кола, савэ на бэяндэ бэяцэн и кола, савэ на праварэн чючяса!» ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Тунчи мануша пхэнэна плаенди: «Пэрэн пэ амэндэ!» И холмонэнди: «Гаравэнтэ амэн!» ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Сар жундэ дрэвоса терэн кацаво, тунчи со авэла шукэса? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Исусоса андярэнас дуен прахарэн по миримос. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Сар онэ авиле по тхан, саво акхарэлпэ Черэпо, котэ примардэ кав трушул Исусос и прахарен, екхэс пай право риг, ай аврэс пай авэр риг. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Исусо пхэндя: — Дадэ! Эртисар лэн, онэ на жанэн, со терэн. Халавдэ шонас жребиё тай розлэнас машкар пэстэ йида Исусостири. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ай мануша тэрдёнас и дикхэнас. Пхурэдэра асанас Лэстар и пхэнэнас: — Фэрисарэлас аврэн! Мэк акана фэрисарэл Ежэно Пэс, сар Вов Дэвлэско Вытидо — Христосо! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Халавдэ, кадя ж асанас Исусостар. Онэ поджанас и дэнас Лэсти уксусо ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","и пхэнэнас: — Фэрисар Пэс, сар Ту Тхагар иудеёско! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ай упрэ англав Исусо сас пистросардо: «Када Тхагар иудеёско». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Екх андай примардэ кав трушул прахари дэлас амрая Лэс и пхэнэлас: — Со Ту, на Христосо? Фэрисар Пэс и амэн! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Авэр жэ прахари улэлас лэс и пхэнэлас: — Чи ту на дарас Дэвлэстар? Ту кадя ж сындосардо по миримос. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Амэ туса пав чячимос прилас кода, со затердэ, ай Вов нисо вырито на тердя. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","И вов пхэндя: — Исусо, гындосар пала мандэ, сар авэса андо Пэско Тхагаримос! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","И пхэндя лэсти Исусо: — Чячимос пхэнав тути: адес авэса Манца андо раё. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Сар сас вряма пашэ дэшудуй чясоря десэстирэ, пай всавори пхув ашыля рят, и када сас жыкай трин чясоря. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Кхам пэрэашыля тэ пхабол, о паринд андо храмо росшындяпэ поепаш. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Исусо фартэ зацыписайля: — Дадэ, андэ Тирэ васта Мэ отдав духо Мэрно! И сар пхэндя када, Вов отдя пэско духо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Кала пхурэдэр шэлэ халавдэнго вся када удикхля, лашардя лэ Дэвлэс и пхэндя: — Кадва Мануш чячес сас жужо! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","И всаворэ мануша, савэ стидэпэ тэ подикхэн пэ умаримос, удикхле, со сас, рисавэнас палпалэ и марэнас пэс андэ кулин. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Всаворэ, савэ жанэнас Исусос, и жувля, савэ жанас пала Лэстэ андай Галилея, тэрдёнас и дикхэнас дурал пала када. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Котэ сас лашо и жужо англав Дэл мануш, савэс акхарэнас Иосифо. Вов сас екх андай пхурэдэра синедрионо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Нэ вов на подритярэлас лэндирэ лава и рындоря. Иосифо сас андай Аримафея, форо Иудейско, и ажутярэлас Тхагаримос Дэвлэско. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Кадва мануш авиля кав Пилато и мангля о тило лэ Исусоско. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Вов зля тило, тховдя андэ сани материя и тховдя Лэс андо склэпо, саво сас вымардо андэ баруно плай. Котэ инке никас на гаравэнас. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Када сас дес, кала гытонаспэ кай субота, и кадва дес поджалас. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Палав Иосифо жанас и жувля, савэ авиле лэ Исусоса андай Галилея. Онэ дикхле о склэпо и сар кордэ тховдэ тило Исусоско. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Сар онэ рисайле, гытосардэ мастина лашэ фаноса и духоря. Суботнё дес онэ отчиёнас пав запхэнимо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ай дэнзор андо курко жувля линэ гытосардэ мастина и жыле кав склэпо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Онэ дикхле, со бар сас отшуто лэ склэпостар. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Кала зажыле, онэ на аракхле тило лэ Раеско Исусоско. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Онэ на полэнас, со тердяпэ, и акэ, сикадэпэ лэнди дуй мурша андэ йида, сави свэтосавэлас, сар молния. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Даратар жувля обмэкле пэстирэ муя тэлэ, нэ кола пхэндэ лэнди: — Со тумэ родэн жундэс машкар мулэ? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Лэс катэ нинай, Вов жундиля! Тумэ сэрэн, со Вов пхэнэлас тумэнди, кала сас инке андэ Галилея: ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","«Шавэс Манушыканэс трэбуй сас тэ отдэн андэ васта бэзэхалэ манушэнди, тэ примарэн кав трушул. Нэ по трито дес Вов жундёла». ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Тунчи онэ сэрдэ Лэстирэ лава. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Онэ рисайле лэ склэпостар и роспхэндэ пала вся када дэшуекхэ апостолонэнди и аврэнди, ко сас лэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Када сас Мария Магдалина, Иоана, дэй Иаковостири, савя кадя ж акхарэнас Мария и авэр жувля, савэ сас лэнца. Онэ роспхэндэ вся када апостолонэнди, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","нэ апостолоря на патяйле лэнди. Лэнди сикадяпэ, со када качи шушэ лава. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ай Пэтро вщиля и прастая кав склэпо. Вов тэлиля и задикхля андрэ, нэ удикхля качи материя. Вов рисайля пэстэ, дивосайля всаворэсти, со тердяпэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Андэ кодва ж дес дуй андай сытярнэ жанас андо гав Эмаусо, саво сас варикай дэшудуй километроря лэ Иерусалимостар. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Онэ дэнас дума машкар пэстэ пала вся, со тердяпэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","И кала онэ дэнас дума и роспушэнас екх екхэстар, Ежэно Исусо поджыля и жыля лэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Нэ лэндирэ якха сас затердэ, и вонэ на ужангле Лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Исусо пушля лэндар: — Пала со када тумэ дэн дума машкар пэстэ, сар жан пав дром? Онэ тэрдиле, и муя лэндэ сас грыжомэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Екх лэндар, савэс акхарэнас Клеопа, пхэндя: — Ту, душол, авилян андо Иерусалимо и екх, саво на жанэл пала кода, со тердяпэ андэ кала деса? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","— Пала со? — пушля Иисусо. — Со тердяпэ Исусоса андав Назарето, — пхэндэ онэ. — Вов сас пророкоса, зорало англав Дэл и англай всаворэ мануша андэ лава и рындоря. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Амарэ барэ рашая и пхурэдэра сындосардэ Лэс по миримос и примардэ кав трушул. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ай амэ ажутярасас, со Вов исин Кодва, Саво трэбуй сас тэ фэрисарэл лэ Израилёс. Нэ акэ, трито дес, сар вся када тердяпэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Нэ коисавэ андай амарэ жувля дивосардэ амэн: онэ жыле дэнзор кав склэпо ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","и на аракхле котэ Лэско тило, рисайле и роспхэндэ амэнди, со онэ дикхле ангелон, савэ пхэндэ, кай Вов жундо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Тунчи коисавэ андар амарэ жыле кав склэпо и удикхле котэ вся, сар роспхэндэ жувля, но Лэс онэ на дикхле. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Вов пхэндя лэнди: — Савэ тумэ бигодятирэ и сар тумэ найсыго патян всаворэсти, со пхэнэнас пророкоря! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Чи на трэбуй сас лэ Христости тэ грыжолпэ и тэ зажал андэ Пэстири слава? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","И ля лэ Моисеёстар и всаворэ пророконэндар тэ роспхэнэл лэнди, со пхэнэласпэ пала Лэстэ андэ всаворо Пистросаримос. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Кала онэ поджыле гавэстэ, каринг онэ жанас, Исусо сикадя, кай камэл тэ жал майдур, ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","нэ онэ фартэ мангэнас Лэс: — Ашпэ амэнца. Поджал рят, дес прожыля. И Вов зажыля андо чер и ашыляпэ лэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Кала Исусо бэшэлас лэнца палай мэсали, Вов ля марно, наисардя Дэвлэс, пэрэпхагля и дя лэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Тунчи лэндирэ якха отпхэрнадэпэ, и онэ гатярдэ Лэс. Нэ Вов ашыля важ лэнди надикхло. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Онэ линэ тэ пхэнэн екх екхэсти: — Чи на пхабонас андэ амэндэ водя, кала Вов дэлас дума амэнца пав дром и отпхэрнавэлас амэнди Пистросаримос? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Андэ кодья ж вряма онэ вщиле и жыле палпалэ андо Иерусалимо. Котэ онэ аракхле дэшуекх апостолон и колэн, ко сас лэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Кола пхэндэ лэнди, со о Рай чячес жундиля и сикадиля лэ Симоности. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Тунчи кала дуй роспхэндэ вся, со сас лэнца пав дром, сар онэ ужангле Исусос, кала Вов пхагэлас о марно. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Онэ инке дэнас дума, сар Ежэно Исусо ашыля машкар лэндэ и пхэндя: — Миро тумэнди! ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Онэ замуле даратар, гындонас, со дикхэн духос. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Вов пхэндя лэнди: — Состар тумэ даран? Состар тумэ на састэс патян? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Подикхэн пэ Мэрнэ васта и пэрнэ. Када ж Мэ! Лэнпэ Мандэ и роздикхэн. Кав духо нинай тило и кокаля, ай Мандэ, сар дикхэн, исин. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Вов пхэндя када и сикадя лэнди Пэстирэ васта и пэрнэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Нэ онэ лошатар инке на патянас и дивосавэнас. Тунчи Исусо пушля лэндар: — Тумэндэ катэ исин варисо тэ хан? ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Онэ подинэ Лэсти котор пэко мащё. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Вов ля и халас англай лэндэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","— Пала када Мэ пхэнавас тумэнди, кала сымас инке тумэнца, — пхэндя Вов. — Вся, со запистросардо пала Мандэ андо Законо Моисеёско, кай пророкоря и андэ псалморя трэбуй тэ терэлпэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Тунчи Вов лэнди отпхэрнадя годи, кай онэ тэ полэн Пистросаримос. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","— Пистросардо, со сас лэ Христости тэ грыжолпэ и по трито дес тэ жундёл андай мулэ, — пхэндя Вов. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","— Важ Алав Лэско всаворэнди манушэнди, майанглал Иерусалимостар, тунчи пай всаворэ пхувья, авэла роспхэндо, кай онэ тэ каисавэн и тунчи простисарэнапэ лэндирэ бэзэха. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Тумэ авэна пала вся када тэ роспхэнэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Акэ, Мэ бишалава тумэнди кода, пала со дя лав Мэрно Дад, нэ тумэ ашэнпэ андо форо Иерусалимо, жы кала прилэна зор упралимастар. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Тунчи Вов выандярдя лэн андав форо кай Вифания, вазгля васта и бахталисардя лэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Андэ кодья вряма, кала Вов бахталисарэлас лэн, Вов ля тэ отжал лэндар и тэ ваздёл по болыбэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Сытярнэ тэлинэ Лэсти и баря лошаса рисайле андо Иерусалимо. ");
INSERT INTO rmyvlakh_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Онэ сас всавори вряма андо храмо и лашарэнас лэ Дэвлэс.");
INSERT INTO rmyvlakh_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Пативало Феофило, андэ мэрно англуно лил мэ пистросардэм палай вся, со Исусо терэлас и состэ Вов сытярэлас, ");
INSERT INTO rmyvlakh_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","жыкай кодва дес, кала припхэндя Свэнтонэ Духоса вытидэнди Лэса апостолонэнди, со трэбуй тэ терэн, и сас залино по болыбэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Кала Вов пэрэандярдя и грыжа, сикадяпэ лэнди жундэса и бут допхэнэлас, со када чячимос. И саранда дес сикавэласпэ лэнди и пхэнэлас палав Тхагаримос Дэвлэско. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Екхвар, кала онэ сас екхэтанэ, Вов припхэндя лэнди тэ на ашавэн Иерусалимо, нэ тэ ажутярэн кода, пала со дя лав о Дад. — Пала када тумэ ашундэ Мандар. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Иоано болэлас паеса, ай кала прожана найбут деса, авэна болдэ Свэнтонэ Духоса. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Кола, савэ стидэпэ котэ, пушле Лэс: — Рай, Ту со, стидэспэ тэ рисарэс андэ кадья вряма тхагаримос Израилёско? ");
INSERT INTO rmyvlakh_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Вов пхэндя лэнди: — Най тумаро рындо тэ жанэн деса и вряма, савэ о Дад тховдя Пэстирэ зораса. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Нэ кала пэр тумэндэ сжала Свэнто Духо, тумэ прилэна зор и авэна Мэрнэ допхэнимаря андо Иерусалимо, пай всавори Иудея, Самария и кав дурутнэ тхана пай всавори пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Вов пхэндя када, и англай лэндирэ якха сас вазгло упрэ, и облако гарадя Лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Онэ дикхэнас по болыбэн, сар Вов ваздэласпэ. И акэ, андэ кодья вряма паша лэндэ авиле дуй мануша андэ парни йида. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","И пхэндэ: — Мурша галилеяноря! Со тумэ тэрдён и дикхэн упрэ? Кадва Исусо, Саво сас залино тумэндар по болыбэн, рисавэла кадя ж, сар тумэ дикхле Лэс, кала Вов ужалас. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Тунчи онэ рисайле андо Иерусалимо пав плай, саво акхарэлпэ Оливково. Вов сас найдур форостар, по дром, саво домукэлпэ тэ прожал андо суботнё дес. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","И сар онэ зажыле андо чер, вазглепэ андо тхан упрэ, кай онэ жувэнас андэ кодья вряма. Котэ сас Пэтро и Иоано, Иаково, Андреё, Филипо, Фома, Варфоломеё, Матфеё, Иаково, шаво Алфеёско и Симоно Зилото, тай Иуда, шаво Иаковоско. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Всаворэ онэ екхэтанэ мангэнаспэ Дэвлэс. Катэ сас коисавэ жувля и Мария, дэй Исусостири, и Лэстирэ пхрала. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Андэ кодья вряма Пэтро вщиля машкар пхрала пав патявимос и пхэндя (сас стидэ варикай шэл биш манушэн): ");
INSERT INTO rmyvlakh_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","— Пхралалэ! Трэбуй сас тэ терэлпэ кода, со андэ Пистросаримос пхэндя Свэнто Духо Давидостирэ уштэнца палав Иуда. Вов сас пхурэдэр колэнго, савэ линэ Исусос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Вов сас амэнца и терэлас апостолонэндири бути, ");
INSERT INTO rmyvlakh_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","нэ приля замакхлэ ловэ и тиндя мал. Котэ вов пэля и кадя арэсляпэ, со лэстэ пхариля о пэр, и выпэле всаворэ лэстирэ пора. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","И када ужангле всаворэ, ко жувэлас андо Иерусалимо, и акхардэ кадья мал пэ лэндири шыб Акелдама, со исин «Ратэстири мал». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Андэ лил Псалморя пистросардо: «Мэк лэско чер авэла шушо, тай тэ на жувэл котэ нико» и «Лэско тхан мэк залэл авэр». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Амэнди трэбуй тэ вытидас екхэс манушэс, саво сас машкар амэндэ всавори вряма, пав всаворэ тхана, кай пхирэлас Рай Исусо, ");
INSERT INTO rmyvlakh_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","кола вряматар, кала лэс болэлас Иоано, жыкай кодва дес, кала Вов сас залино амэндар. Сар и амэнди, лэсти трэбуй сас тэ дикхэл, со Исусо жундиля мулэндар. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Онэ вытидэ дуен: Иосифос, саво акхарэлпэ Вар-Сава, и инке акхарэлпэ Иусто, и Матфеёс; ");
INSERT INTO rmyvlakh_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","и манглепэ Дэвлэс тай пхэндэ: — Ту, Рай, жанэс всаворэндирэ водя. Сикав андай кала дуй екхэс, савэс Ту вытидян ");
INSERT INTO rmyvlakh_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","тэ прилэл кадай бути и апостолимос, саво ашавдя Иуда, кай тэ жал кордэ, каринг лэсти сас сындосардо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Онэ шутэ жребиё, и вов выпэля лэ Матфеёсти, и кодва сас прилито кай дэшуекх апостолоря. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Кала авиля свэнко Пандэшако дес, онэ сас андэ екх тхан. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Сыго авиля шумо пав болыбэн, сар фартэ зораля балвалятар, и пхэрдярдя всаворо чер, кай онэ сас. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Авиле лэнди шыба, сар яга, савэ всаворэ екх пала екх сжыле по кажно мануш. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Всаворэ пхэрдиле Свэнтонэ Духоса и линэ тэ дэн дума пэ авэр шыба, сар о Духо дэлас лэнди тэ пхэнэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Андо Иерусалимо сас дэвлэкунэ иудеёря андай всаворэ пхувья талай болыбэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","И сар тердяпэ кадва шумо, стидэпэ бут мануша и на полэнас, со терэлпэ, колэсти со всаворэ ашунэнас, сар апостолоря дэнас дума пэ лэндирэ шыба. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Всаворэ фартэ дивонаспэ и дэнас дума машкар пэстэ: — Кала, савэ дэн дума, най всаворэ галилеяноря? ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Сар амэ ашунас пэстири шыб, сави амэ жанас амарэ бэяндимастар? ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Машкар амэндэ исин парфяноря и мидяноря, еламиторя и ко жувэл андэ Месопотамия, Иудея и Кападокия, Понто и Цэкни Азия, ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Фригия и Памфилия, Египто и пхув андэ Ливия, сави пашай Киринея, и кола, ко жувэл андо Римо, ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","иудеёря и прозелиторя, критяноря и араборя. Ашунэнас, сар онэ дэн дума амаря шыбаса палай барэ рындоря Дэвлэстирэ? ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Всаворэ дивосавэнас и на дополэнас, пхэнэнас екх екхэсти: — Со када терэлпэ? ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ай авэр асанас лэндар тай пхэнэнас: — Онэ матиле гуглэ молэстар. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Пэтро вщиля лэ дэшуекхэнца и зоралэ гласоса пхэндя лэнди: — Мурша иудеёря и всаворэ, ко жувэл андо Иерусалимо! Ашунэнтэ мэрнэ алава, кай тэ жанэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Онэ на матэ, сар тумэ гындон. Икхатар качи иня чясо дэнзорэско! ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Нэ пала када пхэндя майанглал пророко Иоилё: ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","«Андэ палатунэ деса, — пхэнэл о Дэл, — шава Духо Мэрно пэ всаворэн манушэн, шавэ и щея тумарэ авэна тэ пхэнэн лав Дэвлэстар и шаворэ тумарэ авэна тэ дикхэн дикхимос, и пхурэ мурша тумарэ дикхэна сунэ Лэстар. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","И пэ бутярнэ и бутярня Мэрнэ андэ кола деса шава Мэрно Духо, и онэ авэна тэ пхэнэн лав Дэвлэстар. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Мэ сикавава диворя по болыбэн упрэ и шпэры пэ пхув тэлэ, рат и яг, и баро тхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Кхам калёла, и шон ашэла сар рат, жы кала авэла дес Раеско, баро и лашардо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","И тунчи кажно, ко приакхарэла алав Раеско, авэла фэрисардо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Мурша Израилёстирэ! Выашунэн, со мэ пхэнава. Зораса тай дивоса и шпэраса, савэ о Дэл тердя черэз Лэстэ машкар тумэндэ, сар тумэ и жанэн, Дэвэл допхэндя тумэнди, со Мурш Исусо андав Назарето авиля Лэстар. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Сар Дэл загындосарэлас и жанэлас майанглэ, тумэ умардэ Лэс. Прэдинэ андэ прахарэндирэ васта, савэ примардэ Лэс кав трушул. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Нэ о Дэл жундярдя Лэс, росшындя грыжы миримастирэ, колэсти со миримасти на сас зор тэ уритярэл Лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Давидо пхэнэл пала Лэстэ: «Дикхлем мэ англав пэстэ лэ Раес всавори вряма, Вов пай право риг паша мандэ, кай састэс тэ тэрдював. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Важ кода радосайля води мэрно и лошарэл шыб мэрни; и всаворэ мэрнэ маса авэна тэ жувэн надияса. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Колэсти со Ту на ашавэса води мэрно андо адо и на дэса свэнтонэсти Тирэсти тэ ашэл прахоса. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ту дян манди тэ ужанав дром жувимаско, Ту пхэрдярэса ман лошаса англав Тутэ». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Пхралалэ! Домукэн ман тэ пхэнав тумэнди ворта. Прапапо Давидо муля и гарадо, и склэпо лэско амэндэ жыкай адесутно дес. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Вов сас пророко и жанэлас, со о Дэл солахадя лэсти, со по троно авэла тэ бэшэл мануш пай лэско родо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Вов майанглал пхэндя, со Христосо жундёла андай мулэ, со на авэла ашадо о води Лэско андо адо, и тило Лэско на ашэла прахоса. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Калэс Исусос о Дэл жундярдя андай мулэ, амэ всаворэ дикхасас када. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Вов сас вазгло Дэвлэстирэ правонэ вастэса и приля лэ Дадэстар Свэнто Духо, пала Саво дя лав о Дэл, и со тумэ икхатар дикхэн и ашунэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Давидо на вазгляпэ по болыбэн, нэ вов пхэнэлас кадя: «Пхэндя Рай Дэл мэрнэ Раести: — Бэш пай право риг Мандар, ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","кола вряматэ, кала шава тирэ вражымарен кай и пэрнэ Тирэ». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Кадя састэс жанэн, всаворо чер лэ Израилёско, со Калэс Исусос, Савэс тумэ примардэ кав трушул, о Дэл стердя Раеса и Христоса. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Кала онэ ашундэ када, заровдэ воденца и пхэндэ Пэтрости и аврэнди апостолонэнди: — Пхралалэ! Со амэнди тэ терас? ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Пэтро пхэндя лэнди: — Каисавэн и тэ болэлпэ кажно тумэндар важ алав Исусоско Христоско, кай Дэл тэ эртисарэл тумэнди бэзэха. И тунчи тумэ прилэна даро Свэнтонэ Духос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Кадва лав дино тумэнди и тумарэ бэяцэнди, колэнди, ко дур, и всаворэнди, кас акхарэла амаро Рай Дэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","И бут аврэ лавэнца вов умангэлас лэн: — Фэрисавэнпэ калэ хохавнэ родостар! ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Кола, ко приля лэско лав, болдэпэ, и приашыле лэндэ андэ кодва дес варикай трин мия манушэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Онэ ритярэнаспэ апостолонэндирэ сытяримастэ, всавори вряма екхэтанэ дэнас дума, пхагэнас марно и мангэнаспэ Дэвлэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Всаворэ мануша сас андэ дар англав Дэл, и апостолоря сикавэнас бут шпэры и терэнас диворя. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Всаворэ патикунэ сас екхэтанэ, и вся лэндэ сас гуртоско. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Онэ битинэнас пэско хулаимос тай барвалимос, и роздэнас всаворэнди, касти, со сас трэбуй. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Кажно дес онэ екхэтанэ сас андо храмо, ай пай чера пхагэнас марно, ханас хамос лошаса и отпхэрнадэ воденца, ");
INSERT INTO rmyvlakh_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","лашарэнас Дэвлэс. Онэ жувэнас андо мищимос всаворэнца манушэнца, и Рай кажно дес анэлас лэндэ фэрисардэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Пэтро и Иоано жанас кав храмо андэ трито чясо десэско. Андэ кадья вряма котэ сас мангимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Пашай удара лэ храмостирэ, савэ акхарэнаспэ «Шукар», бэшэлас мануш, саво сас банго всаворо пэско жувимос. Лэс кажно дес анэнас и бэшлярэнас, кай вов тэ мангэл ловэ колэндэ, ко зажал андо храмо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Вов удикхля лэ Пэтрос и Иоанос, савэ зажанас андо храмо, тай мангля лэндар. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Пэтро и Иоано фартэ вдикхлепэ андэр лэстэ и пхэндэ: — Подикх пэ амэндэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Вов вдикхляпэ пэр лэндэ и гындолас, со онэ варисо дэна лэсти. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Нэ Пэтро пхэндя: — Руп и сомнак нинай мандэ, а со исин мандэ, кода и дав тути: важ алав Исусоско Христоско андав Назарето вщи и пхир! ");
INSERT INTO rmyvlakh_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Вов ля лэс палав право васт тай вазгля. Андэ кодья вряма ашыле майсастэ лэстирэ чянга и пэрнэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Вов подхукля, тэрдиля тай ашыля тэ пхирэл. Тунчи зажыля лэнца андо храмо, пхирэлас и хукэлас, лашарэлас лэ Дэвлэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Всаворэ мануша дикхле лэс, сар вов пхирэл и лашарэл Дэвлэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Онэ ужангле, со када сас кодва, саво бэшэлас пашай Шукар удара храмостирэ кай тэ мангэл ловэ. Онэ на патянас лэ якхэнди тай дивонаспэ колэсти, со тердяпэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ай сар састярдо банго на отжалас лэ Пэтростар и Иоаностар, тунчи всаворэ мануша дивонаспэ колэсти тай спрастаепэ лэндэ андо тхан, саво акхарэлпэ Соломоностирэ тиндэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Кала Пэтро удикхля када, вов пхэндя лэ манушэнди: — Мурша Израилёстирэ! Состар тумэн када дивосарэл? Состар тумэ дикхэн пэ амэндэ кадя, сар наче амэ пэстиря зораса и жужымаса тердэ када, со вов пхирэл? ");
INSERT INTO rmyvlakh_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","О Дэл Авраамоско, лэ Исаакоско и Иаковоско, Дэл амарэ дадэнго, лашардя Пэстирэс Бутярнэс Исусос, Савэс тумэ прэдинэ и Савэстар отпхэндэпэ англав Пилато, кала вов камэлас тэ отмукэл Лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Тумэ отпхэндэпэ лэ Свэнтостар и Чячимастар и мангле тэ отмукэл тумэнди колэс, саво умарэлас манушэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Тумэ умардэ Пхурэдэрэс лэ Жувимастирэс, нэ о Дэл жундярдя Лэс андай мулэ, и амэ дикхасас када пэстирэ якхэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Кадва мануш, савэс тумэ жанэн и дикхэн, патяйля андо алав Исусоско, и Вов састярдя лэс англай тумарэ якха. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Пхрала, мэ полав: тумэ и тумарэ пхурэдэра на жанэнас, со терэнас. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Нэ кадя о Дэл тердя кода, со пхэнэлас черэз всаворэн пророконэн, со лэ Христости трэбуй авэла тэ пэрэандярэл грыжа. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Акэ, каисавэн и рисавэн кав Дэл, кай тэ скхосэнпэ бэзэха тумарэ, ");
INSERT INTO rmyvlakh_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","кай авиля лэ Раестар вряма тэ чиёл, и кай бишалдя Вов тумэнди лэ Исусос Христос, Савэс Вов майанглал вытидя тумэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Болыбнасти трэбуй сас тэ прилэл Лэс кай вряма, кала терэлапэ кода, со дэлмутня вряматар пхэнэнас Дэвлэстар всаворэ Лэстирэ свэнтонэ пророкоря. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Моисеё пхэндя: «Рай, о Дэл тумаро, тховэла тумэнди андай пхрала тумарэ Пророкос, сар ман. Кандэн Лэс андэ вся, со Вов авэла тэ пхэнэл тумэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Всаворэ, ко на кандэла колэс Пророкос, авэна вытрадэ андав народо». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Самуило и всаворэ авэр пророкоря, савэ сас палав лэстэ, дэнас дума, со авэна кала деса. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Тумэ — шавэ пророкондирэ и заветостирэ, саво Дэл дя тумарэ дадэнди, кала пхэндя Авраамости: «Кодва, Саво авэла андав тиро родо, дэла бахт всаворэнди манушэнди пай пхув». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Дэл жундярдя андай мулэ Пэстирэс Бутярнэс, майанглал бишалдя Лэс тумэндэ тэ бахталисарэл тумэн и обрисарэл кажнонэс лэстирэ выритонэ рындондар. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Кала онэ дэнас дума кай и мануша, лэндэ поджыле рашая, пхурэдэр халавдэнго андэ храмо и садукеёря, ");
INSERT INTO rmyvlakh_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","савэ холявэнас пэ кода, со онэ сытярэнас манушэн, тай пхэнэнас, со черэз Исусо жундёна мулэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Онэ линэ лэн тай пхандадэ андо баруно жыкай дэнзор, колэсти со вряма сас кай рят. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Бут мануша, савэ ашунэнас лав, патяйле, и сас кацавэн, ко патяйля, варикай панч мия. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Пэ авэр дес стидэпэ андо Иерусалимо лэндирэ майбарэ, пхурэдэра тай сытяримаря Законостирэ, ");
INSERT INTO rmyvlakh_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","о Аннас, баро рашай, о Каиафа, о Иоано, и Александро, и авэр андав родо барэ рашаенго. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Онэ тховдэ лэн по машкар тай пушле: — Савя зораса ай савэ алавэса тумэ тердэ када? ");
INSERT INTO rmyvlakh_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Тунчи Пэтро пхэрдиля Свэнтонэ Духоса тай пхэндя лэнди: — Рая манушэндирэ и пхурэдэра! ");
INSERT INTO rmyvlakh_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Кала тумэ допушэн адес амэндар пала лашо рындо, саво сас тердо важ насвало мануш, и пала кода, сар вов састиля, ");
INSERT INTO rmyvlakh_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","тунчи жанэн тумэ и всаворэ мануша Израилёстирэ, со вов тэрдёл англай тумэндэ састярдо алавэса Исусостирэса Христостирэса андав Назарето, Савэс тумэ примардэ кав трушул и Савэс о Дэл жундярдя андай мулэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Вов исин бар, саво отшутэ тумэ, ко терэнас о чер, ашыля англунэ барэса, пэ саво ритярдёл всаворо чер. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","И нико авэр на дэл о фэрисаримос, колэсти со на дино манушэнди авэр алав талай болыбэн, савэса трэбуй амэнди тэ фэрисавас. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Онэ дикхле, со о Пэтро тай Иоано, мэк и наервалэ и мануша андав народо, нэ всаекх на даранас. И кала онэ ужангле, со кола сас лэ Исусоса, фартэ дивосайле. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Онэ кадя ж дикхле састярдэс манушэс, саво тэрдёлас лэнца, тай лэнди нисо на сас тэ пхэнэн пэ када. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Тунчи онэ припхэндэ апостолонэнди тэ выжан андав Синедрионо тай ашыле тэ дэн дума машкар пэстэ: ");
INSERT INTO rmyvlakh_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","— Со амэнди тэ терас калэ манушэнца? Всаворэнди, ко жувэл андо Иерусалимо, ашундо, со онэ тердэ чячюно диво, и амэнди най сар тэ отпхэндювас калэстар. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Нэ соб тэ на розжалпэ кадья дума машкар мануша, дараваса лэн тай запхэнаса лэнди, кай тэ на дэн дума палав кадва алав никасти андай мануша. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Онэ акхардэ лэн, припхэндэ лэнди майбут тэ на дэн дума и тэ на сытярэн палав алав Исусоско. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Нэ Пэтро и Иоано пхэндэ лэнди: — Сындосарэн: чи пав чячимос авэла англав Дэл, кай тэ кандас тумэн майфартэ, сар лэ Дэвлэс? ");
INSERT INTO rmyvlakh_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Амэнди най сар тэ на пхэнас кода, со дикхле и ашундэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Онэ придарадэ лэн тай отмукле, колэсти со на аракхле, сар тэ марэн лэн, тай колэсти со всаворэ лашарэнас Дэвлэс пала кода, со тердяпэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Важ кода со колэсти манушэсти, каса тердяпэ диво састяримаско, сас варикай саранда бэрша. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Кала Пэтрос тай Иоанос отмукле, онэ авиле кай пэстирэ пхрала и роспхэндэ, со пхэнэнас лэнди барэ рашая тай пхурэдэра. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Онэ выашундэ и екхэтанэ вазгле о гласо кав Дэл и пхэндэ: — Баро Дэл, Саво тердян болыбэн, пхув, море и вся, со андэ лэндэ! ");
INSERT INTO rmyvlakh_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ту уштэнца дадэс амарэс Давидос, бутярнэс Тирэс, пхэндян Свэнтонэ Духоса: «Состар вазглепэ мануша всаворя пхувьятар и народоря гындосардэ шушымос? ");
INSERT INTO rmyvlakh_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Вазглепэ тхагара пхувьятирэ, и пхурэдэра стидэпэ екхэтанэ пэ Рай Дэл и по Христосо Лэско». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Пав чячимос стидэпэ андо кадва форо по Свэнто Бутярно Тиро Исусо, Савэс Ту помакхлян, Иродо и Понтиё Пилато аврэ народонэнца и народоса Израилёстирэса, ");
INSERT INTO rmyvlakh_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","соб тэ терэ кода, со Ту майанглал гындосардян тэ тирэс Пэстиря зораса и воляса. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Икхатар, Рай, подикх, сар онэ амэн даравэн, и дэ Тирэ бутярнэнди бидарако тэ пхэнэн лав Тиро. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Процырдэ о васт Тиро тай састяр насвалэн и тер шпэры ай диворя алавэса Свэнтонэ Бутярнэса Тирэса Исусоса. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","И пав мангимос лэнго ля тэ тинолпэ о тхан, кай онэ стидэпэ, и пхэрдярдэпэ всаворэ Свэнтонэ Духоса, и пхэнэнас лав Дэвлэско бидарако. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Всаворэ патикунэ сас амала екхэ водеса и екхэ гындоса; и нико на бинэлас пэско хулаимос качи пэстирэса, нэ вся лэндэ сас гуртоско. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Апостолоря баря зораса допхэнэнас палав жундимос андай мулэ Раес Исусос; и баро мищимос сас пэр лэндэ всаворэндэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","На сас машкар лэндэ никас, касти варисо на хутилэлас, колэсти со кола, кастэ сас пхув и чера, битинэнас лэн, и анэнас и ловэ битинимастар ");
INSERT INTO rmyvlakh_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","и тховэнас кай и пэрнэ апостолонэндирэ. И кала ловэ роздэнаспэ кажнонэсти, со касти сас трэбуй. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Кадя тердя Иосифо, кас апостолоря акхардэ Варнава (со пэрэандярэлпэ «шаво, саво подритярэл»), левито, родоса андав Кипро. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Лэстэ сас пэстири пхув, вов битиндя ла тай андя ловэ и тховдя кай и пэрнэ апостолонэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Екх мурш, савэс акхарэнас Анания и лэстири ромни Сапфира битиндэ хулаимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Саво-то котор битинимастар вов тховдя кай пэрнэ апостолонэнди. Ай авэр котор гарадя пэсти. Лэстири ромни жанэлас пала кода. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Пэтро пхэндя: — Анания! Пэр со ту дян Сатанасти тэ пхэрдярэл тиро води, кай ту пхэндян найчячимос Свэнтонэ Духости, и гаравдян андай цэмин пхувьятири? ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Кода, со ту битиндян, сас тиро, ай ловэ, со ту прилян, сас тирэ. Пэр со ту тховдян андо тиро води тэ тирэс кадя? Ту пхэндян найчячимос на манушэнди, а Дэвлэсти. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Кала Анания ашундя кала лава, вов пэля и муля. Бари дар авиля пэ всаворэн, ко ашундэ када. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","И тунчи тэрнэ мануша вщиле, гытосардэ тэ гаравэн, выандярдэ тай гаравдэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ай кала прожыля трин чясоря, авиля и ромни лэстири. Вой на жанэлас, со тердяпэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Пэтро пушля латар: — Пхэн манди, палай кацави цэмин тумэ битиндэ э пхув? — Агэ, — пхэндя вой, — палай кацави. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Нэ Пэтро пхэндя лати: — Со када тумэ допхэндэпэ тэ зумавэн Духос Раестирэс? Акэ, зажан андэ удар кола, савэ гаравдэ тирэ ромэс. Онэ и тут выандярэна. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Андэ кадья ж вряма вой пэля пашай пэрнэ лэстирэ тай муля. Тэрнэ мануша зажыле и аракхле ла муляса. Онэ выандярдэ тай гаравдэ ла паша лако ром. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","И бари дар авиля пэ всавори кхандири и пэ всаворэ, ко ашундя када. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Апостолоря пэстирэ вастэнца терэнас бут шпэры и диворя машкар мануша. Всаворэ патикунэ екхэтанэ стидэнаспэ андэ Соломоностирэ тиндэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Авэр мануша даранас тэ приашэн лэндэ, ай народо лашарэлас лэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Майбут мануша авэлас кав патявимос андо Рай, и мурша и жувля. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Мануша выандярэнас лэ насвалэн пэ гасы и тховэнас пэ паторя тай пэ паринда, кай и лэ Пэтростири тень, кала вов прожалас, тэ пэрэл пэ варикастэ андар лэндэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Андо Иерусалимо андай пашутнэ фороря зжанаспэ бут мануша. Онэ анэнас насвалэн и колэн, андэр кастэ сас найжужэ духоря, и всаворэ састярэнаспэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Баро рашай и всаворэ, ко сас пэ лэстири риг, андав стидимос садукеёско, пхэрдярэпэ холяса пэ лэн, ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","и схутилдэ лэ Апостолонэн и запхандадэ андо фороско баруно. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Нэ ангело Раеско и рят отпхэрнадя удара андав бар, выандярдя лэн тай пхэндя: ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","— Жантэ, тэрдён андо храмо и пхэнэн всаворэ кала лава жувимастирэ лэ манушэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Онэ кангле тай жыле дэнзор андо храмо и сытярэнас. Андэ кодья вряма барэ рашая и кола, савэ сас лэнца, авиле и стидэ Синедрионо, акхардэ всаворэн пхурэдэрэн андай шавэ Израилёстирэ и бишалдэ андо баруно бутярнэн тэ анэн лэ апостолонэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Нэ бутярнэ, сар авиле, на аракхле лэн андо баруно и рисайле тай допхэндэ: ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","— Амэ дикхле, со барунэстирэ удара мишто затердэ и пашай лэндэ тэрдён халавдэ, нэ кала отпхэрнадэ удара, андрэ никас на аракхле. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Кала пхурэдэр халавдэнго андо храмо и барэ рашая ашундэ кала лава, фартэ дивосайле и на жанэнас, сар тэ полэн кода, со тердяпэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Авиля варико и допхэндя лэнди: — Акэ мурша, савэн тумэ запхандадэ андо баруно, тэрдён андо храмо и сытярэн лэ манушэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Тунчи халавдэнго пхурэдэр жыля лэ бутярнэнца и андя лэн най зораса, колэсти со даранас лэ манушэндар, кай тэ на помарэн лэн барэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Кала андэ лэн и тховдэ андо Синедрионо, баро рашай пушля лэн: ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","— Чи на запхэндэ амэ тумэнди тэ сытярэн палав кадва алав? Ай тумэ пав всаворо Иерусалимо розандярдэ тумаро сытяримос и камэн тэ ужылисарэн амэн пала миримос Калэстирэс Манушэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Пэтро и апостолоря пхэндэ пэ када: — Трэбуй тэ кандас фэдэр Дэвлэс, сар лэ манушэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Дэл амарэ дадэндиро жундярдя андай мулэ Исусос, Савэс тумэ тховдэ по каштуно трушул тай умардэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","О Дэл вазгля Лэс правонэ вастэса и тердя Пхурэдэрэса и Фэрисаримареса, кай тэ дэл Израилёсти каисаримос и эртисаримос лэ бэзэхэндар. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Допхэнимаря калэсти амэ и Свэнто Духо, Савэс о Дэл дя колэнди, ко кандэл Лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Кола, савэ сас котэ, кала ашундэ када, росшынэнаспэ холятар и камэнас тэ умарэн лэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Тунчи вщиля андо Синедрионо екх фарисеё, савэс акхарэнас Гамалиило, сытяримари Законоско, пативало англай всаворэ мануша. Вов припхэндя тэ выандярэн апостолонэн пэ найбари вряма, ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","и пхэндя манушэнди андав Синедрионо: — Мурша Израилёстирэ! Погындон машкар пэстэ палай кала мануша, со лэнца тэ терэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","На фартэ дэлмут авиля Февда, саво сикавэлас пэс пала варисаво баро мануш, и лэстэ приашыле варикай штаршэл мануша. Нэ вов сас умардо, и всаворэ, ко кандэлас лэс, розжылепэ, и на ашыляпэ никас. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Тунчи пала лэстэ сас Иуда галилеянино. Вов авиля, кала сас запистросаримос, тай андярдя пала пэстэ бутэн манушэн. Нэ вов муля, и всаворэ, ко кандэлас лэс, розжылепэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","И икхатар пхэнав тумэнди: ашавэн калэн манушэн и отмукэн лэн. Сар када воля и рындо манушэндирэ, то онэ роспэрэнапэ, ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ай сар Дэвлэстар, тумэ нисар на роспхагэна лэн. Фэрисавэн, кай тумэ тэ на ашэн вражымаренца Дэвлэсти. Кола, савэ сас котэ, кангле лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Онэ акхардэ апостолонэн и припхэндэ тэ марэн лэн чюкнянца. Тунчи запхэндэ лэнди тэ пхэнэн палав алав Исусоско тай отмукле лэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Онэ жыле андав Синедрионо и лошавэнас, со лэнди выпэля патив тэ прилэн лажаимос палав алав Исусоско. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Всаворэ деса андо храмо и пай чера на пэрэашэнас тэ сытярэн и тэ пхэнэн Радосаво Лав палав Исусо Христосо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Андэ кала деса, кала сытярнэн ашыля майбут, элинисторя линэ тэ холявэн пэ евреёря пала кода, со лэндирэ пхивлянди нисо на дэнас, кала роздэнас хамо кажно дес. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Тунчи дэшудуй апостолоря акхардэ бутэн сытярнэн тай пхэндэ: — Наймишто амэнди тэ ашавас лав Дэвлэско тай тэ подас о хамос пэ мисяля. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Акэ со, пхрала, вытидэн машкар пэстэ эхта манушэн, пала савэ лашо дэн дума, савэ пхэрдярдэ Духоса и годяса, и тховаса лэн пэ кадья бути. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ай амэ всавори вряма аваса тэ мангаспэ Дэвлэс и тэ терас бути лавэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Всаворэнди чялиля кадья дума, и вытидэ Стэфанос, муршэс, саво пхэрдярдо патявимаса и Свэнтонэ Духоса, Филипос, Прохорос, Никанорос, Тимонос, Пармэнос и Николаёс, прозелитос андай Антиохия. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Лэн тховдэ англай апостолоря, савэ мангле Дэвлэс тай тховдэ и васт пэр лэндэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","О лав Дэвлэско барёлас, и андо Иерусалимо ашэлас майбут сытярнэ. Кадя ж и андай рашая фартэ бут патяйле. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ай о Стэфано, пхэрдярдо мищимаса и зораса, терэлас барэ диворя и шпэры андо народо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Лэ Стэфаноса ашыле тэ ханпэ коисавэ андай синагога, сави проакхарди Либертинорэндири. Кордэ кадя ж пхирэнас мануша андай Киринея и Александрия, тай андай Киликия и Цэкни Азия. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Нэ лэндэ на сас, со тэ отпхэнэн ла годяти и Духости, савэса вов пхэнэлас. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Тунчи онэ подпхэндэ коисавэн тэ пхэнэн: — Амэ ашундэ, сар вов пхэнэлас бэзэхалэ лава пэ Моисеё и по Дэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Онэ вазгле о народо, пхурэдэрэн и сытяримарен Законостирэн, нахукле пэр лэстэ, хутилдэ тай андярдэ андо Синедрионо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Котэ тховдэ хохавнэн допхэнимарен, савэ пхэнэнас: — Кадва мануш на пэрэашэл тэ пхэнэл бэзэхалэ лава пэ кадва свэнто тхан и по Законо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Амэ ашундэ, сар вов пхэнэлас, со Исусо андав Назарето розмарэла кадва тхан и пэрэтерэла сытяримос, саво пэрэдя амэнди Моисеё. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Всаворэ, ко бэшэлас андо Синедрионо, дикхэнас пэр лэстэ и дикхле, со муй лэско, сар муй ангелоско. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Тунчи баро рашай пушля Стэфанос: — Када чячес кадя? ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Вов пхэндя: — Пхрала и дада, выашунэнтэ! Кала амаро дад Авраамо инке на пэрэтрадя андо Харано и жувэлас андэ Месопотамия, Дэл славако авиля лэстэ ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","и пхэндя: «Ужа пай пхув тири и лэ родостар тирэстар и жа кай пхув, сави Мэ тути сикавава». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Тунчи вов жыля пай пхув халдеёндири и авиля андо Харано. Ай котар, кала муля лэско дад, о Дэл пэрэандярдя лэс андэ кадья пхув, андэ сави тумэ икхатар жувэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","И на дя лэсти пэр латэ нисаво котор пхув, а пхэндя, со отдэла кадья пхув лэсти и лэстирэ бэяцэнди тунчи, кала вов инке сас бибэяцэнго. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","И пхэндя лэсти о Дэл: «Тирэ бэяцэ авэна найчяченца андэ найпэстири пхув, и лэн терэна бутярнэнца, и онэ андярэна грыжа штаршэл бэрша. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Нэ Мэ, — пхэндя о Дэл, — авава тэ сындосарав кодва народо, кастэ онэ авэна бутярнэнца, и тунчи онэ выжана и авэна тэ тэлён Манди пэ кадва тхан». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Тунчи Вов дя лэсти завето тэ обшынэлпэ. Авраамо, кала бэяндиля Исаако, обшындя лэс андо охто дес. Кав Исаако бэяндиля Иаково, ай кав Иаково — дэшудуй патриархоря. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Патриархоря завистятар битиндэ Иосифос андо Египто. Нэ Дэл сас лэса ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","и фэрисардя лэс всаворя грыжатар. Вов дя Иосифости годи и мищимос англав фараоно, тхагар египтонэнго. Ай кодва тердя лэс пхурэдэрэса андо Египто и андо всаворо пэско чер. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Тунчи авиле бокхалимос и бари грыжа пэ всаворэ пхувья Египто и Ханаано. Амарэ дада никай на аракхэнас хамос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Кала Иаково ашундя, кай андо Египто исин марно, вов бишалдя кордэ амарэ дадэн екх моло. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ай сар онэ авиле авэр моло, Иосифо отпхэрнадяпэ пэстирэ пхралэнди, и фараоно ужангля пала Иосифоско родо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Тунчи Иосифо бишалдя и акхардя пэстирэс дадэс Иаковос и всаворо пэско родо, савэс сас эхтадэш панч манушэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Иаково авиля андо Египто. Котэ муле вов и дада амарэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Лэндирэ тилоря сас пэрэандярдэ андо Шэхемо и тховдэ андо склэпо, саво тиндя Авраамо палай рупунэ кай шавэ Хаморостирэ андо Шэхемо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","И сар майпашэ сас вряма, кала тердяпэ кода, пала со Дэл солахалас лэ Авраамости, амарэн манушэн ашэлас майбут андо Египто, ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","жыкай кодья вряма, сар андо Египто вазгляпэ авэр тхагар, саво на жанэлас Иосифос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Кадва хрантимаса обжаласпэ амарэ народоса, стасавэлас дадэн амарэн, терэлас кадя, соб онэ тэ вышон пэстирэн бэяцэн, савэ найдэлмут бэяндиле, кай кола тэ мэрэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Андэ кадья вряма бэяндиля Моисеё, вов сас шукар англав Дэл. Трин шон лэс праварэнас андо чер лэстирэ дадэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","А сар сас шуто, лэс ля щей фараоностири и барярдя лэс, сар пэстирэс шавэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Моисеё сас сытярдо всаворя египтостиряти годяти и сас зорало андэ лава и рындоря. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Сар лэсти ашыля саранда бэрш, авиля лэсти по води тэ авэл кай пэстирэ пхрала, шавэ Израилёстирэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","И удикхля, сар екхэсти лэндар египтянино терэлас бида. Вов тэрдиля пала лэстэ, отпотиндя вражымарести и умардя египтянинос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Вов гындолас, лэстирэ пхрала полэна, со Дэл лэстирэса вастэса дэл лэнди фэрисаримос, нэ онэ на полинэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Пэ авэр дес, кала коисавэ андай лэндэ марэнаспэ, вов авиля и закамля тэ андярэл лэн кав миро, пхэндя: «Муршалэ, тумэ ж пхрала! Пэр со терэн бида екх екхэсти?» ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Нэ кодва, ко терэлас бида лэ пашутнэсти, отшутя лэс пэстар тай пхэндя: «Ко тут тховдя пхурэдэрэса и сындомареса паша амэндэ? ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Чи на камэс ту и ман тэ умарэс, сар арати умардян египтянинос?» ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Кала Моисеё ашундя кала лава, вов нашля тай ашыляпэ тэ жувэл андэ пхув Мадиамо, котэ андэ лэстэ бэяндиле дуй шавэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Кала прожыля саранда бэрша, андэ мал, пашав плай Синаё кав Моисеё авиля ангело андэ яг, сави пхаболас андо пусаимаско кустарнико. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Моисеё дивосайля, кала удикхля када. Вов поджыля тэ подикхэл пэ када и ашундя котар гласо лэ Раеско: ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","«Мэ Дэл тирэ дадэнго, Дэл Авраамоско, Исаакоско и Иаковоско». Моисеё тиноласпэ даратар и на ваздэлас пэстирэ якха. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Рай пхэндя лэсти: «Злэ пэрналэ пай тирэ пэрнэ, колэсти со пхув, пэ сави ту тэрдёс — свэнто. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Мэ дикхлем, сар стасавэн Мэрно народо андо Египто, и ашундэм лэско ровимос, и авилем тэ фэрисарав лэс. Ай икхатар жа, Мэ бишалав тут андо Египто». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Калэс Моисеёс, савэстар онэ отпхэндэпэ лавэнца: «Ко тховдя тут пхурэдэрэса и сындомареса?» — Дэл бишалэл сар пхурэдэрэс и фэрисаримарес черэз ангелос, саво сикадиля лэсти андав пусаимаско кустарнико. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Кадва выандярдя лэн тай тердя диворя и шпэры андэ пхув Египто, и андо Лоло море, и андэ мал саранда бэрш. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Када кодва Моисеё, саво пхэндя шавэнди Израилёстирэнди: «Андай тумарэ пхрала о Дэл тховэла тумэнди пророкос, сар тховдя ман». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Када кодва, саво стидяпэ андэ мал лэ амарэнца дадэнца и лэ ангелоса, саво дэлас дума лэса по плай Синаё. Када вов приля жундэ лава, кай тэ пэрэдэл амэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Амарэ дада на закамле тэ кандэн Моисеёс, нэ отшутэ лэс тай тходэ андо води тэ рисавэн андо Египто. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Онэ пхэндэ Аароности: «Стер амэнди дэвлэн, савэ жана англай амэндэ, пала кода со амэ на жанас, со тердяпэ лэ Моисеёса, саво выандярдя амэн андай Египтостири пхув». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ай андэ кола деса онэ стердэ гурувэс тай андэ жэртва идолости и лошавэнас колэсти, со стердэ пэстирэ вастэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Дэл отрисайля лэндар и ашадя лэн тэ тэлён чергаенди пав болыбэн, сар пистросардо андэ лила пророкондирэ: «Чер Израилёско! Чи зашынэнас тумэ, чи анэнас жэртворя всаворэ саранда бэрш андэ мал? ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Тумэ линэ пэса катуна Молохостири, чиргай тумарэс дэвлэс Ремфанос тай образоря, савэ тумэ стердэ, кай тэ тэлён лэнди. Пала када Мэ пэрэандярава тумэн майдур Вавилоностар». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Амарэ дадэндэ андэ мал сас Катуна Допхэнимастири. Кодва, Ко дэлас дума Моисеёса, припхэндя лэсти тэ терэл ла пав образо, саво кодва дикхля. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Кала амарэ дада прилинэ кадья Катуна, онэ и Исусо Навиёско заандярдэ ла андэ пхув народонэн, савэн Дэл вытрадя англай лэндэ. Кадя сас кай и вряма Давидостири, ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","саво аракхля мищимос англав Дэл и мангэлас Лэстар, кай тэ аракхэл чер важ о родо Иаковоско. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ай о чер Лэсти стердя Соломоно. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Нэ Майбаро на жувэл андэ чера, савэ тердэ манушэнца. Пророко пхэнэл пала када: ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","«Болыбэн — Мэрно троно, и пхув — када тхан, кай Мэ тховав Пэстирэ пэрнэ! Саво чер тумэ терэна Манди? — пхэнэл о Рай. — Кай тэ авэл тхан Мэ тэ чиював? ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Чи най Мэрно васт вся када стердя?» ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Тумэ — найкандунэ мануша барунэ воденца и затердэ канэнца! Тумэ всавори вряма вэрицайвэн Свэнтонэ Духости, сар тумарэ дада, кадя и тумэ! ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Кас андай пророкоря на гонисарэнас тумарэ дада? Онэ умардэ колэн, савэ пэ англал пхэнэнас, со авэла Чячимаско, ай икхатар тумэ прэдинэ тай умардэ Лэс! ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Тумэ прилинэ о Законо, саво пэрэдинэ тумэнди ангелоря, нэ на ашыле тэ жувэн, сар вов пхэнэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Кала онэ ашунэнас када, холятар росшынэнас водя и стасавэнас данда. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Стэфано, пхэрдярдо Свэнтонэ Духоса, вазгля якха по болыбэн тай дикхля слава Дэвлэстири и Исусос, Саво тэрдёлас пай право риг Дэвлэстар. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","— Дикхэн, — пхэндя вов, — мэ дикхав отпхэрнадо болыбэн и Шавэс Манушыканэс, Саво тэрдёл пай право риг Дэвлэстар. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Нэ онэ зацыписардэ зоралэ гласоса, затердэ пэстирэ кана и екхэтанэ хукле пэр лэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Онэ выандярдэ лэс палай форо и ашыле тэ шон андэр лэстэ бара. Допхэнимаря тховдэ пэстири йида кай пэрнэ тэрнэ манушэсти, савэс акхарэнас Савло. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Кала онэ шонас андо Стэфано бара, вов приакхардя Исусос: — Рай Исусо! Прилэ духо мэрно! ");
INSERT INTO rmyvlakh_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Тунчи пэля пэ чянга и фартэ зацыписайля: — Рай, мэк на авэл пэр лэндэ кадва бэзэх. Вов пхэндя кала лава и муля. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Савло подритярэлас кода, со умардэ Стэфанос. Кола вряматар ашыле тэ гонисарэн иерусалимско кхандири, и всаворэ роспрастаепэ пай Иудея и Самария. Качи апостолоря ашылепэ андо Иерусалимо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Дэвлэкунэ мурша гаравдэ Стэфанос тай фартэ ровэнас пала лэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ай Савло розмарэлас пэ котора и кхандири. Вов захукэлас андэ чера, выцырдэлас муршэн тай жувлян тай шолас андо баруно. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ай кола, савэ сас росшутэ, роспхэнэнас Радосаво Лав, каринг онэ тэ на жан. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Филипо авиля андэ екх Самариятиро форо и ашыля тэ роспхэнэл котэ палав Христосо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Бут мануша мишто ашунэнас кода, со вов пхэнэлас. Онэ всаворэ сар екх ашунэнас лэс и дикхэнас шпэры, савэ вов терэлас. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Колэсти со бутэндар манушэндар выжанас найжужэ духоря барэ цыпимаса, ай бут, савэ на пхирэнас пэрнэнца, и бангэ састярэнаспэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","И андо кодва форо сас бари лош. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Андо кодва форо сас мануш, савэс акхарэнас Симоно. Вов майанглал драбатярэлас и калэса дивосарэлас манушэн андэ Самария. Вов выдэлас пэс палав варисаво баро мануш. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Всаворэ мануша, и чёрорэ, и барвалэ, ашунэнас лэс дивоса и пхэнэнас: — Када исин бари зор Дэвлэстири. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","И мишто ашунэнас лэс колэсти, со вов бут вряма дивосарэлас манушэн пэстирэ драбатиримаса. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Нэ кала онэ патяйле лэ Филипости, саво роспхэнэлас палав Тхагаримос Дэвлэско и алав Исусоско Христоско, бут мурша и жувля болдэпэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Симоно кадя ж патяйля и приля болдимос. Вов всавори вряма пхирэлас палав Филипо, диволаспэ шпэрэнди и барэ чюдонэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Кала апостолоря андо Иерусалимо ашундэ пала кода, со андэ Самария прилинэ лав Дэвлэско, онэ бишалдэ лэндэ Пэтрос и Иоанос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Онэ авиле и манглепэ Дэвлэс, кай кола, савэ обрисайле кав Дэл, тэ прилэн Свэнтонэс Духос, ");
INSERT INTO rmyvlakh_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","колэсти со инке ни пэр кастэ лэндар Духо на сжалас, онэ качи сас болдэ андо алав Раеско Исусоско. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Тунчи Пэтро и Иоано тховдэ пэр лэндэ и васта, и онэ прилинэ Свэнтонэ Духос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Кала Симоно дикхля, со Духо дэлпэ, кала апостолоря тховэн и васта, вов процырдя лэнди ловэ ");
INSERT INTO rmyvlakh_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","тай пхэндя: — Дэнтэ и манди кацави зор, кай кодва, пэр кастэ мэ тхава и васта, тэ лэл Свэнтонэ Духос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Нэ Пэтро пхэндя: — Мэк тиро руп хасавэла екхэтанэ туса, сар ту гындос, со тинэса даро Дэвлэско палай ловэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Тутэ нинай кацаво право тэ терэс кадва рындо, колэсти кай о води тиро найчячюно англав Дэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Каисав андо кадва бэзэх и манг Раес, кай Вов тэ эртисарэл тути, со ту гындосас андо тиро води. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Мэ дикхав, со ту пхэрдярдо кэрконя завистяса и спхангло лэпунзэнца, саво исин найчячимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Симоно пхэндя: — Мангэн пала мандэ Раес, кай манца тэ на терэлпэ нисо, со тумэ пхэндэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Кала апостолоря пэрэашыле тэ допхэнэн и тэ роспхэнэн котэ лав Раеско, онэ жыле палпалэ андо Иерусалимо, ай пав дром роспхэнэнас Радосаво Лав андэ бут самаряниностирэ гава. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ангело Раеско пхэндя Филипости: — Жа по юго, по дром, саво андярэл пай мал андав Иерусалимо андэ Газа. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Филипо вщиля и жыля. Андэ кодья ж вряма котэ сас эфиопско евнухо, рай Кандакияко, ла тхагарняко эфиопонэнго, саво дикхэлас палай всавори сартари. Вов авэлас тэ тэлёл Дэвлэсти андо Иерусалимо ");
INSERT INTO rmyvlakh_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","и икхатар рисавэлас черэ. Вов бэшэлас андэ пэско урдон и бинэлас лил лэ пророкоско Исаяско. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Духо пхэндя Филипости: — Поджа кай кадва урдон и жа паша лэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Филипо поджыля кай урдон и ашундя, со котэ бинэлпэ лил пророкоско Исаяско: — Ту полэс кода, пала со бинэс? — пушля Филипо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","— Сар манди тэ полав, кала манди нико на подпхэнэла? — пхэндя евнухо и акхардя Филипос тэ зажал и тэ бэшэл лэса андо урдон. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ай бинэлас вов кадва тхан Пистросаримаско: «Сар бакро, Вов сас андярдо по зашынимос, и сар бакроро ашэл мулком англай кола, савэ стрижын лэс, кадя ж и Вов на отпхэрнавэлас Пэстирэ ушта. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Вов сас лажавардо, и Лэсти на динэ чячюно сындо. Ко роспхэнэла пала Лэско родо? Ай лэско жувимос залэлпэ пхувьятар». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Евнухо мангля Филипостар: — Пхэн манди, пала кастэ катэ пхэнэл пророко, пала пэстэ чи пала кастэ аврэстэ? ");
INSERT INTO rmyvlakh_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Тунчи Филипо ля тэ роспхэнэл акалэ тханэстар Пистросаримастар и пхэндя лэсти Радосаво Лав палав Исусо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Онэ майдур традэнас и подтрадиле кав паи. — Дикх, акэ паи, — пхэндя о евнухо. — Со манди на дэл тэ прилав болдимос? ");
INSERT INTO rmyvlakh_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Вов тэрдярдя о урдон, лэдуй онэ, Филипо и евнухо, зажыле андо паи, и Филипо болдя лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ай кала онэ выжыле андав паи, Духо Раеско андярдя Филипос, и евнухо майбут лэс на дикхля. И лошаса лагля майдур пэстирэ дромэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ай Филипо попэля андо форо Ашдодо. Вов роспхэнэлас Радосаво Лав пай всаворэ фороря, сар на авиля андэ Кесария. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Савло сас холяко пэ Раестирэ сытярнэн и фартэ камэлас тэ умарэл лэн. Вов авиля кав баро рашай ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","и мангля лэстар лила, пистросардэ кай синагоги Дамаскостирэ, соб, сар вов аракхэла варикас, ко приритярдёл Исусостирэс сытяримости, саво акхарэлпэ Дром, тунчи лэстэ сас зор тэ спхандэл лэн и тэ андярэл андо Иерусалимо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Кала вов подладэлас кав Дамаско, лэсти, катар на ляпэ запхабиля андай всаворэ рига удуд пай болыбэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Вов пэля пэ пхув и ашундя гласо: — Савло! Савло! Сости ту гонисарэс Ман? ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","— Ко Ту, Рай? — пушля Савло. — Мэ Исусо, Савэс ту гонисарэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Вщи и жа андо форо. Котэ тути пхэнэна, со трэбуй тэ терэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Мануша, савэ традэнас екхэтанэ лэ Савлоса, ашыле сар муторя: онэ ашундэ гласо, нэ никас на дикхле. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Савло вазгляпэ пай пхув, нэ кала вов отпхэрнадя якха, нисо на дикхэлас. Лэс линэ палай васт тай андярдэ андо Дамаско. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Трин дес вов сас коро и нисо на халас и на пэлас. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Андо Дамаско жувэлас сытярно, савэс акхарэнас Анания. Рай пхэндя лэсти андо дикхимос: — Анания! — Акэ мэ, Рай, — пхэндя кодва. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Рай пхэндя лэсти: — Жа пэ гаса, сави акхарэлпэ «Ворта», андо чер Иудаско и пуш котэ Савлос, саво акхарэлпэ Тарсянино. Вов икхатар мангэлпэ Дэвлэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Вов дикхля андо дикхимос манушэс пав алав Анания, саво авиля и тховдя пэр лэстэ и васт, кай вов тэ дикхэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Анания пхэндя: — Рай, мэ ашундэм бутэндар пала кадва мануш, сар вов тердя бут бида Тирэнди свэнтонэнди андо Иерусалимо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","И катэ лэстэ исин баримос барэ рашаендар, кай тэ спхандэл всаворэн, ко приакхарэл Тиро алав. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Нэ Рай пхэндя лэсти: — Жа, колэстар со вов исин Мэрно мануш. Мэ вытидэм лэс, кай вов тэ андярэл Мэрно алав народонэнди, лэндирэ тхагарэнди и шавэнди Израилёстирэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Мэ сикавава лэсти кода, скачи лэсти трэбуй авэла тэ пэрэжувэл грыжа пала Мэрно алав. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Анания жыля и авиля андо чер, тховдя по Савло и васт тай пхэндя: — Пхрал Савло, Рай Исусо, Саво авиля тутэ по тиро дром кардэ, бишалдя ман тутэ, кай ту упалэ тэ дикхэс и тэ авэс пхэрдярдо Свэнтонэ Духоса. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Андэ кодья ж вряма сар чешуя спэля пай якха кав Савло, и вов ашыля тэ дикхэл. Савло вщиля и приля болдимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Тунчи вов халя, и лэстэ рисайля зор. И сас вов скачи деса лэ сытярнэнца андо Дамаско ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","и андэ кодья ж вряма ашыля тэ роспхэнэл андэ синагоги пала кода, со Исусо — Шаво Дэвлэско. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Всаворэ, ко лэс ашунэлас, дивонаспэ и пхэнэнас: — Чи на вов гонисарэлас андо Иерусалимо колэн, ко акхарэл кадва алав? Чи на авиля вов кардэ, кай тэ спхандэл и тэ андярэл лэн кай барэ рашая? ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Нэ Савло инке майбаря зораса роспхэнэлас и терэлас кадя, со иудеёря андо Дамаско на жанэнас, со тэ пхэнэн, кала вов допхэнэлас, со Иисусо исин Христосо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Кала прожыле бут деса, иудеёря допхэндэпэ тэ умарэн лэ Савлос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Нэ Савло ужангля, со онэ гындон тэ умарэн лэс. Кола, савэ камэнас тэ терэн када, рят и дес ажутярэнас пашай удара форостирэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Нэ лэстирэ сытярнэ рятяса змукле лэс андэ бари траста дуряса пай форостири стинка. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Савло авиля андо Иерусалимо и камэлас тэ авэл лэ сытярнэндэ, нэ всаворэ даранас лэстар и на патянас, со вов кадя ж сытярно. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Нэ Варнава ля лэс и андя кай апостолоря и роспхэндя лэнди пала кода, сар Савло пав дром дикхля лэ Раес, и сар Вов дэлас дума лэса, сар андо Дамаско бидарако вов роспхэнэлас важ алав Исусоско. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Савло терэлас лэнца екх рындо андо Иерусалимо и бидарако роспхэнэлас важ алав Раеско. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Вов дэлас дума и спорисавэлас лэ элинистонэнца, ай кола камле тэ умарэн лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Кала пхрала ужангле пала када, онэ одандярдэ Савлос андэ Кесария, ай котар бишалдэ андо Тарсо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Андэ кодья вряма кхандири пай всавори Иудея, Галилея и Самария сас андо миро, састярэлас тай барёлас, пхирэлас андо дар англав Рай, и Свэнто Духо подритярэлас ла. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Пэтро обжалас всаворэн, и закамля тэ авэл кай свэнти мануша, савэ жувэнас андэ Лида. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Котэ сас екх мануш, савэс акхарэнас Энэё, вов сас насвало пэрнэнца и на вщелас пав пато охто бэрша. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Пэтро пхэндя лэсти: — Энэё! Исусо Христосо састярэл тут. Вщи и стидэ пэско пато. Андэ кодья ж вряма Энэё вщиля. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Кала всаворэ, ко жувэлас андэ Лида и Шароно дикхле лэс састярдэса, онэ обрисайле кав Рай. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Андэ Яфа сас екх сытярни, савя акхарэнас Тавита, со пэрэандярэлпэ, сар «серна». Вой терэлас бут лашымос и поможысарэлас чёрорэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","И акэ, андэ кадья вряма вой занасвайля и муля. Ла обхаладэ и тховдэ упрэ андо чер. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ай сар и Лида сас найдур лэ Яфатар, сытярнэ бишалдэ котэ дуен манушэн, бо ашундэ, со Пэтро котэ. Онэ мангле лэс: — Ав сыго амэндэ! ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Пэтро жыля лэнца и кала авиля, лэс проандярдэ упрэ андо чер. Паша лэстэ стидэпэ всаворэ пхивля. Онэ ровэнас и сикавэнас лэсти и йида, сави сувэлас Серна, кала сас жунди. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Пэтро выбишалдя всаворэн котар, тэрдиля пэ чянга и мангляпэ Дэвлэс. Тунчи обрисайля кав трупо и пхэндя: — Тавита, вщи! Вой отпхэрнадя и якха, удикхля Пэтрос и бэшля. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Вов ля ла палав васт и поможысардя тэ вщел. Тунчи вов акхардя свэнтонэн манушэн и пхивлян и отдя ла Тавита жундяса. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Пала када ашыля ашундо пай всавори Яфа, и бут мануша патяйле андо Рай. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Пэтро сас андэ Яфа инке бут деса и жувэлас кай Симоно морцэндиро. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Андэ Кесария сас мануш, савэс бушонас Корнилиё, вов сас шэлэнго андав полко, саво акхарэлпэ Италийско. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Корнилиё, сар и всаворо лэско йири, сас пативало мануш и даралас Дэвлэстар, бут поможысарэлас чёрорэнди и всавори вряма мангэласпэ Дэвлэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Екхвар, варикай андэ трин чясоря десэско, вов дикхля дикхимос. Вов чячес дикхля Дэвлэстирэс ангелос, саво авиля лэстэ и пхэндя: — Корнилиё! ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Вов подикхля пэр лэстэ дараса и пхэндя: — Со, рай? Ангело пхэндя: — О Дэл сэрэсардя пала тутэ, колэсти со тиро мангимос и тирэ рындоря важ чёрорэн вазглепэ Лэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Бишал манушэн андэ Яфа, кай онэ тэ акхарэн Симонос, савэс бушон Пэтро, ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","вов ашыляпэ кав морцэндиро Симоно андо чер пашай море. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Кала ангело, саво дэлас дума лэса, ужыля, Корнилиё акхардя дуен пэстирэн бутярнэн и пативалэс халавдэс, саво терэлас лэстиро припхэнимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Вов пэрэпхэндя лэнди вся, со тердяпэ, тай бишалдя андэ Яфа. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Пэ авэр дес, варикай андэ епаш дес, кала и бишалдэ инке сас андо дром и поджанас кай форо, о Пэтро зажыля пэ упраи по чер тэ мангэлпэ Дэвлэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","И акэ вов бокхайля и фартэ закамля тэ хал. Кала гытонас тэ хас, лэ Пэтрости сас дикхимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Вов дикхля отпхэрнадо болыбэн и варисо мэзимэ по бугло паринд, саво змукэласпэ пэ пхув и подритярдёласпэ штарэ ригэндар. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Андэ кадва паринд сас бут всаворо штарэпэрнэнго ското, сапа тай чирикля. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Тунчи гласо пхэндя лэсти: — Пэтро, вщи, зашын и ха. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","— Ни пала со, Рай! — пхэндя Пэтро. — Мэ никала на хавас нисо магрисардо и найжужо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Тунчи гласо пхэндя лэсти авэр моло: — На акхар магрисардэса кода, со Дэл жужардя. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Кадя сас трин молоря, ай тунчи паринд сас вазгло пэ болыбэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Пэтро на полэлас, со кадва за дикхимос вов дикхля, и андэ кодья ж вряма мурша, савэн бишалдя Корнилиё, роспушле, кай о чер Симоноско, поджыле кав чер и линэ тэ ажутярэн пашай удара. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Онэ ашыле тэ пушэн, чи катэ ашыляпэ о Симоно, савэс бушон Пэтро. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Пэтро инке гындолас палав кадва дикхимос, Духо пхэндя лэсти: — Тут родэн трин мануша. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Вщи и змукпэ тэлэ. Жа лэнца и ни пала со на пуш, колэсти со када Мэ бишалдэм лэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Тунчи Пэтро змукляпэ тэлэ и пхэндя колэнди манушэнди: — Мэ кодва мануш, савэс тумэ родэн. Пав саво рындо тумэ авиле? ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Онэ пхэндэ: — Пхурэдэр шэлэн халавдэн Корнилиё, мануш чячимаско, саво дарал Дэвлэстар, касти отдэн патив всаворэ мануша иудеёндирэ, приля свэнтонэстар ангелостар припхэнимо тэ акхарэл тут андо пэско чер, кай тэ ашунэл вся, со ту лэсти пхэнэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Тунчи Пэтро акхардя лэн андо чер и приля лэн вудестар. Ай пэ авэр дес Пэтро жыля лэнца, и лэса жыле коисавэ пхрала андай Яфа. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Пэ авэр дес онэ авиле андэ Кесария. Корнилиё ажутярэлас лэн. Вов акхардя пэстирэ родос и пашутнэн амалэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Кала Пэтро авиля, Корнилиё поджыля лэстэ, пэля кай лэстирэ пэрнэ и тэлиля. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Нэ Пэтро вазгля лэс и пхэндя: — Вщи, мэ кадя ж исин мануш. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Пэтро дэлас дума лэ Корнилиёса и зажыля андо чер, кай стидэпэ бут мануша. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Вов пхэндя лэнди: — Тумэ жанэн, со иудеёсти нащи тэ дэл дума манушэса андав авэр народо и тэ зажал лэстэ андо чер. Нэ о Дэл сикадя манди, кай мэ ни екхэ манушэс тэ на акхарав магрисардэса ай найжужэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Колэсти, кала пала мандэ авиле и акхардэ, мэ жылем лэнца и на пушавас ни пала со. Акана мэ пушав тумэндар, сости тумэ бишалдэ пала мандэ? ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Корнилиё пхэндя: — Штар дес палпалэ андэ кадья ж вряма, андо трито чясо мэ мангаваспэ Дэвлэс пэстэ черэ, сар сыго англай мандэ тэрдиля мануш андэ йида, сави свэнтояспэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","«Корнилиё, — пхэндя вов, — тиро мангимос ашундо, ай рындоря важ чёрорэн сэрэсардя о Дэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Бишал манушэн андэ Яфа палав Симоно, савэс акхарэн Пэтро, вов ашыляпэ черэ кав Симоно морцэндиро пашай море». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Мэ сыго бишалдэм пала тутэ, и мишто кай ту авилян. Икхатар амэ всаворэ катэ англав Дэл и камас тэ выашунас кода, со Рай пхэндя тути. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Пэтро ашыля тэ пхэнэл: — Акана мэ полав, со о Дэл чячимаса на дикхэл по муй, ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","и машкар всаворэн манушэн, савэ жувэн андэ люма, Лэсти чялёл кодва, ко дарал Лэстар и терэл пав чячимос! ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Вов бишалдя шавэнди Израилёстирэ Радосаво Лав пала кода, со амэндэ авэл миро лэ Дэвлэса черэз Исусо Христосо, Саво исин Рай всаворэ манушэнго. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Тумэ жанэн пала кода, со терэласпэ пай всавори Иудея, ла Галилеятар, пала кода Иоано акхарэлас манушэн тэ болэнпэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","О Дэл помакхля Свэнтонэ Духоса и зораса Исусос андав Назарето. Вов пхирэлас, терэлас лашэ рындоря и састярэлас всаворэн, ко сас андэ васт кав Бэнг, колэсти со Лэса сас о Дэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Амэ допхэнимаря всаворэсти, со Исусо терэлас андэ пхув иудеёндири и андо Иерусалимо. Лэс умардэ, примардэ кав трушул. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Нэ о Дэл по трито дес жундярдя Исусос андай мулэ и дя Лэсти тэ сикадёлпэ лэ манушэнди — ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","най всаворэнди манушэнди, нэ амэнди, допхэнимаренди, савэн о Дэл вытидя майанглал. Ай амэ хасас и пасас Лэса тунчи, кала Вов жундиля андай мулэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Вов припхэндя амэнди тэ роспхэнас манушэнди и тэ допхэнас пала кода, со Исусо исин вытидо Дэвлэса Сындомари жундэнго и мулэнго. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Пала Лэстэ допхэнэн всаворэ пророкоря, со кажнонэсти, ко патяла андэр Лэстэ, эртисарэнапэ бэзэха черэз алав Исусоско Христоско. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Пэтро инке дэлас дума, кала пэ всаворэн, ко ашунэнас лэс, сжыля Свэнто Духо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Патикунэ андай обшындэ, савэ авиле лэ Пэтроса, дивосайле, со даро Свэнтонэ Духоско сас дино кадя ж манушэнди аврэ народонэндар. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Колэсти со онэ ашунэнас, сар кола дэнас дума пэ найжанглэ шыба и лашарэнас лэ Дэвлэс. Тунчи Пэтро пхэндя: ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","— Ко запхэнэла тэ болдэнпэ андо паи колэнди, савэ прилинэ Свэнтонэ Духос, сар и амэ? ");
INSERT INTO rmyvlakh_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Пэтро пхэндя, кай онэ тэ прилэн болдимос важ алав Исусоско Христоско. Тунчи хулая мангле лэ Пэтрос кай тэ ашэлпэ лэнца пэ качи деса. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Апостолоря и пхрала андэ Иудея ашундэ, со авэр народоря прилинэ лав Дэвлэско. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Колэсти, кала о Пэтро авиля андо Иерусалимо, патикунэ андай обшындэ иудеёря ашыле тэ пхэнэн лэсти, со лэнди када на чялёл. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","— Ту пхирдян кай найобшындэ и хасас лэнца, — пхэнэнас онэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Тунчи Пэтро ашыля екх пала аврэстэ тэ роспхэнэн лэнди, сар вся тердяпэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","— Мэ сымас андо форо Яфа и мангавас Дэвлэс, — пхэндя вов, — и андэ кодья вряма манди сас дикхимос: варисо, сар баро паринд, саво подритярдёласпэ штарэ ригэндар, змукэласпэ пав болыбэн ворта кордэ, кай мэ сас. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Мэ задикхлем кордэ и дикхлем штарэпэрнэнго черутнэско и вэшэско ското, сапэн и чириклен. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Тунчи мэ ашундэм гласо, саво пхэнэлас манди: «Пэтро, вщи, зашын и ха». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ай мэ пхэндэм: «Нисар нащи, Рай! Мэ никала на хавас нисо магрисардо и найжужо». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Гласо пав болыбэн пхэндя манди дуйто моло: «На акхар магрисардэса кода, со Дэл жужардя». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Кадя сас трин молоря, и тунчи када вся сас вазгло упалэ пэ болыбэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Андэ кодья ж вряма пашав чер, кай мэ сымас, тэрдиле трин мануша, бишалдэ манди андай Кесария. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Духо пхэндя манди тэ жав лэнца и ни пала со тэ на пушав. Акэ, кала шов пхрала жыле манца, и амэ авиле андо чер колэстэ, ко ман акхардя. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Вов роспхэндя амэнди пала кода, сар вов дикхля пашай пэстэ ангелос, саво тэрдёлас и пхэнэлас лэсти: «Бишал манушэн андэ Яфа палав Симоно, савэс бушон Пэтро, ");
INSERT INTO rmyvlakh_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","и вов пхэнэла тути лава, сар ту и всаворо тиро йири авэна фэрисардэ». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Кала мэ ашылем тэ дав дума, пэр лэндэ сжыля Свэнто Духо кадя ж, сар Вов сжыля майанглал пэ амэндэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Тунчи манди авиле по гындо лава Раестирэ: «Иоано болэлас андо паи, ай тумэ авэна болдэ Свэнтонэ Духоса». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Колэсти, сар о Дэл дя лэнди кодва ж даро, со и амэнди, савэ патяйле андо Рай Исусо Христосо, ай ко мэ кацаво, кай тэ на домукав лэ Дэвлэс? ");
INSERT INTO rmyvlakh_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Кала онэ када выашундэ, онэ вся полинэ и лашардэ лэ Дэвлэс тай пхэндэ: — Душол, о Дэл дя тэ каисавэн и аврэ народонэнди, кай и онэ тэ прилэн жувимос! ");
INSERT INTO rmyvlakh_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ай кола, савэн рострадэ, кала гонинас палав Стэфано, дожыле кай Финикия, Кипро и Антиохия и роспхэнэнас лав Дэвлэско качи иудеёнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Коисавэ лэндар сас андай Кипро и Киринея. Онэ авиле андэ Антиохия и роспхэнэнас Радосаво Лав палав Рай Исусо кадя ж и лэ элинистонэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Васт лэ Раеско сас лэнца, и фартэ бут патяйле и обрисайле кав Рай. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Лав пала када дожыля кай кхандири андо Иерусалимо. Котар бишалдэ андэ Антиохия Варнавас. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Кала Варнава авиля и дикхля мищимос Дэвлэско, вов радосайля и мангэлас всаворэн тэ ашэнпэ андэ пэстирэ водя чячюнэ англав Рай. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Варнава сас лашо мануш, пхэрдярдо Свэнтонэ Духоса и патявимаса. И бут мануша ашыле тэ патян андо Рай. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Тунчи Варнава жыля андо Тарсо, кай тэ аракхэл котэ лэ Савлос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Вов аракхля лэс тай андя андэ Антиохия. Всаворо бэрш онэ ашэнаспэ андэ антиохийско кхандири и сытярэнас бутэ манушэн. Андэ Антиохия майанглал лэ сытярнэн линэ тэ акхарэн христианоря. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Андэ кадья вряма андав Иерусалимо андэ Антиохия авиле коисавэ пророкоря. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Екх лэндар, савэс акхарэнас Агаво, вщиля и пхэндя лэ Духостар, со пай всавори пхув авэла баро бокхалимос, со и тердиля андэ вряма, кала сас императоро Клавдиё. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Колэсти сытярнэ закамле тэ подритярэн ловэнца лэ пхралэн, савэ жувэнас андэ Иудея, кастэ скачи выжалас. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Онэ кадя и стердэ, тай бишалдэ лэ Варнавас и Савлос тэ андярэн ловэ, савэ онэ стидэ, и тэ отдэн пхурэдэрэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Андэ кадья ж вряма тхагар Иродо схутилдя коисавэн манушэн андай кхандири, кай тэ терэл лэнди бида. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Вов припхэндя тэ умарэн мечёса Иаковос, пхралэс Иоаностирэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","И кала вов дикхля, со иудеёнди када чялиля, вов запхандадя лэ Пэтрос андо баруно. Када сас андэ свэнкостирэ деса Бизакваскатирэ марнэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Пэтрос запхандадэ андо баруно и тховдэ штар пэ штар халавдэн, тэ дикхэн пала лэстэ. Иродо камля тэ выандярэл лэс кай и мануша, кала прожала и Патради. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Пэтро сас андо баруно, ай кхандири пхабардэс мангэласпэ пала лэстэ Дэвлэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Рятяса, англай кода, кала Иродо камля тэ выандярэл лэс по сындо, Пэтро совэлас машкар дуй халавдэ, спхангло дуе лэпунзэнца, ай инке халавдэ тэрдёнас и дикхэнас пашай удара барунэстирэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","И акэ, авиля ангело Раеско, и баро удуд свэнтояспэ по тхан, кай сас о Пэтро. Ангело арэсля пай риг Пэтростири и вазгля лэс сунэстар. — Вщи майсыго! — пхэндя вов, и лэпунзэ пэле пай васта Пэтростирэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ангело пхэндя: — Обпхандюв кущикаса и уряв пэрналэ. Пэтро тердя кадя. — Уряв пэстири йида и жа пала мандэ, — пхэндя ангело. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Пэтро выжыля палав ангело андав баруно тай на поля, со вся, со терэл ангело, терэлпэ чячес. Лэсти сикадиляпэ, со вов дикхэл дикхимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Онэ прожыле екхэн халавдэн, тунчи машкар аврэн и поджыле кай саструнэ удара, савэ андярэн андо форо. Удара ежэнэ отпхэрнадэпэ англай лэндэ, и онэ выжыле. Онэ прожыле екх гаса, и акэ ангело ужыля. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Кала о Пэтро авиля андэр пэстэ, вов пхэндя: — Акана мэ чячимаса жанав, со Рай бишалдя Пэстирэс ангелос и заля ман андай васта Иродостирэ и фэрисардя бидатар, сави камэнас тэ терэн манди иудеёско народо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Кала Пэтро поля, со тердяпэ, вов жыля андо чер, кай жувэлас Мария и дэй Иоаностири, савэс инке акхарэнас Марко. Котэ стидэпэ тэ мангэнпэ Дэвлэс бут мануша. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Пэтро помардя андэ удара, и бутярни, савя акхарэнас Роза, жыля кай тэ отпхэрнавэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Вой ужангля лэ Пэтрос пав гласо, и лошатар забистардя тэ отпхэрнавэл удара. Вой прастая палпалэ, кай тэ пхэнэл, со Пэтро тэрдёл пашай удара. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","— Ту на андэ пэстири годи, — пхэндэ лати. Нэ вой инке и инке пхэнэлас лэнди. — Када лэско ангело, — пхэндэ онэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Пэтро майдур марэлас андэ удара, и кала онэ отпхэрнадэ удара и удикхле лэс, фартэ дивосайле. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Пэтро вастэса сикадя кай тэ ашэн мулком и роспхэндя, сар о Рай выандярдя лэс андав баруно. — Роспхэнэнтэ пала када Иаковости и аврэнди пхралэнди, — пхэндя вов и жыля котар андо авэр тхан. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Дэнзор халавдэ ашыле тэ прастэн кордэ-кардэ, бо нико на жанэлас, со тердяпэ лэ Пэтроса. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Иродо родэлас лэ Пэтрос, нэ сар на аракхле лэс, вов допушля халавдэн и припхэндя тэ умарэн лэн. Тунчи Иродо лагля Иудеятар андэ Кесария и сас котэ сави-то вряма. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Иродо сас холяко пэ мануша андав Тиро и Сидоно. Кола допхэндэпэ машкар пэстэ и авиле кав Иродо. Онэ умангле Бластос, саво сас пхурэдэр андэ тхагарастири града, кай вов подритярэл лэн, тай мангле кав тхагар о миро, колэсти со лэндири пхув лэлас о хамос андай тхагарастири пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Андэ вытидо дес Иродо урявдя тхагарастири йида, бэшля пэ троно и пхэнэлас лэнди лав. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Мануша ашыле тэ цыписавэн: — Када гласо дэвлэско, ай на манушэско! ");
INSERT INTO rmyvlakh_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Нэ андэ кодья ж вряма ангело Раеско умардя Иродос, колэсти со вов на дя слава лэ Дэвлэсти. Лэс схале чермэ, и вов муля. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ай лав Дэвлэско розжаласпэ майдур и майдур. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Варнава и Савло тердэ пэско рындо андо Иерусалимо и рисайле. Онэ линэ пэса Иоанос, савэс инке акхарэнас Марко. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Андэ кхандири андэ Антиохия сас пророкоря и сытяримаря: Варнава, Симеоно, саво акхарэнас Нигеро, Луцыё андай Киринея, Манаило, саво выбариля екхэтанэ лэ тетрархоса Иродоса, и Савло. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Екхвар, кала онэ тэлёнас лэ Раести и сас андо посто, Свэнто Духо пхэндя: — Отдэнтэ Манди Варнавас и Савлос по рындо, пэ саво Мэ лэн вытидэм. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ай кала прожыле о посто и мангимос, онэ тховдэ пэ лэндэ и васт тай отмукле лэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Кала дуй пхрала, бишалдэ Свэнтонэ Духоса, жыле андэ Селевкия, ай котар плывисардэ по Кипро. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Онэ авиле андо Саламино и котэ пхэнэнас лав Дэвлэско андэ иудеёндирэ синагоги. Иоано кадя ж сас лэнца и поможысарэлас лэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Онэ прожыле всаворо острово и авиле андо Пафосо. Котэ онэ дикхле екхэс иудеёс, савэс акхарэнас Вар-Исусо, саво сас чяклуно и хохавно пророко. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Вов сас паша римско проконсуло Сергиё Павло, манушэс баря годяса. Проконсуло акхардя Варнавас и Савлос тай камля тэ ашунэл лав Дэвлэско. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Нэ кадва Элимо (лэско алав пэрэандярэлпэ «чяклуно») терэлас вся, кай тэ отритярэл проконсулос лэ патявимастар. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Тунчи Савло, вов жэ Павло, пхэрдиля Свэнтонэ Духоса, подикхля ворта по Элимо ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","тай пхэндя: — Шаво Бэнгэско, вражымари всаворэ чячимасти, пхэрдярдо хохавимаса и найжужымаса. Кала ж ту пэрэашэса тэ римосарэс вортателэ дрома Раестирэ? ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","О васт Раеско обрисардо пэр тутэ, ту коравэса и сави-то вряма на авэса тэ дикхэс кхамэско удуд. И андэ кодья ж вряма авиле пэ якха Элимостэ калимос и рят, и вов ашыля тэ пхирэл кордэ-кардэ тай тэ родэл варикас, ко андярэла лэс палав васт. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Кала о проконсуло дикхля, со тердяпэ, вов дивосайля Раестирэ сытяримасти и патяйля. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Павло и всаворэ, ко сас лэса, плывисардэ андав Пафосо и авиле андэ Пергия, сави сас андэ Памфилия. Котэ о Иоано ашадя лэн и рисайля андо Иерусалимо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Андай Пергия онэ жыле майдур, андэ писидийско Антиохия. Андэ субота онэ авиле андэ синагога и бэшле. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Тунчи, кала пробиндэ андав Законо и Пророконэн, пхурэдэра синагогако бишалдэ, кай тэ пхэнэн лэнди: — Пхралалэ, сар исин тумэндэ лав, кай тэ подритярэн манушэн, пхэнэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Павло вщиля, вазгля о васт и пхэндя: — Мурша Израилёстирэ и всаворэ, ко дарал Дэвлэстар, ашунэнтэ ман! ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","О Дэл амаро народоско, Израилёско вытидя амарэн дадэн. Вов вазгля лэн, кала онэ сас андо Египтостири пхув, и выандярдя лэн котар зоралэ вастэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Саранда бэрша о Дэл додикхэлас пала лэндэ андэ мал. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Вов вымардя андо Ханаано эхта народонэн и отдя лэндирэ пхувья амарэ дадэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Кадя прожыля варикай штар шэла пандэша бэрша. Тунчи вов дэлас лэнди сындомарен жыкай пророко Самуило. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ай тунчи народо мангля пэсти тхагарас, и Дэл дя лэнди Саулос, шавэс Кишостирэс, андав родо Вениаминоско. Сауло сас тхагараса саранда бэрша. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Тунчи о Дэл зля лэ Саулос пав тхагаримос и тховдя Давидос. И пхэнэлас пала лэстэ: «Мэ аракхлем Давидос, шавэс Иесеёстирэс. Вов Манди кав води, и вов терэла вся, со Мэ камав». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Сар о Дэл и солахадя, Вов дя лэ Израилёсти андав родо Давидоско Фэрисаримарес Исусос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Жыкай вряма, кала авиля Исусо, Иоано акхарэлас всаворо народо Израилёско тэ каисавэн тай тэ болэнпэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Кала Иоано пэрэашэлас тэ терэл пэстири бути, вов пхэндя: «Пала кастэ тумэ ман прилэн? Мэ на Вов. Нэ палал мандэ жал Кодва, Савэстэ мэ на ашав тэ роспхандав Лэсти пэрналэ». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Пхралалэ, бэяцэ Авраамостирэ родостар и кола, савэ даран Дэвлэстар! Кадва лав фэрисаримаско сас бишалдо амэнди! ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Кола, ко жувэлас андо Иерусалимо, и лэндирэ пхурэдэра на ужангле Лэс. Онэ сындосардэ Лэс и калэса тердэ кода, со пхэнэнас лава пророкондирэ, савэ бинэнпэ кажно суботнё дес. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Онэ на аракхле андэ Лэстэ нисави ужылимос, пала со Лэс тэ умарэн, нэ всаекх вымангле Пилатостар, кай Лэс тэ умарэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Кала онэ тердэ кода, со пала Лэстэ сас пистросардо, онэ злинэ Лэс пав трушул и тховдэ андо склэпо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Нэ о Дэл жундярдя Лэс андай мулэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","И бут деса кола, савэ авиле Лэса Галилеятар андо Иерусалимо, дикхле Лэс. Ай икхатар онэ допхэнэн када англай мануша. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Кадя ж и амэ икхатар роспхэнас тумэнди Радосаво Лав: кода, пала со о Дэл дя лав амарэнди дадэнди, ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Вов тердя важ амэнди, лэндирэ бэяцэ, кала жундярдя Исусос андай мулэ. Сар андо дуйто псалмо пистросардо: «Ту Шаво Мэрно, адес Мэ бэяндэм Тут». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ай пала кода, со о Дэл жундярдя Лэс андай мулэ, кадя со Лэско тило никала на дикхэла прахо, Вов пхэндя кадя: «Мэ дава тумэнди свэнто бахталимос Давидоско, саво на парувэлапэ». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","И андэ авэр тхан Вов пхэндя: «Ту на дэса Свэнтонэсти Тирэсти тэ дикхэл прахо». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Давидо андэ пэстири вряма терэлас бути пай воля лэ Дэвлэстири, нэ вов муля, и лэс гарадэ лэстирэ дадэнца, и тило лэско ашыля прахоса. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Нэ Кодва, Кас о Дэл жундярдя андай мулэ, на ашыля прахоса. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Пхрала, колэсти мэ камав, кай тумэ тэ жанэн, со черэз Исусос тумэнди роспхэнэлпэ эртисаримос лэ бэзэхэндар. Андо Законо Моисеёско на сас зор тэ терэл тумэн жужэнца, ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","нэ всаворо, ко патяла андо Исусо, авэла жужо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Дикхэн, кай тумэнца тэ на терэлпэ кода, пала со пхэнэнас пророкоря: ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","«Подикхэн кола, ко асанпэ, дивосавэна и хасавэна! Мэ терава андэ тумарэ деса кацаво, андэр со бы тумэ никала на патянас, сар тумэнди тэ роспхэнэн пала када». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Кала Павло и Варнава выжанас андай синагога, лэн мангле тэ дэн дума пала када андэ авэр субота. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Мануша розжылепэ, нэ бут иудеёря и прозелиторя, савэ тэлёнас лэ Дэвлэсти, жыле палав Павло и Варнава, савэ умангэнас лэн, соб онэ тэ ашэнпэ андо мищимос лэ Дэвлэско. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Андэ авэр субота стидиля всаворо форо, кай тэ ашунэн лав Раеско. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Кала иудеёря дикхле скачи манушэн, онэ фартэ холяйле и линэ тэ акушэн Павлос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Нэ Павло и Варнава пхэндэ лэнди бидарако: — Лав Дэвлэско трэбуй сас майанглал тэ роспхэнэлпэ тумэнди. Нэ сар тумэ на прилэн лэс и на бинэн, со тумэ пативалэ, кай тэ прилэн вакоско жувимос, амэ акана жас кай найиудеёря. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Кадя припхэндя амэнди о Рай: «Мэ тердэм тут удудэса важ народоря, соб ту тэ андярэс фэрисаримос жыкай майдурутни пхув». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Кала найиудеёря ашундэ када, онэ радонаспэ и лашарэнас лэ Раес пала Лэско лав, и всаворэ кола, савэ сас вытидэ важ вакоско жувимос, патяйле. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Лав Раеско розжыляпэ пай всавори кодья пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Нэ иудеёря подмардэ жувлян андай пативалэ йиря и пхурэдэрэн андав форо и кола линэ тэ гонин Павлос и Варнавас и вытрадэ лэн андав лэнго тхан. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Тунчи онэ обмардэ о прахо пай пэстирэ пэрнэ и жыле андэ Икониё. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Сытярнэ ж пхэрдёнас лошаса и Свэнтонэ Духоса. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Андэ Икониё Павло и Варнава зажыле андэ иудеёндири синагога и пхэнэнас кадя, со патяйле фартэ бут иудеёря и грекоря. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ай иудеёря, савэ отпхэндэпэ тэ патян лэнди, вазгле пэ пхрала найиудеёнэн и тховдэ андэ лэндирэ водя вражымос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Нэ Павло и Варнава сас котэ бут вряма. Онэ бидарако пхэнэнас палав Рай, Саво допхэнэлас лав палав Пэско мищимос и дэлас лэнди зор тэ терэн диворя и шпэры. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Кола, ко жувэлас андо кадва форо, розжылепэ машкар пэстэ, екх подритярэнас иудеёнэн, ай авэр — апостолонэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Нэ кала найиудеёря тай иудеёря екхэтанэ пэстирэ пхурэдэрэнца камле тэ лажаварэн и тэ марэн лэн барэнца, ");
INSERT INTO rmyvlakh_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","онэ ужангле пала када и нашле андэ фороря Ликаониятирэ, Листра тай Дэрвия и паша лэндирэ пхувья. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Котэ онэ майдур роспхэнэнас Радосаво Лав. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Андэ Листра жувэлас мануш, насвало пэрнэнца; вов сас бангэса пэстирэ бэяндимастар и никала на пхирэлас. Вов бэшэлас ");
INSERT INTO rmyvlakh_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","и ашунэлас, со пхэнэлас Павло. Павло подикхля пэр лэстэ и удикхля, со колэстэ исин патявимос, кай тэ састярэлпэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","— Вщи пэ пэстирэ пэрнэ! — гласно пхэндя Павло. Кодва вщиля и ашыля тэ пхирэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Мануша дикхле, со тердя Павло, и линэ тэ цыписавэн пэ ликаониятири шыб: — Амэндэ авиле дэвла андо манушыкано образо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Онэ акхардэ Варнавас Зевсоса, ай лэ Павлос Гермесоса, колэсти со вов андярэлас и дума, сар пхурэдэр. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Англав форо сас храмо Зевсоско, и лэско рашай андя кай форостирэ удара гурувэн и вэнкоря. Вов камэлас екхэтанэ лэ манушэнца тэ анэл лэнди жэртва. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Кала апостолоря Варнава и Павло ашундэ пала када, онэ росшындэ пэстири йида, впрастае кай мануша тай линэ тэ цыпин: ");
INSERT INTO rmyvlakh_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","— Мануша, со тумэ терэн? Амэ кацавэ ж мануша, сар и тумэ, андэ тумэнди Радосаво Лав, и камас, кай тумэ тэ ашавэн шушэн идолонэн и тэ обрисавэн кав жундо Дэл, Саво тердя болыбэн, пхув и море тай вся, со андэр лэндэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Андэ дэлмутни вряма Вов домукля народонэнди тэ пхирэн пэстирэ дромэнца, ");
INSERT INTO rmyvlakh_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","нэ на пэрэашэлас тэ пхэнэл пала Пэстэ, терэлас лашымос, дэлас брышынд болыбнастар тай плодоря андэ пэстири вряма, дэлас хамос и пхэрдярэлас лошаса тумарэ водя. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Калэ лавэнца апостолоря барэ пхаримаса тердярдэ манушэн, соб онэ тэ на анэн лэнди жэртва. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Нэ иудеёря, савэ авиле андай Антиохия и Икониё, пэрэцырдэ манушэн пэ пэстири риг. Онэ лэ Павлос мардэ барэнца и выцырдэ палав форо, колэсти со гындонас, со вов муло. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Нэ кала сытярнэ стидэпэ паша лэстэ, Павло вщиля и жыля палпалэ андо форо. Ай пэ авэр дес вов и Варнава жыле котар андэ Дэрвия. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Андэ кадва форо онэ роспхэнэнас Радосаво Лав кадя, со бут мануша ашыле Раестирэ сытярнэнца. Тунчи онэ рисайле андэ Листра, Икониё и Антиохия. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Онэ подритярэнас лавэнца сытярнэн и мангэнас, кай онэ тэ ашэнпэ састэ андо патявимос. Онэ пхэнэнас: — Амэнди трэбуй тэ пэрэандярас бут грыжа, англай колэ, кала амэ аваса андо Тхагаримос Дэвлэско. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Андэ всаворэ кхандиря Павло и Варнава тховдэ пхурэдэрэн, манглепэ постоса тай пэрэдинэ лэн Раести, андо Саво онэ патяйле. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Тунчи онэ прожыле Писидия тай авиле андэ Памфилия. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Онэ пхэнэнас лав Дэвлэско андэ Пергия тай авиле андэ Аталия. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ай андай Аталия апостолоря плывисардэ палпалэ андэ Антиохия. Котар онэ, пав мищимос Дэвлэско, сас отдинэ по рындо, саво онэ и стердэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Кала онэ авиле, стидэ кхандири тай роспхэндэ палай вся, со о Дэл тердя черэз лэндэ, и сар Вов отпхэрнадя удар важ патявимос найиудеёнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Котэ апостолоря бут вряма сас екхэтанэ лэ сытярнэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Андай Иудея андэ Антиохия авиле мануша, савэ сытярэнас лэ пхралэн: — Сар тумэ на авэна обшындэ пав запхэнимос Моисеёско, тумэ на фэрисарэнапэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Черэз када онэ бут молоря ханаспэ лэ Павлоса и Варнаваса. Тунчи пхрала прилинэ, со лэ Павлости, Варнавасти тай аврэнди трэбуй тэ жан андо Иерусалимо, кай тэ дэн дума пала када лэ апостолонэнца и пхурэдэрэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Кола, кас бишалдя кхандири, прожанас Финикия тай Самария и роспхэнэнас котэ, сар патяйле авэр народоря. Кадай дума анэлас бари лош всаворэнди пхралэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Кала онэ авиле андо Иерусалимо, лэн прилинэ кхандири, апостолоря и пхурэдэра. Онэ роспхэндэ, со о Дэл тердя черэз лэндэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Нэ патикунэ андай фарисеёско стидимос пхэнэнас, со найиудеён трэбуй тэ обшынэн и тэ припхэнэн лэнди, кай онэ тэ жувэн пав Законо Моисеёско. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Апостолоря тай пхурэдэра стидэпэ, соб тэ роздикхэн кадва рындо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Онэ бут вряма дэнас дума пала када, ай тунчи Пэтро вщиля и пхэндя: — Пхралалэ, сар тумэ жанэн, прожыля бут вряма колэ десэстар, кала о Дэл вытидя ман тэ роспхэнав Радосаво Лав найиудеёнди, соб и онэ тэ патян. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","О Дэл жанэл водя манушэндирэ, и Вов дя допхэнимос колэсти, со прилэл найиудеён, кала дя лэнди даро Свэнтонэ Духос кадя ж, сар и амэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Вов жужардя лэндирэ водя черэз патявимос, ай икхатар англав Лэстэ амэ кацавэ ж, сар и онэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Тунчи пэр со тумэ холярэн лэ Дэвлэс колэса, со тховэн пэ сытярнэндирэ кора гамо, саво на сас зор тэ андярэн най амарэ дадэнди, най амэнди? ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Нэ амэ патяс, со амэн фэрисарэл мищимос лэ Раеско Исусоско кадя ж, сар и лэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Тунчи всаворэ ашыле мулком тай ашундэ, со роспхэнэнас Варнава и Павло палай шпэры и диворя, савэ о Дэл тердя черэз лэндэ машкар найиудеёря. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Кала онэ пэрэашыле тэ дэн дума, Иаково пхэндя: — Пхралалэ, выашунэнтэ ман. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Симоно роспхэндя амэнди пала кода, сар о Дэл англуно моло камля тэ стидэл важ Пэско алав народо андай найиудеёндирэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Када подритярэн пророкондирэ лава, савэ пхэнэн: ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","«Тунчи Мэ рисавава тай инке екх моло тховава катуна Давидостири, сави пэля. Мэ терава упалэ кода, со роспхагло, и ваздава ла, ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","кай авэр мануша тай всаворэ народоря, савэ сас акхардэ Мэрнэ алавэса, ашыле тэ родэн лэ Раес. Кадя пхэнэл Рай, Саво терэл када. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Када жангло дэлмутня вряматар». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Колэсти мэ бинав, со амэнди на трэбуй тэ тховас нисаво пхаримос важ найиудеёря, савэ обрисавэн кав Дэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Нэ тэ пистросарас лэнди лил, кай тэ на магрисавэн идолонэнца, тэ ритярэнпэ майдур лубимастар, тэ на хан мас скотостар, саво сас тасадо, и тэ на пэн о рат. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Колэсти со Законо Моисеёско дэлмутня вряматар бинэлпэ кажно субота андэ синагоги андо кажно форо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Тунчи апостолоря и пхурэдэра екхэтанэ всаворя кхандиряса линэ тэ вытидэн машкар пэстэ коискачи манушэн и тэ бишалэн лэн лэ Павлоса и Варнаваса андэ Антиохия. Онэ вытидэ Иудас, савэс инке акхарэнас Вар-Сава, и Силас. Кала мурша сас пхурэдэра машкар пхрала. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Онэ пистросардэ кацаво лил: «Пхрала апостолоря тай пхурэдэра — пхралэнди андай найиудеёря, савэ жувэн андэ Антиохия, Сирия тай Киликия. Тэ авэн бахталэ! ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Амэ ашундэ, со коисавэ мануша, савэ авиле амэндар, пхэндэ тумэнди кацавэ лава, андай савэ тумэнди ашыля наймишто по води. Нэ амэ на бишаласас лэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Колэсти амэ всаворэ екхэтанэ закамле тэ вытидас машкар амэндэ скачи манушэн тай тэ бишалас лэн тумэндэ екхэтанэ амарэ пативалэ пхралэнца Павлоса и Варнаваса, ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","савэ отдэн пэско жувимос пала алав амарэ Раеско Исусоско Христоско. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Амэ бишалас тумэндэ кадя ж лэ Иудас и Силас, соб онэ алавэнца тэ допхэнэн кода, со амэ пистросардэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Свэнто Духо и амэ на камас тэ тховас пэр тумэндэ нисаво пхаримос, сар качи акэ со: ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","тэ на хан хамос, саво анэнаспэ андэ жэртва идолонэнди, и мас скотостар, саво сас тасадо, тэ на пэн о рат и на терэн лубимос. Сар авэна кадя тэ терэн, тумэнди мишто авэла. Тэ авэн састэ!» ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Бишалдэ пхрала жыле тай авиле андэ Антиохия, стидэ котэ и кхандири тай пэрэдинэ о лил ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Кала мануша пробиндэ о лил, лошавэнас лавэнди, савэ подритярдэ лэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","О Иуда тай Сила, савэ сас пророкоря, пэстирэ лавэнца подритярдэ и састярдэ о патявимос лэ пхралэнго. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Онэ сас котэ сави-то вряма, и пхрала отмукле лэн мироса палпалэ кав апостолоря. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Павло лэ Варнаваса ашылепэ андо Антиохия, кай онэ бутэ аврэнца пхралэнца сытярэнас и роспхэнэнас лав Раеско. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Прожыля сави-то вряма и Павло пхэндя лэ Варнавасти: — Авэн жаса кай и пхрала пай всаворэ фороря, кай амэ роспхэнасас лав Раеско, и дикхаса, сар лэндэ жан рындоря. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Варнава камэлас тэ лэл пэса Иоанос, савэс акхарэнас Марко, ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","нэ Павло на закамля тэ лэл пэса колэс, ко ашадя лэн андэ Памфилия тай на терэлас лэнца бути. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Павло и Варнава похалепэ машкар пэстэ и кажно жыля андэ пэстири риг. Варнава ля лэ Маркос и плывисардя андо Кипро. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ай Павло вытидя пэсти Силас. Пхрала отдинэ лэс по мищимос Раеско, и вов жыля андо дром. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Вов прожалас черэз Сирия тай Киликия и подритярэлас лавэса и кхандиря. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Тунчи Павло авиля андэ Дэрвия и Листра. Котэ жувэлас сытярно, савэс акхарэнас Тимофеё. Лэстири дэй сас иудейка и патялас андо Рай, ай дад сас греко. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Палав Тимофеё сас лащи дума лэ пхралэндэ андай форо Листра тай Икониё. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Павло закамля тэ лэл лэс пэса андо дром. Тай важ иудеёря, савэ жувэнас котэ, обшындя лэс, важ кода со всаворэ жанэнас, со дад Тимофеёско сас греко. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Онэ пхирэнас андав екх форо андо авэр, пхэнэнас всаворэнди патикунэнди тэ терэн кода, со прилинэ апостолоря тай пхурэдэра андо Иерусалимо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Андэ кхандиря патикунэ ашэнас майсастэ андэ патявимос, и кажно дес лэн ашэнас майбут. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Онэ прожанас черэз Фригия тай Галатийско пхув, нэ Свэнто Духо на домукля лэн тэ роспхэнэн лав андэ Цыкни Азия. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Кала онэ поджыле кай Мисия, стидэпэ тэ жан андэ Вифиния, нэ Духо Исусоско на домукля лэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Тунчи онэ прожыле Мисия и авиле андэ Троасо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ай рятяса лэ Павлости сикадиля дикхимос: лэстэ авиля мануш андай Македония, вов тэрдёлас и мангэлас Павлос: — Ав андэ Македония и поможысар амэнди! ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Тунчи пала кадва дикхимос амэ полям, со о Дэл акхарэл амэн тэ пхэнас Радосаво Лав, и сыго гытосардямпэ тэ жас андэ Македония. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Андав Троасо амэ плывисардям ворта андэ Самофракия, ай котар пэ авэр дес андо Неаполи. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Андав Неаполи амэ жылям андэ Филипоря, римостири колония и майпхурано форо пай кодья риг Македониятири. Котэ амэ сас коискачи деса. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Тунчи андэ суботнё дес амэ выжылям палай форостирэ удара кай и лэн. Амэ гындосардэ, со котэ сас тхан важ мангимос. Амэ бэшле и линэ тэ дас дума лэ жувлянца, савэ котэ стидэпэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Котэ машкар лэндэ сас екх жувли, сави тэлёлас лэ Дэвлэсти. Ла акхарэнас Лидия, вой сас андав форо Фиатира. Вой битинэлас кучютни сынё-лоли материя. Вой ашунэлас Павлос и о Рай отпхэрнадя лако води тэ прилэл, со пхэнэлас о Павло. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Тунчи вой и кола, савэ жувэнас андо лако чер, прилинэ болдимос, и вой акхардя амэн пэстэ черэ. — Кала тумэ бинэн ман, сар патявимастири англав Рай, тунчи авэн и пожувэн мандэ черэ, — мангэлас вой амэн и умангля. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Екхвар, кала амэ жасас кав тхан, кай мангэнаспэ Дэвлэс, пав дром амэн дикхля бутярни, андэ сави сас драбатиримаско духо. Драбатиримаса вой анэлас барэ ловэ пэстирэнди хулаенди. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Вой жалас палав Павло и пала амэндэ и цыписавэлас: — Кала мануша — бутярнэ Майбарэ Дэвлэстирэ! Онэ роспхэнэн тумэнди, сар тэ фэрисарэнпэ! ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Вой када терэлас кажно дес, и кала лэ Павлости вся када надохаля, вов обрисайля и пхэндя лэ духости: — Важ алав Исусоско Христоско мэ припхэнав тути: выжа андар латэ! Андэ кодья ж вряма о духо выжыля латар. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Кала латирэ хулая полинэ, со лэндэ хасайля надия тэ затерэн ловэ, онэ хутилдэ лэ Павлос и Силас и цырдэ по форо кай рая. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Онэ андэ лэн кай форостирэ рая и пхэндэ: — Кала мануша — иудеёря, и онэ ваздэн манушэн андо амаро форо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Онэ роспхэнэн кода, со амэнди, римлянонэнди, нащи ни тэ прилас, ни тэ терас. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Бут мануша кадя ж ваздинэпэ по Павло и Сила, и рая припхэндэ тэ злэн пай лэндэ йида и тэ марэн лэн рулянца. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Лэн фартэ мардэ тай пхандадэ андо баруно, ай лэ халавдэсти барунэстар припхэндэ мишто тэ дикхэл пала лэндэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Кала халавдо приля кадва припхэнимос, вов запхандадя лэн андрал андо баруно и спхангля лэнди пэрнэ каштунэ лэпунзэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Варикай андэ епашрят Павло и Сила мангэнаспэ Дэвлэс и дилянца лашарэнас лэ Дэвлэс, ай авэр барунаря ашунэнас лэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","И акэ, пхув ля фартэ тэ тинолпэ, кадя со фундаменто барунэско ашыля тэ пхирэл риг ригатар. Всаворэ удара отпхэрнадэпэ, и всаворэ барунарэндэ спэле лэпунзэ пай пэрнэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Кала халавдо барунэстар, саво дикхэлас пала лэндэ, просутяпэ тай удикхля, со всаворэ удара барунэстирэ отпхэрнадэ, вов ля мечё и камля тэ мулярэл пэс. Вов гындолас, со всаворэ барунаря нашле. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Нэ Павло фартэ зацыписайля: — На тер пэсти бида! Амэ всаворэ андо баруно! ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Халавдо мангля удуд, запрастая андо баруно и даратар пэля кай пэрнэ Павлостирэ и Силастирэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Вов выандярдя лэн андав баруно и пушля: — Мэрнэ рая, со манди тэ терав, соб тэ фэрисавав? ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","— Патя андо Рай Исусо, — пхэндэ апостолоря. — Фэрисарэсапэ ту, и всаворэ, ко жувэл андо тиро чер. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Тунчи онэ пхэндэ лав Раеско лэсти и колэнди, ко жувэлас андо лэско чер. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Андэ кодья ж вряма рятяса о халавдо барунэско халадя лэнди помардэ тхана и сыго сас болдо, вов и всаворэ, ко жувэнас андо лэско чер. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Тунчи вов андя лэ Павлос и Силас пэстэ черэ и тховдя важ лэнди мэсали. Всаворэ колэнца, ко жувэнас андо лэско чер, вов лошавэлас колэсти, со патяйля андо Дэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Кала авиля дес, форостирэ рая бишалдэ пэстирэ бутярнэн припхэнимаса: — Отмукэн калэн манушэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Халавдо барунэстар пхэндя лэ Павлости: — Рая припхэндэ тэ отмукав тумэн! Жан лэ мироса! ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Нэ Павло пхэндя: — Амэн бисындоско мардэ англай мануша и на дикхле пэ кода, со амэ римляноря, ай тунчи шутэ амэн андо баруно. Ай икхатар онэ камэн тэ мукэн амэн, кай нико тэ на жанэл? Нат! Мэк онэ ежэнэ авэн и выандярэн амэн катар. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Тунчи бутярнэ роспхэндэ пала када лэ раенди, ай онэ здарайле, кала ашундэ, со Павло и Сила римляноря. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Онэ авиле и мангле, кай лэн тэ эртисарэн. Тунчи выандярэ лэн андав баруно тай мангле, кай кола тэ ужан андав форо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Кала Павло и Сила выжыле андав баруно, онэ жыле андо чер Лидиятэ. Котэ онэ дикхлепэ лэ пхралэнца и подритярдэ лэн лавэнца. Тунчи онэ жыле. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Кала онэ прожыле Амфиполи тай Аполония, авиле андэ Фесалоника, кай сас иудеёско синагога. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Павло, сар вов и терэлас всавори вряма, жыля кордэ и трин суботы сикавэлас лэнди андав Пистросаримос, ");
INSERT INTO rmyvlakh_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","роспхэнэлас и допхэнэлас, со Христости трэбуй сас тэ грыжолпэ тай тэ жундёл андай мулэ. — Исусо, пала Саво мэ тумэнди пхэнав, исин Христосо, — пхэнэлас Павло. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Лэнди патяйле коискачи иудеёря, кадя ж бут грекоря, савэ тэлёнас лэ Дэвлэсти и бут жанглэ жувля. Ай всаворэ онэ жыле палав Павло и Сила. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Авэр иудеёря холяйле пала када, онэ аракхле пэ тарго найлашэн манушэн, линэ лэн пэса, стидэ бут манушэн и вазгле всаворо форо. Онэ прастае кав чер Иасоноско, кай тэ родэн котэ Павлос и Силас тай тэ выандярэн лэн манушэндэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Нэ кала на аракхле лэн котэ, онэ поцырдэ Иасонос и аврэн пхралэн кай форостирэ пхурэдэра. — Кала мануша ваздэн лэ манушэн пай всавори люма, ай икхатар авиле и кардэ, — цыписавэнас онэ, ");
INSERT INTO rmyvlakh_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","— ай Иасоно приля лэн андо пэско чер. Онэ отжан лэ императоростирэ упхэнимастар и пхэнэн, со исин авэр тхагар, Савэс акхарэн Исусо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Народо и форостирэ пхурэдэра ашундэ када тай здарайле. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Онэ линэ лав и ловэ пав Иасоно и аврэн, ко сас лэса тай отмукле лэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Тунчи, сар качи авиля и рят, пхрала отбишалдэ лэ Павлос и Силас андэ Верия. Кала онэ авиле кордэ, жыле андэ иудеёндири синагога. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Верийцоря сас майотпхэрнадэ воденца, сар и фесалоникийцоря. Онэ всаворя зораса прилинэ кода, со пхэнэлас Павло, и кажно дес розлэнас Пистросаримос, кай тэ полэн, када чячимос чи нат. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Бут лэндар патяйле, кадя ж патяйле пативалэ гречянки и бут грекоря. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Нэ кала иудеёря андэ Фесалоника ужангле пала кода, со Павло роспхэнэл лав Дэвлэско андэ Верия, онэ авиле кордэ и ашыле тэ ваздэн и тэ холярэн лэ манушэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Тунчи и пхрала бишалдэ лэ Павлос кай море, ай о Сила и Тимофеё ашылепэ андо форо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Кола, ко проандярэлас лэ Павлос, авиле лэса андэ Афиноря, ай тунчи жыле палпалэ, колэсти со Павло дя лэнди запхэнимос, соб о Сила и Тимофеё майсыго тэ авэн лэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Кала Павло ажутярэлас лэн андэ Афиноря, вов дикхля, со кадя бут идолоря андэ кадва форо и калэстар лэсти сас наймишто по води. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Вов дэлас дума андэ синагога лэ иудеёнца и колэнца, савэ тэлёнас лэ Дэвлэсти, ай кадя ж кажно дес пэ тарго колэнца, ко авэлас кордэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Лэса дэнас дума коисавэ философоря — эпикурейцоря и стоикоря. Екх пушэнас: — Со кадва шыбало камэл тэ пхэнэл? Ай авэр пхэнэнас: — Вов пхэнэл амэнди пала авэр дэвла, — колэсти со Павло роспхэнэлас Радосаво Лав палав Исусо и Жундимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Онэ андэ Павлос андо Ареопаго и мангле: — Роспхэн амэнди, со када за нэво сытяримос, саво ту дэс дума? ");
INSERT INTO rmyvlakh_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ту роспхэнэс пала варисо, со амэ на полас, и амэнди камэлпэ тэ жанас, со када кацаво исин. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Афиняноря и мануша авэр пхувьятар, савэ жувэнас котэ, майфэдэр камэнас тэ дэн дума чи тэ ашунэн варисо нэво. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Тунчи Павло вщиля помашкар Ареопаго тай пхэндя: — Афиняноря! Мэ дикхав, со тумэ майбут всаворэндар тэлён лэ дэвлэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Мэ аракхлем екх жэртвенико, пэ саво сас пистросардо: «НАЙЖАНГЛЭ ДЭВЛЭСТИ». Мэ роспхэнав тумэнди пала Калэс Дэвлэс, Савэс тумэ на жанэн, ай всаекх тэлён Лэсти. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","О Дэл, Саво тердя всавори люма и вся, со пэр латэ, исин Рай болыбнаско и пхувьяко. Вов на жувэл андэ храморя, савэ тердэ вастэнца мануша. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Лэ Дэвлэсти на трэбуй, соб и мануша тэ терэн бути Лэсти пэстирэ вастэнца, сар наче Лэсти варисо на хутилэл. Вов Ежэно дэл всаворэнди манушэнди жувимос, зор и вся авэр. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Екхэ манушэстар Вов тердя всаворэ манушэн, соб онэ тэ жувэн пай всавори пхув, и пхэндя кай и кала онэ авэна тэ жувэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Вов тердя када, соб мануша тэ родэн тай тэ аракхэн Дэвлэс, нэ Вов чячес исин найдур кажнонэс амэндар. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Акэ, андэр Лэстэ амэ жувас, пхирас тай исин андэ люма, сар пхэнэн коисавэ тумарэ поэторя: «Ай амэ исин Лэско родо». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ай кала амэ родо Дэвлэско, амэнди на трэбуй тэ гындосарас, со о Дэл мэзимэ пэ кода, со тердо сомнакастар, рупэстар чи барэстар вастэнца тай годяса манушэндиряса. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Майанглал мануша на жанэнас Дэвлэс и Вов запхандэлас пэ када якха, нэ икхатар Вов припхэнэл всаворэнди пай всавори пхув тэ каисавэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Вов тховдя дес, кала Вов авэла тэ сындосарэл всавори люма пав чячимос, тай вытидя Манушэс, Саво и авэла сындомари. Вов допхэндя када всаворэнди, кала жундярдя Лэс андай мулэ! ");
INSERT INTO rmyvlakh_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Кала онэ ашундэ палай кода, со жундёна и мулэ, коисавэ лэндар ашыле тэ асан, ай авэр пхэндэ: — Пала када амэ поашунаса тут андэ авэр вряма. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Тунчи Павло жылятар котар. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Коискачи манушэн екхпатив патяйле тай жыле лэ Павлоса. Машкар лэндэ сас Дионисиё, мануш андав Ареопаго, инке жувли, савя акхарэнас Дамарь, и авэр. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Тунчи о Павло жылятар андай Афиноря и авиля андо Коринфо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Котэ вов дикхля иудеёс, савэс акхарэнас Акила, андав Понто. Вов найдэлмут авиля андай Италия пэстиря ромняса Прискиласа, колэсти со императоро Клавдиё припхэндя всаворэнди иудеёнди тэ ужан андав Римо. О Павло авиля тэ дикхэл лэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Ай лэндэ сас екх бути лэ Павлоса: онэ терэнас катуны, и колэсти Павло ашыляпэ лэндэ, кай тэ жувэл и терэл бути лэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Кажно субота вов дэлас дума андэ синагога лэ иудеёнца тай лэ греконэнца, кай тэ анэл лэн кав патявимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Ай кала андай Македония авиле Сила тай Тимофеё, о Павло отдя всавори пэстири вряма кай тэ пхэнэл о лав, допхэнэлас иудеёнди пала кода, со Исусо исин Христосо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Нэ кала онэ линэ тэ протисавэн и тэ акушэн лэс, вов обмардя о прахо пай пэстири йида тай пхэндя: — Кала тумэ хасавэна, када тумаро ужылимос! Мэ жужо, и акана жав кай найиудеёря. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Тунчи Павло выжыля андай синагога и жыля андо чер, саво сас пашэ. Котэ жувэлас Титиё Иусто, мануш, саво тэлёлас лэ Дэвлэсти. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ай пхурэдэр синагогако Криспо и всаворэ, ко жувэнас андо лэско чер, патяйле андо Рай. И бут андай коринфяноря, савэ ашунэнас лэ Павлос, патяйле и сас болдэ андо паи. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Екхвар рятяса о Рай пхэндя лэ Павлости андо суно: — На дара! Роспхэн майбут и на ашмулком. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Мэ туса, и нико на терэла тути вырито. Андэ кадва форо исин бут Мэрнэн манушэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","О Павло прожудя котэ екх епашэса бэрш тай сытярэлас лэн Дэвлэстирэ лавэсти. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Ай андэ кодья вряма, кала о Галионо сас проконсуло андэ Ахаия, иудеёря стидэпэ, нахукле по Павло тай андэ лэс по сындо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Онэ ашыле тэ ужылисарэн лэс: — Кадва мануш сытярэл лэ манушэн тэ тэлён лэ Дэвлэсти най кадя, сар сытярэл амаро Законо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Павло инке нисо на пхэндя, сар о Галионо обрисайля кай иудеёря: — Иудеёря, сар тумэ б ужылисарэнас лэс андэ кода, со вов тердя варисаво найчячимос чи сави-то бида, тунчи мэ выашунавас бы тумэндар. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Нэ сар катэ тумэ споринпэ палав сытяримос тай алава андав тумаро Законо, тунчи розлэн када ежэнэ. Мэ на камав тэ авав сындомареса андэ кала рындоря. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","И вов вытрадя лэн андав сындо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Тунчи всаворэ схутилдэ пхурэдэрэс синагогако Сосфэнос тай ашыле тэ марэн лэс англав сындомарёско тхан, нэ Галионо на закамля нисо тэ терэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Ай о Павло сас инке бут деса лэ пхралэнца. Тунчи вов простисайля лэнца и екхэтанэ лэ Прискиласа и Акиласа плывисардя андэ Сирия. Павло варикала дя лав Дэвлэсти и майанглал, сар тэ плывисарэл, вов обшындя пэстирэ бал андэ Кенхрэя. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Онэ авиле андо Эфесо. Котэ о Павло ашадя Прискилас и Акилас, ай ежэно жыля андэ синагога и дэлас дума лэ иудеёнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Онэ мангле лэс тэ ашэлпэ лэнца пэ сави-то вряма, нэ вов отпхэндя. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","— Мэ рисавава, сар авэла пэ када Дэвлэстири воля, — пхэндя Павло, ай тунчи простисайля лэнца тай плывисардя андав Эфесо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Вов вщиля пав кораблё андэ Кесария, авиля андо Иерусалимо, дикхляпэ лэ кхандиряса и жыля андэ Антиохия. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Павло пожудя сави-то вряма андэ Антиохия, ай тунчи вов жыля черэз Галатия и Фригия и пав дром подритярэлас лавэса всаворэ сытярнэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Тунчи андо Эфесо авиля иудеё, савэс акхарэнас Аполосо. Вов выбариля андэ Александрия и сас ервало мануш, саво мишто жанэлас Пистросаримос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Вов сас сытярдо Раестирэ Дромэсти и фартэ пхабардэс дэлас дума и пав чячимос сытярэлас палав Исусо, ай ежэно качи жанэлас болдимос Иоаноско. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Аполосо ашыля бидарако тэ роспхэнэл андэ синагога, ай кала Прискила и Акила ашунэнас лэс, онэ акхардэ лэс пэстэ и маймишто роспхэндэ лэсти палав Дром Дэвлэско. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Тунчи Аполосо камля тэ жал андэ Ахаия. Пхрала подритярдэ лэс тай пистросардэ лил сытярнэнди, кай мангле лэн тэ прилэн Аполосос. И кала вов авиля кордэ, бут поможысардя колэнди, ко патяйля пав Дэвлэско мищимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Пэ якха всаворэндар Аполосо зоралэс допхэнэлас лэ иудеёнди андав Пистросаримос, со Исусо исин Христосо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Андэ кодья вряма, кала Аполосо сас андо Коринфо, Павло прожыля пав плаендирэ пхувья и авиля андо Эфесо. Котэ вов аракхля коискачи сытярнэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","— Тумэ прилинэ Свэнтонэ Духос, кала патяйле? — пушля вов. — Амэ и на ашундэ палав кода, со исин Свэнто Духо, — пхэндэ онэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Тунчи Павло пушля: — Сар тумэ болдэпэ? — Кадя сар болэлас Иоано, — пхэндэ онэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Ай Павло пхэндя: — Иоано болэлас, кала мануша каисавэнас. Нэ вов акхарэлас лэ манушэн тэ патян андо Кодва, Саво трэбуй сас тэ авэл пала лэстэ, андо Исусо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Кала онэ ашундэ пала када, онэ прилинэ болдимос важ алав Раеско Исусоско. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Павло тховдя пэр лэндэ васта, и пэр лэндэ сжыля Свэнто Духо. Тунчи онэ ашыле тэ дэн дума аврэ шыбэнца и тэ пхэнэн лав Дэвлэстар. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Всаворэн лэн сас варикай дэшудуй мануша. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Павло трин шон бидарако дэлас дума андэ синагога и допхэнэлас котэ палав Дэвлэско Тхагаримос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Нэ коисавэ лэндар екх патив холявэнас и отпхэнэнаспэ тэ патя, англай всаворэ пхэнэнас найлашэ лава по Исусоско Дром. Тунчи Павло ашадя лэн. Вов вытидя пэсти сытярнэн и кажно дес дэлас дума лэнца андэ сытярди Тираностири. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Кадя прожыле дуй бэрша, и всаворэ иудеёря тай грекоря, савэ жувэнас андэ Цыкни Азия, ашундэ лав Раеско. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ай о Дэл терэлас Павлостирэ вастэнца барэ диворя. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Насвалэнди дэнас тэ лэнпэ кай кхоснорэ тай бутярни йида, савэндэ лэласпэ о Павло, и лэндэ прожалас насвалимос, тай холятирэ духоря выжанас андар лэндэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ай коисавэ иудеёря, савэ пхирэнас пай дрома и вытрадэнас духонэн, ашыле кадя ж тэ приакхарэн алав Раеско Исусоско пэ мануша, андэ савэндэ сас холятирэ духоря. Онэ пхэнэнас: — Припхэнав тумэнди алавэса Исусостирэса, пала Саво роспхэнэл Павло. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Када терэнас и эхта шавэн лэ Скэвастирэн, саво сас иудеёнго баро рашай. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Нэ холяко духо пхэндя: — Исусос мэ жанав, и пала Павло мэ ашунавас, ай тумэ ко кацавэ? ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","И мануш, андо саво сас холяко духо, хукля пэр лэндэ кацавя зораса, со помардя лэн всаворэн, и онэ нашле андав кадва чер нангэ и помардэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Кала иудеёря и грекоря, савэ жувэнас андо Эфесо, ужангле пала када, пэр лэндэ авиля бари дар, и онэ линэ тэ тховэн майбари патив кав алав Раеско Исусоско. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ай бут мануша, савэ патяйле, авэнас и англай всаворэ отпхэрнавэнас пэстирэ рындоря. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","И бут кола, ко драбатярэлас, анэнас пэстирэ драбатиримастирэ лила тай пхабарэнас англай всаворэ пэ яг. Ай кала пэрэбиндэ, скачи ловэ ашэн кала лила, выжыля варикай пандэша мии драхморя. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Кадя алав Раеско розжаласпэ пай тхана и терэласпэ майзорало. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Кала вся када прожыля, Павло приля андо Духо тэ жал андо Иерусалимо черэз Македония и Ахаия. — Кала мэ поавава андо Иерусалимо, тунчи манди трэбуй тэ жав кадя ж андо Римо, — пхэнэлас вов. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Павло бишалдя андэ Македония дуен пэстирэн бутярнэн, лэ Тимофеёс и Эрастос, ай ежэно ашыляпэ пэ сави-то вряма андэ Цыкни Азия. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Андэ кодья вряма вазглепэ и мануша по Дром Раеско. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Екх мануш, савэс акхарэнас Димитриё, терэлас андав руп цыкнэ храморя Артэмидако и дэлас тэ затерэн ловэ аврэнди бутярнэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Вов акхардя всаворэн бутярнэн кацавя бутятар и пхэндя: — Тумэ жанэн, со кадай бути дэл амэнди барвалэс тэ жувас. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ай тумэ дикхэн и ашунэн, со кадва Павло пэрэцырдя пэ пэстири риг бутэ манушэн на качи катэ андо Эфесо, нэ пай всавори Цыкни Азия. Вов пхэнэл, со дэвла, савэ стердэ вастэнца, на дэвла. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Мэ дарав, со на качи амари бути хасарэла лашо алав, нэ кадя ж и храмо баря дэвляко Артэмидако ашэлапэ нисоса. И ежэи дэвли, савяти тэлён всавори Цыкни Азия и всавори люма, хасарэла пэско баримос! ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Сар ашундэ када, онэ андай холи линэ тэ цыписавэн: — Бари Артэмида Эфесостири! ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Всаворо форо вазгляпэ. Всаворэ екхэтанэ онэ хутилдэ македонянонэн лэ Гаёс тай Аристархос, со пхирэлас лэ Павлоса, и поцырдэ лэн андо театро. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Павло камля тэ выжал кай и мануша, нэ сытярнэ на домукле лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","И коисавэ Азиятирэ барвалэ рая, амала Павлостирэ, бишалдэ лэстэ манушэн, кай тэ мангэн, соб вов тэ на авэл андо театро. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Мануша андо стидимос прастанас риг ригатэ, екх цыписавэнас екх, ай авэр цыписавэнас авэр. Майбут мануша на полэнас, сости онэ кордэ авиле. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Сар пхэндэ иудеёря, мануша выцырдэ пэ англал Александрос. Вов сикадя вастэса, кай тэ ашэн мулком, а ашыля тэ дэл думэл манушэндэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Нэ кала онэ ужангле, со вов иудеё, линэ тэ цыписавэн екхэ гласоса: — Бари Артэмида Эфесостири! И кадя цыписавэнас варикай дуй чясоря. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Тунчи фороско пистросаримари успокоисардя о народо и пхэндя: — Эфесяноря, чи на жанэл варико, со форо Эфесо фэрисарэл храмо баря Артэмидако тай лако образо, саво пэля пав болыбэн? ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Када чячимос, саво на трэбуй тэ допхэнэс. Колэсти тумэнди трэбуй тэ успокоинпэ и тэ на терэн бигодяко. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Тумэ андэ кардэ калэн манушэн, онэ на обчёрдэ храмо и на пхэндэ вырито лав пэ амари дэвли. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ай сар Димитриё и авэр рупунаря камэн варикас тэ ужылисарэн, пэ када амэндэ исин сындоря и проконсулоря. Кордэ мэк онэ и жан пэстирэ рындонца. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ай сар тумэндэ инке исин варисаво рындо, вов авэла продикхло андо стидимос пав законо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Мэ дарав, со пала кода, со тумэ адес вазглепэ, амэн терэна ужылэнца, колэстар со нинай черэз со тэ стидэн кацаво стидимос. Амэнди на авэла, со тэ пхэнэн. Тай кацавэ лавэнца вов розмукля о стидимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Кала всаворэ мануша пэрэашыле тэ цыписавэн, Павло акхардя сытярнэн, подритярдя лавэса, простисайля лэнца и жыля андэ Македония. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Вов прожалас черэз кадья пхув тай бутэнца лавэнца подритярэлас патикунэн. Кала Павло авиля андэ Грецыя. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Вов прожыля котэ трин шон. Ай кала вов камэлас тэ плывисарэл андэ Сирия, вов ужангля, со иудеёря гытосардэпэ тэ умарэн лэс. Тунчи вов приля тэ рисавэл черэз Македония. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Лэса жанас Сопатро, шаво Пироско андай Верия, фесалоникийцоря Аристархо тай Секундо, Гаё андай Дэрвия и Тимофеё, ай кадя ж Тихико и Трофимо андай Цыкни Азия. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Онэ жыле майанглэ и ажутярэнас амэн андэ Троасо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Кала прожыля свэнко Биквасно марнэско, амэ плывисардэ андай Филипоря тай черэз панч деса авиле лэндэ андэ Троасо. Котэ амэ сас эхта деса. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Андо англуно дес куркэско амэ стидиле екхэтанэ тэ пхагас о марно. Павло дэлас дума лэнца, и сар вов камэлас пэ авэр дес тэ жал андо дром, лэстири дума зацырдяпэ жыкай епашрят. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Упрэ андо чер, кай амэ стидэпэ, пхабонас бут каганцоря. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Ай пэ фэлястра бэшэлас тэрно мануш, савэс акхарэнас Эвтихо. И кадя сар о Павло лунго дэлас дума, о Эвтихо састэс засутя и пэля тэлэ пав трито этажо. Ай кала лэс вазгле, вов сас муло. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Павло змукляпэ, пашлиля упрал пэр лэстэ и обля лэс. — На даран, — пхэндя вов, — вов жундо! ");
INSERT INTO rmyvlakh_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Тунчи Павло жыля упрэ, пхагля о марно тай халя. Вов дэдумэлас жыкай дэнзор, ай тунчи жыля андо дром. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ай лэ шаворэс одандярдэ черэ жундэса, и всаворэ лошавэнас калэсти. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Павло припхэндя амэнди тэ бэшас по кораблё и тэ плывисарас андо Асо. Ежэно вов камэлас тэ жал дромэса пай пхув. Андо Асо амэнди трэбуй сас тэ дикхаспэ и тэ лас лэ Павлос по кораблё. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Кала Павло авиля андо Асо, амэ линэ лэс по кораблё и плывисардэ андэ Митилена. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Пэ авэр дес амэ выжыле котар андэ риг островос Хиосос. Кала прожыля инке дес, амэ плывисардэ кав острово Самосо, ай инке черэз дес авиле андо форо Милето. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","О Павло закамля тэ обжал о Эфесо ригаса, кай тэ на заритярдёл андэ Цыкни Азия, колэсти со вов грабияс и камэлас, сар выжала, тэ авэл андо Иерусалимо кав Пандэшако дес. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Андав Милето Павло бишалдя манушэн андо Эфесо, кай тэ мангэн пхурэдэрэн кхандирятирэн тэ авэн лэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ай кала кола авиле, вов пхэндя лэнди: — Тумэ жанэн, сар мэ жувавас тумэндэ всавори вряма пай англуно дес, кала мэ авилем андэ Цыкни Азия. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Мэ теравас бути важ о Рай бипхутимаско и ясвэнца и пэрэандряравас грыжы, савэ терэнас манди иудеёря. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Мэ на умукавас нисо колэстар, соб тумэнди тэ авэл мишто, роспхэнавас и сытяравас тумэн англай мануша пэ гасы и пай чера. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Мэ приакхаравас лэ иудеёнэн и греконэн, со лэнди трэбуй тэ каисавэн тай тэ обрисавэн кав Дэл и тэ патян андо амаро Рай Исусо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Нэ икхатар о Духо припхэнэл манди, кай мэ тэ жав андо Иерусалимо, и мэ на жанав, со котэ манца авэла. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Мэ жанав, кай андо кажно форо Свэнто Духо допхэнэл манди пала кода, со ман ажутярэн лэпунзэ и грыжа. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Важ мандэ мэрно жувимос нисо на ашэл, качи камав тэ дожав пэско дром и тэ дотерав бути, сави манди дя Рай Исусо, — тай допхэнав Радосаво Лав палав мищимос Дэвлэско. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Ай икхатар мэ жанав, со тумэ всаворэ, каса мэ сымас и касти роспхэнавас палав Тхагаримос, никала ман майбут на дикхэна. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Важкода мэ пхэнав адес: мэ на авава ужыло, ни андэр кастиро хасаримос, ");
INSERT INTO rmyvlakh_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","колэсти со мэ нисо на промуклем и роспхэндэм тумэнди пала всавори Дэвлэстири воля. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Дикхэн пала пэстэ и палав всаворо стадо, андо саво Свэнто Духо тховдя тумэн дикхимаренца, кай тумэ тэ пасын кхандири Дэвлэстири, пала сави Вов путиндя Пэстирэ ратэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Мэ жанав, со кала мэ ужава, тумэндэ авэна холятирэ рува, савэ на тангосарэна о стадо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Тай машкар тумэндэ авэна мануша, савэ ашэна тэ пэрэболдэн о чячимос, соб тэ уандярэн лэ сытярнэн пала пэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Колэсти дикхэн мишто! Сэрэн кода, со мэ трин бэрша ясвэнца, дес и рят сытяравас годяти кажнонэс тумэндар. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Ай икхатар мэ отдав тумэн лэ Дэвлэсти и Лэстирэ мищимастирэ лавэсти, савэстэ исин зор тэ терэл састэса тумаро патявимос и дэла тумэнди барвалимос машкар Лэско свэнто народо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Мэ никастар на лавас ни руп, ни сомнак, ни йида. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ай тумэ ежэнэ жанэн, со мэ акалэ пэстирэ вастэнца затеравас по жувимос пэсти и колэнди, савэ сас манца. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Андэр вся мэ сикававас тумэнди, со кадя трэбуй тэ терас бути, тэ поможысарас чёрорэнди и тэ сэрас лава Раестирэ Исусостирэ: «Майбахтало исин кодва, ко дэл, сар кодва, ко лэл». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Кала Павло пхэндя када, вов тэрдиля пэ чянга всаворэнца и мангля Дэвлэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Всаворэ фартэ ровэнас тай облэнас лэ Павлос и чюминдэнас лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Онэ фартэ грыжонаспэ палай кода, со майбут никала лэс на дикхэна. Тунчи онэ проандярдэ лэ Павлос кав кораблё. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Кала амэ простисайле лэнца, тунчи выжыле андо море и плывисардэ ворта по острово Косо. Пэ авэр дес амэ авиле по острово Родосо, ай котар — андэ форо Патара. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Котэ амэ аракхле кораблё, саво плывисарэлас андэ Финикия, бэшле пэр лэстэ и жыле майдур. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Амэ прожыле о Кипро, ашадэ лэс пай лево риг тай жыле пэ Сирия. Ай котэ авиле кав бэрэго андо Тиро, колэсти со котэ амарэсти кораблёсти трэбуй сас тэ ашавэл грузо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Андо Тиро амэ аракхле сытярнэн и сас лэндэ эхта деса. Онэ Духоса пхэнэнас лэ Павлости, кай тэ на жал андо Иерусалимо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ай кала авиля вряма, амэ жыле майдур. Всаворэ сытярнэ, лэндирэ ромня и бэяцэ проандярэнас амэн андав форо, тай по бэрэго амэ тэрдиле пэ чянга и манглепэ Дэвлэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Амэ простисайле лэнца и бэшле по кораблё, ай онэ рисайле черэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Амэ плывисардэ майдур и андав Тиро авиле андэ Птолемаисо. Котэ дикхлепэ лэ пхралэнца тай проандярдэ лэнца екх дес. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ай пэ авэр дес амэ жыле андо дром и авиле андэ Кесария и ашылепэ андо чер кав Филипо-благовестнико, вов сас екх андай эхта диаконоря Дэвлэстирэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Лэстэ сас штар щея. Онэ на сас пала ромэстэ тай пхэнэнас лав Дэвлэстар. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Тунчи, кала амэ сас котэ бут деса, андай Иудея авиля пророко, савэс акхарэнас Агаво. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Вов поджыля амэндэ, ля Павлостири кущик, спхангля пэстирэ васта тай пхэндя: — Свэнто Духо пхэнэл: «Акадя иудеёря андо Иерусалимо спхандэна и отдэна андэ васта найиудеёнди колэс, кастири исин кадья кущик». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Кала амэ и кола, ко жувэлас котэ, ашундэ када, ашыле тэ мангас лэ Павлос тэ на жал андо Иерусалимо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Нэ Павло пэ када пхэндя: — Пэр со тумэ ровэн и росшынэн манди о води? Мэ гытосардо най качи тэ авав спхангло, нэ и тэ мэрав андо Иерусалимо важ алав Раеско Исусоско. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Кала амэндэ на выжыля тэ парувас лэско гындо, ашыле мулком тай пхэндэ: — Мэк авэла воля лэ Раестири. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Кала прожыля коискачи деса амэ стидэпэ и жыле андо Иерусалимо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Амэнца жыле коисавэ сытярнэ андай Кесария. Онэ андэ амэн андо чер Мнасоноско андав Кипро, саво сас дэлмутно сытярно, амэ ашылепэ лэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Кала амэ авиле андо Иерусалимо, пхрала лошаса прилинэ амэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Пэ авэр дес Павло екхэтанэ амэнца жыля кав Иаково. Котэ сас всаворэ пхурэдэра. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Павло дя лэнди о васт и роспхэндя пала вся кода, со о Дэл тердя машкар найиудеёря черэз лэстири бути. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Онэ выашундэ лэс тай лашардэ лэ Дэвлэс. Тунчи онэ пхэндэ Павлости: — Пхрала, ту дикхэс, скачи мии иудеёрэн патяйле, и всаворэ онэ фартэ ритярэнпэ палав Законо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ай пала тутэ онэ ашундэ, со ту сытярэс иудеёнэн, савэ жувэн машкар найиудеёря, тэ отжан лэ Моисеёстирэ Законостар и пхэнэс, тэ на обшынэн пэстирэ шавэн тай тэ на жувэн кадя, сар амэндэ прилито. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Со ж тэ терас? Онэ екхпатив ужанэна, кай ту авилян. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Колэсти стер када, со амэ пхэнаса. Машкар амэндэ исин штар мануша, савэ солахадэ англав Дэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ай ту лэ лэн, прожа лэнца жужаримаско обрядо и потин пала лэндэ, кай онэ тэ обшынэн и бал по шэро. Ай тунчи всаворэ дикхэна, со кода, со пала тутэ пхэнэн, начячимос, и со ту жувэс пав Законо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ай со трэбуй тэ терэн лэ патикунэнди найиудеёнди, амэ пистросардэ, сар лэнди тэ жувэн: нащи тэ хан хамос, саво анэн андэ жэртва идолонэнди, тэ на пэн рат и тэ на хан мас пай тасадо ското, тай тэ на терэн лубимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Тунчи пэ авэр дес о Павло ля пэса калэн манушэн и прожыля екхэтанэ лэнца жужаримаско обрядо. Тунчи вов зажыля андо храмо и пхэндя, кала жужаримос прожала и кала пала кажно лэндар анэна жэртва. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Кала прожыле эхта дес, коисавэ иудеёря андай Цыкни Азия удикхле лэ Павлос андо храмо, вазгле пэр лэстэ всаворэн манушэн тай хутилдэ лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Онэ цыписавэнас: — Мурша Израилёстирэ! Поможысарэн! Акэ мануш, саво андэ всаворэ тхана сытярэл вырито всаворэн манушэн пала амаро народо, амаро Законо и храмо. Ай икхатар вов андя андо храмо греконэн, соса и магрисардя кадва свэнто тхан. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Жы калэстэ онэ дикхле андо форо лэ Павлос екхэтанэ лэ эфесяниноса Трофимоса и гындосардэ, со Павло андя лэс андо храмо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Андо всаворо форо вазглепэ и стидэпэ и мануша. Ай лэ Павлос схутилдэ, выцырдэ андав храмо и удара лэ храмостирэ сыго запхандадэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Онэ камэнас тэ умарэн лэ Павлос, нэ дума пала када, со всаворо Иерусалимо вазгляпэ, дожыля кав миенго римсконэс полкос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Вов сыго ля халавдэн и коискачи шэлэнгонэн тай прастая кордэ, кай стидэпэ мануша. Кала иудеёря удикхле пхурэдэрэс мия халавдэн и лэстирэ халавдэн, онэ пэрэашыле тэ марэн лэ Павлос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ай пхурэдэр мия халавдэн поджыля, ля лэ Павлос и припхэндя тэ спхандэн лэс дуе лэпунзэнца. И пушэлас кай мануша, ко вов кацаво и со вов тердя. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Нэ сар мануша цыписавэнас кажно пэско и лэстэ на выжыля тэ ужанэл чячимос, вов припхэндя тэ одандярэн лэ Павлос андо халавдэнго чер. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Кала онэ сас пэ лестница, бут мануша стасавэнас пай рига кадя, со халавдэнди прижыляпэ тэ андярэн лэ Павлос пэ васт. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Пала лэндэ жанас бут мануша и цыписавэнас: — Миримос лэсти! ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Ай кала поджыле кав халавдэнго чер, Павло пхэндя миенгости: — Чи домукэлпэ манди тэ пхэнав тути варисо? — Ту жанэс греконэндири шыб? — пушля пхурэдэр мия халавдэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","— Тунчи ту на кодва египтянино, саво коискачи вряма палпалэ вазгля лэ манушэн и уандярдя андэ мал штар мии прахарен? ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Ай о Павло пхэндя: — Мэ иудеё андав Тарсо, саво андэ Киликия, мануш барэ форостар. Мангав тут, дэ манди тэ пхэнав лав кай мануша. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","И кала о пхурэдэр домукля лэс тэ дэл дума, о Павло вщиля пэ лестница и сикадя вастэса, кай тэ ашэн мулком и мануша. Ай кала онэ ашыле мулком, вов задя дума пай евреёнэндири шыб. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","— Пхрала и дада! Дэн манди тэ пхэнав лав пала пэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Кала онэ ашундэ, со вов дэл дума пай евреёнэндири шыб, тунчи всаворэ инке майфартэ заашыле мулком. Вов пхэндя: ");
INSERT INTO rmyvlakh_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","— Мэ иудеё, саво бэяндилем андо Тарсо андэ Киликия, нэ выбарилем андэ кадва форо. Мэ сымас мишто сытярдо Законости амарэ дадэнго кав Гамалиило. Мэ всаворэ водеса прэдино лэ Дэвлэсти, сар и кажно тумэндар адес. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Мэ гонисаравас и маравас жыкай миримос колэн, ко жалас Раестирэ Дромэса, астаравас лэ муршэн и лэ жувлян тай шавас лэн андо баруно. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Допхэнимаря калэсти, со пхэнав, — баро рашай и стидимос пхурэдэрэнго. Мэ прилем лэндар лила кай пхрала андо Дамаско и жылем кордэ, соб тэ лав колэн, ко жалас пав Дром и тэ анав лэн андо Иерусалимо, кай тэ помарэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Пав дром, кала мэ поджавас кав Дамаско, варикай андо епашдес, кала мэ на ажутяравас, мэ ашылемпэ андрал баро удуд болыбнастар, пэ саво нащи сас тэ дикхав. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Мэ пэлем пэ пхув и ашундэм гласо, саво пхэнэлас манди: «Савло! Савло! Сости ту гонисарэс Ман?» ");
INSERT INTO rmyvlakh_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Мэ пушлем: «Ко Ту, Рай?» Вов пхэндя: «Мэ Исусо андав Назарето, Савэс ту гонисарэс». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Кола, ко сас манца, дикхле удуд, нэ гласо, саво мэ ашундэм, онэ на ашундэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Мэ пушлем: «Рае, со манди тэ терав?» Ай о Рай пхэндя манди: «Вщи и жа андо Дамаско. Котэ тути пхэнэна вся, со тути трэбуй авэла тэ терэс». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Удуд, саво мэ дикхавас сас кацаво зорало, со мэ корайлем. Колэсти кола, савэ сас манца, андэ ман палав васт андо Дамаско. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Котэ мандэ авиля дэвлэкуно мануш, савэс акхарэнас Анания. Вов тэрэлас вся, со пхэнэлас Законо, тай всаворэ иудеёря, савэ жувэнас котэ, пативаса обжанаспэ лэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Вов тэрдиля паша мандэ тай пхэндя: «Пхрал Савло, мэк отпхэрнавэнпэ тирэ якха!» И андэ кодья ж вряма мэ ашылем тэ дикхав и дикхлем калэс манушэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Вов пхэндя манди: «Дэл амарэ дадэнго вытидя тут, кай ту тэ ужанэс Лэстири воля, тэ удикхэс Чячимастирэс и тэ ашунэс гласо андай Лэстирэ ушта. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ту авэса тэ пхэнэс всаворэнди манушэнди пала вся, со ту дикхлян и ашундян. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ай икхатар, со ту цырдэс вряма! Вщи, акхар Лэско алав, прилэ болдимос тай схалав пэстирэ бэзэха». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Тунчи мэ рисайлем андо Иерусалимо, и кала мэ мангаваспэ Дэвлэс андо храмо, манди сикадяпэ дикхимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Мэ дикхлем Раес, Саво пхэндя манди: «Майсыго выжа андав Иерусалимо, колэсти со катэ на прилэна тиро допхэнимо пала Мандэ». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ай мэ пхэндэм: «Рай, кала мануша жанэн, со мэ пхиравас андай екх синагога андэ авэр синагога, соб тэ лав и тэ марав колэн, ко патял андэр Тутэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","И кала питялас о рат пав Стэфано, саво сас Тиро допхэнимари, мэ тэрдювавас котэ, подритяравас колэн, ко умарэлас лэс, и дикхавас палай лэндири йида». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Тунчи Вов пхэндя манди: «Жа, Мэ бишалав тут дур кай найиудеёря». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Жыкай кала лава мануша ашунэнас Павлос, нэ катэ ашыле тэ цыписавэн: — Тэ скхосэ лэс пхувьятар! Лэсти на трэбуй тэ жувэл! ");
INSERT INTO rmyvlakh_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Онэ цыписавэнас, сшынэнас пэр пэстэ йида и шонас упрэ пош. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Пхурэдэр мия халавдэн припхэндя тэ уандярэн лэ Павлос андо халавдэнго чер. Вов припхэндя тэ марэн лэс чюкнянца тай тэ допушэн, пала со и мануша ваздэнпэ пэр лэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Нэ кала лэ Павлос припхангле кущикэнца, соб тэ марэн, вов пхэндя шэлэнгости, саво тэрдёлас паша лэстэ: — Чи домукэлпэ тумэнди тэ марэн чюкнянца римостирэс манушэс, тай инке бисындоско? ");
INSERT INTO rmyvlakh_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Кала шэлэнго када ашундя, вов жыля и допхэндя пхурэдэрэсти мия халавдэн. — Со ту терэс? Када римоско мануш, — пхэндя вов. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Пхурэдэр выжыля кав Павло тай пушля: — Ту римоско мануш? — Агэ, — пхэндя Павло. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Тунчи пхурэдэр пхэндя: — Манди трэбуй сас тэ потинав бут ловэ, соб тэ авав римоско мануш. — Ай мэ бэяндилем римоско манушэса, — пхэндя Павло. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Кола, савэ камле лэс тэ допушэн, сыго отжыле лэстар. Пхурэдэр пэрэдарайля, кала ужангля, со вов спхангля лэпунзэнца римостирэс манушэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ай пэ авэр дес пхурэдэр мия халавдэн камэлас чячес тэ ужанэл, андэр со иудеёря ужылисарэнас Павлос, роспхангля и лэпунзэ тай припхэндя, соб тэ стидён барэ рашая тай всаворо Синедрионо. Тунчи вов андярдя Павлос и тховдя англай лэндэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Павло мишто вдикхляпэ пэ Синедрионо и пхэндя: — Пхралалэ, жыкай адесутно дес мэ жувавас жужаса пативаса англав Дэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Катэ о баро рашай Анания припхэндя колэнди, ко тэрдёлас пашэ лэ Павлоса, тэ арэсэл лэс пай ушта. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Тунчи Павло пхэндя: — О Дэл арэсэла тут, дуемуенго мануш! Ту бэшэс катэ, соб тэ сындосарэс ман пав Законо ай ежэно отжас лэ Законостар, и припхэнэс тэ марэн ман! ");
INSERT INTO rmyvlakh_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Кола, савэ тэрдёнас пашав Павло, пхэндэ лэсти: — Ту со, акушэс лэ барэ рашаес лэ Дэвлэс? ");
INSERT INTO rmyvlakh_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Ай Павло пхэндя: — Пхралалэ, мэ на жанглем, со вов баро рашай. О Пистросаримос пхэнэл: «На пхэн вырито палав пхурэдэр тирэ народостар». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Павло жанэлас, со андо Синедрионо екх сас садукеёря, ай авэр — фарисеёря. Колэсти вов зоралэ гласоса пхэндя: — Пхрала, мэ фарисеё, шаво фарисеёстиро! Ай ман сындосарэн палай надия, со мулэ жундёна. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Кала вов када пхэндя, фарисеёря тай садукеёря ашыле тэ споринпэ, и стидимос розжыляпэ андэ дума. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Колэсти со садукеёря пхэнэн, со и мулэ на жундён и нинай ни ангелонэн, ни духонэн. Ай фарисеёря патян, со исин и кода и авэр. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Вазгляпэ баро цыпимос, коисавэ сытяримаря Законостирэ андай фарисеёря холяса пхэндэ: — Амэ на дикхас андэ кадва мануш нисо вырито. Со, кала лэсти пхэнэлас духо чи ангело? ");
INSERT INTO rmyvlakh_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Онэ линэ тэ споринпэ кадя, со пхурэдэр мия халавдэн дарайля, соб лэ Павлос тэ на росшынэн пэ котора, и припхэндя халавдэнди зораса тэ выхутилэн лэс лэндар и тэ уандярэн андэ халавдэнго чер. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Пэ авэр рят кав Павло авиля о Рай и пхэндя: — Ав састэса! Сар ту допхэнэсас пала Мандэ андо Иерусалимо, кадя ж ту трэбуй тэ допхэнэс и андо Римо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Ай дэнзор коисавэ иудеёря стидэпэ и солахадэ нисо тэ на хан и тэ на пэн жыкай, кала умарэна лэ Павлос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Кадя допхэндэпэ тэ терэн варикай саранда манушэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Онэ жыле кай барэ рашая и пхурэдэра тай пхэндэ: — Амэ солахадям нисо тэ на лас андо муй, жыкай на умараса лэ Павлос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Ай икхатар тумэ и Синедрионо мангэн пхурэдэрэс мия халавдэн тэ анэн лэс тумэндэ важ кода, соб майпашэ тэ роздикхэн лэско рындо. Ай амэ аваса гытомэ и умараса лэс инке жыкай, кала вов дожала кардэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Палай кадай чёрэхани дума ужангля лэ Павлоско пхэятиро шаво. Вов жыля андо халавдэнго чер и роспхэндя када лэ Павлости. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Тунчи Павло подакхардя екхэс андай шэлэнго и пхэндя лэсти: — Одандярэн акалэс шаворэс кав пхурэдэр мия халавдэн, лэстэ исин варисо тэ пхэнэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Пхурэдэр шэлэн халавдэн одандярдя лэ шаворэс кав пхурэдэр мия халавдэн и пхэндя: — Павло, саво бэшэл затердо, акхардя ман и мангля тэ анав калэс шаворэс тутэ. Лэстэ исин варисо тэ пхэнэл тути. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Пхурэдэр мия халавдэн ля лэ шаворэс палав васт, одандярдя андэ риг тай пушля: — Со ту манди камэс тэ роспхэнэс? ");
INSERT INTO rmyvlakh_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Шаворо пхэндя: — Иудеёря допхэндэпэ тэ мангэн тут, соб ту тэ анэс тэся лэ Павлос по Синедрионо, сар бы важ кода, соб майфэдэр вся тэ ужанэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Нэ ту калэсти на патя, колэсти со лэс поджутярэн майбут, сар саранда манушэн. Онэ солахадэ тэ на хан и тэ на пэн, жыкай на умарэна лэс. И онэ тэрдён гытосардэ и ажутярэн, со ту стерэса кадя, сар онэ мангле. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Тунчи пхурэдэр мия халавдэн отмукля шаворэс тай пхэндя лэсти: — Никасти на роспхэн пала кода, со ту манди пхэндян. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Тунчи пхурэдэр мия халавдэн выакхардя дуй пхурэдэрэн шэлэн халавдэн и припхэндя: — Гытосарэн дуйшэл халавдэн, эхтадэш, савэ бэшэн пэ граста, и дуйшэл, савэ андярэн копьюря, кай тэ жас андэ Кесария андэ иня чясоря ратятерэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Гытосарэн лэ Павлости грастэс, кай бибидако тэ доладэл вов кав баро рай Фэликсо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","И вов пистросардя кацаво лил: ");
INSERT INTO rmyvlakh_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«Клавдиёстар Лисиёстар, Пативалэсти барэ раести Фэликсости: Тэ авэс бахтало! ");
INSERT INTO rmyvlakh_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Иудеёря схутилдэ калэс манушэс и стидэнаспэ тэ умарэн лэс. Нэ мэ ужанглем, со вов римоско мануш, авилем халавдэнца и фэрисардэм лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Мэ камлем тэ ужанав, андэр со онэ лэс ужылисарэн, тай андэм лэс андэ лэнго Синедрионо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Мэ аракхлем, со онэ ужылисарэн лэс пала лэнго Законо, нэ пэ лэстэ нинай нисаво ужылимос, пала сави трэбуй тэ умарэн чи тэ запхандавэн андэ лэпунзэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Нэ кала манди пхэндэ, со лэс камэн тэ умарэн, тай мэ сыго одандярдэм лэс тутэ и припхэндэм колэнди, ко ужылисарэл лэс, тэ допхэнэн пэстирэ лава англав тутэ». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Тунчи халавдэ тердэ кода, со лэнди припхэндэ, линэ Павлос тай рятяса андярдэ андэ Антипатрисо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ай пэ авэр дес халавдэ пэ граста андярдэ лэс майдур, а авэр халавдэ рисайле андо халавдэнго чер. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Кала кола, савэ ладэнас пэ граста, авиле андэ Кесария, отдинэ о лил барэ раести тай пэрэдинэ лэсти Павлос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Баро рай пробиндя лил тай пушля Павлостар, андай сави вов пхув. Кала вов ужангля, со Павло андай Киликия, ");
INSERT INTO rmyvlakh_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","пхэндя: — Мэ выашунава тут кала авэна кола, ко ужылисарэл тут, — и припхэндя соб лэ Павлос тэ запхандавэн андо баро чер Иродоско. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Кала прожыле панч деса, баро рашай Анания, коисавэ пхурэдэра, тай мануш саво жанэл законо Тертуло авиле андэ Кесария, соб тэ ужылисарэл англав баро рай лэ Павлос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","3","Ай сар заандярдэ лэ Павлос, о Тертуло ашыля тэ ужылисарэл лэс. — Пативало Фэликсо! Ту и тирэ годятирэ парувима важ амаро народо андярэн амэнди састо миро. Амэ пэ всаворэ тхана и андэ всавори вряма прилас када и наисарас тут. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Кай тэ на залав тири вряма, мэ мангав тут пав пэско мищимос выашун мэрно налунгуно лав. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Амэ аракхас, со кадва мануш — сар найлащи дукх. Вов ваздэл лэ иудеёнэн пай всавори люма и исин пхурэдэр пай назаретоско стидимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","7","Вов кадя ж камэлас тэ магрисарэл о храмо. Колэсти амэ схутилдэ лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Кала ту допушэса лэс, ту ежэно ужанэса пала вся, андэр со амэ ужылисарас лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Иудеёря кадя ж ужылисарэнас лэ Павлос и пхэнэнас, со када вся чячимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Баро рай сикадя лэ Павлости, кай вов тэ дэл дума, и кодва ашыля тэ пхэнэл: — Мэ жанав, со ту бут бэрша сындос кадва народо, и колэсти лошаса пхэнава лав пала пэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Тути напхарэс авэла тэ ужанэс кода, со на майбут, сар дэшудуй деса палпалэ мэ авилем тэ тэлював Дэвлэсти андо Иерусалимо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Кола, савэ ман ужылисарэн, на дикхле, кай мэ тэ спорисавав варикаса андо храмо и тэ ваздав лэ манушэн андэ синагоги тай андэ саво-то тхан фороско. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Онэ на допхэнэна кода, андэр со икхатар ман ужылисарэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Мэ прижандював тути, со жав пав Дром Раеско, саво онэ акхарэн хохавно сытяримос. Мэ тэлював Дэвлэсти амарэ дадэнго, патяв всаворэсти, со пистросардо андо Законо тай андэ пророкондирэ лила. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Мандэ кацави ж надия по Дэл, сар и колэндэ манушэндэ, — надия, со чячимастирэ и найчячимастирэ жундёна мулэндар. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Важ кода мэ терав вся, кай тэ жував жужаса пативаса англав Дэл и англай мануша. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Мэ на сымас катэ коискачи бэрша, ай тунчи авилем андо Иерусалимо, кай тэ пэрэдав мэрнэ народости ловэ, савэ стидэ важ чёрорэ, и тэ анав жэртва. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Ай ман дикхле андо храмо, кала мэ теравас жужаримаско обрядо. Катэ на сас нисаво цыписаримаско стидимос, и нико на ваздэласпэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Жыкай кала авиле коискачи иудеёря андай Цыкни Азия. Лэнди и трэбуй сас ман тэ ужылисарэн, сар исин андэр со. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Мэк мануша, савэ катэ исин, пхэнэн, саво найчячимос онэ аракхле андэ кода, со мэ теравас, кала ман допушэлас Синедрионо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Мэ домукав, со ужыло андо кода, со, кала тэрдювавас котэ, цыписайлем: — Ман сындосарэн пала кода, со мэ патяв, со жундёна мулэ! ");
INSERT INTO rmyvlakh_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Тунчи Фэликсо, саво майфэдэр жанэлас пала Дром, пхэндя: — Мэ пхэнава пэско лав палав кадва рындо, кала авэла пхурэдэр мия халавдэн Лисиё. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Вов припхэндя пхурэдэрэсти шэлэн халавдэн тэ дикхэл палав Павло, нэ тэ дэл лэсти найбут воля и тэ домукэл лэстирэ амалэн тэ подритярэн лэ Павлос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Кала прожыле коискачи деса, о Фэликсо авиля пэстиря ромняса, сави сас иудейка, ла акхарэнас Друзила. Вов бишалдя палав Павло, кай тэ поашунэн палав лэско патявимос андо Исусо Христосо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Павло дэлас дума палав жужымаско жувимос, со трэбуй тэ ритярэл пэс андэ васта и палав сындо, саво авэла. Фэликсо пэрэдарайля тай пхэндя: — Хутилэла пэ адес! Жатар! Сар трэбуй авэла, мэ тут акхарава. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Вов кадя ажутярэлас, со Павло дэла лэсти ловэ, колэсти бут молоря припхэнэлас тэ анэн лэс и дэлас дума лэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Прожыля дуй бэрш, по Фэликсоско тхан тэрдиля Порцыё Фэсто. Ай о Фэликсо камля тэ терэл мишто иудеёнди и ашадя лэ Павлос андо баруно. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Фэсто сас андэ кадай пхув трин деса, ай тунчи отлагля андай Кесария андо Иерусалимо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Котэ барэ рашая тай майанглунэ андай иудеёря подинэ лэсти ужылимос по Павло. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Онэ фартэ умангэнас лэ Фэстос, кай вов терэл лэнди мишто тай тэ пэрэандярэл лэ Павлос андо Иерусалимо. Ай ежэнэ камэнас тэ нахукэн пэ лэс пав дром и тэ умарэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Фэсто пхэндя: — О Павло бэшэл запхандадо андэ Кесария. Мэ кадя ж сыго авава котэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Мэк тумарэ майбарэ пхурэдэра жан манца и сикавэн, андэр со вов ужыло, сар вов тердя варисо вырито. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Фэсто сас лэнца пашай охто чи дэш деса, тунчи рисайля андэ Кесария. Пэ авэр дес бэшля по сындомарёско тхан тай припхэндя тэ анэн лэ Павлос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Ай кала лэ Павлос андэ, иудеёря, савэ авиле андав Иерусалимо, линэ тэ ужылисарэн лэс андэ бут найлашэ рындоря, нэ лэндэ на выжыля варисо тэ допхэнэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Павло ашыля тэ допхэнэл пэско чячимос и пхэндя: — Мэ на тердэм бэзэх ни англав иудеёско Законо, ни англав храмо, ни англав императоро. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Фэсто камля тэ терэл мишто лэ иудеёнди, колэсти пушля лэ Павлос: — Ту камэс тэ жас андо Иерусалимо, кай мэ котэ тут тэ сындосарав? ");
INSERT INTO rmyvlakh_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Павло пхэндя: — Мэ тэрдював англав сындо императороско, и лэсти трэбуй ман тэ сындосарэл. Мэ на тердэм иудеёнди нисави бида, сар ту и ежэно мишто жанэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Сар терав найчячимос и ман трэбуй тэ умарэн, мэ гытосардо тэ мэрав. Нэ сар иудеёря ужылисарэн ман йивья, тунчи никасти нащи тэ выдэн ман лэнди. Мэк ман сындосарэл императоро! ");
INSERT INTO rmyvlakh_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Тунчи Фэсто пэрэдя дума пэстирэ подпхэнирэмаренца и пхэндя: — Сар ту мангэс лэ императороско сындо, тунчи кав императоро и авэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Кала прожыле коискачи деса, кав Фэсто андэ Кесария авиле тхагар Агрипа и Берника, кай тэ дикхэнпэ лэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Онэ сас котэ бут деса, и Фэсто роспхэндя лэ тхагарасти палав рындо лэ Павлоско: — Катэ исин мануш, савэс Фэликсо ашадя андо баруно. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Кала мэ сымас андо Иерусалимо, иудеёндирэ барэ рашая и пхурэдэра ужылисарэнас лэс тай мангэнас тэ прижанэл лэс ужылэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ай мэ пхэндэм лэнди, со римлянонэндэ на прилито тэ выдэн лэ манушэс, жыкала вов на дикхэлапэ лэ ужылимаренца и на пхэнэла лав пала пэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Онэ авиле манца кардэ, и пэ авэр дес мэ бэшлем по сындомарёско тхан и припхэндэм, кай тэ анэн калэс манушэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Лэстирэ ужылисаримаря тэрдиле англав лэстэ, нэ на сикадэ нисо, со мэ бинавас бы выритонэ рындоса. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Када сас спорно дума палав лэнго патявимос и палав саво-то Исусо, Саво муля, нэ Павло састэс пхэнэлас, со Вов жундо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Мэ на жанавас, сар тэ розлав кадва рындо, и пушлем лэстар, чи камэл вов тэ жал андо Иерусалимо и котэ тэ авэла сындосардо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Нэ Павло мангля, кай лэско рындо тэ роздикхэл майбаро, колэстар мэ припхэндэм тэ ритярэн лэс запхандадэса, жыкала мэ бишалава лэс кав майбаро императоро. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Агрипа пхэндя лэ Фэстости: — Мэ кадя ж камав тэ поашунав калэс манушэс. — Тэся ашунэса лэс, — пхэндя Фэсто. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Пэ авэр дес о Агрипа тай Берника барэ пхутимаса зажыле андо баро зало. Лэнца авиле пхурэдэра мия халавдэн и жанглэ форостирэ мануша. Фэсто припхэндя тэ заандярдэн лэ Павлос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Тунчи Фэсто пхэндя: — Тхагар Агрипа и всаворэ, ко исин пэ кадва тхан! Тумэ икхатар дикхэн англай пэстэ манушэс, пэ саво бут иудеёря жалисавэнас манди, сар андо Иерусалимо кадя ж и катэ. Онэ цыписавэн, со лэсти нащи тэ жувэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Сар мэ аракхлем, вов нисо на тердя, пала со лэс трэбуй тэ умарэл. Нэ сар вов мангля, кай лэс тэ сындосарэл майбаро императоро, мэ камав тэ бишалав лэс андо Римо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Нэ манди нинай, со тэ пистросарав пала лэстэ раести, и колэсти мэ выандярдэм лэс тумэндэ тай майанглал, тутэ, тхагар Агрипа, кай ту лэс тэ допушэс. Тунчи мэ авава тэ жанав, со манди тэ пистросарав. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Мэ гындосарав, со када нагодярванэс, кай варико тэ бишалэл барунарес и тэ на сикавэл, андэр со лэс ужылисарэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Тунчи Агрипа пхэндя Павлости: — Тути домукэлпэ тэ пхэнэс лав пала пэстэ. Павло вазгля пэско васт тай ля тэ дэл дума: ");
INSERT INTO rmyvlakh_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","— Тхагар Агрипа! Мэ бахтало тэ допхэнав адес тути пэско чячимос англай всаворэ иудеёря, савэ ужылисарэн ман. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Ту фартэ мишто жанэс пала вся, со прилито машкар иудеёря и пала со онэ ханпэ. Колэсти мангав тут, терпиримаса выашун ман. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Всаворэ иудеёря жанэн, сар мэ тэрнимастар жувавас машкар мэрно народо андо Иерусалимо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Онэ дэлмут жанэн ман, и сар закамэна, допхэнэна, со мэ сымас фарисеё и жувавас пав майсасто сытяримос андэ амаро патявимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ай адес мэ тэрдював англав сындо пала пэстири надия пэ лав, саво дя о Дэл амарэнди дадэнди. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Дэшудуй родоря амарэ народостирэ дес и рят всавораса зораса терэн бути важо Дэл тай ажутярэн, кала терэлапэ кадва лав. Пала надия пэ када, тхагар, ман ужылисарэн иудеёря. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Тумэ бинэн, со пхарэс тэ патян андо кода, со о Дэл жундярэл мулэн? ");
INSERT INTO rmyvlakh_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","И мэ кадя ж гындосаравас, со манди трэбуй тэ тирав вся, со андэ мэрно зор, пэ холи алавэсти Исусостирэс андав Назарето. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Када мэ и теравас андо Иерусалимо. Мэ прилем зор лэ барэ рашаендар и пхандававас андо баруно бутэн свэнтонэ манушэн, ай кала лэн сындосарэнас по миримос, мэ отдавас пала када пэско гласо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Мэ бут молоря маравас лэн андэ всаворэ синагоги, кай онэ тэ отпхэндён пэстирэ патявимастар. Мэ сымас кацаво холяко пэр лэндэ, со гонисаравас лэн андэ авэр фороря. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Екхвар мэ ладавас андо Дамаско припхэнимаса и зораса лэ барэ рашаендар. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Пав дром кордэ, тхагар, мэ удикхлем удуд болыбнастар, саво свэнтояспэ майфартэ, сар о кхам. Мэ и ко жалас манца ашылепэ андрал калэс удудэстар. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Амэ всаворэ пэле пэ пхув, ай мэ ашундэм гласо, саво дэлас дума манца пай евреёнэндири шыб: «Савло! Савло! Сости ту гонисарэс Ман? Пхарэс тути тэ жас пэр Мандэ». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Тунчи мэ пушлем: «Ко Ту, Рай?» «Мэ Исусо, Савэс ту гонисарэс, — пхэндя Рай. — ");
INSERT INTO rmyvlakh_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Вщи и тэрдюв. Мэ авилем, кай тэ тирав тут Мэрнэ бутярнэса, кай ту тэ роспхэнэс пала кода, со дикхлян, со Мэ тути сикавава. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Мэ фэрисарава тут тирэ народостар и найиудеёндар, савэндэ Мэ тут бишалав. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Кай ту отпхэрнадян лэнди якха и обрисардян лэ калимастар кав удуд, тай рисардян лэн андав Сатанаско васт кав Дэл, соб лэндирэ бэзэха тэ авэн эртисардэ и онэ тэ авэн машкар кола, кас Мэ свэнтосардэм патявимаса андэр Мандэ». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Тхагар Агрипа, манди нащи сас тэ на кандав болыбнаско дикхимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Майанглал мэ ашылем тэ роспхэнав колэнди, ко сас андо Дамаско, тунчи колэнди, ко жувэнас андо Иерусалимо и андэ Иудея. Ай тунчи ашылем тэ пхэнав найиудеёнди, кай онэ тэ каисавэн аглав Дэл тай тэ сикавэн рындонэнца, со онэ чячимаса каисайле. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Пала када иудеёря схутилдэ ман андо храмо и камле тэ умарэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Нэ о Дэл жыкай адесутно дес поможысарэл манди, и акэ мэ тэрдював катэ и допхэнав цэкнэнди тай барэнди. Мэ пхэнав качи кода, со пхэнэнас пророкоря и Моисеё. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Мэ пхэнав, со лэ Христости трэбуй сас тэ пэрэандярэл грыжа, англунэсти тэ жундёл андай мулэ тай тэ роспхэнэл амарэ народости, тай найиудеёнди пала удуд». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Кала вов кадя дэлас дума, Фэсто цыписайля. — Ту на андэ пэстири годи, Павло! Баро ервалимос заандярдя тут годятар! ");
INSERT INTO rmyvlakh_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Павло пхэндя: — Пативало Фэсто, мэ на диляйлем, ай кода, со мэ пхэнав исин чячимос и годявимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Тхагар, англав саво мэ отпхэрнадо дав дума, када вся жанэл. Мэ патяв, со вся када, на сас гаравдо лэстар, кадя сар сас тердо на андо гаравдо тхан. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Тхагар Агрипа, ту патяс пророконди? Мэ жанав, со патяс! ");
INSERT INTO rmyvlakh_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","— Ту кадя сыго камэс тэ терэс ман христианиноса? — пхэндя Агрипа лэ Павлости. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Павло пхэндя: — Скачи када вряма тэ на авэл, сыго ай лунго, мэ мангав Дэвлэс, кай качи най екх ту, нэ и всаворэ, ко ашунэл ман адес, тэ ашэн, сар мэ, качи билэпунзэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Тунчи тхагар вщиля, и лэса вщиле баро рай, Берника и всаворэ, ко сас лэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Онэ выжыле тай пхэнэнас екх екхэсти: — Кадва мануш на тердя нисо, кай лэс тэ умарэн чи тэ запхандавэн андэ лэпунзэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","— Мэ отмуклем бы лэс, нэ вов мангля сындо кав императоро, — пхэндя Агрипа Фэстости. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Кала сас прилито, со амэ плывисараса андэ Италия, тунчи лэ Павлос и аврэн коисавэн барунарэн, пэрэдинэ шэлэнгэсти, савэс акхарэнас Юлиё, андав майбарэско императороско полко. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Амэ бэшле по кораблё андав порто Адрамитино, савэсти трэбуй сас тэ плывисарэл андэ порторя Цыкня Азиятирэ, тай плывисардэ андо дром. Амэнца сас македонянино Аристархо андай Фесалоника. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Пэ авэр дес амэ плывисардэ кав Сидоно. О Юлиё мишто обжаласпэ лэ Павлоса и отмукля лэс, кай вов тэ жал и тэ дикхэлпэ пэстирэ амалэнца, кай онэ тэ поможысарэн лэсти. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Балвал пхурдэлас пэр амэндэ и амэ упалэ плывисардэ андо море и прожыле о Кипро пай бибалвалятири риг. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Амэ плывисарасас пай море пашай бэрэгоря Киликияко тай Памфилияко и авиле андо Ликияко форо Мира. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Котэ шэлэнго аракхля кораблё андай Александрия, саво плывисарэлас андэ Италия, и тховдя амэн пэр лэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Коискачи деса амэ поцыра плывисарасас англэ. Сас фартэ пхарэс, нэ амэ екхпатив авиле андо Книдо. Ай сар балвал на дэлас амэнди тэ жас англэ, амэ обжыле мысо Салмона и плывисардэ пав Крито бибалвалятиря ригатар. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Амэ барэ пхаримаса плывисарас пашав бэрэго и авиле по тхан, саво акхарэлпэ Лашэ Бухторя, найдур лэ форостар Ласея. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Амэ хасардэ бут вряма, кай тэ плывисарас майдур сас хасаримаса важ жувимос, колэсти со прожыля постоско дес. Тунчи Павло пхэндя лэнди: ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","— Мэ дикхав, со дром авэла пхаро и выжала, со амэ хасараса, на качи грузо и кораблё, нэ и амаро жувимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Нэ о шэлэнго на кангля лэ Павлос, ай кангля, со пхэндэ лэсти капитано и кораблёско хулай. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Кадья бухта на поджалас, кай котэ тэ пэрэвинтярэн, и майбут мануша камле тэ плывисарэ майдур, кай сар-то тэ доплывисарэн кай Финиксо и котэ тэ пэрэвинтярэн. О Финиксо, када бухта по Крито, сави отпхэрнади пэ юго-западо тай северо-западо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Пхурдя локхи южно балвал, лэнди сикадиля, со прилинэ кода, со трэбуй. Тунчи морякоря подлинэ о якорё и плывисардэ пашав Критоско бэрэго. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Нэ сыго пай островостири ригатар нахукля фартэ бари северо-восточно балвал, сави акхарэлпэ Эвракилоно. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Балвал подхутилдя о кораблё. Амэндэ на выжалас тэ жас англав балвал. Амэ здинэпэ и балвал андярдя амэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Амэ подплывисардэ кав цэкноро острово Кавда, саво сас пэ бибалвалятири риг. Котэ амэ барэ пхаримаса фэрисардэ о чёвно, ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","кала вазгле лэс по кораблё. Тунчи матросоря процырдэ дуря талав кораблё и обпхангле лэс. Онэ даранас, со кораблё бэшэла по тишай андо Сирто, колэсти онэ обмукле парусо и балвал андярдя амэн майдур. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Бари балвал кадя фартэ шолас о кораблё, со пэ авэр дес амэ ашыле тэ вышас грузо андав кораблё. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Ай по трито дес амэ пэстирэ вастэнца вышутэ андо море кораблёско хулаимос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Бут деса на душолас ни о кхам, ни чиргая, ай бари балвал пхурдэлас инке майфартэ. Амэ хасардэ всавори надия пэ фэрисаримос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Мануша бут вряма нисо на ханас. Тунчи Павло вщиля машкар лэндэ и пхэндя: — Муршалэ! Тумэнди трэбуй сас тэ кандэн ман и тэ на плывисарэн лэ Критостар, тунчи тумэндэ на авэлас грыжа и нисо б на хасавэлас. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Нэ икхатар мангав: ваздэнпэ духоса, нико тумэндар на хасавэла, качи розмардёлапэ о кораблё. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Кола рятяса мандэ авиля ангело Дэвлэстар, Савэско мэ исин и Савэсти тэлював. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Вов пхэндя манди: «Павло, на дара. Тути трэбуй авэла тэ тэрдёс англав императоро, тай о Дэл, пай Пэско мищимос, дя тути всаворэн, ко плывисарэл туса». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Муршалэ! Ваздэнпэ духоса! Мэ патяв Дэвлэсти и жанав, со вся авэла кадя, сар Вов манди пхэндя. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","О кораблё авэла вышуто пэ варисаво острово. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Пэ дэшуштартири рят, кала амэн инке андярэлас пав Адриатическо море, андэ епашрят матросоря поле, со подладэн кай пхув. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Онэ ужангле, пробиндэ скачи сас кав дно и ужангле, со сас варикай трянда шов метроря, ай кала прожыля найбут вряма онэ упалэ побиндэ и аракхле, со кав дно сас бишта эхта метроря. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Матросоря даранас, кай тэ на арэсэл амэн андэ бара, и змукле пав палатуно тхан по кораблё штар якоря и мангэнас, кай майсыго тэ авэл дес. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Онэ камле тэ нашэн пав кораблё тай линэ тэ змэкэн чёвно по паи, притерэнаспэ, со камэн тэ змукэн пав кораблёско нак якорё. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Нэ о Павло пхэндя пхурэдэрэсти шэлэн халавдэн и халавдэнди: — Сар кала мануша на ашэнапэ по кораблё, тунчи тумэ на фэрисавэнапэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Тунчи халавдэ пэрэшындэ дуря, савэ ритярэнас чёвно, и вов пэля андо море. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Ай англав дэнзор Павло мангля манушэн, кай онэ тэ хан. — Акэ адес дэшуштар дес тумэ ажутярэн дараса и нисо инке на хале, — пхэндя вов. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","— Ай колэсти мэ тумэн мангав тэ хан, и када поможысарэла тумэнди тэ фэрисавэн. Ни кастэ тумэндар на пэрэла бал пав шэро. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Кала вов када пхэндя, ля о марно, англай всаворэндэ наисардя пала лэстэ лэ Дэвлэс, пхагля лэс и ля тэ хал. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Манушэн када подритярдя, и онэ всаворэ линэ тэ хан. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Всаворэн манушэн, савэ сас по кораблё, сас дуйшэл эхтадэшушов. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Кала и мануша чялиле, онэ линэ тэ вышон андав кораблё андэ море о див, кай вов тэ авэл майлокхо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Дэнзор онэ на ужангле пхув, сави сикадиляпэ, нэ удикхле бухта и тишаеско бэрэго, каринг онэ камэнас тэ доплывисарэн пэ кораблё. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Тунчи матросоря обшындэ дуря лэ якоренца и ашадэ лэн андэ море, онэ роспхангле рулё, подлинэ цэкно парусо и линэ тэ плывисарэн кав бэрэго. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Нэ кораблё нахукля по тишай тай ашыля. Кораблёско нак попэля андо тишай и ашыля, сар ганавдо, ай волноря розмарэнас палатуно тхан по кораблё. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Тунчи и халавдэ камле тэ умарэн всаворэн барунарэн, кай лэндар нико тэ на уплывисарэл и тэ на нашэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Нэ шэлэнго камля тэ фэрисарэл лэ Павлос и на домэкля лэн. Вов припхэндя колэнди, ко жанэнас тэ плывисарэн, тэ хукэн андо паи майанглал и тэ плывисарэн кав бэрэго. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Ай всаворэнди аврэнди манушэнди трэбуй сас тэ фэрисарэнпэ пэ кашта и пэ вся, со ашыляпэ лэ кораблёстар. Кадя онэ всаворэ мишто доплывисардэ кав бэрэго. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Кала амэ фэрисардэпэ, тунчи ужангле, со кодва острово акхарэлпэ Мальта. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Мануша, савэ жувэнас котэ, фартэ мишто прилинэ амэн. Онэ роспхабардэ яг, акхардэ амэн пэстэ, колэсти со сас шудро и жалас брышынд. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Кала Павло стидя обэрэмко кашта тай ашыля тэ шол андэ яг, лэсти по васт хутилдя дандэнца сап, саво фэрисарэласпэ лэ ягатар и выгульдя андай кашта. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Ай кала мануша, савэ жувэнас котэ, удикхле, со кай васт лэ Павлоско припхангляпэ сап, онэ линэ тэ пхэнэн екх екхэсти: — Душол кадва мануш варикас умардя: вов фэрисардяпэ андав море, нэ Чячимос на ашавэл лэс жундэса. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Нэ Павло сшутя сапэс пав васт андэ яг, и сап на тердя лэсти нисави бида. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Мануша ажутярэнас, со вов шувлёла, пэрэла и мэрэла. Онэ бут вряма ажутярэнас, нэ кала дикхле, со лэса нисо на терэлпэ, линэ тэ гындон пай авэр, со вов варисаво дэл. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Найдур сас пхувья, савэ сас лэ пхурэдэрэстирэ пав острово, савэс акхарэнас Публиё. Вов лошаса приля амэн пэстэ, и амэ трин дес самас лэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Кав Публиё сас насвало дад. Вов пашлёлас пэ пато, сас фартэ пхабардо и лэстэ сас дизентирия. Павло зажыля лэстэ, мангляпэ Дэвлэс, тховдя пэр лэстэ васта и састярдя лэс. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Тунчи всаворэ насвалэ пав острово линэ тэ авэн лэстэ и тэ састярэнпэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Онэ баря пативаса обжылепэ амэнца, ай кала амэнди трэбуй сас тэ плывисарас, онэ динэ амэнди вся, со амэнди трэбуй сас андо дром. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Тунчи кала прожыля трин шон, амэ выжыле андо море по кораблё андай Александрия, саво винтярэлас по острово. Кадва кораблё проакхардо Дуй Пхрала. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Амэ авилям андэ Сиракуза и сас котэ трин дес. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Котар амэ плывисардэ андо море и авиле андэ форо Ригиё. Пэ авэр дес пхурдэлас балвал пав юго, ай пэ дуйто дес амэ авиле андэ Путеолоря. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Котэ амэ аракхле пхралэн, онэ мангле амэн тэ авас лэнца эхта деса. Тай акэ амэ авилям андо Римо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Пхрала андо Римо ашундэ пала кода, со амэ авиле, и выжыле, кай тэ дикхэнпэ амэнца пэ Апиёско форо, и андо форо Трин Гостиницоря. Кала Павло удикхля лэн, вов наисардя лэ Дэвлэс тай вазгляпэ духоса. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Амэ авиле андо Римо, лэ Павлости динэ тэ жувэл ежэнэсти, нэ паша лэстэ жувэлас халавдо, саво дикхэлас пала лэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Кала прожыле трин деса, Павло акхардя майанглунэн андай иудеёря. Кала онэ стидэпэ, вов пхэндя лэнди: — Пхралалэ! Ман схутилдэ андо Иерусалимо и отдинэ лэ римлянонэнди, нэ мэ на тердэм нисо вырито англав амаро народо и отпхэндювавас колэстар, со прилито амарэ дадэнца. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Римляноря розлинэ мэрно рындо и камле ман тэ отмукэн, колэсти со пала мандэ нинай нисаво ужылимос, пала саво ман трэбуй тэ умарэн. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Нэ сар иудеёря на камэнас тэ прилэн када, манди трэбуй сас тэ мангав сындо кав императоро, и тердэм мэ када най кай тэ ужылисарав пэско народо. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Колэсти мэ акхардэм тумэн адес, соб тэ дикхавпэ и тэ подав дума тумэнца. Колэсти со кала лэпунзэ пэ мандэ палай надия лэ Израилёстири. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Кола, савэ ашунэнас лэ Павлос, пхэндэ: — Амэнди нико на пистросардя андай Иудея пала тутэ нисавэ лила, и нико андай пхрала на пхэндя пала тутэ нисо вэрыто. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Нэ амэ камас тутар тэ ашунас, сар ту ежэно гындос, амэ жанас качи кода, со мануша пай всаворэ тхана вырито пхэнэн пала кадва сытяримос. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Онэ допхэндэпэ лэ Павлоса, и андо екх вытидо дес бут мануша авиле андо чер, кай вов жувэлас. Павло пав дэнзор жыкай рят пхэнэлас лэнди пала Дэвлэстиро Тхагаримос и допхэнэлас лэнди палав Исусо лавэнца андав Законо Моисеёско и пророкоря. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Коисавэ патяйле лэстирэ лавэнди, ай коисавэ на патяйле. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Онэ линэ тэ ханпэ машкар пэстэ, и сар онэ ашыле тэ ужан, Павло пхэндя кацавэ лава: — Свэнто Духо чячимос пхэндя тумарэ дадэнди черэз пророко Исая: ");
INSERT INTO rmyvlakh_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","«Жа кав кадва народо и пхэн: \"Тумэ авэна тэ ашунэн, нэ на полэна, авэна тэ дикхэн, нэ на удикхэна. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Води калэ народоско ашыля, сар бар, онэ пхарэс ашунэн канэнца и якха пэстирэ затердэ, соб тэ на дикхэн якхэнца, соб тэ на ашунэн канэнца и тэ на полэн водеса кай тэ обрисавэн, соб Мэ тэ састярав лэн\"». ");
INSERT INTO rmyvlakh_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","29","Акэ жанэнтэ, со фэрисаримос Дэвлэстиро бишалдо найиудеёнди: онэ и ашунэна кадва лав! ");
INSERT INTO rmyvlakh_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Павло жувэлас андо Римо инке дуй бэрш андо чер, саво вов намисардя, и прилэлас всаворэн, ко авэлас лэстэ. ");
INSERT INTO rmyvlakh_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Вов бидарако роспхэнэлас палав Тхагаримос Дэвлэско, сытярэлас палав Рай Исусо Христосо, и лэс нико на тэрдярэлас.");
ALTER TABLE rmyvlakh_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
