﻿USE sofia;
DROP TABLE IF EXISTS sofia.rmyservi_vpl;
CREATE TABLE rmyservi_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES rmyservi_vpl WRITE;
INSERT INTO rmyservi_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Май англэ Дэвэл стерда болыбэн тай пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Пхув сля бинисохкири тай шущи, калимо сля упрэ барэн панен, тай Фано Дэвлэхкиро урялас упрал панэстар. ");
INSERT INTO rmyservi_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Дэвэл пхэнда: — Мэк авэла душлимо. Тай стердапэ душлимо. ");
INSERT INTO rmyservi_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Дэвэл удыкхля, со душлимо сля мишто, тай вылиля лэ калиматар. ");
INSERT INTO rmyservi_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Дэвэл акхарда душлимо «диво», а калимо — «рат». Сля бельвель, тай сля дэнзор — пэрво диво. ");
INSERT INTO rmyservi_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Тай пхэнда Дэвэл: — Мэк авэла сводо помашкар панэстэ, соб тэ отлэ пани панестар. ");
INSERT INTO rmyservi_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Дэвэл стерда сводо тай отлиля пани тала сводо панестар, саво сля понад лэ. Тай ачиля кади. ");
INSERT INTO rmyservi_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Дэвэл акхарда сводо «болыбэн». Сля бельвель, тай сля дэнзор — дуйто диво. ");
INSERT INTO rmyservi_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Дэвэл пхэнда: — Пани тала болыбэн мэк стидэлпэ екхтханэ, тай мэк стерэлапэ суша. Тай ачиля кади. ");
INSERT INTO rmyservi_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Дэвэл акхарда суша «пхув», а пани, саво стидыняпэ екхтханэ, — «море». Тай удыкхля Дэвэл, со када мишто. ");
INSERT INTO rmyservi_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","— Мэк барярэл пхув всаворэ чяря: чяря, савэ анэн самбуря, тай бут породы ранден пэ пхув, савэ анэн плодуря кокаленца, — пхэнда Дэвэл. Тай ачиля кади. ");
INSERT INTO rmyservi_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Пхув барярда бут породы чярен: чяря, дэ савэн исин самбуря, тай бут породы ранден, савэ анэн плодуря кокалицэнца.Тай удыкхля Дэвэл, со када мишто. ");
INSERT INTO rmyservi_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Сля бельвель, тай сля дэнзор — трито диво. ");
INSERT INTO rmyservi_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Тай пхэнда Дэвэл: — Мэк авэна яга пэ болыбнахкиро сводо, соб отлэ диво ратятар. Мэк вонэ авэна знаконэнца, соб тэ сикавэн вряма, дивэ тай бэрша. ");
INSERT INTO rmyservi_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Тай мэк вонэ тэ дэн яг пэ болыбнахкиро сводо, соб тэ душол пхув. Тай ачиля кади. ");
INSERT INTO rmyservi_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Дэвэл стерда дуй барэ яга: бари яг, соб тэ авэл хулаеґа дивэсэґа, тай цыкныдэр яг, соб тэ авэл хулаеґа ратяґа, а кади ж Вов стерда черґэня. ");
INSERT INTO rmyservi_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Дэвэл тховда лэн пэ болыбнахкиро сводо, соб вонэ тэ дэн душлимо пэ пхув, ");
INSERT INTO rmyservi_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","тэ авэн хулаенца дивэсэґа тай ратяґа и тэ отлэн душлимо калиматар. Тай удыкхля Дэвэл, со када мишто. ");
INSERT INTO rmyservi_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Сля бельвель, тай сля дэнзор — штарто диво. ");
INSERT INTO rmyservi_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Дэвэл пхэнда: — Мэк пхэрдёла пани джювимаґа, тай мэк урян понад пхув дэ сводо болыбэн чирикля. ");
INSERT INTO rmyservi_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Дэвэл стерда барэн морендирэн жывотнонэн и бут породы джювима, савэ тирёнас дэ пани, тай бут породы чириклен пхакэнца. Тай удыкхля Дэвэл, со када мишто. ");
INSERT INTO rmyservi_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Дэвэл бахталисарда лэн тай пхэнда: — Мэк тумэндэ авэна чяворэ тай мэк лэн авэла бут, пхэрдён пани дэ море. Тай мэк чириклен авэла будэр пэ пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Сля бельвель, тай сля дэнзор — панчто диво. ");
INSERT INTO rmyservi_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","И пхэнда Дэвэл: — Мэк барярэл пхув бут породы джювима: бут породы барэн тай цыкнэн жывотнонэн. Тай ачиля кади. ");
INSERT INTO rmyservi_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Дэвэл стерда бут породы жывотнонэн, барэн тай цыкнэн зверен пэ пхув. Тай удыкхля Дэвэл, со када мишто. ");
INSERT INTO rmyservi_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Тунчи Дэвэл пхэнда: — Стераґа манушэ, Амаро образо, и тэ авэл вов поджило пэ Амэн. Мэк вов тэ авэл хулай понад морендирэн мачен, и чириклен, савэ дэ болыбэн, понад хулаимо, понад всавори пхув тай понад всаворэн жывотнонэн, савэ пхирэн пав пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Кади Дэвэл стерда манушэ пав образо Пэхкиро, пав образо Дэвлэхкоро Вов стерда лэ, муршэґа тай джювляґа Вов стерда лэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Дэвэл бахталисарда лэн и пхэнда: — Мэк тумэндэ авэна чяворэ тай мэк лэн авэла бут. Пхэрдён пхув и заачявэн ла тэ тирэ бути важ тумэн. Авэн хулаенца понад мачен, савэ дэ морё, и чириклен, савэ дэ болыбэн, тай понад всаворя джювима, сави пхирэл пав пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Тунчи Дэвэл пхэнда: — Мэ дав тумэнди всаворэ чяря самбуренца пав всавори пхув тай всаворэ рандя, савэ дэн плодуря кокалицэнца. Вонэ авэна тумэнди хамаґа . ");
INSERT INTO rmyservi_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Тай всаворэнди джювима пав пхув, и всаворэнди чирикленди дэ болыбэн, тай всаворэнди жывотнонэн, савэ пхирэн пав пхув, — всаворэнди, дэ кастэ пхурдэл джювимо, Мэ дав дэ хама всавори зэлэнь. Тай ачиля кади. ");
INSERT INTO rmyservi_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Дэвэл подыкхля пэ вса, со Вов стерда, тай вса сля фартэ мишто. Сля бельвель, тай сля дэнзор — шовто диво. ");
INSERT INTO rmyservi_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Кади сля стердо болыбэн тай пхув тай вса, со джювэл котэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Дэ ефтатиро диво Дэвэл стерда всавори бути, сави Вов терэлас, тай дэ ефтатиро диво Вов пэрэачиля тэ терэ рындуря, саво Вов терэлас дыколэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Дэвэл бахталисарда ефтатиро диво и терда лэ свэнто, пала када со дэ кадыва диво Вов пэрэачиля тэ тирэ Пэхкирэ рындуря. ");
INSERT INTO rmyservi_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Акэ роспхэнэлпэ пала болыбэн тай пхув, кала вонэ сле стердэ. Кала РАЙ Дэвэл терэлас пхув тай болыбэн, ");
INSERT INTO rmyservi_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","пэ пхув инте нисо на сля: ни малятиро кустарнико, ни чяр малятири, пала када со РАЙ Дэвэл на бичялэлас пэ пхув брышынд и на сля манушэ, соб тэ терэ бути пэ пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Кацик лэнь ваздэласпэ пхуятар и тиндярэлас всавори пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Тунчи РАЙ Дэвэл стерда манушэ прахостар пхуятирэстар тай пхурдыня лэсти дэ ратуя джювимо, и мануш ачиля джювдо. ");
INSERT INTO rmyservi_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","РАЙ Дэвэл выбарярда садо пэ востоко, дэ Эдэмо, тай тховда котэ манушэ, савэ Вов стерда. ");
INSERT INTO rmyservi_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","РАЙ Дэвэл выбарярда пхуятар всаворэ рандя, пэ савэн сля мишто тэ дыкхэ и савэ сле лаче дэ хама. Помашкар дэ садо барёнас рандь, сави дэл джювимо, тай рандь, сави дэл тэ уджянэ лачимо тай врытимо. ");
INSERT INTO rmyservi_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Эдэмостар чюлёлас лэнь, сави тиндярэлас садо, а дурыдэр вой розджяласпэ пэ штар лэня. ");
INSERT INTO rmyservi_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Перво акхарэлпэ Пишоно: вов обчюлёл всавори пхув Хавила, тев исин сувнак. ");
INSERT INTO rmyservi_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Сувнак дэ кодыя пхув лачё. Тай инте котэ исин смола, савятэ лачё фано, и кучютно бар шохамо. ");
INSERT INTO rmyservi_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Дуйто лэнь акхарэлпэ Гихоно, вой обчюлёл всавори пхув Кушо. ");
INSERT INTO rmyservi_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Трито лэнь акхарэлпэ Тигро, вой чюлёл дэ востоко Ашшуростар. А штарто лэнь — када Евфрато. ");
INSERT INTO rmyservi_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","РАЙ Дэвэл тховда манушэ дэ Эдэмско садо, соб вов тэ терэл бути дэ садо тай тэ дыкхэл пала лэстэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","РАЙ Дэвэл прыпхэнда манушэсти: — Ту ґалювэх тэ ха плодуря всаворэндар рандятар дэ садо. ");
INSERT INTO rmyservi_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Кацик на ха рандятар, сави дэл тэ уджянэ лачимо тай врытимо, пала када со дэ дивэ, кала ту схаґа плодо латар, ту мэрэґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","РАЙ Дэвэл пхэнда: — Намишто манушэсти тэ авэ екджинэсти. Мэ терава лэсти амалэ, сар вов, саво дэла лэсти зор. ");
INSERT INTO rmyservi_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","РАЙ Дэвэл стерда пхуятар всаворэн малятирэн зверёнэн тай всаворэн чириклен болыбнэндирэн. Тунчи Вов анда лэн манушэстэ, соб тэ удыкхэ, сар кодэва лэн акхарэла. И сар акхарда мануш кожнонэ жывотнонэ, кади и ачиля лэсти лав. ");
INSERT INTO rmyservi_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Кади мануш дэня лава всаворэсти цэрутности скотости, всаворэнди чирикленди, савэ дэ болыбэн, тай всаворэнди зверёнэнди. Но Адамости на аракхяпэ амалэ, сар вов, саво дэла лэсти зор. ");
INSERT INTO rmyservi_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Тунчи РАЙ Дэвэл засовлярда манушэ, и покы вов сута, лиля екх лэхкиро рёбро тай затерда кодэва тхан масэґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ребростар, саво Вов вылиля манушэстар, РАЙ Дэвэл стерда джювля и анда ла лэстэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Мануш пхэнда: — Када кокали мурэндар кокалендар тай мас мурэстар масэстар. Вой авэла тэ акхарэпэ «ромни», пала када со сля лити ромэстар. ");
INSERT INTO rmyservi_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Пала када ачявэла мануш дадэ и да тай авэна екхтханэ пэхкиряґа ромняґа, тай дуй ачена екх трупо. ");
INSERT INTO rmyservi_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Адамо и лэхкири ромни дуйджинэ сле нангэ, но на ладжянас. ");
INSERT INTO rmyservi_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Всаворэндар дыконэндар зверёнэндар, савэн стерда РАЙ Дэвэл, хрантэдэр всаворэндар сля сап. Вов пхучля джювля: — Чяче ли пхэнда Дэвэл: «На хан всаворэндар рандендар дэ садо\"? ");
INSERT INTO rmyservi_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Джювли пхэнда сапэсти: — Амэ ґалювах тэ ха плодуря рандэндар дэ садо. ");
INSERT INTO rmyservi_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Нэ Дэвэл пхэнда: «На хан плодуря рандятар, саво помашкар дэ садо. Тай на лэнпэ лэндэ, соб тэ на мэрэ тумэнди». ");
INSERT INTO rmyservi_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","— Нат, тумэ на мэрэна, — пхэнда сап джювляти. ");
INSERT INTO rmyservi_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","— Дэвэл джянэл, со кала тумэ схана лэн, тумарэ якха оттерэнапэ тай тумэ ачена, сар дэвла, савэ джянэн лачимо тай врытимо. ");
INSERT INTO rmyservi_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Тунчи джювли удыкхля, со плодо рандятар сля лачё дэ хама тай мишто тэ дыкхэ пэ лэстэ. Джювли кади ж закамля плодо рандятар, пала када со вов дэлас годи. Вой лиля екх плодо тай схаля. Тунчи дэня плодо и ромэсти, саво сля лаґа, и вов халас лэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Лэндэ дуендэ якха оттердэпэ, тай вонэ полиле, со нангэ. Тунчи вонэ ссювдэ листонэндар инжыростар їда тай ушаравдэ пэхкиро нангимо. ");
INSERT INTO rmyservi_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Бельвеляґа, кала ачиля шылалэдэр тай пхурда балвалёры, вонэ ушундэ, сар РАЙ Дэвэл пхирэл пав садо. Адамо и лэхкири ромни гаравдэпэ РАЕСТАР Дэвлэстар машкар ранден дэ садо. ");
INSERT INTO rmyservi_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Нэ РАЙ Дэвэл акхарда Адамо: — Тев ту? ");
INSERT INTO rmyservi_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Адамо пхэнда: — Мэ шундом Тут дэ садо тай пэрэдарынём, пала када со мэ нанго. Акэ мэ и гаравдомпэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","РАЙ Дэвэл пхучля: — Ко пхэнда тути, со ту нанго?Ту халян плодуря рандятар, савэстар Мэ пхэндом тути тэ на ха? ");
INSERT INTO rmyservi_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Адамо пхэнда: — Джювли, савя Ту дэнян манди, соб вой тэ авэл манца, — када вой дэня манди плодо колатар рандятар, тай мэ схалём лэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Тунчи РАЙ Дэвэл пхэнда джювляти: — Со жэ ту стердан? Джювли пхэнда: — Сап хохавда ман, акэ мэ и халём. ");
INSERT INTO rmyservi_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Тунчи РАЙ Дэвэл пхэнда сапэсти: — Пала кода, со ту стердан када, дав мрая тут будэр всаворэстар скотостар тай всаворэн диконэн зверёнэн! Ту авэґа тэ пхирэ пэ води, ту авэґа тэ ха прахо дэ всаворэ дивэса тирэ джювима. ");
INSERT INTO rmyservi_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Мэ тховава холи помашкар тут и джювля и помашкар тирэ чяворэн и латирэн чяворэн: вов авэла тэ марэ тут дэ шэрэ, а ту авэґа тэ дандавэ лэ дэ талпа. ");
INSERT INTO rmyservi_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","А джювляти Вов пхэнда: — Мэ терава, со тути авэла грыжа, кала ту авэґа пхари тай кала авэґа тэ бэянэ чяворэн. Ту закамэґа тэ рицарэ ромэ дэ вастэн, ай вов авэла хулай понад тут. ");
INSERT INTO rmyservi_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Адамости жэ Вов пхэнда: — Кади сар ту шундан джювля тай схалян плодо рандятар, пала савя Мэ прыпхэндом тути: «На ха лэстар», дав мрая пала тут пхув: дэ пхари бути ту авэґа тэ ха латар дэ всаворэ дивэ тирэ джювима. ");
INSERT INTO rmyservi_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Вой выбарярэла тути всаворэ пусанэ чяря, ту авэґа тэ ха малятири чярь. ");
INSERT INTO rmyservi_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Дэ пытия авэла тиро муй, кала ту авэґа тэ затерэ тиро мандро, дыколэ сар на рисявэґа дэ пхув, савятар тут лиле. Ту — прахо, и дэ прахо ту рисявэґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Адамо акхарда пэхкиря ромня Ева, пала када со вой ачиля дэй важ всаворэ, ко джювэлас. ");
INSERT INTO rmyservi_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","РАЙ Дэвэл стерда лэнди їда г равлестар тай урявда дэ лэн Адамо и лэхкиря ромня. ");
INSERT INTO rmyservi_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Тунчи РАЙ Дэвэл пхэнда: — Мануш уджянгля лачимо тай врытимо тай кана ачиля, сар екх Амэндар. Нащи, соб вов процырдыня васт тай тэ чинэл плодо рандятар, сави анэл джювимо, тэ схал лэ тай ачиля тэ джювэ вечно. ");
INSERT INTO rmyservi_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","РАЙ Дэвэл вытрадыня лэ садостар Эдэм, соб вов тэ терэл бути пэ пхув, савятар лэ лиле. ");
INSERT INTO rmyservi_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Вов вытрадыня манушэ тай тховда пэ востоко садостар Эдэм херувимонэн и бари чюри, сави пхаболас и марэлас дэ всаворэ рига, соб тэ фирисарэ дром, саво лиджял рандятэ, сави дэл джювимо. ");
INSERT INTO rmyservi_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Адамо сута Еваґа, пэхкиряґа ромняґа, тай вой ачиля пхари и бэянда Каино. Вой пхэнда: «Мэ стердом манушэ, сар када стерда РАЙ». ");
INSERT INTO rmyservi_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Тунчи вой бэянда лэхкирэ пхралэ Авелё. Авелё чяравэлас бакрэн тай бузнен, а Каино терэлас бути пхуяґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Проджиля вряма, тай Каино анда пхуятирэ плодуря дэ даро РАЕСТИ, ");
INSERT INTO rmyservi_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","а Авелё анда дэ даро само фэдэр пэрвонэндар бакрорэндар. Авелё и лэхкиро даро чялиле РАЕСТИ, ");
INSERT INTO rmyservi_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","нэ Каино тай лэхкиро даро на чялиле Лэсти. Каино фартэ холиля, тай лэхкоро муй покалиля холятар. ");
INSERT INTO rmyservi_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Тунчи РАЙ пхэнда Каиности: — Сости ту холявэх? Сости тиро муй покалиля? ");
INSERT INTO rmyservi_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Сар ту авэґа тэ терэ лаче рындоря, ту на авэґа прылито? Нэ, сар ту терэх налаче рындоря, дэ терэн ударэн гаравдапэ бэзэх: вов камэл тэ лэл зор понад тут, кацик ту ав лэсти хулаеґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Каино пхэнда Авелёсти, пэхкирэ пхралэсти: — Джям дэ маля. Кала вонэ сле дэ маля, Каино чютапэ пэ пэхкирэ пхралэ Авелё тай умарда лэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Тунчи РАЙ пхэнда Каиности: — Тев тиро пхрал Авелё? — На джянав, — пхэнда кодэва. — Мэ со, сторожо мурэсти пхралэсти? ");
INSERT INTO rmyservi_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","РАЙ пхэнда: — Со ж ту тердан? Рат тирэ пхралэхкоро типисявэл Мандэ пхуятар. ");
INSERT INTO rmyservi_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Кана мрая пэ тутэ, вытрадино пхуятар, сави оттерда пэхкоро муй, соб тэ прылэ рат тирэ пхралэ, саво ту прочютан пэхкирэ вастэґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Кала ту авэґа тэ терэ бути пэ пхув, вой на авэла будэр тэ анэ плодуря важ тути. Ту авэґа тэ пхирэ пав пхув пордэ тай павпалэ, сар бицэрэхкоро. ");
INSERT INTO rmyservi_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Каино пхэнда РАЕСТИ: — Ман фартэ пхаро марэх, мэ на вылиджява када. ");
INSERT INTO rmyservi_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Екхатар Ту вытрадэх ман пхуятар, мэ авава тэ гаравэпэ Тирэ муестар: мэ авава тэ пхирэ пордэ тай павпалэ, сар бицэрэхкоро, тай пэрво, ко ман удыкхэла, умарэла ман. ");
INSERT INTO rmyservi_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Нэ РАЙ пхэнда лэсти: — Нат. Ко умарэла Каино, лэсти када рисявэла ефта молуря. И РАЙ стерда Каиности знако, соб нико, ко лэґа удыкхэлапэ, тэ на умарэл лэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Каино уджиля РАЕСТАР тай джюда дэ пхув Нод, дэ востоко Эдэмсконэ садостар. ");
INSERT INTO rmyservi_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Каино сута пэхкиря ромняґа, тай вой ачиля пхари тай бэянда Енохо. ");
INSERT INTO rmyservi_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Енохостэ бэяндапэ Ирадо, Ирадостэ бэяндапэ Мехиаэлё, Мехиаэлёстэ бэяндапэ Метушаэлё, тай Метушаэлёстэ бэяндапэ Ламехо. ");
INSERT INTO rmyservi_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Ламехо лиля пэсти дуен ромнен: екха акхарэнас Ада, авря — Цылла. ");
INSERT INTO rmyservi_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ада бэянда Явало: вов ачиля дадэґа колэн,ко джювэл дэ катунэн и розлиджял ското. ");
INSERT INTO rmyservi_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Лэхкирэ пхралэ акхарэнас Ювало: вов ачиля дадэґа всаворэн, ко цэлэл пэ лира и свирель. ");
INSERT INTO rmyservi_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Цыллатэ сля чяво, Тувал-Каино, саво терэлас промати бронзатар и састрестар. Тувал-Каиностэ сля пхэнь Наама. ");
INSERT INTO rmyservi_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Ламехо пхэнда пэхкирэнди ромненди: Ада и Цылла, шунэн ман, ромня Ламехохкирэ, полэн, со мэ дэдумав. Мэ умардом муршэ пала кода, со вов чинда ман, тэрнэ манушэ пала кода, со вов малавда ман. ");
INSERT INTO rmyservi_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Пала Каино авэна мардэ ефта разуя, пала Ламехо — ефта дэша ефта. ");
INSERT INTO rmyservi_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Адамо инте сута пэхкиря ромняґа, тай вой бэянда чявэ тай акхарда лэ Сифо. Вой пхэнэлас: «Дэвэл дэня манди авэр чяворэ пэ Авелёхкиро тхан, савэ умарда Каино». ");
INSERT INTO rmyservi_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Сифостэ сля чяво, тай вов акхарда лэ Еносо. Дэ кодыя вряма мануша ачиле тэ прыакхарэ лав РАЕХКИРО. ");
INSERT INTO rmyservi_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Акэ роспхэндимо пала Адамо тай пала лэхкирэ чяворэн. Кала Дэвэл стерда манушэ, стерда лэ, соб вов тэ авэл поджило пэ Дэвлэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Вов стерда муршэ тай джювля тай бахталисарда лэн. Кала вонэ сле стердэ, Вов акхарда лэн «мануш». ");
INSERT INTO rmyservi_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Кала Адамо проджюда 130 бэрш, лэстэ бэяндапэ чяво, саво сля поджило пэ лэстэ, лэхкоро образо, тай вов акхарда лэ Сифо. ");
INSERT INTO rmyservi_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Тунчи, сар бэяндапэ Сифо, Адамо джюда 800 бэрш, тай лэстэ сле инте чявэ тай чея. ");
INSERT INTO rmyservi_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Всаворо джювимо Адамохкиро сля 930 бэрш, и вов муля. ");
INSERT INTO rmyservi_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Кала Сифо проджюда 105 бэрш, лэстэ бэяндапэ Еносо. ");
INSERT INTO rmyservi_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Тунчи, сар бэяндапэ Еносо, Сифо джюда 807 бэрш, тай лэстэ сле инте чявэ тай чея. ");
INSERT INTO rmyservi_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Всаворо джювимо Сифохкиро сля 912 бэрш, тай вов муля. ");
INSERT INTO rmyservi_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Кала Еносо проджюда 90 бэрш, лэстэ бэяндапэ Каинано. ");
INSERT INTO rmyservi_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Тунчи, сар бэяндапэ Каинано, Еносо джюда 815 бэрш, тай лэстэ сле инте чявэ тай чея. ");
INSERT INTO rmyservi_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Всаворо джювимо Еносотиро сля 905 бэрш, тай вов муля. ");
INSERT INTO rmyservi_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Кала Каинано проджюда 70 бэрш, лэстэ бэяндапэ Малелеило. ");
INSERT INTO rmyservi_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Тунчи, сар бэяндапэ Малелеило, Каинано джюда 840 бэрш, тай лэстэ сле инте чявэ тай чея. ");
INSERT INTO rmyservi_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Всаворо джювимо Каинанохкиро сля 910 бэрш, тай вов муля. ");
INSERT INTO rmyservi_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Кала Малелеило проджюда 65 бэрш, лэстэ бэяндапэ Яредо. ");
INSERT INTO rmyservi_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Тунчи, сар бэяндапэ Яредо, Малелеило джюда 830 бэрш, тай лэстэ сле инте чявэ тай чея. ");
INSERT INTO rmyservi_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Всаворо джювимо Малелеилохкиро сля 895 бэрш тай муля вов. ");
INSERT INTO rmyservi_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Кала Яредо проджюда 162 бэрш, лэстэ бэяндапэ Енохо. ");
INSERT INTO rmyservi_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Тунчи, сар бэяндапэ Енохо, Яредо джюда 800 бэрш, тай лэстэ сле инте чявэ тай чея. ");
INSERT INTO rmyservi_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Всаворо джювимо Яредохкиро сля 962 бэрш, тай вов муля. ");
INSERT INTO rmyservi_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Кала Енохо проджюда 65 бэрш, лэстэ бэяндапэ Мафусало. ");
INSERT INTO rmyservi_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Тунчи, сар бэяндапэ Мафусало, Енохо пхирэлас Дэвлэґа 300 бэрш, тай лэстэ сле инте чявэ тай чея. ");
INSERT INTO rmyservi_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Енохо доджюда дэ 365 бэрш. ");
INSERT INTO rmyservi_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Енохо пхирэлас Дэвлэґа, тунчи лэ на ачиля, пала када со Дэвэл залиля лэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Кала Мафусало проджюда 187 бэрш, лэстэ бэяндапэ Ламехо. ");
INSERT INTO rmyservi_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Тунчи, сар бэяндапэ Ламехо, Мафусало джюда 782 бэрш, тай лэстэ сле инте чявэ тай чея. ");
INSERT INTO rmyservi_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Всаворо джювимо Мафусалохкиро сля 969 бэрш, тай вов муля. ");
INSERT INTO rmyservi_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Кала Ламехо проджюда 182 бэрш, лэстэ бэяндапэ чяво. ");
INSERT INTO rmyservi_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Вов акхарда лэ Ноё тай пхэнда: «Вов дэла амэнди тэ отцынявэ амарятар пхарятар бутятар пэ пхув, сави прэдэня мрая РАЙ». ");
INSERT INTO rmyservi_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Тунчи, сар бэяндапэ Ноё, Ламехо джюда 595 бэрш, тай лэстэ сле инте чявэ тай чея. ");
INSERT INTO rmyservi_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Всаворо джювимо Ламехохкиро сля 777 бэрш, тай вов муля. ");
INSERT INTO rmyservi_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Кала Ноёсти ачиля 500 бэрш, лэстэ бэяндэпэ Симо, Хамо тай Яфето. ");
INSERT INTO rmyservi_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Манушэн ачиля будэр пэ пхув, тай лэндэ бэяндёнаспэ чея. ");
INSERT INTO rmyservi_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Чявэ Дэвлэхкирэ удыкхле, со манушэндирэ чея фартэ шукарнэ, тай ачиле тэ лэ лэн пэсти дэ ромнен, сави касти чялёла. ");
INSERT INTO rmyservi_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","РАЙ пхэнда: — На авэла Фано Муро вечно дэ манушэ, пала када со мануш бэзэхало. Мэк авэла лэндирэ дивэса шэл биш бэрша. ");
INSERT INTO rmyservi_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Дэ колэ дивэса тай пала лэн, кала чявэ Дэвлэхкирэ лэнас дэ ромнен манушэндирэн чеен, лэндэ бэяндёнаспэ чяворэ, сле пэ пхув нефилимы. Вонэ сле фартэ зоралэ, тай пала лэн шундёласпэ пураня вряматар. ");
INSERT INTO rmyservi_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","РАЙ удыкхля, со мануша пэ пхув фартэ бут терэн бэзэх тай лэндири годи цырдэлпэ тэ тирэ холи. ");
INSERT INTO rmyservi_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","РАЕСТИ ачиля дор, со Вов стерда пэ пхув манушэ. Лэхкоро їло пхэрдиля дукхаґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","И пхэнда РАЙ: — Мэ скхосава пхуятар манушэндиро родо, саво Мэ стердом. Мэ умарава и манушэн, и барэн тай цыкнэн жывотнонэн, и чириклен болыбнэндирэн, пала када со Манди дор, со стердом лэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Нэ Ноё аракхля мила дэ РАЕХКИРЭН якхэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Акэ роспхэндимо пала Ноё тай пала лэхкирэ чяворэн. Машкар манушэн кодыла вряматири кацик Ноё терэлас чячюнэ рындуря тай сля би дошатиро. Вов пхирэлас Дэвлэґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Ноёстэ сле трин чявэ: Симо, Хамо тай Яфето. ");
INSERT INTO rmyservi_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Дэ Дэвлэхкирэн якхэн пхув мусардапэ тай пхэрдиля глабаґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Дэвэл удыкхля, сар пхув мусардапэ пала када, со всаворэ мануша пэ пхув пэрэболдыне пэхкирэ дрома. ");
INSERT INTO rmyservi_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Тунчи Дэвэл пхэнда Ноёсти: — Мэ терава, со всаворэ, ко исин джювдэ, хасявэна, пала лэн пхув пхэрдыня глабаґа. Мэ умарава и лэн, тай всавори пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Стер пэсти ковчеґо рандятар гоферо. Стер дэ лэ цэрора тай макх лэ смолаґа гасатар тай андрал. ");
INSERT INTO rmyservi_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Акэ сар ту лэ стерэґа: ковчеґо 300 куя дэ лунгима, 50 куя дэ буґлима тай 30 куя дэ вучима. ");
INSERT INTO rmyservi_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Стер понад лэ штрэха, соб вой тэ ваздэлпэ англа лэ пэ екх куё. Тхов ригатар удара тай стер тэлуно, машкаруно тай упруно этажо. ");
INSERT INTO rmyservi_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Мэ налиджява пэ пхув баро пани, соб тэ умарэ вса, со джювэл тала болыбэн, дэ кастэ пхурдэл джювимо. Вса, со исин пэ пхув, мэрэла. ");
INSERT INTO rmyservi_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Нэ туґа Мэ терава завето, тай ту заджяґа дэ ковчеґо: ту тай тирэ чявэ, тай тири ромни, тай ромня тирэн чявэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Залиджя дэ ковчеґо всаворэн жывотнонэн по дуй, лэ тай ла, соб вонэ тэ аченпэ джювдэнца ектханэ туґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Тутэ авэна, соб тэ ачепе джювдэнца, пав дуй всаворэндар породэндар чириклен, всаворэндар породэндар жывотнонэн, савэ пхирэн пав пхув тай всаворэ сапа. ");
INSERT INTO rmyservi_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Лэ пэґа всаворо хамо тай стидэ лэ пэстэ, соб тэ ха и тути, и лэнди. ");
INSERT INTO rmyservi_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Ноё терда вса кади, сар пхэнда лэсти Дэвэл. ");
INSERT INTO rmyservi_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","РАЙ пхэнда Ноёсти: Заджя дэ ковчеґо пэхкирэґа їреґа. Мэ дыкхав, со помашкар всаворэн, ко джювэл екхатар, кацик ту чячютно англа Ман. ");
INSERT INTO rmyservi_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Лэ пэґа по ефта пара всаворэндар жужэндар жывотнонэн, ла тай лэ, тай пав екх пара всаворэндар нажужэндар, ла тай лэ, ");
INSERT INTO rmyservi_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","тай пав ефта пара всаворэндар чириклендар, соб тэ авэл и вов , и вой, соб тэ фирисарэ лэн всаворэн пэ пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Проджяна ефта дивэса, Мэ бичялава брышынд пэ пхув пэ саранда дивэн, тай саранда рятен; тай Мэ скхосава пхуятар всаворэн джюдэн, савэн Мэ стердом. ");
INSERT INTO rmyservi_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ноё стерда вса, сар прыпхэнда лэсти РАЙ. ");
INSERT INTO rmyservi_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Кала баро пани авиля пэ пхув, Ноёсти сля шов шэла бэрш. ");
INSERT INTO rmyservi_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Ноё, лэхкирэ чявэ, лэхкири ромни тай ромня лэхкирэн чявэн заджиле дэ ковчеґо, соб тэ фирисарэпэ потопостар. ");
INSERT INTO rmyservi_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Жужэ тай нажужэ жывотные, чирикля и всаворо джювимо ");
INSERT INTO rmyservi_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","авиле Ноёстэ дэ ковчеґо пав дуй: вов и вой, сар прыпхэнда Ноёсти Дэвэл. ");
INSERT INTO rmyservi_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Проджиля ефта дивэ, и пэ пхув джиля баро пани. ");
INSERT INTO rmyservi_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Кала Ноёсти сля шов шэла бэрша, дэ дэшуефтато диво дэ дуйто чён, прочиндэпэ всаворэ ханинга барэ панехкирэ,тай оттердэпэ фылястры болыбэндирэ, ");
INSERT INTO rmyservi_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","тай джялас пэ пхув брышынд саранда дивэса тай саранда ратен. ");
INSERT INTO rmyservi_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Дэ кодэва жэ диво заджиле дэ ковчеґо Ноё, лэхкирэ чявэ Симо, Хамо тай Яфето, ромни Ноёхкири тай ромня тринэн чявэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Лэнца заджиле всаворэ породы жывотнонэн: всаворэ породы дыконэн зверёнэн тай цэрутнонэ скотос, всаворэ породы джювима, савэ пхирэн пав пхув, всаворэ породы чириклен, тай всаворэ, кастэ исин пхака. ");
INSERT INTO rmyservi_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Всаворэ, дэ кастэ пхурдэл джювимо, авиле Ноёстэ тай заджиле дэ ковчеґо по дуй, ");
INSERT INTO rmyservi_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","вов и вой всаворэндар породонэн, сар прыпхэнда Ноёсти Дэвэл. Тай тунчи РАЙ затерда пала лэн удара. ");
INSERT INTO rmyservi_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Потопо сля пэ пхув саранда дивэса, тай пани, саво авэлас, подлиле ковчеґо, тай вов джиля пав пани. ");
INSERT INTO rmyservi_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Пани вса авэлас тай авэлас, ай ковчеґо пхирэлас пав пани. ");
INSERT INTO rmyservi_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Пани кади вучес подлиляпэ пэ пхув, со ушаравда всаворэ вуче плая тала болыбэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Пани подлиляпэ тай ушаравда всаворэ плая вучедэр, сар пэ дэшупанч куя. ");
INSERT INTO rmyservi_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Вса, со сля джювдо пэ пхув, мурдиле: чирикля, ското, дыки зверуря, всаворо джювдо, со пхирэл пав пхув, тай всаворэ мануша. ");
INSERT INTO rmyservi_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Всаворэ пэ пхув, кастэ дэ ратуен сля джювимо, муля. ");
INSERT INTO rmyservi_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Вса, со сля джювдо пэ пхув, вса сля скхосло пхуятар: мануша тай джювимо, саво пхирэл пав пхув, тай чирикля болыбнэндирэ. Кацик ачиляпэ Ноё тай кодыла, ко сле лэґа дэ ковчеґо. ");
INSERT INTO rmyservi_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Потопо лэлас зор пэ пхув шэл пандэша дивэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Дэвэл рапирда пала Ноё тай пала всаворэн дыких зверёнэн, тай пала ското, савэ сле лэґа дэ ковчеґо, тай Вов бичялда балвал пэ пхув, тай пани ачиля тэ уджя. ");
INSERT INTO rmyservi_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ханинга барэ панехкирэ тай фылястры болыбнахкирэ затердэпэ, тай брышынд пэрэачиля тэ джя болыбнастар. ");
INSERT INTO rmyservi_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Пани на сиго ачиля тэ уджя пхуятар, тай дэ шэл панчдэшатиро диво вов фартэ уджиля. ");
INSERT INTO rmyservi_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Пэ дэшуефтатиро диво ефтатиро чёнэхкиро ковчеґо ачиля пэ Араратски плая. ");
INSERT INTO rmyservi_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Пани уджялас дэ дэшто чён, тай дэ пэрво диво дэ дэшто чён ачиле тэ душол вэрхо плаендиро. ");
INSERT INTO rmyservi_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Проджиля саранда дивэса, тай Ноё оттерда фылястра, саво вов стерда дэ ковчеґо. ");
INSERT INTO rmyservi_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Вов вымукля воронос, тай кодэва выуряля тай прыуряля павпалэ дэ колэ, кала пани пэ пхув на вышутиля. ");
INSERT INTO rmyservi_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Тунчи Ноё вымукля гурунгэ, соб тэ удыкхэ, сджиля ли пани упрал пхуятар, ");
INSERT INTO rmyservi_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","нэ гурунго на аракхля шуко тхан, соб тэ бэшэ тэлэ, пала када со пани ушаравэлас всавори пхув, тай рисардапэ Ноёстэ дэ ковчеґо. Ноё процырдэня васт тай лиля гурунгэ павпалэ пэстэ дэ ковчеґо. ");
INSERT INTO rmyservi_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Проджиля ефта дивэн, тай вов упалэ вымукля гурунго ковчеґостар. ");
INSERT INTO rmyservi_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Кала бэльвэляґа гурунго рисардапэ, дэ муй лэстэ сля ївант счиндо оливково листо. Тунчи Ноё полиля, со пани сджиля пхуятар. ");
INSERT INTO rmyservi_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Вов дожутярда инте ефта дивэса тай упалэ вымукля гурунго, тай пэ кадыва моло гурунго на рисардапэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Дэ пэрво диво пэрвонэ чёнэхкиро, кала Ноёсти сля шов шэла екх бэрш, пхув вышутиля панестар. Ноё подлиля стрэха дэ ковчеґо, тай удыкхля, со пхув шуки. ");
INSERT INTO rmyservi_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Дэ биш ефтандиро диво дуйтонэ чёнэхкиро пхув ачиля всавори шуки. ");
INSERT INTO rmyservi_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Тунчи Дэвэл пхэнда Ноёсти: ");
INSERT INTO rmyservi_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","— Выджя ковчеґостар ту тай тири ромни, тай тирэ чявэ, тай лэндирэ ромня. ");
INSERT INTO rmyservi_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Вылиджя пэ гаса со исин туґа джювдо, — чириклен, зверёнэн тай всаворо джювимо, саво пхирэл пав пхув. Мэк вонэ терэн чяворэн пэсти, тай мэк лэн авэла бут. ");
INSERT INTO rmyservi_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Тунчи Ноё выджиля ковчеґостар екхтханэ пэхкирэнца чявэнца, ромняґа тай ромненца пэхкирэн чявэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Всаворэ барэ тай цыкнэ жывотные, савэ пхирэн пав пхув, тай всаворэ чирикля — всаворэ выджиле ковчеґостар, екх порода пала авря. ");
INSERT INTO rmyservi_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Ноё стерда РАЕСТИ жэртвенико, лиля жужэн жывотнонэн тай чириклен кожнонэстар родостар, зачинда лэн тай спхабарда лэн пэ яг. ");
INSERT INTO rmyservi_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","РАЙ ашунда лачё фано тай пхэнда дэ їло Пэстэ: — Колатар вряматар, сар мануш цыкно, їло тай годи лэхкири цырдэлпэ тэ терэ врытимо. Мэ будэр на авава тэ дэ мрая пхув пала лэ тай никала будэр на умарава всаворэн джювдэн, сар екхатар. ");
INSERT INTO rmyservi_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Покы исин джювимо пэ пхув, на пэрэачела вряма, кала мануша авэна тэ росчювэ тай тэ стидэ ворзо, на пэрэачела шылалимо тай татимо, милай тай ївэнт, диво тай рат. ");
INSERT INTO rmyservi_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Дэвэл бахтисарда Ноё тай лэхкирэн чявэн и пхэнда лэнди: — Мэк тумэндэ авэна чяворэ, тай мэк лэн авэла бут, тай пхэрдён пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Мэк всаворэ зверуря тай всаворэ чирикля болыбнахкирэ, всаворо джювимо пэ пхув тай всаворэ морендирэ маче даранпэ тумэн тай тинисявэн. Всаворэн лэн Мэ отдав тумэнди дэ вастэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Вса, со джювэл тай пхирэл, авэла тумэнди дэ хама. Сар дэ калэ Мэ дэнём тумэнди зэлэнь, кади и екхатар Мэ отдав тумэнди вса. ");
INSERT INTO rmyservi_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Кацик на хан мас, дэ савэ исин инте рат. ");
INSERT INTO rmyservi_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Тай пала тумаро рат Мэ мангава тэ дэн цымин. Мэ спхучява кожнонэстар жывотнонэстар, соб вонэ тэ дэн цымин. Тай манушэстар Мэ пхучява пала джювимо лэхкирэ пхралэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Ко бы на прочюта рат манушэхкиро, вастэґа аврэ манушэ прочювэлапэ и лэхкиро рат. Пала када со мануш стердо, сар образо Дэвлэхкоро. ");
INSERT INTO rmyservi_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Мэк тумэндэ авэна чяворэ, тай мэк лэн авэла бут. Розджянпэ пав пхув тай пхэрдён ла. ");
INSERT INTO rmyservi_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Тунчи Дэвэл пхэнда Ноёсти тай лэхкирэнди чявэнди: ");
INSERT INTO rmyservi_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","— Екхатар Мэ дав завето тумэнди тай тумарэнди чяворэнди, ");
INSERT INTO rmyservi_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","тай всаворяти джювимати, сави сля тумэнца: чирикленди, скотости, дыконэнди зверёнэнди — всаворэнди, ко выджиля тумэнца ковчеґостар, кожнонэсти жывотнонэсти пэ пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Мэ дав тумэнди завето: никала будэр вса, со джювэл, на авэла умардо баряґа панеґа; никала будэр на авэла потопо тэ умарэ пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Дэвэл пхэнда: — Акэ знако заветохкоро, саво Мэ дав тумэнди тай всаворяти джювимати, саво тумэнца, пэ всаворо родуря, савэ авэна. ");
INSERT INTO rmyservi_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Мэ тховав дэ Мурэ тучи радуґа, тай вой авэла знако заветохкоро, саво Мэ дав пхуяти. ");
INSERT INTO rmyservi_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Кала Мэ бичялава тучи пэ пхув, дэ тучи авэла радуґа, ");
INSERT INTO rmyservi_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","тай Мэ взрапирава Муро завето, саво Мэ дав тумэнди тай кожнонэсти, дэ кастэ исин джювимо. Никала будэр баро пани на умарэла вса джювдо. ");
INSERT INTO rmyservi_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Всако моло, кала радуґа авэла дэ тучен, Мэ удыкхава ла тай взрапирава вечно завето, саво дав всаворяти джювимати, сави исин пэ пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Кади пхэнда Дэвэл Ноёсти: — Акэ знако заветохкоро, саво Мэ дав всаворэсти, дэ кастэ исин джювимо пэ пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Чявэ Ноёхкирэ, савэ выджиле ковчеґостар, сле Симо, Хамо тай Яфето (Хамо сля дад Ханааности). ");
INSERT INTO rmyservi_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Кала трин сле чявэ Ноёхкирэ, тай лэндар выджиле народуря, савэ розджилепэ пав пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Ноё ачиля тэ терэ бути пхуяґа тай барярэл виноградо. ");
INSERT INTO rmyservi_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Екхвар вов выпиля мол тай матиля, тай пашлёлас нанго дэ пэхкири катуна. ");
INSERT INTO rmyservi_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Хамо, дад Ханаанохкиро, удыкхля нангимо пэхкирэ дадэхкирэ, выджиля тай роспхэнда пала када пхралэнди. ");
INSERT INTO rmyservi_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Нэ Симо тай Яфето лиле їда, тховдэ ла пэсти пэ пхикэн, заджиле павпалэ думэґа тай ушаравдэ нангимо дадэхкиро. Лэндирэ муя сле отрисардэ дэ авэр риг, соб тэ на удыкхэ нангимо дадэхкиро. ");
INSERT INTO rmyservi_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Кала Ноё просутапэ матиматар, вов уджянгля, со терда лэґа цыкнэдэр чяво, ");
INSERT INTO rmyservi_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","тай пхэнда: — Прыдав мрая Ханаано! Вов авэла майпалуно копылендар пэхкирэнди пхралэнди. ");
INSERT INTO rmyservi_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Инте вов пхэнда: — Бахтисардо РАЙ, Дэвэл Симохкоро! Мэк Ханаано авэла лэсти копыли. ");
INSERT INTO rmyservi_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Мэк Дэвэл дэла Яфетости бугли пхув! Мэк джювэл Яфето дэ катунэн Симохкирэн, тай мэк авэла Ханаано лэхкирэґа копылеґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Сар проджиля потопо, Ноё джювда трин шэл панчдэша бэрш. ");
INSERT INTO rmyservi_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Всаворо джювимо Ноёхкиро сля иня шэла панчдэша бэрш, тай вов муля. ");
INSERT INTO rmyservi_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Акэ роспхэндимо пала Ноёхкирэн чявэн, пала Симо, Хамо, Яфето, тай пала лэндирэн чяворэн, савэ бэяндэпэ, кала проджиля потопо. ");
INSERT INTO rmyservi_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Яфетохкирэ чявэ: Гомеро, Магого, Мадаё, Явано, Тувало, Мешэхо тай Тирасо. ");
INSERT INTO rmyservi_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Гомерохкирэ чявэ: Ашкеназо, Рифато тай Тогарма. ");
INSERT INTO rmyservi_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Яванохкирэ чявэ: Элиша, Таршышо, Киттимо тай Роданимо. ");
INSERT INTO rmyservi_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Лэндар выджиле народуря, савэ ачиле тэ джювэ пэ брэго морёхкиро, вонэ розджилепэ пав пэхкирэн народонэн, родонэн тай чибэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Хамохкирэ чявэ: Кушо, Мицраимо, Путо тай Ханаано. ");
INSERT INTO rmyservi_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Кушохкирэ чявэ: Сева, Хавила, Савта, Раама тай Савтеха. Раамахкирэ чявэ: Шэва тай Дедано. ");
INSERT INTO rmyservi_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Кушо сля дадэґа кади ж Нимродости, саво ачиля англуно зорало мануш пэ пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Вов мишто астарэлас жывотнонэн англа РАЙ, пала када и пхэнэлпэ: «Баро астаримари англа РАЙ, сар Нимродо». ");
INSERT INTO rmyservi_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Англунэ фороря дэ лэхкиро тхагаримо сле Вавилоно, Эрехо, Аккадо тай Халне дэ Шынаро. ");
INSERT INTO rmyservi_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Кадэла пхуятар вов пэрэджиля дэ Ассирия, тев стерда Ниневия, Реховот-Иро, Калахо ");
INSERT INTO rmyservi_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","тай Ресено помашкар Ниневия тай Калахо — баро форо. ");
INSERT INTO rmyservi_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Мицраимостар джиле: лудея, анамея, легевея, нафтухея, ");
INSERT INTO rmyservi_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","патрусея, каслухея (савэндар джиле филистимлянуря) тай кафторея. ");
INSERT INTO rmyservi_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Ханаано сля дадэґа Сидоности, када лэстэ сля пхурыдэр чяво, Хето, ");
INSERT INTO rmyservi_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","кади ж евусея, аморея, гергесея, ");
INSERT INTO rmyservi_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","хивея, аркея, синея, ");
INSERT INTO rmyservi_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","арвадея, цэмарея тай хаматея. Проджиля вряма, тай всаворэ мануша розджилепэ пав пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Брэги Ханаанохкирэ процырдэнаспэ Сидоностар дэ риг Герарохкири ды Газа, тай дэ риг Содомохкири тай Гомморахкири, Адмахкири тай Цэвоимохкири ды Лаша. ");
INSERT INTO rmyservi_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Када чяворэ Хамохкирэ, лэндирэ їря тай народуря, кожно дэ пэхкири пхув тай пэхкиряґа чибаґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Бэяндэпэ чявэ кади ж Симостэ, пхурэдэр пхралэстэ Яфетохкирэ. Всаворэ чявэ Эверохкирэ джиле Симостар. ");
INSERT INTO rmyservi_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Симохкирэ чявэ: Эламо, Ашшуро, Арпахшадо, Лудо тай Арамо. ");
INSERT INTO rmyservi_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Арамохкирэ чявэ: Уцо, Хуло, Гетеро тай Машо. ");
INSERT INTO rmyservi_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Арпахшадостэ бэяндапэ Шэлахо, Шэлахостэ бэяндапэ Эверо. ");
INSERT INTO rmyservi_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Эверостэ бэяндэпэ дуй чявэ: екхэ акхарэнас Пелего (пала када со дэ лэхкири вряма пхув розчиндапэ), лэхкирэ пхралэ — Йоктано. ");
INSERT INTO rmyservi_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Йоктаностэ бэяндэпэ Алмодадо, Шалефо, Хацармавето, Ярахо, ");
INSERT INTO rmyservi_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Хадорамо, Узало, Дикла, ");
INSERT INTO rmyservi_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Овало, Авимаило, Шэва, ");
INSERT INTO rmyservi_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Офиро, Хавила тай Йоваво. Всаворэ вонэ сле чявэнца Йоктанохкирэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Тхан, тев вонэ джюдэ, процырдэласпэ Мешастар ды Сефаро, дэ восточно риг плаендар. ");
INSERT INTO rmyservi_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Када чявэ Симохкирэ, лэндирэ їря, народуря, кожно дэ пэхкири пхув тай пэхкиряґа чибаґа Кала мануша бэяндэпэ Симостэ пав пэхкири порода, пэхкиряґа чибаґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Кацавэ їря Ноёхкирэн чявэн, пав лэндирэ родуря тай народуря. Сар проджиля потопо, лэндар джиле всаворэ народуря пэ пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Пэ всавори люмля сля екх чиб тай екх дума. ");
INSERT INTO rmyservi_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Мануша ачиле тэ джя пэ востоко, аракхли дэ пхув Шынаро маля тай джювэнас котэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Вонэ пхэндэ екх екхэсти: — Стераґа глинатар бара тай выпхабараґа лэн мишто. Кола вряматар вонэ ачиле тэ тховэ бара глинатар, тай смола сля сар састимос машкара бара. ");
INSERT INTO rmyservi_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Вонэ пхэндэ: — Тераґа амэнди форо башняґа ды болыбэн, соб тэ ашарэлпэ амаро лав тай тэ на розджяпэ пав всавори пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","РАЙ сджиля тэ дыкхэ форо башняґа, савэ терэнас мануша, ");
INSERT INTO rmyservi_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","тай пхэнда: — Всаворэ мануша — екх народо, лэндэ екх чиб. Тай катар каси кацик икхатар. Кана вонэ со скамэна, кода вонэ стерэна. ");
INSERT INTO rmyservi_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Сджяґа тэлэ тай паруваґа лэндири чиб, соб вонэ тэ на полэн екх екхэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Тай РАЙ розчюта лэн пав всавори пхув, и вонэ пэрэачиле тэ терэ кодэва форо. ");
INSERT INTO rmyservi_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Акэ сости прыпхэндэ форости Вавилоно — РАЙ парувда котэ чиб всаворя люмляти. Котар РАЙ розчюта лэн пав всаворо муй пхуятиро. ");
INSERT INTO rmyservi_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Акэ роспхэндимо пала Симо тай пала лэхкирэн чяворэн. Проджиля дуй бэрш сар сля потопо. Кала Симости сля шэл бэрш, лэстэ бэяндапэ Арпахшадо. ");
INSERT INTO rmyservi_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Тунчи, сар бэяндапэ Арпахшадо, Симо джюда 500 бэрш, тай лэстэ сле инте чявэ тай чея. ");
INSERT INTO rmyservi_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Кала Арпахшадо проджюда 35 бэрш, лэстэ бэяндапэ Шэлахо. ");
INSERT INTO rmyservi_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Тунчи, сар бэяндапэ Шэлахо, Арпахшадо джюда 403 бэрш, тай лэстэ сле инте чявэ тай чея. ");
INSERT INTO rmyservi_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Кала Шэлахо проджюда 30 бэрш, лэстэ бэяндапэ Эверо. ");
INSERT INTO rmyservi_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Тунчи, сар бэяндапэ Эверо, Шэлахо джюда 403 бэрш, тай лэстэ сле инте чявэ тай чея. ");
INSERT INTO rmyservi_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Кала Эверо проджюда 34 бэрш, лэстэ бэяндапэ Пелего. ");
INSERT INTO rmyservi_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Тунчи, сар бэяндапэ Пелего, Эверо джюда 430 бэрш, тай лэстэ сле инте чявэ тай чея. ");
INSERT INTO rmyservi_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Кала Пелего проджюда 30 бэрш, лэстэ бэяндапэ Реу. ");
INSERT INTO rmyservi_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Тунчи, сар бэяндапэ Реу, Пелего джюда 209 бэрш, тай лэстэ сле инте чявэ тай чея. ");
INSERT INTO rmyservi_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Кала Реу проджюда 32 бэрш, лэстэ бэяндапэ Серуго. ");
INSERT INTO rmyservi_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Тунчи, сар бэяндапэ Серуго, Реу джюда 207 бэрш, тай лэстэ сле инте чявэ тай чея. ");
INSERT INTO rmyservi_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Кала Серуго проджюда 30 бэрш, лэстэ бэяндапэ Нахоро. ");
INSERT INTO rmyservi_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Тунчи, сар бэяндапэ Нахоро, Серуго джюда 200 бэрш, тай лэстэ сле инте чявэ тай чея. ");
INSERT INTO rmyservi_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Кала Нахоро проджюда 29 бэрш, лэстэ бэяндапэ Терахо. ");
INSERT INTO rmyservi_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Тунчи, сар бэяндапэ Терахо, Нахоро джюда 119 бэрш, тай лэстэ сле инте чявэ тай чея. ");
INSERT INTO rmyservi_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Тунчи, сар Терахо проджюда 70 бэрш, лэстэ бэяндэпэ Аврамо, Нахоро тай Арано. ");
INSERT INTO rmyservi_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Акэ роспхэндимо пала Терахо тай пала лэхкирэн чяворэн. Терахостэ бэяндэпэ Аврамо, Нахоро тай Арано. Араностэ бэяндапэ Лото. ");
INSERT INTO rmyservi_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Кала лэхкиро дад Терахо сля инте джювдо, Арано муля дэ Уро халдеендиро, дэ кодыя пхув, тев вов бэяндапэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Аврамо тай Нахоро лиле пэсти ромнен. Аврамохкиря ромня акхарэнас Сара, ай Нахорохкиря ромня — Милка. Милка тай латири пхэнь Иска сле чея Аранохкирэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Сара на бэянэлас нисар чяворэн, латэ на сля чяворэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Терахо лиля пэхкирэ чявэ Аврамо, пэхкирэ внуко Лотос, Аранохкирэ чявэ, тай пэхкиря боря Сара, ромня Аврамохкиря, тай ектханэ вонэ выджиле Уростар халдеендирэстар дэ Ханаано. Нэ кала доджиле дэ Харано, вонэ ачилепэ котэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Терахо джюда 205 бэрш тай муля дэ Харано. ");
INSERT INTO rmyservi_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","РАЙ пхэнда Аврамости: — Ачяв пэхкири пхув, пэхкиро форо, пэхкирэн манушэн тай дадэхкиро цэр тай джя дэ пхув, сави Мэ тути сикавава. ");
INSERT INTO rmyservi_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Мэ терава тутар баро народо тай бахталисарава тут; Мэ терава, со тиро лав авэла баро, тай ту авэґа бахтаґа важ аврэн манушэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Мэ бахталисарава колэн, ко бахталисарэл тут, тай прэдава мрая кодылэ, ко дэл мрая тут; тай пала тут авэна бахталисардэ всаворэ народуря пэ пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Тай Аврамо джиля дэ дром, сар пхэнда лэсти РАЙ, тай Лото джиля екхтханэ лэґа. Аврамости сля 75 бэрш, кала вов уджиля Хараностар. ");
INSERT INTO rmyservi_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Вов лиля пэґа пэхкиря ромня Сара, племянико Лото, всаворо пэхкиро барвалимо, саво сля лэндэ, тай манушэн, савэн вонэ тиндэ дэ Харано. Вонэ джиле дэ пхув Ханаано тай авиле пордэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Аврамо проджиля пав кадыя пхув дэ колэ тханэ дэ Шэхемо, тев ачелас дубо Морэ; дэ кодыя вряма котэ джюдэ ханаанея. ");
INSERT INTO rmyservi_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","РАЙ авиля Аврамостэ тай пхэнда: — Мэ дава кадыя пхув тирэ чяворэнди. Аврамо стерда котэ жэртвенико РАЕСТИ, Саво авиля лэстэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Котар вов джиля дэ плаендирэ тхана дэ восточно риг Вефилёстар тай тховда катуна помашкар Вефилё пэ западо тай Гаё пэ востоко. Котэ вов стерда жэртвенико РАЕСТИ тай прыакхарда лав РАЕХКИРО. ");
INSERT INTO rmyservi_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Тунчи Аврамо слиляпэ тханэстар тай джиля пэ юґо, дэ Негево. ");
INSERT INTO rmyservi_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Пэ пхув сля бокх, тай бокх сля фартэ зорало. Пала кода Аврамо джиля тэ джювэ дэ Египто. ");
INSERT INTO rmyservi_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Кала вонэ поджянас дэ Египто, вов пхэнда пэхкиря ромняти Сарати: — Всаворэ дыкхэн, со ту шукарни джювли. ");
INSERT INTO rmyservi_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Кала египтянуря удыкхэна тут, вонэ думисарэна, со ту мури ромни, тай умарэна манман, ай тут ачявэна тэ джювэх. ");
INSERT INTO rmyservi_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Пхэн, со ту мури пхэнь, соб пала тут ман тэ прылэн мишто тай тэ наисарэ тут мэ тэ ачявпэ джювдо. ");
INSERT INTO rmyservi_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Кала Аврамо авиля дэ Египто, египтянуря удыкхле, со Сара фартэ шукарни. ");
INSERT INTO rmyservi_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ай кала ла удыкхле барэ рая фараонохкирэ, вонэ розашардэ ла фараоности, тай лиле Сара лэстэ дэ дворцо. ");
INSERT INTO rmyservi_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Фараоно мишто прылиля Аврамо пала Сара, тай Аврамо тинда хурдо тай баро хулаимо, магарен тай магарицэн, верблюдонэн, копылен тай копыльницэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Нэ РАЙ бичялда пэ фараоно тай пэ всаворо лэхкиро цэр пхарэ насвалима пала Аврамохкиря ромня Сара. ");
INSERT INTO rmyservi_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Тунчи фараоно прыакхарда Аврамо тай пхучля: — Со ту тердан манца? Сости ту на пхэндан манди, со вой тири ромни? ");
INSERT INTO rmyservi_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Пэ со ту пхэндан, со вой тири пхэнь? Кацик пала када мэ лилём ла ромняґа. Акэ тири ромни. Залэ ла тай уджя! ");
INSERT INTO rmyservi_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Фараоно прыпхэнда, тай лэхкирэ мануша отбичялдэ Аврамо дэ дром екхтханэ лэхкиряґа ромняґа тай всаворэґа, со сля лэстэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Аврамо ромняґа тай всаворяґа барвалимаґа рисиля Еґиптостар дэ Негево, тай Лото джиля лэґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Аврамостэ кана сля бут ското, рупь тай сувнак. ");
INSERT INTO rmyservi_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Негевостар вов джялас дурыдэр дромэґа, покы на авиля дэ Вефилё, колэстэ тханэстэ, тев калась ачелас лэхкири катуна, помашкар Вефилё тай Гаё, ");
INSERT INTO rmyservi_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","колэстэ тханэстэ, тев Аврамо дэ колэ стерда жэртвенико. Котэ Аврамо прыакхарда лав РАЕХКИРО. ");
INSERT INTO rmyservi_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Лотостэ, саво пхирэлас Аврамоґа, кади ж сля фартэ бут хурдо тай баро ското тай катуны, ");
INSERT INTO rmyservi_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","тай пхув на ґалёлас тэ пропарварэ лэн дуен: лэндэ сля кади бут барвалимо, со вонэ на ґалёнас тэ проджювэ екхтханэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Машкар Аврамохкирэ чябануря тай Лотохкирэ чябануря заджиля холи. Тунчи дэ кодыя пхув джювэнас ханаанея тай периззея. ");
INSERT INTO rmyservi_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Тунчи Аврамо пхэнда Лотости: — Мэк на авэла холи на машкар тут тай ман, на машкар тирэн чябануря тай мурэн. Амэ ж пэхкирэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Подыкх, всавори пхув англа тутэ! Фэдэр розджямпэ: сар ту джяґа пэ зэрво, тунчи мэ порисявава пэ чячи риг, ай сар ту джяґа пэ чячи риг, тунчи мэ порисявава пэ зэрво. ");
INSERT INTO rmyservi_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Лото подыкхля тай удыкхля, со всавори маля Иордано дэ Цоаро мишто протиндёлас, сар садо РАЕХКИРО, сар пхув Египто. Када сля инте дэ колэ, сар РАЙ спхабарда Содомо тай Гомора. ");
INSERT INTO rmyservi_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Лото вылиля пэсти всавори маля Иордано тай джиля пэ востоко. Вонэ розджилепе: ");
INSERT INTO rmyservi_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Аврамо джюда дэ пхув Ханаано , ай Лото джювэлас машкар форуря пэ маля, тховда катуны надур Содомостар. ");
INSERT INTO rmyservi_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Мануша дэ Содомо сле налаче тай фартэ терэнас бут пхарэ бэзэха англа РАЙ. ");
INSERT INTO rmyservi_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Тунчи, сар Лото отджиля Аврамостар, РАЙ пхэнда Аврамости: — Обдыкхпэ колэстар тханэстар, тев ту екхатар. Подыкх пэ северо, тай пэ юґо, пэ востоко тай пэ западо. ");
INSERT INTO rmyservi_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Всавори пхув, сави ту дыкхэх, Мэ дава тути тай тирэнди чяворэнди пэ всаворэ вако. ");
INSERT INTO rmyservi_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Мэ терава, со терэн чяворэн авэла пхэрдо, сар тишай пэ пхув. Акэ со сар ко ґалёла тэ пэрэбинэ тишай, тунчи тай тирэ чяворэ авэна побиндэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Джя, проджяпэ пэ кадыя пхув дэ лунгима тай дэ буґлима. Мэ дава ла тути. ");
INSERT INTO rmyservi_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Аврамо стидыня катуны тай джиля тэ джювэ надур вэшэстар Мамре дэ Хевроно. Вов стерда котэ жэртвенико РАЕСТИ. ");
INSERT INTO rmyservi_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Дэ кодыя вряма Амрафело, тхагари Шынарохкиро, Ариохо, тхагари Элласарохкиро, Кедорлаомеро, тхагари Эламохкиро, тай Тидало, тхагари Гоимохкиро, ");
INSERT INTO rmyservi_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","екхтханэ джиле маримаґа пэ Бера, пэ тхагари Содомохкиро, пэ Бирша, пэ тхагари Гоморахкиро, пэ Шынаво, пэ тхагари Адмахкиро, пэ Шэмеверо, пэ тхагари Цэвоимохкиро, тай пэ тхагари Бела (када и исин Цоаро). ");
INSERT INTO rmyservi_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Кадыла тхагаря стидынепе зорэнца дэ маля Сиддимо (тев екхатар Лондо мори). ");
INSERT INTO rmyservi_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Дэшудуй бэрш вонэ слэ тала зор Кедорлаомерохкиро, нэ пэ дэшутрито бэрш вонэ подлилепэ пэ лэстэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Дэ дэшуштарто бэрш Кедорлаомеро тай лэхкирэ тхагаря амала выджиле тай розмардэ рефаимеен дэ Аштерото-Карнаимо, зузимеен дэ Хамо, эмимеен дэ Шаве-Кирьятаимо ");
INSERT INTO rmyservi_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","тай хореен пэ плая Сеиро, пэ дром дэ Эл-Парано, пэ брэга дэ шуки пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Котар вонэ порисиле павпалэ тай авиле дэ Эн-Мишпато (када и исин Кадешо) тай лиле всавори пхув амалекитянэндири, тай кадиж амореен, савэ джювэнас дэ Хацацоно-Тамаро. ");
INSERT INTO rmyservi_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Пэ лэндэ выджиля тхагари Содомохкиро, тхагари Гоморахкиро, тхагари Адмахкиро, тхагари Цэвоимохкиро тай тхагари Белахкиро (када и исин Цоарохкиро). Дэ маля Сиддимо вонэ ачиле тэ марэпэ ");
INSERT INTO rmyservi_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Кедорлаомероґа, тхагареґа Эламохкиро, Тидалоґа, тхагареґа Гоимохкиро, Амрафелоґа, тхагареґа Шынарохкиро, тай Ариохоґа, тхагареґа Элласарохкиро, — штар тхагарен джиле пэ панч. ");
INSERT INTO rmyservi_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Пэ маля Сиддимо сля бут смоляно хывъя; кала тхагари Содомохкирэ тай Гоморахкирэ ачиле тэ нашэ котар, бут военонэн тэлэдыне дэ хывъя, ай ко ачиляпэ, понашле дэ плая. ");
INSERT INTO rmyservi_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Штар тхагарен залиле всаворо барвалимо Содомохкиро тай Гоморахкиро тай вса, со лэндэ сля, тай уджиле. ");
INSERT INTO rmyservi_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Вонэ залиле кадиж Аврамохкирэ племянико Лото, саво джюда дэ Содомо, тай всаворо лэхкиро барвалимо. ");
INSERT INTO rmyservi_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Екх кодылэндар, ко фирисардапэ, авиля тай роспхэнда пала када евреёсти Аврамости. Аврамо джюда надур дубонэндар, савэ сле аморехкирэ Мамрехкирэ. Лэхкирэ пхрала Эшколо тай Анеро сле Аврамохкирэ амала. ");
INSERT INTO rmyservi_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Кала Аврамо ушунда, со лэхкирэ племянико залиле дэ плено, Аврамо акхарда трин шэл душуохто муршэн, савэ джянэнас тэ марэпэ, савэ бэяндэпэ лэстэ цэрэ, попрастыня пала штарэн тхагарен тай джялас пав лэндири шпэра дэ Дано. ");
INSERT INTO rmyservi_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ратяґа Аврамо ростховда пэхкирэн манушэн пэ дуен тай джиля маримаґа пэ врыжымашэн. Вонэ ачиле тэ нашэ, ай Аврамо традэлас лэн дэ Хова, северостэ Дамаскостар. ");
INSERT INTO rmyservi_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Вов рисарда всаворо лачимо тай пэхкирэ племянико Лото всаворяґа барвалимаґа, тай джювлен, тай манушэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Кала Аврамо рисарэласпэ тунчи, сар помарда Кедорлаомеро тай тхагарен, савэ сле лэхкирэ амала, тхагари Содомохкиро выджиля тэ дыкхэл лэ дэ маля Шаве (када исин Тхагарендири маля). ");
INSERT INTO rmyservi_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Мелхиседеко, тхагари Салимохкиро, вылиджялда мандро тай мол. Вов сля рашаи Дэвлэхкиро Майвучехкиро. ");
INSERT INTO rmyservi_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Вов бахталисарда Аврамо, пхэнда: — Бахталисардо ав Аврамо Дэвлэстар Майвучестар, Саво стерда болыбэн тай пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Тай ашардо ав Дэвэл Майвучё, Саво отдэня тирэн врыжымашонэн дэ тирэ васта. Аврамо отдыня лэсти всаворэстар дэшто котор. ");
INSERT INTO rmyservi_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Тхагари Содомохкиро пхэнда Аврамости: — Отдэ манди мурэн манушэн, ай лачимо ачяв пэсти. ");
INSERT INTO rmyservi_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Нэ Аврамо пхэнда тхагарести Содомохкирэсти: — Мэ подлав васт РАЕСТИ, Дэвлэсти Майвучести, Саво стерда болыбэн тай пхув, тай дав солах, ");
INSERT INTO rmyservi_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","со на прылава тутар ни тхав, ни кущик сандалёнэндар, на лава нисо тиро, соб ту тэ на пхэнэх: «Мэ барвалисардом Аврамо». ");
INSERT INTO rmyservi_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Мэ лава кацик кода, со схале мурэ мануша. Ай ко джиля манца — Анеро, Эшколо тай Мамре — мэк лэна пэхкиро котор. ");
INSERT INTO rmyservi_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Тунчи РАЙ сикавдапэ Аврамости тай пхэнда: — На дар, Аврамо. Мэ — тиро щито. Тири бахт авэла фартэ бари. ");
INSERT INTO rmyservi_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Аврамо пхэнда: — О Хулай, РАЙ, со Ту ґалювэґа манди тэ дэ, кала мэ ачявпэ бичяворэндиро, тай муро барвалимо ачелапэ Элиезерости Дамаскостар? ");
INSERT INTO rmyservi_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Аврамо допхэнда: — Ту на дынян манди чяворэн, тай копыли мурэ цэрэхкиро авэла хулаеґа муря барвалиматэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Пэ када сля лэсти лав РАЕХКИРО: — Вов на авэла хулаеґа тиря барвалиматэ. Пэ вса хулай авэла тутар. ");
INSERT INTO rmyservi_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","РАЙ вылиджялда лэ пэ гаса тай пхэнда: — Подыкх пэ болыбэн тай побин чергэня, сар сґалювэґа лэн пэрэбинэ. Тай пхэнда лэсти: — Акэ скацик авэна тутэ чяворэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Аврамо патиня РАЕСТИ, тай Вов заискрисарда када лэсти дэ чячимо. ");
INSERT INTO rmyservi_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Инте Вов пхэнда Аврамости: — Мэ — РАЙ, Саво вылиджялда тут Уростар халдеендирэстар, соб тэ дэ кадыя пхув тути дэ хулаимастэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Нэ Аврамо пхучля: — О Хулай, РАЁ, сар мэ уджянава, со мэ авава хуляеґа лати? ");
INSERT INTO rmyservi_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","РАЙ пхэнда лэсти: — Ан Манди тринбэршэхкиря гурувня, тринбэршэхкиря бузня тай тринбэршэхкирэ бакрэ, а кадиж ан гурунгэ тай тэрнэ гурунгэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Аврамо кади и стерда. Вов росчинда лэн по їпаш тай ростховда їпаша екх англа екхатэ; ай чириклен вов на росчинда по їпаш. ");
INSERT INTO rmyservi_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Прыурянас орлуря, соб тэ хан мулэн, ай Аврамо отдаравэлас лэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Сар кхам ачиля тэ бэшэ, Аврамо схутилда фартэ зорало совлимо; тай смукляпэ баро калимо, тай дар лиля лэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","РАЙ пхэнда лэсти: — Джян, со тирэ чяворэ авэна тэ джювэ на дэ пэхкири пхув; вонэ авэна копыленца тай авэна дэ пхарима штар шэла бэрш. ");
INSERT INTO rmyservi_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Нэ Мэ марава колэн манушэн, савэ тердэ лэн копыленца. Тунчи тирэ потомкуря выджяна котар баряґа барвалимаґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ту отджяґа дадэндэ пэхкирэндэ дэ пачя тай авэґа загаравдо дэ баро пхуранимо. ");
INSERT INTO rmyservi_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Бэзэх амореендиро инте на допхэрдиля, пала када кордэ рисавэла кацик штарто родо тирэн потомконэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Кала кхам бэшля тай ачиля калимо, сикавдапэ тхув и яг, тай вонэ проджиле машкар розчиндэ которэндэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Дэ кодэва диво РАЙ стерда Аврамоґа завето тай пхэнда: — Мэ отдав тирэнди потомконэнди кадыя пхув, египетсконатар лэнятар дэ баря лэнь Евфрато: ");
INSERT INTO rmyservi_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","пхув кенеендири, кениззеендири, кадмонеендири, ");
INSERT INTO rmyservi_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","хеттеендири, периззеендири, рефаимеендири, ");
INSERT INTO rmyservi_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","амореендири, ханаанеендири, гергесеендири тай евусеендири. ");
INSERT INTO rmyservi_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Сара, ромни Аврамохкири, на бэяндёлас лэсти чяворэн. Латэ сля копыльница Египтостар, ла акхарэнас Агарь. ");
INSERT INTO rmyservi_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Сара пхэнда Аврамости: — РАЙ на дыня манди чяворэн. Джя, пэр копыльницаґа: сар на авэна латар мандэ чяворэ? Аврамости чялиля када. ");
INSERT INTO rmyservi_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Тай акэ, кала Аврамо проджюда дэ Ханаано дэш бэрш, Сара, лэхкири ромни, лиля пэхкиря копыльница, Агарь, сави сля Египтостар, тай отдыня дэ ромнен пэхкирэсти ромэсти. ");
INSERT INTO rmyservi_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Вов пыля Агарьяґа, тай вой ачиля пхари. Кала вой уджянгля, со пхари, Агарь ачиля тэ подасапэ пэхкирятар хулаятар. ");
INSERT INTO rmyservi_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Тунчи Сара пхэнда Аврамости: — Ту вуджило дэ када, со мэ дэ холи. Мэ отдынём копыльница тути дэ пато, ай кана вой джянэл, со пхари, тай подасалпэ мандар. Мэк РАЙ сундисарэл амэн туґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","— Тири копыльница дэ тирэн вастэн, — пхэнда Аврамо. — Тер лаґа вса, со камэх. Тунчи Сара ачиля кади врыто пэ тэ лиджя Агаряґа, со кодыя унашля латар. ");
INSERT INTO rmyservi_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Ангело РАЕХКИРО аракхля Агарь дэ шуки пхув, надур лэнёратар; кадыя лэнёри сля пашэ дромэстэ дэ Шуро. ");
INSERT INTO rmyservi_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Вов пхучля: — Агарь, копыльница Саратири, катар ту авилян тай тев джях? — Мэ нашав мурятар хуланятар Саратар, — пхэнда вой. ");
INSERT INTO rmyservi_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Тунчи Ангело РАЕХКИРО пхэнда лати: — Рисяв пэхкирятэ хуланятэ тай тэлюв лати. ");
INSERT INTO rmyservi_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Инте Ангело РАЕХКИРО пхэнда лати: — Мэ кади терава бут тирэн потомконэн, со лэн нащи авэла тэ побинэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Инте Ангело РАЕХКИРО пхэнда лати: — Ту кана пхари тай бэянэґа чявэ. Акхар лэ Измаило, пала када со РАЙ ушунда пала тири дукх. ");
INSERT INTO rmyservi_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Вов авэла, сар дыко магари: Вов авэла всаворэнди врыжымашы, тай лэсти всаворэ авэна врыжымашы. Вов авэла тэ джювэ дэ холя всаворэнца пэхкирэнца пхралэнца. ");
INSERT INTO rmyservi_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","РАЕСТИ, Саво дэдуманя лаґа, Агарь дэня лав «Эл-Рои», пала кода со вой пхэнда: — Екхатар мэ дыкхлём Колэ, Ко дыкхэл ман. ");
INSERT INTO rmyservi_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","(Акэ сости кодэва ханинг сля акхардо Бээр-Лахай-Рои, вов и екхатар котэ, машкар Кадешоґа и Бередоґа.) ");
INSERT INTO rmyservi_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Агарь бэянда Аврамости чявэ, тай Аврамо дэня чявэсти, савэ вой бэянда, лав Измаило. ");
INSERT INTO rmyservi_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Кала Агарь бэянда Аврамости Измаило, лэсти сля 86 бэрш. ");
INSERT INTO rmyservi_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Кала Аврамости сля 99 бэрш, РАЙ сикавдапэ лэсти тай пхэнда: — Мэ— Дэвэл Всазорако; пхир англа Ман тай ав би бэзэхахкиро. ");
INSERT INTO rmyservi_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Мэ стерава Муро завето машкар Ман тай туґа тай дава тути фартэ бут потомкуря. ");
INSERT INTO rmyservi_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Аврамо тэлэдыня муеґа тэлэ, тай Дэвэл пхэнда лэсти: ");
INSERT INTO rmyservi_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","— Муря ригатар, акэ Муро завето туґа: ту авэґа дадэґа бутэнди народэнди. ");
INSERT INTO rmyservi_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ту будэр на авэґа тэ акхарэпэ Аврамоґа: тиро лав авэла Авраамо, пала када со Мэ стерава тут дадэґа бутэнди народэнди. ");
INSERT INTO rmyservi_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Тутэ авэла фартэ бут чяворэ; тутар Мэ вылиджява народуря тай тутар вылиджява тхагарен. ");
INSERT INTO rmyservi_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Мэ стерава Муро завето машкар Ман тай туґа, и чяворэнца тирэнца пэ всаворэ бэрша, сар вечно завето: Мэ авава тирэґа Дэвлэґа тай Дэвлэґа тирэнди чяворэнди. ");
INSERT INTO rmyservi_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Всавори пхув Ханаано, тев ту екхатар авилян, Мэ терава тут хулаеґа пэ всаворэ бэрша, тут и тирэ чяворэн; тай авава Мэ лэнди Дэвлэґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Дэвэл пхэнда Авраамости: — Тирятар ригатар, ту авэґа тэ терэ кади, сар дэ Муро завето, ту, тай чяворэ тирэ, тай всаворэ лэндирэ родуря. ");
INSERT INTO rmyservi_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Акэ Муро завето туґа тай тирэнца чяворэнца дэ всаворэ родуря. Ту авэґа тэ терэ кади: кожно чяворо мэк авэла обчиндо. ");
INSERT INTO rmyservi_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Кожнонэсти трэбуни тэ терэ обчиндимо, када авэла заветохкирэґа знакоґа машкар Ман тай тумэнца. ");
INSERT INTO rmyservi_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Кожно тумаро чяворо дэ всаворэ родуря трэбуни тэ авэл обчиндо, кала лэсти авэла охто дивэ: тай кодэва, ко бэяндапэ дэ тиро цэр, тай кодэва, саво на тирэндар чяворэндар, ай савэн тиндэ пала ловэ манушэстар аврятар пхуятар. ");
INSERT INTO rmyservi_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Тай саво бэяндапэ дэ тиро цэр, тай савэн тиндэ пала ловэ, трэбуни тэ авэл обчиндо. Тай Муро завето пэ тумаро трупо авэла вечно. ");
INSERT INTO rmyservi_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Наобчиндо чяворо, савэстэ на сля обчиндимо, авэла вычюто пэхкирэндар манушэндар: вов розчинда Муро завето. ");
INSERT INTO rmyservi_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Инте Дэвэл пхэнда Авраамости: — А Сара, ромня тиря, ту будэр на авэґа тэ акхарэ ла Сара, латиро лав авэла Сарра. ");
INSERT INTO rmyservi_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Мэ бахталисарава ла тай дава тути латар чявэ. Мэ бахталисарава ла кади, со вой авэла дэй важ бут народуря, тай латар джяна тхагаря манушэндирэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Авраамо тэлиля ды пхув, ай дэ пэстэ розасаняпэ тай подумисарда: «Бэяндёлапэ чяво манушэстэ, савэсти шэл бэрш? Бэяндёла ли чяворэ Сарра, савяти инядэша бэрш?» ");
INSERT INTO rmyservi_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Вов пхэнда Дэвлэсти: — Мишто Измаило сля б джювдо тай бахталисардо Тутар! ");
INSERT INTO rmyservi_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Дэвэл пхэнда: — Тири ромни Сарра бэянэла тути чявэ, тай ту акхарэґа лэ Исаако. Мэ стерава Муро завето лэґа сар вечно завето важ лэхкирэ чяворэндэ дэ всаворэ родуря. ");
INSERT INTO rmyservi_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Тай пала Измаило Мэ ушундом тут. Мэ и лэ бахталисарава, тай лэстэ авэна фартэ бут чяворэ. Вов авэла дадэґа дэшудуенди барэдэрэнди тай Мэ терава лэстар бари порода. ");
INSERT INTO rmyservi_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Нэ Муро завето авэла Исаакоґа, савэ Сарра бэянэла тути пэ авэр бэрш дэ кадыя вряма. ");
INSERT INTO rmyservi_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Кала Дэвэл пэрэачиля тэ дэдумэ Авраамоґа, Вов подлиляпэ лэстар. ");
INSERT INTO rmyservi_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Дэ кодэва жэ диво Авраамо лиля пэхкирэ чявэ Измаило тай всаворэн, ко сля бэяндо дэ лэхкиро цэр, ко сля тиндо пала ловэ, тай всаворэн муршэн дэ цэр, тай обчинда лэн, сар пхэнда лэсти Дэвэл. ");
INSERT INTO rmyservi_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Авраамости сля инядэша иня бэрша, кала вов сля обчиндо, ");
INSERT INTO rmyservi_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","ай лэхкирэ чявэсти Измаилости сля душутрин. ");
INSERT INTO rmyservi_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Авраамо тай лэхкиро чяво Измаило дуйджинэ сле обчиндэ дэ кодэва жэ диво. ");
INSERT INTO rmyservi_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Тай всаворэ мурша дэ Авраамохкиро цэр: тай кола, ко сля бэяндо дэ лэхкиро цэр, тай ко сля тиндо пала ловэ манушэстар аврятар пхуятар, — вса сле обчиндэ екхтханэ лэґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","РАЙ авиля Авраамостэ пашэ вэша Мамре, кала вов бэшля англа пэхкири катуна, дэ вряма, кала кхам фартэ татярэлас. ");
INSERT INTO rmyservi_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Авраамо подлиля якха тай удыкхля, со надур ачен трин мануша. Кала удыкхля лэн, вов прастыня катунатар лэндэ тай тэлиля лэнди дэ пхуятэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Вов пхэнда: — Хулай, сар мэ аракхлём мила дэ тирэн якхэн, на проджя ман, тирэ копыле. ");
INSERT INTO rmyservi_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Мэк анэна набут пани, соб тумэнди тэ выхалавэ пурэ. Отцынявэн тала кадыя рандь, ");
INSERT INTO rmyservi_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","нэ мэ анава тумэнди сось тэ пэрэхаха. Тумэ лэна зор тай джяна дурэдэр — кала тумэ екхатар авиле тумарэстэ копылестэ. — Мишто, — пхэндэ вонэ. — Тер, сар пхэнэх. ");
INSERT INTO rmyservi_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Авраамо прастэня дэ катуна Сарратэ тай пхэнда: — Сигидэр, дорос трин чярэ варо, саво фэдэр, стер хумэр тай спэк мандро. ");
INSERT INTO rmyservi_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Вов прастэня ґуртостэ, вылиля райканэ лачёрэ гуруворэ тай отдэня копылести, саво фартэ сиго тавда лэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Тунчи Авраамо анда тирял, тхуд тай тавдо гурувано мас тай тховда англа лэн. Сар вонэ хале, вов ачелас паша лэн тала рандь. ");
INSERT INTO rmyservi_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","— Тев тири ромни Сарра? — пхучле вонэ. — Котэ, дэ катуна, — пхэнда вов. ");
INSERT INTO rmyservi_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Тунчи мурш пхэнда: — Мэ чяче рисявава тутэ пэ авэр бэршэ, дэ кадыя жэ вряма, тай Сарратэ, тирятэ ромнятэ, авэла чяво. Сарра шунэлас, кала ачелас лэстэ пала думэ, дэ катуна пашэ удара. ");
INSERT INTO rmyservi_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Авраамо тай Сарра сле пуранэ дэ бэршэн, тай када со исин джювлендэ, Сарратэ пэрэачиля. ");
INSERT INTO rmyservi_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Пала када Сарра розасаняпэ дэ пэ, подумисарда: «Мэ пурани, тай хулай муро пурано. Мандэ авэла кацави лош?» ");
INSERT INTO rmyservi_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Тунчи РАЙ пхэнда Авраамости: — Сости Сарра асалпэ тай пхэнэл: «Чи чяче мандэ авэла чяворо? Мэ жэ пхури!» ");
INSERT INTO rmyservi_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Исин со фартэ пхаро важ РАЕСТИ? Мэ рисявава тутэ пэ авэр бэрш дэ кадыя жэ вряма, тай Сарратэ авэла чяво. ");
INSERT INTO rmyservi_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Сарра пэрэдарыняпэ тай ачиля тэ отпхэнэпэ: — Мэ на асанёмпэ. Ай Вов пхэнда: — Нат, ту асанянпэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Мурша ваздынепэ тай джиле дэ риг Содомохкири. Авраамо жэ джиля лэнца, соб тэ пролиджя лэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","РАЙ подумисарда: «Гаравава ли Мэ Авраамостар кода, со камав тэ терэ? ");
INSERT INTO rmyservi_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Авраамостар чяче джяна баро тай зорало народо, тай всаворэ мануша пэ пхув авэна бахталисардэ лэстар. ");
INSERT INTO rmyservi_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Мэ жэ вытидэнём лэ, соб вов тэ прыпхэнэл пэхкирэнди чяворэнди тай всаворэсти пэхкирэ родости тэ пхирэ пав РАЕХКИРЭН дромэн чячимаґа тай пативаґа. Тунчи Мэ, РАЙ, стерава кода, со Мэ пхэнда Авраамости». ");
INSERT INTO rmyservi_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","РАЙ пхэнда: — Дэ Содомо тай Гомора шунэлпэ баро типисявимо, мануша котэ терэн бут бэзэх. ");
INSERT INTO rmyservi_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Мэ сджява тай подыкхава, чячюно ли типисявимо, саво доджиля Мандэ, кади ли намишто вонэ терэн. Мэ уджянава, када кади чи нат. ");
INSERT INTO rmyservi_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Мурша порисиле тай джиле Содомостэ, ай РАЙ ачиляпэ тэ аче англа Авраамо. ");
INSERT INTO rmyservi_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Авраамо поджиля пашэдэр Лэстэ тай пхэнда: — Со, чяче, Ту умарэґа чячюнэ манушэ екхтханэ бэзэхалэґа? ");
INSERT INTO rmyservi_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Со, сар дэ форо исин панчдэша чячютнэ? Ту всаекх умарэґа тай на дэґа Тири мила калэсти тханэсти важ панчдэша чячютнэ? ");
INSERT INTO rmyservi_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","На авэґа Ту тэ терэ кацаво — тэ умарэ чячюнэ ектханэ бэзэхалэґа кади ж. На авэґа Ту кади тэ терэ! Со ж Сундисари всаворя люмлятиро авэла ли тэ терэ хохавимо? ");
INSERT INTO rmyservi_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","РАЙ пхэнда: — Сар Мэ аракхава дэ Содомо панчдэша чячютнэн, то пала лэн сикавава Мури мила пэ всаворо кодэва тхан. ");
INSERT INTO rmyservi_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Тунчи Авраамо пхэнда инте: — Акэ, мэ исин прахо тай пепло, ай мэ би даратиро ачилём тэ дэдумэ Хулаеґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Со, сар дэ панчдэша чячютнэн на хутилэла панч ? Умарэґа Ту всаворо форо пала када, со на хутилэл панч манушэн? — Сар Мэ аракхава котэ саранда панч, — пхэнда Вов, — на умарава лэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Авраамо пхэнда Лэсти инте екхвар : — Со, сар котэ аракхэнапэ кацик саранда? Вов пхэнда: — Пала саранда Мэ на терава када. ");
INSERT INTO rmyservi_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Тунчи Авраамо пхэнда: — На холявэл, Хулай, ай дэла манди тэ пхэнэ. Со, сар аракхэнапэ котэ кацик трянда? Вов пхэнда: — Мэ на терава када, сар аракхава котэ трянда. ");
INSERT INTO rmyservi_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Авраамо пхэнда: — Акэ, мэ инте камав тэ пхучяв Тутар, Хулай. Со, сар аракхэнапэ котэ кацик биш? Вов пхэнда: — Пала биш Мэ на умарава лэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Тунчи Авраамо пхэнда: — Тэ на холявэл Хулай, ай дэла манди тэ пхэнэ инте екхвар. Со, сар аракхэнапэ котэ кацик дэш? Вов пхэнда: — Пала дэш Мэ на умарава лэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","РАЙ пэрэачиля тэ дэдумэ Авраамоґа тай уджиля, ай Авраамо рисиля цэрэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Дуй ангелуря авиле дэ Содомо бельвеляґа, тай Лото бэшэлас пашэ удара форохкирэ. Кала удыкхля лэн, вов вщиля тай тэлиля дэ пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","— Хулая мурэ, — пхэнда вов, — мангав тумэн, заджян дэ цэр тумарэстэ копылёстэ. Тумэ халавэна пурэ тай ратярэна мандэ, ай дэнзор джяна дурэдэр. — Нат, — пхэндэ вонэ, — амэ ратяраґа пэ гаса. ");
INSERT INTO rmyservi_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Нэ вов кади мангэлас, со вонэ джиле пала лэ тай заджиле дэ цэр. Вов тавда важ лэн хамо, пэкля присно мандро, тай вонэ хале. ");
INSERT INTO rmyservi_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ай дыкалэ, сар вонэ пыле, всаворэ мурша Содомостар, тэрнэ тай пхурэ, лиле цэр дэ бэльчюґо. ");
INSERT INTO rmyservi_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Вонэ типисиле Лотости: — Тев мануша, савэ авиле тутэ бэльвеляґа? Вылиджя лэн амэндэ, амэ камах тэ пэрэсовах лэнцар. ");
INSERT INTO rmyservi_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Лото выджиля лэндэ тай затерда пала пэ удара. ");
INSERT INTO rmyservi_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Вов пхэнда: — Нат, амала мурэ, на терэн кацаво налачимо. ");
INSERT INTO rmyservi_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Пошунэн, мандэ исин дуй чея, савэ инте на сле муршэґа. Камэн, мэ вылиджява лэн тумэндэ, терэн лэнца, со камэн. Ай на терэн нисо кадэлэнди манушэнди, савэ авиле дэ муро цэр. ");
INSERT INTO rmyservi_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Вонэ пхэндэ: — Наш дромэстар! Тай пхэндэ: — Кадыва мануш, авиля амэндэ авря пхуятар, ай кана камэл тэ авэ амэнди сундимареґа! Амэ тераґа туґа инте врытэдэр! Вонэ ачиле тэ вытрадэ Лото тай поджиле, соб тэ выпхагэ удара. ");
INSERT INTO rmyservi_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Нэ мурша, савэ аченаспэ дэ цэр, процырдэне васта, зацырдэне Лото дэ цэр тай затердэ удара. ");
INSERT INTO rmyservi_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","А колэн, ко сле пашэ цэр, тэрнэн тай пхурэн, вонэ тердэ корэнца , кади со вонэ на аракхэнас удара. ");
INSERT INTO rmyservi_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Кала мурша пхэндэ Лотости: — Ко инте тутэ катэ исин — джямутрэ, чявэ, чея, ко исин инте дэ форо? Вылиджя лэн катар, ");
INSERT INTO rmyservi_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","пала када со амэ стидахпэ тэ умарэ кадыва тхан. Типисявимо РАЕСТЭ пэ кала мануша кацаво зорало, со Вов бичялда амэн тэ умарэ лэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Лото выджиля тай пхэнда дуенди манушэнди, савэ камле тэ лэ пала пэстэ лэхкирэн чеен: — Сигидэр, уджян катар! РАЙ стидэлпэ тэ спхабарэ форо! Ай кодэла думисардэ, со вов терэл пхиряс. ");
INSERT INTO rmyservi_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Англа када, сар кхам ущиля, ангелуря ачиле тэ подтрадэ Лото, пхэнэнас: — Сигидэра! Улиджя катар пэхкиря ромня тай дуен чеен, ай нат, ту мэрэґа, кала мэримо пэрэла пэ форо. ");
INSERT INTO rmyservi_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Вов стидэласпэ насиго, ай кодыла дуй лиле лэ пала васт, тай лэхкиря ромня, тай дуен чеен, пала када со РАЙ сикавда лэнди мила, тай вылиджялдэ лэн пала форо. ");
INSERT INTO rmyservi_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Кала вонэ сле пала форо, екх лэндар пхэнда: — Наш катар! На дыкх павпалэ тай на ачь ни тев дэ маля! Наш дэ плая, ай сар на кади — ту мэрэґа! ");
INSERT INTO rmyservi_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Ай Лото пхэнда лэнди: — Нат, Хулай! ");
INSERT INTO rmyservi_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Копыли тиро аракхля дэ Тирэн якхэн лачимо. Ту сикавдан манди бари мила, кала фирисарэґас муро джювимо. Ай дэ плая мэ на допрастэва: глаба доросэла ман, тай мэ мэрава. ");
INSERT INTO rmyservi_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Акэ кодэва форицы надур, пордэ мэ допрастэва, тай вов на баро. Дэ манди тэ нашэ пордэ— вов фартэ цыкно, на кади? — тай муро джювимо авэла фирисардо. ");
INSERT INTO rmyservi_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Вов пхэнда: — Мишто, Мэ терава и када, со мангэх: Мэ на спхабарава форо, пала савэ ту пхэнэх. ");
INSERT INTO rmyservi_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Наш пордэ сигидэр, пала када со Мэ нисо на авава тэ терэ, тунчи сар ту на допрастэґа дэ лэ. (Акэ сости кодэва форо сля акхардо Цоаро). ");
INSERT INTO rmyservi_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Кала Лото допрастэня дэ Цоаро, кхам ужэ вщиля. ");
INSERT INTO rmyservi_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Тунчи РАЙ прочюта брышындэґа пэ Содомо тай Гомора пхабарди сера. Вой авиля болыбнастар РАЕСТАР. ");
INSERT INTO rmyservi_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Вов спхабарда форуря тай всавори маля, тай всаворэн, ко джюда дэ форуря, тай вса, со барёлас пэ пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ай ромни Лотохкири обрисардапэ павпалэ тай тердапэ лондэґа столбоґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Пэ авэр дэнзор Авраамо подлиляпэ фартэ дэнзор тай рисардапэ колэстэ тханэстэ , тев вов ачелас англа РАЙ. ");
INSERT INTO rmyservi_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Вов подыкхля пэ Содомо, Гомора тай пэ всавори маля тай удыкхля: зорало тхув ваздэлпэ пхуятар, сар тхув боватар. ");
INSERT INTO rmyservi_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Кади, кала Дэвэл спхабарда форуря малендирэ, дэ савэн джюда Лото, Вов взрапирда Авраамо тай фирисарда Лото глабатар. ");
INSERT INTO rmyservi_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Лото даралас тэ ачепэ дэ Цоаро. Вов тай дуй лэхкирэ чея уджиле Цоаростар дэ плая. Пэхкирэнца дуенца чеенца вов ачиля тэ джювэ дэ пищера. ");
INSERT INTO rmyservi_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Пхурэдэр чей пхэнда цыкняти: — Амаро дад пурано, тай катэ нитев нинай муршэ, соб тэ пэрэл амэнца, сар терэлпэ пэ всавори пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Матяраґа дадэ, даґа лэсти мол тай пэраґа лэґа. Мэк и амарэстар дадэстар, нэ амэндэ авэна чяворэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Дэ кодыя рат вонэ дэне дадэсти мол тай матярдэ лэ, тай пхурэдэр чей заджиля тай пэля лэґа. Вов и на джянгля, кала вой пэля и кала вщиля. ");
INSERT INTO rmyservi_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Пэ авэр диво пхурэдэр чей пхэнда цыкняти: — Дэ рат, сави проджиля, мэ пэлём дадэґа. Упалэ даґа лэсти мол тай матяраґа авдивэ бельвеляґа, тай ту заджяґа тай пэрэґа лэґа.Мэк и амарэстар дадэстар, нэ амэндэ авэна чяворэ ");
INSERT INTO rmyservi_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Вонэ дэне мол тай матярдэ дадэ дэ кадыя рат, тай цыкнэдэр чей заджиля тай пэля лэґа. Вов и на джянгля, кала вой пэля и кала вщиля. ");
INSERT INTO rmyservi_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Кади дуй чея Лотохкирэ ачиле пхарэ дадэстар. ");
INSERT INTO rmyservi_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Пхурэдэр чей бэянда чявэ тай акхарда лэ Моаво; вов дад моавитянэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Цыкнэдэр чей кади ж бэянда чявэ тай акхарда лэ — Бен-Амми; вов дад аммонитянэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Котар Авраамо пэрэджиля дэ пхув Негево тай джювэлас машкар Кадешо тай Шуро. Вов савись вряма джювэлас дэ Гераро. ");
INSERT INTO rmyservi_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Котэ вов пхэнэлас всаворэнди, со Сарра сля лэхкири пхэнь. Авимелехо, тхагари Герарохкиро, бичялда пала Сарра тай лиля ла пэстэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ай ратяґа дэ сунэ Авимелехостэ авиля Дэвэл тай пхэнда лэсти: — Тутэ авэла мэримо пала джювли, савля ту лилян пэстэ: вой пала ром. ");
INSERT INTO rmyservi_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Нэ Авимелехо на лэласпэ латэ, тай пала када вов пхэнда: — Хулай, Ту жэ на умарэґа навуджило народо? ");
INSERT INTO rmyservi_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Вов жэ пхэнда манди, со вой лэхкири пхэнь, тай вой пхэнда, со вов латиро пхрал. Катэ мэ на тердом бэзэх на ды годи, на ды рындуря. ");
INSERT INTO rmyservi_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Дэвэл пхэнда лэсти дэ сунэ: — Чяче, Мэ джянав, со годи тири жужи: када Мэ урицардом тут бэзэхатар англа Мандэ, тай на дэнём тути тэ лэпэ латэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Кана рисар ромня ромэсти, пала када со вов — англунари. Вов помангэлапэ пала тут, тай ту ачеґапэ джювдо. Ай сар ту на рисарэґа ла, джян, со тути тай тирэсти родости тэ на унашэ мэриматар. ");
INSERT INTO rmyservi_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Пэ авэр диво дэнзор Авимелехо стидэня всаворэн пэхкирэн пашутнэн тай роспхэнда лэнди, со тердапэ, тай вонэ фартэ дарэне. ");
INSERT INTO rmyservi_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Тунчи Авимелехо акхарда Авраамо тай пхэнда: — Со ту амэнца тердан? Саво врытимо мэ тути тердом, со ту андан кацави пхари дош пэ ман тай пэ муро тхагаримо? Ту тердан манца кади, сар нащи тэ терэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Тай Авимелехо пхучля Авраамостар: — Со сля тутэ пэ годи, кала ту тердан кацаво? ");
INSERT INTO rmyservi_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Авраамо пхэнда: — Мэ подумисардом: « Дэ кадыва тхан, чяче, нинай дар Дэвлэхкиро, тай мануша умарэна ман пала муря ромня». ");
INSERT INTO rmyservi_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ай инте, вой чяче мури пхэнь, чей мурэ дадэсти, ай на муря датар. Вой ачиля муряґа ромняґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Кала Дэвэл бичялда ман мурэ дадэхкирэ цэрэстар тэ пхирэ пав пхув, мэ пхэндом лати: «Стер манди кацаво лачё рындо: тев бы амэ на авиле, пхэн пала ман, со мэ тиро пхрал. ");
INSERT INTO rmyservi_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Тунчи Авимелехо анда цыкно тай баро ското, копылен тай копыльницэн тай дэня лэн Авраамости. Вов инте рисарда лэсти лэхкиря ромня Сарра. ");
INSERT INTO rmyservi_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Авимелехо пхэнда: — Мури пхув англа тутэ: джюв, тев камэх. ");
INSERT INTO rmyservi_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Саррати вов пхэнда: — Мэ дэнём тирэсти пхралэсти пхангли шэкели рупь, соб тэ ушаравэ тири холи дэ якхэн всаворэн, ко дэ тиро цэр. Тири патив кана упалэ жужи. ");
INSERT INTO rmyservi_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Авраамо помангляпэ Дэвлэсти, тай Дэвэл састярда Авимелехо, лэхкиря ромня тай копыльницэн, тай вонэ упалэ ачиле тэ бэянэ чяворэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Ай дыкалэ РАЙ на дэлас ни екх джювляти дэ Авимелехохкиро цэр тэ бэянэ, пала када со Авимелехо лиля пэсти Сарра, Авраамохкиря ромня. ");
INSERT INTO rmyservi_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Сар Вов и пхэнда, РАЙ сикавда мила Саррати тай срицарда Пэхкиро лав. ");
INSERT INTO rmyservi_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Кала Авраамо ужэ ачиля пурано, Сарра ачиля пхари тай бэянда лэсти чявэ, дэ кодыя вряма, сар пхэнда Дэвэл. ");
INSERT INTO rmyservi_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Авраамо дэня чяворэсти, савэ бэянда лэсти Сарра, лав Исаако. ");
INSERT INTO rmyservi_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Кала лэхкирэсти чявэсти Исаакости ачиля охто дивэ, Авраамо обчинда лэ, сар прыпхэнда лэсти Дэвэл. ");
INSERT INTO rmyservi_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Авраамости сля шэл бэрш, кала лэстэ бэяндапэ чяво Исаако. ");
INSERT INTO rmyservi_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Сарра пхэнда: — Дэвэл заачявда ман тэ асапэ. Кожно, ко ушунэла пала када, розасалапэ екхтханэ манца. ");
INSERT INTO rmyservi_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","— Тай допхэнда: — Ко б пхэнда Авраамости, со Сарра авэла тэ парварэ колинаґа? Ай мэ бэяндом лэсти чявэ дэ лэхкиро пхуранимо. ");
INSERT INTO rmyservi_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Чяворо выбариля тай сля отлито колинатар. Дэ кадыва диво, кала Исаако сля отлито колинатар, Авраамо стерда баро сэрбатори. ");
INSERT INTO rmyservi_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Сарра удыкхля, со чяво, савэ бэянда Авраамости Агарь Египтостар, подасалпэ Исаакостар, ");
INSERT INTO rmyservi_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","тай пхэнда Авраамости: — Вытрадэ кадыла копыльница тай латирэ чявэ, пала када со чяво кадылатиро копыльницатиро на лэла амаро хулаемо екхтханэ мурэґа чявэґа Исаакоґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Авраамо сля фартэ холямо, пала кода со и кадыва сля лэхкиро чяво. ");
INSERT INTO rmyservi_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ай Дэвэл пхэнда лэсти: — На холяв пала чяворэ тай копыльницатэ. Пошунпэ Сарра тай стер вса, сар вой пхэнэл, пала када со порода тутэ джяла Исаакостар. ");
INSERT INTO rmyservi_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ай чявэстар копыльницатирэстар Мэ стерава инте народо, пала када со вов тиро чяво. ");
INSERT INTO rmyservi_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Пэ аврэ дивэ фартэ дэнзор Авраамо лиля хамо, пани дэ бурдюко тай дэня Агаряти: тховда лати пэ пхикэн тай отбичялда котар ла тай чяворэ. Вой джиля тай пхирэлас пав шуки пхув Вирсавия. ");
INSERT INTO rmyservi_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Кала пани дэ бурдюко на ачиля, вой ачявда чяворэ тала рандёры, ");
INSERT INTO rmyservi_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","отджиля надур тай прэбэшля пэ дром, сар урял стрела лукостар. Вой думисарэлас: «На авава тэ дыкхэ, сар чяворо мэрэл». Кала вой бэшэлас котэ, розровиняпэ фартэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Дэвэл ушунда чяворэхкиро ровимо, тай Дэвлэхкиро ангело ачиля тэ дэдумэ болыбнатар Агарятэ: — Со туґа, Агарь? На дар, Дэвэл ушунда, сар ровэл чяворо котэ, тев вов пашлёл. ");
INSERT INTO rmyservi_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Вщи, ваздэ лэ, лэ чяворэ пала вастэ. Мэ вылиджява лэстар баро народо. ");
INSERT INTO rmyservi_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Дэвэл оттерда лати якха, тай вой удыкхля ханинг панеґа. Вой джиля, пхэрдиля бурдюко панеґа тай дэня тэ пэ чяворэсти. ");
INSERT INTO rmyservi_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Дэвэл сля чяворэґа. Измаило выбариля тай ачиля тэ джювэ дэ шуки пхув. Вов фартэ мишто марэлас лукостар. ");
INSERT INTO rmyservi_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Вов джюда дэ шуки пхув Парано, тай дэй лиля важ лэсти ромня Египтостар. ");
INSERT INTO rmyservi_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Дэ кодыя вряма Авимелехо тай Фихоло, барэдэр рай дэ лэхкирэ войско, пхэндэ Авраамости: — Дэвэл туґа дэ вса, со ту терэх. ");
INSERT INTO rmyservi_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Дэ солах манди катэ англа Дэвлэ, со ту на хохавэґа ни ман, ни мурэн чяворэн, ни мурэн потомконэн. Стер манди тай пхуяти, дэ сави ту екхатар джювэх, кодыя жэ мила, сави мэ стердом тути. ");
INSERT INTO rmyservi_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Авраамо пхэнда: — Дав солах. ");
INSERT INTO rmyservi_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Тунчи Авраамо выпхэнда Авимелехости пала ханинг панеґа, саво копыли Авимелехохкирэ лиле зораґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Ай Авимелехо пхэнда: — Мэ на джянав, ко када стерда. Ту на дэдуманян, и дыкалэ мэ на шундом пала када. ");
INSERT INTO rmyservi_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Авраамо анда цыкно тай баро ското, дэня лэн Авимелехости, тай вонэ стердэ екх екхэґа допхэнимо. ");
INSERT INTO rmyservi_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Авраамо отлиля гуртостар ефта тэрнэн бакрорэн, ");
INSERT INTO rmyservi_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","тай Авимелехо пхучля Авраамостар: — Со када за ефта тэрнэ бакрорэн, савэн ту отлилян? ");
INSERT INTO rmyservi_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Авраамо пхэнда: — Прылэ мандар ефта кадылэн тэрнэн бакрорэн дэ знако, со мэ выґанавдом кадыва ханинг тай со вов муро. ");
INSERT INTO rmyservi_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Авраамо акхарда кодэва тхан Вирсавия, пала кода со вонэ дуйджинэ дэне котэ солах. ");
INSERT INTO rmyservi_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Тунчи сар вонэ допхэндэпэ дэ Вирсавия, Авимелехо тай Фихоло, барэдэр рай дэ лэхкирэ войско, рисардэпэ дэ пхув филистимлянэндири. ");
INSERT INTO rmyservi_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Дэ Вирсавия Авраамо чюта дэ пхув рандь-тамариско тай прыакхарда котэ лав РАЕХКИРО, Дэвлэхкиро Вечнонэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Авраамо джюда пэ филистимско пхув бут вряма. ");
INSERT INTO rmyservi_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Проджиля савись вряма, тай Дэвэл закамля тэ уджянэ чячюно патямо Авраамохкиро. Вов пхэнда лэсти: — Авраамо. — Мэ катэ, — пхэнда Авраамо. ");
INSERT INTO rmyservi_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Дэвэл пхэнда: — Лэ чявэ, екхорэ пэхкирэ чявэ Исаако, савэ ту камэх, джя дэ пхув Мория тай ан лэ котэ дэ жэртва тай спхабар ла дэ яг пэ плай, сави Мэ сикавава тути. ");
INSERT INTO rmyservi_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Пэ авэр диво дэнзор Авраамо вщиля, залытярда магаре, лиля пэґа дуен копылен тай чявэ Исаако, починда кашта важ жэртва тай джиля дэ дром дэ кодэва тхан, пала савэ пхэнда лэсти Дэвэл. ");
INSERT INTO rmyservi_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Пэ трито диво Авраамо ваздэня якха тай удыкхля дурал кодэва тхан. ");
INSERT INTO rmyservi_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Вов пхэнда копыленди: — Аченпэ катэ магареґа, ай амэ чяворэґа джяґа пордэ стераґа тэлисаримо, ай тунчи рисяваґа тумэндэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Авраамо лиля кашта важ жэртва тай тховда лэн пэ думо Исаакости, ай екджино лиджялда яг тай чюри, тай вонэ дуйджинэ джиле дэ дром. ");
INSERT INTO rmyservi_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Исаако пхэнда пэхкирэсти дадэсти Авраамости: — Дадэ! — Нэ, муро чяво? — пхэнда Авраамо. — Амэндэ исин яг тай кашта, — пхэнда Исаако, — ай тев жэ бакроро важ жэртва? ");
INSERT INTO rmyservi_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Авраамо пхэнда: — Дэвэл Екджино удыкхэла бакрорэ важ жэртва, чяво муро. Тай вонэ дуйджинэ джиле дурэдэр. ");
INSERT INTO rmyservi_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Кала вонэ доджиле дэ тхан, пала савэ пхэнда лэсти Дэвэл, Авраамо стерда котэ жэртвенико тай стховда пэ лэстэ кашта, спхангля пэхкирэ чявэ Исаако тай тховда лэ пэ жэртвенико пэ кашта. ");
INSERT INTO rmyservi_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Вов процырдэня васт тай лиля чюри, соб тэ умарэ чявэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ай Ангело РАЕХКИРО прохпэнда лэсти болыбнастар: — Авраамо! Авраамо! — Мэ катэ, — пхэнда вов. ");
INSERT INTO rmyservi_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","— На ваздэ васт пэ чяворэ, — пхэнда Вов, — на тер лэґа нисо. Кана Мэ джянав, со ту дарахпэ Дэвлэ, пала када со тути на дор важ Манди чявэ, екхорэ пэхкирэ чявэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Авраамо ваздэня якха тай удыкхля бакрэ, саво шынгэнца амгладёлас пала ранден. Вов джиля, лиля бакрэ, анда лэ дэ жэртва тай спхабарда пэ яг пала чявэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Авраамо акхарда кодэва тхан «Яхве-Ирэ», тай пала кода и екхатар пхэнэлпэ: «Пэ РАЕХКИРО плай удыкхэлапэ». ");
INSERT INTO rmyservi_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Ангело РАЕХКИРО пропхэнда Авраамостэ болыбнастар дэ дуйто моло ");
INSERT INTO rmyservi_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","тай пхэнда: — Мэ, РАЙ, солохав Екджинэґа Пэґа: сар ту стердан када тай тути на сля дор важ Манди пэхкирэ екхорэ чявэ, ");
INSERT INTO rmyservi_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","чяче Мэ бахталисарава тут тай стерава, со тирэн чяворэн авэла фартэ бут, сар чергэня дэ болыбэн, сар тишай пэ морско брэга. Тирэ чяворэ залэна форуря пэхкирэн врыжымашэн, ");
INSERT INTO rmyservi_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","тай тутар авэна бахталисардэ всаворэ народуря пэ пхув, пала када со ту поканглян Ман. ");
INSERT INTO rmyservi_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Авраамо рисардапэ копылендэ, тай вонэ ектханэ джиле дэ Вирсавия. Авраамо ачиляпэ дэ Вирсавия. ");
INSERT INTO rmyservi_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Проджиля вряма, тай Авраамости пхэндэ: — Кана и Милка— дэй, вой бэянда чявэн тирэсти пхралэсти Нахорости: ");
INSERT INTO rmyservi_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Уцо, первонэ, Бузо, лэхкирэ пхралэ, Кемуило (Арамохкирэ дадэ), ");
INSERT INTO rmyservi_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Кеседо, Хазо, Пилдашо, Идлафо тай Бетуило. ");
INSERT INTO rmyservi_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Бетуило ачиля дадэґа Ревекатиряти. Милка бэянда охто кадэлэн чявэн Нахорости, Авраамохкирэ пхралэсти. ");
INSERT INTO rmyservi_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Лэхкири наложница, савя акхарэнас Реума, кади ж бэянда лэсти чявэн: Тевахо, Гахамо, Тахашо тай Мааха. ");
INSERT INTO rmyservi_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Сарра проджюда 127 бэрш — када скацик всаворо джювимо Сарратиро. ");
INSERT INTO rmyservi_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Вой муля дэ Кирьят-Арба (када исин Хевроно), дэ пхув Ханаано, тай Авраамо авиля тэ ровэ пала Сарра. ");
INSERT INTO rmyservi_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Тунчи Авраамо отджиля ромнятар, сави муля, тай пхэнда хеттеендэ: ");
INSERT INTO rmyservi_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","— Мэ авилём кордэ авря пхуятар тэ джювэ машкар тумэн авря пхуятар. Битинэнти манди котор пхув, соб мэ тэ гаравав муля. ");
INSERT INTO rmyservi_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Хеттея пхэнэн Авраамости: ");
INSERT INTO rmyservi_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","— Рай, ашун, ту — зорало баро мануш помашкар амэн. Гарав муля дэ амаро само фэдэр тхан важ када. Нико амэндар на отпхэнэла тути кацавэґа тханэґа, соб тэ гаравэ тиря муля. ");
INSERT INTO rmyservi_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Тунчи Авраамо вщиля тай тэлиля хеттеенди, манушэнди кодылатар пхуятар. ");
INSERT INTO rmyservi_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Вов пхэнда лэнди: — Сар тумэ камэн када, соб мэ тэ гаравав муля, пошунэн ман тай помангэн пала ман Эфроно, Цохарохкирэ чявэ, ");
INSERT INTO rmyservi_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","соб вов тэ битинэл манди пищера Махпела, сави исин лэхкири тай ачел пэ бряго пэ лэхкири маля. Мэк битинэла ла манди пала бари цымин рупь, сар тхан важ соб тэ гарава помашкар тумэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Хеттеё Эфроно бэшля помашкар пэхкирэ мануша тай пхэнэл Авраамости англа всаворэ хеттеен, савэ авиле форохкиронэндирэ удара. ");
INSERT INTO rmyservi_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Вов пхэнда: — Нат, муро рай, пошун ман. Мэ отдав тути маля тай отдав тути пищера, сави пэ кая маля. Мэ отдав тути када англа мурэ мануша. Гарав пэхкиря муля. ");
INSERT INTO rmyservi_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Авраамо упалэ тэлиля манушэнди кодылатар пхуятар ");
INSERT INTO rmyservi_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","тай пхэнда Эфроности англа лэн: — Вышун жэ ту ман. Мэ дава рупь пала маля. Прылэ ла мандар, соб манди тэ гаравэ котэ муля. ");
INSERT INTO rmyservi_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Эфроно пхэнда Авраамости: ");
INSERT INTO rmyservi_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","— Пошун ман, рай муро: пхув кодыя ачел штар шэла шэкеля рупь. Када со бут важ тути чи важ манди? Гарав пэхкиря муля. ");
INSERT INTO rmyservi_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Авраамо допхэндапэ Эфроноґа тай дэня лэсти малятири цымин, сави вов пхэнда англа хеттея: штар шэла шэкеля рупь, сар бинэн битинимари. ");
INSERT INTO rmyservi_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Кади маля Эфронохкири дэ Махпела пашэ Мамреґа, маля тай пищера, тай всаворэ рандя пав бэрги малятирэ ачиле ");
INSERT INTO rmyservi_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Авраамохкирэ англа всаворэн хеттеен, савэ авиле дэ форохкирэн ударэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Пала када Авраамо гаравда пэхкиря ромня Сарра дэ пищера пэ маля Махпела пашэ Мамреґа (со дэ Хевроно), дэ пхув Ханаано. ");
INSERT INTO rmyservi_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Маля тай пищера пэ лэстэ пэрэджиля хеттеендар Авраамости, сар тхан, тев тэ гаравэ мулэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Авраамо ачиля пурано, лэсти сля бут бэрш, тай РАЙ бахтисарда лэ дэ вса. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Авраамо пхэнда пхурэдэрэсти копылести дэ пэхкоро цэр, саво дыкхэлас пала вса, со лэстэ сля: — Тхов васт манди тала пашварэ ");
INSERT INTO rmyservi_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","тай солаха манди РАЕҐА, Саво исин Дэвэл болыбнахкиро тай Дэвэл пхуятиро, со ту на лэґа мурэсти чявэсти ромня чеендар ханаанеендирэн, машкар савэн мэ джював, ");
INSERT INTO rmyservi_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","ай джяґа дэ пхув, тев мэ бэяндомпэ, мурэндэ родонэндэ, тай котэ лэґа ромня мурэсти чявэсти Исаакости. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Копыли пхучля лэстар: — Со, сар кодыя джювли на закамэла тэ джя манца кордэ, дэ кадыя пхув? Со манди тунчи тэ терэ, тэ рисарэ тирэ чявэ дэ кодыя пхув, савятар ту авилян? ");
INSERT INTO rmyservi_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Авраамо пхэнэл: — Нисар тай никала на рисар пордэ мурэ чявэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","РАЙ, Дэвэл болыбнахкиро, Саво вылиджялда ман дадэхкирэ цэрэстар тай мурятар пхуятар, Саво дэдуманя манца тай дэня солах манди, кала пхэнда: «Мэ отдава кадыя пхув тирэнди чяворэнди», Вов бичялэла Пэхкирэ ангело англа тут, соб ту тэ лэх котар ромня мурэсти чявэсти. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Сар джювли на закамэла тэ джя туґа, ту авэґа викалавдо калатар солахатар. Кацик на рисар пордэ мурэ чявэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Копыли тховда васт тала паршавэ Авраамости, пэхкирэсти раести, тай дэня солах лэсти. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Тунчи копыли лиля деш верблюдонэн пэхкирэ раехкирэн, пхэрдиля лэн фэдэрэнца подарконэнца лэстар тай джиля дэ дром. Вов джиля дэ Арамо-Нахараимо, рицарда дром форостэ, тев джюда Нахоро. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Вов тэлисарда верблюдонэн пэ чянгэн паша ханинг пала форо; када сля тала бельвель, кала джювля авэн пала пани. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Вов пхэнда: — РАЕ, Дэвэл мурэ раехкиро Авраамо! Дэ манди авдивэ бахтисаримо тай сикав мила мурэсти раести Авраамости. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Акэ, мэ ачяв пашэ ханинг, тай чея форохкирэ джян пала пани. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Мэк авэла кади. Сар мэ пхэнава чяти: « Мангав тут, обмук кхоро пхикэстар, соб манди тэ пэ пани», ай вой пхэнэла: «Пи, тай мэ дава пани тирэнди верблюдонэнди», када вой авэла, савя Ту вылилян важ тирэсти копылёсти Исаакости. Кади мэ уджянава, со Ту дэх мила мурэсти раести. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Инте вов на пэрэачиля тэ мангэпэ, сар ханингэстэ выджиля Ревека кхорэґа пэ пхико, чей Бетуилохкири, саво сля чявэґа Милкатиро, сави сля ромняґа Нахорости, Авраамохкирэ пхралэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Вой сля фартэ шукарни чей, чеёры, сави на сля инте муршэґа. Вой смукляпэ ханингастэ, пхэрдиля кхоро тай джиля павпалэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Копыли подпрастэня латэ тай пхэнэл: — Мангав тут, дэ манди набут пани тирэстар кхорэстар. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","— Пи, муро рай, — пхэнда вой, сиго смукхля кхоро пэ вастэн, дэня лэсти тэ пэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Кала вов пиля скацик лэсти трэбуни, вой пхэнда: — Мэ доросава пани и тирэнди верблюдонэнди, скацик вонэ авэна тэ пэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Вой сиго вычюта пани кхорэстар дэ балани, прастэня упалэ ханингастэ тэ лэ инте пани тай доросля пани всаворэнди лэхкирэнди верблюдонэнди. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Копыли ачелас мулком тай дыкхля пэ ла, вов камэлас тэ полэ, дэня ли РАЙ лэсти бахт. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Кала верблюдуря пэрэачиле тэ пэ, вов вылиля сувнакуни чень важ накх, пхаримаґа дэ бека, тай дуй сувнакунэ ланчюги пэ васта, пхаримаґа дэ дэш шэкеля, ");
INSERT INTO rmyservi_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","тай пхучля: — Пхэн манди, кахкири ту чей? Исин тирэстэ дадэстэ дэ цэр тхан, соб амэнди тэ ратярэ? ");
INSERT INTO rmyservi_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Вой пхэнда лэсти: — Мэ чей Бетуилохкири, вов исин чяво Милкатиро, савэ вой бэянда Нахорости. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Тай инте допхэнда: — Амэндэ исин бут сулум тай ворзо, тай исин тхан, тев тэ ратярэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Тунчи Авраамохкиро копыли тэлиля тай ашарда РАЕ, ");
INSERT INTO rmyservi_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","пхэнда: — Ашарав РАЕ, Дэвлэ мурэ раехкиро Авраамохкирэ, Саво на ачявда би Пэхкири мила тай чячима мурэ рае, пала када со РАЙ анда ман дэ цэр родостэ мурэ раехкирэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Чей прастэня дэ цэр тай роспхэнда пала вса пэхкиряти дати. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Ревекатэ сля пхрал, лэ акхарэнас Лавано, тай вов сиго джиля колэстэ манушэстэ, саво сля пашэ ханинг. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Кацик вов удыкхля чень важ накх тай ланчюги пэ вастэн пхэнятэ тай ушунда роспхэндимо Ревекатиро пала кода, со пхэнда лати кодэва мануш, вов джиля лэстэ, ай кодэва кади и ачелас верблюдонэнца пашэ ханинг. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","— Джям амэндэ, бахталисардо РАЕҐА, — пхэнда Лавано. — Сости ту ачех пэ гаса? Мэ чютом цэр важ тути тай тхан верблюдонэнди. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Копыли заджиля дэ цэр, тай верблюдонэндар слиле пхаримо. Лэнди андэ сулум тай ворзо, ай лэсти и лэхкирэнди манушэнди андэ пани, соб тэ выхалавэ пурэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Англа лэстэ тховдэ хамо, нэ вов пхэнда: — Мэ на авава тэ ха, кала на роспхэнава пала муро рындо. — Роспхэн, — пхэнда Лавано. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Вов пхэнда: — Мэ — Авраамохкиро копыли. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","РАЙ фартэ мишто бахталисарда мурэ рае, вов ачиля барвало. Вов дэня лэсти бузнен, бакрэн тай гурувнен, рупь тай сувнак, копылен тай копыльницэн, верблюдонэн тай магарен. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Мурэ раехкири ромни Сарра бэянда лэсти чявэ дэ пхурима, тай вов отдэня чявэсти вса, со лэстэ сля. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Муро рай прэпхэнда манди тэ дэ солах тай пхэнда: «На лэ ромня мурэсти чявэсти чеендар ханаанеендирэн, дэ кахкири пхув мэ джював, ");
INSERT INTO rmyservi_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","ай джя їрятэ мурэ дадэхкирэ, мурэстэ родостэ, тай котар лэ ромня мурэсти чявэсти». ");
INSERT INTO rmyservi_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Мэ пхучлём мурэ раестар: «Со, сар кодыя джювли на джяла манца?» ");
INSERT INTO rmyservi_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Вов пхэнда: «РАЙ, англа Кастэ мэ пхирав, бичялэла туґа Пэхкоро ангело тай дэла тути бахт пала со ту и джях, соб ту тэ лэх ромня мурэсти чявэсти мурэстар родостар тай дадэхкирятар їрятар. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Кацик тунчи ту авэґа викалавдо кадылатар солахатар, кала поавэґа дэ цэр мурэ дадэхкирэ, тай сар вонэ отпхэнэна тути тэ отдэ ла, тунчи ту авэґа викалавдо солахатар». ");
INSERT INTO rmyservi_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Кала мэ авдивэ авилём ханингатэ, мэ пхэндом: «О, РАЁ, Дэвэл мурэ раехкиро Авраамохкиро, кацик бы Ту тэ дэх бахт колэсти, пала со мэ бичялдо кордэ! ");
INSERT INTO rmyservi_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Акэ, мэ ачяв паша ханинг: сар чей выджяла тэ доросэ пани, тай мэ пхэнава лати: «Мангав тут, дэ манди тэ пэ пани тирэстар кхорэстар», ");
INSERT INTO rmyservi_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","тай сар вой пхэнэла манди: «Пи, тай мэ доросава пани и тирэнди верблюдонэнди», акэ, када вой, савя РАЙ вылиля чявэсти мурэ раести». ");
INSERT INTO rmyservi_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Инте мэ на пэрэачилём тэ мангэпэ дэ пэхкоро їло, сар выджиля Ревека кхорэґа пэ пхико. Вой смукляпэ ханингатэ тай доросля пани, тай мэ пхэндом лати: «Мангав тут, дэ манди тэ пэ пани». ");
INSERT INTO rmyservi_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Вой сиго обмукля кхоро пхикэстар тай пхэнда: «Пи, ай мэ дава пани и тирэнди верблюдонэнди». Мэ пилём пани, тай вой дэня тэ пэ верблюдонэнди. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Мэ пхучлём латар: «Кахкири ту чей?» Вой пхэнда: «Мэ чей Бетуилохкири, вов исин чяво Милкатиро, савэ вой бэянда Нахорости. Тунчи мэ дэнём лати чень важ накх тай ланчюги пэ вастэн, ");
INSERT INTO rmyservi_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","тэлилём тай ашардом РАЕ. Мэ ашардом РАЕ, Дэвлэ Авраамохкирэ, мурэ раехкирэ, Саво анда ман чячютнэ дромэґа, соб тэ лав мурэ раехкирэ пхралэстеря внучка пала лэхкоро чяво. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Кана, сар тумэ терэна мила тай чячимо мурэсти раести, пхэнэн манди, ай сар нат, кади ж пхэнэн манди, соб мэ тэ джянав, со манди тэ терэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Лавано тай Бетуило пхэндэ: — Кадыва рындо РАЕСТАР, на амэнди тэ пхэнэ тути нэ чи нат. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Акэ Ревека англа тут; залэ ла тай джя, тай мэк вой ачела ромняґа тирэ раехкирэ чявэсти, сар вылиля РАЙ. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Кала Авраамохкиро копыли ушунда кадыла лава, вов тэлиля РАЕСТИ ды пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Тунчи вов вылиля лачи їда, кадиж сувнакуно тай рупуно шукаримо, тай отдэня Ревекати; латирэсти пхралэсти тай дати вов кадиж дэня кучютнэ подаркуря. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Тунчи вов тай мануша, савэ сле лэґа, хале, пиле тай ачелепэ тэ ратярэ. Кала пэ авэр дэнзор вонэ вщиле, вов пхэнда: — Отмукэн ман, мэ камав тэ джя дэ дром мурэстэ раестэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Ай пхрал тай дэй Ревекатирэ пхэндэ: — Мэк чей ачелапэ амэнца инте пэ дэш дивэ, тунчи джяґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Нэ вов пхэнда: — На рицарэн ман, сар РАЙ дэня бахт колэсти, пала со мэ бичялдо кордэ. Отмукэн ман дэ дром, соб маї тэ рисявав мурэстэ раестэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Вонэ пхэндэ: — Акхараґа чя тай пхучяґа ла. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Вонэ акхардэ Ревека тай пхучле: — Ту джяґа кадэлэґа манушэґа? — Джява, — пхэнда вой. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Тай вонэ отбичялдэ дэ дром пэхккиря пхэня Ревека екхтханэ кодэлаґа, ко ла парварэлас, Авраамохкирэґа копэлеґа тай манушэнца, савэ лэґа сле. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Вонэ бахталисардэ Ревека тай пхэндэ: — Амари пхэнь, мэк тирэн чяворэн авэла пхангли тай дэшвар будэр латар мэк вонэ лэна зораґа цэра тай форуря пэхкирэн врыжымашэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Ревека тай латирэ копыльницы стидэнепэ, бэшле пэ верблюдонэн тай джиле пала Авраамохкиро копыли. Кади копыли лиля Ревека тай джиля дэ дром. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Исаако кацик со рисиля Бээр-Лахай-Роиестар — вов джюда дэ Негево. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Акэ, бельвеляґа вов выджиля дэ маля, подлиля якха тай удыкхля, со джян верблюдоря. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ревека кадиж подлиля якха тай удыкхля Исаако. Вой смукляпэ верблюдостар ");
INSERT INTO rmyservi_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","тай пхучля копылестар: — Ко кава мануш дэ маля, со джял амэндэ пэ дром? — Када муро рай, — пхэнда копыли. Тунчи вой лиля ушардо тай чюта пэ пэстэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Копыли роспхэнда Исаакости пала вса, со терда. ");
INSERT INTO rmyservi_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Исаако залиджялда Ревека дэ катуна пэхкиря датэ Сарратэ тай лиля ла дэ ромнен. Вой ачиля лэсти ромняґа, тай вов покамля ла. Кади Исаако аракхля пачя, тунчи сар муля лэхкири дэй. ");
INSERT INTO rmyservi_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Авраамо лиля пэсти авэр ромня, савя акхарэнас Кетура. ");
INSERT INTO rmyservi_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Вой бэянда лэсти Зимрано, Йокшано, Медано, Мидьяно, Ишбако тай Шуахо. ");
INSERT INTO rmyservi_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Йокшано сля дадэґа Шэвасти тай Деданости. Потомкуря Деданохкирэ сле Ашшуримо, Летушимо тай Леуммимо. ");
INSERT INTO rmyservi_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Чявэ Мидьянохкирэ: Эфа, Эферо, Енохо, Авида тай Элдаа — всаворэ вонэ потомкуря Кетуратирэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Авраамо ачявда вса, со лэстэ сля, Исаакости. ");
INSERT INTO rmyservi_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Ай чявэнди наложницэндар вов инте сар сля джюдо, Авраамо дэня подаркуря тай отбичялда лэн пэхкорэстар чявэстар Исаакостар пэ востоко, дэ восточно пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Всаворо джювимо Авраамохкиро сля 175 бэрш. ");
INSERT INTO rmyservi_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Авраамо муля дэ баря пхурима, пхуро тай чяло джювимаґа, тай отджиля пэхкорэндэ дадэндэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Лэхкирэ чявэ Исаако тай Измаило гаравдэ лэ дэ пищера Махпела пашэ Мамреґа, пэ маля хеттеёхкири Эфронохкири, чявэ Цохарохкирэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Кадыя маля, сави Авраамо тинда хеттеендэ. Котэ Авраамо сля гаравдо пашэ лэхкиряґа ромняґа Сарраґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Тунчи, сар муля Авраамо, Дэвэл бахталисарда лэхкорэ чявэ Исаако, саво тунчи джюда пашэ Бээр-Лахай-Рои. ");
INSERT INTO rmyservi_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Акэ роспхэндимо пала Измаило, Авраамохкирэ чявэ, савэ Сарратири копыльница Агарь египтостар, бэянда Авраамости, тай пала лэхкирэн чяворэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Акэ лава Измаилохкирэн чявэн, бинэнпэ пхурэдэстар чявэстар: Неваёто (барэдэр чяво Измаилохкиро), Кедаро, Адбеэло, Мивсамо, ");
INSERT INTO rmyservi_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Мишма, Дума, Масса, ");
INSERT INTO rmyservi_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Хададо, Тема, Етуро, Нафишо тай Кедма. ");
INSERT INTO rmyservi_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Када лава чявэн Измаилохкирэн, лава дэшудуен барэдэрэн. Кадиж сле акхардэ и лэндирэ тхана, тев вонэ джювэнас тай пхирэнас. ");
INSERT INTO rmyservi_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Всаворо джювимо Измаилохкиро сля 137 бэрш. Вов муля тай отджиля пэхкорэндэ дадэндэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Лэхкоро потомкуря джюдэ дэ пхув Хавилатар ды Шуро, пашэ Египто, сар тэ джя дэ Ашшуро. Вонэ джюдэ дэ холя всаворэнца пэхкирэнца пхралэнца. ");
INSERT INTO rmyservi_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Акэ роспхэндимо пала Исаако, Авраамохкирэ чявэ, тай пала лэхкирэн чяворэн. Авраамостэ бэяндапэ Исаако. ");
INSERT INTO rmyservi_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Исаакости сля саранда бэрш, кала вов лиля пэсти ромня Ревека. Вой сля чей арамеёхкири Бетуилохкири, саво джюда дэ Паддано-Арамо. Вой сля пхэнь арамеёсти Лаваности. ");
INSERT INTO rmyservi_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Исаако мангэлас РАЕ пала пэхкиря ромня, пала када со латэ на сля чяворэн. РАЙ дэня, со вов мангэлас, тай лэхкири ромни Ревека ачиля пхари. ");
INSERT INTO rmyservi_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Чяворэ ачиле тэ марэпэ дэ латири води, тай вой пхэнда: — Пала со манди када? Тай вой джиля тэ пхуче РАЕСТАР. ");
INSERT INTO rmyservi_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","РАЙ пхэнда лати: — Дуй родуря дэ води тири, тай дуй народуря джяна тутар. Екх авэла зоралэдэр аврэ, тай пхурэдэр авэла дэ копылен цыкнэстэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Кала авиля вряма лати тэ бэянэ, латэ дэ води чяче сле чяворэ блезняшкуря. ");
INSERT INTO rmyservi_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Англуно бэяндапэ лоло, тай вов всаворо сля дэ балэн, сар ворсисто їда. Лэ акхардэ Исаво. ");
INSERT INTO rmyservi_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Тунчи сикавдапэ лэхкоро пхрал, саво рицарэласпэ вастэґа пала талпа Исавохкири. Вов сля акхардо Иаково. Кала Ревека бэянда лэн, Исаакости сля 60 бэрш. ");
INSERT INTO rmyservi_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Чяворэ выбариле. Исаво сля лачё астаримари, малендиро мануш, ай Иаково сля мануш пачяло, вов джюда машкар катуны. ");
INSERT INTO rmyservi_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Исаакости фартэ чялёлас тэ ха тавдо дыконэндар зверёнэндар, тай вов будэр камэлас Исаво, нэ Ревека будэр камэлас Иаково. ");
INSERT INTO rmyservi_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Екхвар, кала Иаково тавэлас зюми, Исаво рисиля малятар тай фартэ циниля. ");
INSERT INTO rmyservi_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Вов пхэнда Иаковости: — Дэ манди тэ ха набут кова лоло, со ту тавэх! Мандэ будэр на ачиляпэ зор! (Акэ сости лэсти дэне кадиж лав Эдомо.) ");
INSERT INTO rmyservi_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Иаково пхэнда: — Мэ дава тути зюми, кацик дэ лав со пала када мэ авава тэ бинэпэ пхурэдэрэґа чявэґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","— Мэ мэрав бокхатар, — пхэнда Исаво. — Со манди кодэлэстар, со мэ пхурэдэр чяво? ");
INSERT INTO rmyservi_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Иаково пхэнда: — Дэ солах. Вов дэня солах, тай кади битинда пэхкоро англуно тхан Иаковости. ");
INSERT INTO rmyservi_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Тунчи Иаково дэня Исавости мандро тай чечевично зюми. Исаво халя, вщиля тай уджиля. Кади Исаво чюнгарда пэ кода, со вов сля пхурэдэр чяво. ");
INSERT INTO rmyservi_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Пэ пхув сля бокх, — сар бокх, сави сля, кала джювэлас Авраамо, — тай Исаако джиля дэ Гераро Авимелехостэ, тхагарестэ филистимлянонэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","РАЙ сикавдапэ Исаакости тай пхэнда: — На джя дэ Египто. Джюв дэ кодэя пхув, тев Мэ пхэнава. ");
INSERT INTO rmyservi_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Джюв пэ кадэя пхув, тай Мэ авава туґа тай бахталисарава тут, стерава кода, пала со солаханём тирэсти дадэсти Авраамости: Мэ дава всавори кадэя пхув тути тай тирэнди чяворэнди. ");
INSERT INTO rmyservi_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Мэ стерава, со тирэн чяворэн авэла бут, сар чергэнен дэ болыбэн, тай дава лэнди всавори кадэя пхув. Тирэндар чяворэндар бахталисарэнапэ всаворэ народуря пэ пхув, ");
INSERT INTO rmyservi_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","пала када со Авраамо кандэлас Ман тай фирисарэлас Мурэ лава, со Мэ прыпхэнавас, Муро прыпхэндимо тай законуря. ");
INSERT INTO rmyservi_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Исаако ачиля тэ джювэ дэ Гераро. ");
INSERT INTO rmyservi_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Кала мануша, савэ джюдэ дэ кодэва тхан пхучле лэстар пала лэхкиря ромня, вов пхэнда: «Када мури пхэнь». Вов дарэня тэ пхэнэ: «Када мури ромни», пала када со думисарэлас: «Мануша, савэ джювэн дэ кадэва тхан, умарэна ман пала Ревекатэ, пала када со вой шукарни». ");
INSERT INTO rmyservi_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Кала Исаако проджюда котэ бут вряма, Авимелехо, тхагари филистимлянонэн, подыкхля дэ фылястра тай удыкхля , сар Исаако облэлас Ревека, пэхкиря ромня. ");
INSERT INTO rmyservi_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Авимелехо акхарда Исаако пэстэ тай пхэнда: — Вой тири ромни! Сости ту пхэндан: «Вой мури пхэнь»? Исаако пхэнда лэсти: — Пала када, со мэ думисаравас, со пала латэ ман умарэна. ");
INSERT INTO rmyservi_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Тунчи Авимелехо пхэнда: — Со ж ту стердан амэнца? Екх муршэндар пэрэлас бы тиряґа ромняґа, тай ту андан бы пэ амэн дош. ");
INSERT INTO rmyservi_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Авимелехо прыпхэнда всаворэнди манушэнди: — Всяко, ко ґулела кадэлэстэ манушэстэ чи лэхкирятэ ромнятэ, чяче авэла умардо. ");
INSERT INTO rmyservi_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Исаако чюта ворзо пэ маля дэ кодэя пхув тай дэ кодэва жэ бэрш стидэня шэлвар будэр. РАЙ бахталисарда лэ, ");
INSERT INTO rmyservi_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","тай Исаако ачиля барвало. Лэхкоро барвалимо барёлас, вов ачиля фартэ баро мануш. ");
INSERT INTO rmyservi_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Лэстэ сле кацавэ барэ гуртуря бакрэн, бузнен тай гурувнен тай скацик копылен, со филистимлянуря рицарэнас холи дэ пэхкоро їло пэ лэстэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Вонэ зачютэ пхуяґа всаворэ ханинга, савэ инте сар сля джюдо дад лэхкоро Авраамо, выґанавдэ лэхкирэ копыли. ");
INSERT INTO rmyservi_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Авимелехо пхэнда Исаакости: — Уджя амэндар. Ту ачилян фартэ зорало важ амэнди. ");
INSERT INTO rmyservi_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Исаако уджиля котар, ачиля тэ джювэ дэ герарско маля. ");
INSERT INTO rmyservi_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Исаако выжужарда ханинга, савэ выґанавдэ копыли лэхкирэ дадэ Авраамо, тай сар вов муля, кадэлэ ханинга сле зачютэ филистимлянонэнца. Вов дэня лэнди кодэла жэ лава, савэ дыкалэ дэня лэхкоро дад. ");
INSERT INTO rmyservi_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Копыли Исаакохкирэ ачиле тэ ґанавэ дэ маля тай оттердэ котэ ханинг, пани савэстар марэлас пхуятар. ");
INSERT INTO rmyservi_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Ай герарски чябануря ачиле тэ кошэпэ чябанонэнца Исаакохкирэнца . Вонэ пхэнэнас: «Када амаро пани!» Вов акхарда ханинг Эсеко, пала када со вонэ кошэнаспэ лэґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Тунчи вонэ выґанавдэ авэр ханинг, ай и пала лэстэ ачиле тэ кошэпэ, пала када вов акхарда лэ Ситна. ");
INSERT INTO rmyservi_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Исаако уджиля котар тай выґанавда инте екх ханинг, пала савэстэ кошэмо на сля, тай вов акхарда лэ Реховото. Вов пхэнда: «Кана РАЙ дэня амэнди оттердо тхан, тай амэн авэла бут дэ кадэя пхув». ");
INSERT INTO rmyservi_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Вов джиля котар дэ Вирсавия. ");
INSERT INTO rmyservi_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Дэ кодэя рат РАЙ сикавдапэ лэсти тай пхэнда: — Мэ — Дэвэл Авраамохкиро, тирэ дадэхкиро. На дар, Мэ туґа. Мэ бахталисарава тут тай стерава, со тирэн чяворэн авэла бут, важ Муро копыли Авраамо. ");
INSERT INTO rmyservi_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Исаако стерда жэртвенико тай прыакхарда РАЕХКОРО лав, тай тховда котэ катуна, ай лэхкирэ копыли выґанавдэ ханинг. ");
INSERT INTO rmyservi_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Авимелехо авиля лэстэ Гераростар екхтханэ Ахузатоґа, саво сля лэхкоро подпхэндимарё, тай Фихолоґа, барэдэр рай дэ лэхкирэ войско. ");
INSERT INTO rmyservi_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Исаако пхучля лэн: — Пэ со тумэ авиле? Тумэ жэ холиле пэ ман тай вытрадэне ман! ");
INSERT INTO rmyservi_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Вонэ пхэндэ: — Амэ кана полах, со туґа РАЙ, тай амэ камах, соб ту и амэ тэ солахах тай тэ допхэнахпэ. Тераґа допхэнимо, ");
INSERT INTO rmyservi_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","со ту на терэґа амэнди врытимо, сар и амэ на лилепэ тутэ, обджяґаспэ туґа мишто тай отмукле тут пачяґа. Ай кана ту бахталисардо РАЕҐА. ");
INSERT INTO rmyservi_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Исаако тховда лэнди лачё скаминд, вонэ хале тай пиле. ");
INSERT INTO rmyservi_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Пэ авэр диво, дэнзор вонэ дэне екх екхэсти солах. Исаако отмукля лэн, тай вонэ уджиле лэстар пачяґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Дэ кодэва диво копыли Исаакохкирэ авиле тай роспхэндэ лэсти пала ханинг, саво вонэ выґанавдэ. Вонэ пхэндэ: — Амэ аракхле пани! ");
INSERT INTO rmyservi_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Вов акхарда лэ Шыва, тай ды авдивэ, кадыва форо акхарэлпэ — Вирсавия. ");
INSERT INTO rmyservi_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Кала Исавости сля саранда бэрш, вов лиля пэсти дэ ромнен Ехудита, хеттеёхкиря Бээрихкиря чя; тай инте лиля Басемата, хеттеёхкиря Элонохкиря чя. ");
INSERT INTO rmyservi_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Лэндар сля бут врытимо Исаакости тай Ревекати. ");
INSERT INTO rmyservi_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Кала Исаако ачиля пурано тай лэхкирэ якха хасардэ зор, вов акхарда Исаво, пэхкирэ пхурэдэрэ чявэ, тай пхэнда лэсти: — Чяво муро! — Мэ катэ, — пхэнэл Исаво. ");
INSERT INTO rmyservi_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Исаако пхэнда: — Мэ пхуро, тай на джянав мэ диво, кала мэрава. ");
INSERT INTO rmyservi_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Лэ тиро колчяно тай луко, джя дэ маля тай дорос манди дыко мас. ");
INSERT INTO rmyservi_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Тав манди камлимахкиро хамо муро тай ан манди тэ ха, соб мэ бахталисардом тут англа муро мэримо. ");
INSERT INTO rmyservi_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ревека шунда, сар Исаако дэдуманя пэхкирэґа чявэґа Исавоґа, тай кала Исаво уджиля дэ маля, соб тэ умарэ тай тэ анэ дыко мас, ");
INSERT INTO rmyservi_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Ревека пхэнда пэхкирэсти чявэсти Иаковости: — Мэ шундом, сар тиро дад пхэнда тирэсти пхралэсти Исавости: ");
INSERT INTO rmyservi_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","«Ан дыко мас тай тав лачё хамо, соб мэ бахталисардом тут англа РАЙ, покы на мулём». ");
INSERT INTO rmyservi_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Шун ман мишто кана, чяво муро, тай тер, сар мэ пхэнава тути. ");
INSERT INTO rmyservi_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Джя гуртостэ тай ан манди дуен лачен бузнорэн, соб манди тэ тавэ лачё хамо важ тиро дад, кацаво хамо, сар лэсти чялёл. ");
INSERT INTO rmyservi_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Тунчи отлиджя лэ дадэсти, вов хала тай бахталисарэла тут, покы на муля. ");
INSERT INTO rmyservi_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Иаково пхэнда Ревекати, пэхкиряти дати: — Нэ муро пхрал Исаво всаворо дэ балэн, ай мандэ морци жужи. ");
INSERT INTO rmyservi_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Со, сар дад лэлапэ мандэ? Мэ авава англа лэстэ хохавимари, тай вов сигидэр дэла ман мрая, ай на бахталисарэла. ");
INSERT INTO rmyservi_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Дэй пхэнда лэсти: — Мрая мэк авэла пэ мандэ, чяво муро, ай ту тер, сар мэ пхэнав: джя тай ан бузнорэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Вов джиля, лиля бузнорэн тай анда лэн дати, тай вой тавда лачё хамо, кацаво, сар чялёл лэхкирэсти дадэсти. ");
INSERT INTO rmyservi_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Тунчи Ревека лиля фэдэдэр їда Исавохкири, пэхкирэ пхурэдэрэ чявэхкири, сави сля латэ дэ цэр, тай урявда пэ цыкнэдэр чявэ Иаково, ");
INSERT INTO rmyservi_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","ай лэхкирэ васта тай жужи кор ушаравда бузнорэхкиряґа морцяґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Тунчи вой дэня пэхкирэсти чявэсти Иаковости лачё хамо тай мандро, савэ тавда. ");
INSERT INTO rmyservi_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Вов авиля дадэстэ тай пхэнда: — Муро дад. — Акэ мэ, — пхэнда кодэва. — Ту саво мурэндар чявэндар? ");
INSERT INTO rmyservi_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Иаково пхэнда дадэсти: — Мэ — Исаво, тиро барэдэр чяво. Мэ тердом, сар ту пхэндан. Мангав, ваздэпэ, бэш тай ха муро хамо, соб тунчи ту тэ бахталисарэх ман. ");
INSERT INTO rmyservi_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Исаако пхучля Иаковостар: — Сар ту кади сиго аракхлян ла, муро чяво? — РАЙ, тиро Дэвэл, дэня манди бахт, — пхэнда кодэва. ");
INSERT INTO rmyservi_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Исаако пхэнда Иаковости: — Поджя пашэдэр, соб манди тэ лэпэ тутэ, муро чяво, чяче ту муро чяво Исаво чи нат. ");
INSERT INTO rmyservi_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Иаково поджиля пашэдэр пэхкирэстэ дадэстэ Исаакостэ, саво лиляпэ лэстэ тай пхэнда: — Гласо — сар гласо Иаковохкиро, ай васта — сар васта Исавохкирэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Вов на уджянгля лэ, пала када со васта лэстэ слэ дэ балэн, сар Исавостэ, и вов бахталисарда лэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","— Чяче ту муро чяво Исаво? — пхучля Исаако, тай вов пхэнда лэсти: — Нэ, када мэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Исаако пхэнда: — Чяво муро, подлиджя манди тиро дыко мас пашэдэр, тай мэ хава, ай тунчи бахталисарава тут. Иаково дэня лэсти хамо, тай вов халя, анда мол, тай вов пиля. ");
INSERT INTO rmyservi_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Тунчи лэхкиро дад Исаако пхэнда лэсти: — Подджя, чяво муро, тай чюминдэ ман. ");
INSERT INTO rmyservi_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Вов поджиля тай чюминда лэ. Исаако ушунда фано лэхкиря їдатиро тай бахталисарда лэ: — Када фано мурэ чявэхкиро, сар малятиро фано, сави бахталисарда РАЙ. ");
INSERT INTO rmyservi_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Мэк Дэвэл дэла тути болыбнахкирятар росынатар тай барвалиматар пхуятирятар, бут ворзо тай тэрно мол. ");
INSERT INTO rmyservi_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Тэ терэн пэ тутэ породы, тай тэлён тути народуря. Раеґа ав тирэнди пхралэнди, тай тэ тэлён англа тутэ чявэ тиря датирэ. Тэ авэл дэно мрая кодэва, ко дэл тут мрая, ай ко бахталисарэл тут, тэ авэл бахталисардо. ");
INSERT INTO rmyservi_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Кацик Исаако пэрэачиля тэ бахталисаримо, тай кацик Иаково выджиля дадэстар, сар авиля лэхкиро пхрал Исаво астариматар. ");
INSERT INTO rmyservi_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Вов кадиж тавда лачё хамо тай анда дадэсти. Вов пхэнда лэсти: — Дадэ, ваздэпэ, бэш тай ха муро хамо, ай тунчи бахталисар ман. ");
INSERT INTO rmyservi_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Лэхкиро дад Исаако пхучля: — Ко ту? — Мэ тиро чяво, — пхэнда вов, — тиро барэдэр, Исаво. ");
INSERT INTO rmyservi_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Исаако всаворо тэ затинисиля тай пхэнда: — Ко сля кодэва авэр, саво анда дыко мас манди? Мэ халём лэ англа кода, сар ту тэ авэх тай бахталисардом лэ. Вов кана авэла бахталисардо! ");
INSERT INTO rmyservi_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Кала Исаво ушунда дадэхкирэ лава, вов зоралэ тай кырко затиписиля тай пхэнда дадэсти: — Бахталисар кадиж и ман, дадэ! ");
INSERT INTO rmyservi_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Нэ кодэва пхэнда: — Тиро пхрал авиля хрантимаґа тай отлиля тутар бахталисаримо. ");
INSERT INTO rmyservi_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Исаво пхэнда: — Чячимаґа, лэ и акхарэн Иаковоґа? Дувар вов обджиля ман: лиля муро барэдэримо, а кана муро бахталисаримо! Тай пхучля: — На ачиляпэ тут э бахталисаримо и важ манди? ");
INSERT INTO rmyservi_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Исаако пхэнэл Исавости: — Мэ тердом лэ хулаеґа понад тутэ, тай всаворо лэхкиро родо отдэнём лэсти дэ копылен, бахталисардом лэ мандрэґа тай дэнём лэсти тэрно мол. Со жэ кана тэ тере важ тути, муро чяво? ");
INSERT INTO rmyservi_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Исаво пхэнда дадэсти: — Тутэ со, кацик екх бахталисаримо, дадэ? Бахталисар и ман, дад муро! Тай фартэ зоралэ заровиня. ");
INSERT INTO rmyservi_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Дад лэхкиро Исаако пхэнда лэсти: — Тиро джювимо авэла дур барвалиматар, сави дэл пхув, дур болыбнастирятар росынатар, сави упрэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ту авэґа тэ джювэ баря чюрятар тай авэґа тэ терэ бути пэ тиро пхрал. Нэ авэла вряма, кала ту ваздэґапэ тай счювэґа пэхкирятар коратар лэхкиро ґамо. ");
INSERT INTO rmyservi_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Исаво рицарэлас холи пэ Иаково пала бахталисаримо, саво дэня лэсти дад, тай пхэнда пэсти: «Сиго дад мэрэла, тай проджяна ровимахкирэ дивэ пала муро дад. Тунчи мэ умарава мурэ пхралэ Иаково». ");
INSERT INTO rmyservi_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ревекати пэрэдэне, со пхэнда пхурэдэр чяво Исаво, тай вой бичялда пала цыкнэдэр чяво, пала Иаково, тай пхэнда лэсти: — Тиро пхрал Исаво думисарэл тэ умарэ тут. ");
INSERT INTO rmyservi_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Муро чяво, стер, сар мэ пхэнава: екхатар жэ прастэ дэ Харано мурэстэ пхралэстэ Лаваностэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Джюв лэстэ савись вряма, покы на уджяла холи тирэстэ пхралэстэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Кала жэ холи тирэ пхралэстэ проджяла тай вов бистарэла кода, со ту тердан лэсти, тунчи мэ бичялава тэ пхэнэ тути, со авиля вряма тэ рисявэ тути. Пэ со манди тэ хасарэ тумэн дуен дэ екх диво? ");
INSERT INTO rmyservi_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Тунчи Ревека пхэнда Исаакости: — Мэ на лошали джювимати пала кадэла хеттейсконэн чеен. Сар и Иаково лэла пэсти дэ ромнен джювля калатар пхуятар, кацавя акэ хеттеянка, сар кадэла, тунчи пала со манди тэ джювэ? ");
INSERT INTO rmyservi_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Исаако акхарда Иаково, бахталисарда лэ тай прыпхэнда лэсти: — На лэ пала пэстэ ханаанеянка. ");
INSERT INTO rmyservi_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Екхатар жэ джя дэ Паддано-Арамо, дэ Бетуилохкиро цэр, дадэстэ тиря датиро, тай лэ пэсти котар ромня Лаванохкирэндар чеендар, тирэстар какостар пав дэй. ");
INSERT INTO rmyservi_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Тэ бахталисарэл тут Дэвэл Всазорако тай терэла тутар бут чяворэ, соб тутар тэ джян бут народуря. ");
INSERT INTO rmyservi_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Тэ дэл Вов тути и тирэнди чяворэнди Авраамохкиро бахталисаримо, соб тэ авэх ту хулай пхуятиро, пэ сави ту екхатар джювэх, пхуятиро, сави Дэвэл дэня Авраамости. ");
INSERT INTO rmyservi_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Тунчи Исаако отмукля Иаково, тай кодэва джиля дэ Паддано-Арамо, Лаваностэ, арамеёхкирэ Бетуилохкирэ чявэстэ, пхралэстэ Ревекатирэ, сави сля дэй Иаковости тай Исавохкири. ");
INSERT INTO rmyservi_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Исаво уджянгля, со Исаако бахталисарда Иаково тай бичялда лэ дэ Паддано-Арамо, соб тэ лэл котар ромня, и со вов кала бахталисарэлас, прыпхэнда лэсти: «На лэ дэ ромнен ханаанеянка», ");
INSERT INTO rmyservi_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","тай со Иаково кангля пэхкирэ дадэ и дэёра и джиля дэ Паддано-Арамо. ");
INSERT INTO rmyservi_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Тунчи Исаво полиля, со лэхкирэсти дадэсти Исаакости на чялёнас ханаанеянкуря. ");
INSERT INTO rmyservi_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Вов джиля Измаилостэ тай лэл пэсти инте екха ромня, Махалат, сави сля пхэнь Неваётохкири, чей Измаилохкири, чяво Авраамохкиро. ");
INSERT INTO rmyservi_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Иаково ачявда Вирсавия тай джиля дэ Харано. ");
INSERT INTO rmyservi_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Кала доджиля савэсь тханэстэ, вов ачеляпэ тэ ратярэ, пала када со кхам бэшля. Вов лиля котэ екх барэндар, тховда лэ пэсти тала шэро тай пэля тэ совэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Лэсти авиля суно. Вов удыкхля лестница, сави ачелас пэ пхув, ай латиро упралимо доросэлас ды болыбэн, тай пав латэ ваздэнаспэ тай змукэнаспэ ангелуря Дэвлэхкирэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Упрэ понад латэ ачелас РАЙ и пхэнэлас: — Мэ — РАЙ, Дэвэл тирэ дадэ Авраамо и Дэвэл Исаакохкиро. Пхув, пэ сави ту екхатар пашлёх, Мэ дава тути и тирэнди чяворэнди. ");
INSERT INTO rmyservi_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Тирэн чяворэн авэла кади бут, сар тишай пэ пхув, тай ту розджяґапэ пэ западо тай пэ востоко, пэ северо тай пэ юґо. Всаворэ мануша пэ пхув бахталисарэнапэ тутар тай тирэндар чяворэндар. ");
INSERT INTO rmyservi_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Мэ туґа тай авава тэ фирисарэ тут, тев бы ту тэ на джях, тай рисарава тут дэ кадэя пхув. Мэ на ачявава тут тай стерава вса, со пхэнавас тути. ");
INSERT INTO rmyservi_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Кала Иаково джюнгавдапэ, вов думисарда: «Чяче, пэ кадэва тхан РАЙ , ай мэ на джянавас». ");
INSERT INTO rmyservi_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Лэсти сля даруно, тай вов пхэнда: — Кадэва тхан сар даравэл! Чячимаґа, катэ цэр Дэвлэхкиро, тай када — болыбнахкирэ удара. ");
INSERT INTO rmyservi_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Иаково вщиля дэнзор, лиля бар, саво вов тховэлас пэсти тала шэро, тховда ворта лэ знакоґа, тай чюта пэ лэстэ оливково цил. ");
INSERT INTO rmyservi_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Вов акхарда кадэва тхан Вефилё, ай дыкалэ кодэва форо акхарэласпэ Лузо. ");
INSERT INTO rmyservi_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Тунчи Иаково дэня солах: — Сар Дэвэл авэла манца тай фирисарэла ман дэ кадэва дром, дэла манди мандро дэ хама тай їда пэ пхикэ, ");
INSERT INTO rmyservi_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","кади, со мэ рисявава тай авава тэ джювэ дэ пачя дэ дадэхкиро цэр, тунчи РАЙ авэла мурэґа Дэвлэґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Кадэва бар, саво мэ тховдом ворта, соб тэ рапирэ, авэла Дэвлэхкирэґа цэрэґа. Тай всаворэстар, со Ту дэґа манди, мэ дава Тути дэшто котор. ");
INSERT INTO rmyservi_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Иаково джялас дурэдэр тай авиля пэ пхув восточнонэндирэн манушэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Котэ вов удыкхля ханинг дэ маля тай паша лэ трин гуртуря бакрэн; колэстар ханингатар дэнас пани скотости. Ханинг сля ушаравдо барэ барэґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Кала всаворэ гуртуря стидэнаспэ, чябануря злэнас ханингатар бар тай дэнас бакрэнди пани, ай тунчи тховэнас бар упалэ пэ тхан. ");
INSERT INTO rmyservi_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Иаково пхучля чябанонэн: — Пхрала, катар тумэ? — Амэ Хараностар, — пхэндэ вонэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Вов пхэнда лэнди: — Тумэ джянэн Лавано, Нахорохкирэ внуко? — Нэ, джянах, — пхэндэ вонэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Иаково пхучля: — Лэстэ вса мишто? — Мишто, — пхэндэ вонэ. — Акэ Рахиль, лэхкири чей, джял бакрэнца. ");
INSERT INTO rmyservi_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","— Кхам инте фартэ вуче, — пхэнда вов. — Инте на авиля вряма тэ стидэ гуртуря. Дэн пани бакрэнди тай даравэн лэн пэ маля. ");
INSERT INTO rmyservi_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","— Амэнди нащи, — пхэндэ вонэ. — Трэбуни тэ стидэнпэ всаворэ гуртуря тай тэ улэн бар ханингатар. Тунчи амэ даґа бакрэнди пани. ");
INSERT INTO rmyservi_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Вов инте дэдуманя лэнца, сар подджиля Рахиль дадэхкирэнца бакрэнца: вой чяравэлас бакрэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Кала Иаково удыкхля Рахиля, пэхкирэ какохкирэ Лаванохкиря чя тай лэхкирэн бакрэн, вов подджиля, улиля бар ханингатар тай дэня пани Лаванохкирэнди бакрэнди. ");
INSERT INTO rmyservi_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Тунчи Иаково чюминда Рахиля тай зоралэ заровиня. ");
INSERT INTO rmyservi_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Вов пхэнда Рахиляти, со вов — родо латирэ дадэсти и Ревекатиро чяво. Вой прастэня тай роспхэнда пала када дадэсти. ");
INSERT INTO rmyservi_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Кала Лавано ушунда, со авиля лэхкиро племянико Иаково, вов прастэня лэстэ пэ дром, облиля лэ, чюминда тай акхарда пэстэ дэ цэр. Иаково роспхэнда лэсти пала вса. ");
INSERT INTO rmyservi_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Лавано пхэнда лэсти: — Ту исин муро чячё рат. Иаково проджюда лэстэ чён. ");
INSERT INTO rmyservi_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Лавано пхэнда Иаковости: — Ту исин родо манди, ай сости ту авэґа тэ терэ бути пэ ман ївъя? Пхэн манди, соґа тути тэ потинэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Лаваностэ сле дуй чея: барэдэра акхарэнас Лия, ай цыкня — Рахиль. ");
INSERT INTO rmyservi_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Лиятэ сле ковле якха, ай Рахилятэ сля шукарно тай муй, тай трупо . ");
INSERT INTO rmyservi_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Иаково покамля Рахиля и пхэнда Лаваности: — Мэ авава тэ терэ бути пэ тутэ ефта бэрша пала тиря цыкнэдэр чей Рахиль. ");
INSERT INTO rmyservi_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Лавано пхэнда: — Фэдэр мэ отдава ла тути, ай на кастись аврэсти. Ачпэ мандэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Иаково терэлас бути ефта бэрша, соб тэ лэл Рахиля, нэ вонэ сикавдэпэ лэсти, сар набут дивэ, пала када со вов камэлас ла. ");
INSERT INTO rmyservi_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Тунчи Иаково пхэнда Лаваности: — Дэ манди ромня муря, соб манди тэ джювэ лаґа, сар ромняґа: мури вряма авиля. ");
INSERT INTO rmyservi_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Лавано акхарда всаворэн, ко джювэл пашэ лэстэ, тай тховда лачё скаминд. ");
INSERT INTO rmyservi_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Нэ сар авиля бельвель, вов лиля пэхкиря чя Лия тай дэня ла Иаковости, тай Иаково сута лаґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Пэхкиря чяти Лавано дэня копыльница Зелфа. ");
INSERT INTO rmyservi_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Кала авиля дэнзор, Иаково додыкхля, со када сля Лия! Вов пхэнда Лаваности: — Со ту тердан манца? Мэ теравас бути пэ тутэ пала Рахилятэ. Сости ту хохавдан ман? ");
INSERT INTO rmyservi_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Лавано пхэнда: — Амэндэ на отдэн пала ром цыкня чя майанглал барэдэрятар. ");
INSERT INTO rmyservi_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Стер бъяв курко кадэла чяґа, ай тунчи амэ даґа тути и цыкнэдэря, пала авэр ефта бэрша бутя. ");
INSERT INTO rmyservi_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Иаково кади и стерда: пролиджялда курко Лияґа, ай тунчи Лавано отдэня лэсти пэхкиря чя Рахиля. ");
INSERT INTO rmyservi_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Лавано дэня Рахиляти пэхкиря копыльница Валла. ");
INSERT INTO rmyservi_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Иаково ачиля тэ джювэ Рахиляґа тай камэлас Рахиля будэр, сар Лия. Вов терэлас бути пэ Лавано инте ефта бэрша. ");
INSERT INTO rmyservi_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Кала РАЙ удыкхля, со Лия накамли, Вов терда, со латэ авэна чяворэ, ай Рахилятэ нат. ");
INSERT INTO rmyservi_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Лия ачиля пхари тай бэянда чяворэ. Вой пхэнда: «Када пала када, со РАЙ удыкхля муро бибахт. Кана муро ром чяче авэла ман тэ камэ», тай акхарда лэ Рувимо. ");
INSERT INTO rmyservi_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Вой упалэ ачиля пхари тай, кала бэянда чяворэ, пхэнда: «Кади сар РАЙ ушунда, со мэ накамли, Вов дэня манди инте кадэлэ». И вой акхарда лэ Симеоно. ");
INSERT INTO rmyservi_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Вой инте упалэ ачиля пхари тай, кала бэянда чяворэ, пхэнда: «Кана муро ром прэпхандэлапэ мандэ, пала када со мэ бэяндом лэсти тринэн чявэн». Пала када лэ акхардэ Левиё. ");
INSERT INTO rmyservi_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Вой упалэ ачиля пхари тай, кала бэянда чяворэ, пхэнда: «Кана мэ наисарава РАЕ». Пала када вой акхарда лэ Иуда. Тунчи вой пэрэачиля тэ бэянэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Рахиль дыкхэлас, со вой на бэянэл Иаковости чяворэн, тай рицарэлас холи пэ пэхкири пхэнь Лия. Вой пхэнда Иаковости: — Дэ манди чяворэн, чи мэ мэрава! ");
INSERT INTO rmyservi_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Иаково холяґа пхэнда лати: — Мэ со, Дэвэл, Саво на дэл тути чяворэн? ");
INSERT INTO rmyservi_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Вой пхэнда: — Акэ Валла, мури копыльница. Пэр лаґа, соб вой тэ бэянэл пала ман чяворэ, тай кади мандэ авэна чяворэ латар. ");
INSERT INTO rmyservi_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Кади вой дэня лэсти дэ ромнен пэхкиря копыльница Валла. Иаково сута лаґа, ");
INSERT INTO rmyservi_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","вой ачиля пхари тай бэянда лэсти чявэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Тунчи Рахиль пхэнда: «Дэвэл фирисарда мури патив. Вов ушунда муро мангимо тай дэня манди чявэ». Пала када вой акхарда лэ Дано. ");
INSERT INTO rmyservi_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Валла, копыльница Рахилятири, упалэ ачиля пхари тай бэянда Иаковости дуйтонэ чявэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Тунчи Рахиль пхэнда: «Баря маримаґа мэ мараваспэ муряґа пхэняґа тай выцэлдом». И вой акхарда лэ Неффалимо. ");
INSERT INTO rmyservi_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Кала Лия удыкхля, со вой пэрэачиля тэ бэянэ чяворэн, вой лиля Зелфа, пэхкиря копыльница, и дэня ла Иаковости дэ ромнен. ");
INSERT INTO rmyservi_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Лиятири копыльница Зелфа бэянда Иаковости чявэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Лия пхэнда: «Сави бахт!» И вой акхарда лэ Гадо. ");
INSERT INTO rmyservi_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Лиятири копыльница Зелфа бэянда Иаковости дуйтонэ чявэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Тунчи Лия пхэнда: «Сави мэ бахтали! Джювля авэна тэ пхэнэ пэ мандэ «бахтали». И вой акхарда лэ Асиро. ");
INSERT INTO rmyservi_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Дэ кодэя вряма, сар мануша стидэн див, Рувимо джиля дэ маля, аракхля мандрагоруря тай анда лэн дати. Рахиль пхэнда Лияти: — Мангав тут, дэ манди набут тирэ чявэхкирэн мандрагорурен. ");
INSERT INTO rmyservi_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Нэ кодэя пхэнда лати: — Ту и кади залилян мандар ромэ. Камэх кана тэ залэ мурэ чявэхкирэ мандрагоруря? — Мишто, — пхэнда Рахиль. — Мэк вов пэрэла туґа авдивэ ратяґа, ай ту отдэ манди тирэ чявэхкирэ мандрагоруря. ");
INSERT INTO rmyservi_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Кала бельвеляґа Иаково авиля малендар, Лия выджиля англа лэ и пхэнда: — Ту пэрэґа манца. Мэ потиндом пала тут чявэхкирэ мандрагонэнца. Тай вов сута лаґа дэ кодэя рат. ");
INSERT INTO rmyservi_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Дэвэл ушунда Лия, вой ачиля пхари тай бэянда Иаковости панчёнэ чявэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Тунчи Лия пхэнда: «Дэвэл дэня манди награда пала кода, со мэ дэнём мурэ ромэсти копыльница». Тай вой акхарда лэ Иссахаро. ");
INSERT INTO rmyservi_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Лия упалэ ачиля пхари тай бэянда Иаковости шовтонэ чявэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Тунчи вой пхэнда: «Дэвэл дэня манди кучютно подарко. Кана ром дэла манди патив, пала када со мэ бэяндом лэсти шов чявэн». Тай вой акхарда лэ Завулоно. ");
INSERT INTO rmyservi_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Проджиля савись вряма и вой бэянда чеёра тай акхарда ла Дина. ");
INSERT INTO rmyservi_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Тунчи Дэвэл взрапирда Рахиля. Вов ушунда ла тай терда кади, соб вой тэ бэянэл чяворэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Вой ачиля пхари тай бэянда чявэ. Вой пхэнда: «Дэвэл злиля муро ладжявимо». ");
INSERT INTO rmyservi_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Вой инте пхэнда: «Тэ дэл манди РАЙ инте екхэ чявэ», тай акхарда лэ Иосифо. ");
INSERT INTO rmyservi_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Тунчи сар Рахиль бэянда Иосифо, Иаково пхэнда Лаваности: — Отмук ман , соб мэ тэ рисявав пэ пхув, тев бэяндомпэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Дэ манди мурэн ромнен тай чяворэн, пала савэн мэ теравас бути пэ тутэ. Тунчи мэ уджява. Ту екхджино джянэх, сар бут мэ теравас пэ тутэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Нэ Лавано пхэнда лэсти: — Сар мэ аракхлём мила дэ тирэн якхэн, мангав тут, ачпэ. Мэ уджянглём пав врэжымо, со РАЙ бахталисарэл ман пала тутэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Тай допхэнда: — Пхэн пэхкири цымин, мэ потинава тути. ");
INSERT INTO rmyservi_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Иаково пхэнда лэсти: — Ту джянэх, сар мэ теравас бути пэ тутэ и савэ тирэ гуртуря ачиле тэ наисарэх ман. ");
INSERT INTO rmyservi_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Лэн на сля бут, сар мэ тэ авав, ай кана лэн пэ бутэстэ будэр, тай РАЙ бахталисарэл тут пала ман. Всаекх, кала жэ мэ стидава сось важ муро цэр? ");
INSERT INTO rmyservi_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Лавано пхучля: — Со тути тэ дэ? — Манди нисо на трэбуни, — пхэнда Иаково. — Стер важ манди кацик екх, тай мэ авава и дурэдэр тэ чяравэ тай фирисарэ тирэ гуртуря. ");
INSERT INTO rmyservi_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Мук ман тэ обджяв всаворэ гуртуря тай тэ тховав дэ рига всаворэ пятнистонэн и крапчятонэн бакрэн и бузнен тай всаворэ калэ бакрорэн. Вонэ авэна муро потинимо. ");
INSERT INTO rmyservi_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Чячимо муро душола англэ, кала закамэґа тэ дыкхэ потинимо, саво дэнян манди. Сар аракхэлапэ мандэ накрапчято тай напятнисто бузни чи накало бакроро, вонэ авэна тэ бинэпэ сар чёрданэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","— Допхэндэпэ, — пхэнда Лавано. — Мэк авэла кади, сар ту пхэндан. ");
INSERT INTO rmyservi_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Нэ дэ кодэва жэ диво вов отлиля всаворэн крапчятонэн тай пятнистонэн бузнэн, тай всаворэн крапчятонэн тай пятнистонэн бузнен, колэн, пэ кастэ сля парнимо, тай всаворэн калэн бакрорэн тай отдэня лэн тэ дыкхэн пала лэндэ лэхкирэ чявэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Тай вов терда, соб тэ авэл машкар лэндэ и Иаково тринэ дивэнго дром. Ай Иаково чяравэлас Лаванохкирэ гуртуря, савэ аченепэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Иаково вычинда ївант рандя тополестар, миндалестар тай чинарестар, злиля морци лэндар тай стерда пэ лэндэ парнэ тханора, соб тэ душол парнимо андрал. ");
INSERT INTO rmyservi_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Вов тховда кацавэ рандора дэ всаворэн балаен, соб вонэ тэ авэн скотостэ пэ якхэн, кала авэна тэ пэ пани. Дэ кодэя вряма, сар бакря ачен пхарэ, кала авэнас вонэ тэ пэ, ");
INSERT INTO rmyservi_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","вонэ теранас кода англа рандёра, тай бакрорэ бэянэнаспэ лэндэ пёстри, крапчяти тай пятнисти. ");
INSERT INTO rmyservi_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Иаково порисявэлас бакрэн пёстронэндэ и калэндэ , савэ сле Лаванохкирэ, ай тэрнэн тховэлас дэ рига. Кади лэстэ сле гуртуря, тай вов рицарэлас лэн ригатар Лаванохкирэндар бакрэндар. ");
INSERT INTO rmyservi_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Кала састэ бакрэ тай бузня авэнас тэ пэ, Иаково тховэлас англа лэндэ дэ балаен рандёра, соб вонэ тэ терэн бакрорэн англа рандя. ");
INSERT INTO rmyservi_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","А кала авэнас насастэ бакрэ тай бузня, то вов на тховэлас рандя. Кади насасто ското доросэласпэ Лаваности, ай састо — Иаковости. ");
INSERT INTO rmyservi_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Иаково ачиля тэ барвалёл, лэстэ кана сле барэ гуртуря, а кадиж копыли тай копыльницы, верблюдуря тай магаря. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Иаково ушунда, сар Лаванохкири чявэ пхэнэнас: «Иаково залиля вса, со сля амарэстэ дадэстэ, тай стидэня барвалимо амарэстар дадэстар». ");
INSERT INTO rmyservi_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Тай Иаково додыкхля, со Лавано на кацаво лэстэ, сар дыкалэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","РАЙ пхэнда Иаковости: — Рисяв павпалэ дэ дадэндири пхув, тирэстэ родостэ. Мэ авава туґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Иаково бичялда тэ пхэнэ Рахиляти тай Лияти, соб вонэ тэ выджян дэ маля, тев сле лэхкирэ бакрэ тай бузня. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Вов пхэнда лэнди: — Мэ дыкхав, со тумаро дад на кацаво мандэ, сар сля дыкалэ. Нэ Дэвэл мурэ дадэхкиро манца. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Тумэ джянэн, со мэ теравас бути пэ тумаро дад всаворэндар зорэндар, ");
INSERT INTO rmyservi_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","ай вов хохавэлас ман, дэшвар парувэлас муро потинимо. Нэ Дэвэл на дэня лэсти тэ терэ манди врыто. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Сар вов пхэнэлас: «Потинимо тиро авэла крапчято ското», всаворо ското бэянэлас крапчятонэн, ай сар вов пхэнэлас: «Потинимо тиро авэла пёстро ското», то всаворо ското бэянэлас пёстронэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Кади Дэвэл залиля ското тумарэстар дадэстар и дэня манди. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Екхвар, сар ското ушаравэл екх екхэ, мандэ авиля суно: мэ подлилём якха тай удыкхлём, со бузнэ, савэ ушаравэн бузнян, сле пёстри, крапчяти тай пятнисти. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ангело Дэвлэхкиро пхэнда манди дэ сунэ: «Иаково». Мэ пхэндом: «Мэ катэ». ");
INSERT INTO rmyservi_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Вов пхэнда: «Подыкх тай ту удыкхэґа: всаворэ бузнэ, савэ ушаравэн бузнян, — пёстри, крапчяти тай пятнисти. Мэ удыкхлём, сар обджиляпэ туґа Лавано. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Мэ — Дэвэл Вефилёхкиро, тев ту чювэґас дзэто пэ бар тай солоханян Манди. Ачяв сигидэр кадэя пхув и рисяв дэ пхув, тев ту бэянданпэ». ");
INSERT INTO rmyservi_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Рахиль тай Лия пхэндэ: — Исин ли амэндэ котор дэ амарэ дадэхкиро барвалимо? ");
INSERT INTO rmyservi_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Чи на душол, со вов бинэн амэн, сар на пала пэхкирэн? Вов битинда амэн тай хасарда кода, со лиля важ амэндэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Чяче, всаворо барвалимо, саво Дэвэл залиля дадэстар, исин амаро тай амарэ чяворэндиро. Тер кади, сар пхэнэл тути Дэвэл. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Иаково тховда чяворэн тай ромнен пэ верблюдуря, ");
INSERT INTO rmyservi_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","залиля всаворо ското, всаворо пэхкиро барвалимо, саво вов затерда дэ Паддано-Арамо, тай джиля дэ дром пэхкирэстэ дадэстэ Исаакостэ дэ пхув Ханаано. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Кала Лавано уджиля тэ подчинэ бакрэндирэ бала, Рахиль чёрда лэхкирэн дэвлэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Ай Иаково хохавда арамеё Лавано, на пхэнда лэсти, со уджял. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Вов унашля всаворяґа барвалимаґа, пэрэджиля лэнь тай джиля дэ плаендиро риг Галаадо. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Пэ трито диво Лаваности пхэндэ, со Иаково нашля. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Вов лиля пэґа родонэн, прастэня пала Иаково тай пэ ефтато диво доросля лэ дэ плаендиро риг Галаадско. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Нэ ратяґа Дэвэл авиля арамеёстэ Лаваностэ дэ сунэ тай пхэнда лэсти: «Фирисарпэ, на пхэн Иаковости ни лачё, ни врыто». ");
INSERT INTO rmyservi_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Лавано доросля Иаково. Иаково тховда катуна дэ плаендиро риг Галаадско, тай Лавано родоґа кадиж тховдэ пэхкирэ катуны. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Лавано пхэнда Иаковости: — Со ту тердан? Ту хохавдан ман тай улиджялдан мурэн чеен,сар копылен пэ мэрима. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Сости ту нашлян чёраханэс? Сости ту на пхэндан манди, соб мэ тэ отмукав тут лошаґа тай диленца, тала бубно тай арфа? ");
INSERT INTO rmyservi_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ту на дэнян манди тэ чюминдав пэ дром внуконэн тай чеен. Ту тердан би годяко. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Дэ мурэн зорэн тэ терав тути врытимо, нэ ратяґа, сави сля, тирэ дадэхкиро Дэвэл пхэнда манди: «Фирисарпэ, на пхэн Иаковости ни лачё, ни врыто». ");
INSERT INTO rmyservi_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Мишто, ту уджилян, пала када со ту фартэ камэлас тэ рисявэ дэ дадэхкиро цэр. Нэ пэ со ту чёрдан мурэн дэвлэн? ");
INSERT INTO rmyservi_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Иаково пхэнда Лаваности: — Мэ подарэнём, пала када со думисаравас, со ту зораґа отлэґа мандар тирэн чеен. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Нэ сар ту аракхэґа катэ кастэсь пэхкирэн дэвлэн, кодэва на джювэла. Англа тирэ родуря дыкх екджино, исин ли мандэ сось тиро, тай сар исин, залэ павпалэ. Иаково на джянгля, со дэвлэн чёрда Рахиль. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Лавано заджиля дэ Иаковохкири катуна, дэ Лиятири катуна тай дэ катуна дуен копыльницэн тай нисо на аракхля. Лиятирятар катунатар вов заджиля дэ Рахилятири катуна. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Рахиль лиля цэрутнонэн дэвлэн, тховда лэн тала верблюдонэндири зэнь тай бэшля пэ лэндэ. Лавано обродэня всавори катуна тай нисо на аракхля. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Рахиль пхэнда дадэсти: — На холяв, муро рай, мэ на вщява англа тутэ, пала када со мандэ екхатар со исин джювлендэ. Сар вов на родэня, вов на аракхля дэвлэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Иаково фартэ сля холятиро тай ачиля тэ выпхэнэ Лаваности: — Дэ со мури дош? — пхучля вов. — Саво бэзэх мэ тердом, со ту понашлян пала мандэ? ");
INSERT INTO rmyservi_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ту обродэнян всаворо муро лачимо — со ту аракхлян тирятар барвалиматар? Тхов, со аракхлян, англа тиро тай муро родо, тай мэк вонэ тэ сундисарэн амэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Мэ биш бэрш джюдом тутэ; тирэ бакря тай бузня на вычювэнас, мэ на халём бакрэн тирэндар гуртонэндар. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Мэ на анавас тутэ бакрорэн, савэн чинэлас дыко зверё, пала лэн мэ екджино чювавас мурэндар гуртонэндар. Ту мангэсас мандар роспотинимо пала вса, со чёрдо сля, ратяґа када сля чи дивэсэґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Дивэсэґа кхам пхабарэлас ман, ратяґа шылалимо мразякирэлас ман, суно нашэлас мурэндар якхэндар. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Кацавэнца сле кола биш бэрш, кала мэ джюдом дэ тиро цэр. Мэ теравас бути пэ тутэ дэшуштар бэрш пала дуен тирэн чеен тай шов бэрш пала ското, тай ту дэшвар парувэґас муро потимо. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Сар тэ на авэл бы манца Дэвэл мурэ дадэхкиро, Дэвэл Авраамохкиро, Кодэва, Кастар даралас Исаако, тунчи ту б отбичялдан ман шушэ вастэнца. Дэвэл дыкхля мури глаба тай бути мурэ вастэндиро тай сундисарда амэн ратяґа, сави проджиля. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Лавано пхэнда Иаковости: — Кала чея — мурэ чея, чяворэ — мурэ чяворэ, тай гуртуря — мурэ гуртуря. Вса, со ту дыкхэх, вса муро. Со жэ кана мэ тэ терав мурэнца чеенца тай чяворэнца, савэн вонэ бэяндэ? ");
INSERT INTO rmyservi_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Стераґа допхэнимо, ту тай мэ, и тэ авэл вов машкар амэндэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Иаково лиля бар тай тховда лэ, соб тэ рапирэн вонэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Вов пхэнда пэхкирэсти родости: — Стидэн бара. Вонэ стидэне бара, тховдэ лэн плаеґа тай бэшле пашэ тэ ха. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Лавано акхарда ла Егар-Сахадута, ай Иаково — Гал-Эд. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Лавано пхэнда: — Кадэва плаёро дыкхэл тай шунэл амари солах екх екхэсти. Акэ сости акхардэ ла Гал-Эд. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Тай инте ла акхардэ Мицпа, пала када со Лавано пхэнда: — Тэ дыкхэл РАЙ пала тут тай пала ман, кала амэ аваґа дур екх екхэстар. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Сар ту авэґа тэ лиджя пэ намишто мурэнца чеенца тай лэґа пэсти аврэн ромнен, тай сар ника амэнца нинай, рапир, со Дэвэл дыкхэл тай шунэл ман и тут. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Инте Лавано пхэнда Иаковости: — Акэ плаёро барэндар тай столбо, саво мэ тховдом машкар тутэ и мандэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Кала бара дыкхэн тай шунэн амари солах, со мэ на пэрэджява пала кадэва плаёро барэндар пэ тири риг, соб тэ анэ тути врытимо, тай ту на пэрэджяґа пала кадэва баруно столбо и плаёро барэндар пэ мури риг, соб тэ анэ манди врытимо. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Мэк Дэвэл Авраамохкиро тай Дэвэл Нахорохкиро, Дэвэл лэндирэ дадэхкиро, сундисарэл амэн. Тай Иаково солаханя Кодэлэґа, Савэ даралас лэхкиро дад Исаако. ");
INSERT INTO rmyservi_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Вов анда жэртва котэ дэ плая тай акхарда родо тэ хан. Вонэ хале тай ратярдэ котэ, ");
INSERT INTO rmyservi_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","тай дэнзор Лавано чюминда внуконэн и чеен, бахталисарда лэн тай джиля цэрэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Иаково джялас дурэдэр, тай ангелуря Дэвлэхкирэ выджиле лэсти пэ дром. ");
INSERT INTO rmyservi_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Кала Иаково удыкхля лэн, вов пхэнда: — Када Дэвлэхкиро тхан! — тай акхарда кова тхан Маханаимо. ");
INSERT INTO rmyservi_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Иаково бичялда англа пэ манушэн пэхкирэстэ пхралэстэ Исавостэ дэ пхув Сеиро, дэ пхув Эдомо. ");
INSERT INTO rmyservi_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Вов прэпхэнда лэнди: — Пхэнэн мурэсти раести Исавости кади: «Тиро копыли Иаково пхэнэн: Мэ джюдом Лаваностэ тай слём котэ ды кадэлэ дивэстэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Мандэ исин гурува, магаря, бакрэ тай бузнэ, копыли тай копыльницы. Мэ бичялав кадэя дума мурэсти раести, соб тэ аракхэ мила дэ тирэн якхэн». ");
INSERT INTO rmyservi_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Мануша, ка вов бичялда, рисиле тай пхэндэ Иаковости: — Амэ сле тирэстэ пхралэстэ Исавостэ, тай кана вов екджино джял тутэ пэ дром тай лэґа штар шэла манушэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Дэ бари дар тай би пачяско дэ їло Иаково розтховда пэ дуй табороря манушэн, савэ сле лэґа, тай кадиж гуртуря баро тай цыкно ското тай верблюдонэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Вов думисарэлас: «Сар Исаво помарэла екх таборо, тунчи авэр таборо ачелапэ тэ джювэ тай фирисарэлапэ». ");
INSERT INTO rmyservi_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Иаково ачиля тэ мангэпэ: — Дэвэл мурэ дадэхкиро Авраамохкиро, Дэвэл мурэ дадэхкиро Исаакохкиро, РАЙ, Саво пхэнда манди: «Рисяв дэ тири пхув, тирэстэ родостэ, тай Мэ дава тути мищимо»! ");
INSERT INTO rmyservi_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Мэ на ачяв кодэя мила тай чячимо, савэ Ту дэнян Тирэсти копылёсти. Кала мэ пэрэджилём Иордано, мандэ нисо на сля, екх дэсто, тай кана мэ рисявав павпалэ дуенца таборонэнца. ");
INSERT INTO rmyservi_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Мангав Тут, фирисар ман вастэстар Исаво, пхралэ мурэ, пала када со мэ дарав, со вов авэла тай помарэла ман тай дэен чяворэнца. ");
INSERT INTO rmyservi_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ту жэ пхэндан: «Мэ чячэ дава тути мищимо тай стерава, со тутэ авэла фартэ бут чяворэн, сар тишай морёско, саво на пэрэбинэґа». ");
INSERT INTO rmyservi_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Вов пролиджялда котэ рат тай кодэлэстар, со лэстэ сля, вылиля подарко пэхкирэсти пхралэсти Исавости: ");
INSERT INTO rmyservi_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","дуйшэла бузнян тай биш бузнэн, дуйшэла бакрян тай биш бакрэн, ");
INSERT INTO rmyservi_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","трянда верблюдицэн верблюжоконэнца, саранда гурувнен тай дэш гурувэн, биш магарицэн тай дэш магарен. ");
INSERT INTO rmyservi_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Вов дэня лэн копыленди, кажно гурто вылито, тай пхэнда лэнди: — Джян англа ман тай рицарэн машкар гуртуря савось дуримос. ");
INSERT INTO rmyservi_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Вов прыпхэнда кодэлэ, ко джялас англал: — Кала муро пхрал Исаво поджяла тутэ тай пхучела: «Кахкиро ту? Тев джях? Кахкиро ското даравэх?» — ");
INSERT INTO rmyservi_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","тунчи ту пхэн: «Ското тирэ копылёхкиро Иаковохкиро. Када подарко лэстар мурэсти раести Исавости, тай вов екджино джял пала амэн». ");
INSERT INTO rmyservi_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Вов прыпхэнда и дуйтонэ, и тритонэ, и всаворэн аврэн, савэ джянас пала гуртонэн: — Тай тумэ кадиж пхэнэна Исавости, кала вов тумэндэ поджяла. ");
INSERT INTO rmyservi_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Тай инте пхэнэнти: «Тиро копыли Иаково джял павпалэ амэндар». Иаково думисарэлас: «Мэ ковлярава лэ кадэлэнца даронэнца, савэ бичялав англа пэ, тай тунчи, кала амэ дыкхаґапэ, вов прылэла ман». ");
INSERT INTO rmyservi_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Кади даруря Иаковохкирэ сле отбичялдэ англэ, ай вов екджино ратярэлас дэ таборо. ");
INSERT INTO rmyservi_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Кодэла ратяґа Иаково вщиля, лиля дуен пэхкирэн ромнен, дуен копыльницэн тай дэшуекх чявэн тай дэ бродо пэрэджиля лэнь Яббок. ");
INSERT INTO rmyservi_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Вов пэрэлиджялда пэ авэр лэнятиро бэрэґо лэн тай всаворо пэхкиро мищимо. ");
INSERT INTO rmyservi_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Иаково ачиляпэ екджино, тай Кось бироласпэ лэґа ды дэнзор. ");
INSERT INTO rmyservi_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Кадэва удыкхля со ни сар на выцэлэл, Вов лиляпэ Иаковохкирэ шолдостэ, кади со шолдо слиляпэ тханэстар. ");
INSERT INTO rmyservi_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Вов пхэнда: — Отмук Ман, пала када со авэл дэнзор. Нэ Иаково пхэнда: — На отмукава, сар на бахталисарэґа ман. ");
INSERT INTO rmyservi_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Вов пхучля: — Сар тиро лав? — Иаково, — пхэнда вов. ");
INSERT INTO rmyservi_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Тунчи Вов пхэнда: — Кадылэ дивэстар тиро лав авэла на Иаково, ай Израилё, пала када со ту бироласпэ Дэвлэґа тай манушэнца тай выцэлдан. ");
INSERT INTO rmyservi_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Иаково пхэнда: — Мангав Тут, пхэн манди Тиро лав. Нэ Вов пхэнда: — Важ со ту пхучех муро лав? Тай Вов бахталисарда лэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Иаково пхэнда вов: «Мэ дыкхлём Дэвлэ муй муестэ тай ачилёмпэ джюдо», тай акхарда кодыва тхан Пенуэло. ");
INSERT INTO rmyservi_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Кала кхам вщиля понад лэстэ, вов проджялас Пенуэло тай лангалас пала пэхкиро шолдо. ");
INSERT INTO rmyservi_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Акхэ сости ды кадэва диво израильтянуря на хан шуки жыла пэ шолдо: Вов жэ малавда Иаково пав мышца пэ шолдо. ");
INSERT INTO rmyservi_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Иаково ваздэня якха тай удыкхля, со джял Исаво и лэґа штаршэла манушэн. Вов ростховда чяворэн машкар Лиятэ, Рахилятэ тай дуендэ копыльницэндэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Вов тховда копыльницэн тай лэндирэн чяворэн англэ, Лия тай латирэн чяворэн пала лэндэ, ай Рахиль Иосифоґа павпалэ всаворэндар. ");
INSERT INTO rmyservi_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Екджино вов джиля англэ тай, кала поджялас пхралэстэ, тэлиля ды пхув ефта молуря. ");
INSERT INTO rmyservi_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ай Исаво прастэня Иаковостэ пэ дром, облиля лэ, чютапэ лэсти пэ кор тай росчюминда лэ, тай вонэ заровине. ");
INSERT INTO rmyservi_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Исаво додыкхля джювлен тай чяворэн и пхучля: — Ко када туґа? Иаково пхэнда: — Када чяворэ, савэн пав мила Дэвэл дэня тирэсти копылести. ");
INSERT INTO rmyservi_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Копыльницы пэхкирэнца чяворэнца поджиле тай тэлиле. ");
INSERT INTO rmyservi_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Тунчи поджиле тай тэлиле Лия тай латирэ чяворэ. Пала всаворэндэ поджиле Иосифо тай Рахиль тай кадиж тэлиле. ");
INSERT INTO rmyservi_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Исаво пхучля Иаковостар: — Сости ту бичялдан всаворэ кала гуртуря манди пэ дром? — Мэ камлём тэ аракхэ лачимо дэ тирэн якхэн, рай муро, — пхэнда вов. ");
INSERT INTO rmyservi_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Исаво пхэнда: — Мандэ вса хутилэл, пхрал. Ачяв пэхкиро пэсти. ");
INSERT INTO rmyservi_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","— Нат, мангав тут! — пхэнда Иаково. — Сар мэ аракхлём лачимо дэ тирэн якхэн, то прылэ мандар кадэва даро. Важ манди тэ дыкхэ тиро муй — када сар тэ удыкхэ Дэвлэхкиро муй, ту жэ прылилян ман кади пав мила. ");
INSERT INTO rmyservi_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Мангав тут, прылэ мандар кала даруря, пала када со Дэвэл терда мила манди, тай мандэ исин вса, со трэбуни манди. Иаково фартэ мангэлас, тай Исаво прылиля даруря. ");
INSERT INTO rmyservi_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Тунчи Исаво пхэнда: — Джям, вряма тэ джя дэ дром. Мэ авава тэ рицарэпэ пашэ туґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Нэ Иаково пхэнда: — Муро рай джянэл, со чяворэндэ на бут зора. Тай бакря и гурувня дэн тхуд; сар лэн фартэ тэ даравэ сиго дэ екх диво, то ското хасявэла. ");
INSERT INTO rmyservi_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Мэк муро рай джял англал пэхкирэстар копылёстар, тай мэ джява насиг, кади сар джяна англа ман гуртуря тай чяворэ, покы на авава мурэстэ раестэ дэ Сеиро. ");
INSERT INTO rmyservi_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Исаво пхэнда: — Дэ мэ ачявава туґа набут мурэн манушэн. — Пэ со? — пхучля Иаково. — Хутилэла и када, со мэ аракхлём лачимо дэ якхэн мурэ раехкирэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Кади, Исаво дэ кодэва диво джиля павпалэ пэстэ дэ Сеиро. ");
INSERT INTO rmyservi_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Ай Иаково джиля дэ Суккото, тев вов стерда пэсти цэр, ай скотости шалашуря. Акэ сости кодэва тхан акхарэлпэ Суккото. ");
INSERT INTO rmyservi_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Иаково мищимаґа авиля Паддано-Арамостар дэ форо Шэхемо дэ Ханаано тай ачиля тэ джювэ англа форо. ");
INSERT INTO rmyservi_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Пала шэл кеситуря рупь вов тинда Хаморохкирэндэ чявэндэ, дадэ Шэхемохкирэндэ, котор маля, пэ саво тховда пэхкири катуна. ");
INSERT INTO rmyservi_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Котэ вов стерда жэртвеннико тай акхарда лэ «Эл-Элохей-Йисраэл». ");
INSERT INTO rmyservi_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Дина, Лиятири чей Иаковостар, джиля тэ удыкхэпэ катутнэнца джювленца. ");
INSERT INTO rmyservi_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Кала Шэхемо, чяво хивеёхкиро Хаморохкиро, саво сля барэдэрэґа дэ кодэя пхув, удыкхля ла, вов схутилда ла, пыла лаґа тай асаняпэ латар. ");
INSERT INTO rmyservi_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Лэхкиро їло прыачиля Динатэ, Иаковохкиря чятэ, вов покамля ла тай дэдуманя лаґа камлимаґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Шэхемо пхэнда пэхкирэ дадэсти Хаморости: — Лэ манди кадэла чя дэ ромнен. ");
INSERT INTO rmyservi_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Кала Иаково ушунда, со лэхкирятар чятар асанепэ, лэхкирэ чявэ сле дэ маля гуртонэнца, тай вов ачелас мулком пала када ды вряма, кала вонэ рисиле цэрэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Хаморо, Шэхемохкиро дад, авиля тэ дэдумэ Иаковоґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Сар кацик Иаковохкирэ чявэ ушундэ, со тердапэ, вонэ рисиле малендар. Вонэ сле фартэ мижэ тай холятирэ, пала када со Шэхемо терда ладжяво рындо дэ Израилё, кола пыля Иаковохкиря чяґа; када нащи сля тэ терэл. ");
INSERT INTO rmyservi_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Хаморо пхэнда лэнди: — Муро чяво Шэхемо всаворэґа їлэґа прыпхангляпэ тумарятэ чятэ. Мангав тумэн, отдэн ла лэсти дэ ромнен. ");
INSERT INTO rmyservi_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Терэн амэнцар бъява: отдэн амэнди пэхкирэн чеен тай лэн пала пэстэ амарэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Джювэн тумэ машкар амэндэ. Пхув англа тумэн: джювэн дэ ла, битинэн тай пхирэн пав ла тай авэн латирэнца хулаенца. ");
INSERT INTO rmyservi_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Шэхемо пхэнда Динатирэсти дадэсти тай пхралэнди: — Мэ дава тумэнди вса, со тумэ пхэнэна, тэ аракхав мэ лачимо дэ тумарэ якха! ");
INSERT INTO rmyservi_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Мангэн важ тэрнятэ цымин тай подаркуря, тай мэ потинава, кацик отдэн ла манди дэ ромнен. ");
INSERT INTO rmyservi_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Тунчи Иаковохкирэ чявэ пхэндэ Шэхемости тай лэхкирэ дадэсти Хаморости хохавимаґа, пала када со вов асаняпэ лэндиря пхэня Дина. ");
INSERT INTO rmyservi_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Вонэ пхэндэ лэнди: — Амэнди нащи тэ терэ када, нащи тэ отдэ амаря пхэня наобчиндэсти муршэсти. Када авэла амэнди ландявимаґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Амэ отдаґа тумэнди ла кацик, сар тумэ ачена, сар амэ, тай терэна обчиндимо всаворэнди пэхкирэнди муршэнди. ");
INSERT INTO rmyservi_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Тунчи амэ аваґа тэ отдэ тумэнди амарэн чеен тай тэ лэ пала пэстэ тумарэн. Амэ аваґа тэ джювэ машкар тумэн тай аваґа тумэнца екхэ народоґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ай сар тумэ на закамэна тэ терэ обчиндимо, амэ залаґа пхэня тай уджяґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Лэндирэ лава пыля дэ їло Хаморости тай лэхкирэсти чявэсти Шэхемости. ");
INSERT INTO rmyservi_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Тэрно мануш сиго терда кода, со вонэ пхэндэ, пала када со вов фартэ камэлас Иаковохкиря чя. Шэхемо сля фартэ пативало дэ пэхкиро дадэхкиро родо. ");
INSERT INTO rmyservi_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Хаморо тай лэхкиро чяво Шэхемо авиле форохкирэндэ вударэндэ тай пхэндэ манушэнди: ");
INSERT INTO rmyservi_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","— Кала мануша лачимаґа амэндэ, — пхэндэ вонэ. — Мэк джювэн дэ амари пхув тай пхирэн пав латэ: пэ кадэя пхув хутилэла и лэнди тхан. Амэ аваґа тэ лэ лэндирэн чеен, тай вонэ мэк лэн амарэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Кацик кади ала мануша камэн тэ джювэ амэнца, сар екх народо: сар амарэ мурша, сар и вонэ, авэна обчиндэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","На авэна ли тунчи лэндирэ гуртуря, барвалимо тай всаворо ското амарэнца? Тераґа кода, со вонэ пхэндэ, тай вонэ джювэна машкар амэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Всаворэ, ко стидэласпэ форохкирэндэ ударэндэ, допхэндэпэ Хамороґа тай лэхкирэ чявэґа Шэхемоґа, тай всаворэ мурша дэ форо сле обчиндэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Проджиле трин дивэ, кала вонэ сле дукхадэ насвалиматар, дуй Иаковохкирэ чявэ Симеоно тай Левиё, Динатирэ пхрала, лиле чюря, чютэпэ пэ форо тай умардэ всаворэн муршэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Вонэ умардэ чюряґа Хаморо тай лэхкирэ чявэ Шэхемо, залиле Дина Шэхемохкирэстар цэрэстар тай уджиле. ");
INSERT INTO rmyservi_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Иаковохкирэ чявэ заджиле умардэндэ тай обчёрдэ форо, тев асанепэ лэндирятар пхэнятар. ");
INSERT INTO rmyservi_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Вонэ залиле гуртуря баро тай хурдо ското, магарянэн — вса, со сля дэ форо и дэ мален, ");
INSERT INTO rmyservi_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","и всаворо лэндиро барвалимо, и чяворэн, и джювлен. И вса, со сля дэ цэрэн, вонэ залиле пэсти. ");
INSERT INTO rmyservi_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Тунчи Иаково пхэнда Симеоности тай Левиёсти: — Тумэ цырдэне пэ ман глаба, тердэ ман врыжыматорэґа важ кодэла, ко джювэл дэ кодэя пхув, ханаанеенди тай периззеенди. Амэн на кади бут, тай сар вонэ стидэна зора тай джяна пэ ман, тай мэ и муро цэр аваґа умардэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ай вонэ пхэндэ: — Хиба трэбуни сля кади тэ лиджял пэ амаряґа пхэняґа, сар лубняґа? ");
INSERT INTO rmyservi_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Дэвэл пхэнда Иаковости: — Ваздэпэ тай джя дэ Вефилё, джюв котэ тай стер котэ жэртвеннико Дэвлэсти, Саво сикавдапэ тути, кала ту нашлян тирэстар пхралэстар Исавостар. ");
INSERT INTO rmyservi_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Иаково пхэнда пэхкирэнди цэрутнэнди тай всаворэнди, ко сля лэґа: — Вычювэн аврэн дэвлэн, савэ тумэндэ пэґа, выжужарэнпэ тай парувэн пэхкири їда. ");
INSERT INTO rmyservi_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Тунчи стидэнпэ дэ дром, тай амэ джяґа дэ Вефилё, тев мэ стерава жэртвеннико Дэвлэсти, Саво дэня манди зор, кала мандэ сля глаба, и сля манца, тев бы мэ тэ на джяв. ");
INSERT INTO rmyservi_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Вонэ отдэне Иаковости всаворэн аврэн дэвлэн, савэ сле лэндэ, тай ченя канэндар, тай Иаково заґанавда лэн тала дубо дэ Шэхемо. ");
INSERT INTO rmyservi_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Тунчи вонэ джиле дэ дром, тай дар Дэвлэстар сля пэ всаворэ форуря, савэ сле пашэ лэн, кади со нико на нашэлас пала Иаковохкирэн чяворэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Иаково тай всаворэ, ко сля лэґа, авиле дэ Лузо (када исин Вефилё) дэ Ханаанско пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Котэ вов стерда жэртвеннико тай акхарда кодэва тхан «Эл Бет-Эл», пала када со котэ Дэвэл оттердапэ лэсти, кала вов нашля пэхкирэстар пхралэстар. ");
INSERT INTO rmyservi_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Девора, сави выправарда Ревека, муля, тай сля гаравди тала дубо пашэ Вефилёстар. Пала када вов сля акхардо «Аллон Бахут». ");
INSERT INTO rmyservi_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Кала Иаково рисиля Паддано-Арамостар, Дэвэл упалэ сикавдапэ лэсти тай бахталисарда лэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Дэвэл пхэнда лэсти: — Тиро лав Иаково, нэ екхатар ту на авэґа тэ акхарэпэ Иаковоґа. Лав тиро авэла «Израилё». Кади Вов акхарда лэ Израилё. ");
INSERT INTO rmyservi_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Дэвэл пхэнда лэсти: — Мэ — Дэвэл Всазорако. Терэн чяворэн, тай мэк тумэн авэла бут. Народо тай бут народуря, тхагаря джяна тутар. ");
INSERT INTO rmyservi_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Пхув, сави Мэ дэнём Авраамости тай Исаакости, Мэ отдава тути тай тирэнди чяворэнди. ");
INSERT INTO rmyservi_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Тунчи Дэвэл ваздэняпэ лэстар. ");
INSERT INTO rmyservi_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Иаково тховда баруно столбо пэ кова тхан, тев Дэвэл дэдуманя лэґа, тай чюта пэ лэстэ мол тай дзэто. ");
INSERT INTO rmyservi_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Иаково акхарда тхан, тев Дэвэл дэдуманя лэґа, Вефилё. ");
INSERT INTO rmyservi_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Вонэ ачявдэ Вефилё тай сле надур Эфрататар, кала Рахиль ачиля тэ бэянэ, тай сля лати фартэ пхаро. ");
INSERT INTO rmyservi_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Вой фартэ пхаро сля тэ бэянэ чяворэ, тай джювли, сави дэлас лати зор дэ када пхэнда лати: — На дар, тутэ авэла инте екх чяво. ");
INSERT INTO rmyservi_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Кала Рахиль мэрэлас, вой акхарда чявэ Бен-Они, нэ дад акхарда лэ Вениамино. ");
INSERT INTO rmyservi_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Рахиль муля тай сля гаравди, пэ дром, сар тэ джя дэ Эфрата (када и исин Вифлеемо). ");
INSERT INTO rmyservi_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Упрал, тев вой сля гаравди, Иаково тховда баруно столбо; кодэва бар ачел котэ и авдивэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Израилё джялас дурэдэр тай тховда катуна пала Мигдало-Эдеро. ");
INSERT INTO rmyservi_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Кала Израилё джювэлас дэ кодэя пхув, Рувимо сута пэхкирэ дадэхкиря наложницаґа Валлаґа, тай Израилё уджянгля пала када. Иаковостэ сля дэшудуй чявэн: ");
INSERT INTO rmyservi_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Лиятар: Рувимо (Иаковохкиро барэдэр чяво), Симеоно, Левиё, Иуда, Иссахаро тай Завулоно. ");
INSERT INTO rmyservi_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Рахилятар: Иосифо тай Вениамино. ");
INSERT INTO rmyservi_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Рахилятирятар копыльницатар Валлатар: Дано тай Неффалимо. ");
INSERT INTO rmyservi_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Лиятирятар копыльницатар Зелфатар: Гадо тай Асиро. Акэ чявэ Иаковохкирэ, савэ бэяндэпэ лэстэ дэ Паддано-Арамо. ");
INSERT INTO rmyservi_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Иаково авиля пэхкирэ дадэстэ Исаакостэ дэ Мамре, када пашэ Кирьят-Арбаґа (када и исин Хевроноґа), тев калась джюдэ Авраамо тай Исаако. ");
INSERT INTO rmyservi_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Всаворо джювимо Исаакохкиро сля 180 бэрша. ");
INSERT INTO rmyservi_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Исаако муля дэ баря пхурима, пхуро тай чяло джювимаґа, тай отджиля пэхкорэндэ дадэндэ. Лэхкирэ чявэ Исаво тай Иаково гаравдэ лэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Акэ роспхэндимо пала Исаво (вов жэ Эдомо) тай пала лэхкирэн чяворэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Исаво лиля пэсти ромнен Ханааностар: Ада, хеттеёхкиря Элонохкиря чя, Охоливама, Анахкиря чя и внучка хиввеёхкиря Цывеонохкиря, ");
INSERT INTO rmyservi_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ай кадиж Басемата, Измаилохкиря чя, пхэня Неваётохкиря. ");
INSERT INTO rmyservi_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ада бэянда Исавости Элифазо, Басемат бэянда Реуэло, ");
INSERT INTO rmyservi_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Охоливама бэянда Еушо, Яламо тай Корахо. Када чявэ Исавохкирэ, савэ бэяндэпэ лэсти дэ Ханаано. ");
INSERT INTO rmyservi_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Исаво лиля пэхкирэн ромнен, чявэн, чеен тай всаворэн цэрутнэн, лиля гуртуря, ското тай всаворо барвалимо, саво вов стидэня дэ Ханаано, тай пэрэджиля дэ авэр пхув пэ савось дуримос пэхкирэстар пхралэстар Иаковостар, ");
INSERT INTO rmyservi_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","пала када со лэндэ сля фартэ бут барвалимо, соб лэнди тэ авэ екхтханэ. Лэндэ сля скацик бут ското, со пхув, тев вонэ джювэнас, на выправарэлас лэн дуен. ");
INSERT INTO rmyservi_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Кади Исаво (вов жэ Эдомо) ачиля тэ джювэ дэ Сеиро паша плая. ");
INSERT INTO rmyservi_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Акэ роспхэндимо пала Исаво, дадэ эдомеендирэ, саво джювэлас дэ Сеиро паша плая, тай пала лэхкирэн чяворэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Акэ Исавохкирэ чявэндирэ лава: Элифазо, Исавохкиро чяво лэхкирятар ромнятар Адатар, тай Реуэло, Исавохкиро чяво лэхкирятар ромнятар Басемататар. ");
INSERT INTO rmyservi_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Элифазохкирэ чявэ: Темано, Омаро, Цэфо, Гатамо тай Кеназо. ");
INSERT INTO rmyservi_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Исавохкирэтэ чявэстэ Элифазостэ сля наложница, ла акхарэнас Тимна, сави бэянда лэсти Амалико. Када чявэ Исавохкиря ромнятэ Адатэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Реуэлохкирэ чявэ: Нахато, Зерахо, Шамма тай Мизза. Када чявэ Исавохкиря ромнятэ Басемататэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Исавохкирэ ромня Охоливама, Анахкири чей и внучка Цывеонохкири, бэянда Исавости Еушо, Яламо тай Корахо. ");
INSERT INTO rmyservi_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Акэ барэдэра машкар Исавохкирэндар чяворэндар. Акэ Элифазохкирэ чявэ, саво сля Исавохкиро англуно: барэдэр Темано, барэдэр Омаро, барэдэр Цэфо, барэдэр Кеназо, ");
INSERT INTO rmyservi_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","барэдэр Корахо, барэдэр Гатамо тай барэдэр Амалико. Када барэдэра Элифазохкирэ дэ Эдомо, када чявэ Адатирэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Чявэ Реуэлохкирэ, саво сля Исавохкиро чяво: барэдэр Нахато, барэдэр Зерахо, барэдэр Шамма тай барэдэр Мизза. Када барэдэра Реуэлохкирэ дэ Эдомо, када чявэ Басемататирэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Исавохкирэ чявэ лэхкирятар ромнятар Охоливаматар: барэдэр Еушо, барэдэр Яламо тай барэдэр Корахо. Када барэдэра, савэ бэяндэпэ Исавохкирятар ромнятар Охоливаматар, Анахкирятар чятар. ");
INSERT INTO rmyservi_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Акэ Исавохкирэ чявэ (вов жэ Эдомо) тай акэ лэндирэ барэдэра. ");
INSERT INTO rmyservi_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Акэ Сеирохкирэ хореёхкирэ чявэ, савэ джюдэ дэ кодэя пхув: Лотано, Шовало, Цывеоно, Ана, ");
INSERT INTO rmyservi_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Дишоно, Эцэро тай Дишано. Кадэла Сеирохкирэ чявэ дэ Эдомо сле барэдэра хореендирэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Лотанохкирэ чявэ: Хори, Хемамо тай Лотанохкири пхэнь Тимна. ");
INSERT INTO rmyservi_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Шовалохкирэ чявэ: Алвано, Манахато, Эвало, Шэфо тай Онамо. ");
INSERT INTO rmyservi_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Цывеонохкирэ чявэ: Айя тай Ана. Када кодэва Ана, саво оттерда дэ шуки пхув пхабардо пани, кала чяравэлас пэхкирэ дадэхкирэ Цывеонохкирэн магарен. ");
INSERT INTO rmyservi_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Анахкирэ чяворэ: Дишоно тай Охоливама, Анахкири чей. ");
INSERT INTO rmyservi_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Дишанохкирэ чявэ: Хемдано, Эшбано, Йитрано тай Керано. ");
INSERT INTO rmyservi_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Эцэрохкирэ чявэ: Билхано, Заавано тай Акано. ");
INSERT INTO rmyservi_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Дишанохкирэ чявэ: Уцо тай Арано. ");
INSERT INTO rmyservi_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Акэ барэдэра хореендирэ: Лотано, Шовало, Цывеоно, Ана, ");
INSERT INTO rmyservi_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Дишоно, Эцэро тай Дишано. Вонэ сле барэдэра хореендирэ пав лэндири порода дэ пхув Сеиро. ");
INSERT INTO rmyservi_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Акэ тхагаря, савэ сле дэ Эдомо, инте дыкалэ, сар дэ Израилё сле тхагаря: ");
INSERT INTO rmyservi_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Бела, Беорохкиро чяво, сля тхагари дэ Эдомо. Лэхкиро форо акхарэласпэ Динхава. ");
INSERT INTO rmyservi_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Сар Бела муля, тхагареґа ачиля Йоваво, Зерахохкиро чяво, Боцратар. ");
INSERT INTO rmyservi_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Сар Йоваво муля, тхагареґа ачиля Хушамо теманитянэндирятар пхуятар. ");
INSERT INTO rmyservi_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Сар Хушамо муля, тхагареґа ачиля Хададо, Бедадохкиро чяво, саво розмарда мидьянитянонэн дэ пхув Моавохкири. Лэхкиро форо акхарэласпэ Авито. ");
INSERT INTO rmyservi_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Сар Хададо муля, тхагареґа ачиля Самла Масрекатар. ");
INSERT INTO rmyservi_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Сар Самла муля, тхагареґа ачиля Сауло Реховотостар, со паша лэнь. ");
INSERT INTO rmyservi_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Сар Сауло муля, тхагареґа ачиля Баал-Ханано, Ахборохкиро чяво. ");
INSERT INTO rmyservi_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Сар Баал-Ханано, Ахборохкиро чяво, муля, тхагареґа ачиля Хададо. Лэхкиро форо акхарэласпэ Пау, ай лэхкиря ромня акхарэнас Мехетавель, чей Матредохкири, внучка Ме-Захавохкири. ");
INSERT INTO rmyservi_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Акэ лава барэдэрэн — Исавохкирэн потомконэн, пав лэндирэ лава, породы тай пхуя. Тимна, Алва, Етето, ");
INSERT INTO rmyservi_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Охоливама, Эла, Пиноно, ");
INSERT INTO rmyservi_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Кеназо, Темано, Мивцаро, ");
INSERT INTO rmyservi_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Мигдаэло тай Ирамо. Када барэдэра Эдомохкирэ, пав тханэн, тев джюдэ, дэ пхув, сави вонэ лиле. Када сля Исаво — эдомитянэндиро дар. ");
INSERT INTO rmyservi_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Иаково джювэлас дэ кодэя пхув, тев джюда лэхкиро дад, дэ пхув Ханаано. ");
INSERT INTO rmyservi_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Акэ роспхэндимо пала Иаково тай пала лэхкирэн чяворэн. Иосифо, савэсти сля душуефта бэрш, чяравэлас гуртуря бакрэн екхтханэ пэхкирэнца пхралэнца — Валлатирэнца тай Зелфатирэнца чявэнца. Иософо роспхэнэлас дадэсти врытимо пала пхралэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Израилё камэлас Иосифо будэр всаворэн аврэн чявэн, пала када со вов сля бэяндо лэсти дэ пхурима. Вов кадиж стерда важ лэсти барвали шукар їда. ");
INSERT INTO rmyservi_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Кала пхрала удыкхле, со дад камэл лэ будэр, сар аврэн, вонэ камле лэсти врытимо тай на дэдумане лэґа лачимаґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Екхфар Иосифо дыкхля суно. Вов роспхэнда пала лэ пхралэнди, тай вонэ закамле лэсти врытимо инте будэр. ");
INSERT INTO rmyservi_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Акэ со вов пхэнда лэнди: — Пошунэнти, саво манди авиля суно. ");
INSERT INTO rmyservi_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Амэ пхандэґас снопуря дэ маля, тай муро снопо подлиляпэ тай састиля, ай тумарэ снопуря ачиле всаворэ ригэндар тай тэлиле. ");
INSERT INTO rmyservi_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Пхрала пхэндэ лэсти: — Чи на тхагареґа ту авэґа амэндэ? Чи амэ аваґа тут тэ кандэ? Тай вонэ камэнас лэсти врытимо инте будэр пала лэхкиро суно тай пала кадэва роспхэндимо. ");
INSERT INTO rmyservi_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Иосифости авиля инте екх суно, тай вов упалэ роспхэнда пала лэ пхралэнди: — Пошунэнти, манди авиля инте екх суно: пэ кадэва моло манди тэлиле кхам, чён тай дэшуекх чергэня. ");
INSERT INTO rmyservi_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Вов роспхэнда суно на кацик пхралэнди, ай и дадэсти, тай дад выпхэнда лэсти: — Со када за суно тутэ авиля? Со када, мэ, дэй тири тай пхрала тирэ чяче аваґа тай тэлюваґа тути ды пхув? ");
INSERT INTO rmyservi_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Пхрала холявэнас пэ лэстэ, ай дад зарипирда кадэя дума. ");
INSERT INTO rmyservi_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Пхрала уджиле тэ чяравэ дадэхкирэ гуртуря пашэ Шэхемо, ");
INSERT INTO rmyservi_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","тай Израилё пхэнда Иосифости: — Ту джянэх, со тирэ пхрала чяравэн гуртуря пашэ Шэхемо. Мэ камав тэ бичялэ тут лэндэ. — Мэ джява, — пхэнда Иосифо. ");
INSERT INTO rmyservi_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Дад пхэнда лэсти: — Джя, подыкх, вса мишто тирэнца пхралэнца тай гуртонэнца. Тунчи авэґа и пхэнэґа манди. Вов када прэпхэнда дэ Хевронохкири маля, тай Иосифо джиля дэ Шэхемо. ");
INSERT INTO rmyservi_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Котэ вов родэлас лэн дэ мален, покы екх мануш дыкхляпэ лэґа тай пхучля лэстар: — Со родэх ту? ");
INSERT INTO rmyservi_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Вов пхэнда: — Мэ родав мурэн пхралэн. Мангав тут, пхэн манди, тев вонэ чяравэн пэхкирэ гуртуря? ");
INSERT INTO rmyservi_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","— Вонэ уджиле катар, — пхэнда кодэва мануш. — Мэ шундом, сар вонэ пхэнэнас: «Джяґа дэ Дотано». Иосифо джиля пала пхралэн тай аракхля лэн Дотаностэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Вонэ удыкхле лэ дурал тай дыкалэ, сар вов тэ поджял лэндэ, допхэндэпэ тэ умарэ лэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","— Акэ джял кадэва, ко дыкхэл сунэ! — пхэндэ вонэ екх екхэсти. ");
INSERT INTO rmyservi_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","— Умараґа лэ тай чюваґа лэ дэ шуко ханинг, ай дадэсти пхэнаґа, со лэ схаля дыко зверё. Тунчи подыкхаґа, со выджяла лэхкирэ сунэндар. ");
INSERT INTO rmyservi_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Нэ Рувимо ушунда тай фирисарда лэ лэндар. Вов пхэнда: — Нат, на аваґа лэ тэ умарэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Вов допхэнда: — На прочювэн рат. Чюваґа лэ дэ кадэва ханинг катэ, дэ шуки пхув, кацик на ваздэн пэ лэстэ васт. Рувимо камля тэ фирисарэ лэ лэндар тай тэ рисявэл вов дадэстэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Кала Иосифо поджиля пхралэндэ, вонэ счиндэ лэстар їда, кодэя барвали шукарни їда, со сля пэ лэстэ, ");
INSERT INTO rmyservi_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","тай чютэ лэ дэ ханинг. Ханинг сля шушо, би панехкиро. ");
INSERT INTO rmyservi_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Вонэ бэшле тэ ха тай удыкхле: измаильтянуря джян Галаадостар. Лэндирэ верблюдуря сле зачютэ пхаримаґа спецыенца, бальзамоґа тай мираґа, савэ вонэ лиджянас дэ Египто. ");
INSERT INTO rmyservi_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Иуда пхэнда пхралэнди: — Со амэнди колэстар, сар амэ умараґа амарэ пхралэ тай сгараваґа када? ");
INSERT INTO rmyservi_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Фэдэр битинаґа лэ измаильтянэнди тай на аваґа тэ ваздэ пэ лэстэ васт. Вов жэ амаро пхрал, амаро рат, амэ екхэ масэстар. Пхрала кангле лэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Кала битинимаря Мидьяностар проджянас пашэ, пхрала доросле Иосифо ханингатар тай битиндэ измаильтянонэнди пала биш рупунэ шэкиля. Измаильтянуря лиле лэ дэ Египто. ");
INSERT INTO rmyservi_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Кала Рувимо рисиля ханингатэ, вов удыкхля, со Иосифо котэ нинай, тай росчинда пэхкири їда. ");
INSERT INTO rmyservi_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Вов рисиля пхралэндэ тай пхэнда: — Чяворэ котэ нинай! Тев манди кана тэ джя? ");
INSERT INTO rmyservi_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Тунчи вонэ лиле їда Иосифохкири, зачиндэ бузнэ тай вымакхле їда дэ рат. ");
INSERT INTO rmyservi_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Котар вонэ отлиджялдэ барвали шукарни їда дадэсти тай пхэндэ: — Акэ со амэ аракхле. Подыкх, када їда на тирэ чявэхкири? ");
INSERT INTO rmyservi_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Вов уджянгля ла тай затиписиля: — Када їда мурэ чявэхкири! Лэ схаля дыко зверё! Чяче, Иосифо сля розчиндо пэ котора! ");
INSERT INTO rmyservi_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Иаково розчинда їда пэ пэстэ, обпхангля кущик їдаґа, сави гонэндар, тай бут дивэ ровэлас пала чявэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Всаворэ лэхкирэ чявэ тай чея авиле тэ анэ пачя лэсти, ай вов отпхэнэласпэ пачятар, пхэнэлас: — Нат, мэ кади глабатар джява дэ мулэндири люмля, мурэстэ чявэстэ! Кади дад ровэлас пала пэхкиро чяво. ");
INSERT INTO rmyservi_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ай мидьянитянуря кодэя врямаґа битиндэ Иосифо дэ Египто Потифарости, саво сля фараоностэ барэдэра пэ халавдэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Дэ кодэя вряма Иуда ачявда пхралэн тай ачиля тэ джювэ екхэстэ манушэстэ, савэ акхарэнас Хира Адулламостар. ");
INSERT INTO rmyservi_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Котэ Иуда удыкхляпэ ханаанеёхкиря чя, савэ акхарэнас Шуа. Вов лиля ла дэ ромнен тай ачиля лаґа тэ джювэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Вой ачиля пхари тай бэянда чявэ тай акхарда лэ Эро. ");
INSERT INTO rmyservi_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Вой инте ачиля пхари тай бэянда чявэ и акхарда лэ Онано. ");
INSERT INTO rmyservi_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Вой бэянда инте екхэ чявэ тай акхарда лэ Шэла. Вой бэянда лэ дэ Кезиво. ");
INSERT INTO rmyservi_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Иуда лиля важ пэхкирэ барэдэр чявэ Эро ромня, ла акхарэнас Тамарь. ");
INSERT INTO rmyservi_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Эро, барэдэр чяво Иудахкиро, сля бэзэхало дэ якхэн РАЕХКИРЭН, тай РАЙ умарда лэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Тунчи Иуда пхэнда Онаности: — Тути трэбуни тэ совэх тирэ пхралэхкиря ромняґа, кади сар ту исин пхрал латирэ ромэсти: трэбуни тэ стерэх чяворэ важ тиро пхрал. ");
INSERT INTO rmyservi_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Нэ Онано джянэлас, со чяворэ авэна на лэхкирэ, тай кала совэлас пэхкирэ пхралэхкиря ромняґа, вов счювэлас пэ пхув, соб тэ на стерэ чяворэн важ пэхкиро пхрал. ");
INSERT INTO rmyservi_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Када, со вов терэлас, дэ РАЕХКИРЭН якхэн сля бэзэхало, пала када Вов умарда и Онано. ");
INSERT INTO rmyservi_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Тунчи Иуда пхэнда Тамаряти, боряти пэхкиряти: — Джюв, сар пхивли, дэ тирэ дадэхкиро цэр, покы на выбарёла муро чяво Шэла. Вов думисарэлас: «Сар бы и Шэла тэ на мэрэл, сар лэхкирэ пхрала». Тамарь джиля тэ джювэ дэ дадэхкиро цэр. ");
INSERT INTO rmyservi_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Проджиля бут вряма. Иудахкири ромни, Шуахкири чей, муля. Кала Иуда заджиля дэ пачя глабатар, вов джиля дэ Тимна манушэндэ, савэ подчинэлас бала лэхкирэ бакрэндирэ. Лэхкиро амало адулламитянино Хиро джиля лэґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Тамаряти пхэндэ: — Тиро састро джял дэ Тимна тэ подчинэ бала пэхкирэнди бакрэнди. ");
INSERT INTO rmyservi_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Вой злиля пхивликани їда, чюта пэ пэстэ ушардо, соб ла тэ на уджянэн, тай бэшла пашэ удара дэ Энаимо, саво пэ дром дэ Тимна, пала када со вой дыкхля, со Шэла выбариля и ла на отдэн лэсти дэ ромнен. ");
INSERT INTO rmyservi_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Кала Иуда удыкхля ла, вов думисарда, со када лубни, пала када со латиро муй сля затердо їдаґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Вов порисарда дромэстар латэ тай пхэнда: — Джям, дэ мэ пэрава туґа. Вов на джянэлас, со када лэхкири бори. Вой пхучля: — Со ту дэґа манди, соб тэ совэ манца? ");
INSERT INTO rmyservi_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Вов пхэнда: — Мэ бичялава тути бузнорэ мурэстар гуртостар. Вой пхучля: — Ай ту дэґа манди сось пэ вряма, сар на бичялэґа бузнорэ? ");
INSERT INTO rmyservi_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Вов пхэнда: — Со тэ дэ тути? Вой пхэнда: — Тири цол пэ ланчюго тай дэсто, саво тутэ дэ вастэ. Вов дэня лати када вса тай сута лаґа, и вой ачиля лэстар пхари. ");
INSERT INTO rmyservi_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Кала вов уджиля котар, вой злиля кадэя їда тай упалэ урявда пхивликани їда. ");
INSERT INTO rmyservi_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Дэ кодэя вряма Иуда бичялда пэхкирэ амалэґа адулламитяниноґа бузнорэ, соб тэ залэ павпалэ када, со колатэ джювлятэ, нэ амал на аракхля ла. ");
INSERT INTO rmyservi_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Вов пхучля катутнэндэ манушэндэ: — Тев исин кодэя лубни, сави бэшэлас пашэ дром дэ Энаимо? Вонэ пхэндэ: — Катэ на сля нисави лубни. ");
INSERT INTO rmyservi_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Вов рисиля Иудастэ тай пхэнда: — Мэ на аракхлём ла, тай мануша колэстар тханэстар пхэндэ: «Катэ на сля нисави лубни». ");
INSERT INTO rmyservi_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Иуда пхэнда: — Мэк ачявэла пэсти кода, со лиля, соб тэ на асанпэ амэндар мануша. Мэ бичялавас лати бузнорэ, кацик ту на аракхлян ла. ");
INSERT INTO rmyservi_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Проджиля чёна трин, и Иудасти пхэндэ: — Тири бори Тамарь терда бэзэх тай ачиля пхари. Иуда пхэнда: — Вылиджян тай спхабарэн ла! ");
INSERT INTO rmyservi_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Нэ кала ла вылиджянас, вой бичялда састрэстэ кацавэнца лавэнца: — Мэ пхари колэ манушэстар, кахкиро вса када. Инте вой пхэнда: — Подыкх, на уджянэх, кахкири кадэя цол, ланчюго тай дэсто? ");
INSERT INTO rmyservi_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Иуда уджянгла лэн тай пхэнда: — Вой май чячюни мандар, пала када со мэ на отдэнём ла пала муро чявэ Шэла. Будэр вов на совэлас лаґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Кала авиля латиро вряма тэ бэянэ, латэ дэ води сле дуй чяворэ блезняшкуря. ");
INSERT INTO rmyservi_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Кала вой бэянэлас, екх лэндар вычюта васт. Тунчи джювли, сави дэлас лати зор дэ када, лиля лоли тхав, запхангля лэсти пэ васторо тай пхэнда: — Кадэва выджиля англуно. ");
INSERT INTO rmyservi_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Нэ вов зацырда васт павпалэ, тай выджиля лэхкиро пхрал. Тунчи вой пхэнда: — Сар када ту прочинданпэ англунэґа? Тай лэ акхардэ Парецо. ");
INSERT INTO rmyservi_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Тунчи выджиля и кодэва, савэстэ пэ васторо сля лоли тхав, тай лэсти дэне лав Зерахо. ");
INSERT INTO rmyservi_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Иосифо андэ дэ Египто, тай египтянино Потифаро, саво сля рай фараоностэ и барэдэр халавдо, тинда Иосифо измаильтянонэндэ, савэ пордэ лэ андэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","РАЙ сля Иосифоґа. Лэстэ сля вса фартэ мишто, тай вов джювэлас да пэхкирэстэ египетсконэстэ раестэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Лэхкиро рай удыкхля, со РАЙ сля Иосифоґа тай со Вов дэл лэсти бахт дэ вса, со вов терэл. ");
INSERT INTO rmyservi_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Иосифо аракхля лачимо дэ лэ лэхкирэн якхэн тай ачиля пашутнэґа копылеґа. Потифаро тховда лэ барэдэрэґа дэ пэхкиро цэр и отдэня лэсти всаворо хулаимо. ");
INSERT INTO rmyservi_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Кола вряматар, сар вов тховда лэ барэдэрэґа дэ пэхкиро цэр и пэ всаворо хулаимо, РАЙ бахталисарда египтянонэхкиро цэр пала Иосифо. Дэвлэхкиро бахталисаримо сля пэ вса, со сля Потифаростэ: и дэ цэр, и дэ маля. ");
INSERT INTO rmyservi_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Пала када вов отдэня Иосифости вса, со сля лэстэ. Вов ни пала со на думисарэлас, сар кацик тэ ха. Иосифо сля лачё пэґа тай шукарно. ");
INSERT INTO rmyservi_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Проджиля савись вряма, тай ромни лэхкирэ раехкири ачиля тэ задыкхэпэ пэ лэстэ и пхэнда: — Сов манца! ");
INSERT INTO rmyservi_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Вов отпхэнда: — Англа ман муро рай ни пала со на думисарэл дэ цэр. Вса, со исин лэстэ, вов отдэня манди. ");
INSERT INTO rmyservi_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Дэ кадэва цэр мэ барэдэр. Муро рай на отпхэнда манди ни дэ со, кацик тут, пала када со ту — лэхкири ромни. Сар жэ мэ терава кацаво баро врытимо тай бэзэх англа Дэвлэ? ");
INSERT INTO rmyservi_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Вой дэдумэлас лэґа пала када диво дивэстар, вов отпхэнэласпэ тэ совэ лаґа тай тэ авэ пашэ латэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Екхвар вов заджиля дэ цэр пав пэхкиро рындо, кала ника цэрутнонэн на сля дэ цэр. ");
INSERT INTO rmyservi_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Вой схутилда лэ пала їда тай пхэнда: — Сов манца! Ай вов вычиндапэ тай унашля, ачявда упраруни їда латэ дэ вастэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Кала вой удыкхля, со вов унашля и ачявда їда латэ дэ вастэн, ");
INSERT INTO rmyservi_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","вой акхарда цэрутнонэн копылен тай пхэнда лэнди: — Дыкхэн, кадэлэ евреё андэ амэндэ дэ цэр, ай вов асалпэ амэндар! Вов авиля кордэ тай камля тэ совэ манца, ай мэ ачилём тэ типисявэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Мурятар типисявиматар вов ачявда пэхкири їда тай нашля. ");
INSERT INTO rmyservi_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Вой рицарда Иосифохкири їда пэстэ, покы на авиля цэрэ латиро хулай. ");
INSERT INTO rmyservi_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Вой роспхэнда лэсти кодэва жэ роспхэндимо: — Кадэва копыли-евреё, савэ ту андан амэндэ, авиля мандэ тай камля тэ асапэ мандар. ");
INSERT INTO rmyservi_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ай мэ ачилём тэ типисявэ, тай вов нашля и ачявда мандэ пэхкири їда. ");
INSERT INTO rmyservi_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Кала Иосифохкиро рай шунда роспхэндимо ромнятиро, сави пхэнда: «Акэ сар тиро копыли обджиляпэ манца», вов фартэ холиля. ");
INSERT INTO rmyservi_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Вов лиля Иосифо и чюта лэ дэ баруно, тев бэшэнас тхагарехкирэ барунаря. Тай акэ кади Иосифо ачиля тэ бэшэ дэ баруно. ");
INSERT INTO rmyservi_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Нэ РАЙ сля лэґа; Вов сикавда лэсти мила и дэня лачимо дэ якхэн барэдэрэ барунэхкиро. ");
INSERT INTO rmyservi_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Барунэхкиро барэдэр тховда Иосифо барэдэрэґа пэ всаворэ барунаря, тай вов дыкхэлас пала всаворэ рындуря дэ барунэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Барунэхкиро барэдэр на дыкхэлас пала кода, со сля отдино Иосифости, пала када со РАЙ сля Иосифоґа тай дэлас лэсти бахт дэ всаворэ рындуря. ");
INSERT INTO rmyservi_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Кала проджиля набут вряма, молымари тай пэклимари, тхагарехкирэ бутярнэ, тердэ дош англа пэхкиро рай, Египетско тхагари. ");
INSERT INTO rmyservi_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Фараоно фартэ холиля пэ дуен пэхкирэн пашутнэн, пэ барэдэрэ молымаре тай пэ барэдэрэ пэклимаре, ");
INSERT INTO rmyservi_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","тай чюта лэн дэ баруно, тев сля цэр барэдэрэхкиро халавдэхкиро, пордэ жэ, тев бэшэл Иосифо. ");
INSERT INTO rmyservi_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Барэдэр халавдо отдэня лэн Иосифости, тай кодэва терэлас бути пэ лэндэ. Вонэ сле котэ савось вряма, ");
INSERT INTO rmyservi_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","тай акэ лэнди дуенди — молымарести тай пэклимарести тхагаре Египетско, савэ бэшэнас дэ барунэ, — дэ екх рат авиле сунэ, тай кожно суно дэдуманя пэхкиро. ");
INSERT INTO rmyservi_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Кала жэ дэнзор Иосифо авиля лэндэ, вов удыкхля, со лэндири годи сось тасавэл. ");
INSERT INTO rmyservi_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Вов пхучля фараонохкирэн пашутнэн, савэ сле екхтханэ лэґа дэ екх цэр лэхкирэ раехкиро: — Сости тумэ авдивэ заровинэ пэ муй? ");
INSERT INTO rmyservi_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","—Амэнди дуенди авиле сунэ, — пхэндэ вонэ, — тай тэ ґатярэ лэн никасти. Иосифо пхэнда лэнди: — Со ґатяримо на Дэвлэстар? Роспхэнэн манди тумарэ сунэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Тунчи барэдэр молымари роспхэнда Иосифости пэхкиро суно: — Мэ дыкхлём дэ сунэ рандь дракостар, ");
INSERT INTO rmyservi_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","тай патар выджянас трин рандя. Тай кацик сикавдэпэ почки, вой розмукхляпэ тай лулудя тердэпэ дракоґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Мандэ дэ вастэ сля фараонохкиро тахтаё. Мэ лилём драко, вытасавдом дэ тахтаё тай подэнём дэ васт фараонохкиро. ");
INSERT INTO rmyservi_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","— Акэ со када, — пхэнда лэсти Иосифо. — Трин рандя — када трин дивэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Проджяна трин дивэ, тай фараоно ваздэла тут. Вов рисарэла тут пэ тири тхан, тай ту подэґа фараоности лэхкиро тахтаё, сар дыкалэ, кала ту подэґас лэсти мол. ");
INSERT INTO rmyservi_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Тунчи кала тутэ вса мишто авэла, манґав тут, взрапир пала ман тай тер манди мила: пхэн пала ман фараоности, соб тэ вылэ ман барунэстар. ");
INSERT INTO rmyservi_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ман жэ зораґа улиджялдэ еврейсконатар пхуятар, тай катэ мэ кадиж на тердом нисо кацаво, соб тэ бэшэ дэ баруно. ");
INSERT INTO rmyservi_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Кала барэдэр пэклимари удыкхля, со Иосифо мишто роспхэнда суно, вов пхэнда Иосифости: — Манди кадиж авиля суно: мэ рицаравас пэ шэро трин корзыны мандрэґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Дэ упралуни сля выпэклимо фараоности, нэ ла ханас чирикля корзынатар, сави сля пэ муро шэро. ");
INSERT INTO rmyservi_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","— Акэ со када, — пхэнда Иосифо. — Трин корзыны — када трин дивэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Проджяна трин дивэ, тай фараоно ваздэла и тут кадиж: тути отчинэна шэро, ай тиро трупо абмлавэна пэ рандь, тай чирикля авэна тэ ха лэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Пэ трито диво, пэ диво, кала бэяндапэ фараоно, вов терда пиро важ всаворэ лэхкирэ рая. Англа лэндэ вов ваздэня барэдэрэ молымаре тай барэдэрэ пэклимаре. ");
INSERT INTO rmyservi_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Барэдэрэ молымаре вов рисарда пэ лэхкиро тхан, тай кодэва упалэ подэня тахтаё дэ фараонохкиро васт. ");
INSERT INTO rmyservi_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Ай барэдэрэ пэклимаре амблавдэ пэ рандь, сар Иосифо и пхэнда лэнди. ");
INSERT INTO rmyservi_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Нэ барэдэр молымари на взрапирда пала Иосифо; вов бистарда пала лэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Проджиля дуй бэрш, тай фараоности авиля суно: вов ачелас пэ брэго Нилохкиро, ");
INSERT INTO rmyservi_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","тай акэ лэнятар подлилепэ ефта гурувнен — лаче тай тхулэ — тай ачиле тэ чяравэпэ дэ тростниконэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Пала лэндэ выджиле Нилостар авэр ефта гурувня — тишлэ тай фартэ нашукарнэ — тай ачиле пашэ колэнца пэ брэго лэнятиро. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Тай тишлэ, нашукарнэ гурувня схале ефта лачен, тхулэн гурувнен. Катэ фараоно джюнгавдапэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Вов засута упалэ, тай лэстэ авиля авэр суно: ефта колосуря — зоралэ тай тхулэ — барёнас пэ екх стеблё. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Пала лэндэ выбариле инте ефта колосуря — тишлэ тай обпхабардэ восточнонаґа балваляґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Тишлэ колосуря накхадэ ефта зоралэн, тхулэн колосонэн. Катэ фараоно джюнгавдапэ. Када сля суно. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Дэнзор вов фартэ пэрэджювэлас пала сунэ. Вов акхарда всаворэн врэжымарен тай годявэрнэн дэ Египто тай роспхэнда лэнди пэхкирэ сунэ, нэ нико лэндар на роспхэнда, со пхэнэн сунэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Тунчи барэдэр молымари пхэнда фараоности: — Кана мэ взрапирав, со тердом дош. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Екхвар фараоно холиля пэ пэхкирэн копылен тай тховда ман тай барэдэрэ пэклимаре дэ барунэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Тай манди, тай лэсти дэ екх рат авиля суно, тай дэ кажно суно пэхкири годи. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Котэ амэнца сля тэрно евреё, барэдэрэхкиро халавдэхкиро копыли. Амэ роспхэндэ лэсти амарэ сунэ, тай вов роспхэнда пала лэн амэнди; кажнонэсти пэхкиро роспхэндимо. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","И сар вов роспхэнда, кади вса и выджиля: ман рисардэ павпалэ пэ муро тхан, ай колэ амблавдэ пэ рандь. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Фараоно бичялда пала Иосифо, тай лэ сиго андэ барунэстар. Вов подчинда бала, парувда їда тай ачиля англа фараоно. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Фараоно пхэнда Иосифости: — Мэ дыкхлём суно, тай нико на ґалёлас тэ роспхэнэ, со кадэва суно пхэнэл. Нэ мэ шундом пала тут, со ту полэх сунэ тай ґалёх тэ роспхэнэ пала лэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Иосифо пхэнда: — На мэ, Дэвэл дэла фараоности роспхэндимо дэ лачима. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Фараоно пхэнда Иосифости: — Мэ дыкхлём, со мэ ачяв пэ брэго Нилохкиро, ");
INSERT INTO rmyservi_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","тай акэ, выджян лэнятар ефта гурувня, лаче тай тхулэ, тай ачиле тэ чяравэпэ дэ тростниконэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Пала лэндэ подлилепэ ефта аврэн гурувнен — тишлэ, пэ лэндэ душонас кокаля, кацавэ нашукарнэ, савэн мэ на дыкхлём дыкалэ никала дэ всавори пхув Египто. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Тунчи тишлэ, нашукарнэ гурувня схале ефта тхулэн гурувнен, савэ выджиле англал. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Вонэ заджиле лэнди дэ води, кацик када на душолос: вонэ ачилепэ кацавэ жэ нашукарнэ, сар дыкалэ. Катэ мэ джюнгавдомпэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Тунчи мэ дыкхлём дэ сунэ ефта колосуря пэ екх стеблё, пхэрдэ лаче ворзоґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Пала лэндэ выбариле авэр ефта колосуря — шукэ, тишлэ тай обпхабардэ восточнонаґа балваляґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Тишлэ колосуря накхавдэ ефта пхэрдэн колосонэн. Мэ роспхэндом врэжымаренди, нэ нико на сґалювда тэ роспхэнэ пала лэн манди. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Иосифо пхэнда фараоности: — Дэ кадэлэн сунэн фараонохкирэн екх годи. Дэвэл оттерда фараоности, со Вов стидэлпэ тэ терэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Ефта лачен гурувнен — када ефта бэрша, тай ефта лачен колосонэн — када кадиж ефта бэрша; када екх суно. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ефта тишлен, нашукарнэн гурувнен, савэ авиле пала лэнди, — када ефта бэрша, тай кадиж ефта тишлэ колосуря, обпхабардэ восточноняґа балваляґа, — када ефта бокхалэ бэрша. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Акэ, со мэ рицаравас дэ годи, кала пхэндом фараоности, со Дэвэл оттерда лэсти, со Вов камэл тэ терэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Дэ Египетско пхув авэн ефта барвалимакхирэ бэрша. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Ай пала лэндэ джяна ефта бокхалэ бэрша, кала всаворо барвалимо дэ Египто авэла бистардо, тай бокх шушарэла пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Барвалимо дэ пхув бистарэлапэ пала бокх, саво джяла пала лэстэ, пала када со бокх авэла фартэ зорали. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Тай кода, со суно авиля фараоностэ дувар, када Дэвэл састэ камэл када сиго тэ терэ тай сиго вса стерэла. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Мэк жэ фараоно аракхэла годявэрнэ манушэ тай тховэла лэ барэдэрэґа пэ Египетско пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Мэк фараоно тховэла раен пэ всавори пхув, соб вонэ тэ стидэн панчто котор дэ вса, со дэла пхув дэ Египто дэ кодэла ефта барвалимакхирэ бэрша. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Мэк дэ кодэла лаче бэрша вонэ стидэн всаворо хамо, со авэл лэндэ, тай мэк фараонохкирэстар лавэстар стидэн ворзо тай фирисарэн лэ дэ форуря. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Кадэва хамо авэла тэ пашлё, соб пхув тэ на хасявэл дэ кодэла ефта бокхалэ бэрша, савэ авэна тунчи дэ Египто. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Фараоности тай лэхкирэнди пашутнэнди чялиля кадэя дума. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Фараоно пхучля пэхкирэн пашутнэн: — Аракхаґа амэ инте кацавэ, сар кадэва мануш, дэ савэ Фано Дэвлэхкиро? ");
INSERT INTO rmyservi_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Тай фараоно пхэнда Иосифости: — Сар Дэвэл оттерда тути вса када, нинай ника годявэрнэ тутар. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Мэ тховав тут барэдэрэґа дэ муро цэр, тай всаворэ мурэ мануша авэна тэ кандэпэ тут, вса, со ту пхэнэґа. Кацик мурэґа троноґа мэ авава вучидэр тутар. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Фараоно пхэнда Иосифости: — Дыкх, мэ тховав тут барэдэрэґа дэ всавори Египетско пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Вов злиля наестар пэхкири ангрусни цолаґа тай урявда пэ най Иосифости, урявда лэ дэ сани полотностар їда тай амблавда лэсти пэ кор сувнаконо ланчюго. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Вов прыпхэнда тэ пхиравэн лэ дэ вурдон, сар дуйтонэ пала пэстэ, тай тэ типисявэ англа лэстэ: «Аврех!» Кади вов тховда лэ пэ всавори пхув Египто. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Фараоно пхэнда Иосифости: — Мэ фараоно, нэ би тирэ лавэско нико дэ всаворо Египто нисо на терала ни вастэґа, ни пурэґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Фараоно дэня Иосифости лав Цафнато-Панеахо тай отдэня лэсти дэ ромнен Асната, Потиперахкиря чя. Потипера сля рашаи дэ форо Оно. Тай Иосифо лагля дэ дром пав всавори пхув Египто. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Иосифости сля трянда бэрш, кала вов ачиля тэ терэ бути пэ фараоно, тхагаре Египетсконэ. Вов выджиля фараоностар тай джиля дэ дром пав всаворо Египто. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Дэ ефта барвалимакхирэ бэрша пхув анэлас лачё урожаё. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Иосифо стидэлас всаворо урожаё дэ кодэла ефта бэрша барвалима дэ Египто тай стховэлас лэ дэ форуря. Дэ кажно форо вов стховэлас урожаё пашутнэндар малендар. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Иосифо кади бут стидэня ворзо, сар тишай дэ море. Вов пэрэачиля тэ бинэ лэ, пала када со нико на сґалёлас тэ пробинэ лэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Англа када, сар авиле бокхалэ бэрша, Иосифостэ бэяндэпэ дуй чявэ Аснататар, Потиперахкиря чя, саво сля рашаи дэ форо Оно. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Иосифо акхарда пэхкирэ пхурэдэрэ чявэ Манассиё. Вов пхэнда: «Дэвэл дэня манди тэ бистарэ всавори глаба и мурэ дадэхкиро цэр». ");
INSERT INTO rmyservi_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Дуйтонэ чявэ вов акхарда Ефремо. Вов пхэнда: «Дэвэл дэня манди чяворэн дэ пхув муря дукхатири». ");
INSERT INTO rmyservi_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ефта барвалимахкирэ бэрша дэ Египто проджиле, ");
INSERT INTO rmyservi_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","тай авиле ефта бокхалэ бэрша, сар и пхэнэлас Иосифо. Бокх сля дэ аврэн всаворэн пхуен, кацик дэ Египетско пхув сля хамо. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Кала всаворо Египто ачиля тэ бокхавэл, мануша ачиле тэ мангэ фараоностэ пала хамо, тай фараоно пхэнда египтянонэнди: — Джян Иосифостэ тай терэн, сар вов пхэнэла. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Кала бокх розджиляпэ пав всавори пхув, Иосифо оттерда складуря тай ачиля тэ битинэ ворзо египтянонэнди. Бокх дэ Египто сля зорали. ");
INSERT INTO rmyservi_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Мануша авэнас дэ Египто всаворэндар тханэндар, соб тэ тинэ Иосифостэ ворзо, пала када со бокх сля зорали пав всавори люмля. ");
INSERT INTO rmyservi_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Кала Иаково уджянгля, со дэ Египто исин ворзо, вов пхэнда чявэнди: — Со тумэ дыкхэн екх пэ екх? ");
INSERT INTO rmyservi_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Мэ шундом, со дэ Египто исин ворзо. Джян тай тинэн лэ котэ важ амэн, соб амэ тэ выджювах тай тэ на мэрах. ");
INSERT INTO rmyservi_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Дэш пхрала Иосифохкирэ джиле дэ Египто, соб тэ тинэ ворзо. ");
INSERT INTO rmyservi_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Кацик Вениамино, Иосифохкирэ пхралэ, Иаково на мукля лэнца, пала када со вов пхэнда: — Тэ на терэлпэ лэґа савись бида. ");
INSERT INTO rmyservi_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Кади машкар бутэн аврэн и чявэ Израилёхкирэ авиле тэ тинэ ворзо, пала када со дэ Ханаанско пхув сля бокх. ");
INSERT INTO rmyservi_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Иосифо сля хулай пэ всавори кодэя пхув. Вов битинэлас ворзо манушэнди пав всаворо Египто, тай кала пхрала Иосифохкирэ авиле, вонэ тэлиле лэсти ды пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Сар кацик Иосифо удыкхля пхралэн, вов екхатар уджянгля лэн, нэ прытердапэ, со вов лэн на джянэл, тай задэдуманя лэнца холяґа. — Катар тумэ авиле? — пхучля вов. — Хананаанохкирятар пхуятар, соб тэ тинэ хамо, — пхэндэ вонэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Иосифо уджянгля пэхкирэн пхралэн, нэ вонэ на уджянгле лэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Вов взрапирда пэхкирэ сунэ пала лэн тай пхэнда: — Тумэ шпионуря! Тумэ авиле тэ выдыкхэ дэ амари пхув, тев исин назоралэ тхана. ");
INSERT INTO rmyservi_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","— Со ту, раё, — пхэндэ вонэ. — Тирэ копыли авиле тэ тинэ хамо. ");
INSERT INTO rmyservi_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Амэ всаворэ чявэ екхэ дадэхкирэ. Тирэ копыли — чячюнэ мануша, на шпионуря. ");
INSERT INTO rmyservi_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Вов пхэнда лэнди: — Нат, тумэ авиле тэ выдыкхэ дэ амари пхув, тев исин назоралэ тхана. ");
INSERT INTO rmyservi_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ай вонэ пхэндэ: — Амэ, тирэ копыли, — дэшудуй пхрала, чявэ екхэ дадэхкирэ, саво джювэл дэ Ханаанско пхув. Цыкнэдэр и екхатар дадэґа, ай екхэ будэр нинай. ");
INSERT INTO rmyservi_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Иосифо пхэнда лэнди: — Мэ пхэндом жэ, со тумэ шпионуря! ");
INSERT INTO rmyservi_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Акэ сар мэ када выпучява тумэндар: солахав фараонохкирятар джювимаґа, тумэ на уджяна катар, сар на авэла кордэ тумаро цыкнэдэр пхрал. ");
INSERT INTO rmyservi_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Бичялэн екхэ тумэндар пала пхралэ, ай авэр авэна тэ бэшэ дэ баруно. Кади мэ уджянава тумарэ лава — чячимо ли тумэ манди дэдумэн. Сар нат, солахав фараонохкиряґа джювимаґа, тумэ — шпионуря! ");
INSERT INTO rmyservi_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Тай затерда лэн всаворэн дэ баруно пэ трин дивэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Пэ трито диво Иосифо пхэнда лэнди: — Терэнти, со мэ пхэнава, тай авэна джюдэ, пала када со мэ дарав Дэвлэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Сар тумэ чячюнэ мануша, мэк екх тумэндар ачелапэ катэ дэ баруно, ай авэр джяна тай отлиджяна ворзо тумарэнди бокхалэнди їренди. ");
INSERT INTO rmyservi_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Нэ тумэ анэна мандэ тумарэ цыкнэдэр пхралэ, соб тэ авэн тумарэ лава чячюнэ тай тумэ тэ аченпэ джюдэ. Кади вонэ и стердэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Вонэ пхэндэ екх екхэсти: — Душол, со пэ амэн авиля кадэя глаба пала амарэ пхралэ. Амэ дыкхле лэхкири дар, кала вов мангэлас амэн, нэ амэ на ачиле тэ шунэ, тай акхэ пэ амэн авиля кадэя глаба. ");
INSERT INTO rmyservi_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Рувимо пхэнда: — Мэ жэ пхэнавас тумэнди— на терэн кадэва бэзэх пала чяворо, ай тумэ на пошундэ! Кана авэл роспотинимо пала лэхкиро рат. ");
INSERT INTO rmyservi_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Вонэ и на думисарэнас, со Иосифо полэл лэн, пала када со вов дэдуманя лэнца пав дуечибэндирэ манушэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Вов отджиля дэ риг тай заровиня. Тунчи рисиля павпалэ тай задэдуманя лэнца. Вов лиля лэндар Симеоно тай спхангля лэ лэндэ пэ якхэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Иосифо прыпхэнда тэ пхэрдён лэндирэ трасты ворзоґа, тай тэ чювэн всаворэнди павпалэ лэндири рупь, кажнонэсти дэ лэхкиро гоно, ай тэ дэн лэнди хамо пэ дром. Кади и сля стердо. ");
INSERT INTO rmyservi_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Пхрала чютэ ворзо пэ магарен тай джиле дэ дром. ");
INSERT INTO rmyservi_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Кала вонэ ачиле, соб тэ ратярэ, екх лэндар розпхангля гоно, соб тэ лэ ворзо тэ парварэ магаре, тай удыкхля дэ гонэ пэхкири рупь. ");
INSERT INTO rmyservi_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","— Мури рупь рисиля! — пхэнда вов пхралэнди. — Акэ вой дэ муро гоно. Лэндирэ їлэ позамуле. Вонэ дэ дар порисиле екх екхэсти тай пхэндэ: — Со када терда амэнца Дэвэл? ");
INSERT INTO rmyservi_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Кала вонэ авиле пэхкирэстэ дадэстэ Иаковостэ дэ Ханаано, вонэ роспхэндэ лэсти пала вса, со лэнца тердапэ. Вонэ пхэндэ: ");
INSERT INTO rmyservi_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","— Мануш, саво хулай пэ кодэя пхув, дэдуманя амэнца холяґа тай прылиля амэн пала шпионуря. ");
INSERT INTO rmyservi_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Нэ амэ пхэндэ лэсти: «Амэ чячюнэ мануша, на шпионуря. ");
INSERT INTO rmyservi_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Амэн сля дэшудуй пхралэн, чявэ екхэ дадэхкирэ, саво джювэл дэ Ханаанско пхув. Цыкнэдэр и екхатар дадэґа, ай екхэ будэр нинай». ");
INSERT INTO rmyservi_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Тунчи мануш, саво хулай дэ кодэя пхув, пхэнда амэнди: «Акэ сар мэ уджянава, чячюнэ тумэ мануша чи нат: ачявэнти екхэ пхралэ катэ манца, лэн хамо важ тумарэн бокхалэн їрен тай джян пэхкирэґа дромэґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Нэ анэн мандэ тумарэ цыкнэдэр пхралэ. Кади мэ уджянава, со тумэ на шпионуря, ай чячюнэ мануша. Тунчи мэ отдава тумэнди тумарэ пхралэ тай пхэнава, соб тумэ тэ пхирэн пав кадэя пхув, тев камэн». ");
INSERT INTO rmyservi_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Кала вонэ вычютэ гонэндар вса, кажно удыкхля котэ пэхкиро бузло рупаґа. Сар удыкхле рупь, и вонэ, и лэндиро дад пэрэдаранепэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Иаково пхэнда лэнди: — Тумэ залиле мандар чяворэн. Иосифо будэр нинай, и Симеоно будэр нинай, ай кана тумэ камэн тэ лэ Вениамино. Со кана авиля пэ мандэ! ");
INSERT INTO rmyservi_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Рувимо пхэнда дадэсти: — Умарэґа мурэн дуен чявэн, сар мэ на анава лэ павпалэ тутэ. Дэ лэ манди, тай мэ анава лэ павпалэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Нэ Иаково пхэнда: — Муро чяво на джяла пордэ туґа. Лэхкиро пхрал муло, вов ачиляпэ екх. Сар дэ дром лэґа терэлапэ глаба, тунчи кадэлаґа грыжаґа тумэ злиджяна муро парно шэро дэ мулэндири люмля! ");
INSERT INTO rmyservi_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Дэ кодэя пхув бокх ачелас вса зоралэдэр. ");
INSERT INTO rmyservi_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Кала пхрала схале всаворо ворзо, саво андэ Египтостар, дад пхэнда лэнди: — Рисявэн тай тинэн амэнди инте набут хамо. ");
INSERT INTO rmyservi_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Нэ Иуда пхэнда лэсти: — Кодэва мануш састэс прыпхэнда амэнди: «На сикавэнпэ манди пэ якхэн, сар тумэнца на авэла тумарэ пхралэ». ");
INSERT INTO rmyservi_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Сар ту отмукэґа амэнца пхралэ, то амэ джяґа тай тинаґа важ тутэ хамо. ");
INSERT INTO rmyservi_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Нэ сар ту на отмукэґа лэ, амэ на джяґа, пала када со кодэва мануш пхэнда амэнди: «На сикавэнпэ манди пэ якхэн, сар тумэнца на авэла тумарэ пхралэ». ");
INSERT INTO rmyservi_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","— Пэ со тумэ андэ пэ ман кадэя глаба? Важ со пхэндэ кодэлэсти манушэсти, со тумэндэ исин инте екх пхрал? — пхучля Израилё. ");
INSERT INTO rmyservi_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Вонэ пхэндэ: — Кодэва мануш роспучелас вса пала амэндэ тай пала амари їри: «Джюдо инте тумаро дад? Исин тумэндэ инте пхрал?» Амэ роспхэндэ лэсти пала када, со вов пхучля. Катар амэ джянгле, со вов пхэнэла: «Анэнти кордэ тумарэ пхралэ»? ");
INSERT INTO rmyservi_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Иуда пхэнда Израилёсти, пэхкирэ дадэсти: — Отмук чяворэ манца, тай амэ екхатар джяґа, соб всаворэ амэ тэ выджювах тай тэ на мэрах: амэ, тай ту, тай амарэ чяворэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Мэ дав тути лав, мандар ту пхучеґа пала лэ. Сар мэ на анава лэ тутэ тай на тховава катэ англа тутэ, мэ авава дошало англа тутэ, покы на мэрава. ");
INSERT INTO rmyservi_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Сар амэ тэ на цырдах вряма, то дувар джиле бы тай рисиле. ");
INSERT INTO rmyservi_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Тунчи лэндиро дад Израилё пхэнда лэнди: — Сар када амэнди тэ на обджя, терэнти акэ со: тховэн дэ трасты фэдэдэр плодуря кадэлатар пхуятар тай отлиджян дэ даро колэсти манушэсти — набут бальзамо тай набут авдин, спецыї тай цил, савэндар джял лачё фано, фисташкуря тай миндалё. ");
INSERT INTO rmyservi_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Лэн дувар будэр рупь, соб тумэнди тэ анэ пэґа и кода, со сля тховдо павпалэ дэ тумарэ гонэ, чи на сля када ошыбка. ");
INSERT INTO rmyservi_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Лэн тумарэ пхралэ, екхатар жэ джян упалэ колэстэ манушэстэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Мэк Дэвэл Всазорако дэла тумэнди мила, соб вов тэ отмукэл и аврэ пхралэ, и Вениамино тэ рисявэ тумэнца цэрэ. Ай сар манди трэбуни тэ ачявпэ би чяворэндиро, мэк кади и авэла. ");
INSERT INTO rmyservi_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Пхрала лиле подаркуря тай дувар будэр рупь, тунчи лиле Вениамино, екхатар жэ джиле дэ Египто тай котэ ачиле англа Иосифо. ");
INSERT INTO rmyservi_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Кала Иосифо удыкхля, со лэнца Вениамино, вов пхэнда пэхкирэсти барэдэр бутярнэсти: — Отлиджя кодэлэн манушэн мандэ дэ цэр, зачин савось ското тай тав хамо. Вонэ авэна тэ ха манца дэ їпаш диво. ");
INSERT INTO rmyservi_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Мануш терда, сар лэсти сля прыпхэндо, тай анда лэн дэ Иосифохкиро цэр. ");
INSERT INTO rmyservi_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Вонэ пэрэдаравдэпэ, кала лэн андэ лэстэ дэ цэр, пала када со думисарэнас: «Амэн андэ кордэ пала рупь, сави рисиля дэ амарэ гонэ дэ англуно моло. Вов камэл тэ помарэ амэн тай тэ лэ зораґа, тэ чювэ дэ копыли тай тэ залэ амарэн магарен». ");
INSERT INTO rmyservi_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Вонэ поджиле барэдэрэстэ бутярнэстэ Иосифохкирэ тай задэдуманэ лэґа паша удара дэ цэр: ");
INSERT INTO rmyservi_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","— Раё, пошун, — пхэндэ вонэ, — амэ аваґас кордэ екх моло тэ тинэ хамо. ");
INSERT INTO rmyservi_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Нэ кала амэ ачиле пэ рат тай розпхангле гонэ, кажно амэндар аракхля котэ пэхкири рупь, скацик сля дыкалэ. Пала када амэ андэ лэ павпалэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Амэ андэ пэґа инте рупь, соб тэ тинэ хамо. Амэ на джянах, ко дэ кодэва моло тховда амари рупь амэнди дэ гонэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Вов пхэнда: — Вса мишто, на даранти. Тумаро Дэвэл, тумарэ дадэхкиро Дэвэл, тховда кадэва барвалимо дэ тумарэ гонэ. Ай манди дэне тумари рупь. Тунчи барэдэр бутярно вылиджялда лэндэ Симеоно. ");
INSERT INTO rmyservi_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Вов анда пхралэн дэ Иосифохкиро цэр, дэня лэнди пани тэ выхалавэ пурэ тай дэня хамо магаренди. ");
INSERT INTO rmyservi_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Вонэ лилэ подаркуря Иосифости, кала вов авэла дэ їпаш диво, пала када со лэнди пхэндэ, со вонэ авэна тэ ха котэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Кала Иосифо авиля цэрэ, вонэ отдэне лэсти подаркуря тай тэлиле лэсти ды пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Вов пхучля лэн пала састимо, тунчи пхэнда: — Сар тумаро пхуро дад, пала савэ тумэ дэдумане манди? Джюдо вов инте? ");
INSERT INTO rmyservi_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Вонэ пхэндэ: — Тиро копыли, дад амаро, инте джюдо тай састо. Тай тэлэ тэлиле лэсти пативатар. ");
INSERT INTO rmyservi_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Вов обдыкхляпэ тай додыкхля пэхкирэ пхралэ Вениамино, пэхкиря датирэ чявэ. Вов пхучля: — Када тумаро цыкнэдэр пхрал, кодэва, пала ка тумэ дэдумане манди? Дэвэл тэ терэл мила тути, муро чяво! ");
INSERT INTO rmyservi_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Иосифохкиро їло сля на пэ тхан, кала вов удыкхля пэхкирэ пхралэ, тай инте набут, и вов розровэлас бы. Вов екхатар жэ уджиля, заджиля пэстэ дэ цэроро тай котэ фартэ заровиня. ");
INSERT INTO rmyservi_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Тунчи вов халавда муй тай выджиля упалэ. тай рицарэласпэ, соб тэ на заровэ, пхэнда: — Подэнти хамо. ");
INSERT INTO rmyservi_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Лэсти подэне ригатар, пхралэнди ригатар, тай египтянонэнди, савэ ханас лэґа, кадиж ригатар, пала када со египтянуря на ханас евреёнэнца, када египтянонэнди сля гряцымо. ");
INSERT INTO rmyservi_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Пхралэн бэшавдэ англа лэ пав пхуриматэ, англунэстар ды цыкнэдэр, тай вонэ дыкхле екх пэ екхэстэ тай нисо на полэнас. ");
INSERT INTO rmyservi_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Лэнди подэнас хамо Иосифохкирэстар скаминдэстар, ай котор Вениаминохкиро сля панчвар барэдэр, сар аврэнди. Вонэ кадиж пэнас лэґа, тай вонэ набут матиле. ");
INSERT INTO rmyservi_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Иосифо прыпхэнда пэхкирэ барэдэрэ бутярнэсти: — Пхэр гонэ кадэлэн манушэн хамаґа, скацик вонэ улиджяна, тай тхов рупь кажнонэхкиро павпалэ дэ гонэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Ай дэ цыкнэхкиро гоно екхтханэ лэхкиря рупаґа пала ворзо тхов муро рупуно тахтаё. Тай кодэва стерда, сар прыпхэнда Иосифо. ");
INSERT INTO rmyservi_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Кацик ачиля тэ душол пэ гаса, пхралэн отбичялдэ дэ дром екхтханэ лэхкирэнца магарэнца. ");
INSERT INTO rmyservi_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Вонэ сле инте надур форостар, кала Иосифо пхэнда барэдэрэсти бутярнэсти: — Екхатар жэ прастэ пала кодэлэн манушэн тай, кала доросэґа лэн, пхэн: «Сости тумэ потиндэ врытимаґа пала лачимо? ");
INSERT INTO rmyservi_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Пэ со тумэ чёрдэ мурэ раехкиро тахтаё, савэстар вов пэл тай пэ саво вов врисарэл? Тумэ тердэ налачё рындо! ");
INSERT INTO rmyservi_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Кала доросля лэн, вов пропхэнда лэнди кодэла лава. ");
INSERT INTO rmyservi_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Вонэ пхэндэ: — Сости рай пхэнэл кацавэ лава? На авэна тирэ копыли тэ терэ кацаво! ");
INSERT INTO rmyservi_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Амэ жэ андэ тути павпалэ рупь Ханаансконатар пхуятар, сави аракхле пэстэ дэ гонэн. Пэ со амэнди тэ чёрэ рупь чи сувнак цэрэстар тирэ хулаестар? ");
INSERT INTO rmyservi_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Сар аракхэґа тахтаё екхэстэ тирэстэ копылестэ, мэк вов мэрэла, ай амэ ачяґа копыленца амарэ раехкирэнца. ");
INSERT INTO rmyservi_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Вов пхэнда: — Мишто, мэк авэла кади, сар тумэ пхэнэн: кастэ аракхэлапэ тахтаё, ачела мурэґа копылеґа, ай авэр на дошалэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Пхрала сиго обмукле кажно пэхкиро гоно пэ пхув тай розпхангле лэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Барэдэр бутярно ачиля тэ родэ пхурэдэрэстар цыкнэстэ; тахтаё аракхляпэ дэ гоно Вениаминохкиро. ");
INSERT INTO rmyservi_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Пхрала розчиндэ пэ пэстэ їда, тховдэ гонэ пэ магарен тай рисиле дэ форо. ");
INSERT INTO rmyservi_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Иуда тай лэхкирэ пхрала рисиле дэ Иосифохкиро цэр, саво инте сля котэ. Вонэ тэлэдэне англа лэстэ пэ пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Иосифо пхэнда лэнди: — Со жэ тумэ тердэ? Тумэ со, на джянэнас, со кацаво мануш, сар мэ, вса джянэл, кала врисарэл? ");
INSERT INTO rmyservi_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","— Со амэ пхэнаґа амарэсти раести? — пхэнда Иуда. — Сар тэ дэдумэ?Сар тэ допхэнэ када, со амэ на дошалэ? Дэвэл оттерда дош тирэн копылен. Кана амэ копыли амарэ раехкирэ — амэ тай кодэва, кастэ аракхляпэ тахтаё. ");
INSERT INTO rmyservi_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Иосифо пхэнда: — Мэ на авава тэ терэ кацаво! Кацик кодэва, кастэ аракхляпэ тахтаё, авэла мурэ копылеґа, ай тумэ рисявэн дадэстэ пачяґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Тунчи Иуда поджиля лэстэ тай пхэнда: — Мангав тут, муро раё, дэ тирэ копылести тэ пхэнэ лав мурэ раести. На холяв пэ тиро копыли, ту — сар фараоно. ");
INSERT INTO rmyservi_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Муро рай пхучля пэхкирэн копылен: «Исин тумэндэ дад чи пхрал? ");
INSERT INTO rmyservi_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Тай амэ пхэндэ: «Амэндэ исин пурано дад тай исин тэрно чяво, саво бэяндапэ лэсти дэ пхурима. Лэхкиро пхрал муля, тай вов ачиляпэ екх пэхкирятэ даятэ, тай дад камэл лэ». ");
INSERT INTO rmyservi_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Тунчи ту пхэндан пэхкирэнди копыленди: «Анэн лэ мандэ, соб манди тэ дыкхэ пэ лэстэ». ");
INSERT INTO rmyservi_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Тай амэ пхэндэ мурэ раести: «Чяворо нисар на ачявэла дадэ, ай сар ачявэла, дад мэрэла». ");
INSERT INTO rmyservi_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Нэ ту пхэндан пэхкирэнди копыленди: «Покы тумаро пхрал на авэла кордэ тумэнца, на сикавэнпэ манди пэ якхэн». ");
INSERT INTO rmyservi_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Кала амэ авиле тирэстэ копылестэ, мурэ дадэстэ, амэ роспхэндэ лэсти, со пхэнда муро раё. ");
INSERT INTO rmyservi_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Амаро дад пхэнда: «Рисявэн тай тинэн инте набут хамо». ");
INSERT INTO rmyservi_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Нэ амэ пхэндэ: «Амэнди нащи тэ джя. Кацик сар цыкнэдэр пхрал джяла амэнца, тунчи амэ джяґа. Амэнди нащи тэ сикавэпэ пэ якхэн кодэлэсти манушэсти, сар на авэла амэнца цыкнэдэр пхрал». ");
INSERT INTO rmyservi_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Тиро копыли, муро дад, пхэнда амэнди: «Тумэ екджинэ джянэн, со мури ромни бэянда манди дуен чявэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Екх лэндар уджиля мандар, тай мэ пхэндом: «Вов сля розчиндо пэ котора», — тай кодэла вряматар мэ лэ на дыкхлём. ");
INSERT INTO rmyservi_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Сар тумэ лэна мандэ и аврэ, тай лэґа терэлапэ глаба, тумэ злиджяна грыжаґа муро парно шэро дэ мулэндири люмля». ");
INSERT INTO rmyservi_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Пала када, сар чяворэ на авэла амэнца, кала мэ рисявава тирэ копылести, мурэ дадэстэ, тай сар муро дад, саво кади прыпхангло кадэлэстэ чяворэстэ, ");
INSERT INTO rmyservi_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","удыкхэла, со лэ амэнца нинай, вов мэрэла. Тирэ копыли злиджяна грыжаґа парно шэро амарэ дадэхкиро дэ мулэндири люмля. ");
INSERT INTO rmyservi_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Тиро копыли дэня лав англа дад, со фирисарава чяворэ. Мэ пхэндом: «Сар мэ на анава лэ тутэ, дош англа тутэ, дадэ, всаворо джювимо авэла пэ ман». ");
INSERT INTO rmyservi_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Кана, мангав тут, дэ тирэсти копылести тэ ачепэ катэ копылеґа мурэ раехкирэ пала чяворэ, тай дэ чяворэсти тэ рисявэ пхралэнца. ");
INSERT INTO rmyservi_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Сар мэ рисявава дадэстэ, сар чяворэ манца на авэла? Тэ на удыкхав грыжа мурэ дадэхкири! ");
INSERT INTO rmyservi_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Тунчи Иосифо на ґалювэлас будэр тэ рицарэпэ англа копыли тай затиписиля: — Уджян всаворэ мандар! — тай ника на сля Иосифоґа, кала вов оттердапэ пхралэнди. ");
INSERT INTO rmyservi_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Вов кади зоралэ заровиня, со ушундэ египтянуря, тай дума пала када доджиля фараоностэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Иосифо пхэнда пхралэнди: — Мэ — Иосифо! Джюдо инте муро дад? Пхрала нисо на ґалёнас тэ пхэнэ, пала када со вонэ сле пэрэдаравдэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Тунчи Иосифо пхэнда пхралэнди: — Поджян мандэ. Тай кала вонэ поджиле, вов пхэнда: — Мэ — тумаро пхрал Иосифо, савэ тумэ битиндэ дэ Египто! ");
INSERT INTO rmyservi_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","На даран тай на дошалярэн будэр пэ пала кода, со битиндэ ман кордэ: када Дэвэл бичялда ман англа тумэндэ, соб тэ фирисарэ тумаро джювимо. ");
INSERT INTO rmyservi_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Дуй бэрш, сар пэ пхув бокх, тай инте панч бэрша на авэна тэ чинэ пхув тай тэ стидэ ворзо. ");
INSERT INTO rmyservi_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Дэвэл бичялда ман англа тумэн, соб тэ фирисарэ тумаро родо пэ пхув тай тэ терэл баро фирисаримо тумаря джювимати. ");
INSERT INTO rmyservi_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Акэ, на тумэ бичялдэ ман кордэ, ай Дэвэл: Вов тховда ман тэ авав фараоности, сар дад, раеґа пэ всаворо лэхкиро цэр тай тэ авав хулай пэ всаворо Египто. ");
INSERT INTO rmyservi_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Сигидэр рисявэн мурэстэ дадэстэ тай пхэнэн лэсти: Акэ со пхэнэл тиро чяво Иосифо: «Дэвэл стерда ман хулаеґа дэ всаворо Египто. Ав мандэ, на цырдэ вряма. ");
INSERT INTO rmyservi_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ту авэґа тэ джювэ дэ пхув Гошэно тай авэґа паша ман: ту, тай тирэ чяворэ, тай внукуря, тай тиро баро тай хурдо ското, тай вса, со тутэ исин. ");
INSERT INTO rmyservi_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Котэ мэ авава тэ дыкхэ пала тут, ай сар на кади, ту тай тиро цэр, тай вса, ко тутэ, авэна дэ чёрымо. Кади сар джян инте панч бокхалэ бэрша». ");
INSERT INTO rmyservi_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Тумэ дыкхэн тумарэнца якхэнца, тумэ тай муро пхрал Вениамино, со чяче када мэ дэдумав тумэнца. ");
INSERT INTO rmyservi_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Роспхэнэн мурэ дадэсти пала када, со тумэ дыкхле, тай пала када, сар мэ ашардо дэ Египто. Тай сигидэр анэн лэ кордэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Вов облиля пэхкирэ пхралэ Вениамино тай заровиня, тай Вениамино ровэлас тай облэлас лэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Вов чюминда всаворэн пхралэн тай ясвэнца облиля лэн. Тунчи пхрала дэдумане лэґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Дума пала кода, со авиле пхрала Иосифохкирэ, доджиля фараоностэ. Фараоно ачиля лошало, тай кадиж лэхкирэ рая. ");
INSERT INTO rmyservi_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Фараоно пхэнда Иосифости: — Пхэн пхралэнди: «Терэн акэ со: тховэн гонэ хамаґа пэ тумарэ магаря, рисявэн дэ Ханаанско пхув ");
INSERT INTO rmyservi_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","тай анэн мандэ дадэ тай тумарэ їря. Мэ дава тумэнди фэдэдэр пхув дэ Египто, тай тумэ авэна тэ ха вса, со фэдэр, со дэла кадэя пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Инте прыпхэнав тути тэ пхэнэ лэнди: «Стерэн акэ со: лэн Египтостар вурдона важ тумарэн чяворэн тай ромнен, анэн дадэ тай авэн екджинэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Тэ на авэл дор тумэнди пала када, со ачявдэ тумаро барвалимо, пала када со вса, со исин фэдэдэр дэ Египто, авэла тумаро». ");
INSERT INTO rmyservi_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Чявэ Израилёхкирэ кади и стердэ. Сар прыпхэнда фараоно, Иосифо дэня лэнди вурдона тай хамо дэ дром. ");
INSERT INTO rmyservi_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Кажнонэсти вов дэня нэви їда, ай Вениаминости вов дэня трин шэла шэкеля рупь тай панч їды. ");
INSERT INTO rmyservi_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Дадэсти вов бичялда дэш магарен фэдэдэряґа барвалимаґа, саво сля дэ Египто, тай дэш магарницэн ворзоґа, мандрэґа тай авря хамаґа дэ дром. ");
INSERT INTO rmyservi_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Тунчи вов отмукля пхралэн, тай кала вонэ уджянас, пхэнда лэнди: — Ни пала со на пэрэджювэн дэ дром! ");
INSERT INTO rmyservi_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Вонэ джиле дэ дром Египтостар, авиле пэхкирэстэ дадэстэ Иаковостэ дэ пхув Ханаано ");
INSERT INTO rmyservi_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","тай пхэндэ лэсти: — Иосифо джюдо! Иосифо — хулай пэ всаворо Египто! Иаковостэ замуля їло, тай вов на патиля лэнди. ");
INSERT INTO rmyservi_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Нэ кала вонэ пэрэдэне лэсти вса, со пхэнда Иосифо, тай кала вов удыкхля вурдона, савэ Иосифо бичялда, соб тэ пэрэлиджя лэ, їло Иаковохкиро отджюндиля. ");
INSERT INTO rmyservi_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Тай Израилё пхэнда: — Хутилэла! Муро чяво Иосифо джюдо. Джява тай дыкхава лэ, покы на мулём. ");
INSERT INTO rmyservi_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Израилё джиля дэ дром всаворэґа, со сля лэстэ, авиля дэ Вирсавия тай анда котэ жэртва Дэвлэсти пэхкирэ дадэхкирэ Исаакохкирэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Дэвэл дэдуманя Израилёґа дэ ратякуро сунэ тай пхэнда: — Иаково! Иаково! — Акэ мэ, — пхэнда Иаково. ");
INSERT INTO rmyservi_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Вов пхэнда: — Мэ — Дэвэл тирэ дадэхкиро. На дар тэ джя дэ Египто. Котэ Мэ стерава тутар баро народо! ");
INSERT INTO rmyservi_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Мэ джява дэ Египто екхтханэ туґа, тай Мэ анава тут павпалэ. Тай Иосифохкиро васт затерэла тути якха. ");
INSERT INTO rmyservi_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Иаково джиля дэ дром Вирсавиятар. Израилёхкирэ чявэ тховдэ дадэ, чяворэн тай ромнен дэ вурдона, савэ прыбичялда фараоно, соб тэ пэрэлиджя лэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Вонэ лиле пэґа ското тай барвалимо, саво затердэ дэ Ханаано, тай Иаково всаворэнца пэхкирэнца авиля дэ Египто. ");
INSERT INTO rmyservi_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Вов лиля пэґа дэ Египто чявэн тай внуконэн, чеен тай внучконэн — всаворо пэхкиро родо. ");
INSERT INTO rmyservi_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Акэ Иаковохкирэ чявэндирэ лава, савэ авиле дэ Египто, Иаково тай лэхкирэ потомкуря. Рувимо, пхурэдэр Иаковохкиро чяво. ");
INSERT INTO rmyservi_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Рувимохкирэ чявэ: Енохо, Паллу, Хецроно тай Кармиё. ");
INSERT INTO rmyservi_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Симеонохкирэ чявэ : Емуэло, Ямино, Охадо, Яхино, Цохаро тай Сауло, ханаанеянкатиро чяво. ");
INSERT INTO rmyservi_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Левиёхкирэ чявэ: Гершоно, Кехато тай Мерариё. ");
INSERT INTO rmyservi_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Иудахкирэ чявэ: Эро, Онано, Шэла, Парецо тай Зерахо. Эро тай Онано муле дэ Ханаано. Парецохкирэ чявэ сле Хецроно тай Хамуло. ");
INSERT INTO rmyservi_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Иссахарохкирэ чявэ: Тола, Пува, Иово тай Шымроно. ");
INSERT INTO rmyservi_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Завулонохкирэ чявэ: Середо, Элоно тай Яхлеэло. ");
INSERT INTO rmyservi_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Када Лиятирэ чявэ, савэн вой бэянда Иаковости дэ Паддано-Арамо. Вой бэянда инте чя Дина. Всаворэн лэн сля трянда трин мануша. ");
INSERT INTO rmyservi_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Гадохкирэ чявэ: Цыфионо, Хаггиё, Шуниё, Эцбоно, Эриё, Ародиё тай Арелиё. ");
INSERT INTO rmyservi_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Асирохкирэ чявэ: Имна, Ишва, Ишвиё тай Берия. Лэндири пхэнь Серах. Чявэ Бериёхкирэ: Хеверо тай Малкиэло. ");
INSERT INTO rmyservi_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Када чяворэ, савэн бэянда Иаковости Зелфа, ла Лавано дэня пэхкиряти чяти Лияти, всаворэн дэшушов манушэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Чявэ Иаковохкиря ромня, Рахилятирэ: Иосифо тай Вениамино. ");
INSERT INTO rmyservi_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Дэ Египто Аснат, чей Потиперахкири, саво сля рашаи дэ форо Оно, бэянда Иосифости Манассиё тай Ефремо. ");
INSERT INTO rmyservi_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Вениаминохкирэ чявэ: Бела, Бехеро, Ашбело, Гера, Наамано, Эхиё, Рошо, Муппимо, Хуппимо тай Ардо. ");
INSERT INTO rmyservi_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Када Рахилятирэ чявэ, савэн вой бэянда Иаковости; всаворэн дэшуштар манушэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Данохкиро чяво: Хушымо. ");
INSERT INTO rmyservi_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Неффалимохкирэ чявэ: Яхцээло, Гуниё, Ецэро тай Шыллемо. ");
INSERT INTO rmyservi_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Када чявэ, савэ Валла бэянда Иаковости. Лавано дэня ла Рахиляти, пэхкиряти чяти. Всаворэн ефта манушэнэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Всаворэ, ко авиля дэ Египто Иаковоґа, лэхкирэ потомкуря, — шов дэша шов мануша; чявэндирэ ромня катэ на бинэнпэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Чявэ Иосифохкирэ, савэ бэяндэпэ лэстэ дэ Египто, сля дуй. Всаворо їри Иаковохкиро, савэ авиле дэ Египто, сля ефта дэша манушэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Иаково бичялда англа пэстэ Иосифостэ Иуда, соб тэ уджянэ дром дэ Гошэно. Кала вонэ авиле пордэ, ");
INSERT INTO rmyservi_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Иосифо залытярда вурдон тай лагля дэ Гошэно, соб тэ прылэ пэхкирэ дадэ Израилё. Вов ачиля англа лэстэ, облиля лэ тай зоралэ ровэлас. ");
INSERT INTO rmyservi_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Израилё пхэнда Иосифости: — Кана мэ ґалював и тэ мэрэ, пала када со удэкхлём пэхкирэнца якхэнца, со ту джюдо. ");
INSERT INTO rmyservi_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Иосифо пхэнда пэхкирэнди пхралэнди тай дадэхкирэнди цэрутнэнди: — Мэ джява фараоностэ тай пхэнава лэсти: «Мурэ пхрала тай дадэхкиро цэр, савэ джюдэ дэ пхув Ханаанско, авиле мандэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Кадэла мануша — чябануря, вонэ розлиджян ското тай андэ пэґа пэхкирэ гуртуря, тай андэ вса пэхкиро барвалимо». ");
INSERT INTO rmyservi_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Кала фараоно выакхарэла тумэн тай пхучела: «Соґа тумэ залэнпэ?» — ");
INSERT INTO rmyservi_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","тумэ пхэнэн: «Амэ, тирэ копыли, чяворэндирятар вряматар тай дыкалэ розлиджях ското, сар терэнас и амарэ дада». Тунчи тумэнди дэна тэ джювэ дэ пхув Гошэно, пала када со египтянонэнди чябануря гряца. ");
INSERT INTO rmyservi_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Иосифо джиля фараоностэ тай пхэнда лэсти: — Муро дад тай пхрала пэхкирэнца гуртонэнца, баро тай хурдо ското, и вса, со лэстэ сля, авиле Ханааностар, тай екхатар вонэ дэ Гошэно. ");
INSERT INTO rmyservi_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Вов вылиля панч пхралэн тай авиля лэнца фараоностэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Фараоно пхучля пхралэн: — Соґа тумэ залэнпэ? Вонэ пхэндэ фараоности: — Тирэ копыли — чябануря, кади и амарэ дада. — ");
INSERT INTO rmyservi_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Инте вонэ пхэндэ: — Амэ авиле кордэ тэ джювэ, пала када со дэ пхув Ханаано бари бокх, тай тирэнди копыленди нинай, тев тэ чяравэ гуртуря. Пала када дэ тирэнди копыленди тэ джювэ дэ Гошэно. ");
INSERT INTO rmyservi_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Фараоно пхэнда Иосифости: — Тиро дад тай пхрала авиле тутэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Пхув Египто англа тутэ. Дэ лэнди тэ джювэ дэ фэдэдэр тхан пэ кадэя пхув. Мэк джювэн дэ Гошэно. Ай сар ту джянэх машкар лэндэ лаче бутярнэ, тхов лэн тэ дэкхэ пала муро ското. ");
INSERT INTO rmyservi_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Иосифо анда пэхкирэ дадэ Иаково тай тховда лэ англа фараоно, тай Иаково бахталисарда фараоно. ");
INSERT INTO rmyservi_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Фараоно пхучля лэ: — Скацик тути бэрш? ");
INSERT INTO rmyservi_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Иаково пхэнда фараоности: — Мэ 130 бэрш пхирав пав пхув. Набарэ тай киркэ сле бэрша муря джювимахкирэ, тай лэн сля на кади, сар дадэндирэ бэрша джювимахкирэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Иаково бахталисардо фараоно тай джиля лэхкиро цэр. ");
INSERT INTO rmyservi_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Сар прыпхэнда фараоно, Иосифо чюта тэ джювэ дадэ тай пхралэн дэ Египто тай отдэня лэнди фэдэдэр котор пхув надур Раамсесостар. ");
INSERT INTO rmyservi_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Иосифо анда бут хамо дадэсти, пхралэнди тай всаворэнди, ко сля дэ цэр дадэхкиро. ");
INSERT INTO rmyservi_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Тунчи нитев на ачиля хамо, пала када со сля зорали бокх дэ Египто тай Ханаано. ");
INSERT INTO rmyservi_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Иосифо битинэлас мандро пала рупь, тай кади стидэня дэ фараонохкиро цэр всавори рупь, сави сля дэ Египто и дэ Ханаано. ");
INSERT INTO rmyservi_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Кала ни дэ Египто, ни дэ Ханаано на ачилепэ рупь, всаворэ египтянуря авиле Иосифостэ тай пхэндэ: — Дэ амэнди мандро. Пэ со амэнди тэ мэрэ тутэ пэ якхэн? Нэ рупь амэндэ будэр на ачиляпэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Иосифо пхэнда: — Сар тумэндэ нинай будэр рупь, анэн тумаро ското, тай мэ парувава мандро пэ ското. ");
INSERT INTO rmyservi_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Вонэ андэ Иосифости ското, тай вов парувэлас лэнди мандро пэ грастэн, бакрэн тай бузнен, гурувэн, гурувнен тай магарен. Дэ кодэва бэрш вов парувэлас лэнди мандро пэ ското. ");
INSERT INTO rmyservi_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Проджиля екх бэрш. Пэ дуйто бэрш вонэ авиле лэстэ тай пхэндэ: — Амэ на аваґа тэ гаравэ тутар, амаро рай, со ловэн амэндэ нинай, тай амаро ското кана тиро. Кади со амэндэ нисо на ачиляпэ важ амаро раестэ, кацик амэ тай пхув амари. ");
INSERT INTO rmyservi_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Пэ со амэнди тэ мэрэ тутэ пэ якхэн, амэнди тай амаряти пхуяти? Тин амэн тай амари пхув, парув пэ мандро, ай амэ тай амари пхув аваґа дэ копылен фараоностэ. Дэ амэнди самбуря, соб амэнди тэ джювэ тай на тэ мэрэ, тай соб кадэя пхув тэ на авэл шушы. ");
INSERT INTO rmyservi_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Кади Иосифо тинда всавори пхув дэ Египто важ фараоно. Египтянуря битиндэ кажно пэхкири маля, пала када со бокх сля бари. Пхув ачиля фараонохкири, ");
INSERT INTO rmyservi_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","ай манушэн Иосифо стерда копыленца екха ригатар дэ Египто ды авря. ");
INSERT INTO rmyservi_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Вов на тинда кацик пхув рашаендири, пала када со ловэ, савэ дэня лэнди фараоно, лэнди хутилэнас пэ хама, акэ сости вонэ на битиндэ пэхкири пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Иосифо пхэнда манушэнди: — Кана, кала мэ тиндом тумэн тай тумари пхув важ фараоно, акэ тумэнди самбуря, соб тэ чювэ лэн дэ пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Кала выбарёла ворзо, отдэн панчто котор фараоности, ай авэр штар котора авэна тумэнди пэ самбуря важ мален тай соб тэ хан тумэ, соб тэ хан тумэ, тумарэ цэрутнэ тай чяворэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Вонэ пхэндэ: — Ту фирисардан амэнди джювимо. Тэ аракхах амэ лачимо дэ якхэн амарэ раехкирэ. Кана амэ аваґа фараонохкирэнца копыленца. ");
INSERT INTO rmyservi_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Кади Иосифо дэня законо дэ Египто, саво и екхатар дэ зора: панчто котор ворзостар авэла фараонохкирэ. Кацик рашаендири пхув на ачиля фараонохкиряґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Израильтянуря джюдэ дэ Египто, дэ пхув Гошэно. Котэ лэндэ сле цэра тай бэяндёнаспэ бут чяворэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Иаково проджюда дэ Египто дэшуефта бэрша. Всаворо лэхкиро джювимо сля шэл саранда ефта бэрша. ");
INSERT INTO rmyservi_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Кала авиля лэхкири вряма тэ мэрэ, вов акхарда пэхкирэ чявэ Иосифо тай пхэнда лэсти: — Сар мэ аракхлём лачимо дэ тирэн якхэн, тхов васт манди тала шолдо тай дэ лав, со сикавэґа манди мила тай чячимо. На гарав ман дэ Египто. ");
INSERT INTO rmyservi_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Кала мэ сджява мурэндэ дадэндэ, вылиджя ман Египтостар тай гарав котэ, тев вонэ сле гаравдэ. Иосифо пхэнда: — Мэ терава кади, сар ту пхэнэх. ");
INSERT INTO rmyservi_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","— Дэ солах, — пхэнда вов. Иосифо дэня солах лэсти. Израилё смукляпэ пэ пэхкиро дэсто тай тэлиля Дэвлэсти. ");
INSERT INTO rmyservi_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Проджиля савись вряма, тай Иосифости пхэндэ: — Тиро дад насвало. Иосифо лиля пэґа дуен чявэн Манассиё тай Ефремо. ");
INSERT INTO rmyservi_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Иаковости пхэндэ: — Тутэ авиля тиро чяво, Иосифо. Израилё стидэняпэ зораґа, привщиля тай бэшля пэ пато. ");
INSERT INTO rmyservi_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Иаково пхэнда Иосифости: — Дэвэл Всазорако сикавдапэ манди дэ Лузо, дэ пхув Ханаано, тай бахталисарда ман. ");
INSERT INTO rmyservi_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Вов пхэнда: «Мэ терава, со тутэ авэла бут чяворэн, со тутар джяна бут народуря, ай кадэя пхув Мэ дава пэ всавори вряма тирэнди чяворэнди». ");
INSERT INTO rmyservi_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Кана дуй тирэ чяворэ, савэ бэяндэпэ дэ Египто, дыкалэ сар авилём мэ катэ, вонэ авэна мурэнца. Ефремо тай Манассиё авэна мурэнца, сар Рувимо тай Симеоно. ");
INSERT INTO rmyservi_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ай чяворэ, савэ бэяндэпэ тутэ инте, авэна тирэ. Вонэ акхарэнапэ пхралэндирэнца лавэнца и лэна пэхкирэ котора лэндирятар пхуятар. ");
INSERT INTO rmyservi_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Кала мэ рисявавас Падданостар, Рахиль муля дэ пхув Ханаано, кала амэ инте сле дэ дром, надур Эфрататар. Мэ гаравдом ла котэ, пашэ дром дэ Эфрата (када исин Вифлеемо). ");
INSERT INTO rmyservi_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Кала Израилё удыкхля Иосифохкирэн чявэн, вов пхучля: — Ко када? ");
INSERT INTO rmyservi_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Иосифо пхэнда дадэсти: — Када чявэ, савэн Дэвэл дэня манди катэ. Тай кодэва пхэнда: — Подлиджя лэн мандэ, соб мэ тэ бахталисарав лэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Пхуриматар Израилё врыто дыкхэлас, вов сля, сар коро. Иосифо подлиджялда чявэн пашэдэр пэхкирэстэ дадэстэ, тай кодэва чюминда тай облиля лэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Израилё пхэнда Иосифости: — Мэ на думасаравас упалэ тэ удыкхэ тут, ай Дэвэл дэня тэ удыкхэ манди и тирэн чяворэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Иосифо отлиджялда лэн Израилёхкирэндар чянгэндар тай тэлиля лэсти ды пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Иосифо тховда Ефремо дэ чячюни риг пэстар тай дэ зэрво риг Израилёстар, ай Манассиё дэ зэрво риг пэстар тай дэ чячюни риг Израилёстар, тай подлиджялда лэн пашэдэр дадэстэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Нэ Израилё процырда чячё васт тай тховда ла пэ Ефремохкиро шэро, ай вов сля цыкнэдэр, тай зэрво васт вов тховда пэ Манассиёхкиро шэро, ай Манассиё сля пхурэдэр чяво. ");
INSERT INTO rmyservi_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Тунчи вов бахталисарда Иосифо тай пхэнда: — Дэвэл, англа Кастэ пхирэнас мурэ дада Авраамо тай Исаако, Дэвэл, Саво сля чябано важ манди всаворо муро джювимо, ");
INSERT INTO rmyservi_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Ангело, Саво фирисарэлас ман всаворятар врытиматар, — тэ бахталисарэл кадэлэн чяворэн. Мэк вонэ пхирявэн муро лав тай лава мурэн дадэн Авраамохкиро тай Исаакохкиро, тай мэк лэндирэн чяворэн авэла будэр пэ пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Кала Иосифо удыкхля, со дад тховда чячё васт пэ Ефремохкиро шэро, када на чялиля лэсти. Вов лиля дадэ пала васт, соб пэрэтховэ ла Ефремохкирэстар шэрэстар пэ Манассиёхкиро шэро. ");
INSERT INTO rmyservi_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Иосифо пхэнда лэсти: — Нат, дадэ, акэ кадэва — пхурэдэр, тхов чячё васт пэ лэхкиро шэро. ");
INSERT INTO rmyservi_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ай дад на закамля тай пхэнда: — Мэ джянав, муро чяво, джянав. Лэстар кадиж джяла народо, тай и вов авэла баро мануш. Нэ лэхкиро цыкнэдэр пхрал авэла барэдэр лэстар, тай лэхкирэндар чяворэндар джяна бут народуря. ");
INSERT INTO rmyservi_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Тай вов бахталисарда лэн дэ кодэва диво тай пхэнда: — Израилё авэна тэ пропхэнэ тумарэ лава, сар бахталисаримо, пхэнэна: «Дэвэл тэ стерэла тут, сар Ефремо тай Манассиё». Кади вов тховда Ефремо англэ Манассиё. ");
INSERT INTO rmyservi_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Израилё пхэнда Иосифости: — Мэ мэрав, нэ Дэвэл авэла тумэнца тай рисарэла тумэн дэ дадэндири пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Мэ дав тути барэдэр котор пхув, сар тирэнди пхралэнди, додав тути котор пхув плаенца, саво мэ чюряґа тай лукоґа отмардом амореендэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Иаково акхарда пэхкирэн чявэн тай пхэнда: — Стидэнпэ паша ман, тай мэ роспхэнава тумэнди, со авэла тумэнца дурэдэр. ");
INSERT INTO rmyservi_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Стидэнпэ тай шунэн , Иаковохкирэ чявэ, шунэн пэхкирэ дадэ Израилё. ");
INSERT INTO rmyservi_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Рувимо, ту — муро пхурэдэр, мури зор, англуно плодо муря муршакуня зоратиро, англуно пай патив, англуно пай зор. ");
INSERT INTO rmyservi_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Парувэхпэ ту, сар пани, будэр ту на авэґа пхурэдэрэґа чявэґа, пала када со сутан пэ тиро дадэхкиро тхан, мусардан муро пато. ");
INSERT INTO rmyservi_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Симеоно тай Левиё — пхрала, лэндирэ чюря анэн мижымо. ");
INSERT INTO rmyservi_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Тэ на авэл муро їло лэнца дэ када, пала со вонэ думисарэн, тэ на авав, тев вонэ стидэнпэ Вонэ дэ холя умардэ муршэн, сар закамле, чиндэ гурувэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Прыдав мрая лэндири холи, пала када со фартэ сле холяти, фартэ зорали лэндири холи! Мэ розчювава лэн машкар Иаковохкирэ чяворэ, розчювава лэн машкар Израилёхкирэ чяворэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Иуда, тирэ пхрала ашарэна тут, тиро васт авэла пэ кор тирэн врыжымашонэн, тирэ дадэхкирэ чявэ авэна тэ тэлён тути. ");
INSERT INTO rmyservi_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ту — тэрно лево, Иуда, ту рисарэґапэ астаримаґа, муро чяво. Сар лево, вов прыпэрэл пхуятэ, сар львица, вов пэрэл, ко камэл ла тэ здаравэ? ");
INSERT INTO rmyservi_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Дэсто тхагаримахкиро на уджяла Иудастар, лэхкирэ потомкуря всавори вряма авэна тэ рицарэ тхагаримо. Ай тунчи авэла Шыло, тай лэсти тэлёна всаворэ народуря. ");
INSERT INTO rmyservi_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Вов прыпхандэла пэхкирэ магаре дэ дракохкири лоза, тэрнэ магаре — дэ фэдэдэр дракохкири лоза. Вов халавэла пэхкири їда дэ мол, пэхкиро урявимо — дэ дракохкиро рат. ");
INSERT INTO rmyservi_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Лэхкирэ якха авэна калэдэр молэстар, данда лэхкирэ — парнэдэр тхудэстар. ");
INSERT INTO rmyservi_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Завулоно авэла тэ джювэ пашэ баро пани, барэ корабли заджяна дэ лэ. Лэхкири пхув процырдэлапэ ды Сидоно. ");
INSERT INTO rmyservi_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Иссахаро — састо магари, вов пашлёл машкар дуй пхарэ гонэ, савэ пхиравэн джювимо. ");
INSERT INTO rmyservi_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Кала дыкхля, сар лачё лэхкиро отцынимахкиро тхан тай сави лачи лэхкири пхув, вов прыцырдэла пэхкирэ пхикэ тала пхаримо тай отдэлапэ пхаря бутяти. ");
INSERT INTO rmyservi_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Дано сундисарэла пэхкиро народо, сар екх Израилёхкирятар породатар. ");
INSERT INTO rmyservi_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Дано авэла сапэґа паша дром, сар сап, саво лиджял мэримо пэ сано дром, саво дандярэл грастэ пала пуро, кади со кодэва, саво бэшэл англистэ, пэрэл пэ пхув. ");
INSERT INTO rmyservi_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","О РАЁ, Тутар ажутярав фирисаримо! ");
INSERT INTO rmyservi_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Гадо авэна тэ обчёрэ, нэ вов даравэла лэн павпалэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Асиростэ авэла скаминд замардо барваляґа хамаґа, вов авэла тэ дэ лачё хамо, саво хан тхагара. ");
INSERT INTO rmyservi_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Неффалимо — сар лань, сави прастэл пав мален, сави анэл райканэн чяворэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Иосифо — дракохкири рандь, сави анэл бут плодо. Вой барёл пашэ лэнь тай ваздэлпэ упрэ пэ ванта. ");
INSERT INTO rmyservi_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Холяґа хукэнас пэ лэстэ лучникуря, зораґа марэнас дэ лэстэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Нэ лэхкиро луко ачиляпэ састо. Зор лэхкирэ вастэндиро — зорало Дэвэл Иаковохкиро, Лав Чябанохкиро, Бар Израилёхкиро. ");
INSERT INTO rmyservi_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Дэвэл тирэ дадэхкиро, Всазорако, Саво дэл зор тути. Вов бичялэл бахталисаримо упрал, болыбнатар, тай бахталисаримо, саво тала пхув, бахталисарэл чючя тай водя. ");
INSERT INTO rmyservi_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Тирэ дадэхкирэ бахталисаримо барыдэр, сар бахталисаримо пуранэн плаен, сар бахталисаримо пуранэн упралимахкирэн плаен. Тэ авэн всаворэ вонэ пэ Иосифохкиро шэро, пэ чекат тхагарехкиро машкар пэхкирэн пхралэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Вениамино — бокхало рув; дэнзор вов схал астаримо, бельвеляґа розлэл кодэва мищимо. ");
INSERT INTO rmyservi_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Акэ савэ дэшудуй Израилёхкирэ родуря, тай акэ со пхэнда лэнди дад, лэндиро бахталисаримо; кажнонэсти вов дэня пэхкиро бахталисаримо. ");
INSERT INTO rmyservi_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Тунчи Иаково прыпхэнда лэнди: — Мэ отджяв мурэндэ дадэндэ. Гаравэн ман пашэ мурэн дадэн дэ пищера пэ маля Эфронохкиря хеттеёхкиря, ");
INSERT INTO rmyservi_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","дэ пищера пэ маля Махпела пашэ Мамреґа дэ Ханаано, сави Авраамо тинда, сар тхан, тев тэ гаравэ Эфроностэ хеттеёстэ екхтханэ маляґа. ");
INSERT INTO rmyservi_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Котэ сле гаравдэ Авраамо тай лэхкири ромни Сарра, котэ гаравдэ Исаако тай лэхкири ромни Ревека, тай котэ мэ гаравдом Лия. ");
INSERT INTO rmyservi_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Маля тай пищера сле тиндэ хеттеянэндэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Иаково пэрэачиля тэ дэдумэ чявэнди, подлиля пурэ пэ пато, вымукля фано тай отджиля пэхкирэндэ дадэндэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Иосифо авиля дадэстэ, ровиня тай чюминда лэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Вов прыпхэнда пэхкирэнди копыленди — састимаренди тэ макхэ дадэхкиро трупо бальзамоґа, тай састимари тердэ кади. ");
INSERT INTO rmyservi_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Лэндэ джиля пэ када саранда дивэса, сар када сля трэбуня. Тай ефта дэша дивэса египтянуря ровэнас пала лэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Кала проджиле ровимахкирэ дивэса, Иосифо пхэнда фараонохкиренди бутярнэнди: — Сар мэ аракхлём лачимо дэ тумарэн якхэн, помангэн пала ман фараоно тай пхэнэн лэсти: ");
INSERT INTO rmyservi_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","«Муро дад прыпхэнда манди тэ дэ солах и пхэнда: \"Мэ мэрав. Гарав ман дэ тхан, со мэ стердом дыкалэ пэсти дэ пхув Ханаано\". Дэ манди тэ джя и тэ гаравэ мурэ дадэ. Сар мэ терава када, рисявава». ");
INSERT INTO rmyservi_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Фараоно пхэнда: — Джя тай гарав дадэ кади, сар ту дэнян солах тэ стерэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Иосифо джиля тэ гаравэ дадэ, тай лэґа джиле всаворэ фараонохкирэ бутярнэ, тай лэхкирэ цэрэхкирэ пхурэдэра, тай всаворэ Египтохкирэ пхурэдэра, ");
INSERT INTO rmyservi_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","тай всаворо Иосифохкиро цэр, тай лэхкирэ пхрала, тай всаворо дадэхкиро цэр. Кацик лэндирэ чяворэ тай гуртуря, баро тай хурдо ското ачилепе дэ Гошэно. ");
INSERT INTO rmyservi_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Пролиджянас лэн вурдона тай англистаря. Котэ сля бут манушэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Вонэ авиле дэ Горен-Атадо, када пала Иордано, тай котэ ачиле зоралэс тэ ровэ. Котэ Иосифо ровэлас пала дадэ ефта дивэса. ");
INSERT INTO rmyservi_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Кала ханаанея, савэ джювэнас дэ кодэя пхув, удыкхле ровимо паша Горен-Атадо, вонэ пхэндэ: «Египтянонэндэ баро ровимо тай глаба». Акэ сости кодэва тхан пала Иордано акхарэлпэ Авел-Мицраим. ");
INSERT INTO rmyservi_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Кади чявэ Иаковохкирэ стердэ лэхкиро прыпхэндимо: ");
INSERT INTO rmyservi_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","вонэ отлиджялдэ лэ дэ Ханаанско пхув тай гаравдэ дэ пищера пэ маля Махпела, пашэ Мамреґа. Кадэя пищера Авраамо тинда Эфроностэ хеттеёстэ екхтханэ маляґа, соб тэ авэл лэстэ тхан, тев тэ гаравэ. ");
INSERT INTO rmyservi_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Кала гаравдэ дадэ, Иосифо рисиля дэ Египто, екхтханэ пхралэнца тай всаворэнца, ко пхирэлас лэнца. ");
INSERT INTO rmyservi_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Кала дад муля, Иосифохкирэ пхрала думисардэ: «Со, сар Иосифо рицарэл пэ амэн холи тай кана отпотинэла амэнди пала всаворо врытимо, саво амэ лэсти андэ?» ");
INSERT INTO rmyservi_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Тай вонэ бичялдэ Иосифостэ тэ пхэнэ: — Англа када, сар тэ мэрэ, дад пхэнда амэнди: ");
INSERT INTO rmyservi_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","«Акэ со пхэнэнти тумарэсти пхралэсти Иосифости: «Мэ мангав тут тэ на рицарэх холи пэ тирэн пхралэн, бистар лэндиро бэзэх тай дош, сави вонэ стердэ, кала стердэ кадэва налачё рындо». Тай кана, амэ мангах тут, эртисар амэнди амарэ бэзэха, амэ жэ Дэвлэхкирэ копыли, савэсти тэлёлас тиро дад». Кала Иосифо шунда када, вов заровиня. ");
INSERT INTO rmyservi_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Лэхкирэ пхрала авиле, тэлэдэне пэ пхув англа лэстэ тай пхэндэ: — Амэ — тирэ копыли. ");
INSERT INTO rmyservi_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Иосифо пхэнда: — На даран. Мэ со, Дэвэл? ");
INSERT INTO rmyservi_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Тумэ закамле манди врытимо, нэ Дэвэл порисарда лэ дэ лачимо, соб тэ терэ када, со выджял екхатар: фирисаримо бутэндиро. ");
INSERT INTO rmyservi_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Пала када на даранти: мэ пропарварава и тумэн, и тумарэн чяворэн. Вов мишто дэдуманя лэнца, тай лэндири дар улиля. ");
INSERT INTO rmyservi_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Иосифо джюда дэ Египто екхтханэ дадэхкиряґа їряґа. Вов проджюда шэл дэша бэрш. ");
INSERT INTO rmyservi_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Вов удыкхля инте трито поколение Ефремохкирэн чяворэн. Тай кала бэяндэпэ Махиростэ чяворэ, Манассиёхкирэ чявэ, вов дыкхля лэн тай рицарэлас лэн пэ чянгэн. ");
INSERT INTO rmyservi_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Иосифо пхэнда пхралэнди: — Мэ мэрав, нэ Дэвэл чяче авэла тумэндэ, дэла зор тай вылиджяла тумэн кадэлатар пхуятар дэ пхув, сави Вов солахаґа пхэнда тэ дэ Авраамости, Исаакости тай Иаковости. ");
INSERT INTO rmyservi_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Иосифо пхэнда Израилёхкирэнди чявэнди тэ дэ солах: — Дэвэл чяче авэла тумэндэ тай дэла зор. Тунчи тумэ вылиджянти катар мурэ кокали. ");
INSERT INTO rmyservi_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Иосифо муля, кала лэсти сля шэл дэша бэрш. Лэ макхле бальзамоґа тай тховдэ дэ гробо дэ Египто.");
INSERT INTO rmyservi_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Калась, ды вряма сундисарэн, ды пхув Иудея авиля бокх, тай екх мануш Вифлеемостар екхтханэ ромняґа тай донца чявэнца пэрэлагля ды пхув Моаво. ");
INSERT INTO rmyservi_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Кадылэ манушэ акхарэнас Элимелехо, лэхкиря джювля — Нооми, а дон лэхкирэн чявэн — Махлоно тай Килионо. Вонэ джювэнас ды Эфрато пашэ ды Вифлеемо, со ды Иудея. Вонэ авиле ды пхув Моаво тай ачилепэ котэ. ");
INSERT INTO rmyservi_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Элимелехо , мурш Нооми, муля, тай вой ачиляпэ донца чявэнца. ");
INSERT INTO rmyservi_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Вонэ лиле пэсти джювлен моавитянкен; екха акхарэнас Орпа, авря — Руфь. Вонэ проджюдэ котэ паша дэш бэрш, ");
INSERT INTO rmyservi_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","тай тунчи Махлоно тай Килионо кади ж муле. Нооми пэрэджюда дон чявэн тай пэхкэрэ муршэ. ");
INSERT INTO rmyservi_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Кала Нооми уджянгля ды Моаво, со РАЙ срапирда пала пэхкирэн манушэн тай дыня лэнди хамо, вой закамля тэ рисявэ пхуятар Моаво ды пэхкири пхув, тай лаґа скамле тэ джя дуй латирэ боря. ");
INSERT INTO rmyservi_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Нооми ачявда тхан, тев джюда, тай лакирэ боря джиле лаґа. Вонэ джиле ды дром павпалэ ды пхув Иудея. ");
INSERT INTO rmyservi_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Нооми пхэнда пэхкирэнди дуенди боренди: — Рисявэн цэрэ, дэ тумарэн чяче їрен! Мэк РАЙ дэл тумэнди лачимо, сар и тумэ дэнас лачимо пэхкирэ мулэнди муршэнди тай манди. ");
INSERT INTO rmyservi_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Тэ дэл РАЙ тумэнди тэ аракхэн бахт ды цэр нэвэ муршэґа. Вой чюминдэня лэн, нэ вонэ фартэ подлиле гвалто тай заровине. ");
INSERT INTO rmyservi_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Тай пхэндэ: — Амэ джяґа туґа, тирэ манушэндэ. ");
INSERT INTO rmyservi_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Нооми пхэнда: — Чея, рисявэн павпалэ. Пэ со тумэнди тэ джя манца? Чи авэна мандэ инте чявэ, соб тэ авэн тумэнди муршэнца? ");
INSERT INTO rmyservi_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Рисявэн, чея мурэ, мэ фартэ пурани, соб тэ выджя пала ром. Тэ думисаравас бы мэ кади: «Мандэ исин надежда!», тэ пэрэрятяравас бы мэ кадыя рят ромэґа тай тэ быяндёнпэ бы чявэ, ");
INSERT INTO rmyservi_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","со калэстар? Тумэнди тэ дожутярэ, кала вонэ выбарёна? Со калэстар, тэ ачепэ тумэнди на пала ром?! На трэбуни, чея. Мурэ джювимо фартэ кырко, мэ фартэ пала тумэн пэрэджював. РАЙ счюта пы ман пэхкири холи. ");
INSERT INTO rmyservi_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Вонэ упалэ подлиле гвалто тай заровине. Орпа чюминдэня пэхкиря сасуя тай джиля, а Руфь отпхэндапэ тэ уджя. ");
INSERT INTO rmyservi_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Нооми пхэнда: — Дыкх, тири ятровка рисявэл пэхкирэ манушэндэ тай пэхкирэ дэвлэндэ. Джя и ту лаґа. ");
INSERT INTO rmyservi_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Нэ Руфь пхэнда: — На манг ман тэ ачявав тут тай тэ рисяв. Мэ джява пордэ, тев ту джях, тай ачявапэ котэ, тев ту ачехпэ; тирэ мануша авэна мурэ манушэнца, тиро Дэвэл — муро Дэвэл. ");
INSERT INTO rmyservi_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Тев мэрэґа ту, котэ и мэ мэрава, тай котэ мэк ман гаравэна. Тэ помарэл ман РАЙ, кацик мэримо розачявэла амэн! ");
INSERT INTO rmyservi_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Нооми полиля, со Руфь всаекх джяла лаґа тай пэрэачиля тэ мангэ ла тэ уджял. ");
INSERT INTO rmyservi_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Вонэ джиле дуйджинэ ды Вифлеемо. Кала вонэ авиле, ды форо подлиляпэ баро гвалто: — Када со, Нооми?! — типисявэнас джювля. ");
INSERT INTO rmyservi_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Нооми пхэнэлас лэнди: — На акхарэн ман будэр Нооми, ай акхарэн Мара, колэсти со Всазорако бичялда манди бида! ");
INSERT INTO rmyservi_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Кала мэ уджявас, мандэ сля вса, нэ РАЙ рисарда ман павпалэ нисоґа. Пэ со тумэ акхарэн ман Нооми? РАЇ сундисарда ман, Всазорако бичялда манди бибахталимо. ");
INSERT INTO rmyservi_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Кади рисардапэ пхуятар Моаво Нооми тай лаґа латири бори моавитянка Руфь. Кала вонэ авиле ды Вифлеемо, ачиле тэ стидэ ячменё. ");
INSERT INTO rmyservi_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Муршэстэ Нооми сля родо пав лавэ Боазо, мануш пативало, колэстар родостар, со и Элимелехо. ");
INSERT INTO rmyservi_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Моавитянка Руфь пхэнда Нооми: — Мук ман тэ джя ды маля тэ стидэ ворзо, саво тэлэдыня, котэ, тев манди сикавэна мищимо. Нооми пхэнда: — Джя, чей мури. ");
INSERT INTO rmyservi_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Руфь джиля пы маля, тев стидэнас ворзо, тай ачиля тэ подлэ кода, со тэлэдэлас пы пхув. Тай ачиля кади, со кодыя маля сля маля Боазохкири, саво сля родо Элимелехости. ");
INSERT INTO rmyservi_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Дэ кадыва диво еджино Боазо авиля пордэ Вифлеемостар. — РАЙ тумэнца! — пхэнда вов бутярнэнди. — Тэ авэх бахтало РАЕСТАР! — пхэндэ вонэ лэсти. ");
INSERT INTO rmyservi_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Боазо пхучля пхурэдэрэ бутярнэстар: — Кахкири када чей, кадыя тэрни джювли? ");
INSERT INTO rmyservi_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Пхурэдэр бутярно пхэнда: — Када моавитянка, сави Нооми анда пхуятар Моаво. ");
INSERT INTO rmyservi_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Вой пхучля: «Мукэґа ман тэ стидэ ворзо, саво тэлэдыня». Авиля дэнзор тай ачиляпэ вой катэ, тай на прыбэшля тэ отцинявэ. ");
INSERT INTO rmyservi_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Тунчи Боазо пхэнда Руфяти: — Чей мури, пошун. На джя тэ стидэ ворзо пэ авэр маля, на уджя катар, нэ рицарпэ пашэ мурэ бутярнендэ. ");
INSERT INTO rmyservi_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Дыкх, тев тирэн бутярнэ, тай джя пав шпэра бутярнен. Мэ прыпхэндом пэхкирэ манушэнди тэ на холярэн тут. Кала скамэґа тэ пэ, поджя тай пи кхорэстар, савэстар лэн пани мурэ копыли. ");
INSERT INTO rmyservi_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Вой тэлиля лэсти ды пхуя тай пхэнда: — Сости ту сикавэх манди кацаво мищимо? Сости ту чювэх пы ман сама, мэ ж авря пхуятар? ");
INSERT INTO rmyservi_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Боазо пхэнда лати: — Манди роспхэндэ пала кода, со ту стердан пэхкиряти сасуяти, кала муля тиро мурш: сар ту ачявдан дадэ тай да, ачявдан пэхкири пхув, тев аракхлянпэ, тай джилян манушэндэ, савэн ды калэ на джянэґас. ");
INSERT INTO rmyservi_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Мэк РАЙ воздэла тути пала тирэ рындоря, савэ ту тирдан, тай дэла бахт тути Дэвэл, РАЙ Израилехкоро, пала лэхкирэ пхака ту камэх тэ ушаравэпэ! ");
INSERT INTO rmyservi_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Вой пхэнда: — Рай муро, ту сикавэх манди кацаво мищимо. Ту дынян пачя тиря копыляти, кала мэ на тирэ копылендар. ");
INSERT INTO rmyservi_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Кала авиля вряма тэ ха, Боазо пхэнда Руфяти: — Джя кордэ, ха тай обмук пэхкоро котор мандро ды шуклима. Руфь бэшля пашэ бутярнэн, тай вов дыня лати присардо ворзо. Вой чялиля, тай латэ интэ ачиляпэ. ");
INSERT INTO rmyservi_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Кала Руфь упалэ джиля тэ стидэ ворзо, Боазо прыпхэнда пэхкирэ манушэнди: — Тай кала вой закамэла тэ стидэ помашкар снопуря, на холярэн ла. ");
INSERT INTO rmyservi_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Кала авэна тэ стидэ, на залэн вса тай ачявэн лати. Мэк подлэл, тай тумэ нисо на дэдумэн лати. ");
INSERT INTO rmyservi_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Дэ бельвель Руфь стидэлас ворзо пэ маля. Нэ кала вой обмарда лэн, выджиля їпаш гоно ячмени. ");
INSERT INTO rmyservi_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Кала авиля ды форо, Руфь сикавда сасуяти, скацик вой стидыня.Тунчи вой доросля кода, со ачиляпэ хаматар, тай отдыня Нооми. ");
INSERT INTO rmyservi_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Сасуи пхучля латар: — Тев ту стидэґас? Тев ту тирдан авдивэ? Тэ авэл бахтало кодыва, саво дыня тути зор. Руфь пхэнда сасуяти, кастэ вой тирда пэ маля. — Манушэ, пэ маля кастэ мэ авдивэ слём, акхарэн Боазо, — пхэнда вой. ");
INSERT INTO rmyservi_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","— Тэ дэл лэсти РАЙ бахт! Вов патив тховэл и пы джюдэн тай пы мулэн! — пхэнда Нооми боряти. — Кадыва мануш амаро пашутно родо, кастар авэла амэнди зор. ");
INSERT INTO rmyservi_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Руфь моавитянка пхэнда: — Вов пхэнда манди тэ рицарэпэ екхтханэ лэхкирэ бутярнэнца ды колэ, кала вонэ стерэна всаворэ бутя пэ лэхкирэн мален. ");
INSERT INTO rmyservi_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Нооми пхэнда Руфяти, пэхкиря боряти: — Чяёри, мишто, кала ту авэґа лэхкирэ бутярненца. Тунчи нико на холярэла тут пэ авэр маля. ");
INSERT INTO rmyservi_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Руфь рицардапэ екхтханэ бутярненца Боазохкирэнца тай подлэлас када, со тэлэдэлас ды колэ, кала постидыне ячмени тай див. Джювэлас вой тунчи пэхкиря сасуяса. ");
INSERT INTO rmyservi_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Екхвар латири сасуи Нооми пхэнда лати: — Мури чей, на трэбуни ли манди тэ аракхав тути тхан, соб тути тэ авэл мишто? ");
INSERT INTO rmyservi_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Хыба Боазо, пэхкирэнца бутярнянца, савэнца ту слян, амэнди на родо? Авдивэ бельвеляґа вов жужарэл ячмени пы токо. ");
INSERT INTO rmyservi_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Тай кади, джя, выхалавпэ, помакпэ лаче мастинаґа тай уряв тири лачи їда. Джя пы токо, кацик на сикавпэ лэсти ды кодыя вряма, кала вов на пэрэачела тэ ха тай тэ пэ. ");
INSERT INTO rmyservi_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Кала вов пэрэла, рапир кадыва тхан, тев вов пэрэла. Тунчи джя, оттер ушардо ды лэхкирэ пурэн тай пэр. Вов пхэнэла тути, со тэ тирэ. ");
INSERT INTO rmyservi_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","— Мэ тирава вса, сар ту пхэндан, — пхэнда Руфь. ");
INSERT INTO rmyservi_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Вой джиля пы токо тай тирда вса, со пхэнда лати тэ тирэ латири сасуи. ");
INSERT INTO rmyservi_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Кала Боазо пэрэачиля тэ ха тай тэ пэ, тай ачиля лэсти мишто, вов отджиля, пэля ды угло скирдатэ. Руфь локхэ поджиля, оттерда ушардо лэхкирэ пурэндэ тай пэля. ");
INSERT INTO rmyservi_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Дэ їпаш рят вов сдарыняпэ, порисардапэ тай додыкхля джювля, сави пашлёлас ды лэхкирэ пурэн. ");
INSERT INTO rmyservi_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","— Ко ту? — пхучля вов. — Мэ тири копыля, Руфь — пхэнда вой. — Ушарав ман тиря їдаґа, ту же екх пашутнэндар родостар амэнди, саво лиджял лав пала амэн. ");
INSERT INTO rmyservi_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Вов пхэнда: — Тэ дэл тути РАЙ бахт, чей мури. Када лачё рындо барыдэр колэстар, саво ту тирэґас дыкалэ. Ту на ачилян тэ пхирэ пала тэрнэн муршэндэ — на пала барвалэн, тай на пала чёрорэн. ");
INSERT INTO rmyservi_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Нэ кана, мури чей, на дара. Мэ тирава важ тути вса, со ту помангэґа. Всаворо муро форо джянэл, со ту пативали джювли. ");
INSERT INTO rmyservi_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Мэ пашутно родо, нэ исин родо пашэдэр тути. ");
INSERT INTO rmyservi_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Ачпэ пы рят катэ. Дэнзор, кала вов скамэла тэ вытинэ тут, када мишто – мэк кади и тэ авэл. Нэ сар на закамэла, чячимаґа, сар кода, со джюдо РАЙ, када тирава мэ. Сов катэ ды дэнзор. ");
INSERT INTO rmyservi_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Тай вой сля ды лэхкирэн пурэн ды дэнзор, нэ вшиля дыкалэ, кала ек мануш роздыкхэла аврэ манушэ. Боазо пхэнда ды пэ: «Мэк нико на джянэл, со пы токо авэлас джювли». ");
INSERT INTO rmyservi_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Вов пхэнда лати: — Дэ манди упрани їда, сави пэ тут, тай рицар ла. Кала вой тирда када, вов вычюта ды кадыя їда баро гоно ячмени тай дыня лати зор тэ зачювэ пы пхикен. Тунчи вов рисардапэ ды форо. ");
INSERT INTO rmyservi_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Кала Руфь авиля пэхкиря сасуятэ, Нооми пхучля: — Нэ сар ту, чей мури? Тай Руфь роспхэнда лати пала вса, со тирда Боазо важ лати ");
INSERT INTO rmyservi_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","тай прыпхэнда: — Вов дыня манди їпаш гоно ячмени тай пхэнда: «На рисюв пэхкиря сасуятэ шушэ вастэнца». ");
INSERT INTO rmyservi_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Нооми пхэнда: — Поач, мури чей, кала на уджянаґа, дысо вса доджяла. Кадыва мануш на прыбэшэла, вов авдивэ затирэла кадыва рындо. ");
INSERT INTO rmyservi_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Боазо джиля тай бэшля ды форохкирэн ударэн. Тай акэ дыкхэл: джял кодыва родо, пала савэ вов дэдуманя. Боазо акхарда лэ тай пхэнда: — Амал, поджя, бэш. Кодыва поджиля тай бэшля. ");
INSERT INTO rmyservi_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Боазо анда дэшэн манушэн пхурэдэрэн ды форо тай пхэнда лэнди: — Бэшэн катэ. Вонэ бэшлэ. ");
INSERT INTO rmyservi_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Боазо пхэнда родости: — Дума джял пала маля Элимелехохкири, амарэ родохкири. Нооми рисиля пхуятар Моаво тай битинэл лэ. ");
INSERT INTO rmyservi_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Мэ думисардом, со трэбуни тэ пхэнэ тути пала када. Камэх, вытин кадыя маля англа всаворэн, ко исин катэ, тай англа пхурэдэрэн мурэ народостар. Камэх — вытин. Сар на камэх — пхэн манди, соб мэ тэ джянав. Тути трэбуни англэ тэ вытинэ када, мэ — авэр, касти трэбуни тэ вытинэ. — Мэ вытинава, — пхэнда кодыва. ");
INSERT INTO rmyservi_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Боазо пхэнда: — Кала вытинэґа маля Ноомиятири, тути трэбуни тэ лэ моавитянка Руфь, кастэ муля ром, соб, кала тумэндэ быяндёлапэ чяворо, всаворо хаббэ тэ ачелпэ лэсти. ");
INSERT INTO rmyservi_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Тунчи пашутно родо пхэнда: — Нат, манди на выджял тэ вытинэ. Дарав, соб тэ на хасявэл мандэ вса. Мэк пала тут вса авэла, вытин ту, мандэ на выджял. ");
INSERT INTO rmyservi_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","(Англал ды Израили сля упхэнимо: кала пэрэдэнас вытинимо тай парувэнас, соб ды калэ тэ авэл зор, мануш слэлас пэстар цэрюли тай отдэлас аврэсти. Кади ды Израили састярэнас упхэнимо.) ");
INSERT INTO rmyservi_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","— Тин ту, — пхэнда пашутно родо Боазости тай слиля цэруля. ");
INSERT INTO rmyservi_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Боазо пхэнда пхурэдэрэнди тай всаворэсти народости: — Тумэ допхэнимаря: екхатар мэ тинав Ноомиятэ вса, со сля Элимелехостэ, Килионостэ тай Махлоностэ. ");
INSERT INTO rmyservi_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Кади ж моавитянка Руфь, со сля ромни Махлонохкири, мэ лав пэсти ды ромнен, соб ко авэла латар тэ авэн хулая пхуяти, со сля лэстэ, тай соб тэ на хасявэл лэхкиро родо ды амаро форо. Тумэ калэсти допхэнимаря! ");
INSERT INTO rmyservi_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Всаворэ ко котэ сля пашэ ударэн тай пхурэдэра пхэндэ: — Акэ, амэ допхэнимаря! Мэк РАЙ дэла ромняти, сави заджял ды тиро цэр, бут чяворэн, сар сля Рахилятэ тай Лиятэ, савэндар джиля всаворя нородо Израилёхкоро! Тэ авэх зорало ды Эфрата, тай тэ джянэн тут ды Вифлеемо. ");
INSERT INTO rmyservi_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Мэк РАЙ дэла тути чяворэн кала тэрня джювлятар! Мэк тиро цэр авэла пхуджило пы цэр Парецохкиро, савэ Тамар быянда Иудасти! ");
INSERT INTO rmyservi_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Боазо лиля Руфь пэсти ды ромнен. Вонэ сле екхтханэ, тай дыня РАЙ, вой быянда лэсти чявэ. ");
INSERT INTO rmyservi_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Джювля пхэндэ Нооми: — Наис РАЕСТИ, саво на ачявда тут би чяворэндиро! Тэ лашарэлпэ вов ды Израили! ");
INSERT INTO rmyservi_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Вов рисарэла тути джюимо тай подрицарэла тут ды пуранэн бэршэн! Бори тири, сави камэл тут, быянда лэ! Вой важ тути фэдэр, сар ефта чявэн. ");
INSERT INTO rmyservi_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Нооми пхиравэлас пы вастэн чяворэ, саво быяндапэ, тай дыкхэлас пала лэ. ");
INSERT INTO rmyservi_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Пашэ джювля дэдумэнас: — Ноомиятэ быяндапэ чяворо! Вонэ дыне лэсти лав тай акхардэ лэ Овидо. Када дад Иессеехкоро, саво сля дад Давидохкоро. ");
INSERT INTO rmyservi_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Акэ родо Давидохкоро, саво джял Парецостар: Парецо сля дад Хецронохкоро, ");
INSERT INTO rmyservi_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Хецроно сля дад Рамости, Рамо сля дад Аминадавости, ");
INSERT INTO rmyservi_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Аминадаво сля дад Нахшоности, Нахшоно сля дад Салмоности, ");
INSERT INTO rmyservi_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Салмоно сля дад Боазости, Боазо сля дад Овидости, ");
INSERT INTO rmyservi_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Овидо сля дад Иессеести, Иессеи сля дад Давидости.");
INSERT INTO rmyservi_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Сля лав РАЕСТАР Ионасти, чявэ Амиттаёхкирэсти: ");
INSERT INTO rmyservi_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","— Вщи, джя ды Ниневия, баро форо, тай роспхэн ды лэ, со дума пала врыти рындуря кадылэн манушэн доджиля ды ман. ");
INSERT INTO rmyservi_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Нэ Иона вщиля, соб тэ нашэ ды Таршыш РАЕСТАР, тай авиля ды Яффа, аракхля корабли, саво оджялас ды Таршыш, потинда, соб лэ тэ пролиджян, и заджиля ды лэ, соб тэ авэ РАЕСТАР ды Таршыш. ");
INSERT INTO rmyservi_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Нэ РАЙ бичялда пы море састо балвал. Тирдапэ баро гвалто, и кораблести трэбуни сля тэ розмарэпэ. ");
INSERT INTO rmyservi_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Матросуря здарэнэпэ тай ачиле тэ типисявэ кожно пэхкирэ дэвлэсти. Вонэ вычютэ всаворэ бужэ кораблестар ды пане, соб тэ авэл локхэдэр. Нэ Иона ды калэ смукляпэ андрэ, пыля тай састэс засута. ");
INSERT INTO rmyservi_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Капитано кораблехкоро авиля лэстэ тай пхэнда лэсти: — Со ту совэх? Вщи, типисяв тирэ Дэвлэсти. Ко джянэл, Вов ушунэла амэн, тай амэ на хасяваґа. ");
INSERT INTO rmyservi_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Матросуря пхэндэ екх екхэсти: — Джям, чюваґа жребиё, соб тэ уджянэ, пала ка кадыя грыжа авиля пы амэн. Вонэ чютэ жребиё, и жребиё выпыля пы Иона. ");
INSERT INTO rmyservi_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Тунчи вонэ пхэндэ лэсти: — Пхэн амэнди, пала ка дорэсля амэн кадыя грыжа? Соґа ту залэхпэ? Катар ту джях? Тев тири пхув? Савэндар ту манушэндар? ");
INSERT INTO rmyservi_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Вов пхэнда лэнди: — Мэ евреё, даравпэ РАЕСТАР, Дэвлэ болыбнахкирэ, Саво стерда баро пани тай пхув. ");
INSERT INTO rmyservi_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Тунчи Иона пхэнда лэнди, со вов нашэл РАЕСТАР. Кала мануша уджянгле пала када, вонэ фартэ пэрэдарэне тай пхэндэ лэсти: — Сости ту када тирдан? ");
INSERT INTO rmyservi_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Море на пэрэачелас гвалтовать. Вонэ пхэндэ лэсти: — Со амэнди тэ тирэ туґа, тэ на гвалтует море? ");
INSERT INTO rmyservi_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Тунчи вов пхэнда лэнди: — Лэн ман и вычювэн ды море, тай море пэрэачела гвалтовать важ тумэнди. Мэ джянав, со кадыя бари грыжа доросля тумэн пала ман. ");
INSERT INTO rmyservi_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Нэ кала мануша ачиле фартыдэр тэ тирэ бути, соб тэ прыаче пхуятэ, лэндэ нисо на выджялас, колэсти со море на пэрэачелас гвалтовать. ");
INSERT INTO rmyservi_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Тунчи вонэ типисине РАЕСТИ тай пхэндэ: — Мангах Тут, РАЕ, тэ на хасявах пала води кадылэ манушэ, тай на прычувэґа амэнди навуджило рат. Ту, РАЕ, стердан, со Ту камлян! ");
INSERT INTO rmyservi_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Вонэ лиле Иона тай вычютэ ды пане, тай пы море авиля пачя. ");
INSERT INTO rmyservi_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Матросуря фартэ пэрэдаранепэ РАЕСТАР, андэ Лэсти жэртва и дыне солах. ");
INSERT INTO rmyservi_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","РАЙ бичялда баро мачё, тай вой прозумавда Иона. Вов просля андрэ ды пэр мачестэ трин дивэ тай трин рятя. ");
INSERT INTO rmyservi_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","Кала Иона сля ды пэр мачестэ, вов помангляпэ РАЕСТИ, пэхкирэ Дэвлэсти. ");
INSERT INTO rmyservi_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Вов пхэнда: — Ды бида мэ типисилём РАЕСТИ, и Вов задэдуманя мандэ. Мэ затиписилём кола люмлятар мулэндар — тай Ту ушундан муро гласо. ");
INSERT INTO rmyservi_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Ту обмуклян ман фартэ тэлэ ды пане, вой тирёлас тай подлэласпэ понад муро шэро. ");
INSERT INTO rmyservi_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Мэ пхэндом: «Отчюто мэ Тирэ якхэндар, нэ всаекх мэ джянав, со мэ удыкхава свэнто Тиро цэр». ");
INSERT INTO rmyservi_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Пани ушаравда ман, чяря панестар обкхувдэ муро шэро. ");
INSERT INTO rmyservi_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Мэ тэлэ пхув сджилём, тев барён плая, тай удара затердэпэ пала ман, соб тэ на вымукэ ман вако. Нэ Ту, РАЙ, муро Дэвэл, вылилян ман хывьятар джюдэґа. ");
INSERT INTO rmyservi_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Кала джювимо муро мурдёлас, тай ачилёмпэ мэ би зорако, мэ РАЕ срапирдом, тай муро мангимо доджиля Тутэ, ды свэнто Тиро цэр. ");
INSERT INTO rmyservi_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Кола, ко тэлёл хохавнэ, шушэ дэвлэнди, прыдыне Тут. ");
INSERT INTO rmyservi_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","А мэ ашаримахкирэ гласоґа анава Тути жэртва, со пхэндом англа Тут, стерава! Фирисаримо РАЕСТАР! ");
INSERT INTO rmyservi_vpl VALUES ("JH2_11","033_2_11","JON","2","11","11","РАЙ пхэнда мачести, тай вов вычюта Иона мостар пы пхув. ");
INSERT INTO rmyservi_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Авэр моло сля лав РАЕСТАР Ионасти: ");
INSERT INTO rmyservi_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","— Вщи, джя ды Ниневия, баро форо, тай роспхэн ды лэ када, со Мэ пхэндом тути. ");
INSERT INTO rmyservi_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Иона вщиля тай джиля ды Ниневия, сар пхэнда лэсти РАЙ. Ниневия сля баро форо Дэвлэстэ, пэ трин дивэ тэ джя пэза. ");
INSERT INTO rmyservi_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Иона заджиля ды форо и састо диво пхирэлас тай пхэнэлас: «Интэ саранда дивэ, и Ниневия хасявэла!» ");
INSERT INTO rmyservi_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Мануша ды Ниневия патиле Дэвлэсти тай отпхэндэпэ тэ ха и тэ пэ. Всаворэ — барвалэ и чёрорэ — урявдэпэ ды їда гонэндар. ");
INSERT INTO rmyservi_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Кала кадыва лав доджиля ды тхагари, вов вщиля троностар, слиля барвали їда, урявдапэ ды їда гонэндар тай бэшля ды прахо. ");
INSERT INTO rmyservi_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Вов прыакхарда барэ манушэн, тай вонэ пхэндэ всаворэнди ды Ниневия: «Мануша нисо тэ на хан, тэ на пэн пани. Тай хулаимо, гурува, бакрэ бузненца тэ на пхирэн пы мален и тэ на пэн пани. ");
INSERT INTO rmyservi_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Мануша тай хулаимо тэ авэн ушаравдэ ды похтан гонэндар тай зоралэс тэ типисявэн Дэвлэстэ. Соб кажно мануш отрисардапэ пэхкэрэндар мижэ дромэндар тай прохарицики рындонэндар. ");
INSERT INTO rmyservi_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Ко джянэл, на парувэла ли Дэвэл Пэхкиро гындо тай отрисарэла амэндар Пэхкири холи, тай амэ на хасяваґа». ");
INSERT INTO rmyservi_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Дэвэл удыкхля лэндирэ рындуря, со вонэ отрисардэпэ пэхкирэ мижэ дромэндар, и ачиля Лэсти дор лэн, тай на бичялда бида, сави камля тэ бичялэ. ");
INSERT INTO rmyservi_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Када сля бари бида ды якхэн Ионасти. Вов фартэ холявэлас. ");
INSERT INTO rmyservi_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Вов ачиля тэ мангэпэ РАЕСТИ: — РАЕ! Мэ ж дэдуманём пала када, кала мэ инте слём пэстэ цэрэ. Колэсти мэ нашлём ды Таршыш. Мэ джянавас, со Ту, Дэвла, тирэх лачимо, Ту доруно, бут вряма на холявэх, Ту барвало камлимаґа тай на камэх тэ бичялэ бида. ");
INSERT INTO rmyservi_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Екхатар, РАЕ, лэ мури води. Манди фэдэр тэ мэрэ, сар тэ джювэ. ");
INSERT INTO rmyservi_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","РАЙ пхэнда: — Мишто када, со ту холявэх? ");
INSERT INTO rmyservi_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Иона выджиля форостар тай бэшля, тев восточно риг форостэ, стерда пэсти котэ катуна рандендар тай бэшля тала ла, дэ шалин, соб тэ удыкхэ, со авэла фороґа. ");
INSERT INTO rmyservi_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","РАЙ Дэвэл прыпхэнда рандяти, и рандь подлиляпэ понад шэро Ионасти, соб вов тэ авэл ды шалин, тэ авэл лэсти мишто. Иона сля фартэ лошало. ");
INSERT INTO rmyservi_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Тала дэнзор Дэвэл бичялда термэ тэ подха кодыя рандь, тай вой зашутиля. ");
INSERT INTO rmyservi_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Кала вщиля кхам, Дэвэл бичялда зорало, пхабардо балвал,тай кхам ачиля тэ пхабарэ шэро Ионасти, кади со лэсти ачиля бибахт. Вов мангля мэримо тай пхэнэлас: — Манди фэдэр тэ мэрэ, сар тэ джювэ. ");
INSERT INTO rmyservi_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Дэвэл пхэнда Ионасти: — Мишто када, со ту холявэх пала кадыя рандь? Вов пхэнда: — Мишто! На кацик тэ холявэ, нэ и тэ мэрэ. ");
INSERT INTO rmyservi_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Тунчи РАЙ пхэнда: — Тути дор кадыя рандь, пала савля ту на пхирэґас тай на тирдан бути. Ды екх рят рандь выбариля, тай ды екх рят вой хасиля. ");
INSERT INTO rmyservi_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Манди ли на дор Ниневия, баро форо, ды саво фартэ бут хулаимо тай будэр тев шэл биш пхангля манушэн, савэ на джянэн, со мищимо, а со врытимо?");
INSERT INTO rmyservi_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Кана бут ко манушэндар ачиле тэ зачинэ дума пала кода, со стердапэ машкар амэн, ");
INSERT INTO rmyservi_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","и сар амэнди розпхэндэ мануша, савэ англунэ дивэндар дыкхле кода, со сля, тай терэнас бути важ Дэвлэхкэрэ Лавэ, ");
INSERT INTO rmyservi_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","тунчи и манди, пативало Феофило, авиля пэ гындо тэ розлэпэ дэ кодэлэ, со стердапэ англунэ дивэндар, тай екх пала аврэ тэ чинэ тути, ");
INSERT INTO rmyservi_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","соб ту тэ полэх, пэ скици исин чячюно сикляримо, саво ту прылилян. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Дэ кодыя вряма, кала Иродо сля тхагари дэ Иудея, джювда екх рашай, саво вджялас дэ рашаенгири группа, тев сля пхурэдэрэґа Авии. Лэ акхарэнас Захария, тай лэхкиря ромняґа сля Елизавета, манушни Ааронохкэрэ родостар. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Вонэ лэдуй сле дэвликунэ мануша, и лэнгоро джювимо сля бидошакоро. И вонэ джювдэ пав Дэвлэ Раехкэрэ заповеди и пав дума Дэвлэхкири. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Лэндэ на сля чяворэн, колэсти со Елизаветатэ на выджялас тэ авэ пхаряґа, и вонэ лэдуй сле дэ пуранэн бэршэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Екхвар поджиля вряма Захариясти рашаенца тэ лиджя бути англа Дэвлэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Сар прылито сля рашаендэ, вонэ чутэ жребии, касти тэ джя дэ храмо, тай Захариясти выпэля тэ заджя дэ храмо Раехкоро и тэ ваздэ тхув. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Дэ кодыя вряма, кала Захария ваздэлас тхув дэ храмо, всавэрэ мануша мангэнаспэ аври, дэ грэда. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Тунчи сикавдапэ Захариясти Раехкоро ангело, пав чячи риг жэртвенникостар, пэ савэ ваздэнас тхув Дэвлэсти. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Кала Захария удыкхля ангело, дэня пэ лэстэ дар, и затинисиля даратар лэхкоро їло. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ангело пхэнда лэсти: — На дар, Захария! Шунда Дэвэл мангимо тиро, тай ромни тири, Елизавета, бэнёла тути чявэ, и дэґа лэсти лав Иоанно. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Тиро їло авэла бахтало баря лошатар, и Иоаннохкэрэ бэнимасти лошавэна бут мануша. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Авэла вов барэ манушэґа англа Рае: на пэла мол и мортхали тай Свэнтонэ Фаноґа авэла пхэрдо инте тала дакэрэ їлэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Бутэн манушэн дэ Израили вов рисарэла Раестэ, лэнгэрэ Дэвлэстэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Вов джяла англа Рае, тай Ильяхкэрэ фано и зор авэна пэ лэстэ, и вов рисарэла дадэнгэрэ їлэ лэнгэрэ чярэндэ, тай накандунэн рисарэла свэнтонэ годятэ, тай лачярэла манушэн, соб тэ авэн вонэ англа Дэвлэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Захария пхэнда ангелости: — Сар манди тэ патя кадэлэсти? Мэ пхуро, тай ромни мури дэ пуранэн бэршэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ангело пхэнда лэсти: — Мэ Гавриило, саво ачел англа Дэвлэ, тай бичалдо тэ дэдумэ туґа и тэ розпхэнэ тути пала када вса. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Акэ, ту авэґа лало и ни екх лав на пхэнэґа ды кодэлэ, сар вса стерэлапэ. Кодэлэсти со ту на патинян мурэ лавэсти, пав савэ стерэлапэ вса дэ пэхкири вряма. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","А мануша дожутярэнас Захария аври тай на полэнас, сости вов на выджял храмостар скици вряма. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Кала вов выджиля храмостар, тунчи на сґалювда тэ выпхэнэ ни екх лав, нэ кици сикавэлас вастэнца, сар лало. Тунчи мануша полиле, со Дэвэл сикавда лэсти вари-со дэ храмо. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ай кала проджиля лэхкири вряма тэ лиджя бути дэ храмо, Захария рисиля цэрэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Проджиля набут вряма, и Елизавета, ромни лэхкири, ачиля пхари тай гаравэласпэ манушэндар панч чён. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Тай пхэнэлас: — Со терда манца Рай? Вздыкхляпэ пэ ман! И слиля ладжявимо мандар англа манушэн! ");
INSERT INTO rmyservi_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Пэ шовто чён, сар Елизавета ачиля пхари, ангело Гавриило сля бичалдо Дэвлэстар дэ форо Назарето, саво ачел дэ пхув Галилея, ");
INSERT INTO rmyservi_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","чятэ, савя акхарэнас Мария, пала савя дэне лав тэ отдэ ла пала Иосифо Давидохкэрэ родостар. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ангело авиля латэ тай пхэнда: — Лошав, бахтали! Рай исин туґа! ");
INSERT INTO rmyservi_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Вой на полиля, со када терэлпэ тай сар тэ полэ лэхкэрэ лава. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ангело пхэнда лати: — На дар, Мария! Дэвэл дэня тути бахт бари! ");
INSERT INTO rmyservi_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Акэ, ту авэґа пхари тай бэнёґа Чяворэ, и дэґа Лэсти Лав Исусо. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Вов авэла баро, тай Лэ авэна тэ акхарэ Барэдэрэхкоро Чяво. Дэвэл Рай дэла Лэсти троно, пэ савэ бэшэлас тхагари Давидо, дад Лэхкоро. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","И авэла Вов Тхагари дэ родо Иаковохкоро, и Тхагаримо Лэхкоро никала на пэрэачела. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Мария пхучля ангелостар: — Сар откада вса авэла, кала мэ чей и муршэ на джянав? ");
INSERT INTO rmyservi_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ангело пхэнда лати: — Свэнто Фано сджяла упрал пэ тут, и зор Барэдэрэхкири ушарэла тут. И кодэлэсти Свэнто, Саво бэнёлапэ, акхарэлапэ Дэвлэхкэрэ Чявэґа. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Акэ и Елизавета, тирэ родостар, пэ савя пхэнэнас «бичяворэнгири», шовто чён, сар ачиля пхари дэ пуранэн бэршэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Акэ, важ Дэвлэ нэнай нисо, соб Вов тэ на стерэл! ");
INSERT INTO rmyservi_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Тунчи Мария пхэнда: — Дэвэл — муро Хулай, мэк авэла вса, сар ту пхэндан. Тай отджиля латар ангело. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Проджиля набут вряма, и Мария стидэняпэ тай сигэдэр джиля дэ форо Иудеенгоро, саво ачелас машкар плаен. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Тай авиля дэ цэр Захариястэ и наисардапэ Елизаветаґа. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Кала Елизавета шунда лакэрэ лава, подхукля чяворо тала лакэрэ їлэ, и пэ Елизавета сджиля Свэнто Фано. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Вой ваздэня пэхкоро ґласо тай пхэнда: — Бахтали ту машкар джювлен, тай бахтало Чяворо, Савэ ту пхиравэх тала тирэ їлэ! ");
INSERT INTO rmyservi_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Пала со манди кадыя бахт, со авиля мандэ Мурэ Раехкири дэй? ");
INSERT INTO rmyservi_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Кала ашундом тиро ґласо, тунчи ваздэняпэ чяворо дэ мурэ їлэ лошаґа. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Бахтали ту, колэсти со патинян и Раехкэрэ лавэсти и со авэла кади, сар Вов пхэнда! ");
INSERT INTO rmyservi_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","И пхэнда Мария: — Ашарэл Рае води муро, ");
INSERT INTO rmyservi_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","и лошавэл фано муро англа Дэвлэ мурэ, Саво фирисарэл ман. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Вов удыкхля ман, бутярня, сави нисо на ачел, и акана всавэрэ родуря пхэнэна, со бахтали мэ, ");
INSERT INTO rmyservi_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","кала шунэна, со Дэвэл Зорало стерда важ ман кадэва баро рындо. И свэнто исин Лав Лэхкоро! ");
INSERT INTO rmyservi_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","И родонэндэ, савэ полэн и трашан Лэстар, Вов обрисявэл ковло їло Пэхкоро! ");
INSERT INTO rmyservi_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Барэ рындуря стерда Вов зоралэ вастэґа, розпхагля дрома пхутимаренди. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Вов счута раен лэнгэрэ трононэндар и ваздэня упрэ чёрэн, ");
INSERT INTO rmyservi_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","бокхалэн чялярда лачимаґа, ай барвалэн мукля шушэ вастэнца. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Авиля Лэсти пэ гындо тэ подрицарэ Израиле, бутярнэ Лэхкэрэ, ");
INSERT INTO rmyservi_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","сар дэня Вов лав амарэ дадэнди, Авраамости тай лэхкэрэ родости пэ всавири вряма. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Мария просля латэ пашэ трин чён тай рисиля цэрэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Тай авиля вряма Елизаветати тэ бэнё, и вой бэня чяворэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Пашунэ мануша и родо лакоро шундэ, сар Рай дэня лати баро лачимо Пэхкоро, тай лошавэнас їтханэ лаґа. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Пэ охто диво авиле вонэ тэ обчинэ чяворэ, и камле тэ дэ лэсти лав Захария, кади, сар акхарэнас лэхкэрэ дадэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Нэ Елизавета, лэхкири дэй, пхэнда: — Нат, дэн лэсти лав Иоанно. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Пхэндэ лати: — Ника дэ тумаро родо кади на акхарэн! ");
INSERT INTO rmyservi_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Тай пхученас вастэнца лэхкэрэ дадэстэ, Захариястэ, камле тэ уджянэ лэстэ, сар вов камэл тэ акхарэ чяворэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Захария помангля сандёры важ лилэн тай чинда упрал: «Лэсти лав Иоанно». Всавэрэ прылиле када пала дыво. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Тунчи отмукля лэсти муй и чиб, и вов ачиля тэ дэдумэ тай тэ ваздэ слава Дэвлэсти. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","И всавэрэн пашунэн облиля бари дар, и када вса розджиляпэ пав всавири Иудея плаенгири. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Мануша, савэ шундэ вса кода, пхученас еджинэ пэстэ: — Каґа дурэдэр авэла кадэва чяворо? И Раехкоро васт сля пэ чяворэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ай Свэнто Фано сджиля пэ Захария, Иоаннохкэрэ дадэ, и вов ачиля тэ дэдумэ Дэвлэстар: ");
INSERT INTO rmyservi_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","— Тэлював англа Тут, Бахтало Рай, Дэвэл Израилехкоро! Ту авилян Тирэ манушэндэ тай фирисардан лэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ваздэня важ амэн Фирисаре цэрэстар, савэстар исин Тиро бутярно Давидо, ");
INSERT INTO rmyservi_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","зрицардан Тиро лав, саво Ту пхэнэґас дэ думутни вряма Тирэ свэнтонэ англунаренца, ");
INSERT INTO rmyservi_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","со фирисарэґа амэн врыжымашэндар, кодэлэндар, савэ вурыцён амэндар. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Вов сикавда ковло їло Пэхкоро амарэ дадэнди тай на бистарда, со спхангля лэнца Еджино Пэ Свэнтонэ заветоґа. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Солаханя Вов Авраамости, амарэ дадэсти, ");
INSERT INTO rmyservi_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","со фирисарэла амэн врыжымашэндар, соб амэ битрашакаро тэ терах свэнто бути англа Лэстэ, ");
INSERT INTO rmyservi_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","соб тэ авэл амаро джювимо свэнто тай чячюно англа Лэхкоро Муй всавэрэ бэрша амарэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","И тут, чяворо, акхарэна Барэдэрэхкоро англунари, колэсти со ту джяґа англа Рае и лачярэґа Лэсти дром, ");
INSERT INTO rmyservi_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","и тховэґа Лэхкэрэ манушэнди дэ гындо, со Дэвэл злэл лэндар бэзимо и фирисарэла лэнгэрэ водя. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Пэхкэрэ ковлэ їлэстар Дэвэл бичалэла амэнди Кхам, Саво ваздэлапэ дэнзор, ");
INSERT INTO rmyservi_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","и манушэнди, савэ мэрэн дэ калима, дэла одуд и сикавэла амэнди дром, саво анэл пачя. ");
INSERT INTO rmyservi_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ай чяворо барёлас, тай фано лэхкоро ачелас зорало, и сля вов дэ шуки пхув ды кодыя вряма, кала трэбуни лэсти сля тэ сикавэпэ манушэнди дэ Израили. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Дэ кодыя вряма императоро Августо чинда упхэнимо, соб тэ пэрэдинэ и тэ зачинэ, скици манушэн джювэл пав всавири римско пхув. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Када сля англуно упхэнимо пала кода, соб тэ пэрэдинэ и тэ зачинэ манушэн, кодэла вряматар, кала Квиринии ачиля раеґа дэ Сирия. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","И всавэрэ мануша джянас тэ зачинэпэ, кожно дэ пэхкоро форо. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Тунчи и Иосифо Назаретостар, саво ачел дэ Галилея, джиля дэ Иудея, дэ форо Давидохкоро, Вифлеемо, колэсти со вов сля Давидохкэрэ родостар. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Иосифо джиля, соб лэ тэ зачинэн, їтханэ Марияґа, лэхкиря тэрняґа, сави сля пхари. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Дэ Вифлеемо авиля вряма, кала лати трэбуни сля тэ бэнё. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Тай бэня пэхкэрэ англунэ Чявэ, закхувда Лэ дэ похтан тай тховда дэ граждо, колэсти со дэ цэр важ акхардэн манушэн на сля лэнди тхан. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Надур сле чукняря, савэ чяравэнас пэ маля пэхкэрэн бакрэн и бузнен и прыдыкхэнас пала лэн ратяґа. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","И акэ, ачиля англа лэндэ ангело Раехкоро, и слава Дэвлэстар, сар баро одуд, дэня пэ лэндэ. И бари дар облиля лэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Нэ ангело пхэнда лэнди: — На даран! Мэ пхэнава тумэнди пала бари лош, сави авэла всавэрэ манушэнди. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Акана бэняпэ тумэнди дэ форо Давидохкоро Фирисари, Саво исин Рай Христосо. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","И акэ тумэнди шпэра: тумэ аракхэна Чяворэ, закхувдэ дэ похтан, Саво пашлёл дэ граждо. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Тунчи упралимастар авиле фартэ бут ангелонэн, савэ ваздэне бари слава Дэвлэсти тай пхэнэнас: ");
INSERT INTO rmyservi_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","— Слава Дэвлэсти пэ упралима, а пэ пхуя пачя манушэнди, важ савэн ковлиля Дэвлэхкоро їло! ");
INSERT INTO rmyservi_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Кала ангелуря ваздэнепэ лэндар упрэ, чукняря пхэндэ екх екхэсти: — Авэн дэ Вифлеемо, дыкхаґа, со котэ стердапэ, пала со амэнди пхэнда Рай. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Вонэ сиго авиле дэ форо Вифлеемо и аракхле Мария, Иосифо тай Чяворэ, Саво пашлёлас дэ граждо. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ай кала дыкхле Лэ, тунчи розпхэндэ лэнди вса, со вонэ ашундэ пала Чяворэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Всавэрэ, ко шундэ лэн, дэнас дыво лавэнди, савэ пхэндэ чукняря. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ай Мария стховэлас кадэла лава дэ пэхкэрэ їлэ тай думисарэлас пала лэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Тунчи чукняря рисиле павпалэ, ашарэнас Дэвлэ и ваздэнас Лэсти слава пала кода, со дыкхле и со лэнди сля пхэндо. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Пэ охто диво, кала авиля вряма тэ обчинэ Чяворэ, Лэсти дэне Лав Исусо. Кадэва Лав дэня Лэсти ангело, кала дэй Исусохкири инте на сля пхари. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Авиля вряма, кала Мария тай Иосифо жужардэпэ пав Моисеехкэрэ Упхэнима, тай тунчи вонэ лиджялдэ Чяворэ дэ Ерусалимо, соб тэ свэнтисарэ Лэ Раести. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Сар чиндо дэ Дэвлэхкэрэ Упхэнима: «Чяворэ, саво бэняпэ англуно, трэбуни тэ свэнтисарэ Раести». ");
INSERT INTO rmyservi_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","И тэ анэ свэнто жэртва, дон ґолубонэн чи дон ґолубонэнгэрэ пуицен, сар пхэндо дэ Упхэнима Раехкэрэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Тунчи джювда дэ Ерусалимо екх мануш, савэ акхарэнас Симеоно. Вов сля дэвликуно тай жужэ їлэґа и дожутярэлас, со Дэвэл подрицарэла Израиле, тай Свэнто Фано сля пэ лэстэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Свэнто Фано пхэнда лэсти, со вов на мэрэла ды кодэлэ, сар на удыкхэла Христо Дэвлэхкэрэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Лэ лиджялда Свэнто Фано дэ храмо, кала дад и дэй андэ Чяворэ Исусо, соб тэ стерэ вса, сар трэбуни пав Упхэнима. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Симеоно лиля Чяворэ пэ вастэн, ваздэня слава Дэвлэсти тай пхэнда: ");
INSERT INTO rmyservi_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","— Акана отмукэх Ту, Дэвла, Хулае, Тирэ бутярнэ и дэх лэсти пачя кади, сар Ту и пхэндан. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Колэсти со дыкхле мурэ якха фирисаримо Тиро, ");
INSERT INTO rmyservi_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","саво Ту лачярдан англа всавэрэн манушэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Вов — одуд, саво дэла душлимо важ всавэрэ народуря и анэла слава Тирэ манушэнди, Израилести. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Дад и дэй прылиле пала дыво лава, савэ Симеоно пхэнда пала Чяворэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Тунчи Симеоно пхэнда бахталэ лава лэнди тай дэдуманя Марияти, Исусохкиря дати: — Важ Кадэлэ Чяворэ, Саво пашлёл катэ, бут манушэн дэ Израили тэлэдэна и бут ваздэнапэ. И тути еджиняти чюри заджяла дэ їлэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Вов авэла сар шпэра, сави бут мануша на прылэна. И оттерэлапэ вса чёрахано, со мануша рицарэн пэстэ дэ їлэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Катэ кади ж сля и англунарька Анна, чей Фануилохкири, Асирохкэрэ родостар. Вой сля манушни дэ пуранэн бэршэн, сави выджиля паларом тэрня чяґа и пэхкэрэ ромэґа проджювда эфта бэрш. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Тунчи латэ муля ром, и вой джювда еджини охтодэша штар бэрш. Диво и рят вой терэлас бути важ Дэвлэ, сля дэ мангима и посто и на уджялас храмостар. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Дэ кодыя вряма вой поджиля и ачиля тэ ашарэ Дэвлэ. Тай розпхэнэлас пала Чяворэ всавэрэнди, савэ дожутярэнас фирисаримо важ Ерусалимо. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Кала Мария и Иосифо стердэ Чяворэґа вса пав Упхэнима Раехкэрэ, тунчи рисиле павпалэ дэ Галилея, дэ пэхкоро форо Назарето. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Чяворо ж барёлас тай бэршэнца прылэлас бари годи и зор, тай Дэвлэхкоро мищимо сля Лэґа. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Исусохкэрэ дад и дэй кожно бэрш пхирэнас пэ Патради дэ Ерусалимо. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","И кала Лэсти сля дэшудуй бэрш, вонэ джиле дэ Ерусалимо пэ сырботори, сар сля прылито. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","А кала проджиля сырботори и вонэ рисявэнас цэрэ, Чяворо Исусо ачиляпэ дэ Ерусалимо, нэ дад и дэй на додыкхле када. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Нэ думисардэ, со Вов джял аврэ манушэнца. Кала ж проджиле екх диво дромэґа, тунчи ачиле тэ родэ Лэ машкар пэхкэрэн манушэн и джянглэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Тай на аракхле Лэ, тунчи рисиле дэ Ерусалимо и родэнас Лэ котэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Кала проджиле трин дивэ, аракхле Лэ дэ храмо. Вов бэшэлас сиклимаренца, шунэлас лэн тай пхучелас лэндэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Всавэрэ шунэнас Лэ тай дэнас дыво Лэхкэрэ годяти тай лавэнди. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Кала дад и дэй удыкхле Лэ, прылиле када пала баро дыво. Тунчи Лэхкири дэй пхэнда Лэсти: — Чяворо! Со Ту стердан амэнца? Мэ тай дад Тиро родаґас Тут баря дукхаґа дэ їлэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Вов пхэнда лэнди: — Пэ со тумэ родэнас Ман? Чи на джянэн тумэ, со Манди трэбуни тэ авэ дэ цэр Мурэ Дадэстэ? ");
INSERT INTO rmyservi_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Нэ вонэ на полиле, пала со Вов пхэнда. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Вов рисиля лэнца дэ Назарето тай сля кандуно лэнди. Лэхкири ж дэй стидэлас кодэла лава дэ пэхкэрэ їлэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Исусо барёлас, и Лэхкири годи ачелас барэдэр, а Дэвэл и мануша камэнас Лэ вса будэр и будэр. ");
INSERT INTO rmyservi_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Пэ дэшупанчто бэрш, кала Тиверии сля императоро, и кала Понтии Пилато сля барэдэрэґа дэ Иудея, а Иродо сля тетрархо дэ Галилея, лэхкоро пхрал, Филиппо, сля тетрархо дэ Итурея тай дэ пхув Трахонитско, а Лисании сля тетрархо дэ Авилиния. ");
INSERT INTO rmyservi_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Англунэ рашаенца тунчи сле Аннас тай Каиафа. Дэ кодыя вряма бичалдо сля Лав Дэвлэхкоро дэ шуки пхув Иоанностэ, Захарияхкэрэ чявэстэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Иоанно пхирэлас пав всавири пхув паша Иордано, прыакхарэлас манушэн тэ отрисявэ бэзимастар тай тэ болдэпэ, соб Дэвэл тэ эртисарэл лэнгоро бэзимо. ");
INSERT INTO rmyservi_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Сар чинда англунари Исаия: «Гласо дэ шуки пхув типисявэл: Лачярэн дром Раести, терэн важ Лэ чяче дромора. ");
INSERT INTO rmyservi_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Тхана, савэ машкар плаен, — ваздэнапэ, а вуче плая тай цыкнэ плаёра — тэлёна, бангэ дрома — выцырдэнапэ, и помардэ дрома — авэна лачярдэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Тунчи всавэрэ мануша дыкхэна фирисаримо Дэвлэхкоро». ");
INSERT INTO rmyservi_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Иоанно пхэналас манушэнди, савэ авиле лэстэ тэ болдэпэ: — Родо сапэнгоро! Ко пхэнда тумэнди тэ нашэ бидатар, сави пэ тумэн джял? ");
INSERT INTO rmyservi_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Мэк тумарэ рындуря сикавэн, со тумэ ачявдэ бэзимо, и на думисарэн: «Амаро дад исин Авраамо». Пхэнав тумэнди, со Дэвлэстэ исин зор кадэла барэндар тэ терэ чявэн Авраамости. ");
INSERT INTO rmyservi_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Акэ, товэр лачярдо и тала каштэнгоро корни пашлёл: кожно кашт, саво на анэл лачё барило, сщинэн и чувэн дэ яга. ");
INSERT INTO rmyservi_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Пхученас лэ мануша: — Со амэнди тэ терэ? ");
INSERT INTO rmyservi_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Вов пхэнда лэнди: — Кастэ исин дуй гада, отдэ екх кодэлэсти, кастэ нэнай. И кастэ исин хамо, дэ епаш кодэлэсти, кастэ нэнай. ");
INSERT INTO rmyservi_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Авиле тэ болдэпэ стидэмаря, савэ лэнас налогуря, тай пхучле лэстар: — Сиклимари! Со амэнди тэ терэ? ");
INSERT INTO rmyservi_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Вов пхэнда лэнди: — На лэн манушэндар будэр, сар тумэнди прыпхэндэ тэ лэн! ");
INSERT INTO rmyservi_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Пхученас лэ и халавдэ: — Со амэ тэ терах? Вов пхэнда лэнди: — На залэн манушэндар зораґа, на дошарэн манушэн ївья и джювэн пэ ловэн, савэ потинэн тумэнди. ");
INSERT INTO rmyservi_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Мануша дожутярэнас тай гинисардэ пала Иоанно: — Чи на Христосо вов исин? ");
INSERT INTO rmyservi_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Иоанно пхэнда всавэрэнди: — Мэ болдав тумэн панеґа, нэ джял пала ман зорэдэр мандар, мэ на ачяв тэ розпхандэ Лэсти пундрангэ. Вов болдэла тумэн Свэнтонэ Фаноґа тай ягаґа. ");
INSERT INTO rmyservi_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Каштуни ґанавди дэ вастэ Лэстэ, тай Вов жужарэла див и стховэла ла дэ граждо, а кода, со ачиляпэ, спхабарэла дэ яга, савя нащи тэ мурдарэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Бут инте со пхэнэлас Иоанно, кала дэдумэлас Бахтало Лав. ");
INSERT INTO rmyservi_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Кала ж Иоанно дошарда Иродо, саво сля тетрархо, пала кода, со вов лиля пала пэ пхралэхкиря ромня, и пала авэр налаче рындуря, ");
INSERT INTO rmyservi_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","тунчи Иродо додэня пэхкэрэ бэзимастэ инте кода, со чута Иоанно дэ барунэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Кала болдэнепэ всавэрэ мануша, болдэняпэ кади ж Исусо. И кала Вов мангэласпэ, оттердапэ упралимо, ");
INSERT INTO rmyservi_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","и Свэнто Фано сджиля упрал пэ Исусо, сар ґолубо, тай сля ґласо упралимастар, саво пхэнэлас: — Ту — Муро камло Чяво! Ту — Мури бари бахт! ");
INSERT INTO rmyservi_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Кала Исусо ачиля тэ терэ бути важ Дэвлэ, Лэсти сля пашэ трянда бэрш. Сар думисарэнас, Вов сля Иосифохкоро Чяво. И Лэхкэрэ пхурэнца сле Илья, ");
INSERT INTO rmyservi_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Матфато, Левии, Мелхии, Ианнаи, Иосифо, ");
INSERT INTO rmyservi_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Маттафия, Амосо, Наумо, Еслии, Наггеи, ");
INSERT INTO rmyservi_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Маафо, Маттафия, Шымьи, Иосифо, Иодаи, ");
INSERT INTO rmyservi_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Иоханано, Рисаи, Зоровавели, Шэалтиило, Нирии, ");
INSERT INTO rmyservi_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Мелхии, Аддии, Косамо, Элмадамо, Иро, ");
INSERT INTO rmyservi_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Иосии, Элиезеро, Иоримо, Матфато, Левии, ");
INSERT INTO rmyservi_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Симеоно, Иуда, Иосифо, Ионамо, Элиакимо, ");
INSERT INTO rmyservi_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Мелеаи, Маинаи, Маттафаи, Нафано, Давидо, ");
INSERT INTO rmyservi_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Иессеи, Овидо, Боазо, Сала, Нахшоно, ");
INSERT INTO rmyservi_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Аминадаво, Админо, Арнии, Хецроно, Парецо, Иуда, ");
INSERT INTO rmyservi_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Иаково, Исаако, Авраамо, Терахо, Нахоро, ");
INSERT INTO rmyservi_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Серуго, Реуо, Пелего, Еверо, Шэлахо, ");
INSERT INTO rmyservi_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Каинано, Арпахшадо, Симо, Нои, Ламехо, ");
INSERT INTO rmyservi_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Мафусало, Енохо, Иаредо, Малелеило, Каинано, ");
INSERT INTO rmyservi_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Еносо, Сифо, Адамо, Дэвэл. ");
INSERT INTO rmyservi_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Исусо, пхэрдило Свэнтонэ Фаноґа, рисиля Иорданостар тай лиджялдо сля Фаноґа дэ шуки пхув. ");
INSERT INTO rmyservi_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Котэ Лэ саранда дивэ зумавэлас баро бэнг. Всавэрэ кадэла дивэ Вов нисо на халас тай ачиля бокхало. ");
INSERT INTO rmyservi_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Тунчи пхэнда Лэсти баро бэнг: — Кала Ту — Дэвлэхкоро Чяво, тер мандро кадэлэ барэстар. ");
INSERT INTO rmyservi_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Пхэнэл лэсти Исусо павпалэ: — Чиндо: «На кици мандрэґа джювэл мануш». ");
INSERT INTO rmyservi_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Тунчи ваздэня Лэ баро бэнг пэ вучё плай тай сикавда Лэсти всавэрэ тхагарима, савэ исин пэ люмля, пала цыро вряма. ");
INSERT INTO rmyservi_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Тай пхэнда Лэсти баро бэнг: — Мэ отдава Тути всавэрэ зор тай слава, савэ исин дэ кадэлэн тхагаримэн. Вса када дэно манди, и мэ када дав, касти камав. ");
INSERT INTO rmyservi_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Вса када авэла Тиро, кала Ту тэлёґа англа ман. ");
INSERT INTO rmyservi_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Исусо пхэнда лэсти: — Чиндо: «Рае Дэвлэсти тэлюв тай кици Лэсти тер тири бути». ");
INSERT INTO rmyservi_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Тунчи баро бэнг лиджялда Лэ дэ Ерусалимо, тховда пэ майвучё тхан дэ храмо тай пхэнда Лэсти: — Кала Ту — Дэвлэхкоро Чяво, тунчи хук тэлэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Колэсти со чиндо: «Ангелонэнди Пэхкэрэнди Вов прыпхэнэла тэ фирисарэн Тут». ");
INSERT INTO rmyservi_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","«Пэ вастэн пхиравэна Тут, тэ на дукхавэлпэ барэстар пуро Тиро». ");
INSERT INTO rmyservi_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Исусо пхэнда лэсти павпалэ: — Пхэндо: «На зумав Тирэ Рае Дэвлэ». ");
INSERT INTO rmyservi_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Тунчи баро бэнг пэрэачиля тэ зумавэ Лэ тай отджиля Лэстар пэ вряма. ");
INSERT INTO rmyservi_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Тунчи Исусо рисиля дэ Галилея, пхэрдило зораґа Фаностар, тай розджиляпэ пала Лэ дума пав всавири кодыя пхув. ");
INSERT INTO rmyservi_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Вов сиклярэлас дэ синагоги, тай всавэрэ ашарэнас Лэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Тунчи Исусо авиля дэ Назарето, тев Вов выбариля, и, сар Лэстэ сля прылито, дэ суббота заджиля дэ синагога тай вщиля, соб тэ динэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Лэсти дэне лил, саво чинда англунари Исаия. Исусо оттерда лэ тай аракхля тхан, тев сля чиндо: ");
INSERT INTO rmyservi_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","— Фано Раехкоро пэ Ман, колэсти со Вов помакхля Ман тэ пхэнэ Бахтало Лав чёрэнди. Вов бичалда Ман тэ дэдумэ спханглэ манушэнди, со лэн отмукэна пэ воля, корэнди, со авэна тэ дыкхэ, и тэ фирисарэ кодэлэн, савэ хан грыжа, ");
INSERT INTO rmyservi_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","тай тэ розпхэнэ, со авиля лачи вряма Раехкири. ");
INSERT INTO rmyservi_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Тунчи Исусо стховда лил, отдэня павпалэ бутярнэсти дэ синагога тай бэшля. Тай всавэрэ ды екхэ дэ синагога дыкхэнас пэ Лэстэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Тай ачиля тэ дэдумэ лэнди: — Авдивэ стердапэ пав лавэн, савэ тумэ шундэ екхатар. ");
INSERT INTO rmyservi_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Всавэрэ ашарэнас Лэ тай фартэ лошавэнас Лэхкэрэ бахталэ лавэнди. Тай пхэнэнас: — Чи на Иосифохкоро Вов Чяво? ");
INSERT INTO rmyservi_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Исусо пхэнда лэнди: — Тумэ дэна Манди пэ гындо лав, сар мануша пхэнэн: «Састимари, састяр еджино пэ!» И кади ж пхэнэна: «Амэ шундэ, со Ту тердан дэ Капернаумо. Стер када и катэ, тев Ту выбарилян». ");
INSERT INTO rmyservi_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Нэ пхэнав тумэнди чячимо: ни екхэ англунаре на прылэн котэ, тев вов бариля. ");
INSERT INTO rmyservi_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Пхэнав тумэнди чячимо: дэ вряма, кала джювда Илья, дэ Израили сля бут джювлен, савэндэ муле рома. Тунчи трин епашеґа бэрш на сля брышынд, тай пав всавири пхув сля бари бокх. ");
INSERT INTO rmyservi_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Тай никастэ лэндар на сля бичалдо Илья, кици дэ Сарепта паша Сидоно джювлятэ, савятэ муля ром. ");
INSERT INTO rmyservi_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Кади ж дэ Израили бут сля насвалэн, пэ савэн сля проказа, кала джювда англунари Елисеи. Тай нико лэндар на састярдапэ, кици екх Неемано Сириятар. ");
INSERT INTO rmyservi_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Кала мануша дэ синагога шундэ кадэла лава, вонэ фартэ мижыле. ");
INSERT INTO rmyservi_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Тунчи вонэ всхукле тай поцырдэне Исусо аври пэ плай, пэ савэ сля ваздэно форо, соб тэ счувэ тэлэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Нэ Вов проджиля машкар лэн тай уджиля котарь. ");
INSERT INTO rmyservi_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Тунчи Исусо джиля дэ форо Капернаумо, саво дэ Галилея, тай дэ суббота сиклярэлас котэ манушэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Тай динэнас пала дыво сикляримо Лэхкоро, колэсти со дэ Лэхкэрэ лавэн сля бари зор. ");
INSERT INTO rmyservi_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Котэ, дэ синагога, сля мануш, дэ савэ сля нажужэ бэнгэхкоро фано. Тай вов фартэ затиписиля: ");
INSERT INTO rmyservi_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","— Ааа! Со Тути трэбуни амэндар, Исусо Назаретостар? Ту авилян, соб тэ хасярэ амэн? Мэ джянав, Ко Ту Кацаво! Ту — Свэнто Дэвлэхкоро! ");
INSERT INTO rmyservi_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Нэ Исусо запхэнда лэсти: — Заач мулком тай выджя лэстар! Тунчи бэнг аравда манушэ англа всавэрэн пэ пхуя, тай выджиля лэстар, тай на стерда манушэсти нисави бида. ");
INSERT INTO rmyservi_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Тунчи дэня пэ всавэрэн бари дар, тай пхэнэнас екх екхэсти: — Катарь дэ Лэхкэрэ лавэн кацави бари зор, со Вов прыпхэнэл нажужэнди тай вонэ кандэн Лэ? ");
INSERT INTO rmyservi_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Тай дума пала Исусо розджиляпэ пав всавири кодыя пхув. ");
INSERT INTO rmyservi_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Тунчи Вов ачявда синагога тай джиля Симоностэ цэрэ. Симонохкири пхуромни пашлёлас насвали дэ пхабарима. Тай мангле Исусо, соб Вов тэ састярэл ла. ");
INSERT INTO rmyservi_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Вов тэлиля латэ тай прыпхэнда пхабаримасти тэ ачявэл ла. Тунчи пхабаримо ачявда ла, тай джювли екхатар ущиля и ачиля тэ стидэ важ лэн скаминд. ");
INSERT INTO rmyservi_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Кала бэшэлас кхам, ачиле тэ анэ Исусостэ фартэ насвалэн манушэн. Вов тховэлас пэ лэндэ васта тай састярэлас лэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","И бутэ манушэндар выджянас бэнга тай типисявэнас: — Ту — Чяво Дэвлэхкоро! Нэ Исусо пхандэлас лэнди муя тай запхэнэлас тэ дэдумэ, колэсти со вонэ джянгле, со Вов — Христосо. ");
INSERT INTO rmyservi_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Кала авиля диво, Исусо джиля дэ шуки пхув, нэ мануша родэнас Лэ. Тай кала аракхле, мангэнас Лэ, соб тэ ачелпэ лэнца. ");
INSERT INTO rmyservi_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Нэ Исусо пхэнда лэнди: — Манди трэбуни тэ пхэнэ Бахтало Лав пала Дэвлэхкэрэ Тхагарима и дэ аврэн форонэн. Пэ кадэва рындо Мэ и слём бичалдо. ");
INSERT INTO rmyservi_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Тай сиклярэлас дэ синагоги пав Иудея. ");
INSERT INTO rmyservi_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Екхвар Исусо ачиля паша Генисаретско озеро, тай бут манушэн стидэнепе паша Лэстэ, соб тэ шунэ Дэвлэхкоро Лав, и стасавэнас Лэ всавэрэ ригэндар. ");
INSERT INTO rmyservi_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Вов удыкхля дуй лодкы пэ пане паша пхуя и мачярен, савэ выджиле лодкэндар и халавэнас кхувдя. ");
INSERT INTO rmyservi_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Исусо заджиля дэ Симонохкири лодка тай помангля Симоно тэ отлиджял ла пав пане надур пхуятар. Тунчи бэшля и лодкатар ачиля тэ сиклярэ манушэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Кала ж пэрэачиля тэ сиклярэ, пхэнда Симоности: — Отлиджя лодка дурэдэр пхуятар, тев будэр пани, тай зачув кхувдя тэ астарэн мачё! ");
INSERT INTO rmyservi_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Симоно пхэнэл Лэсти: — Пхурэдэр амаро! Амэ всавири рят тераґас пхари бути и камле тэ астарэ мачё, тай вса ивья. Нэ сар Ту пхэнэх, мэ кандава Тут тай инте зачувава кхувди. ");
INSERT INTO rmyservi_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Кала вонэ кади стердэ, тунчи астардэ фартэ бут мачен, пэ скици бут, со кхувди ачиля тэ чинэпэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Тунчи вонэ сикавдэ вастэнца амалэнди, савэ сле пэ авэр лодка, соб тэ подрицарэн лэн. Кодэла авиле тай їтханэ зачутэ пхэрдо мачё дэ лэдуй лодкы, кади со лодкы ачиле тэ тасё. ");
INSERT INTO rmyservi_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Кала дыкхля вса откада Симоно Пётро, вов тэлиля Исусохкэрэ чянгэндэ тай пхэнда: — Выджя мандар, Рае! Кодэлэсти со мэ мануш дэ бэзима! ");
INSERT INTO rmyservi_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Бари дар дэня пэ лэстэ тай пэ всавэрэн, ко дыкхля, скици мачё вонэ астардэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Трашане кади ж амала Симонохкэрэ, Иаково тай Иоанно, Зеведеехкэрэ чявэ. Нэ Симоности Исусо пхэнда: — На дар. Акана манушэн авэґа тэ астарэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Тунчи вонэ выцырдэне лодкы пэ пхув, ачявдэ вса тай джиле пала Исусо. ");
INSERT INTO rmyservi_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Екхвар Исусо сля дэ екх форо. Тунчи авиля Лэстэ мануш, пэ савэстэ сля насвалимо проказа. Вов пэля англа Исусо пэ муй тай мангля Лэ мангимаґа: — Рае! Коли закамэґа, Ту жужарэґа ман! ");
INSERT INTO rmyservi_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Исусо процырдэня васт, лиляпэ лэстэ тай пхэнда: — Камав, жужарпэ! Тунчи проказа екхатар сджиля лэстар. ");
INSERT INTO rmyservi_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Исусо прыпхэнда лэсти: — Никасти на розпхэн пала кода, нэ джя, сикавпэ рашаести тай ан жэртва пала кода, со жужарданпэ, сар пхэнда Моисеи, соб вонэ када тэ дыкхэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Нэ инте будэр розджиляпэ дума пала Исусо, тай фартэ бут манушэн джянас Лэстэ, соб тэ шунэ Лэхкэрэ лава тай тэ састярэпэ бутэ дукхэндар. ");
INSERT INTO rmyservi_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Нэ Вов уджялас дэ тханэн, тев манушэн на сля, соб тэ мангэпэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Екхвар, кала Исусо сиклярэлас манушэн, котэ сле фарисея тай сиклимаря пав Упхэнима. Вонэ авиле всавэрэ тханэндар Галилеятар, Иудеятар тай Ерусалимостар. И зор Раехкири сля пэ Исусо, соб тэ састярэ манушэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Тай акэ, андэ пэ пато насвалэ, саво на пхирэлас, тай камле тэ залиджя лэ дэ цэр тай тэ тховэ англа Исусо. ");
INSERT INTO rmyservi_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Тай на аракхле, сар тэ анэ лэ дэ цэр, колэсти со фартэ бут манушэн сля паша цэрэ. Тунчи вонэ ваздэнепэ упрэ пэ цэр, розлиле ушарди тай змукле насвалэ пэ пато англа Исусо. ");
INSERT INTO rmyservi_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Кала Вов удыкхля лэнгоро патявимо, тунчи пхэнда насвалэсти: — Мануша! Отмукэлпэ тути тиро бэзимо. ");
INSERT INTO rmyservi_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Сиклимаря пав Упхэнима тай фарисея ачиле тэ дэдумэ еджинэ пэсти дэ гындо: — Ко Вов исин, со дэдумэл кацавэ бэзимахкэрэ лава? Кици Дэвлэстэ исин зор тэ эртисарэ бэзимо манушэсти! ");
INSERT INTO rmyservi_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Исусо полиля, со лэндэ дэ гындо, тай пхэнда лэнди: — Сости тумэ гинисарэн кади дэ тумарэн їлэн? ");
INSERT INTO rmyservi_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Со локхэдэр, тэ пхэнэ: «Отмукэлпэ тиро бэзимо», — чи тэ пхэнэ: «Вщи тай пхир»? ");
INSERT INTO rmyservi_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Нэ соб тумэ тэ джянэн, со Манушыканэ Чявэстэ исин зор тэ эртисарэ бэзимо, — пхэнда Вов насвалэсти: — Тути пхэнав: Вщи, лэ пато тиро тай джя цэрэ! ");
INSERT INTO rmyservi_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Тунчи Вов екхатар вщиля англа лэндэ, лиля кода, пэ со пашлёлас, джиля цэрэ и ваздэлас слава Дэвлэсти. ");
INSERT INTO rmyservi_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Тунчи и вонэ ваздэнас Дэвлэсти слава тай пхэнэнас: — Авдивэ амэ пэхкэрэ якхэнца дыкхле кода, со на сля никала! ");
INSERT INTO rmyservi_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Пала кадэлэ Исусо выджиля тай удыкхля стидэмаре, саво лэлас налогуря, акхарэнас лэ Левии. Вов бэшэлас паша тханэ, тев здэнас налогуря. Тай пхэнда лэсти Исусо: — Джя пала Ман! ");
INSERT INTO rmyservi_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Вов ачявда вса тай джиля пала Исусо. ");
INSERT INTO rmyservi_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Тунчи Левии тховда важ Исусо баро скаминд пэстэ цэрэ. Лэнца пала скаминдэ сля бут аврэн манушэн и стидэмарен. ");
INSERT INTO rmyservi_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Фарисея тай сиклимаря пав Упхэнима сле дэ холя и пхученас Исусохкэрэ сиклярнэн: — Сости тумэ хан и пэн стидэмаренца тай бэзимахкэрэ манушэнца? ");
INSERT INTO rmyservi_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Исусо пхэнда лэнди: — На састэ манушэнди трэбуни састимари, нэ насвалэнди. ");
INSERT INTO rmyservi_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Мэ авилём тэ прыакхарэ, соб тэ обрисявэнпэ Дэвлэстэ на бидошакэрэ мануша, а кодэла, савэ джювэн дэ бэзима. ");
INSERT INTO rmyservi_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Тунчи вонэ пхэндэ Исусости: — Иоаннохкэрэ тай фарисеенгэрэ сиклярнэ мангэнпэ тай рицарэн посто, а Тирэ сиклярнэ хан тай пэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Исусо пхэнда лэнди: — Сар тумэ пхэнэна пэ бьяв манушэнди тэ рицарэн посто, кала лэнца тэрно? ");
INSERT INTO rmyservi_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Нэ авэла вряма, кала лэндар залэлапэ тэрно, тунчи авэна тэ рицарэ посто. ");
INSERT INTO rmyservi_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Тунчи Вов пхэнда лэнди кацави дума: — Нико на прысювэл пураня їдатэ котор, саво отчиндо нэвя їдатар. Кодэлэсти со тунчи и нэви їда мусарэла, и пуранятэ на поджяла. ");
INSERT INTO rmyservi_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Нико на чувэл тэрно мол дэ пурано ґравлицико гоноро, колэсти со и гоноро пхарола, и мол розчувэлапэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Нэ тэрно мол чувэн дэ нэвэн ґравлицикунэн гонорэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Тай нико на закамэла тэ пэ тэрно мол, кала зумавда пурано мол, нэ пхэнэла: «Пурано фэдэр». ");
INSERT INTO rmyservi_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Екхвар дэ суббота джялас Исусо сиклярнэнца маляґа, а сиклярнэ сщинэнас див, розкхосэнас вастэнца тай ханас ворзо. ");
INSERT INTO rmyservi_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Койсавэ фарисеендар пхэндэ Лэсти: — Сости тумэ терэн кода, со нащи тэ терэ дэ суббота? ");
INSERT INTO rmyservi_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Исусо пхэнда лэнди: — Тумэ со, на динэнас, со терда Давидо, кала вов тай лэхкэрэ мануша ачиле бокхалэ? ");
INSERT INTO rmyservi_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Вов заджиля дэ Дэвликуно Цэр, лиля мандро, свэнтисардо Дэвлэсти. Вов еджино лэ халя тай дэня пэхкэрэ манушэнди. А кодэва мандро нащи никасти сля тэ ха, кици рашаенди. ");
INSERT INTO rmyservi_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Тунчи Исусо пхэнда лэнди: — Чяво Манушыкано исин субботакоро Хулай. ");
INSERT INTO rmyservi_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Дэ авэр суббота Исусо заджиля дэ синагога тай ачиля тэ сиклярэ. Котэ сля екх мануш, савэстэ чячё васт сля шуко. ");
INSERT INTO rmyservi_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Сиклимаря пав Упхэнима тай фарисея дыкхэнас пала Исусо, чи састярэла Вов дэ суббота, соб тэ дошарэ Лэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Нэ Вов джянэлас лэнгоро гындо тай пхэнда манушэсти шукэ вастэґа: — Вщи тай выджя машкар! Мануш подлиляпэ тай ачиля машкар. ");
INSERT INTO rmyservi_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Тунчи Исусо пхэнда лэнди: — Пхучяв тумэн: трэбуни дэ суббота тэ терэ лачимо чи бибахт? Тэ фирисарэ води чи тэ мулярэ? ");
INSERT INTO rmyservi_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Тунчи Вов подыкхля пэ всавэрэн тай пхэнда манушэсти: — Процырдэ тиро васт! Вов стерда кади, и васт ачиля састо. ");
INSERT INTO rmyservi_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Вонэ фартэ мижыле тай ачиле тэ дэдумэ екх екхэґа, со лэнди тэ терэ Исусоґа. ");
INSERT INTO rmyservi_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Дэ кодэлэн дивэн Исусо джиля пэ плай тэ мангэпэ тай мангляпэ Дэвлэсти котэ всавири рят. ");
INSERT INTO rmyservi_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Кала авиля диво, Исусо акхарда Пэхкэрэн сиклярнэн тай вытидэня лэндар дэшудуен, савэнди дэня лав «апостолуря»: ");
INSERT INTO rmyservi_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Симоно, савэ акхарэнас Пётро, лэхкоро пхрал Андреи, Иаково, Иоанно, Филиппо, Варфоломеи, ");
INSERT INTO rmyservi_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Матфеи, Фома, Иаково Алфеехкоро, Симоно, пэ савэ пхэнэнас «Зилото», ");
INSERT INTO rmyservi_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Иуда Иаковохкоро тай Иуда Искариото, саво ачиля здымареґа. ");
INSERT INTO rmyservi_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Тунчи Исусо змукляпэ лэнца плаестар пэ маля. Паша Лэстэ стидэняпэ фартэ бут манушэн: Лэхкэрэ сиклярнэ, мануша всавиря Иудеятар тай Ерусалимостар, кади ж Тиростар тай Сидоностар, форонэндар, савэ ачен паша море. ");
INSERT INTO rmyservi_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Вонэ авиле тэ шунэ Лэхкэрэ лава тай тэ састярэпэ пэхкэрэ дукхэндар. Тай мануша, савэн марэнас нажужэ, састярэнаспэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Всавэрэ вонэ камле тэ лэпэ Исусостэ, колэсти со Лэстар выджялас бари зор тай састярэлас манушэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Тунчи Исусо подыкхля пэ Пэхкэрэн сиклярнэн тай пхэнда: — Бахталэ тумэ, чёрорэ! Тумаро исин Тхагаримо Дэвлэхкоро. ");
INSERT INTO rmyservi_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Бахталэ тумэ, бокхалэ акана! Тумэ авэна чялярдэ. Бахталэ, савэ ровэн акана! Тумэ авэна тэ лошавэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Бахталэ тумэ, кала мануша тумэн на камэна, кала авэна тэ вытрадэ тумэн, тэ кошэ тумаро лав, тэ пхэнэ пэ тумэн налаче лава пала Чявэ Манушыканэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Кадики ж теренас англунаренца и дада кадэлэ манушэнгэрэ! Лошавэн тунчи тай хукэн лошатар! Бари цимин потинэна тумэнди пэ упралима. ");
INSERT INTO rmyservi_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Нэ бида тумэнди, барвалэ! Тумэ катэ ужэ чялиле джювимаґа. ");
INSERT INTO rmyservi_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Бида тумэнди, чялэ! Тумэ авэна бокхалэ. Бида тумэнди, ко асалпэ акана! Тумэ авэна тэ ровэ и ваздэна типимо дэ грыжа. ");
INSERT INTO rmyservi_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Бида тумэнди, кала авэна тэ ашарэ тумэн всавэрэ мануша! Колэсти со лэнгэрэ дада кади ж ашарэнас хохавнэн англунарен. ");
INSERT INTO rmyservi_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Тумэнди, ко шунэн, Мэ пхэнав: камэн тумарэн врыжымашэн. Терэн лачимо кодэлэнди, ко тумэн на камэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Пхэнэн бахталэ лава кодэлэнди, савэ придэн тумэн мрая. Мангэн Дэвлэ пала кодэлэн, ко акошэл тумэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ко дэла палма тут пав екх чямни, бандяр лэсти авэр. Ко залэл тутар упралуни їда, дэ лэсти тэ отлэ и гад тиро. ");
INSERT INTO rmyservi_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Всавэрэнди, ко мангэл тутэ, дэ. Кодэлэстар, ко отлэл тутар, на манг павпалэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Сар тумэ камэн, соб тумэнди тэ терэн мануша, кади и тумэ терэн лэнди. ");
INSERT INTO rmyservi_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Кала камэн кици кодэлэн, ко камэл тумэн, пала со тумэн тэ ашарэ? Кади ж мануша дэ бэзима камэн кодэлэн, ко лэн камэл. ");
INSERT INTO rmyservi_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Кала терэн лачимо кодэлэнди, ко тумэнди терэл лачимо, пала со тумэн тэ ашарэ? Мануша дэ бэзима кади ж терэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Кала дэн ловэ дэ вуджилима кодэлэнди, кастар думисарэн тэ лэ павпалэ, тунчи пала со тумэн тэ ашарэ? Мануша дэ бэзима кади ж залэн кодэлэнди, кастар думисарэн тэ лэ павпалэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Нэ тумэ камэн тумарэн врыжымашэн, терэн лачимо лэнди, залэн дэ вуджилима тай на дожутярэн, со тумэнди отдэна павпалэ. Тунчи бари цимин тумэнди потинэна. Тумэ авэна Барэдэрэхкэрэ чявэнца, колэсти со Вов терэл лачимо и налаченди, и мижэнди. ");
INSERT INTO rmyservi_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Сар ковло їло тумарэ Дадэстэ, кади тумэ ковлисарэн тумарэ їлэ манушэндэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","На сундисарэн, тай еджинэ на авэна сундисардэ. На дошарэн, тай тумэн на дошарэна. Эртисарэн, тай тумэнди авэла эртисардо. ");
INSERT INTO rmyservi_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Дэнтэ, и тумэнди дэлапэ. Дэлапэ дэ бэрг тумэнди пхэрдо, кади чувэлапэ, со авэла прытасавдо и авэла тэ вычувэпэ аври. Сар тумэ дэна, кади и тумэнди дэно авэла. ");
INSERT INTO rmyservi_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Тунчи Исусо пхэнда кацави дума: — Чи лиджяла коро корэ? Чи на пэрэна вонэ лэдуй? ");
INSERT INTO rmyservi_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Сиклярно на барэдэр сиклимарестар, нэ сар высиклёлапэ, авэла, сар сиклимари. ");
INSERT INTO rmyservi_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Со ту дыкхэх сулуморы дэ якха тирэ пхралэстэ, нэ дэ пэхкиря якха баро кашт на дыкхэх? ");
INSERT INTO rmyservi_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Сар пхэнэґа тирэ пхралэсти: «Пхрала, дэ, вылава сулуморы тиря якхатар!» — кала ту дэ пэхкиря якха баро кашт на дыкхэх? Домуенгоро, англал вылэ кашт тиря якхатар, тунчи мишто дыкхэґа, сар тэ вылэ сулуморы якхатар тирэ пхралэстэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Лачё кашт на анэл цэрно барило. А цэрно кашт на анэл лачё барило. ");
INSERT INTO rmyservi_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Пав барило уджянэлпэ кашт. На стидэн инжыро пусанэ рандендар, на стидэн виноградо пусанэ чярендар. ");
INSERT INTO rmyservi_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Лачё мануш вылэл лачимо мищимастар, саво исин лэстэ дэ їлэ. Налачё мануш вылэл пэхкэрэ їлэстар бибахт. Кода, со пхэрдо дэ їлэ, выджял чибатар манушэстэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Со тумэ акхарэн Ман: «Рае! Рае!» — а на терэн, сар Мэ тумэнди пхэнав? ");
INSERT INTO rmyservi_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Мэ пхэнава тумэнди, пэ кастэ счувэлпэ мануш, саво авэл Мандэ, ашунэл, со Мэ пхэнав, и терэл кода. ");
INSERT INTO rmyservi_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Вов — сар кодэва мануш, саво выґанавда пхув ды барэн и ваздэня пэхкоро цэр пэ баруно фундаменто. Кала дэня пэ цэр баро пани лэнятар, вов на аравда цэр, колэсти со вов сля мишто стердо. ");
INSERT INTO rmyservi_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Мануш, саво шунэл Муро лав, нэ на джювэл пав лэ, счувэлпэ пэ манушэ, саво ваздэня цэр пэ пхуя. Тунчи дэня пэ цэр баро пани лэнятар, екхатар аравда кодэва цэр и фартэ розмарда лэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Кала Исусо пэрэачиля тэ дэдумэ манушэнди, Вов авиля дэ Капернаумо. ");
INSERT INTO rmyservi_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Котэ сля екх шэлякоро пхурэдэр. Лэхкоро бутярно, саво важ лэ сля кучутно, фартэ занасвалиля и сля пашэ мэримастэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Шэлякоро пхурэдэр шунда пала Исусо тай бичалда Лэстэ иудеенгэрэн пхурэдэрэн тэ мангэн Исусо, соб Вов тэ авэл и тэ састярэл бутярнэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Вонэ авиле Исусостэ, фартэ мангле Лэ и пхэнэнас: — Кадэва мануш ачел, соб Ту тэ терэх важ лэ кава рындо. ");
INSERT INTO rmyservi_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Колэсти со Вов камэл амаро народо тай ваздэня амэнди синагога. ");
INSERT INTO rmyservi_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Исусо джиля лэнца. Кала Вов сля пашэ цэрэстэ, шэлякоро пхурэдэр бичалда Лэстэ англал пэхкэрэн амалэн, соб вонэ тэ пхэнэн: — Рае! На трэбуни Тути тэ цинё! Мэ на ачяв, соб Ту тэ заджях мандэ дэ цэр! ");
INSERT INTO rmyservi_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Нэ мэ еджино на ачяв тэ авав Тутэ. Кици пхэн лав, и састярэлапэ бутярно муро. ");
INSERT INTO rmyservi_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Упрэ мандар исин пхурэдэра, савэн мэ кандав. Нэ исин мандэ халавдэ, савэ ман кандэн. Пхэнав екхэсти: «Джя!» — и вов джял. Пхэнав аврэсти: «Ав!» — и вов авэл. Пхэнав мурэ бутярнэсти: «Тер!» — тай вов терэла. ");
INSERT INTO rmyservi_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Исусо шунда кадэла лава, прылиля пала дыво, обрисиля тай пхэнда манушэнди, савэ джянас пала Лэ: — Пхэнав тумэнди, со и дэ Израили на аракхлём Мэ кацаво патявимо. ");
INSERT INTO rmyservi_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Кала мануша, савэн бичалдэ Исусостэ, рисиле цэрэ, вонэ удыкхле, со насвало састярдапэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Тунчи Исусо джиля дэ форо, саво акхарэлпэ Наино. Джянас пала Лэ бут Лэхкэрэн сиклярнэн и фартэ бут манушэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Кала Вов поджиля форохкэрэ вударэндэ, котарь вылиджянас тэ гаравэ тэрнэ чявэ. Вов сля екх пэхкиря датэ, савятэ муля ром. Фартэ бут манушэн кодэлэ форостар джянас їтханэ лаґа. ");
INSERT INTO rmyservi_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Кала Рай удыкхля ла, Лэсти ачиля дор кадэла манушня. Тай пхэнда Вов лати: — На ров! ");
INSERT INTO rmyservi_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Тунчи Вов поджиля тай лиляпэ вастэґа гробостэ. Мануша, савэ лиджянас гробо, ачиле. Вов пхэнда мулэсти: — Чяво! Тути пхэнав, вщи! ");
INSERT INTO rmyservi_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Муло ваздэняпэ, бэшля тай ачиля тэ дэдумэ. Тунчи Исусо отдэня лэ дати. ");
INSERT INTO rmyservi_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Пэ всавэрэн дэня бари дар. Вонэ ачиле тэ ваздэ слава Дэвлэсти тай пхэнэнас: — Баро англунари ваздэняпэ машкар амэн, и Дэвэл авиля Пэхкэрэ манушэндэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Кади дэдумане пала Исусо пав всавири Иудея тай дэ пхуен, савэ сле пашэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Иоаннохкэрэ сиклярнэ розпхэндэ Иоанности пала кода, со стердапэ. Иоанно акхарда дон пэхкэрэн сиклярнэн ");
INSERT INTO rmyservi_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","тай бичалда Раестэ тэ пхучен Лэстар: — Ту исин Кодэва, Касти трэбуни тэ авэ, чи трэбуни амэнди тэ дожутярэ аврэ? ");
INSERT INTO rmyservi_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Мурша авиле Исусостэ тай пхэндэ: — Иоанно Болдэмари бичалда амэн тэ пхуче Тут: «Ту исин Кодэва, Касти трэбуни тэ авэ, чи трэбуни амэнди тэ дожутярэ аврэ?» ");
INSERT INTO rmyservi_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Дэ кодыя вряма Исусо бутэн манушэн састярэлас насвалимэндар и дукхэндар, вытрадэлас налачен тай бутэ корэнди оттерэлас якха. ");
INSERT INTO rmyservi_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Тунчи Вов пхэнда Иоаннохкэрэ сиклярнэнди: — Джян, пхэнэн Иоанности, со тумэ дыкхле тай шундэ: корэ дыкхэн, лангэ пхирэн, мануша дэ проказа жужарэнпэ латар, кашукэ шунэн, мулэ отджювдён, и чёрэнди пхэнэлпэ Бахтало Лав. ");
INSERT INTO rmyservi_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Бахтало кодэва, ко пала Ман на змарэлапэ дромэстар. ");
INSERT INTO rmyservi_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Кала бичалдэ Иоанностар джиле, Исусо ачиля тэ пхэнэ манушэнди пала лэ: — Со тумэ пхирдэ тэ дыкхэ дэ шуки пхув? Чяр, сави тинисявэл барвалятар? ");
INSERT INTO rmyservi_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","А сар на кади, ка тумэ пхирдэ тэ дыкхэ: манушэ дэ ковля їда? Нэ кодэла, савэ урявэнпэ дэ райкани їда тай джювэн дэ барвалима, бэшэн дэ тхагарнэн цэрэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ка тумэ пхирдэ тэ дыкхэ: англунаре? Кади, пхэнав тумэнди, вов барэдэр, сар англунаря. ");
INSERT INTO rmyservi_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Вов кодэва, пала кастэ чиндо: «Акэ, Мэ бичалав Мурэ манушэ англа Тиро муй. Вов лачярэла дром Тиро англа Тут». ");
INSERT INTO rmyservi_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Пхэнав тумэнди: машкар кодэлэн, савэ джювлендар бэнепэ, нэнай ни екхэ англунаре барэдэр Иоанностар. Нэ цыкнэдэр дэ Дэвлэхкэрэ Тхагарима исин барэдэр лэстар. ");
INSERT INTO rmyservi_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Всавэрэ мануша, савэ шундэ Исусо, тай стидэмаря прыджянгле, со Дэвлэхкоро дром исин чячюно. Тунчи болдэнепэ Иоаннохкэрэ болдимаґа. ");
INSERT INTO rmyservi_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","А фарисея тай сиклимаря пав Упхэнима на прылиле Дэвлэхкири воля и на болдэнепэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Тунчи Рай пхэнда: — Пэ кастэ счувэлпэ кадэва родо? Пэ кастэ счувэнпэ кадэла мануша? ");
INSERT INTO rmyservi_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Вонэ счувэнпэ пэ чяворэн, савэ бэшэн пэ форо, акхарэн екх екхэ тай пхэнэн: «Амэ цэлдэ тумэнди пэ дудка, нэ тумэ на цэлэнас пэ пурэн. Амэ дилябане тумэнди диля ровимахкэрэ, нэ тумэ на ровэнас». ");
INSERT INTO rmyservi_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Акэ, авиля Иоанно Болдэмари, на хал мандро и на пэл мол, а тумэ пхэнэн: «Дэ лэстэ бэшэл бэнг». ");
INSERT INTO rmyservi_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Авиля Чяво Манушыкано, хал и пэл, а тумэ пхэнэн: «Акэ исин Мануш, Касти чялёл тэ ха и тэ пэ. Вов амал стидэмаренди тай бэзимахкэрэ манушэнди!» ");
INSERT INTO rmyservi_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Нэ кодэла, ко прылэн бари Дэвлэхкири годи, кадэлэґа сикавэн, со када чячимо. ");
INSERT INTO rmyservi_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Екх фарисеи акхарда Исусо скаминдэстэ, тай Вов заджиля лэстэ дэ цэр и залиля тхан пала скаминдэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Тай акэ, екх джювли дэ бэзима кодэлэ форостар уджянгля, со Исусо дэ цэр фарисеестэ пала скаминдэ, анда алабастрово вакхор кучутнэ мироґа. ");
INSERT INTO rmyservi_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Вой вщиля павпалэ, паша Исусохкэрэн пурэн, заровиня, тай лакэрэ ясва ачиле тэ чюлё. А вой выкхосэлас Исусохкэрэ пурэ пэхкэрэ балэнца, чюминдэлас лэн и макхэлас мироґа. ");
INSERT INTO rmyservi_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Фарисеи, саво акхарда Исусо, удыкхля када тай пхэнда пэсти дэ гындо: «Тэ авэл Кадэва Мануш чячимаґа англунари, Вов бы джянэлас, сави манушни Лэстэ лэлпэ тай дэ савэ бэзима вой джювэл». ");
INSERT INTO rmyservi_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Исусо пхэнда лэсти: — Симоно! Камав тэ пхэнэ тути екх лав. Кодэва дэдуманя: — Пхэн, Сиклимари! ");
INSERT INTO rmyservi_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Исусо пхэнда: — Екхэ хулаестэ дуй мануша залиле ловэ. Екх сля вуджило лэсти панчшэл динарии, ай авэр — пандэша. ");
INSERT INTO rmyservi_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Нэ сар лэндэ на сля ловэ, хулай эртисарда лэдуенди вуджилимо. Ко дуендар авэла будэр тэ камэ кадэлэ манушэ? ");
INSERT INTO rmyservi_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Симоно пхэнда: — Гинисарав, со кадэва, касти вов будэр эртисарда. Исусо пхэнда: — Тиро чячимо. ");
INSERT INTO rmyservi_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Тунчи обрисиля манушнятэ и пхэнда Симоности: — Ту дыкхэх кадэла манушня? Мэ авилём дэ тиро цэр, и ту на дэнян Манди пани, соб Мэ пурэ тэ халавав. А вой ясвэнца обхалавда Манди пурэ и выкхосля лэн пэхкэрэ балэнца. ");
INSERT INTO rmyservi_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ту на чюминдан Ман, а вой всавири вряма, сар Мэ заджилём дэ цэр, на пэрэачел тэ чюминдэ Мурэ пурэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ту на помакхлян Муро шэро зэтоґа оливкэндар, а вой пурэ Манди помакхля кучутнэ мироґа. ");
INSERT INTO rmyservi_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Пхэнав тути: эртисардэ бут бэзима лакэрэ, кодэлэсти вой и покамля бут. Касти набут эртисарэлапэ, кодэва набут и камэла. ");
INSERT INTO rmyservi_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Тунчи Исусо пхэнда джювляти: — Эртисарэнпэ тути тирэ бэзима. ");
INSERT INTO rmyservi_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Авэр мануша, савэ сле пала скаминдэ, ачиле тэ гинисарэ: — Ко Вов Кацаво, соб бэзима тэ эртисарэ? ");
INSERT INTO rmyservi_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Вов жэ пхэнда манушняти: — Тиро патявимо тут фирисарда. Джя, и тэ авэл туґа пачя! ");
INSERT INTO rmyservi_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Тунчи Исусо пхирэлас пав гавэн тай форонэн, сиклярэлас и розпхэнэлас Бахтало Лав пала Дэвлэхкэрэ Тхагарима. Паша Лэ сле дэшудуй апостолуря. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Сле паша Лэстэ кади ж и джювля, савэндар Вов вытрадэня налачен тай састярда насвалимастар: Мария, савя акхарэнас Магдалина и савятар выджиле эфта бэнгэн, ");
INSERT INTO rmyservi_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Иоанна, ромни Хузохкири, саво Иродостэ дыкхэлас пала цэр, Сусанна и бут аврэн джювлен, савэ подрицарэнас Исусо и сиклярнэн пэхкэрэ барвалимаґа. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Екхвар, кала паша Исусо стидэняпэ бут манушэн, савэ авэнас Лэстэ бутэ форонэндар, Вов пхэнда кацави дума: ");
INSERT INTO rmyservi_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","— Выджиля мануш тэ чувэ ворзо дэ пхув. Кала чувэлас, екх ворзо пэля паша дром. И койсаво ворзо чирикля упралимахкэрэ похале, а койсаво мануша тасавдэ пурэнца. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Авэр ворзо пэля пэ барэн тай сиго бариля, нэ зашутиля, колэсти со котэ на сля пани. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Трито ворзо пэля машкар пусани чяр. Кодыя чяр бариля тай затасавда ворзо. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Штарто ворзо пэля дэ лачи пхув, ваздэняпэ тай анда барило дэ шэл молы будэр. Тунчи Исусо пхэнда зоралэ ґласоґа: — Кастэ исин кана тэ шунэ, мэк шунэл! ");
INSERT INTO rmyservi_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Лэхкэрэ сиклярнэ пхучле Лэстар: — Сар тэ полэ кадэла лава? ");
INSERT INTO rmyservi_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Вов пхэнда: — Тумэнди дэно тэ джянэ чёраханэ лава пала Дэвлэхкэрэ Тхагарима. Ай аврэнди пхэнэлпэ дума, соб вонэ тэ дыкхэн и тэ на удыкхэн, тэ шунэн и тэ на полэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Акэ сар трэбуни тэ полэ кадыя дума. Ворзо — када исин Дэвлэхкоро Лав. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ворзо, саво пэля паша дром, када исин мануша, савэ шунэн Лав. Нэ лэндэ авэл баро бэнг тай чёрэл Лав лэнгэрэ їлэндар, соб вонэ тэ на патян и тэ на фирисарэнпэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ворзо, саво пэля пэ барэн, када мануша, савэ шунэн Лав тай прылэн лошаґа, нэ лэндэ нэнай корни. И набут вряма вонэ патян. Нэ кала авэл пхари вряма и вонэ зумавэнпэ, тунчи вонэ отджян Дэвлэстар. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ворзо, саво пэля дэ пусани чяр, када мануша, савэ ашунэн Лав. Нэ пэ годя лэндэ кици, сар тэ джювэ пэ кадыя люмля и сар тэ затерэ барвалимо, и соб тэ авэл драго важ лэнгоро трупо. Вса када полокхэ авэл и затасавэл Лав, и мануша на анэн барило. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ворзо, саво пэля дэ лачи пхув, када мануша, савэ шунэн Лав, рицарэн лэ дэ лачё и пативало їло, вса пэрэлиджян и кодэлэсти анэн барило. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Кала пхабарэн лампа, тунчи на тховэн ла тала вакхор чи тала пато. Нэ тховэн упрэ, соб мануша, савэ заджян, тэ дыкхэн одуд. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Нэнай нисо гаравдо, со на авэла аракхло, нэнай нисо чёрахано, со на авэла уджянгло и на выджяла аври. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Дыкхэн, сар тумэ шунэн! Кодэлэсти, кастэ исин, инте дэлапэ. А кастэ нэнай, лэстар залэлапэ и кода, со вов думисарэл, со лэстэ исин. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Тунчи авиле Исусостэ Лэхкири дэй тай Лэхкэрэ пхрала и на поджиле Лэстэ, важ кода со паша Лэ стидэняпэ фартэ бут манушэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Тай пхэндэ Лэсти: — Дэй Тири тай пхрала Тирэ ачен аври и камэн тэ дыкхэ Тут. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Исусо пхэнда лэнди: — Мури дэй тай Мурэ пхрала исин кодэла, савэ шунэн Дэвлэхкоро Лав и терэн кади, сар вов пхэнэл. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Екхвар Исусо заджиля дэ лодка Пэхкэрэ сиклярнэнца тай пхэнда лэнди: — Авэн пэ авэр риг. Тай лагле. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Кала вонэ джянас пав пане пэ лодка, Исусо засута. Ваздэняпэ бари барвал пэ пане, лодка пхэрдэня панеґа, и вонэ ачиле тэ тасё. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Поджиле Исусостэ, джюнгавдэ Лэ и пхэндэ: — Сиклимари! Сиклимари! Амэ хасявах! Исусо вщиля, запхэнда барваляти и барэ панести, саво ваздэласпэ. Тунчи барвал и пани улилепэ, и вса заачиля мулком. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Тунчи Исусо пхэнда сиклярнэнди: — Тев тумаро патявимо? Вонэ фартэ дарэне, и лэнди на заджялас дэ шэрэ, со када терэлпэ. И вонэ кици пхэнэнас екх екхэсти: — Ко исин Кадэва, со и барваляти запхэнэл, и панести, и вонэ кандэн Лэ? ");
INSERT INTO rmyservi_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Тай авиле дэ пхув Гераса, сави исин пэ авэр риг Галилеятар. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Кала Исусо выджиля лодкатар, авиля Лэстэ форостар екх мануш, дэ савэ бэшэнас бэнга. Вов бут вряма пхирэлас нанго и джювэлас на дэ цэр, нэ дэ склепо, тев мулэн гаравэнас. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Кала вов удыкхля Исусо, чутапэ Лэхкэрэ пурэндэ тай затиписиля зоралэ ґласоґа: — Со Тути трэбуни мандар, Исусо, Чяво Дэвлэ Барэдэрэхкэрэ? Мангав Тут, на тер манди бида! ");
INSERT INTO rmyservi_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Вов типисиля, колэсти со Исусо прыпхэнда нажужэсти тэ выджял манушэстар. Ай нажужо бут вряма марэлас кадэлэ манушэ, кади, со пхандэнас лэхкэрэ васта и пурэ ланцоґа и дыкхэнас пала лэ. Нэ вов розчинэлас ланцуря, и бэнг традэлас лэ дэ мален. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Исусо пхучля лэстар: — Сар тиро лав? Вов пхэнда: — Легионо, — колэсти со бут бэнгэн заджиле дэ лэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Тай мангле Исусо, соб Вов тэ на бичалэл лэн дэ хасютно тхан. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Котэ пэ плай чяравэнаспэ фартэ бут балэн, тай бэнга мангле Исусостар, соб лэнди тэ заджя дэ балэн. Исусо домукля лэнди. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Бэнга выджиле манушэстар тай заджиле дэ балэн. Тунчи всавэрэ балэ чутэпэ плаестар дэ пане тай потасиле. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Чукняря, савэ чяравэнас балэн, удыкхле, со тердапэ, и тунчи прастэне и розпхэндэ пала кода дэ форо и пав гавэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Кала стидэнепэ мануша, соб тэ дыкхэ, со тердапэ, воне авиле Исусостэ тай дыкхле, со мануш, дэ кастэ сле бэнга, бэшэл дэ пурэн Исусостэ, урявдо и дэ пэхкиря годя, тай фартэ дарэне. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ай кодэла, савэ еджинэ дыкхле, сар вса от када тердапэ, розпхэндэ лэнди, сар састярдапэ мануш, дэ савэ сле бэнга. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Всавэрэ мануша кадэла пхуятар, сави акхарэлпэ Гераса, мангле Исусо, соб Вов тэ джял лэндар, колэсти со фартэ дарэне. Вов заджиля дэ лодка тай рисиля павпалэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Мануш, дэ савэ сле бэнга, мангля тэ джял лэсти Исусоґа. Нэ Исусо отмукля лэ тай пхэнда: ");
INSERT INTO rmyservi_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","— Рисяв пэстэ цэрэ и розпхэн, со терда туґа Дэвэл. Мануш джиля и всавэрэнди дэ форо розпхэнэлас, со терда лэсти Исусо. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Кала Исусо рисиля павпалэ, мануша прылиле Лэ, колэсти со вонэ дожутярэнас Исусо. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Тай акэ, авиля екх мануш, савэ акхарэнас Иаиро и саво сля пхурэдэр дэ синагога. Вов тэлэдэня Исусости дэ пурэн тай мангля, соб Исусо тэ авэл лэстэ цэрэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Кадэлэ манушэстэ сля кици екх чей, савяти сля пашэ дэшудуй бэрш, и вой мэрэлас насвалимастар. Исусо джиля лэстэ, и мануша всавэрэ ригэндар стасавэнас Лэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Машкар кадэлэн манушэн сля екх джювли, савятар дэшудуй бэрш джиля рат. Вой отдэня састимаренди вса, со латэ сля, нэ нико ла на састярда. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Тунчи вой поджиля павпалэ, лиляпэ подятэ Исусохкиря їдатар, и екхатар рат пэрэачиля тэ джя. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Исусо пхучля: — Ко лиляпэ Мандэ? Нэ нико на прыджянгляпэ. Тунчи Пётро пхэнда: — Сиклимари! Бут манушэн пашэ Тут и всавэрэ ригэндар Тут стасавэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Нэ Исусо пхэнда: — Койсаво мануш лиляпэ Мандэ, и Мэ шундом, со Мандар выджиля зор. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Кодыя джювли удыкхля, со лати на выджиля тэ гаравэпэ, затинисиля, поджиля Исусостэ, тэлэдэня Лэсти дэ пурэн тай розпхэнда англа всавэрэн манушэн, сости вой лиляпэ Исусостэ и сар екхатар састярдапэ насвалимастар. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Исусо пхэнда лати: — Чей! Тиро патявимо тут састярда. Джя, и мэк авэл туґа пачя! ");
INSERT INTO rmyservi_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Кала Вов инте пхэнэлас кадэла лава, авиля екх мануш цэрэстар, тев джювда пхурэдэр дэ синагога, тай пхэнда лэсти: — Тири чей муля. Будэр на замисар Сиклимаре! ");
INSERT INTO rmyservi_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Нэ Исусо шунда када тай пхэнда лэсти: — На дар, кици патя, и тири чей састярэлапэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Кала авиле дэ цэр, Исусо запхэнда тэ заджя пордэ манушэнди, а лиля Пэґа кици Петро, Иаково тай Иоанно и чиёракэрэн дадэ и да. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Всавэрэ ровэнас тай марэнас пэ дэ колинэн дэ баря грыжа. Нэ Исусо пхэнда лэнди: — На ровэн! Вой на муля, вой совэл. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","И асанас Лэстар. Вонэ ж джянгле, со чиёры сля мули. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Нэ Исусо лиля чиёра пала вастэ тай пхэнда: — Вщи, чиёры! ");
INSERT INTO rmyservi_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Тай рисиля лакоро фано, и чиёры екхатар вщиля. Тунчи Исусо пхэнда, соб тэ дэн лати тэ ха. ");
INSERT INTO rmyservi_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Лакэрэ дад и дэй прылиле када пала дыво, нэ Исусо запхэнда лэнди тэ розпхэнэ пала кода, со стердапэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Тунчи Исусо акхарда Пэхкэрэн дэшудуен апостолонэн и дэня лэнди бари зор тэ вытрадэ бэнгэн и тэ састярэ насвалимэндар. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Тунчи бичалда лэн тэ розпхэнэ пала Дэвлэхкэрэ Тхагарима и тэ састярэ насвалэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Вов пхэнда лэнди: — Нисо на лэнтэ дэ дром: ни дэсто, ни траста, ни мандро, ни рупь, ни инте екх гад. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Дэ саво цэр тумэ заджяна, котэ аченпэ и котарь джян дэ дром. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","А кала тумэн на прылэна, тунчи джян кодэлэ форостар тай обмарэн прахо тумарэ пурэндар. И мэк кода авэла шпэра важ лэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Вонэ джиле пав гавэн, пхэнэнас Бахтало Лав и пав всавэрэ тхана састярэнас насвалэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Дума пала кода вса доджиля Иродостэ, саво сля тетрархо. Вов на джянгля, сар када тэ полэ. Койсавэ мануша пхэнэнас, со када Иоанно Болдэмари отджювдиня мулэндар. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Авэр пхэнэнас, со када Илья авиля, а тритэ — со отджювдиня екх думутнэ англунарендар. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Тай пхэнда Иродо: — Мэ отчиндом шэро Иоанности, а ко исин Кадэва, пала Ка мэ шунав? И родэлас тэ дыкхэ Исусо. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Апостолуря рисиле Исусостэ и розпхэндэ Лэсти, со вонэ тердэ. Вов стидэня лэн, и вонэ джиле форостэ, саво акхарэлпэ Вифсаида, еджинэ, би манушэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Нэ мануша уджянгле пала кода тай джиле пала Исусо. Вов прылиля лэн тай дэдуманя лэнца пала Дэвлэхкэрэ Тхагарима. И касти сля трэбуни тэ састярэпэ, Вов састярэлас. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Кала диво сля пашэ рятятэ, дэшудуй апостолуря поджиле Исусостэ тай пхэндэ Лэсти: — Отмук манушэн, мэк джян вонэ дэ пашунэн гаворэн и гавэн, тэ аракхэн, тев лэнди тэ ратярэ и со лэнди тэ ха. Кодэлэсти со амэ катэ дэ шуки пхув. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Исусо пхэнда лэнди: — Тумэ дэн лэнди тэ ха. Вонэ пхэндэ: — Амэндэ исин кици панч мандрэ и дуй маче. Чи амэнди тэ джя тай тэ тинэ всавэрэнди хамо? ");
INSERT INTO rmyservi_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","А котэ стидэнепэ кици екхэн муршэн пашэ панч пхангля. Исусо пхэнда Пэхкэрэ сиклярнэнди: — Пхэнэн манушэнди, мэк розмарэнпэ пав пандэша манушэн и бэшэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Вонэ тердэ кади, и всавэрэ бэшле. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Исусо лиля панч мандрэ и дуй маче, подыкхля дэ упралима, наисарда Дэвлэ пала хама, розпхагля мандро и мачё пэ которэн тай дэня сиклярнэнди, соб вонэ тэ роздэн манушэнди. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Всавэрэ хале и чялиле, и стидэне дэшудуй трасты которэнца, савэ ачилепэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Екхвар, кала Исусо ачиляпэ Еджино и мангляпэ, сиклярнэ поджиле Лэстэ. Тунчи Исусо пхучля лэндар: — Пала кастэ динэн Ман мануша? ");
INSERT INTO rmyservi_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Вонэ пхэндэ: — Пала Иоанно Болдэмаре, ай авэр — пала Илья. А тритэ пхэнэн, со када отджювдиня екх думутнэ англунарендар. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Вов пхучля лэндар: — А тумэ пала ка Ман прылэн? Пётро пхэнда: — Пала Христо Дэвлэхкэрэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Нэ Исусо запхэнда лэнди тэ дэдумэ пала кода. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Тунчи Вов дэдуманя лэнди, со Манушыканэ Чявэсти трэбуни авэла тэ ха бари грыжа, со Лэстар отпхэнэнапэ пхурэдэра, англунэ рашая тай сиклимаря пав Упхэнима, со Лэ умарэна, нэ пэ трито диво Вов отджювдёла мулэндар. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","А всавэрэнди пхэнда: — Кала ко камэл тэ джя пала Ман, тунчи отпхэнпэ еджино пэстар, лэ пэхкоро трушул кожно диво и джя пала Ман. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ко камэл тэ фирисарэ пэхкоро води, кодэва хацарэла лэ. А ко хацарэла пэхкоро води важ Ман, кодэва сфирисарэла лэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Сави бахт кодэлэстар, со мануш затерэла всавиря люмля, а еджино хасявэла чи терэла пэсти бида? ");
INSERT INTO rmyservi_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ко ладжяла Мандар чи Мурэ лавэндар, кодэлэстар ладжяла и Чяво Манушыкано, кала авэла дэ Пэхкири слава, дэ слава Дадэхкири и свэнтононэ ангелонэнгири слава. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Чячимаґа пхэнав тумэнди: ачен катэ мануша, савэ инте ды мэрима дыкхэна Дэвлэхкоро Тхагаримо. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Кала проджиля пашэ охто дивэ, Исусо лиля Пэґа Пётро, Иаково тай Иоанно и джиля пэ плай тэ мангэпэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","И кала мангляпэ, парувдапэ англа лэн муй Лэхкоро, тай їда Лэхкири кади парниля, со дукхано сля тэ дыкхэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Тай акэ, авиле дуй мурша, савэ дэдумане Лэґа. Када сле Моисеи тай Илья. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Вонэ авиле дэ бари слава и пхэнэнас, со Исусости трэбуни авэла тэ джя дэ Ерусалимо и тэ ачявэ кадыя люмля. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Пётро и кодэла, савэ сле лэґа їтханэ, совэнас, а кала джюнгавдэпэ, удыкхле слава Исусохкири и дон муршэн, савэ аченас Лэґа. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Кала мурша ачиле тэ уджя, Пётро пхэнда Исусости: — Сиклимари! Сар мишто амэнди катэ! Тховаґа трин катуны, екх Тути, екх Моисеести и екх Ильясти. Ай еджино на полэлас, со пхэнэл. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","И кала вов инте дэдуманя, авиля хмара и ушарда лэн упрал. Кала ж вонэ ачиле дэ хмара, лэн облиля бари дар. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Тай сля шундо ґласо хмаратар: — Када Чяво Муро вытидэно. Шунэн Лэ! ");
INSERT INTO rmyservi_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Кала ґласо пэрэачиля тэ дэдумэ, Исусо ачиляпэ Еджино. И сиклярнэ аченас мулком и никасти на розпхэнэнас, со дыкхле дэ кодыя вряма. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Пэ авэр диво, кала вонэ сджянас плаестар, авиля Исусостэ гроза манушэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Екх мануш типисиля: — Сиклимари! Мангав Тут, подыкх пэ мурэ чяворэ! Мандэ вов екхоро исин. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Дэ лэстэ заджял бэнгано фано и чяворо ачел тэ типисявэ. Нажужо марэл чяворэ кади, со лэхкэрэ мостар чюлён саля. И вов дэл тэ ха чяворэсти бари грыжа, и пхаро отмукэл лэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Мэ манглём Тирэ сиклярнен, соб вонэ тэ вытрадэн нажужэ, нэ лэндэ нэнай зора. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Исусо пхэнда: — Мануша бипатявнэ и родо мусардэ їлэнца! Скици инте тэ авэ тумэнца? Скици инте тэ вырицарав тумэн? Ан кордэ пэхкэрэ чявэ! ");
INSERT INTO rmyservi_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Кала чяворо джялас Исусостэ, бэнг аравда лэ пэ пхув тай ачиля тэ марэ. Тунчи Исусо запхэнда нажужэсти, састярда чяворэ и отдэня лэ дадэсти. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Всавэрэ дэнас дыво кодэлэсти, саво баро Дэвэл. И кала вонэ дэнас дыво кодэлэсти, со терда Исусо, Вов пхэнда Пэхкэрэ сиклярнэнди: ");
INSERT INTO rmyservi_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","— Тховэн дэ тумарэ канэн кадэла лава: Чявэ Манушыканэ сиго здэна манушэнди дэ вастэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Нэ вонэ инте на полиле, пала со Исусо дэдуманя. Лэнгири годи инте сля затерди, а тэ пхуче Исусостар, сар тэ полэ Лэхкоро лав, вонэ даранас. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Екхвар Лэхкэрэ сиклярнэ ачиле тэ хапэ екх екхэґа пала кода, ко лэндар исин барэдэр. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Исусо джянгля, со лэндэ пэ годен, тунчи Вов лиля цыкнэ чяворэ тай тховда паша Пэстэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Тай пхэнда сиклярнэнди: — Ко прылэла кадэлэ чяворэ важ Мурэ Лавэ, кодэва Ман прылэла. Ай ко прылэла Ман, прылэла Кодэлэ, Ко Ман бичалда. Ко тумэндар исин цыкнэдэр всавэрэндар, кодэва авэла всавэрэндар барэдэр. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Тунчи Иоанно пхэнда Лэсти: — Сиклимари! Амэ дыкхле манушэ, саво вытрадэл бэнгэн Тирэ Лавэґа, и запхэндэ лэсти кади тэ терэ. Кодэлэсти со вов на пхирэл амэнца їтханэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Исусо дэдуманя: — На запхэнэн лэсти. Кодэла, савэ на ваздэнпэ пэ тумэн, кодэла пала тумэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Кала поджялас вряма тэ ваздэпэ Исусости пэ упралима, Вов лиля Пэсти дэ гындо тэ джя дэ Ерусалимо. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Тунчи Исусо бичалда англал Пэстэ манушэн, и вонэ авиле дэ гав Самариякоро, соб вса важ Лэ тэ лачярэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Нэ самарянуря на прылиле Исусо, колэсти со Вов джялас дэ Ерусалимо. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Кала Исусохкэрэ сиклярнэ Иаково тай Иоанно дыкхле кода, вонэ пхэндэ: — Рае! Камэх, амэ пхэнаґа, соб тэ сджял яг упралимастар и тэ спхабарэл лэн? ");
INSERT INTO rmyservi_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","56","Нэ Исусо обрисиля лэндэ тай запхэнда када тэ терэ. И джиле дэ авэр гав. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Кала вонэ джянас пав дром, екх мануш пхэнда Исусости: — Мэ джява пала Тут, курик Ту тэ на джях. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Исусо пхэнда лэсти: — Рувэндэ исин тхан, тев вонэ отцинён, и чириклендэ кади ж. Ай Манушыканэ Чявэстэ нэнай тхан, тев шэро тэ притховэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Аврэ манушэсти Исусо пхэнда: — Джя пала Ман! Кодэва пхэнда: — Рае! Мук ман майанглал тэ гаравав мурэ дадэ! ");
INSERT INTO rmyservi_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Исусо пхэнда лэсти: — Мэк мулэ гаравэн пэхкэрэн мулэн, а ту джя тай розпхэн пала Дэвлэхкэрэ Тхагарима! ");
INSERT INTO rmyservi_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Трито мануш пхэнда Исусости: — Рае! Мэ джява пала Тут, нэ дэ манди майанглал тэ джяв и тэ дыкхав муро їри. ");
INSERT INTO rmyservi_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Исусо пхэнда лэсти: — Мануш, саво лэлпэ пала плуго, нэ обрисявэлпэ павпалэ, на поджял важ Дэвлэхкэрэ Тхагарима. ");
INSERT INTO rmyservi_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Тунчи Рай Исусо вытидэня эфтадэша аврэн сиклярнэн тай бичалда лэн пав дуй англал Пэстар дэ всавэрэн форонэн и тханэн, тев Еджино камля тэ авэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","И пхэнда лэнди: — Ваздэняпэ бут мандро пэ мален, а бутярнэн набут. Важ кода мангэн Хулае малякэрэ, соб Вов тэ бичалэл бутярнэн, тэ злэн див малендар. ");
INSERT INTO rmyservi_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Джянтэ! Мэ бичалав тумэн, сар бакрэн машкар рувэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","На лэн пэґа ни тышыла, ни траста, ни пундрангэ. И пав дромэ на наисарэнпэ манушэнца. ");
INSERT INTO rmyservi_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Дэ саво цэр заджяна, майанглал пхэнэн: «Пачя кадэлэ цэрэсти!» ");
INSERT INTO rmyservi_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Кала котэ джювэл мануш, саво камэл пачя, кадыя пачя ачела пэ лэстэ. А кала нат, тумари пачя рисявэла тумэндэ павпалэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Аченпэ дэ кодэлэ цэрэ, хантэ тай пэнтэ кода, со тумэнди дэна. Бутярно мануш ачел кода, соб лэсти тэ потинэн важ лэхкири бути. На пэрэджян цэрэстар дэ цэр. ");
INSERT INTO rmyservi_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Кала авэна дэ форо и прылэна тумэн котэ, хантэ вса, со тумэнди дэна. ");
INSERT INTO rmyservi_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Састярэн лэнгэрэн насвалэн и пхэнэн лэнди: «Надур тумэндар Дэвлэхкоро Тхагаримо». ");
INSERT INTO rmyservi_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Кала авэна дэ форо тай на прылэна тумэн котэ, тунчи джян пэ гаса и пхэнэн: ");
INSERT INTO rmyservi_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","«И прахо, саво прыачиля амарэ пурэндэ дэ тумаро форо, амэ обмарах. Нэ джянэн, со надур тумэндар Дэвлэхкоро Тхагаримо». ");
INSERT INTO rmyservi_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Пхэнав тумэнди, дэ кодэва диво форости Содомо авэла локхэдэр, сар кадэлэ форости. ");
INSERT INTO rmyservi_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Бида тути, форо Хоразино! Бида тути, форо Вифсаида! Тэ дыкхэн форуря Тиро тай Сидоно дывуря, савэ сле тумэндэ, вонэ б думут обрисявэнаспэ пэхкэрэ бэзимастар, урявэнаспэ дэ їда гонэндар и бэшэнас дэ прахо. ");
INSERT INTO rmyservi_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Нэ Тирости и Сидоности пэ сындо авэла локхэдэр, сар тумэнди. ");
INSERT INTO rmyservi_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","И ту, форо Капернаумо, гинисарэх тэ ваздэпэ упрэ? Ту дэ адо тэлэдэґа. ");
INSERT INTO rmyservi_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Кодэва, ко шунэла тумэн, кодэва Ман шунэла, и ко отпхэнэлпэ тумэндар, отпхэнэлапэ Мандар. А ко отпхэнэлапэ Мандар, отпхэнэлапэ и Кодэлэстар, Ко Ман бичалда. ");
INSERT INTO rmyservi_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Эфтадэша сиклярнэн рисиле баря лошаґа тай пхэндэ: — Рае! И бэнга кандэн амэн важ Тиро Лав! ");
INSERT INTO rmyservi_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Исусо пхэнда лэнди: — Мэ дыкхлём, сар сатана тэлэдэня упралимастар кади, сар тэлэдэл молния. ");
INSERT INTO rmyservi_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Акэ, дав тумэнди зор тэ тасавэ пурэнца сапэн и скорпионэн, и тэ чувэ пэ пхув врыжымашэн, и нисави бибахт вонэ тумэнди на терэна. ");
INSERT INTO rmyservi_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Кици лошавэн на колэсти, со фануря кандэн тумэн, а колэсти, со тумарэ лава зачиндэ пэ упралима. ");
INSERT INTO rmyservi_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Тунчи Исусо лошыля дэ Свэнто Фано тай пхэнда: — Наисарав Тут, Дадэ, Тхагари пэ пхуя и пэ упралима, со Ту оттердан цыкнэнди гаравдо їрвалэндар и годявэрэндар. Кади, Дадэ! Кацави сля Тири лачи воля! ");
INSERT INTO rmyservi_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Вса дэно Манди Мурэ Дадэстар. Нико на джянэл Чявэ, кици Дад, и нико на джянэл Дадэ, кици Чяво и кодэла, касти Чяво камэл тэ сикавэ Дадэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Тунчи обрисиля сиклярнэндэ тай пхэнда лэнди: — Бахталэ якха, савэ дыкхэна кода, со тумэ дыкхэн екхатар! ");
INSERT INTO rmyservi_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Пхэнав тумэнди, со бут ко англунарендар тай тхагарендар камле тэ дыкхэ кода, со тумэ акана дыкхэн, нэ на дыкхле. Камле тэ шунэ кода, со тумэ акана шунэн, нэ на шундэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Тунчи екх сиклимарендар пав Упхэнима вщиля, соб тэ зумавэ Исусо, тай пхучля: — Сиклимари! Со манди тэ терэ, соб тэ авэл мандэ вечно джювимо? ");
INSERT INTO rmyservi_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Исусо пхэнда лэсти: — Сар чиндо дэ Упхэнима? Сар ту полэх? ");
INSERT INTO rmyservi_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Кодэва пхэнда: — Кам тирэ Рае Дэвлэ всавэрэ тирэ їлэґа и всавэрэ тирэ водеґа, всавиря тиря зораґа и всавиря годяґа. И кам тирэ пашунэ, сар еджино пэ камэх. ");
INSERT INTO rmyservi_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Исусо дэдуманя: — Чячимо ту пхэндан. Тер кади и авэґа тэ джювэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Нэ кодэва камля тэ допхэнэ пэхкоро и пхучля Исусостар: — А ко исин муро пашуно? ");
INSERT INTO rmyservi_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Исусо пхэнда: — Екх мануш джиля Ерусалимостар дэ Ерихоно. Тай хутилдэ лэ прахаря, злиле лэстар їда, домардэ лэ и джиле, а вов ачиляпэ тэ пашлё епашмуло. ");
INSERT INTO rmyservi_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Выджиля кади, со трэбуни сля тэ джя кодэлэ дромэґа рашаести. Вов удыкхля кадэлэ манушэ, пэрэджиля пэ авэр риг и проджиля мамуй. ");
INSERT INTO rmyservi_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Джялас котэ и левито, удыкхля манушэ, пэрэджиля пэ авэр риг и проджиля мамуй. ");
INSERT INTO rmyservi_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Екх самарянино ладэлас кодэлэ дромэґа, удыкхля манушэ, и ачиля лэсти дор лэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Вов поджиля манушэстэ, упрал чута мол, помакхля дукхавдэ тхана зэтоґа тай пэрэпхангля лэн. Тунчи тховда лэ пэ пэхкэрэ мугаре, анда дэ гостиница тай прыдыкхэлас пала лэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Пэ авэр диво, кала трэбуни лэсти сля тэ уладэ, вов дэня хулаести дуй динарии тай пхэнда: «Прыдыкх пала кадэлэ манушэ, а кала джяна будэр ловэ, мэ дава тути инте, кала рисявава павпалэ». ");
INSERT INTO rmyservi_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ко тринэндар сля пашуно манушэсти, савэ домардэ прахаря, сар ту гинисарэх? ");
INSERT INTO rmyservi_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Сиклимари пав Упхэнима пхэнда: — Кодэва, ко терда манушэсти лачимо. Тунчи Исусо пхэнда лэсти: — Джя и ту тер кади! ");
INSERT INTO rmyservi_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Кала вонэ джянас дурэдэр, Исусо заджиля дэ екх гав. Котэ манушни, савя акхарэнас Марфа, прылиля Лэ дэ пэхкоро цэр. ");
INSERT INTO rmyservi_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Латэ сля пхэнь Мария. Вой бэшля паша пурэн Раестэ тай шунда Лэхкэрэ лава. ");
INSERT INTO rmyservi_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Марфа ж змардапэ пурэндар, соб тэ тховэ баро скаминд. Тунчи поджиля Исусостэ и пхэнда: — Рае! Чи ту на дыкхэх, со мури пхэнь всавири бути ачявда пэ ман? Пхэн лати, мэк терэл манца. ");
INSERT INTO rmyservi_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Рай Исусо пхэнда: — Марфа! Марфа! Бут пала со ту думисарэх, и бут пала со тутэ дукхал шэро. ");
INSERT INTO rmyservi_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Нэ кици екх трэбуни. Мария ж вытидэня кода, со фэдэр, и када латар на залэлапэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Екхвар Исусо мангляпэ, ай кала пэрэачиля, екх Лэхкэрэ сиклярнэндар пхэнда Лэсти: — Рае! Сикляр амэн тэ мангэпэ, сар Иоанно сиклярда пэхкэрэн сиклярнэн! ");
INSERT INTO rmyservi_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Исусо пхэнда лэнди: — Кала мангэнпэ, пхэнэн: Дадэ! Мэк тэ свэнцолпэ Лав Тиро! Мэк авэл Тхагаримо Тиро! ");
INSERT INTO rmyservi_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Пэ кожно диво мандро амэнди дэ авдивутно. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","И бэзимо амаро эртисар амэнди, сар и амэ дош эртисарах кодэлэнди, ко исин амэнди вуджилэ. И на домук, соб тэ змарахпэ дромэстар. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Тунчи Исусо пхэнда лэнди: — Кала варико тумэндар авэла рятяґа амалэстэ тай пхэнэла лэсти: «Морэ! Залэ манди трин питы мандро. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Амал дромэстар заджиля мандэ, и нэнай мандэ, со тэ дав лэсти тэ ха». ");
INSERT INTO rmyservi_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Чи пхэнэла амал тиро тути андрал: «На замисар ман! Мэ вудара затердом, и мурэ чяворэ совэн манца. Нисар манди тэ вще и тэ дэ тути мандро»? ");
INSERT INTO rmyservi_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Пхэнав тумэнди: кала на вщела и на дэла тути мандро, сар амал тиро, тунчи вщела и дэла тути кодэлэсти, со ту на пэрэачех тэ мангэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","И Мэ пхэнав тумэнди: мангэн — и Дэвэл дэла тумэнди, родэн — и тумэ аракхэна, марэн дэ вудара — и Дэвэл оттерэла тумэнди. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Акэ, кожно, ко мангэл — лэл, кодэва, ко родэл — аракхэл. И кодэлэсти, ко марэла дэ вударэн, — Дэвэл оттерэла. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Чи исин машкар тумэн кацаво дад, саво подэла пэхкэрэ чяворэсти сапэ, кала вов мангэл лэстар мачё? ");
INSERT INTO rmyservi_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","И саво дад подэла чяворэсти скорпионо, кала вов мангэл дадэстар парноро? ");
INSERT INTO rmyservi_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Кала тумэ, мижэ мануша, джянэн, сар тэ терэ лачимо тумарэ чяворэнди, тунчи пэ скици будэр Дад Упралимастар дэла Свэнто Фано кодэлэнди, савэ мангэн Лэстар? ");
INSERT INTO rmyservi_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Екхвар Исусо вытрадэня бэнгэ, саво терэлас манушэ лалэґа. Кала бэнг выджиля, лало мануш ачиля тэ дэдумэ, а всавэрэ мануша прылиле када пала баро дыво. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","А койсавэ лэндар дэдумане: — Вов вытрадэл бэнгэн зораґа, сави дэл Лэсти Веельзевуло, барэдэр бэнгэнгоро. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Авэр мануша зумавэнас Лэ и мангле Лэстар шпэра упралимастар. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Нэ Исусо джянгля лэнгоро гындо тай пхэнда лэнди: — Тхагаримо, дэ савэ ханпэ екх екхэґа, авэла шушо. Тай цэр, дэ савэ ханпэ екх екхэґа, розпхагэлапэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","И кала сатана халпэ еджино пэґа, тунчи сар выачела лэхкоро тхагаримо? Тумэ пхэнэн, со Мэ вытрадав бэнгэн зораґа, сави дэл Манди Веельзевуло. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","А кала Мэ вытрадав бэнгэн зораґа, сави дэл Манди Веельзевуло, тунчи савя зораґа вытрадэн бэнгэн тумарэ сиклярнэ? Кодэлэсти вонэ сундисарэна тумэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","А кала Мэ вытрадав бэнгэн Дэвлэхкиря зораґа, тунчи тумэндэ авиля Дэвлэхкоро Тхагаримо. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Кала зорало мануш дэстэнца и чюренца дыкхэл пала пэхкэрэ цэрэ, лэхкоро хулаимо нико залэла. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Нэ кала авэла зорэдэр лэстар, тунчи марэла лэ, залэла лэстар дэста и чюря, пэ савэн лэстэ сля надия, и всаворо лэхкоро барвалимо роздэла. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ко на їтханэ Манца, кодэва ваздэлпэ пэ Ман. Ко на стидэл Манца, кодэва розчувэл. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Кала нажужо выджяла манушэстар, тунчи пхирэл пав бипаненгирэн тханэн, родэл тхан, тев лэсти тэ отцинё, нэ нисар на аракхэл. Тунчи пхэнэл: «Рисявава павпалэ дэ муро цэр, катарь мэ выджилём». ");
INSERT INTO rmyservi_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","А кала авэл павпалэ, дыкхэл, со цэр шулавдо и прытидо. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Тунчи джял, акхарэл пэстэ эфта аврэн нажужэн, мижэдэр пэстар, и вонэ заджян тай джювэн котэ. И кода авэла важ манушэ инте шымай, сар сля. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Кала Исусо дэдуманя кадэва лав, екх манушни лэнгэрэ стидэмастар затиписиля зоралэ ґласоґа: — Бахтали джювли, сави бэня Тут и парварда! ");
INSERT INTO rmyservi_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Исусо пхэнда: — Нат, на кади! Бахталэ кодэла, савэ шунэн Дэвлэхкоро Лав и джювэн кади, сар вов пхэнэл! ");
INSERT INTO rmyservi_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Кала инте будэр манушэн стидэняпэ паша Исусостэ, Вов ачиля тэ дэдумэ: — Кадэва родо — хохавно. Вов родэл пэсти шпэра, нэ лэсти авэла кици шпэра Ионахкири. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Сар Иона ачиля шпэра важ манушэн Ниневиятар, кади Чяво Манушыкано авэла шпэра важ кадэва родо. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Тхагарни югостар ваздэлапэ пэ сындо їтханэ кадэлэ родоґа и дошарэла лэ, колэсти со вой авиля авря ригакиря пхуятар тэ пошунэ годявэр лава Соломонохкэрэ. Нэ акэ, катэ Кодэва, Саво исин барэдэр Соломоностар. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Мануша Ниневиятар ваздэнапэ пэ сындо їтханэ кадэлэ родоґа и дошарэна лэ. Колэсти со вонэ ачявдэ пэхкэрэ бэзима, кала Иона пхэнэлас лэнди лав Дэвлэстар. Нэ акэ, катэ Кодэва, Саво барэдэр Ионастар. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Кала мануш запхабарэл лампа, вов на тховэл ла ни дэ граждо, ни тала вакхор, нэ тховэл ла упрэ, соб лакири яг тэ дэл душлимо манушэнди, савэ заджян. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Якха — када лампа важ тиро трупо. Кала якха тутэ жужэ, тунчи дэ трупо тиро пхэрдо одуд. А кала якха тутэ налаче, тунчи и дэ трупо тиро авэла пхэрдо калимо. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Кади дыкх: одуд, саво дэ тут исин, соб тэ на авэл вов калимаґа. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Кала дэ тиро трупо исин одуд и нэнай калимо, тунчи ту всаворо жужо, пхэнэґа, сар душлимо лампатар марэл пэ тут. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Кала Исусо пхэнда кадэла лава, екх фарисеендар акхарда Лэ пэстэ тэ ха. Исусо авиля лэстэ и залиля тхан пала скаминдэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Фарисеи удыкхля, со Вов на халавда васта англа колэ, сар тэ ха, и дэняпэ дыво. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Нэ Рай пхэнда лэсти: — Акэ тумэ, фарисея, жужарэн аврял тахтая тай чярэ, нэ андрал тумэндэ пхэрдо ханджьвалимо тай вурытимо. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Бигодякэрэ! Кодэва, Саво стерда кода, со аврял, чи на стерда кади ж и кода, со андрал? ");
INSERT INTO rmyservi_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Кала тэ пхэнэ пала кода, со андрал, тунчи подэн боґудэенди їлэстар, и вса тумэндэ авэла жужо. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Нэ бида тумэнди, фарисея! Тумэ дэн Дэвлэсти дэшто котор чярендар мята и рута и всавэрэстар, со барёл тумэндэ пэ баря, нэ бистарэн чячюно сындо и Дэвлэхкоро камавимо. Трэбуни и када тэ терэ, и пала кода тэ на бистарэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Бида тумэнди, фарисея! Тумэ камэн тэ бэшэ пэ англунэн тханэн дэ синагоги, и чялёл тумэнди, кала пэ форо мануша наисарэнпэ тумэнца. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Бида тумэнди! Тумэ сар могилы, савэ на душон, пав савэн пхирэн мануша и на джянэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Екх сиклимари пав Упхэнима шунда кадэла лава и пхэнда Лэсти: — Сиклимари! Кадэлэ лавэнца Ту и амэн кошэх. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Нэ Исусо пхэнда: — Бида и тумэнди, сиклимаря пав Упхэнима! Тумэ чувэн пэ манушэн баро пхаримо, саво нащи тэ подваздэ, а еджинэ и ангуштэґа лэстэ на лэнпэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Бида тумэнди! Тумэ ваздэн пэ кладбищен памятникуря англунаренди, савэн мулярдэ тумарэ дада! ");
INSERT INTO rmyservi_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Тумарэ дада мулярэнас англунарен, а тумэ ваздэн лэнди памятникуря. Кадэлэґа тумэ сикавэн, со тумэ цырдэн васта пала тумарэн дадэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Колэсти пхэнэл Дэвлэхкири годи: «Бичалава лэндэ англунарен и апостолонэн. Екхэн вонэ мулярэна, а аврэн авэна тэ вытрадэ». ");
INSERT INTO rmyservi_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Колэсти пхучелапэ кадэлэ родостар пала англунаренгоро рат, саво сля прочуто кодэла вряматар, сар Дэвэл терда люмля. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ратэстар, саво прочута Авели, ды Захарияхкэрэ ратэ, кала лэ умардэ машкар храмо и жэртвеннико. Чячимаґа пхэнав тумэнди, пхучелапэ кадэлэ родостар. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Бида тумэнди, сиклимаря пав Упхэнима! Тумэ залиле тии вударэндар, савэ лиджян джянимастэ. Нэ и еджинэ на заджиле, и аврэн, савэ камле тэ заджя, на мукле. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Кала Исусо джиля котарь, сиклимаря пав Упхэнима и фарисея фартэ мижыле пэ Лэстэ тай ачиле тэ долэ Исусо и тэ пхуче Лэстар бут пала со. ");
INSERT INTO rmyservi_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Вонэ родэнас, сар тэ астарэ Исусо пэ лавэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Екхвар стидэняпэ бут пхангля манушэн, кади бут, со ачиле тэ тасавэ екх екхэ. Исусо ачиля тэ дэдумэ англэдэр Пэхкэрэ сиклярнэнди: — Рицарэнпэ дурэдэр фарисеенгэрэ закваскатар, соб тэ на авэн тумэ домуенгэрэ мануша, сар вонэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Нэнай нисо гаравдо, со б тэ на оттерэлпэ, и нэнай чёрахано, со б тэ на авэл уджянгло. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Кода, со тумэ пхэндэ рятяґа, шунэна дивэсэ, и со тумэ чёраханэ пхэндэ дэ цэр, пхэнэна зоралэ ґласоґа пэ ушарди. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Пхэнав жэ тумэнди, Мурэ амалэнди: на даран кодэлэндар, савэ умарэн трупо, а будэр нисо на терэна. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Нэ сикавава тумэнди, кастар трэбуни тэ дара: даран Кодэлэстар, Кастэ исин зор на кици тэ мулярэ, нэ тэ чувэ дэ геенна. Кади, пхэнав тумэнди, Кодэлэстар даран. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Пала дуй харумэ мардэ тинэн панч чириклен. Нэ ника лэндар Дэвэл на бистарда. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","А тумэндэ Вов джянэл, и скици бала исин пэ тумаро шэро. На даран! Тумэ пэ бутэ кучэдэр цыкнэн чириклен! ");
INSERT INTO rmyservi_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Пхэнав жэ тумэнди: кодэлэ, ко прыджянэла Ман англа манушэн, прыджянэла и Чяво Манушыкано англа Дэвлэхкэрэн ангелонэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","А ко отпхэнэлапэ Мандар англа манушэн, кодэлэстар и Чяво Манушыкано отпхэнэлапэ англа Дэвлэхкэрэн ангелонэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Манушэсти, саво пхэнэла налачё лав пэ Чявэ Манушыканэ, эртисарэлапэ бэзимо, а кодэлэсти, ко кошэла Свэнто Фано, бэзимо на эртисарэлапэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Кала ж лиджяна тумэн дэ синагоги, пхурэдэрэндэ и раендэ, на пэрэджювэн пала кода, сар и со тэ пхэнэ лэнди дэ отпхэнима. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Дэ кодыя вряма Свэнто Фано сиклярэла тумэн, со трэбуни тэ пхэнэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Екх мануш, саво ачиля машкар лэн, пхэнда Исусости: — Сиклимари! Пхэн мурэ пхралэсти, соб тэ дэл манди кодэлэ хулаимастар, саво ачиляпэ амарэ дадэстар! ");
INSERT INTO rmyservi_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Нэ Исусо пхэнда лэсти: — Ко тховда Ман тэ сундисарэ тумэн и тэ розлэ тумаро рындо? ");
INSERT INTO rmyservi_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Тунчи пхэнда лэнди: — Дыкхэн, соб тэ на авэн тумэ ханджьвалэ. Саво б тэ на авэл мануш барвало, лэхкэрэ джювимастэ када бэрша на додэла. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Тунчи Вов розпхэнда лэнди кацави дума: — Екхэ барвалэ манушэстэ выбариля бут ворзо пэ маля. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Тай дэдумэлас еджино пэсти: «Со манди тэ терэ? Нэнай мандэ, тев тэ стидэ див». ");
INSERT INTO rmyservi_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Тай пхэнда: «Пхагава мурэ граждуря и терава инте барэдэр. Стидава дэ лэн див и всаворо муро барвалимо. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Тай пхэнава пэхкэрэ водести: \"Води муро! Бут исин тутэ барвалимо, саво ту стидэнян, хутилэла тути пэ бут бэрша. Отцинюв, ха, пи и ав лошало!\"» ");
INSERT INTO rmyservi_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Нэ Дэвэл пхэнда кадэлэ манушэсти: «Бигодякоро! Кадэла рятяґа тиро води залэна тутар. Тунчи касти доросэлапэ кода, со ту стидэнян?» ");
INSERT INTO rmyservi_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Кади авэла кодэлэґа, ко стидэл барвалимо важ пэ, а англа Дэвлэ ачелпэ чёро. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","И пхэнда Пэхкэрэ сиклярнэнди: — Пхэнав тумэнди, на пэрэджювэн пала джювима, ни пала кода, со тумэнди тэ ха, ни пала трупо, дэ со тумэнди тэ урявэпэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Джювимо будэр хамастар, и трупо будэр їдатар. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Подыкхэнтэ пэ воронэн: вонэ на чувэн ворзо дэ пхув, на стидэн мандро малендар. Лэндэ нэнай ни цэра, ни граждо, нэ Дэвэл парварэл лэн. Тумэ ж пэ бутэ кучэдэр чириклендар! ");
INSERT INTO rmyservi_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ко тумэндар, кала пэрэджювэл, додэла джювимастэ пэ екх чясо вряма? ");
INSERT INTO rmyservi_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","И кала тумэ кадэва цыкно рындо на стерэна, сости пала аврэ пэрэджювэн? ");
INSERT INTO rmyservi_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Подыкхэн пэ маленгэрэн лулуден, сар вонэ барён. Вонэ на терэн бути и на сювэн пэсти їда. Нэ пхэнав тумэнди, со и тхагари Соломоно дэ пэхкири слава на урявэласпэ кади, сар кадэла лулудя. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Кала чяр малякири, сави авдивэ барёл, а атася чувэна ла дэ бов, Дэвэл кади урявэл, пэ скици будэр Вов тумэн урявэла, мануша набарэ патявимаґа? ");
INSERT INTO rmyservi_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","И тумэ на родэн, со тэ ха чи со тэ пэ, и на пэрэджювэн пала кода. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Вса откада родэн народуря кадэла люмлякэрэ, нэ тумаро Дад джянэл, со тумэнди када трэбуни. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Нэ родэн Лэхкоро Тхагаримо, и вса откада тумэнди дэлапэ прэдэбэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","На даран, цыкнэ бакрора! Тумаро Дад закамля тэ дэ тумэнди Тхагаримо. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Битинэн тумаро хулаимо и дэн чёрорэнди! Лачярэн тышыла, савэ никала на чинэнапэ! Стидэн барвалимо, саво никала на хасявэла, пэ упралима, курик чёр на пашола и тев цэрмо на схала. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Тев тумаро барвалимо, котэ и тумаро їло авэла. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Мэк всавири вряма тумарэ кущика тэ авэн зацырдэнэ, и мэк всавири вряма пхабон тумарэ лампы. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Авэн, сар бутярнэ, савэ дожутярэн пэхкэрэ хулае бьявэстар. Вонэ екхатар лэсти оттерэна вудара, кала шунэна, со вов марэл дэ лэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Бахталэ кодэла бутярнэ, савэ на совэна, кала авэла лэнгоро хулай. Чячимаґа пхэнав тумэнди: вов еджино зацырдэла кущик, акхарэла лэн пала скаминд и терэла важ лэн бути. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Бахталэ кодэла, савэ дожутярэн хулае и дэ епашрят, и дэнзор. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Полэн, тэ джянэл хулай, кала авэла чёр, вов бы на домукэлас лэсти тэ заґуле дэ цэр. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","А тумэ дожутярэн и авэн гата, колэсти со Чяво Манушыкано авэла тунчи, кала тумэ на думисарэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Тунчи Пётро пхэнда Лэсти: — Рае! Ту кици амэнди пхэнэх кадэла лава чи важ всавэрэн? ");
INSERT INTO rmyservi_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Рай пхэнда: — Со терэла пативало и годявэр бутярно, савэ хулай ачявда тэ дыкхэ пала цэрэ и аврэн бутярнэн, соб тэ роздэл лэнди хамо дэ пэхкири вряма? ");
INSERT INTO rmyservi_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Кала рисявэла хулай и дыкхэла, со бутярно терэл пэхкири бути, тунчи кадэва бутярно авэла бахтало. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Чячимаґа пхэнав тумэнди, со хулай терэла кадэлэ бутярнэ пхурэдэрэґа пав всавэрэ пэхкэрэ хулаима. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Нэ кала кодэва бутярно пхэнэла еджино пэсти: «Муро хулай на сиго авэла», — и ачела тэ марэ аврэн бутярнэн и бутярнен, обхалапэ тай матёла, ");
INSERT INTO rmyservi_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","тунчи авэла хулай дэ дивэ, кала бутярно лэ на дожутярэл, и дэ вряма, пала савя бутярно на джянэл. И мулярэла лэ, и авэла лэсти бида їтханэ бидэвлэхкэрэ манушэнца. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Бутярно, саво джянгля, со камэл лэстар хулай, нэ на сля гата, и на стерда кади, авэла фартэ мардо. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","А бутярно, саво на джянгля и стерда кода, пала со марэна, авэла мардо набут. Касти Дэвэл дэня бут, кодэлэстар бут и лэлапэ. И касти бут допатиня, кодэлэстар будэр пхучелапэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Мэ авилём, соб тэ запхабарэ яг пэ пхуя, и сар Мэ камав, соб вой сигэдэр тэ розпхаболпэ! ");
INSERT INTO rmyservi_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Манди трэбуни тэ болдэпэ, и стасавэл грыжа Муро їло, кала кода вса дожутярав! ");
INSERT INTO rmyservi_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Тумэ гинисарэн, Мэ авилём, соб тэ анэ пэ пхув пачя? Нат, пхэнав тумэнди: Мэ авилём тэ анэ врыжымо. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Акана їри панче манушэндар розджялапэ машкар пэстэ, трин ваздэнапэ пэ дон и дуй ваздэнапэ пэ тринэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Дад ваздэлапэ пэ чявэ, и чяво ваздэлапэ пэ дадэ. Дэй ваздэлапэ пэ чя, и чей ваздэлапэ пэ да. Сасуни ваздэлапэ пэ боря, а бори ваздэлапэ пэ сасуня. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Тунчи Исусо пхэнда манушэнди: — Кала тумэ дыкхэн, сар пэ западо ваздэлпэ хмара, тумэ пхэнэн: «Дэла брышынд». И кади исин, брышынд дэл. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","И кала пхурдэл барвал южнона ригатар, тумэ пхэнэн: «Кхам пэкэла», — и кади выджял. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Домуенгэрэ! Тумэ дыкхэн пэ упралима и пэ пхуя и джянэн, со авэла аври, ай сави вряма авиля акана, тумэ на полэн? ");
INSERT INTO rmyservi_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","И сости тумэ еджинэ на розлэнпэ, со исин чячимо? ");
INSERT INTO rmyservi_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Кала ту джях пэхкэрэ врыжымашэґа дэ сындо, стер вса, соб тэ допхэнэпэ лэґа инте пав дром. А кала на допхэнэґапэ, вов цырдэла тут сындимарестэ, а сындимари отдэла тут халавдэсти, и халавдо чувэла тут дэ барунэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Пхэнав тути: на выджяґа котарь ды колэ, сар на отдэґа ды екхэ мардэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Дэ кодыя вряма авиле Исусостэ койсавэ мануша и розпхэндэ пала манушэн Галилеятар, савэн Пилато прыпхэнда тэ мулярэ и мукля лэнди рат, кала вонэ анэнас жэртвы. ");
INSERT INTO rmyservi_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Исусо пхэнда лэнди: — Тумэ гинисарэн, со кадэла галилеянуря тердэ бэзимо будэр аврэ манушэндар дэ Галилея и кодэлэсти хале грыжа? ");
INSERT INTO rmyservi_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Нат, пхэнав тумэнди. Нэ кала тумэ на ачявэна бэзимо, хасявэна, сар и вонэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","А кодэла дэшуохто манушэн, савэ помуле, кала тэлэдэня пэ лэн упрал башня дэ Силоамо? Тумэ гинисарэн, со вонэ сле дошадэр всавэрэндар, савэ джювэнас дэ Ерусалимо? ");
INSERT INTO rmyservi_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Нат, пхэнав тумэнди. Нэ кала тумэ на ачявэна бэзимо, тунчи всавэрэ хасявэна, сар и вонэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Тунчи пхэнда лэнди кацави дума: — Екхэ манушэстэ сля инжырно кашт дэ лэхкоро винограднико. Вов авиля тэ родэ пэ кадэва кашт барило, нэ нисо на аракхля. ");
INSERT INTO rmyservi_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","И пхэнда виноградарести: «Акэ, дыкх, мэ трито бэрш авав, соб тэ аракхэ барило пэ кадэва инжырно кашт, нэ нисо на аракхав. Сщин лэ! Пэ со вов ивья залэл пхув дэ садо?» ");
INSERT INTO rmyservi_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Нэ виноградари пхэнда лэсти: «Хулае! Мэк кадэва кашт инте екх бэрш барёла. А мэ пхув ковлярава и гуниво чувава. ");
INSERT INTO rmyservi_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","И кала пэ авэр бэрш анэла барило — мишто. А кала на анэла, сщинэґа лэ». ");
INSERT INTO rmyservi_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Екхвар дэ суббота Исусо сиклярда дэ синагога. ");
INSERT INTO rmyservi_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Котэ сля екх джювли, дэ кастэ дэшуохто бэрш сля налачё фано, саво дэлас лати дукх. Вой сля банги, кади со нащи лати сля тэ ваздэ шэро. ");
INSERT INTO rmyservi_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Исусо удыкхля ла, акхарда тай пхэнда: — Джювлие! Ту састярэхпэ тирэ насвалимастар! ");
INSERT INTO rmyservi_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","И тховда пэ латэ васта. Вой екхатар пэрэачиля тэ авэ банги и ачиля тэ ваздэ слава Дэвлэсти. ");
INSERT INTO rmyservi_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Тунчи пхурэдэр дэ синагога мижыля, со Исусо састярда дэ суббота, и пхэнда манушэнди: — Исин шов дивэ, кала трэбуни тэ терэ бути. Дэ кадэлэн дивэн авэнтэ тэ састярэпэ, а на дэ суббота. ");
INSERT INTO rmyservi_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Рай пхэнда лэсти дэ отпхэнима: — Домуенгэрэ! Чи на отпхандэн тумэ пэхкэрэ мугаре чи гурувэ, на вылиджян лэ граждостар и на лиджян панестэ дэ суббота? ");
INSERT INTO rmyservi_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","А вой исин чей Авраамохкири. Дэшуохто бэрш ла спхандэлас сатана! И со, на трэбуни сля тэ розпхандэ ла дэ суббота? ");
INSERT INTO rmyservi_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Кала Исусо пхэнда кадэла лава, всавэрэ Лэхкэрэ врыжымашуря сле ладжьвардэ, а всавэрэ мануша лошавэнас важ кода, со Вов терэлас барэ и лаче рындуря. ");
INSERT INTO rmyservi_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Исусо ж пхэнда: — Пэ со счувэлпэ Дэвлэхкоро Тхагаримо? Сар Манди када тэ сикавэ? ");
INSERT INTO rmyservi_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Вов счувэлпэ пэ цыкно горчично ворзо, саво мануш лиля и чута дэ пхув дэ пэхкоро садо. И кадэлэ ворзостар бариля вучё кашт, кади со упралимахкэрэ чирикля джювэнас пэ лэхкэрэн ранден. ");
INSERT INTO rmyservi_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Инте пхэнда Исусо: — Пэ со счувэлпэ Дэвлэхкоро Тхагаримо? ");
INSERT INTO rmyservi_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Вов счувэлпэ пэ закваска, савя лиля манушни тай чута дэ трин барэ чярэ варэґа, а тунчи кадыя закваска розджиляпэ пав всаворо хумэр. ");
INSERT INTO rmyservi_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Тунчи Исусо упалэ джиля дромэґа дэ Ерусалимо, проджялас пав гавэн и форонэн и котэ сиклярэлас. ");
INSERT INTO rmyservi_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Екх мануш пхучля Лэстар: — Рае! Када чячимо, со кици набут манушэн фирисарэнапэ? Исусо пхэнда: ");
INSERT INTO rmyservi_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","— Прытховэн зора кодэлэстэ, соб тэ заджя тумэнди набуґлэ вударэнца. Чячимаґа пхэнав тумэнди, со бут мануша закамэна тэ заджя, нэ нисо лэндэ на выджяла. ");
INSERT INTO rmyservi_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Кала цэрэхкоро хулай вщела и затерэла вудара, тунчи тумэ авэна тэ аче аври, тэ марэ дэ вударэн тай тэ мангэ: «Рае, оттер амэнди!» Нэ Вов пхэнэла тумэнди: «На джянав, катарь тумэ». ");
INSERT INTO rmyservi_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Тунчи тумэ пхэнэна: «Амэ хале и пиле англа Тут, и пэ амарэн гасэн Ту сиклярэґас». ");
INSERT INTO rmyservi_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Нэ Вов пхэнэла: «На джянав, катарь тумэ. Нашэн Мандар всавэрэ, ко вурытимо терэн!» ");
INSERT INTO rmyservi_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Котэ тумэ авэна тэ ровэ и тэ ха бари грыжа, кала дыкхэна, со Авраамо, Исаако тай Иаково и всавэрэ англунаря дэ Дэвлэхкэрэ Тхагарима, а тумэн котарь вытрадэна. ");
INSERT INTO rmyservi_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Авэна мануша штарэ пхуякэрэ ригэндар тай бэшэна пала скаминдэ дэ Дэвлэхкэрэ Тхагарима. ");
INSERT INTO rmyservi_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Тай акэ, мануша, савэ палунэ, авэна англэ. И кодэла, савэ англэ, авэна палунэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Дэ кодыя вряма авиле койсавэ фарисеендар и пхэндэ Лэсти: — Наш катарь, колэсти со Иродо камэл тэ мулярэ Тут. ");
INSERT INTO rmyservi_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Исусо пхэнда: — Джян и пхэнэн кадэлэ хрантимарести кацавэ лава: «Акэ, Мэ авдивэ и атася авава тэ традэ бэнгэн и тэ састярэ, а пэ трито диво дотерава пэхкоро рындо». ");
INSERT INTO rmyservi_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Нэ Манди трэбуни тэ джя Мурэ дромэґа авдивэ, атася и пэ авэр диво. Нэнай кади, соб англунаре тэ умарэн на дэ Ерусалимо. ");
INSERT INTO rmyservi_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ерусалимо, Ерусалимо! Ту мулярэх англунарен и барэнца помарэх кодэлэн, савэ сле бичалдэ тутэ! Скаци молы Мэ камлём тэ стидэ Тирэ чяворэн кади, сар каґни стидэл пуицен тала пэхкэрэ пхака! Нэ тумэ на закамле кади. ");
INSERT INTO rmyservi_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Тай акэ, ачявав тумэн еджинэн дэ тумарэ цэрэ. Пхэнав тумэнди, со на дыкхэна Ман ды кодыя вряма, сар пхэнэна: «Бахтало Кодэва, Саво джял важ Лав Раехкоро!» ");
INSERT INTO rmyservi_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Екхвар дэ суббота Исусо заджиля дэ цэр фарисеенгэрэ пхурэдэрэстэ, соб тэ ха мандро. И всавэрэ дыкхэнас пала Исусо. ");
INSERT INTO rmyservi_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Тай акэ, англа Исусо бэшля екх мануш, саво сля всаворо шуло панехкиря дукхатар. ");
INSERT INTO rmyservi_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Исусо пхучля сиклимарендар пав Упхэнима и фарисеендар: — Чи трэбуни пав Упхэнима тэ састярэ дэ суббота? ");
INSERT INTO rmyservi_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Вонэ ачиле мулком. Исусо лиляпэ насвалэстэ, састярда лэ и отмукля. ");
INSERT INTO rmyservi_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Тунчи пхэнда лэнди: — Кала тумаро чяворо чи гурув тэлэдэла дэ ханиґ, чи тумэ на выцырдэна лэн екхатар и дэ суббота? ");
INSERT INTO rmyservi_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Вонэ на джянгле, со тэ пхэнэ Исусости. ");
INSERT INTO rmyservi_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Кала Исусо дыкхля, сар мануша, савэн акхардэ, вытидэнас пэсти фэдэр тхана, Вов пхэнда кацави дума: ");
INSERT INTO rmyservi_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","— Кала тут акхарэна пэ бьяв, на бэш пэ фэдэр тхан. Кала машкар манушэн, савэн акхардэ пэ бьяв, авэла пативэдэр тутар, ");
INSERT INTO rmyservi_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","тунчи кодэва, ко акхарда и тут, и лэ, поджяла и пхэнэла тути: «Уштав тхан кадэлэ манушэсти». И авэла тути ладжяво, и прыджялапэ тути тэ залэ шымай тхан. ");
INSERT INTO rmyservi_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Нэ кала акхарэна тут, бэш пэ шымай тхан. Тунчи кодэва, ко акхарда тут, поджяла тутэ и пхэнэла: «Морэ, бэш англэ!» И кодэла, ко бэшэна пала скаминдэ паша тут, дыкхэна, со тути дэне патив. ");
INSERT INTO rmyservi_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Кодэва, ко ваздэлпэ упрэ, авэла тэлярдо. Нэ кодэва, ко тэлярэл еджино пэ, авэла ваздэно. ");
INSERT INTO rmyservi_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Пхэнда Исусо и манушэсти, саво акхарда Лэ: — Кала ту тховэх скаминд дивэсэ чи пашэ рятятэ, на акхар пала лэ ни тирэ амалэн, ни тирэ пхралэн, ни тиро родо, ни пашунэн, савэ исин барвалэ. Колэсти со и кадэла мануша акхарэна тут, кала терэна скаминд, и терэна тути кади, сар и ту лэнди тердан. ");
INSERT INTO rmyservi_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Нэ кала ту терэх скаминд, акхар пала лэ чёрорэн, помардэн, лангалэн и корэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Бахтало ту авэґа, кала кадэла мануша на дэна тути павпалэ кода, со ту важ лэн стердан. Нэ рисявэлапэ вса тути дэ кодэва диво, кала дэвликунэ мануша отджювдёна мулэндар. ");
INSERT INTO rmyservi_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Екх мануш, саво бэшэлас Исусоґа пала скаминдэ, пхэнда: — Бахтало мануш, саво хала мандро дэ Дэвлэхкэрэ Тхагарима! ");
INSERT INTO rmyservi_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Исусо пхэнда лэсти: — Екх мануш терда баро скаминд и акхарда бутэн манушэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","И кала авиля вряма, соб тэ бэшэн пала скаминдэ, бичалда бутярнэ, соб вов тэ пхэнэл акхардэ манушэнди: «Авэн, вса дожутярэл тумэн». ");
INSERT INTO rmyservi_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Нэ всавэрэ мануша сар допхэндэпэ и ачиле тэ мангэ патив. Екх мануш пхэнда: «Мэ тиндом пхув, и манди трэбуни тэ джя и тэ дыкхэ ла. Мангав патив тутар!» ");
INSERT INTO rmyservi_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Авэр мануш пхэнда: «Мэ тиндом дэшэн гурувэн, и манди трэбуни тэ дыкхэ, сар вонэ терэн бути. Мангав патив тутар!» ");
INSERT INTO rmyservi_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Трито мануш пхэнда: «Мэ лилём хуланя, на выджял мандэ тэ авэ тутэ». ");
INSERT INTO rmyservi_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Кала бутярно рисиля, вов вса розпхэнда хулаести. Тунчи хулай холиля и пхэнда пэхкэрэ бутярнэсти: «Джя сигэдэр пав барэн и цыкнэн гасэн дэ форо тай стидэ кордэ чёрорэн, помардэн, корэн и лангалэн!» ");
INSERT INTO rmyservi_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Бутярно пхэнда: «Хулае! Вса тердом, сар ту манди прыпхэндан, нэ инте исин тхана». ");
INSERT INTO rmyservi_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Хулай пхэнда бутярнэсти: «Джя пав дромэн и паша грэдэн, и манг манушэн, соб муро цэр тэ авэл пхэрдо. ");
INSERT INTO rmyservi_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Пхэнав тумэнди, со нико кодэлэндар, савэ сле акхардэ майанглал, на хана муро хамо пала мурэ скаминдэ». ");
INSERT INTO rmyservi_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Джянас їтханэ Исусоґа бут манушэн. Тунчи Исусо обрисиля лэндэ и пхэнда: ");
INSERT INTO rmyservi_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","— Кала мануш, саво авэл Мандэ, на покамэла Ман будэр пэхкэрэн дадэ и да, ромня, чяворэн, пхралэн, пхэнен и будэр пэхкэрэ джювимастар, тунчи вов нисар на авэла Мурэ сиклярнэґа. ");
INSERT INTO rmyservi_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Мануш, саво на лиджял пэхкоро трушул и на джял пала Ман, нисар на авэла Мурэ сиклярнэґа. ");
INSERT INTO rmyservi_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Кала ко тумэндар закамэла тэ ваздэ башня, чи на бэшэла вов англал и на бинэла, скици ловэ пэ када трэбуни, соб тэ дотерэ рындо? ");
INSERT INTO rmyservi_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Кала вов чувэла фундаменто тала башня, нэ на дотерэла кадэва рындо, мануша асанапэ лэстар. ");
INSERT INTO rmyservi_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","И пхэнэна: «Кадэва мануш ачиля тэ терэ бути, нэ на дотерда». ");
INSERT INTO rmyservi_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Кала тхагари стидэлпэ пэ марима аврэ тхагареґа, чи на бэшэла вов англал и на гинисарэла, исин ли лэстэ зор дэшэ пхангленца манушэн тэ выджя пэ марима тхагареґа, кастэ исин биш пхангля манушэн? ");
INSERT INTO rmyservi_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","А кала нат, тунчи бичалэла пативалэн манушэн тхагарестэ, кала вов инте дур и мангэла лэстар пачя. ");
INSERT INTO rmyservi_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Кади и тумэндар нико на авэла Мурэ сиклярнэґа, кала на ачявэла вса, со лэстэ исин. ");
INSERT INTO rmyservi_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Лон — када мишто. Нэ кала лон хацарэла пэхкири зор, сар тэ терэ, соб тэ авэл вов лондо? ");
INSERT INTO rmyservi_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ни дэ пхув, ни дэ гуниво лэ на чувэґа. Лэ кици вычувэн аври. Кастэ исин кана тэ шунэ, мэк шунэл! ");
INSERT INTO rmyservi_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Авэнас Исусостэ всавэрэ стидэмаря, савэ лэнас налогуря, и бэзимахкэрэ мануша, соб тэ шунэ Лэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Нэ фарисеенди и сиклимаренди пав Упхэнима на чялёлас, со терда Исусо, и вонэ пхэнэнас: — Вов прылэл бэзимахкэрэ манушэн и хал лэнца. ");
INSERT INTO rmyservi_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Нэ Исусо пхэнда лэнди кацави дума: ");
INSERT INTO rmyservi_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","— Пхэнаґа, екхэстэ тумэндар исин шэл бакря, и екх лэндар хасиля. Чи на ачявэла вов енядэша тай еня бакрен дэ маля и чи на джяла тэ родэ бакря, сави хасиля? ");
INSERT INTO rmyservi_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ай кала аракхэла бакря, баря лошаґа тховэла ла пэ пхикэ и лиджяла. ");
INSERT INTO rmyservi_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Кала авэла цэрэ, акхарэла пэхкэрэн амалэн и пашунэн и пхэнэла лэнди: «Лошавэн манца, мэ аракхлём бакря, сави хасиля». ");
INSERT INTO rmyservi_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Пхэнав тумэнди, со кади ж пэ упралима пала екхэ манушэ, саво ачявда бэзимо, будэр лошавэна, сар пала енядэша еня патявнэн манушэн, савэнди на трэбуни тэ ачявэ бэзимо. ");
INSERT INTO rmyservi_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Кала манушнятэ исин дэш драхмы и вой хацарэла екх лэндар, чи на пхабарэла вой лампа, на шулавэла всаворо пэкхкоро цэр и на авэла тэ родэ, соб тэ аракхэ кадыя драхма? ");
INSERT INTO rmyservi_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","А кала аракхэла ла, тунчи стидэла пэхкэрэн амалкэн и пашунэн джювлен тай пхэнэла: «Лошавэн манца, мэ аракхлём драхма, сави хацардом!» ");
INSERT INTO rmyservi_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Кади, пхэнав тумэнди, лошавэн ангелуря Дэвлэхкэрэ и пала екхэ манушэ, саво ачявда пэхкоро бэзимо. ");
INSERT INTO rmyservi_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Инте пхэнда Исусо: — Екхэ манушэстэ сле дуй чявэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","И тэрнэдэр лэндар пхэнда дадэсти: «Дадэ! Дэ манди тирэ барвалимастар котор, саво манди доросэлапэ». И дад розмарда вса, со лэстэ сля, пэ дон и дэня пэхкэрэ чявэнди. ");
INSERT INTO rmyservi_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Проджиля набут вряма, и цыкнэдэр чявэндар стидэня вса, со лэсти доросляпэ, и джиля дур, дэ авэр пхув. Котэ розтерда вса, со лэстэ сля, и пав диниманэ розчувэлас ловэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Кала вов розчута всавэрэ ловэ, дэ кодыя пхув авиля бари бокх, и чяво мэрэлас бокхатар. ");
INSERT INTO rmyservi_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Тунчи джиля и намисардапэ екхэ манушэстэ кодэла пхуятар, тэ чяравэ баличен пэ маля. ");
INSERT INTO rmyservi_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Вов мэрэлас бокхатар и сля лошало тэ ха їтханэ баличенца, нэ лэсти и кода на дэнас. ");
INSERT INTO rmyservi_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Кала чявэстэ рисиля годи, тунчи вов пхэнда: «Бут намисардэн бутярнэн мурэ дадэстэ, и вонэ хан, скици закамэна, а мэ бокхатар катэ мэрав! ");
INSERT INTO rmyservi_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Вщява, рисявава павпалэ мурэ дадэстэ и пхэнава лэсти: \"Дадэ! Мэ тердом бэзимо англа Дэвлэ пэ упралима и англа тут ");
INSERT INTO rmyservi_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","и на ачяв тэ акхарэпэ тирэ чявэґа. Нэ прылэ ман сар тирэ бутярнэ\"». ");
INSERT INTO rmyservi_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Тунчи вщиля и джиля пэхкэрэ дадэстэ. Кала чяво сля дур цэрэстар, дад удыкхля лэ. И ачиля лэсти дор пэхкэрэ чявэ. Тунчи вов прастэня лэстэ, облиля и чюминдэня лэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Чяво пхэнда дадэсти: «Дадэ! Мэ тердом бэзимо англа Дэвлэ пэ упралима и англа тут и на ачяв тэ акхарэпэ тирэ чявэґа». ");
INSERT INTO rmyservi_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Нэ дад пхэнда пэхкэрэ бутярнэнди: «Джян сигэдэр! Анэн фэдэр їда, сави исин, и урявэнтэ чявэ, дэнтэ лэсти ангрусни пэ ангушт и пундрангэ пэ лэхкэрэ пурэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Анэн парвардэ гурувэ и чинэн лэ пэ мас. Тховаґа баро скаминд и аваґа тэ лошавэ! ");
INSERT INTO rmyservi_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Кадэва муро чяво сля муло, нэ отджювдиня, сля хацардо, нэ кана аракхляпэ». Тай ачиле тэ лошавэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Пхурэдэр чяво сля пэ маля. Кала вов рисиля малятар и сля паша цэр, шунда, сар цэлэн и дилябэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Тунчи акхарда екхэ бутярнэ и пхучля: «Со када терэлпэ?» ");
INSERT INTO rmyservi_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Бутярно пхэнда лэсти: «Авиля тиро пхрал. И тиро дад прыпхэнда тэ чинэ парвардэ гурувэ, колэсти со лэхкоро чяво рисиля цэрэ джювдо». ");
INSERT INTO rmyservi_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Тунчи пхурэдэр чяво холиля и на камля тэ заджя дэ цэр. Нэ дад выджиля цэрэстар и ачиля тэ акхарэ лэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Нэ вов пхэнда дадэсти: «Акэ, мэ скици бэрш терав бути важ тут, со никала тэ ваздэ шэро, и дэ всавэрэ кандав тут. Нэ ту и цыкнорэ бузнорэ на дэнян манди, соб мэ тэ лошавав мурэ амалэнца. ");
INSERT INTO rmyservi_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","А кала кадэва тиро чяво, саво протерда пэхкэрэ ловэ налаче джювленца, авиля цэрэ, ту важ лэ чиндан парвардэ гурувэ». ");
INSERT INTO rmyservi_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Нэ дад пхэнда чявэсти: «Чяворо! Ту всавири вряма манца. И вса, со мандэ исин, када тиро. ");
INSERT INTO rmyservi_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Нэ важ кода трэбуни тэ лошавэ, со тиро пхрал сля муло, нэ отджювдиня, сля хацардо, нэ аракхляпэ». ");
INSERT INTO rmyservi_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Тунчи Исусо пхэнда Пэхкэрэ сиклярнэнди: — Екхэ барвалэстэ сля бутярно, саво дыкхэлас пала лэхкоро цэр. Екхвар хулаести пхэндэ пэ кан, со бутярно протерэл вса кода, со лэстэ исин. ");
INSERT INTO rmyservi_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Тунчи хулай акхарда бутярнэ и пхэнда: «Со када мэ пала тут шунав? Здэ манди тири бути. Колэсти со ту будэр на терэґа мандэ». ");
INSERT INTO rmyservi_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Тунчи бутярно пхэнда еджино пэсти: «Со манди тэ терэ? Муро хулай вытрадэл ман кадэла бутятар. Тэ ґанавэ пхув мандэ зора нэнай, а тэ мангэ ловэ манди ладжяво. ");
INSERT INTO rmyservi_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Джянав, со тэ терэ, соб тэ прылэн ман мануша дэ пэхкэрэн цэрэн, кала хацарава бути!» ");
INSERT INTO rmyservi_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Тунчи акхарда манушэн, савэ сле вуджилэ лэхкэрэ хулаести, тай пхэнда екхэсти: «Скици ту вуджило мурэ хулаести?» ");
INSERT INTO rmyservi_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Кодэва пхэнда: «Шэл барэ вакхор зэто». Бутярно пхэнда: «Залэ тиро лил, бэш и чин, со ту вуджило пандэша барэ вакхор». ");
INSERT INTO rmyservi_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Тунчи пхучля аврэстэ: «А ту скици вуджило?» Кодэва пхэнда: «Екх пхангли гонэ див». Бутярно пхэнда лэсти: «Залэ тиро лил, бэш и чин, со ту вуджило охтошэл гонэ див». ");
INSERT INTO rmyservi_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","И ашарда хулай бипативалэ бутярнэ пала кода, сар годяґа выджиля кадэлэ рындостар. Кадэла люмлякэрэ чявэ лиджян рындуря пэхкэрэ амалэнца годявэдэр, сар чявэ Дэвлэхкэрэ, Саво исин Одуд. ");
INSERT INTO rmyservi_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Мэ ж пхэнав тумэнди: азбан пэсти амалэн хасютнэ барвалимаґа. И кала тумаро барвалимо проджяла, тумэн прылэна дэ катунэн, савэ авэна тэ аче вечно. ");
INSERT INTO rmyservi_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ко дэ набарэ исин чячюно, кодэва и дэ барэ авэла чячюно. А ко начячюно дэ набарэ, кодэва и дэ барэ на авэла чячюно. ");
INSERT INTO rmyservi_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","И кала нащи тэ допатя тумэнди хасютно барвалимо, ко тумэнди дэла барвалимо чячюно? ");
INSERT INTO rmyservi_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","И кала тумэ на сле чячюнэ на дэ пэхкэрэ барвалима, ко тумэнди дэла тумаро? ");
INSERT INTO rmyservi_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Нисаво бутярно на авэла тэ терэ бути дуе хулаендэ. Важ кода со вов екхэ хулае на камэла, а аврэ камэла, екхэ хулаести авэла чячюно, ай пэ аврэ авэла тэ чюнгардэ. Нащи дэ екх вряма тэ тэрэ бути важ Дэвлэ и важ барвалима. ");
INSERT INTO rmyservi_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Шундэ вса откада фарисея, савэ камле ловэ, тай ваздэне Исусо пэ асама. ");
INSERT INTO rmyservi_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Исусо пхэнда лэнди: — Тумэ камэн тэ сикавэпэ пативалэ манушэнца, нэ Дэвэл джянэл тумарэ їлэ. И кода, со драго важ манушэн, исин гряцимо важ Дэвлэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Упхэнимо тай англунаря сле англа Иоанно, нэ кана пхэнэлпэ Бахтало Лав пала Дэвлэхкэрэ Тхагарима, и всавэрэ прытховэн зора, соб тэ заджя дэ лэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Нэ сигэр пхув и упралимо хасявэна, а Упхэнимастар на хасявэла ни екх цыкно лаворо. ");
INSERT INTO rmyservi_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Кожно мануш, саво чувэл пэхкиря ромня и уджял аврятэ, терэл бэзимо и прэдэл пэхкиря ромня. И кодэва, ко лэл джювля, сави розлиджялдапэ, терэл бэзимо. ");
INSERT INTO rmyservi_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Сля екх барвало мануш, саво урявэласпэ дэ фартэ кучутни їда санэ похтаностар тай кожно диво джювда шукар дэ пэхкэрэ барвалима. ");
INSERT INTO rmyservi_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","И паша вударэн лэстэ аври пашлёлас чёро мануш, савэ акхарэнас Лазари, и трупо лэхкоро сля помардо насвалимастар. ");
INSERT INTO rmyservi_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Вов фартэ камля тэ чялё хамаґа, саво тэлэдэлас скаминдэстар. Авэнас лэстэ риконэ и чибэнца тиндярэнас лэхкэрэ дукха. ");
INSERT INTO rmyservi_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Тай акэ, муля чёро, и ангелуря отлиджялдэ лэ Авраамостэ. Муля и барвало мануш, тай заґанавдэ лэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","И кала барвало халас грыжа дэ адо, вов подыкхля упрал и удыкхля дур пэстар Авраамо и Лазаре, саво сля паша лэстэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","А тунчи акхарда: «Дадэ Авраамо! Ковлисар тиро їло важ ман! Бичал Лазаре, соб вов тэ тиндярэл пэхкоро ангушт дэ пани и тэ подлиджял муря чибатэ, колэсти со мэ хав бари грыжа». ");
INSERT INTO rmyservi_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Нэ Авраамо пхэнда: «Чяво! Взгинисар, со дэ тирэ джювима ту лилян лачимо, а Лазарестэ сля екх бида. Кана Лазари катэ улэлпэ грыжатар и лошавэл, а ту прылэх бари грыжа. ");
INSERT INTO rmyservi_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Када инте на вса, нэ машкар тумэн и амэн стердэ бари выґанавди, соб тумэндар нащи сля тэ пэрэджя амэндэ и амэндар — тумэндэ». ");
INSERT INTO rmyservi_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Тунчи барвало пхэнда: «Мангав тут, дадэ, бичал Лазаре мурэ дадэстэ дэ цэр. ");
INSERT INTO rmyservi_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Мандэ исин панч пхрала. Мэк Лазари розпхэнэла лэнди, соб и вонэ тэ на попэрэн дэ кадэва тхан, тев хан грыжа». ");
INSERT INTO rmyservi_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Авраамо пхэнда: «Лэндэ исин Моисеи и англунаря, мэк шунэн лэн». ");
INSERT INTO rmyservi_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Нэ барвало пхэнда: «Нат, дадэ Авраамо! Нэ кала ко мулэндар вщела и авэла лэндэ, тунчи вонэ ачявэна бэзимо». ");
INSERT INTO rmyservi_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Авраамо пхэнда лэсти: «Кала вонэ на шунэн Моисее тай англунарен, тунчи вонэ на патяна, кала и муло отджювдёла». ");
INSERT INTO rmyservi_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Тунчи Исусо пхэнда Пэхкэрэ сиклярнэнди: — Бут исин, со цырдэл манушэ бэзимастэ. Нэ бида кодэлэсти, ко залиджял манушэн дэ бэзима. ");
INSERT INTO rmyservi_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Фэдэр важ лэ, соб тэ прыпхандэн лэсти баро и пхаро бар пэ кора и тэ чувэн лэ дэ море, сар тэ залиджял вов дэ бэзима екхэ кадэлэн цыкнэндар. ");
INSERT INTO rmyservi_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Дыкхэн пала пэстэ! Кала пхрал тиро терэла бэзимо, запхэн лэсти када тэ терэ! И кала вов ачявэла бэзимо, эртисар лэ! ");
INSERT INTO rmyservi_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","И кала пхрал тиро эфта молы дэ дивэ терэла бэзимо и эфта молы авэла тутэ и пхэнэла: «Дошало! Мангав патив!» — эртисар лэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Апостолуря екхвар пхэндэ Раести: — Баряр амаро патявимо! ");
INSERT INTO rmyservi_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Рай пхэнда: — Кала тумэндэ исин патявимо, сар цыкно горчично ворзо, и тумэ пхэнэна кадэлэ тутовонэ каштэсти: «Вычинпэ пхуятар, джя дэ море и барюв», — тунчи кашт кандэла тумэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ко тумэндар пхэнэла бутярнэсти, саво рисиля малятар, тев вов вушарэлас пхув чи чяравэлас бакрэн: «Джя сигэдэр, бэш пала скаминд»? ");
INSERT INTO rmyservi_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Нат, тумэ на кади дэдумэна, нэ пхэнэна лэсти: «Вщи, тав манди тэ ха! Обпхандэпэ кущикаґа, подэ и прылэ скаминдэстар, кала мэ авава тэ ха и тэ пэ! Тунчи еджино хаґа и пэґа!» ");
INSERT INTO rmyservi_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Чи наисарэна тумэ бутярнэ пала кода, со стерда бути, сави лэсти трэбуни сля тэ терэ? ");
INSERT INTO rmyservi_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Кади и тумэ, кала терэна вса, со тумэнди прыпхэндо, дэдумэн пала пэстэ: «Амэ бутярнэ, савэ нисо на ачен. И стердэ кода, со амэнди трэбуни сля тэ стерэ». ");
INSERT INTO rmyservi_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Пав дром дэ Ерусалимо Исусо проджялас машкар Самария тай Галилея. ");
INSERT INTO rmyservi_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Кала Вов заджиля дэ екх гав, авиле Лэстэ дэш мануша, савэндэ сля насвалимо проказа. Вонэ ачиле дэ рига ");
INSERT INTO rmyservi_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","тай типисиле зоралэ ґласоґа: — Исусо Сиклимари! Ковлисар їло Тиро важ амэн! ");
INSERT INTO rmyservi_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Кала Исусо удыкхля лэн, Вов пхэнда: — Джян и сикавэнпэ рашаенди! И кала мануша джиле, пав дромэ вонэ састярдэпэ насвалимастар. ");
INSERT INTO rmyservi_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Екх лэндар дыкхля, со састярдапэ, рисиля павпалэ и ашарда Дэвлэ зоралэ ґласоґа. ");
INSERT INTO rmyservi_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Вов тэлэдэня Исусостэ дэ пурэн и наисарда Лэ. А кодэва мануш сля самарянино. ");
INSERT INTO rmyservi_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Тунчи Исусо пхэнда: — Чи на дэш манушэн састярдэпэ? Тев жэ инте еня? ");
INSERT INTO rmyservi_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Сости вонэ на рисиле, соб тэ ваздэ слава Дэвлэсти? Ай рисиля кици кадэва самарянино? ");
INSERT INTO rmyservi_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","И пхэнда кадэлэ манушэсти: — Вщи, джя цэрэ! Тиро патявимо тут фирисарда. ");
INSERT INTO rmyservi_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Тунчи фарисея пхучле Исусостар, кала авэла Дэвлэхкоро Тхагаримо. Исусо пхэнда: — Дэвлэхкоро Тхагаримо на авэла кади, соб всавэрэ лэ тэ дыкхэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Нико на пхэнэла: «Акэ, вов катэ исин». Чи: «Акэ, вов котэ». Нэ Дэвлэхкоро Тхагаримо машкар тумэн исин. ");
INSERT INTO rmyservi_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Тунчи Исусо пхэнда Пэхкэрэ сиклярнэнди: — Авэла вряма, кала закамэна тэ дыкхэ екх дивэндар Манушыканэ Чявэхкэрэ, нэ на дыкхэна. ");
INSERT INTO rmyservi_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Кала пхэнэна тумэнди: «Акэ, Вов катэ!» Чи: «Акэ, Вов котэ исин!» — на джян пордэ и на прастан пала лэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Сар молния марэл упралимастар и дэл яг и душлимо пав всавири пхув, кади ж и Чяво Манушыкано рисявэла павпалэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Нэ англал кадэлэстар Чяво Манушыкано хала бари грыжа и кадэва родо Лэстар отпхэнэлапэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Сар сля дэ вряма, кала джювда Нои, кади авэла и дэ вряма, кала рисявэла Чяво Манушыкано. ");
INSERT INTO rmyservi_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Мануша ханас, пэнас, лэнас ромнен и джянас паларом аж ды кодыя вряма, сар Нои заджиля дэ ковчего, а тунчи джиля баро пани и всавэрэ хасиле. ");
INSERT INTO rmyservi_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Кади ж сля дэ вряма, кала джювда Лото: мануша хале, пиле, тинэнас, битинэнас, чувэнас ворзо дэ пхув, ваздэнас цэра. ");
INSERT INTO rmyservi_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Нэ дэ дивэ, кала Лото выджиля форостар Содомо, джиле упралимастар ягуно брышынд и сера и всавэрэ хасиле. ");
INSERT INTO rmyservi_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Кади ж авэла и дэ кодэва диво, кала Чяво Манушыкано сикавэлапэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Дэ кодэлэ дивэ мануш, саво авэла упрэ пэ ушарди, а кырпы лэхкэрэ — дэ цэр, мэк на змукэлпэ тэлэ пала лэн. Ко авэла пэ маля, мэк на рисявэл цэрэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Рипэрэн Лотохкиря ромня! ");
INSERT INTO rmyservi_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ко камэл тэ фирисарэ пэхкоро джювимо, кодэва хасярэла лэ. Ай ко хасярэла пэхкоро джювимо, кодэва сфирисарэла лэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Пхэнав тумэнди: дэ кодыя рят совэна дуй мануша, екхэ залэна, ай авэр мануш ачелапэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Дуй манушня авэна тэ терэ варо ворзостар: екха манушня залэна, ай авэр ачелапэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Тунчи пхэндэ Исусости: — Рае, тев када авэла? Исусо пхэнда: — Пордэ, тев пашлёл муло трупо, стидэнапэ орлуря. ");
INSERT INTO rmyservi_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Тунчи Исусо пхэнда лэнди пала кода, со трэбуни всавири вряма тэ мангэпэ и тэ на грисявэ: ");
INSERT INTO rmyservi_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","— Дэ екх форо сля сындимари, саво Дэвлэстар на даралас и манушэндар на ладжяласпэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Дэ кодэва форо сля и екх джювли, савятэ муля ром. Вой пхирэлас сындимарестэ и мангэлас: «Пав чячима розлэ муро рындо! Фирисар ман кодэлэстар, ко дошарэл ман!» ");
INSERT INTO rmyservi_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Нэ сындимари бут вряма нисо на камля тэ терэ. Тунчи пхэнда еджино пэсти: «Мэ Дэвлэстар на дарав и манушэндар на ладжявпэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Нэ важ кода со кадыя джювли на пэрэачел тэ доха ман, пав чячима розлава лакоро рындо, соб вой будэр мандэ тэ на пхирэл и тэ на дохал ман». ");
INSERT INTO rmyservi_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","И пхэнда Рай: — Шунэн, со пхэнэл бибахтало сындимари? ");
INSERT INTO rmyservi_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","А кала кади, Дэвэл ли на фирисарэла пав чячима кодэлэн, савэн вытидэня и савэ зоралэ ґласоґа акхарэн Лэ диво и рят? Чи помукэла лэн Дэвэл? ");
INSERT INTO rmyservi_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Пхэнав тумэнди, со Дэвэл сиго лэн фирисарэла пав чячима. Нэ Чяво Манушыкано кала авэла, чи аракхэла Вов пэ пхуя патявимо? ");
INSERT INTO rmyservi_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Пхэнда Исусо кацави дума манушэнди, савэ гинисарэнас пала пэстэ, со вонэ фартэ пативалэ, а пала аврэн пхэнэнас, со вонэ бибахталэ: ");
INSERT INTO rmyservi_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","— Дуй мануша заджиле дэ храмо тэ мангэпэ. Екх лэндар сля фарисеи, ай авэр — стидэмари, саво лэлас налогуря. ");
INSERT INTO rmyservi_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Фарисеи ачелас тай мангляпэ дэ пэхкэрэ їлэ кади: «Дэвла! Наисарав тут пала кода, со мэ на кацаво, сар авэр мануша, савэ исин чёра, хохавнэ, терэн биладжявимо ромнятар, чи сар кадэва стидэмари. ");
INSERT INTO rmyservi_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Мэ рицарав посто дуй молы дэ курко, отдав дэшто котор муря ворхатар». ");
INSERT INTO rmyservi_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Стидэмари жэ ачиля дэ рига и ладжяво лэсти сля тэ ваздэ якха упрэ, нэ марэлас дэ колинэ еджино пэ и пхэнэлас: «Дэвла! Ковлисар їло Тиро важ ман, бэзимахкэрэ манушэ!» ");
INSERT INTO rmyservi_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Пхэнав тумэнди, со стидэмари джиля бидошакоро англа Дэвлэ, а фарисеи ачиля дошало. Кодэлэсти со кожно мануш, саво ваздэл еджино пэ, авэла обмукло, а саво тэлярэл еджино пэ, авэла ваздэно. ");
INSERT INTO rmyservi_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Анэнас Исусостэ цыкнэн чяворэн, соб Вов тэ лэлпэ лэндэ, а сиклярнэ дыкхле кода и запхэндэ лэнди. ");
INSERT INTO rmyservi_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Нэ Исусо акхарда сиклярнэн и пхэнда: — Мукэн чяворэн, соб тэ авэн Мандэ, и на запхэнэн лэнди, колэсти со Дэвлэхкоро Тхагаримо исин лэнгоро. ");
INSERT INTO rmyservi_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Чячимаґа пхэнав тумэнди: ко на прылэла Дэвлэхкоро Тхагаримо кади, сар прылэн цыкнэ чяворэ, кодэва дэ Дэвлэхкэрэ Тхагарима на заджяла. ");
INSERT INTO rmyservi_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Екх пхурэдэрэндар пхучля Исусостар: — Сиклимари лачё! Со манди тэ терэ, соб тэ доросав вечно джювимо? ");
INSERT INTO rmyservi_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Исусо пхэнда лэсти: — Сости ту пхэнэх пала Ман «лачё»? Кици Екх Дэвэл исин лачё. ");
INSERT INTO rmyservi_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ту джянэх заповедь: на тер биладжявимо тирэ їрестар, на умар, на чёр, на пхэн хохавимо пэ сындо, полэ тирэ дадэ и да. ");
INSERT INTO rmyservi_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Кодэва мануш пхэнда: — Вса откада мэ терав тэрнэ бэршэндар. ");
INSERT INTO rmyservi_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Исусо шунда када и пхэнда лэсти: — Екх тути на хутилэл: битин вса, со тутэ исин, и роздэ ловэ чёрорэнди, соб тэ авэл тутэ барвалимо пэ упралима. Тунчи ав и джя пала Ман! ");
INSERT INTO rmyservi_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Кала пхурэдэр шунда када, вов загрисиля, колэсти со сля фартэ барвало. ");
INSERT INTO rmyservi_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Исусо дыкхля, со вов загрисиля, и пхэнда: — Сар пхаро барвалэнди тэ заджя дэ Дэвлэхкэрэ Тхагарима! ");
INSERT INTO rmyservi_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Локхэдэр верблюдости тэ проджя машкар сувякоро каноро, сар барвалэсти тэ заджя дэ Дэвлэхкэрэ Тхагарима. ");
INSERT INTO rmyservi_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Кодэла, ко шундэ, пхучле: — Кастэ тунчи исин зора тэ фирисарэпэ? ");
INSERT INTO rmyservi_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Исусо пхэнда: — Кода, со манушэсти нащи тэ стерэ, кода стерэла Дэвэл. ");
INSERT INTO rmyservi_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Пётро пхэнда Исусости: — Акэ, амэ вса ачявдэ и джиле пала Тут. ");
INSERT INTO rmyservi_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Исусо пхэнда лэнди: — Чячимаґа пхэнав тумэнди: мануш, саво ачявда важ Дэвлэхкэрэ Тхагарима цэр, чи ромня, чи пхралэн, чи дадэ и да, чи чяворэн, ");
INSERT INTO rmyservi_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","лэла будэр дэ кадэлэ джювима, а дэ вряма, сави авэла, — вечно джювимо. ");
INSERT INTO rmyservi_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Тунчи Исусо отлиджялда дэ рига Пэхкэрэ сиклярнэн и пхэнда лэнди: — Акэ, амэ заджях дэ Ерусалимо, и терэлапэ вса, со чиндэ англунаря пала Чявэ Манушыканэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Кади со здэна Лэ бидэвлэхкэрэ манушэнди, и вонэ стерэна Лэстар асамо, дэна Лэсти бари дукх и бари грыжа, авэна тэ чунгардэ пэ Лэстэ, ");
INSERT INTO rmyservi_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","тэ марэ Лэ чукняґа, а тунчи умарэна. Нэ пэ трито диво Вов отджювдёла. ");
INSERT INTO rmyservi_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Нэ сиклярнэ нисо кадэлэстар на полиле, кадэла лава сле гаравдэ лэндар. Вонэ на джянэнас пала со Вов дэдумэл. ");
INSERT INTO rmyservi_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Кала Исусо поджялас форостэ, саво акхарэлпэ Ерихоно, екх коро бэшэлас паша дром и мангэлас ловэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Кала коро шунда, со пашэ лэстар джян мануша, вов пхучля: — Со када терэлпэ? ");
INSERT INTO rmyservi_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Лэсти пхэндэ: — Када джял Исусо Назаретостар. ");
INSERT INTO rmyservi_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Тунчи коро ачиля тэ типисявэ: — Исусо, Чяво Давидохкоро! Ковлисар Тиро їло важ ман! ");
INSERT INTO rmyservi_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Мануша, савэ джиле англал, прыпхэндэ лэсти, соб вов тэ заачел мулком, нэ коро типисиля инте зоралэдэр: — Чяво Давидохкоро! Ковлисар тиро їло важ ман! ");
INSERT INTO rmyservi_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Исусо ачиля пэ дром и прыпхэнда, соб тэ анэн кадэлэ корэ Лэстэ. Кала коро поджиля, Исусо пхучля: ");
INSERT INTO rmyservi_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","— Со ту камэх, соб Мэ тэ терав важ тут? Коро пхэнда: — Рае! Камав тэ дыкхэ! ");
INSERT INTO rmyservi_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Исусо пхэнда лэсти: — Дыкх! Тиро патявимо тут фирисарда! ");
INSERT INTO rmyservi_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Коро екхатар ачиля тэ дыкхэ и джиля пала Исусо, а еджино ачиля тэ ваздэ слава Дэвлэсти. И всавэрэ мануша, ко дыкхле кода, ваздэнас Дэвлэсти слава. ");
INSERT INTO rmyservi_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Тунчи Исусо заджиля дэ форо Ерихоно и проджялас пав лэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Тай акэ, екх барвало мануш, стидэмаренгоро пхурэдэр, савэ акхарэнас Закхеи, ");
INSERT INTO rmyservi_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","закамля тэ дыкхэ Исусо, Ко Вов исин. Нэ Закхеи сля цыкноро вучимаґа, и лэсти нащи сля тэ дыкхэ Исусо, колэсти со котэ стидэняпэ фартэ бут манушэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Колэсти вов прастэня англэ, заґульда пэ тутово кашт, соб тэ дыкхэ Исусо, кала Вов проджяла мамуй. ");
INSERT INTO rmyservi_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Кала Исусо авиля пэ кодэва тхан, Вов вздыкхля упрэ и пхэнда: — Закхеи! Змукпэ тэлэ! Авдивэ Манди трэбуни тэ авэ тутэ цэрэ! ");
INSERT INTO rmyservi_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Закхеи сиго змукляпэ и баря лошаґа прылиля Исусо. ");
INSERT INTO rmyservi_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Манушэнди, савэ сле котэ, фартэ на чялиля кода, и вонэ пхэнэнас: — Кастэ Вов заджиля дэ цэр! Манушэстэ, саво джювэл дэ бэзима! ");
INSERT INTO rmyservi_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Закхеи ж вщиля англа Рае тай пхэнда: — Рае! Епаш мурэ хулаимастар мэ отдава чёрорэнди, и кастэ лилём будэр, сар трэбуни, мэ рисарава штарвар будэр. ");
INSERT INTO rmyservi_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Исусо пхэнда лэсти: — Авдивэ фирисаримо авиля дэ кадэва цэр, колэсти со и Закхеи исин Авраамохкоро чяво! ");
INSERT INTO rmyservi_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Чяво Манушыкано авиля тэ аракхэ и тэ фирисарэ кодэлэн, савэ хасиле. ");
INSERT INTO rmyservi_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Кодэлэнди, ко када шунда, Исусо пхэнда инте екх дума. Колэсти со Исусо сля паша Ерусалимо, и мануша гинисардэ, со сиго оттерэлапэ Дэвлэхкоро Тхагаримо. ");
INSERT INTO rmyservi_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Исусо пхэнда: — Екх мануш барвалэ родостар лагля дэ дуратуни пхув, соб тэ аче лэсти тхагареґа, а тунчи камля тэ рисявэ павпалэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Вов акхарда дэшэн бутярнэн, дэня лэнди пав шэл драхмы и пхэнда: «Затерэн пэ кадэлэн ловэн манди ворха ды кодыя вряма, сар мэ рисявава павпалэ». ");
INSERT INTO rmyservi_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Нэ мануша лэхкиря пхуятар на камле кадэлэ рае и бичалдэ пативалэн манушэн пала лэ дэ дром, соб вонэ тэ пхэнэн: «Амэ на камах, соб кадэва мануш тэ авэл амарэ тхагареґа». ");
INSERT INTO rmyservi_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Нэ вов ачиля тхагареґа и рисиля павпалэ. Тунчи акхарда пэстэ бутярнэн, савэнди дэня ловэ, соб тэ уджянэ, скици вонэ затердэ лэсти ворха. ");
INSERT INTO rmyservi_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Авиля англуно бутярно и пхэнда: «Хулае! Пэ тирэ шэл драхмы мэ затердом екх пхангли!» ");
INSERT INTO rmyservi_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Хулай пхэнда лэсти: «Мишто. Ту — лачё бутярно! Пала кода, со ту слян чячюно дэ кадэва набаро рындо, дава дэш форуря тала тиро васт». ");
INSERT INTO rmyservi_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Авиля авэр бутярно и пхэнда: «Хулае! Тирэ шэл драхмы затердэ панч шэла драхмы!» ");
INSERT INTO rmyservi_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Хулай пхэнда кадэлэ бутярнэсти: «И ту ав пхурэдэрэґа пэ панчен форонэн». ");
INSERT INTO rmyservi_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Авиля трито бутярно и пхэнда: «Хулае! Акэ тути тирэ шэл драхмы! Мэ запханглём лэн дэ кхоснэ и гаравдом. ");
INSERT INTO rmyservi_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Мэ даравас тутар, колэсти со ту мануш, саво бут мангэл: ту лэх кода, со на тховэґас, и чинэх кода, со на чувэґас дэ пхув». ");
INSERT INTO rmyservi_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Хулай пхэнда лэсти: «Бибахтало бутярно, тирэ лавэнца сундисарава тут! Ту джянглян, со мэ — мануш, саво бут мангэл, и со мэ лав котэ, тев на тховавас, и чинав кода, со на чувавас дэ пхув? ");
INSERT INTO rmyservi_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Сости ту на дэнян мурэ ловэ дэ рындо? И кала мэ рисилём, тунчи залилём бы лэн и ворха упрэ». ");
INSERT INTO rmyservi_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","И пхэнда пашунэ манушэнди: «Залэнтэ лэстар шэл драхмы и дэнтэ кодэлэсти, кастэ исин екх пхангли!» ");
INSERT INTO rmyservi_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Мануша пхэндэ хулаести: «Хулае! Лэстэ и кади исин екх пхангли!» ");
INSERT INTO rmyservi_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Нэ хулай дэдуманя лэнди: «Пхэнав тумэнди, кастэ исин, кодэлэсти дэлапэ инте. А кастэ нэнай, залэлапэ и кода, со лэстэ исин. ");
INSERT INTO rmyservi_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Мурэн врыжымашэн, савэ на камле, соб мэ тэ авав лэнгэрэ тхагареґа, анэн кордэ и мулярэн англа ман». ");
INSERT INTO rmyservi_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Исусо розпхэнда када и джиля пав дром дэ Ерусалимо. ");
INSERT INTO rmyservi_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Кала Вов поджиля гавэндэ Виффагия тай Вифания, савэ аченас паша Оливково плай, Вов бичалда англэ дон Пэхкэрэн сиклярнэн ");
INSERT INTO rmyservi_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","и пхэнда: — Джян дэ гав, саво англа тумэн. Кала заджяна, дыкхэна, со ачел прыпхангло тэрно мугари, пэ савэ инте нико на бэшэлас. Отпхандэн лэ и лиджян Мандэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Кала ко пхучела тумэндар: «Пэ со тумэ отпхандэн мугаре?» — пхэнэн кади: «Вов трэбуни Раести». ");
INSERT INTO rmyservi_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Бичалдэ сиклярнэ джиле тай аракхле мугаре, сар пхэнда Исусо. ");
INSERT INTO rmyservi_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Кала вонэ отпхандэнас мугаре, хулая пхучле лэндар: — Пэ со тумэ отпхандэн мугаре? ");
INSERT INTO rmyservi_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Сиклярнэ пхэндэ: — Вов трэбуни Раести. ");
INSERT INTO rmyservi_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Тунчи андэ мугаре Исусостэ, чутэ пэ лэстэ пэхкири упралуни їда тай тховдэ Исусо упрал. ");
INSERT INTO rmyservi_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Кала Исусо ладэлас, мануша чувэнас пэ дром пэхкири упралуни їда. ");
INSERT INTO rmyservi_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Кала Исусо подлагля тханэстэ, тев дром змукэлпэ Оливковонэ плаестар, фартэ бут сиклярнэн подваздэне пэхкоро ґласо и лошаґа ачиле тэ ашарэ Дэвлэ пала барэ рындуря, савэ вонэ дыкхле. ");
INSERT INTO rmyservi_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","И пхэнэнас: — Бахтало исин Тхагари, Саво авэл важ Раехкоро Лав! Пачя пэ упралима и слава Дэвлэсти пэ вуче упралима! ");
INSERT INTO rmyservi_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Койсавэ фарисея аченас котэ и пхэндэ Исусости: — Сиклимари! Улэ Тирэ сиклярнэн! ");
INSERT INTO rmyservi_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Нэ Исусо дэдуманя лэнди: — Пхэнав тумэнди: кала вонэ заачена мулком, тунчи бара затиписявэна. ");
INSERT INTO rmyservi_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Кала вонэ поджиле пашэдэр Ерусалимостэ, Исусо вздыкхля пэ форо и заровиня. ");
INSERT INTO rmyservi_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Тай пхэнда: — О, тэ полэх бы ту авдивэ, со анэла тути пачя! Нэ кана гаравдо када тирэ якхэндар. ");
INSERT INTO rmyservi_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Авэна дивэ, кала тирэ врыжымашуря выджяна маримаґа пэ тут, ваздэна пэ тут пхуянэ плая, поджяна тутэ тай стасавэна тут всавэрэ ригэндар. ");
INSERT INTO rmyservi_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Розпхагэна тут, тирэ чяворэн мулярэна, бар пэ барэ тути на ачявэна, пала кода со ту на уджянглян вряма, кала Дэвэл авиля тутэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Тунчи Исусо заджиля дэ храмо и ачиля тэ вытрадэ тимисарен. ");
INSERT INTO rmyservi_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","И пхэнэлас: — Кади исин чиндо: «Муро цэр — када цэр мангимахкоро», а тумэ тердэ лэстар прахарицико цэр. ");
INSERT INTO rmyservi_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Диво дивэстар Исусо сиклярэлас манушэн дэ храмо. Нэ англунэ рашая, сиклимаря пав Упхэнима тай манушэнгэрэ пхурэдэра родэнас, сар тэ мулярэ Исусо. ");
INSERT INTO rmyservi_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","И на джянгле, сар када тэ стерэ, колэсти со всавэрэ мануша шундэ Исусохкэрэ лава и на камле тэ промукэ ни екх лэндар. ");
INSERT INTO rmyservi_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Екхвар, кала Исусо сиклярэлас манушэн дэ храмо и пхэнэлас Бахтало Лав, поджиле Лэстэ англунэ рашая тай сиклимаря пав Упхэнима їтханэ пхурэдэрэнца ");
INSERT INTO rmyservi_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","и пхучле Лэстар: — Пхэн амэнди, савя зораґа Ту вса кода терэх? И ко дэня Тути кадыя зор? ");
INSERT INTO rmyservi_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Исусо пхэнда лэнди дэ отпхэнима: — Пхучява и Мэ тумэн, пхэнэн Манди: ");
INSERT INTO rmyservi_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","катарь Иоанностэ зор тэ болдэ, упралимастар чи манушэндар? ");
INSERT INTO rmyservi_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Тунчи вонэ дэдумане машкар пэстэ: — Кала пхэнаґа: «Упралимастар», — Вов пхучела: «Сости ж тумэ лэсти на патине?» ");
INSERT INTO rmyservi_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","А кала пхэнаґа: «Манушэндар», — тунчи всавэрэ мануша марэна амэн барэнца, вонэ ж динэн, со Иоанно сля англунари. ");
INSERT INTO rmyservi_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","И пхэндэ: — Амэ на джянах, кастар. ");
INSERT INTO rmyservi_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Исусо пхэнда лэнди: — Тунчи и Мэ на пхэнава тумэнди, савя зораґа терав вса откада. ");
INSERT INTO rmyservi_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Тай пхэнда кацави дума: — Екх мануш выбарярда винограднико. Тунчи здэня лэ манушэнди пала ловэн, а еджино улагля пэ бут вряма. ");
INSERT INTO rmyservi_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Кала поджиля вряма, бичалда лэндэ пэхкэрэ бутярнэ, соб тэ залэ котор виноградостар, саво стидэне. Нэ виноградаря дукхавдэ бутярнэ и отбичалдэ лэ павпалэ шушэ вастэнца. ");
INSERT INTO rmyservi_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Хулай бичалда лэндэ аврэ бутярнэ, нэ вонэ мардэ лэ тай тэлярдэ лэхкири патив, и отбичалдэ шушэ вастэнца. ");
INSERT INTO rmyservi_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Хулай бичалда лэндэ инте екхэ бутярнэ. Нэ виноградаря и кодэлэ домардэ и вычутэ аври. ");
INSERT INTO rmyservi_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Тунчи хулай пав винограднико пхэнда: «Со манди тэ терэ? Бичалава лэндэ мурэ камлэ чявэ, чи на ладжяна лэстар?» ");
INSERT INTO rmyservi_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Нэ виноградаря дыкхле чявэ и пхэндэ екх екхэсти: «Акэ кодэва, касти доросэлапэ всаворо хулаимо, муляраґа лэ, тунчи хулаимо доросэлапэ амэнди». ");
INSERT INTO rmyservi_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Тунчи вылиджялдэ чявэ аври виноградникостар тай мулярдэ лэ. И со терэла лэнца виноградникохкоро хулай? ");
INSERT INTO rmyservi_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Авэла тай мулярэла кадэлэн виноградарен, а винограднико отдэла аврэ манушэнди. Мануша, савэ шундэ Исусо, пхэндэ: — Тэ на авэл кади! ");
INSERT INTO rmyservi_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Исусо вздыкхля пэ лэн и пхучля: — Сар тэ полэ кода, со чиндо: «Бар, саво вычутэ кодэла, ко ваздэнас цэр, ачиля шэрутнэ барэґа дэ вэнгло»? ");
INSERT INTO rmyservi_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ко тэлэдэла пэ кодэва бар, розмарэлапэ, а пэ кастэ кодэва бар пэрэла, розтасавэла лэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Дэ кодыя вряма сиклимаря пав Упхэнима тай англунэ рашая полиле, со Исусо пала лэн розпхэнэлас, и камле екхатар тэ хутилэ Лэ, нэ дарэне манушэндар. ");
INSERT INTO rmyservi_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Тунчи вонэ ачиле тэ дыкхэ пала Исусо и подбичалэнас Лэстэ манушэн, савэ поддыкхэнас пала Лэ и прытховэнаспэ пативалэ манушэнца, нэ родэнас, сар тэ астарэ Исусо пэ лавэн тай тэ здэ Лэ раенди и прыбэшлэсти Римостар. ");
INSERT INTO rmyservi_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Вонэ пхучле Исусостар: — Сиклимари! Амэ джянах, со Ту пхэнэх тай сиклярэх пав чячима. И на дыкхэх пэ мо манушэсти, нэ сиклярэх манушэн чячюнэ Дэвлэхкэрэ дромэсти. ");
INSERT INTO rmyservi_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Чи мишто пав Упхэнима тэ потинэ налогуря императости, чи нат? ");
INSERT INTO rmyservi_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Исусо полиля лэнгоро хрантимо тай пхэнда лэнди: ");
INSERT INTO rmyservi_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","— Сикавэнтэ манди динарии: кахкоро муй исин вымардо пэр лэстэ и кахкоро катэ лав? Вонэ пхэндэ: — Императохкэрэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Исусо пхэнда лэнди: — Тунчи отдэн императости императохкоро, а Дэвлэсти отдэн Дэвлэхкоро. ");
INSERT INTO rmyservi_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Лэндэ на выджиля тэ схутилэ Исусо пэ лавэ англа манушэн. Вонэ дэнепэ дыво Лэхкэрэ лавэнди и заачиле мулком. ");
INSERT INTO rmyservi_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Тунчи авиле койсавэ саддукея. Вонэ на патянас, со мулэ отджювдёна, тай пхучле Исусостар: ");
INSERT INTO rmyservi_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","— Сиклимари! Моисеи чинда амэнди, со, кала мэрэла мануш, кастэ сля ромни и на сля чяворэн, тунчи лэхкэрэ пхралэсти трэбуни тэ лэл боря паларом, соб тэ авэл пхралэстэ родо. ");
INSERT INTO rmyservi_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Сля эфта пхралэн. Пхурэдэр лэндар лиля пэсти ромня, нэ тунчи муля, и чяворэн на сля лэндэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Кади ж и авэр пхрал. ");
INSERT INTO rmyservi_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","И трито пхрал лиля пэсти кадэла ромня, и кади ж всавэрэ эфта пхралэн. Всавэрэ пхрала помуле, и чяворэн лэндэ на сля. ");
INSERT INTO rmyservi_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Тунчи муля и ромни. ");
INSERT INTO rmyservi_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Кала мулэ отджювдёна, кахкири ромни кадыя манушни авэла? Вой жэ эфта молы паларом выджялас! ");
INSERT INTO rmyservi_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Исусо пхэнда лэнди: — Мануша дэ кадэва вако лэн пэсти ромнен и джян паларом. ");
INSERT INTO rmyservi_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","А касти вытэлэдэла патив тэ джювэ дэ авэр вако тай савэ отджювдёна мулэндар, кадэла мануша на лэн пэсти ромнен и паларом на выджян. ");
INSERT INTO rmyservi_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Вонэ на мэрэна, нэ исин сар ангелуря. Вонэ важ Дэвлэ чявэ и чея, колэсти со авэна ваздэнэ мулэндар. ");
INSERT INTO rmyservi_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ай кода, со мулэ отджювдён, сикавда Моисеи паша терново кашт, саво пхаболас, кала пхэнда Раести, со Вов — Дэвэл Авраамохкоро, Дэвэл Исаакохкоро тай Дэвэл Иаковохкоро. ");
INSERT INTO rmyservi_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Вов — Дэвэл джювдэн, а на мулэн. Лэстэ всавэрэ исин джювдэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Пэ кода койсавэ сиклимаря пав Упхэнима пхэндэ: — Сиклимари! Ту мишто пхэндан. ");
INSERT INTO rmyservi_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","И всавэрэ даранас тэ пхуче Исусостар дурэдэр. ");
INSERT INTO rmyservi_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Тунчи Исусо пхучля лэндэ: — Сар пхэнэн, со Христосо исин Чяво Давидохкоро? ");
INSERT INTO rmyservi_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Кала еджино Давидо пхэнэл дэ лил «Псалмы»: «Пхэнда Рай Дэвэл мурэ Раести: Бэш пав чяче вастэ Мандар ");
INSERT INTO rmyservi_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ды кодыя вряма, сар Мэ чувава Тирэ врыжымашэн тала пурэн Тути». ");
INSERT INTO rmyservi_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Давидо акхарэл Лэ Раеґа. Сар Вов прыджялпэ Давидости чявэґа? ");
INSERT INTO rmyservi_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","И кала Исусо шундэ всавэрэ мануша, Вов пхэнда Пэхкэрэ сиклярнэнди: ");
INSERT INTO rmyservi_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","— Даран сиклимарендар пав Упхэнима, савэнди чялёл тэ пхирэ дэ лунго їда и соб мануша тэ наисарэнпэ лэнца пэ форо. Дэ синагога и дэ цэрэн, курик лэн акхарэн, вонэ камэн тэ бэшэ пэ англуно тхан. ");
INSERT INTO rmyservi_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Вонэ залэн цэра джювлендар, савэндэ муле рома, и бут мангэнпэ кади, соб тэ дыкхэн лэн мануша. Лэн дожутярэл барэдэр сындо. ");
INSERT INTO rmyservi_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Тунчи Исусо дыкхля, сар барвалэ мануша чувэнас даруля дэ храмохкоро сыртали. ");
INSERT INTO rmyservi_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Дыкхля кади ж, сар чёроры манушни, савятэ муля ром, чута дэ сыртали дуй харумэ хурдэ ловэнца. ");
INSERT INTO rmyservi_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Исусо пхэнда: — Чячимаґа пхэнав тумэнди, со кадыя чёроры манушни чута будэр всавэрэндар. ");
INSERT INTO rmyservi_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Всавэрэ пэхкэрэ барвалимастар дэне даро Дэвлэсти, а кадыя чёры отдэня всавэрэ ловэ, савэ сле латэ пэ джювима. ");
INSERT INTO rmyservi_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Кала мануша пхэнэнас пала храмо, сар вов стердо кучутнэ барэндар тай шукар обтховдо дарэнца, савэ анэнас Дэвлэсти, Исусо пхэнда: ");
INSERT INTO rmyservi_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","— Авэла вряма, кала кодэлэстар, со тумэ катэ дыкхэн, на ачелапэ бар пэ барэ, вса авэла розмардо. ");
INSERT INTO rmyservi_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Тай пхучле Исусостар: — Сиклимари! Кала вса откада авэла? Сави шпэра, со када вса сиго авэла? ");
INSERT INTO rmyservi_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Исусо пхэнда: — Дыкхэн, соб тумэн тэ на хохавэн! Бут манушэн авэна тала Муро Лав и пхэнэна: «Када Мэ» и «Авиля вряма». На джян пала лэндэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Кала шунэна пала маримо и пала кода, сар ваздэнпэ мануша екх пэ екхэстэ, тунчи на даран. Англал кадэлэсти трэбуни тэ авэ. Нэ агор авэла на екхатар. ");
INSERT INTO rmyservi_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Исусо пхэнэлас дурэдэр: — Народуря ваздэнапэ пэ марима екх екхэґа, и тхагаримо выджяла пэ марима тхагаримаґа. ");
INSERT INTO rmyservi_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Пхув затинисявэла баря зораґа, авэна пав тханэн бокха, насвалимо и бари дар, тай упралимо парувэлапэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Нэ англал мануша авэна тэ хутилэ тай тэ традэ тумэн, тэ отлиджя дэ синагоги тай тэ чувэ дэ барунэн. Вонэ лиджяна тумэн тхагарендэ и раендэ пала Муро Лав. ");
INSERT INTO rmyservi_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Тунчи тумэндэ авэла вряма тэ пхэнэ пала Ман. ");
INSERT INTO rmyservi_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Нэ тховэн пэсти дэ їлэ: на пхагэн шэро, со тэ пхэнэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Мэ дава тумэнди кацавэ лава и годи, со тумарэ врыжымашуря пхандэна муя и на выачена англа тумэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Доджяла ды кодэлэ, со дада и дэя, пхрала, родо тумаро и амала авэна тэ здэ тумэн, а койсавэн тумэндар мулярэна. ");
INSERT INTO rmyservi_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Всавэрэ мижона пэ тумэн пала Ман. ");
INSERT INTO rmyservi_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Нэ ни екх балоро тумарэ шэрэстар на хасявэла. ");
INSERT INTO rmyservi_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Кодэлэсти рицарэнпэ тумарэ патявимастэ, соб тэ фирисарэ тумаро джювимо. ");
INSERT INTO rmyservi_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Кала ж дыкхэна, со бут халавдэн стасавэн Ерусалимо, тунчи джянэн, со авиля вряма, кала форо кадэва авэла розмардо и ачявдо. ");
INSERT INTO rmyservi_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Тунчи кодэла, савэ дэ Иудея, мэк нашэн дэ плаен, и кодэла, ко дэ форо, мэк выджян лэстар, и савэ джювэн дэ гавэн, мэк дэ форо на заджян. ");
INSERT INTO rmyservi_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Кода исин вряма, кала Дэвэл дэла лэнди пав лэнгэрэн рындонэн и кала стерэлапэ вса, со чиндо. ");
INSERT INTO rmyservi_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Бида дэ кодэлэн дивэн джювленди, савэ исин пхарэ и савэ парварэн цыкнэ чяворэн. Важ кода со бари грыжа джял пэ кадыя пхув и бари холи пэ кадэлэн манушэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Койсавэн мулярэна барэ чюренца, бутэн схутилэна тай отлиджяна дэ пхуя, тев джювэн авэр народуря. Наиудея авэна тэ тасавэ пурэнца Ерусалимо ды кодэлэ, сар на пэрэачела лэнгири вряма. ");
INSERT INTO rmyservi_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Тунчи парувэнапэ кхам, чён тай чергэня. Народуря пэ пхув шунэна, сар море дэла баро ґласо, и лэн облэна бари дар и бари грыжа. ");
INSERT INTO rmyservi_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Вонэ авэна тэ хацарэ зора даратар, кала авэна тэ дожутярэ кода, со джял пэ кадыя люмля, и зора пэ упралима издрана. ");
INSERT INTO rmyservi_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Тунчи дыкхэна Чявэ Манушыканэ, Саво джял пэ хмара баря зораґа и дэ бари слава. ");
INSERT INTO rmyservi_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Кала вса кода авэла, тунчи вщен ворта и ваздэн тумарэ шэрэ упрэ, колэсти со фирисаримо тумаро пашэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","И пхэнда лэнди Исусо кацави дума: — Подыкхэнтэ пэ инжырно кашт и пэ авэр кашта. ");
INSERT INTO rmyservi_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Кала тумэ дыкхэна, со пэ лэн рандя розмукэнпэ, тунчи джянэн, со сиго авэла милай. ");
INSERT INTO rmyservi_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Кала тумэ дыкхэна, со вса кода терэлпэ, джянэн, со надур тумэндар исин Дэвлэхкоро Тхагаримо. ");
INSERT INTO rmyservi_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Чячимаґа пхэнав тумэнди: родо кадэва на проджяла, сар вса откада терэлапэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Упралимо тай пхув проджяна, нэ лава Мурэ на проджяна никала. ");
INSERT INTO rmyservi_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Дыкхэн пала пэстэ, соб тумарэ їлэ тэ на тасавэн биладжявимо, матимо и годи, сави кици думисарэл, сар дурэдэр тэ джювэ. Дыкхэн, соб кадэва диво тэ на авэл пэ тумэн, кала тумэ лэ на дожутярэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Сар кхувди чувэн пэ чириклен, кала вонэ на дожутярэн кода, кади ж и кадэва диво авэла пэ всавэрэн, ко джювэн пэ люмля. ");
INSERT INTO rmyservi_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Всавири вряма дыкхэн пала пэстэ тай мангэнпэ, соб тумэндэ тэ авэл зор тэ пэрэлиджя кода, со авэла пэ кадыя пхув, и тэ аче англа Чявэ Манушыканэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Дивэсэ Исусо сиклярэлас дэ храмо. Кала ж бэшэлас кхам, Вов джялас пэ Оливково плай и ратярэлас котэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Дэнзор всавэрэ мануша авэнас Исусостэ дэ храмо, соб тэ шунэ Лэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Сля пашэ сырботори, саво акхарэлпэ Биквасно мандро, а инте — Патради. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Англунэ рашая и сиклимаря пав Упхэнима родэнас, сар тэ мулярэ Исусо, нэ даранас манушэндар. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Тунчи сатана заджиля дэ Иуда, савэ акхарэнас Искариото, екхэ дэшудуе сиклярнэндар. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Иуда джиля тай допхэндапэ англунэ рашаенца и халавдэнца, со вов здэла лэнди Исусо. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Вонэ лошыле тай пхэндэ Иудасти, со потинэна лэсти. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Вов дэня лав и родэлас поджили вряма, кала Исусо ачелапэ Еджино, соб тэ здэ Лэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Авиля диво, саво акхарэлпэ Биквасно мандро, кала трэбуни тэ чинэ патрадякэрэ бакрорэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Тунчи Исусо акхарда Петро тай Иоанно и пхэнда лэнди: — Джян и лачярэн патрадякоро хамо. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Вонэ пхэндэ Исусости: — Тев Ту камэх, соб амэ тэ лачярах? ");
INSERT INTO rmyservi_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Исусо пхэнда лэнди: — Акэ, кала тумэ заджяна дэ форо, дыкхэна манушэ, саво лиджял вакхор панеґа. Джян пала лэ и заджян дэ кодэва цэр, курик вов заджяла. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Тай пхэнэн цэрэхкэрэ хулаести: «Сиклимари пхучел тутар: \"Тев цэр, соб Манди тэ ха патради Мурэ сиклярнэнца?\"» ");
INSERT INTO rmyservi_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Хулай сикавэла тумэнди баро цэр упрэ, саво прытидэне важ сырботори. Котэ терэн скаминд. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Вонэ джиле тай вса аракхле, сар пхэнда лэнди Исусо, и лачярдэ патрадякоро хамо. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Кала авиля вряма, Исусо тай апостолуря бэшле пала скаминдэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Тунчи Исусо пхэнда: — Сар Мэ камлём тэ ха кадэва патрадякоро хамо тумэнца англа кода, сар прылава бари грыжа. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Пхэнав тумэнди, со будэр на хава Мэ лэ ды кодыя вряма, сар терэлапэ кадыя патради дэ Дэвлэхкэрэ Тхагарима. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Тунчи Вов лиля тахтай, наисарда Дэвлэ тай пхэнда: — Прылэн кадэва тахтай и всавэрэ пэн лэстар. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Пхэнав тумэнди, со будэр на авава тэ пэ пимо виноградостар аж ды кодыя вряма, сар авэла Дэвлэхкоро Тхагаримо. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Тунчи Исусо лиля мандро, наисарда Дэвлэ, пхагля мандро пэ которэн, дэня лэнди и пхэнда: — Када исин Муро трупо, саво пала тумэн отдава. Кади терэн, соб тэ рапирэн Ман. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Кала вонэ хале, Исусо кади ж лиля тахтай и пхэнда: — Кадэва тахтай исин нэво завето дэ Мурэ ратэ, саво пала тумэн прочувэлпэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Тай акэ, васт кодэлэхкоро, ко здэл Ман, Манца пала екхэ скаминдэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Чяво Манушыкано джял кади, сар Лэсти трэбуни тэ проджя. Нэ бида кодэлэ манушэсти, саво здэл Лэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Тунчи сиклярнэ ачиле тэ пхуче екх екхэстар, ко лэндар камля кода тэ терэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Тунчи вонэ ачиле тэ хапэ екх екхэґа пала кода, ко лэндар барэдэр. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Исусо пхэнда лэнди: — Тхагаря народонэнгэрэ прыпхэнэн лэнди. Кодэла, кастэ исин зор, пхэнэн, со вонэ терэн лачимо. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Нэ тумэ на терэн кади. Барэдэр тумэндар мэк тэ авэл сар цыкнэдэр всавэрэндар, и кодэва, ко прыбэшло тумэндэ, мэк авэл сар бутярно. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Екх бэшэл пала скаминдэ, ай авэр стховэл пэ скаминдэ хамо. Ко лэндар барэдэр? Чи на кодэва, ко бэшэл пала скаминдэ? А Мэ машкар тумэн сар бутярно. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Тумэ пэрэлиджялдэ Манца бут зумавимо. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Сар Дад Муро дэня Манди Тхагаримо, кади и Мэ дав тумэнди, ");
INSERT INTO rmyservi_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","соб тумэ тэ хан и тэ пэн пала Мурэ скаминдэ дэ Мурэ Тхагарима. Тумэ бэшэна пэ тронуря тэ сундисарэ дэшудуй родуря Израилёхкэрэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","— Симоно, Симоно! Акэ, сатана мангля тэ зумавэ тумэн, соб тумэ тэ авэн жужардэ, сар див жужарэлпэ сулумэндар. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Нэ Мэ манглёмпэ пала тут, соб тэ на хацарэх патявимо. И кала ту рисявэґа павпалэ Мандэ, тунчи подрицарэґа тирэ пхралэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Пётро пхэнда Лэсти: — Рае! Пала Тут мэ и дэ барунэ, и пэ мэрима джява! ");
INSERT INTO rmyservi_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Исусо дэдуманя: — Пхэнав тути, Пётро, англа колэ, сар задилабэла башно авдивэ, ту тривал Мандар отпхэнэґапэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Тунчи Исусо пхэнда лэнди: — Кала Мэ бичалавас тумэн и тумэндэ на сля ни тышыла, ни траста, ни пундрангэ, чи на хутилэлас со тумэнди? Вонэ пхэндэ: — Нат. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Тунчи Исусо пхэнда лэнди: — Нэ екхатар, кала кастэсь исин тышыла чи траста, лэнтэ лэн. Ай кастэ нэнай, мэк кодэва битинэла пэхкири їда тай тинэла чюри. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Пхэнав тумэнди, со Манца авэла кода, сар чиндо: «И пала прахаре динэнас Лэ». Трэбуни, соб тэ стерэлпэ вса, со пхэндо пала Ман. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Вонэ пхэндэ: — Рае! Акэ, амэндэ исин дуй чюря! Исусо пхэнда лэнди: — Када хутилэла. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Тунчи Исусо выджиля цэрэстар тай джиля, сар Лэстэ сля прылито, пэ Оливково плай. Джиле Лэґа и Лэхкэрэ сиклярнэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Кала вонэ авиле пэ кодэва тхан, Исусо пхэнда: — Мангэнпэ, соб тэ на авэн тумэ зумавдэ! ");
INSERT INTO rmyservi_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Еджино джиля лэндар пэ скици чувэн бар, пэля пэ чянгэн, ачиля тэ мангэпэ ");
INSERT INTO rmyservi_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","тай пхэнда: — Дадэ! Кала исин Тири воля, залэ кадэва тахтай Мандар! Нэ мэк авэла, на сар Мэ камав, а сар камэх Ту. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Тай авиля ангело упралимастар и подрицарэлас Исусо. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Сля Лэсти фартэ пхаро, и Вов инте зоралэдэр мангэласпэ, кади со Лэхкоро пото сля сар рат и тэлэдэлас пэ пхув. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Кала помангляпэ, Исусо вщиля, поджиля сиклярнэндэ и дыкхля, со вонэ засутэ баря грыжатар. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Исусо пхэнда лэнди: — Сости тумэ совэн? Вщен и мангэнпэ, соб тэ на авэн тумэ зумавдэ! ");
INSERT INTO rmyservi_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Кала Исусо инте пхэнэлас кадэла лава, авиля гроза манушэн. Англал лэндар джялас екх дэшудуендар, савэ акхарэнас Иуда. Вов поджиля Исусостэ тэ чюминдэ Лэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Исусо пхэнда лэсти: — Иуда! Ту чюминдэх и дэ кодыя ж вряма здэх Чявэ Манушыканэ? ");
INSERT INTO rmyservi_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Кодэла, ко аченас пашэ, полиле, со екхатар авэла, тай пхэндэ: — Рае! Чи тэ на малавэ амэнди чюряґа? ");
INSERT INTO rmyservi_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Екх лэндар вылиля чюри, малавда англунэ рашаехкэрэ бутярнэ тай отчинда лэсти чячё кан. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Тунчи Исусо пхэнда: — Авэла тумэнди! Вов лиляпэ канэстэ и састярда бутярнэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Англунэ рашаендэ, халавдэндэ храмостар тай пхурэдэрэндэ, савэ авиле тэ схутилэ Исусо, Вов пхучля: — Сар пэ прахарэ, выджиле тумэ пэ Ман чюренца тай дэстэнца? ");
INSERT INTO rmyservi_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Диво дивэстар Мэ слём тумэнца дэ храмо, и тумэ на ваздэне пэ Ман пэхкоро васт. Нэ екхатар тумари вряма, кала калимо лиля зор. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Тунчи вонэ схутилдэ Исусо тай отлиджялдэ англунэ рашаестэ дэ цэр. А Пётро рицардапэ лэндар ригаґа, нэ джялас пала лэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Машкар грэда розлиджялдэ яг, и бэшле всавэрэ пашэ ягатэ. Бэшля и Пётро лэнца. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Екх бутярни дыкхля Петро, кала вов бэшэлас паша яга, прыдыкхляпэ лэстэ тай пхэнда: — И кадэва сля Лэґа. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Нэ Пётро на прыджянгляпэ тай пхэнда джювляти: — Нат, джювлие, мэ на джянав Лэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Проджиля набут вряма, авэр мануш дыкхля Петро и пхэнда: — И Ту екх лэндар! Нэ Пётро пхэнда кадэлэ манушэсти: — Нат, мануша, када на мэ! ");
INSERT INTO rmyservi_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Проджиля екх мардо вряма, тай инте екх мануш пхэнда дэ якхэн: — Чячимаґа, кадэва кади ж сля Лэґа, вов исин галилеянино. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Нэ Пётро пхэнда кадэлэ манушэсти: — Мануша, на джянав, пала со ту пхэнэх. И екхатар, кала вов инте пхэнэлас кадэва лав, затиписиля башно. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Тунчи Рай обрисиляпэ тай вздыкхля пэ Петро. И Пётро взгинисарда Раехкоро лав, сар Вов пхэнда лэсти: «Ды колэ, сар задилабэла башно авдивэ, ту тривал Мандар отпхэнэґапэ». ");
INSERT INTO rmyservi_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Вов выджиля котарь и заровиня кэркэ ясвэнца. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Мануша, савэ рицарэнас Исусо, марэнас Лэ тай асанас Лэстар. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Вонэ запхангле Лэсти якха, мардэ Лэ пав муй и пхученас: — Ту, англунари, пхэн, ко малавда Тут? ");
INSERT INTO rmyservi_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","И бут налаче лава пхэнэнас пала Исусо. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Кала проджиля рят, стидэнепэ манушэнгэрэ пхурэдэра, англунэ рашая и сиклимаря пав Упхэнима, андэ Исусо дэ лэнгоро Синедрионо ");
INSERT INTO rmyservi_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","тай пхучле Лэ: — Ту исин Христосо? Пхэн амэнди. Исусо дэдуманя: — Кала пхэнава тумэнди, тумэ на патяна. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","А кала Мэ пхучява тумэндар, тумэ нисо на пхэнэна Манди. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Нэ екхатар Чяво Манушыкано авэла тэ бэшэ пав чячи риг Дэвлэхкиря зоратар. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Тай пхэндэ всавэрэ: — И кади, Ту исин Дэвлэхкоро Чяво? Исусо пхэнда лэнди: — Тумэ еджинэ пхэнэн, со Мэ исин Дэвлэхкоро Чяво. ");
INSERT INTO rmyservi_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Кодэла мануша пхэндэ: — Саво допхэнимо амэнди инте трэбуни? Амэ еджинэ шундэ, со Вов пхэнда. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Тунчи всавэрэ, ко сле котэ, вщиле и отлиджялдэ Исусо Пилатостэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Тай ачиле тэ дошарэ Лэ и пхэнэнас: — Амэ уджянгле, со Вов змарэл амаро народо дромэстар, пхэнэл, со на трэбуни тэ потинэн налогуря императости, и дэдумэл пала Пэстэ, со Вов — Христосо, Тхагари. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Пилато пхучля Лэстар: — Ту Тхагари иудеенгоро? Исусо пхэнда: — Ту кади пхэнэх. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Пилато дэдуманя англунэ рашаенди и всавэрэ манушэнди: — Мэ на аракхав дэ Кадэлэ Манушэ нисави дош. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Нэ вонэ на пэрэаченас тэ дошарэ Исусо и пхэндэ: — Вов ваздэл манушэн и сиклярэл пав всавири Иудея, англал дэ Галилея, а тунчи авиля пэ кадэва тхан. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Пилато шунда када и пхучля: — Вов Галилеятар? ");
INSERT INTO rmyservi_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Кала Пилато уджянгля, со Исусо кодэлэ тханэстар, тев сля тхагареґа Иродо, вов бичалда Исусо Иродостэ, саво дэ кадэлэн дивэн сля дэ Ерусалимо. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Иродо дыкхля Исусо и фартэ лошыля. Вов думут камля тэ дыкхэ Исусо, колэсти со бут ашунда пала Лэ и камля, соб Вов тэ сикавэл лэсти варисаво дыво. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","И бут пала со розпхучелас Лэ, нэ Исусо нисо на пхэнда Иродости. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ай англунэ рашая и сиклимаря пав Упхэнима аченас котэ и дурэдэр дошарэнас Лэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Иродо їтханэ халавдэнца ачиле тэ обмукэ патив Исусохкири тай асанепэ Лэстар. Тунчи урявда Лэ дэ барвали їда тай отбичалда павпалэ Пилатостэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Дэ кодэва диво Иродо тай Пилато ачиле амалэнца, а ды колэ вонэ сле врыжымашэнца. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Пилато ж акхарда англунэ рашаен, пхурэдэрэн и всавэрэн манушэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Тай пхэнда лэнди: — Тумэ андэ мандэ Кадэлэ Манушэ и пхэндэ, со Вов ваздэл манушэн. Тай акэ, мэ англа тумэн роздыкхлём Лэхкоро рындо и на аракхлём дэ Кадэлэ Манушэ нисави дош, дэ савя тумэ Лэ вуджилисарэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Тай Иродо на дошарда Лэ и бичалда павпалэ. Вов нисо кацаво на терда, пала со Лэ трэбуни тэ сундисарэ пэ мэрима. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Мэ прыпхэнава тэ марэн Лэ чукненца, а тунчи отмукава. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Нэ всавэрэ мануша затиписиле: — Мэримо Лэсти! Отмук амэнди Варавва! ");
INSERT INTO rmyservi_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ай Варавва бэшля дэ барунэ пала кода, со вов мулярэлас и ваздэлас манушэн дэ форо. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Пилато упалэ подваздэня пэхкоро ґласо, колэсти со камля тэ отмукэ Исусо. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Нэ мануша типисиле: — Прымар, прымар Лэ пэ трушул! ");
INSERT INTO rmyservi_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Пилато дэ трито моло пхэнда лэнди: — Сави бида Вов терда? Мэ на аракхлём дэ Лэстэ нисави дош, пала савя Лэ трэбуни тэ сундисарэ пэ мэрима. Мэ прыпхэнава, соб Лэ тэ марэн чукненца, тай тунчи отмукава. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Нэ мануша затиписиле зоралэ ґласоґа, соб тэ прымарэ Лэ пэ трушул, и типимаґа домардэпэ пэхкоро. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Тунчи Пилато сундисарда Исусо кади, сар вонэ камле. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","И отмукля барунэстар прахаре, саво мулярэлас и ваздэлас всавэрэн манушэн дэ форо, а Исусо отдэня дэ лэнгэрэн вастэн, сар и мангле иудея. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Кала халавдэ лиджянас Исусо пэ мэрима, вонэ схутилдэ Симоно кирениянино, саво джялас малятар, и прыпхэндэ лэсти тэ лиджя трушул пала Исусо. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Фартэ бут манушэн джянас пала Исусо. Джянас пала Лэ и джювля, савэ марэнас еджинэ пэ дэ колинэн баря грыжатар тай фартэ ровэнас пала Лэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Исусо обрисиляпэ лэндэ тай пхэнда: — Чеялэ Ерусалимостар! На ровэн пала Ман! Нэ ровэн пала пэстэ и пала тумарэн чяворэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Акэ, поджял вряма, кала пхэнэна: «Бахталэ бичяворэнгэрэ, савэ на бэнёнас и на парварэнас цыкнэ чяворэн!» ");
INSERT INTO rmyservi_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Тунчи мануша пхэнэна вуче тай цыкнэ плаенди: «Тэлэдэн пэ амэн!» тай «Ушарэн амэн!» ");
INSERT INTO rmyservi_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","И кала терэн када джювдэ каштэґа, со тунчи терэна шукэґа? ");
INSERT INTO rmyservi_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Лиджялдэ пэ мэрима їтханэ Лэґа дон прахарен. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Кала авиле пэ тхан, саво акхарэлпэ Черепо, котэ прымардэ пэ трушул Исусо тай дон прахарен, екхэ пав чячи риг, ай аврэ пав зэрво риг Лэстар. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Исусо пхэнэлас: — Дадэ! Эртисар лэн! Вонэ на джянэн, со терэн. Халавдэ чутэ жребии и розлиле Лэхкири їда. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","А мануша аченас и дыкхэнас. Пхурэдэра терэнас асамо Исусостар тай пхэнэнас: — Аврэн фирисарда, а екхатар мэк Еджино Пэ фирисарэл, кала Вов исин Христосо, Савэ Дэвэл вытидэня. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Кади ж и халавдэ асанас Исусостар, поджянас Лэстэ тай дэнас Лэсти шукло мол. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","И пхэнэнас: — Кала Ту исин Тхагари иудеенгоро, тунчи фирисар Еджино Пэ! ");
INSERT INTO rmyservi_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Упрэ Лэстар сля чиндо: «Кадэва исин иудеенгоро Тхагари». ");
INSERT INTO rmyservi_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Екх прахарендар, саво сля амблавдо пэ трушул, кошэлас Исусо и пхэнэлас: — Кала Ту исин Христосо, фирисар Еджино Пэ и амэн! ");
INSERT INTO rmyservi_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Авэр прахари улэлас лэ тай пхэнэлас: — Ту Дэвлэстар на дарах? Ту еджино сундисардо пэ мэрима, сар и Вов. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Амэн сундисардэ пала амари дош и дэне амэнди кода, со амэ затердэ. Нэ Вов на терда нисаво вурытимо. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Тай пхэнда Лэсти: — Исусо, взгинисар пала ман, кала Ту авэґа дэ Тирэ Тхагарима! ");
INSERT INTO rmyservi_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Тай пхэнда лэсти Исусо: — Чячимаґа пхэнав тути: авдивэ ту авэґа Манца дэ раї. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Сля диво аври, пашэ дэшудуй чясо вряма, тай пав всавири пхув змукляпэ калимо ды тритонэ чясо вряма. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Кхам калиля, тай похтан, саво сля амблавдо дэ храмо, пхариля поепаш. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Тунчи Исусо затиписиля зоралэ ґласоґа: — Дадэ! Дэ Тирэ вастэн отдав Муро фано! Вов пхэнда када и отдэня фано. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Кала шэлякоро пхурэдэр дыкхля вса откада, вов ваздэня слава Дэвлэсти тай пхэнда: — Чяче, Вов сля дэвликуно Мануш! ");
INSERT INTO rmyservi_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Всавэрэ мануша, савэ стидэнепэ, соб тэ дыкхэ Лэхкоро мэримо, дыкхле, со тердапэ, джиле павпалэ тай марэнас еджинэ пэ дэ колинэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Дурал ачиле и дыкхэнас пэ кода мануша, савэ джянгле Исусо, тай джювля, савэ джянас пала Лэстэ Галилеятар. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Котэ сля лачё и пативало мануш, савэ акхарэнас Иосифо. Вов сля екх пхурэдэрэндар дэ Синедрионо, ");
INSERT INTO rmyservi_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","нэ на подрицарэлас лэнгэрэ лава и рындуря. Вов выбариля дэ форо Аримафея тай дожутярэлас, кала авэла Дэвлэхкоро Тхагаримо. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Вов авиля Пилатостэ тэ мангэ, соб кодэва тэ отдэл лэсти Исусохкоро трупо. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Иосифо слиля трупо трушулэстар, обкхувда похтаноґа, дэ савэ гаравэн мулэн, тай тховда дэ склепо, саво сля вымардо дэ барэ и тев инте ника на гаравэнас. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Када сля диво, кала лачярэнаспэ субботатэ. И суббота сля пашэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Пала Иосифо джянас джювля, савэ авиле Исусоґа Галилеятар. Вонэ дыкхле склепо и сар тховэнас пордэ Исусохкоро трупо. ");
INSERT INTO rmyservi_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Тунчи рисиле цэрэ и лачярдэ мастина и миро. Ай кала авиля суббота, вонэ отцинёнас, сар чиндо дэ заповедь. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Пэ англуно куркэхкоро диво, дэнзор, кала кхам вщелас, джювля лиле лачярдэ мастина и джиле склепостэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Нэ кала авиле, удыкхле, со бар склепостар оттховдо дэ рига. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Кала заджиле андрал дэ склепо, на аракхле Рае Исусохкоро трупо. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Джювля на джянгле, сар кода тэ полэ. Тунчи ачиле англа лэн дуй мурша дэ їда, савятар марэлас одуд, сар молния. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Джювля фартэ дарэне и обмукле шэрэ тэлэ, нэ мурша пхэндэ лэнди: — Сости тумэ родэн джювдэ машкар мулэн? ");
INSERT INTO rmyservi_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Лэ нэнай катэ, Вов отджювдиня мулэндар. Взгинисарэн, сар Вов пхэнэлас тумэнди инте дэ Галилея: ");
INSERT INTO rmyservi_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","«Чяво Манушыкано авэла отдэно дэ вастэн бэзимахкэрэ манушэнди, авэла прымардо пэ трушул и отджювдёла мулэндар пэ трито диво». ");
INSERT INTO rmyservi_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Тунчи вонэ взгинисардэ Исусохкэрэ лава. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Тунчи рисиле склепостар и розпхэндэ пала вса кода дэшуекхэнди и всавэрэнди, савэ лэнца сле. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Кадэла джювля сле Мария Магдалина, Иоанна, дэй Иаковохкири, савя кади ж акхардэ Мария. И авэр джювля, савэ сле лэнца, кади ж пхэнэнас пала кода апостолонэнди. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Апостолуря думисардэ, со джювля дэдумане динимо, и на патине лэнди. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Нэ Пётро всаекх вщиля и прастэня склепостэ. А кала тэлювда склепостэ, вов дыкхля, со котэ пашлёл екх похтан. Тай джиля павпалэ, а еджино на патялас колэсти, со дыхле лэхкэрэ якха. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Дэ кодэва диво дуй сиклярнэндар джянас дэ гав Эммаусо, саво сля пашэ дэшудуй километры Ерусалимостар. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Тай дэдумэнас екх екхэґа пала вса, со тердапэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Кала вонэ дэдумэнас тай розпхученас екх екхэ, Еджино Исусо пашыня лэндэ и джиля лэнца. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Нэ лэнди сля затердо, и вонэ на уджянгле Исусо. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Исусо пхучля лэндар: — Пала со тумэ дэдумэн дромэґа? Вонэ ачиле и помукле муя. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Екх сиклярнэндар, Клеопа, пхэнда: — Всавэрэндар, ко авиля дэ Ерусалимо, Ту, выджял, екх, Саво на джянэл, со стердапэ пэ дивэн? ");
INSERT INTO rmyservi_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Исусо пхучля: — Пала со Мэ на джянав? Вонэ пхэндэ Лэсти: — Пала кода, со стердапэ Исусоґа Назаретостар, Саво сля англунари, зорало дэ всавэрэ, со терэлас и пхэнэлас англа Дэвлэ и англа манушэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Сар амарэ англунэ рашая и пхурэдэра отдэне Лэ пэ мэрима и прымардэ Лэ пэ трушул. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ай амэндэ сля надия, со Вов фирисарэла Израили. Тай акэ, джиля трито диво, сар вса откада стердапэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Нэ койсавэ амарэ джювлендар розпхэндэ амэнди кода, состар амэ дэнепэ дыво. Вонэ авиле дэнзор, кала кхам вщелас, склепостэ ");
INSERT INTO rmyservi_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","тай на аракхле котэ Исусохкоро трупо. Тунчи рисиле тай розпхэндэ амэнди, сар лэнди сикавдэпэ ангелуря и пхэндэ, со Исусо джювдо. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Койсавэ амэндар джиле склепостэ и аракхле, со котэ вса кади, сар и пхэндэ джювля, нэ Исусо на дыкхле. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Тунчи Вов пхэнда лэнди: — Чи нэнай тумэндэ годи? Сар пхаро тумэ патян кодэлэсти, со пхэндэ англунаря! ");
INSERT INTO rmyservi_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Чи на трэбуни сля Христости тэ ха бари грыжа и тэ заджя дэ бари слава? ");
INSERT INTO rmyservi_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","И ачиля тэ розпхэнэ джикай Моисеестар тай всавэрэн аврэн англунарен и сикавда, со чиндо сля пала Лэ дэ всавэрэн Лилэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Тунчи сиклярнэ поджиле пашэ гавэстэ, курик джянас. Исусо сикавда лэнди, со камля тэ джя дурэдэр. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Нэ вонэ фартэ мангэнас Лэ: — Ачпэ амэнца! Диво поджиля пашэ рятятэ. Вов заджиля дэ цэр и ачиляпэ лэнца. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Кала Вов бэшля лэнца пала скаминдэ, тунчи лиля мандро, наисарда, розпхагля и подэня лэнди. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Тунчи оттердэпэ лэнгэрэ якха, и вонэ уджянгле Исусо. Нэ Лэ на ачиля душло. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Вонэ ачиле тэ пхэнэ екх екхэсти: — Чи на пхабонас амарэ їлэ, кала Вов дэдуманя амэнца дромэґа и оттерда амэнди, со чиндо дэ Лилэн? ");
INSERT INTO rmyservi_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Вонэ екхатар вщиле тай рисиле дэ Ерусалимо. Кала авиле, котэ аракхле дэшуекхэн и кодэлэн, савэ лэнца сле. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Апостолуря розпхэндэ лэнди, со Рай чячимаґа отджювдиня мулэндар тай сикавдапэ Симоности. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Тунчи кодэла розпхэндэ, со тердапэ лэнца пав дром и сар вонэ уджянгле Исусо, кала Вов пхагля мандро. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Кала вонэ инте дэдумане, Еджино Исусо ачиля машкар лэн и пхэнда: — Пачя тумэнди! ");
INSERT INTO rmyservi_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Вонэ замуле даратар и гинисардэ, со дыкхэн мулэхкоро фано. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Нэ Исусо пхэнда лэнди: — Сости тумэ даран? Сости тумаро патявимо исин кацаво цыкно? ");
INSERT INTO rmyservi_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Подыкхэнтэ пэ Мурэ вастэн и пурэн! Када Мэ исин. Лэнпэ Мандэ тай роздыкхэнтэ. Фаностэ нэнай трупо и кокала, а Мандэ исин. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Исусо пхэнда откада тай сикавда лэнди Пэхкэрэ васта и пурэ. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Кала вонэ лошатар инте на патянас и дэнаспэ дыво, Исусо пхучля лэндар: — Исин тумэндэ хамо? ");
INSERT INTO rmyservi_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Вонэ дэне Лэсти котор пэклэ мачестар. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Исусо лиля кода и халя англа лэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Тай пхэнда лэнди: — Акэ пала со Мэ пхэнавас, кала инте слём тумэнца: трэбуни, соб тэ авэл вса, сар чиндо пала Ман дэ Моисеехкэрэ Упхэнима, англунарендэ и дэ Псалмэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Тунчи Вов оттерда лэнди годи, соб тэ полэн кода, со чиндо. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","И пхэнда лэнди: — Чиндо, со Христосо хала бари грыжа и пэ трито диво отджювдёла мулэндар. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Важ Лэхкоро Лав джикай Ерусалимостар, ай тунчи всавэрэ народонэнди авэла розпхэндо, со, кала вонэ ачявэна бэзимо, тунчи Дэвэл эртисарэла лэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Тумэ авэна тэ розпхэнэ пала кода всавэрэ манушэнди. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Акэ, Мэ бичалава тумэнди кода, пала со Муро Дад пхэнда. Нэ тумэ аченпэ дэ форо джикай кодыя вряма, кала сджяла пэ тумэн зор упрал. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Тунчи Исусо вылиджялда лэн форостар и джиля лэнца дэ Вифания. Котэ Вов ваздэня Пэхкэрэ васта и пхэнда бахталэ лава пала лэн. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","И кала инте пхэнэлас, ачявда лэн и ачиля тэ ваздэпэ пэ упралима. ");
INSERT INTO rmyservi_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Сиклярнэ тэлювдэ Лэсти тай баря лошаґа рисиле дэ Ерусалимо, ");
INSERT INTO rmyservi_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","тев всавири вряма сле дэ храмо и ваздэнас слава Дэвлэсти.");
INSERT INTO rmyservi_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Пативало Феофило, дэ муро англуно лил мэ искриисардом пала вса, со терэлас Исусо и сости Вов сиклярэлас ");
INSERT INTO rmyservi_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ды колэ дивэ, кала Свэнтонэ Фаноґа прыпхэнда вытидэне апостолонэнди кода, со лэнди трэбуни тэ терэ, и сля лито дэ болыбэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Пала Пэхкири бари грыжа Вов сикавдапэ лэнди джювдэґа тай допхэнда, со кода чячимо. Исусо сикавэласпэ лэнди саранда дивэ и дэдумэлас пала Дэвлэхкоро Тхагаримо. ");
INSERT INTO rmyservi_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Екхвар, кала вонэ сле їтханэ, Исусо прыпхэнда лэнди тэ на уджян Ерусалимостар, нэ тэ дожутярэн кода, со Дад камля лэнди тэ дэ. — Акэ, терэлпэ кода, со тумэ шундэ Мандар. ");
INSERT INTO rmyservi_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Иоанно болдэня панеґа, нэ тумэ сиго авэна болдэ Свэнтонэ Фаноґа. ");
INSERT INTO rmyservi_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Тунчи кодэла, савэ котэ сле, пхучле Лэстар: — Рае, на дэ кадыя вряма Ту камэх тэ ваздэ упалэ Израилёхкоро тхагаримо? ");
INSERT INTO rmyservi_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Вов пхэнда лэнди: — На тумаро рындо тэ джянэ вряма и чясо, савэ Дад тховда Пэхкиря зораґа. ");
INSERT INTO rmyservi_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Нэ кала пэ тумэн сджяла Свэнто Фано, тумэ лэна зор и авэна тэ розпхэнэ пала Ман дэ Ерусалимо, пав всавири Иудея, дэ Самария и пав всавири люмля. ");
INSERT INTO rmyservi_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Кала Вов пропхэнда када, вонэ дыкхле, сар Вов ваздэняпэ упрал, и хмара затерда Лэ лэнгэрэ якхэндар. ");
INSERT INTO rmyservi_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Вонэ на пэрэаченас тэ дыкхэ пэ болыбэн, кала Вов ваздэласпэ. Тай акэ, паша лэн ачиле дуй мануша дэ парни їда. ");
INSERT INTO rmyservi_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","— Галилеянуря, — пхэндэ вонэ, — сости тумэ ачен и дыкхэн дэ болыбэн? Кадэва Исусо, Саво сля лито тумэндар дэ болыбэн, рисявэла кади ж, сар тумэ дыкхле Лэ, кала уджялас. ");
INSERT INTO rmyservi_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Тунчи вонэ рисиле дэ Ерусалимо плаестар, саво акхарэлпэ «Оливково». Вов сля надур форостар, дром, саво домукэнас тэ проджя дэ суббота. ");
INSERT INTO rmyservi_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Кала вонэ авиле дэ цэр, дэ саво джювдэ набари вряма, тунчи ваздэнепэ дэ упралуни цэра. Котэ сле Пётро тай Иоанно, Иаково тай Андреи, Филиппо тай Фома, Варфоломеи тай Матфеи, Иаково, Алфеёхкоро чяво, Симоно Зилото тай Иуда, Иаковохкоро чяво. ");
INSERT INTO rmyservi_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Всавэрэ вонэ їтханэ сле дэ мангима. Лэнца сле набут джювлен, дэй Исусохкири, Мария, тай Лэхкэрэ пхрала. ");
INSERT INTO rmyservi_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Дэ кодыя вряма Пётро вщиля машкар патякунэн (а лэн стидэняпэ паша шэл тай биш мануш) и пхэнда: ");
INSERT INTO rmyservi_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","— Мурша! Пхралалэ! Трэбуни сля, соб тэ стерэлпэ кода, со чиндо дэ Лилэн, тев Свэнто Фано пхэнда чэрез Давидо пала Иуда, саво лиджялас колэн, савэ пхангле Исусо. ");
INSERT INTO rmyservi_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Иуда сля екх амэндар, саво терэлас амэнца екх бути. ");
INSERT INTO rmyservi_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Пэ ловэ, савэ вов затерда пала пэхкоро вурыто рындо, вов тинда маля. Нэ тэлэдэня и кади фартэ замардапэ, со пхариля лэхкоро води и выґульдэ лэстар всавэрэ пора. ");
INSERT INTO rmyservi_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Пала кода уджянгле всавэрэ, ко джювдэ дэ Ерусалимо, и проакхардэ маля пав пэхкири чиб Акелдама, ай пав аврэ — «Ратэхкири маля».) ");
INSERT INTO rmyservi_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Дэ лил «Псалмы» искриисардо: «Мэк лэхкоро цэр тэ авэл шушо, и мэк котэ нико на джювэл». Тай инте: «Мэк авэр лэхкоро тхан залэла». ");
INSERT INTO rmyservi_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Колэсти амэнди трэбуни тэ вытидэ екхэ кодэла манушэндар, ко пхирэлас амэнца всавири вряма, тев бы тэ на джял Рай Исусо, ");
INSERT INTO rmyservi_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","кодэла вряматар, кала Иоанно болдэня Лэ ды колэ дивэ, кала Исусо сля лито амэндар. Кадэва мануш, сар и амэ, трэбуни тэ авэл допхэнимари пала Исусохкоро отджюндивимо. ");
INSERT INTO rmyservi_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Вытидэне дон: Иосифо, савэ инте акхарэнас Варсавва, а кади ж — Иусто, тай Матфие. ");
INSERT INTO rmyservi_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Тай поманглепэ: — Рае, Ту джянэх їло кожнонэхкоро; сикав екхэ кадэлэндар дондар, ка Ту вытидэнян ");
INSERT INTO rmyservi_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","тэ лиджя бути апостолэнгири, соб вов тэ парувэл Иуда, саво ачявда амэн и джиля дэ тхан, тев трэбуни лэсти тэ авэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Тунчи вонэ чутэ жребии, тай вов выпэля пэ Матфие, саво прыачиля дэшуекхэ апостолонэндэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Авиля Пандэшахкоро диво, и всавэрэ вонэ сле їтханэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Екхатар болыбнастар шундапэ фоно, саво сджялпэ, сар пхурдэл фартэ бари балвал, и саво пхэрдиля всаворо цэр, тев вонэ бэшле. ");
INSERT INTO rmyservi_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Сиклярнэ дыкхле сось, со поджило пэ ягунэ чиба, савэ розджилепэ и ачиле по екхэ пэ кожно лэндар. ");
INSERT INTO rmyservi_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Всавэрэ вонэ пхэрдиле Свэнтонэ Фаноґа и ачиле тэ дэдумэ аврэ чибэнца, сар дэлас лэнди Фано. ");
INSERT INTO rmyservi_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Дэ кадыя вряма дэ Ерусалимо сле дэвликунэ иудея всавэрэ тханэндар, савэ исин дэ люмля. ");
INSERT INTO rmyservi_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Пэ кадэва фоно стидэнепэ бут манушэн, тай на полэнас, со катэ терэлпэ, колэсти со кожно лэндар шунда, сар кодэла дэдумане пав лэхкири чячи чиб. ");
INSERT INTO rmyservi_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Вонэ фартэ дэнас дыво тай пхученас: — Чи всавэрэ кадэла мануша, савэ дэдумэн, на галилеянуря? ");
INSERT INTO rmyservi_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Сар же када кожно амэндар шунэл, сар вонэ дэдумэн пав амари чячи чиб? ");
INSERT INTO rmyservi_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Машкар амэн исин кацавэ иудея: парфянуря, мидянуря, еламитуря, кодэла, ко джювэн дэ Месопотамия, Иудея тай Каппадокия, дэ Понто и дэ Цыкни Азия, ");
INSERT INTO rmyservi_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","дэ Фригия тай Памфилия, дэ Египто, дэ котор Ливийско пхув, саво паша Кирена, и кодэла, ко джювэн дэ Римо, ");
INSERT INTO rmyservi_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","иудея и кодэла, савэ прылиле иудееенгоро сикляримо, критянуря тай арабуря. И всавэрэ амэ шунах, сар вонэ дэдумэн пала барэ рындуря Дэвлэхкэрэ пэ амарэн чибэн! ");
INSERT INTO rmyservi_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Вонэ дэнас дыво, на джянгле, сар кода тэ полэ, тай пхученас екх екхэстар: — Со када исин? ");
INSERT INTO rmyservi_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","А койсавэ подасанаспэ: — Вонэ пиле тэрно мол тай матиле! ");
INSERT INTO rmyservi_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Пётро вщиля їтханэ аврэнца дэшуекхэнца, ачиля тэ дэдумэ манушэндэ, ваздэня пэхкоро ґласо тай пхэнда: — Мурша иудея и всавэрэ, ко джювэн дэ Ерусалимо! Соб тумэ тэ полэн вса, шунэн тай чувэн сама, со мэ пхэнав. ");
INSERT INTO rmyservi_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Кадэла мануша на матэ, сар тумэ думисарэн: екхатар енякоро чясо дэ дэнзор. ");
INSERT INTO rmyservi_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Нэ када терэлпэ пав лавэн, савэ пхэнда англунари Иоили: ");
INSERT INTO rmyservi_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","«Дэ кодэлэн дивэн, — пхэнэл Дэвэл, — Мэ чувава Фано пэ всавэрэн манушэн. Тумарэ чявэ и чея авэна тэ дэдумэ сар англунаря, тумарэ тэрнэ чявэ дыкхэна сунэ англунарехкэрэ дивэсэґа, А тумарэ пуранэ — рятяґа. ");
INSERT INTO rmyservi_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Пэ Мурэн копылен, муршэн тай джювлен, Мэ дэ кодэлэн дивэн чувава Фано тай авэна тэ дэдумэ сар англунаря. ");
INSERT INTO rmyservi_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Мэ сикавава дывуря упрэ дэ болыбэн и барэ рындуря тэлэ пэ пхув: рат, яг и тхува. ");
INSERT INTO rmyservi_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Кхам калёла, а чён лолёла, сар рат англа кода, сар авэла баро и чудно диво Дэвлэхкоро. ");
INSERT INTO rmyservi_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Тай кожно, ко прыакхарэла Раехкоро Лав, авэла фирисардо». ");
INSERT INTO rmyservi_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Мурша израильтянуря, вышунэн, со мэ пхэнава! Бари бути, зоралэ рындуря и допхэнимо Дэвэл стерда чэрэз Исусо англа амарэн якхэн, и тумэ джянэн пала кода. Кадэлэґа Дэвэл сикавда, со Мурш Исусо Назаретостар авиля Лэстар. ");
INSERT INTO rmyservi_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Пав воля Дэвлэхкири и пав кода, со Лэстэ сля пэ годя майанглал, тумэ умардэ Лэ, кала отдэне дэ вастэн кодэлэнди, ко на джювэн пав Упхэнима, соб вонэ тэ прымарэн Лэ пэ трушул карфинэнца. ");
INSERT INTO rmyservi_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Нэ Дэвэл отджювдярда Лэ, фирисарда мэримахкиря грыжатар, и мэримастэ на сля зор Лэ тэ урицарэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Давидо дэдумэл пала Лэ: «Всавири вряма мэ дыкхлём Рае англа пэ: Вов пав чячё васт мандар — тэ на зджяв дромэстар. ");
INSERT INTO rmyservi_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Колэсти цэлэл їло муро, тай лошавэл чиб, и трупо муро авэла тэ джювэ дэ надия. ");
INSERT INTO rmyservi_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ту ж на ачявэґа муро води дэ адо тай на дэґа, соб свэнто Тиро тэ лэлпэ прахоґа. ");
INSERT INTO rmyservi_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ту сикавдан манди дрома джювимахкэрэ, Ту дэґа манди лош англа муй Тиро». ");
INSERT INTO rmyservi_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Пхралалэ, дэн манди тэ пхэнэ тумэнди ворта, со пропапо Давидо муля и сля загаравдо. Тай лэхкоро склепо ачел амэндэ и авдивэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Вов сля англунари и джянгля, со Дэвэл дэня лэсти солах тэ тховэ пэ лэхкоро троно манушэ, лэхкэрэ родостар. ");
INSERT INTO rmyservi_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Вов дыкхля англуни вряма и дэдумэлас пала Христохкоро отджюндивимо, со Вов на авэла ачявдо дэ адо, и со Лэхкоро трупо на лэлапэ прахоґа. ");
INSERT INTO rmyservi_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Тай акэ, Дэвэл отджювдярда Кадэлэ Исусо, и амэ всавэрэ допхэнимаря кадэлэсти! ");
INSERT INTO rmyservi_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Исусо сля ваздэно чяче Дэвлэхкэрэ вастэґа, прылиля Дадэстар, кода, со сля пхэндо — Свэнто Фано, тай чута Лэ пэ амэн, сар тумэ екхатар и дыкхэн и шунэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Давидо на ваздэласпэ пэ болыбэн, нэ дэдуманя: «Пхэнда Рай Дэвэл мурэ Раести: Бэш пав чяче вастэ Мандар, ");
INSERT INTO rmyservi_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Ды коя вряма, сар Мэ чувава Тирэ врыжымашэн Тути тала пурэн». ");
INSERT INTO rmyservi_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Колэсти, мэк всаворо цэр Израилёхкоро джянэл, со Кадэлэ Исусо, Савэ тумэ прымардэ пэ трушул, Дэвэл терда и Раеґа и Христоґа! ");
INSERT INTO rmyservi_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Кала мануша шундэ када, вонэ вса прылиле пашэ їлэстэ, и лэнди ачиля ладжяво. Вонэ пхученас Петро тай аврэн апостолонэн: — Пхралалэ, со амэнди тэ терэ? ");
INSERT INTO rmyservi_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Пётро пхэнда: — Ачявэн тумаро бэзимо, и мэк кожно тумэндар авэла болдо пала лав Исусо Христохкоро, соб тэ отмукэнпэ тумарэ бэзима, тай тумэ прылэна бициминакоро даро — Свэнто Фано. ");
INSERT INTO rmyservi_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Колэсти со кади сля пхэндо тумэнди, тумарэ чяворэнди и всавэрэнди, ко дурал тумэндар: всавэрэнди, ко авэла прыакхардо Раеґа, амарэ Дэвлэґа. ");
INSERT INTO rmyservi_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Тай бутэ аврэ лавэнца Пётро прыакхарэлас лэн, тай дэдумэлас: — Фирисарэнпэ кадэлэ хасютнэ родостар. ");
INSERT INTO rmyservi_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Кодэла, савэ прылиле лэхкири дума, болдэнепэ. Дэ кодэва диво прыачиля лэндэ пашэ трин пхангля мануш. ");
INSERT INTO rmyservi_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Вонэ рицарэнаспэ апостолонэнгэрэ сикляримастэ, всавири вряма сле їтханэ, прэпхагэнас мандро и мангэнаспэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Всавэрэ даранас Дэвлэстар и апостолуря терэнас баро допхэнимо тай барэ дывуря. ");
INSERT INTO rmyservi_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Всавэрэ патякунэ мануша сле їтханэ, и вса лэндэ сля екх. ");
INSERT INTO rmyservi_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Вонэ битинэнас вса, со лэндэ сля, и всаворо пэхкоро хулаимо, и роздэнас всавэрэнди, касти скаци трэбуни. ");
INSERT INTO rmyservi_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Кожно диво вонэ стидэнаспэ дэ храмо, тай пав цэрэн прэпхагэнас мандро и ханас лошаґа и жужэ їлэґа, ");
INSERT INTO rmyservi_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ашарэнас Дэвлэ и сле дэ лачима всавэрэ манушэндэ. И кожно диво Рай прытховэлас лэндэ фирисардэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Екхвар, дэ трито чясо дэ дивэ, дэ вряма мангимахкири, Пётро тай Иоанно джянас дэ храмо. ");
INSERT INTO rmyservi_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Паша храмохкэрэн вударэн, савэнди сля лав «Шукар», бэшэлас мануш, ланго бэнимастар. Кожно диво лэ ачявэнас паша вударэн, и вов мангля хурдимо кодэлэндар, ко заджялас дэ храмо. ");
INSERT INTO rmyservi_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Кала вов удыкхля Петро тай Иоанно, савэ джиле дэ храмо, тунчи мангля и лэндар. ");
INSERT INTO rmyservi_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Пётро тай Иоанно вхалепэ дэ лэ якхэнца, тай Пётро пхэнда: — Подыкх пэ амэн! ");
INSERT INTO rmyservi_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Мануш ваздэня пэхкэрэ якха, дожутярэлас, со вонэ сось дэна лэсти. ");
INSERT INTO rmyservi_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Нэ Пётро пхэнда: — Рупь тай совнак нэнай мандэ. Нэ кода, со исин, мэ дав тути. Дэ Лав Исусо Христохкэрэ Назаретостар — вщи тай пхир! ");
INSERT INTO rmyservi_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Тунчи Пётро лиля лэ пала чячё васт, подрицарда, соб вов тэ вщел, и дэ кодыя ж вряма пурэ тай чянга лангэхкэрэ састиле. ");
INSERT INTO rmyservi_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Вов всхукля пэ пурэн и ачиля тэ пхирэ. Тунчи вов заджиля лэнца дэ храмо, пхирэлас, хукэлас и ашарэлас Дэвлэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","И всавэрэ мануша дыкхле, со вов пхирэл и ашарэл Дэвлэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Вонэ уджянэнас, со када исин мануш, саво бэшэлас и мангэлас хурдимо аврял храмостар, паша Шукар вударэн, и дэнаспэ дыво кодэлэсти, со лэґа тердапэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Чёроро рицардапэ пала Петро тай Иоанно, тай всавэрэ мануша дэнаспэ дыво и стидэнаспэ лэндэ всавэрэ ригэндар дэ Соломонохкоро пусынд. ");
INSERT INTO rmyservi_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Пётро удыкхля када и ачиля тэ дэдумэ манушэнди: — Мурша израильтянуря, сости тумэ кади дэнпэ дывости? Сости тумэ дыкхэн пэ амэн кади, сар бы амэ пэхкиря зораґа тай пативаґа тердэ кода, со кадэва мануш пхирэл? ");
INSERT INTO rmyservi_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Дэвэл Авраамохкоро, Исаакохкоро тай Иаковохкоро, Дэвэл амарэ дадэнгоро лошарда Пэхкэрэ Копыле Исусо, Савэ тумэ прэдэне, и Савэстар отпхэндэпэ англа Пилато, кала кодэва камля Лэ тэ отмукэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Нэ тумэ отпхэндэпэ Свэнтонэстар и Пативалэстар и вымангле, соб тумэнди тэ отмукэн прахаре. ");
INSERT INTO rmyservi_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Тумэ умардэ Кодэлэ, Ко дэл джювимо, нэ Дэвэл отджювдярда Лэ мулэндар, и амэ кадэлэсти допхэнимаря. ");
INSERT INTO rmyservi_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Лэхкоро Лав дэня зор кадэлэ манушэсти, савэ тумэ дыкхэн и джянэн, и патявимо, саво Лэстар, састярда лэ тумэндэ пэ якхэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Пхралалэ! Мэ полав, со тумэ и тумарэ пхурэдэра на джянгле, со тердэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Нэ кади Дэвэл терда кода, со Вов пхэнэлас чэрэз всавэрэн англунарен, кала дэдуманя, со Христости трэбуни тэ прылэ кадыя грыжа. ");
INSERT INTO rmyservi_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","И кади, ачявэн тумаро бэзимо и рисявэн Дэвлэстэ, соб тумарэ бэзима тэ авэн скхослэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Соб Раестар тэ авэл вряма тэ отцинявэн, и соб Вов тэ бичявэл тумэнди Кодэлэ, Ка англэ вытидэня, Исусо Христо. ");
INSERT INTO rmyservi_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Нэ Исусости трэбуни тэ ачелпэ дэ болыбэн, кала авэла Лэхкири вряма и кала Дэвэл возтховэла вса; вряма, пала сави Вов думут пхэнэлас чэрэз Пэхкэрэн свэнтонэн англунарен. ");
INSERT INTO rmyservi_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Сар пхэнда Моисеи: «Тумарэ пхралэндар Рай, тумаро Дэвэл, тховэла тумэнди Англунаре, кацавэ, сар мэ. Тумэнди трэбуни тэ кандэ Лэс дэ всавэрэ, со Вов тумэнди пхэнэла. ");
INSERT INTO rmyservi_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","И кожно, ко на кандэла кадэлэ Англунаре, авэла вычиндо кадэлэ манушэндар». ");
INSERT INTO rmyservi_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","И всавэрэ англунаря, Самуило тай авэр пала лэ, кади ж допхэнэнас пала кадэлэн дивэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Тумэ ж англунаренгэрэ чявэ, и тумэ прылиле завето, саво дэня Дэвэл тумарэ дадэнди. Вов пхэнда Авраамости: «Тирэ родостар прылэна бахталимо всавэрэ мануша дэ люмля». ");
INSERT INTO rmyservi_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Кала Дэвэл отджювдярда Пэхкэрэ Копыле, Вов англа всавэрэ бичалда Лэ тумэндэ, соб тэ дэ бахталимо и тэ прыакхарэ кожнонэ тумэндар тэ отджян налаче рындостар. ");
INSERT INTO rmyservi_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Кала Пётро тай Иоанно дэдумане манушэндэ, лэндэ поджиле рашая, халавдэнгоро пхурэдэр дэ храмо и саддукея, ");
INSERT INTO rmyservi_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","савэ сле фартэ холярдэ кодэлэґа, со вонэ сиклярэн манушэн и розпхэнэн, со кацик дэ Исусо исин отджювдинимо мулэндар. ");
INSERT INTO rmyservi_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Вонэ захутилдэ Петро тай Иоанно, и, кади сар сля бельвель, бэшардэ лэн ды дэнзор дэ барунэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Бут мануша, савэ шундэ лав, патине, и кодэлэн, савэ патянас, ачиля паша панч пхангля. ");
INSERT INTO rmyservi_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Пэ авэр диво барэ рая, пхурэдэра и сиклимаря пав Упхэнима стидэнепэ їтханэ дэ Ерусалимо. ");
INSERT INTO rmyservi_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Котэ сле англуно рашай Аннас, Каиафа, Иоанно, Александро и всавэрэ мануша англунэ рашаехкэрэ родостар. ");
INSERT INTO rmyservi_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Вонэ тховдэ Петро тай Иоанно помашкар и ачиле лэндар тэ пхуче: — Савя зораґа и савэ лавэґа тумэ када тердэ? ");
INSERT INTO rmyservi_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Тунчи Пётро, саво пхэрдиля Свэнтонэ Фаноґа, пхэнда лэнди: — Рая манушэнгэрэ и пхурэдэра! ");
INSERT INTO rmyservi_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Кала тумэ авдивэ пхучен амэндар пала лачимо, саво амэ тердэ кадэлэ лангэсти, и сар амэ лэ высастярдэ, ");
INSERT INTO rmyservi_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","тунчи джянэн тумэ и всавэрэ мануша Израилёхкэрэ: кадэва мануш екхатар ачел англа тумэн высастярдо важ лав Исусо Христосо Назаретостар, Савэ тумэ ваздэне пэ трушул и Савэ Дэвэл отджювдярда мулэндар! ");
INSERT INTO rmyservi_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Исусо исин кодэва Бар, Саво сля отчуто тумэнцар, ко ваздэн цэра, и Саво ачиля шэрутнэ барэґа. ");
INSERT INTO rmyservi_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Нико авэр на дэла фирисаримо, колэсти со на дэно манушэнди нисаво авэр лав тала болыбэн, савэґа трэбуни амэнди тэ фирисарэпэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Всавэрэ дыкхле, со дэ Петро тай Иоанно нэнай дар, а душолас, со вонэ сле наирвалэ и набарэ мануша. Кала ж полиле, со вонэ сле Исусоґа, тунчи дэнепэ дыво. ");
INSERT INTO rmyservi_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Дыкхэнас паша лэн и высастярдэ манушэ, колэсти никастэ на сля зор сось лэнди тэ пхэнэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Тунчи вонэ прыпхэндэ лэнди тэ ачявэ Синедрионо и ачиле тэ дэдумэ машкар пэстэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","— Со амэнди тэ терэ кадэла манушэнца? — пхэнэнас вонэ. — Всавэрэ, ко джювэн дэ Ерусалимо, джянэн, со вонэ тердэ баро дыво, и амэ колэстар на отрисарахпэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Соб када тэ на розджялпэ инте буґлэдэр помашкар мануша, прыдараваґа лэн, соб вонэ никасти тэ на пхэнэн пала кадэва лав. ");
INSERT INTO rmyservi_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Вонэ акхардэ апостолонэн тай прыпхэндэ лэнди тэ на дэдумэн и тэ на сиклярэн важ Исусохкэрэ лавэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Нэ Пётро тай Иоанно пхэндэ лэнди: — Акэ, пхэнэн еджинэ, чи мишто англа Дэвэл тэ кандэ будэр тумэн, а на Дэвлэ? ");
INSERT INTO rmyservi_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Нэнай амэндэ зор тэ аче мулком пала кода, со амэ дыкхле тай шундэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Кодэла, ко вджянас дэ лэнгоро Синедрионо, инте екхвар прыдаравдэ лэн тай отмукле. Вонэ на аракхле дэ лэн нисави дош, а всавэрэ мануша ашарэнас Дэвлэ пала кода, со тердапэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Важ кода со манушэсти, савэґа тердапэ кадэва састяримахкоро дыво, сля будэр саранда бэрш. ");
INSERT INTO rmyservi_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Кала отмукле Петро тай Иоанно, вонэ рисиле пэхкэрэндэ тай розпхэндэ пала вса, со дэдумане англунэ рашая и пхурэдэра. ");
INSERT INTO rmyservi_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Кала патякунэ мануша шундэ пала када, вонэ всавэрэ їтханэ ваздэне ґласо Дэвлэстэ тай пхэндэ: — Дэвла Баро! Ту стердан болыбэн, пхув, море и вса, со дэ лэн исин. ");
INSERT INTO rmyservi_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ту пхэндан Свэнтонэ Фаноґа вуштэндар амарэ дадэ и Тирэ копыле Давидо: «Сости ваздэнпэ тай мижон люмлякэрэ родуля, и мануша камэн сось тэ терэ, нэ вса лэндэ выджяла ївья? ");
INSERT INTO rmyservi_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ваздэнепэ пхувякэрэ тхагаря, и пхурэдэра стидэнепэ їтханэ, соб тэ выджя пэ Рае Дэвлэ и пэ Христо Лэхкэрэ». ");
INSERT INTO rmyservi_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Чячюнэ, стидэнепэ дэ кадэва форо Иродо тай Понтии Пилато наиудеенца и Израилёхкэрэ манушэнца пэ Тиро Свэнто Копыли Исусо, Савэ Ту помакхлян. ");
INSERT INTO rmyservi_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Вонэ тердэ кода, со Ту тховдан Тиря зораґа и пав Тири воля. ");
INSERT INTO rmyservi_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","И екхатар, Рае, подыкх, сар вонэ даравэн амэн, и дэ Тирэ копыленди бидаракоро тэ розпхэнэ Тиро лав. ");
INSERT INTO rmyservi_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Процырдэ васт Тиро и састяр насвалэн, сикав допхэнимо и барэ дывуря важ лав Тирэ Свэнтонэ Копыле Исусо! ");
INSERT INTO rmyservi_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Кала вонэ поманглепэ, тхан, тев вонэ сле, затинисиля. Вонэ всавэрэ пхэрдиле Свэнтонэ Фаноґа тай бидаракоро пхэнэнас Дэвлэхкоро лав. ");
INSERT INTO rmyservi_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Бутэ манушэндэ, савэ патине, сле екх їло и води. Нико на бинэлас, со лэхкоро хулаимо исин кици важ лэ, нэ вса лэндэ сля екх. ");
INSERT INTO rmyservi_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Апостолуря баря зораґа пхэнэнас пала отджюндивимо Раехкоро Исусохкоро, и Дэвэл дэлас Пэхкоро бахталимо лэнди всавэрэнди. ");
INSERT INTO rmyservi_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Помашкар лэн на сля ниекх мануш, саво авэлас бы чёроро. Колэсти со кодэла, кастэ сля пхув тай цэра, битинэнас лэн, анэнас всавэрэ ловэ ");
INSERT INTO rmyservi_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","тай стховэнас паша пурэн апостолонэндэ. Кадэла ловэ роздэнаспэ кожнонэ манушэсти, пэ со лэсти трэбуни. ");
INSERT INTO rmyservi_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Акэ, Иосифо, савэ апостолуря акхарэнас Варнава (пав аврэ «чяво подрицаримахкоро»), левито Кипростар, ");
INSERT INTO rmyservi_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","савэстэ сля пхув, битинда пэхкири маля, анда ловэ и тховда паша пурэн апостолонэндэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Екх мануш, савэ акхарэнас Анания, їтханэ пэхкиря ромняґа Сапфираґа, битинда епаш хулаимо ");
INSERT INTO rmyservi_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","и ловэндар, савэ лиля пала хулаимо, епаш ачявда пэсти, тай лэхкири ромни джянэлас пала кода. А епаш ловэ вов анда и тховда паша пурэн апостолонэндэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Пётро пхэнда лэсти: — Анания, сар када выджиля, со сатана залиля тиро їло пэ скацик, со ту пхэндан начячимо Свэнтонэ Фаности и ачявдан пэсти ловэ, кала битиндан пэхкири пхув? ");
INSERT INTO rmyservi_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Пхув, сави ту битиндан, и кади сля тири, и ловэ, савэ ту лилян пала ла, всавэрэ тирэ сле. Пэ со ту лилян када пэсти дэ гындо? Ту пхэндан начячимо на манушэнди, нэ Дэвлэсти. ");
INSERT INTO rmyservi_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Сар кацик Анания шунда кадэла лава, вов тэлэдэня тай выджиля лэстар води. Всавэрэ, ко сле котэ, фартэ пэрэдаравдэпэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Поджиле тэрнэ мануша, залашардэ лэхкоро трупо, вылиджялдэ тай гаравдэ лэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Проджиля пашэ трин чясуря, тай авиля лэхкири ромни, сави на джянэлас, со котэ тердапэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Пётро пхучля латар: — Пхэн манди, тумэ ромэґа пала скацик ловэ битиндэ пхув? — Нэ, — пхэнда вой, — пала скацик. ");
INSERT INTO rmyservi_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Пётро пхэнда лати: — Со када тумэ сдэдуманепэ тэ зумавэ Раехкоро Фано? Ту шунэх пасуря паша вудара? Када джян павпалэ кодэла, савэ гаравдэ тирэ ромэ. Вонэ и тут вылиджяна. ");
INSERT INTO rmyservi_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Тай дэ кодыя вряма вой тэлэдэня лэхкэрэ пурэндэ тай выджиля латар води. Тэрнэ мануша заджиле, аракхле ла муляґа, вылиджялдэ тай гаравдэ паша лакоро ром. ");
INSERT INTO rmyservi_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Пэ всавиря кхандиря и кодэлэн, ко шунда пала када, сджиля бари дар. ");
INSERT INTO rmyservi_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Апостолэнгэрэ вастэнца терэнаспэ баро допхэнимо тай дывуря машкар манушэн. Всавэрэ ж сиклярнэ стидэнаспэ їтханэ дэ Соломонохкоро пусын. ");
INSERT INTO rmyservi_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","И аврэ манушэндар даранас лэндэ тэ прыаче, нэ дэ патива вонэ сле всавэрэ манушэндэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","А кодэлэн, ко патялас дэ Рае, ачелас будэр и будэр, муршэн тай джювлен. ");
INSERT INTO rmyservi_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Мануша вылиджянас пэ гаса насвалэн, тховэнас лэн пэ патуря тай пэ париндора, соб шалин Петрохкири тэлэдэлас пэ лэн, кала вов авэла тэ проджя пашэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Тай форонэндар, савэ сле паша Ерусалимо, авэнас фартэ бут манушэн. Вонэ анэнас насвалэн тай кодэлэн, дэ ка бэшэнас нажужэ фануря, и всавэрэ састярэнаспэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Англуно рашай и всавэрэ паша лэ саддукея ханас пэ лэн данда. ");
INSERT INTO rmyservi_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Вонэ пхангле апостолонэн тай бэшардэ лэн дэ форохкэрэ барунэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Нэ ангело Раехкоро отрисарда рятяґа вудара барунэстар тай вылиджялда лэн котарь. ");
INSERT INTO rmyservi_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","— Джян тай ачен дэ храмо, — пхэнда вов, — тай дэдумэн манушэнди вса пала кадэва нэво джювимо. ");
INSERT INTO rmyservi_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Вонэ кандэне лэ, авиле дэнзор дэ храмо тай ачиле тэ сиклярэ. Кала авиле англуно рашай и всавэрэ паша лэ, вонэ акхардэ Синедрионо и всавэрэн Израилёхэкэрэн пхурэдэрэн тай бичалдэ дэ барунэ пала апостолуря. ");
INSERT INTO rmyservi_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Нэ кала бутярнэ авиле дэ барунэ, апостолонэн котэ на сля. Вонэ рисардэпэ и допхэндэ: ");
INSERT INTO rmyservi_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","— Вудара дэ барунэ мишто затердэ, паша лэн ачен халавдэ, нэ кала амэ заджиле пордэ, амэ ника котэ на аракхле. ");
INSERT INTO rmyservi_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Халавдэнгоро пхурэдэр дэ храмо и англунэ рашая вышундэ лэн, тай нико на полиля, со ж када сля. ");
INSERT INTO rmyservi_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Тунчи кось авиля и пхэнда лэнди: — Мануша, савэн тумэ тховдэ дэ барунэ, ачен дэ храмо тай сиклярэн кодэлэн, ко стидэняпэ котэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Тунчи халавдэнгоро пхурэдэр джиля бутярнэнца тай анда апостолонэн. Нэ вонэ на тердэ кода зораґа. Вонэ даранас, со мануша помарэна лэн барэнца. ");
INSERT INTO rmyservi_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Апостолонэн андэ и тховдэ англа Синедрионо. Англуно рашай пхэнда лэнди: ");
INSERT INTO rmyservi_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","— Амэ тумэнди прыпхэндэ, соб тумэ тэ на сиклярэн пала кадэва лав. Нэ тумарэ розлиджян пэхкоро сикляримо пав всаворо Ерусалимо тай чувэн пэ амэн дош дэ мэрима Кадэлэ Манушэхкэрэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Пётро тай авэр апостолуря пхэндэ: — Амэнди трэбуни будэр тэ кандэ Дэвлэ, а на манушэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Дэвэл амарэ дадэнгоро отджювдярда Исусо, Савэ тумэ умардэ тай амблавдэ пэ каштунэ трушулэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Нэ Дэвэл ваздэня Лэ и бэшарда пав чячё васт Пэстар сар Пхурэдэрэ и Фирисаре, соб Израили тэ ачявэл пэхкоро бэзимо, и Дэвэл тэ отмукэл лэхкири дош. ");
INSERT INTO rmyservi_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Допхэнимаря кадэлэсти — амэ тай Свэнто Фано, Савэ Дэвэл дэня кодэлэнди, ко кандэл Лэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Кала кодэла, савэ сле котэ, шундэ када, вонэ ачиле мижэ и камле тэ умарэ апостолонэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Нэ тунчи вщиля екх мануш, саво вджялас дэ Синедрионо. Лэ акхарэнас Гамалиило, вов сля сиклимари пав Упхэнима и дэ патива всавэрэндэ. Вов прыпхэнда тэ вылиджя апостолонэн пэ набут вряма. ");
INSERT INTO rmyservi_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Тунчи вов пхэнда: — Израильтянуря, мишто думисарэн пала кода, со тумэ камэн тэ терэ кадэла манушэнца. ");
INSERT INTO rmyservi_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Надэмут катэ подлиляпэ Февда, вов выдэлас пэ пала савэсь барэ манушэ. Пала лэ джянас пашэ штаршэла манушэн. Нэ кала лэ умардэ, всавэрэ, ко джиле пала лэ, розпрастэнепэ, и вса упалэ ачиля пэ пэхкэрэ тханэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","А пала лэ сля Иуда Галилеятар. Вов авиля дэ кодыя вряма, кала искриисарэнас манушэн, тай улиджялда бутэн пала пэ. Вов кади ж хасиля, тай всавэрэ, ко джиле пала лэ, кади ж розпрастэнепэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Колэсти мэ пхэнав тумэнди екхатар: ачявэн кадэлэн манушэн. Отмукэн лэн. Кала када вса исин манушэндар, тунчи када хасявэла. ");
INSERT INTO rmyservi_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","А сар када Дэвлэстар, тумэ нисо на терэна, кацик еджинэ ачена врыжымашы Дэвлэсти. И лэхкири дума прылиле дэ їлэн кодэла, ко котэ сля. ");
INSERT INTO rmyservi_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Вонэ прыакхардэ апостолонэн и прыпхэндэ лэн тэ марэ чукненца. Тунчи инте екхвар запхэндэ лэнди тэ дэдумэ Исусохкэрэ лавэґа тай отмукле лэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Апостолуря ачявдэ Синедрионо тай лошавэнас колэсти, со лэнди сля дэно тэ прылэ ладжь пала Исусохкоро лав. ");
INSERT INTO rmyservi_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Тай кожно диво дэ храмо тай пав цэрэн вонэ на пэрэаченас тэ сиклярэ и тэ пхэнэ Бахтало Лав пала Исусо Христосо. ");
INSERT INTO rmyservi_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Дэ кадэла дивэ, кала ачиля бут сиклярнэн, эллинистуря холявэнас пэ катутнэн евреен. Вонэ дэдумэнас, со кодэла обджян лэнгэрэн джювлен, савэндэ муле рома, кала роздэн кожно диво хамо. ");
INSERT INTO rmyservi_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Тунчи Дэшудуй акхардэ всавэрэн сиклярнэн тай пхэндэ: — Амэнди нащи тэ ачявэ бути важ лав Дэвлэхкоро, соб тэ лашарэ скаминда. ");
INSERT INTO rmyservi_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Колэсти, пхралалэ, вытидэн пэстар эфта манушэн, савэндэ лачи патив и савэ пхэрдиле Фаноґа тай годяґа, и амэ даґа лэнди тэ терэн кадыя бути. ");
INSERT INTO rmyservi_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Еджинэ амэ аваґа тэ мангэпэ и тэ лиджя бути лавэґа. ");
INSERT INTO rmyservi_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Со вонэ пхэндэ, всавэрэнди чялиля, тай вытидэне Стефано, манушэ, дэ кастэ сля патявимо тай Свэнто Фано, Филиппо, Прохоро, Никаноро, Тимоно, Пармено тай Николае форостар Антиохия, саво прылиля иудеенгоро сикляримо. ");
INSERT INTO rmyservi_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Лэн тховдэ англа апостолонэн, и кодэла поманглепэ пала лэн и возтховдэ пэ лэн васта. ");
INSERT INTO rmyservi_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Лав Дэвлэхкоро розджяласпэ, и дэ Ерусалимо ачиля фартэ бут сиклярнэн, и бут рашая прылиле кадэва патявимо. ");
INSERT INTO rmyservi_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Стефано, мануш, дэ кастэ сле Дэвлэхкэрэ лачимо тай зор, терэлас машкар манушэн барэ дывуря тай допхэнимо. ");
INSERT INTO rmyservi_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Лэґа ачиле тэ розлэпэ койсавэ мануша, ко пхирэнас дэ синагога отмуклэн пэ воля. Пордэ кади ж пхирэнас киренеянуря, александриянуря, тай кодэла, ко джювдэ дэ Киликия тай дэ Цыкни Азия. ");
INSERT INTO rmyservi_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Нэ Стефано дэдумэлас годяґа и зораґа Фаностар, тай вонэ кадэлэґа нисо на ґалёнас тэ терэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Тунчи вонэ поддэдумане койсавэн манушэн тэ пхэнэ: «Амэ шундэ, сар Стефано дэдумэл начячюнэ лава пала Моисее и пала Дэвлэ». ");
INSERT INTO rmyservi_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Вонэ подваздэне манушэн, пхурэдэрэн и сиклимарен пав Упхэнима. Тунчи схутилдэ Стефано и андэ дэ Синедрионо. ");
INSERT INTO rmyservi_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Тай подтховдэ хохавнэн допхэнимарен, савэ пхэндэ: — Кадэва мануш всавири вряма пхэнэл налаче лава пала свэнто храмо и Упхэнимо. ");
INSERT INTO rmyservi_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Амэ шундэ, сар вов дэдуманя, со Исусо Назаретостар розмарэла кадэва храмо и парувэла сикляримо, саво пэрэдэня амэнди Моисеи. ");
INSERT INTO rmyservi_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Всавэрэ кодэла, ко бэшле дэ Синедрионо, чувэнас сама пэ Стефано и дыкхле, со лэхкоро муй исин сар муй ангелостэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Тунчи англуно рашай пхучля Стефаностар: — Када чячимо? ");
INSERT INTO rmyservi_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Стефано пхэнда: — Пхралалэ тай дада! Пошунэн ман! Пативакоро Дэвэл авиля амарэстэ пропапостэ Авраамостэ, кала вов инте джювда дэ Месопотамия — ды кодэлэ, сар вов ачиля тэ джювэ дэ Харрано. ");
INSERT INTO rmyservi_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","«Ачяв кадэва тхан тай пэхкоро родо, — пхэнда лэсти Дэвэл, — тай джя дэ пхув, сави Мэ сикавава тути». ");
INSERT INTO rmyservi_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Авраамо ачявда пхув халдеенгири тай пэрэлагля дэ Харрано. Котарь, сар муля Авраамохкоро дад, Дэвэл пэрэлиджялда Авраамо дэ кодыя пхув, дэ сави тумэ екхатар джювэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Дэвэл на дэня лэсти катэ нисави пхув, и которици пхуякоро на дэня. Нэ Дэвэл пхэнда, со дэла кадыя пхув лэсти тай лэхкэрэ родости, кала Авраамостэ инте на сля чяворэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Дэвэл пхэнэлас лэсти: «Тирэ чявэ на авэна хулая котэ, тев джювэна; вонэ авэна котэ копыля и лиджяна грыжа штаршэл бэрша. ");
INSERT INTO rmyservi_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Нэ Мэ марава кодэлэн манушэн, ко терэла лэн копыленца, — пхэнда Дэвэл, — и тунчи вонэ выджяна котарь тай авэна тэ тэлё Манди пэ кадэва тхан». ");
INSERT INTO rmyservi_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Тунчи Дэвэл дэня Авраамости завето тэ обчинэпэ. Авраамо ачиля дадэґа Исаакости и обчинда лэ пэ охтанго диво. Исаако ачиля дадэґа Иаковости, а Иаково — дэшудуенди патриархонэнди. ");
INSERT INTO rmyservi_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Патриархуля калэ їлэґа дыкхэнас пэ Иосифо и битиндэ лэ дэ Египто. Нэ Дэвэл сля Иосифоґа ");
INSERT INTO rmyservi_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","тай фирисарда лэ всавиря бидатар. Вов дэня Иосифости годи тай терда кади, тэ авэл вов дэ патива фараоностэ, саво сля тхагари дэ Египто. Кодэва терда Иосифо прыбэшлэґа дэ всаворо Египто тай дэ всаворо лэхкоро цэр. ");
INSERT INTO rmyservi_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Тунчи дэ всаворо Египто тай Ханаано ачиля бокх тай сля бари грыжа. Тай амарэ пропапуря нитев на аракхэнас хамо. ");
INSERT INTO rmyservi_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Кала Иаково шунда, со дэ Египто исин ворзо, вов бичалда пордэ амарэн пропапонэн пэрво моло. ");
INSERT INTO rmyservi_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Кала вонэ авиле авэр моло, Иосифо оттердапэ пэхкэрэ пхралэнди, тай фараоно уджянгля пала родо Иосифохкоро. ");
INSERT INTO rmyservi_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Тунчи Иосифо бичалда тэ акхарэ пэхкэрэ дадэ Иаково тай всаворо пэхкоро родо, савэн сля эфтадэша панч манушэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Иаково авиля дэ Египто, тев муля и вов, и амарэ пропапуря. ");
INSERT INTO rmyservi_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Лэнгэрэ трупуля пэрэлиджялдэ дэ Шэхемо и тховдэ дэ склепо, саво Авраамо тинда пала рупь Хаморохкэрэ чявэндэ дэ Шэхемо. ");
INSERT INTO rmyservi_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Кала поджиля пашэ вряма, соб тэ терэлпэ пав лавэ, саво дэня Дэвэл Авраамости, амарэн манушэн дэ Египто ачеласпэ будэр. ");
INSERT INTO rmyservi_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Кади сля ды колэ, сар ваздэняпэ дэ Египто авэр тхагари, саво на джянгля пала Иосифо. ");
INSERT INTO rmyservi_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Вов прытасавэлас амарэн пропапунэн тай хрантимаґа выджялас пэ амарэн манушэн: вов заачявэлас тэ вычувэ чяворэн, савэ бэяндепэ, соб вонэ тэ мэрэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Дэ кадыя вряма бэяндяпэ Моисеи и сля фартэ шукар англа Дэвэл. Трин чён лэ парварэнас дэ дадэхкоро цэр, ");
INSERT INTO rmyservi_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","а кала поджиля вряма тэ ачявэ лэ, Моисее лиля пэстэ фараонохкири чей тай выбарярда лэ, сар пэхкэрэ чявэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Моисеи сля сиклярдо дэ всавири Египтохкири годи; вов сля зорало и дэ лав, и дэ рындонэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Кала лэсти сля саранда бэрш, вов задумисарда тэ дыкхэ, сар джювэн лэхкэрэ пхрала израильтянуря. ");
INSERT INTO rmyservi_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Тунчи вов удыкхля, со екхэ лэндар марэл египтянино. Лэсти ачиля дор кадэлэ манушэ, тай вов умарда египтянино. ");
INSERT INTO rmyservi_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Моисеи думисарэлас, со лэхкэрэ пхрала полэна: чэрэз лэ Дэвэл отмукэл лэн пэ воля, нэ вонэ када на полиле. ");
INSERT INTO rmyservi_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Пэ авэр диво Моисеи удыкхля, сар марэнпэ дуй израильтянуря. Вов камля тэ слиджя лэн, соб тэ на марэнпэ. «Чявалэ, тумэ ж пхрала, — пхэнда вов, — пэ со ж тумэ задэн холи екх екхэсти?» ");
INSERT INTO rmyservi_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Тунчи кодэва, саво марэлас аврэ, отчута пэстар Моисее тай пхэнда: «Ко тховда тут, соб ту тэ авэх пхурэдэрэґа тай сундисарэґа понад амэн? ");
INSERT INTO rmyservi_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Чи ту камэх и ман тэ умарэ, сар арати умардан египтянино?» ");
INSERT INTO rmyservi_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Кала Моисеи шунда кадэла лава, вов нашля тай ачиля тэ джювэ дэ Мадианохкири пхув, сар мануш авря пхувятар. Котэ лэстэ дэ ире бэяндепэ дуй чявэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Проджиля саранда бэрш, тай Моисеести авиля ангело дэ шуки пхув, надур плаестар Синаи, дэ яга, савяґа пхаболас терново рандь. ");
INSERT INTO rmyservi_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Моисеи дэласпэ дыво, кала када дыкхля. Вов поджиля пашэ, соб фэдэр тэ роздыкхэ, и шунда ґласо Раехкоро: ");
INSERT INTO rmyservi_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","«Мэ Дэвэл тирэн пропапонэн, Дэвэл Авраамохкоро, Исаакохкоро тай Иаковохкоро». Моисеи ж тинисявэлас даратар и даралас тэ подыкхэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Рай пхэнда лэсти: «Злэ пэхкэрэ цуруля, колэсти со тхан, пэ саво ту ачех — свэнто пхув. ");
INSERT INTO rmyservi_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Мэ удыкхлём, дэ савэ бибахталима джювэн Мурэ мануша дэ Египто и ушундом лэнгоро ровимо. Мэ сджилём, соб тэ дэ лэнди воля. А кана джя, Мэ бичалав тут дэ Египто». ");
INSERT INTO rmyservi_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Кодэлэ Моисее, ка вонэ отчутэ пэстар тай пала ка дэдумане: «Ко тховда тут, соб ту тэ авэх пхурэдэрэґа тай сундисарэґа понад амэн?» — Дэвэл бичалда кана сар пхурэдэрэ и фирисаре чэрэз ангело, саво сикавдапэ лэсти дэ терново рандь. ");
INSERT INTO rmyservi_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Моисеи вылиджялда лэн Египтостар, терэлас дывуря тай допхэнимо дэ Египто, паша Лоло море и дэ шуки пхув, тев сле вонэ саранда бэрш. ");
INSERT INTO rmyservi_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Кадэва ж Моисеи пхэнда израильтянонэнди: «Тумарэ пхралэндар Дэвэл ваздэла тумэнди Англунаре, сар ман». ");
INSERT INTO rmyservi_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Кала вов їтханэ Израилёхкэрэ манушэнца стидэняпэ дэ шуки пхув, ангело пхэнэлас лэґа тай амарэ пропапунэнца пэ плай Синаи. Тунчи Моисеи прылиля джювдо лав и пэрэдэня лэ амэнди. ");
INSERT INTO rmyservi_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Нэ амарэ дада отпхэндэпэ тэ кандэ лэ, отчутэ лэ тай скамле тэ рисявэ дэ Египто. ");
INSERT INTO rmyservi_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Вонэ пхэндэ Аароности: «Стер амэнди дэвлэн, савэ англа амэн джяна. Колэсти со амэ на джянах, со тердапэ кадэлэ Моисееґа, саво вылиджялда амэн Египтостар». ");
INSERT INTO rmyservi_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Дэ кодэлэ дивэ вонэ тердэ совнакунэ гуруворэ, андэ кадэлэ дэвлорэсти жэртва тай сле лошалэ рындостар, саво тердэ пэхкэрэ вастэнца. ");
INSERT INTO rmyservi_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Дэвэл же отрисардапэ лэндар и ачявда лэн тэ тэлён болыбнахкэрэ чэргэнэнди, сар искриисардо пала када дэ лилэн англунаренгэрэн: «Цэр Израилёхкоро! Чи важ Ман тумэ чинэнас тай анэнас жэртвы дэ шуки пхув, сар саранда бэрш котэ сле? ");
INSERT INTO rmyservi_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Тумэ лиле пэґа дэвлорэ Молохохкири катуна, чэргэнь тумарэ дэвлорэстар Ремфаностар, и кода, со тердэ тумарэ васта, соб кадэлэсти тэ тэлё. Пала кода Мэ бичалава тумэн дэ копылен дурэдэр Вавилоностар». ");
INSERT INTO rmyservi_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Тумарэ дадэндэ дэ шуки пхув сля Катуна Допхэнимахкири, стерди пав прыпхэнимо, саво Дэвэл дэня Моисеести, и пав кодэва рындо, саво дыкхля Моисеи. ");
INSERT INTO rmyservi_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Кала амарэ дада прылиле кадыя Катуна, вонэ тай лэнгоро пхурэдэр Исусо Навиёхкоро влиджялдэ ла дэ пхувен, тев джювдэ манушэнгэрэ родуля, савэн Дэвэл розтрадэня англа лэн. И кади сля ды колэ, кала ачиля тхагареґа Давидо, ");
INSERT INTO rmyservi_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","савэ Дэвэл камэлас и саво мангля Дэвлэстар тэ аракхэ цэр, тев тэлён, важ родо Иаковохкоро. ");
INSERT INTO rmyservi_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Нэ цэр Дэвлэсти стерда Соломоно. ");
INSERT INTO rmyservi_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Барэдэрэхкоро же на джювэл дэ цэрэн, савэ стердэ мануша. Англунари дэдумэл пала када: ");
INSERT INTO rmyservi_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","«Болыбэн — троно Муро, тай пхув исин тхан, тев ачен Мурэ пурэ. Саво тумэ камэн тэ терэ Манди цэр? — пхэнэл Рай. — Тев тхан, соб Манди тэ отцинявэ? ");
INSERT INTO rmyservi_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Чи на Мурэ вастэґа вса откада стердо?» ");
INSERT INTO rmyservi_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Тумэ — накандинэ, тумэ — мануша барунэ їлэнца и кашукэ канэнца! Тумэ, сар тумарэ пропапуря, всавири вряма на уштавэн Свэнтонэ Фаности! ");
INSERT INTO rmyservi_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ка англунарендар на камле тэ вытрадэ тумарэ пропапуря? Вонэ умардэ кодэлэн, ко пхэнэнас пэ англал, со авэла Чячюно. А кана тумэ прэдэне тай умардэ Лэ! ");
INSERT INTO rmyservi_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Тумэ прылиле Упхэнимо, саво пэрэдэне тумэнди ангелуря, нэ на тердэ пав лэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Кала вонэ шундэ када, вонэ мижыле и ачиле тэ стасавэ пэхкэрэ данда. ");
INSERT INTO rmyservi_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Стефано же пхэрдиля Свэнтонэ Фаноґа и ваздэня якха дэ болыбэн, и удыкхля патив Дэвлэхкири тай Исусо, Саво ачелас пав чячи риг Дэвлэстар. ");
INSERT INTO rmyservi_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","— Дыкхэн, — пхэнда вов, — мэ дыкхав оттердо болыбэн и Чявэ Манушыканэ, Саво ачел пав чячё васт Дэвлэстар. ");
INSERT INTO rmyservi_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Тунчи вонэ всавэрэ затердэ пэхкэрэ кана, фартэ типисиле и чутэпэ пэр лэстэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Вонэ выцырдэне Стефано пала форо тай ачиле тэ чувэ дэ лэ бара. Кодэла, ко дыкхле сар лэ дошарэнас, тховдэ пэхкири їда паша пурэн тэрнэ чявэстэ, савэ акхарэнас Савло. ");
INSERT INTO rmyservi_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Кала вонэ чувэнас пэр лэстэ барэнца, Стефано мангляпэ: — Рае Исусо! Прылэ муро фано! ");
INSERT INTO rmyservi_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Тунчи вов тэлэдэня пэ чянгэн и фартэ затиписиля: — Рае, отмук лэнди кадэва бэзимо! Кадэлэ лавэнца вов муля. ");
INSERT INTO rmyservi_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Савло же подэлас ґласо пала кодэлэн, ко умарда Стефано. Кодэлэ дивэстар ачиле фартэ тэ традэ кхандири дэ Ерусалимо. И всавэрэ розпрастэнепэ пав Иудея и Самария, кици апостолуря ачилепэ дэ Ерусалимо. ");
INSERT INTO rmyservi_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Пативалэ мануша гаравдэ Стефано и фартэ ровэнас пала лэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ай Савло традэлас кхандири. Вов захукэлас дэ цэрэн патякунэ манушэндэ, выцырдэлас муршэн тай джювлен тай чувэлас лэн дэ барунэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Машкар колэ мануша, савэн традэнас лэнгэрэ тханэндар, розпхэнэнас Бахтало Лав пав всавэрэ рига. ");
INSERT INTO rmyservi_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Филиппо ж авиля дэ екх форо Самариякоро и розпхэнэлас котэ пала Христосо. ");
INSERT INTO rmyservi_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Гроза манушэн чувэнас сама, кала шунэнас лэхкэрэ лава, тай дыкхэнас допхэнимо, саво вов терэлас. ");
INSERT INTO rmyservi_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Бутэ манушэндар выджянас барэ типимаґа нажужэ фануря, тай бут попхаглэ и лангэ высастярэнаспэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Тай дэ кодэва форо сля бари лош. ");
INSERT INTO rmyservi_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Котэ сля екх мануш, саво акхарэласпэ Симоно. Ды колэ вов врысарэлас дэ кодэва форо, и мануша, ко джювдэ дэ Самария, дэнаспэ дыво кадэлэсти. Вов выдэлас еджино пэ пала савэсь барэ манушэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Всавэрэ мануша, и тэрнэ, и пхурэ, фартэ прышунэнаспэ лэстэ тай пхэнэнас: — Кадэва мануш исин бари зор Дэвлэхкири. ");
INSERT INTO rmyservi_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","А прышунэнаспэ вонэ колэсти, со вов бут вряма сикавэлас дыво пэхкэрэ врысаримаґа. ");
INSERT INTO rmyservi_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Нэ кала мануша патине Филиппости, саво розпхэнэлас пала Дэвлэхкоро Тхагаримо тай лав Исусохкоро Христохкоро, тунчи бут муршэн тай джювлен болдэнепэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Симоно кади ж патиня тай болдэняпэ. Вов всавири вряма пхирэлас пала Филиппо, дыкхэлас баро допхэнимо тай барэ рындуля, и дэласпэ дыво кадэлэсти. ");
INSERT INTO rmyservi_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Кала апостолуря дэ Ерусалимо шундэ, со дэ Самария прылиле Дэвлэхкоро лав, вонэ бичалдэ пордэ Петро тай Иоанно. ");
INSERT INTO rmyservi_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Кодэла авиле тай манглепэ, соб Дэвэл дэня манушэнди Свэнто Фано. ");
INSERT INTO rmyservi_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ни пэ кастэ лэндар Фано инте на сджялас, вонэ кацик болдэнепэ важ Рае Исусохкоро лав. ");
INSERT INTO rmyservi_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Тунчи Пётро тай Иоанно тховдэ пэ лэн васта, тай кадэла мануша прылиле Свэнто Фано. ");
INSERT INTO rmyservi_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Кала Симоно удыкхля, со Свэнто Фано дэлпэ, кала апостолуря тховэн васта пэ манушэн, вов анда лэнди ловэ ");
INSERT INTO rmyservi_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","тай пхэнда: — Дэн и манди кацави зор, соб кодэва, пэ кастэ мэ тховава васта, тэ лэл Свэнто Фано. ");
INSERT INTO rmyservi_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Нэ Пётро пхэнда: — Мэк тиро рупь хасявэла їтханэ туґа, колэсти со ту Дэвлэхкоро даро камлян тэ тинэ пала ловэ! ");
INSERT INTO rmyservi_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ту на вджяґа дэ кадэва рындо, важ кода со тиро їло начячюно англа Дэвлэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Прыджян кадэва бэзимо тай мангпэ Раести, соб Вов тэ отмукэл тути кода, со тутэ исин пэ годя. ");
INSERT INTO rmyservi_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Мэ дыкхав, со дэ тиро їло пхэрдо кэркимо тай со ту спхангло ланчукоґа, саво исин начячимо. ");
INSERT INTO rmyservi_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Симоно пхэнда: — Помангэнпэ пала ман Раести, соб манца тэ на авэл кади, сар тумэ пхэндэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Апостолуря ж допхэнэнас котэ тай розпхэнэнас Раехкоро лав. Тунчи вонэ джиле павпалэ дэ Ерусалимо и пав дром розпхэнэнас Бахтало Лав дэ бутэн гавэн дэ Самария. ");
INSERT INTO rmyservi_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ангело Раехкоро пхэнда Филиппости: — Джя пэ юго, пэ дром, саво проджял пав шуки пхув Ерусалимостар дэ Газа. ");
INSERT INTO rmyservi_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Филиппо вщиля тай джиля. Дэ кадыя вряма котэ сля ефиопско мануш. Вов терэлас бути прыбэшлэґа тхагарнятэ дэ Ефиопия, Кандакиятэ, тай прыдыкхэлас пала всаворо лакоро барвалимо. Вов авэлас дэ Ерусалимо тэ тэлё Дэвлэсти, ");
INSERT INTO rmyservi_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","и кана рисявэлас цэрэ. Кала кадэва мануш бэшэлас дэ пэхкоро вурдон тай динэлас лил, саво искриисарда англунари Исаия. ");
INSERT INTO rmyservi_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Фано пхэнда Филиппости: — Поджя кадэлэ вурдонэстэ и джя пашэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Филиппо подпрастэня вурдонэстэ тай шунда, со котэ динэлпэ лил, саво искриисарда англунари Исаия. — Ту полэх, со ту динэх? — пхучля Филиппо. ");
INSERT INTO rmyservi_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","— Сар же мэ полава, кала манди нико на розпхэнэл, — пхэнда кодэва мануш тай акхарда Филиппо, соб вов тэ подваздэлпэ и тэ бэшэл лэґа дэ вурдонэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ай вов динэлас кацаво тхан Лилэндар: «Сар бакрорэ, лиджялдэ Лэ, соб тэ чинэ, и, сар бакроро на ваздэл пэхкоро ґласо англа кодэлэ, ко злэл лэстар бал, кади ж и Вов ушта Пэхкэрэ на оттерэлас. ");
INSERT INTO rmyservi_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Вов сля ладжьвардо и на домукло чячюнэ сындостэ. Ко розпхэнэла пала Лэхкоро родо? Колэсти со джювимо Лэхкоро пхуятар залэлпэ». ");
INSERT INTO rmyservi_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ефиопско мануш пхучля Филиппо: — Мангав тут, пхэн манди, пала ка дэдумэл катэ англунари? Пала пэ чи пала кась аврэ? ");
INSERT INTO rmyservi_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Тунчи Филиппо ачиля тэ розпхэнэ кадэлэ тханэстар Бахтало Лав пала Исусо. ");
INSERT INTO rmyservi_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Вонэ ладэнас дурэдэр пав дром тай подлагле пашэ панестэ. — Дыкх, акэ исин пани, — пхэнда ефиопско мануш. — Со на дэл манди тэ болдэпэ? ");
INSERT INTO rmyservi_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Вов прыпхэнда, соб тэ тэрдёл вурдон, и дуйджинэ вонэ, ефиопско мануш тай Филиппо, заджиле дэ пани. И Филиппо болдэня лэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","А кала вонэ выджиле панестар, Фано Раехкоро улиджялда Филиппо, тай ефиопско мануш будэр лэ на дыкхля. Баря лошаґа вов лагля дурэдэр. ");
INSERT INTO rmyservi_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ай Филиппо попэля дэ форо Ашдодо. Вов розпхэнэлас Бахтало Лав пав всавэрэн форонэн, а тунчи авиля дэ Кесария. ");
INSERT INTO rmyservi_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Савло жэ пхурдэлас холяґа и мэримаґа пэ Раехкэрэн сиклярнэн. Вов авиля англунэ рашаестэ ");
INSERT INTO rmyservi_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","и мангля лэстар лила дэ синагоги, савэ сле дэ Дамаско, соб вов, кала аракхэла кодэлэн, ко прырицарэлпэ Дромэстэ, муршэн тай джювлен, тэ спхандэл лэн тай тэ анэл дэ Ерусалимо. ");
INSERT INTO rmyservi_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Кала вов поджялас дэ Дамаско, пэр лэстэ сджиля душлимо болыбнастар. ");
INSERT INTO rmyservi_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Вов тэлэдэня пэ пхув и ушунда ґласо, саво пхэнда лэсти: — Савло, Савло, сости ту традэх Ман? ");
INSERT INTO rmyservi_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","— Ко Ту, Рае? — пхучля Савло. — Мэ Исусо, Савэ ту традэх, — пхэнда Вов. ");
INSERT INTO rmyservi_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","— Вщи тай джя дэ форо. Котэ тути пхэнэна, со трэбуни тэ терэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Мурша, савэ сле Савлоґа дэ дром, ачиле сар мутуля: вонэ шундэ ґласо, нэ ника на дыкхле. ");
INSERT INTO rmyservi_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Савло вщиля пхуятар, нэ кала вов оттерда якха, тунчи полиля, со корыля, и лэ пала васт андэ дэ Дамаско. ");
INSERT INTO rmyservi_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Трин дивэ вов на халас и на пэлас, и сля коро. ");
INSERT INTO rmyservi_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Дэ Дамаско джювда сиклярно, савэ акхарэнас Анания. Рай пхэнда лэсти дэ дыкхлима: — Анания! — Кади, Рае! — пхэнда вов. ");
INSERT INTO rmyservi_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Рай дэдуманя лэсти: — Джя пэ гаса, сави акхарэлпэ «Вортаґа», аракх котэ Иудахкоро цэр, и пхуч Савло, саво акхарэлпэ «Тарсянино». Вов екхатар мангэлпэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","И дэ лэхкэрэ дыкхлима мануш пав лавэ Анания авиля и тховда пэр лэстэ васта, соб вов тэ на авэл коро. ");
INSERT INTO rmyservi_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Анания пхэнда: — Рае, мэ бутэ манушэндар шундом пала лэ, саво вурытимо вов терда Тирэ свэнтонэнди дэ Ерусалимо. ");
INSERT INTO rmyservi_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","И лэстэ катэ исин бари зор англунэ рашаендар тэ пхандэ всавэрэн, ко прыакхарэл Тиро Лав. ");
INSERT INTO rmyservi_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Нэ Рай пхэнда лэсти: — Джя, колэсти со кадэва мануш — вытидэно Манца, соб тэ розпхэнэ пала Муро Лав англа наиудеен, англа тхагарен тай англа Израилёхкэрэн манушэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Мэ сикавава лэсти, сави бари грыжа вов прылэла пала Муро лав. ");
INSERT INTO rmyservi_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Анания джиля, заджиля дэ кодэва цэр, тховда пэ Савло васта тай пхэнда: — Пхрал Савло, Рай Исусо, Саво сикавдапэ пэ тиро дром, бичалда ман тутэ, соб ту упалэ тэ дыкхэх и тэ пхэрдёх Свэнтонэ Фаноґа. ");
INSERT INTO rmyservi_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Дэ кодыя вряма калимо уджиля лэхкэрэ якхэндар, и вов ачиля тэ дыкхэ. Савло вщиля тай болдэняпэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","А тунчи вов халя, и лэстэ рисардапэ зор. Савло сля набут дивэн сиклярнэнца дэ Дамаско ");
INSERT INTO rmyservi_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","тай сиго ачиля тэ пхэнэ дэ синагоги пала кода, со Исусо исин Дэвлэхкоро Чяво. ");
INSERT INTO rmyservi_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Всавэрэ, ко лэ шундэ, дэнаспэ дыво тай пхэнэнас: — Чи када на вов, ко умарэлас манушэн Ерусалимостар, савэ прыакхарэнас кадэва лав? И чи на авиля вов кордэ, соб тэ пхандэ лэн и тэ лиджя англунэ рашаендэ? ");
INSERT INTO rmyservi_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Савло же инте зоралэдэр пхэнэлас тай допхэнэлас, со Исусо исин Христосо. Тай иудея, савэ джювэнас дэ Дамаско, на джянгле, со лэсти тэ пхэнэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Кала проджиля бут дивэн, иудея стидэне дума, соб тэ умарэ Савло. ");
INSERT INTO rmyservi_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Нэ Савло уджянгля пала кода. Иудея диво и рят дожутярэнас паша вударэн дэ форо, соб тэ умарэ лэ, ");
INSERT INTO rmyservi_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","нэ сиклярнэ рятяґа лиле тай обмукле лэ дэ бари траста пав форицико ванта. ");
INSERT INTO rmyservi_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Савло авиля дэ Ерусалимо и камля тэ прыаче сиклярнэндэ, нэ всавэрэ даранас лэстар и на патянас, со вов кади ж ачиля сиклярнэґа. ");
INSERT INTO rmyservi_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Тунчи Варнава анда лэ апостолонэндэ тай розпхэнда, сар Савло пэ дром дыкхля Рае, сар Рай дэдумэлас лэґа, и сар дэ Дамаско Савло бидаракоро пхэнэлас важ Исусохкоро лав. ");
INSERT INTO rmyservi_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Савло сля лэнца койсави вряма, пхирэлас пав Ерусалимо и битрашакоро пхэнэлас пала Раехкоро лав. ");
INSERT INTO rmyservi_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Вов бут молы дыкхэласпэ эллинистонэнца, розпхэнэлас тай допхэнэлас лэнди, и кодэла терэнас вса, соб лэ тэ умарэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Кала пхрала уджянгле пала када, вонэ отлиджялдэ Савло дэ Кесария, а котарь отбичалдэ лэ дэ Тарсо. ");
INSERT INTO rmyservi_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","А манушэн кхандирятар пав всавири Иудея, Галилея тай Самария будэр нико на традэлас. Кхандири прылэлас зор тай барёлас, джювда дараґа англа Рае, тай Свэнто Фано подрицарэлас ла. ");
INSERT INTO rmyservi_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Кала Пётро джялас форо форостэ, вов авиля свэнтонэндэ, савэ джювдэ дэ Лидда. ");
INSERT INTO rmyservi_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Котэ вов удыкхля екхэ манушэ, савэ акхарэнас Энеи, вов сля насвало, попхагло мануш и пашлёлас пэ пато охта бэрш. ");
INSERT INTO rmyservi_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Пётро пхэнда лэсти: — Энеи! Исусо Христосо састярэл тут. Вщи тай стидэ тиро тхан. Дэ кодыя ж вряма Энеи вщиля. ");
INSERT INTO rmyservi_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Кала всавэрэ мануша, савэ джювдэ дэ Лидда тай Шароно, удыкхле, со вов састярдяпэ, вонэ обрисиле Раестэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Дэ Яффа сля екх сиклярни, савя акхарэнас Тавита, ай пав аврэ «Бузнори». Вой всавири вряма терэлас лаче рындуря и подрицарэлас чёрорэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Тай акэ, дэ кодыя вряма вой занасвалиля тай муля. Лакоро трупо обхалавдэ и тховдэ дэ упралуни цэра. ");
INSERT INTO rmyservi_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Важ кода со Лидда надур Яффатар, кала сиклярнэ шундэ, со Пётро исин котэ, вонэ бичалдэ лэстэ дон манушэн, соб кодэла мангле лэ: — Ав амэндэ сигэдэр! ");
INSERT INTO rmyservi_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Пётро джиля лэнца, и кала вов авиля, лэ пролиджялдэ дэ упралуни цэра. Паша лэ стидэнепэ всавэрэ джювля, савэндэ муле рома. Вонэ ровэнас тай сикавэнас лэсти гада тай авэр їда, савэ сювда Бузнори, кала сля джювди. ");
INSERT INTO rmyservi_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Пётро выбичалда всавэрэн цэратар, вщиля пэ чянгэн тай помангляпэ. Тунчи вов обрисардапэ мулятэ тай пхэнда: — Тавита, вщи! Вой оттерда якха, удыкхля Петро тай бэшля. ");
INSERT INTO rmyservi_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Вов лиля ла пала вастэ и подрицарда, соб вой тэ вщел. Тунчи вов акхарда джювлен и патякунэн, и сикавда лэнди, со Тавита джювди. ");
INSERT INTO rmyservi_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Пала када уджянгле пав всавири Яффа, и бут манушэн патине Раести. ");
INSERT INTO rmyservi_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Пётро сля дэ Яффа инте бут дивэн, вов джювда Симоностэ, саво вытерэлас морця. ");
INSERT INTO rmyservi_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Дэ Кесария сля мануш, савэ акхарэнас Корнилии, шэлякоро пхурэдэр, халавдэнгэрэ Италиякэрэ стидэмастар. ");
INSERT INTO rmyservi_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Корнилии, сар и всавэрэ лэхкэрэ цэрунэ, сля пативалэ манушэґа тай даралас Дэвлэстар, роздэлас чёрорэнди пэхкэрэ хулаимастар и всавири вряма мангляпэ Дэвлэсти. ");
INSERT INTO rmyservi_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Екхвар, паша трин чясуря дэ дивэ, Корнилиести сля дыкхлимо. Вов мишто дыкхля Дэвлэхкэрэ ангело, саво авиля лэстэ тай пхэнда: — Корнилии! ");
INSERT INTO rmyservi_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Вов подыкхля пэр лэстэ дараґа тай пхэнда: — Со, рае? Ангело пхэнда: — Дэвэл срапирда пала тут. Тиро мангимо и лачимо, саво ту терэх манушэнди, ваздэнепэ Лэстэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Бичал манушэн дэ Яффа, соб вонэ акхарэн Симоно, савэ инте акхарэн Петроґа. ");
INSERT INTO rmyservi_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Вов джювэл Симоностэ, саво вытерэл морця, дэ цэр паша море. ");
INSERT INTO rmyservi_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Кала ангело, савэґа вов дэдуманя, уджиля, Корнилии акхарда дон пэхкэрэн копылен тай пативалэ халавдэ, саво терэлас важ лэсти бути. ");
INSERT INTO rmyservi_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Вов розпхэнда лэнди пала вса, со тердапэ, и бичалда лэн дэ Яффа. ");
INSERT INTO rmyservi_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Пэ авэр диво, кала бичалдэ поджянас форостэ, паша дэшудуй чясуря, Пётро ваздэняпэ пэ цэрэхкири стрэха, соб тэ помангэпэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Вов ачиля бокхало и фартэ закамля тэ ха. Кала тавэнас хамо, Петрости сля дыкхлимо. ");
INSERT INTO rmyservi_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Вов дыкхля оттердо болыбэн и кода, со сля поджило пэ бари цэрга, сави обмукэласпэ пэ пхув пала штар рига. ");
INSERT INTO rmyservi_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Дэ кадыя цэрга сля всаворо штарэпурэнгоро ското, сапа тай болыбнахкэрэ чирикля. ");
INSERT INTO rmyservi_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Тунчи роздэняпэ ґласо тай пхэнда лэсти: — Пётро, вщи, чин и ха! ");
INSERT INTO rmyservi_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","— Нат, Рае! — пхэнда Пётро. — Мэ никала на халём кода, со исин маґрисардо тай нажужо. ");
INSERT INTO rmyservi_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Тунчи ґласо пхэнда лэсти авэр моло: — На акхар маґрисардэґа кода, со Дэвэл жужарда. ");
INSERT INTO rmyservi_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Кади сля тривар, и тунчи цэрга сля подлити дэ болыбэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Пётро вса на полэлас, со када за дыкхлимо, кала мануша, савэн бичалда Корнилии, розпхучле, тев исин Симонохкоро цэр, поджиле тай ачиле паша вударэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Вонэ ачиле тэ пхуче, чи на джювэл катэ екхатар Симоно, савэ инте акхарэн Пётро. ");
INSERT INTO rmyservi_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Пётро инте думисарэлас пала дыкхлимо, кала Фано пхэнда лэсти: — Тут родэн трин мануша. ");
INSERT INTO rmyservi_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Вщи тай змукпэ тэлэ. Джя лэнца тай на думисар ни пала со. Колэсти со када Мэ лэн бичалдом. ");
INSERT INTO rmyservi_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Пётро змукляпэ тэлэ тай пхэнда кадэлэ манушэнди: — Мэ кодэва, ка тумэ родэн. Пав саво рындо тумэ авиле? ");
INSERT INTO rmyservi_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Вонэ пхэндэ: — Шэлякоро пхурэдэр Корнилии, мануш пативало, саво дарал Дэвлэстар, и пэ савэ тховэл патив родо иудеенгоро, прылиля свэнтонэ ангелостар лав тэ акхарэ тут дэ пэхкоро цэр тай тэ вышунэ, со ту лэсти пхэнэґа. ");
INSERT INTO rmyservi_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Тунчи Пётро акхарда лэн тэ заджя дэ цэр тай стховда лэнди патив. Пэ авэр диво Пётро и койсавэ пхрала Яффатар джиле лэнца. ");
INSERT INTO rmyservi_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Пэ авэр диво вонэ авиле дэ Кесария. Корнилии дожутярэлас лэн. Вов акхарда всаворо пэхкоро родо тай пашунэн амалэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Кала Пётро авиля, Корнилии выджиля лэстэ, тэлэдэня лэхкэрэ пурэндэ тай тэлиля лэсти. ");
INSERT INTO rmyservi_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Нэ Пётро подлиля лэ тай пхэнда: — Вщи, мэ кацаво ж мануш, сар и ту. ");
INSERT INTO rmyservi_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Кала Пётро инте дэдуманя Корнилиеґа, вов заджиля дэ цэр тай дыкхля, со котэ стидэняпэ бут манушэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Тай пхэнда лэнди: — Тумэ еджинэ джянэн, со иудеести нащи тэ авэ амалэґа наиудеенгэрэ манушэґа тай тэ заджя лэстэ дэ цэр. Нэ Дэвэл сикавда манди: нащи тэ дэдумэ ни пала савэ манушэ, со вов маґрисардо чи нажужо. ");
INSERT INTO rmyservi_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Колэсти, кала пала ман авиле, мэ джилём и нисо на пхэнавас. Кана мэ камав тумэндар тэ пхуче: пэ со тумэ бичалдэ пала ман? ");
INSERT INTO rmyservi_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Корнилии пхэнда: — Штар дивэ павпалэ, дэ кадыя вряма, паша трин чясуря дэ дивэ, мэ манглёмпэ дэ пэхкоро цэр. Тай англа ман ачиля мануш дэ їда, сави сар яг пхаболас. ");
INSERT INTO rmyservi_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","«Корнилии, — пхэнда вов, — тиро мангимо ушундо, тай лачимо, саво ту терэх, срапирда Дэвэл. ");
INSERT INTO rmyservi_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Бичал манушэн дэ Яффа пала Симоно, савэ инте акхарэн Пётро. Вов екхатар джювэл дэ цэр паша море, Симоностэ, саво вытерэл морця». ");
INSERT INTO rmyservi_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Мэ сиго бичалдом пала тут, тай ту мишто тердан, со авилян. Екхатар амэ всавэрэ катэ, англа Дэвлэ, и камах тэ шунэ кода, со Рай прыпхэнда тути тэ пхэнэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Пётро ачиля тэ дэдумэ: — Кана мэ полав, со Дэвэл на дыкхэл пэ муй манушэхкоро, ");
INSERT INTO rmyservi_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","нэ дэ всавэрэн манушэнгэрэн родонэн Лэсти чялёл кодэва, ко дарал Лэстар и терэл чячимо! ");
INSERT INTO rmyservi_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Вов бичалда Израилёхкэрэ родости Бахтало Лав пала кода, со Исусо Христосо, Саво исин Рай всавэрэ манушэндэ, слиджял амэн Дэвлэґа. ");
INSERT INTO rmyservi_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Тумэ джянэн пала кода, со тердапэ пав всавири Иудея, майанглал Галилеятар и пала кодэлэ, сар Иоанно прыакхарэлас манушэн тэ болдэпэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Дэвэл помакхля Свэнтонэ Фаноґа тай зораґа Исусо Назаретостар тай Вов пхирэлас, терэлас лаче рындуря и састярэлас всавэрэн, ко сля дэ копылен барэ бэнгэстэ, колэсти со Лэґа сля Дэвэл. ");
INSERT INTO rmyservi_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Амэ — допхэнимаря пала кода, со терэлас Исусо дэ иудеенгири пхув тай дэ Ерусалимо. Лэ амблавдэ пэ каштунэ трушулэ тай умардэ, ");
INSERT INTO rmyservi_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","нэ Дэвэл пэ трито диво отджювдярда Лэ и дэня, соб Вов тэ сикавэлпэ манушэнди, — ");
INSERT INTO rmyservi_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","на всавэрэнди, нэ амэнди, допхэнимаренди, ка майанглал вытидэня Дэвэл. Тай амэ хале и пиле Лэґа пала колэ, сар Вов отджювдиня мулэндар. ");
INSERT INTO rmyservi_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Вов прыпхэнда, соб амэ тэ розпхэнах манушэнди тай тэ авах допхэнимаря, со Вов исин Кодэва, Ка вытидэня Дэвэл тэ сундисарэ джювдэн тай мулэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Пала Лэ допхэнэн всавэрэ англунаря, кала дэдумэн, со кожно мануш, саво патял дэ Лэ, фирисарэлапэ бэзимастар важ Лэхкоро лав. ");
INSERT INTO rmyservi_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Кала Пётро инте дэдумэлас пала кода, пэ всавэрэн, ко шунда лэхкэрэ лава, сджиля Свэнто Фано. ");
INSERT INTO rmyservi_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Патякунэ иудея, савэ авиле Петроґа, дэнаспэ дыво, со Дэвэл бичалда Свэнто Фано дэ даро кади ж и наиудеенди, ");
INSERT INTO rmyservi_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","колэсти со вонэ шундэ, сар кодэла дэдумэнас пэ аврэн чибэн и ашарэнас Дэвлэ. Тунчи Пётро пхэнда: ");
INSERT INTO rmyservi_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","— Ко на дэла тэ болдэпэ панеґа кадэлэ манушэнди, савэ прылиле Свэнто Фано кади ж, сар и амэ? ");
INSERT INTO rmyservi_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","И вов прыпхэнда лэнди тэ болдэнпэ важ Исусохкоро Христохкоро лав. Тунчи хулая мангле Петро, соб тэ ачелпэ лэнца пэ набут дивэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Апостолуря тай пхрала, савэ джювдэ дэ Иудея, шундэ, со кади ж и наиудея прылиле Дэвлэхкоро лав. ");
INSERT INTO rmyservi_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Колэсти, кала Пётро авиля дэ Ерусалимо, патякунэ иудея ачиле тэ выпхэнэ лэсти: ");
INSERT INTO rmyservi_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","— Ту пхирдан наобчиндэ манушэндэ и халян лэнца, — пхэнэнас вонэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Тунчи Пётро ачиля тэ розпхэнэ лэнди вса, со сля майанглал и пала кодэлэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","— Мэ слём дэ форо Яффа тай манглёмпэ, — пхэнда вов, — и дэ кадыя вряма мандэ сля дыкхлимо: кода, со сля поджило пэ бари цэрга, сави пала штар рига обмукэласпэ болыбнастар ворта пордэ, тев мэ слём. ");
INSERT INTO rmyservi_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Мэ подыкхлём андрал тай удыкхлём штарэпурэнгоро ското, сапэн тай болыбнахкэрэн чириклен. ");
INSERT INTO rmyservi_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Тунчи мэ шундом ґласо, саво дэдумэлас манди: «Пётро, вщи, чин тай ха!» ");
INSERT INTO rmyservi_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Мэ пхэндом: «Нат, Рае! Ни пала со! Мэ никала на халём кода, со исин маґрисардо тай нажужо». ");
INSERT INTO rmyservi_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Гласо болыбнастар пхэнда манди авэр моло: «На акхар маґрисардэґа кода, со Дэвэл жужарда». ");
INSERT INTO rmyservi_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Кади сля тривар, и тунчи цэрга сля подлити дэ болыбэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Дэ кодыя ж вряма паша цэр, дэ саво мэ слём, пашыле трин мануша, бичалдэ мандэ Кесариятар. ");
INSERT INTO rmyservi_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Фано прыпхэнда манди тэ джяв лэнца и тэ на розпхучяв ни пала со. Акэ кадэла шов пхрала кади ж джиле манца, тай амэ авиле дэ цэр кодэлэстэ, ко ман акхарда. ");
INSERT INTO rmyservi_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Вов розпхэнда амэнди пала кода, сар дыкхля пэстэ ангело. Ангело пхэнда лэсти: «Бичал манушэн дэ Яффа пала Симоно, савэ инте акхарэн Пётро, ");
INSERT INTO rmyservi_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","и вов розпхэнэла, сар тэ фирисарэпэ тути и всавэрэ тирэ цэрэсти». ");
INSERT INTO rmyservi_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Кала мэ ачилём тэ дэдумэ, пэ лэндэ сджиля Свэнто Фано, кади, сар Вов сджиля англэ и пэ амэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Тунчи мэ срапердом лава Раехкэрэ: «Иоанно болдэня панеґа, а тумэ авэна болдэ Свэнтонэ Фаноґа». ");
INSERT INTO rmyservi_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Колэсти, кала Дэвэл дэня лэнди кацаво даро, сар и амэнди, савэ патине Раести Исусости Христости, ко ж мэ кацаво, соб тэ запхэнэ Дэвлэсти? ");
INSERT INTO rmyservi_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Кала вонэ вышундэ када, тунчи пэрэачиле тэ розпхуче тай ваздэне патив Дэвлэсти. Тай дэдумэнас: — Выджял кади, со Дэвэл дэня и наиудеенди тэ уджян бэзимастар тай тэ лэн джювимо! ");
INSERT INTO rmyservi_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Патякунэ, савэ розджилепэ, кала лэн ачиле тэ традэ пала кодэлэ, сар муля Стефано, проджиле Финикия, Кипро тай Антиохия, нэ розпхэнэнас Лав кацик иудеенди. ");
INSERT INTO rmyservi_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Нэ койсавэ лэндар, савэ сле Кипростар тай дэ Киренеятар, авиле дэ Антиохия тай ачиле тэ розпхэнэ Бахтало Лав пала Рае Исусо эллинистонэнди. ");
INSERT INTO rmyservi_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Раехкоро васт сля лэнца, и бут манушэн патине тай обрисардэпэ Раестэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Дума пала кода доджиля кхандирятэ дэ Ерусалимо. Котарь бичалдэ дэ Антиохия Варнава. ");
INSERT INTO rmyservi_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Кала Варнава авиля тай удыкхля Дэвлэхкоро мищимо, вов лошыля тай умангэлас всавэрэн, соб тэ аченпэ дэ патявима Раести. ");
INSERT INTO rmyservi_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Варнава сля лачё мануш, пхэрдо Свэнтонэ Фаноґа тай патявимаґа. Тай фартэ бут манушэн ачиле тэ патя Раести. ");
INSERT INTO rmyservi_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Тунчи Варнава джиля дэ Тарсо, соб тэ аракхэ котэ Савло. ");
INSERT INTO rmyservi_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","И кала аракхля лэ, тунчи анда дэ Антиохия. Састо бэрш вонэ аченаспэ дэ антиохийско кхандири тай сиклярэнас бутэн манушэн. Дэ Антиохия сиклярнэн дэ перво моло ачиле тэ акхарэ «христиануря». ");
INSERT INTO rmyservi_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Дэ кадыя вряма Ерусалимостар дэ Антиохия авиле койсавэ англунаря. ");
INSERT INTO rmyservi_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Екх лэндар, савэ акхарэнас Агаво, вщиля тай Фаноґа пропхэнда, со пав всавири пхув авэла бари бокх. Кади и тердапэ, кала Клавдии сля императоро. ");
INSERT INTO rmyservi_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Колэсти сиклярнэ допхэндэпэ, со кожно лэндар дэла пэхкэрэ хулаимастар скици исин, тэ подрицарэ пхралэн дэ Иудея. ");
INSERT INTO rmyservi_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Кади вонэ и тердэ. Тай бичалдэ Варнава тай Савло тэ отлиджя ловэ, савэ вонэ стидэне, и тэ отдэ лэн пхурэдэрэнди. ");
INSERT INTO rmyservi_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Тевсь дэ кадыя вряма тхагари Иродо спхангля койсавэн манушэн кхандирятар, соб тэ терэ лэнди бибахт. ");
INSERT INTO rmyservi_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Вов прыпхэнда тэ умарэ чюряґа Иоаннохкэрэ пхралэ, Иаково. ");
INSERT INTO rmyservi_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Кала вов удыкхля, со када чялиля иудеенди, тунчи прыпхэнда тэ пхандэ и Петро. Када сля пэ сырботори, саво акхарэлпэ Биквасно мандро. ");
INSERT INTO rmyservi_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Петро пхангле, чутэ дэ барунэ и тховдэ дэшушов халавдэн, по штар мануша дэ череда. Иродо камля тэ вылиджя Петро манушэндэ, кала проджяла Патради. ");
INSERT INTO rmyservi_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Петро сля дэ барунэ, а кхандири фартэ мангляпэ пала лэ Дэвлэсти. ");
INSERT INTO rmyservi_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Рятяґа, англа колэ, сар Иродо камля тэ вылиджя лэ пэ сындо, Пётро совэлас машкар дон халавдэн тай сля спхангло донца ланчугонэнца, а халавдэ паша вударэн прыдыкхэнас пала барунэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Тай акэ, авиля ангело Раехкоро, тай дэ барунэ запхабиляпэ душлимо. Ангело малавда Петро дэ рига тай джюнгавда лэ. — Вщи сигэдэр! — пхэнда вов, тай ланчугуря тэлэдэне Петрохкэрэ вастэндар. ");
INSERT INTO rmyservi_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Тунчи ангело пхэнда: — Подпхандэпэ кущикаґа тай уряв цыруля. Пётро терда када. — Уряв упралуни їда и джя пала ман, — пхэнда ангело. ");
INSERT INTO rmyservi_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Пётро выджиля пала ангело барунэстар тай на полэлас, со ангело терэл вса пав чячима. Вов думисарэлас, со када дыкхлимо. ");
INSERT INTO rmyservi_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Вонэ проджиле англунэн халавдэн, тунчи — аврэн тай поджиле саструнэ вударэндэ, савэндар выджянас дэ форо. Вудара еджинэ оттердэпэ англа лэн, тай вонэ выджиле. Вонэ проджиле екх гаса, тай акэ, ангело уджиля. ");
INSERT INTO rmyservi_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Кала Пётро авиля дэ пэстэ, вов пхэнда: — Кана мэ чяче джянав, со Рай бичалда пэхкэрэ ангело и фирисарда ман Иродохкорэ вастэстар и кодэлэ бибахталимастар, саво камле тэ терэ манди иудеенгерэ мануша. ");
INSERT INTO rmyservi_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Кала Пётро полиля, со тердапэ, вов джиля цэрэстэ, тев джювда Мария, дэй Иоаннохкири, савэ инте акхарэнас Марко. Котэ бут манушэн стидэнепэ тэ мангэпэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Пётро помарда дэ вударэн, тай лэстэ выджиля бутярни, савя акхарэнас Роза. ");
INSERT INTO rmyservi_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Вой уджянгля Петро пав ґласо тай лошатар бистарда тэ оттерэ вудара. Тунчи вой прастэня павпалэ, соб тэ пхэнэ, со Пётро ачел паша вударэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","— Ту на дэ пэхкиря годя! — пхэндэ лати. Нэ вой на пэрэачелас лэнди тэ допхэнэ. — Када лэхкоро ангело! — дэдумане вонэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Пётро вса ж марэлас дэ вударэн, и кала вонэ оттердэ вудара и удыкхле лэ, тунчи дэнепэ дыво. ");
INSERT INTO rmyservi_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Пётро сикавда лэнди вастэґа, соб вонэ тэ заачен мулком, тай розпхэнда, сар Рай вылиджялда лэ барунэстар. — Розпхэнэн пала кода Иаковости и аврэ пхралэнди, — дэдуманя вов лэнди тай уджиля котарь дэ авэр тхан. ");
INSERT INTO rmyservi_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Дэнзор халавдэ ачиле тэ прастэ пордэ котарь, и нико на джянгля, со тердапэ Петроґа. ");
INSERT INTO rmyservi_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Иродо родэлас лэ тай на аракхля, колэсти допхучля халавдэн тай прэдэня лэн мэримасти. Тунчи Иродо лагля Иудеятар дэ Кесария тай ачеласпэ котэ набут вряма. ");
INSERT INTO rmyservi_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Иродо ж фартэ мижыля пэ манушэн, савэ джювдэ дэ Тиро тай Сидоно. Кодэла ж допхэндэпэ машкар пэстэ, авиле Иродостэ тай помангле Бласто, саво прыдыкхэлас пала тхагарехкири цэра, соб вов тэ подрицарэл лэн. Тунчи мангле тхагаре, соб тэ на рицарэл холи пэ лэн, колэсти со лэнгири пхув парварэласпэ тхагарехкиря пхуятар. ");
INSERT INTO rmyservi_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Дэ екх диво, саво вов вытидэня, Иродо урявда тхагаримахкири їда, бэшля пэ сундисарехкоро тхан и ачиля тэ дэдумэ манушэндэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Мануша затиписиле: — Када ґласо дэвликуно, а на манушыкано! ");
INSERT INTO rmyservi_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Нэ дэ кодыя ж вряма ангело Раехкоро малавда Иродо, колэсти со вов на ваздэня лашаримо Дэвлэсти, тай цэрмэ захале лэ, и вов муля. ");
INSERT INTO rmyservi_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Лав Дэвлэхкоро розджяласпэ дурэдэр тай дурэдэр. ");
INSERT INTO rmyservi_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Варнава ж тай Савло стердэ пэхкоро рындо тай рисиле дэ Ерусалимо. Пэґа вонэ лиле Иоанно, савэ инте акхарэнас Марко. ");
INSERT INTO rmyservi_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Дэ антиохийско кхандири сле англунаря тай сикляримаря: Варнава, Симеоно, савэ инте акхарэнас «Нигеро», киренеянино Луции, Манаино, саво бариля їтханэ тетрархоґа Иродоґа, тай Савло. ");
INSERT INTO rmyservi_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Екхвар, кала вонэ тэлёнас Раести и рицарэнас посто, Свэнто Фано пхэнда: — Оттховэн Манди Варнава тай Савло важ рындо, ды савэ Мэ лэн прыакхардом. ");
INSERT INTO rmyservi_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Тай вонэ, кала проджиле посто и мангимо, тховдэ пэ лэн васта и отмукле лэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Кадэла дуй, савэ сле бичалдэ Свэнтонэ Фаноґа, джиле дэ Селевкия, а котарь лагле пав пане пэ Кипро. ");
INSERT INTO rmyservi_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Вонэ авиле дэ Саламино и котэ пхэнэнас Дэвлэхкоро лав дэ иудеенгерэ синагоги. Иоанно сля лэнца тай дэлас лэнди зор. ");
INSERT INTO rmyservi_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Вонэ облагле всаворо острово тай авиле дэ Пафосо. Котэ вонэ удыкхле екхэ иудее, пав лавэ Вар-Исусо, саво сля джянимари тай хохавно англунари. ");
INSERT INTO rmyservi_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Вов сля пашэ римско проконсуло пав лавэ Сергии Павло, манушэ баря годяґа. Проконсуло камля тэ пошунэ Дэвлэхкоро лав тай акхарда пэстэ Варнава и Савло. ");
INSERT INTO rmyservi_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Нэ кадэва Вар-Исусо, савэ инте акхарэнас Элима, (пав аврэ «джянимари»), камля тэ терэ лэнди бибахт тай тэ отмарэ пхурэдэрэ патявимастар. ");
INSERT INTO rmyservi_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Тунчи Савло, вов же Павло, пхэрдиля Свэнтонэ Фаноґа, вхаляпэ дэ Элима якхэнца ");
INSERT INTO rmyservi_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","тай пхэнда: — Чяво барэ бэнгэхкоро, врыжымашо всавэрэ чячимасти, пхэрдо хохавимаґа тай хрантимаґа! Кала ту пэрэачеґа тэ выбандярэ чячюно Раехкоро дром? ");
INSERT INTO rmyservi_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Акэ, екхатар васт Раехкоро ваздэняпэ пэ тут! Ту авэґа коро и савись вряма на дыкхэґа душлимо кхамэхкоро! Тунчи сджиле пэр лэстэ рят тай калимо, тай вов ачиля тэ чувэпэ дэ всавэрэн ригэн и тэ родэ кодэлэ, ко лиджяла лэ пала васт. ");
INSERT INTO rmyservi_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Кала проконсуло удыкхля, со тердапэ, вов патиня, колэсти со дэняпэ дыво сикляримасти пала Дэвлэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Павло и кодэла, ко сле лэґа, отджиле пав пане Пафосостар тай авиле дэ Перга, сави сля дэ Памфилия. Котэ Иоанно ачявда лэн и рисиля дэ Ерусалимо. ");
INSERT INTO rmyservi_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Пергатар вонэ лагле дурэдэр дэ писидийско Антиохия. Дэ суббота вонэ авиле дэ синагога тай бэшле котэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Пала колэ, сар продиндэ Упхэнимастар и Англунарендар, пхурэдэра дэ синагога пхэндэ лэнди: — Пхралалэ, сар исин тумэндэ лав, соб тэ подрицарэ манушэн, тунчи дэдумэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Павло вщиля, подлиля васт и пхэнда: — Мурша израильтянуря и всавэрэ, ко даран Дэвлэстар, шунэн ман! ");
INSERT INTO rmyservi_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Дэвэл Израилёхкэрэн манушэн вытидэня дадэн амарэн. Вов ваздэня манушэн, кала вонэ сле дэ Египто, и зоралэ вастэґа вылиджялда лэн котарь. ");
INSERT INTO rmyservi_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Саранда бэрш Вов прыдыкхэлас пала лэн дэ шуки пхув. ");
INSERT INTO rmyservi_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Вов прэдэня мэримасти дэ Ханаано эфта манушэнгэрэн родонэн и отдэня лэнгири пхув амарэ дадэнди. ");
INSERT INTO rmyservi_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Кади проджиля пашэ штар шэла пандэша бэрш. Ды колэ, сар авиля англунари Самуило, Дэвэл дэлас лэнди сундисарен. ");
INSERT INTO rmyservi_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Тунчи мануша помангле тхагаре, тай Дэвэл дэня лэнди Сауло, Кишохкэрэ чявэ, Вениаминохкорэ родостар. Сауло сля тхагареґа саранда бэрш. ");
INSERT INTO rmyservi_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Тунчи Дэвэл залиля тхагаримо Саулостар тай терда тхагареґа Давидо. Вов допхэнэлас пала лэ: «Мэ аракхлём Давидо, Иессеехкэрэ чявэ, кадэва мануш Манди пав їлэ, вов терэла вса, со Мэ камав». ");
INSERT INTO rmyservi_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Давидохкэрэ родостар Дэвэл дэня Израилёхкэрэ Фирисаре — Исусо, сар и дэлас лав пала кода. ");
INSERT INTO rmyservi_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Англа колэ, сар авиля Исусо, Иоанно пхэнэлас всавэрэ Израилёхкэрэ манушэнди, со трэбуни тэ ачявэ бэзимо тай тэ болдэпэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Кала ж Иоаннохкири бути проджялас, вов пхэнэлас: «Пала ка тумэ ман прылэн? Мэ на Вов. Нэ пала ман джял Кодэва, Касти мэ на ачяв тэ розпхандэ доря пэ цыруля». ");
INSERT INTO rmyservi_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Пхралалэ! Чяворэ Авраамохкэрэ и кодэла тумэндар, савэ даран Дэвлэстар! Кадэва лав фирисаримахкоро сля бичалдо амэндэ! ");
INSERT INTO rmyservi_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Кодэла, савэ джювэн дэ Ерусалимо тай лэнгэрэ пхурэдэра на уджянгле Фирисаре. Вонэ сундисардэ Лэ и кади тердэ пав англунаренгэрэн лавэн, савэ динэн кожно суббота. ");
INSERT INTO rmyservi_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Вонэ на аракхле дэ Лэ нисави дош, пала со Лэ трэбуни сля тэ умарэ, нэ умангле Пилато, соб тэ прэдэ Лэ мэримасти. ");
INSERT INTO rmyservi_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Кала вонэ стердэ вса, со сля пала Лэ искриисардо, вонэ слиле Лэ каштунэ трушулэстар тай тховдэ дэ склепо. ");
INSERT INTO rmyservi_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Нэ Дэвэл отджювдярда Лэ мулэндар, ");
INSERT INTO rmyservi_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","и бут дивэн кодэла, савэ авиле Лэґа Галилеятар дэ Ерусалимо, дыкхэнас Лэ. Тай екхатар вонэ Лэхкэрэ допхэнимаря англа манушэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","И амэ кади ж дэдумах кадэва Бахтало Лав: кода, пала со Дэвэл пхэнэлас амарэ дадэнди, ");
INSERT INTO rmyservi_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Вов терда важ амэн, лэнгэрэ чяворэн, кала отджювдярда Исусо. Дэ авэр псалмо искриисардо: «Ту — Чяво Муро, авдивэ Мэ ачилём Тирэ Дадэґа». ");
INSERT INTO rmyservi_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Тай пала кода, со Дэвэл отджювдярда Лэ мулэндар, кади, со трупо Лэхкоро на прахола, Вов пхэнда: «Мэ дава тумэнди свэнто Давидохкоро бахталимо, саво на парувэлапэ». ");
INSERT INTO rmyservi_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Тай дэ авэр тхан Вов дэдумэл: «Ту на дэґа, соб Свэнто Тиро тэ лэлпэ прахоґа». ");
INSERT INTO rmyservi_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Давидо дэ пэхкири вряма терэлас бути пав воля Дэвлэхкири. Тунчи вов муля, лэ прахосардэ лэхкэрэ дадэнца, тай трупо лэхкоро лиляпэ прахоґа. ");
INSERT INTO rmyservi_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Нэ Кодэва, Ка Дэвэл отджювдярда, прахоґа на лиляпэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Калэсти, пхралалэ, джянэн: чэрэз Лэстэ Дэвэл отмукэл тумэнди бэзимо. ");
INSERT INTO rmyservi_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","И сар тумэндэ на сля зор тэ ачявэ бэзимо пав Моисеехкэрэ Упхэнима, кожно ко патяла дэ Лэстэ, ачявэла пэхкоро бэзимо. ");
INSERT INTO rmyservi_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Дыкхэн, соб тумэнца тэ на терэлпэ кода, пала со дэдумэнас англунаря: ");
INSERT INTO rmyservi_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","«Подыкхэн, асамаря, дэнпэ дывости и хасявэн! Мэ терава дэ тумарэн дивэн кацаво рындо, со тумэ никала б на патине, кала б тумэнди розпхэндэ пала кода». ");
INSERT INTO rmyservi_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Кала Павло тай Варнава джянас котарь, лэн помангле тэ дэдумэ пала кода дэ авэр суббота. ");
INSERT INTO rmyservi_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Мануша розджилепэ, нэ бут иудея тай пативалэ, савэ прылиле иудеенгоро сикляримо, джиле пала Павло тай Варнава. Вонэ дэдумане лэнца тай умангэнас лэн тэ джювэ пав Дэвлэхкоро мищимо. ");
INSERT INTO rmyservi_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Дэ авэр суббота гроза манушэн кодэлэ форостар стидэняпэ, соб тэ шунэ лав Раехкоро. ");
INSERT INTO rmyservi_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Кала иудея удыкхле скацик манушэн, вонэ мижыле тай ачиле намишто тэ дэдумэ пала Павлохкэрэн лавэн тай тэ кошэ Павло. ");
INSERT INTO rmyservi_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Тунчи Павло тай Варнава пхэндэ лэнди ворта: — Лав Дэвлэхкоро трэбуни сля англал всавэрэстар тэ дэдумэ тумэнди. Нэ кала тумэ отпхэнэнпэ лэстар, тай на бинэн, со вечно джювимо исин важ тумэн, амэ джях наиудеенгэрэ манушэндэ, ");
INSERT INTO rmyservi_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","сар и прыпхэнда амэнди Рай: «Мэ тердом Тут душлимаґа важ всаворо манушыкано родо, тэ авэн фирисардэ Тутар пав всавири люмля». ");
INSERT INTO rmyservi_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Кала наиудея шундэ када, вонэ сле лошалэ тай лашарэнас Рае пала Лэхкэрэ лавэ. Тай патине всавэрэ, савэ сле вытидэне вечно джювимастэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Раехкоро лав розджиляпэ пав всавири кодыя пхув. ");
INSERT INTO rmyservi_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Иудея ж подмардэ пативалэн джювлен барвалэ їрендар тай форохкэрэн пхурэдэрэн. Тай всавэрэ вонэ ачиле тэ традэ Павло и Варнава и вытрадэне лэн пэхкиря пхуятар. ");
INSERT INTO rmyservi_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Тунчи вонэ обмардэ прахо пэхкэрэ пурэндар тай джиле дэ Иконии. ");
INSERT INTO rmyservi_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","А сиклярнэ пхэрдёнас лошаґа тай Свэнтонэ Фаноґа. ");
INSERT INTO rmyservi_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Дэ Иконии Павло тай Варнава їтханэ заджиле дэ иудеенгири синагога тай дэдумане кади, со патине фартэ бут иудеен тай греконэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ай иудея, савэ отпхэндэпэ лэнди тэ патя, ваздэне тай мижардэ пэ пхралэн наиудеен. ");
INSERT INTO rmyservi_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Нэ вса ж Павло тай Варнава сле котэ бут вряма. Вонэ бидаракоро дэдумане пала Рае, Саво допхэнэлас лав пала Лэхкоро мищимо и дэлас лэнди зор тэ терэ допхэнимо тай дывуря. ");
INSERT INTO rmyservi_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Кодэла, ко джювэнас дэ форо, розмардэпэ по епаш. Екх мануша подрицарэнас иудеен, ай авэр — апостолонэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Нэ кала наиудея тай иудея їтханэ пэхкэрэ пхурэдэрэнца закамле тэ прытховэ зор тай тэ помарэ лэн барэнца, ");
INSERT INTO rmyservi_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","вонэ уджянгле пала кода, нашле тай проджиле пхув Ликаония, форуля Листра тай Дервия и пхуя, савэ сле пашэ лэн, ");
INSERT INTO rmyservi_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","тев дурэдэр розпхэнэнас Бахтало Лав. ");
INSERT INTO rmyservi_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Дэ Листра джювда бизоракоро мануш, саво пэхкэрэ бэнимастар на пхирэлас пурэнца. Екхвар, кала вов бэшэлас, ");
INSERT INTO rmyservi_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","вов шунда Павлохкоро лав. Павло же подыкхля пэр лэстэ тай полиля, со лэстэ исин патявимо, соб тэ састярэпэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","— Вщи пэ тирэ пурэ тай пхир! — зоралэ ґласоґа пхэнда Павло. Кодэва всхукля тай ачиля тэ пхирэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Мануша удыкхле, со терда Павло тай типисиле пав ликаонско чиб: — Амэндэ сджиле дэвэла, поджилэ пэ манушэн! ");
INSERT INTO rmyservi_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Вонэ пхэнэнас пэ Варнава «Зевсо», а пэ Павло — «Гермесо», колэсти со вов будэр дэдумэлас. ");
INSERT INTO rmyservi_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Англа форо сля храмо, тев тэлёнас Зевсости, тай лэхкоро рашай анда форохкэрэ вударэндэ гурувэн тай винци, колэсти со камля їтханэ манушэнца тэ анэ лэнди жэртва. ");
INSERT INTO rmyservi_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Кала апостолуря Павло тай Варнава ушундэ пала кода, вонэ розчиндэ пэхкири їда, чутэпэ машкар манушэн тай ачиле тэ типисявэ: ");
INSERT INTO rmyservi_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","— Муршалэ, со тумэ терэн? Амэ — кацавэ ж мануша, сар и тумэ! Амэ андэ тумэнди Бахтало Лав тай камах, соб тумэ тэ отпхэнэнпэ хохавнэ дэвлэндар и обрисиле джювдэ Дэвлэстэ, Саво стерда болыбэн, пхув, море и вса, со дэ лэн исин. ");
INSERT INTO rmyservi_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Дэ думутни вряма Вов помукэлас всавэрэ манушэнгэрэ родонэнди тэ пхирэ лэнгэрэ дромэнца, ");
INSERT INTO rmyservi_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","нэ на пэрэачелас тэ допхэнэ пала Пэ, кала терэлас мищимо тай бичалэлас тумэнди брышынд болыбнастар и вряма тэ стидэ плодуря, кала дэлас тумэнди хамо тай пхэрдярэлас тумарэ їлэ лошаґа. ");
INSERT INTO rmyservi_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Тай кацик кадэлэ лавэнца вонэ допхэндэ манушэнди, соб важ лэн тэ на анэн жэртва. ");
INSERT INTO rmyservi_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Иудея, савэ авиле Антиохиятар тай Икониестар, пэрэцырдэне гроза манушэн пэ пэхкири риг. Павло помардэ барэнца тай выцырдэне пала форо. Вонэ думисардэ, со вов муля. ");
INSERT INTO rmyservi_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Нэ кала сиклярнэ стидэнепэ паша лэ, вов ущиля тай упалэ джиля дэ форо. Пэ авэр диво вов тай Варнава джиле дэ Дервия. ");
INSERT INTO rmyservi_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Вонэ дэдумане Бахтало Лав дэ кадэва форо тай тердэ сиклярнэнца бут манушэн. Тунчи вонэ упалэ проджиле Листра, Иконии тай Антиохия. ");
INSERT INTO rmyservi_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Котэ вонэ подрицарэнас сиклярнэнгоро фано тай прыакхарэнас, соб кодэла тэ аченпэ дэ патявима. — Англа колэ, сар тэ заджя дэ Дэвлэхкоро Тхагаримо, амэнди трэбуни тэ прылэ бут грыжа, — пхэнэнас вонэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Павло тай Варнава дэ кожно кхандири возтховэнас васта пэ манушэн тай терэнас лэндар пхурэдэрэн. Тунчи лиле посто тай поманглепэ, и пэрэдэне лэн Раести, дэ Савэ вонэ упатине. ");
INSERT INTO rmyservi_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Тунчи вонэ проджиле Писидия тай авиле дэ Памфилия. ");
INSERT INTO rmyservi_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Кала ж вонэ пхэндэ лав дэ Перга, котарь авиле дэ Атталия. ");
INSERT INTO rmyservi_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Котарь вонэ лагле пав пане дэ Антиохия, тев, пав Дэвлэхкоро мищимо, лэн майанглал вытидэне пэ бути, сави вонэ и тердэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","А кала вонэ авиле дэ Антиохия, тунчи стидэне кхандири тай розпхэндэ пала вса, со Дэвэл терда лэнгэрэ вастэнца, и сар Вов оттерда вудара патявимастэ наиудеенди. ");
INSERT INTO rmyservi_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Тай бут вряма просле котэ їтханэ сиклярнэнца. ");
INSERT INTO rmyservi_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Иудеятар дэ Антиохия авиле мануша, савэ ачиле тэ сиклярэ пхралэн: — Кала тумэ на авэна тэ обчинэпэ пав прыпхэнима Моисеехкэрэ, тумэ на фирисарэнапэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Павло и Варнава бут молы допхэнэнас лэнди тай вджянас дэ бари дума. Тунчи Павлости и Варнавасти прыпхэндэ тэ джя дэ Ерусалимо їтханэ койсавэ авэр патякунэ манушэнца тай тэ обдэдумэ кадэва рындо апостолонэнца и пхурэдэрэнца. ");
INSERT INTO rmyservi_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Кхандири пролиджялда лэн, тай вонэ джиле пав Финикия и Самария тай розпхэнэнас котэ, сар наиудея обрисиле Дэвлэстэ. Кадэлэсти фартэ лошыле всавэрэ патякунэ мануша. ");
INSERT INTO rmyservi_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Дэ Ерусалимо лэн прылиле кхандири, апостолуря тай пхэрэдэра, а вонэ розпхэнда пала вса, со Дэвэл терда лэнгэрэ вастэнца. ");
INSERT INTO rmyservi_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Нэ патякунэ, савэ сле фарисеенгэрэ стидэмастар, пхэнэнас, со наиудеен трэбуни тэ обчинэ тай тэ прыпхэнэ лэнди, соб тэ джювэн вонэ пав Моисеехкэрэ Упхэнима. ");
INSERT INTO rmyservi_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Апостолуря тай пхурэдэра стидэнепэ, соб тэ мишто роздыкхэ кадыя дума. ");
INSERT INTO rmyservi_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Вонэ лунго вряма дэдумэнас пала кода, тунчи Пётро вщиля тай подэня пэхкоро ґласо: — Пхралалэ, сар тумэ джянэн, проджиля бут вряма кодэлэ дивэстар, кала Дэвэл вытидэня всавэрэндар амэндар ман, соб тэ розпхэнав Бахтало Лав наиудеенди, и соб вонэ тэ патян. ");
INSERT INTO rmyservi_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Дэвэл джянэл їлэ манушэнгэрэ, тай Вов дэня допхэнимо, со прылэл и наиудеен, кала бичалда лэнди Свэнто Фано кади ж, сар и амэнди. ");
INSERT INTO rmyservi_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Вов на думисарэл, со амэ фэдэр лэндар, колэсти со патявимаґа жужарда лэнгэрэ їлэ! ");
INSERT INTO rmyservi_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Сости ж тумэ зумавэн Дэвлэ и тховэн пэ кор сиклярнэнди ґамо, тэ лиджя саво на сля зора и амарэ дадэндэ и амэндэ? ");
INSERT INTO rmyservi_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Амэ патях дэ колэ, со прылах фирисаримо пав мищимо Рае Исусохкоро, кади ж, сар и вонэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Тунчи всавэрэ прыачиле мулком тай ачиле тэ шунэ, сар Варнава и Павло розпхэнэн пала допхэнима тай дывуря, савэ Дэвэл терэлас лэнгэрэ вастэнца машкар наиудеен. ");
INSERT INTO rmyservi_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Кала вонэ вса розпхэндэ, Иаково пхэнда: — Пхралалэ, пошунэн ман! ");
INSERT INTO rmyservi_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Симоно екхатар розпхэнда амэнди, сар Дэвэл перво моло авиля наиудеендэ, соб тэ вытидэ лэндар кодэлэн, ко лашарэла Лэхкоро лав. ");
INSERT INTO rmyservi_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","И кадэлэстэ подлиджянас англунаря, кала пхэнэнас: ");
INSERT INTO rmyservi_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","«Тунчи Мэ рисявава тай подваздава катуна Давидохкири, сави тэлэдэня. Вса стерава упалэ, со розпхагляпэ, вортасавава ла, ");
INSERT INTO rmyservi_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","соб авэр мануша тай всавэрэ манушэнгэрэ родуля, савэ акхарэнаспэ Мурэ Лавэґа, ачиле тэ родэ Рае. Кади пхэнэл Рай, Саво терэл вса откада, ");
INSERT INTO rmyservi_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","со джянэл англунимастар». ");
INSERT INTO rmyservi_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Колэсти мэ думисарав, со амэнди на трэбуни тэ тховэ пхаримо пэ наиудеен, савэ обрисявэн Дэвлэстэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Нэ трэбуни тэ искриисарэ лэнди лил, соб вонэ на тэ маґрисарэнпэ стердэ дэвлорэндар, тэ на терэн биладжявимо їрестар, тэ на хан мас затасавдэ хулаимастар тай тэ на пэн рат. ");
INSERT INTO rmyservi_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Колэсти со Упхэнимо Моисеехкоро англунэ родостар розпхэнэн тай динэн кожно суббота дэ всавэрэ синагоги пав всавэрэн форонэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Тунчи апостолуря тай пхурэдэра їтханэ всавиря кхандиряґа прылиле дэ гындо тэ вытидэ манушэн, тай тэ бичалэ лэн дэ Антиохия Павлоґа и Варнаваґа. Вонэ вытидэне Иуда, савэ инте акхарэнас Вар-Савва, тай Сила. Кадэла сле пхурэдэра машкар пхралэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Лэнца пэрэдэне кацаво лил: «Пхрала апостолуря тай пхурэдэра, пхралэнди наиудеендар, савэ джювэн дэ Антиохия, Сирия тай Киликия. Тэ авэн бахталэ! ");
INSERT INTO rmyservi_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Сар доджиля амэндэ дума, со койсавэ амэндар змардэ тумэн годятар пэхкэрэ лавэнца и тховдэ калимо дэ тумарэн їлэн, нэ амэ на пхэнаґас лэнди тэ терэ кади. ");
INSERT INTO rmyservi_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Колэсти амэ прылиле дэ гындо тэ вытидэ койсавэн муршэн тай бичалдэ лэн тумэндэ їтханэ амарэ пативалэнца Варнаваґа тай Павлоґа, ");
INSERT INTO rmyservi_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","савэ отдэн пэхкоро джювимо важ Лав амарэ Рае Исусо Христо. ");
INSERT INTO rmyservi_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Амэ бичалах тумэнди кади ж Иуда тай Сила, соб вонэ розпхэндэ тумэнди кода, со амэ искриисарах. ");
INSERT INTO rmyservi_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Свэнто Фано тай амэ прылиле дэ гындо, соб тэ на тховах пэ тумэн нисаво пхаримо, кацик откада, со трэбуни: ");
INSERT INTO rmyservi_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Тэ на хан кода, со андэ дэ жэртва стердэ дэвлорэнди и мас затасавдэ хулаимастар, тэ на пэн рат, тэ на терэн биладжявимо їрестар. Сар авэна када тэ терэ, терэна мишто. Тэ авэн састэ!» ");
INSERT INTO rmyservi_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Бичалдэ джиле дэ Антиохия. Котэ вонэ стидэне кхандири тай пэрэдэне лил. ");
INSERT INTO rmyservi_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Мануша динэнас лэ тай лошавэнас подрицаримасти. ");
INSERT INTO rmyservi_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Иуда тай Сила, савэ сле англунаря, кади ж подрицарэнас пхралэн пэхкэрэ лавэнца дэ патявима. ");
INSERT INTO rmyservi_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Вонэ сле котэ койсави вряма тай пхрала бахтаґа отмукле лэн кодэлэндэ, ко лэн бичалда. ");
INSERT INTO rmyservi_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Павло тай Варнава ачилепэ дэ Антиохия, тев вонэ аврэ бутэ пхралэнца сиклярэнас Раехкэрэ лавэсти тай розпхэнэнас Бахтало Лав. ");
INSERT INTO rmyservi_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Проджиля набут вряма, тай Павло пхэнда Варнавасти: — Заджяґа пхралэндэ дэ всавэрэн форонэн, тев амэ дэдумане Раехкоро лав, тай подыкхаґа, сар вонэ джювэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Варнава камля тэ лэ пэґа Иоанно, савэ инте акхарэнас Марко. ");
INSERT INTO rmyservi_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Нэ Павло прылиля дэ гындо, со на трэбуни тэ лэ кодэлэ, ко ачявда лэн дэ Памфилия тай на терэлас лэнца бути. ");
INSERT INTO rmyservi_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Вонэ нисар на допхэндэпэ машкар пэстэ, колэсти розджилепэ. Варнава лиля Марко и вонэ лагле пав пане пэ Кипро. ");
INSERT INTO rmyservi_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ай Павло вытидэня Сила, и, кала пхрала прэдэне лэн Раехкэрэ мищимасти, джиля дэ дром. ");
INSERT INTO rmyservi_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Тунчи вов проджялас Сирия тай Киликия, тев подрицарэлас кхандиря дэ патявима. ");
INSERT INTO rmyservi_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Тунчи Павло авиля дэ Листра тай дэ Дервия. Котэ джювда сиклярно, савэ акхарэнас Тимофеи. Лэхкири дэй сля патякуни иудеянка, ай дад сля греко. ");
INSERT INTO rmyservi_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Пала Тимофее мишто дэдумане пхрала дэ Листра тай дэ Иконии. ");
INSERT INTO rmyservi_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Павло закамля тэ лэ Тимофее дэ пэхкоро дром. Тай важ иудеен, савэ джювдэ дэ кодэлэн тханэн, обчинда лэ. Важ кода, со всавэрэ джянгле: Тимофеехкоро дад исин греко. ");
INSERT INTO rmyservi_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Кала Павло тай мануша, савэ сле лэґа, пэрэджянас форо форостар, вонэ прыакхарэнас патякунэн тэ терэ кади, сар пэрэдэне апостолуря тай пхурэдэра Ерусалимостар. ");
INSERT INTO rmyservi_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Кхандиря састёнас дэ патявима, тай патякунэн диво дивэстар ачелас будэр. ");
INSERT INTO rmyservi_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Вонэ проджянас пав Фригия тай Галатиякири пхув, нэ Свэнто Фано на домукля лэн тэ пхэнэ лав дэ Цыкни Азия. ");
INSERT INTO rmyservi_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Вонэ поджиле Мисиятэ и камле тэ джя дэ Вифиния, нэ Исусохкоро Фано на домукля лэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Тай вонэ проджиле Мисия и авиле дэ Троада. ");
INSERT INTO rmyservi_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Рятяґа Павлости сля дыкхлимо: лэсти сикавдапэ мануш Македониятар. Вов ачелас тай мангэлас Павло: — Ав дэ Македония тай дэ амэнди зор! ");
INSERT INTO rmyservi_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Пала кодэлэ дыкхлима амэ полиле, со Дэвэл прыакхарэл амэн тэ пхэнэ котэ Бахтало Лав. Тай екхатар лагле дэ Македония. ");
INSERT INTO rmyservi_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Троадатар амэ лагле пав пане дэ Самофракия тай котарь пэ авр диво лагле дэ Неаполи. ");
INSERT INTO rmyservi_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Котарь амэ лагле дэ Филиппы. Када сля Римохкири колония и баро форо дэ Македония. Дэ кадэва форо амэ сле набут вряма. ");
INSERT INTO rmyservi_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Дэ суббота амэ выджиле пала форохкэрэн ударэн лэнятэ. Котэ, сар амэ думисардэ, сля тхан важ мангима. Амэ бэшле и ачиле тэ дэдумэ джювленца, савэ котэ стидэнепэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Машкар лэн сля екх, савя акхарэнас Лидия. Вой тэлёлас Дэвлэсти, сля форостар Фиатира тай битинэлас кучутнэ шукар похтана. Лидия шунда Павло, и Рай оттерда лакоро їло тэ прылэ лэхкэрэ лава. ");
INSERT INTO rmyservi_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Тунчи, кала вой тай лакэрэ цэрунэ болдэнепэ, вой акхарда амэн пэстэ. — Сар тумэ динэн, со патяв Раести, тунчи джян и поавэн мандэ цэрэ, — фартэ акхарэлас вой амэн, тай амэ джиле. ");
INSERT INTO rmyservi_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Екхвар, кала амэ джиле дэ тхан важ мангима, пав дром амэ удыкхле екха бутярня. Дэ латэ бэшэлас нажужо фано врэжакоро. Вой врысарэлас и кадэлэґа затерэлас барэ ловэ пэхкэрэ хулаенди. ");
INSERT INTO rmyservi_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Бутярни джялас пала Павло тай пала амэн тай типисявэлас: — Кадэла мануша — копыля Дэвлэ Барэдэрэхкэрэ! Вонэ розпхэнэн тумэнди пала дром фирисаримастэ! ");
INSERT INTO rmyservi_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Вой терэлас када диво дивэстар. И кала Павлости вса откада вурыцыля, вов обрисиля тай пхэнда фаности: — Важ Лав Исусо Христохкоро мэ прыпхэнав тути: выджя латар! Дэ кодыя ж вряма фано ачявда ла. ");
INSERT INTO rmyservi_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Кала хулая полиле, со лэндэ хасиля затиримо, вонэ схутилдэ Павло тай Сила тай цырдэне пэ бари гаса форохкэрэ раендэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Вонэ андэ лэн пхурэдэрэндэ тай пхэндэ: — Кадэла мануша — иудея. Вонэ подваздэн амаро форо. ");
INSERT INTO rmyservi_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Вонэ влиджян дэ амаро джювимо кода, со амэнди, римсконэ манушэнди, нащи ни тэ прылэ, ни тэ терэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Гроза манушэн кади ж ачиля тэ вуджилисарэ Павло тай Сила. Тунчи пхурэдэра прыпхэндэ тэ злэ лэндар їда тай тэ марэ лэн дэстэнца. ");
INSERT INTO rmyservi_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Лэн фартэ помардэ тай чутэ дэ барунэ. А барунэхкэрэ бутярнэсти прыпхэндэ мишто тэ дыкхэ пала лэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Кала вов шунда кадэва прыпхэнимо, вов затерда лэн дэ андралатуни цэра дэ барунэ и замарда лэнгэрэ пурэ дэ лэпунза. ");
INSERT INTO rmyservi_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Пашэ епашрят Павло тай Сила манглепэ тай диленца лашарэнас Дэвлэ. И авэр мануша, савэ котэ бэшле, шундэ лэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Екхатар пхув тинисиля баря зораґа, кади, со тинисиле и ванты дэ барунэ. Дэ кодыя ж вряма всавэрэ удара оттердэпэ, и всавэрэ барунарендэ ланчугуря тэлэдене пурэндар. ");
INSERT INTO rmyservi_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Кала барунэхкоро бутярно проджюнгавдапэ тай удыкхля, со всавэрэ удара дэ барунэ оттердэ, вов думисарда, со всавэрэ барунаря унашле. Колэсти хутилда чюри тай камля тэ зачинэпэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Нэ Павло затиписиля лэсти: — На тер нисо пэсти! Амэ всавэрэ катэ! ");
INSERT INTO rmyservi_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Бутярно прыпхэнда, соб тэ анэн яг, запрастэня дэ цэр, затинисиля даратар тай тэлэдэня англа Павло и Сила. ");
INSERT INTO rmyservi_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Тунчи вылиджялда лэн барунэстар тай пхучля: — Рая мурэ! Со манди тэ терэ, соб тэ фирисаравпэ? ");
INSERT INTO rmyservi_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","— Патя дэ Рае Исусо, — пхэндэ вонэ, — и фирисарэґапэ ту тай всаворо тиро цэр. ");
INSERT INTO rmyservi_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Вонэ розпхэндэ лав Раехкоро лэсти тай всавэрэнди, ко сля лэстэ дэ цэр. ");
INSERT INTO rmyservi_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Дэ кодыя ж рятуни вряма барунэхкоро бутярно халавда лэнгэрэ дукхавдэ тхана, а тунчи болдэняпэ вов и всавэрэ, ко сля лэстэ дэ цэр. ");
INSERT INTO rmyservi_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Вов анда Павло тай Сила пэстэ цэрэ и тховда важ лэн скаминд. Всавэрэнца, ко сля лэстэ дэ цэр, вов лошавэлас, со ачиля тэ патя Дэвлэсти. ");
INSERT INTO rmyservi_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Авиля диво, тай форохкэрэ пхурэдэра бичалдэ пэхкэрэн дэстарен дэ барунэ тай прыпхэндэ лэнди: — Отмукэн пэ воля кадэлэн манушэн! ");
INSERT INTO rmyservi_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Барунэхкоро бутярно пхэнда Павлости: — Пхурэдэра прыпхэндэ тэ дэ тумэнди воля! Джян бахтаґа! ");
INSERT INTO rmyservi_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Нэ Павло пхэнда лэнди: — Амэ — римска мануша, ай вонэ бисындохкоро помардэ амэн англа всавэрэн тай чутэ дэ барунэ. Акана камэн чёраханэ амэн тэ вытрадэ? Нат! Мэк вонэ еджинэ авэна тай вылиджяна амэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Бутярнэ розпхэндэ када форохкэрэ пхурэдэрэнди. Кала кодэла шундэ, со Павло тай Сила — римска мануша, тунчи пэрэдаравдэпэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Вонэ авиле, помангле лэндар патив, вылиджялдэ лэн барунэстар и помангле, соб кодэла ачявдэ форо. ");
INSERT INTO rmyservi_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Кала Павло тай Сила выджиле барунэстар, вонэ джиле Лидиятэ. Котэ вонэ удыкхлепэ пхралэнца тай подрицардэ лэн. Тунчи вонэ джиле. ");
INSERT INTO rmyservi_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Кала вонэ проджиле Амфиполи тай Аполлония, тунчи авиле дэ Фессалоника, тев сля иудеенгири синагога. ");
INSERT INTO rmyservi_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Павло, сар лэстэ сля прылито, джиля дэ синагога и котэ трин субботы дэдумэлас иудеенца пала Лила. ");
INSERT INTO rmyservi_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Вов оттерэлас тай допхэнэлас лэнди, со Христости трэбуни сля тэ прылэ грыжа тай тэ отджювдё мулэндар. — Исусо, пала Савэ мэ тумэнди розпхэнав, исин Христосо, — пхэнэлас Павло. ");
INSERT INTO rmyservi_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Лэнди патине койсавэ иудея, бут пативалэн греконэн и бут джювлен барэ родостар. И всавэрэ вонэ прыачиле Павлостэ тай Силастэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Авэр иудея холиле пала кода. Вонэ лиле пэґа налачен манушэн, савэн аракхле пэ форо, стидэне инте гроза манушэн и ачиле бутэн тэ подваздэ. Тунчи джиле Иасонохкэрэ цэрэстэ, родэнас Павло тай Сила, соб тэ вылиджя лэн манушэндэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ай кала на аракхле лэн котэ, цырдэне Иасоно тай аврэн пхралэн форохкэрэ пхурэдэрэндэ. — Кадэла мануша терэн бибахталимо пав всавири люмля, тай екхатар авиле амэндэ, — типисиле вонэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","— Тай Иасоно прылиля лэн дэ пэхкоро цэр. Вонэ на прылэн императохкоро упхэнимо, тай дэдумэн, со исин авэр тхагари, Савэ акхарэн Исусо. ");
INSERT INTO rmyservi_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Гроза манушэн и форохкэрэ пхурэдэра ушундэ када тай пэрэдаравдэпэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Тунчи Иасоно тай авэр потиндэ пала пэ, тай лэн отмукле. ");
INSERT INTO rmyservi_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Сар кацик авиля рят, пхрала отбичалдэ Павло и Сила дэ Верия. Кала вонэ авиле пордэ, тунчи заджиле дэ иудеенгири синагога. ");
INSERT INTO rmyservi_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Вериниянуря сле мануша оттердэ їлэґа, а на кади, сар дэ Фессалоника. Вонэ прылиле Павлохкири дума всавэрэ їлэґа и кожно диво розлэнас Лила, соб тэ продыкхэ, чячимо када чи нат. ");
INSERT INTO rmyservi_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Бут лэндар патине. Патине кади ж греконэнгэрэ пативалэ джювля тай бут греконэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Нэ кала иудея дэ Фессалоника уджянгле, со Павло пхэнэл Дэвлэхкоро Лав дэ Верия, вонэ авиле пордэ и ачиле тэ подмарэ и тэ подваздэ манушэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Пхрала сиго отбичалдэ Павло морестэ, а Сила тай Тимофеи ачилепэ дэ форо. ");
INSERT INTO rmyservi_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Кодэла, савэ отлиджялдэ Павло, авиле лэґа дэ Афины, а тунчи рисиле павпалэ. Павло прыпхэнда лэнди тэ пэрэдэ, соб Сила тай Тимофеи сигэдэр тэ авэн лэстэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Кала Павло дожутярэлас лэн, вов пхирэлас пав Афины и лэсти сля пхаро тэ дыкхэ, сар бут дэвлорэн исин дэ кадэва форо. ");
INSERT INTO rmyservi_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Вов пхэнэлас дэ синагога иудеенца тай кодэлэнца, савэ тэлёнас Дэвлэсти. И кожно диво дэдумэлас кодэлэнца, каґа дыкхэласпэ пэ форо. ");
INSERT INTO rmyservi_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Лэґа дэдумане койсавэ ирвалэ мануша — эпикурейцуря тай стоикуря. Екх мануша пхученас: — Со кадэва башлимури камэл тэ пхэнэ? Авэр пхэнэнас: — Амэнди сикавэлпэ, со вов дэдумэл пала аврэпхуякэрэн дэвлэн, — колэсти со Павло дэдуманя Бахтало Лав пала Исусо тай Отджюндивимо. ");
INSERT INTO rmyservi_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Павло андэ пэ форохкоро стидэмо, Ареопаго, тай помангле: — Розпхэн амэнди, со када за нэво сикляримо, пала савэ ту дэдумэх? ");
INSERT INTO rmyservi_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ту пхэнэх пала кода, со на полах. И амэ камах тэ уджянэ, со када исин. ");
INSERT INTO rmyservi_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Афинянуря ж и мануша авря пхуятар, савэ котэ джювэнас, фартэ камэнас тэ залэпэ кодэлэґа, соб тэ дэдумэ чи тэ шунэ сось нэво. ");
INSERT INTO rmyservi_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Тунчи Павло вщиля машкар Ареопаго тай пхэнда: — Афинянуря! Мэ дыкхав, со тумэ будэр аврэн манушэндар тэлён дэвлэнди. ");
INSERT INTO rmyservi_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Кала мэ пхиравас и роздыкхавас тумарэ свэнтыи тхана, мэ дыкхлём, со пэ екх жэртвеннико сля искриисардо: «Наджянглэ Дэвлэсти». Пала Кадэлэ Дэвлэ, Ка тумэ на джянэн, нэ Касти тэлён, мэ тумэнди и розпхэнав. ");
INSERT INTO rmyservi_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Дэвэл, саво стерда люмля и вса, со дэ латэ исин, Вов исин Рай болыбнасти тай пхуяти. Вов на джювэл дэ храмонэн, савэ тердэ манушэнгэрэ васта. ");
INSERT INTO rmyservi_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Тай на мангэл, соб мануша тэ терэн бути Лэсти пэхкэрэ вастэнца, сар бы Лэсти сось на хутилэл. Вов Еджино дэл манушэнди, соб вонэ тэ джювэн и тэ пхурдэн, и вса авэр. ");
INSERT INTO rmyservi_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Екхэ манушэстар Вов стерда всавэрэ манушэнгэрэ родуря, соб мануша тэ джювэн пав всавири люмля, тай майанглал вытидэня вряма и пхуя лэнгэрэ джювимасти. ");
INSERT INTO rmyservi_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Вса откада Дэвэл терда, соб мануша тэ родэн Лэ, тэ полэн, тев Вов исин, тай тэ аракхэн Лэ, нэ пав чячима Вов исин надур амэндар. ");
INSERT INTO rmyservi_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Дэ Лэстэ амэ джювах, пхирах тай исин дэ люмля. Сар пхэнэнас пала кода и койсавэ тумарэ поэтуря: «Амэ исин Лэхкоро родо». ");
INSERT INTO rmyservi_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","И кала амэ Дэвлэхкоро родо, амэнди нащи тэ думисарэ, со Дэвэл поджило пэ кода, со тердо совнакастар, рупатар чи барэстар пав манушэхкири годи. ");
INSERT INTO rmyservi_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Англэ Дэвэл промукэлас вряма, кала мануша на джянгле пала Лэ, нэ екхатар прыпхэнэл всавэрэ манушэнди пав всавири люмля тэ ачявэ бэзимо. ");
INSERT INTO rmyservi_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Вов екхатар вытидэня диво, кала сундисарэла люмля пав чячима, тай кади ж вытидэня Манушэ, Саво авэла сундисареґа. Дэвэл допхэнда када англа всавэрэн, кала отджювдярда Лэ мулэндар. ");
INSERT INTO rmyservi_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Кала вонэ ушундэ пала отджюндивимо мулэндар, койсавэ лэндар ачиле тэ асапэ, ай авэр пхэндэ: — Пала кода амэ пошунаґа тут дэ авэр моло. ");
INSERT INTO rmyservi_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Кадэлэґа Павло и ачявда лэнгоро стидэмо. ");
INSERT INTO rmyservi_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Нэ набут манушэн прыачиле Павлостэ тай патине. Машкар лэн сле Дионисии, саво вджялас дэ Ареопаго, джювли, савя акхарэнас Дамарь, тай авэр мануша. ");
INSERT INTO rmyservi_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Тунчи Павло ачявда Афины и лагля дэ Коринфо. ");
INSERT INTO rmyservi_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Котэ вов дыкхля иудее пав лавэ Акила, саво бэняпэ дэ Понто. Кодэва надумут авиля Италиятар пэхкиря ромняґа, савя акхарэнас Прискилла, колэсти со императоро Клавдии прыпхэнда всавэрэ иудеенди тэ ачявэн Римо. Павло авиля тэ дыкхэпэ лэнца. ");
INSERT INTO rmyservi_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Вонэ терэнас кодыя ж бути, со и Павло: терэнас катуны. Колэсти Павло ачиляпэ лэндэ тэ терэлас лэнца бути. ");
INSERT INTO rmyservi_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Кожно суббота вов дэдумэлас дэ синагога иудеенца тай греконэнца и камля тэ пэрэцырдэ лэн пэ пэхкири риг. ");
INSERT INTO rmyservi_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Кала Македониятар авиле Сила тай Тимофеи, тунчи Павло всавири пэхкири вряма отдэня колэсти, соб тэ пхэнэ лав. Тай допхэнэлас иудеенди, со Исусо исин Христосо. ");
INSERT INTO rmyservi_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Кала вонэ ачиле тэ пэрэмарэ тай тэ кошэ лэ, вов обмарда прахо пэхкиря їдатар тай пхэнда лэнди: — Тумэ еджинэ дошалэ дэ пэхкэрэ хасявима! Мэ жужо и кана джяв наиудеендэ! ");
INSERT INTO rmyservi_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Павло выджиля котарь тай джиля дэ цэр, саво ачелас пашэ синагога. Котэ джювэлас Титий Иусто, мануш, саво тэлёлас Дэвлэсти. ");
INSERT INTO rmyservi_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Пхурэдэр дэ синагога Криспо и всавэрэ лэхкэрэ цэрунэ патине Раести. Тай бут коринфянуря, савэ шунэнас Павло, патине и сле болдэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Екхвар рятяґа Рай пхэнда Павлости дэ дыкхлима: — На дара! Дэдумэ тай на пэрэач! ");
INSERT INTO rmyservi_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Мэ туґа, тай нико на терэла тут бибахт. Дэ кадэва форо исин бут Мурэн манушэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Павло сля котэ бэрш епашэґа тай сиклярда лэн Дэвлэхкэрэ Лавэсти. ");
INSERT INTO rmyservi_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Дэ кодыя вряма, кала Галлионо сля проконсуло дэ Ахаия, иудея стидэнепэ, схутилдэ Павло тай андэ лэ пэ сындо. ");
INSERT INTO rmyservi_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Вонэ ачиле тэ дошарэ лэ: — Кадэва мануш сиклярэл тэ полэ Дэвлэ на кади, сар сиклярэл амаро Упхэнимо. ");
INSERT INTO rmyservi_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Павло инте нисо на пхэнда, кала Галлионо ачиля тэ дэдумэ кодэлэнди, ко дошарэнас лэ: — Иудея, тэ авэл бы када начячимо чи мижо рындо, мэ бы шунавас тумэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Нэ сар тумэ ханпэ пала сиклярима, лава тай тумаро Упхэнимо, тунчи розлэнпэ еджинэ. Мэ на камав тэ авэ сундисареґа дэ кодэлэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Тай вов вытрадэня лэн сундисарехкэрэ тханэстар. ");
INSERT INTO rmyservi_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Тунчи всавэрэ схутилдэ пхурэдэрэ дэ синагога, савэ акхарэнас Сосфено, тай помардэ лэ англа сундисарехкоро тхан. Нэ Галлионо пэ када нисо на терда. ");
INSERT INTO rmyservi_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Павло просля инте бут дивэн дэ Коринфо. Тунчи вов розачиляпэ пхралэнца тай Прискиллаґа и Акилаґа лагля пав пане дэ Сирия. Англа колэ, сар лэнди тэ ладэ, Павло обчинда бала дэ Кенхреи, колэсти со калась дэня солах Дэвлэсти. ");
INSERT INTO rmyservi_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Вонэ авиле дэ Эфесо. Котэ Павло ачявда Прискилла тай Акилла, а еджино джиля дэ синагога тай дэдумэлас иудеенца. ");
INSERT INTO rmyservi_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Вонэ мангле, соб вов тэ ачелпэ лэндэ пэ савись вряма, нэ вов отпхэндапэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","— Мэ рисявава, сар авэла пэ када Дэвлэхкири воля, — пхэнда Павло, кала розачеласпэ лэнца, тай лагля пав пане Эфесостар. ");
INSERT INTO rmyservi_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Вов лагля дэ Кесария, авиля дэ Ерусалимо, дыкхляпэ котэ кхандиряґа тай джиля дэ Антиохия. ");
INSERT INTO rmyservi_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Павло просля котэ савись вряма, тунчи джиля котарь тай проджялас галатиякири пхув и Фригия, а пав дром подрицарэлас сиклярнэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Дэ кодыя вряма дэ Эфесо авиля иудеи, савэ акхарэнас Аполлосо. Вов шукар дэдумэлас, бэняпэ тай бариля дэ Александрия и мишто джянэлас Лила. ");
INSERT INTO rmyservi_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Вов сля сиклярдо Раехкэрэ Дромэсти тай всавэрэ водеґа розпхэнэлас пала Исусо чячимаґа, нэ еджино джянэлас кацик Иоаннохкоро болдимо. ");
INSERT INTO rmyservi_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Аполлосо ачиля бидаракоро тэ дэдумэ дэ синагога, и кала Прискилла тай Акила ушундэ лэ, вонэ акхардэ лэ пэстэ тай сар исин фэдэр розпхэндэ пала Дэвлэхкоро Дром. ");
INSERT INTO rmyservi_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Аполлосо камля тэ джя дэ Ахаия, тай пхрала, соб тэ подрицарэ лэ, искриисардэ лил сиклярнэнди, савэ котэ джювдэ. Дэ лил вонэ мангле тэ прылэ Аполлосо. Кала вов авиля пордэ, тунчи дэня бари зор кодэлэнди, ко пав Дэвлэхкоро мищимо ачиля тэ патя. ");
INSERT INTO rmyservi_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Аполлосо пхабардэс сикавэлас иудеенгоро начячимо тай англэ манушэн допхэнэлас Лилэндар, со Христосо исин Исусо. ");
INSERT INTO rmyservi_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Дэ кодыя вряма, кала Аполлосо сля дэ Коринфо, Павло проджиля пав плаехкэрэ тхана тай авиля дэ Эфесо. Котэ вов дыкхляпэ койсавэ сиклярнэнца. ");
INSERT INTO rmyservi_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","— Прылиле тумэ Свэнто Фано, кала патине? — пхучля вов. — Амэ и на шундэ пала кода, со исин Свэнто Фано, — пхэндэ кодэла. ");
INSERT INTO rmyservi_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Тунчи Павло пхучля: — Сар жэ тумэ сле болдэ? — Кади, сар сиклярда Иоанно, — пхэндэ вонэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Павло пхэнда: — Иоанно болдэлас, кала мануш прыджянэлас пэхкоро бэзимо. Вов прыакхарэлас манушэн тэ патя дэ Кодэлэ, Касти трэбуни тэ авэ пала лэ, дэ Исусо. ");
INSERT INTO rmyservi_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Кала вонэ ушундэ пала када, тунчи болдэнепэ важ Рае Исусохкоро Лав. ");
INSERT INTO rmyservi_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","И кала Павло тховда пэ лэн васта, пэ лэндэ сджиля Свэнто Фано. Тунчи вонэ ачиле тэ дэдумэ авэр чибэнца и тэ пхэнэ Дэвлэстар. ");
INSERT INTO rmyservi_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Всавэрэн лэн сля паша дэшудуй манушэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Павло трин чёна бидаракоро пхэнэлас дэ синагога. Вов дэдуманя манушэнца пала Дэвлэхкоро Тхагаримо тай допхэнэлас лэнди. ");
INSERT INTO rmyservi_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Нэ койсавэ лэндар мижонас и отпхэнэнаспэ тэ патя, тай дэдумэнас англа всавэрэн, со Дром Раехкоро на исин чячюно. Тунчи Павло ачявда лэн. Вов вытидэня сиклярнэн и кожно диво дэдуманя лэнца дэ Тираннохкири школа. ");
INSERT INTO rmyservi_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Кади процырдэняпэ дуй бэрша, и всавэрэ иудея тай грекуря, савэ джювдэ дэ Цыкни Азия, шундэ Раехкоро Лав. ");
INSERT INTO rmyservi_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Дэвэл терэлас Павлохкэрэ вастэнца фартэ барэ дывуря. ");
INSERT INTO rmyservi_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Насвалэ лэнаспэ кхоснэндэ тай кущикэндэ, савэн майанглал лэласпэ Павло, тай высастёнас всавэрэ дукхэндар, тай мижэ фануря выджянас лэндар. ");
INSERT INTO rmyservi_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Койсавэ иудеенгэрэ джянимаря, савэ пхирэнас пав дромэн, кала вытрадэнас мижо фано манушэндар, прыакхарэнас Лав Рае Исусохкоро. Вонэ пхэнэнас: — Прыпхэнав тумэнди важ Исусо, пала Савэ розпхэнэл Павло. ");
INSERT INTO rmyservi_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Када терэнас и эфта Скевахкэрэ чявэ. А Скева сля иудеенгоро англуно рашай. ");
INSERT INTO rmyservi_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Нэ мижо фано пхэнда лэнди: — Джянав Исусо, тай Павло джянав. А ко тумэ кацавэ? ");
INSERT INTO rmyservi_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Тай мануш, дэ саво сля мижо фано, чутапэ пэ лэн кацавя зораґа, со домарда лэн всавэрэн и вонэ вынашле цэрэстар нангэ тай зранглэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Кала пала када уджянгле иудея тай грекуря, савэ джювдэ дэ Эфесо, лэн всавэрэн обхутилда дар, тай вонэ ачиле тэ отлиджяпэ Рае Исусохкэрэ Лавэстэ баря пативаґа. ");
INSERT INTO rmyservi_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Бут савэ лэндар патине, авэнас тай оттердо прыджянэнаспэ дэ пэхкэрэн рындонэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Бут мануша, савэ майанглал залэнас врэжаґа, анэнас пэхкэрэ джянимахкэрэ лила и англал всавэрэн спхабарэнас лэн. Кала биндэ, сави цимин сля всавэрэ спхабардэ лилэндэ, тунчи выджиля пандэша пхангля рупь. ");
INSERT INTO rmyservi_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Кади Дэвлэхкоро лав розджяласпэ тай лэлас зор. ");
INSERT INTO rmyservi_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Пала кадэлэ всавэрэ Павло прылиля дэ гындо тэ заджя пав Македония тай Ахаия, ай тунчи тэ ладэ дэ Ерусалимо. — Сар мэ авава дэ Ерусалимо, манди трэбуни тэ попэрав и дэ Римо, — пхэнда вов. ");
INSERT INTO rmyservi_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Вов бичалда дэ Македония дон пэхкэрэн амалэн, Тимофее тай Эрасто, а еджино пэ койсави вряма ачиляпэ дэ Цыкни Азия. ");
INSERT INTO rmyservi_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Тунчи сля баро ваздимо важ Раехкэрэ Дромэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Мануш, савэ акхарэнас Димитрии и саво залэласпэ рупунэ рындонэнца, терэлас рупастар храмуря, кацавэ, сар храмо, тев тэлёнас дэвляти пав лавэ Артемида. И кадэлэґа вов дэлас тэ затерэ и авэр пэхкэрэ амалэнди. ");
INSERT INTO rmyservi_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Вов акхарда лэн и аврэн кацавэн бутярнэн дэ кадэва рындо тай пхэнда: — Тумэ джянэн, со кадыя бути дэл амэнди лачё затиримо. ");
INSERT INTO rmyservi_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Нэ тумэ дыкхэн и шунэн, со кадэва Павло пэрэцэрдэня пэ пэхкири риг тай слиджялда годятар бутэн манушэн, савэ джювэн на кацик дэ Эфесо, нэ пав всавири Цыкни Азия. Вов пхэнэл, со дэвэла, савэ стердэ вастэнца, — на дэвэла. ");
INSERT INTO rmyservi_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Када лиджял колэстэ, со на кацик амари бути на авэла дэ патива, нэ и храмо, тев тэлён баря дэвляти Артемидати, нисо на ачела. Тай еджини дэвли, савяти тэлён всавири Цыкни Азия и всавири люмля, хацарэла пэхкири патив. ");
INSERT INTO rmyservi_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Кала вонэ ушундэ када, тунчи мижыле тай ачиле тэ типисявэ: — Бари исин Артемида Эфесохкири! ");
INSERT INTO rmyservi_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Тунчи всаворо форо подваздэняпэ. Мануша схутилдэ кодэлэн, ко авиля Павлоґа (када сле македонянуря Гаий тай Аристархо), и всавэрэ, сар екх, прастэне дэ театро. ");
INSERT INTO rmyservi_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Павло камля тэ выджя манушэндэ, нэ сиклярнэ на дэне лэсти. ");
INSERT INTO rmyservi_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","И койсавэ Азиякэрэ пхурэдэра, амала Павлохкэрэ, пэрэдэне лэсти, соб тэ на авэл дэ театро. ");
INSERT INTO rmyservi_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Мануша, савэ стидэнепэ, выджянас годятар, колэсти со екх лэндар типисявэнас пала екхэ, ай авэр — пала аврэ. Бут манушэн на полэнас, и сости вонэ пордэ авиле. ");
INSERT INTO rmyservi_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Лэнгэрэ стидэмастар выцырдэне пэ англал Александро — када тердэ иудеи. Александро сикавда манушэнди вастэґа, соб вонэ тэ заачен мулком, и камля тэ отрисарэ пэстар лэнгэрэ лава. ");
INSERT INTO rmyservi_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Нэ кала всавэрэ уджянгле, со вов исин иудеи, упалэ ачиле фартэ тэ типисявэ: — Бари исин Артемида Эфесохкири! И типисявэнас паша дуй чясуря. ");
INSERT INTO rmyservi_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Тунчи екх форохкэрэ пхурэдэрэндар ачиля тэ улэ лэн тай пхэнда: — Эфесянуря, чи на джянэл всавири люмля, со дэ форо Эфесо прыдыкхэн пала храмо, тев тэлён баря Артемидати тай свэнтонэ барэсти, саво тэлэдэня болыбнастар? ");
INSERT INTO rmyservi_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Калэсти нико на запхэнэла. Важ кода тумэнди трэбуни тэ улэпэ тай тэ на терэ бибахт. ");
INSERT INTO rmyservi_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Тумэ андэ кордэ манушэн, нэ ни екх лэндар на обчёрда храмо тай на пхэнда бибахтало лав пэ амаря дэвля. ");
INSERT INTO rmyservi_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","А сар исин Димитриестэ и аврэ бутярнэндэ пав кадэва рындо, дэ со лэн тэ дошарэ, тунчи амэндэ исин сындуря тай проконсулы. Котэ пхэнэн, со исин тумэндэ екх пэ екхэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Кала исин тумэндэ, со тэ пхуче, мэк роздыкхэн када дэ упхэнимахкоро стидэмо. ");
INSERT INTO rmyservi_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Тэ на дошарэн амэн авдивэ, со терах ваздимо, и амэнди на авэла, со тэ пхэнах. Кадэла лавэнца вов розмукля лэнгоро стидэмо. ");
INSERT INTO rmyservi_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Кала ваздимо пэрэачиля, Павло акхарда сиклярнэн, подрицарда лэн, тунчи розачиляпэ лэнца тай джиля дэ Македония. ");
INSERT INTO rmyservi_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Кала Павло проджялас авэр пхуя, вов бутэ лавэнца подрицарэлас патякунэн. Тунчи вов авиля дэ Греция ");
INSERT INTO rmyservi_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","тай просля котэ трин чёна. Кала вов стидэняпэ тэ ладэ пав пане дэ Сирия, иудея камле тэ умарэ лэ. Нэ вов уджянгля пала када тай прылиля дэ гындо тэ рисявэ пав Македония. ");
INSERT INTO rmyservi_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Лэґа сле Сопатро, Пиррохкоро чяво, Вериятар, фессалоникийцуря Аристархо тай Секундо, Гаий Дервиятар тай Тимофеи, Тихико тай Трофимо Цыкня Азиятар. ");
INSERT INTO rmyservi_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Вонэ джиле англал и дожутярэнас амэн дэ Троада. ");
INSERT INTO rmyservi_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Кала проджиля сырботори, саво акхарэлпэ Биквасно мандро, амэ сле дэ Филиппы. Тунчи лагле котарь пав пане. Проджиля панч дивэ тай амэ дыкхлепэ лэнца дэ Троада. Котэ амэ просле эфта дивэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Дэ перво куркэхкоро диво амэ стидэнепэ їтханэ, соб тэ пхагэ мандро. Павло дэдумэлас лэнца. И кади сар вов камля пэ авэр диво тэ джя дэ дром, лэхкири дума зацырдэняпэ ды епашрят. ");
INSERT INTO rmyservi_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Дэ упралуни цэра, тев амэ стидэнепэ, пхабонас бут лампы. ");
INSERT INTO rmyservi_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Пэ фэлястра бэшля тэрно мануш пав лавэ Евтихо. Нэ сар Павло бут вряма дэдумэлас, Евтихо засута тай тэлэдэня пэ пхув барэ вучимастар. Кала лэ подлиле, вов сля муло. ");
INSERT INTO rmyservi_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Павло змукляпэ тэлэ, пэля упрал пэ тэрнэ манушэ и облиля лэ. — На пэрэджювэн! — пхэнда Павло. — Вов джювдо! ");
INSERT INTO rmyservi_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Тунчи подваздэняпэ упрал, пхагля мандро и ачиля тэ ха. Вов дэдумэлас ды дэнзор, ай тунчи джиля дэ дром. ");
INSERT INTO rmyservi_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Тэрнэ ж манушэ отлиджялдэ цэрэ джювдэґа, и всавэрэ фартэ лошавэнас кадэлэсти. ");
INSERT INTO rmyservi_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Амэ бэшле пэ корабли тай лагле дэ Ассо, камле котарь тэ залэ Павло. Вов еджино кади прыпхэнда, колэсти со камля тэ джя пэза. ");
INSERT INTO rmyservi_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Дэ Ассо вов дыкхляпэ амэнца, амэ лиле лэ пэ корабли тай джиле дэ Митилина. ");
INSERT INTO rmyservi_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Кала амэ отджиле котарь, тунчи пэ авэр диво авиле дэ Хиосо. Проджиля инте екх диво тай авиле дэ Самосо, инте екхэ дивэсти — дэ Милето. ");
INSERT INTO rmyservi_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Павло прылиля дэ гындо тэ обджя Эфесо, соб тэ на пролиджя бут вряма дэ Цыкни Азия, колэсти со камля сигэдэр тэ авэ дэ Ерусалимо пэ Пандэшахкоро диво. ");
INSERT INTO rmyservi_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Милетостар Павло бичалда дэ Эфесо. Вов мангля пхурэдэрэн кхандирятар тэ авэн лэстэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Кала вонэ авиле, вов пхэнда лэнди: — Тумэ джянэн, сар мэ джювдом катэ тумэндэ всавири вряма англунэ дивэстар, кала авилём дэ Азия. ");
INSERT INTO rmyservi_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Мэ на слём пхутярдо и ясвэнца теравас бути Раести и на дыкхавас ни пэ всавири грыжа, сави родэнас важ ман иудея. ");
INSERT INTO rmyservi_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Мэ на умукавас нисо кодэлэстар, со б тэ авэл мишто важ тумэн, пхэнавас Лав тай сикляравас тумэн пэ гаса англа всавэрэн и пав цэрэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Мэ допхэнавас иудеенди тай греконэнди, со лэнди трэбуни тэ прыджянэ пэхкоро бэзимо англа Дэвлэ и тэ патя дэ амарэ Рае Исусо. ");
INSERT INTO rmyservi_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Екхатар лиджял ман Фано, тэ джяв дэ Ерусалимо, нэ на джянав, со котэ манца авэла. ");
INSERT INTO rmyservi_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Джянав кацик, со дэ кожно форо Свэнто Фано допхэнэл манди, со дожутярэн котэ баруно тай бари грыжа. ");
INSERT INTO rmyservi_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Нэ мэ на тховав цимин пэхкэрэ джювимасти, кацик манди тэ проджя муро дром тай тэ стерэ бути, сави дэня Рай Исусо, тэ розпхэнэ Бахтало Лав пала мищимо Дэвлэхкоро. ");
INSERT INTO rmyservi_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","И екхатар мэ джянав, со всавэрэ тумэ, каґа мэ дыкхаваспэ тай розпхэнавас пала Тхагаримо, никала будэр ман на удыкхэна. ");
INSERT INTO rmyservi_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Колэсти пхэнав тумэнди авдивэ: кала кось тумэндар мэ на авава вуджило дэ кодэлэ, ");
INSERT INTO rmyservi_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","колэсти со мэ на гаравдом ни екх лав пала всавири Дэвлэхкири воля. ");
INSERT INTO rmyservi_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Дыкхэн пала пэстэ и пала всавири кхандири, дэ савя Свэнто Фано тховда тумэн тэ чяравэн отара Дэвлэхкири, сави Вов тинда Пэсти Пэхкэрэ ратэґа тай тэ дыкхэн пала ла. ");
INSERT INTO rmyservi_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Мэ джянав, со кала уджява, тумэндэ авэна мижэ рува, савэнди на дор отара. ");
INSERT INTO rmyservi_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","И машкар тумэн авэна мануша, савэ чячимо пэрэболдэна дэ хохавимо, соб тэ улиджя сиклярнэн пала пэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Колэсти на совэн! Рапирэн, со мэ трин бэрша ясвэнца, диво тай рят на пэрэачявас тэ дэ годи кожнонэсти тумэндар. ");
INSERT INTO rmyservi_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Екхатар мэ отдав тумэн Дэвлэсти тай Лэхкэрэ мищимахкэрэ Лавэсти. И Дэвэл барярэла тумаро патявимо сиклярэла тумэн и дэла тумэнди котор машкар всавэрэн Лэхкэрэн свэнтонэн манушэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Мэ никастар на камлём тэ лэ ни рупь, ни совнак, ни їда. ");
INSERT INTO rmyservi_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Тумэ еджинэ джянэн, со мэ пэхкэрэ вастэнца затеравас пэ котор мандро и пэсти и кодэлэнди, ко манца сля. ");
INSERT INTO rmyservi_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Дэ всавэрэ мэ сикававас, со кади и тумэнди трэбуни тэ терэ бути и тэ дэ зор бизоракэрэ манушэнди тай тэ рапирэ Раехкоро Исусохкоро Лав: «Бахтало мануш, саво прылэл, нэ бахталэдэр кодэва мануш, саво дэл». ");
INSERT INTO rmyservi_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Кала Павло пхэнда када, вов тэлиля всавэрэнца пэ чянга тай помангляпэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Всавэрэ ровэнас, облэнас Павло тай чюминдэнас лэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Лэнди сля бибахт лэхкэрэ лавэндар, со на дыкхэна лэ будэр. Тунчи вонэ пролиджялдэ Павло пэ корабли. ");
INSERT INTO rmyservi_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Кала амэ розачилепэ лэнца, тунчи выджиле дэ море. И лагле ворта пэ острово Косо. Пэ авэр диво амэ авиле дэ Родосо тай котарь лагле дэ Потара. ");
INSERT INTO rmyservi_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Котэ амэ аракхле корабли, саво ладэлас дэ Финикия, бэшле пэ лэстэ и лагле дурэдэр. ");
INSERT INTO rmyservi_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Амэ облагле Кипро, ачявдэ лэ зэрвонэ ригатар тай лагле дэ Сирия. Амэ прыачиле берегостэ дэ Тиро, колэсти со котэ амарэ кораблести трэбуни сля тэ ачявэ савэсь бужэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Дэ Тиро амэ аракхле сиклярнэн и просле котэ эфта дивэ. Вонэ дэдумане Павлости Фаностар, соб вов тэ на джял дэ Ерусалимо. ");
INSERT INTO rmyservi_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Нэ кала авиля вряма, амэ лагле дурэдэр. Всавэрэ сиклярнэ, лэнгэрэ ромня тай чяворэ вылиджялдэ амэн форостар. Тай пэ берего амэ чутэ чянга и манглепэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Тунчи амэ розджилепэ лэнца тай бэшле пэ корабли, а вонэ рисиле цэрэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Амэ дурэдэр лагле пав пане тай Тиростар авиле дэ Птолемаида. Котэ амэ наисардэпэ пхралэнца и просле лэнца екх диво. ");
INSERT INTO rmyservi_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Пэ авэр диво амэ упалэ лагле дэ дром, авиле дэ Кесария тай заджиле дэ цэр Филиппостэ. Вов пхэнэлас Бахтало Лав и сля екхэґа эфта манушэндар. ");
INSERT INTO rmyservi_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Лэстэ сля штар чея. Вонэ сле напаларом тай сле англунарьки. ");
INSERT INTO rmyservi_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Амэ просле котэ бут дивэ. Тунчи Иудеятар авиля англунари пав лавэ Агаво. ");
INSERT INTO rmyservi_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Вов поджиля амэндэ, лиля Павлохкоро кущик, пхангля пэсти васта и пурэ, тай пхэнда: — Свэнто Фано пхэнэл: «Кади иудея дэ Ерусалимо спхандэна и отдэна дэ вастэн наиудеенди кодэлэ, кахкоро исин кадэва кущик». ");
INSERT INTO rmyservi_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Кала амэ ушундэ када, тунчи и амэ, и катутнэ мануша ачиле тэ мангэ Павло тэ на джял дэ Ерусалимо. ");
INSERT INTO rmyservi_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Нэ Павло пхэнда пэ кода: — Пэ со тумэ ровэн и розчинэн муро їло? Мэ лошало на кацик тэ авав спхангло, нэ и тэ мэрав дэ Ерусалимо пала Лав Рае Исусохкоро. ");
INSERT INTO rmyservi_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Кала амэ полиле, со нисо лэсти на допхэнаґа, заачиле мулком тай пхэндэ: — Мэк стерэлапэ воля Раехкири. ");
INSERT INTO rmyservi_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Тунчи амэ стидэнепэ тай лагле дэ Ерусалимо. ");
INSERT INTO rmyservi_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Амэнца джиле койсавэ сиклярнэ Кесариятар. Вонэ андэ амэн дэ цэр, тев джювда кипреянино Мнасоно, саво думут сля сиклярнэґа. Лэстэ амэ и ачилепэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Кала амэ авиле дэ Ерусалимо, пхрала прылиле амэн лошаґа. ");
INSERT INTO rmyservi_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Пэ авэр диво Павло їтханэ амэнца джиля Иаковостэ. Котэ сле всавэрэ пхурэдэра. ");
INSERT INTO rmyservi_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Павло наисардапэ лэнца и розпхэнда вса пала кода, со терда Дэвэл машкар наиудеен лэхкэрэ вастэнца. ");
INSERT INTO rmyservi_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Вонэ шундэ лэ тай лашардэ Дэвлэ. Тунчи пхэндэ Павлости: — Пхрал, ту дыкхэх скацик пхангля иудеен патине? Тай всавэрэ вонэ фартэ прырицарэнпэ Упхэнимастэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","И пала тут вонэ шундэ, со ту сиклярэх иудеен, савэ машкар наиудеендэ джювэн, тэ отджян Моисеехкэрэ Упхэнимастар. И со ту пхэнэх, тэ на обчинэн вонэ пэхкэрэн чяворэн тай тэ на джювэн кади, сар амэндэ прылито. ");
INSERT INTO rmyservi_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Со ж тэ терэ? Вонэ шунэна пала кода, со ту авилян. ");
INSERT INTO rmyservi_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Колэсти тер кода, со амэ пхэнаґа. Машкар амэн исин штар мануша, савэ дэне солах. ");
INSERT INTO rmyservi_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Лэ кадэлэн, жужарпэ лэнца и потин пала кода, соб лэнди тэ обчинэн бала пэ шэро. Тунчи всавэрэ полэна, со пала тут пхэнэн начячимо и со ту джювэх пав Упхэнима. ");
INSERT INTO rmyservi_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","А наиудеенди, савэ патине, амэ искриисардэ кади: лэнди нащи тэ ха кода, со андэ дэ жэртва дэвлорэнди, тай мас затасавдэ хулаимастар, тэ пэ рат и тэ терэ биладжявимо їрестар. ");
INSERT INTO rmyservi_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Пэ авэр диво Павло лиля пэґа кадэлэн манушэн, соб тэ жужарэпэ лэнца. Тунчи вов заджиля дэ храмо тай пхэнда, дэ сави вряма вонэ пэрэачена тэ жужарэпэ, и кала пала кожнонэ лэндар анэна жэртва. ");
INSERT INTO rmyservi_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Кала проджянас эфта дивэ, койсавэ иудея Цыкня Азиятар удыкхле Павло дэ храмо, подваздэне гроза манушэн тай схутилдэ лэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Тай типисявэнас: — Израильтянуря! Дэн амэнди зор! Кадэва мануш пав всавири люмля сиклярэл всавэрэн, соб вонэ тэ на прылэн амаро народо, амаро Упхэнимо и амаро храмо. Екхатар вов анда дэ храмо греконэн, соґа маґрисарда кадэва свэнто тхан. ");
INSERT INTO rmyservi_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ды колэ вонэ дыкхле дэ форо Павло тай эфесянино Трофимо и думисардэ, со Павло анда лэ дэ храмо. ");
INSERT INTO rmyservi_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Тунчи всаворо форо подваздэняпэ и спрастэнепэ мануша. Павло схутилдэ тай выцырдэне храмостар, и храмохкэрэ вудара екхатар затердэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Вонэ камле тэ умарэ Павло, нэ дума пала кода, со всаворо Ерусалимо подваздэняпэ, доджиля пханглякэрэ пхурэдэрэстэ дэ римско халавдэнгоро стидэмо. ");
INSERT INTO rmyservi_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Вов лиля халавдэн тай шэлякэрэ пхурэдэрэн и чутапэ манушэндэ. Кала иудея дыкхле пханглякэрэ пхурэдэрэ и халавдэн, вонэ пэрэачиле тэ марэ Павло. ");
INSERT INTO rmyservi_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Пхурэдэр поджиля, прыпхэнда тэ схутилэ Павло тай тэ спхандэ лэ донца ланчугонэнца. Вов пхучля манушэндэ, ко исин кадэва мануш и со вов терда. ");
INSERT INTO rmyservi_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Нэ мануша типисявэнас кожно пэхкоро, и пхурэдэр нисо на полэлас. Важ кода прыпхэнда тэ отлиджя Павло дэ халавдэнгоро цэр. ");
INSERT INTO rmyservi_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Кала вонэ подлэнаспэ пав лестница, мануша ачиле тэ стасавэ лэн кади, со халавдэ лиджялдэ Павло пэ вастэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Гроза манушэн джялас пала лэн тай типисявэлас: — Мэк вов мэрэл! ");
INSERT INTO rmyservi_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Паша халавдэнгоро цэр Павло пхэнда пханглякэрэ пхурэдэрэсти: — Ту дэґа манди тэ пхэнэ тути лав? — Ту джянэх греческо чиб? — пхучля пхурэдэр. ");
INSERT INTO rmyservi_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Выджял — ту на кодэва египтянино, саво надумут подваздэня манушэн тай улиджялда пала пэ дэ шуки пхув штар пхангля прахарен? ");
INSERT INTO rmyservi_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Павло пхэнда: — Мэ иудеи Тарсостар, саво дэ Киликия, мануш барэ форостар. Мангав тут, дэ манди тэ дэдумэ манушэндэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Пхурэдэр домукля кода. Тунчи Павло вщиля пэ лестница и сикавда вастэґа, соб вонэ тэ ачен мулком. Кала вонэ пэрэачиле тэ типисявэ, Павло дэдуманя пав еврейско чиб. ");
INSERT INTO rmyservi_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","— Пхралалэ тай дада! Дэн манди тэ пхэнэ, со мэ надошало. ");
INSERT INTO rmyservi_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Кала вонэ ушундэ, со вов дэдумэл пав еврейско чиб, тунчи заачиле мулком. Тай вов пхэнда: ");
INSERT INTO rmyservi_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","— Мэ иудеи, саво бэняпэ дэ Тарсо дэ Киликия, выбарярдо дэ кадэва форо паша пурэн Гамалиилостэ и сиклярдо пав чячима Упхэнимасти амарэ дадэнгоро. Мэ отдэнём еджино пэ Дэвлэхкэрэ рындости, сар и кожно тумэндар авдивэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Мэ традавас ды мэрима кодэлэн, ко джянас Исусохкэрэ Дромэґа, пхандавас муршэн тай джювлен и чувавас лэн дэ барунэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Допхэнимаря кадэлэсти — англуно рашай тай всавэрэ пхурэдэра. Мэ лилём лэндар лила пхралэндэ дэ Дамаско тай лаглём пордэ, соб тэ пхандэ кодэлэн, ко котэ сля, тай тэ анэ лэн дэ Ерусалимо и тэ мулярэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Пав дром, кала мэ слём пашэ Дамаско, дэ епашдиво, болыбнастар паша ман запхабиляпэ душлимо, пэ саво нащи сля тэ дыкхэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Мэ тэлэдэнём пэ пхув тай ушундом ґласо, саво дэдумэлас манди: «Савло, Савло! Сости ту традэх Ман?» ");
INSERT INTO rmyservi_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Мэ пхучлём: «Ко Ту, Рае?» Вов пхэнда: «Мэ Исусо Назаретостар, Савэ ту традэх». ");
INSERT INTO rmyservi_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Кодэла, ко сле манца, дыкхле душлимо, нэ ґласо, саво манца дэдуманя, вонэ на шундэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Мэ пхучлём: «Рае, со манди тэ терэ?» Рай пхэнда: «Вщи тай джя дэ Дамаско. Котэ тути пхэнэна вса, со тути трэбуни тэ терэ». ");
INSERT INTO rmyservi_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Кодэла, ко сле манца, пала васт андэ ман дэ Дамаско, колэсти со мэ корылём душлимахкэрэ пхабаримастар. ");
INSERT INTO rmyservi_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Котэ мандэ авиля мануш пав лавэ Анания, саво джювда пав Упхэнима и сля дэ патива всавэрэ катутнэ иудеендэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Вов поджиля мандэ, ачиля пашэ тай пхэнда: «Пхрал Савло! Мэк оттерэнпэ тирэ якха!» Дэ кодыя вряма мэ ачилём тэ дыкхэ и удыкхлём кадэлэ манушэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Вов пхэнда: «Дэвэл амарэ дадэнгоро вытидэня тут, соб ту тэ уджянэх Лэхкири воля, тэ удыкхэх Чячюнэ и тэ шунэх лава Лэхкэрэ уштэндар. ");
INSERT INTO rmyservi_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ту авэґа важ всавэрэн манушэн допхэнимари пала кода, со дыкхлян и шундан. ");
INSERT INTO rmyservi_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Со ту цырдэх вряма? Вщи, прыакхар Лэхкоро Лав, болдэпэ и схалав пэхкоро бэзимо». ");
INSERT INTO rmyservi_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Тунчи мэ рисилём дэ Ерусалимо. И кала мэ манглёмпэ дэ храмо, манди сля дыкхлимо. ");
INSERT INTO rmyservi_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Мэ удыкхлём Рае, Саво пхэнда манди: «Сиго выджя Ерусалимостар, колэсти со катэ на прылэна тиро допхэнимо пала Ман». ");
INSERT INTO rmyservi_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Мэ пхэндом: «Рае! Кадэла мануша джянэн, со мэ чувавас дэ барунэ и маравас дэ синагоги кодэлэн, ко патян дэ Тут. ");
INSERT INTO rmyservi_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Кала чюлиля рат Стефаностар, саво сля Тиро допхэнимари, мэ ачявас котэ и подавас ґласо пала кодэлэн, ко умарэнас лэ, и дыкхлём пала лэнгири їда». ");
INSERT INTO rmyservi_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Тунчи Рай пхэнда манди: «Джя! Мэ бичалав тут народонэндэ, савэ джювэн дурал». ");
INSERT INTO rmyservi_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ды кадэлэн лавэн мануша шунэнас Павло, нэ катэ ачиле тэ типисявэ: — Мэк вов мэрэл! Лэсти нащи тэ джювэ! ");
INSERT INTO rmyservi_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Вонэ типисиле тай розчинэнас пэхкири їда и чувэнас прахо пхуякоро упрал. ");
INSERT INTO rmyservi_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Тунчи пханглякоро пхурэдэр прыпхэнда тэ улиджя Павло дэ халавдэнгоро цэр. Вов прыпхэнда тэ марэ лэ чукненца тай тэ допхуче, соб тэ уджянэ, сости мануша кади мижон пэ лэстэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Нэ кала Павло прыпхангле, соб тэ марэ, вов пхэнда шэлякэрэ пхурэдэрэсти, саво ачелас пашэ: — Чи мишто авэла тэ марэ римсконэ манушэ, ай тэ на пролиджя пав лэ сындо? ");
INSERT INTO rmyservi_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Кала шэлякоро пхурэдэр шунда када, вов джиля тай пхэнда пханглякэрэ пхурэдэрэсти: — Со ту терэх? Када римско мануш! ");
INSERT INTO rmyservi_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Пханглякоро пхурэдэр выджиля Павлостэ тай пхучля: — Ту римско мануш? — Нэ, — пхэнда кодэва. ");
INSERT INTO rmyservi_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Тунчи пхурэдэр пхэнда: — Мэ потиндом бут ловэ пала кода, соб тэ аче римсконэ манушэґа. — Ай мэ бэнимастар римско мануш, — пхэнда Павло. ");
INSERT INTO rmyservi_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Кодэла, савэ камле тэ допхуче лэ, екхатар отджиле лэстар. Кала пхурэдэр уджянгля, со пхангля ланчукоґа римсконэ манушэ, вов фартэ пэрэдаравдапэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Пэ авэр диво пхурэдэр закамля тэ уджянэ ды лавэ, дэ со иудея дошарэн Павло. Тунчи розпхангля лэ и прыпхэнда, соб тэ стидэнпэ англунэ рашая и всаворо Синедрионо. Тунчи анда Павло и тховда англа лэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Павло вхаляпэ якхэнца пэ кодэлэн, ко сля дэ Синедрионо, тай пхэнда: — Пхралалэ! Ды авдивутно диво мэ всавэрэ їлэґа теравас бути Дэвлэсти. ");
INSERT INTO rmyservi_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Катэ англуно рашай Анания прыпхэнда кодэлэнди, ко ачелас пашэ, тэ марэ Павло пав уштэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Тунчи Павло пхэнда: — Дэвэл тут марэла, мануш домуенгоро! Ту бэшэх катэ, соб тэ сундисарэ ман пав Упхэнима. А еджино пэрэхукэх Упхэнимо, кала прыпхэнэх ман тэ марэ! ");
INSERT INTO rmyservi_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Кодэла, савэ аченас паша Павло, пхэнда лэсти: — Сости ту кошэх англунэ рашае? ");
INSERT INTO rmyservi_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Павло пхэнда: — Пхралалэ, мэ на джянавас, со вов англуно рашай. Колэсти со искриисардо: «На дэдумэ бибахт пала пхурэдэрэ тирэ народостар». ");
INSERT INTO rmyservi_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Павло джянгля, со дэ Синедрионо екх лэндар сле саддукея, ай авэр — фарисея. Колэсти вов зоралэ ґласоґа пхэнда: — Пхралалэ, мэ фарисеи, чяво фарисеехкоро. Ман сундисарэн пала кода, со мандэ исин надия пэ отджюндивимо мулэндар. ");
INSERT INTO rmyservi_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Кала вов када пхэнда, машкар фарисея тай саддукея ваздэняпэ баро гвалто, тай всавэрэ розджилепэ дэ дума. ");
INSERT INTO rmyservi_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Саддукея пхэнэн, со нэнай ни отджюндивимо, ни ангелонэн, ни фано, нэ фарисея патян, со када вса исин. ");
INSERT INTO rmyservi_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ваздэняпэ баро типимо, койсавэ сиклимаря пав Упхэнима фарисеендар вщиле тай пхэндэ: — Амэ на аракхах дэ кадэлэ манушэ нисави дош. Со, кала лэсти дэдумэлас фано чи ангело? ");
INSERT INTO rmyservi_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Гвалто фартэ розпхабиляпэ, и пханглякоро пхурэдэр пэрэдаравдапэ, со Павло розчинэна поепаш. Вов прыпхэнда халавдэнди тэ залэ лэ котарь зораґа тай тэ отлиджя дэ халавдэнгоро цэр. ");
INSERT INTO rmyservi_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Пэ авэр рят англа Павло ачиля Рай тай пхэнда: — На дара! Сар ту допхэнэґас пала Ман дэ Ерусалимо, кади авэґа тэ допхэнэ дэ Римо. ");
INSERT INTO rmyservi_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Дэнзор койсавэ иудея стидэнепэ тай лиле солах нисо тэ на хан и тэ на пэн ды колэ, сар умарэна Павло. ");
INSERT INTO rmyservi_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Кади здэдуманепэ пашэ саранда манушэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Вонэ джиле англунэ рашаендэ тай пхурэдэрэндэ и пхэндэ: — Амэ солахане нисо тэ на ха и тэ на пэ ды колэ, сар умараґа Павло. ");
INSERT INTO rmyservi_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Кана тумэ тай Синедрионо помангэн пханглякэрэ пхурэдэрэ тэ анэ лэ тумэндэ, соб пашэ тэ роздыкхэ кадэва рындо. Ай амэ стидаґапэ тай умараґа лэ инте ды колэ, сар вов доджяла кадэлэ тханэстэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Пала лэнгири дума уджянгля Павлохкиря пхэнякоро чяво. Вов джиля дэ халавдэнгоро цэр тай розпхэнда када Павлости. ");
INSERT INTO rmyservi_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Тунчи Павло акхарда екхэ шэлякэрэ пхурэдэрэндар и пхэнда лэсти: — Отлиджян кадэлэ чявэ пханглякэрэ пхурэдэрэстэ, лэстэ исин койсо тэ пхэнэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Шэлякоро пхурэдэр отлиджялда чявэ пханглякэрэ пхурэдэрэстэ тай пхэнда: — Павло, савэ амэ схутилдэ, акхарда ман тай помангля тэ анэ тутэ кадэлэ чявэ. Лэстэ исин койсо тути тэ пхэнэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Пханглякоро пхурэдэр лиля чявэ пала вастэ, отлиджялда дэ рига тай пхучля: — Со ту камэх манди тэ розпхэнэ? ");
INSERT INTO rmyservi_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Чяво пхэнда: — Иудея прылиле дэ гындо тэ мангэ тут, соб ту тэ анэх атася Павло дэ Синедрионо. Вонэ пхэнэн, со камэн будэр тэ уджянэ пала лэхкоро рындо. ");
INSERT INTO rmyservi_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Нэ ту на патя кадэлэсти, колэсти со пэ дром чёрял дожутярэн лэ саранда манушэн. Вонэ солахане тэ на ха тай тэ на пэ ды колэ, сар умарэна Павло. Важ када лэндэ вса исин. Вонэ дожутярэн кацик лав тутар. ");
INSERT INTO rmyservi_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Пханглякоро пхурэдэр отмукля чявэ тай прыпхэнда лэсти: — Никасти на розпхэн пала кода, со ту пхэндан манди. ");
INSERT INTO rmyservi_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Тунчи пханглякоро пхурэдэр акхарда дон шэлякэрэн пхурэдэрэн и прыпхэнда лэнди: — Стидэн дуй шэла халавдэн, эфтадэша анклистарен тай дуй шэла аврэн халавдэн, соб вонэ тэ джян дэ Кесария, сар авэла еня чясо рятяґа. ");
INSERT INTO rmyservi_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Дэн Павлости грастэ тай дыкхэн, соб лэґа тэ на авэл бибахт. И отлиджян лэ барэдэрэстэ Феликсостэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Тунчи вов искриисарда кацаво лил: ");
INSERT INTO rmyservi_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«Клавдии Лисии Пативалэ барэдэрэсти Феликсости: Тэ авэх бахтало! ");
INSERT INTO rmyservi_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Кадэлэ манушэ схутилдэ иудея тай камле тэ умарэ. Нэ мэ поджилём халавдэнца и выхутилдом лэ лэнгэрэ вастэндар, сар уджянглём, со вов римско мануш. ");
INSERT INTO rmyservi_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Мэ закамлём тэ уджянэ, дэ со вонэ дошарэн лэ, тай андом лэ дэ лэнгоро Синедрионо. ");
INSERT INTO rmyservi_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Мэ полилём, со вонэ дошарэн лэ важ лэнгоро Упхэнимо. И со лэ ни пала со тэ мулярэ чи тэ чувэ дэ барунэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Мэ уджянглём, со лэ камэн чёрял тэ умарэ, и екхатар отбичалдом лэ тутэ. И прыпхэндом, соб лэ тэ дошарэн англа тут». ");
INSERT INTO rmyservi_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Халавдэ тердэ, сар вов прыпхэнда, лиле Павло тай лиджялдэ рятяґа дэ Антипатрисо. ");
INSERT INTO rmyservi_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Пэ авэр диво анклистаря лагле Павлоґа дурэдэр, ай кодэла, ко джянас пэза, рисиле дэ Ерусалимо. ");
INSERT INTO rmyservi_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Кала анклистаря авиле дэ Кесария, вонэ отдэне барэдэрэсти лил тай пэрэдэне лэсти Павло. ");
INSERT INTO rmyservi_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Барэдэр продинда лил тай пхучля Павло, савя вов пхуятар. Кала вов уджянгля, со Павло Киликиятар, ");
INSERT INTO rmyservi_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","тунчи пхэнда: — Мэ вышунава тут, кала авэна кодэла, ко дошарэнас тут, — тай прыпхэнда, соб халавдэ тэ аракхэн тхан Павлости дэ райкано цэр, саво терда тхагари Иродо, тай тэ рицарэн лэ котэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Проджиля панч дивэ, и англуно рашай Анания койсавэ пхурэдэрэнца тай манушэґа пав лавэ Тертулло, саво розлэласпэ дэ римско упхэнима, авиля дэ Кесария, соб тэ дошарэ Павло англа барэдэрэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Кала Павло андэ, Тертулло ачиля тэ дошарэ лэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","— Пативало Феликсо! Наис тути пала пачя, сави ту дэх амэнди и пала кода, со тердан важ амарэн манушэн пэхкиря баря годяґа. ");
INSERT INTO rmyservi_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Соб бут тэ на зарицарах тут, мэ мангав тэ дэх амэнди набут вряма и тэ вышунэх амэн пав тирэ мищима. ");
INSERT INTO rmyservi_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Амэ бинах кадэлэ мануш бидаґа дэ амари пачя. Вов подваздэл иудеен пав всавири люмля тай исин пхурэдэр дэ назариенгоро стидэмо. ");
INSERT INTO rmyservi_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","7","Вов камля тэ маґрисарэ храмо, нэ амэ схутилдэ лэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Кала ту допхучеґа лэ, ту еджино уджянэґа пала вса, дэ со амэ лэ дошарах. ");
INSERT INTO rmyservi_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Иудея ж подрицардэ лэ тай пхэндэ, со лэхкэрэ лава исин чячимо. ");
INSERT INTO rmyservi_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Барэдэр сикавда Павлости, соб вов тэ пхэнэл. И Павло пхэнда: — Мэ джянав, со ту бут бэрша сундисарэх амаро народо. Колэсти лошало тэ пхэнэ лав англа тут, соб тэ сикавэ пэхкоро чячимо. ");
INSERT INTO rmyservi_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Тути напхаро авэла тэ уджянэ, со пашэ дэшудуй дивэ павпалэ мэ авилём тэ тэлё дэ Ерусалимо. ");
INSERT INTO rmyservi_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Кодэла, савэ дошарэн ман, на дыкхле, соб мэ хаваспэ каґась дэ храмо чи подваздавас манушэн дэ синагоги чи дэ форо. ");
INSERT INTO rmyservi_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Лэндэ на выджяла тэ допхэнэ кода, пала со вонэ дошарэн ман. ");
INSERT INTO rmyservi_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Мэ прыджянав, со джяв чячюнэ Дромэґа, саво вонэ акхарэн хохавимаґа. Мэ тэлював Дэвлэсти амарэ дадэнгоро и патяв всавэрэсти, со искриисардо дэ Упхэнима тай дэ Англунарен. ");
INSERT INTO rmyservi_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Мандэ кади ж исин надия пэ Дэвлэ, сар и кадэлэ манушэндэ. Надия пэ кода, со отджювдёна мулэндар сар патякунэ, кади ж напатякунэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Колэсти прытховав всавири зор, соб муро їло всавири вряма тэ авэл жужо англа Дэвлэ и англа манушэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Набут бэршэн мэ на слём дэ Ерусалимо, ай тунчи авилём пордэ, соб тэ пэрэдэ мурэ народости даро важ чёрорэн и тэ анэ жэртвы. ");
INSERT INTO rmyservi_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Вонэ аракхле ман дэ храмо, кала мэ жужараваспэ. Нэ котэ на сля нисави гроза манушэн тай нисаво гвалто. ");
INSERT INTO rmyservi_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Тунчи авиле койсавэ иудея Цыкня Азиятар. Акэ лэнди трэбуни сля тэ авэ катэ, соб тэ дошарэ ман, кала лэндэ сось исин пэ ман. ");
INSERT INTO rmyservi_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Чи мэк кодэла, ко исин катэ, пхэнэна, сави дош вонэ аракхле дэ ман, кала ман допхучелас Синедрионо. ");
INSERT INTO rmyservi_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Чи мэ дошало дэ кодэлэ, со типисилём: «Ман сундисарэн пала кода, со мэ патяв дэ отджюндивимо мулэндар»? ");
INSERT INTO rmyservi_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Феликсо, саво мишто джянэлас пала Дром, оттховда кадэва рындо. — Мэ пхэнава лав пав тумаро рындо, кала авэла пханглякоро пхурэдэр Лисии, — дэдуманя вов. ");
INSERT INTO rmyservi_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Вов прыпхэнда шэлякэрэ пхурэдэрэсти, соб халавдэ тэ дыкхэн пала Павло, нэ и тэ дэн лэсти набут воля и тэ на запхэнэн лэхкэрэ амалэнди тэ лашарэ лэхкэрэ рындуря. ");
INSERT INTO rmyservi_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Проджиля набут дивэ, тай Феликсо авиля пэхкиря ромняґа, сави сля иудеянка пав лавэ Друзилла, и бичалда пала Павло, соб тэ пошунэ пала лэхкоро патявимо дэ Исусо Христо. ");
INSERT INTO rmyservi_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Кала Павло ачиля тэ дэдумэ пала джювимо пав чячима, пала кода, со трэбуни мишто тэ дыкхэ пала пэ и пала сындо, саво авэла, Феликсо пэрэдаравдапэ тай пхэнда: — Хутилэла пэ авдивэ, джя! Сар трэбуни авэла, мэ тут акхарава. ");
INSERT INTO rmyservi_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Лэстэ кади ж сля надия, со Павло дэла лэсти ловэ. Колэсти бут вов молы прыпхэнэлас тэ анэ Павло тай дэдумэлас лэґа. ");
INSERT INTO rmyservi_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Проджиля дуй бэрша, тай пэ Феликсохкоро тхан ачиля Порции Фесто. Нэ Феликсо ачявда Павло дэ барунэ, соб тэ терэ мишто иудеенди. ");
INSERT INTO rmyservi_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","И кади, трин дивэнди Фесто авиля дэ кодыя пхув. Тунчи лиля дром Кесариятар дэ Ерусалимо, ");
INSERT INTO rmyservi_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","тев англунэ рашая тай иудеенгэрэ пхурэдэра сикавдэ дош пэ Павло. ");
INSERT INTO rmyservi_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Вонэ фартэ мангле Фесто, соб вов тэ тховэл пэ лэн патив тай тэ пэрэлиджял Павло дэ Ерусалимо. Еджинэ вонэ камле тэ стидэпэ тай тэ умарэ Павло пав дром. ");
INSERT INTO rmyservi_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Фесто пхэнда: — Пала Павло дыкхэн халавдэ дэ Кесария. И мэ сиго котэ авава. ");
INSERT INTO rmyservi_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Мэк тумарэ пхурэдэра джяна манца и сикавэна дош пэ лэстэ, кала вов терда сось налачё. ");
INSERT INTO rmyservi_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Фесто сля лэнца пашэ охто чи дэш дивэ, ай тунчи рисиля дэ Кесария. Пэ авэр диво вов бэшля пэ сундисарехкоро тхан тай прыпхэнда тэ анэн Павло. ");
INSERT INTO rmyservi_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Кала Павло авиля, иудея, савэ авиле Ерусалимостар, ачиле тэ дошарэ лэ дэ бутэн пхарэн рындонэн, нэ тэ допхэнэ када лэндэ на выджялас. ");
INSERT INTO rmyservi_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Павло ж камля тэ сикавэ пэхкоро чячимо тай пхэнда: — Мэ на пэрэхуклём иудеенгоро Упхэнимо, и нисо на тердом ни храмости, ни императости. ");
INSERT INTO rmyservi_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Фесто камля тэ дэ патив иудеенди, колэсти пхучля Павлостар: — Камэх тэ джя дэ Ерусалимо, соб котэ тут тэ сундисарэн пры ман? ");
INSERT INTO rmyservi_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Павло пхэнда: — Мэ ачяв англа сындо императохкоро, и лэґа трэбуни тэ авав сундисардо. Мэ на тердом иудеенди нисо налачё, сар ту еджино джянэх. ");
INSERT INTO rmyservi_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Кала мэ прахари и затердом мэримо, мэк авэл кади. Нэ кала иудея дошарэн ман ивья, никастэ нэнай зор тэ выдэ ман лэнди. Мэк ман сундисарэл императоро! ");
INSERT INTO rmyservi_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Фесто дэдуманя пэхкэрэ стидэмаґа тай пхэнда: — Кала мангэх сындо императохкоро, джяґа императостэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Проджиля набут дивэ, тай дэ Кесария тэ ваздэ патив Фестости авиле тхагари Агриппа тай лэхкири ромни Берника. ");
INSERT INTO rmyservi_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Вонэ сле котэ койсавэ дивэ, тай Фесто дэдумэлас тхагареґа пала Павлохкоро рындо. — Катэ исин екх мануш, савэ Феликсо ачявда дэ барунэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Кала мэ слём дэ Ерусалимо, иудеенгэрэ рашая тай пхурэдэра сикавдэ пэ лэстэ дош. Вонэ мангле тэ сундисарэ лэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Мэ пхэндом лэнди, со римсконэ манушэндэ на прылито тэ отдэ манушэ дэ вастэн кодэлэнди, ко лэ дошарэн, кала вов майанглал на дыкхэлапэ лэнца тай на допхэнэла, со вов надошало. ");
INSERT INTO rmyservi_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Вонэ авиле манца кордэ, и мэ пэ авэр диво бэшлём пэ сундисарехкоро тхан тай прыпхэндом тэ анэн кордэ кадэлэ манушэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Вонэ ачиле паша лэ, нэ нисо на тердэ, соб тэ долиджя лэхкири дош хоть дэ екх налачё рындо, пала саво мэ думисаравас. ");
INSERT INTO rmyservi_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Нэ машкар лэн сля гвалто пала кода, сар трэбуни тэ тэлё Дэвлэсти, тай пала Исусо, Саво муля, нэ пала Савэ Павло пхэнда, со Вов джювдо. ");
INSERT INTO rmyservi_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Мэ на джянглём, сар манди тэ роздыкхэ кадэва рындо. Тай пхучлём Павлостар, чи камэл вов тэ джя дэ Ерусалимо тай тэ прылэ котэ сындо. ");
INSERT INTO rmyservi_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Павло закамля, соб лэхкоро рындо тэ роздыкхэл императоро. И мэ прыпхэндом тэ рицарэ лэ дэ барунэ ды колэ, сар отбичалава лэ императостэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Агриппа пхэнда Фестости: — И мэ камав тэ пошунэ кадэлэ манушэ. — Атася шунэґа, — пхэнда Фесто. ");
INSERT INTO rmyservi_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Пэ авэр диво Агриппа тай Берника барэ пхутимаґа заджиле дэ цэра сындохкири. Лэнца сле пханглякэрэ пхурэдэра тай пативалэ мануша кодэлэ форостар. Фесто прыпхэнда, соб тэ анэн Павло. ");
INSERT INTO rmyservi_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Тунчи Фесто пхэнда: — Тхагари Агриппа и всавэрэ, ко катэ исин! Тумэ дыкхэн манушэ, пала савэ гроза иудеен анэнас дош манди дэ Ерусалимо тай катэ дэ Кесария и типисиле, со лэсти нащи тэ джювэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Мэ ж на аракхав дэ лэ нисави дош, пала сави лэ трэбуни тэ умарэ. Нэ сар вов мангля императохкоро сындо, мэ тховдом дэ гындо тэ отбичалэ лэ дэ Римо. ");
INSERT INTO rmyservi_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Нэ мандэ нэнай нисо пэ кадэлэ манушэ, соб тэ искриисарав раести. Колэсти мэ вылиджялдом лэ тумэндэ, и англал всавэрэстар тутэ, тхагари Агриппа, соб ту тэ допхучех лэ тай мэ тэ джянав, со манди тэ искриисарэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Мэ думисарав, со на пав чячима тэ бичалэ барунаре и тэ на пхэнэ, дэ со исин лэхкири дош. ");
INSERT INTO rmyservi_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Агриппа пхэнда Павлости: — Мишто, дэдумэ пала пэ. Павло подлиля васт и ачиля тэ дэдумэ: ");
INSERT INTO rmyservi_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","— Тхагари Агриппа! Мэ бахтало тэ допхэнэ англа тут пэхкоро чячимо, кала ман дошарэн иудея. ");
INSERT INTO rmyservi_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Ту ж мишто джянэх, со прылито иудеендэ тай кода, пала со вонэ ханпэ екх екхэґа. Колэсти фартэ мангав тут, соб ту тэ на холявэх, нэ тэ шунэх ман. ");
INSERT INTO rmyservi_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Иудея мишто джянэн, сар мэ джювдом машкар мурэн манушэн дэ Ерусалимо тэрнэ бэршэндар. ");
INSERT INTO rmyservi_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Вонэ дэмут джянэн ман. И кала закамэна, допхэнэна, со мэ джювдом сар фарисеи тай слём стидэмастар, тев всавири зор прытховэнас, соб тэ терэ пав Упхэнима. ");
INSERT INTO rmyservi_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Авдивэ мэ ачяв англа сындо пала надия пэ Дэвлэхкоро Лав, саво Дэвэл дэня амарэ дадэнди. ");
INSERT INTO rmyservi_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Дэшудуй чянга амарэ народостар диво тай рят терэн бути Дэвлэсти тай дожутярэн, кала заджяла дэ зор кадэва Лав. Пала кадыя надия, тхагари, ман дошарэн иудея. ");
INSERT INTO rmyservi_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Сости тумэ на патян, со Дэвэл отджювдярэл мулэн? ");
INSERT INTO rmyservi_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Мэ кади ж на прылавас Лав Исусохкоро Назаретостар тай мараваспэ кадэлэ сикляримаґа. ");
INSERT INTO rmyservi_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Када мэ теравас дэ Ерусалимо, кала манди дэне лачимо англунэ рашая. Мэ бичалавас дэ барунэ бутэн свэнтонэн и, кала лэн умарэнас, подавас пала кода пэхкоро ґласо. ");
INSERT INTO rmyservi_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Мэ бут маравас лэн дэ всавэрэ синагоги, соб вонэ тэ отпхэнэнпэ пэхкэрэ патявимастар. И кади мижылём пэ лэн, со традавас лэн и дэ авэр форуря. ");
INSERT INTO rmyservi_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Екхвар мэ ладавас дэ Дамаско пав кадэва рындо зораґа тай прыпхэнимаґа англунэ рашаендар. ");
INSERT INTO rmyservi_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Тай пав дром пордэ, тхагари, мэ удыкхлём дэ епашдиво душлимо болыбнастар, саво пхаболас зоралэдэр кхамэстар. И дэ кодэва душлимо попэлём и мэ, и кодэла мануша, савэ сле манца. ");
INSERT INTO rmyservi_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Амэ всавэрэ тэлэдэне пэ пхув, тай мэ ушундом ґласо, саво дэдумэлас манди пав еврейско чиб: «Савло, Савло, сости ту традэх Ман? Пхаро тути пэ Ман тэ выджя». ");
INSERT INTO rmyservi_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Мэ пхучлём: «Ко Ту, Рае?» — «Мэ Исусо, Савэ ту традэх, — пхэнда Рай. — ");
INSERT INTO rmyservi_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Ваздэпэ, вщи пэ пурэн тирэн. Мэ авилём, соб тэ терэ тут Мурэ бутярнэґа и допхэнимареґа пала кода, со ту дыкхлян и со Мэ терава англа тирэ якха. ");
INSERT INTO rmyservi_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Мэ фирисарава тут тирэ манушэндар тай наиудеендар, савэндэ Мэ тут бичалав, ");
INSERT INTO rmyservi_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","соб тэ оттерэ лэнди якха и тэ рисарэ лэн калимастар душлимастэ, и сатанастар тай лэхкиря зоратар тэ рисарэ лэн Дэвлэстэ. Соб лэнгоро бэзимо тэ авэл отмукло и соб вонэ кади ж тэ авэн машкар кодэлэн, ка Мэ свэнтисардом патявимаґа дэ Ман». ");
INSERT INTO rmyservi_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Тхагари Агриппа, манди нащи сля тэ на кандэ болыбнахкэрэ дыкхлима. ");
INSERT INTO rmyservi_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Мэ пхэнавас лав майанглал кодэлэнди, ко сля дэ Дамаско, тунчи дэ Ерусалимо тай пав всавири Иудея. Ай тунчи наиудеенди, тэ ачявэн вонэ бэзимо тай тэ обрисявэн Дэвлэстэ, тэ допхэнэн пэхкэрэ рындонэнца, со чячимаґа ачявдэ бэзимо. ");
INSERT INTO rmyservi_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Пала када иудея схутилдэ ман дэ храмо и камле тэ умарэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Нэ Дэвэл ды авдивэ дэл зор манди. Тай акэ, мэ ачявэ катэ тай допхэнав цыкнэнди и барэнди. Мэ на прытховав нисо кодэлэстэ, со пхэндэ Моисеи тай англунаря. ");
INSERT INTO rmyservi_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Нэ пхэнав, со Христости сля трэбуни тэ пэрэлиджя кадыя грыжа, пэрвонэсти тэ отджювдё мулэндар и тэ пхэнэ пала душлимо и амарэ манушэнди, и наиудеенди. ");
INSERT INTO rmyservi_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Кала вов кади допхэнэлас пала пэ, Фесто обчинда лэхкоро лав. — Ту на дэ пэхкиря годя, Павло, — затиписиля вов, — баро їрвалимо терэл тут динилэґа! ");
INSERT INTO rmyservi_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Павло пхэнда: — Пативало Фесто, мэ на динило. И кода, со мэ пхэнав, исин чячимо тай годявэримо. ");
INSERT INTO rmyservi_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Тхагари, англа савэ мэ пхэнав бидаракоро, джянэл пала када. Нисо кадэлэстар на гаравдо важ лэ, колэсти со терэласпэ всавэрэндэ пэ якхэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Тхагари Агриппа, ту патях англунаренди? Мэ джянав, со патях. ");
INSERT INTO rmyservi_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","— Ту думисарэх пала кадыя скурто вряма тэ терэ кади, соб мэ тэ авав христианино? — пхэнда Агриппа. ");
INSERT INTO rmyservi_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Павло дэдуманя: — Сави б кадыя вряма тэ на авэл, скурто чи лунго, мэ мангавпэ Дэвлэсти, соб на кацик ту, нэ и всавэрэ, ко шунэл ман авдивэ, тэ авэн кацавэ, сар мэ, кици тэ на прылэн кадэла ланчугуря. ");
INSERT INTO rmyservi_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Тхагари вщиля тай лэґа вщиле барэдэр, Берника тай кодэла, савэ бэшэнас лэнца. ");
INSERT INTO rmyservi_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Вонэ выджиле тай дэдумэнас екх екхэсти: — Кадэва мануш на терда нисо, соб тэ умарэ лэ чи тэ чувэ дэ барунэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","— Лэ б фэдэр тэ отмукэ пэ воля, нэ вов помангля сындо императохкоро, — пхэнда Агриппа Фестости. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Кала сля пхэндо, со амэ ладах дэ Италия, Павло и аврэн барунарен пэрэдэне шэлякэрэ пхурэдэрэсти пав лавэ Юлии, императохкэрэ халавдэнгэрэ стидэмастар. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Амэ бэшле пэ адрамитско корабли, савэсти трэбуни сля тэ заджя дэ портуря пав Цыкни Азия, тай лагле. Амэнца сля македонянино Аристархо, саво бариля дэ Фессалоника. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Пэ авэр диво амэ авиле дэ Сидоно. Юлии сикавда дорымо Павлостэ тай отмукля лэ, соб вов тэ спхирэл пэхкэрэ амалэндэ и соб вонэ тэ лашарэн лэхкэрэ рындуря. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Тунчи амэ упалэ выджиле дэ море тай проджиле Кипро кодэла ригатар, тев на пхурдэлас балвал. А кала на кади, балвал бы пхурдэлас ворта пэ амэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Амэ пэрэлагле море паша пхувен дэ Киликия тай Памфилия и ачиле дэ форо Мира, саво дэ Ликия. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Котэ шэлякоро пхурэдэр аракхля корабли Александриятар, саво джялас дэ Италия, тай тховда амэн пэ лэстэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Бут дивэн амэ полокхэ ладаґас англал. Сля фартэ пхаро тэ ладэ, нэ амэ авиле дэ Книдо. Важ кода со балвал на дэлас амэнди тэ ладэ, амэ подлагле Критостэ кодэла ригатар, тев на пхурдэлас балвал, пашэ Салмони. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Амэнди сля фартэ пхаро тэ ладэ паша берего, нэ амэ авиле дэ тхан, саво акхарэлпэ Лаче Пристани, надур форостар Ласея. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Амэ хасардэ бут вряма и нащи сля тэ ладэ пав пане дурэдэр, соб тэ на хасявэ, колэсти со проджиля иудеенгоро посто. Тунчи Павло подпхэнда: ");
INSERT INTO rmyservi_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","— Мэ дыкхав, со тэ ладэ дурэдэр авэла фартэ пхаро. И на кицик мищимо пэ корабли хасявэла, нэ хасяваґа и амэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Нэ шэлякоро пхурэдэр на кандэня Павло, ай кандэня кодэлэ, ко лиджялас корабли тай кораблехкэрэ хулае. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ай сар дэ кодэва форо нащи сля тэ пэрэмарэ ївэнд, бут манушэн прылиле дэ гындо, со трэбуни тэ ладэ котарь и тэ авэ дэ Финиксо, тхан пэ Крито, тев заджянас бут корабли, и саво сля оттердо пэ юго тай северо-западо, соб тэ ачепэ котэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Пхурдэня южно балвал тай бутярнэ кораблестар прылиле дэ гындо, со када лэнди трэбуни. Тунчи ваздэне якори тай лагле паша Критохкоро берего. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Проджиля набут вряма тай пхурдэня бари северно-восточно балвал, сави акхарэлпэ Эвракилоно. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Амэндэ на сля зора тэ ладэ дэ кодыя риг, тев пхурдэлас балвал, колэсти балвал порисарда корабли тай ачиля тэ традэ лэ. Тунчи амэ отдэнепэ кодэлэсти, со авэла, тай балвал традэня корабли пав пане. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Амэ подлагле островостэ, саво акхардапэ Кавда. Котэ амэндэ баря зораґа выджиля тэ фирисарэ лодка. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Кала ла подлиле пэ корабли, бутярнэ змукле доря кораблестар тай обпхангле лэ. Вонэ дарэне тэ заджя дэ Сирто, тев набут пани, колэсти обмукле парусо тай балвал дурэдэр лиджялас амэн пав пане. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Бари балвал кади чувэлас корабли дэ рига, со пэ авэр диво вонэ ачиле тэ вычувэ бужэ кораблестар. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Пэ трито диво вонэ пэхкэрэ вастэнца вычутэ дэ пани и вса авэр, со ачиляпэ пэ корабли. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Койсавэ дивэ на душолас ни кхам, ни чергэня, тай зорали балвал пхурдэлас. Амэ хацардэ надия, со фирисаґапэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Мануша бут вряма нисо на хале. Тунчи Павло вщиля машкар лэн тай пхэнда: — Тумэнди трэбуни сля тэ кандэ ман тай тэ на выладэ Критостар. Тунчи б тумэ на прылиле кадыя грыжа и на хацардэ б амарэ бужэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Нэ кана пхэнав тумэнди, соб тумэ тэ лошавэн. Нико тумэндар на хасявэла, кицик корабли розмарэлапэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Кодэла рятяґа мандэ авиля ангело Дэвлэстар, Кахкоро мэ исин и Касти терав бути. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Вов пхэнда манди: «Павло, на дара! Тути трэбуни тэ аче англа императоро. Акэ, Дэвэл отдэня тути всавэрэн, ко ладэл туґа». ");
INSERT INTO rmyservi_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Колэсти лошавэн! Мэ патяв Дэвлэсти. Вса авэла кади, сар манди пхэндо. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Корабли вычувэла пэ савось острово. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Пэ дэшуштарто диво, кала амэн инте чувэлас пав Адриатическо море, дэ епашрят бутярнэ кораблестар полиле, со амэ поджях пхуятэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Вонэ продыкхле панехкоро лунгимо тай выджиля, со лунгимо сля пашэ трянда шов метруря. Ай кала подыкхле инте екх моло, лунгимо сля пашэ бишта эфта метруря. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Бутярнэ даранас, со амэн розмарэла пав барэн, и змукле палал кораблестар штар якоря, тай еджинэ манглепэ, соб сигэдэр тэ авэл диво. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Вонэ камле тэ нашэ кораблестар тай ачиле тэ змукэ лодка, соб тэ фирисарэпэ, ай сикавэнас, со камэн тэ змукэ якори кади ж и англал кораблестар. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Павло пхэнда шэлякэрэ пхурэдэрэсти тай халавдэнди: — Кала кадэла мануша на аченапэ пэ корабли, тумэ хасявэна. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Тунчи халавдэ пэрэчиндэ доря, савэ рицарэнас лодка, и вой тэлэдэня дэ море. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Дэнзор Павло мангля манушэн, соб вонэ тэ хан. — Дуй куркэ, сар тумэ бэшэн дэ грыжа, аченпэ бокхалэ и нисо на хан, — пхэнда вов. — ");
INSERT INTO rmyservi_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Мэ мангав тумэн тэ хан, тай када дэла зор тумэнди тэ фирисарэпэ. Никастэ тумэндар ни екх бал на тэлэдэла шэрэстар. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Кала Павло пхэнда, вов лиля мандро, наисарда Дэвлэ англа всавэрэн, пхагля и ачиля тэ ха. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Мануша лошыле, и всавэрэ хале. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Всавэрэн сля пэ корабли дуй шэла эфтадэша шов манушэн. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Кала мануша чялиле, вонэ ачиле тэ терэ корабли локхэґа тай тэ чувэ ворзо дэ море. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Дэнзор вонэ на уджянгле пхув, сави сикавдапэ, нэ удыкхле кацик тишаехкоро берего, тев и камле тэ выцырдэ корабли. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Бутярнэ обчиндэ якоря тай ачявдэ лэн дэ море, тунчи розпхангле кораблехкири рули, подлиле цыкно парусо тай бичялдэ корабли берегостэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Нэ котэ сля набут пани тай корабли заджиля дэ тишай. Епаш корабли сля пэ тишай, а епаш розмарэлас пани. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Халавдэ ж камле тэ умарэ всавэрэн барунарен, соб вонэ тэ на нашэн, кала выджяна панестар. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Нэ пханглякоро пхурэдэр камля тэ фирисарэ Павло тай на домукля лэн тэ терэ кади. Вов прыпхэнда манушэнди, савэ джянэнас, сар пэ тэ лиджя дэ пани, тэ хукэ дэ море англал всавэрэндар и тэ авэ пэ берего. ");
INSERT INTO rmyservi_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Ай савэ ачилепэ, лэнди трэбуни сля тэ доджя берегостэ пэ сандя кораблестар тай пэ котора сандендар. Кади всавэрэ фирисардэпэ тай выджиле пэ пхув. ");
INSERT INTO rmyservi_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Кала амэ фирисардэпэ, тунчи уджянгле, со кодэва острово акхарэлпэ Мальта. ");
INSERT INTO rmyservi_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Мануша, савэ котэ джювдэ, тердэ важ амэн бари патив. Вонэ тховдэ яг тай акхардэ амэн пэстэ, колэсти со сля шылало тай джялас брышынд. ");
INSERT INTO rmyservi_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Кала Павло стидэня кашта и ачиля тэ чувэ дэ яг, лэсти дэ вастэ вхаляпэ сап, саво выґульда каштэндар, кала фирисарэласпэ ягатар. ");
INSERT INTO rmyservi_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Кала катутнэ мануша удыкхле, со Павлостэ пэ вастэ амгладёл сап, вонэ ачиле тэ дэдумэ екх аврэсти: — Душол, со кадэва умарэлас манушэн. Вов фирисардапэ панестар, нэ чячимахкири дэвли отлэл лэхкоро джювимо. ");
INSERT INTO rmyservi_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Нэ Павло счута сапэ дэ яг, и вов на терда лэсти нисаво бибахталимо. ");
INSERT INTO rmyservi_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Мануша жэ дожутярэнас, со вов ачела тэ шулёл чи сиго мэрэла. Вонэ дожутярдэ бут вряма и кала удыкхле, со лэґа нисо на терэлпэ, тунчи парувдэ пэхкири дума тай ачиле тэ пхэнэ, со када савось дэвэл. ");
INSERT INTO rmyservi_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Надур ачелас грэда, тев джювда пхурэдэр пав острово, савэ акхарэнас Публии. Вов пативалэ прылиля амэн, тай амэ сле лэстэ трин дивэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Лэхкоро дад сля насвало тай пашлёлас пэ пато. Лэстэ сля пхабаримо тай фартэ дукхалас води. Павло авиля лэстэ, помангляпэ, тховда пэ лэстэ васта тай састярда лэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Тунчи и авэр насвалэ островостар ачиле тэ авэ лэстэ тай высастярэнаспэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Вонэ дэне амэнди бари патив, и кала амэ лагле, стидэне амэнди вса, со трэбуни важ дром. ");
INSERT INTO rmyservi_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Проджиля трин чёна, и амэ выджиле дэ море пэ корабли Александриятар, саво пролиджялас ївэнд пэ кодэва острово и акхарэласпэ «Дуй пхрала». ");
INSERT INTO rmyservi_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Амэ авиле дэ Сиракузы и просле котэ трин дивэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Котарь амэ ваздэнепэ тай авиле дэ Ригии. Пэ авэр диво пхурдэня южно балвал, тай дивэґа амэ авиле дэ Путеолы. ");
INSERT INTO rmyservi_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Котэ амэ аракхле пхралэн, тай вонэ мангле амэн тэ пролиджя лэнца састо курко. Тай акэ, амэ авиле дэ Римо. ");
INSERT INTO rmyservi_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Пхрала дэ Римо ушундэ, со амэ авиле, тай джиле тэ удыкхэ амэн ды Аппиёхкоро форо тай ды тханэ, саво акхарэлпэ «Трин гостиницы». Кала Павло удыкхля лэн, вов наисарда Дэвлэ тай прылиля зор. ");
INSERT INTO rmyservi_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Амэ авиле дэ Римо, тай Павлости дэне воля тэ джювэ екхэсти. Паша лэ джювда кацик халавдо, саво дыкхэлас пала лэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Проджиля трин дивэ, тай Павло акхарда пативалэн иудеен. Кала вонэ авиле, вов пхэнда лэнди: — Пхралалэ, ман спхангле дэ Ерусалимо тай отдэне дэ вастэн римлянонэнди. Нэ мэ на теравас нисо амарэ народости и на отпхэнаваспэ кодэлэстар, со сля прылито амарэ дадэндэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Римлянуря роздыкхле муро рындо тай камле тэ отмукэ ман, колэсти со дэ ман нэнай дош, пала савя трэбуни тэ умарэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Нэ сар иудея на сле пала ман, мэ манглём сындо императохкоро. Мэ тердом кади на важ кода, соб тэ дошарэ муро народо. ");
INSERT INTO rmyservi_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Колэсти мэ акхардом тумэн авдивэ, соб тэ дыкхэпэ тай тэ подэдумэ тумэнца. Пала надия Израилехкири ман спхангле кадэлэ ланчугонэнца. ");
INSERT INTO rmyservi_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Кодэла пхэндэ: — Амэнди нико на искриисарда пала тут Иудеятар. Тай котарь нико пхралэндар амэндэ на авэлас и на дэдумэлас пала тут намишто. ");
INSERT INTO rmyservi_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Нэ амэ камле тэ пошунэ, со ту думисарэх. Амэ кицик джянах, со мануша пав всавэрэн тханэн осундисарэн кадэва сикляримо. ");
INSERT INTO rmyservi_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Вонэ допхэндэпэ Павлоґа тай дэ диво, саво вонэ вытидэне, лэстэ цэрэ авиля бут манушэн. Павло дэнзор и ды бельвеля пхэнэлас лэнди пала Дэвлэхкоро Тхагаримо тай допхэнэлас пала Исусо Моисеехкэрэ Упхэнимастар и англунарендар. ");
INSERT INTO rmyservi_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Екх лэндар патине, ай авэр — нат. ");
INSERT INTO rmyservi_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Вонэ ачиле тэ хапэ машкар пэстэ, и кала вонэ уджянас, Павло дэдуманя кацавэ лава: — Мишто пхэнда Свэнто Фано тумарэ дадэнди уштэнца англунарехкэрэ Исаияхкэрэ: ");
INSERT INTO rmyservi_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","«Джя кадэлэ народостэ тай пхэн: \"Авэна тэ шунэ, нэ на полэна, авэна тэ дыкхэ, нэ на дыкхэна. ");
INSERT INTO rmyservi_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Їло кадэлэ манушэнгоро забариля чеченэґа, вонэ на шунэн канэнца тай затердэ якха, соб тэ на дыкхэн якхэнца, тэ на шунэн канэнца, тэ на полэн їлэґа и тэ на обрисявэн, соб Мэ састярдом лэн\"». ");
INSERT INTO rmyservi_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","29","Нэ джянэн кана, со фирисаримо Дэвлэхкоро бичалдо наиудеенди: вонэ и ушунэна кадэва Лав. ");
INSERT INTO rmyservi_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Павло инте дуй бэрша джювда дэ Римо, тев намисарэлас цэр тай прылэлас всавэрэн, ко авэлас лэстэ. ");
INSERT INTO rmyservi_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Вов нисостар на даралас тай на сля ника, соб тэ запхэнэл лэсти тэ розпхэнэ пала Дэвлэхкоро Тхагаримо и тэ сиклярэ пала Рае Исусо Христо.");
ALTER TABLE rmyservi_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
