﻿USE sofia;
DROP TABLE IF EXISTS sofia.rmylovari_vpl;
CREATE TABLE rmylovari_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES rmylovari_vpl WRITE;
INSERT INTO rmylovari_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Англунымастар о Дэл кэрдас тэ авэн о чери ай э пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Э пхув сас би канческо ай щющи, калипэ сас опрал па бифундоскэ пая, ай Духо Дэвлэско уралас опрал па пая. ");
INSERT INTO rmylovari_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","О Дэл пхэндас: — Мэк тэ авэл удуд, — ай кэрдилас удуд. ");
INSERT INTO rmylovari_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","О Дэл дыкхлас, кэ удуд лащё, ай уладас лэс катар калипэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","О Дэл дас анав удудэскэ «о дес», ай калимаскэ дас анав «э рат». Сас о мизмэри, ай сас ёкор — о англуно дес. ");
INSERT INTO rmylovari_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Ай пхэндас о Дэл: — Тэ авэл каполна машкар лэ пая, тэ уладёл паи катар о паи. ");
INSERT INTO rmylovari_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","О Дэл кэрдас э каполна ай уладас тэлуно паи катар паи опруно. Ай кэрдилас кадэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","О Дэл дас анав каполнакэ «о чери». Сас о мизмэри, ай сас ёкор — о дуйто дес. ");
INSERT INTO rmylovari_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ай пхэндас о Дэл: — Тэ кидэн-пэ кхэтанэ лэ пая тэла чери, ай тэ кэрдёл шуко тхан. Ай кэрдилас кадэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","О Дэл дас анав шукэ тханэскэ «э пхув», ай пэ кидынэ пая пхэндас «э море». Ай дыкхлас о Дэл, кэ кадо мишто. ");
INSERT INTO rmylovari_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","— Тэ сармозый пэ пхув са, со шай барол анда латэ: чяра лэнгэ сэмноса, ви акарсоскэ копаченгэ породы пэ пхув, савэ дэн дэмэльчи сумбурэнца, — пхэндас о Дэл. Ай кэрдилас кадэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Э пхув дас траё кодолэскэ, со барол: кай фэрсоскэ чяра лэнгэ сэмноса, ай кай са э копачя, савэ дэн дэмэльчи сумбурэнца. Ай о Дэл дыкхлас, кэ кадо мишто. ");
INSERT INTO rmylovari_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Сас о мизмэри, ай сас ёкор — о трито дес. ");
INSERT INTO rmylovari_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Ай о Дэл пхэндас: — Тэ кэрдён удуда по чери, тэ улавэн дес катар э рат, ай мэк вон тэ авэн сар вурмы, сыкавэн врама ви улавэн дес катар о дес ай бэрш катар о бэрш. ");
INSERT INTO rmylovari_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Ай мэк вон авэн сар лампашы по чери тэ пхабон каринг э пхув. Ай кэрдилас кадэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","О Дэл кэрдас дуй барэ удуда — баро удуд, тэ визэрий десэ, ай цыно удуд, тэ визэрий рати, ай Вов кэрдас ви черғая. ");
INSERT INTO rmylovari_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","О Дэл щютас лэн пэ черэски каполна, тэ виламнын пэ пхув, ");
INSERT INTO rmylovari_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","тэ визэрин десэ ай рати ви тэ улавэн удуд катар о калипэ. О Дэл дыкхлас, кэ кадо мишто. ");
INSERT INTO rmylovari_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Сас о мизмэри, ай сас ёкор — о штарто дес. ");
INSERT INTO rmylovari_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","О Дэл пхэндас: — Тэ пхэрдёл о паи жювиндымаса, ай тэ уран опрал э пхув, андо чери, чирикля. ");
INSERT INTO rmylovari_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","О Дэл кэрдас барэ паескэ алатон, акарсоскэ породы анда жювиндымата, кай мижан андо паи, ай фэрсоскэ чириклян, кай уран. Ай дыкхлас о Дэл, кэ кадо мишто. ");
INSERT INTO rmylovari_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Вов бахтярдас лэн ай пхэндас: — Кэрэн щяворэн ви кэрдён май бут; пхэрдярэн моренгэ пая, ай мэк тэ авэл бут чирикля пэ пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Сас о мизмэри, ай сас ёкор — о панжьто дес. ");
INSERT INTO rmylovari_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ай пхэндас о Дэл: — Тэ сармозын пэ пхув акарсоскэ породы анда жювиндымата: кхэрутнэ ай вадна алатура ай са, со масый па пхув. Ай кэрдилас кадэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","О Дэл кэрдас акарсоскэ породы анда вадна ай кхэрутнэ алатура ай са, со масый па пхув. Ай дыкхлас Вов, кэ кадо мишто. ");
INSERT INTO rmylovari_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Котар о Дэл пхэндас: — Кэраса манушэс, тэ авэл лэстэ Амари мусура ай тэ авэл, сар Амэ. Мэк вов визэрий моренгэ мащен ай черэскэ чириклян, алатон ай са э пхув, ви саворэн, кон траий пэ латэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Кадэ о Дэл кэрдас манушэс па Пэски мусура, па мусура лэ Дэвлэски Вов кэрдас лэс, сар муршэс ай жювля Вов кэрдас лэн. ");
INSERT INTO rmylovari_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","О Дэл бахтярдас лэн ай пхэндас: — Кэрэн щяворэн ви кэрдён май бут; пхэрдярэн э пхув, тэ авэл тумари. Паранчюлын пэ моренгэ маще, ай пэ черэскэ чирикля, ви пэ са, со траий пэ пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Котар о Дэл пхэндас: — Мэ дав тумэнгэ са, со барол сэмноса пэ са э пхув, ай са э копачя, савэ дэн дэмэльчи сумбурэнца; кадо авла тумаро хабэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ай са пхувакэ алатонгэ, ви са черэскэ чириклянгэ, ви кай са, со масый — саконэскэ, андэ кастэ пхурдэл о траё, — Мэ дав хамаскэ фэрсоскэ зэлэнимата. Ай кэрдилас кадэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","О Дэл дыкхлас пэ са, со Вов кэрдас, ай са сас зуралэс мишто. Сас о мизмэри, ай сас ёкор — о шовто дес. ");
INSERT INTO rmylovari_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Кадэ сас кэрдэ о чери ай э пхув ай са, со инкэрдёл ви траий котэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","По эфтато дес Дэл дас гата пэски бути, сави Вов кэрлас, ай по эфтато дес Вов чи бутязыяс. ");
INSERT INTO rmylovari_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Жи кай кадо дес сас гата Лэски бути. О Дэл бахтярдас о эфтато дес ай кэрдас лэс сунто, кэ Вов чи бутязыяс май бут. ");
INSERT INTO rmylovari_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Акэ панасы, сар сас кэрдэ о чери ай э пхув. Кана о Дэл Яхва кэрлас э пхув тай о чери, ");
INSERT INTO rmylovari_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","пэ пхув атунчи инкэ нас чи бур малякэ, чи маляки чяр, анда кадо кэ о Дэл Яхва чи бищявлас пэ пхув бришынд, ай нас мануш тэ бутязый пэ ла. ");
INSERT INTO rmylovari_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Фэри о нашыпэ лэ паеско ваздэлас-пэ анда пхув ай киндярлас э пхув опрал. ");
INSERT INTO rmylovari_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Атунчи о Дэл Яхва кэрдас манушэс анда пхуваки чик ай пхурдас андэ лэскэ рутхуна пхурдыпэ лэ траёско, ай о мануш кэрдилас жено-жювиндо. ");
INSERT INTO rmylovari_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Котар о Дэл Яхва барардас дэмэльченги рэйс пэ ғайналоски риг, андо Эдэм, ай щютас тэ траий котэ манушэс, савэс Вов кэрдас. ");
INSERT INTO rmylovari_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","О Дэл Яхва барардас анда пхув акарсоскэ копачя — шукар по дыкхипэ ай лащё хамаскэ. Ай машкарал э рэйс баролас о копачи, кай дэл о траё, ай ви о копачи, кай дэл жянглипэ па лащипэ ай чёрипэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Анда Эдэм фулыяс бари нал, сави дэлас паи кай э рэйс, ай май дур вой улавлас-пэ пэ штар пая. ");
INSERT INTO rmylovari_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Англуны нал бущёл Пишон: вой фулый круял са э пхув Хавила, кай сы сумнакай. ");
INSERT INTO rmylovari_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Сумнакай андэ коды пхув лащё, ай инкэ котэ сы сагаки смола ай куч бар шохам. ");
INSERT INTO rmylovari_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Дуйто нал бущёл Гихон, вой фулый круял са э пхув Куш. ");
INSERT INTO rmylovari_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Трито нал бущёл Тигр, вой фулый андэ ғайналоски риг катар Ашшур. Ай э штарто нал — кадо сы Ефрат. ");
INSERT INTO rmylovari_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","О Дэл Яхва щютас манушэс тэ траий андэ Эдэмско рэйс, тэ барарэл копачя ай тэ фирий лэн. ");
INSERT INTO rmylovari_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","О Дэл Яхва дас аври лэ манушэскэ: — Шай хас дэмэльчи па са копачя андэ рэйс, ");
INSERT INTO rmylovari_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","алом на ха па копачи, кай дэл жянглипэ па лащипэ ай чёрипэ. Кэ андо дес, кана хаса, ту мусай авла тэ мэрэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","О Дэл Яхва пхэндас: — На мишто тэ авэл мануш коркоро. Мэ кэро лэскэ ажутори, саво лэскэ пасулыя. ");
INSERT INTO rmylovari_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","О Дэл Яхва кэрдас анда пхув са малянгэ алатон ай са черэскэ чириклян. Котар Вов андас лэн кай о мануш, тэ дыкхэл, сар вов дэла лэн анава. Ай сар мануш дас лэнгэ анава, кадэ ви ащилас. ");
INSERT INTO rmylovari_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Кадэ мануш дас анава са кхэрутнэ алатонгэ, са черэскэ чириклянгэ ай са малякэ алатонгэ. Алом лэ Адамоскэ чи аракхлас-пэ ажутори, саво пасулысардасас лэскэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Атунчи о Дэл Яхва щютас манушэс андо зурало соипэ, ай жипон вов совлас, лас екх анда лэскэ пашаврэ ай пхандадас кадо тхан масэса. ");
INSERT INTO rmylovari_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Анда пашавро, саво Вов лас аври анда мануш, о Дэл Яхва кэрадас жювля ай андас ла лэстэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Мануш пхэндас: — Акэ, аканак кадо сы кокало катар мурэ кокала ай мас катар муро мас. Вой бущёла «ромни», кэ сас лыны катар ром. ");
INSERT INTO rmylovari_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Анда кадо ащявла мануш пэскэ дадэс ай да ай тэ кэрдёл екх пэска ромняса, ай дуй кэрдёна екх мас. ");
INSERT INTO rmylovari_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ви Адам, ви лэски ромни сас нангэ, алом чи атярнас лажяво. ");
INSERT INTO rmylovari_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Анда са вадна алатура, савэн кэрдас о Дэл Яхва, май бэндяло сас о сап. Вов пущлас э жювлятар: — Чячес о Дэл пхэндас: «На хан па чи соско копачи андэ рэйс»? ");
INSERT INTO rmylovari_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Жювли пхэндас сапэскэ: — Амэ шай хас дэмэльчи па копачя андэ рэйс, ");
INSERT INTO rmylovari_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","алом о Дэл пхэндас: «На хан дэмэльчи па копачи, саво тордёл машкарал э рэйс, ай на азбан лэс, кэ мусай авла тэ мэрэн». ");
INSERT INTO rmylovari_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","— На, тумэ чи мэрна, — пхэндас о сап жювлякэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","— Кэ о Дэл жянэл, со, кана хана лэн, тумарэ якха путэрдёна ай тумэ кэрдёна, сар лэ дэвла, кэ жянна, со сы лащипэ ай чёрипэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Атунчи жювли дыкхлас, кэ о дэмэльчё копаческо сас лащё хамаскэ ай шукар по дыкхипэ, ай кэ о копачи сас киваншагоско, сар годявэримаско пирово. Ай вой лас екх дэмэльчё ай халас лэс. Вой дас екх дэмэльчё ви ромэскэ, саво сас ласа, ай вов халас лэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Лэнгэ якха путэрдилэ, ай вон атярдэ, кэ сы нангэ. Атунчи вон кхудэ пэскэ щеравимата по машкар анда инжыроскэ патра. ");
INSERT INTO rmylovari_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Май пашэ каринг э рат, кана начилас пхабарипэ, о Дэл Яхва, сар миндык, пхирэл па рэйс. Адам ай лэски ромни шундэ, сар Вов пхирэл, ай гарадиле Лэстар машкар лэ копачя. ");
INSERT INTO rmylovari_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Алом о Дэл Яхва акхардас Адамос: — Кай сан? ");
INSERT INTO rmylovari_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Адам пхэндас пэ кадо: — Мэ шундэм Тут андэ рэйс ай дарайлэм, анда кадо кэ сым нанго, ай гарадилэм. ");
INSERT INTO rmylovari_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","О Дэл Яхва пущлас: — Кон пхэндас тукэ, кэ сан нанго? Ту халан дэмэльчи па копачи, па саво Мэ дэм аври тэ на хас? ");
INSERT INTO rmylovari_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Адам пхэндас: — Жювли, сава Ту дан мангэ тэ авэл манца, — кадо вой дас мангэ дэмэльчё па кодо копачи, ай мэ халэм лэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Атунчи о Дэл Яхва пхэндас ла жювлякэ: — Со ту кэрдан? Жювли пхэндас пэ кадо: — О сап хохадас ман, анда кадо ви халэм. ");
INSERT INTO rmylovari_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Атунчи о Дэл Яхва пхэндас лэ сапэскэ: — Анда кадо со ту кэрдан, дав тут армая машкар са кхэрутнэ ай вадна алатура! Ту лэса тэ масыс по пэр, ту лэса тэ хас прахо андэ са тирэ траёскэ деса. ");
INSERT INTO rmylovari_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Мэ кэро холи машкар тутэ ай э жювли ай машкар тирэ парапутя ай лакэ парапутя: вон лэна тэ марэн тут па шэро, ай ту лэса тэ дындалэс лэн андэ пунрэски шарка. ");
INSERT INTO rmylovari_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ай э жювлякэ Вов пхэндас: — Ту хаса кино, кана авэса кхамны: андэ барэ дукха кэрэса щяворэн. Ту киваныса тэ паранчюлыс по тё ром, алом вов визэрия тут. ");
INSERT INTO rmylovari_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ай Адамоскэ Вов пхэндас: — Кай ту патяян тира ромняко муй ай халан дэмэльчё па копачи, па саво Мэ дэм аври тукэ: «На ха лэстар», прокляцымэ анда тутэ э пхув: андэ пхари бути ту лэса тэ хахавэс-ту латар андэ са те траёскэ дес. ");
INSERT INTO rmylovari_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Вой барарла тукэ канрэ ай чёри чяр, ту лэса тэ хас, со барол пэ мал. ");
INSERT INTO rmylovari_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Андэ пхари бути ту хаса манро тиро, жипон чи болдэса-ту андэ пхув, анда сави санас лыно; анда кадо кэ ту коркоро сан чик, андэ пхув ви болдэса-ту. ");
INSERT INTO rmylovari_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Адам дас анав пэска ромнякэ Ева, кэ вой кэрдилас дэй саворэнгэ, кон траий. ");
INSERT INTO rmylovari_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","О Дэл Яхва кэрдас гада анда морчи ай урадас андэ лэ Адамос ви лэска ромня. ");
INSERT INTO rmylovari_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Котар о Дэл Яхва пхэндас: — Кана атярдас, со сы лащипэ ай чёрипэ, мануш кэрдилас, сар екх анда Амэндэ. Наштык тэ цырдэл пэско васт ай тэ щинэл дэмэльчё ви па копачи лэ траёско, тэ хал лэс ай тэ авэл траимэ миндык. ");
INSERT INTO rmylovari_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Ай Дэл Яхва нашадас лэс анда Эдэм, тэ кэрэл бути пэ пхув, анда сави сас лыно. ");
INSERT INTO rmylovari_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Кана нашадас лэ манушэс, Вов щютас паш Эдэмоски рэйс, пэ ғайналоски риг, херувимон ай ягало ханро, кай марлас андэ са рига, тэ фирий о дром каринг о копачи лэ траёско. ");
INSERT INTO rmylovari_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","О Адам лас тэ траий пэска ромняса ла Еваса, сар жювляса. Вой кэрдилас кхамны ай кэрдас Каинос. Вой пхэндас: «Сар о Рай Яхва кэрдас, кадэ ви мэ кэрдэм манушэс». ");
INSERT INTO rmylovari_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Котар латэ аракхадилас лэско прал Авель. О Авель дыкхлас пала бакрэнгэ ай буснянгэ кырдура, ай о Каин бутязыяс пэ пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Па врама Каин дас даро каринг о Рай Яхва анда кодо, со дэлас э пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ай о Авель андас май лаще ай тхулэ бакрэн ай буснян анда кодал алатура, кон аракхадилэ англунэ. О Рай Яхва дыкхлас лащимаса по Авель ай лэско даро, ");
INSERT INTO rmylovari_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","алом по Каин ай лэско даро чи дыкхлас кадэ. Каин холяйлас, ай лэскэ пэлас намишто. ");
INSERT INTO rmylovari_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Атунчи о Рай Яхва пхэндас лэ Каиноскэ: — Состар тукэ пэлас намишто? Состар калилас тиро муй? ");
INSERT INTO rmylovari_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Тэ кэрэса, сар трубуй, чяк ви ту авэса драго. Ай кана кэрэс на кадэ, сар трубуй, атунчи пашо тиро вудар гарадилас бэзэх: вов камэл тэ паранчюлый пэ тутэ, алом ту трубуй тэ визэрис лэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","О Каин пхэндас пэскэ пралэскэ Авелёскэ: — Авэн пэ мал. Кана вон сас пэ мал, Каин щюдас-пэ по пэско прал Авель ай мудардас лэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Атунчи о Рай Яхва пхэндас лэ Каиноскэ: — Кай тиро прал Авель? — Чи жянав, — пхэндас вов. — Мэ чяк чи сым лэско лышытори. ");
INSERT INTO rmylovari_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","О Рай Яхва пхэндас: — Со ту кэрдан? Рат тирэ пралэско цыпий каринг Мандэ анда пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Аканак ту сан прокляцымэ, нашадо па пхув, сави путэрдилас тэ лэл андэ пэстэ тирэ пралэско рат, щёрдо тирэ вастэса. ");
INSERT INTO rmylovari_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Кана бутязыса пэ пхув, вой май бут чи дэла тукэ хабэ. Ту пхирэса бикхэрэско па пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Каин пхэндас лэ Раскэ лэ Яхваскэ: — Мури дош май бари, сар мэ шай инкрав ла, сар мэ шай бирий. ");
INSERT INTO rmylovari_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Аканак Ту нашавэс ман па пхув, ай Ту чи дыкхэса ман май бут: мэ пхиро бикхэрэско па пхув, ай англуно, кон дыкхла ман, мударла ман. ");
INSERT INTO rmylovari_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Алом о Рай Яхва пхэндас лэскэ: — На. Тэ мударла вари-кон Каинос, кодолэс рэсэла эфтавар май бут анда кадо. Ай о Рай Яхва ащядас по Каин э вурма, тэ маладёла вари-кон лэса, тэ на мударэл лэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","О Каин гэластар катар о Рай Яхва ай траияс андо тхэм, кай бущёлас Нод, пэ ғайналоски риг катар Эдэм. ");
INSERT INTO rmylovari_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Каин траияс пэска ромняса, ай вой пэлас кхамны, ай аракхадилас латэ Ханох. Андэ коды врама Каин кэравлас форо ай щютас лэскэ анав пала пэско щяво Ханох. ");
INSERT INTO rmylovari_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Кай о Ханох аракхадилас Ирад, кай о Ирад аракхадилас Мехуяэл, кай о Мехуяэл аракхадилас Метушаэл, ай кай о Метушаэл аракхадилас Ламех. ");
INSERT INTO rmylovari_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Ламех лас пэскэ дуе ромнян: екх бущёлас Ада, э кавэр Цылла. ");
INSERT INTO rmylovari_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Кай э Ада аракхадилас Явал: вов кэрдилас дад кодолэ манушэнгэ, кон траин андэ цэрғи ай барарэн кхэрутнэ алатон. ");
INSERT INTO rmylovari_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Лэско прал бущёлас Ювал: вов кэрдилас дад саворэнгэ, кон башавэн пэ арфа ай тутураза. ");
INSERT INTO rmylovari_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Ви кай э Цылла сас щяво, Тувал-Каин, саво кэрлас са анда галбэно харкума ай састри. Тувал-Каиноски пхэн сас Наама. ");
INSERT INTO rmylovari_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","О Ламех пхэндас пэскэ ромнянгэ: — Ада ай Цылла, шунэн ман, Ламехоскэ ромня, лэн сама пэ мурэ ворби. Мэ мудардэм муршэс анда кадо, кэ вов щиндас ман, тэрнэ щявэс анда кадо, кэ вов маладас ман. ");
INSERT INTO rmylovari_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Тэ рэсла эфтавар май бут анда Каин, антунчи анда Ламех рэсла эфтавардэш тай эфтавар май бут. ");
INSERT INTO rmylovari_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Адам траияс пэска ромняса. Латэ аракхадилас щяво, ай вой дас лэскэ анав Сиф, ворбаса: «О Дэл дас ман инкэ щяворэс мэштык о Авель, савэс мудардас о Каин». ");
INSERT INTO rmylovari_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Ви кай о Сиф сас щяво, ай вов щютас лэскэ анав Энош. Андэ коды врама мануш лынэ тэ рудин лэ Раскэ лэ Яхваскэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Кадо сы панасы па вица лэ Адамоски. Кана о Дэл кэрдас манушэс, Вов кэрдас лэс па сымили лэ Дэвлэско. ");
INSERT INTO rmylovari_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Вов кэрдас муршэс ай жювля ай бахтярдас лэн. Кана вон сас аба кэрдэ, Вов дас лэн анав «мануш». ");
INSERT INTO rmylovari_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Кана о Адам траисардас 130 бэрш, лэстэ аракхадилас щяво, саво мэзыяс пэ лэстэ ай сас лэски мусура, ай вов дас лэс анав Сиф. ");
INSERT INTO rmylovari_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Пала кодо сар аракхадилас Сиф, Адам траисардас инкэ 800 бэрш, ай лэстэ сас инкэ щявэ тай щея. ");
INSERT INTO rmylovari_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Адам траисардас 930 бэрш ай мулас. ");
INSERT INTO rmylovari_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Кана Сиф траисардас 105 бэрш, лэстэ аракхадилас Энош. ");
INSERT INTO rmylovari_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Пала кодо сар аракхадилас Энош, Сиф траисардас инкэ 807 бэрш, ай лэстэ инкэ сас щявэ тай щея. ");
INSERT INTO rmylovari_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Сиф траисардас 912 бэрш ай мулас. ");
INSERT INTO rmylovari_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Кана Энош траисардас 90 бэрш, лэстэ аракхадилас Кенан. ");
INSERT INTO rmylovari_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Пала кодо сар аракхадилас Кенан, Энош инкэ траисардас 815 бэрш, ай лэстэ инкэ сас щявэ тай щея. ");
INSERT INTO rmylovari_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Энош траисардас 905 бэрш ай мулас. ");
INSERT INTO rmylovari_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Кана Кенан траисардас 70 бэрш, лэстэ аракхадилас Махалалэл. ");
INSERT INTO rmylovari_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Пала кодо сар аракхадилас Махалалэл, Кенан инкэ траисардас 840 бэрш, ай лэстэ сас инкэ щявэ тай щея. ");
INSERT INTO rmylovari_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Кенан траисардас 910 бэрш ай мулас. ");
INSERT INTO rmylovari_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Кана Махалалэл траисардас 65 бэрш, лэстэ аракхадилас Яред. ");
INSERT INTO rmylovari_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Пала кадо, сар аракхадилас Яред, Махалалэл траисардас инкэ 830 бэрш, ай лэстэ инкэ сас щявэ тай щея. ");
INSERT INTO rmylovari_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Махалалэл траисардас 895 бэрш ай мулас. ");
INSERT INTO rmylovari_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Кана Яред траисардас 162 бэрш, лэстэ аракхадилас Ханох. ");
INSERT INTO rmylovari_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Пала кодо, сар аракхадилас Ханох, Яред траисардас инкэ 800 бэрш, ай лэстэ инкэ сас щявэ тай щея. ");
INSERT INTO rmylovari_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Яред траисардас 962 бэрш ай мулас. ");
INSERT INTO rmylovari_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Кана Ханох траисардас 65 бэрш, лэстэ аракхадилас Мафусаэл. ");
INSERT INTO rmylovari_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Пала кодо, сар аракхадилас Мафусаэл, Ханох пхирлас англа Дэл 300 бэрш, ай лэстэ инкэ сас щявэ тай щея. ");
INSERT INTO rmylovari_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Ханох траисардас жи кай 365 бэрш. ");
INSERT INTO rmylovari_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Ханох траияс лэ Дэвлэса андо ило, пала кодо лэс аба нас, анда кадо кэ о Дэл лас лэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Кана Мафусаэл траисардас 187 бэрш, лэстэ аракхадилас Ламех. ");
INSERT INTO rmylovari_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Пала кодо, сар аракхадилас Ламех, Мафусаэл траисардас инкэ 782 бэрш, ай лэстэ инкэ сас щявэ тай щея. ");
INSERT INTO rmylovari_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Мафусаэл траисардас 969 бэрш ай мулас. ");
INSERT INTO rmylovari_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Кана Ламех траисардас 182 бэрш, лэстэ аракхадилас щяво. ");
INSERT INTO rmylovari_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Вов дас лэскэ анав Ной ай пхэндас: «Вов дэла амэнгэ тэ ғодонысарас катар э бути, э пхари бути пэ пхув, сава дас армая о Рай Яхва». ");
INSERT INTO rmylovari_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Пала кодо сар аракхадилас Ной, Ламех траисардас 595 бэрш, ай лэстэ инкэ сас щявэ ай щея. ");
INSERT INTO rmylovari_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Ламех траисардас 777 бэрш ай мулас. ");
INSERT INTO rmylovari_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Кана Ноескэ пхэрдилас 500 бэрш, лэстэ аракхадилэ Сим, Хам ай Яфет. ");
INSERT INTO rmylovari_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Мануш лынэ тэ кэрдён май бут пэ пхув, ай лэндэ аракхадёнас щея. ");
INSERT INTO rmylovari_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Дэвлэскэ щявэ дыкхлэ, кэ лэ щея манушэнгэ шукар, ай лынэ тэ лэн лэн ромнянгэ, саконэс соски чялёлас. ");
INSERT INTO rmylovari_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","О Рай Яхва пхэндас: — На акаркана Муро траёско пхурдыпэ авла андо мануш, кэ мануш сы фэри мас ай кокала. Мэк лэнго траё авла шэл тай биш бэрш. ");
INSERT INTO rmylovari_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Пала кодал дес ай май палал пэ пхув сас нефилимы, кана щявэ лэ Дэвлэскэ лэнас лэ манушэнгэ щеян ай лэндар аракхадёнас щявора. Кадал сас зуралэ войныки, ғирэша катар пураны врама. ");
INSERT INTO rmylovari_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","О Рай Яхва дыкхлас, кэ лэ мануш пэ пхув кэрдилэ зуралэс насул ай са лэнгэ гиндура цырдэн-пэ каринг чёрэ бутя. ");
INSERT INTO rmylovari_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","О Рай Яхва бунусардас па кодо, кэ кэрдас манушэс пэ пхув, ай Лэско ило пхэрдилас дукхаса. ");
INSERT INTO rmylovari_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Ай пхэндас о Рай Яхва: — Мэ кхосав тэлэ па пхувако муй манушыпэ, саво Мэ кэрдэм. Мэ хасаравав ви манушэн, ви барэ ай цынэ алатон, ай ви черэскэ чириклян, анда кадо кэ Мэ бунуй, кэ кэрдэм лэн. ");
INSERT INTO rmylovari_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Алом о Ной аракхлас милошаго андэ Раскэ Яхваскэ якха. ");
INSERT INTO rmylovari_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Кадо сы панасы па вица лэ Ноески. Машкар лэ мануш андэ коды врама фэри о Ной сас чячюно ай бидошако; вов пхирлас англа Дэл. ");
INSERT INTO rmylovari_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Кай о Ной сас трин щявэ: Сим, Хам тай Яфет. ");
INSERT INTO rmylovari_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Андэ Дэвлэскэ якха э пхув румусайлас, вой пхэрдилас насулимаса. ");
INSERT INTO rmylovari_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","О Дэл дыкхлас, сар румусайлас э пхув анда кадо, кэ са, со сы жювиндо пэ латэ, гэлас па бангэ дрома. ");
INSERT INTO rmylovari_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Атунчи о Дэл пхэндас лэ Ноескэ: — Мэ кэро агор саворэнгэ, со сы жювиндо, кэ анда лэндэ э пхув пхэрдилас насулимаса. Мэ хасаравав лэн куса са э пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Кэрав пэскэ ковчего анда копачи, кай бущёл гофер, ай кэр андэ лэстэ собы, ай макх лэс смоласа ви андрал, ви аврал. ");
INSERT INTO rmylovari_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Акэ сар трубуй тэ кэравэс о ковчего: вов трубуй тэ авэл 150 метры андо лунжипэ, 25 метры андо булғипэ ай 15 метры андо учипэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Кэрав о тэтэво по допаш метро май учес катар о ковчего. Щюв пэ риг о вудар ай кэрав э мэлэтура: тэлуно, машкарутно ай опруно. ");
INSERT INTO rmylovari_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Мэ щёро пэ пхув барэ пая, тэ хасайвэл са, со траий тэла чери, сако алато, андэ кастэ пхурдёл о траё. Са, со сы пэ пхув, хасайвэла. ");
INSERT INTO rmylovari_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Алом Мэ ворбисайвав туса, ай ту дэса андрэ андо ковчего — ту, ви тирэ щявэ, ви тири ромни, ви тирэ щявэнгэ ромня. ");
INSERT INTO rmylovari_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ингэр андо ковчего саворэ жювиндэ алатон по дуй-женэ, муршэс ай жювля, тэ ащён жювиндэ кхэтанэ туса. ");
INSERT INTO rmylovari_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","По дуй-женэ катар саки порода анда чирикля ай барэ ви цынэ алатура авна тутэ, тэ ащён жювиндэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Кидэ туса сако фалоско хабэ тэ хан ви ту, ви вон. ");
INSERT INTO rmylovari_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","О Ной кэрдас са ворта кадэ, сар пхэндас лэскэ о Дэл. ");
INSERT INTO rmylovari_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","О Рай Яхва пхэндас лэ Ноескэ: — Дэ андрэ андо ковчего пэскэ челэдоса. Мэ дыкхав, кэ машкар са, кон траий аканак, фэри ту сан чячюно англа Мандэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Лэ пэса па эфта пары катар са ужэ алатура, по екх пара катар акарсоскэ магэрдэ ");
INSERT INTO rmylovari_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","ай по эфта пары анда сакэ чирикля, муршэн тай жювлян, тэ фирисайвэн саворэ пэ пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Па эфта дес Мэ бищяво бришынд пэ пхув тэ дэл штарвардэш дес ай штарвардэш ратя; ай Мэ кхосава тэлэ па муй ла пхувако са, со сы жювиндо, кас Мэ кэрдэм. ");
INSERT INTO rmylovari_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ной кэрдас са, сар пхэндас лэскэ о Рай Яхва. ");
INSERT INTO rmylovari_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Кана лэ барэ пая лынэ тэ пэрэн пэ пхув, лэ Ноескэ сас шов шэла бэрш. ");
INSERT INTO rmylovari_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Ной, лэскэ щявэ, лэски ромни ай лэскэ щявэнгэ ромня дынэ андрэ андо ковчего тэ фирисайвэн катар о паи. ");
INSERT INTO rmylovari_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Ужэ тай магэрдэ алатура, чирикля ай са, со мижал пэ пхув, ");
INSERT INTO rmylovari_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","авилэ кай о Ной ай накхлэ андо ковчего по дуй-женэ: мурш тай жювли, сар дас аври лэ Ноескэ о Дэл. ");
INSERT INTO rmylovari_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Па эфта дес лэ барэ пая щёрдилэ пэ пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","По шовэ шэлэнго бэрш лэ Ноеско, андо дэшэфтато дес, андо дуйто щён щиндилэ са бифундоскэ пировура ай путэрдилэ черэнгэ фелястри, ");
INSERT INTO rmylovari_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","ай о бришынд щёрдёлас пэ пхув штарвардэш дес тай ратя. ");
INSERT INTO rmylovari_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Андо кодо дес ви накхлэ андо ковчего о Ной, лэскэ щявэ Сим, Хам ай Яфет, ромни лэ Ноески ай ромня лэ тринэ лэскэ щявэнгэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Лэнца накхлэ са, кон сас жювиндэ: акарсоскэ породы анда вадна ай кхэрутнэ алатура, акарсоскэ, кон масый, са чирикленгэ породы ай са, кастэ сы пхака. ");
INSERT INTO rmylovari_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Саворэ, андэ кастэ пхурдёл о траё, авилэ кай о Ной ай накхлэ андо ковчего по дуй, ");
INSERT INTO rmylovari_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","мурш тай жювли, анда са, со сы жювиндо, сар дас аври лэ Ноескэ о Дэл. Ай атунчи о Рай Яхва пхандадас пала лэстэ вудар. ");
INSERT INTO rmylovari_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Барэ пая сас пэ пхув штарвардэш дес, ай кана арэслэ э пая, вон ваздэ о ковчего катар э пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Лэ пая са май бут ай май бут арэснас каринг э пхув, ай ковчего инкэрдёлас пэ паи. ");
INSERT INTO rmylovari_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Вон ваздэ-пэ кадэ учес пэ пхув, кэ щерадэ са лэ уче хара, кай сы тэла чери. ");
INSERT INTO rmylovari_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Пая ваздэ-пэ ай щерадэ опрал са лэ хара май учес, сар пэ эфта ай допаш метры. ");
INSERT INTO rmylovari_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Са жювиндо, со мишкияс-пэ пэ пхув, хасайлас: чирикля, кхэрутнэ ай вадна алатура, са, кон мишкий-пэ, ай са лэ мануш. ");
INSERT INTO rmylovari_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Са пэ пхув, со траияс, андэ каскэ рутхуна пхурдёлас о траё, мулэ; са жювиндо сас хасарадо. ");
INSERT INTO rmylovari_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Са жювиндо сас кхосло па муй ла пхувако: катар лэ мануш жи кай фэрсоскэ алатура, кон мижан па пхув, ви жи кай са, со урал. Вон сас кхослэ па пхув, ащилас фэри о Ной ай кодал, кон сас лэса андо ковчего. ");
INSERT INTO rmylovari_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Лэ барэ пая лэнас зор пэ пхув шэл тай паньвардэш дес. ");
INSERT INTO rmylovari_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","О Дэл дас пэ гиндо па Ной ай па са вадна ай кхэрутнэ алатура, савэ сас лэса андо ковчего. Вов бищядас балвал пэ пхув, ай лэ пая лынэ тэ цынён. ");
INSERT INTO rmylovari_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Бифундоскэ пировура ай черэнгэ фелястри пхандадилэ, ай о бришынд ащядилас тэ щёрдёл па чери. ");
INSERT INTO rmylovari_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Пая пок цэра жянастар па пхув, ай каринг екх шэл тай паньвардэшто дес вон зуралэс цынилэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","По дэшэфтато дес эфтатонэ щёнэско о ковчего ащядилас пэ Араратска хара. ");
INSERT INTO rmylovari_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Пая жянастар жи кай о дэшто щён, ай андо англуно дес дэштонэ щёнэско сыкадилэ лэ харэнгэ шэрэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Па штарвардэш дес о Ной путэрдас филястра, саво вов кэрдас андо ковчего, ");
INSERT INTO rmylovari_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ай мэклас аври лэ чёкос, ай вов уралас тай болдэлас-пэ палпалэ, жипон чи шутилас паи пэ пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Котар Ной мэклас аври гулумбос, тэ жянэл, гэластар о паи па пхув вай на, ");
INSERT INTO rmylovari_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","алом о гулумбо чи аракхлас шуко тхан тэ мэкэл-пэ тэлэ, кэ о паи щеравлас са э пхув, ай болдас-пэ палпалэ андо ковчего кай о Ной. О Ной лунжярдас аври о васт ай лас гулумбос палпалэ андо ковчего. ");
INSERT INTO rmylovari_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Па эфта дес вов инкэ еквар мэклас аври гулумбос катар о ковчего. ");
INSERT INTO rmylovari_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Кана о гулумбо болдас-пэ палпалэ по мизмэри, вов инкэрлас андо муй зэлэно патрин катар маслиново копачи. Атунчи о Ной атярдас, кэ о паи гэластар па пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Вов жутярдас инкэ эфта дес ай палэ мэклас аври гулумбос, ай атунчи о гулумбо чи болдас-пэ палпалэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Каринг о англуно дес англунэ щёнэско шов шэла тай екхто бэрш лэ Ноеско э пхув шутилас катар о паи. Ной ваздас э ковчегоски хып, щютас аври о шэро тай дыкхлас, кэ э пхув шуки. ");
INSERT INTO rmylovari_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Каринг биштафтато дес андо дуйто щён э пхув кэрдилас са шуки. ");
INSERT INTO rmylovari_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Атунчи о Дэл пхэндас лэ Ноескэ: ");
INSERT INTO rmylovari_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","— Дэ аври анда ковчего, ту, ви тири ромни, ви тирэ щявэ, ви лэнгэ ромня. ");
INSERT INTO rmylovari_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ингэр аври саворэ жювиндэ алатон, кон сы туса: чириклян, алатон ай саворэн, кон масый, тэ авэн вон май бут ай тэ аракхадён ви тэ барон пэ пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ай о Ной дас аври анда ковчего куса пэскэ щявэ, ромни ай пэскэ щявэнгэ ромня. ");
INSERT INTO rmylovari_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Са лэ алатура, ай са, кон масый, ай са чирикля — са, со мишкий-пэ па пхув, — дынэ аври анда ковчего, екх порода пала екхатэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Ной кэрадас лэ Раскэ лэ Яхваскэ жэртвенник ай дас пэ лэс жэртва: лас ужэ алатон ай чириклян анда саки алатонги вица, щиндас лэн ай пхабардас пэ яг. ");
INSERT INTO rmylovari_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","О Рай Яхва атярдас лащи сага ай пхэндас андо Пэско ило: — Шоға май бут Мэ чи дав армая э пхув анда мануш, чи дыкхав пэ кодо, кэ дэ цынара манушэско ило цырдэл-пэ каринг насулыпэ. Ай шоға май бут чи хасаравав са, со сы жювиндо, сар Мэ кэрдэм аканак. ");
INSERT INTO rmylovari_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Жипон сы пхув, мэк тэ на ащядёл врама, кана лэ мануш барарэн ай кидэн сэмно, тэ на ащядён шыл ай пхабарипэ, милай ай ивэнд, дес ай рат. ");
INSERT INTO rmylovari_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","О Дэл бахтярдас лэ Ноес ай лэскэ щявэн ай пхэндас лэнгэ: — Кэрэн щяворэн ви кэрдён май бут ай пхэрдярэн э пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Мэк бари дар англа тумэндэ атярэн са алатура ай са чирикля черэскэ, са, со сы жювиндо пэ пхув, ай са паескэ маще: вон сы дынэ андэ тумарэ васт. ");
INSERT INTO rmylovari_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Са, со траий ай мишкий-пэ, авла тумаро хабэ. Сар майинты Мэ дэм тумэнгэ зэлэна бараимата, ви аканак Мэ дав тумэнгэ са. ");
INSERT INTO rmylovari_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Алом на хан мас, тэ сы андэ лэс инкэ рат, саво сы траё. ");
INSERT INTO rmylovari_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ай анда рат тумаро Мэ манго потиныпэ. Мэ манго потин анда лэс катар сако алато, ви саконэ манушэстар авла Муро пущипэ анда лэско пралэско траё. ");
INSERT INTO rmylovari_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Кон тэ на щёрэл рат манушэско, манушэскэ вастэса щёрдёла ви лэско рат. Анда кадо кэ о мануш сы кэрдо па мусура лэ Дэвлэско. ");
INSERT INTO rmylovari_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ай тумэ кэрэн щяворэн ви кэрдён май бут ай пхэрдярэн э пхув, тэ авэл тумэн май бут. ");
INSERT INTO rmylovari_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Котар о Дэл пхэндас лэ Ноескэ ай лэскэ щявэнгэ: ");
INSERT INTO rmylovari_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","— Аканак Мэ пхандав ворба тумэнца ай тумарэ парапутёнца, ");
INSERT INTO rmylovari_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ай саконэ жювиндэ алатоса, саво сы тумэнца: чирикляса, кхэрутнэ вай вадно алатоса — саконэса, кон дас аври тумэнца анда ковчего, ай саконэ алатоса пэ пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Мэ пхандав ворба туса: шоға англэ са, со сы жювиндо, чи авла хасарадо барэ паенца; шоға англэ баро паи чи хасаравла э пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","О Дэл пхэндас: — Акэ вурма па ворба, сави Мэ пхандав машкар Мандэ ай тумэндэ, ай саконэ жювиндэ алатостэ, саво сы тумэнца, пэ са поколения, кай авна. ");
INSERT INTO rmylovari_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Мэ щював андэ нувэра Мури радуга, ай вой авла вурма па ворба машкар Мандэ ай э пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Кана тэ на ано нувэра пэ пхув, машкар нувэра сыкадёла радуга, ");
INSERT INTO rmylovari_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ай Мэ до ма гиндо па Мури ворба машкар Мандэ ай тумэндэ ви саконэ жювиндэ алатостэ; шоға май бут пая чи щёрдёна тэ хасаравэн са жювиндо. ");
INSERT INTO rmylovari_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Саки врама, кана сыкадёла радуга машкар лэ нувэра, Мэ дыкхо ла и до ма гиндо па ворба, пханглы пэ са врама машкар о Дэл ай са жювиндэ алатура, кон траин пэ пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Кадэ пхэндас о Дэл каринг о Ной: — Акэ вурма па ворба, сави Мэ щютэм машкар Мандэ ай са, со сы жювиндо пэ пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Щявэ лэ Ноескэ, савэ дынэ аври анда ковчего, сас Сим, Хам ай Яфет (Хам сы о дад лэ Ханааноско). ");
INSERT INTO rmylovari_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Кадал трин-женэ сы щявэ лэ Ноескэ, ай катар лэндэ сармозын лэ мануш, савэ рисписайлэ па пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Ной лас-пэ тэ сантый пхув ай тэ барарэл дракх. ");
INSERT INTO rmylovari_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Еквар, кана пилас мол, вов матилас ай пашлёлас нанго андэ пэски цэрға. ");
INSERT INTO rmylovari_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","О Хам, Ханааноско дад, дыкхлас о нангипэ пэскэ дадэско, ай кана дас аври, пурисардас па кадо пэскэ пралэнгэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Алом о Сим ай Яфет лынэ гада, щютэ лэн пэ пэскэ пхикэ, дынэ андрэ думэнца тай щерадэ о дадэско нангипэ. Лэнгэ муя сас болдынэ андэ кавэр риг тэ на дыкхэн дадэско нангипэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Кана о Ной тразосайлас ай жянглас, со кэрдас лэса май цыно щяво, ");
INSERT INTO rmylovari_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","вов пхэндас: — Дав армая Ханаанос! Палуно анда рабура авла вов пэскэ пралэнгэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Инкэ вов пхэндас: — Тэ авэл ғирэшо о Яхва, Дэл лэ Симоско! Тэ авэл Ханаан рабо лэ Симоско. ");
INSERT INTO rmylovari_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Тэ дэл о Дэл Яфетоскэ булғэ пхува, тэ траий Яфет андэ цэрғи лэ Симоскэ, ай тэ авэл Ханаан лэско рабо. ");
INSERT INTO rmylovari_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Пала барэ пая Ной траисардас трин шэла тай паньвардэш бэрш. ");
INSERT INTO rmylovari_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","О Ной траисардас инья шэла ай паньвардэш бэрш ай мулас. ");
INSERT INTO rmylovari_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Кадо сы панасы па вицы лэ Ноескэ щявэнгэ Сим, Хам ай Яфет, кастэ аракхадилэ щявэ пала барэ пая. ");
INSERT INTO rmylovari_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Яфетоскэ щявэ: Гомэр, Магог, Мадай, Яван, Тувал, Мешэх ай Тирас. ");
INSERT INTO rmylovari_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Гомэроскэ щявэ: Ашкеназ, Рифат ай Тогарма. ");
INSERT INTO rmylovari_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Яваноскэ щявэ: Элиша, Таршыш, Киттим ай Роданим. ");
INSERT INTO rmylovari_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Лэндар гэлэ пашапаескэ нацыи ай рисписайлэ па пэскэ пхува, машкар пэстэ мануш; вон уладэ-пэ машкар пэстэ па пэскэ щиба ай вицы. ");
INSERT INTO rmylovari_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Хамоскэ щявэ: Куш, Мицраим, Пут ай Ханаан. ");
INSERT INTO rmylovari_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Кушэскэ щявэ: Сева, Хавила, Савта, Раама ай Савтеха. Раамаскэ щявэ: Шэва ай Дедан. ");
INSERT INTO rmylovari_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Куш сас о дад ви лэ Нимродоско, саво кэрдилас англуно пэ пхув зурало войныко. ");
INSERT INTO rmylovari_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Вов сас зурало охотник англа Рай Яхва. Анда кадо ви пхэнэл-пэ: «Май баро охотник англа Рай Яхва, сар Нимрод». ");
INSERT INTO rmylovari_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Англунэ форура андо лэско краипэ сас Вавилон, Эрех, Аккад ай Халнэ андо тхэм Шынар. ");
INSERT INTO rmylovari_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Анда коды пхув вов гэластар андэ Ашшур, кай кэрадас Ниневия, Реховот-Ир, Калах ");
INSERT INTO rmylovari_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ай Ресен, машкар Ниневия ай Калах — баро форо. ");
INSERT INTO rmylovari_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Катар Мицраим сармозын луды, анамы, легавы, нафтухи, ");
INSERT INTO rmylovari_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","патрусы, каслухи (кастар гэлэ филистимы) ай кафторы. ");
INSERT INTO rmylovari_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Катар Ханаан сармозын лэско англуно щяво Сидон, Хет, ");
INSERT INTO rmylovari_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","ай инкэ евусы, аморы, гергесы, ");
INSERT INTO rmylovari_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","хиввы, арки, сины, ");
INSERT INTO rmylovari_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","арвады, цэмары ви хаматы. Май палал ханаанска нацыи рисписайлэ, ");
INSERT INTO rmylovari_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","ай андо Ханаан тхэмэскэ агора цырдэнас-пэ катар Сидон каринг Герар жи кай Газа, ай котар каринг Содом, Гоморра, Адма ай Цэвоим жи кай Лаша. ");
INSERT INTO rmylovari_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Касавэ сы парапутя ай нацыи, кай сармозын катар о Хам, па лэнгэ вицы, лэнга щибаса, андэ лэнгэ пхува. ");
INSERT INTO rmylovari_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Аракхадилэ щявэ ви кай о Сим, Яфетоско май пхуро прал. Катар о Сим сармозын са лэ Эвероскэ щявэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Симоскэ щявэ: Элам, Ашшур, Арпахшад, Луд ай Арам. ");
INSERT INTO rmylovari_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Арамоскэ щявэ: Уц, Хул, Гетэр ай Маш. ");
INSERT INTO rmylovari_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Кай о Арпахшад аракхадилас Шэлах, ай кай о Шэлах аракхадилас Эвер. ");
INSERT INTO rmylovari_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Кай о Эвер аракхадилэ дуй щявэ: о екх бущёлас Пелег (анда кадо кэ андэ лэскэ дес э пхув сас улады), ай лэско прал бущёлас Ёктан. ");
INSERT INTO rmylovari_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Кай Ёктан аракхадилэ щявэ: Алмодад, Шалеф, Хацармавет, Ерах, ");
INSERT INTO rmylovari_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Гадорам, Узал, Дикла, ");
INSERT INTO rmylovari_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Овал, Авимаэл, Шэва, ");
INSERT INTO rmylovari_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Офир, Хавила ай Ёвав. Са вон сас лэ Ёктаноскэ щявэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Лэ тхана, кай вон траинас, лунжярнас-пэ катар Меша жи кай харутно тхэм Сефар пэ ғайналоски риг. ");
INSERT INTO rmylovari_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Касавэ сы парапутя ай нацыи, кай сармозын катар о Сим, па лэнгэ вицы, лэнга щибаса, андэ лэнгэ пхува. ");
INSERT INTO rmylovari_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Касавэ сы нацыи, кай жян катар лэ Ноескэ щявэ, па лэнгэ вицы; пала барэ пая лэндар гэлэ са мануш пэ пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Атунчи андэ са э лума сас екх щиб ай екх ворбипэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Кана лэ мануш гэлэ андэ риг каринг о ғайнало, вон аракхлэ пхув машкар лэ хара андо тхэм Шынар ай лынэ тэ траин котэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Вон пхэндэ екх екхэскэ: — Тэ кэрдамас цэглы ай тэ пэкламас лэн мишто пэ яг. Мэштык лэ бар вон лынэ цэглы, савэ вон зурарнас машкар пэстэ смоласа. ");
INSERT INTO rmylovari_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Котар вон пхэндэ: — Тэ кэрадамас пэскэ форо, тэ авэл башня жи кай о чери, тэ ғирэшой-пэ амаро анав ай тэ на рисписайвас па са пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","О Рай Яхва мэклас-пэ тэлэ тэ дыкхэл по форо ай башня, кай кэравнас лэ мануш. ");
INSERT INTO rmylovari_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","О Рай Яхва пхэндас: — Акэ екх нацыя екха щибаса, ай вон фэри кэздысардэ кхэтанутны бути! Анда кадо вон ви бирина са, со камна тэ кэрэн. ");
INSERT INTO rmylovari_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Мэкас-амэ тэлэ ай ғамисарас лэнгэ щиб, тэ на атярэн вон екх екхэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Ай о Рай Яхва рисписардас лэн котар па са лума, ай вон ащядилэ тэ кэравэн кодо форо. ");
INSERT INTO rmylovari_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Эта анда кадо лэскэ щютэ анав Вавилон — кэ о Рай Яхва ғамисардас котэ са э лумаки щиб. О Рай Яхва рисписардас лэн котар па са пхувако муй. ");
INSERT INTO rmylovari_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Кадо сы панасы па вица лэ Симоски. Симоскэ сас екх 100 бэрш, кана лэстэ аракхадилас Арпахшад, па дуй бэрш, сар накхлэ лэ барэ пая. ");
INSERT INTO rmylovari_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Пала кодо, сар аракхадилас Арпахшад, Сим траисардас 500 бэрш, ай лэстэ инкэ сас щявэ тай щея. ");
INSERT INTO rmylovari_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Кана Арпахшад траисардас 35 бэрш, лэстэ аракхадилас Шэлах. ");
INSERT INTO rmylovari_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Пала кодо, сар аракхадилас Шэлах, Арпахшад траисардас 403 бэрш, ай лэстэ сас инкэ щявэ тай щея. ");
INSERT INTO rmylovari_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Кана Шэлах траисардас 30 бэрш, лэстэ аракхадилас Эвер. ");
INSERT INTO rmylovari_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Пала кодо, сар аракхадилас Эвер, Шэлах траисардас 403 бэрш, ай лэстэ инкэ сас щявэ тай щея. ");
INSERT INTO rmylovari_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Кана Эвер траисардас 34 бэрш, лэстэ аракхадилас Пелег. ");
INSERT INTO rmylovari_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Пала кодо, сар аракхадилас Пелег, Эвер траисардас 430 бэрш, ай лэстэ инкэ сас щявэ тай щея. ");
INSERT INTO rmylovari_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Кана Пелег траисардас 30 бэрш, лэстэ аракхадилас Реу. ");
INSERT INTO rmylovari_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Пала кодо, сар аракхадилас Реу, Пелег траисардас 209 бэрш, ай лэстэ сас инкэ щявэ тай щея. ");
INSERT INTO rmylovari_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Кана Реу траисардас 32 бэрш, лэстэ аракхадилас Серуг. ");
INSERT INTO rmylovari_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Пала кодо, сар аракхадилас Серуг, Реу траисардас 207 бэрш, ай лэстэ сас инкэ щявэ тай щея. ");
INSERT INTO rmylovari_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Кана Серуг траисардас 30 бэрш, лэстэ аракхадилас Нахор. ");
INSERT INTO rmylovari_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Пала кодо, сар аракхадилас Нахор, Серуг траисардас 200 бэрш, ай лэстэ сас инкэ щявэ тай щея. ");
INSERT INTO rmylovari_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Кана Нахор траисардас 29 бэрш, лэстэ аракхадилас Терах. ");
INSERT INTO rmylovari_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Пала кодо, сар аракхадилас Терах, Нахор траисардас 119 бэрш, ай лэстэ сас инкэ щявэ тай щея. ");
INSERT INTO rmylovari_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Пала кодо, сар Терах траисардас 70 бэрш, лэстэ аракхадилэ Аврам, Нахор ай Харан. ");
INSERT INTO rmylovari_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Акэ панасы па вица лэ Терахоски. Кай о Терах аракхадилэ Аврам, Нахор ай Харан. Кай о Харан аракхадилас Лот. ");
INSERT INTO rmylovari_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Кана лэско дад Терах сас инкэ жювиндо, Харан мулас андо Ур Касдимэнго, андэ пхув, кай вов аракхадилас. ");
INSERT INTO rmylovari_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Аврам ай Нахор лынэ пэскэ ромнян. Лэ Аврамоски ромни бущёлас Сара, ай лэ Нахороски ромни сас Милка, вой сас щей лэ Хараноски, саво сас дад э Милкако тай Искако. ");
INSERT INTO rmylovari_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Сара наштык сас тэ кэрэл щяворэн, ви ащёлас бищяворэнги. ");
INSERT INTO rmylovari_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Терах лас пэскэ щявэс Аврамос, пэскэ внукос Лотос, лэ Хараноскэ щявэс, ай пэска бора Сара, лэ Аврамоска ромня, ай вон гэлэтар кхэтанэ анда Ур Касдимэнго андо Ханаан. Алом, кана вон арэслэ жи кай Харан, ащилэ котэ тэ траин. ");
INSERT INTO rmylovari_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Терах траисардас 200 бэрш ай мулас андо Харан. ");
INSERT INTO rmylovari_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","О Рай Яхва пхэндас Аврамоскэ: — Ащяв тё тхэм, те манушэн ви дадэско кхэр ай жя кай э пхув, сави Мэ тукэ сыкаво. ");
INSERT INTO rmylovari_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Мэ кэро тэ сармозый тутар бари нацыя ай бахтяро тут; Мэ ғирэшоя тиро анав, ай ту авэса э бахт манушэнги. ");
INSERT INTO rmylovari_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Мэ бахтяро кодолэн, кон бахтярна тут, ай до армая кодолэн, кон дэл армая тут; ай анда тутэ авна бахтярдэ са вицы пэ пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Ай Аврам гэлас андо дром, сар пхэндас лэскэ о Рай Яхва, ай о Лот гэлас кхэтанэ лэса. Аврамоскэ сас эфтавардэш ай панжь бэрш, кана вов гэластар анда Харан. ");
INSERT INTO rmylovari_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Вов лас пэса пэска ромня ла Сара, пэскэ пралэскэ щявэс лэ Лотос, са пэско миштыпэ, саво вон кидэ, ви манушэн, савэн вон лынэ, кана сас андо Харан, ай вон гэлэ кай э пхув Ханаан ай авилэ котэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Аврам накхлас па коды пхув жи кай о тхан андо Шэхем, кай баролас баро копачи Морэ. Андэ коды врама котэ траинас ханааны. ");
INSERT INTO rmylovari_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","О Рай Яхва сыкадилас Аврамоскэ ай пхэндас: — Мэ до кады пхув тирэ парапутёнгэ. Аврам кэрадас котэ жэртвенник лэ Дэвлэскэ, Саво сыкадилас лэскэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Вов гэластар котар андо харэнго тхан пэ ғайналоски риг катар Бэт-Эль ай щютас котэ цэрға. Бэт-Эль сас лэстар пэ риг, кай бэшэл о кхам, ай о Гай пэ риг, кай ваздэл-пэ о кхам. Котэ вов кэрадас жэртвенник лэ Раскэ Яхваскэ ай рудисардас каринг лэстэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Котар Аврам лас-пэ па тхан ай гэлас май дур пэскэ дромэса каринг Негев. ");
INSERT INTO rmylovari_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Атунчи пэ пхув кэрдилас бокх, ай Аврам гэластар тэ бэшэл андо Египет, кэ э бокх сас насул. ");
INSERT INTO rmylovari_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Кана вон пашонас каринг о Египет, вов пхэндас пэска ромнякэ Саракэ: — Мэ жянав, соски шукар жювли ту сан. ");
INSERT INTO rmylovari_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Кана египтянура дыкхна тут, вон пхэнна: «Кады лэски ромни», — ай мударна ман, алом тут ащявна траимэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Пхэн, кэ ту сан мури пхэн, тэ инкэрдён манца мишто, ай анда тутэ тэ ащяв жювиндо. ");
INSERT INTO rmylovari_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Кана Аврам авилас андо Египет, египтянура дыкхлэ, кэ Сара сы зуралэс шукар, ");
INSERT INTO rmylovari_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","ай кана дыкхлэ ла фараоноскэ рай, вон ашардэ ла фараоноскэ, ай вов лас ла андо пэско кхэр. ");
INSERT INTO rmylovari_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Вов инкэрдёлас мишто Аврамоса анда латэ, ай Аврам киндас бакрэн, буснян ай гурувнян, самарэн — муршэн и жювлян, бутярнэн ай бутяркинен, ви верблюдон. ");
INSERT INTO rmylovari_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Алом о Рай Яхва мардас лэ фараонос ай са лэско кхэр пхарэ насвалиматэнца анда Аврамоски ромни Сара. ");
INSERT INTO rmylovari_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Атунчи фараоно акхардас Аврамос ай пущлас: — Со ту манца кэрдан? Состар чи пхэндан мангэ, кэ вой тири ромни? ");
INSERT INTO rmylovari_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Состар ту пхэндан: «Вой мури пхэн»? Анда кадо мэ лэм ла пэскэ ромнякэ. Эта тири ромни. Лэ ла ай жятар! ");
INSERT INTO rmylovari_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Фараоно дас аври пэскэ манушэнгэ па Аврам, ай вон бищядэ Аврамос андо дром лэска ромняса ай куса са, со сас лэстэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Аврам ла ромняса ай са пэскэ миштымаса традастар катар Египет андо Негев, ай о Лот гэлас лэса. ");
INSERT INTO rmylovari_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Аврам кэрдилас барвало, ай атунчи сас лэс бут кхэрутнэ алатура, руп ай сумнакай. ");
INSERT INTO rmylovari_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Анда Негев вов традас май дур ай пхирлас катар екх тхан каринг кавэр, жипон авилас андо Бэт-Эль, каринг кодо тхан, кай майинты тордёлас лэски цэрға, машкар Бэт-Эль ай Гай, ");
INSERT INTO rmylovari_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","каринг кодо тхан, кай вов майинты кэрадас жэртвенник. Котэ Аврам акхардас лэ Раско Яхваско анав. ");
INSERT INTO rmylovari_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Кай о Лот, саво индулыяс Аврамоса, ви лэстэ сас кырдура бакрэн, буснян ай гурувнен ви цэрғи, ");
INSERT INTO rmylovari_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","ай э пхув чи бирияс тэ хахавэл лэн солдон: лэндэ акарсо сас кати бут, кэ вон наштык сас тэ инкэрдён кхэтанэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Машкар лэ Аврамоскэ тай Лотоскэ чябаша кэрдилас чингар. Атунчи андэ кады пхув траинас ханааны тай перезы. ");
INSERT INTO rmylovari_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Атунчи Аврам пхэндас лэ Лотоскэ: — Мэк тэ на авэл чингар чи машкар тутэ ай мандэ, чи машкар тирэ ви мурэ мануш, кэ сам прала. ");
INSERT INTO rmylovari_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Чяк чи дыкхэс, кэ интрэги пхув пашлёл англа тутэ? Тэ уладиламас: тэ жяса ту по стунго, мэ бандярава по чячё, ай тэ жяса ту по чячё, мэ бандярава по стунго. ");
INSERT INTO rmylovari_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Лот дыкхлас ай атярдас, кэ са Ёрданско пхув жи кай Цоар мишто киндярэл-пэ паеса, сар э Раско Яхваско рэйс, сар э пхув андо Египет. Кадо сас инкэ англа кодо, сар о Рай Яхва пхагэрдас Содом тай Гоморра. ");
INSERT INTO rmylovari_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Лот алосардас пэскэ са э пхув па Ёрдан ай традас каринг ғайналоски риг. Вон уладилэ: ");
INSERT INTO rmylovari_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Аврам траияс пэ пхув Ханаанско, ай о Лот щювлас пэскэ цэрғи пэ машкархарэнги пхув машкар лэ форура надур катар Содом. ");
INSERT INTO rmylovari_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Лэ Содомоскэ мануш сас напативалэ ай зуралэс бэзэхалэ англа Рай Яхва. ");
INSERT INTO rmylovari_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","О Рай Яхва пхэндас лэ Аврамоскэ пала кодо, сар о Лот уладилас лэстар: — Ваздэ тирэ якха катар о тхан, кай сан аканак. Дыкх каринг шудри риг, каринг таты риг, ай каринг рига, кай ваздэл-пэ ай бэшэл о кхам. ");
INSERT INTO rmylovari_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Са э пхув, сави ту дыкхэс, Мэ до тукэ ай тирэ парапутёнгэ пэ са врама. ");
INSERT INTO rmylovari_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Мэ кэро тэ авэн бут тирэ парапутя, сар пхувако прахо, атунчи тэ бирия вари-кон тэ гинавэл прахо, ви тирэ парапутён гинавла. ");
INSERT INTO rmylovari_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Жя, накх кады пхув андо лунжипэ ай булғипэ, кэ Мэ дав ла тукэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Аврам кидас лэ цэрғи ай гэластар тэ траий паша уче копачя Мамрэ андо Хеврон. Вов кэрадас котэ жэртвенник лэ Раскэ лэ Яхваскэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Андэ коды врама Амрафел, край андо Шынар, Ариох, край андо Элласар, Кедорлаомер, край андо Элам, ай Тидал, край андо Гоим, ");
INSERT INTO rmylovari_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","кхэтанэ гэлэ маримаса пэ кавэр края: по Бера, край андо Содом, по Бирша, край андэ Гоморра, по Шынав, край андэ Адма, по Шэмевер, край андо Цэвоим, ай по край андэ Бела (Цоар). ");
INSERT INTO rmylovari_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Кадал кавэр края кидэ-пэ кхэтанэ пэ машкархарэнги пхув Сиддим (кай сы Лондо море). ");
INSERT INTO rmylovari_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Вон сас аба дэшудуй бэрш тэла зор лэ Кедорлаомероски, ай по дэшутрито бэрш ваздэ-пэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Андо дэшуштарто бэрш о Кедорлаомер куса края, каса вов кэрдас пайташыпэ, нирисардас о марипэ катар рефаимы андо Аштерот-Карнаим, катар зузы андо Гам, эмы андэ Шавэ-Кирьятаим ");
INSERT INTO rmylovari_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ай катар хоры паша Сеироскэ хара, каринг Эл-Паран, по агор ла пустыняко. ");
INSERT INTO rmylovari_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Котар вон болдынэ палпалэ ай авилэ кай Эн-Мишпат (Кадэш), ай лынэ маримаса са лэ амалекитэнги пхув, ай ви э пхув катар аморы, савэ траинас андо Хацацон-Тамар. ");
INSERT INTO rmylovari_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Сэмбэ лэнгэ гэлэ край Содомоско, край Гоморрако, край Адмако, край Цэвоимоско ай край Белако (Цоароско). Андэ Сиддимско пхув вон киздысардэ о марипэ ");
INSERT INTO rmylovari_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","по Кедорлаомер, край андо Элам, по Тидал. край андо Гоим, по Амрафел, край андо Шынар, ай по Ариох, край андо Элласар, — штар края сэмбэ панженгэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Андэ машкархарэнги пхув Сиддим сас бут смолакэ гропи; ай кана Содомоско тай Гоморрако края нашлэтар, бут кэтаны пэлэ андэ кодал гропи, ай кон ащилэ жювиндэ, нашлэ андэ хара. ");
INSERT INTO rmylovari_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Штар края астардэ са о миштыпэ андо Содом тай Гоморра, ай са лэнго хабэ, тай гэлэтар. ");
INSERT INTO rmylovari_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Вон инкэ лынэ пэса лэ Аврамоскэ пралэскэ щявэс Лотос, саво траияс андо Содом, ай ви са лэско миштыпэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Екх анда кодал, кон фирисайлас, авилас ай панаскодысардас па кадо евреёскэ Аврамоскэ. Аврам траияс надур катар уче копачя, савэ сас аморэскэ Мамрэскэ, кон сас прал Эшколоско ай Анэроско, — вон са сас Аврамоскэ пайташа. ");
INSERT INTO rmylovari_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Кана Аврам шундас, кэ лэско нямо сы астардо, вов кидас трин шэла тай дэшохто муршэн, кон аракхадилэ андо пэско кхэр ай биринас тэ марэн-пэ, нашлас пала штар края ай накхлас жи кай Дан. ");
INSERT INTO rmylovari_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ратяса Аврам уладас пэскэ манушэн, хуклас пэ края, трададас лэн ай жялас пала лэндэ жи кай Хова, пэ шудры риг катар Дамаск. ");
INSERT INTO rmylovari_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Вов лас лэндар са чёрдано барвалипэ ай пэскэ нямос лэ Лотос ви лэско миштыпэ куса жювля ай лэ кавэр мануш. ");
INSERT INTO rmylovari_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Кана Аврам болдэлас-пэ палпалэ пала ниришаго катар Кедорлаомер ай катар лэ края, савэ сас лэса, о Содомоско край дас аври тэ дыкхэл-пэ лэса машкархарэнги пхув, сави бущёлас Шавэ (Краицко пхув). ");
INSERT INTO rmylovari_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Мелхисэдэк, лэ Барэ Дэвлэско рашай ай Салимоско край, андас аври манро тай мол ");
INSERT INTO rmylovari_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","ай бахтярдас лэ Аврамос лэ ворбаса: — Бахтярдо тэ авэс, Аврам, катар о Баро Дэл, Кон кэрдас о чери ай э пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ай тэ ғирэшой-пэ о Баро Дэл, Саво дас тирэ душманон андэ тирэ васт. Атунчи Аврам дас лэскэ дэшто партя катар са миштымата. ");
INSERT INTO rmylovari_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Содомоско край пхэндас Аврамоскэ: — Болдэ мангэ палпалэ мурэ манушэн, ай лэ миштымата ащяв тукэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Алом о Аврам пхэндас лэ Содомоскэ краёскэ: — Мэ ваздав о васт каринг о Рай Яхва, о Баро Дэл, Саво кэрдас о чери тай э пхув, ай дав цолах ");
INSERT INTO rmylovari_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","тэ на лав тутар канчи, чи тхав, чи папученго бричинари. Чи ло канчи тиро, тэ на бирис тэ пхэнэс: «Мэ барвардэм Аврамос». ");
INSERT INTO rmylovari_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Мэ ло фэри кодо, со халэ мурэ мануш. Алом кон гэлас манца — Анэр, Эшкол ай Мамрэ — мэк лэн пэски партя. ");
INSERT INTO rmylovari_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Пала кадо о Рай Яхва сыкадилас Аврамоскэ ворбаса: — На дара, Аврам. Мэ сым тиро фиритори. Ғасныпэ тиро авла баро. ");
INSERT INTO rmylovari_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Алом о Аврам пхэндас: — Края, Рай Яхва, тэ ащяв бищяворэнго, соскэ мангэ барвалипэ? Саек муро миштыпэ пэрла каринг Мэшекоско щяво, о Элиэзэр анда Дамаск. ");
INSERT INTO rmylovari_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Аврам инкэ щютас пашэ: — Ту чи дан ман щяворэн, ай кавэрэ манушэскэ, кон траий андо муро кхэр, ащла муро миштыпэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","О Рай Яхва пхэндас лэскэ пэ кадо: — Лэскэ чи ащла тиро миштыпэ. Тутар, анда тиро сэмно, авла о кавэр, каскэ ащла са тиро. ");
INSERT INTO rmylovari_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Вов ингэрдас лэс аври тай пхэндас: — Дыкх по чери ай гинав черғая, тэ шай чячес гинавэс лэн. Ай пхэндас лэскэ: — Эта кати авна тирэ парапутя. ");
INSERT INTO rmylovari_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Аврам патяяс лэ Раскэ Яхваскэ, ай Вов дыкхлас пэ лэстэ сар по патявно ай чячюно мануш. ");
INSERT INTO rmylovari_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Инкэ Вов пхэндас лэскэ: — Мэ сым Яхва, Саво ингэрдас тут аври анда Ур Касдимэнго тэ дав тут кады пхув, тэ авэс газда пэ латэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Алом о Аврам пущлас: — О Края, Рай Яхва, сар мэ тэ жянав по чячипэ, кэ кады пхув авла мури? ");
INSERT INTO rmylovari_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","О Рай Яхва пхэндас лэскэ: — Ан Мангэ тринэ-бэршэнга гурувня, тринэ-бэршэнга бусня ай тринэ-бэршэнгэ бакрэс, ай ви гулумбо тэрнэ гулумборэса. ");
INSERT INTO rmylovari_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Аврам андас лэн Лэскэ, щиндас лэн пэ допашэстэ ай щютас екх котора сэмбэ кавэрэнгэ; алом вов чи щиндас пэ допашэстэ гулумбон. ");
INSERT INTO rmylovari_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Насул чирикля кидэнас-пэ по мурдалипэ, алом Аврам нашадас лэн. ");
INSERT INTO rmylovari_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Кана бэшэлас о кхам, лас Аврамос бари линдра; ай атунчи баро калипэ мэклас-пэ тэлэ, ай лас лэс бари дар. ");
INSERT INTO rmylovari_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Атунчи о Рай Яхва пхэндас лэскэ: — Жян, кэ тирэ парапутя индулына па стрийно пхув, лэн инкэрна сар рабон, авла лэн насул траё, ви ащла кадэ штар шэла бэрш. ");
INSERT INTO rmylovari_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Алом Мэ анда кадо до крис коды нацыя, пэ сави вон бутязына сар рабура, ай май палал вон жянатар котар барэ барвалимаса. ");
INSERT INTO rmylovari_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ту жясатар пачяса кай тирэ прапапура ай авэса прахомэ андо баро пхурипэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Андо штарто поколение тирэ парапутя болдэна-пэ катэ палпалэ, анда кадо кэ аморэнго бэзэх инкэ чи пхэрдилас жи кай о агор. ");
INSERT INTO rmylovari_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Кана о кхам бэшлас ай кэрдилас тюнярико, пэ екхатэ сыкадилэ пирори тхувазымэ ангарэнца ай э яг, ай вон накхлэ машкар щиндэ алатонгэ котора. ");
INSERT INTO rmylovari_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Андо кодо дес о Рай Яхва пханглас ворба лэ Аврамоса ай пхэндас: — Мэ дав кады пхув тирэ парапутёнгэ, катар э нал андо Египет жи кай э май бари нал Ефрат: ");
INSERT INTO rmylovari_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","э пхув, сави сы кай кены, кенезы, кедмоны, ");
INSERT INTO rmylovari_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","хеты, перезы, рефаимы, ");
INSERT INTO rmylovari_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","аморы, ханааны, гергесы ай евусы. ");
INSERT INTO rmylovari_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Сара, ромни лэ Аврамоски, чи кэрлас лэскэ щяворэн. Алом латэ сас бутяркиня анда Египет, сави бущёлас Агарь. ");
INSERT INTO rmylovari_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Ай э Сара пхэндас лэ Аврамоскэ: — О Рай Яхва чи дас ман щяворэн. Жя, пашлюв мура бутяркиняса: кам латар авна ман щявора. Аврам опрэ маладас по лако гиндо. ");
INSERT INTO rmylovari_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Ай атунчи, кана Аврам траисардас андо Ханаан дэш бэрш, Сара, лэски ромни, лас пэска бутяркиня, египтянка Агарь, ай дас ла ромнякэ пэскэ ромэскэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Вов пашлилас Агаряса, ай вой пэлас кхамны. Кана Агарь жянглас, кэ кхамны, вой кэрдилас бариманги англа пэски газдэкиня. ");
INSERT INTO rmylovari_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Атунчи Сара пхэндас лэ Аврамоскэ: — Ту сан дошало анда кодо, кэ мэ рыбдый латар. Мэ дэм э бутяркиня тукэ андо тхан, ай аканак вой жянэл, кэ сы кхамны, ай инкэрдёл каринг мандэ напативалэс. Мэк амэн дэл крисы о Рай Яхва. ");
INSERT INTO rmylovari_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","— Тири бутяркиня сы андэ тирэ васт, — пхэндас о Аврам. — Кэр ласа, со камэс. Атунчи Сара лас кадэ тэ кикидэл пэ Агарь, кэ коды нашластар латар. ");
INSERT INTO rmylovari_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Раско Яхваско Ангело аракхлас э Агарь андэ пустыня, надур катар пирово. Кадо пирово сас паша дром каринг Шур. ");
INSERT INTO rmylovari_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Вов пущлас: — Агарь, ла Сараки бутяркиня, катар авилан ай кай жяс? — Мэ нашав катар мури газдэкиня Сара, — пхэндас вой. ");
INSERT INTO rmylovari_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Атунчи о Раско Яхваско Ангело пхэндас лакэ: — Болдэ-ту палпалэ кай тири газдэкиня ай мэк тэлэ тё шэро англа латэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Инкэ о Раско Яхваско Ангело щютас пашэ: — Мэ кэро тирэ парапутя тэ авэн кати бут, кэ наштык авла тэ гинавэн лэн. ");
INSERT INTO rmylovari_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Инкэ о Раско Яхваско Ангело пхэндас лакэ: — Ту аканак сан кхамны, ай аракхадёла тутэ щяво. Дэ лэс анав Измаил, кэ о Рай Яхва шундас па тири кинозыя. ");
INSERT INTO rmylovari_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Вов авла, сар вадно самара: вов жяла сэмбэ саворэнгэ, ай саворэ жяна сэмбэ лэскэ. Вов лэла тэ траий андэ холи са пэскэ пралэнца. ");
INSERT INTO rmylovari_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Лэ Раскэ Яхваскэ, Саво ворбияс ласа, вой пхэндас: «Ту сан Эл-Рои». Ай щютас пашэ: — Адэнтый мэ дыкхлэм Кодолэс, Саво дыкхэл ман. ");
INSERT INTO rmylovari_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Акэ состар кодола хаингакэ дынэ анав Бээр-Лахай-Рои. Вов ви аканак сы котэ, машкар Кадэш ай Беред. ");
INSERT INTO rmylovari_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Агарь кэрдас лэ Аврамоскэ щявэс, ай Аврам дас лэ щявэскэ, кас вой кэрдас, о анав Измаил. ");
INSERT INTO rmylovari_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Аврамоскэ сас охтовардэш тай шов бэрш, кана Агарь кэрдас лэскэ Измаилос. ");
INSERT INTO rmylovari_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Кана Аврамоскэ сас иньявардэш тай инья бэрш, о Рай Яхва сыкадилас лэскэ ай пхэндас: — Мэ сым Дэл Са-Биримаско. Пхир англа Мандэ ай ав бидошако. ");
INSERT INTO rmylovari_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Пхандаса э ворба машкар Мандэ ай тутэ, ай Мэ до тукэ бут парапутя. ");
INSERT INTO rmylovari_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Аврам бандилас жи кай пхув, ай о Дэл пхэндас лэскэ: ");
INSERT INTO rmylovari_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","— Па Мури риг, акэ Мури ворба туса. Ту авэса дад бутэ нацыенго. ");
INSERT INTO rmylovari_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ту май бут чи бущёса Аврам; тиро анав авла Авраам, анда кадо кэ Мэ кэрдэм анда тутэ дад бутэ нацыенго. ");
INSERT INTO rmylovari_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ту авэса бутэ парапутёнго дад. Мэ кэро тэ киздын-пэ тутар бут нацыи, ай сармозына тутар края. ");
INSERT INTO rmylovari_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Мэ пхандава Мури ворба машкар Мандэ ай тутэ, ви тирэ парапутёндэ андэ поколения, кай авна пала тутэ, сар э ворба, пханглы пэ са врама: Мэ аво тиро Дэл ай о Дэл тирэ парапутёнго. ");
INSERT INTO rmylovari_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Интрэги пхув Ханаанско, кай ту сан стрийно аканак, Мэ до тукэ ай тирэ парапутёнгэ, кай авна пала тутэ, пэ ғинианя бэрш; ай Мэ аво лэнго Дэл. ");
INSERT INTO rmylovari_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","О Дэл пхэндас Авраамоскэ: — Па тири риг, ту трубуй тэ инкрэс Амари ворба, ту ай тирэ парапутя андэ поколения, савэ авна пала тутэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Акэ Мури ворба туса ай тирэ парапутёнца пала тутэ, сави ту трубуй тэ инкрэс: катар сако муршоро, кай аракхадёла, трубуй тэ авэл щиндо. ");
INSERT INTO rmylovari_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Саконэскэ трубуя тэ щинэн катар агорутны морчи, ай кадо авла э вурма пала ворба, кай Мэ пханглэм туса. ");
INSERT INTO rmylovari_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Андэ поколения, кай авна, катар сако тумаро муршоро трубуя тэ щинэл-пэ, кана лэскэ пхэрдёла охто дес, ви катар кодал, кон аракхадёна андо тиро кхэр, ви катар кодал, кон чи авна анда тири вица, ай авна киндэ пал ловэ катар стрийно мануш. ");
INSERT INTO rmylovari_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Ви катар кэрдэ андо тиро кхэр, ви катар киндэ пал ловэ трубуя тэ авэл щиндо. Мури ворба по тумаро мас авла э ворба пэ са врама. ");
INSERT INTO rmylovari_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Сако нащиндо муршоро, кастар чи щиндэ агорутны морчи, авла щюдыно аври катар пэскэ мануш, кэ вов пхаглас э ворба Манца. ");
INSERT INTO rmylovari_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Инкэ о Дэл пхэндас Авраамоскэ: — Ай па Сара, тири ромни, ту май бут чи пхэнэса пэ латэ Сара: лако анав авла Сарра. ");
INSERT INTO rmylovari_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Мэ бахтяро ла ай дав тукэ щявэс латар. Мэ бахтяро ла кадэ, кэ вой кэрдёла нацыенги дэй, латар сармозына нацыенгэ края. ");
INSERT INTO rmylovari_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Авраам бандилас жи кай пхув, асаяс ай гиндысардас: «Сар шай аракхадёл щяво кай шэлэ-бэршэнго мануш? Сар кэрла щяворэс э Сарра, каскэ аба иньявардэш?» ");
INSERT INTO rmylovari_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Авраам пхэндас лэ Дэвлэскэ: — Мишто тэ авило о Измаил траимэ ай бахтярдо англа Тутэ! ");
INSERT INTO rmylovari_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Атунчи о Дэл пхэндас: — Чячес, тири ромни Сарра кэрла тукэ щявэс, ай ту дэса лэскэ анав Исаак. Мэ пхандо Мури ворба лэса сар ворба пэ са врама лэскэ парапутёнгэ пала лэстэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ай па Измаил Мэ шундэм тут: Мэ чи бистро тэ бахтярав лэс; Мэ кэро тэ авэн лэс бут щявора ай тэ кэрдён инкэ май бут. Вов авла дад дэшудуе краенго, ай Мэ кэро тэ жял лэстар зуралэс бари нацыя. ");
INSERT INTO rmylovari_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Алом Мури ворба Мэ пхандав Исаакоса, кон аракхадёла кай э Сарра пала екх бэрш андэ кады врама. ");
INSERT INTO rmylovari_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Кана о Дэл ащядас пэски ворба каринг Авраам, Вов ваздас-пэ лэстар. ");
INSERT INTO rmylovari_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Андо кодо дес Авраам лас пэскэ щявэс Измаилос ай саворэн, кон аракхадилэ андо лэско кхэр вай сас киндэ пал ловэ, сако мурш андо лэско кхэр, ай щиндас лэндар, сар пхэндас лэскэ о Дэл. ");
INSERT INTO rmylovari_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Авраамоскэ сас иньявардэш бэрш, кана сас щиндо лэстар, ");
INSERT INTO rmylovari_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","ай лэскэ щявэскэ Измаилоскэ сас дэшутрин. ");
INSERT INTO rmylovari_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Авраам ай лэско щяво Измаил сас солдуй щиндэ андо екх дес. ");
INSERT INTO rmylovari_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Ай катар сако мурш андо Авраамоско кхэр, кон аракхадилас котэ вай сас киндо катар стрийно мануш, сас щиндо кхэтанэ лэса. ");
INSERT INTO rmylovari_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","О Рай Яхва сыкадилас Авраамоскэ паша уче копачя Мамрэ, кана вов бэшэлас англа пэски цэрға андо десеско пхабарипэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Авраам ваздас пэскэ якха ай дыкхлас, кэ надур тордён трин мануш. Кана дыкхлас лэн, вов щидярдас катар э цэрға каринг лэндэ ай бандилас англа лэндэ жи кай пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Вов пхэндас: — Тэ аракхлэм милошаго андэ Тирэ якха, муро Рай, дэн андрэ андо Тирэ слугако кхэр. ");
INSERT INTO rmylovari_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Мэк анэн эк-цэра паи тэ тховэн тумарэ пунрэ ай тэ пэғэнын тэла кадо копачи. ");
INSERT INTO rmylovari_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Дэн мангэ тэ анав тумэнгэ манро тэ зурайвэн, кэ саек авилан кай тумаро слуга. Ай котар жяна тумарэ дромэса. — Миштой, — пхэндэ вон. — Кэр, сар пхэнэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Атунчи Авраам щидярдас андэ цэрға кай э Сарра. Вов пхэндас: — Лэ май сыго трин чярэ май лащё аро, фурмунтысар хумэр ай пэк манро. ");
INSERT INTO rmylovari_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Пала кодо вов нашлас каринг о кырдо, кидас аври лащёрэ бурнювос ай дас бутярнэскэ, саво щидярдас тэ пэкэл лэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Котар вов андас кирал, тхуд ай гэтомэ бурнювэс ай щютас англа лэндэ. Жипон вон ханас, вов тордёлас паша лэндэ тэла копачи. ");
INSERT INTO rmylovari_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","— Кай сы тири ромни Сарра? — пущлэ вон. — Котэ, андэ цэрға, — пхэндас вов пэ кадо. ");
INSERT INTO rmylovari_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Атунчи о Дэл пхэндас: — Мэ чячес аво тутэ по кавэр бэрш, паша кады врама, ай кай э Сарра, тири ромни, авла щяво. Ай Сарра сас пала Авраамоско думо, андрэ, паша накхипэ ла цэрғако, ай шунлас. ");
INSERT INTO rmylovari_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Авраам ай Сарра сас аба пхурэ ай андэ барэ бэрш, ай Сарра аба наштык сас тэ кэрэл щяворэн. ");
INSERT INTO rmylovari_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Анда кадо Сарра асаяс андэ пэстэ гиндоса: «Мэ аба халилэм катар о траё, ай ви муро рай пхурилас. Шай мандэ инкэ авла касави лош?» ");
INSERT INTO rmylovari_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Атунчи о Рай Яхва пхэндас Авраамоскэ: — Состар э Сарра асал ай пхэнэл: «Шай чячес мандэ аракхадёла щяворо? Алом чяк мэ сым пхури!» ");
INSERT INTO rmylovari_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Тэ сы вари-со зуралэс пхаро лэ Раскэ Яхваскэ? Мэ аво тутэ палпалэ пала екх бэрш андэ кады врама, ай кай э Сарра авла щяво. ");
INSERT INTO rmylovari_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Сарра дарайлас ай хохадас: — Мэ чи асос. Алом Вов пхэндас: — На, ту асаяс. ");
INSERT INTO rmylovari_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Кана лэ мурш ваздэ-пэ, вон гэлэ каринг о форо Содом. Ай Авраам накхлас эк-цэра лэнца. ");
INSERT INTO rmylovari_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Атунчи о Рай Яхва пхэндас: «Шай Мэ тэ гаравав катар о Авраам кодо, со кидав-ма тэ кэрав? ");
INSERT INTO rmylovari_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Катар Авраам чячес жяла ғирэшо тай бари нацыя, ай са нацыи пэ пхув анда лэстэ авна бахтярдэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Кэ Мэ алосардэм лэс тэ бищявэл пэскэ щяворэн ай пэско челэдо тэ инкрэн-пэ Раскэ Яхваскэ дромэса ви тэ авэн лэнгэ траёскэ бутя чячюнэ ай пативалэ. Атунчи Мэ, Яхва, кэрав са, со щинадэм Авраамоскэ». ");
INSERT INTO rmylovari_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Атунчи о Рай Яхва пхэндас: — О цыпипэ анда Содом ай Гоморра сы касаво баро, лэнго бэзэх сы касаво пхаро, ");
INSERT INTO rmylovari_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","кэ Мэ мэко-ма тэлэ ай дыкхо, тэ кэрдэ вон чячес касавэ барэ насулимата, сар о ципипэ, кай рэслас ман. Тэ на, Мэ жяно. ");
INSERT INTO rmylovari_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Лэ мурш болдэ-пэ тай гэлэ каринг о Содом, алом Авраам кадэ ви тордёлас англа о Рай Яхва. ");
INSERT INTO rmylovari_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Авраам пашылас Лэстэ ай пхэндас: — Чячес шай хасаравэс чячюнэ манушэс кхэтанэ начячюнэса? ");
INSERT INTO rmylovari_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Ай тэ сы андо форо паньвардэш чячюнэ мануш? Ту саек хасаравэса ай чи сунуса кадо тхан анда паньвардэш чячюнэ? ");
INSERT INTO rmylovari_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ту наштык кэрэс кадэ — чи мударавэса чячюнэс куса начячюно, чи кэрэса екх солдонца. Ту наштык кэрэс кадэ! Са-лумако Крисынари кэрла фэри чячюнэс! ");
INSERT INTO rmylovari_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","О Рай Яхва пхэндас: — Тэ аракхо андо Содом паньвардэш чячюнэн, анда лэндэ сунуя кадо тхан. ");
INSERT INTO rmylovari_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Атунчи Авраам палэ пхэндас: — Акэ, мэ сым фэри прахо ай ватраки щял, алом чи дарайлэм тэ ворбий лэ Раса. ");
INSERT INTO rmylovari_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ай со авла, тэ авэл чячюнэн по панжь мануш май цэра, сар паньвардэш? Ту пхагрэса са о форо анда кодо, кэ чи арэсэла панжь мануш? — Тэ аракхо котэ штарвардэш тай панжь, — пхэндас Вов, — атунчи чи пхагро лэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Авраам инкэ еквар пущлас Лэс: — Ай тэ аракхадёна котэ фэри штарвардэш? Вов пхэндас: — Анда штарвардэш Мэ чи кэро кадо. ");
INSERT INTO rmylovari_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Атунчи кодо пхэндас: — Тэ на холяйвэл о Рай, алом тэ мэкэл ма тэ пхэнав. Ай тэ аракхадёна котэ фэри транда? Вов пхэндас пэ кадо: — Мэ чи кэро кадо, тэ аракхо котэ транда. ");
INSERT INTO rmylovari_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Авраам пхэндас: — Акэ, мэ сымас касаво тромашо, кэ лэм-ма тэ ворбий лэ Раса. Ай тэ аракхадёна котэ фэри биш? Вов пхэндас: — Анда биш Мэ чи пхагро лэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Атунчи Авраам пхэндас: — Тэ на холяйвэл о Рай, алом тэ мэкэл ма тэ ворбий инкэ фэри еквар. Ай тэ аракхадёна котэ фэри дэш? Вов пхэндас пэ кадо: — Анда дэш Мэ чи пхагро лэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Кана о Рай Яхва ащядас пэски ворба лэ Авраамоса, Вов гэластар, ай Авраам болдас-пэ кхэрэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Дуй ангелы авилэ андо Содом пала мизмэри, ай о Лот бэшэлас паша фороски капува. Кана дыкхлас лэн, ущилас, гэлас сэмбэ лэнгэ ай бандилас лэнгэ жи кай пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","— Мурэ рай, — пхэндас вов. — Мангав тумэн, накхэн андо кхэр кай тумаро слуга. Тумэ шай тховэн тумарэ пунрэ ай тэ ратярэн, ай по ғайнало палэ жяна тумарэ дромэса. — На, — пхэндэ вон пэ кадо, — амэ ратяраса по фороско пляцо. ");
INSERT INTO rmylovari_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Алом вов кадэ зурарлас, кэ вон накхлэ лэса ай дынэ андрэ андо лэско кхэр. Вов гэтосардас лэнгэ хабэ, пэклас постыцко манро, ай вон халэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Англа кодо, сар вон пашлилэ, лэ мурш анда интрэго Содом, тэрнэ ви пхурэ, круисардэ о кхэр. ");
INSERT INTO rmylovari_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Вон цыпинас лэ Лотоскэ: — Кай сы лэ мануш, кай авилэ тутэ пэ ратятэ? Ингэр лэн амэндэ, амэ камас тэ пашлювас лэнца. ");
INSERT INTO rmylovari_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Лот дас аври лэндэ, пхандадас пала пэстэ вудар ");
INSERT INTO rmylovari_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ай пхэндас: — На, мурэ пайташа, на кэрэн касаво насулыпэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Шунэн, мандэ сы дуй щея, савэ инкэ шоға нас муршэса. Тэ ингэрдэмас лэн тумэнгэ ай кэрэн лэнца, со камэн. Алом на кэрэн канчи кадалэ манушэнгэ, кэ вон авилэ тэла мурэ кхэрэско фиришаго. ");
INSERT INTO rmylovari_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Вон пхэндэ пэ кадо: — Жятар па дром! Ай щютэ пашэ: — Кадо авилас катэ стрийно, ай аканак камэл тэ кэрэл анда пэстэ крисынари! Амэ кэраса туса инкэ май насул, сар лэнца. Вон лынэ тэ кикидэн по Лот ай пашылэ тэ пхагрэн о вудар. ");
INSERT INTO rmylovari_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Алом лэ мурш, савэ ащнас андрэ, цырдэ лэ Лотос андо кхэр ай пхандадэ о вудар. ");
INSERT INTO rmylovari_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ай кодолэн, кон сас паша кхэрэско вудар, ви тэрнэн, ви пхурэн, вон корардэ кадэ, кэ кодал наштык аракхнас о вудар. ");
INSERT INTO rmylovari_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Ай кодал дуй мануш пхэндэ лэ Лотоскэ: — Сы тутэ инкэ вари-кон катэ — жямутрэ, щявэ, щея вай вари-кон инкэ андо форо анда тумарэ нямура? Ингэр лэн катар. ");
INSERT INTO rmylovari_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Амэ камас тэ пхаграс кадо тхан. О цыпипэ каринг о Рай Яхва анда кадал мануш сы касаво баро, кэ Вов бищядас амэн тэ пхаграс лэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Атунчи о Лот дас аври тэ ворбий лэ щявэнца, кон сас щинадэ тэ авэн ром лэскэ щеянгэ: — Щидярэн тэ жянтар катар май сыго, кэ о Рай Яхва кидэл-пэ тэ пхагрэл о форо! Алом кодал гиндысардэ, кэ вов кэрэл пэраса. ");
INSERT INTO rmylovari_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","По ғайнало лэ ангелы лынэ тэ щидярэн лэ Лотос ворбаса: — Щидяр! Ингэр катар тира ромня ай дуе щеян, вай хасайвэна, кана Дэвлэскэ армая пэрна по форо. ");
INSERT INTO rmylovari_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","О Лот цырдэлас врама, ай кодал дуй лынэ пала васт лэс, лэска ромня ви дуе щеян ай ингэрдэ лэн аври пала форо, кэ о Рай Яхва сас милошо каринг лэндэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Кана вон аба ингэрдэ лэн пала форо, екх анда мурш пхэндас: — Наш катар! На болдэ-ту тэ дыкхэс палпалэ ай на ащядюв кхатэ андо кадо тхан! Наш андэ хара, вай хасайвэса! ");
INSERT INTO rmylovari_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Алом о Лот пхэндас лэнгэ: — На, Рая, мангав тут! ");
INSERT INTO rmylovari_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Слуга Тиро аракхлас лащипэ андэ Тирэ якха, ай Ту дан ма баро милошаго, кана лас тэ фирис муро траё. Алом мэ наштык рэсав жи кай лэ хара: о насулыпэ астарэл ман, ай мэ мэро. ");
INSERT INTO rmylovari_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Дыкх, акэ цыно форицы надур, жи котэ бирий тэ нашав, ай вов набаро. Мэк ма тэ нашав котэ — кэ вов чяк цыноно, чячес? Атунчи муро траё авла фиримэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Вов пхэндас пэ кадо: — Мишто, Мэ кэро ви кадо, со манглан. Мэ чи пхаграв о форо, па саво пхэнэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Алом наш котэ май сыго, кэ Мэ наштык кэрав канчи, жипон ту рэсэса жи лэстэ. Акэ состар кодо форо лас тэ бущёл Цоар. ");
INSERT INTO rmylovari_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","О кхам аба ущилас, кана о Лот арэслас жи кай Цоар. ");
INSERT INTO rmylovari_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Атунчи о Рай Яхва щёрдас па чери по Содом тай Гоморра сар бришынд анда пхабарды сера. ");
INSERT INTO rmylovari_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Кадэ Вов хасарадас лэ форура ай са кады пхув ви саворэн, кон траияс андэ форура, ай са, со сас круял. ");
INSERT INTO rmylovari_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Алом э Лотоски ромни болдас-пэ тэ дыкхэл палпалэ ай кэрдилас лонэско стылбо. ");
INSERT INTO rmylovari_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","По кавэр ёкор Авраам ваздас-пэ по ғайнало ай болдас-пэ кай кодо тхан, кай вов тордёлас англа о Рай Яхва. ");
INSERT INTO rmylovari_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Вов дыкхлас опрал пэ Содом ай Гоморра, ай пэ са, со сас круял, ай лас сама: дэсо тхув ваздэл-пэ катар э пхув, сар тхув анда бов. ");
INSERT INTO rmylovari_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Кадэ, кана о Дэл пхагэрдас лэ форура андо кодо тхан, Вов дас пэ гиндо па Авраам ай фирисардас лэ Лотос катар насулыпэ, саво пхагэрдас лэ форура, андэ савэ трияс Лот. ");
INSERT INTO rmylovari_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Лот ай лэскэ дуй щея гэлэтар анда Цоар ай лынэ тэ траин андэл хара, кэ вов дарлас тэ ащел андо Цоар. Вов траияс пэскэ дуе щеянца андэ пещера. ");
INSERT INTO rmylovari_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Андо екх дес май пхури щей пхэндас май тэрнакэ: — Амаро дад пхуро, ай катэ кхатэ най мурш тэ пашлёл амэнца, сар кэрэл-пэ пэ са э пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Тэ матярдамас лэ дадэс моляса ай тэ пашлиламас лэса, тэ авэн амэндэ лэстар щявора ай тэ на хасайвэл амари вица. ");
INSERT INTO rmylovari_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Андэ коды рати вон матярдэ лэ дадэс моляса, ай э май пхури щей гэлас ай пашлилас лэса. Вов чи на чи жянглас па са кадо, кана вой пашлилас ай кана ущилас. ");
INSERT INTO rmylovari_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","По кавэр дес май пхури щей пхэндас ла май тэрнакэ: — Коды рати мэ пашлилэм лэ дадэса. Тэ матярдамас лэс моляса инкэ пэ ратятэ, ай ту жяса тай пашлёса лэса, тэ авэн амэндэ лэстар щявора ай тэ на хасайвэл амари вица. ");
INSERT INTO rmylovari_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Вон матярдэ лэ дадэс моляса ви андэ коды рати, ай май тэрны щей гэлас ай пашлилас лэса. Вов инкэ чи на чи жянглас па са кадо, кана вой пашлилас ай кана ущилас. ");
INSERT INTO rmylovari_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Кадэ солдуй Лотоскэ щея кэрдилэ кхамнэ катар лэнго дад. ");
INSERT INTO rmylovari_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Май пхури щей кэрдас щявэс ай дас лэс анав Моав; лэстар гэлэ адесутнэ моавы. ");
INSERT INTO rmylovari_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ви май тэрны щей кэрдас щявэс ай дас лэс анав Бэн-Амми; лэстар гэлэ адесутнэ аммоны. ");
INSERT INTO rmylovari_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Авраам кидас-пэ котар пэ пхув Негев ай траияс машкар Кадэш ай Шур. Вов бэшлас вари-соски врама андо Герар. ");
INSERT INTO rmylovari_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Котэ вов пхэндас па пэски ромни Сарра: «Вой сы мури пхэн». Атунчи Авимелех, край андо Герар, бищядас пала Сарра ай лас ла каринг пэстэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Алом о Дэл сыкадилас Авимелехоскэ ратяса андо суно ай пхэндас лэскэ: — Ту мэрэса анда кадо, кэ лан кадала жювля. Вой сы паларом. ");
INSERT INTO rmylovari_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Алом Авимелех чи азбадас ла ай анда кадо вов пхэндас: — Рая, Ту шай хасаравэс надошалэ манушэн? ");
INSERT INTO rmylovari_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Вов коркоро пхэндас мангэ: «Вой сы мури пхэн». Ай ви вой пхэндас: «Вов сы муро прал». Андо кадо баё мурэ гиндура ай мурэ васт ужэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Атунчи о Дэл пхэндас лэскэ андо суно: — Ова, Мэ жянав, кэ андо кадо баё те гиндура сас ужэ. Ай анда кадо Мэ инкэрдэм тут катар о бэзэх англа Мандэ. Анда кадо ви чи мэклэм тут тэ азбас ла. ");
INSERT INTO rmylovari_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Аканак болдэ палпалэ ромня манушэскэ, кэ вов сы пророко. Вов рудия анда тутэ, ай ту ащеса жювиндо. Алом тэ на болдэса ла палпалэ, жян, кэ ту ай тирэ пашутнэ мануш чи нашнатар катар о мэрипэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","По кавэр дес по ғайнало Авимелех кидас саворэ пэскэ дизакэ бутярнэн ай панаскодысардас лэнгэ, со кэрдилас, ай вон зуралэс дарайлэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Котар Авимелех акхардас Авраамос ай пхэндас: — Со ту кэрдан амэнца? Сави дош сы ма англа тутэ, кэ касаво пхаро бэзэх пэлас пэ мандэ ай по муро краипэ? Ту кэрдан манца кадэ, сар наштык кэрэн. ");
INSERT INTO rmylovari_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Ай Авимелех пущлас Авраамостар: — Со сас тутэ андэ годи, кэ ту кэрдан кадо? ");
INSERT INTO rmylovari_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Авраам пхэндас пэ кадо: — Мэ гиндысардэм: «Най дар катар о Дэл андо кадо тхан, ай катарутнэ мударна ман анда мури ромни». ");
INSERT INTO rmylovari_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ай инкэ вой чячес сы мури пхэн, мурэ дадэски щей, алом на мура датар. Вой кэрдилас мури ромни. ");
INSERT INTO rmylovari_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Кана о Дэл бищядас ман тэ индулый анда мурэ дадэско кхэр, мэ пхэндэм лакэ: «Акэ сар ту шай сыкавэс, сар ту камэс ман: кай тэ на авас, пхэн па мандэ \"Вов сы муро прал\"». ");
INSERT INTO rmylovari_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Атунчи Авимелех андас бакрэн, буснян ай гурувнян, рабон ай бутяркинян, ай дас лэн Авраамоскэ, ай болдас лэс палпалэ лэска ромня Сарра. ");
INSERT INTO rmylovari_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Авимелех пхэндас: — Мури пхув сы англа тутэ: траисар, кай камэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Сарракэ вов пхэндас: — Мэ дэм тирэ пралэскэ екх эзэро рупунэ ловэ, тэ щеравав тиро лажяво англа са тирэ манушэнгэ якха. Аканак тири патив сы вортомэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Атунчи Авраам рудисардас лэ Дэвлэскэ, ай о Дэл састярдас Авимелехос ай лэска ромня, ви рабойкэн, тэ кэрэн вон палэ щяворэн. ");
INSERT INTO rmylovari_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Ай англа кадо о Рай Яхва пхандадас сако жювляко пэр андо Авимелехоско кхэр анда Сарра, лэ Авраамоски ромни. ");
INSERT INTO rmylovari_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","О Рай Яхва, сар пхэндас, сас милошо каринг э Сарра ай кэрдас кодо, со щинадас лакэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Сарра пэлас кхамны ай кэрдас Авраамоскэ щявэс, кана вов сас аба пхуро, андэ коды врама, сар щинадас лэскэ о Дэл. ");
INSERT INTO rmylovari_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Авраам дас лэ щявэскэ, саво аракхадилас кай э Сарра, анав Исаак. ");
INSERT INTO rmylovari_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Кана лэскэ щявэскэ Исаакоскэ пхэрдилас охто дес, Авраам щиндас лэстар, сар дас лэскэ аври о Дэл. ");
INSERT INTO rmylovari_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Авраамоскэ сас екх шэл бэрш, кана аракхадилас лэстэ о щяво Исаак. ");
INSERT INTO rmylovari_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Э Сарра пхэндас: — О Дэл кэрдас ман тэ асав. Ай сако, кон шунла па кадо, асала кхэтанэ манца. — ");
INSERT INTO rmylovari_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ай щютас пашэ: — Тэ пхэндо вари-кон Авраамоскэ, кэ э Сарра хахавла колинэса! Алом мэ кэрдэм лэскэ щявэс по лэско пхурипэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","О щяворо барилас ай сас лыно катар о колин. Андо кодо дес, кана Исаак сас лыно колинэстар, Авраам кэрдас бари патив. ");
INSERT INTO rmylovari_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Сарра дыкхлас, кэ о щяво, кас кэрдас лэ Авраамоскэ египтянка Агарь, асал аври Исаакостар, ");
INSERT INTO rmylovari_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","ай пхэндас Авраамоскэ: — Нашав кадала рабойка ай лакэ щявэс. Лако щяво наштык авла тэ улавэл о барвалипэ мурэ щявэса Исаакоса. ");
INSERT INTO rmylovari_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Авраамоскэ кэрдилас пхаро анда кадо баё, кэ кодо сас лэско щяво. ");
INSERT INTO rmylovari_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Алом о Дэл пхэндас лэскэ: — На бунусар анда щяворо ай рабойка. Патя ла Саррако муй ай кэр са, сар вой пхэнэл, кэ тирэ парапутя авна кодал, кон жяна катар Исаак. ");
INSERT INTO rmylovari_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Алом Мэ кэро тэ сармозый екх нацыя ви катар о рабойкако щяво, кэ вов сы тиро парапутё. ");
INSERT INTO rmylovari_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","По кавэр дес по ғайнало Авраам ущилас, лас хабэ ай бурдюк паеса ай дас кай э Агарь. Вов щютас кадо лакэ по пхикэ ай пхэндас лакэ тэ жялтар лэ щяворэса. Вой гэлас андо дром ай пхирлас андэ пустыня андо тхан Бээр-Шэва. ");
INSERT INTO rmylovari_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Кана паи андо бурдюко начилас, вой ащядас о щяворэс тэла бур, ");
INSERT INTO rmylovari_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","дурайлас ай бэшлас май дур, сар тэ дэс пушкэ анда луко, кэ гиндыяс: «Наштык дыкхав, сар о щяворо мэрэл». Ай сар бэшлас котэ, ви рутас зуралэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","О Дэл шундас о роипэ лэ щяворэско, ай Ангело Дэвлэско акхардас э Агарь па чери ай пхэндас лакэ: — Сой туса, Агарь? На дара, о Дэл шундас, сар ровэл о щяворо котэ, кай вов пашлёл. ");
INSERT INTO rmylovari_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Ваздэ лэ щяворэс ай лэ лэс пала васт, кэ Мэ кэро тэ сармозый лэстар бари нацыя. ");
INSERT INTO rmylovari_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Атунчи о Дэл путэрдас лакэ якха, ай вой дыкхлас хаинг паеса. Вой гэлас, пхэрдас о бурдюко паеса ай дас тэ пэл лэ щяворэскэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","О Дэл сас лэ щяворэса, кана вов баролас. Вов траияс андэ пустыня ай мишто пушказыяс анда луко. ");
INSERT INTO rmylovari_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Вов траияс андэ пустыня Паран. Лэски дэй лас лэскэ ромня анда Египет. ");
INSERT INTO rmylovari_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Андэ коды врама Авимелех ай Пихол, кон сас паранчёдашы пэ лэскэ кэтаны, пхэндэ лэ Авраамоскэ: — О Дэл сы туса андо сако фэло, со ту кэрэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Атунчи цолахар мангэ катэ англа Дэл, со ту чи хохавэса чи ман, чи мурэ щяворэн, чи мурэ парапутён. Кэр мангэ ай лэ тхэмэскэ, кай ту траис сар стрийно, касаво милошаго, саво мэ кэрдэм тукэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Авраам пхэндас: — Цолахав. ");
INSERT INTO rmylovari_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Котар Авраам щютас пэ якха Авимелехоскэ пала хаинг паеса, сави астардэ Авимелехоскэ бутяра. ");
INSERT INTO rmylovari_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Алом Авимелех пхэндас: — Мэ чи жянав, кон кадо кэрдас. Ту чи пхэнэсас мангэ, ай жи кай адесутно дес мэ чи шундэм па кадо. ");
INSERT INTO rmylovari_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Авраам андас бакрэн, буснян ай гурувнян ай дас лэн каринг о Авимелех, ай лэ дуй мурш пханглэ машкар пэстэ ворба. ");
INSERT INTO rmylovari_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Авраам уладас анда кырдо эфта тэрнэ бакрян. ");
INSERT INTO rmylovari_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Авимелех пущлас Авраамостар: — Со сы кадал эфта тэрнэ бакря, савэн ту щютан ригатэ? ");
INSERT INTO rmylovari_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Вов пхэндас: — Мангав, лэ кадалэ эфта тэрнэ бакрян анда мурэ васт, тэ сыкавэл кадо, кэ мэ ғунадэм кады хаинг, ай вой сы мури. ");
INSERT INTO rmylovari_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Акэ состар кадо тхан лас тэ бущёл Бээр-Шэва. Котэ дуй мурш солдуй цолахардэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Пала кодо сар пханглэ ворба андэ Бээр-Шэва, Авимелех ай Пихол, кон сас паранчёдашы пэ лэскэ кэтаны, болдэ-пэ палпалэ пэ филистимэнги пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Авраам щютас тэ барол о копачи тамариск андэ Бээр-Шэва ай акхардас котэ анав лэ Яхваско, Кон сы Дэл Миндык Жювиндо. ");
INSERT INTO rmylovari_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ай Авраам траисардас пэ пхув филистимэнги бут врама. ");
INSERT INTO rmylovari_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Па врама о Дэл зумадас лэ Авраамоско патяипэ. Вов акхардас лэс: — Авраам! — Мэ катэ сым, — пхэндас о Авраам. ");
INSERT INTO rmylovari_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Атунчи о Дэл пхэндас: — Лэ тирэ щявэс, тирэ екхорэ щявэс Исаакос, савэс ту камэс, ай жя каринг э пхув Мориа. Пэ хар, пэ сави Мэ сыкаво тукэ, дэ лэс котэ сар жэртва ай пхабар лэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","По кавэр дес ёкор дэтэғара Авраам ущилас ай щютас самара тэла зэн. Вов лас пэса дон тэрнэ бутярэн ай пэскэ щявэс Исаакос. Кана вов пхарадас лэ кашт, вов гэлас каринг кодо тхан, па саво пхэндас лэскэ о Дэл. ");
INSERT INTO rmylovari_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","По трито дес Авраам ваздас лэ якха ай дыкхлас дэ дурал кодо тхан. ");
INSERT INTO rmylovari_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Вов пхэндас лэ бутярнэнгэ: — Ащен катэ самараса, ай амэ лэ щяворэса жяса котэ. Амэ кэраса рудипэ ай котар болдаса-амэ палпалэ тумэндэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Авраам лас э кашт пхабаримаскэ ай щютас лэн по думо пэскэ щявэскэ Исаакоскэ, ай коркоро лас яг ай щюри. Вон дуй-женэ гэлэ андо дром. ");
INSERT INTO rmylovari_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Исаак пхэндас пэскэ дадэскэ Авраамоскэ: — Дадэ! — Со, муро щяво? — пхэндас палпалэ Авраам. — Амэндэ сы яг ай кашт, — пхэндас Исаак, — алом кай сы бакроро тэ дас сар жэртва? ");
INSERT INTO rmylovari_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Авраам пхэндас пэ кадо: — О Дэл Коркоро алосарла бакрорэс, муро щяво. Ай вон гэлэ май дур дуй-женэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Кана вон арэслэ каринг о тхан, саво сыкадас лэскэ о Дэл, Авраам кэрадас котэ жэртвенник ай ракисардас пэ лэс кашт. Вов пханглас пэскэ щявэс Исаакос ай щютас лэс по жэртвенник опрал пэ кашт. ");
INSERT INTO rmylovari_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Пала кадо вов лунжярдас о васт ай лас щюри тэ щинэл пэскэ щявэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Алом о Раско Яхваско Ангело цыписардас каринг лэстэ па чери: — Авраам! Авраам! — Мэ катэ сым, — пхэндас вов. ");
INSERT INTO rmylovari_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","— На ваздэ о васт по щяворо, — пхэндас Вов. — На кэр лэса канчи. Мэ аканак жянав, кэ ту дарас катар о Дэл, кэ чи сунусардан тэ дэс Мангэ лэ щявэс, тирэ екхорэ щявэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Авраам ваздас лэ якха ай дыкхлас бакрэс, саво кицысайлас шынгэнца андэ бур. Вов гэлас, лас лэ бакрэс мэштык щяво, щиндас лэс ай пхабардас. ");
INSERT INTO rmylovari_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Авраам щютас анав кадалэ тханэскэ «Яхва-Йирэ». Анда кадо жи кай аканак пхэнэл-пэ: «Пэ Яхваски хар авла алосардо». ");
INSERT INTO rmylovari_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","О Раско Яхваско Ангело акхардас Авраамос па чери по дуйто ");
INSERT INTO rmylovari_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","ай пхэндас: — Мэ, Яхва, дав-ма армая Коркоро Пэса. Кэ ту кэрдан кадо ай чи сунусардан Мангэ тирэ щявэс, тирэ екхорэ щявэс, ");
INSERT INTO rmylovari_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Мэ дав ворба тэ алдый тут ай тэ кэрав тэ авэн бут тирэ парапутя, сар лэ черғая по чери ай сар кишай по моряко сало. Тирэ парапутя лэна зораса лэ форура катар лэнгэ душманура. ");
INSERT INTO rmylovari_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Анда тирэ парапутя авна алдымэ са лэ нацыи пэ пхув, кэ ту патяян Муро муй. ");
INSERT INTO rmylovari_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Атунчи Авраам болдас-пэ палпалэ кай пэскэ бутярнэ, ай вон гэлэ кхэтанэ андэ Бээр-Шэва. Ай Авраам ащилас тэ траий андэ Бээр-Шэва. ");
INSERT INTO rmylovari_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Накхлас врама, ай Авраамоскэ пхэндэ: — Милка кэрдилас дэй. Вой кэрдас щявэн тирэ пралэскэ Нахороскэ: ");
INSERT INTO rmylovari_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Уцос, кай сы англуно, Бузос, лэскэ пралэс, Кемуэлос (Арамоскэ дадэс), ");
INSERT INTO rmylovari_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Кеседос, Хазос, Пилдашос, Идлафос ай Бэтуэлос. ");
INSERT INTO rmylovari_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Бэтуэл кэрдилас Ревекако дад. Кадалэ охто щявэн Милка кэрдас Авраамоскэ пралэскэ Нахороскэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Лэски наложница, кай бущёлас Реума, ви вой кэрдас лэскэ щявэн: Тевахос, Гахамос, Тахашос ай Маахас. ");
INSERT INTO rmylovari_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Сарра траисардас шэл тай биштафта бэрш. ");
INSERT INTO rmylovari_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Вой мулас андо Кирьят-Арба (Хеврон) андэ Ханаанско пхув, ай Авраам авилас тэ бригий па Сарра ай тэ ровэл па латэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Пала кадо Авраам дурайлас катар мулы ромни ай лас тэ ворбий лэ хетэнца. Вов пхэндас: ");
INSERT INTO rmylovari_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","— Мэ машкар тумэндэ сым стрийно мануш ай най ман пэски пхув. Бикнэн мангэ котор пхув тэ кэравав крипта, тэ прахосарав ла мула. ");
INSERT INTO rmylovari_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Хеты пхэндэ палпалэ Авраамоскэ: ");
INSERT INTO rmylovari_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","— Рая, шун, ту сан ғирэшо край катар о Дэл машкар амэндэ. Прахосар тя мула по май лащё анда амарэ прахомаскэ тхана. Кхоник амэндар чи пхэнла ворба сэмбэ тэ дэн тукэ прахомаско тхан тэ прахос тя мула. ");
INSERT INTO rmylovari_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Атунчи Авраам ущилас ай бандилас англа манушэндэ андэ коды пхув, англа хетэндэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Вов пхэндас лэнгэ: — Тэ сан тумэ гата тэ дэн мангэ тэ прахой мура мула, атунчи шунэн ман ай мангэн катар муро анав Эфронос, лэ Цохарэскэ щявэс, ");
INSERT INTO rmylovari_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","тэ бикнэл мангэ пэски пещера Махпела, кай сы по агор лэска маляко. Мэк бикнэл ла мангэ пала интрэги тимин, сар о прахомаско тхан машкар тумэндэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Хет Эфрон бэшлас машкар пэскэ мануш ай пхэндас палпалэ пэ Авраамоски ворба англа саворэ хеты, савэ авилэ каринг фороски капува. ");
INSERT INTO rmylovari_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Вов пхэндас: — На, рая, шун ман. Мэ дав тукэ мал ай дав ви пещера, сави сы пэ латэ. Мэ дав тукэ кодо пэ якха англа са мурэ мануш. Прахосар тя мула. ");
INSERT INTO rmylovari_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Авраам палэ бандилас англа кодола пхувакэ мануш ");
INSERT INTO rmylovari_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ай пхэндас Эфроноскэ англа лэндэ: — Атунчи шун ви ту ман, мангав тут. Мэ потино ла маляки тимин. Лэ мандар кадо потин тэ бирий тэ прахой котэ ла мула. ");
INSERT INTO rmylovari_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Эфрон пхэндас палпалэ Авраамоскэ: ");
INSERT INTO rmylovari_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","— Шун ман, рая. Э пхув кэрэл штар шэла шэкели рупэса — кадо чяк най бут чи тукэ, чи мангэ. Прахосар тя мула. ");
INSERT INTO rmylovari_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Авраам опрэ маладас пэ Эфроноски ворба ай потиндас лэскэ э тимин, сави сас щюты англа хеты: штар шэла шэкели рупэса, сар гинавэн-пэ руп машкар лэ бикинытора. ");
INSERT INTO rmylovari_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Кадэ э мал Эфроноски андо Махпела паша Мамрэ — э мал, ай ви пещера пэ латэ, ай са лэ копачя андэ малякэ агора — са кэрдилэ ");
INSERT INTO rmylovari_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Авраамоскэ англа са лэ хеты, савэ сас паша фороски капува. ");
INSERT INTO rmylovari_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Пала кадо Авраам прахосардас пэска ромня Сарра андэ пещера пэ Махпеласки мал паша Мамрэ (андо Хеврон) андэ Ханаанско пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Кадэ э мал ай э пещера пэ латэ пэлэ катар лэ хеты каринг о Авраам сар прахомаско тхан. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Авраам сас аба пхуро, андэ бэрш, ай о Рай Яхва бахтярдас лэс андэ са. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Авраам пхэндас май барэ кхэрутнэ бутярэскэ андо пэско кхэр, саво визэрияс по са, со лэстэ сас: — Щюв тиро васт тэла мури пулпа ");
INSERT INTO rmylovari_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ай цолахар мангэ лэ Яхваса, Кон сы Дэл лэ черэско ай Дэл ла пхувако, кэ ту чи лэса пала муро щяво ромня анда ханааны, машкар савэ мэ траий, ");
INSERT INTO rmylovari_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","алом жяса андо муро тхэм ай кай мурэ нямура, ай котэ лэса ромня мурэ щявэскэ Исаакоскэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Бутяри пущлас лэс: — Ай тэ на камла коды жювли тэ авэл манца катэ, андэ кады пхув? Со мэ атунчи тэ кэрав, тэ бищявав тирэ щявэс андо тхэм, катар ту авилан? ");
INSERT INTO rmylovari_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Авраам пхэндас пэ кадо: — Со тэ на авла, на бищяв палпалэ котэ мурэ щявэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Яхва, Дэл лэ черэско, Саво ингэрдас ман анда мурэ дадэско кхэр ай катар э пхув мурэ нямонги, Саво ворбияс манца ай цолохардас мангэ ворбаса: «Мэ до кады пхув тирэ парапутёнгэ», — Вов бищявла Пэскэ Ангелос англа тутэ тэ бирис тэ лэс котар ромня мурэ щявэскэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Тэ на камла жювли тэ авэл туса, атунчи ту авэса скипимэ катар тири цолах. Фэри на бищяв котэ палпалэ мурэ щявэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","О бутяри щютас о васт тэла пэскэ газдаски Авраамоски пулпа ай цолахардас лэскэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Пала кадо о бутяри лас дэшэн анда пэскэ раскэ верблюдура, ракисардас пэ лэндэ май лаще подарки лэстар ай традас андо дром. Вов гэлас андо Арам-Нахараим, па дром каринг о Нахороско форо. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Вов пашлярдас верблюдон пэ чянга паша пирово пала форо. Кадо сас пала мизмэри, кана лэ жювля жян аври пала паи. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Вов пхэндас: — О, Рая Яхва, мурэ газдаско Авраамоско Дэл! Дэ мангэ бахт адес ай сыкав милошаго каринг муро газда Авраам. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Дыкх, мэ тордював паша пирово, ай лэ щея фороскэ жян пала паи. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Мэк тэ авэл кадэ. Тэ пхэно щякэ: «Мангав, мэк тэлэ па пхико о кхоро мэ тэ пав», ай вой тэ пхэнла: «Пи, ай мэ дав паи ви тирэ верблюдонгэ», вой ви авла коды, сава Ту щинадан Тирэ бутярэскэ Исаакоскэ. Кадэ мэ жяно, кэ Ту сыкадан милошаго каринг муро газда. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Инкэ вов чи дас гата пэскэ ворби, сар каринг о пирово авилас Ревека кхорэса по пхико. Вой сас щей лэ Бэтуэлоски, саво сас ла Милкако щяво, Нахороски ромняко, ай Нахор сас Авраамоско прал. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Вой сас зуралэс шукар щей, пативалы щеёри, сави инкэ нас муршэса. Вой мэклас-пэ тэлэ каринг о пирово, пхэрдас кхоро ай гэлас палпалэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","О бутяри щидярдас тэ жял сэмбэ лакэ ай пхэндас: — Мангав тут, дэ мангэ эк-цэра паи анда тиро кхоро. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","— Пи, рая, — пхэндас вой, сыго мэклас тэлэ о кхоро пэ васт ай дас лэскэ тэ пэл. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Кана э щей дас лэскэ тэ пэл, вой пхэндас: — Мэ пхэрав паи ви тирэ верблюдонгэ, жипон вон чи ащявна лэнги труш. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Вой сыго щёрдас паи анда кхоро андэ алатонги балаи, нашлас палпалэ кай о пирово тэ пхэрэл инкэ паи, ай анлас паи жипон чи кэрдилас доста саворэ лэскэ верблюдонгэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Вов би ворбако лэлас сама пала латэ ай камлас тэ атярэл, дас вай на о Рай Яхва бахт лэскэ индулымаскэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Кана верблюдура ащядилэ тэ пэн, о мануш лас аври сумнакуны накхэски злаг, пхаримаса андэ екх бэка, ай дуй сумнакунэ браслеты, пхаримаса андэ дэш шэкели, ");
INSERT INTO rmylovari_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","ай пущлас: — Каски щей ту сан? Пхэн мангэ, сы кай тиро дад андо лэско кхэр соба тэ ратярас? ");
INSERT INTO rmylovari_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Вой пхэндас лэскэ пэ кадо: — Мэ сым Бэтуэлоски щей, саво сы ла Милкако щяво, кас вой кэрдас Нахороскэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","— Ай щютас пашэ: — Амэндэ сы бут ви сулума, ви алатонго хабэ, ай сы соба тэ ратярэн. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Атунчи вов бандилас ай рудисардас лэ Раскэ Яхваскэ ");
INSERT INTO rmylovari_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","ворбаса: — Ашарав лэ Яхвас, мурэ газдаско Авраамоско Дэвлэс, Саво чи ащядас мурэ газдас би Пэско милашаго ай чи бистэрдас па лэстэ. О Рай Яхва андас ман ворта андо кхэр кай мурэ газдаскэ нямура. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Э щей нашлас кхэрэ кай пэски дэй ай панаскодысардас па кадо саворэнгэ, кон сас котэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Кай э Ревека сас прал по анав Лаван, ай вов щидярдас кай о мануш паша пирово. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Фэри вов дыкхлас э злаг андо накх ай э браслеты пэ васт кай пэски пхэн ай шундас катар э Ревека, со пхэндас кодо мануш, вов гэлас лэстэ. Кодо кадэ ви тордёлас куса верблюдура паша пирово. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","— Ав амэндэ, бахтярдо лэ Раса Яхваса, — пхэндас о Лаван. — Состар ту тордёс катэ аврал? Мэ гэтосардэм о кхэр тукэ ай о тхан верблюдонгэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Атунчи о мануш накхлас андо кхэр, ай па верблюдура лынэ тэлэ пхаримата. Верблюдонгэ дынэ кхас ай хабэ, ай Авраамоскэ бутярэскэ ви лэскэ манушэнгэ андэ паи тэ тховэн лэ пунрэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Котар англа лэстэ щютэ хабэ, алом вов пхэндас: — Мэ чи хо, жипон чи пхэно па муро баё. — Атунчи пхэн амэнгэ, — пхэндэ лэскэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ай вов пхэндас: — Мэ сым слуга лэ Авраамоско. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","О Рай Яхва бут бахтярдас мурэ рас, ай вов кэрдилас барвало. Вов дас лэс бакрэн, буснян ай гурувнян, руп ай сумнакай, рабон ай бутяркинян, верблюдон ай самарэн. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Мурэ раски ромни Сарра кэрдас лэскэ щявэс по пхурипэ, ай вов ащядас лэскэ са, со сы лэстэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Ай муро рай щютас ма тэ цолахав ай пхэндас: «Наштык тэ лэс ромня мурэ щявэскэ катар ханаанонгэ щея, андэ каски пхув мэ траий. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Алом жя кай мурэ дадэско челэдо, кай мурэ нямура, ай лэ котар ла ромня мурэ щявэскэ». ");
INSERT INTO rmylovari_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Атунчи мэ пущлэм мурэ рас: «Ай тэ на камла э жювли тэ жял манца?» ");
INSERT INTO rmylovari_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Вов пхэндас пэ кадо: «О Рай Яхва, англа кастэ мэ пхирав, бищявла туса Пэскэ Ангелос ай дэла бахт тирэ индулымаскэ, тэ лэс ромня мурэ щявэскэ анда мурэ нямура ай анда мурэ дадэско челэдо. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Кана ту жяса кай мурэ нямура, тэ на дэна ла тукэ, ту аба авэса скипимэ катар кады цолах». ");
INSERT INTO rmylovari_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Кана мэ адес авилэм кай о пирово, мэ пхэндэм: «О Яхва, мурэ раско Авраамоско Дэл! Мангав, фэри тэ камэса, шай дэса бахт индулымаскэ, кай сым бищядо! ");
INSERT INTO rmylovari_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Дыкх, мэ тордював паша кадо пирово: тэ авла щей пала паи, ай мэ пхэно лакэ: \"Мангав, дэ мангэ тэ пав эк-цэра паи анда тиро кхоро\", ");
INSERT INTO rmylovari_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ай вой тэ пхэнла мангэ: \"Пи, ай мэ пхэрав паи ви тирэ верблюдонгэ\", мэк вой тэ авэл коды, кас щинадас о Рай Яхва мурэ раскэ щявэскэ». ");
INSERT INTO rmylovari_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Инкэ мэ чи дэм гата мурэ ворби андо муро ило, кана авилас Ревека кхорэса по пхико. Вой мэклас-пэ тэлэ каринг о пирово ай пхэрдас паи. Мэ пхэндэм лакэ: «Мангав тут, дэ мангэ тэ пав». ");
INSERT INTO rmylovari_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Вой сыго мэклас тэлэ о кхоро па пхико ай пхэндас: «Пи, ай мэ до паи ви тирэ верблюдонгэ». Ай мэ пилэм паи, ай вой дас паи ви верблюдонгэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Мэ пущлэм ла: «Каски щей ту сан?» Вой пхэндас: «Мэ сым Бэтуэлоски щей, саво сы Нахороско щяво, кас Милка кэрдас лэскэ». Атунчи мэ щютэм злаг андо лако накх ай браслеты пэ лакэ васт ");
INSERT INTO rmylovari_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","ай бандилэм каринг э пхув англа Рай Яхва. Мэ ашардэм лэ Яхвас, мурэ газдаско Авраамоско Дэвлэс, Саво андас ман чячюнэ дромэса тэ лав мурэ газдэскэ пралэска внучка пала лэско щяво. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Атунчи, тэ авна милоша ай чяче каринг муро рай, кадэ ви пхэнэн мангэ. Ай тэ на, ви кадо пхэнэн, мэ тэ жянав, со тэ кэрав. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Лаван ай Бэтуэл пхэндэ палпалэ: — Кадо жял катар о Рай Яхва; амэ чи бирисарас канчи андэ кады бути. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Акэ э Ревека англа тутэ. Лэ ла ай жя, ай мэк вой авла ромни тирэ раскэ щявэскэ, сар щютас о Рай Яхва. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Кана о слуга Авраамоско шундас кадал ворби, вов бандилас англа Рай Яхва жи кай э пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Котар вов лас аври ураимата ай пхираимаско сумнакай тай о руп ай дас лэн кай э Ревека; ви лакэ пралэскэ тай э дакэ вов дас куч подарки. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Пала кадо вов ай ви лэ мануш, кон сас лэса, халэ, пилэ ай ащилэ тэ ратярэн. Кана по кавэр дес ёкор вон ущилэ, вов пхэндас: — Мэкэн ман андо дром каринг муро рай. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Алом Ревекакэ прал ай дэй пхэндэ: — Мэк э щей ащел амэнца инкэ дэш дес; котар шай жяс. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ай вов пхэндас: — На зибэин ман, тэ дас о Рай Яхва бахт мурэ баёскэ. Мэкэн ман андо дром тэ болдав-ма палпалэ кай муро рай. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Атунчи вон пхэндэ: — Акхарас ла щя ай пущяс латар. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Вон акхардэ Ревека ай пущлэ латар: — Жяс кадалэ манушэса? — Жяв, — пхэндас вой. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Ай вон бищядэ пэска пха Ревека андо дром куса бутяркиня, кон чялярлас ла колинэса, лэ Авраамоскэ слугаса ай лэскэ манушэнца. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Вон бахтярдэ Ревека ай пхэндэ лакэ: — Пхэн амари, тэ гинадён тирэ парапутя эзэра па эзэра. Тэ бирин парапутя тирэ тэ лэн пэскэ душманонгэ форура. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Котар Ревека ай лакэ бутяркини кидэ-пэ, бэшлэ пэ верблюдура ай традэ пала Авраамоско бутяри. Кадэ о слуга лас Ревека ай традас андо дром. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Атунчи Исаак авиластар палпалэ катар Бээр-Лахай-Рои ай траияс андо Негев. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Еквар пэ ратятэ вов гэлас пэ мал тэ гиндый ай дыкхлас, кэ авэн верблюдура. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ви Ревека дыкхлас Исаакос. Вой мэклас-пэ тэлэ па верблюдо ");
INSERT INTO rmylovari_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ай пущлас лэ Авраамоскэ бутярэс: — Кон кадо мануш андэ мал, кай жял сэмбэ амэнгэ? — Кадо муро рай, — пхэндас о слуга. Атунчи вой лас дыкхло ай щерадас-пэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Ай слуга пхэндас Исаакоскэ па са, со вов кэрдас. ");
INSERT INTO rmylovari_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Исаак ингэрдас Ревека андэ пэска даки Сарраки цэрға ай лас ла ромнякэ. Кадэ вой кэрдилас лэски ромни. Исаак камлас ла ай кадэ аракхлас чендэшыя пала мэрипэ пэска дако. ");
INSERT INTO rmylovari_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","О Авраам лас инкэ екха ромня, сави бущёлас Кетура. ");
INSERT INTO rmylovari_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Латар лэскэ аракхадилэ Зимран, Ёкшан, Медан, Мидьян, Ишбак ай Шуах. ");
INSERT INTO rmylovari_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Ёкшан сас о дад Шэваско ай Деданоско; парапутя лэ Деданоскэ сас ашуры, летушы ай леумы. ");
INSERT INTO rmylovari_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Щявэ лэ Мидьяноскэ сас Эфа, Эфер, Ханох, Авида ай Элдага. Вон са сас парапутя ла Кетуракэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Авраам ащядас са, со сас лэстэ, Исаакоскэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Кана вов сас инкэ жювиндо, вов кэрдас подарки пэскэ щявэнгэ катар наложницы ай бищядас кодолэ щявэн катар пэско щяво Исаак каринг ғайналоски риг, пэ пхув, кай ваздэл-пэ о кхам. ");
INSERT INTO rmylovari_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","О Авраам траисардас шэл тай эфтавардэш тай панжь бэрш. ");
INSERT INTO rmylovari_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Вов цырдас палуно пхаро ди андэ лэскэ барэ бэрш ай мулас чяло катар о траё, ай гэластар кай пэскэ мулэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Лэскэ щявэ Исаак ай Измаил прахосардэ лэс андэ пещера Махпела паша Мамрэ, пэ хетоски Эфроноски мал, лэ Цохарэскэ щявэски, ");
INSERT INTO rmylovari_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","сави Авраам киндас кай э хеты. Котэ Авраам сас прахомэ паша пэски ромни Сарра. ");
INSERT INTO rmylovari_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Пала мэрипэ лэ Авраамоско о Дэл бахтярдас лэскэ щявэс Исаакос, саво атунчи траияс паша Бээр-Лахай-Рои. ");
INSERT INTO rmylovari_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Кадо сы панасы па вица лэ Измаилоски, кон сас щяво Авраамоско, кас Сарраки бутяркиня, египтянка Агарь, кэрдас лэ Авраамоскэ. Сас лэс щявэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Акэ лэ Измаилоскэ щявэнгэ анава, сар вон аракхадилэ екх пала екхэстэ: Нэваёт — англуно Измаилоско щяво, Кедар, Адбеэл, Мивсам, ");
INSERT INTO rmylovari_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Мишма, Дума, Масса, ");
INSERT INTO rmylovari_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Хадад, Тема, Етур, Нафиш ай Кедма. ");
INSERT INTO rmylovari_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Кадал сас лэ Измаилоскэ щявэ, кай кэрдилэ вайды ай дынэ пэскэ анава кай дэшудуй вицы. Па лэндэ бущёнас гава ай индулымаскэ таборы. ");
INSERT INTO rmylovari_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Измаил траисардас екх шэл тай транда тай эфта бэрш. Вов цырдас палуно пхаро ди тай мулас, ай гэластар кай пэскэ мулэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Лэскэ парапутя рисписайлэ тэ траин пэ пхув, сави цырдэл-пэ катар Хавила жи кай Шур, паша египтоскэ агора, па дром каринг Ашшур. Ай вон траинас андэ холи са пэскэ пралэнца. ");
INSERT INTO rmylovari_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Кадо сы панасы па вица лэ Исаакоски, кон сас щяво лэ Авраамоско: Кай Авраам аракхадилас Исаак, ");
INSERT INTO rmylovari_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","ай Исаакоскэ сас штарвардэш бэрш, кана вов лас ромнякэ ла Ревека, лэ Бэтуэлоски щя катар э пхув Паддан-Арам ай арамоски Лаваноски пха. ");
INSERT INTO rmylovari_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Исаак рудияс лэ Яхваскэ пала пэски ромни, кэ вой наштык сас тэ кэрэл щяворэн. О Рай Яхва лас сама по лэско рудипэ, ай лэски ромни Ревека кхамнилас. ");
INSERT INTO rmylovari_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Щявора лынэ тэ друкин екх екхэс андо лако пэр, ай вой пхэндас: — Анда со мангэ кадо? Ай вой гэлас тэ пущел лэ Растар Яхвастар. ");
INSERT INTO rmylovari_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","О Рай Яхва пхэндас лакэ: — Дуй вицы сы андо пэр тиро, дуй нацыи жяна тутар ай уладёна. Екх авла май зурало кавэрэстар, ай о май пхуро прал авла лэ май цынэско бутяри. ");
INSERT INTO rmylovari_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Кана авилас врама тэ аракхадён, андо лако пэр чячес сас дуй щявэ-кэтэша. ");
INSERT INTO rmylovari_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","О англуно аракхадилас лоло, ай са лэско мас сас ущярадо балэнца, сар ураимаса анда пош. Анда кадо дынэ лэс анав Исав. ");
INSERT INTO rmylovari_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Котар сыкадилас лэско прал, саво инкэрлас-пэ вастэса пала Исавоскэ пунрэски шарка: анда кадо дынэ лэс анав Яков. Исаакоскэ сас шовардэш бэрш, кана э Ревека кэрдас лэн. ");
INSERT INTO rmylovari_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Лэ щявэ барилэ. Исав кэрдилас лащё охотнико, малянго мануш, ай Яков сас чендэшо мануш, саво траияс андэ лэ цэрғи. ");
INSERT INTO rmylovari_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Исаак, каскэ чялёлас тэ хал вадна алатон, камэлас май бут лэ Исавос, ай Ревека май бут камэлас лэ Яковос. ");
INSERT INTO rmylovari_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Еквар, кана Яков киравлас вари-соско прижымэ хабэ, Исав авилас па мал зуралэс кхинярдо. ");
INSERT INTO rmylovari_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Вов пхэндас Яковоскэ: — Дэ ма тэ чямбав, дэ кадо лоло, кадо лоло хабэ! Мэ пэрав па пунрэ кхинимастар! Акэ состар дынэ лэс инкэ анав Эдом. ");
INSERT INTO rmylovari_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Яков пхэндас пэ кадо: — Тэ гинаво-ма англунэ щявэса. ");
INSERT INTO rmylovari_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","— Дыкх, мэ сым пэ допашэстэ муло, — пхэндас Исав. — Че ғасна мангэ кэ мэ сым англуно щяво? ");
INSERT INTO rmylovari_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Яков пхэндас: — Англунымастар цолахар. Вов цолахардас, ай кадэ бикиндас пэско англуныпэ Яковоскэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Атунчи Яков дас Исавоскэ манро ай прижымэ чечевица. Кодо халас, пилас, ай котар ущилас тай гэластар. Кадэ Исав дас пэско англуныпэ анда канчестэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Пэ пхув сас бокх, — пала май англуны бокх, сави пэлас, кана сас жювиндо о Авраам, — ай Исаак гэлас кай Авимелех, край пэ филистимы, андо Герар. ");
INSERT INTO rmylovari_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","О Рай Яхва сыкадилас Исаакоскэ ай пхэндас: — На жя андо Египет. Траисар пэ коды пхув, кай Мэ пхэно тэ траис. ");
INSERT INTO rmylovari_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Кидэ-ту пэ кады пхув пэ враматэ, ай Мэ аво туса ай алдыя тут. Мэ кэро, со щинадэм тирэ дадэскэ Авраамоскэ, ай до кады пхув тукэ ай тирэ парапутёнгэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Мэ кэро тэ авэн тирэ парапутя бут, сар э черғая по чери, ай до лэнгэ са кадал пхува. Ай анда тирэ парапутя са нацыи пэ пхув авна алдымэ, ");
INSERT INTO rmylovari_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","кэ о Авраам патялас Муро муй ай инкэрлас Мурэ законура ай са, со Мэ дэм лэскэ аври ай со щинадэм. ");
INSERT INTO rmylovari_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Атунчи Исаак лас тэ траий андо Герар. ");
INSERT INTO rmylovari_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Кана лэ мануш андо кодо тхан пущлэ лэс па лэски ромни, вов пхэндас: «Кады мури пхэн», кэ дарлас тэ пхэнэл: «Кады мури ромни». Вов гиндыяс: «Тханэнгэ мануш мударна ман анда Ревека, кэ вой шукар». ");
INSERT INTO rmylovari_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Еквар, кана Исаак аба бут траисардас котэ, Авимелех, край филистимэнго, дыкхлас тэлэ па филястра ай лас сама, сар Исаак малый пэска ромня Ревека. ");
INSERT INTO rmylovari_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Атунчи Авимелех акхардас лэс пэстэ ай пхэндас: — Акэ, по чячипэ вой сы тири ромни! Состар ту пхэндан: «Вой мури пхэн»? Исаак пхэндас лэскэ пэ кадо: — Кэ мэ гиндыяс, кэ анда латэ шай хасаро муро траё. ");
INSERT INTO rmylovari_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Атунчи Авимелех пхэндас: — Со ту кэрдан амэнца? Екх анда мурш шай пашлило тирэ ромняса, ай атунчи анда тутэ пэло пэ амэндэ дош. ");
INSERT INTO rmylovari_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Ай Авимелех дас аври саворэнгэ: — Сако, кон азбала кадалэ манушэс вай лэска ромня, кодо авла мудардо. ");
INSERT INTO rmylovari_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Исаак щютас сэмно андэ пхув андо кодо тхэм ай кодо бэрш кидас шэлвар май бут, кэ о Рай Яхва алдысардас лэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Вов барвайлас, ай миштыпэ лэско инкэ баролас, жипон вов кэрдилас зуралэс барвало. ");
INSERT INTO rmylovari_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Лэстэ сас касавэ барэ бакрэнгэ, буснянгэ ай гурувнянгэ кырдура ай кати бутяра, кэ филистимы инкэрнас холи пэ лэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Вон прахосардэ са лэ хаинга, савэ сас ғунадэ Авраамоскэ бутярэнца, кана инкэ лэско дад Авраам сас жювиндо. ");
INSERT INTO rmylovari_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Атунчи Авимелех пхэндас Исаакоскэ: — Жятар амэндар; ту кэрдилан опра зурало амэндар. ");
INSERT INTO rmylovari_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Ай Исаак гэластар котар, щютас цэрғи пэ пхув Герар ай лас тэ траий котэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Вов ужардас лэ хаинга, савэ сас ғунадэ инкэ лэскэ дадэса Авраамоса ай савэ сас пала лэско мэрипэ прахомэ филистимэнца, ай дас лэн касавэ анава, савэ дас лэн майинты ви лэско дад. ");
INSERT INTO rmylovari_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Еквар лэ бутяра Исаакоскэ ғунавнас андэ Герарско пхув ай путэрдэ хаинг пировоскэ паеса. ");
INSERT INTO rmylovari_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Алом лэ герарицка чябаша ваздэ холи Исаакоскэ чябашэнца, ворбаса: «Кадо амаро паи!» Атунчи вов дас хаингакэ анав Эсек, кэ анда латэ сас чингар. ");
INSERT INTO rmylovari_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Пала кодо лэскэ мануш ғунадэ кавэр хаинг, ай ви анда латэ кэрдилас холи; атунчи вов дас ла анав Ситна. ");
INSERT INTO rmylovari_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Вов гэластар котар ай ғунадас инкэ екх хаинг, анда сави аба нас чингар. Вов пхэндас: «Аканак Рай Яхва дас амэн тхан, ай амэ траисараса андо миштыпэ пэ кады пхув», ай дас ла анав Реховот. ");
INSERT INTO rmylovari_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Котар Исаак гэлас андэ Бээр-Шэва. ");
INSERT INTO rmylovari_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Андэ коды рати лэскэ сыкадилас о Рай Яхва ай пхэндас: — Мэ сым Дэл тирэ дадэско Авраамоско. На дара, кэ Мэ сым туса. Мэ алдыя тут ай бараро тирэ парапутён анда анав мурэ слугаско Авраамоско. ");
INSERT INTO rmylovari_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Исаак кэрадас котэ жэртвенник ай акхардас о анав лэ Раско Яхваско. Вов щютас котэ пэски цэрға, ай лэскэ бутяра лынэ тэ ғунавэн хаинг. ");
INSERT INTO rmylovari_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Андэ кады врама катар Герар лэстэ авилас Авимелех куса Ахуззат, пэскэ ажутороса, ай Пихол, саво сас паранчёдашы пэ лэскэ кэтаны. ");
INSERT INTO rmylovari_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Исаак пущлас лэндар: — Состар тумэ авилан, чяк тумэ санас холярника пэ мандэ ай нашадан ман? ");
INSERT INTO rmylovari_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Вон пхэндэ палпалэ: — Амэ мишто дыкхлам, кэ туса о Рай Яхва; атунчи амэ гиндысардам: «Трубуй тэ пхандас туса ворба цолахаса». Тэ пхангламас пайташыпэ машкар амэндэ, ");
INSERT INTO rmylovari_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","кэ ту чи кэрэса амэнгэ чи соско баё, сар ви амэ чи азбадам тут, ай инкэрдилам каринг тутэ мишто, ви мэклам тут тэ жястар пачяса. Ай аканак ту сан алдымэ катар о Рай Яхва. ");
INSERT INTO rmylovari_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Исаак кэрдас лэнгэ мисаля, ай вон халэ тай пилэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","По кавэр дес ёкор дэтэғара лэ мануш дынэ ворба цолахаса екх екхэскэ. Атунчи Исаак мэклас лэн, ай вон гэлэтар лэстар пачяса. ");
INSERT INTO rmylovari_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Андо кодо дес авилэ Исаакоскэ бутяра ай пхэндэ лэскэ па хаинг, саво вон ғунадэ. Вон пхэндэ: — Амэ аракхлам паи! ");
INSERT INTO rmylovari_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Вов дас лэс анав Шыва, ай жи кай адесутно дес о анав кадалэ фороско сы Бээр-Шэва. ");
INSERT INTO rmylovari_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Кана Исавоскэ сас штарвардэш бэрш, вов лас ромнякэ Ехудита, хетоска Бээриеска щя, ай Басемата, хетоска Элоноска щя. ");
INSERT INTO rmylovari_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Анда лэндэ каринг о Исаак ай э Ревека сас бут налащипэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Кана Исаак пхурилас ай лэскэ якха кэрдилэ касавэ чёрэ, кэ вов корайлас, вов акхардас Исавос, пэскэ май пхурэ щявэс: — Муро щяво! — Мэ сым катэ, — пхэндас палпалэ о Исав. ");
INSERT INTO rmylovari_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Исаак пхэндас: — Мэ аба сым пхуро, ай чи жянав о дес мурэ мэримаско. ");
INSERT INTO rmylovari_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Атунчи лэ тирэ колчан ай луко ай жя андэ мал, астар мангэ вари-соско вадно алато. ");
INSERT INTO rmylovari_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Гэтосар изывно хабэ ай ан мангэ тэ хав, мэ тэ алдый тут англа муро мэрипэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ай Ревека шундас, сар Исаак ворбияс пэскэ щявэса Исавоса. Кана Исав гэлас андэ мал тэ астарэл вадно алатос, ");
INSERT INTO rmylovari_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Ревека пхэндас пэскэ щявэскэ Яковоскэ: — Мэ чёрал шундэм, сар тиро дад пхэндас тирэ пралэскэ Исавоскэ: ");
INSERT INTO rmylovari_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","«Ан мангэ вари-соско вадно алато ай гэтосар мангэ изывно хабэ, тэ дав тукэ муро алдошаго англа о Рай Яхва, англа кодо, сар тэ мэрав». ");
INSERT INTO rmylovari_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Аканак, муро щяво, шун ман мишто ай кэр, сар мэ пхэнав. ");
INSERT INTO rmylovari_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Жя андо кырдо, алосар мангэ ай ан дуе тэрнэ буснян тэ киравав изывно хабэ тирэ дадэскэ, касаво, сар вов камэл. ");
INSERT INTO rmylovari_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Котар ингэр лэскэ тэ хал, вов тэ дэл тукэ алдошаго англа кодо, сар тэ мэрэл. ");
INSERT INTO rmylovari_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Яков пхэндас Ревекакэ, пэска дакэ: — Алом муро прал Исав са андэ бал, ай мандэ ужы морчи. ");
INSERT INTO rmylovari_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ай тэ пипия ман муро дад? Мэ кэрдюво хохавно англа лэс, ай вов дэла ман армая, ай на алдошаго. ");
INSERT INTO rmylovari_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Лэски дэй пхэндас: — Муро щяво, мэк пэрэн армая пэ мандэ, ай ту кэр, сар мэ пхэнав: жя ай ан буснёран. ");
INSERT INTO rmylovari_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Атунчи вов гэлас, лас буснёран ай андас пэска дакэ, ай вой кирадас изывно хабэ, касаво, сар камэлас лэско дад. ");
INSERT INTO rmylovari_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Пала кадо Ревека лас май лаще гада пэскэ май пхурэ щявэскэ Исавоскэ, савэ сас андо кхэр, ай урадас по май тэрно щяво Яков. ");
INSERT INTO rmylovari_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Ай лэскэ васт ай котор кор вой щерадас буснянэ морчянца. ");
INSERT INTO rmylovari_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Котар вой дас пэскэ щявэскэ Яковоскэ изывно хабэ ай манро, саво вой пэклас. ");
INSERT INTO rmylovari_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Яков авилас кай о дад ай пхэндас: — Муро дад! — Катэ сым, — пхэндас кодо палпалэ. — Саво сан анда мурэ щявэ? ");
INSERT INTO rmylovari_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Яков пхэндас лэ дадэскэ: — Мэ сым Исав, тиро англуно. Мэ кэрдэм, сар ту пхэндан. Мангав, ваздэ-ту, бэш ай ха муро хабэ, тэ бирис тэ алдыс ман. ");
INSERT INTO rmylovari_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Исаак пущлас лэ щявэс: — Сар ту аракхлан алатон кадэ сыго, муро щяво? — О Рай Яхва, тиро Дэл, бищядас мангэ бахт, — пхэндас вов палпалэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Пала кадо Исаак пхэндас Яковоскэ: — Пашув май пашэ тэ пипий тут, муро щяво, тэ жянав, чячес сан муро щяво Исав вай на. ");
INSERT INTO rmylovari_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Яков пашылас кай пэско дад Исаак, саво пиписардас лэс ай пхэндас: — О гласо сы Яковоско, ай лэ васт — Исавоскэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Вов чи пинжярдас лэс анда кодо, кэ лэскэ васт сас баласлэ, сар кай о Исав; ай вов алдысардас лэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","— Чячес ту сан муро щяво Исав? — пущлас Исаак, ай Яков пхэндас палпалэ: — Ова, мэ сым. ");
INSERT INTO rmylovari_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Атунчи Исаак пхэндас: — Муро щяво, ан май пашэ тиро хабэ анда вадна алатура, атунчи мэ бирий тэ дав тукэ муро алдошаго. Яков дас лэскэ хабэ, ай вов халас. Яков андас мол, ай вов пилас. ");
INSERT INTO rmylovari_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Пала кадо Исаак пхэндас лэскэ: — Пашув, муро щяво, ай чюмидэ ман. ");
INSERT INTO rmylovari_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Ай вов пашылас ай чюмидас лэс. Кана Исаак атярдас лэскэ гадэнги сага, вов алдысардас лэс ай пхэндас: — О, мурэ щявэски сага, — сар э сага андэ мал, сави алдысардас о Рай Яхва. ");
INSERT INTO rmylovari_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","О Дэл мэк дэл тут катар черэски брума ай катар барвалипэ, саво дэл э пхув: пхэрдо сэмно ай тэрны мол. ");
INSERT INTO rmylovari_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Тэ дэн тут патив лэ вицы, ай бандярэн англа тутэ шэрэ лэ нацыи. Ав рай пэ тирэ прал, ай тирэ дакэ щявэ тэ бандярэн лэ шэрэ англа тутэ. Тэ авэл дыно армая кодо, кон дэл армая тут, ай кон алдый тут, тэ авэл алдымэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Пала кодо, сар Исаак дас пэско алдыпэ, ай фэри Яков гэластар катар о дад, лэско прал Исав авилас па астарипэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ви вов гэтосардас изывно хабэ ай андас лэс дадэскэ. Атунчи вов пхэндас лэскэ: — Дадэ, ваздэ-ту, бэш ай ха муро хабэ, тэ бирис тэ алдыс ман. ");
INSERT INTO rmylovari_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Лэско дад Исаак пущлас: — Кон сан? — Мэ сым тиро щяво, — пхэндас кодо, — тиро англуно щяво, Исав. ");
INSERT INTO rmylovari_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Исаак са издраяс ай пхэндас: — Атунчи кон сас кодо кавэр, кон астардас вадно алатос ай андас лэс мангэ? Мэ халэм лэс англа кодо, сар ту авилан, ай алдысардэм лэ кавэрэс. Аканак вов авла алдымэ! ");
INSERT INTO rmylovari_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Кана Исав шундас кадал ворби, вов зуралэс ай кэркэс цыписардас ай пхэндас лэ дадэскэ: — Алдын ви ман, ви ман, дадэ! ");
INSERT INTO rmylovari_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Алом кодо пхэндас: — Тиро прал авилас ай хохаимаса лас алдошаго мэштык ту. ");
INSERT INTO rmylovari_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Исав пхэндас: — Вов по чячипэ бущёл Яков! Вов дувар кхэладас ман: лас муро англунипэ, ай аканак ви алдошаго! — Ай пущлас: — Чи ащилас тутэ алдошаго ви мангэ? ");
INSERT INTO rmylovari_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Исаак пхэндас Исавоскэ: — Мэ кэрдэм лэс рай пэ тутэ, кэ ви са лэско нямо кэрла бути пэ лэс, ай зурардэм муро алдошаго манрэса ай тэрна моляса. Со шай мэ аканак кэрав тукэ, муро щяво? ");
INSERT INTO rmylovari_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Исав пхэндас лэ дадэскэ: — Тутэ со, фэри екх алдошаго, дадэ? Алдын ви ман, муро дад! Ай Исав зуралэс рутас. ");
INSERT INTO rmylovari_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Лэско дад Исаак пхэндас пэ кадо: — Авла траипэ тиро дур катар барвалипэ, саво дэл э пхув, дур катар черэски брума. ");
INSERT INTO rmylovari_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ту лэса тэ траис ханрэса ай авэса тирэ пралэско слуга. Алом кана ваздэса-пэ, ту щюдэса кадо ғамо па ти кор. ");
INSERT INTO rmylovari_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Исав инкэрдас холи по Яков анда алдыпэ, саво дас лэскэ дад. Вов пхэндас коркоро пэскэ: «Роимаскэ деса па муро дад сы пашэ — атунчи мударо мурэ пралэс Яковос». ");
INSERT INTO rmylovari_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Кана Ревекакэ пурисардэ, со пхэндас лако май пхуро щяво Исав, вой бищядас пала май цыно щяво, Яков, ай пхэндас лэскэ: — Тиро прал Исав щютас пэскэ андо гиндо тэ мударэл тут. ");
INSERT INTO rmylovari_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Аканак, муро щяво, кэр, сар мэ пхэнав: наш сыго кай муро прал Лаван андо Харан. ");
INSERT INTO rmylovari_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Траисар лэстэ вари-соски врама, жипон начёла тирэ пралэски холи. ");
INSERT INTO rmylovari_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Кана начёла э холи кай тё прал, ай бистэрдёла, со ту лэскэ кэрдан, мэ бищяво тэ пхэнэн тукэ, кэ авилас врама тэ болдэс-ту палпалэ. Состар тэ хасарав тумэн солдон андо екх дес? ");
INSERT INTO rmylovari_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Котар Ревека пхэндас Исаакоскэ: — Мэ чи сым лошалы кадалэ траёскэ анда хетэнгэ щея. Тэ лэла ви Яков катарутна жювля ромнякэ, сар кадал хетанкини, атунчи состэ мангэ тэ траий? ");
INSERT INTO rmylovari_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Атунчи Исаак акхардас Яковос, алдысардас лэс ай дас лэскэ аври: — На лэ ромня анда ханааны. ");
INSERT INTO rmylovari_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Сыго традэтар андо Паддан-Арам, андо тира дако пралэско Бэтуэлоско кхэр. Лэ котэ пэскэ ромня анда лэ щея Лаваноскэ, кай тира дако прал. ");
INSERT INTO rmylovari_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Тэ алдый тут Са-Биримаско Дэл ай тэ кэрэл тэ авэн тут бут щявора, ай тэ жял тутар бут нацыи. ");
INSERT INTO rmylovari_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Тэ дэл Вов тукэ ай тирэ парапутёнгэ алдошаго, саво лас о Авраам. Тэ авэс ту газда пэ пхув, пэ сави ту траис аканак, пэ пхув, сави о Дэл дас Авраамоскэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Пала кадо Исаак мэклас Яковос андо дром, ай кодо гэлас андо Паддан-Арам кай о Лаван, лэ арамоско Бэтуэлоско щяво. Ай Лаван сас прал ла Ревекако, кай сас дэй Яковоски ай Исавоски. ");
INSERT INTO rmylovari_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Исав жянглас, кэ Исаак алдысардас Яковос ай бищядас лэс андо Паддан-Арам тэ лэл котар ромня, кэ алдомаса вов пхэндас лэскэ: «На лэ ромня анда ханааны». ");
INSERT INTO rmylovari_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Ай вов жянглас, кэ Яков патяяс лэ дадэско ай дако муй ай гэлас андо Паддан-Арам. ");
INSERT INTO rmylovari_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Атунчи Исав атярдас, сар руты сас лэскэ дадэскэ Исаакоскэ лэ ханаанкини. ");
INSERT INTO rmylovari_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Вов гэлас кай Измаил ай лас инкэ екх ромня, Махалата, кай сас э пхэн Нэваётоски ай Авраамоско щявэски Измаилоски щей. ");
INSERT INTO rmylovari_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Яков ащядас Бээр-Шэва ай гэлас каринг Харан. ");
INSERT INTO rmylovari_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Кана эрэслас жи вари-соско тхан, ащядилас пэ рат, кэ о кхам аба бэшлас. Вов лас екх бар, щютас тэла шэро ай пашлилас тэ совэл. ");
INSERT INTO rmylovari_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Вов дыкхлас суно: э трапта, сави тордёлас пэ пхув, ай опруно агор рэсэлас жи кай о чери, ай ангелы Дэвлэскэ ваздэнас-пэ тай мэкэнас-пэ па латэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Опрэ по чери тордёлас о Рай Яхва ай пхэнлас: — Мэ сым Яхва, Дэл тирэ дадэско Авраамоско ай Дэл Исаакоско. Э пхув, пэ сави ту аканак пашлёс, Мэ до тукэ ай тирэ парапутёнгэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Тирэ парапутя авна касавэ бут, сар прахо ла пхувако, ай тумэ буғлярна-пэ пэ са штар лумакэ рига. Са нацыи пэ пхув авна алдысардэ анда тутэ ай тирэ парапутёндэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Мэ сым туса ай ло тэ лышый пала тутэ, кай тэ на жяса, ай болдо тут палпалэ пэ кады пхув. Мэ чи ащяво тут, жипон кэро са, со щинадэм тукэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Кана о Яков убрэдысайлас, вов гиндысардас: — Чячес, о Рай Яхва сы пэ кадо тхан, ай мэ чяк чи жянос. ");
INSERT INTO rmylovari_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Лэскэ сас дар, ай вов пхэндас: — Сар даравэл кадо тхан! Кадо сы чячюно Дэвлэско кхэр, э черэски капува. ");
INSERT INTO rmylovari_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","По кавэр дес ёкор дэтэғара Яков ущилас, лас о бар, саво сас тэла лэско шэро, ваздас лэс тэ тордёл ай щёрдас пэ лэс улэй. ");
INSERT INTO rmylovari_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Кадалэ тханэскэ вов дас анав «Бэт-Эль», ай англунэс кадо форо бущёлас «Луз». ");
INSERT INTO rmylovari_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Котар Яков дас цолах ворбаса: — Тэ авла о Дэл манца ай лэла тэ лышый пала мандэ андо кадо дром, ай тэ дэла ман манро тэ хав тай ураипэ пэ пхикэ, ");
INSERT INTO rmylovari_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ай тэ болдо-ма палпалэ бахтяса андо кхэр мурэ дадэско, атунчи о Рай Яхва авла муро Дэл, ");
INSERT INTO rmylovari_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","ай кадо бар, кай мэ щютэм сар э вурма, авла Дэвлэско кхэр. Ай катар са, со Ту дэса мангэ, мэ до Тукэ дэшто котор. ");
INSERT INTO rmylovari_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Яков гэлас май дур ай авилас пэ пхув пэ ғайналоски риг. ");
INSERT INTO rmylovari_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Котэ вов дыкхлас хаинг андэ мал ай паша латэ трин кырдура бакрэ, кэ анда кады хаинг пэнас алатура. Э хаинг сас щерады барэ барэса. ");
INSERT INTO rmylovari_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Кана са э кырдура кидэнас-пэ, чябаша щювнас о бар пэ риг ай паярнас бакрэн. Котар вон щювнас о бар по тхан. ");
INSERT INTO rmylovari_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Яков пущлас катар э чябаша: — Пралалэ, катар сан? — Сам анда Харан, — пхэндэ вон палпалэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Вов пущлас лэндар: — Жянэн тумэ лэ Лаванос, о Нахороско внукос? — Ова, жянас, — пхэндэ кодал. ");
INSERT INTO rmylovari_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Атунчи Яков инкэ пущлас: — Сар вов, мишто? — Ова, са мишто, — пхэндэ вон. — Эта, лэски щей Рахиль жял лэ бакрэнца. ");
INSERT INTO rmylovari_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","— О кхам инкэ учесый, — пхэндас Яков. — Инкэ най врама тэ кидэн лэ бакрэнгэ кырдура. Паярэн лэ бакрэн ай традавэн лэн палпалэ пэ мал. ");
INSERT INTO rmylovari_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","— Амэ наштык, — пхэндэ вон палпалэ, — жипон чи кидэна-пэ са кырдура ай чи щёна пэ риг о бар хаингако. Атунчи амэ даса паи лэ бакрэнгэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Вов инкэ ворбияс лэнца, кана пашылас Рахиль куса дадэскэ бакрэ (вой сас чябашкиня). ");
INSERT INTO rmylovari_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Кана Яков дыкхлас ла Рахиля, лэскэ наноски Лаваноски щя, вов пашылас, щютас пэ риг о бар ай дас тэ пэн Лаваноскэ бакрэнгэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Котар Яков чюмидас Рахиля ай зуралэс рутас. ");
INSERT INTO rmylovari_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Вов пхэндас Рахилякэ, кэ вов сы лако дадэско нямо ай щяво ла Ревекако. Вой нашлас ай панаскодысардас па кадо пэскэ дадэскэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Фэри со шундас о Лаван, кэ авилас лэска пхако щяво Яков, вов нашлас каринг лэстэ, лас лэс андэ ангаля, чюмидас ай андас андо пэско кхэр. Котэ Яков панаскодысардас лэскэ са. ");
INSERT INTO rmylovari_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Котар Лаван пхэндас: — Ту сан муро мас ай рат! Кана Яков траисардас лэстэ екх щён, ");
INSERT INTO rmylovari_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Лаван пхэндас лэскэ: — Ту наштык тэ кэрэс пэ мандэ бути ива фэри анда кадо, кэ сан мангэ нямо. Пхэн мангэ, соса тэ потинав тукэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Кай о Лаван сас дуй щея: май пхури бущёлас Лия, ай май цыны — Рахиль. ");
INSERT INTO rmylovari_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Кай э Лия сас шукар якха, ай э Рахиль сас статошо ай шукарэ муеса. ");
INSERT INTO rmylovari_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Яков камлас Рахиля ай пхэндас Лаваноскэ: — Мэ кэро бути пэ тутэ эфта бэрш анда тири май цыны щей Рахиль. ");
INSERT INTO rmylovari_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Лаван пхэндас: — Май федэр до ла тукэ, сар вари-каскэ кавэрэскэ. Ащ мандэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Атунчи Яков кэрлас бути эфта бэрш тэ лэл Рахиля, ай кады врама мэзысайлас лэскэ, сар набут дес, кэ вов камлас ла. ");
INSERT INTO rmylovari_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Котар Яков пхэндас Лаваноскэ: — Дэ мангэ мура ромня. Мура бутяки врама авилас жи кай о агор, ай мэ камав тэ лав ла ромнякэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Атунчи Лаван акхардас саворэн, кон траияс пашэ, ай кэрдас пативалы мисаля. ");
INSERT INTO rmylovari_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Алом, кана кэрдилас пэ ратятэ, вов лас пэска щя Лия ай дас ла Яковоскэ, ай Яков пашлилас ласа. ");
INSERT INTO rmylovari_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(Лаван инкэ дас ла щякэ э служанка Зэлфа). ");
INSERT INTO rmylovari_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Кана десайлас, дычилас, со кады Лия! Яков пхэндас Лаваноскэ: — Со ту манца кэрдан? Мэ чяк кэрос бути анда Рахиль. Состар хохадан ман? ");
INSERT INTO rmylovari_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","О Лаван пхэндас пэ кадо: — Амэндэ най касаво цокашы тэ дас ла май цына щя англа май пхури щей. ");
INSERT INTO rmylovari_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Кэр аври кадо абавэско курко кадала щяса; ай котар даса тукэ ви май цына, пала кавэр эфта бэрш бути. ");
INSERT INTO rmylovari_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Ай Яков кадэ ви кэрдас, траисардас о абавэско курко ла Лияса. Ай котар Лаван дас лэскэ пэска щя Рахиля. ");
INSERT INTO rmylovari_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Лаван дас Рахилякэ служанка Валла. ");
INSERT INTO rmylovari_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Яков лас тэ траий ви Рахиляса ай камлас ла май бут, сар Лия. Вов кэрлас бути по Лаван инкэ эфта бэрш. ");
INSERT INTO rmylovari_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Кана о Рай Яхва дыкхлас, кэ э Лия най камлы, Вов кэрдас ла кхамна, ай э Рахиль ащелас бищяворэнги. ");
INSERT INTO rmylovari_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Лия пэлас кхамны ай кэрдас щявэс. Вой пхэндас: «О Рай Яхва дыкхлас муро кино. Аканак муро ром лэла тэ камэл ман», — ай дас лэскэ анав Рувим. ");
INSERT INTO rmylovari_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Вой палэ кхамнилас ай, кана кэрдас щявэс, пхэндас: «О Рай Яхва шундас, кэ мэ чи сым камлы, ай Вов дас ман инкэ ви кадалэ щявэс». Ай вой дас лэс анав Симеон. ");
INSERT INTO rmylovari_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Палэ вой кхамнилас ай, кана кэрдас щявэс, пхэндас: «Аканак муро ром авла май пашардо мандэ, кэ дэм лэс тринэ щявэн». Ай дынэ лэс анав Левий. ");
INSERT INTO rmylovari_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Атунчи вой палэ кхамнилас ай, кана кэрдас щявэс, пхэндас: «Аканак ғирэшоя о Рас Яхвас». Анда кадо вой дас лэс анав Иуда. Котар латэ чи аракхадёнас щявора. ");
INSERT INTO rmylovari_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Кана Рахиль дыкхлас, кэ вой чи кэрэл Яковоскэ щяворэн, вой инкэрдас холи, кэ най ла щявора, сар кай лаки пхэн Лия. Вой пхэндас Яковоскэ: — Дэ мангэ щяворэн, кэ мэро! ");
INSERT INTO rmylovari_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Яков холяйлас пэ латэ ай пхэндас: — Чяк чи сым о Дэл, Саво чи дэл тукэ щяворэн! ");
INSERT INTO rmylovari_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Атунчи вой пхэндас: — Акэ Валла, мури бутяркиня. Пашлюв ласа тэ кэрэл щяворэн мангэ пэ чянга, ай кадэ па латэ ви мандэ авла челэдо. ");
INSERT INTO rmylovari_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Кадэ вой дас лэскэ бутяркиня Валла сар ромня. Яков пашлилас ласа, ");
INSERT INTO rmylovari_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","вой пэлас кхамны ай кэрдас лэскэ щявэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Атунчи Рахиль пхэндас: «О Дэл фирисардас мури патив. Вов шундас муро рудипэ ай дас ман щявэс». Анда кадо вой дас лэс анав Дан. ");
INSERT INTO rmylovari_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Рахиляки бутяркиня Валла палэ пэлас кхамны ай кэрдас Яковоскэ дуйтонэ щявэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Рахиль пхэндас: «Барэ маримаса мэ марос-ма мура пхаса ай нирисардэм». Ай вой дас лэс анав Неффалим. ");
INSERT INTO rmylovari_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Кана э Лия дыкхлас, кэ латэ аба най щявора, вой лас пэска бутяркиня Зэлфа ай дас Яковоскэ сар ромня. ");
INSERT INTO rmylovari_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Лияки бутяркиня Зэлфа кэрдас Яковоскэ щявэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Атунчи Лия пхэндас: «Сави бахт!» Ай дас лэс анав Гад. ");
INSERT INTO rmylovari_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Лияки бутяркиня Зэлфа кэрдас Яковоскэ ви дуйтонэ щявэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Атунчи Лия пхэндас: «Сави мэ сым бахталы! Лэ жювля пхэнна пэ мандэ \"бахталы\"!» Ай дас лэс анав Ашэр. ");
INSERT INTO rmylovari_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Кана лэ мануш кидэнас див, Рувим гэлас пэ мал ай аракхлас мандрагоры, кай вов андас пэска дакэ Лиякэ. Рахиль пхэндас Лиякэ: — Мангав тут, дэ ман эк-цэра анда тирэ щявэскэ мандрагоры. ");
INSERT INTO rmylovari_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Алом коды пхэндас: — Тукэ най доста, кэ ту лан мандар ромэс? Камэс аканак тэ лэс ви мурэ щявэскэ мандрагоры? — Миштой, — пхэндас э Рахиль. — Вов шай пашлёл туса андэ кады рати, ай ту дэса мангэ тирэ щявэскэ мандрагоры. ");
INSERT INTO rmylovari_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Кана пэ ратятэ Яков авилас па маля, Лия дас аври каринг лэстэ ай пхэндас: — Ту трубуй тэ пашлёс манца. Мэ потиндэм анда тутэ мурэ щявэскэ мандрагорэнца. Ай андэ коды рати вов пашлилас ласа. ");
INSERT INTO rmylovari_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","О Дэл шундас Лия, вой кхамнилас ай кэрдас Яковоскэ панжьтонэ щявэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Лия пхэндас: «О Дэл барвардас ман анда кодо, кэ дэм мурэ ромэскэ мура бутяркиня». Ай вой дас лэс анав Иссахар. ");
INSERT INTO rmylovari_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Лия палэ кхамнилас ай кэрдас Яковоскэ шовтонэ щявэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Вой пхэндас: «О Дэл дас ман куч подарко. Аканак муро ром дэла ман патив, кэ кэрдэм лэскэ шовэ щявэн». Ай вой дас лэс анав Завулон. ");
INSERT INTO rmylovari_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Па вари-сави врама вой кэрдас щя ай дас ла анав Дина. ");
INSERT INTO rmylovari_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Атунчи о Дэл дас-пэ гиндо па Рахиль. Вов шундас ла ай путэрдас лако пэр. ");
INSERT INTO rmylovari_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Вой кхамнилас, ай кэрдас щявэс, ай пхэндас: «О Дэл лас па мандэ муро лажяво». ");
INSERT INTO rmylovari_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Вой инкэ пхэндас: «Тэ дэл мангэ о Рай Яхва инкэ екхэ щявэс», ай дас лэс анав Ёсиф. ");
INSERT INTO rmylovari_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Пала кодо, сар кай э Рахиль аракхадилас Ёсиф, Яков пхэндас Лаваноскэ: — Мэк ман тэ жявтар пэ пхув, кай аракхадилэм. ");
INSERT INTO rmylovari_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Дэ ман мурэ ромнян ай щяворэн, анда савэ мэ кэрос бути тукэ, ай мэ традав андо дром. Ту жянэс, кати бут мэ кэрос бути пэ тутэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Алом о Лаван пхэндас лэскэ: — Тэ аракхав лащипэ андэ тирэ якха, мангав тут: ащ. Мэ жянглэм па драбарипэ, кэ о Рай Яхва алдый ман анда тутэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Пхэн тири тимин, ай мэ потино ла. ");
INSERT INTO rmylovari_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","О Яков пхэндас лэскэ пэ кадо: — Ту жянэс, кати бут мэ кэрос бути пэ тутэ ай пэ катестэ барилэ тирэ кырдура анда мандэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Кана мэ арэслэм, лэн нас бут, алом аканак вон кэрдилэ пэ бутэстэ май бут. О Рай Яхва бахтярлас тут андо са, со мэ кэрос. Ай кана мэ чяк бирия тэ кидав вари-со мурэ челэдоскэ? ");
INSERT INTO rmylovari_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Лаван пущлас: — Со тэ дав тут? — На дэ ма канчи, — пхэндас пэ кадо Яков. — Алом кэр мангэ фэри екх, ай мэ ло май дур тэ лышый ай тэ фирий тирэ кырдура: ");
INSERT INTO rmylovari_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","мэк ман тэ накхав адес па са э кырдура ай тэ улавав ригатэ саворэ плямаша бакрэн, мэлахнэ бакрорэн ай буснёрэн, ай таблаша буснян. Вон ви авна муро потин. ");
INSERT INTO rmylovari_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Май палал дычёла, кэ мэ сым чячё мануш, кана ту камэса тэ жянэс аври, со ту потинэсас мангэ па бути. Тэ аракхадёла мандэ наплямаша вай натаблаша бусни вай намэлахно бакроро, вон гинавна-пэ чёрданэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","— Ворбисайлам, — пхэндас Лаван. — Мэк авэл кадэ, сар ту пхэндан. ");
INSERT INTO rmylovari_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Ай андо кодо дес вов щютас ригатэ саворэ плямаша вай таблаша бузнэн ай буснян, ай саворэ мэлахнэ бакрорэн ай дас тэ лышын лэн лэскэ щявэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Вов кэрдас тэ авэл машкар лэстэ ай о Яков трин дес дром, ай Яков, сар майинты, лышыяс лэ кавэр Лаваноскэ кырдура. ");
INSERT INTO rmylovari_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Алом о Яков щиндас зэлэна кранжи па плопура, пэндэха ай чинара ай щиндас аври пэ лэ корца, тэ ащен парнэ панты пэ кранжи. ");
INSERT INTO rmylovari_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Котар вов щютас кодал кранжи андэ алатонгэ паескэ балая, тэ авэн вон ворта англа алатура, кана вон авнас тэ пэн. Кана сас тато, ай алатура авнас тэ пэн ай тэ кэрэн щяворэн, ");
INSERT INTO rmylovari_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","вон кэрнас кадо англа кранжи. Ай лэндэ аракхадёнас щявора плямаша вай таблаша. ");
INSERT INTO rmylovari_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Инкэ Яков щёлас лэн таблаша ай мэлахнэ алатура, савэ сас Лаваноскэ. Кадэ лэстэ кэрдилэ пэскэ кырдура, ай вов инкрэлас лэн ригатэ катар алатура Лаваноскэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Кана авнас тэ пэн зуралэ бусня ай бакря, Яков щёлас англа лэндэ кранжи андэ балая, тэ кэрэн щяворэн англа кранжи, ");
INSERT INTO rmylovari_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","ай кана сас назуралэ алатура, вов чи щёлас лэн котэ. Кадэ бизоракэ алатура ащнас кай Лаван, ай зуралэ — кай Яковос. ");
INSERT INTO rmylovari_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Кадэ Яков кэрдилас зуралэс барвало, лэстэ сас аканак барэ кырдура бакрэн ай буснян, бутяркини ай бутяра, верблюдура ай самары. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Яков шундас, сар щявэ лэ Лаваноскэ пхэннас: «Яков лас са, со сас кай амаро дад, кидас пэско барвалипэ катар амаро дад». ");
INSERT INTO rmylovari_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ай Яков лас сама, кэ Лаван аба нас касаво каринг лэстэ, сар майинты. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Атунчи О Рай Яхва пхэндас лэ Яковоскэ: — Болдэ-ту палпалэ пэ тири дадэски пхув, кай тиро нямо, ай Мэ аво туса. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","О Яков бищядас тэ пхэнэн Рахилякэ ай Лиякэ тэ авэн пэ мал, кай сас лэскэ алатура. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Вов пхэндас лэнгэ: — Мэ дыкхав, кэ тумаро дад аба най касаво каринг мандэ, сар майинты. Алом мурэ дадэско Дэл сы манца. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Тумэ жянэн, кэ мэ кэрос бути пэ тумаро дад анда са мури зор, ");
INSERT INTO rmylovari_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","ай тумаро дад хохавлас ман, дэшвар парувлас муро потин. Алом о Дэл чи дас лэскэ тэ шэртый ман. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Кана вов пхэнлас: «Тиро потин авла таблаша алатура», са цынэ алатура аракхадёнас таблаша, ай кана пхэнлас: «Тиро потин авла плямаша», са лэ алатура кэрнас цынэн плямаша. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Кадэ о Дэл лас катар тумаро дад лэ алатон ай дас лэн мангэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Еквар, андэ коды врама, кана алатура кэрнас щяворэн, мэ дыкхлэм суно, мэ дыкхлэм, кэ лэ бузнэ, савэ астардёнас кай э бусня, сас таблаша вай плямаша. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","О Ангело Дэвлэско пхэндас мангэ андо суно: «Яков». Мэ пхэндэм лэскэ: «Катэ сым». ");
INSERT INTO rmylovari_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Вов пхэндас: «Лэ сама, ай дыкхэса: са э бузнэ, савэ астардён кай э бусня, сы таблаша вай плямаша. Мэ дыкхлэм са, со Лаван кэрэл туса. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Мэ сым о Дэл андо Бэт-Эль, кай ту щёрдан улэй по бар ай цолахардан Мангэ. Аканак ащяв кады пхув ай болдэ-ту палпалэ пэ пхув, кай аракхадилан». ");
INSERT INTO rmylovari_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Рахиль ай Лия пхэндэ: — Сы инкэ амэндэ амари партя кай амаро дадэско миштыпэ? ");
INSERT INTO rmylovari_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Дычёл, кэ вов гинавэл амэн стрийна! Вов на фэри бикиндас амэн, ай ви халярдас кодо, со лас пала амэндэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Са о барвалипэ, саво о Дэл лас катар амаро дад, сы амаро ай амарэ щяворэнго. Кэр кадэ, сар о Дэл пхэндас тукэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Атунчи Яков щютас щяворэн тай ромнян опрэ пэ верблюдура, ");
INSERT INTO rmylovari_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","трададас са пэскэ алатон англа пэстэ, ай са пэскэ миштымаса, кай вов кидас андо Паддан-Арам, индулысардас кай пэско дад Исаак каринг э пхув Ханаан. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Лаван гэлас тэ муравэл лэ бакрэн, ай Рахиль чёрдас лэскэ кхэрутнэ дэвлэн. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Ай кадэ о Яков хохадас арамос Лаванос, чи пхэндас лэскэ, кэ традэлтар. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Вов нашластар са пэскэ миштымаса, накхлас пэрдал о паи ай гэлас каринг лэ харалы пхув Гилад. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","По трито дес Лаваноскэ пхэндэ, кэ Яков нашластар. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Вов лас пэса нямон ай щюдас-пэ пала Яков, ай па эфта дес арэслас лэн пэ харалы пхув Гилад. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Андэ коды рат андо суно кай арамеё Лаван авилас Дэл ай пхэндас лэскэ: «Фирин-ту, на пхэн канчи Яковоскэ, чи лащё, чи чёро». ");
INSERT INTO rmylovari_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Кана Лаван арэслас лэс, Яков аба щютас цэрға пэ харалы пхув Гилад. Ай ви Лаван куса пэскэ нямо инзардас котэ цэрғи. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Лаван пхэндас Яковоскэ: — Со ту кэрдан? Ту хохадан ман ай ингэрдан мурэ щеян, сар рабон по марипэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Состар хоходан ман ай чёрал нашлантар? Состар чи пхэндан мангэ тэ дав тут дром лошаса ай диланца, тэла башаипэ тобэнго тай арфэнго? ");
INSERT INTO rmylovari_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ту чи дан мангэ тэ чюмидав андо дром мурэ цынэ-щяворэн ай щеян. Ту кэрдан бигиндоско. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ман сы зор тэ кэрав тукэ чёрипэ, алом кады рати о Дэл тирэ дадэско пхэндас мангэ андо суно: «Фирин-ту, на пхэн канчи Яковоскэ, чи лащё, чи чёро». ");
INSERT INTO rmylovari_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ту гэлантар, анда кадо кэ чи рыбдыяс-пэ тукэ тэ болдэс-ту палпалэ май сыго андо тё дадэско кхэр. Алом состар чёрдан мурэ дэвлэн? ");
INSERT INTO rmylovari_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Яков пхэндас Лаваноскэ пэ кадо: — Мэ дарос, кэ ту пэ зор лэса мандар тирэ щеян. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Алом тэ аракхэса вари-кастэ катэ тирэ дэвлэн, кодо чи траия. Англа тирэ нямура родэ коркоро, тэ сы мандэ вари-со тиро, ай тэ аракхэса, лэ кадо палпалэ. Яков чи жянлас, кэ Рахиль чёрдас лэ дэвлэн. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Лаван гэлас андэ Яковоски цэрға, андэ Лияки цэрға ай андэ дуе бутяркинэнги цэрға, алом чи аракхлас канчи. Пала Лияки цэрға вов накхлас андэ Рахиляки цэрға. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Ай Рахиль англа кадо лас кхэрутнэ дэвлэн, щютас лэн андэ верблюдонги зэн ай бэшлас пэ лэ. Лаван родасас андэ са э цэрға, алом чи аракхлас канчи. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Э Рахиль пхэндас дадэскэ: — На холяйви, муро рай, кэ мэ наштык ущяв англа тутэ. Мандэ кадо, со кэрдёл кай э жювля сако щён. Ай сар вов чи родэлас, вов наштык аракхлас дэвлэн. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Яков сас андэ бари холи ай лас тэ пхэнэл ла аври Лаваноскэ: — Андэ состэ мури дош? — пущлас вов лэс. — Саво бэзэх мэ кэрдэм, кэ ту мэклан-пэ пала мандэ тэ астарэс ман? ");
INSERT INTO rmylovari_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Аканак, кана родан аври андо са муро миштыпэ, со ту аракхлан анда тиро? Щюв, со аракхлан, англа тирэ ай мурэ нямура, мэк вон дэн амэн крисы. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Мэ траисардэм тутэ биш бэрш. Тирэ бакря ай бусня чи щюдэнас пэстар, ай мэ чи халэм бакрэн анда тирэ кырдура. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Мэ чи анос тукэ бакрэн, щингэрдэ вадна алатонца, алом мэ коркоро щювос палпалэ пала лэн анда мури партя. Ту чяк лэсас мандар пала са, со сас чёрдо рати вай десэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Кадэ мэ траияс: десэ пхабарлас ман о кхам, рати чи дэлас ман пачя о шыл, ай о суно нашлас катар мурэ якха. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Кадэ сас биш бэрш, кай мэ кэрдэм бути пэ тутэ. Мэ бутязыяс пэ тутэ дэшуштар бэрш пала тирэ дуй щея ай шов бэрш пала алатура, ай ту дэшвар парувэсас муро потин. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Тэ на авило манца мурэ дадэско Дэл, Авраамоско Дэл, Кодо, Кастар дарлас Исаак, ту бищяданас ман палпалэ щюще вастэнца. Алом о Дэл дыкхлас мурэ киноскэ ай пхара бутякэ ай сыкадас тукэ рати тири дош. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Лаван пхэндас Яковоскэ пэ кадо: — Кадал щея сы мурэ щея, щявора сы мурэ щявора, ай кырдура сы мурэ кырдура. Са, со дыкхэс, сы муро. Алом со шай аканак кэрав мурэ щеянца вай лэ цынэ-щяворэнца? ");
INSERT INTO rmylovari_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Тэ пхангламас туса ворба, ту ай мэ, ай мэк кадо бар дыкхэл, со авла щютыно машкар амэндэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Яков лас бар ай щютас лэс тэ тордёл, тэ авэл э вурма пала щютыны ворба. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Вов пхэндас пэскэ челэдоскэ: — Кидэн бар. Вон кидэ бар, ракисардэ лэн харораса ай бэшлэ паша латэ тэ хан. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Лаван дас ла анав Егар-Сахадута, ай Яков — Гал-Эд. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Лаван пхэндас: — Кады харори анда бар дыкхэл, со щютыно машкар амэндэ адес. Акэ состар дынэ ла анав Гал-Эд. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Лакэ инкэ дынэ анав Мицпа, кэ вов пхэндас: — Мэк Рай Яхва лышый пала тутэ ай мандэ, кана аваса дур екх екхэстар. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Тэ инкэрдёса чёрэс мурэ щеянца вай лэса кавэрэ ромнян, ви тэ на авла амэнца кхоник, сэр, кэ о Дэл шундас щютыны ворба машкар тутэ ай мандэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Инкэ Лаван пхэндас Яковоскэ: — Акэ харори ай сэраимаско бар, саво мэ щютэм тэ тордёл машкар тутэ ай мандэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Кады харори ай о бар сыкавэн, кэ мэ чи накхав пэрдал кадал ракисардэ бар пэ тири риг тэ кэрав тукэ чёрипэ, ай ви ту чи накхэса пэрдал лэндэ пэ мури риг, тэ кэрэс мангэ чёрипэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Мэк Дэл Авраамоско ай Дэл Нахороско, ай лэнгэ дадэско Дэл тэ авэл крисынари машкар амэндэ. Ай Яков цолахардас Кодолэса, Савэстар дарлас лэско дад Исаак. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Вов дас жэртва котэ, пэ харалы пхув, ай акхардас пэскэ нямон тэ хан. Вон халэ ай ратярдэ котэ, пэ хар. ");
INSERT INTO rmylovari_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Ёкор дэтэғара Лаван чюмидас пэскэ цынэ-щяворэн ай щеян ай алдысардас лэн. Атунчи вов болдас-пэ кхэрэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","О Яков традас пэскэ дромэса. Атунчи вов дыкхлас Дэвлэскэ ангелон. ");
INSERT INTO rmylovari_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Кана Яков лас сама лэн, вов пхэндас: — Кадо Дэвлэско табор! Ай дас лэс анав Маханаим. ");
INSERT INTO rmylovari_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Яков бищядас англа пэстэ манушэн кай пэско прал Исав андэ пхув Сеир, андо тхэм Эдом. ");
INSERT INTO rmylovari_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Вов дас лэнгэ аври: — Акэ со тумэ трубуй тэ пхэнэн мурэ раскэ Исавоскэ: «Тиро слуга Яков пхэнэл: \"Мэ траисардэм кай о Лаван ай сымас котэ жи кай адесутно дес. ");
INSERT INTO rmylovari_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Мандэ сы гурува ай самары, бакрэ ай бусня, бутярнэ ай бутяркини. Аканак мэ бищявав кадо нэвипэ мурэ раскэ тэ аракхав милошаго андэ тирэ якха\"». ");
INSERT INTO rmylovari_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Кана э бищядэ мануш болдэ-пэ палпалэ, вон пхэндэ Яковоскэ: — Амэ самас кай тиро прал Исав, ай аканак вов коркоро авэл тэ арэсадёл туса, ай лэса жян 400 мануш. ");
INSERT INTO rmylovari_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Андэ бари дар ай пхарэ илэса Яков уладас пэ дуй табора пэскэ манушэн ай ви кырдура ай верблюдон. ");
INSERT INTO rmylovari_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Вов гиндыяс: «Тэ хутела Исав маримаса по допаш анда амандэ, лэ кавэр ащна наазбадэ ай фирина-пэ». ");
INSERT INTO rmylovari_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Яков лас тэ мангэл: — О, Дэл мурэ дадэско Авраамоско, Дэл мурэ дадэско Исаакоско, о Яхва, саво пхэндас мангэ: «Болдэ-ту палпалэ андэ тири пхув кай тирэ нямура, ай Мэ до тукэ миштыпэ»! ");
INSERT INTO rmylovari_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Мэ чи эрдэмлый касаво милошаго ай лышыпэ, савэ Ту дан Тирэ слугакэ. Мандэ кханчи нас, фэри дромэско кашт, кана мэ накхлэм Ёрдан, ай аканак мэ болдав-ма палпалэ дуе таборэнца. ");
INSERT INTO rmylovari_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Рудий тут, фирисар ман катар о васт мурэ пралэско Исавоско, анда кадо кэ мэ дарав, кэ вов авла ай хутела пэ мандэ ай пэ дэя щяворэнца. ");
INSERT INTO rmylovari_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Чяк Ту пхэндан: «Мэ щинадэм тукэ миштыпэ, ай тирэ парапутя авна кати бут, сар моряко кишай, саво наштык тэ гинавэс». ");
INSERT INTO rmylovari_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Яков ратярдас котэ ай анда кодо, со сас лэстэ, кидас аври подарко пэскэ пралэскэ Исавоскэ: ");
INSERT INTO rmylovari_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","200 буснян ай 20 бузнэн, 200 бакрян ай 20 бакрэн, ");
INSERT INTO rmylovari_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","30 верблюдицэн бурнювонца, 40 гурувнян ай 10 гурувэн, 20 самарэн жювлян ай 10 самарэн муршэн. ");
INSERT INTO rmylovari_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Вов дас бутярнэнгэ тэ лышын сако кырдо ригатэ ай пхэндас лэнгэ: — Жян англа мандэ ай инкрэн вари-соско дурипэ машкар кырдура. ");
INSERT INTO rmylovari_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Вов щитярдас манушэс, кон жялас англуно: — Кана арэсадёла туса муро прал ай пущла: «Каско сан ай кай жяс? Ай каско сы кырдо кай традавэс?» — ");
INSERT INTO rmylovari_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","атунчи ту трубуй тэ пхэнэс: «Кадал алатура сы тирэ слугаскэ Яковоскэ. Кадо подарко лэстар мурэ раскэ Исавоскэ, ай коркоро Яков жял пал амэндэ». ");
INSERT INTO rmylovari_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Вов щитярдас ви дуйтонэс, ви тритонэс, ви кавэрэн, кон жялас пала сако кырдо: — Ви тумэ трубуй тэ пхэнэн са кадо Исавоскэ, кана вов авла сэмбэ тумэнгэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Ай на бистрэн тэ пхэнэн: «Тиро слуга Яков жял палал». Яков гиндыяс: «Мэ ковлярав лэско ило кадалэ даронца, кай бищявав англа мандэ, ай май палал, кана дыкхас-амэ, вов шай авла лащё каринг мандэ». ");
INSERT INTO rmylovari_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Кадэ Яковоскэ дары сас бищядэ англал, ай вов коркоро ратярдас андо табор. ");
INSERT INTO rmylovari_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Коды рати Яков ущилас ай лас пэскэ дуе ромнян, дуе бутяркинян ай дэшуекхэ щявэн ай накхлас пэрдал э нал Яббок. ");
INSERT INTO rmylovari_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Вов ингэрдас лэн пэрдал о паи ай пала кадо ви са пэско миштыпэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Атунчи Яков ащилас коркоро, ай Вари-кон биркозыяс лэса жи по ғайнало. ");
INSERT INTO rmylovari_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Кана вон биркозынас, Кодо дыкхлас, кэ чи нирий, ай шэртысардас машкарэско кокало кай о Яков. ");
INSERT INTO rmylovari_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Котар Вов пхэндас: — Мэк Ман; киздый-пэ о ғайнало. Алом Яков пхэндас пэ кадо: — Чи мэкав, жипон чи бахтярэса ман. ");
INSERT INTO rmylovari_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Кодо пущлас: — Сар бущёс? — Яков, — пхэндас вов. ");
INSERT INTO rmylovari_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Атунчи Кодо пхэндас: — Катар кадо дес тиро анав авла на Яков, ай Израиль, анда кадо кэ ту биркозысас лэ Дэвлэса ви лэ манушэнца, ай нирисардан. ");
INSERT INTO rmylovari_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Яков пущлас: — Мангав Тут, пхэн мангэ Тиро анав. Алом Вов пхэндас пэ кадо: — Состар пущес Муро анав? Ай Вов бахтярдас лэс котэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Яков пхэндас: «Мэ дыкхлэм муй лэ Дэвлэско ай ащилэм жювиндо», — ай дас анав кодолэ тханэскэ Пениэл. ");
INSERT INTO rmylovari_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","О кхам сас аба опрэ, кана вов накхлас Пениэл, ай лангалас анда пэско пунро. ");
INSERT INTO rmylovari_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Акэ состар жи кай аканак израильтянура чи хан гырчё анда машкарэско кокало: кэ о Дэл азбадас о машкарэско кокало паша гырчё кай о Яков. ");
INSERT INTO rmylovari_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Яков щюдас лэ якха ай дыкхлас, кэ авэл Исав ай лэса 400 мануш. Вов уладас щяворэн машкар Лия, Рахиль ай дуй бутяркини. ");
INSERT INTO rmylovari_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Вов щютас бутяркинян ай лэнгэ щяворэн англал, Лия ай лакэ щяворэн пала лэндэ, ай Рахиля Ёсифоса пала саворэндэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ай вов коркоро гэлас англал ай эфтавар азбадас э пхув, кана пашолас каринг пэско прал. ");
INSERT INTO rmylovari_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Алом Исав нашлас каринг Яков, лас лэс андэ ангаля ай пала кор ай чюмидас лэс, ай вон рутэ екх пэ екхэстэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Исав дыкхлас жювлян ай щяворэн ай пущлас: — Кон кадал туса? Яков пхэндас: — Кадал щявора, савэн о Дэл па пэско милошаго дас тирэ слугас. ");
INSERT INTO rmylovari_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Котар бутяркини пэскэ щяворэнца пашылэ ай бандилэ жи кай пхув англа Исав. ");
INSERT INTO rmylovari_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Пала лэндэ пашылэ ай бандилэ Лия ай лакэ щявора. Пала саворэндэ пашылэ Ёсиф ай Рахиль, ай ви вон бандилэ жи кай пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Исав пущлас катар о Яков: — Со сы са кодал кырдура сэмбэ мангэ, кай дыкхлэм? — Мэ камав тэ аракхав милошаго андэ тирэ якха, муро рай, — пхэндас кодо. ");
INSERT INTO rmylovari_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Исав пхэндас: — Мандэ са сы, прала. Ащяв тиро тукэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","— На, мангав тут! — пхэндас пэ кадо Яков. — Тэ аракхлэм милошаго андэ тирэ якха, лэ мандар кадо даро. Анда кадо кэ тэ дыкхав тиро муй, — кадо сар тэ дыкхав муй лэ Дэвлэско, чяк ту сан лащё каринг мандэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Мангав тут, лэ кадо даро, кай андэм тукэ, кэ о Дэл сас милошо каринг мандэ, ай мандэ сы са, со ман трубуй. Яков зурарлас, ай Исав лас дарура. ");
INSERT INTO rmylovari_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Атунчи Исав пхэндас: — Авэн, аба трубуй тэ жяс андо дром, мэ инкэрдюво паша тутэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Алом Яков пхэндас лэскэ: — Муро рай жянэл, кэ щяворэндэ най бут зор, ай кэ мэ трубуй тэ лышый пала бакря ай гурувня, кай чялярэн пэскэ бурнювон. Тэ традаво лэн сыго интрэго дес, са лэ алатура мэрна. ");
INSERT INTO rmylovari_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Мэк муро рай традэл англа пэско слуга, ай мэ жяв локхорэс, сар бирина тэ жян кырдура ай лэ щявора, жипон аво кай муро рай андо Сеир. ");
INSERT INTO rmylovari_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Исав пхэндас: — Атунчи дэ ма тэ ащявав туса вари-кати анда мурэ мануш. — Состар тэ кэрэс кадо? — пущлас Яков. — Доста ви кодо, кэ мэ аракхлэм милошаго андэ мурэ раскэ якха. ");
INSERT INTO rmylovari_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Андо кодо дес Исав лас тэ традэл палпалэ каринг Сеир. ");
INSERT INTO rmylovari_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Алом Яков гэлас андо Суккот, кай вов кэрадас пэскэ кхэр ай цынкаловура анда кранжи лэ алатонгэ. Анда кадо кадо тхан бущёл Суккот. ");
INSERT INTO rmylovari_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Анда Паддан-Арам Яков арэслас пачяса андо форо Шэхем андо Ханаан ай щютас тэлэпо надур катар о форо. ");
INSERT INTO rmylovari_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Пала шэл рупунэ вов киндас котор пхув катар щявэ лэ Хамороскэ, кон сас Шэхемоско дад. Вов щютас котэ пэски цэрға. ");
INSERT INTO rmylovari_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Котэ вов кэрадас жэртвенник ай дас лэс анав «Эль-Элохей-Йисраэль». ");
INSERT INTO rmylovari_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Дина, щей ла Лияки катар Яков, гэлас тэ дыкхэл-пэ катарутнэ жювлянца. ");
INSERT INTO rmylovari_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Ай кай о хив Хамор, кон визэрияс коды пхув, сас щяво Шэхем. Кана Шэхем дыкхлас Дина, вов хутилдас ла тай кэрдас пэ ла зор. ");
INSERT INTO rmylovari_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Лэско ило рагадысайлас кай э Дина, щей лэ Яковоски, вов камлас ла ай ворбияс ласа лащимаса. ");
INSERT INTO rmylovari_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Атунчи Шэхем пхэндас пэскэ дадэскэ Хамороскэ: — Лэ мангэ кадала щя ромнякэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Кана Яков шундас, кэ пэ лэски щей Дина кэрдэ зор, лэскэ щявэ сас пэ маля лэскэ кырдонца, ай вов чи пхэнлас па кадо, жипон вон чи болдэ-пэ палпалэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Шэхемоско дад Хамор авилас тэ ворбий лэ Яковоса. ");
INSERT INTO rmylovari_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Ай Яковоскэ щявэ, сар фэри шундэ, со кэрдилас, болдэ-пэ палпалэ па маля. Вон сас пхэрдэ холи тай брига, анда кадо кэ Шэхем кэрдас лажяво ай напативало баё андо Израиль, кана пашлилас Яковоска щяса, ай кадо наштык сас кэрдо. ");
INSERT INTO rmylovari_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Хамор пхэндас лэнгэ: — Муро щяво Шэхем са пэскэ илэса цырдас-пэ каринг тумари щей. Мангав, дэн ла лэскэ ромнякэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Пхандас машкар амэндэ абавэски ворба: дэн амэнгэ тумарэ щеян ай даса пала тумэндэ амарэ щеян. ");
INSERT INTO rmylovari_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Тумэ шай траин машкар амэндэ, — амари пхув англа тумэндэ. Траин пэ латэ, индулын ай кинэн ла. ");
INSERT INTO rmylovari_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Шэхем пхэндас Динакэ дадэскэ ай пралэнгэ: — Дэн мангэ тэ аракхав милошаго андэ тумарэ якха, ай мэ дав тумэнгэ са, со пхэнна. ");
INSERT INTO rmylovari_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Щён тимин тэ потинав пала бори, ви саво даро мэ трубуй тэ анав пала латэ, ай кати баро вов тэ на авэл, мэ потино са, со тумэ пхэнна. Фэри дэн ма э щя паларом. ");
INSERT INTO rmylovari_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Яковоскэ щявэ ворбинас хохаимаса Шэхемоса ай лэскэ дадэса Хамороса, кэ лэнга пха Дина щютэ андо лажяво. ");
INSERT INTO rmylovari_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Вон пхэндэ лэнгэ: — Амэ наштык кэрас касаво: тэ дас амара пха нащиндлэ муршэскэ. Кадо щюто амэн андо лажяво. ");
INSERT INTO rmylovari_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Амэ даса тумэнгэ ворба фэри пала кодо, сар тумэ авна, сар амэ, ай щинэна агора тумарэ муршэнгэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Атунчи амэ ласа тэ дас пала тумэ амарэ щеян ай тэ лас пала амэндэ тумарэн. Амэ ласа тэ траин машкар тумэндэ ай аваса тумэнца екх нацыя. ");
INSERT INTO rmylovari_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Алом тэ на камэна тэ авэн щиндэ, амэ ласа амара пха ай жясатар. ");
INSERT INTO rmylovari_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Лэнгэ ворби пэлэ андо ило кай о Хамор ай кай лэско щяво Шэхем. ");
INSERT INTO rmylovari_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Кадо тэрно щяво, саво сас май пативало анда са пэскэ дадэско челэдо, щидярдас тэ кэрэл, со вон пхэндэ, кэ вов хасардас шэро анда Яковоски щей. ");
INSERT INTO rmylovari_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Атунчи Хамор ай лэско щяво Шэхем авилэ кай лэнгэ фороски капува тэ ворбин манушэнца. ");
INSERT INTO rmylovari_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","— Кадал мануш лаще каринг амэндэ, — пхэндэ вон. — Мэк траин пэ амари пхув ай индулын; пэ кады пхув доста тхан. Амэ шай ласа лэнгэ щеян ромнянгэ, ай ви вон лэна амарэн. ");
INSERT INTO rmylovari_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Алом кадал мурш камэна тэ траин амэнца сар екх нацыя, фэри тэ авэн амарэ мурш щиндэ, сар вон. ");
INSERT INTO rmylovari_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Атунчи лэнгэ кхэрутнэ ай кырдонгэ алатура ай са лэнго миштыпэ авла ви амаро. Даса лэнгэ ворба, ай вон траина машкар амэндэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Са, кон кидэ-пэ паша фороски капува, ворбисайлэ лэ Хамороса ай лэскэ щявэса Шэхемоса, ай са лэ мурш андо форо кэрдилэ щиндэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Па трин дес, кана вон инкэ рыбдынас дукх, дуй Яковоскэ щявэ Симеон ай Левий, Динакэ прал, лынэ пэскэ ханрэ, екварса пэлэ по форо ай мудардэ са лэ муршэн. ");
INSERT INTO rmylovari_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Вон мудардэ ханрэса Хаморос ай лэскэ щявэс Шэхемос, лынэ пэска пха анда Шэхемоско кхэр ай гэлэтар. ");
INSERT INTO rmylovari_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Атунчи э щявэ Яковоскэ авилэ палпалэ, дынэ андрэ андэ кхэра кай лэ мудардэ ай чёрардэ о форо, кай лэнги пхэн сас щютэны андо лажяво. ");
INSERT INTO rmylovari_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Вон лынэ са алатонгэ кырдура, самарэн ай са, со сас андо форо ай пэ маля. ");
INSERT INTO rmylovari_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Са манушэнго миштыпэ, ви лэнгэ жювлян ай щяворэн, ви са, со сас андэ кхэра, — вон са лынэ пэскэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Атунчи Яков пхэндас Симеоноскэ ай Левиёскэ: — Тумэ кэрдан мангэ баро баё, кэ кэрдан анда мандэ, сар магердо, англа мануш, савэ траин пэ кады пхув, англа ханааны ай перезы. Амэн цэра, ай тэ кидэна-пэ вон кхэтанэ сэмбэ мангэ ай хутена пэ мандэ, мэ ай муро кхэр авна хасарадэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Алом вон пхэндэ пэ кадо: — Шай сас тэ кэрэн амара пхаса, сар лубняса? ");
INSERT INTO rmylovari_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","О Дэл пхэндас Яковоскэ: — Жя жи кай Бэт-Эль, щюв котэ цэрғи ай кэрав жэртвенник лэ Дэвлэскэ, Саво сыкадилас тукэ, кана ту нашлантар катар тиро прал Исав. ");
INSERT INTO rmylovari_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Яков пхэндас пэскэ челэдоскэ ай саворэнгэ, кон сас лэса: — Щюдэн-тумэ катар стрийна дэвла, кай сы тумэндэ, ужарэн-тумэ лэндар ай парувэн лэ гада. ");
INSERT INTO rmylovari_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Кидэн-тумэ, авэн жи кай Бэт-Эль, кай мэ кэраво жэртвенник лэ Дэвлэскэ, Саво шундас ман, кана сас мангэ чёрэс, ай Саво сас манца, кай тэ на жёс. ");
INSERT INTO rmylovari_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Вон дынэ Яковоскэ са стрийна дэвлэн, савэ сас лэндэ, ай злага анда лэнгэ кан, ай Яков прахосардас лэн тэла баро копачи андо Шэхем. ");
INSERT INTO rmylovari_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Котар вон гэлэ андо дром, ай дар лэ Дэвлэски щерадас са лэ форура круял лэндэ. Анда кадо кхоник чи нашлас пала лэндэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Яков ай саворэ, кон сас лэса, авилэ андо Луз (андо Бэт-Эль) пэ пхув Ханаан. ");
INSERT INTO rmylovari_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Котэ вов кэрадас жэртвенник ай щютас кодолэ тханэскэ анав «Эль-Бэт-Эль», кэ котэ о Дэл сыкадилас лэскэ, кана вов нашластар катар пэско прал. ");
INSERT INTO rmylovari_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Девора, кон чялярлас ай барардас ла Ревека, мулас ай сас прахосарды тэла учё булғо копачи паша Бэт-Эль. Анда кодо лэскэ дынэ анав «Аллон Бахут». ");
INSERT INTO rmylovari_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Кана Яков болдас-пэ палпалэ андо Паддан-Арам, о Дэл инкэ еквар сыкадилас лэскэ ай бахтярдас лэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","О Дэл пхэндас лэскэ: — Тиро анав Яков, алом аканак ту чи бущёса Яков. Тиро анав авла «Израиль». Кадэ Вов дас лэс анав Израиль. ");
INSERT INTO rmylovari_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Ай о Дэл пхэндас лэскэ: — Мэ сым Дэл Са-Биримаско. Кэрэн щяворэн ай кэрдён май бут. Тутар сармозына нацыя ай интрэго пайташыпэ лэ нацыенго, катар тутар жянатар края. ");
INSERT INTO rmylovari_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Э пхув, кай Мэ дэм кай Авраам ай Исаак, Мэ дав ви тукэ, ви тирэ парапутёнгэ, кай авна пала тутэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Ай о Дэл ваздас-пэ котар. ");
INSERT INTO rmylovari_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","По кодо тхан, кай о Дэл ворбияс лэса, Яков щютас тэ тордёл о бар ай щёрдас пэ лэс мол ай улэй. ");
INSERT INTO rmylovari_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Кодолэ тханэскэ, кай о Дэл ворбияс лэса, Яков дас анав «Бэт-Эль». ");
INSERT INTO rmylovari_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Котар вон гэлэтар катар Бэт-Эль. Вон сас аба надур катар Эфрата, кана кай э Рахиль лас тэ аракхадёл щяворо, ай сас лакэ пхарэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Вой зуралэс халас кино. Жювли, сави жутыяс лакэ, пхэндас: — На дара! Тутэ авла инкэ екх щяво. ");
INSERT INTO rmylovari_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Кана анда Рахиль дэлас аври о ди, андо мэрипэ, вой дас анав пэскэ щявэскэ Бэн-Они, алом о дад дас лэс анав Вениамин. ");
INSERT INTO rmylovari_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Атунчи Рахиль мулас ай сас прахомэ па дром андо Эфрата (Вифлеем). ");
INSERT INTO rmylovari_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","По кодо тхан Яков щютас тэ тордёл о бар. Ай жи аканак кодо бар сыкавэл, кай вой сас прахомэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Израиль гэлас май дур ай щютас пэски цэрға пала Мигдал-Эдэр. ");
INSERT INTO rmylovari_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Кана Израиль траияс пэ коды пхув, Рувим пашлилас лэ дадэски наложницаса Валласа, ай Израиль жянглас па кадо. Кай о Яков сас дэшудуй щявэ: ");
INSERT INTO rmylovari_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Катар э Лия: Рувим, о англуно Яковоско щяво, Симеон, Левий, Иуда, Иссахар ай Завулон. ");
INSERT INTO rmylovari_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Катар э Рахиль: Ёсиф ай Вениамин. ");
INSERT INTO rmylovari_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Катар Рахиляки бутяркиня Валла: Дан ай Неффалим. ");
INSERT INTO rmylovari_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Катар Лияки бутяркиня Зэлфа: Гад ай Асир. Кадал сас лэ щявэ, савэ аракхадилэ кай о Яков андо Паддан-Арам. ");
INSERT INTO rmylovari_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Яков авилас кай пэско дад Исаак андо Мамрэ, кай сы паша Кирьят-Арба (Хеврон), ай кай траинас Авраам ай Исаак. ");
INSERT INTO rmylovari_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Исаак траисардас шэл ай охтовардэш бэрш. ");
INSERT INTO rmylovari_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Котар вов цырдас пэско палуно пхаро ди ай гэластар кай пэскэ мулэ пхуро ай чяло катар о траё. Лэскэ щявэ Исав ай Яков прахосардэ лэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Акэ панасы па вица Исавоски (вай Эдомоски). ");
INSERT INTO rmylovari_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Исав лас пэскэ ромнян анда ханааноскэ жювля: лэ хетоска Элоноска щя Ада, лэ Анаска щя Оголивама, кон сас внучка лэ хивоски Цывеоноски, ");
INSERT INTO rmylovari_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ай ви Измаилоска щя Басемата, кон сас Нэваётоски пхэн. ");
INSERT INTO rmylovari_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ада кэрдас Исавоскэ Элифазос, Басемат кэрдас Реуэлос, ");
INSERT INTO rmylovari_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ай Оголивама кэрдас Еушос, Яламос ви Корахос. Кадал сас лэ щявэ Исавоскэ, савэ аракхадилэ лэстэ андо Ханаан. ");
INSERT INTO rmylovari_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Исав лас ромнян, щявэн ай щеян, ай са пэско челэдо, са алатонгэ кырдура, ви са кавэр алатон, ай пэско миштыпэ, саво вов кидас андо Ханаан. Вов щютас-пэ пэ пхув, кай сас дурал катар пэско прал Яков, ");
INSERT INTO rmylovari_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","анда кадо кэ лэндэ сас касавэ барэ миштымата, кэ вон наштык траинас кхэтанэ: э пхув наштык хахавлас дуе пралэнгэ алатон. ");
INSERT INTO rmylovari_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Кадэ Исав (вай Эдом) лас тэ траий андэ харалы пхув Сеир. ");
INSERT INTO rmylovari_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Акэ панасы па вица Исавоски, кон сас дад лэ эдомэнго ай траияс андэ харалы пхув Сеир. ");
INSERT INTO rmylovari_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Акэ Исавоскэ щявэнгэ анава: Элифаз, Исавоско щяво катар лэски ромни Ада, ай Реуэл, Исавоско щяво катар лэски ромни Басемат. ");
INSERT INTO rmylovari_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Элифазоскэ щявэ: Теман, Омар, Цэфо, Гатам ай Кеназ. ");
INSERT INTO rmylovari_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Кай Исавоско щяво Элифаз сас наложница, кай бущёлас Тимна, сави кэрдас лэскэ Амалекос. Кадал сас цынэ-щявора Исавоскэ лэска ромнятар Адатар. ");
INSERT INTO rmylovari_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Реуэлоскэ щявэ: Нахат, Зерах, Шамма ай Мизза. Кадал сас цынэ-щявора Исавоскэ катар лэски ромни Басемат. ");
INSERT INTO rmylovari_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Акэ Исавоскэ щявэ катар лэски ромни Оголивама, щей лэ Анаски ай э внучка Цывеоноски. Акэ щявэ, савэн вой кэрдас Исавоскэ: Еуш, Ялам ай Корах. ");
INSERT INTO rmylovari_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Акэ вайды машкар Исавоскэ парапутя. Акэ щявэ лэ Элифазоскэ, Исавоскэ англунэ щявэскэ: вайды Теман, Омар, Цэфо, Кеназ, ");
INSERT INTO rmylovari_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","вайды Корах, Гатам ай Амалек. Кадал сас вайды, кай сармозынас катар Элифаз анда Эдом; вон сас Адакэ цынэ-щявора. ");
INSERT INTO rmylovari_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Акэ щявэ лэ Реуэлоскэ, Яковоскэ щявэскэ: вайды Нахат, Зерах, Шамма ай Мизза. Кадал сас вайды, кай сармозынас катар Реуэл анда Эдом; вон сас Исавоскэ ромнякэ Басематакэ цынэ-щявора. ");
INSERT INTO rmylovari_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Акэ Исавоскэ щявэ катар лэски ромни Оголивама: вайды Еуш, Ялам ай Корах. Кадал сас вайды, кай сармозынас катар Исавоски ромни Оголивама, щей лэ Анаски. ");
INSERT INTO rmylovari_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Кадал сас щявэ Исавоскэ (вай Эдомоскэ) ай лэнгэ вайды. ");
INSERT INTO rmylovari_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Акэ хороскэ Сеироскэ щявэ, савэ траинас андэ кады пхув: Лотан, Шовал, Цывеон, Ана, ");
INSERT INTO rmylovari_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Дишон, Эцэр ай Дишан. Кадал Сеироскэ щявэ анда Эдом сас лэ хоронгэ вайды. ");
INSERT INTO rmylovari_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Лотаноскэ щявэ: Хорий ай Хемам. Тимна сас Лотаноски пхэн. ");
INSERT INTO rmylovari_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Шовалоскэ щявэ: Алван, Манахат, Эвал, Шэфо ай Онам. ");
INSERT INTO rmylovari_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Цывеоноскэ щявэ: Ая ай Ана. Кадо сас Ана, кон аракхлас пхабардэ пировура андэ пустыня, кана лышыяс пала пэскэ дадэскэ Цывеонаскэ самары. ");
INSERT INTO rmylovari_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Анаскэ щявора: Дишон ай Оголивама, Анаски щей. ");
INSERT INTO rmylovari_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Дишоноскэ щявэ: Хемдан, Эшбан, Итран ай Керан. ");
INSERT INTO rmylovari_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Эцэроскэ щявэ: Билхан, Зааван ай Акан. ");
INSERT INTO rmylovari_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Дишаноскэ щявэ: Уц ай Аран. ");
INSERT INTO rmylovari_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Акэ хоронгэ вайды: вайды Лотан, Шовал, Цывеон, Ана, ");
INSERT INTO rmylovari_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","вайды Дишон, Эцэр ай Дишан. Вон сас хоронгэ вайды, па саки вица пэ пхув Сеир. ");
INSERT INTO rmylovari_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Акэ края, савэ визэринас андо Эдом, инкэ англа кодо, сар кэрдилэ края андо Израиль. ");
INSERT INTO rmylovari_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Бела, Беороско щяво, сас край андо Эдом. Лэско форо бущёлас Дингава. ");
INSERT INTO rmylovari_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Пала Беласко мэрипэ Зерахоско щяво Ёвав анда Боцра кэрдилас край. ");
INSERT INTO rmylovari_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Пала Ёвавоско мэрипэ Хушам анда тэманонги пхув кэрдилас край. ");
INSERT INTO rmylovari_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Пала Хушамоско мэрипэ Бэдадоско щяво Гадад, саво нирисардас мидьянон андо Моав, кэрдилас край. Лэско форо бущёлас Авит. ");
INSERT INTO rmylovari_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Пала Гададоско мэрипэ Самла катар Масрэка кэрдилас край. ");
INSERT INTO rmylovari_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Пала Самласко мэрипэ Саул катар Реховот (кай сас паша нал) кэрдилас край. ");
INSERT INTO rmylovari_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Пала Саулоско мэрипэ Ахбороско щяво Баал-Ханан кэрдилас край. ");
INSERT INTO rmylovari_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Пала мэрипэ Баал-Хананоско, кон сас щяво лэ Ахбороско, Гадар кэрдилас край. Лэско форо бущёлас Пау, ай лэски ромни бущёлас Мегетавэль; вой сас щей ла Матридаки, ай внучка Мезагавоски. ");
INSERT INTO rmylovari_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Акэ сар бущёнас вайды, Исавоскэ парапутя, па лэнгэ анава, вицы ай пхува: вайды Тимна, Алва, Етет, ");
INSERT INTO rmylovari_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","вайды Оголивама, Эла, Пинон, ");
INSERT INTO rmylovari_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","вайды Кеназ, Теман, Мивцар, ");
INSERT INTO rmylovari_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","вайды Магдиэл ай Ирам. Кадал сас вайды андо Эдом, па лэнгэ тэлэпура, андэ пхува, кай вон лынэ пэскэ. Кадо сас Исав, эдомэнго дад. ");
INSERT INTO rmylovari_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Яков траияс пэ коды пхув, кай индулыяс лэско дад, пэ пхув Ханаан. ");
INSERT INTO rmylovari_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Кадо сы панасы па Яковоски вица. Ёсиф, дэшэфта-бэршэнго щяво, лышыяс пала бакрэнгэ кырдура пэскэ пралэнца — Яковоскэ щявэнца катар Валла ай Зэлфа, савэ сас Ёсифоскэ дадэскэ ромня. Ёсиф пхэнлас пэскэ дадэскэ чёрипэ па кадал пэскэ прал. ");
INSERT INTO rmylovari_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Израиль камэлас Ёсифос май бут саворэ щявэндар, анда кадо кэ вов аракхадилас лэстэ по пхурипэ. Израиль кэрдас лэскэ барвалэ гада. ");
INSERT INTO rmylovari_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Кана лэ Ёсифоскэ прал дыкхлэ, кэ лэнго дад камэл лэс май бут, сар кавэрэн, вон лынэ тэ инкрэн холи пэ лэстэ ай наштык ворбинас лэса пачяса. ");
INSERT INTO rmylovari_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Еквар Ёсиф дыкхлас суно, ай кана вов панаскодысардас лэс пэскэ пралэнгэ, вон холяйлэ пэ лэс инкэ май бут. ");
INSERT INTO rmylovari_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Акэ со вов лэнгэ пхэндас: — Шунэн, саво суно мэ дыкхлэм. ");
INSERT INTO rmylovari_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Амэ пхандасас снопура пэ мал, сар екварса муро снопо ваздас-пэ ай вортосайлас, ай тумарэ снопура тордилэ круял ай бандилэ лэскэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Лэ прал пхэндэ лэскэ: — Кэ шай ту авэса край пэ амэндэ? Кэ шай чячес визэриса амэн? Ай вон инкэрдэ инкэ май бут холи пэ лэстэ анда лэско суно ай анда кадо панасы. ");
INSERT INTO rmylovari_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Лэскэ дычилас инкэ екх суно, ай вов палэ панаскодысардас па лэс пэскэ пралэнгэ: — Шунэн, — пхэндас вов. — Мэ дыкхлэм инкэ екх суно. Аканак англа мандэ бандилэ о кхам, о щёнуто ай дэшуекх черғая. ");
INSERT INTO rmylovari_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Вов панаскодысардас о суно на фэри пралэнгэ, ай ви дадэскэ. О дад пхэндас: — Че суно дычилас тукэ? Сой кадо: мэ, тири дэй ай тирэ прал чячес аваса ай бандюваса жи кай э пхув англа тутэ? ");
INSERT INTO rmylovari_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Э прал инкэрнас холи пэ лэс, алом о дад инкэрлас кадо андо пэско шэро. ");
INSERT INTO rmylovari_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Лэ прал гэлэтар тэ лышын пала дадэскэ кырдура паша Шэхем, ");
INSERT INTO rmylovari_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","ай Израиль пхэндас Ёсифоскэ: — Тирэ прал лышын пала кырдура паша Шэхем. Мэ камав тэ бищявав тут лэндэ. — Миштой, — пхэндас палпалэ о Ёсиф. ");
INSERT INTO rmylovari_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","О дад пхэндас лэскэ: — Жя дыкх, са сы пачяса тирэ пралэнца ай ви кырдонца вай на, ай пхэнэса мангэ. Ай вов бищядас лэс катар э пхув Хеврон. Ёсиф авилас андо Шэхем. ");
INSERT INTO rmylovari_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Кана вов пхирлас акаркай, екх мануш маладилас лэса ай пущлас: — Со ту родэс? ");
INSERT INTO rmylovari_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Кодо пхэндас: — Мэ родав мурэ пралэн. Ту шай пхэнэс мангэ, кай вон лышын пала пэскэ кырдура? ");
INSERT INTO rmylovari_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","— Вон гэлэтар катар, — пхэндас о мануш. — Мэ шундэм, сар вон пхэннас: «Авэн андо Дотан». Атунчи Ёсиф гэлас пала пэскэ прал ай аракхлас лэн паша Дотан. ");
INSERT INTO rmylovari_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Алом вон дыкхлэ лэс дэ дурал ай, англа кодо, сар вов арэслас, ворбисайлэ тэ мударэн лэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","— Эта авэл кадо сунэнго рай! — пхэндэ вон екх екхэскэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","— Тэ мудардамас лэс ай тэ щюдамас андэ шуки хаинг, ай тэ пхэндамас дадэскэ, кэ халас лэс вадно алато. Атунчи дыкхаса, со авла анда лэскэ сунэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Кана Рувим шундас кадо, вов кэрдас са, со бирияс, тэ фирий лэс лэнгэ вастэндар, ворбаса: — На, чи трубуй тэ лас лэско траё. ");
INSERT INTO rmylovari_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Котар щютас пашэ: — На щёрэн рат. Щюдэн лэс андэ кады шуки хаинг катэ, андэ пустыня, алом на ваздэн тумаро васт пэ лэстэ. Рувим камэлас тэ фирий лэс лэндар ай тэ болдэл лэс палпалэ кай лэско дад. ");
INSERT INTO rmylovari_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Кана Ёсиф пашылас кай пэскэ прал, вон лынэ тэлэ па лэс лэ гада — кодал барвалэ гада, кай сас пэ лэстэ, — ");
INSERT INTO rmylovari_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","ай щюдэ лэс андэ хаинг. Э хаинг сас щющи, бипаески. ");
INSERT INTO rmylovari_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Вон бэшлэ тэ хан ай лынэ сама измаильтянонгэ верблюдон, савэ жянас анда Гилад. Пэ верблюдура сас ракисардэ пхаримата: спецыи, бальзам ай ладан, кай вон ингэрнас андо Египет. ");
INSERT INTO rmylovari_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Иуда пхэндас пэскэ пралэнгэ: — Эта, шай мударас лэс ай тэгэдусарас кадо, ай че амэнгэ ғасна? ");
INSERT INTO rmylovari_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Май федэр тэ бикиндамас лэс измаильтянонгэ, ай тэ на ваздамас пэ лэстэ амаро васт. Кэ вов амаро прал, амаро мас ай рат. Лэ прал патяе лэско муй. ");
INSERT INTO rmylovari_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Кана мидьянонгэ бикинытора накхнас пашэ, лэ прал лынэ Ёсифос аври анда хаинг ай бикиндэ лэ измаильтянонгэ пала биш шэкели рупэса. Измаильтяны лынэ лэс андо Египет. ");
INSERT INTO rmylovari_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Кана Рувим болдас-пэ кай о хаинг, вов дыкхлас, кэ Ёсиф най котэ, ай щингэрдас пэ пэстэ гада. ");
INSERT INTO rmylovari_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Вов авиластар кай пэскэ прал ай пхэндас: — Щяво котэ най! Кай мэ тэ жяв аканак? ");
INSERT INTO rmylovari_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Атунчи вон лынэ Ёсифоскэ гада, щиндэ бузнэс ай макхлэ лэ гада ратэса. ");
INSERT INTO rmylovari_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Вон ингэрдэ кадал барвалэ гада пэскэ дадэскэ ай пхэндэ: — Акэ со амэ аракхлам. Дыкх, кадал тирэ щявэскэ гада? ");
INSERT INTO rmylovari_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Вов пинжярдас лэн цыпимаса: — Кадал гада мурэ щявэскэ! Лэс халас вадно алато! Ёсиф сас щингэрдо пэ котора! ");
INSERT INTO rmylovari_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Яков щингэрдас пэ пэстэ гада, патярдас о машкар гонэнгэ похтанэса ай бут дес ровлас па щяво. ");
INSERT INTO rmylovari_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Са лэскэ щявэ тай щея авилэ тэ чендэшысарэн лэс, алом вов чи лэлас сама пэ кадо ай пхэнлас: — На, мэ кадэ, андэ брига, жявтар андэ мулэнги лума, кай муро щяво. Кадэ о дад ровлас пала пэско щяво. ");
INSERT INTO rmylovari_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ай андэ коды врама мидьяны ингэрдэ Ёсифос андо Египет ай бикиндэ лэс раскэ Потифароскэ. Кодо сас паранчёдашы пэ кэтаны, савэ сас лышытора андэ фараоноски диз. ");
INSERT INTO rmylovari_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Андэ коды врама Иуда ащядас пэскэ пралэн ай гэлас тэ траий кай екх мануш, кай бущёлас Хира ай кай сас анда Адуллам. ");
INSERT INTO rmylovari_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Котэ Иуда маладилас лэ ханааноскира Шуаскира щяса. Вов лас ла ромнякэ ай лас тэ траий ласа. ");
INSERT INTO rmylovari_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Вой пэлас кхамны ай кэрдас щявэс, савэскэ дынэ анав Эр. ");
INSERT INTO rmylovari_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Котар вой палэ кхамнилас ай кэрдас щявэс, ай дас лэс анав Онан. ");
INSERT INTO rmylovari_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Латэ аракхадилас инкэ екх щяво, каскэ вой дас анав Шэла. Вов аракхадилас латэ андо Кезив. ");
INSERT INTO rmylovari_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Иуда лас Эроскэ, пэскэ англунэ щявэскэ, ромня, кай бущёлас Тамар. ");
INSERT INTO rmylovari_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Алом о Эр, Иудаско англуно, андэ Раскэ Яхваскэ якха сас напативало. Ай о Рай Яхва мудардас лэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Атунчи Иуда пхэндас Онаноскэ: — Ту трубуй тэ пашлёс тирэ пралэска ромняса, кэ сан лако ромэско прал, ай мусай тэ кэрэс щяворэн тирэ пралэскэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Алом Онан жянлас, кэ щявора чи авна лэскэ, ай миндык, кана пашлёлас пэскэ пралэска ромняса, вов мэклас пэ пхув, тэ на кэрэл щяворэн пэскэ пралэскэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Кодо, со вов кэрлас, сас напативалэс андэ Раскэ Яхваскэ якха, анда кадо Вов мудардас ви Онанос. ");
INSERT INTO rmylovari_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Атунчи Иуда пхэндас пэска боракэ Тамаракэ: — Траисар сар пхивлы андо те дадэско кхэр, жипон чи барола муро щяво Шэла. Вов дас-пэ гиндо: «Тэ на мэрэл ви о Шэла, сар лэскэ прал». Атунчи Тамар гэластар тэ траий андо кхэр кай пэско дад. ");
INSERT INTO rmylovari_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Па бут начилы врама лэ Иудаски ромни, Шуаски щей, мулас. Кана начилас о дясо, Иуда гэлас андэ Тимна кай лэ мануш, савэ муравнас лэскэ бакрэн, ай лэско пайташы Хира анда Адуллам гэлас лэса. ");
INSERT INTO rmylovari_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Тамаракэ пхэндэ: — Тиро сокро жял андэ Тимна тэ муравэл пэскэ бакрэн. ");
INSERT INTO rmylovari_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Атунчи вой лас тэлэ пхивланэ гада, щярадас пэско муй тэ на пинжярэн ла, ай бэшлас паша фороски капува паша Энаим, о форо па дром каринг Тимна. Вой кэрдас кадо, кэ дыкхлас, кэ о Шэла аба барилас, алом ла чи дынэ лэскэ ромнякэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Кана Иуда дыкхлас ла, вов гиндысардас, кэ кады лубни, анда кадо кэ лако муй сас щерадо. ");
INSERT INTO rmylovari_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Вов чи пинжярдас, кэ вой лэски бори. Ай вов бандярдас тэлэ па дром, пашылас латэ ай пхэндас: — Авэн, дэ ма тэ пашлював туса. Вой пущлас: — Ай со ту дэса ман анда кодо, кэ ту пашлёса манца? ");
INSERT INTO rmylovari_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Вов пхэндас: — Мэ бищяво тукэ тэрна буснёра анда муро кырдо. Вой пущлас: — Ай ту дэса ман вари-соско придипэ, жипон бищявэса буснёра? ");
INSERT INTO rmylovari_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Вов пущлас пэ кадо: — Саво придипэ тэ дав тукэ? Вой пхэндас: — Тири печать по шэлоро ай дромэско кашт, саво тутэ андо васт. Вов дас ла са кадо ай пашлилас ласа, ай вой пэлас лэстар кхамны. ");
INSERT INTO rmylovari_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Пала кадо вой гэластар котар, путэрдас щерадо муй ай палэ урадас пхивланэ гада. ");
INSERT INTO rmylovari_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Андэ коды врама Иуда бищядас буснёра пэскэ пайташэса Хираса анда Адуллам, тэ лэл палпалэ о придипэ катар коды жювли, алом о пайташы чи аракхлас ла. ");
INSERT INTO rmylovari_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Вов пущлас катар лэ котарутнэ мануш: — Кай сы коды лубни, кай бэшлас паша дром каринг Энаим? Вон пхэндэ пэ кадо: — Катэ нас чи соски лубни. ");
INSERT INTO rmylovari_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Ай вов болдас-пэ палпалэ кай Иуда ай пхэндас: — Мэ чи аракхлэм ла. Ай лэ котарутнэ мануш пхэндэ мангэ: «Катэ нас чи соски лубни». ");
INSERT INTO rmylovari_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Иуда пхэндас: — Мэк ащявэл пэскэ кодо, со лас, кэ лэ мануш асана амэндар. Мэ чяк бищядэм лакэ буснёра, алом ту чи аракхлан ла. ");
INSERT INTO rmylovari_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Па трин щён Иудаскэ пхэндэ: — Тири бори Тамар сы дошалы андэ лубнязыпэ ай катар кадо кхамнилас. Иуда пхэндас пэ кадо: — Ингрэн ла, ай мэк пхабарэн ла! ");
INSERT INTO rmylovari_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Алом кана ла ингэрнас, вой бищядас лэскэ касавэ ворби: — Мэ сым кхамны катар о мануш, каско сы кадо, — ай щютас пашэ: — Дыкх, ту пинжярэс, каскэ сы кады печать по шэлоро ай дромэско кашт? ");
INSERT INTO rmylovari_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Иуда пинжярдас лэн ай пхэндас: — Чячипэ пэ лаки риг, анда кадо, кэ мэ чи дэм ла пала муро щяво Шэла. Ай вов май бут чи пашлилас ласа. ");
INSERT INTO rmylovari_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Кана авилас лаки врама тэ кэрэл щяворэс, дычилас, кэ латэ сас дуй щявэ кэтэша. ");
INSERT INTO rmylovari_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Кана вон аракхадёнас, екх лэндар щютас аври о васт. Атунчи жювли, сави жутыяс лакэ, пханглас по кадо васт лоло тхав ай пхэндас: — Кадо гэлас аври англуно. ");
INSERT INTO rmylovari_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Алом вов цырдас о васт палпалэ, ай гэлас аври лэско прал. Жювли пхэндас: — Сар ту щиндилан аври англуно?! Ай лэскэ дынэ анав Парец. ");
INSERT INTO rmylovari_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Котар аракхадилас ви кодо, кастэ по васт сас лоло тхав, ай лэс дынэ анав Зерах. ");
INSERT INTO rmylovari_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ёсифос андэ андо Египет, ай египтяно Потифар, саво сас рай кай о фараоно, паранчёдашы пэ кэтаны-лышынара андо диз, киндас Ёсифос катар измаильтяны, савэ андэ лэс котэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","О Рай Яхва сас лэ Ёсифоса, ай са сас лэстэ мишто андо кхэр кай лэско газда египтяно. ");
INSERT INTO rmylovari_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Лэско газда дыкхлас, кэ о Рай Яхва сы Ёсифоса ай дэл лэс бахт андо са, со вов кэрэл. ");
INSERT INTO rmylovari_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Ёсиф аракхлас милошаго андэ лэскэ якха ай кэрдилас лэско ажутори. Потифар щютас лэс тэ визэрий лэско кхэр ай тэ лышый са лэско миштыпэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ай катар коды врама, сар вов щютас Ёсифос тэ авэл лэско визэри, о Рай Яхва бахтярдас Потифарос анда Ёсиф. Вов бахтярдас са, со сас лэстэ, ви кхэрэ, ви пэ мал. ");
INSERT INTO rmylovari_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Анда кодо Потифар дас Ёсифоскэ тэ лышый пала са, со сас лэстэ. Анда Ёсиф вов чи гиндыяс па канчестэ, фэри халас ай пэлас. Ёсиф сас мишто кэрадо ай шукар, ");
INSERT INTO rmylovari_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","ай па вари-соски врама лэскэ раски ромни лас тэ дыкхэл каринг лэстэ ай пхэндас: — Пашлюв манца! ");
INSERT INTO rmylovari_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Алом вов чи камлас ай пхэндас: — Анда кадо кэ мэ сым визэри катэ, муро рай най па состэ тэ гиндый андо пэско кхэр; ай вов дас мангэ тэ лышый пала са. ");
INSERT INTO rmylovari_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Андо кадо кхэр най мануш май баро мандар. Муро рай чи сунуй мангэ канчи, фэри тут, кэ ту сан лэски ромни. Чяк сар мэ шай кэрав касави напативалы бути ай тэ кэрав бэзэх англа Дэл? ");
INSERT INTO rmylovari_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Вой ворбияс лэса па кадо дес пала дес, алом вов чи камлас тэ пашлёл ласа вай ви тэ авэл паша латэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Еквар вов авилас андо кхэр тэ кэрэл пэскэ бутя, кана кхоник анда кхэрэскэ бутяра нас кхэрэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Вой хутилдас лэс пала гада ай пхэндас: — Пашлюв манца! Алом вов щиндилас латар ай нашластар анда кхэр, ай лэско опруно ураипэ ащилас андэ лакэ васт. ");
INSERT INTO rmylovari_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Кана вой дыкхлас, кэ вов нашластар анда кхэр ай ащядас пэско ураипэ андэ лакэ васт, ");
INSERT INTO rmylovari_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","вой акхардас кхэрэскэ бутярнэн ай пхэндас лэнгэ: — Дыкхэн, кадо евреё сас андыно андо амаро кхэр тэ асал аври амэндар! Вов авилас катэ ай камлас тэ пашлёл манца, алом мэ лэм тэ цыпий. ");
INSERT INTO rmylovari_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Атунчи андэ щидяр вов ащядас пэско ураипэ ай нашластар анда кхэр. ");
INSERT INTO rmylovari_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Вой инкэрлас Ёсифоско ураипэ пэстэ, жипон авилас кхэрэ Ёсифоско газда. ");
INSERT INTO rmylovari_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Атунчи вой ви лэскэ панаскодысардас кадо панасы: — Кадо рабо-евреё, кай ту андан амэндэ, авилас мандэ ай зурарлас тэ пашлёл манца. ");
INSERT INTO rmylovari_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Алом сар фэри мэ лэм тэ цыпий, вов ащядас пэско ураипэ ай нашластар анда кхэр. ");
INSERT INTO rmylovari_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Ёсифоско рай шундас ла ромняко панасы. Ай вой щютас паша кадо: «Акэ сар тиро рабо сас тэ кэрэл манца», — ай вов зуралэс холяйлас. ");
INSERT INTO rmylovari_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Вов лас Ёсифос ай бэшадас лэс андэ тэмлица, кай сас бэшадэ лэ краескэ пханглэ. Алом кана Ёсиф сас андэ тэмлица, ");
INSERT INTO rmylovari_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","о Рай Яхва сас лэса; Вов сас лащё каринг лэстэ ай дас лэскэ милошаго катар о тэмлицако визэри. ");
INSERT INTO rmylovari_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Кодо рай щютас Ёсифос май барэскэ пэ са э пханглэ, ай вов лышыяс пала са андэ тэмлица. ");
INSERT INTO rmylovari_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","О тэмлицако визэри чи лэлас сама пэ канчестэ, со сас дыно андэ Ёсифоскэ васт, анда кадо кэ о Рай Яхва сас лэ Ёсифоса ай дэлас лэс бахт андэ са бутя. ");
INSERT INTO rmylovari_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Па вари-кати врама дуй краескэ бутярнэ — моляри ай пэкари — пэлэ андэ дош англа лэнго рай, Египетско край. ");
INSERT INTO rmylovari_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Фараоно холяйлас пэ дуй пэскэ пашутнэ рай, по май баро моляри ай май баро пэкари, ");
INSERT INTO rmylovari_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","ай бэшадас лэн андо кхэр кай о тэмлицако визэри, андэ тэмлица, кай сас щютыно ви Ёсиф. ");
INSERT INTO rmylovari_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Баро пэ лышытора пхэндас Ёсифоскэ тэ бутязый лэнгэ. Пала кодо, сар вон аба сас пханглэ вари-соски врама, ");
INSERT INTO rmylovari_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","солдуй мурш — краеско моляри ай пэкари — андэ екх рати дыкхлэ сунэ, ай андо сако суно сас пэско гиндо. ");
INSERT INTO rmylovari_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Кана Ёсиф авилас лэндэ по кавэр дес ёкор, вов дыкхлас, кэ вон па вари-состэ бригин. ");
INSERT INTO rmylovari_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Ай вов пущлас катар кодал фараоноскэ пашутнэ рай, кай сас пханглэ кхэтанэ лэса андо лэскэ газдаско кхэр: — Состар тумэ бригин адес? ");
INSERT INTO rmylovari_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","— Амэ солдуй дыкхлам сунэ, — пхэндэ вон, — ай най кон тэ гичий лэн. Ёсиф пхэндас лэнгэ: — Лэ сунэнго гичипэ чяк авэл катар о Дэл! Панаскодын мангэ тумарэ сунэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Атунчи май баро моляри панаскодысардас лэскэ пэско суно: — Мэ дыкхлэм англа мандэ дракхаки кранжя, ");
INSERT INTO rmylovari_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ай пэ латэ сас трин раика. Сар фэри пэ ла сыкадилэ бобочя, вой екварса дас лулудя, ай лулудя кэрдилэ дракха. ");
INSERT INTO rmylovari_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Мандэ андо васт сас фараоноски чеса. Мэ лэм э дракх ай кикидэм ла аври андэ чеса ай дэм андэ васт кай фараоно. ");
INSERT INTO rmylovari_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","— Акэ сой кадо, — пхэндас Ёсиф. — Трин раика — кадо трин дес. ");
INSERT INTO rmylovari_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Па трин дес фараоно палэ ваздэла тут ай щёла палпалэ по тиро тхан, ай ту дэса фараоноскэ лэски чеса, сар майинты, кана санас лэско моляри. ");
INSERT INTO rmylovari_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Атунчи кана тутэ са авла мишто, дэ-ту гиндо па мандэ ай сыкав тё лащипэ каринг ман: пхэн фараоноскэ па мандэ ай цырдэ ман аври анда кады тэмлица. ");
INSERT INTO rmylovari_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Чяк ман пэ зор андэ катар евреёнги пхув. Ай ви катэ мэ чи сым анда канчестэ дошало тэ бэшав андэ тэмлица. ");
INSERT INTO rmylovari_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Кана май баро пэкари дыкхлас, кэ Ёсиф аракхлас лащё гиндо андо суно, ви вов пхэндас Ёсифоскэ: — Ви мэ дыкхлэм суно: мэ инкрос по шэро трин кошницы манрэса. ");
INSERT INTO rmylovari_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Андэ опруны кошница сас лэ пэкимата тэ инграв лэ фараоноскэ, алом лэн ханас чирикля ворта анда кошница, кай сас по муро шэро. ");
INSERT INTO rmylovari_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","— Акэ сой кадо, — пхэндас Ёсиф. — Трин кошницы — кадо трин дес. ");
INSERT INTO rmylovari_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Па трин дес фараоно ви тут ваздэла: вов щинла тукэ тэлэ о шэро, ай тё стато умблавна по копачи, ай лэс лэна тэ хан чирикля. ");
INSERT INTO rmylovari_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Трито дес сас лэ фараоноско аракхадимаско дес, ай вов кэрдас мисаляки патив саворэ пэскэ пашутнэ рангэ. Вов ваздас лэ май барэ молярэс ай барэ пэкарэс англа са лэ рандэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Вов болдас молярэс палпалэ по лэско тхан, ай кодо палэ дас чеса андо фараоноско васт. ");
INSERT INTO rmylovari_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Алом вов умбладас по копачи лэ май барэ пэкарэс, сар Ёсиф гичисардас лэнгэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Алом о май баро моляри чи дас-пэ гиндо па Ёсиф; вов бистэрдас па лэстэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Начилэ дуй бэрш, ай фараоноскэ сыкадилас суно: вов тордёлас паша нал Нил, ");
INSERT INTO rmylovari_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","кана анда нал авилэ аври эфта гурувня — грыжымэ ай тхулэ. Вон лынэ хахавэн-пэ машкар камышы. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Пала лэндэ анда Нил авилэ кавэр эфта гурувня — жюнгалэ тай шутярдэ — ай тордилэ по таласы паша англунэ гурувня. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ай жюнгалэ тай шукэ гурувня халэ лэ грыжымэ тай тхулэ гурувнян. Атунчи о фараоно убрэдысайлас. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Вов палэ сутас, ай дыкхлас кавэр суно: эфта дивэскэ колосы баронас састэ ай тхулярдэ пэ екх раикори. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Пала лэндэ барилэ инкэ эфта колосы — шукэ тай билярдэ пхабардэ балваляса. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Шукэ колосы накхадэ эфта састэн тай тхулярдэн. Ай фараоно убрэдысайлас. Кадо сас суно. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ёкор пхарэ гиндура чи ащявнас лэс. Вов кидас саворэ тудошэн ай бутжянглэн, кай сас андо Египет. Вов панаскодысардас лэнгэ пэскэ сунэ, алом кхоник чи бирисардэ тэ гичин лэн. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Атунчи май баро моляри пхэндас фараоноскэ: — Адес мэ дэм-ма гиндо па мури дош. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Еквар фараоно холяйлас пэ пэскэ бутярнэ ай бэшадас ман тай лэ май барэ пэкарэс андо кхэр кай о паранчёдашы пэ лышытора. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Амэ солдуй андэ екх рати дыкхлам сунэ, ай андо сако суно сас пэско гиндо. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Котэ сас амэнца екх тэрно евреё, слуга кай паранчёдашы пэ лышытора. Амэ панаскодысардам лэскэ амарэ сунэ, ай вов гичисардас лэн амэнгэ ай аракхлас саконэ сунэскэ пэско гиндо. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ай са кэрдилас кадэ, сар вов ви пхэндас амэнгэ: ман болдэ палпалэ по муро тхан, ай кавэрэ манушэс умбладэ по копачи. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Фараоно бищядас пала Ёсиф, ай лэс сыго андэ анда тэмлица. Вов рандадас-пэ, парудас лэ гада ай авилас англа фараоно. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Фараоно пхэндас лэ Ёсифоскэ: — Мэ дыкхлэм суно, ай кхоник наштык гичий лэс. Алом мэ шундэм па тутэ, кэ ту атярэс андэ сунэ ай шай гичис лэн. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","— На, наштык кэрав кадо, — пхэндас о Ёсиф. — Алом о Дэл пхэнла фараоноскэ кадо, со вов камэл. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Фараоно пхэндас Ёсифоскэ: — Мэ дыкхлэм андо суно, кэ тордював по таласы паша нал Нил, ");
INSERT INTO rmylovari_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","кана анда нал авилэ аври эфта гурувня — грыжымэ ай тхулэ, ай лынэ тэ хахавэн-пэ машкар камышы. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Пала лэндэ анда Нил авилэ кавэр эфта гурувня — зуралэс жюнгалэ тай шутярдэ. Мэ шоға чи дыкхлэм касавэ жюнгалэ гурувнян пэ интрэги Египтоски пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Э шукэ, жюнгалэ гурувня халэ лэ тхулярдэ гурувнян, савэ авилэ англунэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ай ви кана вов халэ лэн, лэнгэ кадо нас ғасна: вон ащилэ касавэ жюнгалэ, сар сас. Атунчи мэ убрадысайлэм. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Инкэ мэ дыкхлэм андо суно эфта колосы, пхэрдэ лаще дивэскэ сэмноса, кай баронас пэ екх раикори. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Пала лэндэ барилэ кавэр эфта колосы: шукэ, санэ ай билярдэ пхабардэ балваляса. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Санэ колосы накхадэ лэ лащен. Мэ панаскодысардэм кадо лэ тудошэнгэ, алом кхоник чи бирисардэ тэ гичин о суно. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Атунчи Ёсиф пхэндас лэ фараоноскэ: — Андэ кодал сунэ сы екх гиндо. О Дэл путэрдас фараоноскэ, со вов кидэл-пэ тэ кэрэл. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Эфта лаще гурувня — кадо эфта бэрш, ай ви эфта дивэскэ колосы — кадо эфта бэрш; кадо сы екх суно. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Эфта шукэ, жюнгалэ гурувня, кай авилэ палал, ай эфта канческэ дивэскэ колосы, билярдэ пхабардэ балваляса, — кадо сы эфта бокхалэ бэрш. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Эта ворта кодо, со мэ пхэндэм фараоноскэ: о Дэл сыкадас лэскэ, со вов кидэл-пэ тэ кэрэл. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Эфта зуралэс барвалэ бэрш авна по са о тхэм Египет, ");
INSERT INTO rmylovari_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","алом пала лэндэ авна эфта бокхалэ бэрш. Атунчи са барвалэ бэрш авна бистэрдэ, ай э пхув авла щющи анда бокх. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Кхоник чи сэрэла па барвалипэ, кэ э бокх пала кадо авла насул. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ай сас сыкадэ дуй сунэ екхэ гиндоса анда кадо, кэ о Дэл щютас аба пэ кадо баё, ай сыго пхэрдёла, со Вов камэл тэ кэрэл. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Ай аканак мэк о фараоно аракхэл годявэрэ манушэс, саво шай дыкхэл, со авла англал, ай щёла лэс тэ визэрий о тхэм Египет. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Мэк о фараоно щёл лышыторэн па са о тхэм тэ кидэн э панжьто партя катар са, со дэл э пхув андо Египет, кана авна эфта лаще бэрш. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Мэк андэ кодал лаще бэрш вон кидэн див, тэ инкрэн лэс андэ форура тэла фараоноско лышыпэ, тэ авэл хабэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Трубуй тэ фирин кадо хабэ ай тэ хан лэс, кана авна эфта бокхалэ бэрш андо Египет, тэ на хасайвэл са о тхэм бокхатар. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Кадал ворби чялилэ лэ фараоноскэ ай са лэскэ рангэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Ай о фараоно пущлас лэндар: — Шай аракхаса инкэ касавэс, сар кадо мануш, андэ савэстэ сы духо Дэвлэско? ");
INSERT INTO rmylovari_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Ай фараоно пхэндас лэ Ёсифоскэ: — Анда кадо кэ о Дэл путэрдас тукэ са кадо, най май годявэр мануш тутар, кай шай дыкхэл, со авла англал. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Мэ щював тут визэрескэ андэ мури диз, ай са мурэ мануш патяна тё муй. Фэри муро кралицко тхан авла май опрэ тутар. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Ай фараоно пхэндас Ёсифоскэ: — Мэ щював тут пэ са пхув Египтоски. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Котар вов лас тэлэ па най ангрусти ай урадас по Ёсифоско най. Вов урадас лэс андэ санэ похтана ай щютас лэскэ пэ кор сумнакуно ланцо. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Вов дас аври тэ пхиравэн лэс андо гинтово сар дуйтонэс пала лэстэ ай тэ цыпин англа лэс: «Аврех!» Кадэ вов щютас лэс май барэса пэ са э пхув Египтоски. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Атунчи фараоно пхэндас Ёсифоскэ: — Мэ сым фараоно, алом би тира ворбако кхоник чи тромал наеса тэ мишкий. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Вов дас Ёсифоскэ анав Цафнах-Панеах ай дас лэскэ ромни Асната, ла Поти-Пераска щя. Лако дад сас рашай по форо Он. Ай Ёсиф традас тэ накхэл са Египтоски пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Ёсифоскэ сас транда бэрш, кана вов лас тэ кэрэл бути по фараоно, Египетско край. Вов гэластар катар фараоно ай традэлас па са Египет. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Са эфта чялэ бэрш э пхув дэлас пхэрдо хабэната. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Ёсиф кидэлас са, со дэлас э пхув Египет андэ кадал бэрш, ай инкэрлас андэ форура. Андо сако форо вов кидэлас хабэ, кай баролас пэ пашутнэ маля. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Вов кидас кадэ бут див, сар кишай андо море. Лэс сас кати бут, кэ вов аба чи гинавлас о сэмно, кэ наштык сас тэ гинавэн лэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Англа кодо, сар авилэ бокхалэ бэрш, кай о Ёсиф аракхадилэ дуй щявэ катар Аснат, щей лэ Поти-Пераски, кон сас рашай по форо Он. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Ёсиф пхэндас: «О Дэл дас тэ бистрав са муро кино ай са мурэ дадэско челэдо», ай пэскэ англунэскэ дас анав Манассия. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Дуйтонэ щявэскэ вов дас анав Ефрем ай пхэндас: «О Дэл дас мангэ щяворэн пэ пхув, кай хос кино». ");
INSERT INTO rmylovari_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Эфта чялэ бэрш андо Египет авилэ кай о агор, ");
INSERT INTO rmylovari_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ай киздысайлэ эфта бокхалэ бэрш, сар ви пхэндас Ёсиф. Бокх сас ви андэ са кавэр пхува, алом пэ са пхув Египтоски сас хабэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Кана са о Египет лэлас тэ бокхайвэл, лэ мануш манглэ лэ фараонос пала хабэ. Атунчи вов пхэндас: — Жян кай Ёсиф ай кэрэн, сар вов пхэнла. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Кана э бокх буғлилас па са тхэм, Ёсиф путэрдас са э болты ай лас тэ бикнэл о див египтянонгэ, кэ э бокх андо са Египет сас насул. ");
INSERT INTO rmylovari_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Анда са лэ тхэма лэ мануш авнас кай Ёсиф тэ кинэн див, анда кадо кэ пэ са э пхув сас бари бокх. ");
INSERT INTO rmylovari_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Кана Яков жянглас, кэ андо Египет сы див, вов пхэндас пэскэ щявэнгэ: — Со тумэ дыкхэн екх пэ екхэстэ? — ");
INSERT INTO rmylovari_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Ай щютас пашэ: — Мэ шундэм, кэ андо Египет сы див. Традэн котэ ай кинэн лэс амэнгэ, тэ траисарас аври ай тэ на мэрас. ");
INSERT INTO rmylovari_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ай дэш Ёсифоскэ прал традэ андо Египет тэ кинэн див. ");
INSERT INTO rmylovari_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Алом Яков чи бищядас лэ кавэрэнца лэ Вениаминос, Ёсифоскэ пралэс, анда кадо кэ дарлас тэ на маладёл лэса вари-со чёро. ");
INSERT INTO rmylovari_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Кадэ щявэ Израилёскэ авилэ машкар бут кавэр мануш тэ кинэн див, кэ ви пэ пхув Ханаан сас бокх. ");
INSERT INTO rmylovari_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Андэ коды врама Ёсиф визэрияс са о тхэм; вов бикинлас о див манушэнгэ па са Египет. Кана лэ Ёсифоскэ прал авилэ, вон бандилэ лэскэ жи кай пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Сар фэри Ёсиф дыкхлас пэскэ пралэн, вов пэ екхатэ пинжярдас лэн, алом кэрдас-пэ, кэ чи жянэл лэн, ай лас тэ ворбий лэнца, сар о визэри стрийнонэнца. — Катар тумэ авилан? — пущлас вов. — Катар э пхув Ханаан, тэ кинас хабэ, — пхэндэ вон пэ кадо. ");
INSERT INTO rmylovari_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Ёсиф пинжярдас пэскэ пралэн, алом вон чи пинжярдэ лэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Котар вов дас-пэ гиндо па пэскэ сунэ ай пхэндас: — Тумэ сан шпионы! Тумэ авилан тэ дыкхэн аври, кай андэ амари пхув сы назуралэ тхана. ");
INSERT INTO rmylovari_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","— На, рая, — пхэндэ вон, — тирэ слуги авилэ тэ кинэн хабэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Амэ са сам екхэ дадэскэ щявэ. Тирэ слуги на хохавнэ мануш, на шпионы. ");
INSERT INTO rmylovari_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Вов пхэндас лэнгэ: — На! Тумэ авилан тэ дыкхэн аври, кай андэ амари пхув сы назуралэ тхана. ");
INSERT INTO rmylovari_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Алом вон пхэндэ пэ кадо: — Амэн, тирэ слугэн, сас дэшудуй прал. Амэ самас щявэ екхэ дадэскэ, саво траий андэ пхув Ханаан. Май цыно ви аканак дадэса, ай екхэс анда амэндэ май бут най. ");
INSERT INTO rmylovari_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Ёсиф пхэндас лэнгэ: — Мэ чяк пхэндэм, кэ тумэ сан шпионы! ");
INSERT INTO rmylovari_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Акэ сар мэ зумаво тумэн: цолахав лэ фараоноскэ траёса, кэ тумэ чи жянатар катар, жипон чи авэл катэ тумаро май цыно прал. ");
INSERT INTO rmylovari_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Бищявэн екхэс анда тумэ пала прал, ай лэ кавэр бэшна андэ тэмлица, тэ атярав, чячипэ андэ тумари ворба вай нычи. Тэ най тумэн чячипэ, цолахав фараоноскэ траёса, кэ тумэ сан шпионы! ");
INSERT INTO rmylovari_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ай вов пхандадас лэн пэ трин дес. ");
INSERT INTO rmylovari_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","По трито дес Ёсиф пхэндас лэнгэ: — Кэрэн, со мэ пхэно, ай тумэ траина, кэ мэ дарав Дэвлэстар. ");
INSERT INTO rmylovari_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Тэ сан тумэ чяче мануш, мэк екх анда тумэндэ ащел андэ тэмлица, ай лэ кавэр жян тэ ингрэн див пэскэ бокхалэ челэдоскэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Алом тумэ трубуй тэ анэн мандэ тумарэ май цынэ пралэс, тэ жянав, тэ сы чячюнэ тумарэ ворби. Атунчи ащна траимэ. Кадэ вон ви кэрдэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Вон пхэндэ екх екхэскэ: — Дычёл, кэ пэ амэндэ сы кады дош анда амаро прал. Амэ дыкхлам лэско кино, кана вов манглас амэн тэ фирисарас лэско траё, алом амэ чи камлам тэ шунас лэс. Акэ состар пицысардам кадо чёрипэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Рувим пхэндас пэ кадо: — Мэ чяк пхэнос тумэнгэ: на кэрэн бэзэх анда щяворо. Алом тумэ чи камлан тэ патян муро муй! Аканак потинас анда лэско рат. ");
INSERT INTO rmylovari_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Вон чи гиндынас, кэ о Ёсиф атярэл лэн, анда кадо кэ вов ворбияс лэнца пэрдал до-щибанго мануш. ");
INSERT INTO rmylovari_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Андэ лэскэ якха сыкадилэ асва, ай вов болдас-пэ лэндар, алом котар палэ лас тэ ворбий лэнца. Вов дас аври лышыторэнгэ тэ лэн Симеонос ай тэ пхандэн лэс пэ пралэнгэ якха. ");
INSERT INTO rmylovari_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Ёсиф дас аври тэ пхэрдярэн лэнгэ гонэ дивэса, тэ щён саконэскэ палпалэ лэско руп ай тэ дэн лэн хабэ андо дром. Кана кадо сас кэрдо, ");
INSERT INTO rmylovari_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","вон щютэ лэ гонэ пэ самары ай гэлэтар. ");
INSERT INTO rmylovari_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Кана вон ащядилэ тэ ратярэн, екх анда прал путэрдас о гоно тэ дэл хабэ пэскэ самарэскэ ай дыкхлас опрал по див пэско руп. ");
INSERT INTO rmylovari_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","— Муро руп болдас-пэ палпалэ! — пхэндас вов лэ пралэнгэ. — Акэ вов андо муро гоно. Лэнгэ илэ морцосайлэ даратар; вон болдэ-пэ екх пэ екхэстэ ай пхэндэ: — Сой кэрдас амэнца о Дэл? ");
INSERT INTO rmylovari_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Кана вон авилэ кай пэнго дад Яков пэ пхув Ханаан, вон панаскодысардэ лэскэ па са, со лэнца кэрдилас. Вон пхэндэ: ");
INSERT INTO rmylovari_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","— Мануш, саво визэрий коды пхув, ворбияс амэнца насулымаса ай инкэрдёлас амэнца, сар тэ авиламас шпионы. ");
INSERT INTO rmylovari_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Алом амэ пхэндам лэскэ: «Амэ сам чяче мануш, ай на шпионы. ");
INSERT INTO rmylovari_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Амэ самас дэшудуй прал, екхэ дадэскэ щявэ. Екх анда амэндэ аба най, ай о май цыно ащилас дадэса андо Ханаан». ");
INSERT INTO rmylovari_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Атунчи мануш, саво визэрий коды пхув, пхэндас амэнгэ: «Акэ сар мэ жяно, чяче мануш сан вай на: ащявэн екхэ пралэс катэ манца, лэн хабэ тумарэ бокхалэ челэдоскэ ай жянтар. ");
INSERT INTO rmylovari_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Алом анэн мангэ тумарэ май цынэс пралэс. Кадэ мэ жяно, кэ тумэ чи сан шпионы, ай чяче мануш. Атунчи мэ до тумэнгэ палпалэ тумарэ пралэс ай тумэнгэ авна слободо тэ индулын пэ кады пхув». ");
INSERT INTO rmylovari_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Кана вон путэрдэ лэ гонэ, сако анда лэндэ аракхлас андрэ пэско бузё рупэса. Кана дыкхлэ о руп, вон ай ви лэнго дад дарайлэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Яков пхэндас лэнгэ: — Тумэ лынэ мандар мурэ щяворэн. Ёсиф май бут най, ай ви Симеоно май бут най, ай аканак тумэ камэн тэ лэн ви Вениаминос. Са болдас-пэ сэмбэ мангэ! ");
INSERT INTO rmylovari_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Атунчи Рувим пхэндас лэ дадэскэ: — Мударэса мурэ дуе щявэн, тэ на ано тукэ лэс. Дэ кадо баё андэ мурэ васт, ай мэ ано лэс палпалэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Алом о Яков пхэндас: — Муро щяво чи жяла котэ туса. Лэско прал мулас, ай вов ащилас екхоро. Тэ маладёла лэса чёрипэ андо дром, бригатар мэ жётар андэ мулэнги лума. ");
INSERT INTO rmylovari_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Э бокх сас инкэ насул пэ коды пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Кана вон халэ са о див, кай андэ анда Египет, лэнго дад пхэндас: — Болдэн-тумэ палпалэ ай кинэн амэнгэ инкэ эк-цэра хабэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Алом Иуда пхэндас лэскэ: — Кодо мануш дас амэнгэ аври: «На сыкадён мангэ пэ якха, тэ на авла тумэнца тумаро прал». ");
INSERT INTO rmylovari_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Тэ мэкэса амэнца амарэ пралэс, атунчи амэ жяс ай кинас тукэ хабэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ай тэ на мэкэса лэс, амэ чи традас, анда кадо кэ кодо мануш пхэндас: «На сыкадён мангэ пэ якха, тэ на авла тумэнца тумаро прал». ");
INSERT INTO rmylovari_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Израиль пущлас: — Состар тумэ андэ мангэ кадо насул баё, кана пхэндэ кодолэ манушэскэ, кэ сы тумэ инкэ екх прал? ");
INSERT INTO rmylovari_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Вон пхэндэ пэ кадо: — Кодо мануш пущелас аври са па амэндэ ай па амаро челэдо: «Жювиндо тумаро дад? Сы тумэ инкэ прал»? Амэ фэри пхэндам палпалэ пэ кодо, па со вов амэндар пущлас. Катар амэ жянгламас, кэ вов пхэнла: «Анэн катэ тумарэ пралэс»? ");
INSERT INTO rmylovari_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Атунчи Иуда пхэндас Израилёскэ, пэскэ дадэскэ: — Бищяв лэ щяворэс манца, ай сыго традастар, тэ ащен саворэ жювиндэ: ви ту, ви амэ, ви амарэ щявора, ай тэ на мэрэн. ");
INSERT INTO rmylovari_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Мэ дав тукэ ворба, кэ коркоро лышыя, тэ на маладёл щяворэса чёрипэ; мандар авла пущипэ анда лэстэ. Тэ на ано лэс тукэ ай тэ на щюво лэс англа тирэ якха, кады дош авла пэ мандэ са муро траё. ");
INSERT INTO rmylovari_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Тэ на цырдамас э врама, аба дувар болдамас-амэ палпалэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Атунчи лэнго дад Израиль пхэндас лэнгэ: — Тэ наштык кадо мунтуй амэн, атунчи кэрэн акэ со: щювэн андэ кошницы май лаще хабэната анда амари пхув: бальзамо ай адвин, специи ай ладан, фисташки ай миндаль, — ай ингрэн кодолэ манушэскэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Лэн тумэнца дувар май бут руп. Кэ тумэ трубуй тэ дэн палпалэ ви о руп, со сас щютэно андэ тумарэ гонэ. Файма кодал, кон щютэ тумэнгэ руп, хохадилэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Лэн ви тумарэ пралэс ай сыго жян палпалэ кай кодо мануш. ");
INSERT INTO rmylovari_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Мэк о Дэл Са-Биримаско дэл тумэн милошаго англа лэстэ, тэ мэкэл вов аври ви Вениаминос, ви кавэрэ тумарэ пралэс, тэ болдэн-тумэ кхэрэ кхэтанэ. Ай тэ авла мангэ щинадо тэ ащяв би щяворэнго, мэк тэ авэл пэ кадо. ");
INSERT INTO rmylovari_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Атунчи вон лынэ подарки, дувар май бут руп ай ви Вениаминос. Вон щидярдэ каринг о Египет ай котэ авилэ англа Ёсиф. ");
INSERT INTO rmylovari_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Кана Ёсиф дыкхлас, кэ Вениамин лэнца, вов пхэндас пэскэ ажутороскэ, кай визэрияс лэско кхэр: — Ингэр кадалэ манушэн андо муро кхэр, щин екх алато ай кэр мисаля. По допаш о дес вон хана манца. ");
INSERT INTO rmylovari_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","О мануш кэрдас, сар лэскэ пхэндэ, ай андас пралэн андо Ёсифоско кхэр. ");
INSERT INTO rmylovari_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Вон дарайлэ, кана лэн андэ андо лэско кхэр, ай гиндысардэ: «Амэн андэ катэ пала руп, саво сас щютэно андэ амарэ гонэ, кана самас катэ англунымастар. Вов камэл тэ хутел пэ амэндэ ай тэ нирий амэн, тэ кэрэл анда амэндэ рабура ай тэ лэл амарэ самарэн». ");
INSERT INTO rmylovari_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Вон пашылэ кай кхэрэско визэри ай лынэ тэ ворбин лэса паша кхэрэско вудар: ");
INSERT INTO rmylovari_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","— Шун, рая, — пхэндэ вон, — амэ аба самас катэ англунымастар тэ кинас хабэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Алом кана ащядилам ратяко, амэ путэрдам амарэ гонэ, ай сако анда амэндэ аракхлас котэ пэско руп — ворта кати сас. Амэ андам кадо руп амэнца палпалэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Ай амэ андам инкэ руп тэ кинас хабэ. Амэ чи жянас, кон щютас палпалэ амаро руп андэ гонэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Вов пхэндас пэ кадо: — Са миштой, на даран. Мэ лэм о руп, саво тумэ андан. Алом тумарэ дадэско ай ви тумаро Дэл дас тумэнгэ кадо руп андэ тумарэ гонэ. Котар вов андас лэндэ Симеонос. ");
INSERT INTO rmylovari_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","О визэри андас лэ пралэн андо Ёсифоско кхэр, дас лэн паи тэ тховэн лэ пунрэ ай дас хабэ лэнгэ самарэнгэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Вон гэтосардэ Ёсифоскэ подарки, кана вов авла по допаш о дес, анда кадо кэ лэнгэ пхэндэ, кэ вон хана котэ кхэтанэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Кана Ёсиф авилас кхэрэ, вон андэ лэскэ подарки ай бандилэ лэскэ жи кай пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Вов пущлас па лэнго састипэ ай котар пхэндас: — Ай сар тумаро пхуро дад, па саво тумэ пхэннас мангэ? Жювиндой инкэ? ");
INSERT INTO rmylovari_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Вон пхэндэ: — Тиро слуга, амаро дад, инкэ траимэ ай састо. Ай бандилэ англа лэстэ тэ сыкавэн пэнги патив. ");
INSERT INTO rmylovari_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Вов дыкхлас круял пэстэ ай лас сама пэскэ пралэс Вениаминос, лэска дакэ щявэс, ай пущлас: — Кадой — тумаро май цыно прал, па кастэ тумэ пхэннас мангэ? — ай щютас пашэ: — О Дэл тэ авэл милошо каринг тутэ, муро щяво! ");
INSERT INTO rmylovari_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Ёсифоско ило нас по тхан, кана вов дыкхлас пэскэ пралэс, ай вов щидярдас тэ жялтар андо тхан, кай нас мануш. Вов дас андрэ андэ пэски соба ай рутас. ");
INSERT INTO rmylovari_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Котар вов тходас пэско муй, дас аври кай лэ мануш, инкэрдилас тэ на ровэл ай пхэндас: — Анэн о хабэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Лэскэ дынэ хабэ ригатэ, лэ пралэнгэ ригатэ, ай ви египтянура, савэ ханас лэса, ви вон ханас ригатэ, анда кадо кэ вон наштык ханас кхэтанэ лэ евреёнца, кадо лэнгэ сас граца. ");
INSERT INTO rmylovari_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Прала бэшнас англа лэстэ, сар илыяс-пэ па лэнгэ бэрш, катар о май пхуро жи кай май тэрно. Вон дыкхэнас екх пэ екхэстэ ай муцынас-пэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Лэнгэ дэнас хабэ па мисаля лэ Ёсифоски, ай Вениаминоски партя сас панжьвар май бари, сар лэндэ. Вон ханас ай пэнас лэса, ай лошанас. ");
INSERT INTO rmylovari_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Ёсиф дас аври кай пэско визэри: — Пэрдяр гонэ кадалэ муршэнгэ хабэса, кати бирина тэ ингрэн, ай щюв руп саконэскэ палпалэ андо гоно. ");
INSERT INTO rmylovari_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Котар щюв мури рупуны чеса андо гоно лэ май цынэскэ куса лэско руп, кай андас пала див. Ай кодо кэрдас, сар пхэндас Ёсиф. ");
INSERT INTO rmylovari_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Сар фэри десайлас, пралэн бищядэ андо дром пэскэ самарэнца. ");
INSERT INTO rmylovari_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Вон сас инкэ надур катар о форо, кана Ёсиф пхэндас кай пэско визэри: — Сыго традэ пала кодал мануш, ай кана арэсэса лэн, пхэн лэнгэ: «Состар тумэ потиндан чёримаса анда лащипэ? ");
INSERT INTO rmylovari_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Чяк кады мурэ раски чеса, анда сави вов пэл ай саваса драбарэл! Тумэ кэрдан насул бути!» ");
INSERT INTO rmylovari_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Кана арэслас лэн, вов пхэндас лэнгэ кадал ворби. ");
INSERT INTO rmylovari_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Алом вон пхэндэ пэ кадо: — Состар о рай пхэнэл касавэ ворби? Тирэ слуги шоға чи кэрна касаво чёрипэ! ");
INSERT INTO rmylovari_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Чяк амэ андам тумэнгэ анда пхув Ханаан палпалэ кодо руп, саво аракхлам андэ амарэ гонэ. Атунчи состар амэнгэ тэ чёрас руп вай сумнакай анда тирэ раско кхэр? ");
INSERT INTO rmylovari_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Тэ аракхадёла кадо кай екх анда тирэ слуги, мэк вов мэрэл, ай лэ кавэр кэрдёна тирэ раскэ рабура. ");
INSERT INTO rmylovari_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","— Миштой, — пхэндас кодо, — мэк тэ авэл, сар тумэ пхэнэн: кастэ аракхадёла чеса, кодо кэрдёла муро рабо, ай лэ кавэр авна надошалэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Лэ прал сыго мэклэ тэлэ пэ пхув пэскэ гонэ ай путэрдэ лэн. ");
INSERT INTO rmylovari_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","О визэри лас тэ родэл, катар о май пхуро жи кай о май тэрно. Ай э чеса аракхадилас андо гоно кай Вениамин. ");
INSERT INTO rmylovari_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Атунчи вон щиндэ пэ пэстэ гада, ракисардэ пхаримата пэ самары ай болдынэ-пэ палпалэ андо форо. ");
INSERT INTO rmylovari_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Ёсиф сас инкэ кхэрэ, кана Иуда ай лэскэ прал дынэ андо кхэр ай пэлэ англа лэс пэ пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Ёсиф пхэндас лэнгэ: — Со тумэ кэрдан? Со, тумэ чи жянэн, кэ касаво мануш, сар мэ, са жянла пэрдал драбарипэ? ");
INSERT INTO rmylovari_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","— Со амэ шай пхэнас тукэ, рая? — пхэндас о Иуда. — Со тэ пхэнас сэмбэ кадалэскэ? Сар тэ сыкавас, кэ чи сам дошалэ? О Дэл путэрдас э дош тирэ слугэнги. Аканак амэ сам амарэ раскэ рабура — амэ ай ви кодо, кастэ аракхадилас чеса. ");
INSERT INTO rmylovari_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Алом Ёсиф пхэндас: — Мэ чи на чи гиндый тэ кэрав кадо! Фэри кодо, кастэ аракхадилас э чеса, авла муро рабо. Ай тумэ болдэн-тумэ пачяса кай тумаро дад. ");
INSERT INTO rmylovari_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Атунчи Иуда пашылас лэстэ ай пхэндас: — Мангав тут, муро рай, дэ тирэ слугакэ тэ пхэнэл ворба. Ту сан, сар о фараоно, алом на холяйви по тиро слуга. ");
INSERT INTO rmylovari_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Муро рай пущлас пэскэ слугэн: «Сы тумэндэ дад вай прал?» ");
INSERT INTO rmylovari_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ай амэ пхэндам: «Амэндэ сы андэ бэрш дад, ай андо пхурипэ лэстэ аракхадилас щяво. Лэско прал мулас, ай вов ащилас екхоро анда щявэ кай пэски дэй, ай лэско дад камэл лэс». ");
INSERT INTO rmylovari_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Атунчи ту пхэндан тирэ слугэнгэ: «Анэн лэс мандэ тэ дыкхав пэ лэстэ коркоро». ");
INSERT INTO rmylovari_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ай амэ пхэндам амарэ раскэ: «О щяворо наштык ащявэл пэскэ дадэс, ай тэ ащявла, лэско дад мэрла». ");
INSERT INTO rmylovari_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Алом ту пхэндан тирэ слугэнгэ: «Тэ на авла тумэнца тумаро май цыно прал, на сыкадён мангэ пэ якха». ");
INSERT INTO rmylovari_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Кана болдам-амэ кай амаро дад, амэ панаскодысардам лэскэ, со пхэндас амаро рай. ");
INSERT INTO rmylovari_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Амаро дад пхэндас: «Болдэн-тумэ палпалэ ай кинэн инкэ эк-цэра хабэ». ");
INSERT INTO rmylovari_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Алом амэ пхэндам пэ кадо: «Амэ наштык жяс. Фэри шай жяс тэ авла амэнца о май цыно прал. Амэ наштык сыкадювас пэ якха кодолэ манушэскэ, тэ на авла амэнца амаро май цыно прал». ");
INSERT INTO rmylovari_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Тиро слуга, муро дад, пхэндас амэнгэ: «Тумэ коркорэ жянэн, кэ мури ромни кэрдас мангэ дуе щявэн. ");
INSERT INTO rmylovari_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Екх лэндар гэластар мандар, ай мэ пхэндэм: \"Вов сас щингэрдо пэ котора\". Ай катар коды врама мэ чи дыкхлэм лэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Тэ лэна мандар ви кавэрэс, ай маладёла лэса чёрипэ, бригатар мэ жётар андэ мулэнги лума». ");
INSERT INTO rmylovari_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Анда кодо, тэ на авла о щяворо амэнца, кана аваса палпалэ кай амаро дад, ай муро дад, каско траё сы пхангло щяворэскэ траёса, ");
INSERT INTO rmylovari_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","дыкхла, кэ о щяворо най амэнца, вов мэрла. Анда амэндэ муро дад бригатар жялатар андэ мулэнги лума. ");
INSERT INTO rmylovari_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Тиро слуга дас ворба лэ дадэскэ, кэ лышыя тэ на кэрдёла щяворэса чёрипэ. Мэ пхэндэм: «Тэ на ано лэс тукэ, кады дош англа тутэ, дадэ, авла пэ мандэ са о траё». ");
INSERT INTO rmylovari_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Ай аканак мангав, дэ тирэ слугакэ тэ ащяв катэ сар муро раско рабо мэштык щяворо, ай мэк лэ щяворэс тэ жял пэскэ пралэнца. ");
INSERT INTO rmylovari_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Сар шай болдав-ма палпалэ кай муро дад, тэ на авла манца о щяворо? Тэ на дыкхав мурэ дадэски брига. ");
INSERT INTO rmylovari_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Атунчи Ёсиф наштык май бут рыбдыяс тэ на путэрдёл пэскэ пралэнгэ англа пэскэ ажутора ай цыписардас: — Жянтар саворэ мандар! Кхоник нас лэ Ёсифоса, кана вов путэрдилас пэскэ пралэнгэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Вов рутас кадэ зуралэс, кэ шундэ лэс египтянура. Ай ви фараоноско челэдо шундас па кадо. ");
INSERT INTO rmylovari_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Ёсиф пхэндас пэскэ пралэнгэ: — Мэ сым Ёсиф! Жювиндой инкэ муро дад? Лэ прал наштык ворбинас, кэ са муцысайлэ ай лас-пэ лэнги щиб даратар англа лэстэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Атунчи Ёсиф пхэндас лэ пралэнгэ: — Пашон мандэ. Ай кана вон пашылэ, вов пхэндас: — Мэ сым тумаро прал Ёсиф, савэс тумэ бикиндан андо Египет! ");
INSERT INTO rmylovari_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Алом на даран ай пэс на дошарэн анда кодо, кэ бикиндан ман катэ. Кадо о Дэл бищядас ма май англал тумэндар тэ фирий тумаро траё. ");
INSERT INTO rmylovari_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Аба дуй бэрш, сар сы бокх андо тхэм, ай инкэ панжь бэрш кхоник чи сантыя пхув ай чи кидэла див. ");
INSERT INTO rmylovari_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Алом о Дэл бищядас ман англа тумэндэ тэ фирий тумаро траё ай тумари вица пэ пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","На тумэ бищядан ман катэ, алом о Дэл. Вов кэрдас ман тэ авав, сар дад фараоноскэ, тэ визэрий са лэско диз ай ви са Египет. ");
INSERT INTO rmylovari_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Аканак щидярэн тэ болдэн-тумэ палпалэ кай муро дад ай тэ пхэнэн лэскэ: «Акэ со пхэнэл тиро щяво Ёсиф: \"О Дэл кэрдас ман тэ визэрий са о Египет. Ав мандэ, на цырдэ врама. ");
INSERT INTO rmylovari_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ту траиса пэ пхув Гошэн ай авэса пашэ мандэ: ту, тирэ щявора ай цынэ-щявора, ай ви тирэ кырдура ай са, со тутэ сы. ");
INSERT INTO rmylovari_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Котэ шай лышый пала тутэ, тэ на пэрэн андо чёрипэ ту, тиро челэдо ай са, кон сы туса, кэ инкэ авна панжь бэрш бокх\"». ");
INSERT INTO rmylovari_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Тумэ шай дыкхэн тумарэ якхэнца, тумэ ай ви муро прал Вениамин, кэ кадо мэ чячес ворбий тумэнца. ");
INSERT INTO rmylovari_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Панаскодын мурэ дадэскэ па кодо, сар сым ғирэшардо андо Египет, ай па са, со тумэ дыкхлан. Ай анэн катэ мурэ дадэс май сыго. ");
INSERT INTO rmylovari_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Вов лас андэ ангаля пэскэ пралэс Вениаминос, ай вон рутэ екх пэ екхэстэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Вов чюмидас са пэскэ пралэн ай лас андэ ангаля роимаса. Котар лэ прала ворбинас лэса. ");
INSERT INTO rmylovari_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Кана ғира па кодо, кэ авилэ лэ прал Ёсифоскэ, арэслас жи кай фараоноски диз, фараоно ай ви лэскэ ажутора лошайлэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Фараоно пхэндас Ёсифоскэ: — Пхэн тирэ пралэнгэ: «Кэрэн кадэ: ракин пхаримата пэ тумарэ алатура, болдэн-тумэ андо Ханаан ");
INSERT INTO rmylovari_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","ай анэн мандэ тумарэ дадэс ай ви тумарэ челэдура. Мэ до тумэ май лащи пхув андо Египет, ай тумэ траина пхувакэ барвалимаса». ");
INSERT INTO rmylovari_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Инкэ до тукэ аври тэ пхэнэс лэнгэ: «Кэрэн кадэ: лэн анда Египет вурдона тумарэ щяворэнгэ ай ромнянгэ, лэн тумарэ дадэс ай авэн катэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","На бунун па тумаро ащядо миштыпэ, кэ са, со сы май лащё андо Египет, авла тумаро». ");
INSERT INTO rmylovari_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ай лэ щявэ Израилёскэ кадэ ви кэрдэ. Ёсиф дас лэн вурдона, сар дас аври о фараоно, ай ви хабэ андо дром. ");
INSERT INTO rmylovari_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Саконэскэ вов дас нэвэ гада, ай Вениаминоскэ дас трин шэла рупунэ шэкели ай панжь ураимата. ");
INSERT INTO rmylovari_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Пэскэ дадэскэ вов бищядас дэшэ самарэн май лаще миштымаса, кай сас андо Египет, ай дэшэ самарэн, пэ кастэ сас ракисардэ див, манро ай кавэр хабэната андо дром каринг о Египет. ");
INSERT INTO rmylovari_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Пала кадо вов бищядас лэ пралэн андо дром, ай кана жянастар, пхэндас лэнгэ: — На хан-пэ тумэ андо дром! ");
INSERT INTO rmylovari_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Вон традэтар анда Египет ай авилэ кай пэско дад Яков пэ пхув Ханаан. ");
INSERT INTO rmylovari_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Вон пхэндэ лэскэ: — Ёсиф жювиндой! Вов сы визэри пэ са Египет! Кай о Яков морцосайлас о ило, ай вов чи патяяс лэнгэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Алом кана вов шундас, со пхэндас о Ёсиф, ай кана дыкхлас э вурдона, савэ Ёсиф бищядас тэ ингрэн лэс, о ди Яковоско жювиндысайлас. ");
INSERT INTO rmylovari_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Ай Израиль пхэндас: — Достай! Муро щяво Ёсиф траимэй. Жяв ай дыкхав лэс, англа кадо, сар тэ мэрав. ");
INSERT INTO rmylovari_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Ай Израиль традастар са пэскэ миштымаса. Кана вов арэслас жи кай Бээр-Шэва, вов дас жэртва лэ Дэвлэскэ, каскэ рудияс лэско дад Исаак. ");
INSERT INTO rmylovari_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ай о Дэл сыкадилас Израилёскэ рати ай пхэндас лэскэ: — Яков! Яков! — Катэ сым, — пхэндас кодо палпалэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","— Мэ сым Дэл, тирэ дадэско Дэл, — пхэндас Вов. — На дара тэ жяс андо Египет, кэ Мэ котэ сармозыя тутар бари нацыя. ");
INSERT INTO rmylovari_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Мэ жё туса андо Египет ай ано тут палпалэ. Ай Ёсифоско васт пхандэла тирэ якха. ");
INSERT INTO rmylovari_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Атунчи Яков мэклас Бээр-Шэва. Израилёскэ щявэ бэшадэ лэнгэ дадэс, щяворэн ай ромнян андэ вурдона, кай о фараоно бищядас тэ анэн лэн. ");
INSERT INTO rmylovari_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Вон лынэ пэса пэнгэ алатон ай са миштыпэ, кай вон кидэ андо Ханаан. Ай о Яков куса са лэскэ парапутя авилэ андо Египет. ");
INSERT INTO rmylovari_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Вов лас пэса пэскэ щявэн ай цынэ-щяворэн, пэскэ щеян ай внучкэн — са пэскэ парапутён. ");
INSERT INTO rmylovari_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Акэ анава лэ Израилёскэ щявэнгэ, Яковоскэ парапутя, савэ авилэ андо Египет: Рувим, Яковоско англуно щяво. ");
INSERT INTO rmylovari_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Рувимоскэ щявэ: Ханох, Паллу, Хецрон ай Карми. ");
INSERT INTO rmylovari_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Симеоноскэ щявэ: Емуэл, Ямин, Охад, Яхин, Цохар ай Саул, щяво катар ханаанско жювли. ");
INSERT INTO rmylovari_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Левиескэ щявэ: Гершон, Кехат ай Мерарий. ");
INSERT INTO rmylovari_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Иудаскэ щявэ: Эр, Онан, Шэла, Парец ай Зерах (алом Эр ай Онан мулэ андо Ханаан). Парецоскэ щявэ: Хецрон ай Хамул. ");
INSERT INTO rmylovari_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Иссахароскэ щявэ: Тола, Пува, Иов ай Шымрон. ");
INSERT INTO rmylovari_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Завулоноскэ щявэ: Серед, Элон ай Яхлеэл. ");
INSERT INTO rmylovari_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Кадал сас Лиякэ щявэ, кас вой кэрдас Яковоскэ андо Паддан-Арам. Ай инкэ латэ аракхадилас щей Дина. Са кодал парапутя сас транда ай трин-женэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Гадоскэ щявэ: Цыфион, Хаггий, Шуний, Эцбон, Эрий, Ародий ай Арелий. ");
INSERT INTO rmylovari_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Асироскэ щявэ: Имна, Ишва, Ишвий ай Бериа. Ай лэнги пхэн Серах. Бериаскэ щявэ: Хевер ай Малкиэл. ");
INSERT INTO rmylovari_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Кадал сас лэ щявора, кас кэрдас Яковоскэ Зэлфа, сава Лаван дас пэска щякэ Лиякэ. Вон са сас дэшушов-женэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Яковоскэ ромнякэ Рахилякэ щявэ: Ёсиф ай Вениамин. ");
INSERT INTO rmylovari_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Андо Египет кай Ёсиф сас ромни Аснат, щей лэ рашаски Поти-Пераски анда форо Он. Вой кэрдас Ёсифоскэ щявэн Манассияс ай Ефремос. ");
INSERT INTO rmylovari_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Вениаминоскэ щявэ: Бела, Бехер, Ашбэл, Гера, Нааман, Эхий, Рош, Муппим, Хуппим ай Ард. ");
INSERT INTO rmylovari_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Кадал сас Рахилякэ щявэ, кас вой кэрдас Яковоскэ. Вон са сас дэшуштар-женэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Даноско щяво: Хушым. ");
INSERT INTO rmylovari_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Неффалимоскэ щявэ: Яхцеэл, Гуний, Ецэр ай Шыллем. ");
INSERT INTO rmylovari_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Кадал сас щявэ, кас кэрдас Яковоскэ Валла, сава Лаван дас пэска щякэ Рахилякэ. Вон сас эфта-женэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Саворэ, кон авилэ андо Египет лэ Яковоса, кон сас лэскэ ворта парапутя би лэскэ боранго, сас шовардэш тай шов-женэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Инкэ сас дуй Ёсифоскэ щявэ, савэ аракхадилэ лэстэ андо Египет. Яковоско челэдо андо Египет са кхэтанэ сас эфтавардэш-женэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Яков бищядас англа пэс Иудас тэ жянэл аври о дром каринг Гошэн. Кана арэслэ котэ, ");
INSERT INTO rmylovari_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Ёсиф астардас грастэн андо гинтово ай традас андо Гошэн каринг пэско дад Израиль. Кана вон дыкхлэ-пэ, вов лас лэс андэ ангаля ай бут рутас. ");
INSERT INTO rmylovari_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Израиль пхэндас Ёсифоскэ: — Аканак сым гата тэ мэрав, анда кадо кэ дыкхлэм мурэ якхэнца, кэ сан траимэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Ёсиф пхэндас пэскэ пралэнгэ ай дадэскэ челэдоскэ: — Мэ жяв кай о фараоно ай пхэнав лэскэ: «Мурэ прал ай мурэ дадэско челэдо, кай траинас пэ пхув Ханаан, авилэ мандэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Кадал мануш — чябаша; вон барарэн алатон ай андэ пэса лэнгэ кырдура ай са лэнго миштыпэ». ");
INSERT INTO rmylovari_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Кана о фараоно акхарла тумэн ай пущла: «Соса лэн-тумэ?» — ");
INSERT INTO rmylovari_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","тумэ трубуй тэ пхэнэн: «Тирэ слуги дэ цынара барарэн алатон, сар кэрнас ви амарэ дада». Атунчи авла тумэнгэ слободо тэ траин пэ пхув Гошэн, анда кодо кэ египтянура грацон-пэ катар э чябаша. ");
INSERT INTO rmylovari_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Ёсиф гэлас кай о фараоно ай пхэндас лэскэ: — Муро дад ай мурэ прал пэскэ кырдонца ай са пэскэ миштымаса авилэ катар э пхув Ханаан ай аканак инкэрдён андо Гошэн. ");
INSERT INTO rmylovari_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Вов алосардас панжен анда прал ай пинжярадас фараонос лэнца. ");
INSERT INTO rmylovari_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Фараоно пущлас лэ пралэн: — Соса лэн-тумэ? Вон пхэндэ фараоноскэ: — Тирэ слуги — чябаша, сар сас ви амарэ дада. — ");
INSERT INTO rmylovari_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ай щютэ пашэ: — Амэ авилам катэ тэ траисарас вари-кати врама анда насул бокх пэ пхув Ханаан, ай кэ най кай тэ хахавас лэ кырдура. Мэк тирэ слугон тэ траисарас андо Гошэн. ");
INSERT INTO rmylovari_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Фараоно пхэндас лэ Ёсифоскэ: — Тиро дад ай тирэ прал авилэ тутэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Э пхув Египтоски сы англа тутэ; щюв тё дадэс ай те пралэн тэ траин по май лащё тхан пэ кады пхув. Мэк траин андо Гошэн. Ай тэ жянэс лаще алатонгэ лышыторэн машкар лэндэ, щюв лэн тэ лышын пала мурэ алатура. ");
INSERT INTO rmylovari_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Котар Ёсиф андас пэскэ дадэс Яковос англа фараоно. Яков бахтярдас фараонос, ");
INSERT INTO rmylovari_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","ай кодо пущлас лэстар: — Кати тукэ бэрш? ");
INSERT INTO rmylovari_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","О Яков пхэндас фараоноскэ: — Мэ траий екх шэл тай транда бэрш. Скуртэ ай кэркэ сас мурэ дес, на касавэ, сар сас кай амарэ дада. ");
INSERT INTO rmylovari_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Яков алдысардас фараонос ай мэклас лэски диз. ");
INSERT INTO rmylovari_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Кадэ Ёсиф щютас пэскэ дадэс ай пралэн тэ траин андо Египет ай дас лэнгэ май лащи пхув андо тхан Раамсес, сар дас аври о фараоно. ");
INSERT INTO rmylovari_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Ай Ёсиф пхэрдас хабнаса лэ дадэс, лэ пралэн ай ви са дадэски вица, кати сас мануш андо сако челэдо. ");
INSERT INTO rmylovari_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Пэ са э пхув нас хабэ анда насул бокх. Лэ мануш андэ Египет ай Ханаан сас бизоракэ бокхатар. ");
INSERT INTO rmylovari_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Ёсиф кидас са о руп, кай сас андо Египет ай Ханаан, кэ лэ мануш потиннас пала див, кай вон киннас лэстар. Вов андас кадо руп андэ фараоноски диз. ");
INSERT INTO rmylovari_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Кана са о руп начилас кай э мануш ви андо Египет ай ви андо Ханаан, са лэ египтянура авилэ кай Ёсиф ай пхэндэ: — Дэ амэн хабэ, вай амэ мэраса англа тирэ якха. Амаро руп начилас. ");
INSERT INTO rmylovari_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","— Атунчи анэн тумарэ алатон, — пхэндас Ёсиф. — Мэ паруво тумэнгэ хабэ пэ алатура, тэ начилас тумэндэ руп. ");
INSERT INTO rmylovari_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Атунчи вон андэ Ёсифоскэ алатон, ай вов лас тэ парувэл лэнгэ хабэ пэ грас, бакрэ, бусня, лэнгэ гурувня ай самары. Ай са кодо бэрш вов парувлас лэнгэ хабэ пэ алатура. ");
INSERT INTO rmylovari_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Кана начилас кодо бэрш, пэ кавэр бэрш вон авилэ лэстэ ай пхэндэ: — Амэ наштык гаравас катар амаро рай, кэ амаро руп начилас, ай ви амарэ алатура ащилэ тукэ. Ай аканак амэндэ най канчи тэ дас амарэ раскэ, фэри амэн ай амари пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Ива хасайвас англа тирэ якха, амэ ви амари пхув. Кин амэн ай амари пхув пала хабэ, ай амэ аваса фараоноскэ рабура куса амари пхув. Дэ амэнгэ сэмно тэ шай траисарас ай тэ на мэрас ай ви э пхув тэ на авэл щющи. ");
INSERT INTO rmylovari_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Кадэ Ёсиф киндас аври лэ фараоноскэ са э пхув андо Египет. Са лэ египтянура бикиндэ пэскэ маля, кэ э бокх сас зуралэс насул. Э пхув кэрдилас фараоноски, ");
INSERT INTO rmylovari_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","ай Ёсиф кэрдас анда мануш рабура, катар екх агор жи кай о кавэр андо Египет. ");
INSERT INTO rmylovari_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Алом вов чи киндас э пхув, сави фараоно дас лэ рашангэ, кэ лэндэ доста сас хабэ катар лэнги пхув. Акэ анда состэ вон чи бикиндэ пэски пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Ёсиф пхэндас манушэнгэ: — Аканак, кана мэ киндэм тумэн ай тумарэ пхува лэ фараоноскэ, акэ тумэнгэ сэмнура тэ сэмнон э пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Алом кана барола о див, дэна панжьто партя лэ фараоноскэ. Э кавэр штар парти ащна тумэнгэ тэ барарэн сэмно пэ маля ай тэ хан тумэ, тумарэ челэдура ай щявора. ");
INSERT INTO rmylovari_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","— Ту фирисардан амаро траё, — пхэндэ вон. — Тэ аракхас милошаго андэ амарэ раскэ якха. Амэ аваса рабура фараоноскэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Атунчи Ёсиф дас аври законо па пхув андо Египет, саво сас андэ зор бут врама. Сар сас андо законо, екх панжьто партя катар са, со дэл э пхув, пэрэл лэ фараоноскэ. Фэри э рашанги пхув чи кэрдилас фараоноски. ");
INSERT INTO rmylovari_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Атунчи израильтянура лынэ тэ траин андо Египет, пэ пхув Гошэн. Лэндэ сас котэ кхэра, ай аракхадёнас бут щявора, ай вон кэрдёнас са май бут. ");
INSERT INTO rmylovari_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Андо Египет Яков траисардас дэшэфта бэрш, ай кадэ по са вов траисардас екх шэл штарвардэш тай эфта бэрш. ");
INSERT INTO rmylovari_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Кана авилас Израилёски врама тэ мэрэл, вов акхардас пэскэ щявэс Ёсифос ай пхэндас лэскэ: — Тэ аракхлэм милошаго андэ тирэ якха, щюв о васт тэла мури пулпа ай дэ ма ворба, кэ сыкавэса лащипэ ай патив каринг мандэ. На прахосар ман андо Египет, ");
INSERT INTO rmylovari_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","алом кана жётар кай мурэ дада, ингэр ман анда Египет ай прахосар ман андэ мурэ мулэ нямонги крипта. — Мэ кэро кадэ, сар ту мангэс, — пхэндас Ёсиф. ");
INSERT INTO rmylovari_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","— Цолахар, — манглас Яков. Ёсиф цолахардас лэскэ, ай о Израиль мэклас о шэро по шэранд. ");
INSERT INTO rmylovari_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Па вари-кати врама Ёсифоскэ пхэндэ: — Тиро дад насвало. Ай вов лас пэса дуе щявэн: Манассияс ай Ефремос. ");
INSERT INTO rmylovari_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Кана Яковоскэ пхэндэ: — Тутэ авилас тиро щяво Ёсиф. Израиль кидас са пэски зор ай бэшлас по пэско тхан. ");
INSERT INTO rmylovari_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Яков пхэндас Ёсифоскэ: — О Дэл Са-Биримаско сыкадилас мангэ андо Луз, пэ пхув Ханаан, бахтярдас ман ");
INSERT INTO rmylovari_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","ай пхэндас: «Мэ кэро тэ авэн тут бут щявора ай тэ авэн тумэн бут. Мэ кэро тэ жян тутар бут нацыи ай до кады пхув пэ са врама тирэ парапутёнгэ». ");
INSERT INTO rmylovari_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Катар кады врама дуй тирэ щявэ, савэ аракхадилэ андо Египет, кана инкэ чи авилам катэ тутэ, гинадёна мурэ. Ефрем ай Манассия авна мурэ, сар сы мурэ Рувим ай Симеон. ");
INSERT INTO rmylovari_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ай са лэ щявора, савэ аракхадёна тутэ пала лэндэ, авна тирэ, ай лэнгэ ащла пхув катар пэскэ пралэнги партя. ");
INSERT INTO rmylovari_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Кана болдос-ма анда Паддан, Рахиль, пэ мури брига, мулас андо Ханаан, кана самас инкэ андо дром, надур катар о Эфрата. Анда кодо мэ прахосардэм ла котэ, паша дром каринг Эфрата (Вифлеем). ");
INSERT INTO rmylovari_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Кана Израиль дыкхлас лэ Ёсифоскэ щявэн, вов пущлас: — Кон кадал? ");
INSERT INTO rmylovari_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","— Кадал сы щявэ, савэн о Дэл дас ман катэ, — пхэндас Ёсиф лэ дадэскэ. — Пашар лэн мандэ, — пхэндас о Израиль, — мэ тэ алдый лэн. ");
INSERT INTO rmylovari_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Израиль анда пхурипэ лас чёрэс тэ дыкхэл, вов аба сас тэ корайвэл. Ёсиф пашардас каринг о дад пэскэ щявэн, ай кодо чюмидас лэн ай лас андэ ангаля. ");
INSERT INTO rmylovari_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Израиль пхэндас Ёсифоскэ: — Мэ чи на чи гиндыяс тэ дыкхав тут, ай аканак о Дэл дас ман тэ дыкхав ви тирэ щяворэн. ");
INSERT INTO rmylovari_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Ёсиф дурардас лэ щяворэн катар чянга Израилёскэ ай бандилас лэскэ жи кай пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Котар Ёсиф щютас Ефремос, саво сас пэ чячи риг лэстар, каринг стунго Израилёско васт. Ай Манассияс, саво сас пэ стунго риг лэстар, каринг чячё Израилёско васт. Ай пашардас солдон каринг пэско дад. ");
INSERT INTO rmylovari_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Алом Израиль лунжярдас чячё васт ай щютас лэс по шэро лэ Ефремоско, ива вов сас май тэрно, ай стунго васт вов щютас по шэро лэ Манассияско, ива кэ Манассия сас англуно. ");
INSERT INTO rmylovari_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Котар вов бахтярдас Ёсифос ай пхэндас: — О Дэл, англа Каскэ якха пхирнас дада мурэ Авраам ай Исаак, О Дэл, Саво сас муро чябашы са муро траё жи кай адесутно дес, ");
INSERT INTO rmylovari_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Ангело, Саво фирияс ман катар сако насулыпэ, мэк тэ бахтярэл кадалэ щяворэн! Мэк ащел андэ лэндэ муро анав ай анава мурэ дадэнгэ Авраамоскэ ай Исаакоскэ. Ай мэк лэндэ авна бут парапутя пэ са пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Кана Ёсиф дыкхлас, кэ о дад щютас о чячё васт по Ефремоско шэро, лэскэ кадо чи чялилас, ай вов лас дадэско чячё васт тэ щёл лэс по Манассияско шэро. ");
INSERT INTO rmylovari_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Ёсиф пхэндас лэскэ: — На, дадэ, кадой — о англуно, щюв тё чячё васт по лэско шэро. ");
INSERT INTO rmylovari_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Алом лэско дад чи камлас ай пхэндас: — Жянав, муро щяво, жянав. Ви лэстар жяла нацыя, ви вов авла ғирэшо. Алом лэско май цыно прал авла май баро лэстар, ай катар лэскэ парапутя жяна бут нацыи. ");
INSERT INTO rmylovari_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Ай вов бахтярдас лэн андо кодо дес ай пхэндас: — Тумарэ анава лэла тэ сэрэл Израиль сар бахтярипэ, ворбаса: «Тэ кэрэл тут о Дэл тэ авэс сар Ефрем ай Манассия». Кадэ вов щютас Ефремос англа Манассия. ");
INSERT INTO rmylovari_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Котар Израиль пхэндас Ёсифоскэ: — Мэ мэрав, алом о Дэл авла тумэнца ай болдэла тумэн палпалэ пэ тумарэ дадэнги пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Мэ дав тукэ, сар май барэскэ машкар лэ прал, инкэ екх котор пхув уче харэнца, кай мэ нирисардэм мурэ ханрэса ай лукоса катар э аморы. ");
INSERT INTO rmylovari_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Атунчи Яков акхардас пэскэ щявэн ай пхэндас: — Кидэн-тумэ круял, ай мэ панаскодыя, со авла тумэнца май дур. ");
INSERT INTO rmylovari_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Кидэн-тумэ ай шунэн, Яковоскэ щявэ, шунэн тумарэ дадэс лэ Израилёс. ");
INSERT INTO rmylovari_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Рувим, ту сан муро англуно щяво, кай кэрдилан катар мури муршаны зор, англуно андэ патив, англуно андэ зор. ");
INSERT INTO rmylovari_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ту парудёс, сар о паи, ай май бут ту чи авэса англуно, анда кадо кэ щютан-ту андо тирэ дадэско тхан ай щюдан андэ чик мури патив. ");
INSERT INTO rmylovari_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Симеон ай Левий сы прал, лэнгэ ханрэ ингрэн насул зор. ");
INSERT INTO rmylovari_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Тэ на авав пайташы андэ лэнгэ бутя, тэ на дав андрэ андо лэнго кидыпэ. Вон мударнас муршэн андэ пэски холи, ай щиннас э вуны лэ гурувэнгэ, сар камнас. ");
INSERT INTO rmylovari_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Дав армая лэнги турбато холи, лэнго насул мирғошаго! Мэ риспия лэн машкар лэ Яковоскэ парапутя ай машкар лэ Израилёскэ щявэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Иуда, тирэ прал ғирэшона тиро анав! Васт тиро авла пэ кор тирэ душманонги, щявэ тирэ дадэскэ лэна тэ бандён англа тутэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ту сан тэрноро арслано, Иуда; болдэс-ту палпалэ па астарипэ, муро щяво. Сар арслано, вов гэтой-пэ тэ хутел, сар арсланица, пашлёл пэ пхув, — кон тромая тэ шэртый лэс? ");
INSERT INTO rmylovari_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Иуда миндык авла край, ай лэскэ парапутя акар-кана инкэрна краески ровли. Жипон чи авла Шыло, Каско сы о краипэ, Каскэ лэ нацыи бандярна шэрэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Вов пхандэла пэска самара кай дракхаки раик, пэска цына самара — кай май лащи кранжя. Вов тховла пэскэ гада андэ мол, пэскэ ураимата — андо моляко рат. ");
INSERT INTO rmylovari_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Лэскэ якха авна май мэлахнэ, сар э мол, ай лэскэ данд — май парнэ, сар о тхуд. ");
INSERT INTO rmylovari_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Завулон авла тэ траий паша море ай авла парто лэ бэронго; лэскэ пхува цырдэна-пэ жи кай Сидон. ");
INSERT INTO rmylovari_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Иссахар сы шуки самара, сави пашлёл машкар пэскэ дуй пхарэ гонэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Кана вов дыкхла, сар мишто по лэско ғодонымаско тхан ай соски лащи лэски пхув, вов бандярла пэскэ пхикэ тэла пхаримата ай мусай авла тэ кэрэл бути. ");
INSERT INTO rmylovari_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Дан авла крисынари кай пэскэ мануш, андэ екх машкар Израилёскэ вицы. ");
INSERT INTO rmylovari_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Вов авла сап пэ риг лэ дромэски, насул сап пэ кэрара, о сап, саво дындалэл грастэс пала пунрэ, кадэ кэ грастэско прастамари пэрэл пэ пхув. ");
INSERT INTO rmylovari_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","О Рай Яхва, тутар жутярав скипипэ! ");
INSERT INTO rmylovari_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","По Гад лэна тэ хутен лэ чёр, алом вов хутёла пэ лэндэ ай нашавла англа пэстэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Кай о Асир авла пхэрды мисаля хабэ; вов лэла тэ анэл изывна хабэната, савэ пасулын краескэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Неффалим сы еза, мэклы слободыякэ, сави кэрла шукарэ щяворэн. ");
INSERT INTO rmylovari_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Ёсиф сы кранжя, кай анэл бут дракха, пхэрдярды кранжя паша пирово, каскэ раика ваздэн-пэ па фало. ");
INSERT INTO rmylovari_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Лучники пушказынас андэ лэстэ, хутенас пэ лэстэ холяса. ");
INSERT INTO rmylovari_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Алом лэско луко са пушказыяс, лэскэ зуралэ васт чи ковлилэ, кэ лэски зор сы андо Иаковоско Зурало Дэл, андо Чябашэско анав, андэ Израилёски хар, ");
INSERT INTO rmylovari_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","андо тирэ дадэско Дэл, Саво жутый тут, андо Са-Биримаско Дэл, Саво бахтярэл тут. Вов дэла тукэ бахтярипэ опрал па чери, бахтярипэ тэлал катар э пхув, бахтярипэ катар колина лэ дангэ, кай дэн траё бутэ щяворэнгэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Бахтяримата тирэ дадэскэ сы май барэ, сар бахтяримата лэ пуранэ харэнгэ, сар э бахт, кай дэн пуранэ плая. Тэ авэн са лэ бахтяримата по шэро Ёсифоско, по чикат кай о край, кон сы машкар пэскэ прал. ");
INSERT INTO rmylovari_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Вениамин сы бокхало рув. Ёкор вов хал, со астардас, пэ рат улавэл, со нирисардас маримаса. ");
INSERT INTO rmylovari_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Акэ дэшудуй вицы Израилёскэ. Акэ со пхэндас лэнгэ о дад, кана бахтярлас лэн ай дэлас саконэскэ пэско бахтярипэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Котар Яков дас лэнгэ аври: — Мэ жявтар кай мурэ мулэ. Прахон ман паша мурэ дада андэ пещера паша хетоски Эфроноски мал, ");
INSERT INTO rmylovari_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","андэ пещера пэ мал Махпела, паша Мамрэ андо Ханаан, кай Авраам киндас куса мал сар прахомаско тхан кай о хет Эфрон. ");
INSERT INTO rmylovari_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Котэ сас прахомэ Авраам ай лэски ромни Сарра, Исаак ай лэски ромни Ревека, ай котэ прахосардэм Лия. ");
INSERT INTO rmylovari_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Э мал куса пещера сас киндэ кай э хеты. ");
INSERT INTO rmylovari_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Кана Яков дас гата пэски ворба каринг пэскэ щявэ, вов ваздас пэскэ пунрэ по тхан, цырдас о палуно пхаро ди ай гэластар кай пэскэ дада. ");
INSERT INTO rmylovari_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Ёсиф кикидас-пэ кай о дад, рутас ай чюмидас лэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Вов дас аври пэскэ састимарэнгэ тэ щён андо дад бальзамо, ай лэ састимара бальзамосардэ Израилёс. ");
INSERT INTO rmylovari_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Лэндэ гэлас пэ кадо штарвардэш дес, кэ кадо баё кэрэл-пэ кати. Египтянура ровнас па лэс эфтавардэш дес. ");
INSERT INTO rmylovari_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Кана начилэ роимаскэ дес, Ёсиф пхэндас лэ фараоноскэ ажуторэнгэ: — Тэ аракхлэм милошаго андэ тумарэ якха, мангэн анда мандэ фараонос ай пхэнэн лэскэ: ");
INSERT INTO rmylovari_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","«Муро дад лас мандар цолах ай пхэндас: \"Мэ сыго мэро; прахосар ман андэ крипта, сави мэ кэрадэм мангэ андо тхэм Ханаан\". Атунчи мэк ман тэ жяв тэ прахой мурэ дадэс. Пала кадо мэ болдо-ма палпалэ». ");
INSERT INTO rmylovari_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Фараоно пхэндас: — Жя ай прахосар тирэ дадэс, сар ту цолахардан лэскэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Ай Ёсиф гэлас тэ прахой пэскэ дадэс. Са лэ фараоноскэ ажутора гэлэ лэса — пашутнэ кай фараоно рай ай ви са лэ пативалэ мануш андо Египет, ");
INSERT INTO rmylovari_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","— вон са гэлэ куса Ёсифоско челэдо, лэскэ прал ай саворэнца анда лэскэ дадэско кхэр. Андо Гошэн ащилэ фэри лэнгэ щявора ай кырдура. ");
INSERT INTO rmylovari_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Лэнца традэтар до-ротэнгэ вурдона ай прастамара. Катэ сас баро сэпэто мануш. ");
INSERT INTO rmylovari_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Кана вон арэслэ тхан Атад, кай ужарэн о сэмно ай саво сы паша Ёрдан, вон зуралэс ровнас кэркэ асвэнца. Котэ Ёсиф эфта дес ровлас па дад. ");
INSERT INTO rmylovari_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Кана ханааны, кон траинас пэ коды пхув, дыкхлэ роипэ паша Атад, вон пхэндэ: — Кай египтянура сы брига ай барэ роимаскэ деса. Акэ состар кадо тхан паша Ёрдан бущёл Авэл-Мицраим. ");
INSERT INTO rmylovari_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Кадэ лэ Яковоскэ щявэ кэрдэ, со вов дас лэнгэ аври. ");
INSERT INTO rmylovari_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Вон ингэрдэ лэс пэ пхув Ханаан ай прахосардэ андэ пещера пэ мал Махпела, паша Мамрэ, кай Авраам киндас катар хет Эфрон сар прахомаско тхан. ");
INSERT INTO rmylovari_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Кана Ёсиф прахосардас лэ дадэс, вов болдас-пэ палпалэ андо Египет куса пэскэ прал ай саворэ, кон сас лэса тэ прахон дадэс. ");
INSERT INTO rmylovari_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Кана о Яков мулас, лэ Ёсифоскэ прал гиндысардэ: «Файма о Ёсиф инкрэл пэ амэндэ холи, ай аканак потинла амэнгэ пала са насулымата, со амэ кэрдам лэса». ");
INSERT INTO rmylovari_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ай вон бищядэ тэ пхэнэн Ёсифоскэ: — Англа мэрипэ амаро дад ащядас амэнгэ касави ворба: ");
INSERT INTO rmylovari_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","«Акэ со тумэ трубуй тэ пхэнэн Ёсифоскэ: \"Мэ мангав тут тэ лэс тэлэ па тирэ прал лэнги дош ай лэнгэ бэзэха, кай вон кэрдэ, кана кэрнас туса насулымата\". Ай аканак мангас, эртысар бэзэха тирэ дадэскэ Дэвлэскэ бутярэн». Кана кадо бищядыпэ арэслас кай Ёсиф, вов рутас. ");
INSERT INTO rmylovari_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Котар авилэ лэскэ прал, пэлэ англа лэс пэ пхув ай пхэндэ: — Амэ сам тирэ рабура. ");
INSERT INTO rmylovari_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Алом Ёсиф пхэндас пэ кадо: — На даран. Чяк мэ чи сым Дэл. ");
INSERT INTO rmylovari_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Тумэ камнас тэ кэрэн мангэ насулыпэ, алом о Дэл болдас кадо по лащипэ, тэ кэрдёл кодо, со сы аканак, тэ фирий мэ бут траюра. ");
INSERT INTO rmylovari_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Атунчи на даран, мэ ло сама пала тумэндэ ай тумарэ щяворэндэ. Ай вов чендэшысардас лэн ай ворбияс лэнца лащимаса. ");
INSERT INTO rmylovari_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Ёсиф траияс андо Египет куса пэскэ дадэско челэдо. Вов траисардас шэл тай дэш бэрш ");
INSERT INTO rmylovari_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","ай арэслас инкэ трито поколение лэ Ефремоскэ щяворэн, ай щявора лэ Махироскэ, кон сас о Манассияско щяво, ви вон сас щютэ пэ чянга кай о Ёсиф. ");
INSERT INTO rmylovari_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","О Ёсиф пхэндас пэскэ пралэнгэ: — Мэ сыго мэро. Алом о Дэл чи бистрэла тэ жутый тумэнгэ ай ингрэла тумэн анда кадо тхэм пэ пхув, сави вов щинадас армаенца Авраамоскэ, Исаакоскэ ай Яковоскэ. ");
INSERT INTO rmylovari_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Ёсиф щютас лэ Израилёскэ щявэн тэ цолахан ай пхэндас: — О Дэл чи бистрэла тэ жутый тумэнгэ, ай атунчи тумэ трубуна тэ ингрэн катар мурэ кокала. ");
INSERT INTO rmylovari_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Ёсиф мулас, кана сас лэскэ екх шэл тай дэш бэрш. Ай лэс бальзамосардэ ай щютэ андо копоршово андо Египет.");
INSERT INTO rmylovari_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Андэ дес, кана визэринас лэ вайды, андо тхэм кэрдилас бокх, ай екх мануш катар Вифлеем, андэ Иудея, традас тэ траий куса пэски ромни ай дуе щявэнца андо тхэм Моав. ");
INSERT INTO rmylovari_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Кадо мануш бущёлас Элимелех, ай лэски ромни — Наоми, ай лэ дуй лэскэ щявэ — Махлон ай Килион. Вон сас катар Эфрата анда Вифлеем, кай сы андэ Иудея. Вон авилэ андо Моав ай траинас котэ. ");
INSERT INTO rmylovari_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Элимелех, ром ла Наомияко, мулас, ай вой ащилас дуе щявэнца. ");
INSERT INTO rmylovari_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Вон лынэ ромнян моавиатянкэн — екх лэндар бущёлас Орпа, ай э кавэр Рут. Пала кодо сар вон траисардэ котэ каринг э дэш бэрш, ");
INSERT INTO rmylovari_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","ви Махлон ай Килион мулэ, ай Наоми ащилас би щявэнго ай ви би ромэско. ");
INSERT INTO rmylovari_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Наоми шундас андо Моав, кэ о Рай Яхва ажутысардас пэскэ манушэнгэ ай дас лэн хабэ, ай Наоми пэскэ боранца гэтосайлас тэ болдэл-пэ кхэрэ. ");
INSERT INTO rmylovari_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Пэскэ боранца вой ащядас тхан, кай траияс, ай гэлас андо дром, саво трубуяс тэ анэл лэн палпалэ андэ пхув Иудаски. ");
INSERT INTO rmylovari_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Наоми пхэндас пэскэ борангэ: — Болдэн-тумэ сако андо пэска дако кхэр. Мэк о Рай Яхва авэл милошо каринг тумэ, сар ви тумэ санас милоша кай тумарэ мулэ ром ай мандэ. ");
INSERT INTO rmylovari_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Мэк дэл о Рай Яхва саконакэ тумэндар тэ аракхэл пачя андо кхэр кай нэво ром. Вой чюмидас лэн, ай вон зуралэс рутэ ");
INSERT INTO rmylovari_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","ай пхэндэ лакэ: — Амэ жяса туса кай тирэ мануш. ");
INSERT INTO rmylovari_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Алом э Наоми пхэндас: — Болдэн-тумэ палпалэ кхэрэ, мурэ щея. Состар тэ жян манца? Мандэ наштык авэн инкэ щявэ, савэ кэрдёна тумарэ ром. ");
INSERT INTO rmylovari_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Болдэн-тумэ кхэрэ, мурэ щея; мэ аба сым пхури, тэ авэл ма кавэр ром. Ви тэ гиндысардэмас, кэ сы ман бизыяла, — ви андэ кады рати тэ авилэмас ромэса, ай котар кэрдэмас щявэн, — ");
INSERT INTO rmylovari_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","сар тумэ жутярна, жипон вон барона? Шай ли тумэ ащен са кады врама би ромэнго? На, мурэ щея. Мури брига зуралэс пхари тумэнгэ, анда кадо кэ о васт лэ Раско лэ Яхваско болдас-пэ чёрэс каринг мандэ! ");
INSERT INTO rmylovari_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Ай атунчи вон палэ зуралэс рутэ. Ай э Орпа чюмидас пэска сокра по палуныпэ, алом э Рут ащилас ласа. ");
INSERT INTO rmylovari_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","— Дыкх, — пхэндас Наоми, — тири бори болдэл-пэ палпалэ кай пэскэ мануш ай кай пэскэ дэвла. Болдэ-ту ви ту ласа. ");
INSERT INTO rmylovari_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Алом э Рут пхэндас: — На кикидэ пэ мандэ, тэ мэкав тут вай тэ болдав-ма тутар. Кай жяса ту, котэ ви мэ, ай кай ту ащядёса, ащядюво ви мэ. Тирэ мануш авна мурэ мануш, ай тиро Дэл авла муро Дэл. ");
INSERT INTO rmylovari_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Кай мэрэса ту, мэро ви мэ, ай котэ аво прахомэ. Фэри о мэрипэ лэла ман тутар. Мэк марэл ман о Рай Яхва зуралэс, тэ авла кавэрэс. ");
INSERT INTO rmylovari_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Кана Наоми атярдас, со э Рут щютас-пэ зуралэс тэ жял ласа, вой ащядилас тэ марэл ла тэлэ. ");
INSERT INTO rmylovari_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Ай солдуй жювля гэлэ май дур, жипон чи авилэ андо Вифлеем. Кана вон дынэ андрэ, са о форо бугзысайлас анда лэндэ, ай лэ жювля пхэннас: — На кады э Наоми? ");
INSERT INTO rmylovari_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","— На акхарэн ман Наоми, — пхэндас вой лэнгэ. — Пхэнэн мангэ Мара, анда кадо кэ Са-Биримаско кэрдас кэрко муро траё. ");
INSERT INTO rmylovari_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Мэ гэлэмтар анда кадо форо барвалы, ай о Дэл болдас ман палпалэ би канческо. Состар тэ пхэнэн мангэ Наоми? О Рай Яхва щюдас ман андэ брига; Са-Биримаско мэклас пэ ман бида. ");
INSERT INTO rmylovari_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Кадэ Наоми болдас-пэ анда Моав пэска бораса, моавитянкаса ла Рутаса. Вон авилэ андо Вифлеем, кана мануш лынэ тэ кидэн ячмень. ");
INSERT INTO rmylovari_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Кай лэ Наоми сас нямо па лакэ ромэски риг анда коды жэ вица, со ви о Элимелех, барвало ай пативало мануш, по анав Боаз. ");
INSERT INTO rmylovari_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Моавитянка Рут пхэндас ла Наомиякэ: — Жявтар мангэ пэ маля тэ кидав па пхув сэмно пала бутяра, котэ, кай авна мануш лаще каринг мандэ. Наоми пхэндас лакэ: — Жя, мури щей. ");
INSERT INTO rmylovari_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Вой гэлас ай лас тэ кидэл, со ащёлас пала бутяра. Кэрдилас кадэ, со вой авилас пэ коды риг лэ маляки, сави сас лэ Боазоски анда вица Элимелехоски. ");
INSERT INTO rmylovari_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Ворта андэ коды врама анда Вифлеем авилас Боаз ай дас опрэ лэ бутярэнго дес: — Мэк тэ авэл тумэнца о Рай Яхва! — Алдый тут о Рай Яхва, — пхэндэ вон палпалэ. ");
INSERT INTO rmylovari_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Боаз пущлас кай май баро пэ кидэтора: — Каски коды тэрны жювли? ");
INSERT INTO rmylovari_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","О баро пхэндас: — Кады моавитянка, кай болдас-пэ палпалэ э Наомияса анда Моав. ");
INSERT INTO rmylovari_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Вой пхэндас: «Мангав тут, дэ ман тэ кидав опрэ сэмно, кай пэлэ пала кидэтора». Вой авилас пэ мал ай инкэрдёлас катэ катар о ғайнало жи аканак; ай фэри эк-цэра ғодоныяс тэла тэтэво. ");
INSERT INTO rmylovari_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Боаз пхэндас э Рутакэ: — Шун ман, мури щей. На пхир тэ кидэс пэ кавэр мал ай на дурар-ту катар. Ащ катэ мурэ бутярицэнца. ");
INSERT INTO rmylovari_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Дыкх, пэ сави мал кидэн мурэ мануш, ай инкэрдюв кхэтанэ лэ жювлянца. Мэ пхэндэм мурэ бутярэнгэ тэ на азбан тут. Ай кана камэса тэ пэс, жя ай пи анда кхорэ, савэ пхэрдярэн мурэ бутяра. ");
INSERT INTO rmylovari_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Вой бандилас муеса каринг э пхув ай цыписардас: — Состар ту сан кадэ лащё каринг мандэ, состар сунус кадэ лэ каврэ-тхэмэска жювля? ");
INSERT INTO rmylovari_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Боаз пхэндас: — Мангэ панаскодысардэ па са, со ту кэрдан тира сокракэ, кана мулас тиро ром: сар ту ащядан тирэ дадэс ай да ви пэски пхув ай авилан тэ траис кай лэ мануш, савэн ту май англал чи жянэсас. ");
INSERT INTO rmylovari_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Мэк дэл тут лащипэ о Рай Яхва анда кадо, со ту кэрдан. Тэ лэс ту баро миштыпэ катар о Рай Яхва, Дэл Израилёско, каринг Саво ту авилан тэ аракхэс пачя тэла Лэскэ пхака. ");
INSERT INTO rmylovari_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","— Тэ аракхо ви май дур милошаго андэ тирэ якха, муро рай, — пхэндас вой. — Ту чендэшысардан ман ай ворбисас манца лащимаса, ви чи дыкхлан по кодо, кэ чи сым анда тирэ бутярицы. ");
INSERT INTO rmylovari_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Боаз, кана халас, пхэндас лакэ: — Пашув катэ. Лэ манро ай бол лэс андэ шуклы мол. Кана вой бэшлас паша кидэтора, вов дас ла пэко див. Вой халас, кати камлас, ай инкэ ащилас. ");
INSERT INTO rmylovari_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Кана вой ущилас тэ кидэл май дур, Боаз дас аври пэскэ бутярэнгэ: — Ви тэ кидэла вой машкар снопы, на шэртын ла. ");
INSERT INTO rmylovari_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Кэрэн кавэрэс: щюдэн лакэ колосья анда кодал, со тумэ кидан, ай ащявэн лакэ тэ ваздэл па пхув, ви на щюдэн пэ якха лакэ. ");
INSERT INTO rmylovari_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Кадэ кидэлас э Рут пэ мал жи по мизмэри. Кана вой мардас аври о сэмно, саво кидас, кэрдилас каринг допаш гоно. ");
INSERT INTO rmylovari_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Вой андас лэс андо форо, ай лаки сокра дыкхлас, кати бут вой кидас. Инкэ Рут лас аври ай дас ла кодо, со ащилас латэ анда хабэ. ");
INSERT INTO rmylovari_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Э сокра пущлас латар: — Кай ту кидэсас адес? Кай бутязысас? Мэк тэ авэл алдымэ кодо мануш, саво ажутысардас тукэ! Рут пхэндас лакэ, кастэ вой кэрдас бути. — Мануш, кастэ мэ адес кэрос бути, бущёл Боаз, — пхэндас вой. ");
INSERT INTO rmylovari_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","— Алдый лэс о Рай Яхва! — пхэндас Наоми пэска боракэ. — Вов чи ащядас би милошако чи жювиндэн, чи мулэн. Котар щютас пашэ: — Кадо мануш амэнгэ пашутно нямо. ");
INSERT INTO rmylovari_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Рут моавитянка пхэндас: — Вов инкэ пхэндас мангэ: «Ащ мурэ бутярэнца, жипон кидэна са муро сэмно». ");
INSERT INTO rmylovari_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Наоми пхэндас пэска боракэ ла Рутакэ: — Кадо мишто, мури щей, со ту лэса тэ пхирэс лэскэ бутярицэнца, анда кадо кэ пэ каврэски мал тут шай шэртон. ");
INSERT INTO rmylovari_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Рут инкэрлас-пэ лэ Боазоскэ бутярицэнца, жипон лэ мануш кидэ са о ячмень ай о див. Ай траияс кай пэски сокра. ");
INSERT INTO rmylovari_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Еквар лаки сокра Наоми пхэндас лакэ: — Ашта, мури щей, тэ дыкхлэмас тукэ тхан, кай тэ траис андэ пачя. ");
INSERT INTO rmylovari_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Дыкх аканак, о Боаз, каскэ бутярицэнца ту санас, амэнгэ нямо. Адес по мизмэри вов авла, кай ужарэн сэмно. ");
INSERT INTO rmylovari_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Атунчи тхов-ту, макх-ту сагангэ улыенца ай урав тирэ май шукар гада. Жя котэ, кай ужарэн сэмно, алом на сыкадюв лэскэ, жипон вов хала ай пэла. ");
INSERT INTO rmylovari_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Кана вов пашлёла, лэ сама, кай пашлёл. Котар жя, ваздэ капа па лэскэ пунрэ ай пашлюв. Вов пхэнла тукэ, со тэ кэрэс. ");
INSERT INTO rmylovari_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","— Мэ кэро са, сар ту пхэнэс, — пхэндас пэ кадо э Рут. ");
INSERT INTO rmylovari_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Вой гэлас по кадо тхан ай кэрдас са, со пхэндас лаки сокра. ");
INSERT INTO rmylovari_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Кана о Боаз ащядилас тэ хал ай тэ пэл ай лэско ило ковлилас, вов гэлас ай пашлилас пэ дурутны риг, кай сас кидыны сулума. Рут пашылас локхорэс, ваздас э капа па лэскэ пунрэ ай пашлилас. ");
INSERT INTO rmylovari_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Пэ допаш рат вов издраяс, пиписардас паша пэстэ ай аракхлас э жювля, сави пашлёлас паш лэскэ пунрэ. ");
INSERT INTO rmylovari_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","— Кон сан? — пущлас вов. — Мэ сым тири бутярица Рут, муро рай, — пхэндас вой. — Лэ ма андо тиро кхэр, чяк сан екх анда амарэ май пашутнэ нямо, кон фирий амэн. ");
INSERT INTO rmylovari_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","— Алдый тут о Рай Яхва, мури щей, — пхэндас вов. — Кадо лащё баё сы май баро, сар ту кэрдан англа кадо: ту чи лан тэ нашэс пала тэрнэ мурш, — чи пала барвалэ, чи пала чёрэ. ");
INSERT INTO rmylovari_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Ай аканак, мури щей, на дара. Мэ кэрав тукэ са, со ту мангэс. Са муро форо жянэл, со ту сан пативалы жювли. ");
INSERT INTO rmylovari_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Мэ сым тиро пашутно нямо, алом сы нямо инкэ май пашэ мандар. ");
INSERT INTO rmylovari_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Ащ пэ рат катэ, ай ёкор, тэ камла вов тэ авэл тиро фиритори, атунчи мишто — мэк тэ авэл. Ай тэ на камла, кадо кэро мэ; кадо сы чячипэ, сар сы чячипэ, кэ о Рай Яхва сы траимэ. Сов катэ жи ко ёкор. ");
INSERT INTO rmylovari_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Ай вой пашлёлас паша лэскэ пунрэ жи ко ёкор, алом ущилас, кана инкэ чи десайлас, кана инкэ наштык сас тэ пинжярэл екх мануш лэ каврэс. Боаз пхэндас пэскэ: «Мэк коник тэ на жянэл, кэ кады жювли сас катэ». ");
INSERT INTO rmylovari_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Вов пхэндас лакэ: — Дэ мангэ тиро пхикэнго дыкло, саво сы пэ тутэ, ай инкэр лэс. Кана вой кэрдас кадо, вов щютас андо дыкло ячмень, шов меры, ай жутысардас лакэ тэ щёл пхарипэ пэ пхикэ. Пала кадо вов гэлас палпалэ андо форо. ");
INSERT INTO rmylovari_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Кана э Рут авилас кай пэски сокра, Наоми пущлас: — Сар, мури щей? Ай вой панаскодысардас лакэ па са, со кэрдас лакэ о Боаз, ");
INSERT INTO rmylovari_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","ай щютас пашэ: — Вов дас мангэ кодал шов меры сэмно ворбаса: «На болдэ-ту кай тири сокра щюще вастэнца». ");
INSERT INTO rmylovari_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Наоми пхэндас: — Рыбдысар эк-цэра, мури щей, жипон жянэса, со авла май дур. Чяк кадо мануш чи чендэшыя-пэ, жипон адес чи дэла гата кадо баё. ");
INSERT INTO rmylovari_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Ай о Боаз андэ коды врама гэлас каринг о пияцо паша лэ фороски бар ай бэшлас котэ. Кана о нямо, па кастэ вов ворбияс, накхлас паша лэстэ, Боаз пхэндас: — Ав катэ, муро пайташы, ай бэш. Вов авилас ай бэшлас. ");
INSERT INTO rmylovari_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","О Боаз акхардас дэшэ-женэн анда фороскэ барэ мануш ай пхэндас лэнгэ: — Бэшэн катэ. Ай вон бэшлэ. ");
INSERT INTO rmylovari_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Пала кадо вов пхэндас кодолэ нямоскэ: — Наоми, сави болдас-пэ анда Моав, бикнэл котор э пхувако, саво сас амарэ нямоско, лэ Элимелехоско. ");
INSERT INTO rmylovari_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Мэ гиндысардэм, кэ трубуй тэ пхэнав тукэ тэ кинэс лэс англа саворэ, кон бэшэн катэ, ай англа амарэ май пативалэ мануш. Алом тэ на кинэса лэс, пхэн мангэ, мэ тэ жянав. Кэ ту сан англуно васт тэ кэрэс кадо, ай мэ сым о дуйто. — Мэ кинав лэс, — пхэндас о нямо. ");
INSERT INTO rmylovari_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Атунчи Боаз пхэндас: — Андо кодо дес, кана ту кинэса э пхув кай э Наоми, ту инкэ трубуя тэ лэс ромнякэ ла моавитянка, э Рута, мулэска пхивла, кэ кана авла тумэн щяво, тэ ащел кады пхув пала челэдо лэ мулэско. ");
INSERT INTO rmylovari_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Алом о нямо пхэндас: — Атунчи мэ наштык кинав кадо котор пхувако, анда кадо кэ мэ шай хасарав муро барвалипэ. Кин лэс май федэр коркоро, ай мэ наштык кадо кэрав. ");
INSERT INTO rmylovari_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","(Андэ пураны врама андо Израиль, тэ кинэс вай тэ дэс кавэрэскэ э пхув, екх анда лэ бикинэтора лэлас па пунро сандалия ай дэлас ла кавэрэскэ. Касаво цокашы сас андо Израиль, тэ авэл о бикиныпэ андо законо.) ");
INSERT INTO rmylovari_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","О нямо пхэндас лэ Боазоскэ: — Кин коркоро. Ай лас тэлэ сандалия. ");
INSERT INTO rmylovari_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Атунчи Боаз пхэндас барэ манушэнгэ ай саворэнгэ: — Адес тумэ дыкхлан ай шундан кадо, кэ мэ киндэм катар Наоми са, со сас Элимелехоско, Килионоско ай Махлоноско. ");
INSERT INTO rmylovari_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Ай инкэ мэ лэм моавитянка э Рута, Махлоноска пхивла, мангэ ромнякэ, тэ ащел э пхув пала челэдо лэ мулэско, тэ на хасайвэл лэско анав машкар лэ нямура ай андо лэско форо. Тумэ адес са дыкхлэ ай шундэ кадо! ");
INSERT INTO rmylovari_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Ай атунчи лэ барэ мануш ай са, кон сас по пияцо, пхэндэ: — Амэ са дыкхлам ай шундам. Мэк о Рай Яхва тэ кэрэл бутэ щяворэнги жювля, сави авэл андо тиро кхэр, сар э Рахиль ай Лия, савэ кхэтанэ ваздэ о кхэр Израилёско. Барар о барвалипэ андэ Эфрата ай лачи ғира андо Вифлеем. ");
INSERT INTO rmylovari_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Мэк пэрдал парапутя, савэн дэла тут о Рай Яхва катар кады жювли, тири вица авла, сар вица кай о Парец, савэс Тамар кэрдас лэ Ехудаскэ. ");
INSERT INTO rmylovari_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Кадэ о Боаз лас ла Рута, ай вой кэрдилас лэски ромни. Вов пашлилас ласа, ай о Рай Яхва дас лакэ тэ авэл кхамны, ай вой кэрдас щявэс. ");
INSERT INTO rmylovari_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Жювля пхэннас э Наомиякэ: — Наис лэ Раскэ лэ Яхваскэ, Саво чи ащядас тут адес би наследникоско, саво лэла тэ дыкхэл пала тутэ. Мэк о щяворо тэ авэл ғирэшо андо Израиль! ");
INSERT INTO rmylovari_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Вов дэла тут нэво траё ай сунуя тут по пхурипэ. Чяк вов аракхадилас кай тири бори, сави камэл тут ай май лащи тукэ, сар эфта щявэ. ");
INSERT INTO rmylovari_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Наоми лас щяворэс, пхиравлас лэс андэ ангаля ай барарлас лэс. ");
INSERT INTO rmylovari_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Жювля, савэ траинас котэ, пхэннас: — Кай э Наоми аракхадилас щяво. Вон дынэ лэс анав Овид. Вов кэрдилас дад лэ Иессеёско, кон сас о дад Давидоско. ");
INSERT INTO rmylovari_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Эта лэ вица Парецоски: Парец сас о дад лэ Хецроноско, ");
INSERT INTO rmylovari_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Хецрон сас о дад лэ Рамоско, о Рам сас о дад лэ Амминадавоско, ");
INSERT INTO rmylovari_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Амминадав сас о дад Нахшоноско, Нахшон сас о дад Салмоноско, ");
INSERT INTO rmylovari_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","о Салмон сас о дад Боазоско, о Боаз сас о дад лэ Овидоско, ");
INSERT INTO rmylovari_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Овид сас о дад Иессеёско, Иессей сас о дад Давидоско.");
INSERT INTO rmylovari_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Каринг о Иона, Амиттаёско щяво, сас ворба катар о Рай Яхва: ");
INSERT INTO rmylovari_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","— Кидэ-ту, жя андо баро форо Ниневия ай пхэн манушэнгэ ворба, анда кадо кэ ғира па лэскэ чёрэ бутя арэслас жи Мандэ. ");
INSERT INTO rmylovari_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Алом о Иона кидас-пэ тэ нашэл катар о Рай Яхва андо Таршыш. Вов гэластар андэ Яффа, аракхлас бэро, саво жяластар андо Таршыш, потиндас пал традыпэ ай бэшлас пэ лэстэ тэ усый катар о Рай Яхва. ");
INSERT INTO rmylovari_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Алом о Рай Яхва щюдас по море бари балвал, ай ваздас-пэ касаво штормо, кэ о бэро сас тэ пхарадёл. ");
INSERT INTO rmylovari_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Саворэ налара дарайлэ, ай сако лас тэ рудий кай пэско дэл. Вон щюдэ андо паи са э пхаримата, савэ сас по бэро, тэ авэл вов май локхо. Англа кадо о Иона мэклас-пэ тэлэ андо бэро, пашлилас котэ ай сутас зуралэ соимаса. ");
INSERT INTO rmylovari_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Бэроско паранчёдашы авилас лэстэ ай пхэндас: — Со ту совэс? Уще, рудин-ту тирэ Дэвлэскэ! Вов шай жутый амэнгэ, ай амэ чи хасайвас. ");
INSERT INTO rmylovari_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Э налара пхэннас екх екхэскэ: — Тэ щюдамас жребиё тэ жянас, анда кастэ амэ шай хасайваса. Вон щюдэ жребиё, ай вов сыкадас по Иона. ");
INSERT INTO rmylovari_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Атунчи вон пущлэ лэс: — Пхэн амэнгэ, кон дошало андо кадо баё? Че бутяса лэсту? Катар жяс? Анда че тхэм сан? Анда че мануш? ");
INSERT INTO rmylovari_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Вов пхэндас: — Мэ сым евреё ай дав патив кай о Рай Яхва, о Дэл лэ Черэско, Саво кэрдас море ай э пхув. ");
INSERT INTO rmylovari_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Иона пхэндас э наларэнгэ, кэ вов нашэл катар о Рай Яхва. Кана вон жянглэ па кадо, лас лэн бари дар, ай вон пущлэ: — Ай че баё кэрдан? ");
INSERT INTO rmylovari_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Ай лэ моряко паи ваздэлас-пэ са май зуралэс ай май учес, ай атунчи вон пущлэ лэстар: — Со тэ кэрас туса тэ чендэшый-пэ о паи? ");
INSERT INTO rmylovari_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","— Лэн ман ай щюдэн андо море, — пхэндас вов, — ай о паи чендэшыя-пэ. Мэ жянав, кэ кадо насул штормо пэлас пэ тумэндэ анда мандэ. ");
INSERT INTO rmylovari_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Вон лынэ тэ традавэн о бэро анда интрэги зор, тэ рэсэн жи кай пхув, алом вон чи биринас, анда кадо кэ о паи ваздэлас-пэ лэ балваляса инкэ май зуралэс. ");
INSERT INTO rmylovari_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Атунчи вон лынэ тэ мангэн лэ Рас лэ Яхвас: — Эта, Рай Яхва, тэ на хасайвас амэ анда кадо мануш. Тэ на щёс пэ амэндэ бэзэх анда мударипэ на дошалэ манушэско, чяк Ту, Рай Яхва, кэрэс кодо, со камэс Ту. ");
INSERT INTO rmylovari_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Атунчи вон лынэ Ионас, щюдэ лэс аври анда бэро, ай холярнико паи чендэшысайлас. ");
INSERT INTO rmylovari_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Лас э манушэн бари дар катар о Рай Яхва, вон дынэ лэскэ жэртва ай солахадэ. ");
INSERT INTO rmylovari_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","О Рай Яхва кэрдас кадэ, кэ баро мащё накхадас Ионас, ай вов сас андэ мащески дёмра трин дес ай трин ратя. ");
INSERT INTO rmylovari_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","Кана сас андэ дёмра э мащески, Иона рудияс-пэ каринг о Рай Яхва, каринг пэско Дэл. ");
INSERT INTO rmylovari_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Вов пхэндас: — Андэ брига манглэм лэ Рас лэ Яхвас, ай Вов пхэндас мангэ палпалэ. Мэ цыписардэм катар э мулэнги лума — ай Ту шундан муро цыпипэ. ");
INSERT INTO rmylovari_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Ту щюдан ма андо бифундоско паи, ворта андо баро паенго ило; круисардэ ман фолымата. Са Тирэ таласура, са Тирэ пая накхлэ па мандэ. ");
INSERT INTO rmylovari_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Мэ пхэндэм: «Нашадо сым катар Тирэ якха; алом палэ дыкхава Тиро сунто Кхэр». ");
INSERT INTO rmylovari_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Щерадэ ман лэ пая бифундоскэ, ай лэнгэ чяра кхудэ-пэ по муро шэро. ");
INSERT INTO rmylovari_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","По фундо, кай лэ харэнгэ вуны, мэклэм-ма, ай пхувакэ лэкатура пхандадилэ пала мандэ тэ на путрэн-пэ. Алом Ту, Рай Яхва, муро Дэл, лан ма анда гропа жювиндэс! ");
INSERT INTO rmylovari_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Кана о траё мурдайвэлас андэ мандэ, мэ дэм-ма гиндо па Рай Яхва, ай авилас муро рудипэ жи Тутэ, андо сунто Тиро Диз. ");
INSERT INTO rmylovari_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Кодал мануш, кон дэн патив хохавнэ дэвлэнгэ, мэклэ чячюнэ Дэвлэс. ");
INSERT INTO rmylovari_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Ай мэ ашардэ диланца ло тэ анав Тукэ жэртвы. Со щинадэм — кэро. О фирипэ авэл катар о Рай Яхва! ");
INSERT INTO rmylovari_vpl VALUES ("JH2_11","033_2_11","JON","2","11","11","О Рай Яхва дас аври лэ мащескэ, ай вов щюдас Ионас пэ пхув анда пэски дёмра. ");
INSERT INTO rmylovari_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Ай по дуйто сас лэ Раски лэ Яхваски ворба каринг о Иона:. ");
INSERT INTO rmylovari_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","— Кидэ-ту, жя андо баро форо Ниневия ай пхэн манушэнгэ ворба, сави Мэ тукэ пхэнав. ");
INSERT INTO rmylovari_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Иона патяяс лэ Раско лэ Яхваско муй, кидас-пэ тай гэлас андэ Ниневия. Ниневия сас баро форо — трубуяс май трин дес тэ пхирэс лэс опрэ. ");
INSERT INTO rmylovari_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Ай о Иона киздысардас тэ пхирэл па форо ай накхлас кати шай тэ пхирэс тэла екх дес, ай пхэнлас: — Па штарвардэш дес Ниневия авла пхагэрды! ");
INSERT INTO rmylovari_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Лэ ниневитянура патяе лэ Дэвлэскэ ай лынэ тэ на хан и тэ на пэн, ай саворэ — катар барэ жи кай цынэ — урадэ-пэ андэ чёрэ похтанэскэ гада. ");
INSERT INTO rmylovari_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Кана кады ғира арэслас жи кай Ниневияко край, вов ущилас па пэско краицко тхан, лас тэлэ пэскэ краицка гада, урадас чёрэ гада ай андэ брига бэшлас по ватрако тхан. ");
INSERT INTO rmylovari_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Вов дас аври тэ пхэнэн андэ Ниневия: — Краицко ай ранги ворба: «Мэк лэ мануш тэ на хан и тэ на пэн, ви э алатура: гурува, бакрэ ай бусня — тэ на хахавэн-пэ пэ мал ай тэ на пэн! ");
INSERT INTO rmylovari_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Мэк ви манушэн, ви алатон щяравэн чёрэ похтанэнца. Мэк сако анда са пэски зор мангэл лэ Дэвлэс. Мэк ащявэн пэскэ холярдэ бутя ай пэско насулыпэ. ");
INSERT INTO rmylovari_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Кон жянэл, кам шай о Дэл инкэ сунуя амэн ай парувла о гиндо, кам тордярэла пэски ягалы холи ай милоя-пэ амэндар, ай амэ чи хасайваса». ");
INSERT INTO rmylovari_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Кана о Дэл дыкхлас, со вон кэрдэ, ай сар ащядэ пэскэ насул дрома ай чёрэ бутя, Вов милосайлас ай чи бищядас пэ лэндэ бида, саваса Вов даравлас лэн. ");
INSERT INTO rmylovari_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Лэ Ионаскэ кадо зуралэс чи чялилас, ай вов холяйлас. ");
INSERT INTO rmylovari_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Вов лас тэ рудий-пэ лэ Раскэ лэ Яхваскэ: — Эта, Рай Яхва! Па кадо мэ ви гиндыяс, кана сымас инкэ кхэрэ! Анда кадо ви нашлэм андо Таршыш. Мэ жянос, кэ Ту сан Дэл, кай кэрэл лащипэ, милако, рыбдымаско ай барвало камаимаса, ай чи камэс тэ бищявэс бида. ");
INSERT INTO rmylovari_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Ай аканак, Рая Яхва, лэ муро ди, анда кадо кэ май федэр тэ мэрав, сар тэ траий. ");
INSERT INTO rmylovari_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Алом о Рай Яхва пхэндас: — Тукэ трубуй тэ холяйвэс кадэ? ");
INSERT INTO rmylovari_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Иона дас аври анда форо ай бэшлас пэ риг, кай ваздэл-пэ о кхам. Котэ кэрдас анда кранжи сыр цынкалово, бэшлас тэлэ андо щялин ай лас тэ дыкхэл, со кэрдёла лэ фороса. ");
INSERT INTO rmylovari_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Ай о Рай Яхва кэрдас тэ барол о бур, саво ваздас-пэ май учес, сар Иона, тэ на хал вов кино катар о кхам, ай Иона лошаяс кадалэскэ. ");
INSERT INTO rmylovari_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Алом по кавэр дес, коран, о Дэл бищядас лэ кэрмэс тэ рагий о бур, ай о бур шутилас. ");
INSERT INTO rmylovari_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Кана о кхам ваздилас, о Дэл бищядас пхабарды балвал, ай о кхам лас тэ пхабарэл лэ Ионаско шэро. Вов кадэ кинозысайлас, кэ камлас тэ мэрэл ай пхэндас: — Май федэр тэ мэрав, сар тэ траий. ");
INSERT INTO rmylovari_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Ай о Дэл пхэндас Ионаскэ: — Тукэ трубуй кадэ тэ холяйвэс анда бур? — Трубуй, — пхэндас о Иона, — на фэри тэ холяйвав, ай ви тэ мэрав. ");
INSERT INTO rmylovari_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Алом о Рай Яхва пхэндас: — Ту бунус анда буроро, пала саво чи грыжысас, саво чи барардан. Вов барилас тэла екх рати, ай тэла екх рати хасайлас. ");
INSERT INTO rmylovari_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Ай сар Мэ тэ на сунуй баро форо Ниневия, кай на фэри бут алатура, ай май бут сар екх шэл тай биш эзэра мануш чи жянэн, кай сы чячи риг, ай кай э стунго?");
ALTER TABLE rmylovari_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
