﻿USE sofia;
DROP TABLE IF EXISTS sofia.rmyGurbet_vpl;
CREATE TABLE rmyGurbet_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES rmyGurbet_vpl WRITE;
INSERT INTO rmyGurbet_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Kava si spisko tare kuštika e Isusese savo si Hrist, savo sasa potomko e Davideso thaj potomko e Avraameso. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","E Avraamese bijandilo o Isaak. A e Isaakose bijandilo o Jakov. A e Jakovese bijandile o Juda thaj lese phrala. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","A e Judase i Tamara bijanda e Farese thaj e Zare. A e Faresese bijandilo o Esrom. A e Esromese bijandilo o Aram. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","A e Aramese bijandilo o Aminadav. A e Aminadavese bijandilo o Naason. A e Naasonese bijandilo o Salmon. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","A e Salmonese i Raava bijanda e Vooze. A e Voozese i Ruta bijanda e Jovide. A e Jovidese bijandilo o Jesej. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","A e Jesejese bijandilo o caro o David. A e Davidese, e Urijasi romni bijanda e Solomone. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","A e Solomonese bijandilo o Rovoam. A e Rovoamese bijandilo o Avija. A e Avijase bijandilo o Asaf. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","A e Asafese bijandilo o Josafat. A e Josafatese bijandilo o Joram. A e Joramese bijandilo o Ozija. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","A e Ozijase bijandilo o Joatam. A e Joatamese bijandilo o Ahaz. A e Ahazese bijandilo o Ezekija. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","A e Ezekijase bijandilo o Manasija. A e Manasijase bijandilo o Amos. A e Amosese bijandilo o Josija. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","A e Josijase bijandile o Jehonija thaj lese phrala. Sasa gova ano vreme kana e Izraelcuren inđarde ano Vavilon. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","A palo džajipe ko ropstvo ano Vavilon, e Jehonijase bijandilo o Salatiilo. A e Salatiilose bijandilo o Zorovavel. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","A e Zorovavelese bijandilo o Avijud. E Avijudase bijandilo o Elijakim. A e Elijakimese bijandilo o Azor. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","A e Azorese bijandilo o Sadok. A e Sadokase bijandilo o Ahim. A e Ahimese bijandilo o Elijud. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","A e Elijudase bijandilo o Eleazar. A e Eleazarese bijandilo o Matan. A e Matanese bijandilo o Jakov. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","A e Jakovese bijandilo o Josif, o rom e Marijako, savi bijanda e Isuse akhardo Hrist. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Golese e kuštika taro Avraam dži o David, dešuštar (14) kuštika, a taro David dži ko džajipe ko ropstvo ano Vavilon, dešuštar (14) kuštika, a taro džajipe ano Vavilon dži o Hrist, dešuštar (14) kuštika. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","A o bijandipe e Isuseso e Hristeso sasa gija: Kana i Marija lesi dej sasa mangli romnjaće taro Josif thaj vadži ni lije pe thaj voj sasa čhej, ačhili khamni taro Sveto Duxo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","A o Josif lako rom, golese so sasa pravedno manuš thaj kaj ni manglja te ladžarol la, manglja čorale te ačhavol la. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Thaj kana gija dija gođi golestar, zasuta thaj ano suno iklilo lese o anđelo e Gospodeso savo vaćarda: “Josife, čhaveja e Davideso! Ma te dara te le e Marija romnjaće. O čhavoro save voj ađućarol si taro Sveto Duxo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ka bijanol čhave, a tu de le alav Isus golese kaj ka ikalol pe manušen tare grehura lenđe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","A sa kava sasa te ćerdol kova so o Dol vaćarda prekalo proroko: ");
INSERT INTO rmyGurbet_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Akh, i čhej ka ačhol khamni, thaj ka bijanol čhave thaj von ka den le alav Emanuel” so gova značil: “O Dol si amencar.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Kana o Josif uštilo taro sojipe, ćerda sar so vaćarda lese o anđelo e Gospodeso – anda e Marija pe čhereste thaj lija la romnjaće. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Al vov ni suta lasa sa dži kaj ni bijanda murše čhave thaj dija le alav Isus. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","A kana bijandilo o Isus ano Vitlejem ani regija i Judeja, ko vreme e caroso e Irodeso, gothe avile e mudrakura taro istok ano Jerusalim, ");
INSERT INTO rmyGurbet_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","thaj pučlje: “Kaj si o jevrejsko caro savo tek bijandilo? Golese kaj dikhljam lesi čereni kaj iklili ko istok thaj aviljam te pera lese ke koča.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kana gova šunda o caro o Irod, vov but uznemirisajlo thaj savore ano Jerusalim. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Golese akharda sa e bare sveštenikuren thaj e učiteljuren e narodose tare Mojsijaso zakon thaj pučlja len: “Kaj trubul te bijandol o Hrist?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","A von vaćarde lese: “Ano Vitlejem o Judejsko, golese kaj o proroko pisisada: ");
INSERT INTO rmyGurbet_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘A tu Vitlejeme, ani phuv e Judaći, naj san nevažno maškar e Judejska thana, golese kaj tutar ka ikljol vladari savo ka inđarol pe manušen ano Izrael, sar o pastiri pe bakren.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Thaj o Irod čorale bičhalda te den vika e mudrakuren thaj pučlja len kana tačno iklili i čereni. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Tegani bičhalda len ano Vitlejem, vaćarindoj: “Džan tumen thaj pučen šukar bašo čhavoro. Kana ka aračhen le, aven vaćaren manđe, te džav i me te perav angle leste ke me koča.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Von šunde e caro thaj đele. Thaj akh, i čereni sava dikhlje sar ikljol đeli angle lende sa dži kaj ni ačhili upre ko than kaj sasa o čhavoro. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Kana dikhlje i čereni, sesa baxtale, a lenđe ile sesa pherde. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Đele andre ano čher, dikhlje e čhavore thaj lesa sasa lesi dej i Marija. Pele tele ke pe koča thaj poklonisajle lese. Pale gova putarde pe kutije thaj dije le pe darura: zlato, tamjano thaj smirna. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Thaj ano suno upozorisada len o Dol te ma irin pe ko Irod, golese avere dromesa đele ani piri phuv. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kana đele e mudrakura, dikh, avilo o anđelo e Gospodeso e Josifese ano suno thaj vaćarda lese: “Ušti, le e čhave thaj lese deja thaj naš ano Egipat thaj av odori dok me ni vaćarav tuće, golese kaj o Irod ka rodol e čhavore te mudarol le.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Vov uštilo goja rat lija e čhavore thaj lese da thaj našlo ano Egipat. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Thaj odori ačhilo dži o meripe e Irodeso, te bi pherdola so o Gospod vaćarda prekalo proroko: “Taro Egipat dijem vika me čhave.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Kana o Irod dikhlja kaj e mudrakura xoxade le, holajlo but thaj bičhalda e vojnikuren te mudaren ano Vitlejem thaj ane pašutne thana e muršane čhavoren dži e duj berš, palo vreme kana iklili i čereni tare savi dodžanglja tare mudrakura. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Gija pherdilo kova so vaćarda o proroko o Jeremija: ");
INSERT INTO rmyGurbet_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“O glaso ano foro Rama šundilo, o rojipe thaj o kukipe baro. Gova i Rahilja rovol pe čhavoren, thaj našti te ačhol laći dukh, golese kaj naj la vadži čhave.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","A palo meripe e Irodeso, avilo o anđelo e Gospodeso e Josifese ano Egipat ko suno ");
INSERT INTO rmyGurbet_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","thaj vaćarda lese: “Ušti, le e čhave thaj lese da, pa dža ani phuv i Izraelsko, golese so mule kola save manglje te mudaren e čhavore.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","O Josif uštilo, lija e čhavore thaj lese da, pa avilo ani phuv i Izraelsko. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","A kana o Josif šunda kaj o Arhelaj, o čhavo e Irodeso savo vladil ani Judeja umesto leso dad, darajlo te džal odori. Tegani ano suno upozorisada le o Dol, te džal ani phuv i Galilejsko. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Thaj kana avilo odori pe familijasa, ačhilo te bešol ano foro savo akhardola Nazaret. Gija pherdilo gova so e prorokura vaćarde: “Ka akharen e Hriste Nazarećanino.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","A ane gola đivesa avilo o Jovane o Krstitelj thaj propovedila ani Judejsko pustinja. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Thaj vaćarda: “Pokajin tumen, golese kaj sigate avol o Carstvo e neboso!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Golese kaj si o Jovane gova kastar vaćarda o proroko Isaija: “Vov si glaso so dol vika ani pustinja: ‘Pripremin o drom e Gospodese! Ravnin lese o drom!’” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","A po Jovane sesa šeja khuvde tare kamilaće bala thaj kuštik tari morčhi, a leso xape sasa e skakavcura thaj divljo avđin. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","But manuša avena ke leste taro Jerusalim thaj tari sa i phuv i Judeja thaj tare trujale thana paši len o Jordan, ");
INSERT INTO rmyGurbet_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","vaćarena pe grehura, a o Jovane krstila len ani Jordansko len. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Al kana dikhlja o Jovane bute farisejen thaj e sadukejen kaj avena te krstin pe vaćarda lenđe: “Tumen e sapese čhave! Ko vaćarda tumenđe kaj šaj te našen tare Devlesi holi so avol? ");
INSERT INTO rmyGurbet_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Sikaven tumare džuvdimasa thaj tumare bućencar kaj irisaljen taro greh thaj aviljen anglo Dol! ");
INSERT INTO rmyGurbet_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ma mislin kaj dovoljno te phenen: ‘Amaro paradad si o Avraam!’ Golese vaćarav tumenđe kaj o Dol šaj tare kala bara te vazdol čhaven e Avraamese. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Golese kaj o tover tare Devleso sudo ačhol pašo koreno e kašteso thaj dži jekh kaš savo ni bijanol šukar bijandipe ka čhinol pe thaj ani jag ka čhudol pe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Me tumen krstiv pajesa te bi sikavena tumaro pokajanje. Al kova savo avol pale mande, po baro si mandar – me naj sem dostojno ni lese sandale ke pingre te inđarav. Vov ka krstil tumen e Svetone Duxosa thaj jagasa. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Le isi vila ane vasta thaj ka čistil o gumno i ka ćidol o điv ane piro ambari, a i pleva ka phabarol jagasa savi ka phabol thaj ni ka ačhol.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Tegani o Isus tari Galileja avilo ki len o Jordan te bi krstila le o Jovane. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","O Jovane ni manglja thaj vaćarda lese: “Tu trubul man te krsti, a tu aviljan mande?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","A o Isus vaćarda lese: “Ačhav akana gova, golese kaj gija trubul te phera sa o pravednost.” Tegani o Jovane krstisada le. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Thaj kana o Isus krstisajlo, iklilo sigate andaro paj, thaj dikh, o nebo putajlo thaj dikhlja sar e Devleso Duxo uljol sar golubo thaj mukhljape pe leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Thaj dikh, o glaso taro nebo vaćarda: “Kava si mo Čhavo o manglo, savo si palo mingro manglipe!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tegani o Sveto Duxo inđarda e Isuse ani pustinja, te iskušil le o beng. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Thaj postisada o Isus saranda (40) đive thaj raća thaj ko krajo bokhajlo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Thaj avilo paše leste o beng savo iskušil thaj vaćarda lese: “Te san e Devleso Čhavo, vaćar kale barenđe te aven mangre.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","A o Isus phenda lese: “Ano Sveto lil si pisimo: ‘O manuš ni ka avol džuvdo samo taro mangro, nego tare dži jekh lafi savo ikljol taro muj e Devleso.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tegani o beng inđarda le ano sveto foro o Jerusalim thaj čhuta le ko emupruno than e Hrameso ");
INSERT INTO rmyGurbet_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","pa vaćarda lese: “Te san e Devleso Čhavo, čhude tut katar tele, golese kaj si pisimo: ‘E anđelurenđe ka naredil baše tute, thaj ka len tut ke vasta te ma čalave tut ko bar će pingresa.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","O Isus vaćarda lese: “Ano Sveto lil si pisimo: ‘Ma iskuši e Gospode, e Devle ćire!’” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Pale gova o beng inđarda le upre ko but učo brego thaj sikada lese sa e carstvura tare kava sveto thaj lenđi slava ");
INSERT INTO rmyGurbet_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","thaj vaćarda lese: “Sa ka dav tut kava ako pere ke koča thaj pokloni tut manđe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Tegani vaćarda lese o Isus: “Dža mandar, Satano! Golese kaj ano Sveto lil ačhol: ‘Pokloni tut e Gospodese e Devlese ćirese thaj lese jekhese služi.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Tegani o beng ačhada e Isuse, a sigate e anđelura avile thaj služisade le. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Kana šunda o Isus kaj si o Jovane o Krstitelj ano phanglipe, đelo ani Galileja. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Thaj ačhada o Nazaret pa đelo thaj bešlo ano Kafarnaum, pašo Galilejsko jezero ke Zavuloneso thaj e Neftalimeso krajo, ");
INSERT INTO rmyGurbet_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","te bi pherdola kova so vaćarda o proroko o Isaija: ");
INSERT INTO rmyGurbet_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ani phuv e Zavulonesi thaj ani phuv e Neftalimesi, o drom savo inđarol pašo more, tari aver rig e Jordanesi, ani Galileja ani phuv savi si e abandžijenđi, ");
INSERT INTO rmyGurbet_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","manuša save bešen ano kalipe ka dičhen svetlost baro, e manuša save bešen ano mrako, o svetlost pe lende ka sijajil.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tare gova vreme o Isus lija te propovedil thaj te vaćarol: “Pokajin tumen, golese kaj si paše o Carstvo e neboso.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Thaj dži kaj o Isus phirda pašo Galilejsko more, dikhlja duje phralen, e Simone kas akharen Petar thaj e Andrija lese phrale, sar čhuden e mreže ano more, golese kaj sesa ribara. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Thaj vaćarda lenđe: “Aven mancar thaj ka ćerav tumen ribara e manušenđe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Von sigate ačhade e mreže thaj đele pale leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Gothar kana đelo po dur zala, dikhlja avere dujen phralen, e Jakove thaj e Jovane e Zevedejevese čhaven, sar pe dadesa e Zevedejesa ano čamco prećeren pe mreže thaj dija len vika. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Von sigate ačhade o čamco thaj pe dade thaj đele palo Isus. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","O Isus phirda ani sa i Galileja, sikada ane jevrejska sinagoge thaj vaćarda o Lačho Lafi taro Carstvo e neboso thaj sastarda dži jekh nasvalipe thaj bilačhipe so sasa ano narodo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Thaj sa gova so ćerola šundilo ani sa i Sirija thaj angle leste ande e nasvalen tare dži jekh nasvalipe thaj muke, e manušen ane save sesa e bilačhe duxura, kolen so sasa paraliza, kola so naštine te phiren thaj vov sastarda len. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Pale leste phirena but džene tari Galileja, taro Dekapolis, taro Jerusalim, tari Judeja thaj tari phuv savi si ki aver rig e Jordanesi. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Kana o Isus dikhlja kaj ćidije pe but manuša, iklilo ko brego, bešlo thaj avile lese sikade paše leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","A vov lija te sikavol len, vaćarindoj: ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Blagoslovime si kola save si čorore duxosa, golese kaj si lengo o Carstvo e neboso. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Blagoslovime si kola save roven, golese kaj ka utešin pe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Blagoslovime si e kovle ilenđe, golese kaj von ka nasledin i phuv. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Blagoslovime si e bokhale thaj e trošale bašo pravednost, golese kaj von ka čaljon. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Blagoslovime si e milostiva, golese kaj o Dol ka smiluilpe pe lende. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Blagoslovime si kola save si čistone ilencar, golese kaj e Devle ka dičhen. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Blagoslovime si kola save ćeren mir, golese kaj ka akhardon e Devlese čhave. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Blagoslovime si kola save si tradime pašo pravednost, golese kaj lengo si o Carstvo e neboso. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Blagoslovime sen kana zbog mande ka ladžaren tumen thaj traden tumen thaj xoxavne bilačhe buća čhuven pe tumende! ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Radujin tumen thaj aven baxtale, golese kaj tumari plata si bari ko nebo, golese kaj gija e prorokuren tradije angleder tumende!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","O Isus vadži vaćarda: “Tumen sen sar lon e manušenđe ki phuv, te nakhlo leso londipe, sose šaj te koristil pe? Naj khančese, samo te čhudol pe thaj avral te uštaven e manuša pe leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Tumen sen o svetlo kale svetoso. Našti garavol pe o foro savo si ko brego. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ni phabaren i svetiljka te bi čhuvena la talo čaro, nego čhuvol la ko than e svetiljkako te svetlil savorenđe ano čher. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Gija te svetlil tumaro svetlost angle manuša, te dičhen tumare šukar buća thaj te slavin tumare Dade savo si ano nebo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","O Isus vadži vaćarda: “Ma te den gođi kaj me aviljem te čhinavav e Mojsijaso zakon thaj o vaćaripe e prorokurengo. Na, ni aviljem te čhinavav, nego aviljem te pherav len. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Golese čače vaćarav tumenđe dži kaj ačhen o nebo thaj i phuv, ni ka načhol ni emcikno slovo il nesavi crtica tare Mojsijaso zakon dži kaj sa ni avol gija. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Golese, te phaglja khoni jekh tare emcikne zapovestura i gija sikavol, emcikno ka avol ano Carstvo e neboso. A ko sikavol len thaj ćerol gija, ka avol baro ano Carstvo e neboso. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Golese, vaćarav tumenđe: ako tumaro pravednost ni avol pobaro tare učiteljengo tare Mojsijaso zakon thaj tare fariseja, našti te den ano Carstvo e neboso.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","O Isus vadži vaćarda: “Šunden sar si vaćardo amare puranenđe: ‘Ma mudar’, golese ko mudarol, mora te ikljol ko sudo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","A me vaćarav tumenđe: Ko holjavol pe piro phral, mora te ikljol ko sudo. A savo vaćarol pe phralese ‘Budalo’, mora te ikljol anglo Baro sudo, a savo vaćarol pe phralese ‘Dileja’, zaslužil te phabol ani jag savi ni ačhol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Gija, kana ačhe anglo žrtveniko ano Hram te ane žrtva thaj tari jekh drom dijan tut gođi kaj si nesavo phral protiv tute, ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ačhav gothe e žrtva anglo žrtveniko thaj angleder pomiri tut ćire phralesa, tegani av thaj de e žrtva e Devlese. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Dikh sigate te miri tut ćire dušmanesa dok phire lesa po drom, te ma dol tut e sudijase, a o sudija te dol tut e slugase, savo ka čhudol tut ano phanglipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Čače vaćarav tuće: ni ka iklje gothar dok ni poćine dži i zadnjo parava.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","O Isus vadži vaćarda: “Šunden sar si vaćardo: ‘Ma ćeren preljuba!’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Al me vaćarav tumenđe ko dičhol ani aver džuvli te bi sovola lasa, već ćerda preljuba ano po ilo lasa. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ako inđarol tut ano greh ćiri desno jakh, ikal la thaj čhude la tutar. Po lačhe te hasare jekh kotor tutar, nego sa ćiro telo te avol čhudimo ani jag savi ni ačhol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ako inđarol tut ćiro desno va ano greh, čhin le thaj čhude le tutar. Po lačhe te hasare jekh kotor tutar, nego sa ćiro telo te džal ani jag savi ni ačhol.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","O Isus vadži vaćarda: “Gija šunden: ‘Ako neko mučhol pe romnja, nek dol la lil kaj ačhada la.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Al me vaćarav tumenđe: sa ko mučhol pe romnja – sem te voj ćerda blud – čhuvol la te ćerol blud. Thaj savo lol ačhade džuvlja, ćerol blud.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","O Isus vaćarda: “Vadži šunden sar si vaćardo amare puranenđe: ‘Ma phag i sovli thaj ćer okova so e Gospodese xaljan sovli.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Al me vaćarav tumenđe: Ma xan sovli nisar! Ma xan sovli ni e nebosa, golese kaj si presto e Devleso, ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ni phuvasa, golese kaj si tale pingre lese, ni e Jerusalimesa, golese kaj gova foro preperol e Devlese, e bare carose. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ni ćire šoresa ma xa sovli, golese kaj ni jekh bal našti ćere parno il kalo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Gija, tumaro ‘Va’ čače te avol ‘Va’, tumaro ‘Na’ čače te avol ‘Na’. Thaj so si pobut taro kava, taro bilačho si.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","O Isus vadži vaćarda: “Šunden sar si vaćardo: ‘Jakh jakhaće, dand dandese!’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Al me vaćarav tumenđe: Ma brani tut taro bilačho manuš. Ako ko čalavol tut tari desno čham, iri lese i aver čham. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Thaj ko manđol te sudil pe tusa thaj manđol te lol ćiro fostano, de le i ćiro ogrtači. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Thaj ako čhuven tut e rimska vojnikura te inđare lenđi oprema jekh kilometro, inđar la duj. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ko rodol tutar, de le thaj ma iri ćiro dumo taro okova so rodol tutar.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","O Isus vadži vaćarda: “Šunden sar si vaćardo: ‘Mang ćire pašutne’ thaj ma mang ćire dušmane! ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Al me vaćarav tumenđe: manđen tumare dušmanuren thaj molin tumen paše kola save tumen progonin! ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ako ćeren kava ka aven sar prava čhave tumare Dadese savo si ko nebo, golese kaj pe khamesa tatarol e bilačhen thaj e šukaren thaj bičhalol bršnd kolenđe save si čačutne thaj nepravedna. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Thaj ako manđen samo kolen save tumen manđen, savi plata isi tumen? Ni li ćeren gova e carincura? ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Thaj ako pozdravin samo tumare phralen, so ćere po šukar averendar? Ni li ćeren gova e manuša save ni pačan e Devle? ");
INSERT INTO rmyGurbet_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Thaj tumen aven gija savršena, sar so si tumaro Dad ko nebo savršeno.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","O Isus vadži vaćarda: “Pazin te ma ćeren tumare buća taro pravednost angle manuša von te dičhen tumen thaj te divin pe tumenđe. Te ćerden kava, ni ka avol tumen plata ke tumaro Dad savo si ko nebo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Golese kana de e čororenđe, ma galami angle tute, sar so ćeren e dujemujenđe ani sinagoga thaj pe droma te bi hvalina len e manuša. Čače vaćarav tumenđe, aver nagrada ni ka dobin sem goja tare manuša. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Thaj kana de e čororenđe, te ni džanol ćo levo va so ćerol o desno. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Gija te de garandoj e čororen thaj ćo Dad te dičhol kaj gova ćere čorale, a vov ka poćinol tuće.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","O Isus vadži vaćarda: “Thaj kana molin tumen, ma te aven sar kola dujemujenđe, save but manđen ke sinagoge thaj ke anglune droma ačhen thaj molin pe te dičhen len e manuša. Čače vaćarav tumenđe, aver nagrada ni ka dobin sem goja tare manuša. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","A tu, kana moli tut, dža ani ći soba kaj ka ave korkoro, phande ćo vudar thaj moli tut će Devlese savo si ano garajipe thaj ćo Dad savo dičhol ano garajipe, ka poćinol tuće. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Thaj kana molin tumen, ma vaćaren but lafura sar kola save ni džanen e Devlese, golese so von den gođi kaj ka aven uslišime paše but lafura. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ma aven sar von, golese kaj tumaro Dad džanol so trubul tumenđe i angleder nego so molin le. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Gija molin tumen: ‘Dade amareja, savo san ano nebo, nek svetil pe ćo alav. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Te avol ćiro Carstvo. Te avol ćiri volja, sar ko nebo, gija ki phuv. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Mangro savo trubul amen, de amen ađive ");
INSERT INTO rmyGurbet_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","thaj oprosti amare grehura, sar amen so oprosti kolenđe so grešin premal amende. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Thaj crde amen taro iskušenje, al ikal amen taro bilačhipe. Golese kaj si ćiro Carstvo, thaj zor, thaj i slava ane sa e đivesa. Amin.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Golese ako oprostin e manušenđe save grešin premal tumende, i o Dad tumaro o nebesko ka oprostil tumenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Al ako ni oprostin e manušenđe lenđe grehura, ni o Dad tumaro e grehura tumare ni ka oprostil.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","O Isus vadži vaćarda: “Thaj kana postin, ma aven sar e dujemujenđe so ćeren pe žalosna, golese so von ćeren žalosna muja te dičhen len e manuša kaj postin. Čače vaćarav tumenđe kaj aver nagrada ni ka dobin sem goja tare manuša. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Al tu kana posti, makh ćo šoro uljesa thaj thov ćo muj, ");
INSERT INTO rmyGurbet_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","te ni dičhen e manuša kaj posti, nego samo ćiro Dad, savo si ano garajipe. Thaj ćo Dad savo dičhol ano garajipe, ka poćinol tuće.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","O Isus vadži vaćarda: “Ma ćiden tumenđe barvalipe kate ki phuv, kaj o moljco thaj i rđa rumil thaj kaj e čora ka uljen thaj ka čoren. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ćiden tumenđe barvalipe ko nebo, kaj ni o moljco ni i rđa ni rumil thaj kaj e čora ni uljen thaj ni čoren. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Golese, kaj si ćo barvalipe, gothe ka avol ćo ilo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“I jakh si sar i svetiljka e telose. Ako si gija ćiri jakh sasti, sa ćo telo ka avol pherdo svetlosa. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Te si ći jakh bilačhi, sa ćo telo ka avol ano kalipe. Gijate, ako si o svetlost ane tute kalipe, tegani o kalipe ka avol but po baro ane tute!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ni jekh našti služil tari jekh drom dujen gospodaren. Il jekhe ka mrzil, a e dujtone ka manđol, il jekhe ka šunol, a e dujtone ni ka podnosil. Našti služin e Devle thaj o barvalipe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","O Isus vadži vaćarda: “Golese vaćarav tumenđe: Ma brinin tumen za tumaro džuvdipe, dal ka avol tumen so te xan il so te pijen, ni tumare telose so ka uraven! Naj li o džuvdipe po važno taro xape a o telo tare šeja? ");
INSERT INTO rmyGurbet_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Dičhen e čirikljen ko nebo! Ni sejin, ni ćiden thaj ni čhuven ane ambara thaj tumaro Dad ko nebo parvarol len. Naj li sen tumen po vredna lendar? ");
INSERT INTO rmyGurbet_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","A šaj li neko tumendar golesa so brinil pe te baravol po džuvdipe za jekh đive? ");
INSERT INTO rmyGurbet_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Thaj sose brinin tumen šejenđe? Dičhen šukar e luluđa ko polje sar baron. Khanči ni ćeren thaj ni suven šeja. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","A vaćarav tumenđe kaj ni o Solomon ani pi slava ni inđarda gija lačhe šeja sar kala luluđa. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","A ako o Dol uravol e biljke ko polje, so ađive si gothe, a theara ani kubava čhuden pe, kobor tek tumen ka uravol? Sose gaći zala pačan? ");
INSERT INTO rmyGurbet_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Golese, ma vaćaren ki dar: ‘So ka xa?’ il ‘So ka pija?’ il ‘So ka urava?’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Gija roden e manuša save ni džanen e Devlese, a tumaro Dad ano nebo džanol kaj sa kava trubul tumenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Golese angleder tare sa roden o Carstvo thaj o pravednost e Devleso thaj o Dol sa kava ka dol tumen. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ma brinin tumen e thearaće, i thearin nek brinil pe pese. Ađivesutni muka si dovoljno za ađive.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","A o Isus vadži vaćarda: “Ma sudin, te ma aven sudime. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Golese so o Dol ka sudil tumen sar so tumen sudin averen. Thaj save merasa ka merin averen, gasava merasa tumen ka meril o Dol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Sose dičhe i treska ane će phralesi jakh, a o kaš ani ćiri jakh ni dičhe? ");
INSERT INTO rmyGurbet_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Thaj sar šaj vaćare će phralese: ‘Ačh te ikalav i treska tar ćiri jakh’, a dikh, ćiro kaš ani jakh si po baro. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Dujemujengo! Ikal angleder ćiro kaš andari ćiri jakh, tegani po šukar ka dičhe te ikale će phralese i treska andari jakh. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ma den o svetipe e džuklenđe, golese so e džukle irindoj ka pharaven tumen ke kotora! Thaj ma čhuden e bisera angle bale, te ma uštaven len.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","O Isus vadži vaćarda: “Manđen thaj ka dol pe tumenđe! Roden thaj ka aračhen! Maren thaj ka putavol tumenđe! ");
INSERT INTO rmyGurbet_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Golese kaj savore save manđen, dol pe lenđe, save roden aračhen, save maren, putavol pe lenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ko tumendar pe čhavese ka dol bar kana bi rodola mangro? ");
INSERT INTO rmyGurbet_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","A te manglja mačhe dal ka dol le sape? ");
INSERT INTO rmyGurbet_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kana tumen, bišukar manuša, džanen šukaripe te den tumare čhaven, kobor tumaro Dad savo si ko nebo ka dol šukaripe pobut kolenđe save manđen lestar.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Gija, sa so manđen e manuša te ćeren tumenđe, tumen ćeren lenđe, golese kaj gova si o sikajipe tare sa e Mojsijaso zakon thaj e lila save pisisade e prorokura.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","O Isus vadži vaćarda: “Den ko tesno vudar! Golese kaj o bulo vudar thaj o bulo drom inđarol ano propast thaj but džene džan gole dromesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","But si tesno o vudar thaj o drom savo inđarol ano džuvdipe thaj zala si gola save aračhen le!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","O Isus vadži vaćarda: “Aračhen tumen tare xoxavne prorokura, save aven urade ane bakresi morčhi, al andral ane ile si divlja ruva save manđen te xan tumen. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Palo lengo bijandipe ka pindžaren len. Dal tare kangre šaj ćide drakha il tare čičke šaj ćide smokve? ");
INSERT INTO rmyGurbet_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ke gasavo način e lačhe kašta bijanen lačho bijandipe, a e bilačhe kašta bijanen bilačho bijandipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Našti e šukar kašta te bijanen bilačho bijandipe thaj bilačhe kašta te bijanen lačho bijandipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Gija, sa e kašta save ni bijanen lačho bijandipe, čhinen pe thaj čhuden pe ani jag. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Gijate palo lengo bijandipe ka pindžaren e xoxavne prorokuren.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","O Isus vadži vaćarda: “Ni ka dol dži jekh savo vaćarol ‘Gospode, Gospode’, ano Carstvo e neboso, nego ka den samo kola save šunen thaj ćeren o manglipe me Dadeso. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","But ka vaćaren ane gova đive ko sudo: ‘Gospode, Gospode! Na li ane ćo alav prorokuisadam? Ćire alavesa e benđen ikaldam thaj ćire alavesa but čuda ćerdam?’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","I tegani me ka phenav lenđe: ‘Nikad ni džangljem tumen. Džan mandar tumen save phađen e Devleso zakon.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","O Isus vadži vaćarda: “Golese, dži jekh savo šunol kala mingre lafura thaj ćerol len, vov si but džanglo, sar manuš savo ćerol po čher ko temelji taro bar. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Golese kana perol o bršnd thaj aven e paja thaj phurden e balvalja thaj čalaven ane gova čher, vov ni perol, golese kaj si o temelji po bar. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","A dži jekh savo šunol kala mingre lafura, a ni ćerol len, vov si sar dilo manuš, savo ćerol po čher pi pošik. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Golese kana perol o bršnd thaj aven e paja thaj phurden e balvalja thaj čalaven ane gova čher thaj o čher perol dži ko temelji.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Kana završisada kava vaćaripe o Isus, but manuša čudisajle so šunde leso sikajipe, ");
INSERT INTO rmyGurbet_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","golese kaj sikada sar kova savo isi le zuralipe, a na sar e učitelja tare Mojsijaso zakon. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","A kana o Isus ulilo taro brego, pale leste phirena but manuša. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tari jekh drom o gubavo manuš avilo thaj pelo ke pe koča thaj vaćarda: “Gospode! Ako manđe, šaj te sastare man!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","O Isus vazdija po va, dolda le thaj phenda: “Mangav. Av thodo!” Thaj o manuš sigate thodilo tari guba. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Tegani vaćarda lese o Isus: “Dikh te ma vaćare khanikase, nego tu dža i sikav tut e sveštenikose. Inđar žrtva sar so zapovedisada o Mojsije ano zakon bašo ćiro thodipe, te bi avola tut svedočanstvo angle lende.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","A kana o Isus avilo ano Kafarnaum, avilo paše leste jekh rimsko kapetano thaj rodija lestar pomoć. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Vaćarda lese: “Gospode, mo sluga pašljol paralizovano čhere thaj but mučil pe!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","A o Isus phenda lese: “Me ka avav te sastarav le.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Thaj o kapetano vaćarda: “Gospode! Naj sem dostojno te ave tali mi streja. Samo vaćar jekh lafi thaj mo sluga ka sastol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Golese kaj sem i me manuš tale nekaso autoritet thaj isi man tale mande vojnikura. Kana vaćarav jekhese: ‘Dža’, thaj džal. Kana vaćarav dujtonese: ‘Av’, thaj avol. Kana vaćarav mingre slugase: ‘Ćer’, thaj vov ćerol gova.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","A kana o Isus šunda kava, čudisajlo taro kapetano thaj vaćarda kolenđe so džana pale leste: “Čače vaćarav tumenđe, ni arakhljem ni jekhe ano Izrael kas isi gaći pačajipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","A vaćarav tumenđe, kaj but manuša taro sa o sveto, taro istok thaj taro zapad, ka aven thaj ka bešen ko astali ki bari gozba e Avraamesa, e Isaakosa thaj e Jakovesa ano Carstvo e neboso, ");
INSERT INTO rmyGurbet_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","a e čhave taro Carstvo ka aven čhudime avral thaj dur ano embaro mrako, gothe but ka roven thaj ka škripin dandencar.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","E kapetanose vaćarda o Isus: “Dža! Nek avol gija sar pačajan!” Thaj o sluga e kapetanoso ane gova sato sastilo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Thaj kana avilo o Isus ano čher e Petreso, dikhlja e Petrese sasuja sar pašljol thaj tresil la i groznica. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","O Isus dolda la taro va thaj tari jekh drom e Petrese sasuja i jag mukhlja. Voj uštili thaj služisada e Isuse. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","A kana peli i rat, anglo Isus ande pherdo manušen ane kaste sesa e bilačhe duxura. A vov pe lafesa tradija e bilačhe duxuren thaj sastarda sa e nasvalen, ");
INSERT INTO rmyGurbet_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","te pherdol kova so vaćarda o proroko Isaija: “Vov e slabostura amare lija thaj sa amaro nasvalipe inđarda.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Thaj kana dikhlja bute manušen paše peste, o Isus vaćarda pe sikadenđe te načhen ki aver rig taro jezero. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Thaj avilo jekh učitelji taro Mojsijaso zakon thaj phenda: “Učitelju, ka džav tusa kaj tu ka dža.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Thaj o Isus vaćarda lese: “E lisicen isi jazbine thaj e čiriklja e nebeska isi len gnezdura: Me o Čhavo e manušeso naj man kaj mo šoro te pašljarav.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","A aver tare sikade lese vaćarde lese: “Gospode! Mukh ma angleder te džav te prahov me dade.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","A o Isus vaćarda lese: “Av pale mande, a ačhav e mule, nek prahon pe mulen!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Tegani đelo o Isus ano čamco thaj pale leste đele lese sikade. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Bari balval tari jekh drom phurdija ko jezero thaj e talasura pherde o čamco pajesa. A o Isus suta. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","A e sikade avile paše leste, vazdije le taro sojipe thaj vaćarde lese: “Gospode! Ikal amen! Ka tasiva!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","O Isus vaćarda lenđe: “Sose but daraljen, sose gaći zala pačan?” Tegani uštilo thaj naredisada e balvaljaće thaj e pajenđe thaj avilo baro bišundipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","A e manuša čudisajle thaj vaćarde: “Savo si kava kaj šunen le e balvalja thaj e paja?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","A kana avilo ki aver rig e jezerosi ani phuv i gadarinsko, arakhlje e Isuse duj manuša ane kaste sesa e bilačhe duxura, save ikljona andare limora. Sesa gaći opasna te naštine khoni te načhol gole dromestar. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Gola duj džene dije vika: “So manđe amendar, Čhaveja e Devleso? Akari aviljan angleder o vreme te muči amen?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","A po dur lendar čarona pherdo bale. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Thaj e benga molisade e Isuse vaćarindoj: “Te tradijan amen, bičhal amen ane kola pherdo bale.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","A o Isus vaćarda lenđe: “Džan!” Thaj e benga iklile tare kala duj džene thaj đele ane bale. Thaj tari jekh drom sa e bale taro brego čhudije pe ano jezero thaj sa tasile. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","A e manuša save aračhena e balen našle, avile ano foro thaj sa so dikhlje odori vaćarde so sasa e manušencar ane kaste sesa e bilačhe duxura. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Thaj savore andaro foro avile pašo Isus, pa kana dikhlje le, molisade le te džal andaro lengo than. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Tegani o Isus dija ano čamco thaj nakhlo ki aver rig e jezerosi thaj irisajlo ane po foro. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Tegani nesave murša ande anglo Isus e manuše savo pašljola, golese so naštine te phirol. Thaj kana dikhlja o Isus lengo pačajipe, vaćarda e manušese savo pašljol: “Ma dara, mo čhavo, oprostin pe će grehura.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tegani nesave učitelja tare Mojsijaso zakon vaćarde ane peste: “Kava manuš hulil po Dol.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","O Isus džanglja so mislin thaj vaćarda lenđe: “Sose mislin bilačhe ane tumare ile? ");
INSERT INTO rmyGurbet_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Gija, so si poločhe te phenol pe: ‘Oprostime si ćire grehura’, il te phenol pe: ‘Ušti thaj phir’? ");
INSERT INTO rmyGurbet_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ka sikavav tumenđe mi zor, te džanen kaj isi man vlast, me o Čhavo e manušeso, ki phuv te oprostiv e grehura.” Irisajlo premalo manuš savo našti phirol thaj phenda lese: “Ušti, le ćo than kaj pašljiljan thaj dža tuće čhere.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Thaj o manuš savo naštine te phirol uštilo thaj đelo pese čhere. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","A kana gova dikhlje e manuša, but darajle thaj lije te hvalin e Devle, so dija gasavo vlast e manušenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Sar đelo o Isus gothar, dikhlja jekhe manuše sar bešlo ki carina, kaso alav sasa Matej thaj vaćarda lese: “Av pale mande!” O Matej uštilo thaj đelo pale leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Thaj kana o Isus xalja mangro ano čher e Matejeso, but carincura thaj grešnikura avile thaj xalje mangro e Isusesa thaj lese sikadencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Kana gova dikhlje e fariseja vaćarde lese sikadenđe: “Sose tumaro učitelji xal e carincurencar thaj e grešnikurencar?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","A o Isus šunda gova thaj vaćarda: “Ni trubul e sastenđe doktori, al e nasvalenđe trubul. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nego dičhen te sikljon so značil: ‘O milosrđe mangav a na samo žrtva.’ Golese, ni aviljem te akharav e pravednikuren nego e grešnikuren.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Tegani avile e Jovanese e Krstiteljese sikade pašo Isus thaj pučlje: “Sose ćire sikade ni postin sar so posti amen thaj e fariseja?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","O Isus lenđe vaćarda: “Šaj li kola so avile ko abav te aven žalna kana si lencar o džamutro? Al ka avol o đive kana lendar ka len e džamutre thaj tegani ka postin. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Khoni ni suvol nevo kotor e šejengo te učharol i rupa ko purano fostano. Golese kaj ka ćidol pe kana ka thovol pe thaj pobari rupa ka avol pale gova. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Thaj khoni ni čhorol nevi mol ane purane mehura, golese kaj e mehura ka pharadon a i mol ka čhordol. Nego nevi mol čhuvol pe ane neve mehura i gija i mol thaj e mehura ka aračhen pe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Dok gija o Isus vaćarda lencar, jekh šorutno e sinagogako avilo paše leste thaj pelo ke pe koča thaj vaćarda lese: “Mi čhej akana muli, al tu av, čhuv ćo va pe late thaj voj ka avol džuvdi.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Tegani uštilo o Isus thaj đelo palo šorutno pe sikadencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","A nesavi džuvli savi dešuduj berš sasa nasvali taro thavdipe o rat, nakhli pale Isuseso dumo thaj dolda le taro teluno kotor taro fostano. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Golese kaj vaćarda ane peste: “Samo te dolav man pe leso fostano, ka sastivav.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","A o Isus irisajlo thaj dikhlja e džuvlja thaj vaćarda laće: “Ma dara, mi čhej, ćo pačajipe sastarda tut.” Thaj i džuvli sastili ane gova sato. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kana avilo o Isus ane šorutneso čher, dikhlja e bašalnen thaj e manušen save den vika zurale. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Thaj vaćarda: “Crden tumen! Golese so i čhejori ni muli, nego sovol.” Al von marde muj lesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kana tradija e manušen avral, o Isus đelo andre, dolda la taro va thaj voj uštili. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","A tare gova so sasa šundilo o lafi ani sa goja phuv. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Kana o Isus đelo gothar, pale leste đele duj kore manuša thaj dije vika: “Smilui tu pe amende, Čhaveja e Davideso!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","A kana avilo ano čher, avile paše leste e kore thaj pučlja len o Isus: “Pačan li kaj me šaj te ćerav gova?” A von vaćarde lese: “Va, Gospode.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tegani dolda lenđe jakha thaj vaćarda: “Palo tumaro pačajipe nek avol tumenđe!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Thaj putajle lenđe jakha. Thaj o Isus zurale pretisada len: “Dičhen te ma vaćaren khanikase.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Al von kana iklile, vaćarde savorenđe ani sa goja phuv. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Kana von iklile, ande anglo Isus manuše lalore ane savo sasa o bilačho duxo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Thaj o Isus ikalda e benđe, tegani lija te vaćarol o laloro. Thaj but džene sesa oduševime thaj vaćarde: “Kava ni dikhljam vadži ano Izrael.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","A e fariseja vaćarena: “Vov tradol e benđen ano pomoć e šorutnesa tare benga.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","O Isus đelo pe sa e forura thaj e gava thaj sikada e manušen ane lenđe sinagoge. Sikada taro Lačho Lafi taro Carstvo thaj sastarda tare svako nasvalipe thaj bizuralipe ane manuša. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","A kana dičhola e manušen sasa le žal lenđe, golese kaj sesa hasarde thaj mukhle sar bakre bizo pastiri. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Tegani vaćarda pe sikadenđe: “Ćidipe si but baro al bućarne si zala. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Molin tumen e gospodarese taro ćidipe te bičhalol bute bućarnen ke piro ćidipe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","O Isus dija vika pe dešuduje (12) sikaden thaj dija len zuralipe te traden e bilačhe duxuren, te sastaren sa o nasvalipe thaj sa o bizuralipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","A kava si e alava tare dešuduj apostolura: Angluno o Simon savo akharol pe Petar thaj o Andrija leso phral, o Jakov e Zevedejeso čhavo thaj leso phral o Jovan, ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","o Filip thaj o Vartolomej, o Toma thaj o Matej o carinco, o Jakov e Alfejeso čhavo thaj o Tadej, ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","o Simon o Zilot thaj o Juda o Iskariotsko, so izdajisada e Isuse. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Bičhalda o Isus kale dešudujen sikaden thaj naredisada lenđe: “Ma džan ke abandžije thaj ma džan ki ni jekh foro o Samarijansko. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Nego džan ke hasarde bakre tare Izraelska manuša. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Džan thaj propovedin: ‘Sigate avol o Carstvo e neboso.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","E nasvalen sastaren, e mulen vazden, e gubavonen thoven, e benđen traden. Badava dobisaden, badava den. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ma čhuven te inđaren tumencar ni zlatna, ni srebrna, ni bakarna parave ane tumare kuštika, ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ni trasta ko drom, ni dujto gad ni duj para sandale, ni rovli, golese kaj si o bućarno dostojno pe plataće. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ane savo foro il gav aven, roden ko ka primil tumen, gothe ačhen sa dži kaj ni džan tar gova than. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","A kana džan ano čher, vaćaren: ‘Mir kale čhereste.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Thaj te primisade tumen, ka avol tumaro mir ane gova čher. Te ni primisade tumen, o mir tumaro ka iril pe tumenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","A kaj ni manđen tumen, niti šunen tumen so phenen lenđe, ikljen taro gova čher il foro em tresin o praho tare tumare pingre, te ma bi avola tumen khanči lencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Čače vaćarav tumenđe, ko Sudnjo đive po ločhe ka avol e manušenđe ani Sodoma thaj ani Gomora nego e manušenđe ane thana save ni šunde tumen!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","O Isus vadži vaćarda: “Dičhen, me bičhalav tumen sar bakren maškare ruva. Golese aven but džanglje sar sapa, a birumime sar o golubo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Aračhen tumen, golese kaj nesave manuša ka den tumen ke sudura thaj ke sinagoge ka aven bičujime. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Baše mande ka ikalen tumen angle vladara thaj angle carura te bi svedočina lenđe thaj kolenđe save si abandžije. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","A kana ka phanden tumen, ma daran tegani sar thaj so ka vaćaren, golese ane gova sato ka dol pe tumenđe so te vaćaren. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Golese so tumen ni ka vaćaren, nego ka vaćarol andar tumende o Duxo tumare Dadeso savo si ko nebo! ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","O phral e phrale ka dol te mudarol pe thaj o dad e čhave. E čhave ka ušten pe dada thaj pe deja, a von ka den te mudaren len. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Thaj khoni ni ka manđol tumen me alavese, a ko ačhol dži ko krajo pačavno, ka spasil pe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Thaj kana traden tumen ane jekh foro, našen ane aver! Golese kaj vaćarav tumenđe čače: Ni ka resen te ćeren tumari bući ane sa e forura ano Izrael dok ni avav me, o Čhavo e manušeso. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ni jekh sikado naj po baro tare po učitelji, ni sluga upreder po gospodari. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Dosta si e sikadese te avol sar po učitelji thaj o sluga sar po gospodari. Kana man e šorutne e čhereso akharen ‘Veelzevul’, kobor po bilačhe ka akharen tumen, mingre čherutnen?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","O Isus vadži vaćarda: “Ma daran tare manuša, golese so naj gova so si garado a so ni ka avol putardo thaj naj gova so si čorale so ni ka šundol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","So vaćarav tumenđe ano mrako, vaćaren ano svetlo. Thaj so vaćarav tumenđe po zala ko kan, tumen vaćaren zurale pe krovura. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ma daran kolendar so mudaren o telo a i duša našti mudaren. Daran kolestar sostar šaj i duša thaj o telo te uništil pe ani jag savi ni ačhol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ni li bićindol i čirikli emcikne paraće? Thaj ni jekh našti perol ki phuv bizo dopuštenje tumare Dadeso savo si ko nebo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","A tumare sa e bala ko šoro si đinde. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ma daran, golese kaj sen tumen but po vredna tare čiriklja.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","O Isus vadži vaćarda: “Gija, ko man priznajil angle manuša kate ki phuv, me ka priznajiv le anglo mo Dad savo si ano nebo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","A ko odreknil pe mandar angle manuša kate ki phuv, me ka odrekniv man lestar anglo mo Dad savo si ko nebo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","O Isus vadži vaćarda: “Ma te den gođi kaj me aviljem te anav mir ki phuv. Ni aviljem te anav mir nego mačo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Aviljem te ulavav: ‘e manuše taro dad leso thaj e čheja tari dej laći thaj e bora tari sasuj laći. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","E manušese dušmanura ka aven e čherutne lese.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ko po but manđol pe dade thaj pe da mandar, naj dostojno te avol mo sikado. Thaj ko manđol pe čhave il pe čheja po but mandar, naj dostojno te avol mo sikado. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ko ni lol po krsto i ni džal pale mande, naj dostojno te avol mo sikado. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ko manđol te aračhol piro džuvdipe, ka hasarol le, al ko hasarol piro džuvdipe paše mande, ka aračhol le.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","O Isus vadži vaćarda: “Ko tumen primil, man primil, a ko primil man, primil e Devle so man bičhalda. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ko primil e proroko golese kaj si proroko, plata proročko ka primil. Ko primil e pravedniko golese so si pravedno, pravedničko plata ka primil. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ko dol samo jekh tahtaj šudre pajesa emcikne manuše golese so si mingro sikado, čače vaćarav tumenđe, lesi nagrada ni ka hasardol.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Kana o Isus završisada te sikavol pe dešuduje (12) sikaden, đelo gothar te sikavol thaj te vaćarol e Devleso Lafi ane forura e Galilejska. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","A kana o Jovan o Krstitelj sasa phanglo, šunda e Hristese buća thaj bičhalda pe sikaden ");
INSERT INTO rmyGurbet_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","te pučen le: “Tu li san gova savo trubul te avol, il te ađućara avere?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","A o Isus vaćarda e Jovanese sikadenđe: “Džan i vaćaren e Jovanese so šunen thaj so dičhen: ");
INSERT INTO rmyGurbet_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","‘E kore dičhen, e banđe phiren, e gubava thodon, e kašuće šunen, e mule ušten, a e čororenđe vaćarol pe o Lačho Lafi. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Blago kolese savo ni sablaznil pe mandar!’ ” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","A kana e Jovanese sikade đele, lija o Isus te vaćarol e manušenđe taro Jovane: “So ikliljen te dičhen ki pustinja? I trska, savi banđol ki balval? Na. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Il so ikliljen te dičhen? Manuše savo urado ane barvale šeja. Na, kola save inđaren barvale šeja bešen ke carska čhera. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Il so ikliljen te dičhen? E proroko? Va, me vaćarav tumenđe, po but taro proroko. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Golese so si o Jovane manuš kastar o Dol vaćarda ane piro Sveto lil: ‘Akh, me bičhalav angle tute me glasniko, savo ka pripremil tuće o drom.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Čače vaćarav tumenđe: nijekh maškare sa save si bijande naj po baro taro Jovane o Krstitelj, a emcikno ano Carstvo e neboso si po baro lestar! ");
INSERT INTO rmyGurbet_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","A taro vreme e Jovaneso e Krstiteljeso dži akana, o Carstvo e neboso trpil nasilje thaj e nasilna manuša grabin te len le. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Golese, kaj sa e prorokura thaj e Mojsijaso zakon prorokujisade taro Carstvo dži o Jovane. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Thaj te mangljen te pačan, vov si kova Ilija savo trubuja te avol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kas isi kana te šunol nek šunol.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“A kasa te uporediv e ađivesutne manušen? Von si sar čhavore save bešen ko trgo e foroso thaj den vika jekh avere: ");
INSERT INTO rmyGurbet_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Bašaldam tumenđe vesela đilja, a tumen ni čhelden. Đilabijam tumenđe žalna đilja, a tumen ni rujen.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Golese kaj, avilo o Jovane, savo ni xalja šukaripe thaj ni pijola mol, a von vaćaren: ‘O beng si ane leste.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Tegani aviljem me, o Čhavo e manušeso, savo xav šukaripe thaj pijav mol, a tumen vaćaren: ‘Dikh manuš xalano thaj mato! Amal e carincurengo thaj avere grešnikurengo!’ Al e Devleso mudrost ka opravdilpe pe bućencar.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tegani lija o Isus te koril e manušen ane forura ane save ćerda embare čudura, golese so von ni pokaisajle: ");
INSERT INTO rmyGurbet_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Pharo tumenđe manušalen taro Horazin! Pharo tumenđe manušalen, tari Vitsaida! Golese kaj e Tirose thaj e Sidonese manušenđe te avena gasave čudesura sar ke tumende, odavno bi pokajina pe thaj bi uravena pe ane pokajnička šeja thaj pe po šoro bi čhorena pese praho pašo pokajipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","A vaćarav tumenđe, po ločhe ka avol e manušenđe taro Tir thaj e manušenđe taro Sidon ko đive e bare sudose nego tumenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","A tumen manušalen taro Kafarnaum! Dži o nebo li ka ušten? Na! Dži o than kaj si e mule ka peren. Golese te avena gaći čudura ani Sodoma kobor sesa maškar tumende thaj von bi pokajina pe, pa bi ačhola i Sodoma sa dži ađive. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","A vaćarav tumenđe kaj po ločhe ka avol e manušenđe tari phuv i Sodoma ko đive e bare sudose nego tumenđe!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ane gova vreme vaćarola o Isus: “Hvaliv tut, Dade, Gospode taro nebo thaj tari phuv, so kava garadan tare but gođavera thaj tare haljarde a sikadan gova e ciknenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Va, Dade, gova sasa ćiro manglipe te ćere gija. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Manđe mo Dad dija sa. Khoni ni džanol e Čhave dži o Dad, ni e Dade ni džanol khoni dži o Čhavo thaj kase o Čhavo manđol te sikadol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Aven mande savore save sen umorna thaj tovarime, me ka odmoriv tumen. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Len mingro jaram pe tumende thaj sikljon mandar golese kaj sem kovlo thaj ponizno ano ilo thaj ka aračhen mir ane tumare duše. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Golese kaj mingro jaram si lokho thaj mo pharipe naj pharo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ane gova vreme phirola o Isus pe sikadencar ko savato maškaro điv, a lese sikade bokhajle thaj lije te čhinen o điv thaj te xan. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","A nesave fariseja dikhlje gova thaj vaćarde lese: “Dičhe, e sikade ćire ćeren so naj dozvolimo ko savato!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","A o Isus vaćarda lenđe: “Džanav kaj čitisaden so ćerda o David, kana bokhajlo vov thaj lese amala. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Kana đelo andre ano Čher e Devleso, e mangre save čhuvena pe sar žrtva von xalje, a naj sasa šukar te xan ni vov ni kola so sesa lesa. Gola mangre šajine te xan samo e sveštenikura. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Džanav kaj čitisaden ane Mojsijaso zakon kaj e sveštenikura ano Hram o savato savo si sveto phađen, gija so služin ane gova đive a palem naj banđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Me vaćarav tumenđe kaj si kate kova savo si po baro taro Hram! ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kana bi samo džanena so si gova: ‘O milosrđe mangav a na samo žrtva’, nikad ne bi osudina kolen save naj grešna. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Golese kaj man, e Čhave e manušese, isi man vlast po savato.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Pale gova đelo o Isus gothar thaj avilo ane lenđi sinagoga. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","A sasa gothe manuš šuće vastesa. E fariseja pučlje e Isuse: “Šaj li ko savato te sastarol pe?” Gija von rodije khanči te tužin e Isuse. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","A vov vaćarda lenđe: “Savo tumendar ako isi le jekh bakri pa ako voj ko savato perol ani rupa ni ka lol te ikalol la? ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","A kobor si o manuš po baro taro bakro! Gija si mukhlo ko savato šukar te ćerol pe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tegani o Isus vaćarda gole manušese: “Pruži ćiro va!” I vov pružisada piro va thaj leso va sastilo sar o dujto va. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","A e fariseja iklile te dogovorin pe sar te mudaren le. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","A o Isus gova dodžanglja thaj đelo gothar. Pale leste đele but manuša thaj e nasvalen maškar lende sastarda. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","A naredisada lenđe te ma vaćaren ko si vov. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Gija pherdilo kova so vaćarda o proroko o Isaija: ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Dikh, kava si mingro manglo Sluga, save me birisadem. Mingro manglo, Vov si mo radujipe. Mo Duxo ka čhuvav pe leste. Vov ka objavil i pravda sa e manušenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ni ka ćerol čingara, ni ka vazdol po glaso, ke droma khoni ni ka šunol leso glaso. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ni uštadi trska ni ka phađol, ni ka ačhavol o žaro savo pozala phabol, sa dži kaj ni anol i pravda dži ki pobeda. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ane leso alav ka avol nada sa e manušenđe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tegani ande angle leste manuše ane kaste sasa bilačho duxo thaj gova manuš sasa koro thaj laloro. O Isus sastarda le, gija gova manuš lija te vaćarol thaj te dičhol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Sa e manuša so gova dikhlje, sesa zadivime thaj pučlje pe: “Naj li gova o Čhavo e Davideso?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","A kana gova šunde e fariseja, vaćarde: “Kava tradol e benđe ano pomoć e Veelzevuleso, savo si šorutno tare bilačhe duxura.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","A o Isus džanglja so mislin thaj vaćarda: “Dži jekh carstvo savo ulavol pe korkoro pestar, ka ačhol pusto thaj svako foro il familija savi ulavol pe korkori pestar, ka properol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Thaj te o Satana e Satane tradol, korkoro pes ulavol, sar ka ačhol o carstvo leso? ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Thaj čače, te Veelzevulesa tradav e benđen, kasa traden tumare čhave e benđen? Golese von ka aven sudije tumare. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Al ako li me e Devlese Duxosa tradav e benđen, tegani o Carstvo e neboso avilo maškar tumende. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Il sar šaj khoni te avol ano čher e zurale manušese thaj te čorol leso barvalipe, te angleder ni phandol e zurale manuše? Thaj tegani sa andaro čher šaj te čorol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Savo naj mancar, protiv mande si. Savo ni ćidol mancar, čhorol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Golese vaćarav tumenđe, sa e grehura thaj i hula šaj oprostil pe e manušenđe, al i hula po Sveto Duxo ni ka oprostil pe e manušenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Thaj savo vaćarol bilačho lafi po Čhavo e manušeso, šaj oprostil pe lese, a savo vaćarol bilačhe po Sveto Duxo ni ka oprostil pe lese, ni ke kava ni ko aver sveto.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","O Isus vadži vaćarda: “Sadi lačho kaš thaj leso bijandipe ka avol šukar thaj te sadisadan kaš bilačho, leso bijandipe ka avol bilačho. Golese kaj palo bijandipe pindžarol pe o kaš. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Tumen, e sapese čhave! Sar šaj te vaćaren šukar, kana sen bilačhe? Golese kaj o muj vaćarol sosa si pherdo o ilo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Šukar manuš tari šukar riznica e ilesi ikalol šukaripe, a bilačho manuš tari bilačhi riznica e ilesi ikalol bilačhipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","A phenav tumenđe: e manuša, baše dži jekh bikorisno lafi savo vaćaren, ka den računo ko sudnjo Đive. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Čače, će lafesa ka ave opravdime il će lafura ka osudin tut.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Pale gova nesave učitelja tare Mojsijaso zakon thaj e fariseja vaćarde: “Učitelju! Amen manga te dikha tutar nesavo znako.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","A vov vaćarda lenđe: “O bilačho thaj preljubničko bijandipe rodol znako thaj ni ka dol pe aver znako samo o znako savo sasa e prorokose e Jonase. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Sar o Jona so sasa ano vođi e bare mačheso trin đive thaj trin raća, gija i me, o Čhavo e manušeso, ka avav ani phuv trin đive thaj trin raća. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","E murša tari Niniva ka ušten ko Sudo kale bijandimasa thaj ka osudin len, golese kaj pokaisajle kana šunde e Jonaso sikajipe. Thaj dikh, kate tumencar si po baro taro Jona! ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","I Carica taro Jug ka uštol ko Sudo kale bijandimasa thaj ka osudil len, golese kaj avili voj tar aver rig e phuvaći odural te šunol o mudrost e Solomoneso. Thaj dikh, kate tumencar si po baro taro Solomon!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Kana o bilačho duxo ikljol andaro manuš, džal ke šuće thana te rodol than pašo odmor thaj ni aračhol le. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Tegani vaćarol: ‘Ka irima ano čher kotar ikliljem.’ Kana avol, dičhol o čher kaj si čučo, šulado thaj lačhardo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tegani o bilačho duxo džal thaj anol pesa efta averen duxuren po bilačhe pestar. Savore aven andre te bešen thaj e manušese kastar iklilo o bilačho duxo, akana si but po bilačhe nego so sasa lese. Gijate ka avol e bilačhe bijandimasa.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Dži kaj o Isus vaćarola e manušenđe, lesi dej thaj lese phrala avile, ačhile avral thaj manglje te vaćaren lesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Thaj khoni vaćarda lese: “Akh ći dej thaj će phrala ačhen avral. Manđen te vaćaren tusa.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","A vov vaćarda kolese so phenda lese: “Ko si mi dej? Ko si me phrala?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Thaj sikada vastesa premal pe sikade thaj vaćarda: “Akh mi dej thaj me phrala. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Dži jekh savo ćerol o manglipe me Dadeso savo si ko nebo, vov si mo phral, mi phen thaj mi dej.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ane gova đive iklilo o Isus taro čher thaj bešlo pašo jezero te sikavol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","But manuša ćidije pe paše leste, golese đelo ano čamco, bešlo a von ačhile ki obala. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Thaj but vaćarda lenđe ane paramiča sar kaja: “Dikh, iklilo o manuš savo sejil. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Thaj kana sejisada, nesave semenura pele ko drom, thaj avile e čiriklja thaj sa xalje len. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","A avera pele pe barale thana, kaj ni sasa but phuv thaj o seme sigate barilo, golese kaj ni sasa duboko phuv. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Thaj kana o kham sasa zuralo, i biljka phabili thaj šućili golese kaj ni sasa la duboko koreno. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Nesavo seme pelo ane kangre, al barile kangre thaj i biljka tasadili. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","A nesavo seme pelo ki šukar phuv thaj anda bijandipe savo sasa tranda (30), šovardeš (60) thaj šel (100) droma po baro taro kova so sejisade. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kas isi kana te šunol nek šunol.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tegani avile pašo Isus lese sikade thaj pučlje le: “Sose tu vaćare lenđe ane paramiča?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","A vov vaćarda: “Tumenđe dija pe te džanen so si garajipe taro Carstvo e neboso, a lenđe ni dija pe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Golese, kas isi džanglipe ka dol pe lese thaj ka avol le po but. A kas naj džanglipe, ka lol pe i kova so isi le. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Golese me vaćarav lenđe ane paramiča, golese kaj e manuša dičhen a ni dičhen thaj šunen a ni šunen thaj ni haljaren. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Thaj gija pherdol o proroštvo savo o Dol dija e Isaijase, savo vaćarol: ‘Ka šunen thaj ka šunen, al ni ka haljaren, ka dičhen thaj ka dičhen, al ni ka shvatin. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Golese kaj zurajle e ile kale manušenđe, phareste šunen pe kanencar, thaj phanglje pe jakha, te ni dičhen jakhencar, thaj kanencar te ni šunen, thaj ilesa te ni haljaren, thaj te ni irin pe premal mande te sastarav len.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","A blago tumare jakhenđe golese so dičhen thaj tumare kanenđe so šunen. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Čače vaćarav tumenđe, kaj but prorokura thaj čačutne sa e ilesa manglje te dičhen so tumen dičhen, a ni dikhlje thaj te šunen so tumen šunen, a ni šunde. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Šunen akana, so značil i paramič taro manuš savo sejil. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Kana khoni šunol o Lafi taro Carstvo thaj ni haljarol, avol o beng thaj čhorol so si sejimo ano leso ilo. Gova si o seme so si po drom sejimo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","A o seme savo si sejimo ko baralo than si gova savo šunol o Lafi e Devleso thaj sigate ano radujipe lol pese gova. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Al naj le koreno ane peste thaj ni ačhol but. Kana avol o bilačhipe il traden le pašo Lafi, sigate perol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kova seme savo si sejimo ane kangre si gova savo šunol o Lafi, al e brige kale svetose thaj o xoxaipe e barvalimaso tasaven o Lafi thaj ačhol bizo bijandipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","A o seme savo si sejimo ki lačhi phuv si gova savo šukar šunol o Lafi thaj haljarol le. Tegani čače anol šukar bijandipe a jekh seme anol po šel (100) semenura, nesavo seme anol po šovardeš (60) semenura thaj nesavo seme bijanol po tranda (30) semenura.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","O Isus vaćarda lenđe aver paramič: “O Carstvo e neboso si sar manuš savo sejisada lačho seme ane po polje. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","A kana e manuša sute, avilo leso dušmano, sejisada kukolj maškaro điv thaj đelo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kana barilo o điv thaj anda bijandipe, sikadilo thaj o kukolj. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Tegani avile e manuša save služin e manuše kaso sasa o polje thaj vaćarde lese: ‘Gospodarona, na li šukar seme tu sejisadan ani ćiri njiva? Kotar akana kukolj?’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","A vov vaćarda lenđe: ‘O dušmano gova ćerda.’ A e manuša save služin vaćarde lese: ‘Manđe li akana te dža te ikala o kukolj?’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","A vov vaćarda: ‘Na, te ikalden o kukolj, šaj te ikalen o điv. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ačhaven nek baron katane dži ko ćidipe thaj ko vreme e ćidimaso ka vaćarav kolenđe so ćiden: Ćiden angleder o kukolj thaj phanden le ke snopura te phabarav le, a o điv čhuven ano than kaj čhuvav mingro điv.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","O Isus vaćarda lenđe vadži jekh paramič: “O Carstvo e neboso si sar jekh seme tari gorušica, savo lol o manuš thaj sejil ki piri njiva. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","A vov si čače emcikno tare sa e semenura, al kana barol, po baro si tare sa e biljke ano vrt thaj kana ćerdol kaš, e čiriklja e nebose aven thaj ćeren gnezdura thaj bešen pe lese granke.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Pale gova vaćarda vadži jekh paramič: “O Carstvo e neboso si sar kvasaco savo lol i džuvli thaj čhuvol ane biš (20) kile aro sa dži kaj ni uštol o humer.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Sa kava o Isus vaćarola e manušenđe ane paramiča. Thaj bize paramiča khanči ni vaćarda lenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Gijate pherdilo gova so o proroko vaćarda: “Ka putrav ane paramiča mo muj, ka vaćarav kova so si garado taro postanko e svetoso.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","O Isus ačhada e manušen thaj đelo ano čher. Avile paše leste lese sikade thaj vaćarde: “Sikav amen so si i paramič taro kukolj ani njiva.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","A vov vaćarda lenđe: “Gova savo sejil lačho seme si o Čhavo e manušeso ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","thaj i njiva si o sveto. Lačho seme si e čhave e Devlese carstvose, a o kukolj si e čhave e benđese. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","A o dušmano savo sejisada len si o beng, a o ćidipe si o kraj e svetoso, a kola so ćiden si e anđelura. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Sar o kukolj ćidol pe thaj jagasa phabarol pe, gija ka avol ko krajo e svetoso. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Me o Čhavo e manušeso ka bičhalav me anđeluren thaj von ka ćiden tare mingro Carstvo sa e manušen save čhuvena averen pe grehura thaj save phađena e Devleso zakon. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Thaj ka čhuden len ani jagali kubava. Thaj gothe but ka roven thaj ka škripin dandencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tegani e pravedna manuša ka sijajin sar o kham ano Carstvo pe Dadeso. Kas isi kana nek šunol.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","O Isus vadži vaćarda: “O Carstvo e neboso si sar barvalipe garado ano polje. Kana o manuš arakhlja le, palem garada le thaj radosno džal thaj biknol sa so isi le te bi ćinola gova polje.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","O Isus vaćarda: “Vadži si o Carstvo e neboso sar trgovco savo rodol šukar bisera. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Pa kana aračhol jekh but kuč biseri, džal sa biknol so isi le thaj ćinol le.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","O Isus vaćarda: “Vadži o Carstvo e neboso si sar mreža savi čhudol pe ano more thaj dolol tare sa e vrste mačhe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kana pherdol, ikalen i mreža upre pi obala thaj bešen. E lačhe mačhen save ikalde čhuven ane čare, a e bilačhen čhuden palal. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Gija ka avol ko krajo e svetoso. Ka ikljen e anđelura, ka crden e bilačhe manušen tare čačutne ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","thaj ka čhuden len ani jagali kubava. Gothe but ka roven thaj ka škripin dandencar.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Pučlja len o Isus: “Haljarden li sa kava?” Vaćarde lese: “Va, Gospode.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","A vov vaćarda lenđe: “Golese svako učitelji taro Mojsijaso zakon savo avol sikado taro Carstvo e neboso, ka avol sar čherutno savo ikalda andari pi riznica o nevo thaj o purano barvalipe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Thaj kana o Isus vaćarda sa kala paramiča, đelo gothar. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Đelo ano than kaj barilo, sikada ani lenđi sinagoga a e manuša sesa but zadivime thaj vaćarde: “Kotar lese gasavo džanglipe thaj zuralipe? ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Naj li kava e kaštunaleso čhavo? Naj li lesi dej i Marija thaj lese phrala o Jakov, o Josif, o Simon thaj o Juda? ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Lese pheja naj li akate maškar amende? Kotar lese sa kava?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Thaj golese ni prihvatisade le. A o Isus vaćarda lenđe: “O proroko si bizo čast samo ano than kaj barilo thaj ano čher piro.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Thaj ni ćerda but čudura gothe golese kaj sesa bipačavne. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ane gova vreme avilo o glaso dži ko vladari o Irod o Antipa taro Isus, ");
INSERT INTO rmyGurbet_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","thaj vaćarda pe manušenđe save služin le: “Gova si o Jovane o Krstitelj; vov uštilo tare mule thaj golese šaj ćerol kala čudesura.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Golese o Irod čhuta angleder te dolen e Jovane, phanglja le thaj čhudija le ano phanglipe baši Irodijada i romni e Filipesi savo sasa e Irodeso phral, ");
INSERT INTO rmyGurbet_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","golese kaj o Jovane but droma vaćarda lese: “Premalo zakon, našti la te le romnjaće.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","O Irod manglja te mudarol e Jovane, al darajlo tare manuša golese so smatrisade le sar proroko. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","A kana sasa bijandođive e Irodeso, čhelda i čhej e Irodijaći angle leste thaj angle gostura. E Irodese sasa šukar. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Golese xalja sovli kaj ka dol la sa so manđol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","A voj, sikadi tari pi dej vaćarda: “Dema ko čaro o šoro e Jovaneso e Krstiteljeso.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Thaj o caro sasa ožalostime, al golese kaj ni manglja te phađol i sovli savi dija angle gostura, naredisada pe slugenđe te ćeren sa so voj manđol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Thaj bičhalda te čhinen e Jovaneso šoro ano phanglipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","E sluge ande e Irodese e Jovaneso šoro ko čaro, dije le e čhejaće thaj voj dija le pe daće. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Pale gova avile e sikade e Jovanese, lije leso telo thaj prahosade le. Tegani avile thaj vaćarde gova e Isusese. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Kana šunda o Isus so sasa e Jovanesa e Krstiteljesa, đelo gothar čamcosa ko pusto than, te bi avola korkoro. Thaj kana gova šunde e manuša, đele pale leste phirindoj tare forura. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Kana o Isus iklilo andaro čamco, dikhlja bute manušen, pelo lese žal lenđe thaj sastarda lenđe nasvalen. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Angli rat avile lese sikade thaj vaćarde lese: “Kava si pusto than, a akana si kasno. Mukh e manušen, nek džan ane gava te ćinen pese xamase!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","A o Isus vaćarda lenđe: “Ni trubun te džan. Den len tumen te xan!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","A von vaćarde lese: “Akate isi amen samo pandž mangre thaj duj mačhe!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","A vov vaćarda lenđe: “Anen manđe gova akari!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Thaj e manušenđe vaćarda te bešen ki čar. Lija kola pandž mangre thaj e duj mačhe, dikhlja ano nebo, zahvalisada e Devlese bašo xape thaj phaglja o mangro. Tegani o Isus dija len e mangre a e sikade ulade e manušenđe te xan. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Savore xalje thaj čalile. A pale gova e sikade ćidije dešuduj (12) korpe pherde kotora so ačhile. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","A kola so xalje sesa pandž milje (5 000) manuša, a gothe ni sesa đinde e romnja thaj e čhavore. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Pale gova sigate, terisada o Isus pe sikaden te den ano čamco thaj te džan angle leste ki aver rig e jezerosi, dži kaj vov mučhol e manušen te džan pe dromesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kana mukhlja e manušen, uštilo ko brego te avol korkoro te molil pe. Thaj ki rat gothe sasa korkoro. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","A o čamco e sikadencar sasa dur tari obala thaj e talasura čalade ano čamco, golese so premal leste phurdija bari balval. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","A maškare trin em šov o sato sabalje, đelo o Isus premal lende phirindoj po paj. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Thaj kana dikhlje e sikade sar phirol po jezero premal lende, darajle thaj vaćarde: “Gova si omaja!” Darajle thaj lije te den vika. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","A o Isus sigate phenda lenđe: “Šukar si! Me sem, ma daran!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","A o Petar vaćarda lese: “Gospode! Ako san tu, vaćar manđe te phirav po paj!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","A o Isus vaćarda lese: “Phir!” O Petar iklilo taro čamco thaj phirda po paj thaj đelo premalo Isus. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Al kana dikhlja i bari balval, darajlo thaj lija te properol ano paj thaj dija vika: “Gospode, pomoži manđe!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Thaj sigate o Isus pružisada po va te dolol e Petre thaj vaćarda lese: “Sose gaći zala pača, sose sumnjisadan?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Thaj kana dije ano čamco, i balval ačhili. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Kola save sesa ano čamco, pele ke pe koča thaj vaćarde: “Čače tu san o Čhavo e Devleso!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Thaj kana nakhle o paj, avile ani phuv i Genisaretsko. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Kana pindžarde le e manuša tare gova than, vaćarde ani sa goja phuv kaj avilo o Isus thaj ande paše leste e nasvalen. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Thaj molisade le samo te dolen pe taro teluno kotor tare leso fostano. Thaj savore save dolde le, sastile. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tegani avile ko Isus e fariseja thaj e učitelja tare Mojsijaso zakon taro Jerusalim thaj pučlje le: ");
INSERT INTO rmyGurbet_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Sose ćire sikade phađen e adetura tare amare purane? Ni ićaren o adeti te thoven pe vasta angleder so ka xan mangro!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","A o Isus vaćarda lenđe: “Sose tumen baše tumare adetura phađen e Devleso zakon? ");
INSERT INTO rmyGurbet_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Golese kaj o Dol vaćarda: ‘Poštuji će dade thaj će da,’ thaj ‘ko akušol pe dade il pe da te avol kaznimo merimasa!’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","A tumen vaćaren: ‘Vaćarol li khoni pe dadese il pe daće: O pomoć mandar so trubul te dav tumen, xaljem sovli, kaj ka dav sar daro e Devlese,’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","naj dužno te sikavol poštujipe gija so ka dičhol so trubul e dade em e deja. Gija zanemarin e Devleso Lafi paše tumare adetura. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Dujemujenđe! Šukar prorokujisada tumendar o Isaija, kana vaćarda: ");
INSERT INTO rmyGurbet_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Kala manuša poštujin man samo vuštencar, a lenđe ile si dur mandar. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Džabe poštujin man golese kaj si lengo sikajipe manušikane pravilura.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Pale gova o Isus dija vika e manušen thaj vaćarda lenđe: “Šunen thaj haljaren, ");
INSERT INTO rmyGurbet_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ni meljarol e manuše anglo Dol kova so dol lese ano muj, nego e manuše meljarol kova so ikljol lese andaro muj.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tegani avile lese sikade thaj phende: “Džane li kana šunde e fariseja gova lafi, uvredisajle?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","A vov phenda lenđe: “Svako biljka savi ni sadisada o Dad mingro ko nebo, ka ikalol pe andari phuv. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mučhen len! Von si kore manuša thaj vodin e koren. A o koro našti inđarol e kore, golese kaj solduj ka peren ani rupa.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","A o Petar vaćarda lese: “Vaćar amenđe so mangljan te vaćare kale paramičasa taro kova so meljarol e manuše.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","A o Isus vaćarda: “Tumen li sen vadži bihaljarde? ");
INSERT INTO rmyGurbet_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ni li džanen, so dol ano muj, ano vođi džal thaj ikljol avral? ");
INSERT INTO rmyGurbet_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","A e lafura save ikljen andaro muj, ikljen andaro ilo thaj gova meljarol e manuše anglo Dol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Andaro ilo ikljol bilačho gođaveripe, mudaripe, preljube, blud, čoripe, xoxavno svedočanstvo thaj vređipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Gova meljarol e manuše, a te xal pe bithode vastencar ni meljarol e manuše anglo Dol.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","O Isus iklilo andari Galileja thaj crdija pe ane tirska thaj sidonska thana. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Thaj dikh, i džuvli i Hanaanejka savi bešola ane gola thana, avili ko Isus thaj po but droma dija vika: “Smilui tut pe mande, Gospode, Čhaveja e Davideso! Me čheja but mučil o bilačho duxo thaj but patil!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","A vov khanči ni vaćarda e Hanaanejkaće. Gija avile lese sikade paše leste thaj molisade le vaćarindoj: “Mukh la te džal, golese kaj bizo ačhipe dol vika pale amende.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","A vov vaćarda lenđe: “Me sem bičhaldo te pomoživ samo e hasarde bakrenđe tare Izraelska manuša.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","A voj avili, peli angle leste ke koča thaj vaćarda: “Gospode, pomogni manđe!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","A o Isus vaćarda laće: “Naj šukar te lol pe o mangro tare čhave thaj te dol pe e džuklorenđe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","A voj vaćarda: “Va, Gospode, golese so i e džuklore xan e troške so peren taro astali lenđe gospodarenđe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Tegani o Isus vaćarda laće: “O, džuvlije, baro si ćiro pačajipe! Nek avol sar so tu manđe!” Thaj sastili laći čhej ane gova sato. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","O Isus đelo gothar thaj avilo pašo more o Galilejsko. Uštilo ko brego thaj bešlo gothe te sikavol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Avile pašo Isus but manuša thaj ande pesa banđen, koren, sakatonen, laloren thaj bute avere nasvalen. Siđarde te čhuven e nasvalen paše Isusese pingre thaj vov savoren sastarda. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Gijate e manuša sesa zadivime, kaj dikhlje e lalore so vaćaren, e sakata so saston, e banđe so šukar phiren thaj e kore so dičhen thaj hvalisade e Devle e Izraelese. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","O Isus akharda pe sikaden thaj phenda lenđe: “Žal manđe kale manušenđe golese kaj trin đive si kate paše mande thaj naj len so te xan. Ni mangav te mukhav len te džan bokhale te ma malaksin ko drom.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","A e sikade vaćarde lese: “Kotar amenđe ke kava than gaći mangro te čaljon kala manuša?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Thaj o Isus pučlja: “Kobor mangre isi tumen?” A von vaćarde lese: “Efta mangre thaj zala mačhe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","A o Isus vaćarda e manušenđe te bešen ki phuv. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Lija kola efta mangre thaj e mačhen, dija hvala e Devlese, phaglja thaj dija pe sikadenđe a e sikade dije e manušenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Savore xalje thaj čalile. E sikade pale gova lije so ačhilo thaj pherde efta bare korpe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Xalje štar milje (4 000) murša, a gothe ni sesa đinde e džuvlja thaj e čhavore. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Tegani o Isus mukhlja e manušen, čhuta pe ano čamco thaj avilo pašo than o Magadansko. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Avile pašo Isus e fariseja thaj e sadukeja thaj manglje te iskušin le. Thaj rodije te sikavol lenđe nesavo znako taro nebo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","A o Isus vaćarda lenđe: “Džanen te vaćaren kana perol i rat: ‘Ka avol lačho vreme, golese kaj si o nebo lolo.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","A ki sabalin vaćaren: ‘Ađive ka avol o bilačho vreme, golese kaj si o nebo lolo thaj mutno.’ Znakura e nebose šaj tumačin, a e znakura kale đivesenđe našti te tumačin? ");
INSERT INTO rmyGurbet_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","O bilačho thaj preljubničko bijandipe rodol znako thaj aver znako ni ka dol pe lenđe, samo o znako savo sasa e prorokoso e Jonaso.” Pale gova o Isus ačhada len thaj đelo pese. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Thaj kana nakhlje ki aver rig e jezerosi, e sikade bistarde te anen pesa o mangro. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","O Isus vaćarda lenđe: “Aračhen tumen taro kvasaco o farisejsko thaj o sadukejsko!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","A von maškar peste vaćarde: “Gova si golese so ni andam mangro.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","A o Isus džanglja sostar vaćaren thaj phenda lenđe: “Sose gaći zala pačan? So vaćaren maškar tumende, so naj tumen mangro? ");
INSERT INTO rmyGurbet_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Vadži li ni haljarden? Ni li den tumen gođi baše pandž mangre ke pandž milje (5 000) džene thaj kobor korpe pherden tare kova so ačhilo? ");
INSERT INTO rmyGurbet_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ni baše efta mangre ke štar milje (4 000) džene thaj kobor bare korpe pherden? ");
INSERT INTO rmyGurbet_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Sar ni haljaren kaj ni vaćardem tumenđe baše mangre? Aračhen tumen taro kvasaco o farisejsko thaj o sadukejsko?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tegani haljarde kaj ni vaćarda lenđe te aračhen pe taro kvasaco e mangreso, nego taro farisejsko thaj o sadukejsko sikajipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Kana avilo o Isus ane krajura trujal i Kesarija e Filipesi, pučlja pe sikaden: “So vaćaren e manuša, ko sem me, o Čhavo e manušeso?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","E sikade vaćarde lese: “Jekh vaćarol kaj san o Jovane o Krstitelj, avera o Ilija, a nesave o Jeremija, il jekh tare avera prorokura.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","O Isus vaćarda lenđe: “A tumen so phenen: ko sem me?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","A o Simon o Petar vaćarda lese: “Tu san o Hrist, Čhavo e džuvde Devleso!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Thaj vaćarda lese o Isus: “Blagoslovime san, Simone, čhaveja e Jonaso! Golese kaj o manuš ni sikada tuće, nego mo Dad savo si ko nebo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","A me vaćarav tuće: Tu san o Petar i ke kava bar ka vazdav mi Khanđiri thaj e vudara e Hadese našti nadvladil la. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Thaj ka dav tut e ključura taro Carstvo e neboso: i so phande ki phuv, ka avol phanglo ko nebo thaj so putre ki phuv ka avol putardo ko nebo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Tegani o Isus pretisada pe sikaden ma khanikase te vaćaren kaj si vov o Hrist. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Od tegani o Isus lija te vaćarol pe sikadenđe putarde, kaj trubul te džal ano Jerusalim thaj but te patil tare starešine, tare šorutne sveštenikura thaj tare učitelja tare Mojsijaso zakon thaj trubul te avol mudardo em o trito đive te uštol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","A o Petar crdija le ki rig thaj lija te vaćarol lese: “Gospode, nek smiluil pe tuće o Dol! Gova ni trubul te avol tuće!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","A o Isus irisajlo thaj vaćarda e Petrese: “Dža mandar, Satano! Tu ačhe manđe ko drom, golese kaj tuće ani gođi naj e Devleso, nego o manušikano.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Tegani o Isus vaćarda pe sikadenđe: “Ko manđol te džal pale mande, trubul te ačhavol korkoro pes, trubul te lol o krsto piro thaj tegani te avol pale mande. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Golese ko manđol piro džuvdipe te aračhol, ka hasarol le, a ko hasarol piro džuvdipe baše mande, ka aračhol le. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Savo šukaripe ka avol e manuše savo sa o sveto dobil a hasarol po džuvdipe? So šaj o manuš te dol ani zamena baše piro džuvdipe? ");
INSERT INTO rmyGurbet_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Golese kaj me, o Čhavo e manušeso, sigate ka avav mingre anđelurencar ani slava mingre Dadesi, tegani ka nagradiv thaj ka kazniv dži jekhe pale lese buća. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Čače vaćarav tumenđe: nesave kate save si maškar tumende ni ka okusin o meripe sa dok ni dičhen man, e Čhave e manušese, sar avav mingre Carstvosa.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Pale šov đive inđarda o Isus e Petre, e Jakove thaj e Jovane lese phrale upre ko baro brego, kaj sesa korkore. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Gothe angle lende menjisada pe thaj leso muj sijajisada sar o kham a lese šeja sesa parne sar o svetlo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Thaj dikh, sikadilo lenđe o Mojsije thaj o Ilija, save lije te vaćaren lesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","A o Petar vaćarda e Isusese: “Gospode! Šukar kaj sam kate. Ako manđe te ćerav trin senice, jekh tuće, jekh e Mojsijase a jekh e Ilijase.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","I dok vov vaćarda, dikh, sjajno oblako učharda len thaj taro oblako šunde glaso: “Kava si mingro Čhavo o manglo, savo si palo mingro manglipe! Le šunen!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Kana kava šunde e sikade, pele mujesa dži i phuv thaj darajle but. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","A o Isus avilo, dolda len thaj vaćarda lenđe: “Ušten! Ma daran!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Kana von vazdije pe jakha, ni dikhlje khanika sem e Isuse. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Thaj kana ulile taro brego, o Isus naredisada lenđe: “Ma vaćaren khanikase so dikhljen sa dok me, o Čhavo e manušeso, ni uštav tare mule.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","E sikade pučlje e Isuse: “Sose tegani e učitelja tare Mojsijaso zakon vaćaren kaj angleder trubul te avol o Ilija?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","A o Isus vaćarda lenđe: “O Ilija čače ka avol angleder thaj sa ka čhuvol ke po than. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Al me vaćarav tumenđe kaj o Ilija već avilo, a von ni pindžarde le, nego ćerde pese lesa so manglje. Gija i me, o Čhavo e manušeso, ka pativ lendar.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Tegani haljarde e sikade kaj vaćarol lenđe taro Jovane o Krstitelj. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","A kana avile paše but manuša, avilo nesavo manuš anglo Isus, pelo angle leste ke koča ");
INSERT INTO rmyGurbet_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","thaj vaćarda lese: “Gospode! Smilui tut me čhavese, golese kaj isi le padavica thaj but patil. But droma perol ani jag thaj ano paj. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Andem le ke će sikade, a naštine te sastaren le.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","A o Isus vaćarda lenđe: “Tumen, o bipačavno thaj rumimo bijandipe! Dži kana ka avav tumencar? Dži kana ka trpiv tumen? Anen le akari!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Gija o Isus naredisada e bilačhe duxose thaj vov sigate iklilo andro čhavoro, a vov sastilo ane gova sato. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Tegani avile e sikade dži ko Isus thaj korkore pučlje le: “Sose amen naštine te trada e bilačhe duxo?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","O Isus vaćarda lenđe: “Golese so isi tumen zala pačajipe. Čače vaćarav tumenđe, ako isi tumen pačajipe sar o seme tari gorušica, šaj vaćaren kale bregose: ‘Nakh akatar odori’, thaj ka načhol. Khanči ni ka avol tumenđe nemoguće. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Al kaja vrsta tare bilačhe duxura šaj tradol pe samo e molitvasa thaj e postimasa.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Kana e sikade ćidije pe ani Galileja, vaćarda lenđe o Isus: “Me, o Čhavo e manušeso, sigate ka avav predajimo ane vasta e manušikane, ");
INSERT INTO rmyGurbet_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ka mudaren man, a trito đive ka uštav tare mule.” Thaj e sikade sesa but bibaxtale. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Kana e sikade avile ano Kafarnaum, avile pašo Petar e poreznikura taro hram, save ćiden po duj drahme thaj vaćarde e Petrese: “Na li tumaro učitelji poćinol o hramsko porezi?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","O Petar vaćarda: “Poćinol.” Thaj kana dija ano čher, o Isus angleder pučlja le: “So misli, Simone? Kastar e carura e phuvaće ćiden i carina thaj o porezi? Tare pire čhave il tare avera čhave?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","A o Petar vaćarda lese: “Tare avera.” A o Isus vaćarda lese: “Gija, e čhave ni poćinen. Von si oslobodime. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Al te ma uvredi len, dža thaj čhude i udica ano paj. Save mačhe angleder dole, putar leso muj thaj ka aračhe štar drahme. Le thaj poćin o porezi manđe em tuće.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ane gova sato avile dži ko Isus lese sikade thaj pučlje le: “Ko si embaro ano Carstvo e neboso?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","O Isus dija vika jekhe cikne čhavore, čhuta le maškare lende ");
INSERT INTO rmyGurbet_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","thaj vaćarda lenđe: “Čače vaćarav tumenđe, ako ni promenin tumen thaj ni aven sar cikne čhavore, nisar našti džan ano Carstvo e neboso! ");
INSERT INTO rmyGurbet_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Savo gija ponizil pe sar gova čhavoro, vov si embaro ano Carstvo e neboso. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Thaj ko primil jekhe gasave čhave zbog mande, man primil. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Te khoni inđarda ano greh jekhe tare kala cikne save pačan ane mande, pošukar si lese te phanden baro bar tari vodenica ke lesi kor thaj te avol tasado ani dubina e moresi. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Pharo e manušenđe ano sveto golese so ćeren te perol pe ano greh! Golese kaj trubul te aven e iskušenjura save inđaren ano greh, al pharo kole manušese pe kaste e iskušenjura aven. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ako ćo va il ćo pingro inđarol tut ane grehura, čhin le thaj čhude le tutar. Pošukar si tuće te ulje ano džuvdipe bizo meripe sakato il bango, nego duje vastencar thaj duje pingrencar te čhuden tut ani jag savi ni ačhol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Thaj ako ći jakh inđarol tut ano greh, ikal la thaj čhude la tutar. Pošukar si tuće te ulje ano životo jekhe jakhasa, nego duje jakhencar te čhuden tut ani jag savi ni ačhol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Pazin te ma dičhen barikane nijekhe tare kala ciknen, golese me vaćarav tumenđe kaj e anđelura lenđe ko nebo stalno ačhen anglo mo Dad savo si ko nebo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Golese kaj me o Čhavo e manušeso aviljem te rodav thaj te spasiv e hasarden.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“So den gođi? Ako e manuše isi šel bakre thaj jekha hasarol, ni li ačhavol vov enjavardeš thaj enja po brego thaj džal te rodol kola so hasardili? ");
INSERT INTO rmyGurbet_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Thaj ako aračhol la, čače vaćarav tumenđe, vov pobut radujil pe kala jekha so arakhlja, nego kolenđe enjavardeš thaj enja so ni hasajle. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Gijate ni manđol tumaro Dad ko nebo te hasarol ni jekhe tare kala cikne.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ako ćerol greh ćiro phral, dža thaj ukori le kana sen korkore. Ako šunol tut, palem dobisadan ćire phrale. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ako ni šunol tut, le tusa vadži jekhe il dujen, ‘palo svedočanstvo duje il trine svedokurengo te dokažil pe svako optužba.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","A ako i len ni šunol, vaćar e khanđiraće. A ako odbil te šunol e khanđira, te avol tuće sar o bipačavno thaj carinco. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Čače vaćarav tumenđe, sa so phanden ki phuv, ka avol phanglo ko nebo thaj sa so putren ki phuv, ka avol putardo ko nebo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Čače vaćarav tumenđe vadži, ako duj džene tumendar ki phuv katane molin pe thaj roden bilo so, ka dol len o Dad mingro savo si ko nebo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Golese kaj si duj il trin ćidime ane mingro alav, me sem gothe maškar lende.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tegani avilo o Petar pašo Isus thaj vaćarda: “Gospode! Ako mo phral grešil premal mande, kobor droma te oprostiv lese? Dži efta droma li?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","O Isus lese vaćarda: “Ni vaćarav tuće samo efta, nego eftavardeš thaj efta droma. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Golese vaćarav kava, o Carstvo e neboso si sar caro savo manglja te ravnil po računo e manušencar save služisade le. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kana lija te đinol, ande angle leste manuše savo duguil lese deš milje (10 000) kese zlatosa. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Sar vov naštine te iril gola pare, o caro vaćarda te biknen le, lese romnja, lese čhaven thaj sa so sasa le, te bi poćinola o dugo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","O manuš savo služila le, pelo angle leste mujesa premali phuv thaj molisada le: ‘Ađućar man thaj sa ka poćinav tuće.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","E carose pelo žal, oprostisada gole slugase o dugo thaj mukhlja le. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","A kana iklilo o manuš savo služil, arakhlja pe amale, avere sluge, savo duguisada lese šel grošura. Dolda le, lija te tasavol le thaj vaćarda lese: ‘Iri so duguji manđe!’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Pelo leso amal, aver sluga, angle leste mujesa premali phuv thaj molisada le thaj vaćarda lese: ‘Ađućar man thaj ka poćinav tuće!’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","A vov ni manglja te ađućarol le, inđarda le thaj čhudija le ano phanglipe sa dok ni ka poćinol o dugo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kana kava dikhlje avera amala, avera sluge, uznemirisajle but. Đele thaj javisade e carose sa kava so dikhlje. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Tegani o caro leso dija vika e sluge kase oprostisada o dugo thaj vaćarda lese: ‘Bilačheja slugo! Sa o dugo me oprostisadem tuće, golese kaj molisadan ma. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Na li trubujan i tu te smilui tut ćire amalese, e slugase, sar me so smiluisaljem tuće?’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","O caro leso holajlo thaj dija le ke mučitelja sa dži kaj ni ka poćinol o dugo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Gija i mo Dad ko nebo ka ćerol tumencar, ako ni ka oprostin tumare phralese andare tumare ile.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Kana o Isus završisada kava vaćaripe, đelo andari Galileja thaj avilo ane Judejska krajura ki aver rig e Jordanesi. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Đele pale leste but manuša thaj vov gothe sastarda e nasvalen. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Thaj avile dži ko Isus e fariseja te iskušin le thaj pučlje le: “Šaj li o manuš te mučhol pe romnja paše bilo so?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","O Isus phenda lenđe: “Džanav kaj čitisaden ano Sveto lil kaj o Stvoritelji ko anglunipe ‘stvorisada murše thaj džuvlja’. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Thaj vadži vaćarda: ‘Golese o manuš ka ačhavol pe dade thaj pe da thaj ka phandol pe pe romnjasa thaj duj ka aven jekh telo.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Gijate naj akana duj, nego jekh telo. So o Dol phanglja o manuš te ma ulavol!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Pe gova von pučlje le: “Pa, sose o Mojsije zapovedisada o rom te dol pe romnja rastavimaso lil kaj mučhol la?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","O Isus vaćarda lenđe: “O Mojsije ačhada tumenđe te mučhen e romnjen pale tumare zurale ile, al ko anglunipe ni sasa gija. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","A me vaćarav tumenđe: Te khoni mučhol pe romnja, sem pašo lako blud, a lol avera, ćerol preljuba thaj ko lol raspuštenica romnjaće ćerol preljuba.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","E sikade lese vaćarde: “Te si gija maškar o rom thaj i romni, tegani po šukar si te ma ženil pe!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","A o Isus vaćarda e sikadenđe: “Našti savore te prihvatin kava akana so vaćarden, sem kola kase dija pe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Golese kaj isi murša saven taro lengo bijandipe našti te aven len čhave, a isi kola saven avera ćeren te aven gasave. A isi nesave save ni manđen te len romnjen zbog o Carstvo e neboso. Ko šaj te prihvatil, nek prihvatil!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tegani anglo Isus e manuša ande čhavoren te čhuvol po va pe lende thaj te molil pe. A e sikade branisade len. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","A o Isus vaćarda: “Mučhen e čhavoren thaj ma ačhaven len te aven ke mande, golese kaj gasavenđe si o Carstvo e neboso!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Gija čhuta po va pe lende, a pale gova đelo gothar. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Thaj dikh, nesavo terno manuš avilo pašo Isus thaj pučlja le: “Učitelju! Savo šukaripe te ćerav te avol ma džuvdipe bizo meripe?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","A o Isus vaćarda lese: “Sose puče man bašo šukaripe? Samo jekh si šukar, o Dol! Ako manđe te de ano džuvdipe bizo meripe, ićar tut ke zapovestura!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","O terno pučlja le: “Save zapovestura?” A o Isus vaćarda: “Kala zapovestura: ‘Ma mudar, ma čher preljuba, ma čor, ma svedoči xoxavne, ");
INSERT INTO rmyGurbet_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","poštuji ćire dade thaj ćire da,’ thaj ‘mang ćire pašutne sar korkore tut.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","O terno phenda lese: “Pe sa kava ićardem man. So vadži trubul?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","O Isus vaćarda lese: “Ako manđe savršeno te ave, dža bićin sa so isi tut, e pare de e čororenđe thaj ka avol tu barvalipe ko nebo. Tegani av thaj dža pale mande.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kana šunda gola lafura o terno, đelo gothar bibaxtalo, golese kaj ni manglja te biknol sa so sasa le taro baro barvalipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tegani o Isus vaćarda pe sikadenđe: “Čače phenav tumenđe, but pharo ka avol e barvalese te džal ano Carstvo e neboso!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Pale vaćarav tumenđe: “Po ločhe si e kamilaće te načhol maškare suvaće kana, nego o barvalo te avol ano Carstvo e Devleso!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kana šunde gova lese sikade, but čudisajle thaj pučlje: “Pa ko šaj onda te spasil pe?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","O Isus dikhlja šukar premal lende thaj vaćarda lenđe: “So si nemoguće e manušenđe, gova si e Devlese moguće.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tegani o Petar phenda: “Akh, amen ačhadam sa thaj pale tute đeljam. So golesa ka dobi?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","A o Isus vaćarda lenđe: “Čače vaćarav tumenđe ano sveto savo ka obnovil pe, kana me, o Čhavo e manušeso, ka bešav ke mingro slavno presto, a tumen save džan pale mande ka bešen ke dešuduj (12) prestola thaj ka sudin pe dešuduj plemenura e Izraelese. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Thaj dži jekh, savo zbog mo alav ačhavol po čher, il pe phralen, il pe phejen, il pe dade, il pe da, il pe romnja, pe čhaven, il pi phuv, ka lol šel (100) droma gaći thaj ka nasledil džuvdipe bizo meripe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Al, kola so si akana anglal odori ka aven empalal, a kola save si empalal odori ka aven emanglal.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Golese o Carstvo e neboso si sar vlasniko savo ki sabalin rano uštol te rodol bućarnen te ćeren bući ane leso vinograd. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Pazarisajlo e bućarnencar po jekh dinari, so sasa dnevnica jekhe đivesesi thaj bičhalda len ane po vinograd. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Kana sasa paše enja o sato, pale iklilo thaj dikhlja averen sar ačhen ko trgo bibućako. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Vaćarda lenđe: ‘Džan i tumen ane mo vinograd thaj ćeren bući, a kobor si pravedno me ka poćinav tumen.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Thaj von đele. Palem iklilo paše ke dešuduj (12) o sato. Poslepodne ke trin o sato ćerda isto gova. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kana iklilo paše o pandžto sato poslepodne, arakhlja averen sar ačhen bibućako thaj pučlja len: ‘Sose ačhen celo đive gothe bizi bući?’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Von vaćarde lese: ‘Golese kaj khoni ni dija amen bući.’ Gija phenda lenđe: ‘Džan i tumen ane mo vinograd thaj ćeren bući.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Kana pelo o mrako, vaćarda o gospodari e vinogradeso pe anglune slugase: ‘De vika sa e bućarnen thaj poćin angleder kolen save avile empalune dži kola so avile te ćeren bući angleder.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Gija avile angleder kola so avile te ćeren bući ko pandžto sato thaj lije po jekh dinari. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Thaj kana avile kola save angleder lije te ćeren bući, dije gođi kaj ka len po but, al i von lije po jekh dinari. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Kana lije e pare, lije te bunin pe po vlasniko e vinogradeso. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Phende: ‘Amen ćerdam bući celo đive thaj mučisaljam thaj phabiljam, al kola so avile emposlednja save ćerde bući samo jekh sato thaj i len poćindan sar amen!’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","A vov vaćarda jekhese lendar: ‘Manušeja! Me tuće ni ćerav nisavi nepravda. Na li pazarisaljem tusa jekh dinari? ");
INSERT INTO rmyGurbet_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Le so si ćiro thaj dža. Me mangav te dav kole empalune sar so poćinav i tut. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Naj li man pravo te ćerav so me mangav me parencar? Il si ći jakh bilačhi so sem me šukar premal lende?’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Gija, kola so si akana empalal odori ka aven anglal, a kola save si anglal odori ka aven empalal.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Kana đelo o Isus ano Jerusalim, lija pe dešuduje (12) sikaden korkoren thaj odrumal vaćarda lenđe: ");
INSERT INTO rmyGurbet_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Akh dža ano Jerusalim thaj man, e Čhave e manušese, ka den e šorutne sveštenikurenđe thaj e učiteljenđe tare Mojsijaso zakon a von ka osudin man ko meripe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ka den man e abandžijenđe, te maren muj mancar, te bičujin man thaj te čhuven man ko krsto thaj o trito đive ka uštav tare mule.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tegani avili dži ko Isus i dej e Zevedejevase čhavenđi, katane pe čhavencar thaj peli mujesa premali phuv angle leste te šaj khanči manđol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","O Isus pučlja la: “So manđe?” Voj phenda lese: “Obeći manđe kaj me duj čhave ka bešen ke ćire duj riga, ane ćiro Carstvo, jekh tari ći desno rig, a dujto tari ći levo rig.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","A o Isus vaćarda: “Ni džanen so manđen. Šaj li pijen o tahtaj so me ka pijav? Thaj šaj li aven krstime krstimasa savesa sem me krstimo?” Vaćarde lese: “Šaj.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","O Isus vaćarda lenđe: “Čače, o tahtaj e patimaso savo me pijav ka pijen thaj e krstimasa savesa me sema krstimo, ka aven krstime i tumen, al te bešen manđe ki desno thaj ki levo rig našti dav me. Gola thana preperen kolenđe kase pripremisada mo Dad.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kana šunde avera deš sikade, holajle pe kala duj phrala. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","O Isus akharda len paše peste thaj phenda: “Džanen kaj e abandžijenđe vladara isi len zuralipe pe manuša thaj e gospodara manđen te vladin pe lende. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Al maškar tumende te ma avol gijate! Ko manđol te avol embaro maškar tumende, nek služil tumen. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Thaj ko manđol te avol emangluno, nek avol tumaro robo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Golese ni me, o Čhavo e manušeso, ni aviljem te služin man, nego aviljem te služiv tumen thaj mo džuvdipe te dav te bi poćinava butenđe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Kana iklilo o Isus thaj lese sikade andaro foro o Jerihon, đele pale leste but manuša. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Thaj dikh, duj kore bešle pašo drom. Kana šunde kaj načhol o Isus, vaćarde: “Smilui tut amenđe, Gospode, Čhaveja e Davideso!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","A e manuša dije vika pe lende te ma bi vaćarena khanči, al von po zurale dije vika pale leste: “Smilui tut amenđe Gospode, Čhaveja e Davideso!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","O Isus ačhilo, dija len vika thaj pučlja len: “So manđen te ćerav tumenđe?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Phende lese: “Gospode, manga te dikha.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","E Isusese pelo žal thaj dolda lenđe jakha. Tari jekh drom dikhlje thaj đele pale leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Kana avile pašo Jerusalim thaj avile anglo gav i Vitfaga ki Maslinsko gora, o Isus bičhalda anglal duje sikaden ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","thaj vaćarda lenđe: “Džan ano gav angle tumende, ka aračhen hernja kaj si phangli thaj terne here lasa. Putaren len thaj anen len mande. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Te pučlja tumen khoni bilo so, vaćaren: ‘Trubun e Gospodese’ thaj sigate ka mučhen len.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","A kava sasa te bi pherdola so vaćarda o proroko: ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Vaćaren e manušenđe ano Jerusalim: ‘Ake, ćiro Caro avol tute, ponizno thaj uklilo po her, thaj po terno her, po čhavo e hernjako.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Thaj e sikade đele, i ćerde sar vaćarda lenđe o Isus. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ande lese e hernja em e terne here thaj čhute pe fostanura pe lende te šaj o Isus te bešol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","But manuša buljarde pe fostanura, a avera čhinde cikne raja thaj buljarde po drom. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","A e manuša save đele angle leste thaj pale leste, dije vika vaćarindoj: “Hosana e Čhavese e Davideso! Blagoslovimo si kova savo avol ano alav e Gospodeso! Hosana e Devlese ko učipe!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Kana o Isus dija ano Jerusalim, uzbunisajle sa e manuša ano foro thaj pučlje: “Ko si kava?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","A pherdo manuša vaćarde: “Kava si o proroko o Isus taro Nazaret ani Galileja.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","O Isus dija ano Hram thaj tradija savoren so bićinena thaj ćinena ano Hram. Perada e astalura kolenđe so menjina e pare thaj e klupe kolenđe kaj bićinde goluburen. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Thaj vaćarda lenđe: “Ano Sveto lil ačhol: ‘O čher mingro nek akhardol čher e molitvako’, a tumen lestar ćerden ‘čher kaj garaven pe e čora.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Thaj avile ano Hram pašo Isus e kore thaj e banđe thaj vov sastarda len. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Kana dikhlje e šorutne sveštenikura thaj e učitelja tare Mojsijaso zakon e čudura save vov ćerda thaj šunde e čhaven kaj den vika ano Hram: “Hosana e Čhavese e Davideso,” holajle but ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","thaj phende lese: “Šune li kala so vaćaren?” A o Isus vaćarda lenđe: “Va! Džanav kaj čitisaden ano Sveto lil: ‘Ćerdan te slavin tut e čhavore thaj e cikne čhave save pijen čuči?’” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Pale gova ačhada len, iklilo taro foro ani Vitanija thaj presuta gothe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kana o Isus sabalje irisajlo ano Jerusalim, bokhajlo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Thaj dikhlja jekh smokva pašo drom, avilo paše late, al ni arakhlja khanči, samo patrna. Golese phenda laće: “Nikad vadži ma te avol bijanipe pe tute ko džuvdipe.” Sigate i smokva šućili. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kana gova dikhlje e sikade, čudisajle thaj vaćarde: “Sar gija sigate šućili i smokva?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","A o Isus phenda lenđe: “Čače vaćarav tumenđe, ako pačan thaj ni sumnjin, ka ćeren na samo kava so me ćerdem e smokvasa, nego te vaćarden kale bregose te čhudol pe ano more, gija ka avol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Te pačajen, ka dol pe tumenđe sa so ka manđen ani molitva.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Kana o Isus đelo ano Hram, lija te sikavol. Avile leste e šorutne sveštenikura thaj e starešine e narodose thaj pučlje le: “Save vlastesa kava ćere? Ko dija tut kava autoritet?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","A o Isus phenda lenđe: “Thaj me ka pučav tumen khanči. Te vaćarden manđe, i me ka vaćarav tumenđe save vlastesa kava ćerav. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","O Dol li vaćarda e Jovanese te krstil e manušen, il e manuša vaćarde lese gova te ćerol?” A von dije pe gođi maškar peste vaćarindoj: “Te vaćardam: ‘O Dol vaćarda lese,’ ka pučol amen: ‘Sose ni pačajen e Jovane?’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Al te vaćardam: ‘E manuša vaćarde lese gova te ćerol’, ka dara tare manuša, golese kaj savore dikhlje e Jovane sar proroko.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Thaj irisade vaćarindoj e Isusese: “Ni džana.” Tegani o Isus vaćarda lenđe: “Ni me onda ni vaćarav tumenđe save vlastesa me ćerav kava.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“So den gođi tare kava? Jekh manuš sasa le duj čhave. Avilo ki jekh thaj vaćarda lese: ‘Mo čhavo! Dža thaj ćer bući ađive ane mo vinograd.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","A vov vaćarda lese: ‘Ni mangav.’ Al pale gova predomislisajlo thaj đelo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Avilo e dujtonese thaj vaćarda isto gova. A vov vaćarda: ‘Mangav, gospodarona.’ Al ni đelo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Savo tare kala duj ćerda o manglipe e dadeso?” A von vaćarde lese: “O angluno.” O Isus vaćarda: “Čače vaćarav tumenđe, kaj e carincura thaj e bludnice angleder tumendar ka džan ano Carstvo e Devleso. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Golese kaj avilo o Jovane o Krstitelj te sikavol tumenđe o pravedno drom taro džuvdipe, a ni pačajen le, al e carincura thaj e bludnice pačaje le. Tumen gova dikhljen, al ni predomislisaljen thaj ni pačajen le.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Šunen i dujto paramič: Sasa manuš čherutno savo sadisada po vinograd, nakhada le ke riga ogradasa, honda than kaj gazil pe i drakh thaj vazdija stražarsko kula. Tegani dija le ano zakup e vinogradarenđe thaj đelo ko drom. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kana avilo o vreme te ćidol pe i drakh, bičhalda e slugen te len leso kotor taro bijanipe e drakhako. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","E vinogradara dolde e slugen thaj jekhe marde, avere mudarde, a pi jekh čhudije bara thaj mudarde le. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tegani bičhalda averen slugen, po bute dženen nego angleder, a gija i lenđe ćerde. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ko krajo bičhalda lenđe pe čhave vaćarindoj: ‘Ka poštujin me čhave.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Al kana e manuša save ćerde bući ano vinograd dikhlje lese čhave, phende maškar peste: ‘Kava si o nasledniko. Aven te mudara le thaj sa amenđe te ačhol.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Thaj dolde le, ikalde le taro vinograd avral thaj mudarde le.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Tegani o Isus pučlja: “Kana ka avol o manuš kaso sasa o vinograd, so ka ćerol kolenđe so ćerde bući ano vinograd?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Vaćarde lese: “Ka mudarol len bizo milost golese kaj sesa bilačhe thaj o vinograd ka dol ano zakup avere vinogradarenđe, save ka den o bijanipe ano vreme e ćidimaso.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Vaćarda lenđe o Isus: “Džanav kaj čitisaden ano Sveto lil: ‘O bar savo čhudije e manuša save vazden e duvara ćerdilo emglavno bar taro čher. Gova ćerda o Dol thaj čudesno si ane amare jakha.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Golese phenav tumenđe kaj tumendar ka lol pe o Carstvo e Devleso thaj ka dol pe manušenđe save ka anen čačukano bijandipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Thaj ko perol ke gova bar ka phađol; a pe kaste gova bar perol, ka zgnječil le.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kana šunde e šorutne sveštenikura thaj e fariseja lese paramiča, haljarde kaj kava lendar vaćarol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Thaj dikhlje sar te dolen le, al darajle tare manuša, golese kaj dikhlje e Isuse sar proroko. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","O Isus vaćarda lenđe palem ane paramiča: ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“O Carstvo e neboso si sar kana nesavo caro ćerda abav pe čhavese. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","O caro bičhalda pe slugen te den vika kolen so sesa akharde ko abav, al khoni ni manglja te avol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Palem bičhalda avere slugen thaj vaćarda lenđe: Phenen e akhardenđe: ‘Akh o xape ćerdilo, čhindem e guruven thaj me tovime stoka thaj sa si ćerdo. Aven ko abav.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","A von ni šunde thaj đele jekh ki pi njiva a aver đelo te biknol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Avera dolde lese slugen, marde len thaj mudarde len. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Thaj o caro holajlo, bičhalda pe vojska te mudaren gole ubicen thaj te phabaren lengo foro. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Tegani vaćarda pe slugenđe: ‘Akh, o abav si ćerdo, a e akharde ni sesa dostojna te aven. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Golese, džan ke droma save ikljen taro foro thaj kas aračhen, akharen ko abav!’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","E sluge đele pe droma thaj ćidije sa kas arakhlje, bilačhen thaj šukaren, gija i dvorana e abavesi pherdili. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Kana avilo o caro te dičhol e gosturen, dikhlja manuše savo ni sasa urado ane abavese šeja. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Pučlja le: ‘Amala, sar aviljan akari bize abavese šeja?’ Al vov khanči ni vaćarda. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Tegani vaćarda o caro pe slugenđe: ‘Phanden lese vasta thaj lese pingre thaj čhuden le avral em dur ano embaro mrako, gothe but ka roven thaj ka škripin dandencar.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Golese kaj but si akharde a zala odabirime.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Tegani e fariseja đele thaj dogovorisajle sar te dolen e Isuse ano lafi. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Bičhalde ko Isus pe sikaden thaj e Irodese manušen thaj phende lese: “Učitelju! Džana kaj vaćare čačipe thaj sikave e Devleso drom ano čačipe, ni obaziri tu pe khanikaste, golese kaj ni dičhe ko si ko. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Vaćar amenđe so tu misli: Trubul li te da porezi amen e Jevreja e rimskone carose il na?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Haljarda o Isus so von bilačhe dije gođi thaj phenda lenđe: “Tumen dujemujenđe! Sose ćeren manđe zamka? ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Sikaven manđe i poresko parava.” Thaj von ande lese dinari. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","O Isus pučlja len: “Kaso si muj thaj alav ke kala pare?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Vaćarde lese: “E caroso.” Tegani vov vaćarda lenđe: “Den e carose so si e caroso, a e Devlese so si e Devleso.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Kana šunde le, divisajle, ačhade le thaj đele. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Gova đive avile paše leste e sadukeja save vaćaren kaj naj uštipe tare mule thaj pučlje le: ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Učitelju! O Mojsije amenđe dija zakon: Ako merol murš kas sasa romni a naj len čhave, trubul te lol o phral lese romnja thaj te bi voj bijanola murše savo ka nasledil pe dade thaj te inđarol leso alav. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ke amende sasa efta phrala. Angluno lija romnja thaj mulo thaj golese kaj naj sasa le čhave, ačhada pe romnja pe phralese. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Gija mulo i o dujto pa i o trito, sa dži ko eftato phral. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Thaj ko krajo i romni muli. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ko uštipe tare mule, kasi romni ka avol tare efta phrala, golese kaj savorenđi sasa romni?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","O Isus vaćarda lenđe: “Ano xoxaipe sen, golese kaj ni haljarden o Sveto lil ni o zuralipe e Devleso! ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ane aver džuvdipe, kana ka ušten tare mule e manuša, ni ka len pe niti ka den pe, al ka aven sar anđelura ano nebo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","A pašo uštipe tare mule, džanav kaj čitisaden ano Sveto lil so vaćarda tumenđe o Dol: ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Me sem Dol e Avraameso, Dol e Isaakoso thaj Dol e Jakoveso’ a von mule odavno. O Dol naj Dol e mulengo, al vov si Dol e džuvdengo!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kana šunde kava e but manuša, čudisajle lese sikajimasa. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Kana e fariseja šunde kaj o Isus phanglja e muja e sadukejenđe, ćidije pe katane. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Jekh tare učitelja taro Mojsijaso zakon manglja te ćerol lese zamka thaj pučlja le: ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Učitelju! Savo si emvažno zapovest ano zakon?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","O Isus vaćarda: “‘Mang e Gospode, ćire Devle sa ćire ilesa, sa ćire dušasa thaj sa ćire gođasa!’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Kava si angluno thaj emvažno zapovest. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","A o dujto si slično sar angluno zapovest: ‘Mang ćire pašutne sar korkore tut!’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Pe kala duj zapovestura ačhen sa avera zapovestura ano zakon thaj ane lila save pisisade e prorokura.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Dži kaj sesa e fariseja katane, pučlja len o Isus: ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“So den gođi pašo Hrist? Kaso si čhavo?” E fariseja vaćarde lese: “E Davideso.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","A vov phenda lenđe: “Sose o David ano Duxo akharol e Hriste, pe Gospode kana vaćarol: ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Vaćarda o Gospod e Gospodese mingrese: Beš manđe ki desno rig, sa dži kaj ni čhuvav ćire dušmajen tale pingre’? ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Gija kana o David akharol le ‘Gospode’, sar šaj te avol leso čhavo?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Thaj khoni naštine te iril lese ke kava pučipe. Thaj tare gova đive ni tromaje te pučen le khanči. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Tegani o Isus vaćarda e manušenđe thaj pe sikadenđe: ");
INSERT INTO rmyGurbet_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“E učitelja tare Mojsijaso zakon thaj e fariseja bešle ko than e Mojsijaso te tumačin o zakon. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Golese, aven pažljiva te ćeren sa so vaćaren tumenđe. Al ma ćeren kova so von ćeren, golese so von ni ćeren so vaćaren. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Phanden but baro pharipe savo jedva šaj inđaren thaj čhuven e manušenđe pe dume, a najesa ni manđen te mrdin te pomožin lenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Gija, sa so ćeren, ćeren te bi dičhena len e manuša. Bararen pe e kutijice e lafurencar taro Sveto lil ko čikat thaj ke vasta a ćeren bare rese pe pe fostanura. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Manđen počasna thana ke abava thaj anglune thana ke sinagoge. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Manđen e manuša sa poštovanje te pozdravin len ke javna thana thaj te akharen len ‘Učitelju!’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ma tumen te akhardon ‘učitelj,’ golese kaj isi tumen samo jekh Učitelji, a tumen sen sa phrala thaj pheja. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Thaj ‘Dade’ ma akharen nikas ki phuv, golese kaj isi tumen samo jekh Dad, savo si ko nebo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ma tumen te akhardon ‘vođa’, golese kaj isi tumen samo jekh Vođa, o Hrist. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","A embaro maškare tumende te avol kova savo služil! ");
INSERT INTO rmyGurbet_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Golese so, ko pes vazdol, ka avol ponizimo, thaj ko pes ponizil, ka avol vazdimo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Pharo tumenđe učiteljuralen tare Mojsijaso zakon thaj farisejalen, dujemujenđe! Golese kaj phanden e vudara e manušenđe taro Carstvo e neboso. Korkore ni den andre, niti den avera te džan save manđen. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Pharo tumenđe učiteljuralen taro Mojsijaso zakon thaj farisejalen, dujemujenđe! Golese kaj xan e čhera e udovicenđe thaj molin tumen but te bi ačhavena lačho utisko pe manuša. Golese o Dol ka osudil tumen pobut. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Pharo tumenđe učiteljuralen tare Mojsijaso zakon thaj farisejalen, dujemujenđe! Golese kaj načhen o more thaj i phuv te bi prelena jekhe manuše ani tumari vera, savo ka džal pale tumende thaj kana len le, ćeren le te avol čhavo taro pakao duj droma po bilačho nego so sen tumen! ");
INSERT INTO rmyGurbet_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Pharo tumenđe! Tumen, e kore vođe save vaćaren: ‘Ako khoni xal sovli e Hramesa gova naj khanči. A ako khoni xal sovli ano zlato e Hrameso, dužno si te ićarol goja sovli.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Tumen e dile thaj e kore! So si po baro, o zlato il o Hram, savo ćerol o zlato te avol sveto? ");
INSERT INTO rmyGurbet_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Thaj vaćaren: ‘Ako khoni xal sovli po žrtveniko, gova naj khanči. A ako khoni xal sovli e darosa so anol pe ko žrtveniko, dužno si te ićarol goja sovli.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Tumen e kore! So si po baro, o daro il o žrtveniko ke savo ćerol pe o sveto daro? ");
INSERT INTO rmyGurbet_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ko xal sovli e žrtvenikosa, xal sovli e žrtvenikosa thaj sa so si pe leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Thaj ko xal sovli e Hramesa, xal sovli e Hramesa thaj e Devlesa savo bešol ane leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Thaj ko xal sovli e nebosa, xal sovli ko presto e Devleso thaj e Devlesa so bešol pe leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Pharo tumenđe učiteljuralen tare Mojsijaso zakon thaj farisejalen, dujemujenđe! Golese kaj den dešto kotor tari nana, tari mirođija thaj taro kimo, a ačhaden so si emvažno ano Zakon: i pravda, o milosrđe thaj o pačajipe. Trubul te den dešto kotor, al ni trubun te ačhaven e považna buća. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kore vođe! Cedin o paj te ma bi pijena e komarco, a e kamila gutin! ");
INSERT INTO rmyGurbet_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Pharo tumenđe učiteljuralen tare Mojsijaso zakon thaj farisejalen, dujemujenđe! Golese kaj halaven avral o tahtaj thaj o čaro, a izandral pherden le grabipe thaj pohlepa. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Koreja farisejona! Thov angleder o tahtaj thaj o čaro andral, te ave i avral thodo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Pharo tumenđe učiteljuralen tare Mojsijaso zakon thaj farisejalen, dujemujenđe! Golese kaj sen sar makhle limora ano parno, save avral dičhen pe lačhe a andre si pherde kokala mulikane thaj but melalipe! ");
INSERT INTO rmyGurbet_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Gijate i tumen dičhon avral sar pravedna, a izandral sen pherde dujemujencar thaj bizakonesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Pharo tumenđe učiteljuralen tare Mojsijaso zakon thaj farisejalen, dujemujenđe! Golese kaj ćeren limora e prorokurenđe thaj lačharen e spomenikura e čačutnenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Thaj vaćaren: ‘Te avasa amen ano vreme amare paradadengo, ne bi učestvujisa lencar ane gova o rat e prorokurengo te thavdol.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Gijate svedočin tumenđe kaj sen čhave kolendar save mudarde e prorokuren. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Dovršin, gija, kova so tumare paradada počnisade! ");
INSERT INTO rmyGurbet_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Tumen sapalen thaj otrovno bijandipe! Sar ka našen tari kazna savasa sen osudime ki jag savi ni ačhol? ");
INSERT INTO rmyGurbet_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Golese akh, me ka bičhalav tumenđe prorokuren, mudrakuren thaj učiteljuren tare Mojsijaso zakon. Tumen jekhen ka mudaren thaj ka čhuven ko krsto, a dujtonen ka maren bičosa ane tumare sinagoge thaj ka traden len taro foro dži ko foro, ");
INSERT INTO rmyGurbet_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","golese ka aven banđe pašo mudaripe sa e nedužna manuša ki phuv – taro mudaripe e Aveljeso e pravednikoso, dži o mudaripe e Zaharijaso o čhavo e Varahijaso, kas tumen, e Jevreja, mudarden maškaro sveto than e hrameso thaj o žrtveniko. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Čače vaćarav tumenđe, kaj sa kaja kazna pašo mudaripe ka perol pe kava bijandipe!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","O Isus vadži vaćarda: “Jerusalime, Jerusalime, savo mudare e prorokuren thaj čhude bara pe kola saven bičhalda o Dol tuće! Kobor droma mangljem te ćidav ćire čhavoren, sar i khanji pe pujoren tale pe phaka, al ni mangljen! ");
INSERT INTO rmyGurbet_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Akh, tumaro čher ka ačhol pusto thaj čučo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Golese kaj phenav tumenđe: Ni ka dičhen man vadži, sa dok ni vaćaren: ‘Blagoslovimo si kova savo avol ano alav e Gospodeso!’” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Thaj kana iklilo o Isus andaro Hram, đelo gothar thaj avile paše leste lese sikade te sikaven lese e zgrade taro Hram. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","A o Isus pučlja len: “Dičhen li sa kava? Čače vaćarav tumenđe, ni ka ačhol ni bar po bar. Dži jekh ka avol perado.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","A kana o Isus bešlo ko Maslinsko brego, avile e sikade korkore thaj pučlje le: “Phen amenđe, kana gova ka avol? Thaj savo znako ka phenol tare ćiro avipe thaj o kraj e svetoso?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Thaj o Isus vaćarda lenđe: “Aračhen tumen khoni te ma xoxavol tumen. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Golese kaj but džene ka aven thaj ka vaćaren: ‘Me sem o Hrist’. Thaj buten ka xoxaven. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ka šunen paše tumende si maripe thaj glasura taro maripe save si dur. Dičhen te ma daran, golese kaj trubul gijate te avol, al gova vadži naj krajo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Golese so ka uštol o narodo pe narodura thaj o carstvo pe carstvura. Thaj ka avol bokhalipe, i phuv ka tresil pe ke but thana. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","A gova sa si samo anglunipe tare bare muke, sar kana i romni trubul te bijanol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Tegani ka den tumen te aven mučime, ka mudaren tumen thaj sa e manuša ka mrzin tumen, golese kaj sen mingre. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Tegani but ka peren taro pačajipe, jekh avere ka izdol thaj jekh avere ka mrzil. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ka ikljen but xoxavne prorokura thaj ka xoxaven pherdonen. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Golese, sa so ka avol po baro bizakono, o manglipe ka šudrol ke butende, ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","al savo trpil dži ko kraj, ka spasil pe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Thaj ka vaćarol pe taro Lačho Lafi ke sa o sveto za ko svedočanstvo taro Carstvo e neboso sa e narodurenđe thaj tegani ka avol o kraj. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Gija, kana dičhen e ‘grozote save anen uništipe’, taro savo vaćarol o proroko Danilo, sar ačhon ko sveto than ano Hram (savo čitil kava, nek haljarol), ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","tegani kola save ka aven ani Judeja te našen pe bregura. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Thaj ko si po čher ma te uljol tele te bi lola khanči andaro čher! ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Thaj ko si ano polje ma te iril pe te bi lola po fostano! ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Pharo e khamnjenđe thaj kole džuvljenđe save den čuči ane gola đivesa! ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Molin tumen te ma avol tumaro našipe ano jevend niti ko savato! ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Golese kaj ka avol gasavo bilačhipe savo ni sasa taro anglunipe e svetoso pa i ni ka avol posle. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Thaj o Dol te ma skratila o đinipe gole đivesengo, ni jekh manuš ne bi spasila pe, al paše kola saven o Dol birisada ka kratin pe gola đivesa.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Tegani te khoni phenda: ‘Akh kate si o Hrist!’, il ‘Ektalo odori!’, ma pačan. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Golese kaj ka ikljen xoxavne hristura thaj xoxavne prorokura thaj ka sikaven bare znakura thaj čudesura te bi xoxavena, te šaj, čak i e Devlese birimen. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Akh, vaćarav tumenđe angleder so ka avol! ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","A te vaćarde tumenđe: ‘Ektalo ani pustinja’, ma ikljen, a te vaćarde: ‘Aktalo ane garade thana’, ma pačan. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Golese, ka dičhol sar i munja so ikljol ko istok thaj svetlil ko zapad, gasavo ka avol o sikajipe mingro, e Čhaveso e manušeso. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Gova ka avol jasno gija sar kana e lešinara ćiden pe odori kaj si o mulo telo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“A sigate palo bilačhipe gole đivesengo, ‘o kham ka kaljol, thaj o čhon ka hasarol po svetlost, thaj e čerenja ka peren taro nebo, thaj e zora e nebose ka tresin pe.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tegani ka sikadol o znako e Čhaveso e manušeso ko nebo thaj but ka roven sa e plemenura ki phuv thaj ka dičhen e Čhave e manušese sar avol pe oblakura e zuralimasa thaj e bara slavasa. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Vov ka bičhalol pe anđeluren bare glasosa tare trube thaj ka ćiden e birimen tare štar balvalja, taro jekh krajo dži o dujto krajo e neboso.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","O Isus vadži vaćarol: “Sikljon kaja paramič tari smokva: Kana pe laće raja ikljen pupoljkura thaj mučhen patrna, džanen kaj si o milaj paše. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Gija i tumen kana ka dičhen sa kava so phendem tumenđe, te džanen kaj si o vreme paše, anglo vudar. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Čače vaćarav tumenđe: Kava bijandipe ni ka načhol, dži kaj sa kava ni avol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","O nebo thaj i phuv ka načhol, al me lafura ni ka načhen.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Al khoni gova đive thaj gova sato ni džanol kana gova ka avol. Ni džanen ni e anđelura taro nebo, pa ni me, o Čhavo. Džanol samo o Dad. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Golese sar so sasa ano vreme e Nojaso, gija ka avol kana me, o Čhavo e manušeso, ka avav. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Golese, sar so ane gola đivesa anglo potop e manuša xalje thaj pilje, lije pe thaj dije pe dži kova đive kana o Noja đelo ano brodo ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","thaj ni džanglje khanči so ka avol dži kaj ni avilo o potop thaj inđarda sa, gija ka avol i kana me, o Čhavo e manušeso, ka avav. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Tegani duj ka aven ki njiva, jekh ka lol pe, a jekh ka ačhol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Tare duj džuvlja katane so meljin ko mlin, jekh ka lol pe a jekh ka ačhol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Aven džungade, golese kaj ni džanen ane savo đive ka avol tumaro Gospod. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Al kava te džanen: Kana bi džanola o čherutno ane savo sato ka avol o čor, vov bi avola džungado te ne bi dola te avol andre ano čher. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Gija i tumen aven pripravna, golese kaj me, o Čhavo e manušeso, ka avav kana ni ađućaren man.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","O Isus vadži vaćarol: “Verno thaj džanglo sluga si kova kas o gospodari čhuta pe sa aver sluge te dol len xamase ane šukar vreme. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Blago gole slugase, kana avol leso gospodari e čhereso thaj aračhol le kaj gija ćerol! ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Čače vaćarav tumenđe: Ka čhuvol le te upravil sa kolesa so isi le. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ako si gova sluga bilačho ka vaćarol ane peste: ‘Ni ka avol mo gospodari e čhereso vadži but vreme’, ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","thaj lol te marol avere slugen thaj xal thaj pijol e matencar, ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ka avol o gospodari e čhereso gole slugaso ano đive kana vov ni ađućarol le thaj ano sato kana vov ni ka džanol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ka čhinol le ke opaš, ka dol le plata sar kole dujemujenđe, gothe but ka roven thaj ka škripin dandencar.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","O Isus vadži vaćarda: “Tegani o Carstvo e neboso ka avol sar deš čheja save lije pe lampe thaj iklile anglo mladoženja. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Pandž sesa bigođaver a pandž gođaver. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","E bigođaver lije e lampe al inđarde pesa zala ulje ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","a e gođaver lije pesa ulje ane čare pe lampencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","A sar o mladoženja kasnisada, e čhejenđe jakha phanglile thaj gija zasute. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","A ki opaš i rat šundilo: ‘Ek avol o mladoženja! Ikljen angle leste!’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Tegani uštile sa e čheja thaj lije te lačharen pe lampe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","E bigođaver čheja vaćarde e gođaverenđe: ‘Den amen zala ulje tumaro, golese kaj amare lampe ka ačhadon.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","A e gođavera čheja vaćarde lenđe: ‘Našti! Te ma bi ačhasa i amen i tumen, pošukar džan ke manuša save biknen thaj ćinen tumenđe ulje.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","A kana e bigođaver čheja đele te ćinen ulje, avilo o mladoženja thaj e čheja save sesa spremna đele lesa andre ko abav, a e vudara phanglile. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Posle avile i avera čheja vaćarindoj: ‘Gospodarona! Gospodarona! Putar amenđe!’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","A o mladoženja phenda e bigođaverenđe: ‘Čače phenav tumenđe: Ni pindžarav tumen.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Golese, aven džungade, kaj ni džanen o đive thaj o sato kana me, o Čhavo e manušeso, ka avav!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“O nebesko carstvo si sar o manuš savo pojdisada ko drom thaj dija vika pe slugen thaj mukhlja lenđe po barvalipe te aračhen le. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Thaj jekhese mukhlja pandž kese zlatosa, dujtonese duj, a e tritonese jekh, svakonese pale leso sposobnost. Pale gova, đelo ko drom. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Kova so lija pandž kese zlatosa, đelo sigate thaj ćerda bući lencar thaj zaradisada vadži pandž. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Gija i kava so lija duj zaradisada vadži duj. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","A savo lija jekh kesa zlatosa, đelo thaj hunda rupa ani phuv thaj garada o zlato pe gospodareso. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Pale but đivesa avilo o gospodari gole slugengo thaj manglja te dičhol so ćerde lese parencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Thaj avilo kova so lija pandž kese zlatosa, anda vadži pandž thaj vaćarda: ‘Gospodarona! Dijan man pandž kese zlatosa. Akh, me zaradisadem tuće vadži pandž.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","A o gospodari vaćarda lese: ‘Šukar, slugo šukareja thaj pačavneja! Ane cikno sana manđe verno, golese ka čhuvav tut te upravi ke but. Av te raduji tut će gospodaresa.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Avilo i kova so lija duj kese zlatosa thaj vaćarda: ‘Gospodarona! Dijan man duj kese zlatosa. Akh, me zaradisadem tuće vadži duj.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","A o gospodari vaćarda lese: ‘Šukar, slugo šukareja thaj pačavneja! Ane cikno sana manđe verno, golese ka čhuvav tut te upravi ke but. Av te raduji tut će gospodaresa.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Avilo kova so lija jekh kesa zlatosa thaj vaćarda: ‘Gospodarona! Džanav kaj san tu zuralo manuš, ćide kaj ni sejisadan, a le kaj ni vejisadan. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Golese daraljem thaj đeljem thaj garadem ći kesa e zlatosa ani phuv. Ake tuće ći kesa!’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","A o gospodari leso vaćarda: ‘Bilačheja thaj bibućarneja slugo! Džangljan kaj ćidav kaj ni sejisadem thaj lav kaj ni vijisadem? ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Golese trubujan me pare te de e manušenđe save menjin e pare, a me kana ka avav, lava bi mingro zlato kamatasa. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Golese, len lestar goja kesa zlatosa thaj den kolese so isi le deš! ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Golese so, svakone kas isi, ka dol pe lese vadži thaj ka avol le ano izobilje, a kole so naj le, ka lol pe i gova so isi le. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Thaj o sluga savo naj korisno čhuden avral emdur, ano embaro mrako. Gothe but ka roven thaj ka škripin dandencar.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Kana ka avol o Čhavo e manušeso ani pi slava thaj lese anđelura, tegani ka bešol ke piro slavno presto. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Thaj ka ćiden pe angle leste sa e narodura, a vov ka crdol e manušen jekh averendar, sar o pastiri so crdol e bakren tare buznja. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Thaj ka čhuvol e bakren ki desno rig, a e buzen ki levo rig. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Tegani o Caro ka vaćarol kolenđe save ačhen ki desno rig: ‘Tumen, saven blagoslovisada mo Dad, len o Carstvo savo si tumenđe ćerdo taro postanko e svetoso! ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Golese so, dijen man te xav kana bokhalo sema; dijen man te pijav kana trošalo sema; mukhljen ma andre kana abandžija sema. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nango sema thaj uraden man; nasvalo sema thaj aviljen te dičhen man; ano phanglipe sema, aviljen mande.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Tegani ka phenen lese e čačutne: ‘Gospode! Kana gova dikhljam tut bokhale, parvardam tut, il trošale, dijam tut te pije? ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kana gova dikhljam tut sar abandžija, mukhljam tut andre, il nanđe thaj uradam tut? ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kana gova dikhljam tut nasvale il ano phanglipe, aviljam li ke tute?’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","A o Caro ka vaćarol lenđe: ‘Čače phenav tumenđe, kana ćerden gova jekhese tar me emcikne phralenđe, manđe ćerden!’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Tegani ka vaćarol kalenđe kaj si tari levo rig: ‘Džan mandar, prokletonalen, ani jag savi ni ačhol, so si ćerdi e benđese thaj lese anđelurenđe! ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Golese kaj me sema bokhalo, thaj ni dijen man te xav, sema trošalo, ni dijen man te pijav. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Abandžija sema, ni mukhljen man andre, nango sema, ni uraden man, nasvalo thaj ano phanglipe sema thaj ni aviljen te dičhen man.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Tegani i von ka vaćaren lese: ‘Gospode! Kana gova dikhljam tut bokhale il trošale, abandžija il nanđe, nasvale il ano phanglipe, a te ni pomožisadam tut?’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Tegani vov ka vaćarol lenđe: ‘Čače vaćarav tumenđe, kana ni ćerden kava i emciknese tar me phrala, ni ćerden ni manđe!’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Thaj kala ka džan ani večno kazna, a e čačutne ano džuvdipe savo ni ačhol.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Kana o Isus završisada sa kava vaćaripe, phenda pe sikadenđe: ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Džanen kaj paše duj đive si i Pasha. Tegani man, e Čhave e manušese, ka den man thaj ka čhuven ko krsto.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tegani ćidije pe e šorutne sveštenikura thaj e starešine e narodose ani avlin e embare sveštenikosi savo akharda pe Kajafa. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Dogovorisajle sar te dolen e Isuse ko xoxaipe thaj te mudaren le. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","A phende: “Na ko prazniko, te ne bi o narodo bunila pe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Kana sasa o Isus ani Vitanija ano čher e Simoneso o gubavo, ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","avili ke leste jekh džuvli thaj sasa la šiši taro mermerno bar ane savo sasa jekh mirisno ulje savo sasa but kuč thaj gova miris čhorda lese po šoro dži kaj bešlo pašo astali. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Kana dikhlje lese sikade gova, holajle but thaj pučlje: “Sose ćerol pe gasavi šteta? ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Šajine kava te biknol pe bute parenđe thaj e pare te den pe e čororenđe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","A o Isus džanglja so vaćaren thaj vaćarda lenđe: “So manđen latar? Ćerda manđe šukar bući! ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Golese kaj čorore ka aven uvek maškar tumende, a me ni ka avav uvek tumencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Voj čhorda o mirisno ulje pe mo telo thaj ćerda gova te pripremil man pašo mingro prahope. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Čače vaćarav tumenđe: Dži kaj ka vaćarol pe kava Lačho Lafi pe sa o sveto, ka vaćarol pe za ko spomen thaj voj so ćerda.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tegani jekh tare Dešuduj (12) apostolura, savo akhardilo Juda Iskariotsko, đelo ke šorutne sveštenikura ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","thaj pučlja len: “Kobor ka den ma ako izdajiv e Isuse?” A von dije le tranda (30) srebrenjakura. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tare gova vreme o Juda rodija lačhi prilika sar te izdol e Isuse. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ko angluno đive taro prazniko e bikvasacose mangrengo avile e sikade ko Isus thaj pučlje le: “Kaj manđe te ćera tuće pashalno večera te xa?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Vov vaćarda lenđe: “Džan ano Jerusalim koleste thaj koleste thaj vaćaren lese: ‘O učitelji amaro vaćarol: Mo vreme si paše. Ane ćiro čher ka slavi i pasha mingre sikadencar.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","E sikade ćerde sar so o Isus vaćarda thaj pripremisade i pasha. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kana peli i rat, o Isus bešlo pašo astali pe Dešuduje (12) apostolurencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Kana xalje, vaćarda lenđe: “Čače vaćarav tumenđe, jekh tumendar ka izdajil man!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Von sesa dukhade but thaj jekh pale avereste lije te pučen le: “Te naj sem me gova, Gospode?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","O Isus vaćarda: “Ka izdol man kova so bolda mangro mancar ano čaro. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Čače me, o Čhavo e manušeso, mora te merav sar so si pisimo mandar ano Sveto lil, al but pharo kolese ko izdol e Čhave e manušese! Pošukar bi avola lese te ma bijandol!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Tegani o Juda, o izdajniko leso, pučlja: “Naj li sem gova me, učitelju?” O Isus vaćarda lese: “Tu vaćardan korkoro.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Thaj kana xalje, lija o Isus o mangro, dija hvala, phaglja le thaj dija e sikadenđe vaćarindoj: “Len i xan! Kava si o telo mingro.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Pale gova lija o tahtaj, dija hvala thaj dija len vaćarindoj: “Pijen savore lestar! ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Golese kaj kava si mingro rat taro Savez, savo ka čhordol pašo oprostipe e grehura bute manušenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Vaćarav tumenđe: Od akana ni ka pijav mol dži kova đive, kana ka pijav tumencar nevi mol ano Carstvo mingre Dadeso.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Pale gova đilabije psalmura thaj đele ko Maslinsko brego. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Tegani vaćarda lenđe o Isus: “Savore tumen ka ačhaven man kaja rat, golese kaj ano Sveto lil ačhol: ‘Ka čalavav e pastire thaj e bakre taro stado ka našen.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","A palo mo uštipe tare mule ka džav angle tumende ani Galileja.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","A o Petar vaćarda lese: “Te ačhade tut savore, me ni ka ačhavav tut!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","O Isus vaćarda lese: “Čače vaćarav tuće: Ki akaja rat angleder so o bašno ka đilabol, trin droma ka vaćare kaj ni pindžare man.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","A o Petar vaćarda lese: “Te trubuja te merav tusa, ni ka vaćarav kaj ni pindžarav tut!” A gijate vaćarde sa e sikade. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Tegani avilo o Isus pe sikadencar ano than savo akhardol Getsimanija thaj vaćarda lenđe: “Bešen gothe, dok me džav odori te molima!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Lija pesa e Petre thaj solduje čhaven e Zevedejevese thaj dolda le o žalostipe thaj pharipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Tegani vaćarda o Isus: “Mi duša si dži o meripe žalosno. Ađućaren kate thaj aven džungade mancar.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Thaj đelo po dur, pelo mujesa dži i phuv thaj molisajlo: “Dade mingreja, te šaj te nakhavol man kava tahtaj tari patnja! Al gija te ma avol so me mangav nego sar so tu manđe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Kana o Isus irisajlo ke pe trin sikade, dikhlja len sar soven. Gija vaćarda e Petrese: “Pa naštine li ni jekh sato mancar te aven džungade? ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Aven džungade thaj molin tumen te ma peren ano iskušenje, golese kaj o duxo tumaro manđol te ćerol so si šukar, al o telo tumari si slabo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Palem o dujto drom đelo thaj molisajlo: “Dade mingreja, te našti te nakhavol man kava tahtaj te ma pijav lestar, nek avol ćiro manglipe!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Kana irisajlo, palem arakhlja lese sikade sar soven, golese kaj lenđe jakha korkore phanglile. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Gija ačhada len, palem đelo thaj trito drom molisajlo vaćarindoj ista lafura. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tegani irisajlo paše pe sikade thaj vaćarda lenđe: “Vadži soven thaj odmorin? Akh, avilo o sato thaj me, o Čhavo e manušeso, ka avav predajimo ane vasta e grešnikurenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ušten te dža! Akh, kate si mo izdajniko!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Thaj dži kaj o Isus vaćarda, avilo o Juda, jekh tare Dešuduj (12) sikade thaj lesa pherdo manuša čhurencar thaj kaštencar, save sesa bičhalde tare šorutne sveštenikura thaj tare starešine e Jevrejenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","A o izdajniko e Isuseso dija len znako vaćarindoj: “Kas čumidav, gova si. Dolen le!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Thaj sigate avilo pašo Isus thaj phenda lese: “Zdravo, učitelju!” Thaj čumidija le. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","O Isus phenda lese: “Amala! Ćer kova, sose aviljan kate!” Tegani kola manuša avile, grabisade thaj dolde e Isuse. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Tari jekh drom jekh savo sasa e Isusesa, dolda pe tari bari čhuri, ikalda la thaj čhinda o kan jekhese tare sluge e bare sveštenikose. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","O Isus tegani vaćarda lese: “Iri i bari čhuri ko than lako, golese ko dolol pe pi čhuri, tari čhuri ka merol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Dal de gođi kaj me našti te moliv me Dade, te bičhalol manđe sigate pobut tare dešuduj (12) vojske e anđelurenđe? ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Al te ćerdem gova, sar bi pherdona e Sveta lila save vaćaren kaj mora gija te avol?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ane gova sato vaćarda o Isus e manušenđe: “Sar palo razbojniko ikliljen čhurencar thaj kaštencar te dolen man? Svako đive bešljem thaj sikadem ano Hram thaj ni dolden man. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Al sa kava sasa te bi pherdona e Sveta lila e prorokurenđe.” Tegani sa e sikade ačhade le thaj našle. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Kola so dolde e Isuse inđarde le ko baro svešteniko, ko Kajafa, kaj ćidije pe e učitelja tare Mojsijaso zakon thaj e starešine e Jevrejenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","O Petar odural pratisada e Isuse, dži ki avlin e bare sveštenikosi. Dija andre thaj bešlo e stražarencar te bi dičhola so ka avol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","E šorutne sveštenikura thaj sa o Baro Sudo rodije xoxavne svedočanstvura po Isus te bi mudarena le. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Al ni arakhlje len, iako avile but xoxavne svedokura. Thaj arakhlje nesar duje xoxavne svedokuren ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","save vaćarde: “Kava manuš phenda: ‘Me šaj phagav o Hram e Devleso thaj paše trin đive te vazdav le.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Pale gova uštilo o baro svešteniko thaj pučlja le: “Sose khanči ni odgovori pe kava so kala manuša svedočin tutar?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","A o Isus khanči ni vaćarda. O baro svešteniko vaćarda lese: “Xav tut sovli po džuvdo Dol te vaćare amenđe tu li san o Hrist, Čhavo e Devleso?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","O Isus vaćarda lese: “Tu vaćardan korkoro. Al me vaćarav tumenđe: Od akana ka dičhen man, e Čhave e manušese, sar bešav ki desno rig ko počasno than e Zurale Devlese thaj avav pe oblakura taro nebo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Tegani o baro svešteniko pharada pe fostanura thaj vaćarda: “Hulil po Dol! So trubun amen avera svedokura? Akana šunden lesi hula. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","So den gođi?” A von irisade lese vaćarindoj: “Trubul te merol!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tegani čhungarde le po muj thaj čalade le dumukhencar. A avera šamarisade le ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","thaj vaćarde lese: “Prorokuji amenđe, Hriste, ko čalada tut!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","O Petar bešlo avral ani avlin. Avili paše leste jekh sluškinja thaj vaćarda: “I tu sana e Isusesa tari Galileja!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","A vov odreknisajlo angle savorende: “Ni džanav sostar vaćare.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Kana o Petar avilo paši kapija, dikhlja le aver sluškinja thaj vaćarda kolenđe so sesa gothe: “I kava sasa e Isusesa taro Nazaret!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Thaj palem odreknisajlo thaj xalja sovli: “Ni pindžarav gole manuše!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Pale gova avile manuša save ačhena gothe thaj vaćarde e Petrese: “Čače tu san jekh lendar. Ćo vaćaripe gova sikavol!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tegani o Petar lija te dol pe armaja thaj te xal sovli: “Me ni džanav gole manuše!” Thaj sigate đilabija o bašno. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tegani dija pe gođi o Petar e lafurenđe so vaćarda lese o Isus: “Angleder so o bašno ka đilabol, trin droma ka vaćare kaj ni pindžare man.” Iklilo avral andari avlin thaj lija zurale te rovol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","A rano sabalje dogovorisajle e šorutne sveštenikura thaj e starešine e narodose sar te mudaren e Isuse. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Gija phanglje le, inđarde le thaj predije le ko rimsko upravitelji o Pontije Pilat. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Kana dikhlja o Juda, kova so izdajisada e Isuse, kaj osudisade le ko mudaripe, pokajisajlo thaj irisada e tranda (30) srebrenjakura e šorutne sveštenikurenđe thaj e starešinenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Vaćarda: “Grešisadem! Izdajisadem e nevinone manuše!” Von phende lese: “So amenđe tičil pe gova? Pe tute ačhol gova odgovornost.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Vov čhudija e srebrenjakura ano sveto than e hrameso thaj iklilo. Tegani đelo thaj obesisada pe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","E šorutne sveštenikura lije e srebrenjakura thaj phende: “Naj šukar te čhuva len ani hramsko kasa, golese kaj si kale parencar poćindo o rat.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Dogovorisajle te ćinen gole srebrenjakurencar i njiva e lončaresi thaj gothe te aven limora paše abandžije. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Golese i njiva dži ađive akhardol “Ratvali njiva”. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Gija pherdilo kova so vaćarda o proroko Jeremija: “Lije e tranda (30) srebrenjakura, gaći e Izraelcura odlučisade te poćinen paše leso džuvdipe, ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","thaj dije len baši njiva e grnčaresi, sar so zapovedisada manđe o Gospod.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","O Isus ačhilo anglo rimsko upravitelji o Pilat savo pučlja le: “Tu li san o caro e Jevrejengo?” O Isus vaćarda lese: “Tu vaćare korkoro.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kana tužisade le e šorutne sveštenikura thaj e starešine, o Isus khanči ni vaćarda. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Tegani pučlja le o Pilat: “Šune li so vaćaren protiv tute?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","A o Isus ni vaćarda ni jekh lafi, gija o rimsko upravitelji o Pilat but čudisajlo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ko prazniko i Pasha sasa adeti o upravitelji te mučhol andaro phanglipe po jekhe phangle save e manuša manđen. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","E Isusesa sasa jekh phanglo so akhardola Varava kas savore džanen. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kana e manuša ćidije pe, o Pilat pučlja len: “Kas manđen te mukhav tumenđe? E Varava il e Isuse so si akhardo Hrist?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Vov džanglja kaj dije le e Isuse tari ljubomora. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Kana o Pilat bešlo ki sudsko stolica, e Pilatesi romni bičhalda haberi lese: “Ačhav tut taro sudo gole pravednikostar, golese kaj erat ano suno but mučisaljem paše leste!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","A e šorutne sveštenikura thaj e starešine pherde e manušen te roden te mučhol e Varava a e Isuse te mudarol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","O Pilat pučlja: “Kas manđen te mukhav tumenđe tare kala duj džene?” Von phende: “E Varava!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","A o Pilat pučlja len: “A so te ćerav e Isusesa so si akhardo Hrist?” Savore vaćarde: “Čhuv le ko krsto!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","A o Pilat pučlja: “Sose? Savo bilačhipe ćerda?” Von andare sa o glaso dije vika: “Čhuv le ko krsto.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Al kana dikhlja o Pilat kaj khanči ni pomožil thaj sa pobut bunin pe, lija o paj thaj thoda pe vasta angle manuša vaćarindoj: “Me naj sem bango pašo rat kale manušeso! Pe tumende ačhol gova odgovornost.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Sa e manuša phende lese: “Leso rat nek perol pe amende thaj pe amare čhave!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Tegani mukhlja lenđe o Pilat e Varava, a e Isuse dija te šibin thaj dija te čhuven le ko krsto. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tegani e vojnikura e Pilatese inđarde e Isuse ke upraviteljesi palata thaj trujal leste ćidije celo četa vojnikura. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Von uljarde le thaj učharde le ano lolo ogrtači, ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","khuvde lese venco tare kangre thaj čhute lese po šoro. Dije le trska ano desno va, pele ke koča angle leste thaj marde muj lesa vaćarindoj: “Te ave sasto, carona e Jevrejengo!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Čhungarde le, lije i trska thaj marde le po šoro. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Kana ačhade te maren muj lesa, uljarde lestar o lolo ogrtači thaj urade le ane leso fostano. Tegani inđarde le te čhuven le ko krsto. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Kana iklile, resle jekhe manuše andari Kirina savo akhardola Simon thaj terisade le te inđarol o krsto e Isuseso. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Avile dži ko than so akhardola Golgota, so si “Kokalo e šoreso.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Dije le te pijol mol mešimo khančesa so si ćerko. Al kana probisada, ni manglja te pijol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kana čhute le ko krsto, čhudije kocka te bi ulavena lese fostanura maškar peste. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tegani bešle gothe te aračhen le. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Upral pe leso šoro čhute tabla kaj pisil lesi krivica: “Kava si o Isus, o Caro e Jevrejengo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Tegani čhute lesa dujen razbojnikuren, jekhe tari desno rig thaj dujtone tari levo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","E manuša save nakhle, vređisade le thaj vrtisade šorencar ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","vaćarindoj: “Tu so phađe o Hram thaj paše trin đive vazde le, spasi korkoro tut! Te san Čhavo e Devleso, ulji taro krsto!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","A gijate marde muj e Isusesa i e šorutne sveštenikura, e učitelja tare Mojsijaso zakon thaj e starešine. Vaćarde: ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Averen spasisada a korkore pes našti? Vov si o caro e Izraeleso! Nek uljol akana taro krsto thaj ka pača ane leste! ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Pouzdisajlo ano Dol, akana vov nek spasil le, te manglja le. Golese kaj phenda: ‘Me sem e Devleso Čhavo!’” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Gijate vređisade le i e razbojnikura save sesa lesa ke krstura. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","A tare opaš o đive dži ke trin o sato ki sa i phuv učharda o kalipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","A paše o trito sato dija vika o Isus andaro baro glaso: “Eli! Eli! Lama sabahtani?” (So značil: “Devla mingreja! Devla mingreja! Sose mukhljan man?”) ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Kana nesave save ačhile gothe šunde gova, phende: “Vov akharol e proroko e Ilija!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Thaj sigate jekh lendar prastija thaj lija o sunđeri, bolda le ano šut, čhuta pi trska thaj kanisada e Isuse te pijol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","A avera vaćarde: “Ačh te dikha, da li ka avol o Ilija te spasil le.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","A o Isus vadži jekh drom dija vika andaro baro glaso thaj mukhlja pi duša. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Thaj tari jekh drom i zavesa pharadili ano sveto than e hrameso, ke opaš odupral natele. I phuv tresisada thaj e stene pharile. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","E limora putajle thaj but telura e Devlese manušenđe uštile andare mule. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Thaj kana iklile andare limora palo uštipe e Isuseso, avile ano sveto foro o Jerusalim thaj sikadile pherdonenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kana o rimsko kapetano thaj kola so lesa arakhlje e Isuse dikhlje kaj i phuv tresil pe thaj sa so sasa, darajle but thaj vaćarde: “Čače kava manuš sasa Čhavo e Devleso!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Gothe sesa but džuvlja, save gova dikhlje odural. Von džana palo Isus tari Galileja thaj služina le. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Maškare lende sesa i Marija Magdalena, i Marija i dej e Jakovesi thaj e Josifesi thaj i dej e Zevedejese čhavenđi. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Kana peli i rat, avilo jekh barvalo manuš taro foro Arimateja, so akhardola Josif, savo i korkoro sasa sikado e Isuseso. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Vov đelo ko Pilat thaj molisada le pašo telo e Isuseso. Tegani o Pilat naredisada te den le o telo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","O Josif lija o telo, paćarda le ano nevo laneno čaršafi ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","thaj čhuta le ano piro nevo limori savo sasa čhindo ani stena. Phanglja o vudar taro limori bare baresa thaj đelo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Gothe sesa i Marija Magdalena thaj i dujto Marija, save bešle anglo limori. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","A theara đive, ko savato, ćidije pe e šorutne sveštenikura thaj e fariseja ko Pilat ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","thaj phende lese: “Gospodarona! Dijam amen gođi kaj kava xoxavno dok sasa džuvdo, vaćarda: ‘Pale trin đive ka uštav tare mule.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Golese vaćar te aračhol pe o limori dži ko trito đive, te ma aven lese sikade, te čoren le thaj te vaćaren e manušenđe kaj uštilo tare mule. Te gova desisajlo o poslednjo xoxaipe ka avol po baro tare anglune!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","O Pilat vaćarda lenđe: “Isi tumen stražara! Džan thaj aračhen o limori sar džanen.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Von đele thaj osigurisade o limori gija so čhute pečato po bar thaj čhute stražaren. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Palo savato, rano sabalin ko angluno đive ko kurko avili i Marija Magdalena thaj i dujto Marija te dičhen o limori. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tari jekh drom i phuv tresisajli but, golese so o anđelo e Gospodeso ulilo taro nebo. Avilo, crdija o bar tare vudara e limoreso thaj bešlo pe leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Vov sijajisada sar munja a lese šeja sesa parne sar iv. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","E stražara tresisade tari dar e anđelosi thaj sesa sar mule. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","A o anđelo phenda e džuvljenđe: “Tumen ma daran! Džanav kaj roden e Isuse save čhute ko krsto. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Naj kate, golese kaj uštilo tare mule, sar so vaćarda. Aven dičhen o than kaj pašlilo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Sigate džan te vaćaren lese sikadenđe: ‘Uštilo tare mule thaj akana angle tumende džal ani Galileja. Odori ka dičhen le.’ Akh, gova sasa man te vaćarav tumenđe!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Gija e džuvlja sigate iklile andaro limori, darandoj thaj bare radujimasa siđarde te vaćaren gova e sikadenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tari jekh drom avilo lenđe o Isus thaj phenda lenđe: “Zdravo!” A von avile, dolde le tare pingre lese thaj pele ke pe koča. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Tegani vaćarda lenđe o Isus: “Ma daran. Džan vaćaren mingre phralenđe te džan ani Galileja. Odori ka dičhen man.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Kana e džuvlja đele dromesa, nesave tare stražara avile ano foro thaj vaćarde e šorutne sveštenikurenđe sa so sasa. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Gija von ćidije pe e starešinencar thaj dogovorisajle te den e vojnikuren but pare. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Phende lenđe: “Vaćaren, ‘E sikade lese avile raćasa thaj čorde e Isuseso telo kana amen sutam.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Thaj te šunda gova o Pilat, amen ka vaćara lesa a tumenđe khanči ni ka avol.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Gija e vojnikura lije e pare thaj ćerde sar si lenđe phendo. Gija kaja paramič vaćarol pe svugde maškar e Jevreja thaj trajil dži ađive. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Tegani e Dešujekh (11) sikade đele ani Galileja ko brego kaj zapovedisada lenđe o Isus. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Kana dikhlje le, pele pe koča, al nesave posumnjisade. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","O Isus avilo paše lende vaćarindoj: “Dija pe manđe sa o vlast ko nebo thaj ki phuv. ");
INSERT INTO rmyGurbet_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Džan gija thaj ćeren e manušen tare sa e nacije te aven mingre sikade, krstin len ko alav e Dadeso thaj e Čhaveso thaj e Svetone Duxoso ");
INSERT INTO rmyGurbet_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","thaj sikaven len te ićaren sa so zapovedisadem tumenđe! Te džanen, me sem tumencar ane sa e đivesa dži ko kraj e svetoso.”");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Gija počnil o Lačho Lafi taro Isus Hrist, tare Devleso Čhavo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ano Sveto lil e prorokoso e Isaijaso pisil gija: “Akh, bičhalav angle tute me glasniko, savo ka pripremil tuće o drom. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Vov si glaso so dol vika ani pustinja: ‘Pripremin o drom e Gospodese! Ravnin lese o drom.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Pojavisajlo o Jovane o Krstitelj, savo sasa glasniko ani pustinja thaj propovedisada kaj e manuša trubun te irin pe tare pumare grehura thaj te aven ko Dol te oprostil lenđe thaj te krstin pe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Sa e manuša tari Judejsko phuv thaj taro Jerusalim đele leste ani pustinja te šunen le. E manuša vaćarena sa pe grehura a vov krstila len ki len o Jordan. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","E Jovanese šeja sesa tare kamilaće bala, pe leste sasa morčhikani kuštik thaj xalja skakavcuren thaj divljo avđin. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","O Jovane propovedisada: “Pale mande sigate ka avol khoni po baro mandar. Me naj sem dostojno te banđivav thaj te putrav e dora tar lese sandale. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Me krstiv tumen pajesa, a vov ka krstil tumen e Svetone Duxosa.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ane gola đivesa avilo o Isus taro foro Nazaret ani Galileja thaj o Jovane krstisada le ani len o Jordan. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Thaj samo so o Isus iklilo andaro paj, dikhlja sar putajlo o nebo thaj sar o Sveto Duxo odupral uljol pe leste sar golubo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","A andaro nebo šundilo glaso e Devleso: “Tu san mo Čhavo o manglo! Tu san mingro manglipe!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Sigate pale gova o Duxo inđarda e Isuse ani pustinja ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","thaj odori sasa saranda (40) đive thaj gothe o beng iskušisada le. Sasa maškare divlja životinje thaj e anđelura služisade le. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Pale gova so o caro o Irod phanglja e Jovane, o Isus đelo ani Galileja thaj propovedila taro Lačho Lafi e Devleso. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Vaćarda: “Avilo o vreme savo o Dol obećisada kaj si paše o Carstvo e Devleso! Pokain tumen thaj pačan ano Lačho Lafi.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jekh đive kana o Isus phirda pašo Galilejsko jezero, dikhlja e Simone thaj lese phrale e Andrija sar čhuden e mreže ano jezero, golese kaj sesa ribara. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","O Isus phenda lenđe: “Aven mancar thaj ka ćerav tumen te dolen e manušen sar e mačhen.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Von sigate ačhade e mreže thaj đele pale leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Kana o Isus đelo zala po dur, dikhlja e phralen e Jakove thaj e Jovane, e Zevedejevese čhaven, sar ano čamco prećeren pe mreže. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Sigate akharda o Isus i len thaj von ačhade pe dade e Zevedeje ano čamco e manušencar save ćeren bući lende thaj đele pale leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","O Isus thaj lese sikade avile ano foro o Kafarnaum. Thaj gova savato đelo ani sinagoga thaj lija te sikavol e narodo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Savore save šunde e Isuse, divisajle baše leso sikajipe, golese kaj sikada len gija sar kova savo isi le zuralipe, a na sar e učitelja tare Mojsijaso zakon. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ani sinagoga sasa jekh manuš ane kaste sasa o bilačho duxo, savo lija tari jekh drom te dol vika: ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“So manđe amendar, Isuse taro Nazaret? Aviljan li te mudare amen? Džanav ko san tu: Sveco e Devleso!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","A o Isus vaćarda lese po zurale: “Phande ćo muj thaj iklji andar leste!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Tegani o bilačho duxo but tresisada e manuše, dija vika andare sa o glaso thaj iklilo lestar. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Savore save dikhlje sa kava but čudisajle thaj lije jekh avere te pučen: “So si kava? Savo si kava nevo thaj zuralo sikajipe? Vov zapovedil e bilačhe duxonenđe, a von šunen le!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Thaj o lafi lestar sigate šundilo ani sa i Galilejsko phuv. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Samo so iklile o Isus thaj lese sikade tari sinagoga, đele e Jakovesa thaj e Jovanesa ano čher e Simoneso thaj e Andrijaso. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","E Simonesi sasuj pašljola golese so sasa la groznica thaj sigate vaćarde e Isusese latar. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","O Isus avilo paše late, dolda la taro va thaj pomožisada la te uštol. I groznica nakhli thaj voj lija te služil len. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kana peli i rat, kana zanakhlo o kham, angle leste ande sa e nasvalen thaj kolen ane kaste sesa e bilačhe duxura. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Sa e manuša andaro foro ćidije pe anglo vudar. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","O Isus sastarda e nasvalen taro dži jekh nasvalipe. Ikalda i bute benđen thaj ni dija len te vaćaren, golese so von džanglje ko si vov. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Aver sabalin o Isus uštilo rano dok vadži sasa mrako thaj iklilo avri. Đelo ki jekh than kaj naj khoni thaj odori molisajlo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Al o Simon thaj kola save sesa lesa iklile te roden le. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Kana arakhlje le, vaćarde lese: “Roden tut savore!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","O Isus vaćarda lenđe: “Ajde te dža i ane avera pašutne gava thaj e forura te vaćarav i odori. Golese aviljem!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Đelo ki sa i Galileja, vaćarda ane lenđe sinagoge thaj ikalda e benđen tare manuša. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tegani jekh gubavco avilo pašo Isus, pelo ke pe koča thaj molisada le vaćarindoj: “Te mangljan, tu šaj te sastare man!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","E Isusese pelo žal, pružisada po va, dolda le thaj vaćarda: “Mangav, av sasto!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Samo so vaćarda gova, i guba đeli lestar thaj o manuš sasa sasto. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Angleder so o Isus mukhlja te džal avral, strogo phenda lese: ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Dikh te ma vaćare khanikase. Al tu dža i sikav tut e sveštenikose thaj inđar žrtva sar so zapovedisada o Mojsije ano po zakon bašo ćiro thodipe, te bi avola tut svedočanstvo angle lende.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Al kova manuš iklilo gothar thaj lija butenđe te vaćarol sa so sasa, pa golese o Isus naštine putarde te džal ane forura, nego ačhola sa ke pusta thana. Al e manuša avena ke leste tare sa e riga. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nekobor đive pale kava o Isus irisajlo ano Kafarnaum thaj šundilo kaj si čhere. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","A ćidije pe gothe pherdo džene thaj ni sasa than čak ni ke vudara te ačhol pe. A vov vaćarola lenđe o Lafi e Devleso. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tegani avile nesave štar džene thaj ande e manuše savo naštine te phirol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Golese kaj gothe sesa but manuša a von naštine te aven dži o Isus, ćerde rupa ko tavano upreder e Isuseso šoro thaj mukhlje tele e manuše sa lese thanesa kaj pašljola. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Kana o Isus dikhlja lengo pačajipe, vaćarda e nasvalese: “Čhaveja mingreja, oprostime si će grehura!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Gothe bešena nesave učitelja tare Mojsijaso zakon thaj ane peste pučlje pe: ");
INSERT INTO rmyGurbet_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“So kava vaćarol? Hulil po Dol? Ko šaj oprostil e grehura sem jekh Dol?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","O Isus sigate pe duxosa haljarda so von ane peste dije gođi thaj vaćarda lenđe: “Sose gija den gođi ane tumare ile? ");
INSERT INTO rmyGurbet_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","So si poločhe? Te phenol pe kolese savo našti phirol: ‘Oprostime si ćire grehura’, il te phenol pe ‘Ušti, le ćiro than e pašljimaso thaj phir’? ");
INSERT INTO rmyGurbet_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Al te džanen kaj me, o Čhavo e manušeso, isi man vlast ki phuv te oprostiv e grehura.” Gija o Isus phenda e manušese so naštine phirol: ");
INSERT INTO rmyGurbet_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Tuće vaćarav! Ušti, le ćo than kaj pašljiljan thaj dža čhere.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Gova manuš uštilo, sigate lija po than kaj pašlilo thaj iklilo avri angle jakha savorenđe. Savore divisajle, slavisade e Devle thaj vaćarde: “Ni dikhljam dži akana gija khanči!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Tegani o Isus đelo palem pašo Galilejsko jezero. But manuša ćidije pe paše leste thaj vov sikada len. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Sar načhola, dikhlja e Levi, e Alfejevese čhave, sar bešol ki carina thaj vaćarda lese: “Phir pale mande!” Thaj o Levi uštilo thaj đelo pale leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Pale gova đelo o Isus te xal mangro ano čher e Levijaso. But carincura thaj grešnikura avile thaj xalje lesa thaj lese sikadencar. Gothe sesa but gasave manuša save phirena palo Isus. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Kana nesave učitelja tare Mojsijaso zakon save sesa fariseja dikhlje kaj xal e grešnikurencar thaj e carincurencar, pučlje lese sikaden: “Sose tumaro učitelji xal e carincurencar thaj e grešnikurencar?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Kana gova šunda o Isus, vaćarda lenđe: “Ni trubul lekari e sastenđe, nego e nasvalenđe. Me ni aviljem te akharav te pokajin pe e pravednikura, nego e grešnikura.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","E sikade e Jovanese e Krstiteljese thaj e fariseja postisade. Nesave avile ko Isus thaj pučlje le: “Sose ćire sikade ni postin sar so postin e sikade e Jovanese thaj e sikade e farisejenđe?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","A o Isus vaćarda lenđe: “Šaj li postin kola save avile ko abav kana o terno si lencar? Sa dži kaj si o terno lencar, von našti te postin. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Al ka aven e đivesa kana ka len lendar e terne. Ane gova đive ka postin. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Khoni ni suvol po purano fostano nevo kotor e šejengo. Golese te ćerda gova, o nevo kotor ka ćidol pe kana ka thovol pe, a taro purano ka ćerdol pobari rupa. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","A khoni ni čhorol i nevi mol ane purane morčha. Golese kaj i nevi mol ka pharavol e morčha thaj bi rumila pe i mol thaj e morčha. Golese nevi mol trubul te čhorol pe ane neve morčha.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Jekh savato o Isus thaj lese sikade phirde maškaro điv. Lese sikade odrumal lije te čhinen o điv. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","E fariseja vaćarde lese: “Dikh! Sose von ćeren kova so naj dozvolimo ko savato?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","A o Isus phenda lenđe: “Džanav kaj čitisaden ano Sveto lil so ćerda o David kana ni sasa len so te xan a sesa bokhale, vov thaj kola so sesa lesa! ");
INSERT INTO rmyGurbet_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Dija ano Čher e Devleso, ano vreme e Avijatareso e bare sveštenikoso thaj xalja e mangre save čhute pe sar žrtva, save khoni ni tromaje te xan sem e sveštenikura, a vov dija i kolenđe save sesa lesa.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Tegani vaćarda lenđe o Isus: “O savato naj ćerdo te bi o manuš služila lese, nego si savato ćerdo te služil e manušese. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Golese me, o Čhavo e manušeso, sem Gospodari thaj taro savato.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Kana o Isus palem đelo andre ani sinagoga, sasa gothe manuš šuće vastesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Nesave so gothe sesa dičhena po Isus da li ka sastarol e manuše ko savato te bi šaj optužinasa le. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Thaj o Isus vaćarda e manušese e šuće vastesa: “Ava akari thaj ačh ano maškar!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Tegani o Isus pučlja len: “Troma li ko savato te ćera šukar il bilačhe, o džuvdipe te aračhol pe il te mudarol pe?” Al von khanči ni vaćarde. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","O Isus dikhlja len holjasa thaj sasa žalno golese so lenđe ile zurajle. Tegani vaćarda e manušese: “Pruži ćiro va!” I vov pružisada piro va thaj leso va sastilo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","E fariseja sigate iklile thaj lije te planirin e Irodese manušencar sar te mudaren e Isuse. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","O Isus đelo pe sikadencar ko Galilejsko jezero, a lencar đele but manuša tari Galileja thaj i Judeja, ");
INSERT INTO rmyGurbet_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","taro Jerusalim thaj tari Idumeja thaj aver rig tari len o Jordan thaj tari okolina e Tirosi thaj e Sidonesi. Sa kola manuša avile ko Isus golese kaj šunde so vov ćerola. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Tegani o Isus vaćarda pe sikadenđe te pripremin o čamco, te ma bi e manuša ćićidena le. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Golese so gova đive buten sastarda, e nasvale gurisajle premal leste te dolen le te bi sastona. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kana bi dičhena le e bilačhe duxura, perena bi ke koča angle leste thaj bi dena vika: “Tu san e Devleso Čhavo!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Thaj o Isus vaćarda lenđe po zurale te ma šunjaren ko si vov. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Pale gova o Isus uštilo ko brego thaj dija vika kolen saven manglja thaj von avile leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Lendar birisada dešudujen (12) thaj akharda len apostolura, te aven lesa thaj te bičhalol len te propovedin ");
INSERT INTO rmyGurbet_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","thaj te avol len zuralipe te ikalen e benđen. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","A kava si e alava tare Dešuduj (12) saven birisada o Isus: O Simon (save o Isus dija alav Petar), ");
INSERT INTO rmyGurbet_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","o Jakov thaj leso phral o Jovane, e Zevedejevese čhave (len dija vika Voanirges, so si e “Čhave e gromose”), ");
INSERT INTO rmyGurbet_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","thaj o Andrija, o Filip, o Vartolomej, o Matej, o Toma, o Jakov e Alfejeveso čhavo, o Tadej, o Simon o Zilot, ");
INSERT INTO rmyGurbet_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","thaj e Juda o Iskariotsko (savo izdajisada le). ");
INSERT INTO rmyGurbet_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Tegani o Isus ulilo ano čher thaj ćidije pe gaći but džene kaj naštine ni mangro te xan. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kana šunde kava e Isusese čherutne avile pale leste te inđaren le golese kaj vaćarde: “Kava iklilo tari gođi.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","A e učitelja tare Mojsijaso zakon save avile andaro Jerusalim vaćarde: “Ane leste si o Veelzevul savo si vladari e benđengo! Vov lese zuralimasa tradol e benđen.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Gija o Isus akharda len paše peste thaj lija te vaćarol lenđe ane paramiča: “Sose bi o Satana tradola e Satana? ");
INSERT INTO rmyGurbet_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Te si o carstvo korkoro pestar ulado, gasavo carstvo ne bi šajine te ačhol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Te ani familija avol dži ulaipe, gasavi familija našti ačhol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Te o Satana uštol korkoro pe peste thaj ulavol pe, našti te ačhol, nego ka properol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Al khoni našti te dol ano čher e zurale manušese thaj te inđarol leso barvalipe angleder so ni phandol le. Tegani šaj te čorol sa andaro čher. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Čače vaćarav tumenđe: sa e grehura e manušenđe šaj oprostin pe thaj i hula savi phenen. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Al dži jekh savo hulil po Sveto Duxo, nikad ni ka oprostil pe lese. Nego si bango za ke sa e đivesa paše akava greh.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Gova vaćarda lenđe o Isus golese kaj e učitelja tare Mojsijaso zakon vaćarde: “Ane leste si o bilačho duxo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tegani avili e Isusesi dej thaj lese phrala. Sar ačhile avral, bičhalde jekhe te akharol le. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Trujal leste bešle but manuša thaj phende lese: “Akh, avral si ći dej thaj će phrala thaj roden tut.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","A o Isus pučlja len: “Ko si mi dej thaj me phrala?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Tegani dikhlja pe manuša so bešle trujal leste thaj vaćarda: “Dičhen, von si mi dej thaj me phrala! ");
INSERT INTO rmyGurbet_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Golese, dži jekh savo ćerol e Devleso manglipe, gova si mo phral, mi phen thaj mi dej.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","O Isus palem lija te sikavol pašo Galilejsko jezero. Ćidije pe pherdo manuša paše leste, gija vov dija ano čamco po jezero thaj bešlo ane leste. A e manuša ačhile pašo jezero ki obala. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Vov sikada len ane pherdo paramiča. Dži kaj sikada len, phenda: ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Šunen! Jekh đive iklilo o sejači te sejil o seme. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Dži kaj sejisada, nesavo seme pelo ko drom. Avile e čiriklja thaj sa xalje o seme. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Nesavo seme pelo pe barale thana kaj ni sasa but phuv. Sigate lija te barol, golese kaj i phuv ni sasa duboko. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Al kana o kham sasa zuralo, e biljke phabile thaj sigate šućile, golese so ni sasa len duboko koreno. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Nesavo seme pelo ane kangre. E kangre barile thaj tasade le, gija o seme ni anda nisavo bijandipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","A nesavo seme pelo pi šukar phuv, bijanda, barilo thaj lija te dol lačho bijandipe, so sasa tranda (30), šovardeš (60) thaj šel (100) droma po but nego so sasa sejime.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Tegani o Isus vaćarda: “Kas isi kana te šunol, nek šunol.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kana o Isus ačhilo korkoro e dešuduje (12) sikadencar thaj kolencar so ačhile lesa, von pučlje e Isuse so značin kala paramiča. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Vov phenda lenđe: “Tumenđe dija pe te džanen so si garajipe taro Carstvo e Devleso, a kalenđe save si avral taro Carstvo e Devleso, sa vaćarol pe ane paramiča, ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","golese sar so pisil ano Sveto lil: ‘Ka dičhen thaj ka dičhen, al ni ka shvatin, a ka šunen thaj ka šunen, al ni ka haljaren, inače bi obratina pe thaj o Dol bi oprostila lenđe.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Tegani o Isus vaćarda lenđe: “Ni haljaren kaja paramič? Sar ka haljaren sa avera paramiča? ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","O sejači si kova savo sejil e Devleso Lafi. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Nesave manuša si sar seme ko drom kaj si sejimo e Devleso Lafi. Kala manuša šunen le, al avol o Satana thaj lol lendar so si sejimo ande lenđe ile. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Avera manuša si sar o seme so si sejimo pe barale thana. Kala šunen o Lafi thaj sigate prihvatin le radujimasa, ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","al naj len koreno ane peste thaj ićaren pe nesavo vreme. Kana avol bilačhipe thaj progonstvo zbog o Lafi, sigate peren. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Avera manuša si sar seme so si sejimo ane kangre. Kala manuša šunen o Lafi, ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","al ane lenđe ile si e brige kale svetose, želje bašo barvalipe thaj o manglipe za ke avera stvara, so tasaven o Lafi, gija ačhen bizo bijandipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Nesave si sar o seme so si sejimo pi lačhi phuv. Kala manuša šunen o Lafi, prihvatin le thaj anen bijandipe: tranda (30), šovardeš (60) thaj šel (100) droma po but nego so sasa sejime.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","O Isus pučlja len: “Ko bi tumendar anola i svetiljka thaj bi čhuvola la talo čaro il talo than e sojimaso? Ni li čhuvol pe i svetiljka ke lako than? ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Golese, sa so si garado ka ikljol ko dičhipe thaj sa so si učhardo ka ikljol ko videlo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Te isi khanika kana te šunol, nek šunol.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Thaj vaćarda lenđe: “Pazin so šunen! Save merasa merin, gasave merasa ka meril pe tumenđe thaj ka dol pe tumenđe po but. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Golese kaj kas isi džanglipe, ka dol pe lese po but, a kas naj, ka lol pe lestar i kova so isi le.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Tegani o Isus vaćarda lenđe: “O Carstvo e Devleso si sar o manuš savo sejil o seme pi phuv. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Raćasa thaj đivesesa, da li sovol il uštol, o seme bijandol thaj barol, a vov i ni džanol sar. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","I phuv korkori pestar dol o bijanipe: angleder i čar, pale gova o klaso, tegani ano klaso but điv. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Samo so zrelil o bijandipe, o manuš avol e lunesa te čhinol le, golese kaj si o vreme bašo ćidipe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Palem o Isus vaćarda: “Sar ka vaćara savo si o Carstvo e Devleso? Save paramičasa te sikava le? ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Vov si sar o zrno tari gorušica, savo si emcikno tare sa e semenura savo sejil pe ani kaja phuv. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Al kana si sejimo, barol thaj ačhol po baro taro sa o povrće savo mečhol raja, gaći bare kaj ane leso lado e čiriklja e nebose šaj ćeren gnezdura.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Gasave bute paramičencar vaćarola o Isus lenđe o Lafi e Devleso thaj sikavola gaći kobor šajine von te šunen le. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Bize paramiča ni vaćarola lenđe khanči. A kana sasa e sikadencar korkoro, sa gova objasnila lenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Gova đive, kana peli i rat, o Isus vaćarda pe sikadenđe: “Ka nakha ki aver rig e jezerosi.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Gija mukhlje e manušen. E sikade čhute pe ano čamco kaj o Isus već sasa. Pale lende sesa i avera čamcura. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tegani avili zurali balval thaj e talasura čalade ano čamco, gijate da o čamco lija te pherdol paj. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","A o Isus suta ki paluni rig e čamcosi ko šerand. Džungade le thaj vaćarde lese: “Učitelju! Tuće sa jekh kaj amen ka tasiva?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","O Isus uštilo thaj vaćarda pozurale e balvaljaće thaj naredisada e pajese: “Ačh, smiri tut!” I balval ačhili thaj khanči ni šundilo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Thaj pučlja pe sikaden: “Sose gaći daraljen? Vadži li naj tumen pačajipe?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Dolda len bari dar thaj jekh averese vaćarde: “Ko si kava, kaj i balval thaj o more šunen le?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","O Isus thaj lese sikade avile ki aver rig e jezerosi paši Gerasinsko phuv. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Kana iklilo o Isus taro čamco, sigate avilo premal leste andare limora manuš kas sasa bilačho duxo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Kava manuš bešola ane limora thaj khoni naštine te phandol le ni sinđirencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","But droma sasa phanglo sastrnencar thaj sinđirencar, al vov phaglja e sastrna thaj čhinola e sinđira. Khoni naštine te smiril le. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Bizo ačhipe, đive thaj rat, o manuš ane kaste sasa o bilačho duxo, phirola maškare limora thaj ane bregura dola vika thaj čalavola pe barencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Kana odural dikhlja e Isuse, prastija thaj pelo angle leste ke pe koča. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Dija vika andare sa o glaso: “So manđe mandar, Isuse Čhaveja Embare Devleso? Xav tu sovli e Devlesa te ma muči man!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Golese kaj o Isus angleder phenda lese: “Iklji andar kava manuš, bilačheja duxona!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","O Isus pučlja le: “Sar si ćo alav?” O manuš vaćarda lese: “Mo alav si Legion, golese kaj sam but, sar vojska.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Thaj but molisada e Isuse te ma bičhalol e bilačhe duxuren avral tare kaja phuv. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","A gothe, ko brego, xana čar pherdo bale. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Gija e bilačhe duxura molisade e Isuse: “Bičhal amen te dža ane kala bale.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Thaj o Isus mukhlja len. E bilačhe duxura iklile taro manuš thaj dije ane bale. Sigate e bale lije te našen taro brego ano more. Gothe sesa paše duj milje (2 000) bale thaj sa tasile. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","E manuša save arakhlje e balen, našle thaj kalestar vaćarde ano foro thaj ane pašutne thana. Gija e manuša avile te dičhen so sasa. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Kana avile pašo Isus, dikhlje e manuše ane kaste sasa i vojska e bilačhe duxurencar sar bešol urado thaj saste gođasa. Gova darada len. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Kala save dikhlje sa gova vaćarde sa so sasa e manušesa ane kaste sesa e bilačhe duxura thaj so sasa e balencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","E manuša lije te molin e Isuse te džal andari lenđi phuv. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kana đelo o Isus ano čamco, molisada le kova manuš ane kaste sesa e bilačhe duxura te šaj džal lesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","O Isus ni mukhlja le, al vaćarda lese: “Dža čhere thaj vaćar ćirenđe so sasa tusa thaj so ćerda tuće o Gospod i kobor sasa milostivno tuće.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Gija o manuš đelo thaj lija te vaćarol ano Dekapolis so ćerda lese o Isus. Thaj savore divisajle. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Kana o Isus đelo e čamcosa ki aver rig e jezerosi, ćidije pe but manuša paše leste. Dži kaj ačhilo pašo jezero, ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","avilo jekh starešina tari sinagoga, kaso alav sasa Jair. Kana dikhlja e Isuse, pelo ke pe koča mujesa premali phuv angle leste ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","thaj but molisada le: “Mi mangli čhejori si dži o meripe. Moliv tut, av thaj čhuv će vasta pe late, te sastol thaj te živil.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Gija o Isus đelo lesa, a pale leste đele i but manuša thaj ćićidije le. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","A gothe sasa nesavi džuvli, savi sasa nasvali dešuduj (12) berš taro thavdipe o rat. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Voj but patisada thaj trošisada sa so sasa la tare lekara, al khanči ni pomognisade la thaj sasa laće sa po bilačhe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Kana šunda taro Isus, nakhli palal tare lese dume maškar gola but manuša thaj dolda le tare leso ogrtači. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Golese kaj vaćarda ane peste: “Samo te dolav man pe lese šeja, ka sastivav!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Thaj sigate ačhilo latar te thavdol o rat thaj osetisada ane po telo kaj sastili taro piro pharo nasvalipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Tari jekh drom o Isus džanglja kaj i zor iklili lestar. Irisajlo premal e manuša thaj pučlja: “Ko dolda pe tare me šeja?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","E sikade phende lese: “Tu dičhe kaj gaći manuša ćićiden amen, a tu puče ko doldape pe tute?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","A o Isus dičhola trujal peste te aračhol kola savi ćerda gova. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","A i džuvli darajli thaj izdraja, golese kaj džanglja so sasa, gija avili thaj peli mujesa premali phuv angle leste thaj vaćarda lese sa o čačipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","O Isus vaćarda laće: “Ćo pačajipe sastarda tut, mi čhej. Dža ano mir thaj av sasti taro ćiro pharo nasvalipe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Thaj kana vadži vaćarola o Isus, avile nesave manuša andaro čher e Jaireso savo sasa starešina ani sinagoga thaj vaćarda lese: “Jaire, ći čhej muli! Sose vadži muči e učitelje?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Al o Isus ni dija pažnja ke kala lafura thaj vaćarda e Jairese: “Ma dara! Samo pača!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ni dija khoni te džal lesa samo o Petar, o Jakov thaj o Jovane, e Jakoveso phral. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kana resle ko čher e Jaireso savo sasa starešina ani sinagoga, o Isus dikhlja kaj but manuša gothe roven thaj but den vika. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Dija ano čher thaj pučlja len: “Sose den vika thaj roven? I čhej ni muli, nego sovol!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Von lije te asan lese. Al vov ikalda len savoren avri, lija e dade e čhejaće thaj laće da thaj e trine sikaden save sesa lesa thaj đele andre ani soba kaj pašljola i čhej. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Vov lija e čhejako va thaj vaćarda laće: “Talita, kum!” (So značil: “Čhejorije, tuće vaćarav, ušti!”). ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","I čhejori sigate uštili thaj lija te phirol. Sasa la dešuduj (12) berš. Savore sesa začudime so dikhlje kava čudo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Al o Isus strogo naredisada lenđe, ma te vaćaren khanikase kava thaj vaćarda te den e čhejora te xal. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","O Isus iklilo gothar thaj đelo ano Nazaret, ano foro kaj barilo. Lese sikade đele lesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Kana avilo o savato, o Isus lija te sikavol ani sinagoga. But džene so šunde le, divisajle thaj pučlje: “Kotar kale manušese sa kava? Savo si gova mudrost so dija pe lese? Sar pe vastencar ćerol kala čudura? ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Naj li kava samo kaštarutno, čhavo e Marijako thaj phral e Jakoveso, e Josijaso, e Judaso thaj e Simoneso? Naj li lese pheja amencar kate?” Golese sesa but razočarime thaj ni manglje te prihvatin le. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Tegani o Isus vaćarda lenđe: “O proroko si bizo čast samo ano foro kaj barilo, maškar pi familija thaj ane po čher.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Thaj naštine ni jekh čudo te ćerol, samo čhuta pe vasta pe zala nasvale thaj sastarda len. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Thaj čudisajlo o Isus kaj e manuša ni pačaje. Tegani o Isus phirda maškare pašutne gava thaj sikada e manušen. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Dija vika paše peste e dešuduje (12) sikaden, dija len zuralipe te traden e bilačhe duxuren thaj bičhalda pe sikaden te džan duj po duj ke različita thana. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Thaj vaćarda lenđe: “Ma te len khanči tumencar, ni mangro, ni trasta, ni bakarna parave ane tumare poske, samo jekh rovli. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Al uraven tumen sandale thaj samo jekh gad, a na duj.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Thaj vadži vaćarda lenđe: “Kana džan ane nesavo than, bešen ane jekh čher, dži kaj ni pojdin ane aver than. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","A te khoni ni prihvatisada tumen thaj ni manglja te šunol tumen, ikljen gothar thaj tresin o praho tare tumare pingre sar svedočanstvo so ni lije o Lafi e Devleso. Čače vaćarav tumenđe: ‘Po ločhe ka avol e Sodomaće thaj e Gomoraće ko Sudnjo đive nego kale forose.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Gija đele e sikade thaj vaćarena savorenđe kaj trubun te pokajin pe tare pe grehura. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Buten benđen ikalde tare manuša thaj makhlje bute nasvalen uljesa thaj sastarde len. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","O caro o Irod šunda bašo Isus golese kaj savore vaćarena lestar. Nesave manuša phenena: “Gova si o Jovane o Krstitelj savo uštilo tare mule, golese šaj ćerol kala čudesura.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Avera vaćarde: “Gova si o proroko o Ilija.” A nesave vaćarde: “Vov si proroko sar jekh tare prorokura andare purane vremenura.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kana o Irod šunda kava, phenda: “Gova si o Jovane kaso šoro me čhindem. Vov uštilo tare mule!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Golese kaj o Irod sasa kova savo angleder naredisada te dolen e Jovane, te phanden le thaj te čhuven le ano phanglipe. O Irod gova ćerda baši Irodijada, i romni lese phralesi e Filipesi, golese kaj o Irod lija la romnjaće. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Golese kaj o Jovane angleder vaćarola e Irodese: “Našti le romnjaće će phralese romnja!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","I Irodijada holajli po Jovane thaj manglja te mudarol le, al naštine, ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","golese kaj o Irod darajlo taro Jovane thaj džanglja kaj si vov pravedno thaj sveto thaj golese zaštitila le. Thaj kana o Irod šunola e Jovane, avola bi but zbunime, al manglja te šunol le. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Tegani sikadili šukar prilika kana sasa e Irodeso bijando đive thaj vov ćerda bari gozba e bare manušenđe ani piri avlin, e anglunenđe tari vojska thaj e anglunenđe tari Galileja. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Avili andre i Irodijaći čhej thaj čhelda. Gova sasa šukar e Irodese thaj savorenđe save bešle gothe. Gija o caro o Irod vaćarda laće: “Rode mandar sa so manđe. Me ka dav tut.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Thaj xalja sovli: “Sa so ka manđe mandar, ka dav tut, pa i ako si gova opaš tare mingro carstvo!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Voj iklili thaj pučlja pe da: “So te mangav?” A voj phenda laće: “Rode o šoro e Jovaneso e Krstiteljeso!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Sigate i čhej avili ko caro thaj vaćarda: “Mangav te de ma akana ko čaro o šoro e Jovaneso e Krstiteljeso!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","O caro o Irod sasa but žalosno, al golese kaj xalja sovli angle gostura, ni manglja te odbil la. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Gija o caro sigate bičhalda e dželato thaj naredisada lese te anol e Jovaneso šoro. Vov đelo thaj čhinda leso šoro ano phanglipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Tegani anda leso šoro ko čaro thaj dija le e čhejaće, a i čhej dija le pe daće. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Kana e Jovanese sikade šunde kava, avile, lije leso telo thaj prahosade le ano limori. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","E apostolura irisajle tare po drom, avile ko Isus thaj vaćarde lese sa so ćerde thaj so sikade. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Thaj o Isus phenda lenđe: “Te dža ko nesavo mirno than korkore, te odmorin tumen zala.” Gova phenda lenđe golese kaj avena thaj džana pherdo manuša thaj von naštine ni te xan. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Gija đele čamcosa ko mirno than, te aven korkore. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","A but manuša so dikhlje len sar džan, pindžarde len thaj prastaje dromesa odori andare sa e forura thaj resle angleder lende. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Kana o Isus iklilo taro čamco thaj dikhlja kaj si but manuša, pelo lese žal, golese kaj sesa sar bakre bizo pastiri. Gija lija te sikavol len tare but buća. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Sar sasa kasno, e sikade avile pašo Isus thaj vaćarde: “Ke kava than naj khanči thaj kasno si. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Mukh e manušen, nek džan ane pašutne gava thaj thana te ćinen pese khanči te xan!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","A o Isus vaćarda lenđe: “Den len tumen te xan!” E sikade pučlje le: “Sosa? But pare trubul amenđe te ćina mangro te bi parvarasa sa kale manušen!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","A o Isus pučlja len: “Kobor mangre isi tumen? Džan thaj dičhen!” Kana dodžanglje, vaćarde: “Pandž mangre thaj duj mačhe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Tegani o Isus zapovedisada e sikadenđe te bešljaren e manušen ke kupe pi zeleno čar. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Gija e manuša bešle ane kupe po šel (100) thaj po pinda (50). ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tegani o Isus lija kola pandž mangre thaj e dujen mačhen, dikhlja ano nebo thaj zahvalisada e Devlese. Phaglja e mangre thaj dija e sikadenđe te den e manušenđe. Gija ulada i e duje mačhen. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Savore xalje thaj čalile. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Thaj e sikade ćidije dešuduj (12) kotora pherde korpe taro kova so ačhilo tare mangre thaj tare mačhe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Kola save xalje e mangre sesa pandž milje (5 000) murša. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Sigate pale gova o Isus naredisada pe sikadenđe te džan ano čamco thaj te džan angleder leste ki aver rig e jezerosi, premali Vitsaida, dži kaj vov ni mukhlja e manušen čhere. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kana oprostisajlo e manušencar, đelo ko brego te molil pe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kana peli i rat thaj o čamco e sikadencar sasa maškaral o jezero, o Isus sasa korkoro ki phuv. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Dikhlja kaj naštine te veslin, golese kaj i balval phurdola premal lende. Maškare trin em šov o sato sabalje avilo o Isus dži lende phirindoj po jezero. Vov manglja te načhol paše lende, ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","al kana dikhlje le sar phirol po jezero, dije gođi kaj si omaja thaj lije te den vika. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Savore dikhlje le thaj but darajle. A o Isus sigate phenda lenđe: “Šukar si! Me sem, ma daran!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Tegani avilo lencar ano čamco thaj i balval ačhili. But darajle thaj čudisajle so gova dikhlje, ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","golese kaj ni haljarde khanči taro čudo e mangrencar golese so lenđe ile sesa zurale sar bar. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kana nakhle ki aver rig e jezerosi, avile ano Genisaret thaj gothe phanglje o čamco. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Kana iklile taro čamco, e manuša odma pindžarde e Isuse. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Thaj prastije maškaro sa gova krajo te vaćaren averenđe so o Isus avilo, a e manuša lije ke nosiljke te anen e nasvalen odori kaj šunde kaj si o Isus. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Thaj kaj god te džala, ane gava il forura il po cikne thana, e manuša ke trgura čhuvena e nasvalen. Molinasa le te dolen pe bar tare leso teluno kotor e fostanoso, thaj savore save doldepe pe leste, sastile. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Jekh đive ćidije pe pašo Isus nesave fariseja thaj nesave učitelja tare Mojsijaso zakon save avile andaro Jerusalim. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Von dikhlje kaj nesave tare sikade lese lije te xan mangro bithode vastencar – so značil kaj ni thode pe vasta palo adeti e farisejengo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Golese kaj e fariseja thaj sa e Judejcura ićarena pe ke paradadengo adeti a ni xana dok ni thovena pe va dži e kuja. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Thaj kana irina pe taro trgo, ni xana dok ni thovena pe. A sesa gasave vadži but adetura e paradadenđe save ićarena, sar so sasa o adeti te thoven e tahtaja, e čare thaj e bakarna loncura. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Golese e fariseja thaj e učitelja tare Mojsijaso zakon pučlje e Isuse: “Sose će sikade ni ćeren pale adetura so dije amenđe e starešine, a xan mangro bithode vastencar?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","A o Isus vaćarda lenđe: “Dujemujenđe! Šukar tumendar prorokujisada o Isaija kana pisisada ano Sveto lil kaj o Dol vaćarda: ‘Kala manuša samo vuštencar poštujin man, a lenđe ile si dur mandar. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Khanči ni vredil lengo slavipe premal mande, golese kaj sikaven manušikane zapovestura.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ačhaden e zapovestura e Devlese, a ićaren tumen ke manušikane adetura.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Thaj vadži vaćarda lenđe: “Šukar čhinaven e Devlese zapovestura, te bi aračhena tumare manušikane adetura! ");
INSERT INTO rmyGurbet_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Golese so o Mojsije vaćarda: ‘Poštuji će dade thaj će da’ thaj ‘Ko akušol pe dade il pe da te avol kaznimo merimasa!’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Al tumen vaćaren, kaj o manuš šaj te phenol pe dadese il pe daće: ‘Kova so šaj pomogniv tumenđe, gova si te dav žrtva’ (so značil prinos e Devlese), ");
INSERT INTO rmyGurbet_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","gija ni mučhen vadži khanči te dol pe dadese em pe daće. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Gija tumen čhinaven o Lafi e Devleso paše tumare adetura savencar sikaven averen, a but gasave buća vadži nesave ćeren save naj šukar.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","O Isus palem dija vika te ćiden pe po but manuša paše leste thaj vaćarda lenđe: “Šunen man savore thaj haljaren ma! ");
INSERT INTO rmyGurbet_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Khanči so dol ano manuš od avral našti meljarol le anglo Dol. Nego gova so ikljol andaro manuš, gova ćerol e manuše melale anglo Dol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Te isi khanika kana te šunol, nek šunol!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kana o Isus crdija pe tare manuša thaj avilo ano čher, lese sikade pučlje le tari kaja paramič. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","O Isus pučlja len: “Tumen li vadži ni haljaren? Dal ni dičhen kaj sa kova so dol ano manuš od avral našti meljarol le? ");
INSERT INTO rmyGurbet_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Golese kaj ni džal gova ane leso ilo nego džal gova ane leso vođi thaj ikljol avral!” (A gija o Isus sikada kaj sa o xape si thodo anglo Dol.) ");
INSERT INTO rmyGurbet_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Thaj vadži vaćarda: “So ikljol andaro manuš gova meljarol e manuše anglo Dol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Golese, andral, andaro manušeso ilo, ikljol bilačhe mislura, o blud, čoripe, mudaripe, ");
INSERT INTO rmyGurbet_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","preljube, pohlepa, bilačhipe, prevara, razuzdanost, zavist, vređipe, baripe thaj bigođaveripe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Sa kala bilačhe buća ikljen andral thaj meljaren e manuše anglo Dol.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Pale gova o Isus đelo gothar. Avilo ane krajura pašo Tir thaj o Sidon, gothe đelo thaj bešlo ane jekh čher. Ni manglja khoni te džanol, al naštine te garadol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Nesavi džuvli sava sasa čhejori thaj ane savi sasa o bilačho duxo, šunda e Isusese thaj sigate avili thaj peli mujesa premali phuv, angle lese pingre. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","A goja džuvli sasa abandžika, bijandi andi Sirofinija thaj molisada le te ikalol e bilačhe duxo andari laći čhejori. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","O Isus vaćarda laće: “Mukh angleder te čaljon e čhavore, golese kaj naj šukar te lol pe o mangro tare čhave thaj te čhudol pe e džuklorenđe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","A voj vaćarda lese: “Va, Gospode, i e džuklore xan talo astali e troške so peren e čhavorenđe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Tegani o Isus vaćarda laće: “Zbog kava so vaćardan šaj dža čhere. Iklilo o bilačho duxo andari ći čhejori.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Thaj kana avili čhere, dikhlja kaj laći čhejori pašljol ko than e pašljimaso thaj kaj iklilo o bilačho duxo latar. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Pale gova o Isus đelo andare Tirska krajura, pa prekalo Sidon reslo dži ko Galilejsko jezero ano Dekapoljsko krajo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Gothe nesave manuša ande paše leste jekhe savo sasa kašuko thaj phareste vaćarola thaj molisade e Isuse te čhuvol po va pe leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","O Isus crdija pe lesa tare manuša, te bi avena korkore. Tegani čhuta pe naja ane lese kana, čhungarda thaj dolda lesi čhib. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Tegani o Isus dikhlja upre ko nebo, zurale uzdahnisada thaj vaćarda: “Efata,” so značil: “Putar tut!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","E manušese kana sigate putajle, putajli lesi phangli čhib thaj lija te vaćarol šukar. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","O Isus vaćarda e manušenđe ma khanikase te vaćaren. A sar po but vaćarola lenđe te ma vaćaren, von po but vaćarde. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","E manuša baš but čudisajle thaj vaćarena: “Vov sa so ćerol si but šukar! Vov ćerol e kašuće te šunen thaj e lalore te vaćaren!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ane gola đivesa palem ćidije pe pherdo manuša pašo Isus, a ni sasa len so te xan. Gija dija vika o Isus pe sikaden thaj vaćarda lenđe: ");
INSERT INTO rmyGurbet_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Žal manđe kale manušenđe, golese kaj trin đive ačhen mancar kate a naj len so te xan. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ako mukhav len bokhalen te džan čhere, ka malaksin ko drom, golese kaj nesave džene avile odural.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","E sikade pučlje le: “Šaj li khoni ani kaja pustinja te aračhol gaći but xamase baše sa kala manuša?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","A o Isus pučlja len: “Kobor mangre isi tumen?” E sikade phende: “Efta.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tegani o Isus vaćarda e manušenđe te bešen pi phuv. Lija kola efta mangre, zahvalisada e Devlese, phaglja len thaj dija pe sikadenđe te ulaven thaj von ulade e manušenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Sasa len i zala mačhe. O Isus zahvalisada baše mačhe, pa vaćarda i len te čhuven angle manuša. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Savore xalje thaj čalile thaj ćidije okova so ačhilo efta korpe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Gothe sesa paše štar milje (4 000) murša. Pale gova mukhlja len o Isus te džan pese ");
INSERT INTO rmyGurbet_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","thaj sigate bešlo ano čamco pe sikadencar thaj avilo pašo Dalmanutsko krajo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Nesave fariseja avile ko Isus thaj lije te ćeren čingara lesa. Rodije lestar nesavo čudesno znako taro nebo, te bi iskušina le. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","O Isus ane peste zurale uzdahnisada thaj pučlja: “Sose akana kava bijandipe rodol znako? Čače phenav tumenđe, ni ka dol pe nisavo znako kale bijandimase.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Pale gova ačhada len thaj palem đelo ano čamco thaj nakhlja ki aver rig e jezerosi. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","E sikade bistarde te anen pesa dovoljno mangro, a sasa len ano čamco samo jekh cikni bokoli. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Dok nakhlje o jezero, vaćarda lenđe o Isus: “Aračhen tumen taro kvasaco o farisejsko thaj o kvasaco e Irodeso!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","A von maškar peste vaćarde so kava značil, pa phende: “Kava vaćarol kaj naj amen mangro.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","O Isus džanglja sostar vaćaren thaj pučlja len: “Sose vaćaren kaj naj tumen mangro? Sar ni anen ani gođi thaj ni haljaren? Dal vadži si tumare ile zurale sar o bar? ");
INSERT INTO rmyGurbet_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Jakha isi tumen thaj ni dičhen. Kana isi tumen thaj ni šunen. Dal bistarden? ");
INSERT INTO rmyGurbet_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Kobor pherde korpe so ačhile ćidijen kana phagljem pandž mangre thaj čalile pandž milje (5 000) murša?” Vaćarde lese: “Dešuduj (12).” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“A kana phagljem efta mangre ke štar milja (4 000) murša thaj von čalile, kobor pherde bare korpe ačhile so ćidijen?” E sikade vaćarde lese: “Efta.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Thaj o Isus vaćarda lenđe: “Vadži li ni haljaren?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Tegani resle ani Vitsaida. Nesave manuša ande e Isusese jekhe kore manuše thaj molisade le te čhuvol po va pe leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","O Isus lija e kore taro va thaj ikalda le andaro gav. Čhungarda lese ke jakha, čhuta pe vasta pe leste thaj pučlja le: “Dičhe li khanči?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","O manuš dikhlja thaj vaćarda: “Dikhav manušen te phene phiren sar kašta!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Pale gova vadži jekh drom o Isus čhuta pe vasta ke lese jakha thaj vov dikhlja, leso dičhipe irisajlo thaj sa šukar dikhlja. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Tegani o Isus bičhalda le čhere thaj vaćarda lese: “Ma dža ano gav thaj ma vaćar khanikase.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Pale gova o Isus thaj lese sikade đele ane gava paši Kesarija e Filipesi. I odrumal pučlja e sikaden: “So vaćaren e manuša, ko sem me?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Von vaćarde lese: “Nesave vaćaren kaj san o Jovane o Krstitelj, avera o proroko o Ilija, a nesave vaćaren kaj san jekh tare prorokura.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Pučlja len: “A so tumen vaćaren, ko sem me?” O Petar vaćarda lese: “Tu san o Hrist!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Tegani o Isus vaćarda zurale lenđe khanikase te ma vaćaren lestar gova. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Pale gova o Isus lija te sikavol len kaj vov, o Čhavo e manušeso, trubul but te patil. Ka odbacin le e starešine, e šorutne sveštenikura thaj e učitelja tare Mojsijaso zakon thaj ka mudaren le, al vov o trito đive ka uštol tare mule. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","O Isus putarde vaćarda lenđe tare kava, a o Petar crdija le ki rig thaj lija te iril le ma golestar te vaćarol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","A o Isus irisajlo, dikhlja pe sikaden thaj korisada e Petre: “Dža mandar, Satano, golese kaj tuće ani gođi naj e Devlikane buća, nego e manušikane!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Pale gova dija vika o Isus e manušen te aven paše leste thaj paše lese sikade thaj vaćarda lenđe: “Ko manđol te džal pale mande, nek ačhavol korkoro pes, trubul te lol o krsto piro thaj nek džal pale mande. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ko manđol piro džuvdipe te aračhol, ka hasarol le, al ko hasarol piro džuvdipe baše mande thaj bašo Lačho Lafi, ka aračhol le. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Golese, savo šukaripe ka avol e manuše ako sa o sveto dobil a hasarol po džuvdipe? ");
INSERT INTO rmyGurbet_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","So vredil po but tare ćiro džuvdipe? ");
INSERT INTO rmyGurbet_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","A ko ladžal mandar thaj tare me lafura angle kava neverno thaj grešno bijandipe, tegani i me, o Čhavo e manušeso, ka ladžav lestar kana ka avav ani slava me Dadesi thaj e svetone anđelurencar.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","O Isus vaćarda lenđe: “Čače vaćarav tumenđe, kaj nesave maškar tumende save kate ačhen čače ni ka meren sa dok ni dičhen o Carstvo e Devleso sar avol ani zor!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Pale šov đive lija o Isus e Petre, e Jakove thaj e Jovane thaj anda len ko baro brego thaj gothe sesa korkore. Gothe angle lende menjisada pe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Lese šeja ćerdile blistava thaj gaći parne kaj ni jekh manuš ki phuv našti te ćerol len gaći parne. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Thaj tari jekh drom angle lende sikadile o proroko o Ilija thaj o Mojsije save lije te vaćaren e Isusesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","A o Petar vaćarda e Isusese: “Učitelju, šukar si kaj sam kate! Ka ćera trin senice, jekh tuće, jekh e Mojsijase thaj jekh e Ilijase.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","O Petar ni džanglja so te vaćarol aver, golese kaj savore but darajle. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tegani pojavisajlo o oblako thaj učharda len em šundilo lestar glaso: “Kava si mingro manglo Čhavo! Le šunen!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Tari jekh drom, kana dikhlje paše peste, khanika ni dikhlje samo e Isuse. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Sar uljena taro baro brego, o Isus zapovedisada lenđe khanikase ma te vaćaren so dikhlje, sa dži kaj vov, o Čhavo e manušeso, ni uštol tare mule. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Von ačhade gova ane peste, al pučlje jekh avere so značil “ka uštol tare mule.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","E sikade pučlje e Isuse: “Sose vaćaren e učitelja tare Mojsijaso zakon kaj o Ilija trubul te avol angleder o Mesija?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","O Isus vaćarda lenđe: “Čače, o Ilija ka avol angleder thaj sa ka obnovil. Sose tegani si pisimo ano Sveto lil taro Čhavo e manušeso, kaj but ka patil thaj ka avol odbacimo? ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Al me vaćarav tumenđe, kaj o Ilija već avilo thaj ćerde lesa sa so manglje, sar so sasa pisimo paše leste.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kana irisajle ke avera sikade, dikhlje paše lende but džene thaj e učitelja tare Mojsijaso zakon sar ćeren čingara lencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Kana e manuša dikhlje e Isuse, but iznenadisajle thaj siđarde te pozdravin pe lesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","O Isus pučlja len: “Sose ćeren čingara lencar?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Jekh gothar tare manuša vaćarda lese: “Učitelju! Andem tute me čhave savo si laloro, golese kaj si ane leste bilačho duxo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kana dolol le gova duxo, peravol le, mučhol spume thaj dandencar marol thaj kočil pe. Vaćardem će sikadenđe te traden le, al von naštine.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","O Isus phenda lenđe: “O, bipačavno bijandipe! Kobor ka avav tumencar? Kobor ka trpiv tumen? Anen e čhavore mande.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Gija ande e čhavore angle leste. Kana o bilačho duxo dikhlja e Isuse, sigate lija te tresil e čhavore. O čhavoro pelo ki phuv, lija te iril pe thaj mukhlja spume. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","O Isus pučlja lese dade: “Kobor si vov gasavo?” O dad vaćarda: “Taro ciknipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","O bilačho duxo but droma čhudol le ani jag thaj ano paj te mudarol le. Golese ako šaj te ćere khanči, smilui tut amenđe thaj pomogni amen!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","O Isus vaćarda lese: “Sose puče: ‘Ako šaj’? Sa šaj kolese savo pačal.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","O dad e čhavoreso sigate dija vika: “Pačav! Pomogni manđe po but te pačav.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Kana dikhlja kaj but manuša lije te prasten premal lende, o Isus korisada e bilačhe duxo vaćarindoj: “Duxona so ćere laloripe thaj kašućipe, vaćarav tuće: Iklji lestar thaj ma te ave ane leste više nijekh drom!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","O duxo dija vika, zurale tresisada e čhavore thaj iklilo o duxo lestar. O čhavoro ačhilo te pašljol tele sar mulo, pa but džene dena gođi kaj si mulo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","A o Isus dolda le taro va, vazdija le thaj o čhavo uštilo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kana o Isus đelo ano čher thaj sasa pe sikadencar korkoro, von pučlje le: “Sose amen naštine te ikala e bilačhe duxo?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","O Isus phenda lenđe: “Gasavo duxo šaj ikalol pe samo molitvasa thaj postimasa.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","O Isus thaj lese sikade đele gothar thaj nakhle maškari phuv i Galileja. O Isus ni manglja khoni te džanol ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","golese kaj manglja ko miro te sikavol pe sikaden. Vaćarda lenđe: “Man, e Čhave e manušese, ka den man e bilačhe manušenđe ane vasta thaj von ka mudaren man. A kana ka mudaren man, pale trin đive ka uštav.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Al e sikade ni haljarde kala lafura, a darajle te pučen le so manglja te phenol golesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","O Isus thaj lese sikade pale gova avile ano foro Kafarnaum. Kana resle ano čher, o Isus pučlja len: “Sostar raspravisaden odrumal?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Von khanči ni vaćarde lese golese kaj odrumal ćerde čingara ko si lendar embaro. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","O Isus bešlo thaj dija vika paše peste e dešudujen apostoluren thaj vaćarda lenđe: “Ko manđol te avol angluno, trubul te avol poslednjo thaj te služil savoren!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Tegani lija jekhe čhavore, čhuta le maškare lende thaj lija le ane pe vasta e čhavore thaj vaćarda lenđe: ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ko primil jekhe gasave čhavore ane mingro alav, man primil. Thaj ko primil man, ni primil samo man nego primil thaj e Devle savo bičhalda man.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","O Jovane vaćarda e Isusese: “Učitelju, dikhljam nesave manuše sar ikalol e benđen ane ćiro alav. Phendam lese te ma ćerol gova, golese kaj naj jekh amendar.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","A o Isus vaćarda lenđe: “Ma branin le! Golese kaj khoni ko ćerol čuda ane mingro alav našti bilačhe te vaćarol mandar. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Golese ko naj protiv amende, vov si amencar! ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Golese ko dol tumen te pijen samo tahtaj e pajesa, golese kaj sen e Hristese, čače vaćarav tumenđe, gova manuš čače ka dobil pi nagrada.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ko inđarol ano greh jekhe tare kala cikne save pačan ane mande, pošukar si lese te phanden baro bar tari vodenica ke lesi kor thaj te čhuden le ano more. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ako inđarol tut ćo va ano greh, čhin le! Po lačhe si tuće te dža ano džuvdipe bizo meripe sakato, nego te dža duje vastencar ani jag savi ni ačhol, ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","kaj e ćerme save xan len ni meren odori, thaj i jag ni ačhol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ako inđarol tut ćo pingro ano greh, čhin le! Po lačhe si te dža ano džuvdipe bizo meripe bango, nego te ave čhudimo solduj pingrencar ani jag savi ni ačhol ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","kaj e ćerme save xan len ni meren odori, thaj i jag ni ačhol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ako inđarol tut ći jakh ano greh, ikal la! Po lačhe si te dža jekhe jakhasa ano Carstvo e Devleso, nego te ave čhudimo duje jakhencar ani jag savi ni ačhol ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","kaj e ćerme save xan len ni meren odori, thaj i jag ni ačhol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Golese kaj dži jekh ka avol čistimo jagasa sar so o žrtva čistil pe e lonesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","O lon si šukar. Al, o lon te hasarda po londipe, sosa ka irin o londipe? Te avol lon ane tumende thaj te živin ano mir jekh averesa.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Tegani o Isus iklilo taro Kafarnaum thaj đelo ani phuv i Judeja thaj prekali len o Jordan. Pale ćidije pe pherdo manuša paše leste, al vov, sar so ćerola uvek, sikavola len. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Avile nesave fariseja te iskušin le thaj pučlje le: “Šaj li o rom te mučhol pe romnja?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","A o Isus pučlja len: “So o Mojsije zapovedisada tumenđe ano zakon?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","A von phende: “O Mojsije dozvolisada e romese te dol pe romnjaće rastavimaso lil kaj mučhol la i gija šaj te razvedil pe latar”. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Al o Isus vaćarda: “O Mojsije pisisada tumenđe gasavo zapovest golese kaj tumare ile si zurale. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Al ko anglunipe taro ćeripe ‘o Dol ćerda murše thaj e džuvlja. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Golese o manuš ka ačhavol pe dade thaj pe da thaj ka phandol pe pe romnjasa ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","thaj duj ka aven jekh telo.’ Gija, von naj više duj, nego jekh telo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Golese, so o Dol phandol, o manuš ma te ulavol!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kana palem sesa ano čher, e sikade pučlje le kalestar. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","O Isus vaćarda lenđe: “Ko mučhol pe romnja thaj lol avera, ćerol preljuba premali angluni romni. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","A gija i voj, ako mučhol pe rome thaj lol avere, ćerol preljuba.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Jekh đive ande e manuša pe čhavoren anglo Isus te čhuvol pe vasta pe lende te blagoslovil len. Al e sikade korisade len golese. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Kana o Isus dikhlja gova, holajlo ke pe sikade thaj vaćarda lenđe: “Mučhen e čhavoren te aven ke mande. Ma ačhaven len, golese kaj gasavenđe si o Carstvo e Devleso! ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Čače vaćarav tumenđe, ko ni primil o Carstvo e Devleso sar čhavoro, čače ni ka dol ane leste.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Thaj lija e čhavoren ani pi angali thaj čhuta pe vasta pe lende thaj blagoslovisada len. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Kana o Isus iklilo ko drom, prastija jekh manuš angle leste thaj pelo ke pe koča thaj pučlja e Isuse: “Učitelju šukareja, so trubul te ćerav te avol ma džuvdipe bizo meripe?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","O Isus pučlja le: “Sose man de vika šukareja? Khoni naj šukar, samo jekh si šukar – o Dol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","E Devlese zapovestura džane: ‘Ma mudar’, ‘Ma ćer preljuba’, ‘Ma čor’, ‘Ma svedoči xoxavne’, ‘Ma prevari’, ‘Poštuji će dade thaj će da!’” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Al vov vaćarda lese: “Učitelju! Sa kala zapovestura ićarav taro mo ternipe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Tegani o Isus dikhlja le bute manglimasa thaj vaćarda lese: “Jekh trubul tuće. Dža i bićin sa so isi tut, ulav e pare e čororenđe thaj ka avol tut barvalipe ko nebo. Tegani av thaj dža pale mande.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kana šunda o manuš kala lafura, sasa but žalosno thaj đelo dukhado, golese kaj sasa but barvalo i ni manglja te bićinol sa so isi le. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","O Isus dikhlja trujal peste thaj pe sikadenđe vaćarda: “Kobor si pharo e barvalenđe te den ano Carstvo e Devleso!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","A e sikade čudisajle tare e lafura lese, al o Isus pale vaćarda lenđe: “Čhavoralen, sar si pharo kolenđe save uzdajin pe ane piro barvalipe te džal pe ano Carstvo e Devleso! ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Po ločhe si e kamilaće te načhol maškare suvaće kana, nego o barvalo te dol ano Carstvo e Devleso!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","A e sikade sesa vadži pobut čudime thaj maškare peste pučlje pe: “Ko šaj onda te avol spasime?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","O Isus dikhlja pe lende thaj vaćarda: “E manušenđe si nemoguće, al e Devlese si sa moguće.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Tegani o Petar vaćarda e Isusese: “Akh! Amen sa ačhadam thaj pale tute dža.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","O Isus phenda: “Čače vaćarav tumenđe, dži jekh savo zbog mande thaj pašo Lačho lafi ačhada po čher, il pe phralen, il pe phejen, il pe da, il pe dade, il pe čhaven, il pe njive, ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","čače ka primil akana, ane kava vreme šel droma pobut čhera, phralen, phejen, dejen, čhaven thaj njive – ano progonstvo – a ane aver buduće sveto ka lol džuvdipe bizo meripe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","But save si akana anglal odori ka aven empalal, a kola save si empalal odori ka aven emanglal.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Kana đele po drom ano Jerusalim, o Isus đelo angle lende. E sikade lese čudisajle so džal ano Jerusalim thaj kola so džana pale lende sesa darade. Tegani o Isus palem crdija ki rig pe dešudujen sikaden thaj lija te vaćarol lenđe so ka avol lesa: ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Akh, dža ano Jerusalim thaj man, e Čhave e manušese, ka den e šorutne sveštenikurenđe thaj e učiteljenđe tare Mojsijaso zakon thaj ka osudin man ko meripe thaj ka den man e abandžijenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Von ka maren muj mancar, ka čhungaren man, ka šibin man thaj ka mudaren man, al pale trin đive me ka uštav tare mule.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Tegani ko Isus avile o Jakov thaj o Jovane, e Zevedejevese čhave thaj vaćarde lese: “Učitelju, manga te ćere amenđe sa so roda tutar.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","O Isus pučlja len: “So manđen te ćerav tumenđe?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Von phende lese: “Mukh amen te beša tusa kana ka ave ane ćiri nebesko slava, jekh ki ćiri desno rig, a o dujto ki ćiri levo rig.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","A o Isus vaćarda lenđe: “Ni džanen so manđen. Šaj li pijen o tahtaj savo me pijav? Šaj li krstin tumen krstimasa savesa me ka krstiv man?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Von vaćarde: “Šaj.” Tegani o Isus vaćarda lenđe: “O tahtaj e patimaso savo me pijav ka pijen i tumen. I o krstipe e patimaso savesa me krsti man, i tumen ka krstin tumen. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Al te bešen manđe ki desno thaj ki levo rig našti dav me. Gola thana preperen kolenđe kase o Dol pripremisada.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Kana gova šunde e avera deš sikade, lije te holjavon po Jakov thaj po Jovane. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","A o Isus dija len vika paše peste thaj vaćarda lenđe: “Tumen džanen kola save vladin e abandžijencar, sikaven po zuralipe pe lende thaj lenđe vođe manđen te gospodarin pe lende. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Al maškar tumende te ma avol gija! Ko manđol te avol maškar tumende baro, nek služil tumen, ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","thaj ko manđol te avol maškar tumende angluno, nek služil savoren. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Golese kaj ni me, o Čhavo e manušeso, ni aviljem te služin man, nego aviljem te služiv thaj mo džuvdipe te dav te bi poćinava butenđe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Tegani resle ano foro Jerihon. Kana o Isus pe sikadencar thaj pherdo manušencar save phirde pale leste, iklilo andaro Jerihon, bešlo pašo drom jekh koro savo prosil, o Vartimej, e Timejeso čhavo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Kana vov šunda kaj avilo o Isus o Nazarećanino, lija te dol vika: “Isuse, Čhaveja e Davideso, smilui tut manđe!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","But džene korisade le te ma dol vika, al vov dija vika vadži po zurale: “Čhaveja e Davideso, smilui tut manđe!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","O Isus ačhilo thaj vaćarda: “Akharen le.” Gija von akharde e kore thaj vaćarde lese: “Ma dara! Ušti, vov akharol tut.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","O Vartimej čhudija o ogrtači pestar, hutija ke pe pingre thaj avilo ko Isus. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","O Isus pučlja le: “So manđe te ćerav tuće?” O koro vaćarda lese: “Učitelju, mangav te dikhav.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","O Isus vaćarda lese: “Dža, ćiro pačajipe sastarda tut!” Thaj tari jekh drom o Vartimej predikhlja thaj pojdisada e dromesa palo Isus. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Kana o Isus thaj lese sikade avile pašo Jerusalim thaj resle paše gava i Vitfaga thaj i Vitanija, ko Maslinsko brego, o Isus bičhalda anglal pe dujen sikaden. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Vaćarda lenđe: “Džan ane kava gav so si angle tumende. Samo so ka resen ane leste, ka aračhen terne here phangle, pe savo vadži khoni ni uklilo. Putren le thaj anen le! ");
INSERT INTO rmyGurbet_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Te pučlja tumen khoni, ‘Sose gova ćeren?’, vaćaren lese, ‘Trubul e Gospodese, al sigate ka iril le.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Gija von đele, arakhlje e terne here phangle ko vudar pašo nekaso čher avri ko drom thaj putarde le. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Nesave manuša save ačhile gothe, pučlje e sikaden: “So ćeren? Sose putaren e terne here?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","A kana e sikade vaćarde so o Isus vaćarda lenđe, e manuša mukhlje len. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Gija ande e terne here ko Isus, čhute po her pe ogrtačura, a o Isus uštilo po terno her. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","But džene buljarde pe ogrtačura po drom a nesave čhinde zelena raja save čhinde ko polje. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Gola save đele angle leste thaj pale leste, dije vika: “‘Hosana! Blagoslovimo si kova so avol ano alav e Gospodeso!’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Blagoslovime si o carstvo amare dadeso e Davideso savo avol! ‘Hosana e Devlese ko učipe!’” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Tegani o Isus dija ano Jerusalim thaj đelo ano Hram. Odori sa dikhlja thaj golese kaj sasa kasno, đelo e dešudujencar apostolurencar ani Vitanija. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Theara đive, kana džana tari Vitanija, o Isus bokhajlo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Odural dikhlja i patrnali smokva, pa đelo paše late te aračhol khanči te xal. Al kana avilo paše late, ni arakhlja khanči samo patrna, golese kaj naj sasa o vreme te bijanol i smokva. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Tegani o Isus vaćarda e smokvaće: “Khoni više te ma xal tar ćo bijanipe ane sa e vremenura!” Thaj šunde gova e sikade lese. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Kana resle ano Jerusalim, o Isus đelo ani avlin e Hramesi thaj lija te tradol kolen save andre biknena thaj ćinena. Irisada e astalura kolenđe save menjina e pare thaj irisada e klupe kolenđe save biknena goluburen. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ni dija khanikase te nakhaven khanči so si bićinimase thaj ćinimase maškari avlin e Hramesi. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Sikada len: “Naj li pisimo ano Sveto lil: ‘O čher mingro nek akhardol čher e molitvako sa e manušenđe’? A tumen lestar ćerden ‘čher kaj garaven pe e čora’.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Kana šunde gova e šorutne sveštenikura thaj e učitelja tare Mojsijaso zakon, lije te roden sar te mudaren e Isuse. Darajle lestar, golese kaj sa e manuša divisajle taro leso sikajipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kana peli i rat, o Isus thaj lese sikade iklile andaro foro. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Sabalje kana o Isus thaj e sikade nakhle paši smokva, dikhlje kaj šućili sa dži o koreno. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Tegani o Petar dija pe gođi thaj vaćarda e Isuse: “Učitelju dikh! I smokva sava dijan armaja, šućili!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Vaćarda lenđe o Isus: “Nek avol tumen pačajipe ano Dol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Čače vaćarav tumenđe: Te khoni vaćarol kale bregose: ‘Ušti thaj čhude tut ano more,’ a ni sumnjil ane po ilo, nego pačal kaj so vaćarol ka avol, gova čače ka avol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Golese vaćarav tumenđe: ‘Paše sa so ka molin thaj so roden, pačan kaj ka primin thaj ka avol tumen gova. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","A kana len te molin tumen, oprostin ako isi tumen khanči protiv nekaste, te bi o Dad savo si ano nebo oprostil tumare grehura. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","A tumen te ni oprostisaden averenđe, ni tumaro Dad ano nebo ni ka oprostil tumenđe tumare grehura.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","O Isus thaj lese sikade palem avile ano Jerusalim. Thaj kana o Isus phirda ani avlin e Hramesi, avile paše leste e šorutne sveštenikura, e učitelja tare Mojsijaso zakon thaj e starešine. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Gija pučlje le: “Ane kaso vlast sa kava ćere? Ko dija tut gova vlast te ćere kava?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","O Isus phenda lenđe: “I me ka pučav tumen khanči. Te vaćarden manđe, i me ka vaćarav tumenđe save vlastesa kava ćerav. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","O Dol li vaćarda e Jovanese te krstil e manušen, il e manuša vaćarde lese gova te ćerol? Vaćaren manđe!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","A von lije te raspravin pe maškar peste: “Te vaćardam: ‘O Dol vaćarda lese,’ ka pučol amen: ‘Sose tegani ni pačajen e Jovane?’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Al te vaćardam: ‘E manuša vaćarde lese gova te ćerol…’” Darajle tare manuša, golese kaj sa e manuša pačaje kaj si o Jovane o Krstitelj čače proroko. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Gija phende e Isusese: “Ni džana.” Tegani o Isus vaćarda lenđe: “I me ni ka vaćarav tumenđe ane savo vlast kava ćerav!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Tegani lija o Isus te vaćarol lenđe ane paramiča sar so si kaja: “Jekh manuš sadisada drakha ano vinograd. Čhuta ograda trujal leste, honda than kaj te uštaven i drakh thaj vazdija stražarsko kula. Tegani dija le ano zakup e vinogradarenđe thaj đelo ani aver phuv. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kana avilo o vreme te ćidol pe i drakh, o gospodari e vinogradeso bičhalda pe sluga te lol leso kotor savo preperol lese taro bijandipe e drakhako. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Al e vinogradara dolde e sluga thaj marde le thaj bičhalde le čuče vastencar te džal pese. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Tegani o gospodari bičhalda dujtone sluga ke lende. E vinogradara phaglje leso šoro thaj ladžarde le. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Thaj bičhalda tritone sluga thaj gole mudarde. Bičhalda thaj buten averen slugen, al e vinogradara nesaven marde thaj nesaven i mudarde. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","E manuše kaso sasa o vinograd, ačhilo te bičhalol samo pe jekhe čhave, save but manglja. Ko krajo bičhalda pe čhave ke lende, golese kaj dija gođi: ‘Ka poštujin me čhave.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Al kana dikhlje le e vinogradara jekh averese vaćarde: ‘Kava si o nasledniko. Aven te mudara le thaj sa amenđe ka ačhol!’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Thaj dolde le, mudarde le thaj čhudije le avral taro vinograd. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","So akana ka ćerol o manuš kaso si o vinograd? Ka avol, ka mudarol e vinogradaren savenđe dija o vinograd ano najam thaj ka dol ano najam o vinograd averenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Džanav kaj čitisaden ano Sveto lil kava: ‘O bar savo čhudije e manuša save vazden e duvara ćerdilo emglavno bar taro čher. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Gova ćerda o Dol thaj čudesno si ane amare jakha’!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Tegani e učitelja tare Mojsijaso zakon dikhlje te dolen le, golese kaj džanglje kaj si kaja paramič lendar. Al darajle tare manuša, golese mukhlje le thaj đele. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Pale gova bičhalde ko Isus nesaven farisejen thaj Irodese manušen te bi dolena e Isuse kaj vaćarol khanči bilačhe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Avile leste thaj vaćarde lese: “Učitelju! Džana kaj vaćare čačipe thaj ni obaziri tu pe khanikaste, golese kaj ni dičhe ko si ko. Thaj čačimasa sikave e manušen tare Devleso drom. Trubul li amen e Jevreja e carose te da porezi il na? Te poćina il na?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Al o Isus džanglja kaj si von dujemujenđe, gija vaćarda lenđe: “Sose čhuven manđe zamka? Anen manđe jekh srebrenjako savesa poćinen o porez, te dikhav.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Von ande lese srebrenjako a o Isus pučlja len: “Kaso si kava muj thaj alav?” Von vaćarde lese: “E caroso.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Tegani o Isus vaćarda “Den e carose so si e caroso, a e Devlese so si e Devleso.” Thaj von but čudisajle lestar. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Tegani avile ko Isus e sadukejura save vaćarde kaj naj uštipe tare mule thaj pučlje le: ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Učitelju! O Mojsije pisisada amenđe ano zakon kana merol nekaso phral thaj ačhavol romnja bize čhave. Gova manuš trubul te lol pe phralese romnja te bi šaj goja romni te bijanol čhave pe phralese, savese ka preperol sa o barvalipe e muleso thaj te phiravol leso alav. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Sesa efta phrala. O angluno ženisajlo, mulo thaj ni ačhada čhaven. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","O dujto lija gole romnja, mulo thaj ni vov ni ačhada čhaven. Gijate i o trito. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Thaj ni jekh tare efta phrala ni ačhada čhaven. A ko krajo thaj i romni muli. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ko đive kana ka ušten e mule, kasi romni voj ka avol? Golese kaj sasa so eftanenđi romni.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","O Isus vaćarda lenđe: “Naj li sen xoxade, golese kaj ni haljarden o Sveto lil ni o zuralipe e Devleso? ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kana e manuša ka ušten tare mule, ni ka len pe niti ka den pe, al ka aven sar anđelura ano nebo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","A pašo uštipe tare mule, džanav kaj čitisaden ane lila e Mojsijase taro grmo savo phabol. Gothe o Dol vaćarda e Mojsijase: ‘Me sem Dol e Avraameso, Dol e Isaakoso thaj Dol e Jakoveso’ thaj von naj ki kaja phuv odavno. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","O Dol naj Dol e mulengo, al vov si Dol e džuvdengo! Tumen sen ano baro xoxaipe!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jekh tare učitelja taro Mojsijaso zakon avilo thaj šunda len so raspravin pe. Kana dikhlja sar šukar lenđe vaćarda o Isus, pučlja le: “Savo si emvažno zapovest tare sa?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","O Isus vaćarda lese: “Emvažno zapovest si: ‘Šun, Izraele! O Gospod amaro Dol, samo si vov Gospod. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Mang e Gospode, će Devle, sa će ilesa, sa će dušasa, sa će gođasa thaj sa će zorasa.’ Kava si angluno zapovest. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","A dujto zapovest si kava: ‘Mang ćire pašutne sar korkore tut!’ Avera zapovestura po bare naj tare akala.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","O učitelji taro Mojsijaso zakon vaćarda lese: “Učitelju, čače si gova. Isi tu pravo kana vaćare kaj isi jekh Dol thaj naj aver lestar. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","A te manga e Devle sa e ilesa, sa e gođasa thaj sa e zuralimasa thaj te manga e pašutnen sar amen korkoren, kava si po baro zapovest nego sa e phabarde thaj sa avera žrtve.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Kana o Isus dikhlja sar gođaver phenol o učitelji taro Mojsijaso zakon, vaćarda lese: “Naj san dur taro Carstvo e Devleso.” Pale kava khoni ni tromaja te pučol le khanči aver. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Kana o Isus sikada ano Hram, pučlja: “Sar e učitelja tare Mojsijaso zakon šaj vaćaren kaj o Hrist si samo e Davideso čhavo? ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","O David korkoro vaćarda ano Sveto Duxo: ‘Vaćarda o Gospod e Gospodese mingrese: Beš manđe ki desno rig te caruji mancar, sa dži kaj ni čhuvav ćire dušmajen tale pingre.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Gijate korkoro o David dol vika e Hriste Gospode. Sar onda šaj te avol o Hrist leso čhavo?” Thaj but džene šunde le oduševime. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Kana o Isus sikavola, vaćarda lenđe: “Aračhen tumen tare učitelja tare Mojsijaso zakon. Von barikane phiren ane kučale fostanura thaj roden e manuša te pozdravin len sar uvažimen ke trgura. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Manđen te bešen ko emvažno than ane sinagoge a ke gozbe ko emangluno than. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ko xoxaipe len o imanje e udovicengo, a garaven pe ane dugačka molitve e Devlese. Gasave ka aven po but osudime nego avera!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","O Isus bešlo prekalo drom i Hramsko kutija kaj ćiden pe pare thaj dičhola sar pherdo manuša čhuvena pare gothe. A but barvale čhuvena but. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","A jekh čori romni kaso rom mulo, avili thaj čhuta duj bakarna pare, save ni vredina but. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Tegani o Isus dija vika pe sikaden paše peste thaj vaćarda lenđe: “Čače vaćarav tumenđe kaj kaja čori romni kaso rom mulo, čhuta ani kutija embut savorendar. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Golese kaj savore lendar dije so sasa len pobut, al voj gija čori sa dija, sa so sasa la.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kana iklilo o Isus andaro Hram, jekh tare lese sikade vaćarda: “Učitelju, dikh save lačhe bara thaj kala lačhe građevine!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","O Isus vaćarda lese: “Dičhe li gola građevine? Ni bar po bar ni ka ačhol. Sa ka avol crdimo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Kana o Isus bešlo ko Maslinsko brego prekal o drom taro Hram, o Petar, o Jakov, o Jovane thaj o Andrija korkore pučlje e Isuse: ");
INSERT INTO rmyGurbet_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Vaćar amenđe kana gova ka avol? Save znakosa ka sikadol gova so ka ćerdol sa gova?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","A o Isus lija te vaćarol lenđe: “Aračhen tumen khoni te ma xoxavol tumen! ");
INSERT INTO rmyGurbet_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","But ka aven ane mingro alav thaj ka vaćaren: ‘Me sem o Hrist.’ Thaj buten ka xoxaven. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kana ka šunen maripe thaj glasura taro maripe save si dur, ma daran! Golese kaj trubul gijate te avol, al gova naj krajo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Golese so ka uštol o narodo po narodo thaj o carstvo po carstvo. I phuv ka tresil pe ke but thana thaj ka aven bune thaj bokhalipe. Gova si anglunipe tare bare muke, sar kana i romni trubul te bijanol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Kana ka avol sa gova, aračhen tumen! Golese kaj ka inđaren tumen ke sudura thaj ke sinagoge. Ka maren tumen thaj zbog mande angle vladara thaj angle carura ka ačhen, te svedočin lenđe mandar. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Al angleder, o Lačho Lafi sa e manušenđe trubul te propovedil pe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kana ka phanden tumen thaj ka inđaren tumen ko sudo, ma angleder te brinin tumen so ka vaćaren. Vaćaren gova so dol pe tumenđe te vaćaren ane gova sato. Golese kaj ni ka vaćaren tumen, nego ka vaćarol o Sveto Duxo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","O phral e phrale ka dol te mudarol pe thaj o dad e čhave. E čhave ka ušten pe dada thaj pe deja, a von ka den te mudaren len. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Thaj savore ka dičhen tumen banđeste paše mande. Al ko ka ačhol dži ko krajo pačavno, ka spasil pe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Kana ka dičhen i ‘grozota savi anol uništipe’, sar ačhol odori kaj naj lako than, sar vaćarol o proroko Danilo – savo čitil kava, nek haljarol – tegani kola save si ani Judeja nek našen pe bregura. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ko si po čher, ma te uljol tele te džal ano čher te lol khanči andral! ");
INSERT INTO rmyGurbet_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Thaj ko si ano polje ma te iril pe te lol po fostano! ");
INSERT INTO rmyGurbet_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Pharo e khamnjenđe thaj kole džuvljenđe save den čuči e čhavorenđe ane gola đivesa! ");
INSERT INTO rmyGurbet_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Molin tumen o našipe tumaro te ma avol ano jevend! ");
INSERT INTO rmyGurbet_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Golese kaj ane gola đivesa ka avol gasavo bilačhipe savo ni sasa taro anglunipe kana o Dol ćerda o sveto, pa dži akana thaj niti ka avol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Al o Dol te ma kratila o đinipe gole đivesengo, khoni ne bi ačhola džuvdo. O Dol e đivesa kratisada paše kola manuša saven vov birisada. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Te phenda tumenđe tegani khoni: ‘Akh kate si o Hrist!’, il ‘Ek okori si!’, ma pačan. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Golese kaj ka ikljen xoxavne hristura thaj xoxavne prorokura thaj ka sikaven znakura thaj čudesura te bi xoxavena, te šaj, čak i e Devlese birimen. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Aračhen tumen! Sa vaćardem tumenđe angleder so ka avol!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Al ane gola đivesa, pale gova bilačhipe, ‘o kham ka kaljol thaj o čhon ni ka sijajil. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","E čerenja ka peren taro nebo thaj e zora e nebose ka tresin pe.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tegani e manuša ka dičhen man, e Čhave e manušese, sar avav pe oblakura e zuralimasa thaj e bara slavasa. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Me ka bičhalav me anđeluren thaj von ka ćiden e birimen tare štar balvalja, taro krajo e phuvako dži o krajo e neboso.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","O Isus vadži vaćarol kaja paramič: “Tari smokva kava sikljon: Kana pe laće raja ikljen pupoljkura thaj mučhen patrna, džanen kaj si o milaj paše. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Gija i tumen kana ka dičhen kaj kava avol, džanen kaj si o vreme paše, anglo vudar. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Čače vaćarav tumenđe, kaj kaja generacija ni ka načhol dok sa kava ni avol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","O nebo thaj i phuv ka načhen, al me lafura nikad ni ka načhen!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Al khoni tare gova đive thaj gova sato ni džanol kana gova ka avol, ni e anđelura taro nebo, pa ni me, o Čhavo. Džanol samo o Dad. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Aračhen tumen! Aven džungade thaj molin tumen! Golese kaj ni džanen kana ka avol gova vreme. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Gova si sar o manuš, savo džal ko drom. Ačhada po čher thaj naredisada e slugenđe so te ćeren. Svakonese dija pi bući thaj e manušese so ačhol ko vudar vaćarda te avol džungado te pazil. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Gija aven džungade, golese kaj ni džanen kana ka avol kova kaso si čher, il angleder i rat, il ki opaš i rat, il kana e bašne đilaben, il ki sabalin. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ako ka avol tare jekh drom, ma te aračhol tumen sar soven. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","So vaćarav tumenđe, vaćarav savorenđe: Aven džungade!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Sasa vadži duj đive dži i Pasha thaj o prazniko e bikvasacose mangrengo. E šorutne sveštenikura thaj e učitelja tare Mojsijaso zakon rodije sar šaj te dolen e Isuse ki prevara thaj te mudaren le. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Al vaćarde: “Na ko baro đive, ma te bunil pe o narodo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Kana sasa o Isus ani Vitanija, ano čher e Simoneso o gubavo thaj bešlo pašo astali, avili jekh džuvli savi sasa la šiši taro mermerno bar pherdo kuč mirisnone uljesa taro čisto nardo. Thaj putarda o šiši thaj čhorda o ulje e Isusese po šoro. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nesave holajle thaj vaćarde maškar peste: “Sose ćerol pe uljesa gasavi šteta? ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Šajine te lol pe trišel dinara pašo gova ulje thaj e pare te den pe e čororenđe.” Thaj lije te den vika pe late. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Al o Isus vaćarda: “Mučhen la! Sose uznemirin la? Voj ćerda manđe šukaripe! ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Golese kaj čorore ka aven uvek maškar tumende thaj šaj ćeren lenđe šukaripe kana manđen. Al me ni ka avav uvek tumencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Voj ćerda so šajine. Angleder makhlja mo telo te pripremil le pašo prahope. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Čače vaćarav tumenđe: Dži kaj ka vaćarol pe o Lačho lafi pe sa o sveto, ka vaćarol pe za ko spomen thaj voj so ćerda.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Tegani o Juda o Iskariotsko, jekh tare dešuduj apostolura, đelo ke šorutne sveštenikura te izdol e Isuse. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Kana von šunde gova, sesa baxtale thaj obećisade lese kaj ka den le pare. Gija o Juda lija te rodol sar šaj te izdol e Isuse. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ko angluno đive taro prazniko e bikvasacose mangrengo, kana čhinol pe o pashalno bakroro palo adeti, pučlje e sikade e Isusese: “Kaj manđe te dža te ćera tuće pashalno večera te xa?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tegani o Isus bičhalda dujen pe sikaden. Vaćarda lenđe: “Džan ano foro thaj gothe ka aračhen jekhe manuše sar anol paj ano baro khoro. Džan pale leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ano čher ane savo vov džal, vaćaren gole čherutnese: ‘O učitelji pučol: Kaj si i soba ane savi šaj xav i pashalno večera me sikadencar?’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Vov ka sikavol tumenđe bari upruni soba savi si sa lačhardi thaj spremimi. Gothe ćeren pashalno večera.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","E sikade iklile. Kana avile ano foro, arakhlje sa sar so vaćarda lenđe o Isus thaj ćerde pashalno večera. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kana peli i rat, o Isus avilo odori pe sikadencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Kana bešena pašo astali thaj xana, o Isus vaćarda: “Čače vaćarav tumenđe, jekh tumendar ka izdol man, kova savo xal mancar!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Von sesa dukhade thaj jekh pale avereste lije te pučen le: “Te naj sem me gova?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","A o Isus vaćarda lenđe: “Jekh tumendar tare dešuduj sikade, savo bolol mancar o mangro ano čaro. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Čače me, o Čhavo e manušeso, mora te merav sar so si pisimo mandar ano Sveto lil, al but pharo kolese ko izdol e Čhave e manušese! Pošukar bi avola lese te ma bijandol!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Kana xana, lija o Isus o mangro, dija hvala, phaglja le thaj ulada e sikadenđe vaćarindoj: “Len! Xan! Kava si o telo mingro.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Pale gova lija o tahtaj, zahvalisada e Devlese, dija len thaj savore pilje. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Thaj vaćarda lenđe: “Kava si mingro rat so ćerol nevo savez, savo ka čhordol paše but džene. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Čače vaćarav tumenđe, kaj ni ka pijav više mol dži kova đive kana ka pijav nevi mol ano Carstvo e Devleso.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Pale gova đilabije psalmura thaj iklile ko Maslinsko brego. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Tegani vaćarda lenđe o Isus: “Savore ka ačhaven man kaja rat, golese so o Dol vaćarol ano Sveto lil: ‘Ka peravav e pastire thaj e bakre ka našen.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","A palo mo uštipe tare mule ka džav angle tumende ani Galileja thaj odori ka ađućarav tumen.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","O Petar vaćarda e Isusese: “Te ačhade tut savore, me na!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","O Isus vaćarda lese: “Čače vaćarav tuće, kaj ađive, vadži ani akaja rat angleder so o bašno duj drom ka đilabol, trin droma ka vaćare kaj ni pindžare man.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Al o Petar po zuraleste vaćarda: “Te trubuja te merav tusa, ni ka vaćarav kaj ni pindžarav tut!” Gijate vaćarde sa e sikade. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","O Isus thaj lese sikade avile ano than kaj isi but masline a savo akhardol Getsimanija thaj o Isus vaćarda lenđe: “Bešen kate dok me moli man.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Lija pesa e Petre, e Jakove thaj e Jovane. Thaj e Isuse dolda baro nemir thaj pharipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Vaćarda lenđe: “Žalosno si but mo ilo dži o meripe. Ađućaren kate thaj aven džungade.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Đelo zala po dur, pelo mujesa pi phuv thaj molisada pe te šaj te nakhavol le o vreme tari patnja. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Thaj vaćarda: “Abba! Dade! Tuće si sa moguće! Crde kava tahtaj tari patnja mandar! Al gija te ma avol so me mangav, nego sar tu manđe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Pale gova irisajlo ke sikade thaj arakhlja len sar soven. E Petrese vaćarda: “Simone! Tu li sove? Našti li jekh sato te ave džungado? ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Aven džungade thaj molin tumen te ma peren ano iskušenje. Golese kaj o duxo tumaro manđol te ćerol so si šukar, al o telo tumari si slabo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Palem o Isus đelo thaj molisada pe gola ista lafura. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Kana irisajlo, arakhlja len palem sar soven, golese kaj lenđe jakhenđe sasa pharo thaj ni džanglje so te vaćaren lese. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Kana irisajlo trito drom, vaćarda lenđe: “Tumen vadži soven thaj odmorin? Dosta sasa! Avilo o sato! Akh, man, e Čhave e manušese, den ane vasta e grešnikurenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ušten te dža! Akh, mo izdajniko si paše!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Sar o Isus vadži vaćarda, avilo o Juda, jekh tare dešuduj sikade thaj lesa e manuša čhurencar thaj kaštencar save sesa bičhalde tare šorutne sveštenikura thaj učitelja tare Mojsijaso zakon thaj tare starešine. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","A o izdajniko angleder vaćarda e stražarenđe savo znako ka dol len: “Kas čumidav, gova si. Dolen le thaj inđaren le tali straža.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Kana o Juda avilo, sigate đelo pašo Isus thaj vaćarda: “Učitelju!” Thaj čumidija le. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Tegani kola manuša grabisade e Isuse thaj phanglje le. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","A jekh tare kola so ačhena gothe, ikalda pi čhuri thaj lasa čhinda o kan jekhese tare sluge e bare sveštenikoso. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Tegani o Isus vaćarda lenđe: “Sar palo razbojniko ikliljen čhurencar thaj kaštencar te dolen man? ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Svako đive sema tumencar thaj sikadem ano Hram al tumen ni dolden man. Al kava sasa golese te bi pherdola kova so si pisimo mandar ane Sveta lila.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tegani sa e sikade ačhade le thaj našle. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Palo Isus phirda nesavo terno čhavo so inđarda laneno čaršafi po nango telo. Kana le dolde, ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","vov čhudija o čaršafi thaj nango našlo lendar. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Tegani ande e Isuse anglo baro svešteniko, kaj ćidije pe sa e šorutne sveštenikura, e starešine thaj e učitelja tare Mojsijaso zakon. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","O Petar odural džala palo Isus dži ke bare sveštenikosi avlin. Gothe bešlo e stražarencar thaj tatilo paši jag. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","E šorutne sveštenikura thaj sa o Baro sudo rodije nesavo dokaz te bi mudarena e Isuse, al ni arakhlje. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Golese kaj but džene vaćarde xoxaipe pe leste, al lengo vaćaripe ni sasa isto. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Pale gova uštile nesave manuša thaj svedočisade xoxavne lestar: ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Amen šundam le sar vaćarol: ‘Me ka phagav kava Hram savo si vastencar ćerdo thaj ka vazdav paše trin đive nevo savo ni ka avol ćerdo vastencar.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Al ni ane kava vaćaripe ni sesa ista. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tegani uštilo o baro svešteniko, ačhilo maškaral thaj pučlja e Isuse: “Sose khanči ni odgovori pe kava so kala manuša svedočin protiv tute?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Al o Isus khanči ni vaćarda. Gija o baro svešteniko palem pučlja le: “Tu li san o Hrist, Čhavo e Blagoslovimeso Devleso?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","O Isus vaćarda: “Me sem. Thaj ka dičhen man, e Čhave e manušese, sar bešav ko počasno than e Zurale Devlese ki desno rig thaj sar avav pe oblakura taro nebo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","O baro svešteniko pharada pe šeja tari holi thaj vaćarda: “So trubun amen avera svedokura? ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Šunden lesi hula. So den gođi?” Thaj von savore osudisade le kaj trubul te merol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tegani nesave lije te čhungaren le. Učharde leso muj, čalade le dumukhencar thaj vaćarde lese: “Prorokuji, ko čalada tut!” Thaj e stražara lije te maren le po muj. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Dok sasa o Petar tele ki avlin, avili jekh terni džuvli savi služila ko baro svešteniko. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Kana dikhlja e Petre sar tatol paši jag, avili po paše thaj po lačhe dikhlja ane leste thaj vaćarda: “I tu sana e Nazarećaninesa, e Isusesa!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Al vov odreknisajlo thaj vaćarda: “Ni džanav thaj ni haljarav so tu vaćare.” Tegani iklilo ano angluno kotor e avlijako thaj o bašno đilabija. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Palem dikhlja le koja terni džuvli savi služila thaj lija te vaćarol kalenđe so ačhena gothe: “Kava manuš si jekh lendar!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Al o Petar palem odreknisajlo. Pale nesavo vreme, e manuša save ačhile gothe, vaćarde e Petrese: “Čače san jekh lendar golese kaj san i tu Galilejco ćo vaćaripe si gasavo!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Vov lija te dol pe armaja thaj te xal sovli: “Me ni džanav gole manuše kastar vaćaren!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Sigate đilabija o bašno dujto drom. Tegani o Petar dija pe gođi so o Isus vaćarda lese: “Angleder so o bašno duj drom ka đilabol, trin droma ka vaćare kaj ni pindžare man.” Thaj lija but te rovol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Sigate sabalin ćidije pe e šorutne sveštenikura, e učitelja tare Mojsijaso zakon, e starešine thaj savore taro Baro sudo. Phanglje e Isuse, inđarde le thaj predije le ko rimsko upravitelji ko Pilat. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","O Pilat pučlja e Isuse: “Tu li san o caro e Jevrejengo?” O Isus vaćarda e Pilatese: “Tu vaćare korkoro.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","A e šorutne sveštenikura tužisade le paše but buća. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Tegani o Pilat palem pučlja le: “Dal naj tu khanči te vaćare ke kava? Dičhe li paše so sa tužin tut?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Al o Isus khanči ni vaćarda, golese sasa o Pilat but začudime. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","O Pilat ko vreme e Bare đivesengo mučhola jekhe phangle save e manuša manđen. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Tegani ano phanglipe sesa pobunjenikura save mudarena ani pobuna, a maškar lende sasa i jekh manuš kaso alav sasa Varava. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","But manuša avile te roden taro Pilat te mučhol jekhe phangle sar obično ćerola ko Baro đive. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","O Pilat pučlja len: “Manđen li te mukhav tumenđe kole caro e Jevrejengo?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Vaćarda kava golese kaj džanglja kaj e šorutne sveštenikura predije e Isuse taro zavist. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Al e šorutne sveštenikura čhute e manušen te roden taro Pilat te mučhol lenđe e Varava. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","A o Pilat palem pučlja len: “A so te ćerav kalesa so den le vika caro e Jevrejengo?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","A von lije te den vika: “Čhuv le ko krsto!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Tegani o Pilat pučlja: “Savo bilačhipe ćerda?” Al von vadži po zurale dije vika: “Čhuv le ko krsto!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","O Pilat manglja te avol šukar e manušencar, golese mukhlja lenđe e Varava. A e Isuse dija te šibin thaj dija te čhuven le ko krsto. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Tegani e vojnikura inđarde e Isuse ki palata so si pretorijum thaj dije vika četa vojnikuren. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Urade e Isuse skerletno ogrtači, khuvde lese venco tare kangre thaj čhute lese po šoro. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tegani lije te maren muj lesa vaćarindoj: “Te ave sasto, carona e Jevrejengo!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Čalade le po šoro e trskasa, čhungarde le thaj pele ke pe koča te klanjin pe lese – te bi asana lesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kana ačhade te maren muj lesa, uljarde lestar o skerletno ogrtači thaj urade le ane leso fostano. Tegani ikalde le te čhuven le po krsto. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","A nesavo manuš o Simon tari Kirina, o dad e Aleksandreso thaj e Rufoso, nakhlo gothar kana irisajlo andari njiva thaj e vojnikura terisade le te inđarol o krsto e Isuseso. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","E Isuse ande ko than savo akhardola Golgota, so značil “Kokalo e šoreso”. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","A nesave odori kanisade le te pijol mešimi mol e smirnasa, te bi ačhola lesi dukh, al vov ni manglja. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","E vojnikura čhute le ko krsto, ulade maškar peste lese šeja thaj čhudije kocka te dičhen ko so ka lol. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Sasa enja o sato sabalinasa kana čhute le ko krsto. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","O natpis paše lesi krivica sasa: “O Caro e Jevrejengo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","A e Isusesa ke avera krstura čhute i dujen razbojnikuren, jekhe tari lesi desno rig thaj e dujtone tari lesi levo rig. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Golesa pherdilo so si pisimo ano Sveto lil: “Dikhlje le sar jekhe tare kola save ćeren bilačhipe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","E manuša save nakhle gothar, vređisade le thaj vrtisade šorencar vaćarindoj: “Ej tu, so phađe o Hram thaj paše trin đive vazde le, ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","spasi korkoro tut! Ulji akana taro krsto!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","A gijate marde muj e Isusesa i e šorutne sveštenikura thaj e učitelja tare Mojsijaso zakon. Jekh averese vaćarde: “Averen spasisada, a korkore pes našti te spasil? ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Hriste! Carona e Izraeleso! Ulji akana taro krsto te dikha thaj te pača.” Marde lesa muj thaj kola razbojnikura so sesa po krsto lesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ane opaš đive učharda o kalipe pi sa i phuv, sa dži ko trito sato. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ko trito sato dija vika o Isus andaro baro glaso: “Eloi! Eloi! Lama sabahtani?” (So značil: “Devla mingreja! Devla mingreja! Sose mukhljan man?”) ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nesave save ačhile gothe, kava šunde thaj vaćarde: “Dičhen, akharol e proroko e Ilija!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Jekh manuš prastija, pherda o sunđeri šutesa, čhuta pi trska thaj kanisada e Isuse te pijol vaćarindoj: “Ačh te dikha, da li ka avol o Ilija te uljarol le.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","A o Isus andaro baro glaso dija vika thaj mulo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","I zavesa pharadili ano sveto than e hrameso ke opaš odupral natele. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kana o rimsko kapetano savo ačhilo gothe pašo Isus dikhlja sar mulo, vaćarda: “Čače, kava manuš sasa Čhavo e Devleso!” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Gothe sesa nesave džuvlja, save gova dikhlje odural. Maškare lende sasa i Marija Magdalena, i Marija i dej e Jakovesi e ternesi thaj e Josijasi, thaj i Saloma. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Von phirde palo Isus thaj služisade le, kana sasa ani Galileja. Sesa gothe i avera džuvlja save avile lesa ano Jerusalim. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Kana lija te perol i rat, a sar sasa đive paši Priprema, so si đive anglo savato, ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","đelo o Josif taro foro Arimateja bidarako ko Pilat thaj molisada le pašo telo e Isuseso. O Josif sasa pošteno člano taro Baro sudo thaj i vov ađućarda te avol o Carstvo e Devleso. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Al o Pilat čudisajlo kaj gaći sigate mulo o Isus. Dija vika e rimskone kapetano thaj pučlja le: “Da li odavno mulo?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Kana dodžanglja o Pilat taro rimsko kapetano kaj mulo o Isus, dija o telo e Josifese. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Gija o Josif ćinda laneno čaršafi, uljarda e Isuseso telo taro krsto, paćarda le ano čaršafi thaj čhuta le ano limori savo sasa čhindo ani stena. Tegani o vudar taro limori phanglja baresa. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","A i Marija Magdalena thaj i Marija e Josijasi dej dikhlje kaj o Josif čhuta e Isuse. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kana nakhlo o savato, i Marija Magdalena, i Marija e Jakovesi dej thaj i Saloma ćinde mirisura te bi džana te mačhen e Isuseso telo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Rano sabalje ko angluno đive ano kurko kana iklilo o kham, avile ko limori. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Odrumal pučlje pe maškare peste: “Ko ka crdol o bar taro vudar e limoreso?” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Al kana resle thaj dikhlje, o bar savo sasa but baro, sasa crdimo taro limori. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Gija dije andre ano limori thaj dikhlje terne manuše savo sasa urado ano parno fostano te bešol ki desno rig thaj von darajle. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Vov phenda lenđe: “Ma daran! Tumen roden e Isuse e Nazarećanine, save čhute ko krsto. Naj kate, golese kaj uštilo tare mule! Dičhen o than kaj čhute le. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Al tumen džan thaj vaćaren lese sikadenđe thaj e Petrese: ‘O Isus džal angle tumende ani Galileja. Odori ka dičhen le, sar so vaćarda tumenđe.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Tegani e džuvlja iklile thaj prastije andaro limori, golese kaj sesa zbunime thaj tresisade. Al čače khanikase khanči ni vaćarde, golese kaj darajle. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Kana o Isus uštilo tare mule rano ko angluno đive ano kurko, angleder sikada pe e Marijaće e Magdalenaće, andar savi vadži angleder ikalda efta benđen. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Voj đeli thaj vaćarda kava kolenđe save angleder sesa lesa thaj save akana ruje thaj pharo sasa lenđe palo Isus. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Kana šunde kaj si o Isus džuvdo thaj kaj voj dikhlja le, ni pačaje la. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Pale gova o Isus sikadilo dujenđe tare lese sikade kana đele ano gav, al ni izgledisada gija sar ane po džuvdipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Kana pindžarde le, von đele thaj vaćarde kava averenđe. Al khoni ni pačaje len. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pale gova o Isus sikadilo e dešujekhe (11) apostolurenđe save bešle te xan mangro. Korisada len kaj naj len pačajipe thaj kaj si zurale lenđe ile, golese kaj ni pačaje kolen so dikhlje le pale leso uštipe tare mule. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Vaćarda lenđe: “Džan ano sa o sveto thaj vaćaren taro Lačho lafi sa e manušenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ko ka pačal thaj krstil pe, ka spasil pe. Al ko ni ka pačal, ka avol sudimo. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Kala čudesna znakura ka pratin kolen save pačan: me alavesa ka ikalen e benđen thaj ka vaćaren neve čhibencar, ");
INSERT INTO rmyGurbet_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ka dolen e sapen vastencar thaj ako i khanči otrovno pijen, khanči ni ka avol lenđe, pe nasvale ka čhuven pe vasta thaj von ka saston.” ");
INSERT INTO rmyGurbet_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kana o Gospod o Isus vaćarda lenđe kava, sasa vazdimo ano nebo thaj bešlo e Devlese ki desno rig. ");
INSERT INTO rmyGurbet_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Tegani e sikade đele thaj vaćarde o Lačho lafi ke sa e thana. O Gospod pomognisada lenđe thaj e čudesnone znakurencar potvrdisada o Lačho lafi savo von propovedisade. Amin.");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Mangleja Teofile, sar so džane, but džene lije te pisin tare kova so sasa, so o Dol obećisada prekale prorokura, a ćerdilo maškar amende. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Pisisade amenđe kola save korkore dikhlje vadži tare anglune đivesa thaj ćerdile sluge e Devlese Lafese, ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","gija i me, mangleja Teofile, tuće pisiv sa redasa, golese so sa taro anglunipe ispitujisadem, ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","te šaj ave uverimo kaj si čačipe kova so sikade tut. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Kana sasa o Irod caro ani Judeja, nesavo manuš savo akhardola Zaharija sasa svešteniko tare Avijineso redo. Lesi romni sasa tari kuštik e Aaronesi thaj akhardola Jelisaveta. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Solduj džene sesa čačutne anglo Dol thaj živisade pale zapovestura thaj palo Zakon e Gospodeso bizo nisavo bilačhipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Al len ni sesa čhave, golese kaj i Jelisaveta naštine te ačhol khamni, a solduj džene sesa već purane. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Jekh đive, o Zaharija služisada e Devle ano Hram golese kaj palo dužnost sasa leso redo, ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","golese so, palo adeti e sveštenikurengo birisade le kockasa te džal ano Hram e Gospodeso te kadil. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Kana o Zaharija dija ano Hram te kadil, but manuša molisajle avral. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Tegani e Zaharijase sikadilo o anđelo e Gospodeso savo ačhilo ki desno rig taro žrtveniko e kadimaso. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Kana o Zaharija dikhlja le, uznemirisajlo thaj but darajlo. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Al o anđelo vaćarda lese: “Ma dara, Zaharije! Ćiri molitva sasa šundi. Ćiri romni i Jelisaveta ka bijanol murše thaj tu ka de le alav Jovan. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Tu ka ave radosno thaj baxtalo thaj but džene ka aven blagoslovime lese bijandimasa, ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","golese kaj vov ka avol baro anglo Gospod. Nikad ni ka pijol mol ni zuralo pijipe. Vov ka pherdol e Svetone Duxosa dok si ano vođi pe dako. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","O Jovane bute Izraelcuren ka iril anglo Gospod, angle lengo Dol. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Vov ka džal anglo Gospod sar glasniko ano Duxo thaj ano zuralipe e prorokoso e Ilijaso. Ka miril e ile e dadenđe premale e čhave thaj ka iril kolen save ni šunen ano gođaveripe e pravednikurengo. Sa kava ka ćerol te pripremil e manušen te šaj aven spremna e Gospodese avimase.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","O Zaharija vaćarda e anđelose: “Pale soste me gova ka džanav? Golese kaj sem purano thaj mingri romni si bute beršenđi.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","O anđelo phenda lese: “Me sem o Gavrilo, o anđelo savo ačhol anglo Dol. Bičhaldo sem te vaćarav tuće kava lačho lafi. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Akh, ka ave laloro thaj ni ka vaćare dži gova đive dži kaj sa gova ni ćerdol, golese so ni pačajan ane mingre lafura save ka pherdon ano pravo vreme.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","E manuša ađućarde e Zaharija thaj čudisajle sose gaći majisajlo ano Hram. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Al kana o Zaharija iklilo, naštine te vaćarol. Vov dija len znakura golese kaj sasa laloro. Gija e manuša haljarde kaj sasa le vizija ano Hram. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Kana nakhle e đivesa lese služimase ano Hram, o Zaharija đelo čhere. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Pale kala đivesa i Jelisaveta lesi romni ačhili khamni thaj ni iklili avral taro čher pandž čhon. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Golese i Jelisaveta vaćarda: “Gija ćerda manđe o Gospod! Ane kala đivesa sikada manđe po milost thaj uljarda mandar i ladž maškare manuša kaj ni sasa man čhave.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Kana i Jelisaveta sasa šovto čhon khamni, o Dol bičhalda e anđelo e Gavrilo ano Galilejsko foro o Nazaret ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ki čhej i Marija savi sasa mangli romese e Josifese savo sasa tari kuštik e carosi e Davidesi. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Kana o anđelo o Gavrilo avilo late, phenda: “Av radosno, tu so arakhljan milost. O Gospod si tusa. Blagoslovimi san maškare džuvlja!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","I Marija but darajli tare lese lafura thaj dija gođi savo sasa kava pozdrav. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Al o anđelo o Gavrilo phenda laće: “Ma dara, Marijo! Golese kaj arakhljan milost anglo Dol. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Akh, ka ačhe khamni, ka bijane čhave thaj ka de le alav Isus. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Vov ka avol baro thaj ka akhardol Čhavo e Embare Devleso. O Gospod o Dol ka dol le o presto lese paradadeso e Davideso. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Vov ka carujil ane kuštika e Jakovese ane sa e đivesa thaj lese carstvose ni ka avol krajo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tegani i Marija pučlja e anđelo: “Sar ka avol gova kana sem me vadži čhej?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","O anđelo o Gavrilo vaćarda laće: “O Sveto Duxo ka avol pe tute thaj o zuralipe e Embare Devleso ka učharol tut. Golese kaj o čhavoro so ka bijandol ka avol sveto thaj ka akhardol Čhavo e Devleso. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Akh, i ćiri bibi i Jelisaveta ačhili khamni ane purane berša thaj ka bijanol murše. E manuša vaćarde kaj voj naštine te ačhol khamni, al akana si šov čhon khamni. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Golese kaj o Dol šaj te ćerol sa so phenol!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","I Marija phenda: “Ake, me sem sluškinja e Gospodesi. Nek avol manđe palo ćiro lafi!” Thaj o anđelo đelo latar. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Pale gola đivesa i Marija spremisajli thaj siđarda ani bregali phuv ano foro e Judejako. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Kana resli odori, đeli ano čher e Zaharijaso thaj pozdravisajli e Jelisavetasa. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Kana i Jelisaveta šunda e Marijako pozdrav, čhelda o čhavo ane lako vođi thaj i Jelisaveta pherdili Svetone Duxosa. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Andare sa o glaso vaćarda e Marijaće: “Emblagoslovimi san maškare sa e džuvlja thaj blagoslovimo si o čhavo ane ćiro vođi. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Kotar manđe kava čast kaj tu, i dej mingre Gospodesi, aviljan ke mande? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Golese dikh, kana šundem ćiro pozdrav, taro radost čhelda o čhavoro ane mingro vođi. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Blagoslovimi san tu so pačajan kaj ka pherdol kova so vaćarda tuće o Gospod!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Tegani i Marija vaćarda: “Slavil mingri duša e Gospode! ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Mingro duxo veselil pe ano Dol, ane mingro Spasitelji, ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","golese so sasa milostivno e poniznone sluškinjaće. Golese dikh, od akana ka akharen man blagoslovimi sa e kuštika. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Golese so ćerda manđe baro šukaripe o Zuralo Dol. Sveto si leso alav! ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Vov si milostivno sa e manušenđe tari kuštik dži i kuštik, kolenđe save daran lestar. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Pe vastesa sikada piro zuralipe, čhudija pestar kolen save si barikane ane ile thaj ani gođi. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Čhudija e vladaren taro lengo presto, thaj vazdija e poniznonen. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","E bokhalen čaljarda šukarimasa, a e barvalen mukhlja čuče vastencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Pomožisada e Izraele, ćire sluga, golese kaj dol pe gođi taro milost, ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","sar so obećisada amare paradadenđe, e Avraamese thaj lese potomkurenđe ane sa e đivesa.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","I Marija bešli e Jelisavetasa paše trin čhon thaj pale gova irisajli čhere. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Kana i Jelisavetaće avilo o sato te bijanol, bijanda čhave. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Laće pašutne thaj lačhi familija šunde kaj o Gospod sikada laće baro milost thaj radujisajle lasa. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kana e čhavore sesa ohto đive, avile te ćeren lese suneti thaj manglje te den le alav lese dadeso – Zaharija. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Al i Jelisaveta vaćarda: “Na, leso alav ka avol Jovan!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Von phende lačhe: “Naj tut khoni ani ćiri familija gole alavesa!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Tegani vastencar pučlje e dade e Zaharija sar bi vov manđola te avol leso alav. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Thaj o Zaharija manglja khanči pe soste šajine te pisil thaj pisisada: “Jovan ka avol leso alav.” Thaj savore čudisajle. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Tare jekh drom putardilo leso muj thaj lesi čhib, tegani o Zaharija lija te vaćarol thaj lija te slavil e Devle. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","I dar e Devlesi avili ane sa lenđe pašutne thaj ki sa i bregali Judeja vaćarda pe tare kava so sasa. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Savore so šunde gova, dije gođi tare gova thaj phende: “So ka avol tare kava čhavo? Golese so o va e Gospodeso sasa pe leste.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","O Zaharija, e Jovaneso dad, pherdilo e Svetone Duxosa thaj prorokujisada: ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Blagoslovimo si o Gospod o Dol e Izraeleso, golese so avilo thaj otkupisada e manušen! ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Vazdija amenđe e zurale Spasitelje, tari kuštik e carosi e Davidesi, pe slugase, ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","sar so vaćarda ano purano vreme andare muja tare pe sveta prorokura, ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","kaj ka ikalol amen tare amare dušmanura thaj tare vasta savorenđe save mrzin amen. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Sasa milosno amare paradadenđe, thaj ispunisada piro sveto savez, ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","savez savo dija e Avraamese amare paradadese, ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","te ikalol amen tare vasta amare dušmajenđe, te šaj služi e Devle bizi dar, ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ano svetost thaj ano pravednost angle leste sa dok sam džuvde. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","A tu Jovane, čhaveja mingreja, ka ave akhardo proroko e Embare Devleso, golese so ka dža anglo Gospod te pripremi lese o drom. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ka sikave lese manušen sar te pindžaren o spasenje prekalo oproštenje tare lenđe grehura. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Golese so si e Devleso ilo milostivno, tare savo ka avol amenđe o svetlost e sabalinako tari visina, ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","te svetlil kolenđe so bešen ano kalipe thaj ani sena e merimasi, a amare pingre te usmeril ko drom taro mir.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","A o čhavoro o Jovane barilo thaj zurajlo duxosa. Kana barilo, đelo ani pustinja sa dži kaj ni iklilo angle Izraelcura te propovedil. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ane gola đivesa kana bijandilo o Jovane o Krstitelj, iklilo o vaćaripe e caroso e Avgustineso te popisin pe sa e manuša ano Rimsko carstvo. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kava sasa angluno popis kana o Kvirinije vladisada ani Sirija. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Thaj savore đele te pisin pumare alava ko spisko – dži jekh ane gova foro kaj bešle lenđe kuštika. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Gija o Josif, golese so sasa tari familija thaj tari kuštik e Davidesi, đelo taro Nazaret, so si ani Galileja, ano foro e Davideso savo akhardol Vitlejem thaj si ani phuv Judeja. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Đelo gothe te pisil piro alav ko spisko e Marijasa, savi sasa mangli lese thaj sasa khamni. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Kana sesa ano Vitlejem, avilo o vreme i Marija te bijanol. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Thaj bijanda pe anglune čhave. Paćarda le thaj čhuta le ani jaslica, golese kaj naj sasa than ani gostionica. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ane goja phuv pašo Vitlejem sesa nesave čobanura, save arakhlje pe bakren raćasa ke poljura. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tari jekh drom o anđelo e Gospodeso ačhilo maškare lende thaj e Gospodesi slava svetlisada len thaj von but darajle. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Al o anđelo vaćarda lenđe: “Ma daran! Dikh, anav tumenđe radosno lafi so ka avol sa e manušenđe! ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Golese kaj ano foro e Davideso ađive bijandilo o Spasitelj. Vov si o Hrist o Gospod. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kava ka avol tumenđe znako pale savo ka pindžaren le: ka aračhen čhavore savo si paćardo thaj pašljol ani jaslica.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tari jekh drom pašo anđelo sikadili bari vojska e anđelurenđi, save hvalina e Devle vaćarindoj: ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Slava e Devlese ko učipe, thaj ki phuv mir maškare manuša save si pale Devleso manglipe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Kana e anđelura đele lendar ano nebo, e čobanura phende jekh averese: “Ka dža dži o Vitlejem, te dikha gova so sasa odori sar so vaćarda amenđe o Gospod.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","E čobanura đele sigate thaj arakhlje e Marija, e Josife thaj e čhave sar pašljol ani jaslica. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Kana dikhlje le, savorenđe vaćarde so o anđelo lenđe vaćarda taro čhavoro. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Savore save šunde so phende e čobanura, divisajle. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Al i Marija dija gođi tare kala lafura thaj čhuta len ane piro ilo. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","E čobanura irisajle, slavisade thaj hvalisade e Devle paše sa so šunde thaj dikhlje, golese so pherdile sa e lafura sar so sasa lenđe phendo. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ohtoto đive palo bijandipe e čhaveso avilo o vreme te ćeren lese suneti. Dije le alav Isus, sar so vaćarda o anđelo angleder so i Marija ačhili khamni. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Kana avilo o vreme pašo adeti i dej te thodol sar so si pale Mojsijaso zakon, o Josif thaj i Marija ande e Isuse ano Jerusalim te preden le e Gospodese ano Hram, ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","sar so si pisimo ane Gospodeso zakon: “Dži jekh angluno murš te posvetil pe e Gospodese”, ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","thaj te anen žrtva “duj grlice il duj terne golubura” sar so si phendo ane Gospodeso zakon. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Tegani sasa ano Jerusalim manuš kaso alav sasa Simeon. Gova manuš sasa pravedno thaj devlikano. Ađućarda o Mesija te ikalol o Izrael taro ropstvo thaj o Sveto Duxo sasa pe leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","O Sveto Duxo sikada lese angleder kaj ni ka merol sa dži kaj ni dičhol e Gospode e Hriste. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","O Duxo vaćarda lese te džal ano Hram. Tegani o Josif thaj i Marija ande e čhave e Isuse ano Hram te ćeren o adeti pale Mojsijaso zakon. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Kana o Simeon dikhlja e Isuse, lija le ke pe vasta, hvalisada e Devle vaćarindoj: ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Gospode, akana mukh ano mir te merol ćiro sluga, pale kova sar so phendan. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Golese so mingre jakha dikhlje ćiro spasenje, ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","savo pripremisadan angle sa e manuša. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Vov si svetlo savo ka avol pe abandžije, thaj vov ka anol slava ćire manušenđe, e Izraelcurenđe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","E Isusesi dej thaj leso dad čudisajle golesa so vaćarda o Simeon taro Isus. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Tegani blagoslovisada len o Simeon thaj vaćarda e Marijaće, e Isusese daće: “Dikh, kava čhavoro si odredimo bute manušen taro Izrael te peravol thaj te vazdol. Vov si odredimo te avol e Devleso znako, al but džene ka odbacin le. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Gija ka sikadol so garandoj den ane pumare gođa. A tut i bari čhuri ka pusavol ani duša.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Sasa gothe thaj i Ana, e Devlesi proročica, e Fanuilosi čhej, tari kuštik e Asiresi. Voj sasa but purani. Efta berš živisada pe romesa thaj lako rom mulo, ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","thaj pale gova sasa udovica ohtovardeš thaj štar (84) berš. Ni iklili andaro Hram, nego, ano post thaj ani molitva služisada e Devle i rat thaj o đive. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","I voj avili gothe ane gova vreme, hvalisada e Devle thaj vaćarda taro čhavoro savorenđe save ađućarde o Dol te ikalol o Jerusalim. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Kana o Josif thaj i Marija ćerde sa pale Gospodeso zakon, irisajle ani Galileja, ane pumaro foro ano Nazaret. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","A o čhavoro barilo thaj zurajlo. Pherdilo gođaveripe thaj o milost e Devleso sasa ane leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","E Isusesi dej thaj leso dad đele svako berš ano Jerusalim ko prazniko i Pasha. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kana sasa e Isuse dešuduj (12) berš, i vov đelo palo adeti te svetkujil lencar kava prazniko ano Jerusalim. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Kana nakhlo gova prazniko, o Josif thaj i Marija đele čhere. O čhavoro o Isus ačhilo ano Jerusalim, al lesi dej thaj leso dad gova ni džanglje. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Sar dije gođi kaj si o Isus maškare avera manuša save putujisade lencar, đele jekh đive phirindoj thaj pale gova lije te roden le ki familija thaj ke pe pindžarutne manuša. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Kana ni arakhlje le, irisajle ano Jerusalim te roden le. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","O trito đive arakhlje le ano Hram sar bešol maškare učitelja, sar šunol len thaj pučol len. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Savore save šunena e Isuse divisajle lese džanglimasa thaj sar odgovorila ko pučipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Kana lesi dej thaj leso dad dikhlje le, čudisajle. Lesi dej vaćarda lese: “So ćere amencar kava, mo čhavo? Akh, me thaj ćiro dad daraljam thaj rodijam tut!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","O Isus vaćarda lenđe: “Sose rodijen man? Ni li džanen kaj trubul te avav ano čher mingre Dadeso?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Al von ni haljarde so vov manglja te phenol lenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Tegani irisajlo lencar ano Nazaret thaj ane sa šunola len. Lesi dej sa kala lafura garada ane piro ilo. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","O Isus barola ano gođaveripe, ano zrelost thaj ano milost anglo Dol i angle manuša. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Kana o cezar o Tiberija vladisada po rimsko carstvo dešupandžto (15) berš, o Pontije o Pilat vladisada ani Judeja, o Irod vladisada ani Galileja, o Filip leso phral vladisada ani Itureja thaj ani Trahonitida thaj o Lisanije vladisada ani Avilina, ");
INSERT INTO rmyGurbet_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","a kana o Ana thaj o Kajafa sesa šorutne sveštenikura, o Lafi e Devleso avilo e Jovanese, e Zaharijase čhavese, ani pustinja. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","O Jovane o Krstitelj đelo taro than dži ko than tare solduj riga tari len e Jordanesi thaj propovedisada kaj e manuša trubun te irin pe tare pumare grehura thaj te aven ko Dol te oprostil lenđe thaj te krstin pe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Sar so angleder pisisada o proroko o Isaija: “O glaso koleso so dol vika ani pustinja: ‘Pripremin o drom e Gospodese! Ravnin lese o drom! ");
INSERT INTO rmyGurbet_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Sa e doline te pherdon, thaj sa e gore thaj e bregura te ravnin pe! Sa e banđe droma te aven prava, a e bilačhe droma te aven ravnime. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Thaj sa e manuša ka dičhen e Devleso spasenje!’” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","O Jovane vaćarda bute manušenđe save avena ke leste te krstil len: “Tumen e sapese čhave! Ko vaćarda tumenđe kaj šaj te našen tare Devlesi holi savi avol? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Sikaven tumare džuvdimasa thaj tumare bućencar kaj irisaljen tare tumare grehura! Ma xoxaven tumen golesa so vaćaren: ‘Amaro paradad si o Avraam!’ Golese kaj, me vaćarav tumenđe kaj o Dol šaj i tare kala bara te vazdol čhaven e Avraamese. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Golese kaj o tover taro sudo e Devleso ačhol pašo koreno e kašteso thaj dži jekh kaš savo ni bijanol šukar bijandipe ka čhinol pe thaj ka čhudol pe ani jag.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","E manuša pučlje e Jovane: “So te ćera?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","O Jovane vaćarda lenđe: “Kas isi duj gada, nek dol jekh kolese so naj le nijekh, thaj kas isi xamase, nek dol kole kas naj.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Avile te krstin pe thaj i nesave carincura thaj pučlje le: “Učitelju, so te ćera amen?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","O Jovane phenda lenđe: “Ma manđen pobut nego so si tumenđe vaćardo taro vlast.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","I nesave vojnikura pučlje le: “A amen so te ćera?” Vov vaćarda lenđe: “Khanikastar ma len silasa e pare thaj ma ćeren xoxaipe pe nikaste. Aven baxtale kolesa kobor poćinen tumen.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","E manuša ađućarde e Mesija thaj savore pučlje pe ane pumare ile naj li o Jovane o Mesija. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Al o Jovane vaćarda savorenđe: “Me krstiv tumen pajesa, al avol khoni savo si po baro mandar. Lese naj sem dostojno ni e dora tare sandale te putrav. Vov ka krstil tumen e Svetone Duxosa thaj e jagasa. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Le isi vila ane vasta te čistil o gumno thaj te ćidol o điv ane piro ambari, al i pleva ka phabarol jagasa savi ka phabol thaj ni ka ačhol.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Gija o Jovane opomenisada e manušen bute lafurencar thaj propovedisada lenđe o Lačho Lafi. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Al o Jovane prekorisada e vladare e Irode golese so lija romnjaće pe phralese romnja e Irodijada thaj paše but bilačhe buća so ćerda. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Pale sa gova o Irod ćerda vadži jekh bilačhipe: čhuta e Jovane ano phanglipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Kana o Jovane krstisada sa e manušen, krstisajlo i o Isus. Thaj dok o Isus molisajlo, putajlo o nebo ");
INSERT INTO rmyGurbet_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","thaj o Sveto Duxo ulilo pe leste ano oblik sar golubo. A taro nebo šundilo glaso: “Tu san mingro čhavo o manglo! Tu san palo mingro manglipe!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","E Isuse sasa paše tranda (30) berš kana počnisada piri služba. E manuša smatrisade kaj o Isus si čhavo e Josifeso. O Josif sasa čhavo e Ilijaso. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","O Ilija sasa čhavo e Matataso, O Matat sasa čhavo e Levijaso. O Levi sasa čhavo e Melhijaso. O Melhi sasa čhavo e Janejeso. O Janej sasa čhavo e Josifeso. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","O Josif sasa čhavo e Matatijaso. O Matatij sasa čhavo e Amoseso. O Amos sasa čhavo e Naumeso. O Naum sasa čhavo e Eslijaso. O Eslija sasa čhavo e Nangejeso. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","O Nangej sasa čhavo e Maateso. O Maat sasa čhavo e Matatijaso. O Matatij sasa čhavo e Semeinaso. O Semein sasa čhavo e Josiheso. O Josih sasa čhavo e Jodaso. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","O Joda sasa čhavo e Joananaso. O Joanan sasa čhavo e Risaso. O Risa sasa čhavo e Zorovaveleso. O Zorovavel sasa čhavo e Salatiilaso. O Salatiil sasa čhavo e Nirijaso. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","O Niri sasa čhavo e Melhijaso. O Melhi sasa čhavo e Adijeso. O Adija sasa čhavo e Kosamaso. O Kosam sasa čhavo e Elmadameso. O Elmadam sasa čhavo e Ireso. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","O Er sasa čhavo e Isuseso. O Isus sasa čhavo e Eliezereso. O Eliezer sasa čhavo e Jorimaso. O Jorim sasa čhavo e Matatoso. O Matat sasa čhavo e Levijaso, ");
INSERT INTO rmyGurbet_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","O Levi sasa čhavo e Simeoneso, O Simeon sasa čhavo e Judaso. O Juda sasa čhavo e Josifeso. O Josif sasa čhavo e Jonameso. O Jonam sasa čhavo e Eliakimeso. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","O Eliakim sasa čhavo e Melejaso. O Meleja sasa čhavo e Menaso. O Mena sasa čhavo e Matateso. O Matata sasa čhavo e Nataneso. O Natan sasa čhavo e Davideso. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","O David sasa čhavo e Jesejeso. O Jesej sasa čhavo e Jovideso, O Jovid sasa čhavo e Voozeso. O Vooz sasa čhavo e Salmoneso. O Salmon sasa čhavo e Naasoneso. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","O Naason sasa čhavo e Aminadaveso. O Aminadav sasa čhavo e Admineso. O Admin sasa čhavo e Arnijeso. O Arni sasa čhavo e Esromeso. O Esrom sasa čhavo e Fareseso. O Fares sasa čhavo e Judaso. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","O Juda sasa čhavo e Jakoveso. O Jakov sasa čhavo e Isaakoso. O Isaak sasa čhavo e Avraameso. O Avraam sasa čhavo e Taraso. O Tara sasa čhavo e Nahoreso. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","O Nahor sasa čhavo e Seruheso, O Seruh sasa čhavo e Ragaveso. O Ragav sasa čhavo e Falekeso. O Falek sasa čhavo e Evereso. O Ever sasa čhavo e Salaso. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","O Sala sasa čhavo e Kainameso. O Kainam sasa čhavo e Arfaksadeso. O Arfaksad sasa čhavo e Simeso. O Sim sasa čhavo e Nojaso. O Noja sasa čhavo e Lameheso. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","O Lameh sasa čhavo e Matusaleso. O Matusal sasa čhavo e Enoheso. O Enoh sasa čhavo e Jareteso. O Jaret sasa čhavo e Malaleileso. O Malaleil sasa čhavo e Kainameso. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","O Kainam sasa čhavo e Enoseso. O Enos sasa čhavo e Siteso. O Sit sasa čhavo e Adameso. O Adam sasa čhavo e Devleso. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","O Isus pherdo Svetone Duxosa irisajlo tari len o Jordan. O Duxo inđarda le ani pustinja, ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","kaj iskušisada le o beng saranda (40) đive. Ane gola đivesa o Isus khanči ni xalja thaj kana nakhle saranda (40) đive, bokhajlo. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Tegani vaćarda lese o beng: “Te san e Devleso Čhavo, phen kale barese te avol mangro.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","O Isus phenda lese: “Ano Sveto lil si pisimo: ‘O manuš ni ka avol džuvdo samo taro mangro nego tare dži jekh Lafi e Devleso.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Pale gova ikalda le o beng ko učo than thaj tari jekh drom sikada lese sa e carstvura ki phuv. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","O beng vaćarda e Isusese: “Tuće ka dav sa kava lengo zuralipe thaj i slava, golese kaj manđe dija pe thaj me ka dav la kase mangav. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ako pere pe koča angle mande, sa ka avol ćiro.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","O Isus vaćarda lese: “Ano Sveto lil si pisimo: ‘Per ke koča e Gospodese e Devlese ćirese thaj lese jekhese služi.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Pale gova inđarda le o beng ano Jerusalim, čhuta le najučeste po Hram thaj vaćarda lese: “Te san e Devleso Čhavo, čhude tu katar tele. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Golese kaj ano Sveto lil si pisimo: ‘Vov ka phenol pe anđelurenđe te aračhen tut,’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","thaj: ‘Von ka len tut ke vasta te ma čalave tut ko bar ćire pingresa.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","O Isus vaćarda lese: “Ano Sveto lil si pisimo: ‘Ma iskuši e Gospode, e Devle ćire.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Kana o beng završisada sa lese iskušenjura, đelo lestar dži aver nesavo vreme. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","O Isus irisajlo ano zuralipe e Duxoso ani Galileja thaj o lafi lestar đelo ane sa e phuva. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Sikada ane lenđe sinagoge thaj savore šukar lestar vaćarde. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Tegani avilo o Isus ano foro Nazaret kaj barilo thaj ko savato palo piro adeti, đelo ani sinagoga thaj uštilo te čitil. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Dije le o Lil e prorokoso e Isaijaso, vov putarda o Lil thaj arakhlja than kaj sasa pisimo: ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“O Duxo e Gospodeso si pe mande, golese kaj pomazisada man te anav o Lačho Lafi e čororenđe, bičhalda man te sastarav len, saven isi dukhade ile, thaj te vaćarav e phanglenđe kaj ka aven oslobodime, thaj e korenđe kaj ka dičhen, thaj e mučime kaj ka aven slobodna, ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","te vaćarav taro lačho berš taro milost e Gospodeso.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Tegani phanglja o Lil, dija le e slugase thaj bešlo. Savore ani sinagoga dikhlje ane leste ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","thaj o Isus lija te vaćarol lenđe: “Ađive pherdile kala lafura so akana šunden.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Savore lestar vaćarde šukar thaj sesa zadivime gole šukar lafurencar so iklilo andaro leso muj thaj pučlje pe: “Naj li kava e Josifeso čhavo?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","O Isus vaćarda lenđe: “Čače tumen manđe ka vaćaren kaja poslovica: ‘Lekarona, sastar korkore tut!’ So šundam kaj ćerdan ano Kafarnaum, ćer i kate ane ćiro than kaj bariljan.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Tegani vaćarda: “Čače vaćarav tumenđe, nijekh proroko naj manglo ane piro than kaj barilo. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","A čače vaćarav tumenđe: But romnja kase roma mule sesa ano Izrael ano vreme e Ilijaso kana o bršnd ni pelo trin berš thaj šov čhon thaj sasa baro bokhalipe pe sa i phuv. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Al o Ilija ni sasa bičhaldo ni jekhaće lendar, sasa bičhaldo ki jekh džuvli kaso rom mulo ke abandžijengo foro Sarepta pašo Sidon. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Thaj but gubava sesa ano Izrael ko vreme e prorokoso e Jelisejeso. Thaj khoni lendar ni thodilo, nego thodilo o Neman o Sirijanco.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Savore ani sinagoga pherdile holi kana kava šunde. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Uštile thaj tradije le avral taro foro. Inđarde le ko brego najuče kaj sasa ćerdo lengo foro te čhuden le odupral natele. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Al o Isus nakhlo maškar lende thaj đelo pe dromesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Pale gova o Isus ulilo ano Kafarnaum ano Galilejsko foro thaj sikada ko savato. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","E manuša čudisajle lese sikajimasa, golese kaj ane lese lafura sasa vlast. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Gothe ani sinagoga sasa manuš ane kaste sasa o bilačho duxo thaj dija vika zurale: ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“So manđe amendar, Isuse taro Nazaret? Aviljan li te uništi amen? Džanav ko san tu: Sveco e Devleso!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","O Isus pretisada le: “Phande ćo muj thaj iklji lestar!” Tegani o beng perada e manuše angle sa e manuša, iklilo lestar thaj khanči ni ćerda lese bilačhe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ane savorende avili i dar thaj čudisajle thaj jekh averese vaćarde: “Savo si kava sikajipe! Ano autoritet thaj ano zuralipe vaćarol e bilačhe duxurenđe te ikljon thaj von ikljen!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Thaj đelo o lafi lestar ane sa e pašutne thana. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","O Isus uštilo gothar andari sinagoga thaj avilo ano čher e Simoneso. E Simonese sasuja sasa la bari jag thaj rodije lestar te sastarol la. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","O Isus ačhilo paše late, pretisada e jagaće thaj i jag mukhlja la. Sigate uštili thaj služisada len. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kana pelo o kham, ande angle leste savoren saven sesa nasvale manuša tare dži jekh nasvalipe. Vov pe savorende čhuta pe vasta thaj sastarda len. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Tare pherdo manuša iklile e benga thaj dije vika vaćarindoj: “Tu san o Čhavo e Devleso!” Al o Isus darada len te ma vaćaren khanikase golese kaj džanglje kaj si vov o Hrist. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kana đivesajlo, o Isus iklilo thaj đelo ani pustinja. E manuša rodije le thaj avile leste thaj manglje te ačhaven le te ma džal lendar. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Al o Isus vaćarda lenđe: “Trubul i ane avera forura te vaćarav o Lačho Lafi taro Carstvo e Devleso, golese kaj sem paše gova bičhaldo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Thaj ni ačhada te vaćarol ane sinagoge ani Judeja. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Jekh drom kana o Isus ačhilo pašo Genisaretsko jezero, ćidije pe paše leste but manuša, te šunen o Lafi e Devleso. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Tegani dikhlja duj čamcura kaj ačhen ki obala. E manuša save dolen mačhe iklile lendar thaj thode e mreže. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","O Isus dija ano čamco savo sasa e Simoneso thaj pučlja le te crden le zala ano paj. Pale gova bešlo thaj taro čamco sikada e manušen. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Kana ačhilo te vaćarol e manušenđe, vaćarda e Simonese: “Dža ko duboko paj thaj čhude e mreže thaj dol mačhen.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","O Simon vaćarda lese: “Gospodarona! Celo rat dijam zor thaj khanči ni doldam, al ako tu phene, ka čhudav e mreže.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kana ćerde gova, dolde bute mačhen thaj e mreže lije te pharadon. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Tegani vastesa dije vika pe amalen save sesa ane aver čamco te aven te pomožin lenđe. Von avile thaj pherde solduj čamcura gija so lije te pherdon paj taro pharipe e mačhengo. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Kana gova dikhlja o Simon Petar, pelo ke koča angle Isusese pingre thaj vaćarda: “Dža mandar, Gospode! Me sem grešno manuš.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Golese kaj i dar dolda le thaj savoren save sesa lesa, tare but mačhe so dolde. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Gija dolda i dar e Jakove thaj e Jovane, e čhaven e Zevedejevese, so sesa amala e Simonesa. Tegani o Isus vaćarda e Simonese: “Ma dara, od akana ka dole e manušen.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kana ikalde e čamcura ki obala, ačhade sa thaj đele pale leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Kana sasa o Isus ane jekh foro, avilo paše leste jekh manuš so sasa but gubavo. Kana dikhlja e Isuse pelo angle leste mujesa dži ki phuv thaj molisada le vaćarindoj: “Gospode! Ako manđe, šaj te sastare man!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","O Isus vazdija piro va, dolda le thaj phenda: “Mangav. Av thodo!” Thaj i guba tare lesi koža sigate crdija pe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Tegani o Isus naredisada lese: “Ma vaćar gova khanikase, nego dža thaj sikav tut e sveštenikose! Inđar žrtva sar so zapovedisada o Mojsije ano zakon pašo ćiro thodipe, te bi avola tut svedočanstvo angle lende.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","O lafi taro Isus sa pobut šundilo. E manuša sa pobut ćidije pe te šunen le thaj te sastarol len tare lengo nasvalipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Al o Isus đelo ko than kaj naj khoni thaj molisajlo. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Jekh đive o Isus sikada ano jekh čher thaj gothe bešle e fariseja thaj e učitelja tare Mojsijaso zakon save avile tare sa e gava andari Galileja, andari Judeja thaj andaro Jerusalim. A o Isus sastarola e Gospodese zorasa. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Thaj nesave manuša ande ano than e pašljimaso jekhe manuše savo naštine te phirol. Thaj rodije sar te anen le thaj te mučhen le anglo Isus. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Kana ni arakhlje kotar te anen le andre tare but manuša, uštile po čher thaj taro tavano mukhlje le sa e thanesa e pašljimaso, ko maškar anglo Isus. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Kana dikhlja lengo pačajipe, vaćarda lese: “Manušeja, oprostime si će grehura!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","E fariseja thaj e učitelja tare Mojsijaso zakon lije ane peste te den gođi: “Ko si kava savo hulil po Dol? Ko šaj oprostil e grehura sem jekh Dol?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Kana o Isus haljarda so von den gođi ane peste, vaćarda lenđe: “So den gođi ane tumare ile? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","So si poločhe, te phenol pe: ‘Oprostime si ćire grehura’, il te phenol pe kolese savo našti phirol: ‘Ušti thaj phir’? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Al te džanen kaj isi man, o Čhavo e manušeso, vlast ki phuv te oprostiv e grehura, me ka sikavav tumenđe mingri zor.” Tegani irisajlo premalo manuš savo naštine te phirol thaj phenda: “Tuće phenav! Ušti thaj le ćiro than e pašljimaso thaj dža čhere.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Sigate kova manuš uštilo angle lende thaj lija piro than e pašljimaso thaj đelo pese čhere hvalindoj e Devle. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Savore sesa zadivime thaj hvalisade e Devle. Pherdile dar thaj vaćarde: “Baro čudo dikhljam ađive!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Pale gova iklilo o Isus thaj dikhlja e carinco savo akhardola Levi sar bešol ki carina thaj vaćarda lese: “Av pale mande.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Thaj o Levi uštilo, ačhada sa gothe thaj đelo pale leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","O Levi ćerda e Isusese ane piro čher baro xape. Sesa gothe but carincura thaj avera manuša save bešle lesa ko astali. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","E fariseja thaj e učitelja tare Mojsijaso zakon lije te bunin pe vaćarindoj e Isusese sikadenđe: “Sose xan thaj pijen e carincurencar thaj e grešnikurencar?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","O Isus vaćarda lenđe: “Ni trubul e sastenđe doktora, nego e nasvalenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Me ni aviljem te akharav ko pokajipe e pravednikuren, nego e grešnikuren.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","E fariseja thaj e učitelja tare Mojsijaso zakon pučlje e Isuse: “Sose e Jovanese sikade postin thaj molin pe e Devlese, gija ćeren thaj e farisejska sikade, al ćire sikade xan thaj pijen?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","O Isus pučlja len: “Šaj li čhuve e gosturen save avile ko abav te postin, dok slavin e mladoženjasa? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Al ka avol o đive kana ka len lendar e mladoženja. Ane gova đive i von ka postin.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Thaj vaćarda lenđe i paramič: “Khoni ni čhuvol kotor taro nevo fostano po purano fostano, golese kaj i o nevo ka pharadol thaj o kotor taro nevo fostano ni ačhol šukar ko purano. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Thaj khoni ni čhorol nevi mol ane purane morčha, golese kaj i nevi mol ka pharavol e morčha thaj i mol ka čhordol, a e morčha ka pharadon. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Golese i nevi mol čhuvol pe ane neve morčha thaj gija solduj ka arakhadon. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Thaj khoni ko pilja i purani mol ni manđol nevi, golese kaj phenol: ‘I purani si pošukar.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ke jekh savato o Isus nakhlo maškaro điv. Lese sikade lije o điv, morde vastencar thaj xalje. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nesave fariseja pučlje: “Sose ćeren kova so ni trubul ko savato pale Mojsijaso zakon?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","O Isus vaćarda lenđe: “Ni li čitisaden ano Sveto lil so ćerda o David kana bokhajlo vov thaj i kola so sesa lesa? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Dija ano čher e Devleso thaj lija e mangre save sesa posvetime, save šajine te xan samo e sveštenikura. O David xalja thaj dija i kolenđe so sesa lesa.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Tegani o Isus vaćarda lenđe: “Me, o Čhavo e manušeso, sem o gospodari e savatoso.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ko aver savato o Isus dija ani sinagoga thaj lija te sikavol. Gothe sasa jekh manuš kaso desno va sasa šuko. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","E učitelja tare Mojsijaso zakon thaj e fariseja dikhlje palo Isus, na li ko savato ka sastarol, te bi ćerena le banđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Al o Isus džanglja so von den gođi thaj vaćarda e manušese kaso va sasa šuko: “Ušti thaj ačh akari ko maškar!” O manuš uštilo thaj ačhilo angle lende. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Tegani o Isus vaćarda lenđe: “Te pučav tumen: Ko savato li šaj ćerol pe šukar il bilačhe? Te aračhol pe o džuvdipe il te mudarol pe?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Thaj dikhlja savoren so sesa gothe thaj vaćarda e manušese: “Pruži ćo va.” I vov pružisada po va thaj leso va sastilo. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","E fariseja thaj e učitelja tare Mojsijaso zakon pherdile bari holi thaj lije te vaćaren jekh averese so te ćeren e Isusesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ane gola đivesa o Isus iklilo ko brego te molil pe e Devlese thaj sasa celo rat ano molipe e Devlesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kana sasa đive, akharda pe sikaden, lendar birisada dešudujen (12) thaj akharda len apostolura: ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","e Simone kas akharda Petar, thaj lese phrale e Andrija, e Jakove thaj e Jovane, e Filipe thaj e Vartolomeje, ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","e Mateja thaj e Toma, e Jakove e Alfejevese čhave thaj e Simone savo sasa Zilot, ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","e Juda e Jakoveso thaj e Juda e Iskariotskone, savo izdajisada le. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","O Isus ulilo taro brego pe Dešudujencar (12) thaj ačhilo ko ravno than. Odori sesa but lese sikade thaj but manuša andari sa i Judeja, andaro Jerusalim, andare Tirska thaj Sidonska krajura thaj tare pašutne thana save si pašo more. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Von avile te šunen le thaj te sastardon tare piro nasvalipe. Sastardile i kola save sesa mučime tare bilačhe duxura. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Sa e manuša rodije te dolen pe po Isus, golese kaj lestar ikljola zor thaj sastardona savore. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","O Isus dikhlja ane pe sikade thaj vaćarda: “Blagoslovime sen tumen save sen čore, golese kaj tumaro si o Carstvo e Devleso. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Blagoslovime sen tumen save sen akana bokhale, golese kaj ka čaljon. Blagoslovime sen tumen save akana roven, golese kaj ka asan. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Blagoslovime sen kana e manuša mrzin tumen, čhuden tumen, ladžaren tumen thaj tumaro alav ni manđen thaj dičhen tumen sar bilačhen golese so pačan ane mande, ano Čhavo e manušeso. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Radujin tumen ane gova đive thaj ćhelen, golese kaj bari si tumari plata ko nebo. Golese kaj gija ćerde e prorokurenđe i lenđe paradada. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Al jao tumenđe e barvalenđe, golese so već lijen tumari uteha. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Jao tumenđe save sen akana čale, golese so ka bokhavon. Jao tumenđe save akana asan, golese so ka tugujin thaj ka roven. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Jao tumenđe kana sa e manuša vaćaren šukar tumendar, golese kaj gija i lenđe paradada vaćarde šukar tare xoxavne prorokura!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","O Isus vadži vaćarda: “Al tumenđe save šunen man, vaćarav: Manđen tumare dušmanuren! Šukar ćeren kolenđe save mrzin tumen! ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Blagoslovin kolen save den tumen armaja! Molin tumen e Devlese kolenđe save bilačhe ćeren tumencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kolese savo čalavol tut pi čham, iri thaj aver čham, kole savo manđol tutar o ogrtači, de le te lol i ćo gad. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","De svakone kova so rodol tutar, thaj te khoni khanči lija tutar, ma rode gova te iril tuće. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Gova so manđen te ćeren e manuša tumenđe, gova i tumen ćeren lenđe! ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ako manđen samo kolen save tumen manđen, savi si tumari hvala? Golese so čak i e grešnikura manđen kolen save len manđen. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Thaj ako ćeren šukar samo kolenđe save tumenđe ćeren šukar, savi si tumari hvala? Golese so i e grešnikura ćeren gija. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Thaj ako den zajam kolenđe savendar ađućaren te irin o zajam, savi si tumari hvala? Golese kaj i e grešnikura e grešnikurenđe den zajam te len palem gaći. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Nego, manđen tumare dušmanuren thaj ćeren lenđe šukar! Den zajam te ni manđen khanči golestar. Gija ka avol tumen bari plata thaj ka aven čhave e Najbare Devlese, golese kaj si vov šukar i e nezahvalnonenđe thaj e bilačhenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Golese aven milosrdna sar so si tumaro Dad taro nebo milosrdno.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","O Isus vadži vaćarda: “Ma sudin thaj ni ka aven sudime. Ma osudin thaj ni ka aven osudime. Oprostin thaj ka avol oprostimo tumenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Den thaj ka dol pe tumenđe. Pobari mera thaj popherdi ka dol pe tumenđe ane tumare vasta. Golese kaj, save merasa merin, gaći ka iril pe tumenđe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Thaj o Isus vaćarda lenđe paramič: “Šaj li o koro e kore te inđarol? Na li solduj ka peren ani rupa? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nijekh sikado naj pobaro tare piro učitelji. Kana ka sikljol sa, ka avol sar piro učitelji. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Sose dičhe i treska ane ćire phralesi jakh, al o kaš ani ćiri jakh ni dičhe? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Sar šaj vaćare ćire phralese: ‘Phrala, ačh te ikalav i treska andari ćiri jakh’, al o kaš ani ćiri jakh ni dičhe? Dujemujengo! Ikal angleder o kaš andari ćiri jakh, pa ka dičhe te ikale i treska andari ćire phralesi jakh.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","O Isus vadži vaćarda: “Golese kaj naj šukar kaš savo bijanol bilačho bijandipe, ni bilačho kaš savo bijanol šukar bijandipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Sa e kašta pindžardon pale lengo bijandipe. Golese kaj i smokve ni ćiden pe tare kangre thaj ni e drakha ni ćiden pe tari kupina. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","E šukare manuše isi šukar ano ilo, i gija, lestar ikljol šukar. Thaj bilačho manuš andare piro ilo ikalol bilačhipe, golese kaj andaro muj leso ikljol kova sosa si pherdo leso ilo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","O Isus vadži vaćarda: “Sose akharen man: ‘Gospode! Gospode!’, a ni ćeren kova so vaćarav tumenđe? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ka sikavav tumenđe savo si dži jekh savo avol ke mande thaj šunol mingre lafura thaj ćerol len. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Vov si sar manuš savo ćerda piro čher. Pa hunda rupa thaj čalada temelji ko bar. Thaj kana avile e paja, avili i bari len pe gova čher thaj naštine te peravol le, golese kaj si leso temelji ko bar. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Al kova savo šunda a ni ćerda, si sar manuš savo ćerda piro čher ki phuv bizo temelji. Thaj kana avilo o paj, gova čher sigate pelo dži o temelji.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Kana vaćarda o Isus sa kava angle manuša, đelo ano foro o Kafarnaum. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Gothe jekhe rimskone kapetano sasa jekh sluga savo sasa nasvalo dži o meripe thaj kas but manglja. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kana o kapetano šunda e Isusese, bičhalda leste nesave jevrejskone starešinen te molin le te avol te sastarol lese sluga. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Kana avile ko Isus, but molisade le vaćarindoj: “Vov zaslužil gova te ćere lese, ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","golese kaj manđol amaro narodo thaj ćerda amenđe sinagoga.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Gija, o Isus đelo lencar. Kana ni sesa dur taro čher, bičhalda o kapetano pe amalen te vaćaren lese: “Gospode! Ma čhuv tuće gova pharipe golesa so ka de ane mingro čher, golese kaj me naj sem dostojno te ave tali mingri streja. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Golese ni mangljem te avav angle tute kaj naj sem dostojno. Nego vaćar samo jekh lafi thaj sigate ka sastol mingro manglo sluga. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Golese kaj i me sem manuš tale nekaso autoritet thaj isi man tale mande vojnikura, pa vaćarav jekhese: ‘Dža’, thaj vov džal. Vaćarav dujtonese: ‘Av’, thaj vov avol. Vaćarav mingre slugase: ‘Ćer’, thaj ćerol gova.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Kana šunda gova o Isus, čudisajlo thaj irisajlo e manušenđe save đele pale leste thaj vaćarda lenđe: “Vaćarav tumenđe, nijekhe Jevreje vadži ni arakhljem ano Izrael save isi gaći pačajipe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Tegani kola manuša so sesa bičhalde, irisajle čhere thaj arakhlje e nasvale sluga saste. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Na but pale gova, o Isus đelo ano foro savo akhardola Nain. Đele lesa lese sikade thaj pherdo manuša. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Kana avile pašo vudar e foroso, nesave manuša ikalde jekhe terne čhave, savo mulo. Vov sasa jekhoro čhavo jekha dejako, savako rom mulo. Pherdo manuša andaro foro džana lasa te prahon e čhave. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Kana dikhlja la o Gospod, pelo lese žal laće thaj vaćarda: “Ma rov!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Tegani avilo paše thaj dolda pe po than kaj sasa pašljardo o mulo čhavo. E manuša save inđarena le ačhile thaj o Isus vaćarda: “Čhaveja! Tuće vaćarav, ušti!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","O mulo čhavo bešlo thaj lija te vaćarol, a o Isus dija le lese daće. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Savore darajle thaj hvalisade e Devle vaćarindoj: “Baro proroko si maškar amende!” Thaj: “O Dol avilo te pomognil pe manušenđe!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Kava šundilo taro Isus ani sa i Judeja thaj ane sa e pašutne thana. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","E Jovanese e Krstiteljese sikade vaćarde lese sa kava so o Isus ćerda. Tegani akharda o Jovane pe duje sikaden ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","thaj bičhalda len ko Gospod te pučen le: “Tu li san gova save obećisada o Dol kaj trubul te avol, il te ađućara avere?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Kana avile gola duj manuša ko Isus, phende lese: “O Jovane o Krstitelj bičhalda amen tute te puča tut: ‘Tu li san gova save obećisada o Dol kaj trubul te avol, il te ađućara avere?’” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ane gova sato o Isus sastarda buten taro lengo nasvalipe, tare lengo pharipe thaj tare bilačhe duxura thaj bute koren dija dičhipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Gija o Isus phenda e Jovanese sikadenđe: “Džan thaj vaćaren e Jovanese so dikhljen thaj so šunden: e kore dičhen, e banđe phiren, e gubava thodon, e kašuće šunen, e mule ušten taro meripe thaj e čororenđe vaćarol pe o Lačho Lafi. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Blagoslovimo si kova savo mandar ni sablaznil pe!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Kana đele e Jovanese sikade, o Isus lija te vaćarol taro Jovane bute manušenđe: “So ikliljen te dičhen ki pustinja? I trska, savi banđol ki balval? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Il so ikliljen te dičhen? Manuše ane barvale šeja urade? Na! Kola save phiraven barvale šeja ano šukaripe bešen ane carska palate. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Il so ikliljen te dičhen? Proroko? Va, me phenav tumenđe, vov si pobut taro proroko. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Golese so, o Jovane si manuš kastar si pisimo ano Sveto lil: ‘Akh, me bičhalav mingre glasniko angle tute, savo ka pripremil tuće o drom angle tute.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Vaćarav tumenđe: maškare sa e manuša save sesa bijande tare romnja, ni sasa khoni pobaro taro Jovane. Al i o emcikno ano Carstvo e Devleso pobaro si lestar.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Sa e manuša so šunde e Isuse, pa i nesave carincura, pindžarde kaj si e Devleso sikajipe čačukano, golesa so krstisajle e Jovanese krstimasa. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Al e fariseja thaj e učitelja tare Mojsijaso zakon čhudije o plan e Devleso savo sasa lenđe thaj ni manglje o Jovane te krstil len. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","O Isus vaćarda: “Kasa te uporediv e manušen tari kaja kuštik save si akana džuvde? Sar kaste si von slična? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Von si sar čhavore save bešen ko drom thaj akharen jekh avere vaćarindoj: ‘Bašaldam tumenđe vesela đilja, a tumen ni čhelden! Bašaldam tumenđe žalosna đilja, a tumen ni rujen!’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Golese kaj, avilo o Jovane o Krstitelj savo ni xalja mangro thaj ni pijola mol, a tumen vaćaren: ‘O beng ane leste!’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Aviljem me, o Čhavo e manušeso, savo xav thaj pijav, a tumen vaćaren: ‘Dikh, manuš xalano thaj mato, amal e carincurengo thaj e grešnikurengo!’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Al, sa gola so prihvatisade gova sikajipe, phende kaj si e Devleso mudrost čačukano!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Jekh farisejo kaso alav sasa Simon dija vika e Isuse te avol te xal mangro ke leste. O Isus đelo ano čher e farisejeso thaj čhuta pe pašo astali. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Thaj dikh, ane gova foro sasa i džuvli savaće džanglja pe kaj si grešnica. Voj šunda kaj si o Isus pašo astali ano čher e farisejeso, i avili andre thaj anda kučalo miris ko čaro savo sasa taro mermerno bar. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Voj ačhili palo Isus thaj rojindoj, peli ke pe koča paše lese pingre thaj lija te thovol len pe jasvencar. Tegani koslja len pe balencar, čumidija lese pingre thaj makhlja len e mirisesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Kana gova dikhlja o farisejo savo akharda le, vaćarda ane peste: “Te avol kava manuš proroko, bi džanola ko si kaja džuvli savi dotaknil le. Vov bi džanola kaj si grešnica!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","O Isus phenda lese: “Simone! Isi man khanči te vaćarav tuće.” Vov vaćarda: “Učitelju, vaćar!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","O Isus vaćarda: “Duj džene sesa dužna jekhe manušese. Jekh sasa dužno panšel (500) srebrenjakura a o dujto pinda (50). ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Kana len ni sasa te irin, kova manuš oprostisada soldujenđe. Vaćar, tare kala duj savo ka manđol le pobut?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","O Simon vaćarda lese: “Pa bi phenava kolese kas sasa pobaro dugo.” A o Isus vaćarda lese: “Gija si, šukar vaćardan.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Tegani irisajlo o Isus premali džuvli thaj vaćarda e Simonese: “Dičhe li kala džuvlja? Kana me aviljem ane ćiro čher, ni paj ni andan te thovav me pingre, al voj pe jasvencar thoda len thaj pe balencar koslja len. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ni čumidipe ni dijan man, al voj sar aviljem, ni ačhili te čumidol mingre pingre. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Uljesa ni makhljan mingro šoro, al voj mirisesa makhlja mingre pingre. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Golese vaćarav tuće: ‘Baro manglipe sikada manđe, golese so si laće oprostime but bare grehura. Al kase zala oprostime, sikavol zala manglipe.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","A e džuvljaće vaćarda: “Oprostime si ćire grehura.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Tegani ane peste lije te vaćaren kola so sesa lesa pašo astali: “Ko si kava savo šaj oprostil e grehura?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Al o Isus vaćarda e džuvljaće: “Ćiro pačajipe spasisada tut. Dža ano mir!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Pale gova o Isus đelo ane forura thaj ane gava. Sikada thaj vaćarda taro Lačho Lafi taro Carstvo e Devleso. Lesa đele e dešuduj (12) sikade ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","thaj nesave džuvlja save sesa sastarde tare benga thaj taro nasvalipe: i Marija (savi akhardola Magdalena, kastar iklile efta bilačhe duxura), ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","thaj i Jovana (romni e Huzosi savo sasa upravitelji ko Irod) thaj i Suzana thaj avera but džuvlja save pomožisade pumare parencar e Isuse thaj lese sikaden. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kana ćidije pe but manuša tare sa e forura thaj avile pašo Isus, vov vaćarda lenđe paramič: ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Iklilo o manuš savo čhudola o seme pi phuv. Thaj kana sejisada, nesavo seme pelo po drom. Gothe uštade le e manuša thaj e čiriklja sa xalje le. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Nesavo seme pelo pe bara. Barilo thaj šućilo, golese kaj naj sasa paj ani phuv. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Thaj nesavo seme pelo pe kangre. O seme barilo e kangrencar thaj e kangre tasade le. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Thaj nesavo seme pelo pi šukar phuv. Barilo thaj anda šel droma pobut.” Kana vaćarda kava, dija vika: “Kas isi kana te šunol, nek šunol.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","E Isusese sikade pučlje le: “Vaćar amenđe so značil kaja paramič?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Vov vaćarda: “O Dol tumenđe dija te džanen o garajipe tare leso Carstvo, al averenđe vaćarav ane paramiča, te pherdol okova so ačhol ano Sveto lil: ‘Ka dičhen, al ni ka shvatin; ka šunen, al ni ka haljaren.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Kaja paramič phenol kava: O seme si o Lafi e Devleso. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nesave manuša si sar o drom ke savo pelo o seme. Kana šunen o Lafi e Devleso thaj avol o beng, lol o Lafi andaro lengo ilo, te ma pačan thaj te ni aven spasime. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Nesave manuša si sar than kaj isi bara ke savo pelo o seme. Gova si manuša save šunen thaj len o Lafi radosno, al si sar luluđa saven naj koreno. Zala vreme pačan, a kana avol o vreme tare iskušenjura, tegani prestanin te pačan. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Nesave manuša si sar than maškar e kangre ke savo pelo o seme. Gola si kola manuša save šunen o Lačho Lafi, al o pharipe, o barvalipe thaj o guglipe kale svetoso tasavol len thaj ni den šukar bijandipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","A nesave manuša si sar šukar phuv pe savo si sejimo o seme. Gola si manuša save šunen o Lafi thaj gova Lafi ićaren ano šukar thaj iskreno ilo, sa dži kaj ni anen šukar bijandipe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Khoni ni phabarol i svetiljka te bi učharola la e čaresa il te bi čhuvola talo than e sojimaso. Čhuvol la ko than e svetiljkako te šaj kola save den andre, dičhen o svetlo. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Sa so si garado ka avol pučardo thaj so si ćerdo garandoj ka ikljol ko dičhipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Golese pazin sar šunen. Golese so, kas isi, ka dol pe lese, a kas naj, ka lol pe lestar i kova zala so dol gođi kaj isi le.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Avile e Isusesi dej thaj lese phrala thaj naštine tare but manuša te aven dži leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Thaj khoni vaćarda e Isusese: “Ćiri dej thaj ćire phrala ačhen avri thaj manđen te dičhen tut.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Al vov vaćarda lenđe: “Mingri dej thaj mingre phrala si kola save šunen o Lafi e Devleso thaj ićaren le.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Jekh đive o Isus phenda pe sikadenđe: “Te nakha ki aver rig e jezerosi.” Dije ano čamco thaj đele. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Thaj kana pojdisade, o Isus zasuta. Tegani uštili bari balval, o čamco lija te pherdol paj thaj arakhlje pe ano opasnost. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","E sikade avile pašo Isus thaj lije te den vika: “Gospode! Gospode! Ka tasiva!” Vov uštilo thaj zapovedisada e balvaljaće thaj e bare pajese te ačhen, thaj von ačhile thaj pale gova khanči ni šundilo. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","A o Isus pučlja len: “Kaj tumaro pačajipe?” A e sikade darajle thaj čudisajle, pučindoj jekh averese: “Savo si kava so e balvaljenđe thaj e pajese zapovedil te ačhen thaj von šunen le?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Tegani resle paši Gerasinsko phuv savi si ki aver rig tari Galileja. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Kana iklilo o Isus taro čamco, avilo paše leste andaro foro jekh manuš ane kaste sesa benga. But vreme sasa nango thaj ni bešlo ano čher, nego bešlo ke limora. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Kana dikhlja e Isuse, dija vika thaj pelo ke pe koča angle leste. Andare sa o glaso dija vika: “So manđe mandar, Isuse, Čhaveja Embare Devleso? Moliv tut, ma muči man!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Golese so o Isus već zapovedisada e bilačhe duxose te ikljol andare kava manuš. Angleder, e manuša phandena le ane sinđira thaj aračhena le. Al vov čhinola e sinđira thaj o beng inđarola le ani pustinja. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","O Isus pučlja le: “Sar si ćiro alav?” Vov phenda: “Legija,” golese kaj but benga sesa ane leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Thaj e benga molisade e Isuse te ma bičhalol len ano bezdan. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Paše gothar sasa jekh brego kaj sesa pherdo bale save čarona. E benga molisade e Isuse te mučhol len te džan ane gola bale. Thaj o Isus mukhlja len te džan. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Tegani iklile e benga andare kova manuš thaj đele ane bale. Thaj e bale lije te prasten taro brego ano jezero thaj tasile. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Kana e manuša save arakhlje e balen, dikhlje so sasa, našle thaj đele te vaćaren tare gova ano foro thaj ane gava. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Tegani e manuša iklile te dičhen so sasa. Kana avile pašo Isus, arakhlje e manuše kastar iklile e benga, sar bešol urado paše Isusese pingre thaj si gođaver. Thaj von darajle. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Kola save gova dikhlje, vaćarde averenđe sar o Isus sastarda e manuše ane kaste sesa e benga. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tegani sa e manuša tari Gerasinsko phuv molisade e Isuse te džal lendar, golese kaj but darajle. O Isus dija ano čamco thaj irisajlo palal ani Galileja. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","O manuš kastar o Isus ikalda e benđen molisada e Isuse te džal lesa, al o Isus bičhalda le pestar vaćarindoj: ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Iri tut ane ćiro čher thaj vaćar sa so ćerda tuće o Dol.” Gija o manuš đelo thaj vaćarda maškaro sa o foro so ćerda lese o Isus. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Kana irisajlo o Isus tari aver rig e jezerosi, e manuša sesa baxtale kana dikhlje le, golese kaj savore ađućarde le. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Thaj dikh, jekh manuš kaso alav sasa Jair, starešina e sinagogako, avilo thaj pelo ke koča anglo Isus thaj molisada le te avol ane leso čher, ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","golese kaj sasa le jekhori čhej tare dešuduj berš thaj voj sasa dži o meripe. Kana pojdisada o Isus e Jairesa ane leso čher, ćićidije le e manuša. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Thaj maškare manuša sasa jekh nasvali džuvli tare rateso thavdipe već dešuduj berš. I džuvli sa piro barvalipe so sasa la, dija ke lekara, al nijekh naštine te sastarol la. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Voj avili od palal e Isusese thaj dolda le taro teluno kotor taro fostano thaj tare jekh drom ačhilo lako ratvalipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","O Isus pučlja: “Ko dolda pe gova pe mande?” Dži jekh lendar phende kaj naj von, vaćarda o Petar thaj kola save sesa lesa: “Gospode! But manuša si paše tute thaj ćićiden tut a tu puče: ‘Ko dolda pe gova pe mande?’.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Al o Isus vaćarda: “Khoni dolda pe pe mande, golese kaj osetisadem zor kaj iklili mandar.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kana dikhlja i džuvli kaj našti garadol, avili darandoj, peli ke pe koča angle leste thaj vaćarda angle sa e manuša sose dolda pe pe leste thaj sar tare jekh drom sastili. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","O Isus vaćarda laće: “Mingri čhej! Ćiro pačajipe sastarda tut. Dža ano mir!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Dok o Isus vaćarda e džuvljaće, avilo jekh andaro čher e Jaireso, e šorutno e sinagogako, thaj vaćarda lese: “Jaire, muli ćiri čhej. Ma muči e učitelje.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Kana šunda gova o Isus, vaćarda lese: “Ma dara! Samo pača thaj voj ka uštol.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Kana o Isus avilo ano čher, ni dija khoni te džal andre, sem o Petar, o Jovane thaj o Jakov, e čhejorako dad thaj i dej. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Savore ruje thaj tugujisade andaro vođi pale late thaj o Isus vaćarda: “Ma roven. Ni muli, nego sovol.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Al von asaje e Isusese golese kaj džanglje so muli. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Vov dolda e čhejora taro va thaj dija vika vaćarindoj: “Čhejorije, ušti!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Tare jekh drom irisajlo lako duxo thaj voj sigate uštili. O Isus naredisada lenđe te den la te xal. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Thaj lako dad thaj laći dej sesa začudime. Al vov zapovedisada lenđe khanikase te ma vaćaren so sasa. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","O Isus dija vika e dešuduje (12) apostoluren thaj dija len zor thaj vlast pe sa e benga thaj te sastaren taro nasvalipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Bičhalda len te propovedin taro Carstvo e Devleso thaj te sastaren e nasvalen. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Vaćarda lenđe: “Khanči ma len dromese: ni rovli, ni trasta, ni mangro, ni pare thaj te ma avol tumen po duj gada. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kana džan ane nesavo čher, bešen gothe, dži kaj ni ka džan ane aver than. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Te ni manglje tumen ane nesavo foro, ikljen gothar thaj tresin o praho tare tumare pingre sar svedočanstvo protiv lende.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","E sikade đele thaj phirde taro gav dži ko gav. Propovedisade o Lačho Lafi thaj sastarde e manušen ke sa e thana. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Kana o Irod, o vladari e Galilejako, šunda tare sa so sasa, sasa zbunimo golese kaj nesave vaćarde kaj o Jovane o Krstitelj uštilo tare mule. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Thaj avera vaćarde kaj ki phuv sikadilo o Ilija, a nesave vaćarde kaj uštilo tare mule nesavo proroko taro purano vreme. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Thaj vaćarda o Irod: “E Jovaneso šoro me čhindem. Savo si akana kava kastar gasave čudura šunav?” Thaj manglja te dičhol e Isuse. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Kana irisajle e apostolura, vaćarde e Isusese sa so ćerde. O Isus tegani inđarda e sikaden pesa thaj katane đele pašo foro savo akhardol Vitsaida te šaj aven korkore. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Al but manuša šunde kaj đelo o Isus, thaj lije te džan pale leste. O Isus primisada len thaj lija te propovedil lenđe taro Carstvo e Devleso thaj sastarda kolen saven trubuja sastipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Kana lija o đive te načhol, avile e dešuduj (12) apostolura pašo Isus thaj vaćarde: “Mukh e manušen. Nek džan ane pašutne gava thaj ane thana kaj šaj te aračhen khanči xamase thaj kaj šaj te soven, golese kaj sam ko than kaj naj khanči.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","O Isus vaćarda lenđe: “Den len tumen te xan!” Von vaćarde: “Amen isi samo pandž mangre thaj duj mačhe. Amen li te dža te ćina sa kale manušenđe te xan?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Gothe sesa paše pandž milje (5 000) murša. Tegani o Isus vaćarda pe sikadenđe: “Čhuven len te bešen ane kupe po pinda (50) džene.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","E sikade ćerde gija thaj bešljarde len savoren. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","O Isus lija gola pandž mangre thaj gole duje mačhen, dikhlja ano nebo thaj zahvalisada e Devlese. Phaglja e mangre thaj e mačhen thaj dija len ke sikade te den e manušen. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Savore xalje thaj čalile. Pale gova ćidije dešuduj (12) korpe kolestar so ačhilo so xalje e manuša. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Jekh đive o Isus molisajlo korkoro thaj lesa sesa lese dešuduj (12) sikade. Vov pučlja len: “So vaćaren e manuša, ko sem me?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","E sikade vaćarde lese: “Nesave manuša vaćaren kaj san o Jovane o Krstitelj, a avera kaj san o Ilija o proroko, a nesave vaćaren kaj san jekh tare purane prorokura savo uštilo tare mule.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","O Isus pučlja len: “A tumen, so phenen, ko sem me?” O Petar vaćarda: “Tu san o Hrist, bičhaldo taro Dol.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","O Isus zurale naredisada e sikadenđe te ma vaćaren khanikase kaj si vov o Hrist. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Thaj phenda: “Me, o Čhavo e manušeso, trubul te avav but mučimo. E starešine, e šorutne sveštenikura thaj e učitelja tare Mojsijaso zakon ka čhuden man. Ka avav mudardo, al me trito đive ka uštav tare mule.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Tegani o Isus savorenđe vaćarda: “Ko manđol te džal pale mande, nek ačhavol korkoro pes thaj nek lol piro krsto svako đive thaj nek džal pale mande. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Golese ko manđol piro džuvdipe te aračhol, ka hasarol le, al ko hasarol piro džuvdipe baše mande, ka aračhol le. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Savo šukaripe ka avol e manuše ako sa o sveto dobil, al pes hasarol il upropastil pes? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Golese, ko ladžal mandar thaj tare mingre lafura, lestar i me, o Čhavo e manušeso, ka ladžav kana ka avav ane mingri slava thaj ani slava mingre Dadesi thaj e svetone anđelurenđi. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Čače vaćarav tumenđe, nesave tumendar save sen kate ni ka meren dok ni dičhen o Carstvo e Devleso.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Kana nakhle ohto đive pale gova, o Isus lija e Petre, e Jovane thaj e Jakove thaj iklilo ko brego te molil pe e Devlese. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Kana molisajlo, leso muj ćerdilo averčhande thaj lese šeja ćerdile parne thaj sjajna. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Thaj dikh, tari jekh drom iklile duj manuša thaj lije te vaćaren e Isusesa. Gova sesa o Mojsije thaj o Ilija. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Sikadile ani slava thaj vaćarde tare leso meripe savo trubuja te avol ano Jerusalim. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","O Petar thaj kala so sesa lesa, zasute thaj kana džungadile dikhlje e Isuse ani slava thaj duje manušen sar lesa ačhen. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kana lije o Mojsije thaj o Ilija te crden pe taro Isus, o Petar phenda e Isusese: “Gospode! Šukar kaj sam kate. Te ćera trin senice: Jekh tuće, jekh e Mojsijase thaj jekh e Ilijase.” Ni džanglja so te vaćarol. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","A dok vov gova vaćarda, avilo o oblako savo učharda len. Thaj von, kana učharda len o oblako, darajle. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Thaj šunde glaso andare kova oblako vaćarindoj: “Kava si mingro manglo čhavo save me birisadem. Le šunen!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Pale gova so šundilo o glaso, e sikade dikhlje samo e Isuse korkore. Thaj von khanči ni vaćarde khanikase tare gova so dikhlje. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Theara đive kana o Isus thaj lese sikade ulile taro brego, but manuša avile ko Isus. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Thaj dikh, tare but manuša akharda le jekh: “Učitelju! Moliv tut, dikh pe mingro čhavo golese kaj si jekhoro.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","O bilačho duxo dolol le thaj tari jekh drom lol te dol vika thaj čhudol le ane grčura tare savi ikljol i spuma taro leso muj thaj o duxo ni ačhavol le thaj sa malaksil le. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","“Molisadem ćire sikaden te ikalen e bilačhe duxo, al von naštine.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","O Isus vaćarda lenđe: “O, bipačaće thaj rumime potomkura! Vadži kobor trubul te avav tumencar thaj te trpiv tumen? An ćire čhave akari!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","A dok avola o čhavoro premal leste, o bilačho duxo perada e čhave ki phuv ane grčura thaj lija te tresil le. A o Isus zapovedisada e bilačhe duxose te ikljol lestar, sastarda e čhave thaj dija le lese dadese. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Savore divisajle so dikhlje e Devleso baro zuralipe. Savore divisajle sa kolese so o Isus ćerola. Tegani o Isus vaćarda pe sikadenđe: ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Šukar šunen kala lafura: Me, o Čhavo e manušeso, trubul te avav dindo ane vasta e manušenđe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Al e sikade ni haljarde kala lafura, golese kaj sasa lendar garado te našti haljaren. Thaj darajle te pučen le kale lafese. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","E sikade lije te vaćaren maškar pumende ko si lendar embaro. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Al o Isus džanglja so si ane lenđe ile. Lija e čhavore čhuta le paše peste, ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","thaj vaćarda lenđe: “Savo primil kale čhavore ane mingro alav, man primil. Thaj ko man primil, primil e Devle savo bičhalda man. Golese kaj, ko si maškare tumende emcikno, vov si embaro.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Tegani vaćarda o Jovane e Isusese: “Gospode! Dikhljam jekhe sar ćire alavesa tradol e benđen. Amen vaćardam lese te ma ćerol gova, golese kaj ni džal amencar pale tute.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Al o Isus vaćarda lese: “Mučhen le, golese kaj ko naj protiv tumende, tumencar si.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kana sesa paše e đivesa te avol o Isus vazdimo ko nebo, zurale odlučisada te džal ano Jerusalim. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Thaj bičhalda glasnikuren angle peste thaj von đele thaj dije ano gav ani Samarija te lačharen lese kaj te sovol. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Al e manuša ni manglje le gothe, golese kaj džanglje kaj manđol te džal ano Jerusalim. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kana dikhlje gova lese sikade o Jakov thaj o Jovane, pučlje e Isuse: “Gospode! Manđe li te phena te uljol i jag taro nebo thaj te phabarol len sar so gova ćerda o Ilija?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Al o Isus irisajlo thaj dija vika pe lende. Phenda: “Ni džanen tare savo duxo sen. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Golese kaj me, o Čhavo e manušeso, ni aviljem te uništiv e manušengo džuvdipe, nego te spasiv.” Thaj đele ane aver gav. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Sar đele dromesa, nesavo manuš vaćarda e Isuse: “Me ka džav tusa kaj tu dža.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Al o Isus phenda lese: “E lisicen isi jazbina thaj e čirikljen isi gnezdura, al me, o Čhavo e manušeso, naj man kaj mingro šoro te pašljarav.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","A o Isus avere manušese vaćarda: “Phir pale mande.” A kova manuš phenda: “Gospode! Mukh man angleder te džav te prahov mingre dade.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Al o Isus vaćarda lese: “Ačhav e mule, nek prahon pe mulen. Al tu dža thaj propovedi taro Carstvo e Devleso.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","A aver manuš vaćarda: “Gospode! Me ka džav pale tute, al mukh man te džav te oprostiv man mingre čherutnencar.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","A o Isus phenda lese: “Kova savo čhuvol piro va ko plugo te oril a dičhol palal, naj pogodno pašo Carstvo e Devleso.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Pale gova odredisada o Gospod avere eftavardeš thaj duje (72) sikaden thaj bičhalda len po duj te džan angle leste ane sa e forura thaj ane thana kaj manglja te džal. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","O Isus vaćarda lenđe: “O ćidipe si baro a e bućarne si zala. Golese, molin e gospodare taro ćidipe te bičhalol e bućarnen ke piro ćidipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Džan! Akh, bičhalav tumen sar terne bakren maškare ruva. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ma inđaren kese parencar, ni traste, ni sandale. Thaj dok phiren ma ačhen te vaćaren ko drom khanikasa te ma hasaren tumaro vreme. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Kana ka den ane nesavo čher, angleder vaćaren: ‘Mir kale čhereste.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Te gothe bešlo o manuš savo manđol o mir, tumaro mir ka avol pe lende. Te ni manglja o mir, tumaro mir ka iril pe tumenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kana ka džan ane nesavo čher, ma džan tare gova čher ke aver. Ačhen ke gova čher thaj xan thaj pijen so isi len, golese kaj o bućarno dostojno si pe plataće. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Kana ka den ane nesavo foro thaj gothe ka primin tumen, xan so anen angle tumende. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Sastaren e nasvalen save si gothe, thaj vaćaren lenđe: ‘O Carstvo e Devleso avilo paše tumenđe.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Al kana ka džan ano nesavo foro thaj ni ka primin tumen gothe, ikljen ke lengo drom thaj vaćaren: ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Thaj o praho tare tumaro foro savo si pe amare pingre, amen kosa, sar svedočanstvo protiv lende. Al te džanen kaj paše avilo tumenđe o Carstvo e Devleso.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Vaćarav tumenđe kaj e manušenđe tari Sodoma ka avol poločhe ko đive e Sudoso, nego e manušenđe tare kava foro!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Pharo tumenđe, manušalen taro Horazin! Pharo tumenđe, manušalen tari Vitsaida! Golese kaj, te bi ćerdona ano foro Tir thaj ano foro Sidon e čudura save ćerdile tumende, dumutane bi pokajina pe thaj bi bešena urade ano dorikalo čaršafi thaj ano praho. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Al e manušenđe taro Tir thaj e manušenđe taro Sidon ka avol poločhe ko sudo, nego so ka avol tumenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","A tumen manušalen taro Kafarnaum! Dži o nebo li ka ušten? Dži o than kaj si e mule ka peren!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Tegani vaćarda o Isus pe sikadenđe: “Ko tumen šunol, man šunol. Ko tumen čhudol, man čhudol. Ko čhudol man, čhudol e Devle savo bičhalda man.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Kana irisajle kola eftavardeš thaj duj (72) sikade, radosno vaćarde e Isusese: “Gospode, e benga pokorisajle amenđe ke ćiro alav.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Vov phenda lenđe: “Me dikhljem e Satana sar pelo taro nebo sar munja. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Akh, dijem tumen zor te ačhen pe sapa thaj pe škorpije thaj pe sa o vlast e dušmaneso. Khanči ni ka avol tumenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Al tumen ma aven radosna paše gova so e duxura pokorin pe tumenđe, nego aven radosna golese so si tumare alava pisime ko lil e Devleso ano nebo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ane gova sato o Isus pherdilo radost ano Sveto Duxo thaj phenda: “Hvaliv tut, Dade, Gospode e neboso thaj e phuvako, so garadan gova tare džangle thaj tare razumna a sikadan gova kolenđe save si sar čhavore. Va, Dade, golese kaj si gova ćiri volja.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Thaj vaćarda o Isus kolenđe so sesa gothe: “Sa manđe dija mingro Dad thaj khoni ni džanol ko si o Čhavo, sem o Dad, thaj khoni ni džanol ko si o Dad, sem o Čhavo thaj kola kase o Čhavo manđol te sikavol le.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Pale gova irisajlo pe sikadenđe thaj samo lenđe vaćarda: “Blagoslovime si e jakha save dičhen kova so tumen dičhen. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Golese kaj, vaćarav tumenđe kaj but prorokura thaj carura manglje te dičhen kova so tumen dičhen, al ni dikhlje, thaj manglje te šunen kova so tumen šunen, al ni šunde.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Tegani uštilo jekh tare učitelja tare Mojsijaso zakon te iskušil e Isuse thaj pučlja le: “Učitelju! So trubul te ćerav te dobiv o džuvdipe bizo meripe?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","O Isus phenda lese: “So si pisimo ane Mojsijaso zakon? Sar tu gova haljare?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Vov phenda e Isusese: “Mang e Gospod ćire Devle sa ćire ilesa, sa ćire dušasa, sa ćire zorasa thaj sa ćire gođasa,” thaj: “Mang ćire pašutne sar korkore tut.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","O Isus vaćarda lese: “Šukar vaćardan. Ćer gova thaj ka živi!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Al kova učitelji e zakoneso manglja te opravdil pe, pa pučlja e Isuse: “Ko si mingro pašutno?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Pe gova o Isus lija te vaćarol kava: “Jekh manuš đelo taro Jerusalim ano Jerihon thaj dolde le e čora. Von uljarde lese šeja, marde le, ačhade le opaš mule pašo drom thaj đele pese. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Slučajno gole dromesa nakhlo nesavo svešteniko. Kana dikhlja le, crdija pe lestar ki aver rig thaj nakhlo. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Gija i nesavo levito: kana avilo ke gova than thaj dikhlja le thaj nakhlo ki aver rig. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Tegani paše leste avilo i nesavo Samarijanco savo đelo gole dromesa. Thaj kana dikhlja le, pa pelo lese žal. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Avilo, koslja e manušese rane uljesa thaj moljasa thaj paćarda len. Pale gova čhuta le ke piro her thaj inđarda le ani mehana thaj dikhlja pe leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Theara đive o Samarijanco ikalda duj srebrenjakura, dija ko manuš kasi sasa i mehana thaj phenda lese: ‘Dikh pe leste. Te trošisadan pobut, me ka poćinav kana ka irima.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Tegani o Isus pučlja: “So misli akana? Ko tare kala trin džene sikadilo sar pašutno kole manušese save dolde e čora?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","A o učitelji e zakoneso phenda lese: “Kova savo sikada milosrđe.” Tegani o Isus vaćarda lese: “Dža thaj i tu ćer gija.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Kana o Isus thaj lese sikade đele premalo Jerusalim, avile ane jekh gav. Gothe živisada jekh džuvli savi akhardola Marta, thaj voj primisada len ane piro čher. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","La sasa phen savi akhardola Marija. Voj bešli paše pingre e Isusese thaj šunda leso sikajipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Al i Marta dikhlja pobut ani bući thaj sar emlačhe te služil e Isuse. Avili pašo Isus thaj pučlja le: “Gospode! Šukar li si kava so mingri phen ačhada man korkora te služiv tut? Vaćar laće te pomožil man.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","O Gospod phenda laće: “Marto, Marto! Sikiri tut thaj trudi tut paše but buća. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","A samo jekh trubul. I Marija ćiri phen birisada kova so si pošukar, thaj gova ni ka lol pe latar.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jekh đive o Isus molisajlo ane jekh than. Kana ačhilo e molitvasa, jekh tare lese sikade vaćarda lese: “Gospode, sikav amen te moli amen, sar so o Jovane o Krstitelj sikada pe sikaden.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","O Isus vaćarda lenđe: “Kana molin tumen, vaćaren: ‘Dade amareja ko nebo, te svetil pe ćiro alav! Te avol ćiro carstvo. Te avol ćiro manglipe ki phuv sar ko nebo. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Xamase so trubul amen de amen svako đive. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Oprosti amare grehura, sar so i amen oprosti kolenđe so ćeren grehura premal amende! Thaj ikal amen taro bilačhipe.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Pale gova o Isus vaćarda: “Den gođi sar bi avola kana bi khoni tumendar džala ke piro amal ki opaš i rat te rodol mangro lestar vaćarindoj: ‘Amala, de man trin mangre, pa ka irivlen tuće. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Golese kaj avilo ke mande taro drom mingro amal thaj naj so te čhuvav angle leste.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","A vov andral te phenol: ‘Ačhav man ko miro! Mingro vudar si phanglo thaj mingre čhave si mancar ano than e pašljimaso thaj našti uštav te dav tut!’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Vaćarav tumenđe: te ni uštilo golese kaj si leso amal, ka uštol te dol le golese so si uporno thaj ka dol le kobor trubul le. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Golese vaćarav tumenđe: Manđen thaj ka dol pe tumenđe! Roden thaj ka aračhen! Maren thaj ka putavol tumenđe! ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Golese kaj dži jekh savo manđol, dol pe lese; thaj kova savo rodol, aračhol; thaj savo marol, putardol lese. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Savo dad tumendar, kana bi o čhavo rodola mangro, vov bi dola le bar? Il bi rodola mačhe, vov bi dola le sape? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Il te manglja angro, te dol le škorpija? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kana tumen, bišukar manuša, džanen šukar buća te den tumare čhaven, kobor pobut tumaro Dad taro nebo ka dol Sveto Duxo kolenđe save molin le?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jekh drom o Isus tradija e benđe taro manuš savo naštine te vaćarol. Kana iklilo o beng, kova manuš lija te vaćarol thaj e manuša sesa zadivime. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Al nesave lendar vaćarde: “Vov tradol e benđen e Veelzevulese zorasa, savo si o šorutno e benđengo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","A avera iskušisade e Isuse gija so rodije znako te dičhen dal si bičhaldo taro Dol. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Al o Isus džanglja so den gođi thaj phenda lenđe: “Dži jekh carstvo savo si ulado, ka properol thaj čher ane savo naj sloga, ka properol. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Gija, te avol o Satana ulado ane peste, sar šaj te ačhol leso carstvo? Me phenav kava golese so vaćaren kaj me tradav e benđen e Veelzevulese zorasa. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Al te me e Veelzevulese zorasa tradav e benđen, save zorasa traden len tumare sikade? Golese von korkore ka dokažin tumenđe kaj sen banđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Al te me e Devlese zorasa tradav e benđen, onda avilo tumende o Carstvo e Devleso.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","O Isus vaćarda: “Kana o zuralo manuš savo naoružil pe, aračhol piro čher, leso barvalipe si šukar arakhado. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Al kana avol pozuralo lestar thaj pobedil le, ka lol sa leso oružje ane savo pačaja thaj ka ulavol pirencar gova so lija tare kova manuš. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ko naj mancar, protiv mande si thaj ko mancar ni ćidol, vov onda čhorol.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Kana o bilačho duxo ikljol andaro manuš, džal ke šuće phuva te rodol than kaj šaj odmoril pe. Kana ni aračhol gasavo than, vaćarol: ‘Ka irima ano čher kotar ikliljem.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Kana ka iril pe, aračhol gova čher šulado thaj lačhardo andral. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Tegani džal thaj aračhol efta avere duxuren, pobilačhe pestar, thaj katane aven andre thaj bešen gothe. Thaj ko kraj avol e manušese pobilačhe nego angleder.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Kana gova vaćarda o Isus, jekh džuvli tare manuša dija vika zurale vaćarindoj: “Blagoslovimi i džuvli savi inđarda tut ane piro vođi thaj dija tut čuči!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Al o Isus phenda: “Vadži po blagoslovime si kola save šunen o Lafi e Devleso thaj ćeren le.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Sar e manuša lije pobut te ćiden pe, o Isus lija te vaćarol lenđe: “Kaja generacija si bilačhi. Rodol znako thaj ni ka dol pe aver znako samo o znako savo sasa e prorokose e Jonase. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Golese kaj, sar so o Jona sasa znako e manušenđe save živisade ano foro Niniva, gija i me, o Čhave e manušeso, ka avav znako e manušenđe tari kaja generacija. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ko đive taro baro sudo e Devleso i carica so angleder vladisada e južnone phuvasa, ka uštol thaj ka osudil e manušen tari kaja generacija, golese kaj avili tare empalune phuva te šunol e Solomoneso mudrost. Al akh, kate si khoni pobaro taro Solomon, a tumen ni manđen te šunen le. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ko đive taro baro sudo e Devleso e manuša so bešle ano purano foro Niniva, ka ušten i ka osudin e manušen tari kaja generacija, golese kaj kajisajle kana o Jona propovedisada lenđe. Al akh, kate si khoni pobaro taro Jona, a tumen ni pokajisaljen!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Khoni ni phabarol i svetiljka pa te čhuvol la talo garado than il talo čaro, nego čhuvol la ko than e svetiljkako te šaj dičhen o svetlost kola so den ano čher. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ćiri jakh si sar svetiljka e telose. Ako gija ćiri jakh si sasti, sa ćiro telo ka avol osvetlimo. Ako si ćiri jakh bilačhi, ćiro telo ka avol ani tama. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Golese vodi redo gova svetlost ma te avol ane tute i tama. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Golese, te si sa ćiro telo osvetlimo thaj naj nisavo kotor ani tama, tegani sa ćiro džuvdipe ka avol osvetlimo sar kana i svetiljka osvetlil tut pe svetlosa.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Kana o Isus vadži vaćarola, jekh tare fariseja akharda le te xal mangro ke leste. O Isus đelo ke leste thaj bešlo ko astali. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Al o farisejo čudisajlo kana dikhlja so o Isus angleder ni thoda pe vasta anglo xape. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Tegani lese o Gospod o Isus vaćarda: “Čače, tumen e fariseja thoven od avral o tahtaj thaj o čaro, al andral tumen sen pherde pohlepa thaj bilačhipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Bigođaće! Naj li o Dol kova savo ćerda e manuše od andral thaj od avral? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nego, den so si andral sar milostinja thaj sa ka avol tumenđe thodo. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Pharo tumenđe e farisejenđe so den dešto kotor tari nana, tari ruta thaj taro sa o povrće, al ni marin te ćeren averenđe kova so si pravedno thaj te manđen e Devle. Trubul te den dešto kotor, al ni trubun te ačhaven e považna buća. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Pharo tumenđe e farisejenđe! Golese so volin te bešen ke anglune thana ane sinagoge thaj kana dičhen tumen e manuša, pherde poštujipe premal tumende, te pozdravin tumen ke trgura. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Pharo tumenđe učiteljuralen tare Mojsijaso zakon thaj farisejonalen, dujemujenđe! Tumen sen sar e neprimetna limora pe save e manuša uštaven a ni džanen kaj uštaven len.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tegani phenda e Isusese nesavo učitelji tare Mojsijaso zakon: “Učitelju, kana kava phene, ladžare i amen!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","O Isus phenda lese: “Pharo i tumenđe, učiteljuralen tare Mojsijaso zakon! Golese so čhuven pe manuša pharipe savo si but pharo inđarimase, a ni tumare najesa ni manđen te crden te pomožin nekase. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Pharo tumenđe! Golese so ćeren limora e prorokurenđe, saven tumare paradada mudarde. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Golesa sikaven kaj odobrin gova so ćerde tumare paradada: von mudarde len, a tumen vazden lenđe limora. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Golese o Dol ane leso mudrost vaćarda tumendar: ‘Ka bičhalav lenđe prorokuren thaj apostoluren. Nesaven lendar ka mudaren, a e dujtonen ka progonin.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Golese, e manuša tari kaja generacija ka aven kaznime za ko rat savo thavdija tare sa e prorokura taro ćerdipe e svetoso, ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","taro Aveljeso rat dži e Zaharijaso rat, savo sasa mudardo maškaro žrtveniko thaj o sveto than e Hrameso. Va, phenav tumenđe, ka rodol pe tari tumari generacija. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Pharo tumenđe učiteljuralen tare Mojsijaso zakon! Golese so garaden o ključo taro džanglipe. Korkore ni den andre, a tumen ni mukhljen kolen save manglje te den andre.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Kana o Isus iklilo gothar, e učitelja tare Mojsijaso zakon thaj e fariseja lije ani bari holi te protivin pe thaj te pučen le tare but buća. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Dikhlje te dolen le ani zamka lese lafurencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Kana ćidije pe but milja manuša gaći kaj lije te uštaven jekh avere, o Isus angleder lija te vaćarol pe sikadenđe: “Aračhen tumen taro kvasaco e farisejengo, so si dujemujengo. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Golese kaj naj garado khanči so ni ka pučardol, thaj naj učhardo khanči so ni ka šundol angle savorende. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Golese so si vaćardo ano mrako, ka šundol ko svetlo. Thaj sa so vaćarden čorale ko kan ane phangle sobe, tare krovura ka šundol!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Al vaćarav tumenđe, amalalen, ma daran tare kola so šaj mudaren o telo, golestar khanči aver našti ćeren tumenđe! ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ka vaćarav tumenđe kastar te daran. Daran taro Dol savo šaj mudarol thaj isi le zor te čhudol ani jag savi ni ačhol. Va, phenav tumenđe, lestar daran! ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ni li bićindon pandž čiriklja paše duj pare? Thaj ni jekha ni zabistrol o Dol. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","A tumenđe i tumare bala ko šoro si đinde. Golese ma daran! Tumen sen povredna tare pherdo čiriklja.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Gija vaćarav tumenđe: Dži jekh ko anglo manuša priznajil kaj pripadil manđe, le i me, o Čhavo e manušeso, ka priznajiv angle anđelura. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Al ko man čhudol angle manuša, lestar i me ka odrekniv man angle Devlese anđelura. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Dži jekh ko vaćarol nesavo lafi protiv mande, protiv o Čhavo e manušeso, lese ka avol oprostimo. Al kova ko vaćarol bilačhe taro Sveto Duxo, lese ni ka avol oprostimo. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Kana ka anen tumen anglo sudo ke sinagoge thaj angle šorutne thaj anglo vlast, ma daran sar ka branin tumen thaj so ka vaćaren. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Golese kaj o Sveto Duxo ka sikavol tumen ane gova sato so trubul te vaćaren.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tegani vaćarda khoni tare manuša e Isusese: “Učitelju, vaćar mingre phralese te ulavol mancar kova so ačhada amenđe amaro dad.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","O Isus phenda lese: “Manušeja, ko man čhuta te avav sudija il delioc pe tumende?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Thaj vaćarda savorenđe o Isus: “Dičhen thaj aračhen tumen tari pohlepa! I sa gaći barvalipe te avol manuše, leso džuvdipe ni avol golestar so isi le.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Pale gova o Isus vaćarda lenđe kava paramič: “Nesave barvale manušesi phuv bijanda but bijandipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Dija gođi ane peste vaćarindoj: ‘So ka ćerav? Naj ane soste te ćidav e milajeso ćidipe.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Thaj vaćarda: ‘Kava ka ćerav! Ka peravav mingre thana taro điv thaj ka ćerav len pobare thaj gothe ka ćidav mingro điv thaj sa so isi man. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Tegani ka vaćarav korkoro manđe: Isi tut baro barvalipe bute beršenđe. Ka odmori tut, ka xa, ka pije thaj ka veseli tut!’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Al o Dol lese vaćarda: ‘Bigođaleja! Vadži kaja rat ka lol pe ćiri duša tutar. Thaj kase ka ačhol sa gova so steknisadan?’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Gija si kolesa savo ćidol pese barvalipe ki phuv, a ni ćidol barvalipe savo si šukar ane Devlese jakha.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Tegani o Isus pe sikadenđe phenda: “Golese vaćarav tumenđe: Ma daran za ko tumaro džuvdipe dal ka avol tumen so te xan, ni tumare telose so ka uraven! ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Golese kaj si o džuvdipe pobut taro xape thaj tumaro telo pobut taro urajipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Dičhen e gavranuren! Sar ni sejin, ni ćiden, naj len ni podrumo ni kaj čhuven o điv, thaj o Dol parvarol len. A kobor sen tumen povredna tare čiriklja? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Šaj li khoni tumendar golesa so brinil pe te baravol piro džuvdipe paše jekh đive? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kana našti ni gova zala te ćeren, sose brinin tumen za ko sa aver? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Dičhen e luluđa ki livada sar baron! Ni ćeren bući, ni suven pese šeja, a me vaćarav tumenđe kaj ni o caro o Solomon ane pe barvale šeja ni sasa urado sar jekh lendar. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Te o Dol e čara gija uravol ko polje, savi si ađive thaj theara čhudol pe ani jag, dal ni ka brinil pe tumenđe vadži pobut? Sose gaći zala pačan? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Golese, ma brinin tumen isi li tumen so te xan il so te pijen. Ma daran! ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Gija ćeren ke kava sveto e manuša save ni džanen e Devlese. Tumaro Dad ano nebo džanol kaj sa gova trubul tumenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nego roden o Carstvo e Devleso thaj aver ka dodol pe tumenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ma daran, mingre cikne bakre! Tumaro Dad manglja te dol tumen te aven ano Carstvo. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Bićinen so isi tumen thaj den e čororenđe! Ćeren tumenđe traste za ke pare save ni phuravon thaj barvalipe ko nebo savo ni ka ciknjol. Khoni našti te avol odori te čorol tumaro barvalipe thaj ni jekh moljco ni ka xal le. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Golese, kaj si tumaro barvalipe, gothe ka avol i tumaro ilo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","O Isus vaćarda lenđe: “Aven spremna thaj urade za ki bući thaj tumare svetiljke te aven phabarde, ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","sar manuša save ađućaren pe gospodare savo iril pe taro abav, te aven spremna te putren lese kana resol thaj marol ko vudar. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","E sluge save si spremna thaj ađućaren pe gospodare te iril pe, ka aven blagoslovime. Čače vaćarav tumenđe, o gospodari korkoro ka uravol pe sar sluga thaj ka phenol lenđe te bešen thaj ka avol te služil len thaj ka dol len te xan. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","O gospodari šaj ka avol ki opaš i rat il anglo uštipe taro sojipe. Blagoslovime si e sluge save ađućaren. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","A kava džanen: kana bi džanola o čherutno ke savo sato ka avol o čor, ne bi dola te avol leso čher phago. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Thaj tumen aven spremna, golese so me, o Čhavo e manušeso, ka avav kana ni ka den gođi ane savo sato.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","A o Petar pučlja e Isuse: “Gospode! Vaćare li amenđe e sikadenđe kaja paramič, il savorenđe?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","A o Isus vaćarda lese: “Savo si devlikano thaj džanglo sluga kas leso gospodari ka čhuvol upreder pe čherese sluge te dol len te xan ko vreme? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Blagoslovimo si gova sluga kas o gospodari kana avol, aračhol le sar ćerol gijate! ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Čače vaćarav tumenđe, o gospodari pe sa piro barvalipe ka čhuvol e sluga. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ako vaćarol o sluga ane po ilo: ‘O gospodari ni ka avol sigate’ thaj lol te marol avere slugen thaj e sluškinjen thaj xal em pijol thaj matol. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","O gospodari ka avol ano đive kana vov ni ađućarol thaj ano sato kana ni dol gođi, ka čhinol e sluga ke kotora thaj ka čhuvol le maškar kola save ni pačan ano Dol. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","A kova sluga savo džanglja so leso gospodari manđol thaj naj spremno thaj ni ćerda pale leso manglipe ka avol but mardo. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","A okova sluga savo ni džanglja e gospodaresi volja, a ćerda khanči sose ka avol mardo, ka marolpe zala. Kase dija pe but, but ka rodol pe lestar. Kase poverimo but, po but ka rodol pe lestar.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Thaj o Isus vaćarda: “Me aviljem te čhudav i jag e sudosi ki phuv. O, sar bi mangava te avol već phabardi! ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Al me trubul te krstima mučimasa thaj but manđe pharo sa dok ni ćerdol gova! ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Dal den gođi kaj me aviljem te anav mir ki phuv? Na, me aviljem te anav ulaipe maškare manuša. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Golese od akana ka aven ulade e pandž čherutne: trin manuša ka aven ke mingri rig, a duj ka aven protiv gola trin. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ka uštol o dad protiv o čhavo thaj o čhavo protiv o dad, i dej protiv i čhej thaj i čhej protiv i dej, i sasuj protiv i bori thaj i bori protiv piri sasuj.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Thaj o Isus vaćarda e manušenđe: “Kana dičhen kaj e kale oblakura ćiden pe nakaro zapad tumen phenen: ‘Ka dolpese bršnd’, thaj gija avol. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kana dičhen taro jug phurdol, vaćaren: ‘Ka avol tatipe’ thaj gija avol. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Dujemujenđe! O muj e phuvako thaj neboso pindžaren, a sar ni pindžaren kala znakura so ćerdon akana? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Tumen korkore trubul te džanen so si šukar! ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Te khoni tužil tumen zbog o dugo savo ni irisaden thaj inđarol tumen ko sudo, odrumal miri tut lesa, te ma vucil tut ko sudo, golese so o sudija šaj osudil tut thaj te dol tut ke piro manuš te phandol tut ano phanglipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","A ako phandol tut vaćarav tuće: Ni ka iklje gothar dok ni poćine dži i paluni parava.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ane gova vreme odori sesa nesave save phende e Isusese tare Galilejcura savengo rat o Pilat mešisada lenđe žrtvencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","O Isus phenda lenđe: “Tumen li den gođi kaj gola Galilejcura so sesa mudarde si po grešna tare avera Galilejcura? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Na! Phenav tumenđe, al ako ni irin tumen tare grehura, sa tumen gija ka meren. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Il, so si kole dešohtonecar (18) pe kaste pelo o toranj ano Siloam thaj mudarda len? Tumen li den gođi kaj von sesa po grešna tare sa avera manuša so bešen ano Jerusalim? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Na! Phenav tumenđe, al ako ni irin tumen tare grehura, sa tumen gija ka meren.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","O Isus vaćarda lenđe kaja paramič: “Jekhe manuše sasa smokva sadime ano vinograd. Kana avilo te dičhol dal anda bijandipe, ni arakhlja pe late khanči. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Tegani vaćarda e manušese savo ćerda bući ko vinograd: ‘Akh, trito berš sar avav te rodav bijandipe pi kaja smokva, al ni arakhav khanči. Čhin la! Sose te šućarol i phuv?’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Kova manuš lese phenda: ‘Gospodarona! Ačhav la vadži kava berš te hunav paše late thaj te čhudav laće gunoj. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Šaj ka bijanol aver berš, te na, ka čhine la.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Kana o Isus sikavola ani jekh sinagoga ko savato ");
INSERT INTO rmyGurbet_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","sasa gothe jekh džuvli savi sasa banđardi dumesa taro bilačho duxo thaj sasa nasvali dešohto (18) berš thaj naštine te ispravil pe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Kana o Isus dikhlja la, dija la vika thaj phenda laće: “Džuvlije! Oslobodimi san tare ćiro nasvalipe!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Čhuta pe late pe vasta, thaj voj sigate ispravisajli thaj hvalisada e Devle. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tegani o starešina tari sinagoga but holajlo sose o Isus sastarda ko savato thaj vaćarda e manušenđe: “Isi šov đive ano kurko ke save šaj ćerol pe bući! Aven ke gola đive te sastardon, a na ko savato!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","O Gospod o Isus tegani phenda lese: “Dujemujenđe! Tumen li ni putren tumare guruve il e here tari jasla thaj ni inđaren le te pijol paj? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","A kala čheja tare Avraamesi kuštik sava o Satana phanglja akh dešohto (18) berš, sose te ma avol oslobodimi ko savato?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Kana kava šunde, ladžajle savore save sesa protiv leste, al sa avera manuša sesa baxtale baše sa e šukar buća so o Isus ćerda. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Tegani o Isus vaćarda: “Savo si o Carstvo e Devleso? Thaj sosa te uporediv le? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Vov si sar seme e gorušicako, savo lol o manuš thaj čhudol le ane piro vrt. Vov barol thaj ćerdol baro kaš thaj e čiriklja aven thaj ćeren pese gnezdura ane lese raja.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Thaj palem o Isus vaćarda: “Savo si o Carstvo e Devleso? Thaj sosa te uporediv le? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Vov si sar kvasaco savo i džuvli dospil ani bari vangla aresa, sa dži kaj ni šukljol.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Dok o Isus phirda pe dromesa ano Jerusalim, nakhlo maškare forura thaj maškare gava thaj sikavola e manušen. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Khoni pučlja le: “Gospode, dal samo zala ka aven spasime?” O Isus phenda lenđe: ");
INSERT INTO rmyGurbet_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Trudin tumen te den ko tesno vudar e neboso, golese kaj but džene, vaćarav tumenđe, ka manđen te den, al ni ka šaj. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kana o čherutno uštol thaj phandol e vudara tare piro čher, ka avol tumenđe but kasno. Tegani ka ačhen avral, ka čalaven ko vudar thaj ka den vika: ‘Gospode! Putar amenđe e vudara!’ Al vov ka vaćarol tumenđe: ‘Ni pindžarav tumen katar sen.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Tegani ka vaćaren: ‘Amen xaljam thaj piljam tusa thaj pe amare droma sikadan!’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Al vov ka phenol: ‘Vaćarav tumenđe: Ni pindžarav tumen katar sen. Crden tumen mandar save bilačhipe ćeren!’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Gothe ka roven thaj ka škripin dandencar, kana ka dičhen e Avraame, e Isaako thaj e Jakove thaj sa e prorokuren ano Carstvo e Devleso, a tumen ka aven ikalde avri. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","But džene ka aven taro istok thaj taro zapad, taro sever thaj taro jug thaj ka bešen pašo astali ano Carstvo e Devleso. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Thaj dikh, kola so si akana anglal odori ka aven empalal, a kola save si empalal odori ka aven emanglal.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ane gova đive avile nesave fariseja te phenen e Isusese: “Iklji thaj dža akatar, golese so o caro o Irod manđol te mudarol tut!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","O Isus phenda lenđe: “Džan thaj vaćaren gole lisicaće: ‘Akh, ikalav e benđen thaj sastarav ađive thaj theara, a trito đive ka završiv.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Al ađive, theara thaj prektheara trubul te džav mingre dromesa, golese kaj o proroko našti mudardol avral taro Jerusalim. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jerusalime, Jerusalime, tu savo mudare e prorokuren thaj čhude bara pe kola saven bičhalda o Dol tuće! Kobor droma mangljem te ćidav ćire čhavoren sar i khanji pe pujoren tale pe phaka, al ni mangljen! ");
INSERT INTO rmyGurbet_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Akh, tumaro čher ka avol pusto. A me vaćarav tumenđe: Ni ka dičhen man sa dok ni vaćaren: ‘Blagoslovimo si kova savo avol ano alav e Gospodeso.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ke jekh savato o Isus đelo ko jekh šorutno e farisejengo te xal mangro ke leste thaj savore so sesa gothe dikhlje ane leste so ka ćerol. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Thaj dikh, avilo nesavo manuš anglo Isus kase vasta thaj e pingre sesa pherde pajesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Thaj o Isus pučlja e učiteljuren tare Mojsijaso zakon thaj e farisejen: “Premale Mojsijaso zakon, šaj li te sastara ko savato il našti?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Al von khanči ni vaćarde. Tegani o Isus dolda e nasvale manuše, sastarda le thaj phenda lese kaj šaj te džal. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Pale gova lenđe vaćarda: “So den gođi? Te perol ćiro čhavo il ćiro guruv ano bunari, ni li ka ikale le sigate ano savatno đive?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","A len ni sasa len so te phenen ke lese lafura. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Kana o Isus dikhlja sar e manuša save avile te xan, roden pese šukar thana kaj te bešen anglal, vaćarda lenđe kaja paramič: ");
INSERT INTO rmyGurbet_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Kana akharen tumen ko abav, ma bešen ke lačhe anglune thana. So ako si akhardo pobaro manuš tutar? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Tegani kova manuš so akharda tut ka avol thaj ka vaćarol tuće: ‘De gova than kalese.’ Tegani ka ladžare tut thaj ka crde tut te beše ko empaluno than savo ačhilo. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Nego, kana khoni akharol tut ko abav, dža thaj beš ko empaluno than. Tegani ka avol kova so akharda tut, thaj ka vaćarol tuće: ‘Amala! Arakhljam tuće pošukar than.’ Tegani ka aven tusa ko baripe kola save bešen tusa ko astali. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Golese so, ko pes vazdol, ka avol ponizimo, thaj ko pes ponizil, ka avol vazdimo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Pale gova o Isus vaćarda kolese so akharda le: “Kana de xamase il večera, ma akhar ćire amalen ni ćire phralen, ni ćire familija, ni ćire barvale pašutnen, golese so i von tut ka akharen ko xape thaj gija ka irin tuće. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Gija kana ćere gozba akhar e čororen, e banđen, e sakaten thaj e koren. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Tegani ka ave blagoslovimo, golese kaj len naj sar te nagradin tut. Al o Dol ka nagradil tut kana ka vazdol e pravednikuren taro meripe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Kana kava šunda jekh tare manuša savo bešlo pašo astali, vaćarda e Isusese: “Blagoslovimo si kova savo ka xal mangro ano Carstvo e Devleso!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Al o Isus phenda lese: “Jekh manuš ćerda bari gozba thaj akharda bute manušen. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kana sasa o vreme e xamaso, bičhalda pe sluga te vaćarol e akhardenđe: ‘Sa si postavimo ko astali. Aven!’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Al savore lije te vaćaren kaj našti te aven. Jekh vaćarda lese: ‘Ćindem njiva thaj džav te dikhav savi si. Moliv tut, vaćar e gospodarese kaj golese našti te avav.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Aver phenda: ‘Ćindem deše guruven thaj džav te probiv len sar orin. Moliv tut, vaćar e gospodarese kaj golese našti avav.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Trito vaćarda: ‘Andem manđe romnja. Golese našti avav.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Thaj avilo o sluga thaj phenda pe gospodarese so vaćarde lese. Tegani o gospodari holajlo thaj vaćarda pe slugase: ‘Dža sigate ke droma e forose thaj an akari e čororen, e banđen, e sakaten thaj e koren!’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Kana gova ćerda, vaćarda o sluga pe gospodarese: ‘Ćerdem sar so vaćardan, al isi vadži thana.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","O gospodari vaćarda e slugase: ‘Iklji ke droma thaj pale ograde thaj ana kolen so ačhen odori, te aven te pherdol o čher. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Golese vaćarav tumenđe kaj nijekh kole anglunendar kas akhardem ni ka xal tari gozba.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","E Isusesa đele but manuša. Vov irisajlo thaj vaćarda lenđe: ");
INSERT INTO rmyGurbet_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Te khoni manđol te avol mingro sikado, trubul te manđol pobut man, nego pe dade thaj pe da, pe romnja thaj pe čhaven, pe phralen thaj pe phejen, pobut, nego čak i piro džuvdipe. Savo ni ćerol gija, našti avol mingro sikado. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Golese kaj, ko manđol te avol mingro sikado, mora te inđarol piro krsto thaj te džal pale mande. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Te khoni tumendar manđol te ćerol baro čher, na li angleder ka đinol kobor ka trubul lese thaj ka dičhol šaj li te završil la? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Te ćerda samo o temelji thaj te ni ačhilo le pare te završil le, savore save ka dičhen gova ka maren muj lesa ");
INSERT INTO rmyGurbet_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","vaćarindoj: ‘Kava manuš lija te ćerol baro čher thaj naštine te završil le.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Il savo caro kana džal te marolpe avere carosa, angleder golestar ni bešol te dičhol dal ka šaj pe deše miljencar (10 000) te marolpe kolesa so inđarol pesa biš milje (20 000)? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Te našti, ka bičhalol manušen, dok si kova aver caro dur thaj molil le te mirin pe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Gija akana khoni tumendar savo ni mučhol sa so isi le, našti avol mingro sikado.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Tegani o Isus vaćarda: “O lon si šukar. Al kana hasarol piro londipe, sosa ka lonđarol pe? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Naj lačho ni e phuvaće, ni gunojese, gijate o lon čhudol pe avral. Kas isi kana te šunol, nek šunol!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Pašo Isus ćidije pe pherdo carincura thaj but grešnikura te šunen so sikavol. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Al e fariseja thaj e učitelja tare Mojsijaso zakon vaćarena maškar peste: “Kava primil e grešnikuren thaj xal lencar.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Golese o Isus lenđe vaćarda kaja paramič: ");
INSERT INTO rmyGurbet_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Te khanika tumendar isi šel (100) bakre thaj jekh lendar hasardol, so ka ćerol? Ka ačhavol e enjavardeš thaj enja (99) ki pustinja thaj ka džal te rodol gola jekha so hasajli sa dok ni aračhol la. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Thaj kana aračhol la, čhuvol la radosno ke piro piko. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Kana avol čhere, dol vika pe amalen thaj e pašutnen vaćarindoj: ‘Radujin tumen mancar! Arakhljem mingra hasarde bakra!’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Vaćarav tumenđe kaj ano nebo ka avol pobaro radost baše jekh grešniko savo iril pe tare pe grehura nego baše enjavardeš thaj enja (99) pravedna savenđe ni trubul pokajipe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","O Isus vaćarda thaj kava: “Il, te nesavi džuvli isi la deš srebrenjakura thaj hasarol jekh, so ka ćerol? Ka phabarol i svetiljka thaj ka šulavol o čher thaj ka rodol šukar sa dok ni aračhol la? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Thaj kana aračhol la, akharol pe amalinjen thaj e pašutnen thaj phenol lenđe: ‘Radujin tumen mancar! Me arakhljem o srebrenjako so hasardem!’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Gija, vaćarav tumenđe kaj maškare anđelura e Devlese ka avol pobaro radost baše jekh grešniko savo iril pe tare pe grehura.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Thaj o Isus vaćarda: “Jekhe manuše sesa duj čhave. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","O ciknjeder vaćarda e dadese: ‘Dade! De man kotor taro barvalipe so preperol manđe.’ Thaj o dad ulada lenđe o barvalipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Pale nekobor đivesa, ćidija o ciknjeder čhavo sa piro, đelo ani durutni phuv, odori xalja sa o barvalipe thaj živisada dilikane. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kana xalja sa e pare, sasa but baro bokhalipe ane goja phuv thaj ni sasa le so te xal. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Golese đelo ki jekh manuš te ćerol bući. Gova manuš bičhalda le ane piro polje te aračhol e balen. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","O čhavo sasa gija bokhalo kaj bi xala i gova so xan e bale, al khoni ni dija le ni gova. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Tegani avilo ane peste thaj vaćarda: ‘Kobor e bućarne ke mingro dad isi len so te xan, a me kate merav bokhalo! ");
INSERT INTO rmyGurbet_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ka džav ke mingro dad thaj ka vaćarav lese: “Dade, grešisadem anglo Dol thaj angle tute. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Naj sem vadži dostojno te akhardivav ćiro čhavo. Le man sar jekhe tare ćire bućarne.”’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Tegani uštilo thaj đelo ke piro dad. A kana sasa vadži dur, dikhlja le leso dad thaj pelo lese žal. Prastija ke leste, zagrlisada le thaj čumidija le. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Tegani o čhavo vaćarda lese: ‘Dade, grešisadem anglo Dol thaj angle tute! Naj sem vadži dostojno te akhardivav ćiro čhavo.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Al o dad phenda pe slugenđe: ‘Sigate! Ikalen emlačho fostano thaj uraven le! Čhuven lese angrustik ko va thaj sandale ke pingre! ");
INSERT INTO rmyGurbet_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Anen e terne thule guruve thaj čhinen le, te xa thaj te raduji amen, ");
INSERT INTO rmyGurbet_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","golese kaj mingro čhavo sasa mulo thaj džuvdilo; sasa hasardo thaj arakhadilo!’ Thaj lije te radujin pe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","O phureder čhavo sasa ano polje. Kana avilo pašo čher, šunda čhelipe thaj bašalipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Tegani dija vika jekhe sluga thaj pučlja le: ‘So si gova?’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Vov phenda lese: ‘Ćiro phral avilo. Ćiro dad čhinda e terne thule guruve, golese so dikhlja le džuvde thaj saste.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Tegani o phureder phral holajlo thaj ni manglja te avol andre. Al iklilo leso dad thaj molisada le te dol ano čher. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Al vov vaćarda pe dadese: ‘Akh, služiv tut sar robo gaći berša thaj nikad ni phagljem ćiro lafi. Thaj manđe ni jekh drom ni dijan ni buzore te radujiv man mingre amalencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Al kana avilo ćiro čhavo savo ćiro barvalipe čhorda e bludnicencar, čhindan lese terne thule guruve.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","A o dad phenda lese: ‘Mo čhavo! Tu san uvek mancar thaj sa so si mingro, si ćiro. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Al trubul te raduji amen thaj te ava baxtale, golese kaj ćiro phral sasa mulo thaj džuvdilo; sasa hasardo thaj arakhadilo.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","O Isus vaćarda pe sikadenđe kaja paramič: “Jekhe barvale manuše sasa jekh upravitelji savo vodila leso barvalipe. Le tužisade kaj xalja leso barvalipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Golese o barvalo akharda le thaj vaćarda lese: ‘So šunav kava tutar? Sikav manđe o đinipe tare ćiri bući pe mingro barvalipe, golese kaj našti vadži pe mingro barvalipe te ave upravitelji.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Tegani o upravitelji vaćarda ane peste: ‘So ka ćerav? O barvalo gospodari mingro ka lol mandar i bući. Naj man zuralipe te hunav thaj ladžav te mangav. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Džanav so ka ćerav te primin man savore ane pe čhera kana ka ačhav bizi bući.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Thaj dija vika sa kolen save sesa lese gospodarese dužna thaj pučlja e anglune: ‘Kobor duguji mingre gospodarese?’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Vov phenda: ‘Šel (100) bačve taro maslinsko ulje.’ Tegani o upravitelji vaćarda lese: ‘Le ćiro lil, beš thaj sigate pisi pinda (50).’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Pale gova pučlja e dujtone: ‘A tu, kobor duguji?’ Vov phenda: ‘Šel (100) mere điv.’ Thaj vaćarda lese: ‘Le ćiro lil thaj pisi ohtovardeš (80).’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Tegani o barvalo gospodari hvalisada pe xoxavne upravitelje, kobor si džanglo so gija ćerda. Čače, e manuša tare kava sveto po snalažljivo postupin premal kola save si slična lenđe thaj si po džangle, nego e manuša e svetlose. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Thaj me vaćarav tumenđe: so isi tumen barvalipe kale svetoso, upotrebin le te ćeren tumenđe amalen. Kana ni ka avol tumenđe više korisno o barvalipe kale svetoso, ka aven primime ane čhera sa e đivesenđe ano nebo. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ko si verno ane cikne buća, vov ka avol verno i ane pobare buća; thaj ko naj verno ane cikne buća, vov ni ka avol verno ni ane pobare buća. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Gijate, te naj sen verna ano barvalipe kale svetoso, ko ka dol tumen čačukano barvalipe? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Te naj sen verna ane avereso barvalipe, ko ka dol tumen tumaro? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Nijekh sluga našti služil tari jekh drom duje gospodaren. Il jekhe ka mrzi, a dujtone ka manđe; il jekhe ka šune, a e dujtone ni ka šune. Našti služin thaj e Devle thaj o barvalipe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Sa kava šunde i e fariseja, save sesa pohlepna parenđe, thaj marde muj e Isusesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","O Isus phenda lenđe: “Tumen ćeren tumen pravedna angle manuša, al o Dol džanol tumare ile. So si vredno ane manušenđe jakha, si gadno ane Devlese jakha.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Tegani o Isus vaćarda: “E Mojsijaso zakon thaj e lila save pisisade e prorokura, sikljona sa dži kaj o Jovane o Krstitelj ni avilo. Od tegani propovedil pe o Lačho Lafi taro Carstvo e Devleso thaj savore den zor te džan ane leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Al gova ni značil kaj o Zakon više ni vredil, golese so poločhe si te načhen o nebo thaj i phuv, nego jekh slovo andaro Zakon te properol. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Dži jekh savo mučhol pe romnja thaj lol avera, preljuba ćerol; thaj savo lol džuvlja sava lako rom mukhlja, preljuba ćerol.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","O Isus vaćarda vadži jekh paramič: “Sasa jekh barvalo manuš. Sasa urado ane barvale šeja thaj živisada ano barvalipe, but xalja thaj pilja svako đive. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Angle leso vudar pašljola jekh phumbalo – sasa čoro thaj sasa le but čirura – leso alav sasa Lazar. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Vov čeznila te čaljol e troškendar so perena tare barvaleso astali. Čak thaj e džukle avena thaj čarena lese phumba. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Kana mulo o čoro, e anđelura inđarde le ani angali e Avraamese. Thaj posle i o barvalo mulo thaj prahosade le. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ano than kaj si e mule, ane bare muke, o barvalo vazdija pe jakha thaj odural dikhlja e Lazare ani angali e Avraamese. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Thaj dija vika: ‘Dade Avraame! Smilui tut pe mande thaj bičhal e Lazare te čhuvol piro naj ano paj, te šudarol mingri čhib, golese kaj sem but mučimo ane kaja jag.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Al o Avraam phenda: ‘Čhaveja! De tut gođi kaj ane ćiro džuvdipe sasa tut sa šukar, a e Lazare sa bilačhipe. Akana lese kate si šukar, a tu muči tut. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Thaj prekale sa gova, maškare amende si bari provalija. Kola save manđen te načhen katar odori tumende, našti; ni gothar te načhen amende.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Tegani vaćarda o barvalo manuš: ‘Moliv tut, dade Avraame, te bičhale e Lazare ano čher mingre dadeso. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Golese kaj isi man pandž phrala. Nek vaćarol lenđe te ne bi i von avena ke kava than e mučimaso.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","O Avraam phenda lese: ‘Len isi e Mojsijaso zakon thaj e lila save pisisade e prorokura. Len nek šunen.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Al o barvalo vaćarda lese: ‘Na, dade Avraame! Te avilo lenđe khoni tare mule, ka pokajin pe.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","O Avraam phenda lese: ‘Te ni šunde e Mojsija thaj e prorokuren, ni ka šunen ni te uštilo khoni tare mule.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","O Isus vaćarda pe sikadenđe: “O iskušenje mora te avol, al pharo kolese prekal kaste avol o iskušenje. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Pošukar ka avol lese te phanden baro bar tari vodenica ke lesi kor thaj te čhuden le ano more, nego te inđarol ano greh jekhe tare kala cikne. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Aračhen tumen! Te grešisada ćiro pačavno phral il phen, vaćar lenđe kaj gova naj šukar. A te pokajisajlo, oprosti lese! ");
INSERT INTO rmyGurbet_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Thaj te efta droma ko đive grešisada premal tute thaj efta droma avilo tute vaćarindoj: ‘Kajiv man,’ oprosti lese.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","E apostolura vaćarde e Gospodese: “De amen po but pačajipe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","O Gospod vaćarda: “Kana bi avola tumen pačajipe gaći cikno sar e gorušicako seme thaj bi vaćarena kale dudinkaće: ‘Ikal tut taro koreno thaj sadi tut ano more!’, bi šunola tumen. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Savo tumendar ka phenol pe slugase, savo hunol i phuv il aračhol e bakren, kana iril pe andaro polje: ‘Av akari, beš te xa mangro’? Nijekh tumendar. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Mesto gova ka vaćaren: ‘Ćer manđe te xav! Čhuv tuće i kecelja thaj služi man dok xav thaj pijav! A pale gova šaj i tu te xa thaj te pije.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","E slugase ni zahvalil pe o gospodari, golese so si gova lesi bući. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Gija i tumen, kana ćeren gova so tumenđe phenda o Dol, vaćaren: ‘Naj sam vredna hvalaće. Samo sam sluge save ćera amari bući.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Kana o Isus đelo ano Jerusalim, nakhlo maškari granica ki phuv i Samarija thaj i phuv i Galileja. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Thaj kana dija ane jekh foro, arakhlje le deš gubavcura save ačhena dur. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Von zurale dije vika vaćarindoj: “Isuse, Gospode! Smilui tut pe amende!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Kana len dikhlja, vaćarda: “Džan thaj sikaven tumen e sveštenikurenđe.” I gija phirindoj sastile. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Jekh lendar dikhlja kaj sastilo, irisajlo thaj hvalisada e Devle andare sa o glaso. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Pelo angle Isusese pingre thaj zahvalisajlo. Gova sasa Samarijanco. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Tegani o Isus pučlja le: “Na li sastiljen deš džene? Kaj si kola enja? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Sar maškar lende ni arakhlja pe nijekh te iril pe te zahvalil e Devlese, nego samo kava manuš andari aver phuv?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Tegani vaćarda lese: “Ušti thaj dža! Ćiro pačajipe spasisada tut.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Jekh đive pučlje e fariseja e Isuse: “Kana ka avol o Carstvo e Devleso?” O Isus phenda lenđe: “O Carstvo e Devleso ni ka avol sar kova so dičhol pe jakhencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ni ka vaćarol pe: ‘Aktalo, kate si’, il: ‘Odori si!’ Golese kaj o Carstvo e Devleso si maškar tumende!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","A pe sikadenđe o Isus phenda: “Ka avol o vreme kana ka manđen te dičhen man barem jekh đive kana me, o Čhavo e manušeso, ka vladiv sar caro, al ni ka šaj. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Tegani e manuša ka vaćaren tumenđe: ‘Akh, kate si’, il: ‘Ek, odori!’ Al ma ikljen thaj ma prasten lencar te roden man. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Golese so me, o Čhavo e manušeso, kana ka avav sar i munja so strefil andaro nebo, ka svetliv sa so si talo nebo. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Al angleder trubul but te avav mučimo thaj kala kuštika mora čhuden man pestar. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Thaj sar sasa ano vreme e Nojaso, gija i ka avol ane đivesa kana me, o Čhavo e manušeso, ka avav. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Xalje, pilje, lije pe, dije pe dži kova đive dži kana o Noja đelo ano brodo. Tegani avilo o baro paj thaj tasile sa kola save ni sesa ano brodo. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Gija sasa i ano vreme kana živisada o Lot. E manuša ano foro i Sodoma xalje, pilje, ćinde, bićinde, sadisade thaj vazdije čhera. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Al ano đive kana iklilo o Lot andari Sodoma, čalada i jag thaj taro nebo pele žuta bara save phabon thaj mudarde sa kolen so ačhile ano foro. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Gija ka avol i ane gova đive, kana ka avav me, o Čhavo e manušeso. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ane gova đive ko ka avol ko krovo, a lese stvara ano čher andre, ma te uljol te lol len! Thaj ko si ano polje, ma te iril pe ano foro pale pe stvara. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Den tumen gođi so sasa e Lotese romnjasa! ");
INSERT INTO rmyGurbet_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ko dičhol te aračhol piro džuvdipe, ka hasarol le, al ko hasarol piro džuvdipe, ka aračhol le. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Vaćarav tumenđe, ane goja rat kana ka avav, duj manuša ka pašljon ko than e pašljimaso: jekh ka lol pe, a dujto ka avol ačhado. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Thaj duj džuvlja ka meljin ano mlin: jekh ka lol pe, a i dujto ka avol ačhadi. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Duj murša ka aven ki njiva: jekh ka lol pe, a dujto ka avol ačhado.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Tegani e sikade pučlje e Isuse: “Kaj, Gospode?” Vov phenda lenđe: “Kaj si o mulo telo, odori ćiden pe i e lešinara.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","O Isus vaćarda pe sikadenđe paramič te sikavol len sar trubul te molin pe thaj te ačhen ane gova. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Vaćarda: “Ane jekh foro sasa jekh sudija savo ni darajlo e Devlestar thaj ni marisada e manušenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ane gova foro sasa i jekh romni savako rom mulo. Voj stalno avola leste thaj molisada le: ‘De man pravda angle kova savo tužil man!’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Vov jekh vreme ni manglja te pomožil laće, al kana nakhlo nesavo vreme vaćarda korkoro pese: ‘Iako ni darav taro Dol thaj ni mariv e manušenđe, ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ka dav pravda kala udovicaće golese so avol but droma ke mande, te ma avol te dosadil man!’” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Tegani vaćarda o Gospod o Isus: “Šunen so vaćarda kova nepravedno sudija! ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ni li ka dol pravda o Dol pe birime manušen save ano rojipe molin pe lese rat thaj đive? Vov li ka ačhavol len te ađućaren? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Vaćarav tumenđe, kaj sigate ka dol len pravda. Al me, o Čhavo e manušeso, kana ka avav ki phuv, ka arakhav li maškare manuša gasavo pačajipe?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Tegani o Isus vaćarda jekh paramič kolenđe save dije gođi pese kaj si čačutne thaj korkore pes dikhlje pobaren averendar: ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Duj manuša đele ano Hram te molin pe e Devlese: Jekh sasa farisejo, a dujto carinco. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","O farisejo ačhilo thaj molisada ane peste: ‘Devla! Hvaliv tut kaj naj sem sar kala avera manuša: čora, nepravednikura, preljubnikura il sar kava o carinco. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Postiv duj droma ko kurko, dav tut dešto kotor tare sa so zaradiv.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Al o carinco ačhilo odural. Ni manglja ni pe jakha te vazdol premalo nebo, nego čalada pe ano kolin te sikavol kobor lese pharo thaj vaćarda: ‘Devla, av milostivno manđe, e grešnikose!’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Vaćarav tumenđe: o carinco đelo čhere opravdimo anglo Dol, a na kava o farisejo. Golese so dži jekh, ko pes vazdol, ka avol ponizimo, thaj ko pes ponizil, ka avol vazdimo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ande anglo Isus i e cikne čhavoren te čhuvol pe vasta pe lende thaj te blagoslovil len. Kana gova dikhlje e sikade, vaćarde lenđe te ni ćeren gova. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Al o Isus dija len vika thaj phenda: “Mučhen e čhavoren te aven ke mande thaj ma ačhaven len, golese so gasavenđe preperol o Carstvo e Devleso! ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Čače vaćarav tumenđe, ko ni primil o Carstvo e Devleso sar čhavoro, ni ka dol ane leste!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Jekh šorutno pučlja e Isuse: “Učitelju šukareja, so te ćerav te avol man džuvdipe bizo meripe?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","O Isus phenda lese: “Sose akhare man šukareja? Khoni naj šukar, samo o Dol. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","E Devlese zapovestura džane: ‘Ma čher preljuba’, ‘Ma mudar’, ‘Ma čor’, ‘Ma svedoči xoxavne’, ‘Poštuji će dade thaj će da!’” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","O šorutno vaćarda: “Sa kava ćerdem tare mingro ternipe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Kana šunda kava o Isus, vaćarda lese: “Vadži jekh trubul tut: bićin sa so isi tut, thaj e pare de e čororenđe thaj ka avol tu barvalipe ko nebo. Pale gova ava pale mande!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kana šunda gova o barvalo, sasa but bibaxtalo, golese kaj sasa le but barvalipe savo ni manglja te bićinol. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Kana dikhlja o Isus kaj sasa bibaxtalo, vaćarda: “Kobor si pharo e barvalenđe te den ano Carstvo e Devleso! ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Poločhe si e kamilaće te načhol maškare kana e suvaće, nego o barvalo te dol ano Carstvo e Devleso!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","E manuša save šunde le, pučlje: “Onda ko šaj te avol spasimo?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","O Isus phenda: “So si nemoguće e manušenđe, e Devlese si moguće.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Tegani o Petar phenda: “Akh, amen ačhadam sa so sasa amen, te dža pale tute.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","O Isus vaćarda lenđe: “Čače vaćarav tumenđe: Dži jekh savo ačhada po čher, il e romnja, il e phralen, il e dade thaj deja, il e čhaven bašo Carstvo e Devleso, ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ka primil akana vadži pobut ke akava sveto kolestar so ačhada, thaj ka primil džuvdipe bizo meripe ko sveto savo ka avol.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ćidija o Isus e dešuduje apostoluren thaj vaćarda lenđe: “Ake, dža upre ano Jerusalim. Odori ka ćerdol sa kova so e prorokura pisisade ano Sveto lil mandar, taro Čhavo e manušeso. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ka den man ke manuša save ni džanen e Devlese thaj ka maren muj mancar. Ka ladžaren man thaj ka čhungaren man. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ka šibin man thaj ka mudaren man, al me o trito đive ka uštav tare mule.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","E sikade khanči ni haljarde tare gova so vaćarda o Isus. O značenje tare kala lafura sasa lendar garado thaj ni džanglje so sasa lenđe vaćardo. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Kana o Isus reslo pašo foro Jerihon, sasa jekh koro manuš savo bešindoj mangljarola ko drom. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Kana o koro šunda kaj pherdo manuša načhen, pučlja: “So si gova?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Vaćarde lese kaj načhol o Isus taro foro Nazaret. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Tegani o koro dija vika: “Isuse, Čhaveja e Davideso, smilui tut pe mande!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Nesave manuša save đele anglo Isus, phende lese te ma dol vika gaći, al vov vadži pozurale dija vika: “Čhaveja e Davideso, smilui tut pe mande!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","O Isus ačhilo thaj vaćarda te anen e kore manuše paše leste. Kana ande le, pučlja le o Isus: ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“So manđe te ćerav tuće?” Vov vaćarda: “Gospode! Mangav te dikhav!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","O Isus phenda lese: “Dikh! Ćiro pačajipe spasisada tut.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Thaj sigate dikhlja, đelo palo Isus thaj hvalisada e Devle. Savore save kava dikhlje, hvalisade e Devle. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","O Isus dija ano foro Jerihon thaj nakhlo gothar. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Odori bešlo nesavo manuš so akhardola Zakej, savo sasa šorutno e carincurengo thaj sasa barvalo. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Vov manglja te dičhol e Isuse, te dičhol ko si vov, al naštine tare but manuša, golese kaj o Zakej sasa cikno. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Golese prastaja po anglal, uklilo pi divljo smokva te dičhol e Isuse, golese kaj džanglja kaj ka načhol gothar. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Kana avilo o Isus ke gova than, dikhlja le upre thaj vaćarda lese: “Zakej! Ulji sigate! Ađive trubul te avav gosto ane ćiro čher.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","O Zakej sigate ulilo taro kaš thaj anda e Isuse ane piro čher radosno. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Savore, save kava dikhlje, vaćarde maškar peste taro Isus kaj ne bi trubula te avol ano čher e grešnikoso. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Al o Zakej ačhilo thaj vaćarda e Gospodese: “Gospode! Akh, opaš mingro barvalipe ka dav e čororenđe. A te nekas phabardem, ka iriv lese štar droma pobut.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","O Isus vaćarda lese: “Ađive avilo spasenje ane kava čher, golese kaj i vov si čhavo e Avraameso! ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Me, o Čhavo e manušeso, aviljem te rodav thaj te spasiv so si hasardo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","But manuša gova šunde thaj o Isus vaćarda lenđe jekh paramič, golese kaj sesa pašo Jerusalim thaj e manuša dije gođi kaj akana ka avol o Carstvo e Devleso. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","O Isus phenda: “Jekh manuš tari prešundi familija đelo ani durutni phuv te postavin le bašo caro, thaj pale gova te iril pe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Angleder so đelo, akharda pe deše slugen thaj dija len po deš mine thaj vaćarda lenđe: ‘Trgujin lencar sa dži kaj ni avav.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Al e manuša tare lesi phuv mrzisade le thaj bičhalde e manušen ko pobaro caro te vaćaren lese: ‘Ni manga vov te carujil pe amende.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Kana kova manuš irisajlo sar caro, vaćarda te akharen kole slugen savenđe dija e srebrenjakura, te dičhol kobor pare ćerde. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Tegani avilo o angluno thaj vaćarda: ‘Gospodarona! Ćerdem deš droma pobut srebro, nego so dijan man.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","O caro vaćarda lese: ‘But šukar. Tu san šukar sluga! Golese so sana manđe šukar ko cikno, dav tut te vladi pe deš forura.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Pale gova avilo o dujto thaj vaćarda: ‘Gospodarona! Ćerdem pandž droma pobut srebro, nego so dijan man.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","O caro vaćarda: ‘Šukar! Tu vladi pe pandž forura.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Tegani avilo o trito thaj vaćarda: ‘Gospodarona! Ake, ćiro srebro. Garadem le ano kotor e šejengo ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","golese kaj daraljem tutar. Golese kaj san zuralo manuš. Tu le so naj ćiro thaj ćide so ni sejisadan.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","O caro vaćarda lese: ‘Pale ćire lafura ka sudiv tut, bilačheja slugo! Džangljan kaj sem zuralo manuš, kaj lav kova so naj mingro thaj ćidav so ni sejisadem. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Pa sose ni dijan mingro srebro e trgovcurenđe te ćidav gova kamatencar kana ka irima?’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Thaj averenđe so ačhile angle leste, vaćarda: ‘Len gova srebro lestar thaj den le kolese so isi le pandž kile srebrenjakura.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Von vaćarde lese: ‘Gospodarona! Le isi već pandž kile srebro.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","O caro vaćarda lenđe: ‘Vaćarav tumenđe, dži jekh kas isi ka dol pe lese, al kole so naj ka lol pe lestar i kova so isi le. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","A kolen mingre dušmajen, save ni manglje te avav lengo caro, anen len akari thaj čhinen len angle mande.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Kana vaćarda lenđe gova o Isus, đelo anglal thaj đelo upre ano foro Jerusalim. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Kana avilo pašo gav Vitfaga thaj o gav Vitanija pašo Maslinsko brego, bičhalda duje sikaden ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","vaćarindoj: “Džan ane gova gav angle tumende. Kana ka den andre, ka aračhen cikne phangle here pe savo vadži nijekh manuš ni uklilo. Putren le thaj anen le. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Te khoni pučlja tumen: ‘Sose putren le?’, vaćaren lese: ‘E Gospodese trubul.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Von đele thaj arakhlje sa sar so vaćarda lenđe o Isus. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kana putarde e cikne here, pučlje len e manuša kaso sasa o cikno her: “Sose putren e cikne here?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Von phende: “E Gospodese trubul.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Tegani ande le ko Isus thaj čhute po cikno her pe fostanura thaj bešljarde e Isuse pe leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Kana đelo o Isus premal o Jerusalim, e manuša čhute pe fostanura ko drom te den čast e Isusese. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Kana avilo pašo than kaj počnil o Maslinsko brego, lije but sikade te radujin pe thaj te hvalin e Devle andare sa o glaso baše čudesura so dikhlje. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Vaćarde: “Blagoslovimo si kova savo avol ano alav e Gospodeso! Mir ko nebo thaj slava e Devlese ko učipe!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Tegani nesave fariseja save sesa maškare manuša, vaćarde lese: “Učitelju! Vaćar ćire sikadenđe te ma phenen gova!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","O Isus vaćarda lenđe: “Phenav tumenđe, te von ni vaćaren, e bara ka den vika!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Kana avilo o Isus pašo Jerusalim, dikhlja o foro thaj ruja lese ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","vaćarindoj: “O, so bi mangava i tu ađive te džane so ka anol tuće mir! Al akana si gova garado tutar. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Golese kaj ka aven e đivesa kana ćire dušmanura ka vazden tuće bare duvara, ka opkolin tut thaj ka ćićiden tut tare sa e riga. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ka peraven tut thaj ka mudaren kolen save bešen ane tute. Ni ka ačhaven nijekh bar ko leso than, golese kaj ni džangljan o vreme kana avilo tute o Dol.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kana dija o Isus ano Hram, lija te tradol kolen save gothe bićinena. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Vaćarda lenđe: “Ano Sveto lil si pisimo: ‘O čher mingro ka avol čher e molitvako’, a tumen lestar ćerden ‘čher kaj garaven pe e čora.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Svako đive o Isus sikada ano Hram. E šorutne sveštenikura, e učitelja tare Mojsijaso zakon katane e manušenđe šorutnencar dikhlje sar te mudaren e Isuse, ");
INSERT INTO rmyGurbet_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","al ni arakhlje sar gova te ćeren lese, golese kaj sa e manuša džana pale leste thaj šunde sa lese lafura. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Jekh đive kana o Isus ano Hram sikada e manušen thaj propovedisada o Lačho Lafi, avile e šorutne sveštenikura, e učitelja tare Mojsijaso zakon thaj e starešine, ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","pa pučlje le: “Vaćar amenđe kotar tuće pravo kava te ćere? Ko dija tut kava pravo?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","O Isus phenda lenđe: “I me tumen ka pučav khanči. Vaćaren manđe: ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","O Dol li vaćarda e Jovanese te krstil e manušen, il e manuša vaćarde lese gova te ćerol?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Von lije te raspravin pe maškar peste: “Te vaćardam: ‘O Dol vaćarda lese,’ ka pučol amen: ‘Sose tegani ni pačajen e Jovane?’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Al te vaćardam: ‘E manuša vaćarde lese gova te ćerol’, savore ka čhuden bara pe amende, golese kaj savore pačaje kaj o Jovane o Krstitelj sasa proroko.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Golese phende kaj ni džanen ko dija pravo e Jovane te krstil. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Tegani lenđe o Isus vaćarda: “Ni me ni ka vaćarav tumenđe kotar manđe kava pravo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Tegani o Isus lija te vaćarol kaja paramič: “Jekh manuš sadisada drakha ano vinograd thaj iznajmisada e manušenđe i phuv te ćeren bući gothe. Pale gova đelo te bešol averthe ke po but berša. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kana avilo o vreme te ćidol pe i drakh, bičhalda pe sluga ke gola manuša te ćidol o kotor taro bijandipe e drakhako so lese preperol. Al e vinogradara marde le thaj bičhalde le čuče vastencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Golese o gospodari taro vinograd bičhalda avere sluga. Al i gole marde, ladžarde thaj bičhalde le čuče vastencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Palem bičhalda ke lende avere sluga. Al von ratvarde le thaj tradije le taro vinograd. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Tegani o gospodari taro vinograd vaćarda: ‘So te ćerav? Ka bičhalav mingre mangle čhave. Šaj le ka poštujin.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Al kana e vinogradara dikhlje lese čhave, vaćarde jekh averese: ‘Kava si leso nasledniko. Aven te mudara le te ačhol gova amenđe so si leso!’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Gija ikalde le avral taro vinograd thaj mudarde le. So den gođi so ka ćerol o gospodari taro vinograd kale manušenđe kana ka šunol so ćerde? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ka avol thaj ka mudarol sa e vinogradaren thaj o vinograd ka iznajmil averenđe.” Kana kava šunde e manuša, vaćarde e Isuse: “Ma te dol o Dol gova te avol!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","O Isus dikhlja ane lende thaj vaćarda: “So značil kava so si pisimo ano Sveto lil: ‘O bar savo čhudije e manuša save vazden e duvara ćerdilo emglavno bar taro čher’? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Dži jekh savo perol pe gova bar, ka phađol pe ke kotora; a pe kaste gova bar perol, ka zgnječil le.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","E učitelja tare Mojsijaso zakon thaj e šorutne sveštenikura dikhlje ane gova sato te vazden pe vasta pe leste, al darajle tare but manuša, golese kaj haljarde kaj o Isus kaja paramič vaćarol lendar. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","E učitelja tare Mojsijaso zakon thaj e šorutne sveštenikura dikhlje po Isus thaj bičhalde ke leste špijunuren, save ćerde pe čačutne, te bi dolena e Isuse kaj vaćarol khanči bilačhe i te bi dena le ko rimsko upravitelji. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Golese kola špijunura pučlje e Isuse: “Učitelju! Amen džana kaj šukar vaćare thaj sikave. Ni dičhe ko si ko, nego čače sikave o drom e Devleso. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Vaćar amenđe, trubul li te da o porezi e carose il na?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Al o Isus dikhlja lengo lukavstvo thaj vaćarda lenđe: ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Sikaven manđe jekh srebrno parava savasa poćinen o porezi. Kaso muj si kate ke pare thaj kaso alav?” Von phende: “E caroso.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Pe gova o Isus vaćarda lenđe: “So si e caroso den e carose, a so si e Devleso den e Devlese.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Thaj naštine te aračhen khanči bilačhe ane lese lafura angle manuša. Divisajle bašo leso vaćaripe thaj khanči ni vaćarde. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Gija avile ko Isus nesave sadukejura save vaćarena kaj naj uštipe tare mule thaj pučlje e Isuse: ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Učitelju! O Mojsije pisisada amenđe kaj kana ka merol nekaso phral thaj ačhavol romnja bize čhave. Gova manuš trubul te lol pe phralese romnja te šaj bijanol čhave savese ka preperol sa o barvalipe e muleso thaj te phiravol leso alav. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Sesa efta phrala. O angluno lija romnja thaj mulo bize čhave. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","O dujto lija pe phralese romnja thaj i vov mulo, ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","thaj i o trito lija la thaj mulo, thaj gija i sa efta phrala. Nijekh ni ačhada čhaven pale peste. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Empalal muli thaj i romni. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kana ka ušten e mule, kasi romni ka avol? Golese kaj sasa romni so eftane phralenđi.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","O Isus vaćarda lenđe: “Manuša kale svetose len pe thaj den pe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Al kola saven o Dol dičhol sar dostojna te ušten tare mule thaj ka aven džuvde ane kova sveto savo avol, ni ka len pe thaj ni ka den pe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Golese kaj ni ka meren, ka aven sar anđelura. Von si e Devlese čhave, golese so o Dol ka vazdol len tare mule. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","A kaj ka ušten e mule, golestar thaj o Mojsije sikada ando Sveto lil, odori kaj pisil taro grmo savo phabol. Gothe vov e Gospode dol vika sar Devle e Avraameso thaj Devle e Isaakoso thaj Devle e Jakoveso. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","A o Dol naj Dol e mulengo nego e džuvdengo, golese so si lese savore džuvde.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","A nesave učitelja tare Mojsijaso zakon vaćarde e Isusese: “Učitelju! Šukar vaćardan.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Darajle thaj khoni ni tromaja te pučol le khanči. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Thaj o Isus pučlja len: “Sar gova šaj vaćaren kaj si o Hrist čhavo e caroso e Davideso? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kana korkoro o David vaćarol ane po lil tare Psalmura: ‘Vaćarda o Gospod e Gospodese mingrese: Beš ko počasno than paše mande ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","dži kaj ni pašljarav e dušmanen tale pingre ćire.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","O David akharda e Hriste Gospode, pa sar šajine te avol leso čhavo?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Dži kaj sa e manuša šunena e Isuse, vov phenda pe sikadenđe: ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Aračhen tumen tare učitelja tare Mojsijaso zakon! Von manđen te džan ane bare fostanura thaj roden e manuša te pozdravin len ke trgura thaj te ačhaven lenđe anglune thana te bešen ke sinagoge thaj ke abava. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ko xoxaipe len o imanje e udovicengo, thaj molin dugačka molitve te sikaven pe sar devlikane. Gasave ka aven embut kaznime.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Kana ano Hram o Isus dičhola sa e barvalen sar čhuven daro ani hramsko riznica, ");
INSERT INTO rmyGurbet_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","dikhlja i jekha čora udovica sar čhuta duj emcikne pare. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Tegani vaćarda: “Čače, vaćarav tumenđe, kaja čori udovica čhuta pobut savorendar! ");
INSERT INTO rmyGurbet_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Golese kaj savore lendar čhute so sasa len pobut, al voj gija čori, dija sa so sasa la.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Kana nesave sikade lije te vaćaren taro Hram kaj si lačhardo lačhe barencar thaj ukrasurencar save e manuša dije e Devlese, o Isus vaćarda: ");
INSERT INTO rmyGurbet_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ka avol o vreme, tare sa kava so dičhen, ni ka ačhol ni bar po bar. Sa ka avol rušimo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Tegani e sikade pučlje le: “Učitelju, kana ka avol gova? Save znakosa ka sikadol gova so ka avol?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","O Isus phenda: “Aračhen tumen ma te aven xoxade! Golese kaj but ka aven ane mingro alav i ka phenen pese: ‘Me sem o Mesija,’ thaj: ‘Avilo o vreme!’ Ma pačan ane lende! ");
INSERT INTO rmyGurbet_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","A kana ka šunen za ko maripe thaj pobune, ma daran! Golese so sa gova trubul te avol, al o krajo ni ka avol sigate.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Tegani o Isus vaćarda lenđe: “Ka uštol o narodo po narodo thaj o carstvo po carstvo. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ke but thana ka tresil pe i phuv thaj ka avol bokhalipe thaj nasvalipe. Ka aven bare znakura ko nebo savendar e manuša ka pherdon dar. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Al angleder sa golestar ka dolen tumen thaj ka traden tumen. Ka den tumen ke sudije e sinagogenđe thaj ka phanden tumen ano phanglipe. Ka inđaren tumen angle carura thaj angle vladara golese so sen mingre sikade. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Kava ka avol tumenđe te bi vaćarena lenđe mandar. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ma daran so ka phenen kana ka trubul te branin tumen. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Golese so ka dav tumen lafura thaj mudrost savaće našti te protivil pe thaj te suprostavil pe nijekh manuš. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ka izden tumen i tumare dada, tumare deja, tumare phrala, tumare pašutne thaj e amala. Nesaven tumendar ka mudaren. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Savore ka mrzin tumen golese so sen mingre sikade. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Al ni o bal tumare šorestar ni ka perol. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ma ačhen te pačan ane mande, pa ka avol tumen džuvdipe bizo meripe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","O Isus vadži vaćarda: “Kana ka dičhen kaj si o Jerusalim opkolimo e vojskasa, te džanen kaj avilo o vreme te avol gova foro pusto. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Tegani e manuša save si tari Judeja, nek našen ke bregura. Al e manuša save si taro Jerusalim, nek ikljen avral thaj kola save si avral, ma te irin pe ane leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Golese kaj ane gola đivesa ka avol e Devlesi kazna, savasa ka pherdol sa kova so si pisimo ano Sveto lil. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Al pharo e khamnjenđe thaj kolenđe save den čuči ane gola đivesa! Golese kaj ka avol baro bilačhipe ki phuv thaj bari holi pe kala manuša. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Von ka mudaren kale manušen e oštrone mačosa thaj ka inđaren len ano phanglipe maškare sa e manuša ki phuv. Thaj o Jerusalim ka uštaven e manuša save ni džanen e Devlese sa dok ni načhol o vreme lengo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","O Isus vadži vaćarda: “Ka aven e znakura ano kham thaj ano čhon thaj ane čerenja. Ki phuv e manuša ni ka džanen so te ćeren tari dar golese so o more thaj e talasura ka šundon but. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","E manuša ka meren tari dar thaj taro ađućaripe so ka avol e svetosa, golese kaj e zora e nebose ka tresin pe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Tegani ka dičhen man, e Čhave e manušese, sar avav pe oblakura e zuralimasa thaj ani bari slava. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kana ka lol te avol gova, ušten thaj vazden tumare šore, golese kaj tumaro Osloboditelji avol tumende.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Tegani o Isus vaćarda lenđe kaja paramič: “Dičhen pi smokva thaj sa e kašta! ");
INSERT INTO rmyGurbet_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kana dičhen kaj ikljen e luluđa lenđe, džanen kaj paše si o milaj. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Gijate i tumen, kana ka dičhen kaj sa avol gija sar so phendem, džanen kaj si paše o Carstvo e Devleso. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Čače vaćarav tumenđe, kaj kaja generacija ni ka načhol dok sa kava ni avol. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","O nebo thaj i phuv ka načhen, al mingre lafura ni ka načhen.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Pale gova o Isus vaćarda: “Aračhen tumen ma tumare ile te aven opteretime ano halanipe, matipe thaj ane brige kale svetose thaj ma gova đive te resol tumen tari jekh drom. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Golese so ka avol sar zamka pe sa e manuša so živin pi kaja phuv. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Golese aven džungade sa o vreme thaj molin tumen te bi šaj crdena tumen tare sa o bilačhipe so trubul te avol, thaj te ačhen bizi ladž ano radujipe angle mande, anglo Čhavo e manušeso.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","O Isus svako đive sikada ano Hram a ki rat suta ko Maslinsko brego. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Thaj sa e manuša avena tari sabalin ke leste ano Hram te šunen le. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Paše sasa o Prazniko e bikvasacose mangrenđe savo akhardol Pasha. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","E šorutne sveštenikura thaj e učitelja tare Mojsijaso zakon rodije sar te mudaren e Isuse, al darajle tare manuša te ni bunin pe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tegani o Satana dija ano Juda Iskariotsko, savo sasa jekh tare dešuduj (12) apostolura. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Vov đelo thaj vaćarda e šorutne sveštenikurencar thaj e hramese zapovednikurencar sar ka izdajil e Isuse. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Von radujisajle thaj vaćarde e Judase kaj ka poćinen lese gova. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","O Juda pristanisada thaj rodija šukar vreme te predol e Isuse dok ni sesa gothe but manuša. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Kana avilo o angluno đive taro Prazniko e bikvasacose mangrengo, ke savo trubuja te čhinol pe o pashalno bakroro, ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","o Isus vaćarda e Petrese thaj e Jovanese: “Džan thaj ćeren amenđe pashalno xape te šaj te xa.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Von pučlje le: “Kaj manđe te ćera la?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","O Isus vaćarda: “Kana ka den ano foro, ka aračhen manuše savo inđarol paj ano khoro. Džan pale leste ano čher ane savo ka džal, ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","thaj pučen gole čherutne: ‘O učitelji pučol ane savi soba šaj xal i Pasha pe sikadencar?’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Vov ka sikavol tumenđe bari upruni soba savi si postavimi. Gothe sa pripremin.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","O Jovane thaj o Petar đele ano foro i arakhlje sa sar so vaćarda lenđe o Isus thaj gothe sa pripremisade o pashalno xape. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kana avilo o sato, bešlo o Isus ko astali pe dešuduje (12) apostolurencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Thaj o Isus phenda lenđe: “But mangljem te xav kaja Pasha tumencar angleder so ka avav mudardo. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Golese vaćarav tumenđe kaj od akana ni ka xav i Pasha dok ni pherdol ano Carstvo e Devleso.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Pale gova lija o tahtaj e moljasa, dija hvala e Devlese thaj vaćarda: “Len kaja mol thaj ulaven la maškare tumende. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Vaćarav tumenđe, od akana ni ka pijav mol sa dok ni avol o Carstvo e Devleso.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Pale gova lija o mangro, dija hvala e Devlese, phaglja le thaj ulada le e sikadenđe vaćarindoj: “Kava si mingro telo savo dol pe tumenđe. Kava ćeren te den tumen gođi mandar.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","A palo xape lija o tahtaj e moljasa thaj vaćarda: “Kava tahtaj si nevo savez ane mingro rat savo čhordol tumenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","A akh, mingro izdajniko bešol mancar kate ko astali. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Thaj me, o Čhavo e manušeso, mora te merav sar so si phendo, al pharo e manušese savo ka izdol man!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Thaj e sikade lije maškar peste te pučen pe ko lendar bi ćerola gova. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","E sikade lije te ćeren čingara maškare peste ko lendar si embaro. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","O Isus vaćarda lenđe: “E carura tare kava sveto vladin pire manušencar thaj isi len vlast pe lende. Von korkore pese vaćaren kaj si ‘manuša save but den šukaripe’. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Al tumen ma ćeren gijate! Nego ko si tumendar embaro te avol emcikno, thaj ko vladil nek avol kova savo služil. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Golese kaj ko si embaro? Kova savo bešol ko astali il savo služil? Naj li kova savo bešol ko astali? Al me sem maškar tumende kova savo služil. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Tumen sen gola save ačhile mancar ane mingre iskušenjura. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Me ačhavav tumenđe o carstvo sar so mingro Dad ačhada manđe ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","te xan thaj te pijen ke mingro astali ane mingro carstvo thaj te bešen ko tron thaj te sudin e dešuduje (12) plemenuren e Izraelese.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","O Isus vaćarda: “Simone! Simone! Akh, o Satana manđol te sejil tumen sar so sejil pe o điv. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Al me molisaljem tuće ćiro pačajipe ma te ačhol. A kana ka iri tut ke mande, te zurave ćire phralen!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","O Petar phenda lese: “Gospode! Spremno sem ano phanglipe thaj ano meripe tusa te džav!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Al o Isus vaćarda lese: “Vaćarav tuće, Petre! Ađive ni ka đilabol o bašno dok tu trin droma ni vaćare kaj ni pindžare man.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Tegani vaćarda lenđe: “Kana bičhaldem tumen bize kese parencar thaj bize traste thaj bizo pođipe, so falisada tumenđe?” Von phende: “Khanči.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","O Isus vaćarda lenđe: “Al akana kas isi kesa e parencar, nek lol la! Gijate i piri trasta! A kas naj mačo nek biknol pe šeja thaj nek ćinol pese. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Golese vaćarav tumenđe kaj trubul te pherdol kova so si pisimo mandar ano Sveto lil: ‘Dikhlje le sar jekhe tare kola save phađen o zakon.’ Golese ka avol čače sa so sasa pisimo mandar.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Al e sikade phende: “Gospode! Akh, isi amen duj mačura.” O Isus vaćarda lenđe: “Dosta si!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Iklindoj gothar, pale piro adeti, đelo o Isus ko Maslinsko brego. Lese sikade đele pale leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Kana resle, o Isus vaćarda lenđe: “Molin tumen te ma peren ano iskušenje!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Pale gova crdija pe lendar gaći kobor šaj te čhudol pe o bar thaj pelo ke pe koča thaj molisajlo e Devlese: ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Dade! Te mangljan le mandar te ma pijav kava tahtaj tari patnja. Al nek avol sar tu so manđe, a na sar so me mangav.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tegani sikadilo lese o anđelo taro nebo thaj zurada le. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","A kana dolda le bari muka, but pozurale molisajlo, a leso znoj sasa sar kaplje taro rat save perena ki phuv. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Pali molitva uštilo thaj avilo ke pe sikade thaj arakhlja len sar soven taro pharipe kobor sasa lenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","O Isus pučlja len: “Sose soven? Ušten, molin tumen e Devlese te ma peren ano iskušenje!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Dok o Isus vaćarda, e manuša thaj o Juda, jekh tare dešuduj (12) sikade, avena premal leste. O Juda avilo pašo Isus thaj čumidija le. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","O Isus pučlja le: “Judo! Čumidimasa li izdaji, man, e Čhave e manušese?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kana e sikade dikhlje so ćerdol, vaćarde: “Gospode! Te mara amen e mačurencar?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Thaj jekh lendar čalada e bare sveštenikose sluga thaj čhinda leso desno kan. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Al o Isus vaćarda: “Mučhen len! Dosta!” A dolda leso kan thaj sastarda le. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Tegani o Isus vaćarda e manušenđe so avile pale leste, e šorutne sveštenikurenđe, e zapovednikurenđe e hramese thaj e starešinenđe: “Aviljen pale mande sar palo razbojniko, čhurencar thaj kaštencar te dolen man! ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Sose ni dolden man dok sema ano Hram? Svako đive sema tumencar odori. Al akana si tumaro sato – kana vladil o kalipe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Kana dolde e Isuse, inđarde le ano čher e bare sveštenikoso. O Petar odural đelo pale lende. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","E stražara phabarde jag ani avlin thaj bešle savore katane. Thaj o Petar bešlo lencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Dikhlja le jekh sluškinja sar bešol paši jag thaj dikhlja premal leste thaj vaćarda: “Kava sasa lesa!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Al o Petar xoxada vaćarindoj: “Džuvlije! Me ni pindžarav le!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Nekobor pale gova pindžarda le aver thaj vaćarda: “Tu san jekh lendar!” Al o Petar phenda: “Manušeja, naj sem!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Thaj kana nakhlo paše jekh sato, nesavo manuš uporno vaćarda taro Petar: “Čače thaj kava manuš sasa lesa golese kaj si Galilejco!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Al o Petar vaćarda: “Manušeja! Ni džanav so tu phene!” Thaj sigate dok vov vaćarda, o bašno đilabija. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Tegani irisajlo o Gospod thaj dikhlja e Petre, a o Petar dija pe gođi so vaćarda lese o Gospod: “Ađive, angleder so o bašno ka đilabol, trin droma ka vaćare kaj ni pindžare man.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","O Petar iklilo avral thaj zurale ruja. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","A e čuvara lije te maren e Isuse thaj te maren lesa muj. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Učharde lese jakha thaj pučlje le: “Prorokuji, ko čalada tut?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Thaj but avera bilačhe lafura vaćarde lestar. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kana sasa sabalin, ćidije pe e manušenđe starešine, e šorutne sveštenikura thaj e učitelja tare Mojsijaso zakon. Ande e Isuse anglo Baro sudo ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","vaćarindoj: “Tu li san o Hrist? Vaćar amenđe gova!” O Isus phenda lenđe: “Te vaćardem tumenđe, ni ka pačan man. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Te pučljem tumen khanči, ni ka phenen manđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Al od akana me, o Čhavo e manušeso, ka bešav ki desno rig ko počasno than e Zurale Devlese.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Pe gova savore pučlje: “Tu li san, čače, o Čhavo e Devleso?” O Isus phenda: “Gija si sar tumen vaćaren. Me sem.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Tegani von vaćarde: “So trubul amen pobut dokazura? Golese kaj korkore amen šundam tare leso muj!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tegani sa e manuša save sesa ano Baro sudo, uštile thaj inđarde e Isuse ko Pilat, savo sasa o rimsko upravnikо. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Gothe lije te tužin e Isuse: “Arakhljam kale manuše sar xoxavol amare manušen thaj phenol lenđe ma te poćinen o porezi е carose, a pese vaćarol kaj si o Hrist, caro.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","O Pilat pučlja le: “Tu li san o caro e Jevrejengo?” O Isus phenda lese: “Gija si sar so tu vaćare.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Tegani o Pilat vaćarda e šorutne sveštenikurenđe thaj e manušenđe: “Me ni arakhav nisavo banđipe ane kava manuš.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Al von dije zor vaćarindoj: “Vov pe sikajimasa bunil e manušen ki sa i phuv Judeja. Počnisada ki Galileja thaj avilo sa dži kate ano Jerusalim!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Kana gova šunda o Pilat, pučlja: “Vov li si tari Galileja?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Thaj kana šunda o Pilat kaj si o Isus tari Galileja, bičhalda le ko Irod, savo vladisada ani Galileja. O Irod sasa ane gola đivesa ano Jerusalim. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Kana dikhlja o Irod e Isuse, sasa but radujimo, golese kaj odavno manglja te dičhol le, golese kaj but šunda lestar thaj dija gođi kaj o Isus ka ćerol nesavo čudo angle leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","O Irod pučlja baše but buća, al o Isus khanči ni phenda lese. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ačhile gothe i e šorutne sveštenikura thaj e učitelja tare Mojsijaso zakon thaj von zurale vaćarde protiv o Isus. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","O Irod thaj lese vojnikura ladžarde le thaj asaje e Isusese. Urade le ano carsko fostano thaj bičhalde le palal ko Pilat. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ane gova đive mirisajle o Pilat thaj o Irodo maškare peste, golese kaj angleder golestar sesa dušmanura. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","O Pilat ćidija e šorutne sveštenikuren, e manušenđe starešinen thaj e manušen ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","thaj vaćarda: “Anden manđe kale manuše thaj phenen kaj e manušen bunil. Ake, me angle tumende pučljem le thaj ni arakhljem ni jekh banđipe so tumen čhuven pe leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ni o Irod ni arakhlja banđipe pe leste, golese kaj bičhalda le palal amende. Ake, ni ćerda khanči sosa bi zaslužila te avol mudardo. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Golese ka šibi le thaj ka mukha le.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Dži jekh berš ko prazniko, o Pilat trubuja te mučhol lenđe jekhe phangle manuše. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Tegani sa e manuša dije vika vaćarindoj: “Mudar akale a mukh amenđe e Varava!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(O Varava sasa čhudimo ano phanglipe baši pobuna thaj bašo mudaripe.) ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","O Pilat vadži jekh drom vaćarda lenđe kaj vov bi mučhola e Isuse. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Al von dije vika: “Čhuv le ko krsto! Čhuv le ko krsto!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Tegani o Pilat trito drom vaćarda lenđe: “Savo bilačhipe vov ćerda? Me ni dikhav khanči sosa bi zaslužila te avol mudardo. Gija ka šibiv le thaj ka mukhav le.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Al e manuša ni ačhile te vazden piro glaso thaj manglje taro Pilat te čhuvol e Isuse ko krsto. I lenđi vika sasa pozurali thaj pozurali. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Golese o Pilat odlučisada te ćerol sar so e manuša manđen. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Tegani mukhlja e Varava, savo sasa ano phanglipe baši pobuna thaj bašo mudaripe, a e Isuse dija e vojnikurenđe te ćeren lesa kova so e manuša manglje. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Kana inđarde e vojnikura e Isuse, dolde nesave Simone taro foro Kirina savo avola taro polje, thaj čhute pe leste o krsto te inđarol le palo Isus. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Palo Isus đele pherdo manuša thaj džuvlja save ruje thaj žalisade le. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","O Isus irisajlo premal lende thaj vaćarda: “Čhejalen taro Jerusalim! Ma roven pale mande. Nego, roven pale tumende thaj pale tumare čhave. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Golese kaj dikh, aven e đivesa ane save ka vaćaren: ‘Blagoslovime kola džuvlja save našti bijanen, blagoslovime e vođa save ni bijande, thaj blagoslovime e čuča save ni parvarde!’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Tegani ‘ka vaćaren e planinenđe: “Peren pe amende!”, thaj e bregurenđe: “Učharen amen!”’ ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Golese kaj, ako kava e manuša ćeren e zelenone kaštesa, so ka avol e šuće kaštesa?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Katane e Isusesa inđarde duje bilačhe manušen te aven mudarde. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kana avile ke kova than savo akhardola “Kokalo e šoreso”, gothe čhute ko krsto e Isuse thaj lesa i e duje bilačhe manušen, jekhe tari lesi desno rig a avere tari levo rig. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Tegani o Isus vaćarda: “Dade! Oprosti lenđe, golese kaj ni džanen so ćeren.” Pale gova e vojnikura čhudije i kocka te ulaven maškar peste leso fostano. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","But manuša gothe ačhile thaj dikhlje sa gova, a e manušenđe šorutne marde muj lesa vaćarindoj: “Averen spasisada, nek spasil akana korkoro pes, te si vov o Hrist, birimo e Devleso.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","I e vojnikura marde muj lesa. Avile paše leste thaj manglje te den le te pijol šut. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Thaj vaćarde e Isusese: “Te san tu caro e Jevrejengo, spasi korkoro tut!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","A sasa upreder leste ploča pe savi sesa pisime kala lafura: “Kava si caro e Jevrejengo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jekh tare gola bilačhe manuša savo sasa ko krsto pašo Isuse, marda muj thaj vaćarda lese: “Te san tu o Hrist, spasi tut thaj amen!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Al taro aver krsto o dujto manuš dija vika pe leste vaćarindoj: “Tu li ni dara taro Dol? Kana san i tu korkoro gija osudimo. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Amen sam čače osudime golese so gova zaslužisadam, al vov ni ćerda khanči bilačhe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Tegani vaćarda e Isusese: “Isuse, kana ka rese ane ćo carstvo, de tut gođi pe mande thaj av manđe milostivno.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Pe gova phenda lese o Isus: “Čače vaćarav tuće: ađive ka ave mancar ano raj!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Sasa popodne kana peli i rat ki sa i phuv dži ke trin popodne, ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","golese so kalilo o kham. A i hramsko zavesa pharadili ke opaš. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Tegani o Isus dija vika andare sa o glaso: “Dade! Ane ćire vasta mukhav mingro duxo.” Kana kava phenda, mulo. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Kana dikhlja o kapetano so sasa, lija te hvalil e Devle thaj vaćarda: “Čače kava manuš sasa čačukano pravedno manuš!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kana sa e manuša ćidije pe te dičhen kava thaj dikhlje so sasa, lije te džan pese thaj marde pe ane pe kolina tari žal. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Sa kola so džanglje e Isuse, ačhile podur. Thaj e džuvlja so avile lesa tari Galileja, dikhlje kava. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Sasa jekh manuš kaso alav sasa Josif, savo sasa jekh tare šorutne e jevrejenđe. Sasa šukar thaj pravedno manuš ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","tari Arimateja, foro ani Judeja. Vov ni složisajlo golesa so ćerde e Isusese, thaj ađućarda o Carstvo e Devleso. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Đelo ko Pilat thaj rodija o telo e Isuseso. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pale gova o Josif uljarda e Isuseso telo taro krsto, paćarda le čaršafesa thaj čhuta le ano limori savo sasa hundo ani stena thaj ane savo vadži khoni ni sasa čhuto. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ćerda gova jekh đive anglo savato, savo samo so ni avilo. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","E džuvlja save avile e Isusesa andari Galileja, đele palo Josif i dikhlje o limori thaj sar čhute gothe e Isuseso telo. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Pale gova irisajle čhere te ćeren e mirisna čara thaj e uljura te mačhen e Isuseso telo. Kana sa spremisade, već avilo o savato i naštine te ćeren gova golese kaj poštujina e Mojsijaso zakon. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ko angluno đive palo savato, rano sabalin avile e džuvlja ko limori thaj ande mirisura save ćerde. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Arakhlje o bar crdimo taro limori. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Dije andre thaj ni arakhlje o telo e Gospodeso e Isuseso. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Dok pučlje pe so sasa gova, dikh, duj manuša ačhile angle lende ane sjajna fostanura. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","E džuvlja but darajle thaj perade pe šore tele dži ki phuv. Thaj e duj manuša pučlje e džuvljen: “Sose roden e džuvde maškar e mule? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Naj kate. Uštilo tare mule! Den tumen gođi so vaćarda tumenđe dok vadži sasa ani Galileja: ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Me, o Čhavo e manušeso, trubul te avav dindo ane vasta e grešnone manušenđe thaj te avav čhuto ko krsto, al o trito đive ka uštav tare mule.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Tegani dije pe gođi so vaćarda lenđe o Isus. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Thaj irisajle taro limori thaj vaćarde sa e dešujekhe (11) apostolurenđe thaj savorenđe averenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Gola džuvlja sesa i Marija taro foro Magdala, i Jovana, i Marija e Jakovesi dej thaj avera save vaćarde kava e apostolurenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Al e apostolurenđe kala lafura sesa sar dilipe thaj ni pačaje e džuvljenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Al o Petar uštilo thaj prastaja dži ko limori. Kana telilo, dikhlja samo o čaršafi savo ačhilo. Đelo thaj čudisajlo ane peste so sasa gova. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ane gova đive duj e Isusese sikade đele ano gav savo akhardola Emaus thaj vov sasa dur taro Jerusalim dešujekh (11) kilometra. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Phirindoj vaćarde maškar peste tare sa kova so sasa. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Thaj dok vaćarde maškar peste thaj pučlje khanči jekh avere, korkoro o Isus avilo paše lende thaj đelo lencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Al lenđe jakhenđe ni sasa mukhlo te pindžaren le. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","O Isus pučlja len: “Sostar gova vaćaren maškar tumende phirindoj?” Ačhile i tužnisajle ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","thaj jekh lendar savo akhardola o Kleopa, vaćarda e Isusese: “Tu li san jedino abandžija ano Jerusalim savo ni šunda so sasa kala đivesa odori?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","O Isus pučlja len: “So sasa gova?” Von phende lese: “Gova so ćerdilo e Isusesa taro Nazaret. Vov sasa proroko, zuralo ano vaćaripe thaj ane buća anglo Dol thaj angle manuša. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Amare šorutne sveštenikura thaj e starešine dije le te avol osudimo ko meripe thaj čhute le ko krsto. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Amen nadisaljam kaj vov ka ikalol o Izrael. Al ađive si gova već trito đive sar sasa sa gova. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Nesave džuvlja maškar amende bunisade amen. Sabalje sesa ko limori, ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","al ni arakhlje e Isuseso telo odori. Avile thaj phende amenđe kaj dikhlje e anđeluren save phende lenđe kaj si o Isus džuvdo. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Tegani nesave amendar đele ko limori thaj dikhlje kaj si o limori čučo, sar so vaćarde e džuvlja, al ni dikhlje e Isuse.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","O Isus vaćarda lenđe: “O bigođaće manušalen! Pharo tumenđe te pačan so vaćarde e prorokura ano Sveto lil! ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ni li von vaćarde kaj o Hrist trubul te načhol sa gova pharipe angleder so o Dol ka proslavil le?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Tegani o Isus lija te objasnil lenđe so si ano Sveto lil pisimo taro Hrist, počnindoj taro Mojsije dži ke Prorokura. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kana avile pašo gav ane savo đele, o Isus ćerda pe kaj manđol te džal podur lendar. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Al von dije le zor te ačhol, vaćarindoj: “Ačh amencar! Nakhlo o đive thaj i rat lija te perol!” Ačhilo thaj dija lencar ano čher. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kana sasa lencar ko astali, o Isus lija o mangro, zahvalisada thaj phaglja le thaj dija len. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tegani lenđe jakha putajle thaj pindžarde le. Al vov sigate hasajlo. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Tegani phende jekh averese: “Ni li phabile amare ile kana o Isus phirindoj vaćarda amenđe ko drom thaj kana objasnisada amenđe o Sveto lil?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Uštile vadži ane gova sato thaj irisajle ano Jerusalim. Odori arakhlje e dešujekhe (11) sikaden thaj kolen save sesa lencar, sar bešen katane. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","E dešujekh (11) sikade vaćarde lenđe: “Čače uštilo o Gospod thaj sikada pe e Simonese!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Thaj kala duj sikade so sesa ko drom pašo Emaus vaćarde so sasa thaj sar pindžarde e Isuse kana phaglja o mangro. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kana gova vaćarde, o Isus tare jekh drom ačhilo maškare lende thaj vaćarda lenđe: “Mir tumenđe!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Von darajle thaj sesa bunime golese kaj dije gođi kaj dičhen duxo. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Vov vaćarda lenđe: “Sose daran? Thaj sose ni pačan? ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Dičhen mingre vasta thaj mingre pingre! Me sem gova! Dolen man thaj ka dičhen! Golese kaj e duxo naj telo thaj kokala, a sar so dičhen man isi!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Thaj dok vaćarola sa gova, sikada lenđe ožiljkura ke pe vasta thaj ke pe pingre. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Sesa gija začudime thaj radosna kaj naštine te pačan. Vov pučlja len: “Isi li tumen khanči xamase?” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Von dije le kotor peće mačhe. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","O Isus lija thaj xalja angle lende. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Tegani lenđe o Isus vaćarda: “Kava si kova sostar vaćardem tumenđe kana sema tumencar, kaj trubul te avol sa so pisimo mandar ane Mojsijaso zakon thaj ane lila save pisisade e prorokura thaj ane Psalmura.” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Tegani putarda lenđe jakha te haljaren o Sveto lil ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","thaj vaćarda lenđe: “Gija si pisimo ano Sveto lil, kaj o Hrist trubul te mudardol thaj te uštol tare mule ko trito đive. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Thaj ane leso alav ka propovedil pe sa e manušenđe, počnindoj taro Jerusalim, kaj trubul te pokajin pe te bi o Dol oprostila lenđe grehura. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","A tumen sen svedokura tare sa kava. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Thaj dikh, me ka bičhalav o Sveto Duxo pe tumende sar so obećisada mingro Dad. Al tumen ačhen ano foro Jerusalim sa dok o Dol ni ka bičhalol piri zor pe tumende!” ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Pale gova o Isus inđarda len dži ko gav i Vitanija. Gothe vazdija pe vasta thaj blagoslovisada len. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Thaj sar blagoslovisada len, lija te crdol pe lendar thaj sasa vazdimo ano nebo. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Von pele ke koča anglo Isus. Tegani irisajle ano Jerusalim radosna. ");
INSERT INTO rmyGurbet_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Stalno sesa ano Hram thaj slavisade e Devle.");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ko anglunipe sasa o Lafi, thaj o Lafi sasa e Dеvlesa, thaj o Lafi sasa o Dol. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Vov sasa e Devlesa ko anglunipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Sa sasa stvorimo prekale leste thaj ni postojil khanči so sasa stvorimo bize leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ane leste sasa o džuvdipe, thaj o džuvdipe sasa o svetlo e manušenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","O svetlo svetlil ano kalipe thaj o kalipe našti nadvladil o svetlo. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Sasa manuš kas bičhalda o Dol. Leso alav sasa Jovan savo krstila. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Avilo sar svedoko, te svedočil pašo Svetlo, prekale leste savore te pačan. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","O Jovane korkoro ni sasa svetlo, nego avilo te svedočil taro Svetlo. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","O čačukano Svetlo avilo ko sveto thaj svetlil svakone manuše. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Vov sasa ko sveto, o sveto sasa stvorimo prekale leste, al o sveto ni pindžarda le. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Avilo ano sveto savo sasa leso, al lese manuša ni prihvatisade le. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","A dija pravo savoren kolen save prihvatisade le, save pačan ane leso alav, te aven e čhave e Devlese. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Gasave ni bijandile taro prirodno bijandipe, ni tari požuda e telosi, ni taro manglipe e manušeso, samo taro Dol. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","O Lafi ćerdilo manuš thaj bešlo maškar amende. Dikhljam lesi slava, savi isi le, sar jekhbijando Čhavo savo avilo taro Dad, a vov si pherdo milost thaj čačipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","O Jovane o Krstitelj svedočisada lestar thaj dija vika: “Kava si gova savestar vaćardem: ‘Kova savo pale mande avol, po baro si mandar, golese kaj sasa angleder mande!’” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Vov si pherdo milost thaj čačipe thaj lestar primisadam blagoslov palo blagoslov. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Golese, o Zakon dija pe prekalo Mojsije thaj e Devleso milost thaj o čačipe avile prekalo Isus Hrist. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Khoni nikad ni dikhlja e Devle, al o jekhbijando Čhavo savo si i korkoro Dol, savo si e Dadese empaše, sikada le amenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Kava sasa e Jovaneso svedočanstvo kana e Jevreja taro Jerusalim bičhalde e sveštenikuren thaj e Levituren te pučen e Jovane: “Ko san tu?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","O Jovane phenda putarde, ni garada khanči, al priznajisada: “Me naj sem o Hrist.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Gija pučlje le: “Pa ko san onda? Naj li san o proroko o Ilija?” A vov phenda: “Naj sem.” “Tu li san kova Proroko save ađućara?” O Jovane vaćarda: “Na.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Tegani pučlje le: “Pa ko san tu? Te šaj vaćara gova kolenđe so bičhalde amen. So šaj vaćare korkoro tutar?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","O Jovane vaćarda lenđe gija sar so pisisada o proroko o Isaija: “Me sem ‘glaso so dol vika ani pustinja: Ravnin o drom e Gospodese!’” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","A nesave tare bičhalde sesa fariseja. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Von pučlje le: “Kana naj san o Hrist, ni o Ilija, ni kova Proroko save ađućara, sose onda krsti?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","O Jovane vaćarda lenđe: “Me krstiv pajesa, al maškare tumende ačhol kova kas tumen ni pindžaren. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Vov avol pale mande, al me naj sem dostojno ni te putrav e dora tar lese sandale.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Kava sasa ani Vitanija, ki istočno rig tari len o Jordan, kaj o Jovane krstila e manušen. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Theara đive o Jovane dikhlja e Isuse sar avol premal leste thaj vaćarda: “Dičhen, e Devlese Bakrore! Vov crdol e grehura kale svetose! ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Gova si kova kastar me vaćardem: ‘Pale mande avol manuš savo si po baro mandar golese kaj sasa angleder mande!’ ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Me ni pindžardem le, al me aviljem thaj krstiv pajesa, te bi e manuša taro Izrael šajine te dičhen ko si vov.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Tegani o Jovane svedočisada vaćarindoj: “Dikhljem o Sveto Duxo sar avol tele taro nebo sar golubo thaj ačhilo pe leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Me ni pindžardem le, al o Dol so bičhalda man te krstiv pajesa vaćarda manđe: ‘Kana dičhe e manuše pe kaste perol thaj ačhol o Sveto Duxo, te džane kaj gova si manuš savo ka krstil e Svetone Duxosa.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Thaj me gova dikhljem thaj golese svedočiv kaj kava si o Čhavo e Devleso.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Theara đive palem sasa odori o Jovane pe duje sikadencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Kana dikhlje e Isuse kaj načhol gothar o Jovane vaćarda: “Dičhen, e Devlese Bakrore!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Kana šunde e duj sikade e Jovanese so phenda o Jovane, đele palo Isus. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","O Isus irindoj dikhlja kaj aven pale leste thaj pučlja len: “So manđen?” Von vaćarde lese: “Rabbi” (so si: Učitelju), “kaj beše?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","O Isus phenda lenđe: “Aven thaj ka dičhen.” Gija đele dikhlje kaj bešol thaj gova đive ačhile lesa. Sasa paše štar o sato ko đive. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jekh tare kala duj, save šunde e Jovanese lafura thaj đelo palo Isus, sasa o Andrija, o phral e Simoneso e Petreso. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Vov sigate rodija pe phrale e Simone thaj vaćarda lese: “Amen arakhljam e Mesija” (so značil o Hrist). ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","O Andrija anda e Simone ko Isus. Thaj o Isus dikhlja pe leste thaj vaćarda: “Tu san o Simon, a ćo dad akhardol Jovan. Tu ka akhardo Kifa” (so značil Petar, “baro bar”). ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Theara đive o Isus odlučisada te džal ki regija i Galileja. Arakhlja e Filipe thaj vaćarda lese: “Phir pale mande!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","O Filip sasa tari Vitsaida, taro foro e Andrijaso thaj e Petreso. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","O Filip arakhlja e Natanaile thaj vaćarda lese: “Arakhljam kole kastar pisisade o Mojsija ano Zakon thaj e Prorokura – e Isuse, e Josifese čhave, taro foro Nazaret.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Tegani o Natanail pučlja le: “Šaj li avol khanči šukar taro Nazaret?” O Filip vaćarda lese: “Av thaj dikh!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Kana o Isus dikhlja e Natanailo sar avol premal leste, vaćarda lestar: “Akh čačukano Izraelco, ane savo naj prevara!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Pučlja le o Natanailo: “Kotar pindžare ma?” O Isus vaćarda lese: “Angleder so o Filip akharda tut, dikhljem sar beše tali smokva.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Tegani o Natanailo phenda lese: “Rabbi! Tu san Čhavo e Devleso! Tu san o caro e Izraeleso!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","O Isus pučlja le: “Pača golese so vaćardem tuće kaj dikhljem tut tali smokva? Ka dičhe po bare buća tare kava.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Pale gova o Isus vadži vaćarda: “Čače, čače vaćarav tumenđe: ka dičhen o nebo putardo thaj e Devlese anđeluren sar ušten thaj uljen po Čhavo e Manušeso.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ko trito đive sasa abav ano gav savo akhardol Kana ani Galileja. Gothe sasa thaj e Isusesi dej. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ko abav sesa akharde o Isus thaj lese sikade. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Kana ni ačhili mol, e Isusesi dej vaćarda lese: “Naj len mol.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","O Isus vaćarda laće: “So isi man golesa, džuvlije? Mingro vreme vadži ni avilo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Lesi dej vaćarda e slugenđe: “Ćeren sa so vaćarol tumenđe!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Gothe sesa šov bare barale khore. E Jevrejenđe sesa gola khore paše jevrejska adetura e thodimase thaj ane dži jekh khoro šajine te ačhol ohtovardeš (80) dži ke šelubiš (120) litra paj. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","O Isus vaćarda e slugenđe: “Pheren e khore pajesa!” Gija pherde len dži upre. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Pale gova vaćarda lenđe: “Akana len thaj inđaren e glavnone trpezarese.” Von ćerde gija. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","O trpezari pilja o paj savo ćerdilo mol. Vov ni džanglja kotar si, al e sluge so ande gova paj džanglje. Tegani akharda o trpezari e mladoženja ");
INSERT INTO rmyGurbet_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","thaj vaćarda lese: “Sa e manuša angleder anen i lačhi mol ko abav, a kana e gostura maton, anol i bilačhi mol. Al tu garadan i lačhi mol dži akana.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Gija, ani Kana i Galilejsko, ćerda o Isus piro angluno čudesno znako thaj sikada pi slava thaj lese sikade pačaje ane leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Pale gova đelo o Isus pe dasa, pe phralencar thaj pe sikadencar ano foro Kafarnaum. Gothe ačhile nekobor đive. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Paše sasa o vreme taro prazniko e Jevrejengo – Pasha thaj o Isus đelo ano Jerusalim. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ane Hramesi avlin arakhlja kolen save bićinena guruven, bakren thaj goluburen. Arakhlja i kolen so menjina e pare, sar bešen gothe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Gija o Isus ćerda bičo tare dorika thaj sa kolen save bićinen lija te tradol andaro Hram, sa lenđe bakrencar thaj e guruvencar. E manušenđe so menjina e pare čhudija e srebrnjakura thaj irisada e astalura. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Kolenđe save bićinena goluburen vaćarda: “Inđaren gova katar! Ma ćeren pijaco taro Čher mingre Dadeso.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Thaj lese sikade dije pe gođi kaj si pisimo ano Sveto lil: “O manglipe paše ćiro čher ka phabol ane mande sar jag.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Tegani e Jevrejska šorutne pučlje e Isuse: “Savo čudesno znako ka sikave amenđe kaj tu troma kava te ćere?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","O Isus vaćarda lenđe: “Phađen kava Hram a me paše trin đive ka vazdav le.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Al e Jevreja vaćarde lese: “Kava Hram sasa ćerdo saranda thaj šov (46) berš a tu paše trin đive ka vazde le?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Al o Hram savestar vaćarda o Isus, sasa leso telo. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kana uštilo tare mule, dije pe gođi lese sikade kaj gova phenda thaj pačaje ano Sveto lil thaj ane lafura so o Isus vaćarda. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","A dži kaj sasa ano Jerusalim ko prazniko e Jevrejengo – Pasha, but manuša dikhlje e čudesna znakura save ćerda thaj pačaje ane leso alav. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Al korkoro o Isus ni pačaja lenđe, golese kaj pindžarda sa e manušen. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ni trubuja te vaćarol lese khoni pašo manuš, golese kaj korkoro džanglja so si ano manuš. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Maškare fariseja sasa jekh manuš, savo akhardola Nikodim. Vov sasa jekh tare šorutne e Jevrejenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Jekh rat avilo ko Isus thaj phenda: “Rabbi! Amen džana kaj san tu učitelji bičhaldo taro Dol, golese kaj khoni našti ćerol gasave čudesna znakura save tu ćere, a te naj o Dol lesa.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","O Isus phenda lese: “Čače, čače vaćarav tuće: khoni našti avol ano Carstvo e Devleso, ako ni bijandol palem.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","O Nikodim pučlja le: “Sar šaj manuš bijandol ako si purano? Šaj li dujto drom te džal ane pe dako vođi thaj te bijandol?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","O Isus vaćarda lese: “Čače, čače vaćarav tuće: te o manuš ni bijandilo pajesa thaj Duxosa, našti džal ano Carstvo e Devleso! ");
INSERT INTO rmyGurbet_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Kova so si bijando taro manuš, manuš si, a so si bijando taro Duxo, duxo si. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ma čudi tut so vaćarav tuće kaj trubul palem te bijandon. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","I balval phurdol kaj manđol. Šaj šune la, al ni džane kotar avol ni kaj džal. Gija si kolesa kas o Duxo bijanol.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","O Nikodim pučlja le: “Sar šaj gova te avol?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","O Isus vaćarda lese: “Tu san poštujimo učitelji e Izraeleso a gova ni džane? ");
INSERT INTO rmyGurbet_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Čače, čače vaćarav tuće: amen vaćara tare kova so džana thaj svedoči za kova so dikhljam, al tumen ni prihvatin amaro svedočanstvo. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Te ni pačajen man kana vaćarav tumenđe tare kova so ćerol pe ki phuv, sar ka pačan man te vaćardem tumenđe tare kova so ćerol pe ko nebo? ");
INSERT INTO rmyGurbet_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Khoni ni uštilo ko nebo thaj irisajlo ki phuv, sem o Čhavo e Manušeso, kova savo ulilo taro nebo. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Thaj sar o Mojsije so vazdija e sape tari bronza ki pustinja, gija o Čhavo e Manušeso trubul te avol vazdimo ");
INSERT INTO rmyGurbet_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","te šaj dži jekh savo pačal ane mande te avol le džuvdipe bizo meripe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Golese kaj, o Dol gaći manglja o sveto kaj dija pe jekhebijande Čhave te ma bi merola khoni savo pačal ane leste, nego te avol le džuvdipe bizo meripe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","O Dol ni bičhalda ko sveto pe Čhave te sudil o sveto, nego o sveto prekale leste te spasil pe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ko ane leste pačal, naj osudimo, a ko ni pačal već si osudimo, golese kaj ni pačaja ano alav e Devlese jekhebijande Čhaveso. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","A osudime si paše kava: o svetlo avilo ko sveto, al e manuša manglje o kalipe, a na o svetlo, golese kaj lenđe buća sesa bilačhe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Dži jekh savo ćerol bilačhipe, mrzil o svetlo thaj ni džal ko svetlo te ma pučardon lese buća. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Al savo ćerol kova so si čačukanipe, džal ko svetlo te dičhol pe kaj lese buća si ćerde ano sklad e Devlesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Pale gova đelo o Isus pe sikadencar ane Judejska gava. Odori sasa lencar thaj krstisada. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","A i o Jovane krstisada ano than Enon pašo gav Salim, golese kaj sasa gothe but paja. E manuša avena ke leste te krstil len. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Gova sasa angleder so e Jovane čhute ano phanglipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Tegani maškare sikade e Jovanese sasa aver Jevrejo savesa lije te ćeren čingara pašo adeti e thodimaso. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","E sikade avile ko Jovane thaj vaćarde lese: “Rabbi, kova so sasa tusa ki istočno rig e Jordanesi thaj kastar tu svedočisadan, dikh, krstil thaj savore džan leste.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","O Jovane vaćarda lenđe: “O manuš našti te lol khanči ako naj lese gova dindo taro Dol savo si ko nebo. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Korkore sen svedokura kaj vaćardem: ‘Me naj sem o Hrist, nego sem bičhaldo angle leste.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ko abav samo o mladoženja ženil pe. A e mladoženjaso amal savo ađućarol te šunol kaj avol o mladoženja, pherdo si radost kana šunol e mladoženjaso glaso. Golese gova radost si mingro thaj akana si pherdo. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Vov trubul pobut te barol, a me sa pobut te ciknjivav.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Kova savo avol odupral taro nebo, pe savorende si. Kova savo si tari phuv, phuvako si thaj vaćarol sar khoni tari phuv. Kova savo avol taro nebo, pe savorende si. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Vov svedočil paše kova so dikhlja thaj so šunda, al khoni ni prihvatil leso svedočanstvo. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","A ko prihvatil leso svedočanstvo, potvrdil kaj si o Dol čačukano. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kova kas bičhalda o Dol, vaćarol e Devlese lafura, golese kaj o Dol dol po Duxo ano izobilje. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","O Dad manđol e Čhave thaj sa dija le ane vasta. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ko pačal ano Čhavo, isi le džuvdipe bizo meripe. Al ko ni šunol e Čhave, ni ka dičhol o džuvdipe, nego i holi e Devlesi ačhol pe leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Kana o Isus dodžanglja kaj e fariseja šunde so vov pridobil thaj krstil pobut sikaden nego o Jovane ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","– iako o Isus korkoro ni krstila, nego lese sikade gova ćerena – ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","đelo andari phuv i Judeja thaj irisajlo ani phuv i Galileja. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ko drom trubuja te načhol tari Samarija. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Gija avilo ano samarijansko gav savo akhardola Sihar, paši phuv savi dija o Jakov pe čhavese e Josifese. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Gothe sasa o bunari e Jakoveso. O Isus čhindilo taro baro drom thaj bešlo pašo bunari. Sasa paše dešuduj (12) o sato. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Kana gothe avili jekh Samarijanka te dolol paj, o Isus vaćarda laće: “De ma te pijav!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Tegani sasa o Isus korkoro, golese kaj lese sikade đele ano gav te ćinen xamase.) ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Vaćarda e Isusese i Samarijanka: “Sar tu, savo san Jevrejo, šaj te manđe mandar tari Samarijanka te dav tut te pije paj?” Golese kaj e Jevreja naj ano amalipe e Samarijancurencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","O Isus vaćarda laće: “Kana bi samo džanesa e Devleso daro! Tu ni džane ko si kova so vaćarol tuće: ‘De ma te pijav paj!’ Te džane, tu bi mandar manđesa thaj me bi dava tut paj savo dol džuvdipe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","I džuvli phenda lese: “Gospodarona! Naj tut ni čaro te dole o paj, a o bunari si xor. Kotar ka le paj savo dol džuvdipe? ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Tu li misli kaj san po baro tare amaro paradad o Jakov savo dija amen kava bunari savestar pilja vov, lese čhave thaj lesi stoka?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","O Isus vaćarda laće: “Dži jekh savo pijol tare kava paj, palem ka trošavol. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Al ko pijol paj savo me ka dav le, ni ka avol trošalo dži kaj si džuvdo. Paj savo me ka dav le ka avol ane leste izvor e pajeso savo ka dol le džuvdipe bizo meripe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","I džuvli vaćarda lese: “Gospodarona! De ma gova paj te ma trošavav vadži ni te avav kate ko bunari te dolav paj!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","O Isus vaćarda laće: “Dža akhar ćire rome thaj iri tut akari!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Tegani vaćarda lese i romni: “Naj man rom.” Tegani phenda o Isus: “Šukar phendan kaj naj tut rom! ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Golese kaj sasa tut pandž roma thaj kova so isi tut akana naj ćiro rom. Gova so vaćardan si čače.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","I romni vaćarda lese: “Gospodarona! Dikhav kaj san proroko. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Amare paradada slavina e Devle ke kava brego. Al tumen e Jevreja vaćaren kaj ano Jerusalim si than kaj trubul te slavil pe o Dol.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","O Isus vaćarda laće: “Džuvlije! Pača man, ka avol o vreme kaj ni ka slavin e Dade na samo kate ko brego thaj na samo ano Jerusalim. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Tumen e Samarijancura ni džanen kas slavin. Amen e Jevreja džana kas slavi golese kaj o spasenje avol tare Jevreja. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Al avol o vreme kana e čačukane slavljenikura ka slavin e Dade ano Duxo thaj ano čačipe. O Dad manđol gasave pačavnen. A gova vreme već avilo. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","O Dol si Duxo thaj kola save slavin le, mora te slavin le ano Duxo thaj ano čačipe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","I džuvli phenda lese: “Džanav kaj ka avol o Mesija, savo akhardol Hrist. Kana ka avol vov, sa ka objasnil amenđe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","O Isus vaćarda laće: “Vov akana vaćarol tusa. Me sem o Mesija.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ane gova časo lese sikade irisade pe andaro foro thaj čudisajle so o Isus vaćarol e džuvljasa. Al ni jekh ni pučlja le: “So manđe latar?”, il “Sose vaćare lasa?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Tegani i džuvli ačhada gothe po khoro, irisajli ano gav thaj vaćarda e manušenđe: ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Aven te dičhen e manuše savo manđe vaćarda sa so ćerdem. Šaj si vov o Hrist?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Gija e manuša avile andaro gav thaj đele te dičhen e Isuse. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ane gova vreme e sikade molisade e Isuse: “Rabbi! Xa khanči!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Al vov phenda lenđe: “Man isi xape savestar tumen ni džanen.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Tegani e sikade vaćarde maškare peste: “Te ni anda lese khoni khanči xamase?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","A o Isus vaćarda lenđe: “Mingro xape si te ćerav so si volja kolesi savo bičhalda man thaj te dovršiv lesi bući. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Na li vaćaren kana sejin: ‘Vadži štar čhon thaj ka avol o ćidipe?’ Al me phenav tumenđe, putren tumare jakha thaj dičhen e poljura resle ćidimase. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Kova savo ćidol već prihvatil plata thaj ćidol o bijandipe pašo džuvdipe bizo meripe, te šaj radujin pe katane kova so sejil thaj kova so ćidol. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Gija čače avol i poslovica: ‘Jekh sejil, dujto ćidol.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Me bičhalav tumen te ćiden kaj ni ćerden bući. Avera trudisajle, a tumen ćidijen o bijandipe tari lenđi bući.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","But Samarijancura tare gova foro pačaje ane leste zbog o lafi e džuvljako savi phenda o svedočanstvo: “Vaćarda manđe sa so ćerdem.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Kana avile e Samarijancura paše leste, molisade le te ačhol lencar. Thaj vov ačhilo gothe duj đive. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Tegani vadži pobut manuša pačaje zbog lese lafura. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Vaćarde e džuvljaće: “Akana više ni pača samo zbog gova so tu vaćardan, golese kaj amen korkore šundam thaj džana kaj si čače kava manuš o Spasitelji e svetoso!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Pale duj đive, o Isus đelo tari Samarija ani Galileja. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Korkoro o Isus svedočisada kaj e proroko ni poštujin ano than kaj barilo. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Kana reslo ani Galileja, e Galilejcura lačhe prihvatisade le samo golese so dikhlje sa e čudesura save ćerda ano Jerusalim, golese kaj i von sesa odori ko prazniko Jevrejengo – Pasha. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Gija o Isus đelo palem ani Kana i Galilejsko, kaj sasa ćerdo o paj ani mol. Sasa jekh službeniko e caroso andaro Kafarnaum, kas sasa nasvalo čhavo. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Kana šunda kaj o Isus andari Judeja avilo ani Galileja, đelo ke leste ani Kana thaj molisada le te avol ano Kafarnaum thaj te sastarol lese čhave golese kaj si ko meripe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","A o Isus phenda lese: “Gasave sen tumen manuša! Dži kaj ni dičhen znakura thaj čudesura, ni pačan.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","E caroso službeniko vaćarda lese: “Gospode! Moliv tut, av sar ni mulo mingro čhavo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","O Isus vaćarda lese: “Dža čhere, ćiro čhavo sastilo!” O manuš pačaja ane Isusese lafura thaj đelo čhere. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Kana sasa vadži ko drom, arakhlja pe slugen save ande lese haberi kaj leso čhavo sastilo. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Vov pučlja len kana sastilo thaj von phende lese: “Eraći ko jekh o sato ko đive ačhada le i groznica.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tegani haljarda o dad kaj gova sasa ane kova sato kana vaćarda lese o Isus: “Ćiro čhavo sastilo.” Thaj pačaje vov thaj savore ane leso čher. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Gova sasa dujto čudesno znako savo ćerda o Isus ani Galileja kana irisajlo tari Judeja. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Pale gova sasa o prazniko e Jevrejengo thaj o Isus đelo ano Jerusalim. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ano Jerusalim paše Bakresi kapija isi banja, savi akhardol jevrejsko Vitezda thaj gothe sesa pandž učharde terase. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Odori pašljona but nasvale manuša, kore, banđe thaj šuće. Von ađućarena o paj te tresil, ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","golese kaj o anđelo e Gospodeso uljola ano određeno vreme ani banja thaj tresila o paj. Ko angleder bi džala andre kana o paj tresila, vov bi sastola taro po nasvalipe savo sasa le. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Gothe pašo paj sasa jekh manuš savo tranda thaj ohto (38) berš sasa nasvalo. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Kana o Isus dikhlja le sar pašljol, a sar džanglja kaj si but berša nasvalo, pučlja le: “Manđe li te ave sasto?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","O nasvalo phenda lese: “Gospode, naj man khoni te mučhol man ani banja kana o paj tresil. Kana me džav premalo paj, khoni aver uljol angleder mande.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","O Isus vaćarda lese: “Ušti, le ćiro than kaj pašljiljan thaj phir!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","A tari jekh drom kova manuš sastilo, lija po than kaj pašlilo thaj phirda. Al gova đive sasa savato ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","golese e Jevrejska šorutne vaćarde kalese save o Isus sastarda: “Ađive si savato! Phađe o zakon, golese kaj inđare ćiro than kaj pašljiljan ko savato!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Al vov phenda lenđe: “Kova manuš savo sastarda man, phenda manđe: ‘Le ćiro than kaj pašljiljan thaj phir!’” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Von pučlje le: “Ko si gova manuš savo vaćarda tuće: ‘Le ćiro than kaj pašljiljan thaj phir?’” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Al o sastardo ni džanglja ko si, golese kaj o Isus crdija pe maškare but manuša save sesa gothe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Pale gova, o Isus arakhlja ane hramesi avlin kole manuše save sastarda thaj vaćarda lese: “Akh, sastiljan! Ma vadži ćer greh, te ma avol tuće pobilačhe!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Tegani o manuš đelo thaj vaćarda e Jevrejskone šorutnenđe kaj si gova o Isus savo sastarda le. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Gija, e Jevrejska šorutne lije te progonin e Isuse golese kaj sastarda e manuše ko savato. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Al o Isus vaćarda lenđe: “Mingro Dad uvek ćerol bući. Gija i me ćerav.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Gola lafura sesa povod e Jevrejskone šorutnenđe te dičhen pobut te mudaren le golese kaj na samo so phaglja o zakon taro savato, nego so e Devle čak akharol Dade thaj gija vov ćerda pe isto sar o Dol. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Golese o Isus phenda lenđe: “Čače, čače vaćarav tumenđe: o Čhavo korkoro pestar našti khanči te ćerol, već samo so dičhol so ćerol o Dad. Sa so o Dad ćerol, gova ćerol i o Čhavo. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Golese kaj o Dad manđol e Čhave thaj sikavol lese sa so korkoro ćerol. A ka sikavol lese i pobare buća tare kala so sastarda akale manuše, te aven zadivime i tumen. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Golese kaj, sar so o Dad vazdol e mulen thaj dol len džuvdipe, gija i o Čhavo dol džuvdipe kase manđol. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Golese so, o Dad khanikase ni sudil, nego dija o pravo pe Čhavese te anol o sudo, ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","te bi savore poštujina e Čhave sar so poštujin e Dade. Ko ni poštujil e Čhave, ni poštujil ni e Dade savo bičhalda le. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Čače, čače vaćarav tumenđe: ko mingre lafura šunol thaj pačal kole savo man bičhalda, isi le džuvdipe bizo meripe thaj ni ka avol osudimo nego nakhlo andaro meripe ano džuvdipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Čače, čače vaćarav tumenđe: avol o sato – thaj već avilo – kana e mule ka šunen o glaso e Devlese Čhaveso thaj kola save šunen, ka aven džuvde. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Sar so si o Dad izvor taro džuvdipe, gija pe Čhave ćerda izvor taro džuvdipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Thaj dija le vlast te sudil golese kaj si Čhavo e Manušeso. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ma čudin tumen kalese! Golese kaj avol o vreme kana sa e mule ka šunen o glaso e Devlese Čhaveso ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","thaj ka ikljen andare pumare limora – kola save ćerde šukar, ka ušten te prihvatin o džuvdipe bizo meripe, a kola save ćerde bilačhe, ka ušten te aven osudime. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Me korkoro mandar khanči našti ćerav. Sudiv ko temelji so šundem tare mo Dad. A mingri presuda si pravedno golese so ni rodav te ćerav mingri volja, nego i volja kolesi savo bičhalda man.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Te svedočisadem korkoro mandar, gova svedočanstvo naj dovoljno. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Al isi jekh aver savo svedočil mandar thaj me džanav kaj si gova svedočanstvo mandar dovoljno. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Tumen bičhalden e manušen ko Jovane o Krstitelj thaj vov svedočisada tumenđe taro čačipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Manđe naj potrebno o manuš te svedočil mandar, al sa kava vaćarav tumenđe taro Jovane, te bi spasina tumen. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","O Jovane sasa sar svetiljka savi phabola thaj dola svetlost, a tumen mangljen zala vreme te uživin ane leso svetlost. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Al man isi po baro svedočanstvo tare Jovaneso. Golese kaj e buća save dija man mo Dad te ćerav – gola čudesna znakura save akana ćerav, svedočin mandar thaj dokažin kaj bičhalda man o Dad. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Thaj o Dad, savo bičhalda man, svedočisada mandar. Tumen nikad ni šunden leso glaso niti dikhljen leso muj. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Leso Lafi naj džuvdo ane tumende golese kaj ni manđen te pačan ane Koleste savo bičhalda man. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Tumen šukar sikljon e Sveta lila, golese kaj den gođi kaj šaj aračhen ane lende džuvdipe bizo meripe, a gola Sveta lila svedočin mandar. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Al tumen ni manđen te aven mande te avol tumen džuvdipe bizo meripe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Me ni prihvativ slava tare manuša. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Al me pindžarav tumen thaj džanav kaj ane tumende naj e Devleso manglipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Me aviljem ano alav mingre Dadeso, a ni manđen te prihvatin man. Te avol khoni aver ane piro alav, le bi prihvatina. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Sar šaj pačan, tumen, save prihvatin i slava jekh averestar, al i slava savi si taro jekh Dol ni roden? ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ma te den gođi kaj me ka tuživ tumen angle mingro Dad. Tumen ka tužil o Mojsije, ane kaste čhuten tumari nada. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Te bi čače pačana e Mojsijase, pačana bi i man. Golese kaj o Mojsije pisisada mandar. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Al te ni pačajen kova so pisisada vov, sar ka pačan ane mingre lafura!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Pale gova o Isus irisada pe ani Galileja thaj đelo ki istočno rig taro Galilejsko more, savo akhardol i Tiverijadsko more. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Pale leste đele but manuša, golese kaj dikhlje e čudesna znakura save ćerda pe nasvale manuša. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","O Isus đelo upre ko brego thaj gothe bešlo pe sikadencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Sasa paše i Pasha, o prazniko e Jevrejengo. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Kana vazdija o Isus pe jakha thaj dikhlja kaj aven paše leste but manuša, pučlja e Filipe: “Kaj šaj te ćina mangro kale manušenđe te xan?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Kava pučlja te bi iskušila le, golese kaj već džanglja so ka ćerol. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","O Filip vaćarda lese: “Ni dujšel (200) srebrnjakura ne bi avola dovoljno savore te xan mangro bar zala.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Vaćarda lese aver tare lese sikade, o Andrija, o phral e Simoneso e Petreso: ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Kate isi amen jekh čhavoro kas isi pandž mangre taro ječam thaj duj cikne mačhe. Al so si gova paše gaći manuša!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","O Isus phenda: “Vaćaren e manušenđe te bešen!” Ke gova than sasa but čar thaj e manuša gothe bešle. Sesa paše pandž milja (5 000) murša. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Tegani o Isus lija kola mangre, zahvalisada e Devlese thaj dija e manušenđe save bešle gothe. Gija ćerda thaj e mačhencar, a savore xalje kobor manglje. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Kana čalile, o Isus vaćarda pe sikadenđe: “Ćiden e kotora so ačhile te ma čhudol pe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Gija ćidije dešuduj (12) korpe so ačhile tare pandž ječmena mangre, save e manuša xalje. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Kana e manuša dikhlje o čudesno znako savo ćerda o Isus, vaćarde: “Kava si čače kova Proroko savo trubul te avol ke kava sveto!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","A kana o Isus haljarda kaj manđen e manuša te aven thaj ki sila te ćeren le caro, đelo palem ko brego, korkoro. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kana peli i rat, ulile lese sikade pašo more. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Čhute pe ano čamco thaj plovisade ki aver rig premalo Kafarnaum. Al već peli i rat, a o Isus vadži ni irisajlo premal lende. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tegani o more lija te vazdol pe tari bari balval. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Kana nakhle paše pandž il šov kilometra, dikhlje e Isuse sar phirol po paj thaj sar avol pašo čamco. E sikade but darajle. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Al vov vaćarda lenđe: “Me sem, ma daran!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tegani lije le pesa andre ano čamco thaj o čamco tari jekh drom avilo dži ki obala kaj plovisade. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Theara đive e manuša save ačhile ki aver rig taro Galilejsko more, primetisade kaj odori sasa samo jekh čamco thaj o Isus ni čhutape pe sikadencar ano čamco, nego kaj e sikade đele korkore. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Tegani taro foro Tiverijada avile avera čamcura paše kova than kaj e manuša xalje mangro, paše savo o Gospod dija hvala e Devlese. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Kana kala but manuša dikhlje kaj gothe naj ni o Isus ni lese sikade, čhute pe ane čamcura thaj đele ano Kafarnaum te roden e Isuse. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Kana nakhle ki goja rig e moresi, arakhlje e Isuse thaj pučlje le: “Rabbi, kana aviljan akari?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","A o Isus vaćarda lenđe: “Čače, čače vaćarav tumenđe: tumen roden man na golese so haljarden e čudesna znakura, nego golese so xaljen mangro thaj čaljiljen. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ma ćeren bući pašo xape savo načhol, nego pašo xape savo ačhol pašo džuvdipe bizo meripe. Gova xape ka dav tumen me, o Čhavo e Manušeso, golese kaj o Dol, o Dad mingro, ovlastisada man.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Von pučlje le: “So trubul te ćera te bi ćerasa e buća save o Dol rodol amendar?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","O Isus vaćarda lenđe: “Kava si i bući savi o Dol rodol tumendar – te pačan ane kova kas vov bičhalda.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Gija pučlje le: “Savo čudesno znako tu ka ćere te šaj dikha thaj te pača ane tute? So ka ćere? ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Amare paradada xalje mangro savo akhardola ‘mana’ ani pustinja, sar so si pisimo ane Sveta lila: ‘Parvarda len mangresa taro nebo.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","O Isus phenda lenđe: “Čače, čače vaćarav tumenđe: ni dija tumen o Mojsije mangro taro nebo, nego mingro Dad. Akana Vov dol tumen čačukano mangro taro nebo. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Golese so si o mangro e Devleso kova savo uljol taro nebo thaj dol džuvdipe e svetose.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Pe gova phende lese: “Gospode, de amen uvek kava mangro!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","O Isus vaćarda lenđe: “Me sem mangro so dol o džuvdipe. Ko avol mande, ni ka bokhavol thaj ko pačal ane mande, ni ka avol nikad trošalo. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Al sar so vaćardem tumenđe: dikhljen man, al ni pačajen. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Dži jekhe manuše save dol manđe o Dad, avol mande; thaj kole savo avol mande ni ka tradav le avral. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Golese kaj me ni uljiljem taro nebo te ćerav mingri volja, nego i volja Kolesi savo bičhalda man. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","A kava si i volja e Devlesi savo bičhalda man kaj kolen so dija man te ma hasarav, nego te vazdav len tare mule ko poslednjo đive. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Golese kaj kava si i volja mingre Dadesi: dži jekh savo dičhol e Čhave thaj pačal ane leste, te avol le džuvdipe bizo meripe thaj me te vazdav le tare mule ko poslednjo đive.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Tegani e Jevreja lije te mrmljin protiv leste golese so phenda: “Me sem mangro savo ulilo taro nebo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Thaj vaćarde: “Naj li kava o Isus, e Josifeso čhavo? Amen pindžara lese dade thaj lese da. Sar šaj vov vaćarol: ‘Me uljiljem taro nebo’?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Tegani o Isus irisada lenđe vaćarindoj: “Ma mrmljin maškar tumende! ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Našti khoni te avol mande te ni anda le mingro Dad savo bičhalda man. A me ka vazdav le tare mule ko poslednjo đive. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Sar so ačhol ane proročka lila: ‘Savoren o Dol ka sikavol.’ Dži jekh savo šunol e Dade thaj sikljol lestar, ka avol mande. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Khoni ni dikhlja e Dade, sem kova savo avol taro Dol. Vov dikhlja e Dade. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Čače, čače vaćarav tumenđe: ko pačal ane mande, isi le džuvdipe bizo meripe! ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Me sem mangro so dol o džuvdipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Tumare paradada xalje mana ani pustinja thaj mule. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Al o mangro savo avol taro nebo si gasavo kaj ko xal lestar, ni ka merol. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Me sem kova mangro e džuvdimaso savo ulilo taro nebo. Ko xal tare kava mangro, ka avol džuvdo ane sa e đivesa. O mangro savo me dav si mingro telo, te bi e manuša kale svetoso šajine te živin.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Tegani e Jevreja lije te ćeren čingara maškar peste pučindoj: “Sar šaj kava manuš te dol amen po telo xamase?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","A o Isus phenda lenđe: “Čače, čače vaćarav tumenđe: te ni xaljen o telo e Čhaveso e Manušeso thaj te ni piljen leso rat, naj ane tumende džuvdipe bizo meripe! ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ko xal mingro telo thaj pijol mingro rat, isi le džuvdipe bizo meripe thaj me ka vazdav le tare mule ko poslednjo đive. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Golese kaj mingro telo si čačukano xape thaj mingro rat si čačukano pijipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ko xal mingro telo thaj pijol mingro rat, ačhol ane mande thaj me ane leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Sar so bičhalda man o džuvdo Dad thaj me sem džuvdo pašo mingro Dad, gijate kova savo xal man, ka avol džuvdo baše mande. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Kava si kova mangro savo ulilo taro nebo, al na gasavo savo xalje tumare paradada thaj mule. Ko xal kava mangro, ka avol džuvdo ane sa e đivesa.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Sa kava o Isus vaćarda kana sikada ani sinagoga ano Kafarnaum. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Tegani but tare lese sikade save šunde kava, vaćarde: “Kava si but pharo vaćaripe! Ko šaj te prihvatil lese lafura?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Al o Isus džanglja kaj lese sikade maškar peste mrmljin paše kala lafura thaj phenda lenđe: “Dal kava sikajipe uznemiril tumen? ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","A so ka phenen ako dičhen e Čhave e Manušese sar džal upre ano nebo, odori kaj sasa angleder? ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","O Sveto Duxo dol o džuvdipe, a o telo naj khančese. E lafura save me vaćardem tumenđe, si o Duxo thaj džuvdipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Al si maškare tumende nesave save ni pačan.” Golese kaj o Isus džanglja taro anglunipe save lendar ni pačan ane leste thaj ko ka izdajil le. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Thaj vadži vaćarda: “Golese vaćardem tumenđe kaj khoni našti avol mande, ako naj lese dindo taro Dad.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tegani but tare lese sikade ačhade le thaj ni đele vadži pale leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","A o Isus pučlja pe dešuduje (12) sikaden: “Te ni manđen te džan i tumen?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Tegani vaćarda lese o Simon o Petar: “Gospode! Kaste te dža? Samo tut isi lafura save den džuvdipe bizo meripe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Amen pača thaj džana kaj tu san o Sveco e Devleso.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Tegani o Isus phenda lenđe: “Na li me izaberisadem tumen, e dešudujen (12)? Al ipak, jekh tumendar si beng!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Gova vaćarda pašo Juda, o čhavo e Simoneso o Iskariotsko, jekh tare dešuduj (12) sikade, golese kaj vov si gova so ka izdajil le. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Pale gova phirda o Isus ani Galileja. Vov ni manglja te džal ani Judejsko phuv golese kaj e jevrejska šorutne dikhlje te mudaren le. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Al sasa paše o prazniko e Jevrejengo kana slavina e Senice. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Tegani lese phrala phende lese: “Dža katar thaj dža ani Judeja, te dičhen ćire sikade e čudura save ćere! ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Golese kaj nijekh ni ćerol e čudura garandoj, a manđol te džanol pe lestar. Kana već ćere gola čudura, sikav tut e svetose!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Golese, čak ni lese phrala ni pačaje ane leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Pe gova vaćarda lenđe o Isus: “Mingro vreme vadži ni avilo, al tumenđe sa o vreme si pogodno. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Tumen o sveto našti mrzil, al man mrzil, golese kaj vaćarav e manušenđe tare kava sveto, kaj si bilačhe lenđe buća. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Tumen džan te slavin o prazniko. Al me vadži ni džav odori golese kaj mingro vreme vadži ni avilo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Gova vaćarda lenđe thaj ačhilo ani Galileja. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Kana đele lese phrala odori te slavin o prazniko, đelo i vov, al na te dičhen le, nego garandoj. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","E jevrejska šorutne rodije e Isuse ko prazniko thaj pučlje: “Kaj si kova manuš?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","I but manuša so gothe sesa, čorale vaćarde taro Isus. Nesave phende: “Vov si šukar manuš!” A e dujta vaćarde: “Naj, xoxavol e manušen!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Al khoni ni vaćarda putarde lestar, golese kaj darajle tare jevrejska šorutne. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ko opaš taro prazniko, o Isus đelo ano Hram thaj lija te sikavol e manušen. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","E jevrejska šorutne čudisajle thaj pučlje pe: “Sar kava džanol e Sveta lila, a ni sasa ane amare škole?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Pe gova o Isus vaćarda lenđe: “Mingro sikajipe naj mingro, nego avol tare Kova savo bičhalda man. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ko manđol te ćerol e Devlesi volja, ka pindžarol, dal si gova sikajipe taro Dol il me vaćarav korkoro mandar. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ko korkoro pestar vaćarol, slava pese rodol. Al ko rodol i slava kolesi savo bičhalda le, gova si čačukano thaj naj ane leste nepravda. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ni li dija tumen o Mojsije o Zakon? Thaj khoni tumendar ni ićarol pe po Zakon! Sose roden te mudaren man?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","E manuša phende: “O bilačho duxo si ane tute! Ko rodol te mudarol tut?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","O Isus vaćarda lenđe: “Ko savato ćerdem čudo thaj savore divisaljen. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","O Mojsije dija tumen o suneti thaj tumen sunetin tumare čhaven i ko savato. Iako ni avol gova adeti taro Mojsije, nego tare tumare paradada. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Te o manuš šaj avol sunetimo ko savato, te ma bi phađola pe o Zakon, sose tegani gaći holjavon pe mande so sastardem celone manuše ko savato? ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ma sudin pale kova so dičhen avral, nego sudin pravedno!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Tegani vaćarde nesave manuša taro Jerusalim: “Naj li kava kova kas roden te mudaren? ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Thaj dikh, sar vaćarol putarde thaj khanči ni vaćaren lese. Te na li pindžarde i e šorutne kaj si vov čače o Hrist? ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Al savore amen džana kotar si kava manuš, a kana ka avol o Hrist, khoni ni ka džanol kotar si!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Dži kaj o Isus sikada ano Hram, zurale phenda: “Va, pindžaren man! Thaj džanen kotar sem! Al me ni aviljem korkoro mandar. Kova savo bičhalda man si čačukano. Le ni pindžaren. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Me pindžarav le, golese kaj sem lestar thaj Vov bičhalda man.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Tegani dikhlje te dolen le, al khoni ni čhuta po va pe leste, golese kaj vadži ni avilo o vreme. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","A but džene tare manuša pačaje ane leste thaj phende: “Kana ka avol o Hrist, dal ka ćerol pobut čudesna znakura nego kava manuš?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","E fariseja šunde so e manuša garandoj phenen lestar. Gijate, von thaj e šorutne sveštenikura bičhalde e stražaren te dolen le. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Tegani o Isus vaćarda: “Vadži zala vreme ka avav tumencar, pa džav Koleste savo bičhalda man. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ka roden man, al ni ka aračhen man. Tumen našti aven odori kaj sem me.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Tegani e jevrejska šorutne pučlje pe maškare peste: “Kaj kava manuš manđol te džal kaj amen našti te arakha le? Šaj manđol te džal ke amare so živin maškare Grkura thaj te sikavol e Grkuren? ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","So si kava lafi so vaćarda: ‘Ka roden man, al ni ka aračhen man’, thaj: ‘Tumen našti aven odori kaj sem me’?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ko poslednjo thaj emvažno đive taro prazniko, ačhilo o Isus thaj dija vika vaćarindoj: “Ko si trošalo, nek avol mande thaj nek pijol! ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ko pačal ane mande, sar so o Sveto lil vaćarol, e leja džuvde pajese ka thavden andar leste!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","O Isus gova vaćarda taro Sveto Duxo save trubul te prihvatin kola save ka pačan ane leste. Tegani vadži naj sasa dindo o Sveto Duxo golese so o Isus naj sasa vadži proslavimo. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Kana nesave džene tare but manuša šunde gola lafura, vaćarde: “Kava si čače kova Proroko save ađućara.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Avera vaćarde: “Kava si čače o Hrist.” Al sesa i kola save vaćarde: “Na. Vov našti te avol o Hrist. Dal o Hrist ka avol andari Galileja? ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ni li sikavol o Sveto lil kaj o Hrist ka avol taro bijandipe e Davideso thaj andaro gav o Vitlejem kaj o David živisada?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Gija paše leste ane manuša ćerdilo ulaipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Nesave lendar dikhlje te dolen le, al khoni ni čhuta pe vasta pe leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Kana e stražara palem avile ke šorutne sveštenikura thaj ke fariseja, von pučlje len: “Sose ni anden le?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","E stražara phende lenđe: “Khoni nikad gija ni vaćarda sar kava manuš.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Pe gova e fariseja vaćarde lenđe: “Dal i tumen diljarda? ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Na li khoni tare šorutne il tare fariseja pačaje ane leste? Na. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nego, kala manuša si prokleta, golese so ni pindžaren o Zakon!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Tegani o Nikodim, jekh tare fariseja, gova savo angleder avilo ko Isus ki rat, pučlja: ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Dal amaro Zakon šaj osudil e manuše ako angleder naj gova manuš šundo thaj ni džanol pe so ćerda?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","A von phende lese: “Naj li san i tu tari Galileja? Pošukar rode ano Sveto lil thaj ka dičhe kaj nijekh proroko ni ka avol andari Galileja.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Tegani, savore đele pese čhere. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","O Isus đelo ko Maslinsko brego. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","A sabalin palem avilo ano Hram thaj sa e manuša ćidije pe paše leste. Vov bešlo thaj lija te sikavol len. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Tegani e učitelja tare Mojsijaso zakon thaj e fariseja ande ke leste džuvlja savi doldi ani preljuba. Čute la maškar e manuša ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","thaj vaćarde lese: “Učitelju! Kaja džuvli si doldi kana ćerda preljuba. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","O Mojsije ano Zakon naredisada gasave džuvljen te mudara barencar. So vaćare tu?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Kava vaćarde te bi iskušina le, sar te avol len paše so te banđaren le. Al o Isus čučnisada tele thaj pisisada najesa pi phuv. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","A sar ni ačhade e učitelja tare Mojsijaso zakon thaj e fariseja te pučen le, vov uspravisajlo thaj vaćarda lenđe: “Ko si maškar tumende bizo greh, angleder nek čhudol pe late o bar.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Palem čučnisada thaj pisisada ki phuv. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Kana von gova šunde, lije te džan gothar jekh pale avereste. Angleder lije te džan e po purane. Gija gothe ačhilo samo o Isus e džuvljasa so sasa ko maškar. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Tegani o Isus uspravisajlo thaj pučlja la: “Džuvlije! Kaj si kala? Nijekh ni osudisada tut?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Voj phenda: “Nijekh, Gospode!” Gija o Isus vaćarda laće: “Ni me ni osudiv tut. Dža thaj vadži ma greši!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Pale gova o Isus pale phenda e manušenđe: “Me sem svetlo e svetoso. Ko džal pale mande, nikad ni ka phirol ano kalipe, al ka avol le svetlost savo inđarol ano džuvdipe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Tegani vaćarde lese e fariseja: “Tu korkoro tuće svedoči. Ćiro svedočanstvo naj dovoljno.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","O Isus phenda lenđe: “Thaj te svedočiv korkoro mandar, dovoljno si mingro svedočanstvo, golese kaj džanav kotar avav thaj kaj džav. Al tumen ni džanen kotar avav thaj kaj džav. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Tumen sudin palo manušikano merilo, al me ni sudiv khanikase. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Al čak i te sudisadem, mingro sudo si čačukano, golese kaj ni sudiv korkoro, nego si mancar o Dad savo bičhalda man. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","A i ane tumaro Zakon ačhol pisimo kaj o svedočanstvo si dovoljno ako duj svedokura vaćarde isto. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Me svedočiv korkoro mandar thaj manđe svedočil o Dad savo bičhalda man.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Tegani pučlje le: “Kaj si ćiro dad?” O Isus phende lenđe: “Tumen ni džanen ko sem me, pa ni džanen ni ko si mingro Dad. Kana bi džanena man, bi džanena i le.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Kala lafura o Isus vaćarda kana sikada e manušen ano Hram paše kutije kaj ćidena pe e pare. Thaj khoni ni dolda le golese kaj vadži ni avilo leso sato. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","O Isus palem vaćarda lenđe: “Me džav thaj tumen ka roden man thaj ka meren ane tumaro greh. Kaj me džav, odori tumen našti aven.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Tegani e Jevrejska šorutne lije te pučen pe: “Te ni manđol te mudarol pe kana gija vaćarol: ‘Kaj me džav, odori tumen našti aven’?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","O Isus vaćarda lenđe: “Tumen sen tare telune, a me sem tare uprune. Tumen sen tare kava sveto, al me naj sem tare kava sveto. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Golese vaćardem tumenđe kaj ka meren ane tumare grehura. Ako ni ka pačan kaj Me Sem, ka meren ane tumare grehura.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Tegani pučlje le: “Ko san tu?” O Isus vaćarda lenđe: “Me sem kova so taro anglunipe vaćarav tumenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","But isi man so bi šajine te vaćarav tumendar pe tumari osuda. Kova savo bičhalda man si čačukano thaj me vaćarav samo kale svetose so šundem Lestar.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Al von ni haljarde kaj vaćarda lenđe taro Dad. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Golese o Isus vaćarda lenđe: “Kana ka vazden e Čhave e Manušese, tegani ka džanen kaj Me Sem thaj korkoro mandar khanči ni ćerav, nego vaćarav gija sar sikada man o Dad. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Thaj Kova so bičhalda man si mancar. Ni ačhada man korkore, golese kaj me ćerav kova so si lese šukar.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Kana kava o Isus vaćarda, but džene pačaje ane leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Tegani vaćarda o Isus kole Jevrejenđe save pačaje ane leste: “Ako tumen ačhen ano mingro sikajipe, čače sen mingre sikade. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Thaj ka pindžaren o čačipe thaj o čačipe ka oslobodil tumen.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","A e Jevreja phende lese: “Amen sam potomkura e Avraamese thaj nikase nikad ni sama robura. Sar šaj te vaćare: ‘Ka aven oslobodime’?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","O Isus phenda lenđe: “Čače, čače, vaćarav tumenđe: dži jekh ko ćerol greh, si robo e grehose. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","O robo ni ačhol ani familija zauvek, al o čhavo ačhol zauvek. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Te oslobodisada tumen o Čhavo, čače ka aven oslobodime. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Džanav kaj sen potomkura e Avraamese. Al tumen dičhen te mudaren man, golese kaj ane tumare ile naj than mingre lafese. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Me vaćarav gova so sikada manđe o Dad thaj tumen ćeren kova so phenda tumenđe tumaro dad.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Von vaćarde lese: “Amaro dad si o Avraam.” O Isus phenda lenđe: “Te aven čhave e Avraamese, bi ćerena gova so ćerda o Avraam. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Al mesto gova tumen akana dičhen te mudaren man, samo golese so vaćardem tumenđe čačipe savo šundem taro Dol. O Avraam nikad ni ćerda gija! ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Tumen ćeren e buća tumare dadese.” Tegani vaćarde lese: “Amen naj sam bijande tari preljuba. Jekh dad isi amen, o Dol!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","O Isus vaćarda lenđe: “Kana bi avola o Dol tumaro dad, manđena bi i man golese kaj me ikliljem taro Dol thaj akana sem akari. Me ni aviljem korkoro mandar, nego vov bičhalda man. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Sose našti haljaren so vaćarav tumenđe? Golese so našti trpin mingro lafi. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Tumaro dad si o beng thaj tumen manđen te ćeren kova so vov manđol. Vov sasa taro anglunipe kova savo mudarol thaj ni ićarol pe po čačipe, golese kaj ane leste naj khanči čačipe. Kana xoxavol, vov sikavol piro čačukano muj golese kaj si xoxavno thaj si dad e xoxaimaso. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Al golese kaj me čačipe vaćarav, tumen ni pačan man. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ko tumendar šaj dokažil manđe jekh greh? Te vaćardem čačipe, sose ni pačan man? ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ko si taro Dol, šunol e Devlese lafura. Tumen ni šunen golese kaj naj sen taro Dol.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","E Jevreja pučlje le: “Ni li šukar vaćara kaj san Samarijanco thaj o beng si ane tute?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","O Isus vaćarda: “Ane mande naj beng, nego me poštujiv mingre Dade a tumen man ni poštujin. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Me ni rodav slava manđe – isi khoni savo rodol la thaj savo sudil. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Čače, čače vaćarav tumenđe: ko ićarol pe ke mingro lafi, nikad ni ka dičhol o meripe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Tegani vaćarde lese e Jevreja: “Akana džana kaj si o beng ane tute. O Avraam mulo thaj gija i e prorokura, a tu vaćare: ‘Ko ićarol pe ke mingro lafi, nikad ni ka dičhol o meripe.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Tu li san po baro tare amaro dad o Avraam, savo mulo? Thaj e prorokura mule. So tu misli, ko san tu?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","O Isus phenda lenđe: “Te slavisadem man korkore, mingri slava khanči ni vredil. Al man proslavil mingro Dad, savese tumen vaćaren kaj si tumaro Dol. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Iako tumen ni pindžaren le, me pindžarav le. Te vaćardem kaj ni pindžarav le, bi avava xoxavno sar tumen. Al me pindžarav le thaj ke leso Lafi ićarav man. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","O Avraam, tumaro dad, radujisajlo so ka dičhol mingro avipe. Thaj dikhlja le thaj radujisada pe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Tegani e Jevreja vaćarde lese: “Vadži naj tut pinda (50) berš, a vaćare kaj dikhljan e Avraame?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","O Isus phenda lenđe: “Čače, čače vaćarav tumenđe: angleder nego so bijandilo o Avraam, Me Sem!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tegani lije e bara thaj manglje te čhuden len pe leste, al o Isus garadilo thaj iklilo taro Hram. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Dži kaj o Isus nakhlo, dikhlja jekhe manuše savo sasa koro taro leso bijandipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Lese sikade pučlje le: “Rabbi! Ko ćerda greh pa bijandilo koro? Vov, il leso dad il lesi dej?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","O Isus vaćarda: “Naj koro golese so grešisada vov, il leso dad il lesi dej. Bijandilo koro te dičhol pe e Devlesi zor pe leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","A dok si đive, amen mora te ćera e buća Kolese savo bičhalda man. Ka perol i rat, kana khoni našti ćerol bući. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Dok sem ko sveto, me sem svetlo e svetoso.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Kana vaćarda kava, čhungarda ki phuv thaj ćerda taro čhungaripe čik, thaj makhlja e čikasa e korese jakha. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Thaj vaćarda lese: “Dža thov tut ani banja Siloam.” (Siloam značil “Bičhaldo”.) Gija kova manuš đelo thaj thoda pe thaj irisajlo čhere dikhljindoj. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","A lese komšije thaj kola save dikhlje le angleder sar prosila, vaćarde: “Naj li kava savo bešola pašo drom thaj prosila?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Nesave vaćarde: “Va, vov si.” Al avera: “Naj, samo ličil pe leste.” A vov korkoro phenda: “Me sem gova manuš.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Tegani pučlje le: “Sar putajle ćire jakha thaj akana dičhe?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Vov vaćarda lenđe: “Manuš savo akhardol Isus, ćerda tari phuv čik, makhlja mingre jakha thaj vaćarda: ‘Dža ani banja Siloam thaj thov tut.’ Gija đeljem thaj thodem ma, thaj lijem te dikhav.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Von pučlje le: “Kaj si vov?” Vov phenda: “Ni džanav.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Tegani kale manuše so sasa angleder koro inđarde ke fariseja. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Al gova đive kana ćerda o Isus i čik thaj putarda lese jakha, sasa savato. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Golese pučlje le e fariseja sar putardile lese jakha. Vov vaćarda lenđe: “Ke mingre jakha čhuta čik, thodem ma thaj akana dikhav!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Tegani vaćarde nesave tare fariseja: “Kava manuš naj taro Dol, golese kaj ćerol bući ko savato.” Al avera phende: “Sar o grešno manuš šaj ćerol gasave čudesna znakura?” Thaj gija sasa maškar lende čingara. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Tegani e fariseja palem pučlje e manuše savo sasa angleder koro: “So tu vaćare paše kava manuš so putarda ćire jakha?” Vov vaćarda: “Proroko si.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Al e jevrejska šorutne ni pačaje kaj sasa koro thaj kaj putajle lese jakha, sa dži kaj ni akharde lese dade thaj lese da, ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","thaj pučlje len: “Kava li tumaro čhavo tare savo vaćaren kaj bijandilo koro? Tegani, sar akana dičhol?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Leso dad thaj lesi dej vaćarde: “Džana kaj si kava amaro čhavo savo bijandilo koro. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Al sar akana dičhol thaj ko putarda lese jakha, amen ni džana. Pučen le! Barilo thaj šaj te vaćarol korkoro pestar.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Kava vaćarde leso dad thaj lesi dej, golese kaj darajle tare jevrejska šorutne. Golese kaj e jevrejska šorutne angleder odlučisade kaj zauvek ka ikalen tari sinagoga dži jekhe ko priznajil e Isuse sar e Hriste. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Golese phende leso dad thaj lesi dej: “Pherda pe berša. Le pučen!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Tegani palo dujto drom akharde e manuše savo sasa koro thaj vaćarde lese: “De e Devlese čast! Priznaji o čačipe! Amen džana kaj kova manuš, savo putarda ćire jakha, si grešniko.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Al vov phenda lenđe: “Grešno li si, ni džanav, al džanav kaj sema koro thaj akana dikhav!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","A pučlje le: “So ćerda tuće? Sar putarda ćire jakha?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","O manuš savo sasa koro vaćarda lenđe: “Me već vaćardem gova tumenđe, al tumen ni mangljen te šunen. Sose palem manđen te šunen? I tumen li manđen te aven lese sikade?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tegani von lije te vređin le thaj vaćarde lese: “Tu san leso sikado, al amen sam sikade e Mojsijase. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Amen džana kaj o Dol vaćarola e Mojsijasa. Al kalese ni džana ni kotar avol.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Kova sastardo manuš vaćarda lenđe: “Gova si čače čudo! Tumen ni džanen kotar si, al putarda mingre jakha. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Amen džana kaj o Dol ni šunol e grešnikuren, al šunol kole savo si devlikano thaj ko lesi volja ćerol. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Od kana si o sveto, vadži ni šundilo kaj khoni putarda e jakha kolese so bijandilo koro. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Te ne bi avola kava taro Dol, khanči ne bi šajine te ćerol.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Von phende lese: “Pherdo san grehura taro ćiro bijandipe thaj tu bi khanči sikavesa amen!” Thaj tradije le andari sinagoga. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","O Isus šunda kaj tradije le andari sinagoga thaj kana arakhlja le, pučlja le: “Pača li tu ano Čhavo e Manušeso?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Vov pučlja le: “Ko si gova, gospodarona, te pačav ane leste?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","O Isus phenda lese: “Dikhljan le! Gova si kova so vaćarol tusa!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Tegani vov vaćarda: “Va, pačav, Gospode!” Thaj pelo pe koča angle leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","O Isus vaćarda: “Me aviljem ke kava sveto te sudiv. Aviljem te šaj dičhen kola save ni dikhlje thaj te sikavav kolenđe save den gođi kaj dičhen kaj si kore.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Nesave fariseja save sesa lesa, gova šunde thaj vaćarde lese: “Te naj sam i amen kore?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","O Isus vaćarda lenđe: “Kana bi priznajina kaj sen kore, ne bi avena kriva pašo greh al golese kaj phenen: ‘Dikha’, gija tumari krivica ačhol.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","O Isus vadži vaćarda: “Čače, čače vaćarav tumenđe: ko ni uljol ko vudar ano tor e bakrengo nego hutol čorale prekalo duvari, vov si čor thaj razbojniko. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Al ko uljol ko vudar, vov si pastiri e bakrengo. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Lese o stražari putrol o vudar thaj e bakre šunen leso glaso. Vov pe bakren akharol ko alav thaj ikalol len avral. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Kana ikalol sa pe bakren, džal angle lende thaj e bakre džan pale leste, golese kaj pindžaren leso glaso. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Palo kova kas ni pindžaren, ni ka džan, nego ka našen lestar golese kaj leso glaso ni pindžaren.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","O Isus vaćarda lenđe kaja paramič, al von ni haljarde so manglja te vaćarol lenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Golese o Isus vadži phenda lenđe: “Čače, čače vaćarav tumenđe: Me sem vudar e bakrenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Savore save avile angleder mande si čora thaj razbojnikura, al e bakre ni šunde len. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Me sem vudar. Ko dol maškar mande ka avol spasimo. Ka džal andre thaj ka ikljol thaj ka aračhol lačho pašnjako. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","O čor avol te čorol, te čhinol thaj te mudarol. Me aviljem te avol len džuvdipe thaj gova ano izobilje. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Me sem šukar pastiri. Šukar pastiri dol po džuvdipe pe bakrenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","O manuš savo si poćindo te aračhol e bakren. Vov naj pastiri, gola bakre naj lese – kana dičhol e ruve kaj avol, ačhavol e bakren thaj našol. A o ruv napadil len thaj e bakre našen ke sa e riga. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Golese so vov si samo poćindo manuš thaj ni ačhilo lese dži e bakre. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Me sem šukar pastiri. Me pindžarav mingre bakren thaj von man pindžaren. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Sar so o Dad pindžarol man, i me gija pindžarav e Dade. Me mingro džuvdipe dav me bakrenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Isi man i avera bakre save naj tare kava tor thaj len trubul te anav. Von ka šunen mingro glaso thaj ka aven jekh stado jekhe pastiresa. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Mingro Dad manđol man, golese so dav mingro džuvdipe te bi lava le palem. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Khoni ni lol o džuvdipe mandar, nego me dav le korkoro mandar. Vlast isi man te dav mingro džuvdipe thaj vlast isi man i te lav le palem. Kava zapovest lijem tare mingro Dad.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Tegani palem putajle čingara maškare Jevreja paše kala lafura. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","But lendar vaćarde: “Ane leste si o beng thaj dilajlo. Sose šunen le?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Al avera phende: “Kala lafura našti aven taro kova ane kaste si o beng. Šaj li o beng e korenđe jakha te putrol?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","A sasa prazniko kana slavina o svetipe e Hrameso ano Jerusalim, a sasa jevend. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","O Isus phirda ano Hram ki terasa e Solomonesi. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","A e Jevrejska šorutne okolisade le thaj pučlje le: “Dži kana ka garave amendar ko san tu? Te san o Hrist, vaćar amenđe putarde!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","O Isus phenda lenđe: “Me vaćardem tumenđe, al ni pačajen. Buća save ćerav ano alav mingre Dadeso, svedočin mandar. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Al tumen ni pačan, golese kaj naj sen tare mingre bakre. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mingre bakre šunen mingro glaso. Me pindžarav len thaj von džan pale mande. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Me dav len džuvdipe bizo meripe thaj von nikad ni ka mudardon. Khoni ni ka crdol len tare mingre vasta. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Mingro Dad savo dija len manđe, pozuralo si savorendar thaj khoni našti crdol len tare vasta mingre Dadese. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Me thaj mingro Dad sam jekh.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Tegani e Jevreja palem lije bara thaj manglje te čhuden len pe leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","O Isus vaćarda lenđe: “But lačhe buća sikadem tumenđe tare mingro Dad. Za ke save lačhe buća manđen te čhuden bara pe mande?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","E Jevreja phende lese: “Ni manga te čhuda pe tute bara paše šukar buća, nego so huli po Dol. Ćere tut Dol, al samo san manuš!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","O Isus vaćarda lenđe: “Ni li ačhol ano tumaro Zakon: ‘Me phendem: tumen sen dolura’? ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Te akharda dolura gasaven savenđe avilo o Lafi e Devleso – thaj o Sveto lil našti promenil pe – ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","sar šaj tumen te vaćaren kolese kas o Dad svetisada thaj bičhalda le ki phuv: ‘Huli’, golese kaj vaćardem: ‘Me sem Čhavo e Devleso’? ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Te ni ćerav e buća mingre Dadese, ma pačan man. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Al te ćerav, i te ane mande ni pačan, gole bućenđe pačan, te bi pindžarena thaj te bi džanena kaj si o Dad ane mande thaj me ano Dad.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Pale gova von palem dikhlje te dolen le, al vov crdija pe lenđe andare vasta. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Tegani o Isus palem đelo ke aver rig tari len o Jordan, ko than kaj angleder krstila o Jovane. Thaj ačhilo gothe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","A but manuša avile leste thaj vaćarde: “O Jovane ni ćerda nijekh čudesno znako, al avilo čače sa so vaćarda kale manušestar.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Thaj but džene gothe pačaje ano Isus. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Nesavo manuš savo akhardola Lazar sasa nasvalo. Vov sasa tari Vitanija, taro gav kaj bešle i Marija thaj laći phen i Marta. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(I Marija si koja savi ka čhorol o miris po Gospod thaj ka kosol lese pingre pe balencar. Lako phral o Lazar sasa nasvalo.) ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","E pheja golese bičhalde palo Isus vaćarindoj: “Gospode! Ćiro manglo amal si nasvalo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Kana o Isus gova šunda, phenda: “Kava nasvalipe ni ka anol meripe, već slava e Devlese, te bi prekal kava nasvalipe proslavila pe o Čhavo e Devleso.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","O Isus manglja e Marta thaj laće pheja e Marija thaj e Lazare. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Gija, kana šunda bašo nasvalipe e Lazareso, ačhilo vadži duj đive odori kaj sasa, ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","thaj pale gova vaćarda pe sikadenđe: “Ajde te dža palem ani Judeja!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","E sikade phende lese: “Rabbi! Okova đive e jevrejska šorutne manglje te mudaren tut barencar, a tu palem manđe odori te dža?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","O Isus vaćarda: “Dal o đive naj le dešuduj (12) satura? Ko phirol ko đive, našti perol, golese kaj dičhol o svetlo kale svetoso. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Al ko džal ki rat, perol, golese kaj naj videlo ane leste.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Kava vaćarda thaj vadži phenda: “O Lazar, amaro amal zasuta, a me džav te džungavav le.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Tegani phende lese e sikade: “Gospode! Te zasuta, ka sastol!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Al o Isus vaćarda bašo meripe e Lazareso, a von dije gođi kaj o Lazar čače sovol. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Tegani o Isus putarde vaćarda lenđe: “O Lazar mulo. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Zbog tumende raduji man so ni sema odori, te bi šaj pačana. Al, ajde ka dža ke leste.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tegani o Tomo, savo akhardola Bliznako, phenda avere sikadenđe: “Ajde te dža i amen te mera lesa.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Kana o Isus avilo odori, dodžanglja kaj čhute e Lazare ano limori angleder štar đive. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","I Vitanija sasa pašo Jerusalim paše trin kilometra. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Tegani gothar but Jevreja avile ki Marta thaj ki Marija te kovljaren i dukh pale lengo phral. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Kana i Marta šunda kaj o Isus avilo, iklili angle leste, a i Marija ačhili čhere. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","I Marta vaćarda e Isusese: “Gospode! Te avesa kate, ne bi merola mingro phral! ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Al me i akana džanav kaj sa so ka rode taro Dol, ka dol tut!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","O Isus vaćarda laće: “Ćiro phral ka uštol tare mule.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","I Marta phenda lese: “Džanav kaj ka uštol tare mule kana savore ka ušten, ano poslednjo đive.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","O Isus vaćarda laće: “Me sem uštipe tare mule thaj džuvdipe. Ko pačal ane mande, i te mulo, ka avol džuvdo. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Dži jekh savo si džuvdo thaj pačal ane mande, nikad ni ka merol. Pača li ane kava, Marto?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Voj phenda lese: “Va, Gospode! Me pačav kaj tu san o Hrist, o Čhavo e Devleso, savo trubuja te avol ki phuv.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Kana kava vaćarda, đeli te akharol pe pheja thaj po zala vaćarda laće: “O učitelji avilo thaj manđol te dičhol tut.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Kana i Marija gova šunda, uštili sigate thaj đeli ke leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","O Isus vadži ni sasa ano gav, nego vadži sasa ko than kaj reslja le i Marta. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Kana e Jevreja save sesa e Marijasa ano čher thaj kovljarde lenđi dukh, dikhlje kaj i Marija sigate uštili thaj iklili avral, i von đele pale late golese kaj dije gođi kaj džal ko limori te rovol odoringate. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Kana i Marija resli ko than kaj sasa o Isus thaj dikhlja le, peli angle lese pingre thaj vaćarda lese: “Gospode! Te avesa kate, ne bi merola mingro phral!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Kana o Isus dikhlja kaj i Marija lija te rovol thaj kaj roven i e Jevreja save avile lasa, but potresisajlo ano duxo thaj žal sasa lese. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","O Isus pučlja: “Kaj čhuten le?” Vaćarde lese: “Gospode, av te dičhe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","A o Isus lija te rovol. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Tegani e Jevreja phende: “Dikh kobor manglja le!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Al nesave lendar vaćarde: “Naštine li kava savo putarda e jakha e korese, te ćerol kava manuš te ma merol?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","O Isus tegani palem potresisajlo thaj đelo ko limori. Gova sasa pećina kaso ulaz phanglje bare baresa. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","O Isus phenda: “Crden o bar!” I Marta, i phen koleso so mulo, vaćarda lese: “Gospode! Vov već khandol, golese kaj nakhle štar đive sar mulo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Tegani o Isus vaćarda laće: “Na li phendem tuće kaj ka dičhe i slava e Devlesi te pačajan?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Sigate crdije o bar. Tegani o Isus vazdija pe jakha upre premalo nebo thaj phenda: “Dade! Hvala tuće so šundan man. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Me džanav kaj uvek šune man, al kava vaćardem zbog e manuša save ačhen kate, te pačan kaj tu bičhaldan man.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Kana phenda kava, dija vika andare sa o glaso: “Lazare, iklji avri!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Thaj iklilo o mulo. Lese vasta thaj lese pingre sesa paćarde čaršafesa thaj leso muj sasa phanglo kotoresa. O Isus vaćarda lenđe: “Putren le thaj mučhen le te džal!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Tegani but Jevreja save avile ki Marija thaj dikhlje so ćerda o Isus, pačaje ane leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Al nesave lendar đele ke fariseja thaj vaćarde lenđe so ćerda o Isus. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Golese e šorutne sveštenikura thaj e fariseja ćidije e manušen andaro Baro sudo thaj vaćarde: “So ka ćera? Kava manuš ćerol but čudesna znakura. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Te ačhadam le gija, savore ka pačan ane leste. Pale gova ka aven e Rimljanura thaj ka len amaro Hram thaj amare narodo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Tegani o Kajafa, jekh lendar, savo gova berš sasa baro svešteniko, vaćarda: “Tumen khanči ni džanen! ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ni den gođi kaj si tumenđe pošukar jekh manuš te merol baše manuša, te ma bi sa o narodo properola.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","O Kajafa ni vaćarda kava korkoro pestar, nego, sar baro svešteniko gole beršeso, prorokujisada kaj o Isus trubul te merol bašo sa o narodo. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Thaj na samo bašo narodo, nego te bi ćidola katane sa e strvime čhaven e Devlese thaj te aven sar jekh. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Gija gova đive dogovorisajle e jevrejska šorutne te mudaren e Isuse. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Golese o Isus vadži ni phirda putarde maškare jevrejska šorutne, al gothar đelo ani phuv paši pustinja, ano gav savo akhardol Efrem thaj gothe sasa pe sikadencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","A sasa paše o prazniko e Jevrejengo – Pasha thaj but Jevreja tari sa i phuv avile ano Jerusalim angleder i Pasha, te ćeren o adeti e thodimaso. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Tegani rodije e Isuse thaj kana ačhile ano Hram, pučlje jekh avere: “So den gođi? Ka avol li vov ki Pasha?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Gija, e šorutne sveštenikura thaj e fariseja već dije naredba, ko ka dodžanol kaj si o Isus, te prijavil le, sar bi dolena e Isuse. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Šov đive angleder o prazniko i Pasha avilo o Isus ano gav i Vitanija, kaj bešlo o Lazar, manuš kas o Isus vazdija tare mule. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Gothe ćerde e Isusese večera. I Marta služisada, a o Lazar sasa maškare kola so bešle pašo astali e Isusesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Tegani i Marija lija paše opaš litra skupoceno mirisno ulje taro čisto nardo, makhlja e Isusese pingre thaj koslja len pe balencar. A o čher pherdilo lačho miris. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Tegani jekh tare Isusese sikade, o Juda o Iskariotsko savo pale gova izdajisada le, vaćarda: ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Sose kava mirisno ulje ni bićinda pe baše trišel (300) srebrenjakura, a e pare te den pe e čororenđe?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Al vov kava ni vaćarda golese so ačhilo lese dži ke čore, nego golese so sasa čor. Leste sasa i kesa e parencar thaj vov lola pese gothar kova so čhuvola pe gothe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Tegani o Isus vaćarda: “Ačhav la! Gova ćerda te pripremil man bašo đive za ko mingro prahope! ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Čore uvek ka aven maškar tumende, al me ni ka avav uvek tumencar.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","But Jevreja dodžanglje kaj si o Isus ani Vitanija. Al ni đele odori samo te dičhen e Isuse, nego te dičhen i e Lazare kas o Isus vazdija tare mule. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Gija e šorutne sveštenikura dogovorisajle te mudaren e Lazare ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","golese kaj zbog leste but Jevreja ačhade len thaj lije te pačan ano Isus. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Theara đive but džene save avile ki Pasha, šunde kaj o Isus avol ano Jerusalim. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Lije e palmaće raja, iklile angle leste thaj dije vika: “Hosana! Blagoslovimo si kova savo avol ano alav e Gospodeso! Blagoslovimo si o Caro e Izraeleso!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","A o Isus arakhlja terne here thaj bešlo pe leste sar so si pisimo ano Sveto lil: ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ma daran, manušalen ano Jerusalim! Akh, ćiro Caro avol bešindoj po terno her!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Lese sikade tegani gova ni haljarde, al kana o Isus sasa vazdimo ani piri slava, dije gođi kaj sasa gija pisimo ano Sveto lil taro Isus thaj gija i ćerde lese. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","E manuša save sesa e Isusesa kana akharda e Lazare te ikljol taro limori thaj vazdija le tare mule, širisade o lafi golestar. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Golese iklile angle leste but manuša golese kaj šunde kaj ćerda gova čudesno znako. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Tegani e fariseja vaćarde jekh averese: “Dičhen kaj khanči našti ćera. Ek, sa o sveto đelo pale leste!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","A maškare manuša sesa Grkura save avile te peren ke koča anglo Dol, ki Pasha. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Von avile pašo Filip savo sasa tari Galilejsko Vitsaida pa molisade le: “Gospodarona, amen manga te dikha e Isuse!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","O Filip đelo thaj vaćarda gova e Andrijase thaj zajedno đele te vaćaren gova e Isusese. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","O Isus vaćarda lenđe: “Avilo o sato te primil i slava o Čhavo e Manušeso. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Čače, čače vaćarav tumenđe: te i o seme taro điv ni perol ki phuv thaj ni merol, ačhol samo jekh zrno. Al te mulo, anol barvalo bijandipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ko manđol piro džuvdipe, ka hasarol le. A ko mrzil piro džuvdipe ki kaja phuv, ka aračhol le bašo džuvdipe bizo meripe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ko služil man, mora te phirol pale mande. Kaj sem me, gothe ka avol i mingro sluga. Mingro Dad ka dol čast kolese savo man služil. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Mingri duša si akana uznemirimi. So me te vaćarav? Te vaćarav li: ‘Dade, arakh ma tari patnja’? Al baš golese i aviljem! ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Dade! Proslavi ćiro alav!” Tegani šundilo o glaso taro nebo: “Već proslavisadem le thaj palem ka proslaviv le!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Kana gova šunde e manuša save odori ačhile, vaćarde: “Grmisada.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Al avera phende: “O anđelo vaćarda lesa.” A o Isus pe gova vaćarda lenđe: “Kava glaso ni šundilo baše mande, nego baše tumende. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Akana si o vreme kale svetose te avol sudimo! Akana o vladari kale svetoso ka avol čhudimo avral. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","A me, kana ka avav vazdimo tari phuv, sa e manušen ka crdav paše mande.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Gova vaćarda te sikavol save merimasa ka merol. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","E manuša phende lese: “Šundam taro Zakon kaj o Hrist ka ačhol ane sa e đivesa. Sar tu šaj vaćare kaj o Čhavo e Manušeso trubul te avol vazdimo te merol? Ko si gova ‘Čhavo e Manušeso’?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Tegani o Isus vaćarda lenđe: “O svetlo ni ka avol vadži but vreme maškar tumende. Phiren dži kaj isi tumen svetlo, te ni nadvladil tumen o kalipe. Golese so, ko phirol ano kalipe, ni džanol kaj džal. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Dži kaj isi tumen svetlo, pačan e svetlose, te šaj aven e čhave e svetlose!” Kana gova o Isus phenda, đelo thaj garadilo lendar. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Iako gaći čudesna znakura ćerda angle lende o Isus, von palem ni pačaje ane leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Gova sasa te bi pherdola kova so vaćarda o proroko o Isaija: “Gospode, ko pačaja amare haberese? Kase sikadilo o zuralo va e Gospodeso?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Golese naštine te pačan, golese so o Isaija vadži vaćarda: ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“O Dol korada lenđe jakha, thaj zurada lengo ilo, jakhencar te ni dičhen, thaj ilesa te ni haljaren, te ni irin pe premal mande te sastarav len.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Kava phenda o Isaija, golese kaj dikhlja e Isusesi slava thaj vaćarda lestar. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","A čak i but džene tare jevrejska šorutne pačaje ane leste, nego zbog e fariseja ni priznajisade le javno, te ma bi ikalena len zauvek tari sinagoga. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Golese, po šukar sasa lenđe o čast savo avol tare manuša nego o čast savo dol o Dol. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Tegani o Isus dija vika andare sa o glaso: “Ko pačal ane mande, ni pačal samo ane mande, nego i ane Koleste savo bičhalda man. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Thaj ko dičhol man, dičhol i Kole savo bičhalda man. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Me – o Svetlost – aviljem ki phuv, ma te ačhol ano kalipe nijekh ko ane mande pačal. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Te khoni šunol mingre lafura al ni ićarolpe pe lende, me ni sudiv le. Golese so, me ni aviljem te sudiv o sveto, nego te spasiv o sveto. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ko odbacil man thaj ni lol mingre lafura, isi le leso sudija. O Lafi savo me vaćardem ka sudil le ko poslednjo đive. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Golese kaj, me ni vaćardem korkoro mandar, nego o Dad, savo bičhalda man, zapovedisada manđe so te vaćarav thaj so te phenav. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Thaj me džanav kaj leso zapovest anol džuvdipe bizo meripe. Gija, so me vaćarav, vaćarav gija sar so o Dad phenda manđe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Angleder o prazniko i Pasha, džanglja o Isus kaj avol o sato te načhol tare kava sveto ko Dad. O Isus dži o krajo sikavola kobor manđol kolen so preperen lese ke kava sveto. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Avilo vreme za ki večera. O beng e Judase, e čhavese e Simonese o Iskariotsko, već čhuta ano ilo te izdajil e Isuse. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","O Isus džanglja kaj o Dad dija le sa o vlast ane vasta thaj kaj taro Dol iklilo thaj ko Dol iril pe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Uštilo tari večera, uljarda po ogrtači, lija o peškiri thaj phanglja pe lesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Pale gova čhorda paj ano lavori thaj lija te thovol e sikadenđe pingre thaj te kosol len e peškiresa savesa phanglja pe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Kana avilo dži o Simon Petar, vov vaćarda lese: “Gospode! Tu li mingre pingre ka thove?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","O Isus vaćarda lese: “So me ćerav akana tu ni džane, al jekh đive ka džane.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","O Petar vaćarda lese: “Nikad tu ni ka thove mingre pingre!” O Isus vaćarda lese: “Te ni thodem tut, našti ave jekh tare mingre.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","O Simon Petar phenda lese: “Gospode, onda thov na samo mingre pingre, nego i mingre vasta thaj mingro šoro!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","O Isus vaćarda lese: “Kolese savo si najardo, trubul te thoven pe samo lese pingre, golese so si leso telo sa thodo! Thaj tumen sen thode, al na savore.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","O Isus džanglja ko ka izdajil le, pa golese vaćarda: “Naj sen savore thode.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Kana o Isus thoda lenđe pingre, čhuta pe peste o ogrtači, pale bešlo ke piro than pašo astali thaj pučlja len: “Džanen li so ćerdem tumenđe? ");
INSERT INTO rmyGurbet_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Tumen man akharen Učitelji thaj Gospod thaj šukar vaćaren, golese kaj me sem gova. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Te me, tumaro Gospod thaj Učitelji, thodem tumare pingre, tegani i tumen trubun te thoven jekh averenđe pingre. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Dijem tumen primer i tumen gija te ćeren sar so me ćerdem tumenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Čače, čače vaćarav tumenđe: o sluga naj po baro taro piro gospodari, ni o bičhaldo naj po baro tare kova savo bičhalda le. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Golese kaj kava džanen, blagoslovime sen ako gova ćeren.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ni vaćarav savorenđe tumenđe. Me džanav kolen kas birisadem! Al trubul te pherdol gova so si pisimo ano Sveto lil: ‘Kova savo xal mangro mancar, iril manđe po dumo.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Vaćarav tumenđe akana, angleder nego so ka avol, gija kana gova ka avol, te pačan kaj Me Sem. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Čače, čače vaćarav tumenđe: ko primil kole kas me bičhalav, man primil thaj ko primil man, primil kole so man bičhalda.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Kana vaćarda kava o Isus, leso duxo sasa uznemirimo, golese putarde vaćarda: “Čače, čače vaćarav tumenđe: jekh tumendar ka izdol man.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Tegani e sikade dikhlje pe maškar peste, golese kaj ni džanglje kastar gova vaćarol. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jekh tare lese sikade, kas o Isus but manglja, bešlo pašo Isus. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","O Simon Petar dija le znako thaj vaćarda: “Puč le kastar gova vaćarol.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Kava so bešlo pašo Isus, nakhlo popaše paše leste thaj pučlja le: “Gospode, ko si gova?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","O Isus phenda: “Kova kase bolav o mangro ano čaro thaj dav le.” Tegani bolda o mangro ano čaro thaj dija e Judase, e čhavese e Simonese e Iskariotskonese. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Kana o Juda xalja, o Satana ulilo ane leste. Tegani o Isus lese vaćarda: “Gova so manđe te ćere, ćer akana.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Khoni kolendar so bešle lesa pašo astali, ni haljarda sose o Isus vaćarda lese gova. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Golese so ko Juda sasa i kesa e parencar, nesave dije gođi kaj o Isus phenol lese te džal te ćinol khanči xamase pašo prazniko, il te dol khanči e čororenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Pale gova so o Juda xalja o mangro, iklilo sigate. A sasa rat. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Kana o Juda iklilo, o Isus phenda: “Akana ka proslavil pe o Čhavo e Manušeso thaj o Dol ka proslavil pe ane leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ako o Dol ka proslavil pe ane leste, o Dol le ka proslavil ane peste thaj ka proslavil le sigate. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Čhavoralen mingralen, vadži zala ka avav tumencar! Ka roden man, al sar so vaćardem e jevrejskone šorutnenđe, gija akana vaćarav i tumenđe: ‘Kaj me džav, tumen našti aven odori.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nevo zapovest dav tumen: Manđen jekh avere. Sar so me mangljem tumen, gija i tumen te manđen jekh avere. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Pale gova savore ka pindžaren kaj tumen sen mingre sikade, te isi tumen o manglipe jekh averese.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","O Simon Petar pučlja e Isuse: “Gospode, kaj dža?” O Isus vaćarda lese: “Kaj me džav, tu akana našti dža pale mande, al pale gova ka dža.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","O Petar pučlja le: “Gospode, sose akana našti džav pale tute? Me tuće ka dav i mingro džuvdipe!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","O Isus pučlja le: “Ka de ćo džuvdipe manđe? Čače, čače vaćarav tuće, angleder so ka đilabol o bašno, trin droma ka vaćare kaj ni pindžare man.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","O Isus vaćarda: “Te ma aven žalna tumare ile! Pačan ano Dol thaj pačan ane mande. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ano čher mingre Dadeso isi but thana. Te ma avol gija, ne bi vaćarava tumenđe: ‘Džav te pripremiv tumenđe than.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Kana ka džav thaj pripremiv tumenđe than, palem ka avav thaj ka lav tumen mande te bi tumen avena kaj sem me. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","A tumen džanen o drom kaj me džav.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","O Tomo phenda: “Gospode, ni džana kaj dža. Sar šaj džana o drom?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","O Isus vaćarda lese: “Me sem o drom, o čačipe thaj o džuvdipe. Khoni ni ka avol ko Dad, sem prekal mande. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kana bi man pindžarena, ka pindžaren i mingre Dade. Od akana tumen džanen le thaj dikhljen le.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","O Filip vaćarda lese: “Gospode, sikav amenđe e Dade thaj dosta ka avol amenđe!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Pe gova phenda lese o Isus: “Gaći vreme sem tumencar, Filipe, thaj tu vadži ni džane ko sem me? Ko dikhlja man, dikhlja e Dade. Sar onda šaj phene: ‘Sikav amenđe e Dade’? ");
INSERT INTO rmyGurbet_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ni li pača kaj me sem ano Dad thaj o Dad si ane mande? Lafura save vaćarav tumenđe ni vaćarav korkoro mandar, nego o Dad savo si džuvdo ane mande, ćerol pe buća. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Pačan man kaj me sem ano Dad thaj o Dad si ane mande. Te na, pačan zbog e buća save ćerdem. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Čače, čače vaćarav tumenđe: ko pačal ane mande, ka ćerol buća save me ćerav, pa i pobare buća ka ćerol, golese kaj me džav ko Dad. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Sa so ka roden ane mingro alav, me ka ćerav, te proslavil pe o Dad ano Čhavo. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Bilo so te roden ane mingro alav, ka ćerav.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Te man mangljen, ka ićaren mingre zapovestura. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","A me ka moliv mingre Dade thaj vov ka bičhalol tumenđe avere Zastupniko te avol tumencar ane sa e đivesa: ");
INSERT INTO rmyGurbet_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","o Duxo e čačimaso save o sveto našti primil, golese kaj ni dičhen le thaj ni pindžaren le. Al tumen pindžaren le, golese kaj živil tumencar thaj ka avol ane tumende. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ni ka ačhavav tumen sar čororen. Palem ka irima tumende. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Vadži zala, o sveto man ni ka dičhol, al tumen ka dičhen man. Golese kaj me sem džuvdo thaj i tumen ka aven džuvde. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ane gova đive ka pindžaren kaj me sem ane mingro Dad thaj tumen sen ane mande thaj me ane tumende. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ko prihvatisada mingre zapovestura thaj ićarol len, gova manđol man. A ko manđol man, le ka manđol i mingro Dad. I me ka mangav le thaj me ka sikadivav lese.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","O Juda (na o Iskariotsko) vaćarda lese: “Gospode, sar gova kaj ka sikave tu samo amenđe, a na e svetose?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","O Isus phenda lese: “Te khoni manglja man, ka ićarol pe ko mingro lafi thaj mingro Dad ka manđol le. Leste ka ava, mingro Dad thaj me thaj lesa ka beša. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ko ni manđol man, ni ićarol pe ko mingro lafi. A o lafi so šunen, naj mingro, nego taro Dad savo bičhalda man. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Kava vaćardem tumenđe kana vadži sema tumencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Al o Zastupniko, o Sveto Duxo, kas o Dad ka bičhalol te zastupil man, ka sikavol tumen tare sa thaj ka dol tumen gođi sa so vaćardem tumenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ačhavav tumenđe mir, mingro mir dav tumen. Al me ni dav tumen gova mir sar so dol tumen o sveto. Te ma uznemirin pe tumare ile thaj te ma daran. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Šunden kaj vaćardem tumenđe: ‘Džav thaj palem ka avav tumende.’ Te manđen man, bi avena radosna so džav ko Dad golese kaj si o Dad po baro mandar. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Vaćarav tumenđe gova akana, angleder so gova ka avol, te pačan kaj gova ka avol. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ni ka vaćarav tumenđe vadži but, golese kaj avol o vladari kale svetoso. Le naj vlast pe mande. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Al, te bi o sveto dodžanola sar mangav e Dade, ćerav baš sar so naredisada manđe o Dad. A akana, ajde ušten ka dža katar!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Me sem čačukano čokot thaj mingro Dad si vinogradari. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Vov čhinol dži jekh loza pe mande savi ni anol bijandipe. Thaj rezil dži jekh savi anol bijandipe, te bi anola pobut bijandipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Tumen sen već rezime thaj thode lafesa savo me vaćardem tumenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ačhen tumen ane mande thaj me ka ačhav ane tumende! Sar so i loza našti anol bijandipe korkori pestar te ni ačhili po čokot, gija i tumen našti aven kola save šaj anen bijandipe te ni ačhiljen ane mande. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Me sem o čokot, a tumen loze. Ko ačhol ane mande thaj me ane leste, anol but bijandipe, golese kaj bize mande khanči našti te ćeren. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ko ane mande ni ačhol, ka čhudol pe avri sar i čhindi loza thaj ka šučhol. Tegani ka ćiden gasave loze thaj ka čhuden len ani jag kaj ka phabaren len. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Te ačhiljen ane mande thaj mingre lafura ane tumende, roden sa so manđen thaj ka dol pe tumenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Mingro Dad ka proslavil pe gija so ka anol but bijandipe thaj so ka aven mingre sikade. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Sar so o Dad manglja man, gija i me mangljem tumen. Ačhen ane mingro manglipe! ");
INSERT INTO rmyGurbet_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Te ićarden tumen pe mingre zapovestura, ka ačhen ane mingro manglipe, sar so i me ićardem ma ke zapovestura mingre Dadese thaj ačhav ane leso manglipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Gova vaćardem tumenđe te avol mingro radujipe ane tumende thaj tumaro radujipe te avol pherdo. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Kava si mingro zapovest: manđen jekh avere sar so me mangljem tumen. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Po baro manglipe naj tare kava nego kana khoni dol piro džuvdipe pe amalenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Tumen sen mingre amala te ćerden kova so zapovediv tumenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ni akharav tumen više sluge golese kaj o sluga ni džanol so ćerol leso gospodari. Akana akharav tumen mingre amala golese kaj vaćardem tumenđe sa so phenda manđe mingro Dad. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ni birisaden tumen man, nego me birisadem tumen thaj čhutem tumen te džan thaj te anen bijandipe savo ka ačhol thaj te dol tumen mingro Dad sa so ka roden ane mingro alav. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Kava zapovediv tumenđe: manđen jekh avere!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Te mrzil tumen o sveto, džanen kaj man mrzisada angleder tumende. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kana bi preperena e svetose, o sveto bi manđola tumen. Al, golese kaj ni preperen kale svetose, nego me birisadem tumen taro sveto, golese o sveto mrzil tumen. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Den tumen gođi so vaćardem tumenđe: ‘O sluga naj po baro taro piro gospodari.’ Te man progonisade, ka progonin i tumen. Te ićarde pe ke mingro lafi, ka ićaren pe i ke tumaro. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","A sa gova von ka ćeren tumenđe baše mande, golese kaj ni džanen Kole savo bičhalda man. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Te ni aviljem thaj ni vaćardem lenđe, ne bi avena banđe. Al akana naj len so te vaćaren baše pe grehura. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ko man mrzil, mrzil i mingre Dade. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Te ma ćerava maškar lende buća save khoni aver ni ćerda, ne bi avena banđe. Al von dikhlje buća save ćerdem a palem mrzisade i man thaj mingre Dade. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Al trubul te pherdol o lafi savo si pisimo ane lengo Zakon: ‘Mrzisade man nisose.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","A kana ka avol o Zastupniko, save ka bičhalav tumenđe taro mingro Dad – o Duxo e čačimaso savo ikljol taro Dad – vov ka svedočil mandar. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Thaj i tumen ka svedočin mandar, golese kaj taro anglunipe sen mancar.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","O Isus vaćarda: “Kava vaćardem tumenđe te ma peren taro pačajipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ka ikalen tumen zauvek tari sinagoga, a avol o vreme kana dži jekh savo ka mudarol tumen ka dol gođi kaj golesa služil e Devle. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","A gova ka ćeren, golese kaj ni pindžarde ni e Dade ni man. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Kava vaćardem tumenđe, kana ka avol o vreme, te den tumen gođi kava so phendem tumenđe golestar.” Thaj vadži vaćarda o Isus: “Ni vaćardem tumenđe kava ko anglunipe, golese kaj sema tumencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Al akana džav Koleste ko bičhalda man thaj khoni tumendar ni pučol man: ‘Kaj dža?’ ");
INSERT INTO rmyGurbet_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Nego, golese kaj vaćardem gova tumenđe, tumare ile pherdile žal. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Al me vaćarav tumenđe o čačipe: pošukar tumenđe me te džav. Golese so, te me ni đeljem, o Zastupniko ni ka avol. Al te đeljem, ka bičhalav le tumenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","A kana vov ka avol, ka dokažil e manušenđe ano sveto so si čače o greh, o pravednost thaj o sudo. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Vov ka dokažil e manušenđe ano sveto kaj si ano greh golese kaj ni pačan ane mande. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ka dokažil lenđe kaj grešin ano dičhipe taro pravednost golese kaj džav ko Dad thaj odori vadži ni ka dičhen man. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Thaj ka dokažil lenđe ko sudo e Devleso golese kaj o vladari e svetoso si već osudimo. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Vadži but isi man so te vaćarav tumenđe, al akana gova našti inđaren. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Al kana ka avol vov, o Duxo e čačimaso, ka inđarol tumen ke sa o čačipe. Golese kaj ni ka vaćarol korkoro pestar, nego ka vaćarol kova so šunol. Vov ka objavil tumenđe i gova so ka avol. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Vov ka proslavil man golese kaj ka lol so si mingro thaj ka objavil tumenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Sa so isi e Dade, mingro si. Golese vaćardem tumenđe kaj ka lol so si mingro thaj ka objavil tumenđe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","O Isus vadži phenda: “Vadži zala thaj ni ka dičhen man. Thaj vadži zala thaj palem ka dičhen man.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Tegani nesave tare lese sikade lije te pučen jekh avere: “So značil gova so vaćarol amenđe: ‘Vadži zala thaj ni ka dičhen man. Thaj vadži zala thaj palem ka dičhen man’ thaj: ‘Me džav ko Dad’?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Pale gova vaćarde: “So značil gova so vaćarol: ‘Vadži zala’? Ni džana so manđol te phenol.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","O Isus džanglja so manglje te pučen le, golese vaćarda lenđe: “Pučen tumen jekh avere so značil gova so vaćardem: ‘Vadži zala thaj ni ka dičhen man. Thaj vadži zala thaj palem ka dičhen man’? ");
INSERT INTO rmyGurbet_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Čače, čače vaćarav tumenđe: tumen ka roven thaj ka tugujin, al o sveto ka radujil pe. Tumen ka aven žalna, al tumari žal ka ćerdol radujipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","I džuvli si žalosno kana bijanol golese kaj avilo o vreme tare laće dukha. Al kana bijandol o čhavoro, bistrol o pharipe golese kaj radujil pe so anda e manuše ko sveto. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Gija i tumen sen akana ani žal, al me ka dikhav tumen palem thaj tumare ile ka radujin pe. Thaj khoni našti te lol tumendar tumaro radujipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ane gova đive khanči ni ka pučen man. Čače, čače vaćarav tumenđe: sa so ka roden taro Dad ane mingro alav, vov ka dol tumenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Dži akana khanči ni rodijen ane mingro alav. Roden thaj ka dobin, gija tumaro radujipe te avol pherdo!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Gova vaćardem tumenđe ane slike. Al avol o vreme kana vadži ni ka vaćarav tumenđe ane slike, nego putarde ka vaćarav tumenđe taro Dad. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ane gova đive ka roden e Dade ane mingro alav. Ni vaćarav tumenđe kaj me ka moliv e Dade tumenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Golese kaj o Dad korkoro manđol tumen golese kaj tumen mangljen man thaj pačajen kaj me ikliljem taro Dol. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Me ikliljem taro Dad thaj aviljem ke kava sveto. Akana ačhavav kava sveto thaj džav ko Dad.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Tegani lese sikade vaćarde: “Akh, akana vaćare putarde thaj ni phene ane slike. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Akana džana kaj naj potreba khoni te pučol tut khanči golese kaj tu angleder sa džane. Golese pača kaj ikliljan taro Dol.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","O Isus vaćarda lenđe: “Akana pačan? ");
INSERT INTO rmyGurbet_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Akh, avol o vreme – thaj akana avilo – kana dži jekh tumendar ka našol ko kaj dičhol, a man ka ačhaven korkore. Al me naj sem korkoro, golese kaj o Dad si mancar. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Kava vaćardem tumenđe, te avol tumen ane mande mir. Ano sveto ka avol tumen patnje, al ohrabrin tumen – me pobedisadem o sveto!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Kana kava vaćarda o Isus, vazdija pe jakha premal o nebo thaj vaćarda: “Dade, avilo o vreme! Proslavi ćire Čhave, te šaj o Čhavo proslavil tut. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Golese so, tu dijan le vlast pe sa e manuša, te dol džuvdipe bizo meripe, savoren saven tu dijan le. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","A o džuvdipe bizo meripe si kava: te pindžaren tut, jekhe čačukane Devle thaj e Isuse Hriste kas bičhaldan. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Me tut proslavisadem ki phuv gija so završisadem i bući savi dijan man te ćerav. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Akana, Dade, proslavi man ke tute, slavasa savi sasa man ke tute angleder so ćerdilo o sveto.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Objavisadem ćiro alav kolenđe saven dijan man tare kava sveto. Sesa ćire thaj tu dijan len manđe thaj von ićarde ćiro Lafi. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Akana džanen kaj sa so dijan man avol tutar. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Golese kaj dijem len ćire lafura save tu dijan man, a von len prihvatisade thaj pindžarde kaj si čače kaj me aviljem tutar thaj pačaje kaj tu bičhaldan man. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Lenđe me moliv. Ni moliv pašo sveto, nego paše kola saven tu dijan man golese kaj si ćire. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Sa so si mingro, si ćiro thaj sa so si ćiro si mingro, a me ane lende proslavisaljem. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Me naj sem vadži ko sveto, al von si ano sveto thaj me avav tute. Dade Svetoneja, arakh len ane ćiro alav savo dijan man, te aven jekh sar so sam i amen jekh. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Dži kaj sema lencar, arakhljem len ane ćiro alav, savo dijan man. Arakhljem len thaj nijekh lendar ni hasajlo, osim kova so sasa osudimo za ko propast, te bi pherdola o Sveto lil. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Akana avav ke tute, al kava vaćarav dži kaj sem vadži ano sveto, te bi i len avola pherdo radost savo man isi. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Me dijem len ćiro Lafi thaj o sveto zamrzisada len golese kaj ni pripadin e svetose, sar so me ni pripadiv e svetose. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ni moliv tut te le len taro sveto, nego te aračhe len taro Bilačho. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Von ni pripadin e svetose, sar so me naj sem taro sveto. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Posveti len ćire čačimasa – ćiro Lafi si čačipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Sar so tu man bičhaldan ano sveto, gija i me len bičhalav ano sveto. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Predav man te služiv tut baše lende, te bi i von avena posvetime te služin tut ano čačipe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Al ni moliv man samo lenđe, nego thaj sa kolenđe save ka pačan prekalo lengo haberi ane mande, ");
INSERT INTO rmyGurbet_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","te bi avena savore jekh. Sar so san tu Dade ane mande thaj me ane tute, gija von nek aven ane amende, o sveto te bi pačala kaj tu bičhaldan man. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Me predijem lenđe i slava, savi tu dijan man, te aven jekh sar so sam amen jekh – ");
INSERT INTO rmyGurbet_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","me ane lende thaj tu ane mande – te aven savršeno katane, te bi o sveto džanola kaj tu man bičhaldan thaj kaj len mangljan sar so man mangljan. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Dade, mangav, i kolen so dijan man te aven mancar gothe kaj sem me, thaj te dičhen mingri slava, savi dijan man, golese kaj tu mangljan man angleder nego so ćerdilo o sveto. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Dade pravednoneja, o sveto ni pindžarol tut, al me pindžarav tut. Thaj i kala pindžarde kaj tu bičhaldan man. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Me lenđe objavisadem ćiro alav thaj ka objaviv le vadži, te bi o manglipe savesa mangljan man avola ane lende thaj me ane lende.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Kana o Isus završisada i molitva, nakhlo pe sikadencar ki dujto rig tari Kedronesi dolina. Gothe sasa vrt thaj đele ane leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Al kava than džanglja i o Juda leso izdajniko, golese kaj o Isus but droma ćidija pe gothe pe sikadencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Tegani o Juda lija e rimskone četa thaj e hramese stražaren save sesa bičhalde tare šorutne sveštenikura thaj tare fariseja thaj avile ano vrt. Pesa ande svetiljke, baklje thaj oružje. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","O Isus, golese kaj džanglja sa so ka avol lesa, iklilo thaj vaćarda lenđe: “Kas roden?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Vaćarde lese: “E Isuse taro Nazaret.” O Isus vaćarda lenđe: “Me sem!” Ačhilo gothe lencar o Juda leso izdajniko. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Kana o Isus phenda: “Me sem!”, crdije pe palal thaj pele ki phuv. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Tegani o Isus pučlja len palem: “Kas roden?” Von vaćarde lese: “E Isuse taro Nazaret.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","O Isus phenda lenđe: “Phendem tumenđe: Me sem. Te rodijen man, mučhen kala avera nek džan!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Kava vaćarda te pherdol gova so angleder vaćarda: “Dade, ni hasardem nijekhe kolendar so dijan man.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Tegani o Simon Petar savo sasa le čhuri, ikalda la thaj čalada e sluga e bare sveštenikose thaj čhinda leso desno kan. E slugaso alav sasa Malho. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","O Isus vaćarda e Petrese: “Iri i čhuri palal! O tahtaj e patimaso savo dija man mingro Dad te ma li pijav?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tegani i rimsko četa, lengo šorutno thaj e hramese stražara dolde e Isuse thaj phanglje le ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","thaj inđarde le ko Ana, o sastro e Kajafaso savo sasa baro svešteniko gova berš. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","O Kajafa sasa kova savo angleder sikada e Jevrejskone šorutnenđe kaj si pošukar jekh manuš te merol bašo sa o narodo. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Palo Isus đele o Simon Petar thaj jekh aver sikado. Gova o dujto sikado džanglja pe e bare sveštenikosa, golese šajine te džal ani avlin katane e Isusesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Al gothar o Petar ačhilo avral angli kapija. Tegani iklilo kova dujto sikado kas o baro svešteniko džanglja thaj vaćarda kole sluškinjaće te mučhol andre e Petre. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Tegani pučlja i sluškinja e Petre: “Naj li san tu jekh tare sikade kole manušese?” O Petar vaćarda: “Naj sem!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","A e sluge thaj e stražara phabarde jag taro angar thaj ačhile gothe te taton, golese kaj sasa šul. Thaj o Petar ačhilo lencar te tatol. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","O baro svešteniko pučlja e Isuse baše lese sikade thaj tare leso sikajipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","O Isus vaćarda lese: “Me vaćardem putarde sa e manušenđe. Uvek sikadem ane sinagoge thaj ano Hram, kaj ćiden pe sa e Jevreja thaj khanči ni vaćardem garandoj. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Sose puče man? Puč kolen save šunde so vaćardem lenđe. Von džanen so vaćardem!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Kana o Isus kava vaćarda, jekh tare stražara savo gothe ačhilo, čalada le ki čham thaj vaćarda: “Gija li vaćarol pe e bare sveštenikosa?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","O Isus irisada lese vaćarindoj: “Te vaćardem khanči bilačhe, dokaži manđe so si gova! Al te vaćardem čačipe, sose čalave man?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Tegani o Ana bičhalda e phangle Isuse ko Kajafa, savo sasa baro svešteniko. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","O Simon Petar ačhilo gothe thaj tatilo. Avera pučlje le: “Naj li san i tu jekh tare lese sikade?” Vov xoxada thaj vaćarda: “Naj sem!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Jekh sluga taro baro svešteniko savo sasa familija kolese kaso kan o Petar čhinda, vaćarda: “Ni li dikhljem tut lesa ano vrt?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","A o Petar palem xoxada thaj sigate o bašno đilabija. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Tegani e Isuse inđarde tare Kajafaso čher ani palata e rimskone upraviteljesi. Sasa rano sabalje. Al von ni đele ani palata e rimskone upraviteljesi te ma bi meljarena pe palo adeti, a te bi šajine te xan i pashalno večera. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","O Pilat tegani iklilo angle lende thaj pučlja: “Za ke so optužin kale manuše?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Phende e Pilatese: “Kana ne bi ćerola bilačhipe, ne bi anasa le tute.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","O Pilat vaćarda lenđe: “Len le tumen thaj sudin le pale tumaro zakon.” E Jevreja vaćarde lese: “Amen našti khanika te mudara!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Kava sasa te bi pherdona e Isusese lafura, save vaćarda angleder, save merimasa ka merol. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Tegani irisajlo o Pilat andre ani pi palata, akharda e Isuse andre thaj pučlja le: “Tu li san o caro e Jevrejengo?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","O Isus vaćarda lese: “Vaćare li gova korkoro tutar, il avera gova vaćarde tuće mandar?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","O Pilat palem pučlja le: “Me li sem Jevrejo? Ćiro narodo thaj e šorutne sveštenikura dije tut mande. So ćerdan?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","O Isus vaćarda: “Mingro Carstvo naj tare kava sveto. Kana bi mingro Carstvo avola tare kava sveto, tegani bi mingre sluge branina man te ma dolen man e Jevrejska šorutne. Al mingro Carstvo naj katar.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pe gova vaćarda lese o Pilat: “Znači gija, tu san caro?” O Isus vaćarda lese: “Tu vaćare kaj me sem caro. Me golese bijandiljem thaj aviljem ko sveto te svedočiv taro čačipe. Dži jekh savo si taro čačipe šunol mingro glaso.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","O Pilat pučlja le: “So si čačipe?” Kana vaćarda kava o Pilat, iklilo palem angle Jevrejska šorutne thaj vaćarda lenđe: “Me ni arakhav khanči sose bi optuživa le. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Al tumende si adeti te mukhav tumenđe jekhe phangle ki Pasha. Manđen li te mukhav tumenđe e caro e Jevrejengo?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Al von pe gova dije vika: “Na le! Mukh e Varava!” Al o Varava sasa razbojniko. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Tegani o Pilat naredisada te šibin e Isuse. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","E vojnikura khuvde venco tare kangre thaj čhute e Isusese ko šoro thaj učharde le purpurno ogrtači. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Tegani lije te aven angle leste thaj vaćarde: “Te ave sasto, carona e Jevrejengo!” Thaj čalade le pe čhama. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pale gova o Pilat palem iklilo thaj vaćarda kole manušenđe: “Akh, akana ka ikalav le avral ke tumende, te džanen kaj me pe leste ni arakhav khanči sose bi optuživa le.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Tegani o Isus iklilo avri, urado ano purpurno ogrtači thaj pe leso šoro sasa venco tare kangre, a o Pilat vaćarda lenđe: “Akh, o manuš!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Kana dikhlje le e šorutne sveštenikura thaj e stražara, lije te den vika: “Čhuv le ko krsto! Čhuv le ko krsto!” Al o Pilat vaćarda lenđe: “Len le tumen thaj čhuven le ko krsto, golese kaj me pe leste ni arakhav khanči sose bi optuživa le.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","E Jevrejska šorutne irisade lese: “Amen isi Zakon thaj palo gova Zakon trubul te merol, golese so vaćarda kaj si Čhavo e Devleso.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Kana o Pilat šunda kava, darajlo vadži pobut. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Palem đelo ani palata thaj pučlja e Isuse: “Kotar san tu?” Al o Isus khanči ni phenda. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Tegani o Pilat pučlja le: “Dal khanči ni manđe te vaćare? Džane li kaj isi man vlast te mukhav tut il te čhuvav tu ko krsto?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","O Isus phenda lese: “Ne bi avola tut nisavo vlast pe mande te ni dol pe tuće odupral. Golese, po baro greh isi kole savo dija man tute.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Od tegani o Pilat dikhlja pobut te mučhol e Isuse, al e Jevrejska šorutne dije vika: “Te mukhljan kale, naj san amal e rimskone carose! Dži jekh savo pes ćerol caro protivil pe e rimskone carose.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Kana kava šunda o Pilat, ikalda e Isuse avral, bešlo ki sudsko stolica, ko than savo si taro bar thaj akhardol Litostrotos, jevrejski Gavata. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","A sasa đive baše pripreme angli Pasha pašo dešuduj (12) o sato. O Pilat vaćarda e Jevrejenđe: “Akh, tumaro caro!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pe gova e Jevreja lije te den vika: “Inđaren le! Inđaren le! Čhuven le ko krsto!” O Pilat phenda lenđe: “So manđen, tumare caro te čhuvav ko krsto?” E šorutne sveštenikura vaćarde lese: “Amen naj caro sem o rimsko caro.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Tegani dija o Pilat e Isuse ke vojnikura te čhuven le ko krsto. E vojnikura tegani lije e Isuse. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","O Isus korkoro inđarda po krsto ko than savo akhardola Kokalo e šoreso, jevrejski Golgota. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Gothe čhute e Isuse ko krsto thaj lesa i averen dujen – jekhe tari jekh rig thaj avere tari dujto rig, a e Isuse maškaral. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","O Pilat pisisada ki ploča thaj dija te čhuven gova ko krsto. Pi ploča sasa pisimo: “O Isus taro Nazaret, caro e Jevrejengo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","But Jevreja čitisade o pisipe pi ploča, golese kaj o than kaj čhute e Isuse ko krsto sasa pašo foro. Gova sasa pisimo ki jevrejsko, ki latinsko thaj ki grčko čhib. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","E jevrejska šorutne sveštenikura phende e Pilatese: “Ma pisi ‘caro e Jevrejengo’, nego ‘kava manuš phenda me sem caro e Jevrejengo.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Al o Pilat phenda: “So pisisadem, pisisadem.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Kana e vojnikura čhute e Isuse ko krsto, lije lese šeja thaj ulade len maškar peste ke štar kotora, so štarenđe po jekh kotor. Lije i leso gad savo naj sasa suvdo, nego sasa khuvdo ane jekh kotor odupral natele. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Golese phende maškar peste: “Pošukar ma te pharava le! Ajde ka čhuda kocka baše kava gad. Ko pobedil, leso ka avol.” Kava sasa te bi pherdola kova so si pisimo ano Sveto lil: “Mingre šeja ulade maškar peste, thaj baše mingro gad čhudije kocka.” Thaj e vojnikura ćerde gija. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Pašo krsto e Isuseso ačhile lesi dej, i phen lese daći i Marija e Kleopesi romni thaj i Marija Magdalena. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Kana o Isus dikhlja pe da thaj paše late e sikade save but manglja, phenda pe daće: “Džuvlije, ake tuće čhavo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Pale gova phenda e sikadese: “Ake tuće dej!” Thaj tare gova sato o sikado lija la ane po čher. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Pale gova, o Isus džanglja kaj pherdilo sa so trubuja te avol pa vaćarda te bi pherdola o Sveto lil: “Trošalo sem!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Gothe sasa jekh čaro pherdo šut. Gija e vojnikura čhute ke izopeso kaš o sunđeri ćinđardo šutesa thaj čhute le paše leso muj. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Kana pilja o Isus o šut, vaćarda: “Sa si ćerdo!” Tegani perada po šoro thaj mukhlja po duxo. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Golese kaj sasa đive baše pripreme, e Jevrejska šorutne molisade e Pilate te phađen e pingre kolenđe save sesa ko krsto thaj te bi uljarena len tare krstura te ma bi ačhola o telo ko krsto ko savato, golese kaj gova savato sasa Prazniko – Pasha. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Tegani avile e vojnikura thaj phaglje e pingre anglune manušese thaj pale gova i e dujtone manušese, save sesa ko krsto pašo Isus. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Al kana avile dži ko Isus thaj dikhlje kaj mulo, ni phaglje lese pingre. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Umesto gova, jekh tare vojnikura e kopljesa pusada lese pašavre. Gothar sigate thavdija rat thaj paj. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Kova so gova dikhlja, svedočil tare gova thaj leso svedočanstvo si čačukano. Vov džanol kaj vaćarol čačipe thaj svedočil te bi i tumen pačana. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Kava sasa te bi pherdola kova so si pisimo ano Sveto lil: “Ni jekh kokalo leso ni ka phađol.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","A ko aver than o Sveto lil phenol: “Ka dičhen kole save pusade.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Pale gova o Josif tari Arimateja rodija taro Pilat te uljarol taro krsto e Isuseso telo. O Josif sasa e Isuseso sikado, al na javno, golese kaj darajlo tare Jevrejska šorutne. O Pilat mukhlja le te lol e Isuseso telo. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Lesa avilo i o Nikodim, savo angleder avilo ko Isus raćasa. Vov pesa anda paše tranda (30) kila mešime smirna thaj aloja. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Lije e Isuseso telo thaj paćarde le čaršafesa savo makhle mirisesa, sar si o adeti ke Jevreja kana prahon. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","A paše gova than kaj sasa o Isus čhuto ko krsto, sasa jekh vrt thaj ane gova vrt sasa jekh nevo limori, ane savo khoni vadži naj sasa prahome. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","A sar sasa jevrejsko đive tare pripreme, trubuje te siđaren, a gova limori sasa paše, pa čhute e Isuseso telo ane gova than. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sabalin rano ko angluno đive ano kurko, kana vadži ni đivesajlo, avili ko limori i Marija taro gav i Magdala thaj dikhlja kaj si o bar crdimo taro ulaz e limoreso. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Tegani prastija thaj avili ko Simon Petar thaj ke aver sikado kas o Isus but manglja thaj vaćarda lenđe: “Inđarde e Gospode andaro limori thaj ni džana kaj čhute le!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Gija o Petar thaj kova aver sikado iklile thaj đele premalo limori. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Solduj džene prastije katane thaj o dujto sikado prastija posigate taro Petar thaj avilo ko limori angleder. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Banđilo thaj dikhlja andre e čaršafura taro lan kaj pašljon odori, al ni đelo andre. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Tegani avilo pale leste i o Simon Petar thaj đelo andre ano limori thaj dikhlja e čaršafura kaj pašljon odori, ");
INSERT INTO rmyGurbet_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","thaj o kotor savo učharda e Isuseso šoro. Al gova kotor ni pašljola e čaršafurencar, al sasa čhuto ki rig paćardo. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tegani andre avilo i o dujto sikado, kova so reslo ko limori angleder thaj dikhlja thaj pačaja. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Golese kaj vadži ni haljarde e Sveta lila kaj o Isus trubul te uštol tare mule. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Pale gova e sikade irisajle ke avera sikade. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","A i Marija ačhola avral pašo limori thaj ruja. Thaj sar ruja, čhudija pe jakha andre ano limori ");
INSERT INTO rmyGurbet_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","thaj dikhlja duje anđeluren urade ane parne fostanura sar bešen po than kaj angleder sasa o telo e Isuseso – jekh kaj trubuja te avol leso šoro, dujto kaj sesa lese pingre. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","E anđelura pučlje la: “Džuvlije, sose rove?” Voj phenda lenđe: “Lije mingre Gospode thaj ni džanav kaj čhute le.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Kana gova vaćarda, irisajli thaj dikhlja e Isuse sar gothe ačhol, al ni pindžarda kaj si gova o Isus. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Pučlja la o Isus: “Džuvlije, sose rove? Kas rode?” I Marija dija gođi kaj si gova o manuš savo ćerol bući ano vrt, golese vaćarda lese: “Manušeja, te inđardan le tu, phen manđe kaj čhutan le thaj me ka lav le.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","O Isus phenda laće: “Marijo!” Voj irisajli thaj jevrejski vaćarda lese: “Rabbuni!” (So značil “Učitelju”.) ");
INSERT INTO rmyGurbet_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Vaćarda laće o Isus: “Ma but zadrži man, golese kaj vadži ni đeljem ke mingro Dad. Nego dža ke mingre phrala thaj vaćar lenđe: ‘Džav upre ke mingro Dad thaj ke tumaro Dad, ke mingro Dol thaj ke tumaro Dol.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","I Marija Magdalena đeli ke sikade thaj phenda lenđe: “Dikhljem e Gospode.” Thaj vaćarda lenđe sa so o Isus phenda laće. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ki rat ko angluno đive taro kurko, kana e sikade sesa katane thaj o vudar sasa phanglo golese kaj e sikade darana tare Jevrejska šorutne, tari jekh drom avilo o Isus thaj ačhilo maškar lende thaj vaćarda lenđe: “Mir tumenđe!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Kana kava vaćarda, sikada lenđe e ožiljkura ke vasta thaj ke pašavre. Tegani e sikade sesa radosna so dikhlje e Gospode. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","A palem o Isus phenda lenđe: “Mir tumenđe! Sar so o Dad bičhalda man, gija i me bičhalav tumen.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Thaj sar kava vaćarda, phurdija ane lende thaj vaćarda lenđe: “Primin o Sveto Duxo! ");
INSERT INTO rmyGurbet_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Kase tumen ka oprostin e grehura, lenđe si oprostime, a kase tumen ni ka oprostin e grehura, lenđe naj oprostime e grehura.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","O Tomo kas akharde Bliznako, jekh tare Dešuduj (12) sikade, ni sasa lencar kana avilo o Isus. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Avera sikade vaćarde lese: “Dikhljam e Gospode!” Al vov phenda lenđe: “Ni ka pačav dži kaj ni dikhav e ožiljkura tare eksera ke lese vasta thaj dži kaj čhuvav me naja ane lende, thaj dži kaj ni čhuvav mingre naja pe lese ožiljkura ke pašavre.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Pale ohto đive, palem sesa e sikade katane andre ano čher thaj sasa lencar i o Tomo. Iako o vudar sasa phanglo, avilo o Isus andre thaj ačhilo maškar lende thaj vaćarda: “Mir tumenđe!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Pale gova phenda e Tomose: “Čhuv ćiro naj kate thaj dikh mingre vasta. Ispruži ćiro va thaj čhuv ane mingre pašavre. Ma vadži te sumnji, nego pača.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","O Tomo phenda lese: “Mingro Gospod thaj mingro Dol!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","O Isus vaćarda lese: “Golese kaj dikljan man, pačajan. Blagoslovime si kola save ni dičhen, a pačan.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Thaj but avera čudesna znakura ćerda o Isus angle pe sikade save naj pisime ane kava lil. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Al kava si pisime te bi pačana kaj o Isus si o Hrist, o Čhavo e Devleso thaj pačajindoj te šaj avol tumen džuvdipe ane leso alav. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Pale gova palem sikadilo o Isus pe sikadenđe ko Tiverijadsko more. A sikadilo gija: ");
INSERT INTO rmyGurbet_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Sesa katane o Simon Petar, o Tomo kas akharde Bliznako, o Natanailo tari Kana i Galilejsko, e čhave e Zevedijase thaj avera duj džene tare lese sikade. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","O Simon Petar phenda lenđe: “Džav te dolav mačhen.” Von vaćarde lese: “Ka dža i amen tusa.” Tegani iklile thaj bešle ano čamco, al ane goja rat khanči ni dolde. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Kana sasa rano sabalje, ačhilo o Isus ki obala, al e sikade ni pindžarde kaj si gova o Isus. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Tegani o Isus pučlja len: “Amalalen, isi li tumen mačhe xamase?” Phende lese: “Naj amen.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","A vov vaćarda lenđe: “Čhuden i mreža ki desno rig taro čamco thaj ka dolen mačhe.” Gija i ćerde. Al naštine te ikalen i mreža tare but mačhe save dolde. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Tegani o sikado, save o Isus but manglja, phenda e Petrese: “Kava si o Gospod!” Kana o Simon Petar šunda kaj gova si o Gospod, phanglja pe zurale e fostanesa, golese kaj ni sasa but urado thaj hutija ano more. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","I avera sikade avile e čamcosa, golese kaj ni sesa dur tari obala, paše šel (100) metra thaj crdije i mreža pale peste e mačhencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Kana iklile ki phuv, dikhlje phabardi jag taro angar thaj pe late pećona e mačhe thaj o mangro. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","O Isus vaćarda lenđe: “Anen zala tare gola mačhen saven dolden.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Tegani o Simon Petar đelo ano čamco thaj ikalda ki obala i mreža pherdi bare mačhencar thaj ane late sesa šelupinda thaj trin (153) mačhe. Thaj iako sesa gaći mačhe, i mreža ni pharadili. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","O Isus phenda lenđe: “Aven te xan.” Al nijekh sikado ni tromaja te pučol le: “Ko san tu?” Golese so džanglje kaj si gova o Gospod. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Tegani avilo o Isus, lija o mangro thaj dija len, a gija ćerda i e mačhencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Kava sasa trito drom kana o Isus sikadilo pe sikadenđe sar uštilo tare mule. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Kana xalje, pučlja o Isus e Simone Petre: “Simone, čhaveja e Jovaneso, manđe li man pobut tare kala aver manuša?” O Petar vaćarda lese: “Va, Gospode, tu džane kaj mangav tut.” O Isus phenda lese: “Čarav mingre bakroren.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Tegani pučlja le o Isus dujto drom: “Simone, čhaveja e Jovaneso, manđe li man?” Phenda lese o Petar: “Va Gospode. Tu džane kaj mangav tut.” O Isus vaćarda lese: “Arakh mingre bakren.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Tegani pučlja le o Isus trito drom: “Simone, čhaveja e Jovaneso, manđe li man?” O Petar sasa žalno so pučol le o Isus trito drom: “Manđe li man?” Golese vaćarda lese: “Gospode, tu džane sa. Tu džane kaj me mangav tut.” O Isus phenda lese: “Čarav mingre bakren. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Čače, čače vaćarav tuće: kana sana terno, korkoro phangljan ći kuštik thaj phirdan kaj mangljan. Al kana ka phuravo, ka ispruži ćire vasta thaj avera ka phanden tut thaj ka inđaren tut kaj ni manđe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Kava vaćarda lese te sikavol lese save merimasa o Petar ka proslavil e Devle. Kana vaćarda kava, phenda lese: “Av pale mande!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","O Petar irisajlo thaj dikhlja kaj džal pale leste kova kas o Isus but manglja thaj savo ki večera nakhlo po paše pašo Isus thaj pučlja le: “Gospode, ko ka izdajil tut?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Kana dikhlja le o Petar, pučlja e Isuse: “Gospode, so ka avol kale manušesa?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","O Isus phenda lese: “Te mangljem vov te ačhol sa dok me ni avav, so isi tut golesa? Tu av pale mande!” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Golese iklilo lafi maškare phrala kaj kava sikado ni ka merol. Al o Isus ni vaćarda kaj kava sikado ni ka merol, nego vaćarda: “Te mangljem vov te ačhol sa dok me ni avav, so isi tut golesa?” ");
INSERT INTO rmyGurbet_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Kava si gova sikado savo svedočil tare sa thaj sa kava pisisada. Amen džana kaj si čačukano leso svedočipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Al isi vadži but so ćerda o Isus thaj kana bi sa redasa pisila pe, misliv kaj bi celo sveto avola cikno paše lila ane save bi avola pisimo sa gova!");
INSERT INTO rmyGurbet_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Mangleja Teofile, ano angluno lil pisisadem tuće tare sa so o Isus lija te ćerol thaj te sikavol ");
INSERT INTO rmyGurbet_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","dži o đive kana sasa vazdimo ko nebo. Angleder gova e apostolurenđe saven birisada dija uputstvura prekalo Sveto Duxo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Vadži saranda (40) đive palo đive kana uštilo tare mule, o Isus sikada kaj si džuvdo bute dokazurencar. Thaj vaćarda lenđe taro Carstvo e Devleso. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Jekh đive dži kaj xalja mangro lencar naredisada lenđe: “Ma ikljen andaro Jerusalim, al ađućaren kova so obećisada mo Dad, so šunden mandar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Golese kaj o Jovane krstisada pajesa, al tumen ka aven kala đivesa krstime e Svetone Duxosa.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Tegani kola save sesa ćidime pašo Isus pučlje le: “Gospode, manđe li akana te obnovi o Carstvo e Izraeleso?” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","A o Isus vaćarda lenđe: “Naj tumaro te džanen o vreme thaj e đivesa save o Dad odredisada pe vlastesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Al akana tumen ka primin o zuralipe kana ka uljol pe tumende o Sveto Duxo thaj ka aven mingre svedokura ano Jerusalim, pi sa i Judeja thaj i Samarija thaj sa dži ko krajo e phuvako.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Kana kava vaćarda, sasa vazdimo ko nebo angle lenđe jakha thaj o oblako učharda le thaj vadži ni dikhlje le. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Kana vadži lenđe jakha sesa premal o nebo, dži kaj o Isus džala, tare jekh drom ačhile angle lende duj džene ane parne šeja, ");
INSERT INTO rmyGurbet_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","save vaćarde: “Manušalen tari Galileja, sose ačhen thaj dičhen ano nebo? Kava Isus savo sasa vazdimo tumendar ko nebo, ka avol gija sar so dikhljen kaj džal ko nebo!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Tegani e apostolura irisajle ano Jerusalim taro brego savo akhardol Maslinsko, savo si taro Jerusalim dur jekh kilometro. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Kana resle ano foro, đele ani upruni soba kaj bešle. A gothe sesa o Petar, o Jovan, o Jakov, o Andrija, o Filip, o Tomo, o Vartolomej, o Matej, o Jakov e Alfejeveso čhavo, o Simon o Zilot thaj o Juda e Jakoveso čhavo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Savore bizo ačhipe molisajle thaj sesa katane thaj jednodušna, a gothe sesa lencar nesave džuvlja thaj i Marija i dej e Isusesi thaj lese phrala. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ane gola đivesa uštilo o Petar maškare sikade – ćidije pe paše šelubiš (120) manuša – thaj vaćarda: ");
INSERT INTO rmyGurbet_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Phralalen! Trubuja te pherdol o Sveto lil ane savo o Sveto Duxo angleder vaćarda andare Davideso muj pašo Juda, savo anda kolen save dolde e Isuse. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Golese kaj vov sasa jekh amendar thaj sasa le kotor tare kaja bući.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Parencar save dobisada paše piro bilačhipe, o Juda ćinda njiva, al gothe pelo ko šoro, leso telo pharilo ko maškar thaj sa lese pora iklile. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Gova džanen savore save bešen ano Jerusalim, golese gole njivaće dije alav Akeldamah, so ki lenđi čhib značil “Ratvali njiva”.) ");
INSERT INTO rmyGurbet_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Golese kaj ane psalmura si pisime: ‘Te avol pusto leso čher thaj khoni ma te bešol ane leste!’, thaj si vadži pisime: ‘Lesi služba te lol neko aver.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Golese trubul te biri jekhe tare kala manuša save sesa amencar sa o vreme kana o Gospod o Isus živisada maškar amende, ");
INSERT INTO rmyGurbet_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","taro đive kana o Jovane počnisada te krstil dži o đive kana amendar đelo o Isus ano nebo. Jekh tare kala trubul te avol svedoko tare leso uštipe tare mule katane amencar.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Gija predložisade dujen: e Josife save akharde Varsava (kas akharde i Just) thaj e Matija. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Tegani molisajle e Devlese vaćarindoj: “Tu, Gospode, pindžare e ile savorenđe. Sikav amenđe save tare kala duj birisadan, ");
INSERT INTO rmyGurbet_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","te prelol kaja apostolsko služba, savi ačhada o Juda, te bi džala kaj si leso than.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Tegani čhudije kocka baše lende thaj i kocka peli po Matija. Gija vov priključisajlo e dešujekhe (11) apostolurenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Kana avilo o đive i Pedesetnica – pinda (50) đive pali Pasha, savore sesa katane ko jekh than. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tari jekh drom šundilo zvuko taro nebo sar kana phurdol bari balval thaj i balval pherda sa o čher kaj bešle. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Tegani sikadile lenđe sar jagale čhiba save uladile thaj ulile pe svakoneste po jekh. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Pherdile savore Svetone Duxosa thaj lije te vaćaren avere čhibencar, sar lenđe o Duxo dija te vaćaren. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ano Jerusalim sesa devlikane Judejcura save avile tare sa e narodura talo nebo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Kana šunde gova zvuko, ćidije pe e manuša. Sesa zbunime, golese kaj dži jekh šunda kaj e sikade vaćaren ke lesi čhib. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Divisajle thaj čudisajle. Jekh avere pučlje: “Dikh, naj li sa kala manuša so vaćaren tari Galileja? ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Sar onda amen savore šuna sar vaćaren ki amari čhib kaj sam bijande? ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Maškar amende si e Parćanura, e Međanura, e Elamcura, e manuša andari Mesopotamija, andari Judeja thaj andari Kapadokija, andari Ponta thaj andari Cikni Azija, ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","andari Frigija thaj andari Pamfilija, andaro Egipat thaj tare Libijska phuva paši Kirina, putnikura andaro Rim ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","(e Jevreja thaj e manuša save irisade pe ko jevrejsko pačajipe), e manuša taro Krit thaj Arapura. Amen savore šuna len sar vaćaren ke amare čhiba tare bare buća e Devlese!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Savore divisajle thaj sesa zbunime thaj jekh avere pučlje: “So kava značil?” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Al avera asaje thaj vaćarde: “Gugli mol pilje. Von matile!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","O Petar iklilo katane e dešujekhe (11) apostolurencar thaj zurale vaćarda e manušenđe: “Manušalen, Jevrejonalen thaj savore save bešen ano Jerusalim! Šukar šunen me lafura thaj kava te džanen: ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Kala manuša naj mate sar so tumen den gođi, golese kaj si enja o sato ki sabalin. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Nego kava si gova so vaćarda o proroko o Joilo: ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Vaćarol o Gospod: ‘Ane palune đivesa ka čhuvav mingro Duxo pe sa e manuša. Tumare čhave i čheja ka prorokujin, tumare terne ka dičhen vizije thaj tumare purane ka dičhen sune. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ane gola đivesa ka čhuvav mingro Duxo pe me sluge thaj pe me sluškinje, thaj ka prorokujin. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ka sikavav e čudura upre ko nebo thaj znakura tele ki Phuv: rat, jag thaj oblako taro čuro. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","O kham ka ćerdol kalo thaj o čhon sar rat lolo angleder so avol o baro thaj veličanstveno Đive e Gospodeso. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Thaj dži jekh savo rodol e Gospodeso alav, ka avol spasimo.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Izraelcuralen, šunen kala lafura: O Isus o Nazarećanino sasa manuš save o Dol potvrdisada maškare tumende zorasa thaj čudurencar thaj znakurencar save ćerda o Dol prekal leste tumenđe, sar so džanen i korkore. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Gova manuš o Isus, sasa predajimo ane tumare vasta e Devlese odlukasa thaj e Devlese anglune zamislime planesa. Tumen, ano pomoć e abandžijengo, kovisaden le ko krsto thaj mudarden le. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Al o Dol vazdija le tare mule thaj oslobodisada le tare dukha e merimase, golese kaj naštine o meripe te ićarol le. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Golese o David vaćarol lestar: ‘Dikhav kaj si o Gospod uvek angle mande, golese kaj ačhol paše mi desno rig te ma perav. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Golese mingro ilo radujil pe thaj mi čhib dol vika taro radost, čak i mingro telo ka avol ani nada, ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","golese kaj ni ka ačhave mingri duša ano sveto e mulengo, ni ka mučhe ćiro Sveco te ćernjol. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Sikadan manđe e droma e džuvdimase thaj ka phere man baxtasa anglo ćiro prisutnost.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Phralalen, putarde thaj čače šaj vaćarav tumenđe kaj amaro paradad o David mulo, sasa prahome thaj leso limori si maškar amende dži kava đive. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Al o David sasa proroko thaj džanglja kaj o Dol sovljasa vaćarda lese kaj jekhe tare lese potomkura ka čhuvol ke leso presto. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Vov angleder gova dikhlja thaj phenda tare Hristeso uštipe tare mule: ‘ni ačhada le ano sveto e mulengo thaj leso telo ni ćernilo’. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Kava proročanstvo vaćarol taro Isus save o Dol vazdija tare mule a amen savore gova dikhljam. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","O Dol vazdija e Isuse ko počasno than ki desno rig thaj primisada taro Dad e Svetone Duxo savo sasa lese obećimo. Vov čhuta pe amende kava so akana dičhen thaj šunen. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Golese kaj o David ni uštilo ko nebo, a vov korkoro phenda: ‘Vaćarda o Gospod e Gospodese mingrese: Beš manđe ki desno rig, ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","sa dži kaj ni čhuvav ćire dušmajen tale ćire pingre.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Golese šukar te džanol sa o Izraelsko narodo kaj gole Isuse kas tumen čhuten ko krsto, o Dol ćerda te avol Gospod thaj Hrist.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Kana kava šunde e manuša, dukhaja len ano ilo thaj pučlje e Petre thaj avere apostoluren: “Phralalen, so te ćera?” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","O Petar phenda lenđe: “Pokajin tumen tare tumare grehura thaj savore te krstin tumen ano alav e Isuseso e Hristeso. Gija tumare grehura ka aven oprostime thaj ka primin e Svetone Duxo sar poklon. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Golese gova obećanje si tumenđe thaj tumare čhavenđe thaj sa e durutnenđe saven ka dol vika ke peste o Gospod, o Dol amaro.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Thaj bute avere lafurencar opomenisada thaj molisada len vaćarindoj: “Spasin tumen taro sudo savo avol pe kava rumimo bijandipe!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Tegani krstisajle kola save pačaje o lafi. Gija ane gova đive paše trin milje (3 000) duše pridružisajle e pačavnenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ačhile ustrajna ano sikajipe e apostolurengo, ano ćidinipe, ano phađipe o mangro thaj ani molitva. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ane sa e duše avili i dar, golese kaj o Gospod ćerda but čudura thaj znakura prekal e apostolura. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","A sa save pačaje sesa katane thaj sa so sasa len sasa zajedničko. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Bićinena sa po barvalipe thaj ulade kolenđe kase trubul. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Svako đive ćidije pe katane ano Hram. Ane čhera ćidije pe te len i Gospodnjo večera thaj xalje mangro baxtasa thaj čačukane ilencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Hvalisade e Devle thaj poštujisade len sa e manuša. A o Gospod svako đive anola lenđe kolen so spasina pe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","O Petar thaj o Jovane đele katane ano Hram ki molitva ko trin o sato ko đive. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","E manuša inđarena jekhe manuše savo sasa bango tare po bijandipe thaj svako đive čhuvena le paši kapija e Hramesi savi akhardol “Lačhi”, te prosil pare tare manuša save džan ano Hram. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Kana vov dikhlja e Petre thaj e Jovane kaj manđen te džan ano Hram, lija te prosil pare lendar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","O Petar thaj o Jovane dikhlje premal leste pa vaćarde: “Dikh pe amende!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","A vov dikhlja premal lende thaj dija gođi kaj ka den le khanči. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","A o Petar vaćarda: “Zlato thaj srebro naj man, al kova so isi man dav tut: Ano alav e Isuseso e Hristeso taro Nazaret, ušti thaj phir!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Lija le taro desno va thaj vazdija le. Thaj sigate zurajle lese pingre thaj lese zglobura. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Gija vov hutija, uštilo thaj phirda. Đelo lencar ano Hram, phirindoj thaj hutindoj hvalisada e Devle. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Sa e manuša dikhlje le sar phirol thaj šunde sar hvalil e Devle. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Kana džanglje kaj vov si kova savo bešola thaj prosila angli kapija e Hramesi savi akhardol “Lačhi”, but čudisajle thaj divisajle kalese so sasa kale manušesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Sa e manuša save sesa odori sesa začudime thaj prastije premalo than savo akhardola “E Solomonesi streja” kaj sesa o Petar, o Jovane thaj o sastardo manuš, savo ni crdija pe lendar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Kana dikhlja o Petar gova, vaćarda e manušenđe: “Izraelcuralen, sose čudin tumen kalese? Sose dičhen premal amende te phene amen amara zorasa il devlikanimasa ćerdam kava manuš te phirol? ");
INSERT INTO rmyGurbet_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","O Dol e Avraameso, e Isaakoso thaj e Jakoveso, o Dol amare paradadengo proslavisada pe sluga e Isuse, save tumen predijen te mudaren le thaj odreknisaljen anglo muj e Pilateso kana vov manglja te mučhol le. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","A tumen e Isusestar, e Svetone manušestar thaj e Pravednikostar, odreknisaljen a mangljen te mučhol tumenđe o Pilat manuše savo mudarol. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","A tumen mudarden Kole kastar avol o džuvdipe, al o Dol vazdija le tare mule thaj amen sama svedokura golestar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Golese kaj kava manuš save dičhen thaj džanen, pačaja ane Isuseso alav thaj gova alav zurada le. O pačajipe ano Isus ćerda kale manuše te avol savršeno sasto angle savorende tumende. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","A akana, phralalen, džanav kaj ano bidžanglipe gova ćerden, sar i tumare šorutne. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Gija o Dol ispunisada gova so već angleder vaćarda andare muja pe prorokurenđe, kaj leso Pomazaniko mora te trpil. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Golese, pokajin tumen tare tumare grehura thaj irin tumen e Devlese te bi kosena pe tumare grehura, ");
INSERT INTO rmyGurbet_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","te avol tumenđe taro Gospod vreme taro odmoripe thaj te bičhalol e Isuse, save već angleder birisada te avol Pomazaniko. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Vov trubul te ačhol ko nebo sa dži kaj ni avol o vreme tari sa i obnova savatar o Dol angleder vaćarda prekale sveta prorokura. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Golese kaj o Mojsije vaćarda: ‘O Gospod, o Dol tumaro, ka vazdol tumenđe proroko maškar tumare phrala, sar so sem me. Šukar šunen sa so vov vaćarol tumenđe! ");
INSERT INTO rmyGurbet_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","A kova savo ni šunol gole proroko, ka avol uništimo andar o narodo!’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","A sa e prorokura taro Samuilo thaj kola pale leste vaćarde so ka avol ane kala đivesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Tumen sen naslednikura taro obećanje savo o Dol dija prekale prorokura thaj tumen sen ano savez savo o Dol phanglja tumare paradadencar. O Dol vaćarda e Avraamese: ‘Ćiro čhavo ka avol ko blagoslov sa e narodurenđe ki phuv.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","O Dol vazdija pe sluga e Isuse thaj bičhalda le tumenđe angleder te blagoslovil tumen thaj te crden tumen tare tumare bilačhe buća.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Vadži dok o Petar thaj o Jovane vaćarena e manušenđe, avile paše lende e sveštenikura, o šorutno tare hramesi straža thaj e sadukejura ");
INSERT INTO rmyGurbet_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","thaj but holajle golese so von sikaven e manušen thaj objavin kaj ano Isus si uštipe tare mule. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Dolde len thaj čhute len ano phanglipe dži aver đive, golese kaj već peli i rat. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Al but džene lendar save šunde lengo lafi, pačaje thaj o đinipe barilo paše pandž milje (5 000) murša. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Theara đive ano Jerusalim ćidije pe e šorutne e Jevrejenđe, e starešine thaj e učitelja taro Zakon. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Gothe sasa i o baro svešteniko o Ana thaj o Kajafa, o Jovane, o Aleksandar thaj avera tari familija e bare sveštenikosi. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Von ikalde e apostoluren angle peste thaj lije te pučen len: “Save zorasa il save alavesa gova ćerden?” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Tegani o Petar pherdo Svetone Duxosa vaćarda lenđe: “Šorutnalen thaj starešinalen e Jevrejenđe! ");
INSERT INTO rmyGurbet_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Te sam amen akharde ko odgovornost baše lačhe buća so ćerdam e nasvale manušese thaj pučen amen sar vov sastilo, ");
INSERT INTO rmyGurbet_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","tegani te džanen savore tumen thaj sa e Jevrejska manuša: Ćerdam gova ano alav e Isuseso e Hristeso e Nazarećanineso, kas tumen čhuten ko krsto thaj kas o Dol vazdija tare mule! Golese kava manuš ačhol angle tumende sasto. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","O Isus si: ‘o bar savo tumen e graditelja čhudijen, thaj ćerdilo emglavno bar taro čher.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ane khanikaste avereste naj spasenje, golese kaj talo nebo naj aver alav so dija pe e manušenđe savesa šaj te ava spasime.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Kana von dikhlje kaj o Petar thaj o Jovane ni daran thaj dodžanglje kaj von naj sikade thaj si prosta manuša, but čudisajle. Džanglje kaj von sesa e Isusesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Al kana dikhlje kaj kova sastardo manuš gothe ačhol lencar, naštine khanči te vaćaren. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Golese naredisade e Petrese thaj e Jovanese te ikljen andaro Baro sudo. Tegani lije maškar peste te vaćaren: ");
INSERT INTO rmyGurbet_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“So te ćera kale manušencar? Savore save bešen ano Jerusalim šukar džanen kaj prekal lende ćerdilo baro čudo, a amen našti te vaćara kaj na. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Al te ma bi kava sikajipe po but širila pe maškare manuša, te preti len ma khanikase te vaćaren tare gova alav.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Tegani akharde e apostoluren thaj naredisade lenđe ma te putren po muj khanikase il te sikaven ano alav e Isuseso. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Al o Petar thaj o Jovane phende lenđe: “Tumen li smatrin kaj si šukar anglo Dol te šuna tumen, a na e Devle? ");
INSERT INTO rmyGurbet_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Amen našti te ačhava thaj te ma phena tare kova so dikhljam thaj so šundam.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","E manuša taro Baro sudo vadži jekh drom pretisade e Petre thaj e Jovane thaj mukhlje len, golese kaj ni arakhlje khanči sosa bi kaznina len a i golese so e manušendar darajle; golese kaj savore hvalisade e Devle kalese so sasa. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Golese kaj o manuš sasa po but tare saranda (40) berš bango i akana čudesno sastilo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kana mukhlje len, o Petar thaj o Jovane irisajle ke pumare thaj vaćarde lenđe so phende lenđe e šorutne sveštenikura thaj e starešine. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Kana von šunde gova, sar jekh vazdije po glaso e Devlese thaj vaćarde: “Gospode, tu ćerdan o nebo thaj i phuv, o more thaj sa so si ane lende. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Tu vaćardan e Svetone Duxosa taro muj amaro paradadeso, će slugaso e Davideso: ‘Sose bunin pe e narodura, a e manuša džabe ćeren zavere? ");
INSERT INTO rmyGurbet_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Uštile e carura e phuvaće thaj e vladara udružisajle protiv o Gospod o Dol thaj protiv leso Pomazaniko.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Čače, o caro o Irod thaj o vladari o Pontije Pilat ane kava foro udružisajle katane e narodurencar thaj e manušencar taro Izrael protiv ćiro sveto sluga o Isus, save tu pomazisadan. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Udružisajle katane te ćeren sa so ćiro zuralipe thaj ćiro manglipe angleder odredisade so trubul te avol. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","A akana Gospode, dikh pe lengo pretipe thaj de amen, ćire slugenđe, ćo Lafi te vaćara bizi dar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Pruži ćo va te sastare thaj te ćere znakura thaj čudura ano alav će svetone slugaso e Isuseso.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Kana završisade i molitva, tresisada o than kaj sesa ćidime. A savore pherdile e Svetone Duxosa thaj vaćarde o Lafi e Devleso bizi dar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Sa save pačaje sesa jekh ilo thaj jekh duša thaj sesa but. Khoni ni ićarda pese kova so sasa len, nego ulade sa so sesa len maškar peste. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","E apostolura bare zorasa svedočisade taro uštipe tare mule e Gospodeso e Isuseso. O Dol but blagoslovisada len savoren. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Khanikase maškar lende khanči ni falila, golese kaj savoren kas sasa phuv il čher, bićinde thaj ande e pare taro bićinipe ");
INSERT INTO rmyGurbet_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","thaj e pare čhute angle pingre e apostolurenđe. A von ulade savorenđe gaći kobor trubuja lenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","A o Josif, save e apostolura akharde Varnava, so značil kova savo hrabril averen, o Levito, bijando ano Kipar, ");
INSERT INTO rmyGurbet_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","sasa le njiva, bićinda la thaj e pare čhuta e apostolurenđe angle pingre. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","A sasa jekh manuš, savo akhardola Ananija thaj vov pe romnjasa e Safirasa bićinda po imanje. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ano dogovor pe romnjasa crdija jekh kotor tare pare thaj garada len, a kola pare so ačhile čhuta e apostolurenđe angle pingre. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","A o Petar vaćarda lese: “Ananija! Sose o Satana pherda ćo ilo te xoxave e Svetone Duxo thaj te garave jekh kotor e parengo so lijan bašo imanje? ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Angleder so bićindan o imanje, naj li sasa ćiro? Šajine li gole parencar kana bićindan o imanje te ćere sa so manđe. Sose ane ćo ilo gija mangljan? Ni xoxadan e manušen, nego xoxadan e Devle!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Kana šunda o Ananija kala lafura, pelo thaj mulo. Tegani avili bari dar ane kola manuša save šunde kava. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Nesave terne murša uštile, paćarde le, ikalde le thaj prahosade le. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Paše trin satura pale gova, avili andre lesi romni i Safira. Al voj ni džanglja so sasa. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","O Petar pučlja la: “Vaćar manđe, paše gaći li pare bićinden i njiva?” A voj vaćarda: “Va, paše gaći.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","O Petar vaćarda laće: “Sose vaćarden katane te iskušin o Duxo e Gospodeso? Dikh, kola save prahosade ćire rome anglo vudar si, a i tut ka ikalen!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Tegani peli angle lese pingre thaj muli. Tegani avile andre e terne murša thaj arakhlje la mulja. Gija ikalde la thaj prahosade la paše lako rom. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","A avili bari dar ane sa i Khanđiri thaj ane sa save šunde kava. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Prekale apostolura sesa ćerde but znakura thaj čudura maškare manuša. Sa e pačavne sa jekhe dušasa ćidena pe tali Solomonesi streja. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Khoni aver ni tromaje te aven paše lende, al e manuša but hvalisade len. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","A gija sa po but manuša, murša thaj džuvlja lije te pačan ano Gospod thaj priključisajle e pačavnenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","A ke droma e manuša ikalde e nasvalen thaj čhute len ke thana e soimase thaj inđarimase, te bi kana načhola o Petar bar lesi senka perola pe lende. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Thaj avena but manuša tare pašutne forura save si pašo Jerusalim, save anena e nasvalen thaj kolen kas mučisade e bilačhe duxura thaj savore sastile. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","O baro svešteniko thaj savore save sesa lesa – e sadukejura – pherdile zavist. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Von dolde e apostoluren thaj čhute len ano javno phanglipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ane goja rat o anđelo e Gospodeso putarda o vudar taro phanglipe, ikalda len thaj vaćarda lenđe: ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Džan thaj ačhen ano Hram thaj vaćaren sa e manušenđe tare kava nevo Džuvdipe!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","E apostolura šunde e anđelo e Gospodese, đele rano sabalje ano Hram thaj lije te sikaven e manušen. Kana avilo o baro svešteniko thaj kola so sesa lesa, ćidije o Baro sudo, sa e starešinen e Izraelese thaj bičhalde ano phanglipe pe slugen te anen e apostoluren. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Al kana e stražara avile ano phanglipe, ni arakhlje len gothe. Tegani irisajle thaj vaćarde: ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“O phanglipe arakhljam kaj si šukar phanglo thaj e stražara sar ačhen angle vudara, al kana putardam, andre khanika ni arakhljam!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Kana šunde kala lafura o kapetano tari hramsko straža thaj e šorutne sveštenikura, čudisajle thaj lije te pučen pe so bi akava šajine te avol. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Tegani nesavo manuš avilo thaj vaćarda lenđe: “Ek, kola manuša saven čhuten ano phanglipe, ačhen ano Hram thaj sikaven e manušen!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Gija đelo o kapetano pe stražarencar thaj anda len, al na ki zor, golese kaj darajle tare manuša te ma mudaren len e barencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ande e apostoluren andre thaj ačhade len anglo Baro sudo. O baro svešteniko lija te pučol len: ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Na li strogo zabranisadam tumenđe te ma sikaven ane gova alav? A dikh, tumen pherden o Jerusalim tumare sikajimasa taro Isus thaj vadži manđen amen te ćeren banđen baše leso meripe!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","O Petar thaj e apostolura irisade lenđe vaćarindoj: “E Devle trubul te šuna, na e manušen. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","O Dol amare paradadengo vazdija tare mule e Isuse, kas tumen umladen ko kaš thaj mudarden. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","O Dol le vazdija ki piri desno rig sar Vođa thaj Spasitelje. Ćerda gova te bi dola prilika sa e Izraelcurenđe te obratin pe, te bi lenđe grehura avena oprostime. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Amen dikhljam so sasa thaj vaćara kaj gova si čače. I gova potvrdil thaj o Sveto Duxo, savo o Dol dija kolen save si lese poslušna.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kana von šunde gova, but holajle thaj manglje te mudaren len. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Tegani uštilo jekh farisejo ano Baro sudo, savo akhardola Gamalilo. Vov sasa učitelji e zakoneso kas poštujisade sa e manuša. Tegani vaćarda te ikalen e apostoluren zala avri. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Pa vaćarda lenđe: “Izraelcuralen, šukar den gođi so ka ćeren kale manušencar! ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Golese, kaj anglal nesavo vreme uštilo o Tevda thaj vaćarda pestar kaj si khoni. Ćidija paše peste štaršelen (400) dženen. Al kana mudarde le, sa lese manuša našle thaj tare gova ni sasa khanči. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Pale leste ano vreme taro popis uštilo o Juda o Galilejco thaj vov vazdija buna e manušencar. Thaj le mudarde a sa lese manuša našle. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Gija tare kava phenav tumenđe: ačhaven tumen tare kala manuša thaj mučhen len. Te si lengo plan il lenđe buća tare manuša, ka properen. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Te si kala buća taro Dol, našti te ačhaven len, a šaj aven ano maripe e Devlesa.” Thaj o Baro sudo šunda e Gamalile. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Dije vika e apostoluren ke peste thaj šibisade len, pretisade te ma vaćaren taro alav e Isuseso thaj mukhlje len. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","E apostolura đele taro Baro sudo radosna golese kaj o Dol dikhlja len dostojna te trpin kaja ladž za ko alav e Isuseso. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Thaj ni ačhile svako đive te sikaven e manušen ano Hram il ane čhera thaj te vaćaren taro Lačho Lafi kaj si o Isus o Mesija. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ane gola đivesa, kana but barilo o đinipe tare sikade, e grčka Jevreja holjame sesa pe Jevreja save vaćarde jevrejski, golese kaj lenđe džuvlja, kase roma mule, sesa zapostavime svako đive kana ulavola pe o xape. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Tegani e dešuduj (12) apostolura akharde sa e sikaden thaj vaćarde lenđe: “Ni ka avol šukar amen e apostolura te ačhava o sikajipe taro Lafi e Devleso te bi amen ulavasa o xape. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Golese phralalen, aračhen maškar tumende efta šukaren muršen, savenđe džangljol pe kaj si pherde Svetone Duxosa thaj but džanglimasa. Len ka čhuva te ćeren kala buća, ");
INSERT INTO rmyGurbet_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","al amen ka ačha ustrajna ani molitva thaj ano sikajipe taro Lačho Lafi.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Gova vaćaripe sasa šukar sa e manušenđe. Birisade e Stefane, manuše pherdo pačajimasa thaj Svetone Duxosa thaj e Filipe, e Prohore, e Nikanore, e Timone, e Parmene thaj e Nikola andari Antiohija, savo angleder obratisajlo ko jevrejsko pačajipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Len čhute angle apostolura, save molisajle thaj čhute pe vasta pe lende. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Gija o Lafi e Devleso širilasa pe, a o đinipe tare sikade barilo but ano Jerusalim. Sasa maškar lende i but sveštenikura so prihvatisade kaja pač. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","A o Stefane, manuš pherdo e Devlese milostesa thaj zorasa, ćerola but znakura thaj čudura maškaro narodo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Tegani uštile nesave manuša tari gija akhardi Sinagoga tare oslobodime robura. Kava sesa Jevreja tari Kirina, Aleksandrija thaj nesave tari Kilikija thaj andari Cikni Azija. Thaj von lije te raspravin pe e Stefanesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Al naštine te suprostavin pe bašo mudrost thaj e Duxose savesa vaćarola. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Golese čhute nesave manušen te vaćaren: “Šundam sar hulil protiv o Mojsije thaj protiv o Dol.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Gija lije te bunin pe e manuša, e starešine thaj e učitelja tare Mojsijaso zakon. Tegani dolde ani zaseda e Stefane thaj inđarde le anglo Baro sudo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ande gothe i xoxavne svedokuren save vaćarde: “Kava manuš ni ačhol te vaćarol protiv o Hram thaj protiv e Mojsijaso zakon. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Šundam le kaj phenol: ‘Kava o Isus o Nazarećanino ka phađol kava Hram thaj ka promenil e adetura save ačhada amenđe o Mojsije.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Savore save bešle ano Baro sudo dičhena premalo Stefane thaj dikhlje kaj leso muj sasa sar muj e anđeloso. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Tegani o baro svešteniko pučlja e Stefane: “Čače li gova?” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","O Stefane vaćarda: “Phralalen thaj dadalen, šunen man! O Dol tari slava sikadilo amare paradadese e Avraamese kana sasa ani Mesopotamija, angleder nego so avilo te bešol ano Haran. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Vaćarda lese: ‘Iklji andar ćiri phuv thaj tari ćiri familija thaj dža ani phuv savi ka sikavav tuće.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Gija o Avraam iklilo andari Haldejsko phuv thaj avilo te bešol ano Haran. A palo meripe lese dadeso o Dol nakhada le ani kaja phuv kaj akana tumen bešen. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ni dija le ni jekh korako e phuvako ano nasledstvo, al obećisada lese kaj ka dol kaja phuv lese thaj lese čhavenđe pale leste. Kana vaćarda lese gova, e Avraame vadži ni sesa čhave. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","A o Dol vaćarda lese gija: ‘Ćire čhave ka aven abandžije ane averenđi phuv. Ka čhuven len te aven robura thaj ka mučin len štaršel (400) berš. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Al me ka sudiv e manušen kase von ka robujin.’ A o Dol vaćarda: ‘Pale gova ka ikljen thaj ka služin man ke kava than.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Pale gova o Dol ćerda e Avraamesa e suneteso savez. Kana bijandilo lese o Isaak o Avraam ćerda lese suneti ohtoto đive, gova ćerda thaj o Isaak e Jakovese thaj o Jakov pe dešuduje (12) čhavenđe, e jevrejska bare paradada – e patrijarhura. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","E Jakovese čhave, e patrijarhura, sesa zavidna pe po phral o Josif thaj bićinde le sar robo e manušenđe save đele ano Egipat. Al o Dol sasa lesa ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","thaj ikalda le taro dži jekh bilačhipe. Dija le mudrost thaj ćerda o faraono, o caro e Egipateso, te dol gođi šukar lestar. A o faraono čhuta e Josife te avol šorutno po Egipat thaj pe sa piro čher. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Pale gova avilo o bokhalipe thaj baro bilačhipe pe sa Egipat thaj o Hanaan. Amare paradaden ni sasa xamase. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Kana o Jakov šunda kaj isi điv ano Egipat, bičhalda odori angleder pe čhaven, amare paradaden. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Kana avile dujto drom, o Josif vaćarda pe phralenđe ko si vov thaj o faraon upoznajisada lese familija. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Gija o Josif bičhalda pe dade e Jakove thaj akharda le i sa lese familija, eftavardeš thaj pandž (75) dženen. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Tegani o Jakov đelo ano Egipat. Gothe mulo vov thaj amare paradada. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ande lenđe kokala ano Sihem thaj čhute len ano limori savo ćinda parencar o Avraam ano Sihem tare čhave e Emorese. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Kana avilo paše o vreme te ispunil o Dol o obećanje so dija e Avraamese, amaro narodo but barola thaj širila pe ano Egipat. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Tegani ‘vladisada aver caro ano Egipat, savo ni pindžarda e Josife.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Vov lukavo ćerda but bilačhipe amare narodose, mučila amare paradaden thaj čhuta len te ačhaven avri pe čhavoren save tek bijandona, te bi merena. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ane gova vreme bijandilo o Mojsije savo sasa but šukar e Devlese. Trin čhon sasa arakhado ane pe dadeso čher. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Kana morajle te ačhaven le, arakhlja le e faraonesi čhej thaj bararda le sar pe čhave. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","E Mojsija sikade tare sa o Egipatsko džanglipe. Sasa zuralo ane lafura thaj ane sa so ćerda. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Kana sasa le saranda (40) berš, dija pe gođi te džal te dičhol pe phralen, e čhaven e Izraelskonen. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Kana dikhlja sar nesavo Egipćanino marol jekhe Izraelco, branisada e Izraelco thaj suprostavisajlo e Egipćanese. Osvetisajlo lese gija so mudarda le. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","O Mojsija dija gođi kaj lese phrala ka haljaren kaj o Dol prekal leste bičhalol o oslobođenje, al von ni haljarde. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Theara đive avilo maškar lende thaj dikhlja sar maren pe duj Izraelcura. Dikhlja te miril len vaćarindoj: ‘Manušalen! Tumen sen phrala! Sose ćeren bilačhipe jekh averese!’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Al kova savo ćerda bilačhipe pe pašutnese gurisada e Mojsija thaj vaćarda: ‘Ko tut čhuta te ave šorutno thaj te sudi amen? ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Il manđe i man te mudare sar kole Egipćane so mudardan eraći?’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Kana gova o Mojsije šunda, našlo taro Egipat thaj sasa sar abandžija ani phuv i Midjansko kaj bijandile lese duj čhave. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Kana nakhle saranda (40) berš, sikada pe lese o anđelo e Devleso ano grmo so sasa ani jag, ani pustinja paši Sinajsko gora. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Kana gova o Mojsije dikhlja, divisajlo kalese. Al kana avilo paše pošukar te dičhol, šunda o glaso e Devleso: ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Me sem o Dol ćire paradadengo, Dol e Avraameso, e Isaakoso thaj e Jakoveso.’ A o Mojsije tresisada tari dar thaj ni tromaja te dičhol. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","O Gospod vaćarda lese: ‘Uljar će sandale, golese kaj o than ke savo ačhe si sveto phuv. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Me šukar dikhljem i muka mingre manušenđi ano Egipat. Šundem sar jaučin thaj uljiljem te ikalav len. Akana dža! Ka bičhalav tut ano Egipat.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Kava si o Mojsija, save čhudije thaj vaćarde lese: ‘Ko tut čhuta te ave šorutno thaj te sudi amen?’ Le o Dol prekal o anđelo so sikadilo lese ano grmo bičhalda te avol vladari thaj kova savo ka izbavil len. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Thaj o Mojsije ikalda len thaj ćerda čudura thaj znakura ano Egipat, maškaro Lolo more thaj ani pustinja saranda (40) berš. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Kava si o Mojsije savo vaćarda e Izraelcurenđe: ‘O Dol tumaro ka vazdol tumenđe proroko tare tumare phrala sar man.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Kava si o Mojsije savo sasa ćidimo e manušencar ani pustinja e anđelosa savo vaćarda lese ki Sinajsko gora thaj amare paradadencar. Vov primisada e lafura e džuvdimase, te bi dola len amenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Al amare paradada ni manglje te šunen le. Odbacisade le thaj pe ilencar irisajle ano Egipat. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Golese vaćarde e Aaronese: ‘Ćer amenđe devlen save ka džan angle amende, golese kaj ni džana so si kale Mojsijasa, savo ikalda amen andaro Egipat.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Tegani ćerde idole savo ličila po terno guruv thaj dije žrtva e idolese thaj slavisade kole so ćerde pe vastencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Al o Dol crdija pe lendar thaj mukhlja len te klanjin pe e čerenjenđe, sar pisil ano lil e prorokurengo: ‘Izraele! Dijen li manđe žrtve thaj darura saranda (40) berša ani pustinja? ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Na, nego inđarden o šatori e devleso e Moloheso thaj i čereni tumare devlese e Refanese. Kala si idolura save ćerden te molin tumen lenđe; Golese ka bičhalav tumen ano progonstvo’ po dur taro Vavilon. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Amare paradada sasa len šatori taro svedočanstvo ani pustinja, sar so vaćarda o Dol e Mojsijase te ćerol le sar so sikada lese. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Pale gova amare paradada save primisade šatori, ande le e Isusesa e Navineso ani phuv e abandžijenđi saven o Dol tradija angle lende tari goja phuv. Gothe ačhilo o šatori dži ko vreme kana sasa o caro o David. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","O David arakhlja milost anglo Dol thaj molisada e Devle te vazdol Hram e Jakovese Devlese. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Al tek o Solomon vazdija lese o Hram. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Al o Embaro Dol ni bešol ane Hramura ćerde e manušikane vastencar, sar so phenda o proroko: ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘O Gospod vaćarol: O nebo si mo presto a i phuv than tale mingre pingre. Savo čher ka ćeren manđe? Kaj si than pašo odmor mingro? ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Na li ćerda sa kava mo va?’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","O tumen, zurale šorenđe sen! Bisunetime ilenđe sen thaj kašuće e čačimase! Uvek protivin tumen e Svetone Duxose sar tumare paradada! ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Isi li jekh proroko save ni tradije tumare paradada? Mudarde i kolen save angleder vaćarde taro avipe e Pravednikoso, kas tumen akana izdajisaden thaj mudarden. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Tumen sen gola so dobisaden o Zakon prekalo anđelura, al ni ićarden tumen pe leste.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Kana e Jevreja ano Baro sudo gova šunde, holajle ane pe ile thaj ćićidije pe danda pe leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Al o Stefane pherdo e Svetone Duxosa vazdija pe jakha premalo nebo thaj dikhlja i slava e Devlesi thaj e Isuse kaj ačhol ki desno rig e Devlese. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Thaj vaćarda: “Akh, dikhav o nebo putardo thaj e Čhave e Manušese kaj ačhol ki desno rig e Devlese.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Tegani von dije vika andare sa o glaso thaj phanglje pe kana. Savore sar jekh uštile pe leste, ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ikalde le andaro foro thaj lije te čhuden pe leste bara. E svedokura pe fostanura dije te aračhol o terno čhavo savo akhardol Savle. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Dok čhudena e bara po Stefane, vov molisajlo e Devlese vaćarindoj: “Gospode Isuse! Primi mo duxo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Tegani pelo pe koča thaj dija vika andare sa o glaso: “Gospode! Ma le lenđe kava sar greh.” Kana kava vaćarda, mulo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","A o Savle odobrisada e Stefaneso mudaripe. Ane gova đive sasa baro progonstvo pi Khanđiri ano Jerusalim. Sa e pačavne, sem e apostolura, našle ani Judeja thaj ani Samarija. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Nesave pačavne murša prahosade e Stefane thaj but ruje pale leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Al o Savle dikhlja te uništil i Khanđiri. Džala taro čher dži o čher te dolol e muršen thaj e džuvljen thaj čhuvola len ano phanglipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Kola so našle andaro Jerusalim, vaćarde o Lafi svugde kaj đele. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Gija o Filip avilo ane jekh samarijansko foro thaj gothe vaćarda taro Hrist. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Kana e manuša šunde e Filipe thaj dikhlje e čudesura save ćerda, katane savore obratisade pažnja pe gova so vaćarda. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","E bilačhe duxura bare vikasa iklile andare pherdo manuša ane kaste sesa. Thaj pherdo banđe sastile. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Gija sasa baro radost ane kava foro. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ane kava foro sasa jekh manuš, savo akhardola Simon, savo već nesavo vreme divila e manušen ani Samarija pe dikhljarimasa. Vov vaćarda pestar kaj si but baro manuš ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","thaj savore, taro emcikno dži o naj baro, obratisade pažnja thaj vaćarde: “Kava manuš si e Devlesi zor, savi akhardol Bari zor.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Šunena le, golese kaj but vreme divila len pe dikhljarimasa. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Al kana pačaje e Filipese savo vaćarola lenđe taro Lačho Lafi taro Carstvo e Devleso thaj taro alav e Isuseso e Hristeso, krstisajle e murša thaj e džuvlja. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","I korkoro o Simon pačaja thaj krstisajlo. Stalno sasa pašo Filip zadivimo e znakurencar thaj e bare čudurencar save ćerda. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Kana šunde e apostolura save sesa ano Jerusalim kaj e manuša ani Samarija prihvatisade o Lafi e Devleso, bičhalde lende e Petre thaj e Jovane. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Von avile thaj molisajle e pačavnenđe te primin e Svetone Duxo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Golese kaj vadži pe ni jekh ni avilo o Sveto Duxo. Samo sesa krstime ano alav e Gospodeso e Isuseso. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Tegani e apostolura čhute pe vasta pe lende thaj von primisade e Svetone Duxo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","O Simon dikhlja kaj e pačavne primin e Svetone Duxo kana e apostolura čhute pe lende pe vasta thaj anda lenđe pare ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","vaćarindoj: “Den i man gasavo zuralipe te primil o Sveto Duxo dži jekh pe kaste čhuvav me vasta.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Al o Petar phenda lese: “Ćire parencar tu te propere, golese kaj tu dijan gođi kaj e Devleso daro šaj ćinol pe parencar! ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Naj tuće bući ane goja služba, golese kaj ćiro ilo naj čače anglo Dol! ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Pokaji tut tare kava ćiro bilačhipe thaj moli tut e Gospodese te šaj oprostil tuće kova so dijan gođi ane ćiro ilo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Golese kaj dikhav kaj san pherdo ćerčipe thaj phanglo ani nepravda.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Tegani o Simon vaćarda: “Tumen molin e Gospode manđe, ma te avol pe mande khanči tare gova so vaćarden.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pale gova, kana von phende o svedočanstvo thaj vaćarde e Gospodeso Lafi, irisajle ano Jerusalim. Thaj odrumal ane but Samarijanska gava vaćarde o Lačho Lafi. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","O anđelo e Gospodeso vaćarda e Filipese: “Spremi tut thaj dža ko jug ko drom maškari pustinja savo uljol taro Jerusalim ani Gaza.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Gija o Filip spremisajlo thaj đelo. Odrumal arakhlja jekhe manuše tari Etiopija, savo sasa evnuho, baro bućarno e caricako e Kandako tari Etiopija, savo sasa upravitelji tari laći riznica. Kava manuš sasa ano Jerusalim te molil pe e Devlese, ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","thaj akana irisajlo andaro Jerusalim. Bešola pe piro grastano vordon thaj čitisada o lil e prorokoso e Isaijaso. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","O Sveto Duxo phenda e Filipese: “Dža paše kova vordon thaj av paše leste.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Tegani o Filip prastija pašo vordon thaj šunda kaj čitil taro proroko Isaija. Pučlja: “Haljare li gova so čiti?” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","O evnuho phenda: “Sar bi šajine te haljarav kaj khoni ni objasnil manđe gova?” I molisada e Filipe te uštol po vordon thaj te bešol paše leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","E lafura andaro Sveto lil kotar čitisada o evnuho sesa kala: “Inđarde le ko čhinipe sar bakre. Thaj sar terno bakro khanči ni vaćarda angle kola save randen le, gija ni vov ni putarda po muj. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Sasa ponizimo thaj uskratisade lestar i pravda. Tare lese potomkura khanči ni ka vaćarol pe, golese kaj leso džuvdipe lija pe tari phuv.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","O evnuho pučlja e Filipe: “Moliv tut, kastar kava vaćarol o proroko? Pestar il nekastar averestar?” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Tegani o Filip lija te vaćarol tare kava lil e Isaijaso, te phenol lese o Lačho Lafi taro Isus. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Sar džana e dromesa, avile dži nesavo paj. A o evnuho phenda: “Akh paj! So šaj ačhavol ma te ma krstiv man?” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","O Filip vaćarda lese: “Te pačajan tare sa ćiro ilo, šaj.” A vov irindoj vaćarda lese: “Pačav kaj o Isus Hrist si o Čhavo e Devleso.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Gija o evnuho vaćarda te ačhaven o vordon. Tegani solduj, o Filip thaj o evnuh, ulile ko paj thaj o Filip krstisada le. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Kana iklile andaro paj, o Duxo e Gospodeso lija e Filipe tare jekh drom thaj o evnuho ni dikhlja le vadži, al nastavisada pe dromesa radosno. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","O Filip arakhlja pe ano Azot. Đelo ane sa e forura thaj e dromesa vaćarda o Lačho Lafi, sa dži kaj ni reslo ani Kesarija. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","A o Savle bizo ačhipe vadži holjame pretisada kaj ka mudarol e sikaden e Gospodese. Golese đelo ko baro svešteniko ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","thaj molisada le te dol le e lila paše sinagoge ano Damask, te šaj ane sinđira te anol ano Jerusalim sa kolen save džan ko Drom e Gospodeso, bilo kas te aračhol, muršen il džuvljen. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Kana sasa ko drom thaj avilo paše o Damask, tari jekh drom pe leste svetlisada zuralo svetlost taro nebo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Pelo ki phuv thaj šunda o glaso vaćarindoj: “Savle, Savle! Sose progoni man?” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","O Savle pučlja: “Ko san tu, Gospode?” O glaso phenda lese: “Me sem o Isus, kas tu progoni. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Nego akana ušti thaj dža ano foro, odori ka vaćarol pe tuće so trubul te ćere.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","E manuša save džana e Savlesa ačhile thaj khanči ni vaćarde, golese kaj šunde o glaso al khanika ni dikhlje. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Tegani o Savle uštilo tari phuv, al kana putarda pe jakha naštine te dičhol. Golese lije le taro va thaj ande le ano Damask. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Trin đive ni dikhlja, ni xalja, ni pilja. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ano Damask bešola jekh tare sikade e Isusese kaso alav sasa Ananija. O Gospod ani vizija vaćarda lese: “Ananija!” A o Ananija vaćarda lese: “Aktaljem, Gospode!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","O Gospod vaćarda lese: “Ušti thaj dža ko drom savo akhardol Prava. Gothe ano čher e Judaso rode e manuše taro Tarsis savo akhardol Savle. Ektalo, vov akana molil pe ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","thaj ani vizija dikhlja manuše palo alav Ananija, kaj avol andre ke leste thaj čhuvol po va pe leste te šaj palem te dičhol.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","A o Ananija vaćarda: “Gospode, me šundem tare but džene paše gova manuš kobor bilačhipe ćerda ćire svetone manušenđe ano Jerusalim. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","A i kate isi le vlast tare šorutne sveštenikura te phandol savoren save pačan ane ćiro alav.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Al o Gospod phenda lese: “Dža! Golese kaj kale manuše birisadem te anol mingro alav angle abandžije, angle carura thaj angle Izraelcura. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Me ka sikavav le kobor trubul te trpil mingre alavese.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Gija đelo o Ananija thaj avilo ano čher. Gothe čhuta pe vasta po Savle thaj vaćarda: “Phrala Savle! O Gospod o Isus, savo sikadilo tuće ko drom kana aviljan akari, vov bičhalda man ke tute te bi tu palem šajine te dičhe thaj te ave pherdo Svetone Duxosa.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Sigate tare Savlese jakha pele khanči sar ljuspe thaj vov palem dikhlja. Uštilo em krstisajlo pajesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Pale gova, zala xalja thaj irisajlo leso zuralipe. O Savle nekobor đivesa ačhilo e sikadencar ano Damask. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Sigate ane sinagoge vaćarola kaj o Isus si o Čhavo e Devleso. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Savore save šunde le, divisajle lesa thaj pučlje pe: “Naj li kava kova savo uništil ano Jerusalim sa kolen save pačan ane Isuseso alav? Ni li avilo kate te phandol thaj te inđarol len ke šorutne sveštenikura?” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Al e Savleso propovedipe sasa sa po zuralo. Dokažila kaj si o Isus čače o Hrist, gija kaj e Jevrejen ano Damask ačhavola bizo odgovor. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Kana nakhle po but đivesa, e Jevreja ćidije pe thaj dogovorisajle te mudaren e Savle. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Al o Savle dodžanglja so manđen te ćeren. Đive thaj rat von pazisade pe forose vudara, te bi mudarena le. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Al ki rat e sikade lije e Savle thaj mukhlje le ani bari korpa taro duvari. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Kana avilo o Savle ano Jerusalim dikhlja te avol katano e sikadencar. Al savore lestar darajle golese kaj ni pačaje kaj i vov si čače sikado. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Al o Varnava prihvatisada le, anda le ke apostolura thaj vaćarda lenđe sar ko drom dikhlja e Gospode thaj so vaćarda lese. Phenda lenđe i sar o Savle ano Damask bizi dar propovedisada taro alav e Isuseso. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Gija ačhilo lencar, slobodno phirola ano Jerusalim thaj bizi dar propovedila taro alav e Isuseso, e Gospodeso. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Vaćarda thaj raspravisajlo e Jevrejencar save vaćarena grčki, al von dikhlje te mudaren le. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Kana gova šunde e phrala, inđarde le ani Kesarija thaj gothar bičhalde le ano Tars. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Tegani i Khanđiri ani sa i Judeja, Galileja thaj Samarija sasa ano mir. Izgradila pe thaj barili, golese kaj e pačavne phirde ani dar e Devlesi thaj utešina pe ano Sveto Duxo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Kana o Petar nakhlja taro than dži ko than, avilo ke Devlese sveta manuša save bešena ani Lida. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Odori arakhlja jekhe manuše savo akhardola Enej, savo sasa lindo ohto berš thaj pašljola ano than e pašljimaso. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","O Petar vaćarda lese: “Eneje! O Isus Hrist sastarol tut! Ušti thaj lačhar ćo than.” Thaj o Enej sigate uštilo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Dikhlje gova savore save bešle ani Lida thaj ano Saron thaj irisajle premal o Gospod. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ani Jopa bešli jekh sikadi savi akhardola Tavita, so grčki značil “Košuta”. Lako džuvdipe sasa pherdo šukare bućencar thaj dola milostinja e čore manušenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Thaj ane gola đivesa nasvajli thaj muli. Najarde la thaj čhute la ani upruni soba. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","A sar si i Lida paši Jopa thaj e sikade šunde kaj o Petar si odori, bičhalde duje manušen te zamolin le: “Moli tut, av amende sigate!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Gija o Petar uštilo thaj đelo lencar. Kana avilo, inđarde le ki upruni soba thaj ćidije pe paše leste e romnja kase roma mule. Von ruje thaj sikade lese e gada thaj e fostanura save ćerda i Tavita kana voj sasa lencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","O Petar tradija savoren avral, pelo ke pe koča thaj molisajlo e Devlese. Pale gova irisajlo premal lako telo thaj vaćarda: “Tavito, ušti!” Voj putarda pe jakha thaj kana dikhlja e Petre, bešli. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","O Petar dija la po va thaj pomožisada la te uštol. Pale gova akharda e romnjen kase roma mule thaj e avere pačavnen thaj sikada kaj si džuvdi. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Kava šundilo ani sa i Jopa thaj but pačaje ano Gospod. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","A o Petar but đive ačhilo ani Jopa ko nesavo Simon savo ćerola e morčha. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ani Kesarija sasa jekh manuš alavesa Kornelije, rimsko kapetano e četako savi akhardola Italijansko. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Vov thaj sa lese čherutne sesa pačavne thaj darana taro Izraelsko Dol. Dija but milostinja e čore Izraelcurenđe thaj svako đive molila pe e Devlese. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Jekh đive, kana sasa trin o sato ko đive, sasa le vizija. Šukar dikhlja, sar premal leste avilo e Devleso anđelo thaj vaćarda lese: “Kornelije!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","O Kornelije dikhlja ane leste thaj darandoj pučlja: “Vaćar so manđe, Gospode?” O anđelo vaćarda: “O Dol prihvatisada ćire molitve thaj ćiri milostinja sar žrtve. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Golese akana bičhal ani Jopa manušen te anen e Simone, kas den vika Petar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Vov si gosto ke nesavo Simon savo ćerol e morčha, kaso čher si pašo more.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Pale gova o anđelo savo vaćarda lesa đelo thaj o Kornelije akharda pe duje slugen thaj jekhe devlikane vojniko tare kola save služisade le. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Phenda lenđe sa kava so sasa thaj bičhalda len ani Jopa. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Theara đive kana e Kornelijase manuša đele e dromesa thaj avile paši Jopa, iklilo o Petar ko krovo te molil pe e Devlese, kana o sato sasa paše dešuduj (12) ko đive. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Sasa bokhalo thaj manglja te xal. Dok ćerde lese xamase, vov pelo ani vizija. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Dikhlja sar taro putardo nebo uljol premali phuv baro čaršafi phanglo ke štar riga. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ane leste sesa sa e vrste štare pingrenđe životinje tari phuv thaj e gmizavcura thaj sa e čiriklja talo nebo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Tegani nesavo glaso vaćarda lese: “Ušti, Petre! Čhin thaj xa!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","A o Petar vaćarda: “Nisar, Gospode! Nijekh drom ni xaljem so si poganimo thaj melalo so si zabranimo Zakonesa.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Thaj o glaso dujto drom lese vaćarda: “Ma tu vaćar kaj si poganimo te xal pe kova so o Dol proglasisada thodo!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Kava sasa trin drom thaj o čaršafi sigate irisajlo palal ko nebo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","A sar o Petar sasa vadži ano čudo so kaja vizija značil, e manuša save sesa bičhalde taro Kornelija pučindoj arakhlje o čher e Simoneso savo ćerola morčha thaj već ačhile paši kapija. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Akharde thaj pučlje: “Naj li kate o Simon kas akharen Petar?” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","A sar o Petar vadži dola gođi tari vizija, o Sveto Duxo phenda lese: “Akh, trin džene roden tut. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Golese ušti thaj ulji tele, dža lencar bizo nisavo mislipe, golese kaj me bičhaldem len.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Tegani o Petar ulilo ke kola manuša thaj vaćarda: “Akh, me sem kova kas roden. Sose aviljen?” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Von vaćarde: “Bičhalda amen o Kornelije o rimsko kapetano, manuš čačukano savo daral taro Izraelsko Dol, a save poštujin sa e Jevreja. Lese phenda o sveto anđelo te akharol tut ane piro čher thaj te šunol tutar će lafura.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Tegani o Petar dija len vika andre ano čher te aven lese gostura. Theara đive uštilo o Petar thaj đelo lencar. I nesave pačavne phrala save sesa andari Jopa, đele lesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","A aver đive avile ani Kesarija. O Kornelije već ađućarda len thaj akharda pe familija thaj pe pašutne amalen. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Kana o Petar dija andre, o Kornelije avilo angle leste thaj pelo angle lese pingre thaj poklonisajlo lese. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Al o Petar vazdija le vaćarindoj: “Ušti, i me sem samo manuš.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Vaćarindoj lesa đelo o Petar andre thaj dikhlja kaj si gothe pherdo džene. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","O Petar vaćarda lenđe: “Tumen džanen kaj naj dindo e Jevrejese te bešol tumencar e abandžijencar il te džal tumende ano čher. Al o Dol manđe sikada khanika ma te akharav poganimo il melalo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Golese aviljem bizo nisavo mislipe kana akharden man. Akana pučav tumen, sose bičhalden pale mande?” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","O Kornelije vaćarda: “Angleder štar đive ane mingro čher molisaljem ke kava sato, ke trin o sato. Thaj dikh, manuš ačhilo angle mande ano sjajno fostano ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","thaj vaćarda: ‘Kornelije! Uslišimi si ćiri molitva thaj o Dol dikhlja ćiri milostinja e čororenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Bičhal ani Jopa thaj akhar e Simone save akharen Petar. Vov bešol pašo more ano čher e Simoneso, savo ćerol morčha.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Gija me bičhaldem sigate pale tute thaj tu šukar ćerdan kaj aviljan. Akana amen savore ačha kate anglo Gospod te šuna sa so o Dol tuće vaćarda te vaćare amenđe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Tegani o Petar lija te vaćarol: “Akana čače dikhav kaj o Dol ni ćerol razlika maškare manuša. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Dikhav kaj andare sa e narodura prihvatime si kola save daran lestar thaj ćeren čačipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Tumen džanen kaj o Dol bičhalda e Izraelcurenđe o lafi kana objavisada o Lačho Lafi taro mir prekalo Isus Hrist savo si Gospod savorenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Tumen džanen so sasa ani sa i Judeja. Počnisada ani Galileja palo krstipe taro savo propovedisada o Jovane. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","A tumen džanen taro Isus andaro Nazaret kas o Dol pomazisada e Svetone Duxosa thaj e zorasa. Gija o Isus džala ke but thana, ćerola šukaripe thaj sastarola savoren saven o beng ićarda ane piro vlast, golese kaj o Dol sasa lesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Amen e apostolura dikhljam sa so ćerda ano Jerusalim thaj ani sa i phuv e Jevrejenđi. Von mudarde le gija so čhute le ko krsto. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Al o Dol trito đive vazdija le tare mule thaj dija le te sikadol. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ni sikadilo sa e manušenđe nego e svedokurenđe saven angleder birisada o Dol – amenđe save lesa xaljam thaj piljam palo leso uštipe tare mule. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Vov naredisada amenđe te vaćara thaj te svedoči e manušenđe kaj o Dol čhuta le sar sudija e džuvdenđe thaj e mulenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Baše leste svedočin sa e prorokura, kaj lese alavesa primin oprostipe paše grehura savore save pačan ane leste.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","A sar o Petar vaćarola kala lafura, ulilo o Sveto Duxo pe savore save šunde leso lafi. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Thaj e jevrejska pačavne save avile e Petresa, divisajle kaj o Dol dija sar daro o Sveto Duxo e abandžijenđe, ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","golese kaj šunde so vaćaren e abandžije ane avera čhiba thaj baravena e Devle. Tegani vaćarda o Petar: ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Kala manuša primisade e Svetone Duxo, sar amen. Šaj li khoni te čhinavol o paj te ma krstin pe?” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","A naredisada lenđe te krstin pe ano alav e Isuseso e Hristeso. Pale gova molisade e Petre te ačhol lencar gothe vadži nekobor đivesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","E apostolura thaj e phrala ani sa i Judeja šunde kaj čak i e abandžije prihvatisade o Lafi e Devleso. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Kana o Petar irisajlo ano Jerusalim, kola save si sunetime pačavne lije te ćeren čingara lesa, ");
INSERT INTO rmyGurbet_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","vaćarindoj: “Đeljan ke abandžije save naj sunetime thaj xaljan lencar!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Tegani o Petar lija te vaćarol lenđe palo redo: ");
INSERT INTO rmyGurbet_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Sema ano foro ani Jopa thaj dok molisaljem, sasa man vizija. Dikhljem sar taro nebo uljol khanči sar baro čaršafi so mučhol pe ke štar riga thaj ulilo angle mande. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Kana šukar dikhljem andre, dikhljem e štare pingrenđe životinje e phuvaće, gmizavcura, e zverura thaj e čirikljen talo nebo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Tegani šundem glaso savo vaćarda manđe: ‘Ušti, Petre! Čhin thaj xa!’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Al me vaćardem: ‘Nisar, Gospode! Ni jekh drom so si poganimo il melalo, so si zabranimo e Zakonesa, ni đelo ane mo muj.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","A o glaso taro nebo vaćarda manđe dujto drom: ‘Ma tu vaćar kaj si poganimo te xal pe kova so o Dol proglasisada thodo.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Kava sasa trin droma thaj pale gova sa irisajlo ko nebo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ane gova časo avile anglo čher ane savo sama, trin džene so sesa bičhalde andari Kesarija pale mande. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","O Sveto Duxo vaćarda manđe te džav lencar bizo nisavo mislipe. Mancar džana i kala šov phrala thaj đeljam ano čher gole manušeso savo bičhalda pale amende. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Gova manuš vaćarda amenđe sar dikhlja anđelo savo ačhilo ane piro čher thaj vaćarda lese: ‘Bičhal khanika ani Jopa te anen e Simone kas den vika Petar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Vov ka vaćarol tuće lafura tare save ka spasin tumen, tu thaj savore save bešen ane ćiro čher.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","A kana lijem te vaćarav, ulilo o Sveto Duxo pe lende, gija sar ko angluno drom pe amende. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Tegani dije man gođi e Lafese e Gospodeso savo vaćarda: ‘O Jovane krstisada pajesa al tumen ka krstin e Svetone Duxosa.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Gijate, te o Dol dija len jekh isto daro, sar savo dija amen kana lijam te pača ane amaro Gospod o Isus Hrist, ko sem me te braniv e Devle ane gova?” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Kana šunde kava, smirisajle thaj lije te hvalin e Devle vaćarindoj: “O Dol, gijate, i e abandžijen dija pokajanje savo inđarol ano džuvdipe bizo meripe!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ano isto vreme, e pačavne save našle taro progonstvo savo lija te avol kana o Stefan mudardilo, avile dži ki Fenikija, dži ko Kipar thaj dži ki Antiohija. Ni vaćarde o Lačho Lafi khanikase samo e Jevrejenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Al nesave lendar, e Kipranura thaj e Kirincura, đele ani Antiohija thaj lije te vaćaren i e Grkurenđe thaj propovedisade lenđe o Lačho Lafi taro Gospod o Isus. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Sasa lencar e Gospodeso va thaj but džene pačaje thaj irisajle premal o Gospod. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Golestar šundilo dži ki Khanđiri ano Jerusalim thaj von bičhalde e Varnava ani Antiohija. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Kana o Varnava avilo thaj dikhlja so ćerda o Dol pale piro milost, radujisajlo thaj zurada len savoren te ačhen verna e Gospodese sa e ilesa, ");
INSERT INTO rmyGurbet_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","golese so o Varnava sasa šukar manuš, pherdo Svetone Duxosa thaj pačajimasa. Thaj but manuša obratisajle e Gospodese. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Pale gova o Varnava đelo ano Tars te rodol e Savle. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Kana arakhlja le, inđarda le ani Antiohija. Gothe berš đive ćidije pe e Khanđirasa thaj sikade bute manušen. Ani Antiohija angluno drom akharde e sikaden “hrišćanura”. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ane gola đivesa andaro Jerusalim avile nesave prorokura ani Antiohija. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Jekh lendar, leso alav sasa Agav, uštilo thaj vodimo e Svetone Duxosa, phenda kaj ka avol baro bokhalipe ko Rimsko Carstvo. Gova sasa kana vladisada o Klaudije. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Golese e sikade andari Antiohija odlučisade dži jekh lendar kobor šaj te pomognin e phralen thaj phejen save bešena ani Judeja. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Gija i ćerde thaj bičhalde e pare e starešinenđe palo Varnava thaj palo Savle. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ane gova vreme o caro o Irod Agripa lija te progonil nesaven andari Khanđiri. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","E Jakove, e Jovanese phrale, mudarda le mačosa. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Kana dikhlja kaj si e Jevrejenđe šorutnenđe gova šukar, naredisada te dolen thaj e Petre. Gova sasa ko Prazniko, ko vreme tare bikvasacose mangrengo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Kana dolda le, čhudija le ano phanglipe thaj dija e Petre ke štar vojnička straže po štar džene te aračhen le. O Irod manglja pali Pasha te ikalol le angle manuša te sudil le. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Gija e Petre arakhlje ano phanglipe, al i Khanđiri bizo ačhipe molisada e Devle bašo Petar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","A goja rat, kana o Irod manglja te ikalol le angle manuša, o Petar sasa phanglo duje sinđirencar, suta maškare duj vojnikura, a e stražarura ačhile anglo vudar taro phanglipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","A tari jekh drom pojavisajlo o anđelo e Gospodeso thaj baro svetlo svetlisada o than ano phanglipe kaj sasa o Petar. O anđelo po zala čalada e Petre ane lese pašavre, vazdija le taro sojipe thaj vaćarda lese: “Ušti sigate!” Thaj e sinđira pele tare vasta e Petrese. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Tegani o anđelo vaćarda lese: “Phande ći kuštik thaj pođi će sandale.” O Petar ćerda gijate. Pale gova o anđelo vaćarda lese: “Urav ćo fostano thaj phir mancar!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","O Petar iklilo pale leste, al ni džanglja kaj sa kava so ćerol o anđelo si čače, nego dija gođi kaj isi le vizija. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Kana nakhle i angluni thaj i dujto straža, avile pašo sastrunalo vudar, savo inđarol ano foro. O vudar korkoro putajlo thaj iklile ko drom. Kana nakhle jekh ulica, o anđelo tari jekh drom crdija pe lestar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Tegani avilo o Petar ane peste thaj vaćarda: “Akana čače džanav kaj o Gospod bičhalda pe anđelo thaj ikalda man andare e Irodese vasta thaj tare sa so e Jevreja ađućarde te avol manđe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Kana haljarda sa gova, avilo ano čher e Marijako, i dej e Jovanesi, kas akharena Marko. Gothe pherdo manuša ćidije pe thaj molina pe e Devlese. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Kana čalada o Petar po vudar e avlijako, avili jekh terni sluškinja savi akhardola Roda, te putrol o vudar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Kana pindžarda e Petreso glaso taro radost ni putarda o vudar, nego prastija andre thaj vaćarda kaj o Petar ačhol anglo vudar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Von phende laće: “Tu san dili!” Kana voj uporno vaćarda kaj si čače gija, von vaćarde: “Gova si leso anđelo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Al o Petar ni ačhada te čalavol ko vudar. Kana putarde, dikhlje e Petre thaj but čudisajle. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","O Petar ćerda lenđe vastesa khanči te ma vaćaren thaj pale gova vaćarda lenđe sar o Gospod ikalda le taro phanglipe thaj phenda: “Vaćaren kava e Jakovese thaj e avere phralenđe.” Tegani o Petar iklilo gothar thaj đelo ke aver than. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Kana putajlo o đive, sasa bari pobuna maškare vojnikura baše gova so sasa e Petresa. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","O Irod bičhalda te roden e Petre, a kana ni arakhlje le, ispitujisada e vojnikuren so sasa thaj naredisada te mudaren len. Pale gova o Irod iklilo tari Judeja, đelo ani Kesarija thaj odori ačhilo nesavo vreme. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","O caro o Irod sasa ani bari čingar e manušencar taro Tir thaj taro Sidon. Al von ćidije pe thaj katane đele ko Irod thaj kana sasa len podrška taro Vlasto, e caroso pomoćniko, molisade le bašo mir, golese so andari phuv e carosi anena xamase. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ano dogovorime đive urada pe o Irod ane carska šeja, bešlo ko presto thaj lija te vaćarol e manušenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","A e manuša dije vika: “Kava si glaso e devleso, naj e manušeso!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Al tari jekh drom čalada le o anđelo e Gospodeso golese kaj ni dija slava e Devlese. Xalje le e ćerme thaj mulo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","A o Lafi e Devleso širisajlo thaj sesa sa po but pačavne. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Kana o Varnava thaj o Savle završisade po služipe ano Jerusalim, irisajle ani Antiohija thaj lije pesa e Jovane kas akharde Marko. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ani Khanđiri ani Antiohija sesa kala prorokura thaj učitelja: o Varnava, o Simeon kas akharde Niger, o Lukije tari Kirina, o Manaino savo barilo pašo Irod o vladari, thaj o Savle. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Gija jekh drom kana slavisade e Gospode thaj postisade, o Sveto Duxo vaćarda lenđe: “Crden manđe akana e Varnava thaj e Savle baši bući savi me akhardem len.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Tegani, sar vadži postisade thaj molisade, čhute pe vasta pe lende thaj bičhalde len. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","O Savle thaj o Varnava bičhalde sesa taro Sveto Duxo, đele ani Selevkija thaj gothar đele e brodosa ano Kipar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Kana avile ano Salamin, propovedisade e Devleso Lafi ane Jevrejska sinagoge thaj pomožisada lenđe o Jovane kas akharde Marko. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Kana nakhle sa o ostrvo, resle ko foro Paf. Gothe arakhlje nesave manuše savo sasa dikhljarno thaj xoxavno proroko. Vov sasa Jevrejo savo akhardola Varisus. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Vov sasa amal e upravnikosa, kaso alav sasa Sergij Pavle, manuš savo sasa but gođaver. O Sergij Pavle akharda e Varnava thaj e Savle golese kaj manglja te šunol e Devleso Lafi. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Al lenđe protivisajlo o Elima o dikhljarno – gija si leso alav ano prevod – savo manglja e upravniko te iril taro pačajipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Tegani o Savle kas akharde i Pavle, pherdo Svetone Duxosa dikhlja ano xoxavno proroko, o Varisus Elim ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","thaj vaćarda: “Čhaveja e benđeso thaj dušmanona baše sa o pravednost! Pherdo san prevare thaj lukavstvo dži jekh vrsta. Ni li ka ačhave te banđare e ravna droma e Gospodese? ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Dikh, akana o va e Gospodeso ka avol protiv tute! Ka ave koro thaj ni ka dičhe o kham nesavo vreme.” Thaj tari jekh drom po Elim pelo kalipe thaj tamnina thaj lija te phirol thaj te rodol khanika te inđarol le vastesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Kana o upravniko dikhlja so sasa, pačaja thaj divisajlo ano sikajipe e Gospodeso. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Kana o Pavle thaj kola save sesa lesa đele e čamcosa andaro Paf thaj avile ani Perga, ani Pamfilija o Jovane kas akharde Marko ačhada len thaj irisajlo ano Jerusalim. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Pale gova o Pavle thaj o Varnava đele andari Perga thaj avile ani Pisidijsko Antiohija. Ko savato đele ani sinagoga thaj bešle gothe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Palo čitipe taro Zakon thaj tare Prorokura, e starešine e sinagogaće bičhalde ke lende te vaćaren lenđe kava: “Phralalen, ako isi tumen lafi te zuraven e manušen, vaćaren!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Gija o Pavle uštilo, vazdija po va thaj lija te vaćarol: “Izraelcuralen thaj avera tumen save daran taro Dol, šunen! ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","O Dol kale izraelskone manušengo birisada amare paradaden thaj vazdija lengo đinipe dži kaj bešle sar abandžije ano Egipat thaj pe zurale vastesa ikalda len gothar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Paše saranda (40) berš strpljivo podnosisada len ani pustinja. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ano Hanaan uništisada efta naroduren thaj lenđi phuv dija e Izraelcurenđe ano nasledstvo. Sa gova sasa štaršel thaj pinda (450) berš. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Pale gova dija len sudijen dži o proroko o Samuilo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Tegani e manuša manglje caro thaj o Dol dija len e Saule, e Kisose čhave, manuše tare Venijaminaso pleme. O Savle vladisada paše saranda (40) berš. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Kana o Dol crdija e Saule, vazdija lenđe e Davide carose, savestar vaćarda: ‘Arakhljem e Davide, čhave e Jesejese, manuš pale mingro ilo. Vov ka ćerol sa so me mangav.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Taro potomstvo e Davideso, o Dol palo piro obećanje, vazdija e Izraelese e Spasitelje e Isuse. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Angleder so o Isus avilo, o Jovane o Krstitelj propovedisada sa e Izraelskone manušenđe te pokajin pe thaj te krstin pe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Kana o Jovane završisada pi bući savaće sasa bičhaldo, vaćarda: ‘Me naj sem kova savese den gođi kaj sem. Al akh, pale mande avol khoni savo si po baro mandar, kase naj sem dostojno te putrav lese sandale.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Phralalen, čhave e Avraamese thaj avera tumen save daran taro Dol! Amenđe sasa bičhaldo kava Lafi taro spasenje. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","E manuša save bešen ano Jerusalim thaj lenđe šorutne, ni pindžarde e Isuse, nego sudisade le. Gija pherdile e lafura e prorokurenđe save čitin pe svako savato a ni haljarde len. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Iako ni arakhlje nisavo banđipe sose o Isus zaslužisada o meripe, rodije taro Pilat te mudaren le. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Kana ćerde sa so sasa pisimo lestar ane Sveta lila, uljarde le taro krsto thaj čhute le ano limori. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Al o Dol vazdija le tare mule ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","thaj o Isus sikadilo but đivesa kolenđe save đele lesa andari Galileja ano Jerusalim. Von si akana lese svedokura angle Jevreja. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Amen vaćara tumenđe o Lačho Lafi: o obećanje savo o Dol dija amare paradadenđe, ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","pherda amare čhavenđe gija so vazdija e Isuse andare mule. Sar so si pisime ano dujto psalmo: ‘Tu san mingro Čhavo. Od ađive sem ćiro Dad.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Golese kaj o Dol vazdija le tare mule, ni ka ćernjol nikad ano limori. Vaćarda gija: ‘Tumenđe ka dav e sveta thaj sigurna blagoslovura save obećisadem e Davidese.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Golese, ko aver than o Dol vaćarol: ‘Ni ka de ćo sveto manuš te ćernjol.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Golese, o David ane piri kuštik služisada baše Devleso cilj, mulo thaj prahosade le paše lese paradada thaj leso telo ćernilo ano limori. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Al Kova kas o Dol vazdija tare mule, ni ćernilo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Golese, phralalen, trubul te džanen kaj ano Isus objavil pe tumenđe oprostipe tare grehura thaj tare sa so naštine te opravdil pe e Mojsijase zakonesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","E Isusesa opravdil pe dži jekh savo pačal. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Golese, aračhen tumen ma te avol pe tumende kova so o Dol vaćarda prekal e prorokura: ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Dičhen, tumen save maren muj! Čudin tumen thaj hasavon! Golese kaj ane tumare đivesa ka ćerav bući ane savi ne bi pačana, te bi vaćarola pe tumenđe golestar.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Kana iklile o Pavle thaj o Varnava andari sinagoga, molisade len e manuša te irin pe aver savato te vaćaren lenđe vadži tare gova. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Kana o ćidipe crdija pe, pherdo Jevreja thaj e devlikane abandžije save lije e Jevrejengo pačajipe, đele palo Pavle thaj o Varnava. Von vaćarde lencar thaj zurade len te nastavin te pačan ano milost e Devleso. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ane aver savato ćidije pe skoro savore andaro foro te šunen e Gospodeso Lafi. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Kana e Jevreja dikhlje bute manušen, pherdile zavist thaj lije te vređin e Pavle thaj te suprostavinpe pe gova so vaćarola. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Al o Pavle thaj o Varnava bizi dar vaćarde lenđe: “O Lafi e Devleso tumenđe e Jevrejenđe angleder trubuja te vaćarol pe. Al golese kaj tumen čhuden le thaj korkore tumen ni dičhen kaj sen dostojna bašo džuvdipe bizo meripe, akana amen irisaljam e abandžijenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Golese kaj gija vaćarda amenđe o Gospod: ‘Ćerdem tut svetlo e abandžijenđe, te ane o spasenje ane sa e krajura e phuvaće.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Kana šunde kava e abandžije, radujisajle thaj slavisade e Gospodeso Lafi thaj pačaje savore save sesa odredime pašo džuvdipe bizo meripe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","O Lafi e Gospodeso širisajlo ke sa e thana ani goja regija. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Al e Jevreja nagovorisade e uticajna devlikane džuvljen thaj e muršen save sesa ke šorutne thana ane kava foro thaj von lije te traden e Pavle thaj e Varnava thaj čhudije len andari pi phuv. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Al o Pavle thaj o Varnava tresisade o praho tare pe pingre te ma bi avola len khanči lencar thaj đele ani Ikonija. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","A e sikade sesa radosna thaj pherde Svetone Duxosa. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Sar ane avera thana, gija thaj ani Ikonija o Pavle thaj o Varnava đele ani Jevrejsko sinagoga. Gothe pherdo Jevreja thaj Grkura lije te pačan golese kaj o Pavle thaj o Varnava vaćarde o Lafi e Devleso. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Al e Jevreja save ni manglje te pačan, bunisade e abandžijen protiv e phrala thaj pherde bilačhimasa lenđe gođa. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Tegani, von ačhile but đive gothe thaj bizi dar vaćarde taro Gospod, savo potvrdisada o Lafi tare piro milost gija so dija len te ćeren znakura thaj čudesura. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","E manuša taro foro uladile: nesave sesa e Jevrejencar, a avera e apostolurencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Tegani nesave abandžije thaj e Jevreja katane pe šorutnencar ande odluka te ćeren bišukaripe e Pavlese thaj e Varnavase thaj manglje te maren len thaj te čhuden bara pe lende. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Kana o Pavle thaj o Varnava dodžanglje baše gova, našle ani likaonsko regija, ane forura Listra thaj Derva thaj ane pašutne thana, ");
INSERT INTO rmyGurbet_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","thaj i odori vaćarde o Lačho Lafi. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ani Listra bešola jekh manuš savo sasa paralizovano tare piro bijandipe. Nikad naštine te phirol. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Dži kaj kava manuš šunda e Pavle sar vaćarol thaj o Pavle dikhlja pe leste, o Pavle dikhlja kaj vov pačal ano sastaripe, ");
INSERT INTO rmyGurbet_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","vaćarda lese bare glasosa: “Ušti ke pingre!” Tari jekh drom o manuš hutija thaj lija te phirol. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Kana but manuša dikhlje so ćerda o Pavle, vazdije po glaso ki likaonsko čhib: “E dolura ulile tele amende thaj ćerdile manuša!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Thaj akharde e Varnava Zevs, a e Pavle Hermes, golese kaj vov sasa glavno govorniko. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","O svešteniko, tare Zevseso hram savo sasa pašo foro, anda guruven thaj vencura ki kapija golese kaj manglja e manušencar te dol e apostolurenđe sar žrtve. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Kana e apostolura o Varnava thaj o Pavle šunde gova, pharade pe fostanura, prastije maškare manuša thaj lije te den vika: ");
INSERT INTO rmyGurbet_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Manušalen! So ćeren kava? Amen sam samo manuša sar tumen! Amen aviljam te vaćara tumenđe o Lačho Lafi te crden tumen tare gasave beskorisna buća thaj te irin tumen premalo džuvdo Dol, savo ćerda o nebo thaj i phuv, o more thaj sa so si ane lende. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Angleder o Dol sa e manušen mukhlja te džan pe dromencar, ");
INSERT INTO rmyGurbet_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","al nikad ni ačhada tumen bizo svedočanstvo pestar. Vov ćerol tumenđe šukar buća, dol tumen taro nebo bršnd thaj šukar bijandipe ane po vreme, čaljarol tumen xamasa thaj pherol tumare ile baxtasa.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Sar kava vaćarde lenđe, jedva ačhade e manušen te ma čhinen lenđe žrtven. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Al tegani avile nesave Jevreja andari Antiohija thaj andari Ikonija, pherde e manušen te čhuden bara po Pavle. Kana čhudije bara pe leste, inđarde le avral taro foro golese kaj dije gođi kaj si mulo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Al kana e sikade ćidije pe trujal leste, o Pavle uštilo thaj irisajlo ano foro. Theara đive e Varnavasa đelo ano Dervo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Kana o Pavle thaj o Varnava vaćarde o Lačho Lafi i ani Derva thaj buten ćerde sikade, irisajle ani Listra, ani Ikonija thaj ani Antiohija. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Gothe zuravena thaj ohrabrina e sikaden te ačhen ano pačajipe thaj vaćarena lenđe kaj maškaro baro bilačhipe trubun te načhen te bi dena ano Carstvo e Devleso. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ane sa e khanđira o Pavle thaj o Varnava čhute lenđe starešinen, ano post thaj ani molitva ačhade len e Gospodese ane savo pačaje. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pale gova nakhle maškar i Pisidija thaj avile ani Pamfilija. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Kana vaćarde o Lafi e Devleso ani Perga, ulile ani Atalija. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Gothar đele brodosa ani Antiohija, odori kaj sesa angleder predajime e Devlese ane vasta vov te brinil pe lendar thaj bičhalde te ćeren i bući savi akana završisade. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","A kana avile ani Antiohija thaj ćidije i khanđiri, o Pavle thaj o Varnava vaćarde lenđe sa so ćerda o Dol prekal lende thaj sar e abandžijenđe putarda o vudar taro pačajipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Thaj gothe ačhile po but đivesa e sikadencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Tegani avile nesave manuša andari Judeja ani Antiohija thaj lije te sikaven e phralen: “Te ni ćerden suneti palo purano e Mojsijaso adeti, našti spasin tumen.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","O Pavle thaj o Varnava zurale suprostavisajle golese thaj sasa bari čingar maškar lende. O Pavle thaj o Varnava thaj vadži nesave phrala sesa bičhalde te džan ano Jerusalim, golestar te vaćaren e apostolurencar thaj e starešinencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Gija i Khanđiri bičhalda len po drom thaj von nakhle maškar i Fenikija thaj i Samarija thaj vaćarena lenđe sa tare abandžije save obratisajle e Devlese. Gova ćerda baro radost maškare sa e pačavne. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Kana avile ano Jerusalim, i khanđiri, e apostolura thaj e starešine lačhe ađućarde len, a o Pavle thaj o Varnava vaćarde sa so ćerda o Dol prekal lende. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Tegani uštile nesave pačavne tari farisejsko stranka save vaćarde: “Trubun e abandžijenđe te ćeren suneti thaj naredisade lenđe te ićaren e Mojsijaso zakon!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","E apostolura thaj e starešine ćidije pe te vaćaren golestar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Pali bari čingar, uštilo o Petar thaj vaćarda: “Phralalen! Tumen džanen kaj o Dol tare anglune đivesa birisada man maškar tumende, andar mingro muj te šunen e abandžije o Lačho Lafi thaj te pačan. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","O Dol savo pindžarol e ile, potvrdisada kaj prihvatil e abandžijen gija so dija len o Sveto Duxo, sar i amenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","O Dol ni ćerda nisavi razlika maškar lende thaj amende, golese kaj e pačajimasa thoda lenđe ile.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Sose akana iskušin tumare Devle thaj manđen te čhuven pharipe pi kor e sikadenđe, savo naštine te inđara ni amen ni amare paradada? ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Nego amen pača kaj ka ava spasime taro milost e Gospodeso e Isuseso, sar i von. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Tegani khoni khanči ni vaćarda thaj lije te šunen e Varnava thaj e Pavle so vaćarde, save znakura thaj čudura ćerda o Dol maškare abandžije prekale lende. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Kana von ačhade te vaćaren, o Jakov phenda: “Phralalen, šunen man! ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","O Simon Petar vaćarda sar o Dol taro anglunipe brinisajlo maškare abandžije te biril narodo pese. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","A kalesa uklopin pe e lafura e prorokurenđe, golese kaj si pisime: ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Pale gova ka iriv ma thaj palem ka vazdav e Davideso šatori savo si perado. Ka vazdav le andari ruševina thaj ka obnoviv le ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","te roden e Gospode i avera manuša, thaj sa e abandžije, saven akhardem mande. Gija vaćarol o Gospod, so ćerol gija, ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","a gova džanol pe taro angluno vreme.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Golese me phenav te ma ćeren pharipe e abandžijenđe save akana irin pe ko Dol, ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","nego amen te pisi lenđe te aračhen pe taro xape savo si žrtvujime e idolurenđe, taro blud, taro mas e tasade životinjengo kaso rat ni thavdija thaj te ni pijen o rat tare nisavi životinja. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Golese kaj ane svako foro, od angleder isi kola save propovedin gola zakonura e Mojsijase thaj lendar čitin svako savato ane sinagoge.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Tegani e apostolura thaj e starešine sa e Khanđirasa, odlučisade te birin maškar peste manušen saven ka bičhalen e Pavlesa thaj e Varnavasa ani Antiohija. Gija birisade e Juda kas akharde Varsava thaj e Sila, save sesa e šorutne maškare phrala. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Pale lende bičhalde kava lil: “Amen, e apostolura thaj e starešine, tumare phrala andaro Jerusalim, bičhala pozdrav sa e phralenđe tare aver narodura save živin ani Antiohija thaj ani Sirija thaj ani Kilikija. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Amen šundam kaj nesave amendar avile tumende, uznemirisade tumen thaj bunisade tumen pe lafurencar. Al amen ni vaćardam lenđe te ćeren gova. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Golese odlučisadam savore sar jekh, te biri nekobor manušen thaj te bičhala len katane amare mangle phralencar, e Varnavasa thaj e Pavlesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Gova si manuša save po džuvdipe čhute ki kocka bašo alav amare Gospodeso, e Isuseso e Hristeso. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Gija bičhala e Juda thaj e Sila, save ka vaćaren tumenđe gova lafurencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Golese odlučisadam, o Sveto Duxo thaj amen, te ni čhuva tumenđe nisavo aver pharipe, sem kava so trubul: ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","te aračhen tumen taro xape savo si žrtvujime e idolurenđe, te ni pijen rat thaj te ni xan mas e tasade životinjengo kaso rat ni thavdija thaj te ni ćeren blud. A te arakhljen tumen tare kava, ka ćeren šukar. Aven saste.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Gija bičhalde len po drom thaj von đele ani Antiohija. Gothe ćidije sa e pačavnen ani khanđiri thaj dije len o lil. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Kana čitisade le, radujisajle tare gova ohrabrenje. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","O Juda thaj o Sila, save i korkore sesa prorokura, bute lafurencar ohrabrisade thaj zurade e phralen. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","A sar sesa gothe nesavo vreme, e phrala mukhlje len ano mir palal kolenđe so bičhalde len. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Al o Sila odlučisada kaj si po šukar te ačhol gothe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","A o Pavle thaj o Varnava ačhile ani Antiohija kaj sikade thaj vaćarde o Lafi e Gospodeso bute dženenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Pale nekobor đivesa o Pavle vaćarda e Varnavase: “Te iri amen thaj te dikha e phralen ke sa e forura, ane save propovedisadam o Lafi e Gospodeso, te dikha sar si.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","O Varnava manglja te inđaren pesa e Jovane kas akharde Marko. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Al o Pavle vaćarda: “Kova savo ačhada amen ani Pamfilija thaj ni đelo amencar ke buća save trubujam te ćera, ma te la le amencar.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Gija iklili čingar maškar lende thaj uladile jekh averestar. O Varnava lija pesa e Marko thaj đelo ko Kipar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","A o Pavle lija e Sila. E phrala predajisade len ane Gospodese vasta, vov te brinil pe lendar thaj von đele. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Nakhle maškar i Sirija thaj i Kilikija thaj zurada e phralen ane khanđira. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","O Pavle thaj o Sila đele ano Dervo a pale gova ani Listra. Gothe sasa jekh sikado alavesa Timotej. Lesi dej sasa Jevrejka savi pačaja, al leso dad sasa abandžija. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","O Timotej sasa ko lačho glaso maškare phrala ani Listra thaj ani Ikonija. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","O Pavle manglja te inđarol le pesa. Tegani ćerde e Timotejase suneti, taro poštovanje e Jevrejengo save bešle ane gola thana, golese kaj von džanglje kaj leso dad sasa abandžija. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Sar džana taro foro ko foro, sikade e manušen te ićaren pe tare odredbe save odredisade e apostolura thaj e starešine ano Jerusalim. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Gija e khanđira zurajle ano pačajipe thaj svako đive barile ano đinipe sa po but. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Von samo nakhle maškar i regija Frigija thaj i Galatija, golese so o Sveto Duxo ni dija len te vaćaren o Lafi e Devleso ani Cikni Azija. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Kana avile paše i Misija, dikhlje te džan ani Vitanija, al o Duxo e Isuseso ni dija len te džan. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Gija nakhle i Misija thaj ulile ani Troada. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ane goja rat, e Pavle sasa vizija. Dikhlja sar jekh manuš andari Makedonija ačhilo thaj molisada le: “Av ani Makedonija thaj pomogni amen!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pale gova so dikhlja i vizija, sigate dikhljam te dža ani Makedonija, golese kaj džangljam kaj o Dol dija amen vika te propovedi gothe o Lačho Lafi. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Kana đeljam andari Troada, aviljam brodosa pravo ko ostrvo Samotrak thaj theara đive đeljam ano Neapolj. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Gothar đeljam dži ko Filipi, savo si angluno foro taro jekh kotor tari Makedonija, savi sasa rimsko kolonija. Ane kava foro ačhiljam nekobor đive. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ko savato ikliljam avral tari kapija e forosi dži ki len, golese kaj dijam gođi kaj ka arakha odori than za ki molitva. Ćidije pe gothe nesave džuvlja, a amen bešljam thaj lijam te vaćara lencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Maškar lende sasa jekh džuvli, savako alav sasa Lidija taro foro Tijatira, savi biknola but kuč skerletna šeja. Voj poštujila e čačukane Devle thaj o Gospod putarda lako ilo te šunol šukar e Pavlese lafura. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Pale gova so krstisajli voj thaj laće čherutne, molisada amen: “Te dijen gođi kaj me pačav ano Gospod, aven thaj bešen ane mo čher.” Thaj čhuta amen te ćera gova. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Jekh đive kana đeljam ko than za ki molitva, arakhlja amen jekh robinja. Ane late sasa bilačho duxo savesa dikhljarola so ka avol. Gija anola but pare pe gospodarenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Voj đeli palo Pavle thaj pale amende thaj dija vika: “Kala manuša si sluge e Devlese e Embarese! Von objavin tumenđe o drom taro spasenje!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Thaj gija ćerola but đivesa. Kana gova e Pavlese avilo dži o nak, irisajlo thaj vaćarda gole bilačhe duxose: “Zapovediv tuće ano alav e Isuseso e Hristeso, iklji andar late!” Thaj o bilačho duxo iklilo latar ane gova sato. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Kana dikhlje laće gospodara kaj hasarde i nada baši zarada latar, dolde e Pavle thaj e Sila thaj vucisade len dži ko trgo kaj sesa e šorutne e forose. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ande len ke sudije thaj vaćarde: “Kala manuša si Jevreja thaj ćeren buna ane amaro foro, ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","thaj vaćaren tare adetura save amen e Rimljanura ni smi te prihvati thaj te ićara amen pe lende.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Tegani e manuša uštile po Pavle thaj po Sila. E sudije pharade e šeja save sesa pe lende thaj vaćarde te šibin len. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Pale gova so šibisade len but, čhute len ano phanglipe thaj vaćarde ko čuvari te aračhol len šukar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Kana dobisada gasavo naređenje, vov čhuta len ano emdurutno kotor taro phanglipe thaj lenđe pingre phanglja maškare phalja. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ani opaš i rat o Pavle thaj o Sila molisajle, đilabije thaj hvalisade e Devle a kola phangle manuša šunde len. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","A tari jekh drom i phuv lija but te tresil pe thaj gija crdija pe o temelji taro phanglipe. Sigate putajle sa e vudara thaj savorenđe pele e sinđira tare vasta. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Kana džungadilo o čuvari, dikhlja kaj si putarde e vudara taro phanglipe. Gija lija o mačo thaj manglja te mudarol pe, golese kaj dija gođi kaj našle e phangle manuša. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Al o Pavle andare sa o glaso dija vika: “Ma čher tuće nisavo bilačhipe, golese kaj sam amen savore gothe!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","O čuvari rodija e memelja thaj prastija sigate andre. Tresisada tari dar thaj pelo ke pe koča anglo Pavle thaj anglo Sila. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ikalda len avral thaj pučlja: “Cenime manušalen, so trubul te ćerav te spasiv man?” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Von vaćarde: “Pača ano Gospod o Isus thaj ka ave spasimo tu thaj ćire čherutne.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Tegani vaćarde lese o Lafi e Gospodeso thaj savorenđe save sesa ane leso čher. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ane gova sato ani rat kova čuvari lija e Pavle thaj e Sila, thoda lenđe rane thaj sigate krstisajlo vov thaj sa lese čherutne. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Pale gova anda len ane po čher, dija len te xan thaj radujisajlo pe čherutnencar golese so pačaja ano Dol. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Kana đivesajlo, e sudije bičhalde pe službenikuren te phenen e čuvarese: “Mukh kale duje manušen.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","O čuvari vaćarda e Pavlese: “E sudije vaćarde te mukha tumen. Golese akana ikljen thaj džan ano miro!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Al o Pavle vaćarda e službenikurenđe: “Marde amen angle manuša bizo sudo thaj iako sam Rimljanura, čhudije amen ano phanglipe thaj akana manđen čorale te ikalen amen? Našti gija! Nek aven korkore thaj nek ikalen amen!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","E službenikura đele ke sudije thaj vaćarde gova lenđe thaj von darajle kana šunde kaj si o Pavle thaj o Sila Rimljanura. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Avile, izvinisajle lenđe, a kana ikalde len andaro phanglipe, molisade len te ikljen andaro foro. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Kana o Pavle thaj o Sila iklile andaro phanglipe, đele ki Lidija, dikhlje pe e phralencar, zurade len thaj đele andar kava foro. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Kana o Pavle thaj o Sila nakhle maškare forura o Amfipolj thaj i Apolonija, avile ano Solun, kaj sasa jevrejsko sinagoga. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Thaj o Pavle pale piro adeti đelo ani sinagoga thaj trin savatura raspravisada lencar tare Svete lila. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Objasnisada lenđe thaj anola dokazura golestar kaj: “O Hrist trubuja te mudardol thaj te uštol tare mule. A gova Hrist si o Isus, savestar me tumenđe vaćarav.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Nesave Jevreja dikhlje kaj si gova čače thaj pridružisajle e Pavlesa thaj e Silasa. Pridružisajle lencar i but Grkura save poštujina e Devle thaj but ugledna džuvlja. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Al aver Jevreja save sesa zavidna baše gova, lije nesave bilačhe manušen taro trgo thaj ćerde pobuna ano foro. Napadisade e Jasonoveso čher thaj rodije e Pavle thaj e Sila te ikalen len angle manuša te sudin len. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","A kana ni arakhlje len, zorasa ande e Jasone thaj nesave phralen angle e forose šorutne thaj dije vika: “Kala manuša bunisade celo Rimsko carstvo thaj akana avile i amende ");
INSERT INTO rmyGurbet_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","a o Jason mukhlja len peste ano čher. Von savore ćeren protiv e carose odredbe, golese kaj vaćaren kaj isi aver caro, nesavo Isus.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Kana e manuša thaj e forose šorutne kava šunde, uznemirisajle ");
INSERT INTO rmyGurbet_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","thaj mukhlje len tek kana taro Jason thaj avera phrala lije pare sar zalogo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Goja rat e phrala sigate ani rat bičhalde e Pavle thaj e Sila ani Verija. A kana resle odori, lije te džan ani jevrejsko sinagoga. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Kala Jevreja manglje po but te šunen o Lafi tare kala save bešena ano Solun thaj šukar prihvatisade e Devleso Lafi. Dži jekh đive rodena ano Sveto lil te dičhen dal si čače gova so vaćarol o Pavle. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Golese, but Jevreja thaj but tare ugledna Grkinje thaj Grkura pačaje. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Al kana dodžanglje e Jevreja taro Solun kaj o Pavle objavil o Lafi e Devleso i ani Verija, avile i von odori te vazden thaj te bunin e manušen. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Tegani e phrala sigate bičhalde e Pavle te džal ko more, a o Sila thaj o Timotej ačhile ani Verija. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","A kola so pratisade e Pavle, inđarde le ani Atina thaj palo zapovest irisajle ani Verija te inđaren o haberi e Silase thaj e Timotejese sigate te aven palo Pavle. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Dok o Pavle ađućarda e Timoteje thaj e Sila ani Atina, holajlo but leso duxo ane leste kaj ano foro dikhlja pherdo idoluren. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Golese ani sinagoga raspravisajlo e Jevrejencar thaj e Grkurencar save poštujina e Devle thaj ko trgo kolen saven bi aračhena svako đive. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Gija lesa lije te raspravin pe nesave epikurejska thaj e stojička filozofura. Nesave lendar pučlje pe: “So kava brbljivco manđol te vaćarol?” Thaj e dujta vaćarena: “Izgleda kaj objavil abandžijskone devlen.” Gova vaćarde golese kaj o Pavle vaćarola o Lačho Lafi taro Isus thaj taro uštipe tare mule. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Tegani lije le, inđarde le ano Areopag, ko brego kaj ćidena pe e starešine e forose thaj phende lese: “Šaj li džana savo si gova nevo sikajipe savo tu ikale angle amende? ");
INSERT INTO rmyGurbet_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Phere amare kana čudnone bućencar, pa manga te džana so gova značil.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Sa e Atinjanura thaj e abandžije save bešena maškare lende, ni nakhavena po vreme ane khanči sem so vaćarena thaj šunena nesave neve buća. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Tegani o Pavle ačhilo maškar o Areopag thaj vaćarda: “Atinjanuralen, me dikhav kaj tumen sen but religiozna. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Golese, dži kaj nakhljem, ačhiljem thaj dikhljem tumare sveta thana, arakhljem čak jekh žrtveniko pe savo sasa pisimo: ‘Devlese savo ni pindžarol pe.’ Gova si Dol save tumen ni pindžaren a poštujin, savestar me vaćarav tumenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Kava si o Dol savo ćerda o sveto thaj sa so si pe leste. Vov si Gospodari e neboso thaj e phuvako golese ni bešol ane hramura save si ćerde manušikane vastesa, ");
INSERT INTO rmyGurbet_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","niti e manušikane vasta naj potrebe te služin le, sar te phene kaj khanči trubul le. Golese vov si kova savo dol džuvdipe, o dišipe thaj sa aver. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Vov tare jekh manuš ćerda sa e naroduren te bešen pi sa i phuv thaj angleder odredisada vreme e manušenđe thaj međe kaj šaj te bešen. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ćerda gova e manuša te roden e Devle, sar te bi vazdena pe vasta premale leste thaj te aračhen le. Al vov čače naj dur tare ni jekh amendar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","‘Golese kaj ane leste živi, phira thaj sam.’ Sar so i nesave tare tumare manuša e pesnikura phende: ‘Amen sam leso potomstvo.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Gija, sar sam e Devleso potomstvo, ni trubul te da gođi kaj si o Dol sar tvorevina taro zlato, taro srebro il taro bar, save e manuša ćerde majstorski thaj pale piri mašta. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Angleder kana e manuša ni džanglje e Devlese, o Dol ni dikhlja pe gova, al akana zapovedil sa e manušenđe ke sa e thana te pokajin pe, ");
INSERT INTO rmyGurbet_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","golese kaj odredisada đive ane savo pravedno ka sudil e svetose prekalo manuš save odredisada. Savorenđe dija dokaz golestar, gija so vazdija le tare mule.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Kana šunde taro uštipe tare mule, nesave marde muj, al avera vaćarde: “Tare gova ka šuna tut aver drom.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Gija o Pavle đelo lendar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Nesave ačhile paše leste thaj pačaje. Maškar lende sasa o Dionisije o Areopagito, jekh tare starešine e forose thaj i džuvli savi akhardola Damara thaj avera. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Pale gova o Pavle đelo tari Atina thaj avilo ano Korint. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Gothe arakhlja nesave Jevrejino, alavesa Akila, savo sasa tari Ponta. Vov skoro avilo andari Italija pe romnjasa e Priskilasa golese kaj o Caro o Klaudije naredisada sa e Jevreja te džan andaro Rim. O Pavle pridružisajlo lencar ");
INSERT INTO rmyGurbet_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","thaj golese kaj ćerde isto zanati sar i vov, ćerena šatora, ačhilo lende thaj ćerda bući lencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","A dži jekh savato o Pavle raspravila ani sinagoga thaj manglja e Jevreja thaj e Grkura te pačan. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Kana avile andari Makedonija o Sila thaj o Timotej, o Pavle posvetisajlo te propovedil samo e Devleso Lafi thaj te svedočil e Jevrejenđe kaj si o Isus čače Mesija. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Al kana von protivisajle thaj lije te vređin e Pavle, vov tresisada i prašina pestar tare pe šeja te ma bi avola le khanči lencar thaj vaćarda: “Tumaro rat ka perol pe tumare šore! Me sem thodo. Od akana ka propovediv e abandžijenđe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Tegani o Pavle đelo andari sinagoga thaj avilo ano čher nesave manušese savo akhardola Titije Just, savo si abandžija a darala taro Dol, kaso čher sasa paši sinagoga. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","A o Krispo, o starešina tari sinagoga, pačaja ano Gospod sa pe čherutnencar. I but avera Korinćanura save šunde le, pačaje thaj krstisajle. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Jekh rat o Gospod vaćarda e Pavlese ani vizija: “Ma dara, nego vaćar. Ma te ačhe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Golese kaj me sem tusa. Khoni ni ka napadil tut te ćerol tuće bilačhipe, golese kaj man isi but manuša ane kava foro.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Gija o Pavle bešlo gothe berš tepaš thaj sikada len taro Lafi e Devleso. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Kana sasa o Galion upravniko ani Ahaja, e Jevreja katane uštile po Pavle thaj inđarde le ko sudo ");
INSERT INTO rmyGurbet_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","vaćarindoj: “Kava manuš čhuvol e manušen te poštujin e Devle protiv o Zakon.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Kana o Pavle manglja te putrol po muj, vaćarda o Galion e Jevrejenđe: “Jevrejonalen! Te avol nesavi nepravda il bilačhi bući, avola bi sose te šunav tumen. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Al kava si čingara baše lafura, baše alava thaj baše tumaro Zakon, golese rešin gova korkore. Sudija ni mangav te avav ane gova.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Gija tradija len andaro sudo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Tegani von dolde e Sostene, e šorutne tari sinagoga, thaj marde le anglo sudo. O Galion khanči golese ni marisada. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","O Pavle ačhilo vadži but đivesa ano Korint. Pale gova oprostisajlo pe phralencar thaj e brodosa đelo katane e Priskilasa thaj e Akilasa, ani Sirija. Ani Kenhreja ranglja po šoro, golese kaj ćerda zavet. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Kana resle ano Efes, ačhada len gothe thaj vov korkoro đelo ani sinagoga, kaj raspravisajlo e Jevrejencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Von molisade te ačhol ke lende vadži nesavo vreme, al vov ni manglja, ");
INSERT INTO rmyGurbet_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","nego oprostisajlo lencar vaćarindoj: “Ka iri ma tumende, te manglja o Dol.” Tegani đelo e brodosa andaro Efes. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Kana reslo ani Kesarija, đelo ano Jerusalim te pozdravil pe e Khanđirasa thaj pale gova đelo ani Antiohija. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ačhilo nesavo vreme gothe thaj pale gova đelo gothar. Pa taro than dži ko than đelo maškar i regija Galatija thaj i Frigija thaj zurada sa e sikaden. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ano Efes avilo jekh Jevrejino, alavesa Apolos, savo bijandilo ani Aleksandrija. Vov sasa manuš savo but šukar vaćarola thaj but šukar džanglja e Sveta lila. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Vov sasa sikado taro drom e Gospodeso thaj bare jagasa vaćarola thaj tačno sikavola taro Isus, iako džanglja samo za ke Jovaneso krstipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Thaj lija bizi dar te vaćarol thaj ani sinagoga. Kana šunde le i Priskila thaj o Akila, lije le ke peste thaj po šukar objasnisade lese e Devleso drom. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Kana o Apolos manglja te džal ani Ahaja, e phrala zurade le thaj pisisade e sikadenđe lil te primin le. Kana reslja gothe, but pomožisada kolenđe save palo milost pačaje, ");
INSERT INTO rmyGurbet_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","golese kaj ano javno vaćaripe sesa po zurale ane lafura tare Jevreja. Gija dokažisada andare Sveta lila kaj si o Isus o Mesija. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","I dži kaj sasa o Apolos ano Korint, o Pavle nakhlo e uprune phuva thaj reslo ano Efes. Gothe arakhlja nekoboren sikaden ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","thaj pučlja len: “Primisaden li o Sveto Duxo kana pačajen?” Von vaćarde lese: “Na, ni šundam kaj isi Sveto Duxo!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","O Pavle pučlja len: “Pa tegani save krstimasa krstisaljen?” Von vaćarde lese: “E Jovanese krstimasa.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","O Pavle phenda lenđe: “E Jovaneso krstipe sasa znako taro pokajipe. O Jovane vaćarola e Izraelcurenđe te pačan ane kova savo avol pale leste, a gova si o Isus.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Kana šunde gova, krstisajle ano alav e Gospodeso e Isuseso. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pale gova o Pavle čhuta pe vasta pe lende, o Sveto Duxo ulilo pe lende thaj von lije te vaćaren ane aver čhiba thaj te prorokuin. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Sesa dešuduj (12) manuša. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","O Pavle pale gova đelo ani sinagoga. Gothe, ke gola trin čhon bizi dar vaćarda thaj raspravisajlo ani sinagoga thaj pokušisada te ubedil e Jevrejen taro Carstvo e Devleso. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Al nesave lendar sesa zurale šorenđe, ni manglje te pačan thaj angle manuša kaljarena o Drom e Gospodeso. Tegani o Pavle đelo lendar, pesa inđarda e Isusese sikaden thaj svako đive raspravisada ani učionica e Tiranesi. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Gova sasa duj berš, gija sa e manuša ani Cikni Azija, e Jevreja thaj e abandžije, šunde o Lafi e Gospodeso. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","O Dol prekale Pavlese vasta ćerda but bare čudura. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Gija čak i e maramice thaj e kuštika save o Pavle dolda, e manuša inđarena ke nasvale thaj von sesa sastarde tare pumaro nasvalipe, a e bilačhe duxura ikljona lendar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Golese nesave Jevreja, save phirena taro than dži ko than thaj tradena e bilačhen duxuren thaj pokušisade pe kola ane save sesa e bilačhe duxura te akharen o alav e Gospodeso e Isuseso: “Xav tumen sovli ano Isus kastar vaćarol o Pavle, ikljen!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Gova ćerena efta čhave e Skevase savo sasa jevrejsko baro svešteniko. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Al o bilačho duxo vaćarda lenđe: “E Isuse pindžarav thaj e Pavle džanav, al ko sen tumen?” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Tegani kova manuš ane savo sasa o bilačho duxo, hutija pe lende thaj savoren osvojisada thaj gaći marda len kaj andaro gova čher iklile nanđe thaj ratvale. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Kana dodžanglje sa kava e Jevreja thaj e abandžije save bešle ano Efes, dolda savoren i dar thaj lije te vazden o alav e Gospodeso e Isuseso. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","But tare kala save pačaje, avile thaj putarde lije te priznajin pe bilačhe buća. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","A but tare kala save dikhljarena, ćidije pumare lila thaj phabarde len angle savorende. Kana dikhlje kobor koštin, arakhlje kaj gola lila sesa pinda milje (50 000) srebrenjakura. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Gijate e Gospodese zorasa o Lafi širisajlo thaj zurajlo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Pale sa kava o Pavle odlučisada ano Duxo te načhol maškar i Makedonija thaj i Ahaja, a te džal ano Jerusalim. Vaćarda: “A sar ka avav nesavo vreme odori, trubul te džav i ano Rim.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Gija bičhalda ani Makedonija dujen save pomožisade le, e Timoteje thaj e Eraste, al vov korkoro ačhilo ani Cikni Azija vadži nesavo vreme. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ane gova vreme ano Efes sasa bari buna protiv o Drom e Gospodeso. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Sasa odori nesavo kovači alavesa Dimitrije savo ćerola e Artemidijaće cikne hramura taro srebro thaj gija anola e bućarnenđe bari zarada. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Savoren ćidija katane thaj e majstoren saven sasa slična zanatura thaj vaćarda lenđe: “Manušalen, džanen kaj amaro barvalipe zavisil tari kaja bući. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Dičhen thaj šunen kaj kava Pavle, na samo ano Efes nego skoro ani sa i Cikni Azija, pridobisada thaj xoxada bute manušen. Vaćarola lenđe kaj kola dolura save si ćerde manušikane vastencar naj dolura. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Thaj isi opasnost na samo kaj ka avol bilačho glaso pe amaro zanato, nego i kaj khoni ni ka dičhol po hram tari bari boginja, i Artemidija thaj ka hasarol po baro veličantsvo, sava slavil sa i Cikni Azija thaj sa o sveto!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Kana šunde gova e zanatlije, pherdile holi thaj dije vika: “Bari si i Artemidija taro Efes!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Thaj ano foro sasa bari pometnja. Tegani savore katane prastije ano pozorište thaj vucisade e Gaje thaj e Aristarhe tari Makedonija, save phirde e Pavlesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","O Pavle manglja te ikljol angle manuša, al ni dije le e sikade. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Čak nesave lese amala save sesa šorutne ani Cikni Azija, bičhalde lese haberi ane savo molisade le te ma džal ano pozorište. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","A odori nesave dije vika jekh, a avera khanči aver, golese kaj ano ćidipe sasa pobuna. But manuša ni džanglje ni sose ćidije pe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","E Jevreja gurisade e Aleksandre te ačhol angle manuša thaj von phende lese so te vaćarol. Vov vazdija po va e manušenđe te ma vaćaren thaj lija te branil pe angle manuša. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Kana pindžarde kaj si Jevrejo, duj satura savore dije vika sar jekh: “Bari si i Artemida taro Efes!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Tegani e foroso pisari umirisada e manušen thaj vaćarda: “Manušalen taro Efes! Isi li manuš savo ni džanol bašo foro o Efes savo si čuvari e hrameso e boginjako e Artemidijako thaj lako kipo savo pelo taro nebo? ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Khoni našti vaćarol kaj naj, golese trubul te smirin tumen thaj ma khanči te ćeren bigođako! ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Golese, anden kale manušen save ni čorde khanči andaro hram e Artemidijako thaj ni hulin pi amari boginja. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ako o Dimitrije thaj e bućarne save si lesa, manđen khanika te tužin, o sudo si putardo thaj odori si e upravnikura. Gothe nek tužin jekh avere. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","A te mangljen aver khanči pobut, gova trubul te rešil pe ko zakonito ćidipe e manušengo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Golese isi opasnost kaj šaj te ava optužime za ki pobuna savi ćerdam kava ađive. Naj amen khanči sosa bi šajine te opravdi kava nered.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Kana kava vaćarda, mukhlja e manušen save ćidije pe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Kana nakhli i pobuna, o Pavle akharda e sikaden thaj zurada len. Pale gova oprostisajlo lencar thaj đelo ani Makedonija. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Načhola maškare gola thana thaj ane but lafura zuravola e sikaden. Pale gova reslo ani Grčko ");
INSERT INTO rmyGurbet_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","thaj gothe ačhilo trin čhon. Al golese kaj e Jevreja dikhlje te mudaren le baš kana manglja te džal brodosa ani Sirija, dija gođi te iril pe maškari Makedonija. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Pratisade le o Sopater o čhavo e Pireso tari Verija, o Aristarh thaj o Sekundo andaro Solun, o Gaj andari Derva, o Timotej, o Tihiko thaj o Trofimo andari Cikni Azija. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Von đele angle amende, pa ađućarde amen ani Troada. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","A amen đeljam brodosa taro foro Filipi palo prazniko e bikvasacose mangrengo thaj pale pandž đive arakhljam amen lencar ani Troada, kaj ačhiljam efta đive. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ano angluno đive ano kurko ćidijam amen te la i Gospodnjo večera thaj o Pavle propovedisada amenđe o Lafi. A golese kaj manglja theara đive te džal, vaćarola dži opaš i rat. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ani upruni soba kaj sama ćidime, sesa phabarde but svetiljke. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Thaj jekh terno čhavo kaso alav sasa Evtih bešlo ko džamo. A golese kaj o Pavle vaćarda but, e čhave dolda zuralo sojipe. Sar o sojipe savladisada le, pelo tele taro trito sprato. Thaj kana vazdije le, sasa mulo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Al o Pavle ulilo thaj pelo ke koča paše leste. Dolda le ani angali thaj vaćarda: “Ma uznemirin tumen, džuvdo si!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Pale gova irisajlo upre, ulada i Gospodnjo večera thaj xalje mangro. Thaj vadži but vaćarda lenđe dži sabalje, pa pale gova đelo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","A e manuša inđarde e terne čhave čhere džuvde thaj but sesa utešime. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Čhutam amen angleder ano brodo thaj đeljam ano Asos, kotar trubujam te la e Pavle, golese kaj vov manglja phirindoj te avol gothe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Kana arakhlja pe amencar ano Asos, lijam le ano brodo thaj aviljam ano Mitilino. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Gothar theara đive đeljam brodosa thaj resljam pašo ostrvo Hios. A aver đive đeljam brodosa ano Samos thaj theara đive aviljam ano Milit. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Golese kaj o Pavle odlučisada te načhol pašo Efes te ma bi ačhasa but ani Cikni Azija. Golese kaj siđarda, te bi šajine te resol ano Jerusalim dži ko Prazniko i Pedesetnica. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Andaro Milit o Pavle bičhalda manušen ano Efes te aven e starešine e khanđiraće. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Kana avile leste, vaćarda lenđe: “Tumen džanen kaj taro angluno đive kana aviljem ani Cikni Azija sar ponašisaljem tumencar sa o vreme. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Služisadem e Gospode ano baro poniznost, ane but jasva thaj ane iskušenjura save arakhlje man zbog e Jevrejenđe zavere. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Džanen kaj ni ačhadem te vaćarav so si tumenđe korisno, al sikadem tumen javno thaj ane čhera. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Opomenisadem e Jevrejen thaj e abandžijen te irin pe premalo Dol thaj te pačan ano amaro Gospod o Isus. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Akana, akh, sar so o Duxo čhuvol man, džav ano Jerusalim thaj so ađućarol man gothe, ni džanav. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Samo džanav kaj ane svako foro o Sveto Duxo opomenil man kaj ađućaren man sinđira thaj bilačhipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Al, ni ačhilo manđe dži mo džuvdipe, nego te završiv mo prastipe dži o krajo thaj mi bući savi lijem taro Gospod o Isus, te objaviv o Lačho Lafi taro milost e Devleso. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Akana, akh, džanav kaj khoni tumendar ni ka dičhol man više, savore tumen maškare save putujisadem thaj vaćardem taro Carstvo e Devleso. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Golese ađive svedočiv tumenđe kaj naj sem bango baše nijekheso meripe, ");
INSERT INTO rmyGurbet_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","golese kaj ni ačhadem te vaćarav tumenđe tare sa e Devleso manglipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Aračhen tumen thaj sa o stado e Devleso ane savo o Sveto Duxo čhuta tumen te aven nadglednikura thaj te parvaren i khanđiri e Devlesi, savi poćinda pe ratesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Džanav kaj pale gova so ka džav, ka aven e ratvale ruva save ka čalaven po stado. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Čak maškare tumende ka aven manuša save ka preirin o čačukano sikajipe te bi crdena e sikaden pale peste. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Golese aven džungade! Ma bistren kaj trin berš ni ačhadem đive ni rat jasvencar te opomeniv dži jekhe tumendar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Akana, ačhavav tumen e Devlese thaj ano Lafi taro Leso milost, savo šaj te zuravol tumen thaj te dol tumen nasledstvo maškare sa save si posvetime. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Nikad ni sema željno baše khanikaso srebro ni zlato, ni baše khanikase šeja. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Korkore džanen kaj mingre vasta služisade za ke mingre potrebe thaj za ke potrebe kolenđe save sesa mancar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ane sa sema tumenđe primer sar trubun te trudin tumen, te pomognin kolenđe save si ano bilačhipe thaj te den gođi baše lafura save vaćarda korkoro o Gospod o Isus: ‘Po blagoslovimo si te da nego te la.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Kana o Pavle kava vaćarda, pelo ke koča thaj molisajlo savorencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Savore lije te roven zurale, te grlin e Pavle thaj te čumiden le. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Al embut sasa lenđe pharo kaj o Pavle phenda lenđe kaj ni ka dičhen le više. Pale gova ispratisade le ko brodo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Kana oprostisaljam lendar, đeljam brodosa pravo ko ostrvo Kos thaj dujto đive ano Rodos, a gothar ano Patar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Odori arakhljam brodo savo načhola tari Fenikija, gija ukliljam ane leste thaj đeljam. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Kana dikhljam o Kipar, nakhljam tari levo rig e brodosi thaj đeljam premali Sirija. Ačhiljam ano Tir golese kaj trubuja te uljarol pe o pharipe taro brodo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Gothe arakhljam e Gospodese sikaden thaj ačhiljam lencar efta đive. Lenđe o Duxo objavisada so ađućarol e Pavle thaj vaćarde lese te ma džal ano Jerusalim. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Kana nakhle gola đivesa, nastavisadam o drom. Savore von iklile pe romnjencar thaj pe čhavencar te ispratin amen andaro foro dži i obala thaj peljam pe koča te moli amen e Devlese. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Pale gova oprostisaljam jekh averendar, amen đeljam ano brodo thaj von irisajle ane pe čhera. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Andaro Tir đeljam brodosa ani Ptolemaida. Gothe pozdravisadam e phralen thaj e phejen thaj jekh đive ačhiljam lencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Theara đive đeljam thaj resljam ani Kesarija. Odori đeljam ano čher e Filipeso thaj ačhiljam leste. O Filip propovedila taro Lačho Lafi thaj vov sasa jekh tare kola save pomožina e romnjenđe kase roma mule. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Le sesa štar bidinde čheja, saven sasa daro te prorokujin. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Gothe bešljam but đive thaj tegani andari Judeja avilo jekh proroko alavesa Agav. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Avilo ke amende, lija e Pavlesi kuštik, phanglja pe pingre thaj pe vasta thaj phenda: “Kava vaćarol o Sveto Duxo: ‘Gija e Jevreja ano Jerusalim ka phanden e manuše kasi si kaja kuštik thaj ka den le ane vasta e abandžijenđe.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Kana šundam kava, i amen thaj e manuša ane kava foro molisadam e Pavle te ma džal upre ano Jerusalim. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Tegani o Pavle phenda: “So ćeren? Sose roven thaj phađen mingro ilo? Bašo alav e Gospodeso e Isuseso, me sem spremno na samo te avav phanglo, nego ano Jerusalim i te merav.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","A sar naštine te iri le tare gova, mukhljam le thaj vaćardam: “Nek avol sar o Gospod manđol!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Pale gova spremisaljam za ko drom thaj đeljam ano Jerusalim. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Nesave pačavne andari Kesarija đele amencar. Von inđarde amen ano čher e Mnasonaso te ava lese gostura. Vov sasa taro Kipar thaj jekh tare anglune sikade. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Kana aviljam ano Jerusalim, primisade amen šukar e phrala thaj e pheja. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Theara đive đelo o Pavle amencar ko Jakov; sesa gothe i sa e starešine tari jerusalimsko Khanđiri. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","O Pavle pozdravisajlo lencar thaj lija te vaćarol lenđe sa so ćerda o Dol prekal lesi služba maškare abandžije. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Kana von šunde gova, hvalisade e Devle thaj vaćarde e Pavlese: “Phrala, dičhe li, kobor but milja Jevreja pačaje. Thaj savore von zurale ićarenpe pe Mojsijaso Zakon. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Al šunde kaj tu sikave sa e Jevrejen save bešen maškare abandžije, te ma ićarenpe pe Mojsijaso Zakon. Šunde kaj sikave te ma ćeren suneti pe čhavenđe, ni te ma živin pale adetura. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","So te ćera akana? Von sigurno ka šunen kaj aviljan. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Golese ćer gija sar so ka vaćara tuće. Maškar amende isi štar džene save dije zavet. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Le len tusa, ćer lencar katane o adeti e thodimaso thaj poćin lenđe troškura tare adetura te šaj te randen po šoro. Gija savore ka džanen kaj naj čače khanči tare gova so šunde tutar, nego kaj i tu korkoro ićare tut pe Mojsijaso Zakon thaj živi pale leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","A baše abandžije save pačaje, amen bičhaldam o lil ane savo odlučisadam kaj trubun te aračhen pe taro xape savo si žrtvujime e idolurenđe, te ni pijen o rat, te ni xan mas e tasade životinjengo kaso rat ni thavdija thaj te ni ćeren blud.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Theara đive o Pavle lija pesa kole štare dženen thaj ćerda lencar o adeti e thodimaso. Pale gova đelo ano Hram thaj vaćarda kana ka načhen e đivesa taro lengo adeti e thodimaso thaj kana ka dol pe žrtva savorenđe lendar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Kana skoro nakhle gola efta đive, dikhlje e Pavle ano Hram nesave Jevreja tari Cikni Azija. Tegani pobunisade sa e manušen, dolde e Pavle ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","thaj dije vika: “Izraelcuralen, pomožin! Kava si manuš savo svugde sikavol sa e manušen protiv amare manuša thaj amaro Zakon thaj protiv kava than! Akana čak thaj e abandžijen anol ano Hram thaj golesa meljarda kava sveto than.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(Angleder gova, e Jevreja dikhlje e Trofime taro Efes e Pavlesa ano foro thaj golese dije gođi kaj o Pavle anda le ano Hram.) ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Sa o foro uštilo thaj e manuša lije te prasten tare sa e riga, dolde e Pavle thaj čhudije le andaro Hram thaj sigate phanglje e vudara pale leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","E manuša manglje te mudaren le, al o glaso avilo dži ko šorutno komandiri tari rimsko četa kaj si sa o foro o Jerusalim ani pometnja. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Vov sigate lija pe vojnikuren thaj e kapetanuren thaj prastija dži lende. Kana e manuša dikhlje e komandire thaj e vojnikuren, ačhade te maren e Pavle. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","O komandiri avilo paše leste, dolda le thaj naredisada te phanden le ane duj sinđira. Pale gova lija te pučol ko si kava manuš thaj so ćerda. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Nesave manuša dije vika jekh, a avera aver. Kana o komandiri ane goja gužva naštine te haljarol khanči tare manuša, naredisada te inđaren e Pavle ani kasarna. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Kana o Pavle avilo ke stepenice, e manuša sesa gaći nasilna kaj morajle e vojnikura te inđaren le ane vasta. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","But manuša đele pale lende thaj dije vika: “Mudaren le!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Kana spremisade e Pavle te inđaren ani kasarna, vov vaćarda e komandirese: “Šaj li khanči te vaćarav tuće?” A vov pučlja le: “Tu li džane grčki? ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Naj li san, tegani, tu kova Egipćano savo ćerda buna angleder nesavo vreme thaj inđarda pesa štar milje (4 000) razbojnikuren ani pustinja?” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","O Pavle phenda: “Me sem Jevrejo andaro Tars ani Kilikija, forutno taro pindžardo foro. Moliv tut mukh man te vaćarav e manušenđe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Kana mukhlja le o komandiri te vaćarol, o Pavle ačhilo ke stepenice thaj vazdija po va premale manuša golese kaj manglja te vaćarol. Kana sasa tišina, o Pavle lija te vaćarol lenđe ki jevrejsko čhib: ");
INSERT INTO rmyGurbet_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","O Pavle phenda: “Phralalen thaj dadalen! Šunen akana so isi man te vaćarav tumenđe ani mingri odbrana.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Kana šunde kaj vaćarol jevrejskone čhibasa, sasa pobari tišina. Tegani o Pavle vaćarda: ");
INSERT INTO rmyGurbet_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Me sem Jevrejo, bijando ano kilikijsko Tars, al barado sem ane kava foro, sikliljem paše pingre e Gamalilese thaj šukar sem sikado palo zakon amare paradadengo. Revno služisadem e Devle sar savore tumen ađive. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","E manušen save džan akale Dromesa me gonisadem dži o meripe. E muršen thaj e džuvljen phangljem ane sinđira thaj čhutem len ano phanglipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Tare kava šaj te svedočil o baro svešteniko thaj sa o Baro sudo e starešinengo. Lendar dobisadem lila baše amare jevrejska phrala ano Damask thaj đeljem odori te anav len ano Jerusalim ane sinđira, te bi avena kaznime.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Al kana sema ko drom thaj aviljem pašo foro o Damask, ko opašo đive tari jekh drom pe mande svetlisada zuralo svetlost taro nebo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Peljem ki phuv thaj šundem glaso savo vaćarda manđe: ‘Savle! Savle! Sose goni man?’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Me pučljem: ‘Ko san tu, Gospode?’ O glaso vaćarda manđe: ‘Me sem o Isus o Nazarećanino kas tu progoni.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Kola save sesa mancar dikhlje gova svetlost, al ni haljarde o glaso koleso savo vaćarola mancar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Me pučljem: ‘So te ćerav, Gospode?’ A o Gospod vaćarda manđe: ‘Ušti thaj dža ano Damask! Gothe ka avol tuće phendo sa so o Dol odredisada te ćere.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Gova svetlost sasa gaći zuralo, kaj ačhiljem koro thaj kola so sesa mancar inđarde man vastesa ano Damask. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Odori sasa nesavo manuš savo akhardola Ananija. Vov verno ićarola pe po Zakon thaj sasa ko šukar glaso maškare Jevreja so bešle gothe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Vov avilo ke mande, ačhilo paše mande thaj phenda: ‘Phrala Savle, dikh!’ Thaj ane gova sato predikhljem thaj dikhljem e Ananija. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Tegani o Ananija vaćarda manđe: ‘O Dol amare paradadengo angleder birisada tut te pindžare leso manglipe thaj te dičhe lese Pravedniko thaj te šune leso glaso andare leso muj. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Golese kaj angle sa e manuša ka svedoči tare gova so dikhljan thaj šundan. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Thaj akana, so ađućare? Ušti thaj krsti tut! Thov tut tare ćire grehura gija so ka de vika e Gospodeso alav.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Kana irisaljem ano Jerusalim, đeljem ano Hram. Dži kaj molisaljem, sasa man vizija. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Dikhljem e Gospode sar vaćarol manđe: ‘Siđar thaj dža sigate andaro Jerusalim, golese kaj ni ka prihvatin ćiro svedočanstvo mandar.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","A me vaćardem: ‘Gospode, kala manuša džanen kaj đeljem andari sinagoga ki sinagoga te dolav thaj te marav kolen so pačan ane tute. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Von džanen kaj sema gothe kana mudarde e Stefane, ćire svedoko thaj odobrisadem thaj arakhljem e šeja kolenđe save mudarde le.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Al o Gospod phenda manđe: ‘Dža! Golese kaj me ka bičhalav tut dur maškare abandžije.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","E Jevreja šunde le dži kala lafura, al pale kava lije andaro baro glaso te den vika: “Crden gasave tari phuv! Ni zaslužil gasavo te avol džuvdo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Dok gija dije vika, čhudije pestar e fostanura thaj čhudije o praho ano vazduho. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","O komandiri naredisada te inđaren e Pavle ani kasarna. Naredisada te čalaven le bičosa thaj te pučen le, te bi dodžanena sose e Jevreja but dije vika pe leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Kana lije te phanden te bi bičujina le, o Pavle pučlja e kapetano savo gothe ačhola: “Smin li te bičujin e rimskone manuše kase naj dokažimi nisavi krivica?” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Kana o kapetano šunda kava, đelo ko komandiri thaj vaćarda lese: “So manđe te ćere? Kava manuš si rimljanino.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Tegani o komandiri avilo dži leste thaj pučlja le: “Vaćar manđe, tu li san čače rimljanino?” A o Pavle phenda: “Va.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","O kapetano vaćarda lese: “Me poćindem gova but te avav rimljanino.” Al o Pavle vaćarda lese: “Me bijandiljem sar rimljanino.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","E vojnikura, save spremisajle te bičujin e Pavle, sigate crdije pe. Kana o komandiri haljarda kaj si o Pavle rimljanino darajlo, golese kaj vov čhuta le ane sinđira. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","O komandiri manglja te džanol sose tužin e Jevreja e Pavle. Gija theara đive mukhlja le andaro phanglipe thaj naredisada e šorutne sveštenikurenđe thaj savorenđe taro Baro sudo te ćiden pe. Tegani ikalda e Pavle thaj anda le angle lende. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","O Pavle dikhlja ane manuša taro Baro sudo thaj vaćarda: “Phralalen! Sa dži kava đive me živisadem anglo Dol e šukare savestesa.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","O baro svešteniko o Ananija zapovedisada kolenđe so ačhile paše leste te čalaven le po muj. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Tegani vaćarda o Pavle: “Tut o Dol ka marol, tu dujemujengo – duvarona krečimeja ano parno! Tu beše te sudi man palo Zakon, al zapovedi te čalaven ma, so si protivno e Zakonose!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Kola so ačhile pašo Pavle vaćarde: “Akuše e Devlese bare svešteniko?” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","A o Pavle vaćarda: “Ni džangljem, phralalen, kaj si baro svešteniko, golese kaj ačhol ano Sveto lil: ‘Ma akuš e šorutne ćire narodose.’” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Kana o Pavle džanglja kaj nesave sesa sadukejura thaj aver fariseja, dija vika ano Baro sudo: “Phralalen! Me sem farisejo, čhavo e farisejeso thaj osudin man golese so isi man nada ano uštipe tare mule!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Sar phenda kava, maškare fariseja thaj e sadukeja lije te aven čingara thaj o ćidipe e manušengo delisajlo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(Golese kaj e sadukejura vaćarena kaj naj uštipe tare mule, naj ni anđelura ni duxura; al e fariseja ane sa kava pačan.) ");
INSERT INTO rmyGurbet_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Thaj lija te avol bari vika, uštile nesave učitelja tare Mojsijaso zakon tari rig e farisejenđi thaj zurale ćerde čingara: “Ni dikha kaj akava manuš ćerda nesavo bilačhipe. So ako vaćarda lese o duxo il o anđelo? Te ma suprostavi amen e Devlese.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Kana sasa pobari čingar, darajlo o komandiri ma e Pavle te čhinen ke kotora. Golese zapovedisada e vojnikurenđe te uljen maškare manuša thaj te crden e Pavle lendar thaj te inđaren le ani kasarna. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Aver rat pojavisajlo o Gospod angle leste thaj vaćarda: “Ma dara! Golese, sar so svedočisadan mandar ano Jerusalim, gija trubul te svedoči mandar thaj ano Rim.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Kana đivesajlo, nesave Jevreja ćerde zavera thaj xalje sovli kaj ni ka xan thaj ni ka pijen dok ni mudaren e Pavle. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Sesa pobut tare saranda (40) džene save xalje kaja sovli. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Pale gova avile ke šorutne sveštenikura thaj ke starešine thaj vaćarde lenđe: “Zurale xaljam sovli kaj khanči ni ka čhuva ano muj dok ni mudara e Pavle. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Golese akana tumen, katane e manušencar taro Baro sudo, roden taro komandiri zahtev te anen le palem tumenđe. Vaćaren kaj manđen pošukar te ispitujin leso slučaj. A amen sam spremna te mudara le angleder so resol kate.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Al o čhavo e Pavlese phejako šunda baši kaja zavera thaj đelo ani kasarna gova te vaćarol e Pavlese. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Tegani o Pavle dija vika jekhe tare kapetanura thaj vaćarda: “Kale terne čhavore inđar ko komandiri, golese kaj isi le khanči te vaćarol lese!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","O kapetano lija le thaj inđarda le ko komandiri thaj vaćarda: “O phanglo Pavle dija man vika thaj molisada man kale terne čhavore te anav ke tute, golese kaj isi le khanči te vaćarol tuće.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","O komandiri lija le taro va, crdija le ki strana thaj pučlja le: “So isi tut te vaćare manđe?” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","O terno čhavo phenda lese: “E Jevreja vaćarde maškare peste te zamolin tut te ane e Pavle theara ko Baro sudo, te bi hatam šajine pošukar te raspučen pe lestar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Al tu ma te šune len, golese kaj ađućaren le čorale pobut tare saranda (40) džene. Kala xalje sovli kaj khanči ni ka xan thaj ni ka pijen dok ni mudaren le. Akana si spremna thaj samo ađućaren tu te dozvoli kava.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","O komandiri mukhlja e terne čhave thaj zapovedisada lese: “Ma khanikase te vaćare kaj phendan manđe kava.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Tegani o komandiri dija vika pe duje kapetanuren thaj vaćarda lenđe: “Pripremin manđe dujšel (200) vojnikuren, eftavardeš (70) dženen so jašin pe grasta thaj dujšel (200) dženen save inđaren koplja, te džan dži ki Kesarija, ko enjato sato ani rat. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Spremin e grasten e Pavlese thaj nek inđaren le džuvde dži ko upravitelji o Feliks.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Pale gova pisisada kava lil: ");
INSERT INTO rmyGurbet_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Klaudije Lisije, e poštujime upraviteljese e Feliksese: Pozdraviv tut! ");
INSERT INTO rmyGurbet_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Kale manuše dolde e Jevreja thaj manglje te mudaren le. Al kana dodžangljem kaj si rimljanino, me aviljem mingre vojnikurencar thaj ikaldem le andare lenđe vasta. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Mangljem te džanav sose tužin le thaj inđardem le ke lengo Baro sudo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Tegani dodžangljem kaj tužin le baše nesavo lengo versko Zakon, al naj bango khančese sose bi trubula te avol mudardo il te džal ano phanglipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Kana sasa manđe vaćardo kaj planirin te mudaren kale manuše, sigate bičhaldem le ke tute, a lese tužiteljen naredisadem te phenen tuće sose tužin le. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Gija e vojnikura, sar so sasa lenđe vaćardo, lije e Pavle thaj ani rat inđarde le ani Antipatrida. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Theara đive, lesa ačhade e manušen save jašin pe grasta te džan e Pavlesa po dur, dži ki Kesarija, a von irisajle ani kasarna. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Kana resle ani Kesarija, dije o lil e upraviteljese thaj ande e Pavle angle leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Kana o upravitelji čitisada o lil, pučlja le andar savi si pokrajina. Kana dodžanglja kaj si andari Kilikija, ");
INSERT INTO rmyGurbet_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","vaćarda: “Ka šunav tut thaj ka dikha so ka ćera, kana ka resen i ćire tužitelja.” Pale gova zapovedisada te aračhen le ani Irodesi palata. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Pale pandž đive avilo ani Kesarija o baro svešteniko o Ananija nesave starešinencar thaj nesave advokatesa e Tertulesa. Von iklile anglo upravitelji pe optužbencar protiv o Pavle. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","E Pavle dije vika andre, a o Tertul anglo Feliks lija te vaćarol e optužbe protiv o Pavle: “Poštujimeja Felikse, ani zahvala tuće amen uživi ano mir, a ani zahvala baše ćiro baro džanglipe, ani amari phuv ćerde pe bare važna promene. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Amen sam tuće, Felikse, but zahvalna za ke sa gova thaj ko svako than amen priznaji gova. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Al te ma dosadiv tut but, moliv tut zala te šune amen ane ćiro šukaripe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Golese kaj arakhljam kaj si kava manuš sar kuga. Vazdol pobune maškare sa e Jevreja ano sa o rimsko carstvo thaj si šorutno pi nazaretsko sekta. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Thaj vov dikhlja o Hram te poganil, al amen doldam le. Mangljam te sudi le pale amare zakonura, ");
INSERT INTO rmyGurbet_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","al avilo o Lisije, o komandiri. Vov lija le andare amare vasta ki sila ");
INSERT INTO rmyGurbet_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","thaj naredisada kolenđe so tužisade le te aven angle tute. Te ispitujisadan le, i tu korkoro šaj uveri tut kaj amaro tužipe si opravdimo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","A e Jevreja potvrdisade kaj si čače sa kava. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Kana o upravitelji dija znako o Pavle te vaćarol, o Pavle phenda: “Džanav kaj san but berša sudija ane kaja phuv, golese mirnone dušasa ka vaćarav mingri odbrana. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Šaj te uveri tut kaj gova naj pobut tare dešuduj (12) đive so đeljem ano Jerusalim te klanjiv man e Devlese ano Hram. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Kola so tužisade man ni arakhlje man kaj khanikasa ćerav čingara ano Hram, ni kaj buniv e manušen ane sinagoge il ano foro ");
INSERT INTO rmyGurbet_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","thaj von našti te dokažin kaj si čače gova sose akana tužin man. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Al kava šaj priznajiv: Me služiv e Devle amare paradadengo thaj džav pe Gospodeso Drom, savo von akharen sekta. Pačav ane sa so si pisimo ane Mojsijaso Zakon thaj ane proročka lila. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Isi man gasavi nada ano Dol, sar kala akate so isi len, kaj e čačukane thaj e grešnikura ka ušten tare mule. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Golese i me trudiv man te avol man thodo savest anglo Dol thaj angle manuša. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Pale but berša aviljem te anav milostinja mingre narodose thaj te dav žrtve e Devlese. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Kola so tužin man dikhlje man ano Hram kana završisadem o adeti e thodimaso. Trujal mande ni sesa manuša niti sasa nisavi pobuna. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Gova sesa nesave Jevreja tari Cikni Azija. Von bi trubuna te aven angle tute thaj te tužin man, ako khanči isi len protiv mande. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Il, nek vaćaren i kala so si akate, savo bilačhipe arakhlje pe mande kana ačhiljem anglo Baro sudo, ");
INSERT INTO rmyGurbet_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","sem te naj gova so dijem vika kana ačhiljem maškare lende: ‘Tumen ađive sudin man so pačav ano uštipe tare mule!’” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Kana šunda kava o Feliks, savo šukar džanglja e Gospodeso Drom, ačhada kava sudipe thaj vaćarda: “Kana ka avol o komandiri o Lisije, tegani ka rešiv tumaro slučaj.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","E kapetanose naredisada te aračhen e Pavle thaj te aven le nesave olakšice thaj te ma branin ako aven nesave lese manuša te služin le. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Pale nekobor đivesa avilo o Feliks pe romnjasa e Drusilasa, savi sasa Jevrejka. Bičhalda palo Pavle thaj šunda le sar vaćarol taro pačajipe ano Isus Hrist. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Al kana o Pavle lija te vaćarol taro čačipe, tari samokontrola thaj taro sudo savo ka avol, o Feliks darajlo thaj vaćarda: “Akana šaj dža. Kana ka arakhav vreme, ka dav tut vika.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Paše gova, nadisajlo kaj ka dol le o Pavle pare te bi mučhola le. Golese pobut droma bičhalda pale leste thaj vaćarda lesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Kana nakhle duj berš, e upravitelje e Felikse nasledisada o Porkije Fest. A golese kaj o Feliks manglja te avol šukar e Jevrejencar, ačhada e Pavle ano phanglipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Trin đive sar o Fest postanisada upravitelji ani Judeja, iklilo andari Kesarija thaj đelo ano Jerusalim. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Gothe e šorutne sveštenikura thaj e jevrejska šorutne ikalde pe optužbe protiv o Pavle. Molisade le ");
INSERT INTO rmyGurbet_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","te ćerol lenđe usluga te avol o Pavle bičhaldo ano Jerusalim, golese kaj spremisade zaseda kaj manglje e Pavle odrumal te mudaren. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","O Fest vaćarda lenđe kaj e Pavle ićaren ano phanglipe ani Kesarija thaj kaj vov korkoro sigate ka džal odori. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Thaj vadži vaćarda: “Nek nesave tare tumare šorutne aven mancar thaj ako si gova manuš baše khanči bango, šaj tužin le.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Pale gova so lencar o Fest ačhilo ohto il deš đive irisajlo ani Kesarija. Theara đive bešlo ki stolica e sudijasi thaj naredisada te anen e Pavle. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Kana ande e Pavle, e Jevrejska starešine save avile andaro Jerusalim ačhile trujal leste thaj but phare tužbe vaćarde protiv leste, al naštine gova te dokažin. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Tegani o Pavle branisajlo gija: “Ni ćerdem khanči bilačhe premal o jevrejsko Zakon, ni premal o Hram, ni premal o caro.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Al o Fest manglja te avol šukar e Jevrejencar, golese pučlja e Pavle: “Manđe te dža upre ano Jerusalim te ave sudimo angle mande baše kala optužbe?” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Al o Pavle vaćarda: “Me ačhav anglo sudo e Cezareso thaj kate trubul te sudil pe manđe. E Jevrejenđe ni ćerdem bilačhipe, sar so korkoro gova šukar džane. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Te sem bango thaj te ćerdem bilo so, baše so zasluživ te merav, ni našav taro meripe. Al ako e optužbe save protiv mande vaćaren kala manuša naj čače, khoni ni smil te dol man ane lenđe vasta. Mangav te avav sudimo anglo Cezar!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Kana o Fest vaćarda pe manušencar save savetujina le, phenda e Pavlese: “Anglo Cezar manđe te ave sudimo, anglo Cezar ka dža!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Pale nekobor đive, resle ani Kesarija o caro o Agripa thaj i Vernika te dičhen pe e Festesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","A sar ačhile gothe pobut đive, o Fest rodija savet taro caro, taro slučaj e Pavleso: “Kate isi jekh manuš kas ačhada o Feliks ano phanglipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Kana sema ano Jerusalim, e jevrejska šorutne sveštenikura thaj e starešine tužisade le angle mande thaj rodije te avol osudimo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Me vaćardem lenđe kaj ke Rimljanura naj o adeti te kaznil pe khoni angleder so vov, o tužimo, ni suočil pe e manušencar save tužin le thaj ni branil pe lendar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Gija, kana von avile mancar akari, ni ađućardem. Theara đive bešljem ki stolica e sudijasi thaj naredisadem te anen gole manuše. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Kana lese tužitelja uštile te vaćaren protiv leste, ni tužisade le baše ni jekh bilačhipe savo ađućardem. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Mesto gova ikalde nesave buća pe save ni složisajle lesa baši lenđi religija thaj vaćarde taro nesavo Isus, savo mulo, a kastar o Pavle vaćarol kaj si džuvdo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","A me naštine te snalaziv man ane goja čingar maškar lende, pa pučljem gole manuše dal bi manđola te džal ano Jerusalim te avol sudimo odori. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Al sar o Pavle rodija po pravo te ačhol ani Kesarija dži ki presuda e bare Cezaresi, gija naredisadem te aračhen le ano phanglipe sa dži kaj ni bičhalav le ko Cezar.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Tegani o Agripa vaćarda e Festese: “I me bi mangava te šunav gole manuše.” O Fest phenda lese: “Theara ka šune le.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Theara đive o Agripa thaj i Vernika avile ano baro sjaj. Avile ani dvorana katane e komandirencar thaj e ugledna manušencar tare kava foro. Pale gova o Fest naredisada te anen e Pavle. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","O Fest vaćarda: “Agripe carona thaj savore save sen kate! Dičhen kale manuše! Le tužisada sa o jevrejsko katanipe ano Jerusalim thaj akate, a von dije vika kaj trubul te merol. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","A me ni arakhljem, kaj ćerda khanči sose bi mudarava le. Al, golese kaj vov rodija te avol sudimo anglo baro Cezar, odlučisadem te bičhalav le ano Rim. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Al naj man khanči konkretno so šaj pisiv protiv kava manuš e gospodarese. Golese ikaldem le angle tumende a posebno angle tute, carona Agripe, te pučen le. Gija ka šaj khanči te pisiv e Cezarese. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Golese kaj naj smisla te bičhalav e manuše savo si phanglo ano Rim a te ni pisiv sostar tuživ le.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Tegani o Agripa vaćarda e Pavlese: “Mukhlja pe tuće te vaćare ani ćiri odbrana.” O Pavle vazdija po va thaj lija te vaćarol piri odbrana: ");
INSERT INTO rmyGurbet_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Carona Agripe, smatriv kaj sem baxtalo so šaj ađive angle tute te braniv man tare sa kova sostar e Jevreja tužin man, ");
INSERT INTO rmyGurbet_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","golese kaj tu embut džane sa e jevrejska adetura thaj e pačavne buća pe save ni složin pe. Golese moliv tut te šune man strpljivo! ");
INSERT INTO rmyGurbet_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Sa e Jevreja džanen mingro džuvdipe tare mingro ciknipe maškar mingro narodo thaj ano Jerusalim. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Pindžaren man odavno, a šaj te manglje, gova i te phenen, kaj živisadem sar farisejo thaj poštujisadem emstroga pravila ani amari religija. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Al akana ačhav anglo sudo zbog mingri nada bašo obećanje savo dija o Dol amare paradadenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Amare dešuduj (12) plemenura nadin pe baše leso pheripe thaj iskreno služin e Devle đive thaj rat. Baši goja isto nada, carona, e Jevreja tužin man. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Sose den gođi kaj si nemoguće o Dol te vazdol e mulen? ");
INSERT INTO rmyGurbet_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Gija i me smatrisadem kaj trubul te bori man protiv o alav e Isuseso e Nazarećanineso. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Gova ano Jerusalim i ćerdem. Tare šorutne sveštenikura dobisadem ovlašćenje thaj me buten svetone manušen čhutem ano phanglipe. A kana mudarde len, me gova odobrisadem. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Često, ke sa e sinagoge kaznisadem len thaj čhutem len te odreknin pe tare piro pačajipe. Gaći holjamo sema pe lende kaj gonisadem len i ane aver forura. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Gijate, palo ovlašćenje thaj odobrenje e šorutne sveštenikurengo đeljem ano Damask. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Ko opaš o đive, carona, sar putujisadem, dikhljem o svetlost taro nebo savo sasa po zuralo tare khameso sjaj, savo sijajisada pe mande thaj pe kola save sesa mancar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Savore peljam ki phuv thaj me šundem glaso savo manđe vaćarda jevrejskone čhibasa: ‘Savle, Savle! Sose goni man? Samo tuće ane šteta so bori tut protiv mande – sar e guruvese so si pharo te ritil i oštrime rovli.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Me pučljem le: ‘Ko san tu, Gospode?’ A o Gospod phenda: ‘Me sem o Isus kas tu progoni. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Al, ušti akana thaj ačh ke pingre! Sikadiljem tuće te ćerav tut mingro sluga thaj svedoko tare kova so dikljan thaj vadži tare kova so ka sikavav tuće. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Me ka ikalav tut tare ćiro narodo thaj tare abandžije, kaste ka bičhalav tut, ");
INSERT INTO rmyGurbet_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","te putre lenđe jakha, te irin pe taro kalipe ko svetlost thaj tare Satanaso vlast, premalo Dol, gijate, e pačajimasa ane mande lenđe grehura te aven oprostime thaj te aven primime maškare kola save si sveta.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Golese, carona Agripe, ni sema neposlušno premali vizija taro nebo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Gija angleder propovedisadem e manušenđe ano Damask, pale gova kolenđe ano Jerusalim thaj ani sa i judejsko phuv thaj e abandžijenđe te pokajin pe, te irin pe e Devlese thaj te ćeren buća save dokažin o pokajipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Golese e Jevreja dolde man kana sema ano Hram thaj manglje te mudaren man. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Al o Dol arakhlja man dži ađive. Gijate, šaj ačhav kate thaj svedočiv e ciknenđe thaj e barenđe. Me ni phenav aver khanči nego so e prorokura thaj o Mojsije vaćarde kaj ka avol. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Phende kaj o Hrist ka merol thaj kaj sar angluno ka uštol tare mule thaj ka vaćarol taro svetlost e Jevrejenđe thaj e abandžijenđe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Dži kaj o Pavle branila pe kale lafurencar, o Fest bare glasosa dija vika: “Dilaljan, Pavle! Ćiro baro džanglipe ikalol tut tari gođi.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","O Pavle phenda leste: “Ni dilaljem, poštujimeja Feste, nego vaćarav čačukane thaj razumna lafura. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","O caro kalestar džanol, golese vaćarav angle leste putarde. Ni pačav kava so vaćardem si lese bipindžarutno, golese kaj kava ni sasa ane nesavo garado than. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Carona Agripe, pača li ane kova so vaćarde e prorokura? Džanav kaj pača!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Tegani o Agripa vaćarda e Pavlese: “Tu li misli gija ločheste šaj ćere te avav hrišćano!” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","O Pavle vaćarda: “Ločheste il phareste, me moliv e Devle na samo tu nego i sa kala save šunen man ađive te aven gasave sar savo sem me, al bize kala sinđira.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Tegani uštile o caro, o upravitelji, i Vernika thaj kola save bešle lencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Dži kaj ikljona avri, lije te vaćaren maškare peste: “Kava manuš ni ćerol khanči sose bi zaslužila te avol phanglo il mudardo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","O Agripa vaćarda e Festese: “Kava manuš šajine te avol mukhlo, te ma vaćarola kaj manđol te avol sudimo anglo Cezar.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Kana sasa odlučimo te dža brodosa ani Italija, predije e Pavle thaj nesave avere phangle manušen ko kapetano so akhardola Julije savo sasa tari četa e Cezaresi. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Đeljam ko brodo andaro foro Adramitij, savo džala dži ke thana ani Cikni Azija thaj otplovisadam. Amencar sasa thaj o Aristarh, o Makedonco taro Solun. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Theara đive aviljam ano Sidon. O Julije šukar sasa premalo Pavle thaj mukhlja le te džal ke pe amala, te bi von dena le sa so trubul le. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Kana đeljam gothar, nakhljam e brodosa tari rig kaj naj but balval ano Kipar, golese kaj i balval phurdija premal amende. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Kana nakhljam i pučina paši obala i Kilikija thaj i Pamfilija, resljam ani Likijsko Mira. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Odori o kapetano arakhlja jekh aleksandrijsko brodo savo džala ani Italija thaj čhuta amen ane leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","But đive đeljam brodosa po zala thaj nesar resljam pašo Knid. I balval ni mukhlja amen te ićara amaro smer, golese plovisadam ki rig kaj naj but balval, taro Krit pašo Salmon. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Phareste đeljam paši obala thaj resljam dži ko than savo akhardol “Šukar luke”, pašo foro Laseja. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Hasardam but vreme thaj amari plovidba lija te avol but opasno, golese so nakhlo o Jevrejsko Post. Gija o Pavle lija te opomenil len: ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Manušalen, dikhav kaj amari plovidba ka avol but opasno thaj ka avol bari šteta, na samo bašo brodo thaj baše leso pharipe, nego i baše amaro džuvdipe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Al o kapetano po but pačaja e kormilare thaj e manuše kaso sasa o brodo, nego e Pavle. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Golese kaj goja luka ni sasa šukar pašo brodo te ačhol ko jevend gothe, po but džene odlučisade te crden pe gothar thaj ako šajine te resen ani luka Feniks thaj odori te nakhaven o jevend. Goja luka sasa ko Krit, savi dičhol ko jugozapad thaj severozapad. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Kana lija te phurdol cikni južno balval, dije gođi kaj ka šaj te ćeren gova so manglje, gija vazdije o sidro thaj plovisade paši obala e Kritesi. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Al ni nakhlo but thaj lija taro ostrvo Krit te phurdol zurali balval savi akhardol Evroklidon. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Tegani e brodo dolda i balval thaj khanči naštine te ćerol pe protiv goja balval, golese mukhljam i balval te inđarol amen. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Kana nakhljam e brodosa ki rig kaj naj but balval pašo cikno ostrvo savo akhardol Klauda, bare mukasa uspisadam te ićara o čamco e spasimaso. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Vazdije o čamco ki paluba thaj dorencar phanglje o brodo. Darajle te ma zaglavin pe ano plitko paj paši obala i Sirta, mukhlje o sidro thaj gija i balval inđarda len. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Golese kaj dolda amen bari oluja, theara đive lije te čhuden o pharipe taro brodo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Trito đive pe vastencar čhudije čak i oprema e brodosi. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","But đivesa ni dikhljam ni o kham ni e čerenja thaj i zurali oluja ni ačhili te čalavol po brodo, tegani hasardam svako nada kaj ka spasi amen. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","But đivesa khoni ni xalja khanči. Tegani o Pavle ačhilo angle lende thaj vaćarda: “Manušalen, trubujen te šunen man thaj te ma crda amen taro Krit. Gija ni ka avena pe amende gaći muke thaj štete. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Al akana moliv tumen, ma daran, golese kaj ni jekh tumendar ni ka hasarol po džuvdipe, sem so ka potonil o brodo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Golese kaj kaja rat ačhilo angle mande o anđelo e Devleso kase me preperav thaj kas služiv. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","O anđelo vaćarda manđe: ‘Ma dara, Pavle. Trubul te ave sudimo anglo Cezar! Akh, tuće o Dol obećisada kaj zbog tute ka spasil sa kolen save plovin tusa.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Golese, manušalen, ma daran! Golese kaj pačav e Devlese kaj ka avol sar so vaćarda manđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Al, trubul o brodo te phađol paše nesavo ostrvo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Kana sasa i dešuštarto (14) rat thaj i balval inđarda amen pašo Mediteransko more, ani opaš i rat dije gođi e mornara kaj si i phuv paše. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Kana merisade kobor si duboko o paj, dikhlje kaj si tranda thaj efta (37) metra. Kana nakhle zala, palem merisade thaj dikhlje kaj si i dubina bišteohto (28) metra. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Tegani e mornara darajle kaj ka čalava ane nesave bara, gija tari paluni rig e brodosi čhudije štar sidrura thaj molisade te svanil. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Kana e mornara dikhlje te našen, mukhlje o čamco e spasimaso ano more thaj ćerde pe sar samo ka mučhen o sidro tari angluni rig e brodosi. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","O Pavle phenda e kapetanose thaj e vojnikurenđe: “Te ni ačhile kala ano brodo, našti ni tumen te spasin tumen.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Tegani e vojnikura čhinde e dora e čamcose thaj mukhlje le te perol ano more. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Angleder so đivesajlo, molisada o Pavle savoren te xan khanči, vaćarindoj: “Ađive si dešuštarto (14) đive sar nakhaven bizo xape, ko ađućaripe so ka avol thaj khanči ni čhuten ano muj. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Golese moliv tumen te xan, te mangljen te ačhen džuvde. Nikase tumendar bal taro šoro ni ka perol.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Kana gova vaćarda, lija o mangro thaj zahvalisada e Devlese angle savorende. Tegani phaglja o mangro thaj lija te xal. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Savore radujisajle thaj lije i von te xan. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Ano brodo sama dujšel thaj eftavardeš thaj šov (276) džene. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Kana čalile, lije te ločharen o brodo gija so čhudije o điv ano more. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Kana putajlo o đive, ni pindžarde i phuv, al dikhlje plaža ke nesavo zaliv thaj odlučisade, ako šaj, ki obala te anen o brodo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Putarde e sidrura thaj mukhlje len ano more. Thaj ano isto vreme putarde i e dora save ićarde e kormila te bi mučhena len ano paj thaj vazdije o angluno jedro premali balval thaj lije te džan nakari obala. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Al o brodo avilo ko plitko paj thaj o angluno kotor e brodoso zaglavisajlo ani pošik thaj ačhilo gothe. I paluni rig e brodosi lija te phađol tare silna talasura. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","E vojnikura odlučisade te mudaren e phangle manušen te ne bi khoni lendar našola plivindoj. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Al o kapetano manglja te spasil e Pavle thaj golese ačhada e vojnikuren gova te ćeren. Tegani naredisada kolen save džanen te plivin te huten angleder ano more thaj te ikljen ki obala, ");
INSERT INTO rmyGurbet_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","a akala avera te ićarenpe pe phalja thaj ke kotora save phađile taro brodo. Gija savore nakhle džuvde thaj saste ki obala. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Kana baxtale ikliljam ki obala, tegani haljardam kaj o ostrvo akhardol Malta. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","E manuša tari Malta, save bešle gothe, sikade amenđe but manglipe. Savoren amen primisade thaj phabarde jag te tativa, golese kaj pelo bršnd, a sasa but šul. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Kana o Pavle ćidija jekh angali kašta thaj čhudija ki jag, iklilo o sap taro baro tatipe thaj kicisada le ko va. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Kana dikhlje e manuša tari Malta, save bešle gothe, kaj o sap visil lese po va, vaćarde jekh averese: “Kava manuš sigurno buten mudarda. Arakhadilo taro more, al i devlikani i Pravda ni mukhlja le džuvde.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Al o Pavle tresisada e sape ani jag thaj khanči ni sasa lese. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Von ađućarde te šuvljol il tari jekh drom te perol mulo. Al sar ađućarde but thaj dikhlje kaj naj lese khanči, predomislisajle thaj vaćarde kaj si vov dol. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Paše kava than sasa o imanje e šorutneso taro ostrvo kaso alav sasa Publije. Vov lija amen peste thaj trin đive šukar ugostisada amen. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","E Publijeso dad tegani pašlilo nasvalo tari groznica thaj dizenterija. O Pavle đelo te dičhol le, molisajlo, čhuta pe vasta pe leste thaj sastarda le. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Pale gova avile i avera save sesa nasvale ke gova ostrvo thaj sastile. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Golese e manuša but šukar dikhlje amen thaj kana pripremisaljam te dža, dije amenđe sa so trubuja. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Pale trin čhon plovisadam ko brodo andari Aleksandrija, savo sasa gothe ko ostrvo celo jevend thaj ki angluni rig sasa le zaštitničko znako e bliznakurengo, e Kastoreso thaj e Polukseso. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Kana resljam ani Sirakuza, ačhiljam gothe trin đive. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Gothar plovisadam thaj resljam ano foro Regijum. Pale jekh đive lija te phurdol i balval taro jug, pa duje đivesenđe resljam ano foro Puteole. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Gothe arakhljam nesave phralen, save molisade amen te ačha lende efta đive. Thaj gija đeljam ano Rim. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Kana e phrala taro Rim šunde kaj ava, iklile angle amende sa dži e Apijeveso trgo thaj e Trin mehane. Kana o Pavle dikhlja len, zahvalisada e Devlese thaj zurajlo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Kana resljam ano Rim, e Pavle mukhlje te bešol korkoro jekhe vojnikosa savo arakhlja le. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Pale trin đive o Pavle dija vika e jevrejskone phurederen. Kana von ćidije pe, vaćarda lenđe: “Phralalen! Me ni ćerdem khanči bilačhe amare manušenđe ni e adeturenđe amare paradadenđe, al ano Jerusalim phanglje man thaj dije man ane vasta e Rimljanurenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Von ispitujisade man thaj manglje te mučhen man, golese kaj ni arakhlje pe mande khanči sose bi zasluživa te merav. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Al, e Jevreja usprotivisajle, pa sema prisilimo te rodav te sudin ma anglo Cezar, al na te bi optuživa baše khanči mingre narodo. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Golese dijem tumen vika, te dikhav tumen thaj tumencar te vaćarav. Golese kaj sem phanglo ane kala sinđira baši nada e Izraelesi.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Von vaćarde e Pavlese: “Amen ni dobisadam nisavo lil tutar andari Judeja niti avilo khoni tare phrala te phenol il te vaćarol tutar khanči bilačhe. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Al amen bi mangasa tutar te šuna so tu misli, golese so džana kaj tari kaja sekta vaćarol pe ke sa e thana.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Dogovorisajle jekh đive te aven leste ano čher kaj o Pavle bešola. Thaj avile leste but džene. Taro sabalje dži ki rat o Pavle lenđe vaćarda thaj svedočisada taro Carstvo e Devleso thaj uverisada len sa so vaćarola taro Isus, tare Mojsijaso zakon thaj e proročka lila. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Nesave sesa uverime ane gova so o Pavle vaćarda, al avera ni manglje te pačan. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","A sar ni složisajle maškar peste thaj lije te džan pese, tegani o Pavle vaćarda jekh lafi: “Šukar vaćarda o Sveto Duxo tumare paradadenđe prekalo proroko o Isaija: ");
INSERT INTO rmyGurbet_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Dža thaj vaćar kale manušenđe: Ka šunen thaj ka šunen, al ni ka haljaren, ka dičhen thaj ka dičhen, al ni ka shvatin. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Golese kaj zurajle e ile kale manušenđe, phareste šunen pe kanencar, thaj phanglje pe jakha, jakhencar te ni dičhen, thaj kanencar te ni šunen, thaj ilesa te ni haljaren, thaj te ni irin pe premal mande te sastarav len.’ ");
INSERT INTO rmyGurbet_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Mangav te džanen: E Devleso spasenje si bičhaldo e abandžijenđe thaj von ka prihvatin le.” ");
INSERT INTO rmyGurbet_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Kana vov kava vaćarda, đele e Jevreja thaj maškare peste ćerde čingara. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","O Pavle ačhilo duj berš ano čher savo lija ki kirija. Odori primisada svakone ko avilo leste. ");
INSERT INTO rmyGurbet_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Propovedisada taro Carstvo e Devleso thaj sikada taro Gospod o Isus Hrist bizi dar thaj khoni ni ačhada le.");
INSERT INTO rmyGurbet_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Kava lil pisiv me, o Pavle, o sluga e Isuseso e Hristeso. O Dol akharda man te avav leso apostoli thaj odredisada man te objaviv e Devleso Lačho Lafi ");
INSERT INTO rmyGurbet_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","savo o Dol angleder obećisada prekale prorokura ano Sveto lil. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Gova Lačho Lafi si tare leso Čhavo, savo si palo bijandipe potomko e caroso e Davideso. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","O Isus Hrist, amaro Gospod, sikadilo kaj si e Devleso Čhavo kana o Dol zorasa vazdija le tare mule e Duxosa taro svetost. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Prekal leste me dobisadem milost te avav leso apostol, te bi akharava e manušen tare sa e narodura te pačan ane leste thaj te aven lese poslušna. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","I tumen sen maškar kola saven o Dol akharda te preperen e Isuse e Hristese. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Pisiv kava lil savorenđe save sen ano Rim, kas o Dol manđol thaj kas akharda te aven lese manuša: Milost thaj o mir tumenđe taro Dol, amaro Dad thaj taro Gospod o Isus o Hrist. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Angleder sa, zahvaliv man e Devlese prekalo Isus Hrist savorenđe tumenđe, golese so tare tumaro pačajipe vaćarol pe ke sa o sveto. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","O Dol, save me služiv sa me duxosa kana objaviv averenđe o Lačho Lafi tare leso Čhavo, vov si mingro svedoko kaj uvek dav ma gođi tumendar. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Ane mingre molitve, stalno moliv ma o Dol pale piro manglipe te dol ma konačno te šaj avav ke tumende. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Golese so čače mangav te dikhav tumen, te šaj dav tumen nesavo duxovno daro savo ka zuravol tumen, ");
INSERT INTO rmyGurbet_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","gija katane mingre thaj tumare pačajimasa te zurava jekh avere. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Phralalen thaj phejalen manglalen, mangav te džanen kaj but droma mangljem te posetiv tumen. Golese kaj mangav i maškar tumende te ćidav duxovno bijandipe, sar so ćidijem maškare aver narodura, al dži akana sema sprečimo. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Isi man ista obaveze te propovediv savorenđe: paše civilizovana thaj paše divljakura, paše džangle thaj paše bidžangle. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Golese but mangav te propovediv o Lačho Lafi i tumenđe ano Rim. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Ni ladžav taro Lačho Lafi golese kaj gova si zuralipe e Devleso savo spasil dži jekhe savo pačal: emangleder e Jevrejen a pale gova i e abandžijen. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Golese kaj ano Lačho Lafi objavimo si e Devleso način sar postignil pe o pravednost savo počnil thaj završil pe e pačajimasa, sar so si pisimo i ano Sveto lil: “O pravedniko ka živil taro pačajipe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","E Devlesi holi objavimi si taro nebo pe sa bidevlikane thaj pe nepravedna buća e manušenđe save pe nepravednone bućencar garaven o čačipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Golese, so šaj džanol pe taro Dol, lenđe si pindžarutno, golese kaj o Dol sikada lenđe gova. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","E Devlesi večno zor thaj o devlipe našti te dičhol, al taro postanko e svetoso šaj dičhen pe thaj te haljaren pe ane kova so o Dol ćerda. Golese naj len nisavo opravdanje paše pe buća. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Golese so, iako džanglje e Devlese, ni dije le slava sar Devlese niti zahvalisajle lese. Mesto gova, lengo gođaveripe sasa čučo, a lenđe nerazumna ile dolda o kalipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Vaćarde pese kaj si gođavera, al ćerdile dile. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Thaj i slava e Devlesi savo nikad ni merol, menjisade slikasa thaj oblikosa taro mulikano manuš, tare čiriklja, tare životinje ke štar pingre thaj tare gmizavcura. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Golese predija len o Dol ano bludničko melalipe so sasa ane lenđe ile, te ćeren pumare telurencar ladžutne buća jekh averesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Menjisade e Devleso čačipe xoxaimasa thaj slavisade thaj služisade kova so si ćerdo vastencar, mesto e Stvoritelje, kase si i slava ane sa e đivesa. Amin. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Gijate, o Dol predija len ane lenđe ladžutne strastura. Mesto te avol len prirodna polna odnosura, lenđe romnja ćerde len neprirodna. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Gijate i e murša ačhade e prirodna polna odnosura e romnjenca thaj phabile ani požuda jekh premal avereste. E murša e muršencar lije te ćeren ladžutne buća thaj primisade pe peste zaslužimi kazna paše pe perverzna buća. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","A golese kaj ni smatrisade kaj si vredno te aračhen o čačukano pindžaripe e Devleso, vov predija len lenđe dile gođenđe save navedisade len te ćeren buća save ni trubun. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Pherde si sa e vrste grehura, rumipe, pohlepa thaj bilačhipe. Ane lende si zavist, mudaripe, čingara, prevare thaj podmuklo manglipe. Ogovorin jekh avere, ");
INSERT INTO rmyGurbet_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","klevetin, mrzin e Devle, bezobrazna, barikane thaj hvalin pe. Den gođi taro nevo bilačhipe, ni šunen e dade thaj e da, ");
INSERT INTO rmyGurbet_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","dile si, ni ispunin pe obećanjura, bizo osećanje si thaj naj len samilost premal avera. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Kala manuša džanen e Devleso upozorenje kaj kola save gija živin zaslužin meripe. Al von na samo so gija živin, nego ohrabrin i averen te ćeren gija. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Golese naj tut izgovor, manušeja savo sudi averen, bilo savo san. Golese kaj, ane so sudi averen, osudi korkoro tut, golese kaj tu so sudi ćere gova so i von. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Amen džana kaj o sudo e Devleso si pravedno pe kola save ćeren gasave buća. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Al, tu manušeja, savo sudi kolen save ćeren gasave buća, a korkoro ćere len, misli kaj ka naše tare Devleso sudo? ");
INSERT INTO rmyGurbet_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Dal preziri e Devleso barvalo šukaripe, trpipe thaj strpljenje thaj ni džane kaj leso šukaripe manđol te inđarol tut ko pokajanje? ");
INSERT INTO rmyGurbet_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Al, zbog ćiro zuralo thaj bipromenimo ilo sa po but čhuve pe tute e Devlesi holi za ko đive kana o Dol ka sikavol lesi pravedno presuda. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Golese kaj, o Dol “ka iril svakonese pale lese buća.” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Vov ka iril svakonese džuvdimasa bizo meripe, kolenđe save ni ačhen te ćeren šukar buća gija so roden i slava, o čast thaj o džuvdipe bizo meripe. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Al pe bare holjasa ka kaznil kolen save taro sebičnost ni pokorin pe pašo čačipe, nego džan palo nepravednost. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","I nevolja thaj i muka ka aračhol dži jekhe manuše savo ćerol bilačhipe – angleder e Jevrejen, al pale gova i e abandžijen. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Al dži jekhe savo ćerol šukar, o Dol ka dol i slava, o čast thaj o mir – angleder e Jevrejen, al pale gova i e abandžijen. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Golese so o Dol ni ćerol razlika maškare manuša. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Sa kola save ćeren greh thaj naj len e Mojsijaso Zakon, isto gija bizo Zakon ka aven hasarde. A sa kola save ćeren greh thaj isi len Zakon, ka aven sudime palo Zakon. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Golese kaj, ane Devlese jakha naj pravedna kola manuša save samo šunen o Zakon, nego ka aven opravdime kola save ićaren pe po Zakon. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Nesave, save naj Jevreja thaj ni pindžaren o Zakon, prirodno ćeren kova so vaćarol o Zakon. Iako naj len Zakon, ane pire ile isi len Zakon. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Von gija sikaven kaj gova so manđol o Zakon, pisimo si ane lenđe ile. Gova sikaven i golesa so osetin so si šukar, a so naj. Lenđi gođi jekh drom tužil len thaj aver drom čak branil len. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Sa kava ka avol ane gova đive kana o Dol prekal o Hrist o Isus ka sudil e manušenđe tajne, sar so objavisadem gova ano Lačho Lafi. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Al tu akhare tut Jevrejo thaj tu osloni tut po Zakon thaj hvali tut e Devlesa, ");
INSERT INTO rmyGurbet_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","džane so o Dol manđol thaj andaro Zakon sikliljan te pindžare so si ispravno. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Uverimo san kaj san vodiči e korengo, o videlo kolenđe so si ano mrako, ");
INSERT INTO rmyGurbet_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","kaj san kova savo sikavol e bidžanglen thaj kaj san učitelji paše manuša save naj zrela golese kaj isi tut Zakon, savo si pherdo džanglipe thaj čačipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Sose, gija, tu so sikave averen, ni sikave korkoro tut? Tu, savo averen sikave te ma čoren, sose tu čore? ");
INSERT INTO rmyGurbet_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Tu, savo vaćare te ma ćerol pe preljuba, sose gova ćere? Tu, savo preziri e idoluren, sose koristi e čordane stvara andar lenđe hramura? ");
INSERT INTO rmyGurbet_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Tu, so hvali tut kaj pindžare e Devleso Zakon, sose vređi e Devle gija so phađe o Zakon? ");
INSERT INTO rmyGurbet_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Sar so si pisimo ano Sveto lil: “Zbog tumende hulin e Devleso alav maškare avera narodura.” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","O suneti isi le vrednost te ićardan tut po Zakon. Al te phagljan o Zakon, ka ave sar kova savo naj sunetimo. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Te ićarol pe o bisunetimo manuš pe gova so manđol o Zakon, ni li ka avol đindo maškare sunetime? ");
INSERT INTO rmyGurbet_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Kova savo naj sunetimo telesno, al ićarol pe po Zakone, ka sudil tut savo san sunetimo thaj isi tut pisimo Zakon, al phađe o Zakon. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Golese, naj Jevrejo kova savo si Jevrejo samo avral, ni suneti naj gova so si ćerdo avral thaj telesno. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Pravo Jevrejo si kova savo si Jevrejo ano ilo thaj čačukano suneti si promena e ilesa savo ćerol o Duxo, a na pisimo Zakon. Gasavo manuš ni primil pohvala tare manuša, nego taro Dol. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Savo prednost tegani isi e Jevrejen, il savo vrednost isi taro suneti? ");
INSERT INTO rmyGurbet_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","But baro vrednost ane sa, golese so angleder e Jevrejenđe dije pe e Devlese lafura. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Al so te nesave lendar sesa bipačavne? Dal lengo bipačajipe ka peravol o vernost e Devleso? ");
INSERT INTO rmyGurbet_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Na, nisar! Nek sikadol kaj si o Dol čačukano iako si dži jekh manuš xoxavno, sar so si pisimo ano Sveto lil: “Gija ka ave opravdimo ćire lafurencar, thaj ka pobedi kana ka sudin tut.” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Al ako amari nepravda sikavol savo pravedno si o Dol, so šaj vaćara pe gova? O Dol li si nepravedno kana sikavol pi holi? Vaćarav gija sar so e manuša den gođi. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Na, nisar! Sar bi tegani šajine o Dol pravedno te sudil e svetose? ");
INSERT INTO rmyGurbet_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Al te mingro xoxaipe sikavol kaj e Devleso čačipe si po baro thaj anol gova lese i slava, sose tegani te avav sudimo sar grešniko? ");
INSERT INTO rmyGurbet_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Gova bi avola isto sar te vaćara: “Ćera bilačhipe te bi avola šukaripe!”, sar so nesave bilačhe vaćaren kaj amen sikava. Gola save gija phenen, zaslužin i osuda! ");
INSERT INTO rmyGurbet_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Tegani, dal sam amen e Jevreja po šukar averendar? Na, nisar! Golese kaj već vaćardam tare Jevrejura thaj i tare abandžije kaj sa si talo greh. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Sar so si pisimo ano Sveto lil: “Khoni naj pravedno, nijekh; ");
INSERT INTO rmyGurbet_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Nijekh ni haljarol; naj nijekh savo bi rodola e Devle. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Savore crdije pe taro Dol, thaj savore ćerdile bezvredna. Naj nijekh savo bi ćerola šukaripe, khoni naj, nijekh. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Lenđe muja si putarde limora, pe čhibencar xoxaven, thaj pe lenđe vušta si otrovo e sapengo. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Lenđe muja si pherde armajencar thaj ćerčimasa. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Lenđe pingre siđaren te čhoren rat. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Kaj god te džan, anen beda thaj bilačhipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Thaj mirno drom ni pindžarde. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Ane lenđe jakha naj nisavi dar taro Dol.” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Al amen džana kaj gova so o Zakon vaćarol, vaćarol kolenđe so si talo Zakon, khanika te ni avol nisavo izgovor thaj sa o sveto te ačhol anglo Devleso sudo. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Golese kaj, e bućencar taro Zakon nijekh manuš ni ka avol pravedno anglo Dol. Golese kaj o Zakon anol e manuše dži ko džanglipe kaj si grešniko. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Al akana, sikadol o pravednost e Devleso bizo Zakon, sar so svedočin tare gova o Zakon thaj e Prorokura. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Anglo Dol sam opravdime pačajimasa ano Isus Hrist, savore save pačan. Golese so naj razlika maškare manuša: ");
INSERT INTO rmyGurbet_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Golese kaj savore grešisade thaj hasarde i slava e Devlesi. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Al opravdime si anglo Dol palo leso milost thaj avol prekalo otkupljenje taro Hrist o Isus. Gova si e Devleso daro. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","O Dol odredisada e Isuse sar žrtva pašo greh. Akana amenđe si oprostime e grehura golese so pača kaj o Isus dija po džuvdipe gija so čhorda po rat. Gija o Dol sikada po pravednost, golese so sasa strpljivo thaj ni kaznisada e grehura save sesa ćerde angleder. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","A gova o Dol ćerda te bi ane kava vreme sikavola po pravednost, kaj si Vov korkoro pravedno thaj te opravdil dži jekhe savo pačal ano Isus. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Golese, isi li sose khoni te hvalil pe korkoro pesa? Naj sose. Palo savo zakon? Palo zakon e bućengo? Na, nego palo zakon e pačajimaso. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Golese so amen misli kaj o manuš si opravdimo e pačajimasa, a na gija so ćerol e buća taro Zakon. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Il si o Dol samo o Dol e Jevrejengo? Dal naj o Dol i avere narodurengo? Va, vov si o Dol i avere narodurengo. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Golese kaj si samo jekh Dol. Vov pačajimasa ka opravdil kolen save si sunetime thaj prekali pač kolen save naj sunetime. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Čhinava li gija o Zakon e pačajimasa? Na, nisar! Mesto gova, amen e pačajimasa ićara amen po Zakon. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","So šaj te vaćara, so o Avraam otkrijisada tari pač, amaro paradad palo telo? ");
INSERT INTO rmyGurbet_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Golese kaj, te sasa o Avraam opravdimo pe bućencar, bi avola le razlog sosa te hvalil pe, al na anglo Dol. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Golese o Sveto lil vaćarol: “O Avraam pačaja e Devlese thaj o Dol đinda lese leso pačajipe sar pravednost.” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Kolese savo ćerol bući, ni đinol pe i plata sar poklon, nego sar dugo. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","A kolese savo ni ćerol bući thaj pačal ano Dol savo opravdil e grešnikuren, lese o pačajipe đinol pe ano pravednost. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Gija o David o caro vaćarda kaj si blagoslovimo o manuš kase o Dol đinol o pravednost bizo obzir tare lese buća. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Blagoslovime si kola kase sesa oprostime e bilačhe buća thaj kase grehura si učharde. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Blagoslovimo si kova kase o Gospod ni đinol o greh.” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Kava blagoslovipe si samo e sunetimenđe, il i e bisunetimenđe? Golese so vaćara kaj o Dol đinda e Avraamese leso pačajipe sar pravednost. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Kana sasa lese leso pačajipe đindo? Kana sasa sunetimo il bisunetimo? Na kana sasa sunetimo, nego kana vadži sasa bisunetimo. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Vov primisada o sunetipe sar znako, sar pečato taro pravednost savo dobisada pačajimasa vadži angleder kana ni sasa sunetimo. Golese si o Avraam duxovno dad sa kolenđe save pačan bizo obzir dal si sunetime il naj, savorenđe te đinol pe lengo pačajipe sar pravednost. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","O Avraam si o dad na samo e sunetimengo nego i kolengo save džan pale lesi pač savi sikada kana vadži ni sasa sunetimo. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Golese kaj, o obećanje so o Dol dija e Avraamese il lese potomstvose kaj ka nasledil o sveto, ni avilo palo Zakon, nego palo pravednost savo si rezultat e pačajimaso. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Ako si e naslednikura kola save ićaren pe po Zakon, tegani o pačajipe si beznačajno thaj o obećanje ni vredil khanči. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Golese so, o Zakon izazivil e Devlesi holi ako phađol pe. Al te naj Zakon, naj ni prestup. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Gija si thaj e Devleso obećanje tari pač te bi e manuša prihvatina le sar daro taro Devleso milost thaj važil paše sa e Avraamese potomkura, na samo paše kola save si podložna e Zakonese, nego i paše kola save pačan sar o Avraam. Vov si dad savorenđe amenđe ");
INSERT INTO rmyGurbet_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","sar so si pisimo ano Sveto lil: “Ćerdem tut dad bute narodurengo.” Gova si čačipe anglo Dol ane savo pačaja o Avraam. Gova si Dol savo dol e mulen džuvdipe thaj kova so ni postojil pire lafesa ćerol te postojil. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Kana naj sasa e Avraame nada te avol le čhave, vov pačaja ani nada thaj postanisada dad bute manušengo, sar so sasa lese vaćardo: “Gaći but ka aven tut potomkura.” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","O Avraam šukar džanglja kaj nakhlo leso vreme kana šaj te avol le čhave golese so sasa le paše šel (100) berš. Džanglja so i Sara naštine te bijanol, al lesi pač ni peli. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Ađućarda kaj o Dol ka pherol po obećanje thaj ni sumnjisada, nego zurajlo ano pačajipe thaj hvalisada e Devle. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Sasa potpuno uverimo kaj o Dol šaj ćerol so obećisada. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Golese thaj “o Dol đinda lese leso pačajipe sar pravednost.” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Al kova so sasa pisimo “đinda lese” ni sasa samo lese, ");
INSERT INTO rmyGurbet_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","nego i amenđe. O Dol gija ka đinol i amenđe save pača ane Kova, savo vazdija tare mule e Isuse, amare Gospode. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Vov sasa predimo te merol paše amare grehura a uštilo tare mule te ava opravdime. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Tegani, akana kana sam opravdime e pačajimasa, amen sam ano mir e Devlesa palo amaro Gospod o Isus o Hrist. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Pačajimasa prekal leste isi amen pristup ane Devleso milost ane savo ačha. Raduji amen golese kaj isi amen nada kaj o Dol ka sikavol amenđe pi slava. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Thaj na samo gova, nego raduji amen kana sam ano bilačhipe, golese kaj džana kaj o bilačhipe zuravol amaro strpljenje, ");
INSERT INTO rmyGurbet_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","o strpljenje zuravol o karakteri thaj taro karakteri zuravol i nada. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Thaj kaja nada ni ka razočaril amen golese kaj e Devleso manglipe thavdija ane amare ile palo Sveto Duxo, savo dobisadam. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Golese, o Hrist mulo paše bidevlikane ano pravo vreme, kana amen vadži sama duxovno slaba. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Pharo si khoni te dol piro džuvdipe te bi spasila avere manuše pa i te si gova manuš pravedno. Iako pašo but šukar manuš šaj bi neko manđola te merol. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Al o Dol sikavol po manglipe premal amende gija so o Hrist mulo amenđe vadži kana sama grešnikura. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Kobor po but akana, kana sam opravdime lese ratesa, ka ava spasime tare Devlesi holi. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","O Dol amencar mirisajlo palo meripe lese Čhaveso vadži kana sama e Devlese dušmanura, gija vadži po but o Dol ka spasil amen ane Hristeso džuvdipe akana kana mirisaljam lesa. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","A na samo gova, nego vadži po but ka raduji amen ano Dol prekal amaro Gospod o Isus o Hrist, tare savo primisadam pomirenje. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Golese, o greh avilo ano sveto prekalo jekh manuš thaj prekalo greh avilo o meripe. Gijate o meripe nakhlo pe sa e manuša golese kaj savore grešisade. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","O greh sasa ko sveto i angleder so avilo o Zakon, nego o greh khanikase ni đinol pe, te naj le o Zakon. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Al o meripe vladisada tare Adameso dži e Mojsijaso vreme i pe kola save ni phaglje e Devleso zapovest sar o Adam, savo si slika Kolesi savo ka avol. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","E Devleso daro naj sar o greh e Adameso. Golese so, te but džene mule zbog o greh jekhe manušeso, e Adameso, but po baro si e Devleso milost thaj o daro savo primisade but džene prekalo milost jekhe manušeso, e Isuseso e Hristeso. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Thaj gova daro naj sar kova so avilo prekal kova savo grešisada. Gija, pale jekh greh avilo o sudo savo anda osuda, a o milosno daro avilo pale but grehura thaj anda opravdanje. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Golese, te o meripe lija te vladil pe sa e manuša golese so jekh manuš ćerda greh, gija vadži po but kola save primin ano izobilje e Devleso milost thaj e Devleso daro taro pravednost, ka vladin ano džuvdipe prekal jekh manuš, o Isus o Hrist. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Golese, sar so sa e manuša sesa osudime pašo greh jekhe manušeso, isto gijate pašo jekh pravedno delo sa e manuša ka aven opravdime thaj ka avol len čačukano džuvdipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Golese kaj, sar so pašo neposlušnost jekhe manušeso postanisade but manuša grešnikura, isto gijate pašo poslušnost jekhe manušeso but džene ka aven pravednikura. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","O Zakon avilo te bi e grehura barona. Al kaj but barilo o greh, odori o Dol dija po milost ane pobari mera. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Gova sasa te bi, sar angleder o greh vladila e merimasa, ko isto način e Devleso milost vladila prekal o pravednost thaj te anol o džuvdipe bizo meripe palo Isus o Hrist, amaro Gospod. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Golese, so te vaćara? Vadži li ka nastavi te ćera grehura sar bi e Devlesi milost avola po baro? ");
INSERT INTO rmyGurbet_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Na, nisar! Al sar šaj amen save muljam e grehurenđe vadži te živi ane lende? ");
INSERT INTO rmyGurbet_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Ni li džanen kaj amen savore, save krstisaljam ano Hrist o Isus, ane leso meripe sam krstime? ");
INSERT INTO rmyGurbet_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Golese, palo krstipe muljam thaj prahosaljam katane e Hristesa, te bi šajine te živi neve džuvdimasa, sar so i o Hrist uštilo tare mule pe Dadese slavnone zuralimasa. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Golese, te postanisadam lesa jekh ano meripe, sar so Vov mulo, isto gija ka ava lesa jekh ko uštipe tare mule, sar so i Vov uštilo. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Amen džana kaj amaro purano manuš sasa čhuto ko krsto katane e Hristesa, te bi amaro grešno telo avola uništimo, te ma bi vadži avasa robura e grehose. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Golese kaj kova savo mulo, oslobodimo si tare grehura. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Ako muljam e Hristesa, pača kaj lesa ka ava i džuvde. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Golese so džana kaj o Hrist, pale gova kana uštilo tare mule, našti palem te merol. O meripe pe leste naj le vadži nisavo zuralipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","O meripe, savesa Vov mulo, sasa meripe te bi phađola o zuralipe e grehoso, jekh drom paše sa e đivesa. Al o džuvdipe savo akana živil si o džuvdipe e Devlese. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Gijate i tumen smatrin kaj sen mule e grehurenđe, al džuvde e Devlese ano Hrist o Isus. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","E grehura ni smin vadži te vladin pe tumaro mulikano telo, te bi pokorina tumen lese grešnone manglimasa! ");
INSERT INTO rmyGurbet_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Ma te den tumare telose kotora pašo greh te ma aven oruđe savencar ka ćeren nepravda. Mesto gova, den korkore tumen e Devlese, sar kola save mule thaj džuvdile. Tumare kotora e telose den e Devlese te aven oruđe savencar ka ćeren pravednost. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","O greh ni ka vladil pe tumende, golese kaj naj sen talo Zakon, nego talo milost. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","So tegani te ćera? Trubul li te ćera grehura golese so naj sam talo Zakon, nego talo milost? Na, nisar! ");
INSERT INTO rmyGurbet_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Dal ni džanen kaj kana khanikase preden tumen te služin sar robura, šunen le thaj lese sen robura. Šaj aven robura pašo greh, savo ka inđarol tumen ano meripe, il šaj aven robura ano poslušnost e Devlese, so inđarol ano pravednost. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Al hvala e Devlese so iako sena sluge e grehose, akana sa e ilesa pokorisaljen pašo primer taro sikajipe savo dija pe tumenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Akana sen oslobodime taro greh thaj postanisaden robura taro pravednost. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Vaćarav tumenđe manušikane čhibasa golese kaj kala buća si phare te haljaren pe. Golese kaj, sar angleder predajisaden tumare kotora e telose te služin sar robura e duxovnone melalimase thaj pašo bezakonje savo inđarol ano po baro bezakonje, gijate akana predajisaden tumare kotora e telose te služin sar robura taro pravednost te živin sveto džuvdipe pašo Dol. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Golese kaj, dži kana sena robura pašo greh, ni sena podložna pašo pravednost. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Thaj savo korist sasa tumen tare gola buća, sostar ađive ladžan? O rezultat taro sa gova si meripe. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Al akana, kana sen slobodna taro greh thaj postanisaden robura e Devlese, rezultat tare gova si tumaro posvećenje e Devlese, a sar rezultat ko krajo si džuvdipe bizo meripe. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Golese kaj, i plata pašo greh si meripe, al daro e Devleso si džuvdipe bizo meripe ano Hrist o Isus, amaro Gospod. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Ni li džanen, phralalen thaj phejalen manglalen – golese kaj vaćarav kolenđe so džanen o Zakon – kaj o Zakon vladil po manuš samo dok si džuvdo? ");
INSERT INTO rmyGurbet_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Na primer, i romni savi isi la rom, palo Zakon si phangli paše leste sa dok si vov džuvdo. Al te mulo lako rom, i romni si oslobodimi taro Zakon, savesa sasa phangli za ko rom. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Golese, te lija avere rome dok si lako rom džuvdo, ka dol pe vika preljubnica. Al te mulo lako rom, oslobodimi si taro Zakon thaj ni ćerol preljuba te lija avere rome. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Gija i tumen, phralalen thaj phejalen manglalen, gija so o Hrist dija po džuvdipe amenđe, muljen e Zakonese te bi preperena averese, kolese savo sasa vazdimo tare mule, gija amare buća te anen šukar bijandipe e Devlese. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Golese so, dok sama ano telo, vladisade ane amende grešna požude save anola o Zakon ane amare kotora e telose, a o bijandipe tare gova sasa meripe. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Al akana sam oslobodime taro Zakon, golese kaj muljam kolese so ićarda amen ano ropstvo. Gija akana ko nevo način služi e Devle Duxosa, a na e slovosa taro Zakon, sar so sasa palo purano. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Golese, so te vaćara? O Zakon li si greh? Na, nisar! Te ma avola o Zakon, ne bi džanava so si greh. Golese kaj ne bi džanava kaj si i požuda bilačhi te ma vaćarola o Zakon: “Ma mang khanči so naj ćiro!” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Al o greh lija i prilika thaj palo zapovest ane mande izazivisada dži jekh požuda. Golese, o greh si bizo Zakon mulo. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Me angleder živisadem bizo Zakon, al kana avilo o zapovest, o greh džuvdilo. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Al me muljem thaj gija sikadilo kaj o zapovest, savo trubuja te anol manđe o džuvdipe, anda manđe o meripe. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Golese so o greh lija i prilika, koristisada o zapovest, xoxada man thaj gija mudarda man. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Golese, o Zakon si sveto thaj o zapovest si sveto, pravedno thaj šukar. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Dal gova značil kaj e šukar buća ande manđe meripe? Na, nisar! Al te bi sikadola o greh sar greh, maškaro gova šukaripe anda manđe meripe, te o greh avol maškaro zapovest embaro grešno bilačhipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Tegani džana kaj si o Zakon duxovno. Al me sem telesno, bićindo sar robo e grehose. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Našti man te razumiv so ćerav. Golese kaj ni ćerav gova so čače mangav, nego mesto gova ćerav baš kova so mrziv. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Al ako ćerav kova so ni mangav, tegani složiv man kaj si o Zakon šukar. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Gija, akana vadži gova ni ćerav me, nego o greh savo živil ane mande. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Golese, džanav kaj ane mande, ane mingro telo – ni živil khanči šukar. Mangav te ćerav šukaripe, al naj sem ano stanje te ćerav šukaripe. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Golese, ni ćerav o šukaripe so mangav te ćerav, al ćerav o bilačhipe so ni mangav te ćerav. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Al te ćerdem kova so ni mangav, gova značil kaj ni ćerav gova me, nego o greh savo živil ane mande. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Gijate arakhav kava zakon: kana mangav te ćerav šukaripe, o bilačhipe si sigate gothe. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Ane mingro ilo sem oduševimo e Devlese Zakonesa, ");
INSERT INTO rmyGurbet_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","al ane me kotora e telose dikhav aver zakon, savo marolpe e zakonesa so si ane mingri gođi thaj phandol man talo zakon e grehoso, savo si ane me kotora e telose. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Bibaxtalo sam me manuš! Ko ka ikalol man tare kava telo e merimaso? ");
INSERT INTO rmyGurbet_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Hvala e Devlese savo ćerol gova prekal o Isus Hrist, amaro Gospod! Gija, tegani me, mingra gođasa služiv e Devlese Zakonese, al mingre telosa služiv e zakonese taro greh. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Golese, akana naj vadži nisavi osuda kolenđe save si ano Isus o Hrist. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Golese kaj o zakon e Duxoso savo anol amenđe džuvdipe ano Hrist o Isus, oslobodisada tut taro zakon e grehoso, savo inđarol ano meripe. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Gova so o Zakon naštine te ćerol golese kaj amaro telo si slabo, gova ćerda o Dol gija so bičhalda pe Čhave savese dija isto telo sar amaro, savesa ćera grehura, sar žrtva pašo greh, te bi osudila o greh ano telo. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","O Dol ćerda gova te bi ane amende pherdola sa so o Zakon manglja amendar, save naj sam vadži džuvde palo telo, nego palo Duxo. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Kola save živin palo telo, den gođi kova so si telesno, al kola save živin palo Duxo, den gođi kova so si ugodno e Duxose. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Golese kaj i gođi savi inđarol o telo, džal ano meripe. Al i gođi savi inđarol o Duxo, džal ano džuvdipe thaj ano mir. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","I gođi savi inđarol o telo si dušmano e Devleso, golese kaj ni pokoril pe e Devlese Zakonese thaj našti ćerol gova. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Golese kola ane save vadži vladil o telo našti aven ugodna e Devlese. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Al ane tumende ni vladil vadži o telo, nego o Duxo, te čače o Duxo e Devleso živil ane tumende. Al te khanika naj e Hristeso Duxo, gova naj e Hristeso. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Al palem, te si o Hrist ane tumende, tumaro telo si mulo pašo greh, al o Duxo si džuvdipe ane tumende golese kaj o Dol opravdisada tumen. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Te živisada ane tumende o Duxo koleso savo e Isuse vazdija tare mule, tegani kova savo e Hriste vazdija tare mule, ka dol džuvdipe i tumare mulikane telurenđe pale piro Duxo savo živil ane tumende. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Gija, phralalen thaj phejalen manglalen, dužna sam, al na palo telo, te bi ano telo živisa. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Golese, te živisaden palo telo, mora te meren. Al ako e Svetone Duxosa mudaren o telo, ka živin. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Golese so, savoren saven o Duxo e Devleso vodil, von si čhave e Devlese. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","O Duxo savo primisaden, ni inđarol tumen ano ropstvo te bi palem avena ani dar, nego primisaden e Duxo savo ćerda tumen te aven e Devlese čhave, pale savo šaj da vika: “Abba, Dade!” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Kava Duxo korkoro svedočil amare duxose kaj sam čhave e Devlese. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Te sam e Devlese čhave, amen sam e Devlese naslednikura katane e Hristesa. Al gova šaj ava čače e Hristesa samo ako lesa i trpi, sar so vov trpisada, te bi katane lesa primisa i slava. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Smatriv kaj amare patnje save amen isi akana naj khanči ano poređenje e slavasa savi o Dol ka sikavol amenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Golese kaj, sa e stvorenjura, željno ađućaren o đive kana o Dol ka sikavol ko si čače lese čhave. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Sa e stvorenjura postanisade čučipe, al na pe manglimasa, nego e Devlese manglimasa savo čhuta len ane gova – ani nada ");
INSERT INTO rmyGurbet_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","kaj sa e stvorenjura ka aven oslobodime taro ropstvo savo inđarol ano propast, ani slavno sloboda e Devlese čhavenđi. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Džana kaj sa e stvorenjura, sa dži akana, uzdišin thaj mučin pe, sar i romni ane bijanimase dukha. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Thaj na samo von, nego i amen save isi amen o Duxo sar angluno kotor tare Devlese darura, uzdiši ane amende thaj vadži željno ađućara, o Dol potpuno te usvojil amen sar pe čhaven, odnosno te oslobodil amare telura. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Golese kaj, amen sam spasime gole nadasa. Al i nada savi šaj dičhol pe, naj nada. Golese so, ko nadil pe kolesa so već isi le? ");
INSERT INTO rmyGurbet_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Al te nadisaljam kolesa so vadži naj amen, tegani gova ađućara bare strpimasa. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Gija, i o Sveto Duxo pomognil amenđe ane amare slabostura. Amen ni džana so trubul te moli. Al korkoro o Sveto Duxo molil pe amenđe uzdahurencar save našti te vaćaren pe lafurencar. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Al o Dol savo dičhol ane manušikane ile džanol so o Duxo manđol, golese kaj o Duxo pale Devleso manglipe molil paše Devlese manuša. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Amen džana kaj o Dol ane sa ćerol šukar kolenđe save manđen le thaj saven Vov birisada pale piro plan. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Vov džanglja len angleder so postojisade thaj angleder birisada len te aven sar leso Čhavo. Gijate o Isus, e Devleso Čhavo, avol angluno bijando čhavo maškare pe phrala thaj pe pheja. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Kolen kas angleder o Dol birisada, len i akharda. Kolen kas akharda, len i opravdisada, a kolen kas opravdisada, len i proslavisada. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","So šaj vaćara pe kava? Te si o Dol amencar, ko šaj avol protiv amende? ");
INSERT INTO rmyGurbet_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","O Dol, savo čak ni poštedisada pe Čhave, nego dija le te merol mesto savore amen, na li ka dol amen sa aver katane lesa? ");
INSERT INTO rmyGurbet_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Ko šaj tužil kolen saven birisada o Dol? Khoni! O Dol si kova savo opravdil len. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Ko ka osudil len? Khoni! O Hrist o Isus savo mulo, a na samo gova, vov i uštilo tare mule, akana bešol ko počasno than ki desno rig e Devlesi thaj molil amenđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Ko šaj crdol amen taro manglipe e Hristeso? Šaj li o pharipe, o bilačhipe, o progonstvo, il o bokhalipe, o čororipe, o opasnost, il o meripe? ");
INSERT INTO rmyGurbet_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Sar so si pisimo ano Sveto lil: “Zbog tuće mudaren amen dži jekh đive; amen sam sar bakre čhinimase.” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Al pe sa kava amen zurale pobedi pale kova savo manglja amen. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Zurale pačav kaj khanči – ni o meripe, ni o džuvdipe, ni e anđelura, ni o šorutnipe, ni kova so si akana, ni kova so ka avol, ni e zora, ");
INSERT INTO rmyGurbet_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ni kova so si upre, ni kova so si tele, ni khanči aver so si stvorimo našti crdol amen taro manglipe e Devleso savo si ano Hrist o Isus, amaro Gospod. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Me vaćarav čačipe ano Hrist, ni xoxavav thaj mingro savest, savo vodil o Sveto Duxo, si manđe svedoko ");
INSERT INTO rmyGurbet_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","kaj ane mingro ilo si bari žal thaj dukh savi ni ačhol. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Golese so, mangava bi i me korkoro te avav harami thaj crdimo taro Hrist umesto me phrala thaj me pheja, sar te bi šaj gova spasila len, save si mingri familija palo telo. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Von si e Izraelcura: len o Dol usvojisada sar čhaven, thaj objavisada lenđe i slava, e savezura, o Zakon, sar te služin e Devle thaj pire obećanjura. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Lenđe si e paradada o Avraam, o Isaak thaj o Jakov thaj lendar si o manušikano poreklo e Hristeso, savo si Dol pe savorende. Nek avol blagoslovimo o Dol ane sa e đivesa! Amin. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","O Dol li phaglja pe obećanjura? Na. Golese so, naj savore save aven taro Izrael čačukane Izraelcura. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Naj ni savore čačukane e Devlese čhave samo golese so si e Avraameso potomstvo, nego: “Prekalo Isaak ka računil pe ćiro potomstvo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Gova značil kaj e čhave palo telesno poreklo naj e Devlese čhave, nego e čhave save si bijande palo obećanje računin pe sar Avraameso potomstvo. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Golese kaj kava si o lafi taro obećanje: “Ka iri man tute aver berš ane kava vreme thaj e Sara ka avol čhavo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Thaj na samo voj, nego thaj i Reveka inđarda ano vođi bliznakuren, a sasa la čhave taro amaro paradad o Isaak. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Golese so, kana vadži e čhave ni bijandile thaj ni ćerde ni lačhe ni bilačhe, te bi o izbor avola pale Devleso plan, ");
INSERT INTO rmyGurbet_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","na pale lenđe buća, nego taro Kova savo akharol – o Dol phenda e Revekaće: “O phureder čhavo ka služil e po terne čhave.” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Sar so si pisimo ano Sveto lil: “E Jakove mangljem, a e Isave mrzisadem.” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Golese, so te vaćara? Dal si o Dol nepravedno? Na, nisar! ");
INSERT INTO rmyGurbet_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Golese so e Mojsijase vaćarda: “Pe kaste ka smiluiv man, ka smiluiv man, pe kaste ka sažaliv man, ka sažaliv man” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Gija, ni zavisil kolestar savo manđol, ni kolestar savo trudil pe, nego zavisil taro Dol savo smiluil pe. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Golese kaj ano Sveto lil o Dol phenol e faraonese: “Golese vazdijem tut te ave vladari, te sikavav pe tute mingri zor thaj te šundol mingro alav pe sa i phuv.” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Gija, o Dol smiluilpe pe kova kase manđol, a ćerol zurado ilo kolenđe kase manđol. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Neko šaj bi pučola: “Tegani, sose o Dol vadži rodol i krivica pe manuša? Golese, ko šaj suprostavil pe kova so Vov manđol?” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Al ko san tu, manušeja, te protivi tut e Devlese? Dal kova so si ćerdo ka vaćarol kolese so ćerda le: “Sose gija ćerdan man?” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Gija, dal e grnčare naj pravo tari jekh isto glina te ćerol čaro pašo čast, a aver čaro paši ladž? ");
INSERT INTO rmyGurbet_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","O Dol manglja te sikavol piri holi te bi e manuša dičhena lesi zor. Al, bizo obzir pe gova, ipak sasa le but strpljenje pe kola ke save sasa holjamo, a save sesa pripremime pašo propast, ");
INSERT INTO rmyGurbet_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","te bi sikavola o barvalipe pe slavako kolenđe save primin o milosrđe, saven angleder pripremisada paši slava. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Amen sam gola saven o Dol akharda, na samo tare Jevreja, nego i tare sa avera narodura. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Sar so o Dol vaćarol ano lil e prorokoso e Osijaso: “Mingre manušencar ka akharav kolen save ni sesa mingre manuša, thaj ka akharav kolen saven ni mangljem mingre mangle.” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Thaj: “Ke okova than kaj sasa vaćardo lenđe: ‘Tumen naj sen mingro narodo’, ka aven akharde ‘čhave e džuvde Devlese’.” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","O proroko o Isaija dol vika pašo Izrael: “Te aven e čhave e Izraelese kobor si morsko pošik, ipak samo zala lendar ka aven spasime, ");
INSERT INTO rmyGurbet_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","golese kaj o Gospod sigate thaj sa po Lafi ka ispunil pi phuv.” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Thaj sar so angleder prorokujisada o proroko o Isaija: “Te o Gospod pe vojske ni ačhada amenđe potomstvo, avasa bi uništime sar i Sodoma thaj bi ličisa pi Gomora.” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Golese, so te vaćara? Aver narodura, save ni rodije pravednost, dobisade pravednost – pravednost savo avol taro pačajipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Al e Izraelcura save trudisajle te ićaren gova Zakon te bi avena pravedna anglo Dol, naštine te aven dži ke gova. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Sose? Golese kaj ni trudisajle te aven o pravednost pačajimasa, nego pe bućencar. Avile pašo “bar e perimaso” savo perada len. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Sar so si pisimo ano Sveto lil: “Dičhen, ko Sion čhuvav o bar pe savo e manuša ka peren, al kola save pačan ane leste, ni ka ladžan.” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Phralalen thaj phejalen mingralen, sa me ilesa mangav thaj moliv man e Devlese e Izraelcura te aven spasime. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Šaj svedočiv kaj len isi revnost e Devlese, al bizo ispravno haljaripe. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Golese kaj ni pindžarde o pravednost savo avol taro Dol, manglje te steknin piro pravednost thaj ni pokorisajle pašo pravednost savo avol taro Dol. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Golese kaj, o Hrist ane sa pherda o Zakon te bi avola opravdimo dži jekh savo pačal. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Golese kaj, o Mojsije pisil taro opravdanje, savo avol taro Zakon: “Kova savo ćerol e Devlese zapovestura, ka živil pale lende.” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Al ano Sveto lil vaćarol pe taro opravdipe savo avol taro pačajipe: “Te ma puče tut ano ilo: ‘Ko ka uštol ko nebo?’ So značil: ‘Ko ka anol e Hriste taro nebo ki phuv?’ ");
INSERT INTO rmyGurbet_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Thaj ma te pučen tumen: ‘Ko ka uljol ano bezdan?’ So značil: ‘Ko ka uljol te anol e Hriste tare mule?’” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Al sar si pisimo ano Sveto lil: “O Lafi e Devleso si paše tute, pe ćire vušta si thaj ane ćiro ilo” – gova Lafi si haberi e pačajimaso savo amen propovedi. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Gijate, te priznajisadan ćire vuštencar kaj “o Isus si Gospod” thaj pača ane ćiro ilo kaj o Dol vazdija le tare mule, ka ave spasimo. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Golese kaj, amen pača ano ilo te ava opravdime, al vuštencar priznaji te ava spasime. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Sar so si pisimo ano Sveto lil: “Khoni savo pačal ane leste, ni ka ladžal.” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Golese so naj razlika maškaro Jevrejo thaj o abandžija, golese kaj o Gospod si jekh thaj isto paše savorende thaj but blagoslovil kolen save akharen leso alav. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Gija si pisimo i ano Sveto lil: “Dži jekh savo akharol o alav e Gospodeso, ka avol spasimo.” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Al angleder so ka akharen e Devle, trubul te pačan ane leste. A palem, našti pačan ane leste te ni šunde lestar. A te bi šunena taro Gospod, trubul khoni te propovedil lenđe lestar. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Sar khoni ka propovedil lestar ako ni sasa bičhaldo taro Dol? Sar so si pisimo ano Sveto lil: “So si šukar kana avol kova savo anol o Lačho Lafi!” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Al ni prihvatisade savore o Lačho Lafi. Golese kaj, o proroko o Isaija vaćarol: “Gospode, ko pačaja ane amare lafura?” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","O pačajipe avol kana si šundo o Lačho Lafi, a o Lačho Lafi šundol kana si propovedimo o haberi taro Hrist. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Al me pučav: E manuša li ni šunde amaro haberi? Va, šunde! Sar so si pisimo ano Sveto lil: “Lengo glaso nakhlja sa i phuv thaj lenđe lafura šundile ko krajo e svetoso.” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Palem pučav: E Izraelcura li ni haljarde? Va, haljarde. Angleder o Dol vaćarda prekal o Mojsije: “Me ka ćerav tumen ljubomorna pe kola save naj narodo. Ka holjarav tumen narodosa savo ni haljarol.” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Thaj o proroko o Isaija bizi dar phenol: “Arakhlje man – e Devle – kola save ni rodije man. Sikadiljem kolenđe save ni pučlje manđe.” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Al pašo Izrael phenol: “Dži jekh đive pružisadem mingre vasta premale manuša, save si neposlušna thaj ponosna.” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Pučav, gijate: “Dal o Dol čhudija pe manušen?” Na, nisar! Golese kaj sem i me Izraelco taro potomstvo e Avraameso, tari koč e Venijaminesi. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Ni čhudija o Dol pe manušen saven angleder birisada. Ni li džanen so o proroko o Ilija vaćarda ano Sveto lil kana ani molitva žalisajlo e Devlese po Izrael? ");
INSERT INTO rmyGurbet_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“Gospode! Sa ćire prorokuren mudarde thaj ćire oltara perade. Ačhiljem samo me džuvdo, a akana roden thaj man te mudaren.” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Al so vaćarda o Dol e Ilijase? “Ačhadem manđe vadži efta milje (7 000) manušen save ni pele ke koča e Vaalese, e xoxavne devlese.” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Gija thaj ane kava vreme isi saven o Dol birisada pale piro milost. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","A te birisada len o Dol pale piro milost, tegani gova naj paše lenđe buća. Gija, e Devleso milost ne bi avola milost. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","So, tegani? E Izraelcura ni dobisade kova so rodije, al e birime dobisade, a averenđe zurajle e ile. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Sar so si pisimo ano Sveto lil: “Dija len o Dol duxovno sojipe, e jakha te ma dičhen thaj kana te ma šunen, sa dži kava đive.” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","O caro o David phenol: “Nek dolen pe ani klopka thaj nek peren ane zamke kana pheren pumare astalura xamasa. Nek peren thaj nek aven kaznime. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Nek aven lenđe jakha kore te našti dičhen, thaj nek banđon lenđe dume taro pharipe ane sa e đivesa.” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Pučav gijate: Dal sapletisajle e Izraelcura te bi perena? Na, nisar! Al paše lenđe grehura o spasenje avilo avere narodurenđe, te bi e Izraelcura avena ljubomorna. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Al te postanisada lengo greh baro blagoslov e svetose thaj gova so pele, postanisada blagoslov avere narodurenđe, kobor tegani avera narodura ka primin blagoslov kana e Jevreja ka aven gasave saven o Dol manđol? ");
INSERT INTO rmyGurbet_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Al tumenđe save naj sen Jevreja, vaćarav: golese so me sem apostol avere narodurengo, dav sa mandar te baravav mi služba ");
INSERT INTO rmyGurbet_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","ani nada te bi mingre manušen čhuvava te aven ljubomorna thaj te bi spasina pe nesave lendar. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Kana o Dol odbisada e Jevrejen, mirisajlo avere narodurencar. So, gija, ka značil kana o Dol palem ka prihvatil e Jevrejen, nego te vazdol len andare mule? ");
INSERT INTO rmyGurbet_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Te si angluno kotor taro humer posvetimo e Devlese, tegani si sa o humer sveto. A te si o koreno sveto, ka aven sveta i e raja. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Al te sesa nesave raja phađe thaj tu – savo naj san jevrejo – divljo maslino, san kalemime maškar lende thaj akana isi tut kotor ano koreno thaj primi blagoslov andaro koreno e maslinako, ");
INSERT INTO rmyGurbet_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","dikh te ma ave barikano angle čhinde raja. Al te san barikano, ma te bistre kaj ni inđare tu o koreno, nego o koreno tut. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Al tu vaćare: “E raja sesa čhinde te šaj me avav kalemimo ke lengo than.” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Čače, gola raja sesa čhinde golese so ni pačaje, al tu ačhe golese kaj pača. Ma te vazde tut, nego te dara golestar so bi šajine te avol. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Golese kaj, te o Dol ni poštedisada e čačukane raja, ni tut ni ka poštedil. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Golese, dikh savo šukar thaj strogo si o Dol. Vov si strogo premal kola save peren, al si šukar premal tute, te ačhiljan ane leso šukaripe. Al te ni ačhiljan, i tu ka ave čhindo. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Al i von e Izraelcura, te ni ačhile ano bipačajipe, ka aven palem kalemime. Golese kaj, o Dol isi le zuralipe palem len te kalemil. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Gija, te san tu – savo naj san jevrejo – sar prirodno ran tari divljo maslina čhindo thaj sana neprirodno kalemimo pi pitomo maslina, kobor tegani po ločheste ka aven kalemime pi piri maslina e Izraelcura save si laće čačukane raja? ");
INSERT INTO rmyGurbet_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Ni mangav, phralalen thaj phejalen, kava garajipe te ačhol tumenđe garado, ma te aven barikane. Nesave manuša taro Izrael si zurale ilenđe, al gova ka avol sa dži kaj o đinipe tare sa aver narodura ni ćerdol e Devleso narodo. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Gija ka avol spasimo sa o Izrael, sar so si pisimo ano Sveto lil: “Taro Sion ka avol o Izbavitelj thaj ka crdol tare Jakovese potomkura sa o bidevlikanipe. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Ka ćerav savez lencar kana ka crdav lenđe grehura.” ");
INSERT INTO rmyGurbet_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","But tare manuša andaro Izrael si akana dušmanura e Lačhe Lafese, al gova si šukaripe tumenđe, avere narodurenđe. Al, von si vadži birime manuša saven o Dol manđol, golese so si von potomkura taro Avraam, o Isaak thaj o Jakov. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Golese so, o Dol ni menjil pi odluka kas akharol thaj kase dol pe darura. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Sar so tumen save naj sen jevreja ano anglunipe ni šunden e Devle, al akana primisaden o milosrđe paše jevrejengo bipačajipe, ");
INSERT INTO rmyGurbet_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","gija i e jevreja akana ni šunen e Devle, tumen save naj sen jevreja, te primin o milosrđe, te bi i von primina e Devleso milosrđe. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Golese kaj, o Dol sa e manušen phanglja ano neposlušnost, te bi savorenđe smiluila pe. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","O, kobor si baro e Devleso barvalipe, mudrost thaj o džanglipe! E Devlese odluke khoni našti objasnil thaj lese droma khoni našti haljarol. ");
INSERT INTO rmyGurbet_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Sar so si pisimo ano Sveto lil: “Ko pindžarda e Gospodesi gođ