﻿USE sofia;
DROP TABLE IF EXISTS sofia.rmyChergash_vpl;
CREATE TABLE rmyChergash_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES rmyChergash_vpl WRITE;
INSERT INTO rmyChergash_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Akava si poreklo katar o Isuso Hristo. Vo sas potomko e caresko Davidesko thaj e Avraamesko potomko. ");
INSERT INTO rmyChergash_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","E Avraamešće bijandilo o Isaak. E Isaakošće bijandilo o Jakov. E Jakovešće bijandilo o Juda thaj e phrala lešće. ");
INSERT INTO rmyChergash_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","E Judašće e Tamara bijandas e Farese thaj e Zare. E Faresošće bijandilo o Esrom. E Esromešće bijandilo o Aram. ");
INSERT INTO rmyChergash_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","E Aramešće bijandilo o Aminadav. E Aminadavešće bijandilo o Naason. E Naasonešće bijandilo o Salmon. ");
INSERT INTO rmyChergash_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","E Salmonešće e Rahava bijandas e Voozo. E Voozešće e Ruta bijandas e Ovido. E Ovidešće bijandilo o Jesej. ");
INSERT INTO rmyChergash_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","E Jeseješće bijandilo o caro David. E Davidešće e Urijašći bivšo romnji bijandas e Solomones. ");
INSERT INTO rmyChergash_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","E Solomonešće bijandilo o Rovoam. E Rovoamešće bijandilo o Avija. E Aviješće bijandilo o Asaf. ");
INSERT INTO rmyChergash_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","E Asafešće bijandilo o Josafat. E Josafatešće bijandilo o Joram. E Joramešće bijandilo o Ozija. ");
INSERT INTO rmyChergash_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","E Ozijašće bijandilo o Joatam. E Joatamešće bijandilo o Ahaz. E Ahazešće bijandilo o Ezekija. ");
INSERT INTO rmyChergash_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","E Ezekijašće bijandilo o Manasija. E Manasijašće bijandilo o Amos. E Amosešće bijandilo o Josija. ");
INSERT INTO rmyChergash_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","E Josijašće bijandilo o Jehonija thaj lešće phrala ande vrjama kana o izraelsko them sas inđardo ando vavilonsko progonstvo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nakon so sas inđarde ando Vavilon, e Jehonijašće bijandilo o Salatiilo. E Salatiilešće bijandilo o Zorovavel. ");
INSERT INTO rmyChergash_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","E Zorovavelešće bijandilo o Aviud. E Aviudašće bijandilo o Elijakim. E Elijakimešće bijandilo o Azor. ");
INSERT INTO rmyChergash_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","E Azorešće bijandilo o Sadok. E Sadokošće bijandilo o Ahim. E Ahimešće bijandilo o Elijud. ");
INSERT INTO rmyChergash_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","E Elijudešće bijandilo o Eleazar. E Eleazarešće bijandilo o Matan. E Matanešće bijandilo o Jakov. ");
INSERT INTO rmyChergash_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","E Jakovešće bijandilo o Josif, o rom e Marijako, savi bijanda e Isuse save akhardine Hristo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Akava si, dakle, sa ukupno dešuštar naraštaja katar o Avram dži ko caro David, dešutrito štar naraštaja katar o caro David dži ko progonstvo ando Vavilon, thaj dešutrito štar naraštaja katar o progonstvo ando Vavilon dži ko Hristo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ake sar bijandilo o Isuso Hristo: lešći dej e Marija, sas mangli palo Josif. Ali majsigo nego so line pe, dok sas još čhej, sikadilo kaj e Marija ačhili phari katar o Sveto Duho. ");
INSERT INTO rmyChergash_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Sar lako rom o Josif sas pravedno manuš thaj či kamlas javno te ladžarel lat, kamlas potajno te mućel lat. ");
INSERT INTO rmyChergash_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Sar gindilas godova, lija les e lindri thaj ando suno sikadilo lešće o anđelo e Gospodesko thaj phendas lešće: “Josife, e Davidešće čhaveja, na dara te les e Marija pale ćiri romnji! Kaj e čhavre saves inđarel ande peste si katar o Sveto Duho. ");
INSERT INTO rmyChergash_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Voj bijanela čhave, a tu deja les alav Isus, kaj vo spasila piro them katar lenđe bezeha.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","A sa godova dogodisajlo te pherdol okova so o Gospod phendas kroz o proroko: ");
INSERT INTO rmyChergash_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ake e čhej ačhela khamni! Thaj bijanela čhaves savo akhardola Emanuel” (so značil: “O Del si amenca”). ");
INSERT INTO rmyChergash_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Kana o Josif džungadilo, ćerda sar zapovedisardas lešće o anđelo e Gospodesko thaj lijas e Marija pale piri romnji. ");
INSERT INTO rmyChergash_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ali či suta lasa dok voj či bijandas čhaves. A kana o čhavro bijandilo, dija les alav Isus. ");
INSERT INTO rmyChergash_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","O Isus bijandilo ando gav Vitlejem savo sas ande judejsko regija, ande vrjama kana vladilas o caro Irod. Ande godoja vrjama aviline e mudracurja katar o Istok ando Jerusalim ");
INSERT INTO rmyChergash_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","thaj počnisardine te raspituin pe: “Kaj si godova o nevo bijando caro e Židovengo? Dikhlam lešći čerain sar inkljel po istok thaj avilam te das koča angle leste.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kana godova ašundas o caro Irod zurale uznemirisajlo sago vi o sa o them ando Jerusalim. ");
INSERT INTO rmyChergash_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Askal akhardas sa e židovske šorvale rašajen thaj e učiteljen e Mojsiješće zakonestar te phučel lendar: “Kaj o Hristo trubul te bijandol?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","A von phendine lešće: “Ando Vitlejem ande Judeja, kaj gajda o proroko ramosarda: ");
INSERT INTO rmyChergash_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘A tu Vitlejeme, ande judejsko phuv, nipošto naj san majcikno katar aver e judejske gava, kaj andar tute inkljela o vladari savo vodila mungro theme o Izraele sago o pastiri pire bakhren.’” ");
INSERT INTO rmyChergash_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Askal o Irod čordanes akhardas peste e mudracen te phučel lendar kana inkljisti e čerain. ");
INSERT INTO rmyChergash_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Askal phendas: “Džan thaj lačhe phučen pale godova čhavro thaj kana araćhena les, bolden tumen thaj javin manđe te šaj džav vi me te pokloni man lešće,” thaj bičhalda len ando Vitlejem. ");
INSERT INTO rmyChergash_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Kana ašundine so phendas lenđe o caro Irod thaj đeletar. A e čerain savja dikhline sar inkljel džalas angle lende dok či ačhili anglo than kaj sas o čhavro. ");
INSERT INTO rmyChergash_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Kana dikhline e čerain kaj ačhili, zurale raduisajle. ");
INSERT INTO rmyChergash_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Dine ando ćher thaj dikhline e čhavre lešće dejava e Marijasa thaj peline pe pire koča thaj poklonisajle lešće. Pale godova putardine pire kutijice thaj daruisardine les e sunakajesa, tamnjanosa thaj e mirisno uljesa. ");
INSERT INTO rmyChergash_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Pale godova o Del upozorisarda len ando suno te či bolden pe ko Irod, nego boldine pe ande pešći phuv aver dromesa. ");
INSERT INTO rmyChergash_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","A kana von đeletar, o anđelo e Gospodesko javisajlo e Josifešće ando suno thaj phendas lešće: “Ušti, le e čhavre thaj lešće deja thaj naš ando Egipat. Ačh okote dok či phenav tuće, kaj o Irod rodela e čhavre te mudarel les.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","O Josif uštilo, lija e čhavre thaj lešće deja thaj još isto rjat uputisajlo lenca ando Egipat. ");
INSERT INTO rmyChergash_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Thaj ačhilo okote dok o Irod či mulo, te pherdol so o Gospod phendas prekal o proroko savo phenel: “Andar o Egipat akhardem mungre čhaves.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Kana o Irod dikhla kaj e mudracurja nadmudrisardine les, zurale holjajlo thaj naredisarda te ando Vitlejem thaj sasti okolina mudaren sa e muške čhavren dži ke duj brš, prema e vrjama savi saznaisardas katar e mudracurja kana inkljisti e čerain. ");
INSERT INTO rmyChergash_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Askal pherdilo okova so o Del phendas prekal o proroko Jeremija: ");
INSERT INTO rmyChergash_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ando gav e Rama ašundilo o glaso, o roipe thaj o jauk. Godova e Rahilja rovel pale pire čhavra thaj našti utešil pes kaj majbut naj len.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Kana mulo o Irod, o anđelo e Gospodesko javisajlo ando suno e Josifešće ando Egipat ");
INSERT INTO rmyChergash_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","thaj phendas lešće: “Ušti, le e čhavre thaj lešće deja thaj bolde tut lenca palpale ande izraelsko phuv, kaj okola save line te mudaren e čhavres muline.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","O Josif uštilo, lija e čhavre thaj lešće deja, thaj bolda pe ande izraelsko phuv. ");
INSERT INTO rmyChergash_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ali kana ašundas kaj e Judejava vladil o Arhelaj umesto lesko dad, darajlo te džal okote, ali o Del upozorisarda les ando suno te džal ande galilejaći regija. ");
INSERT INTO rmyChergash_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Thaj nastanisajlo ando gav Nazaret. Godolesa pherdilo okova so phendine e prorokurja palo Mesija kaj akhardola Nazarećanino. ");
INSERT INTO rmyChergash_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ande godoja vrjama o Jovano savo bolelas počnisarda te propovedil ande judejsko pustinja. ");
INSERT INTO rmyChergash_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Thaj phenelas: “Pokajin tumen pale tumare bezeha thaj obratin tumen e Devlešće kaj o Carstvo nebesko si paše!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","O proroko Isaija phenelas palo Jovano kana prorokuisardas: “Vo si o glaso savo čhol muj ande pustinja: ‘Pripremin o drom palo Gospod, vorton e staze pale leste!’” ");
INSERT INTO rmyChergash_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","A o Jovano inđarelas pe peste e drze save sas ćerde katar e kamilaće bal, a oko maškar sas les morćhako pojas. O habe lesko sas e skakavcurja thaj o divljo medo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Leste avelas o but o them andar o Jerusalim, andar e Judeja thaj andar sa e krajurja oko e reka Jordan. ");
INSERT INTO rmyChergash_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ispovedinas lešće pire bezeha, a vo bolelas len ande reka Jordan. ");
INSERT INTO rmyChergash_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","A kana o Jovano dikhla e but e farisejen thaj e sadukejen kaj aven leste te bolel len, phendas lenđe: “Tumen e sapešće čhavra! Koli upozorisarda tumen te našen katar e Devlešći bari holji savi avel? ");
INSERT INTO rmyChergash_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Sikaven tumare trajosa thaj tumare plodonenca kaj pokajisardine tumen katar tumare bezaha. ");
INSERT INTO rmyChergash_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Thaj na hohaven korkoro tumen kaj si tumenđe dosta te phenen: ‘Amen sam e Avramešće potomkurja’ kaj phenav tumenđe: o Del šaj vi katar akala bara te vazdel čhavren e Avramešće. ");
INSERT INTO rmyChergash_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","O tover e Devlešće sudosko već si čhutino po koreno e kaštesko. Svako kaš savo či bijanel lačhe plodurja čhinela pe thaj čhudela pe ande jag. ");
INSERT INTO rmyChergash_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Me bolav tumen e pajesa, palo pokajanje katar tumare bezeha. Ali avel vareko posle mande ko si majmoćno mandar, kašće naj sem dostojno e sandale te inđarav. Vo bolela tumen e Sveto Duhosa thaj e jagasa. ");
INSERT INTO rmyChergash_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Vo si spremno te losarel o kućin e đivesko katar e pleva. O điv ćidela thaj spremila ande piri žitnica, a e pleva dela jag e jagasa savi našti mudardol.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Askal avilo o Isus andar e Galileja pe reka Jordan te o Jovano bolel les. ");
INSERT INTO rmyChergash_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","A o Jovano či kamlas te bolel les thaj phenelas lešće: “Tu trubul man te boles, a tu aves mande te me bolav tut?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","A o Isus phendas lešće: “Muk akana, kaj agajda trubul amenđe te pheras e Devlešći pravedno volja.” Askal o Jovano bola les. ");
INSERT INTO rmyChergash_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Pale godova kana sas o Isus boldo thaj čim inkljisto andar o paj. Thaj dik! O nebo putajlo thaj vo dikhla e Devlešće Duho sar fuljel sago golubo thaj mućel pes pe leste. ");
INSERT INTO rmyChergash_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Askal o glaso andar o nebo ašundilo: “Akava si mungro Čhavo, saves voliv. Vo si mungri bah.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Askal o Sveto Duho inđardas e Isuse ande pustinja te iskušil les o beng. ");
INSERT INTO rmyChergash_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","O Isus postilas štarvardeš đesa thaj štarvardeš raća, a pale godova bokhajlo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Askal avilo leste o beng thaj iskušisarda les gajda kaj phendas lešće: “Ako san Čhavo e Devlesko, phen te akala bara aven mangre.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","A o Isus phendas: “Ando Sveto lil ačhel ramome: ‘Či trajil o manuš samo katar o mangro, nego katar svako alav savo inkljel andar e Devlesko muj.’” ");
INSERT INTO rmyChergash_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Askal o beng inđarda e Isuse ando Sveto gav Jerusalim thaj čhuta les po vrho e Hramosko, ");
INSERT INTO rmyChergash_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","thaj phendas lešće: “Ako san tu Čhavo e Devlesko, čhude tut katar tele. Kaj ando Sveto lil ramol: ‘Pire anđelenđe zapovedila pale tute’ thaj: ‘von pe vas inđarena tut te či pećes e pungresa ando bar.’” ");
INSERT INTO rmyChergash_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","A o Isus phendas lešće: “Ramome si vi akava: ‘Na iskušisar e Gospode ćire Devle.’” ");
INSERT INTO rmyChergash_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Askal o beng inđarda les po vrho pe vuči gora, thaj sikadas lešće sa e carstvurja akale themešće thaj e slava lenđi. ");
INSERT INTO rmyChergash_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Thaj phendas lešće: “Sa akava dava tut ako peres pe koča angle mande thaj slavis man.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Askal o Isus phendas lešće: “Džatar mandar, Sotono, kaj ando Sveto lil si ramome: ‘De koča samo anglo Gospod ćiro Del, thaj jedino les slavisar.’” ");
INSERT INTO rmyChergash_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Askal o beng đelotar lestar, a e anđelurja odma aviline thaj služisardine lešće. ");
INSERT INTO rmyChergash_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Kana o Isus ašundas kaj phangline e Jovano savo bolelas, bolda pe ande galilejsko regija. ");
INSERT INTO rmyChergash_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Avilo prvo ando Nazaret thaj okotar đelotar thaj nastanisajlo ando Kafarnaum, gav pašo galilejsko jezero, pe Zavulonešći thaj e Neftalimešći phuv. ");
INSERT INTO rmyChergash_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Gajda pherdilo so phendas o proroko Isaija: ");
INSERT INTO rmyChergash_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ande phuv e Zavulonešći thaj e Neftalimešći, pašo more, pe okoja rig e jordanošći, ande Galileja, e phuv savi nas e židovenđi, ");
INSERT INTO rmyChergash_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","e manuša save trajinas ando tunjariko, dikhline o baro svetlo thaj okolenđe save trajinas ande mračno phuv, ande sena e smrtošći zasjaisardas o svetlo.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Katar askal o Isus počnisarda te propovedil: “Pokajin tumen pale tumare bezeha thaj obratin tumen kaj si paše o Carstvo nebesko!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Kana o Isus naćhelas pašo Galilejsko jezero, dikhla e duj phralen e Simone saves akharenas Petar, thaj lešće phrale e Andrija, sar čhuden e mreža ando jezero, kaj von sas ribarja. ");
INSERT INTO rmyChergash_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Thaj o Isus phendas lenđe: “Aven pale mande thaj me ćerava tumen te aven ribarja save astarena e manušen sago e mačhen.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Von odma mukline e mreže thaj teljardine pale leste. ");
INSERT INTO rmyChergash_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Kana o Isus đelo majdur okotar dikhla e aver duj phralen, e Jakove thaj e Jovane e Zevedejevešće čhaven, sar bešen ando čamco pire dadeja thaj lačharenas pire mreže, askal akhardas vi len. ");
INSERT INTO rmyChergash_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","A von odma mukline o čamco thaj pire dades thaj teljardine pale leste. ");
INSERT INTO rmyChergash_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","O Isus džalas pe sasti Galileja thaj sikavelas e manušen ande lenđe sinagoge, propovedilas lenđe e Bahtali nevimata pale Devlesko carstvo thaj sastarelas katar o nasvalipe thaj svako nemoć andar o them. ");
INSERT INTO rmyChergash_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","O glaso pale leste buljilo pe sasti sirisko regija, thaj anenas lešće sa okolen save sas nasvale katar o razno nasvalipe savo mučilas len, okolen ande save sas e bilačhe duhurja, mesečaren thaj e linen thaj vo sastarelas len. ");
INSERT INTO rmyChergash_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Pale leste teljardas o but o them andar e Galileja, Dekapolja, Jerusalim thaj andar e sasti Judeja, pa vi katar okoja rig e jordanošći. ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Kana o Isus dikhla kaj ćida pes o but o them, lija pe opre pe gora thaj bešlo. Pe godova aviline leste e učenikurja ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","thaj o Isus počnisarda te sikavel len alavenca: ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Blago okolenđe save svatin kaj si lenđe o Del potrebno kaj si lengo o Carstvo nebesko! ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Blago okolenđe save tugujin, kaj o Del utešila len! ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Blago okolenđe e kovle ileja kaj nasledina e phuv; ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Blago okolenđe save si bokhale thaj trušale pale pravednost, kaj čaljona! ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Blago okolenđe save si milosrdne, kaj o Del smiluila pe lenđe! ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Blago okolenđe save si čiste ileja, kaj e Devles dićhena! ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Blago okolenđe kaj ćeren miro, kaj akhardona čhave e Devlešće! ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Blago okolenđe save si progonime andar godova kaj si pravedne anglo Del, kaj lengo si o Carstvo nebesko! ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Blago tumenđe kana zbog mande avena vređome, progonime thaj kana hohaipe phenena pe tumende thaj vi svako vrsta bilačhipe! ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Raduin tumen thaj aven bahtale, kaj si bari tumari poćin ando nebo. Kaj gajda progoninas vi e prorokonen save sas majsigo tumendar!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","O Isus phendas: “Tumen sen o lon e themenđe pe phuv. Ako o lon naj londo, sova lonđarela pe? Askal majbut či avela pale khančeste, osim te čhudel pe avri te o them uštavel les. ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Tumen sen svetlo e themešće. Našti garadol o gav savo si pe gora. ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Či den jag o stenko te čhon les talo čaro, nego čhon les po čirako te svetlil savorenđe ando ćher. ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Gajda tumaro svetlo neka svetlil angle manuša te dićhen pe tumare lačhe dela thaj te slavin tumare Dades savo si ando nebo.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","O Isus phendas: “Na te gindin kaj me avilem te čhinav e Mojsijesko zakono thaj e prorokonenđe zapisurja. Či avilem te čhinav len, nego te pherav len. ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Čače phenav tumenđe: sa dži kaj postoil o nebo thaj e phuv, či naćhela ni majcikno slovo niti jek crtica andar e Mojsijesko zakono dok sa či dogodil pe. ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ali, ako vareko phenel kaj naj važne jek katar akala majcikne zapovesti thaj gajda sikavel aver manušen, majcikno avela ando Carstvo nebesko. A ko inčarel e zapovesti thaj aver manušen sikavel te ćeren gajda avela baro ando Carstvo nebesko. ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Kaj phenav tumenđe, te či avili tumari pravednost majbari katar e pravednost e učiteljenđi e Mojsiješće zakonestar thaj e farisejenđi, nisar či dena ando Carstvo nebesko!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","O Isus phendas: “Ašundine sar si phendo ande Mojsijesko zakono amare prapaponenđe: ‘Na mudar, kaj ko mudarel, avela došalo e sudošće.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","A me phenav tumenđe: ko holjavol pe piro phral, avela došalo e sudošće! A ko phenel pire phralešće kaj si čalado, avela došalo angle majbaro sudo. A ko phenel pire phralešće dileja, avela došalo anglo pakao e jagako. ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Zato ako anes ćiro daro po žrtveniko thaj okote des tut gođi kaj ćire phrales si vareso protiv tute, ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","muk e žrtva anglo žrtveniko thaj dža majsigo thaj pomirisar tut ćire phralesa, thaj tek askal av thaj prinesisar ćiro žrtveno daro e Devlešće. ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Brzo nagodisar tut ćire protivnikosa dok san lesa po drom, te či inkalel tut anglo sudo, a o sudco či čhudel tut ande tamnica. ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Čače phenav tuće: či inkljeja okotar dok či poćines sa so san udžile dži ko poslednjo lovoro.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","O Isus majdur phenelas: “Ašundine sar si phendo ando zakono: ‘Na ćer preljub!’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","A me phenav tumenđe: Svako savo dićhel pe avrešći romnji te sovel lasa, već ande piro ilo ćerda lasa preljub. ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ako ćiri desno jak crdel tut po bezeh, inkal ćiri jak thaj čhude lat tutar, kaj majlačhe tuće te propadnil jek deo katar ćiro telo, nego ćo sasto telo te avel čhudino ando pakao. ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Thaj ako ćiro desno vas crdel tut po bezeh, čhin ćo vas thaj čhude les tutar, kaj majlačhe tuće te propadnil jek deo katar ćiro telo, nego sasto ćo telo te džal ando pakao.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","O Isus majdur phenelas: “Ašundine kaj si phendo ando Mojsijesko zakono: ‘Ko rastavil pe pire romnjatar, neka del lat lil kaj si rastavime.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","A me phenav tumenđe: Svako ko rastavil pe pire romnjatar, osim zbog o preljub, crdel lat te ćerel preljub. Thaj svako ko oženil pe rastavime romnjava, ćerel preljub.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","O Isus majdur phenelas: “Isto gajda ašundine kaj si dumutune phendo ande Mojsijesko zakono amare prapaponenđe: ‘Inćar e solah savi dijan e Gospodešće.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","A me phenav tumenđe: Na han solah, ni e nebosa, kaj si prestolje e Devlesko, ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ni e phuvjasa, kaj si tale lešće pungre, ni e Jerusalimeja, kaj si gav e Devlesko, e bare carosko. ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Na han solah ni tumare šoresa, kaj našti ni jek bal po šoro te ćeren ni kali ni parni. ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Zato kana phenen: ‘Kamav’, neka avel ‘Kamav’, thaj kana phenen: ‘Či kamav’, neka avel ‘Či kamav’. Sa so si majbut katar godova, avel katar o bilačho.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","O Isus majdur phendas: “Ašundine kaj si phendo ando Mojsijesko zakono: ‘Jak pale jak, dand palo dand.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","A me phenav tumenđe: na oduprin tumen e bilačhe manušešće! Te vareko pekla tut pe desno rig ćire mujestar, tu bolde lešće vi aver rig. ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Thaj ako vareko kamel te sudil pe tusa te lel tutar ćiro gad, de les vi ćiro ogrtači. ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Te traden tut e rimske vojnikurja te inđares lenđi oprema jek kilometar, tu inđar duj. ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ko manđel tutar vareso, de les, thaj na bolde e dume okolestar ko zamolil tut te des les udžile.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","O Isus majdur phendas: “Ašundine kaj si phendo: ‘Volisar ćire pašutnes’, a mrzisar ćire dušmanes. ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","A me phenav tumenđe: volin tumare dušmajen thaj molin tumen pale okola save progonin tumen! ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ako gajda ćeren, avena sago prave čhave tumare nebesko Dadešće, savo del te inkljel lesko kham pe bilačhe thaj pe lačhe manuša, thaj del te lesko bršnd perel okolenđe kaj si pravedne thaj okolenđe kaj si nepravedne. ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kaj te volin samo okolen save tumen volin, sošći nagrada šaj ažućaren? Zar či ćeren godova vi e carinikurja? ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ako pozdravin samo tumare phralen, zar ćeren vareso naročito? Zar či ćeren godova vi okola kaj či pinđaren e Devle. ");
INSERT INTO rmyChergash_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Gajda vi tumen aven savršene, sago kaj si savršeno tumaro Dad nebesko.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","O Isus phendas: “Len sama te tumare lačhe dela či ćeren angle manuša te von divin pe tumenđe, kaj askal či primina nagrada katar tumaro Dad nebesko. ");
INSERT INTO rmyChergash_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Zato kana des e čorenđe, na hvali tu po sasto muj anglo them, sago kaj ćeren e licemerja pe sinagoge thaj pe sokača te hvalin len e manuša. Čače phenav tumenđe: aver nagrada či dobina osim godoja katar e manuša. ");
INSERT INTO rmyChergash_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","A tu kana des e čorenđe, neka či džanel ćiro levo vas so ćerel ćiro desno vas. ");
INSERT INTO rmyChergash_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Nego kana tu des e čorenđe de len potajno pa ćiro Dad, savo dićhel so si potajno, nagradila tut.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","O Isus phendas: “kana molin tumen na aven sago e licemerja, save volin te molin pes pe sinagoge thaj pe glavne sokača, te e manuša dićhen len. Čače phenav tumenđe kaj već primisardine piri nagrada thaj osim godoja aver či primina. ");
INSERT INTO rmyChergash_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","A tu, kana molis tut, dža ande ćiri soba, phandav pale tute o vudar thaj moli tut potajno ćire nebesko Dadešće, a ćiro nebesko Dad, savo dićhel so si potajno, nagradila tut. ");
INSERT INTO rmyChergash_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Kana molin tumen na brbljin sago okola save či pindžaren e Devle, kaj von gndin kaj o Del ašunela len zbog e but alava save phenen. ");
INSERT INTO rmyChergash_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Tumen dakle na aven sago von, kaj tumaro Dad nebesko lačhe džanel so trubul tumen vi majsigo nego so zamolin les. ");
INSERT INTO rmyChergash_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Tumen agajda molin tumen: ‘Dade amareja savo san po nebo, nek poštuil pe ćiro sveto alav. ");
INSERT INTO rmyChergash_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Neka avel ćiro carstvo. Te avel ćiri volja pe phuv sago kaj si ando nebo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","De amen mangro savo si amenđe potrebno pale svako đes ");
INSERT INTO rmyChergash_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","thaj jartosar amenđe e bezeha amare sago kaj vi amen jartosaras okolenđe save sagrešisardine protiv amende. ");
INSERT INTO rmyChergash_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Na de te peras ande kušnje, nego izbavisar men andar o bilačhipe.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Kaj, ako jarton okolenđe save grešin protiv tumende, askal vi tumaro nebesko Dad jartola tumenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ali, ako tumen či jarton e manušenđe lenđe bezeha, ni tumaro nebesko Dad či jartola tumenđe tumare bezeha.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","O Isus majdur phenelas: “A kana postin, na mućen tumaro muj sago e licemerja, te dićhen len e manuša sar postin. Kaj čače phenav tumenđe, kaj aver nagrada či dobina osim godoja katar e manuša. ");
INSERT INTO rmyChergash_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","A tu kana postis, thov ćiro muj thaj fulav ćire bal, ");
INSERT INTO rmyChergash_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","te e manuša na dićhen kaj postis, nego samo ćiro Dad, savo si ande tajnost. Askal ćiro Dad savo dićhel so si ćerdo ande tajnost nagradila tut.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","O Isus phendas: “Na ćiden tumenđe barvalipe akate pe phuv, kaj han les e moljcurja thaj e rđa, kaj e čora provalil thaj čoren les. ");
INSERT INTO rmyChergash_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nego, ćiden tumenđe barvalipe po nebo, kaj či hal les ni e moljcurja ni e rđa thaj kaj e čora či provalil te čoren les. ");
INSERT INTO rmyChergash_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Zato, kaj si ćiro barvalipe, okote avela vi ćiro ilo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ćiri jak si sar e svetiljka e telošće. Zato, ako si ćiri jak sasti, sasto ćiro telo avela osvetlime. ");
INSERT INTO rmyChergash_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ali ako si ćiri jak nasvali, sasto ćiro telo avela ando tunjariko. Ako o svetlo ande tute postanil tunjariko, sosko baro tunjariko avela ande tute!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Khonik našti robujil e duje gospodarenđe. Kaj jećhe mrzala, a avere volila, ili jećhešće avela paćivalo a avres prezirila. Našti služin e Devlešće thaj e barvalipešće ande isto vrjama.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","O Isus još phendas: “Zato phenav tumenđe: Na daran pale tumaro trajo, so hana, ili so pijena, ni palo tumaro telo, so lena pe tumende. Naj li o trajo majbut katar o habe, a o telo katar e drze? ");
INSERT INTO rmyChergash_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Lačhe dićhen e čirikljen! Niti sadin, niti žanjin niti ćiden ande pire žitnice, a tumaro nebesko Dad pravarel len. Zar tumen naj sen majvredne lendar? ");
INSERT INTO rmyChergash_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","A ko tumendar šaj e brigenca te lunđarel piro trajo samo pale jek đes? ");
INSERT INTO rmyChergash_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Sostar askal vodin e briga pale drze? Lačhe dićhen e divlje luluđa sar barjon! Či trudin pe niti suven pešće drze. ");
INSERT INTO rmyChergash_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","A phenav tumenđe kaj ni o caro Solomon ande sa piro barvalipe či inđarelas pe peste gajda šukar drze sago akala divlje luluđa. ");
INSERT INTO rmyChergash_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Pa ako o Del gajda šukar furjarel e biljke save si ando polje, save ađes si, a thejara čhuden pe ando bov, kozom askal majbut vodila e briga pale tumende, manušalen e cikne paćimava? ");
INSERT INTO rmyChergash_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Zato na daran thaj na phenen: ‘So hasa?’, ili ‘So pijasa?’ ili ‘So lasa pe amende?’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kaj godova roden e bi paćivale manuša. Džanel tumaro nebesko Dad sa so trubul tumen. ");
INSERT INTO rmyChergash_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Zato majbut katar sa roden e Devlesko carstvo, thaj e pravda lešći, askal sa akava o Del nadodaila tumenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Zato na daran pale thejara. Neka o đes thejara vodil e briga pale peste. Svako đesešće si dosta lešće muke.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","O Isus majdur phenelas: “Na sudin, thaj či sudila pe tumenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kaj sar tumen sudin averenđe, gajda o Del po isto način sudila tumenđe. Sar tumen merin averenđe, gajda vi o Del merila tumenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Sostar dićhes e kaštešći prušuk ande jak ćire phralešći, kana či haćares o baro kaš ande ćiri jak? ");
INSERT INTO rmyChergash_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Sar šaj phenes ćire phralešće: ‘Ažućar te inkalav e kaštešći prušuk andar ćiri jak’, kana o baro kaš si tut ande ćiri jak? ");
INSERT INTO rmyChergash_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Licemernona! Majsigo inkal o baro kaš andar ćiri jak, thaj majlačhe dićheja te inkales e kaštešći prušuk andar ćire phralešći jak. ");
INSERT INTO rmyChergash_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Na den e džućhelenđe okova so si sveto thaj na čhuden e biserja angle bale, te na uštaven len e pungrenca thaj askal bolden pe protiv tumende thaj te rastrgnon tumen.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","O Isus majdur phenelas: “Molin tumen thaj dela pe tumenđe! Roden, thaj araćhena! Maren po vudar thaj putrela pe tumenđe! ");
INSERT INTO rmyChergash_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kaj svako ko molil, primil, ko rodel, araćhel, a ko marel po vudar, putrel pe lešće. ");
INSERT INTO rmyChergash_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ko tumendar kana lesko čhavo manglasas lestar mangro, dija sas les bar? ");
INSERT INTO rmyChergash_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ili kana manglasas lestar mačho dija sas les sap? ");
INSERT INTO rmyChergash_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ako tumen, vi ako sen bilačhe manuša, džanen te den lačhe darurja tumare čhavrenđe, kozom majbut tumaro nebesko Dad dela lačhipe okolen save manđen lestar? ");
INSERT INTO rmyChergash_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Sa, dakle, so kamen te e manuša ćeren tumenđe, ćeren vi tumen lenđe, kaj godova si okova so sikavelas e Mojsijesko zakono thaj e prorokurja.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","O Isus majdur phenelas: “Den andre po usko vudar. Kaj o bulo vudar thaj o bulo drom inđaren ande propast thaj but si okola save godole dromesa džan. ");
INSERT INTO rmyChergash_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Sar si usko o vudar thaj tesno drom savo inđarel ando trajo, cara si okola save araćhen les!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","O Isus majdur phendas: “Len tumen sama katar e hohamne prorokurja, save aven tumenđe ande bakhrani morćhi, a andral si ruva save kamen te han tumen. ");
INSERT INTO rmyChergash_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Pindžarena len pe lenđe plodurja. Dali katar e kangre kušel pe e drak, ili e smokve katar e čičkurja? ");
INSERT INTO rmyChergash_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Isto gajda, svako lačho kaš bijanel lačhe plodurja, a o bilačho kaš bijanel bilačhe plodurja. ");
INSERT INTO rmyChergash_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Našti o lačho kaš bijanel bilačhe plodurja, niti o bilačho kaš šaj bijanel lačhe plodurja. ");
INSERT INTO rmyChergash_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Svako kaš savo či bijanel lačhe plodurja, čhinela pe thaj čhudel pe ande jag. ");
INSERT INTO rmyChergash_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Isto gajda pindžarena e hohamne prorokonen pe lenđe plodurja.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","O Isus majdur phenelas: “Či dela ando Carstvo nebesko svako ko phenel manđe ‘Gospode, Gospode!’ Nego okova savo izvršil e volja mungre Dadešći savo si ando nebo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","But džene avena po sudo ande godola đesa thaj phenena manđe: ‘Gospode, Gospode, zar či prorokujisardam ande ćiro alav? Zar či thradasas e benđen ande ćiro alav? Thaj zar či ćerasas but čudurja ande ćiro alav?’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Askal priznajiva lenđe: ‘Nikad či pindžaravas tumen. Džantar mandar, tumen save kršin e Devlesko zakon!’” ");
INSERT INTO rmyChergash_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","O Isus majdur phenelas: “Prema godova, svako ko čhol kan ke akala munge alava thaj gajda ćerel, mudro si sago o manuš savo gradil piro ćher po čvrsto temelji. ");
INSERT INTO rmyChergash_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Pelo o bršnd, navalisada e bujica, phurdas e balval thaj peklas ando godova ćher, ali o ćher či pelo kaj sas sagradime po čvrsto temelji. ");
INSERT INTO rmyChergash_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Naprotiv, svako ko čhol kan ke akala mungre alava, ali či ćerel gajda, slično si sago o dilo manuš savo sazidosardas piro ćher po pesko. ");
INSERT INTO rmyChergash_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Pelo o bršnd, navalisarda e bujica, phurdas e balval thaj peklas ande godova ćher, thaj o ćher haradilo dži ko temelji.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Kana o Isus sas gata godole alavenca, o but o them čudilas pe lešće sikavipešće, ");
INSERT INTO rmyChergash_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","kaj sikavelas sago okova saves si autoriteto, a na sago lenđe učitelja e Mojsiješće zakonestar. ");
INSERT INTO rmyChergash_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Kana o Isus fuljisto katar e gora, pale leste teljarda o but o them. ");
INSERT INTO rmyChergash_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Anglo Isus avilo jek gubavco, pelo pe koča angle leste thaj zamolisarda les: “Gospode! Te kames, šaj te sastares man katar e guba!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","O Isus čhuta po vas pe leste, thaj phendas: “Kamav, av sasto!” Thaj e guba odma nestanisardas lestar. ");
INSERT INTO rmyChergash_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","A o Isus phendas lešće: “Le sama te na phenes khonikašće pala akava, nego dža thaj sikav tu e rašaješće, thaj prinesisar o daro savo o Mojsije odredisardas palo svedočanstvo lenđe.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Kana o Isus avilo ando Kafarnaum, avilo dži leste jek rimsko kapetano thaj zamolisarda les: ");
INSERT INTO rmyChergash_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Gospode, mungro sluga pašljol ćhere nepokretno thaj zurale mučilpe.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","A o Isus phendas lešće: “Avava thaj sastarava les.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","A o kapetano phendas: “Gospode! Naj sem dostojno te des ande mungro ćher; nego samo phen alav thaj o sluga mungro sastola! ");
INSERT INTO rmyChergash_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kaj vi me sem manuš tele vlast thaj si man tale mande vojnikurja. Thaj kana phenav jećhešće: ‘Dža!’ vo džaltar. Thaj kana phenav averešće: ‘Av!’ vo avel. Thaj kana phenav mungre robošće: ‘Ćer godova!’ thaj vo ćerel.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Kana godova ašundas, o Isus zadivisajlo lešće, thaj phendas okolenđe save džanas pale leste: “Čače phenav tumenđe, kasavo paćipe či arakhlem ke nijek manuš ando Izrael! ");
INSERT INTO rmyChergash_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","A phenav tumenđe kaj but e manuša avena andar o sasto them, katar o istok thaj katar o zapad thaj avela len than pe bari gozba e Avraameja, e Isakosa thaj e Jakovesa ando Carstvo nebesko, ");
INSERT INTO rmyChergash_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","a but e Izraelcurja savenđe si pripremime e Devlesko carstvo, avena čhudine andar o carstvo, ande majhanduk tunjariko, okote avela o roipe thaj o škripipe e dandenca katar e duk.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Askal o Isus phendas e kapetanošće: “Dža, thaj neka avel tuće sar paćajan.” Thaj o sluga e kapetanesko sastilo ande godova časo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Kana o Isus avilo ande Petresko ćher, arakhlas e Petrešće sokra sar pašljol nasvali ande groznica. ");
INSERT INTO rmyChergash_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","O Isus astarda lat palo vas thaj e groznica mukla lat. A voj uštili thaj počnisarda te služil lešće. ");
INSERT INTO rmyChergash_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Kana peli e rjat, andine ko Isus e but e manušen ande save sas e bilačhe duhurja. Thaj o Isus e alavesa trada sa e bilačhe duhonen andar e manuša thaj e nasvalen sastardas. ");
INSERT INTO rmyChergash_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Gajda pherdilo okova so si phendo kroz o proroko Isaija: “Vo lijas amare slabosti thaj inđarada amaro nasvalipe.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Kana o Isus dikhla e bute theme savo ćida pes oko leste, zapovedisardas pire učenikonenđe te otplovin pe okoja rig e jezerošći. ");
INSERT INTO rmyChergash_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ande godova avilo leste jek katar e učitelja e Mojsiješće zakonestar thaj phendas lešće: “Učiteljina, me džava pale tute kaj god tu te džas.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","A o Isus phendas lešće: “E lisicen si lenđe jazbine thaj e čirikljen lenđe gnezdurja; a man e Čhave e Manušešće naj kaj mungro šoro te čhav.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Phendas lešće jek aver učeniko: “Gospode, muk man majsigo te džav te prahov mungre dade, askal avava thaj slediva tut.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","A o Isus phendas lešće: “Tu av pale mande, a muk e mulen te prahon pire mulen!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","A askal o Isus dija ando čamco, a pale leste dine vi lešće učenikurja. ");
INSERT INTO rmyChergash_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Andar jekhvar po jezero vazda pe gajda bari oluja, kaj e talasurja pherenas o čamco e pajesa. A o Isus sovelas. ");
INSERT INTO rmyChergash_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Lešće učenikurja aviline dži leste, džungadine les thaj phendine: “Gospode, spasisar men kaj tasadosa!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","A o Isus phendas lenđe: “Sostar daran, cara paćivalen?” Askal uštilo thaj zapovedisardas e balvajenđe thaj e jezerošće te ačhen, a e oluja smirisajli thaj postanisardas bari tišina po jezero. ");
INSERT INTO rmyChergash_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","A e manuša, zadivime, phučline: “Ko si akava te e balvaja thaj o more pokorin pe lešće?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","A kana o Isus areslo pe okoja rig e jezerošći, ando gadarinsko krajo, angle leste aviline duj manuša ande save sas e bilačhe duhurja save inkljenas andar e limorja, a sas gaći napasne kaj khonikal či tromalas te naćhel godole dromesa. ");
INSERT INTO rmyChergash_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Von čhutine muj: “So si amen tusa, e Devlešće Čhaveja? Avilan li akate te mučis amen majsigo nego so si e vrjama?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","A majdur lendar čarjonas but e bale. ");
INSERT INTO rmyChergash_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","A e demonurja zamolisardine e Isuse: “Ako trades men, bičhal amen te džas ande okola bale.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","A o Isus phendas lenđe: “Džan”. Thaj e demonurja inkljistine andar e manuša thaj dine ande bale. Pe godova, sa e bale pojurisardine niz o brego ando jezero thaj tasadile ando paj. ");
INSERT INTO rmyChergash_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Pe godova e manuša kaj lenas sama pe bale našline ando gav thaj phendine sa so dikhline thaj so sas e manušenca ande save sas e demonurja. ");
INSERT INTO rmyChergash_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Askal sa e manuša andar godova gav inkljistine anglo Isus, pa kana dikhline les počnisardine te molin les te džaltar andar lengo krajo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Gajda o Isus dija ando čamco, otplovisardas pe okoja rig ande piro gav. ");
INSERT INTO rmyChergash_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Okote andine lešće e line manušes pe nosilja. Kana o Isus dikhla lengo paćipe, phendas e line manušešće: “Na dara čhaveja, jarton pe tuće ćire bezeha!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","A varesave katar e učitelja e Mojsiješće zakonestar phendine ande peste: “Dik akava hulil po Del!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","O Isus džanglas lenđi gindimata thaj phendas lenđe: “Sostar gajda gndin bilačhe ande tumare ile? ");
INSERT INTO rmyChergash_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","So si maj loće te phenel pe: ‘Jartome si tuće ćire bezeha’ ili: ‘Ušti thaj phir’? ");
INSERT INTO rmyChergash_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ali, te džanen kaj man, e Čhaves e Manušešće si vlast pe phuv te jartosarv e bezeha.” Askal phendas e line manušešće: “Ušti, le ćiri nosilja thaj dža tuće ćhere!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Vo uštilo thaj đelotar pire ćherešće. ");
INSERT INTO rmyChergash_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kana godova dikhla o but o them, darajlo thaj ačhilo te slavin e Devle, savo dijas kasavi vlast e manušenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Kana o Isus džalastar okotar, dikhla e manušes savo akhardolas Matej sar bešel po than kaj poćinelas pe o porez. O Isus phendas lešće: “Av pale mande!” O Matej mukla sa, uštilo thaj teljardas pale leste. ");
INSERT INTO rmyChergash_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Dok o Isus sas pale sinija ande Matejesko ćher, avile okote e but carinikurja thaj aver bezahale manuša thaj hanas zajedno lesa thaj lešće učenikonenca. ");
INSERT INTO rmyChergash_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Kana godova dikhline e fariseja, pučline e Isusešće učenikonen: “Sostar tumaro učitelj hal e carenikonenca thaj e bezahalenca?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","A o Isus ašundas godova thaj phendas lenđe: “Či trubun e saste e doktore nego e nasvale. ");
INSERT INTO rmyChergash_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nego, sićon so akava značil: ‘majbut voliv te aven milosrdne, nego te prinosin manđe žrtve.’ Me hav e bezehalenca zato kaj či avilem te akharav e pravednikonen, nego e bezehalen te pokajin pe.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Askal aviline ko Isus e učenikurja katar o Jovano savo bolelas thaj phučline les: “Sostar ćire učenikurja či postin sago amen thaj e fariseja?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","A o Isus phendas lenđe: “Tugujin li e svaturja dok si o džamutro lenca? Nisar! Nego avela o đes kana otmina lendar e džamutre thaj askal vi von postina. ");
INSERT INTO rmyChergash_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Nego, khonik či suvel o nevo kotor pe pharadi haljina sar učhardasas e hv, kaj kana thovela pe e haljina o nevo kotor ćidela pe thaj avela još majbari hv. ");
INSERT INTO rmyChergash_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Niti čhol pe e nevi mol ande purane morćhaće traste, kaj kana e nevi mol dela vras thaj buljola, pharavela e morćhaće traste, a e mol čhordola pe. Nego e nevi mol čhol pe ande neve morćhaće traste, gajda avena arakhade vi e mol vi e morćhaće traste.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Dok o Isus još motholas lenđe, avilo leste jek upravniko e sinagogako, pelo angle leste pe koča thaj phendas lešće: “E čhej mungri muli, ali tu av thaj čho ćo vas pe late thaj voj trajila.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","O Isus uštilo thaj teljardas pale leste pire učenikonenca. ");
INSERT INTO rmyChergash_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","A varesavi manušnji savi sas nasvali dešuduj brš gajda kaj o rat thavdelas latar, avili pale lešće zeja thaj astarda pes e ćoškostar katar lešći haljina. ");
INSERT INTO rmyChergash_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Kaj gndisardas ande peste: “Te astarde man samo palo ćoško katar lešći haljina, avav sasti.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","O Isus bolda pe, dikhla pe late thaj phendas: “Na dara čhejo. Ćiro paćipe sastarda tut.” Thaj e manušnji sastili isto časo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","A kana o Isus avilo ando ćher e upravnikosko, dikhla e pogrebne sviračen thaj e themes sar kućin. ");
INSERT INTO rmyChergash_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","O Isus phendas: “Inkljen avri! Kaj e čhori či muli, nego sovel.” A von asajine lestar. ");
INSERT INTO rmyChergash_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kana o them sas tradino avri, o Isus dija andre thaj astarda e čhora palo vas, thaj e čhori uštili. ");
INSERT INTO rmyChergash_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Thaj o glaso pale akava so dogodisajlo ašundilo po sasto than godole krajosko. ");
INSERT INTO rmyChergash_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Kana o Isus đelotar okotar, teljardine pale leste e duj kore manuša thaj čhonas muj pale leste: “Smilujisar tut amenđe, Čhaveja e Davidosko!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Kana o Isus dija ando ćher e kore manuša avile pale leste, a o Isus phučla len: “Dali paćan kaj šaj te sastarav tumen?” A von phendine lešće: “Ej, Gospode, amen paćas!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Askal čhuta pire vas pe lenđe jakha thaj phendas: “Neka avel tumenđe sar paćan!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Thaj ande godova časo lenđe jakha sastile. A o Isus askal phendas lenđe: “Na phenen khonikašće pale akava.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ali von inkljistine andar o ćher thaj mothonas po sasto godova krajo pale leste. ");
INSERT INTO rmyChergash_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Dok von inkljenas, odma pale godova andine leste e manušes savo sas nemo kaj o bilačho duho sas ande leste. ");
INSERT INTO rmyChergash_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","O Isus trada e bilačhe duho andar o nemo manuš, thaj o nemo manuš odma počnisarda te ćerel svato. E manuša sas zadivime thaj phenenas: “Gajda vareso još či dikhlam ando sasto Izrael!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","A e fariseja phenenas: “Vo tradel e bilačhe duhonen gajda kaj pomognil lešće o poglavica e bilačhe duhonengo.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Gajda o Isus džalas pe sa e bare thaj cikne gava thaj sikavelas e manušen ande lenđe sinagoge, navestilas e Bahtali nevimata pale Devlesko carstvo thaj sastarelas e nasvalen katar svako nasvalipe thaj nemoć. ");
INSERT INTO rmyChergash_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","A kana o Isus dikhla e bute themes, sažalisajlo pe lende, kaj sas iscrpime thaj bespomoćne sago e bakhre bi e pastiresko. ");
INSERT INTO rmyChergash_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Askal phendas pire učenikonenđe: “E žetva si bari, a radnikurja si cara. ");
INSERT INTO rmyChergash_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Zato molin e Gospodare katar žetva te bičhalel e radnikonen ande piri žetva.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","O Isus akhardas peste pire dešuduj učenikonen, thaj dija len vlast pe bilačhe duhurja thaj te sastaren svako vrsta nasvalipe thaj slabost. ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Akava si e alava katar e dešuduj apostolurja: O Simon (saves akharenas Petar), o Andrija (e Petresko phral), o Jakov (e Zevedejevesko čhavo), o Jovano (e Jakovesko phral), ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","o Filip thaj o Vartolomej, o Toma thaj o Matej (o cariniko), o Jakov (e Alfejevesko čhavo) thaj o Tadej, ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","o Simon pobunjeniko thaj o Juda Iskariotski (savo izdaisarda e Isuse). ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","O Isus bičhaldas akale dešudujen thaj zapovedisardas lenđe: “Na džan ke o okola save či pindžaren e Devle thaj na den ande ni jek Samarijansko gav, ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","nego džan samo ko them save si hasarde bakhre e israelošće. ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Džan thaj propovedin lenđe kaj si paše o carstvo nebesko. ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Sastaren e nasvalen thaj okolen saven si guba, vazden e mulen, thaj traden e bilačhe duhonen andar e manuša. Ivija dobisardine, ivija vi den. ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Na steknin tumenđe ni sunakaj, ni rup, ni bakarne lovora ande tumare pošća, ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","niti dromešći trasta niti aver gada niti još jek paro sandale, niti rovlji palo drom, kaj o radniko zaslužil te dobil piri poćin. ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","A kana den ande varesosko gav, roden e manušes savo si dostojno te ačhen ande lesko ćher sa dok či teljaren majdur andar godova gav. ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","A kana den ande godova ćher, phenen: ‘Miro tumenca.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Thaj ako godova ćher kamel te primil tumen, neka tumaro miro avel pe leste. Ali ako o ćher či kamel te primil tumen, neka tumaro miro boldel pe tumenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","A te vareko či primila tumen thaj či čhon kan so phenen lenđe, inkljen andar godova ćher ili godova gav thaj ćhinon o praho katar tumare pungre, te na avel tumen khači lenca. ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Čače phenav tumenđe: Majloće avela e gavenđe e Sodomaće thaj e Gomoraće ando đes e sudosko nego godole gavešće.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","O Isus majdur motholas: “Ake me bičhalav tumen sago e bakhren maškar e ruva. Zato aven mudre sago e sapa, a bezopasne sar e goluburja. ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Len tumen sama, kaj varesave manuša predaina tumen pe sudurja, thaj bičuina tumen ande pire sinagoge. ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Zbog mande inkalena tumen angle vladarja thaj angle carurja, godova avela prilika te svedočin pale mande okolenđe kaj či pindžaren e Devle. ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","A kana predaina tumen, na daran so phenena, kaj ande godova časo dela pes tumenđe so te phenen. ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kaj či ćerena svato tumen, nego o Duho tumare nebesko Dadesko ćerela svato kroz tumende. ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","O phral e phrale predaila te mudaren les, a o dad e čhavres. E čhavra vazdena pes pe pire dada thaj pe pire deja thaj predaina len te aven mudarde. ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Savora mrzana tumen zato kaj sen mungre učenikurja, ali ko god ačhel verno dži ko krajo avela spasime. ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kana progonina tumen ande jek gav, tumen našen ande aver! Čače phenav tumenđe či aresena te završin tumaro poslanje pe sa e izraelske gava majsigo nego so me, o Čhavo e Manušesko, avava. ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Nijek učeniko naj majbaro katar piro učitelj, niti o sluga katar piro gospodari. ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Dovoljno si e učenikošće te avel sago lesko učitelj, a e slugašće te avel sago lesko Gospodari. Ako man e domaćine akharenas Veelzevul – Sotona, kozom askal bišukar alavenca akharena tumen mungre ćherutnen?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","O Isus majdur phendas: “Zato na daran katar okola save pretin tumenđe kaj sa so si garado dićhola thaj sa so si tajno ašundola. ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Okova so phenav tumenđe ande tama, tumen phenen po svetlo thaj okova so phenel pe tumenđe po kan objavin katar e krovurja. ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Na daran katar okola save šaj te mudaren samo o telo, a našti mudaren e duša. Nego, daran katar okova savo šaj te uništil o telo thaj e duša ando pakao. ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Či li bićinen pe duj vrapcurja pale jek kovano lovoro? A ni jek lendar či perel pe phuv, a te pale godova tumaro nebesko Dad či džanel. ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","A tumenđe si vi sa e bal po šoro đinade. ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Zato na daran! Kaj tumen vredin majbut katar e but e vrapcurja. ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Dakle ko god priznail angle manuša kaj si mungro učeniko, priznaiva vi me les angle mungro Dad nebesko. ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","A ko god odreknil pes mandar anglo them, vi me odrekniva man lestar angle mungro Dad nebesko.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","O Isus nastavisarda te mothol: “Na gndin kaj avilem pe phuv te anav miro. Či avile te anav miro, nego o mačo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Avilem te odvojiv ‘e manuše katar lesko dad, e čheja katar laći dej, thaj e borja katar laći sokra. ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","E manušešće dušmaja avena okola save trajin lesa ando ćher.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ko volil pire dades ili pire deja majbut nego man, naj dostojno te avel mungro učeniko. Ko volil pire čhaves ili pire čheja majbut nego man, naj dostojno te avel mungro učeniko. ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ko či lel piro trušul thaj či džal pale mande, naj dostojno te avel mungro učeniko. ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ko kamel te zaštitil pesko trajo hasarela les, a ko hasarel piro trajo zbog mande zaštitila les.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ko tumen primil, man primil, a ko primil man primil e Devles savo bičhalda man. ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ko primil e proroko zato kaj si proroko, primila e proročko nagrada, a ko primil e pravedniko, zato kaj si pravedniko, dobila pravedničko nagrada. ");
INSERT INTO rmyChergash_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Thaj ko napoil jećhe katar akala majcikne vi samo tahtaj šudre pajesa, zato kaj si mungro učeniko, čače phenav tumenđe lešći poćin či propadnila.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Kana o Isus završisarda te del e upute pire dešuduje učenikonenđe, đelotar okotar te sikavel e theme thaj te propovedil pe galilejske gava. ");
INSERT INTO rmyChergash_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","A o Jovano savo bolelas ašundas ande tamnica pale čudurja save ćerelas o Hristo, pa bičhaldas pire učenikonen ");
INSERT INTO rmyChergash_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","te phučen e Isuse: “Dali san tu okova saves o Del obećisarda kaj bičhalela ili te ažućaras avres?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Askal o Isus phendas lenđe: “Džan thaj phenen e Jovanošće so ašunen thaj so dićhen kaj ćerav: ");
INSERT INTO rmyChergash_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","E kore dićhen, e banđe phiren, e gubavcurja saston, e kašuće ašunen, e mule bolden pe ando trajo, a e čorenđe propovedil pe e Bahtali nevimata. ");
INSERT INTO rmyChergash_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Thaj blago okolešće savo či sablaznil pe zbog mande.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Kana e Jovanošće učenikurja đeletar, o Isus počnisarda te mothol e themešće palo Jovano: “So đeline te dićhen ande pustinja? E trska savja ljuljil e balval? Na! ");
INSERT INTO rmyChergash_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ili so đeline te dićhen? E manušes savo lija pe peste šukar drze? Na! Okola save inđaren pe peste šukar drze bešen pe carenđe dvorurja. ");
INSERT INTO rmyChergash_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ili so đeline te dićen? E Devlešće prorokos? Ej, me phenav tumenđe, vo si vi majbut katar o proroko! ");
INSERT INTO rmyChergash_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","O Jovano si okova pale savo si ramome ando Sveto lil: ‘Ake, me bičhalav angle tute mungre glasnikones thaj vo lačharela o drom angle tute.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Čače phenav tumenđe: katar sa e manuša save sas ikada bijande, khonik naj majbaro katar o Jovano savo bolelas, a okova savo si majcikno ando Carstvo nebesko majbaro si lestar. ");
INSERT INTO rmyChergash_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Katar e vrjama e Jovanošći savo bolelas dži akana o Carstvo nebesko trpil nasilje thaj e nasilne manuša grabin pe pale leste. ");
INSERT INTO rmyChergash_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kaj sa e prorokurja thaj o Mojsijesko zakon prorokuinas palo Carstvo sa dok či avilo Jovano. ");
INSERT INTO rmyChergash_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","A o Jovano si, ako kamen godova te prihvatin, o Ilija savo trubujas te avel. ");
INSERT INTO rmyChergash_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ašunen kana već si tumen kan! ");
INSERT INTO rmyChergash_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","A kasa te usporediv akava naraštaj? Slično si e čhavrenđe save bešen po trgo, thaj čhon muj jek averešće: ");
INSERT INTO rmyChergash_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Svirosardam tumenđe veselo, a tumen či ćheldine, đilabadam tumenđe tužno, a tumen či rujine.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Kaj o Jovano avilo thaj či halas niti pijelas šukar habe sago e aver manuša, a von phenen: ‘Ande leste si o bilačho duho.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Avilem me, o Čhavo e Manušesko, savo hav thaj pijav šukar habe, a von phenen: ‘Dik e manušes savo but hal thaj pijel, thaj drugari si e carenikonengo thaj e bezehalengo!’ Okola save prihvatin e Devlešći mudrost sikaven kaj si voj ispravno.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Askal o Isus lijas te koril e manušen andar e gava ande save sas majbut lešće čudurja kaj či pokajisajle. ");
INSERT INTO rmyChergash_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Teško tumenđe manušalen andar o Horazin! Teško tumenđe andar e Vitsaida! Kaj te ando Tiro thaj Sidono avilesas e čudurja save dogodisajle ande tumende, von već dumut linesas pe peste e drze katar o kostret thaj čhutine sas o praho pe pire šore sar sikadinesas kaj pokajisajle! ");
INSERT INTO rmyChergash_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ali phenav tumenđe: Kaj po đes e sudosko avela majloće e gavenđe, e Tirošće thaj e Sidonešće nego tumenđe! ");
INSERT INTO rmyChergash_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","A tumen andar o Kafarnaum, zar dži ko nebo vazdena tumen? Perena dži ko than e mulengo. Kaj te ande Sodoma avilesas e čudurja save sas maškar tumende, von pokajisajle sas thaj e Sodoma dži ađes ačhili sas. ");
INSERT INTO rmyChergash_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ali phenav tumenđe kaj avela majloće e Sodomaće ando đes e sudosko nego tumenđe.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Askal o Isus phendas: “Hvaliv tut Dade, Gospodarina e nebesko thaj e phuvjako, kaj garadan akava katar e mudre thaj katar e umne, a sikadan okolenđe save si sago ciknen čhavra. ");
INSERT INTO rmyChergash_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ej, Dade, kaj gajda sas ćiri volja te avel. ");
INSERT INTO rmyChergash_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Mungro Dad sa predaisarda manđe. Khonik osim o Dad či pindžarel e Čhaves. Thaj khonik či pindžarel e Dades, samo o Čhavo thaj okola savenđe o Čhavo kamel te objavil les. ");
INSERT INTO rmyChergash_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Aven mande savora save sen umorne thaj opteretime thaj me odmoriva tumen. ");
INSERT INTO rmyChergash_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Len mungro jarmo pe tumende, thaj sićon mandar, kaj me sem krotko thaj ponizno ilesko, thaj araćhena o miro pale tumare duše. ");
INSERT INTO rmyChergash_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kaj mungro jarmo si blago thaj mungro pharipe si loko.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ande godoja vrjama, ande jek savato o Isus naćhelas maškar e njive e đivesa. A lešće učenikurja bokhajle, thaj počnisardine te trgon e klasurja thaj te han. ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Kana godova dikhline e fariseja, phendine e Isusešće: “Dik ćire učenikurja ćeren savatone, okova so po zakono naj muklo te ćerel pe savatone.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","A o Isus phendas lenđe: “Sigurno čitosardine ando Sveto lil so o David ćerda, kana vo thaj okola save sas lesa bokhajle a nas len so te han. ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Dijas ande Devlesko ćher thaj halas e svete mangre, vi, ako ni vo ni okola save džanas pale leste či tromanas te han lendar, nego samo e rašaja. ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Sigurno čitosardine ando zakono kaj vi e rašaja ando Hramo kršin o zakon gajda kaj ćeren bući savatone, a ipak najlen doš? ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","A me phenav tumenđe kaj akate si vareko majbaro katar o Hramo! ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kana džangline sas so značil: ‘Majbut voliv te aven milosrdne, nego te prinosin manđe žrtve’, či osudisardinesas okolen save naj došale. ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kaj me, o Čhavo e Manušesko, gospodari sem e savatosko.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Askal o Isus đelotar okotar thaj dijas ande lenđi sinagoga. ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","A okote sas jek manuš e šuće vastesa. A e fariseja rodenas razlog te optužin e Isuse, zato phučline les: “Dali si muklo te sastarel pe savatone?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","A o Isus phendas lenđe: “Ko tumendar či lijasas te inkalel pire jećhe bakhres te savatone pelo ande hv? ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","A kozom si o manuš majvredno katar o bakhro! Zato savatone si muklo te ćerel pe lačhipe.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Askal o Isus phendas godole manušešće: “Inzar ćo vas!” Thaj vo inzardas pesko vas, a lesko vas sastilo thaj postanisardas sasto sago vi okova aver. ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","A e fariseja čim inkljistine andar e sinagoga, dogovorisajle sar te mudaren e Isuse. ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","A o Isus doznaisardas pale godova thaj đelotar okotar. A pale leste teljardas o but o them thaj vo sa e nasvalen sastarda ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","thaj upozorilas len te na mothon khonikašće ko si vo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Akava sas te pherdol okova so si phendo kroz o proroko Isaija: ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ake mungro sluga, saves losardem. Mungro volime, o miljeniko mungre dušako. Pe leste čhava mungro Duho thaj vo e themenđe objavila e pravda. ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Či prepirilape niti čhola muj, lesko glaso či ašundola pe sokača. ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ni e banđardi trska či phađela, niti mudarela o stenko savo tek tinjal, sa dok e pravda či anel dži ke pobeda. ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ande lesko alav pouzdinape e thema.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Askal andine anglo Isus jećhe manuše ande savo sas o bilačho duho, a sas godova manuš koro thaj nemo. O Isus sastardas les, thaj o nemo manuš šaj dićhelas thaj šaj ćerelas svato. ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","A sa o them sas zurale zadivime thaj phenelas: “Te naj akava o Čhavo e Davidesko?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kana ašundine pale godova e fariseja, phendine: “Akava tradel e bilačhe duhonen gajda kaj pomožil les o Veelzevul knezo e bilačhe duhonengo.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","A o Isus džanglas so gndin thaj phendas lenđe: “Svako carstvo savo si ande peste podelime propadnila thaj svako gav ili ćher savo si ande peste podelime či ačhela. ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ako o Satana izgonil e Satanes, askal si vo protiv peste razdelime. Sar askal šaj te ačhel lesko carstvo? ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Thaj ako me tradav e bilačhe duhonen gajda kaj pomožil man o Veelzevul, uz kašći pomoć traden len tumare sledbenikurja? Zato von dokažina kaj naj sen ando pravo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ali, ako me e Devlešće Duhosa tradav e bilačhe duhonen, askal avilo tumenđe e Devlesko carstvo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ili, sar šaj vareko te del ando ćher e zurale manušesko te čorel lešći imovina, a te či majsigo phandel les? Tek askal šaj čorel sa andar o ćher. ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ko naj manca, protiv mande si. Thaj ko či ćidel manca rspil. ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Zato phenav tumenđe: E manušenđe šaj avela jartome svako bezeh thaj e hula ali e hula po Sveto Duho či jartola pe. ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ako vareko vareso phenel protiv o Čhavo e Manušesko, šaj avela jartome lešće, a ako vareko vareso phenel protiv o Sveto Duho, či jartola pe lešće ni ande akaja vrjama niti ande vrjama savi avel. ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Uzgojin o lačho kaš, thaj vi lesko plodo avela lačho, ili uzgojin o bilačho kaš thaj vi lesko plodo avela bi lačho, kaj o kaš pindžarel pes pe lešće plodurja. ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Tumen e sapešće čhavra! Sar šaj tumen te phenen so si lačhe, kana sen vi korkoro bilačhe? Kaj o muj phenel okova sova si pherdo o ilo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","O lačho manuš andar e lačhi riznica pire ilešći inkalel lačhipe, a o bilačho manuš andar e bilačhi riznica pire ilešći inkalel bilačhipe. Kaj andar o muj inkljel sova si pherdo o ilo ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","A me phenav tumenđe kaj e manuša pale svako beskorisno alav savo phenen avena odgovorne ando đes e bare sudosko. ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kaj, ćire alava opravdina tut ili osudina tut.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Askal phendnine e Isusešće varesave učitelja e Mojsiješće zakonestar thaj e fariseja: “Učiteljina, kamlamas te sikaves amenđe varesavo znako.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","A o Isus phendas lenđe: “Samo o bilačho thaj o neverno naraštaj rodel znako, ali či dela pe lešće aver znako osim o znako savo dogodisajlo e prorokošće Jonašće. ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Sago kaj ‘o Jona sas trin đesa thaj trin raća ando đi e bare mačhesko’, gajda vi me, o Čhavo e Manušesko, avava ando đi e phuvjako trin đes thaj trin raća. ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","E manuša andar e Niniva uštena po sudo akale naraštajesa, thaj osudina les, kaj von pokajisajle pe Jonašći propoved, a tumen či pokaisardine tumen. A tumenca si akate vareko majbaro vi katar o Jona! ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","E carica katar o jugo uštela po sudo akale naraštajesa, thaj osudila les, kaj avili dadural te ašunel e Solomonešći mudrost, a tumenca si akate vareko majbaro vi katar o Solomon.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","O Isus majdur phendas: “Kana o bilačho duho inkljel andar o manuš, lutil e pustinjasa thaj rodel than kaj šaj te odmoril pe, ali či araćhel les. ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Askal phenel: ‘Boldava man ande mungro ćher andar savo inkljistem.’ Kana boldel pe ande piro ćher andar savo inkljisto, araćhel o ćher čučo, šilado thaj čisto. ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Askal džal thaj anel efta duhurja majgore pestar, thaj savora von den ando manuš thaj nastanin pes ande leste, thaj gajda po krajo godole manušešće si majgore nego so sas lešće majsigo. Gajda avela vi akale bilačhe naraštaješće.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Dok o Isus još ćerelas svato e themešće, aresline thaj ačhiline avri lešći dej thaj lešće phral thaj kamenas te ćeren svato lesa. ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Vareko phendas lešće: “Ake, ćiri dej thaj ćire phral ačhen avri. Kamen te ćeren tusa svato.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","A o Isus phendas lešće: “Ko si mungri dej? Thaj ko si mungre phral?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Askal sikadas karingal pire učenikurja, thaj phendas: “Ake mungri dej thaj mungre phral! ");
INSERT INTO rmyChergash_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kaj phenav tumenđe, ko god ćerel e volja mungre nebesko Dadešći, godova si mungro phral, phen thaj mungri dej!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Isto godova đes o Isus inkljisto andar o ćher, đelo thaj bešlo pašo jezero te sikavel. ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Oko leste ćida pe gaći but them, gajda kaj vo moraš te dijas ando čamco thaj bešlo, a sa o them ačhelas pe obala. ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","But godova phenelas lenđe ande paramiče sago kaj si akaja: “Jek đes inkljisto o sejači te sejol. ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Dok sejolas, varesavo seme pelo po drom thaj avile e čiriklja thaj sa haline les. ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Aver seme pelo pe barutni phuv kaj nas but phuv thaj odma inkljisto kaj e phuv nas handuk. ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ali kana inkljisto o baro kham, phabilo thaj šućilo kaj nas les handuk koreno. ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Varesavo seme pelo maškar e kangre. E kangre barile thaj tasadine les. ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","A varesavo seme pelo pe lačhi phuv, thaj bijandas šel drom majbut, šovardeš drom majbut, ili trijanda drom majbut. ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ašunen, kana već si tumen kan!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","E Isuseše učenikurja avile dži leste thaj phučline les: “Sostar mothos e themešće ande paramiče?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","A vo phendas lenđe: “Tumenđe si dino te džanen e tajne e nebesko Carstvošće, a lenđe naj dino. ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kaj, kas si džanglipe, dela pe lešće thaj avela les još majbut, a kas naj, lela pe lestar vi okova cara so si les. ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Zato phenav lenđe ande paramiče, kaj dićhen so ćerav, a phandaven e jakha te na dićhen, čhon kan so phenav lenđe, a či ašunen thaj či haćaren. ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Gajda pherdol pe lende e Isaijasko proročanstvo: ‘Ašunena mungre alava, a či haćarena; pire jakhenca dićhena mungre dela, a našti dićhena len. ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kaj barosajle e ile akale themešće, pire kanenca jedva ašunen, pire jakha phandadine; te e jakhenca či dićen, te e kanenca či ašunen, te e ileja či haćaren thaj te obratin pe, te sastarav len.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ali blago tumare jakhenđe kaj dićhen, thaj blago tumare kanenđe kaj ašunen. ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Kaj čače phenav tumenđe: e but prorokurja thaj e pravednikurja zurale kamline te dićhen so tumen dićhen, a či dikhline thaj te ašunen so tumen ašunen, ali či ašundine.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","O Isus majdur phendas: “Ašunen so značil e paramiči palo sejači. ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Svakonešće savo ašunel o alav pale Devlesko carstvo, a či haćarel, avel o beng thaj čorel so si posadime ande lesko ilo. Godova si okova seme savo si posadime po drom. ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","O seme savo si posadime po barutno than, si okova savo ašunel e Devlesko alav thaj odma e bahtasa prihvatil les, ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ali sar e Devlesko alav či mukla koreno ande leste, či ačhel dugo. Kana avel e nevolja thaj o progonstvo zbog o alav e Devlesko, vo odma otpadnil. ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","O seme savo si posadime ande kangre, si okova savo ašunel o alav e Devlesko, ali e brige akale trajošće thaj o hohavno barvalipe tasaven o alav thaj ačhel bi plodosko. ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","A okova seme kaj si posadime pe lačhi phuv, godova si okova savo ašunel o alav, haćarel thaj čače anel plodo, šel drom majbut, šovardeš drom majbut ili trijanda drom majbut.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Askal o Isus phendas lenđe vi aver paramiči: “O Carstvo nebesko si sago o manuš savo posadisardas o lačho seme ande piri njiva. ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ali dok savora sovenas, avilo lesko dušmano thaj posadisardas o kukolji maškar o điv thaj đelotar. ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","A kana o seme barilo thaj anda plodo, askal sikadilo vi o kukolj. ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Askal aviline e sluge ko domaćino thaj phendine lešće: ‘Gospodarina! Zar tu či posadisardan o lačho seme pe ćiri njiva? Katar askal o kukolj?’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","A vo phendas lenđe: ‘O dušmano ćerda godova.’ A e sluge phučline les: ‘Kames te džas thaj te inkalas o kukolj?’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","A o domaćino phendas lenđe: ‘Na, kaj te akana inkaldine o kukolji inkalena vi o điv. ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mućen te liduj barjon dži ke žetva, thaj ande vrjama e žetvaći phenava okolenđe save ćiden o điv: Majsigo inkalen o kukolj, thaj phanden le ande snopurja te del pe jag, a o điv ćiden thaj čhon les ande mungro skladište.’” ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","O Isus phendas lenđe vi aver paramiči: “O Carstvo nebesko si slično sago e gorušicako semeno savo o manuš posardisarda ande piri njiva. ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Vi ako si majcikno katar sa o seme, kana barjol avel majbaro katar svako povrće. Barjol thaj avel kaš, thaj e čiriklja aven thaj gnezdin pes maškar lešće ranja.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Askal o Isus phendas lenđe aver paramiči: “O Carstvo nebesko si sago o kvasco savo lel e manušnji thaj šukljarel les ande biš kile aro, dok sa či vazdel pe.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","O Isus sa godova phendas e themešće ande paramiča. Thaj khanči či phenelas lenđe bi e paramičengo: ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Gajda pherdilo o proročanstvo savo phenel: “Ande paramiči phenava thaj objaviva okova so si garado katar o postanko e themesko.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","O Isus mukla e but e themes te džaltar thaj dijas ando ćher. E učenikurja aviline leste thaj phendine lešće: “Objasnisar amenđe e paramiči palo kukolj pe njiva.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","A vo phendas lenđe: “Okova kaj posadisardas o lačho seme si o Čhavo e Manušesko, ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","a e njiva si o them. O lačho seme si e manuša save pripadin e nebesko Carstvošće, a o kukolji si e manuša e benđešće. ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","O dušmano savo posadisardas o seme si o beng; e žetva si o krajo e themesko, a okola save ćiden o điv si e anđelurja. ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Sago kaj o kukolji ćidel pe ande snopurja, thaj del pe jag, gajda avela vi po krajo e themesko. ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","A me, o Čhavo e Manušesko, bičhalava mungre anđelen, te izdvoin andar mungro Carstvo savoren save crden avren po bezeh thaj savoren save ćeren bilačhipe. ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Thaj e anđelurja čhudena len ando jagalo bov, okote avela roipe thaj škripipe e dandenca katar e duk. ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Askal e pravednikurja sago o kham zasijina ando Carstvo pire Dadesko. Ašunen, kana već si tumen kan!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“E nebesko Carstvosa si sago e garade barvalipeja ande njiva. Kana o manuš araćhel les, garavel les okote thaj pherdo bah džal thaj bićinel sa so si les thaj ćinel godoja njiva.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Još o Carstvo nebesko si slično sago o trgovco savo rodel šukar biserja. ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Pa kana araćhel zurale kuč biseri, džal thaj bićinel sa so si les, te ćinel les. ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Još o Carstvo nebesko si slično sago vi e mreža savi si čhudini ando more ande savi astardile e svakovrsne mačhe. ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kana e mreža pherdol e mačhenca, crden lat avri pe obala. Askal e ribarja bešen thaj losaren e lačhe mačhe thaj čhon len ande kante, a e bilačhe mačhen čhuden. ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Gajda avela po krajo e themesko: avena e anđelurja thaj odvoina e bilačhen katar e pravedne ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","thaj e bilačhen čhudena ando užarime bov, okote avela roipe thaj škripipe e dandenca katar e duk. ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","O Isus phučla len: “Dali haćardine sa akava?” A von phendine: “Haćardam.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","O Isus phendas lenđe: “Zato si svako učitelj e Mojsiješće zakonestar savo si sikado palo Carstvo nebesko slično sago o domaćino savo andar piri riznica inkalel o nevo thaj vi o purano blago.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Kana o Isus završisarda akala paramiče, đelotar okotar. ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Thaj dijas ando piro gav kaj barilo. Thaj sikavelas okote e theme ande lenđe sinagoge, a von zadivime phenenas: “Katar akales kasavi mudrost thaj moć? ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Naj li akava e tesaresko čhavo? Či li bučhol lešći dej Marija, a lešće phrala o Jakov, Josif, Simon, thaj o Juda? ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Thaj zar naj sa lešće pheja akate maškar amende? Katar les askal sa akava?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Thaj odbisardine te paćan ande leste. A o Isus phendas lenđe: “O proroko si svugde poštujime osim ande piro gav thaj ande piro ćher.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Zbog lengo bipaćipe okote či ćerda but e čudurja. ");
INSERT INTO rmyChergash_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ande godoja vrjama o Irod, savo sas vladari ande Galileja, ašundas o glaso palo Isus. ");
INSERT INTO rmyChergash_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Askal phendas pire slugenđe: “Godova si o Jovano savo bolelas. Vo uštilo andar e mule, thaj zato ćerel čudurja.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","A o Irod godova phendas zato kaj majsigo astardas e Jovane, phangla les, thaj čhuda les ande tamnica zato kaj lijas e Irodijada savi sas romnji lešće phralešći e Filipešći. ");
INSERT INTO rmyChergash_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","A o Jovano stalno motholas e Irodešće: “Tut naj pravo te les lat romnjaće!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Zbog godova o Irod kamlas te mudarel les, ali darajlo katar o them, kaj o them smatrilas e Jovane kaj si proroko. ");
INSERT INTO rmyChergash_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ali kana sas e Irodesko bijando đes, e Irodijaći čhej teljarda te ćhelel angle savorende. E Irodešće godova zurale sviđosajlo, ");
INSERT INTO rmyChergash_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","zato halas laće solah kaj dela lat sa so rodela lestar. ");
INSERT INTO rmyChergash_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","A voj sikadi katar pešći dej phendas: “Deman akate po tijari o šoro e Jovanesko savo bolelas!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","O caro Irod ražalostisajlo, ali zbog godova kaj či kamlas te prekršil e solah angle manuša save sas okote, zapovedisardas te den lat. ");
INSERT INTO rmyChergash_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Thaj bičhaldas e manušen ande tamnica te čhinen tele e Jovanesko šoro. ");
INSERT INTO rmyChergash_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","E manuša askal andine e Jovanesko šoro po tijari thaj dine les e Irodijaće čhejaće, a voj inđarda les pire dejaće. ");
INSERT INTO rmyChergash_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Askal e Jovanešće učenikurja aviline, line e Jovanesko telo thaj prahosardine les. Askal đele thaj mothodine e Isusešće so sas. ");
INSERT INTO rmyChergash_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Kana o Isus ašundas godova, dijas ando čamco thaj đelotar okotar po pusto than te avel korkoro. Ali kana godova ašundas o them teljardine phujatar pale leste andar pire gava. ");
INSERT INTO rmyChergash_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Kana o Isus inkljisto andar o čamco, dikhla e bute theme, sažalisajlo pe lende thaj sastardas lenđe nasvalen. ");
INSERT INTO rmyChergash_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Kana peli e rjat avile leste lešće učenikurja thaj phendine lešće: “Akava si pusto krajo, a već si kasno. Muk e theme te džal pe okolne gava te ćinen pešće vareso te han!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","A o Isus phendas lenđe: “Či trubun te džan. Tumen den len te han.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Von phendine lešće: “Amen naj akate khanči aver osim pandž mangre thaj duj mačhe!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","A o Isus phendas: “Anen godova mande.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Askal zapovedisardas e themešće te bešel pe čar. Lijas e pandž mangre thaj e duj mačhe, dikhla prema o nebo thaj zahvalisarda e Devlešće palo habe. Phaglas o mangro thaj dija pire učenikonenđe, a e učenikurja e manušenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Thaj savora haline thaj čaljile. A e učenikurja ćidine još dešuduj pherde korpe katar e kotora save ačhiline. ");
INSERT INTO rmyChergash_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","A okola save haline sas pandž milja muškarcurja, a nas đinade e manušnja thaj e čhavra save sas lenca. ");
INSERT INTO rmyChergash_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Odma posle godova o Isus zapovedisardas pire učenikonenđe te den ando čamco thaj te džan angle leste pe okoja rig, dok vo či mućel e theme te džantar. ");
INSERT INTO rmyChergash_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nakon so mukla e themes te džantar, lija pe opre pe gora, korkoro te molil pe. Kana peli e rjat, vo sas još okote korkoro. ");
INSERT INTO rmyChergash_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","A o čamco ande savo sas e učenikurja sas već dur katar e obala, mardo katar e talasurja kaj plovilas suprotno katar e balval. ");
INSERT INTO rmyChergash_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","A varekaj katar e trin dži ke šov saturja detharinako, o Isus avilo dži ke učenikurja gajda kaj phirelas po paj ando jezero. ");
INSERT INTO rmyChergash_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Kana e učenikurja dikhline e Isuse sar phirel po paj karingal lende, e darasa čhutine muj: “Godova si o duho!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","O Isus odma phendas lenđe: “Na daran! Me sem!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","A o Petar phendas lešće: “Gospode, ako san tu, zapovedisar te avav tute po paj!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","A o Isus phendas lešće: “Av!” O Petar inkljisto andar o čamco thaj počnisarda te phirel po paj karingal o Isus. ");
INSERT INTO rmyChergash_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ali kana dikhla kozom si zurali e balval, darajlo thaj teljarda te tonil thaj čhol muj: “Gospode, spasisar man kaj tasadova!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","O Isus odma inzarda piro vas, astarda les thaj phendas: “O manušeja cikne paćimava, sostar posumnjisardan?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Kana line pe opre ando čamco, e balval ačhili. ");
INSERT INTO rmyChergash_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","A e učenikurja save sas ando čamco peline pe koča angle leste thaj phendine: “Tu san čače o Čhavo e Devlesko!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","A o Isus thaj lešće učenikurja preplovisardine o jezero, thaj aresline po kopno ando Genisaret. ");
INSERT INTO rmyChergash_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Thaj e manuša andar godova than pindžardine e Isuse, razglasisardine godova pe sasto krajo kaj avilo thaj andine leste sa e nasvalen. ");
INSERT INTO rmyChergash_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Molisardine e Isuse te mućel len te astaren pe samo palo ćoško katar lešći haljina. Thaj savora save dotaknisardine les potpuno sastile. ");
INSERT INTO rmyChergash_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Askal ko Isus aviline varesave fariseja thaj e učitelja e Mojsiješće zakonestar andar o Jerusalim thaj phučline les: ");
INSERT INTO rmyChergash_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Sostar ćire učenikurja phađen e purane židovske običaja? Či inćaren o obred te thoven pire vas majsigo nego so len te han.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","A o Isus phendas lenđe: “A sostar tumen phađen e Devlešći zapovest zbog tumare običaja? ");
INSERT INTO rmyChergash_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kaj o Del zapovedisardas: ‘Poštuisar ćire dade thaj ćire deja’ thaj: ‘ko del romaja pire dade thaj pire deja, neka avel kaznime po smrto.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","A tumen phenen: ‘Ako vareko phenel pire dadešće ili pire dejaće: našti pomoživ tut kaj halem solah kaj dava e Devlešće okova so dijemas tuće.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Gajda tumen phenen kaj či trubun te poštujin tumare dade thaj tumare deja zato kaj či vodin briga pale lenđe potrebe. Gajda zanemarin e Devlešće zapovesti zbog tumari predaja. ");
INSERT INTO rmyChergash_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Licemerja! Lačhe pale tumende prorokuisardas o Isaija kana phendas: ");
INSERT INTO rmyChergash_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Akava them poštuil man samo e mujesa, ali lengo ilo si dur mandar. ");
INSERT INTO rmyChergash_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Uzalud poštuin man kaj sago mungro sikavipe sikaven e manušenđe zapovesti.’” ");
INSERT INTO rmyChergash_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","O Isus akhardas e but e themes thaj phendas lenđe: “Čhon kan thaj probin te haćaren! ");
INSERT INTO rmyChergash_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Či meljarel e manušes okova so del ande manušesko muj, već okova so inkljel andar o muj meljarel e manuše anglo Del.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Askal aviline leste e učenikurja thaj phučline les: “Dali džanes kaj e fariseja uvredisajle pe okova so phendan?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","A vo phendas lenđe: “Svako biljka savi či zasadisardas mungro nebesko Dad, inkalela pe e korenosa andar e phuv. ");
INSERT INTO rmyChergash_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mućen len! Von si kore vođe e korenđe! A kana o koro vodil e kores, liduj peren ande hv.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","A o Petar phendas lešće: “Phen amenđe so značil okova so phendan kaj meljarel e manuše anglo Del.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","A o Isus phučla len: “Zar tumen još či haćaren? ");
INSERT INTO rmyChergash_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Či li haćaren: kaj sa so del ando muj džal ando đi, thaj inkljel avri. ");
INSERT INTO rmyChergash_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ali e bilačhe alava inkljen andar o ilo thaj meljarel e manušes anglo Del. ");
INSERT INTO rmyChergash_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kaj andar o ilo inkljen e bilačhe gndurja, mudaripe, preljub, bludo, čoripe, hohamno svedočanstvo thaj uvrede. ");
INSERT INTO rmyChergash_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Akava meljarel e manušes! Či avela o manuš duhovno melalo anglo Del, ako hal, a te majsigo či obredno thoda pire vas.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Askal o Isus đelotar okote thaj crda pe andar e Galileja po sever, ando tirsko thaj sidonsko krajo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","A jek manušnji, Hanaanejka andar godova krajo, avili dži leste thaj teljarda te čhol muj: “Smiluisar tut manđe Gospode, Čhaveja e Davidesko! Kaj mungri čhej zurale patil pe, zato kaj si ande late o bilačho duho!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ali o Isus khanči či phendas laće, pa lešće učenikurja aviline đi leste thaj počnisardine te molin les: “Phen laće te džaltar kaj čhol muj pale amende!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","A vo phendas lenđe: “Bičhaldo sem samo te pomogniv e Izraelošće themešće save si sago e hasarde bakhre.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","A voj avili thaj peli pe koča angle leste thaj phendas: “Gospode, pomožisar manđe!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","A vo phendas laće: “Naj lačhe te lel pe o mangro e čhavrendar thaj te čhudel pe e džućhelenđe.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","A voj phendas: “Ej, Gospode, kaj čak vi e džućhela han e prušuka save peren katar e sinija lenđe gospodarenđe!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Askal phendas laće o Isus: “Baro si ćiro paćipe, manušnjije! Neka avel tuće sago kaj kames!” Thaj ando isto časo sastili laći čhej. ");
INSERT INTO rmyChergash_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Askal o Isus đelotar okotar dži ko Galilejsko jezero, lija pes pe gora thaj bešlo te sikavel. ");
INSERT INTO rmyChergash_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","A leste avilo o but o them thaj pesa andine e banđen, e koren, e sakaten, e mutaven thaj e but avren saven sas razne nasvalimate thaj siđardine te čhon len angle Isusešće pungre, a vo sastarda len, ");
INSERT INTO rmyChergash_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","gajda kaj o them zadivisajlo, kana dikhline okolen kaj našti ćerenas svato sar ćeren svato, e sakaten sar si saste, e banđen sar phiren, e koren sar dićhen thaj o but o them hvalilas e Izraelošće Devle. ");
INSERT INTO rmyChergash_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","A o Isus akhardas pire učenikonen thaj phendas lenđe: “Žao manđe e themestar, kaj si već trin đes manca, a najlen so te han. Či kamav te mukav len bokhale te džantar te na malaksin e dromesa.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","A e učenikurja phendine lešće: “Kaj ande akaja pustinja te arakhas dosta mangro te pravaras gadići themes?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","A o Isus phučla len: “Kozom mangre si tumen?” A von phendine: “Efta mangre thaj cara mačhe.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Askal o Isus zapovedisardas e themešće te bešen pe phuv. ");
INSERT INTO rmyChergash_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Thaj lijas e efta mangre thaj e mačhen, zahvalisarda e Devlešće, phaglas e mangre thaj dija pire učenikonenđe, a e učenikurja dine e themešće. ");
INSERT INTO rmyChergash_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Savora haline thaj čaljile; thaj katar e kotora save ačhiline lenđe pherdine još efta bare korpe. ");
INSERT INTO rmyChergash_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","A okola save haline sas štar milje muškarcurja thaj još vi manušnja thaj čhavra save nas đinade. ");
INSERT INTO rmyChergash_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Kana o Isus mukla e theme te džaltar, bešlo ando čamco thaj avilo ande Magadansko krajo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ko Isus aviline e fariseja thaj e sadukeja e gindosa te iskušin les thaj manđenas lestar te sikavel lenđe o znako andar o nebo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","A vo phendas lenđe: “Kana perel e rjat, phenen: ‘Avela lačhi vrjama kaj si o nebo lolo.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","A detharinako phenen: ‘Ađes avela nevreme kaj si o nebo lolo thaj mutno.’ Džanen te tumačin e nebesko izgled, a či džanen te pindžaren e znakurja e vrjamaće ande save trajin. ");
INSERT INTO rmyChergash_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Samo o bilačho thaj bi paćivalo naraštaj rodel znako, ali či dela pe lešće aver znako osim o znako savo dogodijsajlo e prorokošće Jonašće. Askal o Isus mukla len thaj đelotar.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","E Isusešće učenikurja teljardine pe okoja rig e jezerošći, ali bistardine te len pesa o mangro. ");
INSERT INTO rmyChergash_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","A o Isus phendas lenđe: “Len tumen sama katar e farisejengo thaj e sadukejengo kvasco!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","A von počnisardine te raspravin pe maškar peste, thaj phendine: “Godova sigurno phendas zato kaj či lijam o mangro.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","O Isus džangla so ćeren svato thaj phendas: “Manušalen cikne paćimava! Sostar raspravin tumen maškar tumende kaj naj tumen mangro? ");
INSERT INTO rmyChergash_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Zar još uvek či haćaren? Zar či den tumen gođi ke okola pandž mangre pale pandž milje manuša thaj kozom pherde korpe ćidine kotora save ačhile? ");
INSERT INTO rmyChergash_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Thaj či den tumen gođi ke efta mangre pale štar milje manuša thaj kozom bare korpe ćidine kotora save ačhile? ");
INSERT INTO rmyChergash_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Sar či haćaren kaj či phendem tumenđe palo mangro kana phendem tumenđe te len tumen sama katar e farisejengo thaj e sadukejengo kvasco?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Askal haćardine kaj či phendas lenđe te len pes sama katar e mangresko kvasco, nego katar e farisejengo thaj e sadukejengo sikavipe. ");
INSERT INTO rmyChergash_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","A kana o Isus avilo ande krajurja oko e Kesareja e Filipešći, phučlas pire učenikonen: “So phenel o them, ko sem me, o Čhavo e Manušesko?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","A von phendine lešće: “Jek phenen kaj san o Jovano savo bolelas, aver phenen kaj san o proroko Ilija, a varesave phenen kaj san o Jeremija, ili varesavo katar e aver prorokurja.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Askal o Isus phučla len: “A tumen so tumen phenen ko sem me?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","A o Simon Petar phendas: “Tu san o Hristos, Čhavo e džude Devlesko!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","O Isus phendas lešće: “Blago tuće, Simone e Jonašće čhaveja kaj godova či sikadas tuće o manuš, nego mungro nebesko Dad. ");
INSERT INTO rmyChergash_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","A me phenav tuće: Tu san o Petar, thaj pe godoja stena vazdava mungri Khanđiri, thaj o vudar e Hadosko či nadvladina lat. ");
INSERT INTO rmyChergash_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Tuće dava e ćije katar o Carstvo nebesko thaj sa so phandes pe phuv avela phanglo po nebo thaj sa so razrešisares pe phuv avela razrešime ando nebo.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Askal o Isus strogo zapretisardas pire učenikonenđe te na phenen khonikašće kaj si vo o Hristos. ");
INSERT INTO rmyChergash_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Katar godoja vrjama o Isus teljardas te objasnil pire učenikonenđe kaj moraš te džal ando Jerusalim thaj kaj okote but trpila e starešinendar, e šorvale rašajendar thaj katar e učitelja e Mojsiješće zakonestar, kaj avela mudardo thaj uštela andar e mule o trito đes. ");
INSERT INTO rmyChergash_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Askal o Petar akharda les pe rig thaj počnisarda te odgovoril les te na ćerel godova. Motholas lešće: “Gospode, arakh Devla! Godova tuće nikada či tromal te dogodil pe.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","O Isus bolda pe ko Petar thaj phendas lešće: “Džatar mandar, Sotono! Tu san mungri zamka kaj ćire gindimata naj e Devlešće, nego e manušešće!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Askal o Isus phendas pire učenikonenđe: “Ako vareko kamel te džal pale mande, moraš te odreknil pe korkoro pestar, moraš te lel piro trušul thaj teljarel pale mande. ");
INSERT INTO rmyChergash_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kaj svako savo kamel te araćhel piro trajo hasarela les; a ko hasarel piro trajo pale mande, araćhela les. ");
INSERT INTO rmyChergash_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","So mol e manušešće te dobil sasto them, a hasarel piro trajo? So o manuš šaj del sago zamena pale piro trajo? ");
INSERT INTO rmyChergash_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kaj me, o Čhavo e Manušesko, uskoro avava ande slava mungre dadešći, mungre anđelenca, thaj askal svakonešće boldava prema lešće dela. ");
INSERT INTO rmyChergash_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Čače phenav tumenđe, varesave maškar tumende save si akate či merena dok či dićhena man, e Čhaves e Manušešće, sar avav mungre Carstvosa.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Šov đes majposle o Isus lijas pesa e Petre, e Jakove thaj lešće phrales e Jovano opre pe vuči gora, te aven korkoro. ");
INSERT INTO rmyChergash_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Thaj okote angle lende promenisajlo lesko izgled, o muj lesko phabolas sar o kham, a e haljine pe leste postanisardine parne sago o svetlost. ");
INSERT INTO rmyChergash_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ande godova pojavisajle o Mojsije thaj o Ilija thaj teljardine te ćeren svato e Isuseja. ");
INSERT INTO rmyChergash_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","A o Petar phendas: “Gospode, lačhe si kaj sam akate! Ako kames, ćerava akate trin senice: jek pale tute, jek palo Mojsije thaj jek palo Ilija.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Dok vo još ćerelas svato, učharda len o svetlo oblako thaj o glaso ašundilo andar o oblako: “Akava si mungro volime Čhavo. Vo si mungri bah! Leste čhon kan!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Kana godova ašundine e učenikurja, zurale darajle thaj peline pe koča e mujesa dži ke phuv. ");
INSERT INTO rmyChergash_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","O Isus avilo dži lende, čhuta pire vas pe lende thaj phendas: “Ušten thaj na daran!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Von vazdine pešće jakha, ali či dikhline khonikas osim e Isuse. ");
INSERT INTO rmyChergash_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Dok fuljenas tele katar e gora, o Isus zapovedisarda lenđe: “Khonikašće na phenen so dikhline sa dok me, o Čhavo e Manušesko, či vaskrsniv andar e mule.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","A e učenikurja phučline les: “Sostar askal e učitelja e Mojsiješće zakonestar phenen kaj o Ilija trubul te avel majsigo nego o Mesija?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","A o Isus phendas lenđe: “O Ilija vi čače avel thaj sa palem čhola pe pesko than. ");
INSERT INTO rmyChergash_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ali phenav tumenđe kaj o Ilija već avilo, ali či pindžardine les, pa ćerdine lesa so kamline. Gajda vi o Čhavo e Manušesko trpila andar lenđe vas.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","E učenikurja askal haćardine kaj phenel lenđe palo Jovano savo bolelas. ");
INSERT INTO rmyChergash_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Kana aviline dži ko but o them, e Isuseste avilo varesavo manuš, pelo tele angle leste pe koča ");
INSERT INTO rmyChergash_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","thaj phenelas lešće: “Gospode! Smiluisar tut mungre čhavešće kaj si mesečari thaj but trpil. Često perel te ande jag te ando paj. ");
INSERT INTO rmyChergash_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Andem les ke ćire učenikurja, ali von našti sastardine les.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","A o Isus phendas: “Tumen bi paćako thaj rumome naraštajona, kozom još moraš te avava tumenca? Kozom još moraš te trpiva tumen? Anen les mande!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Askal o Isus zapretisardas e bilačhe duhošće thaj vo inkljisto andar o čhavro savo isto časo sastilo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Askal e učenikurja aviline ko Isus thaj pe rig phučline les: “Sostar amen našti tradam godole bilačhe duhos andar o čhavro?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","A o Isus phendas lenđe: “Zbog tumaro cikno paćipe. Vi čače phenav tumenđe, te avel tumen paćipe gajda cikno sago kaj si e gorušicako zrno thaj te askal phenen akale goraće: ‘Nak akatar inća’, voj nakhlasas. Khanči či avilosas tumenđe nemoguće. ");
INSERT INTO rmyChergash_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Samo e molitvava thaj e postosa šaj tradel pe akaja vrsta demonurja.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Kana e Isusešće učenikurja ćidine pe ande Galileja, O Isus phendas lenđe: “Me, o Čhavo e Manušesko, avava predaime e manušenđe ande vas. ");
INSERT INTO rmyChergash_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Von mudarena man, ali po trito đes me uštava andar e mule.” Godova zurale rastužisarda e učenikonen. ");
INSERT INTO rmyChergash_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Kana aresline ando Kafarnaum, avile dži ko Petar okola kaj ćidenas o hramsko porezo thaj phučline les: “Tumaro učitelj poćinel o hramsko porez, si gajda?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","O Petar phendas: “Poćinel!” Askal dijas ando ćher, a o Isus odma lijasle anglal thaj phučlas: “So gndis, Simone, dali e themešće carurja ćiden e carina ili o porez katar pire ili katar averenđe čhavra?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","O Petar phendas lešće: “Katar averenđe čhavra,” a o Isus pe godova phendas lešće: “Askal si lenđe čhavra oslobodime thaj či trubun te poćinen o porezo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ali te na uvredisaras len, dža dži ko more thaj čhude e udica. Prvo mačhešće saves astares putar lesko muj, thaj araćheja andre lovoro. Le les thaj lesa poćin lenđe o porezo pale mande thaj pale tute.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ande godova časo aviline ko Isus e učenikurja thaj phučline les: “Ko si askal majbaro ando Carstvo nebesko?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Pe godova o Isus akhardas peste e cikne čhavres, thaj čhuta les maškare maškar lende ");
INSERT INTO rmyChergash_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","thaj phendas lenđe: “Čače phenav tumenđe, ako či obratin tumen thaj či aven sago cikne čhavra, sigurno či dena ando Carstvo nebesko! ");
INSERT INTO rmyChergash_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ando Carstvo nebesko, majbaro si okova savo ponizil pes sago akava cikno čhavro. ");
INSERT INTO rmyChergash_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ko zbog mande prihvatil jećhe kasave čhavre, man prihvatil. ");
INSERT INTO rmyChergash_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ali ko jećhe katar akala ciknen kaj paćan ande mande crdel po bezeh, avilosas lešće majlačhe te phanden lešće mlinsko bar oko e kor, thaj te tasadol ando more.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","O Isus majdur phendas: “Teško e manušenđe ando them kaj ćeren okova so navodil po bezeh! No gajda vareso moraš te avel. No teško okolešće prekal kaste avel. ");
INSERT INTO rmyChergash_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ako ćiro vas ili ćiro pungro crdel tut po bezeh, čhin len thaj čhude len tutar. Kaj si tuće majlačhe te des ando večno trajo kljasto ili bango, nego te liduj vastenca ili pungrenca aves čhudino ande večno jag. ");
INSERT INTO rmyChergash_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ako ćiri jak crdel tut po bezeh, inkal lat thaj čhude lat tutar! Kaj si tuće majlačhe jećhe jakhasa te des ando večno trajo nego te liduj jakhenca aves čhudino ande paklošći jag. ");
INSERT INTO rmyChergash_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Len sama te na dićhen barikane ni jećhe katar akala cikne. Kaj phenav tumenđe kaj lenđe anđelurja po nebo neprestalno ačhen anglo nebesko Dad. ");
INSERT INTO rmyChergash_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Kaj me, o Čhavo e Manušesko, avilem te spasiv e hasarden.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“So gindin? Ako si e manušes šel bakhre thaj jek lendar hasavol, či li mućela okolen injavardeš thaj inja ande gore thaj džal te rodel okole jećhe kaj hasajlo? ");
INSERT INTO rmyChergash_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Čače phenav tumenđe, ako araćhel les, majbut raduilape kaj arakhlas godole jećhe nego okolen injavardeš thaj inja kaj či hasajle. ");
INSERT INTO rmyChergash_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Gajda vi tumaro nebesko Dad či kamel te hasavol thaj te propadnil ni jek katar akala cikne.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ako ćiro phral sagrešil protiv tute, le les tusa pe rig thaj prekorisar les. Te čhuta tute kan, palem dobisardan ćire phrales palpale. ");
INSERT INTO rmyChergash_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","No ako či čhol kan tute, le tusa još jećhe ili duje phralen, gajda te ‘svako optužba temeljil pes pe alava duje ili trine svedokonenđi’. ");
INSERT INTO rmyChergash_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ako odbil te čhol kan vi lende, inkal godova angle khanđiri. A ako odbil te čhol kan vi ke khanđiri, inćaren les sago manušes svo či pindžarel e Devles ili sago carenikos. ");
INSERT INTO rmyChergash_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Čače phenav tumenđe, so god phanden pe phuv avela phanglo po nebo, thaj sa so razrešin pe phuv, avela razrešime vi po nebo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Isto gajda phenav tumenđe: ako duj džene tumendar akate pe phuv jećhe ileja zamolin bilo so, mungro nebesko Dad dela tumen godova. ");
INSERT INTO rmyChergash_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Zato okote kaj ćiden pe duj ili trin džene ando mungro alav, okote sem vi me maškar lende.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Askal o Petar avilo ko Isus thaj phendas lešće: “Gospode, kozom drom te jartosarav mungre phralešće savo sagrešisardas protiv mande? Dži ke efta drom?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","A o Isus phendas lešće: “Na samo efta drom, nego efta drom po eftavardeš! ");
INSERT INTO rmyChergash_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","O Carstvo nebesko si sago kana o caro kamel te poravnil e računurja pire slugenca. ");
INSERT INTO rmyChergash_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Thaj kana teljardine te ćeren obračun, andine leste jećhe savo sas lešće udžile deš milje gone sunakaj. ");
INSERT INTO rmyChergash_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Sar o manuš našti boldelas o dugo, o caro zapovedisardas te bićinen le zajedno lešće romnjava thaj lešće čhavrenca thaj sa okoleja so sas len thaj gajda podmirin o dugo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","O sluga pe godova pelas anglo caro pe koča e mujesa dži ke phuv thaj zamolisarda les: ‘Av strpljivo manca thaj sa boldava tuće!’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","O caro sažalisajlo pe leste, oslobodisarda les thaj jartosardas lešće o dugo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ali kana godova sluga inkljisto avri, maladas pire drugares, avre slugo, savo sas lešće udžile cara love. Astarda les pale kor thaj počnisarda te tasavel les, thaj phenel lešće: ‘Bolde manđe so san udžile!’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","O drugari lesko pelo angle leste pe koča e mujesa dži ke phuv thaj zamolisarda les: ‘Av strpljivo manca thaj boldava tuće!’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","A vo či kamlas te ažućarel, nego inđarda les thaj čhuda les ande tamnica dok či boldel o dugo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kana e aver sluge dikhline so dogodisajlo, zurale ražalostisajle thaj đeletar ko caro thaj obavestisardine les so sas. ");
INSERT INTO rmyChergash_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Pe godova o caro akhardas e slugos savešće jartosardas thaj phendas lešće: ‘Bilačho slugona! Me tuće jartosardem sa so sanas manđe udžile zato kaj zamolisardan man! ");
INSERT INTO rmyChergash_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Zar či vi tu trubujanas te smiluis tut ćire drugarešće sago kaj me smiluisajlem tuće?’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Askal o caro holjajlo thaj predaisarda les e mučiteljenđe dok či boldel sa o dugo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Gajda vi mungro nebesko Dad ćerela tumenca, ako či jarton tumare phralešće saste ileja.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Kana o Isus sas gata godole alavenca, đelotar andar e Galileja thaj đelo ande judejske krajurja pe aver rig katar e reka Jordan. ");
INSERT INTO rmyChergash_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Pale leste teljardas o silno them, thaj vo okote sastarelas okolen save sas nasvale. ");
INSERT INTO rmyChergash_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Avile leste varesave fariseja thaj phučenas les gajda te probin les: “Dali o manuš tromal te rastavil pe katar piri romnji zbog bilo savo razlog?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","A o Isus mothodas lenđe: “Sigurno čitosardine ando Sveto lil kaj o Stvoritelj ando početko ‘stvorisarda muško thaj žensko’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","thaj kaj phendas: ‘O manuš mućela pire dades thaj pire deja thaj sjedinila pe pire romnjasa, thaj von duj džene avena jek telo.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Gajda von duj džene naj majbut duj džene, nego si jek. Dakle, neka nijek manuš či rastavil okova so o Del sastavisardas!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Pe godova von phučline e Isuse: “Sostar askal o Mojsije phendas kaj o manuš trubul samo pire romnja te del rastavno lil thaj te askal mućel lat?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","A o Isus phendas lenđe: “O Mojsije mukla tumenđe te šaj mućen tumare romnjen zato kaj sen tvrdoglave, ali ando početko nas gajda. ");
INSERT INTO rmyChergash_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ali me phenav tumenđe: Ko god rastavil pe katar piri romnji, osim zbog lako bludo, thaj lel aver romnja, ćerel preljub.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Pe godova e Isusešće učenikurja phendine: “Ako si gajda maškar o rom thaj e romnji, askal si majlačhe te na ženil pe!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","O Isus phendas lenđe: “Našti godova savora te prihvatin, nego samo okola savenđe o Del godova dijas. ");
INSERT INTO rmyChergash_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kaj si manuša save si nesposobne katar o bijandipe te ženin pe, si vi okola saven e manuša ćerdine nesposobne te ženin pe, a varesave pire voljasa odlučin kaj či ženina pe zbog o Carstvo nebesko. Ko šaj prihvatil, nek prihvatil!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Askal andine lešće e čhavren te čhol pire vas pe lende thaj te pomolil pe pale lende, a e učenikurja godova braninas lenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","A o Isus pe godova phendas lenđe: “Mućen e čhavren te aven mande thaj na branin lenđe, kaj kasavenđe pripadil o Carstvo nebesko!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Čhuta pire vas pe lende thaj askal đelotar okotar. ");
INSERT INTO rmyChergash_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Askal nakhlo dži ko Isus varesavo manuš thaj phučla les: “Učiteljina, savo lačhipe trubul te ćerav te dobiv večno trajo?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","A o Isus phendas lešće: “Sostar phučes man palo lačhipe? Samo si jek lačho – o Del! Te kames te des ando večno trajo, inćar e zapovesti!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","A vo phučlas: “Save zapovesti”? A o Isus phendas: “Akala zapovesti: ‘Na mudar, na ćer preljub, na čor, na svedočisar hohamne, ");
INSERT INTO rmyChergash_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","poštuisar ćire dade thaj ćire deja’ thaj ‘volisar okoles savo si ćiro pašutno sago korkoro tut.’” ");
INSERT INTO rmyChergash_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","A o terno phendas lešće: “Godova sa već ćeravas. So još falil man?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","A o Isus phendas lešće: “Te kames te aves savršeno, dža thaj bićin so si tut, a e love podelisar e čorenđe thaj avela tut blago ando nebo. Askal av thaj sledisar man!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kana o terno ašundas godova, ražalostisajlo thaj đelotar, kaj či kamlas te bićinel piro baro barvalipe. ");
INSERT INTO rmyChergash_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","A o Isus pe godova phendas e učenikonenđe: “Čače phenav tumenđe, phare o barvalo dela ando Carstvo nebesko! ");
INSERT INTO rmyChergash_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Još phenav tumenđe: Majloće si e kamilaće te naćhel kroz e suvjaće kan nego e barvalešće te del ande Devlesko carstvo!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kana godova ašundine e učenikurja zurale začudisajle thaj phučenas pe: “Pa ko askal šaj spasil pe?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","A o Isus lačhe dikhla pe lende thaj phendas: “E manušenđe si godova potpuno nemoguće, ali na vi e Devlešće. E Devlešće si sa moguće.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Askal o Petar phendas lešće: “Ake, amen sa muklam te šaj džas pale tute. So dobisarasa pale godova?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","A o Isus phendas lenđe: “Čače phenav tumenđe, kana o Del obnovila o them, me, o Čhavo e Manušesko, bešava po prestolje mungre slavako, askal vi tumen bešena pe dešuduj prestolja thaj sudina e dešuduj plemenurja e Izraelošće. ");
INSERT INTO rmyChergash_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","A svako ko zbog mande mućel piro ćher, ili pire phralen, ili pire phejen, ili pire dades, ili pire deja, ili pire romnja, ili pire čhavren, ili piri phuv, primila šel drom majbut thaj nasledila o večno trajo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ali, but save si akana prve avena palune, a e palune avena prve.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Kaj o nebesko Carstvo si slično e domaćinesa savo detharinako rano inkljisto te unajmil e radnikonen pale piro vinograd. ");
INSERT INTO rmyChergash_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Thaj pogodisajlo e radnikonenca pale jek dnevnica thaj bičhalda len ande piro vinograd. ");
INSERT INTO rmyChergash_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Oko injato sato palem inkljisto po trgo thaj dikhla okote aver manušen sar ačhen bi bućarne, ");
INSERT INTO rmyChergash_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","thaj vi lenđe phendas: ‘Džan vi tumen thaj ćeren bući ande mungro vinograd thaj poćinava tumenđe kozom si pravedno.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Gajda vi von đele te ćeren bući ando vinograd. Varekaj katar o mismeri thaj oko trin saturja ćerda isto. ");
INSERT INTO rmyChergash_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","A kana palem inkljisto oko o pandžto sato palo mismeri, arakhlas avren manušen sar ačhen okote bi bućarne. Phendas lenđe: ‘Sostar ačhen akate celo đes thaj bi bućarne?’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Von phendine lešće: ‘Khonik či dija men bući.’ A vo askal phendas lenđe, ‘Džan askal vi tumen ando mungro vinograd.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Talerjat o gospodari e vinogradesko phendas pire upravitelješće: ‘Akhar e radnikonen thaj isplatil len redom, katar okola save aviline palune dži ke prve.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","E radnikurja save aviline oko o pandž saturja dobisardine sasti dnevnica. ");
INSERT INTO rmyChergash_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Pe godova okola save aviline prve te ćeren bući gndisardine kaj dobina majbut, ali vi von dobisardine isto. ");
INSERT INTO rmyChergash_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Line e love thaj počnisardine te prigovorin protiv o vinogradari. ");
INSERT INTO rmyChergash_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Thaj phendine: ‘Akala palune ćerdine bući samo jek sato, a tu poćindan lenđe isto sago vi amenđe save sasto đes phare ćerdam bući thaj phabilam po kham!’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","O gospodari e vinogradesko bolda pe ke jek lendar thaj phendas: ‘Manušeja, naj sem nepravedno prema tute. Či li pogodisajlan manca pale gadići? ");
INSERT INTO rmyChergash_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Le so si ćiro thaj džatar. A me kamav te dav akalešće savo avilo paluno isto sago vi tuće. ");
INSERT INTO rmyChergash_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Naj man li pravo te ćerav mungre lovenca so kamav? Ili san zavidno kaj sem lačho prema leste?’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Gajda okola save si akana palune avena prve, a e prve avena palune.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Kana o Isus delas ando Jerusalim, lijas pesa pire dešuduj učenikonen pe rig thaj dromesa phendas lenđe: ");
INSERT INTO rmyChergash_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ake, das ando Jerusalim. Okote predaina man, e Čhave e Manušešće, e šorvale rašajenđe, thaj e učiteljenđe e zakonestar, save osudina man po smrto, ");
INSERT INTO rmyChergash_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","thaj predaina man okolenđe kaj či pindžaren e Devle te maren muj mandar, te bičuin man, thaj te razapnin man. Ali me o trito đes uštava andar e mule.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Askal avili dži ko Isus e dej e Zevedejevešće čhavenđi, zajedno pire čhavenca, thaj peli pe koča angle leste te vareso zamolil les. ");
INSERT INTO rmyChergash_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","O Isus phučla lat: “So kames?” A voj phendas: “Zapovedisar te mungre čhave ande ćiro Carstvo bešen paše tute, jek pe ćiri desno a aver pe ćiri levo rig.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","A o Isus phendas: “Či džanen so roden. Dali šaj pijen andar o tahtaj savo me uskoro pijava?” A von phendine lešće: “Ej, šaj!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","A vo phendas lenđe: “Čače pijena andar mungro tahtaj pherdo patnje, ali naj mungro te odrediv ko bešela pe mungri desno, thaj pe mungri levo rig. Godola thana dena pe okolenđe pale kaste lačhardas mungro Dad.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kana godova ašundine aver deš učenikurja, holjajle pe duj phrala. ");
INSERT INTO rmyChergash_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Askal o Isus akharda len peste, thaj phendas lenđe: “Džanen kaj e vladarja okolenđe save či pindžaren e Devle okrutno vladin pe lende a e moćnikurja volin te gospodarin pe lende. ");
INSERT INTO rmyChergash_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ali maškar tumende te či avel gajda! Nego savo kamel te avel majbaro maškar tumende, nek služil tumenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Thaj ko kamel te avel majbaro maškar tumende, neka avel tumaro sluga. ");
INSERT INTO rmyChergash_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Baš sago kaj ni me, o Čhavo e Manušesko, či avilem te služin manđe, nego te me služiv averenđe thaj te dav mungro trajo sago poćin pale butende.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Kana o Isus thaj e učenikurja inkljenas andar o Jerihon, pale lende teljardas o but o them. ");
INSERT INTO rmyChergash_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Thaj dik, pašo drom bešenas e duj kore manuša, pa kana ašundine kaj o Isus naćhel počnisardine te čhon muj: “Smilujisar tut amenđe Gospode, e Davidešće Čhaveja!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","O them čholas muj pe lende te na rknin, ali von čhonas muj još majzurale: “Smiluisar tut amenđe Gospode, e Davidešće Čhaveja!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","A kana o Isus godova ašunda, ačhada pe paše lende, akharda len thaj phučla: “So kamen te ćerav tumenđe?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","A von phendine lešće: “Gospode, de te šaj dikhas.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","O Isus sažalisajlo thaj čhuta pire vas pe lenđe jakha, thaj von ande data šaj dićhenas. Thaj teljardine pale leste. ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Kana o Isus thaj e učenikurja aviline paše pašo Jerusalim thaj avile ando gav Vitfaga pe Maslinsko gora, o Isus bičhaldas anglal pire duj učenikonen. ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Thaj phendas lenđe: “Džan ando gav savo si angle tumende thaj odma araćhena e phangle magarica thaj lasa laće terne magare. Putren len thaj anen mande. ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","A ako vareko phučel tumen vareso, samo phenen: ‘Trubun e Gospodešće’, thaj odma mućena len.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Godova dogodisajlo te pherdol okova so sas phendo prekal o proroko: ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Phenen e themenđe andar o Jerusalim: ‘Ake, ćiro caro avel tuće, ponizno si thaj jašil po magarco, po terno e magaricako.’” ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","E učenikurja đele thaj ćerdine sar o Isus phendas lenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Andine e magarica thaj e terne magarco thaj preko lende čhutine pire ogrtača, te šaj o Isus bešel pe lende. ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","O but o them buljarelas tele po drom pire ogrtačurja te sikaven lešće čast, a aver čhinenas e ranja e patrjenca katar e kaš thaj buljarenas po drom. ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","A o them savo džalas angle leste thaj pale leste čhonas muj: “Hosana e Davidešće Čhavešće! Blagoslovime okova savo avel ando alav e Gospodesko! Hosana e Devlešće ande visine!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Kana o Isus dijas ando Jerusalim, sasto gav uzbunisajlo thaj phučenas pe: “Ko si akava?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","A o but o them phenelas: “Akava si o Isus, o proroko andar o Nazaret ande Galileja.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Askal o Isus dijas ando Hramo, thaj trada andar leste sa okolen save bićinenas thaj ćinenas ando Hramo. Okolenđe kaj phađenas e love dijas mujal e sinije, a okolenđe save bićinenas e golubonen dijas mujal e klupe. ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Thaj phenelas lenđe: “Ando Sveto lil ačhel ramome: ‘Mungro Hramo trubul te avel molitveno ćher’, a tumen ćeren lestar than kaj ćiden pe e razbojnikurja!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Askal avile dži ko Isus ando Hramo e kore thaj e banđe thaj vo sastardas len. ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","A kana dikhline e šorvale rašaja thaj e učitelja e Mojsiješće zakonestar e čudurja save ćerda thaj e čhavren ando Hramo sar čhon muj: “Hosana e Davidešće Čhavešće!”, zurale holjajle, ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","thaj phučline les: “Ašunes li tu so akala čhavra čhon muj?” O Isus phendas lenđe: “Ašunav. Sigurno čitosardine ando Sveto lil: ‘Ćerdan te slavin tut e čhavra thaj e bebe.’ ” ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Askal mukla len thaj andar o gav Jerusalim bolda pe ando gav savo akhardolas Vitanija, te okote raćarel. ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Detharinako rano, kana boldelas pe ando Jerusalim, o Isus bokhajlo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Dikhla e smokva pašo drom thaj nakhlo dži late, ali pe late či arakhlas khanči osim patrja. Zato phendas laće: “Nikada te na avel majbut rodo pe tute!” Thaj e smokva odma šućili. ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","E učenikurja pe godova začudisajle thaj phučline: “Sar e smokva gajda sigo šućili?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","A o Isus phendas lenđe: “Čače phenav tumenđe, te paćajine thaj či posumnjin, či ćerena samo godova so me ćerdem e smokvasa, nego te phendine akale planinaće: ‘Vazde tut akatar thaj čhude tut ando more!’, godova vi avela. ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Sa so zamolin ando paćipe, primina.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","O Isus đelo ando Hramo. Dok okote sikavelas, avile leste e šorvale rašaja thaj e themešće starešine thaj phučline les: “Savo autoriteto si tut te ćeres akava? Ko dija tut vlast pale godova?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","A o Isus phendas lenđe: “Vi me tumen vareso phučava. Ako tumen manđe phenen, vi me phenava tumenđe ko dija man vlast. ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Dali o Del phendas e Jovanošće te bolel e manušen, ili e manuša phendine lešće te ćerel godova?” Von ćerenas svato maškar peste: “Te phendam ‘o Del phendas lešće’, phučela men ‘Sostar askal či paćajine lešće.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","A te phendam katar e manuša, dar amenđe katar o but o them kaj savora paćan kaj si o Jovano proroko.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Zato phendine e Isusešće: “Či džanas.” A o Isus phendas lenđe: “Askal ni me tumenđe či phenava katar man vlast!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“So gndin pale akava: Varesave manušes sas duj čhave. Avilo ko prvo thaj phendas lešće: ‘Čhaveja, dža ađes thaj ćer bući ando vinograd!’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","O čhavo phendas: ‘Či kamav!’ Ali maj posle predomislisajlo thaj đelo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Askal o dad isto gajda phendas vi e aver čhavešće. A o čhavo phendas ‘Džava, raja’, ali či đelo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Savo katar akala duj džene ćerda e volja pire dadešći?” A von phendine: “Okova prvo”. A o Isus pe godova phendas lenđe: “Čače phenav tumenđe, e bludnikurja thaj e carinikurja dena majsigo tumendar ande Devlesko carstvo! ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kaj o Jovano savo bolelas avilo te sikavel tumenđe o pravedno drom, ali tumen či paćaine lešće, a e carinikurja thaj e bludnikurja paćaine. A tumen čak vi kana sa godova dikhline, či predomislisajle thaj či paćajine lešće.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Ašunen još jek prispodoba: Varesavo manuš posadisardas vinograd thaj ogradisarda les, hanadas ande leste than kaj ćićidelas pe e drak te ćerel pe e mol thaj vazda stražarsko kula. Askal dijas o vinograd ando najam e vinogradarenđe thaj đelo po drom. ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kana avili e vrjama pale berba, bičhaldas e slugen te len lesko deo katar o urodo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ali e vinogradarja astardine e slugonen, jećhe mardine, a jećhe mudardine, a po trito čhudenas e bara dok či mudardine les. ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Pale godova vo bičhaldas majbut slugonen nego prvo data, ali e vinogradarja vi lenca ćerdine isto gajda. ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Po krajo bičhaldas lenđe pire čhaves kaj gndisardas: ‘Mungre čhave poštujina.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ali kana e vinogradarja dikhline e čhave phendine: ‘Akava si o nasledniko. Hajde te mudaras les, thaj te ačhel amenđe lesko nasledstvo.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Astardine les, čhudine les avri andar o vinograd thaj mudardine les.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Askal o Isus phučla len: “So gndin, sar o gospodari e vinogradesko ćerela okole vinogradarenca kana boldela pe?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Von phendine lešće: “Godole zlikovconen mudarela bi milako, a o vinograd dela aver vinogradarenđe, save dena les o urodo kana pale godova avela e vrjama.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","O Isus phendas lenđe: “Sigurno čitosardine ando Sveto lil: ‘Bar saves e graditeljurja odbacisardine postanisardas glavno bar e temeljesko. Godova si e Gospodesko delo, čudesno ande amare jakha.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Zato phenav tumenđe kaj lela pes tumendar e Devlesko carstvo, thaj dela pe okole themešće save dena lešće plodurja. ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Thaj ko god perel pe godova bar phađelape, a godova bar smrskola okoles pe kaste perel.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kana e šorvale rašaja thaj e fariseja ašundine e paramiče thaj haćardine kaj mothol pale lende, ");
INSERT INTO rmyChergash_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","kamenas te astaren les, ali daranas katar o them savo paćalas kaj si o Isus proroko. ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","O Isus palem počnisarda te ćerel lenđe svato ande paramiče. ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“O Carstvo nebesko si sago kana varesavo caro ćerel svaturja pire čhavešće. ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Thaj bičhalda pire slugonen te akharen okolen save sas akharde pe svaturja, ali von či kamline te aven. ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Palem bičhaldas aver slugen thaj phendas: Phen e akhardenđe: ‘Dik, pripremisardem tumenđe e gozba. Peklam o majlačho mas. Sa si spremno. Aven pe svaturja!’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","A von či marisardine thaj đeletar svako pire dromesa, jek ande pire njive, aver đele te trguin. ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","A okola save ačhiline astardine e carošće slugen, mardine len thaj mudardine len. ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Pe godova o caro holjajlo, thaj bičhaldas piri vojska te mudaren okolen save mudardine lešće slugen thaj te den jag lengo gav. ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","A e slugenđe phendas: ‘Ake e svaturja si spremne, ali e akharde naj dostojne te aven. ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Askal džan pe droma avri andar o gav thaj akharen pe svaturja kas god araćhen.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Gajda inkljistine godola sluge pe droma thaj ćidine sa okolen saven arakhline, e bilačhen thaj e lačhen. Thaj e sala pale svaturja pherdili. ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ali kana o caro dijas andre te dićhel okolen save sas akharde, dikhla okote jećhe manušes savo nas lačhardo ande svečane svaturjaće drze. ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Thaj phendas lešće: ‘Manuša, sar avilan akate bi e svaturjenđe drze?’ A o manuš ačhilo bi alavesko. ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Askal o caro phendas e slugenđe: ‘Phanden lešće vas thaj lešće pungre, thaj čhuden les avri ando majhanduk tunjariko, okote avela o roipe thaj o škripipe e dandenca katar e duk. ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Kaj but si akharde, ali si cara odabrane.’” ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Askal e fariseja đele thaj dogovorisajle sar te astaren e Isuse ando svato. ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Thaj odlučisardine te bičhalen leste pire učenikonen zajedno e Irodešće manušenca te phučen les: “Učiteljina, džanas kaj phenes čačipe thaj či inćares khonikašći rig, niti dićhes ko si ko, nego sićares palo čačo drom e Devlesko. ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Akana phen amenđe so gndis tu? Dali tromal te del pe o porez e rimsko carošće ili te či del pe.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","A o Isus džanglas lenđe bilačhe gindurja thaj phendas: “Sostar kamen te crden man ande tumari zamka, licemerja? ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Sikaven manđe e kovanica savjava poćinen o porez. Thaj phenava tumenđe.” Andine lešće e kovanica. ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","A vo phučlas len: “Kasko si akava liko thaj o alav pe kovanica?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","A von phendine lešće: “E carosko.” Askal phendas lenđe: “Den askal e carošće so si e carosko a e Devlešće trubun te den so si e Devlesko.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Kana godova ašundine zadivisajle, mukline les thaj đeletar. ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Godova đes aviline leste e sadukeja, save phenen kaj naj uštipe andar e mule, thaj phučline e Isuse: ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Učiteljina, o Mojsije phendas: ‘Ako varesavo manuš savo sas oženime merel, a nas les čhavra, neka lesko phral oženil pe lešće udovicava sar voj bijandasas čhaves savo avela nasledniko e mulesko thaj vazdel lešće potomstvo.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Amende sas efta phrala. Prvo oženisajlo thaj mulo, pa pošto nas les čhavra lesko phral oženisajlo lešće romnjava. ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Isto gajda sas vi e dujto thaj e trito phralesa, pa sa gajda dži ke eftato phral. ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","A posle savorende muli vi e romnji. ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kašći askal voj avela romnji ando đes kana avela o vaskrsenje kana sas udajime pale sa efta phral?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","A o Isus phendas lenđe: “Hohaven tumen, kaj či pindžaren o Sveto lil niti e Devlešći sila! ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kaj kana avela o vaskrsenje e manuša či ženina pe niti udajina pe, nego avena sar e anđelurja e Devlešće po nebo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Sigurno čitosardine ando Sveto lil so o Del phendas tumenđe palo vaskrsenje andar e mule: ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Me sem o Del e Avraamesko, e Isakosko, thaj Jakovesko’ save dumut muline. A o Del naj o Del e mulengo, nego e džudengo!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kana o but o them ašundas godova, čudinas pe lešće sikavipešće. ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Kana e fariseja ašundine kaj o Isus pire alavenca phandadas e sadukejengo muj, ćidine pe vi von, ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","a jek lendar savo sas učitelj e zakonesko phučlas e Isuse te crdel les ande zamka: ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Učiteljina, savi si majvažno zapovest ande Mojsijesko zakono?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","A o Isus phendas lenđe: “‘Volisar e Gospode ćire Devle saste ileja, ćire saste dušava, thaj ćire saste gođava!’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Godoja si prvo thaj majvažno zapovest. ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","A e dujto zapovest si isto gajda važno: ‘Volisar ćire pašutnes sago korkoro tut!’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Sa aver zapovesti ande Mojsijesko zakono thaj sa e spisurja e prorokonenđe ačhen pe akala duj zapovesti.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Dok e fariseja sas još zajedno, o Isus phučla len: ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“So gndin palo Hristo, kasko si vo čhavo?” A von phendine: “E carosko Davidesko.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","A vo askal phučla len: “Sostar askal o David nadahnime e Sveto Duhosa akharda e Hristo pire Gospodesa kana phenel: ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Phenel o Gospod mungre Gospodešće: Beš pe mungri počasno desno rig dok či čhav ćire dušmajen tale ćire pungre’? ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Pa kana korkoro o David akhardas les pire Gospodeja, sar askal šaj avilosas lesko čhavo?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Thaj khonik či džanglas te odgovoril lešće ni alav. Katar godova đes khonik majbut khanči či usudisajlo te phučel les. ");
INSERT INTO rmyChergash_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Askal o Isus phendas e but e themešće thaj pire učenikonenđe: ");
INSERT INTO rmyChergash_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“E učitelja e Mojsiješće zakonestar thaj e fariseja sikaven e Mojsijesko zakon. ");
INSERT INTO rmyChergash_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Zato ašunen thaj ćeren sa so phenen tumenđe, ali na ćeren okova so von ćeren, kaj von korkoro či ćeren okova so avren sikaven. ");
INSERT INTO rmyChergash_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Von čhon pe manuša phare tereturja, save phare šaj inđarenpe, a korkoro ni e najesa či mrdnon te pomognin te inđaren godova pharipe. ");
INSERT INTO rmyChergash_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Sa so ćeren, ćeren pale godova te e manuša dićhen len. Na primer buljaren pire kutijice e stihonenca andar o Sveto lil po čikat thaj lundžaren e rese pe piro ogrtači. ");
INSERT INTO rmyChergash_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Pe gozbe Volin te bešen pe počasne thana ande sinagoge thaj pe gozbe. ");
INSERT INTO rmyChergash_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Lačhe si lenđe kana e manuša pozdravin len pe javne thana thaj kana akharen len ‘učiteljina.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","A tumen na te akharen tumen učiteljenca, kaj si tumen samo jek Učitelj, a savora tumen sen phral thaj pheja. ");
INSERT INTO rmyChergash_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Thaj khonikas pe phuv na akharen tumare dadesa, kaj si tumen samo jek Dad – okova po nebo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Thaj na akharen tumen vođe kaj si tumen samo jek Vođa – o Hristo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Savo si majbaro maškar tumende avela tumenđe sluga! ");
INSERT INTO rmyChergash_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ko korkoro pes uzvisil, avela ponizime, a ko korkoro pes ponizil, avela uzvisime. ");
INSERT INTO rmyChergash_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Teško tumenđe, učiteljurja e Mojsiješće zakonestar thaj farisejalen! Licemerja! Tumen phandaven o Carstvo nebesko angle manuša. Korkoro či den ande leste, a či mućen te den ande leste ni okola save godova kamen. ");
INSERT INTO rmyChergash_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Teško tumenđe, učiteljurja e Mojsiješće zakonestar thaj farisejalen! Licemerja! Kaj han e udovicenđe ćhera, a ćeren tumen kaj sen pobožne gajda kaj molin lundže molitve anglo them. Pale godova avena majstrože osudime. ");
INSERT INTO rmyChergash_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Teško tumenđe, učiteljurja e Mojsiješće zakonestar thaj farisejalen! Licemerja! Putujin e moreja thaj e phuvjava te pridobin jećhe ande tumari vera, a kana postanil tumaro sledbeniko, ćeren lestar te avel manuš savo zaslužil duvar majgore muke ando pakao nego so avela tumen! ");
INSERT INTO rmyChergash_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Teško tumenđe, kore vođe! Tumen phenen: ‘Te vareko hal solah e Hramosa, godova khanči či mol. Ali te vareko hal solah e Hramošće sunakajesa, askal si phanglo godole solahasa.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Tumen sen dile thaj kore! Pa so si majbaro – o sunakaj ili o Hramo savo posvetil o sunakaj? ");
INSERT INTO rmyChergash_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Thaj još phenen: ‘Te vareko hal solah e žrtvenikosa, godova khanči či mol. Ali te vareko hal solah e darosa savo si po žrtveniko, askal si phanglo godole solahasa.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Koralen! So si majbaro – o daro ili o žrtveniko savo posvetil o daro? ");
INSERT INTO rmyChergash_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ko dakle hal solah e žrtvenikosa, hal solah e žrtvenikosa thaj okolesa so si sa pe leste. ");
INSERT INTO rmyChergash_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","A ko hal solah e Hramosa, hal solah e Hramosa thaj e Devlesa savo si ande leste. ");
INSERT INTO rmyChergash_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ko hal solah e nebosa, hal solah e Devlešće troneja thaj e Devleja savo bešel pe leste. ");
INSERT INTO rmyChergash_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Teško tumenđe, učiteljurja e Mojsiješće zakonestar thaj farisejalen! Licemerja! Kaj redovno den deš posto katar e nana, katar mirođija thaj katar o kimo, a mukline okova so si majvažno ando zakon: pravda, milosrđe thaj paćipe. Trubun te den deš posto, ali či troman te zanemarin majvažne stvarja andar o zakon. ");
INSERT INTO rmyChergash_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kore vođe! Cedin o paj te či pen e pajesa vi e cincares, a kadre sen, te nakhaven e saste kamila! ");
INSERT INTO rmyChergash_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Teško tumenđe učiteljurja e Mojsiješće zakonestar thaj farisejalen! Licemerja! Thoven tumaro tahtaj thaj tumaro čaro avrjal, a andral sen pherde pohlepa thaj želja te ugodin korkoro tumenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Koro farisejina! Majsigo thov o tahtaj andral thaj avela čisto vi avrjal. ");
INSERT INTO rmyChergash_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Teško tumenđe učiteljurja e Mojsiješće zakonestar thaj farisejalen! Licemerja! Tumen sen sago okrečime limorja. Avrjal izgledin šukar, a andral sen pherde mulikane kokala thaj svakojako melalipe! ");
INSERT INTO rmyChergash_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Gajda vi tumen e manušenđe avrjal sikaven tumen pravedne, ali andral sen pherde licemerje thaj bezakonje. ");
INSERT INTO rmyChergash_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Teško tumenđe učiteljurja e Mojsiješće zakonestar thaj farisejalen! Licemerja! Tumen e prorokonenđe vazden limorja thaj kitin e spomenikurja e pravednikonenđe, ");
INSERT INTO rmyChergash_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","thaj tumen phenen: ‘Te amen trajisardamas ande vrjama amare pradadenđi, či avilosas amen talo lenca ande godova te čhoras o rat e prorokonengo.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Gajda korkoro protiv tumende svedočin kaj sen potomkurja okolenđe save mudardine e prorokonen. ");
INSERT INTO rmyChergash_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Tumen dovršin, dakle, godova so von započnisardine! ");
INSERT INTO rmyChergash_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Tumen sapenđe čhavra! Otrovno leglona! Sar našena katar e paklošći bari jag? ");
INSERT INTO rmyChergash_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Pale godova, ake, bičhalav tumenđe e prorokonen, e mudracen thaj e učiteljen e Mojsiješće zakonestar. Varesaven lendar mudarena thaj razapnina, a averen bičuina pe sinagoge thaj progonina len katar o gav dži ko gav ");
INSERT INTO rmyChergash_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","gajda perela pe tumende o rat sa e pravednikonengo savo si čhordo pe phuv, katar o rat e Aveljesko savo sas pravedno dži ko rat e Zaharijasko, e Varahijinesko čhavesko, saves tumen e Židovurja mudardine maškar e svetinja e hramošći thaj maškar o žrtveniko. ");
INSERT INTO rmyChergash_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Čače phenav tumenđe, kaj sa godova rat perela pe akava naraštaj.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Jerusalime, Jerusalime, savo mudares e prorokonen thaj čhudes e bara dži ko smrto pe okola save si e Devlestar bičhalde tuće! Kozom drom lijem te ćidav ćire čhavren, sago e kvočka savi ćidel pire pujen tale pešće phaka, ali tumen či kamline! ");
INSERT INTO rmyChergash_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ake, akana tumaro ćher ačhela pusto. ");
INSERT INTO rmyChergash_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kaj phenav tumenđe, či dićhena man majbut dok či phenen: ‘Blagoslovime si okova savo avel ando alav e Gospodesko!’ ” ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Kana o Isus inkljisto andar o Hramo thaj teljarda majdur, avile leste lešće učenikurja thaj sikadine lešće e hramošće zgrade. ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","A o Isus phendas lenđe: “Dićhen sa akava? Čače phenav tumenđe, či ačhela katar akava ni bar pe bareste. Svako avela harado.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Kana o Isus bešelas pe Maslinsko gora, lešće učenikurja avile leste pe rig thaj phendine lešće: “Phen amenđe kana o hramo avela harado thaj savo avela o znako kana palem aveja thaj kana avela o krajo e themesko.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","O Isus phendas lenđe: “Len sama te či vareko hohavel tumen, ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","kaj but avena ande mungro alav thaj phenena: ‘Me sem o Hristo’ thaj e buten hohavena. ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kana ašunena pale raturja thaj kaj ćerel pe svato pale raturja, na te uznemirin tumen kaj godova moraš te dogodil pe, ali godova još naj o krajo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Zaratila o them protiv o them thaj o carstvo protiv o carstvo. Avela potresurja ande but e krajurja e themešće thaj zavladila e bari bok. ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Sa godova si samo o početko e bare mukengo sago kaj si e manušnja kana trubul te bijanel. ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Askal predaina tumen te aven mučime thaj mudarena tumen, a zbog mande sa o them mrzala tumen. ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Thaj but o them askal hasarela o paćipe thaj jek avren izdaina thaj mrzana. ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Avena e but hohamne prorokurja thaj hohavena e bute manušen. ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Zbog o baro bezakonje e butenđi ljubav šudrola. ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ali ko god ačhel verno dži ko krajo avela spasime. ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","E bahtali nevimata palo Carstvo nebesko propovedila pes pe sasti phuv sago svedočanstvo sa e themenđe, a askal konačno avela o krajo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","A kana dićhena ‘e grozota savi anel uništenje’ pale savo phendas o proroko Danilo, kaj ačhel po sveto than ando Hramo (ko akava čitol neka svatil) ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","askal okola save si ande Judeja neka našen ande gore. ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Thaj ko araćhel pe po ćher, neka či fuljel tela ando ćher te lel vareso! ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","A ko araćhela pe ande njive, neka na boldel pe ćhere te lel o ogrtači! ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Teško e khamne manušnjenđe thaj okolenđe save den čuči e čhavren ande godola đesa. ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Molin tumen e Devlešće te tumaro našipe či avel ando ivend ili ando savato. ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kaj askal avena gajda strašne nevolje save nas katar o postanko e themesko, niti varekana avena. ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kana godola đesa či harnjardinesaspe khonik či ačhilosas džudo. Ali zbog okola saven o Del izabirisardas, godola đesa avena harnjarde.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","O Isus majdur phendas: “Ako vareko askal phenel tumenđe: ‘Ake, o Hristo si akate!’ ili: ‘Eketalo, okote si!’, na paćan. ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kaj avena e hohamne hristurja thaj e hohamne prorokurja save ćerena čudesne znakurja thaj čudurja sar hohadinesas, ako si moguće, čak vi okolen saven o Del izaberisardas. ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ake, anglal upozorisardem tumen. ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","A, te phendine tumenđe: ‘Ake, o Hristo si ande pustinja’, na džan okote. Ili ako phenen: ‘Aketalo ande tajne sobe’, na paćan lenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kaj avela očito sago kana e munja sevnil katar o istoko thaj zasvetlil sa dži ko zapado, gajda avela vi kana me, o Čhavo e Manušesko, avava. ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Godova avela očito sago kaj ćiden pe e lešinarja okote kaj si o mulo telo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","A odma pale nevolje godola đes, ‘o kham kaljola, thaj o čhonut majbut či sijola, e čereja perena katar o nebo, thaj e nebeske sile avena uzdrmome.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Askal po nebo sikadola o znako e Manušešće Čhavesko. Thaj sa e plemenurja pe phuv marena pe ando kolin thaj rovena kana dićhena man, e Čhaves e Manušešće, sar avav pe nebeske oblakurja, e silava thaj e bare slavava. ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Thaj bičhalava mungre anđelen e glasno trubasa thaj von ćidena okolen saven me losardem katar sa e štar riga sa e themešće, katar jek krajo dži ke aver krajo nebesko. ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Sićon katar e smokva. Kana laće krandže kovljon thaj mućen pešće patrja, džanen kaj paše si o milaj. ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Gajda vi tumen kana dićhen sa akala događaja, džanen kaj si vo paše anglo vudar. ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Čače phenav tumenđe: Akava naraštaj či naćhela dok sa akava či avel. ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","O nebo thaj e phuv naćhena, ali mungre alava či naćhena. ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","A pale godova đes thaj pale godova sato khonik khanči či džanel kana godova avela, ni e anđelurja po nebo, ni o Čhavo, nego samo o Dad. ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Sago kaj sas ande Nojašći vrjama, gajda avela kana avava me, o Čhavo e Manušesko. ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Baš sago ande okoja vrjama, majsigo nego so sas o potop, e manuša hanas, pijenas, ženinas pe thaj udajinas pe sa dži ke okova đes kana o Noja dijas ando baro brodo, ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","thaj khanči či haćardine so avela dži kaj god či avilo o potop thaj sa inđarda len, gajda avela vi kana avela o Čhavo e Manušesko. ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Askal avena duj džene pe njive jek lela pes, a aver mućela pe. ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Duj manušnja ando mlino meljina o điv, Jek lela pes, a aver mućela pe. ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Zato aven džungade thaj len sama, kaj či džanen savo đes avela tumaro Gospod. ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ali akava džanen: te o domaćino džanglasas ande savi vrjama e raćaći avela o čor, avilosas džungado thaj či muklasas te o čor provalil ande lesko ćher. ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Pale godova vi tumen aven spremne, kaj me, o Čhavo e Manušesko, avava ando časo kana či očekuin man.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Paćivalo thaj mudro sluga si okova saves o gospodari čhuta pe sa aver sluge te del len habe ande pravo vrjama. ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Blago godole slugašće saves lesko gospodari, kana avela, araćhel kaj ćerel gajda. ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Čače, phenav tumenđe, o gospodari čhola godole slugone te upravljil lešće saste barvalipeja. ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ali te o bilačho sluga phenel ande piro ilo: ‘Mungro gospodari či avela gajda brzo’, ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","thaj počnil te marel e aver slugen thaj hal thaj pijel e matarnenca, ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","avela lesko gospodari ande godova đes kana vo či ni gindil thaj ando časo kana vo či ni džanel, ");
INSERT INTO rmyChergash_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","thaj strogo kaznila les thaj odredila lesko than maškar e licemerja, okote avela o roipe thaj o škripipe e dandenca.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","O Isus askal phendas: “O Carstvo nebesko avela sago kana e deš čheja line pire stenkurja thaj inkljistine anglo mladoženja. ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Pandž čheja sas dile a pandž mudre. ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","E dile čheja line pesa pire stenkurja, ali či line vi zetino kozom trubulas len. ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","A e mudre čheja line pire stenkurja thaj vi zetino ande pire posude. ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Sar o mladoženja kasnilas, sa e čhejen lijas e lindri thaj o sovipe. ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","A ande opaš e rjat ašundili e vika: ‘Ake, areslo o mladoženja! Inkljen angle leste!’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Askal sa e čheja uštile thaj pripremisardine pire stenkurja. ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","A e dile čheja askal phendine e mudre čhejenđe: ‘Den amen cara katar tumaro zetino, kaj amare stenkurja mudardona.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ali e mudre phendine lenđe: ‘Nisar! Kaj sigurno či avela dosta vi pale tumende thaj vi pale amende. Džan majlačhe thaj ćinen tumenđe zetino.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ali, kana von đeletar te ćin zetino, avilo o mladoženja, thaj okola čheja save sas spremne dine lesa andre pe svaturja, a o vudar phandadilo pale lende. ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Pale godova aviline vi okola aver čheja thaj ačhile te čhon muj: ‘Gospode! Gospode, putar amenđe!’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ali vo mothoda lenđe: ‘Čače phenav tumenđe: Či pindžarav tumen.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Zato aven džungade thaj len sama, kaj či džanen ni o đes ni o sato ande savo avava!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","O Isus majdur motholas: “Askal o Carstvosa nebesko avela sago varesavo manušes kana teljarel po drom. Akhardas pire slugen thaj poverisardas lenđe piro barvalipe. ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Jećheste dija pandž gone sunakaj, ko dujto dijas duj gone, a ko trito dijas jek gono sunakaj, gajda svakonešće dijas prema godova kozom ko sas sposobno, thaj askal đelotar po drom. ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","O sluga savo dobisarda pandž gone sunakaj odma đelo, uložisardas o sunakaj thaj zaradisarda još pandž gone. ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Isto gajda, okova kaj dobisardas duje gone sunakaj zaradisarda još duj. ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","A o sluga savo dobisardas jek gono, hanadas hv ande phuv thaj ande late garadas e gospodarešće love. ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Pale lungo vrjama bolda pe o gospodari thaj manglas katar e sluge te položin lešće o računo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kana avilo leste okova kaj dobisarda pandž gone sunakaj, andas još pandž thaj phendas: ‘Gospodarina, dijan man pandž gone sunakaj. Ake, me zaradisarem lenca još pandž.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","A o gospodari phendas lešće: ‘Lačhe, lačho thaj paćivalo slugona! Sanas paćivalo ande cikne stvarja, zato čhava tut te upravis pe majbare stvarja. Av thaj raduisar tut ćire gospodaresa!’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Askal avilo leste o sluga savo dobisardas duj gone sunakaj thaj phendas: ‘Gospodarina, manđe poverisardan duj gone sunakaj. Ake, me zaradisardem još duj.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","A o gospodari phendas lešće: ‘Lačhe, lačho thaj paćivalo slugona! Sanas paćivalo ande cikne stvarja zato čhava tut te upravis pe majbare stvarja. Av thaj raduisar tut ćire gospodaresa!’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Askal avilo leste vi okova sluga savešće dijas jek gono thaj phendas: ‘Gospodarina, Džanglem kaj san pharo manuš, žanjis okote kaj či sijosardan thaj ćides okote kaj či posadisardan. ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Zato darajlem thaj garadem ćiro gono ande phuv. Ake, le ćiro gono e sunakajesa!’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ali o gospodari phendas lešće: ‘Bilačho thaj leno slugona! Džanglan kaj žanjiv okote kaj či sijosardem thaj kaj ćidav kaj či posadisardem? ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Trubujanas askal barem te uložis mungre love ande banka thaj kana me boldemas man lijemas mungre love e kamatenca. ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Zato len lestar e love thaj den okolešće kas si deš gone sunakaj! ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kaj okoles kas si, dela pe lešće još, thaj avela les ando izobilje, a okoles kas naj, lela pe lestar vi okova so si les. ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Zato akale beskorisno slugos čhuden avri ando majhanduk tunjariko. Okote avela roipe thaj škripipe e dandenca.’” ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","A o Isus phendas: “Kana avela o Čhavo e Manušesko ande piri slava thaj lesa sa lešće anđelurja, bešela po prestolje pire slavako. ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Askal sa o them ćidela pe angle leste, a vo sago kaj o pastiri odvoil e bakhren katar e buznja. ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Gajda odvoila e pravednikonen pe piri desno rig, a averen pe piri levo rig. ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Askal o caro phenela okolenđe pe desno rig: ‘Tumen, saven mungro Dad blagoslovisarda, aven thaj primin ando nasledstvo o carstvo savo si pripremime pale tumende katar o postanko e themesko! ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kaj semas bokhalo, a tumen dine man te hav; semas trušalo, a tumen dine man te pijav; semas stranco, a tumen primisardine man; ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","nango semas, a tumen dine pe mande drze; semas nasvalo, a tumen vodinas e briga pale mande; semas ande tamnica, a tumen aviline mande.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Askal e pravednikurja phenena lešće: ‘Gospode! Kana dikhlam tut kaj sanas bokhalo, thaj dijam tut te has? Ili kana sanas trušalo, thaj dijam tut te pijes? ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kana dikhlam tut sago strancone, thaj primisardam tut? Ili bi drzengo thaj dijam pe tute? ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kana dikhlam tut kaj sanas nasvalo ili ande tamnica, thaj avilam tute?’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","A o caro phenela lenđe: ‘Čače phenav tumenđe: Sogod ćerdine jećhešće katar akala mungre majcikne phral, manđe ćerdine!’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Askal phenela vi okolenđe kaj si pe lešći levo rig: ‘Džantar mandar proklete ando večno oganj savo si pripremime e benđešće thaj lešće anđelenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kaj semas bokhalo, a tumen či dine man te hav; trušalo semas, a tumen či dine man te pijav; ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","stranco semas, a tumen či primisardine man; nango semas, a tumen či dine pe mande drze; nasvalo semas thaj ando phanglipe, a tumen či vodinas briga pale mande.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Askal vi von phenena lešće: ‘Gospode! Kana dikhlam tut kaj sanas bokhalo ili trušalo, ili sago stranco, ili nango, ili nasvalo ili ande tamnica, thaj či pomognisardam tuće?’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","A vo phenela lenđe: ‘Čače phenav tumenđe: kana god či ćerdine vareso pale akala majcikne, manđe či ćerdine.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Gajda von džana ande večno kazna, a e pravednikurja ando večno trajo.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Kana o Isus sas gata sa godole alavenca, phendas pire učenikonenđe: ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Džanen kaj si pale duj đes o prazniko e bi kvascošće mangrengo. Askal man, e Čhave e Manušešće, izdaina te čhon man po trušul.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Askal ćidine pe e šorvale rašaja thaj e themešće starešine ando dvoro e bare rašajesko savo akhardolas Kajafa ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","thaj dogovorisajle te astaren e Isuse po hohaipe thaj te mudaren les. ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Thaj phendine: “Ali či tromas godova te ćeras dok si o prazniko Pasha, te či pobunilpe o them.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","A o Isus sas ande Vitanija ando ćher e Simonesko e gubavcesko. ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Dok sas pale sinija, avili dži leste varesavi manušnji e vasurjava savi sas ćerdi katar o kuč bar pherdi e kuč mirisosa savo čhordas pe Isusesko šoro. ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Kana dikhline godova, e učenikurja holjajle thaj phendine: “Sostar kasavo rspipe! ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Godova miris šaj kuč te bićindasas pe, a e love te den pe e čorenđe.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","O Isus džanglas so ćeren svato thaj phendas lenđe: “Sostar zamerin akale manušnjaće? Voj ćerda manđe lačho delo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kaj e čore manušen uvek avela tumen paše tumende, a man či avela tumenca. ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Kana čhordas akava mirisno pomast pe mande, ćerda godova pale mungro prahope. ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Čače phenav tumenđe, kaj po sasto them propovedila pe akaja Bahtali nevimata, ćerela pe svato vi pale akava so voj ćerda, laće palo spomen.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Askal jek katar e dešuduj apostolurja, akhardo Juda andar o gav Iskariot, đelo ke šorvale rašaja, ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","thaj phendas: “Kozom poćinena manđe te izdajiv tumenđe e Isuse?” Von đinadine lešće trijanda rupune kovanice. ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Katar askal o Juda počnisarda te rodel lačhi vrjama te izdail les. ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Prvo đes kana sas o prazniko bikvascošće mangrengo e učenikurja phučline e Isuse: “Kaj kames te ćeras tuće e pashalno večera?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","A vo phendas lenđe: “Džan ando Jerusalim ke okova thaj okova manuš, thaj phenen lešće: ‘O učitelj phenel: Mungri vrjama si paše. Tute slaviva e pasha mungre učenikonenca.’” ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","E učenikurja ćerdine sar phendas lenđe o Isus thaj pripremisardine e pashalno večera. ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","A kana peli e rjat, o Isus sas pale sinija e dešuduje učenikonenca. ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Dok hanas vo phendas lenđe: “Čače phenav tumenđe, jek tumendar izdaila man.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Von zurale ražalostisajle thaj jek pale avreste počnisardine te phučen les: “Te naj sem možda me Gospode?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","A vo phendas lenđe: “Okova savo bolel o mangro manca ando čaro, godova izdaila man. ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Vi čače me, o Čhavo e Manušesko, moraš te merav sago kaj ramol ando Sveto lil. Ali teško okolešće savo izdail man, e Čhaves e Manušešće! Majlačhe avilosas lešće te či ni bijandilosas!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","A lesko izdajniko o Juda phučla: “Te naj sem me godova, učiteljina?” A o Isus phendas lešće: “Korkoro phenes.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Dok hanas o Isus lija o mangro, zahvalisarda pale leste thaj phagla les, askal dijas pire učenikonenđe thaj phendas: “Len, thaj han akava si mungro telo.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Askal lijas o tahtaj mol, zahvalisarda e Devlešće pa dijas e učenikonenđe thaj phendas: “Pijen andar leste savora, ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","kaj akava si mungro rat, o rat savo utemeljil o savezo, thaj čhordol pe pale butende te jartonpe lenđe bezeha. ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Thaj phenav tumenđe: či majbut pijava mol sa dži ke okova đes kana pijava tumenca nevi mol ando carstvo mungre Dadesko.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Askal đilabadine e psalmurja thaj uputisajle ande Maslinsko gora. ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Askal o Isus phendas lenđe: “Arjat savora tumen mućena man, kaj ando Sveto lil ačhel ramome: ‘Dava dab e pastire thaj e bakhre andar o stado našena.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ali kana uštava andar e mule, džava angle tumende ande Galileja.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","A o Petar phendas lešće: “Te mukline tut savora, me nisar či mukava tut!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","A o Isus phendas lešće: “Čače phenav tuće, još akaja rjat, majsigo nego so o bašno zakukuričil, trin drom hohaveja kaj či pindžares man.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","O Petar phendas lešće: “Te trubul vi te merav tusa, me nisar či mukava tut.” A gajda phendine vi e sa aver učenikurja. ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Askal o Isus đelo e učenikonenca po than savo akhardolas Getsimanija, thaj phendas lenđe “Bešen akate dok me džav inća te molima.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Lijas pesa e Petre thaj e liduj Zevedejevešće čhaven, thaj astarda les e žalost thaj o pharipe. ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Askal phendas lenđe: “Mungri duša si žalosno dži ko smrto. Ačhen akate thaj aven džungade manca.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Askal đelotar cara majdur lendar, thaj pelo e mujesa dži ke phuv thaj molisajlo e alavenca: “Dade mungreja, te šaj, te naćhel man akava tahtaj patnje! Ali neka či avel mungri volja, nego ćiri volja.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Askal bolda pe ke trin učenikurja thaj arakhla len sar soven, thaj phendas e Petrešće: “Gajda askal, našti ačhiline džungade manca ni jek sato! ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ačhen džungade thaj molin tumen te či peren ande kušnje! Kaj o duho kamel te ćerel okova so si lačhe ali o telo si slabo.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Askal po dujto drom palem đelotar lendar thaj molisajlo e alavenca: “Dade mungreja, ako naj moguće te naćhel man akava tahtaj patnje, neka avel ćiri volja.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","A kana bolda pe palem arakhla len sar soven. Lenđe jakha korkoro phandadonas. ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Palem mukla len thaj đelo po trito drom te molil pe iste alavenca. ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Askal bolda pe ke učenikurja thaj phendas lenđe: “Još soven thaj odmorin tumen? Ake, avili e vrjama kana me, o Čhavo e Manušesko, avava dino ande vas e bezehalenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ušten! Hajde te džastar! Kaj, ake akate si okova savo izdaila man!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Dok o Isus još ćerelas svato, areslo o Juda, jek katar e dešuduj učenikurja. A lesa avilo vi o but o them e mačonenca thaj e rovljenca, saven bičhaldine e šorvale rašaja thaj e themešće starešine. ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","A e Isusesko izdajniko dogovorisajlo lenca kaj dela len znako. Phendas lenđe: “Saves čumidava, godova si. Les astaren.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Vo odma avilo dži ko Isus thaj phendas lešće: “Zdravo, učiteljina!” thaj čumida les. ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","A o Isus phendas lešće: “Drugarina, ćer godova pale soste avilan!” Askal e manuša aviline dži ko Isus, čhutine e vas pe leste thaj astardine les. ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Thaj ande data jek katar okola save sas e Isuseja astarda pe palo mačo, inkalda les thaj peklas lesa e bare rašaješće sluga thaj čhinda lesko kan. ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Askal o Isus phendas lešće: “Bolde ćiro mačo pe lesko than, kaj svako ko astarel pe palo mačo, katar o mačo vi merela. ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Zar či haćares kaj šaj te zamoliv mungre Dade thaj vo odma bičhaldas manđe majbut milje anđelurja? ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ali te ćerdem godova, sar askal pherdilesas e Svete lila, save phenen kaj gajda moraš te avel?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Askal phendas e themešće: “Teljardine pe mande e mačonenca thaj e rovljenca sago po razbojniko! Svako đes bešavas ando Hramo thaj sikavavas, pa ipak či astardine man. ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ali, sa akava trubul te avel te pherdol okova so e prorokurja majsigo ramosardine pale mande.” Askal godova sa e učenikurja mukline les thaj našline. ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Okola save astardine e Isuse inđardine les ko baro rašaj o Kajafa, ke savo ćidine pe e učitelja e zakonestar thaj e starešine. ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","A o Petar dadural džalas pale leste dži ke avlija e bare rašaješći, pa dijas andre ande avlija thaj bešlo e slugenca te dićhel so avela. ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","E šorvale rašaja thaj sasto baro veće rodenas hohavne dokazurja protiv o Isus sar šaj te mudardinesas les. ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ali či arakhline len vi ako pojavisajle e but e hohavne svedokurja. Napokon aviline duj džene ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","thaj phendine: “Akava phendas: ‘Me šaj haravav o Hramo e Devlesko thaj pale trin đes palem te vazdav les.’” ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Askal uštilo o baro rašaj thaj phučla e Isuse: “Khanči či pheneja pe akava so phenen protiv tute?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","A o Isus samo ačhelas. A o baro rašaj phendas lešće: “Dav tut solah e džude Devlesa te phenes amenđe dali san tu o Hristo, e Devlesko Čhavo?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","A o Isus phendas lešće: “Tu korkoro phenes. Thaj još phenav tumenđe kaj katar akana dićhena man, e Čhave e Manušešće, sar bešav pe desno rig e Svemoćno Devlešće thaj avav pe nebeske oblakurja.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Pe godova o baro rašaj pharadas pe peste o ogrtači thaj phendas: “Hulil po Del! So trubul amen još svedokurja. Ake, akana ašundine lešći hula! ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","So gndin?” A von phendine: “Zaslužisardas smrto!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Askal čhungarenas e Isuse po muj thaj denas les dab e dumukhenca. A aver denas les dab e palmenca po muj ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","thaj phenenas: “Prorokuisar amenđe, Hriste, ko dija tut dab!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Dok o Petar bešelas avri ande avlija, avili dži leste varesavi sluškinja thaj phendas: “Vi tu sanas e Isuseja andar e Galileja!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","A o Petar angle savorende hohadas: “Či džanav so phenes!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","A kana đelo prema e kapija, dikhla les jek aver sluškinja, thaj phendas okolenđe save sas okote: “Vi akava sas e Isuseja andar o Nazaret!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Vo palem hohadas thaj još hala solah: “Či pindžarav godole manušes!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","A cara pale godova aviline dži leste e manuša save sas okote thaj phendine: “Pa tu san čače jek lendar! Izdail tut o galilejsko naglasko.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Askal o Petar počnisarda te hal solah e alavenca: “Hav solah kaj či pindžarav godole manušes!” Thaj odma zakukuričisarda o bašno. ");
INSERT INTO rmyChergash_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Vo askal dija pe gođi so phendas lešće o Isus: “Majsigo nego so o bašno zakukuričil, trin drom hohaveja kaj či pindžares man.” Inkljisto andar e avlija thaj zurale rujas. ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Detharinako rano sa e šorvale rašaja thaj e themešće starešine dogovorsajle te mudaren e Isuse. ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Phangline les, inđardine thaj predaisardine les ko Pilato savo sas rimsko upravniko. ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Kana o Juda, e Isusesko izdajniko, dikhla kaj e Isuse osudisardine po smrto, zažalisarda thaj inđardas e trijanda rupune kovanice palpale te boldel len e šorvale rašajenđe thaj e starešinenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Askal phendas lenđe: “Ćerdem doš! Izdaisardem e manušes savo naj došalo pale khančeste!” A von askal phendine lešće: “So amen hal briga pale godova? E doš perela pe tute!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Pe godova o Juda čhuda e rupune kovanice ande svetinja e hramošći, askal đelo thaj ungladilo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","E šorvale rašaja ćidine e rupune kovanice thaj phendine: “O zakono či mućel amenđe te čhas akala love ande hramsko blagajna, kaj si ratvale love.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Askal dogovorisajle thaj pale godola love ćindine e Lončarešći njiva, te avel limorja pale strancurja. ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Zato godoja njiva vi akana akhardol “Ratvali njiva.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Gajda pherdilo okova so sas phendo preko proroko Jeremija: “Line trijanda rupune kovanice pale leste kaj gadići varesave katar e Izraelcurja phendine kaj lesko trajo mol, ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","thaj godole lovenca ćindine e Lončarešći njiva, sago kaj o Gospod zapovedisardas manđe.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","O Isus ačhilo anglo rimsko upravniko savo bučholas Pilato. Vo phučla les: “Dali san tu o caro e Židovengo?” A o Isus phendas lešće: “Tu korkoro phenes.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","E šorvale rašaja prnas e Isuse vi palo but aver bilačhipe, ali o Isus khanči či motholas. ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Askal o Pilato phučla les: “Zar či ašunes so sa svedočin protiv tute?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ali o Isus či delas lešće odgovor niti jeće alaveja, zato o Pilato zurale začudisajlo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","A e upravniko sas običaj te po prazniko e Pasha mućel pe sloboda jećhe phangle manuše saves o them manglasas. ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Baš ande godoja vrjama ando phanglipe inćarenas jećhe manuše savo sas pindžardo kriminalaco savo akhardolas Varava. ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kana o them ćida pes, o Pilato phučla len: “Kas kamen te mukav tumenđe: e Varava ili e Isuse savo akhardol Mesija?” ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","O Pilato džanelas kaj e Isuse predaisardine zato kaj sas ljubomorne pe leste. ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Dok o Pilato bešelas pe sudačko stolica, avili lešće e poruka katar lešći romnji: “Inćar tut majdur katar godova pravedno manuš kaj arjat but namučisajlem ando suno zbog leste!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","A e šorvale rašaja thaj e starešine pherenas o šoro e themešće te roden te mućel lenđe e Varava, a Isuse te mudaren. ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","A o upravniko phučla e themes: “Kas katar akala duj džene kamen te mukav tumenđe?” Von phendine: “E Varava!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","A o Pilato phučla len: “A so te ćerav e Isuseja savo akhardol Hrist?” A von čhonas muj “Razapnisar les!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","A o Pilato phučlas: “Sostar? Savo bilačhipe ćerda?” Ali o them još majzurale čholas muj: “Razapnisar les!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Kana o Pilato dikhla kaj godoja rasprava či džal nikaj, nego još majbari buna vazdel pe, lijas paj thaj anglo them thoda pire vas thaj phendas: “Me naj sem došalo palo rat akale manušesko – e doš perela pe tumende!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Pe godova sa o them phendas: “Neka lesko rat perel pe amende thaj pe amare čhavra!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","O Pilato askal mukla lenđe e Varava, a e Isuse dijas te maren e bičosa thaj te razapnin les. ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","E Pilatošće vojnikurja inđardine e Isuse ande bari palata thaj ćidine pes pe leste sasti četa vojnikurja. ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Askal čhudine lestar e drze thaj dine pe leste lolo ogrtači sago kaj inđaren e carurja. ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Khudine kruna katar e kangre thaj čhutine pe lesko šoro, a ande lesko desno vas čhutine trska sago caresko žezlo. Dine koča angle leste, marenas muj lestar thaj mothonas: “Nek trajil o caro e Židovengo!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Askal čhungarenas pe leste thaj marenas les e trskava po šoro. ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Kana ačhile te maren muj lestar, čhudine lestar o ogrtači thaj dine pe leste lešće drze. Askal inđardine les te razapnin les. ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Dok inđarenas les te razapnin les, dromesa maladine varesošće manuše andar e Kirina savo akhardolas Simon, thaj les tradine te inđarel e Isusesko trušul. ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Kana aviline dži ko than savo akhardolas Golgota (so značil “o than lobanja”), ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","dine e Isuse te pijel mol hamime e fajrasa, ali kana lija ando muj či kamlas te pijel. ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kana razapnisardine les, podelisardine lešće drze maškar pende gajda kaj čhudenas kocka pale lende. ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Askal bešline okote thaj lenas sama pe leste. ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Opre angle lesko šoro čhutine lešće tabla pe savi sas ramome lešći doš: “Akava si o Isus, caro e Židovengo.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Askal zajedno lesa razapnisardine vi duje razbojnikonen, jećhe pe lešći desno rig, a avres pe lešći levo rig. ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","A okola save naćhenas okotar vređonas les thaj ćerenas e šoresa ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","thaj mothonas: “Tu savo haraves e svetinja e hramošći thaj vazdes lat ande trin đesa, spasisar korkoro tut! Fulji katar o trušul, ako san Čhavo e Devlesko!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Isto gajda vi e šorvale rašaja, e učitelja e Mojsiješće zakonestar, thaj e starešine, marenas muj lestar thaj phenenas: ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Spasisardas avren, a korkoro pes našti te spasil! Vo si caro e Izraelosko! Pa neka akana fuljel katar o trušul, askal amen paćasa ande leste! ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Paćalas ando Del, pa neka akana o Del spasil les ako kamel! Kaj phenelas: ‘Me sem o Čhavo e Devlesko.’” ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Isto gajda vređonas les vi e razbojnikurja save sas lesa razapnime. ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","A katar o mismeri dži ko trito sato palo mismeri o tunjariko učharda e sasti phuv. ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","A katar o trito sato o Isus čhuta muj andar sasto glaso: “Eli, Eli, lama sabahtani?” (so značil “Devla mungreja, Devla mungreja, sostar muklan man?”). ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","A kana varesave manuša save ačhenas okote ašundine godova, phendine: “Akava akharel e prorokos Ilija!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Jek lendar odma prastaja, lijas o sunđer, bolas les ando šut, čhuta pe trska, thaj ponudisardas e Isuse te pijel. ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","A aver phenenas: “Ačh, te dikhas dali avela o Ilija te spasil les.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","A o Isus palem čhuta muj andar sasto glaso, thaj mukla pesko đi. ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Pe godova e firanglje ande svetinja e hramošći pharadile pe opaš, katar opral dži tele. E phuv ćhinosajli, a e bare bara pharle. ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","E limorja putajle, thaj e telurja e bute svete manušendar uštile andar e mule. ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Pale godova kana o Isus uštilo andar e mule von inkljistine andar pire limorja thaj đele ando sveto gav Jerusalim thaj sikadine pes e bute manušenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kana dikhla o rimsko kapetano thaj okola save lenas sama po Isus kaj e phuv činosajli thaj sa so dogodisajlo, astarda len e bari dar thaj phendine: “Akava manuš sas čače Čhavo e Devlesko!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","A sas okote vi e but manušnja save sa godova dićhenas dadural. Von pratinas e Isuse andar e Galileja thaj služinas lešće. ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Maškar lende sas e Marija andar e Magdala, e Marija e dej e Jakovešći thaj e Josifešći thaj e dej e Zevedejevešće čhavenđi. ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","A kana peli e rjat, avilo varesavo barvalo manuš andar o gav e Arimateja, savo akhardolas Josif. Vo vi korkoro sas e Isusesko učeniko. ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Vo đelo ko Pilato thaj manglas e Isusesko telo, a o Pilato zapovedisarda te den les. ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","O Josif lijas o telo e Isusesko thaj paćarda les ande nevo fino pohtan, ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","askal čhuta o telo ando piro nevo limori savo sas ćerdo ande stena. Thaj spidas o baro bar po vudar e limoresko thaj đelotar. ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","A e Marija andar e Magdala thaj e aver Marija bešenas okote thaj dićhenas karingal o limori. ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Thejara o đes, ando savato, ćidine pe e šorvale rašaja thaj e fariseja ko Pilato, ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","thaj phendine lešće: “Gospodarina, dijam men gođi kaj okova hohamno, dok sas još džudo phendas. ‘Pale trin đesa uštava andar e mule.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Zato naredisar te lel pe sama po limori, dži ko o trito đes, te na aven lešće učenikurja thaj čoren lesko telo, a askal phenen e themešće: ‘Uštilo andar e mule!’ Te avilo gajda godova poslednjo hohaipe avela majbaro nego okova prvo!” ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","A o Pilato phendas lenđe: “Si tumen stražarja. Džan thaj len sama po limori majlačhe sar džanen.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Askal đele, čhutine pečato po bar thaj čhutine straža. ");
INSERT INTO rmyChergash_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Posle o savato, ande zora savo sas prvo đes ando kurko, avili e Marija andar e Magdala thaj e aver Marija te dićhen o limori. ");
INSERT INTO rmyChergash_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Thaj katar jekhvar sas o baro potres, kaj e Gospodesko anđelo fuljisto andar o nebo, avilo dži ko limori, spidas o bar katar o vudar e limoresko thaj bešlo pe leste. ");
INSERT INTO rmyChergash_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","A vo sijalas sago munja, thaj e drze pe leste sas parne sago o iv. ");
INSERT INTO rmyChergash_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","E stražarja izdranas e daratar thaj peline ando nesvest kana dikhline les. ");
INSERT INTO rmyChergash_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Askal o anđelo phendas e manušnjenđe: “Tumen na daran! Kaj džanav kaj roden e Isuse savo sas razapnime. ");
INSERT INTO rmyChergash_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ali vo naj akate! Uštilo andar e mule sago kaj vi phendas tumenđe! Aven te dićhen o than kaj pašljolas, ");
INSERT INTO rmyChergash_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","pa sigo džan thaj phenen lešće učenikonenđe: ‘Uštilo andar e mule thaj akana džal angle tumende ande Galileja. Okote dićhena les.’ Ake so sas man phendem tumenđe.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Pherde dar ali vi bahtale, e manušnja sigo teljardine katar o limori thaj prastajine te javin godova lešće učenikonenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Katar jekhvar angle lende avilo o Isus thaj phendas lenđe: “Zdravo!” Von avile majpaše leste, astardine lešće pungre thaj poklonisajle lešće. ");
INSERT INTO rmyChergash_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Askal o Isus phendas lenđe: “Na daran! Džan thaj javin mungre phralenđe te džan ande Galileja. Okote dićhena man.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Dok e manušnja sas po drom karingal e učenikurja, varesave katar e stražarja đele ando gav thaj phendine e šorvale rašajenđe sa so dogodisajlo. ");
INSERT INTO rmyChergash_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Askal e šorvale rašaja sastaisajle e starešinenca thaj dogovorisajle te den e vojnikonenđe but love. ");
INSERT INTO rmyChergash_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Thaj phendine lenđe: “Phenen, ‘Arjat dok amen sovasas aviline e Isusešće učenikurja thaj čordine les.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","A te pale akava ašunel o upravniko, amen ćerasa lesa svato te tumen či avel problemurja.” ");
INSERT INTO rmyChergash_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","E vojnikurja line e love thaj ćerdine sago kaj sas lenđe phendo. Gajda akava svato buljilo maškar e Židovurja thaj zadržisajlo sa dži ađes. ");
INSERT INTO rmyChergash_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","E dešujek učenikurja đeletar ande Galileja, pe gora, pe savi naredisarda lenđe o Isus te džan. ");
INSERT INTO rmyChergash_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Kana dikhline e Isuse, poklonisajle lešće. Ali varesave lendar palem posumnjisardine. ");
INSERT INTO rmyChergash_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Askal o Isus avilo dži lende thaj phendas: “Dini si manđe sa e vlast po nebo thaj pe phuv. ");
INSERT INTO rmyChergash_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Zato džan thaj ćeren sa e themen te aven mungre učenikurja! Bolen len ando alav e Dadesko thaj e Čhavesko thaj e Sveto Duhosko, ");
INSERT INTO rmyChergash_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","thaj sikaven len te inćaren sa so zapovedisardem tumenđe. Ake me sem tumenca ande sa e đesa, sa dži ko krajo e themesko.”");
INSERT INTO rmyChergash_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Akava si početko e Bahtale nevimatako katar o Isuso Hristo, Čhavo e Devlesko. ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Sago kaj ramol ando Sveto lil e prorokosko Isaijasko: “Ake, me bičhalav angle tute mungre glasnikones thaj vo lačharela o drom angle tute. ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Vo si o glaso savo čhol muj ande pustinja: ‘Pripremin o drom palo Gospod, vorton e staze pale leste!’” ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Gajda avilo o Jovano savo bolelas ande pustinja thaj propovedilas kaj e manuša trubun te obratin pe e Devlešće te jartol lenđe e bezeha thaj te bolen pe. ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Avenas leste e but manuša andar e sasti Judeja thaj savora andar o Jerusalim, priznainas pire bezeha, a vo bolelas len ande reka jordanošći. ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Po Jovano sas drze katar e kamilaće bal, a sas les oko maškar morćhaći haravlji. Halas skakavcurja thaj o divljo medo. ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Vo propovedilas: “Pale mande avel jek majmoćno mandar. Me naj sem dostojno ni te banđijav te putarav e haravlje pe lešće sandale. ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Me bolav tumen e pajesa, a vo bolela tumen e Sveto Duhosa.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ande godoja vrjama avilo o Isus andar o Nazaret ande Galileja thaj o Jovano bola les ande reka e Jordanošći. ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Čim o Isus inkljisto andar o paj, dikhla o putardo nebo thaj e Sveto Duho sar sago golubo fuljel pe leste. ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","A katar o nebo ašundilo o glaso: “Tu san mungro volime Čhavo! Tu san mungri bah.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Thaj odma o Duho bičhaldas e Isuse ande pustinja. ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Okote o Isus ačhilo štarvardeš đesa, a o Sotona probilas les po bezeh. Sas maškar e divlje životinje, a e anđelurja služinas lešće. ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Nakon so o Jovano sas čhudino ande tamnica, o Isus đelo ande Galileja thaj propovedilas e Devlešći Bahtali nevimata. ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Motholas: “Avilo o časo! Paše si e Devlesko carstvo! Pokajin tumen thaj paćan ande Bahtali nevimata!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Dok o Isus naćhelas pašo Galilejsko more, dikhla e Simone thaj lešće phrale e Andrija, sar čhuden e mreže ando more, kaj von sas ribarja. ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","O Isus phendas lenđe: “Aven pala mande thaj me ćerava tumendar ribarja save astarena manušen sago e mačhen!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Thaj von odma mukline pire mreže thaj teljardine pale leste. ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Kana đelo cara majdur, dikhla e Jakove e Zevedejevešće čhaves thaj lešće phrales e Jovano sar ande lađica lačharen pire mreže. ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","O Isus odma akharda len, thaj von mukline ando čamco pešće dades e Zevedejes e manušenca save ćerenas bući lende, thaj đele pale leste. ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Thaj avile ando Kafarnaum, o Isus ando savato dija ande sinagoga thaj teljarda te sikavel e theme. ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","O them čudilas pe lešće sikavipešće, kaj sikavelas sago okova saves si autoriteto, a na sago e učitelja e Mojsiješće zakonestar. ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Askal okote ande lenđi sinagoga sas jek manuš ande savo sas o bilačho duho thaj katar jekhvar ačhilo te čhol muj thaj te mothol: ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“So kames amendar, Isuse andar o Nazaret? Avilan te uništis amen? Džanav ko san: Sveco e Devlesko!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","A o Isus oštro phendas lešće: “Phandav ćiro muj thaj inklji andar leste!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Askal o bilačho duho zurale ćhinosarda e manušes thaj e riknjimava andar o sasto glaso inkljisto andar leste. ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Savora sas but začudime, thaj phučenas jek avres: “So si akava? Sosko si akava nevo thaj silno sikavipe. Vo čak vi e bilačhe duhonenđe zapovedil thaj von pokorin pe lešće!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Thaj o glaso pale leste odma ašundilo pe sasti okolina e Galilejaći. ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Čim inkljistine andar e sinagoga, đele e Jakoveja thaj e Jovanova ando ćher e Simunesko thaj e Andrijasko. ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","A e Simunošći sokra pašljolas nasvali ande groznica, pa čim aresline odma mothodine Isusešće pale late. ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","O Isus avilo dži late, lija lat palo vas thaj vazda lat. A e groznica nakhli latar thaj voj poslužilas len. ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Tale rjat, kana mukla pe o kham, anenas leste sa e nasvalen thaj okolen ande save sas e bilačhe duhurja. ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","O sasto gav ćida pe anglo vudar. ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Thaj o Isus sastardas e bute nasvalen katar o razno nasvalipe. Trada e bute bilačhe duhonen andar e manuša, ali či mućelas e bilačhe duhonenđe te ćeren svato kaj džanenas ko si vo. ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Rano detharinako, dok sas još o tunjariko, o Isus uštilo, inkljisto thaj đelo pe jek pusto than thaj okote molilas pe. ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","A o Simon thaj okola aver kaj sas lesa svugde rodenas les. ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Thaj kana arakhline les, phendine lešće: “Savora roden tut!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","A o Isus phendas lenđe: “Hajde džastar varekaj pe aver pašutne gava te vi okote propovediv, kaj me zbog godova avilem.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Gajda džalas pe sasti Galileja, propovedilas ande lenđe sinagoge thaj tradelas andar e manuša e benđen. ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Jek gubavco avilo ko Isus thaj počnisarda pe koča te molil les: “Te kames šaj te sastares man katar e guba!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","O Isus sažalisajlo, inzarda pesko vas pe leste thaj phendas: “Kamav, av sasto!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Thaj e guba odma peli lestar thaj vo sastilo. ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","O Isus askal odma naredisarda lešće te džaltar thaj strogo phendas lešće: ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Le sama te na ćeres svato khonikašće pale akava, nego dža thaj sikav tut e rašaješće thaj prinesisar pale ćiro šilaipe okova so Mojsije odredisardas palo svedočanstvo lenđe.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ali o manuš, samo so đelotar lestar, ačhilo savorenđe te mothol so dogodisajlo lešće, zbog godova o Isus našti majbut delas javno ando gav, nego moraš te ačhelas pe puste thana. A e manuša avenas leste katar sa e riga. ");
INSERT INTO rmyChergash_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Varekozom đesa majposle, kana o Isus palem dijas ando Kafarnaum, ašundilo kaj si o Isus ćhere, ");
INSERT INTO rmyChergash_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","pa ćida pe gadići them kaj nas than čak ni anglo vudar. A o Isus propovedilas lenđe o Alav e Devlesko. ");
INSERT INTO rmyChergash_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Askal avile dži ko Isus varesave štar džene, save anenas leste e nepokretne manušes. ");
INSERT INTO rmyChergash_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ali, sar katar o but o them našti inđardine les andre ando ćher dži ko Isus, ćerdine hv po krovo opral po than kaj ačhelas o Isus pa mukline e nasvale kroz e hv pe nosilje maškare anglo Isus. ");
INSERT INTO rmyChergash_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Kana o Isus dikhla lengo paćipe, phendas e line manušešće: “Čhaveja, jartonpe tuće ćire bezeha!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","A okote bešenas varesave učitelja e Mojsiješće zakonestar thaj ande peste gndinas: ");
INSERT INTO rmyChergash_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Sostar akava gajda ćerel svato? Vo vređol e Devle! Ko šaj te jartol e bezeha osim o jedino Del?” ");
INSERT INTO rmyChergash_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","A o Isus odma džanglas ande pesko duho kaj von gajda gndin thaj phučla len: “Sostar gajda gindin? ");
INSERT INTO rmyChergash_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","So si majloće te phenel pe akale nepokretne manušešće: ‘Jartome si tuće e bezeha’ ili ‘Ušti! Le ćiri nosila thaj dža’? ");
INSERT INTO rmyChergash_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ali dokaživa tumenđe kaj man, e Čhaves e Manušešće, si vlast pe phuv te jartov e bezeha.” Askal bolda pe ko manuš thaj phendas: ");
INSERT INTO rmyChergash_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Tuće phenav: Ušti, le ćiri nosila thaj dža ćhere.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Thaj o manuš uštilo, odma lijas e nosilja thaj angle savorende inkljisto avri. A savora sas zadivime thaj počnisardine te slavin e Devle, e alavenca: “Gajda vareso još či dikhlam!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","O Isus palem đelo pe obala e jezerošći. A but o them avilo dži leste thaj vo sikavelas len. ");
INSERT INTO rmyChergash_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Sar naćhelas okotar, dikhla e Levije, e Alfejevešće čhave, sar bešel po than kaj poćinelas pe o porezo thaj phendas lešće: “Av pala mande.” Vo uštilo thaj teljardas pala leste. ");
INSERT INTO rmyChergash_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Dok o Isus halas ande Levijesko ćher, lesa thaj lešće učenikonenca hanas vi e but carinikurja thaj e bezehale, kaj sas but okola save džanas pale leste. ");
INSERT INTO rmyChergash_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","A kana varesave učitelja e Mojsiješće zakonestar, save sas fariseja dikhline kaj o Isus hal e bezehalenca thaj e carinikonenca, phučline lešće učenikonen: “Sostar tumaro učitelj hal e carinikonenca thaj e bezehalenca?” ");
INSERT INTO rmyChergash_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","O Isus godova ašundas, thaj phendas lenđe: “Naj e sastenđe potrebno o doktori, nego e nasvalenđe. Me či avilem te akharav te pokajin pe e pravednikurja, nego e bezehale.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","E učenikurja e Jovanošće savo bolelas thaj e fariseja postinas. Varesave manuša aviline ko Isus, thaj phučline les: “Sostar e Jovanošće thaj e farisejenđe učenikurja postin, a ćire učenikurja či postin?” ");
INSERT INTO rmyChergash_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","O Isus phendas lenđe: “Šaj li e svaturja te postin dok si o mladoženja lenca? Sa dok si o mladoženja lenca von našti te postin. ");
INSERT INTO rmyChergash_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ali, avela e vrjama kana otmina lendar e mladoženja. Askal von postina. ");
INSERT INTO rmyChergash_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Khonik či suvel nevo kotor katar o platno pe purani haljina. Kaj te ćerda godova, kana thovela e haljina o nevo kotor ćidela pe thaj pharavela e haljina thaj avela još majbari hv. ");
INSERT INTO rmyChergash_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Khonik či čhol e nevi mol ande purane morćhaće trjaste kaj kana e mol počnila te del vras e purane morćhaće trjaste pharona, a e mol čhordola pe thaj gajda avena uništime vi e morćhaće trjaste vi e mol. Zato e nevi mol čhol pe ande neve morćhaće trjaste.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Kana o Isus jek savato naćhelas kroz e njive e đivesa, lešće učenikurja počnisardine e dromesa te trgon o điv. ");
INSERT INTO rmyChergash_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Kana e fariseja dikhline godova phendine e Isusešće: “Dik! Ćire učenikurja ćeren savatone, okova so po zakono naj muklo te ćerel pe savatone.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ali o Isus phendas lenđe: “Sigurno čitosardine ando Sveto lil so o David ćerda, kana vo thaj okola save sas lesa bokhajle, a nas len so te han. ");
INSERT INTO rmyChergash_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Sas godova ande vrjama e Avijatarešći e šorvale rašaješći. O David dijas ande Devlesko ćher thaj halas e posvetime mangre save sas prinesime e Devlešće. A khonik osim e rašaja, či tromanas te han godola mangre, a o David još podelisarda okolenca save sas lesa.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Askal phendas lenđe: “O savato si stvorime te služil e manušešće, a na o manuš e savatošće. ");
INSERT INTO rmyChergash_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Dakle me, o Čhavo e Manušesko, sem Gospodari vi e savatosko.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Kana o Isus palem dija ande sinagoga, okote sas jek manuš e šuće vastesa. ");
INSERT INTO rmyChergash_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Varesave andar e sinagoga inćarenas e jakha pe leste te dićhen dali sastarel lat ando savato te došaren les. ");
INSERT INTO rmyChergash_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","O Isus askal phendas e manušešće e šuće vastesa: “Ušti thaj av akate maškare!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Askal phučla e aver manušen: “Dali tromal pe savatone te ćerel pe lačhipe ili bilačhipe, o trajo te spasil pe ili te mudarelpe?” Ali von khanči či mothonas. ");
INSERT INTO rmyChergash_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","O Isus ande holji dikhla pe lende thaj sas zurale žalosno zbog lenđe barune ile, askal phendas e manušešće: “Inzar ćo vas.” Vo inzarda pesko vas thaj lesko vas sas palem sasto. ");
INSERT INTO rmyChergash_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Askal e fariseja inkljistine thaj odma e Irodešće manušenca dogovorinas pe sar te mudaren e Isuse. ");
INSERT INTO rmyChergash_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","O Isus pire učenikonenca crda pe po Galilejsko jezero, a pala leste teljardas o but o them andar Galileja thaj andar e Judeja, ");
INSERT INTO rmyChergash_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","andar o Jerusalim, thaj andar e Idumeja, katar okoja rig e reka Jordanošći, thaj vi andar e okolne thana pašo Tiro thaj pašo Sidon. Sa godova but them avelas leste, zato kaj ašundine sa so vo ćerelas. ");
INSERT INTO rmyChergash_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","A kana o Isus dikhla e silno themes kaj avel leste, phendas pire učenikonenđe, te avel o čamco spremno sar či avilosas zgnječime maškar o them, ");
INSERT INTO rmyChergash_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","kaj već e bute manušen sastardas, thaj e nasvale manuša ispidenas pe te dotaknin les thaj te saston. ");
INSERT INTO rmyChergash_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kana e manuša ande save sas e bilačhe duhurja dićhenas e Isuse, perenas pe koča angle leste thaj čhonas muj: “Tu san o Čhavo e Devlesko!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","A o Isus strogo phenelas lenđe te na mothon ko si vo. ");
INSERT INTO rmyChergash_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Askal o Isus đelo pe gora thaj akhardas o kolen saven vo kamlas, thaj von aviline leste. ");
INSERT INTO rmyChergash_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Lendar losarda dešudujen – save još akhardas apostolurja – te aven lesa thaj te bičhalel len te propovedin ");
INSERT INTO rmyChergash_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","thaj te avel len vlast te traden e benđen. ");
INSERT INTO rmyChergash_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Akala si e alava e dešudujengo saven o Isus losarda: o Simon, saves akhardas Petar, ");
INSERT INTO rmyChergash_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","o Jakov e Zevedejevesko čhavo thaj o Jovan o phral e Jakovesko saven akharda Voanirges, so značil “čhave e gromošće” ");
INSERT INTO rmyChergash_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","o Andrija, o Filip, o Vartolomej, o Matej, o Toma, o Jakov čhavo e Alfejevesko, o Tadej, o Simun pobunjeniko, ");
INSERT INTO rmyChergash_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","thaj o Juda Iskariot savo izdaisarda e Isuse. ");
INSERT INTO rmyChergash_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Askal o Isus dijas ando ćher kaj bešelas, a okote palem ćida pes gaći but them kaj našti ni mangro hanas. ");
INSERT INTO rmyChergash_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kana pale godova ašunda lešći dej thaj lešće phral avile pale leste te inđaren les, kaj gndinas kaj vo naj dži peste. ");
INSERT INTO rmyChergash_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","A e učitelja e Mojsiješće zakonestar save avile andar o Jerusalim phenenas: “O Veelzevul, o vladari e benđengo si ande leste, thaj lešće silava izgonil e benđen.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Pe godova o Isus akharda len peste thaj motholas lenđe ande prispodoba: “Sostar o Satana izgonisardasas e Satanes? ");
INSERT INTO rmyChergash_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ako si varesavo carstvo ande peste podelime, našti te održila pes. ");
INSERT INTO rmyChergash_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Thaj te ande varesavo ćher e familija ačhel jek protiv avreste, godoja familija našti održila pes. ");
INSERT INTO rmyChergash_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Thaj te o Satana uštilo korkoro protiv peste thaj razdelil pes, askal našti ačhel, nego avilo lesko krajo. ");
INSERT INTO rmyChergash_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ali khonik našti del ando ćher e zurale manušesko te otmil lešće stvarja, a te majsigo či phandel les. Tek askal šaj otmil e stvarja andar lesko ćher. ");
INSERT INTO rmyChergash_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Čače phenav tumenđe: E manušenđe šaj avena jartome sa e bezeha thaj e bilačhe alava save mothon. ");
INSERT INTO rmyChergash_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ali ko god mothol bilačhe alava po Sveto Duho, godova bezeh či avel lešće jartome nikad, nego avela došalo pale sa e vrjama.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Akava phendas kaj e učitelja e Mojsiješće zakonestar mothonas: “O bilačho duho si ande leste.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ande godova aresline e Isusešći dej thaj lešće e phral. Dok ačhenas avri, bičhaldine leste jećhe manušes te akharel les. ");
INSERT INTO rmyChergash_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","A oko leste bešelas o but o them, thaj phendine lešće: “Ake avri roden tut ćiri dej thaj će phral.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Askal o Isus phučla len: “Ko si mungri dej thaj mungre phral?” ");
INSERT INTO rmyChergash_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Askal dikhla pe okola kaj bešenas oko leste ando krugo thaj phendas: “Ake akala si mungri dej thaj mungre phral! ");
INSERT INTO rmyChergash_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kaj ko god ćerel e Devlešći volja, godova si mungro phral, mungri phen thaj mungri dej.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","O Isus palem počnisarda te sikavel e themes pašo jezero. A o silno them ćida pe oko leste gajda kaj vo dija ande lađica po jezero thaj bešlo, a sa o them ačhelas pe obala. ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Thaj but godova sikavelas len kroz e paramiče. A dok sikavelas len, phendas: ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ašunen! Jek đes inkljisto o sejači te sejol. ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Dok sejolas, varesavo seme pelo po drom thaj avile e čiriklja thaj sa haline les. ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Aver seme pelo pe barutni phuv kaj nas but phuv thaj odma inkljisto kaj e phuv nas handuk. ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","A kana inkljisto o baro kham, phabilo thaj šućilo, kaj nas les handuk koreno. ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","A varesavo seme pelo ande kangre, a e kangre barile thaj tasadine les, pa o seme či bijanda plodo. ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","A varesavo seme pelo pe lačhi phuv, niknosardas, barilo thaj dija plodo savo sas trijanda, šovardeš, thaj čak vi šel drom majbut nego so sas posadime.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Askal phendas: “Ašunen kana već si tumen kan.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","A kana o Isus ačhilo korkoro, okola save sas oko leste thaj e dešuduj učenikurja phučline les so značin godola paramiče. ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","A o Isus phendas lenđe: “Tumenđe si dino te džanen e tajna pale Devlesko carstvo. A okolenđe save si avrjal e Devlešće carstvostar, sa phenav ande paramiče, ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","gajda kaj: ‘E jakhenca lačhe dićhen, ali či dićhena e dela mungre, e kanenca lačhe ašunen, ali či haćarena so phenav, te či obratin pe thaj te o Del či jartol lenđe.’ ” ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Askal o Isus phučla len: “Zar či haćaren akaja paramiči? Sar askal haćarena aver paramiče? ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","O sejači si okova manuš savo sejol e Devlešći poruka. ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Varesave manuša si sago o seme savo si posadime po drom, von si okola manuša save ašunen o alav e Devlesko, ali odma avel o Sotona thaj inđarel o alav e Devlesko savo sas posadime ande lende. ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","A varesave si sago o seme savo si posadime pe barutni phuv. Kana ašunen e Devlesko alav, odma prihvatin les e bahtasa, ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ali pošto o alav e Devlesko či astarda koreno ande lengo trajo, inćarenpe varesavi vrjama, pa kana aven e nevolje thaj o progon zbog e Devlesko alav, von odma peren katar o paćipe. ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","A varesave si sago o seme savo si posadime ande kangre. Godova si okola save ašunen e Devlesko alav, ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ali e brige akale themešće, o barvalipe savo si primamljivo thaj e aver požude tasaven o alav thaj o alav e Devlesko ačhel bi plodosko. ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","A varesave si posadime pe lačhi phuv. Godova si okola save ašunen o alav e Devlesko, primin o alav thaj anen plodo – varesave trijanda drom majbut, varesave šovardeš drom majbut a varesave šel drom majbut katar okova so sas posadime.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Askal o Isus phučla len: “Dali o stenko anen andre te čhon les talo čaro ili talo kreveto te garaven lesko svetlo? Nipošto! O stenko del pe jag te čhol pe po čirako. ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kaj, sogod si tajno, avela javno, thaj so god si garado, inkljela po videlo. ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ako varekas si kan, nek ašunel!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Thaj još phendas lenđe: “Len sama so ašunen. Save merasa merin, kasave merasa merila pe tumenđe thaj još dodaila pe tumenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Okoles kas si džanglipe, dela pe lešće još majbut, a okoles kas naj, lela pe lestar vi okova so sile.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","O Isus isto phendas lenđe: “E Devlesko carstvo si sago o manuš savo posadisardas o seme ande phuv. ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Raćava thaj e đesesa, dali sovel ili uštel, o seme niknil thaj barjol, a o manuš či džanel sar. ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","E phuv korkoro pestar anel pesko plodo: majsigo inkljel e stabiljka, o klaso, a askal o klaso pherdo điv. ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","A kana o điv paćol, o manuš odma lel o srpo, kaj avili e vrjama pale žetva.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Askal o Isus phendas lenđe: “Sova uporedisaras e Devlesko carstvo? Save paramičasa te objasnisaras les? ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Vo si sago o seme e gorušicako, majcikno katar sa o seme savo sejol pes pe phuv. ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ali kana sejol pe, barjol thaj avel majbaro katar sa e biljke ande bar, thaj mućel gajda bare ranja kaj e čiriklja šaj ćeren gnezdurja ande lesko hlado.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","O Isus phenelas kasave paramiče te sikavel e theme e Devlesko alav gaći kozom šaj ašunenas, ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","thaj bi e paramičengo khanči či phenelas lenđe. Ali kana sas korkoro pire učenikonenca, askal sa objasnilas lenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Isto godova đes kana peli e rjat, o Isus phendas pire učenikonenđe: “Džas pe okoja rig e jezerošći.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Mukline e theme thaj dine ande lađica ande savi već bešelas o Isus. A pale lende teljardine vi varesave aver manuša e lađicenca. ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Thaj vazda pe gajda bari oluja kaj e talasurja pherenas e lađica e pajesa. ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","A o Isus sas po paluno krajo e lađicako thaj sovelas po šerand. E učenikurja džungadine les thaj phendine: “Učiteljina, zar či hal tut e briga kaj tasadivas?” ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","O Isus uštilo thaj oštro phendas e bavlajaće thaj e jezerošće: “Ačh! Smiri tut!” E balval ačhili thaj sas bari tišina. ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Askal o Isus phendas e učenikonenđe: “Sostar gadići daran? Zar još naj tumen paćipe?” ");
INSERT INTO rmyChergash_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","A len lijas e bari dar, thaj phučenas jek avres: “Ko si akava te e balval thaj o jezero pokorin pe lešće.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Askal avile pe aver rig katar o jezero, ando gerasinsko krajo. ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Thaj samo so o Isus inkljisto andar e lađica, odma angle leste avilo andar e limorja jek manuš ande savo sas o bilačho duho. ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Akava manuš trajilas ande limorja thaj khonik majbut našti phandelas les čak ni ande lancurja. ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","But drom phandenas lešće vas thaj lešće pungre ande lancurja, ali vo trgolas e lancurja thaj phađelas e okurja pe pešće pungre, thaj khonik nas gaći zuralo te inćarel les. ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Stalno, e đesenca thaj e raćenca lutilas pe limorja thaj pe bregurja, rknjilas thaj pećelas korkoro pes e barenca. ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Kana dadural dikhla e Isuse, prastaja dži leste thaj pelo angle leste pe pešće koča, ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","thaj andar o sa glaso e rknjimava phendas: “So kames mandar, Isuse, Čhaveja e Majbare Devlesko? Dav tut solah e Devleja te na mučis man!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Kaj, o Isus već phendas lešće: “Bilačho duhona, inklji andar o manuš!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Askal phučla les: “Sar bučhos?” A vo phendas lešće: “Mungro alav si legija kaj sam but duhurja ande akava manuš sago vojska.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Thaj uporno molilas e Isuse te na tradel len andar godova krajo. ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","A okote po brego čarjolas o baro krdo bale, ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","thaj e bilačhe duhurja zamolisardine e Isuse: “Bičhal amen ande okola bale, te das ande lende.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","O Isus mukhla len thaj e bilačhe duhurja inkljistine andar o manuš thaj dine ande bale. Pe godova o sasto krdo varekaj katar duj milje bale, prastajine e bregostar ando more thaj tasadile. ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Pe godova e manuša kaj lenas sama pe bale našline ande pašutne gava thaj pe okolne thana thaj phendine pale akava so dikhline, thaj o them avelas te dićel so sas godova. ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Kana avile ko Isus, dikhline e manušes ande savo sas vojska benga, sar bešel furjardo ande drze thaj sar si sasto ande gođi. E dar askal dija pe lende. ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","A okola kaj lenas sama pe bale phendine lenđe sa so dogodisajlo e manušesa thaj e balenca, ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","thaj e manuša askal zamolisardine e Isuse te džaltar andar lengo krajo. ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kana o Isus delas ande lađica, okova manuš ande savo sas e bilačhe duhurja zamolisarda e Isuse te mućel les te džal lesa. ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ali o Isus či mukhla les, nego phendas lešće: “Bolde tut ćhere ke ćiri familija thaj phen lenđe so ćerda tuće o Gospod, thaj sošći bari milost dija tut.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","O manuš đelotar thaj ačhilo te ćerel svato po Dekapolis e themešće sa so o Isus ćerda lešće. Thaj savora sas zadivime. ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Kana o Isus palem nakhlas e lađicava pe aver rig e jezerošći, oko leste ćida pes o but them. Thaj dok sas vo još pašo jezero, ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","avilo leste jek vođa e sinagogako alavesa Jair, thaj kana dikhla e Isuse, pelo pe pešće koča angle lešće pungre e mujesa dži ke phuv ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","thaj zurale molilas les: “Mungri čhejori si po meripe. Av thaj čho ćire vas pe late, te sastol thaj te trajil.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","O Isus đelo lesa. A palo Isus teljardas vi okova but them, savo spidelas pe oko leste. ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","A sas okote maškar lende vi jek nasvali manušnji savi dešuduj brš patilas katar o ratvalipe. ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","But patisajli dok phirelas pe but doktorja, thaj potrošisardas sa so sas lat, ali khanči či pomognisardas laće, nego sas laće sa majgore. ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Kana ašundas palo Isus, nakhli maškar o them thaj avili leste katar lešće dume thaj dotaknisarda lesko ogrtači, ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","kaj phendas ande peste: “Te dotaknisardem samo lešće drze, avava sasti!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Thaj isto časo o ratvalipe ačhilo latar, a voj haćarda ande pesko telo kaj sastili katar piro baro nasvalipe. ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","O Isus odma haćarda kaj e sila inkljisti andar leste, thaj bolda pe ko them thaj phučlas: “Ko dirda e drze pe mande?” ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Lešće učenikurja phendine lešće: “Dićhes kaj o them spidel pe oko tute, a tu phučes ko dirda man?” ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ali o Isus dićhelas oko peste te dićel ko ćerda godova. ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","A e manušnji, izdralas e daratar kaj džangla kaj sastili, avili angle leste thaj peli pe koča e mujesa dži ke phuv thaj phendas lešće sa o čačipe. ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","A vo phendas laće: “Čhorije ćiro paćipe sastarda tut. Dža ando miro thaj av sasti katar ćiro baro nasvalipe!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Dok o Isus još godova motholas, avile varesave manuša andar e Jairesko ćher thaj phendine: “Ćiri čhej muli. Sostar majbut mučis e učitelje?” ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ali o Isus či marilas pale lenđe alava, nego phendas e Jairošće: “Na dara! Samo paća!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Thaj či mukla khonikas te džal pale leste osim e Petar, e Jakove thaj e Jovane e phrale e Jakovešće. ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kana aresline ando ćher e sinagogaće vođasko, o Isus dikhla kaj o them rknil, rovel thaj kukil ando baro muj, ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","dija andre thaj phendas lenđe: “Sostar gaći kukin thaj roven? E čhori či muli, samo sovel.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","A von asanas lestar. O Isus sa trada len avri, lija pesa samo e čhoraće dade, thaj laće deja thaj okole trin učenikonen kaj sas lesa, thaj dija andre okote kaj pašljolas e čhori. ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Askal astarda e čhora palo vas thaj phendas laće: “Talita kum!” so značil: “Čhejorije, tuće phenav, ušti!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","E čhori odma uštili thaj ačhili te phirel (sas lat dešuduj brš) a von zaprepastisajle katar o čudo. ");
INSERT INTO rmyChergash_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Askal o Isus zurale zapovedisarda lenđe te na mothon khonikašće pale akava, thaj phendas lenđe te den e čhora te hal. ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Askal o Isus đelotar okotar thaj avilo ando gav ande savo barilo, a lesa aviline vi lešće učenikurja. ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Kana avilo o savato, vo počnisarda te sikavel e manušen ande sinagoga, a but okola save ašunenas les sas zadivime thaj phenenas: “Katar akale sa gadava? Kaj steknisarda kasavi mudrost? Pe savo način vo pire vastenca ćerel čudurja? ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Pa vo si samo varesavo stolari, e Marijako čhavo, a e Jakovesko, Josijasko, Judasko thaj e Simunesko phral. Naj li lešće pheja akate maškar amende?” Razočarisajle thaj či prihvatisardine les. ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Askal o Isus phendas lenđe: “E prorokos poštuin svugde, osim ande lesko gav kaj barilo, maškar lešći familija thaj ande lesko ćher.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Thaj okote našti ćerda ni jek čudo, osim kaj pe varekozom nasvale manuša čhuta pire vas thaj sastarda len. ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","O Isus sas začudime kaj nas len paćipe. Askal džalas pe okolne gava thaj sikavelas e theme. ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","O Isus akhardas peste e dešuduj učenikonen, dija len vlast te traden andar o them i bilačhe duhonen thaj bičhalda len po duj džene. ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Zapovedisarda lenđe te na len pesa po drom khanči osim rovlji, ni mangro, ni trjasta, ni bakarne lovora. ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","“Nego len pe tumare pungre e sandale thaj len tumenca samo okola drze save si pe tumende.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Još phendas lenđe: “Kana boravin ande varesosko gav, ačhen ande jek ćher thaj na naćhen andar o ćher ando ćher dok či džan ande aver gav. ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ako či primina tumen ande varesavo than thaj či čhona kan tumende, džantar okotar thaj ćhinon o praho katar tumare pungre, sago znako kaj či prihvatisardine o alav e Devlesko.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Gajda e učenikurja đele thaj počnisardine te propovedin kaj e manuša trubun te pokajin pe. ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Andar e manuša tradine e bute demonen thaj e bute nasvalen sastardine gajda kaj maćhenas len e uljeja. ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","A pale godova ašundas vi o caro Irod, kaj e Isusesko alav postanisardas pindžardo. Jek phenenas: “Godova si o Jovano savo bolelas. Uštilo andar e mule, thaj zato akana šaj ćerel e silne čudurja.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Aver phendine: “Godova si o proroko Ilija.” A varesave phendine kaj vo si proroko sago jek katar e purane prorokurja. ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kana o Irod godova ašundas, phendas: “Me dijem te čhinen e Jovanesko šoro, a vo akana uštilo andar e mule!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Kaj o Irod majanglal zapovedisardas te astaren e Jovane thaj te čhuden les ande tamnica. Ćerda godova zbog e Irodijada, savi sas romnji lešće phralešći e Filipešći. ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","O Irod lija lat romnjaće a o Jovano stalno phenelas lešće: “Či tromas te les pale romnji ćire phralešće romnja!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Zbog godova e Irodijada inćarelas e holji po Jovano thaj kamlas te mudarel les, ali našti ćerelas godova, ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","kaj o Irod daralas lestar. Džanglas kaj si o Jovano pravedno thaj sveto manuš thaj zato štitilas les. Volilas te čhol kan leste vi ako e Jovanešće alava zurale uznemirinas les. ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ali e Irodijadaće sikadili lačhi prilika, kana o Irod pale piro rođendan pripremisardas gozba pale pire bare službenikurja, vojne zapovednikurja, thaj pale šorvale andar e Galileja. ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Kana dija andre e Irodijadaći čhej thaj počnisarda te ćhelel, godova zurale sviđosajlo e Irodešće thaj lešće gostonenđe. Thaj o caro phendas e čhejaće: “Mang mandar sa so kames, thaj dava tut.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Thaj hala laće solah: “Dava tut sa so manđes, čak vi opaš mungro carstvo.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Voj inkljisti thaj phučla pire deja: “So te mangav katar o caro?” A laći dej phendas laće: “Mang o šoro e Jovanesko savo bolelas.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","E čhej odma siđardas ko caro thaj phendas lešće: “Kamav te odma des man pe tacna o šoro e Jovanesko savo bolelas.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","O caro zurale ražalostisajlo, ali zbog godova kaj halas solah angle gosturja či kamla te odbil lat. ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Nego odma naredisarda e dželatošće te anel e Jovanesko šoro. Akava đelo, čhinda lesko šoro ande tamnica, ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","anda les pe tacna thaj dija les e čhejaće, a voj pire dejaće. ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Kana pale godova ašundine e Jovanošće učenikurja, avile te len e Jovanesko telo thaj te čhon le ando limori. ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","E apostolurja boldine pe thaj ćidine pe oko Isus thaj phendine lešće sa so ćerdine thaj so sikadine e manušen. ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Askal o Isus phendas lenđe: “Hajde aven manca pe varesavo čučo than te avas korkoro thaj te cara odmorin tumen.” Godova phendas lenđe zato kaj o but o them džalas thaj avelas thaj nas len kana ni te han. ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Gajda von korkoro teljardine e čamcosa pe jek čučo than. ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ali, but e manuša dikhline len sar džantar thaj odma pindžardine len, pa andar sa e gava siđardine phujatar thaj aresline okote majsigo lendar. ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Kana o Isus inkljisto andar e lađica, dikhla e bute theme thaj sažalisajlo pe lende, kaj von sas sago e bakhre bi pastiresko, thaj počnisarda te sikavel len but godova. ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Već sas kasno pa e učenikurja avile dži ko Isus thaj phendine: “Akava si pusto krajo, a već si kasno. ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Muk e theme te džantar pe okolne thana thaj gava te ćinen pešće vareso te han.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","A o Isus phendas lenđe: “Den len tumen te han.” A von phendine lešće: “So? Sar ćinasa gaći mangro? Trubujasas men duj šela rupune lovora te pravaras sa akale manušen.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","A o Isus phučla len: “Kozom mangre si tumen? Džan thaj proverin!” Kana đinadine e mangre, phendine: “Si amen pandž mangre thaj duj mačhe.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","O Isus askal naredisarda lenđe te bešen ande grupe pe zeleno čar. ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Thaj o them bešlo ande grupe po šel thaj po pandžvardeš džene. ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Askal o Isus lijas e pandž mangre thaj e duj mačhe, dikhla opre ando nebo, zahvalisarda e Devlešće askal phaglas e mangre, thaj dijas pire učenikonenđe te čhon anglo them. Gajda podelisarda savorenđe vi e duj mačhe. ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Savora haline thaj čaljile. ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","E učenikurja još ćidine dešuduj pherde korpe kotora save ačhiline katar e mangre thaj e mačhe. ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","A haline pandž milje muškarcurja. ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Odma pale godova, o Isus naredisarda pire učenikonenđe te den ande lađica thaj te džan angle leste ande Vitsaida, pe okoja rig e jezerošći, dok vo či mućel e theme te džantar. ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","A kana mukla e theme te džantar, đelo po brego te molil pe. ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kana peli e rjat, lešće učenikurja sas ande lađica maškaral po jezero, a o Isus sas korkoro pe phuv. ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","O Isus dikhla sar e učenikurja phare veslin kaj phurdelas e suprotno balval, pa varekaj katar o trito dži ko šovto sato detharinako, o Isus avilo dži lende gajda kaj phirelas po paj. Kamlas te naćhel paše lende, ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ali kana e učenikurja dikhline sar phirel po paj, gndisardine kaj si duho, thaj počnisardine te čhon muj. ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Kaj savora izdranas e daratar kana dikhline les, a o Isus odma phendas lenđe: “Aven hrabre! Me sem! Na daran!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Askal dijas lende ande lađica thaj e balval ačhili. A e učenikurja sas zurale začudime, ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","kaj či haćardine o čudo e mangrenca, kaj lenđe ile zurajle thaj či paćanas. ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kana o Isus thaj lešće učenikurja nakhline pe okoja rig e jezerošći, aresline ando Genisaret thaj okote phandadine o čamco. ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Čim inkljistine andar o čamco o them odma pindžardas e Isuse, ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","thaj prastajine pe sasto krajo te razglasin kaj avilo o Isus, a o them teljarda te anen e nasvalen pe nosilje okote kaj ašundine kaj si o Isus. ");
INSERT INTO rmyChergash_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Thaj kaj god džalas, ande baro ili cikno gav, o them čholas pire nasvalen pe glavne sokača thaj molinas e Isuse te mućel len te dotakin samo o teluno ćoško katar lesko ogrtači. Thaj savora save dotaknisardine les, sastile. ");
INSERT INTO rmyChergash_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Oko Isus ćidine pe varesave fariseja thaj e učitelja palo Mojsijesko zakono save aviline andar o Jerusalim. ");
INSERT INTO rmyChergash_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Von dikhline varesave lešće učenikonen kaj han mangro bithode vastenca so značil kaj lenđe vas sas obredno melale. ");
INSERT INTO rmyChergash_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","A e Židovurja, posebno e fariseja, či hanas mangro, a te majsigo či laće thodinesas obredno pire vas, pa gajda inćarenas e purane običaja katar pire prapapurja. ");
INSERT INTO rmyChergash_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Thaj kana avenas ćhere katar o pijaco, či hanas, a te majsigo či obredno thodinesas pe. A sas len još majbut purane običaja save inćarenas, sago kaj si: o obred te thoven pe e tahta, e bokalurja thaj e bakrene vasurja. ");
INSERT INTO rmyChergash_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Thaj zbog godova e fariseja thaj e učitelja palo Mojsijesko zakono phučline e Isuse: “Sostar ćire učenikurja či inćaren e purane običaja save mukline amenđe amare prapapurja, nego han e melale vastenca?” ");
INSERT INTO rmyChergash_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","A o Isus phendas lenđe: “Licemerja! Lačhe prorokuisardas o Isaija pale tumende sago kaj o Del phendas ando Sveto lil: Akala manuša samo e alavenca poštuin man, ali lengo ilo si dur mandar. ");
INSERT INTO rmyChergash_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ivja lenđe kaj slavin man, kana e manušenđe zapovesti sikaven sago kaj si mungro sikavipe. ");
INSERT INTO rmyChergash_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","E Devlešće zapovesti mukline, a inćaren e manušenđe običaja.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Thaj još phendas lenđe: “Baš šukar tumendar, odbacin e Devlešće zapovesti te šaj inćaren tumare običaja. ");
INSERT INTO rmyChergash_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","O Mojsija phendas: ‘Poštuisar ćire dades thaj će deja’ thaj: ‘Ko del romaja pire dade ili pire deja, neka avel kaznime po smrto.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","A tumen phenen: ‘Lačhe si te o manuš phenel pire dadešće ili pire dejaće: “Sa sova šaj pomogniv tut si te prinesiv kurbano – so značil žrtveno daro e Devlešće”’, ");
INSERT INTO rmyChergash_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","gajda tumen či mućen e manušes te vodil briga pale piro dad ili pale piri dej. ");
INSERT INTO rmyChergash_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Thaj gajda odbacin e Devlesko alav tumare običajenca save sikaven avren. Thaj but gajda vareso ćeren.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Askal palem akharda e theme peste thaj phendas: “Ašunen man savora thaj haćaren! ");
INSERT INTO rmyChergash_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Khanči so avrjal del ando manuš našti meljarel e manuše andral. Nego okova so inkljel andar o manuš meljarel e manuše andral. ");
INSERT INTO rmyChergash_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ako varekas si kan, nek ašunel!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","A kana đelotar e themestar thaj dijas ando ćher, e učenikurja phučline les te objasnil lenđe akaja paramiči. ");
INSERT INTO rmyChergash_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","A o Isus phučla len: “Pa ni tumen či haćaren? Sar či haćaren kaj khanči so del avrjal ando manuš našti meljarel e manušes, ");
INSERT INTO rmyChergash_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","kaj či džal lešće ando ilo, nego džal ande lesko ođi, thaj inkljel avri andar lesko telo?” (Gajda o Isus mothodas kaj si sa o hamasko čisto.) ");
INSERT INTO rmyChergash_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Thaj još majdur motholas: “Okova so inkljel andar e manušesko ilo ćerel e manuš te avel melalo anglo Del. ");
INSERT INTO rmyChergash_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kaj andral, andar e manušesko ilo, aven e bilačhe gindurja, o blud, o čoripe, o mudaripe, ");
INSERT INTO rmyChergash_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","o preljub, e pohlepa, o bilačho narav, e prevara, o biladžavipe, e zavist, o vređope, o barikanipe thaj o dilipe. ");
INSERT INTO rmyChergash_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Sa akava bilačhipe inkljel andar o manuš thaj meljarel e manušes anglo Del.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Pale godova o Isus andar e Galileja đelo ande tirske thaj sidonske krajurja thaj smestisajlo ande varesosko ćher. Či kamlas te bilo ko džanel kaj si okote, ali našti ačhilo garado. ");
INSERT INTO rmyChergash_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Varesavi manušnji ande kašći čhejori sas o bilačho duho, čim ašunda pale leste avili thaj peli angle lešće pungre pe koča e mujesa dži ke phuv. ");
INSERT INTO rmyChergash_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","A godoja manušnji nas Židovka thaj sas bijandi ande sirisko Fenikija. Molilas e Isuse te tradel e benđe andar laći čhej. ");
INSERT INTO rmyChergash_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","O Isus phendas laće: “Muk majsigo te čaljon e čhavra, kaj naj lačhe te lel pe o mangro katar e čhavra thaj te čhudel pe e džućhelorenđe.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","A voj phendas: “Gajda si, Gospode, ali vi e džućhelora tale sinija han e prušuka kaj peren e čhavrenđe.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Askal o Isus phendas laće: “Zbog godova kaj phendan akava, dža ćhere. O bilačho duho inkljisto andar ćiri čhej.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kana e manušnji đeli ćhere, arakhla e čhora sar pašljol ando kreveto, a o bilačho duho već inkljisto andar late. ");
INSERT INTO rmyChergash_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Askal o Isus đelotar andar e tirske krajurja, thaj preko Sidono areslo dži ko Galilejsko jezero ande dekapoljsko krajo. ");
INSERT INTO rmyChergash_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Okote andine lešće jeće kašuće manuše, savo vi phare ćerelas svato thaj zamolisardine e Isuse te čhol piro vas pe leste. ");
INSERT INTO rmyChergash_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","O Isus inđarda les cara majdur katar o them te šaj avel lesa korkoro, čhuta pešće naja ande lešće kan, thaj pešće čhungarava dotaknisardas lešći čhib. ");
INSERT INTO rmyChergash_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Dikhla ando nebo, uzdahnisarda thaj phendas lešće: “Efata!”, so znaćil: “Putar tut!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Thaj odma bolda pe e manušesko sluho, thaj lešći phangli čhib putajli thaj šaj lačhe ćerelas svato. ");
INSERT INTO rmyChergash_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","O Isus zabranisarda e themešće te mothon bilo kašće pale akava. Ali so vo majbut branilas lenđe, von sa majbut ćerenas svato pale akava. ");
INSERT INTO rmyChergash_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","But divinas pe thaj phenenas: “Sa so ćerel si zurale lačhe – vo ćerel te e kašuće manuša ašunen thaj e neme te ćeren svato!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ande godoja vrjama palem ćida pes o but o them. A sar nas len so te han, o Isus akhardas peste pire učenikonen thaj phendas lenđe: ");
INSERT INTO rmyChergash_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Žao si manđe katar o them, kaj si već trin đes manca, a najlen so te han. ");
INSERT INTO rmyChergash_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ako bičhalav len ćhere bokhalen, malaksina po drom. A varesave lendar avile dadural.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Lešće učenikurja phučline les: “Sar vareko pe akava pusto than šaj arakhla sas dosta mangro pale sa akala manuša te han?” ");
INSERT INTO rmyChergash_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","O Isus phučla len: “Kozom mangre si tumen?” A von phendine: “Efta.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Askal o Isus phendas e themešće te bešen tele pe phuv. Lijas e efta mangre, zahvalisarda e Devlešće, phagla e mangre thaj dijas e učenikonenđe, a von podelisardine e themešće. ");
INSERT INTO rmyChergash_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","A sas len vi varekozom mačhora. O Isus zahvalisarda pale lende thaj phendas e učenikonenđe te vi len podelin e themešće. ");
INSERT INTO rmyChergash_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","E manuša haline thaj čaljile. A e učenikurja ćidine efta korpe kotora katar o okova habe kaj ačhilo. ");
INSERT INTO rmyChergash_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","A okote sas varekaj katar štar milje muškarcurja. Askal o Isus mukla len te džantar ćhere. ");
INSERT INTO rmyChergash_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Odma pale godova o Isus dija ande lađica pire učenikonenca thaj uputisajle ande dalmanitsko krajo. ");
INSERT INTO rmyChergash_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Askal aviline e fariseja thaj počnisardine te raspravin pe e Isuseja thaj te iskušin les, gajda kaj rodenas lestar te sikavel lenđe varesavo znako andar o nebo. ");
INSERT INTO rmyChergash_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Kana o Isus godova ašunda, handuk uzdahnisarda thaj phendas: “Sostar akava naraštaj rodel znako? Čače phenav tumenđe: Nisavo znako či dela pe tumenđe.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Askal đelotar lendar, dijas palem ande lađica thaj otplovisarda pe aver rig e jezerošći. ");
INSERT INTO rmyChergash_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","A e učenikurja bistardine te len pesa mangro, pa ande lađica sas len samo jek mangro. ");
INSERT INTO rmyChergash_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Dok naćhenas prekal o jezero, o Isus upozorisarda len: “Len tumen sama katar o farisejsko thaj e Irodesko kvasco!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","A von počnisardine te raspravin pe maškar peste: “Kava phendas zato kaj či lijam amenca mangro!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","O Isus džanglas so gndin thaj phendas lenđe: “Sostar raspravin tumen kaj naj tumen mangro? Još uvek či razumin thaj či haćaren o značenje? Zar tumaro ilo gadići barosajlo? ");
INSERT INTO rmyChergash_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Jakha si tumen, a či dićhen thaj kan si tumen, a či ašunen. Zar či den tumen gođi? ");
INSERT INTO rmyChergash_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Kana phaglem okola pandž mangre thaj prvardem pandž milje muškonen, kozom pherde korpe ćidine kotora save ačhiline?” A von phendine: “Dešuduj.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“A kana phaglem okola efta mangre thaj pravardem štar milje muškonen, kozom pherde bare korpe kotora ćidine?” A von phendine: “Efta.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Pe godova phendas lenđe: “Zar još či haćaren?” ");
INSERT INTO rmyChergash_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Kana aresline ande Vitsaida, varesave manuša andine ko Isus jećhe kore manuše, thaj zamolisardine les te čhol pire vas pe leste. ");
INSERT INTO rmyChergash_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","O Isus lijas e kore manuše palo vas thaj inđarda les avri andar o gav, čhungarda ande lešće jakha thaj čhuta pešće vas pe leste thaj phučla les: “Šaj dićhes vareso?” ");
INSERT INTO rmyChergash_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","A o manuš dikhla thaj phendas: “Dikhav e manušen, ličin manđe sago e kaš save phiren.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Askal o Isus palem čhuta pire vas pe lešće jakha, thaj e manušešće godova drom skroz bolda pe o vido. Thaj sa jasno dićhelas. ");
INSERT INTO rmyChergash_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Askal o Isus bičhalda les ćhere thaj phendas lešće te na del ando gav. ");
INSERT INTO rmyChergash_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Askal o Isus thaj lešće učenikurja đele ande okolne gava oko e Kesarija e Filipešći. Dok sas još po drom, o Isus phučlas pire učenikonen: “So phenel o them, ko sem me?” ");
INSERT INTO rmyChergash_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","A von phendine lešće: “Jek phenen kaj san o Jovano savo bolelas, aver e phenen kaj san o proroko Ilija, a varesave phenen kaj san varesavo katar e prorokurja.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Askal phučla len: “A tumen, so gndin ko sem me?” O Petar phendas: “Tu san o Hristo!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","O Isus oštro phendas lenđe te či phenen khonikašće akava pale leste. ");
INSERT INTO rmyChergash_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Askal počnisarda te sikavel len e alavenca: “Me, o Čhavo e Manušesko, moraš but te pativa. E starešine, e šorvale rašaja thaj e učitelja e Mojsiješće zakonestar moraš te odbacina man. Avava mudardo thaj pale trin đes uštava andar e mule.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","O Isus phendas lenđe godova gajda jasno. Askal o Petar lija les pe rig thaj lijas te ukoril les. ");
INSERT INTO rmyChergash_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","O Isus bolda pe, dikhla pe pire učenikurja thaj ukorisarda e Petre alavenca: “Džatar mandar, Sotono, kaj tu či gndis pe okova so si e Devlesko, nego so si e manušesko.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Askal akharda peste e theme thaj pire učenikonen thaj phendas lenđe: “Ako vareko kamel te džal pale mande, askal neka odreknil pe korkoro pestar, neka lel piro trušul, thaj neka džal pale mande. ");
INSERT INTO rmyChergash_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kaj svako ko kamel te spasil piro trajo, hasarela les, a ko hasarel piro trajo zbog mande thaj zbog e Bahtali nevimata, spasila les. ");
INSERT INTO rmyChergash_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Kaj so mol e manušešće te dobil o sasto them, a te hasarel piro trajo? ");
INSERT INTO rmyChergash_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","So o manuš šaj del sago zamena pale piro trajo? ");
INSERT INTO rmyChergash_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Kaj ko ladžal mandar thaj katar mungre alava angle akava bipaćivalo thaj bezehalo naraštaj, vi me, o Čhavo e Manušesko, ladžava lestar kana avava ande slava mungre Dadešći e svete anđelenca.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","O Isus majdur phendas lenđe: “Čače phenav tumenđe, si akate varesave kaj ačhen maškar tumende, von sigurno či merena dok majsigo či dićhena e Devlesko carstvo kaj avel ande sila.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Šov đes majposle o Isus lija pesa e Petre, e Jakove thaj e Jovane thaj đelo lenca pe vuči gora, kaj sas lenca korkoro thaj okote angle lende promenisajlo e Isusesko izgled. ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Lešće drze ćerdile blistavo, gajda parne sar ni jek manuš pe phuv našti parnjardasas len. ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Pe godova angle lende sikadilo o proroko o Ilija thaj o Mojsija thaj line te ćeren svato e Isuseja. ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","A o Petar phendas e Isusešće: “Učiteljina, lačhe si kaj sam akate! Te vazdas trin senice: jek pale tute, jek palo Mojsije thaj jek palo Ilija.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","O Petar či džanelas so aver te mothol kaj lija len e bari dar. ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Askal sikadilo jek oblako thaj učharda len pire senkava thaj askal ašundilo o glaso andar o oblako: “Akava si mungro volime Čhavo! Les ašunen.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Thaj katar jekhar kana e učenikurja dikhline oko peste, majbut khonikas či dikhline osim e Isuse. ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Thaj kana fuljenas katar e gora, o Isus naredisarda lenđe kaj či troman te mothon khonikašće so dikhline, dok vo, o Čhavo e Manušesko, či uštel andar e mule. ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Von inćardine godova pale peste, ali ćerdine svato maškar pende so gindilas o Isus kana phendas kaj “uštela andar e mule.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Askal e učenikurja phučline les: “Sostar e učitelja e Mojsiješće zakonestar phenen kaj majsigo katar o Mesija trubul te avel o Ilija?” ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","O Isus phendas lenđe: “Čače o Ilija avela prvo thaj sa obnovila, ali sostar si askal ramome ando Sveto lil palo Čhavo e Manušesko kaj but patila thaj kaj avela odbacime? ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","A me phenav tumenđe: O Ilija već avilo, a von ćerdine lesa sar kamla pe lenđe, sago kaj si pala leste vi ramome.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kana o Isus thaj lešće okola trin učenikurja boldine pe katar e gora ke aver učenikurja, dikhline e bute themes oko lende thaj e učiteljen e Mojsiješće zakonestar sar traden pe e učenikonenca. ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","A o them kana dikhla kaj avel o Isus, zurale iznenadisajle thaj odma prastajine te pozdravin les. ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","O Isus phučla len: “Oko soste traden tumen lenca?” ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","A jek manuš andar o them phendas lešće: “Učiteljina, andem tute mungre čhaves, savo našti te ćerel svato, kaj si ande leste o bilačho duho thaj zbog godova si nemo. ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kana astarel les, čhudel les pe phuv, thaj e spuma del lešće po muj, škripol e dandenca thaj kočil pe. Phučlem ćire učenikonen te traden e nemo duhos andar leste, ali von našti tradine les.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","O Isus pe godova phendas lenđe: “O bipaćivalo naraštajona, dži kaj još trubula te avav tumenca? Dži kaj još trpiva tumen? Anen e čhavre mande.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Thaj von andine e čhavres leste. Kana o duho dikhla e Isuse, odma zurale ćhinosarda e čhavres, savo pelo pe phuv thaj ačhilo te valjil pes pe sa e riga, a po muj delas lešće e spuma. ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","O Isus askal phučla lešće dades: “Kozom vrjama si kasavo?” O dad phendas: “Katar lesko ciknipe. ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Svako cara o duho čhudel les vi ande jag vi ando paj te mudarel les. Ali te šaj vareso te ćeres, smiluisar tut amenđe thaj pomožisar amen!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","O Isus phendas lešće: “Phučes man: ‘Te šaj’? Sa si moguće okolešće savo paćal!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","A e čhavesko dad odma čhuta muj: “Paćav! Pomožisar manđe te majbut paćav!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Kana o Isus dikhla kaj sa majbut them prastajas dži lende, strogo ukorisarda e bilačhe duho gajda kaj phendas: “Duhona savo phandaves e manušenđe čhibja te našti ćeren svato thaj lenđe kan te aven kašuće, zapovediv tuće inklji andar leste thaj majbut na te boldes tut ande leste!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Thaj o bilačho duho čhuta muj thaj zurale ćhinosarda e čhavres thaj inkljisto andar leste. A o čhavro ačhilo te pašljol tele sago mulo thaj but džene phendine kaj mulo. ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ali o Isus lija les palo vas, vazda les opre thaj o čhavro uštilo. ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kana dija andre ando ćher, lešće učenikurja phučline les korkoro pe rig: “Sostar amen našti tradam godole bilačhe duhos?” ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","A o Isus mothodas lenđe: “Akaja vrsta šaj tradel pe samo e molitvava.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Kana đeletar okotar, naćhenas kroz e Galileja. A o Isus či kamla te o them pale godova džanel, ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kaj sikavelas pire učenikonen gajda kaj phenelas lenđe: “Me, o Čhavo e Manušesko, avava dino ande vas e bilačhe manušenđe thaj von mudarena man, ali pale trin đes me uštav andar e mule.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ali e učenikurja či haćardine so motholas, a sas lenđe dara te phučen les. ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kana o Isus thaj lešće učenikurja aresle ando Kafarnaum thaj kana dine ando ćher, o Isus phučla len: “So godova tradenas tumen dromesa maškar tumende?” ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","A von khanči či mothonas kaj e dromesa tradenas pe jek avresa ko si maškar lende majbaro. ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Askal o Isus bešlo, akhardas peste e dešuduje apostolen thaj phendas lenđe: “Ko kamel te avel prvo neka avel maškar savorende zadnjo thaj neka avel sluga savorenđe!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Askal lija jećhe čhavre, čhuta les maškar lende, dijale mrtiko thaj phendas: ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ko prihvatil jećhe kasave cikne čhavre zbog mande, man prihvatil. A ko man prihvatil, či prihvatil samo man već e Devles savo bičhalda man.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","O Jovano phendas e Isusešće: “Učiteljina, dikhlam jećhe manuše sar ande ćiro alav tradel e bilačhe duhonen. Amen phendam lešće te na ćerel godova kaj či džal pale tute thaj naj jek amendar.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","O Isus phendas lenđe: “Na branin lešće, kaj khonik ko ćerel čudo ande mungro alav či mothol bi lačhipe pale mande. ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kaj, ko naj protiv amende, godova si pale amende. ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Kaj, ko del tumen samo vi tahtaj paj zato kaj sen e Hristošće učenikurja, čače phenav tumenđe: godova manuš sigurno dobila piri nagrada.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ko crdel po bezeh jećhe katar kala ciknen save ande mande paćan, majlačhe avilosas lešće te unglaven lešće o mlinsko bar pe kor thaj te čhuden les ando jezero. ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Te crdel tut ćiro vas po bezeh, čhin ćo vas tutar. Kaj majlačhe si tuće bi vastengo te des ando večno trajo, nego liduj vastenca te džas ande pakao, ande večno jag savi nikad či mudardola, ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","kaj lengo ćermo či merela thaj e jag či mudardola. ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Te crdel tu ćiro pungro po bezeh, čhin ćo pungro tutar. Kaj majlačhe si tuće bi pungrengo te des ando večno trajo, nego liduj pungrenca te aves čhudino ando pakao, ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","kaj lengo ćermo či merela thaj e jag či mudardola. ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Te crdel tu ćiri jakh po bezeh, inkal ćiri jakh tutar. Kaj majlačhe si tuće te des ande Devlesko carstvo jećhe jakhasa, nego te avel tut liduj jakha, a te aves čhudino ando pakao, ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","kaj lengo ćermo či merela thaj e jag či mudardola. ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Kaj svako avela šilado e jagasa sago kaj si e žrtva šiladi e loneja. ");
INSERT INTO rmyChergash_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","O lon si lačho. Ali te o lon hasarel pesko londipe sova lonđarena? Aven sago o lon thaj trajin ando miro jek avresa!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","O Isus đelotar okotar thaj đelo ande judejske krajurja, preko e reka e jordanošći. Thaj palem avilo leste o but o them, a vo sago vi uvek sikavelas len. ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Avile dži leste varesave fariseja thaj phučline les gajda te iskušin les: “Dali tromal o rom te rastavil pe katar piri romnji?” ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","A o Isus phučla len: “So o Mojsije zapovedisardas tumenđe?” ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","A von phendine: “O Mojsija mukla e romešće te del pešće romnja rastavno lil thaj askal šaj mućel lat.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Askal o Isus phendas lenđe: “O Mojsije ramosarda tumenđe godoja zapoved zbog tumare barune ile. ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ali, ando početko kana o Del sa ćerda, ‘ćerda len muško thaj žensko.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Zato o rom mućela pire dade thaj pire deja thaj avel jek pire romnjasa, ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","thaj von duj džene avena jek telo’ gajda naj majbut duj nego jek telo. ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Zato o manuš neka či rastavil okova so o Del sastavisarda.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","A kana sas palem andre ando ćher, e učenikurja phučline les pale godova. ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","A o Isus phendas lenđe: “Ko rastavil pe katar piri romnji thaj lel aver romnja, ćerel preljub prema piri prvo romnji. ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Thaj e romnji, ako rastavil pe katar piro rom thaj lel aver rome, ćerel preljub.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Varesave manuša anenas anglo Isus pire čhavren te čhol pire vas pe lende thaj blagoslovil len, a e učenikurja godova braninas lenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Kana o Isus dikhla so ćeren, holjajlo thaj phendas lenđe: “Mućen e čhavroren te aven mande. Thaj na branin lenđe, kaj kasavenđe pripadil e Devlesko carstvo. ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Čače phenav tumenđe: ko či primil e Devlesko carstvo sago cikno čhavro, sigurno či dela ande leste.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Askal dijas mrtiko e čhavren, čhuta pire vas pe lende thaj blagoslovisarda len. ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Kana o Isus sas palem po drom, prastajas dži leste varesavo manuš, pelo pe koča angle leste thaj phučla les: “Lačheja učiteljina, so trubul te ćerav te naslediv o večno trajo?” ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","A o Isus phendas lešće: “Sostar man akhares lačheja? Khonik naj lačho osim o jedino o Del. ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","E zapovesti džanes: ‘Na mudar, na ćer preljub, na čor, na svedočisar hohamne, na prevarisar, poštuisar ćire dades thaj ćire deja!’ ” ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","A o manuš phendas lešće: “Učiteljina, sa gadava inćarav katar mungro ternipe.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","O Isus dikhla pe leste pherdo ljubavi thaj phendas lešće: “Još samo jek falil tuće: dža thaj bićin sa so si tut, a e love de e čorenđe thaj avela tut barvalipe ando nebo. Askal av thaj sledisar man.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Čim o Isus godova phendas lešće, o manuš mukla po muj. Rastužisajlo thaj đelotar, kaj či kamlas te bićinel piro baro barvalipe. ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","O Isus dikhla oko peste, thaj phendas pire učenikonenđe: “Sar si phare e barvalenđe te den ande Devlesko carstvo!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","E učenikurja začudisajle pe godova so phendas. Zato o Isus palem phendas lenđe: “Čhavralen mungralen, sar si phare te den ande Devlesko carstvo. ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Maj loće si e kamilaće te naćhel kroz e suvjaće kan nego e barvalešće te del ande Devlesko carstvo.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","E učenikurja još maj but začudisajle, thaj phučenas jek avres: “Pa ko askal šaj te spasil pes?” ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","A o Isus dikhla pe lende thaj phendas: “E manušenđe si godova nemoguće, ali e Devlešće naj, kaj e Devlešće si sa moguće.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Askal o Petar phendas e Isusešće: “Ake, amen muklam sa thaj teljardam pale tute.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Askal o Isus phendas: “Čače phenav tumenđe, svako ko mukla pesko ćher, ili pe phralen, ili pe phejen, ili pe dade thaj pe deja, ili pe čhavren, ili pe njive pale mande thaj pale Bahtali nevimata, ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","akana, ande akaja vrjama, sigurno dobila šel drom majbut: ćhera, phrala, pheja, deja, čhavra, thaj phuvja. Ali sa godolesa avena vi e progonurja, a ande vrjama savi avela, večno trajo. ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","A but okola save si akana prve, avena poslednje, a okola poslednje avena prve.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Kana o Isus thaj lešće učenikurja teljardine karingal o Jerusalim, a o Isus džalas angle lende, e učenikurja sas začudime kaj džal ando Jerusalim, a okolen save džanas pale leste lijas e dar. O Isus palem lijas e dešuduje učenikonen pe rig thaj motholas lenđe so avela lesa: ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Ake das ando Jerusalim. Okote man, e Čhaves e Manušešće, predaina ande vas e šorvale rašajenđe thaj e učiteljenđe e Mojsiješće zakonestar thaj von osudina man po smrto. Askal predaina man ke okola save naj židovurja ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","thaj von marena muj mandar, čhungarena man, bičuina man, thaj mudarena man. Ali me trin đes pale godova uštava andar e mule.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Askal avile dži ko Isus o Jakov thaj o Jovano, e Zevedejevešće čhave, thaj phendine lešće: “Učiteljina, kamas te ćeres pale amende sa so zamolisa tut.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","A o Isus phučla len: “So kamen te ćerav pale tumende?” ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","A von phendine lešće: “Muk amen te bešas tusa kana deja ande ćiri nebesko slava, pe počasne thana, jek pe ćiri desno rig a aver pe ćiri levo rig.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","A o Isus phendas lenđe: “Či džanen so manđen. Dali šaj pijen andar o tahtaj andar savo me pijava ili te bolen tumen sago kaj me bolava man?” ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","A von phendine: “Šaj.” Pe godova o Isus phendas lenđe: “Ej čače pijena andar o tahtaj patnje andar savo me pijava thaj bolena tumen ande patnje sago kaj me bolava man. ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ali naj mungro te odrediv ko bešela pe mungri levo ili desno rig. Godola thana pripadin okolenđe pale kaste o Del odredisardas.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Kana godova ašundine e aver deš učenikurja, holjajle po Jakov thaj po Jovano. ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","O Isus akharda len peste thaj phendas lenđe: “Tumen džanen kaj okola save inćaren pe kaj si e manušenđe vladarja, vladin pe lende, thaj okola save si majbare lendar volin te gospodarin lenca. ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ali maškar tumende nek či avel gajda, nego savo kamel te avel majbaro maškar tumende, neka avel tumaro sluga. ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Thaj ko kamel te avel maškar tumende prvo, neka savorenđe avel robo. ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kaj ni me, o Čhavo e Manušesko, či avilem te služin manđe nego te me služiv averenđe, thaj te dav mungro trajo sar poćin pale e but manuša.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Askal aresline ando gav o Jerihon. Kana o Isus, lešće učenikurja thaj o but o them inkljenas andar o Jerihon, pašo drom bešelas o koro prosijako, savo akhardolas Vartimej, so značil e Timejesko čhavo. ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Kana ašunda kaj godova naćhel o Isus andar o Nazaret, počnisarda te čhol muj: “Isuse e Davidešće Čhaveja, smiluisar tut manđe!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","But džene opomeninas les te ačhel, ali vo još majzurale čholas muj: “E Davidešće Čhaveja, smiluisar tut manđe!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","O Isus ačhilo thaj phendas: “Akharen les akaring!” Von akhardine e kore manuše thaj phendine lešće: “Hrabro, ušti! O Isus akharel tut.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","O koro manuš čhuda pestar o ogrtači, huklo pe pungre thaj avilo anglo Isus. ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","O Isus phučla les. “So kames te ćerav pale tute?” O koro manuš phendas: “Učiteljina, kamav te šaj te dikhav.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","A o Isus phendas lešće: “Dža, ćiro paćipe sastarda tut!” Thaj o koro odma šaj dićhelas, thaj teljarda dromesa palo Isus. ");
INSERT INTO rmyChergash_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Kana o Isus thaj lešće učenikurja avile majpaše dži ko Jerusalim thaj aresle paše ke gava Vitfaga thaj ke Vitanija, pe maslinsko gora, bičhalda pire duje učenikonen anglal. ");
INSERT INTO rmyChergash_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Phendas lenđe: “Džan ando gav savo si angle tumende. Sar den ande leste, araćhena e phangle magare pe savo khonik či jašisarda. Putaren e magare thaj anen les akaringal. ");
INSERT INTO rmyChergash_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","A ako vareko phučel tumen: ‘sostar godova ćeren?’, tumen phenen: ‘Trubul e Gospodešće, ali vo sigo boldela les.’ ” ");
INSERT INTO rmyChergash_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","E učenikurja đele thaj arakhline e phangle magare pale kapija, avri po sokako, thaj putardine les. ");
INSERT INTO rmyChergash_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","A varesošće manuša save okote ačhenas phučline len: “Sostar putren e magare?” ");
INSERT INTO rmyChergash_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","A e učenikurja phendine lenđe gajda sar o Isus phendas lenđe te mothon, thaj e manuša mukline len po miro. ");
INSERT INTO rmyChergash_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Askal andine ko Isus e magare, thaj čhutine prekal leste pire ogrtača, a o Isus bešlo pe leste. ");
INSERT INTO rmyChergash_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","But manuša buljarenas pire ogrtača po drom, a varesave katar e manuša buljarenas zelene krandže save čhindine ando polje. ");
INSERT INTO rmyChergash_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","E manuša save džanas anglo Isus thaj pale leste čhonas muj: “‘Hosana! Blagoslovime okova savo avel ando alav e Gospodesko!’ ");
INSERT INTO rmyChergash_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Blagoslovime si o carstvo amare pradadesko e Davidesko savo avel! ‘Hosana e Devlešće ande visina!’” ");
INSERT INTO rmyChergash_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Gajda o Isus dijas ando Jerusalim thaj đelo ando Hramo thaj sa razgledilas, ali sar sas već kasno, đelotar e dešuduje apostolenca ande Vitanija. ");
INSERT INTO rmyChergash_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Thejara o đes teljardine andar e Vitanija, a o Isus bokhajlo. ");
INSERT INTO rmyChergash_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Dadural dikhla jećhe smokva savi sas sa ande patrja thaj đelo dži late te araćhel vareso pe late te hal. Ali kana avilo late, či arakhlas pe late khanči osim laće patrja, kaj još nas e vrjama te e smokva bijanel pesko plodo. ");
INSERT INTO rmyChergash_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Askal o Isus phendas e smokvaće: “Dži ko veko neka khonik majbut či hal ćiro plodo tutar!” A godova ašundine vi lešće učenikurja. ");
INSERT INTO rmyChergash_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Kana avile palem ando Jerusalim, o Isus dijas ande avlija e Hramošći thaj ačhilo te tradel avri andar o Hramo savoren save okote ćinenas thaj bićinenas thaj delas mujal e sinije kolenđe kaj phađenas e love, a kolenđe kaj bićinenas e golubonen haravelas lenđe klupe. ");
INSERT INTO rmyChergash_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Thaj khonikašće či mukla te inđarel vareso kroz e Hramošći avlija te bićinel. ");
INSERT INTO rmyChergash_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Askal lijas te sikavel len: “Naj li ramome ando Sveto lil: ‘Mungro ćher akhardola molitveno ćher pale sa o them?’ A tumen ćerdine lestar than kaj ćiden pe e razbojnikurja!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","A kana ašundine pale godova e šorvale rašaja thaj e učitelja e Mojsiješće zakonestar, ačhile te roden način sar te mudaren e Isuse, kaj daranas lestar andar godova kaj sa o them divilas pe lešće sikavipešće. ");
INSERT INTO rmyChergash_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kana peli e rjat, o Isus thaj lešće učenikurja inkljistine andar o gav. ");
INSERT INTO rmyChergash_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kana o Isus thaj lešće učenikurja aver detharin naćhenas paše okoja smokva, line sama kaj e smokva šućili andar o koreno. ");
INSERT INTO rmyChergash_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","A o Petar askal dija pe gođi thaj phendas e Isusešće: “Dik učiteljina! Šućili e smokva savja dijan romaja!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","O Isus phendas lenđe: “Nek avel tumen paćipe ando Del. ");
INSERT INTO rmyChergash_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Vi čače phenav tumenđe, ko god phenel akale goraće: ‘Vazde tut thaj čhude tut ando more!’ thaj či sumnjil ande piro ilo, nego paćal kaj avela gajda sar phendas – gajda avela lešće. ");
INSERT INTO rmyChergash_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Andar godova phenav tumenđe: sa so roden ande tumare molitve, paćan kaj primina, thaj avela tumenđe dino. ");
INSERT INTO rmyChergash_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Thaj kana len te molin tumen, jartosaren te si tumen vareso protiv varekaste, te vi tumenđe tumaro nebesko Dad jartol tumare bezeha.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","A te tumen či jarton averenđe, askal ni tumaro nebesko Dad či jartola tumenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Thaj palem o Isus thaj lešće učenikurja avile ando Jerusalim. Kana o Isus phiravelas pes pe avlija e Hramošći, avile dži leste e šorvale rašaja, e učitelja e Mojsiješće zakonestar thaj e starešine, ");
INSERT INTO rmyChergash_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","thaj phučline les: “Ande kašći vlasti ćeres akava? Ko dija tut vlast te ćeres kasave stvarja?” ");
INSERT INTO rmyChergash_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","A o Isus phendas lenđe: “Vi me phučava vareso tumen, te tumen mothodine manđe. Vi me mothava tumenđe ande kašći vlast ćerav akava. ");
INSERT INTO rmyChergash_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Dali o Del phendas e Jovanošće te bolel e manušen, ili e manuša phendine lešće te ćerel godova? Phenen manđe akava!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","A von ačhile maškar peste te raspravin: “Te phendam ‘o Del phendas lešće’, phučela men ‘Sostar askal či paćajine lešće?’ ");
INSERT INTO rmyChergash_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","A či kamas te phenas kaj e manuša phendine lešće. Ipak daranas katar o them, kaj savora inćarenas kaj o Jovano sas čačo proroko.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Andar godova phendine e Isusešće: “Či džanas.” Askal o Isus phendas lenđe: “Ni me askal či phenava tumenđe ande kašći vlast ćerav akava!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Askal o Isus počnisarda te ćerel lenđe svato ande paramiče sago kaj si akaja: “Jek manuš zasadisardas vinograd, ogradisarda les e ogradava, hanadas ande leste than kaj gnječila pe e drak, thaj vazdas stražarsko kula. Askal o vinograd iznajmisardas e vinogradarenđe thaj đelotar dur. ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kana avili e vrjama pale berba, bičhaldas pire slugos te lel katar e vinogradarja o deo katar e drak savi pripadil lešće. ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ali e vinogradarja astardine e slugos, mardine les thaj tradine les palpale čuče vastenca. ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","O gospodari e vinogradesko bičhaldas aver slugos. Ali e vinogradarja pharadine lesko šoro thaj ladžardine les. ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Askal bičhalda vi e trito slugos, ali les mudardine. Bičhaldas lenđe vi bute e aver slugen, ali e vinogradarja jećhen mardine, a averen mudardine. ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Thaj ačhilo les samo još jek: lesko volime čhavo. Po krajo bičhaldas vi les, kaj gindisarda: ‘Mungre čhave sigurno poštuina.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ali kana e vinogradarja dikhline les phendine jek avrešće: ‘Akava si o nasledniko. Hajde te mudaras les, thaj o nasledstvo ačhela amenđe.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Astardine les, mudardine les thaj lesko telo čhudine avri andar o vinograd. ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","So akana ćerela o gospodari e vinogradesko? Avela thaj mudarela godole vinogradaren, a o vinograd dela ando najam aver vinogradarenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Sigurno čitosardine ando Sveto lil akava: ‘O bar savo e zidarja odbacisarde postanisarda bar e temeljesko. ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","O Gospod godova ćerda, thaj čudesno si ande amare jakha’?” ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","E židovske vođe askal rodenas način sar te astaren e Isuse kaj džangline kaj godoja paramiči si namenime lenđe. Ali daranas katar o them. Andar godova đeletar thaj mukline les. ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Pale godova e židovske vođe bičhaldine ko Isus varesave farisejen thaj e Irodešće manušen te šaj optužin e Isuse kaj phendas vareso bilačhe. ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Von avile leste thaj phendine: “Učiteljina, džanas kaj tu mothos o čačipe, thaj kaj naj san pe khonikašći rig niti dićhes ko si ko, nego čačipeja sikaves e theme palo drom e Devlesko. Dali amen e Židovurja trubul te das e carošće o porez ili či trubul? Dali te poćinas o porez ili te či poćinas?” ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","A o Isus džangla kaj si licemerne thaj phendas lenđe: “Sostar kamen te crden man ande tumari zamka? Anen manđe e kovanica savjava poćinen o porez te dikhav lat thaj phenava tumenđe.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Andine leste e kovanica, a vo phučla len: “Kasko si akava šoro thaj natpiso pe kovanica?” A von phendine lešće, “E carosko.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Askal o Isus phendas lenđe: “Den e carošće so si e carosko, a e Devlešće so si e Devlesko.” Pe godova von zadivisajle lešće. ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Askal avile ko Isus varesave sadukeja save phenen kaj naj uštipe andar e mule, thaj phučline les: ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Učiteljina, o Mojsije ramosarda amenđe te mulo varekasko phral thaj mućel e romnja, a nas len čhavra, lesko phral trubul te oženil pe godole romnjasa sar voj bijandasas čhaves savo avela nasledniko e mulesko thaj te inđarel lesko prezime. ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Sas gajda efta phrala. O prvo phral oženisajlo thaj mulo, a nas les čhavra. ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Askal o dujto phral oženisajlo lešće udovicava, ali vi vo mulo, a či mukla čhavren pale peste. Isto dogodisajlo vi e trito phralešće. ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Thaj ni jek katar e efta phral či mukla pale peste čhavra. Po krajo muli vi e romnji. ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Thaj kana e manuša uštena andar e mule, kašći romnji voj avela? Kaj, sa e phral sas oženime isto romnjasa.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","O Isus phendas lenđe. “Ande zabluda sen, pale godova kaj či haćaren o Sveto lil ni e Devlešći sila. ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kaj, kana e manuša uštena andar e mule, či ženina pe niti udajina pe, nego avena sago e anđelurja ando nebo. ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","A palo uštipe andar e mule, sigurno čitosardine ande Mojsiješći knjiga, kaj ramol palo okova grmo, kana o Del phendas e Mojsiješće: ‘Me sem o Del e Avraamesko, e Isakosko thaj e Jakovesko’, save dumut muline. ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","A o Del naj o Del e mulengo, nego o Del e džudengo. Tumen sen prema godova ande bari zabluda.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Varesavo učitelj e zakonesko avilo thaj ašundas lenđi rasprava. Kana dikhla sar o Isus lačhe phendas lenđe, phučla les: “Savi si majvažno zapovest katar sa e zapovesti?” ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","O Isus phendas lešće: “Majvažno si akaja: ‘Ašun, Izraele, o Gospod amaro Del si jedino Del. ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Voli e Gospode, ćire Devle, saste ćire ileja, ćire saste dušava, ćire saste gođasa thaj ćire saste snagava.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","A dujto si zapovest: ‘Voli ćire pašutne sago korkoro tut.’ Naj majbare zapovesti katar akala duj.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","O učitelj e zakonesko phendas lešće: “Lačhe phendan, učiteljina. Si tut pravo kana phenes kaj si samo jek Del thaj kaj naj aver osim leste.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Te volis e Devle ćire saste ileja, saste gođasa, saste snagasa thaj te volis ćire pašutnes sago korkoro tut majvažno si katar sa e žrtve paljenice thaj katar sa aver žrtve. ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Kana o Isus ašundas sar o manuš mudro ćerel svato, phendas lešće: “Tu naj san dur katar e Devlesko carstvo.” Katar godoja vrjama khonik majbut či usudisajlo khanči te phučel les. ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Kana o Isus sikavelas e theme ando Hramo, phučla len: “Sostar e učitelja e Mojsiješće zakonestar phenen kaj si o Hristo samo čhavo e carosko Davidesko? ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Korkoro o David pherdo e Sveto Duhosa, phendas: ‘Phenel o Gospod mungre Gospodešće: Beš pe mungri počasno desno rig dok či čhav ćire dušmajen tale ćire pungre.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ako o korkoro David akharda e Hristo pire Gospodeja, sar askal šaj o Hristo te avel lesko potomko?” A o but o them oduševime ašunenas les. ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Dok sikavelas len, o Isus phendas lenđe: “Len tumen sama katar e učitelja e zakonešće. Von volin te o them dićhel len ande kuč ogrtačurja thaj te o them časno pozdravil len pe trgurja. ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Volin te bešen pe počasne thana ande sinagoge thaj pe gozbe. ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Von čoraren e udovicenđe ćhera thaj godova učharen gajda kaj lungo molin pe e Devlešće. Pale godova avena kaznime majbut katar sa aver.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Pale godova o Isus đelo thaj bešlo ando hramo dži ke kutija kaj ćidenas pe e love thaj dićhelas sar o them čholas ande late love. A e but barvale manuša čhonas but love. ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Askal avili jek čori udovica thaj čhuta andre duj bakarne lovora save vredinas zurale cara. ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Askal o Isus akhardas peste pire učenikonen, thaj phendas lenđe: “Čače phenav tumenđe: akaja čori udovica čhuta andre majbut love nego savora aver. ");
INSERT INTO rmyChergash_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kaj, savora von dine katar piro viško, a voj gajda čori dijas sa so sas lat.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kana o Isus inkljelas andar o Hramo, jek katar lešće učenikurja phendas lešće: “Učiteljina, Dik! Čefal šukar bara katar o Hramo thaj sošći šukar građevina!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","A o Isus phendas lešće: “Dićhes akala bare građevine? Čače phenav tumenđe, či ačhela katar akava ni bar pe bareste. Sa avela harado.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Kana o Isus bešelas pe Maslinsko gora, pe okoja rig katar o Hramo, o Petar, o Jakov, o Jovan thaj o Andrija phučline les pe rig: ");
INSERT INTO rmyChergash_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Phen amenđe, kana godova avela thaj savo znako si kaj sa akava pherdola?” ");
INSERT INTO rmyChergash_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","A o Isus ačhilo te mothol lenđe: “Len sama te na vareko hohavel tumen. ");
INSERT INTO rmyChergash_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","But džene avena ande mungro alav thaj phenena: ‘Me sem o Mesija’ thaj e bute manušen hohavena. ");
INSERT INTO rmyChergash_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kana ašunena pale raturja thaj e glasurja pale raturja, na daran, kaj sa godova moraš te avel, ali godova još naj o krajo. ");
INSERT INTO rmyChergash_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kaj o them uštela po them thaj o carstvo uštela po carstvo. E phuv ćhinola pes pe razne riga thaj avela bok. Akava si samo o početko e mukengo sago kana e manušnji džal te bijanel. ");
INSERT INTO rmyChergash_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ali tumen len sama pe tumende! Kaj avena dine pe sudurja thaj marena tumen ande sinagoge. Inkalena tumen angle vladarja thaj angle carurja andar godova kaj sen mungre sledbenikurja. Godova avela tumenđe prilika te svedočin pale mande. ");
INSERT INTO rmyChergash_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","E Bahtali nevimata trubul majsigo te propovedil pe sa e themenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","A kana inđarena tumen te sudin tumenđe, na han briga majanglal so phenena, kaj avela tumenđe dino so te phenen. Mothon okova so avela tumenđe dino ande godova časo kaj či ćerena svato tumen, nego o Sveto Duho. ");
INSERT INTO rmyChergash_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","O phral e phrale dela po mudaripe, a o dad pire čhavre. E čhavra uštena pe pire dada thaj pe pire deja thaj dena len po mudaripe. ");
INSERT INTO rmyChergash_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Savora mrzana tumen zbog mande, ali ko god ačhel verno dži ko krajo avela spasime. ");
INSERT INTO rmyChergash_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","A kana dićhena ‘e grozota savi anel uništenje’ sar ačhel po than kaj či tromajasas te avel askal okola save si ande Judeja, neka našen ande gore. (Ko akava čitol neka haćar so phenel pe!) ");
INSERT INTO rmyChergash_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ko avela opre po ćher, nek na fuljel te del ando ćher te lel vareso, ");
INSERT INTO rmyChergash_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","thaj ko avela ande njiva, neka na boldel pe te lel o ogrtači! ");
INSERT INTO rmyChergash_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Teško e khamne manušnjenđe thaj okolenđe save još den čuči e čhavren ande godola đesa! ");
INSERT INTO rmyChergash_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Nego molin tumen te tumaro našipe či avel ando ivend. ");
INSERT INTO rmyChergash_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kaj ande godola đesa avela nevolje save nas sar o Del stvorisarda o them sa dži akana, niti posle avela. ");
INSERT INTO rmyChergash_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Thaj te o Gospod či harnjarel o brojo godole đesengo, khonik či ačhilosas džudo. Ali harnjarda godola đesa, zbog okola manuša saven o Del losardas. ");
INSERT INTO rmyChergash_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","A te askal vareko phendas tumenđe: ‘Ake o Hristo si akate!’ ili: ‘Eke okote si!’, na paćan. ");
INSERT INTO rmyChergash_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kaj uštena e but hohamne mesije thaj e hohamne prorokurja thaj ćerena znakurja thaj čudurja te šaj hohaven, ako si moguće, vi e Devlešće izabrane manušen. ");
INSERT INTO rmyChergash_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Len sama pe tumende! Kaj ake sa majanglal phenav tumenđe! ");
INSERT INTO rmyChergash_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","A ande godola đesa – posle akale nevolje – ‘O kham kaljola, thaj o čhonut majbut či sijola. ");
INSERT INTO rmyChergash_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","E čereja perena katar o nebo thaj e nebeske sile avena uzdrmome’. ");
INSERT INTO rmyChergash_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Askal e manuša dićhena e Čhave e manušešće sar avel ande oblakurja e silava thaj e bare slavava. ");
INSERT INTO rmyChergash_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Vo askal bičhalela e anđelen thaj ćidela pire losarde manušen katar sa e štar riga e themešće, katar o krajo e phuvjako dži ko krajo e nebesko.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Sićon katar e smokva. Kana laće krandže kovljon thaj mućen pešće patrja, džanen kaj paše si o milaj. ");
INSERT INTO rmyChergash_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Gajda vi tumen kana dićhen kaj si akate sa akava so phendem tumenđe, džanen kaj si vo paše anglo vudar. ");
INSERT INTO rmyChergash_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Čače phenav tumenđe: akava pokoljenje či naćhela dok sa akava či avela. ");
INSERT INTO rmyChergash_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","O nebo thaj e phuv naćhena, ali mungre alava či naćhena.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“A savo si godova đes thaj vrjama khonik či džanel, ni e anđelurja po nebo, pa čak niti o Čhavo, već samo Dad. ");
INSERT INTO rmyChergash_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Aven džungade thaj len sama, kaj či džanen kana avela godoja poslednjo vrjama. ");
INSERT INTO rmyChergash_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Godova si sago kana o manuš džaltar po drom, a pesko ćher mućel te vodin lešće sluge. Askal sa jek slugašće zapovedil so trubun te ćere, a e manušešće kaj lelas sama po vudar phendas te čhol straža. ");
INSERT INTO rmyChergash_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Dakle aven džungade, kaj či džanen kana o gospodari avela ćhere – dali avela talerjat, ili ande opaš e rjat, ili kana e bašne ašundona, ili ande detharin – ");
INSERT INTO rmyChergash_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","te na avel iznenada thaj te na araćhel tumen sar soven. ");
INSERT INTO rmyChergash_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","A so phenav tumenđe, savorenđe phenav: ačhen džungade!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Sas duj đesa dži ke pasha thaj dži ko prazniko e bikvascošće mangrengo. E šorvale rašaja thaj e učitelja e zakonešće rodenas sar te astaren e Isuse po hohaipe thaj te mudaren les. ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Phenenas: “Či tromas te ćeras godova dok si o prazniko, te či pobunil pe o them.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","A o Isus sas ande Vitanija thaj halas ando ćher e Simonesko saves sas guba. Askal avili dži leste jek manušnji e ćuposa savo sas ćerdo katar o kuč bar, ande savo sas zurale kuč mirisno ulje savo sas ćerdo katar o čisto nard. Putardas o ćupo thaj čordas o ulje pe Isusesko šoro. ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","A varesave katar e učenikurja holjajle zbog godova thaj ačhile maškar pende te mothon: “Sostar akava mirisno ulje gajda rspil pe? ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Godova ulje šaj bićinda pe pale majbut katar jek bršešći poćin, a e love šaj dine sas pe e čore manušenđe.” Thaj čhutine muj pe late. ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","A o Isus phendas: “Mućen lat po miro! Sostar ćeren te avel laće neprijatno? Voj ćerda manđe lačho delo. ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Kaj čore manušen uvek avela tumen maškar tumende thaj šaj te pomožina lenđe kana got kamena, a man či avela tumen uvek tumenca. ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Voj ćerda so voj šaj: majanglal makhlas mungro telo palo prahope. ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Čače phenav tumenđe: kaj god po them propovedila pe e Bahtali nevimata, mothola pe vi pale akava so voj ćerda, sago uspomena pe late.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Askal o Juda Iskariotski, jek katar e dešuduj učenikurja, đelo ke šorvale rašaja te izdail lenđe e Isuse. ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","A von, kana ašundine, raduisajle thaj obećisardine kaj dena les love. Katar askal o Juda počnisarda te rodel lačhi vrjama te izdail les. ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Po prvo đes kana sas o prazniko e bikvascošće mangrengo, kana delas pe čhurjasa o pashalno bakhro, e učenikurja phučline e Isuse: “Kaj kames te džas te pripremisaras tuće te has e pashalno večera?” ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","O Isus askal bičhaldas pire duj učenikonen e alavenca: “Džan ando gav ando Jerusalim okote malavena manušes savo inđarel ando ćupo paj. Džan pale leste, ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","pa ande savo ćher del andre, tumen phenen godole domaćinešće: ‘O Učitelj phučel ande savi soba šaj te hal e pashalno večera pire učenikonenca?’ ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Vo sikavela tumenđe bari soba opre po sprato savi si pripremime. Okote spremin amenđe e večera.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","E učenikurja đele ando gav thaj arakhline sa sar o Isus phendas lenđe thaj okote ćerdine e pashalno večera. ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Talerjat, o Isus avilo e dešuduje učenikonenca. ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Dok hanas pale sinija, o Isus phendas lenđe: “Čače phenav tumenđe, kaj jek tumendar savo akana hal manca, izdaila man.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","E učenikurja zurale ražalostisajle thaj jek pale avreste phučenas les: “Te naj sem me godova?” ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","A o Isus phendas lenđe: “Godova si jek tumendar e dešudujendar, savo bolel o mangro manca ando isto čaro. ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Kaj o me o Čhavo e Manušesko, moraš te merava sago kaj ramol pale mande ando Sveto lil. Ali teško okolešće savo izdail man e Čhaves e Manušešće. Pale leste avilosas majlačhe te nikada či ni bijandilosas.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Dok hanas, o Isus lija o mangro, zahvalisarda pale leste thaj phagla les, askal dijas pire učenikonenđe thaj phendas: “Len, akava si mungro telo.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Askal lijas tahtaj mol, zahvalisarda e Devlešće thaj dijas pire učenikonenđe thaj savora piline andar o tahtaj. ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Thaj phenelas lenđe: “Akava si mungro rat, rat savo potvrdil o savezo thaj savo čhordol pale butende. ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Čače phenav tumenđe: či majbut pijava mol sa dži ke okova đes kana pijava tumenca nevi mol ande Devlesko carstvo.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Askal e điljenca slavisardine e Devle thaj teljardine karingal e maslinsko gora. ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","A o Isus phendas lenđe: “Savora tumen mućena man, kaj o Del phenel ando Sveto lil: ‘Mudarava e pastire thaj e bakhre našena.’ ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ali kana uštava andar e mule, džava angle tumende ande Galileja.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","A o Petar phendas lešće: “Vi ako savora mućen tut, me či mukava tut!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","A o Isus phendas lešće: “Čače phenav tuće ađes, još akaja rjat, maj sigo nego so o bašno dujto data zakukuričil, trin drom hohaveja kaj či pindžares man.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ali o Petar još maj odlučno phendas: “Čak vi ako trubul te merav tusa, nikada či odrekniva man tutar!” A gajda mothonas vi savora aver. ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Askal aviline ando masleniko savo akhardolas Getsimanija. A o Isus phendas pire učenikonenđe: “Bešen akate dok me džav te molima!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pesa inđarda e Petre, e Jakove, thaj e Jovano. Askal lija les e bari žalost thaj sas lešće pharo. ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Thaj phendas lenđe: “Mungri duša si žalosno dži ko smrto. Ačhen akate, na soven thaj stražarin.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Askal đelo cara majdur, pelo e mujesa dži ke phuv thaj molisajlo, te ako si moguće, či naćhel kroz e patnja savi ažućarel les. ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Molisajlo: “Abba! Dade! Tu sa šaj. Le mandar akava tahtaj patnje! Ali neka či avel mungri volja, nego ćiri.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Askal bolda pe ke pire učenikurja, arakhla len sar soven thaj phendas e Simone Petrešće: “Soves li Simone? Našti ačhilan džungado ni jek sato te stražaris? ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ačhen džungade, stražarin thaj molin tumen, te na peren ando iskušenje. O duho si spremno ali o telo si slabo.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","O Isus palem đelotar lendar thaj molisajlo iste alavenca. ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Kana palem bolda pe ke učenikurja, arakhla len sar soven. Lenđe jakha phandadonas thaj či džangline so te phenen lešće. ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Kana bolda pe po trito drom, phendas lenđe: “Zar još soven thaj odmorin tumen? Dosta sas! Avilo o časo! Ake man, e Čhave e Manušešće, predain ande vas e bezehalenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ušten! Ake, mungro izdajniko avel!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Dok o Isus još motholas, areslo o Juda, jek katar e dešuduj učenikurja, a lesa avilo vi o but o them, e mačonenca thaj e rovljenca, saven bičhaldine e šorvale rašaja, e učitelja e zakonešće thaj e starešine. ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","O Juda, lesko izdajniko, majanglal dija len znako: “Okova saves čumidav, godova si. Astaren les thaj inđaren les e stražarenca.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Thaj čim avilo dži ko Isus, o Juda phendas lešće: “Učiteljina” thaj čumida les. ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Pe godova e manuša čhutine pire vas po Isus thaj astardine les. ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","A jek katar e učenikurja, savo ačhelas okote paše, inkalda o mačo thaj peklas e bare rašaješće slugos thaj čhinda lesko kan. ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","A o Isus phendas lenđe: “Aviline pe mande sago po razbojniko e mačonenca thaj e rovljenca te astaren man. ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","A svako đes semas tumenca ando Hramo thaj sikavavas, ali či astardine man. Sa akava sas te pherdol okova so ramol pale mande ando Sveto lil.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Pe godova sa e učenikurja mukline e Isuse thaj našline. ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","A pale leste džalas jek terno manuš savo sas nango thaj učhardo samo e kuč čaršapeja. Kana vi les line te astaren, ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","vo čhudas pestar o čaršapo thaj našlo nango. ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","E Isuse andine anglo baro rašaj, thaj okote ćidine pe sa e šorvale rašaja, e starešine thaj e učitelja e zakonešće. ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","A o Petar dadural džalas pale leste thaj dija ande avlija e bare rašaješći. Bešlo okote zajedno e slugenca thaj tatolas paše jag. ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","A e šorvale rašaja thaj o sasto veće rodenas varesavo dokaz protiv o Isus, te šaj osudin les po smrto, ali či arakhline khanči protiv leste. ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","But manuša hohamne svedočinas protiv leste, ali lengo svedočanstvo či slažolas pe. ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Askal uštiline varesave manuša thaj počnisardine hohave te svedočin protiv leste: ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ašundam les sar mothol: ‘Haravava akava Hramo, saves ćerdine e manušenđe vas, thaj pale trin đes vazdava aver, save či ćerena e manušešće vas.’” ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ali ni godova lengo svedočanstvo či slažolas pe. ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","O baro rašaj askal ačhilo maškare maškar lende, thaj phučla e Isuse: “Sostar khanči či mothos? So akava akala manuša svedočin protiv tute?” ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","A o Isus samo ačhelas thaj khanči či motholas. O baro rašaj palem phučla les: “San tu o Hristo, Čhavo e Blagoslovime Devlesko?” ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","A o Isus phendas: “Sem. Thaj dićhena man, e Čhave e Manušešće, sar bešav pe desno počasno rig e Svemoguće Devlešći thaj avav pe nebeske oblakurja.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Pe godova o baro rašaj pharada pe peste e drze thaj phučlas: “So trubul men majbut svedokurja? ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ašundine les sar hulil! So mothon?” A von savora phendine kaj si došalo thaj kaj zaslužisarda smrto. ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Varesave počnisardine te čhungaren les, te učharen lesko muj thaj denas le dab dumukhenca thaj marenas muj lestar: “Proreknisar ko dija tut dab?” Askal astardine les e sluge thaj mardine les e palmenca po muj. ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Dok o Petar sas tele ande avlija, avili jek sluškinja e bare rašaješći. ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Kana dikhla e Petre sar tatol paše jag, lačhe dikhla pe leste thaj phendas: “Vi tu sanas okole Isuseja andar o Nazaret!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","A o Petar hohada: “Či džanav niti haćarav so phenes.” Thaj inkljisto ando prvo deo e avlijako. A o bašno askal zakukuričisarda. ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Kana e sluškinja dikhla les, palem phendas okolenđe save okote ačhenas: “Okova manuš si jek lendar!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","A o Petar palem phenelas kaj naj. Cara majposle, vi okola aver manuša save sas okote mothonas e Petrešće: “Tu san čače jek lendar, kaj san vi tu andar e Galileja!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","A o Petar ačhilo te del pe romaja thaj te hal solah: “Či pindžarav godole manuše pale savo phenen.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Thaj odma pale godova o bašno po dujto drom zakukuričisarda, a o Petar dija pe gođi so phendas lešće o Isus: “Maj sigo nego so o bašno duj data zakukuričil, trin drom odreknija tut mandar.” Thaj askal ačhilo zurale te rovel. ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Thaj odma rano ande detharin ćerdine svato maškar phende e šorvale rašaja, e starešine, e učitelja palo Mojsijesko zakon thaj o sasto Baro veće. Phangline e Isuse thaj inđardine les ko Pilato savo sas rimsko upravniko. ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","O Pilato phučla les: “Dali san tu o caro e Židovengo?” A o Isus phendas lešće: “Tu korkoro phenes.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","A e šorvale rašaja došarenas e Isuse pale but godova. ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","O Pilato palem phučla les: “Naj tut khanči te phenes pe akava? Dik pale so sa došaren tut.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ali o Isus majbut khanči či motholas lešće, gajda kaj o Pilato but začudisajlo. ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","A o Pilato svako brš po prazniko mućelas andar o phanglipe jećhe manušes saves o them rodasas lestar. ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ando phanglipe askal sas vi varesavo manuš savo akhardolas Varava zajedno e razbojnikonenca save ande pobuna ćerdine mudaripe. ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","O them avilo thaj rodenas katar o Pilato te ćerel okova so vo obično ćerelas po prazniko. ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","A o Pilato phučla len: “Dali kamen te mukav tumenđe e Židovsko caro?” ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Džanelas kaj e šorvale rašaja predaisardine leste e Isuse andar e zavist. ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ali e šorvale rašaja pherdine e manušengo šoro te roden te mućel lenđe majradije e Varava. ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","A o Pilato palem phučla len: “A so kamen te ćerav akalesa saves akharen caro e Židovengo?” ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","A von čhutine muj: “Razapnisar les!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","“Ali andar soste?” Phučlas o Pilato: “Sosko bilačhipe ćerda?” Ali von još majzurale čhonas muj: “Razapnisar les!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","A o Pilato, zbog godova kaj kamlas te ugodil e themešće, mukla andar o phanglipe e Varava, a e Isuse dija te izbičujin thaj te razapnin les po trušul. ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Askal e vojnikurja inđardine e Isuse ande palata, pindžardi sago pretorijum, thaj ćida pes okote sasti četa vojnikurja. ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Dine po Isus grimizno ogrtači, a po šoro čhutine lešće khuvdi kruna katar e kangre. ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Askal marenas muj lestar thaj mothonas: “Nek trajil o caro e Židovengo!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Denas les dab e trskasa po šoro, čhungarenas pe leste, perenas pe koča thaj ćerenas pe kaj klanjinpe lešće. ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kana ačhiline te maren muj lestar, askal fuljardine lestar o grimizno ogrtači thaj dine pe leste lešće drze thaj inđardine les te razapnin les po trušul. ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Varesavo manuš andar e Kirinija naćhelas okotar kaj boldelas pe andar e njive. Vo akhardolas Simon thaj sas dad e Aleksandresko thaj e Rufosko. E vojnikurja tradine les te inđarel e Isusesko trušul. ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Askal andine e Isuse dži ko than savo akhardol Golgota (so značil “lobanja”). ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Denas les mol hamime e smirnava te loćaren lešće e duk, ali vo či kamlas te pel. ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Askal razapnisardine les, a lešće drze razdelisardine gajda kaj čhudine kocka pale lende, te dićhen ko so lela. ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Sas inja saturja ande detharin kana razapnisardine les. ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Okote sas o natpis pe savo ramolas lešći doš: “Caro e Židovengo”. ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Zajedno lesa razapnisardine vi duje razbojnikonen, jećhe katar lešći desno rig a avres katar lešći levo rig. ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Godolesa ispunisajlo okova so sas ramome ando Sveto lil: “Dićhenas pe leste sago pe zločincurja.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","E manuša kaj naćhenas okotar kušenas les. Ćerenas e šoresa pe leste thaj mothonas: “Ej, tu kaj haraves o Hramo thaj ande trin đes vazdes les, ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","spasisar akana korkoro tut thaj fulji katar o trušul.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Gajda marenas muj lestar vi e šorvale rašaja thaj e učitelja palo Mojsijesko zakon thaj jek avrešće phenenas: “Averen spasisardas, a korkoro pes našti spasil! ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Neka akana godova Hristo, Caro e Izraelosko, fuljel katar o trušul, te dikhas thaj te paćas!” Gajda vređonas les čak vi okola kaj sas lesa razapnime. ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ando mismeri mukla pe o tunjariko pe sasti phuv thaj sas sa dži ke trin saturja palo mismeri. ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ande trin saturja o Isus ando baro glaso čhuta muj: “Eloi, Eloi, lama sabahtani?”, so značil: “Devla mungreja, Devla mungreja, sostar muklan man?” ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","A kana varesave kaj ačhenas okote ašundine akava, phendine: “Dićhen, akharel e proroko Ilija!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","A jek manuš prastaja te bolel o sunđer ando šut, čhuta les pe trska, dija e Isuse te pel thaj motholas: “Ažućaren te dikhas dali avela o Ilija te fuljarel les!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","A o Isus čhuta muj andar o baro glaso, thaj mukla pesko đi. ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Askal e firanglja ande svetinja e hramošći pharadili po opaš, katar opral dži tele. ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kana o rimsko kapetano savo ačhelas anglo Isus ašundas sar o Isus čhuta muj thaj gajda mukla pesko đi, phendas: “Akava manuš vi čače sas Čhavo e Devlesko!” ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","A sa godova dadural dićhenas vi varesave manušnja. Maškar lende sas e Marija andar e Magdala, e Marija e dej e majterne Jakovešći thaj o Josije, thaj e Saloma. ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Von džanas pale leste thaj pomožinas les dok sas ande Galileja. Akate sas vi but aver manušnja save avile lesa ando Jerusalim. ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Kana već skoro perelas o tunjariko, pošto sas đes kana ćerenas pe e pripreme, godova sas đes majsigo o savato, ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","o Josif andar e Arimateja, savo sas ugledno člano andar o Baro veće savo vi korkoro ažućarelas e Devlesko carstvo, bi darako đelo anglo Pilato thaj manglas lestar e Isusesko telo. ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","O Pilato sas začudime kaj o Isus već mulo thaj akhardas e kapetano te phučel les kozom si sar o Isus mulo. ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Kana ašunda godova katar o kapetano askal dijas e Isusesko mulo telo e Josifešće. ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","O Josif ćindas čaršapo, fuljarda e Isusesko telo katar o trušul, paćarda les ando čaršapo thaj čhuta les ando limori savo sas isklesime ande stena. Askal čhuta o bar po vudar e limoresko. ");
INSERT INTO rmyChergash_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","A e Marija andar e Magdala thaj e Marija e dej e Josiješći dićhenas kaj čhutine e Isusesko telo. ");
INSERT INTO rmyChergash_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kana nakhlo o savato, e Marija andar e Magdala, e Marija e deja Jakovešći thaj e Saloma ćindine mirisno pomast te maćhen e Isusesko telo. ");
INSERT INTO rmyChergash_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Pa detharinako rano prvo đes ando kurko čim inkljisto o kham, đele po limori. ");
INSERT INTO rmyChergash_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Thaj dromesa phučenas jek avrja: “Ko lela amenđe o bar majdur katar o vudar e limoresko?” ");
INSERT INTO rmyChergash_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ali kana aresline, dikhline kaj o bar sas već spidino majdur katar o limori vi ako sas godova zurale baro bar. ");
INSERT INTO rmyChergash_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kana dine andre ando limori, dikhline pe desno rig terne manuše ande parne haljina sar bešel. E manušnja darajle. ");
INSERT INTO rmyChergash_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","A vo phendas lenđe: “Na daran! Tumen roden e razapnime Isuse andar o Nazaret. Vo naj akate. Uštilo andar e mule! Ake dićhen o than kaj pašljolas. ");
INSERT INTO rmyChergash_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ali tumen džan thaj phenen lešće učenikonenđe, thaj e Petrešće: ‘O Isus džal angle tumende ande Galileja. Okote dićhena les, sago vi kaj phendas tumenđe.’ ” ");
INSERT INTO rmyChergash_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","E manušnja inkljistine andar o limori thaj našline okotar kaj astarda len o izdrape thaj e dar gajda khonikašće khanči či phendine, kaj daranas. ");
INSERT INTO rmyChergash_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Kana o Isus uštilo andar e mule detharinako rano prvo đes ando kurko, majsigo sikadilo e Marijaće andar e Magdala, andar savi majsigo trada efta bilačhe duhonen. ");
INSERT INTO rmyChergash_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Voj đeli thaj javisarda godova okolenđe save sas lesa, a save akana tugujin thaj roven. ");
INSERT INTO rmyChergash_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Kana von ašundine kaj si o Isus džudo thaj kaj voj dikhla les, či paćajine. ");
INSERT INTO rmyChergash_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Pale godova e Isusesko izgled promenisajlo thaj sikadilo pire duje učenikonenđe dok džanas ande aver gav. ");
INSERT INTO rmyChergash_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Kana pindžardine les, boldine pe thaj godova javisardine aver učenikonenđe, ali ni lenđe či paćajine. ");
INSERT INTO rmyChergash_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pale godova o Isus sikadilo e dešuduje apostolenđe dok hanas pale sinija. Thaj ukorisarda len pale lengo bipaćipe thaj lenđe zurale ile kaj či paćajine okolenđe save dikhline les nakon so uštilo andar e mule. ");
INSERT INTO rmyChergash_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Askal phendas lenđe: “Džan pe sasto them thaj propovedin e Bahtali nevimata sa e themešće! ");
INSERT INTO rmyChergash_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ko paćala thaj bolel pe, spasila pe, a ko či paćala, osudila pe. ");
INSERT INTO rmyChergash_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","A akala čudesne znakurja pratina okolen save paćan: ande mungro alav tradena e bilačhe duhonen andar e manuša, ćerena svato neve čhibjenca, ");
INSERT INTO rmyChergash_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","lena e sapen ande vas, ako vareso otrovno pijen, či naudila lenđe, čhona pire vas pe nasvale manuša thaj von sastona.” ");
INSERT INTO rmyChergash_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Pale godova kana o Gospod Isus godova phendas lenđe, sas vazdino ando nebo thaj bešlo pe Devlešći desno rig. ");
INSERT INTO rmyChergash_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","E učenikurja đele thaj propovedinas e Bahtali nevimata pe sa e thana. A o Gospod pomožilas lenđe thaj prekal lende potvrdilas pire alava e čudesne znakonenca save pratinas len.");
INSERT INTO rmyChergash_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Poštuime Teofile, ramov tuće zbog godova kaj but džene line te ramon okola događajurja save o Del obećisarda majsigo prekal e prorokurja, a save dogodisajle maškar amende. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Von godova ramosardine prema okova so majanglal phendine e očevicurja thaj sluge e Alavešće. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Zato vi me odlučisardem Teofile, te ramov tuće sa po redo, pošto pomno sa katar o početko istražisardem, ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","gajda aveja sigurno kaj si okova sikavipe savo primisardan pouzdano. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ande vrjama kana vladilas o Judejsko caro o Irod, sas varesavo rašaj savo akhardolas Zaharije andar e Avijasko rašajesko redo. A lešći romnji sas isto andar e Aronosko pleme. Lako alav sas Jelisaveta. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","A liduj sas pravedne anglo Del, thaj trajinas sa po zakono thaj pe okova so sas odredime anglo Gospod, bi manako. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","A nas len čhavra, kaj e Jelisaveta našti ačhelas khamni, a liduj već phurile. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Jek đes kana o Zaharija služilas e Devlešće ando Hramo kaj po dužnost avilo o redo kana lešći grupa rašaja trubunas te služin, ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","prema e rašajengo običaj odabirisardine les gajda kaj čhudine e kocka te del ando Svetište e Gospodesko te kadil. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Pale vrjama kana kadilas pe ando Hramo, sa o them sas avri thaj molinas pe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","A e Zaharijašće sikadilo o anđelo e Gospodesko savo ačhelas pe desno rig e žrtvenikosko katar savo kadilas pe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Kana dikhla les o Zaharije, zurale darajlo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","A o anđelo phendas lešće: “Na dara, Zaharija! Kaj si ašundi ćiri molitva: ćiri romnji e Jelisaveta bijanela tuće čhave thaj tu de les alav Jovan. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Zbog leste aveja bahtalo thaj radosno thaj e buten raduila lesko bijandipe, ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","kaj avela baro anglo Gospod. Či pijela mol niti pimo savo matarel. Pherdola e Sveto Duhosa još ando đi pire dejako. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Vo boldela e but Izraelconen e Gospodešće lenđe Devlešće. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Džala anglo Gospod sago glasniko pherdo duho thaj sila, sago o proroko Ilija. Pomirila e daden lenđe čhavenca a e nepokorne umurja boldela gajda te prihvatin o razumnost okolengo save si pravedne. Pripremila e theme pale e vrjama kana o Gospod avela.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","A o Zaharija phendas e anđelošće: “Sar me džanava kaj godova avela čače? Kaj me sem purano thaj e romnji mungri dija ande pire purane brš.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","A o anđelo phendas lešće: “Me sem o anđelo Gavrilo, savo ačhav anglo Del te služiv thaj bičhaldo sem te ćerav svato tusa thaj te javiv tuće akaja bahtali nevimata. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","A akana andar godova kaj či paćajan zanemija thaj našti ćereja svato dži ko đes dok či avel e vrjama pale godova thaj mungre alava či pherdon.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","A o them ažućarelas avri e Zaharija thaj začudisajle so gaći zadržisajlo ando svetište e Hramosko. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","A kana napokon inljisto, našti ćerelas svato, nego e znakonenca probisarda te phenel lenđe so sas ando Hramo thaj von haćardine kaj sas les viđenje ando svetište e Hramosko. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Thaj kana završisajle e đesa lešće službaće ando Hramo o Zaharije đelotar ćhere. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","A posle godola đesa, lešći romnji e Jelisaveta ačhili khamni thaj pandž čhon či inkljelas avri andar piro ćher thaj motholas: ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“O Gospod milostivo dikhla pe mande kaj fuljardas mandar o ladžavo anglo them.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Kana e Jelisaveta sas khamni šov čhon, o Del bičhaldas e anđele Gavrilo ando cikno galilejsko gav savo akhardolas Nazaret, ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ke Marija savi sas još čhej thaj sas mangli palo manuš, savo akhardolas Josif, savo sas potomko e carosko Davidosko. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Kana o anđelo dijas late andre phendas laće: “Raduisar tut, kaj o Del si pherdo milosti prema tute! O Gospod si tusa.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Pe godola alava e Marija uznemirisajli thaj počnisarda te gindil so značil godova pozdrav. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","A o anđelo phendas laće: “Na dara Marija! Kaj o Del iskažisardas tuće piri ljubav.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ake ačheja khamni thaj bijaneja čhave saves deja alav Isus. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Vo avela baro thaj akhardola Čhavo e Majbare Devlesko thaj o Gospod Del dela les autoriteto te vladil sago o caro David savo sas lesko prapapo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Vo vladila e Jakovešće plemenova dži ko veko thaj lešće carstvošće či avela krajo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","A e Marija phendas e anđelošće: “Sar godova avela kana sem još čhej?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","A o anđelo phendas laće: “O Sveto Duho fuljela pe tute thaj e sila e Majbare Devlešći avela pe tute thaj zasenila tut. Zato vi okova savo bijandola avela sveto thaj akhardola o Čhavo e Devlesko. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ake vi ćiri bibi e Jelisaveta, ačhili khamni ande piri purani vrjama thaj avela lat čhavo. Okoja isto manušnji pale savi phenenas kaj našti avel lat čhavra, već si šov čhon khamni. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kaj, e Devlešće khanči naj nemoguće!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","A e Marija phendas lešće: “Ake, sluškinja sem e Gospodešći, neka avel manđe pe ćire alava.” Thaj o anđelo đelotar latar. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Varesave đesa majposle e Marija siđardas ande gorsko krajo e Judejako. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Kana aresli okote dija ande Zaharijasko ćher thaj pozdravisajli e Jelisavetava. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Kana e Jelisaveta ašunda e Marijako pozdrav, o čhavro huklo ando lako đi, a e Jelisaveta pherdili e Sveto Duhosa. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Pale godova e bahtatar čhuta muj e bare glasosa: “Majblagoslovime san tu, Marijo, katar sa e manušnja thaj blagoslovime o čhavro ande ćiro đi. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Savi čast si man, te tu e dej mungre Gospodešći aves mande! ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kaj ake čim ćiro pozdrav avilo dži ke mungre kan, e bahtatar o čhavro huklas ande mungro đi. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Blago tuće kaj paćajan kaj pherdola okova so phendas tuće o Gospod!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","E Marija askal phendas: “Barjarel e duša mungri e Gospode! ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Thaj raduil pe o duho mungro e Devlešće mungre Spasitelješće. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kaj milostivo dikhla pe mande pe piri ponizno sluškinja, katar akana sa e manuša akharena man blagoslovime. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kaj o silno Del, savesko si alav sveto, ćerda manđe baro lačhipe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Kaj o Del si milostivo; e milost lešći si katar e čang dži ke čang okolenđe save daran lestar. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Pire moćno vastesa ćerel silne dela thaj odbacisardas pestar okolen save si barikane ande pire ile. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Čhudas tele katar o prestolje e vladaren, a vazdas e poniznen. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","E bokhalen čaljarda e lačhipeja, a e barvalen mukla čuče vastenca. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Huklo ando pomoć pire slugenđe e Izraelconenđe thaj či bistardas te avel milostivo ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","sago kaj obećisarda amare prapaponenđe, e Avramešće thaj lešće potomkonenđe dži ko veko.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","A e Marija ačhili ke Jelisaveta varekaj katar trin čhon thaj askal bolda pe ćhere. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","A e Jelisavetaće avili e vrjama te bijanel thaj bijanda čhaves. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Kana ašundine laće komšije thaj laći familija kaj o Gospod sas gajda lačho thaj milostivo prema late, raduisajle zajedno lasa. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","A kana e čhavres sas ohto đes o them ćida pes po obred te obrezin e čhavre. Thaj line te den les alav Zaharija, sago kaj bučhol lesko dad. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ali e Jelisaveta phendas: “Na! Lesko alava avela Jovan!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","A von phendine laće: “Pa khonik ande ćiri familija či bučhol gajda.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Zato e znakonenca phučline e čhavrešće dades sar vo kamel te del alav e čhavres. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","O Zaharija manglas e pločica pe savi šaj te ramol thaj ramosarda: “Jovan si lesko alav.” Thaj savora začudisajle. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Thaj odma o Del putardas lesko muj thaj oslobodisardas lešći čhib thaj o Zaharija počnisarda te ćerel svato thaj te slavil e Devle. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","A e Devlešći dar lija sa lenđe komšijen po gorsko krajo e judejako thaj ćerelas pe svato pale akala događaja. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Thaj savora save ašundine pale akala događaja, gndinas thaj phučenas pe ande peste: “So avela katar akava čhavro? Čače si o vas e Gospodesko pe leste.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","O Zaharije, o dad e čhavresko, pherdilo e Sveto Duhosa, thaj prorokuisardas alavenca: ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Blagoslovime o Gospod o Del e Izraelosko kaj avilo thaj izbavisarda pire theme! ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Vazdas amenđe silno spasitelje andar o potomstvo pire slugasko e Davidesko, ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","sago kaj dumut obećisarda po muj pire svete prorokonengo ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","kaj izbavila men katar amare dušmaja thaj andar e vas savorenđe save mrzin men. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Sas milostivo amare pradadenđe thaj ispunisardas piro sveto savezo, ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","e solah savi dija e Avramešće amare pradadešće. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Izbavisarda men andar amare dušmajenđe vas, te šaj služisaras lešće bi darako, ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ando svetost thaj ande pravda angle leste dokle god sam džude. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","A tu, Jovane čhaveja mungreja, akhardoja proroko e Majbare Devlesko kaj džaja anglo Gospod te lačhares lesko drom. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Sikaveja e Devlešće theme sar te pindžaren o spasenje kroz o jartipe lenđe bezehendar. ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Zbog e bari milost amare Devlešći, osvanila amenđe andar e visine e nevi detharin ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","te anel svetlo okolenđe save trajin ando tunjariko thaj ande dar katar o smrto thaj te upravisares amare korakurja po drom e mirosko.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","A o čhavro Jovano barjolas thaj zuravolas ando duho. Kana barjilo, trajilas ande pustinja sa dok či započnisardas e javno služba angle Izraelcurja. ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ande godoja vrjama kana bijandilo o Jovano, inkljisti e zapoved katar o rimsko caro Avgusto te sa o them savo trajilas ando Rimsko carstvo avel ramome ando popis stanovništva. ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Akava sas o prvo zapis kana o Kvirinije vladilas e Sirijava. ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Sa e manuša teljardine ande pire gava te ramon pe palo popis. ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Gajda vi o Josif teljardas andar o gav Nazaret andar e galilejsko regija, ando Vitlejem e judejsko regija kaj sas o David bijando, kaj o Josif sas potomko e carosko Davidesko ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","te prijavil pe palo zapis zajedno pire verenicasa e Marijasa savi sas khamni. ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Dok sas ando Vitlejem avili laći vrjama te bijanel, ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","thaj bijandas pire prvo čhaves, paćarda les thaj čhuta les ande jasle kaj nas than ande gostijonica. ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ande godoja isto regija savi sas paše pašo Vitlejem sas e pastirja save inćarenas e raćaći straža pe pašnjakurja ke pire bakhre. ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Andar jekhvar o anđelo e Gospodesko ačhilo maškar lende thaj obasjaisarda len e slava e Gospodešći, a von zurale darajle. ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","A o anđelo phendas lenđe: “Na daran! Kaj ake, anav tumenđe e Bahtali nevimata pe bari bah sa e themešće. ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kaj ađes bijandilo tumenđe o Spasitelj, savo si o Gospod Hrist ando gav kaj bijandilo o caro David! ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ake o znako pe savo pindžarena les: araćhena e čhavre paćarde sar pašljol ande jasle.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ande data e anđelošće pridružisajli e bari vojska anđelurja thaj slavinas e Devle alavenca: ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Slava e Devlešće ande nebeske visine, thaj pe phuv miro e themešće savenca si o Del zadovoljno!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Čim e anđelurja boldine pe ando nebo, e pastirja phenenas jek avrešće: “Hajde džas dži ko Vitlejem, te dikhas so godova okote dogodisajlo, so phendas amenđe o Gospod.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Sigo aviline ando than o Vitlejem thaj arakhline e Marija, thaj e Josife thaj e čhavres savo pašljol ande jasle. ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","A kana dikhline e čhavres, e pastirja phendine savorenđe sa so o anđelo phendas lenđe palo čhavro. ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","A savora save ašunenas e pastiren divisajle okolešće so phenenas pale godova čhavro. ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","A e Marija sa akala alava araćhelas ande piro ilo thaj stalno gindilas pale lende ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Pale godova e pastirja boldine pe palpale, hvalinas thaj slavinas e Devle pale sa so dogodisajlo sago kaj vi phendas lenđe o anđelo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","A kana avilo o ohtoto đes sar o čhavro bijandilo, trubujine te obrezin e čhavres, thaj dine les alav Isus, sago kaj phendas o anđelo dok još e Marija či ačhili khamni. ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Kana navršisajle e đesa katar lengo šilaipe prema e Mojsijesko zakon o Josif thaj e Marija inđardine e čhavres ando Jerusalim te predain les e Gospodešće ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(sago kaj si ramome ando zakono e Gospodesko: “Svako prvo bijando, a muško čhavo neka posvetil pe e Gospodešće”) ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","thaj den e žrtva (sago kaj phenel e Gospodesko zakon: “duj grlice ili duj terne goluburja”). ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ande godoja vrjama trajilas ando Jerusalim varesavo manuš savo akhardolas Simeon. Vo sas zurale pravedno thaj pobožno manuš thaj ažućarelas te avel o Mesija te spasil e Izraelcen. O Sveto Duho sas pe leste ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","thaj objavisarda lešće kaj či merela dok či dićhel e Gospodešće Mesija. ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Potaknime katar o Sveto Duho avilo ando Hramo baš kana o dad thaj e dej anenas e čhavre e Isuse te izvršin okova so rodelas o Mojsijesko zakon. ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","O Simeon lija e čhavres ande pire vas thaj hvalisarda e Devle alavenca: ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Akana, Gospode, šaj me ćiro sluga te merav ando miro sago kaj phendan. ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kaj e jakha mungre dikhline o spasenje ćiro, ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","savo pripremisardan angle sa o them, ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","o svetlo te prosvetlil aver themen pe slava ćire themešći e Izraelošći.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","E Isusesko dad thaj lešći dej divisajle okolešće so o Simeon phenelas pale leste. ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","O Simeon askal blagoslovisarda len thaj phendas e Isusešće dejaće e Marijaće: “O Del odredisardas pale akava čhavro te e but e manušenđe ando Izrael avel palo propast thaj butenđe palo vaskrsenje. Vo si odredime te avel e Devlesko znako, ali o but o them odbacila les. ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Akava avela sar te sikadon e gindimata save si garade ande but e ile. A vi tuće korkoraće o mačo hvarela ćiro ilo.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","A okote sas vi e Devlešći proročica savi akhardolas Ana, e Fanuilovešći čhej, voj sas andar e Asiresko pleme thaj sas zurale purani. Trajilas pire romesa samo efta brš, ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","a pale godova trajilas korkoro sar udovica dži ke ohtovardeš thaj štar brš. Voj sas stalno ando Hramo, služilas e Devlešće đeseja thaj e raćava, postilas thaj molilas pe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Thaj samo so o Simeon završisarda vi voj avili thaj hvalilas e Devles thaj phenelas palo Isus savorenđe save ažućarenas te o Del otkupil o Jerusalim. ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Kana o Josif thaj e Marija dine gata so sas po zakono e Gospodesko, boldine pe ande Galileja ando piro gav Nazaret. ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","A o čhavro Jovano barjolas thaj zuravolas thaj pherdolas mudrost, a e milost e Devlešći sas pe leste. ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","E Isusesko dad thaj lešći dej svako brš džanas ando Jerusalim ande đesa kana sas o prazniko Pasha. ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","A kana sas e Isuse dešuduj brš, von aviline Lesa ando Jerusalim te slavin o prazniko. ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Kana sas gata godola đesa, thaj kana boldenas pe ćhere, o čhavro Isus ačhilo ando Jerusalim, a o Josif thaj e čhavrešći dej e Marija či džangline kaj si vo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nego gndisardine kaj si e društvosa anglal. Kana nakhlo već jek đes phiripe počnisardine te roden les maškar e familija thaj maškar okola kasa džanenas. ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Sar či arakhline les boldine pe ando Jerusalim te roden les. ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Thaj o trito đes arakhline les ando Hramo sar bešel maškar e učitelja thaj čholas kan lende thaj phučelas len. ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","A savora save ašunenas les divisajle lešće gođaće thaj lešće odgovorenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Kana dikhline les začudisajle, a lešći dej phendas lešće: “Čhaveja! Sostar ćerdan amenđe gadava? Ake me thaj ćiro dad e darasa rodam tut.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","A o Isus phendas lenđe: “Sostar rodine man zar či džangline kaj me trubul te avav ando ćher mungre Dadesko?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ali von či haćardine so o Isus kamlas te phenel lenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Askal bolda pe lenca ando Nazaret thaj čholas kan lende. A e dej lešći lelas sama pe sa akala događajurja ande piro ilo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","A o Isus napreduilas ande mudrost thaj barjolas ande milost anglo Del thaj anglo them. ");
INSERT INTO rmyChergash_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Sas dešupandžto brš sar vladilas o caro Tiberija e rimske carstvosa, o Pontije Pilato vladilas e judejava, o Irod vladilas e galilejava, a lesko phral o Filip vladilas ande Itureja thaj ande Trahonitada, o Lisanije vladilas ande Avilina, ");
INSERT INTO rmyChergash_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","o Ana thaj o Kajafa sas e šorvale rašaja, a o Del askal objavisarda piro alav e Jovanošće e Zaharijašće čhavešće ande pustinja. ");
INSERT INTO rmyChergash_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Thaj o Jovano savo bolelas nakhlas e sasti okolina oko e reka e Jordan thaj propovedilas e themešće kaj e manuša trubun te obratin pe e Devlešće te jartol lenđe bezeha thaj te bolen pe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Sago kaj ramol ando Sveto lil e prorokosko Isaijasko: “Vo si o glaso savo čhol muj ande pustinja: ‘Pripremin o drom palo Gospod, vorton e staze pale leste! ");
INSERT INTO rmyChergash_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Neka svako dolina pherdol a svako gora neka slegnilpe! Sa e banđe droma neka ispravin pe thaj e grbave droma postanina ravne. ");
INSERT INTO rmyChergash_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Thaj svako manuš dićhela o spasenje savo avel katar o Del.’ ” ");
INSERT INTO rmyChergash_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","O Jovano phenelas okolenđe save avenas te bolen pe: “Tumen e sapešće čhavra! Koli upozorisarda tumen te našen katar e Devlešći bari holji savi avel? ");
INSERT INTO rmyChergash_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Sikaven tumare trajosa thaj tumare delenca kaj odvoisajle katar o bezeh thaj kaj obratisajle e Devlešće. Na hohaven tumen kaj si tumenđe dosta te phenen: ‘Amen sam e Avramešće potomkurja,’ kaj phenav tumenđe kaj o Del šaj vi katar akala bara te vazdel čhavra e Avramešće.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kaj o tover e Devlešće sudosko već si čhutino po koreno e kaštesko. Svako kaš savo či bijanel lačhe plodurja čhinela pe thaj čhudela pes ande jag. ");
INSERT INTO rmyChergash_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Askal o them phučla les: “So askal te ćeras?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","A o Jovano phendas lenđe: “Kas si duj gada neka del jek okole kas naj. Thaj kas si habe neka del okoles kas naj.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Aviline vi e carinikurja te o Jovane bolel len thaj phendine lešće: “Učiteljina, so amen te ćeras?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","A o Jovane phendas lenđe: “Na roden majbut porezo nego so odredil tumenđe e vlast.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","E vojnikurja isto phučline: “A amen so te ćeras?” A vo phendas lenđe: “Khonikastar na len love pe sila, na optužin khonikas hohamne thaj aven zadovoljno tumare poćinava.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ande godoja vrjama o them ažućarelas e Mesija thaj savora ande pire ile phučenas pe te naj možda o Jovano Mesija. ");
INSERT INTO rmyChergash_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Zato o Jovano phendas savorenđe: “Me bolava tumen e pajesa, ali avel vareko pale mande ko si majmoćno mandar, kašće me naj sem dostojno ni e haravlja pe sandale te putrav. Vo bolela tumen e Sveto Duhosa thaj e jagasa. ");
INSERT INTO rmyChergash_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Vo si spremno te losarel o kućin e đivesko katar e pleva. O điv ćidela thaj spremila ande piri žitnica, a e pleva dela jag e jagasa savi našti mudardol.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Thaj but kasave opomene o Jovano phendas e themešće thaj navestilas lenđe e Bahtali nevimata. ");
INSERT INTO rmyChergash_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","A o Irod o vladari kas o Jovano ukorisarda zato kaj lijas e Irodijada savi sas romnji lešće phralešći, thaj pale sa aver bilačhimata save ćerda, ");
INSERT INTO rmyChergash_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","pe sa godova još vi e Jovane čhuda ande tamnica. ");
INSERT INTO rmyChergash_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Kana o Jovano bolelas sa e themes, bolape vi o Isus. Dok o Isus molisajlo, putajlo o nebo, ");
INSERT INTO rmyChergash_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","thaj fuljisto pe leste o Sveto Duho ando telesno obliko sago golubo, thaj andar o nebo ašundilo o glaso savo phendas: “Tu san mungro voljeno Čhavo. Tu san mungri bah!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Kana o Isus započnisardas e javno služba katar o Del, sas les varekaj katar trijanda brš. Inćarelas pe kaj si o Isus čhavo e Josifesko. O Josif sas e Ilijesko čhavo, ");
INSERT INTO rmyChergash_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","o Ilija sas e Matatesko čhavo, a o Matat e Levijesko čhavo, o Levije sas e Melhijesko čhavo, o Melhi sas e Janajesko čhavo, o Janaj e Josifesko čhavo, ");
INSERT INTO rmyChergash_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","o Josif sas e Matatesko čhavo, o Matatija sas e Amosesko čhavo, o Amos sas e Naumasko čhavo, o Naum sas e Eslijesko čhavo, o Eslija sas e Nangejesko čhavo, ");
INSERT INTO rmyChergash_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","o Nangej sas e Maatesko čhavo, o Maat sas e Matatijesko čhavo, o Matatija sas e Semeinasko čhavo, o Semein sas e Josihesko čhavo, o Josih sas e Jodasko čhavo, ");
INSERT INTO rmyChergash_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","o Joda sas e Joananesko čhavo, o Joanan sas e Risasko čhavo, o Risa sas e Zorovavelesko čhavo, o Zorovavel sas e Salatilesko čhavo, o Salatiil sas e Nirijasko čhavo, ");
INSERT INTO rmyChergash_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","o Niri sas e Melhijesko čhavo, o Melhi sas e Adijasko čhavo, o Adi sas e Kosamesko čhavo, o Kosam sas e Elmadamesko čhavo, o Elmadam sas e Iresko čhavo, ");
INSERT INTO rmyChergash_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","o Ir sas e Isusesko čhavo, o Isus sas e Eliezeresko čhavo, o Eliezer sas e Jorimesko čhavo, o Jorim sas e Matatesko čhavo, o Matat sas e Levijesko čhavo, ");
INSERT INTO rmyChergash_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","o Levije sas e Simeonesko čhavo, o Simeon sas e Judasko čhavo, o Juda sas e Josifesko čhavo, o Josif sas e Jonamesko čhavo, o Jonam sas e Eliakimesko čhavo, ");
INSERT INTO rmyChergash_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","o Eliakim sas e Melejasko čhavo, o Meleja sas e Menasko čhavo, o Mena sas e Matatesko čhavo, o Matata sas e Natanesko čhavo, o Natan sas e Davidesko čhavo, ");
INSERT INTO rmyChergash_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","o David sas e Jesejesko čhavo, o Jesej sas e Jovidesko čhavo, o Jovid sas e Voozesko čhavo, o Vooz sas e Salmonesko čhavo, o Salmon sas e Naasonesko čhavo, ");
INSERT INTO rmyChergash_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","o Naason sas e Aminadavesko čhavo, o Aminadav sas e Adminesko čhavo, o Admin sas e Arnijesko čhavo, o Arni sas e Esromesko čhavo, o Esrom sas e Faresesko čhavo, o Fares sas e Judasko čhavo, ");
INSERT INTO rmyChergash_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","o Juda sas e Jakovesko čhavo, o Jakov sas e Isakosko čhavo, o Isak sas e Avraamesko čhavo, o Avram sas e Taresko čhavo, o Tara sas e Nahoresko čhavo, ");
INSERT INTO rmyChergash_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","o Nahor sas e Seruhesko čhavo, o Seruh sas e Ragavesko čhavo, o Ragav sas e Falekesko čhavo, o Falek sas e Everesko čhavo, o Ever sas e Salasko čhavo, ");
INSERT INTO rmyChergash_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","o Sala sas e Kainamesko čhavo, o Kainam sas e Arfaksadesko čhavo, o Arfaksad sas e Simesko čhavo, o Sim sas e Nojesko čhavo, o Noje sas e Lamehesko čhavo, ");
INSERT INTO rmyChergash_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","o Lameh sas e Matusalinesko čhavo, o Matusalin sas e Enohesko čhavo, o Enoh sas e Jaretesko čhavo, o Jaret sas e Malaleilesko čhavo, o Malaleil sas e Kainamesko čhavo, ");
INSERT INTO rmyChergash_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","o Kainam sas e Enosesko čhavo, o Enos sas e Sitesko čhavo, o Sit sas e Adamesko čhavo, o Adam sas e Devlesko čhavo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","O Isus, pherdo e Sveto Duhosa, bolda pe katar e reka Jordan thaj o Sveto Duho inđardale ande pustinja, ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","okote o beng iskušilas les štarvardeš đesa thaj khanči či hala pale godoja vrjama, a kana nakhline godola đesa vo bokhajlo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","A o beng phendas lešće: “Ako san Čhavo e Devlesko, phen akale barešće te postanil mangro.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","A o Isus phendas lešće: “Ando Sveto lil ačhel ramome: ‘Či trajil o manuš samo katar o mangro.’” ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","O beng inđarda les pe vuči gora thaj sikadas lešće sa e carstvurja akale themešće ando treno e jakhako. ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Thaj phendas lešće o beng: “Tuće dava sa akaja vlast thaj e slava lenđi, kaj si manđe predaime thaj me šaj te dava len kašće me kamav. ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ako peres pe koča angle mande thaj slavis man, sa avela ćiro.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","A o Isus phendas lešće: “Ando Sveto lil ačhel ramome: ‘De koča samo anglo Gospod ćiro Del, thaj jedino les slavi.’” ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Thaj o beng inđarda les ando Jerusalim thaj čhuta les po vrho e Hramosko thaj phendas lešće: “Ako san tu Čhavo e Devlesko, čhude tut katar tele ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","kaj ando Sveto lil ramol: ‘Pire anđelenđe zapovedila pale tute te len sama pe tute’, ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","thaj: ‘von pe vas inđarena tut te či pećes e pungresa ando bar.’” ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","A o Isus phendas lešće: “Ramome si vi akava: ‘Na iskušisar e Gospode ćire Devle.’” ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Thaj kana o beng završisarda te iskušil les, đelotar lestar pale varesošći vrjama. ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","O Isus bolda pe ando galilejako krajo pherdo e Sveto Duhošće silava thaj o glaso pale leste buljilo pe sasto godova krajo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Sikavelas pe lenđe sinagoge, thaj savora šukar mothonas pale leste. ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Thaj avilo ando gav savo akhardolas Nazaret kaj barilo thaj pe piro običaj ando savato dija ande sinagoga thaj uštilo te čitol, ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","a dine les o lil katar o proroko Isaija, putardas o lil thaj arakhla o than kaj si ramome: ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“O Duho e Gospodesko si pe mande zato makhlas mungro šoro e uljeja thaj bičhalda man te anav e Bahtali nevimata e čorenđe, bičhalda man te propovediv e phanglenđe kaj avena oslobodime, thaj e korenđe kaj dićhena, a e mučime kaj avena oslobodime ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","thaj te proglasiv o brš milosti e Gospodesko”. ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Phandada o Lil, dija les ko sluga thaj bešlo te sikavel, a savora save sas ande sinagoga dićhenas pe leste. ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Thaj počnisarda te phenel lenđe: “Ađes akava Lil savo ašundine tumare kanenca pherdilo.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Savora phenenas sa majšukar pale leste thaj divinas pe e šukar alavenđe kaj inkljenas andar lesko muj thaj phenenas: “Naj li akava o čhavo e Josifesko?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Askal phendas lenđe: “Tumen manđe bi sumnjako mothona akaja poslovica: ‘Doktorina! Sastar korkoro tut!’ Ćer vi akate ande ćiro gav kaj barilan so ašundam kaj ćerdan ando Kafarnaum.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Askal ačhilo majdur te mothol: “Čače phenav tumenđe: ‘Nijek proroko či lačhe avilo ande piro gav kaj bajrilo.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","A čače phenav tumenđe: E but udovice sas ando Izrael ande vrjama kana sas o Ilija proroko, askal o nebo phandadilo pe trin brš thaj šov čhon thaj sas bari bok pe sasti phuv e Izraelošći. ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ali nijećhaće lendar nas bičhaldo o Ilija osim varesave udovicaće ando gav Sarepta, savo sas ando Sidonsko krajo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Thaj but gubavcurja sas ando Izrael pale vrjama kana sas o Jelisej proroko ali ni jek lendar či sastilo nego samo o Neman andar e Sirija.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Thaj savora ande sinagoga zurale holjajle kana ašundine akava. ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Uštile thaj tradine les avri andar o gav thaj inđardine les po vrho e gorako kaj sas sazidome lengo gav te čhuden les opral. ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ali vo nakhlo maškar lende thaj đelotar. ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Thaj avilo ando galilejsko gav savo akhardolas Kafarnaum thaj sikavelas len ando savato. ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","A o but o them čudilas pe lešće sikavipešće kaj lesko svato sas pherdo sile. ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ande sinagoga sas varesavo manuš ande savo sas bilačho duho e benđesko, vo čhuta muj zurale glasosa: ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“So kames amendar, Isuse andar o gav Nazaret? Avilan te uništis men? Džanav ko san: Sveco e Devlesko.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","A o Isus zapovedisardas lešće: “Phande ćiro muj thaj inklji andar leste!” Askal o demono harada les angle savorende, inkljisto andar leste thaj ni cara či naudisardas lešće. ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Savora sas but začudime thaj phenenas jek avrešće: “Sosko si godova svato, te ando autoriteto thaj ande sila zapovedil e bilačhe duhonenđe thaj von inkljen!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Thaj o glaso pale leste buljilo pe sa e okolne thana. ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Kana inkljisto andar e sinagoga thaj đelo ande Simonesko ćher. E Simonešće sokra sas e bari jag thaj ćhinolas lat e groznica, pa zamolisardine les te sastarel lat. ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Vo banđilo paše late thaj zapovedisardas e jagaće te mućela thaj e jag nestanisardas. Voj odma uštili thaj ačhili te služil len. ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kana nakhlas o savatosko đes, sa e nasvalen katar razne nasvalimata, anenas ko Isus, a vo pe savorende čholas pire vas thaj von sastonas. ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","A vi e bilačhe duhurja inkljenas andar e but e manuša thaj čhonas muj thaj phenenas: “Tu san Čhavo e Devlesko!” A vo pretilas lenđe thaj zabranisarda lenđe te na ćeren svato, kaj von džanenas kaj si vo o Hristo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","A kana svanosardas o đes, inkljisto thaj đelotar po pusto than. A o them rodelas les. Kana arakhline les avile leste thaj kamline te ačhaven les te na džaltar lendar. ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","A vo phendas lenđe: “Vi e manušenđe andar e aver gava trubul te anav e Bahtali nevimata pale Devlesko carstvo, kaj zato o Del bičhalda man.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Thaj nastavisarda te propovedil pe judejske sinagoge. ");
INSERT INTO rmyChergash_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Jekhvar kana o Isus ačhelas pe obala ko galilejako jezero, o them spidelas pes pe leste te ašunen o alav e Devlesko. ");
INSERT INTO rmyChergash_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","O Isus lija sama e duj čamcurija kaj ačhenas pe obala andar save inkljistine e ribarja thaj halavenas pire mreže. ");
INSERT INTO rmyChergash_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Thaj dija ande jek katar o čamco savo sas e Simonesko thaj zamolisarda les te spiden les cara majdur katar e obala. Bešlo andre thaj počnisarda te sikavel e theme andar o čamco. ");
INSERT INTO rmyChergash_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","A kana o Isus ačhilo te ćerel svato e themešće, phendas e Simonešće: “Otplovisar okote kaj si handuk o paj thaj čhude e mreže ćire thaj astar e mačhen.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","A o Simon phendas lešće: “Učiteljina! Sasti rjat trudisajlam thaj khanči či astardam, ali ako tu gajda phenes, čhudava e mreže.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kana ćerdine godova, astardine but mačhe, gaći kaj pharjonas lenđe mreže. ");
INSERT INTO rmyChergash_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Dine znako pire drugarenđe ando aver čamco te aven te pomožin len. Kana von aviline, pherdine e liduj čamcurija gajda kaj gata potonisardine. ");
INSERT INTO rmyChergash_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","A kana dikhla o Simon Petar, pelo pe pire koča angle Isusešće pungre thaj phendas: “Džatar mandar, Gospode! Me sem bezehalo manuš.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Thaj sas ando čudo o Petar thaj savora save sas lesa zbog e bute e mačhe kaj astardine. ");
INSERT INTO rmyChergash_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","A gajda vi o Jakov thaj o Jovano sas ando čudo. Von sas e čhave e Zevedeješće thaj e drugarja e Simonešće. A o Isus phendas e Simonešće: “Na dara! Katar akana e manušen astareja sago e mačhen.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Thaj crdine e čamcurja pe phuv, mukline sa thaj teljardine pale leste. ");
INSERT INTO rmyChergash_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Kana sas o Isus ande jek gav, dijas pe jek manuš savo sas sa ande guba. Dikhla e Isuse thaj pelo angle leste e mujesa dži ke phuv, thaj zamolisarda les: “Gospode! Te kames šaj te sastares man katar e guba.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Vo čhuta po vas pe leste thaj phendas: “Kamav, av sasto!” Thaj e guba odma peli lestar. ");
INSERT INTO rmyChergash_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","A o Isus zapovedisardas lešće: “Na phen khonikašće, nego dža thaj sikav tu e rašaješće thaj prinesisar ćiri žrtva palo ćiro sastipe, sar odredisardas o Mojsije. Godova avela sago dokazo e manušenđe.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","A o glaso pale leste još majbut buljolas thaj o but o them ćidelas pe te ašunen les thaj te sastarel len katar lenđe nasvalimata. ");
INSERT INTO rmyChergash_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","A vo đelotar ande pustinja te molil pe e Devlešće. ");
INSERT INTO rmyChergash_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Jek đes dok o Isus sikavelas e themes, bešenas lesa e fariseja thaj e učitelja e Mojsiješće zakonestar save aviline andar sa e galilejske gava, judejske thaj andar o Jerusalim. A e sila e Gospodešći sas e Isuseja te sastarel e nasvalen. ");
INSERT INTO rmyChergash_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Askal aviline varesošće manuša save inđarenas pe nosilje e manušes savo sas lino. Kamline te anen les andre thaj te čhon les anglo Isus. ");
INSERT INTO rmyChergash_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ali, sar katar o but o them našti dine lesa andre, line pe po krovo e ćheresko thaj kroz o krovo mukline les tele zajedno e nosiljasa maškare anglo Isus. ");
INSERT INTO rmyChergash_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Kana o Isus dikhla lengo paćipe, phendas e line manušešće: “Manušeja, jartompe tuće ćire bezeha.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","E fariseja thaj e učitelja e Mojsiješće zakonestar počnisardine te gndin: “Ko si akava kaj hulil po Del? Ko šaj te jartol e bezeha osim o Del?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","A o Isus džangla lenđe gindimata thaj phendas lenđe: “Sostar gajda gndin ande tumare ile? ");
INSERT INTO rmyChergash_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","So si majloće te phenel pe: ‘Jartime si tuće ćire bezeha’ ili te phenel pe: ‘Ušti thaj phir’? ");
INSERT INTO rmyChergash_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Dokaživa tumenđe kaj man, e Čhaves e Manušešće, si vlast pe phuv te jartosarv e bezeha.” Askal phendas e line manušešće: “Tuće phenav: ‘Ušti, le ćire nosilje thaj džatar tuće ćhere!’” ");
INSERT INTO rmyChergash_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Vo odma uštilo angle lende thaj lija pe soste pašljolas thaj đelotar pire ćherešće thaj hvalilas e Devle. ");
INSERT INTO rmyChergash_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Savora sas ando čudo, slavinas e Devle thaj pherde dar phenenas: “Čudurja ađes dikhlam!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Pale godova o Isus inkljisto thaj dikhla e cariniko savo bučholas Levije kaj bešel po than kaj poćinelas pe o porezo thaj phendas lešće: “Av pale mande.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","O Levije mukla sa, uštilo thaj teljarda pale leste. ");
INSERT INTO rmyChergash_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Pale godova o Levije ćerda lešće ande piro ćher bari gozba. Leja pale sinija bešenas but carinikurja thaj vi aver manuša. ");
INSERT INTO rmyChergash_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Askal e fariseja thaj lenđe učitelja e Mojsiješće zakonestar počnisardine te mrmljan pe leste thaj phendine lešće učenikonenđe: “Sostar han thaj pijen e carinikonenca thaj e bezehalenca?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","A o Isus phendas lenđe akaja izreka: “‘Či trubun e saste manuša e doktore nego e nasvale’. ");
INSERT INTO rmyChergash_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Gajda vi me či avilem te akharav e pravednikonen, nego e bezehalen te bolden pe katar pire bezeha ko Del.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Von askal phendine lešće: “Sostar e Jovanošće učenikurja često postin thaj molin pe, isto gajda vi e farisejenđe učenikurja, a ćire či postin nego han thaj pijen?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","A o Isus phendas lenđe: “Tugujin li e svaturja dok si o džamutro lenca? Nisar! ");
INSERT INTO rmyChergash_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Nego avela o đes kana otmina lendar e džamutre thaj askal postina ande godola đesa.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","O Isus phendas lenđe još jek paramiči ande slike: “Khonik či čhinel o nevo kotor katar e nevi haljina te suvel pe purani haljina. Ako godova ćerel, e nevi haljina čhindola, a e purane haljinaće či ačhela o kotor katar e nevi haljina. ");
INSERT INTO rmyChergash_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Khonik či čhol e nevi mol ande purani morćhaći trasta, kaj e nevi mol pharavela e trasta thaj e mol čhordola, a e morćhaći trasta propadnila. ");
INSERT INTO rmyChergash_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nego e nevi mol ande nevi morćhaći trasta trubul te čhol pe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Thaj khonik ko pijel e purani mol, či kamel e nevi, kaj phenel e purani mol si majlačhi.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Jek savato kana o Isus naćhelas maškar e njive, lešće učenikurja trgonas o điv e vastenca thaj hanas. ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","A varesave katar e fariseja phendine e Isusešće: “Sostar ćeren, okova so po zakono naj muklo te ćerel pe savatone?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","A o Isus phendas lenđe: “Sigurno čitosardine ando Sveto lil so o David ćerda, kana vo thaj okola save sas lesa bokhajle a nas len so te han. ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Dijas ande Devlesko ćher thaj lijas e svete mangre save či tromal te hal khonik osim e rašaja, hala thaj dija vi okolenđe save džanas pale leste.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Thaj phendas lenđe: “Kaj me, o Čhavo e Manušesko, gospodari sem e savatosko.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","A jek aver savato, o Isus dija ande sinagoga thaj sikavelas, a okote sas jek manuš e šuće vastesa. ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","E fariseja thaj e učitelja e Mojsiješće zakonestar inćarenas e jakha pe leste te dićhen dali sastarel lat ando savato te došaren les. ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","A vo džanglas e gindimata lenđe thaj phendas e manušešće e šuće vastesa: “Ušti thaj ačh maškare.” A vo uštilo thaj ačhilo angle manuša. ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","A o Isus phendas lenđe: Te phučav tumen: “Dali tromal pe savatone te ćerel pe lačhipe ili bilačhipe, o trajo te spasil pe ili te hasarelpe?” A von samo ačhenas. ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","O Isus dikhla pe lende savorende thaj phendas e manušešće e šuće vastesa: “Inzar ćo vas.” A vo ćerda gajda thaj o vas lesko sastilo thaj sas sasto sago vi aver. ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","A e fariseja thaj e učitelja e Mojsiješće zakonestar holjajle thaj ćerdine svato maškar pende so te ćeren e Isuseja. ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ande godoja vrjama o Isus đelo pe gora te molil pe. Okote ačhilo sasti rjat thaj molilas pe e Devlešće. ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Thaj kana avilo o đes, akhardas pire e učenikonen thaj losarda maškar lende e dešudujen, thaj akharda len apostolurja a lenđe alava sas: ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","O Simon (saves akharenas Petar), thaj o Andrija (e Petresko phral), o Jakov thaj o Jovan, o Filip thaj o Vartolomej, ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","o Matej thaj o Toma, o Jakov (savo sas čhavo e Alfejevesko) thaj o Simon (savo sas pobunjeniko), ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","o Juda (čhavo e Jakovesko), thaj o Juda (andar o gav Iskariot, savo izdaisarda les). ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Pale godova o Isus fuljisto lenca tele katar e gora thaj ačhilo po ravno than. Okote sas baro brojo lešće učenikurja thaj o silno them andar o krajo e judejako, andar o Jerusalim, andar e tirske thaj andar e sidonske gava pašo more. ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Von aviline te ašunen les thaj te sastarel len katar lenđe nasvalimata, a avenas vi okola saven mučinas e bilačhe duhurja, a o Isus oslobodilas len. ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Thaj sa o them rodelas te čhon pire vas pe leste, kaj andar leste inkljelas e sila thaj von sa sastonas. ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Vo dikhla pe pire učenikurja thaj phendas: “Blago tumenđe save sen čore, kaj si tumaro e Devlesko carstvo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Blago tumenđe save sen akana bokhale, kaj čaljona. Blago tumenđe save akana roven, kaj asana. ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Blago tumenđe kana e manuša mrzana tumen, kana odbacina tumen, kana ladžarena tumen, thaj kana phenena pale tumende kaj sen bilačhe, zbog godova kaj paćan ande mande, ando Čhavo e Manušesko! ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Radujin tumen ande godola đesa thaj ćhelen e bahtatar, kaj bari si tumari nagrada po nebo! Kaj sa godova bilačhipe isto gajda amaro them ćerelas amare prorokonenđe ande lenđi vrjama. ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ali teško tumenđe save sen akana barvale, kaj već primisardine e uteha tumari. ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Teško tumenđe kaj sen akana čaljarde, kaj bokhavona. Teško tumenđe kaj asan akana, kaj rovena thaj tugujina. ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Teško tumenđe kana savora lačhe mothona pale tumende, kaj isto gajda amaro them ćerelas amare hohamne prorokonenđe ande lenđe vrjama.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ali tumenđe save ašunen phenav: Volin tumare dušmajen! Ćeren lačhipe okolenđe save mrzan tumen! ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Blagoslovin okolen kaj den tumen romaja! Molin tumen e Devlešće pale okola save vređon tumen. ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ako vareko pećel tut pe jek rig e muješći, bolde lešće vi aver rig. Ako vareko lijas ćiro ogrtači, de les vi ćiro gad. ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ko manđel tutar vareso, de les. A okolestar kaj otmil ćiro, na rode palpale. ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Thaj askal sar kamen te ćeren e manuša tumenđe, gajda ćeren vi tumen lenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ako volin samo okolen save tumen volin, sošći avela tumari nagrada? Kaj vi e bezehale volin samo okolen save len volin. ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Thaj ako ćeren lačhipe samo okolenđe kaj tumenđe ćeren lačhipe, sošći avela tumari nagrada? Kaj vi e bezehale ćeren gajda. ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Thaj te den udžile samo okolen katar save ažućaren te bolden tumenđe, sošći avela tumari nagrada? Kaj vi e bezehale den e bezehalen udžile te šaj palem dobin palpale. ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Volin tumare dušmajen, ćeren lenđe lačhipe, den len udžile thaj na ažućaren khanči te bolden tumenđe. Ako ćeren gajda, avela bari tumari poćin, thaj avena čhave e Majbarešće, kaj si vo lačho čak vi okolenđe kaj si nezahvalne thaj vi e bilačhenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Aven dakle bare ileja sago kaj si vi tumaro nebesko Dad bare ileja.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Na sudin thaj či sudila pe tumenđe. Na osudin thaj či avena osudime. Jartosaren thaj jartola pe tumenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Den thaj dela pe tumenđe. Čhordola pe tumenđe ande angalja lačhi mera, nabime, ćhinosardi thaj preobilno kaj sošće merava merin kasave merava merila pe tumenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Thaj phendas lenđe akaja paramiči ande slike: “Dali šaj o koro e kore te vodil? Či li perena liduj ande hv? ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nijek učeniko naj majbaro katar piro učitelj. Svako savo si sikado dži ko krajo, avela sago vi o učitelj lesko. ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Sostar dićhes e kaštešći prušuk ande jak ćire phralešći, kana či haćares o baro kaš ande ćiri jak? ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Sar šaj phenes ćire phralešće: ‘Phrala, ažućar te inkalav e kaštešći prušuk savi si ande ćiri jak’, kana ni korkoro či haćares o baro kaš ande ćiri jak? Licemernona! Majsigo inkal o baro kaš andar ćiri jak thaj majlačhe dićheja e kaštešći prušuk te inkal les andar ćire phralešći jak.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Lačho kaš či bijanel bilačhe plodurja, a bilačho kaš či bijanel lačhe plodurja. ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kaj svako kaš pe piro plodo pindžarel pes. E smokva thaj e drak či kušen pe katar e kangre. ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","O lačho manuš andar e lačhi riznica pire ilešći inkalel lačhipe, a o bilačho manuš andar piro bilačho ilo inkalel o bilačhipe, kaj andar o muj inkljel sova si pherdo o ilo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Sostar akharen man: ‘Gospode! Gospode!’ A naj sen paćivale okolešće so phenav tumenđe? ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Sikavava tumenđe pe kaste anel svako savo avel mande, ašunel mungre alava thaj si paćivalo mungre alavenđe: ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Slično si sago o manuš savo agajda ćerda piro ćher: hanadas handuk thaj čhuta o temelji pe stena. Kana avili e poplava, o paj navalisarda po ćher, ali našti harada les kaj sas lačhe sagradime. ");
INSERT INTO rmyChergash_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","A okova savo ašundas mungre alava a naj paćivalo mungre alavenđe, vo si sago o manuš savo vazdas piro ćher pe phuv bi temeljesko, pe savo navalisarda o paj, odma harada o ćher thaj katar godova ćher sas bari ruševina.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Kana o Isus dija gata sa godola alava anglo them, dija ando gav Kafarnaum. ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Varesave rimske kapetano sas robo savo sas nasvalo po smrto, a vo sas lešće but drago. ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","A kana o kapetano ašundas palo Isus, bičhaldas lešće e židovske starešinen thaj molisarda les te avel te sastarel lešće slugo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","A von aviline ko Isus thaj počnisardine ilestar te molin les alavenca: “Zaslužisarda te ćeres lešće godova, ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","kaj volil amare theme thaj vo vazdas amenđe e sinagoga.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","A o Isus teljarda lenca. Thaj kana sas već paše ko ćher, bičhalda o kapetano pire drugaren leste te phenen lešće: “Gospode! Na trudi tu, kaj Naj sem dostojno te des ande mungro ćher. ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Zato vi či inćara man dostojno te avav angle tute, nego samo phen alav thaj o sluga mungro sastola. ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kaj, vi me sem manuš tale vlast thaj si man tale mande vojnikurja. Thaj kana phenav jećhešće: ‘Dža!’, vo džaltar. Thaj kana phenav averešće: ‘Av!’, vo avel. Thaj kana phenav mungre robošće: ‘Ćer godova!’ vo ćerel.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","A kana godova ašundas o Isus, zadivisajlo e kapetanošće thaj bolda pe ko them savo džalas pale leste thaj phendas: “Phenav tumenđe: kasavo paćipe či arakhlem ke nijek manuš ando Izrael!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","A kana okola kaj sas bičhalde katar o kapetano boldine pe ćhere, arakhline e robo kaj si sasto. ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Pale godova o Isus teljarda ando gav savo akhardolas Nain. Pale leste džans e učenikurja thaj o but o them. ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Kana avilo paše ke gavesko vudar, baš askal inkalenas e mule, čhave savo sas jedinco pire dejako savi sas udovica. Lava sas o but o them andar o gav. ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Kana dikhla lat o Gospod, sažalisajlo pe late thaj phendas laće: “Na rov!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Pale godova avilo ko mohto, čhuta pire vas pe leste thaj okola kaj inđarenas o mohto ačhiline. A vo phendas: “Čhaveja, tuće phenav: Ušti!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","O mulo vazda pe, bešlo thaj počnisarda te ćerel svato. A o Isus dija les lešće dejaće. ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","A savora zadivisajle thaj počnisardine te hvalin e Devle alavenca: “Baro proroko avilo maškar amende!” thaj: “O Del avilo ando pomoć pire themešće!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Thaj godova glaso pale leste buljilo pe saste judejske krajurja thaj pe sasti okolina. ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","E Jovanošće učenikurja javisardine e Jovanošće so o Isus ćerda. A vo akhardas pire dujen učenikonen ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","thaj bičhalda len ko Gospod te phučen les: “Dali san tu okova saves o Del obećisarda kaj bičhalela les ili te ažućaras avres?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Kana akala duj manuša aresline leste, phendine: “O Jovano savo bolel bičhalda amen tute te phučas tut: ‘Da li san tu okova saves obećisarda o Del kaj trubul te avel, ili te ažućaras avres?’” ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","O Isus baš ande godova časo sastarelas e buten katar lenđe muke, razne nasvalimata thaj katar e bilačhe duhurja thaj e bute kore manušenđe boldas o vido. ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","A o Isus phendas lenđe: “Džan thaj phenen e Jovanošće so upravo dikhline thaj so ašundine: e kore dićhen, e banđe phiren, e gubavcurja saston, e kašuće ašunen, e mule bolden pes ando trajo, a e čorenđe propovedil pe e Bahtali nevimata. ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Blago okolešće savo či sablaznil pe zbog mande.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","A Kana e Jovanošće učenikurja đeletar, o Isus počnisarda te mothol e themešće palo Jovano: “So đeline te dićhen ande pustinja? E trska, savja ljuljil e balval? Na! ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","So đeline te dićhen? Manušes savo lija pe peste šukar drze? Na! E manuša save inđaren pe peste e šukar drze thaj trajin ando raskoš, von si ande carošće dvorurja. ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","So dakle inkljistine te dićhen? E proroko? Ej, me phenav tumenđe, vo si majbut vi katar o proroko. ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Kaj o Jovano si okova pale savo o Del phendas ando Sveto lil: ‘Ake, me bičhalav angle tute mungre glasniko savo pripremila o drom angle tute.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Phenav tumenđe: katar sa e manuša save sas ikada bijande, khonikal naj majbaro katar o Jovano savo bolelas, a okova savo si majcikno ande Devlesko carstvo majbaro si lestar.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Kana sa o them thaj vi e carinikurja save sas bolde e Jovanošće boldimasa, ašundine e Isuse sar ćerel svato priznaisardine kaj si e Devlesko sikavipe ispravno. ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","A e fariseja thaj e učitelja e Mojsiješće zakonestar, či kamenas te bolel len o Jovano. Von odbisardine so o Del planirisarda pale lende. ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","O Isus phendas: “Kasa te usporediv e manušen katar akaja generacija? Kašće si slične? ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Lenca si sago e čhavrenca save bešen po sokako thaj jek avrešće čhon muj: ‘Svirosardam tumenđe veselo, a tumen či ćheldine, đilabadam tumenđe tužno, a tumen či rujine!’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Gajda avilo o Jovano savo bolelas. Niti halas mangro niti pijelas mol, a tumen phenen: ‘O bilačho duho si ande leste!’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Avilem me, o Čhavo e Manušesko. Vi hav vi pijav, a tumen phenen: ‘Dik, o manuš halapljivo thaj matarno, drugari e carinikonengo thaj e bezehalengo.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Savora save prihvatin e Develešći mudrost sikaven kaj si voj čači.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Varesavo farisejo zamolisarda e Isuse te hal leste. O Isus dija ande farisejsko ćher thaj lijas than pale sinija. ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kana ake avili varesošći manušnji savi sas bezehali ando gav. Ašunda kaj si o Isus pale sinija ande farisejsko ćher, avili thaj andas e alabasterosko čaroro ande savo sas kuč mirisno ulje. ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ačhili pale lešće pungre, rovelas thaj e jasvenca thovelas lešće pungre a pire balenca khoselas len. Čumidelas len thaj maćhelas len e mirisne uljeja. ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Kana godova dikhla o fariseji savo akharda e Isuse ande piro ćher, gndisardas ande peste: “Kana akava avilosas proroko, džanglasas ko si thaj sošći si akaja manušnji, savi diril les, kaj si bezehali.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","O Isus phendas lešće: “Simone, si man vareso te phenav tuće.” A vo phendas: “Phen, učiteljina.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","O Isus majdur motholas: “Sas varesavo manuš savo delas averenđe udžile love. Gajda sas duj džene save sas lešće udžile. Jek sas lešće udžile pandž šela rupune lovora, a aver pandžvardeš. ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Sar našti te boldine e love save sas lešće udžile, vo jartosardas liduj dženenđe o dugo. Savo lendar majbut volila les?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","O Simon phendas: “Gndiv kaj okova savešće si majbut jartome.” A o Isus phendas lešće: “Lačhe phenes.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Gajda bolda pe ke manušnji thaj phendas e Simonešće: “Dićhes akala manušnja? Dijem ande ćiro ćher, a tu ni paj či dijan man te thovav mungre pungre, a voj pire jasvenca thoda mungre pungre thaj pire balenca khosla len. ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Tu či ni čumidan man, a voj, sar dija andre, či ačhili te čumidel mungre pungre. ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Uljeja mungro šoro či makhlan, a voj e mirisne kuč uljeja mungre pungre makhlas. ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Zato, phenav tuće: ‘Voj sikadas but ljubav kaj si laće jartome e but e bezeha, a majcara ljubav sikadas okova savo si majcara svesno kaj si lešće jartome lešće bezeha.’” ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","A o Isus phendas e manušnjaće: “Jartome si tuće ćire bezeha.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","A okola save sas pale sinija počnisardine te mothon maškar pende: “Ko si akava kaj vi e bezeha jartol?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","A vo phendas e manušnjaće: “Zbog ćiro paćipe tu san spasime. Dža ando miro!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Pale godova o Isus džalas pe sa e bare thaj cikne gava, propovedilas thaj navestilas e Bahtali nevimata palo o carstvo e Devlesko. Pale leste džanas e dešuduj apostolurja ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","thaj varesave manušnja saven o Isus oslobodisardas katar e bilačhe duhurja thaj sastarda len katar e nasvalimata: e Marija andar e Magdala, andar savi trada efta demonurja, ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","e Jovana, romnji e Huzošći savo sas e Irodosko upravitelj, e Suzana, thaj but aver save pomožinas e Isusešće thaj e dešuduje apostolenđe pire lovenca thaj okoleja so sas len. ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Dok još ćidelas pe o but o them andar e razne gava, o Isus phendas lenđe akaja paramiči: ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Jek đes inkljisto o sejači te sejol. Dok sijolas, varesavo seme pelo po drom thaj o them uštada les a e čiriklja aviline thaj haline les. ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Aver seme pelo pe barutni a kana inkljisto odma šućilo kaj nas les dosta vlage. ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Varesavo seme pelo maškar e kangre thaj e kangre tasadine les sar barjonas zajedno lesa. ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","A varesavo napokon pelo pe lačhi phuv, niknosarda thaj bijanda šel drom majbut.” Kana phendas godova thaj čhuta muj: “Ašunen kana već si tumen kan!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","E učenikurja phučline e Isuse so značil godoja paramiči. ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","A vo phendas lenđe: “Tumenđe si dino te džanen e tajne e Devlešće carstvošće, a averenđe si dino samo ande paramiča, kaj ando Sveto lil ačhel ramome: ‘vi ako dićhen či primetin, vi ako čhon kan či haćaren.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","A akava si so značil e paramiči: O seme si sago o alav e Devlesko. ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Okova seme savo pelo po drom si sago e manuša save ašunen o alav, ali avel o beng thaj inđarel o alav e Devlesko andar lenđe ile te na paćan thaj te či spasin pe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","A varesave si sago o seme savo si posadime pe barutni phuv. Kana ašunen e Devlesko alav, odma prihvatin les e bahtasa, ali najlen koreno. Varesavi vrjama paćan, ali kana aven e kušnje von peren katar o paćipe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","A okova seme savo pelo ande kangre si sago e manuša save ašunen o alav, ali još pe lengo drom e trajošće brige tasaven len e barvalipeja thaj akale trajošće nasladenca thaj či anen lačho plodo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Okova seme savo pelo pe lačhi phuv si sago e manuša save ašunen o alav thaj inćaren les ando lačho thaj plemenito ilo thaj ustrain dok či anen plodo.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Khonikal kana del jag o stenko či čhol les talo čaro niti talo kreveto, nego čhon les po čirako, te dićhen o svetlo okola save den andre. ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Sa so si garado thaj ćerdo tajno avela sikado javno thaj inkljela po videlo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Len sama sar ašunen, kaj kas si dela pe lešće, a kas naj lela pe lestar vi okova so gindil kaj si les.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ko Isus aviline lešći dej thaj lešće phral, ali katar o but o them našti ćerdine lesa svato. ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","A vareko javisarda e Isusešće: “Ćiri dej thaj ćire phral ačhen avri thaj kamen te dićhen tu.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","O Isus phendas lenđe: “Mungri dej thaj mungre phral si okola save ašunen thaj izvršisaren o alav mungre Devlesko.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Jek đes o Isus phendas pire dešuduj učenikonenđe: “Hajde te nakhas pe koja rig e jezerošći.” O Isus thaj lešće učenikurja dine ando čamco thaj isplovisardine. ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Dok plovinas, e Isuse lija e lindri. Ande godova mukla pe e oluja po jezero. E lađica počnisarda te pherel pe e pajesa a von arakhline pe ande bari briga pale piro trajo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Aviline ko Isus, džungadine les thaj čhutine muj: “Učiteljina, učiteljina, tasadosa!” Vo džungadilo, thaj zapovedisarda e bavlajaće thaj e talasenđe thaj e talasurja smirosajle thaj nastanisarda tišina. ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","A o Isus phendas lenđe: “Kaj tumaro paćipe?” A von ande dar thaj ando čudo phučenas jek avres: “Ko si akava te zapovedil e paješće thaj e bavlajaće, a von te pokorin pe lešće?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Askal o Isus thaj lešće učenikurja otplovisardine pe obala ke gerasinsko krajo, savo si pe koja rig katar o Galilejako jezero. ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Dok o Isus inkljelas pe obala, avilo angle leste o manuš ande savo sas e bilačhe duhurja. Već dugo či inđarelas e drze pe peste, niti trajilas ando ćher nego trajilas ande limorja. ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Kana o manuš dikhla e Isuse, čhuda pes pe koča angle leste thaj ande sasto glaso čhuta muj: “So kames mandar, Isuse, majbare Devlešće čhaveja? Moliv tut na muči man!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","(Kaj o Isus zapovedisardas e bilačhe duhošće te inkljel andar godova manuš. Kaj već lungo vrjama o bilačho duho inćarelas les ande piri vlast, Čak vi kana phandenas les ande lancurja thaj ande okurja, o manuš trgolas e lancurja thaj o beng inđarelas les ande pustinja.) ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","O Isus pe godova phučla les: “Sar bučhos?” Vo phendas: “Legija”, kaj ande leste dine e but bilačhe demonurja. ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Thaj zamolisardine e Isuse te na naredil lenđe te džantar ando bezdan. ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","A okote ande gora sas bari gomila bale save čarjonas. Askal e demonurja zamolisardine e Isuse te mućel len te den ande bale. Thaj vo mukla len. ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Askal e bilačhe demonurja inkljistine andar o manuš thaj dine ande bale. Thaj e bale pojurisardine niz o brego ando jezero thaj tasadile. ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","A kana dikhline okola manuša kaj lenas sama pe bale so sas, našline thaj phendine pe gava thaj pe okoline thana so dikhline. ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","A o them inkljisto te dićhel so sas. Avile dži ko Isus thaj dikhline e manuše andar savo inkljistine e bilačhe demonurja sar bešel dži ke Isusešće pungre, furjardo ande drze thaj saste gođasa e dar askal dijas pe lende. ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","A okola kaj lenas sama pe bale phendine averenđe, sar o Isus oslobodisardas e manuše ande savo sas e demonurja. ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Askal e Isuse zamolisarda sa o them andar e gerasinsko krajo te džaltar lendar kaj lija len e bari dar. O Isus dija ando čamco thaj teljarda palpale ande Galileja. ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","A o manuš andar savo o Isus trada e bilačhe demonen, zamolisarda e Isuse te šaj ačhel lesa, ali o Isus phendas lešće: ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Bolde tut ćhere thaj phen sa so ćerda tuće o Del.” Thaj o manuš đelotar thaj razglasisarda pe sasto gav so ćerda lešće o Isus. ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","A kana o Isus bolda pe palpale pe koja rig e jezerošći, malada les o them kaj željno ažućarenas les. ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Thaj dik, avilo o manuš kasko alav sas Jair, savo sas jek katar e vođe ande sinagoga. Thaj pelo pe pire koča angle Isusešće pungre thaj zamolisarda les te del ande lesko ćher ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kaj sas po meripe lešći jedino čhej savja sas varekaj katar dešuduj brš. Dok o Isus džalas ande Jairesko ćher oko leste ćićidelas pe sa o them katar sa e riga. ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","A maškar o them sas jek manušnji savi sas nasvali katar o godova kaj dešuduj brš thavdelas o rat latar. Sa so sasla dija pe doktorja thaj khonik našti te sastarelas lat. ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nakhli palal leste thaj astarda pe e ćoškostar katar e Isusešći haljina, thaj o rat odma ačhilo latar. ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","A o Isus phendas: “Ko astarda pe pale mungri haljina?” Savora počnisardine te branin pe, a o Petar phendas: “Učiteljina, o but o them ćićidel tut thaj spidel pe, a tu phučes ko astarda pe pale mande.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","A o Isus phendas: “Vareko astarda pe pale mande. Haćardem sar e sila inkljisti andar mande thaj vareko sastilo.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kana e manušnji dikhla kaj či ačhili neprimetno, izdralas e daratar thaj peli pe koča angle leste thaj angle sasto them phendas sostar astarda pe pale leste thaj sar odma sastili. ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","A vo phendas laće: “Čhejo, ćiro paćipe sastarda tut. Dža ando miro!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Dok o Isus još ćerelas svato e manušnjasa, avilo vareko andar e Jairesko ćher ko Jair savo sas vođa ande sinagoga thaj phendas: “Ćiri čhej muli. Na mučisar majbut e učitelje.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ašunda godova o Isus thaj phendas: “Na dara! Samo paća thaj voj trajila!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Kana o Isus areslo ando ćher, či mukla khonikašće te den andre lesa osim o Petre, o Jovane, o Jakov thaj e čhorako dade thaj laće deja. ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","A savora save sas ando ćher rovenas thaj žalinas pale čhori. A o Isus phendas lenđe: “Na roven! Či muli, nego samo sovel!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","A von asanas lestar kaj džangline kaj muli. ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","O Isus astarda lat palo vas thaj čhuta muj: “Čhorije, ušti!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Thaj lako duho bolda pe ande late thaj voj odma uštili, a vo naredisarda te denla te hal. ");
INSERT INTO rmyChergash_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","A lako dad thaj laći dej čudisajle, a vo zapovedisarda lenđe te na phenen khonikašće so sas. ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","O Isus akhardas e dešuduj apostolen thaj dija len moć thaj vlast pe sa e bilačhe duhurja thaj te sastaren katar e nasvalimata. ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Bičhalda len te navestin e Devlesko carstvo thaj te sastaren e nasvalen. ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Thaj phendas lenđe: “Na len tumenca po drom ni rovlji, ni trasta ni so hana, ni love thaj na te avel tumen tumenca po duj haljine! ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kana den ande varesosko gav, ačhen ande jek ćher dok či džan ande aver gav. ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ande savo gav či primin tumen, inkljen andar godova gav thaj ćhinon o praho katar tumare pungre. Godova avela znako kaj mukline les lešće sudošće.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Thaj e učenikurja teljardine majdur: obilazinas e gava, navestinas e Bahtali nevimata thaj sastarenas e nasvalen. ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Kana ašunda o vladiri o Irod so dogodisajlo, sas zbunime, kaj varesave phenenas kaj o Jovano savo bolelas uštilo andar e mule. ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Aver phenenas pojavisajlo pe phuv o Ilija, a aver palem phendine: “Uštilo andar e mule varesavo proroko andar e purani vrjama.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","A o Irod phendas: “Me čhindem e Jovanesko šoro. Ko si askal akava pale kaste gaći ašunav?” Thaj rodelas prilika te dićhel e Isuse. ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Kana e apostolurja boldine pe katar e okolne krajurja, phendine e Isusešće sa so ćerdine. Askal o Isus inđarda len pesa te avel lenca korkoro, paše pašo gav savo akhardol Vitsaida. ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ali kana godova ašunda o them, teljarda pale leste. Vo primisarda len thaj phenelas lenđe pale Devlesko carstvo thaj sastardas savoren ko trubuja sastipe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Kana avilo majpaše o krajo e đesesko kasno mismere avile ko Isus majpaše e dešuduj učenikurja thaj phendine e Isusešće: “Akava si pusto krajo, a već si kasno. Muk e theme te džal pe okolne gava thaj e thana te ćinen pešće vareso te han! kaj sam akate ando samotno krajo?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","A o Isus phendas lenđe: “Tumen den len te han!” A von phendine, “Naj amen majbut katar pandž mangre thaj duj mačhe, osim te džas te ćinas hamasko pale sa o them.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","A sas varekaj katar pandž milje muškarcurja (či đinavenas pe e manušnja thaj e čhavra). O Isus phendas pire učenikonenđe: “Phenen lenđe te bešen ande skupine po pandžvardeš džene.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Thaj savora bešline. ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","A o Isus lijas e pandž mangre thaj e duj mačhe, dikhla prema o nebo thaj blagoslovisarda len. Askal phagla o mangro pa dija pire učenikonenđe te podelin e themešće. ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Savora haline thaj čaljile. Thaj katar okova so ačhilo e themešće ćidine dešuduj pherde korpe kotora mangre thaj mačhe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Jekhvar dok o Isus crda pe po korkoro than te molil pe, lesa sas samo lešće dešuduj učenikurja. Pale godova phučla len: “So phenel o them, ko sem me?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Von phendine: “Varesave phenen kaj san o Jovano savo bolelas, aver kaj san o proroko Ilija, a trite palem kaj uštilo andar e mule varesavo katar aver purane prorokurja.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","A vo phučla len: “A tumen, so tumen phenen, ko sem me?” A o Petar phendas: “Hristo Pomazaniko e Devlesko!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","A o Isus zapovedisardas lenđe te na phenen khonikašće kaj si vo o Mesija. ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Thaj phendas: “Me, o Čhavo e Manušesko, trubul but te trpiv. E starešine, e šorvale rašaja thaj e učitelja e Mojsiješće zakonestar odbacina man. Mudarena man, a me o trito đes uštava andar e mule.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Pale godova o Isus phendas savorenđe: “Ako vareko kamel te avel mungro sledbeniko, neka odreknil pe korkoro pestar, nek svako đes lel piro trušul thaj nek džal pale mande. ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kaj svako ko kamel te spasil piro trajo, hasarela les; a ko hasarel piro trajo zbog mande, godova spasila les. ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Savi korist si e manušes, ako zadobil sa o them, a korkoro pes hasarel ili pešće naudil?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ko ladžal mandar thaj mungre alavendar, lestar vi me, o Čhavo e Manušesko, ladžava kana avava ande slava mungri thaj e slava mungre Dadešći thaj e svete anđelenđi. ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","“Čače phenav tumenđe: ‘Varesave save si akate tumendar či merena dok či dićhena e Devlesko carstvo.’” ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","A kana nakhla varekaj katar ohto đes katar godola alava o Isus lijas pesa e Petre, e Jovano thaj e Jakove ande gora te molin pe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Dok molilas pe, lesko muj promenisajlo, a e drze pe leste postanisardine parne thaj sjajne. ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ande godova pojavisajle duj manuša thaj ćerenas svato e Isuseja. Sas godova o Mojsija thaj o Ilija. ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Pojavisajle ande slava thaj ćerenas lesa svato pale lesko smrto savo trubuja te podnesil ando Jerusalim te pherdol o Lil. ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","E Petre thaj lešće drugaren lija e lindri. Kana džungadile, dikhline lešći slava thaj duj manušen save ačhenas lesa. ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Thaj dok godola duj džene džanastar lestar, o Petar phendas e Isusešće: “Učiteljina, lačhe kaj sam kate. Te ćeras trin senice: jek pale tute, jek palo Mojsije thaj jek palo Ilija.” Či džanelas so phenel. ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Dok vo još ćerelas svato, pojavisajlo o oblako thaj zasinisarda len. Kana o oblako učharda len, lija len e bari dar. ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Askal andar o oblako ašundilo o glaso savo phendas: “Akava si mungro Čhavo saves odabirisardem! Leste čhon kan.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Baš kana ašundilo o glaso, o Isus ačhilo korkoro. E učenikurja ačhenas thaj askal još khonikašće khanči či phendine pale okova so dikhline. ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","A kana thejara o đes o Isus thaj lešće učenikurja fuljistine katar e gora, avilo angle leste o but o them. ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Askal varesosko manuš savo sas maškar o them čhuta muj: “Učiteljina, moliv tut dik mungre čhave, kaj si manđe jedinco. ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Inćarel les o bilačho duho. Andar jekhvar počnil te čhol muj; čhudel pes thaj e spuma del lešće po muj. Gata nikada či mućel les thaj uništil les. ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Molisardem ćire učenikonen te traden e bilačhe duho andar leste avri ali von našti tradine les.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","A o Isus phendas lenđe: “O bilačhe thaj bi paćako manušalen! Kozom semasa tumenca, a tumen či paćan. Phuča man kozom još trpiva tumen! An akaring ćire čhave!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Dok o čhavro avelas paše, o bilačho duho harada les pe phuv thaj ćhinosarda les. A o Isus zapretisardas e bilačhe duhošće thaj odma sastarda e čhave thaj dijale lešće dadešće. ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Savora divisajle okolešće so o Isus ćerda. Thaj dok savora čudinas pe okolešće so ćerelas o Isus, o Isus phendas pire učenikonenđe: ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Lačhe zapamtin so phenav tumenđe: Me, o Čhavo e Manušesko, avava dino ande vas e manušenđe.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ali e učenikurja či haćardine so motholas, kaj nas lenđe dino te haćaren, o značenje sas lendar garado, a daranas te phučen les te objasnil lenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","E učenikurja počnisardine te raspravin pe ko maškar lende šaj avilosas majbaro. ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","O Isus džangla so si ande lenđe ile thaj lija e cikne čhavre, čhuta les paše peste ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","thaj phendas lenđe: “Ko god primil akale cikne čhavre zbog mande, man primil. A ko man primil, primil e Devles savo bičhalda man. O Del smatril kaj si majvažno okova savo si majponizno maškar tumende!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Askal o Jovano phendas e Isusešće: “Učiteljina, dikhlam jećhe manuše sar ande ćiro alav tradel e bilačhe duhonen. Amen phendam lešće te na ćerel godova, kaj či džal pale tute.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","A o Isus phendas lešće: “Na branin lešće! Kaj ko naj protiv tumende, pale tumende si!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kana avili majpaše e vrjama te o Isus boldel pe ando nebo, vo zurale odlučisarda te džan ando Jerusalim. ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Thaj bičhalda e glasnikonen angle peste. Von đele thaj dine ande varesosko samarijsko gav te pripremin lešće than kaj raćarela. ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","No okote o them či kamlas te primin les kaj sas po drom palo Jerusalim. ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kana godova dikhline lešće učenikurja o Jakov thaj o Jovano, phučline les: “Gospode! Kames te amen phenas te fuljel o oganj andar o nebo thaj uništil len?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","A o Isus bolda pe lende thaj phendas lenđe kaj či gndin lačhe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Thaj đeletar ande aver gav. ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Dok džanas dromesa, varesosko manuš phendas e Isusešće: “Džava pale tute kaj god tu te džas.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","A o Isus phendas lešće: “E lisicen si lenđe jazbine, thaj e čirikljen lenđe gnezdurja, a man e Čhave e Manušešće naj kaj mungro šoro te čhav.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Varesave avrešće phendas o Isus: “Teljar pale mande!” A vo phendas lešće: “Gospode, muk man majsigo te džav te prahov mungre dade.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","O Isus phendas lešće: “Muk e mulen te prahon pire mulen, a tu dža thaj navestisar e Devlesko carstvo.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Još vareko phendas: “Me džava pale tute Gospode, ali muk man te džav prvo te jartoman katar mungri familija.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","A o Isus phendas lešće: “Ni jek savo lel o plugo ande pire vas te oril thaj askal dićhel palpale, naj dostojno pale Devlesko carstvo.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Pale godova o Gospod odredisarda aver eftavardeš thaj duj učenikonen thaj bičhalda len po dujen angle peste ande svako gav thaj ande svako than kaj kamlas te džal. ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Majsigo so bičhalda len phendas lenđe: “E žetva si bari, a radnikurja si cara. Molisaren e Gospodare katar e žetva te bičhalel e radnikonen ande piri žetva. ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Džan! Ake, bičhalav tumen sago e bakhroren maškar e ruva. ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Na inđaren tumenca ni love, ni trasta, ni so pođina. Dromesa na te hasaren tumari vrjama gajda kaj pozdravina e theme thaj ćerena svato lenca. ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ande savo god ćher den, prvo phenen: ‘Miro akale ćherešće!’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Te avilo okote vareko dostojno palo tumaro miro, tumaro miro ačhela pe leste. A ako naj khonik dostojno tumaro miro boldela pe tumende. ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kana aven ande varesosko ćher, na naćhen andar o ćher ande aver ćher, ačhen pe jek than han thaj pijen sa so inkalen angle tumende. Kaj o radniko zaslužil piri poćin.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Kana den ande savo gav thaj primin tumen, han so ponudin tumen. ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Sastaren e nasvalen save si ande godova gav thaj phenen lenđe: Akaleja pašilo tumenđe e Devlesko carstvo! ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","A kana den ande varesavo gav thaj či primin tumen, inkljen pe lešće sokača thaj phenen: ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Čak vi o praho andar tumaro gav, savo astarda pe pale amare pungre, khosas amendar sago o znako kaj o Del sudila tumenđe. Ali kava džanen: Pašilo tumenđe e Devlesko carstvo! ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Phenav tumenđe: Ando đes e sudosko majloće avela e themešće andar e Sodoma nego e themešće andar akava gav. ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Teško tumenđe manušalen andar o gav Horazin! Teško tumenđe manušalen andar o gav Vitsaida! Kaj te e čudurja save dogodisajle tumende dogodisajle sas ando rumome gava o Tiro thaj o Sidon, e manuša andar godola gava već dumut obratisajlesas thaj bešline sas ande hrapavo thaj neudobne drze ando praho sago znako palo pokajanje. ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ali e manušenđe andar o gav Tiro thaj andar o Sidon po sudo avela majloće nego tumenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Vi tumen manušalen andar o Kafarnaum! Zar dži ko nebo avena vazdine? Dži ko than kaj si e mule haradona kaj si o tunjariko thaj e jag. ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Pale godova phendas e učenikonenđe: “Ko tumende čhol kan, mande čhol kan. Ko tumen odbacil man odbacil, a ko man odbacil, odbacil okoles savo bičhalda man.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Kana e eftavardeš thaj duj učenikurja boldine pes bahtale phendine: “Gospode, čak vi e bilačhe duhurja pokorin pe angle amende ande ćiro alav!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","A o Isus phendas lenđe: “Dikhlem e benđenđe poglavica sar perel sar e munja andar o nebo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ake dijem tumen vlast te uštaven pe sapa thaj pe škorpijonurja thaj pe sa e sila e dušmaješći thaj khanči či naškodila tumenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ali na raduin tumen kaj e bilačhe duhurja pokorin pe tumenđe, Ali raduin tumen zbog godova kaj si tumare alava ramome ande Devlesko svitak ando nebo.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ande godova časo o Isus pherdo bah ando Sveto Duho phendas: “Slaviv tut, Dade, tut savo san Gospodari e nebesko thaj e phuvjako, kaj garadan ćiro čačipe katar okola save smatrin pes mudre thaj umne, a objavisardan e ciknenđe. Ej Dade! Gajda tuće sviđosajlo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Mungro Dad sa dija man thaj khonik či džanel ko si o Čhavo, nego samo o Dad; niti ko si o Dad osim o Čhavo thaj okova kašće o Čhavo godova kamel te objavil.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Askal bolda pe ke učenikurja kana sas korkoro lenca thaj phendas lenđe: “Blago e manušenđe save dićhen okova so tumare jakha dićhen! ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Phenav tumenđe: But prorokurja thaj e carurja kamline te dićhen man thaj te ašunen man, ali či dikhline man thaj či ašundine man!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Jekhvar uštilo jek učitelj e Mojsiješće zakonestar te probil e Isuse thaj phučlas: “Učiteljina, so trubul te ćerav te dobiv večno trajo?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","A vo phendas lešće: “So ramol ando Mojsijesko zakono? So okote čitosardan?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Askal o manuš phendas “Čumide e Gospode Devle ćire saste ileja, ćire saste dušava, ćire saste snagasa ćire saste gođasa, thaj volisar ćire pašutne sago kaj volis korkoro tut!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Pe godova phendas lešće o Isus: “Lačhe phendan. Godova ćer thaj avela tut večno trajo.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ali vo lija te sikavel pes pravedno, thaj phučla e Isuse: “A ko si mungro pašutno?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","A o Isus phendas: “Varesosko manuš fuljelas andar o Jerusalim ando gav savo akhardolas Jerihon. Thaj astardine les e razbojnikurja. Von čhudine lestar e drze, mardine les thaj đeletar. O manuš ačhilo te pašljol opaš mulo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Slučajno godole dromesa naćhelas varesosko židovsko rašaj, dikhla les thaj nakhlo gajda kaj zaobiđisarda les. ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","A gajda vi o levito e rašajesko pomoćniko: nakhlo okotar, dikhla les thaj nakhlo paše leste. ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Varesosko putniko Samarijanco areslo dži leste, dikhla les, thaj sažalisajlo pe leste. ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Avilo dži leste thaj thoda e rane lešće e uljesa thaj e molasa thaj paćarda len. Thaj čhuta les pe piro magarco, inđardale ande gostijonica thaj pobrinisajlo pale leste. ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Thejara o đes inkalda duj rupune lovora, dija len e gostijoničarešće thaj phendas: ‘Le sama pe leste. Ako so majbut potrošil, poćinava tuće kana boldava man.’” ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Askal o Isus phučla les: “So phenes, savo katar akala ponašisajlo sago pašutno prema okova saves astardine e razbojnikurja?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","A vo phendas: “Okova savo pomognisarda lešće.” Pe godova o Isus phendas lešće: “Dža thaj vi tu ćer gajda!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Dok o Isus thaj lešće učenikurja gajda putuinas majdur prema o Jerusalim, dine ande varesosko gav. Okote sas varesavi manušnji savi akhardolas Marta, primisarda len ande piro ćher. ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","A sas lat phen savi akhardolas Marija. Voj bešelas dži ke Gospodešće pungre thaj ašunelas o alav lesko. ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","A e Marta sas but zauzmime godolesa kaj poslužilas. Voj avili leste thaj phendas: “Gospode! Zar či maris kaj mungri phen mukla man korkoro te posluživ? Phen laće te pomožil man.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","A o Gospod phendas laće: “Marta, Marta! Na ha holji thaj uznemiri tut pale but godova, ");
INSERT INTO rmyChergash_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","a samo jek si važno. E Marija godova svatisardas thaj godova či lava latar.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jekhvar kana o Isus završisarda e molitvava, avilo dži leste jek katar e učenikurja thaj phendas lešće: “Gospode, sikav men te moli men sago kaj o Jovano savo bolelas sikada pire učenikonen.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","O Isus phendas lenđe: “Kana molin tumen, phenen: ‘Dade amareja ando nebo! Neka avel sveto ćiro alav! Neka avel ćiro carstvo! ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Mangro amaro de amen svako đes! ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Thaj jarto amenđe amare e bezeha, sago kaj amen jartosaras svakonešće ko sagrešil protiv amende thaj na de te peras ande kušnja!’” ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Askal o Isus phendas lenđe: “Zamislin te džan ke tumaro drugari ande opaš e rjat thaj phenen lešće: ‘Drugarina, deman udžile trin mangre. ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Kaj avilo mungro drugari katar o drom, a naj man so te čhav angle leste te hal!’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","A okova andral phenel lešće: ‘Na dosadisar manđe! O vudar si već phandado, a e čhavrora si manca ando kreveto thaj soven. Našti uštav te dav tut.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Phenav tumenđe: Ako či ni uštel te de les kaj si lesko drugari, uštela te del les zbog godova kaj lešće drugare naj ladžavo te avel uporno. ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Isto gajda phenav tumenđe: Manđen thaj dela pe tumenđe! Roden thaj araćhena! Maren po vudar thaj putrela pe tumenđe! ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kaj ko god manđel, primil. Ko rodel, araćhel. Ko marel po vudar, putrel pe lešće. ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Savo dad maškar tumende kana o čhavro lesko manđel lestar mačho, del les umesto mačho sap? ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ili kana manđel angro, zar dela les škorpijono? ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ako tumen, vi ako sen bilačhe, džanen te den lačhe darurja tumare čhavrenđe, kozom majbut tumaro nebesko Dad dela Sveto Duho okolen save manđen lestar!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jekhvar o Isus trada e bilačhe duho andar o manuš savo sas nemo. Kana inkljisto o bilačho duho, o nemo manuš počnisarda te ćerel svato. Thaj o but o them divisajlo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","A varesave lendar phendine: “Vo tradel e bilačhe duhonen e Veelzevulešće silava, savo si e benđengo knezo.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","A aver iskušisardine e Isuse gajda kaj rodenas lestar varesosko znako andar o nebo kaj o Del bičhalda les. ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ali o Isus džangla lenđe gindimata thaj phendas lenđe: “Ako e manuša andar isto carstvo borin pes maškar peste von uniština piro carstvo. Vi ako e familijaće članurja borin pes maškar pende, uniština piri familija. ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ako si o beng ande peste podelime, sar ačhela lesko carstvo? A tumen phenen kaj me e Veelzevulešće silava tradav e bilačhe duhonen andar e manuša. ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ako me e Veelzevulešće silava tradav e bilačhe duhonen andar e manuša, kašće silava askal tumare učenikurja traden len? Gajda von korkoro dokažina kaj naj sen ando pravo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ali ako me e Devlešće silava tradav e bilačhe duhonen, čače avilo tumende o carstvo e Devlesko.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","O Isus još phendas: “Dži kaj god o zuralo manuš, lačhe naoružime, araćhel piro ćher, lesko barvalipe si sigurno. ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ali te avel o majzuralo lestar, svladila les thaj otmil lešće sa lesko oružje ande savo uzdilaspe, a o pleno razdelila.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Zato ko naj manca protiv mande si. Thaj ko manca či ćidel, rspil. ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Askal o Isus phendas: “Kana o bilačho duho inkljel andar o manuš, lutil pe puste thana thaj rodel pešće than kaj šaj te odmoril pes. A kana či araćhel o than, phenel: ‘Boldava man ande mungro ćher, ando manuš andar savo inkljistem.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Thaj kana areslo o bilačho duho arakhlas e manuše savo si sago o čučo ćher, šilado thaj lačhardo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Askal džal thaj lel pesa efta aver duhurja, majgore lestar thaj del andre thaj okote nastanil pe. Po krajo godole manušešće avela majgore nego kaj sas lešće po početko.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Dok o Isus godova phenelas, varesošći manušnji kaj sas maškar o but o them čhuta muj: “Blagoslovime o đi ćire dejako savo inđarda tu thaj e čuča save pilan!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","O Isus phendas: “Još majblagoslovime si okova savo ašunel o alav e Devlesko thaj ačhel paćivalo!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","A vo phendas laće: “Tumen manušalen save trajin ande akaja vrjama sen bilačhe manuša. Tumen roden znako. Ali aver znako či dela pe tumenđe osim e čudurja save o Del ćerda palo Jona. ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kaj okova so sas e Jonasa sas znako e manušenđe save trajinas ando gav savo akhardolas Niniva, ande savo o Del bičhalda les. Gajda okova so manca dogodila pe avela znako kaj man, e Čhave e Manušešće, o Del bičhaldas akale themešće. ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Po đes kana avela e Devlesko sudo, e carica savi dumut vladilas e južno phujava, savi akhardolas Saba, uštela thaj osudila e manušen save si ađes džude. Kaj dadural avili te ašunel e care Solomone savo sas zurale mudro, a akate si vareko majbaro vi katar o Solomon, a tumen či kamen te čhon kan leste! ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","E manuša save majsigo trajinas ando gav savo akhardolas Niniva, uštena po đes kana avela e Devlesko sudo thaj osudina e manušen save akana trajin. Kaj von pokajisajle kana o Jona propovedilas, a ake, akate si vareko majbaro katar o Jona, a tumen još či pokajisajle!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","O Isus majdur sikavelas: “Khonik či del jag o stenko te čhol les po garado than, niti tale korpa, nego po čirako te okola kaj den andre dićhen o svetlo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ćiri jak si stenko ćire telošće. Kana si ćiri jak sasti, sasto ćiro telo si ando svetlost. Ali, ako si ćiri jak nasvali, ćiro telo si ande tama. ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Zato le sama te okova so gndis kaj si ande tute svetlost naj li tama. ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ako si sasto ćiro telo osvetlime thaj ni cara tama naj ande tute, askal sasto aveja prosvetlime, sago kana o stenko pire svetlosa osvetlil tut.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Kana o Isus dija gata o svato, avilo leste varesavo fariseji thaj akharda les ande piro ćher te hal. Vo dija andre thaj lijas than pale sinija. ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Kana godova dikhla o farisej, začudisajlo kaj o Isus bešlo pale sinija majsigo nego so thoda pire vas sago kaj trubujas prema e židovengo običaj. ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","A o Gospod phendas lešće: “Tumen e fariseja gadići trudin tumen te thoven tumaro tahtaj thaj o čaro avrjal, a andral sen pherde pohlepe thaj e bilačhipe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Bi gođavalen! Naj li o Del okova kaj stvorisarda e manušes thaj pindžarel les andral sago vi avrjal? ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Zato den okova so si andral andar e tahta thaj andar e čare so handžvale inćaren samo pale tumende, okolenđe savenđe si majpotrebno sago milostinja thaj saste avena čiste andral thaj vi avrjal. ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ali teško tumenđe, farisejalen! Kaj den deš posto katar sa e začinurja thaj katar o povrće, a či marin pale pravda e manušenđi thaj pale ljubav e Devlešći so si majvažno. Trubun te den deš posto, ali či troman te zanemarin majvažne stvarja andar o zakono. ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Jao tumenđe farisejalen! Kaj volin te bešen pe prve thana ande sinagoge thaj te e manuša pozdravin tumen pe javne thana. ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Teško tumenđe farisejalen kaj sen sago e limorja, save naj obeležime, pe save e manuša phirena, a či džanen kaj si okote o limori thaj postanin duhovno melale!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Askal varesosko katar e učitelja e Mojsiješće zakonestar phendas e Isusešće: “Učiteljina, dok gajda phenes, vi amen vređos.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","A o Isus phendas: “Jao vi tumenđe, učiteljurja e Mojsiješće zakonestar! Kaj čhon pe manuša o pharipe gajda kaj den len pravilo save našti te inđaren, a tumen korkoro ni e najesa či mrdnon te pomognin lenđe te inđaren godova pharipe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Teško tumenđe, kaj vazden e prorokonenđe spomenikurja, a tumare pradada mudardine len. ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Godolesa kaj či trajin so e prorokurja sikavenas svedočin kaj odobrin okova so ćerdine tumare pradada: von mudardine len, a tumen spomenikurja vazden lenđe! ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Zato vi o Del mudro phendas: ‘Bičhalava lende e prorokonen thaj e apostolen. Varesaven lendar mudarena, a varesaven progonina.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Zato tumaro naraštaj smatrila pe došalo palo rat kaj sas čhordo e prorokonengo katar o postanko e themesko, ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","katar o rat e prvo prorokosko dži ko rat e poslednjo prorokosko, e Aveljesko dži ko rat e Zaharijasko, savo sas mudardo maškar o žrtveniko thaj o svetište. Ej phenav tumenđe, kaj rodela pe o računo katar akaja generacija tumaro naraštaj avela odgovorno pale godova rat savo sas čhordo! ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Jao tumenđe, učiteljurja e Mojsiješće zakonestar! Kaj line e ćija katar o džanglipe pale Devlesko carstvo thaj garadine katar e manuša. Korkoro či den andre ando carstvo, a či mućen te den andre okola save kamen te den.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Kana o Isus inkljisto okotar, e učitelja e Mojsiješće zakonestar thaj e fariseja počnisardine zurale te holjavon pe leste thaj navalisardine pe leste te phučen les but vareso. ");
INSERT INTO rmyChergash_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Von dićhenas te astaren les ande varesavo pogrešno alav sar optužisardinesas les. ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Askal ćida pes majbut milje manuša, gajda kaj jek avrešće uštavenas e pungre. Ali o Isus prvo phendas pire učenikonenđe: “Len tumen sama kaj o farisejsko licemerje buljol sago o kvasco savo šukljarel sasto humer. ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kaj avel e vrjama kana sa so si garado avela arakhado thaj sa so si tajno ašundola angle savorende. ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Zato, sa so phendine ande tama ašundola po svetlo thaj sa so phendine varekašće po kan ande sobe, katar e krovurja propovedila pe.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","O Isus nastavisarda: “Phenav tumenđe mungre drugarenđe na daran katar okola save šaj te mudaren samo o telo, a pale godova našti ćeren tumenđe khanči. ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ali phenava tumenđe kastar trubun te daran: daran katar o Del savo, šaj lel o trajo thaj askal čhudel les ando pakao. Lestar daran! ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Pa či li bićinen pe pandž čiriklja pale samo duj lovora? Pa palem ni jećhe lendar o Del či bistrel. ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","A tumenđe si svako bal po šoro đinado. Zato na daran! Kaj sen e Devlešće majvredne nego but e čiriklja!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ko akate pe phuv anglo them priznail kaj pripadil manđe, pale leste me o Čhavo e Manušesko phenava, angle anđelurja e Devlešće kaj pripadil manđe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ali okova savo odreknil pe mandar angle manuša akate pe phuv, gajda vi me odrekniva man lestar angle anđelurja e Devlešće. ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ali phenav tumenđe ko mothol vareso protiv o Čhavo e Manušesko, jartola pe lešće. Ali okolešće ko hulil po Sveto Duho, či jartola pe lešće. ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","A kana anena tumen po sudo thaj ande sinagoge, angle poglavarja thaj angle vlast, na vodin briga so phenena te branin tumen! ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kaj o Sveto Duho ande godova časo sikavela tumen so te phenen.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Vareko maškar o them phendas lešće: “Učiteljina, phen mungre phralešće te podelil manca so mukla amenđe amaro dad.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Pe godova o Isus phendas lešće: “Manušeja, ko čhuta man te avav tumaro sudco ili deliv maškar tumende?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Askal phendas savorenđe: “Len tumen majdur katar svako pohlepa, kaj o čačo trajo či avel katar okova so si tumen.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Askal o Isus phendas lenđe akaja usporedba: “Varesave barvale manušešće e phuv but bijanda ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","thaj ačhilo te gindil ande peste: ‘So te ćerav? Kaj naj man kaj te čhav sa akava so bijanda manđe e phuv.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Thaj phendas: ‘Ake so ćerava! Haravava mungre žitnice thaj vazdava majbare thaj okote čhava sa mungro điv thaj mungro lačhipe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Askal phenava korkoro manđe ake situ ande zalihe but lačhipe pale but e brš kaj aven. Dušo mungrije, akana odmori tut, ha, pi thaj veselitu!’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ali o Del phendas lešće: ‘Bigođavereja! Već arjat mereja! A sa so ćidan, kasko avela?’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Gajda avela okoleja kaj ćidel pešće barvalipe, a či ćidel o barvalipe savo si vredno ande Devlešće jakha.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Askal o Isus phendas pire učenikonenđe: “Zato phenav tumenđe, na daran pale tumaro trajo so hana, ni palo telo so lena pe tumende. ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kaj o trajo si majvredno katar o habe, a o telo katar e drze. ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Dićhen pe gavranurja! Niti sadin niti ćiden, najlen spremište ni žitnice, thaj tumaro Dad nebesko pravarel len. Kozom sen tumen majvredne nego e čiriklja! ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","A ko tumendar šaj e brigenca te lunđarel piro trajo samo pale jek đes? ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Dakle, ako tumen našti ćeren ni okova so si majcara, sostar askal stalno han holji pale sa aver? ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Lačhe dićhen e divlje luluđa sar barjon! Či trudin pe niti suven pešće drze. A phenav tumenđe kaj ni o caro Solomon ande sa piro barvalipe či inđarelas pe peste gajda šukar drze sago akala divlje luluđa. ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ako o Del gajda šukar furjarel e poljsko čar, savi ađes si, a već thejara čhudel pe ando bov te phabon, kozom majbut šukar furjarela tumen. Tumen cara paćivalen! ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Zato vi tumen na samo gndisaren pe godova dali si tumen dosta te han thaj te pijen. Na uznemirin tumen zbog godova! ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Sa godova roden e manuša save či pindžaren e Devles. Tumaro nebesko Dad džanel kaj sa godova trubul tumen. ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nego roden e Devlesko carstvo, a sa godova nadodaila pe tumenđe! ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Na dara mungro cikno stado! Kaj si e volja tumare Dadešći te del tumen o Carstvo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Bićinen okova so si tumen thaj e love den e čorenđe! Gajda ćidena tumenđe trjaste save či phurjon thaj barvalipe savo či propadnila, večno blago savo si ando nebo kaj o čor či avel thaj kaj o moljco či hala les. ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Zato, kaj si ćiro barvalipe, okote avela vi ćiro ilo.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","O Isus phendas lenđe vi akava: “Aven spremne te služin thaj tumare stenkurja neka phabon. ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Aven sago okola kaj ažućaren pire gospodare kana boldel pe andar e svaturja te odma putren lešće čim aresel thaj marel po vudar, ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Blago okole slugonenđe saven o gospodari, kana avela, araćhel džungade! Čače phenav tumenđe, kaj korkoro o gospodari čhola len pale sinija te bešen thaj čhola pe peste o keceljko, te poslužil len. ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","O gospodari šaj te boldel pe ande opaš e rjat ili ande zora a blago e slugenđe saven o gospodari araćhela kaj si još džungade thaj ažućaren les. ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ali akava džanen: te o domaćino džanglasas ande savo časo avela o čor, či muklasas te o čor provalil ande lesko ćher. ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Vi tumen aven spremne, kaj me, o Čhavo e Manušesko, avava ando časo kana či očekuina man.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pe godova o Petar phendas: “Gospode, phenes li godoja usporedba samo pale amende ili vi pale savorende?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","A o Gospod Isus phendas: “Ko si okova verno thaj razumno upravniko saves o gospodari čhola te vladil pe lešće sluge thaj te del len habe ande pravo vrjama? ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Blago godole slugašće saves lesko gospodari, kana avela, araćhel kaj ćerel gajda. ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Čače, phenav tumenđe, o gospodari čhola godole slugone te upravljil lešće saste barvalipeja. ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ali ako godova sluga phenel ande piro ilo: ‘Mungro gospodari či avela gajda sigo’ thaj ačhel te marel e slugonen thaj e sluškinjen, te hal, te pijel thaj te matol, ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","avela lesko gospodari ande godova đes kana vo či očekuil thaj ando časo kana vo či ni džanel, thaj strogo kaznila les thaj odredila lesko than maškar okola save či paćan, ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","O sluga savo pindžarel e volja pire gospodarešći, a khanči či ćerda te pripremil pe pale vrjama kana boldela pe lesko gospodari, avela strogo kaznime. ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","A okova sluga kaj či džanglas e gospodarešći volja, a ćerda vareso so zaslužil kazna, cara avela mardo. A katar okola kašće but dijas lendar majbut vi rodela. Okolestar kašće si but poverime lestar but vi rodela pe.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Askal o Isus phendas: “Me avilem te čhudav jag e sudošći pe phuv! Sar volisardemas te već počnisarda te phabol! ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ali majsigo trubul te pretrpiv e muke thaj o smrto, zurale si manđe pharo dok godova či avel gata! ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Gndisaren kaj me avilem te anav miro pe phuv maškar o them? Nisar. Avilem te anav razdor. ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kaj katar akana e familija rspila pe: trin džene avena pe mungri rig, a aver duj protiv ili duj pe mungri rig, a trin protiv mande. ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Boldela pe o dad protiv o čhavo, thaj o čhavo protiv o dad, e dej protiv e čhej, thaj e čhej protiv e dej, e sokra protiv e bori thaj e bori protiv e sokra.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","A e bute themešće o Isus phendas: “Kana dićhen kaj o kalo oblako avel katar o zapad, odma phenen: ‘Dela o bršnd!’ Thaj gajda si. ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kana dićhen kaj phurdel e balval katar e pustinja po jugo, phenen: ‘Avela tati vrjama’, thaj gajda avela. ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Licemerja! Džanen te prosudin o izgled e nebesko thaj e phuvjako. Sar askal či pindžaren mungre znakurja save trubuinesas te pindžaren! ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Tumen korkoro trubuinesas te pindžaren so si ispravno! ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Sago vi ako vareko prl tumen zbog o dugo savo či poćindine thaj kamel te inđarel tumen po sudo, još e dromesa den sa tumendar te e nagodbasa rešin tumen lestar, te či inkalel tumen anglo sudo. O sudco dela tumen ko stražari, a o stražari čhudela tumen ande tamnica. ");
INSERT INTO rmyChergash_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Phenav tuće: či inkljeja okotar dok či poćines sa so san udžile dži ko poslednjo lovoro.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Askal aviline varesave manuša thaj phendine e Isusešće kaj o Pilato savo sas rimsko upravniko dijas naredba te mudaren pe varesave manuša andar e Galileja. Thaj sas mudarde ando jerusalimsko Hramo dok anenas e žrtve. ");
INSERT INTO rmyChergash_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","O Isus phendas lenđe: “Dali si godova dokaz kaj godola Galilejcurja save nasradisardine sas majbut bezehale katar aver Galilejcurja? ");
INSERT INTO rmyChergash_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nisar! Phenav tumenđe: vi tumen gajda avena duhovno hasarde ako či obratin tumen ko Del! ");
INSERT INTO rmyChergash_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ili gndin kaj okola dešuohto, pe save haradili e Siloamsko kula thaj mudarda len sas majbut bezehale katar sa e manuša save trajinas ando Jerusalim? ");
INSERT INTO rmyChergash_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nisar! Phenav tumenđe: vi tumen gajda avena duhovno hasarde ako či obratin tumen ko Del.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Askal o Isus phendas lenđe akaja usporedba: “Varesave manuše sas zasadime smokva ande lesko vinograd. Avelas te rodel plodo pe late, ali či arakhla. ");
INSERT INTO rmyChergash_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Zato phendas e vinogradarešće: ‘Ake, već trin brš avav thaj rodav plodo pe akaja smokva thaj či arakhav les. Čhin lat. Sostar te crpil e phuv?’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","A o vinogradari phendas lešće: ‘Gospodarina, mukla još akava brš, a me hanavava oko late thaj čhava oko late o štalsko gunoj. ");
INSERT INTO rmyChergash_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Možda ipak pe okova brš bijanel. A ako či bijanel askal čhineja lat.’” ");
INSERT INTO rmyChergash_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jek savato dok o Isus sikavelas ande jek sinagoga. ");
INSERT INTO rmyChergash_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Okote sas varesavi manušnji savi dešuohto brš sas grbavo thaj našti uspravilaspe. Ande late sas o bilačho duho savo ćerelas te avel nasvali. ");
INSERT INTO rmyChergash_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Kana o Isus dikhla lat, akharda lat peste thaj phendas: “Manušnjije, oslobodime san katar ćiro nasvalipe!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Thaj čhuta pire vas pe late, a voj odma uspravisajli thaj počnisarda te slavil e Devle. ");
INSERT INTO rmyChergash_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","A okova savo sas vođa ande sinagoga holjajlo kaj o Isus sastardas ando savato, thaj phendas e themešće: “Šov si đes ando kurko kana trubul te ćerel pe bući! Ande godola đesa aven thaj saston, a na ande savatosko đes!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","O Gospod askal phendas lešće: “Licemerja! Vi tumen ćeren bući savatone. Zar či svako tumendar savatone odrešil pire guruve ili magarco katar e jasle thaj inđarel les po paj te napoil les? ");
INSERT INTO rmyChergash_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Naj li vi voj čhej andar e Avraamesko plemeno, savja o Sotona phangla već dešuohto brš, či li trubujasas vi lat o Del te odrešil katar godova nasvalipe savo si laće okurja ande savatosko đes?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Pe godova sa lešće protivnikurja ladžajle, a sa aver raduisajle e šukar delenđe save o Isus ćerda. ");
INSERT INTO rmyChergash_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Pale godova o Isus phendas: “Sova si slično e Devlesko carstvo? Sova te usporediv les? ");
INSERT INTO rmyChergash_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Slično si e gorušicaće zrnosa savo si zurale cikno, kana o manuš lel les thaj čhude les ande piri bar. Barjol thaj ćerdol ando kaš thaj e čiriklja ćiden pe thaj ćeren gnezdurja ande lešće ranja.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Thaj palem phučla len: “Sova te usporediv e Devlesko carstvo? ");
INSERT INTO rmyChergash_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Vo si sago o kvasco savo lel e manušnji thaj šukljarel les ando but aro, dok sa či vazdel pe.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Gajda o Isus naćhelas kroz e gava thaj kroz e varošice, sikavelas thaj putuilas ando Jerusalim. ");
INSERT INTO rmyChergash_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Askal vareko phendas lešće: “Gospode, dali si cara okola kaj spasin pe?” A o Isus phendas lenđe: ");
INSERT INTO rmyChergash_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“O vudar nebesko si usko. Trudin tumen te den andre kroz leste, kaj phenav tumenđe, but rodena te den kroz leste, ali našti dena. ");
INSERT INTO rmyChergash_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kana o gospodari e ćheresko zaključil o vudar avela prekasno. Askal ačhena avri marena po vudar thaj phenena: ‘Gospode, putar amenđe!’ Vo phenela tumenđe: ‘Či džanav ko sen, ni katar sen.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Askal počnina te phenen: ‘Pa amen tusa halam thaj pilam, a tu sikavejas pe amare sokača!’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","A vo phenela tumenđe: ‘Či džanav ko sen. Džantar mandar savora save nepravda ćeren!’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","okote avela o roipe thaj o škripipe e dandenca kaj avena gajda holjarike kana dićhena e Avraame, e Isako, e Jakove thaj sa e prorokonen ande Devlesko carstvo, a tumen avena čhudine avri. ");
INSERT INTO rmyChergash_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Askal avela o but o them katar o istok thaj katar o zapad, katar o severo thaj katar o jugo thaj bešena pale sinija ande Devlesko carstvo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Thaj dik, okola save si akana prve askal avena pe poslednjo than, a okolen save akate smatrin kaj si poslednje avena majbare.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ande godova časo aviline varesave fariseja thaj phendine e Isusešće: “Inklji thaj džatar akatar, kaj o caro Irod kamel te mudarel tut.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","A o Isus phendas lenđe: “Džan thaj phenen godole lisicaće: ‘Ake, tradav e bilačhe duhonen thaj sastarav ađes thaj thejara, thaj trito đes avava gata.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ali ađes, thejara thaj overthara moraš te nastaviv o drom, kaj valda e prorokurja našti aven mudarde avrjal o Jerusalim. ");
INSERT INTO rmyChergash_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jerusalime, Jerusalime, savo mudares e prorokonen thaj čhudes e bara dži ko smrto pe okola save si e Devlestar bičhalde tuće! Kozom drom lijem te ćidav ćire čhavren, sago e kvočka savi ćidel pire pujen tale pešće phaka, ali tumen či kamline! ");
INSERT INTO rmyChergash_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ake akana, tumaro ćher avela pusto! Thaj phenav tumenđe, či dićhena man dok či avel o časo kana phenena: ‘Blagoslovime o okova savo avel ando alav e Gospodesko!’ ” ");
INSERT INTO rmyChergash_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Jek savato avilo o Isus ando ćher ke jek vođa e farisejengo te hal lesa. Okola save sas okote lačhe lenas sama pe leste so ćerela. ");
INSERT INTO rmyChergash_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Kaj pojavisajlo anglo Isus varesavo manuš savo sas nasvalo gajda kaj sas les paj thaj šuljolas lestar. ");
INSERT INTO rmyChergash_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Pe godova o Isus phučla e učitelja e Mojsiješće zakonestar thaj e farisejen: “Dali si muklino prema e Mojsijesko zakono te savatone sastarel pe o manuš ili naj?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","A von khanči či phendine. Askal o Isus čhuta pire vas po nasvalo manuš, sastarda les thaj phendas lešće kaj šaj džaltar. ");
INSERT INTO rmyChergash_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","A o Isus phendas: “Ko tumendar savatone či ćerel bući? Ako varekašće tumendar o čhavro ili o guruv perel ande haing, zar či odma inkalena les?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Pe godova nas len so te phenen. ");
INSERT INTO rmyChergash_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Kana o Isus dikhla sar okola kaj si akharde pe gozba len pešće prve thana te bešen, phendas lenđe e usporedba: ");
INSERT INTO rmyChergash_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Kana vareko akharel tut pe svaturja, na beš po prvo than kaj so ako si akhardo vareko ko si majvažno tutar? ");
INSERT INTO rmyChergash_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Te či o domaćino savo akhardas tut thaj vi les phenela tuće: ‘Ušti thaj de o than okole manušešće.’ Askal ladžavoja, ušteja thaj bešeja po paluno than. ");
INSERT INTO rmyChergash_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Nego kana vareko akharel tut dža thaj beš pe paluno than, thaj kana avela okova kaj akharda tut, phenel tuće: ‘Drugarina pripremisardem tuće majlačho than!’ Askal aveja počastime angle sa save si akharde. ");
INSERT INTO rmyChergash_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kaj, svako ko korkoro pes uzvisil, avela ponizime, a ko korkoro pes ponizil, avela uzvisime.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","A askal o Isus bolda pes ko domaćino thaj phendas lešće: “Kana ćeres habe ili večera, na akhar ćire drugaren, ni ćire phralen, ni ćire familija, ni ćire barvale komšijen, te či vi von možda tut akhardinesas thaj pe akava način boldinesas tuće. ");
INSERT INTO rmyChergash_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nego kana ćeres gozba akhar e čoren, sakaten, banđen, thaj koren. ");
INSERT INTO rmyChergash_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Kaj len naj sova te bolden tuće. Gajda aveja blagoslovime kaj o Del pale godova nagradila tut kana vo vaskrsnila e pravedne manušen andar e mule.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Kana godova ašunda jek katar e manuša pale sinija, phendas e Isusešće: “Blago okolešće savo hala ande Devlesko carstvo!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","A o Isus phendas lešće: “Varesosko manuš ćerda bari večera thaj akhardas e but e themes. ");
INSERT INTO rmyChergash_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kana e večera sas gata, bičhaldas e sluga te phenel e gostonenđe: ‘Sa si gata. Aven!’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","A von jek pale avreste phendine kaj našti te aven. O prvo phendas lešće: ‘Ćindem njiva thaj trubul te džav te dikhav lat. Moliv tut, jartosar man ke godova manuš.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Aver phendas: ‘Ćindem deš guruva, thaj trubul te džav te isprobiv len dali si lačhe. Moliv tut, jartosar man ke godova manuš.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","O trito phendas: ‘Upravo ženisajlem thaj zato našti te avav.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","O sluga bolda pe thaj javisarda godova pire gospodarešće. Askal o gospodari holjajlo thaj phendas e slugašće: ‘Inklji brzo pe sokača e gavešće thaj an akaring e čoren, sakaten, koren thaj e banđen.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Kana o sluga gajda ćerda, javisardas e Gospodarešće: ‘Gospodarina, ćerdo si so phendan thaj još si than.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","O gospodari phendas e slugašće: ‘Inklji pe droma avrajl o gav thaj trade len te aven te pherdol mungro ćhere e themesa. ");
INSERT INTO rmyChergash_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kaj phenav tumenđe: Ni jek katar okola manuša save sas majsigo akharde či hana ni zalogaj katar e gozba savi ćerdem.’” ");
INSERT INTO rmyChergash_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","E Isuseja putuilas o silno them. O Isus bolda pe thaj phendas lenđe: ");
INSERT INTO rmyChergash_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ako vareko kamel te avel mungro učeniko, moraš te volil man majbut nego pire dade, deja, romnja, čhavren, phralen, phejen, pa majbut vi katar piro trajo. Inače našti avel mungro učeniko! ");
INSERT INTO rmyChergash_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ko či lel piro trušul thaj či džal pale mande thaj naj spremno te merel pale mande, našti avel mungro učeniko! ");
INSERT INTO rmyChergash_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Kaj khonik tumendar, kana kamel te sagradil e kula, či prvo bešel thaj proračunil e troškurja te dićhel dali si les sova te završil. ");
INSERT INTO rmyChergash_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Inače, šaj dogodisajlo sas lešće te uspil samo te čhol o temelji thaj najles dosta love te završil, a askal savora save godova dikhline sas mardinesas muj lestar ");
INSERT INTO rmyChergash_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","thaj phenena: ‘Akava manuš počnisarda te gradil, a našti završil!’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ili savo caro teljardasas ando rato aver caronenca, a te majsigo či bešel thaj gindil dali šaj pire deš milje vojnikonenca te svladil okoles savo avel pe leste pire biš milje vojnikonenca? ");
INSERT INTO rmyChergash_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ako procenil kaj našti te svladil len, bičhalela pire manušen te roden miro dok si lenđe protivnikurja još dur po drom. ");
INSERT INTO rmyChergash_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Zato khonikal našti postanil mungro učeniko savo či mućel sa so si les zbog mande.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Askal o Isus još phendas lenđe: “O lon si lačho. Ali ako o lon naj londo, sova askal lonđarela pe? ");
INSERT INTO rmyChergash_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","O bilondo lon naj lačho ni pale phuv, ni palo gnoište, nego samo te čhudel pes. Ašunen kana već si tumen kan!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Oko o Isus ćida pes e but e carinikurja thaj e bare bezehale manuša te ašunen les sar sikavel. ");
INSERT INTO rmyChergash_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Zato e fariseja thaj e učitelja e Mojsiješće zakonestar mrmljinas: “Družilpe e bezehalenca thaj još čak vi hal lenca!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Pe godova o Isus phendas lenđe akaja usporedba: ");
INSERT INTO rmyChergash_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ko tumendar, ako si les šel bakhre thaj hasarel jećhe či mućela okolen injavardeš thaj inja ande divljina, thaj či đelosas te rodel godole jećhe dok či araćhel les? ");
INSERT INTO rmyChergash_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","A kana araćhelas, pherdo bah čhol les pe dume ");
INSERT INTO rmyChergash_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","thaj boldel les ćhere thaj čim aresel ćhere akharel pire komšijen thaj pire drugaren thaj phenel lenđe: ‘Raduin tumen manca! Arakhlem mungre hasarde bakhres.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Phenav tumenđe, gajda savora ando nebo avena majbahtale pale jek bezehalo manuš savo pokajil pe nego pale injavardeš thaj inja save gndin kaj si pravedne thaj kaj o pokajanje naj lenđe potrebno.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","O Isus phendas lenđe: “Savi godoja manušnji, ako si lat deš rupa thaj jek hasarel, či del jag o stenko, lačhe šilavel o ćher thaj rodel dok či araćhel les? ");
INSERT INTO rmyChergash_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","A kana araćhel les, akharel pire komšinicen thaj pire drugaricen thaj phenel lenđe: ‘Raduin tumen manca! Arakhlem o rup savo hasardem.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Phenav tumenđe, kaj gajda e Devlešće anđelurja raduinape pale jek bezehalo savo obratil pe.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Thaj o Isus nastavisarda te ćerel svato: “Varesave manuše sas duj čhave. ");
INSERT INTO rmyChergash_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","O majterno phendas pire dadešće: ‘Dade, deman akana mungro nasledstvo savo pripadil manđe.’ Thaj o dad podelisarda o barvalipe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Kana nakhline varesave đesa o majterno čhavo ćida sa piro thaj otputuisarda ande dur phuv thaj okote potrošisarda sa piro barvalipe pire bilačhe trajosa. ");
INSERT INTO rmyChergash_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kana potrošisarda sa, dija e bari bok ande godoja phuv, thaj nas les so te hal. ");
INSERT INTO rmyChergash_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Askal đelo thaj zaposlisajlo sago sluga ke jek manuš ande godoja phuv thaj čarjarelas lešće balen. ");
INSERT INTO rmyChergash_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","O čhavo sas gajda bokhalo kaj rado halasas vi e ljuske katar e maune save hanas e bale, ali khonikal či delas len lešće. ");
INSERT INTO rmyChergash_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kana napokon avilo peste, phendas: Ke mungro dad e najamnikonen si habe gaći kaj uvek vi ačhel, a me akate merav bokhatar! ");
INSERT INTO rmyChergash_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Uštava, teljarava ke mungro dad thaj phenava lešće: ‘Dade, sagrešisardem protiv tute thaj protiv o Del ando nebo! ");
INSERT INTO rmyChergash_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Naj sem majbut dostojno te akhara man ćire čhavesa. Primi man sago jećhe katar ćire najamnikurja.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Uštilo thaj teljarda ke piro dad. Dok sas još dur katar piro ćher, lesko dad dikhla les dok sas još po drom thaj sažalisajlo pe leste thaj prastajas angle leste, dija les mrtiko thaj čumida les. ");
INSERT INTO rmyChergash_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","A o čhavo phendas lešće: ‘Dade, sagrešisardem protiv tute thaj protiv o Del! Naj sem majbut dostojno te akhara man ćire čhavesa.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","A o dad phendas e slugenđe: ‘Brzo inkalen e majšukar haljina thaj den pe leste! Čhon lešće e angrušći po naj thaj e sandale pe lešće pungre! ");
INSERT INTO rmyChergash_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Anen e majthule guruve thaj denle čhurjasa, pa te pogostime thaj te veselime. ");
INSERT INTO rmyChergash_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kaj, akava mungro čhavo sas mulo thaj akana bolda pe ando trajo, hasardo sas thaj akana arakhadilo!’ Thaj počnisardine te veselin pe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Pale godoja vrjama lesko majpurano čhavo ćerelas bući ande njive. A kana bolda pe thaj sas već paše, andar o ćher ašundolas e muzika thaj o ćhelipe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Pa akhardas jećhe slugo te phučel so si godova. ");
INSERT INTO rmyChergash_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","A o sluga phendas: ‘Bolda pe ćiro phral thaj ćiro dad dija čhurjasa e thule guruve te proslavil kaj lesko čhavo bolda pe džudo thaj sasto.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","O majpurano phral holjajlo thaj či kamla te del andre. Askal o dad inkljisto thaj počnisarda te molil les te del andre. ");
INSERT INTO rmyChergash_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","A vo phendas pire dadešće: ‘Me ake gaći brš služiv sago robo tuće thaj nikada či obisardem te ćerav so phendan manđe, a tu nikada ni jarco či dijan man te proveselima mungre drugarenca. ");
INSERT INTO rmyChergash_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","A kana avilo kava ćiro čhavo savo e bludnicenca haljarda sa ćiro barvalipe, tu dijan lešće čhurjasa majthule guruve.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Pe godova o dad lesko phendas lešće: ‘Čhaveja, tu san uvek manca thaj sa mungro vi ćiro si. ");
INSERT INTO rmyChergash_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ali trubul te raduji men thaj veselimen kaj akava ćiro phral sas mulo thaj akana bolda pes ando trajo, hasardo thaj arakhadilo!’” ");
INSERT INTO rmyChergash_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","O Isus askal phendas pire učenikonenđe e usporedba: “Sas varesavo barvalo manuš saves sas upravitelj saves e manuša prnas kaj rspil o barvalipe pire gospodaresko. ");
INSERT INTO rmyChergash_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","O barvalo manuš akharda pire upravitelje thaj phendas lešće: ‘So godova ašunav pale tute? Sikav manđe o računo kaj ramosardan sar vodijas e briga pale mungro barvalipe zato kaj majbut našti aves mungro upravitelj!’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Pe godova o baro sluga phendas ande peste: ‘So te ćerav kana mungro gospodari či del više te ćerav bući pale leste? Te džav te hanavav naj man snaga. Te prosiv? Ladžavo si manđe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Džanav so ćerava! Thaj kana gajda ćerava e manuša lačhe primina man ande pire ćhera, kana majbut či avava e gospodaresko upravitelj.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Askal akhardas jećhe po jećhe katar o okola save sas udžile lešće gospodarešće. Thaj phučla e prvo manuše savo sas udžile: ‘Kozom san udžile mungre gospodarešće?’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‘Šel bačve maslinsko zetino’, phendas o okova savo sas udžile. A o baro sluga phendas lešće: ‘Le ćiro računo beš thaj odma ramosar pandžvardeš.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Pale godova phendas e aver manušešće: ‘A tu, kozom san tu udžile?’ A vo phendas lešće: ‘Šel mere điv.’ Phendas vi lešće: ‘Le ćiro računo thaj ramosar pe ohtovardeš.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Thaj o gospodari pohvalisarda e bilačhe upravitelje kaj sas snalažljivo. Kaj e manuša akale themešće majsnalažljivo postupin prema okola save si lenđe slične, nego e manuša katar o svetlost. ");
INSERT INTO rmyChergash_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","A me phenav tumenđe, steknin tumenđe drugaren gajda kaj ispravno koristin akale themesko barvalipe thaj kana o barvalipe majbut či avela korisno o Del primila tumen ande večne stanurja ando nebo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ako šaj paćas e manušešće ande cikne buća, askal šaj paćas lešće vi ande bare buća thaj ako našti paćas e manušešće ande cikne buća askal našti paćas lešće ni ande bare buća. ");
INSERT INTO rmyChergash_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ako naj senas paćivale ande e themesko barvalipe, sar o Del poverila tumenđe duhovno barvalipe te upravin lesa? ");
INSERT INTO rmyChergash_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Thaj ako ande averesko barvalipe naj senas paćivale, sar o Del dela tumen tumaro? ");
INSERT INTO rmyChergash_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ni jek sluga našti robujil duje gospodarenđe ande isto vrjama. Kaj jećhe mrzala, a averes volila; ili jećhešće avela paćivalo a avres prezirila. Našti služin e Devlešće thaj e barvalipešće ande isto vrjama.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Sa gadava ašundine e fariseja save sas pohlepne pale love thaj marenas muj katar o Isus. ");
INSERT INTO rmyChergash_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","A o Isus phendas lenđe: “Tumen ćeren tumen kaj sen pravedne anglo them, ali džanel o Del tumare ile. Kaj so e manuša smatrin vredno, e Devlešće grjacolpe.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Askal o Isus phendas lenđe: “E Mojsijesko zakono thaj e knjige save ramosardine e purane prorokurja važinas sa dok či avilo o Jovano savo bolelas, a katar askal navestilas pe e Bahtali nevimata palo carstvo e Devlesko. Thaj katar askal nagovorisaras savoren te den ande Devlesko carstvo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ali godova či značil kaj e Mojsijesko zakon majbut či vredil kaj majloće nestanila o nebo thaj e phuv, nego te propadnil jek tačkica andar o zakono. ");
INSERT INTO rmyChergash_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Sago kaj ramol ando zakon: svako ko rastavil pe katar piri romnji thaj lel avrja, ćerel preljub; thaj ko oženil pe e romnjasa savi si rastanime, preljub ćerel.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Askal o Isus nastavisarda: “Sas varesosko barvalo manuš, savo lelas pe peste majšukar thaj majkuč drze, trajilas svako đes raikane thaj veselilas pe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","A angle lesko vudar pašljolas varesavo čoro manuš savo sas sa ande čirurja. Lesko alav sas Lazar, ");
INSERT INTO rmyChergash_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","thaj čeznilas samo te čaljol e prušukenca save perenas katar e barvalešći sinija. Dok gajda pašljolas avenas e džućhela thaj čarnas e čirurja pe leste. ");
INSERT INTO rmyChergash_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","A kana mulo o čoro, e anđelurja inđardine les ande Avramešće angalja. Pale godova mulo vi o barvalo manuš, thaj prahosardine les. ");
INSERT INTO rmyChergash_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","A lešći duša đeli po than kaj si e mule, thaj dok sas ande bare muke vazda pire jakha thaj dadural dikhla e Lazare ande Avramešće angalja. ");
INSERT INTO rmyChergash_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Thaj čhuta muj: ‘Dade Avraame, smiluitu manđe thaj bičhal e Lazare te umočil piro naj ando paj thaj šudrjarel mungri čhib kaj zurale muči man ande akava plameno.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Pe godova phendas o Avram: ‘De tut gođi, čhaveja, kaj tu pale ćiro trajo primisardan ćiro lačhipe, a gajda vi o Lazar piro bilačhipe. Akana vo akate tešil pe, a tu mučis tut. ");
INSERT INTO rmyChergash_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Osim godova, maškar amende thaj tumende si bari provalija thaj vi okola save kamline sas našti naćhen okotar akaring, niti akatar okoring.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Pe godova o barvalo manuš phendas: ‘Moliv tut askal, dade, bičhal e Lazare ando ćher mungre dadesko. ");
INSERT INTO rmyChergash_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Kaj si man pandž phral pa neka džal thaj upozoril len te na vi von aven akaring ande kava than e mukengo.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","A o Avram phendas lešće: ‘Opomenil len o Mojsija thaj e prorokurja ande pire zapisurja. Neka čiton thaj čhon kan lende.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","A vo phendas: ‘O na, dade Avraame! Nego te avilo lende vareko andar e mule, obratina pe.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","A vo phendas lešće: ‘Ako či ašunen e Mojsija thaj e prorokonen, či paćana sa vi te uštel thaj avel lenđe vareko andar e mule.’” ");
INSERT INTO rmyChergash_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","O Isus phendas pire učenikonenđe: “O iskušenje moraš te avel, ali teško e manušešće kroz savo avel o iskušenje. ");
INSERT INTO rmyChergash_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Kasave manušešće avilosas majlačhe te phanden lešće mlinsko bar oko e kor, thaj te čhuden les ando more, nego te crdel po bezeh jećhe katar akala manuša saven si cara paćipe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Upozoriv tumen! Ako ćiro phral savo si verniko pogrešil, ukori les thaj jartosar lešće ako pokajil pe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Pa ako vi efta drom po đes sagrešil protiv tute thaj efta drom po đes avel thaj phenel tuće: ‘Jartosar manđe. Pogrešisardem!’, jartosar lešće.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","E apostolurja phendine e Gospodešće: “Trubul amen majbut paćipe. Phen amenđe sar te dobis!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","O Gospod phendas lenđe: “Te avel tumen paćipe gajda cikno sago kaj si e gorušicako zrno, phendinesas akale dudošće: ‘Inkaltu e korenosa thaj presadi tut ando more!’, thaj vo presadisajlo sas. ");
INSERT INTO rmyChergash_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ko tumendar phenela pire slugašće savo oril ili lel sama pe stoka, kana boldela pes andar o polje thaj del ando ćher: ‘Av brzo thaj beš pale sinija?’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Či umesto godova phenena lešće gajda: ‘Ćer manđe večera! Čhov e keceljko pe tute thaj služisar man dok hav thaj pijav, pale godova tu haja thaj peja?’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","E slugašće pale godova či zahvalil pe kaj vo samo ćerel piri bući. ");
INSERT INTO rmyChergash_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Gajda vi tumen: kana sen poslušne e Devlešće, phenen: ‘Sluge sam save či zaslužin pohvala! Ćerdam samo so samas udžile te ćeras!’” ");
INSERT INTO rmyChergash_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Gajda dok putuilas majdur prema o Jerusalim, o Isus naćhelas maškar e Samarijaći thaj e Galilejaći regija. ");
INSERT INTO rmyChergash_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Kana delas ande varesosko gav, angle leste avile deš gubavcurja. Ačhiline cara majdur ");
INSERT INTO rmyChergash_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","thaj počnisardine te čhon muj: “Isuse, Učiteljina, smiluisar tut amenđe!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Kana o Isus dikhla len, phendas lenđe: “Džan thaj sikaven tumen e rašajenđe te dićhen tumen thaj phenen dali sen saste!” Thaj dok džanas dromesa sastile katar e guba. ");
INSERT INTO rmyChergash_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Jek lendar dikhla kaj sastilo, bolda pe thaj slavisarda e Devle andar sasto glaso. ");
INSERT INTO rmyChergash_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Čhuda pes pe koča angle Isusešće pungre thaj zahvalisarda lešće. A sas godova varesavo manuš andar e Samarija. ");
INSERT INTO rmyChergash_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","O Isus phučla: “Či li sastile deš džene? Kaj si okola inja? ");
INSERT INTO rmyChergash_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Dali nijek lendar či bolda pe te del slava e Devlešće osim akava tuđinco?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Askal phendas e manušešće savo sastilo: “Ušti thaj dža. Ćiro paćipe ande mande spasisarda tut!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Jekhvar kana e fariseja phučline e Isuse kana avela e Devlesko carstvo, O Isus phendas lenđe: “E Devlesko carstvo či avela e znakonenca save šaj dićhen pe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Našti phenela pe: ‘Aketalo akate!’, ili: ‘Eketalo okote!’ Ake e Devlesko carstvo si maškar tumende!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Pale godova phendas e učenikonenđe: “Avela e vrjama kana kamena te dićhen jek katar e đesa kana me, o Čhavo e Manušesko, vladiva sago o caro, ali či dićhena godova đes. ");
INSERT INTO rmyChergash_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Askal phenena tumenđe: ‘Eketalo okote, aketalo akate!’ Ali na džan thaj na prasten inća! ");
INSERT INTO rmyChergash_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kaj sago e munja kaj sevil pe jek krajo e nebesko thaj rasvetlil sa dži ke aver krajo, gajda avela vi manca, e Manušešće Čhavesa, ando mungro đes. ");
INSERT INTO rmyChergash_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ali majsigo trubuv but te pretrpiv thaj akava naraštaj trubula te odbacil man. ");
INSERT INTO rmyChergash_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Thaj sago kaj sas ande Nojašći vrjama gajda avela vi ando đes kana avava me o Čhavo e Manušesko. ");
INSERT INTO rmyChergash_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","E manuša hanas, pijenas, ženinas pe thaj udajinas pe dži ko đes dok o Noje či dijas ando baro brodo, thaj avilo o potop thaj uništisardas sa so nas ando baro brodo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Askal avela sago kaj sas dumut kana trajilas o Lot: Kana e manuša ando gav savo akhardolas Sodoma, hanas thaj pijenas, ćinenas thaj bićinenas, sadinas thaj gradinas, ");
INSERT INTO rmyChergash_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","sa dži ke detharin kana o Lot inkljisto andar o gav Sodoma, a askal andar o nebo zapljuštisarda e jag thaj o sumpor thaj uništisardas sa okolen save ačhiline ando gav. ");
INSERT INTO rmyChergash_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Isto gajda iznenada avela ando đes kana boldava man me o Čhavo e Manušesko. ");
INSERT INTO rmyChergash_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Gajda ande okova đes, ko avela po krovo, a lešće stvarja si ando ćher, neka na fuljel te lel len. Thaj ko si ande njive, neka či boldel pes palpale te lel vareso pesa. ");
INSERT INTO rmyChergash_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Den tumen gođi sar muli e Lotošći romnji! ");
INSERT INTO rmyChergash_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kaj ko lela sama pe piro trajo te araćhe les, hasarela les; a ko hasarel piro trajo zadobila les palo večnost. ");
INSERT INTO rmyChergash_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Phenav tumenđe, ande koja rjat kana me boldava man avena duj džene ande jek kreveto. Jek lela pes, aver mućela pe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Duj manušnja zajedno meljina o điv; jek lela pes, a aver mućela pe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Duj džene avena ando polje; jek avela lino, a aver ačhela.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Pe godova e učenikurja phučline les: “A kaj godova Gospode?” A o Isus phendas lenđe: “Avela očito sago vi akaja poslovica: ‘kaj ćiden pes e lešinarja okote kaj si o mulo telo.’” ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Askal o Isus phendas e učenikonenđe e usporedba te sikavel len sar uvek trubun te molin pe thaj sar nikada či trubun te odustanin. ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Thaj phendas: “Ande jek gav sas jek sudija savo či daralas e Devlestar a e themestar či ladžalas. ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","A ande godova gav sas vi jek udovica savi stalno avelas leste thaj molilas les: ‘Deman pravda angle mungro protivniko.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","O sudija varesavi vrjama či marilas pale godova, ali napokon phendas: ‘Vi ako či darav katar o Del thaj či mariv pale manuša, ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ali dava pravda akale udovica, kaj, ako či dav lat pravda, dosadila manđe dok či dobil piro pravo, kaj stalno dosadil man!’” ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Askal phendas o Gospod Isus: “Dićhen sar ispravno postupisarda o nepravedno sudija. ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Kaj o Del strpljivo čhola kan ke lenđe molitve thaj pobrinila pe te dobin pravda okola save pripadin lešće thaj vapin lešće o đes thaj e rjat. ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Phenav tumenđe kaj brzo dela len pravda. Ali kana me, o Čhavo e Manušesko, boldava man pe phuv, dali arakhava kasavo paćipe?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Askal o Isus phendas još akaja usporedba varesavenđe save sas uverime ande piri vlastito pravednost, a averen prezirisarenas: ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Duj manuša đele ando Hramo te molin pe. Jek sas fariseji a aver cariniko. ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","O fariseji ačhelas thaj molilas pe pale peste: ‘Devla, nais tuće kaj naj sem sago aver manuša, grabežljivo, nepravedno, preljubniko, ili sago akava cariniko. ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Me postiv duvar ando kurko; dav deš posto katar sa so si man.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","A o cariniko, ačhelas majdur, thaj či usudilas pe ni pe jakha te vazdel prema o nebo, nego pećelas pe ando kolin te sikavel piri tuga thaj phenelas: ‘Devla av milostivo manđe bezehalešće!’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Phenav tumenđe: vo bolda pe ćhere pravedno anglo Del, a na o fariseji! Kaj svako ko korkoro pes uzvisil, avela ponizime, a ko korkoro pes ponizil, avela uzvisime.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","A e Isusešće anenas vi e cikne čhavren te čhol pire vas pe lende te blagoslovil len, a kana godova dikhline e učenikurja braninas lenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","A o Isus akharda len thaj phendas: “Mućen e čhavren te aven mande thaj na branin lenđe, kaj kasavenđe pripadil e Devlesko carstvo.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","“Čače, phenav tumenđe, savo či primil e Devlesko carstvo sago cikno čhavro, či dela ande leste.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Varesavo židovsko vođa phučlas e Isuse: “Lačhe učiteljina, so trubul te ćerav te dobiv o večno trajo?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","A o Isus phendas lešće: “Sostar man akhares lačheja? Khonikal naj lačho, nego li samo o jedino Del. ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","A e zapovedi andar o Mojsijesko zakon džanes: ‘Na ćer preljub’, ‘Na mudar’, ‘Na čor’, ‘Na svedočisar hohamne’, ‘Poštuisar ćire dades thaj ćire deja.’ ” ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","A vo phendas: “Sa gadava ćerav katar mungro ternipe.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Kana godova ašunda o Isus, phendas lešće: “Još jek ačhilo tut: sa so si tut bićin thaj podelisar e čorenđe thaj avela tu barvalipe ando nebo. A askal av thaj dža pale mande.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kana vo godova ašundas, ražalostisajlo kaj sas zurale barvalo thaj či kamlas te bićinel sa so sas les. ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","O Isus dikhla pe leste thaj phendas: “Sar si phare e barvalešće te del ande Devlesko carstvo! ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Majloće si e kamilaće te naćhel kroz e suvjaće kan nego o barvalo te del ande Devlesko carstvo.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Okola save godova ašundine, phendine: “Pa ko askal šaj spasil pe?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","A o Isus phendas: “So si nemoguće e manušenđe, moguće si e Devlešće.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Askal o Petar phendas: “Ake, amen muklam sa amaro thaj teljardam pale tute te sledis tut.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","A o Isus phendas lenđe: “Čače, phenav tumenđe, naj godova savo muklasas piro ćher, ili pire romnja, ili pire phralen, ili pire dade thaj pire deja, ili pire čhavren zbog e Devlesko carstvo, ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","a te či već pe akava them primila majbut nego so mukla, a pe okova them savo avel vi večno trajo.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","O Isus ćida oko peste e dešuduj apostolen thaj phendas lenđe: “Ake das ando Jerusalim, a okote dogodila pe sa so e prorokurja ramosardine ando Sveto lil, pale mande e Čhave e manušešće. ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Von predaina man ande vas e nevernikonenđe, save marena muj mandar, ladžarena man, vređona man, ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","bičuina man thaj mudarena man, ali me o trito đes uštava andar e mule.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","A e učenikurja khanči katar godova so o Isus phendas či haćardine. O značenje godole alavengo sas lendar garado thaj našti haćardine so o Isus phenelas lenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","A kana o Isus avilo paše dži ko gav o Jerihon, varesavo koro manuš bešelas po drom thaj prosilas. ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","A kana o koro manuš ašunda kaj naćhel okotar o but o them, phučlas so si godova. ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Phendine lešće: “Naćhel o Isus andar o Nazaret.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","A vo pe godova čhuta muj: “Isuse e Davidešće Čhaveja, smiluitu tut manđe!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","A okola kaj džanas anglal o Isus ačhavenas e kore manuše te na čhol muj, ali vo još majzurale čholas muj: “E Davidešće Čhaveja, smiluitu manđe!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Kana o Isus ašunda les ačhilo thaj phendas te anen les leste. Kana e kore manuše andine majpaše o Isus phučla les: ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“So kames te ćerav tuće?” A vo phendas: “Gospode, te šaj dikhav.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","A o Isus phendas lešće: “Akana šaj te dićhes! Ćiro paćipe sastarda tut.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","E kore manušešće jakha odma putajle thaj počnisarda te dićhel, uputisajlo dromesa palo Isus thaj počnisarda te slavil e Devles. A sa o them savo godova dikhla dija slava e Devlešće. ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","O Isus dijas ando Jerihon. Dok naćhelas kroz o gav, ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","angle leste avilo o manuš savo akhardolas Zakej. Vo sas glavno cariniko thaj sas zurale barvalo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Probilas te dićhel e Isuse, ali sas zurale cikno manuš thaj našti dikhla les katar o but o them savo sas oko leste. ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Vo zato prastaja anglal, thaj lija pe opre pe smokva paše savi o Isus trubujas te naćhel te šaj dićhel les. ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Kana o Isus areslo pe godova than, dikhla opre thaj phendas lešće: “Zakej, brzo fulji tele! Ađes trubul te avav gosto ande ćiro ćher.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","O Zakej brzo fuljisto tele katar e smokva thaj pherdo bah ugostisarda les ande piro ćher. ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","A sa save godova dikhline počnisardine te mrmljan: “Đelo ando ćher e bezehalesko!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","A o Zakej ačhilo thaj phendas e Gospodešće: “Gospode ake, opaš mungro barvalipe dava e čorenđe! Thaj ako varekas hohadem, boldav štar drom majbut.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Pe godova o Isus phendas lešće: “Ađes ande akava ćher avilo o spasenje kaj si vi akava manuš e Avraamesko čhavo! ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Me o Čhavo e Manušesko avilem te rodav thaj te spasiv okova so si hasardo!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","O but o them sa godova ašunelas, a o Isus phendas lenđe još jek usporedba zato kaj sas o Isus paše pašo Jerusalim thaj gndinas kaj odma pojavila pe e Devlesko carstvo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Thaj phendas: “Sas varesavo ugledno manuš savo trubuja te otputuil ande dur phuv te okote okrunin les sago caros, a askal te boldel pe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Zato akhardas pire deš slugonen, dija len svakones po opaš kila rup so sas štar čhonenđi poćin thaj phendas lenđe: ‘Trguin akale rupesa dok či boldav man.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","A e manuša andar lešći phuv mrzanas les thaj bičhaldine pale leste e poslaniko te phenen e majbare carošće: ‘Či kamas te akava caruisarel pe amende.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Kana vo primisarda piro carstvo thaj bolda pe palpale, naredisarda te anen lešće okolen slugen savenđe dijas o rup te ašunel kozom zaradisardine. ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","O prvo sluga avilo thaj phendas: ‘Gospodarina, o iznos savo dijan man ćerdem te avel deš drom majbut.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Phendas lešće: ‘But lačhe! Lačho san sluga, zato kaj sanas verno ande cikno, dava tut te vladis pe deš gava!’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Aver sluga avilo thaj phendas: ‘Gospodarina o iznos savo dijan man ćerdem te avel pandž drom majbut.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Phendas lešće: ‘Lačhe! Vladi pe pandž gava!’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","A o trito sluga avilo bi zaradako thaj phendas: ‘Gospodarina, ale tuće ćiro rup, savo dijan man. Arakhavas les garado ando dikhloro. ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Daravas tutar kaj san strogo manuš. Les so či uložisardan, thaj žanjis so či sadisardan.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Phendas lešće: ‘Pe ćire alava aveja osudime, bilačho slugona! Džanglan kaj sem strogo manuš, kaj lav so či uložisardem thaj kaj ćidav kaj či sadisardem? ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Sostar askal či uložisardan mungre love ande banka? Gajda barem dobisardemas e kamatenca.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Pe godova o caro phendas kolenđe save sas okote ćidine: ‘Len lestar o rup thaj den okolešće saves si deš.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Phendine lešće: ‘Ali gospodarina, pa les već si deš kile rup!’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","O caro phendas lenđe: ‘Phenav tumenđe: Okoles kas si, dela pe lešće još majbut, a okoles save naj, lela pes lestar vi okova cara so si les. ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","A mungre dušmajen okolen save či kamline man te me avav caro, anen len akaring thaj mudaren len angle mande.’ ” ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nakon so phendas lenđe godova, o Isus teljarda majdur karingal o Jerusalim. ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Kana avilo paše dži ke gava e Vitfaga thaj e Vitanija save sas pe Maslinsko gora, bičhalda anglal pire duj učenikonen ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","thaj phendas lenđe: “Džan ando gav savo si angle tumende. Čim den ande leste, araćhena phangle terne magarco saves još khonik či jašisarda. Putren les thaj anen les. ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ako vareko phučel tumen: ‘Sostar putren e magare?’ Gajda phenen: ‘Trubun e Gospodešće’, thaj odma mućena len.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Von đele thaj arakhline e magarco sago kaj o Isus phendas lenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Thaj dok e učenikurja putrenas e magare, e magaresko gospodari phendas lenđe: “Sostar putren e magare?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","A von phendine: “Trubul e Gospodešće.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Andine e magare ko Isus thaj čhutine pire haljine po magarco thaj o Isus bešlo pe leste. ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Thaj dok O Isus gajda džalas po magarco, e manuša buljarenas pire ogrtačurja po drom angle leste te sikaven lešće čast. ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","A kana već avilo paše te fuljel katar e Maslinsko gora, e but e manuša save džanas pale leste počnisardine pe sa o glaso te zahvalin e Devlešće pale sa e čudurja save dikhline. ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Phenenas: “Blagoslovime o Caro, savo avel ando alav e Gospodesko! Miro po nebo thaj slava e Devlešće ande visine!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Pe godova varesave fariseja save sas maškar o them phenenas e Isusešće: “Učiteljina, phen ćire učenikonenđe te na phenen godova.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","O Isus phendas: “Phenav tumenđe, ako von ačhen, e bara slavina!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Kana o Isus avilo paše dži ko Jerusalim thaj dikhla o gav, o Isus rujas pale manuša andar leste. ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Thaj phendas: “Sar volisardemas te ađes arakhline sas o drom e mirosko! Ali akana si kasno, thaj o miro si garado tumendar. ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Avena e đesa kana o dušmano zauzmila ćire zidurja, okolina tut thaj ćićidena tu katar sa e riga. ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","O Jerusalime, sravnina tut e phuvjasa thaj vi ćire čhavren ande tute. Či ačhela tutar ni bar pe bareste kaj či pindžardan e vrjama kana o Del avilo te spasil tut.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kana o Isus dijas ando Hramo, počnisarda te tradel andar leste e trgovcen. ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Thaj phendas lenđe: “Ando Sveto lil ramol: ‘Mungro Hramo trubul te avel o ćher pale molitva’, a tumen pretvorisardine les ande razbojničko pećina!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Pale godova o Isus svako đes sikavelas ando Hramo, a e šorvale rašaja thaj e učitelja e Mojsiješće zakonestar zajedno e gavešće šorvalenca gndinas sar te mudaren les, ");
INSERT INTO rmyChergash_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ali či arakhline o način sar te ćeren godova kaj o them pažljivo čholas kan ke lesko sikavipe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Jek đes dok o Isus sikavelas e theme ando Hramo thaj navestilas e Bahtali nevimata, aviline leste e šorvale rašaja, e učitelja e Mojsiješće zakonestar thaj vi aver e židovske starešine ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","thaj phučline les: “Phen amenđe ko dija tut vlast te ćeres godova? Ko ovlasitisarda tut pale godova?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","A o Isus phendas: “Vi me tumen vareso phučava: Phenen manđe ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Dali o Del phendas e Jovanošće te bolel e manušen, ili e manuša phendine lešće te ćerel godova?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","A von počnisardine te raspravin pe maškar peste: “Te phendam katar o Del, phenela amenđe sostar askal či paćaine lešće? ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","A te phendam katar o manuš, sa o them čhudelape barenca pe amende dok či mudaren men. Kaj o them paćal kaj sas o Jovano proroko.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Zato phendine e Isusešće kaj či džanen kastar avilo e Jovanesko autoriteto te bolel. ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","A o Isus phendas lenđe: “Askal ni me či phenava tumenđe katar man vlast!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Pale godova o Isus phendas e themešće akaja usporedba: “Varesavo manuš zasadisardas o vinograd thaj iznajmisarda les e vinogradarenđe. A askal otputuisarda pe lungo vrjama. ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kana avili e vrjama pale berba, bičhaldas pire slugo ke vinogradarja te den les katar o plodo e drakako. Ali e vinogradarja mardine les thaj bičhaldine les palpale čuče vastenca. ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Pe godova vo bičhalda lenđe aver slugo. Ali von vi godole mardine, mardine muj lestar thaj bičhaldine le palpale čuče vastenca. ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Bičhaldas lenđe vi e trito. A von vi les izranisardine thaj tradine les. ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Pe godova o gospodari e vinogradesko phendas: ‘So te ćerav? Bičhalava lenđe mungre voljeno čhaves. Les valda poštuina kaj si mungro čhavo.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ali kana e vinogradarja dikhline e čhaves, počnisardine te ćeren svato maškar pende: ‘Akava si o nasledniko. Ajde te mudaras les thaj o nasledstvo avela amaro.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Tradine les avri andar o vinogrado thaj mudardine les. So gndin so ćerela lenca o gospodari e vinogradesko kana ašunela so sas? ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Avela thaj mudarela godole vinogradaren, a o vinograd dela aver vinogradarenđe ando najam.” A okola save ašunenas e Isuse phendine: “Amen vareso gajda nikad či ćerdamas!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","A o Isus lačhe dikhla pe lende thaj phendas: “A so askal značil okova odlomko savo ramol ando Sveto lil: ‘O bar saves čhudine e graditeljurja postanisardas o bar zaglavno?’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Te ko god perel pe godova bar phađela pes, a godova bar smrskola okoles pe kaste perel.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","E učitelja e Mojsiješće zakonestar thaj e šorvale rašaja kamline odma te astaren les kaj lačhe džangline kaj godoja usporedba odnosil pes pe lende, ali daranas katar o them. ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Katar askal počnisardine te vrebin les thaj bičhaldine e špijunen save ćerenas pe kaj si iskrene te šaj optužin e Isuse kaj phendas vareso bilačhe thaj te predain les e rimske upravitelješće. ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Thaj phučline e Isuse: “Učiteljina! Džanas kaj phenes čačipe thaj sikaves ispravno, thaj či dićhes ko si ko, nego čače sikaves e Devlesko drom. ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Phen amenđe dali trubul te amen e Židovurja das e carošće o porez ili te či das?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","A o Isus dikhla kaj kamen te astaren les ande zamka thaj phendas lenđe: ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Sikaven manđe e kovanica savjava poćinen o porez. Kasko si akava liko thaj o alav pe late?” A von phendine: “E carošći.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","“Askal den e carošće so si e carosko, a e Devlešće so si e Devlesko.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Gajda našti arakhline doš ande okova so o Isus phendas anglo them, nego ačhiline zadivime lešće naukava thaj ačhiline bi alavesko. ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Askal aviline leste varesave saduceja, save phenen kaj naj uštipe andar e mule. Thaj phučline e Isuse: ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Učiteljina, o Mojsije ramosarda amenđe te mulo varekasko phral saves sas romnji, a nas les čhavra, neka lesko phral lel lešće romnja sar voj bijandas lešće čhavo savo nasledila e imovina okolešći savo mulo thaj te inđarel lesko prezime. ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Gajda sas efta phral. Prvo phral oženisajlo thaj mulo, a nas les čhavra. ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Aver phral oženisajlo lešće romnjasa ali vi vo mulo, ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","askal o trito thaj gajda vi sa efta muline, a či mukline čhavra. ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Po krajo muli vi e romnji. ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kašći romnji askal voj avela kana e manuša uštena andar e mule kana sas romnji sa efta phralenđi?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","O Isus phendas lenđe: “E manuša akale themešće udajina pe thaj ženina pe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ali okolen saven o Del dićhel kaj si dostojne te ušten andar e mule thaj trajina ande okova them savo avela, či ženina pe niti udajina pe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Von majbut našti ni merena, kaj avena slične sar e anđelurja. Von si čhave e Devlešće kaj vo bolda len palpale andar e mule. ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","A kaj e mule uštena, godova čak vi o Mojsije potvrdisarda ando odlomko po than kaj phabolas o grmo kaj e Gospode akhardas e Avraamešće Devleja, e Isakošće Devleja thaj e Jakovešće Devleja dumut nakon so von muline. ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","A o Del naj Del e mulengo nego o Del e džudengo, kaj si savora ande leste džude.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Pe godova phendine lešće varesave učitelja e Mojsiješće zakonestar: “Učiteljina! Lačhe phendan!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Thaj khonik majbut či usudisajlo te vareso phučel les. ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Askal o Isus phučla len: “Sostar phenel pe kaj si o Hristo samo potomko e carosko Davidesko? ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Pa korkoro o David phenel ande knjige psalmurja: ‘Phenel o Gospod mungre Gospodešće: Beš pe mungri počasno desno rig ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","dok či čhav ćire dušmajen tale ćire pungre.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Korkoro o David akhardas les pire Gospodeja. Sar askal avilosas samo lesko potomko?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Askal anglo sa o them, o Isus phendas pire učenikonenđe: ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Len tumen sama katar e učitelja e Mojsiješće zakonestar, save volin te phiraven pe ande lundže haljine, volin te e manuša pozdravin len pe javne thana, thaj te bešen pe prve thana ande sinagoge, thaj e počelja pe gozbe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bi ladžavesko len katar e udovice okova so silen thaj hohamne molin pe dugo e Devlešće. Von avena majstrogo osudime.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","O Isus ando Hramo dikhla e barvalen sar čhon ande riznica love sago daro e Devlešće. ");
INSERT INTO rmyChergash_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","A dikhla vi varesošće čore udovica savi čhuta okote samo duj majcikne kovanice. ");
INSERT INTO rmyChergash_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Thaj phendas: “Čače, phenav tumenđe akaja čori udovice čhuta majbut savorendar. ");
INSERT INTO rmyChergash_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kaj savora von dine katar piro viško, a voj katar piro čoripe dijas sa so sila.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Dok varesave učenikurja ćerenas svato pale godova sar si o Hramo šukar ukrasime e barenca thaj e ukrasenca save e manuša andine e Devlešće, a o Isus phendas: ");
INSERT INTO rmyChergash_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Avela e vrjama kana katar akava so dićhen či ačhela ni bar pe bareste. Svako avela harado.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","E učenikurja phučline les: “Učiteljina, a kana godova avela? Thaj sar džanasa kaj godova uskoro avela?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","A vo phendas lenđe: “Len sama te na aven hohade kaj but džene avena ande mungro alav thaj phenena korkoro pale peste kaj si von o Mesija thaj phenena: ‘avili e vrjama’. Na džan pale lende! ");
INSERT INTO rmyChergash_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kana ašunena pale raturja thaj pale pobune, na daran. Kaj sa godova trubul te avel, ali godova još naj odma o krajo.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Askal još phendas lenđe: “O them borila pe protiv aver them, thaj e carurja protiv aver carurja. ");
INSERT INTO rmyChergash_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Pe sa e riga e themešće avena e potresurja, bokhalipe thaj nasvalipe. Po nebo avena čudesne znakurja savendar dela e dar pe sa o them. ");
INSERT INTO rmyChergash_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ali, majsigo nego godova sa avel astarena tumen thaj progonina tumen. Zbog mande predaina tumen e manušenđe ande sinagoge te sudin tumenđe. Inđarena tumen angle carurja thaj angle upravitelja zato kaj sledin man. ");
INSERT INTO rmyChergash_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Godova avela tumari prilika te den svedočanstvo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Zato zapamtin na majanglal te gndin so phenena ande tumari obrana! ");
INSERT INTO rmyChergash_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Me dava tumen alava thaj kasavi mudrost savjaće našti proturečila niti te odupril pe ni jek tumaro protivniko. ");
INSERT INTO rmyChergash_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","A izdaina tumen čak vi tumare dada, deja, phrala, drugarja thaj tumari familija. Varesaven tumendar vi mudarena. ");
INSERT INTO rmyChergash_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Savora mrzana tumen zato kaj sledin man. ");
INSERT INTO rmyChergash_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ali či perela ni jek bal katar tumaro šoro. ");
INSERT INTO rmyChergash_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Tumare duše spasina pe zbog godova, ako či odustanin.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","O Isus nastavisarda te phenel lenđe: “A kana dićhena kaj e vojska opkolisardas o Jerusalim, askal džanen kaj avili paše e vrjama kaj avela opustošime. ");
INSERT INTO rmyChergash_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Askal okola save si ande Judeja neka našen ande gore thaj save si ando gav neka inkljen andar leste, a ni o okola save si ando polje neka či bolden pe ando gav. ");
INSERT INTO rmyChergash_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kaj ande godola đesa avela e Devlešći kazna te pherdol sa so ramol ando Sveto lil. ");
INSERT INTO rmyChergash_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Teško e khamne manušnjenđe thaj okolenđe save den čuči e čhavren ande godola đesa! Kaj avena e bare nevolje pe phuv, thaj e Devlesko gnjevo pe akala manuša. ");
INSERT INTO rmyChergash_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Avena mudarde katar o oštro mačo, thaj avena inđarde ando robstvo pe sasto them. A o Jerusalim uštavena okola save či džanen palo Del dok či isteknil e vrjama okolenđi save či džanen palo Del.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","O Isus phendas: “Pojavina pe e znakurja po kham thaj po čhonut thaj pe čereja. A e theme pe phuv astarela o očaj zbog e huka thaj e talasurja andar o more. ");
INSERT INTO rmyChergash_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","O them merela e daratar thaj katar godova kaj ažućarena so avela pe akava them, kaj vi e nebeske sile avena uzdrmome. ");
INSERT INTO rmyChergash_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Askal dićhena man, e Čhave e Manušešće, sar avav pe nebeske oblakurja e silava thaj e bare slavava. ");
INSERT INTO rmyChergash_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kana počnila sa godova te avel, ušten thaj vazden tumare šore kaj o Del uskoro oslobodila tumen.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Pale godova o Isus phendas lenđe e usporedba: “Dićhen e smokva ili bilo savo aver kaš. ");
INSERT INTO rmyChergash_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kana dićhen kaj mućen e patrja, korkoro već džanen kaj paše si o milaj. ");
INSERT INTO rmyChergash_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Gajda vi tumen kana dićhen sa akala događaja, džanen kaj si paše o carstvo e Devlesko. ");
INSERT INTO rmyChergash_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Čače, phenav tumenđe, kaj akava naraštaj sigurno či naćhela dok sa akava či avel. ");
INSERT INTO rmyChergash_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","O nebo thaj e phuv naćhena, ali mungre alava či naćhena nikad.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","O Isus phendas lenđe: “Len sama te či zuravol tumaro ilo ando handžvali pe palo habe thaj ando matipe ili ande trajošće brige thaj te či iznenadil tumen godova đes, ");
INSERT INTO rmyChergash_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","savo avela sago zamka, pe sa e manuša save trajin pe sasti phuv. ");
INSERT INTO rmyChergash_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Zato stražarin thaj molin tumen e Devlešće te šaj naćhen sa akava so trubul te avel thaj te ačhen sago pobednikurja angle mande, anglo Čhavo e Manušesko.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","O Isus svako đes sikavelas ando Hramo, a raćava inkljelas thaj raćarelas pe Maslinsko gora. ");
INSERT INTO rmyChergash_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","A sa o them već katar e rano detharin avenas leste ando Hramo te ašunen les. ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Avili paše e Pasha savi sas prvo đes katar o prazniko e bi kvascošće mangrengo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","E šorvale rašaja thaj e učitelja e Mojsiješće zakonestar rodenas sar te mudaren e Isuse. Ali daranas katar o them. ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Askal o beng dijas ando Juda andar o gav Iskariot, jek katar e dešuduj e Isusešće apostolurja. ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Vo đelo thaj dogovorisajlo e šorvale rašajenca thaj e Hramske stražarenca sar te predail lenđe e Isuse. ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","A von, kana ašundine, raduisajle thaj obećisardine kaj dena les love. ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","O Juda pristanisardas thaj katar askal počnisarda te rodel lačhi vrjama te izdail e Isuse lenđe, a te na dićhel o them. ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Kana avilo o prvo đes katar o prazniko e bikvascošće mangrengo, ande savo trubujasas te žrtvujil pe o bakhro palo prazniko e pasha, ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","o Isus bičhalda e Petre thaj e Jovano thaj phendas lenđe: “Hajde džan thaj pripremin amenđe te has e pasha.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","A e učenikurja phučline les: “Kaj kames te pripremis lat?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","A vo phendas lenđe: “Ake, čim den ando gav malavela tumen o manuš savo inđarel paj ando ćupo. Teljaren pale leste ando ćher savo vo del ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","thaj roden e domaćine ande godova ćher thaj phenen lešće: ‘O učitelj phučel ande savi soba šaj hal e pashalno večera pire učenikonenca?’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Vo sikavela tumenđe e bari soba po sprato. Okote pripremin.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","E učenikurja đele ando gav thaj arakhline sa sar o Isus phendas lenđe thaj okote pripremisardine e pashalno večera. ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kana avili e vrjama pale večera, o Isus lija than pale sinija e apostolenca. ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Askal phendas lenđe: “Saste ileja čeznisardem te hava tumenca akaja pashalno večera majsigo nego so aven mungre muke. ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kaj phenav tumenđe, či majbut hava e pashalno večera dok či pherdol laći svrha ande Devlesko carstvo.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Lijas o tahtaj e molasa, zahvalisarda e Devlešće thaj phendas: “Len thaj razdelin maškar tumende. ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Kaj, phenav tumenđe: či majbut pijava mol sa dži ke okova đes kana pijava tumenca nevi mol ando carstvo mungre Dadesko.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Askal o Isus lija o mangro, zahvalisarda e Devlešće pale leste, phagla les thaj dija pire učenikonenđe thaj phendas: “Akava si mungro telo savo del pe pale tumende. Akava ćeren manđe po spomen.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Gajda lija vo o tahtaj posle e večera thaj phendas: “Akava tahtaj si Nevo savez ande mungro rat, savo čhordol pale tumende.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Ali ake, mungro izdajniko bešel manca pale sinija. ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Me o Čhavo e Manušesko, moraš te merav sar si odredime, ali jao okolešće savo izdaila man!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","A e učenikurja pe godova počnisardine te phučen pe ko maškar lende šaj avilosas godova. ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Askal e učenikurja počnisardine te prepirin pe maškar pende ko si lendar majbaro. ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","A o Isus phendas lenđe: “E carurja akale themešće gospodarin pe pire thema thaj okola saven si vlast pe thema kamen te o them phenel pale lende kaj si lačhe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ali tumen na ćeren gajda! Naprotiv, okova savo si majbaro maškar tumende, neka avel majcikno, a o vođa sago okova kaj služil. ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kaj ko si majbaro? Okova savo bešel pale sinija ili okova savo služil les? Dali naj okova savo si pale sinija? A me ake služiv maškar tumende. ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ačhiline manđe verne ande mungre kušnje. ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Zato dav tumen ando nasledstvo e carosko čast kaj man dija lat mungro Dad ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","te han thaj te pijen pale mungri sinija ande mungro Carstvo thaj te bešen pe prestolja te sudin e dešuduj plemenurja e Izraelošće.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","A o Isus phendas: “Simone! Simone! Ake o Sotona rodel katar o Del te probil tumaro paćipe ande mande. Zato rešetila tumen sago o điv kroz o sito. ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ali me molisajlem pale tute te ćiro paćipe ande mande ačhel. A kana palem boldeja tu mande, učvrsti ćire phralen.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","O Petar phendas lešće: “Gospode, spremno sem tusa te džav vi ande tamnica vi ando smrto.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","A o Isus phendas lešće: “Phenav tuće Petre, ađes ni o bašno či oglasila pes a tu trin drom hohaveja kaj či pindžares man.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Thaj phendas: “Kana bičhaldem tumen po drom bi lovengo, bi trastako thaj bi sandalengo, dali falilas tumenđe vareso?” A von phendine: “Khanči či falilas amenđe.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ali akana phendas lenđe: “Kas si love, neka lel len pesa! Isto gajda vi e trasta! A kas naj mačo, neka bićinel pire gada thaj nek ćinel pešće mačo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kaj phenav tumenđe, moraš te pherdol pe mande okova so si ramome ando Sveto lil: ‘Ubrojime si maškar e zločincurja.’ kaj sa so e prorokurja ramosardine pale mande pherdola pe.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Von phendine lešće: “Gospode, ake akate si amen duj mačurja!” A o Isus phendas lenđe: “Dosta si!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Askal inkljisto okotar thaj po običaj uputisajlo pe maslinsko gora. Pale leste teljardine vi lešće učenikurja. ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Kana areslo okote phendas lenđe: “Molin tumen te na peren ande kušnja!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Pale godova đelo majdur lendar kozom šaj čhudel pe o bar thaj pelo pe pire koča thaj molisajlo: ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Dade! Ako kames, le mandar akava tahtaj patnje. Ali na te avel mungri nego ćiri volja!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","A askal sikadilo lešće o anđelo andar o nebo te ohrabril les. ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","A o Isus sa majzurale molilas pe, ande smrtno muka, a o znojo pe leste postanisardas sago kapljice e ratešće save perenas pe phuv. ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Uštilo katar e molitva, bolda pe ke učenikurja thaj arakhla len sar soven, iscrpime katar e žalost. ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Pa phendas lenđe: “Sostar soven? Ušten! Molin tumen te na peren ande kušnje!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Dok o Isus još ćerelas svato, avilo o them thaj angle lende o Juda jek katar e dešuduj učenikurja. Vo avilo paše ko Isus thaj kamla te čumidel les. ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","A o Isus phendas lešće: “Juda, zar e poljupceja kames te izdais man, e Manušešće Čhave?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","A kana e ostale učenikurja dikhline so si, phučline: “Gospode, te napadnis len e mačesa?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","A jek lendar zamahnisardas e mačesa pe šorvale rašajesko sluga thaj čhinda lesko desno kan. ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","A o Isus phendas: “Mućen len te ćeren godova! Na oduprin tumen majbut!” Askal čhuta o vas pe lesko kan thaj sastarda les. ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Askal o Isus phendas e manušenđe save aviline te astaren les, e šorvale rašajenđe, e hramske stražarenđe thaj e židovske starešinenđe: “Sago po pobunjeniko aviline pe mande e mačonenca thaj e rovljenca! ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Sostar či astardine man ando Hramo? Svako đes semas okote tumenca. Ali akava si tumaro časo thaj vladil e tama.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Astardine e Isuse thaj inđardine les ando ćher e šorvale rašajesko. A o Petar dadural džalas pale leste. ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","A e stražarja maškare ande avlija astardine jag thaj bešline okolo late. A o Petar bešlo maškar lende. ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Varesavi sluškinja dikhla les kaj bešel paše jag, oštro dikhla pe leste thaj phendas: “Vi akava sas e lesa!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","A o Petar hohadas: “Manušnjije pa me či pindžarav les.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Nedugo pale godova još vareko lija les sama thaj phendas: “Vi tu san jek lendar!” A o Petar phendas: “Naj sem, manušeja!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Kana nakhlo varekaj katar jek sato, vareko aver odlučno phendas: “Vi akava sas čače lesa! Pa Galilejco si!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","A o Petar phendas: “Manušeja, či džanav so phenes!” Isto časo dok još motholas, oglasisajlo o bašno. ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Askal o Gospod bolda pe thaj dikhla po Petar, a o Petar dija pe gođi ke alava e Gosodešće, save phendas lešće: “Phenav tuće još akaja rjat majsigo nego so o bašno ašundol, trin drom hohaveja kaj či pindžares man.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","O Petar inkljisto andar e avlija thaj zurale rujas. ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","A e čuvarja počnisardine te maren e Isuse thaj te maren muj lestar ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Učhardine lešće jakha thaj phenenas lešće: “Prorokuisar ko dija tut dab!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Thaj but aver podrugljive alava phenenas lešće. ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","A kana svanosardas o đes, ćida pes o starešinstvo e themesko, e šorvale rašaja thaj e učitelja e Mojsiješće zakonestar thaj andine e Isuse anglo baro židovsko veće. ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Von phendine lešće: “Ako san tu o Hristo, phen amenđe godova!” A o Isus phendas lenđe: “Ako phenav tumenđe, či paćana manđe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ako phučav tumen dali sem me o Hristo, či odgovorina manđe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ali katar akana me, o Čhavo e Manušesko, bešava po počasno than pašo svemogućo Del.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Pe godova savora phendine: “Tu dakle tvrdis kaj san o Čhavo e Devlesko!” Vo phendas lenđe: “Tumen korkoro pravo phenen! Me sem!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Pe godova von phendine: “Či trubul amen majbut dokaz. Korkoro ašundam andar lesko muj!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Askal sa e manuša save sas ando židovsko baro veće uštiline thaj inđardine e Isuse ko Pilato savo sas rimsko upravitelj ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","thaj optužisardine les: “Astardam les sar zavodil e theme thaj phenel lenđe te na poćinen o porez e carošće, a pale peste phenel kaj si vo o Hristo, amaro caro.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","O Pilato phučla les: “Dali san tu o caro e Židovengo?” A o Isus phendas lešće: “Gajda si sago kaj tu phenes!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Askal o Pilato phendas e šorvale rašajenđe thaj e themešće: “Nisošći doš či arakhav pe akava manuš!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ali von počnisardine još majbut te navalin: “Bunil e theme pire naukava ande sasti phuv e židovenđi. Počnisarda ande regija e galilejaći thaj avilo sa dži akaring ando Jerusalim!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Kana godova ašundas o Pilato, phučla len, dali si godova manuš galilejco. ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Kana potvrdisardine godova, o Pilato bičhaldas e Isuse ko Irod, savo vladilas ande galilejaći regija. A o Irod baš askal arakhadilo ando Jerusalim. ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","A kana o Irod dikhla e Isuse, zurale raduisajlo kaj dumut već lija te dićhel les zbog okova kaj ašundas pale leste thaj nadisajlo kaj lestar dićhela varesosko čudo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Thaj but phučlas e Isuse, ali vo khanči či phendas lešće. ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","A e šorvale rašaja thaj e učitelja e Mojsiješće zakonestar ačhenas thaj žestoko prnas les. ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","O Irod zajedno pire vojnikonenca marda muj lestar. Dijas pe leste e carske haljine thaj bičhalda le palpale ko Pilato. ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Godova đes o Irod thaj o Pilato pomirisajle kaj sas majsigo dušmaja. ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","O Pilato akhardas e šorvale rašajen, e vođen thaj e themes ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","thaj phendas lenđe: “Andine manđe akale manušes e optužbava kaj vo vazdel e themes pe buna. Me ake phučav les angle tumende thaj či arakhlem ni jek doš pe leste pale savi prn les. ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","A či arakhla e doš pe leste, ni o Irod thaj zato bičhalda les palpale amende. Ake, vo či ćerda khanči sova zaslužisardas smrto. ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Zato dava naredba te bičuin les thaj askal mukava les.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","A svako brš kana sas o prazniko Pasha, mućenas lenđe po jećhe phangles ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","A sa o them ande jek glaso čhuta muj alavenca: “Mudar les a muk amenđe e Varava!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(O Varava sas ande tamnica kaj mudardas, thaj kaj vazdas e buna ando Jerusalim.) ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","O Pilato probisarda te odgovoril len kaj kamelas te mućel e Isuse. ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ali o them čholas muj: “Razapnisar les! Razapnisar les!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Phučla len o Pilato trin drom: “Ali savo zločino vo ćerda? Me khanči či arakhav pe leste sova zaslužisardas smrto. Zato dava te bičuin les thaj mukava les.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","A o them čholas muj thaj navalinas te razapnin e Isuse. Thaj čhonas muj sa majzurale thaj majzurale. ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","O Pilato presudisarda te udovoljil lenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Thaj mukla o kole savo sas čhudino ando phanglipe zbog e pobuna thaj zbog o mudaripe, a e Isuse dijas ande vojnikonenđe vas te ćeren lesa okova so o them kamlas. ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Dok inđarenas e Isuse, astardine varesave Simone andar o gav e Kirinija, savo boldelas pe andar o polje thaj čhutine pe leste o trušul te inđarel palo o Isus. ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Palo Isus džalas o but them thaj e manušnja save rovenas thaj kukinas pale leste. ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","O Isus bolda pe lende thaj phendas lenđe: “Manušnjalen andar o Jerusalim, na roven pe mande, nego roven pe tumende thaj pe tumare čhavra. ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kaj ake aven e đesa kana phenela pe: ‘Blago e nerotkinjenđe, blago e điješće savo či bijanda thaj blago e čučenđe save či pravardine.’ ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Askal e manuša molina e gore te peren pe lende thaj e bregonen te učharen len. ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kaj ako gajda ćerel pe e zelene kaštenca, so tek avela e šuće kaštenca?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","E Isuseja po mudaripe inđarenas vi aver duj zločinconen. ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kana aviline po than savo akhardolas Lubanja, okote razapnisardine e Isuse, a paše leste vi godole zločinconen, jećhe pe lešći desno rig, a avre pe lešći levo rig. ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","A o Isus phenelas: “Jartosar lenđe, Dade Devla, kaj či džanen so ćeren!” Pale godova e vojnikurja čhudine e kocka thaj gajda podelisardine maškar peste lešće drze. ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","O them ačhelas okote thaj dićhelas, a e verske vođe marenas lestar muj e alavenca: “Averen spasisardas, neka akana spasisarel korkoro pes ako si vo čače o Hristo e Devlesko izabraniko!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Vi e vojnikurja marenas muj lestar, avenas paše leste thaj nudinas les e mol savi sas hamime e šuteja ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","thaj phenenas: “Ako san tu o caro e židovengo, spasi korkoro tut!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","A opral lesko šoro čhutine vi natpis pe savo ramolas: “Akava si o caro e židovengo.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jek katar o razapnime zločinco vređolas e Isuse thaj phenelas: “Naj san li tu o Hristo? Pa spasi tut thaj vi amen!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Askal aver phendas: “Zar či daras e Devlestar? Trpis isto kazna sago vi vo? ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ali pravedno si te amen trpis kaj primisardam so zaslužisardam amare trajosa, a akava manuš khanči bilačhe či ćerda.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Askal phendas: “Isuse, kana počnija te vladis sago caro, de tut gođi pe mande thaj av manđe milostivo.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","A o Isus phendas lešće: “Čače phenav tuće: ađes aveja manca ando rajo!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kana već avilo o mismeri, pe sasti phuv nastanisarda o tunjariko thaj sas dži ke o trito sato mismere, ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","kaj o kham pomračisajlo, a e firanglje ando Hramo pharadile pe opaš. ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","A o Isus još jekhvar čhuta muj andar sasto glaso: “Dade Devla, ande ćire vas predaiv mungro duho!” Godova phendas, thaj izdahnisarda. ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Kana o rimsko stotniko dikhla so dogodisajlo, ačhilo te slavil e Devle thaj phendas: “Akava manuš sas čače pravedniko!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nakon godova sa o them savo ćida pes te dićhel godova prizor dikhline so sas, boldenas pe ćhere thaj marenas pe katar e tuga ando kolin. ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Majdur ačhenas sa okola kaj pindžarenas e Isuse thaj e manušnja save džanas pale leste andar e Galileja thaj promatrinas. ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Sas varesavo manuš savo akhardolas Josif. Vo sas versko većniko. Thaj sas lačho thaj pravedno manuš ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","andar e Arimateja, gav savo si ande Judeja. Vo či složisajlo e odlukava thaj e postupkosa so ćerdine e Isusešće, nego ažućarelas te avel e Devlesko carstvo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Vo đelo ko Pilato thaj rodas lestar e Isusesko telo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pale godova fuljardine les katar o trušul, paćardine les ando pohtan thaj čhutine les ando isklesime limori ande savo još khonik nas čhutino. ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Godova sas đes kana o them pripremilas pe palo savato, savo uskoro započnila. ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","A godova sa pratinas e manušnja save aviline e Isuseja andar e Galileja. Thaj dićhenas sar čhonas e Isusesko telo ando limori. ");
INSERT INTO rmyChergash_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Pale godova boldine pe ćhere te pripremin e miomirisurja thaj o pomast savo koristilas pe palo prahope. A kana godova završisardine, već sas o savato pa sasto đes našti khanči ćerdine kaj poštuinas e odredba andar o zakon. ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Prvo đes ando kurko, detharinako rano, e manušnja aviline po limori e miomirisenca save von korkoro ćerdine. ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","A kana aresline dži ko limori arakhline o bar spidino katar o limori. ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Dine andre, ali či arakhline o telo e Gospode Isusesko. ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Thaj dok ačhenas gajda zbunime, angle lende pojavisajle duj manuša ande blistavo parne haljine. ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","E manušnja darajle thaj poklonisajle e mujesa dži ke phuv, a e duj manuša phendine lenđe: “Sostar roden e džude maškar e mule? ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Naj akate, nego uštilo andar e mule! Den tumen gođi sar phendas tumenđe dok još sas ande Galileja: ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Me o Čhavo e Manušesko moraš te avava dino ande vas e bezehalenđe thaj razapnina man, ali me o trito đes uštava andar e mule.’” ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Askal e manušnja dine pe gođi kaj o Isus phendas godova. ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Thaj boldine pe katar o limori thaj sa godova javisardine e dešujek apostolenđe thaj savorenđe averenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","A godola manušnja sas e Marija andar e Magdala, e Jovana, e Marija dej e Jakovešći, thaj još varesošće manušnja. Von sa godova so sas phendine e apostolenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","A e apostolenđe sa gadava činisajlo sago kaj umislisardine, thaj či paćaine e manušnjenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","A o Petar ipak, uštilo thaj prastaja karingal o limori. Kana areslo, provirisarda andre thaj dikhla andre o pohtan katar o lano sar pašljol ando limori. Pale godova bolda pes ćhere ando čudo savo dogodisajlo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Godova đes e Isusešće duj sledbenikurja putuinas ando gav savo akhardolas Emaus, savo sas majdur katar o Jerusalim dešujek kilometrja. ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Dromesa ćerenas svato maškar pende pale sa so sas. ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Thaj dok gajda ćerenas svato thaj raspravinas, avilo dži lende o Isus thaj džalas lenca. ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ali nas dino lenđe jakhenđe te pindžaren les. ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","O Isus phučla len: “So godova raspravin dromesa?” Von ačhiline phađe katar e tuga. ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Jek lendar, savo akhardolas Kleopa, phendas lešće: “Zar san tu jedino stranco ando Jerusalim savo či džanel so sas ando Jerusalim akala đesa?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","A o Isus phučla: “So sas godova?” A von phendine lešće: “Pa okova so dogodisajlo e Isuseja andar o Nazaret. Vo sas proroko, silno pe dela thaj ande alava anglo Del thaj angle sa o them: ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ali amare šorvale rašaja thaj e vladarja predaisardine les te avel osudime po smrto thaj te razapnin les. ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","A amen nadisajlam kaj si vo okova savo izbavila o Izrael osim godova, akava si već trito đes sar gadava dogodisajlo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","A još vi varesave manušnja, save sas maškar amende, zbunisardine men: čim svanosardas đele po limori, ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ali okote či arakhline lesko telo pa aviline thaj phendine amenđe kaj sikadile lenđe e anđelurja thaj phendine lenđe kaj si o Isus džudo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Varesave amarendar prastajine po limori thaj arakhline sa sar e manušnja phendine, ali les či dikhline.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","A o Isus pe godova phendas lenđe: “O sar sen nerazumne, nisar te paćan ande okova so phendine e prorokurja! ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Dali či von prorokuisardine kaj o Hristo sa godova moraš te pretrpila majsigo nego so o Del proslavila les?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Askal o Isus započnisardas te objasnil lenđe sa so sas ramome ando Sveto lil, katar o Mojsije dži ke e prorokurja. ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Pe godova avile paše dži ko gav ande savo džanas, a lenđe pričinisajo sago kaj o Isus kamelas te nastavil majdur o drom. ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ali von nagovorinas les: “Ačh amenca! Kaj već peli e rjat, a o đes naćhel!” Vo ačhilo thaj dijas lenca ando ćher. ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kana o Isus lijas te hal lenca, lijas o mangro, blagoslovisarda les, phagla les thaj dija len. ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Pe godova putajle lenđe jakha thaj pindžardine les, ali vo nestanisardas angle lenđe jakha. ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Askal von phendine jek avrešće: “Či li phabolas amaro ilo ande amende dromesa dok ćerelas amenđe svato, thaj dok tumačilas amenđe o Sveto lil?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Odma spremisajle thaj boldine pe ando Jerusalim. Okote arakhline e dešujek apostolen thaj vi averen e Isusešće sledbenikonen, ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","save phendine lenđe: “O Gospod čače uštilo andar e mule thaj sikadilo e Simonešće!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Askal von phendine sar maladine e Gospode po drom palo Emaus thaj sar pindžardine les kana phaglas o mangro. ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Dok von ćerenas svato pale godova, o Isus katar jekhvar ačhilo maškar lende thaj phendas lenđe: “Miro tumenđe!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Von, zbunime thaj darade, gndisardine kaj dićhen e duho. ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","A o Isus phendas lenđe: “Sostar darajle? Sostar kasavi sumnja dija ande tumare ile? ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Dićhen mungre vas thaj mungre pungre! Me sem gadava! Pipnin man thaj dićhena! E duho naj kokala ni mas sago kaj dićhen kaj man si!” ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Kana godova phendas lenđe, sikada lenđe e ožiljkurja pe pire vas thaj pire pungre. ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Katar o čuđenje thaj katar e bah našti paćaine. A vo phučla len: “Si tumen vareso hamasko?” ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Von dine les kotor peko mačho. ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Vo lija les thaj halas anglal lende. ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Askal phendas: “Pale akava phenavas tumenđe dok još semas tumenca: Trubul te pherel pe sa so si ande Mojsijesko zakono, ande proročke lila thaj ande psalmurja ramome pale mande.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Askal putardas lenđi gođi te haćaren o Sveto lil. ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Thaj phendas lenđe: “Ramome si ande Svete lila: O Hristo trpila thaj merela, a o trito đes uštela andar e mule. ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ande lesko alav propovedila pe sa e manušenđe kaj trubun te pokajin pe gajda te o Del jartol lenđe e bezeha. A počnila katar o Jerusalim. ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Tumen sen svedokurja pale godova. ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","A me bičhalava tumenđe e Sveto Duho, baš sago kaj mungro Dad obećisarda. Zato ačhen ando gav dok či len pe tumende e sila opral.” ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Pale godova o Isus inđarda len paše dži ko gav Vitanija. Okote vazdas pire vas thaj blagoslovisarda len. ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Gajda sar blagoslovisarda len, durilo lendar thaj sas lino ando nebo. ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Von peline pe koča angle leste thaj askal bare bahtasa boldine pe ando Jerusalim. ");
INSERT INTO rmyChergash_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Thaj svako đes ando Hramo slavinas e Devle.");
INSERT INTO rmyChergash_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ando početko sas o Alav, thaj o Alav sas ko Del. Thaj o Alav sas o Del. ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Vo sas ando početko ko Del. ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Kroz leste sa postanisarda thaj bi leste či postanisardas khanči so postoil. ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ande leste sas o trajo, thaj godova trajo sas svetlo e manušenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","O svetlo svetlil ande tama, thaj e tama či nadvladisarda les. ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Pojavisajlo manuš, bičhaldo katar o Del, e alavesa Jovan. ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Vo avilo te svedočil palo svetlost, te savora kroz leste paćan. ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","O Jovano nas svetlo, nego svedočilas palo svetlo. ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","O čačutno svetlost, savo prosvetlil svako manuše – avilo po them. ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Sas po them, thaj o them kroz leste postanisardas, ali o them či pindžarda les. ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Avilo ande piro them, ali lešće manuša či primisardine les. ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","A savorenđe save primisardine les, save paćan ande lesko alav, dijas pravo te postanin čhavra e Devlešće, ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","čhavra bijande na e prirodno dromesa, ni e telošće voljatar, ni e romešće voljatar, već bijande e Devlestar. ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Thaj o Alav postanisardas manuš thaj avilo te trajil maškar amende. Dikhlam lešći slava, slava savi si les sago jedino bijando savo avilo katar o Dad, pherdo milost thaj čačipe. ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","O Jovano svedočil pale leste thaj čholas muj: “Akava si okova pale savo phendem tumenđe: Okova savo avel pale mande, majbaro si mandar, kaj postoilas majsigo mandar.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Katar lešći punina savora primisardam, thaj godova milost pe milost. ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Kaj, o Zakono si dino prekal o Mojsije, a e milost thaj o čačipe avile prekal o Isuso Hristo. ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","E Devles nikad khonik či dikhla, osim o jedino bijando Čhavo savo si vi korkoro Del. Vo si e Dadešće majpaše thaj vo sikadas amenđe sosko si o Del. ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","A kava si e Jovanesko svedočanstvo. E Židovurja andar o Jerusalim bičhaldine leste e rašajen thaj e Leviten te phučen les: “Ko san tu?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","O Jovano jasno phendas lenđe thaj či garadas khanči: “Me naj sem o Hristo.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Askal phučline les: “Pa ko san tu askal? San tu o proroko Ilija?” Vo phendas: “Naj sem.” “San tu o proroko saves ažućaras?” Vo phendas: “Naj sem.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Askal phendine lešće: “Phen amenđe ko san tu, te šaj phenas okolenđe save amen bičhaldine. So tu phenes pale tute?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Vo phendas lenđe: “Me sem ‘o glaso savo čhol muj ande pustinja: Vorton o drom te avel spremno kana avela o Gospod!’ sago kaj prorokuisarda o proroko Isaija.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","A varesave katar godola manuša save sas bičhalde sas fariseja. ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Von phučline les: “Sostar askal boles ako naj san o Hristo, ni o Ilija, ni proroko savo trubul te avel?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","O Jovano phendas: “Me bolav e pajesa, ali maškar tumende ačhel jek saves tumen či pindžaren. ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Vo avel pale mande, a me naj sem dostojno e haravlje te putarav pe lešće sandale.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Godova sas ande Vitanija, katar e istočno rig e reka jordanošći, kaj o Jovano bolelas. ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Thejara đes o Jovano dikhla e Isuse sar avel leste, thaj phendas: “Ake o Bakhro e Devlesko, savo lel e bezeha themešće! ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Akava si okova pale savo me phendem: ‘Pale mande avel o manuš savo si majbaro mandar, kaj postoilas majsigo mandar.’ ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Me či pindžaravas les, ali avilem te bolav e pajesa, te vo šaj objavil pe e izraelsko themešće.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Askal o Jovano gajda svedočisardas: “Dikhlem e Sveto Duho sar fuljel andar o nebo sago golubo thaj ačhel pe leste. ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Me či pindžardemas les ko si vo, ali phendas manđe okova savo bičhalda man te bolav e pajesa: ‘Pe kaste dićhes kaj o Duho fuljel thaj pe leste ačhel, godova si okova savo bolel e Sveto Duhosa.’ ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Thaj me dikhlem thaj svedočiv kaj si akava Čhavo e Devlesko.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Thejara đes o Jovano palem sas okote pire duje učenikonenca. ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Kana dikhla e Isuse sar naćhelas okotar, phendas: “Ake o Bakhroro e Devlesko!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Kana okola duj učenikurja ašundine so phendas, teljardine palo Isus. ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","O Isus bolda pe thaj dikhla len kaj džan pale leste, thaj phučla len: “So kamen?” Von phendine lešće: “Rabbi” (so značil – Učiteljina) “kaj trajis?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Vo phendas lenđe: “Aven thaj dićhen.” Von đeline thaj dikhline kaj trajilas thaj godova đes ačhiline leste. Sas varekaj katar e štar saturja mismere. ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jek katar akala duj džene save ašundine e Jovane thaj teljardine palo Isus sas o Andrija, o phral katar o Simon Petar. ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Vo odma arakhlas pire phrales e Simone thaj phendas lešće: “Arakhlam e Mesija” (so značil – e Hristo). ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Thaj andas e Simone ko Isus. O Isus dikhla pe leste thaj phendas: “Tu san Simon, čhavo e Jovanesko. Akhareja tu Kifa” (so značil – Petar – “baro bar”). ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Thejara o đes o Isus odlučisarda te džal ande regija Galileja. Arakhlas e Filipe thaj phendas lešće: “Teljar pale mande.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","O Filip sas andar e Vitsaida, andar e Andrijasko thaj e Petresko gav. ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","O Filip arakhlas e Natanaile thaj phendas lešće: “Arakhlam okoles pale savo ramolas o Mojsije ando Zakono thaj pale kaste ramonas e prorokurja. Godova si o Isus, čhavo e Josifesko, andar o gav Nazaret.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","O Natanail phučla: “Šaj li vareso lačhe te avel andar o Nazaret?” A o Filip phendas lešće: “Av thaj dik.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","O Isus dikhla e Natanaile sar avel leste, thaj phendas pale leste: “Ake o pravo Izraelco ande savo naj hohaipe!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","O Natanail phučla les: “Katar pindžares man?” A o Isus phendas lešće: “Dikhlem tut dok sanas još tale smokva, majsigo nego so o Filip akharda tut.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Pe godova o Natanail phendas lešće: “Rabi, tu san Čhavo e Devlesko! Tu san o Caro e Izraelosko!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","O Isus phendas lešće: “Paćas andar godova kaj phendem tuće kaj dikhlem tut tale smokva! Dićheja vi majbare stvarja katar akala.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Askal phendas: “Čače, čače phenav tumenđe: dićhena putardo o nebo thaj e Devlešće anđelen sar den ando nebo thaj fuljen po Čhavo e Manušesko.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","O trito đes sas e svaturja ando gav Kana Galilejaći. Okote sas e Isusešći dej, ");
INSERT INTO rmyChergash_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","a pe svaturja sas akharde vi o Isus thaj lešće učenikurja. ");
INSERT INTO rmyChergash_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Kana nas len majbut mol, e Isusešći dej phendas lešće: “Najlen majbut mol.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","A o Isus phendas laće: “Drago manušnjije, so si man tusa? Još či avilo mungro časo!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Lešći dej phendas e slugenđe: “Ćeren sa so phenel tumenđe.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","A okote sas šov bare barune ćupurja palo paj, saven e Židovurja koristinas palo obredno thoipe. Thaj ande svako lendar šaj ačhelas katar ohtovardeš dži ke šel thaj biš litre. ");
INSERT INTO rmyChergash_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","O Isus phendas e slugenđe: “Pheren e ćupurja e pajesa!” Thaj von pherdine len dži ko vrho. ");
INSERT INTO rmyChergash_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Askal phendas lenđe: “Akana len cara thaj inđaren ko manuša savo si zadužime palo habe thaj pipe.” Thaj von ćerdine gajda. ");
INSERT INTO rmyChergash_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","O manuš probisarda o paj savo postanisardas mol, ali či džanglas katar si. Godova džangline samo e sluge save line o paj. O manuš askal akhardas e džamutre ");
INSERT INTO rmyChergash_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","thaj phendas lešće: “Svako manuš prvo inkalel e majlačhi mol, a kana e gosturja maton, askal e majslabo mol. A tu araćhejas e lačhi mol sa dži akana.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Gajda o Isus piro prvo čudesno znako ćerda ande Kana Galilejaći thaj javno sikadas piri slava, pa lešće učenikurja paćaine ande leste. ");
INSERT INTO rmyChergash_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Pale godova o Isus đelo pire dejava, phralenca, thaj e učenikonenca ando gav Kafarnaum, kaj ačhiline varesave đesa. ");
INSERT INTO rmyChergash_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Paše sas o židovsko prazniko Pasha, pa o Isus đelo ando Jerusalim. ");
INSERT INTO rmyChergash_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ande hramošći avlija arakhlas e trgovcen save bićinenas e guruven, bakhren thaj e golubonen. Okote arakhlas vi e menjačen sar bešen thaj menjin e love. ");
INSERT INTO rmyChergash_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","O Isus ćerda bičo katar e dori thaj trada sa e trgovcen andar o Hramo, zajedno e bakhrenca thaj e guruvenca, a e menjačenđe rspisardas e love thaj prevrnisardas lenđe sinije, ");
INSERT INTO rmyChergash_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","a okolenđe kaj bićinenas e golubonen phendas: “Inđaren gadava akatar thaj na ćeren pijaca katar o ćher mungre Dadesko.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Lešće učenikurja askal dine pe gođi kaj si ramome ando Sveto lil: “Hala man e revnost pale ćiro ćher.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Askal varesave katar e Židovske vođe phučline les: “Save čudesne znakova dokažija amenđe kaj si tu pravo te ćeres godova?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","A o Isus phendas lenđe: “Haraven akava hramo thaj me palem vazdava les pale trin đes.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","A e Židovurja phendine: “Akava Hramo vazdelas pe štarvardeš thaj šov brš, a tu vazdeja les pale trin đes?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ali o hramo pale savo o Isus phenelas sas lesko telo. ");
INSERT INTO rmyChergash_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kana uskrsnisardas andar e mule, lešće učenikurja dine pe gođi ke godola alava thaj paćajine ande okova so ramolas ande Svete lila thaj ande alava save o Isus phendas. ");
INSERT INTO rmyChergash_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Dok o Isus sas ando Jerusalim ande vrjama kana sas o prazniko Pasha, but džene paćajine ande leste kaj dikhline e čudesne znakurja save ćerelas. ");
INSERT INTO rmyChergash_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ali korkoro o Isus či paćalas lenđe kaj sa pindžarelas len. ");
INSERT INTO rmyChergash_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Khonikal či trubujas te phenel lešće sošće si kaj pindžarelas e manušengo ilo. ");
INSERT INTO rmyChergash_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Varesavo ugledno manuš, savo akhardolas Nikodem, sas fariseji thaj jek katar e vodeće manuša maškar e Židovurja. ");
INSERT INTO rmyChergash_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Vo avilo ko Isus raćava thaj phendas lešće: “Učiteljina, džanas kaj san tu učitelj saves o Del bičhaldas. Kaj khonik našti ćerel kasave čudesne znakurja save tu ćeres, a te o Del naj lesa.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","A o Isus phendas lešće: “Čače, čače phenav tuće: ako o manuš či bijandol palem, našti dićhel e Devlesko carstvo.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","O Nikodem phučla les: “Sar šaj o manuš te bijandol kana si već phuro? Našti valda, po dujto data te del ando đi pire dejako thaj palem te bijandol?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","O Isus phendas lešće: “Čače, čače phenav tuće: ako o manuš či bijandol katar o paj thaj katar o Duho, našti del ande Devlesko carstvo. ");
INSERT INTO rmyChergash_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","So si bijando e manušestar – manuš si, a so si bijando e Duhostar – duho si. ");
INSERT INTO rmyChergash_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Na čudisar tut kaj phendem kaj trubun palem te bijandon. ");
INSERT INTO rmyChergash_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","E balval phurdel kaj kamel. Ašunes lako šumo, ali či džanes katar avel niti kaj džal. Gajda si svakonesa savo si bijando katar o Duho.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","A o Nikodem phučla e Isuse: “Sar šaj godova te avel?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","O Isus phendas lešće: “Tu san poštuime učitelj ando Izrael, a godova či džanes? ");
INSERT INTO rmyChergash_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Čače, čače phenav tuće: phenas okova so džanas, thaj svedočisaras pale okova so dikhlam, ali tumen či prihvatin amaro svedočanstvo. ");
INSERT INTO rmyChergash_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ako či paćan manđe kana phenav tumenđe pale stvarja save si pe phuv, sar paćana kana phenav tumenđe pale stvarja save si po nebo? ");
INSERT INTO rmyChergash_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Kaj nikad khonik či đelo po nebo thaj bolda pe osim o Čhavo e Manušesko savo fuljisto katar o nebo. ");
INSERT INTO rmyChergash_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Thaj sago kaj o Mojsije ande pustinja vazdas pe rovlji e sapes katar e bronza, gajda moraš te avel vazdino vi o Čhavo e Manušesko, ");
INSERT INTO rmyChergash_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","te svako savo paćal ande leste avel les večno trajo.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kaj, o Del gadići volilas akava them kaj dija pire jedino bijande Čhave te ko god paćal ande leste, či propadnil, nego te avel les večno trajo. ");
INSERT INTO rmyChergash_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kaj o Del či bičhaldas pire Čhaves po them te sudil e themešće, nego te o them spasil pe kroz leste. ");
INSERT INTO rmyChergash_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ko paćal ande leste, naj osudime, a ko či paćal već si osudime, kaj či paćaja ando alav e jedino bijande Devlešće Čhavesko. ");
INSERT INTO rmyChergash_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","A pale akava sudilpe lenđe kaj o svetlo avilo po them, ali o them volilas e tama umesto o svetlo, kaj lenđe dela sas bilačhe. ");
INSERT INTO rmyChergash_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ko god ćerel bilačhipe, mrzil o svetlo thaj či inkljel po svetlo, te lešće dela či inkljen po videlo. ");
INSERT INTO rmyChergash_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","A ko ćerel so si čačipe, inkljel po svetlo te sikadon pe kaj si lešće dela ćerde kroz o Del. ");
INSERT INTO rmyChergash_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Pale godova o Isus đelotar pire učenikonenca ande Judejske gava. Okote ačhilo lenca thaj bolelas. ");
INSERT INTO rmyChergash_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","A o Jovano isto bolelas ando than Enon, paše ko gav Salim, kaj okote sas but paj thaj e manuša avenas thaj bolenas pe. ");
INSERT INTO rmyChergash_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","O Jovano askal još nas čhudino ande tamnica. ");
INSERT INTO rmyChergash_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","A maškar e Jovanošće učenikurja thaj varesavo aver Židovo avilo dži ke čingara zbog o obredno thoipe. ");
INSERT INTO rmyChergash_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Askal e učenikurja avile ko Jovano thaj phendine lešće: “Učiteljina, okova kaj sas tusa pe istočno rig katar e reka Jordan, pale savo tu svedočisardan, eke bolel e manušen thaj savora džan leste umesto amende.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","A o Jovano phendas: “Khonik našti ćerel khanči, ako godova naj lešće dino katar o Del. ");
INSERT INTO rmyChergash_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Tumen korkoro sen mungre svedokurja kaj phendem: ‘Me naj sem o Hristo, nego bičhaldo sem angle leste.’ ");
INSERT INTO rmyChergash_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Pe svaturja samo o džamutro ženil pe, a o ćirvo, savo ažućarel thaj čhol kan, pherdo si bah dok ašunel e džamutresko glaso. Askal godoja bah si mungri thaj akana si potpuno. ");
INSERT INTO rmyChergash_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Vo trubul te avel sa majbaro, a me sa majcikno.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Okova savo avel opral, pe savorende si; a okova savo si katar akaja phuv, pripadil e phuvjaće, thaj ćerel svato pale akale phuvjaće stvarja. Ali okova savo avel andar o nebo, pe savorende si. ");
INSERT INTO rmyChergash_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Vo svedočil pale okova so dikhla thaj so ašundas, ali khonik či prihvatil lesko svedočanstvo. ");
INSERT INTO rmyChergash_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ko prihvatil lesko svedočanstvo, potvrdil kaj si o Del čačutno. ");
INSERT INTO rmyChergash_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Okoles saves o Del bičhaldas, e Devlešće alava mothol, kaj o Del del les Duho ando izobilje. ");
INSERT INTO rmyChergash_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","O Dad volil e Čhaves thaj sa dija ande lešće vas. ");
INSERT INTO rmyChergash_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ko paćal ando Čhavo, si les večno trajo, a okova savo naj paćivalo e Čhavešće, či primila večno trajo, nego pe leste ačhel e Devlešći holji. ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Kana o Isus saznaisarda kaj e fariseja ašundine kaj vo pridobil thaj bolel majbut učenikonen nego o Jovano ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","– vi ako korkoro o Isus či bolelas, nego lešće učenikurja – ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","đelotar andar e Judeja thaj bolda pe ande Galileja. ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Po drom karingal e Galileja moraš te nakhlas kroz e Samarija. ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Gajda avilo ando Samarijansko gav savo akhardol Sihar, paše phuv savi o Jakov dija pire čhavešće e Josifešće. ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Okote sas vi e Jakovešći haing. O Isus sas umorno katar o drom thaj bešlo paše haing. Godova sas varekaj katar o mismeri. ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Kana varesavi manušnji savi sas Samarijanka avili te astarel o paj, o Isus phendas laće: “De man te pijav”, ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","kaj lešće učenikurja već majsigo đele ando gav te ćinen hamasko. ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","E manušnji phendas lešće: “Zar tu, Židovo, manđes paj mandar savi sem Samarijanka?” E Židovurja či družinaspe e manušenca andar e Samarija. ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Pe godova o Isus phendas laće: “Kana samo džanglanas e Devlesko daro thaj ko si okova savo phenel tuće: ‘De man te pijav’, zamolisardanas man, thaj me dijemas tut paj savo del trajo.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","A e manušnji phendas lešće: “Gospodarina! Pa tut naj čak ni sova te astares o paj, a e haing si handuk. Katar tut askal džudo paj? ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Dali gndis kaj san tu majbaro katar amaro pradad o Jakov, savo dija amen akaja haing thaj pilas andar late vo, lešće čhave thaj lešći stoka?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","A o Isus phendas laće: “Ko god pijel katar akava paj palem trušavola. ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","A ko pijela o paj savo me dava les, nikada majbut či trušavola. O paj savo me dava les postanila ande leste o izvori e pajesko savo anela lešće večno trajo.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","A e manušnji phendas lešće: “Gospodarina, de vi man godova paj pa te ni me majbut či avav trušali thaj te naj moraš te avav akaring palo paj!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","O Isus phendas laće: “Dža thaj akhar ćire romes, pa bolde tut akaringal.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","A e manušnji phendas lešće: “Naj man rom”. A o Isus phendas laće: “Lačhe phendan: ‘Naj man rom.’ ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Kaj sas tut pandž roma, a okova saveja san akana naj ćiro rom.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","E manušnji phendas lešće: “Gospodarina, dikhav kaj san proroko! ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Amare samarijanske pradada klanjinaspe e Devlešće pe akaja gora, a tumen e Židovurja phenen kaj trubul te klanjilpe lešće ando Jerusalim.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","O Isus phendas laće: “Paća manđe manušnjije, kaj avela e vrjama kana či klanjina tumen e Devlešće samo pe akaja gora ni samo ando Jerusalim. ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Tumen e Samarijancurja či džanen kašće klanjin tumen, a amen e Židovurja džanas kašće te klanjimen kaj o spasenje avel katar e Židovurja. ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ali avel e vrjama thaj već si akate – kana okola save čače klanjinpe, klanjinape e Dadešće ando duho thaj ando čačipe, kaj o Dad o Del baš kasave klaniteljen kamel. ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","O Del si Duho thaj okola save klanjinpe lešće, trubun ando duho thaj ando čačipe te klanjinpe lešće.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","E manušnji phendas: “Džanav kaj avela o Mesija, savo akhardol Hristos. Kana vo avela sa objasnila amenđe.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","A o Isus phendas laće: “Godova sem me, savo ćerav svato tusa.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Pe godova boldine pe lešće učenikurja, thaj začudisajle kaj o Isus ćerel svato e manušnjasa. Ali khonik či phučla les: “So rodes latar?” ili “Sostar ćeres lasa svato?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Askal e manušnji mukla piro ćupo, đeli ando gav thaj phendas savorenđe: ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Aven te dićhen e manuše savo phendas manđe sa so ćerdem. Te naj li vo o Hristo?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","E manuša teljardine andar o gav te dićhen e Isuse. ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Pale godoja vrjama e učenikurja molisardine e Isuse: “Učiteljina, ha vareso!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","A vo phendas lenđe: “Man si habe pale savo tumen khanči či džanen.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Askal e učenikurja phendine jek avrešće: “Dali vareko andas lešće vareso te hal?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","A o Isus phendas lenđe: “Mungro habe si te ćerav e volja okolešći savo bičhalda man thaj te završiv o zadatko savo poverisarda manđe. ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Zar tumen či phenen: ‘Još štar čhon thaj ake e žetva?’ A me phenav tumenđe: putren e jakha thaj dićhen kaj si e manuša sago e njive! Već si paće pale žetva. ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Okova savo ćidel o điv već primil e poćin thaj ćidel o plodo, a o plodo si e manuša save dobina večno trajo, te o sejači thaj vi okova savo ćidel o điv zajedno radujin pe. ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Čači si e izreka savi phenel: ‘Jek sijol, a o dujto ćidel o plodo.’ ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Me bičhaldem tumen te ćiden okova oko soste tumen či trudisajle. Aver trudisajle, a tumen ćidine e plodurja lenđe trudosko.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","E but Samarijancurja andar godova gav paćajine ando Isus zbog e alava e manušnjaće savi svedočisarda: “Phendas manđe sa so ćerdem.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Kana e manuša andar e Samarija aviline leste, zamolisardine les te ačhel lende. Thaj okote ačhilo duj đes. ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Askal još majbut paćaine lešće zbog lešće alava. ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","A e manušnjaće phendine: “Akana paćas kaj vi korkoro ašundam les sar ćerel svato, a na zbog o okova so tu phendan amenđe. Džanas kaj si vo čače Spasitelj e themesko.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Pale duj đes, o Isus đelotar lendar thaj zaputisajlo ande Galileja. ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","O Isus već majsigo svedočilas pale godova kaj e proroko či poštuin ande ando than kaj bajrilo. ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Kana areslo ande Galileja, e manuša andar e Galileja šukar primisardine les, ali samo zato kaj dikhline sa e čudurja save ćerda ando Jerusalim pale vrjama kana sas o prazniko Pasha, kaj vi von sas okote. ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","O Isus palem đelo ando gav Kana ande regija e Galilejaći, kaj pretvorisardas o paj ande mol. A cara majdur ando gav Kafarnaum sas jek caresko službeniko savesko čhavo pašljolas nasvalo. ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Kana ašundas kaj o Isus avilo andar e Judeja ande Galileja, avilo dži leste thaj zamolisarda les te džal ando Kafarnaum thaj sastarel lešće čhaves, kaj si po meripe. ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","A o Isus phendas lešće: “Kasave sen tumen e manuša! Dok či dićhen e znakurja thaj e čudurja, či paćan.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","E caresko službeniko phendas lešće: “Gospode, moliv tut, av majsigo nego so mungro čhavo merel!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","O Isus phendas lešće: “Dža ćhere, ćiro čhavo trajila.” O manuš paćaja ande okova so o Isus phendas lešće thaj đelotar. ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Dok sas još po drom, angle leste aviline lešće sluge thaj phendine lešće: “Ćiro čhavo si džudo thaj sasto.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Vo phučla len kana lešće čhavešće teljardas te avel majlačhe, a von phendine lešće: “E groznica mukla les araći varekaj katar jek sato mismere.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","E čhavesko dad dija pe gođi kaj baš ande godoja vrjama o Isus phendas lešće: “Ćiro čhavo avela džudo thaj sasto.” Thaj askal paćaja ando Isus – vo thaj vi savora save trajinas lesa ando ćher. ");
INSERT INTO rmyChergash_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Godova sas dujto čudesno znako savo o Isus ćerda sar avilo andar e Judeja ande Galileja. ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Posle akava, o Isus đelo opre ando Jerusalim po židovsko prazniko. ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ando Jerusalim, ke Bakhrani kapija, sas bazeno savo pe židovsko čhib akhardolas Vitezda. Okote sas pandž terase. ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Tale godola terase pašljonas but nasvale manuša: kore, banđe thaj paralizime. Ažućarenas te o paj zatalasil pe, ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","kaj o anđelo e Gospodesko, fuljelas ando bazeno ande određeno vrjama thaj talasilas o paj. O prvo manuš savo nakon godova dija sas ando paj sastilosas katar bilo savo nasvalipe. ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","A sas okote jek manuš savo sas bango trijanda thaj ohto brš. ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Kana o Isus dikhla les sar pašljol thaj džanelas kaj već lungo vrjama si nasvalo, phučla les: “Kames te aves sasto?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","O nasvalo phendas lešće: “Gospode, naj man khonik te mućel man ando bazeno kana o paj lel te talasilpe. Dok me avav dži inća, vareko aver del andre majsigo mandar.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","O Isus phendas lešće: “Ušti, le ćiri nosilja thaj phir!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","O manuš odma sastilo, lijas piri nosilja thaj ačhilo te phirel. A godova đes sas o savato. ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Pa e židovske vođe phendine e sastile manušešće: “Ađes si o savato, thaj naj tuće muklo te inđares ćiri nosilja!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Vo phendas lenđe: “Okova savo sastarda man phendas manđe: ‘Le ćiri nosilja thaj phir!’ ” ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","A von phučline les: “Ko si o manuš savo phendas tuće: ‘Le ćiri nosilja thaj phir!’?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","O sastilo manuš či džanglas ko sas godova kaj sastarda les, kaj o Isus hasajlo lestar maškar o but o them savo sas pe godova than. ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Majkasnije o Isus arakhlas e sastile manušes ande hramošći avlija thaj phendas lešće: “Ake, sastilan. Na ćer majbut bezeh, te na avel tuće vareso još majgore.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Askal o manuš đelotar thaj mothodas e Židovske vođenđe kaj si o Isus okova savo sastarda les. ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Andar godova kaj ćerda gajda vareso ando savato, e Židovske vođe počnisardine te progonin e Isuse. ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","A o Isus phendas lenđe: “Mungro Dad stalno ćerel bući, gajda vi me slediv lesko primer.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Andar godova e Židovske vođe još majbut kamenas te mudaren les, kaj či prekršisardas samo o zakon ando savato nego vi e Devles akhardas pire Dadesa thaj gajda ćerelas pe kaj si jednako e Devlesa. ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","A o Isus phendas lenđe: “Čače, čače phenav tumenđe: O Čhavo korkoro pestar našti ćerel khanči; vo ćerel samo okova so dikhla kaj o Dad ćerel. So o Dad ćerel godova isto ćerel vi o Čhavo. ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Kaj o Dad volil e Čhaves thaj sikavel lešće sa so ćerel. A sikavela lešće vi majbare dela katar akala thaj čudina tumen. ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kaj, sago kaj o Dad vazdel e mulen thaj del len trajo, gajda vi o Čhavo del trajo kašće vo kamel. ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Kaj o Dad či sudil khonikašće, nego dijas e Čhave pravo te sudil svakonešće, ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","te savora poštujin e Čhaves sago kaj poštujin e Dade. Ko či poštuil e Čhave, či poštuil ni e Dade, savo bičhalda les. ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Čače, čače phenav tumenđe, svako savo ašunel mungre alava thaj paćal okolešće savo bičhalda man, si les večno trajo, thaj či avela osudime, nego već nakhla andar o smrto ando trajo. ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Čače, čače phenav tumenđe: avel o časo thaj već avilo, kana e mule ašunena o glaso e Devlešće Čhavesko, thaj save ašunen les, godola trajina. ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Sago kaj e Dade si trajo ande peste, gajda vi e Čhavešće dijas te ave les trajo ande peste. ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Thaj dija les vlast te sudil, kaj si vo o Čhavo e Manušesko. ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Na čudin tumen godolešće. Kaj, avel e vrjama kana sa e mule ande limorja ašunena o glaso e Devlešće Čhavesko, ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","thaj inkljena andar pire limorja. Okola save ćerenas lačhipe, uštena thaj primina večno trajo, a okola save ćerenas bilačhipe uštena thaj primina osuda. ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Me korkoro mandar našti ćerav khanči, me sudiv gajda sar ašunav katar o Dad. Mungro sudo si pravedno kaj či rodav te ćerav mungri volja, nego e volja okolešći savo bičhalda man.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Ako me svedočiv korkoro pale mande, mungro svedočanstvo naj dovoljno. ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Vareko aver svedočil pale mande thaj me džanav kaj okova so vo svedočil pale mande si dovoljno. ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Tumen bičhaldine e manušen ko Jovano savo bolelas, a vo svedočisardas tumenđe o čačipe. ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Manđe či trubul svedočanstvo e manušestar, nego mothav tumenđe akava palo Jovano te spasin tumen. ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","O Jovano sas svetiljka savi phabolas thaj svetlilas, a tumen kamline pe harni vrjama te uživin ande lesko svetlo. ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ali man si svedočanstvo pale mande majbaro katar e Jovanesko: e dela save ćerav. O Dad dija man te ćerav len thaj von svedočin pale godova kaj o Dad bičhalda man. ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Thaj vi o Dad savo bičhalda man svedočil pale mande. Lesko glaso nikad či ašundine, niti dikhline lesko liko. ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Lesko alav naj ande tumende kaj či paćan okolešće saves vo bičhalda. ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Tumen sićon e Svete lila, kaj gndin kaj kroz lende si tumen večno trajo, a godola lila svedočin pale mande. ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","A tumen ipak či kamen te aven mande te avel tumen večno trajo. ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Me či prihvativ slava e manušendar. ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ali pindžarav tumen thaj džanav kaj naj tumen ande tumende e Devlešći ljubav. ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Me avilem ando alav mungre Dadesko, ali tumen či prihvatin man. Ako vareko avel ande piro alav, les prihvatin. ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Sar paćana kana prihvatin slava jek avrestar, a či roden slava e jedino Devlestar? ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Na gndin kaj me prva tumen anglo Dad. Tumen prl o Mojsije, ande savo uzdin tumen. ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kaj te paćainesas e Mojsijašće, paćainesas vi manđe, kaj vo pale mande ramolas. ");
INSERT INTO rmyChergash_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","A pošto či paćan ande okova so vo ramosarda, sar paćana ande mungre alava?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Pale godova o Isus bolda pe ande Galileja pa đelo pe istočno rig katar o Galilejsko jezero, (savo akhardol vi Tiverijadsko jezero). ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","A pale leste teljardas o silno o them, kaj dikhline e čudesne znakurja save ćerda kana sastardas e nasvalen. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","A o Isus lijapes opre pe gora thaj okote bešlo pire učenikonenca. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","A avelas paše e Pasha o židovsko prazniko. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Kana o Isus vazda pire jakha thaj dikhla e silno themes sar avel leste, phučlas e Filipe: “Kaj šaj te ćinas mangro pale sa akala manuša te han?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Godova phendas te probil les, kaj već džanglas so ćerela. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","A o Filip phendas lešće: “Ni duj šela rupune lovora či avilosas dosta te ćinel pe dosta mangro te svako dobil barem kotororo!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","A jek aver učeniko savo akhardolas Andrija, o phral katar o Simon Petar, phendas e Isusešće: ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Akate si jek čhavro saves si pandž mangre katar o ječam thaj duj mačhora. Ali so si godova pale gadići them?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","O Isus phendas lenđe: “Neka o them bešel tele!” Pe godova than sas but čar, pa e manuša bešline. Sas okote varekaj katar pandž milje muškarcurja. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Askal o Isus lijas godola mangre, zahvalisarda e Devlešće thaj podelisardas e themešće save bešenas pe čar. A gajda ćerda vi e mačhenca, thaj savora haline kozom kamline. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Kana savora čaljile, o Isus phendas pire učenikonenđe: “Ćiden e kotorora save ačhiline, te khanči či propadnil.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Gajda e učenikurja ćidine dešuduj korpe kotorora save ačhiline katar okola pandž ječmene mangre save o them halas. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Kana o them dikhla o čudesno znako savo o Isus ćerda, phendine: “Akava si čače o Proroko savo trubul te avel po them!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","A o Isus džanglas kaj kamen te aven, te astaren les thaj pe sila te čhonle te avel lengo caro, pa palem crda pe ande gora te avel korkoro. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kana peli e rjat, e Isusešće učenikurja fuljistine dži ko jezero. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ali sar peli e rjat, a o Isus još či bolda pe, dine andre ande lađica thaj teljardine pe okoja rig e jezerošći, karingal o Kafarnaum. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Phurdelas e bari balval thaj vazdenas pe e bare talasurja. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Kana e učenikurja otplovisardine varekaj katar pandž dži ke šov kilometrja katar e obala, dikhline e Isuse sar phirel po paj thaj avel sa majpaše ke e lađica, a len astarda dar. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","A o Isus phendas lenđe: “Me sem! Na daran!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Askal line les ande lađica, thaj e lađica ande data arakhadili pe obala prema savi plovinas. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Thejara o đes o them savo ačhilo pe okoja rig e jezerošći primetisardine kaj si pe okoja rig samo jek lađica thaj kaj o Isus či dijas ande lađica pire učenikonenca, nego kaj von đeletar korkore. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","A varesave lađice andar e Tiverijada avile paše dži ke okova than kaj haline o mangro nakon so o Gospod zahvalisarda e Devlešće. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Kana o them dikhla kaj ni o Isus a ni lešće učenikurja naj okote, dine ande lađice thaj teljardine ando Kafarnaum te roden e Isuse. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Kana arakhline les pe okoja rig e jezerošći, phučline les: “Učiteljina, kana avilan akate?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","A o Isus phendas lenđe: “Čače, čače phenav tumenđe: Či roden tumen man zbog godova kaj haćardine e čudesne znakurja, nego zbog o mangro savo haline thaj čaljile. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ćeren bući, ali na palo habe savo si propadljivo, nego ćeren bući palo habe savo ačhel palo večno trajo, a les dela tumen o Čhavo e manušesko, kaj les ovlastisardas o Dad o Del.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Von phučline les: “So trubul te ćeras, a te avel okova so o Del kamel te ćeras?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","A o Isus phendas lenđe: “Akava si o delo savo o Del kamel te ćeren: te paćan ande okova saves vo bičhaldas.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Von askal phučline les: “Savo tu čudesno znako ćereja, te kana dikhas les paćas ande tute? So dakle ćereja? ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Amare pradada haline mangro ande pustinja savo akhardolas mana, sago kaj si ramome ando Sveto lil: ‘Dija len mangro andar o nebo te han.’” ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","O Isus phendas lenđe: “Čače, čače phenav tumenđe. Či dija tumen o Mojsije mangro andar o nebo, nego mungro Dad, a akana del tumen o čačutno mangro andar o nebo. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kaj, o mangro savo del o Del si o okova savo avel andar o nebo thaj del trajo e themešće.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Askal phendine lešće: “Gospode, de amen uvek godova mangro.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","A o Isus phendas lenđe: “Me sem o mangro e trajosko. Ko avel mande, či bokhavola thaj ko paćal ande mande nikada či trušavola. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ali sago kaj phendem tumenđe, dikhline man, ali ipak či paćan. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Sa saven o Dad del man, avena mande, a okolen save aven mande či odbaciva. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kaj, či fuljistem andar o nebo te ćerav mungri volja, nego e volja okolešći savo bičhalda man. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","A akava si e volja okolešći savo bičhalda man: te či hasarav ni jećhe katar okola saven vo dija man, nego te vazdav len andar e mule ando Poslednjo đes. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kaj, akava si e volja mungre Dadešći: ko god dićhel man, e Čhave thaj paćal ande mande, te avel les večno trajo thaj te me vazdav les andar e mule ando Poslednjo đes.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Askal e Židovurja počnisardine te mrmljin protiv o Isus zato kaj phendas: “Me sem o mangro savo fuljisto andar o nebo.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Phenenas: “Zar godova naj o Isus, e Josifesko čhavo? Zar či pindžaras lešće dade thaj lešće deja? Sar akana phenel: ‘Fuljistem andar o nebo’?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Pegodova o Isus phendas lenđe: “Na mrmljan maškar tumende! ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Khonikal našti avel mande ako či crdel les o Dad savo bičhalda man, a me vazdava len andar e mule ande Poslednjo đesa. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","E prorokurja ramosardine: ‘O Del sikavela sa e themen.’ Svako ko čhol kan ko Dad thaj sićol lestar, avel mande. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ipak, khonikal či dikhla e Dade, osim okova savo avilo katar o Del. Vo dikhla e Dade. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Čače, čače phenav tumenđe: ko paćal ande mande, si les večno trajo. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Me sem o mangro e trajosko. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Tumare pradada haline e mana ande pustinja thaj ipak muline. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","A akava si o mangro savo fuljel andar o nebo te kogod hal lestar či merel. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Me sem o džudo mangro savo fuljisto andar o nebo. Ko hala katar akava mangro, trajila zauvek. O mangro savo me dava si mungro telo, savo dava te e manuša po them šaj trajin.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Askal e Židovurja počnisardine maškar peste te raspravin pes e alavenca: “Sar akava šaj del amen piro telo te has?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","O Isus phendas lenđe: “Čače, čače phenav tumenđe, ako či han o telo e manušešće Čhavesko thaj či pijen lesko rat, naj tumen večno trajo ande tumende. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ko hal mungro telo thaj pijel mungro rat, si les večno trajo thaj me vazdava les andar e mule ando Poslednjo đes. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kaj mungro telo si čačo habe thaj mungro rat čačo pipe. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ko hal mungro telo thaj pijel mungro rat, ačhel ande mande thaj me ačhav ande leste. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Sago kaj man bičhaldas o džudo Dad, thaj me trajiv zbog o Dad, gajda vi okova savo man hala trajila zbog mande. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Akava si o mangro savo fuljisto andar o nebo, thaj vo naj sago okova saves haline tumare pradada ande pustinja thaj muline. Ko hal akava mangro, trajila zauvek.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Akava o Isus phendas dok sikavelas ande sinagoga ando Kafarnaum. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Kana akava ašundine, but lešće učenikurja phendine: “Phare si akala alava. Ko šaj prihvatil len?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","O Isus korkoro pestar džanglas kaj lešće učenikurja mrmljin thaj phendas lenđe: “Dali akava sikavipe navodil tumen te odustanin? ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","A so phendinesas kana dikhline sas man, e Čhave e manušešće sar džav opre ando nebo, okote kaj semas vi majsigo? ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","O Duho e Devlesko si okova savo del o trajo, a o telo našti te del les. E alava save me phendem tumenđe, von si o Duho thaj o trajo. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ali si maškar tumende okola save či paćan manđe.” O Isus katar o početko džanglas save si okola save či paćana thaj savo si okova savo izdaila les. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Askal phendas: “Pale godova vi phendem tumenđe kaj khonik našti avel mande ako naj lešće dino katar o Dad.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Askal but lešće učenikurja mukline les thaj či majbut džanas pale leste. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Askal o Isus phučlas e dešuduje učenikonen: “Te či kamen vi tumen te džantar?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","A o Simon Petar phendas lešće: “Gospode, kaste te džas? Samo tut si alava palo večno trajo. ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Amen paćas thaj džanas kaj san tu o Sveco e Devlesko!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","A o Isus phendas lenđe: “Zar či me losardem tumen dešudujen? A palem jek tumendar si o beng.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","O Isus phendas godova palo Juda savo sas čhavo e Simonesko andar o gav Kariot, kaj vo sas godova savo izdaila les, vi ako sas jek katar e dešuduj učenikurja. ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Posle godova o Isus phirelas pe regija e Galilejaći. Či kamlas te džal ande Judeja, kaj e židovske vođe rodenas prilika te mudaren les. ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ali kana avilo paše o židovsko Prazniko senica, ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","e Isusešće phral phendine lešće: “Muk e Galileja thaj dža ande Judeja, te ćire učenikurja dićhen e čudurja save ćeres. ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Khonik ko kamel te avel pinđardo, či garavel okova so ćerel. Kana već sa godova ćeres, sikav tut e themešće.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Kaj čak ni lešće phral či paćanas ande leste. ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","A o Isus phendas lenđe: “Mungri vrjama još či avili, ali tumen šaj džan kana kamen kaj svako vrjama pale tumende si lačhi. ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Tumen o them našti mrzal, ali man mrzal andar godova kaj me phenav e manušenđe ande akava them kaj si lenđe dela bilačhe. ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Tumen džan po prazniko, a me još či džava inća, kaj još či pherdili mungri vrjama.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Godova o Isus phendas thaj ačhilo ande Galileja. ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ali kana lešće phral đele po prazniko, đelo vi vo pale lende, ali na javno nego tajno. ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","A e židovske verske šorvale rodenas e Isuse po prazniko thaj stalno phučenas e themes: “Dali vareko dikhla les?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","A maškar o them but ćerelas pe svato pala leste. Gajda varesave phenenas: “Lačho si!” A aver palem phenenas: “Naj lačho, nego zavodil e themes.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ali khonik, či tromalas javno te ačhel pe lešći rig kaj daranas katar e židovske verske šorvale. ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","A kana već nakhlas o opaš prazniko o Isus đelo ando Hramo thaj ačhilo te sikavel themes. ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Askal e Židovurja začudisajle thaj phendine: “Katar akava džanel e Svete lila, a či sićolas andar lende?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","O Isus askal phendas lenđe: “Akava sikavipe či avel mandar, nego katar okova savo bičhalda man. ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ko kamel te ćerel okova so o Del kamel, džanela dali akava sikavipe avel katar o Del ili me ćerav svato korkoro mandar. ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ko ćerel svato korkoro pale peste, pešće rodel slava. A ko rodel slava pale okova savo bičhalda les, vo si pošteno thaj ande leste naj nepravda. ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Či li o Mojsije dija tumen o Zakono? A palem khonik tumendar či postupil po Zakono. Sostar kamen te mudaren man?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","O them phendas lešće: “O bilačho duho dijas ande tute! Ko kamel te mudarel tut?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","A o Isus phendas lenđe: “Ćerdem jek čudo thaj savora čudin tumen. ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ali vi tumen ćeren bući ando savato kana obrezin e manušes sago kaj phendas tumenđe o Mojsije. Godova običaj si, zapravo, majpurano katar e Mojsijesko Zakono, a avel katar e pradada. ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ako dakle o pravo časo palo obrezanje tumare čhavengo perel ando savato, tumen izvršina o obrezanje te na avel prekršime o Mojsijesko zakono. Sostar askal gaći holjavon pe mande kaj potpuno sastardem okole manuše ando savato. ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Na sudin prema okova so dićhen avrjal, nego sudin pravedno.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Askal varesave manuša andar o Jerusalim ćerenas svato maškar pende: “Naj li akava okova saves kamen te mudaren? ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","A ake, vo javno ćerel svato thaj khonik khanči či phenel lešće. Te či amare šorvale vičače haćardine kaj si vo o Hristo? ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ali amen džanas katar si akava, a kana o Hristo avela, khonik či džanela katar si.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Dok sikavelas e themes ando Hramo, O Isus čhuta muj: “Ej, tumen pindžaren man! Thaj džanen katar sem! Či avilem korkoro mandar. Ali o čačutno si Okova savo bičhalda man, saves tumen či pindžaren. ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","A me pindžarav les, kaj sem lestar thaj vo bičhalda man.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Askal e židovske poglavarja dićhenas te astaren e Isuse, ali khonik či čhuta o vas pe leste, kaj lesko časo još či avilo. ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","A but džene maškar e manuša paćaine ande leste thaj phenenas: “Kana avela o Hristo, zar ćerela majbare čudesne znakurja, nego so ćerda akava?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","E fariseja ašundine so them šapućilaspe palo Isus thaj ando dogovor e šorvale rašajenca bičhaldine e stražaren te astaren e Isuse. ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Askal o Isus phendas: “Još cara vrjama sem tumenca thaj askal džavtar okolešće savo bičhalda man. ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Rodena man, ali či araćhena man, thaj kaj sem me, tumen našti aven.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Askal e židovske vođe phendine maškar pende: “Kaj godova vo kanil te džal, a te amen či arakhasa les? Te či kanil te džal ke Židovurja save trajin rasejime maškar okola kaj naj Židovurja thaj te len sikavel. ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","So gndisardas godolesa kana phendas: ‘Rodena man, ali či araćhena man’ thaj ‘kaj sem me tumen našti aven’?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Poslednjo thaj majvažno đes e praznikosko, o Isus ačhilo anglo them thaj čhuta muj: “Ako si vareko trušalo, neka avel mande thaj neka pijel! ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ko god paćal ande mande, sago kaj phenel o Sveto lil, andar leste poteknina reke džude pajesko.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Akava phendas palo Sveto Duho save sas te primin okola kaj paćanas ando Isus. A o Duho ande godoja vrjama još či fuljisto, andar godova kaj o Isus nas još vazdino ande piri slava. ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Kana varesave manuša andar e bari gomila ašundine akala Isusešće alava, phendine: “Akava si čače o proroko saves ažućaras.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","A aver phenenas: “Akava si o Hristo!” A e trite palem phenenas: “Na, vo našti avel o Hristo! Zar o Hristo avela andar e Galileja? ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Či li phenel o Sveto lil kaj o Hristo avela andar e caresko Davidesko potomstvo, thaj andar o gav Vitlejem, katar sas o David?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Gajda zbog Isus avilo dži ke podela maškar e manuša. ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Varesave kamline te astaren les, ali khonik či čhuta o vas pe leste. ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Askal e stražarja boldine pe ke šorvale rašaja thaj ke fariseja, a von phučline len: “Sostar či andine Isuse?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","A e stražarja phendine lenđe: “Khonik nikada či ćerelas gajda svato sago akava manuš.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","A e fariseja phendine lenđe: “Zar vi tumen diljardas? ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Dali vareko katar e šorvale ili katar e fariseja paćajine ande leste? Či. ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nego, akala manuša si proklete, kaj či pindžaren e Mojsijesko zakono!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Askal phučla len o Nikodem, okova kaj sas majranije ko Isus thaj savo sas jek lendar: ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Zar amaro zakono osudil e manušes majsigo nego so ašunel les thaj utvrdil so ćerda?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","A von phendine lešće: “Dali san vi tu jadno Galilejco? Proučisar thaj dićheja kaj nijek proroko či avel andar e Galileja.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Askal svako đelo pire ćherešće, ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","A o Isus đelo pe Maslinsko Gora, ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","pa detharin palem avilo ando Hramo. Sa o them ćida pes oko leste. Vo bešlo thaj teljarda te sikavel len. ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","A e zakonešće učitelja thaj e fariseja andine jećhe manušnja savi sas astardi ando preljub thaj čhutine lat maškare anglo them. ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Askal phendine e Isusešće: “Učiteljina, akaja manušnji si astardi kana ćerda preljub. ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","O Mojsije ando zakon zapovedisardas amenđe te kasave manušnjen mudaras gajda kaj čhudasa bara pe lende. So tu phenes pe godova?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Godova phučline te iskušin les, sar avilosas len vareso pale soste te optužin les. A o Isus samo banđilo thaj teljarda te ramol vareso e najesa pe phuv. ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ali, sar von vi majdur phučenas les, o Isus uspravisajlo thaj phendas lenđe: “Ko tumendar nikada či ćerda bezeh, neka prvo čhudel o bar pe late.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Askal palem banđilo thaj nastavisarda te ramol pe phuv. ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Kana godova ašundine, teljardine te džantar jek po jek; e majpurane đeletar prve. Po krajo o Isus ačhilo korkoro e manušnjasa savi još uvek ačhelas angle leste. ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Askal o Isus uspravisajlo thaj phučla lat: “Manušnjije, kaj si akala? Zar khonik či osudisarda tut?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","A voj phendas: “Khonik, Gospode.” Askal o Isus phendas laće: “Ni me či osudiva tut. Dža thaj katar akana na ćer majbut bezeh!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","O Isus palem phendas e themešće: “Me sem svetlo e themesko. Ko džal pale mande, nikada majbut či phirela ando tunjariko, nego avela les svetlo e trajosko.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Askal e fariseja phendine lešće: “Tu korkoro pale tute svedočis. Ćiro svedočanstvo naj dovoljno!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","A o Isus phendas lenđe: “Čak vi ako svedočiv korkoro pale mande, mungro svedočanstvo si dovoljno, kaj džanav katar avilem thaj kaj džav. A tumen či džanen katar avilem ni kaj džav. ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Tumen sudin pe manušenđi mera, a me či sudiv khonikašće. ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","A vi ako sudiv, mungro sudo si čačo, kaj naj sem korkoro, nego sudiv e Dadesa savo bičhalda man. ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Pa vi ande tumaro zakono ramol kaj kana duj džene svedočin o svedočanstvo si dovoljno. ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Me svedočiv pale mande, a pale mande svedočil vi o Dad savo bičhalda man.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Pa von phučline les: “Kaj si ćiro Dad?” A o Isus phendas: “Tumen či pindžaren ni man ni mungre Dade. Kaj te džangline sas ko sem me, džangline sas vi ko si mungro Dad.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","O Isus sa godova phendas paše kutijice kaj ćidenas pe e love dok sikavelas e manušen ando Hramo, thaj khonik či astarda les kaj lesko časo još či avilo. ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","O Isus palem phendas lenđe: “Me džavtar, a tumen rodena man thaj merena ande tumaro bezeh. Kaj me džav, tumen našti aven.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Askal e Židovske vođe phendine: “Te či kamel te mudarelpe kana phenel: ‘Kaj me džav, tumen našti aven’?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","A o Isus askal phendas lenđe: “Tumen sen akatar tele, katar e phuv, a me sem opral, andar o nebo. Tumen sen katar akava them, a me naj sem katar akava them. ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Zato phendem tumenđe kaj merena ande tumare bezeha. Ako či paćan kaj Me sem, merena ande tumare bezeha.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Von phučline les: “Pa ko san tu askal?” A o Isus phendas lenđe: “Pa so katar o početko phenav tumenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","But godova šaj phendemas pale tumende pe tumari osuda. Ali me e themešće phenav samo okova so ašundem katar okova savo bičhalda man, a vo phenel čačipe.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Von či haćardine kaj phenel lenđe palo Dad. ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Askal o Isus phendas lenđe: “Kana vazdena man, e Čhaves e Manušešće, askal džanena kaj Me sem thaj kaj či ćerav khanči korkoro mandar, nego kaj phenav samo okova so o Dad sikada man. ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","A okova savo bičhalda man, manca si. Či mukla man korkoro kaj me uvek ćerav okova so si lešće drago.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Dok o Isus godova phenelas, but džene paćaine ande leste. ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Askal o Isus phendas e Židovenđe save paćaine ande leste: “Ako tumen inćaren mungro sikavipe, čače sen mungre učenikurja. ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Pindžarena o čačipe thaj o čačipe oslobodila tumen.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","A von phendine lešće: “Amen sam e Avraamešće potomkurja thaj nikada khonikašće či robuisardam. Sar askal tu phenes: ‘Avena slobodne’?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","A o Isus phendas lenđe: “Čače, čače phenav tumenđe: svako ko ćerel bezah, robo si e bezehesko. ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","O robo či ačhel zauvek ando ćher savo služil, ali o čhavo zauvek pripadil ando ćher. ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ako o Čhavo oslobodil tumen, askal čače avena slobodne. ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Džanav kaj sen e Avraamešće potomkurja, ali tumen ipak kamen te mudaren man, kaj či prihvatin mungro sikavipe. ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Me phenav tumenđe pale okova so dikhlem ke mungro Dad, a tumen ćeren okova so ašundine katar tumaro dad.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","A von phendine lešće: “Amaro dad si o Avraam.” A o Isus pe godova phendas lenđe: “Te tumen čače avilinesas e Avraamešće čhavra, pherdine sas okova so ćerelas o Avraam. ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","A tumen akana kamen te mudaren man, zato kaj phendem tumenđe čačipe savo ašundem katar o Del. O Avraam gajda vareso či ćerelas. ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Tumen ćeren okova so ćerel tumaro dad.” Von phendine lešće: “Amen naj sam čhavra save či džanen ko si lengo dad. Amen si samo jek dad – o Del!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","A o Isus phendas lenđe: “Kana o Del avilosas tumaro dad, tumen volisardinesas man, kaj me avilem katar o Del thaj akana sem akate. Či avilem korkoro mandar nego vo bičhalda man. ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Sostar či haćaren so phenav tumenđe? Zato kaj našti prihvatin mungre alava. ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Tumen sen e benđešće čhavra. Vo si tumaro dad thaj tumen kamen te ćeren e volja tumare dadešći. Vo sas ubica katar o početko, thaj či ačhel ando čačipe, kaj ande leste naj čačipe. Kana hohavel, sikavel sosko si. Vo si hohamno thaj o dad e hohaimasko. ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","A manđe zato kaj phenav tumenđe o čačipe, či paćan. ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ko tumendar šaj dokažil manđe bezeh? Ako phenav tumenđe čačipe, sostar askal či paćan manđe? ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ko si katar o Del, čhol kan ke Devlešće alava. A tumen či čhon kan leste zato kaj naj sen katar o Del.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","E Židovurja pe godova phendine lešće: “Naj sam li amen ando pravo kana phenas kaj san tu Samarijanco thaj kaj si ande tute o bilačho duho?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","O Isus phendas: “Naj ande mande o bilačho duho, nego me poštuiv mungre Dade, a tumen či poštuin man. ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Me či rodav slava pale mande. Vareko aver kamel te proslavil man, a vo vi sudil. ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Čače, čače phenav tumenđe: ko inćarel mungro alav, nikada či dićhela o meripe.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","A e Židovurja phendine lešće: “Akana džanas kaj si ande tute o bilačho duho. O Avraam mulo, sago vi e prorokurja, a tu phenes: ‘Ko inćarel mungro alav, nikada či dićhela o meripe!’ ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Naj san valda majbaro katar amaro dad o Avraam, savo mulo? A vi e prorokurja muline. So tu gndis ko san tu?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Askal o Isus phendas lenđe: “Ako me korkoro man proslaviv, mungri slava naj khanči. Man proslavil mungro Dad, pale savo tumen phenen kaj si tumaro Del. ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Tumen či pindžaren les, ali me pindžarav les. Kana phendemas kaj či pindžarav les, avilemas hohavno sago vi tumen. Ali me pindžarav les thaj inćarav lesko alav. ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tumaro dad o Avraam raduilaspe kaj dićhela o đes kan me avava. Dikhla les thaj sas bahtalo.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Askal e Židovurja phučline les: “Sar šaj dikhlan e Avraame? Naj tut još ni pandžvardeš brš, a phenes kaj dikhlan e Avraame!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","O Isus phendas lenđe: “Čače, čače phenav tumenđe, majsigo nego so o Avraam bijandilo, Me sem!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Pe godova von line e bara te čhuden len pe leste, ali o Isus lija pe majdur thaj inkljisto andar o Hramo. ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Kana o Isus naćhelas okotar, dikhla e manušes savo sas koro katar piro o bijandipe. ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","A lešće učenikurja phučline les: “Učiteljina, sostar akava manuš bijandilo koro? Zbog pire bezeha ili zbog e bezeha kaj ćerdine lesko dad thaj lešći dej?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","A o Isus phendas: “Naj vo koro zato kaj ćerdine bezeh vo, lesko dad ili lešći dej. Vo bijandilo koro te pe leste sikadol e Devlešći bari sila. ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Dok si o đes, trubul te ćeras buća katar okova savo bičhalda man. Kaj avel e rjat, kana khonik našti ćerela bući. ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","A dok sem po them, svetlo sem e themesko.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Kana godova phendas, čhungarda pe phuv thaj katar e čhungara ćerda čik, thaj godole čikasa makhlas e kore manušešće jakha. ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Askal phendas lešće: “Dža thaj thov ćo muj ando Siloamsko bazeno!” (Siloam značil “Bičhaldo”.) O manuš đelo, thoda piro muj thaj bolda pe ćhere gajda kaj šaj dićhelas. ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","A lešće komšije thaj okola kaj majsigo dićhenas les kaj prosilas phučline: “Naj li godova okova koro manuš savo akate bešelas thaj prosilas?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","varesave phenenas: “Ej, vo si godova!”, a aver phenenas: “Naj, samo anel pe leste.” A vo phendas: “Ej, me sem godova manuš.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Askal phučline les: “Sar putajle će jakha te šaj dićhes?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","A vo phendas: “O manuš savo akhardol Isus ćerda čik, makhlas mungre jakha thaj phendas: ‘Dža thov ćo muj ando Siloamsko bazeno.’ Me đelem, thodem mungro muj thaj mungre jakha putajle katar o koripe.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Von phučline les: “Kaj si akana godova manuš?” A vo phendas: “Či džanav.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Askal e manušes savo sas varekana koro, inđardine ke fariseja. ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","A godova đes kana o Isus ćerda čik thaj putardas e kore manušešće jakha, sas savato. ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","E fariseja isto gajda phučline les sar putajle lešće jakha. A vo phendas lenđe: “Makhlas mungre jakha e čikasa, thodem mungro muj thaj akana dikhav!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Varesave katar fariseja phendine: “Akava manuš naj katar o Del, kaj ćerel bući ando savato.” A aver phendine: “Sar o bezehalo manuš šaj ćerel kasave čudesne znakurja?” Thaj gajda maškar lende avilo dži ko razdor. ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Askal palem phučline godole manuše savo sas varekana koro: “So tu phenes pale godova manuš savo boldas tuće o vido?” O manuš phendas: “Proroko si.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","A e Židovske vođe či paćanas kaj o manuš sas čače koro thaj kaj putajle lešće jakha, sa dok či akhardine lešće dade thaj lešće deja. ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Askal lendar phučline: “Dali si akava tumaro čhavo pale savo tvrdin kaj bijandilo koro? Sar godova te akana dićhel?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Lesko dad thaj lešći dej phendine: “Džanas kaj si akava amaro čhavo thaj kaj bijandilo koro, ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ali či džanas sar akana šaj dićhel thaj ko putardas lešće jakha. Phučen lestar. Dosta si purano te korkoro phenel pale peste.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Lesko dad thaj lešći dej gajda phendine, kaj sas lenđe dar katar e židovske vođe save odlučisardine kaj andar e sinagoga isključina svakone savo priznail e Isuse palo Hristo. ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Andar godova lesko dad thaj lešći dej phendine: “Dosta si purano te phenel korkoro pale peste. Les phučen!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Askal po dujto data akhardine e manuše savo sas koro, thaj phendine lešće: “Obećisar anglo Del kaj pheneja čačipe! Amen džanas kaj si godova manuš bezehalo.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","A o manuš phendas lenđe: “Me či džanav da li si vo bezehalo. Jek džanav kaj semas koro, a akana dikhav!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Von phučline les: “So ćerda tuće? Sar putardas će jakha?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","A vo phendas lenđe: “Već phendem tumenđe, a tumen či čhonas kan mande. Sostar kamen palem te ašunen? Te či kamen vi tumen te aven lešće učenikurja?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Askal von vređonas les thaj phendine lešće: “Tu san lesko učeniko, a amen sam e Mojsiješće učenikurja. ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Amen džanas kaj o Del motholas e Mojsijašće, a pale akava či džanas ni katar si!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","O manuš phendas lenđe: “Baš godova si čudno kaj či džanen katar si, a vo putardas mungre jakha. ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Džanas kaj o Del či čhol kan ke bezehale, nego čhol kan ke okola save poštuin les thaj ćeren okova so si lešći volja. ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nikada či ašunda pe kaj vareko putardas e kore manušešće jakha savo sas koro katar o bijandipe. ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Te akava manuš či avilosas katar o Del, našti khanči ćerdasas.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Von phendine lešće: “Tu amen sikaveja, a sasto san bijando ando bezeh!” Askal čhudine les avri andar e sinagoga. ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Kana o Isus ašundas kaj tradine e manušes andar e sinagoga, arakhla les thaj phučline les: “Dali paćas ando Čhavo e Manušesko?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","A o sastilo manuš phendas lešće: “Phen manđe ko si vo, Gospode, te šaj paćav ande leste.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","A o Isus phendas lešće: “Već dikhlan les. Vo si godova kaj upravo ćerel tusa svato.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","A o manuš phendas: “Paćav, Gospode”, thaj dija koča angle leste. ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","A o Isus phendas: “Me avilem pe akava them te e themešće šaj sudilpe. Avilem te putrav e jakha okolenđe kaj či dićhen, a te ačhen kore okola save gndin kaj dićhen.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Varesave fariseja save sas lesa ašundine godova thaj phučline les: “Te najsam vi amen kore?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","O Isus phendas lenđe: “Kana priznaisardinesas kaj sen kore, či avilinesas došale palo bezah. Ali pošto phenen kaj dićhen, e doš si vi majdur pe tumende.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","O Isus majdur motholas: “Čače, čače phenav tumenđe: Ko či del ke bakhre kroz o vudar, nego čordane preko zido, čor si thaj razbojniko. ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","A ko del kroz o vudar, pastiri si e bakhrengo. ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","O stražari, savo ačhel po vudar, putrel lešće, a e bakhre ašunen lesko glaso. Vo pire bakhren akharel po alav thaj inkalel len avri. ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Kana inkalel pire bakhren, džal angle lende, a e bakhre džan pale leste, kaj pindžaren lesko glaso. ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","E bakhre nikada či džana pale okova saves či pindžaren, nego našen lestar, kaj či pindžaren lesko glaso.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","O Isus phendas lenđe akaja paramiči, ali von či haćardine so kamlas te phenel lenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Zato o Isus još phenelas lenđe: “Čače, čače phenav tumenđe: me sem o vudar e bakhrenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Savora save aviline majsigo mandar čora si thaj razbojnikurja. Ali e bakhre či čhutine kan lende. ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Me sem o vudar. Ko del prekal mande spasila pes. Dela andre thaj inkljela avri thaj araćhela zeleno čar pe savi čarjola. ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","O čor avel samo te čorel, del čhurjasa thaj mudarel. Me avilem te dav len trajo thaj godova trajo te avel len ando izobilje. ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Me sam o lačho pastiri, a o lačho pastiri del piro trajo pale pire bakhre. ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","O najamniko naj pastiri; e bakhre naj lešće. Zato kana dićhel e ruve kaj avel, mućel e bakhren thaj našel. A o ruv askal napadnil len thaj e bakhre raspršin pes. ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Kaj, vo si samo najamniko thaj les naj briga pale bakhre. ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Me sem o lačho pastiri. Pindžarav mungre bakhren thaj von pindžaren man. ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Isto gajda, mungro Dad pindžarel man thaj me pindžarav mungre Dade. Me mungro trajo dav pale bakhre. ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Si man vi aver bakhre, save naj andar akava stado. Moraš vi len te anav thaj vi von ašunena mungro glaso thaj avena jek stado jećhe pastiresa. ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Zato o Dad volil man, kaj mungro trajo dav te palem lav les palpale. ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Khonik či lel mungro trajo mandar, nego me korkoro mandar dav les. Si man pravo te dav mungro trajo, thaj si man pravo palem vi te lav les. Gajda zapovedisardas manđe o Dad.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Kana phendas godova, e Židovurja palem podelisajle ande pire gindimate. ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","But lendar phenenas: “Ande leste si o bilačho duho thaj buncil. Sostar čhon kan leste?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","A aver phenenas: “Pa či ćerel svato sago kaj si o bilačho duho ande leste. Zar o bilačho duho šaj boldasas e kore manušešće o vido?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ando Jerusalim askal slavilas pe o Prazniko kana posvetilas pe o Hramo thaj sas o ivend. ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","O Isus phirelas kroz o Hramo, pe Solomonešći terasa. ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","A e židovske vođe okružisardine les thaj phučline les: “Dži kaj inćareja amen ando bi džanglipe? Ako san tu o Hristo, askal phen amenđe godova!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","O Isus phendas lenđe: “Već phendem tumenđe ali tumen či paćan manđe. E dela save ćerav ando alav mungre Dadesko von svedočin pale mande. ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ali tumen či paćan kaj naj sen katar mungre bakhre. ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mungre bakhre ašunen mungro glaso, me pindžarav len thaj von džan pale mande. ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Me dav len večno trajo thaj von či propadnina nikada, niti vareko otmila len andar mungre vas. ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Mungro Dad, savo dija len manđe, majbaro si savorendar, thaj khonik našti otmil len andar e Dadešće vas. ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Me thaj o Dad sam jek.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Askal e Židovurja palem line e bara te čhuden pe ande leste te mudaren les. ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","A o Isus phendas lenđe: “Sikadem tumenđe but lačhe dela save aven katar o Dad. Pale save katar godola lačhe dela kamen te čhuden tumen e barenca ande mande?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","E židovske vođe phendine lešće: “Či kamas te čhudas men e barenca ande tute pale lačhe dela, nego kaj hulis po Del. Obično san manuš, a ćeres tut kaj san o Del.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","O Isus phendas lenđe: “Či li ande tumaro zakon ramol kaj o Del phendas: ‘Tumen sen devla!’ ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ako akhardas ‘devlenca’ okolen savenđe si e Devlesko alav uputime – a o Sveto lil našti menjilpe – ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","sar šaj askal pale okova saves o Dad posvetisardas thaj bičhaldas po them te phenen: ‘Hulis po Del’ zato kaj phendem kaj sem Čhavo e Devlesko? ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ako či ćerav e dela mungre Dadešće, na paćan manđe. ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ali ako čače ćerav len, paćan barem ande godola dela kana već či paćan manđe, gajda konačno džanena kaj si o Dad ande mande thaj me ande leste.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Askal von palem kamline te astaren les, ali vo izmaknisajlo andar lenđe vas. ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","O Isus askal palem bolda pes pe aver rig ke reka jordanošći, po than kaj o Jovano varekana bolelas, thaj okote ačhilo. ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","A o but o them avilo leste thaj phendine: “O Jovano či ćerda ni jek čudesno znako, ali sa so phendas pale akava manuš, si čače.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Thaj okote but džene paćajine ande leste. ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Varesavo manuš po alav Lazar sas nasvalo. Vo sas andar e Vitanija, andar o gav kaj trajilas e Marija thaj laći phen e Marta. ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","E Marija sas okoja manušnji savi čhorela mirisno ulje pe Gospodešće pungre thaj khosela len, pire balenca. O Lazar savo sas nasvalo sas lako phral. ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Gajda e pheja, e Marija thaj e Marta, poručisardine e Isusešće: “Gospode, nasvalo si okova saves tu volis.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Kana o Isus godova ašundas, phendas: “Akava nasvalipe či avela po meripe, već pe slava e Devlešće, te kroz late proslavilpe o Čhavo e Devlesko.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","O Isus volilas e Marta, laće pheja thaj lenđe phrale e Lazare. ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ali kana o Isus ašundas kaj si o Lazar nasvalo, ačhilo okote kaj sas još duj đes. ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Askal phendas pire učenikonenđe: “Hajde džas palem ande Judeja!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","A e učenikurja phendine lešće: “Učiteljina, či nakhlo but sar e židovske vođe kamenas okote te mudaren tut e barenca, a tu palem kames te džas inća?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","A o Isus phendas: “Naj li o đes lungo dešuduj saturja? Ko phirel e đeseja, godova či spotaknilpe te perel, kaj si les o svetlo akale themesko. ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ali, ko phirel e raćava, godova spotaknilpe thaj perel, kaj najles svetlo te osvetlil lešće o drom.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Phendas godova thaj lijas te mothol lenđe majdur: “Amaro drugari o Lazar sovljardilo, ali me džava te džungavav les.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","E učenikurja phendine pe godova: “Gospode, ako sovel, značil kaj sastola.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ali o Isus gindilas pe lesko smrto, a e učenikurja haćardine kaj o Lazar čače sovel. ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Askal o Isus jasno mothodas lenđe: “O Lazar mulo. ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Thaj zbog tumende si manđe drago kaj naj semas okote kaj akana paćana. Ali hajde akana džas leste!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Pe godova o Toma, saves akharenas Blizanco, phendas aver učenikonenđe: “Hajde vi amen te meras lesa!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Kana o Isus avilo ande Vitanija, phendine lešće kaj o Lazar pašljol već štar đes mulo ando limori. ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","A e Vitanija sas dur katar o Jerusalim varekaj majcara katar trin kilometra, ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","a e but Židovurja aviline okotar ke Marta thaj ke Marija te utešin len zbog lengo phral. ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Kana e Marta ašundas kaj o Isus avel, đeli angle leste, a e Marija ačhili ćhere. ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","E Marta phendas e Isusešće: “Gospode, te avilanas akate, mungro phral či mulosas. ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ali me akana džanav kaj o Del dela tut sa so manđes lestar.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","A o Isus phendas laće: “Ćiro phral uštela andar e mule.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","A e Marta phendas lešće: “Džanav kaj uštela andar e mule ando Poslednjo đes kana vi aver uštena.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","O Isus phendas laće: “Me sem o vaskrsenje thaj o trajo. Ko paćal ande mande, ako vi merela, trajila. ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Thaj kogod trajil thaj paćal ande mande, nikada či merela. Paćas li ande gadava, Marta?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Voj phendas: “Ej Gospode, paćav kaj san tu o Hristo, e Devlesko Čhavo savo trubuja te avel pe phuv.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Kana phendas godova, đeli thaj akharda pire pheja e Marija pe rig thaj phendas laće: “O Učitelj si akate thaj akharel tut.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Kana e Marija godova ašundas, brzo uštili thaj teljardas leste. ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","A o Isus još či dija ando gav, već ačhilo po than kaj malada les e Marta. ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","A e Židovurja save sas e Marijasa ando ćher thaj tešinas lat, kana dikhline e Marija kaj ando siđaripe uštili thaj inkljisti te varekaj džal, teljardine pale late, kaj gndinas kaj džal po limori te okote rovel. ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Kana e Marija avili dži ko than kaj sas o Isus thaj kana dikhla les, peli pe koča angle leste thaj phendas: “Gospode, te tu avilanas akate, mungro phral či mulosas!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Kana o Isus dikhla e Marija thaj e Židoven save avile lasa, sar roven, uznemirisajlo thaj sas lešće pharo ando ilo. ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Askal phučla len: “Kaj čhutine e Lazare?” Phendine lešće: “Gospode, av thaj dik.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","E Isusešće askal teljardine e jasva. ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","A e Židovurja phendine: “Dićhen, kozom volilas les!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","A varesave maškar lende phendine: “Zar vo, savo e kore manušešće boldas o vido, našti ćerda te o Lazar na merel?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Askal o Isus palem but uznemirisajlo thaj đelo pe Lazaresko limori savo sas ćerdo ande pećina, a po ulaz sas čhutino o baro bar. ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","O Isus phendas: “Len majdur o bar!” A e Lazarešći phen e Marta phendas: “Gospode, moraš kaj već zurale khandel, kaj već si štar đes ando limori!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","O Isus phendas laće: “Či li phendem tuće kaj dićheja e slava e Devlešći ako paćas?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Askal spidine o bar majdur, a o Isus vazda pire jakha ando nebo thaj phendas: “Dade, najs tuće kaj ašundan man ande molitva. ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Džanav kaj uvek ašunes man kana moliv man tuće, ali akava phendem zbog o them savo ačhel akate, te šaj paćan kaj tu bičhaldan man.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Kana o Isus godova phendas, zurale čhuta muj: “Lazare, inklji avri!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","O mulo Lazar inkljisto. Lešće pungre thaj lešće vas sas motime ande zavoje, a lesko muj sas učhardo e laneno čaršapeja. O Isus phendas lenđe: “Putren godova lestar thaj mućen les te džal!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Kana e but Židovurja save avile ke Marija, dikhline so o Isus ćerda teljardine te paćan ande leste. ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ali varesave katar godola manuša đele ke fariseja thaj mothodine lenđe so o Isus ćerda. ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Askal e šorvale rašaja thaj e fariseja ćidine e manušen andar o Baro veće thaj phendine: “So te ćeras? Akava manuš ćerel but čudesne znakurja. ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Te muklam les te nastavil agajda, savora ačhena te paćan ande leste. Askal avena e Rimljanurja thaj uniština vi amaro Hramo thaj vi amaro them.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","A jek lendar, o Kajafa, savo sas godova brš baro rašaj, phendas lenđe: “Khanči tumen či džanen! ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Zar či haćaren kaj si majlačhe te jek manuš merel palo them, nego te sa amaro them avel mudardo?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","O Kajafa či phendas godova korkoro pestar, nego sar vo sas godova brš baro rašaj, gajda prorokuisarda kaj o Isus merela palo sasto židovsko them. ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Thaj na samo palo židovsko them, nego vi pale godova te ćidel e Devlešće rspime čhavren te aven sago jek. ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Godova đes e židovske vođe odlučisardine te mudaren e Isuse. ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Andar godova o Isus majbut či sikadolas maškar e židovske vođe, nego đelotar okotar ando krajo paše ke pustinja, ando gav savo akhardolas Efrem. Okote ačhilo e učenikonenca. ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","A sas paše o židovsko prazniko Pasha thaj e but Židovurja andar pire krajurja aviline ando Jerusalim, te obredno šilaven pe majsigo nego so avel o prazniko Pasha. ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Askal rodenas e Isuse thaj dok ačhenas ando Hramo phučenas jek avres: “So gndin? Dali avela pe Pasha?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","A e šorvale rašaja thaj e fariseja već dine naredba te svako ko džanel kaj si o Isus, te godova javin, te šaj astaren les. ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Šov đes majsigo nego o prazniko Pasha, o Isus đelo ande Vitanija, kaj trajilas o Lazar, saves uskrsnisardas andar e mule. ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Okote pripremisardine lešće večera. E Marta poslužilas, a o Lazar sas e Isuseja thaj averenca pale sinija. ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Askal e Marija lijas varekaj katar e opaš litra o kuč miris katar o čisto nard, makhlas leja e Isusešće pungre, thaj khosla len pire balenca. Thaj sasto ćher pherdilo e mirisosa. ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ali o Juda andar o gav Kariot, jek katar e Isusešće učenikurja – savo majposle izdaisarda les, phendas: ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Sostar godova miris či bićinda pe pale trin šela rupune lovora thaj e love razdelisajle e čorenđe?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Či phendas godova zato kaj ačhilo lešće pale čore, nego zato kaj sas čor. Vo sas zadužime pale kutijica ande savi sas e zajedničke love thaj često čorelas andar late. ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Askal o Isus phendas: “Mućen lat po miro! Lačhe ćerda kaj araćhelas godova miris sa dži ađes, kaj si akava đes priprema pale mungro prahope. ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Kaj čore manušen uvek avela tumen tumenca, a me či avava uvek tumenca.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","But e Židovurja andar o Jerusalim saznaisardine kaj si o Isus ande Vitanija. Teljardine inća te dićhen e Isuse, ali vi e Lazare. O Lazar sas okova manuš saves o Isus vazdas andar e mule. ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Askal e šorvale rašaja odlučisardine te mudaren vi e Lazare ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","kaj zbog leste but e Židovurja mućenas len thaj paćanas ando Isus. ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Thejara o đes o but o them save aviline po prazniko Pasha, ašundine kaj o Isus avel ando Jerusalim, ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","line e palmenđe krandže, teljardine angle leste thaj čhonas muj: “Hosana! Blagoslovime si okova savo avel ando alav e Gospodesko! Nek avel blagoslovime o Caro e Izraelosko!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","A o Isus arakhlas terne magarco thaj uzjašisarda les, sago kaj si ramome ando Sveto lil: ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Na daran, manušalen andar o Jerusalim! Ake, avel ćiro caro gajda kaj jašil e terne magarco!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Lešće učenikurja askal či haćardine godova, ali kana o Isus sas vazdino ande piri slava, dine pe gođi kaj ando Sveto lil ramol pale leste baš okova so askal ćerdine lešće. ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","A o them savo sas e Isuseja kana akhardas e Lazare te inkljel andar o limori thaj vazda les andar e mule, svedočinas pale godova. ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Zato o but o them vi inkljisto angle leste, kaj ašundine kaj si vo godova savo ćerda o čudesno znako. ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Askal e fariseja phendine jek avrešće: “Dićhen kaj khanči či vredil! Eke sa o them džal pale leste!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Maškar o okola save aviline ando Jerusalim te pokloninpe e Devlešće po prazniko Pasha sas vi Grkurja. ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Von aviline ko Filip, savo sas andar e Vitsaida ande Galileja, thaj zamolisardine les e alavenca: “Raja, kamlamas te dikhas e Isuse.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","O Filip đelo thaj phendas godova e Andrijašće, askal o Andrija thaj o Filip đeline thaj phendine godova e Isusešće. ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","A o Isus phendas lenđe: “Avili e vrjama te o Čhavo e manušesko primil piri slava. ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Čače, čače phenav tumenđe, ako e đivešći kućin či perel pe phuv thaj či merel, ačhel korkoro. A ako merel, anel but plodurja. ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ko volil piro trajo pe akava them hasarela les. A ko mrzal piro trajo pe akava them, araćhela les palo večno trajo. ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ko kamel te služil manđe neka džal pale mande. Kaj sem me, okote avela vi mungro sluga. Okolešće savo služil manđe, mungro Dad dela les čast. ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Mungri duša si akana uznemirime, thaj so te phenav? Dali te phenav: ‘Dade, spasi man katar akaja patnja?’ Na, kaj baš pale godova vi avilem. ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Dade, proslavi ćiro alav.” Askal andar o nebo ašundilo o glaso: “Me već proslavisardem mungro alav thaj palem proslaviva les.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","A e manuša save okote ačhenas, ašundine o glaso thaj phendine kaj zagrmisardas. A aver phendine: “O anđelo mothol lešće.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","A o Isus phendas lenđe: “Akava glaso či avilo zbog mande, nego zbog tumende. ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Akana si e vrjama palo sudo akale themesko. Akana o vladari akale themesko avela čhudino avri. ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","A kana me avava vazdino katar e phuv, sa e theme crdava mande.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Godova phendas te označil save smrtosa merela. ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Askal o them phendas lešće: “Amen andar o zakon sićilam kaj o Hristo trajila zauvek. Sar askal phenes kaj o Čhavo e manušesko trubul te avel vazdino te merel? Ko si godova Čhavo e manušesko?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Askal o Isus phendas lenđe: “O svetlo či avela još dugo maškar tumende. Zato phiren dok si tumen još svetlo, te či nadvladil tumen o tunjariko. Kaj, ko phirel ando tunjariko, či džanel kaj džal. ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Paćan ando svetlo, dok još si tumen svetlo te aven čhave e svetlošće!” Pale godova o Isus đelotar thaj garadilo lendar. ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Vi ako o Isus ćerda sa godola čudesne znakurja angle lende, von ipak či paćanas lešće ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","te pherdol o alav savo phendas o proroko Isaija: “Gospode, ko paćaja ande amari poruka thaj kašće sikadilo o snažno vas e Gospodesko?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Zbog akava našti paćajine, kaj o Isaija isto gajda phendas: ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“O Del korarda lenđe jakha thaj zurardas lenđe ile, te e jakhenca či dićhen, a e ileja či haćaren, thaj či obratin pe, te sastarav len.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","O Isaija phendas godova, kaj dikhla e Isusešći slava thaj ćerelas svato pale leste. ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ipak, e but šorvale paćajine ande leste, ali či priznainas godova zbog e fariseja, te či aven isključime andar e sinagoga. ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Kaj, majbut volisardine e manušenđi slava nego e Devlešći. ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","A o Isus čhuta muj e alavenca: “Ko paćal ande mande, či paćal samo ande mande, nego ande okova savo bičhalda man. ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Thaj ko man dićhel, dićhel okoles savo bičhalda man. ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Me, o svetlo, avilem po them te savora save paćan ande mande či ačhen majbut ando tunjariko. ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ako vareko ašunel mungre alava, a či inćarel len, me či sudiv lešće. Kaj, či avilem te sudiv e themešće, nego te spasiv les. ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ko man odbacil thaj či prihvatil mungre alava, avela les lesko sudco. E alava save phendem tumenđe von sudina lešće ando Posledno đes. ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Kaj me či phenavas korkoro mandar, nego korkoro o Dad, savo bičhalda man zapovedisardas manđe so te phenav. ");
INSERT INTO rmyChergash_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","A džanav kaj lešći zapoved anel večno trajo. Dakle, okova so me phenav, phenav gajda sar o Dad phendas manđe.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Sas akava anglo prazniko Pasha. O Isus džanelas kaj avilo o časo kana mućela akava them thaj džala ke piro Dad. Volilas okolen save sas lešće ande akava them, a volilas len dži ko piro smrto. ");
INSERT INTO rmyChergash_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","O Isus thaj lešće učenikurja hanas zajedno večera. A o beng e Judašće andar o gav Kariot, e Simonešće čhavešće, već čhuta ando ilo te izdail e Isuse. ");
INSERT INTO rmyChergash_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","O Isus džanglas kaj o Dad sa e vlast dija ande lešće vas thaj kaj vo katar o Del avilo thaj kaj leste boldel pe. ");
INSERT INTO rmyChergash_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Askal o Isus uštilo katar e večera thaj fuljarda pestar o ogrtači, lijas o peškiri thaj phangla les angle peste. ");
INSERT INTO rmyChergash_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Askal čhuta paj ando lavori thaj ačhilo te thovel e pungre pire učenikonenđe thaj te khosel len e peškiresa savo sas angle leste. ");
INSERT INTO rmyChergash_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Askal avilo dži ko Simon Petar, savo phendas lešće: “Gospode, tu manđe e pungre te thoves!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","A o Isus phendas lešće: “Tu akana či džanes so me ćerav, ali haćareja jek đes.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pe godova o Petar phendas lešće: “Či thoveja tu mungre pungre nikad!” A o Isus phendas lešće: “Ali te či thodem ćire pungre, našti aves jek katar mungre.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Askal o Simon Petar phendas lešće: “Gospode, na thov samo mungre pungre, nego vi mungre vas thaj vi mungro šoro!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","A o Isus phendas lešće: “Kolešće savo si najardo trubul samo te thoven pe e pungre, kaj već si sasto čisto. Tumen sen čiste, ali na savora.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","O Isus džanelas ko izdaila les thaj andar godova phendas: “Naj sen savora čiste.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Kana thoda lenđe pungre, lijas pe peste piro ogrtači thaj bolda pe ke sinija. Askal phučla len: “Dali haćaren so ćerdem tumenđe? ");
INSERT INTO rmyChergash_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Tumen akharen man Učitelj thaj Gospod. Lačhe phenen kaj godova vi sem! ");
INSERT INTO rmyChergash_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Pa ako me, o Gospod thaj Učitelj thodem tumenđe e pungre, vi tumen askal trubun te thoven e pungre jek avrešće. ");
INSERT INTO rmyChergash_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Dijem tumen primer: ćeren gajda sago kaj me ćerdem tumenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Čače, čače phenav tumenđe: naj o sluga majbaro katar piro gospodari niti si o poslaniko majbaro katar okova savo bičhalda les. ");
INSERT INTO rmyChergash_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Akana, kana džanen godova, blago tumenđe te gajda vi ćeren!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Či phenav pale sa tumende. Me džanav saven losardem. Ali o Sveto lil moraš te pherdol kana phenel: ‘Okova savo halas manca, vazdel pe protiv mande.’ ");
INSERT INTO rmyChergash_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Phenav tumenđe akana, majsigo nego so godova avela, te kana godova avela šaj paćan kaj Me sem. ");
INSERT INTO rmyChergash_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Čače, čače phenav tumenđe, ko primil okole saves me bičhalav, man primil, a ko primil man, primil Okoles savo bičhalda man.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Kana phendas godova, o Isus zurale uznemirisajlo ando duho thaj phendas lenđe: “Čače, čače phenav tumenđe: jek tumendar izdaila man!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Lešće učenikurja dikhline jek pe avreste thaj phučenas pe, pale kaste godova phenel. ");
INSERT INTO rmyChergash_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jek katar e učenikurja, saves o Isus but volilas, bešelas odma pašo Isus. ");
INSERT INTO rmyChergash_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Lešće o Simon Petar dijas znako thaj phendas: “Phuč les pale kaste phenel.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Akava učeniko avilo e Isuseste majpaše thaj phučla les: “Ko si godova, Gospode?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","O Isus phendas: “Okova si kašće dav kotor mangro boldo ando čaro.” Bolda kotor mangro ando čaro thaj dija e Judašće, e Simonešće čhavešće andar o gav Kariot. ");
INSERT INTO rmyChergash_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Čim o Juda halas godova kotor mangro, o Satana dijas ande leste. A o Isus phendas lešće: “Odma ćer okova so manđes te ćeres!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Khonik katar učenikurja save sas pale sinija či haćardine sostar o Isus phendas lešće godova. ");
INSERT INTO rmyChergash_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","A sar lenđe zajedničke love sas ko Juda, varesave gndinas kaj o Isus phendas lešće te džal te ćinel vareso hamasko palo prazniko ili te del vareso love e čore manušenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","O Juda, nakon so lijas kotor mangro, odma đelotar. A sas e rjat. ");
INSERT INTO rmyChergash_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Kana o Juda đelotar, o Isus phendas: “Akana si proslavime o Čhavo e manušesko thaj o Del si proslavime ande leste. ");
INSERT INTO rmyChergash_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ako o Del si proslavime ande leste, vi o Del proslavila les ande peste, thaj proslavila les odma. ");
INSERT INTO rmyChergash_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Čhavralen, još sem samo harni vrjama tumenca. Rodena man, ali sago kaj majsigo phendem e židovske vođenđe, akana phenav vi tumenđe: ‘Okote kaj me džav tumen našti aven.’ ");
INSERT INTO rmyChergash_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nevi zapoved dav tumen: te volin jek avres. Sago kaj me volivas tumen, gajda tumen volin jek avres. ");
INSERT INTO rmyChergash_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Te avilo tumen ljubav jek pale avreste, savora džanena kaj sen mungre učenikurja.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","O Simon Petar phučlas e Isuse: “Gospode, kaj džas?” A o Isus phendas lešće: “Akana našti džas pale mande okote kaj me džav, ali aveja majposle.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","O Petar phučla les: “Gospode, sostar našti džav tusa akana? Spremno sem te merav pale tute!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","O Isus phučla les: “Dali san vi čače spremno te meres pale mande? Čače, čače phenav tuće: majsigo so o bašno ašundola, trin drom hohaveja kaj či pindžares man.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","O Isus majdur motholas: “Neka tumare ile či aven uznemirime. Paćan ando Del thaj paćan ande mande. ");
INSERT INTO rmyChergash_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ando ćher mungre Dadesko si but stanurja. Te či avilosas gajda dali phendemas tumenđe: ‘Džav te lačharav tumenđe o than’? ");
INSERT INTO rmyChergash_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Kana džavatar thaj lačharava tumenđe than, palem avava thaj lava tumen mande te vi tumen aven okote kaj sem me. ");
INSERT INTO rmyChergash_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","A kaj me džav, tumen već džanen o drom.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","A o Toma phendas: “Gospode, či džanas kaj tu džas. Sar šaj te džanas o drom?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","O Isus phendas lešće: “Me sem o Drom, Čačipe thaj Trajo. Khonikal či avel ko Dad osim preko mande. ");
INSERT INTO rmyChergash_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ako džangline sas man askal džanena vi mungre Dade. Tumen katar akana pindžaren les thaj dikhline les.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","O Filip phendas lešće: “Gospode, sikav amenđe e Dades thaj godova avela amenđe dosta!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","O Isus phendas lešće: “Gadići vrjama sem tumenca a tu, Filipe, još či pindžares man? Ko dikhla man, dikhla vi e Dades. Sar šaj askal phenes: ‘Sikav amenđe e Dades’? ");
INSERT INTO rmyChergash_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Zar či paćas kaj sem me ando Dad thaj kaj si o Dad ande mande? E alava save me phenav tumenđe, či phenav korkoro mandar, nego o Dad savo trajil ande mande ćerel pire dela kroz mande. ");
INSERT INTO rmyChergash_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Paćan manđe kaj sem me ando Dad thaj kaj si o Dad ande mande. Ako či paćan zbog varesoste avreste, paćan bar zbog e dela save dikhline kaj ćerav. ");
INSERT INTO rmyChergash_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Čače, čače phenav tumenđe, ko paćal ande mande, ćerela e dela save me ćerav, pa čak vi majbare dela ćerena, kaj me džav ko Dad. ");
INSERT INTO rmyChergash_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Thaj sogod zamolin ande mungro alav, me godova ćerava te proslavilpe o Dad ando Čhavo. ");
INSERT INTO rmyChergash_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Sogod te zamolin man ande mungro alav, me ćerava godova.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","O Isus majdur phendas: “Ako volin man, inćarena mungre zapovedi, ");
INSERT INTO rmyChergash_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","a me moliva e Dade thaj vo bičhalela tumenđe aver Zastupniko te avel tumenca zauvek. ");
INSERT INTO rmyChergash_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Vo si Duho čačimasko, saves o them našti primil, kaj či dićhel les thaj či pindžarel les. Tumen pindžaren les, kaj si tumenca thaj trajila ande tumende. ");
INSERT INTO rmyChergash_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Či mukava tumen sago čoren. Palem avava tumende. ");
INSERT INTO rmyChergash_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Još cara thaj o them majbut či dićhela man, ali tumen dićhena man. Kaj, me trajiv, thaj vi tumen trajina. ");
INSERT INTO rmyChergash_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Godova đes saznaina kaj sem me ande mungro Dad thaj kaj sen tumen ande mande, a me ande tumende. ");
INSERT INTO rmyChergash_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ko prihvatil mungre zapovedi thaj inćarel len, godova volil man, a ko volil man, les volila mungro Dad. Thaj vi me voliva les thaj objaviva man lešće.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","O Juda (na okova andar o gav Kariot) phučla les: “Gospode, sar godova kaj sikaveja tu samo amenđe, a na vi e themešće?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","O Isus phendas lešće: “Ako vareko volil man, inćarela mungro sikavipe thaj mungro Dad volila les. Mungro Dad thaj me avasa leste thaj trajisa lesa. ");
INSERT INTO rmyChergash_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ko či volil man, či inćarel mungro sikavipe, vi ako o sikavipe savo ašunen naj mungro, nego katar o Dad savo bičhalda man. ");
INSERT INTO rmyChergash_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Akava phendem tumenđe akana, dok sem još tumenca. ");
INSERT INTO rmyChergash_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","A o Zastupniko – o Sveto Duho – saves o Dad bičhalela te zastupil man, sikavela tumen sa thaj dela tumen gođi so phenavas tumenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Mukav tumenđe mungro miro, mungro miro dav tumen. Ali, či dav les gajda sago kaj o them del les. Neka či uznemirilpe tumaro ilo thaj neka či daral. ");
INSERT INTO rmyChergash_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ašundine so phendem tumenđe: ‘Džavtar thaj boldava man tumende.’ Te volisaren man raduisardinesas tumen kaj džav ko Dad, kaj si o Dad majbaro mandar. ");
INSERT INTO rmyChergash_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Phendem tumenđe sa akava majsigo nego so avel, te paćan kana godova avela. ");
INSERT INTO rmyChergash_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Či ćerava tumenca više but svato, kaj avel o vladari akale themesko. Les naj vlast pe mande, ");
INSERT INTO rmyChergash_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ali o them trubul te džanel kaj me voliv e Dade thaj zbog godova ćerav gajda sar o Dad zapovedisarda manđe. Ušten, džastar akatar.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","O Isus phendas: “Me sem o čačutno čokot, a mungro Dad si vinogradari. ");
INSERT INTO rmyChergash_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Vo čhinel pe mande svako loza savi či bijanel plodo, a svako loza savi bijanel plodo vo obrezil thaj šilavel te anel još majbut plodo. ");
INSERT INTO rmyChergash_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","A tumen sen već šlade zbog e alava save phenavas tumenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ačhen ande mande thaj me ačhava ande tumende. Sago kaj e loza našti anel plodo korkoro pestar te či ačhili po čokot, gajda ni tumen našti anena plodo te či ačhiline ande mande. ");
INSERT INTO rmyChergash_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Me sem o čokot, a tumen sen e loza. Ko ačhel ande mande thaj me ande leste, but plodo anela. Kaj bi mango našti ćeren khanči. ");
INSERT INTO rmyChergash_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ako vareko či ačhel ande mande, čhudel pe avri sago e čhindi loza thaj šućola. A kasavi loza ćidel pe thaj čhudel pe ande jag te phabol. ");
INSERT INTO rmyChergash_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ako ačhen ande mande thaj mungre alava ačhen ande tumende, roden sogod kamen thaj dela pe tumenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Akaleja proslavilpe mungro Dad: te anen but plodurja thaj te aven mungre učenikurja. ");
INSERT INTO rmyChergash_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Sago kaj o Dad volilas man, gajda vi me volivas tumen. Ačhen ande mungri ljubav. ");
INSERT INTO rmyChergash_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Te inćaredine tumen ke mungre zapovesti, ačhena ande mungri ljubav, sago kaj vi me inćaravas e zapovesti mungre Dadešće thaj ačhav ande lešći ljubav. ");
INSERT INTO rmyChergash_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Akava phendem tumenđe te mungri bah avel ande tumende thaj te tumari bah avel potpuno. ");
INSERT INTO rmyChergash_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Akaja si mungri zapovest: te volin jek avres sago kaj me volivas tumen. ");
INSERT INTO rmyChergash_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Naj majbari ljubav nego te vareko del pesko trajo pale pešće drugarja. ");
INSERT INTO rmyChergash_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Tumen sen mungre drugarja, ako ćeren okova so zapovediv tumenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Majbut či akharav tumen sluge, kaj o sluga či džanel so ćerel lesko gospodari. Me akharav tumen mungre drugarenca, kaj phendem tumenđe sa so ašundem katar mungro Dad. ");
INSERT INTO rmyChergash_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Či losardine tumen man, nego me losardem tumen thaj čhutem tumen te džan thaj te anen plodo thaj tumaro plodo ačhel, gajda te o Dad del tumen sa so roden lestar ande mungro alav. ");
INSERT INTO rmyChergash_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Akava zapovediv tumenđe: volin jek avres!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Ako o them mrzal tumen, džanen kaj vi man mrzalas majsigo tumendar. ");
INSERT INTO rmyChergash_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Te avilinesas katar akava them, o them volisardasas tumen sago piren. Ali sar naj sen katar akava them, nego me losardem tumen andar akava them, zato o them mrzal tumen. ");
INSERT INTO rmyChergash_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Den tumen gođi so phendem tumenđe: ‘O sluga naj majbaro katar piro gospodari.’ Ako progoninas man, progonina vi tumen. Ako inćardine mungre alava, inćarena vi tumare. ");
INSERT INTO rmyChergash_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Sa akava ćerena protiv tumende zbog mungro alav, kaj či pindžaren Okoles savo bičhalda man. ");
INSERT INTO rmyChergash_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Te či avilemas thaj te či mothavas lenđe, či avilesas došale palo bezeh. Ali akana najlen izgovor palo piro bezeh. ");
INSERT INTO rmyChergash_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ko man mrzal, mrzal vi mungre Dade. ");
INSERT INTO rmyChergash_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Te či ćerdem maškar lende dela, save khonik aver či ćerda, či avilesas došale palo bezeh. Ali dikhline e dela save ćerdem, a ipak mrzan vi man vi mungre Dade. ");
INSERT INTO rmyChergash_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ali, trubul te pherdol okova so si ramome ande lengo zakono: ‘Mrzanas man, a nas len andar soste.’ ");
INSERT INTO rmyChergash_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","A kana avela o Zastupniko, saves bičhalava tumenđe katar o Dad – e Duho čačimasko savo inkljel katar o Dad – vo pale mande svedočila. ");
INSERT INTO rmyChergash_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","A svedočina vi tumen, kaj sen katar o početko manca.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","O Isus još phendas: “Godova phendem tumenđe te či peren katar o paćipe. ");
INSERT INTO rmyChergash_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Isključina tumen andar e sinagoga. Thaj avela e vrjama kana svako ko mudarel tumen gindila kaj gajda služil e Devlešće. ");
INSERT INTO rmyChergash_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","A godova ćerena zato kaj či pindžaren ni e Dade ni man. ");
INSERT INTO rmyChergash_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Akava phendem tumenđe te kana avela godoja vrjama, den tumen gođi kaj phenavas tumenđe pale godova. Ando početko akava či phendem tumenđe, kaj semas tumenca.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Ali akana džavtar ke okova savo bičhalda man, a khonik tumendar či phučel man: ‘Kaj džas?’ ");
INSERT INTO rmyChergash_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Nego, zato kaj akava phendem tumenđe, e žalost pherda tumare ile. ");
INSERT INTO rmyChergash_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ali me phenav tumenđe čačipe: pale tumende si majlačhe te me džavtar. Kaj, ako me či džavtar, či avela tumenđe o Zastupniko. A ako džavtar bičhalava les tumenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","A kana vo avela, dokažila e themešće so si čače bezeh, pravednost thaj sudo. ");
INSERT INTO rmyChergash_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Vo dokažila e themešće kaj si bezehale zato kaj či paćan ande mande. ");
INSERT INTO rmyChergash_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Thaj dokažila e themešće so si pravednost zato kaj džav ko Dad thaj okote majbut našti dićhena man. ");
INSERT INTO rmyChergash_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Thaj dokažila e themešće so si o sudo zato kaj o vladari akale themesko si već osudime. ");
INSERT INTO rmyChergash_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Još but godova avilosas man te phenav tumenđe, ali akana godova našti te inćaren. ");
INSERT INTO rmyChergash_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ali kana avela vo, o Duho čačimasko, uputila tumen ande sasto čačipe. Vo či ćerela svato korkoro pestar, nego phenela tumenđe okova so ašundas thaj objavila tumenđe okova so avela. ");
INSERT INTO rmyChergash_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Vo proslavila man, kaj lela mandar so si mungro thaj objavila tumenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Sa so si e Dades, mungro si. Zato phenav tumenđe: ‘Lela mandar so si mungro thaj objavila tumenđe.’ ");
INSERT INTO rmyChergash_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Još samo cara, thaj džavatar thaj majbut či dićhena man. Thaj palem cara naćhela, thaj palem dićhena man.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Askal varesave katar e Isusešće učenikurja phučline jek avres: “So si godova kaj phenel amenđe: ‘Još samo cara, thaj či dićhena man, a askal još cara thaj palem dićhena man’, thaj: ‘Zato kaj džav ko Dad’?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Thaj phenenas: “So si godova kaj phenel: ‘Još cara’? Či džanas so phenel.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","A o Isus džanglas kaj kamen te phučen les pale godova thaj phendas lenđe: “Phučen tumen maškar tumende pale okova kaj phendem: ‘Još cara thaj či dićhena man, a askal još cara thaj dićhena man’. ");
INSERT INTO rmyChergash_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Čače, čače phenav tumenđe: Tumen rovena thaj tugujina, a o them raduilape. Avena žalosne, ali tumari žalost pretvorilape ande bah. ");
INSERT INTO rmyChergash_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","E manušnji si ande dukha dok bijanel, kaj avilo lako časo. Ali, kana o čhavro bijandol, voj majbut či del pe gođi ke muke. Voj si bahtali kaj andas manušes po them. ");
INSERT INTO rmyChergash_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Gajda sen vi tumen akana žalosne, ali me palem dikhava tumen thaj tumaro ilo raduilape thaj khonik našti lela tumendar godoja bah. ");
INSERT INTO rmyChergash_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Thaj godova đes khanči či phučena man. Čače, čače phenav tumenđe: sogod zamolin e Dades ande mungro alav, dela pe tumenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Dži akana khanči či molisardine ande mungro alav. Molin, thaj dobina – te tumari bah avel pherdi.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Akava phenavas tumenđe ande paramiče. Avel e vrjama kana majbut či mothava tumenđe ande paramiče, nego jasno mothava tumenđe palo Dad. ");
INSERT INTO rmyChergash_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Godova đes molina e Dade ande mungro alav. Či phenav tumenđe kaj me moliva e Dade pale tumende. ");
INSERT INTO rmyChergash_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","O Dad vi korkoro volil tumen kaj tumen volisardine man thaj paćaine kaj avilem katar o Del. ");
INSERT INTO rmyChergash_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Me inkljistem katar o Dad thaj avilem pe akava them. Akana mukav o them thaj džav ke mungro Dad.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Askal lešće učenikurja phendine lešće: “Ake, akana jasno phenes amenđe, thaj či phenas amenđe ande paramiče. ");
INSERT INTO rmyChergash_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Akana džanas kaj tu sa džanes, thaj kaj džanes so phučasa tut majsigo nego so phučas tut. Zato paćas kaj avilan katar o Del.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","A o Isus phendas lenđe: “Da li akana paćan? ");
INSERT INTO rmyChergash_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ake, avel o časo – thaj već si akate – kana našena svako pe piri rig, a man mućena korkores. Ali me naj sem korkoro, kaj manca si o Dad. ");
INSERT INTO rmyChergash_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Akava phendem tumenđe te ande mande avel tumen miro. Ande akava them si tumen nevolje, ali aven hrabre – me pobedisardem o them.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Kana godova phendas, o Isus dikhla ando nebo thaj phendas: “Dade, avilo o časo: proslavisar ćire Čhaves, te o Čhavo proslavil tut. ");
INSERT INTO rmyChergash_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kaj, tu dijan les vlast pe sa e manuša, te savorenđe saven tu dijan les vo del večno trajo. ");
INSERT INTO rmyChergash_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","A akava si večno trajo: te pindžaren tut, e jedino čačutne Devle, thaj okoles saves tu bičhaldan – e Isuse Hristos. ");
INSERT INTO rmyChergash_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Me tut proslavisardem pe phuv gajda kaj završisardem sa so phendan manđe te ćerav. ");
INSERT INTO rmyChergash_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Akana tu, Dade, proslavisar man tute e slavava savi sas man tute majsigo nego so postoilas o them.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Me objavisardem ćiro alav e manušenđe save dijan man andar akava them. Sas ćire, a tu dijan len manđe thaj von inćarenas ćire alava. ");
INSERT INTO rmyChergash_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Akana džanen, kaj avel tutar sa so dijan man. ");
INSERT INTO rmyChergash_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Kaj dijem len ćire alava save tu dijan manđe thaj von prihvatisardine thaj džanen kaj si čače kaj me tutar avilem thaj paćan kaj tu bičhaldan man. ");
INSERT INTO rmyChergash_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Pale lende moliv. Či moliv pale manuša andar akava them, nego pale okola save tu dijan man, kaj si ćire. ");
INSERT INTO rmyChergash_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Sa so si mungro, ćiro si, thaj so si ćiro, mungro si, a me ande lende proslavisajlem. ");
INSERT INTO rmyChergash_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Me naj sem majbut ando them, ali von si ando them, a me avav tute. Sveto Dade, arakh len ande ćiro alav, okolen save dijan man, te aven jek sago kaj sam amen jek. ");
INSERT INTO rmyChergash_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Dok semas lenca, lavas pe lende sama ande ćiro alav savo dijan man. Lavas len sama thaj ni jek lendar či hasajlo, osim o okova savo sas odredime pale propast, te pherdol o Sveto lil. ");
INSERT INTO rmyChergash_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Akana avav tute, ali akava phenav dok sem još ando them, te avel len pherdi bah savi si man. ");
INSERT INTO rmyChergash_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Dijem len ćiro alav, a o them zamrzisarda len andar godova kaj von naj andar akava them, sago kaj naj sem ni me. ");
INSERT INTO rmyChergash_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Či moliv tut te les len katar akava them, nego te araćhes len katar o Bilačho. ");
INSERT INTO rmyChergash_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Von či pripadin akale themešće, sago kaj ni me naj sem katar akava them. ");
INSERT INTO rmyChergash_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Posvetisar len e čačimasa te služin tuće. Ćiro Alav si čačipe. ");
INSERT INTO rmyChergash_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Sago kaj tu man bičhaldan ando them, gajda vi me bičhaldem len ando them. ");
INSERT INTO rmyChergash_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Me korkoro man posvetiv pale lende, te vi von aven posvetime e čačimasa.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ali či moliv tut samo pala lende, nego vi pale okola save pe lenđe alava paćana ande mande, ");
INSERT INTO rmyChergash_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","te savora aven jek sago kaj san tu, Dade, ande mande thaj me ande tute. Neka vi von aven ande amende, te o them paćal kaj tu bičhaldan man. ");
INSERT INTO rmyChergash_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Dijem len slava savi tu dijan man, te aven jek sago kaj sam amen jek ");
INSERT INTO rmyChergash_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","– me ande lende, a tu ande mande – te aven savršeno ujedinime, te o them džanel kaj tu bičhaldan man thaj kaj len volisardan sago kaj volisardan man. ");
INSERT INTO rmyChergash_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Dade, kamav te okola save tu dijan man aven manca okote kaj sem me thaj te dićhen mungri slava, slava savi tu dijan man, kaj volisardan man majsigo nego so o them postoilas. ");
INSERT INTO rmyChergash_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Pravedno Dade, vi ako o them či pindžarel tut, me pindžarav tut, a vi akala džanen kaj tu bičhaldan man. ");
INSERT INTO rmyChergash_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Me objavisardem lenđe ćiro alav, a objaviva les vi majdur, te e ljubav saveja volisardan man avel ande lende, thaj me ande lende.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Kana phendas godova, o Isus đelotar pire učenikonenca pe okoja rig e potokošći ando Kedron. Okote sas jek maslinsko vrto, pa vo thaj lešće učenikurja dine ande leste. ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","A o Juda, izdajniko, džanglas pale godova than kaj o Isus okote često araćhelas pe pire učenikonenca. ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Askal o Juda lija pesa četa vojnikurja thaj e hramošće stražaren saven dine les e šorvale rašaja thaj e fariseja. Aresline ando maslinsko vrto e svetiljkenca, e bakljenca thaj e oružjesa. ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","O Isus džanglas sa so avela lesa, inkljisto korako angle lende thaj phučla: “Kas roden?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Von phendine lešće: “E Isuse andar o Nazaret.” A o Isus phendas lenđe: “Me sem.” Lenca ačhelas vi o Juda lesko izdajniko. ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Kana o Isus phendas lenđe “Me sem”, von crdine pe palpale thaj peline pe phuv. ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Askal o Isus palem phučla len: “Kas roden?” Von palem phendine: “E Isuse andar o Nazaret.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","O Isus phendas lenđe: “Phendem tumenđe: Me sem. Ali, ako man roden, mućen akalen save si manca te džantar.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Gajda phendas te pherdol okova so majsigo phendas: “Či hasardem nijećhe katar okola saven dijan man.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","A e Simone Petre sas mačo, pa inkaldale andar e fotrola thaj lesa peklas e šorvale rašaješće slugo thaj čhinda lesko kan. O sluga akhardolas Malh. ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ali o Isus phendas e Petrešće: “Bolde o mačo ande lešće korice. Dali te či pijav andar o tahtaj e patnje savi o Dad dija man?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Askal e četa vojnikurja, zajedno pire zapovednikosa thaj e hramošće stražasa astardine e Isuse thaj phangline les, ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","pa prvo inđardinele ko Ana, savo sas e Kajafasko sokro, a o Kajafa sas baro rašaj godova brš. ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","O Kajafa sas okova savo savetuilas e židovske vođen kaj si majlačhe te jek manuš merel pale sasto them. ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","O Simon Petar thaj još jek aver učeniko džanas palo Isus. Godole učeniko o baro rašaj lačhe pindžarelas, pa gajda šaj dijas andre ande avlija zajedno e Isuseja, ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","a o Petar ačhilo avri angle kapija. O aver učeniko saves pindžarelas o baro rašaj askal inkljisto thaj ćerda svato e sluškinjasa savi lelas sama ko vudar pa voj mukla e Petre andre ande avlija. ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Askal e sluškinja savi lelas sama po vudar phučla e Petre: “Naj san li vi tu jek katar okole manušešće učenikurja?” O Petar phendas: “Naj sem.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","A e sluge thaj e stražarja čhonas angar pe jag thaj ačhenas paše late te taton, kaj sas šil. Pa vi o Petar ačhelas okote lenca thaj tatolas. ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","A ande godoja vrjama o baro rašaj počnisarda te ispituil e Isuse pale lešće učenikurja thaj pale okova so sikavelas len. ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","O Isus phendas lešće: “Me javno mothavas e manušenđe. Uvek sikavavas ande sinagoge thaj ando Hramo kaj ćiden pe e Židovurja. Khanči či phendem čordane. ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Sostar phučes man? Phuč okolen save ašundine so phenavas lenđe. Von sigurno džanen so phenavas!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Kana o Isus godova phendas, jek katar e stražarja, savo ačhelas okote paše, peklale e palmasa prekal o muj thaj phendas: “Dali gajda ćerel pe svato e bare rašajesa?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","A o Isus phendas lešće: “Ako phendem vareso pogrešno, dokažisar kaj si pogrešno. A ako si godova kaj phendem ispravno sostar askal des man dab?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Askal o Ana bičhalda e Isuse phangle ko baro rašaj Kajafa. ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Dok o Simon Petar ačhelas paše jag thaj tatolas, phučline les: “Te naj san vi tu jek katar lešće učenikurja?” A o Petar hohada: “Naj sem.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Jek katar e bare rašaješće sluge, savo sas familija okole manušeja savešće o Petar čhinda o kan, phendas: “Či li dikhlem tut e Isuseja okote ando Maslinsko vrto?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","A o Petar palem hohada kaj nas thaj o bašno odma zakukuričisarda. ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Detharinako rano e Isuse inđardine andar e Kajafesko ćher ande palata ko rimsko upravniko. A e židovske vođe či dine ande palata, te či postanin obredno melale angle pashalno večera. ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Zato o Pilato inkljisto angle lende thaj phučla: “Pale soste prn akale manuše?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","A von phendine lešće: “Te akava manuš či avilosas zločinco, či predaisardamas les tuće.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Askal o Pilato phendas lenđe: “Len les tumen thaj sudin lešće pe tumaro zakon.” A e Židovurja phendine lešće: “Amen či tromas khonikas te mudaras.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Akava dogodisajlo te pherdol okova so o Isus phendas palo meripe saveja trubuja te merel. ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pale godova o Pilato bolda pe ande palata, akharda e Isuse, thaj phučla les: “Dali san tu caro e Židovengo?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","O Isus phendas: “Dali phenes godova korkoro tutar ili godova aver phendine tuće pale mande?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","O Pilato phendas: “Dali sem me Židovo? Ćiro them thaj e šorvale rašaja predaisardine tut manđe. Sostar? So ćerdan?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","O Isus phendas: “Mungro carstvo naj katar akava them. Kana mungro carstvo avilosas katar akava them, mungre sluge borisajlesas te či avav predaime e Židovske vođenđe. Ali mungro carstvo naj akatar!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Askal o Pilato phendas lešće: “Znači tu san o caro!” A o Isus phendas: “Gajda si sago kaj phenes: caro sem. Me pale akava bijandilem thaj pale akava avilem po them: te svedočiv palo čačipe. Ko god si katar o čačipe, ašunel mungro glaso.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","O Pilato phučla les: “A so si čačipe?” Askal palem inkljisto angle Židovske vođe thaj phendas lenđe: “Me či arakhav nisošći doš pe leste! ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","A tumaro si običaj te mukav tumenđe varekas kana si o prazniko Pasha. Dali kamen te mukav tumenđe e židovske caro?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ali von pe godova čhutine muj: “Na les, nego e Varava!” A o Varava sas razbojniko. ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Askal o Pilato dija te izbičuin e Isuse. ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","A e vojnikurja khudine kruna katar e kangre, čhutine e Isusešće po šoro thaj dine pe leste grimizno ogrtači. ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Askal avenas leste thaj phenenas: “Nek trajil o caro e Židovengo!” Gajda marenas muj lestar thaj denas les dab e palemnca po muj. ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","O Pilato palem inkljisto avri thaj phendas e Židovenđe: “Ake inkalav les angle tumende, ali te džanen kaj či arakhlem lešće nisošći doš.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Askal o Isus inkljisto avri, po šoro inđarelas khuvdi kruna katar e kangre thaj grimizno ogrtači pe dume, a o Pilato phendas: “Ake o manuš!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Kana dikhline les e šorvale rašaja thaj e hramošće stražarja, čhonas muj: “Razapnisar les! Razapnisar les!” A o Pilato phendas lenđe: “Tumen len les thaj razapnin les, kaj me či arakhlem pe leste nisošći doš.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","A e Židovske vođe phendine lešće: “Amen si amaro zakon, thaj pe amaro zakon vo moraš te merel, kaj tvrdilas kaj si e Devlesko Čhavo.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Kana o Pilato ašundas godova, još majbut darajlo. ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Bolda pe palem ande palata thaj phučla e Isuse: “Katar san?” Ali o Isus pe godova či phendas lešće khanči. ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","O Pilato askal phendas lešće: “Manca či kames te ćeres svato? Či džanes kaj si man vlast te mukav tut ili te razapniv tut po trušul?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","O Isus phendas lešće: “Či avilosas tut nisošći vlast pe mande te či avilosas tuće dini e Devlestar. Andar godova si majbaro bezeh okolesko savo tuće ande vas dija man.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Katar askal o Pilato dićhelas te oslobodil les. Ali e Židovske vođe čhonas muj: “Te muklan godole manušes, naj san drugari e rimsko carošće! Ko god phenel pala peste kaj si caro, protivil pe e rimsko carošće.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Kana godova ašundas, o Pilato inkalda e Isuse avri thaj bešlo pe sudačko stolica, po than savo akhardol Baruno pločnik, pe židovsko čhib: Gavata. ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","A sas o đes kana pripremilas pe pale Pasha, varekaj katar o mismeri. O Pilato phendas e Židovenđe: “Ake tumaro caro!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","A e Židovurja čhonas muj: “Mudar les, mudar les! Razapnisar les po trušul!” O Pilato phučla len “Te tumare caro razapniv po trušul?” A e šorvale rašaja phendine lešće: “Amen naj aver caro. Amaro caro si o rimsko caro!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Askal o Pilato dija e Isuse ke vojnikurja te razapnin les po trušul. Askal e vojnikurja line e Isuse. ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","O Isus korkoro inđarelas pesko trušul dži ko than savo akhardolas Lobanja, a pe židovsko čhib akhardo Golgota. ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Okote razapnisardine e Isuse po trušul. A lesa sas razapnime po trušul još duj džene, jek katar lešći jek rig, aver katar lešći aver rig, a o Isus sas maškare. ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","O Pilato dija te ramol pe natpis thaj te čhol pe po trušul. Po natpis sas ramome: “Isus Nazarećanin, caro e Židovengo.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Akava natpis čitosardine e but Židovurja, kaj o than kaj o Isus sas razapnime po trušul sas paše ko gav. O natpis sas ramome pe židovsko, latinsko thaj grčko čhib. ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","E židovske šorvale rašaja phendine e Pilatošće: “Na te ramos: ‘caro e Židovengo’, nego phen: kaj vo korkoro pale peste phenelas kaj si caro e Židovengo.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","A o Pilato phendas lenđe: “So ramosardem – ramosardem!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Kana razapnisardine e Isus po trušul, e vojnikurja line lešće drze thaj podelisardine pe štar delurja – pale svako vojniko po kotor. Line vi lesko gad, ali pe leste nas šavurja, kaj sas ćerdo katar opral dži tele ande jek kotor. ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Askal phendine jek avrešće: “Ajde te na pharavas o gad, nego te čhudas kocka pale leste te dikhas kasko avela.” Akava sas te pherdol so sas ramome ando Sveto lil: “Mungre drze podelisardine maškar pende thaj čhudine e kocka pale mungre patave.” Thaj e vojnikurja gajda ćerdine. ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","A paše Isusesko trušul ačhenas lešći dej, laći phen, e Marija e Klopešći romnji thaj e Marija andar e Magdala. ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Kana o Isus dikhla pire deja thaj e učeniko saves but volilas sar ačhel paše late, phendas pire dejaće: “Manušnjije, ake tuće čhavo.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Askal phendas e učenikošće: “Ake tuće dej.” Thaj katar godova časo o učeniko lija lat ande piro ćher. ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Posle godova, o Isus džanelas kaj si sa gata. Ali te potpuno pherdol so sas ramome ando Sveto lil, phendas: “Trušalo sem.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","A okote, ačhelas o čaro pherdo šut. Line o sunđer savo ćinđardine ande godova šut, pusadine pe stabiljka katar o isop thaj čhutine ke Isusesko muj. ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Kana o Isus okusisarda o šut, phendas: “Gata si.” Askal haradilo lesko šoro thaj mukla pesko đi. ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","A sar sas Đes pale priprema, e židovske vođe zamolisardine e Pilato, te okolenđe kaj sas vazdine po trušul te phađen pe lenđe pungre te majsigo meren thaj fuljaren pe katar o trušul, sar lenđe tela či ačhilesas po trušul prekal o savato. Godova savato sas Baro prazniko. ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Thaj e vojnikurja aviline thaj phagline e pungre e prvo thaj vi e dujto manušešće save sas razapnime e Isuseja. ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Kana aviline dži ko Isus, dikhline kaj već mulo, thaj či phagline lešće pungre, ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","nego jek katar e vojnikurja e kopljesa pusadas lešće pašvare. Thaj andar e rana odma teljardas o rat thaj o paj. ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Godova svedočil okova savo godova dikhla thaj lesko svedočanstvo si čačutno. Vo džanel kaj mothol čačipe, thaj svedočil te vi tumen paćan. ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Akava sas te pherdol o Sveto lil: “Nijek kokalo či avela lešće phago.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","A pe jek aver than o Sveto lil phenel: “Dićhena okoles saves pusadine.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Posle godova o Josif andar e Arimateja manglas katar o Pilato te inđarel e Isusesko telo. O Josif sas e Isusesko učeniko, ali na javno kaj daralas katar e židovske vođe. O Pilato dija les thaj gajda o Josif avilo thaj inđardas e Isusesko telo. ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","A avilo vi o Nikodem, okova savo majsigo avilo e Isuseste raćava, thaj andas varekaj katar trijanda literja hamime smirna thaj aloja. ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Askal line e Isusesko telo thaj paćardine les ando mirisno pohtan sago kaj sas o židovsko običaj kana prahonas e mulen. ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","A ko than kaj sas o Isus razapnime sas o vrto, thaj ando vrto nevo limori ande savo još khonik nas prahome. ");
INSERT INTO rmyChergash_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Zbog godova kaj sas o židovsko Đes pale priprema, trubujine te siđaren a zato kaj sas o limori paše, čhutine e Isusesko telo ande leste. ");
INSERT INTO rmyChergash_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Detharinako rano prvo đes ando kurko, dok sas još tunjariko e Marija andar e Magdala avili po limori thaj dikhla kaj si o bar katar o ulazo po limori lino majdur. ");
INSERT INTO rmyChergash_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Askal prastaja dži ko Simon Petar thaj ko aver učeniko saves o Isus but volilas thaj phendas lenđe: “Inđardine e Gospodesko telo andar o limori thaj či džanav kaj čhutine les!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Askal o Petar thaj okova aver učeniko inkljistine thaj teljardine karingal o limori. ");
INSERT INTO rmyChergash_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Liduj džene prastenas zajedno, ali okova aver učeniko sas majbrzo katar o Petar thaj prvo areslo dži ko limori. ");
INSERT INTO rmyChergash_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Banđilo thaj dikhla andre o pohtan katar o lano sar pašljon ando limori, ali či dijas andre. ");
INSERT INTO rmyChergash_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Askal pale leste areslo vi o Simon Petar, pa dija ando limori thaj vi vo dikhla o pohtan savo pašljolas okote, ");
INSERT INTO rmyChergash_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","thaj o dikhloro savo sas pe Isusesko šoro či pašljolas zajedno e pohtanesa, nego sas odvojime thaj paćardo pe jek rig. ");
INSERT INTO rmyChergash_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Askal dija andre vi okova aver učeniko, savo prvo areslo po limori, dikhla thaj paćajas. ");
INSERT INTO rmyChergash_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Kaj von još či haćardine andar o Sveto lil kaj o Isus trubul te uštel andar e mule. ");
INSERT INTO rmyChergash_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Pale godova e učenikurja boldine pe ke pire manuša. ");
INSERT INTO rmyChergash_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","A e Marija ačhelas avri anglo limori thaj rovelas. Sa ande jasva, zavirisarda ando limori ");
INSERT INTO rmyChergash_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","thaj dikhla e duj anđelurja sa ando parno sar bešen po than kaj sas e Isusesko telo, jek po than kaj sas e Isusesko šoro a aver po than kaj sas lešće pungre. ");
INSERT INTO rmyChergash_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","E anđelurja phučline lat: “Manušnjije, sostar roves?” A e Marija phendas lenđe: “Inđardine mungre Gospode thaj či džanav kaj čhutine les!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Kana phendas godova, bolda pe thaj dikhla e Isuse sar ačhel, ali či pindžarda kaj si godova vo. ");
INSERT INTO rmyChergash_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","O Isus phučla lat: “Manušnjije, sostar roves? Kas rodes?” Voj gndisarda kaj si godova o baštovano, thaj phendas: “Raja, ako tu inđardan les, phen manđe kaj čhutan les, me džava pale leste thaj lava les.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Askal o Isus phendas laće: “Marijo!” Voj bolda pe thaj phendas lešće pe židovsko čhib: “Raboni!”, so značil: “Učiteljina!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","O Isus phendas laće: “Na inćar man akate, kaj još či đelem opre, ko Dad. Nego dža ke mungre phral thaj phen lenđe: ‘Džav opre, ke mungro Dad thaj ke tumaro Dad, ke mungro Del thaj ke tumaro Del.’ ” ");
INSERT INTO rmyChergash_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Thaj e Marija andar e Magdala đeli thaj javisardas e učenikonenđe: “Dikhlem e Gospode.” Thaj phendas lenđe okova so o Isus phendas laće. ");
INSERT INTO rmyChergash_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Talerjat, godova prvo đes ando kurko, ando ćher ande savo sas e učenikurja zajedno, sa e vudara sas phandade e daratar katar e Židovske vođe. O Isus pojavisajlo, ačhilo maškar lende thaj phendas lenđe: “Miro tumenđe!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Kana godova phendas lenđe, sikada lenđe e ožiljkurja pe pire vas thaj pe pire pašvare. E učenikurja raduisajle kana dikhline e Gospode. ");
INSERT INTO rmyChergash_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Askal o Isus palem phendas lenđe: “Miro tumenđe! Sago kaj o Dad bičhaldas man, gajda vi me bičhalav tumen.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Kana phendas godova, phurdas pe lende thaj phendas: “Primin e Sveto Duho! ");
INSERT INTO rmyChergash_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Thaj kašće jarton e bezeha, jartome si lenđe, a kašće či jarton e bezeha, naj lenđe jartome.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","A o Toma, jek katar e Dešuduj učenikurja, saves akharenas Blizanco, nas lenca kana avilo o Isus. ");
INSERT INTO rmyChergash_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Aver učenikurja phendine lešće: “Dikhlam e Gospode!” A o Toma phendas lenđe: “Či paćava sa dok či dikhav e ožiljkurja katar e krafina ande lešće vas, thaj ande lende čhav mungro naj, thaj dok či čhav mungro naj ande lešće pašvare.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ohto đes majposle, lešće učenikurja sas palem zajedno ando ćher thaj vi o Toma sas lenca. Vi ako sas o vudar zaključime, o Isus avilo, ačhilo maškar lende thaj phendas lenđe: “Miro tumenđe!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Askal phendas e Tomašće: “Čho ćiro naj akaring thaj dik mungre vas! Inzar ćiro vas thaj čho ćiro naj ande mungre pašvare! Thaj na av majbut bi paćivalo, nego paća!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","A o Toma phendas lešće: “Mungro Gospod thaj mungro Del!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Askal o Isus phendas lešće: “Tu paćas zato kaj dikhlan man. Ali blago okolenđe save paćan a či dikhline man.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","A o Isus angle pire učenikurja ćerda još but aver čudesne znakurja save naj ramome ande akava lil. ");
INSERT INTO rmyChergash_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ali akava si ramome te paćan kaj o Isus si o Hristo, Čhavo e Devlesko thaj te gajda kaj paćan ande leste, avel tumen večno trajo ande lesko alav. ");
INSERT INTO rmyChergash_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","O Isus posle godova palem sikada pe pire učenikonenđe po Tiverijadsko jezero. A sikadilo lenđe agajda: ");
INSERT INTO rmyChergash_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","O Simon Petar, o Toma akhardo Blizanco, o Natanail andar o gav Kana Galilejaći, e Zevedejevešće čhave thaj još aver duj e Isusešće učenikurja sas zajedno. ");
INSERT INTO rmyChergash_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","O Simon Petar phendas lenđe: “Džav te astarav mačhe.” A von phendine: “Džas vi amen tusa.” Inkljistine avri, dine ando čamco, ali godoja rjat khanči či astardine. ");
INSERT INTO rmyChergash_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","A rano ande detharin, o Isus ačhelas pe obala, ali e učenikurja či pindžardine kaj si godova vo. ");
INSERT INTO rmyChergash_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Askal o Isus phučla len: “Čhavoralen, dali astardine vareso?” A von phendine: “Či astardam khanči.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","A o Isus phendas lenđe: “Čhuden e mreža pe desno rig katar o čamco thaj astarena.” Von ćerdine gajda thaj astardine gaći mačhe kaj našti crdenas e mreža katar e but mačhe save astardine. ");
INSERT INTO rmyChergash_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Askal okova učeniko saves o Isus but volilas phendas e Petrešće: “Godova si o Gospod.” Kana o Simon Petar ašundas kaj si godova o Gospod, učharda pe kaj sas gata nango, thaj huklas ando jezero. ");
INSERT INTO rmyChergash_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","A okola aver učenikurja avile e čamcosa. Crdenas e mreža e mačhenca pe obala, kaj e obala nas lendar dur, varekaj katar šel meterja. ");
INSERT INTO rmyChergash_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Kana inkljistine pe obala, dikhline već ćerdi jag katar o angar thaj pe late čhutino mačho thaj mangro. ");
INSERT INTO rmyChergash_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","O Isus phendas lenđe: “Anen varekozom e mačhe katar akala save akana astardine.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Askal o Simon Petar dija ando čamco thaj inkalda pe obala e mreža savi sas pherdi bare mačhe, šel thaj pandžvardeš thaj trin kotora. Ali vi ako sas gaći but, e mreža či pharadili. ");
INSERT INTO rmyChergash_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","A o Isus phendas lenđe: “Aven doručkujin”, a ni jek učeniko či usudisajlo te phučel les: “Ko san tu?” kaj džanenas kaj si vo o Gospod. ");
INSERT INTO rmyChergash_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Askal o Isus avilo majpaše, lijas o mangro thaj dija len, a gajda vi o mačho. ");
INSERT INTO rmyChergash_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Sas godova trito data sar o Isus sikadilo pire učenikonenđe sar uštilo andar mule. ");
INSERT INTO rmyChergash_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Kana haline, o Isus phučlas e Simone Petre: “Simone, čhaveja e Jovanesko, dali volis man majbut katar akala?” A o Petar phendas “Ej, Gospode, tu džanes kaj voliv tut.” A o Isus phendas lešće: “Pravar mungre bakhroren.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Askal o Isus phučla les po dujto drom: “Simone, čhaveja e Jovanesko, dali volis man?” A o Petar phendas lešće: “Ej, Gospode, tu džanes kaj voliv tut.” A o Isus phendas lešće: “Le sama pe mungre bakhre.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Askal o Isus phučla les po trito drom: “Simone, čhaveja e Jovanesko, dali volis man?” O Petar sas žalosno kaj po trito drom phučel les: “Volis man?” thaj phendas lešće: “Gospode, tu sa džanes thaj džanes kaj voliv tut.” A o Isus phendas lešće: “Pravar mungre bakhren. ");
INSERT INTO rmyChergash_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Čače, čače phenav tuće: kana sanas majterno korkoro šaj phandavejas ćiri haravlji thaj džajas kaj kamejas. Ali, kana aveja phuro, buljareja ćire vas thaj aver phandavena tut thaj inđarena tut okoring kaj tu či kameja.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","O Isus akava phendas te sikavel save smrtosa o Petar proslavila e Devles. Askal phendas lešće: “Av pale mande!” ");
INSERT INTO rmyChergash_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","A o Petar bolda pe thaj dikhla e učeniko saves o Isus but volilas sar džalas pale lende, okoles savo pe večera avilo e Isuseste majpaše thaj phučla les: “Gospode, ko si ćiro izdajniko?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Sar o Petar dikhla les, phučlas e Isuse: “Gospode, a so avela lesa?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","O Isus phendas lešće: “Ako me kamav te vo ačhel džudo dok me či boldav man, so godova tut hal briga? Tu samo av pale mande.” ");
INSERT INTO rmyChergash_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Gajda maškar e phral buljarda pe o svato kaj godova učeniko či merela. Ali o Isus či phendas kaj vo či merela, nego: “Ako me kamav te vo ačhel džudo dok me či boldav man, so godova tut hal briga?” ");
INSERT INTO rmyChergash_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Akava si o učeniko savo svedočil pale akava, vo akava ramosarda thaj amen džanas kaj lesko svedočanstvo si čačutno. ");
INSERT INTO rmyChergash_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","A si još but godova so o Isus ćerda, a kana sa po redo avilosas ramome, gndiv kaj ando sasto them či ačhile sas e knjige save avile sas ramome.");
INSERT INTO rmyChergash_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Poštuime Teofile, ande mungri prvo knjiga ramosardem sa so o Isus počnisarda te ćerel thaj te sikavel, ");
INSERT INTO rmyChergash_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","sa dži ko đes kana sas vazdino ando nebo, pošto kroz o Sveto Duho dijas upute pire apostolenđe save izaberisardas. ");
INSERT INTO rmyChergash_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Nakon piro smrto o Isus dijas but dokazurja kaj si džudo. Sikavelas pe e apostolenđe štarvardeš đesa thaj motholas lenđe pale Devlesko carstvo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Jekhar, dok sas još lenca, o Isus zapovedisardas lenđe: “Na durjon andar o Jerusalim, nego ažućaren te pherdol e Dadesko obećanje pale savo majsigo mothavas tumenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Kaj o Jovano bolelas e pajesa, a tumen pale varekazom đesa avena bolde e Sveto Duhosa.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Askal okola kaj sas ćidine oko leste phučline les: “Gospode, dali tu akana ande akaja vrjama obnovija o Izraelsko carstvo?” ");
INSERT INTO rmyChergash_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","A o Isus phendas lenđe: “Naj tumaro te džanen e vrjame ili e datume save o Dad odredisardas ande piri vlast. ");
INSERT INTO rmyChergash_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ali kana fuljela pe tumende o Sveto Duho, primina sila te svedočin pale mande ando Jerusalim, thaj pe sasti Judeja thaj ande Samarija thaj sa dži ko krajo e phuvjako.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Thaj kana phendas godova, sas vazdino po nebo angle lenđe jakha, a o oblako garadale lenđe jakhendar. ");
INSERT INTO rmyChergash_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Thaj dok još sas lenđe jakha vazdine ando nebo kaj o Isus džalas, andar jekhar ačhile paše lende duj manuša ande blistavo parne drze. ");
INSERT INTO rmyChergash_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Phendine lenđe: “Manušalen andar e Galileja, sostar ačhen akate thaj dićhen ando nebo? Akava Isus, savo si tumendar vazdino ando nebo, boldela pe isto gajda sago kaj dikhline kaj đelotar po nebo!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Askal boldine pe ando Jerusalim katar e gora, savi akhardolas Maslinsko, a sas dur katar o Jerusalim varekaj katar jek kilometar. ");
INSERT INTO rmyChergash_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Kana aresline ando ćher kaj bešenas, line pe opre ande soba, a sas okote o Petar, o Jovan, o Jakov, o Andrija, o Filip, o Toma, o Vartolomej, o Matej, o Jakov (e Alfejevesko čhavo), o Simon (saves akharenas pobunjeniko) thaj o Juda (e Jakovesko čhavo). ");
INSERT INTO rmyChergash_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Savora von istrajno thaj jek dušava molinas pe zajedno još varesave manušnjenca. Maškar lende sas vi e Isusešće dej thaj lešće phral. ");
INSERT INTO rmyChergash_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Godola đesa uštilo o Petar maškar e učenikurja, a sas ćidino o them varekaj katar šel thaj biš manuša thaj phendas: ");
INSERT INTO rmyChergash_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Phralalen, trubuja te pherdol okova so si ramome ando Sveto lil palo Juda, savo andas okolen kaj astardine e Isuse. Kaj godova dumut phendas o Sveto Duho kroz e carosko Davidesko muj. ");
INSERT INTO rmyChergash_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Kaj o Juda sas jek amendar thaj sas les talo ande apostolsko služba.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(O Juda e lovenca save dobisardas pale pesko bilačho delo steknisardas njiva, ali pelo tele po šoro thaj lesko telo pharlo pe opaš thaj lešće pora čhordile. ");
INSERT INTO rmyChergash_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Akava si pindžardo sa e manušenđe save trajin ando Jerusalim, gajda kaj godoja njiva sas akhardi pe lenđi čhib Akeldamah so značil: “Ratvali njiva.”) ");
INSERT INTO rmyChergash_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Kaj ramome si ande knjiga e psalmenđi: ‘O ćher lesko neka avel pusto, neka khonik či trajil ande leste!’ thaj: ‘Neka lešći služba dobil aver manuš.’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Trubul, dakle, te izabirisaras jećhe katar okola manuša kaj sas amenca sa e vrjama, katar o đes kana o Gospod Isus avilo maškar amende thaj dži ko o đes kana đelotar amendar, ");
INSERT INTO rmyChergash_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","katar e vrjama kana o Jovano teljardas te bolel, pa dži ko đes kana o Isus sas vazdino amendar po nebo. Kasavo manuš nek avel amenca svedoko kaj o Isus uštilo andar e mule.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Askal line duje manušen: e Josife saves akharenas Varsava, a savo sas pindžardo vi po alav Just, thaj e Matija. ");
INSERT INTO rmyChergash_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Askal molisajle e Devlešće akale alavenca: “Gospode, tu pinđares savorenđe ile. Sikav amenđe saves izaberisardan katar akala duj ");
INSERT INTO rmyChergash_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","te lel akaja apostolsko služba savi o Juda mukla – thaj đelo okote kaj pripadil.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Askal čhudine kocka pale lende thaj e kocka peli po Matija, savo sas đinado sago dešudujto apostol. ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Kana avilo o prazniko Pedesetnica, o pandžvardešto đes palo prazniko Pasha, sa e apostolurja sas ćidine pe jek than. ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Katar jekhar andar o nebo ašundili varesavi huka, sago kana phurdel e bari balval, thaj pherdas sasto ćher ande savo bešenas. ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Thaj dikhline vareso slično sago jagaće čhibja, save podelisajle thaj fuljistine pe svakoneste lendar. ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Thaj savora pherdile e Sveto Duhosa thaj počnisardine te ćeren svato aver čhibjenca, sar o Duho delas len te ćeren svato. ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","A ande godoja vrjama ando Jerusalim sas e pobožne Židovurja save aviline andar svako krajo e themesko talo nebo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Kana ašundine godova zvuko, o but o them ćida pes okote zbunime. Kaj svako lendar ašundas sar ćeren svato lešće čhibjava. ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Savora sas zadivime, thaj začudime phučenas: “Dik, naj li akala kaj ćeren svato sa Galilejcurja? ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Pa sar askal svako amendar ašunas len kaj ćeren svato pe amari čhib. ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","A akate maškar amende si amen Parćanurja, Međanurja, Elamcurja, manuša andar e Mesapotamija, Judeja, Kapadokija, Ponta, Cikni Azija, ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigija, Pamfilija, Egipto thaj andar e libijske krajurja oko e Kirina, thaj okola andar o Rimo ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","– e Židovurja thaj okola save obratisajle pe židovsko paćipe – e Krićanurja thaj e Arapurja. Savora amen ašunas akale manušen sar pe amare čhibja ćeren amenđe svato pale Devlešće bare dela!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Savora sas zadivime, thaj zbunime phučenas jek avres: “So akava značil?” ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","A aver palem marenas muj e alavenca: “Ma, matile von katar e gugli mol!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Askal o Petar inkljisto anglal, zajedno e dešujeće apostolenca thaj glasno phendas lenđe: “Židovurja thaj vi tumen savora save sen ando Jerusalim, čhon kan ke mungre alava. Thaj akava te džanen: ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Akala manuša naj mate, sago kaj tumen gndin, kaj tek si inja saturja detharinako rano. ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Nego akava so dićhen si okova pale soste phenelas o proroko Joil: ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Phenel o Del: ‘Ande poslednje đesa, izliva mungro Duho pe sa e manuša. Tumare čhave thaj tumare čheja prorokuina, thaj tumare terne čhaven avela vizije, a tumare phure dićhena sune. ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ande godola đesa izliva mungro Duho vi pe mungre sluge thaj pe mungre sluškinje thaj vi von prorokuina. ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ćerava čudurja opre po nebo thaj e znakurja tele pe phuv: o rat, e jag thaj e oblakurja katar o thuv. ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","O kham pretvorila pe ando tunjariko, a o čhon avela lolo sago o rat majsigo nego so avela o baro thaj o pindžardo đes e Gospodesko. ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Thaj svako ko akharel ando pomoć o alav e Gospodesko avela spasime.’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Manušalen andar o Izrael, ašunen akala alava: O Isus andar o Nazaret sas manuš saves o Del bičhaldas, thaj godova jasno potvrdisarda e bare delenca, e čudenca thaj e znakonenca, save sar vi korkoro džanen, o Del kroz leste ćerda maškar tumende. ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Godova manuš, o Isus, sas predaime ande tumare vas e Devlešće odlukava thaj prema e Devlesko plano saves majanglal zamislisardas. A tumen, zajedno e bidevlešće manušenca, prikuisardine les po trušul thaj mudardine les. ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ali o Del vazda les andar e mule thaj oslobodisarda les katar e bare smrtne muke. Kaj o smrto našti inćarda les ande piri vlast. ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","O caro David palo Isus phendas: ‘O Gospod si uvek angle mungre jakha. Pošto si vo pe mungri desno rig, khanči či uznemirila man. ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Zato mungro ilo raduil pe, thaj mungri čhib e bahtatar čhol muj. Čak vi mungro telo trajila ande nada. ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Kaj či mućeja mungri duša maškar e mule, niti deja te ćiro sveco ćernjol. ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Sikadan manđe e droma e trajošće. Pherdo bah angle tute avava.’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Phralalen mungralen, pouzdano šaj phenav tumenđe pale amaro pradad o David: vo mulo thaj prahome si. Lesko limori si akate maškar amende sa dži ađes. ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ali sar o David sas proroko, džanglas kaj o obećanje savo o Del dija les kroz e solah, kaj jek đes čhola pe lesko prestolje jećhe katar lešće potomkurja. ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Vo godova majanglal dikhla thaj phendas pale Hristosko vaskrsenje: ‘Vo naj muklino maškar e mule niti lesko telo ćernjilo ando limori.’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","O Del godole Isuse vazdas andar e mule, a savora sam svedokurja pale godova. ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Thaj akana si vazdino pe počasno desno rig e Devlešće, vo e Dadestar primisardas o obećanje e Sveto Duhos te izlil les pe amende. Thaj akana godova dićhen thaj ašunen. ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Kaj o David nas vazdino ando nebo, nego korkoro phenel: ‘Phenel o Gospod mungre Gospodešće: “Beš pe mungri počasno desno rig ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","dok či čhav ćire dušmajen tale ćire pungre. ”’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Zato neka sa o them andar o Izrael pouzdano džanel kaj godova Isus, saves tumen razapnisardine, o Del ćerda te avel Gospod thaj Hristo!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Kana e manuša godova ašundine, zurale čhinda len ando ilo thaj phučline e Petre thaj e aver apostolen: “Phralalen, so te ćeras?” ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","O Petar phendas lenđe: “Pokajin tumen katar o bezeh thaj neka svako tumendar bolel pe ando alav e Isuse Hristosko te aven jartome tumare bezeha, thaj te primina o daro e Sveto Duhos. ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kaj o Del akava obećisarda tumenđe thaj tumare čhavrenđe thaj pale sa okola save si dur, saven amaro Gospod o Del akharel peste.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","O Petar još vi aver alavenca strogo opominjilas len thaj molilas len e alavenca: “Spasin tumen katar o sudo savo avel pe akava rumome naraštaj!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Askal okola save prihvatisardine lešći poruka boldine pe, a godova đes pridružisajlo e vernikonenđe varekaj katar trin milje manuša. ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Thaj sa e učenikurja ačhiline paćivale ande apostolsko sikavipe, družinas pe, phađenas o mangro thaj molinas pe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Thaj e dar lija svakone manuše, zato kaj o Gospod kroz e apostolurja ćerelas but čudurja thaj znakurja. ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","A savora okola save paćajine sas zajedno thaj delinas sa so sas len. ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Bićinenas sa so sas len thaj e love delinas svakonešće kozom kas trubulas. ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Thaj svako đes zajedno jek dušava ćidenas pe ando Hramo. A pe ćhera ćidenas pe te phađenas o mangro thaj zajedno hanas iskreno thaj e bahtale ileja. ");
INSERT INTO rmyChergash_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Hvalinas e Devles thaj poštuilas len sa o them. A o Gospod svako đes anelas lenđe okolen save spasisajle. ");
INSERT INTO rmyChergash_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Kana jekhar o Petar thaj o Jovano džanas ando Hramo pe molitva, ande trin saturja palo mismeri, ");
INSERT INTO rmyChergash_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","varesave manuša inđarenas jećhe manušes savo sas bango katar piro bijandipe. Svako đes čhonas les anglo Hramosko vudar savo akhardolas Divna, te prosil katar okola manuša kaj avenas ando Hramo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Kana dikhla e Petre thaj e Jovane kaj kamen te den ando Hramo, manglas lendar love. ");
INSERT INTO rmyChergash_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","A o Petar e Jovanova lačhe dikhla pe leste thaj phendas lešće: “Dik pe amende.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","O bango manuš lačhe dikhla pe lende, kaj ažućarelas te vareso dobil lendar. ");
INSERT INTO rmyChergash_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","A o Petar phendas lešće: “Naj man ni rup ni sunakaj, ali okova so si man godova dav tut: ando alav e Isuse Hristosko andar o Nazaret, ušti thaj phir!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","O Petar askal astardas e manušes palo desno vas thaj vazda les. Ande godova časo e manušešće stopala thaj lešće zgloburja pe pungre odma zurajle, ");
INSERT INTO rmyChergash_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","a o manuš huklo pe pešće pungre thaj ačhilo te phirel. Askal dija lenca ando Hramo, phirelas, hutelas thaj slavilas e Devles. ");
INSERT INTO rmyChergash_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Sa e manuša dikhline les sar phirel thaj ašunenas sar slavil e Devles. ");
INSERT INTO rmyChergash_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Kana pindžardine kaj si vo okova isto manušes savo bešelas pašo Hramsko vudar savo akhardolas Divna thaj prosilas, sas but začudime thaj zadivime zbog godova so sas lešće. ");
INSERT INTO rmyChergash_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Sar o manuš či durjolas katar o Petar thaj katar o Jovano, sa o them začudime prastajine lende ando Solomonosko tremo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Kana o Petar godova dikhla phendas e themešće: “Izraelcurja, sostar akava čudil tumen? Sostar dićhen ande amende sago kaj amen amare snagava ili godoleja kaj sam pobožne ćerdam te akava manuš phirel? ");
INSERT INTO rmyChergash_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","O Del e Avraamesko, e Isakosko thaj e Jakovesko, o Del amare pradadengo, proslavisarda pire slugas e Isuse, saves tumen dine te avel mudardo thaj odreknisardine tumen lestar anglo Pilato kana vo već odlučisarda te mućel les. ");
INSERT INTO rmyChergash_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Odreknisardine tumen katar o Isus savo sas Sveco thaj Pravedniko, a mangline te mućel pe tumenđe o ubica. ");
INSERT INTO rmyChergash_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Tumen mudardine e Isuse kastar avel o trajo, ali o Del vazda les andar e mule, pale soste sam amen svedokurja. ");
INSERT INTO rmyChergash_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Zbog o paćipe ande Isusesko alav zurajlo akava manuš saves tumen pindžaren thaj kas akana dićhen. O paćipe ando Isus ćerda akale manušes te avel potpuno sasto, sago kaj vi korkoro šaj dićhen. ");
INSERT INTO rmyChergash_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Phralalen, džanav kaj tumen sago vi tumare poglavarja ćerdine akava e Isuseja ando bidžanglipe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","O Del gajda pherdas okova so majsigo phendas kroz o muj sa e prorokonengo – kaj lesko Hristos patila. ");
INSERT INTO rmyChergash_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Zato pokajin tumen thaj obratin tumen e Devlešće te jartol pe tumenđe tumare e bezeha, ");
INSERT INTO rmyChergash_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","askal avela tumenđe katar o Gospod e vrjama palo duhovno odmor thaj o Gospod palem bičhalela tumenđe e Isuse, saves već odredisardas te avel Hristo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Vo moraš te ačhel ando nebo sa dok či avel e vrjama kana o Del sa obnovila. Pale godova o Del još dumut mothodas kroz pire svete prorokurja. ");
INSERT INTO rmyChergash_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Kaj o Mojsije phendas: ‘O Gospod, tumaro Del, vazdela tumenđe prorokos katar tumaro them sago kaj sem me. Leste čhon kan ande sa so phenel tumenđe! ");
INSERT INTO rmyChergash_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","A ko god či čhola kan ke godova proroko, neka avel iskorenime andar o them!’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Thaj sa e prorokurja save mothonas, katar o Samuilo thaj katar okola posle leste, najavinas akala đesa. ");
INSERT INTO rmyChergash_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Tumen sen naslednikurja palo obećanje saves o Del dijas prekal e prorokurja thaj tumen sen učesnikurja ando savez saves o Del sklopisardas tumare pradadenca, kaj o Del phendas e Avraamešće: ‘Ćiro potomko avela blagoslov sa e themenđe pe phuv.’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","O Del vazdas pire slugas e Isuse thaj prvo bičhalda les tumenđe te blagoslovil tumen thaj te odvratil tumen katar tumaro bilačhipe.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Dok o Petar thaj o Jovano još ćerenas svato e themešće, aviline dži lende e rašaja, o zapovedniko e hramošće stražako thaj e sadukeja. ");
INSERT INTO rmyChergash_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Holjajle pe lende kaj o Petar thaj o Jovano sikavenas thaj objavinas kaj kroz o Isus si o vaskrsenje andar e mule. ");
INSERT INTO rmyChergash_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Astardine len thaj čhudine len ande tamnica dži thejara o đesa, kaj sas već e rjat. ");
INSERT INTO rmyChergash_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","A but katar okola save ašundine e Petrešći poruka paćajine thaj gajda o brojo okolengo save paćanas barilo varekaj dži ke pandž milje samo muškarcurja. ");
INSERT INTO rmyChergash_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Thejara o đes ando Jerusalim sastaisajle e židovske šorvale, e starešine thaj e učitelja e zakonestar. ");
INSERT INTO rmyChergash_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Okote sas vi o prvo rašaj o Ana, o Kajafa, o Jovano, o Aleksandar thaj vi aver andar e prvo rašajenđi familija. ");
INSERT INTO rmyChergash_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Von inkaldine e apostolen angle peste thaj phučline len: “Save snagava thaj ande kasko alav akava ćerdine?” ");
INSERT INTO rmyChergash_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Askal o Petar pherdo e Sveto Duhosa phendas lenđe: “E themešće starešinenđe thaj e šorvalenđe! ");
INSERT INTO rmyChergash_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ako sam amen ađes inkalde angle tumende te ispituin amen pale godova kaj ćerdam lačho delo e nasvale manušešće thaj phučen men sar vo sastilo, ");
INSERT INTO rmyChergash_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","askal džanen tumen, thaj sasto Izraelsko them kaj akava manuš ačhel angle tumende zato kaj sastilo prekal o alav e Isuse Hristosko andar o Nazaret, saves tumen razapnisardine, a saves o Del vazdas andar e mule. ");
INSERT INTO rmyChergash_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","O Isus si: ‘bar saves tumen e zidarja odbacisardine, a savo postanisardas e temeljesko bar.’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Thaj naj spasenje ni ande jek aver alav, kaj e manušenđe naj dino ni jek aver alav pe sasti phuv prekal savo šaj spasi men.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Kana dikhline kaj o Petar thaj o Jovano či daran thaj kana haćardine kaj si von obične manuša save nas posebno sikade kroz o sveto Lil, začudisajle. Džangline kaj von sas e Isuseja, ");
INSERT INTO rmyChergash_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ali sar dikhline kaj o manuš savo sastilo ačhelas okote lenca, ačhiline bi alavesko. ");
INSERT INTO rmyChergash_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Askal naredisardine e Petrešće thaj e Jovanošće te inkljen avri andar o Veće thaj počnisardine te dogovorin pe maškar pende. ");
INSERT INTO rmyChergash_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Phendine: “So te ćeras akale manušenca? Kaj, savora save trajin ando Jerusalim džanen kaj kroz lende dogodisajlo baro čudo thaj amen našti phenas kaj nas godova. ");
INSERT INTO rmyChergash_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ali, te akava sikavipe či buljol još majbut maškar o them, zapretisa lenđe te khonikašće majbut či ćeren svato ande godova alav.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Askal akhardine len, thaj naredisardine lenđe te nipošto majbut ni o muj či putren thaj sikaven ande Isusesko alav. ");
INSERT INTO rmyChergash_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ali o Petar thaj o Jovano phendine lenđe: “Zar smatrin kaj si pravo anglo Del te čhas kan tumende, a na ko Del? ");
INSERT INTO rmyChergash_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","A amen našti te či ćeras svato pale okova so dikhlam thaj so ašundam.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","E manuša andar e većnica palem zapretisardine lenđe, thaj mukline len. Pošto našti odlučisardine sar te kaznin len kaj sa o them slavilas e Devle pale okova so dogodisajlo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Kaj, o manuš savo čudesno sastilo sas les majbut katar štarvardeš brš. ");
INSERT INTO rmyChergash_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Čim mukline e Petre thaj e Jovane von boldine pe ke aver vernikurja thaj phendine lenđe sa so phendine lenđe e prve rašaja thaj e starešine. ");
INSERT INTO rmyChergash_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Kana e vernikurja godova ašundine, savora zajedno ande jek glaso molisajle e Devlešće: “Gospode, tu stvorisardan o nebo, e phuv, o more thaj sa so si ande lende. ");
INSERT INTO rmyChergash_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Tu e Sveto Duhosa, prekal amaro pradad o David, ćiro sluga phendan: ‘Sostar bunin pe e manuša save či pindžaren e Devles, a o them ivja zavere ćerel? ");
INSERT INTO rmyChergash_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ušten e carurja e phuvjaće thaj e vladarja udružisajle protiv o Gospod thaj protiv lesko Pomazaniko.’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ej, čače o caro Irod thaj o vladari Pontije Pilato ande akava gav udružisajle okolenca save či pindžaren e Devle thaj e Izraelošće themesa protiv ćiro sveto sluga o Isus, ćiro pomazaniko. ");
INSERT INTO rmyChergash_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Von ćerdine okova so tu ćire voljava thaj ćire silava majanglal odredisardan te avel. ");
INSERT INTO rmyChergash_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","A akana, Gospode, ašun lenđe pretnje thaj de amenđe ćire slugenđe hrabrost te bi darako mothos averenđe pale ćiro alav. ");
INSERT INTO rmyChergash_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Inzar ćiro moćno vas, te avel o sastipe, znakurja thaj čudurja – ando alav ćire sveto slugasko e Isusesko.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Kana završisardine e molitva, ćhinosajlo o than pe savo sas ćidine thaj savora pherdile e Sveto Duhosa pa počnisardine hrabro te mothon pale Devlesko alav. ");
INSERT INTO rmyChergash_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Savora okola save paćanas sas sago jek ileja thaj jek dušava. Thaj khonikal či phenelas kaj si vareso so si les samo lesko, nego delinas maškar peste sa so sas len. ");
INSERT INTO rmyChergash_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","A e apostolurja e bare silava svedočinas palo vaskrsenje e Gospode Isusesko, thaj e bari milost sas pe lende savorende. ");
INSERT INTO rmyChergash_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Khonikašće lendar khanči či falilas. Kaj okolen saven sas phuv ili ćher, bićinenas len thaj e dobime love, ");
INSERT INTO rmyChergash_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","denas e apostolenđe, a katar godova delas pe svakonešće kozom kas trubulas. ");
INSERT INTO rmyChergash_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Gajda vi varesavo Levito savo akhardolas Josif, bijando ando Kipar, saves e apostolurja akharenas Varnava (so značil kaj sas manuš savo ohrabrilas), ");
INSERT INTO rmyChergash_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","les sas njiva savi bićinda thaj e love dijas e apostolenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","A varesavo manuš po alav Ananija zajedno pešće romnjava e Safirava bićinda piri phuv. ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Thaj ando džanglipe pire romnjako ačhada pale peste jek deo e lovendar, a okova so ačhilo dija ke apostolurja. ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Askal o Petar phendas lešće: “Ananija, sostar muklan te o Satana pherel ćiro ilo, te hohaves e Sveto Duhošće thaj te ačhaves pale tute jek deo e lovendar save lijan pale phuv. ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Či li e phuv ačhilisas ćiri te či bićindanas lat? A kana već bićindan lat, zar godole lovenca našti ćerdan so kamlan? Sostar ande ćiro ilo odličisardan te ćeres gajda vareso? E Devlešće hohadan, a na e manušenđe.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Kana o Ananija ašundas sa akala alava, pelo tele mulo. A e bari dar dijas ande sa okola save ašundine pale akava. ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Askal varesave terne čhave uštile, paćardine lesko telo ando pohtan, inklaldine les thaj prahosardine les. ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","A kana nakhlo varekaj katar trin saturja, dijas andre vi lešći romnji, savi či džanglas so sas. ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","O Petar phučla lat: “Phen manđe, dali pale gaći love bićindine e phuv?” A e manušnji phendas: “Ej baš pale gaći love.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Askal o Petar phendas laće: “Sostar dogovorisajle te iskušin e Gospodešće Duhos? Ake, anglo vudar si okola kaj prahosardine ćire romes. Vi tut inkalena!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Thaj vi voj odma peli tele muli dži ke lešće pungre. Askal dine andre okola terne čhave thaj arakhline lat muli, thaj vi lat inkaldine thaj prahosardine paše lako rom. ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","E saste khanđirja thaj sa okolen save ašundine pale akava lijas e bari dar. ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Prekal e apostolurja dogodinas pe e but znakurja thaj čudurja maškar o them. Sa e vernikurja jećhe dušava ćidenas pe ande Solomonosko tremo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Khonik avrendar či tromaja te pridružil pe lenđe, ali o them šukar motholas pala lende. ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","A ipak sa majbut thaj majbut manuša thaj manušnja paćanas ando Gospod thaj priključinas pe e vernikonenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Kana o Petar naćhelas, e manuša inkalenas pire nasvalen pe sokača. Čhonas len pe ležaljke thaj pe nosilje gajda te lešći senka barem perel pe lende. ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Avenas vi but manuša andar e okolne gava oko o Jerusalim thaj anenas pire nasvalen thaj okolen saven mučinas e bilačhe duhurja. Thaj savora sastile. ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Askal o baro rašaj thaj sa okola save sas lesa andar e sadukejenđi stranka sas but ljubomorne ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","thaj astardine e apostolen thaj čhudine len ando glavno phanglipe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ali e Gospodesko anđelo raćava putardas o vudar katar e tamnica, inkalda len avri thaj phendas lenđe: ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Džan ando Hramo thaj mothon e themešće sa pale akava nevo Trajo.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Kana e apostolurja godova ašunde, đele ando Hramo detharinako ande zora thaj sikavenas e themes. Kana avilo o baro rašaj thaj okola save sas lesa, ćidine sa okolen andar o Baro veće thaj sa e starešinen andar o Izraelsko them thaj dine naredba te anen pe e apostolurja andar o phanglipe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ali, kana e stražarja aresle ando phanglipe, či arakhline len okote, gajda kaj boldine pe palpale thaj phendine: ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“O vudar katar e tamnica sas pe ćija lačhe phandado, a e stražarja ačhenas anglo vudar. Ali kana putardam o vudar či arakhlam andre khonikas!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","A kana o zapovedniko pe hramošće stražarja thaj e šorvale rašaja ašundine akava so mothodine, sas zbunime thaj phučenas pe so šaj avel akava. ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Pe godova vareko avilo thaj phendas lenđe: “Eke okola manuša saven araći čhudine ando phanglipe ando Hramo si thaj sikaven e themes!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Askal o zapovedniko pale hramsko straža đelo e stražarenca thaj andine e apostolen, ali na pe sila kaj daranas te o them či čhudel bara pe lende. ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Kana andine len, čhutine len anglo Baro veće thaj o baro rašaj phučelas len: ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Či li strogo mothodam tumenđe te na sikaven ando alav godole manušesko? A tumen pherdine o sasto Jerusalim tumare sikavipeja thaj kamen te čhon e doš pe amende palo smrto godole manušesko!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","A o Petar thaj e apostolurja phendine lenđe: “E Devlešće trubul te avas paćivale majsigo nego e manušenđe! ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","O Del amare pradadengo vazdas e Isuse andar e mule, saves tumen mudardine gajda kaj čhutine les po trušul. ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ali o Del uzvisisarda les thaj čhuta les pe piri desno rig sago Princos thaj Spasiteljes, te e manušenđe andar o Izrael del prilika te obratin pes thaj te jarton pe lenđe e bezeha. ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Amen sam svedokurja pale sa godova thaj o Sveto Duho saves o Del dijas okolenđe save pokorin pe lešće.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kana e manuša andar o Baro veće ašundine akava, gaći holjajle kaj kamenas te mudaren len. ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Askal ando Baro veće uštilo jek učitelj palo Mojsijesko zakon, savo akhardolas Gamalilo, fariseji saves sa o them poštuilas. Vo phendas te inkalen e apostolen cara avri. ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Askal phendas: “Manušalen andar o Izrael, lačhe gndin tumare šoresa so kamen te ćeren akale manušenca. ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kaj majsigo varesavi vrjama pojavisajlo o Tevda savo motholas pale peste kaj si vo vareko thaj vareso. Lešće pridružisajle štar šela manuša, ali vo sas mudardo, a sa lešće manuša našline thaj katar godova nas khanči. ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Pale leste, ande vrjama kana sas o popis stanovništva, pojavisajlo o Juda Galilejco thaj vazdas e theme pe buna. Ali vi vo sas mudardo, a sa lešće manuša našline. ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Zato pale akava phenav tumenđe: mućen tumen akale manušendar thaj den len te džantar. Kaj, te si lengo naum ili lengo delo katar e manuša, vi godova propadnila. ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","A te si e Devlestar, našti uniština len, kaj gajda avena sago okola kaj borin pe protiv o Del.” Thaj von složisajle lesa. ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Askal akhardine e apostolen andre, izbičuisardine len, thaj zabranisardine lenđe te sikaven ande Isusesko alav, askal mukline len. ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","A e apostolurja đeletar andar o Baro veće bahtale, kaj sas dostojne te han ladžavo zbog e Isusesko alav. ");
INSERT INTO rmyChergash_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Thaj či prestainas svako đes ando Hramo thaj pe ćhera te sikaven thaj navestin kaj si o Isus o Mesija. ");
INSERT INTO rmyChergash_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Godola đesa, sar o brojo e učenikonengo sa majbut barjolas, e Židovurja save ćerenas svato grčki počnisardine te žalin pes pe aver Židovurja. Phenenas kaj lenđe udovice si zanemarime kana delil pe svako đes o habe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Askal e dešuduj apostolurja akhardine peste sa e učenikonen thaj phendine lenđe: “Naj lačhe te amen zanemaris te propovedisaras e Devlesko alav thaj te delis o habe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Zato, phralalen, araćhen maškar tumende efta manušen save si po lačho glaso, thaj pherde e Sveto Duhosa thaj mudrost. Len čhasa pale godova, ");
INSERT INTO rmyChergash_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","a amen posvetisa men e molitvaće thaj te propovedisaras andar o alav e Devlesko.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Godova predlog sviđosajlo savorenđe. Thaj losardine e Stefane, manuše savo sas pherdo paćipe thaj Sveto Duhosa, e Filipe, e Prohore, e Nikanore, e Timone, e Parmene thaj e Nikola andar e Antiohija savo majsigo obratisajlo po židovsko paćipe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Askal andine len angle apostolurja, von čhutine pire vas pe lende thaj pomolisajle pale lende. ");
INSERT INTO rmyChergash_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Gajda e Devlesko alav buljolas. A o brojo e učenikonengo ando Jerusalim but barjolas, a vi e but židovenđe rašaja počnisardine te paćan. ");
INSERT INTO rmyChergash_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","O Stefan sas manuš pherdo milosti thaj sila thaj ćerelas e bare čudurja thaj znakurja maškar o them. ");
INSERT INTO rmyChergash_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ali, pobunisajle protiv leste varesave andar e Sinagoga okolenđi save sas oslobodime roburja, e Židovurja andar e Kirina, Aleksandrija, thaj varesave anda e Kilikija thaj e Cikni Azija, thaj počnisardine te raspravin pe e Stefanesa. ");
INSERT INTO rmyChergash_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ali khonik lendar našti protivisajlo protiv e mudrost thaj e Duhošće saveja ćerelas svato. ");
INSERT INTO rmyChergash_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Askal nagovorisardine varesave manušen te phenen: “Ašundam les sar vređol e Mojsija thaj e Devle.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Gajda pobunisardine e theme, e starešinen thaj e učiteljen e zakonestar, pa navalisardine pe leste, astardine les thaj inđardine les anglo Baro veće. ");
INSERT INTO rmyChergash_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Andine vi e hohavne svedokonen save phendine: “Akava manuš neprestalno mothol protiv o Hramo thaj protiv e Mojsijesko zakon. ");
INSERT INTO rmyChergash_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ašundam les kaj phenel sar godova Isus andar o Nazaret haravela o Hramo thaj promenila e običaja save dija men o Mojsija.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","A savora save bešenas ando Baro veće lačhe dikhline po Stefano thaj dikhline o muj lesko sas sago e anđelosko. ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Askal o baro rašaj phučlas e Stefane: “Dali si gajda akava so mothon?” ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","A o Stefano phendas: “Phralalen thaj dadalen, ašunen man! O slavno Del sikadilo amare pradadešće e Avraamešće kana sas ande Mesopotamija, majsigo nego so doselisajlo ando Haran ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","thaj phendas lešće: ‘Muk akaja phuv thaj ćire familija maškar savi trajis thaj dža ande phuv savi sikavava tuće.’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Thaj o Avraam gajda mukla e phuv e Haldejenđi thaj doselisajlo ando Haran. Nakon so mulo lesko dad, o Del anda les ande akaja phuv kaj tumen akana trajin. ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ali či dija les ande late ni jek majcikno kotor phuv ando nasledstvo, nego obećisarda kaj dela e phuv lešće thaj lešće potomkonenđe posle leste, vi ako e Avraame još nas čhavra. ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","O Del gajda phendas lešće: ‘Ćire potomkurja avena strancurja ande averenđi phuv. Okote avena roburja thaj avena mučime štar šela brš.’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ali o Del phendas: ‘Me sudiva e themes kašće von robuina, a posle godova inkljena andar godoja phuv thaj avena te služin man pe akava than.’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Askal o Del ćerda savez e Avraameja thaj dija les obrezanje sago znako godole savezosko. E Avraamešće askal bijandilo o Isak saves obrežisarda ohtoto đes katar lesko bijandipe. O Isako gajda ćerda pire čhaveja e Jakoveja, a o Jakov pire dešuduje čhavenca save sas patrijahurja katar save postanisardas amaro them. ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","A e Jakovešće čhave, e patrijarhurja, sas ljubomorne pe pesko phral po Josif, thaj zbog godova bićindine les sago robo ando Egipto. Ali o Del sas lesa, ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","thaj inkhalelas les andar svako lešći nevolja. O Del dija les mudrost, thaj naklonost e faraonešći, e egipatsko carošći, savo čhuta les te avel upravniko po sasto Egipto thaj pe sasto lesko dvoro. ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Askal ande sasti egipatsko phuv thaj ando Hanaan avili e bok thaj bari nevolja, gajda kaj amare pradada našti araćhenas hamasko. ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Kana o Jakov ašundas kaj ando Egipto si điv, bičhaldas okote amare pradaden po prvo data. ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Kana đeline po dujto drom, o Josif phendas pire phralenđe ko si vo. Gajda o faraon ašundas pale Josifešći familija. ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","O Josif askal bičhaldas pale pesko dad palo Jakov thaj pale sasti piri familija save sas eftavardeš thaj pandž džene. ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Gajda o Jakov đelo tele ando Egipat kaj mulo vo thaj amare pradada. ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Lenđe telurja sas inđarde ando Sihem thaj okote sas prahome ando limori savo o Avraam ćindas pale odredime svota love katar Emorošće čhave. ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Sar avelas paše e vrjama te perdol so o Del obećisarda e Avraamešće, amaro them ando Egipto barjolas thaj množilas pe, ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","sa dok či zavladisardas ando Egipto o nevo caro, savo či pindžarelas e Josife. ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Vo lukavo postupilas amare themeja: mučilas amare pradaden thaj tradelas len te mućen pire tek bijande čhavren avri te meren. ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ande godoja vrjama bijandilo o Mojsije, savo sas zurale šukar čhavro ande Devlešće jakha. Trin čhon sas barjardo ande pe dadesko ćher. ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Kana mukline les avri, e faraonešći čhej lija les thaj barjarda les sago pire čhaves. ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","O Mojsije sas sikado ande sasti e Egipatsko mudrost thaj sas silno ande alava thaj pe dela. ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Kana sas lešće štarvardeš brš, crdelas les o ilo te džal te dićhel pire phralen e Izraelsko themes. ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Kana dikhla kaj varesavo Egipćano mučil e Izraelco, ačhilo ande lešći obrana thaj osvetisarda les gajda kaj mudardas e Egipćanos. ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Gindilas kaj lešće phral haćarena kaj o Del preko leste bičhalel lenđe oslobođenje, ali von godova či haćardine. ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Thejara đes palem dija pe duj Izraelcurja sar marens pe. Probisarda te pomiril len gajda kaj phendas lenđe: ‘Manušalen, phrala sen! Sostar ćeren zlo jek avrešće?’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ali okova kaj marelas pire pašutnes, spida e Mojsija thaj phendas lešće: ‘Ko čhuta tut te aves amaro vladari thaj amaro sudija? ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Kames vi man te mudares sago kaj araći mudardan okole Egipćanos?’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Kana o Mojsije godova ašundas našlo ande midjansko phuv thaj okote trajilas sago stranco, kaj bijandile lešće duj čhave. ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Posle štarvardeš brš sikadilo lešće o anđelo ande pustinja paše ke Sinajsko gora ando grmo savo phabolas. ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Kana o Mojsije dikhla godova, zadivisajlo godolešće so dićhel. Ali kana avilo majpaše te majlačhe dićhel, ašunda e Gospodesko glaso: ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Me sem o Del ćire pradadengo, o Del e Avraamesko, e Isakosko, thaj e Jakovesko.’ O Mojsije izralas e daratar thaj či tromaja e jakha te vazdel te dićhel. ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","O Gospod phendas lešće: ‘Fuljar e sandale katar ćire pungre! Kaj o than pe savo ačhes, si sveto. ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Dikhlem e muka mungre themešći ando Egipat thaj ašundem lengo jauk. Andar godova fuljistem te inkalav len okotar. A akana, ajde dža, me bičhalav tut ando Egipat!’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Akale Mojsija saves e Židovurja odbacisardine kana phendine: ‘Ko čhuta tut te aves amaro vladari thaj amaro sudija?’, o Del baš akana les bičhaldas prekal o anđelo savo sikadilo lešće ando grmo te avel vladari thaj izbavitelj. ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Vo inkalda len okotar gajda kaj ćerelas čudurja thaj znakurja ande egipatsko phuv, po Lolo more thaj štarvardeš brš ande pustinja. ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Isto godova Mojsije phendas e Izraelošće themešće: ‘O Del vazdela tumenđe prorokos sago kaj sem me andar tumaro them.’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Isto godova Mojsije si okova savo sas posredniko maškar amare pradada ande pustinja thaj maškar o anđelo savo dija les o alav e trajosko pe Sinajsko gora te predail godola alava amenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Amare pradada či kamline te pokorin pe lešće, nego odbacisardine les thaj e ileja palem boldine pe ando Egipat. ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Phendine e Aronešće: ‘Ćer amenđe devlen save džana angle amende! Kaj či džanas so si okole Mojsijava savo inkalda men andar o Egipat.’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Godola đesa ćerdine kipo ando oblik terne guruvesko, dine lešće žrtva thaj slavinas godova so ćerdine pire vastenca. ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Askal o Del bolda pes lendar thaj mukla len te klanjin pe e khamešće thaj e čerejenđe, sago vi kaj ačhel ramome ando lil e prorokonengo: ‘Zar manđe dijan žrtve thaj darurja ande pustinja štarvardeš brš, manušalen andar o Izrael? ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Na, nego inđarenas o šator e Molohosko e hohamne devlesko thaj e čerain katar tumaro del o Refan; kipurja save ćerdine te klanjin tumen lenđe. Zato inđarava tumen ando progonstvo’, majdur katar o Vavilon! ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Amare predaden sas Šator svedočanstva ande pustinja. O Del phendas e Mojsijašće sar te ćerel o šator thaj o Mojsija ćerda o šator gajda sar sas lešće sikado. ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Kana amare pradada primisardine o Šator, inđardine les pesa ande phuv, savi line katar o them saven o Del angle lende trada, a o Isus Navin sas lengo vođa. O Šator ačhilo okote sa dži e vrjama e carošći Davidešći. ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","O David arakhlas milost ko Del thaj zamolisarda e Devle te šaj sagradil Hramo palo Del e Jakovesko, ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","ali tek o Solomon vazdas lešće o Hramo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ipak o majbaro Del či trajil ande Hramurja save si ćerde e manušenđe vastenca, sago kaj phenel o proroko: ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘O nebo si mungro prestolje, a e phuv si tale mungre pungre: Sosko ćher vazdena manđe? Phenel o Gospod, thaj kaj si o than kaj me odmoriva? ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Či li sa akava mungro vas stvorisarda?’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","O tumen tvrdoglave manušalen save či pindžaren e Devle thaj či čhon kan leste! Tumen uvek protivin tumen e Sveto Duhošće, sago kaj godova ćerenas vi tumare pradada! ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Kas katar e prorokurja tumare pradada či progonisardine? Mudardine čak vi okolen save majsigo phendine kaj avela o Pravedniko, saves tumen izdaisardine thaj mudardine. ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Prekal o anđelo dobisardine o zakon, ali či inćardine les!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Kana godova ašundine e židovske vođe, gajda holjajle po Stefan kaj počnisardine te škripin e dandenca pe leste. ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","A o Stefano pherdo e Sveto Duhosa, vazda pire jakha po nebo thaj dikhla e slava e Devlešći thaj e Isuse sar ačhel pe desno rig e Devlešći. ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Askal phendas: “Ake dikhav o nebo putardo thaj e Čhave e Manušešće sar ačhel pe desno rig e Devlešći.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Pe godova von učhardine pire kan e vastenca thaj počnisardine te čhon muj andar sasto glaso, thaj savora sar jek navalisardine pe leste. ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Inkaldine les andar o gav thaj čhudenas bara pe leste. A e svedokurja protiv o Stefano mukline pire ogrtačurja jeće terne manušešće savo akhardolas Savle te lel sama pe lende. ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Dok čhudenas bara pe leste te mudaren les, o Stefano zavapisardas: “Gospode Isuse, primisar o mungro duho!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Askal pelo pe pire koča thaj čhuta muj andar sasto glaso: “Gospode, na le lenđe kava palo bezeh!” Sar godova phendas, mukla pesko đi. ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","A o Savle odobrisardas e Stefanesko mudaripe. Godova đes počnisarda o baro progonstvo pe Khanđiri ando Jerusalim. Pa sa e vernikurja, osim e apostolurja, raspršisajle pe judejske thaj pe samarijanske krajurja. ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","A varesave pobožne manuša prahosardine e Stefane thaj zurale rovenas pale leste. ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","A o Savle saste silava trudilas pe te uništil e Khanđiri. Džalas andar o ćher dži ko ćher thaj inkalelas avri e manušen thaj e manušnjen thaj čhudelas len ando phanglipe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","A okola vernikurja save raspršisajle, buljarenas e Bahtali nevimata kaj god džanas. ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Gajda o Filip avilo ande jek samarijansko gav, thaj okote propovedilas e themešće palo Hristo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Kana o them ašundas thaj dikhla e čudurja save ćerelas, savora pažljivo čhonas kan so phenelas. ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","E bilačhe duhurja zurale rknjinas kana inkljenas andar e but manuša ande save sas, a sastonas vi but okola save sas line thaj banđe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Thaj ande godova gav gajda zavladisardas e bari bah. ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","A ande godova gav sas vi varesavo manuš, savo akhardolas Simon, vo već varesavi vrjama okote drabarelas. E manuša save trajinas ande Samarija divinas pe lešće, a vo phenelas pale peste kaj si vo baro manuš. ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Thaj savora pažljivo čhonas kan leste katar o majcikno dži ko majbaro thaj phenenas: “Akava manuš si čače sila e Devlešći, savi akhardol bari sila.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","A čhonas kan leste zato kaj već lungo vrjama zadivilas len pire ćirimatenca. ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ali kana paćaine e Filipešće, savo propovedilas e Bahtali nevimata pale Devlesko carstvo thaj palo alav e Isuse Hristosko, bolenas pe e manuša thaj e manušnja. ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Čak vi o Simon korkoro paćaja, bola pe thaj ačhilo e Filipeja. Zadivime dićhelas e znakurja thaj e bare čudurja save dogodinas pe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Kana e apostolurja ando Jerusalim ašundine kaj ande Samarija prihvatisardine e Devlesko alav, bičhaldine lenđe e Petre thaj e Jovano. ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Kana von duj džene aresline pomolisajle pale lende te vi von primin e Sveto Duho. ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Kaj o Sveto Duho još či fuljisto pe nijećheste lendar pošto sas bolde samo ando alav e Gospodesko Isusesko. ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Askal e apostolurja čhutine pire vas pe lende, thaj von primisardine e Sveto Duhos. ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Kana o Simon dikhla kaj e manuša primin e Sveto Duhos, čim e apostolurja čhutine pire vas pe lende, ponudisarda e apostolenđe love ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","thaj phendas lenđe: “Den vi man godoja moć te svako pe kaste čhav mungre vas primil e Sveto Duhos!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","A o Petar phendas lešće: “Neka propadnin ćire love zajedno tusa, kaj gndis kaj e lovenca šaj ćines e Devlesko daro! ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Tu našti sudeluis ande akaja služba, kaj ćiro ilo naj ispravno anglo Del. ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Zato pokaji tut thaj muk tut katar ćiro bilačhipe. Moli tut e Gospodešće te jartol tuće kaj sas tu kasavi gindimata. ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kaj dikhav kaj san pherdo gorčine thaj robo e bezehešće.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","A o Simon phendas: “Tumen molin tumen pale mande e Gospodešće te či aresel man khanči katar godova so phendine.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Nakon so svedočisardine lenđe palo Isus thaj objavisardine lenđe e Gospodesko alav, von boldine pe ando Jerusalim. E dromesa naćhenas kroz e but e samarijanske gava thaj navestinas e Bahtali nevimata. ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","O anđelo e Gospodesko phendas e Filipešće: “Ušti thaj teljar po jugo e dromesa savo inđarel kroz e pustinja thaj mućel pe tele andar o Jerusalim ande Gaza.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","O Filip spremisajlo thaj teljardas. Dromesa maladas varesave evnuho, manuše andar e Etiopija – savo sas dvoraniko e Kandako, e etiopske caricako thaj upravniko e riznicako. Sas ando Jerusalim te poklonil pe e Devlešće, ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","thaj kana boldelas pe ćhere. Bešelas ande piri kočija thaj po glaso čitolas andar o lil e proroko Isaijasko. ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Askal o Sveto Duho phendas e Filipešće: “Dža paše dži ke godoja kočija thaj ačh uz late!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","O Filip prastaja dži ke kočija thaj ašundas sar o manuš čitol andar o proroko Isaija thaj phučla les: “Dali haćares so čitos?” ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","A o manuš phendas: “Sar šaj te haćarav ako khonik či objasnil manđe?” Thaj akhardas e Filipe te lel pe opre ande kočija thaj te bešel paše leste. ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","A o odlomko andar o Sveto lil savo čitosardas sas akava: “Inđardine les sago e bakhre tale čhuri. Thaj sago o bakhroro nemo angle okola save randen les, gajda ni vo či putrelas piro muj. ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Sas ponizime thaj uskratime katar e pravda. Ko ćerela svato pale lešće potomkurja kaj lesko trajo lija pe katar e phuv.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","O dvoraniko askal phučla e Filipe: “Moliv tut, phen manđe ko si godova pale kaste phenel o proroko? Dali godova o proroko phenel pale peste ili pale varekaste avreste?” ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Askal o Filip teljardas te sikavel les katar godova than andar o Lil thaj te objasnil lešće e Bahtali nevimata palo Isus. ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Thaj dok gajda džanas e dromesa, aresline dži ke varesavo paj, pa o dvoraniko phendas: “Dik, ake o paj! So sprečil man te bolav man?” ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","A o Filip phendas lešće: “Šaj ako paćas ćire saste ileja.” A o dvoraniko phendas: “Paćav kaj si o Isuso Hristo Čhavo e Devlesko.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Askal o dvoraniko zapovedisarda te ačhel e kočija thaj liduj džene fuljistine dži ko paj, thaj o Filip bolda les. ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","A kana inkljistine andar o paj, e Gospodesko Duho otmisarda e Filipe thaj o dvoraniko majbut či dikhla les thaj bahtalo nastavisarda pire dromesa. ");
INSERT INTO rmyChergash_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","A o Filip arakhadilo ando gav Azot, thaj e dromesa dok putuilas propovedilas e Bahtali nevimata pe sa e gava sa dok či areslo ande Kesarija. ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","A o Savle, vi majdur e holjasa pretilas kaj mudarela e Gospodešće učenikonen. Andar godova đelo ko Baro rašaj ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","thaj manglas lestar lila pale sinagoge ando Damask te šaj astarel inća svakones savo sledil e Gospodesko drom, bilo te si manuš ili manušnji thaj te phangle šaj anel len ando Jerusalim. ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Kana avilo paše dži ko Damask, katar jekhar o baro svetlo andar o nebo zasvetlisarda les. ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Askal pelo pe phuv thaj ašunda o glaso savo motholas lešće: “Savle! Savle! Sostar progonis man?” ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","O Savle phučla les: “Ko san tu, Gospode?” A o glaso phendas: “Me sem o Isus saves tu progonis. ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Nego, ušti akana thaj dža ando gav! Okote phenela pe tuće so trubul te ćeres.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","A okola manuša kaj džanas e Savleja ačhile bi alavesko, kaj ašundine o glaso, ali či dikhline khonikas. ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Kana o Savle uštilo katar e phuv, putardas pešće jakha, ali khanči našti dićhelas. Zato astardine les palo vas thaj andine les ando Damask. ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Trin đesa našti dićhelas, a pale godoja vrjama či halas ni pijelas. ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ando Damask trajilas varesavo učeniko savo akhardolas Ananija. Lešće o Gospod phendas ando viđenje: “Ananija!” A o Ananija phendas: “Akate sem, Gospode.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","A o Gospod phendas lešće: “Ušti, thaj dža ando sokako savo akhardol Pravo, ande Judasko ćher, thaj okote rode e manušes savo akhardol Savle andar o Taršiš! Eke vo akana molil pe.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","O Savle ando viđenje dikhla jećhe manušes savo akhardolas Ananija sar del andre thaj čhol pire vas pe leste te šaj dićhel. ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","O Ananija phendas: “Gospode, ašundem e bute manušendar kaj akava manuš ćerda but bilačhipe ćire svete manušenđe ando Jerusalim! ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Čak vi pale akate si les vlast katar e bare rašaja te phandel ande okurja sa okolen save paćan ande ćiro alav.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","O Gospod phendas lešće: “Dža kaj godole manušes lijem te preko leste ašunen pale mande e aver thema, e carurja, thaj o izraelsko them. ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Me sikavava lešće kozom trubul te trpil pale mungro alav.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","O Ananija đelo, dijas ande godova ćher thaj čhuta pire vas po Savle thaj phendas lešće: “Phrale Savle! O Gospod Isus, savo sikadilo tuće po drom akaring, bičhalda man te šaj dićhes thaj te pheres tut e Sveto Duhosa.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Isto treno katar lešće jakha pelo vareso sago ljuske, thaj šaj dićhelas. Askal uštilo thaj sas boldo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Askal hala vareso thaj bolda pe lešći snaga. O Savle ačhilo varekazom đesa e učenikonenca ando Damask. ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Thaj odma ačhilo te propovedil pe sinagoge kaj o Isus si Čhavo e Devlesko. ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Thaj savora save ašunenas les, sas začudime thaj phučenas pe: “Pa naj li akava okova isto manuš savo ando Jerusalim kamlas te uništil okolen save paćan ande godova alav? Zar či avilo akate te astarel len thaj te phangle inđarel len angle šorvale rašaja?” ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","A e Savlesko propovedanje sas sa majsilno, gajda kaj mućelas e Židoven andar o Damask bi alavengo. Dokažilas kaj o Isus si o Hristo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Nakon so nakhline but đesa, e židovske vođe odlučisardine te mudaren e Savle. ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ali o Savle saznajisardas pale lengo gindo. A e Židovurja lenas sama đesenca thaj e raćenca pe gavesko vudar te šaj mudaren les. ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ali e učenikurja e raćava mukline les ande bari korpa prekal e gavesko zido. ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Kana o Savle avilo ando Jerusalim, kamla te pridružil pes e učenikonenđe, ali savora daranas lestar, kaj či paćanas lešće kaj si vi vo učeniko. ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Askal o Varnava prihvatisarda les thaj inđarda les ke apostolurja. O Varnava ćerda svato e apostolenđe sar o Savle po drom dikhla e Gospode savo motholas lešće thaj sar ando Damask hrabro propovedilas ande Isusesko alav. ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Gajda o Savle ačhilo lenca, phirelas po Jerusalim thaj hrabro propovedilas ande Gospodesko alav. ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ćerelas svato thaj raspravilas pe e Židovenca save ćerenas svato grčki, ali von dićhenas te mudaren les. ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Kana ašundine pale godova e vernikurja, inđardine les ande Kesarija thaj bičhaldine les ćhere ando Tars. ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Gajda e khanđiri ande sasti Judeja, Galileja thaj ande Samarija sas ando miro. E khanđiri zuravolas ande dar e Gospodešći thaj brojčano barjolas ande uteha e Sveto Duhošći. ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Kana o Petar naćhelas maškar akala regije, avilo vi ke Devlešće manuša ando gav savo akhardolas Lida. ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Okote arakhlas jećhe manuše savo akhardolas Enej, savo pašljolas ohto brš bango ando kreveto. ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","O Petar phendas lešće: “Enej, o Isus Hrist sastarel tut. Ušti thaj lačhar ćiro kreveto!” Thaj o Enej odma uštilo! ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Kana dikhline e Enejes, sa e manuša save trajinas ande Lida thaj ando Saron, obratisajle e Gospodešće. ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ande Jopa, trajilas jek učenica savi akhardolas Tavita (so značil: “Košuta”). Voj uvek ćerelas lačhipe thaj pomožilas e čore manušen. ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Baš ande godoja vrjama voj nasvajli thaj muli. Najardine lat thaj čhutine lat ande soba po sprato. ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ali kana ašundine kaj si o Petar paše ando gav Lida, bičhaldine leste duj manušen thaj zamolisardine les: “Av odma amende!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Zato o Petar odma teljarda lenca. Thaj čim areslo inđardine les ande soba savi sas opre po sprato. Okote okružisardine les e udovice save rovenas thaj sikavenas lešće e ogrtača thaj e aver drze save ćerda lenđe e Tavita dok sas lenca. ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ali o Petar trada len sa avri andar e soba. Dija koča thaj pomolisajlo e Devlešće. Askal bolda pe ko mulo telo thaj phendas: “Tavita, ušti!” Voj putardas pire jakha, dikhla e Petre thaj bešli. ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Vo astarda lat palo vas thaj vazda lat. Askal akharda e vernikonen thaj e udovicen thaj sikada lenđe kaj si džudi. ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Pale akava ašundine sa e stanovnikurja andar e Jopa, thaj but lendar paćajine ando Gospod. ");
INSERT INTO rmyChergash_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","O Petar ačhilo ande Jopa još varesavi vrjama, ando ćher jećhe manušesko savo sas kožari, a akhardolas Simon. ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ande Kesarija trajilas varesavo manuš savo akhardolas Kornelije. Vo sas rimsko kapetano e četako savi akhardolas Italijansko. ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Vo sas pobožno manuš thaj daralas e Devlestar, sago vi savora save trajinas lesa ando ćher, delas milostinja e čore Židovenđe thaj stalno molilas pe e Devlešće. ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Jek đes varekaj katar e trin saturja mismere, sas les vizija ande savi jasno dikhla sar avel leste e Devlesko anđelo thaj phenel lešće: “Kornelije!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","O Kornelije dikhla pe leste e darasa thaj phučlas: “So kames Gospode?” A o anđelo phendas lešće: “Ćire molitve thaj e milostinje aviline anglo Del sago žrtva thaj vo dija pe gođi tute. ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Akana bičhal e manušen ande Jopa te anen e Simone saves akharen Petar. ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Vo si gosto ko Simon savo si kožari, kasko ćher si pašo more.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Kana o anđelo savo motholas lešće đelotar, o Kornelije akhardas e duje slugen thaj jećhe pobožno vojniko savo sas jek katar lešće pomoćnikurja, ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","thaj phendas lenđe sa so sas thaj bičhalda len ande Jopa. ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Thejara o đes, varekaj katar o mismeri, dok von sas još po drom thaj sas već paše ke Jopa, o Petar lija pe opre po krovo te molil pe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Bokhajlo thaj kamlas vareso te hal. Ali dok andre pripreminas lešće o habe, les sas vizija. ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Dikhla sar o nebo putavol, a vareso sago baro čašapo phanglo pe štar ćoškurja mućel pes pe phuv. ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ande leste sas svakojake vrste životinje pe štar pungre, gmizavcurja thaj e čiriklja. ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Askal varesavo glaso phendas lešće: “Ušti Petre, de čhurjasa thaj ha!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","A o Petar phendas: “Nisar, Gospode! Me nikada či halem khanči nečisto so zabranil amaro Zakon!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","A o glaso palem phendas lešće. “Na phen kaj si zabranime okova so o Del phenas kaj si čisto!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Akava sas trin drom thaj katar jekhvar o čašapo vazda pe palpale po nebo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Dok o Petar sas još zbunime so godoja vizija šaj te značil, e manuša saven o Kornelije bičhaldas phučenas kaj si e Simonesko ćher, thaj već aresline angle kapija. ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Akhardine thaj phučline dali si akate ande goste o Simon saves akharen Petar. ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Dok o Petar još gindilas pale okova so dikhla ando viđenje, o Sveto Duho phendas lešće: “Ake roden tut trin manuša. ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ušti, fulji tele thaj dža lenca. Na oklevisar kaj me bičhaldem len.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","O Petar fuljisto thaj phendas lenđe: “Me sem okova saves roden. Sostar aviline?” ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","A von phendine: “Bičhalda men o rimsko kapetano o Kornelije. Vo si pravedno thaj daral e Devlestar, manuš saves poštuin sa e Židovurja. O sveto anđelo phendas lešće te akharel tut ande piro ćher thaj te čhol kan so si tut te phenes lešće.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Askal o Petar akharda len te den andre ando ćher thaj ugostisarda len. Thejara o đes spremisajlo thaj teljarda lenca, a lesa teljardine vi varesave phral andar e Jopa. ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Aver đes aresline ande Kesarija. A o Kornelije ažućarelas len zajedno pire familijava thaj e majpaše drugarenca. ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","A kana o Petar dijas ando ćher, o Kornelije inkljisto angle leste, pelo dži ke lešće pungre thaj poklonisajlo lešće. ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ali o Petar vazda les thaj phendas lešće: “Ušti, kaj vi me sem samo manuš. ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Sar ćerelas svato leja, gajda dija andre thaj dikhla e bute manušen save ćidine pe.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","O Petar phendas lenđe: “Tumen lačhe džanen kaj e Židovenđe o Zakon či mućel te družin pe tumenca save naj sen Židovurja ili te den ande tumare ćhera. Ali manđe o Del sikada te khonikas či smatriv kaj si nečisto thaj pogano. ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Zato avilem bi alavesko čim akhardine man. A akana phenen manđe sostar akhardine man.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Pe godova o Kornelije phendas: “Majsigo štar đesa, ande isto akaja vrjama, ande trin saturja mismere, semas ande mungro ćher thaj molisajlem. Andar jekhvar angle mande pojavisajlo o manuš ande sjajne drze ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","thaj phendas manđe: ‘Kornelije, o Del ašundas ćiri molitva thaj dija pe gođi ke ćiri milostinje e čorenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Zato bičhal varekas ande Jopa te akharel e Simone saves akharen Petar. Vo si gosto ando ćher e Simonesko savo si kožari pašo more.’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Gajda odma bičhaldem pale tute, thaj lačhe si kaj avilan. Akana savora ačhas akate anglo Del te ašunas sa so o Gospod zapovedisarda tuće te phenes amenđe!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Askal o Petar počnisarda te mothol: “Akana čače haćarav kaj o Del či ćerel razlika maškar o them. ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Dikhav kaj andar o svako them prihvatil okolen save daran lestar thaj ćeren so si pravedno. ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","O Del bičhaldas o alav e izraelošće themešće thaj objavisarda lenđe e Bahtali nevimata palo miro kroz o Isuso Hristo, savo si Gospod sa e manušenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Tumen džanen so sas pe sasti Judeja, a sa započnisardas ande Galileja nakon so o Jovano savo bolelas propovedilas palo bolipe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ašundine palo Isus andar o Nazaret saves o Del izabirisarda thaj pherdas e Svete Duhosa thaj e silava. Vo džalas okolo, ćerelas lačhipe thaj sastarelas savoren saven o beng inćarelas ande piri vlast, kaj o Del sas lesa. ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Amen sam svedokurja pale sa so vo ćerda ando Jerusalim thaj pe sasti phuv e židovenđi, a von mudardine les gajda kaj čhutine les po trušul, ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ali o Del o trito đes vazda les andar e mule thaj dija les te sikavel pe e manušenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ali či dikhla les sa o them, nego samo e svedokurja saven o Del majanglal izabirisarda. Godova sam amen save halam thaj pilam lesa nakon so uštilo andar e mule. ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","A vo zapovedisarda amenđe te propovedisaras e themešće thaj svedočisaras kaj si vo godova saves o Del odredisarda te sudil e džudenđe thaj mulenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Sa e prorokurja svedočin pale leste, te svako ko paćal ande leste, kroz lesko alav primil jartipe katar e bezeha.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Dok o Petar još ćerelas svato, o Sveto Duho fuljisto pe savorende save ašunenas e poruka. ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","A e židovske vernikurja, save aviline e Petresa, sas zaprepastime kana dikhline kaj o Del izlisarda o daro e Sveto Duhos vi pe okola save nas Židovurja, ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","kaj ašundine len sar ćeren svato ande aver čhibja thaj barjaren e Devle. Askal o Petar phendas: ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Akala manuša primisardine e Sveto Duho isto sago vi amen. Dali šaj vareko te zabranil lenđe te bolen pe e pajesa?” ");
INSERT INTO rmyChergash_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Thaj zapovedisarda lenđe te bolen pe ando alav e Isuse Hristosko. Askal von zamolisardine e Petre te ačhel lenca još varesavi vrjama. ");
INSERT INTO rmyChergash_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","E apostolurja thaj e phral ande sasti Judeja ašundine kaj čak vi okola save naj Židovurja prihvatisardine e Devlesko alav. ");
INSERT INTO rmyChergash_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Kana o Petar bolda pe ando Jerusalim, varesave katar e obrezime vernikurja kritikujinas les. ");
INSERT INTO rmyChergash_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Mothonas: “Dijan ando ćher e neobrezime manušengo thaj vi halan lenca!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Askal o Petar ačhilo te objasnil lenđe sa so sas: ");
INSERT INTO rmyChergash_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Semas ando gav Jopa thaj molivas ma. Dok molivas ma, sas man vizija: dikhlem vareso sago baro čašapo savo pe pire štare ćoškurja mućel pe katar o nebo thaj avel dži mande. ");
INSERT INTO rmyChergash_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Kana majlačhe lijem sama, dikhlem andre razne životinje pe štar pungre, divlje zveri, gmizavcurja thaj čirikljen. ");
INSERT INTO rmyChergash_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Askal ašundem o glaso savo phendas manđe: ‘Ušti, Petre, de čhurjasa thaj ha!’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ali me phendem: ‘Nisar, Gospode! Nikada vareso nečisto so zabranil amaro Zakon či čhutem ande mungro muj te hav.’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","O glaso andar o nebo po dujto data phendas manđe: ‘Na phen kaj si zabranime okova so o Del phendas kaj si čisto!’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Akava sas trin drom, thaj askal sas sa godova crdino po nebo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Baš ande godova časo avile trin manuša thaj ačhile anglo ćher ande savo me samas. Von sas bičhalde andar e Kesarija te aven pale mande. ");
INSERT INTO rmyChergash_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","O Sveto Duho phendas manđe te džav lenca thaj te na gndiv man khanči. Manca teljardine vi akala šov phrala, thaj gajda dijam ando ćher godole manušesko. ");
INSERT INTO rmyChergash_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Vo mothodas amenđe kaj dikhla e anđele ande piro ćher savo phendas: ‘Bičhal e manušen ande Jopa palo Simon saves akharen Petar. ");
INSERT INTO rmyChergash_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Vo phenela tuće alava kroz save aveja spasime tu thaj savora save trajin tusa ando ćher.’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Kana ačhilem te ćerav svato, o Sveto Duho fuljisto pe lende isto sago kaj fuljisto ando početko pe amende. ");
INSERT INTO rmyChergash_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Askal dijem man gođi so phendas o Gospod: ‘O Jovano bolelas e pajesa, a tumen avena bolde e Sveto Duhosa.’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Pa, ako o Del dija len isto daro sago vi amenđe kana paćajam ando Gospod Isuso Hristo, ko sem me te šaj ačhav e Devlešće po drom?” ");
INSERT INTO rmyChergash_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Kana ašundine godova, smirosajle thaj počnisardine te slavin e Devle. Phenenas: “O Del dakle, vi okole manušenđe save naj Židovurja dija pokajanje savo inđarel ando večno trajo!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ande godoja vrjama okola vernikurja save dine pe ando našipe zbog e nevolja savi avili kana sas o Stefan mudardo, aresle sa dži ke Fenikija, dži ko Kipar thaj dži ke Antiohija. O alav e Devlesko či propovedinas khonikašće osim e Židovenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ali varesave katar godola vernikurja sas andar o Kipar thaj andar e Kirinija. Kana von aresle ande Antiohija počnisardine te propovedin vi okole manušenđe save naj Židovurja palo Gospod Isus. ");
INSERT INTO rmyChergash_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","O vas e Gospodesko sas lenca, thaj but manuša paćajine thaj obratisajle e Gospodešće. ");
INSERT INTO rmyChergash_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Kana e khanđiri ando Jerusalim ašundas so akala ćeren ande Antiohija line thaj bičhaldine e Varnava ande Antiohija. ");
INSERT INTO rmyChergash_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Kana areslo thaj kana dikhla savi milost sikada lenđe o Del, raduisajlo thaj ohrabrilas e vernikonen te ačhen paćivale e Gospodešće pire saste ileja, ");
INSERT INTO rmyChergash_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","kaj o Varnava sas čestito manuš, pherdo e Sveto Duhosa thaj e paćimava. Thaj but e manuša avile e Gospodešće. ");
INSERT INTO rmyChergash_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Pale akava o Varnava đelo ando Tars te rodel e Savle. ");
INSERT INTO rmyChergash_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Kana arakhla les inđarda les ande Antiohija. Okote sasto brš araćhenas pe e manušenca andar e khanđiri thaj sikavenas e bute themes. A e učenikurja prvo data sas ande Antiohija akharde Hrišćanurja. ");
INSERT INTO rmyChergash_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ande godola đesa avile andar o Jerusalim ande Antiohija varesave prorokurja. ");
INSERT INTO rmyChergash_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Jek lendar savo akhardolas Agav, uštilo, thaj nadahnime e Sveto Duhostar prorokuisardas, kaj ando sasto Rimsko carstvo avela bari bok. Godova vi dogodisajlo kana vladilas o caro Klaudije. ");
INSERT INTO rmyChergash_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Andar godova e učenikurja andar e Antiohija odlučisardine te svako lendar kozom ko šaj, bičhalen pomoć e phralenđe ande Judeja. ");
INSERT INTO rmyChergash_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Gajda vi ćerdine thaj po Varnava thaj po Savle bičhaldine pomoć e starešinenđe ande Judeja. ");
INSERT INTO rmyChergash_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ande godoja vrjama o caro Irod počnisarda te mučil varesave vernikonen andar e khanđiri. ");
INSERT INTO rmyChergash_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Naredisarda te e mačesa mudaren e Jakove, e Jovanešće phrale, ");
INSERT INTO rmyChergash_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","pa kana dikhla kaj si godova drago e židovske vođenđe, naredisarda te astaren vi e Petre. Godova sas ande vrjama kana sas o prazniko e bikvascošće mangrengo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","A kana o Irod astarda e Petre, čhuda les ande tamnica thaj naredisarda te len pe leste sama štar straže po štar vojnikurja. Kamlas te inkalel les posle o prazniko Pasha anglo them te sudin lešće. ");
INSERT INTO rmyChergash_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Dok o Petar sas ando phanglipe, e khanđiri zurale molilas pe e Devlešće pale leste. ");
INSERT INTO rmyChergash_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Godoja rjat majsigo nego so o Irod kamlas te inkalel les anglo them te sudin lešće, o Petar phanglo duple lanconenca, sovelas maškar e duj vojnikurja, a e stražarja anglo vudar araćhenas e tamnica. ");
INSERT INTO rmyChergash_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Katar jekhvar pojavisajlo o anđelo e Gospodesko thaj o baro svetlo obasjaisarda e ćelija ande savi sas o Petar. A o anđelo poloćore dija dab e Petre pe pašvare, džungada les thaj phendas lešće: “Brzo ušti!” Thaj e lancurja odma peline katar e Petrešće vas. ");
INSERT INTO rmyChergash_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Askal o anđelo phendas lešće: “Le pe tute thaj le e sandale pe ćire pungre!” Thaj o Petar ćerda godova. Askal o anđelo phendas lešće: “Akana le pe tute o ogrtači thaj teljar pale mande!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","O Petar teljarda palo anđelo avri, ali či džanglas kaj si godova čače, nego gndisardas kaj si les vizija. ");
INSERT INTO rmyChergash_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Kana nakhline paše prvo thaj paše dujto straža, aresline dži ke sastruni kapija savi inđarel ando gav. Voj korkoro putajli angle lende thaj von inkljistine avri, a kana nakhline kroz jek sokako askal o anđelo katar jekhvar nestanisardas lestar. ");
INSERT INTO rmyChergash_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Askal o Petar avilo peste thaj phendas: “Akana džanav kaj o Gospod čače bičhaldas pire anđele thaj izbavisarda man andar e Irodešće vas thaj katar sa okova so o židovsko them ažućarelas te avel manđe!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Kana godova haćardas, đelo dži ko ćher e Marijako, savi sas dej e Jovanešći saves akharenas Marko, kaj but džene ćidine pe thaj molinas pe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","A kana o Petar mardas pe avlijako vudar, e sluškinja savi akhardolas Roda avili te putrel o vudar. ");
INSERT INTO rmyChergash_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Kana pindžardas e Petresko glaso, e bahtatar či putardas lešće o vudar, nego prastajas ando ćher thaj javisardas kaj o Petar ačhel anglo vudar. ");
INSERT INTO rmyChergash_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","A von phendine laće: “Tu san dili!” Ali sar voj vi maj dur tvrdilas kaj si gajda, von phendine: “Godova si lesko anđelo.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","A o Petar vi majdur marelas pe kapija. Kana putardine e kapija thaj dikhline e Petre, sas avrjal peste katar o čudo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Vo e vastesa dija len znako te ačhen thaj phendas lenđe sar o Gospod inkalda les andar o phanglipe thaj phendas lenđe: “Akava javin e Jakovešće thaj e aver phralenđe.” Askal inkljisto thaj đelotar pe aver than. ");
INSERT INTO rmyChergash_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","A kana svanosardas o đes e vojnikurja zurale uznemirisajle. Phučenas pe so sas e Petresa. ");
INSERT INTO rmyChergash_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","O Irod naredisarda te roden les, pa kana či arakhla les, akhardas e stražaren te ispituil len, thaj zapovedisarda te mudaren len. Pale godova o Irod đelotar andar e Judeja ande Kesarija thaj okote ačhilo varesavi vrjama. ");
INSERT INTO rmyChergash_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","O caro Irod sas zurale holjariko pe okola save trajinas ando Tiro thaj o Sidon, pa von udružisajle thaj zajedno aviline angle leste. Pošto zadobisardine e carošće pomoćniko savo akhardolas Vlasta, molisardine e caro Irode palo miro, kaj lenđi phuv uvozilas o hamasko andar e carošći phuv. ");
INSERT INTO rmyChergash_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ando dogovorime đes, o Irod lija pe peste e carske drze, bešlo pe piro prestolje thaj počnisarda angle savorende te mothol lenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","A o them čholas muj: “Akava si e devlesko glaso, a na e manušesko!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Isto časo e Gospodesko anđelo pekla e Irode e nasvalimasa, kaj či dijas slava e Devlešće. Mulo gajda kaj haline les e ćerme. ");
INSERT INTO rmyChergash_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","A e Devlesko alav sa majbut buljolas thaj o brojo e vernikonengo sas sa majbaro. ");
INSERT INTO rmyChergash_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Kana o Varnava thaj o Savle završisardine piro zadatko ando Jerusalim thaj boldine pe ande Antiohija, andine pesa e Jovane saves akharenas Marko. ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Maškar e prorokurja thaj maškar e učitelja ande Antiohisko khanđiri sas o Varnava, o Simeon saves akharenas Niger, o Lukije andar e Kirina, o Manain savo barilo e Irodesa savo sas vladari, thaj o Savle. ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Dok jekhar slavinas e Gospode thaj postinas, o Sveto Duho phendas lenđe: “Odvojin manđe akana e Varnava thaj e Savle palo delo savo si man pale lende.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Von askal, nakon so postisardine thaj molisardine, čhutine e vas po Varnava thaj po Savle thaj askal bičhaldine len po drom. ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","O Savle thaj o Varnava sas bičhalde e Sveto Duhostar ande Seleukija, a okotar đeline e lađicava ando Kipar. ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Kana aresle ando gav savo akhardolas Salamina, navestinas e Devlesko alav ande židovske sinagoge. O Jovano saves akharenas Marko sas lengo pomoćniko. ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Kana nakhline o sasto ostrvo aresline dži ko gav savo akhardolas Paf. Okote maladine varesaves vračares thaj hohavne prorokos, savo sas Židovo e alaveja Varisus. ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Vo sas ando društvo e upravnikosko e gođaver manušesa savo akhardolas Sergije Pavlo. Vo akhardas peste e Varnava thaj e Savle thaj zamolisarda len te phenen lenđe e Devlesko alav. ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ali lenđe usprotivisajlo o Elima o vračari (gajda prevodil pe lesko alav) thaj ačhilo te nagovoril e upravniko te na paćal ando alav e Devlesko. ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Askal o Savle, saves akharenas vi Pavle, ispunime e Sveto Duhosa, dikhla vorta ando Varisus Elim ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","thaj phendas lešće: “Tu san čhavo e benđesko thaj dušmano pe sa so si pravedno! Pherdo san svako prevara thaj bilačhipe. Zar či ačheja te banđares e ispravne droma e Gospodešće? ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ake, akana o vas e Gospodesko vazdel pes pe tute: koravoja thaj varesavi vrjama našti dićheja o svetlo e đesesko.” Thaj odma o baro tunjariko dijas pe lešće jakha thaj vo pipolas naokolo, thaj rodelas varekas te vodila les. ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Kana o upravniko dikhla so sas, paćajas thaj sas zadivime e Gospodešće sikavipeja. ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Nakon godova o Pavle thaj okola kaj džanas lesa otplovisardine e lađicava andar o Paf thaj aresline ando Pergu ande Pamfilija. Okote o Jovan saves akharenas Marko mukla len thaj bolda pes ando Jerusalim. ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","O Pavle thaj o Varnava đeletar andar o Pergu ande Pisidijsko Antiohija. A ando savato đeline ande sinagoga thaj bešline. ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Posle kana čitosardine andar o Zakon thaj andar e knjige e prorokonenđe, e vođe e sinagogaće bičhaldine varekas te phenel lenđe: “Phralalen, te si tumen vareso te mothon palo ohrabrenje e themešće, phenen!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pe godova o Pavle uštilo, vazdas piro vas thaj phendas: “Manušalen andar o Izrael thaj vi tumen savora aver save daran e Devlestar, ašunen: ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","O Del akale Izraelsko themesko, izabirisardas amare pradaden thaj umnožisardas amare themes pale vrjama dok trajinas sago strancurja ando Egipat. Thaj pire zurale vastesa inkalda len andar godoja phuv. ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Štarvardeš brš strpljivo podnosilas len ande pustinja. ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kana uništisarda ande Hanaansko phuv efta themen, dija lenđi phuv e Izraelconenđe ando nasledstvo. Sa akava sas kroz štar šela thaj pandžvardeš brš. ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Posle godova, o Del dija len sudijen, sa dži ko proroko Samuilo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Askal e manuša rodine te avel len caro, thaj o Del dija len e Saule, e Kisosće čhaves, andar o Venijaminesko pleme, savo vladilas štarvardeš brš. ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","A kana harada e Saules katar o prestolje, vazda lenđe e Davides palo caro, pale savo korkoro posvedočisardas: ‘Arakhlem e Davides e čhaves e Jeseješće, manušes savo si pe mungro ilo. Vo ćerela sa so me kamav.’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Andar o Davidesko potomstvo o Del sago kaj obećisarda, vazdas e Izraelošće Spasiteljes – e Isuse. ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Majsigo nego so avilo o Isus, o Jovano savo bolelas propovedilas sa izraelošće themešće kaj moraš te obratin pe e Devlešće thaj te bolen pe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Kana o Jovano završisarda piri služba phendas: ‘Pale kaste tumen inćaren man? Me naj sem okova pale savo gndin kaj sem. Ali ake, pale mande avel okova kašće me naj sem dostojno te putrav e sandale pe pungre.’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Phralalen, čhavra e Avraamešće thaj vi savora tumen aver save daran e Devlestar, amenđe si bičhaldi akaja poruka palo spasenje! ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","E manuša save bešen ando Jerusalim thaj lenđe šorvale vođe či pindžardine e Isuse, nego osudisardine les. Gajda pherdine e alava e prorokošće save čiton pe svako savato, a či haćaren len. ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Vi ako či arakhline nisošći doš zbog savi zaslužilas te avel mudardo, von mangline katar o Pilato te mudarel les. ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","A kana pherdine sa so si pale leste ramome, fuljardine les katar o trušul thaj čhutine les ando limori. ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ali o Del vazda les andar e mule, ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","thaj vo but đesa sikavelas pe okolenđe save avile lesa andar e Galileja ando Jerusalim, thaj akana von si lešće svedokurja anglo Izraelosko them. ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Amen akana mothas tumenđe e Bahtali nevimata: o obećanje savo o Del dijas amare pradadenđe ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","akana pherdas godova amare čhavrenđe godoleja kaj vazdas e Isuse andar e mule. Sago kaj si ramome ando dujto psalmo: ‘Tu san mungro Čhavo, ađes postanisardem ćiro Dad.’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","A pale godova kaj o Del vazda les andar e mule, te nikad či ćernjol, agajda phendas: ‘Dava tumen svete thaj pouzdane blagoslovurja, save obećisardem e Davidešće.’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Gajda vi pe aver than phenel: ‘Tu či deja te ćernjol ćiro sveco.’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Kaj o David poslužisardas ande Devlešći namera ande piri vrjama. Kana mulo, sas prahome paše pire pradada, thaj lesko telo ćernjilo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ali o Isus saves o Del vazdas andar e mule, či ćernjilo ando limori. ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Gajda džanen, phralalen, kaj kroz o Isus mothol pe tumenđe o jartipe katar tumare bezeha, thaj katar sa aver katar soste našti opravdin tumen ande Mojsijesko zakono. ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","E Isuseja opravdila pes svako savo paćal. ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Zato len sama te či avel tumenđe okova so o Del ramomosardas kroz e Prorokurja: ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Dićhen, tumen save maren muj, čudin tumen thaj propadnin, kaj ćerava vareso ande tumare đesa, ande soste či paćainesas, te vareko phendasas tumenđe.’” ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Kana o Pavle thaj o Varnava inkljenas andar e sinagoga, e manuša zamolisardine len te vi aver savato ćeren lenđe svato pale akava. ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Kana o sastanko sas gata e but Židovurja thaj e pobožne manuša save obratisajle po židovsko paćipe, teljardine palo Pavle thaj palo Varnava, save ćerenas lenca svato thaj poticinas len te ustrajno paćan ande Devlešći milost. ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ande aver savato gata o sasto gav ćida pe te ašunel o alav e Gospodesko. ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Kana e Židovske vođe dikhline o but o them, sas ljubomorne, thaj vređonas e Pavle gajda kaj mothonas protiv okova so vo motholas. ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","A o Pavle thaj o Varnava hrabro phendine lenđe: “Trubuja majsigo te o alav e Devlesko avel tumenđe e Židovenđe mothodo. Ali sar tumen odbacisardine o alav thaj smatrin kaj sen nedostojne e večno trajošće, akana džastar okolenđe save naj Židovurja. ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Kaj, agajda o Gospod korkoro zapovedisardas amenđe: ‘Ćerdem tut te aves svetlo okolenđe kaj naj Židovurja, te anes spasipe dži ko krajo e phuvjako.’” ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Kana ašundine godova, okola save nas Židovurja raduinas pe thaj slavinas e Gospodesko alav. Thaj okola kaj sas odredime palo večno trajo paćaine. ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","A o alav e Gospodesko buljilo pe sasto godova krajo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","A e židovske vođe vazdine pe buna varesave ugledne thaj pobožne manušnjen thaj e gavešće poglavaren te progonin e Pavle thaj e Varnava thaj te traden len andar pire krajurja. ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","A von duj džene ćhinosarde o praho katar pire pungre protiv lende sago znako kaj o Del sudila lenđe, thaj đeline ande Ikonija. ");
INSERT INTO rmyChergash_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","A e učenikurja pherdile bahtasa thaj e Svete Duhosa. ");
INSERT INTO rmyChergash_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Sago vi ande aver thana, gajda vi ande Ikonija o Pavle thaj o Varnava dine ande židovsko sinagoga thaj propovedinas, gajda kaj o but o them počnisarda te paćal, e Židovurja thaj okola save nas Židovurja. ");
INSERT INTO rmyChergash_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ali varesave Židovurja či paćajine, pobunisardine thaj ogorčisardine okolen save nas Židovurja protiv e phral. ");
INSERT INTO rmyChergash_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Askal o Pavle thaj o Varnava ačhiline okote još dosta dugo thaj hrabro ćerenas svato palo Gospod, savo potvrdilas o alav pale piri milost thaj dija len te ćeren znakurja thaj čudurja. ");
INSERT INTO rmyChergash_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Askal sa o them savo trajilas ande godova gav podelisajle, jek sas pale Židovurja a aver pale apostolurja. ");
INSERT INTO rmyChergash_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Varesave save nas Židovurja thaj vi e Židovurja, zajedno pire vođenca, udružisajle protiv o Pavle thaj protiv o Varnava. Kamline te maltretirin len thaj te čhuden e bara pe lende te mudaren len. ");
INSERT INTO rmyChergash_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Kana o Pavle thaj o Varnava ašundine pale godova, našline ande likaonske gava ande Listra thaj e ande Derva thaj lenđi okolina. ");
INSERT INTO rmyChergash_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Thaj okote nastavisardine te propovedin e Bahtali nevimata. ");
INSERT INTO rmyChergash_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ande Listra bešelas varesavo manuš savešće pungre sas line. Vo sas nepokretno katar piro bijandipe thaj nikada či phirelas. ");
INSERT INTO rmyChergash_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Dok ašunelas e Pavle sar propovedil, o Pavle pažljivo dikhla pe leste thaj dikhla kaj si les paćipe kaj šaj te avel sasto, ");
INSERT INTO rmyChergash_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","thaj e bare glasosa phendas lešće: “Ušti pe pungre uspravno!” Thaj o manuš odma huklo pe pire pungre thaj počnisarda te phirel. ");
INSERT INTO rmyChergash_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Kana e manuša dikhline so ćerda o Pavle, andar o sasto glaso čhutine muj pe likaonsko čhib: “E devla line e manušengo liko thaj fuljistine maškar amende!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Palo Varnava phendine kaj si grčko del o Zevs, a o Pavle Hermesija kaj o Pavle vodilas o glavno alav. ");
INSERT INTO rmyChergash_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","A o rašaj andar e Zevsesko hramo, savo sas odma pašo gav, anda e guruven thaj vencurja pe kapija thaj kamlas zajedno e themesa te prinesil e Pavlešće thaj e Varnavašće žrtve. ");
INSERT INTO rmyChergash_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Kana e apostolurja o Varnava thaj o Pavle ašundine pale godova, čhindine pe peste pire drze, pa prastajine maškar o them thaj čhonas muj: ");
INSERT INTO rmyChergash_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Manušalen, so ćeren godova? Vi amen sam samo manuša sago vi tumen. Amen avilam te phenas tumenđe e Bahtali nevimata, te bolden tumen katar godola bezvredne buća ko džudo Del savo stvorisarda o nebo, e phuv, o more thaj sa so si ande lende! ");
INSERT INTO rmyChergash_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","O Del ande okoja vrjama mukla sa e theme te džan pire dromesa, ");
INSERT INTO rmyChergash_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ali nikada či mukla tumen te či džanen okova so si čačipe pale leste: vo ćerel tumenđe lačhipe, del tumen o bršnd andar o nebo, thaj plodne brša, čaljarel tumen e habeja thaj pherel tumaro ilo e bahtasa.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ali vi ako phenenas godova jedva nagovorisardine e themes te na prinesin lenđe žrtve. ");
INSERT INTO rmyChergash_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Askal aresline varesave Židovurja andar e Antiohija thaj andar e Ikonija thaj pobunisardine e theme te čhuden pe e barenca ando Pavle thaj crdine les avrjal o gav, kaj gndisardine kaj si mulo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","A kana e učenikurja ćidine pe oko leste, vo uštilo thaj bolda pe palpale ando gav, a thejara o đes zajedno e Varnavasa đelo ando gav Derva. ");
INSERT INTO rmyChergash_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Kana navestisardine e Bahtali nevimata ande Derva thaj steknisardine but e učenikon, boldine pe ande Listra, Ikonijum thaj ande Antiohija. ");
INSERT INTO rmyChergash_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Okote zurardine e učenikonen thaj ohrabrisardine len te ačhen ando paćipe thaj phenelas lenđe kaj ande Devlesko carstvo trubun te den kroz e but nevolje. ");
INSERT INTO rmyChergash_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ande svako khanđiri o Pavle thaj o Varnava čhutine starešinen. Molinas pe thaj postinas, a askal dine len pe briga e Gospodešće, ande savo paćanas. ");
INSERT INTO rmyChergash_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pale godova nakhline kroz e Pisidija thaj aresline ande Pamfilija. ");
INSERT INTO rmyChergash_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Nakon so propovedinas o Alav e Devlesko ande Perga, askal đeline ande Atalija. ");
INSERT INTO rmyChergash_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Okotar otplovisardine ande Antiohija, kaj sas majsigo poverime ande milost e Devlešći pale služba savi ćerdine. ");
INSERT INTO rmyChergash_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Kana aresline ande Antiohija, ćidine e khanđiri thaj phendine sa so o Del ćerda prekal lende, thaj sar vi e manuša andar e aver thema putren o vudar te paćan. ");
INSERT INTO rmyChergash_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Thaj dugo ačhiline okote e učenikonenca. ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","A varesave manuša avile andar e Judeja ande Antiohija thaj ačhile te sikaven e phralen save nas Židovurja: “Ako či obrežin tumen prema e Mojsijesko običaj, našti spasina tumen.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Sar o Pavle thaj o Varnava zurale suprotivisajle lenđe avilo dži ke bari rasprava maškar lende. Zbog godova o Pavle, o Varnava thaj još varesave phral sas bičhalde te džan ando Jerusalim thaj te okote inkalen akava problemo angle apostolurja thaj angle starešine. ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","E khanđiri gajda bičhalda len po drom, a von sar naćhenas kroz e Fenikija thaj kroz e Samarija, ćerenas svato sa po redo sar obratisajle okola save nas Židovurja, a sa e phral sas bahtale zbog godova. ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Kana aresle ando Jerusalim, primisarda len e khanđiri, e apostolurja thaj e starešine. Askal o Pavle thaj o Varnava mothonas lenđe okova so o Del ćerda preko lende. ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Askal uštile varesave vernikurja andar e farisejenđi stranka thaj phendine: “Okola kaj naj Židovurja, trubun te obrežin pe thaj trubul te naredil pe lenđe te inćaren o Mojsijesko zakono.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Askal e apostolurja thaj e starešine arakhline pe zajedno te ćeren svato pale akava. ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Kana nakhlo o lungo svato maškar lende, uštilo o Petar thaj phendas: “Phralalen, džanen katar prve đesa kaj o Del man akhardas maškar tumende te okolenđe save naj Židovurja, mothav e Bahtali nevimata thaj te vi von paćan. ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","O Del, savo pindžarel e manušenđe ile, potvrdisarda kaj prihvatil len gajda kaj vi len dijas Sveto Duho, baš sago kaj dijas vi amen. ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Vo či ćerda nisošći razlika maškar lende thaj maškar amende, kaj vi lenđe ile šilada e paćimava. ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Sostar dakle, akana iskušin e Devle gajda kaj čhon e učenikonenđe o pharipe pe kor save našti inđarenas ni amare pradada niti amen? ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Amen paćas kaj sam spasime prekal e milost amare Gospodešći e Isusešći sago vi von.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pe godova savora smirosajle thaj ašunenas e Varnava thaj e Pavle, save mothonas pale znakurja thaj čudurja save o Del ćerda preko lende maškar okola save naj Židovurja. ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Kana o Pavle thaj o Varnava phendine so sas len, o Jakov askal phendas: “Phralalen, čhon kan mande. ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","O Simon Petar ćerda amenđe svato sar o Del prvo data sikadas piri ljubav okole themenđe kaj naj Židovurja thaj varesave lendar izabirisarda sago them pale peste. ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Akaleja složin pe vi e alava e prorokošće, sago kaj si ramome: ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Posle godova boldava man thaj vazdava e Davidesko harado šator; andar e ruševine vazdava les thaj obnoviva les, ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","te vi aver manuša roden e Gospode, okola saven akhardem te aven mungre andar sa e thema. Gajda phenel o Gospod, savo ćerel akava’, ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","‘a pindžardo si katar e dumutni vrjama.’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Zato me inćarav kaj či trubul te uznemirisaras okolen kaj naj Židovurja thaj save obratin pe e Devlešće. ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Umesto godova, neka ramol pe lenđe te na han habe savo si žrtvujime e idolenđe, te len pe majdur katar o bludo, te na han mas katar e mule životinje niti o rat. ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Kaj, ande svako gav si okola save još katar e dumutuni vrjama sikaven godola Mojsiješće zakonurja, save čiton pe svako savato ande sinagoge.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Askal e apostolurja thaj e starešine e saste khanđirava odlučisardine te maškar pende odvojin varesave manušen saven bičhalena e Pavlesa thaj e Varnavasa ande Antiohija. Gajda sas izabrano o Juda saves akharen Varsava thaj o Sila. Von sas vodeće manuša maškar e phrala. ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Preko lende bičhaldine akava lil ande savo ramolas: “Amen e apostolurja thaj e starešine, tumare phral, pozdravisaras sa amare phralen andar aver nacija ande Antiohija, ande Sirija, thaj ande Kilikija! ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ašundam kaj avile tumende varesave amendar, saven nas amari dozvola thaj zbunisardine tumen pire alavenca thaj uznemirisardine tumen, ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","gajda amen savora složisajlam te las varesave manušen thaj te bičhalas len tumende zajedno e volime phralenca e Varnavasa thaj e Pavlesa, ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","save pire trajurja čhutine pe kocka palo alav amare Gospodesko e Isuse Hristosko. ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Gajda bičhalas tumenđe e Juda thaj e Sila thaj von phenena tumenđe vi e alavenca isto akava so amen ramosardam. ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Odlučisardam, o Sveto Duho thaj amen, te na čas pe tumende aver pharipe sem akava so trubul: ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","na han katar o mas savo si žrtvuime e idolenđe, na han o rat thaj o mas e mule životinjengo, thaj na ćeren bludo. Te line tumen sama katar akava, lačhe ćerena. Ačhen saste!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Gajda dakle ispratisardine len po drom thaj von đeline ande Antiohija. Okote ćidine e themes thaj predaisardine lenđe o lil. ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Kana čitosardine o lil, sas bahtale zbog e poruka savi ohrabrisarda len. ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","A o Juda thaj o Sila, save vi korkoro sas prorokurja, ohrabrinas thaj učvrstinas e phralen e bute alavenca. ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Sar ačhiline okote varesavi vrjama, e phrala ando miro ispratisardine len palpale ke okola save bičhaldine len. ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ali o Sila dikhla kaj si majlačhe te ačhel okote, a o Juda bolda pes ando Jerusalim. ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","O Pavle thaj o Varnava ačhiline ande Antiohija, sikavenas e themes thaj e bute aver manušenca propovedinas o alav e Gospodesko. ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Posle varesavi vrjama o Pavle phendas e Varnavešće: “Hajde te boldas amen thaj te obiđisaras e phralen ande sa e gava kaj propovedisardam o alav e Gospodesko thaj te dikhas sar si!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","O Varnava kamlas pesa te inđarel vi e Jovane saves akharenas Marko, ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ali o Pavle gindilas kaj si majlačhe te na inđaren pesa okoles savo mukla len ande Pamfilija thaj či nastavisarda lenca o delo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Gajda avilo dži ke bari čingar andar savi razdvojisajle jek avrestar: O Varnava lijas pesa e Marko thaj otplovisarda palo Kipar, ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","a o Pavle lijas pesa e Silas thaj đelotar, pošto e phral poverisardine les ande milost e Gospodešće. ");
INSERT INTO rmyChergash_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","O Pavle naćhelas kroz e Sirija thaj kroz e Kilikija thaj zuravelas e khanđirja. ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Gajda o Pavle areslo ando gav savo akhardol Derva, a askal ande Listra, kaj trajilas o učeniko savo akhardolas Timotej. Vo sas čhavo e Židovkako savi sas vernica, a lesko dad nas Židovo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","O Timotej sas po lačho glaso maškar e phral ande Listra thaj ande Ikonija. ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pa o Pavle kamla te o Timotej džal lesa po drom, pa zato obrezisarda les sar prihvatisardinesas les e Židovurja save trajinas ande godola thana, kaj savora džanenas kaj lesko dad nas Židovo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Džanas andar o gav ando gav thaj phenenas e manušenđe e odluke save andine e apostolurja thaj e starešine ando Jerusalim thaj rodenas lendar te poštuin godola odluke. ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Gajda e khanđirja zuravonas ando paćipe thaj lengo brojo barjolas svako đes sa majbut. ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","A von nakhline kroz e regija Frigija thaj Galatija, kaj o Sveto Duho zabranisarda lenđe te propovedin e Devlesko Alav ande Cikni Azija. ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Kana aresline dži ke Mizisko granica, kamline te den ande Vitinija, ali e Isusesko Duho či mukla len. ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","A kana nakhline e Mizija, đeline ande Troada. ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Godoja rjat e Pavle sas viđenje: dikhla jek manuše andar e Makedonija savo ačhelas angle leste thaj molilas les e alavenca: “Av akaring ande Makedonija thaj pomožisar amenđe!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pale godova viđenje dikhlam so majsigo te teljaras ande Makedonija, zato kaj samas uverime kaj o Del akharel men okote te mothas lenđe e Bahtali nevimata. ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Andar e Troada otplovisardam pravo po otoko savo akhardolas Samotrak, a thejara o đes đelam ando Neapolj, ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","pa okotar ande Filipe, savo si rimsko kolonija thaj važno gav ande godova deo e Makedonijako. Ande godova gav ačhilam varekozom đesa. ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ando savato inkljistam avrjal o gav thaj đelam dži ke reka, kaj gndisardam kaj okote ćidel pe o them te molin pe. Okote bešlam thaj počnisardam te ćeras svato e ćidine manušnjenca. ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","A čholas kan amende vi jek pobožno manušnji savi akhardolas Lidija, savi bićinelas kuč lole pohtana andar o gav Tijatira. O Gospod putardas lako ilo te lačhe čhol kan ke okova so o Pavle phenelas. ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","A kana bolda pe voj thaj savora save trajinas ande lako ćher, zamolisarda men: “Ako gndin kaj čače paćav ando Gospod, aven thaj ačhen ande mungro ćher.” Thaj nagovorisarda men te ačhas late. ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Jekhvar dok džasas po than kaj molilas pe, maladam men varesave ropkinja. Voj sas opsednutime e bilačhe duhosa savo majanglal phenelas laće so avela. Pe godova način voj anelas bari zarada pire gospodarenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Voj teljarda palo Pavle thaj pale amende thaj čholas muj: “Akala manuša si sluge e majbare Devlešće! Aviline te navestin tumenđe o drom sar te spasin tumen!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Gajda ćerelas đesenca, pa kana e Pavlešće godova dojadisarda, bolda pe late thaj phendas e duhošće savo sas ande late: “Zapovediv tuće ando alav e Isuse Hristosko: inklji andar late!” Thaj o duho odma inkljisto. ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","A kana laće gospodarja dikhline kaj propadnisarda lenđi nada ande zarada, astardine e Pavle thaj e Sila thaj crdine len po trgo, angle šorvale. ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Thaj kana andine len angle upravnikurja, phendine: “Akala manuša save si Židovurja uznemirin amaro gav, ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","thaj propovedin e običaja save amen, e Rimljanurja, či tromas te prihvatis niti te inćaras.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Askal o them navalisarda po Pavle thaj po Sila, a e upravnikurja godole gavešće pharadine pe lende e drze thaj naredisardine te išibin len. ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Nakon so zurale išibisardine len, čhudine len ando phanglipe, thaj naredisardine e stražarešće te lačhe lel sama pe lende. ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Nakon so dobisarda kasavi naredba, vo čhuda len andre ande majzabacime deo e tamnicako, a lenđe pungre čhuta ande kaštune okurja. ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Kana varekaj katar e opaš e rjat o Pavle thaj o Sila molinas pe, đilabenas thaj slavinas e Devle, a aver okola save sas ando phanglipe ašunenas len. ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","A katar jekhvar nastanisarda gajda zuralo zemljotres kaj e phanglipešće temeljurja ćhinosajle. Odma sa e vudara pe tamnica putajle, thaj savorenđe peline e okurja! ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","O stražari džungadilo andar o suno, pa kana dikhla kaj si o vudar e tamnicako putardo, inkalda o mačo thaj kamlas te mudarel pe kaj gndisarda kaj e phangle našline. ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ali o Pavle andar sasto glaso čhuta lešće muj: “Na ćer tuće nisosko bilačhipe! Savora sam akate!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Askal o tamničari naredisarda te anen e lampe thaj prastaja andre. Ćhinolas pe e daratar thaj pelo pe koča anglo Pavle thaj anglo Sila. ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Askal inkalda len avri thaj phučla len: “Rajalen, so trubul te ćerav te spasiv man?” ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","A von phendine lešće: “Paća ando Gospod Isus, thaj spasija tut, tu thaj vi savora andar ćiro ćher!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Askal navestisardine o Alav e Gospodesko lešće thaj savorenđe ande lesko ćher. ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Još isto časo ande godoja rjat o stražari lijas e Pavle thaj e Sila thaj thoda lenđe rane. Thaj odma pale godova vo thaj savora andar lesko ćher boldine pe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Askal anda len ande piro ćher, dija len te han thaj raduisajlo zajedno savorenca save trajinas lesa ando ćher zato kaj paćaine ando Del. ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Kana svanosardas, e upravnikurja bičhaldine e službenikonen ko stražari e porukasa: “Oslobodisar godole duj manušen!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Askal o stražari phendas e Pavlešće: “E upravnikurja phendine te mukas tumen. Akana inkljen thaj džan ando miro!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","A o Pavle phendas: “Javno mardine men, a či dokažisardine amenđe e doš. Čhudine men ande tamnica vi ako sam rimske građanurja, a akana kamline sas čordane te mućen amen te džastar! Nipošto! Neka korkoro aven thaj inkalen amen!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Kana e službenikurja phendine e upravikonenđe so phendas o Pavle thaj kana akala saznaisardine kaj si o Pavle thaj o Sila rimske građanurja, darajle, ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","pa aviline lende te jarton pe, inkaldine len avri thaj zamolisardine len te džantar andar o gav. ");
INSERT INTO rmyChergash_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Kana o Pavle thaj o Sila inkljistine andar e tamnica đeline ande Lidijako ćher, te dićhen pe e phralenca thaj te ohrabrin len, pa đeletar andar o gav. ");
INSERT INTO rmyChergash_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Kana o Pavle thaj o Sila nakhline kroz e gava Amfipolj thaj kroz e Apolonija, avile ando Soluno, kaj sas e židovsko sinagoga. ");
INSERT INTO rmyChergash_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","O Pavle, pe piro običaj, dijas lende ande sinagoga, pa gajda trin savaturja raspravilas lenca pale Svete lila. ");
INSERT INTO rmyChergash_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Vo objasnilas thaj dokažilas lenđe: “E Hristo trubuja te mudaren thaj te vo uštela andar e mule. A godova Hristos si o Isus saves me objavisarav tumenđe.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Varesave katar e Židovurja paćajine thaj pridružisajle e Pavlešće thaj e Silašće, a gajda vi e but pobožne Grkurja thaj but ugledne manušnja. ");
INSERT INTO rmyChergash_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ali e Židoven astarda e ljubomora thaj andar godova line varesaven bilačhe manušen katar o trgo, ćidine e bute themes thaj ćerdine pobuna ando gav. Askal dine po Jasonesko ćher thaj rodenas e Pavle thaj e Sila te inkalen len te sudil pe lenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","A kana či arakhline e Pavle thaj e Sila, astardine e Jasone thaj još varesave phralen, crdine len angle gavešće šorvale manuša thaj čhonas muj: “Vi akate avile okola kaj uzbunisardine o sasto carstvo, ");
INSERT INTO rmyChergash_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","a o Jason primisarda len ande piro ćher! Savora von ćeren protiv e carošće uredbe, gajda kaj mothon kaj postojil aver caro – o Isus!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Kana o them thaj e gavešće šorvale ašundine akava, uznemirisajle, ");
INSERT INTO rmyChergash_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ali mukline len pe sloboda tek kana line katar o Jason thaj katar aver phrala zalog. ");
INSERT INTO rmyChergash_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Čim peli e rjat, e phrala bičaldine e Pavle thaj e Sila ande Verija. Kana aresline okote, počnisardine te džan ande židovsko sinagoga. ");
INSERT INTO rmyChergash_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Okote e Židovurja sas majplemenite katar okola andar o Soluno thaj spremno prihvatisardine o alav e Devlesko. Svako đes istražinas e Svete lila te dićhen dali si godova čače gajda sar phenen o Pavle thaj o Sila. ");
INSERT INTO rmyChergash_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Askal e but Židovurja paćajine, a gajda vi but ugledne Grkinje thaj baro brojo Grkurja. ");
INSERT INTO rmyChergash_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Kana e Židovurja andar o Soluno ašundine kaj o Pavle vi ande Verija propovedil o alav e Devlesko, avile thaj vi okote uznemirisardine thaj pobunisarde e themes. ");
INSERT INTO rmyChergash_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Askal e phral odma bičaldine e Pavle ando primorje, a o Sila thaj o Timotej ačhiline ande Verija. ");
INSERT INTO rmyChergash_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","A okola kaj pratinas e Pavle, đele leja dži ke Atina thaj askal boldine pe ande Verija. Preko lende o Pavle bičhaldas poruka e Silašće thaj e Timoteješće te so majsigo aven leste. ");
INSERT INTO rmyChergash_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Dok o Pavle ažućarelas len ande Atina, sas zurale uznemirime kaj dićhelas o gav kaj si pherdo idolurja. ");
INSERT INTO rmyChergash_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","E Židovenca thaj e pobožno Grkonenca raspravilas ande sinagoga thaj svako đes po glavno trgo okolenca save okote maladinesas pe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Gajda astardine te raspravin pe e Pavlesa varesave epikurejcurja thaj e stojičke filozofurja. Jek phenenas: “So akava brbljivco kamel te phenel?” A aver phenenas: “Izgledil kaj propovedil e averenđe devlen” – kaj propovedilas e Bahtali nevimata palo Isuso thaj palo uštipe andar e mule. ");
INSERT INTO rmyChergash_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Askal line les thaj inđardine les po sastanko anglo veće po Areopag thaj phendine lešće: “Šaj li phenes amenđe te džanas, sosko si godova nevo sikavipe savo sikaves? ");
INSERT INTO rmyChergash_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Čhos ande amare kan čudne stvarja. Pa kamlamas te džanas so godova trubujasas te značil.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","A sa e manuša andar e Atina thaj e strancurja save trajinas maškar lende či provodinas e vrjama ni ande soste aver osim te ćeren svato thaj te ašunen o nevipe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","O Pavle ačhilo maškare ando Areopag thaj phendas: “Manušalen andar e Atina! Dikhav kaj sen ande svako vas zurale religiozne. ");
INSERT INTO rmyChergash_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Dok phiravas po gav pažljivo dikhavas tumare svetinje, a arakhlem vi jek žrtveniko pe savo sas ramome: ‘E bipindžarde Devlešće.’ Okova so dakle tumen či pindžaren, a poštujin – godole Devle me objavisarav tumenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","O Del savo stvorisarda o them thaj sa ande leste, Gospodari si e nebesko thaj e phuvjako thaj zato či trajil ande hramurja save si ćerde e manušenđe vastenca. ");
INSERT INTO rmyChergash_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Niti trubun te poslužin les e manušenđe vas, sago kaj si lešće vareso potrebno. Kaj vo si godova savo savorenđe del o trajo, o daho thaj sa aver. ");
INSERT INTO rmyChergash_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","O Del katar o jek manuš stvorisarda sa e manušen te pheren e sasti phuv thaj majanglal odredisardas lenđe e vrjama thaj o than kaj bešena. ");
INSERT INTO rmyChergash_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","O Del ćerda godova te e manuša roden les, či li varesar inzardinesas pire vas prema leste thaj te araćhen les, vi ako vo naj dur ni katar jek amendar. ");
INSERT INTO rmyChergash_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","‘Kaj, ande leste trajisaras, phiras thaj postojisaras’, sago kaj phendine vi varesave katar tumare pesnikurja: ‘Vi amen sam lešće potomkurja.’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Sar sam amen, dakle, e Devlesko potomstvo, či tromas te gndisaras kaj si o Del sago o kipo ćerdo katar o sunakaj ili rup ili katar o bar save ćerdine e manušenđe vas thaj lenđi mašta. ");
INSERT INTO rmyChergash_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","O Del či lel ando obzir e vrjama kana senas ando bidžanglipe, ali o Del akana zapovedil sa e manušenđe pe svako than te pokajin pe, ");
INSERT INTO rmyChergash_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","kaj odredisarda o đes kana pravedno sudila sa e themenđe prekal o Manuš saves odredisardas. Godova potvrdisarda angle sa e manuša kana vazda les andar e mule.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Kana ašundine kaj spomenil o uštipe andar e mule, varesave marenas muj, a aver phendine: “Pale akava čhasa tute kan aver data!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Gajda o Pavle đelotar lendar. ");
INSERT INTO rmyChergash_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ipak, varesave manuša pridružisajle lešće thaj paćajine, a maškar lende sas vi o Dionisije savo sas člano ande baro veće po Areopag, thaj e manušnji alaveja Damara thaj aver manuša. ");
INSERT INTO rmyChergash_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Pale godova o Pavle đelo andar e Atina ando Korint. ");
INSERT INTO rmyChergash_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Okote arakhlas varesave Židovo savo akhardolas Akila, savo sas bijando ando Ponto, thaj nas but vrjama sar avilo andar e Italija zajedno pire romnjasa savi akhardolas Priskila, kaj o caro Klaudije zapovedisarda te sa e Židovurja džantar andar o Rimo. O Pavle đelo lende, ");
INSERT INTO rmyChergash_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","sar ćerenas isto bući sago vi vo – ćerenas šatorja, o Pavle ačhilo lende thaj ćerelas bući zajedno lenca. ");
INSERT INTO rmyChergash_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","A svako savato o Pavle raspravilas ande sinagoga thaj kamlas te uveril e Židoven thaj e Grkonen. ");
INSERT INTO rmyChergash_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Kana o Sila thaj o Timotej aresline andar e Makedonija, o Pavle posvetisajlo te propovedil thaj svedočil e Židovenđe kaj o Isus si o Hristo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ali, kana e Židovurja počnisardine te protivin pe lešće thaj te vređon les, o Pavle ćhinosarda o praho katar pire drze sago znako kaj o Del sudila lenđe, thaj phendas lenđe: “Tumaro rat perela pe tumare šore. Me naj sem došalo. Katar akana džav te propovediv okolenđe save naj Židovurja.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Thaj đelotar okotar, pa dija ando ćher ke jek manuš savo daralas e Devlestar thaj akhardolas Titije Just, kasko ćher sas odma paše sinagoga. ");
INSERT INTO rmyChergash_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","A o Krisp o vođa e sinagogako, paćaja ando Gospod saste pire ćheresa. A paćaine thaj bolajle vi but manuša andar o Korint save ašundine les. ");
INSERT INTO rmyChergash_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Jek rjat o Gospod phendas e Pavlešće ande vizija: “Na dara, nego ćer svato thaj na ačh! ");
INSERT INTO rmyChergash_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Kaj, me sem tusa thaj khonik či napadnila tut niti naudila tuće, kaj ande akava gav si but okola save pripadin manđe.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Gajda o Pavle ačhilo okote jek brš thaj šov čhon thaj sikavelas e manušen e Devlesko alav. ");
INSERT INTO rmyChergash_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","A kana sas o Galion upravniko ande pokrajina Ahaje, e Židovurja složno navalisardine po Pavle thaj inđardine les po sudo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Thaj phendine: “Akava manuš nagovoril e manušen te protiv o zakono poštuin e Devle.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","A kana o Pavle kamlas vareso te phenel, o Galion phendas e Židovenđe: “Židovurja, čhutemas kan tumende, te avilosas o svato pale varesavi nepravda ili bilačhipe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ali, sar si akaja rasprava zbog tumaro sikavipe, alava thaj tumaro zakon, rešin godova korkoro. Me ande godova či kamav te avav sudco.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Thaj trada len andar e sudnica. ");
INSERT INTO rmyChergash_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Askal von astardine e Sostene, e sinagogaće vođa, thaj počnisardine te maren les anglo sudo. A o Galion či marisarda pale godova ni cara. ");
INSERT INTO rmyChergash_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","O Pavle ačhilo ando Korinto još but đesa, a pale godova jartosajlo katar e phral, pa e Priskilava thaj laće romeja e Akilava otplovisarda prema e Sirija. Ande Kenhreja čhinda pešće bal, zato kaj ćerda zavet. ");
INSERT INTO rmyChergash_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Kana aresline ando gav Efes, vo mukla len thaj korkoro dija ande sinagoga thaj počnisarda te raspravil pe e Židovenca. ");
INSERT INTO rmyChergash_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Von zamolisardine les te ačhel još varesavi vrjama, ali vo či pristanisarda, ");
INSERT INTO rmyChergash_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","nego jartosajlo lendar thaj phendas lenđe: “Te dija o Del boldava man tumende.” Thaj otplovisardas andar o Efes. ");
INSERT INTO rmyChergash_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Kana areslo ande Kesarija, đelo opre ando Jerusalim te pozdravil e khanđirja, a pale godova đelo ande Antiohija. ");
INSERT INTO rmyChergash_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Pošto sas ande Antiohija varesavi vrjama, đelotar okotar, thaj džalas katar o than dži ko than kroz e regija Galatija thaj Frigija thaj zuravelas e učenikonen ando paćipe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","A ando Efes areslo varesavo Židovo savo akhardolas Apolos. Vo sas lačho govorniko andar e Aleksandrija thaj lačhe pindžarelas e Svete lila. ");
INSERT INTO rmyChergash_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Vo sas sikado pale Gospodesko drom, thaj e bare žarosa ćerelas svato thaj tačno sikavelas palo Isus vi ako džanelas samo pale Jovanesko bolipe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Vo počnisarda hrabro te ćerel svato ande sinagoga, pa kana ašundine les o Priskila thaj e Akila, akhardine les peste thaj majlačhe objasnisardine lešće o Drom e Devlesko. ");
INSERT INTO rmyChergash_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Kana o Apolos odlučisarda te džal ande Ahaja, e phral ohrabrisardine les thaj ramosardine e vernikonenđe te šukar primin les. Kana areslo okote, but pomognisardas okolenđe save prekal e milost e Devlešći postanisardine vernikurja, ");
INSERT INTO rmyChergash_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","kaj ande javne rasprave snažno dokažilas e Židovenđe prekal o Sveto lil kaj o Isus si Hristo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Dok sas o Apolos ando Korint, o Pavle putuilas kroz e unutarnje thana godole phuvjaće thaj avilo ando Efes. Okote arakhla varesave učenikonen, ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","thaj phučla len: “Dali primisardine e Sveto Duho kana paćaine?” A von phendine lešće: “Či ni ašundam kaj si Sveto Duho.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","A o Pavle phučla len: “Savo bolipe askal primisardine?” A von phendine: “E Jovanesko bolipe.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","O Pavle phendas: “O Jovano bolelas e bolipeja palo pokajipe. Motholas e Izraelconenđe te paćan ande okova savo avela pala leste – ando Isus.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Kana godova ašundine bolajle ando alav e Gospodesko e Isusesko. ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","A kana o Pavle čhuta pire vas pe lende, o Sveto Duho fuljisto pe lende thaj von ačhile te ćeren svato ande aver čhibja thaj te prorokujin. ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","A sas sa zajedno varekaj katar dešuduj manuša. ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Askal o Pavle džalas ande sinagoga thaj trin čhon hrabro propovedilas, raspravilas thaj uverilas e themes palo Devlesko carstvo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ali, sar sas varesave lendar tvrdoglave thaj nepokorne thaj angle savorende kaljarenas e Gospodesko drom, o Pavle mukhla len, lijas pesa e učenikonen thaj svako đes vodilas rasprava ande učionica jeće manušešći savo akhardolas Tiranin. ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Godova sas duj brš, gajda kaj sa e stanovnikurja andar e Cikni Azija, e Židovurja thaj okola kaj nas Židovurja, ašundine o Alav e Gospodesko. ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","O Del preko e Pavlešće vas ćerelas but bare čudurja. ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Gajda kaj vi e dikhlora thaj e haravlje save o Pavle dirdas sas inđarde ke nasvale thaj von sastonas katar piro nasvalipe, a e bilačhe duhurja inkljenas andar lende. ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","A varesave Židovurja save džanas katar o than dži ko than thaj tradenas e bilačhe duhonen andar e manuša, probisarde pe okola ande save sas e bilačhe duhurja te akharen o alav e Gospodesko Isusesko. Phenenas: “Ando alav e Isusesko saves o Pavle propovedil, zapovediv tumenđe inkljen avri!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Godova ćerenas e efta čhave katar varesavo šerutno židovsko rašaj savo akhardolas Skeva. ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ali o bilačho duho phendas lenđe: “E Isuse pindžarav, a vi e Pavle džanav, ali ko sen tumen?” ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Thaj o manuš ande savo sas o bilačho duho, huklo pe lende, svladisarda len thaj gajda zurale marda len kaj našline andar godova ćher nanđe thaj ratvale. ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Akava ašundine sa e Židovurja thaj okola save nas Židovurja save trajinas ando Efes. Sa len astarda e dar thaj barjarenas o alav e Gospodesko Isusesko. ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","But okolendar save paćaine avenas thaj priznainas pire bilačhe buća. ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","A but lendar savenđi bući sas te drabaren, andine pire čarobne knjige thaj angle savorede dine len jag. A kana đinadine kozom molas e čarobne knjige, arakhline kaj monas pandžvardeš milje rupune lovora. ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Gajda e Gospodešće snagava o Alav buljolas thaj zuravolas. ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Posle sa akava so sas, o Pavle ando Duho odlučisardas te naćhel kroz e Makedonija thaj kroz e Ahija, a okotar te džal ando Jerusalim. O Pavle phendas: “Posle godova moraš te džav vi ando Rimo.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Askal bičhaldas ande Makedonija pire dujen pomoćnikon, e Timoteje thaj e Eraste, a vo još varesošći vrjama ačhilo ande Cikni Azija. ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ande godoja vrjama avilo dži ke bari buna protiv o Drom e Gospodesko. ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Kaj varesavo kovači alaveja Dimitrije, savo ćerelas cikne Artemidaće hramurja katar o rup thaj gajda e zanatlijenđe anelas bari zarada. ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Vo ćida sa e zanatlijen thaj aver bućarne manušen e slično bućava thaj phendas: “Manušalen, tumen džanen kaj amaro barvalipe avel katar akaja bući. ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Vi korkoro dićhen thaj ašunen kaj akava Pavle uverisardas thaj diljardas e but e themes na samo ando Efes nego gata vi ande sasti Cikni Azija gajda kaj mothol kaj e devla save si ćerde e manušenđe vastenca naj devla. ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Si opasnost na te samo o ugled amare bućako avel po bilačho glaso, već vi godova te o hramo e bare boginjako e Artemidako hasarel piro značaj thaj te piro veličanstvo hasarel e boginja savja slavil e sasti Cikni Azija, thaj sa o them!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Kana akala ašundine akava, lija len e bari holji, thaj čhonas muj: “Bari si e efeško Artemida!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Askal o sasto gav uzbunisajlo thaj sa zajedno prastajine ando pozorište, thaj crdine pesa e dujen manušen save putuinas e Pavlesa, e Gaje thaj e Aristarhes andar e Makedonija. ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","O Pavle lijas te inkljel anglo them, ali e učenikurja či dine les. ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Čak vi varesave ugledne manuša andar e Cikni Azija save sas e Pavlešće drugarja, poručisardine lešće thaj zamolisardine les te na avel ando pozorište. ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Andre ando pozorište jek čhonas muj jek, a aver čhonas muj aver, kaj o ćidino them sas zbunime thaj či ni džanenas sostar ćidine pe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","E Židovurja spidine e Aleksandre te inkljel anglal o them, a varesave phendine lešće so te phenel. O Aleksandar e vastesa zamolisarda te čhon kan leste kaj kamlas te obranil pe anglo them. ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ali kana haćardine kaj si Židovo, savora duj saturja čhonas glasno muj: “Bari si e efeško Artemida!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Askal e gavesko pisari smirosarda e themes thaj phendas: “Manušalen andar o Efes! Dali si manuš savo či džanel kaj o gav Efes lel sama po hramo e bare Artemidako thaj pe lako kipo savo pelo katar o nebo? ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Sar godova naj sporno, tumen trubun te smiron tumen thaj te khanči či brzopleto ćeren. ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Kaj andine akale manušen akaring vi ako či čordine andar o hramo thaj či vređosardine amare boginja. ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ako dakle o Dimitrije thaj e zanatlije save si lesa kamen varekas te prn, e sudurja si putarde, a akate si vi e upravnikurja – pa nek prn pes. ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","A te roden vareso majbut, godova rešila pe ande zakonito skupština. ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Kaj pretil amenđe opasnost te avas optužime pale pobuna savi sas ađes, a naj nijek razlogo sar šaj te opravdisaras akava nered.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Thaj kana godova phendas mukla e themes te džaltar. ");
INSERT INTO rmyChergash_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Kana e pobuna smirisajli, o Pavle bičhaldas pale učenikurja, thaj ohrabrisarda len, pozdravisajlo lenca thaj đelotar ande Makedonija. ");
INSERT INTO rmyChergash_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Naćhelas kroz godola krajurja thaj ohrabrilas e učenikonen e bute alavenca. Gajda areslo ande Grčka, ");
INSERT INTO rmyChergash_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","thaj ačhilo okote trin čhon. A baš kana trubuja te otplovil palpale ande Sirija, ašunda kaj e Židovurja čhutine lešće zamka, pa odlučisarda te boldel pe kroz e Makedonija. ");
INSERT INTO rmyChergash_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","A pale leste teljardine o Sopater, e Pirosko čhavo andar e Verija, o Aristarh thaj o Sekund andar o Soluno, o Gaj andar e Derva, o Tihik thaj o Trofim andar e Cikni Azija, thaj o Timotej. ");
INSERT INTO rmyChergash_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Von teljardine majsigo amendar thaj ažućardine men ande Troada. ");
INSERT INTO rmyChergash_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","A amen isplovisardam andar e Filipe palo o Prazniko e bikvascošće mangrengo. Pandž đes majposle pridružisajlem lenđe ande Troada thaj okote ačhilam efta đes. ");
INSERT INTO rmyChergash_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","A o prvo đes ando kurko, kana ćidam men pe Gospodnjo večera, o Pavle motholas lenđe. Sar kanisarda thejara o đes te otplovil, propovedilas sa dži ke opaš e rjat. ");
INSERT INTO rmyChergash_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","A opre ande soba kaj samas ćidine sas but svetiljke. ");
INSERT INTO rmyChergash_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","A varesavo terno čhavo savo akhardolas Evtih bešelas pe pendžera. Sar o Pavle ćerelas dugo svato, les lija e lindri. Kana o suno skroz svladisarda les, vo pelo katar o trito sprato pe phuv, a kana vazdine les vo sas već mulo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","O Pavle fuljisto tele, dija koča pašo čhavo, dijale mrtiko thaj phendas: “Na uznemirin tumen, džudo si!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Pale godova lija pe opre, te podelil e Gospodnjo večera thaj halas lenca. Dugo ande rjat još ćerelas lenđe svato sa dok či svanosardas, a askal đelotar. ");
INSERT INTO rmyChergash_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","A e terne čhave andine ćhere džude, thaj savora sas utešime. ");
INSERT INTO rmyChergash_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Amen teljardam anglal e lađicava thaj otplovisardam ando Asos, okotar trubuja te inđaras e Pavle. Vo gajda odredisardas, kaj kamlas te džal korkoro, phujatar. ");
INSERT INTO rmyChergash_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","A kana maladilam lesa ando Asos, lijam les ande lađica thaj areslam ande Mitilina. ");
INSERT INTO rmyChergash_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Thejara o đes isplovisardam andar o Mitilina thaj areslam paše pašo otoko Hios. Aver đes areslam dži ko otoko Samosa, a đes pale godova areslam vi ando Milit. ");
INSERT INTO rmyChergash_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Kaj o Pavle odlučisarda te či naćhel kroz o Efes, a či kamlas te zadržil pe ande Cikni Azija kaj siđarelas, te aresel ako si moguće ando Jerusalim dži ko prazniko Pedesetnica. ");
INSERT INTO rmyChergash_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Andar o Milit bičhaldas ando Efes pale khanđirjaće starešine. ");
INSERT INTO rmyChergash_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Kana aviline, phendas lenđe: “Tumen džanen sar trajivas sasti vrjama dok semas tumenca, katar o prvo đes kana areslem ande Cikni Azija. ");
INSERT INTO rmyChergash_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Služisardem e Gospodešće ponizno, ande jasva thaj ande kušnje save aresline man zbog e židovenđe zamke. ");
INSERT INTO rmyChergash_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Nikada či ačhilem te phenav tumenđe sa so si korisno pale tumende thaj te sikavav tumen javno thaj pe tumare ćhera. ");
INSERT INTO rmyChergash_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Upozorivas e Židoven thaj okolen save nas Židovurja te mućen pe katar piro bezeh te obratin pe e Devlešće thaj te paćan ande amaro Gospod o Isus. ");
INSERT INTO rmyChergash_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","A akana, ake, zato kaj o Sveto Duho tradel man, džav ando Jerusalim, a so okote ažućarel man či džanav. ");
INSERT INTO rmyChergash_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Samo džanav kaj ande svako gav o Sveto Duho upozorilas thaj phenelas kaj ažućarel man o phanglipe thaj nevolje. ");
INSERT INTO rmyChergash_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ali manđe ni cara či ačhilo dži ko trajo, samo te završiv mungri trka thaj e služba savi primisardem katar o Gospod Isus – te svedočiv e Bahtali nevimata pale Devlešći milost. ");
INSERT INTO rmyChergash_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Akana, ake, džanav kaj khonik tumendar, maškar save putuisardem thaj phenavas pale Devlesko carstvo, majbut či dićhena man. ");
INSERT INTO rmyChergash_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Zato ađes jasno phenav tumenđe: naj sem došalo ako vareko tumendar propadnil. ");
INSERT INTO rmyChergash_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Kaj či ačhilem te navestiv tumenđe e sasti Devlešći volja. ");
INSERT INTO rmyChergash_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Len sama pe tumende thaj pe sa okola saven o Sveto Duho poverisarda tumenđe pe briga. Tumen sen pastirja, a von si tumaro stado – e Devlešći khanđiri, savja o Del otkupisarda pire rateja. ");
INSERT INTO rmyChergash_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Džanav kaj, pale mande kana me džavatar, maškar tumende avena e opasne ruva save či štedina o stado. ");
INSERT INTO rmyChergash_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Čak vi maškar tumende avena varesave save banđarena o sikavipe te crden e učenikonen pale peste. ");
INSERT INTO rmyChergash_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Zato len tumen sama! Thaj den tumen gođi kaj semas tumenca trin brš thaj neprestalno, đesenca thaj e raćenca, opominjivas tumen ande jasva. ");
INSERT INTO rmyChergash_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","A akana dav tumen e Devlešće pe briga, thaj e porukaće pale lešće milosti savi šaj te bajrarel tumen thaj te del tumen nasledstvo maškar sa okola save si posvetime. ");
INSERT INTO rmyChergash_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Nikada či kamlem ande mungro ilo khonikasko rup, sunakaj ili e drze. ");
INSERT INTO rmyChergash_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Vi korkoro džanen, kaj akale mungre vastenca ćeravas bući pale okova so trubul man thaj okolen save sas manca. ");
INSERT INTO rmyChergash_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ande sa so ćeravas semas tumenđe primer, sar trubun te trudin tumen, thaj te aven ando pomoć okolenđe save si ande nevolje. Sikadem tumen te pamtin so korkoro o Gospod Isus phendas: ‘Maj blagoslovime si te del pe nego te lel pe.’ ” ");
INSERT INTO rmyChergash_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Kana godova phendas, o Pavle dija koča thaj zajedno savorenca pomolisajlo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Askal savora line te roven, te den mrtiko e Pavle thaj čumiden les, ");
INSERT INTO rmyChergash_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","majbut sas žalosne zbog godova kaj phendas lenđe kaj majbut či dićhena les. A pale godova otpratisardine les pe lađica. ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Pale godova oprostisajlam lendar, isplovisardam thaj plovisardam vorta dži ko otok Kos, a thejara đes otplovisardam po otok Rodos, a okotar ando gav Patar. ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Inća arakhlam lađa savi džalas pale Fenikija, dijam ande lađa thaj otplovisardam. ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Kana dikhlam o Kipar, nakhlam katar amari levo rig thaj teljardam majdur prema e Sirija. Areslam ando than Tiro, kaj okote trubuja katar e lađa te fuljarel pe tele o tereto. ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Okote arakhlam e učenikonen, thaj ačhilam lenca efta đesa. A von, kroz o Duho phenenas e Pavlešće te na džal ando Jerusalim. ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ali kana nakhline e đes save samas okote, ipak đelamtar majdur po drom, a von savora e romnjeca thaj e čhavrenca ispratisardine men dži avri andar o gav. Okote pe obala dijam koča thaj molisajlam. ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Kana pozdravisajlam jek avrenca, dijam ande lađica, a von boldine pe ćhere. ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Andar o Tiro nastavisardam e plovidba thaj areslam ande Ptolemaida. Okote pozdravisardam e phralen thaj ačhilam lenca jek đes. ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Thejara đes đelamtar okotar thaj areslam ande Kesarija. Okote ačhilam ando ćher e Filipesko, savo sas propovedniko e Bahtale nevimatako – jek katar efta manuša saven e vernikurja ando Jerusalim odabirisardine te vodil e briga pale udovice. ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Les sas štar čheja save nas udajime thaj save prorokuinas. ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Sar samas okote but đesa, andar e Judeja areslo varesosko proroko savo akhardolas Agav. ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Vo avilo amende, lija e Pavlesko pojas, thaj phanglas pire vas thaj pire pungre thaj phendas: “Akava phenel o Sveto Duho: ‘Gajda e Židovurja ando Jerusalim phandena e manušes savesko si akava pojas thaj predaina les okolenđe save naj Židovurja ande vas.’ ” ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Kana ašundam godova počnisardam vi amen thaj vi e manuša kaj trajinas okote te molisaras e Pavle te na džal ando Jerusalim. ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Askal o Pavle phendas: “Sostar roven thaj phađen mungro ilo? Palo alav e Gospodesko Isusesko me sem spremno na samo te avav phanglo, nego vi te merav ando Jerusalim.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Ali sar či dijas te nagovorisaras les, vazdam e vas thaj phendam: “Nek avel sar o Gospod kamel.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Pale godova spremisajlam thaj đelam ando Jerusalim. ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Amenca teljardine vi varesave učenikurja andar e Kesarija thaj andine men ando ćher e Mnasonesko andar o Kipar. Vo sas jek katar e prve učenikurja, te avas lešće gosturja. ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Kana areslam ando Jerusalim, e phrala šukar primisardine men. ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Thejara o đes o Pavle teljarda amenca ko Jakov, kaj sas prisutne vi sa e starešine andar e Jerusalimsko khanđiri. ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","O Pavle pozdravisarda len thaj sa po redo mothodas lenđe sa so o Del ćerda maškar okola save naj Židovurja kroz lešći služba. ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Kana von godova ašundine, dine slava e Devlešće thaj phendine e Pavlešće: “Dićhes phrala, dešenca milje Židovurja si save paćaine thaj sa revno sledin e Mojsijesko zakono? ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","A pale tute ašundine kaj sa e Židoven save trajin maškar okola kaj naj Židovurja, sikaves te či poštuin e Mojsijesko zakono thaj te na obrezin pire čhavren thaj te na inćaren amare običaja. ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","So akana te ćeras? Von sigurno ašunena kaj avilan, ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","pa zato ćer gajda sar phenas tuće. Amende si štar manuša save zavetuisajle e Devlešće. ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Le len thaj obredno šlav tut zajedno lenca thaj poćin pale lende o obred te šaj randen pesko šoro. Gajda savora džanena kaj naj čače okova so ašundine pale tute, nego kaj vi tu korkoro inćares e Mojsijesko Zakon thaj trajis prema leste. ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","A pale okola manuša save naj Židovurja, a save postanisardine vernikurja, amen lenđe bičhaldam akaja amari odluka: te na han habe savo si žrtvujime e idolenđe, te na han rat thaj mas e mule životinjengo thaj te na ćeren bludo.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Thejara o đes o Pavle lijas okole manušen, pa zajedno lenca izvršisarda o obredno šilaipe. Askal dijas ando Hramo te mothol kana inkljena e obredne đesa palo šilaipe thaj kana avena prinesime e žrtve pale savorende lendar. ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Kana akala efta đesa skoro nakhline, varesave Židovurja andar e Cikni Azija dikhline e Pavle ando Hramo, vazdine e themes pe leste thaj astardine les. ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Čhonas muj: “Manušalen andar o Izrael, pomognin! Akava si okova kaj posvuda sikavel sa e manušen protiv amaro them, protiv amaro zakon thaj protiv akava than! Čak vi okolen save nas Židovurja anda andre ando Hramo thaj gajda poganil akava than!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Akava phendine kaj majsigo, dikhline e Trofime andar o Efes e Pavlesa ando gav thaj gndinas kaj o Pavle anda les andre ando Hramo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","O sasto gav vazda pe thaj o them prastaja katar sa e riga. Astardine e Pavle thaj crdine les avri andar o Hramo. A o vudar odma phandadilo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Dok von kamenas te mudaren e Pavle, aresli e poruka e šerutne zapovednikošće pe rimsko četa kaj o sasto Jerusalim si ande buna. ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","O zapovedniko odma lijas e vojnikonen thaj e kapetanen thaj prastaja dži lende. Kana e Židovurja dikhline e zapovedniko thaj e vojnikonen, či marenas majbut e Pavle. ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","O zapovedniko avilo ko Pavle, astarda les thaj zapovedisardas te phanden les ande duj lancurja. Askal phučla ko si vo thaj so ćerda. ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","A varesave manuša andar e gomila čhonas muj jek, a aver vareso dujto. Sar o zapovedniko našti khanči katar e bari buka te saznajil, naredisarda te inđaren e Pavle ande kasarna. ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Kana o Pavle areslo dži ke stepenice, o them sas gajda nasilno kaj e vojnikurja moraš te inđarenas e Pavle. ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","O silno them džalas pale lende thaj čholas muj: “Mudar les!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Kana trubuja te inđaren e Pavle ande kasarna, vo phučla e zapovedniko: “Tromav vareso te phenav tuće?” O zapovedniko phučla les: “Zar tu džanes grčki? ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Te naj san tu askal okova Egipćano savo majsigo varesavi vrjama vazda pobuna thaj inđarda pesa ande pustinja štar milje manušen save inđarenas čhurja?” ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","O Pavle phendas lešće. “Me sem Židovo andar o Tarso, građanino sem e pindžarde gavesko ande Kilikija. Moliv tut, muk man te phenav vareso e themešće.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Kana o zapovedniko mukla les te ćerel svato, o Pavle askal ačhilo pe stepenice, dijas znako e vastesa kaj kamel te ćerel svato thaj nastanisarda tišina. Vo askal lija te mothol lenđe pe židovsko čhib: ");
INSERT INTO rmyChergash_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Phralalen thaj dadalen, ašunen akana so si man te phenav tumenđe ande mungri odbrana.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Kana ašundine kaj ćerel lenđe svato pe židovsko čhib, sas još majbari tišina. Askal o Pavle phendas: ");
INSERT INTO rmyChergash_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Me sem Židovo. Bijando sem ando Tarso ande Kilikija, ali barjilem akate ande akava gav. Semas e Gamalilesko učeniko thaj vo tačno sikada man o zakon amare pradadengo. Saste ileja služisardem e Devlešće sago vi tumen ađes. ");
INSERT INTO rmyChergash_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Progonivas thaj mudaravas okolen save sledinas akava Drom, astaravas e manušen thaj e manušnjen thaj čhavas len ande tamnica. ");
INSERT INTO rmyChergash_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Pale godova šaj te posvedočin vi e šorvale rašaja thaj sa e starešine. Lendar dobisardem o lil pale phral ando Damask, thaj teljardem te okolen save sas okote anav phanglen ande lancurja ando Jerusalim te aven kaznime. ");
INSERT INTO rmyChergash_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Dok putuivas thaj semas već paše te dav ando Damask, varekaj katar o mismeri katar jekhvar obasjaisarda man o zuralo svetlost andar o nebo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Pelem pe phuv thaj ašundem o glaso savo phenelas manđe: ‘Savle, Savle, sostar progonis man?’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","A me phučlem: ‘Ko san tu Gospode?’, a o glaso phendas manđe: ‘Me sem o Isus andar o Nazaret saves tu progonis.’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","E manuša save sas manca dikhline o svetlo, ali či haćardine o glaso okolesko savo motholas. ");
INSERT INTO rmyChergash_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","A me phučlem: ‘So trubul te ćerav, Gospode?’ A o Gospod phendas manđe: ‘Ušti thaj teljar ando Damask. Okote phenela pe tuće so si tuće odredime te ćeres.’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Katar o baro svetlo korajlem thaj okola save sas manca inđarenas man palo vas, pa gajda dijam ando Damask. ");
INSERT INTO rmyChergash_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Okote sas varesavo pobožno manuš savo akhardolas Ananija. Vo verno inćarelas o Zakon thaj sas po lačho glaso maškar e Židovurja save trajinas okote. ");
INSERT INTO rmyChergash_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Vo avilo dži mande, ačhilo thaj phendas: ‘Phrala Savle, dik!’ A me isto časo dikhlem pe leste thaj šaj dikhlem les. ");
INSERT INTO rmyChergash_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","O Ananija phendas manđe: ‘O Del amare pradadengo majanglal losarda tut te pindžares lešći volja, te dićhes e Pravedniko thaj te ašunes o glaso andar lesko muj. ");
INSERT INTO rmyChergash_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Kaj, tu angle savorende svedočija pale leste thaj pale okova so dikhlan thaj ašundan. ");
INSERT INTO rmyChergash_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","A akana, so ažućares? Ušti thaj bol tut, thaj thov ćire bezeha gajda kaj akhareja lesko alav.’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Kana bolde man ando Jerusalim thaj molisajlem ando Hramo, sas man vizija. ");
INSERT INTO rmyChergash_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Dikhlem e Isuse sar phenel manđe: ‘Siđar, odma thaj džatar andar o Jerusalim, kaj o them akate či prihvatila okova so kames te phenes lenđe pale mande.’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","A me phendem: ‘Gospode, von džanen kaj čhudavas ande tamnica thaj kaj maravas pe sinagoge okolen save paćanas ande tute. ");
INSERT INTO rmyChergash_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","A kana čhordolas o rat ćire svedokosko e Stefanesko, vi me ačhavas okote, odobrisardem godova thaj lavas sama pe drze okolenđe save mudarenas les.’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","A vo phendas manđe: ‘Dža, kaj bičhalava tut dur maškar okola save naj Židovurja.’ ” ");
INSERT INTO rmyChergash_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","E Židovurja čhonas kan ko Pavle sa dži ke akala alava, a askal čhutine muj: “Istrebi kasaves katar e phuv! Godova či zaslužil te trajil!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Gajda dok čhonas muj, čhudenas pestar e ogrtača thaj čhudenas o praho ando vazduh. ");
INSERT INTO rmyChergash_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","A o zapovedniko naredisarda te e Pavle inđaren ande kasarna te bičuin les, sar saznaisardasas sostar e Židovurja gaći čhonas muj pe leste. ");
INSERT INTO rmyChergash_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","A kana pašljardine les thaj phangline les e haravljenca te bičuin les, o Pavle phučlas e kapetano savo sas okote: “Dali troman te bičuin okole savo si rimsko državljanin, a či ni sudisardine lešće?” ");
INSERT INTO rmyChergash_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Kana o kapetano godova ašundas, avilo dži ko zapovedniko thaj phendas lešće: “So ćeres godova? Pa akava manuš si rimsko državljanin!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","O zapovedniko nakhlo dži ko Pavle thaj phučla les: “Phen manđe, dali san tu čače rimsko državljanin?” A o Pavle phendas: “Sem.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Askal o zapovedniko phendas: “Me but love dijem te dobiv rimsko državljanstvo.” A o Pavle pe godova phendas: “A me lesa bijandilem.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","A e vojnikurja, save spremisajle te bičuin e Pavle odma crdine pe lestar. A o zapovedniko zato kaj phangla e Pavle zurale darajlo kana ašundas kaj si o Pavle rimsko državljanin. ");
INSERT INTO rmyChergash_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Thejara o đes o zapovedniko oslobodisarda e Pavle, a pošto kamlas pouzdano te ašunel sostar e Židovurja optužin e Pavle, naredisarda e šorvale rašajenđe thaj savorenđe andar o Baro veće te sastanin pe. Askal inkalda e Pavle angle lende. ");
INSERT INTO rmyChergash_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","O Pavle dikhla pe manuša andar o Baro veće thaj phendas: “Phralalen, me sa dži ađes trajivas anglo Del ande čisto savest.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Pe godova o Baro rašaj o Ananija naredisarda okolenđe save ačhenas paše leste te den les dab prekal o muj. ");
INSERT INTO rmyChergash_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","A o Pavle phendas lešće: “Tut o Del dela dab, kaj san dvolično, okrečime zidona! Tu bešes akate te sudis manđe po Zakono, a protivno e zakonešće des naredba te den man dab!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","A okola kaj sas prisutne okote phendine: “Sar tromas te kudis e Devlešće bare rašajes!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","A o Pavle phendas. “Či džanglem, phralalen, kaj si vo o baro rašaj. Kaj ando Sveto lil ačhel ramome: ‘Na motho bilačhipe palo poglavari ćire themesko.’” ");
INSERT INTO rmyChergash_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Sar o Pavle džanelas kaj si varesave manuša andar o Baro veće sadukeja, a aver fariseja, vo čhuta muj: “Phralalen! Me sem fariseji thaj potomko sem e farisejengo! Akate sudil pe manđe andar godova kaj si man nada ando uštipe andar e mule.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Thaj kana godova phendas, avilo dži ke čingara maškar e fariseja thaj maškar e sadukeja, gajda kaj o ćidino them podelisajlo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","E sadukeja inćaren kaj naj uštipe andar e mule, niti anđelurja niti duho, a e fariseja paćan ande sa godova. ");
INSERT INTO rmyChergash_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Gajda avilo dži ko baro rknjipe, a varesave učitelja e Mojsiješće zakonestar save sas andar e farisejenđi stranka uštile thaj zurale usprotivisajle gajda kaj, mothonas: “Či arakhas kaj akava manuš ćerda nisosko bilačhipe. Kaj so te motholas lešće o duho ili o anđelo?” ");
INSERT INTO rmyChergash_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","E čingar maškar lende sas gajda zurali kaj o zapovedniko daralas te na pharaven e Pavle pe kotora. Andar godova naredisarda e vojnikonenđe te pe sila len e Pavle katar o them thaj te inđaren les ande kasarna. ");
INSERT INTO rmyChergash_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Aver rjat o Gospod ačhilo anglo Pavle thaj phendas lešće: “Av zuralo. Kaj sar pale mande svedočisardan ando Jerusalim, gajda trubul te svedočis vi ando Rimo!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Kana đesajlo, e Židovurja ćerdine zavera thaj dine pe solah kaj či hana ni pijena dok či mudaren e Pavle. ");
INSERT INTO rmyChergash_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","A sas majbut katar štarvardeš džene okola save ćerdine e zavera. ");
INSERT INTO rmyChergash_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Von đele ke šorvale rašaja thaj ke starešine thaj phendine: “Zurale halam solah kaj khanči či čhasa ando muj dok či mudaras e Pavle. ");
INSERT INTO rmyChergash_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Zato tumen akana e manušenca andar o Baro veće, manđen katar o zapovedniko te palem anen e Pavle tumende. Phenen kaj kamen majlačhe te phučen les pale godova so ćerel. A amen mudarasa les po drom dži akaring.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ali e Pavlešće phejako čhavo ašundas pale akaja zavera thaj đelo ande kasarna te godova mothol e Pavlešće. ");
INSERT INTO rmyChergash_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","O Pavle akhardas jećhe kapetano thaj phendas lešće: “Inđar akale terne ko zapovedniko, kaj sile vareso te mothol lešće.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","O kapetano lija thaj inđarda les ko zapovedniko thaj phendas: “O Pavle kaj si phanglo akhardas man thaj phendas te akale terne manušes anav tute, kaj si les vareso te phenel tuće.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","O zapovedniko lija les palo vas, inđarda les pe rig thaj phučla les: “So si tut te mothos manđe?” ");
INSERT INTO rmyChergash_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Vo phendas: “E Židovurja dogovorisajle te zamolin tut pale thejara te palem anes e Pavle ando Baro veće, sago izgovor kaj kamen majlačhe te ašunen pale lesko slučaj. ");
INSERT INTO rmyChergash_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Na de te hohaven tut, kaj si majbut katar štarvardeš manuša save garade ažućaren les. Dine pes solah kaj či hana niti pijena dok či mudaren les. Već si spremne, samo ažućaren te tu pristanis.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","O zapovedniko askal mukla e terne te džaltar thaj zapovedisardas lešće: “Khonikašće na phen kaj akava phendan manđe.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Askal akhardas duj kapetanen thaj phendas: “Pripremin duj šela vojnikonen, thaj eftavardeš manušen pe grasta thaj duj šela manušen e kopljenca, te arjat ande inja saturja teljaren ande Kesarija. ");
INSERT INTO rmyChergash_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Palo Pavle pripremin e životinjen pe save jašila thaj inđaren les ko upravniko Feliks džude thaj saste.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Askal ramosarda lil palo upravniko ande savo ramolas: ");
INSERT INTO rmyChergash_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Katar o Klaudije Lisija, e poštuime upravnikošće e Feliksošće, pozdrav. ");
INSERT INTO rmyChergash_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Akale manušes astardine e Židovurja thaj kamline te mudaren les, ali kana ašundem kaj si vo rimsko državljano avilem mungre vojnikonenca thaj spasisardem les. ");
INSERT INTO rmyChergash_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Andem les askal anglo Baro veće te ašunav pale soste si došalo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Arakhlem kaj došaren les pale vareso so naj muklo ande lengo zakono thaj kaj naj došalo pale khanči andar soste trubujasas te avel mudardo ili čhutino ando phanglipe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","A kana ašundem kaj si protiv leste ćerdine zavera, odma bičhaldem les tute. A okolenđe kaj prnas les phendem te angle tute inkalen pale soste prn les.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Askal e vojnikurja ćerdine sago kaj sas lenđe zapovedime. Line e Pavle thaj raćava inđardine les ando gav Antipatrida. ");
INSERT INTO rmyChergash_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","A thejara đes mukline e manušen pe grasta te džan lesa majdur, a von boldine pe ande kasarna. ");
INSERT INTO rmyChergash_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Kana aresline ande Kesarija, dine e upravnikošće o lil thaj andine e Pavle angle leste. ");
INSERT INTO rmyChergash_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","O upravniko čitosarda o lil thaj phučlas e Pavle andar savi si pokrajina. Kana ašunda kaj si andar e Kilikija, ");
INSERT INTO rmyChergash_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","phendas: “Čhava kan tut thaj odlučiva kana aresena okola save prn tut.” Askal dija naredba te o Pavle avel tale straža ande Irodešći palata. ");
INSERT INTO rmyChergash_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Pandž đes pale godova, ande Kesarija areslo o šorvalo rašaj Ananija varesave starešinenca thaj e advokatosa savo akhardolas Tertul. Von inkaldine anglo upravniko pire optužbe protiv o Pavle. ");
INSERT INTO rmyChergash_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Kana akhardine e Pavle te del andre, o Tertul počnisarda te optužil les, e alavenca: “Poštuime Feliks, zahvalne sam tuće, kaj amen uživis ando miro, a ćiri briga palo them andas lačhipe e themešće. ");
INSERT INTO rmyChergash_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Amen godova, pe svako način thaj pe svako than priznaisaras ande bari zahvalnost. ");
INSERT INTO rmyChergash_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ali te či majbut dosadisarav tuće, moliv tut te ande ćiro lačhipe čhos cara kan amende. ");
INSERT INTO rmyChergash_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Utvrdisardam, kaj akava manuš ćerel amenđe bare nevolje. Vazdel e pobuna maškar e Židovurja ando sasto carstvo thaj vođa si ande nazaretsko sektako. ");
INSERT INTO rmyChergash_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Kamlas te oskrnavil čak vi amaro Hramo, ali astardam les. ");
INSERT INTO rmyChergash_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Ali avilo o zapovedniko Lisija e bare vojskasa thaj e silava otmisarda les amendar. ");
INSERT INTO rmyChergash_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ako phučes les, vi korkoro šaj saznais lestar sa pale soste amen optužisaras les.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","A vi e Židovurja složisajle lešće alavenca. Tvrdinas kaj si čače sa so phendas o Tertul. ");
INSERT INTO rmyChergash_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Kana o upravniko dija znako e Pavle te ćerel svato, o Pavle phendas: “Džanav kaj san već but brš sudco akale themesko, zato e mirno dušava inkalav mungri odbrana. ");
INSERT INTO rmyChergash_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Šaj proveris kaj naj majbut katar dešuduj đes sar areslem ando Jerusalim te pokloniman e Devlešće. ");
INSERT INTO rmyChergash_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Či arakhline man nikada kaj prepiriv man ando Hramo, niti kaj buniv e theme ande sinagoge ili ando gav. ");
INSERT INTO rmyChergash_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Akala manuša našti dokažin godova pale soste akana prn man. ");
INSERT INTO rmyChergash_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ali, akava priznajiv tuće: me služiv e Devlešće savešće služinas amare pradada thaj slediv o Drom, saves okola save prn man akharen sekta. Paćav ande sa so ramol ando Mojsijesko Zakon thaj ande proročke knjige. ");
INSERT INTO rmyChergash_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Vi man si nada ando Del, isto sago vi len – kaj avela uštipe andar e mule pale okola savi si pravedne thaj vi pale nepravedne. ");
INSERT INTO rmyChergash_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Zato uvek trudiv man te avel man čisto savest anglo Del thaj anglo them. ");
INSERT INTO rmyChergash_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Već bršenca naj semas ando Jerusalim, a akana avilem te mungre themešće anav pomoć pale čore thaj te prinesiv žrtve e Devlešće. ");
INSERT INTO rmyChergash_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Dok godova ćeravas arakhline man ando Hramo, thaj askal semas obredno čisto, ali okote nas ćidino o them niti sas buka. ");
INSERT INTO rmyChergash_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Godova sas varesave Židovurja andar e Cikni Azija, pa vi von trubujine te aven akate te svedočin angle tute thaj optužin man, ako si len vareso protiv mande. ");
INSERT INTO rmyChergash_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ili, neka akala akate korkoro phenen savi doš arakhline pe mande kana ačhavas anglo Baro veće, ");
INSERT INTO rmyChergash_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","osim ako godova naj zbog godova kaj čhutem muj dok ačhavas maškar lende: ‘Tumen ađes sudin manđe zato kaj paćav ando uštipe andar e mule!’ ” ");
INSERT INTO rmyChergash_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Pe godova o Feliks, savo sas lačhe obavestime palo Drom, odgodisarda o saslušanje thaj phendas lenđe: “Kana avela o zapovedniko Lisija, rešiva tumaro slučaj.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Askal naredisarda e kapetanošće te len sama po Pavle ando phanglipe, ali te den les varesavi sloboda thaj te či branin khonikašće katar lešće te vodin e briga pale leste. ");
INSERT INTO rmyChergash_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","A pale varesave đesa majposle avilo o Feliks pire romnjava e Drusilava, savi sas Židovka. Naredisarda e vojnikonenđe te anen lešće e Pavle thaj čhuta leste kan sar ćerelas svato palo paćipe ando Isus Hristo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","A askal o Pavle počnisarda te ćerel svato pale pravednost, uzdržljivost, thaj palo sudo savo avel. O Feliks darajlo thaj phendas: “Akana šaj džastar, a kana avela man majbut vrjama, bičhalava pale tute.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","A uz godova nadisajlo kaj o Pavle dela les love pa zato često akharelas les thaj ćerelas lesa svato. ");
INSERT INTO rmyChergash_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Nakhline duj brš, a e Felikse po than e upravnikosko nasledisardas o Porkije Fest. A pošto kamlas te ugodil e Židovenđe, o Feliks mukla e Pavle ando phanglipe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Trin đesa nakon so o Fest avilo ande pokrajina, đelotar andar e Kesarija ando Jerusalim. ");
INSERT INTO rmyChergash_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Okote e šorvale rašaja thaj e židovske starešine inkaldine lešće pire optužbe protiv o Pavle thaj zamolisardine les ");
INSERT INTO rmyChergash_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","te ćerel lenđe usluga thaj te e Pavle premestil ando Jerusalim – pošto ćerdine zaseda po drom te mudaren les. ");
INSERT INTO rmyChergash_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Ali o Fest phendas kaj e Pavle inćaren phandade ande Kesarija thaj kaj vi vo uskoro džala inća. ");
INSERT INTO rmyChergash_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Askal phendas: “Neka varesave katar tumare vođe teljaren manca thaj neka prn godole manušes te si pale varesoste došalo.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Nakon so o Fest ačhilo lende varekaj katar ohto ili deš đesa, đelo ande Kesarija. Već thejara đes bešlo pe sudačko stolica thaj zapovedisarda te anen e Pavle. ");
INSERT INTO rmyChergash_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Kana o Pavle dija andre, e židovske vođe andar o Jerusalim ačhile oko leste thaj inkalenas protiv leste but phare optužbe save našti dokažinas. ");
INSERT INTO rmyChergash_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","A o Pavle agajda branilas pe: “Či ćerdem khanči so si protiv o židovsko Zakono, niti protiv o Hramo, niti protiv o caro.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Pe godova o Fest, pošto kamlas te ugodil e Židovenđe, phučlas e Pavle: “Dali kames te džas ando Jerusalim, te okote sudil pe tuće angle mande?” ");
INSERT INTO rmyChergash_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","A o Pavle phendas: “Me ačhav anglo Cezaresko sudo thaj akate trubul te sudil pe manđe. E Židovenđe či ćerdem nisosko bilačhipe, sago kaj vi korkoro lačhe džanes. ");
INSERT INTO rmyChergash_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Te sem vareso došalo ili te ćerdem vareso so zaslužil te avav mudardo, či našav katar godova. Ali te akava so čhon pe mande naj čačipe, khonik našti del man lende po sudo. Mangav te sudil pe manđe anglo Cezar!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Pošto ćerda svato pire savetnikonenca, o Fest phendas lešće: “Manglan te sudil pe tuće anglo Cezar, ko Cezar vi džaja.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Varekazom đesa majkasnije avilo ande Kesarija o caro Agripa thaj e Vernika te posetin e Feste. ");
INSERT INTO rmyChergash_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Sar ačhile okote majbut đesa, o Fest phučla e caro te del les savet palo Pavle: “Akate si jek manuš saves o Feliks ačhada ando phanglipe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Kana semas ando Jerusalim, e šorvale rašaja thaj e židovske starešine čhutine optužbe protiv leste thaj manđenas te avel osudime. ");
INSERT INTO rmyChergash_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Me phendem lenđe kaj e Rimljanen naj običaj te izručin varekas majsigo nego so sudin lešće. O prme manuš majsigo trubul te suočil pe okolenca save prnas les thaj te dobil prilika te branil pe katar e optužbe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Zato či gndivas man kana avile akaringal manca, nego odma thejara đes bešlem pe sudačko stolica thaj naredisardem te anen godole manušes. ");
INSERT INTO rmyChergash_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Kana e manuša kaj prnas les uštile te ćeren svato, či prnas les pale nisosko bilačhipe, sago kaj me ažućaravas. ");
INSERT INTO rmyChergash_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Nego tradenas pe lesa pale lenđi vlastito religija thaj pale varesosko Isus savo mulo, ali pale savo o Pavle tvrdil kaj si džudo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Sar me semas hasardo ande kasavi rasprava, phučlem les, dali kamel te džal ando Jerusalim te okote sudil pe lešće pale godova. ");
INSERT INTO rmyChergash_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ali sar o Pavle kamla te ačhel ando phanglipe dok či odlučil amaro veličanstveno Cezar, naredisardem te inćaren les ando phanglipe dok či bičhalav les ko Cezar.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Askal o Agripa phendas e Festošće: “Kamlemas vi me te ašunav godole manušes.” A akava phendas: “Thejara ašuneja les.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Thejara đes o Agripa thaj e Vernika avile ando baro raskoš zajedno e zapovednikonenca thaj e gavešće ugledne manušenca, dine ande sala, a o Fest naredisarda te anen e Pavle. ");
INSERT INTO rmyChergash_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Askal o Fest phendas: “Caro Agripa, thaj savora tumen save sen akate, dićhen akale manušes! Zbog leste aviline mande sa e Židovurja ando Jerusalim thaj vi akatar thaj rknjimava mothonas kaj vo či trubul majbut te trajil. ");
INSERT INTO rmyChergash_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ali me či arakhlem kaj vo ćerda vareso so zaslužil smrto. Ali sar vo korkoro manglas te sudil pe lešće anglo Cezar, odlučisardem te bičhalav les ando Rimo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ali naj man khanči odredime te ramov pale leste e Cezarošće, zato andem les angle tumende, a posebno angle tute carona Agripa, te avel man posle akaja istraga so te ramov. ");
INSERT INTO rmyChergash_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Gndiv, kaj naj razumno te bičhalel pe o phanglo manuš ko Cezar, a te či ramol pe so si lešći doš.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Askal o Agripa phendas e Pavlešće: “Muklino si tuće te ćeres svato ande ćiri odbrana.” O Pavle vazda piro vas thaj phendas: ");
INSERT INTO rmyChergash_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Carona Agripa, inćarav man kaj sem bahtalo kaj ađes angle tute braniva man katar sa okova pale soste e Židovurja prn man, ");
INSERT INTO rmyChergash_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","a majbut pale godova kaj tu pindžares sa e židovske običaja thaj okova ande soste naj složne. Zato moliv tut te strpljivo čhos kan mande! ");
INSERT INTO rmyChergash_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Sa e Židovurja lačhe džanen mungro trajo, sar trajivas katar mungro majrano ternipe maškar mungro them thaj ando Jerusalim. ");
INSERT INTO rmyChergash_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Katar dumut pindžaren man thaj ako kamen, šaj te svedočin kaj sago farisejo trajivas pe majstrože pravilurja ande amaro paćipe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","A akana sudin manđe zato kaj nadiv man kaj o Del pherela piro obećanje savo dija amare pradadenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Amare dešuduj plemenurja, nadin pe kaj o Del pherela o obećanje thaj pale godova predano služin e Devlešće o đes thaj e rjat. Pale godoja isto nada, carona, e Židovurja prn man! ");
INSERT INTO rmyChergash_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Sostar smatrin nemoguće kaj o Del vazdel e manušen andar e mule? ");
INSERT INTO rmyChergash_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Vi me gndisardem kaj sa e silenca trubul te boriv man protiv okola save sledin e Isuse andar o Nazaret. ");
INSERT INTO rmyChergash_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ake so ćeravas ando Jerusalim kana dobisardem vlast katar e šorvale rašaja: but e Devlešće svete manušen čhudavas ande tamnica. A kana mudarenas len, me godova odobrivas. ");
INSERT INTO rmyChergash_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Thaj pe sa e sinagoge često mučivas len thaj gajda tradavas len te hulin po Isus. Gaći semas holjariko pe lende kaj progonivas len čak vi pe aver gava.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Gajda me kana dobisardem vlast thaj odobrenje katar e šorvale rašaja đelem ando Damask. ");
INSERT INTO rmyChergash_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Kana varekaj katar o mismeri, carona, dok putuivas, dikhlem svetlo andar o nebo, savo sas majzuralo katar o kham, pa obasjaisarda man thaj okolen save džanas manca. ");
INSERT INTO rmyChergash_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Savora pelam pe phuv, a me ašundem o glaso savo pe židovsko čhib phendas: ‘Savle, Savle, sostar progonis man? Samo korkoro tuće anes šteta dok boris tut protiv mande.’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Me phučlem: ‘Ko san tu, Gospode?’ A o Gospod phendas manđe: ‘Me sem o Isus saves tu progonis. ");
INSERT INTO rmyChergash_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Ali ušti, vazde tu pe pungre! Sikadilem tuće te aves mungro sluga thaj mungro svedoko. Ćereja svato pale okova so dikhlan thaj pale okova so sikavava tuće. ");
INSERT INTO rmyChergash_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Me izbaviva tut katar ćiro židovsko them thaj vi katar okola save naj Židovurja, savenđe bičhalav tut. ");
INSERT INTO rmyChergash_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Tu putreja lenđe jakha, thaj boldeja len katar e tama karingal o svetlo, katar e sotonsko vlast karingal o Del thaj po paćipe ande mande primin jartipe pale pire bezeha thaj o nasledstvo maškar e svete.’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Zato, carona Agripa, naj semas bi paćivalo okolešće so dikhlem andar o nebo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Nego prvo propovedivas okolenđe ando Damask, askal ando Jerusalim, thaj pe sasti Judeja, a vi okolenđe save naj Židovurja, kaj trubun te pokajin pe thaj te bolden pe ko o Del thaj te ćeren e dela save dokažina kaj pokajisajle. ");
INSERT INTO rmyChergash_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Zbog godova e Židovurja astardine man ando Hramo thaj line te mudaren man. ");
INSERT INTO rmyChergash_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ali o Del pomognisarda manđe thaj pomožil manđe sa dži ađes ađeste. Gajda ake akana, ačhav akate thaj svedočiv savorenđe pale okova so dikhlem. Či phenav khanči nevo, nego okova so e Prorokurja thaj o Mojsije phendine kaj avela: ");
INSERT INTO rmyChergash_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","kaj o Hristo patila thaj kaj avela prvo savo uštela andar e mule, thaj navestila o svetlo e Židovenđe thaj vi okolenđe save naj Židovurja.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Dok o Pavle gajda phenelas ande piri odbrana, o Fest čutas muj: “Pavle, tu san dilo! Dilajlan katar o baro džanglipe.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","O Pavle phendas: “Naj sem dilo, poštuime Feste, nego phenav okova so si čače thaj razumno. ");
INSERT INTO rmyChergash_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","O caro Agripa si lačhe uputime ande gadava thaj lešće šaj phenav slobodno. Či paćav kaj si lešće bilo so katar akava bi džanglo, kaj godova či dogodisajlo varekaj ande varesavo garado ćoško e phuvjako. ");
INSERT INTO rmyChergash_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Carona Agripa, dali paćas ande okova so phendine e prorokurja? Me džanav kaj paćas.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Askal o Agripa phendas e Pavlešće: “Još cara thaj ubedija man te avav hršćano!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","A o Pavle phendas lešće: “Još cara ili but, me molima e Devlešće te na samo tu nego vi savora akala save ađes ašunen man aven sago vi me, samo bi akala okurja!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Pe godova o caro uštilo, a lesa vi o upravniko, Vernika thaj okola save bešenas lesa. ");
INSERT INTO rmyChergash_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Dok inkljenas avri, počnisardine te phenen jek avrešće: “Akava manuš či ćerda khanči so zaslužil smrto ili phanglipe.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","A o Agripa phendas e Festešće: “Akava manuš već šaj avilosas oslobodime te či manglasas te sudil pe lešće anglo Cezar.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Kana sas odlučime te otplovisaras ande Italija, e Pavle thaj aver manušen andar o phanglipe predaisardine ko kapetano pe Cezarošći četa, savo akhardolas Julije. ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Dijam ande jek lađa andar o gav Adramiteja, savi džalas dži ke cikne azijske thana ando primorje thaj otplovisardam. Amenca sas vi o Aristarh, o Makedonco andar o Soluno. ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Thejara đes avilam ando Sidon, a o kapetano Julije, sago manuš postupilas e Pavlesa, mukla les te džal dži ke pire drugarja te pobrininpe pale okova so trubulas les. ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Kana đelam okotar, plovisardam severno uz o Kipar maškar o ostrvo thaj o kopno kaj phurdelas e protivno balval te avas zaštitime. ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Preplovisardam o more uz e obala Kilikija thaj Pamfilija thaj areslam ando gav Mira Likijsko. ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Okote o kapetano arakhlas jek lađa andar e Aleksandrija savi džalas ande Italija, gajda kaj dijam ande godoja lađa. ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","But đesa plovisardam zurale sporo thaj jedva areslam paše dži ko than Knid. Pošto e balval či delas amen te plovisaras majdur, zato plovisardam e južno Kritaće rigava te štitil men katar e balval dži ko than Salmona. ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Phares plovisardam uz e obala, areslam dži ke varesavo than savo akhardolas “Lačhe pristaništa”, paše ko than Laseja. ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","But vrjama sas hasardi, a e plovidba postanisardas opasno, a vi o židovsko posto sas već gata, pa o Pavle upozorisarda len: ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Manušalen, dikhav kaj e plovidba avela opasno thaj pe bari šteta – na samo palo tereto thaj pale lađa, nego vi pale amare trajurja.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ali o kapetano majbut paćalas e manušešće savo tradelas e lađa thaj kolešće kašći sas e lađa, nego e Pavlešće. ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Pošto e luka nas lačhi te ačhel pe okote prekal o ivend, majbut džene odlučisardine te otplovisaras okotar dži ko Feniks te avilo moguće thaj te okote ačhel pe prekal o ivend. O Feniks si luka pe Krita, savi dićhel karing o jugozapad thaj karing o severozapad. ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Kana phurdas e cikni južno balval, pelo lenđe pe gođi kaj avela lenđe gajda sago kaj kamenas, vazdine o sidro thaj plovinas uz e obala Krita. ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Ali či nakhlo but katar godova, kana ačhili te phurdel katar o ostrvo e olujno balval akhardi severoistočnjak. ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Astardas e lađa, savi našti oduprisajli gajda kaj muklam te inđarel men e balval. ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Dok plovisardam uz varesavo cikno ostrvo savo akhardolas Klauda te avas zaštitime katar e balval, e phare mukava astardam o čamco savo crdam pale amende. ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Kana vazdine o čamco, e šolenca učvrstisardine e lađa te na rspil pe. Daranas te na zaglavin pes ando plitko paj pe Sirta zato mukline o cikno sidro thaj e balval inđarelas len majdur. ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Sar astarda men e bari oluja, thejara đes ačhile te čhuden o tereto katar e lađa te avel e lađa majloći, ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","a o trito đes čhudine čak vi e oprema. ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Sar o kham thaj e čerenja či sikadonas but đesa, a e oluja marelas e lađa, hasardam svako nada kaj spasisarasa men. ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","A sar već dugo khonik khanči či hala, o Pavle ačhilo angle lende thaj phendas: “Manušalen, trubujine te čhon kan mande thaj te na isplovin katar e Krita. Askal či avilosas tumen akaja nevolja thaj šteta. ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ali vi akana phenav tumenđe te na daran, kaj khonik tumendar či hasarela pesko trajo, samo e lađa avela uništime. ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Araći pe rjat sikadilo manđe o anđelo e Devlesko kašće pripadiv thaj kašće služiv, ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","thaj phendas manđe: ‘Na dara, Pavle. Tu trubus te ačhes anglo Cezar. Thaj ake, o Del obećisarda tuće kaj zbog tute spasila savoren save plovin tusa.’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Andar godova, na te daran, manušalen, kaj paćav e Devlešće kaj avela sago kaj sas manđe mothodo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Samo trubul te zaglavi men ando plitko paj pe varesavo ostrvo.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Mukhla pes e dešu štarto rjat, a e balval inđarelas men još e Sredozemno moreja, a varekaj katar e opaš e rjat e mornarja gndinas kaj si o kopno paše. ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Izmerisardine kozom sas o paj handuk e šoleja pe savo sas phanglo o tego. Izmerisardine kaj sas o paj handuk trijanda thaj efta meterja. Cara majposle palem izmerisardine e handuk thaj o paj sas handuk biš thaj ohto meterja. ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Sar daranas te na pekas ande podvodne stene, čhudine štar sidrurja ando paj katar e paluni rig e lađaći thaj molisajlam te đesavol. ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","E mornarja kamenas te našen, gajda kaj mukline o čamco ando paj thaj ćerenas pešće muj kaj moraš te mućen e sidrurja vi katar e angluni rig e lađaći. ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Ali o Pavle phendas e kapetanošće thaj e vojnikonenđe: “Ako akala manuša či ačhen pe lađica, tumen či spasina tumen!” ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Pe godova e vojnikurja čhindine o šolo thaj mukline te o čamco perel ando paj. ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Kana počnisarda te đesavol, o Pavle motholas savorenđe te len te han vareso. Phenelas: “Ađes si dešuštarto đes sar ažućaren ande neizvesnost bi habesko, thaj khanči či čhutine ando muj. ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Akana moliv tumen te han vareso kaj si godova pale tumaro lačhipe. A nijećešće tumendar či perela ni bal katar o šoro.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Sar akava phendas, lijas o mangro thaj angle lende zahvalisarda e Devlešće, phagla thaj lijas te hal. ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Savora sas ohrabrime thaj line te han. ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","A pe lađa sas ukupno duj šela thaj eftavardeš thaj šov manuša. ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Kana čaljile ačhile te loćaren e lađa, gajda kaj čhudenas o điv ando more. ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Kana đesajlo, či pindžardine o kopno, ali dikhline varesavo zaliv e pristupačno obalava thaj kamenas te avilo moguće, okote te uplovin e lađava. ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Putardine e šole katar e sidrurja te peren ando more thaj ande isto vrjama mukline e kormilurja ando paj te šaj upravin e lađasa. Askal vazdine o angluno jedro karingal e balval thaj teljardine karingal e obala. ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ali e lađa dija dab ando pesko kaj sas o cikno paj thaj ačhili. O angluno deo e lađako zaglavisajlo thaj našti pomaknilaspe, dok o paluno deo e lađako phađolas e zurale talasendar. ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Askal e vojnikurja kamenas te mudaren e phangle manušen, te na varesavo lijasas te plivil thaj našel. ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Ali o kapetano kamlas te spasil e Pavle thaj či mukla te ćeren godova. Naredisarda te prvo okola manuša save džanenas te plivin huten ando paj thaj inkljen pe obala, ");
INSERT INTO rmyChergash_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","a aver manuša neka plutin pe phalja ili pe vareso aver so ačhilo katar e lađa. Gajda savora džude aresline pe phuv. ");
INSERT INTO rmyChergash_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Kana gajda spasisajlam, saznaisardam, kaj godova ostrvo akhardol Malta. ");
INSERT INTO rmyChergash_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","E manuša save trajinas okote sas neobično ljubazne prema amende. Astardine e jag thaj primisardine men oko late, kaj delas o bršnd thaj sas šil. ");
INSERT INTO rmyChergash_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","O Pavle ćida naramko šuće krandže thaj čhuta len pe jag, ali katar jekhvar zbog o tatipe andar e krandže inkljisto o sap thaj astarda pe pale lešće vas. ");
INSERT INTO rmyChergash_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Kana okola save trajinas okote dikhline sar o sap visil pe Pavlesko vas, phendine: “Akava manuš si sigurno ubica. Spasisajlo katar o more, ali e božica savi akhardolas Pravda či del les te trajil.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","A o Pavle ćhinosarda e sape katar piro vas ande jag, thaj nas lešće khanči. ");
INSERT INTO rmyChergash_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","A e manuša ažućarenas te šuljola ili te katar jekhar perel tele mulo. Kana pale lungo vrjama sar ažućarenas, dikhline kaj khanči neobično či dogodisajlo lešće, predomislisajle thaj počnisardine te phenen kaj si vo del. ");
INSERT INTO rmyChergash_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","A paše godova than sas o imanje savo sas katar o poglavari godole ostrvosko savo akhardolas Publije. Vo primisarda men ande piro ćher thaj trin đes ljubazno ugostisarda men. ");
INSERT INTO rmyChergash_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","A e Publijesko dad pašljolas, kaj mučilas les e groznica thaj e dizenterija. O Pavle dijas andre, čhuta pire vas pe leste thaj pomolisajlo, thaj o manuš sastilo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Pale godova avenas vi e aver nasvale manuša save trajinas pe godova ostrvo thaj sastonas. ");
INSERT INTO rmyChergash_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Zato sikadine amenđe bari čast, a kana teljardam te džastar, čhutine amenđe ande lađa sa so trubulamen palo drom. ");
INSERT INTO rmyChergash_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Kana nakhlo trin čhon, dijam ande varesavi aleksandrisko lađa savi sas sasto ivend po ostrvo, thaj pe savi sas zaštitno znako e blizancengo e Kastrosko thaj e Poluksosko. ");
INSERT INTO rmyChergash_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Areslam ando Sirakuza, okote ačhilam trin đes. ");
INSERT INTO rmyChergash_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Okotar otplovisardam thaj areslam ande Regijum. A thejara o đes počnisarda te phurdel e balval katar o jugo thaj pale duj đesa areslam ando Puteole. ");
INSERT INTO rmyChergash_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Okote arakhlam e phralen, save zamolisardine men te ačhas lende efta đes. Agajda areslam vi ando Rimo: ");
INSERT INTO rmyChergash_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Kana e phral ando Rimo ašundine kaj amen avas, aviline angle amende sa dži ke Apijevesko trgo thaj dži ke Trin birturja. Kana dikhla len o Pavle zahvalisarda e Devlešće thaj ohrabrisajlo. ");
INSERT INTO rmyChergash_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","A kana dijam ando Rimo, e Pavle dine te trajil posebno, zajedno e vojnikosa savo lelas les sama. ");
INSERT INTO rmyChergash_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Trin đes majposle, o Pavle akharda e židovske vođen, pa, kana savora ćidine pe phendas lenđe: “Phralalen, vi ako či ćerdem khanči protiv amaro them niti protiv e običaja amare pradadenđe, ipak phangline man ando Jerusalim thaj predaisardine man e Rimljanenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","E Rimljanurja ispituisardine man thaj kamline te oslobodin man kaj khančeja či zaslužisardem smrtno kazna. ");
INSERT INTO rmyChergash_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ali kana e Židovurja godolešće usprotivisajle, semas prisilime te mangav te sudil pe manđe anglo Cezar. Ali ni pale khančeste či optuživ mungre theme. ");
INSERT INTO rmyChergash_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Zato vi kamlem te dikhav tumen thaj te ćerav svato tumenca: ande akala lancurja sem upravo pale godova kaj paćav ande nada e Izraelošći.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","E židovske vođe phendine e Pavlešće: “Či primisardam andar e Judeja nisosko lil pale tute, thaj khonik katar e phral save aresline okotar či pale tute javisardine ili phendine vareso bilačhe. ");
INSERT INTO rmyChergash_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Ali, volisardamas te tutar ašunas so tu gndis, kaj džanas kaj protiv gadaja sekta svugde ćerel pe svato.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Gajda odredisardine jek đes, pa još majbut džene aviline ando ćher kaj sas o Pavle. A vo phenelas lenđe thaj svedočilas pale Devlesko carstvo thaj katar e detharin dži ke rjat andar knjige e Mojsiješće zakonestar thaj andar e Prorokurja uverilas len ande sa so značilas palo Isus. ");
INSERT INTO rmyChergash_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Varesave paćaine ande okova so phenelas, dok aver či kamline te paćan. ");
INSERT INTO rmyChergash_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Thaj sar našti složisajle maškar peste line te džantar, a o Pavle phendas lenđe još kava: “Lačhe phendas o Sveto Duho tumare pradadenđe prekal o proroko Isaija: ");
INSERT INTO rmyChergash_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Dža ke akava them thaj phen lenđe: Ašunena mungre alava, a či haćarena; pire jakhenca dićhena mungre dela, a našti dićhena len. ");
INSERT INTO rmyChergash_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Kaj barosajle e ile akale themešće, pire kanenca jedva ašunen, pire jakha phandadine; te e jakhenca či dićen, te e kanenca či ašunen, te e ileja či haćaren thaj obratin pe, te sastarav len.’ ");
INSERT INTO rmyChergash_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Zato, trubun te džanen: o Del bičhalel akava spasenje okolenđe save naj Židovurja. Von čhona kan leste.” ");
INSERT INTO rmyChergash_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","A kana akava phendas, e Židovurja đeletar gajda kaj tradenasa pe maškar pende. ");
INSERT INTO rmyChergash_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","O Pavle duj pherde brš ačhilo okote ande piro unajmime ćher. Okote primilas savoren save avenas leste. ");
INSERT INTO rmyChergash_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Propovedilas pale Devlesko carstvo thaj hrabro sikavelas palo Gospod Isus Hrist thaj khonik či sprečilas les.");
INSERT INTO rmyChergash_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Akava lil ramov tumenđe me, o Pavle, o sluga e Isuse Hristosko, savo sem odvoime te avav apostoli thaj savo sem bičhaldo te propovediv e Devlešći Bahtali nevimata, ");
INSERT INTO rmyChergash_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","savja o Del majanglal obećisarda prekal pire prorokurja ande Svete lila. ");
INSERT INTO rmyChergash_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Akaja Bahtali nevimata mothol pale lesko Čhavo, savo postanisardas manuš gajda kaj bijandilo sago potomko e carsko Davidesko, ");
INSERT INTO rmyChergash_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","a kroz o Duho savo posvetil thaj pire uštimava andar e mule, sikadilo kaj si Čhavo e Devlesko ande sila. Vo si o Isuso Hristo, amaro Gospod. ");
INSERT INTO rmyChergash_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Kroz leste dobisardam milost te avas apostolurja, te ande lesko alav anas e manušen andar svako them dži ke poslušnost thaj dži ko paćipe. ");
INSERT INTO rmyChergash_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Maškar akala sen vi tumen saven akhardas o Isuso Hristo. ");
INSERT INTO rmyChergash_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Ramov savorenđe ando Rimo save sen drage e Devlešće thaj save sen akharde te aven svete: Milost thaj miro tumenđe katar o Del, amaro Dad, thaj katar o Gospod Isus Hrist. ");
INSERT INTO rmyChergash_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Majsigo katar sa, dav najs mungre Devlešće kroz o Isuso Hristo pale savorende tumende, kaj palo tumaro paćipe ćerel pe svato po sasto them. ");
INSERT INTO rmyChergash_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","O Del, kašće mungre duhosa služiv gajda kaj propovediv e Bahtali nevimata lešće Čhavešći, svedoko si manđe kaj či ačhav te moliv man pale tumende. ");
INSERT INTO rmyChergash_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Uvek ande mungre molitve moliv man te avili gajda e Devlešći volja te napokon šaj avav tumende. ");
INSERT INTO rmyChergash_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Kaj čezniv te dikhav tumen thaj te dav tumen varesavo duhovno daro te zuravon, ");
INSERT INTO rmyChergash_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","godova si, te amare zajedničko paćimava ohrabrisaras jek avres kana sem tumenca. ");
INSERT INTO rmyChergash_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","A či kamlemas te na džanen, phralalen, kaj but data sas man gindo te avav tumende, te vi maškar tumende kušav varesosko duhovno plodo baš sago kaj ćerdem vi maškar aver manuša save naj Židovurja, ali semas sa dži akana sprečime. ");
INSERT INTO rmyChergash_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Udžile sem te propovediv okolenđe save si civilizovane thaj okolenđe save naj civilizovane, e mudre manušenđe thaj kolenđe save naj mudre. ");
INSERT INTO rmyChergash_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Gajda kaj but kamav te vi tumenđe ando Rimo propovediv e Bahtali nevimata. ");
INSERT INTO rmyChergash_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Me či ladžav katar e Bahtali nevimata, kaj voj si e sila e Devlešći palo spasenje savorenđe save paćan – majsigo e Židovešće, a askal vi okolešće savo naj Židovo. ");
INSERT INTO rmyChergash_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Kaj ande late sikadolpe e pravednost e Devlešći, savi primilpe e paćimava, thaj samo e paćimava, sago kaj si ramome ande Sveto lil: “O pravedniko trajila katar o paćipe.” ");
INSERT INTO rmyChergash_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Kaj, e Devlešći bari holji sikadolpe andar o nebo pe svako bezbožno trajo thaj pe svako nepravda e manušenđi, save pire nepravedne trajosa garaven o čačipe. ");
INSERT INTO rmyChergash_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Kaj okova so palo Del šaj džanel pe, pindžardo si lenđe, kaj o Del ćerda te avel godova lenđe očigledno. ");
INSERT INTO rmyChergash_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","A e Devlešće nevidljive osobine – lešći večno sila thaj lesko božanstvo, šaj jasno dićhel pe katar o postanko e themesko pe okova so stvorisarda. Zato khonikas naj izgovor pale piro bezah. ");
INSERT INTO rmyChergash_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Kaj, vi ako džanenas kaj o Del postoil, či sikavenas lešće sago e Devlešće čast thaj zahvalnost, nego dilajle ande pire gindurja thaj lengo nerazumno ilo kaljilo. ");
INSERT INTO rmyChergash_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Mothonas kaj si mudre, a postanisardine dile, ");
INSERT INTO rmyChergash_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","pa e slava e besmrtno Devlešći zamenisardine e slikava thaj e oblikosa katar o smrtno manuš thaj katar e čiriklja, katar e životinje pe štar pungre thaj katar e gmizavcurja. ");
INSERT INTO rmyChergash_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Zato o Del ande požude lenđe ilenđe predaisarda len e nemoralno melalipešće, te ćeren ladžavne buća jek avresa. ");
INSERT INTO rmyChergash_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Von e hohaimasa zamenisardine e Devlesko čačipe, pa slavinas thaj služinas okolešće so si stvorime, a na e Stvoritelješće savešće pripadil e slava pale uvek. Amin. ");
INSERT INTO rmyChergash_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Zbog godova o Del mukla len lenđe ladžavne požudenđe. Gajda lenđe romnja o prirodno polno odnos zamenisardine okoleja savo naj prirodno. ");
INSERT INTO rmyChergash_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Isto gajda vi e muškarcurja mukline o prirodno polno odnos e romnjenca thaj ande požuda phabonas jek pe avreste. E muškarcurja e muškarconenca ćerenas ladžavne buća thaj gajda primisardine pe peste e zasluženo kazna pale pire perverzne buća. ");
INSERT INTO rmyChergash_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Thaj zato kaj či inćarenas vredno te pindžaren e Devle, o Del predaisarda len lenđe bezvredne gođaće, te ćeren okova so si nedolično. ");
INSERT INTO rmyChergash_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Von si pherde svako vrsta nepravda, zloba, pohlepa, bilačhipe, zavist, mudaripe, čingara, lukavstvo thaj zlo namera. Von si okola kaj ćeren spletke, ");
INSERT INTO rmyChergash_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","klevetin avren, mrzan e Devle, bezobrazne si, ohole, barikane, izmislin sar te ćeren bilačhipe, nepokorne pire dadešće thaj pire dejaće, ");
INSERT INTO rmyChergash_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","nerazumne, nepouzdane, bezosećajne, nemilosrdne. ");
INSERT INTO rmyChergash_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Vi ako džanen pale Devlesko upozorenje kaj smrto zaslužin okola save gajda ćeren, von na samo kaj godova ćeren nego ohrabrin vi avren gajda te ćeren. ");
INSERT INTO rmyChergash_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Zato naj tut izgovor, manušeja savo sudis, ma ko god te san. Kaj, korkoro godoleja kaj sudis varekašće avrešće, korkoro tut osudis, kaj vi tu savo sudis ćeres godova isto. ");
INSERT INTO rmyChergash_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","A amen džanas kaj si e Devlesko sudo pravedno prema okola save ćeren gajda. ");
INSERT INTO rmyChergash_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Dali gndis, manušeja savo sudis okolenđe save ćeren godova, a vi tu ćeres godova isto, kaj našeja katar e Devlesko sudo? ");
INSERT INTO rmyChergash_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Ili či maris palo barvalipe lešće lačhimasko, trpljivost thaj strpljenje? Či haćares kaj lesko lačhipe kamel te vodil tut dži ko pokajanje? ");
INSERT INTO rmyChergash_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Ali, zbog ćiri tvrdoglavost thaj kaj ćiro ilo naj promenime sa majbut crdes pe tute e Devlešći holji, po Đes kana o Del objavila piri pravedno presuda, ");
INSERT INTO rmyChergash_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","pa svakonešće boldela prema lenđe dela. ");
INSERT INTO rmyChergash_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Dela večno trajo okolenđe save roden e slava, čast thaj trajo bi smrtosko, thaj trudin pe uvek te ćeren lačhipe, ");
INSERT INTO rmyChergash_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","a e bare holjasa kaznila okolen save si handžvale thaj či pokorin pe e čačipešće, a pokorin pe e nepravdaće. ");
INSERT INTO rmyChergash_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","E nevolja thaj e muka aresela svakone ko ćerel bilačhipe, majsigo e Židove, a askal vi okole savo naj Židovo. ");
INSERT INTO rmyChergash_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","A e slava, čast thaj miro avela svakone ko ćerel lačhipe, majsigo e Židovenđe, a askal okolenđe save naj Židovurja, ");
INSERT INTO rmyChergash_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","kaj o Del či dićhel ko si ko. ");
INSERT INTO rmyChergash_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Okola saven si e Mojsijesko Zakon, ćeren bezah isto sago vi okola save nikada či ašundine palo Zakon. Ako okola saven naj Zakon ćeren bezah, isto gajda vi bi e Zakonesko avena hasarde. A ako okola save silen o Zakon ćeren bezah, lenđe avela sudime po Zakon. ");
INSERT INTO rmyChergash_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Kaj anglo Del naj pravedne okola save ašunen o Zakon, nego avena opravdime okola save izvršin o Zakon. ");
INSERT INTO rmyChergash_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Kaj varesave, save naj Židovurja thaj či pindžaren e Mojsijesko Zakon prirodno ćeren okova so mothol o Zakon. Zato, vi ako najlen Zakon, ande lenđe ile silen o Zakon. ");
INSERT INTO rmyChergash_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Von sikaven kaj si lenđe ande ile ramome okova so o Zakon rodel lendar, a pale godova svedočil lenđi savest thaj lenđi gođi savi jekhar prl len a jekhvar čak vi branil len. ");
INSERT INTO rmyChergash_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Sa godova avela okova Đes kana o Del prekal o Hristo Isus sudila e manušenđe tajne, prema e Bahtali nevimata savi me objaviv. ");
INSERT INTO rmyChergash_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","A tu, savo phenes pale tute kaj san Židovo oslonistu po Zakon thaj hvalis tut e Devlesa. ");
INSERT INTO rmyChergash_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Džanes e Devlešći volja thaj prosudis so si majlačhe, kaj godova sikavel tut o Zakono. ");
INSERT INTO rmyChergash_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Uverime san kaj san vođa e korenđe, svetlo okolenđe save si ando tunjariko, ");
INSERT INTO rmyChergash_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","kaj sikaves okolen save či džanen, thaj te aves učitelj e čhavrenđe, kaj si tut o Zakon, saves si potpuno džanglipe thaj čačipe. ");
INSERT INTO rmyChergash_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Sostar, askal tu savo sikaves averen, korkoro tut či sikaves? Tu savo propovedis kaj či trubul te čorel pe, korkoro čores. ");
INSERT INTO rmyChergash_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Tu savo phenes te či ćerel pe preljub, korkoro ćeres preljub. Tu savešće si odvratne e idolurja, koristis e čordane predmeturja andar lenđe hramurja. ");
INSERT INTO rmyChergash_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Tu savo hvalis tut kaj pindžares e Devlesko Zakon, sostar vređos e Devle gajda kaj phađes o Zakon? ");
INSERT INTO rmyChergash_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Sago kaj ramol ando Sveto lil: “Zbog tumende maškar okola save naj Židovurja vređol pe e Devlesko alav.” ");
INSERT INTO rmyChergash_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","O obrezanje koristil tuće samo ako poštuis o Zakon, ali ako phađes o Zakon askal sago kaj ni naj san obrezime: kaj o Zakon či ćerel tut te aves khanči majlačho katar okola save naj obrezime. ");
INSERT INTO rmyChergash_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Ali ako o manuš savo naj obrezime inćarel okova so phenel o Zakon, godova đinavelpe lešće sago kaj si obrezime. ");
INSERT INTO rmyChergash_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Zato tuće, savo pindžares okova so ramol ando Zakon thaj san obrezime, a phađes o Zakon, sudila o manuš savo naj obrezime telesno, a inćarel e zapovedi e Zakonešće. ");
INSERT INTO rmyChergash_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Kaj naj Židovo okova savo si godova samo avrjal, niti si pravo obrezanje avrjal po telo. ");
INSERT INTO rmyChergash_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Nego, Židovo si okova savo si godova andral, a pravo obrezanje si o obrezanje e ilesko, a godova ćerel o Duho, a na o slovo e Zakonesko. Kasave manuše či hvalin e manuša, nego o Del. ");
INSERT INTO rmyChergash_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Savi, askal, prednost si e Židoven? Ili savi korist si katar o obrezanje? ");
INSERT INTO rmyChergash_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Bari ande svako pogled. Majsigo, e Židovenđe si poverime e Devlešće alava. ");
INSERT INTO rmyChergash_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","A so ako varesave lendar či paćanas? Zar lengo bipaćipe ačhavela e Devlešći vernost? ");
INSERT INTO rmyChergash_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Nisar! Nego o Del ačhela verno, vi ako si sa e manuša hohamne, sago kaj ando Sveto lil ramol: “Te aves ando pravo kana ćeres svato thaj te pobedis kana došaren tut.” ");
INSERT INTO rmyChergash_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","A ako amari nepravda sikavel e Devlešći pravednost, so te phenas pe godova? Kaj o Del si nepravedno – kana sikavel piri bari holji? Mothav gajda sago kaj e manuša gndin. ");
INSERT INTO rmyChergash_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Nisar! Sar askal o Del šaj pravedno sudil e themešće? ");
INSERT INTO rmyChergash_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Ali, ako si e Devlesko čačipe zbog mungro hohaipe još majočigledno pe lešći slava, sostar vi majdur sudilpe manđe sago e bezehalešće? ");
INSERT INTO rmyChergash_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Thaj sostar te na “ćeras bilačhipe te avel lačhipe”, sago kaj varesave hohaven pe amende thaj tvrdin kaj amen gajda phenas. Lenđi osuda avela pravedno! ");
INSERT INTO rmyChergash_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","So askal? Dali sam amen Židovurja majlačhe avrendar? Nisar! Kaj, već optužisardam vi e Židoven thaj vi okolen save naj Židovurja kaj si o talo bezeh. ");
INSERT INTO rmyChergash_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Sago kaj si ramome ando Sveto lil: “Naj pravedno – nijek; ");
INSERT INTO rmyChergash_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","naj khonik ko haćarel, naj khonik ko e Devle rodel. ");
INSERT INTO rmyChergash_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Savora banđardine e Devlešće dromestar, sa zajedno postanisardine beskorisne. Naj khonik ko ćerel lačhipe, naj ni jek.” ");
INSERT INTO rmyChergash_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","“O muj lengo putardo limori si, e čhibja lenđi hohaipe mothol.” “E sapengo otrovo si pe lenđe vuš.” ");
INSERT INTO rmyChergash_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","“O muj lengo pherdo si romaja thaj gorčina.” ");
INSERT INTO rmyChergash_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","“E pungre lenđe siđaren te čhoren o rat, ");
INSERT INTO rmyChergash_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","kaj god džan, inđaren propast thaj e beda, ");
INSERT INTO rmyChergash_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","a o drom e mirosko von či pindžaren.” ");
INSERT INTO rmyChergash_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","“Dar e Devlestar naj angle lenđe jakha.” ");
INSERT INTO rmyChergash_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Ali džanas sa so o Zakon phenel, phenel okolenđe save si talo Zakono, te svako muj phandadol thaj te o sasto them avel angle Devlesko sudo. ");
INSERT INTO rmyChergash_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Kaj khonik anglo Del našti opravdila pe gajda kaj inćarel e Mojsijesko Zakon, kaj o Zakon anel e manuše dži ko džanglipe kaj si bezehalo. ");
INSERT INTO rmyChergash_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","A akana, odvojime katar o Zakon, sikadili e Devlešći pravednost – pale savi svedočin o Zakon thaj ande knjige e Prorokonenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Anglo Del sam opravdime kroz o paćipe ando Isuso Hristo. Godova odnosil pes pe sa save paćan kaj naj razlika maškar e manuša: ");
INSERT INTO rmyChergash_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","savora sagrešisardine thaj hasardine e slava e Devlešći, ");
INSERT INTO rmyChergash_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","ali ivja si opravdime, lešće milava, kroz o Hristo Isus, savo otkupisarda men gajda kaj lijas pe peste amare bezeha. ");
INSERT INTO rmyChergash_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Les o Del čhuta te pire ratesa avel žrtva pomirno savi prihvatilpe e paćimava. Gajda o Del kamlas te sikavel piri pravednost. Kaj, vo ande piri strpljivost či kaznilas e majsigo ćerde bezeha, ");
INSERT INTO rmyChergash_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","a ande akaja vrjama sikavel piri pravednost te korkoro avel pravedno thaj te opravdil okoles savo paćal ando Isus. ");
INSERT INTO rmyChergash_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Prema godova, si li varekas razlog te hvalil pe korkoro pesa? Godova si isključime. Sošće zakoneja? E zakoneja savo rodel e dela? Na, nego e zakoneja savo rodel o paćipe. ");
INSERT INTO rmyChergash_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Amen, dakle, inćaras kaj o manuš opravdil pe zato kaj paćal, a na zato kaj vršil e dela e Zakonešće. ");
INSERT INTO rmyChergash_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Ili si o Del samo o Del e Židovengo? Naj li vi okolengo save naj Židovurja? Ej, vi okolengo save naj Židovurja. ");
INSERT INTO rmyChergash_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Kaj, samo jek Del si thaj opravdila e paćimava okolen save si obrezime, a okolen save naj obrezime kroz o paćipe. ");
INSERT INTO rmyChergash_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Da li amen e paćimava čhinas o Zakono? Nisar! Nego, e paćimava inćares e rig e Zakonešći. ");
INSERT INTO rmyChergash_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","So šaj phenas kaj arakhlas o Avraam, amaro pradad ando telo? ");
INSERT INTO rmyChergash_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Kaj, ako si o Avraam opravdime prekal pire dela, si les sova te hvalil pe, ali na anglo Del. ");
INSERT INTO rmyChergash_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Kaj ramol ando Sveto lil: “O Avraam paćaja e Devlešće thaj godova đinada pe lešće ande pravednost.” ");
INSERT INTO rmyChergash_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Okolešće savo ćerel bući, e poćin či đinavelpe sago daro, nego sago okova so si lešće udžile. ");
INSERT INTO rmyChergash_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","A okolešće savo či ćerel bući, a paćal ando Del savo opravdil e bezehales, o paćipe đinavelpe sago pravednost. ");
INSERT INTO rmyChergash_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Gajda vi o David phenel kaj si bahtalo o manuš savešće o Del đinavel e pravednost bi lešće pravedne dela: ");
INSERT INTO rmyChergash_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Blago okolenđe savenđe si bilačhe dela jartome thaj e bezeha učharde. ");
INSERT INTO rmyChergash_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Blago e manušešće savešće o Gospod či đinavel o bezah.” ");
INSERT INTO rmyChergash_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Dali si akaja bah samo pale okola save si obrezime ili vi pale okola save naj obrezime? Phendam kaj o paćipe e Avraamešće đinada pe sago pravednost. ");
INSERT INTO rmyChergash_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","A kana godova đinada pe lešće? Dok sas obrezime ili dok još nas obrezime? Na dok sas obrezime, nego dok nas obrezime! ");
INSERT INTO rmyChergash_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","A o obrezanje primisarda sago znako, thaj pečato pale pravednost savi steknisarda e paćimava dok još nas obrezime. Zbog godova si vo duhovno dad savorenđe save paćan, a naj obrezime, te vi von aven đinade ande pravednost. ");
INSERT INTO rmyChergash_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","A o Avraam si dad vi okolenđe save naj samo obrezime nego save sledin lesko paćipe savo sikada dok još nas obrezime. ");
INSERT INTO rmyChergash_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Kaj, o obećanje savo si dino e Avraamešće ili lešće potomkošće kaj nasledila o them či avilo po Zakon, nego pe pravednost savi si rezultato e paćipasko. ");
INSERT INTO rmyChergash_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Ako si e naslednikurja okola save trajin po Zakon, askal o paćipe naj vredno, a o obećanje či mol khanči. ");
INSERT INTO rmyChergash_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Kaj, o Zakon anel e Devlešći holji, a kaj naj o Zakon, či ni phađelpe o Zakon. ");
INSERT INTO rmyChergash_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Gajda vi e Devlesko obećanje temeljil pe po paćipe sar avilosas pe Devlešći milost thaj te vredil pale sa e Avraamešće potomkurja, na samo pale okola save inćaren o Zakono, nego vi pale okola saven si paćipe sago e Avraame. Vo si dad savorenđe amenđe, ");
INSERT INTO rmyChergash_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","sago kaj ramol ando Sveto lil: “Ćerdem tut te aves dad e bute themengo” – anglo Del, ande savo paćajas, savo džudarel e mulen thaj pire alavenca ćerel te postanil okova so či postojil. ");
INSERT INTO rmyChergash_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Kana e Avraame nas nada kaj avela les čhavra, o Avraam ande nada paćaja. Thaj postanisarda dad e bute themengo prema okova so si phendo: “Gaći baro avela ćiro potomstvo.” ");
INSERT INTO rmyChergash_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","O Avraam lačhe džanelas kaj nakhli e vrjama kaj šaj avel les čhavra, kaj sas les skoro šel brš, isto gajda džanelas kaj e Sara našti bijanel, ali lesko paćipe či oslabisardas. ");
INSERT INTO rmyChergash_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Ažućarelas te o Del pherel piro obećanje thaj či sumnjilas, nego zuravolas ando paćipe thaj hvalilas e Devle. ");
INSERT INTO rmyChergash_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Potpuno sas uverime kaj o Del šaj ćerel so obećisarda. ");
INSERT INTO rmyChergash_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Zato vi “đinada pe lešće ande pravednost.” ");
INSERT INTO rmyChergash_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","A e alava: “si lešće uračunime”, naj ramome samo pale leste, ");
INSERT INTO rmyChergash_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","nego vi pale amende. Amaro paćipe avela prihvatime te opravdil men anglo Del. Godova avela vi amenđe save paćas ando Del savo vazdas andar e mule amare Gospode e Isus ");
INSERT INTO rmyChergash_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","savo si dino te avel mudardo pale amare bezeha thaj vazdino andar e mule te avas opravdime. ");
INSERT INTO rmyChergash_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Pošto sam, dakle, akana opravdime e paćimava, si amen miro e Devlesa kroz amaro Gospod Isus Hrist. ");
INSERT INTO rmyChergash_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Kroz leste, e paćimava, si amen pristup ke akaja milost ande savi ačhas thaj raduji men, kaj si amen nada ande Devlešći slava. ");
INSERT INTO rmyChergash_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Thaj na samo godova, nego raduji men vi ande nevolja, kaj džanas kaj e nevolja anel strpljenje. ");
INSERT INTO rmyChergash_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","O strpljenje zuravel amaro karakter, a o zuralo karakter anel nada. ");
INSERT INTO rmyChergash_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","A e nada či ladžarela men kaj e ljubav e Devlešći čhordili ande amare ile e Sveto Duhosa savo si dino amenđe. ");
INSERT INTO rmyChergash_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Kaj, ande pravo vrjama, dok samas još bespomoćne, o Hristo mulo pale amende save samas bidevlešće manuša. ");
INSERT INTO rmyChergash_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Phare kaj vareko kamlasas te merel palo pravedno manuš, vi ako pale zurale lačho manuš šaj te vareko vi kamlasas te merel. ");
INSERT INTO rmyChergash_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Ali o Del sikada piri ljubav prema amende gajda kaj o Hristo mulo pale amende dok samas još bezehale manuša. ");
INSERT INTO rmyChergash_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Kozom majbut akana, kana sam opravdime lešće ratesa, avasa spasime katar e Devlešći bari holji? ");
INSERT INTO rmyChergash_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Pa, kana izmirisajlam e Devlesa kroz o smrto lešće Čhavesko dok samas još e Devlešće dušmaja, kozom majbut avasa spasime lešće trajosa akana kana sam izmirime lesa. ");
INSERT INTO rmyChergash_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Thaj na samo godova, nego vi raduji men ando Del kroz amaro Gospod Isus Hrist, kroz savo akana primisardam pomirenje. ");
INSERT INTO rmyChergash_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Prema godova, sago kaj o bezeh dija ando them kroz o jek manuš, a kroz o bezeh o smrto, gajda vi o smrto avilo pe sa e manuša, kaj savora ćerdine bezeh. ");
INSERT INTO rmyChergash_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","O bezeh sas ando them majsigo katar o Zakono, ali o bezeh khonikašće či đinavelpe kana naj zakon. ");
INSERT INTO rmyChergash_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Ipak, katar o Adam dži ko Mojsije, o smrto vladilas vi pe okola save či prekršisardine e jasno Devlešći zapoved sago o Adam, savo si slika Okolešći savo avela. ");
INSERT INTO rmyChergash_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Ali o milosno daro naj sago o prestup e Adamesko. Kaj ako but muline zbog o prestup jećhe manušesko, kozom majbut izlisajli e Devlešći milost thaj o daro savo avilo kroz e milost jećhe manušešći, e Isuse Hristošći pe butende. ");
INSERT INTO rmyChergash_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Thaj godova daro naj 