﻿USE sofia;
DROP TABLE IF EXISTS sofia.rmna_vpl;
CREATE TABLE rmna_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES rmna_vpl WRITE;
INSERT INTO rmna_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Akavai o spisko oto preci e Isuse Hristesere kovai potomko e Davidesoro hem potomko e Avraamesoro. ");
INSERT INTO rmna_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","E Avraamese bijandilo o Isaak. E Isaakese bijandilo o Jakov. E Jakovese bijandilo o Juda hem lesere phralja. ");
INSERT INTO rmna_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","E Judase i Tamara bijanđa e Farese hem e Zare. E Faresese bijandilo o Esrom. E Esromese bijandilo o Aram. ");
INSERT INTO rmna_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","E Aramese bijandilo o Aminadav. E Aminadavese bijandilo o Naason. E Naasonese bijandilo o Salmon. ");
INSERT INTO rmna_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","E Salmonese i Rahava bijanđa e Vooze. E Voozese i Ruta bijanđa e Jovide. E Jovidese bijandilo o Jesej. ");
INSERT INTO rmna_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","E Jesejese bijandilo o caro o David. E Davidese e Urijasiri bivšo romni bijanđa e Solomone. ");
INSERT INTO rmna_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","E Solomonese bijandilo o Rovoam. E Rovoamese bijandilo o Avija. E Avijase bijandilo o Asaf. ");
INSERT INTO rmna_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","E Asafese bijandilo o Josafat. E Josafatese bijandilo o Joram. E Joramese bijandilo o Ozija. ");
INSERT INTO rmna_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","E Ozijase bijandilo o Joatam. E Joatamese bijandilo o Ahaz. E Ahazese bijandilo o Ezekija. ");
INSERT INTO rmna_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","E Ezekijase bijandilo o Manasija. E Manasijase bijandilo o Amos. E Amosese bijandilo o Josija. ");
INSERT INTO rmna_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","E Josijase bijandilo o Jehonija hem lesere phralja kad o Vavilonci osvojinde i Judeja hem ćerde o Izraelci te džan ano Vavilon. ");
INSERT INTO rmna_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Palo progonstvo ano Vavilon, e Jehonijase bijandilo o Salatiil. E Salatiilese bijandilo o Zorovavel. ");
INSERT INTO rmna_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","E Zorovavelese bijandilo o Avijud. E Avijudese bijandilo o Elijakim. E Elijakimese bijandilo o Azor. ");
INSERT INTO rmna_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","E Azorese bijandilo o Sadok. E Sadokese bijandilo o Ahim. E Ahimese bijandilo o Elijud. ");
INSERT INTO rmna_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","E Elijudese bijandilo o Eleazar. E Eleazarese bijandilo o Matan. E Matanese bijandilo o Jakov. ");
INSERT INTO rmna_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","E Jakovese bijandilo o Josif, o rom e Marijakoro koja bijanđa e Isuse vičime Hrist. ");
INSERT INTO rmna_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Adava značini dai ukupno dešu štar generacije taro Avraam đi o caro o David, dešu štar generacije taro David đi o progonstvo ano Vavilon hem dešu štar generacije taro progonstvo ano Vavilon đi o Hrist. ");
INSERT INTO rmna_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ače sar inele kad bijandilo o Isus o Hrist: Lesiri daj i Marija inele mangli e Josifese. Ali angleder so te len pe, dodžanđa da ačhili khamni oto Sveto Duho. ");
INSERT INTO rmna_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Lakoro rom o Josif inele pravedno manuš, i adalese so na manglja te lađari la anglo manuša, tajno manglja te ačhaj la. ");
INSERT INTO rmna_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","I sar razmislini ine adalestar, zasuća. Ano suno alo lese o anđeo e Gospodesoro hem phenđa lese: “Josife, čhaveja e Davidesereja, ma dara te le e Marija romnjaće! Adalese so o Sveto Duho ćerđa la te akhari adale čhavore ano vođi. ");
INSERT INTO rmna_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Oj ka bijani čhave hem tu ka de le anav Isus adalese so ka spasini ple narodo lengere grehendar.” ");
INSERT INTO rmna_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Sa adava ulo sar te pherđol okova so o Gospod vaćerđa palo proroko: ");
INSERT INTO rmna_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Šunen! I čhaj ka ačhol khamni! Ka bijani murše hem ka vičinen le Emanuel” (so značini: “O Devel amencar”). ");
INSERT INTO rmna_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Kad o Josif uštino oto sojba, ćerđa sar so phenđa lese o anđeo e Gospodesoro – lelja e Marija romnjaće. ");
INSERT INTO rmna_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Na suća olaja sar romnjaja đikote na bijanđa e čhave. A tegani ov dinđa le anav Isus. ");
INSERT INTO rmna_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","O Isus bijandilo ano gav Vitlejem ani regija Judeja zako e carosoro e Irodesoro vreme. Ko adava vreme, nesave mudraci taro Istok resle ano Jerusalim ");
INSERT INTO rmna_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","hem lelje te raspučen pe: “Kaj o nevo bijando caro e Jevrejengoro? Dikhljam sar lesiri čereni ikljola ko istok i aljam te pera ko kočija anglo leste.” ");
INSERT INTO rmna_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kad šunđa adava o caro o Irod, but uznemirinđa pe, a oleja hem sa o manuša ano Jerusalim. ");
INSERT INTO rmna_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Vičinđa kora peste sa e jevrejengere šerutne sveštenikonen hem e učiteljen e Zakonestar hem pučlja len kaj o Hrist valjani te bijanđol. ");
INSERT INTO rmna_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","A on phende lese: “Ano Vitlejem ani Judeja, adalese so ađahar o proroko pisinđa: ");
INSERT INTO rmna_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Tu, Vitlejeme, ki phuv e Judejakiri, na injan najtikoro maškaro legarutne dizja e Judejakere, adalese so ka ikljol tutar vladari kova sar pastiri ka legari mle narodo, e Izraelconen.’” ");
INSERT INTO rmna_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tegani o Irod tajno vičinđa kora peste e mudrakonen hem pučlja len kad tačno mothovđa pe i čereni. ");
INSERT INTO rmna_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","I bičhalđa len ko Vitlejem vaćerindoj: “Džan hem šukar raspučen tumen e čhavorestar. Kad ka arakhen le, aven te javinen maje te šaj hem me te avav te perav ko kočija anglo leste.” ");
INSERT INTO rmna_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","O mudraci šunde e caro hem džele. I otojekhvar, i čereni, sava dikhle sar ikljola ko istok, džala ine anglo lende sa đikote na terdini upreder o than kote inele o čhavoro. ");
INSERT INTO rmna_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Kad dikhle i čereni, zorale radujinde pe. ");
INSERT INTO rmna_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Đerdinde ko čher hem dikhle e čhavore lesere dajaja e Marijaja i pele ko kočija anglo leste. Tegani ikalde pumare darija hem dinde le zlato, tamjan hem smirna. ");
INSERT INTO rmna_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Palo adava, ko suno o Devel upozorinđa len te na irinen pe palal koro Irod, i adalese avere dromeja irinde pe ki pumari phuv. ");
INSERT INTO rmna_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kad o mudraci džele, o anđeo e Gospodesoro alo ko suno e Josifese hem phenđa lese: “Ušti, le e čhavore hem lesere daja hem našen ano Egipat. Ačhoven adari đikote na phenava tumenđe, adalese so o Irod ka rodel e čhavore te mudari le.” ");
INSERT INTO rmna_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","O Josif uštino hem adaja rat dželo ko Egipat e čhavoreja hem lesere dajaja. ");
INSERT INTO rmna_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","I ačhile adari sa đi e Irodesoro meriba. Adaleja pherdilo okova so o Gospod phenđa prekalo proroko: “Taro Egipat vičinđum mle čhave.” ");
INSERT INTO rmna_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Kad o Irod dikhlja so o mudraci hovavde le, but holjanđa hem bičhalđa e vojnikonen ano Vitlejem hem ano sa o pašutne thana te mudaren sa e murše čhavoren đi o duj berš. Sa adava ćerđa premalo vreme zako savo šunđa e mudrakonendar. ");
INSERT INTO rmna_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Tegani pherdilo okova so phenđa o proroko o Jeremija: ");
INSERT INTO rmna_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ani diz Rama o glaso šundilo, o kukiba hem o rojba baro; Adava i Rahilja rovela ple čhaven hem na mangela te utešini pe, adalese so lakere čhave nane više dživde.” ");
INSERT INTO rmna_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Kad o Irod mulo, o anđeo e Gospodesoro alo ko suno e Josifese ano Egipat ");
INSERT INTO rmna_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","hem phenđa lese: “Ušti, le e čhavore hem lesere daja, i džan ki phuv Izrael, adalese so mule okola so mangle te mudaren e čhavore.” ");
INSERT INTO rmna_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ov uštino, lelja peja e čhavore hem lesere daja hem dželo ano Izrael. ");
INSERT INTO rmna_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kad šunđa so e Irodesoro čhavo o Arhelaj ulo nevo vladari ani regija Judeja, darandilo te džal adari. Tegani ko suno o Devel upozorinđa le te na džal adari, nego te džal ki regija Galileja. ");
INSERT INTO rmna_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","I džele hem živinde ani diz Nazaret. Adaleja pherdilo okova so phende o proroci e Mesijastar da ka vičini pe Nazarećanin. ");
INSERT INTO rmna_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ko adala dive o Jovan o Krstitelj lelja te propovedini ani pustinja e judejakiri ");
INSERT INTO rmna_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","vaćerindoj: “Pokajinen tumen zako tumare grehija, adalese soi o carstvo e nebosoro paše!” ");
INSERT INTO rmna_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","E Jovanestar vaćerđa o proroko o Isaija kad prorokujinđa: “Ovi o glaso so vičini ani pustinja: ‘Pripreminen o drom e Gospodese! Ravnonen lese o droma!’” ");
INSERT INTO rmna_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","A adava Jovan akharđa šeja oto bala e kamilakere, a ko maškar inele phandlo kožno pojas. Hala ine skakavconen hem divljo avđin. ");
INSERT INTO rmna_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","But manuša avena ine koro leste taro Jerusalim hem tari sa i regija Judeja hem taro sa o thana savei uzali len Jordan. ");
INSERT INTO rmna_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Priznajinena ine pumare grehija, a ov krstini len ine ani len Jordan. ");
INSERT INTO rmna_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Kad o Jovan dikhlja so but fariseja hem sadukeja avena te krstinen pe, phenđa lenđe: “E sapengere čhavalen! Ko vaćerđa tumenđe da šaj te našen tari e Devlesiri holi savi avela? ");
INSERT INTO rmna_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Tumare životeja mothoven da čače pokajinđen tumen! ");
INSERT INTO rmna_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","I ma mislinen dai dovoljno te phenen: ‘Amaroi pradad o Avraam.’ Phenava tumenđe da o Devel hem akale barendar šaj te vazdel čhaven e Avraamese. ");
INSERT INTO rmna_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ače o tover oto sudo e Devlesoroi već vazdime te čhinel o kašta ano koreno. I svako kaš savo na bijani šukar bijandipe ka čhinel pe hem ka frdel pe ani jag. ");
INSERT INTO rmna_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Me krstinava panjeja tumen kola kajinena tumen zako tumare grehija. Ali pala mande avela o po baro mandar, kase na injum dostojno ni i obuća te legarav. Ov ka krstini tumen Svetone Duhoja hem jagaja. ");
INSERT INTO rmna_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ano vas lese i lopata te čistini o gumno plo hem te odvojini o điv taro ljuske. O điv ka čhivel pese ki šupa, a o ljuske ka tharel jagaja savi nikad na mudarđola.” ");
INSERT INTO rmna_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Tegani o Isus alo tari Galileja ki len Jordan te krstini le o Jovan. ");
INSERT INTO rmna_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","A o Jovan na manglja hem phenđa lese: “Tu man valjani te krstine, a tu aveja kora mande!” ");
INSERT INTO rmna_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","A o Isus phenđa lese: “Muk akana adava. Valjani amenđe te ćera ađahar te šaj pherđol sa soi pali pravedno volja e Devlesiri.” Tegani o Jovan pristaninđa te krstini le. ");
INSERT INTO rmna_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","I odmah palo adava so o Isus krstinđa pe, iklilo taro pani. I dikh! O nebo phravdilo hem dikhlja e Devlesere Duho sar avela sar golubi hem huljela upro leste. ");
INSERT INTO rmna_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Tegani taro nebo šundilo o glaso e Devlesoro: “Akavai mlo Čhavo o volime. Oleja injum bahtalo!” ");
INSERT INTO rmna_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tegani o Duho legarđa e Isuse ki pustinja te ovel iskušime e bengestar. ");
INSERT INTO rmna_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Palo adava so postinđa saranda dive hem saranda raća, bokhalilo. ");
INSERT INTO rmna_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tegani alo koro leste o beng kova kušini hem phenđa lese: “Te injan o Čhavo e Devlesoro, vaćer akale barenđe te oven maro.” ");
INSERT INTO rmna_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","A o Isus phenđa: “Pisimei ano Sveto lil: ‘O manuš naka živini samo oto maro nego oto svako lafi savo ikljola taro muj e Devlesoro.’ ” ");
INSERT INTO rmna_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tegani o beng legarđa le ki Sveto diz Jerusalim, čhivđa le upro naj učo than e Hramesoro ");
INSERT INTO rmna_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","hem phenđa lese: “Te injan o Čhavo e Devlesoro, frde tut akatar tele! Adalese soi pisime: ‘Ka naredini ple anđelenđe te arakhen tut, te akharen tut ko vasta te na khuve tut preja ko bar.’” ");
INSERT INTO rmna_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","A o Isus phenđa lese: “Pisimei hem akava: ‘Ma kušin e Gospode, te Devle.’ ” ");
INSERT INTO rmna_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Tegani o beng anđa le upri but uči gora, mothovđa lese sa o carstvija e phuvjakere hem lengiri slava ");
INSERT INTO rmna_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","hem phenđa lese: “Sa akava ka dav tut, te peljan ko kočija angla mande te slavine man!” ");
INSERT INTO rmna_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","A o Isus phenđa lese: “Dža mandar, Sotone! Adalese soi pisime: ‘Per ko kočija samo anglo Gospod, to Devel, hem samo ole kande!’ ” ");
INSERT INTO rmna_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Tegani o beng cidinđa pe olestar, a o anđelja ale te kanden le. ");
INSERT INTO rmna_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","A kad o Isus šunđa so e Jovane e Krstitelje phandle, irinđa pe ki Galileja. ");
INSERT INTO rmna_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ačhavđa i diz Nazaret hem dželo te živini ani diz Kafarnaum, uzalo e Galilejakoro jezero, ko krajo oto plemija e Zavulonesere hem e Neftalimesere. ");
INSERT INTO rmna_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ađahar pherdilo okova so phenđa o proroko o Isaija: ");
INSERT INTO rmna_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ani phuv e Zavulonesiri hem e Neftalimesiri, uzalo jezero e Galilejakoro, tari aver strana oti len Jordan, ani regija Galileja e avere nacijengiri, ");
INSERT INTO rmna_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","o manuša kola živinde ani tomina dikhle baro svetlost; o svetlost thabilo upro okolende kola živinde ani senka e meribnasiri.” ");
INSERT INTO rmna_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Otegani o Isus lelja te propovedini: “Pokajinen tumen zako tumare grehija, adalese soi paše o carstvo e nebosoro!” ");
INSERT INTO rmna_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Sar o Isus nakhela ine uzalo e Galilejakoro jezero, dikhlja e duje phraljen, e Simone vičime Petar hem e Andreja, sar frdena o mreže ano pani, adalese so inele manuša so dolena maćhen. ");
INSERT INTO rmna_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","I phenđa lenđe: “Phiren pala mande hem me ka ćerav tumen te dolen manušen sar maćhen!” ");
INSERT INTO rmna_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","On odmah ačhavde pumare mreže hem džele palo leste. ");
INSERT INTO rmna_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Kad džele adathar hari po dur, o Isus dikhlja avere duje phraljen, e Jakove hem e Jovane, sar pumare dadeja e Zevedeja bešena ano čamco hem popravinena pumare mreže. O Isus vičinđa hem olen. ");
INSERT INTO rmna_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","I on otojekhvar ačhavde o čamco hem pumare dade hem džele palo leste. ");
INSERT INTO rmna_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","O Isus džala ine maškari sa i Galilejaja hem sikaj e manušen ano lengere sinagoge, vaćerindoj o Šukar lafi oto carstvo e nebosoro hem sasljarindoj e manušen oto svako nambormipe hem bizoralipe. ");
INSERT INTO rmna_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","O glaso olestar šundilo ani sa i Sirija, i đi adathar o manuša anena ine koro leste sa e nambormen oto razna nambormipa hem muke, e manušen ano kolende inele demonja, e manušen kolen inele epilepsija hem e nepokretnonen, a o Isus sasljari len ine. ");
INSERT INTO rmna_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Palo leste džele sa edobor manuša tari regija Galileja, taro Dekapolis, tari diz Jerusalim, tari regija Judeja hem tari aver strana oti len Jordan. ");
INSERT INTO rmna_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Kad o Isus dikhlja so but džene čedinde pe, uklinđa ki gora hem beštino te sikaj. Lesere učenici ale uzalo leste, ");
INSERT INTO rmna_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","i ov lelja te sikaj len, vaćerindoj: ");
INSERT INTO rmna_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Bahtalei o čorore duhoja adalese soi olengoro o carstvo e nebosoro! ");
INSERT INTO rmna_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Bahtalei okola kola tugujinena, adalese so o Devel ka utešini len! ");
INSERT INTO rmna_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Bahtalei o krotka, adalese so olenđe ka ačhol i phuv! ");
INSERT INTO rmna_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Bahtalei o bokhale hem o žedna zaki pravednost, adalese so o Devel ka čaljari len! ");
INSERT INTO rmna_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Bahtalei o milosrdna, adalese so o Devel ka mothoj lenđe milosrđe! ");
INSERT INTO rmna_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Bahtalei o manuša bimelale vilesere, adalese so ka dikhen e Devle! ");
INSERT INTO rmna_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Bahtalei okola kola ćerena mir, adalese so ka vičinen pe čhave e Devlesere! ");
INSERT INTO rmna_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Bahtalei o progonime zaki pravednost, adalese soi olengoro o carstvo e nebosoro! ");
INSERT INTO rmna_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Bahtale injen kad zbog mande o manuša vređinena tumen, kad progoninena tumen hem kad hovavne vaćerena protiv tumende! ");
INSERT INTO rmna_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Radujinen tumen hem oven bahtale, adalese so bari nagrada adžićeri tumen ko nebo. Adalese so ađahar progoninde e prorokonen kola inele angleder tumendar!” ");
INSERT INTO rmna_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","O Isus phenđa: “Tumen injen sar o lon e manušenđe ki phuv. Ali te o lon našalđa plo londipe, soja ov ka lonđari pe? Esavko nane šukar nisose, sem te frdel pe avri, te gazinen le o manuša. ");
INSERT INTO rmna_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Tumen injen o svetlost e svetose. I diz savi upri gora našti te garaj pe. ");
INSERT INTO rmna_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Niko na tharela i svetiljka i te garaj la talo čaro, nego čhivela la ko than zaki svetiljka te šaj svetlini sarijenđe kolai ano čher. ");
INSERT INTO rmna_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ađahar hem tumaro svetlost te svetlini e manušenđe te dikhen tumare šukar delja hem te slavinen tumare Dade kovai ano nebo.” ");
INSERT INTO rmna_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Tegani o Isus phenđa: “Ma mislinen da aljum te čhinavav o zakoni e Mojsijasoro hem o lila e prorokonengere. Na aljum te čhinavav len, nego te pherav len. ");
INSERT INTO rmna_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Čače vaćerava tumenđe, sa đikote ka oven o nebo hem i phuv, ni o najtikoro slovo, nijekh crtica, oto Zakoni naka nakhel đikote sa adava na ovela. ");
INSERT INTO rmna_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Adalese, ko phagela hem jekh oto najtikore naredbe, hem averen sikaj te ćeren ađahar, ka ovel najtikoro ano carstvo e nebosoro. A ko ićeri o naredbe, hem averen sikaj te ćeren ađahar, ka ovel baro ano carstvo e nebosoro. ");
INSERT INTO rmna_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Adalese vaćerava tumenđe, na ovela li tumari pravednost po bari oti pravednost e učiteljengiri e Zakonestar hem e farisejengiri, nisar naka šaj te đerdinen ano carstvo e nebosoro!” ");
INSERT INTO rmna_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","I phenđa: “Šunđen soi phendo ano Zakoni amare pradadenđe: ‘Ma mudar! Ko mudari, ka ovel krivo anglo sudo.’ ");
INSERT INTO rmna_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","A me phenava tumenđe: Ko holjani upro plo phral, ka ovel krivo anglo sudo. Ko vičini ple phrale ‘budalo’, ka ovel krivo anglo po baro sudo. A te vičinđa le ‘Dilineja’, ka ovel krivo hem ka džal ano jagalo pakao. ");
INSERT INTO rmna_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Adalese, te injan anglo žrtveniko ano Hram hem deja žrtva e Devlese i otojekhvar setineja tut da te phrale isi nešto protiv tute, ");
INSERT INTO rmna_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ačhav te žrtva anglo žrtveniko, dža najangle mirin tut oleja i tegani ava hem de te žrtva e Devlese. ");
INSERT INTO rmna_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","So po sigate mirin tut te protivnikoja odrumal, pana sar na anđa tut ko sudo. Te na ćerđan ađahar, ov šaj te del tut ko sudija, a o sudija te del tut ko manuš kova ka čhivel tut ano phandlipe. ");
INSERT INTO rmna_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Vaćerava će da čače naka ikljove adathar sa đikote na irineja đi i zadnjo para.” ");
INSERT INTO rmna_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","I o Isus phenđa: “Šunđen soi phendo ano Zakoni: ‘Ma ćer preljuba!’ ");
INSERT INTO rmna_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","A me phenava tumenđe: Sar ko dikhela avera đuvlja ađahar da mangela te sovel olaja, već ćerđa preljuba olaja pese ano vilo. ");
INSERT INTO rmna_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Te ti desno jakh legari tut ano greh, ikal la hem frde la tutar. Adalese soi po šukar tuće te našale jekh deo te telostar nego sa to telo te ovel frdime ano pakao. ");
INSERT INTO rmna_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Hem te to desno vas legari tut ano greh, čhin le hem frde le tutar. Adalese soi po šukar tuće te ačhove bizo jekh deo te telostar nego sa to telo te džal ko pakao.” ");
INSERT INTO rmna_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","I phenđa: “Ano Zakoni inele da phendo: ‘Ko ačhaj pla romnja, nek del la lil kote pisini so ačhavđa la.’ ");
INSERT INTO rmna_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","A me phenava tumenđe: Svako kova ačhaj pla romnja, čhivela la te ćerel preljuba, sem te ačhavđa la zbog lakiri preljuba. Hem svako kova lela romnja kola o rom muklja, ćerela preljuba.” ");
INSERT INTO rmna_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","I o Isus phenđa: “Šunđen soi hem akava phendo ano Zakoni amare pradadenđe: ‘Ma phag i sovli, nego ćer okova savese haljan sovli e Gospodese.’ ");
INSERT INTO rmna_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","A me phenava tumenđe: Ma han sovli nisar! Ma han sovli ni e neboja, adalese soi e Devlesoro tron, ");
INSERT INTO rmna_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ni e phuvjaja, adalese soi talo lesere pre, ni e Jerusalimeja, adalese soi adava i diz kaj o Devel vladini sar baro caro. ");
INSERT INTO rmna_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ma han sovli ni tumare šereja, adalese so čak nijekh bal našti te ćeren te ovel parno ili kalo. ");
INSERT INTO rmna_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kad phenena: ‘Oja’, nek adava čače značini ‘oja’; kad phenena: ‘Na’, nek adava čače značini ‘na’. Sa so više phenena adalestar, avela e Bišukarestar.” ");
INSERT INTO rmna_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","I o Isus phenđa: “Šunđen soi phendo ano Zakoni: ‘Jakh zaki jakh, dand zako dand!’ ");
INSERT INTO rmna_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","A me phenava tumenđe: Ma suprotstavinen tumen e bišukare manušese! Te khuvđa tut neko ki desno čham, irin lese hem i dujto! ");
INSERT INTO rmna_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Te neko mangela te legari tut ko sudo hem te lel tutar o gad, de le hem o ogrtači. ");
INSERT INTO rmna_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Te e rimesere vojnici terinena tut te akhare lenđe i oprema jekh kilometari, akhar lenđe duj. ");
INSERT INTO rmna_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Te neko rodela tutar nešto, de le, hem ma irin to dumo okolese kova rodela tutar ko zajam.” ");
INSERT INTO rmna_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","I phenđa: “Šunđen soi phendo: ‘Volin te pašutne’, a mrzin te neprijatelje! ");
INSERT INTO rmna_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","A me phenava tumenđe: Volinen hem tumare neprijateljen hem molinen tumen okolenđe kola progoninena tumen, ");
INSERT INTO rmna_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","sar te šaj mothoven da injen čhave tumare Dadesere kovai ano nebo. Ov ćerela lesoro kham te ikljol upreder hem o bišukar hem o šukar manuša, hem bičhali bršim okolenđe kolai pravedna hem okolenđe kola nane pravedna. ");
INSERT INTO rmna_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Adalese so, te volinena samo okolen kola tumen volinena, savi nagrada šaj te adžićeren? Na li ađahar ćerena hem o carinici? ");
INSERT INTO rmna_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Te pozdravinena samo tumare manušen, so ćerena po šukar averendar? Adava ćerena hem okola kola na džanen e Devlese. ");
INSERT INTO rmna_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Adalese tumen oven savršena sar soi savršeno tumaro Dad kovai ano nebo.” ");
INSERT INTO rmna_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","O Isus phenđa: “Pazinen! Ma ćeren šukaripe anglo manuša, sar te dikhen tumen aver džene, adalese so, te ćerđen ađahar, tumaro Dad kovai ano nebo naka del tumen nagrada. ");
INSERT INTO rmna_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Adalese, kad deja e čororenđe, ma mothov adava javno. Ađahar ćerena e dujemujengere ano sinagoge hem ko droma sar te hvalinen len o manuša. Čače vaćerava tumenđe, aver nagrada sem adaja naka dobinen. ");
INSERT INTO rmna_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nego, kad deja e čororenđe, te na džanel to levo vas so ćerela to desno. ");
INSERT INTO rmna_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","De e čororenđe garandoj, a to Dad, kova dikhela soi ćerdo ano garavdipe, ka nagradini tut.” ");
INSERT INTO rmna_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Hem kad molinena tumen, ma oven sar e dujemujengere kola volinena te molinen pe ano sinagoge hem ko raskrsnice sar te dikhen len o manuša. Čače vaćerava tumenđe, aver nagrada sem adaja naka dobinen. ");
INSERT INTO rmna_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nego, kad molineja tut, đerdin korkoro tuće ki soba, phand o udar hem molin tut te Dadese e Devlese kovai ano garavdipe, a to Dad, kova dikhela soi ćerdo ano garavdipe, ka nagradini tut. ");
INSERT INTO rmna_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Kad molinena tumen, ma vaćeren but čuče lafija sar okola kola na džanen e Devlese, adalese so mislinena da ka oven uslišime te vaćerde but lafija. ");
INSERT INTO rmna_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Adalese, ma oven sar olende, adalese so tumaro Dad džanel so valjani tumenđe čak hem angleder so rodena lestar. ");
INSERT INTO rmna_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Adalese ađahar molinen: ‘Dade amareja, kova injan ano nebo, to sveto anav barjardo te ovel. ");
INSERT INTO rmna_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","To carstvo te avel. Ti volja te ovel, sar soi ano nebo, ađahar te ovel hem ki phuv. ");
INSERT INTO rmna_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","De amen avdive o maro savo valjani amenđe svako dive ");
INSERT INTO rmna_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","hem oprostin amenđe amare grehija sar so hem amen oprostinaja okolenđe kola grešinde premala amende. ");
INSERT INTO rmna_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Hem cide amen taro iskušenje, hem oslobodin amen e Bišukarestar. Adalese soi to carstvo, to zoralipe hem ti slava zauvek.’ ");
INSERT INTO rmna_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Adalese so, te oprostinđen avere manušenđe kad grešinena premala tumende, hem tumaro Dad, kovai ano nebo, ka oprostini tumenđe. ");
INSERT INTO rmna_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ali te na oprostinđen averenđe, ni tumaro Dad naka oprostini tumenđe tumare grehija.” ");
INSERT INTO rmna_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Kad postinena, ma čeden tumare phova sar e dujemujengere, adalese so on ćerena muja sar te oven dikhle averendar da postinena. Čače vaćerava tumenđe, aver nagrada sem adaja naka dobinen. ");
INSERT INTO rmna_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nego, kad postineja, harov te bala hem thov to muj, ");
INSERT INTO rmna_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","te na dikhen o manuša so postineja, nego samo to Dad kovai ano garavdipe. Tegani to Dad, kova dikhela soi ćerdo ano garavdipe, ka nagradini tut.” ");
INSERT INTO rmna_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ma čeden tumenđe barvalipe ki phuv, kote o moljci hem i rđa ka uništinen le, a o čora šaj te aven te čoren le. ");
INSERT INTO rmna_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nego, čeden tumenđe barvalipe ko nebo, kote ni o moljci ni i rđa naka šaj uništinen le, a ni o čora našti te aven te čoren le. ");
INSERT INTO rmna_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Adalese so to vilo ka ovel adari kaj to barvalipe. ");
INSERT INTO rmna_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ti jakhi sar svetiljka te telose. Kadi ti jakh šukar, sai to telo osvetlime, ");
INSERT INTO rmna_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","a kadi ti jakh bišukar, sai to telo ani tomina. Adalese, te o svetlost ana tute ovela tomina, savi bari adaja tomina ka ovel!” ");
INSERT INTO rmna_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Nijekh robo našti kandel duje gospodaren. Ili ka mrzini jekhe, a ka volini e dujtone, ili jekhese ka ovel poslušno, a e dujtone naka podnosini. Našti kanden hem e Devle hem o barvalipe.” ");
INSERT INTO rmna_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Adalese vaćerava tumenđe: Ma oven zabrinuta zako tumaro dživdipe: ka ovel tumen li so te han ili so te pijen, ni zako tumaro telo: ka ovel tumen li so te urjaven. Nane li o dživdipe po bitno e hajbnastar, a o telo e šejendar? ");
INSERT INTO rmna_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Dikhen šukar e čirikljen! Ni sejinena ni čedena te čhiven ano šupe, a palem parvari len tumaro Dad kovai ano nebo. A na li tumen više vredinena e čirikljendar? ");
INSERT INTO rmna_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","A kova tumendar šaj adaleja so brinini pe te produžini hari plo dživdipe? ");
INSERT INTO rmna_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Hem sose brininena tumen zako šeja? Dikhen šukar o divlja luluđa sar barjona. Na ćerena buti, niti sivenafse šeja, ");
INSERT INTO rmna_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","a vaćerava tumenđe da ni o caro o Solomon, kova inele but barvalo, na inole edobor šuže šeja sar jekha olendar. ");
INSERT INTO rmna_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Te o Devel ađahar šukar urjavela o biljke ko polje savei avdive adathe, a već tejsa frdena pe ani jag, kobor li više tumenđe ka del šeja, tikora verakere manušalen! ");
INSERT INTO rmna_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Adalese, ma oven zabrinuta hem ma vaćeren: ‘So ka ha?’ ili ‘So ka pija?’ ili ‘So ka urjava?’ ");
INSERT INTO rmna_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Adalese so adava rodena okola kola na džanen e Devlese. Tumaro Dad kovai ano nebo džanel da valjani tumenđe sa adava. ");
INSERT INTO rmna_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Nego, najangle roden o carstvo e Devlesoro hem lesiri pravednost, a sa adava so valjani tumenđe, ov ka del tumen! ");
INSERT INTO rmna_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Adalese, ma brininen tumen zako tejsato dive; nek o tejsato dive brinini pe pese. Svako dive isi le dovoljno ple bišukaripa.” ");
INSERT INTO rmna_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","I o Isus phenđa: “Ma sudinen hem naka sudini pe tumenđe! ");
INSERT INTO rmna_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Adalese so, sar sudinena averenđe, ađahar hem o Devel ka sudini tumenđe; hem sava meraja merinena, esavkaja ka merini tumenđe. ");
INSERT INTO rmna_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","A sose dikheja i trunka ani jakh te phralesiri, a i greda ani ti jakh na primetineja? ");
INSERT INTO rmna_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Sar šaj te phene te phralese: ‘Aš te ikalavtar i trunka oti jakh’, a tut isi greda ani jakh? ");
INSERT INTO rmna_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Dujemujengereja, najangle ikal i greda te jakhatar, i tegani šukar ka dikhe te ikale i trunka te phralesere jakhatar. ");
INSERT INTO rmna_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ma den e đuklenđe okova soi sveto hem ma frden tumare biserja anglo bale. Adalese so o bale ka gazinen len, a o đukle ka irinen pe hem ka pharaven tumen ko kotora.” ");
INSERT INTO rmna_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Mangen hem ka del pe tumenđe! Roden hem ka arakhen! Khuven hem ka phravel pe tumenđe! ");
INSERT INTO rmna_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Adalese so svako kova mangela, primini; hem kova rodela, arakhi; hem kova khuvela, ka ovel lese phravdo. ");
INSERT INTO rmna_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ko tumendar pe čhavese, kad ka rodel lestar ine maro, ka del le bar? ");
INSERT INTO rmna_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ili kad ka rodel lestar ine maćhe, ka del le sape? ");
INSERT INTO rmna_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kad tumen, kola injen bišukar, džanen te den šukar darija tumare čhavenđe, kobor više tumaro Dad kovai ano nebo ka del šukar darija okolenđe kola rodena olestar. ");
INSERT INTO rmna_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Adalese, sar so mangena avera te ćeren tumenđe, ađahar ćeren tumen olenđe, adalese soi adava okova so sikaj o Zakoni e Mojsijasoro hem o Proroci.” ");
INSERT INTO rmna_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","I o Isus phenđa: “Đerdinen maškaro tesno udar. Adalese so o bulo udar hem o bulo drom legarena ani propast, a isi but džene so džana oleja. ");
INSERT INTO rmna_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Buti tesno o udar hem o drom savo legari ano dživdipe, a isi hari džene kola arakhena le.” ");
INSERT INTO rmna_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","I phenđa: “Arakhen tumen e hovavne prorokonendar. On avena kora tumende urjavde sar bakre, a andrali divlja ruva. ");
INSERT INTO rmna_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Palo lengere plodija ka pendžaren len. Na čedena pe o drakha oto kare, ni o smokve oto čičke. ");
INSERT INTO rmna_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ađahar, svako šukar kaš dela šukar plodija, a o bišukar kaš dela bišukar plodija. ");
INSERT INTO rmna_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","O šukar kaš našti del bišukar plodija, ni o bišukar kaš našti del šukar plodija. ");
INSERT INTO rmna_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Svako kaš savo na dela šukar plodija, čhinela pe hem frdela pe ani jag. ");
INSERT INTO rmna_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Adalese, e hovavne prorokonen ka pendžaren palo lengere plodija.” ");
INSERT INTO rmna_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Ano carstvo e nebosoro naka đerdinen sare kola vaćerena maje ‘Gospode, Gospode’, nego samo okola kola ćerena i volja mle Dadesiri kovai ano nebo. ");
INSERT INTO rmna_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ko adava dive kad ka ovel o sudo, but džene ka vaćeren maje: ‘Gospode, Gospode, na li amen tuće ano anav prorokujinđam, ispudinđam e demonen hem ćerđam bare čudesija?’ ");
INSERT INTO rmna_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Tegani phravdeste ka phenav lenđe: ‘Nikad na pendžarđum tumen. Džan mandar, tumen kola phagena e Devlesoro zakoni!’ ” ");
INSERT INTO rmna_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Adalese, svako kova šunela akala mle lafija hem ćerela len, ovi mudro sar o manuš kova ćerela plo čher upro temelji oto bar. ");
INSERT INTO rmna_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","I pelo o bršim, ale o panja, phudinde o barvalja hem khuvde adava čher, ali o čher na pelo, adalese soi ćerdo upro temelji oto bar. ");
INSERT INTO rmna_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Svako kova šunela akala mle lafija, a na ćerela len, ovi sar o dilino manuš kova ćerela plo čher upri pošik. ");
INSERT INTO rmna_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","I pelo o bršim, ale o panja, phudinde o barvalja hem khuvde adava čher, i adava čher pelo hem ulo bari ruševina.” ");
INSERT INTO rmna_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Kad o Isus završinđa ple vaćeribnaja, o narodo inele zadivime lesere sikavibnaja, ");
INSERT INTO rmna_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","adalese so sikavđa sar okova kole isi autoritet, a na sar lengere učitelja e Zakonestar. ");
INSERT INTO rmna_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Sar o Isus huljela ine tari gora, baro narodo dželo palo leste. ");
INSERT INTO rmna_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Otojekhvar alo koro leste nesavo gubavco, pelo ko kočija anglo leste hem phenđa: “Gospode, te mangeja, šaj te sasljare man!” ");
INSERT INTO rmna_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","I o Isus pružinđa plo vas, dolinđa le hem phenđa: “Mangava, ov sasljardo!” I otojekhvar ulo sasljardo oti guba. ");
INSERT INTO rmna_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Tegani o Isus phenđa lese: “Ma vaćer nikase akalestar, nego dža mothov tut e sveštenikose hem de žrtva, sar so naredinđa o Mojsije, zako svedočanstvo olenđe.” ");
INSERT INTO rmna_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Kad o Isus đerdinđa ki diz Kafarnaum, alo koro leste jekh kapetani e rimljanengoro, kova inele upreder šel vojnici, hem rodinđa lestar pomoć ");
INSERT INTO rmna_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","vaćerindoj: “Gospode, mlo sluga pašljola čhere nepokretno hem ano bare dukha.” ");
INSERT INTO rmna_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","O Isus phenđa lese: “Ka avav te sasljarav le.” ");
INSERT INTO rmna_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","A o kapetani phenđa: “Gospode, na injum dostojno te đerdine maje ko čher. Nego samo naredin hem mlo sluga ka ovel sasto. ");
INSERT INTO rmna_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Adalese so hem me injum manuš talo autoritet, hem isi man vojnici teleder mande. I jekhese vaćerava: ‘Dža!’ – i ov džala. A averese vaćerava: ‘Ava!’ – i ov avela. A mle slugase vaćerava: ‘Ćer adava!’ – i ov ćerela.” ");
INSERT INTO rmna_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","A o Isus kad šunđa adava, iznenadinđa pe, irinđa pe nakoro narodo kova džala ine palo leste hem phenđa lenđe: “Čače vaćerava tumenđe, na arakhljum nijekhe ano Izrael te ovel le esavki vera. ");
INSERT INTO rmna_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","A vaćerava tumenđe hem akava: but džene ka aven tari sa i phuv, taro istok hem taro zapad, hem ka oven uzalo astali e Avraameja, e Isaakeja hem e Jakoveja ki gozba ano carstvo e nebosoro. ");
INSERT INTO rmna_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","A okola kolenđe o carstvo pripadini ka oven frdime avri taro carstvo, ani naj dur tomina, kote ka ovel baro rojba hem krciba e dandengoro tari dukh.” ");
INSERT INTO rmna_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Tegani phenđa e kapetanese: “Dža! Nek ovel ađahar sar so verujinđan!” I ko adava momenti e kapetanesoro sluga saslilo. ");
INSERT INTO rmna_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Kad o Isus alo e Petrese ko čher, dikhlja lesere sasuja sar pašljola namborme hem isi la bari jag. ");
INSERT INTO rmna_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","I o Isus dolinđa lakoro vas hem i jag muklja la, i oj uštini hem lelja te poslužini le. ");
INSERT INTO rmna_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Kad peli i rat, ande koro leste bute manušen ano kolende inele o demonja hem ov lafeja ispudinđa e duhen hem sasljarđa sa e nambormen. ");
INSERT INTO rmna_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ađahar pherdilo okova so phenđa o proroko o Isaija: “Ov lelja amare bizoralipa hem legarđa amare nambormipa.” ");
INSERT INTO rmna_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Kad o Isus dikhlja da but džene čedinde pe uzalo leste, naredinđa ple učenikonenđe te nakhen ki aver strana oto jezero. ");
INSERT INTO rmna_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Tegani alo đi leste jekh učitelj e Zakonestar hem phenđa: “Učitelju, ka džav tuja kaj god tu džaja.” ");
INSERT INTO rmna_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","A o Isus phenđa lese: “E lisicen isi jazbine hem e čirikljen gnezdija, a man, e Čhave e manušesere nane kaj te pašljarav mlo šero.” ");
INSERT INTO rmna_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Aver učeniko phenđa lese: “Aš najangle, Gospode, te parunav mle dade, i ka džav pala tute.” ");
INSERT INTO rmna_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","A o Isus phenđa lese: “Phir pala mande hem muk o mule te parunen ple mulen.” ");
INSERT INTO rmna_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","I kad o Isus đerdinđa ano čamco, palo leste đerdinde hem lesere učenici. ");
INSERT INTO rmna_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","I otojekhvar upro jezero muklja pe jekh zorali barval da o čamco lelja te pherđol pani oto talasija, a o Isus sovela ine. ");
INSERT INTO rmna_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","O učenici ale uzalo leste hem džangavde le vaćerindoj: “Gospode, spasin amen, meraja!” ");
INSERT INTO rmna_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","O Isus pučlja len: “Sose darana, tikora verakere manušalen?” Tegani uštino, naredinđa e barvaljaće hem e jezerose te ačhon, i ulo baro mir. ");
INSERT INTO rmna_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","A o manuša ule začudime hem pučle: “Kovai akava so đi o barvalja hem o jezero šunena le?” ");
INSERT INTO rmna_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","I kad o Isus reslo ki aver strana oto jezero, ano krajo e Gadaresoro, iklile anglo leste duj manuša opsednutime demonencar kola avena ine taro grobija. Edobor inele nasilna da niko našti ine te nakhel adale dromeja. ");
INSERT INTO rmna_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Otojekhvar vičinde: “So mangeja amendar, Čhaveja e Devlesereja? Akari li aljan te mučine amen angleder nego so valjani?” ");
INSERT INTO rmna_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","A po dur olendar jekh baro krdo oto bale hana ine. ");
INSERT INTO rmna_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","O demonja molinde e Isuse: “Te ispudinđan amen, bičhal amen ano okova krdo oto bale.” ");
INSERT INTO rmna_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ov phenđa lenđe: “Džan!” I on iklile e duje manušendar hem đerdinde ano bale. I sa o bale prastandile taro brego ano jezero hem taslile ano pani. ");
INSERT INTO rmna_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","A okola so arakhena ine e balen, našle hem džele ki diz te vaćeren e manušenđe sa so ulo, hem adava so ulo e opsednutimencar. ");
INSERT INTO rmna_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tegani sa o manuša oti diz ale koro Isus. Kad dikhle le, lelje te molinen le te džal taro lengoro krajo. ");
INSERT INTO rmna_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","O Isus đerdinđa ano čamco, nakhino ki aver strana hem reslja pese ki diz. ");
INSERT INTO rmna_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Adari nesave manuša koro leste ande upri nosiljka jekhe manuše kova našti ine te phirel ni te mrdini. Kad o Isus dikhlja lengiri vera, phenđa e nambormese: “Ma dara, mlo čhavo, oprostimei će te grehija!” ");
INSERT INTO rmna_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","A nesave učitelja e Zakonestar vaćerde ana pumende: “Akava hulini!” ");
INSERT INTO rmna_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","O Isus džanđa so mislinena, pa pučlja len: “Sose ađahar bišukar mislinena ano tumare vile? ");
INSERT INTO rmna_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Soi po lokhe te phenel pe: ‘Oprostimei će te grehija’ ili te phenel pe: ‘Ušti hem phir’? ");
INSERT INTO rmna_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ka dokažinav tumenđe da man, e Čhave e manušesere, isi pravo ki phuv te oprostinav o grehija.” Tegani phenđa e manušese kova našti ine te phirel: “Ušti, le ti nosiljka hem dža čhere!” ");
INSERT INTO rmna_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","I ov uštino hem dželo čhere. ");
INSERT INTO rmna_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kad o narodo dikhlja adava, inele zadivime hem lelje te slavinen e Devle so e manušenđe dinđa esavko autoritet. ");
INSERT INTO rmna_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Sar džala ine adathar, o Isus dikhlja jekhe manuše palo anav Matej sar bešela ko than kotar čedela pe o porez, pa phenđa lese: “Phir pala mande!” I o Matej uštino hem dželo palo leste. ");
INSERT INTO rmna_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","I sar o Isus inele uzalo astali ano čher e Matejesoro, but carinici hem avera grešnici ale te han oleja hem lesere učenikonencar. ");
INSERT INTO rmna_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Kad o fariseja dikhle adava, pučle lesere učenikonen: “Sose tumaro učitelj hala e carinikonencar hem avere grešnikonencar?” ");
INSERT INTO rmna_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","A o Isus šunđa adava, pa phenđa: “E sastenđe na valjani doktori, nego e nambormenđe. ");
INSERT INTO rmna_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nego, džan hem sikljoven so značini akava: ‘Po šukari maje te dikhav da injen milosrdna, nego te anen maje žrtven.’ Adalese so, na aljum te vičinav e pravednikonen, nego e grešnikonen.” ");
INSERT INTO rmna_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Tegani e Jovanesere e Krstiteljesere učenici ale koro Isus hem pučle le: “Sar adava amen hem o fariseja postinaja, a te učenici na postinena?” ");
INSERT INTO rmna_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","O Isus phenđa lenđe: “Tugujinena li e mladoženjasere amala kadi olencar o mladoženja? Na. Ali ka aven o dive kad o manuša ka len lendar e mladoženja. Tegani ka postinen. ");
INSERT INTO rmna_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Niko na sivela o nevo kotor zako šeja upro purano fostani sar te pherel i rupa, adalese so, ko thojba, adava kotor ka čedel pe, ka pharaj pe oto fostani hem ka ćerel po bari rupa. ");
INSERT INTO rmna_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ni i nevi mol na čhorela pe ano purane morćha. Te ćerđa pe ađahar, kad i mol ka zreloni, o morćha ka pharavđon hem ka oven uništime, a i mol ka čhorđol. Nego, i nevi mol čhorela pe ano neve morćha, i soduj ka oven arakhle.” ");
INSERT INTO rmna_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Sar o Isus vaćeri ine adava, alo jekh vođa e sinagogakoro, pelo ko kočija anglo Isus hem phenđa: “Mli čhaj akana muli. Ali tu ava hem čhiv to vas upro late hem oj palem ka živini.” ");
INSERT INTO rmna_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","O Isus uštino hem ple učenikonencar dželo palo leste. ");
INSERT INTO rmna_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","I dikh, nesavi đuvli kolatar dešu duj berš thavdinđa rat nakhini oto palal e Isusese hem dolinđa pe upro lesere fostanesoro krajo, ");
INSERT INTO rmna_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","adalese so phenđa ana peste: “Samo te dolav man upro lesoro fostani, ka ovav sasljardi.” ");
INSERT INTO rmna_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","O Isus irinđa pe, i kad dikhlja la, phenđa laće: “Ma dara, mli čhaj, ti vera sasljarđa tut.” I oj odmah saslili. ");
INSERT INTO rmna_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kad o Isus đerdinđa ko čher e sinagogakere vođasoro, dikhlja e manušen kola zbog i muli čhaj bašalena flaute hem averen kola galaminena. ");
INSERT INTO rmna_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","I phenđa lenđe: “Džan tumenđe! I čhajori na muli, nego sovela.” I on asandile lese. ");
INSERT INTO rmna_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kad o manuša inele ikalde avri, o Isus đerdinđa adari kaj inele i čhajori, dolinđa la oto vas hem oj uštini. ");
INSERT INTO rmna_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","I adava šundilo ko sa adava krajo. ");
INSERT INTO rmna_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Sar o Isus džala ine adathar, duj korore manuša džele palo leste vičindoj: “Smilujin tut amenđe, Čhaveja Davidesereja!” ");
INSERT INTO rmna_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Kad đerdinđa ano čher, ale anglo leste o korore, i o Isus pučlja len: “Verujinena li da me šaj te sasljarav tumen?” A on phende: “Oja, Gospode!” ");
INSERT INTO rmna_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tegani čhivđa ple vasta upro lengere jaćha hem phenđa: “Nek ovel tumenđe sar so verujinena.” ");
INSERT INTO rmna_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","I on lelje te dikhen. Tegani o Isus zorale upozorinđa len vaćerindoj: “Nikase ma vaćeren akalestar.” ");
INSERT INTO rmna_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ali on džele hem vaćerde olestar ko sa adava krajo. ");
INSERT INTO rmna_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","I sar on ikljona ine taro čher, nesave manuša ande anglo Isus jekhe manuše kova našti ine te vaćeri, kova inele opsednutime demoneja. ");
INSERT INTO rmna_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kad o Isus ispudinđa e demone, o manuš lelja te vaćeri. I o narodo inele zadivime hem phende: “Nikad ađahar nešto na dikhljam ano Izrael!” ");
INSERT INTO rmna_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","A o fariseja vaćerena ine: “E demonengere šerutnesere zoralipnaja ispudini e demonen!” ");
INSERT INTO rmna_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","O Isus džala ine ko sa o dizja hem o gava hem sikaj e manušen ano lengere sinagoge, vaćerindoj o Šukar lafi e carstvostar hem sasljarindoj e manušen oto svako nambormipe hem bizoralipe. ");
INSERT INTO rmna_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Kad dikhlja e narodo, ine lese pharo olenđe, adalese so inele uznemirime hem bespomoćna sar bakre bizo pastiri. ");
INSERT INTO rmna_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Tegani phenđa ple učenikonenđe: “I žetvai bari, a hari bućarne te čeden. ");
INSERT INTO rmna_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Adalese, molinen e gospodare oti žetva te bičhali e bućarnen ki žetva pli.” ");
INSERT INTO rmna_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","O Isus vičinđa kora peste e dešu duje apostolen hem dinđa len autoritet upro bišukar duhija, te ispudinen len, hem te sasljaren svako nambormipe hem bizoralipe. ");
INSERT INTO rmna_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","A akavai o anava e dešu duje apostolengere: Simon, vičime Petar, Andreja, e Petresoro phral, Jakov, e Zevedejesoro čhavo, Jovan, e Jakovesoro phral, ");
INSERT INTO rmna_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip, Vartolomej, Toma, Matej, o cariniko, Jakov, e Alfejesoro čhavo, Tadej, ");
INSERT INTO rmna_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon Zilot hem Juda Iskariot, kova posle izdajinđa e Isuse. ");
INSERT INTO rmna_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","O Isus bičhalđa akale dešu dujen vaćerindoj: “Ma džan koro manuša taro avera nacije hem ma đerdinen ki nisavi diz e samarijakiri, ");
INSERT INTO rmna_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","nego najangle džan koro našalde bakre e izraelesere narodostar. ");
INSERT INTO rmna_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Džan hem vaćeren lenđe dai o carstvo e nebosoro paše. ");
INSERT INTO rmna_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Sasljaren e nambormen hem e gubavonen, vazden e mulen hem ispudinen e demonen. Bizo pare priminđen, bizo pare den. ");
INSERT INTO rmna_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ma len tumencar zlatna, ni srebrna, ni bakarna kovanice ano tumare pojasija, ");
INSERT INTO rmna_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ni torba dromese, ni aver gad, ni buderi obuća, ni štapi, adalese so o bućarno zaslužini pli plata. ");
INSERT INTO rmna_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Kad đerdinena ki nesavi diz ili gav, roden nekas ko ka primini tumen te ačhoven koro leste đikote na džana adathar. ");
INSERT INTO rmna_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","So đerdinena ko adava čher, vaćeren: ‘Mir akale čhereste’. ");
INSERT INTO rmna_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Te o čherutne priminde tumen, tumaro mir nek ačhol olencar. A te na priminde tumen, tumaro mir nek irini pe tumenđe. ");
INSERT INTO rmna_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Te neko na priminđa tumen ili te na manglja te šunel tumare lafija, ikljoven taro adava čher ili tari adaja diz hem tresinen i prašina tumare prendar sar znako zako zoralo odbiba. ");
INSERT INTO rmna_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Čače, phenava tumenđe, ko dive oto baro sudo ka ovel po lokhe e manušenđe tari Sodoma hem Gomora negoli e manušenđe tari adaja diz.” ");
INSERT INTO rmna_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ače, bičhalava tumen sar bakren maškaro ruva. Adalese oven lukava sar o sapa, a birumime sar o golubija. ");
INSERT INTO rmna_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Arakhen tumen, adalese so o manuša ka legaren tumen ko sudo hem ka šibinen tumen pumenđe ano sinagoge. ");
INSERT INTO rmna_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Adalese so injen mle učenici, ka legaren tumen ko sudo anglo vladarija hem anglo carija. Adava ka ovel te šaj olenđe hem e manušenđe taro avera nacije te svedočinen mandar. ");
INSERT INTO rmna_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kad on ka preden tumen, ma oven zabrinuta sar hem so te vaćeren, adalese so tegani ka del pe tumenđe so te vaćeren. ");
INSERT INTO rmna_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Adalese so naka vaćeren tumen, nego o Duho tumare nebeskone Dadesoro ka vaćeri prekala tumende. ");
INSERT INTO rmna_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","O phral e phrale ka del te mudaren le, a o dad e čhave. O čhave ka ušten upro pumare dada hem daja hem ka ćeren lenđe te oven mudarde. ");
INSERT INTO rmna_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Sare ka mrzinen tumen zbog mande. Ali kova ačhola verno đi o kraj, ka ovel spasime. ");
INSERT INTO rmna_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kad ka len te progoninen tumen ani jekh diz, našen ki aver. Čače vaćerava tumenđe, naka resen te ćeren ano sa o dizja e Izraelesere okova sose injen bičhalde angleder so me, o Čhavo e manušesoro, ka avav. ");
INSERT INTO rmna_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Nane o učeniko upreder o učitelji, ni o sluga upreder o gospodari. ");
INSERT INTO rmna_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Dovoljnoi e učenikose te ulo sar lesoro učitelji, a e slugase te ulo sar lesoro gospodari. Te man, e domaćine, vičinde ‘Veelzevul’ – Sotoni – kobor više tumen, mle čherutnen, ka vičinen po bišukare anavencar!” ");
INSERT INTO rmna_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Adalese, ma daran olendar, adalese so sa soi garavdo, ka dičhol hem sa soi tajno, ka šunđol. ");
INSERT INTO rmna_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","So vaćerava tumenđe ani tomina, vaćeren ko svetlost; hem so pohari vaćerava tumenđe ko kan, vaćeren taro krovija sare te šunen. ");
INSERT INTO rmna_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ma daran okolendar kola šaj te mudaren samo o telo, a našti te mudaren hem i duša. Nego daran e Devlestar kova hem i duša hem o telo šaj te uništini ano pakao. ");
INSERT INTO rmna_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Na biknena pe li duj čiriklja zaki samo jekh najtikori kovanica? A palem, nijekh olendar na perela ki phuv, a adava te na mukel tumaro Dad kovai ano nebo. ");
INSERT INTO rmna_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","A tumenđei svako bal ko šero džendo. ");
INSERT INTO rmna_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Adalese, ma daran! E Devlese injen po dragocena negoli but čiriklja!” ");
INSERT INTO rmna_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Svako kova anglo manuša ka priznajini dai mlo, hem me anglo mlo Dad, kovai ano nebo, ka priznajinav dai ov mlo. ");
INSERT INTO rmna_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","A svako kova anglo manuša odreknini pe mandar, hem me anglo mlo Dad, kovai ano nebo, ka odrekninav man olestar.” ");
INSERT INTO rmna_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ma te mislinen da aljum te anav mir ki phuv. Na aljum te anav mir, nego mači. ");
INSERT INTO rmna_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Aljum te razdvojinav: ‘e čhave lesere dadestar e čhaja lakere dajatar e borja lakere sasujatar. ");
INSERT INTO rmna_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","E manušese ka oven neprijatelja lesere čherutne.’ ");
INSERT INTO rmna_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ko volini ple dade ili pla daja više nego man, nane dostojno te ovel mlo učeniko. Ko volini ple čhave ili pla čhaja više nego man, nane dostojno te ovel mlo učeniko. ");
INSERT INTO rmna_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ko na lela plo krsto hem na džala pala mande, nane dostojno te ovel mlo učeniko. ");
INSERT INTO rmna_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ko arakhi plo dživdipe, ka našali le, a ko našali plo dživdipe zbog mande, ka arakhi le.” ");
INSERT INTO rmna_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ko primini tumen, man primini, a ko primini man, primini e Devle kova bičhalđa man. ");
INSERT INTO rmna_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ko primini e proroko adalese soi proroko, proročko nagrada ka primini, hem ko primini e pravedniko adalese soi pravedno, pravedničko nagrada ka primini. ");
INSERT INTO rmna_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ko dela hem samo jekh šudri čaša panjeja jekhese akale najtikore manušendar te pijel adalese soi mlo učeniko, čače vaćerava tumenđe da naka našali pli nagrada.” ");
INSERT INTO rmna_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Kad o Isus završinđa adaleja so dinđa uputstvija ple dešu duje učenikonenđe, dželo adathar te sikaj hem te propovedini ano dizja e galilejakere. ");
INSERT INTO rmna_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","A kad o Jovan o Krstitelj ano phandlipe šunđa adalestar so o Hrist ćerela, bičhalđa ple učenikonen ");
INSERT INTO rmna_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","te pučen le: “Tu li injan adava kova valjani te avel ili te adžićera avere?” ");
INSERT INTO rmna_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","O Isus phenđa lenđe: “Džan hem vaćeren e Jovanese so šunena hem so dikhena: ");
INSERT INTO rmna_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","o korore dikhena, o bange phirena, o gubavci sasljovena, o kašuke šunena, o mule uštena, e čororenđe vaćeri pe o Šukar lafi. ");
INSERT INTO rmna_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Vaćeren lese hem akava: bahtaloi okova kova na našali pli vera ana mande.” ");
INSERT INTO rmna_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Kad e Jovanesere učenici džele, o Isus lelja te vaćeri e narodose e Jovanestar: “So ikliljen ki pustinja te dikhen? I trska sava phudela i barval? ");
INSERT INTO rmna_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ili so ikliljen te dikhen? E manuše ano barvale šeja urjavde? Na! Okola soi urjavde ano barvale šeja bešena ano e carosere palate. ");
INSERT INTO rmna_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ili so ikliljen te dikhen? E proroko? Oja, vaćerava tumenđe, ovi po više oto proroko! ");
INSERT INTO rmna_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ovi okova kolestar pisime ano Sveto lil: ‘Ače, bičhalava mle glasniko angla tute, kova ka pripremini će o drom.’ ");
INSERT INTO rmna_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Čače vaćerava tumenđe: maškar okolende kolai bijande e đuvljendar nijekh nane po baro e Jovanestar e Krstiteljestar, a o najtikoro manuš ano carstvo e nebosoro po baroi olestar. ");
INSERT INTO rmna_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Taro dive e Jovanesere kad lelja te propovedini i sa đi akana o carstvo e nebosoro trpini nasilje hem o nasilna manuša prelena le. ");
INSERT INTO rmna_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Adalese so sa o proroci hem o Zakoni prorokujinde e carstvostar đi o dive e Jovanesere. ");
INSERT INTO rmna_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Te mangljen te prihvatinen adava, ovi o Ilija kova valjanđa te avel. ");
INSERT INTO rmna_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kas isi kana, nek šunel! ");
INSERT INTO rmna_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","A kasar te uporedinav akala generacija? Sličnai e čhavorenđe kola bešena ko trg hem vaćerena jekh averese: ");
INSERT INTO rmna_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Bašalđam tumenđe veselo, a na čhelđen. Đilabđam tužno, a na runđen!’ ");
INSERT INTO rmna_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ađahar, kad alo o Jovan, ni halja ni pilja sar avera, a phenena: ‘O demoni ano leste!’ ");
INSERT INTO rmna_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","A kad aljum me, o Čhavo e manušesoro, hava hem pijava, a phenena: ‘Eče manuš halano hem mato, amal e carinikonengoro hem e avere grešnikonegoro!’ Ali i mudrost e Devlesiri dokažini pe ko ple delja.” ");
INSERT INTO rmna_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tegani o Isus lelja te ukorini e manušen taro dizja ano save ule but lesere čudesija so na pokajinde pe. ");
INSERT INTO rmna_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Jao tumenđe, manušalen taro Horazin! Jao tumenđe, manušalen tari Vitsaida! Te oven ine čudesija maškaro manuša taro Tir hem taro Sidon save ule maškara tumende, pana angleder ka urjen pe ine ano šeja oto kanaj hem ka čhoren pepeo upro pumare šere sar te mothoven da kajinena pe. ");
INSERT INTO rmna_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ali, vaćerava tumenđe: e manušenđe taro Tir hem taro Sidon ka ovel po lokhe ko dive oto baro sudo negoli tumenđe. ");
INSERT INTO rmna_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","A tumen, manušalen taro Kafarnaum, na li đi o nebo ka vazden tumen? Đi o than e mulengoro isi te peren. Adalese so, te oven ine čudesija maškaro manuša tari Sodoma save ule maškara tumende, ka pokajinen pe ine hem i Sodoma ka ačhol ine đi avdive. ");
INSERT INTO rmna_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ali, vaćerava tumenđe: e manušenđe tari Sodoma ka ovel po lokhe ko dive oto baro sudo negoli tumenđe.” ");
INSERT INTO rmna_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tegani o Isus phenđa: “Hvalinava tut, Dade, Gospode e nebosoro hem e phuvjakoro, so garavđan akava okolendar kola pes dikhena sar mudronen hem džanden, a mothovđan okolenđe kolai sar čhavore. ");
INSERT INTO rmna_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Oja, Dade, ćerđan adava adalese so ađahar mangljan. ");
INSERT INTO rmna_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Mlo Dad sa muklja maje ko vasta. Niko na džanel e Čhave, sem o Dad; hem niko na džanel e Dade, sem o Čhavo hem okola kolenđe o Čhavo mangela te mothoj le. ");
INSERT INTO rmna_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Aven kora mande sare kola injen umorna hem kola akharena pharipe, hem me ka ločharav tumen. ");
INSERT INTO rmna_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Len o jaram mlo upra tumende hem sikljoven mandar, adalese so injum krotko hem ponizno ano vilo. Ađahar ka arakhen odmor tumare dušenđe. ");
INSERT INTO rmna_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Adalese soi mlo jaram lokho hem mlo pharipe nane pharo.” ");
INSERT INTO rmna_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ko adava vreme o Isus ko jekh savato nakhino maškaro njive, a lesere učenici bokhalile hem lelje te čeden e đivesoro klaso hem te han le. ");
INSERT INTO rmna_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Kad dikhle adava o fariseja, phende lese: “Dikh, te učenici ćerena so palo Zakoni na tromal pe ko savato.” ");
INSERT INTO rmna_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","A o Isus phenđa lenđe: “Na čitinđen li ano Sveto lil so ćerđa o David kad bokhalile ov hem okola so inele oleja? ");
INSERT INTO rmna_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Đerdinđa ano čher e Devlesoro, hem ov hem okola so inele oleja hale o posvetime maro savo na inele muklo te han on, nego samo o sveštenici. ");
INSERT INTO rmna_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ili, na čitinđen li ano Zakoni so ko savato o sveštenici kandena ano Hram hem ađahar phagena o Zakoni, a palem, nane kriva? ");
INSERT INTO rmna_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","A me phenava tumenđe: Akatei neko po baro oto Hram! ");
INSERT INTO rmna_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Te džanen ine so značini: ‘Po šukari maje te dikhav da injen milosrdna, nego te anen maje žrtven’, naka osudinen ine akalen kola nane kriva. ");
INSERT INTO rmna_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Adalese so me, o Čhavo e manušesoro, injum gospodari e savatesoro.” ");
INSERT INTO rmna_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","I adathar o Isus dželo ki lengiri sinagoga. ");
INSERT INTO rmna_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","A adari inele jekh manuš kasoro vas inele šuko. O fariseja rodinde zako so te tužinen e Isuse, i pučle le: “Tromal pe li ko savato te sasljari pe?” ");
INSERT INTO rmna_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ov phenđa lenđe: “Ko tumendar naka dolel hem te ikali ple jekhe bakre te pelo ani rupa ko savato? ");
INSERT INTO rmna_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","A kobor o manuš po but vredini e bakrestar! Adalese, ko savato tromal pe te ćerel pe šukaripe.” ");
INSERT INTO rmna_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tegani phenđa okole manušese: “Pružin to vas!” Ov ispružinđa plo vas hem lesoro vas ulo sasto sar soi o dujto. ");
INSERT INTO rmna_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","A o fariseja iklile hem lelje te dogovorinen pe sar te mudaren e Isuse. ");
INSERT INTO rmna_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","A kad o Isus dodžanđa adava, cidinđa pe adathar. Palo leste džele but džene hem ov sasljarđa sa e nambormen maškar olende ");
INSERT INTO rmna_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","hem upozorinđa len te na vaćeren averenđe koi ov. ");
INSERT INTO rmna_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Adaleja pherdilo adava so inele vaćerdo prekalo proroko Isaija: ");
INSERT INTO rmna_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ače o sluga mlo, kole birinđum. Mlo volime, ano kolestei mli duša bahtali. Ka čhivav upro leste mle Duho hem ov ka proglasini i pravda e nacijenđe. ");
INSERT INTO rmna_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Naka ćerel kavga ni ka vičini, naka šunđol lesoro glaso ko droma. ");
INSERT INTO rmna_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ni i gazime trska naka phagel, ni ka mudari i jag e memeljakiri savi samo so nane te mudarđol sa đikote na ćerela i pravda te pobedini. ");
INSERT INTO rmna_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Olese ano anav ka ovel i nada e nacijengiri!” ");
INSERT INTO rmna_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tegani ande anglo Isus jekhe manuše opsednutime demoneja, kova našti ine te dikhel hem te vaćeri. O Isus sasljarđa le hem o manuš lelja te vaćeri hem te dikhel. ");
INSERT INTO rmna_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","I sare kola dikhle adava inele but zadivime hem pučle pe: “Te nane akava o Čhavo e Davidesoro?” ");
INSERT INTO rmna_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kad šunde adava o fariseja, phende: “Akava ispudini e demonen e Veelzevulesere zoralipnaja, kovai e demonengoro šerutno.” ");
INSERT INTO rmna_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ali o Isus džanđa lengere mislija, i phenđa lenđe: “Svako carstvo savoi ana peste podelime, ka ačhol pusto. I diz ili o čher savoi ana peste podelime ka perel. ");
INSERT INTO rmna_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Te o Sotoni e Sotone ispudini, ovi ana peste podelime. Sar onda lesoro carstvo ka ačhol? ");
INSERT INTO rmna_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","A te me e Veelzevulesere zoralipnaja ispudinava e demonen, kasere zoralipnaja tumare učenici ispudinena len? Adalese on ka dokažinen tumenđe da na injen u pravu. ");
INSERT INTO rmna_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ali te me e Devlesere Duhoja ispudinava e demonen, onda o carstvo e Devlesoro alo maškara tumende. ");
INSERT INTO rmna_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ili, šaj li neko te đerdini ko čher e zorale manušesoro hem te čorel le, a angleder adalestar te na phandel le? Tegani ka šaj te čorel sa oto čher. ");
INSERT INTO rmna_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ko nane mancar, ovi protiv mande. I ko na čedela mancar, ov čhorela. ");
INSERT INTO rmna_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Adalese vaćerava tumenđe: e manušenđe ka šaj te ovel oprostime svako greh hem hula, ali naka ovel lenđe oprostime i hula upro Sveto Duho. ");
INSERT INTO rmna_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","I te vaćerđa neko lafi protiv o Čhavo e manušesoro, ka šaj te ovel lese oprostime. Ali te vaćerđa protiv o Sveto Duho, naka ovel lese oprostime ni ko akava sveto ni ko okova savo avela. ");
INSERT INTO rmna_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Barjaren šukar kaš, i lesoro plod ka ovel šukar, ili barjaren bišukar kaš, i lesoro plod ka ovel bišukar, adalese so o kaš pendžari pe palo lesoro plod. ");
INSERT INTO rmna_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","E sapengere čhavalen! Sar šaj tumen kola injen bišukar te vaćeren nešto šukar? Adalese so o muj vaćeri okova sojai o vilo pherdo. ");
INSERT INTO rmna_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","E šukare manušestar ikljola šukaripe e šukaripnastar savoi ano leste, a e bišukare manušestar ikljola bišukaripe e bišukaripnastar savoi ano leste. ");
INSERT INTO rmna_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ali phenava tumenđe: o manuša ka odgovorinen ko dive oto baro sudo zako svako čučo lafi savo vaćerena. ");
INSERT INTO rmna_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Adalese so, palo te lafija ka ove opravdime ili osudime.” ");
INSERT INTO rmna_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tegani nesave učitelja e Zakonestar hem nesave fariseja phende e Isusese: “Učitelju, mangaja te dikha nesavo znako tutar sar dokaz da injan e Devlestar.” ");
INSERT INTO rmna_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","A o Isus phenđa lenđe: “I bišukar hem i neverno generacija rodela znako, ali nisavo znako naka del pe laće sem adava so inele e prorokose e Jonase. ");
INSERT INTO rmna_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Adalese so, sar so ‘o Jona trin dive hem trin raća inele ano vođi e bare maćhesoro’, ađahar hem me, o Čhavo e manušesoro, trin dive hem trin raća ka ovav ani phuv. ");
INSERT INTO rmna_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ko dive oto baro sudo, o manuša kola živinde ani purani diz Niniva ka ušten protiv akaja generacija hem ka osudinen la, adalese so on pokajinde pe kad o Jona propovedinđa, a akatei tumencar neko po baro e Jonastar, a tumen pana na pokajinđen tumen! ");
INSERT INTO rmna_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ko dive oto baro sudo, i carica koja angleder vladinđa ki južno phuv ka uštel protiv akaja generacija hem ka osudini la, adalese so tari durutni phuv ali te šunel e Solomonesiri mudrost, a akatei tumencar neko po baro e Solomonestar, a tumen na mangena te šunen!” ");
INSERT INTO rmna_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Kad o bišukar duho ikljola taro manuš, džala ko šuke thana rodindoj kote šaj te odmorini. Kad na arakhi le, ");
INSERT INTO rmna_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","vaćeri: ‘Ka irinav man ko čher kotar ikliljum.’ I irinđa pe hem arakhlja o čher čučo, šulavdo hem namestime. ");
INSERT INTO rmna_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tegani džala hem lela peja efta avere duhen, po bišukaren pestar, i đerdinena ano adava manuš hem ačhovena adari. I ko kraj adale manušese ovela po bišukar nego angleder. Ađahar ka ovel hem akala bišukara generacijaja.” ");
INSERT INTO rmna_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Sar o Isus pana vaćeri ine e manušenđe, ale lesiri daj hem lesere phralja hem terdine avri mangindoj te vaćeren oleja. ");
INSERT INTO rmna_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","I neko phenđa lese: “Eče, ti daj hem te phralja terđovena avri. Mangena te vaćeren tuja.” ");
INSERT INTO rmna_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","A o Isus phenđa lese: “Koi mli daj hem koi mle phralja?” ");
INSERT INTO rmna_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Tegani vasteja mothovđa nakoro ple učenici hem phenđa: “Ače mli daj hem mle phralja. ");
INSERT INTO rmna_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Adalese so, svako kova ćerela i volja mle Dadesiri kovai ano nebo, ovi mlo phral, hem mli phen, hem mli daj.” ");
INSERT INTO rmna_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ko adava dive o Isus iklilo taro čher hem dželo te bešel uzalo jezero te sikaj. ");
INSERT INTO rmna_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Sa edobor džene čedinde pe uzalo leste, i adalese đerdinđa ko čamco hem beštino, a o manuša terđona ine ki phuv uzalo jezero. ");
INSERT INTO rmna_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","I but so vaćerđa lenđe ano priče, sar akaja: “Šunen! Iklilo o sejači te sejini. ");
INSERT INTO rmna_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","I sar frdela ine o seme, nesave zrnja pele ko drom, i o čiriklja ale hem sa hale len. ");
INSERT INTO rmna_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","A nesave pele ko than kote inele hari phuv upro bara, i odmah lelje te ikljon, adalese so na inele ani hor phuv. ");
INSERT INTO rmna_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ali kad iklilo o zoralo kham, thabile hem šućile, adalese so na ine len baro koreno. ");
INSERT INTO rmna_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","A nesave pele maškaro kare, i o kare barile hem tasavde len. ");
INSERT INTO rmna_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","A nesave pele ki šukar phuv hem ande bijandipe – šel puti, šovardeš puti ili trijanda puti više adalestar so inele sejime. ");
INSERT INTO rmna_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kas isi kana, nek šunel!” ");
INSERT INTO rmna_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","E Isusesere učenici ale koro leste hem pučle le: “Sose vaćereja e manušenđe ano priče?” ");
INSERT INTO rmna_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","A ov phenđa lenđe: “Adalese soi tumenđe dindo te džanen o tajne oto carstvo e nebosoro, a olenđe nane dindo. ");
INSERT INTO rmna_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Adalese so, đijekhe kas isi džandipe, ka del pe lese pana hem ka ovel le but, a okole kas nane, ka lel pe lestar hem adava so isi le. ");
INSERT INTO rmna_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Adalese vaćerava lenđe ano priče, adalese so anglo jaćha na dikhena hem anglo kana na šunena ni na haljovena. ");
INSERT INTO rmna_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ađahar upro lende pherđola o proroštvo e Isaijasoro: ‘Ka šunen hem ka šunen, ali naka haljoven; ka dikhen hem ka dikhen, ali naka pendžaren. ");
INSERT INTO rmna_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Adalese so akale manušengoro vilo ulo pharo, phareste šunena kanencar hem phandle pumare jaćha, te na dikhen jaćhencar hem te na šunen kanencar, a vileja te na haljoven. Adalese našti te irinen pe kora mande te sasljarav len.’ ");
INSERT INTO rmna_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ali blago tumare jaćhenđe so dikhena hem blago tumare kanenđe so šunena. ");
INSERT INTO rmna_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Čače phenava tumenđe: But proroci hem pravednici edobor mangle te dikhen akava so tumen dikhena, ali na dikhle; hem mangle te šunen okova so tumen šunena, ali na šunde.” ");
INSERT INTO rmna_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Šunen akana sostar vaćeri pe ani priča oto sejači: ");
INSERT INTO rmna_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Svakonese kova šunela o lafi oto carstvo e nebosoro, a na haljola le, avela o Bišukar hem čorela lestar okova soi lese sejime ano vilo. Adavai o than ko drom ko savoi sejime o zrnja. ");
INSERT INTO rmna_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","A o than e barencar ko savoi sejime o zrnja, adavai okova kova šunela o lafi hem odmah lela le radosno. ");
INSERT INTO rmna_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ali, adalese so nane le baro koreno ana peste, na trajini but. Kad avela i nevolja ili o progonstvo zbog o lafi, ov odmah otperela oti vera. ");
INSERT INTO rmna_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","A o than maškaro kare ko savoi sejime o zrnja, adavai okova kova šunela o lafi, ali o brige akale dživdipnasere hem o zavodljivost e barvalipnasoro tasavena o lafi, i našti anel bijandipe. ");
INSERT INTO rmna_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","A i šukar phuv ki savi sejime o zrnja, adavai okova kova šunela hem haljovela o lafi. Ov čače anela bijandipe – šel puti, šovardeš puti ili trijanda puti više adalestar so inele sejime.” ");
INSERT INTO rmna_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","O Isus dinđa len hem aver priča: “O carstvo e nebosoroi slično sar kad o manuš pese ki njiva sejinđa o šukar seme. ");
INSERT INTO rmna_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ali, sar sare sovena ine, alo lesoro neprijatelj, sejinđa kukolj maškaro điv hem dželo. ");
INSERT INTO rmna_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","A kad barilo o điv hem kad anđa bijandipe, dikhlilo hem o kukolj. ");
INSERT INTO rmna_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","O sluge ale koro domaćini hem pučle le: ‘Gospodarona, ini tu sejinđan šukar seme tuće ki njiva? Kotar onda adava kukolj?’ ");
INSERT INTO rmna_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","A ov phenđa lenđe: ‘O neprijatelj adava ćerđa.’ Tegani o sluge pučle le: ‘Mangeja li te dža te ikala o kukolj?’ ");
INSERT INTO rmna_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","A ov phenđa: ‘Na, adalese so tumen ko ikaliba o kukolj šaj te ikalen hem o điv. ");
INSERT INTO rmna_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Muken soduj te barjon đi ki žetva. I kad ka avel o vreme e čedibnasoro, ka phenav okolenđe kola čedena: Ikalen najangle o kukolj hem phanden le ko kupe te tharel pe, a o điv čeden hem čhiven le maje ki šupa.’ ” ");
INSERT INTO rmna_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","O Isus dinđa len hem aver priča: “O carstvo e nebosoroi slično e zrnose oti gorušica save o manuš lelja hem sejinđa pese ki njiva. ");
INSERT INTO rmna_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ovi čače najtikoro oto sa semenja, ali kad barjola ovela po baro oto sa o biljke ki bašta, ovela kaš, i o čiriklja avena hem ćerena gnezdija upro lesere granke.” ");
INSERT INTO rmna_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Phenđa lenđe hem aver priča: “O carstvo e nebosoroi slično e kvascose save i đuvli lelja hem čhivđa ano but baro čaro vareja, i ov ćerđa sa o humer te uštel.” ");
INSERT INTO rmna_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Sa adava o Isus vaćerđa e manušenđe ano priče. Na vaćerđa lenđe ništa bizo priče. ");
INSERT INTO rmna_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ađahar pherdilo okova soi vaćerdo prekalo proroko: “Mlo muj ka phravav ano priče, ka vaćerav okova soi garavdo pana taro ćeriba e svetosoro.” ");
INSERT INTO rmna_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Tegani o Isus bičhalđa e manušen čhere, i đerdinđa ko čher. Lesere učenici ale koro leste hem phende: “Vaćer amenđe sostar vaćeri pe ani priča oto kukolj ki njiva.” ");
INSERT INTO rmna_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ov phenđa lenđe: “Okova kova sejinđa o šukar semei o Čhavo e manušesoro, ");
INSERT INTO rmna_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","a i njivai o sveto. O šukar semei o čhave e carstvosere, a o kukolj o čhave e Bišukaresere. ");
INSERT INTO rmna_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","O neprijatelj kova sejinđa o kukolj – adavai o beng. I žetva – adavai o kraj e svetosoro, a okola kola čedena – adalai o anđelja. ");
INSERT INTO rmna_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Sar so o kukolj ikali pe hem tharela pe, ađahar ka ovel hem ko kraj e svetosoro. ");
INSERT INTO rmna_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Me, o Čhavo e manušesoro, ka bičhalav mle anđelen te ikalen taro mlo carstvo sarijen kola ćerena averen te grešinen hem kola ćerena bišukaripe ");
INSERT INTO rmna_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","hem ka frden len ani jagali peć, kote ka ovel baro rojba hem krciba e dandengoro tari dukh. ");
INSERT INTO rmna_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tegani o pravednici sar o kham ka sijajinen ano carstvo pumare Dadesoro. Kas isi kana, nek šunel!” ");
INSERT INTO rmna_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“O carstvo e nebosoroi sar o blago garavdo ki njiva. Kad o manuš arakhi le, palem garaj le hem radosno džala te biknel sa so isi le hem činela adaja njiva.” ");
INSERT INTO rmna_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Palem, o carstvo e nebosoroi sar kad o trgovco rodela šuže biserja. ");
INSERT INTO rmna_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kad arakhi jekh dragoceno biseri, džala hem biknela sa so isi le hem činela le.” ");
INSERT INTO rmna_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Palem, o carstvo e nebosoroi sar i mreža frdimi ano jezero ani savi dolinde pe maćhe oti svako vrsta. ");
INSERT INTO rmna_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kad i mreža pherđola, o manuša ikalena la ki phuv. Tegani bešena hem e šukare maćhen čhivena ano čare, a e bišukaren frdena. ");
INSERT INTO rmna_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ađahar ka ovel hem ko kraj e svetosoro. Ka aven o anđelja hem ka ciden e bišukare manušen e pravednikonendar ");
INSERT INTO rmna_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","hem ka frden len ani jagali peć, kote ka ovel baro rojba hem krciba e dandengoro tari dukh. ");
INSERT INTO rmna_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Haliljen li sa adava?” On phende: “Oja.” ");
INSERT INTO rmna_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","A ov phenđa lenđe: “Adalese svako učitelj e Zakonestar kovai sikavdo oto carstvo e nebosoro – ovi sar o domaćini kova pestar ikali hem o nevo hem o purano blago.” ");
INSERT INTO rmna_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Kad o Isus vaćerđa sa adala priče, dželo adathar ");
INSERT INTO rmna_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","hem alo ko than kaj barilo. Adari ki sinagoga sikavđa e manušen, a on divinde pe hem pučle: “Kotar lese adaja mudrost hem zoralipe te ćerel čudesija? ");
INSERT INTO rmna_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nane li akava e kaštarutnesoro čhavo? Nane li lesiri daj i Marija, a lesere phralja o Jakov, o Josif, o Simon hem o Juda? ");
INSERT INTO rmna_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Hem nane li sa lesere phenja akate amencar? Kotar lese onda sa adava?” ");
INSERT INTO rmna_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","I na mangle te prihvatinen le. Tegani o Isus phenđa lenđe: “E prorokose dela pe čast ano sa o thana, sem lese ano than kaj barilo hem lese ano čher.” ");
INSERT INTO rmna_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","I na ćerđa but čudesija adari adalese so e manušen na ine vera. ");
INSERT INTO rmna_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ko adava vreme o Irod, o vladari e Galilejakoro, šunđa e Isusese ");
INSERT INTO rmna_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","hem phenđa ple slugenđe: “Adavai o Jovan o Krstitelj! Uštino taro mule hem adalese šaj te ćerel adala čudesija!” ");
INSERT INTO rmna_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","A o Irod phenđa adava adalese so angleder dolinđa e Jovane, phandlja le hem frdinđa le ano phandlipe, adalese so o Jovan phenela lese ine da na tromal te lel romnjaće e Irodijada, ple phralesere e Filipesere romnja. ");
INSERT INTO rmna_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Manglja te mudari e Jovane, ali darandilo e narodostar, adalese so dikhle e Jovane sar proroko. ");
INSERT INTO rmna_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ali kad inele e Irodesoro bijando dive, e Irodijadakiri čhaj čhelđa anglo gostija. Adava e Irodese but inele šukar. ");
INSERT INTO rmna_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Adalese halja sovli te del la sa so ka mangel. ");
INSERT INTO rmna_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","A i daj pherđa la te vaćeri: “De man akate ko čaro o šero e Jovanesoro e Krstiteljesoro.” ");
INSERT INTO rmna_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","E carose pelo žal, ali adalese so halja sovli anglo gostija naredinđa te ćeren pali lakiri volja, ");
INSERT INTO rmna_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","i bičhalđa ple manušen te čhinen o šero e Jovanesoro ano phandlipe. ");
INSERT INTO rmna_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","I ande lesoro šero ko čaro hem dinde le e čhajaće, a oj legarđa le pla dajaće. ");
INSERT INTO rmna_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","I ale e Jovanesere učenici, lelje lesoro telo hem parunde le, i džele te vaćeren e Isusese so ulo. ");
INSERT INTO rmna_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Kad šunđa o Isus adava, dželo adathar čamcoja ko jekh čučo than, te ovel korkoro. Ali o manuša šunde adava hem taro dizja phirindoj džele palo leste. ");
INSERT INTO rmna_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Kad o Isus iklilo taro čamco, dikhlja bute manušen, pelo lese žal olenđe hem sasljarđa e nambormen maškar olende. ");
INSERT INTO rmna_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Kad lelja te perel i rat, nakhle đi leste lesere učenici hem phende: “Ko akava than ništa nane, a već perela i rat. Te muke ine e manušen te šaj džan ko gava te činenfse hajbnase.” ");
INSERT INTO rmna_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","A o Isus phenđa lenđe: “Na valjani te džan. Den len tumen nešto hajbnase.” ");
INSERT INTO rmna_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","On phende lese: “Akate isi amen samo pandž mare hem duj maćhe.” ");
INSERT INTO rmna_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","A ov phenđa: “Anen maje adava akari.” ");
INSERT INTO rmna_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","I naredinđa o manuša te bešen ki čar. Tegani lelja e pandže maren hem e duje maćhen, dikhlja nakoro nebo hem zahvalinđa e Devlese zako hajba. Phaglja o mare hem dinđa len ko ple učenici, a o učenici dinde len e manušenđe. ");
INSERT INTO rmna_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","I sare hale đikote na čalile. Palo adava, dešu duj pherde korpe čedinde pe okolestar so ačhilo oto hajba. ");
INSERT INTO rmna_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","A okola so hale inele đi ko pandž hiljade murša, bizo te dženen pe o đuvlja hem o čhavore. ");
INSERT INTO rmna_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","I odmah palo adava o Isus terinđa e učenikonen te đerdinen ko čamco hem angleder oleste te džan ki aver strana oto jezero, đikote ov bičhali čhere e manušen. ");
INSERT INTO rmna_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kad bičhalđa čhere e manušen, uštino ki gora, korkoro, te molini pe. Kad peli i rat, ov pana inele adari, korkoro. ");
INSERT INTO rmna_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","A o čamco već inele dur e phuvjatar, hem lelje te khuven le o talasija, adalese so nakoro leste phudinđa i barval. ");
INSERT INTO rmna_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Đi sar maškaro trin hem šov o sati prekali rat, o Isus alo nakoro učenici phirindoj upro jezero. ");
INSERT INTO rmna_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Kad o učenici dikhle le sar phirela upro jezero, but darandile. Phende: “Adavai duho!” Hem oti dar lelje te vičinen. ");
INSERT INTO rmna_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ali o Isus odmah phenđa lenđe: “Oven hrabra! Me injum. Ma daran!” ");
INSERT INTO rmna_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ko adava, o Petar phenđa lese: “Gospode, te injan tu, naredin maje te avav kora tute upro pani!” ");
INSERT INTO rmna_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","I o Isus phenđa lese: “Ava!” O Petar iklilo taro čamco hem lelja te džal nakoro Isus phirindoj upro pani. ");
INSERT INTO rmna_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ali kad dikhlja kobor zorali i barval, darandilo hem lelja te properel ano pani, i vičinđa: “Gospode, spasin man!” ");
INSERT INTO rmna_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","O Isus odmah pružinđa plo vas hem dolinđa le, i phenđa lese: “Tikora verakere manušeja, sose sumnjinđan?” ");
INSERT INTO rmna_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","I kad đerdinde ko čamco, i barval ačhili. ");
INSERT INTO rmna_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","A o učenici ano čamco pele ko kočija anglo Isus hem phende: “Tu čače injan o Čhavo e Devlesoro!” ");
INSERT INTO rmna_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","I o Isus hem lesere učenici nakhle ki aver strana oto jezero, ki phuv e Genisaretakiri. ");
INSERT INTO rmna_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","A kad o manuša taro adava than pendžarde e Isuse, sarijenđe taro sa adava krajo vaćerde so alo, i ande koro leste sa e nambormen. ");
INSERT INTO rmna_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Molinena le ine te mukel len samo te dolen pe upro lesere fostanesoro krajo. I ule saste sare kola dolinde pe. ");
INSERT INTO rmna_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tegani nesave fariseja hem učitelja e Zakonestar taro Jerusalim ale koro Isus hem pučle le: ");
INSERT INTO rmna_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Sose te učenici phagena o adetija amare dadengere? Na thovena pumare vasta angleder o hajba!” ");
INSERT INTO rmna_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","A o Isus pučlja len: “A sose tumen phagena e Devlesere naredbe zbog tumare adetija? ");
INSERT INTO rmna_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Adalese so o Devel phenđa: ‘Poštujin te dade hem te daja’ hem: ‘Ko dela armanja pe dade ili pe daja, nek ovel kaznime meribnaja.’ ");
INSERT INTO rmna_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","A tumen phenena: ‘Ko vaćeri e dadese ili e dajaće: Sa soja šaj ine te pomožinav tut, već haljum sovli da adava ka dav sar daro e Devlese, ");
INSERT INTO rmna_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","adava manuš na valjani te mothoj poštujiba ple dadese.’ Ađahar, zbog tumare adetija, ruminena e Devlesoro lafi. ");
INSERT INTO rmna_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Dujemujengere manušalen! Šukar o Isaija prorokujinđa tumendar: ");
INSERT INTO rmna_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Akala manuša poštujinena man samo mujeja, a lengoroi vilo dur mandar. ");
INSERT INTO rmna_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Džabe poštujinena man, adalese so sikavena o manušikane naredbe sar dai mlo sikaviba.’ ” ");
INSERT INTO rmna_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","O Isus vičinđa kora peste e narodo hem phenđa lenđe: “Šunen hem haljoven: ");
INSERT INTO rmna_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Na meljari e manuše okova so đerdini lese ko muj, nego okova so ikljola taro lesoro muj – adava meljari e manuše.” ");
INSERT INTO rmna_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tegani nakhle nakoro leste o učenici hem pučle le: “Džane li so o fariseja uvredinde pe kad šunde so phenđan?” ");
INSERT INTO rmna_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","A ov phenđa lenđe: “Svako biljka sava na sadinđa mlo Dad kovai ano nebo, ka ovel ikaldi taro koreno. ");
INSERT INTO rmna_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Muken tumen olendar! Oni korore hem vođe e kororenđe. A te o kororo legari e korore, soduj ka peren ki rupa.” ");
INSERT INTO rmna_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","O Petar phenđa lese: “Vaćer amenđe so mangljan te vaćere adala pričaja.” ");
INSERT INTO rmna_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","A o Isus pučlja len: “Ni tumen li pana na haljovena? ");
INSERT INTO rmna_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Na dikhena li da sa so đerdini ko muj, džala ko vođi hem frdela pe avri taro telo? ");
INSERT INTO rmna_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ali, okova so ikljola taro muj, avela taro vilo, hem adava meljari e manuše. ");
INSERT INTO rmna_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Adalese so taro vilo avena o bišukar mislija, o mudariba, o preljube, o blud, o čoriba, o hovavno svedočiba hem o hule. ");
INSERT INTO rmna_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Adava meljari e manuše, a o hajba bithovde vastencar na meljari e manuše.” ");
INSERT INTO rmna_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","I tegani o Isus dželo tari Galileja hem cidinđa pe ko krajo e tiresoro hem e sidonesoro. ");
INSERT INTO rmna_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","I dikh, nesavi đuvli, Hanaanejka taro adava krajo, ali koro leste hem vičini ine: “Smilujin tut maje, Gospode, Čhaveja Davidesereja! Mli čhaj but patini, adalese soi opsednutime demoneja.” ");
INSERT INTO rmna_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ali o Isus na phenđa laće nijekh lafi. I lesere učenici nakhle đi leste hem molinde le: “Vaćer laće te džal, adalese so džala pala amende hem vičini!” ");
INSERT INTO rmna_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","A ov phenđa: “Bičhaldo injum te pomožinav samo e Izraelesere našalde bakrenđe.” ");
INSERT INTO rmna_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ali oj nakhini đi o Isus, peli ko kočija anglo leste hem phenđa: “Gospode, pomožin maje!” ");
INSERT INTO rmna_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","O Isus phenđa laće: “Nane šukar te lel pe o maro e čhavorendar hem te frdel pe e đuklorenđe.” ");
INSERT INTO rmna_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","A oj phenđa: “Oja, Gospode, adalese so hem o đuklore hana o troške save perena taro astali lengere gospodarengoro.” ");
INSERT INTO rmna_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Tegani o Isus phenđa laće: “Bari ti vera, đuvlije! Nek ovel sar so mangeja.” I lakiri čhaj odmah saslili. ");
INSERT INTO rmna_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","O Isus dželo adathar hem alo đi E galilejakoro jezero. Tegani uklinđa ki gora hem beštino adari te sikaj. ");
INSERT INTO rmna_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","I but manuša ale koro leste hem pumencar ande e bangen, e kororen, e sakatimen, okolen so našti ine te vaćeren hem bute averen, i siđarena ine te čhiven len anglo lesere pre, a ov sasljarđa len. ");
INSERT INTO rmna_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","I o manuša inele zadivime so dikhle so okola so našti ine te vaćeren da vaćerena, o sakatime sasljovena, o bange phirena hem o korore dikhena, i lelje te slavinen e Izraelesere Devle. ");
INSERT INTO rmna_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","A o Isus vičinđa kora peste ple učenikonen hem phenđa lenđe: “Pharo maje akale manušenđe. Trin divei mancar, a nane len so te han. Nako te bičhalav len čhere bokhalen, te na peren odrumal.” ");
INSERT INTO rmna_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","O učenici pučle le: “Kaj te arakha dovoljno maro ko akava čučo than te da hajbnase sa edobor manušen?” ");
INSERT INTO rmna_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","I o Isus pučlja len: “Kobor mare isi tumen?” On phende: “Efta mare hem hari maćhe.” ");
INSERT INTO rmna_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","I o Isus naredinđa o narodo te bešel ki phuv. ");
INSERT INTO rmna_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Tegani lelja o efta mare hem e maćhen, zahvalinđa e Devlese, phaglja len hem dinđa len ko učenici, a o učenici dinde len e manušenđe. ");
INSERT INTO rmna_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Sare hale hem čalile, hem efta pherde bare korpe čedinde pe okolestar so ačhilo oto hajba. ");
INSERT INTO rmna_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","A okola so hale inele štar hiljade murša, bizo te dženen pe o đuvlja hem o čhavore. ");
INSERT INTO rmna_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","I o Isus bičhalđa e manušen čhere, đerdinđa ko čamco hem dželo ko krajo e magadanesoro. ");
INSERT INTO rmna_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","I ale koro Isus nesave fariseja hem sadukeja hem iskušinde le ađahar so rodinde lestar znako taro nebo. ");
INSERT INTO rmna_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","A ov phenđa lenđe: “Kad perela i rat, džanen te vaćeren: ‘Ka ovel šužo vreme, adalese soi o nebo lolo.’ ");
INSERT INTO rmna_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","A ko sabale, vaćerena: ‘Avdive naka ovel šužo vreme, adalese soi o nebo lolo hem oblačno.’ O izgled e nebosoro džanen te pendžaren, a na džanen te pendžaren o znakija e divengere ano save živinena! ");
INSERT INTO rmna_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","I bišukar hem i neverno generacija rodela znako, ali nisavo znako naka del pe laće sem adava so inele e prorokose e Jonase.” I tegani ačhavđa len hem dželo. ");
INSERT INTO rmna_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","O učenici nakhine ki aver strana oto jezero, ali bisterde te legaren pumencar maro. ");
INSERT INTO rmna_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","I o Isus phenđa lenđe: “Arakhen tumen taro kvasco e farisejengoro hem e sadukejengoro!” ");
INSERT INTO rmna_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","A o učenici lelje te vaćeren maškara pumende: “Adava phenđa adalese so na anđam amencar maro.” ");
INSERT INTO rmna_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","O Isus džanđa adava hem phenđa lenđe: “Tikora verakere manušalen, sose vaćerena maškara tumende adalestar so nane tumen maro? ");
INSERT INTO rmna_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Pana li na haljovena? Na setinena tumen li oto okola pandž mare zako pandž hiljade manuša hem kobor korpe čedinđen adalestar so ačhilo? ");
INSERT INTO rmna_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","A okola efta mare zako štar hiljade manuša hem kobor bare korpe čedinđen? ");
INSERT INTO rmna_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Sar na haljovena da na vaćerđum tumenđe e marestar, nego te arakhen tumen taro kvasco e farisejengoro hem e sadukejengoro?” ");
INSERT INTO rmna_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tegani halile da o Isus na vaćerđa lenđe te arakhen pe taro kvasco zako maro, nego taro sikaviba e farisejengoro hem e sadukejengoro. ");
INSERT INTO rmna_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Kad o Isus alo ko krajo e Filipesere Cezarejakoro, pučlja ple učenikonen: “So phenena o manuša, ko injum me, o Čhavo e manušesoro?” ");
INSERT INTO rmna_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","On phende lese: “Nesave manuša phenena da tu injan o Jovan o Krstitelj, a avera phenena da tu injan o Ilija, a nesave avera da tu injan o Jeremija ili jekh oto avera proroci.” ");
INSERT INTO rmna_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Tegani o Isus pučlja len: “A so tumen phenena, ko injum me?” ");
INSERT INTO rmna_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","O Simon o Petar phenđa: “Tu injan o Hrist, o Čhavo e dživde Devlesoro!” ");
INSERT INTO rmna_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","O Isus phenđa lese: “Bahtalo injan Simone, čhaveja e Jonasereja, adalese so adava na mothovđa će o manuš, nego mlo Dad, kovai ano nebo. ");
INSERT INTO rmna_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","A me phenava će: Tu injan o Petar, hem ki adaja stena ka vazdav mli Khanđiri, hem o udara e Hadesere naka šaj prelen la. ");
INSERT INTO rmna_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ka dav tut o ključija e nebosere carstvostar, i sa so phandeja ki phuv, ka ovel phandlo ko nebo, hem sa so ka phrave ki phuv, ka ovel phravdo ko nebo.” ");
INSERT INTO rmna_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Tegani zorale naredinđa e učenikonenđe te na vaćeren nikase dai ov o Hrist. ");
INSERT INTO rmna_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Otegani o Isus lelja te mothoj e učenikonenđe so valjani te džal ko Jerusalim hem but te patini e starešinendar, e šerutne sveštenikonendar hem e učiteljendar e Zakonestar, hem te ovel mudardo hem o trito dive te uštel taro mule. ");
INSERT INTO rmna_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","I o Petar cidinđa le ki strana hem lelja te ukorini le vaćerindoj: “Te na del o Devel, Gospode! Nikad naka ovel tuće adava!” ");
INSERT INTO rmna_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","A o Isus irinđa pe nakoro leste hem phenđa lese: “Dža mandar, Sotone! Terđoveja maje ko drom, adalese so na razmislineja devlikane, nego manušikane.” ");
INSERT INTO rmna_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Tegani o Isus phenđa ple učenikonenđe: “Ko mangela te džal pala mande, mora te ačhaj pe ple dživdipnastar hem te lel plo krsto hem te phirel pala mande. ");
INSERT INTO rmna_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Adalese so, ko mangela te spasini plo dživdipe, ka našali le, a ko našali plo dživdipe zbog mande, ka arakhi le. ");
INSERT INTO rmna_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","So vredini e manušese hem sa i phuv te ovel olesiri, a našali plo dživdipe? So o manuš šaj te del sar zamena zako plo dživdipe? ");
INSERT INTO rmna_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Adalese so me, o Čhavo e manušesoro, sigate ka avav ani slava mle Dadesiri, mle anđelencar hem tegani ka irinav sarijenđe palo lengere delja. ");
INSERT INTO rmna_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Čače vaćerava tumenđe, isi nesave akate maškara tumende kola naka meren đikote na dikhena e Čhave e manušesere sar avela ple carstvoja.” ");
INSERT INTO rmna_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Palo šov dive, o Isus lelja peja e Petre, e Jakove hem lesere phrale e Jovane hem uklinđa olencar ki jekh uči gora, kote inele korkore. ");
INSERT INTO rmna_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Adari o Isus ulo averčhane anglo lende: lesoro muj sijajinđa sar o kham, a lesere šeja ule parne sar o svetlost. ");
INSERT INTO rmna_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","I otojekhvar iklile anglo lende o Mojsije hem o Ilija hem lelje te vaćeren e Isuseja. ");
INSERT INTO rmna_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","A o Petar phenđa e Isusese: “Gospode, šukari amenđe so injam akate. Te mangeja, ka ćerav akate trin šatorja: jekh tuće, jekh e Mojsijase hem jekh e Ilijase.” ");
INSERT INTO rmna_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Sar vaćeri ine adava, učharđa len jekh sjajno oblako hem taro oblako šundilo glaso savo vaćerđa: “Akavai mlo Čhavo o volime. Oleja injum bahtalo. Ole šunen!” ");
INSERT INTO rmna_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Kad o učenici šunde adava, pele mujeja đi phuv hem but darandile. ");
INSERT INTO rmna_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","I o Isus alo đi lende, čhivđa ple vasta upro lende hem phenđa lenđe: “Ušten hem ma daran!” ");
INSERT INTO rmna_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","A kad vazdinde pumare šere, na dikhle nikas sem e Isuse. ");
INSERT INTO rmna_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","I sar huljena ine tari gora, o Isus naredinđa lenđe nikase te na vaćeren so dikhle sa đikote ov, o Čhavo e manušesoro, na uštela taro mule. ");
INSERT INTO rmna_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","O učenici pučle le: “Sose onda o učitelja e Zakonestar vaćerena da prvo o Ilija valjani te avel?” ");
INSERT INTO rmna_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","A o Isus phenđa lenđe: “Čače prvo o Ilija avela hem palem ka čhivel sa than thaneja. ");
INSERT INTO rmna_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ali phenava tumenđe: o Ilija već alo, ali on na pendžarde le, nego ćerde oleja sar olenđe manglja pe. Ađahar hem o Čhavo e manušesoro ka patini olendar.” ");
INSERT INTO rmna_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Tegani o učenici halile so adava vaćerđa lenđe e Jovanestar e Krstiteljestar. ");
INSERT INTO rmna_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Kad ale koro narodo, nakhlo đi o Isus jekh manuš, pelo ko kočija anglo leste ");
INSERT INTO rmna_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","hem phenđa lese: “Gospode, smilujin tut mle čhavese. Adalese so isi le epilepsija hem but mučini pe hem but puti perela ani jag hem ano pani. ");
INSERT INTO rmna_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Anđum le ko te učenici, ali on našti ine te sasljaren le.” ");
INSERT INTO rmna_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","A o Isus phenđa: “O, biverakiri hem rumimi generacijo! Pana kobor valjani te ovav tumencar? Pana kobor valjani te trpinav tumen? Anen adale čhavore akari!” ");
INSERT INTO rmna_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Tegani o Isus naredinđa e demonese te ikljol e čhavorestar, hem iklilo, a o čhavoro ko adava momenti saslilo. ");
INSERT INTO rmna_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Tegani o učenici ale đi o Isus, inele korkore, hem pučle le: “Sose amen našti ine te ispudina e demone?” ");
INSERT INTO rmna_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","A o Isus phenđa lenđe: “Adalese so injen tikora verakere manuša. Čače vaćerava tumenđe: te ovel tumen ine vera sar zrno oti gorušica, ka phenen ine akala goraće: ‘Nakh akatar adari’, hem oj ka nakhel ine. Hem ništa naka ovel tumenđe ine nemoguće. ");
INSERT INTO rmna_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ali, akaja vrsta ispudini pe samo molitvaja hem postibnaja.” ");
INSERT INTO rmna_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","I kad čedinde pe ani Galileja, o Isus phenđa ple učenikonenđe: “Me, o Čhavo e manušesoro, sigate ka ovav predime ano vasta e bišukare manušengere. ");
INSERT INTO rmna_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ka mudaren man, ali o trito dive ka uštav taro mule.” I o učenici but rastužinde pe. ");
INSERT INTO rmna_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Kad resle ano Kafarnaum, ale koro Petar okola so čedena e hramesoro porez savo inele duj drahme, hem pučle le: “Tumaro li učitelj na platini e hramesoro porez?” ");
INSERT INTO rmna_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","O Petar phenđa lenđe: “Platini!” I kad o Petar đerdinđa ko čher, o Isus angleder olestar lelja te vaćeri hem pučlja le: “So mislineja, Simone, kastar e phuvjakere carija čedena i carina ili o porez? Pumare ili averengere čhavendar?” ");
INSERT INTO rmna_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","O Petar phenđa: “Averengere čhavendar.” Tegani o Isus phenđa: “Znači, o čhave na valjani te platinen. ");
INSERT INTO rmna_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ali, sar te na uvredina len, dža ko jezero hem frde i udica. Phrav o muj e prvone maćhesoro save ka dole hem andre ka arakhe jekh kovanica oto štar drahme. Le la hem platin lenđe o porez maje hem tuće.” ");
INSERT INTO rmna_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Tegani o učenici ale koro Isus hem pučle le: “Koi, onda, najbaro ano carstvo e nebosoro?” ");
INSERT INTO rmna_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","O Isus vičinđa kora peste jekhe čhavore, čhivđa le maškar olende ");
INSERT INTO rmna_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","hem phenđa: “Čače vaćerava tumenđe, te na obratinđen tumen hem te na uljen sar o čhavore, naka đerdinen ko carstvo e nebosoro. ");
INSERT INTO rmna_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Adalese, ano carstvo e nebosoroi najbaro okova kova ovela ponizno sar akava čhavoro. ");
INSERT INTO rmna_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","I svako kova primini jekhe esavke čhavore zbog maje, man primini.” ");
INSERT INTO rmna_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Te neko ćerela jekhe akale najtikore manušendar, kola verujinena ana mande, te perel ano greh, po šukar ka ovel lese ine ki men te ovel lese phandlo baro bar hem te ovel tasavdo ano hor e moresoro. ");
INSERT INTO rmna_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Jao e manušenđe oto sveto adalese so ćerena te perel pe ano greh. O iskušenja mora te aven, ali jao e manušese prekala kaste avena! ");
INSERT INTO rmna_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Te to vas ili to pro legari tut ko greh, čhin le hem frde le tutar. Po šukari će te đerdine ko večno dživdipe sakatime ili bango nego te oven tut soduj vasta ili pre, a te ove frdime ani večno jag. ");
INSERT INTO rmna_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Te ti jakh legari tut ko greh, ikal la hem frde la tutar. Po šukari će te đerdine ko večno dživdipe samo jekha jakhaja nego te oven tut soduj jaćha, a te ove frdime ano jagalo pakao. ");
INSERT INTO rmna_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Pazinen te na dikhen po tele nijekhe akale najtikore manušendar. Adalese so, vaćerava tumenđe, lengere anđelja ko nebo stalno terđovena anglo mlo Dad, kovai ano nebo. ");
INSERT INTO rmna_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Adalese so me, o Čhavo e manušesoro, aljum te spasinav e našalden.” ");
INSERT INTO rmna_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“So mislinena: te nesave manuše isi šel bakre i jekh olendar našalđola, so ka ćerel? Ka ačhaj e enjavardešu enjen ko gore hem ka džal te rodel e našalde bakre. ");
INSERT INTO rmna_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","I te arakhlja le, čače vaćerava tumenđe, više ka radujini pe olese nego okole enjavardešu enjenđe save na našaldile. ");
INSERT INTO rmna_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ađahar ni tumaro Dad, kovai ano nebo, na mangela nijekh akale najtikore manušendar te našalđol.” ");
INSERT INTO rmna_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Te to phral ćerela greh premala tute, dža korkoro hem vaćer lese ko so grešinđa. Te šunđa tut, zadobinđan te phrale. ");
INSERT INTO rmna_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Te na šunđa tut, legar tuja pana jekhe ili dujen, te šaj ‘palo svedočiba duje ili trine svedokonengoro dokažini pe svako stvaro.’ ");
INSERT INTO rmna_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Te na mangela te šunel ni olen, vaćer e khanđirjaće. A te na mangela te šunel ni e khanđirja, dikh le sar okole kova na džanel e Devlese ili sar cariniko. ");
INSERT INTO rmna_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Čače vaćerava tumenđe, sa so phandena ki phuv, ka ovel phandlo ano nebo, hem sa so phravena ki phuv, ka ovel phravdo ano nebo. ");
INSERT INTO rmna_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","A vaćerava tumenđe hem akava: sa so duj džene tumendar ki phuv sar jekh rodena, mlo Dad, kovai ano nebo, ka del len adava. ");
INSERT INTO rmna_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Adalese so, kotei duj ili trin džene čedime ano mlo anav, me injum adari maškar olende.” ");
INSERT INTO rmna_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tegani o Petar nakhlo đi o Isus hem pučlja le: “Gospode, kobor puti te oprostinav mle phralese kova grešini premala mande? Đi efta puti?” ");
INSERT INTO rmna_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","O Isus phenđa lese: “Vaćerava će, na efta puti, nego eftavardeš puti po efta! ");
INSERT INTO rmna_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ače sose: O carstvo e nebosoroi slično e carose kova odlučinđa te rešini o računja ple slugencar. ");
INSERT INTO rmna_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kad lelja te dženel, ande anglo leste jekhe kova dugujini lese ine deš hiljade kese zlatoja. ");
INSERT INTO rmna_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Adalese so na inole te irini lese adava, o caro naredinđa adale sluga, lese romnja, e čhaven hem sa so inole te biknen hem ađahar te irini pe lese o dugo. ");
INSERT INTO rmna_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tegani o sluga pelo mujeja đi phuv anglo leste hem phenđa: ‘Ov strpljivo mancar hem sa ka irinav će.’ ");
INSERT INTO rmna_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","E carose pelo žal olese, oprostinđa lese o dugo hem muklja le. ");
INSERT INTO rmna_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ali kad adava sluga iklilo, reslja jekhe ple amale, avere sluga, kova dugujini lese ine šel srebrna kovanice. Dolinđa le hem lelja te tasavel le, vaćerindoj: ‘Irin maje o dugo!’ ");
INSERT INTO rmna_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Tegani lesoro amal pelo mujeja đi phuv anglo leste hem molinđa le, vaćerindoj: ‘Ov strpljivo mancar hem ka irinav će.’ ");
INSERT INTO rmna_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ali ov na manglja te adžićeri, nego dželo hem frdinđa ple amale ko phandlipe đikote na irini o dugo. ");
INSERT INTO rmna_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kad lesere amala, o avera sluge, dikhle so ulo, but ine lenđe pharo, i džele hem vaćerde e carose sa so ulo. ");
INSERT INTO rmna_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Tegani o caro vičinđa kora peste e sluga kase oprostinđa o dugo hem phenđa lese: ‘Bišukar slugo! Oprostinđum će sa okova dugo, adalese so molinđan man! ");
INSERT INTO rmna_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Na valjanđan li hem tu te ove milosrdno te amalese sar so me injumle milosrdno tuće?’ ");
INSERT INTO rmna_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","I o caro holjanđa, i dinđa le ko manuša kola ka mučinen le đikote na irini lese sa o dugo. ");
INSERT INTO rmna_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ađahar hem mlo Dad, kovai ano nebo, ka ćerel tumencar te na oprostinđen tumare phralese oto sa o vilo.” ");
INSERT INTO rmna_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","I kad o Isus završinđa ple vaćeribnaja, dželo tari Galileja ko krajo e judejakoro ki aver strana oti len Jordan. ");
INSERT INTO rmna_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Palo leste džele but džene hem ov adari sasljarđa e nambormen maškaro lende. ");
INSERT INTO rmna_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","I ale koro Isus nesave fariseja mangindoj te iskušinen le, i pučle le: “Tromal li o rom te ačhaj pe romnja zako bilo so?” ");
INSERT INTO rmna_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ov phenđa lenđe: “Na čitinđen li ano Sveto lil da ko anglunipe o Stvoritelj ‘ćerđa murše hem đuvlja’? ");
INSERT INTO rmna_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Hem so phenđa: ‘Adalese o manuš ka ačhaj pe dade hem pe daja hem ka ovel jekh pe romnjaja, hem on duj ka oven jekh telo.’ ");
INSERT INTO rmna_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ađahar, on nane više duj, nego jekh telo. Adalese, o manuš te na rastavini okolen so o Devel ćerđa te oven jekh!” ");
INSERT INTO rmna_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Tegani on pučle le: “Sose onda o Mojsije naredinđa o rom te del pe romnjaće lil oto rastaviba kad ačhaj la?” ");
INSERT INTO rmna_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","O Isus phenđa lenđe: “O Mojsije muklja tumenđe te šaj ačhaven tumare romnjen adalese so injen šerale, ali ko anglunipe na inele ađahar. ");
INSERT INTO rmna_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ali me vaćerava tumenđe: te neko ačhaj pe romnja, sem zbog olakoro blud, i lela avera, ćerela preljuba.” ");
INSERT INTO rmna_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tegani lesere učenici phende: “Tei ađahar maškaro rom hem i romni, ondai po šukar te na ženini pe manuš.” ");
INSERT INTO rmna_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","A o Isus phenđa lenđe: “Našti adava tumaro lafi sare te prihvatinen, nego samo okola kolenđei dindo. ");
INSERT INTO rmna_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Adalese so isi manuša kola bijandile nesposobna zaki ženidba. Isi hem okola kolen o manuša ćerde te oven nesposobna zaki ženidba. A isi hem okola kola, zbog o carstvo e nebosoro, korkore na mangena te ženinen pe. Ko šaj akava te prihvatini, nek prihvatini.” ");
INSERT INTO rmna_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tegani o manuša ande anglo Isus pumare čhavoren te čhivel ple vasta upro lende hem te molini pe, a o učenici braninde lenđe. ");
INSERT INTO rmna_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","A o Isus phenđa: “Muken e čhavoren te aven kora mande hem ma braninen lenđe, adalese so esavkenđe pripadini o carstvo e nebosoro!” ");
INSERT INTO rmna_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","I čhivđa ple vasta upro lende hem blagoslovinđa len, a palo adava dželo adathar. ");
INSERT INTO rmna_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","I dikh, alo koro Isus nesavo manuš hem pučlja le: “Učitelju, savo šukaripe valjani te ćerav te ovel man o večno dživdipe?” ");
INSERT INTO rmna_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","A o Isus phenđa lese: “Sose pučeja man adalestar soi šukar? Isi samo jekh kovai šukar – o Devel! Ali te mangljan te đerdine ko dživdipe, ićer o naredbe!” ");
INSERT INTO rmna_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ov pučlja: “Save?” A o Isus phenđa: “Akala: ‘Ma mudar’, ‘Ma ćer preljuba’, ‘Ma čor’, ‘Ma svedočin hovavne’, ");
INSERT INTO rmna_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","‘Poštujin te dade hem te daja’ hem ‘Volin te pašutne sar korkore tut.’ ” ");
INSERT INTO rmna_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","O terno manuš phenđa lese: “Sa adava ićerđum. So valjani pana te ćerav?” ");
INSERT INTO rmna_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","O Isus phenđa lese: “Te mangljan te ove savršeno, dža hem biknin so isi tut, a o pare de e čororenđe i ka ovel tut barvalipe ano nebo. Tegani ava hem phir pala mande.” ");
INSERT INTO rmna_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","A kad o terno manuš šunđa adava, rastužisalo hem dželo, adalese so na manglja te biknel plo baro barvalipe. ");
INSERT INTO rmna_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tegani o Isus phenđa ple učenikonenđe: “Čače vaćerava tumenđe, phareste o barvalo ka đerdini ko carstvo e nebosoro. ");
INSERT INTO rmna_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","I palem vaćerava tumenđe: Po lokhei e kamilaće te nakhel maškaro kan e suvjakoro nego e barvalese te đerdini ko carstvo e Devlesoro.” ");
INSERT INTO rmna_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kad šunde adava, o učenici ule but začudime, i pučle: “Ko onda šaj te ovel spasime?” ");
INSERT INTO rmna_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","O Isus dikhlja len šukar, i phenđa: “E manušenđe adava nane moguće, ali e Devlese sai moguće.” ");
INSERT INTO rmna_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tegani o Petar phenđa: “Ače, amen sa ačhavđam te dža pala tute. So, onda, ka dobina adalese?” ");
INSERT INTO rmna_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","A o Isus phenđa lenđe: “Čače vaćerava tumenđe, ko nevo sveto, kad me, o Čhavo e manušesoro, ka bešav ko mlo slavno tron, tumen kola dželjen pala mande ka bešen ko dešu duj tronja te sudinen upro dešu duj plemija e Izraelesere. ");
INSERT INTO rmna_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","A svako kova zbog maje ačhavđa o čhera, ili e phraljen, ili e phenjen, ili e dade, ili e daja, ili e romnja, ili e čhaven, ili o njive, ka dobini šel puti više hem ka nasledini o večno dživdipe. ");
INSERT INTO rmna_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ali, but okola kolai akana prva tegani ka oven zadnja, a okola kolen akate dikhena sar zadnjonen adari ka oven prva.” ");
INSERT INTO rmna_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Adalese so, o carstvo e nebosoroi slično e domaćinese kova rano sabale iklilo te rodel bućarnen te ćeren buti ano lesoro vinograd. ");
INSERT INTO rmna_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Dogovorinđa pe e bućarnencar te del len po jekh denari, so inele plata zako jekh dive, i bičhalđa len pese ko vinograd. ");
INSERT INTO rmna_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Kad inele đi sar enja o sati, palem iklilo avri hem dikhlja averen sar terđovena ko trg bizi buti, ");
INSERT INTO rmna_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","i phenđa lenđe: ‘Džan hem tumen ko mlo vinograd, a me ka platinav tumenđe pravedno.’ ");
INSERT INTO rmna_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","I on džele. A ov palem iklilo đi sar ko dešu duj o sati, hem đi sar ko trin o sati, hem ćerđa isto ađahar. ");
INSERT INTO rmna_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kad inele đi sar pandž o sati, palem iklilo hem arakhlja averen sar terđovena hem pučlja len: ‘Sose sa akava dive terđovena akate bizi buti?’ ");
INSERT INTO rmna_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","On phende lese: ‘Adalese so niko na dinđa amen buti.’ A ov phenđa lenđe: ‘Džan hem tumen ko mlo vinograd.’ ");
INSERT INTO rmna_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Kad peli i rat, o gospodari e vinogradesoro phenđa ple manušese kova inele upreder o bućarne: ‘Vičin e bućarnen hem platin len počindoj oto okola kola ale zadnja, i đi okola kola ale prva.’ ");
INSERT INTO rmna_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ađahar ale o bućarne so lelje te ćeren buti ko pandž o sati, hem svako olendar priminđa po jekh denari. ");
INSERT INTO rmna_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Kad ale okola kola prva lelje te ćeren buti, mislinde da on ka priminen više, ali hem on priminde po jekh denari. ");
INSERT INTO rmna_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Kad lelje o pare, lelje te buninen pe protiv o domaćini vaćerindoj: ");
INSERT INTO rmna_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Akala zadnja ćerde buti samo jekh sati, a tu platinđan len kobor hem amen kola sa akava dive ćerđam phari buti hem thabiljam ko kham!’ ");
INSERT INTO rmna_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","A o domaćini jekhese olendar phenđa: ‘Amala, me na hovavđum tut. Tu dogovorinđan tut mancar te ćere buti zako jekh denari. ");
INSERT INTO rmna_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Le ti plata hem dža, a me akalese soi zadnjo mangava te dav edobor kobor hem tuće. ");
INSERT INTO rmna_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nane li man pravo mle parencar te ćerav so me mangava? Ili tu injan ljubomorno so me injum šukar premalo lende?’ ");
INSERT INTO rmna_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ađahar okola kolai akana zadnja tegani ka oven prva, a okola kolen akate dikhena sar prvonen adari ka oven zadnja.” ");
INSERT INTO rmna_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Sar džala ine nakoro Jerusalim, o Isus cidinđa ki strana e dešu duje učenikonen hem odrumal phenđa lenđe: ");
INSERT INTO rmna_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ače, ukljaja nakoro Jerusalim. Adari man, e Čhave e manušesere, o manuša ka den ko šerutne sveštenici hem ko učitelja e Zakonestar, hem on ka osudinen man ko meriba. ");
INSERT INTO rmna_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Tegani ka den man ko manuša kola nane Jevreja te maren muj mancar, te šibinen man hem te čhiven man ko krsto. Ali o trito dive ka uštav taro mule.” ");
INSERT INTO rmna_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tegani i daj e Zevedejesere čhavengiri, ple čhavencar, ali koro Isus hem peli mujeja đi phuv anglo leste te rodel lestar nešto. ");
INSERT INTO rmna_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","O Isus pučlja la: “So mangeja?” Oj phenđa: “Vaćer maje da mle soduj čhave ano to carstvo ka bešen jekh tuće oti desno strana, a jekh oti levo.” ");
INSERT INTO rmna_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","A o Isus phenđa: “Na džanen so rodena. Šaj li te pijen tari čaša savatar me ka pijav?” On phende: “Šaj.” ");
INSERT INTO rmna_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","I ov phenđa lenđe: “Čače ka pijen tari mli čaša e patnjaja. Ali nane mlo te vaćerav ko ka bešel maje oti desno ili oti levo strana. Adalai thana okolenđe kolenđe mlo Dad spreminđa len.” ");
INSERT INTO rmna_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kad šunde adava avera deš učenici, holjande upro duj phralja. ");
INSERT INTO rmna_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Tegani o Isus vičinđa len kora peste hem phenđa: “Džanen da o vladarija avere nacijengere gospodarinena olencar hem o bare manuša vladinena upro lende. ");
INSERT INTO rmna_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ali ma te ovel ađahar maškar tumende. Nego, ko mangela te ovel baro maškar tumende, nek ovel tumenđe sluga. ");
INSERT INTO rmna_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ko mangela te ovel prvo maškar tumende, nek ovel tumenđe robo. ");
INSERT INTO rmna_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Sar so ni o Čhavo e manušesoro na alo te kanden le, nego te kandel, hem te del plo dživdipe sar otkup butenđe.” ");
INSERT INTO rmna_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Sar o Isus hem lesere učenici ikljovena ine tari diz Jerihon, palo leste džele but manuša. ");
INSERT INTO rmna_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","I dikh, duj korore manuša bešena ine uzalo drom, i kad šunde so o Isus nakhela, vičinde: “Smilujin tut amenđe, Gospode, Čhaveja Davidesereja!” ");
INSERT INTO rmna_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","But džene vičinde upro lende te trainen, ali on po zorale vičinde: “Smilujin tut amenđe, Gospode, Čhaveja Davidesereja!” ");
INSERT INTO rmna_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","O Isus terdino, i vičinđa len kora peste hem pučlja: “So mangena te ćerav tumenđe?” ");
INSERT INTO rmna_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","On phende lese: “Gospode, phrav amare jaćha te dikha.” ");
INSERT INTO rmna_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","E Isusese pelo žal olenđe, čhivđa ple vasta upro lengere jaćha hem on otojekhvar šaj ine te dikhen, i džele palo Isus. ");
INSERT INTO rmna_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Kad o Isus hem lesere učenici ale paše uzalo Jerusalim hem resle đi o gav Vitfaga ki e Maslinakiri gora, bičhalđa anglal duje učenikonen, ");
INSERT INTO rmna_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","vaćerindoj lenđe: “Džan ko adava gav savoi angla tumende hem odmah ka arakhen hernja savi phandli hem uzalo late terne here. Phraven len hem anen len kora mande. ");
INSERT INTO rmna_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Te vaćerđa tumenđe neko nešto, phenen samo: ‘E Gospodese valjanena’, hem adava manuš odmah ka bičhali len.” ");
INSERT INTO rmna_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Adava ulo sar te pherđol okova so inele vaćerdo prekalo proroko: ");
INSERT INTO rmna_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Vaćeren e narodose taro Jerusalim: ‘Ače, avela tuće to Caro, ponizno, bešindoj upro her, upro terno her, o čhavo e hernjakoro.’ ” ");
INSERT INTO rmna_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","O učenici džele hem ćerde ađahar sar so phenđa lenđe o Isus. ");
INSERT INTO rmna_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ande e hernja hem e terne here, i čhivde pumare fostanja upro lende te šaj o Isus te bešel. ");
INSERT INTO rmna_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Sa edobor džene buljarena ine pumare fostanja upro drom anglo leste, a nesave manuša čhinena ine o granke taro kašta hem buljarena len upro drom. ");
INSERT INTO rmna_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","O manuša kola džele anglo leste hem palo leste vičinena ine: “Hosana e Davidesere Čhavese! ‘Blagoslovimei okova kova avela ano anav e Gospodesoro!’ Hosana e Devlese ko učipe!” ");
INSERT INTO rmna_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Kad đerdinđa ano Jerusalim, sa o dizutne uzbudinde pe hem pučle: “Kovai akava?” ");
INSERT INTO rmna_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","A o narodo vaćerđa: “Akavai o Isus, o proroko taro Nazaret oti Galileja.” ");
INSERT INTO rmna_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","O Isus đerdinđa ano boro e Hramesoro hem ispudinđa adathar sa okolen so biknena hem okolen so činena hem peravđa o astalja okolengere so menjinena o pare hem o klupe okolengere so biknena goluben. ");
INSERT INTO rmna_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","I phenđa lenđe: “Pisimei ano Sveto lil: ‘O čher mlo ka vičini pe čher zaki molitva’, a tumen ćerena olestar ‘than kote čedena pe o čora!’ ” ");
INSERT INTO rmna_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","I ale koro Isus ano Hram o korore hem o bange manuša, hem ov sasljarđa len. ");
INSERT INTO rmna_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","A kad o šerutne sveštenici hem o učitelja e Zakonestar dikhle o čudesija save o Isus ćerđa hem e čhavoren sar ano Hram vičinena: “Hosana e Davidesere Čhavese!”, holjande ");
INSERT INTO rmna_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","hem pučle le: “Šuneja li so o čhavore vaćerena?” A o Isus phenđa lenđe: “Šunava. Tumen li nikad na čitinđen ano Sveto lil akava: ‘Taro muj e čhavorengoro hem e bebicengoro ćerđan te avel će hvala’?” ");
INSERT INTO rmna_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Tegani ačhavđa len hem dželo taro Jerusalim ki Vitanija te sovel adari. ");
INSERT INTO rmna_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","A ko sabale sar o Isus irini pe ine ko Jerusalim, bokhalilo. ");
INSERT INTO rmna_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Dikhlja uzalo drom e smokvakoro kaš hem alo uzalo leste, ali na arakhlja upro leste ništa sem listija. I phenđa lese: “Nikad više te na ovel tut plod!” I otojekhvar o kaš šućilo. ");
INSERT INTO rmna_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kad dikhle adava o učenici, začudinde pe hem pučle: “Sar adava e smokvakoro kaš otojekhvar šućilo?” ");
INSERT INTO rmna_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","A o Isus phenđa lenđe: “Čače vaćerava tumenđe, te ine tumen vera hem te na sumnjinđen, na samo da ka ćeren adava so me ćerđum e smokvaja nego hem ka šaj te vaćeren akala goraće: ‘Ušti hem frde tut ano more!’ – hem ađahar ka ovel. ");
INSERT INTO rmna_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Hem sa so rodena ani molitva, ka priminen te verujinđen.” ");
INSERT INTO rmna_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","O Isus dželo ko Hram. I sar sikaj ine adari e narodo, ale koro leste o šerutne sveštenici hem o starešine e jevrejengere hem pučle le: “Kotar tuće autoritet te ćere akava? Ko dinđa tut pravo?” ");
INSERT INTO rmna_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","O Isus phenđa lenđe: “Hem me tumen ka pučav nešto, i te phenđen maje, hem me tumenđe ka phenav kotar maje pravo te ćerav akava. ");
INSERT INTO rmna_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ko dinđa pravo e Jovane te krstini e manušen, o Devel kovai ano nebo ili o manuša?” A on raspravinde pe maškara pumende vaćerindoj: “Te phenđam ‘o Devel kovai ano nebo’, ov ka pučel amen sose onda na verujinđam lese. ");
INSERT INTO rmna_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","A te phenđam ‘o manuša’, dar amen e narodostar, adalese so sare dikhle e Jovane sar proroko.” ");
INSERT INTO rmna_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Adalese phende e Isusese: “Na džanaja.” I ov phenđa lenđe: “Ni me onda naka phenav tumenđe kotar maje pravo akava te ćerav.” ");
INSERT INTO rmna_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Tegani o Isus pučlja len: “So mislinena akalestar: Nesave manuše inele duj čhave. Alo koro prvo hem phenđa lese: ‘Mlo čhavo, dža hem ćer buti avdive ano vinograd.’ ");
INSERT INTO rmna_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","A ov phenđa lese: ‘Nako’, ali palo adava predomislinđa pe, i dželo. ");
INSERT INTO rmna_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tegani o dad alo koro dujto čhavo hem phenđa lese isto. A ov phenđa lese: ‘Ka džav, gospodarona’, ali na dželo. ");
INSERT INTO rmna_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Kova akale dujendar ćerđa e dadesiri volja?” On phende: “O prvo.” O Isus phenđa lenđe: “Čače vaćerava tumenđe, o carinici hem o bludnice angleder tumendar đerdinena ko carstvo e Devlesoro. ");
INSERT INTO rmna_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Adalese so o Jovan o Krstitelj alo te mothoj tumenđe o drom oto pravedno dživdipe, ali tumen na verujinđen lese, a o carinici hem o bludnice verujinde lese. Čak hem kad dikhljen adava, na predomislinđen tumen hem na verujinđen lese.” ");
INSERT INTO rmna_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Šunen aver priča: Nesavo domaćini sadinđa vinograd, ogradinđa le, handlja ano leste than zako pritiskiba i drakh hem vazdinđa e stražakiri kula. Tegani iznajminđa le nesave vinogradarenđe hem dželo ko drom. ");
INSERT INTO rmna_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","I kad alo o vreme te čeden pe o drakha, bičhalđa ple slugen koro vinogradarija te šaj len oto bijandipe e drakhakoro. ");
INSERT INTO rmna_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ali o vinogradarija dolinde lesere slugen, i jekhe marde, avere mudarde, a upro aver frdinde bara đikote na mulo. ");
INSERT INTO rmna_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","O gospodari palem bičhalđa avere slugen, više nego prvo puti, ali hem olencar ćerde sar e prvonencar. ");
INSERT INTO rmna_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ko kraj bičhalđa lenđe ple čhave, vaćerindoj: ‘Mle čhave ka poštujinen.’ ");
INSERT INTO rmna_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ali kad o vinogradarija dikhle e čhave, vaćerde maškara pumende: ‘Akavai o nasledniko. Hajde te mudara le hem te la lesoro nasledstvo.’ ");
INSERT INTO rmna_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","I dolinde le, frdinde le avri taro vinograd hem mudarde le.” ");
INSERT INTO rmna_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","O Isus tegani pučlja len: “So mislinena, so ka ćerel o gospodari adale vinogradarenđe kad ka avel?” ");
INSERT INTO rmna_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","On phende lese: “Adale bišukare manušen ka mudari bizi milost, a o vinograd ka iznajmini avere vinogradarenđe kola ka den le o plodija kad ka avel o vreme zako adava.” ");
INSERT INTO rmna_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","O Isus pučlja len: “Tumen li nikad na čitinđen ano Sveta lila: ‘O bar savo odbacinde o zidarija ulo najbitno bar e čheresoro. Adava o Gospod ćerđa hem adava ćerela amen te ova zadivime.’ ");
INSERT INTO rmna_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Adalese vaćerava tumenđe: ka lel pe tumendar o carstvo e Devlesoro hem ka del pe e manušenđe kola ka mothoven lesere plodija. ");
INSERT INTO rmna_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","I svako kova perela upro adava bar, ka phagel pe, a te pelo adava bar upra nekaste, ka zgnječini le.” ");
INSERT INTO rmna_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kad o šerutne sveštenici hem o fariseja šunde e Isusesere priče, halile so ov vaćeri olendar, ");
INSERT INTO rmna_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","i mangle te dolen le. Ali darandile e narodostar, adalese so o manuša dikhle e Isuse sar proroko. ");
INSERT INTO rmna_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","O Isus palem lelja te vaćeri lenđe ano priče: ");
INSERT INTO rmna_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“O carstvo e nebosoroi slično sar kad o caro ćerela bijav ple čhavese. ");
INSERT INTO rmna_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","I bičhalđa ple slugen palo okola kolai vičime ko bijav, ali on na mangle te aven. ");
INSERT INTO rmna_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Palem bičhalđa avere slugen hem phenđa: ‘Vaćeren e vičimenđe: Ače, o hajbai ćerdo. Pekljam najšužo guruvano mas. Sai ćerdo. Aven ko bijav.’ ");
INSERT INTO rmna_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ali on na dinde pažnja adalese, nego džele – jekh ki pli njiva, a aver pla bućaja, ");
INSERT INTO rmna_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","a avera dolinde e carosere slugen, marde len hem mudarde len. ");
INSERT INTO rmna_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","A o caro holjanđa, i bičhalđa pla vojska hem mudarđa okolen kola mudarde lesere slugen hem tharđa lengiri diz. ");
INSERT INTO rmna_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Tegani phenđa ple slugenđe: ‘O bijavi spremime, ali o vičime na inele dostojna te aven. ");
INSERT INTO rmna_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Adalese ikljoven ko droma avri tari diz hem vičinen ko bijav đijekhe kas arakhena.’ ");
INSERT INTO rmna_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","I adala sluge iklile ko droma hem čedinde sarijen kolen arakhle, hem e bišukaren hem e šukaren, i o than kote ćerđa pe o bijav pherdilo gostonencar. ");
INSERT INTO rmna_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Kad o caro đerdinđa te dikhel e gostonen, dikhlja adari jekhe manuše kova na inele urjavdo ano e bijavesere šeja, ");
INSERT INTO rmna_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","i pučlja le: ‘Amala, sar đerdinđan akari, a na injan urjavdo ano e bijavesere šeja?’ A ov samo trainđa. ");
INSERT INTO rmna_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Tegani o caro phenđa e slugenđe: ‘Phanden lesere vasta hem lesere pre hem frden le avri ani naj dur tomina, kote ka ovel baro rojba hem krciba e dandengoro tari dukh.’ ");
INSERT INTO rmna_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Adalese soi but vičime, a hari birime.” ");
INSERT INTO rmna_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Tegani o fariseja džele hem dogovorinde pe sar hovavneste te dolen e Isuse ko lafi. ");
INSERT INTO rmna_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","I bičhalde koro Isus pumare učenikonen e manušencar kola podržinena e Irode te pučen le: “Učitelju, džanaja da vaćereja o čačipe hem na ićereja nikasiri strana, adalese so na dikheja koi kova, nego čačimase sikaveja oto drom e Devlesoro. ");
INSERT INTO rmna_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Vaćer amenđe so mislineja? Valjani li amen o Jevreja te platina o porez e rimesere carose ili na?” ");
INSERT INTO rmna_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","A o Isus džanđa lengere bišukar mislija, i phenđa lenđe: “Sose mangena te dolen man ki zamka, dujemujengere manušalen? ");
INSERT INTO rmna_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mothoven maje i kovanica savaja platinena o porez.” On dinde le denari, ");
INSERT INTO rmna_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","a ov pučlja len: “Kasiri slika hem kasoroi anav ki kovanica?” ");
INSERT INTO rmna_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","A on phende: “E carosoro.” Tegani o Isus phenđa lenđe: “Onda den soi e carosoro e carose, a soi e Devlesoro e Devlese.” ");
INSERT INTO rmna_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Kad šunde adava, ule zadivime, i ačhavde le hem džele. ");
INSERT INTO rmna_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Adava dive ale koro Isus nesave sadukeja, kola vaćerena da nane uštiba taro mule, i pučle e Isuse: ");
INSERT INTO rmna_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Učitelju, o Mojsije phenđa: ‘Te nesavo ženime manuš merela, a na ačhavđa pala peste čhaven, lesoro phral valjani te lel lesere romnja te šaj oj te bijani čhave kova ka ovel nasledniko e mulesoro.’ ");
INSERT INTO rmna_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ađahar, koro amende inele efta phralja. O prvo lelja romnja i mulo, a na ačhavđa pala peste čhaven, i lesiri romni uli romni e dujtone phralesiri. ");
INSERT INTO rmna_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ađahar hem mule o dujto hem o trito phral, hem ađahar sa o efta phralja. ");
INSERT INTO rmna_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","A palo lende sarijende muli hem i romni. ");
INSERT INTO rmna_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kasiri onda romni oj ka ovel kad ka uštel pe taro mule, a inele dindi ko sa o efta phralja?” ");
INSERT INTO rmna_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","A o Isus phenđa lenđe: “Tumen hovavdiljen ko adava, adalese so na haljovena ni o Sveto lil ni e Devlesoro zoralipe. ");
INSERT INTO rmna_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Adalese so, kad ka ušten taro mule, o manuša ni ka len pe ni ka den pe, nego ka oven sar o anđelja ano nebo. ");
INSERT INTO rmna_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","A zako uštiba taro mule, na čitinđen li ano Sveto lil so o Devel phenđa tumenđe: ");
INSERT INTO rmna_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Me injum o Devel e Avraamesoro, e Isaakesoro hem e Jakovesoro’ kola mule odavno? A o Devel nane Devel e mulengoro, nego Devel e dživdengoro.” ");
INSERT INTO rmna_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kad o narodo šunđa adava, ule zadivime lesere sikavibnaja. ");
INSERT INTO rmna_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","I kad o fariseja šunde so o Isus trainćerđa e sadukejen, čedinde pe, ");
INSERT INTO rmna_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","i jekh olendar kova inele učitelj e zakonestar, sar te dolel e Isuse ki zamka, pučlja le: ");
INSERT INTO rmna_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Učitelju, savi najbari naredba ano zakoni e Mojsijasoro?” ");
INSERT INTO rmna_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","A o Isus phenđa lese: “ ‘Volin e Gospode te Devle sa te vileja, sa te dušaja hem sa te gođaja.’ ");
INSERT INTO rmna_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Adajai prvo hem najbari naredba. ");
INSERT INTO rmna_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","A i dujtoi slično akalaće: ‘Volin te pašutne sar korkore tut.’ ");
INSERT INTO rmna_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Sa o naredbe oto Zakoni hem o lila e prorokonengere terđovena ko akala duj naredbe.” ");
INSERT INTO rmna_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","A sar o fariseja pana inele čedime, o Isus pučlja len: ");
INSERT INTO rmna_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“So mislinena e Hristestar? Kasoroi ov čhavo?” On phende lese: “E Davidesoro.” ");
INSERT INTO rmna_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","A ov pučlja len: “A sose onda o David, ano Duho vičini e Hriste Gospod vaćerindoj: ");
INSERT INTO rmna_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘O Gospod phenđa mle Gospodese: Beš ko počasno than, oti mli desno strana, đikote na pašljarava te neprijateljen talo te pre’? ");
INSERT INTO rmna_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Te o David vičini le ‘Gospode’, sar onda o Hrist šaj te ovel samo lesoro čhavo?” ");
INSERT INTO rmna_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","I niko na džanđa so te phenel lese ko adala lafija. Taro adava dive nijekh više na tromandilo te pučel le nešto. ");
INSERT INTO rmna_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Tegani o Isus phenđa e narodose hem ple učenikonenđe: ");
INSERT INTO rmna_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“O učitelja e Zakonestar hem o fariseja beštine ko than e Mojsijasoro te tumačinen o Zakoni. ");
INSERT INTO rmna_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Adalese ćeren hem ićeren tumen ko sa so vaćerena tumenđe, ali ma ćeren okova so on ćerena. Adalese so on na ćerena okova so vaćerena. ");
INSERT INTO rmna_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Phandena o bare pharipa savei phare te akharen pe hem čhivena len e manušenđe ko piće, a ni najeja na mangena te mrdinen te pomožinen lenđe te akharen len. ");
INSERT INTO rmna_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Sa so ćerena, ćerena sar te dikhen len o manuša. Sar kad širinena pumare kutijice e lafencar taro Sveto lil ko čekat ili ko vasta hem ćerena o dorikha save visinena lenđe oto šeja te oven po bare. ");
INSERT INTO rmna_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Volinena te bešen ko najšukar thana ko gozbe hem ko anglune thana ano sinagoge. ");
INSERT INTO rmna_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Volinena kad ko trgija pozdravinena len o manuša hem kad vičinena len ‘učitelju’. ");
INSERT INTO rmna_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ali tumen ma te oven vičime ‘učitelj’, adalese so isi tumen samo jekh Učitelj, a tumen sare injen phralja. ");
INSERT INTO rmna_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","I nijekhe ki phuv ma vičinen ‘dade’, adalese so isi tumen samo jekh Dad – okova kovai ano nebo. ");
INSERT INTO rmna_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ma te oven vičime ‘vođa’, adalese so isi tumen samo jekh Vođa – o Hrist. ");
INSERT INTO rmna_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","A kovai najbaro maškara tumende, nek ovel tumenđe sluga. ");
INSERT INTO rmna_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ko pes povazdela, ka ovel peravdo; a ko ponizini pe ka ovel povazdime. ");
INSERT INTO rmna_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Jao tumenđe, učiteljalen e Zakonestar hem farisejalen, dujemujengere manušalen! Adalese so phandena anglo manuša o udar e nebosere carstvostar. Korkore na đerdinena ano leste, a na mukena te đerdinen ni okola kola mangena te đerdinen. ");
INSERT INTO rmna_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Jao tumenđe, učiteljalen e Zakonestar hem farisejalen, dujemujengere manušalen! Hana o imanje e udovicengoro hem ćerena tumen da injen pobožna ađahar so molinena bare molitve. Adalese po zorale ka oven kaznime. ");
INSERT INTO rmna_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Jao tumenđe, učiteljalen e Zakonestar hem farisejalen, dujemujengere manušalen! Adalese so džana moreja hem phuvjaja sar te prelen jekhe manuše ani tumari vera, a kad prelena le, ćerena le te ovel čhavo e pakaosoro, duj puti po bišukar tumendar. ");
INSERT INTO rmna_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Jao tumenđe, so injen korore vođe! Vaćerena: ‘Te neko hala pe sovli e Hrameja, adava na značini ništa. Ali te hala pe sovli e hramesere zlatoja, phandloi adala sovljaja.’ ");
INSERT INTO rmna_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Dilinalen hem kororalen! Soi po baro: o zlato ili o Hram savo ćerela o zlato te ovel sveto? ");
INSERT INTO rmna_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Hem vaćerena: ‘Te neko hala pe sovli e žrtvenikoja, adava na značini ništa. Ali te hala pe sovli e daroja savoi upro oleste, phandloi adala sovljaja.’ ");
INSERT INTO rmna_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Kororalen! Soi po baro: o daro ili o žrtveniko savo ćerela o daro te ovel sveto? ");
INSERT INTO rmna_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Adalese, ko hala pe sovli e žrtvenikoja, hala pe sovli oleja hem sa okoleja soi upro leste. ");
INSERT INTO rmna_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Hem ko hala pe sovli e Hrameja, hala pe sovli oleja hem e Devleja kova bešela ano leste. ");
INSERT INTO rmna_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Hem ko hala pe sovli e neboja, hala pe sovli e Devlesere troneja hem e Devleja kova bešela upro leste. ");
INSERT INTO rmna_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Jao tumenđe, učiteljalen e Zakonestar hem farisejalen, dujemujengere manušalen! Adalese so dena e Devlese desetak oto začinja: oti nana, oto kopar hem oto kim, a ačhavđen te ćeren okova soi najbitno ano Zakoni e Mojsijasoro: pravda, milosrđe hem vera. Valjani te den o desetak, ali na troman te bistren te ćeren adava soi po bitno. ");
INSERT INTO rmna_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Korore vođe injen! Cedinena o pani kad o komarco đerdini tumenđe ani čaša, a bidikhindoj, e kamila gutinena! ");
INSERT INTO rmna_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Jao tumenđe, učiteljalen e Zakonestar hem farisejalen, dujemujengere manušalen! Adalese so kosena i šolja hem o čaro avrijal, a andral pherđen len tumara pohlepaja hem adaleja so ugodinena korkore tumenđe. ");
INSERT INTO rmna_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kororeja farisejona! Najangle kos i čaša andral, i oj ka ovel čisto hem avrijal. ");
INSERT INTO rmna_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Jao tumenđe, učiteljalen e Zakonestar hem farisejalen, dujemujengere manušalen! Adalese so injen sar o grobija makhle ano parno, save avrijal dičhona šuže, a andral pherde mulikane kokala hem svako melalipe. ");
INSERT INTO rmna_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ađahar hem tumen avrijal e manušenđe dičhona pravedna, a andral injen pherde licemerje hem bezakonje. ");
INSERT INTO rmna_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Jao tumenđe, učiteljalen e Zakonestar hem farisejalen, dujemujengere manušalen! Adalese so ćerena grobija e prorokonenđe hem ukrasinena o spomenici e pravednikonenđe, ");
INSERT INTO rmna_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","i vaćerena: ‘Te živina ine ko vreme amare pradadengoro, naka učestvujina ine olencar ko čhoriba o rat e prorokonengoro.’ ");
INSERT INTO rmna_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Korkore adaleja potvrdinena so injen potomci okolengere kola mudarena ine e prorokonen. ");
INSERT INTO rmna_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ćeren đi o krajo, onda, okova so tumare pradada počinde! ");
INSERT INTO rmna_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Sapalen! E sapengere čhavalen! Sar ka našen adalestar te na oven osudime ko pakao? ");
INSERT INTO rmna_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Adalese, ače, bičhalava tumenđe prorokonen, mudrakonen hem učiteljen e Zakonestar. Nekas olendar ka mudaren hem ka čhiven ko krsto, a averen ka šibinen tumenđe ano sinagoge hem ka progoninen len tari diz ki diz. ");
INSERT INTO rmna_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ađahar upra tumende ka perel sa o pravedno rat savo čhordilo ki phuv, pana taro rat e Aveljesoro kova inele pravedno sa đi o rat e Zaharijasoro, e Varahijasere čhavesoro, kole tumen o Jevreja mudarđen maškari svetinja ano hram hem o žrtveniko. ");
INSERT INTO rmna_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Čače vaćerava tumenđe, sa adava rat ka perel sar kazna upri akaja generacija.” ");
INSERT INTO rmna_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Jerusalime, Jerusalime, tu savo mudareja e prorokonen hem frdeja bara upro okola kolai tuće bičhalde! But puti mangljum te čedav te manušen sar i khani ple pilićken talo ple phaka, ali tumen na mangljen! ");
INSERT INTO rmna_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ače, to čher ka ovel napustime! ");
INSERT INTO rmna_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Adalese vaćerava tumenđe da naka dikhen man više sa đikote na phenena: ‘Blagoslovimei okova kova avela ano anav e Gospodesoro!’ ” ");
INSERT INTO rmna_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","O Isus iklilo taro Hram, a sar džala ine adathar, ale đi leste lesere učenici te mothoven lese sari šukar ćerdo o Hram. ");
INSERT INTO rmna_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","A ov phenđa lenđe: “Dikhena li sa adava? Čače vaćerava tumenđe, adalestar naka ačhol ni bar upro bar. Svako ka ovel peravdo.” ");
INSERT INTO rmna_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","I sar o Isus bešela ine ki e Maslinakiri gora, o učenici ale korkore đi leste hem pučle le: “Vaćer amenđe, kad adava ka ovel hem savo ka ovel o znako zako to aviba hem zako kraj e svetosoro?” ");
INSERT INTO rmna_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","O Isus phenđa lenđe: “Dikhen te na oven hovavde nekastar. ");
INSERT INTO rmna_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Adalese so but džene ka aven ano mlo anav vaćerindoj: ‘Me injum o Hrist’ hem buten ka hovaven. ");
INSERT INTO rmna_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","A kad ka šunen zako mariba hem da vaćeri pe e maribnastar, ma te daran. Adalese so adava valjani te ovel, ali adava pana nane kraj. ");
INSERT INTO rmna_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Adalese so ka uštel jekh nacija upri aver nacija hem jekh carstvo upro aver carstvo. Ko but thana ka ovel bokhalipe hem zemljotresija. ");
INSERT INTO rmna_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ali sai adava samo o anglunipe e bijandipnasere mukengoro. ");
INSERT INTO rmna_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Tegani o manuša ka den tumen te oven mučime hem ka mudaren tumen. Sa o nacije ka mrzinen tumen zbog mande. ");
INSERT INTO rmna_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Tegani but džene ka otperen oti vera, jekh avere ka izdajinen hem ka mrzinen. ");
INSERT INTO rmna_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ka ikljon but hovavne proroci hem buten ka hovaven. ");
INSERT INTO rmna_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Adalese so ka ovel baro bezakonje, butengoro mangipe ka šudrol. ");
INSERT INTO rmna_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ali kova ačhola verno đi o kraj, ka ovel spasime. ");
INSERT INTO rmna_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","A akava Šukar lafi e nebosere carstvostar ka vaćeri pe ki sa i phuv sar svedočanstvo sa e nacijenđe, i tegani ka avel o kraj. ");
INSERT INTO rmna_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Ađahar, kad ka dikhen da o ‘gadost savo anela uništenje’, savestar vaćerđa o proroko o Danilo, terđola ko Sveto Hram (ko akava čitini, nek haljol), ");
INSERT INTO rmna_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","tegani okola kola živinena ani e judejakiri regija nek našen ko gore. ");
INSERT INTO rmna_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ko ka ovel upro čher, ma te huljel te lel nešto taro čher! ");
INSERT INTO rmna_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ko ka ovel ki njiva, ma te irini pe čhere te lel plo fostani! ");
INSERT INTO rmna_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Pharo ka ovel e khamnjenđe hem okolenđe kola dena čuči ko adala dive! ");
INSERT INTO rmna_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Molinen tumen tumaro našiba te na ovel ko jevend ili ko savato, ");
INSERT INTO rmna_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","adalese so tegani ka ovel bari nevolja, savi na inele taro anglunipe e svetosoro đi akana, ni nikad palo adava naka ovel. ");
INSERT INTO rmna_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","I te na skratini ine o Gospod o broj adale divengoro, niko naka spasini pe ine. Ali zbog okola kolen o Devel birinđa, adala dive ka oven skratime.” ");
INSERT INTO rmna_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Te phenđa tumenđe neko tegani: ‘Ače akatei o Hrist’, ili ‘Eče adari’, ma verujinen. ");
INSERT INTO rmna_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Adalese so ka ikljon hovavne hristija hem hovavne proroci hem ka ćeren bare znakija hem čudesija sar, te šaj ine, te hovaven hem e Devlesere birimen. ");
INSERT INTO rmna_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Eče, vaćerđum tumenđe angleder o vreme. ");
INSERT INTO rmna_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Adalese, te vaćerde tumenđe: ‘Ečei ki pustinja’, ma džan adari; ili ‘Ačei ko garavde sobe’, ma verujinen. ");
INSERT INTO rmna_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Adalese so o mothojba mlo, e Manušesere Čhavesoro, ka ovel sar kad i munja čhinela taro istok hem dičhola đi ko zapad. ");
INSERT INTO rmna_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Adava ka ovel jasno ađahar sar kad o lešinarija čedena pe adari kaj isi mulo telo. ");
INSERT INTO rmna_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","A odmah palo nevolje adale divengere, ‘O kham ka kaljol hem o masek naka sijajini, o čerenja ka peren taro nebo hem o zoralipa e nebosere ka oven potresime.’ ");
INSERT INTO rmna_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tegani ko nebo ka mothoj pe o znako e Manušesere Čhavesoro. Tegani sa o plemija ki phuv zorale ka roven hem ka dikhen e Čhave e manušesere, sar avela upro oblaci e nebosere ano zoralipe hem ani bari slava. ");
INSERT INTO rmna_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Hem ka bičhali ple anđelen e trubencar savei glasna hem on ka čeden lesere birimen taro sa o štar strane e phuvjakere, taro jekh krajo e nebosoro đi ko aver.” ");
INSERT INTO rmna_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“A oti smokva sikljoven akava: Kad lakere granke zrelonena hem ikljona listija upro lende, džanena dai paše o linaj. ");
INSERT INTO rmna_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ađahar hem tumen kad dikhena da ovela sa adava, te džanen dai mlo aviba paše, dai anglo udar. ");
INSERT INTO rmna_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Čače vaćerava tumenđe, akaja generacija naka nakhel đikote sa adava na ovela. ");
INSERT INTO rmna_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","O nebo hem i phuv ka nakhen, ali mle lafija nikad naka nakhen.” ");
INSERT INTO rmna_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“A niko na džanel adava dive hem adava sati kad adava ka ovel. Na džanen ni o anđelja ko nebo ni o Čhavo. Džanel samo o Dad. ");
INSERT INTO rmna_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Sar so inele ano vreme kad o Noje živinđa, ađahar ka ovel hem kad me, o Čhavo e manušesoro, ka avav. ");
INSERT INTO rmna_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Sar so ano adava vreme, angleder o baro pani, o manuša hana ine hem pijena, lena pe hem dena pe sa đi o dive kad o Noje đerdinđa ki barka, ");
INSERT INTO rmna_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","a on ništa na džande đikote na alo o baro pani hem na legarđa sarijen – ađahar ka ovel hem kad o Čhavo e manušesoro ka mothoj pe. ");
INSERT INTO rmna_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Tegani duj džene ka oven ki njiva. Jekhe ka lel pe, a e dujtone ka ačhaj pe. ");
INSERT INTO rmna_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Duj đuvlja ka ćeren buti ano mlin. Jekha ka lel pe, a e dujtona ka ačhaj pe. ");
INSERT INTO rmna_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Adalese džangale pazinen, adalese so na džanen ko savo dive ka avel tumaro Gospod. ");
INSERT INTO rmna_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ali akava te džanen: te džanel ine o domaćini ko savo sati prekali rat avela o čor, ka ovel ine džangalo hem naka mukel lese ine te đerdini ko čher te čorel. ");
INSERT INTO rmna_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Adalese hem tumen oven spremna, adalese so o Čhavo e manušesoro ka avel tegani kad na nadinena tumen!” ");
INSERT INTO rmna_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“O verno hem o mudro slugai okova kas o gospodari šaj te čhivel upreder ple sluge te del len hajba ko vreme. ");
INSERT INTO rmna_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Blago adale slugase kas lesoro gospodari, kad ka avel, ka arakhi sar ćerela ađahar. ");
INSERT INTO rmna_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Čače vaćerava tumenđe, upreder sa o barvalipe plo ka čhivel le sar upravniko. ");
INSERT INTO rmna_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ali tei adava sluga bišukar hem vaćeri ana peste: ‘Naka avel pana mlo gospodari’, ");
INSERT INTO rmna_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","i lela te marel avere slugen, hem te hal hem te pijel e mate manušencar, ");
INSERT INTO rmna_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","lesoro gospodari ka avel ano okova dive hem okova sati kad naka adžićeri le, ");
INSERT INTO rmna_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ka čhinel le ko ekvaš hem ka čhivel le maškaro dujemujengere manuša, kote ka ovel baro rojba hem krciba e dandengoro tari dukh.” ");
INSERT INTO rmna_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","O Isus phenđa: “Tegani o carstvo e nebosoro ka ovel sar kad o deš čhaja lelje pumare svetiljke hem iklile anglo mladoženja. ");
INSERT INTO rmna_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Pandž olendar inele diline, a pandž mudra. ");
INSERT INTO rmna_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","O diline čhaja lelje pumare svetiljke, ali na lelje pumencar ulje, ");
INSERT INTO rmna_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","a o mudra čhaja lelje pumencar hem o svetiljke hem o ulje ano čare. ");
INSERT INTO rmna_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Adalese so o mladoženja harinđa, sa e čhajengere jaćha phandljona ine hem zasuće. ");
INSERT INTO rmna_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","A ki ekvaš i rat šundilo: ‘Ače o mladoženja! Ikljoven anglo leste!’ ");
INSERT INTO rmna_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Tegani sa o čhaja uštine hem pripreminde pumare svetiljke. ");
INSERT INTO rmna_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","A o diline čhaja phende e mudronenđe: ‘Den amen hari oto tumaro ulje, adalese so amare svetiljke mudarđona.’ ");
INSERT INTO rmna_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ali o mudra čhaja phende: ‘Našti! Adalese so naka ovel dovoljno hem amenđe hem tumenđe. Po šukar ka ovel tumenđe te džan te činen tumenđe ulje koro okola so biknena.’ ");
INSERT INTO rmna_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ali kad džele te činen, reslo o mladoženja, i okola čhaja kola inele spremna đerdinde oleja ko than e bijavesoro, hem o udar phandlilo. ");
INSERT INTO rmna_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","A palo adava ale hem okola avera čhaja vaćerindoj: ‘Gospodarona! Gospodarona, phrav amenđe!’ ");
INSERT INTO rmna_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","A ov phenđa lenđe: ‘Čače vaćerava tumenđe: Na pendžarava tumen.’ ");
INSERT INTO rmna_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Adalese džangale pazinen, adalese so na džanen ni o dive ni o sati kad ka avav!” ");
INSERT INTO rmna_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Adalese so o carstvo e nebosoroi sar kad jekh manuš ko džajba ko drom, vičinđa ple slugen hem muklja lenđe ano vasta plo barvalipe. ");
INSERT INTO rmna_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Jekhese dinđa pandž kese zlatoja, e dujtonese duj, a e tritonese jekh – svakonese dinđa palo adava kobori sposobna, i dželo ko drom. ");
INSERT INTO rmna_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","O sluga kase dinđa pandž kese zlatoja odmah dželo, ćerđa buti olencar hem zaradinđa pana pandž kese zlatoja. ");
INSERT INTO rmna_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ađahar hem okova kase dinđa duj kese zlatoja zaradinđa pana duj. ");
INSERT INTO rmna_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","A o sluga kase dinđa jekh kesa zlatoja dželo, handlja rupa ani phuv hem adari garavđa ple gospodaresere pare. ");
INSERT INTO rmna_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Palo but vreme o gospodari irinđa pe hem rodinđa e slugendar te mothoven lese so ćerde adaleja so dinđa len. ");
INSERT INTO rmna_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Okova kase dinđa pandž kese zlatoja alo hem anđa pana pandž vaćerindoj: ‘Gospodarona, dinđan man pandž kese zlatoja, a me, ače, zaradinđum pana pandž.’ ");
INSERT INTO rmna_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","O gospodari phenđa lese: ‘But šukar! Tu injan šukar hem verno sluga. Injanle maje verno ko hari hem adalese ka čhivav tut te upravine ko but. Ava hem radujin tut te gospodareja.’ ");
INSERT INTO rmna_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Tegani alo okova kase dinđa duj kese zlatoja hem phenđa: ‘Gospodarona, dinđan man duj kese zlatoja, a me, ače, zaradinđum pana duj.’ ");
INSERT INTO rmna_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","O gospodari phenđa lese: ‘But šukar! Tu injan šukar hem verno sluga. Injanle maje verno ko hari hem adalese ka čhivav tut te upravine ko but. Ava hem radujin tut te gospodareja.’ ");
INSERT INTO rmna_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Tegani alo okova kase dinđa jekh kesa zlatoja hem phenđa: ‘Gospodarona, džanav so injan pharo manuš. Čedeja kaj na sejinđan hem čedeja kaj na sadinđan. ");
INSERT INTO rmna_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Adalese darandiljum, i dželjum hem garavđum ti kesa zlatoja ani phuv. Ače, le la.’ ");
INSERT INTO rmna_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ali o gospodari phenđa lese: ‘Tu injan bišukar hem lenjo sluga! Džane da čedava kaj na sejinđum hem da čedava kaj na sadinđum. ");
INSERT INTO rmna_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Adalese valjanđan te de mle pare ki kamata, i me irindoj čhere ka lav ine soi mlo hem ka ovel man ine zarada. ");
INSERT INTO rmna_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Adalese len olestar i kesa zlatoja hem den la okolese kas isi deš kese zlatoja. ");
INSERT INTO rmna_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Adalese so, svakone kas isi, ka del pe lese pana hem ka ovel le but, a okole kas nane ka lel pe lestar hem adava so isi le. ");
INSERT INTO rmna_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Akale sluga kova nane korisno – frden le avri ani naj dur tomina, kote ka ovel baro rojba hem krciba e dandengoro tari dukh.’ ” ");
INSERT INTO rmna_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Kad me, o Čhavo e manušesoro ka avav ani slava hem mle anđelencar, ka bešav ko mlo slavno tron. ");
INSERT INTO rmna_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tegani sa o nacije ka čeden pe angla mande, a me ka cidav jekhen averendar sar so o pastiri cidela e bakren e buznjendar. ");
INSERT INTO rmna_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","E pravednikonen ka čhivav maje oti desno strana, a averen maje oti levo. ");
INSERT INTO rmna_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Tegani me, o caro, ka vaćerav okolenđe oti desno strana: ‘Aven, tumen kolen mlo Dad blagoslovinđa, hem nasledinen o carstvo, savoi pripremime tumenđe pana taro ćeriba e svetosoro! ");
INSERT INTO rmna_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Adalese so, dinđen man te hav kad injumle bokhalo, dinđen man te pijav kad injumle žedno, leljen man sar gosto kad injumle abanđija, ");
INSERT INTO rmna_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","hem urjavđen man kad injumle nango; injenle adathe te dikhen man kad injumle namborme hem aljen kora mande kad injumle ano phandlipe.’ ");
INSERT INTO rmna_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Tegani o pravednici ka pučen man: ‘Gospode, kad dikhljam tut bokhale hem dinđam tut te ha, kad dikhljam tut žednone hem dinđam tut te pije? ");
INSERT INTO rmna_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kad dikhljam tut sar abanđija hem leljam tut sar gosto, kad dikhljam tut nange hem urjavđam tut? ");
INSERT INTO rmna_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Hem kad dikhljam tut namborme hem ano phandlipe hem aljam te dikha tut?’ ");
INSERT INTO rmna_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","A me, o caro, ka phenav lenđe: ‘Čače vaćerava tumenđe, sa so ćerđen jekhese akale mle najtikore phraljendar, maje ćerđen!’ ");
INSERT INTO rmna_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Tegani ka phenav okolenđe oti levo strana: ‘Džan mandar, tumen kola injen prokleta, ani večno jag, savi pripremime e bengese hem lesere anđelenđe! ");
INSERT INTO rmna_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Adalese so, injumle bokhalo, a tumen na dinđen man te hav; injumle žedno, a tumen na dinđen man te pijav. ");
INSERT INTO rmna_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Injumle abanđija, a tumen na leljen man sar gosto; injumle nango, a tumen na urjavđen man. Injumle namborme hem ano phandlipe, a tumen na aljen te dikhen man.’ ");
INSERT INTO rmna_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Tegani hem on ka pučen: ‘Gospode, kad dikhljam tut bokhale ili žednone, sar abanđija ili nange, namborme ili ano phandlipe, a na pomožinđam će?’ ");
INSERT INTO rmna_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","A me ka phenav lenđe: ‘Čače vaćerava tumenđe, sa so na ćerđen jekhese akale najtikorendar, na ćerđen ni maje.’ ");
INSERT INTO rmna_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ađahar on ka džan ki večno kazna, a o pravedna ko večno dživdipe.” ");
INSERT INTO rmna_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","I kad o Isus završinđa sa ple vaćeribnaja, phenđa ple učenikonenđe: ");
INSERT INTO rmna_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Džanena soi zako duj dive o prazniko Pasha. Tegani man, e Čhave e manušesere, ka den te ovav čhivdo ko krsto.” ");
INSERT INTO rmna_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tegani o šerutne sveštenici hem o starešine e jevrejengere čedinde pe ko boro e prvosveštenikosoro kova vičinđa pe Kajafa ");
INSERT INTO rmna_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","hem dogovorinde pe ko hovavne te dolen e Isuse hem te mudaren le. ");
INSERT INTO rmna_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","I phende: “Naka ćera adava zako vreme e praznikosoro, te na pobunini pe o narodo.” ");
INSERT INTO rmna_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","A o Isus inele ano gav Vitanija, ano čher e Simonesoro e Gubavcosoro. ");
INSERT INTO rmna_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","I sar inele uzalo astali, ali koro leste jekh đuvli e čareja savo inele ćerdo oto šužo bar, ano savo inele skupo mirisno ulje hem čhorđa le upro lesoro šero. ");
INSERT INTO rmna_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Kad o učenici dikhle adava, lelje te holjanen vaćerindoj: “Sose esavko bespotrebno čhoriba? ");
INSERT INTO rmna_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Bute parenđe šaj ine te biknel pe adava, a o pare te den pe e čororenđe.” ");
INSERT INTO rmna_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","A o Isus džanđa sostar vaćerena, i pučlja len: “Sose uznemirinena akala đuvlja? Oj ćerđa maje šukaripe. ");
INSERT INTO rmna_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Adalese so o čorore manuša uvek ka oven uzala tumende, a me naka ovav uvek tumencar. ");
INSERT INTO rmna_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Čhorđa akava mirisno ulje upra mande te pripremini mlo telo zako paruniba. ");
INSERT INTO rmna_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Čače vaćerava tumenđe, kaj god ki sa i phuv ka vaćeri pe akava Šukar lafi, ka vaćeri pe hem akalestar so oj ćerđa, sar setiba olatar.” ");
INSERT INTO rmna_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tegani jekh oto dešu duj apostolja – okova kova vičinđa pe Juda Iskariot – dželo koro šerutne sveštenici ");
INSERT INTO rmna_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","hem pučlja len: “Kobor ka den man pare te izdajinav tumenđe e Isuse?” I on dinde le trijanda srebrna kovanice. ");
INSERT INTO rmna_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","I otegani o Juda lelja te rodel šukar prilika te izdajini e Isuse. ");
INSERT INTO rmna_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","A ko prvo dive oto Prazniko e bikvascone marengoro o učenici pučle e Isuse: “Kaj mangeja te ćera će te ha e pashakoro hajba?” ");
INSERT INTO rmna_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","A o Isus phenđa lenđe: “Džan ki diz koro adava hem adava manuš hem vaćeren lese: ‘O učitelj vaćeri: Mloi vreme paše. Kora tute ka slavinav i Pasha mle učenikonencar.’ ” ");
INSERT INTO rmna_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","I o učenici ćerde sar so phenđa lenđe o Isus hem adari ćerde zako hajba e pashakoro. ");
INSERT INTO rmna_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kad peli i rat, o Isus čhivđa pe uzalo astali ple dešu duje apostolencar. ");
INSERT INTO rmna_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","I sar hana ine, o Isus phenđa lenđe: “Čače vaćerava tumenđe, jekh tumendar ka izdajini man!” ");
INSERT INTO rmna_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","On but rastužisale, i lelje jekh palo avereste te pučen le: “Te na injum me adava, Gospode?” ");
INSERT INTO rmna_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","A ov phenđa lenđe: “Okova kova mancar macinđa o maro ano čaro, ov ka izdajini man. ");
INSERT INTO rmna_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Čače, o Čhavo e manušesoro valjani te merel sar so pisini ano Sveto lil, ali jao okole manušese kova ka izdajini le! Po šukar ka ovel lese te na ovel ine bijando!” ");
INSERT INTO rmna_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","A lesoro izdajniko o Juda pučlja: “Te na injum me adava, Učitelju?” A o Isus phenđa lese: “Ađahari sar so phenđan.” ");
INSERT INTO rmna_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Sar hana ine, o Isus lelja o maro, zahvalinđa e Devlese hem phaglja le, i dinđa le e učenikonenđe, vaćerindoj: “Len hem han! Akavai mlo telo.” ");
INSERT INTO rmna_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tegani lelja i čaša e moljaja, zahvalinđa e Devlese hem dinđa la olenđe, vaćerindoj: “Pijen olatar sare! ");
INSERT INTO rmna_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Adalese so akavai mlo rat oto savez, savo čhorela pe butenđe, zako oprostiba e grehengoro. ");
INSERT INTO rmna_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","I vaćerava tumenđe da naka pijav više oti akaja mol sa đi o dive kad ka pijav tumencar i nevi mol ano carstvo mle Dadesoro.” ");
INSERT INTO rmna_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Tegani đilabde psalmija, i džele ki e Maslinakiri gora. ");
INSERT INTO rmna_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Tegani o Isus phenđa lenđe: “Erat sare ka ačhaven man, adalese soi pisime ano Sveto lil: ‘Ka mudarav e pastire, hem o bakre ka našen taro stado.’ ");
INSERT INTO rmna_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ali kad ka uštav taro mule, ka džav angla tumende ki Galileja.” ");
INSERT INTO rmna_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","A o Petar phenđa lese: “I sare te ačhavde tut, me naka ačhavav tut!” ");
INSERT INTO rmna_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","O Isus phenđa lese: “Čače vaćerava će, ki akaja rat, angleder so o bašno ka đilabi, trin puti ka hovave da na pendžareja man.” ");
INSERT INTO rmna_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","O Petar phenđa lese: “Naka ćerav adava, čak hem te valjanđum te merav tuja.” I ađahar vaćerde sa o učenici. ");
INSERT INTO rmna_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Tegani o Isus dželo ple učenikonencar ko than vičime Getsimanija, i phenđa lenđe: “Bešen akate đikote me džava adari hem molinav man.” ");
INSERT INTO rmna_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Peja lelja e Petre hem soduje čhaven e Zevedejeseren. Pelo lese žal hem pharipe, ");
INSERT INTO rmna_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","i phenđa lenđe: “Edobor injum žalosno da mlo vilo ka pharjol! Ačhoven akate hem džangale pazinen mancar.” ");
INSERT INTO rmna_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","I dželo hari po dur, pelo mujeja đi phuv hem molinđa pe vaćerindoj: “Dade mleja, te šaj, cide akaja čaša e patnjaja mandar. Ali, nek ovel pali ti volja, a na pali mli.” ");
INSERT INTO rmna_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Tegani irinđa pe koro učenici hem arakhlja len sar sovena, i phenđa e Petrese: “Ah, našti li ine nijekh sati džangale te pazinen mancar! ");
INSERT INTO rmna_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Džangale pazinen hem molinen tumen te na peren ko iskušenje. O duho mangela te ćerel okova soi šukar, ali o teloi bizoralo.” ");
INSERT INTO rmna_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","I palo dujto puti dželo hem molinđa pe vaćerindoj: “Dade mleja, te našti te cide mandar akaja čaša e patnjaja, te na pijav olatar, nek ovel pali ti volja.” ");
INSERT INTO rmna_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","I palem, kad irinđa pe, arakhlja len sar sovena adalese so phandljona ine lengere jaćha. ");
INSERT INTO rmna_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ov ačhavđa len hem palem dželo po dur, i trito puti molinđa pe, vaćerindoj ista lafija. ");
INSERT INTO rmna_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tegani irinđa pe koro učenici hem phenđa lenđe: “Pana li sovena hem odmorinena? Ače, alo o sati kad me, o Čhavo e manušesoro, ka ovav dindo ko vasta e grešnikonengere. ");
INSERT INTO rmna_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ušten! Hajde! Ače mlo izdajniko avela.” ");
INSERT INTO rmna_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","I sar pana o Isus vaćeri ine adava, alo o Juda, jekh e dešu duje apostolendar, hem oleja but džene, e mačencar hem e kaštencar, kolen bičhalde o šerutne sveštenici hem o starešine e jevrejengere. ");
INSERT INTO rmna_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","A o Juda, lesoro izdajniko dinđa len znako vaćerindoj: “Kas ka čumudinav – ovi adava. Ole dolen.” ");
INSERT INTO rmna_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","I odmah alo đi o Isus hem phenđa: “Zdravo, učitelju”, hem čumudinđa le ki čham. ");
INSERT INTO rmna_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","A o Isus phenđa lese: “Amala, ćer okova savese aljan.” Tegani o manuša ale, dolinde e Isuse hem phandle le. ");
INSERT INTO rmna_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","I dikh, jekh okolendar kola inele e Isuseja dolinđa pe ko mači, ikalđa le hem khuvđa oleja e prvosveštenikosere sluga hem čhinđa lesoro kan. ");
INSERT INTO rmna_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tegani o Isus phenđa lese: “Irin o mači olese ko than, adalese so sare kola dolena pe ko mači, oto mači ka meren. ");
INSERT INTO rmna_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Tu li mislineja da me našti te rodav mle Dadestar te bičhali maje akana više oto dešu duj armije anđelen? ");
INSERT INTO rmna_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ali te ćerđum adava, sar ka pherđon o Sveta lila save vaćerena da valjani te ovel ađahar?” ");
INSERT INTO rmna_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Tegani phenđa e manušenđe: “Mačencar hem kaštencar aljen pala mande te dolen man, sar palo pobunjeniko. Divencar ano Hram bešljum hem sikavđum e narodo, i na dolinđen man. ");
INSERT INTO rmna_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ali, sa akava ulo sar te pherđol okova so mandar pisinde o proroci.” Tegani sa o učenici ačhavde le hem našle. ");
INSERT INTO rmna_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Okola kola dolinde e Isuse, legarde le koro prvosvešteniko o Kajafa, kora kaste čedinde pe o učitelja e Zakonestar hem o starešine. ");
INSERT INTO rmna_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","O Petar odural džala ine palo Isus sa đi ko boro e prvosveštenikosoro, i đerdinđa andre hem bešlo e slugencar te dikhel so ka ovel. ");
INSERT INTO rmna_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","A o šerutne sveštenici hem sa o sabor rodena ine nesavo hovavno svedočiba protiv o Isus sar te šaj ćeren te ovel mudardo, ");
INSERT INTO rmna_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ali našti ine te arakhen le, iako ale but hovavne svedoci. A ko kraj ale duj džene ");
INSERT INTO rmna_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","hem phende: “Akava manuš phenđa: ‘Šaj te peravav o Hram e Devlesoro hem zako trin dive palem te vazdav le.’ ” ");
INSERT INTO rmna_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","I o prvosvešteniko uštino hem pučlja e Isuse: “Tut li nane so te phene ko akava so vaćerde protiv tute?” ");
INSERT INTO rmna_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","A o Isus trainđa. I o prvosvešteniko phenđa lese: “Hava tut sovli upro dživdo Devel, phen amenđe tu li injan o Hrist, o Čhavo e Devlesoro?” ");
INSERT INTO rmna_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","O Isus phenđa: “Ađahari sar so phenđan. Ali vaćerava tumenđe: Od akana ka dikhen man, e Čhave e manušesere, sar bešava ko počasno than, oti desno strana e Najzorale Devlesiri hem sar avava upro oblaci e nebosere.” ");
INSERT INTO rmna_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Tegani o prvosvešteniko pharavđa ple šeja hem phenđa: “Hulinđa upro Devel! Na valjani amenđe više svedoci! Ače, akana šunđen i hula! ");
INSERT INTO rmna_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","So mislinena?” A on phende: “Zaslužini te merel!” ");
INSERT INTO rmna_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tegani čhungarde le ko muj hem khuvde le dumukhencar. A nesave khuvena le ine šamarke, ");
INSERT INTO rmna_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","vaćerindoj: “Hriste, prorokujin amenđe ko khuvđa tut!” ");
INSERT INTO rmna_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","I sar o Petar bešela avri ano boro, ali nakoro leste jekh sluškinja hem phenđa: “Hem tu injanle e Isuseja tari Galileja!” ");
INSERT INTO rmna_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","A o Petar anglo sarijende hovavđa vaćerindoj: “Na džanav sostar vaćereja!” ");
INSERT INTO rmna_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Kad iklilo angli kapija, dikhlja le jekh aver sluškinja, i phenđa okolenđe kola inele adari: “Akava inele e Isuseja e Nazarećanineja!” ");
INSERT INTO rmna_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","O Petar palem hovavđa hem pana halja sovli: “Na pendžarava adale manuše!” ");
INSERT INTO rmna_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Na nakhlo but palo adava, okola kola terđona ine adari ale nakoro Petar hem phende: “Tu čače injan jekh olendar! Izdajini tut to vaćeriba!” ");
INSERT INTO rmna_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tegani o Petar lelja te vičini prokletstvija upra peste hem te hal pe sovli: “Na pendžarava adale manuše!” I odmah o bašno đilabđa. ");
INSERT INTO rmna_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tegani o Petar setinđa pe e Isusesere lafendar: “Angleder so o bašno ka đilabi, trin puti ka hovave da na pendžareja man.” I iklilo taro boro hem zorale runđa. ");
INSERT INTO rmna_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Rano sabale, sa o šerutne sveštenici hem o starešine e jevrejengere dogovorinde pe te mudaren e Isuse. ");
INSERT INTO rmna_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Phandle le, i legarde le hem dinde le ko Pilat, ko upravniko e rimesoro. ");
INSERT INTO rmna_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Kad o Juda, olesoro izdajniko, dikhlja soi o Isus osudime ko meriba, pelo lese žal hem irinđa o trijanda srebrna kovanice e šerutne sveštenikonenđe hem e starešinenđe, ");
INSERT INTO rmna_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","vaćerindoj: “Grešinđum! Izdajinđum e manuše kova nane krivo.” On phende lese: “Nane adava amari briga. Adavai to stvaro.” ");
INSERT INTO rmna_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","I o Juda frdinđa o srebrna kovanice ano Hram, i dželo hem obesinđa pe. ");
INSERT INTO rmna_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","O šerutne sveštenici lelje o srebrna kovanice, vaćerindoj: “Nane muklo te čhiva len ani blagajna e hramesiri, adalese so inele plata zako rat.” ");
INSERT INTO rmna_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Adalese dogovorinde pe olencar te činen e Čarutnesiri njiva, te ovel than kote ka parunen pe o abanđije. ");
INSERT INTO rmna_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Adalese adaja njiva hem avdive vičini pe “Ratvali njiva.” ");
INSERT INTO rmna_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ađahar pherdilo okova so phenđa o proroko o Jeremija: “Lelje o trijanda srebrna kovanice, edobor proceninde le o Izraelci, ");
INSERT INTO rmna_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","hem činde e Čarutnesiri njiva, sar so o Gospod naredinđa maje.” ");
INSERT INTO rmna_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","A o Isus terdino anglo e rimesoro upravniko, kova pučlja le: “Tu li injan o caro e Jevrejengoro?” A o Isus phenđa: “Ađahari sar so pheneja.” ");
INSERT INTO rmna_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","O šerutne sveštenici hem o starešine tužinena ine e Isuse, a ov ništa na vaćeri ine. ");
INSERT INTO rmna_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Tegani o Pilat pučlja le: “Tu li na šuneja so vaćerena sa adava protiv tute?” ");
INSERT INTO rmna_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ali o Isus nijekh lafi na vaćerđa lese, i o upravniko but začudinđa pe. ");
INSERT INTO rmna_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","A e upravniko e Pilate inele adeti ko prazniko Pasha te mukel e narodose jekhe manuše taro phandlipe kole on mangle. ");
INSERT INTO rmna_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ko adava vreme jekh e prešunde phandlendar inele o Varava. ");
INSERT INTO rmna_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kad o narodo čedinđa pe, o Pilat pučlja len: “Kas mangena te mukav tumenđe: e Varava ili e Isuse vičime Hrist?” ");
INSERT INTO rmna_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Adalese so džanđa so e Isuse predinde tari zavist. ");
INSERT INTO rmna_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Sar o Pilat bešela ine ki stolica e sudosiri, reslo lese lafi lesere romnjatar: “Muk tut adale manušestar kovai nevino, adalese so erat ano suno but mučinđum man zbog leste.” ");
INSERT INTO rmna_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ali o šerutne sveštenici hem o starešine pherde e narodo te roden o Varava te ovel muklo, a o Isus te ovel mudardo. ");
INSERT INTO rmna_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","O upravniko pučlja len: “Kas akale dujendar mangena te mukav tumenđe?” On phende: “E Varava!” ");
INSERT INTO rmna_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","O Pilat pučlja len: “A so te ćerav e Isuseja vičime Hrist?” On sare vičinde: “Čhiv le ko krsto!” ");
INSERT INTO rmna_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","A ov phenđa: “A savo bišukaripe ćerđa?” Ali on pana po zorale vičinde: “Čhiv le ko krsto!” ");
INSERT INTO rmna_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Kad o Pilat dikhlja da ništa na pomožini, nego da sa po bari pobuna ovela, lelja o pani hem anglo narodo thovđa ple vasta, vaćerindoj: “Me na injum krivo zako rat akale manušesoro – adavai tumaro stvaro!” ");
INSERT INTO rmna_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","A sa o narodo phenđa: “Nek lesoro rat perel upro amende hem upro amare čhavende!” ");
INSERT INTO rmna_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","O Pilat tegani muklja lenđe e Varava, a e Isuse dinđa ko vojnici te šibinen le hem palo adava te čhiven le ko krsto. ");
INSERT INTO rmna_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tegani e upravnikosere vojnici legarde ki lesiri palata e Isuse, i uzalo leste čedinde sa i četa e vojnikonendar. ");
INSERT INTO rmna_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Huljavde le hem čhivde upro leste lolo ogrtači. ");
INSERT INTO rmna_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","I ćerde kruna oto kare hem čhivde lese ko šero, a ko desno vas trska. Tegani pele ko kočija anglo leste, i lelje te maren muj oleja, vaćerindoj: “Te ove sasto, e jevrejengere carona!” ");
INSERT INTO rmna_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","I čhungarena le ine, hem lelje i trska hem khuvena le ine olaja ko šero. ");
INSERT INTO rmna_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","I palo adava so marde muj oleja, huljavde lestar o ogrtači, hem urjavde le lesere šeja, i legarde le te čhiven le ko krsto. ");
INSERT INTO rmna_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Iklindoj, resle jekhe manuše tari Kirinija palo anav Simon hem terinde le te akhari e Isusesoro krsto. ");
INSERT INTO rmna_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Kad resle đi ko than vičime Golgota – so značini “Kokalo e šeresoro”, ");
INSERT INTO rmna_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","dinde e Isuse te pijel mol mešimi nesaveja so inele but ćerko, ali kad čhivđa ano muj, na manglja te pijel la. ");
INSERT INTO rmna_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","I kad čhivde le ko krsto, frdinde barbuti hem ađahar delinde maškara pumende lesere šeja. ");
INSERT INTO rmna_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","I bešena ine adari te arakhen le. ");
INSERT INTO rmna_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Upreder lesoro šero čhivde znako kote inele pisime lesiri krivica: Akavai o Isus, o caro e jevrejengoro . ");
INSERT INTO rmna_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Tegani oleja čhivde ko avera krstija hem duje pobunjenikonen, jekhe oti lesiri desno, a e dujtone oti lesiri levo strana. ");
INSERT INTO rmna_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","A okola kola nakhena ine adale dromeja vređinena le ine. Mrdinena ine šerencar, ");
INSERT INTO rmna_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","vaćerindoj: “Tu kova peraveja o Hram hem vazdeja le zako trin dive, spasin tut! Hulji taro krsto te injan o Čhavo e Devlesoro!” ");
INSERT INTO rmna_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ađahar da marde muj oleja o šerutne sveštenici, o učitelja e Zakonestar hem o starešine, vaćerindoj: ");
INSERT INTO rmna_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Averen spasinđa, a pes našti te spasini? Ovi o caro e Izraelesoro! Nek huljel akana taro krsto, i ka verujina ano leste. ");
INSERT INTO rmna_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nadini pe upro Devel! Nek o Devel akana spasini le te čače mangela le. Adalese so vaćerđa: ‘Me injum o Čhavo e Devlesoro.’ ” ");
INSERT INTO rmna_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ađahar da vređinena le ine hem o pobunjenici kola inele čhivde ko krsto oleja. ");
INSERT INTO rmna_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","A ko ekvaš o dive, i tomina učharđa sa i phuv hem ađahar inele trin saća. ");
INSERT INTO rmna_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kad inele đi ko trin o sati, o Isus vičinđa oto sa o glaso: “Eli, Eli, lema sabahtani?” (so značini: “Devla mleja, Devla mleja, sose ačhavđan man?”) ");
INSERT INTO rmna_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","A kad adava šunde okola kola terđona ine adari, phende: “Vičini e proroko e Ilija.” ");
INSERT INTO rmna_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","I otojekhvar jekh olendar prastandilo, lelja o sunđeri, čhivđa le ani ušli mol, i čhivđa le upri trska hem kaninđa e Isuse te pijel. ");
INSERT INTO rmna_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","A avera phende: “Adžićer, te dikha ka avel li o Ilija te spasini le.” ");
INSERT INTO rmna_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","A o Isus palem vičinđa oto sa o glaso, i muklja pli duša. ");
INSERT INTO rmna_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","I otojekhvar e hramesiri zavesa pharavdili ko ekvaš, odupral natele. I phuv tresinđa pe hem o stene phađile. ");
INSERT INTO rmna_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","O grobija phravdile hem uštine taro mule but manuša e Devlesere. ");
INSERT INTO rmna_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Palo e Isusesoro uštiba taro mule on iklile taro grobija hem džele ki sveto diz hem mothovde pe butenđe. ");
INSERT INTO rmna_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","A kad e rimesoro kapetani hem okola kola oleja arakhena ine e Isuse dikhle o zemljotres hem sa so ulo, but darandile hem phende: “Čače akava manuš inele e Devlesoro Čhavo!” ");
INSERT INTO rmna_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","A adari inele hem but đuvlja kola sa adava dikhena ine odural. On pana tari Galileja džana ine palo Isus hem kandena le. ");
INSERT INTO rmna_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Maškar olende inele i Marija Magdalena, i Marija e Jakovesiri hem e Josifesiri daj, hem i daj e Zevedejesere čhavengiri. ");
INSERT INTO rmna_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Kad peli i rat, alo jekh barvalo manuš tari diz Arimateja palo anav Josif, kova hem korkoro inele učeniko e Isusesoro. ");
INSERT INTO rmna_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ov dželo koro Pilat hem rodinđa te den le o telo e Isusesoro, i o Pilat naredinđa te den le. ");
INSERT INTO rmna_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","O Josif lelja o telo, paćarđa le neve čaršaveja ");
INSERT INTO rmna_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","hem čhivđa le ano plo nevo grobo savo inele ćerdo ani stena. Hem o udar e grobosoro phandlja e bare bareja, i dželo. ");
INSERT INTO rmna_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","A adari inele i Marija Magdalena hem i aver Marija kola bešena ine dikhindoj nakoro grobo. ");
INSERT INTO rmna_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Tejsato dive, ko savato, o šerutne sveštenici hem o fariseja čedinde pe koro Pilat ");
INSERT INTO rmna_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","hem phende lese: “Gospodarona, setinđam amen so okova hovavno kad inele dživdo phenđa: ‘Palo trin dive ka uštav taro mule’. ");
INSERT INTO rmna_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Adalese naredin o grobo te ovel osigurime sa đi ko trito dive, te na aven lesere učenici hem te čoren o telo, i te phenen e narodose: ‘Uštino taro mule!’ Te ulo ađahar, adava hovajba ka ovel po baro e prvonestar.” ");
INSERT INTO rmna_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","O Pilat phenđa lenđe: “Isi tumen stražarija. Džan hem osigurinen o grobo sar džanen.” ");
INSERT INTO rmna_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Tegani džele hem osigurinde o grobo ađahar so zapečatinde o bar hem čhivde stražaren. ");
INSERT INTO rmna_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Palo savato, rano sabale ko prvo dive oto kurko, i Marija Magdalena hem i aver Marija ale te dikhen o grobo. ");
INSERT INTO rmna_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Otojekhvar ulo baro zemljotres, adalese so o anđeo e Gospodesoro huljilo taro nebo, alo nakoro grobo, cidinđa o bar hem beštino upro leste. ");
INSERT INTO rmna_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","A ov sijajinđa sar i munja hem lesere šeja inele parne sar o hiv. ");
INSERT INTO rmna_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","A o stražarija oti dar lelje te tresinen hem ule sar mule. ");
INSERT INTO rmna_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Tegani o anđeo phenđa e đuvljenđe: “Tumen ma daran! Džanav so rodena e Isuse kova inele čhivdo ko krsto. ");
INSERT INTO rmna_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ov nane akate; uštino taro mule, ađahar sar so phenđa tumenđe. Aven hem dikhen o than kaj pašlilo, ");
INSERT INTO rmna_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","i sigate džan hem vaćeren lesere učenikonenđe: ‘Uštino taro mule hem ače džala angla tumende ki Galileja. Adari ka dikhen le.’ Eče, vaćerđum tumenđe.” ");
INSERT INTO rmna_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","I on ki sig džele taro grobo hem ani dar, ali hem ani bari radost prastandile te vaćeren adava lesere učenikonenđe. ");
INSERT INTO rmna_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Otojekhvar reslja len o Isus hem phenđa lenđe: “Zdravo!” A on ale nakoro leste, dolinde lesere pre hem pele ko kočija anglo leste. ");
INSERT INTO rmna_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Tegani o Isus phenđa lenđe: “Ma daran. Džan hem vaćeren mle phraljenđe te džan ki Galileja. Adari ka dikhen man.” ");
INSERT INTO rmna_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","I sar o đuvlja džana ine, nesave e stražarendar džele ki diz hem vaćerde e šerutne sveštenikonenđe sa so ulo. ");
INSERT INTO rmna_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","On čedinde pe e starešinencar hem dogovorinde pe te den but pare e vojnikonenđe. ");
INSERT INTO rmna_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Phende lenđe: “Vaćeren: ‘Sar amen sovaja ine, lesere učenici ale prekali rat hem čorde le.’ ");
INSERT INTO rmna_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","A te šunđa zako adava o upravniko, amen ka vaćera oleja hem ka pobrinina amen te na oven tumen problemija.” ");
INSERT INTO rmna_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","I on lelje o pare hem ćerde sar so inele sikavde. I adaja priča vaćerđa pe maškaro Jevreja sa đi akava dive. ");
INSERT INTO rmna_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","O dešujekh učenici džele ki Galileja, ki gora ki savi o Isus bičhalđa len te džan. ");
INSERT INTO rmna_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","I kad dikhle le, pele ko kočija anglo leste. Ali nesave sumnjinde. ");
INSERT INTO rmna_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Tegani o Isus alo nakoro lende hem phenđa lenđe: “Dindi maje sa i vlast ko nebo hem ki phuv. ");
INSERT INTO rmna_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Adalese džan hem ćeren e manušen oto sa o nacije te oven mle učenici, ađahar so ka krstinen len ano anav e Dadesoro hem e Čhavesoro hem e Svetone Duhosoro ");
INSERT INTO rmna_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","hem ađahar so ka sikaven len te ićeren sa so naredinđum tumenđe. I ače, me injum tumencar ano sa o dive, đi ko kraj e svetosoro.”");
INSERT INTO rmna_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Akavai o anglunipe oto Šukar lafi e Isuse Hristestar, e Devlesere Čhavestar. ");
INSERT INTO rmna_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Sar soi pisime ano Sveto lil e prorokosoro e Isaijasoro: “Ače, bičhalava mle glasniko angla tute, kova ka pripremini će o drom. ");
INSERT INTO rmna_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ovi o glaso so vičini ani pustinja: ‘Pripreminen o drom e Gospodese! Ravnonen lese o droma!’ ” ");
INSERT INTO rmna_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","I ađahar alo o Jovan o Krstitelj. Ov živini ine ani pustinja hem propovedini ine e manušenđe da valjani te pokajinen pe zako pumare grehija hem te oven krstime sar te mothoven dai lenđe oprostime o grehija. ");
INSERT INTO rmna_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","But manuša avena ine koro leste tari sa i regija Judeja hem taro Jerusalim. Priznajinena ine pumare grehija, a ov krstini len ine ani len Jordan. ");
INSERT INTO rmna_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","A e Jovanesere šeja inele ćerde oto bala e kamilakere, a ko maškar inele phandlo kožno pojas. Hala ine skakavconen hem divljo avđin. ");
INSERT INTO rmna_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Propovedinđa vaćerindoj: “Pala mande avela o po baro mandar, kase na injum dostojno ni te teljovav o dorikha oti lesiri obuća te phravav. ");
INSERT INTO rmna_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Me krstinava tumen panjeja, a ov ka krstini tumen e Svetone Duhoja.” ");
INSERT INTO rmna_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ko adava vreme o Isus alo tari diz Nazaret oti regija Galileja hem o Jovan krstinđa le ani len Jordan. ");
INSERT INTO rmna_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","I odmah palo adava so o Isus iklilo taro pani, dikhlja sar o nebo phravđola hem sar o Duho huljela upro leste sar golubi. ");
INSERT INTO rmna_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","A taro nebo šundilo o glaso e Devlesoro: “Tu injan mlo Čhavo o volime! Tuja injum bahtalo!” ");
INSERT INTO rmna_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","I odmah o Duho bičhalđa e Isuse ki pustinja, ");
INSERT INTO rmna_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","hem adari inele saranda dive, a o Sotoni kušini le ine. Adari inele maškaro divlja životinje, a o anđelja kandena le ine. ");
INSERT INTO rmna_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Palo adava so o Jovan inele čhivdo ano phandlipe, o Isus dželo ki Galileja hem propovedinđa o Šukar lafi e Devlesoro. ");
INSERT INTO rmna_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Vaćerđa: “Alo o vreme! Alo paše o carstvo e Devlesoro! Pokajinen tumen zako tumare grehija hem verujinen ano Šukar lafi!” ");
INSERT INTO rmna_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Sar o Isus nakhela ine uzalo e Galilejakoro jezero, dikhlja e Simone hem lesere phrale e Andreja sar frdena o mreže ano pani, adalese so inele manuša so dolena maćhen. ");
INSERT INTO rmna_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","I o Isus phenđa lenđe: “Phiren pala mande hem me ka ćerav tumen te dolen manušen sar maćhen!” ");
INSERT INTO rmna_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","On odmah ačhavde pumare mreže hem džele palo leste. ");
INSERT INTO rmna_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Kad džele adathar hari po dur, o Isus dikhlja e Zevedejesere čhaven, e Jakove hem e Jovane, sar bešena ano čamco hem popravinena pumare mreže. ");
INSERT INTO rmna_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","O Isus odmah vičinđa len, hem on ačhavde ano čamco pumare dade e Zevedeje e manušencar kola ćerena buti koro lende hem džele palo leste. ");
INSERT INTO rmna_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Kad ale ano Kafarnaum, o Isus odmah ko savato đerdinđa ki sinagoga hem lelja te sikaj e manušen. ");
INSERT INTO rmna_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","On inele zadivime lesere sikavibnaja, adalese so sikavđa sar okova kole isi autoritet, a na sar o učitelja e Zakonestar. ");
INSERT INTO rmna_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","I otojekhvar ani lengiri sinagoga jekh manuš kova inele opsednutime bišukare duhoja lelja te vičini: ");
INSERT INTO rmna_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“So mangeja amendar, Isuse Nazarećanine? Aljan li te uništine amen? Džanav ko tu injan: o Sveco e Devlesoro.” ");
INSERT INTO rmna_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","A o Isus ukorinđa le vaćerindoj: “Phand to muj hem ikljov olestar!” ");
INSERT INTO rmna_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Tegani o bišukar duho zorale tresinđa e manuše hem, vičindoj oto sa o glaso, iklilo olestar. ");
INSERT INTO rmna_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","I sare but začudinde pe, i lelje maškar pumende te vaćeren: “Savo li akava nevo sikaviba, hem adava ano autoritet? Đi e bišukare duhenđe naredini hem on šunena le!” ");
INSERT INTO rmna_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","I o glaso e Isusestar sig šundilo ko sa o thana ani regija Galileja. ");
INSERT INTO rmna_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","I so iklile tari sinagoga, o Isus e Jakoveja hem e Jovaneja dželo ko čher e Simonesoro hem e Andrejasoro. ");
INSERT INTO rmna_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Adari e Simonesiri sasuj pašlili, adalese so ine la bari jag, i odmah phende adava e Isusese. ");
INSERT INTO rmna_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","I o Isus alo uzalo late, dolinđa lakoro vas hem vazdinđa la. I jag muklja la, i oj lelja te poslužini len. ");
INSERT INTO rmna_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kad peli i rat, kad o kham huljilo, ande koro leste sa e nambormen hem e manušen ano kolende inele o demonja. ");
INSERT INTO rmna_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Sa o dizutne čedinde pe anglo udar, ");
INSERT INTO rmna_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","hem o Isus sasljarđa buten kola inele namborme oto razna nambormipa. Ispudinđa hem bute demonen, ali na muklja lenđe te vaćeren, adalese so džande koi ov. ");
INSERT INTO rmna_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Rano sabale, sar pana inele tomina, o Isus uštino, iklilo taro čher hem dželo ko jekh čučo than, hem adari molini pe ine. ");
INSERT INTO rmna_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","O Simon hem avera kola inele oleja lelje te roden le, ");
INSERT INTO rmna_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","i kad arakhle le, phende lese: “Sare rodena tut!” ");
INSERT INTO rmna_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ov phenđa lenđe: “Hajde te dža hem avrethe, ko avera pašutne gava, hem adari te propovedinav, adalese so zako adava aljum.” ");
INSERT INTO rmna_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","I ađahar džala ine maškar sa i Galileja hem propovedini ano lengere sinagoge hem ispudini e demonen. ");
INSERT INTO rmna_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","A jekh gubavco alo koro Isus, pelo ko kočija anglo leste hem phenđa: “Te mangeja, šaj te sasljare man!” ");
INSERT INTO rmna_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","E Isusese pelo žal, pružinđa plo vas, dolinđa le hem phenđa: “Mangava, ov sasljardo!” ");
INSERT INTO rmna_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Odmah i guba cidinđa pe olestar hem ov ulo sasto. ");
INSERT INTO rmna_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","O Isus odmah phenđa lese te džal, ali zorale upozorinđa le: ");
INSERT INTO rmna_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Dikh nikase te na vaćere akalestar, nego dža mothov tut e sveštenikose hem de žrtva zako to očistiba, sar so naredinđa o Mojsije, zako svedočanstvo olenđe.” ");
INSERT INTO rmna_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ali o manuš, samo so dželo adathar, lelja sarijenđe te vaćeri so ulo lese, i o Isus našti ine više te đerdini javno ki bilo savi diz, nego ačhola ine avri ko čuče thana. A palem o manuša avena ine koro leste taro sa o strane. ");
INSERT INTO rmna_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nekobor dive palo adava, kad o Isus irinđa pe ko Kafarnaum, ano čher kaj bešela ine, o manuša šunde dai ov adari. ");
INSERT INTO rmna_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","I edobor džene čedinde pe adari da na inele više than čak ni anglo udar. A ov propovedini lenđe ine o Lafi e Devlesoro. ");
INSERT INTO rmna_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tegani ale koro Isus štar manuša akharindoj jekhe manuše kova našti ine te phirel ni te mrdini. ");
INSERT INTO rmna_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","I sar taro narodo našti ine te aven anglo Isus, ćerde rupa ko tavani upreder o than kote inele o Isus prekali savi mukle e namborme sa e nosiljkaja ki savi pašlilo. ");
INSERT INTO rmna_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Kad o Isus dikhlja lengiri vera, phenđa e nambormese: “Mlo čhavo, oprostimei će te grehija!” ");
INSERT INTO rmna_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","A adari inele nesave učitelja e Zakonestar kola ana pumende pučle pe: ");
INSERT INTO rmna_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Sar šaj akava te vaćeri ađahar? Ov hulini! Ko šaj te oprostini o grehija sem o jekh Devel?” ");
INSERT INTO rmna_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","O Isus odmah džanđa ano plo duho so on ađahar mislinena, i pučlja len: “Sose ađahar mislinena? ");
INSERT INTO rmna_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Soi po lokhe te phenel pe e manušese kova našti te phirel: ‘Oprostimei će te grehija’ ili te phenel pe: ‘Ušti, le ti nosiljka hem phir’? ");
INSERT INTO rmna_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ka dokažinav tumenđe da man, e Čhave e manušesere, isi pravo ki phuv te oprostinav o grehija.” Tegani phenđa e manušese kova našti ine te phirel: ");
INSERT INTO rmna_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Tuće vaćerava: ušti, le ti nosiljka hem dža čhere!” ");
INSERT INTO rmna_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","I o manuš odmah uštino, lelja i nosiljka hem anglo sarijende iklilo avri. Sare divinde pe hem lelje te slavinen e Devle, vaćerindoj: “Nikad esavko nešto na dikhljam!” ");
INSERT INTO rmna_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","I o Isus palem dželo uzalo jezero, a but manuša avena ine koro leste hem ov sikaj len ine. ");
INSERT INTO rmna_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Sar nakhela ine adathar, o Isus dikhlja e Levije, e Alfejesere čhave, sar bešela ko than kotar čedela pe o porez, i phenđa lese: “Phir pala mande!” I ov uštino hem dželo palo leste. ");
INSERT INTO rmna_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","I sar o Isus inele uzalo astali ano čher e Levijesoro, but carinici hem avera grešnici hale maro oleja hem lesere učenikonencar, adalese so inele but esavke manuša kola džana ine palo Isus. ");
INSERT INTO rmna_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Kad nesave učitelja e Zakonestar kola inele fariseja dikhle so o Isus hala e grešnikonencar hem e carinikonencar, pučle lesere učenikonen: “Sose tumaro učitelj hala e carinikonencar hem avere grešnikonencar?” ");
INSERT INTO rmna_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","A o Isus šunđa adava, i phenđa lenđe: “E sastenđe na valjani doktori, nego e nambormenđe. Me na aljum te vičinav e pravednikonen, nego e grešnikonen.” ");
INSERT INTO rmna_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","E Jovanesere e Krstiteljesere učenici hem o fariseja postinena ine. Nesave manuša ale koro Isus hem pučle le: “Sar adava e Jovanesere učenici hem e farisejengere učenici postinena, a te učenici na postinena?” ");
INSERT INTO rmna_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","O Isus phenđa lenđe: “Šaj li e mladoženjasere amala te postinen kadi olencar o mladoženja? Na. Đikotei o mladoženja olencar, našti te postinen. ");
INSERT INTO rmna_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ali ka aven o dive kad o manuša ka len lendar e mladoženja. Tegani, ko adala dive, ka postinen. ");
INSERT INTO rmna_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Niko na sivela o nevo kotor zako šeja upro purano fostani sar te pherel i rupa, adalese so, ko thojba, adava kotor ka čedel pe, ka pharaj pe oto purano fostani hem ka ćerel po bari rupa. ");
INSERT INTO rmna_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","I niko na čhorela i nevi mol ano purane morćha. Te ćerđa pe ađahar, kad i mol ka zreloni, o morćha ka pharavđon hem ka oven uništime, a i mol ka čhorđol. Nego, i nevi mol čhorela pe ano neve morćha.” ");
INSERT INTO rmna_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ko jekh savato o Isus nakhino maškaro njive, a lesere učenici odrumal lelje te čeden e đivesoro klaso. ");
INSERT INTO rmna_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tegani o fariseja pučle le: “Dikh! Sose te učenici ćerena so palo zakoni na tromal pe ko savato?” ");
INSERT INTO rmna_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","A o Isus phenđa lenđe: “Nikad li na čitinđen ano Sveto lil so ćerđa o David kad na inole so te hal, kad bokhalile ov hem okola so inele oleja? ");
INSERT INTO rmna_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Đerdinđa ano čher e Devlesoro, ano vreme e Avijataresoro e prvosveštenikosoro, halja o posvetime maro, savo nikase na inele muklo te han sem e sveštenikonenđe, hem čak dinđa okolenđe so inele oleja te han.” ");
INSERT INTO rmna_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","I tegani phenđa lenđe: “O savatoi ćerdo zako manuš, a na o manuš zako savato. ");
INSERT INTO rmna_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ađahar, me, o Čhavo e manušesoro, injum gospodari hem e savatesoro.” ");
INSERT INTO rmna_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Kad o Isus palem đerdinđa ki sinagoga, adari inele jekh manuš kasoro vas inele šuko. ");
INSERT INTO rmna_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Adari inele hem okola kola posmatrinena ine e Isuse te dikhen na li ko savato ka sasljari le, sar te šaj tužinen le. ");
INSERT INTO rmna_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","O Isus phenđa e manušese kas inele šuko vas: “Ušti hem terđov ko maškar!” ");
INSERT INTO rmna_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","I tegani pučlja len: “So tromal pe te ćerel pe ko savato: šukaripe ili bišukaripe? Te spasini pe o dživdipe ili te mudari pe?” A on trainde. ");
INSERT INTO rmna_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","I dikhlja len holjame hem ine lese but phare zbog olengere steđime vile. I phenđa e manušese: “Pružin to vas!” Ov ispružinđa plo vas hem lesoro vas ulo sasto. ");
INSERT INTO rmna_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tegani o fariseja iklile hem odmah e manušencar kola podržinena e Irode lelje te dogovorinen pe sar te mudaren e Isuse. ");
INSERT INTO rmna_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","O Isus ple učenikonencar cidinđa pe adathar ko e Galilejakoro jezero, a palo leste džele but džene tari regija Galileja hem tari regija Judeja, ");
INSERT INTO rmna_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","tari diz Jerusalim, tari regija Idumeja, tari aver strana oti len Jordan hem taro e dizjengere e Tiresere hem e Sidonesere pašutne thana. Sa adala manuša ale koro Isus, adalese so šunde so ćerela ine čudesija. ");
INSERT INTO rmna_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Tegani o Isus phenđa ple učenikonenđe te pripreminen lese o čamco, sar te na gurini pe o narodo ano leste. ");
INSERT INTO rmna_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Adava dive buten sasljarđa, i but namborme manuša gurinena pe ine nakoro leste te dolen pe upro leste sar te šaj oven sasljarde. ");
INSERT INTO rmna_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kad dikhena le ine o manuša kola inele opsednutime e bišukare duhencar, perena ine anglo leste hem vičinena: “Tu injan o Čhavo e Devlesoro!” ");
INSERT INTO rmna_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","A ov zorale upozorini len ine te na vaćeren averenđe koi ov. ");
INSERT INTO rmna_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tegani dželo ki gora hem vičinđa okolen kolen ov manglja, hem on ale koro leste. ");
INSERT INTO rmna_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Olendar birinđa dešu dujen, kolen vičinđa apostolja, te oven oleja, te bičhali len te propovedinen ");
INSERT INTO rmna_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","hem te ovel len autoritet te ispudinen e demonen. ");
INSERT INTO rmna_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","A akavai o anava e dešu dujengere kolen birinđa: Simon, kole vičinđa Petar, ");
INSERT INTO rmna_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jakov, e Zevedejesoro čhavo, hem Jovan, e Jakovesoro phral, kolen vičinđa Voanirges, so značini “Čhave e gromesere”, ");
INSERT INTO rmna_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andreja, Filip, Vartolomej, Matej, Toma, Jakov, e Alfejesoro čhavo, Tadej, Simon Zilot ");
INSERT INTO rmna_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","hem Juda Iskariot, kova posle izdajinđa e Isuse. ");
INSERT INTO rmna_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Tegani o Isus đerdinđa ko jekh čher, a palem sa edobor džene čedinde pe da ov hem olesere učenici našti ine ni maro te han. ");
INSERT INTO rmna_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kad e Isusesoro jeri šunđa zako adava, ale palo leste te legaren le, adalese so mislinde da dilindilo. ");
INSERT INTO rmna_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","A o učitelja e Zakonestar kola ale taro Jerusalim vaćerena ine: “Opsednutimei e Veelzevuleja, e demonengere šerutneja, kasere zoralipnaja ispudini e demonen.” ");
INSERT INTO rmna_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","O Isus vičinđa len uzala peste hem lelja te vaćeri lenđe ano uporedbe: “Sose bi o Sotoni ispudini e Sotone? ");
INSERT INTO rmna_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tei nesavo carstvo ana peste podelime, adava carstvo našti te ačhol. ");
INSERT INTO rmna_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Hem tei nesavo čher ana peste podelime, adava čher naka šaj te ačhol. ");
INSERT INTO rmna_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","I, te o Sotoni džala korkoro protiv peste hem tei ana peste podelime, ov našti te ačhol, nego alo lesoro kraj. ");
INSERT INTO rmna_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ali niko našti te đerdini ko čher e zorale manušesoro hem te čorel lestar, a angleder adalestar te na phandel le. Tegani ka šaj te čorel sa oto čher. ");
INSERT INTO rmna_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Čače vaćerava tumenđe: e manušenđe ka šaj te oven oprostime sa o grehija hem o hule, ");
INSERT INTO rmna_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ali ko god hulini upro Sveto Duho nikad naka ovel lese oprostime, nego zako adava greh ka ovel zauvek krivo.” ");
INSERT INTO rmna_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Adava phenđa adalese so nesave učitelja e Zakonestar vaćerena ine dai ov opsednutime e bišukare duhoja. ");
INSERT INTO rmna_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tegani e Isusesiri daj hem lesere phralja resle adari. Sar terđovena ine avri, bičhalde nekas koro leste te vičini le. ");
INSERT INTO rmna_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","A uzalo leste bešena ine but džene, i phende lese: “Eče, ti daj hem te phralja terđovena avri hem mangena te dikhen tut.” ");
INSERT INTO rmna_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","A o Isus pučlja len: “Koi mli daj hem mle phralja?” ");
INSERT INTO rmna_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Tegani dikhlja nakoro manuša kola bešena ine ko krugo uzalo leste hem phenđa: “Ače, akalai mli daj hem mle phralja. ");
INSERT INTO rmna_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Adalese so, svako kova ćerela i volja e Devlesiri, ovi mlo phral, hem mli phen, hem mli daj.” ");
INSERT INTO rmna_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","O Isus palem lelja te sikaj e narodo uzalo jezero. Sa edobor džene čedinde pe uzalo leste, i adalese đerdinđa ko čamco upro jezero hem beštino, a sa o manuša ačhile ki phuv uzalo jezero. ");
INSERT INTO rmna_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","I but so sikaj len ine ano priče. I sikavđa len ađahar: ");
INSERT INTO rmna_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Šunen! Jekhvar iklilo o sejači te sejini. ");
INSERT INTO rmna_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","I sar sejini ine, nesave zrnja pele ko drom, i o čiriklja ale hem sa hale len. ");
INSERT INTO rmna_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Nesave pele ko than kote inele hari phuv upro bara, i odmah lelje te ikljon, adalese so na inele ani hor phuv. ");
INSERT INTO rmna_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ali kad iklilo o zoralo kham, thabile hem šućile, adalese so na ine len baro koreno. ");
INSERT INTO rmna_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","A nesave pele maškaro kare. O kare barile hem tasavde len, i o zrnja na ande bijandipe. ");
INSERT INTO rmna_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","A nesave pele ki šukar phuv, lelje te ikljon, barile hem ande bijandipe – trijanda puti više, šovardeš puti više, hem šel puti više.” ");
INSERT INTO rmna_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Hem phenđa: “Kas isi kana, nek šunel!” ");
INSERT INTO rmna_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","A kad ačhilo korkoro, okola so inele uzalo leste hem o dešu duj apostolja pučle le so manglja te vaćeri adale pričencar. ");
INSERT INTO rmna_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ov phenđa lenđe: “Tumenđei dindo te džanen i tajna oto carstvo e Devlesoro, a averenđe, kolai avri, sa vaćeri pe ano priče, ");
INSERT INTO rmna_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","sar te šaj: ‘Anglo jaćha te na dikhen, anglo kana te na šunen ni te haljoven, sar te na irinen pe kora mande, i te ovel lenđe oprostime.’ ” ");
INSERT INTO rmna_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Tegani o Isus pučlja len: “Sar na haljovena akaja priča? Sar onda ka haljoven avera priče? ");
INSERT INTO rmna_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","O sejači sejini e Devlesoro lafi. ");
INSERT INTO rmna_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Nesavei manuša sar o drom ko savoi o Lafi sejime. Kad šunena le, odmah avela o Sotoni hem lela o Lafi savoi ano lende sejime. ");
INSERT INTO rmna_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Nesavei sar o than kote inele hari phuv upro bara ko savoi sejime o zrnja. Kad šunena o Lafi, odmah lena le radosno. ");
INSERT INTO rmna_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ali, adalese so nane len baro koreno ana peste, na trajinena but. Kad avela i nevolja ili o progonstvo zbog o Lafi, odmah otperena oti vera. ");
INSERT INTO rmna_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Nesavei sar o than maškaro kare ko savoi sejime o zrnja. Adalai okola kola šunena o Lafi, ");
INSERT INTO rmna_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ali o brige akale dživdipnasere, o zavodljivost e barvalipnasoro hem o avera požude tasavena o Lafi, i našti anel plod. ");
INSERT INTO rmna_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","A nesavei sar i šukar phuv ki savi sejime o zrnja. Adalai okola kola šunena hem lena o Lafi. On anena plod – trijanda puti više, šovardeš puti više, hem šel puti više.” ");
INSERT INTO rmna_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","I tegani o Isus pučlja len: “Kad anena andre i svetiljka, tumen li čhivena la talo čaro ili talo than e pašljojbnasoro? Na! Nego čhivena la ko than zaki svetiljka. ");
INSERT INTO rmna_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Adalese so, sa soi tajno, ka otkrijini pe, hem sa soi garavdo, ka ikljol ko svetlost. ");
INSERT INTO rmna_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Te nekas isi kana, nek šunel!” ");
INSERT INTO rmna_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Hem phenđa lenđe akava: “Šunen šukar. Sava meraja merinena, esavkaja ka merini pe tumenđe hem buderi adalestar ka del pe tumenđe. ");
INSERT INTO rmna_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Adalese so, svakone kas isi džandipe, ka del pe lese pana, a okole kas nane, ka lel pe lestar hem adava so isi le.” ");
INSERT INTO rmna_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","I phenđa: “O carstvo e Devlesoroi slično sar kad o manuš sejini o seme ki phuv, ");
INSERT INTO rmna_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","i bilo te sovel ili te uštel, i rat hem o dive, o zrnja lena te ikljon hem barjona, a ov ni džanel sar. ");
INSERT INTO rmna_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","I phuv korkori pestar anela bijandipe: najangle i čar, palo adava o klaso, i ko kraj o klaso pherđola điveja. ");
INSERT INTO rmna_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Kad o điv zreloni, o manuš odmah lela te čedel le, adalese so alo o vreme zako čediba.” ");
INSERT INTO rmna_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Tegani o Isus phenđa: “Soja te uporedina o carstvo e Devlesoro? Ili, sava pričaja te objasnina le? ");
INSERT INTO rmna_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ovi sar o zrno oti gorušica savoi najtikoro oto sa o zrnja save sejinena pe ki phuv. ");
INSERT INTO rmna_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ali, kad sejini pe, barjola hem ovela po baro oto sa o biljke ki bašta, i mukela edobor bare granke da hem o čiriklja šaj te ćeren gnezdija ano lesoro hlado.” ");
INSERT INTO rmna_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ano but esavke priče vaćeri lenđe ine e Devlesoro lafi, edobor kobor šaj ine te šunen, ");
INSERT INTO rmna_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","hem na vaćerđa lenđe ništa bizo priče. A kad inele korkoro ple učenikonencar, tegani sa objasnini lenđe ine. ");
INSERT INTO rmna_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","I kad lelja te raćol, o Isus phenđa e učenikonenđe: “Te nakha ki aver strana oto jezero.” ");
INSERT INTO rmna_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","I on ačhavde e narodo hem legarde pumencar e Isuse čamcoja ano savo već inele. A palo lende džana ine hem avera manuša čamconencar. ");
INSERT INTO rmna_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","I muklja pe jekh zorali barval upro jezero. O talasija lelje te pheren o čamco panjeja edobor da samo so na ine te pheren le đi o muj. ");
INSERT INTO rmna_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","A o Isus ko paluno deo e čamcosoro sovela ine pašljindoj šereja ko jastuko. Tegani o učenici džangavde le hem pučle le: “Učitelju, tuće li sa jekh so ka mera?” ");
INSERT INTO rmna_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","I o Isus uštino, naredinđa e barvaljaće te ačhol hem phenđa e jezerose: “Train! Smirin tut!” Hem i barval ačhili hem ulo baro mir. ");
INSERT INTO rmna_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Tegani pučlja e učenikonen: “Sose injen edobor darutne? Pana li nane tumen vera?” ");
INSERT INTO rmna_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","A on but darandile, i pučle jekh avere: “Kovai onda akava so đi o barvalja hem o jezero šunena le?” ");
INSERT INTO rmna_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","I resle ki dujto strana oto jezero, ko krajo e gerasakoro. ");
INSERT INTO rmna_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","I kad o Isus iklilo taro čamco, odmah nakoro leste, taro grobija, alo jekh manuš opsednutime bišukare duhoja. ");
INSERT INTO rmna_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Adava manuš živinđa maškaro grobija hem niko našti ine više te phandel le, čak ni lanconencar. ");
INSERT INTO rmna_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","But puti phandena ine lanconencar lesere vasta hem lesere pre, ali ov čhinela ine o lancija, a phagela o okovija taro pre, hem niko na inele edobor zoralo te šaj smirini le. ");
INSERT INTO rmna_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Bizo ačhojba, i dive i rat, maškaro grobija hem maškaro bregija vičini ine hem khuvela pe barencar. ");
INSERT INTO rmna_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Kad odural dikhlja e Isuse, prastandilo hem pelo ko kočija anglo leste, ");
INSERT INTO rmna_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","i vičinđa oto sa o glaso: “So mangeja mandar, Isuse, Čhaveja e Najbare Devlesereja? Hava tut sovli e Devleja te na mučine man!” ");
INSERT INTO rmna_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","(Adalese so o Isus već naredinđa e bišukare duhose te ikljol adale manušestar.) ");
INSERT INTO rmna_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Tegani o Isus pučlja le: “Sar to anav?” A ov phenđa lese: “Vičinena man Legija, adalese so but džene injam ano leste, sar vojska.” ");
INSERT INTO rmna_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","I zorale molinđa e Isuse te na ispudini len taro adava krajo. ");
INSERT INTO rmna_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","A adari ko brego inele jekh baro krdo oto bale save hana ine, ");
INSERT INTO rmna_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","i o bišukar duhija molinde e Isuse vaćerindoj: “Bičhal amen ano okola bale, te đerdina ano lende.” ");
INSERT INTO rmna_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","I ov muklja lenđe, i o bišukar duhija iklile e manušestar hem đerdinde ano bale. I sa o krdo, đi ko duj hiljade bale, prastandile taro brego ano jezero hem taslile. ");
INSERT INTO rmna_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","A okola so arakhena ine e balen našle hem vaćerde adalestar e manušenđe ani diz hem ano gava, i o manuša ale te dikhen so adava ulo. ");
INSERT INTO rmna_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ale koro Isus hem dikhle e manuše ano koleste angleder inele vojska oto bišukar duhija sar urjavdo hem saste gođaja bešela adari, i darandile. ");
INSERT INTO rmna_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Okola so dikhle adava vaćerde adale manušenđe sa so ulo e opsednutimeja hem e balencar. ");
INSERT INTO rmna_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Tegani on lelje te molinen e Isuse te džal taro lengoro krajo. ");
INSERT INTO rmna_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","I sar o Isus đerdini ine ko čamco, o manuš ano koleste inele o bišukar duhija molinđa le te džal oleja, ");
INSERT INTO rmna_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","ali o Isus na muklja lese, nego phenđa lese: “Dža čhere, te čherutnende, hem vaćer lenđe sa so ćerđa će o Gospod hem kobor inele će milosrdno.” ");
INSERT INTO rmna_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","I o manuš dželo hem lelja te vaćeri ano Dekapolis sa so ćerđa lese o Isus. I sare divinde pe. ");
INSERT INTO rmna_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","O Isus palem nakhino e čamcoja ki aver strana oto jezero. Uzalo leste čedinde pe but džene, a ov inele uzalo jezero. ");
INSERT INTO rmna_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tegani alo jekh vođa e sinagogakoro palo anav Jair hem, kad dikhlja e Isuse, pelo mujeja đi phuv anglo lesere pre ");
INSERT INTO rmna_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","hem zorale molinđa le: “Mli čhajori anglo meriba. Molinava tut, ava hem čhiv te vasta upro late, te sasljol hem te živini.” ");
INSERT INTO rmna_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","I o Isus lelja te džal palo Jair, a palo leste džele but džene, kola lelje te gurinen pe ano leste. ");
INSERT INTO rmna_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Maškar olende inele hem jekh namborme đuvli kolatar dešu duj berš thavdinđa rat. ");
INSERT INTO rmna_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","But patinđa ko doktorija hem sa so inola trošinđa upro lende, ali so te ovel laće po šukar, olaće inele po bišukar. ");
INSERT INTO rmna_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Kad šunđa e Isusese, nakhini maškaro narodo koro leste oto palal hem dolinđa pe upro lesoro fostani, ");
INSERT INTO rmna_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","adalese so phenđa ana peste: “Samo te dolav man upro lesere šeja, ka ovav sasljardi.” ");
INSERT INTO rmna_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","I otojekhvar ačhilo te thavdel latar o rat hem oj osetinđa ano telo soi sasljardi taro plo baro nambormipe. ");
INSERT INTO rmna_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","O Isus odmah osetinđa so olestar iklilo zoralipe te sasljari nekas, i irinđa pe nakoro narodo hem pučlja: “Ko dolinđa pe upro mle šeja?” ");
INSERT INTO rmna_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","O učenici phende lese: “Dikheja sar o narodo gurini pe uzala tute, a tu pučeja ko dolinđa pe upra tute!” ");
INSERT INTO rmna_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","A o Isus lelja te rodel uzala peste te dikhel ko ćerđa adava. ");
INSERT INTO rmna_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Tegani adaja đuvli, tresindoj oti dar, adalese so džanđa so ulo laće, ali hem peli mujeja đi phuv anglo leste hem vaćerđa lese sa sar inele. ");
INSERT INTO rmna_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","A o Isus phenđa laće: “Mli čhaj, ti vera sasljarđa tut. Dža ano mir hem ov sasti te bare nambormipastar!” ");
INSERT INTO rmna_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Sar o Isus pana vaćeri ine adava, ale nesave manuša taro čher e Jairesoro, e sinagogakere vođasoro, hem phende: “Ti čhaj muli. Sose više te mučine e učitelje?” ");
INSERT INTO rmna_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ali o Isus na dinđa pažnja ko adava so phende, nego phenđa e sinagogakere vođase: “Ma dara! Samo verujin!” ");
INSERT INTO rmna_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","I o Isus na muklja nikase te džal oleja, sem e Petrese, e Jakovese hem lesere phralese e Jovanese. ");
INSERT INTO rmna_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kad resle đi ko čher e sinagogakere vođasoro, o Isus dikhlja so o manuša galaminena, so sa glasoja rovena e čhajorja. ");
INSERT INTO rmna_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","I ov đerdinđa hem phenđa lenđe: “Sose galaminena? Sose rovena? I čhajori na muli, nego sovela.” ");
INSERT INTO rmna_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","A on asandile lese, i ov ikalđa sarijen avri. Peja legarđa samo e čhajorjakere dade hem e daja hem ple trine učenikonen, hem đerdinđa adari kaj inele i čhajori. ");
INSERT INTO rmna_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","I dolinđa la oto vas hem phenđa laće: “Talita kum!” (so značini: “Čhajorije, tuće vaćerava, ušti!”). ");
INSERT INTO rmna_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","I odmah i čhajori uštini hem lelja te phirel, a on but inele začudime. Ola inele dešu duj berš. ");
INSERT INTO rmna_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Tegani o Isus zorale naredinđa lenđe te na vaćeren nikase so ulo hem phenđa lenđe te den la te hal. ");
INSERT INTO rmna_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Tegani o Isus dželo adathar hem alo ko than kaj barilo, a oleja ale hem lesere učenici. ");
INSERT INTO rmna_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Kad alo o savato, ov lelja te sikaj e manušen ani sinagoga. But džene kola šunde le divinde pe hem pučle: “Kotar akalese adava? Savi adaja mudrost lese dindi? Sar šaj te ćerel esavke čudesija ple vastencar? ");
INSERT INTO rmna_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ma ovi samo kaštarutno! Ovi o čhavo e Marijakoro, a phral e Jakovesoro, e Josesoro, e Judasoro hem e Simonesoro, hem lesere phenjai akate amencar.” I razočarinde pe hem na mangle te prihvatinen le. ");
INSERT INTO rmna_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Tegani o Isus phenđa lenđe: “E prorokose dela pe čast ko sa o thana, sem lese ano than kaj barilo, maškari lesiri familija hem lese ano čher.” ");
INSERT INTO rmna_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","I adari našti ine te ćerel nijekh čudo, sem so čhivđa ple vasta upro nekobor namborme hem sasljarđa len. ");
INSERT INTO rmna_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","I čudinđa pe so na ine len vera. I o Isus džala ine ko pašutne gava hem sikaj e manušen. ");
INSERT INTO rmna_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","I vičinđa kora peste e dešu duje apostolen hem lelja te bičhali len po dujen. Dinđa len autoritet upro bišukar duhija ");
INSERT INTO rmna_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","hem naredinđa lenđe, sem štapi, te na legaren pumencar ko drom ništa aver, ni maro, ni torba, ni bakarna kovanice ano pojasija, ");
INSERT INTO rmna_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","nego te urjen pe sandale, hem te na legaren pumencar aver gad. ");
INSERT INTO rmna_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Hem phenđa lenđe: “Kad đerdinena ko nesavo than, đikote na džana adathar, ačhoven ano jekh čher. ");
INSERT INTO rmna_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Te ko nesavo than na priminde tumen ili te na mangle te šunen tumen, ikljoven adathar hem tresinen i prašina tumare prendar, sar znako zako zoralo odbiba.” ");
INSERT INTO rmna_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","I o apostolja džele hem propovedinde da o manuša valjani te pokajinen pe. ");
INSERT INTO rmna_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ispudinde bute demonen, hem makhle uljeja bute nambormen hem sasljarde len. ");
INSERT INTO rmna_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","I o caro o Irod šunđa e Isusese, adalese so lesoro anav ulo prešundo. Nesave manuša vaćerena ine: “Ovi o Jovan o Krstitelj. Uštino taro mule hem adalese šaj te ćerel adala čudesija.” ");
INSERT INTO rmna_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Avera vaćerde: “Adavai o proroko o Ilija.” A avera vaćerde: “Ovi proroko sar so inele o proroci taro purano vreme.” ");
INSERT INTO rmna_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ko adava, o Irod phenđa: “Ovi o Jovan, kasoro šero me čhinđum. Ov uštino taro mule!” ");
INSERT INTO rmna_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Adalese so, korkoro o Irod angleder bičhalđa te dolen e Jovane hem te frden le ano phandlipe, adalese so o Jovan phenela lese ine da na tromal te lel romnjaće e Irodijada, ple phralesere e Filipesere romnja, sava već lelja romnjaće. ");
INSERT INTO rmna_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","I Irodijada adalese zamrzinđa e Jovane hem manglja te mudari le, ali našti ine te ćerel adava ");
INSERT INTO rmna_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","adalese so o Irod darandilo e Jovanestar hem štitinđa le adalese so džanđa dai pravedno hem sveto manuš. Kad god o Irod šunela ine e Jovane, ovela ine but zbunime, a palem, mangela ine te šunel le. ");
INSERT INTO rmna_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","A mothovđa pe šuži prilika e Irodijadaće kad o Irod zako plo bijando dive ćerđa gozba zako ple bitna službenici, zako e vojskakere narednici hem zako e galilejakere šerutne. ");
INSERT INTO rmna_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Kad đerdinđa e Irodijadakiri čhaj ki gozba hem kad čhelđa anglo lende, adava but inele šukar e Irodese hem lesere gostonenđe. I o caro phenđa e čhajaće: “Rode mandar sa so mangeja hem me adava ka dav tut.” ");
INSERT INTO rmna_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Hem halja laće sovli: “Ka dav tut sa so ka mange, đi ko ekvaš oto mlo carstvo.” ");
INSERT INTO rmna_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","I oj iklili hem pučlja pe daja: “So te mangav?” A oj phenđa: “O šero e Jovanesoro e Krstiteljesoro.” ");
INSERT INTO rmna_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","I čhaj odmah siđarđa koro caro hem phenđa lese: “Mangava odmah te de man ko čaro o šero e Jovanesoro e Krstiteljesoro.” ");
INSERT INTO rmna_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","E carose but inele žao, ali zbog pli sovli anglo gostija na manglja te odbini la. ");
INSERT INTO rmna_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Odmah naredinđa e dželatese te džal hem te anel e Jovanesoro šero. Ov dželo, čhinđa lesoro šero ano phandlipe ");
INSERT INTO rmna_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","hem anđa le ko čaro, i dinđa le e čhajaće, a oj dinđa le pe dajaće. ");
INSERT INTO rmna_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Kad šunde adava e Jovanesere učenici, ale hem lelje lesoro telo, i čhivde le ano grobo. ");
INSERT INTO rmna_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","O apostolja irinde pe koro Isus hem vaćerde lese sa so ćerde hem sostar sikavde e manušen. ");
INSERT INTO rmna_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","I o Isus phenđa lenđe: “Te cida amen ko jekh čučo than, korkore, te odmorinen hari.” Adalese so but manuša avena ine hem džana, i na ine len vreme ni te han. ");
INSERT INTO rmna_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","I on lelje korkore čamcoja te džan ko jekh čučo than. ");
INSERT INTO rmna_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ali, but džene dikhle len sar džana hem pendžarde len, i taro sa o pašutne dizja prastandile adari phuvjaja hem resle angleder olendar. ");
INSERT INTO rmna_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Kad o Isus iklilo taro čamco, dikhlja bute manušen hem ine lese pharo olenđe, adalese so inele sar bakre bizo pastiri, i lelja but so te sikaj len. ");
INSERT INTO rmna_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","I kad lelja te perel i rat, nakhle đi leste lesere učenici hem phende: “Ko akava than ništa nane, a već perela i rat. ");
INSERT INTO rmna_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Te muke ine e manušen te šaj džan ko pašutne thana hem gava te činenfse nešto hajbnase.” ");
INSERT INTO rmna_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","A o Isus phenđa lenđe: “Den len tumen nešto hajbnase!” On pučle le: “Mangeja amendar te dža hem te čina mare zako dušel srebrna kovanice hem te da len te han?” ");
INSERT INTO rmna_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","A o Isus pučlja len: “Kobor mare isi tumen? Džan hem dikhen.” Kad dikhle, phende so isi len pandž mare hem duj maćhe. ");
INSERT INTO rmna_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Tegani o Isus naredinđa sare, ko kupe, te bešen ki zeleno čar. ");
INSERT INTO rmna_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","I on beštine ko kupe po šel hem po pinda. ");
INSERT INTO rmna_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tegani lelja e pandže maren hem e duje maćhen, dikhlja nakoro nebo hem zahvalinđa e Devlese zako hajba. Phaglja o mare hem dinđa len ko ple učenici te podelinen len e manušenđe. Ađahar sarijenđe podelinđa hem e duje maćhen. ");
INSERT INTO rmna_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","I sare hale đikote na čalile. ");
INSERT INTO rmna_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Palo adava, dešu duj pherde korpe čedinde pe okolestar so ačhilo oto mare hem oto maćhe. ");
INSERT INTO rmna_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","A okola so hale inele pandž hiljade murša. ");
INSERT INTO rmna_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","I odmah palo adava o Isus terinđa e učenikonen te đerdinen ko čamco hem angleder oleste te džan ki aver strana, nakori diz Vitsaida, đikote ov bičhali čhere e manušen. ");
INSERT INTO rmna_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kad bičhalđa čhere e manušen, dželo ko brego te molini pe. ");
INSERT INTO rmna_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kasno ani rat, o čamco inele ko ekvaš o jezero, a o Isus inele ki phuv korkoro. ");
INSERT INTO rmna_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ov dikhlja e učenikonen sar phareste veslinena, adalese so nakoro lende phudinđa i barval, i paše đi maškaro trin hem šov o sati prekali rat alo nakoro lende phirindoj upro jezero. Ov valjanđa te nakhel uzalo lende, ");
INSERT INTO rmna_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ali kad dikhle le sar phirela upro jezero, lelje te vičinen, adalese so mislinde dai duho. ");
INSERT INTO rmna_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Sare dikhle le hem tresinde oti dar, ali o Isus odmah phenđa lenđe: “Oven hrabra! Me injum. Ma daran!” ");
INSERT INTO rmna_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Tegani đerdinđa koro lende ko čamco hem i barval ačhili. A on inele but začudime, ");
INSERT INTO rmna_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","adalese so na halile okova čudo so ulo e marencar, adalese so lengere vile inele steđime. ");
INSERT INTO rmna_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","I o Isus hem lesere učenici nakhle ki aver strana oto jezero, ki phuv e Genisaretakiri hem phandle o čamco. ");
INSERT INTO rmna_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","So iklile taro čamco, o manuša odmah pendžarde e Isuse, ");
INSERT INTO rmna_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","i prastandile maškaro sa adava krajo te vaćeren averenđe so o Isus alo, i o manuša lelje ko nosiljke te anen e nambormen adari kaj šunde dai o Isus. ");
INSERT INTO rmna_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","I kaj god te đerdini ine – ko dizja, ko gava ili ko po tikore thana – čhivena ine e nambormen ko trgija hem molinena le ine te mukel lenđe samo te dolen pe upro lesere fostanesoro krajo. I svako kova dolinđa pe, saslilo. ");
INSERT INTO rmna_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Uzalo Isus čedinde pe o fariseja hem nesave učitelja e Zakonestar kola ale taro Jerusalim. ");
INSERT INTO rmna_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","I dikhle nesaven lesere učenikonendar sar bithovde vastencar hana maro – so značini dai lengere vasta melale palo adeti e farisejengoro. ");
INSERT INTO rmna_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Adalese so, o Jevreja, a posebno o fariseja, na hana ine maro đikote na thovena pumare vasta đi o kunja, sar te ićeren o adeti pumare puranengoro. ");
INSERT INTO rmna_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Hem kad avena ine čhere taro pijac, na hana ine đikote šukar na thovena pe. A isi pana but adetija save ićerena, sar soi o thojba e čašengoro, e bokalengoro hem e čarengoro. ");
INSERT INTO rmna_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Adalese o fariseja hem o učitelja e Zakonestar pučle e Isuse: “Sose te učenici na ićerena o adetija amare puranengere, nego melale vastencar hana maro?” ");
INSERT INTO rmna_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","A o Isus phenđa lenđe: “Dujemujengere manušalen! Šukar tumendar prorokujinđa o Isaija. Sar soi pisime ano Sveto lil: ‘Akala manuša poštujinena man samo mujeja, a lengoroi vilo dur mandar. ");
INSERT INTO rmna_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Džabe poštujinena man, adalese so sikavena o manušikane naredbe sar dai mlo sikaviba.’ ");
INSERT INTO rmna_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Tumen ačhavđen e Devlesere naredbe, a ićerena o manušikane adetija.” ");
INSERT INTO rmna_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Hem phenđa lenđe: “Ko šukar način arakhljen te čhinaven e Devlesiri naredba sar te ićeren tumare adetija! ");
INSERT INTO rmna_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Adalese so o Mojsije phenđa: ‘Poštujin te dade hem te daja’ hem: ‘Ko dela armanja pe dade ili pe daja, nek ovel kaznime meribnaja.’ ");
INSERT INTO rmna_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","A tumen vaćerena: ‘O manuš šaj te phenel pe dadese ili pe dajaće: Sa soja šaj ine te pomožinav tut, već haljum sovli dai adava korbani, so značini daro e Devlese’, ");
INSERT INTO rmna_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","i ađahar na mukena lese ništa više te pomožini pe dadese ili pe dajaće. ");
INSERT INTO rmna_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ađahar čhinavena e Devlesoro lafi tumare adetencar saven sikavena averen. Hem pana but so ađahar ćerena.” ");
INSERT INTO rmna_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","I o Isus palem vičinđa kora peste e narodo hem phenđa lenđe: “Šunen man sare hem haljoven: ");
INSERT INTO rmna_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ništa so od avrijal đerdini ano manuš našti te meljari le, nego okova so ikljola e manušestar – adava meljari e manuše. ");
INSERT INTO rmna_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Te nekas isi kana, nek šunel!” ");
INSERT INTO rmna_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","A kad cidinđa pe e narodostar hem kad đerdinđa ano čher, o učenici pučle le te objasnini lenđe adaja priča. ");
INSERT INTO rmna_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","I ov pučlja len: “Ni tumen li na haljovena? Na haljovena li so e manuše našti te meljari ništa so od avrijal đerdini ano leste, ");
INSERT INTO rmna_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","adalese so na đerdini lese ano vilo, nego ano vođi hem ikljola taro lesoro telo?” (Ađahar sa soi hajbnase, o Isus proglasinđa dai čisto.) ");
INSERT INTO rmna_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Hem phenđa: “E manuše meljari okova so ikljola olestar. ");
INSERT INTO rmna_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Adalese so, andral, e manušesere vilestar, ikljona o bišukar mislija, o blud, o čoriba, o mudariba, ");
INSERT INTO rmna_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","o preljube, i pohlepa, o bišukaripe, o prevariba, i bilađ, i zavist, o bišukar vaćeriba averendar, o barikanipe hem o dilinipe. ");
INSERT INTO rmna_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Sa adala bišukaripa ikljona andral hem meljarena e manuše.” ");
INSERT INTO rmna_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Palo adava o Isus tari regija Galileja dželo ko krajo e tiresoro hem e sidonesoro, i ačhilo adari ano nesavo čher. Na manglja niko te džanel dai adari, ali našti ine te garaj pe ");
INSERT INTO rmna_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","adalese so odmah šunđa olese jekh đuvli kasiri čhajori inele opsednutime bišukare duhoja. Oj ali hem peli mujeja đi phuv anglo lesere pre. ");
INSERT INTO rmna_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Adaja đuvli inele Grkinja, bijandi ani e sirijakiri Fenicija. Molinđa e Isuse te ispudini e demone lakere čhajatar. ");
INSERT INTO rmna_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","O Isus phenđa laće: “Muk najangle o čhavore te han đikote na čaljona. Adalese so nane šukar te lel pe o maro e čhavorendar hem te frdel pe e đuklorenđe.” ");
INSERT INTO rmna_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","A oj phenđa: “Oja, Gospode, ali hem o đuklore talo astali hana o troške save perena e čhavorendar.” ");
INSERT INTO rmna_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Tegani o Isus phenđa laće: “Adalese so ađahar phenđan, šaj te dža čhere. O demoni iklilo te čhajatar.” ");
INSERT INTO rmna_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kad i đuvli resli čhere, arakhlja e čhajorja sar ano mir pašljola ko than e pašljojbnasoro, a o demoni već iklilo ine olatar. ");
INSERT INTO rmna_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tegani o Isus dželo taro krajo e tiresoro, i prekalo Sidon reslo ko e Galilejakoro jezero, ko krajo e dekapolisesoro. ");
INSERT INTO rmna_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Adari ande koro Isus jekhe kašuke manuše kova hem phareste vaćeri ine hem molinde le te čhivel plo vas upro leste hem te sasljari le. ");
INSERT INTO rmna_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","I o Isus cidinđa le ki strana e narodostar, čhivđa ple naja ano lesere kana, a palo adava čhungarđa ko ple naja hem pipinđa lesiri čhib. ");
INSERT INTO rmna_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","I dikhlja nakoro nebo, zorale uzdahninđa hem phenđa lese: “Efata!”– so značini “Phravđov!” ");
INSERT INTO rmna_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","I odmah phravdile e manušesere kana hem lesiri čhib, i lelja šukar te vaćeri. ");
INSERT INTO rmna_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","O Isus naredinđa lenđe te na vaćeren adalestar nikase. Ali sa so više naredini lenđe ine te na vaćeren, on sa više vaćerena ine adalestar. ");
INSERT INTO rmna_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","I o manuša but divinena pe ine hem vaćerena: “Sa ćerela šukar – đi o kašuke te šunen hem o lalore te vaćeren.” ");
INSERT INTO rmna_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ko adava vreme palem čedinđa pe baro narodo. I adalese so na ine len so te han, o Isus vičinđa kora peste ple učenikonen hem phenđa lenđe: ");
INSERT INTO rmna_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Pharo maje akale manušenđe. Trito divei mancar, a nane len so te han. ");
INSERT INTO rmna_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Te bičhalđum len čhere bokhalen, ka peren odrumal, a nesave olendar ale odural.” ");
INSERT INTO rmna_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","A o učenici pučle le: “Kaj ko akava čučo than te arakha dovoljno maro zako sa akala manuša te čaljoven?” ");
INSERT INTO rmna_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","I o Isus pučlja len: “Kobor mare isi tumen?” A on phende: “Efta.” ");
INSERT INTO rmna_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tegani naredinđa o narodo te bešel ki phuv, lelja okola efta mare, zahvalinđa e Devlese, phaglja len hem dinđa len ko ple učenici, hem on dinde len e manušenđe. ");
INSERT INTO rmna_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","A olen inele hem nekobor tikore maćhe. O Isus zahvalinđa hem olenđe, i phenđa e učenikonenđe hem olen te podelinen e manušenđe. ");
INSERT INTO rmna_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Sare hale hem čalile, hem efta pherde bare korpe čedinde pe okolestar so ačhilo oto hajba. ");
INSERT INTO rmna_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","A adari inele đi ko štar hiljade manuša. I o Isus bičhalđa len čhere ");
INSERT INTO rmna_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","hem odmah đerdinđa ko čamco e učenikonencar, i dželo ko krajo e dalmanutakoro. ");
INSERT INTO rmna_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Tegani ale nesave fariseja hem lelje te raspravinen pe e Isuseja. Iskušinde le ađahar so rodinde lestar znako taro nebo. ");
INSERT INTO rmna_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","A ov zorale uzdahninđa, i phenđa: “Sose akaja generacija rodela mandar znako? Čače phenava tumenđe: nisavo znako naka del pe laće.” ");
INSERT INTO rmna_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Tegani ačhavđa len, palem đerdinđa ko čamco hem nakhino ki aver strana oto jezero. ");
INSERT INTO rmna_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","A o učenici bisterde te legaren pumencar maro, i ano čamco inolen samo jekh maro. ");
INSERT INTO rmna_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","I sar nakhena ine ki aver strana oto jezero, o Isus upozorinđa len vaćerindoj: “Arakhen tumen taro kvasco e farisejengoro hem taro kvasco e Irodesoro!” ");
INSERT INTO rmna_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","A on maškara pumende vaćerena ine: “Adava phenđa adalese so nane amen maro!” ");
INSERT INTO rmna_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","O Isus džanđa sostar vaćerena, i pučlja len: “Sose vaćerena adalestar so nane tumen maro? Pana li na haljovena hem na anena ki godi? Edobor li steđime tumare vile? ");
INSERT INTO rmna_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Jaćha isi tumen, a na dikhena? Kana isi tumen, a na šunena? Hem sar na setinena tumen? ");
INSERT INTO rmna_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Kad phagljum o pandž mare zako pandž hiljade murša, kobor pherde korpe čedinđen okolestar so ačhilo oto hajba?” On phende: “Dešu duj.” ");
INSERT INTO rmna_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“A kad phagljum o efta mare zako štar hiljade murša, kobor bare korpe čedinđen okolestar so ačhilo oto hajba?” On phende: “Efta.” ");
INSERT INTO rmna_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","A ov pučlja len: “I pana li na haljovena?” ");
INSERT INTO rmna_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","I kad resle ki Vitsaida, nesave manuša ande koro Isus jekhe korore manuše, i molinde le te čhivel ple vasta upro leste. ");
INSERT INTO rmna_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","O Isus dolinđa e korore oto vas hem ikalđa le taro gav, čhungarđa lese ko jaćha hem čhivđa ple vasta upro leste. I pučlja le: “Dikheja li nešto?” ");
INSERT INTO rmna_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","A o manuš lelja te dikhel, i phenđa: “Dikhava manušen, ali oni sar kašta save phirena!” ");
INSERT INTO rmna_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","I o Isus palem čhivđa ple vasta upro lesere jaćha, hem e manušese irinđa pe o dikhiba hem sa šukar dikhlja. ");
INSERT INTO rmna_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","O Isus bičhalđa le čhere, vaćerindoj: “Ma đerdin ko gav.” ");
INSERT INTO rmna_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","I o Isus hem lesere učenici džele ko gava uzali e Filipesiri Cezareja. Odrumal o Isus pučlja len: “So phenena o manuša, ko injum me?” ");
INSERT INTO rmna_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","On phende lese: “Nesave manuša phenena da tu injan o Jovan o Krstitelj, a avera phenena da tu injan o proroko o Ilija, a nesave avera da tu injan jekh oto avera proroci.” ");
INSERT INTO rmna_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Tegani o Isus pučlja len: “A so tumen phenena, ko injum me?” O Petar phenđa: “Tu injan o Hrist!” ");
INSERT INTO rmna_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","I o Isus zorale upozorinđa len nikase te na vaćeren adava olestar. ");
INSERT INTO rmna_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","I lelja te sikaj len vaćerindoj: “Me, o Čhavo e manušesoro, valjani but te patinav. O starešine, o šerutne sveštenici hem o učitelja e Zakonestar naka prihvatinen man. Ka ovav mudardo, ali o trito dive ka uštav taro mule.” ");
INSERT INTO rmna_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Phravdeste vaćerđa lenđe adalestar, i o Petar cidinđa le ki strana hem lelja te ukorini le. ");
INSERT INTO rmna_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","A o Isus, irinđa pe, dikhlja ano učenici, i ukorinđa e Petre hem phenđa: “Dža mandar, Sotone! Adalese so na razmislineja devlikane, nego manušikane.” ");
INSERT INTO rmna_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Tegani o Isus vičinđa kora peste e narodo zajedno ple učenikonencar, i phenđa lenđe: “Ko mangela te ovel mlo učeniko, mora te ačhaj pe ple dživdipnastar hem te lel plo krsto hem te phirel pala mande. ");
INSERT INTO rmna_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Adalese so, ko mangela te spasini plo dživdipe, ka našali le, a ko našali plo dživdipe zbog mande hem zbog o Šukar lafi, ka spasini le. ");
INSERT INTO rmna_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","I so vredini e manušese hem sa i phuv te ovel olesiri, a našali plo dživdipe? ");
INSERT INTO rmna_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","I so o manuš šaj te del sar zamena zako plo dživdipe? ");
INSERT INTO rmna_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Adalese so, ko angli akaja neverno hem grešno generacija lađala mandar hem mle lafendar, hem me, o Čhavo e manušesoro, ka lađav olestar kad ka avav ani slava mle Dadesiri e svetone anđelencar.” ");
INSERT INTO rmna_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","I o Isus phenđa lenđe: “Čače vaćerava tumenđe, isi nesave akalendar so terđona akate kola čače naka meren đikote na dikhena o carstvo e Devlesoro sar avela ano zoralipe.” ");
INSERT INTO rmna_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Palo šov dive, o Isus lelja peja e Petre, e Jakove hem e Jovane hem dželo olencar ki jekh uči gora, kote inele korkore. Adari o Isus ulo averčhane anglo lende: ");
INSERT INTO rmna_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","lesere šeja ule sjajna hem parne – edobor parne da nijekh manuš ki phuv naka šaj ine edobor te parnjari len. ");
INSERT INTO rmna_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","I tegani iklile anglo lende o Ilija hem o Mojsije hem lelje te vaćeren e Isuseja. ");
INSERT INTO rmna_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","I o Petar phenđa e Isusese: “Učitelju, šukari amenđe so injam akate. Te ćera trin šatorja: jekh tuće, jekh e Mojsijase hem jekh e Ilijase.” ");
INSERT INTO rmna_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Na džanđa so te vaćeri, adalese so but darandile.) ");
INSERT INTO rmna_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tegani iklilo jekh oblako savo učharđa len hem taro oblako šundilo glaso savo vaćerđa: “Akavai mlo Čhavo o volime! Ole šunen!” ");
INSERT INTO rmna_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","I otojekhvar, kad dikhle uzala pumende, na dikhle više nikas sem e Isuse. ");
INSERT INTO rmna_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Sar huljena ine tari gora, o Isus naredinđa lenđe nikase te na vaćeren so dikhle sa đikote ov, o Čhavo e manušesoro, na uštela taro mule. ");
INSERT INTO rmna_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","I on nikase na vaćerde adalestar, ali maškara pumende pučena pe ine upra soste mislinđa kad phenđa da ka “uštel taro mule.” ");
INSERT INTO rmna_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","I o učenici pučle le: “Sose onda o učitelja e Zakonestar vaćerena da o Ilija valjani te avel angleder e Mesijastar?” ");
INSERT INTO rmna_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","O Isus phenđa lenđe: “Čače prvo o Ilija avela hem palem ka čhivel sa than thaneja. A sosei onda pisime ano Sveto lil zako Čhavo e manušesoro da but ka patini hem da ka ovel odbacime? ");
INSERT INTO rmna_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ali phenava tumenđe: o Ilija već alo, ali ćerde oleja sar olenđe manglja pe, sar soi pisime olestar.” ");
INSERT INTO rmna_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kad o Isus hem o trin učenici irinde pe koro avera učenici, dikhle bute manušen uzalo lende hem nesave učiteljen e Zakonestar sar raspravinena pe olencar. ");
INSERT INTO rmna_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","I so dikhle e Isuse sa adala manuša, but iznenadinde pe, i prastandile nakoro leste te pozdravinen le. ");
INSERT INTO rmna_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","I o Isus pučlja len: “Sostar raspravinena olencar?” ");
INSERT INTO rmna_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","A jekh manuš taro narodo phenđa lese: “Učitelju, anđum mle čhave te sasljare le. Ov našti te vaćeri adalese soi opsednutime bišukare duhoja kova na mukela le te vaćeri. ");
INSERT INTO rmna_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kad prelela le, frdela le ki phuv, taro muj ikljola lestar pena, steđini pe danda hem kočini pe. Rodinđum te učenikonendar te ispudinen le mle čhavestar, ali našti ine te ćeren adava.” ");
INSERT INTO rmna_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","A o Isus phenđa lenđe: “O, biverakiri generacijo! Pana kobor valjani te ovav tumencar? Pana kobor valjani te trpinav tumen? Anen adale čhavore kora mande!” ");
INSERT INTO rmna_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","I on ande e čhavore koro Isus. Kad o bišukar duho dikhlja e Isuse, odmah frdinđa e čhavore ano grčevija. Ov pelo ki phuv hem lelja te irini pe ko sa o strane, a taro muj lelja te ikljol lestar pena. ");
INSERT INTO rmna_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","O Isus pučlja lesere dade: “Kobori već ov esavko?” A o dad phenđa: “Pana taro tikoripe. ");
INSERT INTO rmna_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Hem but puti frdela le ani jag ili ano pani te mudari le. Ali, te šaj nešto te ćere, smilujin tut amenđe hem pomožin amenđe.” ");
INSERT INTO rmna_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","A o Isus phenđa lese: “Te šaj? Sa šaj okolese kova verujini.” ");
INSERT INTO rmna_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","A e čhavoresoro dad odmah vičinđa: “Verujinava! Pomožin maje više te verujinav!” ");
INSERT INTO rmna_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Kad o Isus dikhlja so but manuša prastana nakoro lende, naredinđa e bišukare duhose: “Duhona so ćereja e manušen te našti vaćeren hem te našti šunen, naredinava će te ikljove olestar hem te na irine tut više ano leste!” ");
INSERT INTO rmna_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","I o bišukar duho vičinđa, zorale tresinđa e čhavore hem iklilo olestar. A o čhavoro ačhilo ki phuv sar mulo, i but džene phende da mulo. ");
INSERT INTO rmna_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ali o Isus dolinđa le oto vas hem vazdinđa le, hem o čhavoro terdino ko pre. ");
INSERT INTO rmna_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kad o Isus đerdinđa ko čher, lesere učenici inele korkore oleja hem pučle le: “Sose amen našti ine te ispudina e bišukare duho?” ");
INSERT INTO rmna_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","O Isus phenđa lenđe: “Akaja vrsta ispudini pe samo molitvaja.” ");
INSERT INTO rmna_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","I o Isus hem lesere učenici džele taro adava krajo hem nakhine maškari regija Galileja. O Isus na manglja o manuša te džanen dai adari ");
INSERT INTO rmna_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","adalese so manglja te sikaj samo ple učenikonen. Phenđa lenđe: “Me, o Čhavo e manušesoro, valjani te ovav predime ano vasta e bišukare manušengere. Ka mudaren man, ali palo trin dive ka uštav taro mule.” ");
INSERT INTO rmna_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ali o učenici na halile so o Isus manglja te vaćeri adaleja, a darandile te pučen le adalestar. ");
INSERT INTO rmna_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kad o Isus hem lesere učenici ale ani diz Kafarnaum hem kad inele ano čher, o Isus pučlja len: “Sostar raspravinđen odrumal?” ");
INSERT INTO rmna_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","A on trainde, adalese so odrumal raspravinde maškara pumende adalestar kovai olendar najbaro. ");
INSERT INTO rmna_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tegani o Isus beštino, vičinđa kora peste e dešu duje apostolen hem phenđa lenđe: “Kova mangela te ovel prvo, valjani te ovel zadnjo maškaro sarijende hem te ovel sluga sarijenđe.” ");
INSERT INTO rmna_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Tegani lelja jekhe čhavore, čhivđa le maškar olende, zagrlinđa le hem phenđa lenđe: ");
INSERT INTO rmna_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Svako kova primini jekhe esavke čhavore zbog maje, man primini. A svako kova man primini, na primini samo man, nego primini hem e Devle kova bičhalđa man.” ");
INSERT INTO rmna_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","O učeniko o Jovan phenđa e Isusese: “Učitelju, dikhljam nesave manuše sar ano to anav ispudini e demonen hem amen na mukljam lese te ćerel adava, adalese so na džala amencar pala tute.” ");
INSERT INTO rmna_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","A o Isus phenđa: “Muken le te ćerel adava! Adalese so nijekh kova ano mlo anav ćerela čudo našti odmah te vaćeri bišukar mandar. ");
INSERT INTO rmna_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Adalese so okova kova nane protiv amende, ovi amencar! ");
INSERT INTO rmna_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Adalese so, svako kova dela tumen đi hem jekh čaša panjeja te pijen adalese so injen mle, e Hristesere, čače vaćerava tumenđe da ka primini pli nagrada.” ");
INSERT INTO rmna_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Te neko ćerela jekh akale tikorendar kola verujinena ana mande te perel ano greh, po šukar ka ovel lese ine ki men te ovel lese phandlo baro bar hem te ovel frdime ano more. ");
INSERT INTO rmna_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Hem te to vas legari tut ano greh, čhin le. Po šukari će te đerdine ko večno dživdipe sakatime nego te oven tut soduj vasta, a te dža ko pakao, ki jag savi nikad na mudarđola, ");
INSERT INTO rmna_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","kote o čirme save hana len na merena hem i jag na mudarđola. ");
INSERT INTO rmna_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Te to pro legari tut ko greh, čhin le. Po šukari će te đerdine ko večno dživdipe sakatime nego te oven tut soduj pre, a te ove frdime ano pakao, ");
INSERT INTO rmna_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","kote o čirme save hana len na merena hem i jag na mudarđola. ");
INSERT INTO rmna_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Te ti jakh legari tut ko greh, ikal la. Po šukari će te đerdine ko carstvo e Devlesoro jekha jakhaja nego te oven tut soduj jaćha, a te ove frdime ano pakao ");
INSERT INTO rmna_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","kote o čirme save hana len na merena hem i jag na mudarđola. ");
INSERT INTO rmna_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Adalese so, svako ka ovel pročistime jagaja sar soi i žrtva pročistime loneja. ");
INSERT INTO rmna_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Šukari o lon. Ali te našalđa plo londipe, soja ov ka lonđari pe? Nek ovel tumen lon ana tumende, hem oven ano mir jekh avereja!” ");
INSERT INTO rmna_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","I o Isus iklilo tari diz Kafarnaum, i dželo ko krajo e Judejakoro hem ki aver strana oti len Jordan. I palem alo koro leste but narodo, a ov lelja te sikaj len, sar so uvek ćerela ine. ");
INSERT INTO rmna_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","I ale nakoro leste nesave fariseja mangindoj te iskušinen le, i pučle le: “Tromal li o rom te ačhaj pe romnja?” ");
INSERT INTO rmna_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","A ov pučlja len: “So naredinđa tumenđe o Mojsije?” ");
INSERT INTO rmna_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","On phende: “O Mojsije muklja e manušese pe romnjaće te del lil oto rastaviba hem te ačhaj la.” ");
INSERT INTO rmna_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","A o Isus phenđa lenđe: “O Mojsije pisinđa tumenđe adaja naredba adalese so injen šerale. ");
INSERT INTO rmna_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ali, ko anglunipe o Stvoritelj ‘ćerđa murše hem đuvlja’. ");
INSERT INTO rmna_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Adalese o manuš ka ačhaj pe dade hem pe daja hem ka ovel jekh pe romnjaja, ");
INSERT INTO rmna_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","hem on duj ka oven jekh telo.’ Ađahar on nane više duj, nego jekh telo. ");
INSERT INTO rmna_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Adalese, o manuš te na rastavini okolen so o Devel ćerđa te oven jekh!” ");
INSERT INTO rmna_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kad palem inele ano čher, o učenici pučle le adalestar, ");
INSERT INTO rmna_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","a o Isus phenđa lenđe: “Svako kova ačhaj pe romnja hem lela avera, ćerela preljuba premalo late. ");
INSERT INTO rmna_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Hem te i romni ačhaj pe rome hem lela avere, ćerela preljuba.” ");
INSERT INTO rmna_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","O manuša anena ine anglo Isus pumare čhavoren te čhivel ple vasta upro lende, a o učenici braninde lenđe. ");
INSERT INTO rmna_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Kad o Isus dikhlja adava, holjanđa hem phenđa lenđe: “Muken e čhavoren te aven kora mande hem ma braninen lenđe, adalese so esavkenđe pripadini o carstvo e Devlesoro! ");
INSERT INTO rmna_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Čače vaćerava tumenđe, ko na primini o carstvo e Devlesoro sar o čhavoro, nikad naka đerdini ano leste.” ");
INSERT INTO rmna_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Tegani zagrlinđa e čhavoren, čhivđa ple vasta upro lende hem blagoslovinđa len. ");
INSERT INTO rmna_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Sar o Isus lela ine te džal ko drom, prastandilo nakoro leste jekh manuš, pelo ko kočija anglo leste hem pučlja le: “Učitelju šukareja, so valjani te ćerav te dobinav o večno dživdipe?” ");
INSERT INTO rmna_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","A o Isus phenđa lese: “Sose vičineja man šukareja? Samoi jekh šukar – o Devel. ");
INSERT INTO rmna_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","O naredbe džane: ‘Ma mudar!’, ‘Ma ćer preljuba!’, ‘Ma čor!’, ‘Ma svedočin hovavne!’, ‘Ma prevarin’, ‘Poštujin te dade hem te daja!’” ");
INSERT INTO rmna_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","A ov phenđa: “Sa adava ićerava pana taro tikoripe.” ");
INSERT INTO rmna_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","O Isus dikhlja ano leste hem osetinđa mangipe olese, i phenđa lese: “Pana jekh ačhola tut te ćere: dža hem biknin sa so isi tut, a o pare de e čororenđe i ka ovel tut barvalipe ano nebo. Tegani ava hem phir pala mande.” ");
INSERT INTO rmna_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","A kad o terno manuš šunđa adava, rastužisalo hem dželo, adalese so na manglja te biknel plo baro barvalipe. ");
INSERT INTO rmna_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","O Isus dikhlja ano učenici hem phenđa lenđe: “Kobori pharo e barvalenđe te đerdinen ko carstvo e Devlesoro!” ");
INSERT INTO rmna_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","A o učenici čudinde pe ko adava so phenđa. A o Isus palem phenđa lenđe: “Mle čhavoralen, kobori pharo te đerdini pe ko carstvo e Devlesoro! ");
INSERT INTO rmna_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Po lokhei e kamilaće te nakhel maškaro kan e suvjakoro nego e barvalese te đerdini ko carstvo e Devlesoro.” ");
INSERT INTO rmna_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","A o učenici po više čudinde pe, i lelje maškara pumende te pučen pe: “Ko onda šaj te ovel spasime?” ");
INSERT INTO rmna_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","O Isus dikhlja len šukar, i phenđa: “E manušenđe adava nane moguće, ali na hem e Devlese. Adalese soi e Devlese sa moguće.” ");
INSERT INTO rmna_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","O Petar lelja te vaćeri lese: “Ače, amen sa ačhavđam te dža pala tute.” ");
INSERT INTO rmna_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","O Isus phenđa: “Čače vaćerava tumenđe, svako kova ačhavđa plo čher, ili e phraljen, ili e phenjen, ili e daja, ili e dade, ili e čhaven, ili o njive zbog maje hem zbog o Šukar lafi, ");
INSERT INTO rmna_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","akana, ano akava vreme, ka primini šel puti više: čhera, phraljen, phenjen, dajen, čhaven hem njive – uzalo adava ka ovel hem progonime – a ko sveto savo avela, ka primini o večno dživdipe. ");
INSERT INTO rmna_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ali, but okola kolai akana prva tegani ka oven zadnja, a okola kolen akate dikhena sar zadnjonen adari ka oven prva.” ");
INSERT INTO rmna_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Kad lelje te džan dromeja nakoro Jerusalim, o Isus džala ine anglo lende. O učenici inele začudime so džala ko Jerusalim, a okolen so džana ine palo lende uklinđa i dar. Tegani o Isus palem cidinđa ki strana e dešu duje apostolen, i lelja te vaćeri lenđe adalestar so ka ovel oleja: ");
INSERT INTO rmna_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Ače, đerdinaja ko Jerusalim. Adari man, e Čhave e manušesere, o manuša ka den ko šerutne sveštenici hem ko učitelja e Zakonestar, hem on ka osudinen man ko meriba. Tegani ka den man ko manuša kola nane Jevreja ");
INSERT INTO rmna_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","hem on ka maren muj mancar, ka čhungaren man, ka šibinen man hem ka mudaren man, a me palo trin dive ka uštav taro mule.” ");
INSERT INTO rmna_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Tegani uzalo Isus ale o Jakov hem o Jovan, e Zevedejesere čhave, hem phende lese: “Učitelju, mangaja te ćere amenđe so god ka roda tutar.” ");
INSERT INTO rmna_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","A ov pučlja len: “So mangena te ćerav tumenđe?” ");
INSERT INTO rmna_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","I on phende: “Muk amenđe, kad ka ove ani ti slava, te beša ko počasna thana uzala tute – jekh oti desno strana, a o dujto oti levo.” ");
INSERT INTO rmna_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","A o Isus phenđa lenđe: “Na džanen so rodena. Šaj li te pijen tari čaša savatar me pijava ili te krstinen tumen krstibnaja saveja me krstinava man?” ");
INSERT INTO rmna_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","A on phende lese: “Šaj.” Tegani o Isus phenđa: “Oja, ka patinen ađahar so ka pijen tari mli čaša hem so ka krstinen tumen krstibnaja saveja me krstinava man, ");
INSERT INTO rmna_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ali nane mlo te vaćerav ko ka bešel maje oti desno ili oti levo strana. Adalai thana okolenđe kolenđei spremime.” ");
INSERT INTO rmna_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Kad šunde adava avera deš apostolja, holjande upro Jakov hem upro Jovan. ");
INSERT INTO rmna_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Tegani o Isus vičinđa len kora peste hem phenđa: “Džanen da okola kola pes dikhena sar vladaren avere nacijengere, gospodarinena olencar, hem lengere bare manuša vladinena upro lende. ");
INSERT INTO rmna_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ali, ma te ovel ađahar maškar tumende. Nego, ko mangela te ovel baro maškar tumende, nek ovel tumenđe sluga. ");
INSERT INTO rmna_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ko mangela te ovel prvo maškar tumende, nek ovel sarijenđe robo. ");
INSERT INTO rmna_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Adalese so ni o Čhavo e manušesoro na alo te kanden le, nego te kandel hem te del plo dživdipe sar otkup butenđe.” ");
INSERT INTO rmna_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","I ađahar resle ani diz Jerihon. I sar o Isus ple učenikonencar hem bute narodoja ikljola ine taro Jerihon, uzalo drom bešela ine o kororo, o Vartimej (so značini “čhavo e Timejesoro”) hem prosini. ");
INSERT INTO rmna_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Kad šunđa so nakhela o Isus o Nazarećanin, vičinđa: “Isuse, čhaveja Davidesereja, smilujin tut maje!” ");
INSERT INTO rmna_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","But džene vičinde upro lese te traini, ali ov po zorale vičinđa: “Čhaveja Davidesereja, smilujin tut maje!” ");
INSERT INTO rmna_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","O Isus terdino hem phenđa: “Vičinen le.” I on vičinde e korore vaćerindoj: “Ma dara! Ušti, o Isus vičini tut!” ");
INSERT INTO rmna_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","A ov frdinđa pestar plo ogrtači, ripinđa ko pre hem alo koro Isus. ");
INSERT INTO rmna_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","I o Isus pučlja le: “So mangeja te ćerav će?” A o kororo phenđa: “Učitelju, mangava te dikhav.” ");
INSERT INTO rmna_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","A o Isus phenđa lese: “Dža. Ti vera sasljarđa tut.” I o manuš otojekhvar dikhlja hem lelja te džal dromeja palo Isus. ");
INSERT INTO rmna_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Kad o Isus hem lesere učenici ale paše uzali diz Jerusalim hem resle uzalo gava Vitfaga hem Vitanija ki e Maslinakiri gora, bičhalđa anglal duje učenikonen, ");
INSERT INTO rmna_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","vaćerindoj lenđe: “Džan ko adava gav savoi angla tumende. I so ka đerdinen, ka arakhen phandle terne here upro saveste pana nijekh manuš na beštino. Phraven le hem anen le akari. ");
INSERT INTO rmna_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Te neko pučlja tumen: ‘Sose ćerena adava?’, phenen lese: ‘E Gospodese valjani, ali sigate ka irini le palal.’ ” ");
INSERT INTO rmna_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","I on džele hem arakhle e terne here phandle ko udar, avri ko drom, i phravde le. ");
INSERT INTO rmna_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","A nesave manuša kola terdine adari pučle len: “Sose phravena e terne here?” ");
INSERT INTO rmna_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","On phende lenđe ađahar sar so o Isus sikavđa len, i o manuša mukle len. ");
INSERT INTO rmna_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","I ande e terne here anglo Isus. Čhivde pumare fostanja upro her, i o Isus beštino upro leste. ");
INSERT INTO rmna_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","But manuša buljarena ine pumare fostanja upro drom anglo leste, a nesave manuša buljarena ine o granke save čhinde ko polje. ");
INSERT INTO rmna_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","O manuša kola džele anglo leste hem palo leste vičinena ine: “‘Hosana! Blagoslovimei okova kova avela ano anav e Gospodesoro!’ ");
INSERT INTO rmna_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Blagoslovimei o carstvo amare pradadesoro e Davidesoro, savo avela! ‘Hosana e Devlese ko učipe!’” ");
INSERT INTO rmna_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","I o Isus đerdinđa ano Jerusalim, i dželo ko Hram hem sa dikhlja uzala peste. Ali, adalese so već lelja te perel i rat, lelja te džal ple dešu duje apostolencar ki Vitanija. ");
INSERT INTO rmna_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tejsato dive, kad iklile tari Vitanija, o Isus bokhalilo. ");
INSERT INTO rmna_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","I odural dikhlja e smokvakere kašte savoi pherdo listija, i dželo nakoro leste sar te arakhi nešto upro leste. Ali, kad alo đi o kaš, na arakhlja upro leste ništa sem listija, adalese so na inele vreme zako bijandipe e smokvakoro. ");
INSERT INTO rmna_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Tegani phenđa e kaštese: “Nikad više o manuša te na han to plod!” A adava šunde hem lesere učenici. ");
INSERT INTO rmna_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Kad resle ko Jerusalim, o Isus đerdinđa ano boro e Hramesoro hem lelja te ispudini adathar okolen so biknena hem so činena hem peravđa o astalja okolengere so menjinena o pare hem o klupe okolengere so biknena goluben. ");
INSERT INTO rmna_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Nikase na muklja maškaro boro e Hramesoro te akhari bilo so zako bikniba. ");
INSERT INTO rmna_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","I lelja te sikaj len, vaćerindoj: “Nane li pisime ano Sveto lil: ‘O čher mlo ka vičini pe čher zaki molitva zako sa o nacije’? A tumen ćerđen olestar ‘than kote čedena pe o čora!’” ");
INSERT INTO rmna_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Kad šunde adava o šerutne sveštenici hem o učitelja e Zakonestar, lelje te roden sar te ćeren o Isus te ovel mudardo, adalese so darandile olestar so sa o narodo divinđa pe lesere sikavibnaja. ");
INSERT INTO rmna_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kad peli i rat, o Isus hem lesere učenici iklile tari diz. ");
INSERT INTO rmna_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","A sabale, sar nakhena ine o Isus hem lesere učenici, dikhle so okova kaš e smokvakoro taro koreno šućilo. ");
INSERT INTO rmna_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","O Petar setinđa pe hem phenđa e Isusese: “Učitelju, dikh! Šućilo o kaš e smokvakoro save prokletinđan!” ");
INSERT INTO rmna_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","O Isus phenđa lenđe: “Nek ovel tumen vera ano Devel! ");
INSERT INTO rmna_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Čače vaćerava tumenđe, te neko vaćeri akala goraće: ‘Ikal tut hem frde tut ano more!’, a na sumnjini ano plo vilo, nego verujini da ka ovel ađahar sar so vaćeri, ka ovel lese adava. ");
INSERT INTO rmna_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Adalese vaćerava tumenđe: zako sa so molinena hem so rodena, verujinen da ka priminen, i ka ovel tumenđe adava. ");
INSERT INTO rmna_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Hem kad terđovena te molinen tumen, oprostinen te isi tumen nešto protiv nekaste, te šaj hem tumaro Dad, kovai ano nebo, te oprostini tumare grehija.” ");
INSERT INTO rmna_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ali, tumen te na oprostinđen, ni tumenđe tumaro Dad, kovai ano nebo, naka oprostini tumare grehija. ");
INSERT INTO rmna_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","I palem o Isus hem lesere učenici ale ano Jerusalim. Sar o Isus nakhela ine maškaro boro e Hramesoro, ale koro leste o šerutne sveštenici, o učitelja e Zakonestar hem o starešine ");
INSERT INTO rmna_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","hem pučle le: “Kotar tuće autoritet te ćere akava? Ko dinđa tut pravo?” ");
INSERT INTO rmna_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","O Isus phenđa lenđe: “Hem me tumen ka pučav nešto, i te phenđen maje, hem me tumenđe ka phenav kotar maje pravo te ćerav akava. ");
INSERT INTO rmna_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ko dinđa pravo e Jovane te krstini e manušen, o Devel kovai ano nebo ili o manuša? Phenen maje.” ");
INSERT INTO rmna_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","I on raspravinde pe maškara pumende vaćerindoj: “Te phenđam ‘o Devel kovai ano nebo’, ov ka pučel amen sose onda na verujinđam lese. ");
INSERT INTO rmna_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","A te phena ‘o manuša…’?” Ali darandile e narodostar, adalese so sare dikhle e Jovane sar čačikane proroko. ");
INSERT INTO rmna_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Adalese phende e Isusese: “Na džanaja.” I ov phenđa lenđe: “Ni me onda naka phenav tumenđe kotar maje pravo akava te ćerav.” ");
INSERT INTO rmna_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Tegani o Isus lelja te vaćeri lenđe ano priče, sar soi akaja: “Nesavo manuš sadinđa vinograd, ogradinđa le, handlja ano leste than zako pritiskiba i drakh hem vazdinđa e stražakiri kula. Tegani iznajminđa le nesave vinogradarenđe hem dželo ki aver phuv. ");
INSERT INTO rmna_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","I kad alo o vreme te čeden pe o drakha, bičhalđa e sluga koro vinogradarija te šaj lel plo deo oto bijandipe e drakhakoro. ");
INSERT INTO rmna_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ali o vinogradarija dolinde le, marde le hem bičhalde le palal čuče vastencar. ");
INSERT INTO rmna_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ov palem bičhalđa lenđe avere sluga, a on pharavde lesoro šero hem lađarde le. ");
INSERT INTO rmna_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Bičhalđa lenđe hem e tritone sluga, ali ole mudarde. Hem pana buten bičhalđa lenđe, a o vinogradarija jekhen marde, a averen mudarde. ");
INSERT INTO rmna_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ačhilo lese samo pana jekh: lesoro volime čhavo. Ko kraj bičhalđa hem ole, vaćerindoj: ‘Mle čhave ka poštujinen.’ ");
INSERT INTO rmna_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ali o vinogradarija vaćerde maškar pumende: ‘Akavai o nasledniko. Hajde te mudara le hem amenđe te ačhol o nasledstvo.’ ");
INSERT INTO rmna_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","I dolinde le, mudarde le hem frdinde le avri taro vinograd. ");
INSERT INTO rmna_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","So mislinena, so ka ćerel o gospodari e vinogradesoro? Ka avel hem ka mudari adale vinogradaren, a o vinograd ka iznajmini averenđe. ");
INSERT INTO rmna_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Na čitinđen li akava ano Sveto lil: ‘O bar savo odbacinde o zidarija ulo najbitno bar e čheresoro. ");
INSERT INTO rmna_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Adava o Gospod ćerđa hem adava ćerela amen te ova zadivime’?” ");
INSERT INTO rmna_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","A e jevrejengere vođe dikhena ine sar te dolen e Isuse, adalese so džande da vaćerđa adaja priča protiv olende, ali darandile e narodostar. Adalese ačhavde le hem džele. ");
INSERT INTO rmna_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","I e jevrejengere vođe bičhalde koro Isus nesave farisejen hem e manušen kola podržinena e Irode te dolen e Isuse ko bišukar lafi. ");
INSERT INTO rmna_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","On ale koro leste hem phende: “Učitelju, džanaja da vaćereja o čačipe hem na ićereja nikasiri strana, adalese so na dikheja koi kova, nego čačimase sikaveja o drom e Devlesoro. Vaćer amenđe so mislineja? Valjani li amen o Jevreja te da o porez e rimesere carose ili na? Te platina ili na?” ");
INSERT INTO rmna_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","A o Isus džanđa soi on dujemujengere manuša, i phenđa lenđe: “Sose iskušinena man? Anen maje te dikhav i kovanica savaja platinena o porez.” ");
INSERT INTO rmna_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","On dinde le denari, a ov pučlja len: “Kasiri slika hem kasoroi anav ki kovanica?” A on phende: “E carosoro.” ");
INSERT INTO rmna_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Tegani o Isus phenđa lenđe: “Onda den soi e carosoro e carose, a soi e Devlesoro e Devlese.” I on inele but zadivime lesere vaćeribnaja. ");
INSERT INTO rmna_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Tegani ale koro Isus hem nesave sadukeja, kola vaćerena da nane uštiba taro mule, i pučle e Isuse: ");
INSERT INTO rmna_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Učitelju, o Mojsije pisinđa amenđe so te ćerel o manuš te mulo lesoro phral kova pala peste ačhavđa romnja bizo čhave. Adava manuš valjani te lel ple phralesere romnja te šaj oj te bijani čhave kova ka ovel nasledniko e mulesoro. ");
INSERT INTO rmna_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Inele efta phralja. O prvo lelja romnja i mulo, a na ačhavđa pala peste čhaven. ");
INSERT INTO rmna_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","O dujto phral lelja ple phralesere romnja, ali hem ov mulo, a na ačhavđa pala peste čhaven. Ađahar ulo hem e tritoneja. ");
INSERT INTO rmna_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","I nijekh oto efta phralja na ačhavđa pala peste čhaven. Ko kraj muli hem i romni. ");
INSERT INTO rmna_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kasiri onda romni oj ka ovel kad ka uštel pe taro mule, a inele dindi ko sa o efta phralja?” ");
INSERT INTO rmna_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","O Isus phenđa lenđe: “Injen hovavde, adalese so na haljovena ni o Sveto lil ni e Devlesoro zoralipe. ");
INSERT INTO rmna_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Adalese so, kad ka ušten taro mule, o manuša ni ka len pe ni ka den pe, nego ka oven sar o anđelja ano nebo. ");
INSERT INTO rmna_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","A zako uštiba taro mule, na čitinđen li ano Lil e Mojsijasoro kote pisini oto grmo savo ine thabljola, kad o Devel phenđa e Mojsijase: ‘Me injum o Devel e Avraamesoro, e Isaakesoro hem e Jakovesoro’ kola mule odavno? ");
INSERT INTO rmna_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","A o Devel nane Devel e mulengoro, nego Devel e dživdengoro. But hovavdiljen.” ");
INSERT INTO rmna_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Tegani alo jekh učitelj e Zakonestar, kova šunđa lengiri rasprava. Dikhlja so o Isus šukar phenđa lenđe, i pučlja le: “Oto sa o naredbe, savi najbari?” ");
INSERT INTO rmna_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","O Isus phenđa: “Akajai najbari: ‘Šun, Izraele! O Gospod, amaro Devel, samoi ov Gospod! ");
INSERT INTO rmna_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Volin e Gospode te Devle, sa te vileja, sa te dušaja, sa te gođaja hem sa te zoralipnaja.’ ");
INSERT INTO rmna_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","A i dujtoi: ‘Volin te pašutne sar korkore tut.’ Nane po bare naredbe akalendar.” ");
INSERT INTO rmna_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","O učitelj e Zakonestar phenđa: “Šukar phenđan, učitelju. U pravu injan kad pheneja dai samo ov Gospod hem da nane avera sem leste. ");
INSERT INTO rmna_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Te volini pe ole taro sa o vilo, tari sa i godi hem taro sa o zoralipe, hem te volini pe e pašutne sar korkore pes po bitnoi taro sa o žrtve paljenice hem taro avera žrtve.” ");
INSERT INTO rmna_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","I dikhindoj so šukar vaćeri, o Isus phenđa lese: “Na injan dur taro carstvo e Devlesoro.” I nijekh više na tromandilo te pučel le nešto. ");
INSERT INTO rmna_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Sar sikaj ine e manušen ano Hram, o Isus pučlja: “Sar šaj o učitelja e Zakonestar te vaćeren dai o Hrist samo e Davidesoro čhavo? ");
INSERT INTO rmna_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Korkoro o David, ano Sveto Duho, phenđa: ‘O Gospod phenđa mle Gospodese: Beš ko počasno than, oti mli desno strana, đikote na pašljarava te neprijateljen talo te pre!’ ");
INSERT INTO rmna_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Korkoro o David vičini le ‘Gospode’. Sar šaj onda o Hrist te ovel samo lesoro čhavo?” A but džene oduševime šunena le ine. ");
INSERT INTO rmna_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","I sar sikaj len ine, o Isus phenđa: “Arakhen tumen e učiteljendar e Zakonestar! On volinena te phiren urjavde ano skupa fostanja, hem te pozdravinen len o manuša ko trgija. ");
INSERT INTO rmna_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Volinena te bešen ko anglune thana ano sinagoge hem ko najšukar thana ko gozbe. ");
INSERT INTO rmna_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Hana o imanje e udovicengoro hem ćerena pe dai pobožna ađahar so molinena bare molitve. On ka oven po zorale kaznime nego avera manuša.” ");
INSERT INTO rmna_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","I o Isus beštino uzali e hramesiri kutija zako čediba hem lelja te dikhel sar o manuša čhivena ano late pare. I but barvale manuša čhivde but pare. ");
INSERT INTO rmna_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ali hem jekh čorori udovica hem čhivđa samo duj najtikore kovanice, save but hari vredinde. ");
INSERT INTO rmna_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Tegani o Isus vičinđa kora peste ple učenikonen hem phenđa lenđe: “Čače vaćerava tumenđe, akaja čorori udovica čhivđa više sarijendar kola čhivde pare ani kutija zako čediba. ");
INSERT INTO rmna_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Adalese so sare on dinde oto buderi so isi len, a oj, kojai čorori, dinđa sa so inola zako živiba.” ");
INSERT INTO rmna_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Sar o Isus ikljola ine taro Hram, jekh lesere učenikonendar phenđa lese: “Učitelju, dikh! Soi bare bara hem soi šuže građevine!” ");
INSERT INTO rmna_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","A o Isus phenđa lese: “Dikheja li akala bare građevine? Olendar naka ačhol ni bar upro bar. Svako ka ovel peravdo.” ");
INSERT INTO rmna_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","I sar o Isus bešela ine ki e Maslinakiri gora, kotar šaj te dikhel pe o Hram, o Petar, o Jakov, o Jovan hem o Andreja inele korkore oleja hem pučle le: ");
INSERT INTO rmna_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Vaćer amenđe, kad adava ka ovel hem savo ka ovel o znako da sa adava ka pherđol?” ");
INSERT INTO rmna_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","I o Isus lelja te vaćeri lenđe: “Dikhen te na oven hovavde nekastar. ");
INSERT INTO rmna_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","But džene ka aven ano mlo anav vaćerindoj: ‘Me injum o Hrist’ hem buten ka hovaven. ");
INSERT INTO rmna_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","A kad šunena da ovena mariba hem da vaćeri pe e maribnastar, ma te daran. Adalese so prvo adava valjani te ovel, ali adava pana nane kraj. ");
INSERT INTO rmna_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Adalese so ka uštel jekh nacija upri aver nacija hem jekh carstvo upro aver carstvo. Ko but thana ka oven zemljotresija, hem ka ovel bokhalipe. Adavai samo o anglunipe e bijandipnasere mukengoro. ");
INSERT INTO rmna_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","A tumen arakhen tumen! Ka legaren tumen ko sudo hem ka maren tumen ano sinagoge. Ka terđoven anglo vladarija hem anglo carija adalese so injen mle učenici. Adava ka ovel te šaj svedočinen lenđe mandar. ");
INSERT INTO rmna_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","O Šukar lafi najangle valjani te vaćeri pe sa e nacijenđe. ");
INSERT INTO rmna_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","A kad ka dolen tumen te legaren tumen ko sudo, ma angleder brininen tumen so valjani te vaćeren, nego tegani ka del pe tumenđe so te vaćeren. Adalese so naka vaćeren tumen, nego o Sveto Duho. ");
INSERT INTO rmna_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","O phral e phrale ka del te mudaren le, a o dad e čhave. O čhave ka ušten upro pumare dada hem daja hem ka ćeren lenđe te oven mudarde. ");
INSERT INTO rmna_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Sare ka mrzinen tumen adalese so injen mle učenici. Ali kova ačhola verno đi o kraj, ka ovel spasime. ");
INSERT INTO rmna_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","A kad ka dikhen da o ‘gadost savo anela uništenje’ terđola adari kaj nane lesoro than (ko akava čitini, nek haljol), tegani okola kola živinena ani e judejakiri regija nek našen ko gore. ");
INSERT INTO rmna_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ko ka ovel upro čher, ma te huljel te đerdini te lel nešto taro čher! ");
INSERT INTO rmna_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ko ka ovel ki njiva, ma te irini pe čhere te lel plo fostani! ");
INSERT INTO rmna_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Pharo ka ovel e khamnjenđe hem okolenđe kola dena čuči ko adala dive! ");
INSERT INTO rmna_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Molinen tumen o našiba te na ovel ko jevend, ");
INSERT INTO rmna_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","adalese so adala dive ka ovel bari nevolja savi na inele taro anglunipe, kad o Devel ćerđa i phuv, đi akana, ni nikad palo adava naka ovel. ");
INSERT INTO rmna_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","I te na skratini ine o Gospod o broj adale divengoro, sare ka meren ine. Ali zbog o birime kolen o Devel birinđa, odlučinđa te skratini adala dive. ");
INSERT INTO rmna_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Te phenđa tumenđe neko tegani: ‘Ače akatei o Hrist’, ili ‘Eče adari’, ma verujinen. ");
INSERT INTO rmna_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Adalese so ka ikljoven hovavne hristija hem hovavne proroci hem ka ćeren znakija hem čudesija sar, te šaj ine, te hovaven hem e Devlesere birimen. ");
INSERT INTO rmna_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","A tumen arakhen tumen! Sa vaćerđum tumenđe angleder o vreme.” ");
INSERT INTO rmna_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“A ko adala dive, palo adala nevolje, ‘o kham ka kaljol hem o masek naka sijajini, ");
INSERT INTO rmna_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","o čerenja ka peren taro nebo hem o zoralipa e nebosere ka oven potresime’. ");
INSERT INTO rmna_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tegani o manuša ka dikhen man, e Čhave e manušesere, sar avava upro oblaci ano baro zoralipe hem ani slava. ");
INSERT INTO rmna_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Hem tegani ka bičhalav mle anđelen te čeden mle birimen taro sa o štar strane e phuvjakere, taro krajo e phuvjakoro đi o krajo e nebosoro. ");
INSERT INTO rmna_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","A oti smokva sikljoven akava: Kad lakere granke zrelonena hem ikljona listija upro lende, džanena dai paše o linaj. ");
INSERT INTO rmna_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ađahar hem tumen kad dikhena da ovela sa adava, te džanen dai adava vreme paše, dai anglo udar. ");
INSERT INTO rmna_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Čače vaćerava tumenđe, akaja generacija naka nakhel đikote sa adava na ovela. ");
INSERT INTO rmna_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","O nebo hem i phuv ka nakhen, ali mle lafija nikad naka nakhen.” ");
INSERT INTO rmna_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“A niko na džanel adava dive ili adava sati kad adava ka ovel. Na džanen ni o anđelja ko nebo ni o Čhavo. Džanel samo o Dad. ");
INSERT INTO rmna_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Džangale pazinen, adalese so na džanen kad adava vreme ka avel. ");
INSERT INTO rmna_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Adavai sar kad jekh manuš lela te džal ko drom: ačhaj o čher, dela autoritet e slugenđe hem svakonese dela te ćeren lesiri buti, a e stražarese naredini džangale te pazini. ");
INSERT INTO rmna_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Adalese džangale pazinen, adalese so na džanen kad o gospodari e čheresoro ka avel – angli rat, ki ekvaš i rat, anglo disljojba kad o bašne đilabena ili sabale – ");
INSERT INTO rmna_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","te na avel otojekhvar hem te arakhel tumen sar sovena. ");
INSERT INTO rmna_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","A adava so phenava tumenđe, phenava sarijenđe: džangale pazinen!” ");
INSERT INTO rmna_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Inele pana duj dive đi i Pasha hem o Prazniko e bikvascone marengoro. O šerutne sveštenici hem o učitelja e Zakonestar rodena ine ko hovavne te dolen e Isuse sar te ćeren te ovel mudardo. ");
INSERT INTO rmna_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ali phende: “Naka ćera adava zako vreme e praznikosoro, te na pobunini pe o narodo.” ");
INSERT INTO rmna_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","A o Isus inele ano gav Vitanija, ano čher e Simonesoro e Gubavcosoro. I sar inele uzalo astali, ali koro leste jekh đuvli e čareja, savo inele ćerdo oto šužo bar, ano savo inele skupo mirisno ulje oto čisto nard, i phaglja o bokali hem čhorđa o ulje upro lesoro šero. ");
INSERT INTO rmna_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","I nesave manuša kola inele adari lelje te holjanen, vaćerindoj jekh averese: “Sose ađahar bespotrebno čhorela pe o skupo miris? ");
INSERT INTO rmna_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Adava ulje šaj ine te biknel pe zaki jekhe beršesiri plata, i o pare te den pe e čororenđe.” I holjame vičinde upro late. ");
INSERT INTO rmna_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ali o Isus phenđa: “Muken la! Sose uznemirinena la? Oj ćerđa maje šukaripe. ");
INSERT INTO rmna_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Adalese so, o čorore manuša uvek ka oven uzala tumende hem šaj te pomožinen lenđe kad god mangena, a me naka ovav uvek tumencar. ");
INSERT INTO rmna_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Oj ćerđa so šaj ine. Angleder makhlja mlo telo, te pripremini man zako paruniba. ");
INSERT INTO rmna_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Čače vaćerava tumenđe, kaj god, ki sa i phuv, ka vaćeri pe o Šukar lafi, ka vaćeri pe hem akalestar so oj ćerđa, sar setiba olatar.” ");
INSERT INTO rmna_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Tegani o Juda Iskariot, jekh oto dešu duj apostolja, dželo koro šerutne sveštenici te dogovorini pe olencar te izdajini lenđe e Isuse. ");
INSERT INTO rmna_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","A on, kad šunde adava, ule radosna hem dinde lese pumaro lafi da ka den le pare, i ov lelja te rodel šukar prilika te izdajini e Isuse. ");
INSERT INTO rmna_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ko prvo dive oto Prazniko e bikvascone marengoro, kad čhinela pe bakrore zaki Pasha, o učenici pučle e Isuse: “Kaj mangeja te dža te ćera će te ha e pashakoro hajba?” ");
INSERT INTO rmna_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","I o Isus bičhalđa dujen ple učenikonendar vaćerindoj lenđe: “Džan ki diz hem adari ka resel tumen jekh manuš kova akhari pani ano khoro. Džan palo leste. ");
INSERT INTO rmna_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ko čher ko savo ka đerdini roden e domaćine hem vaćeren lese: ‘O učitelj pučela ki savi soba šaj te hal e pashakoro hajba ple učenikonencar?’ ");
INSERT INTO rmna_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","I ov ka mothoj tumenđe i bari upruni soba savi već pripremime. Adari ćeren amenđe zako hajba.” ");
INSERT INTO rmna_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","I o učenici džele ki diz hem arakhle sa ađahar sar so phenđa lenđe o Isus, i adari ćerde zako hajba e pashakoro. ");
INSERT INTO rmna_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kad peli i rat, o Isus dželo adari ple dešu duje apostolencar. ");
INSERT INTO rmna_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","I sar hana ine uzalo astali, o Isus phenđa lenđe: “Čače vaćerava tumenđe, jekh tumendar, kova akana hala mancar, ka izdajini man!” ");
INSERT INTO rmna_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","On but rastužisale, i lelje jekh palo avereste te pučen le: “Te na injum me adava?” ");
INSERT INTO rmna_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","A ov phenđa lenđe: “Adavai jekh tumendar, e dešu duje apostolendar, kova mancar macini o maro ano čaro. ");
INSERT INTO rmna_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Adalese so, me, o Čhavo e manušesoro, valjani te merav sar so pisini ano Sveto lil, ali jao okole manušese kova ka izdajini man! Po šukar ka ovel lese ine te na ovel ine bijando!” ");
INSERT INTO rmna_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Sar hana ine, o Isus lelja o maro, zahvalinđa e Devlese hem phaglja le, i dinđa le e apostolenđe, vaćerindoj: “Len! Akavai mlo telo.” ");
INSERT INTO rmna_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tegani lelja i čaša e moljaja, zahvalinđa e Devlese hem dinđa la olenđe, i sare pile olatar. ");
INSERT INTO rmna_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","I phenđa lenđe: “Akavai mlo rat, o rat oto savez, savo čhorela pe butenđe. ");
INSERT INTO rmna_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Čače vaćerava tumenđe: naka pijav više mol sa đi o dive kad ka pijav i nevi mol ano carstvo e Devlesoro.” ");
INSERT INTO rmna_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Tegani đilabde psalmija, i džele ki e Maslinakiri gora. ");
INSERT INTO rmna_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","I o Isus phenđa lenđe: “Sare ka ačhaven man, adalese soi pisime ano Sveto lil: ‘Ka mudarav e pastire, hem o bakre ka našen.’ ");
INSERT INTO rmna_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ali kad ka uštav taro mule, ka džav angla tumende ki Galileja.” ");
INSERT INTO rmna_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","A o Petar phenđa lese: “I sare te ačhavde tut, me naka ačhavav tut!” ");
INSERT INTO rmna_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","O Isus phenđa lese: “Čače vaćerava će, pana ki akaja rat, angleder so o bašno duj puti ka đilabi, trin puti ka hovave da na pendžareja man.” ");
INSERT INTO rmna_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ali o Petar po zorale vaćeri ine: “Naka ćerav adava, čak hem te valjani te merav tuja!” I ađahar vaćerde sa o učenici. ");
INSERT INTO rmna_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tegani džele ko than vičime Getsimanija. I o Isus phenđa ple učenikonenđe: “Bešen akate đikote me molinav man!” ");
INSERT INTO rmna_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Peja lelja e Petre, e Jakove hem e Jovane. Uklinđa le baro nemir hem pharipe, ");
INSERT INTO rmna_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","i phenđa lenđe: “Edobor injum žalosno da mlo vilo ka pharjol! Ačhoven akate hem džangale pazinen.” ");
INSERT INTO rmna_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","I dželo hari po dur, pelo mujeja đi phuv hem molinđa pe e Devlese, te šaj, te cidel lestar o pharo vreme savo adžićeri le. ");
INSERT INTO rmna_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Phenđa: “Abba! Dade! Tu sa šaj. Cide akaja čaša e patnjaja mandar. Ali, nek ovel pali ti volja, a na pali mli.” ");
INSERT INTO rmna_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tegani irinđa pe koro učenici hem arakhlja len sar sovena, i phenđa e Petrese: “Simone, tu li soveja? Našti li ine nijekh sati džangale te pazine? ");
INSERT INTO rmna_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Džangale pazinen hem molinen tumen te na peren ko iskušenje. O duho mangela te ćerel okova soi šukar, ali o teloi bizoralo.” ");
INSERT INTO rmna_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","I palem dželo hem molinđa pe, vaćerindoj ista lafija. ");
INSERT INTO rmna_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","I palem, kad irinđa pe, arakhlja len sar sovena adalese so phandljona ine lengere jaćha, i na džande so te phenen lese. ");
INSERT INTO rmna_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Kad o trito puti irinđa pe, phenđa lenđe: “Pana li sovena hem odmorinena? Šukari više! Alo o sati! Ače, me, o Čhavo e manušesoro, ka ovav dindo ko vasta e grešnikonengere. ");
INSERT INTO rmna_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ušten! Hajde! Ače mlo izdajniko avela.” ");
INSERT INTO rmna_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","I sar pana o Isus vaćeri ine adava, reslo o Juda, jekh e dešu duje apostolendar, hem oleja, e mačencar hem e kaštencar, but manuša kolen bičhalde o šerutne sveštenici, o učitelja e Zakonestar hem o starešine. ");
INSERT INTO rmna_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","A o Juda, lesoro izdajniko, pana angleder dinđa len znako vaćerindoj: “Kas ka čumudinav – ovi adava. Ole dolen hem legaren le tali straža.” ");
INSERT INTO rmna_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","I so alo đi o Isus, phenđa: “Učitelju”, hem čumudinđa le ki čham. ");
INSERT INTO rmna_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Tegani o manuša dolinde le hem phandle le. ");
INSERT INTO rmna_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","A jekh okolendar, kola inele adari uzalo Isus, ikalđa o mači, hem khuvđa oleja e prvosveštenikosere sluga hem čhinđa lesoro kan. ");
INSERT INTO rmna_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","O Isus phenđa lenđe: “Mačencar hem kaštencar aljen pala mande te dolen man, sar palo pobunjeniko. ");
INSERT INTO rmna_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Divencar injumle tumencar ano Hram hem sikavđum e narodo, ali na dolinđen man. Ali ađahar ulo sar te pherđol okova soi mandar pisime ano Sveto lil.” ");
INSERT INTO rmna_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tegani sa o učenici ačhavde le hem našle. ");
INSERT INTO rmna_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","A palo leste džala ine jekh terno čhavo, učhardo skupone čaršaveja upro nango telo. Hem ole dolinde, ");
INSERT INTO rmna_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ali ov tegani muklja o čaršavi hem nango našlo olendar. ");
INSERT INTO rmna_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","I legarde e Isuse koro prvosvešteniko, i čedinde pe sa o šerutne sveštenici, o starešine hem o učitelja e Zakonestar. ");
INSERT INTO rmna_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","A o Petar odural džala ine palo Isus sa đi ko boro e prvosveštenikosoro, i adari bešlo e slugencar hem tačola ine uzali jag. ");
INSERT INTO rmna_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","A o šerutne sveštenici hem sa o sabor rodena ine nesavo svedočiba protiv o Isus sar te šaj ćeren te ovel mudardo, ali našti ine te arakhen le. ");
INSERT INTO rmna_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","A but džene svedočinena ine hovavne protiv oleste, ali lengoro vaćeriba na inele sar jekh. ");
INSERT INTO rmna_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Tegani nesave svedoci uštine, i hovavne svedočinde protiv oleste vaćerindoj: ");
INSERT INTO rmna_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Šunđam le sar vaćeri: ‘Ka peravav akava Hram savoi ćerdo e manušengere vastencar, hem zako trin dive ka vazdav aver, savo naka ovel ćerdo e manušengere vastencar.’ ” ");
INSERT INTO rmna_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ali ni adava lengoro vaćeriba na inele sar jekh. ");
INSERT INTO rmna_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tegani o prvosvešteniko uštino, terdino ko maškar, hem pučlja e Isuse: “Tut li nane so te phene ko akava so vaćerde protiv tute?” ");
INSERT INTO rmna_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","A o Isus trainđa hem ništa na vaćerđa. Tegani o prvosvešteniko pučlja le: “Tu li injan o Hrist, o Čhavo e Blagoslovime Devlesoro?” ");
INSERT INTO rmna_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","O Isus phenđa: “Oja, me injum. Hem ka dikhen man, e Čhave e manušesere, sar bešava ko počasno than, oti desno strana e Najzorale Devlesiri hem sar avava upro oblaci e nebosere.” ");
INSERT INTO rmna_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ko adava o prvosvešteniko pharavđa ple šeja oti holi hem phenđa: “Na valjani amenđe više svedoci! ");
INSERT INTO rmna_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Šunđen sar hulinđa upro Devel! So mislinena?” I sarijengiri osuda inele da zaslužini te merel. ");
INSERT INTO rmna_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tegani nesave lelje te čhungaren le, te učharen lesere jaćha hem te khuven le dumukhencar, vaćerindoj lese: “Prorokujin ko khuvđa tut!” Palo adava o sluge lelje e Isuse hem khuvena le ine šamarke. ");
INSERT INTO rmna_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","I sar o Petar inele tele ano boro, adari ali jekh sluškinja e prvosveštenikosiri. ");
INSERT INTO rmna_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Oj dikhlja e Petre sar tačola uzali jag, i po šukar dikhlja ano leste hem phenđa: “Hem tu injanle adale Nazarećanineja, e Isuseja!” ");
INSERT INTO rmna_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","A o Petar hovavđa vaćerindoj: “Ni džanava, ni haljovava sostar vaćereja!” I dželo nakori kapija e borosiri. A o bašno đilabđa. ");
INSERT INTO rmna_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Okoja sluškinja palem dikhlja le, i lelja te vaćeri okolenđe kola terđona ine adari: “Akavai manuš jekh olendar!” ");
INSERT INTO rmna_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","A o Petar palem hovavđa da nane. Na nakhlo but palo adava, okola kola terđona ine adari phende e Petrese: “Tu čače injan jekh olendar, adalese so hem tu injan Galilejco!” ");
INSERT INTO rmna_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","A ov lelja te vičini prokletstvija upra peste hem te hal pe sovli: “Na pendžarava adale manuše kastar vaćerena!” ");
INSERT INTO rmna_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","I odmah, palo dujto puti, o bašno đilabđa. Tegani o Petar setinđa pe e lafendar save o Isus phenđa lese: “Angleder so o bašno duj puti ka đilabi, trin puti ka hovave da na pendžareja man.” I lelja zorale te rovel. ");
INSERT INTO rmna_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Odmah sabale, o šerutne sveštenici, o starešine hem o učitelja e Zakonestar hem sa o sabor ande odluka, i phandle e Isuse, legarde le hem dinde le ko Pilat. ");
INSERT INTO rmna_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","I o Pilat pučlja le: “Tu li injan o caro e Jevrejengoro?” A o Isus phenđa: “Ađahari sar so pheneja.” ");
INSERT INTO rmna_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","A o šerutne sveštenici lelje te tužinen le zako but so. ");
INSERT INTO rmna_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Tegani o Pilat palem pučlja le: “Tut li nane so te phene ko adava? Dikheja li zako so tut sa tužinena?” ");
INSERT INTO rmna_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ali o Isus ništa na phenđa, i o Pilat but začudinđa pe. ");
INSERT INTO rmna_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","A o Pilat ko prazniko Pasha mukela ine e narodose jekhe phandle Jevrejco kole on mangle. ");
INSERT INTO rmna_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Tegani ano phandlipe, e pobunjenikonencar kola mudarde ani pobuna, inele hem o manuš vičime Varava. ");
INSERT INTO rmna_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","O narodo alo, i lelja te rodel e Pilatestar, palo lesoro adeti, te mukel lenđe jekhe phandle. ");
INSERT INTO rmna_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","A o Pilat pučlja len: “Mangena li te mukav tumenđe e jevrejengere caro?” ");
INSERT INTO rmna_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Adalese so džanđa so o šerutne sveštenici e Isuse predinde tari zavist. ");
INSERT INTO rmna_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ali o šerutne sveštenici pherde e narodo te roden te mukel lenđe e Varava, umesto e Isuse. ");
INSERT INTO rmna_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","A o Pilat palem pučlja len: “A so mangena te ćerav akaleja kole vičinena caro e jevrejengoro?” ");
INSERT INTO rmna_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","A on vičinde: “Čhiv le ko krsto!” ");
INSERT INTO rmna_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","A o Pilat pučlja len: “A savo bišukaripe ćerđa?” Ali on pana po zorale vičinde: “Čhiv le ko krsto!” ");
INSERT INTO rmna_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","I o Pilat, mangindoj te ćerel e narodosiri volja, muklja lenđe e Varava, a e Isuse dinđa ko vojnici te šibinen le hem palo adava te čhiven le ko krsto. ");
INSERT INTO rmna_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","I o vojnici legarde e Isuse ki e Pilatesiri palata, ko Pretorijum, i čedinde sa i četa e vojnikonendar. ");
INSERT INTO rmna_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Urjavde le ano lolo ogrtači, ćerde kruna oto kare hem čhivde lese ko šero, ");
INSERT INTO rmna_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","i lelje te maren muj oleja vaćerindoj: “Te ove sasto e jevrejengere carona!” ");
INSERT INTO rmna_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","I khuvena le ine e trskaja ko šero, čhungarena le ine hem perena anglo leste ko kočija sar te ćeren pe da slavinena le. ");
INSERT INTO rmna_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","I palo adava so marde muj oleja, huljavde lestar o lolo ogrtači, hem urjavde le lesere šeja, i legarde le avri te čhiven le ko krsto. ");
INSERT INTO rmna_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","A jekhe manuše, e Simone tari Kirinija, e Aleksandresere hem e Rufesere dade, kova nakhela ine adathar irindoj taro polje, terinde le te akhari e Isusesoro krsto. ");
INSERT INTO rmna_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","I ande e Isuse ko than vičime Golgota – so značini “Kokalo e šeresoro.” ");
INSERT INTO rmna_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","I kaninde le mol mešime e smirnaja zbog o dukha, ali ov na manglja te pijel. ");
INSERT INTO rmna_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","I kad čhivde le ko krsto, delinde maškara pumende lesere šeja ađahar so frdinde barbuti olenđe, te dikhen ko so ka lel. ");
INSERT INTO rmna_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Kad čhivde le ko krsto, inele enja o sati sabale. ");
INSERT INTO rmna_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Upreder lesoro šero terdino znako kote inele pisime lesiri krivica: O Caro e Jevrejengoro . ");
INSERT INTO rmna_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Oleja čhivde ko avera krstija hem duje pobunjenikonen, jekhe oti lesiri desno, a e dujtone oti lesiri levo strana. ");
INSERT INTO rmna_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ađahar pherdilo okova so terđola ano Sveto lil: “Dikhle le sar jekhe zločinco.” ");
INSERT INTO rmna_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","A okola kola nakhena ine adale dromeja vređinena le ine. Mrdinena ine šerencar, vaćerindoj: “Ej, tu kova peraveja o Hram hem vazdeja le zako trin dive, ");
INSERT INTO rmna_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","spasin tut! Hulji taro krsto!” ");
INSERT INTO rmna_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ađahar da marde muj oleja o šerutne sveštenici, zajedno e učiteljencar e Zakonestar, vaćerindoj jekh averese: “Averen spasinđa, a pes našti te spasini! ");
INSERT INTO rmna_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ovi o Hrist, o caro e Izraelesoro! Nek huljel akana taro krsto te dikha, i ka verujina ano leste.” A vređinena le ine hem okola kola inele čhivde ko krsto oleja. ");
INSERT INTO rmna_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","A ko ekvaš o dive, i tomina učharđa sa i phuv hem ađahar inele trin saća. ");
INSERT INTO rmna_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ko trin o sati, o Isus vičinđa oto sa o glaso: “Eloi, Eloi, lema sabahtani?” (so značini: “Devla mleja, Devla mleja, sose ačhavđan man?”) ");
INSERT INTO rmna_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Kad adava šunde nesave okolendar kola terđona ine adari, phende: “Dikh, vičini e Ilija.” ");
INSERT INTO rmna_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","A jekh olendar prastandilo hem čhivđa o sunđeri ani ušli mol, čhivđa le upri trska, hem dinđa e Isusese te pijel, vaćerindoj: “Adžićeren, te dikha ka avel li o Ilija te huljaj le!” ");
INSERT INTO rmna_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","A o Isus vičinđa oto sa o glaso, i muklja pli duša. ");
INSERT INTO rmna_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Tegani e hramesiri zavesa pharavdili ko ekvaš, odupral natele. ");
INSERT INTO rmna_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","A kad o kapetani, kova terdino anglo Isus, dikhlja le sar mulo, phenđa: “Čače akava manuš inele e Devlesoro Čhavo!” ");
INSERT INTO rmna_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","A adari inele hem nesave đuvlja kola sa adava dikhena ine odural. Maškar olende inele i Marija Magdalena, i Marija, e terne Jakovesiri hem e Josijasiri daj, hem i Saloma – ");
INSERT INTO rmna_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","kola džana ine palo Isus kad inele ani Galileja hem kandena le ine, hem pana but avera đuvlja kola oleja ale ano Jerusalim. ");
INSERT INTO rmna_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Kad lelja te raćol, adalese so inele Dive zako pripremiba – dive anglo savato, ");
INSERT INTO rmna_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","o Josif tari diz Arimateja, kova inele ugledno člano oto e jevrejengoro sabor, kova hem korkoro adžićeri ine o carstvo e Devlesoro, bizi dar đerdinđa koro Pilat hem rodinđa te den le o telo e Isusesoro. ");
INSERT INTO rmna_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","A o Pilat čudinđa pe so o Isus već mulo, i terinđa te vičinen koro leste e kapetane te pučel le čače li o Isus već mulo. ");
INSERT INTO rmna_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Kad o kapetani phenđa so čače o Isus mulo, o Pilat naredinđa te den o telo e Isusesoro ko Josif. ");
INSERT INTO rmna_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","I o Josif činđa skupo čaršavi, huljavđa o telo e Isusesoro taro krsto, paćarđa le čaršaveja hem čhivđa le ano grobo savo inele ćerdo ani stena. Hem o udar e grobosoro phandlja e bare bareja. ");
INSERT INTO rmna_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","A i Marija Magdalena hem i Marija e Josijasiri daj dikhena ine kaj čhivena lesoro telo. ");
INSERT INTO rmna_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kad nakhlo o savato, i Marija Magdalena, i Marija e Jakovesiri daj, hem i Saloma činde mirisija sar te šaj džan hem te makhen e Isusesoro telo. ");
INSERT INTO rmna_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","I rano sabale ko prvo dive oto kurko, kad o kham iklilo, lelje te džan ko grobo. ");
INSERT INTO rmna_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Odrumal pučena pe ine: “Ko ka cidel amenđe o bar taro udar e grobosoro?” ");
INSERT INTO rmna_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ali kad resle, dikhle so o bar već inele cidime. A adava inele čače baro bar. ");
INSERT INTO rmna_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kad đerdinde ko grobo, dikhle jekhe terne manuše ano parne šeja sar bešela oti desno strana, i darandile. ");
INSERT INTO rmna_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","A ov phenđa lenđe: “Ma daran! Tumen rodena e Isuse e Nazarećanine, kova inele čhivdo ko krsto. Ov uštino taro mule hem nane akate. Ače o than kaj pašljarde lesoro telo. ");
INSERT INTO rmna_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nego, džan hem vaćeren lesere učenikonenđe hem e Petrese: ‘Ov džala angla tumende ki Galileja. Adari ka dikhen le, sar so angleder phenđa tumenđe.’ ” ");
INSERT INTO rmna_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","I o đuvlja iklile, i našle taro grobo, adalese so uklinđa len i dar hem lelje te tresinen. I nikase ništa na vaćerde, adalese so darandile. Ali na nakhlo but i on sa adava vaćerde e Petrese hem avere učenikonenđe. Palo adava korkoro o Isus bičhalđa len taro istok đi ko zapad te vaćeren o sveto hem o nepropadljivo lafi te šaj o manuša zauvek te oven spasime. Amen. ");
INSERT INTO rmna_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Rano sabale ko prvo dive oto kurko, kad o Isus uštino taro mule, najangle mothovđa pe e Marijaće e Magdalenaće, kolatar angleder ispudinđa ine efta demonen. ");
INSERT INTO rmna_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Oj dželi hem vaćerđa adava okolenđe kola inele oleja, a kola tugujinena ine hem rovena. ");
INSERT INTO rmna_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Kad on šunde dai o Isus dživdo hem so oj dikhlja le, na verujinde laće. ");
INSERT INTO rmna_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Palo adava o Isus, ko aver obličje, mothovđa pe anglo duj džene olendar sar džana ine ko jekh gav. ");
INSERT INTO rmna_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","On pendžarde e Isuse hem irinde pe te vaćeren adava averenđe, ali ni olenđe na verujinde. ");
INSERT INTO rmna_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Palo adava, o Isus mothovđa pe anglo dešujekh učenici sar hana ine maro zajedno. I ukorinđa len so na inolen vera hem soi lengere vile steđime, adalese so na verujinde okolenđe kola dikhle le palo lesoro uštiba taro mule. ");
INSERT INTO rmna_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","I phenđa lenđe: “Džan ko sa o sveto hem propovedinen o Šukar lafi sarijenđe. ");
INSERT INTO rmna_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ko poverujini hem krstini pe, ka ovel spasime, a ko na poverujini, ka ovel osudime. ");
INSERT INTO rmna_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","A akala znakija ka pratinen okolen kola verujinena: ano mlo anav ka ispudinen e demonen; ka vaćeren ano neve jezici; ");
INSERT INTO rmna_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","te dolinde sapen vastencar, hem te pile nešto otrovno, ništa naka ovel lenđe; ka čhiven pumare vasta upro namborme hem on ka sasljoven.” ");
INSERT INTO rmna_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kad phenđa lenđe adava, o Gospod Isus legardilo ko nebo, hem beštino ko počasno than, oti desno strana e Devlesiri. ");
INSERT INTO rmna_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","I o učenici džele ko sa o thana te propovedinen, a o Gospod pomožinđa lenđe hem potvrdini ine o Lafi znakonencar save pratinde le.");
INSERT INTO rmna_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Cenimeja Teofile, but džene lelje te pisinen oto događaja save ule maškar amende. ");
INSERT INTO rmna_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","On pisinde ađahar sar so vaćerde amenđe okola kola taro anglunipe dikhle adala događaja hem kola inele sluge zako e Devlesoro lafi. ");
INSERT INTO rmna_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ađahar hem me, palo adava so taro anglunipe šukar ispitujinđum sa adava, mangljum tuće sa palo redo te pisinav, ");
INSERT INTO rmna_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","te šaj ove uverime dai čače sa adava so injan sikavdo. ");
INSERT INTO rmna_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Kad o Irod inele caro ani Judeja, nesavo manuš palo anav Zaharija inele svešteniko e izraelconengoro, oto redo e Avijasoro. E Zaharijasiri romni da inele oto pleme e Aaronesoro. Lakoro anav inele Jelisaveta. ");
INSERT INTO rmna_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","O Zaharija hem i Jelisaveta inele pravedna anglo Devel, adalese so živinde palo sa o naredbe hem o zakonja e Gospodesere. ");
INSERT INTO rmna_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Olen na ine čhave adalese so i Jelisaveta našti ine te ačhol khamni, a soduj džene već purandile. ");
INSERT INTO rmna_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Jekh dive kad e Zaharijasiri grupa oto sveštenici kandlja ano Hram, tegani hem o Zaharija ćerela ine pli buti sar svešteniko anglo Devel. ");
INSERT INTO rmna_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ov, palo adeti e sveštenikonengoro, barbuteja inele izabirime te đerdini ko Hram e Gospodesoro hem te kadini. ");
INSERT INTO rmna_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Sar o Zaharija kadini ine ano Hram, sa edobor narodo molini pe ine avri. ");
INSERT INTO rmna_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","A ano Hram e Zaharijase mothovđa pe o anđeo e Gospodesoro, kova terdino ki desno strana oto žrtveniko kotar kadinđa pe. ");
INSERT INTO rmna_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Kad o Zaharija dikhlja le, uznemirinđa pe hem but darandilo. ");
INSERT INTO rmna_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","A o anđeo phenđa lese: “Ma dara, Zaharija! O Devel šunđa ti molitva. Ti romni i Jelisaveta ka bijani će čhave, i ka de le anav Jovan. ");
INSERT INTO rmna_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ka ove but radosno zbog leste hem but džene ka radujinen pe so ov ka bijanđol, ");
INSERT INTO rmna_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","adalese so ka ovel baro manuš anglo Gospod. Nikad naka pijel mol hem ništa sostar šaj te mačol pe. Ka ovel pherdo e Svetone Duhoja pana pe dajaće ano vođi. ");
INSERT INTO rmna_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Bute Izraelconen ka irini anglo Gospod, anglo lengoro Devel. ");
INSERT INTO rmna_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ka džal anglo Gospod sar glasniko ano duho hem ano zoralipe e prorokosoro e Ilijasoro. Ka mirini e daden lengere čhavencar hem okolen so na šunena ka irini nakori mudrost e pravednikonengiri. Ka pripremini e narodo te oven spremna zako e Gospodesoro aviba.” ");
INSERT INTO rmna_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","I o Zaharija pučlja e anđeo: “Sar me te džanav da čače ka ovel adava so phenđan? Me injum purano hem mli romni da beršali.” ");
INSERT INTO rmna_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","A o anđeo phenđa lese: “Me injum o Gavrilo, o anđeo kova terđola anglo Devel. Ov bičhalđa man te vaćerav tuja hem te anav će akava šukar lafi. ");
INSERT INTO rmna_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","I ače, ka ove laloro, naka šaj te vaćere sa đi o dive kad adava ka ovel, adalese so na verujinđan mle lafenđe save ka pherđoven ano pravo vreme.” ");
INSERT INTO rmna_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Sar o anđeo vaćeri ine e Zaharijaja, o narodo kova adžićerđa avri čudinđa pe so o Zaharija edobor ačhilo ano Hram. ");
INSERT INTO rmna_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","A kad o Zaharija iklilo, našti ine te vaćeri olencar. Ćerela ine nesar te mothoj lenđe vastencar, ali ačhilo laloro. O manuša halile da ole ine vizija ano Hram. ");
INSERT INTO rmna_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Kad pherdile o dive oti lesiri služba ano Hram, o Zaharija irinđa pe čhere. ");
INSERT INTO rmna_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Na nakhlo but, i lesiri romni i Jelisaveta ačhili khamni hem pandž masek na iklili avri taro čher. Phenđa: ");
INSERT INTO rmna_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“O Gospod ćerđa te šaj ačhovav khamni. Akana mothovđa maje pli milost hem cidinđa mli lađ anglo manuša.” ");
INSERT INTO rmna_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Kad i Jelisaveta inele šofto masek khamni, o Devel bičhalđa ple anđeo e Gavrilo ki diz Nazaret ani regija Galileja. ");
INSERT INTO rmna_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Adari valjanđa te legari o lafi e Marijaće koja pana inele čhaj. Oj inele mangli e muršese palo anav Josif, kova inele oto pleme e carosoro e Davidesoro. ");
INSERT INTO rmna_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Kad alo o anđeo, phenđa e Marijaće: “Radujin tut! O Gospodi tuja! Ovi but milostivno premala tute!” ");
INSERT INTO rmna_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","A i Marija but uznemirinđa pe zbog e anđeosere lafija, i pučlja pe so šaj te značini adava pozdrav. ");
INSERT INTO rmna_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","A o anđeo phenđa laće: “Ma dara, Marije! O Devel mothovđa će pli milost! ");
INSERT INTO rmna_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ače, ka ačhove khamni hem ka bijane čhave, i ka de le anav Isus. ");
INSERT INTO rmna_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ov ka ovel baro hem ka vičini pe Čhavo e Najbare Devlesoro. O Devel o Gospod ka del le o presto lesere pradadesoro e Davidesoro. ");
INSERT INTO rmna_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ka carujini upro pleme e Jakovesoro zauvek; zako lesoro carstvo naka ovel kraj.” ");
INSERT INTO rmna_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tegani i Marija pučlja e anđeo: “Sar šaj te ovel adava kad me pana injum čhaj?” ");
INSERT INTO rmna_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","A o anđeo phenđa laće: “O Sveto Duho ka huljel upra tute hem o zoralipe e Najbare Devlesoro ka učhari tut. Adalese adava čhavo, kole ka bijane, ka ovel sveto hem ka vičini pe Čhavo e Devlesoro. ");
INSERT INTO rmna_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Eče, ti bibi i Jelisaveta da, ko purane berša, ačhili khamni hem ka bijani murše. I oj, kolaće sare džande da našti te ačhol khamni, akanai šov masek khamni. ");
INSERT INTO rmna_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Adalese so o Devel sa šaj te ćerel!” ");
INSERT INTO rmna_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Tegani i Marija phenđa: “Ače, sluškinja e Gospodesiri injum. Nek ovel maje palo to lafi.” I o anđeo dželo olatar. ");
INSERT INTO rmna_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Adala dive i Marija spreminđa pe hem siđarđa ko bregalo krajo, ki jekh diz ani regija Judeja. ");
INSERT INTO rmna_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Kad resli adari, đerdinđa ko čher e Zaharijasoro hem pozdravinđa e Jelisaveta. ");
INSERT INTO rmna_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","I kad i Jelisaveta šunđa e Marijakoro pozdrav, o čhavoro oti radost zorale mrdinđa olaće ano vođi, a oj pherdili e Svetone Duhoja. ");
INSERT INTO rmna_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","I bare glasoja phenđa e Marijaće: “Najblagoslovime injan maškaro đuvlja hem blagoslovime o čhavoro kole akhareja ano vođi! ");
INSERT INTO rmna_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Akavai bari čast maje so tu, mle Gospodesiri daj, aljan kora mande. ");
INSERT INTO rmna_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Adalese so, kad šunđum to pozdrav, o čhavoro oti radost zorale mrdinđa maje ano vođi. ");
INSERT INTO rmna_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Blago tuće so verujinđan da ka ovel adava so phenđa će o Gospod!” ");
INSERT INTO rmna_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Tegani i Marija phenđa: “Mli duša barjari e Gospode; ");
INSERT INTO rmna_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Mloi duho radosno ano Devel, ano mlo Spasitelj, ");
INSERT INTO rmna_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","so ulo milostivno upri poniznost ple sluškinjakiri. I ače, od akana sa o generacije ka phenen da injum blagoslovime đuvli, ");
INSERT INTO rmna_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","adalese so bare šukaripa ćerđa maje o Zoralo Devel kasoroi anav sveto! ");
INSERT INTO rmna_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ovi milostivno e manušenđe tari generacija ki generacija kola darana olestar. ");
INSERT INTO rmna_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ple zorale vasteja ćerđa bare buća; rasfrdinđa e manušen kolai barikane ano pumare vile. ");
INSERT INTO rmna_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Peravđa e vladaren taro lengoro prestolje, a vazdinđa e poniznonen. ");
INSERT INTO rmna_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Čaljarđa e bokhalen šukaripnaja, a čučen muklja e barvalen. ");
INSERT INTO rmna_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Pomožinđa e Izraelconenđe, ple slugenđe. Na bisterđa te ovel milostivno ");
INSERT INTO rmna_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","e Avraamese hem lesere potomkonenđe zauvek, sar so dinđa plo lafi amare pradadenđe.” ");
INSERT INTO rmna_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","I Marija ačhili e Jelisavetaja đi sar trin masek, i tegani irinđa pe čhere. ");
INSERT INTO rmna_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","A kad alo o vreme i Jelisaveta te bijani, bijanđa murše. ");
INSERT INTO rmna_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Kad lakiri familija hem lakere komšije šunde so o Gospod mothovđa laće bari milost, radujinde pe olaja. ");
INSERT INTO rmna_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","A kad e čhavore inele ofto dive, koro Zaharija čedinde pe o manuša zako obreziba e čhavoresoro. I mangle te den le lesere dadesoro anav – Zaharija, ");
INSERT INTO rmna_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ali i Jelisaveta phenđa: “Na! Lesoro anav ka ovel Jovan!” ");
INSERT INTO rmna_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","A on phende laće: “Niko te familijatar na vičini pe ađahar.” ");
INSERT INTO rmna_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","I vastencar pučle e Zaharija savo anav mangela te del ple čhavore. ");
INSERT INTO rmna_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tegani o Zaharija rodinđa te den le jekh tikori phal zako pisiba hem pisinđa: “Lesoro anavi Jovan.” I sare začudinde pe. ");
INSERT INTO rmna_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","I otojekhvar e Zaharijasoro muj phravdilo hem šaj ine palem te vaćeri, i lelja te slavini e Devle. ");
INSERT INTO rmna_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","I uklinđa i dar sa lengere komšijen. Ko sa o bregalo krajo e Judejakoro vaćerđa pe adalestar so ulo. ");
INSERT INTO rmna_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","I sare kola šunde adava, razmislinde adalestar hem phende: “Akava čhavoro isi te ovel baro manuš. Čačei upro leste o vas e Gospodesoro.” ");
INSERT INTO rmna_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","A o Zaharija, e Jovanesoro dad, pherdilo e Svetone Duhoja hem prorokujinđa: ");
INSERT INTO rmna_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Slava e Gospodese e Izraelesere Devlese, adalese so alo hem otkupinđa ple narodo! ");
INSERT INTO rmna_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Vazdinđa amenđe e zorale Spasitelje oto pleme e carosoro e Davidesoro, ple slugasoro, ");
INSERT INTO rmna_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","sar so vaćerđa pana angleder prekalo muja ple svetone prorokonengere. ");
INSERT INTO rmna_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Vazdinđa amenđe zorale Spasitelje te spasini amen amare neprijateljendar hem sa e manušengere vastendar kola mrzinena amen. ");
INSERT INTO rmna_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Mothovđa milost amare pradadenđe hem ispuninđa plo sveto savez, ");
INSERT INTO rmna_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","i sovli savi halja e Avraamese amare pradadese: ");
INSERT INTO rmna_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","so ka ikali amen amare neprijateljengere vastendar te šaj služina lese bizi dar ");
INSERT INTO rmna_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ani svetost hem ani pravednost anglo leste sa đikote injam dživde. ");
INSERT INTO rmna_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","A tu Jovane, mlo čhavo, ka ove pendžardo sar proroko e Najbare Devlesoro, adalese so ka dža anglo Gospod te pripremine lese o drom. ");
INSERT INTO rmna_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ka sikave lesere narodo sar te pendžaren o spasenje prekalo oprostiba lengere grehija ");
INSERT INTO rmna_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","zbog amare Devlesoro milosrdno vilo palo savo o svetlost odupral ka avel kora amende sar ikljojba e khamesoro, ");
INSERT INTO rmna_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","te svetlini okolenđe so bešena ani tomina hem ani senka e meribnasiri, te legari amen ko drom oto mir.” ");
INSERT INTO rmna_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","A o čhavoro o Jovan barjola ine hem zoraljola ano duho. Kad barilo, živinđa ani pustinja sa đikote na iklilo anglo Izraelci te propovedini. ");
INSERT INTO rmna_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","A ano adava vreme kad o Jovan bijandilo, e rimesoro caro o Avgust naredinđa te ćerel pe popis oto sa o manuša ano carstvo. ");
INSERT INTO rmna_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Adava inele prvo popis ćerdo sar o Kvirinije vladini ine ani Sirija. ");
INSERT INTO rmna_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","I sa o manuša džele ko dizja kaj bešle ine lengere preci te prijavinen pe zako popis. ");
INSERT INTO rmna_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ađahar da o Josif, adalese so inele potomko e carosoro e Davidesoro, dželo tari diz Nazaret oti regija Galileja ko gav Vitlejem oti regija Judeja, kote o David bijandilo. ");
INSERT INTO rmna_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Dželo adari sar te prijavini pe zako popis pe verenicaja e Marijaja koja inele khamni. ");
INSERT INTO rmna_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","I sar on inele ano Vitlejem, alo e Marijakoro vreme te bijani. ");
INSERT INTO rmna_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","I bijanđa ple prvone čhave. Paćarđa le hem pašljarđa le ano jasle adalese so ki gostionica na inele than olenđe. ");
INSERT INTO rmna_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Adaja rat paše uzalo Vitlejem inele nesave pastirija kola arakhena ine pumare bakren ko polje. ");
INSERT INTO rmna_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","I otojekhvar o anđeo e Gospodesoro terdino uzalo lende hem i slava e Gospodesiri osvetlinđa len, i on but darandile. ");
INSERT INTO rmna_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","A o anđeo phenđa lenđe: “Ma daran! Ače, anava tumenđe šukar lafi oto baro bahtalipe savo ka ovel sa e manušenđe! ");
INSERT INTO rmna_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Avdive, ani e Davidesiri diz bijandilo tumenđe o Spasitelj kovai o Hrist o Gospod. ");
INSERT INTO rmna_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","A palo akava znako ka pendžaren le: ka arakhen e čhavore paćarde hem sar pašljola ano jasle.” ");
INSERT INTO rmna_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Otojekhvar uzalo anđeo mothovđa pe bari vojska e anđelendar savi hvalinđa e Devle vaćerindoj: ");
INSERT INTO rmna_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Slava ko učipe e Devlese, a ki phuv mir e manušenđe kolencar o Devel zadovoljno!” ");
INSERT INTO rmna_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","I kad o anđelja irinde pe ko nebo, o pastirija phende jekh averese: “Hajde te dža đi o Vitlejem hem te dikha adava so phenđa amenđe o Gospod.” ");
INSERT INTO rmna_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","I džele sigate, hem arakhle e Marija, e Josife hem e čhavore sar pašljola ano jasle. ");
INSERT INTO rmna_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","A kad dikhle e čhavore, vaćerde averenđe sa so ine lenđe phendo e čhavorestar. ");
INSERT INTO rmna_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","I inele zadivime sare kola šunde adava so o pastirija vaćerde. ");
INSERT INTO rmna_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","A i Marija sa adava garavđa pese ano vilo hem razmislinđa adalestar. ");
INSERT INTO rmna_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","I o pastirija dželefse slavindoj hem hvalindoj e Devle zako sa okova so šunde hem so dikhle baš ađahar sar so ine lenđe phendo. ");
INSERT INTO rmna_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Kad nakhle ofto dive, kad e čhavore valjande te obrezinen, dinde le anav Isus – sar so vičinđa le o anđeo angleder so i Marija ačhili khamni. ");
INSERT INTO rmna_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Kad alo o vreme zako adeti i daj te očistini pe palo e Mojsijasoro zakoni, o Josif hem i Marija ande e Isuse ano Hram ko Jerusalim te preden le e Gospodese ");
INSERT INTO rmna_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(sar soi pisime ano zakoni e Gospodesoro: “Svako murš prvenco te ovel posvetime e Gospodese”) ");
INSERT INTO rmna_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","hem te den žrtva (sar soi phendo ano zakoni e Gospodesoro: “duj tikore golubija ili duj terne golubija”). ");
INSERT INTO rmna_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","A ano Jerusalim inele jekh manuš palo anav Simeon. Ov inele pravedno hem pobožno. Adžićeri ine te avel o Mesija te spasini e Izraelconen, hem o Sveto Duho inele upro leste. ");
INSERT INTO rmna_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","O Sveto Duho mothovđa lese da angleder so ka merel, ka dikhel e Gospodesere Mesija. ");
INSERT INTO rmna_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","I o Sveto Duho phenđa lese te džal ko Hram, i ov dželo. Tegani o Josif hem i Marija ande e čhavore e Isuse ano Hram sar te ćeren o adeti savoi palo Zakoni. ");
INSERT INTO rmna_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Kad o Simeon dikhlja e čhavore e Isuse, lelja le ki angali hem hvalinđa e Devle vaćerindoj: ");
INSERT INTO rmna_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Gospode, akana šaj me, o sluga klo, te merav ano mir sar so phenđan maje. ");
INSERT INTO rmna_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Adalese so mle jaćha dikhle to spasenje, ");
INSERT INTO rmna_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","savo spreminđan anglo sa o nacije. ");
INSERT INTO rmna_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Akava spasenje ka ovel svetlost te mothoj tut avere nacijenđe hem ka anel slava te narodose, e Izraelconenđe.” ");
INSERT INTO rmna_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","E Isusesoro dad hem i daj divinde pe adaleja so o Simeon vaćerđa olestar. ");
INSERT INTO rmna_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Tegani o Simeon blagoslovinđa len hem phenđa e Marijaće, e Isusesere dajaće: “Dikh, akavai čhavoro birime te ćerel buten te peren hem te ušten ano Izrael. Ovi odredime te ovel e Devlesoro znako, ali but džene ka odbacinen le. ");
INSERT INTO rmna_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Adava ka ovel sar te mothoven pe bute manušengere garavde mislija. A o mači ka posaj ti duša.” ");
INSERT INTO rmna_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","A adari da inele i proročica i Ana, i čhaj e Fanuilesiri, oto pleme e Asiresoro. Oj inele ano purane berša. Efta berš živinđa ple romeja, ");
INSERT INTO rmna_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","a palo adava živinđa sar udovica đi oftovardešu štarto berš. Stalno inele ano Hram, i dive i rat slavinđa e Devle ano postiba hem ano moliba. ");
INSERT INTO rmna_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","I samo so o Simeon završinđa ple vaćeribnaja, i Ana nakhini đi o Josif hem i Marija zahvalindoj e Devlese zako čhavoro. I lelja te vaćeri e čhavorestar sarijenđe adari kola adžićerde upro Devel te otkupini o Jerusalim. ");
INSERT INTO rmna_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Kad o Josif hem i Marija ćerde sa soi palo zakoni e Gospodesoro, irinde pe ki pumari diz Nazaret ki Galileja. ");
INSERT INTO rmna_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","A o čhavoro barjola ine hem zoraljola. Pherđola ine mudrost hem i milost e Devlesiri inele upro leste. ");
INSERT INTO rmna_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","E Isusesoro dad hem i daj svako berš zako prazniko Pasha džana ine ki diz Jerusalim. ");
INSERT INTO rmna_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kad e Isuse inele dešu duj berš, palo adeti, hem ov dželo olencar adari te slavini o prazniko. ");
INSERT INTO rmna_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Kad nakhlo o prazniko, o Josif hem i Marija lelje te džanfse, a na džande so lengoro čhavo o Isus ačhilo ano Jerusalim. ");
INSERT INTO rmna_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Sar mislinde dai o Isus maškaro manuša kola putujinde olencar, džele jekh dive phirindoj, a onda lelje te roden le maškaro pumarende hem maškaro pendžarutne. ");
INSERT INTO rmna_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","I kad našti ine te arakhen le, irinde pe ko Jerusalim te roden le. ");
INSERT INTO rmna_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","I o trito dive arakhle le ano Hram sar bešela maškaro e verakere učitelja, sar šunela len hem pučela len. ");
INSERT INTO rmna_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","I sare kola šunde e Isuse, divinde pe zako lesoro džandipe hem zako lesere odgovorija. ");
INSERT INTO rmna_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","I kad dikhlja le lesoro dad hem lesiri daj, inele iznenadime. Lesiri daj phenđa lese: “Mlo čhavo, vaćer sose adava ćerđan amenđe? To dad hem me but darandiljam hem rodinđam tut!” ");
INSERT INTO rmna_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","A o Isus pučlja len: “Sose rodinđen man? Na džanđen li so valjani te ovav ano čher mle Dadesoro?” ");
INSERT INTO rmna_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","A i Marija hem o Josif na halile so o Isus manglja te phenel lenđe adaleja. ");
INSERT INTO rmna_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","I palo adava, o Isus irinđa pe olencar ko Nazaret hem ine lenđe poslušno. A lesiri daj garavđa pese ano vilo sa adava so ulo. ");
INSERT INTO rmna_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","A o Isus ulo po mudro hem barjola ine ano telo, hem sa više barjola ine ano jaćha e Devlese hem e manušenđe. ");
INSERT INTO rmna_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Kad o caro o Tiberija vladinđa upro e Rimesoro carstvo dešupandžto berš, o Pontije Pilat vladinđa ani Judeja, o Irod vladinđa ani Galileja, a lesoro phral o Filip vladinđa ani Itureja hem ani Trahonitada, o Lisanije vladinđa ani Avilina, ");
INSERT INTO rmna_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","hem o Ana hem o Kajafa inele šerutne sveštenici, o lafi e Devlesoro alo e Zaharijasere čhavese e Jovanese ki pustinja. ");
INSERT INTO rmna_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","I o Jovan dželo ko sa o krajo e lenjakoro Jordan te propovedini e manušenđe da valjani te pokajinen pe zako pumare grehija hem te oven krstime sar te mothoven dai lenđe oprostime o grehija. ");
INSERT INTO rmna_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Sar so angleder pisinđa o proroko o Isaija, o Jovan inele “o glaso so vičini ani pustinja: ‘Pripreminen o drom e Gospodese, ravnonen lese o droma! ");
INSERT INTO rmna_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Svako dolina te pherđol a svako planina hem brego te peren! O bange droma te oven ispravime a o neravna droma te oven ravnome! ");
INSERT INTO rmna_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","I sa o manuša ka dikhen e Devlesoro spasenje.’” ");
INSERT INTO rmna_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Akava o Jovan vaćerđa butenđe kola iklile te krstini len: “E sapengere čhavalen! Ko vaćerđa tumenđe da šaj te našen oti e Devlesiri holi savi avela? ");
INSERT INTO rmna_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Tumare životeja mothoven da čače pokajinđen tumen! I ma mislinen dai dovoljno te phenen: ‘Amaroi pradad o Avraam.’ Phenava tumenđe da o Devel hem akale barendar šaj te vazdel čhaven e Avraamese. ");
INSERT INTO rmna_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ače o tover oto sudo e Devlesoroi već vazdime te čhinel o kašta ano koreno. I svako kaš savo na bijani šukar bijandipe ka čhinel pe hem ka frdel pe ani jag.” ");
INSERT INTO rmna_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","A o narodo pučlja le: “So valjani te ćera?” ");
INSERT INTO rmna_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","O Jovan phenđa lenđe: “Kas isi duj gada, jekh valjani te del okolese kas nane. A kas isi hajbnase, te ćerel isto ađahar.” ");
INSERT INTO rmna_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Nesave carinici da ale te krstini len o Jovan, i pučle le: “Učitelju, so amen te ćera?” ");
INSERT INTO rmna_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","A ov phenđa lenđe: “Ma roden buderi porez okolestar so o zakoni phenela tumenđe te roden.” ");
INSERT INTO rmna_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","I nesave vojnici da pučle e Jovane: “A so amen te ćera?” A ov phenđa lenđe: “Nikastar ma len pare ki sila ili so ka tužinen len hovavne hem oven zadovoljna tumara plataja.” ");
INSERT INTO rmna_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","A o narodo adžićerđa e Mesija hem sare pučle pe nane li o Jovan adava. ");
INSERT INTO rmna_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Adalese o Jovan phenđa sarijenđe: “Me krstinava tumen panjeja, ali avela o po baro mandar, kase na injum dostojno ni o dorikha oti obuća te phravav. Ov ka krstini tumen e Svetone Duhoja hem jagaja. ");
INSERT INTO rmna_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ano vas lese i lopata te čistini o gumno plo hem te odvojini o điv taro ljuske. O điv ka čhivel pese ki šupa, a o ljuske ka tharel jagaja savi nikad na mudarđola.” ");
INSERT INTO rmna_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ađahar, sar hem bute avere lafencar o Jovan vaćerđa lenđe o Šukar lafi. ");
INSERT INTO rmna_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","A e vladare e Irode o Jovan ukorinđa adalese so lelja romnjaće ple phralesere romnja e Irodijada hem zako but avera bišukar buća save ćerđa. ");
INSERT INTO rmna_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Tegani o Irod ćerđa aver bišukaripe: čhivđa e Jovane ko phandlipe. ");
INSERT INTO rmna_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Kad sa o manuša krstinde pe, krstinđa pe hem o Isus. I tegani sar o Isus molini pe ine, phravdilo o nebo, ");
INSERT INTO rmna_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","a o Sveto Duho huljilo upro leste ano oblik e golubesoro. A taro nebo šundilo o glaso e Devlesoro: “Tu injan mlo Čhavo o volime! Tuja injum bahtalo!” ");
INSERT INTO rmna_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","O Isus počinđa pli služba anglo narodo kad inole đi ko trijanda berš. O narodo smatrinđa dai o Isus čhavo e Josifesoro. O Josif inele čhavo e Ilijasoro. ");
INSERT INTO rmna_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","O Ilija inele čhavo e Matatesoro. O Matat inele čhavo e Levijesoro. O Levije inele čhavo e Melhisoro. O Melhi inele čhavo e Janajesoro. O Janaj inele čhavo e Josifesoro. ");
INSERT INTO rmna_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","O Josif inele čhavo e Matatijesoro. O Matatije inele čhavo e Amosesoro. O Amos inele čhavo e Naumesoro. O Naum inele čhavo e Eslijasoro. O Eslija inele čhavo e Nangejesoro. ");
INSERT INTO rmna_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","O Nangej inele čhavo e Maatesoro. O Maat inele čhavo e Matatijesoro. O Matatije inele čhavo e Semeinesoro. O Semein inele čhavo e Josihesoro. O Josih inele čhavo e Jodasoro. ");
INSERT INTO rmna_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","O Joda inele čhavo e Joananesoro. O Joanan inele čhavo e Risasoro. O Risa inele čhavo e Zorovavelesoro. O Zorovavel inele čhavo e Salatiilesoro. O Salatiil inele čhavo e Nirisoro. ");
INSERT INTO rmna_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","O Niri inele čhavo e Melhisoro. O Melhi inele čhavo e Adisoro. O Adi inele čhavo e Kosamesoro. O Kosam inele čhavo e Elmadamesoro. O Elmadam inele čhavo e Iresoro. ");
INSERT INTO rmna_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","O Ir inele čhavo e Isusesoro. O Isus inele čhavo e Eliezeresoro. O Eliezer inele čhavo e Jorimesoro. O Jorim inele čhavo e Matatesoro. O Matat inele čhavo e Levijesoro. ");
INSERT INTO rmna_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","O Levije inele čhavo e Simeonesoro. O Simeon inele čhavo e Judasoro. O Juda inele čhavo e Josifesoro. O Josif inele čhavo e Jonamesoro. O Jonam inele čhavo e Eliakimesoro. ");
INSERT INTO rmna_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","O Eliakim inele čhavo e Melejasoro. O Meleja inele čhavo e Menasoro. O Mena inele čhavo e Matatasoro. O Matata inele čhavo e Natanesoro. O Natan inele čhavo e Davidesoro. ");
INSERT INTO rmna_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","O David inele čhavo e Jesejesoro. O Jesej inele čhavo e Jovidesoro. O Jovid inele čhavo e Voozesoro. O Vooz inele čhavo e Salmonesoro. O Salmon inele čhavo e Naasonesoro. ");
INSERT INTO rmna_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","O Naason inele čhavo e Aminadavesoro. O Aminadav inele čhavo e Adminesoro. O Admin inele čhavo e Arnisoro. O Arni inele čhavo e Esromesoro. O Esrom inele čhavo e Faresesoro. O Fares inele čhavo e Judasoro. ");
INSERT INTO rmna_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","O Juda inele čhavo e Jakovesoro. O Jakov inele čhavo i Isaakesoro. O Isaak inele čhavo e Avraamesoro. O Avraam inele čhavo e Tarasoro. O Tara inele čhavo e Nahoresoro. ");
INSERT INTO rmna_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","O Nahor inele čhavo e Seruhesoro. O Seruh inele čhavo e Ragavesoro. O Ragav inele čhavo e Falekesoro. O Falek inele čhavo e Everesoro. O Ever inele čhavo e Salasoro. ");
INSERT INTO rmna_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","O Sala inele čhavo e Kainamesoro. O Kainam inele čhavo e Arfaksadesoro. O Arfaksad inele čhavo e Simesoro. O Sim inele čhavo e Nojesoro. O Noje inele čhavo e Lamehesoro. ");
INSERT INTO rmna_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","O Lameh inele čhavo e Matusalasoro. O Matusala inele čhavo e Enohesoro. O Enoh inele čhavo e Jaretesoro. O Jaret inele čhavo e Malaleilesoro. O Malaleil inele čhavo e Kainamesoro. ");
INSERT INTO rmna_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","O Kainam inele čhavo e Enosesoro. O Enos inele čhavo e Sitesoro. O Sit inele čhavo e Adamesoro. O Adam inele čhavo e Devlesoro. ");
INSERT INTO rmna_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","A o Isus, pherdo e Svetone Duhoja, irinđa pe tari len Jordan; i oto Duho inele legardo ki pustinja, ");
INSERT INTO rmna_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","kaj inele saranda dive iskušime e bengestar. I na halja ništa adala dive, a kad nakhle adala dive, tegani bokhalilo. ");
INSERT INTO rmna_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","I o beng phenđa lese: “Te injan o Čhavo e Devlesoro, vaćer akale barese te ovel maro.” ");
INSERT INTO rmna_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","A o Isus phenđa lese: “Pisimei ano Sveto lil: ‘O manuš naka živini samo oto maro.’” ");
INSERT INTO rmna_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","I o beng legarđa le ko učo than hem otojekhvar mothovđa lese sa o carstvija e phuvjakere, ");
INSERT INTO rmna_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","i phenđa lese: “Tuće ka dav sa akava zoralipe hem i slava olengiri adalese soi maje dindi, i dava la kase me mangava. ");
INSERT INTO rmna_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Adalese, te peljan ko kočija angla mande, sa ka ovel klo.” ");
INSERT INTO rmna_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","I o Isus phenđa lese: “Pisimei ano Sveto lil: ‘Per ko kočija samo anglo Gospod, to Devel, hem samo ole kande!’” ");
INSERT INTO rmna_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","I o beng anđa le ko Jerusalim hem čhivđa le upro naj učo than e Hramesoro hem phenđa lese: “Te injan o Čhavo e Devlesoro, frde tut akatar tele! ");
INSERT INTO rmna_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Adalese soi pisime: ‘Ka naredini ple anđelenđe te arakhen tut, ");
INSERT INTO rmna_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","te akharen tut ko vasta te na khuve tut preja ko bar.’” ");
INSERT INTO rmna_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","O Isus phenđa lese: “Hem akavai phendo ano Sveto lil: ‘Ma kušin e Gospode, te Devle.’” ");
INSERT INTO rmna_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","I kad završinđa svako kušnja, o beng cidinđa pe olestar đi nesavi aver prilika. ");
INSERT INTO rmna_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","I o Isus irinđa pe ki regija Galileja ano zoralipe e Duhosoro, i šundilo o glaso olestar ko sa o krajo. ");
INSERT INTO rmna_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","I sikavđa e manušen olenđe ano sinagoge hem inele pohvalime sarijendar. ");
INSERT INTO rmna_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","I o Isus alo ki diz Nazaret kote barilo hem, palo plo adeti ko savato, đerdinđa ki sinagoga. Uštino te čitini, ");
INSERT INTO rmna_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","a ine lese dindo o lil e prorokosoro e Isaijasoro. Ov phravđa o lil hem arakhlja o than kaj inele pisime: ");
INSERT INTO rmna_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“O Duhoi e Gospodesoro upra mande, adalese so pomazinđa man te vaćerav o šukar lafi e čororenđe. Bičhalđa man te proglasinav e phandlenđe da ka oven oslobodime, e kororenđe da ka irini pe lenđe o dikhiba, e mučimenđe da ka oven slobodna, ");
INSERT INTO rmna_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","te proglasinav o adžićerdo berš oti e Gospodesiri milost.” ");
INSERT INTO rmna_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Tegani phandlja o lil, irinđa le e slugaste, i beštino te sikaj. I sare ani sinagoga dikhle ano leste. ");
INSERT INTO rmna_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","A o Isus lelja te vaćeri lenđe: “Avdive pherdile akala lafija save šunđen tumare kanencar.” ");
INSERT INTO rmna_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","I sare šukar vaćerde olestar hem inele zadivime oto šukar lafija save iklile lesere mujestar, i vaćerde: “Nane li ov e Josifesoro čhavo?” ");
INSERT INTO rmna_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","A ov phenđa lenđe: “Čače ka vaćeren maje akaja poslovica: ‘Doktore, sasljar korkore tut!’ So šunđam so ulo ano Kafarnaum, ćer hem akate, ano to than kaj bariljan.” ");
INSERT INTO rmna_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","I phenđa: “Čače, vaćerava tumenđe, nijekh proroko nane prihvatime ano plo than kaj barilo. ");
INSERT INTO rmna_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","I čače, vaćerava tumenđe, inele but udovice ano Izrael e Ilijase ano vreme, kad na pelo bršim trin berš hem šov masek i ulo baro bokhalipe ki sa i phuv. ");
INSERT INTO rmna_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","I nijekhaće olendar na inele bičhaldo o Ilija sem e udovicaće ki e abanđijengiri diz Sarepta uzalo Sidon. ");
INSERT INTO rmna_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","I inele but gubavci ano Izrael ano vreme e prorokosoro e Jelisejesoro, i nijekh olendar na inele sasljardo, sem o Neman o Sirijco.” ");
INSERT INTO rmna_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","I sare ani sinagoga pherdile holi kad šunde adava. ");
INSERT INTO rmna_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","I uštine hem ispudinde le tari diz, i legarde le upre ko brego upro savo lengiri diz inele vazdime te šaj frden le odupral. ");
INSERT INTO rmna_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ali o Isus nakhino maškar olende hem dželo. ");
INSERT INTO rmna_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","I o Isus huljilo ani e galilejakiri diz Kafarnaum, i sikavđa e manušen ko savato. ");
INSERT INTO rmna_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","I on inele zadivime lesere sikavibnaja adalese so lesoro vaćeriba inele ano autoritet. ");
INSERT INTO rmna_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","A adari, ani sinagoga, inele manuš opsednutime e demonesere bišukare duhoja hem oto sa o glaso vičinđa: ");
INSERT INTO rmna_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Oh, so mangeja amendar, Isuse Nazarećanine? Aljan li te uništine amen? Džanav ko tu injan: o Sveco e Devlesoro.” ");
INSERT INTO rmna_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Tegani o Isus ukorinđa le: “Phand to muj hem ikljov olestar!” I o demoni frdinđa le ki phuv anglo sarijende, iklilo olestar hem ni hari na dukhavđa le. ");
INSERT INTO rmna_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","I sare but začudinde pe hem vaćerde jekh avereja ađahar: “Savo li vaćeriba adava da ano autoritet hem ano zoralipe naredini e bišukare duhenđe te ikljon hem on ikljona?” ");
INSERT INTO rmna_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","I o glaso e Isusestar šundilo ko sa o pašutne thana. ");
INSERT INTO rmna_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","O Isus iklilo tari sinagoga hem dželo ko čher e Simonesoro. E Simonesere sasuja inele bari jag. I on zamolinde le te sasljari la. ");
INSERT INTO rmna_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","I o Isus terdino uzalo late, naredinđa e jagaće hem oj muklja la. I odmah uštini hem lelja te poslužini len. ");
INSERT INTO rmna_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kad o kham huljilo, sarijen kolen inele namborme manuša oto razna nambormipa, ande len koro Isus. A ov upra svakoneste olendar čhivđa ple vasta hem sasljarđa len. ");
INSERT INTO rmna_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","A butendar da iklile o demonja vičindoj hem vaćerindoj: “Tu injan o Čhavo e Devlesoro!” O Isus pretinđa len hem na muklja lenđe te vaćeren adalese so džande dai ov o Hrist. ");
INSERT INTO rmna_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kad dislilo, o Isus iklilo tari diz hem dželo ko jekh čučo than. I but džene rodinde le. Ale đi leste hem na mukena le ine te džalfse olendar. ");
INSERT INTO rmna_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","A ov phenđa lenđe: “I ko avera dizja valjani te vaćerav o šukar lafi oto carstvo e Devlesoro adalese so zako adava injum bičhaldo.” ");
INSERT INTO rmna_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","I o Isus nastavinđa te propovedini ano e judejakere sinagoge. ");
INSERT INTO rmna_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","A jekhvar but džene gurinde pe uzalo Isus te šunen o lafi e Devlesoro, a ov terdino uzalo e Galilejakoro jezero. ");
INSERT INTO rmna_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","I dikhlja duj čamcija uzalo jezero savendar iklile o manuša kola dolena maćhen adalese so thovena ine pumare mreže. ");
INSERT INTO rmna_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","I đerdinđa ano jekh čamco, kova inele e Simonesoro, i zamolinđa le te cidel pe hari e phuvjatar, i bešindoj ano čamco, sikavđa e narodo. ");
INSERT INTO rmna_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","A kad završinđa o vaćeriba, phenđa e Simonese: “Dža e čamcoja ko hor hem frden tumare mreže te šaj dolen maćhen.” ");
INSERT INTO rmna_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","A o Simon phenđa: “Gospodarona, sa i rat trudinđam amen i ništa na dolinđam, ali te tu pheneja, ka frdav o mreže.” ");
INSERT INTO rmna_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","I kad ćerde adava, dolinde sa edobor maćhen i lengere mreže lelje te pharavđon. ");
INSERT INTO rmna_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","I vastencar mothovde pumare amalenđe, kola inele ko aver čamco, te aven te pomožinen lenđe. I on ale hem pherde soduj čamcija edobor da lelje te pherđon pani. ");
INSERT INTO rmna_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","A kad dikhlja adava o Simon o Petar, pelo ko kočija anglo Isus vaćerindoj: “Dža mandar, Gospode, me injum grešno manuš!” ");
INSERT INTO rmna_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Adalese so i dar prelelja ole hem sarijen kola inele oleja zbog o baro doliba e maćhengoro. ");
INSERT INTO rmna_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ađahar da i dar dolinđa e Jakove hem e Jovane, e Zevedejesere čhaven, kola inele e Simonesere amala. I o Isus phenđa e Simonese: “Ma dara! Od akana manušen ka dole.” ");
INSERT INTO rmna_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","I kad ikalde o čamcija upri phuv, ačhavde sa hem džele palo leste. ");
INSERT INTO rmna_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","I jekhvar o Isus inele ki nesavi diz, i nekotar anglo leste iklilo manuš pherdo gubaja. So dikhlja e Isuse, pelo anglo leste mujeja đi phuv hem molinđa le vaćerindoj: “Gospode, te mangeja, šaj te sasljare man!” ");
INSERT INTO rmna_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","I o Isus pružinđa plo vas, dolinđa le hem phenđa: “Mangava, ov sasljardo!” I otojekhvar i guba cidinđa pe olestar. ");
INSERT INTO rmna_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Tegani naredinđa lese: “Ma vaćer nikase akalestar, nego dža mothov tut e sveštenikose hem de žrtva zako to očistiba, sar so naredinđa o Mojsije, zako svedočanstvo olenđe.” ");
INSERT INTO rmna_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","A o glaso e Isusestar šunđola ine sa po dur, i but džene čedena pe ine te šunen le hem te oven sasljarde oto pumare nambormipa. ");
INSERT INTO rmna_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","A ov cidela pe ine ko čuče thana hem molini pe. ");
INSERT INTO rmna_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","I jekh dive o Isus sikavđa ano jekh čher, a o fariseja hem o učitelja e Zakonestar, kola ale oto sa e galilejakere hem judejakere gava hem oto Jerusalim, beštine adathe. A o zoralipe e Gospodesoro inele upro Isus te sasljari. ");
INSERT INTO rmna_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","I nesave manuša ande upri nosiljka jekhe manuše kova našti ine te phirel ni te mrdini. Mangle te anen le andre hem te čhiven le anglo Isus. ");
INSERT INTO rmna_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","I adalese so taro narodo našti ine te arakhen kotar te anen le andre, uklinde upro čher, ćerde rupa ko tavani hem adathar mukle le sa e nosiljkaja ko maškar anglo Isus. ");
INSERT INTO rmna_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","I kad o Isus dikhlja lengiri vera, phenđa: “Manušeja, oprostimei će te grehija!” ");
INSERT INTO rmna_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","I o fariseja hem o učitelja e Zakonestar pučle pe ana pumende: “Kovai akava so hulini? Ko šaj te oprostini o grehija sem o jekh Devel?” ");
INSERT INTO rmna_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","A o Isus džanđa lengere mislija, i phenđa lenđe: “Sose ađahar mislinena? ");
INSERT INTO rmna_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Soi po lokhe te phenel pe: ‘Oprostimei će te grehija’ ili te phenel pe: ‘Ušti hem phir’? ");
INSERT INTO rmna_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ka dokažinav tumenđe da man, e Čhave e manušesere, isi pravo ki phuv te oprostinav o grehija.” Tegani phenđa e manušese kova našti ine te phirel: “Tuće vaćerava! Ušti, le ti nosiljka hem dža čhere!” ");
INSERT INTO rmna_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","I o manuš odmah uštino anglo lende, lelja i nosiljka hem dželo čhere slavindoj e Devle. ");
INSERT INTO rmna_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","I sare začudinde pe, hvalinde e Devle, pherdile dar hem vaćerde: “Avdive dikhljam bare čudesija!” ");
INSERT INTO rmna_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","I palo adava, o Isus iklilo adathar hem dikhlja e cariniko palo anav Levije sar bešela ko than kotar čedela pe o porez, i phenđa lese: “Phir pala mande!” ");
INSERT INTO rmna_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","I ov uštino, ačhavđa sa hem dželo palo leste. ");
INSERT INTO rmna_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","I o Levije spreminđa lese baro hajba pese ano čher, hem adari inele but carinici hem avera kola beštine olencar uzalo astali. ");
INSERT INTO rmna_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tegani o fariseja hem lengere učitelja e Zakonestar lelje te buninen pe vaćerindoj e Isusesere učenikonenđe: “Sose tumen hana hem pijena e carinikonencar hem avere grešnikonencar?” ");
INSERT INTO rmna_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","I o Isus phenđa lenđe: “E sastenđe na valjani doktori, nego e nambormenđe. ");
INSERT INTO rmna_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Me na aljum te vičinav ko pokajanje e pravednikonen, nego e grešnikonen.” ");
INSERT INTO rmna_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","A on phende lese: “E Jovanesere e Krstiteljesere učenici but postinena hem molinena, ađahar hem e farisejengere učenici, a te učenici hana hem pijena.” ");
INSERT INTO rmna_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","A o Isus phenđa lenđe: “Sar šaj te terinen e mladoženjasere amalen te postinen kadi olencar o mladoženja? ");
INSERT INTO rmna_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ali ka aven o dive kad o manuša ka len lendar e mladoženja. Tegani, ko adala dive, ka postinen.” ");
INSERT INTO rmna_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","I vaćerđa lenđe akaja uporedba: “Niko na sivela o kotor e neve fostanestar ko purano fostani sar te pherel i rupa; adalese so hem o nevo ka pharavđol, a ko purano naka avel o kotor e nevestar. ");
INSERT INTO rmna_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","I niko na čhorela i nevi mol ano purane morćha. Te ćerđa pe ađahar, kad i nevi mol ka zreloni, ka pharaj o morćha hem ka čhorđol, a o morćha ka oven uništime. ");
INSERT INTO rmna_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nego, i nevi mol valjani te čhorel pe ano neve morćha. ");
INSERT INTO rmna_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","I nijekh, kova pilja i purani mol, na mangela i nevi, adalese so vaćeri: ‘dovoljnoi i purani’.” ");
INSERT INTO rmna_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ko jekh savato o Isus nakhino maškaro njive. A lesere učenici čedinde e đivesoro klaso, morde le vastencar hem hale. ");
INSERT INTO rmna_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Tegani nesave fariseja phende: “Sose ćerena adava so palo Zakoni na tromal pe ko savato?” ");
INSERT INTO rmna_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","O Isus phenđa lenđe: “Na čitinđen li ano Sveto lil adava so ćerđa o David kad bokhalile ov hem okola so inele oleja? ");
INSERT INTO rmna_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Đerdinđa ano čher e Devlesoro, lelja hem halja o posvetime maro, savo nikase na inele muklo te han sem e sveštenikonenđe, hem čak dinđa le okolenđe so inele oleja te han.” ");
INSERT INTO rmna_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","I phenđa lenđe: “Me, o Čhavo e manušesoro, injum gospodari e savatesoro.” ");
INSERT INTO rmna_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ko aver savato, o Isus đerdinđa ki sinagoga hem sikavđa. I adari inele jekh manuš kasoro desno vas inele šuko. ");
INSERT INTO rmna_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Tegani o učitelja e Zakonestar hem o fariseja posmatrinena le ine te dikhen na li ko savato ka sasljari, sar te šaj tužinen le. ");
INSERT INTO rmna_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","A ov džanđa lengere mislija hem phenđa e manušese kas inele šuko vas: “Ušti hem terđov ko maškar!” I ov uštino hem terdino. ");
INSERT INTO rmna_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","A o Isus phenđa lenđe: “Te pučav tumen: so tromal pe te ćerel pe ko savato: šukaripe ili bišukaripe? Te spasini pe o dživdipe ili te uništini pe?” ");
INSERT INTO rmna_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","I dikhindoj ano sarijende, phenđa lese: “Pružin to vas!” I ov ćerđa ađahar hem lesoro vas ulo sasto. ");
INSERT INTO rmna_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","A o fariseja hem o učitelja e Zakonestar pherdile bari holi hem vaćerde maškara pumende so šaj te ćeren e Isusese. ");
INSERT INTO rmna_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Adala dive, o Isus dželo ki gora te molini pe. I nakhavđa sa i rat ani molitva e Devlese. ");
INSERT INTO rmna_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kad dislilo, vičinđa kora peste ple učenikonen hem birinđa olendar dešu dujen, kolen vičinđa apostolja: ");
INSERT INTO rmna_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","e Simone kole vičinđa Petar, hem lesere phrale e Andreja, e Jakove hem e Jovane, e Filipe hem e Vartolomeje, ");
INSERT INTO rmna_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","e Mateje hem e Toma, e Jakove e Alfejesere čhave hem e Simone kovai vičime Zilot, ");
INSERT INTO rmna_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","e Juda e Jakovesere čhave, hem e Juda e Iskariote, kova ulo izdajniko. ");
INSERT INTO rmna_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","I o Isus huljindoj olencar, terdino ko ravno than. A adari inele sa edobor lesere učenici hem but narodo taro but thana e judejakere, đi hem tari diz Jerusalim, hem taro e tiresere hem e sidonesere pašutne thana savei uzalo more. ");
INSERT INTO rmna_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ale te šunen le hem te oven sasljarde oto pumare nambormipa. A saslile hem okola kolen mučinde o bišukar duhija. ");
INSERT INTO rmna_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","I sa o manuša rodinde te pipinen le adalese so baro zoralipe ikljola ine olestar hem sasljari sarijen. ");
INSERT INTO rmna_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","I o Isus dikhlja ano ple učenici, i lelja te vaćeri: “Bahtale injen tumen o čorore, adalese soi o carstvo e Devlesoro tumaro! ");
INSERT INTO rmna_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Bahtalei okola kolai akana bokhale, adalese so o Devel ka čaljari tumen! Bahtalei okola kola akana rovena, adalese so ka asan! ");
INSERT INTO rmna_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Bahtale injen kad o manuša mrzinena tumen, kad odbacinena tumen, uvredinena tumen hem lađarena tumen da injen bišukar adalese so verujinena ana mande, ano Čhavo e manušesoro! ");
INSERT INTO rmna_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Tegani radujinen tumen hem ripinen oto bahtalipe, adalese so adžićeri tumen bari nagrada ko nebo! Adalese so, ađahar ćerena ine hem lengere pradada e prorokonencar. ");
INSERT INTO rmna_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ali jao tumenđe e barvalenđe, adalese so već leljen tumari uteha! ");
INSERT INTO rmna_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Jao tumenđe kola akana injen čaljarde, adalese so ka oven bokhale! Jao tumenđe kola akana asana, adalese so ka tugujinen hem ka roven! ");
INSERT INTO rmna_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Jao tumenđe kad sa o manuša vaćerena šukar tumendar, adalese so ađahar vaćerena ine hem lengere pradada e hovavne prorokonendar.” ");
INSERT INTO rmna_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“A vaćerava tumenđe so šunena: Volinen tumare neprijateljen! Ćeren šukaripe okolenđe so mrzinena tumen! ");
INSERT INTO rmna_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Blagoslovinen okolen so dena tumen armanja! Molinen tumen okolenđe so ćerena tumenđe bišukaripe! ");
INSERT INTO rmna_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Okolese kova khuvela tut ki čham, irin hem aver čham. Okolese kova lela to ogrtači, ma zabranin te lel tutar hem o gad. ");
INSERT INTO rmna_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","De svakonese kova rodela tutar nešto, hem te neko lela okova soi klo, ma rode adava palal. ");
INSERT INTO rmna_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","I sar so mangena avera te ćeren tumenđe, ađahar ćeren tumen olenđe. ");
INSERT INTO rmna_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Te volinena samo okolen kola tumen volinena, savi pohvala šaj te dobinen? Adalese so hem o grešnici volinena okolen kola olen volinena. ");
INSERT INTO rmna_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ađahar da, te ćerđen šukaripe okolenđe kola tumenđe ćerena šukaripe, savi pohvala šaj te dobinen? Hem o grešnici ćerena ađahar. ");
INSERT INTO rmna_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Te dinđen ko zajam pare okolenđe kastar adžićerena te irinen tumenđe, savi pohvala šaj te dobinen? Hem o grešnici dena ko zajam jekh averese te šaj irini pe lenđe edobor. ");
INSERT INTO rmna_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Nego, volinen tumare neprijateljen, ćeren lenđe šukaripe hem den len ko zajam bizo nisavo adžićeriba te irini pe tumenđe adava! I o Devel ka del tumen bari nagrada. I ka oven čhave e Najbaresere, adalese soi ov šukar hem premalo nezahvalna hem premalo bišukar. ");
INSERT INTO rmna_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Oven milosrdna sar soi milosrdno tumaro Dad kovai ano nebo!” ");
INSERT INTO rmna_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ma sudinen hem čače naka sudini pe tumenđe! I ma osudinen hem čače naka oven osudime! Oprostinen hem ka oprostini pe tumenđe! ");
INSERT INTO rmna_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Den hem ka del pe tumenđe: mera šukar, pritiskime, tresime hem prepherdi ka čhivel pe tumenđe ki angali. Adalese so, sava meraja merinena, esavkaja ka merini pe tumenđe.” ");
INSERT INTO rmna_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","I vaćerđa lenđe akaja uporedba: “Šaj li o kororo te legari e korore? Na li soduj ka peren ki rupa? ");
INSERT INTO rmna_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nane o učeniko upreder o učitelj. I svako kovai sikavdo sa, ka ovel samo sar plo učitelj. ");
INSERT INTO rmna_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","A sose dikheja i trunka ani jakh te phralesiri, a i greda ani ti jakh na primetineja? ");
INSERT INTO rmna_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Sar šaj te phene te phralese: ‘Phrala, aš te ikalavtar i trunka oti jakh’, a korkoro na dikheja i greda ani ti jakh? Dujemujengereja, najangle ikal i greda te jakhatar, i tegani šukar ka dikhe te ikale i trunka te phralesere jakhatar.” ");
INSERT INTO rmna_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Nijekh šukar kaš na dela bišukar plod, sar so nijekh bišukar kaš na dela šukar plod. ");
INSERT INTO rmna_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Adalese so svako kaš pendžari pe palo lesoro plod. Sar so džanen, o smokve na čedena pe oto kare ni o drakha na čedena pe oti kupina. ");
INSERT INTO rmna_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","E šukare manuše isi šukaripe ano vilo, i ađahar, ple vilestar ikali šukaripe, a o bišukar manuš ple vilestar ikali bišukaripe. Adalese so e manušesoro muj vaćeri adava sojai lesoro vilo pherdo.” ");
INSERT INTO rmna_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Sose vičinena man: ‘Gospode, Gospode!’, a na ćerena okova so vaćerava? ");
INSERT INTO rmna_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Svako kova avela mande hem šunela mle lafija hem ćerela len, ka mothovav tumenđe upra kastei: ");
INSERT INTO rmna_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ovi upro manuš kova ćerindoj plo čher handlja hem ćerđa hor, ćerđa o temelji upro bar hem vazdinđa o čher. I kad ale o panja, i len khuvđa ko adava čher, ali našti ine te potresini le adalese soi ćerdo šukar. ");
INSERT INTO rmna_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","A okova kova šunđa mle lafija, a na ćerđa len, ovi upro manuš kova ćerđa plo čher ki phuv bizo temelji, ko savo khuvđa i len hem otojekhvar peravđa le, i oto čher uli bari ruševina.” ");
INSERT INTO rmna_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","A kad o Isus završinđa plo vaćeriba anglo narodo, đerdinđa ki diz Kafarnaum. ");
INSERT INTO rmna_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","A jekhe rimljanengere kapetane, kova inele upreder šel vojnici, ine sluga kova inele namborme, anglo meriba, a ceninđa le. ");
INSERT INTO rmna_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","I kad o kapetani šunđa e Isusese, bičhalđa koro leste nesave jevrejengere starešinen te pučen le te šaj avel te sasljari lesere sluga. ");
INSERT INTO rmna_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","A kad ale koro Isus, šukar zamolinde le vaćerindoj: “Ov zaslužini te ćere lese adava, ");
INSERT INTO rmna_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","adalese so volini amare narodo, a ćerđa amenđe hem sinagoga.” ");
INSERT INTO rmna_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","I o Isus dželo olencar. A kad inele paše uzalo čher, o kapetani bičhalđa lese ple amalen vaćerindoj: “Gospode, ma mučin tut, adalese so na injum dostojno te đerdine maje ko čher. ");
INSERT INTO rmna_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Adalese na dikhljum man dostojno te avav đi tute. Nego samo naredin hem mlo sluga ka ovel sasto. ");
INSERT INTO rmna_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Adalese so hem me injum manuš talo autoritet, hem isi man vojnici teleder mande. I jekhese vaćerava: ‘Dža!’, i ov džala. A averese vaćerava: ‘Ava!’, i ov avela. A mle slugase vaćerava: ‘Ćer adava!’, i ov ćerela.” ");
INSERT INTO rmna_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","A kad o Isus šunđa adava olestar, iznenadinđa pe, irinđa pe nakoro narodo kova džala ine palo leste hem phenđa: “Vaćerava tumenđe, na arakhljum nijekhe ano Izrael te ovel le esavki vera.” ");
INSERT INTO rmna_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","I kad okola kola inele bičhalde irinde pe čhere, arakhle e sluga saste. ");
INSERT INTO rmna_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Na but palo adava, o Isus dželo ki diz savi vičini pe Nain. Oleja džele lesere učenici hem but narodo. ");
INSERT INTO rmna_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","A kad alo paše uzalo udar e dizjakoro, reslja e dizutnen sar legarena e mule čhave, kova inele jekhoro pe dajaće koja inele udovica. But dizutne džana ine e dajaja te parunen e čhave. ");
INSERT INTO rmna_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","I kad dikhlja la o Gospod, pelo lese žal olaće hem phenđa laće: “Ma rov!” ");
INSERT INTO rmna_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","I alo paše hem dolinđa pe upro nosilja, i tegani okola so akharde terdine. A o Isus phenđa: “Terneja, tuće vaćerava, ušti!” ");
INSERT INTO rmna_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","I o mulo beštino hem lelja te vaćeri, i o Isus dinđa le lesere dajaće. ");
INSERT INTO rmna_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tegani sare darandile hem slavinde e Devle vaćerindoj: “Baro proroko iklilo maškar amende!” hem: “O Devel alo te pomožini ple narodose!” ");
INSERT INTO rmna_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","I adava šundilo ki sa i phuv e jevrejengiri hem ko sa o pašutne thana. ");
INSERT INTO rmna_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","I sa adava e Jovanese e Krstiteljese vaćerde lesere učenici. Tegani o Jovan vičinđa kora peste nesave dujen ple učenikonendar ");
INSERT INTO rmna_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","hem bičhalđa len koro Gospod Isus vaćerindoj: “Tu li injan adava kova valjani te avel ili te adžićera avere?” ");
INSERT INTO rmna_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","I adala manuša ale koro Isus hem phende: “O Jovan o Krstitelj bičhalđa amen kora tute vaćerindoj: ‘Tu li injan adava kova valjani te avel ili te adžićera avere?’” ");
INSERT INTO rmna_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Baš tegani o Isus sasljarđa buten oto nambormipa, oto pharipa hem oto bišukar duhija, hem bute kororenđe dinđa dikhiba. ");
INSERT INTO rmna_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Tegani o Isus phenđa e Jovanesere učenikonenđe: “Džan hem vaćeren e Jovanese so dikhljen hem so šunđen: o korore dikhena, o bange phirena, o gubavci čistinena pe, o kašuke šunena, o mule uštena, e čororenđe vaćeri pe o Šukar lafi. ");
INSERT INTO rmna_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","I bahtaloi okova kova na našali pli vera ana mande.” ");
INSERT INTO rmna_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Kad e Jovanesere manuša džele, o Isus lelja te vaćeri e narodose e Jovanestar: “So ikliljen ki pustinja te dikhen? I trska sava phudela i barval? ");
INSERT INTO rmna_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ili so ikliljen te dikhen? E manuše ano barvale šeja urjavde? Na! Okola ano skupa šeja hem so živinena ano luksuz, eče tane ano palate. ");
INSERT INTO rmna_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ili so ikliljen te dikhen? E proroko? Oja, vaćerava tumenđe, ovi po više oto proroko! ");
INSERT INTO rmna_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ovi okova kastar pisime ano Sveto lil: ‘Ače, bičhalava mle glasniko angla tute, kova ka pripremini će o drom.’ ");
INSERT INTO rmna_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Vaćerava tumenđe: maškar okolende kolai bijande e đuvljendar nijekh nane po baro e Jovanestar, a o najtikoro e Devlese ano carstvo po baroi olestar.” ");
INSERT INTO rmna_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","I sa o manuša hem o carinici kola šunde adava, pendžarde dai e Devlesoro sikaviba čačikano, adaleja so krstinde pe e Jovanesere krstibnaja. ");
INSERT INTO rmna_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","A o fariseja hem o učitelja e Zakonestar odbacinde o plan e Devlesoro pumenđe. Oni adala so na mangle o Jovan te krstini len. ");
INSERT INTO rmna_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","O Isus phenđa: “Kasar akana te uporedinav e manušen oti akaja generacija? Kasei slična? ");
INSERT INTO rmna_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Sličnai e čhavorenđe kola bešena ko trg hem vaćerena jekh averese: ‘Bašalđam tumenđe veselo, a na čhelđen! Đilabđam tužno, a na runđen!’ ");
INSERT INTO rmna_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ađahar, kad alo o Jovan o Krstitelj, ni halja maro ni pilja mol, a phenena: ‘O demoni ano leste!’ ");
INSERT INTO rmna_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","A kad aljum me, o Čhavo e manušesoro, hava hem pijava, a phenena: ‘Eče manuš halano hem mato, amal e carinikonengoro hem e avere grešnikonegoro!’ ");
INSERT INTO rmna_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ali i mudrost e Devlesiri dokažini pe sa lakere čhavendar.” ");
INSERT INTO rmna_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Nesavo farisej palo anav Simon vičinđa e Isuse te avel te hal koro leste. Ov đerdinđa e farisejese ko čher hem čhivđa pe uzalo astali. ");
INSERT INTO rmna_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","I eče, adari ali i đuvli kolaće džanđa pe dai grešnica ani diz, adalese so šunđa da o Isus inele uzalo astali e farisejese ko čher, i anđa miris ko čaro savo inele ćerdo oto šužo bar. ");
INSERT INTO rmna_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","I terdindoj palo lesere pre, runđa hem lelja te sampaćeri lesere pre ple asvencar hem koslja len ple balencar. I tegani čumudinđa lesere pre hem makhlja len miriseja. ");
INSERT INTO rmna_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Kad adava dikhlja o farisej kova vičinđa le, phenđa ana peste: “Tei akava manuš proroko, ka džanel ine koi hem savi akaja đuvli koja pipini le – dai grešnica.” ");
INSERT INTO rmna_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","A o Isus phenđa lese: “Simone, isi man nešto te vaćerav će.” A ov phenđa: “Učitelju, vaćer!” ");
INSERT INTO rmna_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","I o Isus phenđa: “Duj džene inele dužnici nesave manušese kova dela pare ko zajam. Jekh dugujini lese panšel e rimljanengere denarija, a o dujto pinda. ");
INSERT INTO rmna_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Adalese so na ine len te irinen, ov oprostinđa o dugo sodujenđe. Kova, onda, olendar više ka volini le?” ");
INSERT INTO rmna_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","O Simon phenđa: “Mislinava da okova kase oprostinđa više.” Tegani ov phenđa lese: “Oja, šukar phenđan.” ");
INSERT INTO rmna_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Irinđa pe nakori đuvli, i phenđa e Simonese: “Dikheja li akala đuvlja? Đerdinđum tuće ko čher, pani mle prenđe na anđan, a oj sampaćerđa mle pre ple asvencar hem koslja len ple balencar. ");
INSERT INTO rmna_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Na pozdravinđan man čumudipnaja, a oj, sar đerdinđum na ačhavđa te čumudini mle pre. ");
INSERT INTO rmna_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Na makhljan mlo šero uljeja, a oj makhlja mle pre miriseja. ");
INSERT INTO rmna_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Adalese phenava će: But mangipe mothovđa, adalese soi laće oprostime but grehija. A hari mangipe mothoj okova kolesei oprostime hari grehija.” ");
INSERT INTO rmna_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","A olaće phenđa: “Oprostimei će te grehija.” ");
INSERT INTO rmna_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","A o manuša kola inele uzalo astali lelje ana peste te vaćeren: “Kovai akava so šaj hem o grehija te oprostini?” ");
INSERT INTO rmna_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Tegani o Isus phenđa e đuvljaće: “Ti vera spasinđa tut! Dža ano mir!” ");
INSERT INTO rmna_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Palo adava, o Isus lelja te džal ko dizja hem ko gava vaćerindoj o Šukar lafi oto carstvo e Devlesoro. Oleja džele hem o dešu duj apostolja ");
INSERT INTO rmna_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","hem nesave đuvlja kola inele sasljarde oto bišukar duhija hem oto nambormipa: i Marija vičimi Magdalena, kolatar ikalđa efta demonen, ");
INSERT INTO rmna_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","i Jovana, i romni e Irodesere upravnikosiri e Huzesiri, i Suzana hem but avera. Adala đuvlja pumare parencar kandle e Isuse hem lesere učenikonen. ");
INSERT INTO rmna_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kad čedinđa pe uzalo Isus baro narodo taro but dizja, ov vaćerđa lenđe jekh priča: ");
INSERT INTO rmna_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Iklilo o sejači te sejini. I sar frdela ine o seme, nesave zrnja pele ko drom, inele gazime hem o čiriklja sa hale len. ");
INSERT INTO rmna_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Nesave pele ko than kote inele hari phuv upro bara, i kad barile, šućile adalese so na ine len pani. ");
INSERT INTO rmna_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","I nesave pele maškaro kare, o kare barile olencar hem tasavde len. ");
INSERT INTO rmna_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","I nesave pele ki šukar phuv, barile hem ande bijandipe šel puti više.” Kad vaćerđa adava, vičinđa: “Kas isi kana, nek šunel!” ");
INSERT INTO rmna_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Tegani lesere učenici pučle le so manglja te vaćeri adala pričaja. ");
INSERT INTO rmna_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","A ov phenđa: “Tumenđei dindo te džanen o tajne oto carstvo e Devlesoro, a averenđe vaćerava ano priče, sar te šaj: ‘anglo jaćha te na dikhen hem anglo kana te na haljoven.’ ");
INSERT INTO rmna_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","A akava i priča vaćeri: O semei o lafi e Devlesoro. ");
INSERT INTO rmna_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nesavei manuša sar o drom ko savo pele o zrnja. Kad šunena o Lafi, avela o beng hem lela le lengere vilendar, sar te na poverujinen hem te na oven spasime. ");
INSERT INTO rmna_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","A nesavei sar o than e barencar ko savo pele o zrnja. Kad šunena o Lafi, odmah lena le radosno, ali nane len koreno. On nesavo vreme verujinena, ali kad avela o iskušenje otperena. ");
INSERT INTO rmna_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","A nesavei sar o than maškaro kare ko savo pele o zrnja. Adalai okola kola šunena o Lafi, ali živinena ano brige, ano barvalipe hem ano zadovoljstvija e dživdipnasere, i ovena tasavde hem na anena šukar plod. ");
INSERT INTO rmna_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","A nesavei sar i šukar phuv ki savi sejime o zrnja. Adalai okola kola e šukare hem e bimelale vileja šunena o Lafi hem ićerena le sa đikote na anena šukar plod.” ");
INSERT INTO rmna_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Niko na tharela i svetiljka te učhari la čareja ili te čhivel la talo than e pašljojbnasoro, nego čhivela la ko than zaki svetiljka te šaj dikhen o svetlost okola kola đerdinena. ");
INSERT INTO rmna_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Adalese so, sa soi garavdo, ka dičhol; sa soi tajno, ka šunđol. ");
INSERT INTO rmna_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Adalese pazinen sar šunena. Adalese so, kas isi, ka del pe lese pana, a kas nane, ka lel pe lestar hem adava so mislini da isi le.” ");
INSERT INTO rmna_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","A e Isusesiri daj hem lesere phralja avena ine nakoro leste, ali oto but narodo našti ine te aven đi oleste. ");
INSERT INTO rmna_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","A neko phenđa lese: “Ti daj hem te phralja terđona avri hem mangena te dikhen tut.” ");
INSERT INTO rmna_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","A o Isus phenđa: “Akalai mli daj hem mle phralja – kola šunena hem ćerena o lafi e Devlesoro.” ");
INSERT INTO rmna_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","I jekh dive o Isus phenđa ple učenikonenđe: “Te nakha ki aver strana oto jezero!” I đerdinde ano čamco hem pođinde. ");
INSERT INTO rmna_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","A sar plovinena ine, o Isus zasuća. I muklja pe jekh zorali barval upro jezero. O čamco lelja te pherđol pani i arakhle pe ani opasnost. ");
INSERT INTO rmna_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","I o učenici ale uzalo Isus hem džangavde le vaćerindoj: “Gospodarona, Gospodarona, meraja!” I o Isus uštino, naredinđa e barvaljaće hem e talasenđe te ačhon, i ačhile hem ulo mir. ");
INSERT INTO rmna_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Tegani pučlja e učenikonen: “Kaj tumari vera?” A on darandile hem začudime pučle jekh avere: “Kova šaj te ovel akava so naredini e barvaljenđe hem e panjese, a on šunena le?” ");
INSERT INTO rmna_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","I resle ko krajo e gerasakoro savoi prekalo e Galilejakoro jezero. ");
INSERT INTO rmna_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","A kad o Isus iklilo ki phuv, reslja le nesavo manuš tari diz kova inele opsednutime demonencar. Sa edobor vreme inele nango hem na beštino ano čher, nego maškaro grobija. ");
INSERT INTO rmna_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","I kad dikhlja e Isuse, vrištinđa, pelo anglo leste hem vičinđa oto sa o glaso: “So mangeja mandar, Isuse, Čhaveja e Najbare Devlesereja? Molinava tut, ma mučin man!” ");
INSERT INTO rmna_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","(Adalese so o Isus već naredinđa e melale duhose te ikljol adale manušestar. Angleder, đi hem kad o stražarija pazinena le ine hem phandena le ko lancija hem ko okovija, o manuš phagela len ine hem o demoni legari le ine ko čuče thana.) ");
INSERT INTO rmna_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","A o Isus pučlja le: “Sar to anav?” I ov phenđa: “Legija”, adalese so but demonja đerdinde ano leste. ");
INSERT INTO rmna_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","I zorale molinde le te na naredini lenđe te džan ki Beskrajno rupa. ");
INSERT INTO rmna_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","A adari ko brego inele krdo oto bale save hana ine, i o demonja molinde e Isuse te mukel lenđe te đerdinen ano bale. I ov muklja lenđe. ");
INSERT INTO rmna_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Tegani o demonja iklindoj e manušestar, đerdinde ano bale. I o bale prastandile taro brego ano jezero hem taslile. ");
INSERT INTO rmna_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","I kad okola so arakhena ine e balen dikhle so ulo, našle hem vaćerde adalestar e manušenđe ani diz hem ano gava. ");
INSERT INTO rmna_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Tegani o manuša ale te dikhen so ulo. Ale koro Isus hem arakhle e manuše, kolestar iklile o demonja, sar urjavdo hem saste gođaja bešela uzalo e Isusesere pre, i darandile. ");
INSERT INTO rmna_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","A okola so dikhle adava so ulo, vaćerde averenđe sar o Isus sasljarđa e opsednutime manuše. ");
INSERT INTO rmna_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","I sa o narodo oto krajo e gerasakoro zamolinde e Isuse te džal olendar adalese so uklinđa len bari dar. Tegani o Isus đerdinđa ano čamco te irini pe palal. ");
INSERT INTO rmna_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","A o manuš, kolestar o Isus ikalđa e demonen, molinđa e Isuse te džal oleja, ali o Isus bičhalđa le vaćerindoj: ");
INSERT INTO rmna_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Irin tut te čhereste hem vaćer sa so ćerđa će o Devel.” I o manuš dželo maškari sa i diz hem vaćerđa so ćerđa lese o Isus. ");
INSERT INTO rmna_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","A kad o Isus irinđa pe ki aver strana oto jezero, but manuša inele radosna so dikhe le so avela, adalese so sare adžićerena le ine. ");
INSERT INTO rmna_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","I dikh, alo o manuš palo anav Jair, kova inele vođa ani sinagoga. I perindoj anglo pre e Isusesere, phenđa: “Molinava tut, ava maje ano čher.” ");
INSERT INTO rmna_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Adalese so e Jairesiri jekhori čhaj, kola ine dešu duj berš, inele anglo meriba. I sar o Isus džala ine palo Jair, o narodo gurini pe ano leste. ");
INSERT INTO rmna_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","A maškaro narodo inele jekh đuvli kolatar dešu duj berš thavdinđa rat. Oj sa plo barvalipe dinđa ko doktorija, ali nijekh našti ine te sasljari la. ");
INSERT INTO rmna_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nakhini oto palal e Isusese hem dolinđa pe upro lesere fostanesoro krajo hem otojekhvar ačhilo te thavdel latar o rat. ");
INSERT INTO rmna_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","I o Isus pučlja: “Ko dolinđa pe upra mande?” A kad svako olendar phende: “Na injum me”, o Petar phenđa: “Gospodarona, sar te džana kad but džene čedinde pe hem gurinena pe uzala tute.” ");
INSERT INTO rmna_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","A o Isus phenđa: “Neko namerno dolinđa pe upra mande. Osetinđum sar ikljola mandar o zoralipe.” ");
INSERT INTO rmna_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","A i đuvli dikhlja so našti te garaj pe, tresindoj oti dar ali hem peli mujeja đi phuv anglo leste hem vaćerđa anglo sa o manuša sose dolinđa pe upro leste hem sar otojekhvar inele sasljardi. ");
INSERT INTO rmna_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","A o Isus phenđa laće: “Mli čhaj, ti vera sasljarđa tut. Dža ano mir!” ");
INSERT INTO rmna_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Sar o Isus pana vaćeri ine adava, nesavo manuš taro čher e Jairesoro, e sinagogakere vođasoro, alo hem phenđa: “Jaire, ti čhaj muli. Ma više mučin e učitelje.” ");
INSERT INTO rmna_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","A o Isus šunđa adava hem phenđa e Jairese: “Ma dara! Samo verujin hem oj ka ovel sasljardi!” ");
INSERT INTO rmna_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","I kad reslo ko čher, o Isus na muklja nikase te đerdini oleja, sem e Petrese, e Jovanese, e Jakovese hem e čhajorjakere dadese hem e dajaće. ");
INSERT INTO rmna_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","A sare, kola već inele ano čher, runde hem tugujinde palo late. A o Isus phenđa: “Ma roven! Adalese so oj na muli, nego sovela.” ");
INSERT INTO rmna_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","I on asandile lese adalese so džande so muli. ");
INSERT INTO rmna_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","A o Isus dželo hem dolinđa la oto vas hem vičinđa: “Čhajorije, ušti!” ");
INSERT INTO rmna_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","I lakoro duho irinđa pe ano late, i otojekhvar uštini, a o Isus naredinđa te den la nešto te hal. ");
INSERT INTO rmna_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","I lakoro dad hem lakiri daj inele but začudime, a o Isus naredinđa lenđe te na vaćeren nikase so ulo. ");
INSERT INTO rmna_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","A o Isus vičinđa e dešu duje apostolen hem dinđa len zoralipe hem autoritet upro sa o demonja hem te sasljaren o nambormipa. ");
INSERT INTO rmna_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","I bičhalđa len te propovedinen oto carstvo e Devlesoro hem te sasljaren e nambormen. ");
INSERT INTO rmna_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","I phenđa lenđe: “Ma legaren tumencar ništa ko drom: ni štapi, ni torba dromese, ni maro, ni pare, hem te na ovel tumen aver gad. ");
INSERT INTO rmna_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Sa đikote ačhovena ki nesavi diz, i đikote na džana adathar, bešen ano jekh čher. ");
INSERT INTO rmna_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Te na priminde tumen nesave dizutne, ikljoven tari adaja diz hem tresinen i prašina tumare prendar sar znako zako zoralo odbiba.” ");
INSERT INTO rmna_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","I on džele taro gav ko gav, vaćerindoj o Šukar lafi hem sasljarindoj e nambormen ko sa o thana. ");
INSERT INTO rmna_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","A o Irod, o vladari e Galilejakoro, šunđa sa so ulo i inele zbunime adalese so nesave vaćerde da o Jovan o Krstitelj uštino taro mule. ");
INSERT INTO rmna_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","A avera vaćerde da o proroko o Ilija mothovđa pe ki phuv, a nesave avera vaćerde da taro mule uštino nesavo proroko taro purano vreme. ");
INSERT INTO rmna_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","A o Irod phenđa: “Me čhinđum e Jovanesoro šero. A kovai onda akava kastar sa adava šunava?” I manglja te dikhel e Isuse. ");
INSERT INTO rmna_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","I kad o apostolja irinde pe koro Isus, vaćerde lese sa so ćerde. I o Isus legarđa len peja hem cidinđa pe olencar nakori diz vičime Vitsaida te šaj oven korkore. ");
INSERT INTO rmna_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ali o narodo šunđa adava i dželo palo lende. A o Isus dodžaćerđa len šukar, vaćerđa lenđe oto carstvo e Devlesoro hem sasljarđa okolen kase adava valjanđa. ");
INSERT INTO rmna_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","A kad lelja te perel i rat, o dešu duj apostolja nakhle đi o Isus hem phende lese: “Te muke ine e manušen te šaj džan ko pašutne gava hem thana kote šaj te arakhen nešto hajbnase hem than sojbnase. Adalese so injam akate ko čučo than kaj nane ništa.” ");
INSERT INTO rmna_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","A o Isus phenđa lenđe: “Den len tumen nešto hajbnase!” A on phende: “Ali isi amen samo pandž mare hem duj maćhe. Mangeja amendar te dža te čina hajbnase zako sa akava narodo?” ");
INSERT INTO rmna_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Adari inele đi ko pandž hiljade murša. Tegani o Isus phenđa ple učenikonenđe: “Čhiven len te bešen ko kupe po pinda.” ");
INSERT INTO rmna_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","I on ćerde ađahar, hem čhivde sarijen te bešen. ");
INSERT INTO rmna_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","O Isus lelja o pandž mare hem e duje maćhen, dikhlja nakoro nebo, zahvalinđa e Devlese zako hajba, phaglja len hem dinđa ko učenici te podelinen len e manušenđe. ");
INSERT INTO rmna_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","I sare hale đikote na čalile. A palo adava, dešu duj korpe čedinde pe okolestar so ačhilo oto hajba. ");
INSERT INTO rmna_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Jekhvar kad o Isus korkoro molinđa pe, oleja inele lesere učenici. Ov pučlja len: “So phenena o manuša, ko injum me?” ");
INSERT INTO rmna_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","A on phende: “Nesave manuša phenena da tu injan o Jovan o Krstitelj, a avera phenena da tu injan o proroko o Ilija, a nesave avera phenena da tu injan jekh oto avera proroci taro purano vreme kova uštino taro mule.” ");
INSERT INTO rmna_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Tegani o Isus pučlja len: “A so tumen phenena, ko injum me?” O Petar phenđa: “Tu injan o Hrist, kole o Devel bičhalđa!” ");
INSERT INTO rmna_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","A o Isus zorale naredinđa e učenikonenđe te na vaćeren nikase dai ov o Hrist. ");
INSERT INTO rmna_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","I phenđa: “Me, o Čhavo e manušesoro, valjani but te patinav. O starešine, o šerutne sveštenici hem o učitelja e Zakonestar naka prihvatinen man. Ka ovav mudardo, ali o trito dive ka uštav taro mule.” ");
INSERT INTO rmna_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","I o Isus phenđa sarijenđe: “Ko mangela te džal pala mande, mora te ačhaj pe ple dživdipnastar hem te lel plo krsto taro dive ko dive hem te phirel pala mande. ");
INSERT INTO rmna_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Adalese so, ko mangela te spasini plo dživdipe, ka našali le, a ko našali plo dživdipe zbog mande, ka spasini le. ");
INSERT INTO rmna_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","So vredini e manušese hem sa i phuv te ovel olesiri, a našali ili upropastini korkoro pes? ");
INSERT INTO rmna_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Adalese ko lađala mandar hem mle lafendar, hem me, o Čhavo e manušesoro, ka lađav olestar kad ka avav ani mli slava hem ani slava e Dadesiri hem e svetone anđelengiri. ");
INSERT INTO rmna_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","A čače vaćerava tumenđe, isi nesave akate maškara tumende kola naka meren đikote na dikhena o carstvo e Devlesoro.” ");
INSERT INTO rmna_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Đi sar ofto dive palo adava so phenđa lenđe, o Isus lelja peja e Petre, e Jovane hem e Jakove i dželo ki gora te molini pe. ");
INSERT INTO rmna_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","I sar molini pe ine, lesoro muj ulo averčhane hem lesere šeja ule but parne hem sjajna. ");
INSERT INTO rmna_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","I dikh, nekotar iklile duj manuša hem lelje te vaćeren oleja. Adala inele o Mojsije hem o Ilija. ");
INSERT INTO rmna_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","On mothovde pe ano baro sjaj hem vaćerde oleja e meribnastar savo adžićeri le ano Jerusalim. ");
INSERT INTO rmna_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","A o Petar hem okola so inele oleja, zasuće. Kad uštine, dikhle e Isuse ano baro sjaj hem e duje manušen sar terđona oleja. ");
INSERT INTO rmna_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","I kad lelje o Mojsije hem o Ilija te ciden pe e Isusestar, o Petar phenđa e Isusese: “Gospodarona, šukari amenđe so injam akate. Te ćera trin šatorja: jekh tuće, jekh e Mojsijase hem jekh e Ilijase.” Na džanđa so vaćeri. ");
INSERT INTO rmna_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Sar vaćeri ine adava, iklilo jekh oblako savo učharđa len. A on, kad učharđa len o oblako, darandile. ");
INSERT INTO rmna_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","I šundilo glaso taro oblako savo vaćerđa: “Akavai mlo Čhavo, kole birinđum! Ole šunen!” ");
INSERT INTO rmna_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","I palo adava so šundilo o glaso, o učenici dikhle samo e Isuse korkore. I trainde, hem tegani pana nikase na vaćerde adalestar so dikhle. ");
INSERT INTO rmna_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Tejsato dive, kad o Isus hem o trin učenici huljile tari gora, baro narodo alo te dikhel e Isuse. ");
INSERT INTO rmna_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","I dikh, nesavo manuš taro narodo lelja te vičini: “Učitelju, molinava tut te pomožine mle čhavese, adalese soi maje jekhoro! ");
INSERT INTO rmna_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","O bišukar duho but puti prelela le hem otojekhvar vrištini; frdela le ano grčevija hem ikljola lestar pena taro muj; uništini le hem jedva ačhaj le. ");
INSERT INTO rmna_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","I molinđum te učenikonen te ispudinen e bišukare duho mle čhavestar, ali on našti ine te ćeren adava.” ");
INSERT INTO rmna_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","A o Isus phenđa: “O, biverakiri hem rumimi generacijo! Pana kobor valjani te ovav tumencar hem te trpinav tumen? Ana te čhave akari!” ");
INSERT INTO rmna_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","I sar o čhavoro avela ine đi o Isus, o demoni frdinđa le ki phuv ano grčevija. A o Isus naredinđa e bišukare duhose te cidel pe e čhavorestar, sasljarđa e čhavore hem dinđa le palal ko dad. ");
INSERT INTO rmna_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Tegani sare inele začudime so dikhle e Devlesoro baro zoralipe. Sar sare čudinena pe ine zako adava so ćerđa o Isus, ov phenđa ple učenikonenđe: ");
INSERT INTO rmna_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Šunen šukar akala lafija: Me, o Čhavo e manušesoro, valjani te ovav predime ano vasta e manušengere.” ");
INSERT INTO rmna_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ali o učenici na halile so o Isus manglja te vaćeri adaleja. Adava inele olendar garavdo sar te na haljoven le, a darandile te pučen le so adaleja manglja te vaćeri lenđe. ");
INSERT INTO rmna_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","A o učenici lelje maškara pumende te raspravinen kovai olendar najbaro. ");
INSERT INTO rmna_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","A o Isus džanđa soi lenđe ki godi, lelja jekhe čhavore, čhivđa le uzala peste, ");
INSERT INTO rmna_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","i phenđa lenđe: “Svako kova primini akale čhavore zbog maje, man primini. A svako kova man primini, primini e Devle kova bičhalđa man. Adalese so, ko maškara tumende pes dikhela sar najtikore, ovi najbaro.” ");
INSERT INTO rmna_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","A o Jovan phenđa e Isusese: “Gospodarona, dikhljam nesave manuše sar ano to anav ispudini e demonen e manušendar. Amen na mukljam lese te ćerel adava, adalese so na džala amencar pala tute.” ");
INSERT INTO rmna_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","A o Isus phenđa lese: “Muken le te ćerel adava, adalese so okova kova nane protiv tumende, ovi tumencar!” ");
INSERT INTO rmna_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","A kad inele paše o dive e Isusesere te ovel vazdime ko nebo, ov zorale odlučinđa te džal ko Jerusalim. ");
INSERT INTO rmna_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","I bičhalđa nesave glasnikonen angla peste. I on džele hem đerdinde ko nesavo gav ani regija Samarija te pripreminen le e Isusese. ");
INSERT INTO rmna_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ali o gavutne na mangle e Isuse adalese so džande da džala ko Jerusalim. ");
INSERT INTO rmna_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","A dikhindoj adava o učenici o Jakov hem o Jovan, pučle e Isuse: “Gospode, mangeja li te phena te huljel taro nebo i jag hem sa te tharel len?” ");
INSERT INTO rmna_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","A o Isus irinđa pe hem ukorinđa len. ");
INSERT INTO rmna_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","I ov hem lesere učenici džele ko aver gav. ");
INSERT INTO rmna_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","I sar o učenici hem o Isus džana ine dromeja, nesavo manuš alo hem phenđa e Isusese: “Ka džav tuja kaj god tu džaja.” ");
INSERT INTO rmna_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","A o Isus phenđa lese: “E lisicen isi jazbine hem e čirikljen gnezdija, a man, e Čhave e manušesere nane kaj te pašljarav mlo šero.” ");
INSERT INTO rmna_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","A avere manušese phenđa: “Phir pala mande!” A ov phenđa: “Aš najangle, Gospode, te parunav mle dade, i ka džav pala tute.” ");
INSERT INTO rmna_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Tegani o Isus phenđa lese: “Muk o mule te parunen ple mulen, a tu dža vaćer oto carstvo e Devlesoro.” ");
INSERT INTO rmna_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","A aver manuš phenđa: “Ka phirav pala tute, Gospode, ali aš najangle te džav te pozdravinav man mle čherutnencar.” ");
INSERT INTO rmna_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","A o Isus phenđa lese: “Nijekh kova dolela pe upro plugo te orini i onda dikhela napalal, nane korisno zako carstvo e Devlesoro.” ");
INSERT INTO rmna_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Palo adava, o Gospod Isus birinđa avere eftavardešu duje učenikonen hem bičhalđa len duj po duj angla peste ko sa o dizja hem o thana ko save ov manglja te džal. ");
INSERT INTO rmna_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Angleder so te džan, o Isus phenđa lenđe: “I žetvai bari, a hari bućarne te čeden. Adalese, molinen e gospodare oti žetva te bičhali e bućarnen ki žetva pli. ");
INSERT INTO rmna_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Džan! Ače, bičhalava tumen sar bakroren maškaro ruva. ");
INSERT INTO rmna_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ma legaren tumencar kesa e parencar, ni torba dromese, ni buderi obuća. I ma našalen tumaro vreme ađahar so ka terđoven te pozdravinen nekasar odrumal. ");
INSERT INTO rmna_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","I kad đerdinena ko nesavo čher, prvo vaćeren: ‘Mir akale čhereste!’ ");
INSERT INTO rmna_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Te adari bešela o manuš kova mangela mir, tegani o mir, savese tumen molinena, ka ačhol oleja; a te na manglja mir, tumaro mir ka irini pe tumenđe. ");
INSERT INTO rmna_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kad avena ko nesavo čher, ma palo adava nakhen ko avera čhera. Ačhoven ko jekh than, han hem pijen adava so o čherutne ikalena angla tumende, adalese so o bućarno zaslužini pli plata. ");
INSERT INTO rmna_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","I ki savi diz đerdinena, a o dizutne priminena tumen, han okova so ikalena angla tumende. ");
INSERT INTO rmna_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Sasljaren e nambormen adari hem vaćeren sarijenđe: ‘Alo tumenđe paše o carstvo e Devlesoro!’ ");
INSERT INTO rmna_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","A ki savi diz đerdinena, a o dizutne na priminena tumen, iklindoj ko glavna droma e dizjakere, vaćeren: ");
INSERT INTO rmna_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Hem i prašina tumara dizjakiri, savi dolinđa pe ko amare pre, amen kosaja la sar znako zako zoralo odbiba. Ali te džanen da o carstvo e Devlesoro alo paše!’ ");
INSERT INTO rmna_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Vaćerava tumenđe da ko dive oto baro sudo, po lokhe ka ovel e manušenđe tari Sodoma negoli e manušenđe tari adaja diz.” ");
INSERT INTO rmna_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Jao tumenđe, manušalen taro Horazin! Jao tumenđe, manušalen tari Vitsaida! Te oven ine čudesija maškaro manuša taro Tir hem taro Sidon save ule maškara tumende, pana angleder ka bešen ine ano šeja oto kanaj hem ka čhoren pepeo upro pumare šere sar te mothoven da kajinena pe. ");
INSERT INTO rmna_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ali e manušenđe taro Tir hem taro Sidon ka ovel po lokhe ko Sudo negoli tumenđe. ");
INSERT INTO rmna_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","A tumen, manušalen taro Kafarnaum, na li đi o nebo ka vazden tumen? Đi o than e mulengoro isi te peren. ");
INSERT INTO rmna_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Tegani phenđa e učenikonenđe: Ko šunela tumen, man šunela, a ko odbini tumen, man odbini. A ko odbini man, odbini e Devle kova bičhalđa man.” ");
INSERT INTO rmna_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Kad o eftavardešu duj učenici irinde pe oto drom radosna, phende e Isusese: “Gospode, hem o demonja pokorinena pe amenđe ano to anav!” ");
INSERT INTO rmna_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","A o Isus ko adava phenđa lenđe: “Dikhljum e Sotone sar perela taro nebo sar munja. ");
INSERT INTO rmna_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Eče, dinđum tumen vlast te gazinen upro sapa hem o škorpije hem upro sa o zoralipe e neprijateljesoro hem ništa naka ovel tumenđe. ");
INSERT INTO rmna_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ali ma edobor radujinen tumen zako adava so o bišukar duhija pokorinena pe tumenđe, nego više radujinen tumen adalese soi tumare anava zapisime ano nebo.” ");
INSERT INTO rmna_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","I tegani o Isus radujinđa pe ano Sveto Duho hem phenđa: “Hvalinava tut, Dade, Gospode e nebosoro hem e phuvjakoro, so garavđan akava okolendar kola pes dikhena sar mudronen hem džanden, a mothovđan okolenđe kolai sar čhavore. Oja, Dade, džanav da ćerđan adava adalese so ađahar mangljan. ");
INSERT INTO rmna_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Mlo Dad sa muklja maje ko vasta. Niko na džanel e Čhave, sem o Dad; hem niko na džanel e Dade, sem o Čhavo hem okola kolenđe o Čhavo mangela te mothoj le.” ");
INSERT INTO rmna_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Tegani irinđa pe nakoro učenici hem samo olenđe phenđa: “Blago e jaćhenđe save dikhena adava so tumen dikhena! ");
INSERT INTO rmna_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Vaćerava tumenđe da but proroci hem carija mangle te dikhen akava so tumen dikhena, ali na dikhle; hem mangle te šunen okova so tumen šunena, ali na šunde!” ");
INSERT INTO rmna_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","I dikh, jekh dive sar o Isus sikaj ine, nesavo učitelj e Zakonestar uštino te pučel le nešto sar te iskušini le, i pučlja: “Učitelju, so valjani te ćerav te dobinav o večno dživdipe?” ");
INSERT INTO rmna_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","A o Isus phenđa lese: “Soi pisime ano e Mojsijasoro zakoni? So čitineja adari?” ");
INSERT INTO rmna_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","I ov phenđa e Isusese: “Volin e Gospode te Devle sa te vileja, sa te dušaja, sa te zoralipnaja hem sa te gođaja; hem volin te pašutne sar korkore tut.” ");
INSERT INTO rmna_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Tegani o Isus phenđa lese: “Šukar phenđan. Ćer ađahar hem ka živine.” ");
INSERT INTO rmna_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ali o učitelj e Zakonestar manglja te opravdini pe i pučlja e Isuse: “A koi mlo pašutno?” ");
INSERT INTO rmna_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","A ko adava, o Isus phenđa lese akaja priča: “Nesave manuše, sar huljela ine tari diz Jerusalim ki diz Jerihon, dolinde o čora. On lelje lestar sa, đi o šeja. Zorale marde le, i džele, a o manuš pašlilo ko drom hem na džanđa pese. ");
INSERT INTO rmna_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Na nakhlo but, i nekotar adale dromeja sar huljela ine nesavo svešteniko, dikhlja adale manuše hem nakhino oti aver strana. ");
INSERT INTO rmna_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ađahar da nesavo levit: alo đi adava than kote o manuš pašljola, dikhlja le i nakhino oti aver strana adale dromesiri. ");
INSERT INTO rmna_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","A inele nesavo Samarijanco savo džala ine adale dromeja. Kad reslja đi ko than kote o manuš pašljola, dikhlja le, i pelo lese žal olese. ");
INSERT INTO rmna_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Tegani o Samarijanco alo đi o manuš, čhorđa ulje hem mol upro lesere rane te kosel len hem paćarđa len. I čhivđa le upro plo her hem legarđa le ki gostionica, i adari brininđa pe olestar. ");
INSERT INTO rmna_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Tejsato dive o Samarijanco ikalđa duj srebrna kovanice hem dinđa ko manuš kasiri inele i gostionica hem phenđa lese: ‘Brinin tut akale manušestar, i sa so ka trošine buderi, ka irinav će kad ka irinav oto drom.’” ");
INSERT INTO rmna_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Tegani o Isus pučlja e učitelje e Zakonestar: “So tu pheneja? Kova akale trinendar mothovđa pe sar pašutno okolese kole dolinde o čora?” ");
INSERT INTO rmna_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","A ov phenđa: “Okova kova mothovđa lese milosrđe.” Tegani o Isus phenđa lese: “Oja, hem tu dža hem ćer ađahar!” ");
INSERT INTO rmna_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","I sar o Isus hem lesere učenici džana ine dromeja nakoro Jerusalim, đerdinde ko nesavo gav. Adari živinđa nesavi đuvli palo anav Marta. Oj priminđa len kora peste ko čher. ");
INSERT INTO rmna_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ola inele phen palo anav Marija, koja beštini uzalo e Gospodesere e Isusesere pre hem šunđa lesoro lafi. ");
INSERT INTO rmna_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","A i Marta sa ki sig dikhela ine te kandel, i ali uzalo Isus hem pučlja le: “Gospode, tu li na dikheja adava so mli phen muklja man korkora te kandav? Phen laće te pomožini maje.” ");
INSERT INTO rmna_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","A o Gospod phenđa laće: “Marto, Marto! Brinineja tut hem uznemirineja tut zako but so, ");
INSERT INTO rmna_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","a samo jekh valjani. I Marija izabirinđa okova soi po šukar, i adava naka lel pe latar.” ");
INSERT INTO rmna_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","I kad jekhvar o Isus završinđa e molitvaja, jekh lesere učenikonendar phenđa lese: “Gospode, sikav amen te molina sar so o Jovan o Krstitelj sikavđa ple učenikonen.” ");
INSERT INTO rmna_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Tegani o Isus phenđa lenđe: “Kad molinena, vaćeren: ‘Dade, to sveto anav barjardo te ovel! To carstvo te avel! ");
INSERT INTO rmna_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","De amen avdive o maro savo valjani amenđe svako dive! ");
INSERT INTO rmna_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Oprostin amenđe amare grehija sar so hem amen oprostinaja svakonese kova grešinđa premala amende! Hem cide amen taro iskušenje!’” ");
INSERT INTO rmna_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Tegani o Isus phenđa lenđe: “Zamislinen da ki ekvaš i rat džana koro tumaro amal te phenen lese: ‘Amala, te de man trin mare, i ka irinav će. ");
INSERT INTO rmna_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Mlo amal alo oto drom kora mande, a nane man so te ikalav anglo leste!’ ");
INSERT INTO rmna_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","A ov od andral te phenel: ‘Ma uznemirin man! O udarai phandle, a mle čhavore već pašlile mancar hem sovena. Našti akana te uštav te dav tut!’ ");
INSERT INTO rmna_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Vaćerava tumenđe: te na uštino te del le adalese soi lesoro amal, ka uštel hem ka del le sa so valjani adalese so lesere amale nane lađ te ovel uporno. ");
INSERT INTO rmna_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Vaćerava tumenđe: Mangen hem ka del pe tumenđe! Roden hem ka arakhen! Khuven hem ka phravel pe tumenđe! ");
INSERT INTO rmna_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Adalese so svako kova mangela, primini; hem kova rodela, arakhi; hem kova khuvela, ka ovel lese phravdo. ");
INSERT INTO rmna_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","A kova dad tumendar: kad lesoro čhavo ka rodel lestar ine maćhe, ka del le sape? ");
INSERT INTO rmna_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ili kad ka rodel jaro, ka del le škorpija? ");
INSERT INTO rmna_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kad tumen, kola injen bišukar, džanen te den šukar darija tumare čhavenđe, kobor više tumaro Dad taro nebo ka del e Svetone Duho okolenđe kola rodena olestar.” ");
INSERT INTO rmna_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","I jekh dive o Isus ispudinđa e demone kova ćerela ine jekhe manuše te našti vaćeri. Kad iklilo o demoni, o manuš lelja te vaćeri. I o narodo inele zadivime, ");
INSERT INTO rmna_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ali nesave olendar vaćerde: “E Veelzevulesere, e demonengere šerutnesere, zoralipnaja ispudini e demonen!” ");
INSERT INTO rmna_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","A avera iskušinde e Isuse ađahar so rodinde lestar znako taro nebo. ");
INSERT INTO rmna_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ali o Isus džanđa lengere mislija, i phenđa lenđe: “Svako carstvo savoi ana peste podelime ka properel, hem o čher ano savo nane sloga ka perel. ");
INSERT INTO rmna_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Tei e Sotonesoro carstvo ana peste podelime, sar onda pana trajini? Akava vaćerava adalese so tumen phenena da e Veelzevulesere zoralipnaja ispudinava e demonen. ");
INSERT INTO rmna_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","A te me e Veelzevulesere zoralipnaja ispudinava e demonen, kasere zoralipnaja tumare učenici ispudinena len? Adalese on ka dokažinen tumenđe da na injen u pravu. ");
INSERT INTO rmna_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ali te me e Devlesere zoralipnaja ispudinava e demonen, onda o carstvo e Devlesoro alo maškara tumende.” ");
INSERT INTO rmna_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","O Isus phenđa hem akava: “Kad okova kovai zoralo hem naoružime pazini plo čher, lesoro barvalipei osigurime. ");
INSERT INTO rmna_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ali kad avela o po zoralo lestar, ka pobedini le hem ka lel lestar o oružje upro savo inole nada hem ka delini plencar adava so lelja e bizoralestar. ");
INSERT INTO rmna_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ko nane mancar, ovi protiv mande. I ko na čedela mancar, ov čhorela.” ");
INSERT INTO rmna_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Tegani o Isus phenđa: “Kad o bišukar duho ikljola taro manuš, džala ko šuke thana rodindoj kote šaj te odmorini. Kad na arakhi le, vaćeri: ‘Ka irinav man ko čher kotar ikliljum.’ ");
INSERT INTO rmna_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","I irinđa pe hem arakhlja o čher šulavdo hem namestime. ");
INSERT INTO rmna_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Tegani džala hem lela efta avere duhen po bišukaren pestar hem đerdinena ano adava manuš hem ačhovena adari. I ko kraj adale manušese ovela po bišukar nego angleder.” ");
INSERT INTO rmna_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","I sar o Isus vaćeri ine adava, nesavi đuvli oto narodo vičinđa: “Bahtali i đuvli koja akharđa tut ano vođi hem dinđa tut čuči!” ");
INSERT INTO rmna_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","A o Isus phenđa: “Po bahtalei okola so šunena o lafi e Devlesoro hem ćerena le!” ");
INSERT INTO rmna_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Sar čedela pe ine po baro narodo, o Isus lelja te vaćeri: “Akajai generacija bišukar. Rodela mandar znako, ali nisavo znako naka del pe laće sem adava so inele e prorokose e Jonase. ");
INSERT INTO rmna_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Sar so adava so ulo e Jonaja inele znako e manušenđe kola živinde ki diz Niniva, ađahar hem so ka ovel mancar, e Čhaveja e manušesereja, ka ovel znako akala generacijaće. ");
INSERT INTO rmna_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ko dive oto baro sudo, i carica koja angleder vladinđa ki južno phuv ka uštel hem ka osudini e manušen oti akaja generacija, adalese so tari durutni phuv ali te šunel e Solomonesiri mudrost, a akatei tumencar neko po baro e Solomonestar, a tumen na mangena te šunen! ");
INSERT INTO rmna_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ko dive oto baro sudo, o manuša kola živinde ani purani diz Niniva ka ušten protiv akaja generacija hem ka osudinen la, adalese so on pokajinde pe kad o Jona propovedinđa, a akatei tumencar neko po baro e Jonastar, a tumen pana na pokajinđen tumen!” ");
INSERT INTO rmna_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Niko na tharela i svetiljka hem te čhivel la ko garavdo than ili talo čaro, nego čhivela la ko than zaki svetiljka te šaj dikhen o svetlost okola kola đerdinena. ");
INSERT INTO rmna_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ti jakhi sar svetiljka te telose. Kadi ti jakh šukar, sai to telo osvetlime. A kadi ti jakh bišukar, hem to teloi ani tomina. ");
INSERT INTO rmna_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Adalese, pazin da o svetlost so mislineja dai ana tute nane tomina. ");
INSERT INTO rmna_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tei sa to telo pherdo oto svetlost, bizo jekh deo oti tomina, tegani sa to dživdipe ka ovel osvetlime sar kad i svetiljka osvetlini tut ple svetloja.” ");
INSERT INTO rmna_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Kad o Isus vaćerđa adava, nesavo farisej vičinđa le te hal maro koro leste. I o Isus đerdinđa lese ko čher hem čhivđa pe uzalo astali. ");
INSERT INTO rmna_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","A o farisej dikhindoj adava, čudinđa pe so o Isus, palo adeti, na thovđa ple vasta angleder o hajba. ");
INSERT INTO rmna_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","A o Gospod Isus phenđa lese: “Oja, tumen o fariseja kosena i šolja hem o čaro od avrijal, a pherđen len tumara pohlepaja hem bišukaripnaja. ");
INSERT INTO rmna_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Hulavonalen! Nane li o Devel okova kova ćerđa e manuše, kova džanel le hem od avrijal hem od andral? ");
INSERT INTO rmna_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nego, den e čororenđe sar milostinja okova so isi tumen andre, hem sa ka ovel tumenđe čisto. ");
INSERT INTO rmna_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ali jao tumenđe e farisejenđe so dena e Devlese desetak oto začinja: oti nana, oti ruta hem oto sa o povrće, a ačhavđen te ćeren averenđe okova soi pravedno hem te volinen e Devle. Valjani te den o desetak, ali na troman te bistren te ćeren adava soi po bitno. ");
INSERT INTO rmna_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Jao tumenđe e farisejenđe so volinena te bešen ko anglune thana ano sinagoge hem so volinena kad o manuša, pherde poštujiba premala tumende, pozdravinena tumen ko trgija. ");
INSERT INTO rmna_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Jao tumenđe adalese so injen sar o bioznačime grobija upra savende o manuša phirena, a na džanen.” ");
INSERT INTO rmna_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tegani nesavo oto učitelja e Zakonestar phenđa e Isusese: “Učitelju, tu hem amen vređineja adale lafencar.” ");
INSERT INTO rmna_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","A o Isus phenđa: “Jao hem tumenđe, učiteljalen e Zakonestar! Čhivena upro manuša pharipa but phare te akharen ađahar so dena len pravilja save našti te ićeren, a ni najeja na mangena te mrdinen te pomožinen lenđe te akharen adava pharipe. ");
INSERT INTO rmna_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Jao tumenđe, adalese so vazdena spomenici e prorokonenđe kolen tumare pradada mudarde. ");
INSERT INTO rmna_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Adaleja mothovena da odobrinena adava so ćerde tumare pradada: on mudarde len, a tumen vazdena lenđe spomenici. ");
INSERT INTO rmna_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Adalese o Devel mudro vaćerđa tumendar: ‘Ka bičhalav lenđe prorokonen hem apostolen. Nekas olendar ka mudaren, a nekas ka progoninen.’ ");
INSERT INTO rmna_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Akala generacijatar ka rodel pe o rat sa e prorokonengoro savo thavdinđa pana taro ćeriba e svetosoro, ");
INSERT INTO rmna_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","pana taro rat e Aveljesoro sa đi o rat e Zaharijasoro, kova inele mudardo maškaro žrtveniko hem i svetinja ano Hram. Oja, vaćerava tumenđe, akaja generacija ka ovel osudime zako adava rat so thavdinđa! ");
INSERT INTO rmna_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Jao tumenđe, učiteljalen e Zakonestar! Adalese so e narodostar garavđen o ključo oto džandipe. Korkore na đerdinđen, a na mukljen te đerdinen ni okola kola mangle te đerdinen.” ");
INSERT INTO rmna_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","I kad o Isus iklilo adathar, o učitelja e Zakonestar hem o fariseja ani bari holi lelje te protivinen pe hem te pučen le but so. ");
INSERT INTO rmna_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","On dikhle te dolen le ko bišukar lafi sar te šaj optužinen le. ");
INSERT INTO rmna_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","I kad čedinde pe nekobor hiljade manuša, edobor džene inele da jekh avere gazinde, o Isus prvo lelja te vaćeri ple učenikonenđe: “Arakhen tumen taro kvasco e farisejengoro, te na oven dujemujengere sar soi on. ");
INSERT INTO rmna_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Sa soi garavdo, ka otkrijini pe; sa soi tajno, ka šunđol. ");
INSERT INTO rmna_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Adalese, sa so vaćerđen ani tomina, ka šunđol ano svetlost; hem so pohari vaćerđen ko kan ano sobe, ka vaćeri pe taro krovija sare te šunen.” ");
INSERT INTO rmna_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ali phenava tumenđe, amalalen: ma daran okolendar kola šaj te mudaren samo o telo, adalese so više adalestar naka šaj te ćeren tumenđe. ");
INSERT INTO rmna_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","A ka phenav tumenđe kastar te daran: te daran taro Devel kas palo mudariba isi zoralipe te frdel ano pakao. Oja, vaćerava tumenđe, olestar te daran! ");
INSERT INTO rmna_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Na biknena pe li pandž čiriklja zako samo duj najtikore kovanice? A palem nijekh olendar nane bisterdi anglo Devel. ");
INSERT INTO rmna_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","A tumenđei hem svako bal ko šero džendo. Adalese, ma daran! E Devlese injen po dragocena negoli but čiriklja!” ");
INSERT INTO rmna_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“A vaćerava tumenđe: Svako kova anglo manuša ka priznajini dai mlo, me, o Čhavo e manušesoro, anglo anđelja e Devlesere ka priznajinav dai ov mlo. ");
INSERT INTO rmna_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","A te odrekninđa pe neko mandar anglo manuša, hem me ka odrekninav man olestar anglo anđelja e Devlesere. ");
INSERT INTO rmna_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","I te vaćerđa neko lafi protiv o Čhavo e manušesoro, ka ovel lese oprostime; ali naka ovel oprostime okolese kova hulini upro Sveto Duho. ");
INSERT INTO rmna_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","A kad ka anen tumen anglo sudo ko sinagoge, anglo vladarija hem o vlastija, ma oven zabrinuta sar hem soja te braninen tumen, so te vaćeren! ");
INSERT INTO rmna_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Adalese so tegani o Sveto Duho ka sikaj tumen so te vaćeren.” ");
INSERT INTO rmna_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tegani neko oto narodo phenđa e Isusese: “Učitelju, vaćer mle phralese te podelini mancar o nasledstvo.” ");
INSERT INTO rmna_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","A o Isus phenđa lese: “Manušeja, ko čhivđa man te ovav sudija ili delioco upra tumende?” ");
INSERT INTO rmna_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Tegani phenđa sarijenđe: “Arakhen tumen hem ciden tumen tari pohlepa. I sa edobor barvalipe te ovel e manuše, lesoro dživdipe na avela oto adava so isi le.” ");
INSERT INTO rmna_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Tegani o Isus phenđa lenđe akaja priča: “Nesave barvale manušesiri phuv bijanđa but. ");
INSERT INTO rmna_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","I ov mislinđa pe ana peste: ‘So te ćerav? Nane man edobor baro than kote te čhivav mli žetva.’ ");
INSERT INTO rmna_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","I phenđa: ‘Akava ka ćerav! Ka peravav mle purane šupe hem ka vazdav po bare, i adathe ka čhivav sa o điv hem avera šukaripa. ");
INSERT INTO rmna_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Tegani ka vaćerav mla dušaće: Isi tut baro barvalipe bute beršenđe. Odmorin, ha, pi hem uživin!’ ");
INSERT INTO rmna_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ali o Devel phenđa lese: ‘Hulavona! Akaja rat ka mere! A sa adava so spreminđan, kasoro ka ovel?’ ");
INSERT INTO rmna_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ađahari okolese kova pese čedela barvalipe, a čororoi anglo Devel.” ");
INSERT INTO rmna_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Tegani o Isus phenđa ple učenikonenđe: “Adalese vaćerava tumenđe: ma oven zabrinuta zako tumaro dživdipe: ka ovel tumen li so te han; ni zako tumaro telo: ka ovel tumen li so te urjaven. ");
INSERT INTO rmna_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Adalese soi o dživdipe po bitno e hajbnastar hem tumaroi telo po bitno e šejendar. ");
INSERT INTO rmna_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Dikhen e gavranen! Ni sejinena ni čedena, nane len ni šupa kote te čhiven o điv, a palem o Devel parvari len. A tumen injen e Devlese po vredna e čirikljendar! ");
INSERT INTO rmna_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","A kova tumendar šaj adaleja so brinini pe te produžini hari plo dživdipe? ");
INSERT INTO rmna_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Znači te našti ni adava najhari te ćeren, sose onda brininena tumen zako bilo so aver? ");
INSERT INTO rmna_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Dikhen o divlja luluđa sar barjona. Na ćerena buti, niti sivenafse šeja, a vaćerava tumenđe da ni o caro o Solomon, kova inele but barvalo, na inole edobor šuže šeja sar jekha olendar. ");
INSERT INTO rmna_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Te o Devel ađahar šukar urjavela o biljke ko polje savei avdive adathe, a već tejsa frdena pe ani jag, kobor li više tumenđe ka del šeja, tikora verakere manušalen! ");
INSERT INTO rmna_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Tumen ma oven zabrinuta zako adava so ka han hem so ka pijen, ");
INSERT INTO rmna_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","adalese so adava rodena okola kola na džanen e Devlese. Tumaro Dad, o Devel, džanel da valjani tumenđe sa adava. ");
INSERT INTO rmna_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nego roden o carstvo e Devlesoro, a ov ka del tumen sa adava so valjani tumenđe! ");
INSERT INTO rmna_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ma daran, mlo tikoro stado! Tumare Dadesiri volja inele te del tumen o carstvo. ");
INSERT INTO rmna_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Bikninen so isi tumen hem o pare den e čororenđe! Ćeren tumenđe kese zako pare save na properena hem barvalipe ko nebo savo nikad na tikorini. Niko naka šaj te avel adari te čorel tumaro barvalipe hem nijekh moljco naka uništini le. ");
INSERT INTO rmna_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Adalese so tumaro vilo ka ovel adari kaj tumaro barvalipe.” ");
INSERT INTO rmna_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","O Isus ple učenikonenđe phenđa hem akava: “Oven spremna, urjavde zaki buti hem tumare svetiljke te oven tharde, ");
INSERT INTO rmna_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","sar sluge kola adžićerena ple gospodare te irini pe čhere taro bijav. Kad irini pe o gospodari hem kad khuvela ko udar, o slugei spremna te phraven lese. ");
INSERT INTO rmna_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Blago okole slugenđe kolen o gospodari, kad ka avel, ka arakhi len sar adžićerena le džangale! Čače, vaćerava tumenđe, ov, o gospodari, ka phandel pe i kecelja, ka bešljaćeri len te han hem ka kandel len. ");
INSERT INTO rmna_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Blago e slugenđe kolen o gospodari ka arakhi džangalen čak hem te alo ki ekvaš i rat ili anglo disljojba. ");
INSERT INTO rmna_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ali akava te džanen: te džanel ine o domaćini ko savo sati avela o čor, naka mukel lese ine te đerdini ko čher te čorel. ");
INSERT INTO rmna_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Hem tumen oven spremna, adalese so o Čhavo e manušesoro ka avel tegani kad na nadinena tumen!” ");
INSERT INTO rmna_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Tegani o Petar pučlja e Isuse: “Gospode, vaćereja li akaja priča samo amenđe e učenikonenđe ili sarijenđe?” ");
INSERT INTO rmna_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","O Gospod Isus phenđa: “Kovai, onda, verno hem mudro upravniko kas o gospodari ka čhivel upreder ple sluge te del len hajba ko vreme? ");
INSERT INTO rmna_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Blago okole slugase kas lesoro gospodari, kad ka avel, ka arakhi sar ćerela ađahar. ");
INSERT INTO rmna_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Čače vaćerava tumenđe, upreder sa o barvalipe plo ka čhivel le sar upravniko. ");
INSERT INTO rmna_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","A te vaćerđa adava sluga ana peste: ‘Naka avel pana mlo gospodari’ i lela te marel avere slugen, hem te hal, te pijel hem te mačol, ");
INSERT INTO rmna_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","lesoro gospodari ka avel ano okova dive hem okova sati kad naka adžićeri le, ka čhinel le ko ekvaš hem ka čhivel le maškaro nevernici. ");
INSERT INTO rmna_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","A okova sluga kova džanđa i volja ple gospodaresiri, a na inele spremno ili na ćerđa pali e gospodaresiri volja, but mariba ka hal. ");
INSERT INTO rmna_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","A okova kova na džanđa e gospodaresiri volja, a ćerđa nešto zako so zaslužini kazna, hari mariba ka hal. Kasei dindo but, but ka rodel pe lestar. Kasei poverime but, više ka rodel pe lestar.” ");
INSERT INTO rmna_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Tegani o Isus phenđa: “Aljum te frdav jag e sudosiri ki phuv. So bi mangava ine već te ovel thardi! ");
INSERT INTO rmna_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","A valjani te nakhavav e patibnasoro krstiba. But maje pharo đikote adava na završini pe! ");
INSERT INTO rmna_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Mislinena da aljum te anav mir ki phuv? Na. Aljum te ćerav o manuša te ciden pe jekh averestar. ");
INSERT INTO rmna_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Adalese od akana, oto pandž čherutne, trin ka oven ki mli strana, a duj ki aver ili duj ki mli strana, a trin ki aver. ");
INSERT INTO rmna_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ka uštel o dad upro čhavo hem o čhavo upro dad, i daj upri čhaj hem i čhaj upri daj, i sasuj upri bori hem i bori upri sasuj.” ");
INSERT INTO rmna_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Tegani o Isus vaćerđa e narodose: “Kad dikhena da o oblaci avena taro zapad, tegani phenena da ka perel bršim, i čače perela. ");
INSERT INTO rmna_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kad phudela i barval taro jug, phenena da ka ovel tatipe, i ovela. ");
INSERT INTO rmna_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Dujemujengere manušalen! Džanen te pendžaren o izgled e phuvjakoro hem e nebosoro; sar onda na džanen te pendžaren o znakija akale vremesere? ");
INSERT INTO rmna_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Tumen korkore valjani te pendžaren okova soi ispravno. ");
INSERT INTO rmna_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Te neko legari tut ko sudo te tužini tut adalese so na irinđan lese o pare, odrumal de sa tutar te mirine tut oleja angleder nego so resena adari. Te na ćerđan ađahar, ov šaj te vucini tut anglo sudija, a o sudija ka del tut ko manuš kova ka čhivel tut ano phandlipe. ");
INSERT INTO rmna_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Vaćerava će da čače naka ikljove adathar sa đikote na irineja đi i zadnjo para.” ");
INSERT INTO rmna_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ano adava vreme nesave manuša phende e Isusese so o Pilat, o upravniko e rimesoro, naredinđa nesave Galilejci te oven mudarde sar anena ine žrtve ano Hram. ");
INSERT INTO rmna_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","A o Isus phenđa lenđe: “Tumen li mislinena da adala Galilejci, adalese so ađahar mudardile, inele po grešna sa avere Galilejconendar? ");
INSERT INTO rmna_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Na! Ali te na pokajinđen tumen, sarijen tumen ka adžićeri propast! ");
INSERT INTO rmna_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ili okola dešu ofto upro kolende peli i kula ano Siloam hem mudarđa len, tumen li mislinena da on inele po bare grešnici sa e manušendar kola živinena ano Jerusalim? ");
INSERT INTO rmna_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Na! Ali te na pokajinđen tumen, sarijen tumen ka adžićeri propast!” ");
INSERT INTO rmna_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Tegani o Isus vaćerđa lenđe akaja priča: “Inele nesave manuše smokva sadime pese ano vinograd, i alo te rodel lakoro plod, ali ništa na arakhlja. ");
INSERT INTO rmna_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Tegani phenđa e vinogradarese: ‘Ače, trin berš sar avava te rodav plod upri akaja smokva, ali na arakhava le. Čhin la! Sose te šućari i phuv?’ ");
INSERT INTO rmna_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","A ov phenđa: ‘Gospodarona, ačhav la pana akava berš. Ka handav okolo late hem ka frdav laće đubrivo, ");
INSERT INTO rmna_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","i šaj đi berše ka anel plod. A te na bijanđa, ka čhine la.’” ");
INSERT INTO rmna_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","I jekh savato sar o Isus sikaj ine ani jekh sinagoga, ");
INSERT INTO rmna_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","adari inele nesavi đuvli kola o bišukar duho ćerela ine te ovel namborme. Oj inele grbavo dešu ofto berš hem nisar našti ine te ispravini pe. ");
INSERT INTO rmna_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Kad o Isus dikhlja la, vičinđa la kora peste hem phenđa laće: “Đuvlije, oslobodimi injan taro to nambormipe!” ");
INSERT INTO rmna_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","I čhivđa ple vasta upro late, a oj otojekhvar ispravinđa pe hem lelja te slavini e Devle. ");
INSERT INTO rmna_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tegani e sinagogakoro vođa, holjame so o Isus sasljarđa ko savato, phenđa e narodose: “Isi šov dive ano kurko ko save šaj te ćerel pe buti! Ko adala dive aven hem oven sasljarde, a na ko savato!” ");
INSERT INTO rmna_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","A o Gospod Isus phenđa lese: “Dujemujengere injen! Tumen li ko savato na phravena tumare guruve ili tumare here taro jasle te legaren le te pijel pani? ");
INSERT INTO rmna_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","A akajai đuvli oto pleme e Avraamesoro kola o Sotoni ićerđa phandlja dešu ofto berš. Oj li na valjani te ovel phravdi taro akala lancija e nambormipasere ko savato?” ");
INSERT INTO rmna_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Kad phenđa adava, lađandile sare kola inele protiv leste, a sa avera manuša radujinde pe zako sa o šukar delja save o Isus ćerđa. ");
INSERT INTO rmna_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Tegani o Isus phenđa: “Savesei slično o carstvo e Devlesoro? Soja te uporedinav le? ");
INSERT INTO rmna_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Sličnoi e semese oti gorušica save o manuš lelja hem frdinđa pese ki bašta. Ov barilo hem ulo kaš, hem o čiriklja ćerde gnezdija upro lesere granke.” ");
INSERT INTO rmna_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","I palem phenđa: “Soja te uporedinav o carstvo e Devlesoro? ");
INSERT INTO rmna_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Sličnoi e kvascose save i đuvli lelja hem čhivđa ano but baro čaro vareja, i ov ćerđa sa o humer te uštel.” ");
INSERT INTO rmna_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","I sar o Isus džala ine ple dromeja đi ko Jerusalim, nakhela ine ko dizja hem ko gava hem sikaj e narodo. ");
INSERT INTO rmna_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","I neko pučlja le: “Gospode, samo li hari manuša ka oven spasime?” A o Isus phenđa lenđe: ");
INSERT INTO rmna_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Den sa tumendar te đerdinen maškaro tesno udar e nebosoro adalese so but džene, vaćerava tumenđe, ka roden te đerdinen, ali naka šaj. ");
INSERT INTO rmna_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kad o domaćini ka uštel hem ka phandel o udar, ka ovel kasno. Tegani ka terđoven avri hem ka khuven ko udar vaćerindoj: ‘Gospodarona, phrav amenđe!’ Ali ov ka phenel tumenđe: ‘Na džanav tumen kotar injen.’ ");
INSERT INTO rmna_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Tegani ka phenen: ‘Haljam hem piljam tuja, hem tu sikavđan ko amare dizjengere droma.’ ");
INSERT INTO rmna_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","A ov ka phenel: ‘Na džanav tumen kotar injen. Ciden tumen mandar, sare tumen kola ćerena bišukaripe!’ ");
INSERT INTO rmna_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Tegani ka ovel baro rojba hem krciba e dandengoro tari dukh kad ka dikhen e Avraame, e Isaake, e Jakove hem sa e prorokonen ano carstvo e Devlesoro, a tumen frdime avri. ");
INSERT INTO rmna_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","O manuša ka aven taro istok hem taro zapad, taro sever hem taro jug hem ka čhiven pe uzalo astali ki gozba ano carstvo e Devlesoro. ");
INSERT INTO rmna_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ače, okola kolai akana prva tegani ka oven zadnja, a okola kolen akate dikhena sar zadnjonen adari ka oven prva.” ");
INSERT INTO rmna_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","I tegani nesave fariseja ale koro Isus hem phende lese: “Dža akatar ko nesavo aver than, adalese so o caro o Irod mangela te mudari tut.” ");
INSERT INTO rmna_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","O Isus phenđa lenđe: “Džan hem vaćeren adala lisicaće: ‘Ka ispudinav e demonen hem ka sasljarav avdive hem tejsa, a ko trito dive završinava mli buti.’ ");
INSERT INTO rmna_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ali avdive, tejsa hem prektejsa valjani te džav mle dromeja, adalese so izgledini dai o Jerusalim than kote sa o proroci valjani te oven mudarde. ");
INSERT INTO rmna_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jerusalime, Jerusalime, tu savo mudareja e prorokonen hem frdeja bara upro okola kolai tuće bičhalde! But puti mangljum te čedav te manušen sar i khani ple pilićken talo ple phaka, ali tumen na mangljen! ");
INSERT INTO rmna_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ače, to čher ka ovel napustime! I vaćerava tumenđe da čače naka dikhen man đikote na phenena: ‘Blagoslovimei okova kova avela ano anav e Gospodesoro!’” ");
INSERT INTO rmna_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","I ko jekh savato, o Isus inele vičime ko čher nesave farisejengere vođasoro te hal maro, i dželo. Sare so inele adari, šukar ine posmatrinena le, ");
INSERT INTO rmna_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","adalese so anglo leste inele nesavo namborme manuš kasere vasta hem o pre inele pherde pani. ");
INSERT INTO rmna_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","I o Isus pučlja e učiteljen e Zakonestar hem e farisejen: “Palo e Mojsijasoro zakoni, tromal pe li te sasljari pe ko savato ili na?” ");
INSERT INTO rmna_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","A on ništa na phende. Tegani o Isus čhivđa plo vas upro namborme manuš, sasljarđa le hem muklja le te džal. ");
INSERT INTO rmna_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","A olenđe phenđa: “So mislinena tumaro čhavo ili tumaro guruv ko savato perela ano bunari, na li sigate ka ikalen le ine adathar?” ");
INSERT INTO rmna_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","I na ine len so te phenen ko adava. ");
INSERT INTO rmna_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Kad o Isus dikhlja sar o gostija kola ale te han rodenafse najšukar thana bešibnase, phenđa lenđe akaja priča: ");
INSERT INTO rmna_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Kad injan vičime nekase ko bijav, ma beš ko najšukar than, adalese so šaj maškaro vičime isi nesavo manuš kovai po baro tutar. ");
INSERT INTO rmna_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Tegani okova so vičinđa tut ka phenel će: ‘De to than akalese.’ Tegani ka ove lađardo, i ka dža te dole o zadnjo than. ");
INSERT INTO rmna_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Nego, kad injan vičime, dža hem beš ko zadnjo than. Kad ka dikhel tut okova so vičinđa tut ka phenel će: ‘Amala, ava beš ko po šukar than!’ Tegani sa o gostija ka dikhen kobor injan poštujime. ");
INSERT INTO rmna_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Adalese, ko pes povazdela, ka ovel peravdo; a ko ponizini pe, ka ovel povazdime.” ");
INSERT INTO rmna_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Tegani o Isus phenđa okolese so vičinđa le: “Kad vičineja gostonen ko ručko ili ki večera, ma vičin samo te amalen, te phraljen, te familija, hem te barvale komšijen. Te vičinđan olen, hem on tut ka vičinen ko hajba kora pumende sar te irinen će. ");
INSERT INTO rmna_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nego, kad vičineja ko hajba, vičin e čororen, e sakatimen, e bangen hem e kororen. ");
INSERT INTO rmna_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Tegani ka ove blagoslovime, adalese so olen nane sar te irinen će. A o Devel ka irini će tegani kad ka vazdel taro mule e pravednikonen.” ");
INSERT INTO rmna_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Kad adava šunđa jekh okolendar so beštine uzalo astali, phenđa e Isusese: “Bahtaloi okova kova ka hal maro ano carstvo e Devlesoro!” ");
INSERT INTO rmna_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","A ko adava, o Isus phenđa lese: “Nesavo manuš ćerđa bari gozba hem vičinđa bute manušen. ");
INSERT INTO rmna_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","I kad sa inele ćerdo hajbnase, bičhalđa ple sluga te phenel e vičimenđe: ‘Sai akana spremno. Aven!’ ");
INSERT INTO rmna_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ali jekh pala avereste lelje te phenen lese sose našti te aven. O prvo phenđa lese: ‘Činđum njiva i valjani te džav te dikhav la. Molinava tut, vaćer te gospodarese da adalese našti te avav.’ ");
INSERT INTO rmna_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","O dujto phenđa: ‘Samo so činđum deše guruven i džava te dikhav sar ka orinen. Molinava tut, vaćer te gospodarese da adalese našti te avav.’ ");
INSERT INTO rmna_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","O trito phenđa: ‘Samo so ženinđum man i adalese našti te avav.’ ");
INSERT INTO rmna_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","I o sluga irinđa pe hem phenđa sa adava ple gospodarese. Tegani o gospodari holjanđa i phenđa ple slugase: ‘Siđar, ikljov ko droma e dizjakere hem ko trgija i ana akari e čororen, e sakatimen, e kororen hem e bangen.’ ");
INSERT INTO rmna_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Kad o sluga ćerđa adava, phenđa: ‘Gospodarona, ćerđum ađahar sar so naredinđan, ali pana isi thana.’ ");
INSERT INTO rmna_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","I o gospodari phenđa lese: ‘Ikljov avri tari diz ko droma hem ko staze hem terin e manušen te aven te ovel pherdo mlo čher. ");
INSERT INTO rmna_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Vaćerava tumenđe da nijekh okole manušendar kola inele vičime naka hal ki mli gozba.’” ");
INSERT INTO rmna_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","I but manuša džana ine dromeja palo Isus. Ov irinđa pe nakoro lende hem phenđa lenđe: ");
INSERT INTO rmna_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Te neko mangela te ovel mlo učeniko, valjani te volini man but više nego ple dade hem pla daja, pla romnja hem ple čhaven, ple phraljen hem ple phenjen, više nego plo dživdipe. Te na ćerđa ađahar, našti te ovel mlo učeniko. ");
INSERT INTO rmna_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ko na akhari plo krsto hem na džala pala mande, našti te ovel mlo učeniko. ");
INSERT INTO rmna_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Adalese so, ko tumendar ka lel ine te vazdel kula, a angleder adalestar te na bešel te računini o troško te dikhel ka šaj li te završini la? ");
INSERT INTO rmna_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Te samo čhivđa o temelji, i na ačhola le pare te završini đi o kraj, sare kola ka dikhen adava ka asan lese ");
INSERT INTO rmna_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","hem ka phenen: ‘Akava manuš lelja te vazdel kula, a našti ine te završini la!’ ");
INSERT INTO rmna_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ili, kova caro kad džala te arakhi pe ko mariba avere caronencar, angleder adalestar na bešela te razmislini šukar ka šaj li ple deše hiljadencar te marel pe adaleja kova avela protiv leste ple biše hiljadencar? ");
INSERT INTO rmna_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Te našti, ka bičhali ple manušen koro aver caro, sar pana na alo paše, te pučen le savei o uslovija zako mir. ");
INSERT INTO rmna_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ađahar da svako tumendar kova na mukela sa so isi le, našti te ovel mlo učeniko.” ");
INSERT INTO rmna_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Tegani o Isus phenđa: “Šukari o lon. Ali te našalđa plo londipe, soja ov ka lonđari pe? ");
INSERT INTO rmna_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Esavko nane šukar ni zaki phuv ni zako đubrivo, nego frdela pe. Kas isi kana te šunel, nek šunel!” ");
INSERT INTO rmna_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","But carinici hem prešunde grešnici čedena pe ine uzalo Isus te šunen le. ");
INSERT INTO rmna_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","A o fariseja hem o učitelja e Zakonestar lelje te gunđinen vaćerindoj: “Akava primini kora peste e grešnikonen hem hala olencar.” ");
INSERT INTO rmna_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Adalese o Isus phenđa lenđe akaja priča: ");
INSERT INTO rmna_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Te nekas tumendar isi šel bakre i jekh olendar našaldilo, so ka ćerel? Ka ačhaj e enjavardešu enjen ko polje hem ka džal te rodel e našalde bakre sa đikote na arakhi le. ");
INSERT INTO rmna_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","I kad ka arakhi le, ka radujini pe, ka čhivel le ko piče ");
INSERT INTO rmna_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","hem ka legari le čhere. Tegani ka vičini ple amalen hem ple komšijen kora peste hem ka phenel lenđe: ‘Radujinen tumen mancar! Arakhljum mle našalde bakre.’ ");
INSERT INTO rmna_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Vaćerava tumenđe, ađahar da ano nebo ka ovel po bari radost zako jekh grešniko kad pokajini pe nego li zako enjavardešu enja pravednici kolenđe na valjani pokajanje.” ");
INSERT INTO rmna_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","O Isus phenđa hem akava: “Ili te nesava đuvlja isi deš srebrna kovanice, i jekh našali, so ka ćerel? Ka tharel i svetiljka, ka šulaj o čher hem šukar ka rodel i kovanica đikote na arakhi la. ");
INSERT INTO rmna_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","I kad ka arakhi la, ka vičini ple amalinjen hem ple komšiken kora peste hem ka phenel lenđe: ‘Radujinen tumen mancar! Arakhljum i kovanica savi našalđum.’ ");
INSERT INTO rmna_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ađahar, vaćerava tumenđe, ovela radost maškaro anđelja e Devlesere zako jekh grešniko kova pokajini pe.” ");
INSERT INTO rmna_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","I o Isus phenđa: “Jekhe manuše ine duj čhave. ");
INSERT INTO rmna_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","I o tikneder čhavo phenđa ple dadese: ‘Dade, de man akana o deo te barvalipnastar so pripadini maje.’ I ađahar o dad podelinđa lenđe plo barvalipe. ");
INSERT INTO rmna_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","I palo nekobor dive o tikneder čhavo čedinđa sa so inole, dželo ki durutni phuv hem adari halja sa plo barvalipe ađahar so živinđa dilikane. ");
INSERT INTO rmna_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kad trošinđa sa o pare, ulo baro bokhalipe ani adaja phuv i tegani na inole so te hal. ");
INSERT INTO rmna_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","I dželo te ćerel buti koro jekh manuš kova živinđa adari. Adava manuš bičhalđa le pese ko polje te arakhi balen. ");
INSERT INTO rmna_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","O čhavo edobor inele bokhalo da manglja te hal adava so hana o bale, ali niko na dinđa le čak ni adava. ");
INSERT INTO rmna_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","A kad lelja te razmislini šukar, phenđa ana peste: Mle dadesere bućarnen isi da buderi hajbnase, a me akate merava bokhatar! ");
INSERT INTO rmna_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ka uštav hem ka irinav man koro mlo dad hem ka phenav lese: ‘Dade, grešinđum anglo Devel hem angla tute! ");
INSERT INTO rmna_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Na injum dostojno akana te vičinav man to čhavo. Molinava tut, le man sar jekhe bućarne te ćerav buti kora tute.’ ");
INSERT INTO rmna_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","I uštino hem lelja te džal koro plo dad. Pana sar inele dur, lesoro dad dikhlja le sar avela, pelo lese žal, prastandilo nakoro leste, zagrlinđa le hem čumudinđa le. ");
INSERT INTO rmna_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Tegani o čhavo phenđa: ‘Dade, grešinđum anglo Devel hem angla tute! Na injum dostojno akana te vičinav man to čhavo.’ ");
INSERT INTO rmna_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","A o dad phenđa ple slugenđe: ‘Sig anen o najšužo ogrtači hem urjaven le! Čhiven lese i angrustik ko naj hem o sandale ko pre! ");
INSERT INTO rmna_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Anen okole thuljarde telco te čhinen, te ha hem te veselina amen, ");
INSERT INTO rmna_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","adalese so akava mlo čhavo inele mulo, a akana oživinđa, inele našaldo, a akanai arakhlo.’ I lelje te veselinen pe. ");
INSERT INTO rmna_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","A lesoro phureder čhavo ćerela ine buti ki njiva. I ko iriba, sar avela ine paše uzalo čher, šunđa bašaliba hem čheliba. ");
INSERT INTO rmna_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Tegani vičinđa jekhe sluga te pučel le so ulo adava. ");
INSERT INTO rmna_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","O sluga phenđa lese: ‘To phral irinđa pe čhere. To dad čhinđa e thuljarde telco adalese so dikhlja le dživde hem saste.’ ");
INSERT INTO rmna_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","I o phureder čhavo holjanđa hem na manglja te đerdini ko čher. Tegani lesoro dad iklilo hem molinđa le te đerdini. ");
INSERT INTO rmna_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","A ov phenđa ple dadese: ‘Ače, sa edobor berša sar robo kandava tut hem nikad na phagljum to lafi, a nijekhvar na dinđan man ni buzore te šaj mle amalencar te veselinav man. ");
INSERT INTO rmna_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","A kad alo akava to čhavo, kova halja to barvalipe e kurvencar, tu čhinđan lese thuljarde telco.’ ");
INSERT INTO rmna_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","A lesoro dad phenđa lese: ‘Mlo čhavo, tu stalno injan mancar. I sa soi mlo – kloi. ");
INSERT INTO rmna_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ali, valjanđam ađahar te veselina amen hem te radujina amen adalese so akava, to phral, inele mulo, a akana oživinđa; inele našaldo, a akanai arakhlo!’ ” ");
INSERT INTO rmna_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","O Isus ple učenikonenđe vaćerđa: “Jekhe barvale manuše ine upravniko kole tužinde da halja lesoro barvalipe. ");
INSERT INTO rmna_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","I o barvalo vičinđa le hem phenđa lese: ‘So šunava tutar adava? Ana maje o spisko te dikhav so ćerđan mle parencar adalese so našti više te ćere buti kora mande sar upravniko!’ ");
INSERT INTO rmna_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Tegani o upravniko phenđa ana peste: ‘So ka ćerav kad mlo gospodari ka cidel man tari buti? Na injum edobor zoralo te handav, a lađava te prosinav. ");
INSERT INTO rmna_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Džanav so te ćerav te šaj o manuša priminen man pumenđe ano čhera kad ka ovav cidime tari buti.’ ");
INSERT INTO rmna_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","I vičinđa sa ple gospodaresere dužnikonen, i pučlja e prvone: ‘Kobor aveja mle gospodarese?’ ");
INSERT INTO rmna_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","A ov phenđa: ‘Šel burija uljeja.’ Tegani o upravniko phenđa lese: ‘Siđar le to lil kaj pisime kobor aveja lese hem čhiv da aveja lese pinda.’ ");
INSERT INTO rmna_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","I pučlja avere: ‘A tu kobor aveja mle gospodarese?’ A ov phenđa: ‘Šel burija điveja.’ I olese da phenđa o upravniko: ‘Le to lil hem čhiv da aveja lese oftovardeš.’ ");
INSERT INTO rmna_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","I o gospodari pohvalinđa e nepoštenone upravniko so inele džando hem so ađahar postupinđa. Akava mothoj dai o manuša akale svetosere po džande ko postupci premalo okolende kolai slična olenđe, nego o manuša e svetlosere. ");
INSERT INTO rmna_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Vaćerava tumenđe: ćeren tumenđe amalen ađahar so ka pomožinen lenđe akala phuvjakere barvalipnaja, te šaj, kad ka nakhel adava barvalipe, te oven primime ano večna čhera. ");
INSERT INTO rmna_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Kovai verno ano najtikore buća, ov ka ovel verno hem ano najbare; a kova nane pravedno ano najtikore buća, ov naka ovel pravedno hem ano najbare. ");
INSERT INTO rmna_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Te na injen verna ano akala phuvjakoro barvalipe, ko ka mukel tumenđe ano vasta o čačikano barvalipe? ");
INSERT INTO rmna_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Te na injenle verna ano averesoro barvalipe, ko ka del tumen tumaro? ");
INSERT INTO rmna_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Nijekh sluga našti kandel duje gospodaren. Ili ka mrzini jekhe, a ka volini e dujtone; ili jekhese ka ovel poslušno, a e dujtone naka podnosini. Našti kanden hem e Devle hem o barvalipe.” ");
INSERT INTO rmna_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Sa adava, so vaćerđa o Isus, šunde o fariseja kola but volinde pare, i asandile lese. ");
INSERT INTO rmna_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","A o Isus phenđa lenđe: “Tumen injen adala so ćerena tumen pravedna anglo manuša, ali o Devel džanel tumare vile. Okova soi but vredno e manušenđe, adavai gadno e Devlese.” ");
INSERT INTO rmna_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Tegani o Isus phenđa: “O Zakoni e Mojsijasoro hem o Lila e prorokonengere sikavena ine e manušen đi o aviba e Jovanesoro, a od tegani propovedini pe o Šukar lafi taro carstvo e Devlesoro hem svako nasilno đerdini ano leste. ");
INSERT INTO rmna_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","A palem, po lokhe o nebo hem i phuv te nakhen, negoli jekh slovo oto Zakoni te properel. ");
INSERT INTO rmna_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Jekh primer: Ko tumendar ačhaj pla romnja hem lela avera, ćerela preljuba. Hem ko lela romnja kola o rom muklja, isto ćerela preljuba.” ");
INSERT INTO rmna_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","O Isus phenđa: “Inele nesavo barvalo manuš kova urjela pe ine sa ano najšuže šeja hem taro dive ko dive hala ine sa najšukar habinja. ");
INSERT INTO rmna_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Angli lesiri kapija sa ano čirevija pašljola ine nesavo čororo manuš palo anav Lazar. ");
INSERT INTO rmna_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ov but manglja te čaljari pe e troškendar save perena ine taro astali e barvalesoro. Čak hem o đukle avena ine hem ližinena lesere čirevija. ");
INSERT INTO rmna_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Kad mulo o čororo, o anđelja legarde le e Avraamese ki angali. I o barvalo da mulo hem inele parume. ");
INSERT INTO rmna_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","I ano than e mulengoro, ano bare muke, o barvalo vazdinđa ple jaćha hem odural dikhlja e Avraame hem e Lazare lese ani angali. ");
INSERT INTO rmna_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Tegani vičinđa: ‘Dade Avraame, smilujin tut maje hem bičhal e Lazare te čhivel samo hari plo naj ano pani hem te avel te šudari mli čhib, adalese so but injum mučime ani akaja jag.’ ");
INSERT INTO rmna_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","A o Avraam phenđa: ‘Mlo čhavo, setin tut da priminđan to šukaripe tuće ko dživdipe, a o Lazar plo bišukaripe. A akanai e Lazarese šukar akate, a tu mučineja tut. ");
INSERT INTO rmna_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Sem adava, isi bari provalija maškar amende hem tumende i te manglja neko te nakhel akatar kora tumende ili adathar kora amende, naka šaj.’ ");
INSERT INTO rmna_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","A o barvalo phenđa: ‘Onda molinava tut, dade Avraame, bičhal e Lazare mle dadese ko čher. ");
INSERT INTO rmna_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Adari isi man pandž phralja. Nek o Lazar upozorini len, te na aven hem on ko akava than e mukengoro.’ ");
INSERT INTO rmna_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","A o Avraam phenđa: ‘Isi len o Zakoni e Mojsijasoro hem o Lila e prorokonengere. Nek šunen olen!’ ");
INSERT INTO rmna_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","A ov phenđa: ‘Nane adava dovoljno, dade Avraame! Ali te alo lenđe neko taro mule, ka obratinen pe.’ ");
INSERT INTO rmna_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","I o Avraam phenđa lese: ‘Te na šunde adava so pisinđa o Mojsije hem o proroci, naka šunen ni te neko uštino taro mule.’” ");
INSERT INTO rmna_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","O Isus phenđa ple učenikonenđe: “O iskušenja mora te aven, ali jao okolese prekala kaste avena. ");
INSERT INTO rmna_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Olese ka ovel ine po šukar ki men te ovel lese phandlo baro bar hem te ovel frdime ano more, nego te ćerel jekh akale tikorendar te perel ano greh. ");
INSERT INTO rmna_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Arakhen tumen! Te to phral grešini, ukorin le, i te pokajinđa pe, oprostin lese. ");
INSERT INTO rmna_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","I te efta puti ko dive grešini premala tute hem efta puti avela kora tute hem vaćeri će: ‘Kajinav man’, oprostin lese.” ");
INSERT INTO rmna_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","O apostolja phende e Gospodese: “De amen po bari vera!” ");
INSERT INTO rmna_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","A o Gospod phenđa: “Te isi tumen vera tikori sar zrno oti gorušica, ka phenen ine akale kaštese: ‘Ikal tut taro koreno hem sadin tut ano more!’ I ka šunel tumen ine. ");
INSERT INTO rmna_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Te phena da nekas tumendar isi sluga kova handela ili arakhi e bakren. I kad ov irini pe tari njiva, ko tumendar ka phenel lese: ‘Siđar ava akari hem beš te ha maro’? ");
INSERT INTO rmna_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Na li, umesto adava, ka phenen lese: ‘Ćer maje te hav, phand tut i kecelja hem kande man đikote hava hem pijava, a palo adava tu ka ha hem ka pije’? ");
INSERT INTO rmna_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Valjani li o gospodari te zahvalini e slugase so ćerđa adava so ine lese naredime? Na. ");
INSERT INTO rmna_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ađahar hem tumen, kad ćerena sa so naredinđa tumenđe o Devel, vaćeren: ‘Amen injam sluge kolenđe na valjani te zahvalini pe! Ćerđam samo soi amari buti!’” ");
INSERT INTO rmna_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","I sar o Isus džala ine nakori diz Jerusalim, nakhino maškari regija Samarija hem i regija Galileja. ");
INSERT INTO rmna_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","I sar đerdini ine ko nesavo gav, nakoro leste ale deš gubavci kola terdine po dur olestar ");
INSERT INTO rmna_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","hem vičinde: “Isuse, Gospodarona, smilujin tut amenđe!” ");
INSERT INTO rmna_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Kad dikhlja len o Isus, phenđa lenđe: “Džan hem mothoven tumen e sveštenikonenđe!” I sar džana ine dromeja, saslile tari guba. ");
INSERT INTO rmna_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","I jekh olendar kad dikhlja so saslilo, irinđa pe koro Isus slavindoj e Devle oto sa o glaso. ");
INSERT INTO rmna_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Pelo anglo lesere pre mujeja đi phuv, zahvalindoj lese. A ov inele Samarijanco. ");
INSERT INTO rmna_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Tegani o Isus pučlja: “Na li deš saslile? A kaj pana okola enja? ");
INSERT INTO rmna_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nijekh li olendar na aračhilo te irini pe hem te slavini e Devle, sem akava jekh kova čak nane ni Jevrejco?” ");
INSERT INTO rmna_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","I phenđa e manušese: “Ušti hem dža! Ti vera spasinđa tut!” ");
INSERT INTO rmna_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Jekh dive o fariseja pučle e Isuse kad ka avel o carstvo e Devlesoro. O Isus phenđa lenđe: “O carstvo e Devlesoro na avela e znakonencar saven ka šaj te dikhen pe. ");
INSERT INTO rmna_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Naka šaj te phenel pe: ‘Ače akatei!’ ili ‘Eče adari!’ Adalese soi o carstvo e Devlesoro maškara tumende!” ");
INSERT INTO rmna_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Tegani phenđa ple učenikonenđe: “Avela o vreme kad ka mangen te dikhen samo jekh dive e Manušesere Čhavesoro, ali naka šaj te dikhen le. ");
INSERT INTO rmna_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","O manuša ka phenen tumenđe: ‘Eče adari!’ ili ‘Ače akatei!’ Ali ma džan adari hem ma prastan palo lende! ");
INSERT INTO rmna_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Adalese so o aviba e Manušesere Čhavesoro ko lesoro dive ka ovel sar kad i munja čhinela taro jekh krajo e nebosoro, a svetlini ko dujto. ");
INSERT INTO rmna_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ali angleder adalestar valjani but te patini hem te ovel odbacime akala generacijatar. ");
INSERT INTO rmna_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Hem sar so inele ano vreme kad o Noje živinđa, ađahar ka ovel hem ano vreme kad me, o Čhavo e manušesoro, ka avav. ");
INSERT INTO rmna_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","O manuša hana ine hem pijena, lena pe hem dena pe sa đi o dive kad o Noje đerdinđa ki barka. Tegani alo o baro pani hem tasavđa sarijen. ");
INSERT INTO rmna_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ađahar da inele ano vreme kad o Lot živinđa. O manuša ani diz Sodoma hana ine hem pijena, činena hem biknena, sadinena hem vazdena čhera. ");
INSERT INTO rmna_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","A ko dive kad o Lot iklilo tari Sodoma, odupral sar bršim peli jag hem sumpor hem mudarđa sarijen. ");
INSERT INTO rmna_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ađahar ka ovel hem ko dive kad o Čhavo e manušesoro ka mothoj pe. ");
INSERT INTO rmna_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ko adava dive, ko ka ovel upro čher, a lesere stvarija ano čher, ma te huljel te lel len. Ađahar da, ko ka ovel ki njiva, ma te irini pe čhere palo ple stvarija. ");
INSERT INTO rmna_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Setinen tumen so ulo e Lotesere romnjaja! ");
INSERT INTO rmna_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ko dikhela te arakhi plo dživdipe, ka našali le, a ko našali plo dživdipe zbog mande, ka arakhi le. ");
INSERT INTO rmna_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Vaćerava tumenđe: ki adaja rat duj džene ka pašljon ani jekh soba; jekhe ka lel pe, a e dujtone ka ačhaj pe. ");
INSERT INTO rmna_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Duj đuvlja zajedno ka ćeren hajbnase; jekha ka lel pe, a e dujtona ka ačhaj pe. ");
INSERT INTO rmna_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Duj murša ka ćeren buti ki njiva; jekhe ka lel pe, a e dujtone ka ačhaj pe.” ");
INSERT INTO rmna_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","I on pučle e Isuse: “Kaj, Gospode?” A ov phenđa lenđe: “Kaj isi mulo telo, adari čedena pe o lešinarija.” ");
INSERT INTO rmna_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Tegani o Isus vaćerđa ple učenikonenđe priča da uvek valjani te molinen pe hem te na odustajinen. ");
INSERT INTO rmna_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Phenđa: “Inele nesavo sudija ani jekh diz. Na darandilo e Devlestar hem na ačhilo lese đi o manuša. ");
INSERT INTO rmna_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","A inele hem nesavi udovica ani adaja diz. Oj stalno avela ine koro leste hem molini le: ‘De man pravda anglo okova kova tužini man!’ ");
INSERT INTO rmna_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ov jekh vreme na manglja te pomožini laće. Ali kad nakhlo nesavo vreme, phenđa korkoro pese: ‘Iako na darava e Devlestar hem na ačhilo maje đi o manuša, ");
INSERT INTO rmna_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ka dav pravda akala udovicaće, adalese so stalno avela kora mande, i te na avel više te dosadini man!’” ");
INSERT INTO rmna_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Tegani o Gospod Isus phenđa: “Šunen šukar so phenđa o nepravedno sudija! ");
INSERT INTO rmna_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","O Devel li naka del pravda ple izabirimenđe kola rat hem dive molinena le? Ov li ka ačhaj len te adžićeren? ");
INSERT INTO rmna_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Vaćerava tumenđe, ka del len pravda, hem adava sigate. Ali kad me, o Čhavo e manušesoro, ka irinav, ka arakhav li vera ki phuv?” ");
INSERT INTO rmna_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Tegani o Isus vaćerđa akaja priča okolenđe kola mislinde dai pravedna, a averen dikhle sar po tikoren pumendar: ");
INSERT INTO rmna_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Duj manuša džele ko Hram te molinen pe: jekh inele farisej, a o dujto cariniko. ");
INSERT INTO rmna_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","O farisej, terdindoj, molinđa ana peste ađahar: ‘Devla, hvala će so na injum sar avera manuša: čora, nepravedna, preljubnici ili sar akava cariniko. ");
INSERT INTO rmna_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Postinava duj puti ano kurko hem dava desetak oto sa so zaradinava.’ ");
INSERT INTO rmna_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","A o cariniko, terdindoj odural, na manglja ni te dikhel nakoro nebo, nego khuvela pe ine ko gruđa oti tuga hem vaćeri: ‘Devla, smilujin tut maje, e grešnikose!’ ");
INSERT INTO rmna_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Vaćerava tumenđe: akava cariniko irinđa pe čhere opravdime anglo Devel, a na o farisej! Adalese so ko pes povazdela, ka ovel peravdo; a ko ponizini pe ka ovel povazdime.” ");
INSERT INTO rmna_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","O manuša anena ine anglo Isus pumare tikore čhavoren te čhivel ple vasta upro lende. I kad o učenici dikhle adava, braninde lenđe. ");
INSERT INTO rmna_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ali o Isus vičinđa len angla peste vaćerindoj e učenikonenđe: “Muken e čhavoren te aven kora mande hem ma braninen lenđe, adalese so esavkenđe pripadini o carstvo e Devlesoro! ");
INSERT INTO rmna_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Čače vaćerava tumenđe, ko na primini o carstvo e Devlesoro sar o čhavoro, naka đerdini ano leste.” ");
INSERT INTO rmna_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","I nesavo šerutno e jevrejengoro pučlja e Isuse: “Učitelju šukareja, so valjani te ćerav te dobinav o večno dživdipe?” ");
INSERT INTO rmna_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","A o Isus phenđa lese: “Sose vičineja man šukareja? Samoi jekh šukar – o Devel. ");
INSERT INTO rmna_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","O naredbe džane: ‘Ma ćer preljuba!’, ‘Ma mudar!’, ‘Ma čor!’, ‘Ma svedočin hovavne!’, ‘Poštujin te dade hem te daja!’” ");
INSERT INTO rmna_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Tegani o šerutno phenđa: “Sa adava ićerava pana taro tikoripe.” ");
INSERT INTO rmna_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ko adava, o Isus phenđa lese: “Pana jekh ačhola tut te ćere: biknin sa so isi tut, a o pare de e čororenđe i ka ovel tut barvalipe ano nebo. Tegani ava hem phir pala mande.” ");
INSERT INTO rmna_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","A ov kad šunđa adava, rastužisalo adalese so na manglja te biknel plo baro barvalipe. ");
INSERT INTO rmna_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","A kad dikhlja le o Isus sar rastužisalo, phenđa: “Kobori pharo e barvalenđe te đerdinen ko carstvo e Devlesoro! ");
INSERT INTO rmna_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Po lokhei e kamilaće te nakhel maškaro kan e suvjakoro nego e barvalese te đerdini ko carstvo e Devlesoro.” ");
INSERT INTO rmna_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","A o manuša kola šunde adava, phende: “Ko onda šaj te ovel spasime?” ");
INSERT INTO rmna_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","A o Isus phenđa lenđe: “So nane moguće e manušenđe, mogućei e Devlese.” ");
INSERT INTO rmna_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","O Petar phenđa: “Ače, amen sa ačhavđam te dža pala tute.” ");
INSERT INTO rmna_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","A o Isus phenđa lenđe: “Čače vaćerava tumenđe, svako kova ačhavđa plo čher, ili e romnja, ili e phraljen, ili e dade hem e daja, ili e čhaven zbog o carstvo e Devlesoro, ");
INSERT INTO rmna_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ka primini po više ko akava sveto adalestar so ačhavđa hem ka primini o večno dživdipe ko sveto savo avela.” ");
INSERT INTO rmna_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","O Isus cidinđa pe e dešu duje apostolencar ki strana hem phenđa lenđe: “Ače, džaja nakoro Jerusalim. Adari ka pherđol sa adava so o proroci pisinde ano Sveto lil mandar, e Manušesere Čhavestar. ");
INSERT INTO rmna_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ka den man ko manuša kola nane Jevreja. On ka maren muj mancar, ka vređinen man hem ka čhungaren man. ");
INSERT INTO rmna_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ka šibinen man hem ka mudaren man, ali o trito dive ka uštav taro mule.” ");
INSERT INTO rmna_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","O učenici na halile ništa adalestar so o Isus vaćerđa lenđe. O značenje adale lafengoro inele garavdo olendar, i na džande sostar o Isus vaćeri. ");
INSERT INTO rmna_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Kad o Isus alo paše uzali diz Jerihon, uzalo drom bešela ine nesavo kororo manuš hem prosini. ");
INSERT INTO rmna_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Kad o kororo manuš šunđa sar o narodo nakhela, raspučlja pe soi adava. ");
INSERT INTO rmna_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","I phende lese so o Isus o Nazarećanin nakhela. ");
INSERT INTO rmna_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Tegani o kororo vičinđa: “Isuse, Čhaveja Davidesereja, smilujin tut maje!” ");
INSERT INTO rmna_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","A o manuša kola phirde anglo Isus vičinde upro leste te traini, ali ov pana po zorale vičinđa: “Čhaveja Davidesereja, smilujin tut maje!” ");
INSERT INTO rmna_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Tegani o Isus terdino hem naredinđa te anen e korore anglo leste. I kad ande le, o Isus pučlja le: ");
INSERT INTO rmna_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“So mangeja te ćerav će?” A o kororo phenđa: “Gospode, mangava te dikhav.” ");
INSERT INTO rmna_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","I o Isus phenđa lese: “Dikh! Ti vera sasljarđa tut.” ");
INSERT INTO rmna_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","I otojekhvar o kororo šaj ine te dikhel hem lelja te džal palo Isus slavindoj e Devle. I sa o manuša kola dikhle adava zahvalinde e Devlese. ");
INSERT INTO rmna_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","O Isus đerdinđa ani diz Jerihon. I sar nakhela ine maškari diz, ");
INSERT INTO rmna_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","alo nesavo manuš palo anav Zakej te dikhel le. O Zakej inele jekh taro šerutne e carinikonengere ani diz hem inele barvalo. ");
INSERT INTO rmna_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ov pokušinđa te dikhel koi adava o Isus, ali našti ine taro narodo adalese so inele pretičkoro. ");
INSERT INTO rmna_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Adalese prastandilo po anglal hem uklinđa upro e smokvakoro kaš te šaj dikhel e Isuse adalese so džanđa da valjani te nakhel adathar. ");
INSERT INTO rmna_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","A kad o Isus reslo adari, dikhlja upre hem phenđa lese: “Zakej, hulji sigate! Avdive valjani te ovav ano to čher.” ");
INSERT INTO rmna_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","I o Zakej huljilo sigate hem radosno priminđa le pese ano čher. ");
INSERT INTO rmna_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Sa o manuša kola dikhle adava, lelje te gunđinen, vaćerindoj: “Dželo koro grešniko te bešel.” ");
INSERT INTO rmna_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","A o Zakej terdino hem phenđa e Gospodese e Isusese: “Ače, Gospode, ekvaš oto barvalipe mlo ka dav e čororenđe, a te nekas hovavđum, ka irinav lese štar puti više.” ");
INSERT INTO rmna_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","A ko adava, o Isus phenđa lese: “Avdive alo o spasenje ano akava čher, adalese soi hem akava manuš potomko e Avraamesoro. ");
INSERT INTO rmna_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Adalese so, me, o Čhavo e manušesoro, aljum te rodav hem te spasinav e našalden!” ");
INSERT INTO rmna_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","I sar but manuša šunena ine e Isuse, ov vaćerđa lenđe hem akaja priča, adalese so inele paše uzalo Jerusalim, a on mislinde da o carstvo e Devlesoro otojekhvar ka mothoj pe. ");
INSERT INTO rmna_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Phenđa: “Inele jekh ugledno manuš kova spremisalo te džal ki durutni phuv te ovel čhivdo zako caro, a palo adava te irini pe čhere. ");
INSERT INTO rmna_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","I vičinđa ple deše slugen, dinđa len po ekvaš kilo srebro hem phenđa lenđe: ‘Zaradinen maje ađahar so ka ćeren buti adaleja đikote na avava.’ I dželo ko drom. ");
INSERT INTO rmna_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","A o manuša oti lesiri phuv mrzinde le, i bičhalde pumare manušen adari kaj ov dželo te phenen: ‘Na mangaja akale te ovel amaro caro.’ ");
INSERT INTO rmna_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Kad o ugledno manuš irinđa pe sar caro, naredinđa te vičinen koro leste okole slugen, kolenđe dinđa pare, te dikhel kobor zaradinde lese. ");
INSERT INTO rmna_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","O prvo sluga alo vaćerindoj: ‘Gospodarona, oto adava so dinđan man, ćerđum deš puti više.’ ");
INSERT INTO rmna_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","I ov phenđa lese: ‘But šukar. Tu injan šukar sluga! Adalese so injanle maje verno ko najhari, ka dav tut te vladine upro deš dizja!’ ");
INSERT INTO rmna_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","O dujto sluga alo vaćerindoj: ‘Gospodarona, oto adava so dinđan man, ćerđum pandž puti više.’ ");
INSERT INTO rmna_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","I lese phenđa: ‘Ka dav tut te vladine upro pandž dizja!’ ");
INSERT INTO rmna_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","O trito sluga alo vaćerindoj: ‘Gospodarona, ače to srebro savo dinđan man. Garavđum le ano jekh kotor e šejengoro. ");
INSERT INTO rmna_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ćerđum ađahar adalese so darandiljum tutar so injan strogo manuš. Leja okova so nane klo hem čedeja kaj na sejinđan.’ ");
INSERT INTO rmna_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","A ov phenđa lese: ‘Tu injan bišukar sluga! Palo te lafija ka sudinav tut. Te džanđan so injum strogo manuš, da lava okova so nane mlo hem čedava so na sejinđum, ");
INSERT INTO rmna_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","sose onda na dinđan mle pare ki kamata? Đi akana ka ovel man ine više pare save ka lav ine avindoj čhere.’ ");
INSERT INTO rmna_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Tegani phenđa okolenđe kola terdine uzalo leste: ‘Len akale slugastar o srebro hem den le okolese kas isi deš puti edobor!’ ");
INSERT INTO rmna_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","A on phende lese: ‘Ali, gospodarona, ole već isi pandž kilja srebro.’ ");
INSERT INTO rmna_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ov phenđa: ‘Dikhena da svakone kas isi, ka del pe lese pana, a okole kas nane ka lel pe lestar hem adava so isi le. ");
INSERT INTO rmna_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","A okole mle neprijateljen, so na mangle te ovav lengoro caro, anen akari hem čhinen len angla mande!’” ");
INSERT INTO rmna_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","I kad vaćerđa lenđe adava, o Isus nastavinđa plo drom nakoro Jerusalim. ");
INSERT INTO rmna_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Kad alo paše uzalo gava Vitfaga hem Vitanija, uzali gora vičimi e Maslinakiri, bičhalđa duje učenikonen ");
INSERT INTO rmna_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","vaćerindoj: “Džan ko adava gav savoi angla tumende. I kad ka đerdinen, ka arakhen phandle terne here upro saveste pana nijekh manuš na beštino. Phraven le hem anen le akari. ");
INSERT INTO rmna_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Te neko pučlja tumen: ‘Sose phravena le?’, phenen lese: ‘E Gospodese valjani.’” ");
INSERT INTO rmna_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","On džele hem arakhle ađahar sar so phenđa lenđe o Isus. ");
INSERT INTO rmna_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","I sar phravena ine e terne here, o manuša, kasoro inele o terno her, pučle len: “Sose phravena e terne here?” ");
INSERT INTO rmna_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","A on phende: “E Gospodese valjani.” ");
INSERT INTO rmna_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","I ande e here anglo Isus. Čhivde pumare fostanja upro her hem bešljarde e Isuse upro leste. ");
INSERT INTO rmna_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","I sar džala ine anglal bešindoj upro her, o manuša buljarena ine pumare fostanja upro drom anglo leste. ");
INSERT INTO rmna_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","A kad alo paše uzalo than kotar huljela pe ine tari e Maslinakiri gora, sa o učenici so inele adari lelje radosno hem oto sa o glaso te slavinen e Devle zako sa o čudesija save dikhle, ");
INSERT INTO rmna_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","vaćerindoj: “Blagoslovime o Caro kova avela ano anav e Gospodesoro! Nek ovel mir ano nebo hem slava e Devlese ko učipe!” ");
INSERT INTO rmna_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Tegani nesave fariseja, kola inele maškaro lende, phende e Isusese: “Učitelju, phen te učenikonenđe te na vaćeren adava.” ");
INSERT INTO rmna_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","A o Isus phenđa lenđe: “Phenava tumenđe, te trainde on, o bara ka vičinen.” ");
INSERT INTO rmna_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","I kad o Isus alo paše uzalo Jerusalim, dikhindoj i diz, runđa laće ");
INSERT INTO rmna_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","vaćerindoj: “Oh, te džane ine avdive hem tu so anela će mir! Ali adavai akana garavdo te jaćhendar. ");
INSERT INTO rmna_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ka aven o dive kad te neprijatelja ka čhiven će barikade, ka opkolinen tut hem taro sa o strane ka pritiskinen tut. ");
INSERT INTO rmna_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ka uništinen hem tut hem te dizutnen. Naka ačhaven ni bar upro bar adalese so na pendžarđan o vreme kad o Devel alo te spasini tut.” ");
INSERT INTO rmna_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kad o Isus alo ano Jerusalim, đerdinđa ano boro e hramesoro hem lelja te ispudini adathar okolen so biknena. ");
INSERT INTO rmna_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Phenđa lenđe: “Pisimei ano Sveto lil: ‘O čher mlo ka ovel čher zaki molitva’, a tumen ćerđen olestar ‘than kote čedena pe o čora!’” ");
INSERT INTO rmna_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","I taro dive ko dive, o Isus sikavđa e manušen ano boro e hramesoro. A o šerutne sveštenici hem o učitelja e Zakonestar zajedno e jevrejengere starešinencar rodena ine sar te ćeren o Isus te ovel mudardo, ");
INSERT INTO rmna_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ali na arakhle sar adava te ćeren, adalese so sa o manuša pažljivo šunena ine lesoro sikaviba. ");
INSERT INTO rmna_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","I jekhvar sar o Isus sikaj ine e manušen ano boro e Hramesoro hem vaćeri lenđe ine o Šukar lafi, ale uzalo leste o šerutne sveštenici, o učitelja e Zakonestar hem o starešine ");
INSERT INTO rmna_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","hem pučle le: “Vaćer amenđe kotar tuće autoritet te ćere akava? Ko dinđa tut pravo?” ");
INSERT INTO rmna_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","O Isus phenđa lenđe: “Hem me tumen ka pučav nešto. Vaćeren maje: ");
INSERT INTO rmna_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ko dinđa pravo e Jovane te krstini e manušen, o Devel kovai ano nebo ili o manuša?” ");
INSERT INTO rmna_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","A on raspravinde pe maškara pumende vaćerindoj: “Te phenđam ‘o Devel kovai ano nebo’, ov ka pučel amen sose onda na verujinđam lese. ");
INSERT INTO rmna_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","A te phenđam ‘o manuša’, sa o manuša ka mudaren amen barencar, adalese soi uverime da o Jovan inele proroko.” ");
INSERT INTO rmna_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Adalese phende e Isusese: “Na džanaja ko dinđa pravo e Jovane.” ");
INSERT INTO rmna_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","I o Isus phenđa lenđe: “Ni me onda naka phenav tumenđe kotar maje pravo akava te ćerav.” ");
INSERT INTO rmna_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Tegani o Isus lelja te vaćeri e narodose akaja priča: “Nesavo manuš sadinđa vinograd, iznajminđa le nesave vinogradarenđe hem dželo ko drom ko but vreme. ");
INSERT INTO rmna_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","I kad alo o vreme te čeden pe o drakha, bičhalđa e sluga koro vinogradarija te šaj den le oto bijandipe e drakhakoro. Ali o vinogradarija marde le hem bičhalde le palal čuče vastencar. ");
INSERT INTO rmna_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","I o gospodari bičhalđa avere sluga. Ali on hem ole marde, lađarde le hem bičhalde le palal čuče vastencar. ");
INSERT INTO rmna_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","I palem o gospodari bičhalđa koro lende hem e tritone sluga. A on ćerde le ko rata hem frdinde le avri taro vinograd. ");
INSERT INTO rmna_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Tegani o gospodari oto vinograd phenđa: ‘So te ćerav? Ka bičhalav lenđe mle volime čhave. Šaj ole ka poštujinen.’ ");
INSERT INTO rmna_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ali kad o vinogradarija dikhle le, vaćerde maškara pumende: ‘Akavai o nasledniko. Hajde te mudara le hem amenđe te ačhol o nasledstvo.’ ");
INSERT INTO rmna_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","I frdinde le avri taro vinograd hem mudarde le. So mislinena, so ka ćerel o gospodari adale vinogradarenđe? ");
INSERT INTO rmna_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ka avel hem ka mudari len, a o vinograd ka iznajmini averenđe.” I okola kola šunde adaja priča, phende: “Te na del o Devel adava te ovel!” ");
INSERT INTO rmna_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","A o Isus dikhlja ano lende hem phenđa: “A so onda značini adava soi pisime ano Sveto lil: ‘O bar savo odbacinde o zidarija ulo najbitno bar e čheresoro’? ");
INSERT INTO rmna_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Svako kova perela upro adava bar, ka phagel pe, a te pelo adava bar upra nekaste, ka zgnječini le.” ");
INSERT INTO rmna_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","A o učitelja e Zakonestar hem o šerutne sveštenici mangle tegani te dolen e Isuse, adalese so džande da akaja priča vaćeri olendar, ali darandile e narodostar. ");
INSERT INTO rmna_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","A o učitelja e Zakonestar hem o šerutne sveštenici posmatrinena ine e Isuse. Bičhalde koro leste špijunen, kola ćerde pe dai iskrena, sar te dolen le ko bišukar lafi i te šaj preden le ko upravniko e rimesoro te osudini le. ");
INSERT INTO rmna_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","I o špijunja pučle e Isuse: “Učitelju, džanaja da vaćereja hem sikaveja šukar hem na dikheja kovai kova, nego čačimase sikaveja oto drom e Devlesoro. ");
INSERT INTO rmna_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Valjani li amen o Jevreja te platina o porez e rimesere carose ili na?” ");
INSERT INTO rmna_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","A o Isus džanđa so on mangle te prevarinen le i phenđa lenđe: ");
INSERT INTO rmna_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Mothoven maje i kovanica savaja platinena o porez. Kasiri slika hem kasoro anav isi la?” A on phende: “E carosoro.” ");
INSERT INTO rmna_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Tegani o Isus phenđa lenđe: “Onda den soi e carosoro e carose, a soi e Devlesoro e Devlese.” ");
INSERT INTO rmna_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","I ađahar o špijunja našti ine te arakhen ništa bišukar ano okova so o Isus vaćerđa i trainde adalese so inele zadivime lesere vaćeribnaja. ");
INSERT INTO rmna_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","I ale koro Isus nesave sadukeja kola vaćerena da nane uštiba taro mule, i pučle e Isuse: ");
INSERT INTO rmna_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Učitelju, o Mojsije pisinđa amenđe so te ćerel o manuš te mulo lesoro phral kova pala peste ačhavđa romnja bizo čhave. Adava manuš valjani te lel ple phralesere romnja te šaj oj te bijani čhave kova ka ovel nasledniko e mulesoro. ");
INSERT INTO rmna_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ađahar, inele efta phralja. O prvo lelja romnja i mulo, a na ačhavđa pala peste čhaven. ");
INSERT INTO rmna_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","O dujto phral lelja ple phralesere romnja, ali hem ov mulo. ");
INSERT INTO rmna_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Tegani o trito phral lelja adala romnja i mulo hem ađahar sa o efta phralja. I nijekh olendar na ačhavđa čhaven pala peste. ");
INSERT INTO rmna_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ko kraj muli hem i romni. ");
INSERT INTO rmna_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kasiri onda romni oj ka ovel kad ka uštel pe taro mule, a inele dindi ko sa o efta phralja?” ");
INSERT INTO rmna_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","O Isus phenđa lenđe: “O manuša ko akava sveto lena pe hem dena pe. ");
INSERT INTO rmna_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","A okola kolen o Devel smatrini dai dostojna te oven vazdime taro mule hem te živinen ko sveto savo avela, ni ka len pe ni ka den pe. ");
INSERT INTO rmna_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Adalese so našti više ni te meren: ka oven sar o anđelja. Oni čhave e Devlesere, adalese so o Devel ka vazdel len taro mule. ");
INSERT INTO rmna_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","A da o mule uštena, mothovđa hem o Mojsije ano Sveto lil kote pisini oto grmo savo ine thabljola. Adathe ov zako Gospod phenela dai ‘Devel e Avraamesoro, e Isaakesoro hem e Jakovesoro’ iako on tegani inele mule. ");
INSERT INTO rmna_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","A o Devel nane Devel e mulengoro, nego Devel e dživdengoro. Adalese soi on e Devlese pana dživde.” ");
INSERT INTO rmna_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Nesave učitelja e Zakonestar phende e Isusese: “Učitelju, šukar vaćerđan!” ");
INSERT INTO rmna_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","I nijekh više na tromandilo te pučel le nešto. ");
INSERT INTO rmna_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Tegani o Isus pučlja okolen so šunena le ine: “Sar šaj te vaćeri pe dai o Hrist samo e Davidesoro čhavo? ");
INSERT INTO rmna_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","A korkoro o David phenela ano lil oto Psalmija: ‘O Gospod phenđa mle Gospodese: Beš ko počasno than, oti mli desno strana, ");
INSERT INTO rmna_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","đikote na pašljarava te neprijateljen talo te pre!’ ");
INSERT INTO rmna_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Te o David vičini le ‘Gospode’, sar onda o Hrist šaj te ovel samo lesoro čhavo?” ");
INSERT INTO rmna_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Tegani anglo sa o manuša, o Isus phenđa ple učenikonenđe: ");
INSERT INTO rmna_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Arakhen tumen e učiteljendar e Zakonestar! On volinena te phiren urjavde ano bare fostanja hem o manuša, ano baro poštujiba, te pozdravinen len ko trgija. Volinena te bešen ko anglune thana ano sinagoge hem ko najšukar thana ko gozbe. ");
INSERT INTO rmna_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Hana o imanje e udovicengoro hem ćerena pe dai pobožna ađahar so molinena bare molitve. On ka oven po zorale kaznime nego avera manuša.” ");
INSERT INTO rmna_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Na nakhlo but palo adava, o Isus vazdinđa plo šero hem dikhlja sar o barvale manuša čhivena pumare pare ani e hramesiri kutija zako čediba. ");
INSERT INTO rmna_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ađahar dikhlja hem jekha čorora udovica sar čhivela samo duj najtikore kovanice. ");
INSERT INTO rmna_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Tegani phenđa: “Čače vaćerava tumenđe, akaja čorori udovica čhivđa više sarijendar. ");
INSERT INTO rmna_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Adalese so sare akala dinde oto buderi so isi len, a oj, kojai čorori, dinđa sa so inola zako živiba.” ");
INSERT INTO rmna_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","I sar nesave učenici vaćerena ine adalestar sari o Hram šukar ukrasime šuže bare barencar hem e daronencar savei posvetime e Devlese, o Isus phenđa: ");
INSERT INTO rmna_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ka avel o dive kad oto sa akava so dikhena naka ačhol ni bar upro bar. Svako ka ovel peravdo.” ");
INSERT INTO rmna_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","I on pučle e Isuse: “Učitelju, kad adava ka ovel? Savo znako ka mothoj amenđe da ka ovel adava?” ");
INSERT INTO rmna_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","A o Isus phenđa: “Dikhen te na oven hovavde. Adalese so but džene ka aven ano mlo anav vaćerindoj: ‘Me injum o Hrist’ hem: ‘Alo paše o kraj akale vremesoro.’ Ma džan palo lende! ");
INSERT INTO rmna_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","A kad šunena zako mariba hem zako pobune, ma te daran. Adalese so prvo adava valjani te ovel, ali nane odmah o kraj.” ");
INSERT INTO rmna_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Tegani phenđa lenđe: “Jekh nacija ka uštel upri aver nacija hem jekh carstvo upro aver carstvo. ");
INSERT INTO rmna_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ko but thana ka oven bare zemljotresija, bokhalipe hem zaraze. Ka mothoven pe čudesna znakija ko nebo savendar o manuša ka daran. ");
INSERT INTO rmna_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ali angleder so sa adava te ovel, ka dolen tumen hem ka progoninen tumen, ka legaren tumen ko sudo ano sinagoge hem ko phandlipe, ka legaren tumen anglo carija hem anglo vladarija, hem sa adava zbog mande. ");
INSERT INTO rmna_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Adava ka ovel tumenđe te šaj svedočinen lenđe mandar. ");
INSERT INTO rmna_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Adalese zapamtinen: ma pripreminen tumen angleder save lafencar ka braninen tumen. ");
INSERT INTO rmna_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Adalese so me ka dav tumen mudrost hem lafija ko save nijekh tumaro protivniko naka šaj te irini lafi. ");
INSERT INTO rmna_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","A ka izdajinen tumen čak hem tumare dada hem o daja, tumare phralja, tumari familija hem tumare amala; hem nesaven tumendar ka mudaren. ");
INSERT INTO rmna_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","I sare ka mrzinen tumen zbog mande, ");
INSERT INTO rmna_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ali nijekh bal tumare šerestar naka perel. ");
INSERT INTO rmna_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Adaleja so ka ačhoven verna, ka dobinen o večno dživdipe.” ");
INSERT INTO rmna_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","O Isus phenđa hem akava: “I kad ka dikhen sar o Jerusalim opkolime e vojskendar, te džanen da alo lesoro vreme te ovel uništime. ");
INSERT INTO rmna_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Tegani okola kola živinena ani e judejakiri regija nek našen ko gore. Okola kola živinena ano Jerusalim nek ikljon avri, a kolai ko polje, te na đerdinen ani diz. ");
INSERT INTO rmna_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Adalese so adala ka oven o dive oti e Devlesiri kazna, te pherđol sa soi pisime ano Sveto lil. ");
INSERT INTO rmna_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Jao e khamnjenđe hem okolenđe kola dena čuči ko adala dive! Adalese so bari nevolja ka ovel upri phuv hem e Devlesiri holi ka perel upro akava narodo. ");
INSERT INTO rmna_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Nesave olendar ka oven mudarde mačeja, a avera ka oven legarde ko ropstvo maškaro sa o nacije. O Jerusalim ka ovel gazime e manušendar oto avera nacije sa đikote na nakhela lengoro vreme.” ");
INSERT INTO rmna_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","O Isus phenđa hem akava: “I ka oven čudna znakija ko kham, ko masek hem ko čerenja, a ki phuv o nacije naka džanen so te ćeren oti dar zbog adava so o more ka ćerel glasna zvukija hem bare talasija. ");
INSERT INTO rmna_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","O manuša ka meren oti dar hem oto adžićeriba o bišukaripe savo avela ki phuv, adalese so o zoralipa e nebosere ka oven potresime. ");
INSERT INTO rmna_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Tegani sare ka dikhen man, e Čhave e manušesere, sar avava upro oblako ano zoralipe hem ani bari slava. ");
INSERT INTO rmna_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","A kad sa adava ka počini te ovel, terđoven ko pre bizi dar hem vazden tumare šere adalese soi paše tumaro spasenje.” ");
INSERT INTO rmna_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Tegani o Isus phenđa lenđe akaja priča: “Dikhen i smokva ili bilo savo aver kaš. ");
INSERT INTO rmna_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kad dikhena da ikljona listija upro leste, korkore džanen dai paše o linaj. ");
INSERT INTO rmna_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ađahar hem tumen kad dikhena da ovela sa adava, te džanen dai o carstvo e Devlesoro paše. ");
INSERT INTO rmna_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Čače vaćerava tumenđe, akaja generacija naka nakhel đikote sa adava na ovela. ");
INSERT INTO rmna_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","O nebo hem i phuv ka nakhen, ali mle lafija nikad naka nakhen.” ");
INSERT INTO rmna_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","I o Isus phenđa lenđe: “Arakhen tumen te na oven zaokupirime pibnaja, mačojbnaja hem akale dživdipnasere brigencar i te resel tumen otojekhvar adava dive. ");
INSERT INTO rmna_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Adalese so adava dive ka avel sar zamka upro sa o manuša ki phuv. ");
INSERT INTO rmna_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Adalese oven džangale hem stalno molinen te šaj nakhaven sa adava so valjani te ovel hem te terđoven anglo Čhavo e manušesoro.” ");
INSERT INTO rmna_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Diveja o Isus sikaj ine ano Hram, a raćaja ikljola ine tari diz hem džala te nakhaj i rat ki gora vičimi e Maslinakiri. ");
INSERT INTO rmna_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","I sa o manuša rano sabaleja džana ine ko Hram te šunen le. ");
INSERT INTO rmna_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Avela ine paše o Prazniko e bikvascone marengoro, savo vičini pe Pasha. ");
INSERT INTO rmna_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","O šerutne sveštenici hem o učitelja e Zakonestar rodena ine sar te ćeren o Isus te ovel mudardo, ali darandile e narodostar. ");
INSERT INTO rmna_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tegani o Sotoni đerdinđa ano Juda vičime Iskariot kova inele jekh oto dešu duj apostolja e Isusesere. ");
INSERT INTO rmna_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ov dželo koro šerutne sveštenici hem koro narednici e hramesere stražakere hem dogovorinđa pe olencar sar te predel lenđe e Isuse. ");
INSERT INTO rmna_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","On ule radosna hem phende e Judase da ka den le pare. ");
INSERT INTO rmna_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","I ov pristaninđa. I ađahar lelja te rodel šukar prilika te izdajini e Isuse kad naka ovel narodo uzalo leste. ");
INSERT INTO rmna_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Kad alo o prvo dive oto Prazniko e bikvascone marengoro, ko savo valjanđa te žrtvujini pe bakrore zaki Pasha, ");
INSERT INTO rmna_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","o Isus phenđa e Petrese hem e Jovanese: “Džan hem ćeren amenđe te ha e pashakoro hajba.” ");
INSERT INTO rmna_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","A on phende lese: “Kaj mangeja te ćera le?” ");
INSERT INTO rmna_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ov phenđa lenđe: “Šunen. So ka đerdinen ki diz, ka resel tumen jekh manuš kova akhari pani ano khoro. Džan palo leste. Ko čher ko savo ka đerdini ");
INSERT INTO rmna_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","roden e domaćine hem vaćeren lese: ‘O učitelj pučela ki savi soba šaj te hal e pashakoro hajba ple učenikonencar?’ ");
INSERT INTO rmna_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","I ov ka mothoj tumenđe i bari upruni soba savi već pripremime. Adari ćeren amenđe zako hajba.” ");
INSERT INTO rmna_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","I on džele hem arakhle sa ađahar sar so phenđa lenđe o Isus i adari ćerde zako hajba e pashakoro. ");
INSERT INTO rmna_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","I kad alo o vreme, o Isus čhivđa pe uzalo astali ple apostolencar. ");
INSERT INTO rmna_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","I phenđa lenđe: “Edobor mangljum te hav akaja Pasha tumencar angleder so ka patinav. ");
INSERT INTO rmna_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Adalese so, vaćerava tumenđe, naka hav la više đikote lakoro čačikano značenje na pherđola ano carstvo e Devlesoro.” ");
INSERT INTO rmna_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Tegani lelja i čaša e moljaja, zahvalinđa e Devlese hem phenđa e apostolenđe: “Len akaja mol hem podelinen la maškara tumende. ");
INSERT INTO rmna_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Adalese so, vaćerava tumenđe, naka pijav više mol đikote o carstvo e Devlesoro na avela.” ");
INSERT INTO rmna_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","I lelja o maro, zahvalinđa e Devlese, phaglja le hem dinđa le e apostolenđe vaćerindoj: “Akavai mlo telo savo dela pe zako tumenđe. Ćeren akava te setinen tumen mandar.” ");
INSERT INTO rmna_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ađahar lelja hem i čaša e moljaja pali večera hem phenđa: “Akaja čaša e moljaja nevoi savez ano mlo rat savo čhorela pe tumenđe. ");
INSERT INTO rmna_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ali ače, o manuš kova ka izdajini man mancari uzalo astali. ");
INSERT INTO rmna_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Adalese so, me, o Čhavo e manušesoro, valjani te merav sar soi odredime, ali jao okole manušese kova ka izdajini man!” ");
INSERT INTO rmna_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","I o apostolja lelje te pučen pe maškara pumende kova olendar šaj te ovel adava so ka ćerel ađahar nešto. ");
INSERT INTO rmna_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","I o učenici lelje te raspravinen pe kovai olendar najbaro. ");
INSERT INTO rmna_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","A o Isus phenđa lenđe: “Avere nacijengere carija vladinena upro lende hem o vladarija lengere pumen vičinena ‘manuša kola ćerena šukaripe’. ");
INSERT INTO rmna_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ali tumen ma oven esavke! Nego, o najbaro maškar tumende nek ovel sar najtikoro, a o vođa nek ovel sar sluga. ");
INSERT INTO rmna_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","A kovai po baro? Okova kovai uzalo astali ili okova kova kandela le? Na li okova kovai uzalo astali? A me maškara tumende injum sar okova kova kandela. ");
INSERT INTO rmna_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Tumen injen adala kola ačhile mancar ano mle iskušenja. ");
INSERT INTO rmna_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","I me dava tumen te vladinen ano carstvo, sar so mlo Dad dinđa man: ");
INSERT INTO rmna_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","te han hem te pijen maje uzalo astali ano carstvo mlo, hem te bešen ko tronja te sudinen upro dešu duj plemija e Izraelesere.” ");
INSERT INTO rmna_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","O Isus phenđa: “Simone, Simone, ače o Sotoni rodinđa e Devlestar te iskušini tumen sar kad neko čhorela o điv maškari sita. ");
INSERT INTO rmna_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ali me molinđum tuće te na našale ti vera. Adalese, kad palem ka irine tut mande, zorjar te phraljen.” ");
INSERT INTO rmna_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","A ov phenđa lese: “Gospode, injum spremno te džav tuja hem ko phandlipe hem ko meriba.” ");
INSERT INTO rmna_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","A o Isus phenđa: “Vaćerava će, Petre, o bašno naka đilabi avdive đikote trin puti naka hovave da na pendžareja man.” ");
INSERT INTO rmna_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","I phenđa e apostolenđe: “Kad bičhalđum tumen ko drom bizo kese e parencar, bizo torbe hem bizi buderi obuća, na li falinđa tumenđe nešto?” A on phende: “Ništa.” ");
INSERT INTO rmna_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Tegani o Isus phenđa lenđe: “Ali akana kas isi kesa e parencar, nek lel la! Ađahar hem i torba! A kas nane mači, nek biknel plo ogrtači hem nek činelfse jekh. ");
INSERT INTO rmna_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Adalese so, vaćerava tumenđe, valjani te pherđol adava soi mandar pisime ano Sveto lil: ‘Dikhle le sar jekhe zločinco.’ Čače, pherđola sa soi pisime mandar.” ");
INSERT INTO rmna_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","A on phende: “Gospode, ače isi amen duj mačija!” A ov phenđa: “Šukari!” ");
INSERT INTO rmna_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","I iklindoj adathar, palo plo adeti, dželo ki e Maslinakiri gora. Oleja džele hem lesere učenici. ");
INSERT INTO rmna_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","I kad resle adari, phenđa lenđe: “Molinen tumen te na peren ano iskušenje!” ");
INSERT INTO rmna_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","I cidinđa pe olendar, edobor kobor šaj te frdel pe o bar, pelo ko kočija hem molinđa pe e Devlese, ");
INSERT INTO rmna_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","vaćerindoj: “Dade! Te mangeja, cide akaja čaša e patnjaja mandar. Ali, nek ovel pali ti volja, a na pali mli.” ");
INSERT INTO rmna_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tegani o anđeo mothovđa pe lese taro nebo hem hrabrinđa le. ");
INSERT INTO rmna_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","A kad inele ani po bari patnja, po zorale molinđa pe. Lesoro znoj ulo sar kapke oto rat save perena ine upri phuv. ");
INSERT INTO rmna_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","I pali molitva uštino, alo đi ple učenici hem arakhlja len sar sovena adalese so inele umorna oto tugujiba. ");
INSERT INTO rmna_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Tegani pučlja len: “Sose sovena? Ušten hem molinen tumen te na peren ano iskušenje!” ");
INSERT INTO rmna_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Sar pana o Isus vaćeri ine adava, ale nakoro leste but manuša kolen anđa o Juda kova inele jekh oto dešu duj apostolja. Ov alo koro Isus te čumudini le ki čham. ");
INSERT INTO rmna_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","A o Isus pučlja le: “Judo, čumudipnaja li izdajineja e Čhave e manušesere?” ");
INSERT INTO rmna_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kad o učenici kola inele adari dikhle da o Isus ka ovel dolime, pučle le: “Gospode, te napadina len li mačencar?” ");
INSERT INTO rmna_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","I jekh olendar khuvđa mačeja e prvosveštenikosere sluga hem čhinđa lesoro desno kan. ");
INSERT INTO rmna_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","A o Isus phenđa ple učenikonenđe: “Ačhaven tumen adalestar!” I čhivđa plo vas upro lesoro kan hem sasljarđa le. ");
INSERT INTO rmna_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Tegani phenđa okolenđe so ale te dolen le, e šerutne sveštenikonenđe, e narednikonenđe e hramesere stražakere hem e starešinenđe: “Mačencar hem kaštencar aljen pala mande sar palo pobunjeniko. ");
INSERT INTO rmna_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Divencar injumle tumencar ano Hram, i na dolinđen man. Ali akavai tumaro vreme hem o zoralipe e tominakoro vladini.” ");
INSERT INTO rmna_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","I dolinde e Isuse hem adathar legarde le ko čher e prvosveštenikosoro. A o Petar odural džala ine palo lende. ");
INSERT INTO rmna_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Kad tharde jag ko maškar e borosoro hem beštine uzalo late, hem o Petar beštino olencar. ");
INSERT INTO rmna_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","I nesavi sluškinja dikhlja le sar bešela uzali jag, i dikhlja po šukar ano leste hem phenđa: “I akava inele oleja!” ");
INSERT INTO rmna_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","A o Petar hovavđa vaćerindoj: “Đuvlije, na pendžarava le!” ");
INSERT INTO rmna_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Na nakhlo but palo adava, dikhlja le nesavo aver manuš hem phenđa: “I tu injan jekh olendar!” A o Petar phenđa: “Manušeja, na injum!” ");
INSERT INTO rmna_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","I kad nakhlo đi sar jekh sati, aver nesavo uporno tvrdinđa: “Čače akava inele oleja, adalese soi hem ov Galilejco!” ");
INSERT INTO rmna_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","A o Petar phenđa: “Manušeja, na džanav sostar vaćereja!” I odmah, sar pana vaćeri ine, o bašno đilabđa. ");
INSERT INTO rmna_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Tegani o Gospod Isus irinđa pe hem dikhlja ano Petar, a o Petar setinđa pe lesere lafendar: “Vaćerava će, Petre, angleder so o bašno avdive ka đilabi, trin puti ka hovave da na pendžareja man.” ");
INSERT INTO rmna_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","I o Petar iklilo taro boro hem zorale runđa. ");
INSERT INTO rmna_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","O čuvarija lelje te maren muj e Isuseja hem te maren le. ");
INSERT INTO rmna_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Učharde lesere jaćha hem phende lese: “Prorokujin ko khuvđa tut!” ");
INSERT INTO rmna_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","I bute avere lafencar vređinena ine e Isuse. ");
INSERT INTO rmna_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kad dislilo, čedinde pe o starešine e jevrejengere, o šerutne sveštenici hem o učitelja e Zakonestar, ande e Isuse pumenđe ko sabor, ko Sinedrion, ");
INSERT INTO rmna_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","hem phende lese: “Te injan tu o Hrist, phen amenđe!” A ov phenđa lenđe: “Te phenđum tumenđe, naka verujinen; ");
INSERT INTO rmna_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","a te pučljum tumen, naka odgovorinen. ");
INSERT INTO rmna_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ali od akana me, o Čhavo e manušesoro, ka bešav ko počasno than, oti desno strana oto zoralipe e Devlesoro.” ");
INSERT INTO rmna_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","A on sare pučle e Isuse: “Znači tu injan o Čhavo e Devlesoro?” A ov phenđa lenđe: “Ađahari sar so phenena: Me injum.” ");
INSERT INTO rmna_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Tegani on phende: “Na valjani amenđe više avera svedoci. Sare amen šunđam da korkoro pes osudinđa!” ");
INSERT INTO rmna_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tegani sare kola inele ko sabor uštine hem legarde e Isuse koro Pilat, koro upravniko e rimesoro, ");
INSERT INTO rmna_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","hem lelje te vaćeren protiv oleste: “Akale manuše arakhljam sar zavodini amare narodo hem vaćeri lenđe te na platinen o porez e carose, a pese vaćeri dai o Hrist, o caro.” ");
INSERT INTO rmna_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Tegani o Pilat pučlja e Isuse: “Tu li injan o caro e Jevrejengoro?” A o Isus phenđa: “Ađahari sar so pheneja.” ");
INSERT INTO rmna_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Tegani o Pilat phenđa e šerutne sveštenikonenđe hem e narodose: “Na arakhava nisavi krivica upro akava manuš!” ");
INSERT INTO rmna_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ali on na ačhavde te vičinen: “Ple sikavibnaja vazdela pobuna maškaro manuša ki sa i phuv e Jevrejengiri. Lelja te ćerel adava ani regija Galileja hem alo čak đi akate ani diz Jerusalim!” ");
INSERT INTO rmna_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","A kad o Pilat šunđa adava, pučlja len nane li o Isus Galilejco. ");
INSERT INTO rmna_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","I kad phende lese dai o Isus Galilejco, o Pilat bičhalđa le koro Irod, kova vladinđa ani Galileja. A baš adala dive o Irod inele ano Jerusalim. ");
INSERT INTO rmna_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Kad o Irod dikhlja e Isuse, but inele radosno adalese so pana angleder manglja te dikhel le adalese so but šunđa olestar hem nadinđa pe da o Isus ka ćerel nesavo čudo anglo leste. ");
INSERT INTO rmna_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","But so pučlja le, ali o Isus ništa na phenđa lese. ");
INSERT INTO rmna_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","A adari terđona ine o šerutne sveštenici hem o učitelja e Zakonestar vaćerindoj zorale protiv o Isus. ");
INSERT INTO rmna_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","A o Irod hem lesere vojnici ponizinde e Isuse hem marde muj oleja. Urjavde le ano carikano fostani hem tegani o Irod bičhalđa le palal koro Pilat. ");
INSERT INTO rmna_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Angleder o Irod hem o Pilat na inele ano šukar odnosija, a adava dive ule amala. ");
INSERT INTO rmna_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","A o Pilat vičinđa kora peste e šerutne sveštenikonen, e vođen hem e narodo, ");
INSERT INTO rmna_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","i phenđa lenđe: “Anđen kora mande akale manuše vaćerindoj da vazdela pobuna maškaro narodo. Ače, angla tumende pučljum le adalestar, ali na arakhljum nisavi krivica zaki savi tumen optužinena le. ");
INSERT INTO rmna_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","A ni o Irod na arakhlja upro leste krivica i adalese bičhalđa le palal kora amende. Akava manuš na ćerđa ništa so zaslužini meriba. ");
INSERT INTO rmna_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Adalese samo ka naredinav te šibinen le, i ka mukav le.” ");
INSERT INTO rmna_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","A valjanđa zako prazniko, palo adeti, te mukel lenđe jekhe phandle manuše. ");
INSERT INTO rmna_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ko adava sare so inele adari vičinde: “Mudar adale manuše, a muk amenđe e Varava!” ");
INSERT INTO rmna_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(O Varava inele phandlo adalese so učestvujinđa ani pobuna savi inele ano Jerusalim hem adalese so mudarđa nekas.) ");
INSERT INTO rmna_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","A o Pilat, adalese so manglja te mukel e Isuse, palem vaćerđa olencar, ");
INSERT INTO rmna_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ali on vičinde: “Čhiv le ko krsto! Čhiv le ko krsto!” ");
INSERT INTO rmna_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","A o Pilat palo trito puti phenđa lenđe: “A savo bišukaripe ćerđa akava manuš? Na dikhava sose valjani te merel. Ka naredinav te šibinen le, i ka mukav le.” ");
INSERT INTO rmna_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ali on na ačhavde te vičinen oto sa o glaso rodindoj te čhivel e Isuse ko krsto. I lengoro vičiba inele sa po zoralo. ");
INSERT INTO rmna_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","I adalese o Pilat odlučinđa te del len adava so mangena. ");
INSERT INTO rmna_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Muklja okole kole mangle, kova inele phandlo zbog i pobuna hem zbog o mudariba, a e Isuse dinđa ko vojnici te ćeren oleja adava so o narodo manglja. ");
INSERT INTO rmna_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Sar o vojnici legarena ine e Isuse, dolinde nesave Simone tari Kirinija sar avela ine taro polje. Čhivde o krsto upro leste hem terinde le te akhari le palo Isus. ");
INSERT INTO rmna_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Palo Isus dželo baro narodo maškaro kolende inele hem o đuvlja kola runde hem žalinde le. ");
INSERT INTO rmna_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ali o Isus irinđa pe nakoro lende hem phenđa lenđe: “Đuvljalen taro Jerusalim, ma roven pala mande, nego roven pala tumende hem tumare čhavende. ");
INSERT INTO rmna_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Adalese so, ače, avena o dive kad o manuša ka vaćeren: ‘Bahtalei o đuvlja kolai bizo čhave, kola na bijande hem na dinde čuči.’ ");
INSERT INTO rmna_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Tegani ‘ka phenen e planinenđe: Peren upra amende! hem e bregonenđe: Učharen amen!’ ");
INSERT INTO rmna_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Adalese so, te ađahar ćerela pe mancar kova injum sar jekh sapano kaš, sigurno po bišukar ka ćerel pe e manušencar kolai sar o šuke kašta.” ");
INSERT INTO rmna_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","A e Isuseja inele legarde pana duje zločinconen te oven mudarde. ");
INSERT INTO rmna_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","I kad resle ko than vičime Kokalo e šeresoro, o vojnici čhivde ko krsto e Isuse hem čhivde adale zločinconen ko avera krstija: jekhe oti lesiri desno, a e dujtone oti lesiri levo strana. ");
INSERT INTO rmna_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","O Isus phenđa: “Dade, oprostin lenđe, adalese so na džanen so ćerena!” Tegani o vojnici frdinde barbuti hem ađahar delinde maškara pumende e Isusesere šeja. ");
INSERT INTO rmna_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","O narodo terdino adari te dikhelfse, a e jevrejengere vođe marde muj e Isuseja vaćerindoj: “Averen spasinđa; akana nek spasini korkoro pes tei čače ov o Hrist e Devlesoro, lesoro Izabirime!” ");
INSERT INTO rmna_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Hem o vojnici marde muj e Isuseja. Ale uzalo leste hem kaninde le ušli mol, ");
INSERT INTO rmna_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","vaćerindoj: “Te injan o caro e jevrejengoro, spasin tut!” ");
INSERT INTO rmna_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","A upreder lesoro šero terdino znako kote inele pisime: Akavai o caro e jevrejengoro . ");
INSERT INTO rmna_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jekh okole zločinconendar vređinđa e Isuse vaćerindoj: “Te injan o Hrist, sose na spasineja tut hem amen?” ");
INSERT INTO rmna_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","A o dujto zločinco ukorinđa adale so vređinđa e Isuse: “Sar na daraja e Devlestar? Hem tu injan ađahar osudime sar soi ov. ");
INSERT INTO rmna_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Amen pravedno injam kaznime zbog amare bišukar buća, a ov na ćerđa nisavo bišukaripe.” ");
INSERT INTO rmna_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Tegani phenđa: “Isuse, setin tut mandar kad ka ave ano to carstvo.” ");
INSERT INTO rmna_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","A o Isus phenđa lese: “Čače vaćerava će, avdive ka ove mancar ano raj!” ");
INSERT INTO rmna_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","A ko ekvaš o dive, i tomina učharđa sa i phuv hem ađahar inele trin saća, ");
INSERT INTO rmna_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","adalese so o kham kalilo. A e hramesiri zavesa pharavdili ko ekvaš. ");
INSERT INTO rmna_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","A o Isus vičinđa oto sa o glaso: “Dade, tuće ano vasta mukava o duho mlo!” Kad phenđa adava, muklja pli duša. ");
INSERT INTO rmna_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","A kad e rimesoro kapetani dikhlja so ulo, lelja te slavini e Devle, vaćerindoj: “Čače akava manuš inele pravedniko!” ");
INSERT INTO rmna_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","But manuša kola čedinde pe adari te dikhenfse, irindoj čhere khuvena pe ine ko gruđa adalese so ine lenđe žao. ");
INSERT INTO rmna_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","A sa e Isusesere amala, đi o đuvlja kola phirde palo leste pana tari Galileja, odural terdine hem dikhle sa adava. ");
INSERT INTO rmna_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","A inele jekh manuš palo anav Josif tari Arimateja, diz ani Judeja. Ov inele šukar hem pravedno manuš kova adžićeri ine o carstvo e Devlesoro. Iako inele člano oto e jevrejengoro sabor, na složinđa pe adaleja so inele odlučime te roden o Isus te ovel mudardo. ");
INSERT INTO rmna_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ov dželo koro Pilat hem rodinđa te den le o telo e Isusesoro. ");
INSERT INTO rmna_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Tegani huljavđa e Isusesoro telo taro krsto, paćarđa le čaršaveja hem čhivđa le ano grobo savo inele ćerdo ano bar, ano savo pana niko na inele čhivdo. ");
INSERT INTO rmna_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Adava dive inele Dive zako pripremiba zako savato savo samo so na ine te avel. ");
INSERT INTO rmna_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","A o đuvlja, kola ale e Isuseja tari Galileja, džele e Josifeja hem dikhle sar e Isusesoro telo inele čhivdo ano grobo. ");
INSERT INTO rmna_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","I irinde pe adari kaj bešena ine hem spreminde o mirisija hem o mastija savencar te makhen e Isusesoro telo. Ali ko savato odmorinde pe poštujindoj i naredba oto Zakoni e Mojsijasoro. ");
INSERT INTO rmna_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Rano sabale, ko prvo dive oto kurko, o đuvlja ale ko grobo hem ande o mirisija save spreminde. ");
INSERT INTO rmna_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","I dikhle dai cidime o bar savo inele anglo udar e grobosoro. ");
INSERT INTO rmna_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Đerdinde andre, ali na arakhle o telo Gospodesoro e Isusesoro. ");
INSERT INTO rmna_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","I sar terđona ine adari zbunime, otojekhvar iklile anglo lende duj manuša ano sjajna šeja. ");
INSERT INTO rmna_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","O đuvlja but darandile hem peravde pumare šere nakori phuv, a on phende lenđe: “Sose rodena e dživde maškaro mule? ");
INSERT INTO rmna_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ov nane akate. Uštino taro mule! Setinen tumen so vaćerđa tumenđe dok pana inele ani Galileja: ");
INSERT INTO rmna_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Me, o Čhavo e manušesoro, valjani te ovav dindo ano vasta e grešnone manušengere, te ovav čhivdo ko krsto, ali o trito dive ka uštav.’” ");
INSERT INTO rmna_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Tegani on setinde pe da o Isus phenđa lenđe adava. ");
INSERT INTO rmna_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","I irinde pe taro grobo palal ki diz te vaćeren adava e dešujekhe apostolenđe hem sarijenđe averenđe. ");
INSERT INTO rmna_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Adala đuvlja inele i Marija Magdalena, i Jovana, i Marija e Jakovesiri daj, hem avera. I on sa adava vaćerde e apostolenđe, ");
INSERT INTO rmna_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ali o apostolja na verujinde lenđe, adalese so mislinde da sa adava izmislinde. ");
INSERT INTO rmna_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","A o Petar uštino hem prastandilo đi o grobo. Telilo hem dikhlja samo o čaršavi saveja e Isusesoro telo inele paćardo. I irinđa pe palal pučindoj pes so ulo adava. ");
INSERT INTO rmna_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Adava dive duj oto e Isusesere sledbenici džana ine ko gav Emaus, dur taro Jerusalim dešujekh kilometarija. ");
INSERT INTO rmna_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Odrumal vaćerena ine maškara pumende adalestar so ulo adala dive. ");
INSERT INTO rmna_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","I sar vaćerena ine ađahar, korkoro o Isus alo uzalo lende hem lelja te phirel olencar. ");
INSERT INTO rmna_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ali olenđe na inele muklo te pendžaren le. ");
INSERT INTO rmna_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","O Isus pučlja len: “Sostar vaćerena maškara tumende phirindoj?” Tegani on terdine, a ko lengere muja dičhili žalost. ");
INSERT INTO rmna_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Jekh olendar, palo anav Kleopa, phenđa lese: “Sar so dičhola, tu injan jedino abanđija ano Jerusalim kova na džanel so ulo adari akala dive.” ");
INSERT INTO rmna_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","O Isus pučlja len: “So ulo?” I on phende lese: “Adava so ulo e Isuseja e Nazarećanineja. Ov inele proroko zoralo ano lafija hem ano delja anglo Devel hem anglo sa o narodo. ");
INSERT INTO rmna_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ali amare šerutne sveštenici hem amare avera vođe dinde le te ovel osudime ko meriba hem čhivde le ko krsto. ");
INSERT INTO rmna_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Amen nadinđam amen dai ov adava kova ka otkupini e Izraelesere narodo. A ače, tritoi dive sar ulo sa adava. ");
INSERT INTO rmna_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Hem pana zbuninde amen nesave amare đuvlja. Rano sabale džele ko grobo, ");
INSERT INTO rmna_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ali na arakhle e Isusesoro telo adari. Ale hem phende amenđe da dikhle anđelen kola vaćerde lenđe dai o Isus dživdo. ");
INSERT INTO rmna_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Tegani nesave amendar džele ko grobo hem arakhle ađahar sar so phende o đuvlja. Ali na dikhle e Isuse.” ");
INSERT INTO rmna_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Tegani o Isus phenđa lenđe: “O, sar na haljovena? Sosei tumenđe pharo te verujinen sa adava so o proroci vaćerde? ");
INSERT INTO rmna_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","On prorokujinde da o Hrist valjani te nakhel sa adala patnje angleder so đerdini pese ani slava.” ");
INSERT INTO rmna_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","I tegani lelja te objasnini lenđe soi e Hristestar pisime ano Sveta lila, počindoj e Mojsijasere lilendar hem ano sa e prorokonengere lila. ");
INSERT INTO rmna_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Sar avena ine paše uzalo gav Emaus, o Isus ćerđa pe da mangela te džal po dur. ");
INSERT INTO rmna_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ali on terinde le te ačhol vaćerindoj: “Ačhov amencar, adalese so lela te perel i rat!” I o Isus đerdinđa ano čher hem ačhilo olencar. ");
INSERT INTO rmna_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kad inele olencar uzalo astali, o Isus lelja o maro, zahvalinđa e Devlese, phaglja le hem dinđa len. ");
INSERT INTO rmna_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tegani phravdile lengere jaćha hem pendžarde le dai ov o Isus, ali ov otojekhvar na inele više anglo lende. ");
INSERT INTO rmna_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Tegani phende jekh averese: “Na ine amen li sar jag ano vile dok vaćerđa amencar odrumal hem objasninđa amenđe o Sveta lila?” ");
INSERT INTO rmna_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","I odmah uštine hem irinde pe ko Jerusalim. Adari arakhle sar bešena zajedno o dešujekh apostolja hem avera sledbenici e Isusesere ");
INSERT INTO rmna_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","kola phende lenđe: “O Gospod čače uštino taro mule hem mothovđa pe e Simonese!” ");
INSERT INTO rmna_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Tegani o duj manuša vaćerde lenđe sa so ulo ko drom nakoro Emaus hem sar pendžarde e Isuse kad phaglja o maro. ");
INSERT INTO rmna_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Sar pana vaćerena ine adalestar, o Isus otojekhvar terdino maškar olende hem phenđa lenđe: “Mir tumencar!” ");
INSERT INTO rmna_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","A on but darandile, adalese so mislinde da dikhena duho. ");
INSERT INTO rmna_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Tegani o Isus phenđa lenđe: “Sose darana? Hem sose isi tumen sumnje ano vile? ");
INSERT INTO rmna_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Dikhen mle vasta hem mle pre! Me injum! Pipinen man hem ka dikhen! E duho nane telo hem kokala sar so dikhena da man isi!” ");
INSERT INTO rmna_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Vaćerindoj adava, mothovđa lenđe ple vasta hem o pre. ");
INSERT INTO rmna_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","On edobor inele radosna hem začudime da našti ine te verujinen. Tegani o Isus pučlja len: “Isi tumen li nešto hajbnase?” ");
INSERT INTO rmna_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","I on dinde le kotor oto peko maćho. ");
INSERT INTO rmna_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ov lelja hem halja le anglo lende. ");
INSERT INTO rmna_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Tegani o Isus phenđa lenđe: “Akavai o lafija save vaćerđum tumenđe dok injumle tumencar: da valjani te pherđol sa soi pisime mandar ano Zakoni e Mojsijasoro, ano Lila e prorokonengere hem ano Psalmija.” ");
INSERT INTO rmna_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Tegani phravđa lengere jaćha te haljoven o Sveta lila, ");
INSERT INTO rmna_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","i phenđa lenđe: “Ađahari zapisime: O Hrist ka patini hem o trito dive ka uštel taro mule, ");
INSERT INTO rmna_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","hem ano lesoro anav ka propovedini pe o pokajanje hem oprostiba e grehengoro sa e nacijenđe, počindoj taro Jerusalim. ");
INSERT INTO rmna_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Tumen injen svedoci adalestar. ");
INSERT INTO rmna_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","A me ka bičhalav tumenđe e Svetone Duho, sar so mlo Dad obećinđa. Ali ačhoven ani diz đikote o zoralipe e Devlestar naka huljel upra tumende.” ");
INSERT INTO rmna_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Tegani o Isus legarđa ple učenikonen paše uzali Vitanija, i vazdinđa ple vasta hem blagoslovinđa len. ");
INSERT INTO rmna_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","I sar blagoslovini len ine, cidinđa pe olendar hem legardilo ko nebo. ");
INSERT INTO rmna_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","A on pele ko kočija anglo leste, i ani bari radost irinde pe ano Jerusalim. ");
INSERT INTO rmna_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","I stalno džana ine ko Hram te hvalinen e Devle.");
INSERT INTO rmna_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ko anglunipe inele o Lafi, hem o Lafi inele e Devleja, hem o Lafi inele o Devel. ");
INSERT INTO rmna_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ov ko anglunipe inele e Devleja. ");
INSERT INTO rmna_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Prekalo lestei ćerdo sa so postojini, hem bizo lesoro ništa nane ćerdo. ");
INSERT INTO rmna_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ano leste inele o dživdipe hem adava dživdipe inele svetlost e manušenđe. ");
INSERT INTO rmna_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Adava svetlost svetlini ani tomina hem i tomina na prelelja le. ");
INSERT INTO rmna_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Inele jekh manuš vičime Jovan Krstitelji, kole o Devel bičhalđa ");
INSERT INTO rmna_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","te svedočini e svetlostar, te šaj prekalo leste sare te poverujinen. ");
INSERT INTO rmna_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Korkoro o Jovan na inele svetlost, nego inele svedoko kova vaćerđa e svetlostar. ");
INSERT INTO rmna_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","A okova kovai e čačipnasoro svetlost, so osvetlini svakone manuše, alo ko sveto. ");
INSERT INTO rmna_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ov inele ko sveto hem o sveto prekalo leste inele ćerdo, ali o sveto na pendžarđa le. ");
INSERT INTO rmna_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Alo ani pli phuv, ali olesere manuša na priminde le. ");
INSERT INTO rmna_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","A sarijenđe kola priminde le, kola verujinena ano lesoro anav, dinđa pravo te oven e Devlesere čhave. ");
INSERT INTO rmna_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","On nane bijande ni prirodno, ni oti volja e telosiri, ni oti volja e muršesiri, nego oto Devel. ");
INSERT INTO rmna_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","I o Lafi ulo manuš hem alo te živini maškar amende. Amen dikhljam lesiri slava, i slava e jekhore Čhavesiri kova alo e Dadestar. Ov inele pherdo milost hem čačipe. ");
INSERT INTO rmna_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","(O Jovan svedočinđa olestar vičindoj: “Akavai adava kolestar vaćerđum: Pala mande avela neko kovai po baro mandar, adalese so postojinđa angleder mandar.”) ");
INSERT INTO rmna_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Taro pherdipe oti olesiri milost sare priminđam milost pali milost. ");
INSERT INTO rmna_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Adalese soi o Zakoni dindo prekalo Mojsije, a i milost hem o čačipe ale prekalo Isus Hrist. ");
INSERT INTO rmna_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","E Devle niko nikad na dikhlja, ali o jekhoro Čhavo, kovai hem korkoro Devel hem kovai e Dadese najpaše, ov mothovđa le. ");
INSERT INTO rmna_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Akava inele e Jovanesoro svedočanstvo kad o šerutne Jevreja taro Jerusalim bičhalde nesave sveštenikonen hem e Leviten te pučen e Jovane: “Ko injan tu?” ");
INSERT INTO rmna_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","O Jovan phravdeste phenđa lenđe: “Me na injum o Hrist.” ");
INSERT INTO rmna_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","I on pučle le: “A kova injan onda? Na li injan o proroko o Ilija?” Ov phenđa: “Na injum.” Tegani pučle le: “Na li injan o Proroko kole adžićeraja?” Ov phenđa: “Na.” ");
INSERT INTO rmna_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Tegani phende lese: “Phen amenđe onda kova tu injan, te šaj vaćera okolenđe kola bičhalde amen. So ka phene tutar?” ");
INSERT INTO rmna_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","A o Jovan phenđa lenđe palo lafija e prorokosere e Isaijasere: “Me injum ‘o glaso so vičini ani pustinja: Ravnonen o drom e Gospodese!’” ");
INSERT INTO rmna_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","A nesave oto bičhalde inele fariseja. ");
INSERT INTO rmna_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","On pučle le: “Sose onda krstineja te na injan o Hrist, ni o Ilija, ni o Proroko?” ");
INSERT INTO rmna_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","O Jovan phenđa lenđe: “Me krstinava panjeja, ali akate maškara tumende terđola neko kas tumen na pendžarena. ");
INSERT INTO rmna_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Pala mande avela ov, kase na injum dostojno ni o dorikha oti obuća te phravav.” ");
INSERT INTO rmna_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Adava ulo ani Vitanija, tari istočno strana oti len Jordan, kote o Jovan krstini ine. ");
INSERT INTO rmna_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Tejsa dive o Jovan dikhlja e Isuse sar avela nakoro leste, i phenđa: “Ače o Bakroro e Devlesoro kova cidela o grehija e svetosere! ");
INSERT INTO rmna_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Akavai adava kastar me vaćerđum: ‘Pala mande avela manuš kovai po baro mandar, adalese so postojinđa angleder mandar.’ ");
INSERT INTO rmna_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Me na džanđum dai ov adava, ali aljum te krstinav panjeja te šaj ov te ovel mothovdo e izraelesere manušenđe.” ");
INSERT INTO rmna_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","I o Jovan ađahar svedočinđa: “Dikhljum e Svetone Duho sar huljela taro nebo sar golubi hem ačhola upro leste. ");
INSERT INTO rmna_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Me na džanđum dai ov adava, ali kad o Devel bičhalđa man te krstinav panjeja, phenđa maje: ‘Kad ka dikhe e manuše upra kaste huljela o Sveto Duho hem ačhola upro leste, ka džane dai ov adava kova krstini Svetone Duhoja.’ ");
INSERT INTO rmna_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","I me dikhljum adava hem adalese svedočinava dai ov o Čhavo e Devlesoro.” ");
INSERT INTO rmna_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Tejsa dive o Jovan palem inele adari ple duje učenikonencar. ");
INSERT INTO rmna_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Dikhindoj e Isuse sar nakhela, phenđa: “Ače o Bakroro e Devlesoro!” ");
INSERT INTO rmna_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Kad o duj učenici šunde adava, lelje te džan palo Isus. ");
INSERT INTO rmna_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","O Isus irinđa pe hem dikhlja len sar džana palo leste, i pučlja len: “So mangena?” On phende lese: “Rabi” (so značini: Učitelju), “kaj bešeja?” ");
INSERT INTO rmna_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ov phenđa lenđe: “Aven hem ka dikhen.” Hem ađahar džele oleja đi o than kaj bešela ine hem adava dive ačhile koro leste. A tegani inele đi ko štar o sati prekalo dive. ");
INSERT INTO rmna_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jekh e duje učenikonendar kola šunde so o Jovan phenđa hem džele palo Isus inele o Andreja, o phral e Simonesoro e Petresoro. ");
INSERT INTO rmna_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","I najangle arakhlja ple phrale e Simone hem phenđa lese: “Arakhljam e Mesija” (so značini: e Hriste). ");
INSERT INTO rmna_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","I anđa le koro Isus. O Isus dikhlja le hem phenđa lese: “Tu injan o Simon, e Jovanesoro čhavo. Ka vičine tut Kifa” (so značini: Petar –“stena”). ");
INSERT INTO rmna_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Tejsa dive o Isus odlučinđa te džal ki regija Galileja, i arakhlja e Filipe hem phenđa lese: “Phir pala mande!” ");
INSERT INTO rmna_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","O Filip inele tari Vitsaida, tari e Andrejasiri hem e Petresiri diz. ");
INSERT INTO rmna_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","O Filip arakhlja e Natanailo, hem phenđa lese: “Arakhljam e Mesija, okole kastar pisinde o Mojsije ano Zakoni hem o Proroci. Adavai o Isus tari diz Nazaret, e Josifesoro čhavo.” ");
INSERT INTO rmna_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","O Natanail pučlja le: “Šaj li taro Nazaret te avel nešto šukar?” A o Filip phenđa lese: “Ava hem dikh.” ");
INSERT INTO rmna_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","O Isus dikhlja e Natanailo sar avela nakoro leste, i phenđa averenđe olestar: “Ače čačikano Izraelco, kora kaste nane hovajba.” ");
INSERT INTO rmna_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","A o Natanail pučlja le: “Kotar džane man?” O Isus phenđa lese: “Dikhljum tut pana kad injanle talo kaš e smokvakoro, angleder so o Filip vičinđa tut.” ");
INSERT INTO rmna_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Tegani o Natanail phenđa lese: “Rabi, tu injan o Čhavo e Devlesoro! Tu injan o Caro e Izraelesoro!” ");
INSERT INTO rmna_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","O Isus pučlja le: “Tu li verujineja samo adalese so phenđum će so dikhljum tut talo kaš e smokvakoro? Ka dikhe hem po bare stvarija akalendar.” ");
INSERT INTO rmna_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Tegani phenđa: “Čače, čače vaćerava tumenđe: ka dikhen o nebo phravdo hem sar o anđelja e Devlesere ukljena hem huljena upro Čhavo e manušesoro.” ");
INSERT INTO rmna_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ko trito dive inele bijav ano gav Kana ani regija Galileja. Adari inele e Isusesiri daj, ");
INSERT INTO rmna_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","a ko bijav inele vičime hem o Isus hem lesere učenici. ");
INSERT INTO rmna_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Kad na ačhili više mol ko bijav, e Isusese phenđa lesiri daj: “Nane len više mol.” ");
INSERT INTO rmna_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","O Isus phenđa laće: “So isi man adaleja, đuvlije? Mlo vreme pana na alo.” ");
INSERT INTO rmna_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Lesiri daj phenđa e slugenđe: “Ćeren sa so vaćeri tumenđe!” ");
INSERT INTO rmna_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Adari inele šov bare bokalija oto bar, a ko svako bokali resela ine taro oftovardeš đi ko šelu biš litarja. O Jevreja koristinena len ine zako pumaro adeti e thojbnasoro. ");
INSERT INTO rmna_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","O Isus phenđa e slugenđe: “Pheren panjeja o bokalija”, hem on pherde len đi o muj. ");
INSERT INTO rmna_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Kad ćerde adava, phenđa lenđe: “Akana dolen hari hem legaren e manušese kovai odgovorno zaki gozba.” I on ćerde ađahar. ");
INSERT INTO rmna_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Adava manuš probinđa o pani savo ulo mol, i adalese so na džanđa kotari adaja mol – iako džande o sluge kola dolinde pani – vičinđa e mladoženja ");
INSERT INTO rmna_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","hem phenđa lese: “Svako manuš prvo ikali i šuži mol, a kad o gostija mačona, ikali i mol savi nane edobor šuži. A tu garavđan i najšuži mol sa đi akana.” ");
INSERT INTO rmna_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ađahar o Isus plo prvo čudesno znako ćerđa ani Kana e Galilejakiri, hem mothovđa pli slava, i lesere učenici verujinde ano leste. ");
INSERT INTO rmna_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Palo bijav o Isus, pe dajaja, ple phraljencar hem ple učenikonencar, huljilo ani diz Kafarnaum. Adari ačhile nekobor dive. ");
INSERT INTO rmna_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Avela ine paše e jevrejengoro prazniko Pasha, i o Isus dželo ko Jerusalim. ");
INSERT INTO rmna_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ano boro e Hramesoro o Isus arakhlja manušen sar biknena guruven, bakren hem goluben. Arakhlja hem okolen so menjinena o pare sar bešena adari. ");
INSERT INTO rmna_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","I ćerđa bič oto dorikha hem sarijen kola biknena, sa e bakrencar hem e guruvencar, ikalđa taro Hram. Rasfrdinđa o pare okolengere so menjinena len ine, hem preirinđa lengere astalja. ");
INSERT INTO rmna_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Okolenđe kola biknena goluben phenđa: “Legaren adava akatar! Ma ćeren pijaca mle Dadesere čherestar!” ");
INSERT INTO rmna_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Lesere učenici setinde pe soi pisime ano Sveto lil: “O mangipe zako to čher ka thabljol ana mande sar jag.” ");
INSERT INTO rmna_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Tegani e jevrejengere vođe pučle e Isuse: “Save čudesnone znakoja ka dokažine amenđe da isi tut pravo te ćere sa akava?” ");
INSERT INTO rmna_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","O Isus phenđa lenđe: “Peraven akava Hram hem me palem ka vazdav le zako trin dive.” ");
INSERT INTO rmna_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","A on phende: “Sarandu šov berš valjanđa te ćerel pe akava Hram, a tu ka vazde le zako trin dive?” ");
INSERT INTO rmna_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ali o Hram savestar o Isus vaćerđa inele lesoro telo. ");
INSERT INTO rmna_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kad uštino taro mule, lesere učenici setinde pe so phenđa adava, i poverujinde ano Sveta lila hem ano lafija save o Isus vaćerđa. ");
INSERT INTO rmna_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","A sa đikote inele ano Jerusalim zako prazniko Pasha, but džene dikhle o čudesna znakija save ćerela ine hem poverujinde ano leste. ");
INSERT INTO rmna_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ali korkoro o Isus na verujinđa lenđe, adalese so džanđa sarijen. ");
INSERT INTO rmna_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Niko na valjanđa te vaćeri lese savoi o manuš, adalese so ov korkoro džanđa soi ano manuš. ");
INSERT INTO rmna_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","A maškaro fariseja inele jekh manuš palo anav Nikodim, kova inele jekh oto vođe e jevrejengere. ");
INSERT INTO rmna_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Jekh rat dželo koro Isus hem phenđa lese: “Rabi, džanaja da e Devlestar injan bičhaldo sar učitelj, adalese so nijekh našti te ćerel esavke čudesna znakija save tu ćereja te o Devel nane oleja.” ");
INSERT INTO rmna_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","O Isus phenđa lese: “Čače, čače vaćerava će, te o manuš palem na bijanđola, naka šaj te dikhel o carstvo e Devlesoro.” ");
INSERT INTO rmna_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","O Nikodim pučlja le: “Sar šaj o manuš palem te bijanđol kadi purano? Našti, valjda, dujto puti te đerdini ple dajaće ano vođi hem palem te bijanđol!” ");
INSERT INTO rmna_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","O Isus phenđa lese: “Čače, čače vaćerava će, te o manuš na bijanđola oto pani hem oto Duho, naka šaj te đerdini ko carstvo e Devlesoro. ");
INSERT INTO rmna_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Okova soi bijando oto telo, teloi, a soi bijando oto Duho, duhoi. ");
INSERT INTO rmna_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ma čudin tut so phenđum će so valjani palem te bijanđoven. ");
INSERT INTO rmna_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","I barval phudela kaj mangela; šuneja la, ali na džane kotar avela ni kaj džala. Ađahari svakoneja kovai bijando oto Duho.” ");
INSERT INTO rmna_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","A o Nikodim pučlja le: “Sar šaj adava te ovel?” ");
INSERT INTO rmna_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","A o Isus phenđa lese: “Tu injan cenime učitelj ano Izrael, a adava na džane! ");
INSERT INTO rmna_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Čače, čače vaćerava će: vaćeraja okova so džanaja hem svedočinaja zako okova so dikhljam, ali tumen na prihvatinena amaro svedočanstvo. ");
INSERT INTO rmna_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Vaćerđum tumenđe oto stvarija save ovena ki phuv, i tumen na verujinena. Sar ka verujinen te vaćerđum tumenđe oto stvarija save ovena ko nebo? ");
INSERT INTO rmna_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Niko na uštino ko nebo sem o Čhavo e manušesoro kova taro nebo huljilo. ");
INSERT INTO rmna_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Hem sar so o Mojsije ani pustinja vazdinđa ko štapi e sape oti bronza, ađahar valjani te ovel vazdime hem o Čhavo e manušesoro, ");
INSERT INTO rmna_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","te šaj svako kova verujini ano leste te ovel le večno dživdipe.” ");
INSERT INTO rmna_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Adalese so, o Devel edobor volinđa e manušen taro sveto da dinđa ple jekhore Čhave, da svako kova verujini ano leste te na merel, nego te ovel le večno dživdipe. ");
INSERT INTO rmna_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","O Devel na bičhalđa ple Čhave ko sveto te osudini e manušen, nego o manuša te oven spasime prekalo leste. ");
INSERT INTO rmna_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ko verujini ano leste, nane osudime, a ko na verujini, ovi već osudime, adalese so na poverujinđa ano anav e Devlesere jekhore Čhavesoro. ");
INSERT INTO rmna_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","A akavai i osuda: o svetlost alo ko sveto, ali o manuša volinde i tomina umesto o svetlost, adalese so lengere delja inele bišukar. ");
INSERT INTO rmna_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ko god ćerela bišukaripe, mrzini o svetlost hem na ikljola ko svetlost, te na dičhon lesere delja. ");
INSERT INTO rmna_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","A okova kova živini palo čačipe, ikljola ko svetlost, te dičhol soi lesere delja ćerde ano zoralipe e Devlesoro. ");
INSERT INTO rmna_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Palo adava o Isus dželo ple učenikonencar ko gavutno deo e Judejakoro. Adari inele olencar nesavo vreme hem krstini ine. ");
INSERT INTO rmna_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","A hem o Jovan krstini ine ano than Enon, paše uzalo gav Salim, adalese so adari inele but pani, a o manuša avena ine koro leste te krstini len. ");
INSERT INTO rmna_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Adava inele angleder so e Jovane frdinde ano phandlipe. ");
INSERT INTO rmna_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","A maškaro e Jovanesere učenici hem nesavo aver Jevrejco uli rasprava zako adeti e thojbnasoro. ");
INSERT INTO rmna_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","I adala učenici ale koro Jovan hem phende lese: “Rabi, okova so inele tuja tari aver strana oti len Jordan, okova kastar tu svedočinđan, eče krstini hem sa edobor manuša džana koro leste.” ");
INSERT INTO rmna_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","A o Jovan phenđa: “O manuš šaj te primini samo okova soi lese dindo e Devlestar kovai ano nebo. ");
INSERT INTO rmna_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Korkore injen maje svedoci so phenđum da me na injum o Hrist, nego da injum bičhaldo anglo leste. ");
INSERT INTO rmna_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","O mladoženjai okova kasiri i nevesta. A o najšukar amal e mladoženjasoro, kova adžićeri te šunel da o mladoženja avela, radosnoi but kad šunela e mladoženjasoro glaso. I adajai radost mli, hem akana uli pherdi. ");
INSERT INTO rmna_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ov valjani te ovel sa po baro, a me sa po tikoro.” ");
INSERT INTO rmna_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Okova kova avela odupral, ovi upreder sarijende, a okova kovai tari phuv, ovi e phuvjakoro hem vaćeri taro stvarija e phuvjakere. Okova kova avela taro nebo, ovi upreder sarijende. ");
INSERT INTO rmna_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ov svedočini zako okova so dikhlja hem šunđa, ali niko na prihvatini lesoro svedočanstvo. ");
INSERT INTO rmna_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","A ko prihvatini lesoro svedočanstvo, potvrdini dai o Devel čačikano. ");
INSERT INTO rmna_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Okova kas o Devel bičhalđa, vaćeri e Devlesere lafija, adalese so o Devel dinđa le pherdeste e Duho. ");
INSERT INTO rmna_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","O Dad volini e Čhave hem sa muklja lese ano vasta. ");
INSERT INTO rmna_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Svako kova verujini ano Čhavo, isi le večno dživdipe, a kova nane poslušno e Čhavese, naka ovel le večno dživdipe, nego upro leste ačhola e Devlesiri holi. ");
INSERT INTO rmna_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Kad o Isus dodžanđa so o fariseja šunde so ov ćerela hem krstini više učenikonen nego o Jovan, ");
INSERT INTO rmna_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","– iako korkoro o Isus na krstinđa, nego lesere učenici – ");
INSERT INTO rmna_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","dželo tari regija Judeja hem irinđa pe ani regija Galileja. ");
INSERT INTO rmna_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Morandilo te nakhel maškari regija Samarija. ");
INSERT INTO rmna_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Alo đi e samarijakoro gav savo vičini pe Sihar, paše uzalo imanje savo o Jakov dinđa ple čhavese e Josifese. ");
INSERT INTO rmna_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Adari inele e Jakovesoro bunari, i o Isus, umorno oto but phiriba, beštino uzalo leste. Inele paše đi ko dešu duj o sati diveste. ");
INSERT INTO rmna_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","I kad jekh Samarijanka ali te dolel pani, o Isus phenđa laće: “De man te pijav.” ");
INSERT INTO rmna_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Tegani o Isus inele korkoro, adalese so lesere učenici džele ko gav te činen hajbnase.) ");
INSERT INTO rmna_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","A i Samarijanka phenđa lese: “Sar adava tu kova injan Jevrejco rodeja mandar e Samarijankatar te dav tut pani?” (Adalese so o Jevreja na mešinde pe e Samarijanconencar). ");
INSERT INTO rmna_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","O Isus phenđa laće: “Te džane ine savo daro e Devle isi tuće hem kova injum me so rodava tutar te de man te pijav, ka rode mandar ine hem me ka dav tut o dživdo pani.” ");
INSERT INTO rmna_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","I đuvli phenđa lese: “Gospodarona, nane tut ni soja te dole pani, a o bunari but hor. Kotar će onda adava dživdo pani? ");
INSERT INTO rmna_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Tu li mislineja da injan po baro amare pradadestar e Jakovestar, kova dinđa amen akava bunari hem savestar pilja ov hem lesere čhave hem lesiri stoka?” ");
INSERT INTO rmna_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","O Isus phenđa laće: “Svako kova pijela akava pani, palem ka ovel žedno, ");
INSERT INTO rmna_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","a kova pijela o pani savo me ka dav le, nikad više naka ovel žedno. O pani savo ka dav le ka ovel ano leste izvor e panjesoro savo dela večno dživdipe.” ");
INSERT INTO rmna_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Tegani i đuvli phenđa lese: “Gospodarona, molinava tut, de man adava pani te na ovav više žedno hem te na avav više akate te dolav pani!” ");
INSERT INTO rmna_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","O Isus phenđa laće: “Dža vičin te rome hem ava palem akari.” ");
INSERT INTO rmna_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","I đuvli phenđa lese: “Nane man rom.” Tegani o Isus phenđa laće: “Šukar phenđan so nane tut rom, ");
INSERT INTO rmna_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","adalese so ine tut pandž roma, a akava kasar akana injan nane to rom. Čače šukar phenđan.” ");
INSERT INTO rmna_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","A i đuvli phenđa lese: “Gospodarona, dikhava da injan proroko. ");
INSERT INTO rmna_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Amare pradada slavinde e Devle ki akaja gora, a tumen o Jevreja phenena da e Devle valjani te slavini pe ano Jerusalim.” ");
INSERT INTO rmna_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","A o Isus phenđa laće: “Đuvlije, verujin maje, avela o vreme kad naka slavinen e Dade samo akate ili ano Jerusalim. ");
INSERT INTO rmna_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Tumen o Samarijanci na džanen kas slavinena, a amen o Jevreja džanaja kas slavinaja, adalese so o spasenje avela prekalo Jevreja. ");
INSERT INTO rmna_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ali avela o vreme – hem već alo – kad o čačikane slavljenici ka slavinen e Dade ano duho hem ano čačipe. Esavke slavljenikonen o Dad rodela. ");
INSERT INTO rmna_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","O Develi duho, hem okola kola slavinena le, valjani te slavinen le ano duho hem ano čačipe.” ");
INSERT INTO rmna_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","A i đuvli phenđa lese: “Džanav da o Mesija (vičime Hrist) ka avel. Kad ka avel ov, sa ka objasnini amenđe.” ");
INSERT INTO rmna_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Tegani o Isus phenđa laće: “Me injum adava, kova vaćerava tuja.” ");
INSERT INTO rmna_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","I ko adava momenti ale lesere učenici hem inele začudime so o Isus vaćeri e đuvljaja. Ali nijekh na pučlja le: “So mangeja olatar?” ili: “Sose vaćereja olaja?” ");
INSERT INTO rmna_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Tegani i đuvli ačhavđa plo bokali uzalo bunari, i dželi ko gav hem phenđa e manušenđe: ");
INSERT INTO rmna_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Aven te dikhen e manuše kova phenđa maje sa so ćerđum. Te nane ov o Hrist?” ");
INSERT INTO rmna_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","I o manuša iklile taro gav hem lelje te džan nakoro Isus. ");
INSERT INTO rmna_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Sar ovela ine adava, o učenici molinena ine e Isuse vaćerindoj: “Rabi, ha maro!” ");
INSERT INTO rmna_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","A ov phenđa lenđe: “Man isi te hav hajba zako savo tumen na džanen.” ");
INSERT INTO rmna_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Tegani o učenici phende jekh averese: “Te na anđa lese neko nešto te hal?” ");
INSERT INTO rmna_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","O Isus phenđa lenđe: “O hajbai mlo te ćerav i volja Okolesiri kova bičhalđa man hem te ćerav đi o kraj i buti savi dinđa man. ");
INSERT INTO rmna_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Na li tumen phenena: ‘Pana štar masek đi o čediba i žetva?’ Ače, vaćerava tumenđe: phraven tumare jaćha hem dikhen o njive – spremnai zako čediba. ");
INSERT INTO rmna_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Okova kova čedela već primini i plata hem čedela o bijandipe zako večno dživdipe, te šaj hem o sejači te radujini pe zajedno okoleja kova čedela. ");
INSERT INTO rmna_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ađahar pherđola okova vaćeriba: ‘Jekh sejini, a o dujto čedela.’ ");
INSERT INTO rmna_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Me bičhalđum tumen te čeden adari kaj na ćerđen buti. Avera ćerde phari buti, a tumen čedinđen o plodija save iklile oti lengiri buti.” ");
INSERT INTO rmna_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","But Samarijanci taro adava gav poverujinde ano Isus zbog o lafija e đuvljakere koja svedočinđa: “Ov phenđa maje sa so ćerđum!” ");
INSERT INTO rmna_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","A kad o Samarijanci ale koro Isus, zamolinde le te ačhol koro lende, hem ov ačhilo adari duj dive. ");
INSERT INTO rmna_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Hem pana but manuša poverujinde ano leste zbog lesere lafija. ");
INSERT INTO rmna_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Tegani o manuša taro gav phende e đuvljaće: “Akana više na verujinaja zbog adava so tu vaćerđan, nego so korkore šunđam, hem džanaja soi ov čače o Spasitelji e svetosoro.” ");
INSERT INTO rmna_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Palo adala duj dive, o Isus dželo adathar ki Galileja. ");
INSERT INTO rmna_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Korkoro o Isus tvrdinđa da o proroko nane cenime ano plo than kaj barilo.) ");
INSERT INTO rmna_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Kad reslo ki Galileja, o Galilejci priminde le šukar, samo adalese so dikhle o čudesija save ćerđa ano Jerusalim zako prazniko Pasha, adalese so hem on inele adari. ");
INSERT INTO rmna_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","I ađahar o Isus palem alo ani Kana e Galilejakiri, kaj ćerđa ine o pani ani mol. A inele jekh službeniko e carosoro kasoro čhavo pašljola ine namborme ani diz Kafarnaum. ");
INSERT INTO rmna_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Kad šunđa so o Isus alo tari Judeja ki Galileja, alo koro leste hem zamolinđa le te avel ano Kafarnaum hem te sasljari lesere čhave kovai anglo meriba. ");
INSERT INTO rmna_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Tegani o Isus phenđa lese: “Tumen đikote na dikhena znakija hem čudesija, na verujinena.” ");
INSERT INTO rmna_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","O službeniko phenđa lese: “Gospodarona, molinava tut, ava sar pana na mulo mlo čhavo!” ");
INSERT INTO rmna_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","O Isus phenđa lese: “Dža, to čhavo ka živini.” O manuš poverujinđa ano adava so o Isus phenđa lese hem dželo. ");
INSERT INTO rmna_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","A odrumal resle le lesere sluge hem phende lese dai lesoro čhavo dživdo. ");
INSERT INTO rmna_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ov pučlja len kad lesere čhavese lelja te ovel po šukar, a on phende lese: “I jag muklja le erati ko jekh o sati diveste.” ");
INSERT INTO rmna_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tegani e čhavesoro dad setinđa pe so baš ko adava sati o Isus phenđa lese: “To čhavo ka živini.” I ov hem sa lesere čherutne poverujinde ano Isus. ");
INSERT INTO rmna_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Adava inele dujto čudesno znako savo o Isus ćerđa ani Galileja. Ćerđa le kad alo tari Judeja. ");
INSERT INTO rmna_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Palo adava o Isus dželo ko Jerusalim zako e jevrejengoro prazniko. ");
INSERT INTO rmna_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","A ano Jerusalim, uzali e Bakrengiri kapija, inele bazeni savo ko jevrejski vičini pe Vitezda. Adari inele pandž phravde terase učharde krovonencar. ");
INSERT INTO rmna_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Adari pašljona ine but namborme manuša: korore, bange hem paralizujime. On adžićerena ine te ćeren pe talasija ano pani, ");
INSERT INTO rmna_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","adalese so ponekad avela ine o anđeo e Gospodesoro ko bazeni te ćerel talasija. I kova manuš prvo đerdini ano bazeni kad ovena o talasija, sasljola ine taro bilo savo nambormipe savo inole. ");
INSERT INTO rmna_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","A adari inele hem jekh manuš kova trijandu ofto berš inele namborme. ");
INSERT INTO rmna_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Kad o Isus dikhlja le sar pašljola hem adalese so džanđa kobori berš namborme, pučlja le: “Mangeja li te ove sasljardo?” ");
INSERT INTO rmna_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Tegani o namborme manuš phenđa e Isusese: “Gospodarona, nane man niko te pomožini maje te đerdinav ano bazeni kad ovena o talasija. A dok me resava, nekoi već adari angleder mande.” ");
INSERT INTO rmna_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","O Isus phenđa lese: “Ušti, le ti nosiljka hem phir!” ");
INSERT INTO rmna_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","I otojekhvar o manuš saslilo, vazdinđa pli nosiljka hem lelja te phirel. A adava dive inele savato, ");
INSERT INTO rmna_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","i adalese e jevrejengere vođe phende e sasljarde manušese: “Avdivei savato! Na tromaš te akhare ti nosiljka!” ");
INSERT INTO rmna_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","A ov phenđa lenđe: “Okova kova sasljarđa man phenđa maje: ‘Le ti nosiljka hem phir!’” ");
INSERT INTO rmna_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","On pučle le: “Kovai adava manuš so phenđa će: ‘Le ti nosiljka hem phir!’?” ");
INSERT INTO rmna_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ali o sasljardo manuš na džanđa kova inele adava, adalese so o Isus cidinđa pe maškaro but manuša kola inele adari. ");
INSERT INTO rmna_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Palo adava o Isus arakhlja le ko boro e Hramesoro, i phenđa lese: “Eče, sasto injan. Ma grešin više, te na arakhi tut nešto po bišukar.” ");
INSERT INTO rmna_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Tegani o sasljardo manuš dželo hem phenđa e jevrejengere vođenđe dai o Isus adava kova sasljarđa le. ");
INSERT INTO rmna_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Adalese so o Isus sasljarđa e manuše ko savato, e jevrejengere vođe lelje te progoninen le. ");
INSERT INTO rmna_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","A o Isus phenđa lenđe: “Mlo Dad stalno ćerela buti, a ađahar hem me.” ");
INSERT INTO rmna_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Adalese so phenđa adava, e jevrejengere vođe po više mangle te mudaren le, adalese so na samo so phaglja o zakoni zako savato nego hem so phenđa dai o Devel lesoro Dad – adaleja phenđa dai ov hem o Devel jednaka. ");
INSERT INTO rmna_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","A o Isus phenđa lenđe: “Čače, čače vaćerava tumenđe: O Čhavo korkoro pestar našti ništa te ćerel. Ćerela samo okova so dikhela so o Dad ćerela. Sa so ćerela o Dad, isto adava ćerela hem o Čhavo. ");
INSERT INTO rmna_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Adalese so, o Dad volini e Čhave hem mothoj lese sa so ćerela. A ka mothoj lese hem po bare buća nego soi o sasljariba akale manušesoro, i tumen ka čudinen tumen. ");
INSERT INTO rmna_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Adalese so, sar so o Dad vazdela e mulen hem dela len dživdipe, ađahar hem o Čhavo dela dživdipe kase ov mangela. ");
INSERT INTO rmna_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Adalese so, o Dad na sudini nikase, nego dinđa vlast e Čhavese te sudini sarijenđe, ");
INSERT INTO rmna_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","te šaj sare poštujinen e Čhave sar so poštujinena e Dade. Ko na poštujini e Čhave, na poštujini ni e Dade, kova bičhalđa le. ");
INSERT INTO rmna_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Čače, čače vaćerava tumenđe: Svako kova šunela mle lafija hem verujini Okolese kova bičhalđa man, isi le večno dživdipe hem naka ovel osudime, nego nakhino taro meriba ko dživdipe. ");
INSERT INTO rmna_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Čače, čače vaćerava tumenđe: Avela o vreme, hem već alo, kad o mule ka šunen o glaso e Devlesere Čhavesoro hem, kola ka šunen le, ka oven palem dživde. ");
INSERT INTO rmna_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Sar so e Dade isi dživdipe ana peste, ađahar hem ple Čhavese dinđa te ovel le dživdipe ana peste, ");
INSERT INTO rmna_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","hem dinđa le vlast te sudini, adalese soi ov o Čhavo e manušesoro. ");
INSERT INTO rmna_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ma čudinen tumen adalese. Adalese so avela o vreme kad sare kolai ano grobija ka šunen lesoro glaso ");
INSERT INTO rmna_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","hem ka ikljon, okola kola ćerde šukaripe, ka ušten te živinen večno, a okola kola ćerde bišukaripe, ka ušten te oven osudime. ");
INSERT INTO rmna_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Me korkoro mandar našti ništa te ćerav, nego sudinava ađahar sar so šunava e Dadestar. A mloi sudo pravedno, adalese so na rodava te ovel mli volja, nego i volja Okolesiri kova bičhalđa man.” ");
INSERT INTO rmna_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Te me korkoro mandar svedočinava, mlo svedočiba nane dovoljno. ");
INSERT INTO rmna_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ali aver neko svedočini mandar, hem džanav dai dovoljno o svedočiba savo dinđa mandar. ");
INSERT INTO rmna_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Tumen bičhalđen tumare manušen koro Jovan o Krstitelj, a lesoroi svedočiba mandar čačikano. ");
INSERT INTO rmna_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nane da maje valjani manušikano svedočiba, nego akava phenđum tumenđe e Jovanestar sar te šaj oven spasime. ");
INSERT INTO rmna_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","O Jovan inele svetiljka savi thabljola hem svetlini, a tumen mangljen samo nesavo vreme te uživinen ano lesoro svetlost. ");
INSERT INTO rmna_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","A isi man svedočanstvo po baro taro e Jovanesoro – o buća save ćerava. O Dad dinđa man te ćerav len hem on svedočinena adalestar da o Dad bičhalđa man. ");
INSERT INTO rmna_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","A hem korkoro o Dad, kova bičhalđa man, svedočinđa mandar. Tumen nikad na šunđen lesoro glaso ni na dikhljen lesoro muj, ");
INSERT INTO rmna_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","a ni lesoro Lafi na živini ana tumende, adalese so na verujinena maje, okolese kole ov bičhalđa. ");
INSERT INTO rmna_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Pažljivo sikljovena o Sveta lila, adalese so mislinena da ano lende isi tumen večno dživdipe, a on svedočinena mandar. ");
INSERT INTO rmna_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","A tumen palem na mangena te aven kora mande te ovel tumen večno dživdipe. ");
INSERT INTO rmna_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Na prihvatinava pohvala e manušendar. ");
INSERT INTO rmna_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ali me pendžarava tumen hem džanav da ana tumende nane mangipe premalo Devel. ");
INSERT INTO rmna_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Me aljum ano anav mle Dadesoro, a tumen na prihvatinena man. Ali, te alo neko aver ano plo anav, ole ka prihvatinen! ");
INSERT INTO rmna_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","A sar hem ka verujinen maje kad prihvatinena pohvala jekh averestar, a na rodena pohvala e jekhe Devlestar? ");
INSERT INTO rmna_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ma mislinen da me ka tužinav tumen anglo Dad. Tumen ka tužini o Mojsije, upra kaste nadinena tumen. ");
INSERT INTO rmna_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Adalese so, te verujinen ine e Mojsijase, ka verujinen ine hem maje, adalese so ov mandar pisinđa. ");
INSERT INTO rmna_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","A kad na verujinena ano adava so ov pisinđa, sar ka verujinen mle lafenđe?” ");
INSERT INTO rmna_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Palo adava o Isus irinđa pe ki Galileja hem dželo ki istočno strana oto e Galilejakoro jezero (vičime hem: e Tiberijakoro jezero), ");
INSERT INTO rmna_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","a palo leste džele but manuša, adalese so dikhle o čudesna znakija save ćerđa sasljarindoj e nambormen. ");
INSERT INTO rmna_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","O Isus uklinđa ki gora hem bešlo ple učenikonencar. ");
INSERT INTO rmna_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","(A avela ine paše i Pasha, e jevrejengoro prazniko.) ");
INSERT INTO rmna_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","I kad o Isus vazdinđa plo šero te dikhel, dikhlja but narodo sar avela nakoro leste, i pučlja e Filipe: “Kaj šaj te čina maro sa akale manušenđe te han?” ");
INSERT INTO rmna_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Adava o Isus pučlja e Filipe sar te čhivel le ko test, adalese so već džanđa so ka ćerel. ");
INSERT INTO rmna_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","A o Filip phenđa lese: “Ni dušel srebrna kovanice naka ovel ine dovoljno te čina sarijenđe te han barem hari.” ");
INSERT INTO rmna_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","A aver oto lesere učenici – o Andreja, o phral e Simonesoro e Petresoro – phenđa e Isusese: ");
INSERT INTO rmna_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Akatei jekh čhavoro kas isi pandž mare oto ječam hem duj tikore maćhe. Ali adava nane ništa zako sa edobor manuša.” ");
INSERT INTO rmna_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","O Isus phenđa: “Čhiven e manušen te bešen.” A ko adava than inele but čar, hem tegani đi ko pandž hiljade murša bešle. ");
INSERT INTO rmna_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Tegani o Isus lelja okola mare, zahvalinđa e Devlese, i dinđa len e manušenđe kola bešle, a ađahar ćerđa hem e maćhencar. I sare hale edobor kobor mangle. ");
INSERT INTO rmna_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Kad sare čalile, o Isus phenđa ple učenikonenđe: “Čeden sa okolestar so ačhilo oto hajba, te na frdel pe ništa.” ");
INSERT INTO rmna_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","I on čedinde sa adava so ačhilo oto pandž mare oto ječam save o manuša hale, hem adaleja pherde dešu duj korpe. ");
INSERT INTO rmna_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Kad o manuša dikhle o čudesno znako savo o Isus ćerđa, phende: “Akavai čače o Proroko savo valjani te avel ko sveto!” ");
INSERT INTO rmna_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","A o Isus džanđa so on inele spremna ki zor te čhiven le te ovel lengoro caro, i palem cidinđa pe ki gora, korkoro. ");
INSERT INTO rmna_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kad lelja te raćol, lesere učenici huljile đi ko jezero, ");
INSERT INTO rmna_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","đerdinde ko čamco hem lelje te džan prekalo jezero, nakori diz Kafarnaum. Već peli i rat, a o Isus pana na alo ine koro lende. ");
INSERT INTO rmna_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","I lelja te phudel jekh zorali barval hem upro jezero vazdinde pe o talasija. ");
INSERT INTO rmna_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Kad veslinde sar pandž đi ko šov kilometarija, dikhle e Isuse sar phirela upro pani hem avela nakoro čamco, hem darandile. ");
INSERT INTO rmna_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","A o Isus phenđa lenđe: “Me injum. Ma daran!” ");
INSERT INTO rmna_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tegani on lelje le peja ano čamco, i o čamco otojekhvar inele ki phuv nakori savi plovinde. ");
INSERT INTO rmna_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Tejsato dive o manuša kola ačhile ki aver strana oto jezero setinde pe so adari inele samo jekh čamco hem da o Isus na đerdinđa ano čamco ple učenikonencar, nego da on džele korkore. ");
INSERT INTO rmna_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","A nesave čamcija tari diz Tiberijada resle paše uzalo than kaj o Gospod zahvalinđa e Devlese zako maro hem dinđa len te han. ");
INSERT INTO rmna_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Kad o manuša dikhle da adari nane ni o Isus ni lesere učenici, čhivde pe ano čamcija hem džele ko Kafarnaum te roden le. ");
INSERT INTO rmna_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","A kad arakhle le ki aver strana oto jezero, pučle le: “Učitelju, kad aljan akari?” ");
INSERT INTO rmna_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","O Isus phenđa lenđe: “Čače, čače vaćerava tumenđe, tumen na rodena man adalese so haliljen o čudesna znakija, nego adalese so haljen o maro hem čaliljen. ");
INSERT INTO rmna_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ćeren buti, ali na zako hajba savo nakhela, nego zako hajba savo trajini zako večno dživdipe, a adava ka dav tumen me, o Čhavo e manušesoro, adalese so o Devel o Dad dinđa man vlast zako adava.” ");
INSERT INTO rmna_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Tegani pučle le: “So valjani te ćera sar te šaj ćera o buća save o Devel rodela amendar?” ");
INSERT INTO rmna_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","A o Isus phenđa lenđe: “Akavai i buti savi o Devel rodela tumendar te ćeren: te verujinen ano okoleste kole ov bičhalđa.” ");
INSERT INTO rmna_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Tegani pučle le: “Savo, onda, čudesno znako tu ka mothove amenđe, te šaj dikha hem te verujina će? So ka ćere? ");
INSERT INTO rmna_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Amare pradada ani pustinja hale o maro vičime mana, sar soi pisime ano Sveta lila: ‘Dinđa len maro taro nebo te han.’” ");
INSERT INTO rmna_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","O Isus phenđa lenđe: “Čače, čače vaćerava tumenđe, na dinđa tumen o Mojsije maro taro nebo, nego mlo Dad. Hem akana dela tumen e čačipnasoro maro taro nebo. ");
INSERT INTO rmna_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Adalese so, e Devlesoroi maro okova kova huljela taro nebo hem dela dživdipe e svetose.” ");
INSERT INTO rmna_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tegani phende lese: “Gospode, de amen uvek adava maro.” ");
INSERT INTO rmna_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","A o Isus phenđa lenđe: “Me injum o maro savo dela dživdipe. Ko avela kora mande, naka ovel bokhalo, hem ko verujini ana mande, nikad naka ovel žedno. ");
INSERT INTO rmna_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ali, sar so phenđum tumenđe, dikhljen man, a palem na verujinena. ");
INSERT INTO rmna_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Sarijen kolen mlo Dad dela man, ka aven kora mande hem esavken nikad naka ispudinav. ");
INSERT INTO rmna_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Adalese so me na huljiljum taro nebo te ćerav mli volja, nego i volja Okolesiri kova bičhalđa man. ");
INSERT INTO rmna_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","A akajai i volja Okolesiri kova bičhalđa man: te na našalav nijekhe okolendar kolen dinđa man, nego te vazdav len taro mule ko Poslednjo dive. ");
INSERT INTO rmna_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Adalese soi akaja i volja mle Dadesiri: svako kova dikhela e Čhave hem verujini ano leste, te ovel le večno dživdipe hem me te vazdav le taro mule ko Poslednjo dive.” ");
INSERT INTO rmna_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Tegani o Jevreja lelje te gunđinen protiv o Isus adalese so phenđa: “Me injum o maro savo huljilo taro nebo.” ");
INSERT INTO rmna_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Hem vaćerena ine: “Nane li akava o Isus, e Josifesoro čhavo? Amen džanaja lesere dade hem e daja. A sar akana vaćeri: ‘Huljiljum taro nebo’?” ");
INSERT INTO rmna_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","A o Isus phenđa lenđe: “Ma gunđinen maškara tumende! ");
INSERT INTO rmna_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nijekh našti te avel kora mande te o Dad kova bičhalđa man na privucini le, a me ole ka vazdav taro mule ko Poslednjo dive. ");
INSERT INTO rmna_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Sar so pisinde o Proroci: ‘Sare ka oven sikavde e Devlestar.’ Svako kova šunđa e Dade hem siklilo olestar, avela kora mande. ");
INSERT INTO rmna_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Niko na dikhlja e Dade sem okoleste kova alo olestar – ov dikhlja e Dade. ");
INSERT INTO rmna_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Čače, čače vaćerava tumenđe: Svako kova verujini ana mande, isi le večno dživdipe. ");
INSERT INTO rmna_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Me injum o maro savo dela dživdipe. ");
INSERT INTO rmna_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Tumare pradada hale mana ki pustinja, ali sare mule. ");
INSERT INTO rmna_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ali akava maro savo huljela taro nebo esavkoi da ko hala lestar na merela. ");
INSERT INTO rmna_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Me injum o dživdo maro savo huljilo taro nebo. Ko ka hal akava maro, večno ka živini. Akavai maro mlo telo, savo ka dav te šaj o manuša taro sveto živinen.” ");
INSERT INTO rmna_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Tegani o Jevreja lelje zorale te raspravinen pe maškara pumende, pučindoj: “Sar akava manuš šaj te del amen plo telo te ha?” ");
INSERT INTO rmna_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","A o Isus phenđa lenđe: “Čače, čače vaćerava tumenđe: Te na hana o telo e Manušesere Čhavesoro hem te na pijena lesoro rat, nane tumen dživdipe ana tumende. ");
INSERT INTO rmna_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ko hala mlo telo hem pijela mlo rat, isi le večno dživdipe hem me ka vazdav le taro mule ko Poslednjo dive. ");
INSERT INTO rmna_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Adalese soi mlo telo čačikano hajba hem mlo rat čačikano piba. ");
INSERT INTO rmna_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Okova kova hala mlo telo hem pijela mlo rat, ačhola ana mande hem me ano leste. ");
INSERT INTO rmna_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Sar so man bičhalđa o dživdo Dad, hem me živinava zbog o Dad, ađahar hem okova kova hala man ka živini zbog mande. ");
INSERT INTO rmna_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Me injum adava maro savo huljilo taro nebo, a na sar okova savo hale tumare pradada ani pustinja hem mule. Ko hala akava maro, večno ka živini.” ");
INSERT INTO rmna_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","O Isus sa akava vaćerđa sikavindoj e manušen ani sinagoga ano Kafarnaum. ");
INSERT INTO rmna_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","But lesere učenici, kad šunde adava, phende: “Adalai but phare lafija. Ko šaj te prihvatini len?” ");
INSERT INTO rmna_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","A o Isus korkoro pestar džanđa da lesere učenici gunđinena zbog olesere lafija, i phenđa lenđe: “Akava li sikaviba ćerela tumen te odustajinen? ");
INSERT INTO rmna_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","A so onda ka phenen te dikhljen man, e Čhave e manušesere, sar džava upre ko nebo, adari kaj injumle angleder? ");
INSERT INTO rmna_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","O Duho dela dživdipe, a o telo ništa na dela. O lafija save me phenđum tumenđe, oni duho hem dživdipe. ");
INSERT INTO rmna_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","A palem isi nesave maškara tumende kola na verujinena.” O Isus phenđa adava adalese so pana oto početak džanđa kolai adala so naka verujinen ano leste hem kovai adava so ka izdajini le. ");
INSERT INTO rmna_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Hem phenđa: “Adalese phenđum tumenđe da nijekh našti te avel kora mande te nane lese dindo e Dadestar.” ");
INSERT INTO rmna_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tegani but lesere učenici cidinde pe olestar hem na džele više palo leste. ");
INSERT INTO rmna_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","I o Isus pučlja e dešu duje učenikonen: “Na li hem tumen mangena te džan mandar?” ");
INSERT INTO rmna_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","A o Simon o Petar phenđa lese: “Gospode, kaste te dža? Te lafija dena večno dživdipe, ");
INSERT INTO rmna_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","hem amen poverujinđam hem džanaja da tu injan o Sveco e Devlesoro.” ");
INSERT INTO rmna_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","A o Isus phenđa lenđe: “Na li me birinđum tumen e dešu dujen? A palem, jekhi tumendar beng!” ");
INSERT INTO rmna_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Adava vaćerđa e Judastar, e Simonesere e Iskariotesere čhavestar, jekhestar e dešu duje učenikonendar, kova ka izdajini le. ");
INSERT INTO rmna_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Palo adava o Isus džala ine maškari regija Galileja. Na manglja te džal ki regija Judeja, adalese so e jevrejengere vođe adari mangle te mudaren le. ");
INSERT INTO rmna_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","A avela ine paše e jevrejengoro Prazniko Senica, ");
INSERT INTO rmna_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","i e Isusesere phralja phende lese: “Ikljov akatar hem dža ki Judeja, te šaj dikhen te učenici o čudesija save ćereja. ");
INSERT INTO rmna_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Adalese so, nijekh kova mangela te ovel pendžarutno, na garaj pe. Kad već ćereja esavke čudesija, mothov tut e svetose.” ");
INSERT INTO rmna_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Adalese so čak ni lesere phralja na verujinde ano leste. ");
INSERT INTO rmna_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","A o Isus phenđa lenđe: “Mlo vreme pana na alo, a tumen šaj te džan kad god mangena. ");
INSERT INTO rmna_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","O sveto našti te mrzini tumen, ali man mrzini, adalese so svedočinava protiv oleste, dai lesere delja bišukar. ");
INSERT INTO rmna_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Džan tumen zako prazniko, a me pana na džava adari, adalese so mlo vreme pana na alo.” ");
INSERT INTO rmna_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Adava phenđa lenđe hem ačhilo ani Galileja. ");
INSERT INTO rmna_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","A kad lesere phralja džele te slavinen o prazniko, dželo hem ov, ali na javno, nego garandoj. ");
INSERT INTO rmna_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","A e jevrejengere vođe zako prazniko rodinde le hem pučle: “Kaj okova?” ");
INSERT INTO rmna_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Maškaro narodo but vaćerđa pe olestar. Nesave vaćerena ine: “Ovi šukar manuš”, dok avera nesave vaćerena: “Nane, prevarini e narodo.” ");
INSERT INTO rmna_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ali nijekh na vaćerđa olestar javno, adalese so darandile e jevrejengere vođendar. ");
INSERT INTO rmna_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","A ko ekvaš o prazniko, o Isus dželo ko Hram hem lelja te sikaj e narodo. ");
INSERT INTO rmna_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Kad šunde le, e jevrejengere vođe začudinde pe, i pučle pe: “Sar akava edobor šukar džanel o Sveta lila, a nikad na inele sikavdo?” ");
INSERT INTO rmna_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","A o Isus phenđa lenđe: “Mlo sikaviba na avela mandar, nego Okolestar kova bičhalđa man. ");
INSERT INTO rmna_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ko mangela te ćerel e Devlesiri volja, ka džanel avela li akava sikaviba Olestar ili me vaćerava korkoro mandar. ");
INSERT INTO rmna_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ko vaćeri korkoro pestar, pese rodela slava. A ko rodela slava okolese kova bičhalđa le, vaćeri o čačipe hem koro leste nane hovajba. ");
INSERT INTO rmna_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Na li o Mojsije dinđa tumen o Zakoni? A palem nijekh tumendar na ćerela palo Zakoni! Sose mangena te mudaren man?” ");
INSERT INTO rmna_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","O manuša phende: “Ana tute isi demoni! Ko mangela te mudari tut?” ");
INSERT INTO rmna_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","A o Isus phenđa lenđe: “Ćerđum jekh čudo hem sare divinena tumen. ");
INSERT INTO rmna_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","O Mojsije dinđa tumen o obreziba hem adalese tumen e čhavore obrezinena čak hem ko savato. Iako adava na avela e Mojsijastar, nego pana e pradadendar. ");
INSERT INTO rmna_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","I, te o manuš šaj te ovel obrezime ko savato, sar te na ovel phago e Mojsijasoro zakoni, sose edobor holjanena upra mande so ko savato sasljarđum sa o telo e manušesoro? ");
INSERT INTO rmna_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ma sudinen palo spoljašnjost, nego sudinen pravedno.” ");
INSERT INTO rmna_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Tegani nesave manuša taro Jerusalim vaćerde: “Nane li akava okova kole dikhena te mudaren? ");
INSERT INTO rmna_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","A ače, ov javno vaćeri hem niko lafi na phenela lese. Te na halile amare šerutne dai ov čače o Hrist? ");
INSERT INTO rmna_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ali amen džanaja kotari ov, a kad o Hrist ka avel, niko naka džanel kotari.” ");
INSERT INTO rmna_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","I sar o Isus sikaj ine ano Hram, vičinđa: “Oja, pendžarena man! Hem džanen kotar injum! Na aljum korkoro mandar. Ali, čačikanoi Okova kova bičhalđa man, kole tumen na pendžarena. ");
INSERT INTO rmna_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","A me pendžarava le, adalese so me injum olestar hem Ov bičhalđa man.” ");
INSERT INTO rmna_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Tegani on mangle te dolen le, ali niko na čhivđa plo vas upro leste, adalese so lesoro vreme pana na alo. ");
INSERT INTO rmna_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","A but džene taro narodo poverujinde ano leste, i phende: “O Hrist li, kad ka avel, ka ćerel više čudesna znakija nego so ćerđa len akava?” ");
INSERT INTO rmna_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","O fariseja šunde so o manuša adava garandoj vaćerena e Isusestar, i on hem o šerutne sveštenici bičhalde nesave stražaren te dolen le. ");
INSERT INTO rmna_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Tegani o Isus phenđa: “Pana hari ka ovav tumencar, a onda ka irinav man Okoleste kova bičhalđa man. ");
INSERT INTO rmna_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ka roden man, ali naka arakhen man, hem tumen našti te aven adari kaj me ka ovav.” ");
INSERT INTO rmna_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Tegani e jevrejengere vođe vaćerde maškara pumende: “Kaj adava ov mislini te džal, a te našti amen te arakha le? Na li mislini te džal koro Jevreja kolai rasejime maškaro Grci hem te sikaj e Grkonen? ");
INSERT INTO rmna_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","So manglja te vaćeri adaleja kad phenđa: ‘Ka roden man, ali naka arakhen man’, hem: ‘Tumen našti te aven adari kaj me ka ovav’?” ");
INSERT INTO rmna_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Kad inele o zadnjo hem o najbitno dive e praznikosoro, o Isus uštino ko pre hem vičindoj phenđa: “Tei neko žedno, nek avel mande hem nek pijel! ");
INSERT INTO rmna_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ko verujini ana mande, sar so vaćeri o Sveto lil, olestar ka thavden o lenja e dživde panjesoro.” ");
INSERT INTO rmna_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","A o Isus adava vaćerđa e Svetone Duhostar, kole valjande te priminen okola kola verujinena ano leste. Adalese so, tegani o Sveto Duho pana na inele dindo, adalese so o Isus pana na irinđa pe pese ani slava. ");
INSERT INTO rmna_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Kad šunde akala lafija, but džene taro narodo phende: “Akavai čače o Proroko kole adžićeraja.” ");
INSERT INTO rmna_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","A avera phende: “Akavai o Hrist.” A, palem, nesave avera phende: “Nane. O Hrist li ka avel tari Galileja? ");
INSERT INTO rmna_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Na pisini li ano Sveto lil da o Hrist ka avel taro e Davidesoro potomstvo hem taro Vitlejem, taro gav kotari o David?” ");
INSERT INTO rmna_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","I ađahar zbog o Isus uli podela ano narodo. ");
INSERT INTO rmna_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","A nesave čak mangle te dolen le, ali niko na čhivđa plo vas upro leste. ");
INSERT INTO rmna_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","I o stražarija irinde pe koro šerutne sveštenici hem koro fariseja, a on pučle len: “Sose na anđen e Isuse?” ");
INSERT INTO rmna_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","A o stražarija phende: “Niko nikad ađahar na vaćerđa sar adava manuš.” ");
INSERT INTO rmna_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","A o fariseja phende lenđe: “Hem tumen li prevarinđa? ");
INSERT INTO rmna_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Na li neko e šerutnendar ili e farisejendar poverujinđa ano leste? Na. ");
INSERT INTO rmna_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nego, akavai narodo prokleto, adalese so na pendžari o Zakoni!” ");
INSERT INTO rmna_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Tegani o Nikodim, okova kova angleder inele koro Isus, kovai jekh olendar, pučlja len: ");
INSERT INTO rmna_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Amaro li Zakoni mukela amenđe te osudina e manuše angleder nego so šunaja le hem dikhaja so ćerđa?” ");
INSERT INTO rmna_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","A on phende lese: “Te na injan hem tu tari Galileja? Rode ano Sveto lil hem ka dikhe da nijekh proroko na avela tari Galileja!” ");
INSERT INTO rmna_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","I tegani sare dželefse čhere. ");
INSERT INTO rmna_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","A o Isus dželo ki e Maslinakiri gora, ");
INSERT INTO rmna_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","i rano sabale palem alo ano Hram. I sare čedinde pe uzalo leste, a ov beštino hem lelja te sikaj len. ");
INSERT INTO rmna_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","A o učitelja e Zakonestar hem o fariseja ande koro Isus jekha đuvlja koja inele dolimi ani preljuba. Čhivde la ko maškar, ");
INSERT INTO rmna_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","hem phende lese: “Učitelju, akajai đuvli dolimi kad ćerđa preljuba. ");
INSERT INTO rmna_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ano e Mojsijasoro zakoni terđola da esavka valjani te mudara ađahar so ka frda bara upro late. A so tu pheneja ko adava?” ");
INSERT INTO rmna_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","On adava pučle le te iskušinen le, sar te ovel len zako sose te optužinen le. A o Isus telilo hem lelja te pisini najeja ki phuv. ");
INSERT INTO rmna_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ali, adalese so na ačhavde te pučen le adava, ov ispravinđa pe, i phenđa lenđe: “Kovai tumendar bizo greh, prvo nek frdel bar upro late.” ");
INSERT INTO rmna_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Hem palem telilo hem pisinđa ki phuv. ");
INSERT INTO rmna_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Kad on šunde adava, jekh po jekh lelje te ciden pe adathar, počindoj e najphurederendar. I ađahar ačhile samo o Isus hem i đuvli koja terdini ko maškar. ");
INSERT INTO rmna_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Tegani o Isus ispravinđa pe hem pučlja la: “Đuvlije, kaj akala? Nijekh li olendar na osudinđa tut?” ");
INSERT INTO rmna_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","A oj phenđa lese: “Nijekh, gospodarona.” Tegani o Isus phenđa laće: “Ni me na osudinava tut. Dža, hem od akana ma grešin više!” ");
INSERT INTO rmna_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Tegani o Isus palem phenđa e manušenđe: “Me injum o svetlost e svetose. Ko džala pala mande, nikad naka phirel ani tomina, nego ka ovel le svetlost e dživdipnasoro.” ");
INSERT INTO rmna_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Tegani o fariseja phende lese: “Tu korkoro tutar svedočineja. To svedočiba nane dovoljno.” ");
INSERT INTO rmna_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","O Isus phenđa lenđe: “Čak hem te svedočinava korkoro mandar, mloi vaćeriba dovoljno, adalese so džanav kotar aljum hem kaj džava. A tumen na džanen ni kotar aljum ni kaj džava. ");
INSERT INTO rmna_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Tumen sudinena telesno, a me na sudinava nikas. ");
INSERT INTO rmna_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","A hem te sudinđum, mloi sudo čačikano, adalese so na injum korkoro, negoi mancar o Dad kova bičhalđa man. ");
INSERT INTO rmna_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Čak hem ano tumaro Zakoni pisini dai o svedočiba dovoljno te duj svedoci vaćerena isto. ");
INSERT INTO rmna_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Me svedočinava korkoro mandar, a mandar svedočini hem o Dad, kova bičhalđa man.” ");
INSERT INTO rmna_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","A o fariseja pučle le: “Kaj to dad?” O Isus phenđa lenđe: “Tumen na džanen ni man ni mle Dade. Te džanen ine ko injum me, ka džanen ine hem mle Dade.” ");
INSERT INTO rmna_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Sa adava o Isus vaćerđa uzalo kutije zako čediba o pare sar sikaj ine e manušen ano Hram, hem niko na dolinđa le, adalese so lesoro vreme pana na alo. ");
INSERT INTO rmna_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","O Isus palem phenđa lenđe: “Me džava, a tumen ka roden man, hem ka meren ano tumaro greh. Kaj me džava, tumen našti te aven.” ");
INSERT INTO rmna_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Tegani e jevrejengere vođe phende: “Na li akava mangela te mudari pe kad phenela: ‘Kaj me džava, tumen našti te aven’?” ");
INSERT INTO rmna_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","A o Isus phenđa lenđe: “Tumen injen telal, a me injum upral. Tumen injen taro akava sveto, a me na injum taro akava sveto. ");
INSERT INTO rmna_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Adalese phenđum tumenđe da ka meren ano tumare grehija. Te na verujinđen da Me Injum, ka meren ano tumare grehija.” ");
INSERT INTO rmna_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","On pučle le: “Ko injan tu?” A o Isus phenđa lenđe: “Me injum okova so pana taro anglunipe vaćerava tumenđe da injum. ");
INSERT INTO rmna_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Isi man but so te vaćerav tumendar ki tumari osuda. Okova kova bičhalđa man čačikanoi hem me e svetose vaćerava samo okova so olestar šunđum.” ");
INSERT INTO rmna_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","On na halile da vaćeri lenđe e Dadestar. ");
INSERT INTO rmna_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Adalese o Isus phenđa lenđe: “Kad ka vazden e Čhave e manušesere, tegani ka džanen da Me Injum hem da ništa na ćerava korkoro mandar, nego da vaćerava okova so sikavđa man o Dad. ");
INSERT INTO rmna_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","A okova kova bičhalđa man, ovi mancar. Na ačhavđa man korkore, adalese so uvek ćerava okova soi lese šukar.” ");
INSERT INTO rmna_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","I sar vaćeri ine adava, but džene poverujinde ano leste. ");
INSERT INTO rmna_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Tegani o Isus phenđa e Jevrejenđe kola poverujinde ano leste: “Te ićerena tumen ko mlo sikaviba, čače injen mle učenici. ");
INSERT INTO rmna_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ka pendžaren o čačipe, hem o čačipe ka oslobodini tumen.” ");
INSERT INTO rmna_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","A on phende lese: “Amen injam e Avraamesere potomci, hem nikad na injamle nikasere robija. Sar šaj te phene: ‘Ka oven slobodna’?” ");
INSERT INTO rmna_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","O Isus phenđa lenđe: “Čače, čače phenava tumenđe, svako kova ćerela greh, ovi robo e grehese. ");
INSERT INTO rmna_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","E robo nane than ani familija zauvek, a e čhave isi zauvek. ");
INSERT INTO rmna_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Adalese, te o Čhavo oslobodini tumen, čače ka oven slobodna. ");
INSERT INTO rmna_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Džanav da injen e Avraamesere potomci, a palem, tumen mangena te mudaren man, adalese so ana tumende nane than mle lafese. ");
INSERT INTO rmna_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Me vaćerava tumenđe okova so dikhljum koro mlo Dad, ali tumen ćerena okova so šunđen tumare dadestar.” ");
INSERT INTO rmna_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","On phende lese: “Amaroi dad o Avraam.” A o Isus phenđa lenđe: “Te oven ine e Avraamesere čhave, ka ćeren ine okova so ov ćerđa. ");
INSERT INTO rmna_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ali tumen akana mangena te mudaren man, e manuše kova vaćerđa tumenđe o čačipe savo šunđa e Devlestar. O Avraam na ćerđa ađahar. ");
INSERT INTO rmna_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Tumen ćerena okova so ćerela hem tumaro dad.” A on phende lese: “Amen na injam bijande tari preljuba. Jekh dad isi amen, adavai o Devel!” ");
INSERT INTO rmna_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","A o Isus phenđa lenđe: “Te ovel ine o Devel tumaro dad, ka volinen man ine, adalese so me aljum taro Devel hem akana injum akate. Na aljum korkoro mandar, nego ov bičhalđa man. ");
INSERT INTO rmna_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Sose na haljovena okova so vaćerava tumenđe? Adalese so našti te prihvatinen mlo lafi. ");
INSERT INTO rmna_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Tumaroi dad o beng hem mangena te ćeren palo tumare dadesere želje. Ovi taro anglunipe ubica hem na ićerđa pe ko čačipe, adalese so ano leste nane čačipe. Kad hovaj, ov mothoj plo pravo muj, adalese soi hovavno hem dad e hovajbnasoro. ");
INSERT INTO rmna_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","A adalese so vaćerava tumenđe o čačipe, tumen na verujinena maje. ");
INSERT INTO rmna_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Kova tumendar šaj te dokažini mlo greh? Te vaćerava tumenđe o čačipe, sose na verujinena maje? ");
INSERT INTO rmna_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Kovai e Devlestar, šunela e Devlesere lafija. Tumen na šunena len adalese so na injen e Devlestar.” ");
INSERT INTO rmna_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","O Jevreja phende lese: “Na li amen šukar phenđam da tu injan Samarijanco hem da injan opsednutime demoneja?” ");
INSERT INTO rmna_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","O Isus phenđa lenđe: “Na injum me opsednutime demoneja, nego me poštujinava mle Dade, a tumen man na poštujinena. ");
INSERT INTO rmna_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Me na rodava slava maje – isi neko ko rodela la maje hem ko sudini. ");
INSERT INTO rmna_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Čače, čače vaćerava tumenđe: ko ićeri pe ko mle lafija, nikad naka dikhel o meriba.” ");
INSERT INTO rmna_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","A o Jevreja phende lese: “Akana džanaja da injan opsednutime demoneja. O Avraam mulo, a ađahar hem o proroci, a tu vaćereja: ‘Ko ićeri pe ko mle lafija, nikad naka dikhel o meriba.’ ");
INSERT INTO rmna_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Na injan valjda po baro amare dadestar e Avraamestar, kova mulo. A hem o proroci da mule. Ko mislineja da tu injan?” ");
INSERT INTO rmna_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","O Isus phenđa lenđe: “Te me korkore man proslavinava, mli slava nane ništa. Man proslavini mlo Dad, kolese tumen vaćerena dai tumaro Devel. ");
INSERT INTO rmna_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Tumen na džanen le, ali me džanav le. Te phenav da na džanav le, ka ovav ine hovavno sar tumen. Ali me džanav le hem ićerava man ko lesoro lafi. ");
INSERT INTO rmna_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tumaro dad o Avraam but radujinđa pe so ka dikhel o dive oto mlo aviba. Dikhlja le hem but radujinđa pe.” ");
INSERT INTO rmna_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Tegani o Jevreja phende lese: “Nane tut ni pinda berš, a pheneja da dikhljan e Avraame!” ");
INSERT INTO rmna_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","O Isus phenđa lenđe: “Čače, čače vaćerava tumenđe: angleder nego so o Avraam bijandilo, Me Injum!” ");
INSERT INTO rmna_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tegani on lelje bara te frden upro leste, ali o Isus garavđa pe olendar hem iklilo taro Hram. ");
INSERT INTO rmna_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Sar nakhela ine adathar, o Isus dikhlja e manuše kova inele kororo taro bijandipe. ");
INSERT INTO rmna_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","A lesere učenici pučle le: “Učitelju, sose akava manuš bijandilo kororo? Adalese so ov ćerđa greh ili lesoro dad hem i daj?” ");
INSERT INTO rmna_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","A o Isus phenđa: “Nane kororo adalese so grešinđa ov ili lesoro dad ili i daj. Ov bijando kororo te šaj upro leste mothoj pe o delja e Devlesere zoralipnastar. ");
INSERT INTO rmna_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Sari dive, valjani te ćera o delja Okolesere kova bičhalđa man. Avela i rat, kad niko našti te ćerel buti. ");
INSERT INTO rmna_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Sar injum ko sveto, me injum svetlost e svetose.” ");
INSERT INTO rmna_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Kad adava phenđa, čhungarđa ki phuv hem oto čhungar ćerđa čik, i adala čikaja makhlja e kororesere jaćha. ");
INSERT INTO rmna_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Tegani o Isus phenđa lese: “Dža thov to muj ko bazeni Siloam.” (Siloam značini “Bičhaldo”.) I o manuš dželo, thovđa plo muj hem irinđa pe čhere dikhindoj. ");
INSERT INTO rmna_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","A lesere komšije hem okola kola angleder džande le sar prosjako, pučle pe: “Nane li akava okova kova bešela ine hem prosini?” ");
INSERT INTO rmna_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Nesave phende: “Ovi adava”, a avera phende: “Nane, nego samo ličini upro leste.” A ov phenđa: “Me injum.” ");
INSERT INTO rmna_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Tegani on pučle le: “Sar phravdile te jaćha?” ");
INSERT INTO rmna_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","A ov phenđa: “O manuš kova vičini pe Isus, ćerđa čik hem olaja makhlja mle jaćha, hem phenđa maje: ‘Dža ko Siloam hem thov to muj.’ I me dželjum, thovđum mlo muj hem leljum te dikhav.” ");
INSERT INTO rmna_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","On pučle le: “Kaj akana adava manuš?” A ov phenđa lenđe: “Na džanav.” ");
INSERT INTO rmna_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Tegani e manuše kova angleder inele kororo ande koro fariseja. ");
INSERT INTO rmna_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","A adava dive kad o Isus ćerđa i čik hem phravđa e kororesere jaćha inele savato. ");
INSERT INTO rmna_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Adalese hem o fariseja pučle le sar phravdile lesere jaćha. A ov phenđa lenđe: “Makhlja mle jaćha e čikaja, me thovđum mlo muj hem akana dikhava.” ");
INSERT INTO rmna_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Tegani nesave fariseja phende: “Adava manuš nane e Devlestar, adalese so ćerela buti ko savato.” A avera phende: “Sar šaj o grešniko te ćerel esavke čudesna znakija?” Hem ađahar maškaro fariseja uli podela. ");
INSERT INTO rmna_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","I palem phende e kororese: “Adava manuš phravđa te jaćha. So tu mislineja olestar?” A ov phenđa: “Ovi proroko.” ");
INSERT INTO rmna_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ali e jevrejengere vođe na verujinde da o manuš inele kororo hem da phravdile lesere jaćha sa đikote na vičinde lesere dade hem e daja. ");
INSERT INTO rmna_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","I pučle len: “Akava li tumaro čhavo kolese phenena da bijandilo kororo? Sar onda akana dikhela?” ");
INSERT INTO rmna_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","A lesoro dad hem i daj phende: “Džanaja dai akava amaro čhavo hem da bijandilo kororo. ");
INSERT INTO rmna_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ali, sar onda akana dikhela hem ko phravđa lesere jaćha, na džanaja. Ole pučen. Ovi beršalo hem šaj te vaćeri korkoro pese.” ");
INSERT INTO rmna_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Lesoro dad hem i daj phende adava, adalese so darandile e jevrejengere vođendar, adalese so e jevrejengere vođe već odlučinde ine tari sinagoga te ikalen đijekhe kova priznajini e Isuse sar Hriste. ");
INSERT INTO rmna_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Adalese lesoro dad hem i daj phende: “Ovi beršalo. Ole pučen!” ");
INSERT INTO rmna_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Tegani pana jekhvar vičinde e manuše kova inele kororo, i phende lese: “Obećin anglo Devel da ka vaćere o čačipe! Amen džanaja dai adava manuš grešniko.” ");
INSERT INTO rmna_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","A ov phenđa lenđe: “Me na džanav da li ov grešniko. Džanav samo da injumle kororo, a akana dikhava.” ");
INSERT INTO rmna_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","A on palem pučle le: “So ćerđa će? Sar phravđa te jaćha?” ");
INSERT INTO rmna_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","A ov phenđa lenđe: “Adava već phenđum tumenđe, ali na šunđen man. Sose palem mangena adava te šunen? Na li hem tumen mangena te oven lesere učenici?” ");
INSERT INTO rmna_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tegani on lelje te vređinen le hem phende lese: “Tu injan lesoro učeniko, a amen injam e Mojsijasere učenici. ");
INSERT INTO rmna_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Amen džanaja da o Devel vaćerđa e Mojsijase, a akalese na džanaja ni kotari.” ");
INSERT INTO rmna_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","A o sasljardo manuš phenđa lenđe: “Čačei čudno akava! Tumen na džanen kotari, a ov phravđa mle jaćha. ");
INSERT INTO rmna_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Džanaja da o Devel na šunela e grešnonen, ali šunela okolen kolai pobožna hem kola ćerena lesiri volja. ");
INSERT INTO rmna_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Niko nikad na šunđa da neko phravđa o jaćha e manušesere kova bijandilo kororo. ");
INSERT INTO rmna_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Te na ovel ine e Devlestar, naka šaj ine ništa te ćerel.” ");
INSERT INTO rmna_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","A on phende lese: “Tu kova bijandiljan sa ano grehija arakhljan amen te sikaven!” Hem frdinde le tari sinagoga. ");
INSERT INTO rmna_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","O Isus šunđa so e sasljarde manuše frdinde tari sinagoga, i arakhlja le hem pučlja le: “Verujineja li ano Čhavo e manušesoro?” ");
INSERT INTO rmna_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","A ov phenđa lese: “Phen maje koi ov, Gospode, te šaj verujinav ano leste.” ");
INSERT INTO rmna_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","O Isus phenđa lese: “Već dikhljan le. Adavai okova kova vaćeri tuja.” ");
INSERT INTO rmna_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Tegani ov phenđa: “Verujinava, Gospode.” I pelo ko kočija anglo Isus. ");
INSERT INTO rmna_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","O Isus phenđa lese: “Me aljum ko akava sveto te šaj e svetose ovel sudime, te šaj dikhen okola kola na dikhena hem te ačhoven korore okola kola mislinena da dikhena.” ");
INSERT INTO rmna_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Nesave fariseja kola inele oleja šunde adava, i pučle le: “Te na injam hem amen korore?” ");
INSERT INTO rmna_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","A o Isus phenđa lenđe: “Te priznajinen ine da injen korore, naka oven ine kriva zako greh. Ali, adalese so phenena da dikhena, tumari krivica ačhola upra tumende.” ");
INSERT INTO rmna_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Čače, čače vaćerava tumenđe, ko na đerdini ko udar kotei ogradime e bakrenđe, nego preskočindoj đerdini, ovi čor hem razbojniko. ");
INSERT INTO rmna_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","A ko đerdini ko udar, ovi e bakrengoro pastiri. ");
INSERT INTO rmna_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Olese o stražari phravela o udar, a o bakre šunena lesoro glaso. Ov ple bakren vičini palo anav hem ikali len avri. ");
INSERT INTO rmna_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Kad ikali sa ple bakren, džala anglo lende, a o bakre džana palo leste, adalese so pendžarena lesoro glaso. ");
INSERT INTO rmna_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Naka džan palo abanđija, nego ka našen olestar, adalese so na pendžarena o glaso e abanđijasoro.” ");
INSERT INTO rmna_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","O Isus vaćerđa lenđe adaja priča, ali on na halile so manglja te phenel lenđe adaleja. ");
INSERT INTO rmna_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Adalese o Isus palem vaćerđa lenđe: “Čače, čače, vaćerava tumenđe, me injum o udar e bakrenđe. ");
INSERT INTO rmna_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Sare kola ale angleder mande, oni čora hem razbojnici, ali o bakre na šunde len. ");
INSERT INTO rmna_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Me injum o udar. Ko đerdini prekala mande, ka ovel spasime. Ka đerdini hem ka ikljol hem ka arakhi hajbnase. ");
INSERT INTO rmna_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","O čor avela samo te čorel, te mudari hem te uništini. Me aljum e manušen te ovel dživdipe, hem adava dživdipe ano izobilje. ");
INSERT INTO rmna_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Me injum o šukar pastiri. O šukar pastiri dela plo dživdipe zako bakre. ");
INSERT INTO rmna_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","A o manuš kovai platime te pazini e bakren – adalese so nane pastiri hem o bakre nane olesere – kad dikhela e ruve sar avela, ačhaj e bakren hem našela. A o ruv napadini e bakren hem ćerela len te našen ko sa o strane. ");
INSERT INTO rmna_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Adalese soi samo platime manuš, olese na ačhilo đi o bakre. ");
INSERT INTO rmna_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Me injum o šukar pastiri. Me pendžarava mle bakren hem mle bakre pendžarena man, ");
INSERT INTO rmna_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ađahar sar so o Dad pendžari man hem sar so me pendžarava e Dade. Me dava mlo dživdipe zako bakre. ");
INSERT INTO rmna_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Isi man hem avera bakre, kola nane taro akava stado; hem olen valjani te anav. Hem on ka šunen mlo glaso, i ka ovel jekh stado jekhe pastireja. ");
INSERT INTO rmna_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Adalese mlo Dad volini man, so dava mlo dživdipe – te šaj palem te lav le. ");
INSERT INTO rmna_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Niko na lela le mandar, nego me korkoro mandar dava le. Isi man vlast te dav le hem isi man vlast palem te lav le. Adaja naredba priminđum mle Dadestar.” ");
INSERT INTO rmna_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Zbog akala lafija maškaro Jevreja palem uli podela. ");
INSERT INTO rmna_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","But Jevreja phende: “Ovi opsednutime demoneja hem dilindilo. Sose šunena le?” ");
INSERT INTO rmna_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","A avera phende: “Adava nane o lafija e manušesere kovai opsednutime demoneja. Šaj li o demoni te phravel e kororengere jaćha?” ");
INSERT INTO rmna_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Tegani ano Jerusalim slavinđa pe o prazniko Hanuka, o posvećenje e Hramesoro. Inele jevend. ");
INSERT INTO rmna_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","O Isus nakhela ine maškari phravdi terasa e Solomonesiri ano Hram. ");
INSERT INTO rmna_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","A e jevrejengere vođe okružinde le hem phende lese: “Đikote ka garave amendar ko tu injan? Te injan o Hrist, phen amenđe phravdeste!” ");
INSERT INTO rmna_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","A o Isus phenđa lenđe: “Već phenđum tumenđe angleder, ali tumen na verujinena. O delja save ćerava ano anav mle Dadesoro – on svedočinena mandar. ");
INSERT INTO rmna_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ali tumen na verujinena, adalese so na injen mle bakre. ");
INSERT INTO rmna_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mle bakre šunena mlo glaso hem me pendžarava len, hem on džana pala mande. ");
INSERT INTO rmna_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Me dava len večno dživdipe hem on nikad naka meren. Niko naka čorel len mle vastendar. ");
INSERT INTO rmna_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Mlo Dad, kova dinđa man len, po baroi sarijendar, hem niko našti te čorel len mle Dadesere vastendar. ");
INSERT INTO rmna_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Me hem o Dad jekh injam.” ");
INSERT INTO rmna_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Tegani e jevrejengere vođe palem mangle te mudaren le hem lelje bara sar te frden upro leste, ");
INSERT INTO rmna_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","a o Isus phenđa lenđe: “Mothovđum tumenđe but šukar delja e Dadestar. Zako save olendar mangena te mudaren man barencar?” ");
INSERT INTO rmna_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","A o Jevreja phende lese: “Na mangaja te mudara tut barencar zako šukar delja, nego so hulineja upro Devel. Tu injan samo manuš, a pheneja da injan Devel!” ");
INSERT INTO rmna_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","O Isus phenđa lenđe: “Nane li pisime tumenđe ano zakoni: ‘Me phenđum: tumen injen develja’? ");
INSERT INTO rmna_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Te o Devel e manušen kolenđe alo o lafi e Devlesoro vičinđa develja – a o Sveto lil našti te promenini pe – ");
INSERT INTO rmna_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","sar onda šaj okolese kole o Dad posvetinđa hem bičhalđa ko sveto te phenen: ‘Hulineja’, adalese so phenđum da injum o Čhavo e Devlesoro? ");
INSERT INTO rmna_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Te na ćerava o delja mle Dadesere, ma verujinen maje. ");
INSERT INTO rmna_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ali te ćerava len, sa hem te na verujinen maje, verujinen olenđe, te džanen dai o Dad ana mande hem me ano Dad.” ");
INSERT INTO rmna_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Tegani on palem mangle te dolen le, ali ov našlo lenđe taro vasta. ");
INSERT INTO rmna_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","O Isus palem nakhlo ki aver strana oti len Jordan, ko than kaj o Jovan angleder krstini ine, hem ačhilo adari. ");
INSERT INTO rmna_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","A but manuša ale koro leste hem vaćerena ine: “O Jovan na ćerđa nijekh čudesno znako, ali čače inele sa so phenđa akale manušestar.” ");
INSERT INTO rmna_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Hem but džene adari poverujinde ano Isus. ");
INSERT INTO rmna_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Nesavo manuš palo anav Lazar inele namborme. Ov inele tari Vitanija, taro gav kaj živinde i Marija hem lakiri phen i Marta. ");
INSERT INTO rmna_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","I Marija inele okoja đuvli koja čhorđa o miris upro e Gospodesere pre hem koslja len ple balencar. O Lazar, kova inele namborme, inele lakoro phral. ");
INSERT INTO rmna_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Adalese o phenja bičhalde lafi e Isusese: “Gospode, ače, nambormei to volime amal.” ");
INSERT INTO rmna_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Kad o Isus šunđa adava, phenđa: “Akava nambormipe naka završini pe meribnaja, nego ka ovel e Devlese ki slava, te šaj prekalo adava proslavini pe o Čhavo e Devlesoro.” ");
INSERT INTO rmna_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","A o Isus volinđa e Marta, lakere phenja hem e Lazare. ");
INSERT INTO rmna_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","I kad šunđa dai o Lazar namborme, ačhilo pana duj dive adari kaj inele, ");
INSERT INTO rmna_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","i tegani phenđa ple učenikonenđe: “Hajde palem ki Judeja.” ");
INSERT INTO rmna_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","A o učenici phende lese: “Učitelju, na li e jevrejengere vođe angleder nekobor dive mangle te mudaren tut barencar, a tu palem mangeja te dža adari?” ");
INSERT INTO rmna_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","O Isus phenđa lenđe: “Nane li e dive dešu duj saća? Ko phirela diveja, na perela, adalese so dikhela o svetlost akale svetosoro. ");
INSERT INTO rmna_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ali, ko phirela raćaja, ka perel, adalese so nane svetlost ano leste.” ");
INSERT INTO rmna_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Palo adala lafija, phenđa hem akava: “Amaro amal o Lazar zasuća, ali me džava te vazdav le.” ");
INSERT INTO rmna_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","A o učenici phende lese: “Gospode, te zasuća, ka sasljol.” ");
INSERT INTO rmna_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ali o Isus vaćerđa lenđe e Lazaresere meribnastar, a on mislinde da vaćeri da o Lazar sovela. ");
INSERT INTO rmna_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Tegani o Isus phravdeste phenđa lenđe: “O Lazar mulo. ");
INSERT INTO rmna_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Zbog tumende radujinav man so na injumle adari, te šaj verujinen. Ali, hajde akana koro leste.” ");
INSERT INTO rmna_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tegani o Toma vičime Blizanco phenđa avere učenikonenđe: “Hajde hem amen te mera e Isuseja.” ");
INSERT INTO rmna_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Kad o Isus reslja adari, dodžanđa dai o Lazar štar dive već ano grobo. ");
INSERT INTO rmna_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","A i Vitanijai taro Jerusalim dur đi sar trin kilometarija, ");
INSERT INTO rmna_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","i but Jevreja adathar ale ki Marta hem ki Marija te tešinen len zbog lengoro phral. ");
INSERT INTO rmna_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Kad i Marta šunđa da o Isus avela, lelja te džal nakoro leste, a i Marija ačhili čhere. ");
INSERT INTO rmna_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Tegani i Marta phenđa e Isusese: “Gospode, te ove ine akate, mlo phral naka merel ine. ");
INSERT INTO rmna_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ali me hem akana džanav da o Devel ka del tut sa so rodeja lestar.” ");
INSERT INTO rmna_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","O Isus phenđa laće: “To phral ka uštel taro mule!” ");
INSERT INTO rmna_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","A i Marta phenđa lese: “Džanav da ka uštel taro mule tegani kad sare ka ušten taro mule ko Poslednjo dive.” ");
INSERT INTO rmna_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","O Isus phenđa laće: “Me injum o uštiba taro mule hem o dživdipe. Ko verujini ana mande, čak hem te merel, ka živini. ");
INSERT INTO rmna_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Hem svako kova živini hem verujini ana mande, nikad naka merel. Verujineja li ano adava?” ");
INSERT INTO rmna_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","A oj phenđa lese: “Oja, Gospode! Verujinava da tu injan o Hrist, o Čhavo e Devlesoro, kova valjanđa te avel ko sveto.” ");
INSERT INTO rmna_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Kad phenđa adava, dželi hem vičinđa pla phenja e Marija hem pohari phenđa laće: “Akatei o učitelj hem rodela tut.” ");
INSERT INTO rmna_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Kad i Marija šunđa adava, sig uštini hem dželi nakoro leste. ");
INSERT INTO rmna_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","A o Isus pana na đerdinđa ano gav, nego pana inele adari kaj i Marta reslja le. ");
INSERT INTO rmna_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","A kad o Jevreja kola inele e Marijaja ano čher hem tešinde la, dikhle da ki sig uštini hem iklili, lelje te džan palo late, mislindoj da džala ko grobo te rovel adari. ");
INSERT INTO rmna_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Kad i Marija resli adari kaj inele o Isus hem kad dikhlja le, peli anglo lesere pre hem phenđa lese: “Gospode, te ove ine akate, mlo phral naka merel ine.” ");
INSERT INTO rmna_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Kad o Isus dikhlja ola hem e Jevrejen kola ale olaja sar rovena, pelo lese žal hem ine lese but pharo, ");
INSERT INTO rmna_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","i pučlja len: “Kaj čhivđen le?” On phende lese: “Gospode, ava hem dikh.” ");
INSERT INTO rmna_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","A o Isus lelja te rovel. ");
INSERT INTO rmna_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Tegani o Jevreja phende: “Dikh kobor volinđa le!” ");
INSERT INTO rmna_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ali nesave olendar phende: “Našti ine li ov, kova e kororesere jaćha phravđa, te ćerel akava manuš te na merel?” ");
INSERT INTO rmna_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","I e Isusese palem ine but pharo, i dželo ko grobo. Adava inele i pećina ko savakoro udar inele pašljardo o bar. ");
INSERT INTO rmna_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","O Isus phenđa: “Ciden o bar.” A i Marta, i phen e mulesiri, phenđa lese: “Gospode, već khandela, adalese soi štarto dive sari ano grobo.” ");
INSERT INTO rmna_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","O Isus pučlja la: “Na li phenđum će da ka dikhe e Devlesiri slava te verujinđan?” ");
INSERT INTO rmna_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tegani cidinde o bar, a o Isus dikhlja nakoro nebo hem phenđa: “Dade, hvala će so šunđan man. ");
INSERT INTO rmna_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Džanav da tu uvek šuneja man, ali akava vaćerđum zbog o manuša kola akate terđovena, te poverujinen da tu bičhalđan man.” ");
INSERT INTO rmna_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Kad phenđa adava, vičinđa oto sa o glaso: “Lazare, ikljov!” ");
INSERT INTO rmna_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","I o mulo iklilo. Lesere vasta hem o pre inele paćarde zavojencar, a lesoro muj inele paćardo maramicaja. A o Isus phenđa lenđe: “Huljaven lestar adava hem muken le te džal!” ");
INSERT INTO rmna_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Tegani but Jevreja, kola ale kori Marija hem dikhle so o Isus ćerđa, poverujinde ano leste. ");
INSERT INTO rmna_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ali nesave olendar džele koro fariseja hem vaćerde lenđe okova so o Isus ćerđa. ");
INSERT INTO rmna_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Tegani o šerutne sveštenici hem o fariseja čedinde pe ko sabor, i phende: “So te ćera? Adava manuš ćerela but čudesna znakija. ");
INSERT INTO rmna_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Te mukljam lese te ćerel ađahar sa o manuša ka poverujinen ano leste. Tegani ka aven o Rimljanja hem ka uništinen amaro Hram hem amare narodo.” ");
INSERT INTO rmna_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","A jekh olendar, o Kajafa, kova adava berš inele prvosvešteniko, phenđa lenđe: “Tumen ništa na džanen! ");
INSERT INTO rmna_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Na haljovena dai tumenđe po šukar jekh manuš te merel zako narodo, nego sa o narodo te properel.” ");
INSERT INTO rmna_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","O Kajafa na phenđa adava korkoro pestar, nego, adalese so adava berš inele prvosvešteniko, prorokujinđa da o Isus ka merel zako sa o narodo e Jevrejengoro. ");
INSERT INTO rmna_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Hem na samo zako adava narodo, nego hem te bi čedela sa e Devlesere rasejime čhaven. ");
INSERT INTO rmna_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ađahar adava dive e jevrejengere vođe dogovorinde pe te mudaren e Isuse. ");
INSERT INTO rmna_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Adalese o Isus na tromandilo te phirel javno maškaro e jevrejengere vođe, nego adathar dželo paše uzali pustinja, ano gav Efrem, hem adari inele ple učenikonencar. ");
INSERT INTO rmna_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","A inele paše e jevrejengoro prazniko Pasha hem but Jevreja taro avera dizja hem gava ale ko Jerusalim te očistinen pe angleder i Pasha. ");
INSERT INTO rmna_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Rodinde e Isuse hem, terdindoj ano Hram pučle jekh avere: “So mislinena, ka avel li ki Pasha?” ");
INSERT INTO rmna_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","A o šerutne sveštenici hem o fariseja već dinde naredba, ko ka dodžanel kaj o Isus te vaćeren lenđe, te šaj dolen le. ");
INSERT INTO rmna_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Šov dive angleder o prazniko Pasha, o Isus dželo ki Vitanija, kaj inele o Lazar, kole vazdinđa taro mule. ");
INSERT INTO rmna_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Adari spreminde lese večera. I Marta poslužini ine, a o Lazar inele maškaro okolende kola e Isuseja inele uzalo astali. ");
INSERT INTO rmna_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Tegani i Marija lelja ekvaš litar oto but skupo mirisno ulje savoi ćerdo oto čisto nard, makhlja e Isusesere pre hem koslja len ple balencar. Hem sa o čher mirišinđa ano ulje. ");
INSERT INTO rmna_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","A jekh oto e Isusesere učenici, o Juda Iskariot, kova posle ka izdajini e Isuse, phenđa: ");
INSERT INTO rmna_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Sose akava mirisno ulje na bikninđa pe zako trišel srebrna kovanice, a o pare te den pe e čororenđe?” ");
INSERT INTO rmna_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ov na phenđa adava adalese so ačhilo lese zako čorore, nego adalese so inele čor: oleste inele o zajednička pare, hem adathar čorela ine pese. ");
INSERT INTO rmna_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Tegani o Isus phenđa: “Muk la! Adava ćerđa te pripremini man zako paruniba. ");
INSERT INTO rmna_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Maškara tumende uvek ka oven čorore manuša, ali me naka ovav uvek tumencar.” ");
INSERT INTO rmna_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","But Jevreja dodžande dai o Isus ki Vitanija hem džele adari, ali na džele samo zbog o Isus, nego hem zbog o Lazar, kole o Isus vazdinđa taro mule. ");
INSERT INTO rmna_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","A o šerutne sveštenici odlučinde te mudaren hem e Lazare, ");
INSERT INTO rmna_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","adalese so zbog oleste but Jevreja džana ine palo Isus hem verujinena ano leste. ");
INSERT INTO rmna_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Tejsato dive but manuša ale ko prazniko, i kad šunde da o Isus avela ko Jerusalim, ");
INSERT INTO rmna_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","lelje granke oti palma hem iklile anglo leste, vičindoj: “Hosana! Blagoslovimei okova kova avela ano anav e Gospodesoro! Blagoslovimei o Caro e Izraelesoro!” ");
INSERT INTO rmna_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","A o Isus arakhlja jekhe terne here hem beštino upro leste, sar soi pisime ano Sveto lil: ");
INSERT INTO rmna_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ma dara, Jerusalime! Ače, to Caro avela bešindoj upro terno her.” ");
INSERT INTO rmna_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Lesere učenici tegani na halile akava, ali kad o Isus legardilo ani slava, setinde pe so adava inele pisime olestar hem da baš ađahar ćerde lese. ");
INSERT INTO rmna_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","A o manuša kola inele e Isuseja kad vičinđa e Lazare taro grobo hem vazdinđa le taro mule, svedočinde adalestar averenđe. ");
INSERT INTO rmna_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Adalese sa edobor manuša iklile anglo leste, so šunde dai ov adava kova ćerđa adava čudesno znako. ");
INSERT INTO rmna_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Tegani o fariseja phende jekh averese: “Dikhena da našti ništa te ćera! Sa o sveto dželo palo leste!” ");
INSERT INTO rmna_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","A maškaro manuša kola ale ko prazniko te slavinen e Devle inele hem Grci. ");
INSERT INTO rmna_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","On ale koro Filip, kova inele tari Vitsaida ani Galileja, hem zamolinde le, vaćerindoj: “Gospodarona, amen mangaja te dikha e Isuse.” ");
INSERT INTO rmna_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","O Filip dželo hem phenđa adava e Andrejase, i on duj džele hem phende adava e Isusese. ");
INSERT INTO rmna_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","A o Isus phenđa lenđe: “Alo o vreme te proslavini pe o Čhavo e manušesoro. ");
INSERT INTO rmna_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Čače, čače vaćerava tumenđe: te e đivesoro zrno na perela ki phuv hem na merela, ačhola korkoro. A te merela, anela but bijandipe. ");
INSERT INTO rmna_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ko volini plo dživdipe, ka našali le, a ko mrzini plo dživdipe ko akava sveto, ka arakhi le zako večno dživdipe. ");
INSERT INTO rmna_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ko služini maje, mora te phirel pala mande. Kaj injum me, adari ka ovel hem mlo sluga. Mlo Dad ka mothoj čast okolese kova služini maje. ");
INSERT INTO rmna_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Mli dušai akana uznemirime. So te phenav? ‘Dade, spasin man adalestar so adžićeri man’? Na, adalese so me hem aljum zako adava. ");
INSERT INTO rmna_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Dade, proslavin to anav!” Tegani taro nebo šundilo glaso: “Proslavinđum hem palem ka proslavinav!” ");
INSERT INTO rmna_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Kad o narodo kova adari terdino šunđa adava, phenđa da grminđa. A avera phende da o anđeo vaćerđa lese adava. ");
INSERT INTO rmna_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","O Isus phenđa lenđe: “Akava glaso na šundilo zbog mande, nego zbog tumende. ");
INSERT INTO rmna_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Akanai o vreme te sudini pe akale svetose. Akana o vladari akale svetosoro ka ovel frdime avri. ");
INSERT INTO rmna_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","A me, kad ka ovav vazdime tari phuv, sa e manušen ka cidav nakora mande.” ");
INSERT INTO rmna_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Adava phenđa sar te mothoj savo meriba adžićeri le. ");
INSERT INTO rmna_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Tegani o narodo phenđa lese: “Šunđam taro Zakoni da o Hrist ka živini zauvek. Sar onda vaćereja da o Čhavo e manušesoro valjani te merel? Kovai adava ‘Čhavo e manušesoro’?” ");
INSERT INTO rmna_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","A o Isus phenđa lenđe: “O svetlost samo pana hari ka ovel maškar tumende. Phiren sar isi tumen svetlost, te na prelel tumen i tomina. Adalese so, ko phirela ki tomina, na džanel kaj džala. ");
INSERT INTO rmna_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Sar isi tumen svetlost, verujinen ano svetlost, te oven čhave e svetlosere.” Kad phenđa adava, dželo hem garavđa pe olendar. ");
INSERT INTO rmna_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Iako o Isus edobor čudesna znakija ćerđa anglo lende, on palem na verujinde lese. ");
INSERT INTO rmna_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","A sa adava inele sar te pherđol okova so vaćerđa o proroko Isaija: “Gospode, ko poverujinđa amare lafenđe hem kase mothovđa pe o zoralo vas e Gospodesoro?” ");
INSERT INTO rmna_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Adalese našti ine te poverujinen, adalese so o Isaija phenđa hem akava: ");
INSERT INTO rmna_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“O Devel korjarđa lengere jaćha, hem steđinđa lengere vile, jaćhencar te na dikhen hem vileja te na haljoven, hem te na irinen pe, te sasljarav len.” ");
INSERT INTO rmna_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","O Isaija adava phenđa, adalese so dikhlja e Isusesiri slava hem vaćerđa olestar. ");
INSERT INTO rmna_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","A čak hem but vođe e jevrejengere verujinde ano leste, ali na mangle te priznajinen zbog o fariseja, sar te na oven ikalde oti sinagoga. ");
INSERT INTO rmna_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Adalese so, više volinde o manuša te hvalinen len nego o Devel. ");
INSERT INTO rmna_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","A o Isus vičinđa oto sa o glaso: “Ko verujini ana mande, na verujini samo ana mande, nego hem ano Okoleste kova bičhalđa man. ");
INSERT INTO rmna_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Hem ko dikhela man, dikhela hem Okole kova bičhalđa man. ");
INSERT INTO rmna_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Me injum o Svetlost savo alo ko sveto, da svako kova verujini ana mande te na ačhol ani tomina. ");
INSERT INTO rmna_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ko šunela mle lafija, a na ćerela len, me na sudinava lese. Adalese so, me na aljum te sudinav e svetose, nego te spasinav o sveto. ");
INSERT INTO rmna_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ko odbacini man hem na prihvatini mle lafija, isi le lesoro sudija: o Lafi savo vaćerđum ka sudini lese ko Poslednjo dive. ");
INSERT INTO rmna_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Adalese so, me na vaćerđum korkoro mandar, nego korkoro mlo Dad, kova bičhalđa man, naredinđa maje so te phenav hem so te vaćerav. ");
INSERT INTO rmna_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","A me džanav da olesere naredbe dena večno dživdipe. Me vaćerava samo okova so mlo Dad phenđa maje te vaćerav.” ");
INSERT INTO rmna_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Angleder o prazniko Pasha, o Isus džanđa so alo lesoro vreme te džal taro akava sveto koro Dad. Tegani o Isus đi o kraj mothovđa kobor volini okolen kola inele olesere ko akava sveto. ");
INSERT INTO rmna_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","O Isus hem lesere učenici hana ine zajedno i večera. O beng e Judase e Iskariotese, e Simonesere čhavese, već čhivđa ano vilo te izdajini e Isuse. ");
INSERT INTO rmna_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","A o Isus džanđa so o Dad dinđa lese sa i vlast; džanđa da e Devlestar alo hem da ko Devel ka džal. ");
INSERT INTO rmna_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Uštino oti večera hem huljavđa plo ogrtači, i lelja o peškiri hem phandlja le pese ko maškar. ");
INSERT INTO rmna_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Tegani čhorđa pani ano lavori hem lelja te thovel e učenikonengere pre hem te kosel len peškireja saveja phandlja po maškar. ");
INSERT INTO rmna_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Kad alo đi o Simon Petar, ov phenđa lese: “Gospode, tu li ka thove mle pre?” ");
INSERT INTO rmna_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","O Isus phenđa lese: “Tu akana na haljoveja so me ćerava, ali jekh dive ka haljove.” ");
INSERT INTO rmna_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","A o Petar phenđa lese: “Tu nikad naka thove mle pre!” A o Isus phenđa lese: “Te na thovđum te pre, našti te ove jekh mle učenikonendar.” ");
INSERT INTO rmna_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Tegani o Simon Petar phenđa lese: “Gospode, ma onda thov samo mle pre, nego hem mle vasta hem mlo šero!” ");
INSERT INTO rmna_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","A o Isus phenđa lese: “Okolese kovai nanđardo valjani te thoven pe samo o pre, adalese soi već čisto. Hem tumen injen čista, ali na sare.” ");
INSERT INTO rmna_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Džanđa ko ka izdajini le, i adalese phenđa: “Na injen sare čista.” ");
INSERT INTO rmna_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Kad thovđa lengere pre, lelja plo ogrtači hem palem čhivđa pe uzalo astali, hem pučlja len: “Haljovena li so ćerđum tumenđe? ");
INSERT INTO rmna_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Tumen man vičinena Učitelju hem Gospode, hem šukar phenena, adalese so me adava injum. ");
INSERT INTO rmna_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","I te me, o Gospod hem o Učitelj, thovđum tumare pre, onda valjani hem tumen te thoven o pre jekh averese. ");
INSERT INTO rmna_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Dinđum tumen primer, hem tumen te ćeren ađahar sar so me ćerđum tumenđe. ");
INSERT INTO rmna_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Čače, čače vaćerava tumenđe: o sluga nane po baro ple gospodarestar, ni o bičhaldo okolestar kova bičhalđa le. ");
INSERT INTO rmna_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Adalese so džanen akava, blago tumenđe te ađahar ćerđen.” ");
INSERT INTO rmna_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Na vaćerava sarijendar tumendar. Me džanav okolen kas birinđum. Ali mora te pherđol okova soi pisime ano Sveto lil: ‘Okova kova mancar hala maro, irinđa pe protiv mande.’ ");
INSERT INTO rmna_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Vaćerava tumenđe akana, angleder nego so te ovel, da kad ka ovel, te poverujinen da Me injum. ");
INSERT INTO rmna_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Čače, čače vaćerava tumenđe: ko primini okole kole me bičhalava, man primini, a ko primini man, primini Okole kova bičhalđa man.” ");
INSERT INTO rmna_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Kad phenđa adava, lesoro duho inele but uznemirime, i tegani phravdeste phenđa lenđe: “Čače, čače vaćerava tumenđe: jekh tumendar ka izdajini man.” ");
INSERT INTO rmna_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Tegani o učenici dikhle jekh avere, adalese so na džande kastar o Isus vaćeri. ");
INSERT INTO rmna_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jekh e učenikonendar – okova kas o Isus but volinđa – inele odmah uzalo Isus, ");
INSERT INTO rmna_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","i o Simon Petar dinđa le znako te pučel e Isuse kastar vaćeri. ");
INSERT INTO rmna_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ađahar adava učeniko pašljarđa pe nakoro Isus hem pučlja le: “Kovai adava, Gospode?” ");
INSERT INTO rmna_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","A o Isus phenđa lese: “Okova kase ka dav o maro savo ka macinav ano čaro.” Tegani lelja o kotor maro, macinđa le hem dinđa le e Judase, e Simonesere Iskariotesere čhavese. ");
INSERT INTO rmna_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","I samo so o Juda halja o maro, đerdinđa ano leste o Sotoni. Tegani o Isus phenđa lese: “Adava so mangeja te ćere, ćer po sig.” ");
INSERT INTO rmna_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ali niko e učenikonendar kola inele uzalo astali na halilo sose phenđa lese adava. ");
INSERT INTO rmna_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Adalese so ko Juda inele o zajednička pare, nesave mislinde da o Isus phenđa lese te džal hem te činel nešto hajbnase zako prazniko ili te del nešto e čororenđe. ");
INSERT INTO rmna_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Palo adava so o Juda halja o maro, odmah iklilo avri. A inele rat. ");
INSERT INTO rmna_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Kad o Juda iklilo, o Isus phenđa: “Akanai proslavime o Čhavo e manušesoro hem o Devel proslavinđa pe ano leste. ");
INSERT INTO rmna_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Te o Devel proslavinđa pe ano leste, hem o Devel ole ka proslavini ana peste, hem ka proslavini le odmah. ");
INSERT INTO rmna_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Mle čhavoralen, pana hari injum tumencar. Ka roden man, ali, sar so phenđum e jevrejengere vođenđe: ‘Kaj me džava, tumen našti te aven’, ađahar adava hem tumenđe phenava. ");
INSERT INTO rmna_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nevi naredba dava tumen – te volinen jekh avere. Sar so me volinđum tumen, ađahar hem tumen volinen jekh avere. ");
INSERT INTO rmna_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Palo akava sare ka džanen da injen mle učenici: te ine tumen mangipe jekh averese.” ");
INSERT INTO rmna_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","O Simon Petar pučlja le: “Gospode kaj džaja?” A o Isus phenđa lese: “Kaj me džava, tu akana našti te ave pala mande. Ali ka ave posle.” ");
INSERT INTO rmna_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","O Petar pučlja le: “Gospode, sose našti te džav tuja akana? Spremno injum mlo dživdipe te dav tuće!” ");
INSERT INTO rmna_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","A o Isus pučlja le: “To dživdipe te de maje? Čače, čače vaćerava će, angleder so o bašno ka đilabi, trin puti ka hovave da na pendžareja man.” ");
INSERT INTO rmna_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","I o Isus phenđa: “Ma te uznemirinen pe tumare vile. Verujinen ano Devel hem verujinen ana mande. ");
INSERT INTO rmna_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ano čher mle Dadesoro isi but thana bešibnase. Te na ovel ine ađahar, naka phenav tumenđe ine: ‘Džava te pripreminav tumenđe than.’ ");
INSERT INTO rmna_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","A kad ka džav hem kad ka pripreminav tumenđe than, ka avav palem hem ka lav tumen mancar, te oven hem tumen adari kaj me injum. ");
INSERT INTO rmna_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","A tumen džanena o drom kaj me džava.” ");
INSERT INTO rmna_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","O Toma phenđa lese: “Gospode, na džanaja kaj džaja. Sar onda šaj te džana o drom?” ");
INSERT INTO rmna_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","A o Isus phenđa lese: “Me injum o Drom, o Čačipe hem o Dživdipe. Nijekh na avela koro Dad, sem prekala mande. ");
INSERT INTO rmna_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Te pendžarđen man, ka pendžaren hem mle Dade. Od akana pendžarena le, hem dikhljen le.” ");
INSERT INTO rmna_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","O Filip phenđa lese: “Gospode, mothov amenđe e Dade, hem adava ka ovel amenđe dovoljno.” ");
INSERT INTO rmna_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","O Isus phenđa lese: “Edobor vreme injum tumencar, a tu man, Filipe, pana na pendžareja! Ko dikhlja man, dikhlja hem e Dade. Sar šaj te phene: ‘Mothov amenđe e Dade’? ");
INSERT INTO rmna_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Tu li na verujineja da me injum ano Dad hem dai o Dad ana mande? O lafija save vaćerava tumenđe na vaćerava korkoro mandar, nego o Dad, kova živini ana mande, ćerela ple delja prekala mande. ");
INSERT INTO rmna_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Verujinen maje da injum ano Dad hem dai o Dad ana mande. A te na verujinena maje, verujinen zbog o delja save ćerava. ");
INSERT INTO rmna_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Čače, čače vaćerava tumenđe: ko verujini ana mande, ka ćerel o delja save me ćerava. Ka ćerel hem po bare, adalese so me džava koro Dad. ");
INSERT INTO rmna_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Hem sa so ka roden ano mlo anav, me ka ćerav adava, te šaj o Dad proslavini pe ano Čhavo. ");
INSERT INTO rmna_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Sa so ka roden ano mlo anav, me ka ćerav.” ");
INSERT INTO rmna_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Te volinena man, ka ićeren mle naredbe. ");
INSERT INTO rmna_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","A me ka molinav e Dade hem ov ka del tumen avere Zastupniko, te ovel tumencar zauvek: ");
INSERT INTO rmna_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","e Duho e čačipnasere, kole o sveto našti primini, adalese so na dikhela le hem na pendžarela le. Tumen pendžarena le, adalese soi tumencar hem ka ovel ana tumende. ");
INSERT INTO rmna_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Naka ačhavav tumen sar čhavoren bizo dad hem bizi daj. Palem ka avav kora tumende. ");
INSERT INTO rmna_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Pana hari, hem o sveto više naka dikhel man, ali tumen ka dikhen man. Adalese so me živinava, hem tumen ka živinen. ");
INSERT INTO rmna_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Adava dive ka haljoven da me injum ano mlo Dad hem da tumen injen ana mande, a me ana tumende. ");
INSERT INTO rmna_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ko prihvatini mle naredbe hem ićeri len, ov volini man, a ko volini man, ole ka volini hem mlo Dad. A hem me ka volinav le hem ka mothovav man lese.” ");
INSERT INTO rmna_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","O Juda (na o Iskariot) pučlja le: “Gospode, sar adava da ka mothove tut amenđe, a na e svetose?” ");
INSERT INTO rmna_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","O Isus phenđa lese: “Te neko volini man, ka ićeri mlo Lafi, hem mlo Dad ka volini le. Mlo Dad hem me ka ava koro leste hem ka ačhova koro leste. ");
INSERT INTO rmna_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ko na volini man, na ićeri mlo Lafi. A o Lafi savo šunena nane mlo, nego avela e Dadestar, kova bičhalđa man. ");
INSERT INTO rmna_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Adava phenđum tumenđe akana, sar pana injum tumencar. ");
INSERT INTO rmna_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","A o Zastupniko, o Sveto Duho, kole o Dad ka bičhali te zastupini man, ka sikaj tumen sa hem ka podsetini tumen ko sa so phenđum tumenđe. ");
INSERT INTO rmna_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ačhavava tumenđe mir, mlo mir dava tumen. Ali, na dava tumen ole ađahar sar o sveto so dela. Ma te uznemirinen pe tumare vile hem ma te daran. ");
INSERT INTO rmna_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Šunđen man so phenđum: ‘Džava hem ka irinav man kora tumende.’ Te volinena man, ka radujinen tumen ine so džava koro Dad, adalese soi o Dad po baro mandar. ");
INSERT INTO rmna_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Adava phenđum tumenđe akana, angleder nego so ka ovel, te verujinen kad ka ovel adava. ");
INSERT INTO rmna_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Naka vaćerav pana but tumencar, adalese so avela o vladari akale svetosoro. Ole nane vlast upra mande, ");
INSERT INTO rmna_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ali sar te šaj o sveto dodžanel da me volinava e Dade, ćerava ađahar sar so o Dad naredinđa maje. Ušten, hajde akatar!” ");
INSERT INTO rmna_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Me injum o čačikano čokot, a mloi Dad o vinogradari. ");
INSERT INTO rmna_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ov čhinela đijekh loza upra mande savi na anela bijandipe, a čistini đijekha savi anela bijandipe, sar te del više bijandipe. ");
INSERT INTO rmna_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","A tumen injen već čista zbog o lafi savo vaćerđum tumenđe. ");
INSERT INTO rmna_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ačhoven ana mande hem me ka ačhovav ana tumende. Sar so i loza našti te anel bijandipe korkori pestar te na ačhili upro čokot, ađahar ni tumen našti te anen bijandipe te na ačhiljen ana mande. ");
INSERT INTO rmna_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Me injum o čokot, a tumen o loze. Ko ačhola ana mande hem me ano leste, ov anela but bijandipe, adalese so bizo mande našti ništa te ćeren. ");
INSERT INTO rmna_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Te neko na ačhola ana mande, frdela pe avri sar i čhindi loza hem šućola, a esavken čedena hem frdena len ani jag, i tharena len. ");
INSERT INTO rmna_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Te ačhona ana mande hem te mle lafija ačhona ana tumende, roden okova so mangena hem ka dobinen. ");
INSERT INTO rmna_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Akavai ki slava mle Dadesiri: te anen but bijandipe hem te oven mle učenici. ");
INSERT INTO rmna_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Sar so o Dad volinđa man, ađahar hem me tumen volinđum. Ačhoven ano mlo mangipe. ");
INSERT INTO rmna_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Te ićerđen tumen ko mle naredbe, ka ačhoven ano mlo mangipe, sar so hem me ićerđum man ko naredbe mle Dadesere, i ačhovava ano lesoro mangipe. ");
INSERT INTO rmna_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Akava phenđum tumenđe te šaj mli radost ovel ana tumende hem te šaj tumari radost ovel pherdi. ");
INSERT INTO rmna_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Akavai mli naredba: volinen jekh avere sar so me volinđum tumen. ");
INSERT INTO rmna_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nane po baro mangipe adalestar nego kad neko dela plo dživdipe ple amalenđe. ");
INSERT INTO rmna_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","A tumen injen mle amala te ćerđen okova so naredinava tumenđe. ");
INSERT INTO rmna_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Na vičinava tumen više sluge, adalese so o sluga na džanel so ćerela lesoro gospodari. Akana vičinava tumen amala, adalese so mothovđum tumenđe sa so phenđa maje mlo Dad. ");
INSERT INTO rmna_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Na birinđen tumen man, nego me tumen birinđum hem čhivđum tumen te džan hem te anen bijandipe, hem tumaro bijandipe te ačhol, hem te šaj o Dad te del tumen sa so ka roden ano mlo anav. ");
INSERT INTO rmna_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Akava naredinava tumenđe: Volinen jekh avere!” ");
INSERT INTO rmna_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Te o sveto mrzini tumen, džanen da man mrzinđa angleder tumendar. ");
INSERT INTO rmna_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Te oven ine akale svetostar, o sveto ka volini tumen ine. Ali, adalese so na injen akale svetostar, nego me izabirinđum tumen olestar, zbog adalese o sveto mrzini tumen. ");
INSERT INTO rmna_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Setinen tumen mle lafendar so phenđum tumenđe: ‘O sluga nane po baro ple gospodarestar.’ Te man progoninde, ka progoninen hem tumen. Te ićerde pe ko mlo Lafi, ka ićeren pe hem ko tumaro. ");
INSERT INTO rmna_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","A sa adava ka ćeren protiv tumende zbog mlo anav, adalese so na džanen Okole kova man bičhalđa. ");
INSERT INTO rmna_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Te na avav hem te na vaćerav lenđe ine, naka oven ine kriva zako greh. Ali akana nane len izgovor zako pumaro greh. ");
INSERT INTO rmna_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ko mrzini man, mrzini hem mle Dade. ");
INSERT INTO rmna_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Te na ćerav ine delja maškar olende save niko aver na ćerđa, naka oven ine kriva zako greh. A on dikhle o delja save ćerđum, a palem zamrzinde hem man hem mle Dade. ");
INSERT INTO rmna_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ali, valjani te pherđol okova soi pisime ano lengoro Zakoni: ‘Mrzinde man bizo razlog.’ ");
INSERT INTO rmna_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","A kad ka avel o Zastupniko, kole ka bičhalav tumenđe e Dadestar – o Duho e čačipnasoro kova avela e Dadestar – ov ka svedočini mandar. ");
INSERT INTO rmna_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","A hem tumen ka svedočinen, adalese so taro početak injen mancar.” ");
INSERT INTO rmna_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","I o Isus phenđa: “Adava phenđum tumenđe te na otperen oti vera. ");
INSERT INTO rmna_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ka ikalen tumen oti sinagoga, a ka avel o vreme kad, svako kova ka mudari tumen, ka mislini da adaleja služini e Devlese. ");
INSERT INTO rmna_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","A adava ka ćeren adalese so na pendžarena ni mle Dade ni man. ");
INSERT INTO rmna_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Adava vaćerđum tumenđe, kad ka avel adava vreme, te setinen tumen mle lafendar. Na vaćerđum tumenđe akava ko početak, adalese so injumle tumencar.” ");
INSERT INTO rmna_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Ali akana džava Okoleste kova bičhalđa man, a nijekh tumendar na pučela man: ‘Kaj džaja?’ ");
INSERT INTO rmna_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Nego, adalese so adava phenđum tumenđe, i žal pherđa tumare vile. ");
INSERT INTO rmna_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ali vaćerava tumenđe o čačipe: po šukari tumenđe me te džav. Adalese so, te na dželjum, naka avel tumenđe o Zastupniko. Ali te dželjum, ka bičhalav le tumende. ");
INSERT INTO rmna_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","A kad ov ka avel, ka mothoj e manušenđe soi čače o greh, i pravednost hem o sudo. ");
INSERT INTO rmna_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","So tičini pe oto greh, adalese so na verujinena ana mande. ");
INSERT INTO rmna_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","So tičini pe oti pravednost, adalese so džava koro Dad hem naka dikhen man više. ");
INSERT INTO rmna_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","So tičini pe oto sudo, adalese soi o vladari akale svetosoro već osudime. ");
INSERT INTO rmna_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Pana but so isi man te phenav tumenđe, ali adava naka šaj ine akana te akharen. ");
INSERT INTO rmna_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ali, kad ka avel ov, o Duho e čačipnasoro, ka legari tumen ano sa o čačipe. Ov naka vaćeri korkoro pestar, nego ka vaćeri samo okova so šunela, hem ka vaćeri tumenđe okova so ka ovel. ");
INSERT INTO rmna_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ov ka proslavini man, adalese so mandar ka primini hem tumenđe ka vaćeri. ");
INSERT INTO rmna_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Sa so isi mle Dade, mloi. Adalese phenđum tumenđe da mandar ka primini hem tumenđe ka vaćeri. ");
INSERT INTO rmna_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Pana hari, hem naka dikhen man više, a onda pana hari, i ka dikhen man.” ");
INSERT INTO rmna_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Tegani nesave lesere učenikonendar pučle jekh avere: “Soi adava so phenela amenđe: ‘Pana hari, hem naka dikhen man, a onda pana hari, i ka dikhen man’, hem: ‘Adalese so džava koro Dad’?” ");
INSERT INTO rmna_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","I phende: “So mislini adaleja kad phenela: ‘Pana hari’? Na džanaja sostar vaćeri.” ");
INSERT INTO rmna_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","A o Isus džanđa so mangle te pučen le, hem phenđa lenđe: “Pučena tumen maškara tumende so značini adava so phenđum: ‘Pana hari, hem naka dikhen man, a onda pana hari, i ka dikhen man’? ");
INSERT INTO rmna_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Čače, čače vaćerava tumenđe: Ka roven hem ka tugujinen, a o sveto ka radujini pe. Ka oven žalosna, ali tumari žalost ka irini pe ani radost. ");
INSERT INTO rmna_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ano dukhai i đuvli kad bijani, adalese so alo lakoro vreme, ali kad bijanđola o čhavoro, radosnoi adalese so anđa e čhavore ko sveto, i bistrela upro pharipa save nakhavđa. ");
INSERT INTO rmna_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ađahar hem tumen akana injen žalosna, ali me palem ka dikhav tumen hem tumare vile ka radujinen pe, hem niko naka šaj te lel tumendar adaja radost. ");
INSERT INTO rmna_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Hem adava dive ništa više naka pučen man. Čače, čače vaćerava tumenđe: sa so ka roden mle Dadestar ano mlo anav, ka del tumen. ");
INSERT INTO rmna_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Đi akana ništa na rodinđen ano mlo anav. Roden hem ka dobinen – te šaj tumari radost ovel pherdi.” ");
INSERT INTO rmna_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Akava vaćerđum tumenđe ano priče. Avela o vreme kad više naka vaćerav tumenđe ano priče, nego phravdeste ka vaćerav tumenđe e Dadestar. ");
INSERT INTO rmna_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Adava dive ka roden e Dadestar maje ano anav. Na phenava tumenđe da me ka molinav mle Dade tumenđe, ");
INSERT INTO rmna_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","adalese so hem korkoro o Dad volini tumen adalese so tumen volinđen man hem poverujinđen da aljum e Devlestar. ");
INSERT INTO rmna_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","E Dadestar ikliljum hem aljum ko sveto. Akana ačhavava o sveto hem džava mle Dadeste.” ");
INSERT INTO rmna_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Tegani lesere učenici phende: “Ače, akana vaćereja amenđe phravdeste, bizo te vaćere ano priče. ");
INSERT INTO rmna_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Akana džanaja da sa džane hem na valjani neko te pučel tut nešto, adalese so sa angleder džane. Adalese verujinaja da aljan e Devlestar.” ");
INSERT INTO rmna_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","A o Isus phenđa lenđe: “Akana li verujinena? ");
INSERT INTO rmna_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ače, avela o vreme – hem već alo – kad sare ka našen svako pese ki strana, a man ka ačhaven korkore. Ali me na injum korkoro, adalese soi o Dad mancar. ");
INSERT INTO rmna_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Akava phenđum tumenđe te šaj ovel tumen mir ana mande. Ano sveto ka ovel tumen nevolja, ali tumen oven zorale – me pobedinđum e sveto.” ");
INSERT INTO rmna_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Kad sa adava o Isus vaćerđa, vazdinđa plo šero nakoro nebo, hem phenđa: “Dade, alo o vreme. Proslavin te Čhave, sar te šaj o Čhavo proslavini tut. ");
INSERT INTO rmna_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Adalese so, tu dinđan le vlast upreder svako manuš te del večno dživdipe sarijenđe kolen tu dinđan le. ");
INSERT INTO rmna_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","A akavai o večno dživdipe: te pendžaren tut, e jekhe čačikane Devle, hem e Isuse Hriste, kole tu bičhalđan. ");
INSERT INTO rmna_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Me tut proslavinđum ki phuv ađahar so završinđum i buti savi dinđan man te ćerav. ");
INSERT INTO rmna_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","A akana tu proslavin man kora tute, Dade, esavka slavaja savi ine man kora tute angleder nego so o sveto inele ćerdo.” ");
INSERT INTO rmna_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Mothovđum to anav e manušenđe kolen dinđan man taro akava sveto. On inele kle hem tu dinđan len maje hem on ićerde pe ko to Lafi. ");
INSERT INTO rmna_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Akana džanen da sa so dinđan man avela tutar. ");
INSERT INTO rmna_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Adalese so, dinđum len o lafija save tu dinđan maje hem on prihvatinde len hem čače halile da me aljum tutar, hem poverujinde da tu bičhalđan man. ");
INSERT INTO rmna_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Olenđe molinava. Na molinava zako sveto, nego zako okola kolen dinđan man, adalese soi on kle. ");
INSERT INTO rmna_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Sa soi mlo, kloi, hem sa soi klo, mloi, a me injum proslavime prekalo lende. ");
INSERT INTO rmna_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Me na injum više ano sveto, ali oni ano sveto, a me avava kora tute. Svetona Dade, arakh len te anaveja, save dinđan maje, te oven jekh sar so amen injam jekh. ");
INSERT INTO rmna_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Đikote injumle olencar, arakhljum len e anaveja save dinđan man. Arakhljum len hem nijekh olendar na propelo, sem okolestar kovai osudime ki propast, sar te pherđol o Sveto lil. ");
INSERT INTO rmna_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","A akana avava kora tute, ali akava vaćerava sar pana injum ko sveto, sar te šaj te ovel len ana pumende o pherdipe oti mli radost. ");
INSERT INTO rmna_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Dinđum len to Lafi, a o sveto zamrzinđa len, adalese so on nane oto sveto, sar so hem me na injum oto sveto. ");
INSERT INTO rmna_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Na molinava te le len taro sveto, nego te arakhe len e Bišukarestar. ");
INSERT INTO rmna_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","On nane oto sveto, sar so hem me na injum oto sveto. ");
INSERT INTO rmna_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Posvetin len te čačipnaja; o čačipei to Lafi. ");
INSERT INTO rmna_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Sar so tu man bičhalđan ano sveto, ađahar hem me len bičhalđum ano sveto ");
INSERT INTO rmna_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","hem korkore man posvetinava zako olenđe, hem on te oven posvetime čačipnaja.” ");
INSERT INTO rmna_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ali, na molinava samo lenđe, nego hem okolenđe kola prekalo olengoro lafi ka poverujinen ana mande, ");
INSERT INTO rmna_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","te šaj sare oven jekh. Sar so injan tu, Dade, ana mande hem me ana tute, ađahar hem on nek oven jekh ana amende, te šaj o sveto te poverujini da tu bičhalđan man. ");
INSERT INTO rmna_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Me dinđum len i slava savi tu man dinđan, te oven jekh sar so amen injam jekh ");
INSERT INTO rmna_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","– me ano lende, a tu ana mande – te oven savršena ano jedinstvo, te šaj o sveto džanel da tu bičhalđan man hem da len volinđan sar so volinđan man. ");
INSERT INTO rmna_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Dade, mangava okola kolen dinđan man te oven mancar adari kaj me injum hem te dikhen mli slava, savi dinđan man adalese so volinđan man angleder nego so o sveto inele ćerdo. ");
INSERT INTO rmna_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Pravednona Dade, iako o sveto na pendžari tut, me pendžarava tut, hem akala džanen da tu bičhalđan man. ");
INSERT INTO rmna_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mothovđum lenđe to anav hem pana ka mothovav le, te šaj o mangipe saveja tu volinđan man ovel ano lende, hem me ano lende.” ");
INSERT INTO rmna_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Kad završinđa i molitva, o Isus dželo ple učenikonencar ki aver strana oto potok Kedron. Adari inele jekh vrt ko savo ov hem lesere učenici đerdinde. ");
INSERT INTO rmna_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","A o izdajniko o Juda džanđa zako adava than adalese so o Isus but puti arakhi pe ine adari ple učenikonencar. ");
INSERT INTO rmna_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","I o Juda alo adari hem anđa peja četa e rimesere vojnikonendar hem e hramesere stražaren, kolen bičhalde o šerutne sveštenici hem o fariseja. Pumencar legarde baklje, svetiljke hem oružje. ");
INSERT INTO rmna_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","A o Isus, adalese so džanđa sa so ka ovel oleja, iklilo hem pučlja len: “Kas rodena?” ");
INSERT INTO rmna_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","On phende lese: “E Isuse taro Nazaret!” A ov phenđa lenđe: “Me injum.” Olencar terdino hem o Juda, lesoro izdajniko. ");
INSERT INTO rmna_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","A kad phenđa lenđe: “Me injum”, cidinde pe napalal hem pele ki phuv. ");
INSERT INTO rmna_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Tegani o Isus palem pučlja len: “Kas rodena?” A on phende lese: “E Isuse taro Nazaret.” ");
INSERT INTO rmna_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","O Isus phenđa lenđe: “Phenđum tumenđe: Me injum. I, adalese so man rodena, muken akalen te džan.” ");
INSERT INTO rmna_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Adava phenđa sar te pherđol okova so angleder phenđa: “Na našalđum nijekhe okolendar kolen dinđan man.” ");
INSERT INTO rmna_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","A e Simone Petre inele mači, i ikalđa le, khuvđa e prvosveštenikosere sluga hem čhinđa lesoro desno kan. E slugasoro anav inele Malho. ");
INSERT INTO rmna_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","O Isus phenđa e Petrese: “Irin o mači ano korice! Sar te na pijav oti čaša e patnjaja savi dinđa man mlo Dad?” ");
INSERT INTO rmna_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tegani i četa, olakoro naredniko hem e hramesere stražarija dolinde e Isuse hem phandle le. ");
INSERT INTO rmna_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Najangle legarde le koro Ana e Kajafasoro sastro. O Kajafa inele prvosvešteniko adava berš. ");
INSERT INTO rmna_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","A o Kajafa inele adava kova savetujinđa e jevrejengere vođen dai po šukar jekh manuš te merel zako sa o narodo. ");
INSERT INTO rmna_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Palo Isus pođinde o Simon Petar hem pana jekh učeniko. Adale učeniko o prvosvešteniko džanđa, i ov e Isuseja đerdinđa ko boro e prvosveštenikosoro, ");
INSERT INTO rmna_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","a o Petar ačhilo avri angli kapija. Tegani iklilo okova dujto učeniko, kole o prvosvešteniko džanđa, vaćerđa e sluškinjaja koja pazini ine anglo udar, i anđa e Petre andre. ");
INSERT INTO rmna_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Tegani adaja sluškinja pučlja e Petre: “Na li hem tu injan jekh akale manušesere učenikonendar?” O Petar phenđa: “Na injum.” ");
INSERT INTO rmna_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","A o sluge hem o stražarija tharde jag hem terdine adari te tačon, adalese so inele šil, i ađahar hem o Petar terdino olencar hem tačola ine. ");
INSERT INTO rmna_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","A zako adava vreme o prvosvešteniko ispitujini ine e Isuse lesere učenikonendar hem lesere sikavibnastar. ");
INSERT INTO rmna_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","O Isus phenđa lese: “Me javno vaćerđum e manušenđe. Uvek sikavđum ani sinagoga hem ano Hram, kaj sa o Jevreja čedena pe, hem ništa na vaćerđum garandoj. ");
INSERT INTO rmna_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Sose man pučeja? Puč okolen kola šunde so vaćerđum lenđe. On džanen so vaćerđum.” ");
INSERT INTO rmna_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Kad phenđa adava, khuvđa le šamarka jekh sluga kova adari terdino hem phenđa: “Ađahar li vaćeri pe e prvosveštenikoja?” ");
INSERT INTO rmna_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","O Isus phenđa lese: “Te phenđum nešto pogrešno, dokažin dai adava pogrešno. Ali te phenđum nešto šukar, sose khuveja man?” ");
INSERT INTO rmna_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Tegani o Ana, phandle, bičhalđa le koro prvosvešteniko Kajafa. ");
INSERT INTO rmna_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Sar o Simon Petar terđola hem tačola ine, pučle le: “Te na injan hem tu jekh olesere učenikonendar?” A ov hovavđa: “Na injum.” ");
INSERT INTO rmna_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Jekh sluga e prvosveštenikosoro – o rođako okolesoro kasoro kan o Petar čhinđa – phenđa: “Na li dikhljum tut oleja ano vrt?” ");
INSERT INTO rmna_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","A o Petar palem hovavđa hem odmah o bašno đilabđa. ");
INSERT INTO rmna_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Rano sabale e Isuse legarde taro e Kajafasoro čher ki palata e Pilatesiri. E jevrejengere vođe na đerdinde ki palata, sar te na oven nečista palo pumaro adeti, adalese so mangle te han i pashalno večera. ");
INSERT INTO rmna_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Adalese o Pilat iklilo anglo lende hem pučlja len: “Zako so optužinena akale manuše?” ");
INSERT INTO rmna_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","A on phende lese: “Te na ovel ine krivo akava manuš, amen naka preda le ine tute.” ");
INSERT INTO rmna_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Tegani o Pilat phenđa lenđe: “Len le tumen, i sudinen lese palo tumaro zakoni.” A o Jevreja phende lese: “Amen na tromaja nikas te mudara.” ");
INSERT INTO rmna_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Akava ulo sar te pherđol okova so o Isus phenđa e meribnastar saveja valjanđa te merel. ");
INSERT INTO rmna_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","O Pilat tegani palem đerdinđa ki palata, vičinđa e Isuse, hem pučlja le: “Tu li injan o caro e Jevrejengoro?” ");
INSERT INTO rmna_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","A o Isus phenđa: “Vaćereja li adava korkoro tutar, ili avera vaćerde će mandar?” ");
INSERT INTO rmna_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","O Pilat phenđa: “Me li injum Jevrejco? To narodo hem o šerutne sveštenici predinde tut mande. So ćerđan?” ");
INSERT INTO rmna_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","O Isus phenđa lese: “Mlo carstvo nane akale svetostar. Te ovel ine mlo carstvo akale svetostar, mle sluge ka maren pe ine te na ovav predime e jevrejengere vođenđe. Ali mlo carstvo nane akatar.” ");
INSERT INTO rmna_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Tegani o Pilat phenđa: “Znači, tu injan caro!” A o Isus phenđa: “Ađahari sar so pheneja: Injum caro. Me akalese bijandiljum hem akalese aljum ko sveto: te svedočinav zako čačipe. Svako kovai oto čačipe, šunela mlo glaso.” ");
INSERT INTO rmna_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","A o Pilat pučlja le: “Soi o čačipe?” Kad adava phenđa, o Pilat palem iklilo anglo e jevrejengere vođe, i phenđa lenđe: “Na arakhava nisavi krivica upro leste. ");
INSERT INTO rmna_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ali tumen isi jekh adeti zaki Pasha te mukav tumenđe jekhe phandle. Mangena li te mukav tumenđe e jevrejengere caro?” ");
INSERT INTO rmna_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","A on vičinde: “Na ole, nego e Varava!” A o Varava inele razbojniko. ");
INSERT INTO rmna_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Tegani o Pilat naredinđa te šibinen e Isuse. ");
INSERT INTO rmna_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","O vojnici ćerde lese kruna oto kare hem čhivde la lese ko šero, hem urjavde le lolo ogrtači. ");
INSERT INTO rmna_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Tegani lelje te aven nakoro leste hem te phenen lese: “Te ove sasto, e jevrejengere carona!” Hem khuvena le ine šamarke. ");
INSERT INTO rmna_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","O Pilat palem iklilo avri, hem phenđa e narodose: “Ače, ikalava le avri angla tumende, ali te džanen da na arakhljum nisavi krivica upro leste.” ");
INSERT INTO rmna_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Tegani o Isus iklilo avri, e krunaja oto kare ko šero hem ano lolo ogrtači, a o Pilat phenđa: “Dikhen e manuše!” ");
INSERT INTO rmna_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Kad o šerutne sveštenici hem o stražarija dikhle le, vičinde: “Čhiv le ko krsto! Čhiv le ko krsto!” A o Pilat phenđa lenđe: “Len le tumen, i čhiven le ko krsto, adalese so me na arakhljum nisavi krivica upro leste.” ");
INSERT INTO rmna_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","A e jevrejengere vođe phende lese: “Amen isi Zakoni, hem palo adava Zakoni ov mora te merel, adalese so tvrdinđa dai e Devlesoro Čhavo!” ");
INSERT INTO rmna_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Kad o Pilat adava šunđa, po više darandilo, ");
INSERT INTO rmna_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","i palem đerdinđa ki palata hem pučlja e Isuse: “Kotar injan?” Ali o Isus ništa na phenđa. ");
INSERT INTO rmna_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Tegani o Pilat phenđa lese: “Maje li na mangeja te phene? Na džaneja li da isi man vlast te mukav tut hem vlast te čhivav tut ko krsto?” ");
INSERT INTO rmna_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","O Isus phenđa lese: “Naka ovel tut ine nisavi vlast upra mande, te na ovel će ine dindi e Devlestar. Adalesei po baro greh okolesoro kova predinđa man tute.” ");
INSERT INTO rmna_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Otegani o Pilat po više dikhlja te mukel le. Ali e jevrejengere vođe vičinde: “Te mukljan akale, na injan e rimesere carosoro amal! Ko pese phenela dai caro, protivini pe e carose!” ");
INSERT INTO rmna_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Kad šunđa adava, o Pilat ikalđa e Isuse avri hem beštino ki stolica e sudosiri, ko than savo vičini pe Ploča oto bar – jevrejski: Gavata. ");
INSERT INTO rmna_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","A adava inele Dive oti priprema zaki Pasha, paše uzalo dešu duj o sati diveste. O Pilat phenđa e Jevrejenđe: “Ače tumaro caro!” ");
INSERT INTO rmna_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","A o Jevreja vičinde: “Mudar le! Mudar le! Čhiv le ko krsto!” A o Pilat pučlja len: “Tumare li caro te čhivav ko krsto?” A o šerutne sveštenici phende lese: “Amen nane aver caro sem e rimesoro caro!” ");
INSERT INTO rmna_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Tegani o Pilat predinđa e Isuse ko vojnici te čhiven le ko krsto, i on lelje le hem legarde le. ");
INSERT INTO rmna_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Akharindoj plo krsto, o Isus alo ko than vičime Kokalo e šeresoro – savo ko jevrejski vičini pe: “Golgota” – ");
INSERT INTO rmna_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","kaj čhivde le ko krsto. A oleja čhivde ko krsto pana dujen – jekhe oti jekh strana, avere oti dujto, a o Isus ko maškar. ");
INSERT INTO rmna_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","O Pilat dinđa te čhivel pe ko krsto jekh natpis ko savo pisinđa akava: O Isus o Nazarećanin, o caro e jevrejengoro. ");
INSERT INTO rmna_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","But Jevreja čitinde adava natpis, adalese so o than kaj o Isus inele čhivdo ko krsto inele paše uzali diz. A inele pisime ki jevrejsko, latinsko hem grčko čhib. ");
INSERT INTO rmna_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","O šerutne sveštenici e jevrejengere phende e Pilatese: “Ma pisin: ‘caro e jevrejengoro’, nego da ov phenđa dai caro e jevrejengoro.” ");
INSERT INTO rmna_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","A o Pilat phenđa lenđe: “So pisinđum – pisinđum.” ");
INSERT INTO rmna_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Kad čhivde e Isuse ko krsto, o vojnici lelje lesere šeja hem podelinde len ko štar kotora – svakone vojnikose po jekh kotor. Lelje hem lesoro gad, savo na inele sivdo, adalese so odupral đi tele inele pletime sar jekh kotor. ");
INSERT INTO rmna_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Tegani o vojnici phende jekh averese: “Hajde te na pharava o gad, nego te frda o barbuti olese, te dikha kasoro ka ovel.” Adava ulo sar te pherđol okova soi pisime ano Sveto lil: “Mle šeja delinde maškara pumende hem frdinde o barbuti mle gadese.” I o vojnici ađahar hem ćerde. ");
INSERT INTO rmna_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","A uzalo e Isusesoro krsto terđovena ine e Isusesiri daj, lakiri phen, i Marija e Klopesiri romni hem i Marija Magdalena. ");
INSERT INTO rmna_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Kad o Isus dikhlja pla daja hem uzalo late e učeniko kole but volinđa, phenđa laće: “Đuvlije, ače tuće čhavo.” ");
INSERT INTO rmna_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","A e učenikose phenđa: “Ače tuće daj.” Hem otegani o učeniko lelja la peste. ");
INSERT INTO rmna_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Palo adava, o Isus džanđa da pherdilo sa so valjanđa te ovel. A sar te pherđol o Sveto lil, phenđa hem akava: “Žedno injum.” ");
INSERT INTO rmna_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","A adari inele jekh čaro pherdo ušlja moljaja, i čhivde o sunđeri ani ušli mol, čhivde le upri e isopesiri trska hem vazdinde le nakoro e Isusesoro muj. ");
INSERT INTO rmna_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Kad o Isus čhivđa ano muj i mol, phenđa: “Završimei!” Tegani peravđa plo šero hem muklja pli duša. ");
INSERT INTO rmna_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Adalese so inele Dive zako pripremiba zako savato, e jevrejengere vođe zamolinde e Pilate te phagen pe o pre e manušengere kolai ko krsto, sar po sig te meren, i te na ačhoven lengere telija ko krsto prekalo savato. Adalese so ko adava savato inele baro prazniko. ");
INSERT INTO rmna_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","I o vojnici ale hem phagle o pre e duje manušengere kola ine čhivde ko krsto e Isuseja, prvo jekhesere, onda e dujtonesere. ");
INSERT INTO rmna_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","A kad ale đi o Isus, dikhle dai već mulo, i na phagle lesere pre, ");
INSERT INTO rmna_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","nego jekh vojniko kopljeja posavđa le ko rebrija. Hem odmah adathar thavdinđa rat hem pani. ");
INSERT INTO rmna_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Zako akava svedočini okova kova adava dikhlja hem lesoroi svedočanstvo čačikano, hem ov džanela da vaćeri o čačipe, i svedočini te šaj hem tumen poverujinen. ");
INSERT INTO rmna_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Akava ulo sar te pherđol okova soi pisime ano Sveto lil: “Nijekh kokalo naka ovel lese phago.” ");
INSERT INTO rmna_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","A ko aver than ano Sveto lil pisini: “Ka dikhen okole kole posavde.” ");
INSERT INTO rmna_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Palo adava o Josif tari Arimateja zamolinđa e Pilate te mukel lese te lel e Isusesoro telo. O Josif inele e Isusesoro učeniko, ali na javno, adalese so darandilo e jevrejengere vođendar. O Pilat muklja lese adava, i ov alo hem legarđa o telo. ");
INSERT INTO rmna_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","A alo hem o Nikodim – okova kova angleder alo ine koro Isus prekali rat. Ov anđa peja đi sar trijanda kilja mirisija, mešavina oti smirna hem aloja. ");
INSERT INTO rmna_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Tegani lelje e Isusesoro telo hem paćarde le čaršaveja ko savo inele o mirisija, palo adeti e jevrejengoro zako paruniba. ");
INSERT INTO rmna_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","A uzalo than kaj o Isus inele čhivdo ko krsto, inele jekh vrt. Ano adava vrt inele jekh nevo grobo ano savo pana niko na inele parume. ");
INSERT INTO rmna_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Adalese so inele e jevrejengoro Dive zako pripremiba zako savato, hem adalese so o grobo inele paše, čhivde e Isusesoro telo ano leste. ");
INSERT INTO rmna_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Rano sabale ko prvo dive oto kurko, sar pana inele tomina i Marija Magdalena ali ko grobo hem dikhlja dai o bar cidime taro ulaz e grobosoro, ");
INSERT INTO rmna_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","i prastandoj dželi koro Simon Petar hem koro aver učeniko, kole o Isus but volinđa, hem phenđa lenđe: “Legarde e Gospode taro grobo hem na džanaja kaj čhivde le!” ");
INSERT INTO rmna_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Tegani o Petar hem okova aver učeniko iklile hem lelje te džan nakoro grobo. ");
INSERT INTO rmna_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Soduj džene prastandile zajedno, ali okova dujto učeniko inele po brzo taro Petar hem prvo reslo ko grobo. ");
INSERT INTO rmna_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Telilo hem dikhlja o čaršavija save adari inele pašljarde, ali na đerdinđa. ");
INSERT INTO rmna_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Tegani palo leste reslja o Simon Petar, i đerdinđa ko grobo hem dikhlja o čaršavija save adari inele pašljarde. ");
INSERT INTO rmna_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","A i maramica savi inele e Isusese ko šero na inele zajedno e čaršavencar, nego inele ki aver strana paćardi ko jekh than. ");
INSERT INTO rmna_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tegani đerdinđa hem okova aver učeniko, okova kova prvo reslo đi o grobo, dikhlja hem poverujinđa. ");
INSERT INTO rmna_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Adalese so, on pana na halile soi pisime ano Sveto lil – da o Isus valjani te uštel taro mule. ");
INSERT INTO rmna_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Palo adava o učenici irinde pe pumarende. ");
INSERT INTO rmna_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","A i Marija terđola ine avri ko grobo hem rovela. Hem sar rovela ine, telili ");
INSERT INTO rmna_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","hem dikhlja duje anđelen ko parno sar bešena adari kaj inele e Isusesoro telo – jekh ko than kaj inele lesoro šero, a o dujto ko than kaj inele lesere pre. ");
INSERT INTO rmna_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","A o anđelja pučle la: “Đuvlije, sose roveja?” A oj phenđa lenđe: “Legarde mle Gospode, hem na džanav kaj čhivde le.” ");
INSERT INTO rmna_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Kad adava phenđa, irinđa pe hem dikhlja e Isuse sar terđola, ali na džanđa dai ov adava. ");
INSERT INTO rmna_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","A o Isus pučlja la: “Đuvlije, sose roveja? Kas rodeja?” A oj, mislindoj dai adava o manuš kova ćerela buti ano vrt, phenđa lese: “Gospodarona, ako tu legarđan le, phen maje kaj čhivđan le, hem me ka lav le.” ");
INSERT INTO rmna_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Tegani o Isus phenđa laće: “Marije!” Oj irinđa pe nakoro leste, hem ko jevrejski phenđa lese: “Rabuni!”– so značini “Učitelju.” ");
INSERT INTO rmna_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","A o Isus phenđa laće: “Ma zadržin man, adalese so pana na dželjum upre, koro Dad. Nego, dža koro mle phralja, hem phen lenđe: ‘Džava upre, koro mlo Dad hem tumaro Dad, koro mlo Devel hem tumaro Devel.’” ");
INSERT INTO rmna_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Hem i Marija Magdalena dželi hem phenđa e učenikonenđe: “Dikhljum e Gospode!” Hem vaćerđa lenđe okova so o Isus phenđa laće. ");
INSERT INTO rmna_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ki adaja rat ko prvo dive oto kurko, kad o učenici inele zajedno, a o udara phandle adalese so darandile taro e jevrejengere šerutne, o Isus alo hem terdino maškaro lende, i phenđa lenđe: “Mir tumencar.” ");
INSERT INTO rmna_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Kad adava phenđa, mothovđa lenđe o ožiljci ko ple vasta hem ple rebrija, a o učenici inele radosna so dikhle e Gospode. ");
INSERT INTO rmna_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Tegani o Isus palem phenđa lenđe: “Mir tumencar. Sar so mlo Dad bičhalđa man, ađahar hem me bičhalava tumen.” ");
INSERT INTO rmna_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Vaćerindoj adava, phudinđa ano lende hem phenđa lenđe: “Priminen e Svetone Duho. ");
INSERT INTO rmna_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Kase oprostinena o grehija, oprostimei lenđe, a kase na oprostinena, nane lenđe oprostime.” ");
INSERT INTO rmna_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","A o Toma vičime Blizanco, jekh e dešu duje učenikonendar, na inele olencar kad o Isus alo. ");
INSERT INTO rmna_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Avera učenici phende lese: “Dikhljam e Gospode!” A ov phenđa lenđe: “Đikote na dikhava o ožiljci e ekserendar olese ko vasta hem na čhivava mlo naj ko than kaj inele o ekserija hem na čhivava mlo vas lese ko rebrija, na verujinava.” ");
INSERT INTO rmna_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Palo ofto dive, o učenici palem čedinde pe zajedno andre ano čher, a olencar inele hem o Toma. Iako o udara inele phandle, o Isus đerdinđa, hem terdino maškaro lende, i phenđa: “Mir tumencar.” ");
INSERT INTO rmna_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tegani phenđa e Tomase: “Čhiv to naj akate hem dikh mle vasta. Pružin to vas, i čhiv maje ko rebrija. Hem ma više sumnjin, nego verujin.” ");
INSERT INTO rmna_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","A o Toma tegani phenđa lese: “Mlo Gospod hem mlo Devel!” ");
INSERT INTO rmna_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","A o Isus phenđa lese: “Adalese so dikhljan man, poverujinđan. Blago okolenđe kola na dikhle, a poverujinde.” ");
INSERT INTO rmna_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","O Isus anglo ple učenici ćerđa pana but avera čudesna znakija save nane pisime ani akaja knjiga. ");
INSERT INTO rmna_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ali akavai pisime te verujinen dai o Isus o Hrist, o Čhavo e Devlesoro, hem te šaj, verujindoj, ovel tumen dživdipe ano lesoro anav. ");
INSERT INTO rmna_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Palo adava o Isus palem mothovđa pe ple učenikonenđe ko e Tiberijakoro jezero. A mothovđa pe ađahar: ");
INSERT INTO rmna_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","O Simon Petar, o Toma vičime Blizanco, o Natanailo tari Kana e Galilejakiri, e Zevedejesere čhave hem duj avera učenici inele zajedno. ");
INSERT INTO rmna_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","O Simon Petar phenđa lenđe: “Džava te dolav maćhen.” A on phende lese: “Hem amen ka dža tuja.” I džele hem đerdinde ano čamco, ali adaja rat na dolinde ništa. ");
INSERT INTO rmna_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","A rano sabale, o Isus terdino ki obala, ali o učenici na džande dai ov adava. ");
INSERT INTO rmna_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","O Isus pučlja len: “Amalalen, dolinđen li nešto?” A on phende lese: “Na.” ");
INSERT INTO rmna_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","A o Isus phenđa lenđe: “Frden i mreža ki desno strana oto čamco, hem ka dolen e maćhen.” I on frdinde i mreža hem edobor dolinde maćhen da našti ine te ikalen i mreža taro pani. ");
INSERT INTO rmna_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Tegani okova učeniko kole o Isus but volinđa, phenđa e Petrese: “Adavai o Gospod!” Kad šunđa dai adava o Gospod, o Simon Petar phandlja pe o ogrtači ko maškar, adalese so inele nango, hem ripinđa ano jezero. ");
INSERT INTO rmna_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","A avera učenici čamcoja ale đi i obala, vucindoj i mreža e maćhencar, adalese so na inele dur oti obala – đi sar šel metarija. ");
INSERT INTO rmna_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Kad iklile ki obala, dikhle i jag savi inele već thardi hem upro late maćhe hem maro. ");
INSERT INTO rmna_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","O Isus phenđa lenđe: “Anen nekobore maćhen adalendar save dolinđen.” ");
INSERT INTO rmna_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Tegani o Simon Petar uklilo ko čamco hem ki obala ikalđa i mreža, pherdi bare maćhencar – šelu pindu trin maćhe. Ali, iako inele edobor but, i mreža na pharavdili. ");
INSERT INTO rmna_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","A o Isus phenđa lenđe: “Aven hem han doručko.” Hem nijekh e učenikonendar na tromandilo te pučel le: “Ko injan tu?,” adalese so džande dai adava o Gospod. ");
INSERT INTO rmna_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Tegani o Isus lelja o maro hem dinđa len, a isto ađahar hem e maćhen. ");
INSERT INTO rmna_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Adava inele trito puti da o Isus mothovđa pe ple učenikonenđe sar uštino taro mule. ");
INSERT INTO rmna_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Kad hale maro, o Isus pučlja e Simone Petre: “Simone, čhaveja e Jovanesereja, volineja man li više nego akala?” O Petar phenđa lese: “Oja, Gospode, tu džane da volinava tut.” A o Isus phenđa lese: “Parvar mle bakroren.” ");
INSERT INTO rmna_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Tegani o Isus dujto puti pučlja le: “Simone, čhaveja e Jovanesereja, volineja man li?” A o Petar palem phenđa lese: “Oja, Gospode, tu džane da volinava tut.” A o Isus phenđa lese: “Arakh mle bakren.” ");
INSERT INTO rmna_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Tegani o Isus trito puti pučlja le: “Simone, čhaveja e Jovanesereja, volineja man li?” A o Petar rastužinđa pe so o Isus trito puti pučlja le: “Volineja man li?” I phenđa lese: “Gospode, tu džane sa, hem džane da volinava tut.” A o Isus phenđa lese: “Parvar mle bakren. ");
INSERT INTO rmna_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Čače, čače vaćerava će: kad injanle terno, korkoro phandeja tut ine to pojas hem džaja kaj mangeja. Ali kad ka puranđove, ka širine te vasta, i avera ka phanden tut hem ka legaren tut kaj na mangeja.” ");
INSERT INTO rmna_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","O Isus adava phenđa sar te mothoj save meribnaja o Petar ka proslavini e Devle. Tegani phenđa lese: “Phir pala mande.” ");
INSERT INTO rmna_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","O Petar irinđa pe hem dikhlja okole učeniko kole o Isus but volinđa sar phirela palo lende, okova kova zaki večera pašljarđa pe nakoro Isus hem pučlja le: “Gospode, ko ka izdajini tut?” ");
INSERT INTO rmna_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Kad o Petar dikhlja le, pučlja e Isuse: “Gospode, a so ka ovel akaleja?” ");
INSERT INTO rmna_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","A o Isus phenđa lese: “Te me mangava ov te ačhol dživdo đikote na irinav man, so isi tut adaleja? Tu phir pala mande.” ");
INSERT INTO rmna_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ađahar maškaro phralja šundilo da adava učeniko naka merel. Ali o Isus na phenđa da ov naka merel, nego: “Te me mangava te ačhol dživdo đikote na irinav man, so isi tut adaleja?” ");
INSERT INTO rmna_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Adava učeniko svedočini zako sa akava hem ov sa akava pisinđa, hem amen džanaja dai lesoro svedočanstvo čačikano. ");
INSERT INTO rmna_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ali, isi pana but so o Isus ćerđa hem te ovel ine sa palo redo pisime, mislinava da sa adala knjige naka resen ine ni ko sa o sveto!");
INSERT INTO rmna_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Cenimeja Teofile, ko mlo prvo lil pisinđum oto sa so o Isus lelja te ćerel hem te sikaj ");
INSERT INTO rmna_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","sa đi o dive kad legardilo ko nebo. Angleder so legardilo ko nebo, prekalo Sveto Duho dinđa naredbe e apostolenđe kolen birinđa. ");
INSERT INTO rmna_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Mothovđa pe lenđe palo plo meriba hem dinđa len but dokazija dai dživdo. Saranda dive mothovđa pe lenđe hem vaćerđa lenđe oto carstvo e Devlesoro. ");
INSERT INTO rmna_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","I jekhvar, sar pana inele zajedno olencar, naredinđa lenđe: “Ma ciden tumen taro Jerusalim, nego adžićeren upro daro savo mlo Dad obećinđa, savestar mandar šunđen. ");
INSERT INTO rmna_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Adalese so, o Jovan krstinđa panjeja, a tumen zako nekobor dive ka oven krstime e Svetone Duhoja.” ");
INSERT INTO rmna_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Tegani o apostolja čedinde pe uzalo leste hem pučle le: “Gospode, ka obnovine li akana o carstvo e Izraelesoro?” ");
INSERT INTO rmna_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","A ov phenđa lenđe: “Nane dindo tumenđe te džanen o vremenja ili o dive save o Dad odredinđa ani pli vlast. ");
INSERT INTO rmna_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ali, ka priminen o zoralipe kad o Sveto Duho ka huljel upra tumende hem ka oven mle svedoci ano Jerusalim, ani sa i regija Judeja hem i regija Samarija, hem sa đi ko krajo e phuvjakoro.” ");
INSERT INTO rmna_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","I kad phenđa adava, legardilo upre ko nebo anglo lengere jaćha, a jekh oblako učharđa le hem našti ine više te dikhen le. ");
INSERT INTO rmna_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","I sar dikhena ine nakoro nebo sar ov džala, otojekhvar duj murša ano parne šeja terdine uzalo lende ");
INSERT INTO rmna_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","hem phende lenđe: “Manušalen tari Galileja, sose terđovena hem dikhena ko nebo? Akava Isus kova lelja pe tumendar ko nebo, ađahar hem ka irini sar so dikhljen da džala ko nebo.” ");
INSERT INTO rmna_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Tegani on irinde pe ko Jerusalim tari gora savi vičini pe e Maslinakiri, a taro Jerusalim inele dur đi sar jekh kilometari. ");
INSERT INTO rmna_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Kad resle ani diz, uštine ki upruni soba kaj bešena ine: o Petar, o Jovan, o Jakov, o Andreja, o Filip, o Toma, o Vartolomej, o Matej, o Jakov (e Alfejesoro čhavo), o Simon Zilot, hem o Juda (e Jakovesoro čhavo). ");
INSERT INTO rmna_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Sare on bizo ačhojba sar jekh molinde pe e đuvljencar hem e Marijaja, e Isusesere dajaja, hem lesere phraljencar. ");
INSERT INTO rmna_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","I ko adala dive o Petar uštino maškaro učenici – a o narodo savo inele čedime ine paše uzalo šelu biš džene – hem phenđa lenđe: ");
INSERT INTO rmna_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Muršalen, phraljalen, valjanđa te pherđol o Lil ano savo but angleder o Sveto Duho prekalo muj e carosoro e Davidesoro vaćerđa e Judastar, kova predvodinđa okolen kola dolinde e Isuse. ");
INSERT INTO rmna_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Adalese so o Juda inele jekh amendar hem amencar inele ani akaja služba.” ");
INSERT INTO rmna_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(E parencar save o Juda lelja zako plo bišukar delo činđa pe i njiva. Adari pelo šereja tele, lesoro telo pharilo ko maškar hem sa lesere porja iklile. ");
INSERT INTO rmna_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Adava džanen sa o dizutne e Jerusalimesere, hem adaja njiva pese ki čhib vičinde Akeldamah – so značini: “Ratvali njiva.”) ");
INSERT INTO rmna_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Adalese soi pisime ano Lil e psalmengoro: ‘Nek ovel pusto lesoro čher hem nijekh te na bešel ano leste’ hem: ‘Nek olesiri služba lel neko aver.’ ");
INSERT INTO rmna_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Adalese, valjani, jekh akale manušendar kola inele amencar sa o vreme đikote o Gospod Isus živinđa maškar amende ");
INSERT INTO rmna_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","– počindoj e Jovanesere krstibnastar hem sa đi o dive kad amendar legardilo ko nebo – zajedno amencar te ovel svedoko lesere uštibnastar taro mule.” ");
INSERT INTO rmna_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Tegani predložinde dujen: e Josife vičime Varsava (pendžarutne hem sar Just) hem e Matija, ");
INSERT INTO rmna_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","i molinde pe, vaćerindoj: “Gospode, tu džane sarijengere vile. Mothov amenđe kole akale dujendar birinđan ");
INSERT INTO rmna_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","te prelel sar apostoli akaja služba, sava o Juda ačhavđa – sar te džal kaj lesoro than.” ");
INSERT INTO rmna_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","I frdinde o barbuti olenđe hem o barbuti pelo ko Matija. Ađahar ov upelo maškaro apostolja sar dešu dujto. ");
INSERT INTO rmna_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Kad alo o prazniko o Pentekost, o pindato dive palo prazniko Pasha, sare inele zajedno ko jekh than. ");
INSERT INTO rmna_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Otojekhvar taro nebo šundilo nesavo zvuk, sar kad phudela i zorali barval, hem pherđa sa o čher ano savo on inele. ");
INSERT INTO rmna_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","I dikhle nešto sar jagale jezici, save delinde pe hem huljile upro svako olendar. ");
INSERT INTO rmna_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Hem sare pherdile e Svetone Duhoja hem lelje te vaćeren ano avera jezici sar so dela len ine o Duho te vaćeren. ");
INSERT INTO rmna_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","A ko adava vreme ano Jerusalim inele o pobožna Jevreja kola ale taro svako narodo ki phuv. ");
INSERT INTO rmna_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Kad šunde adava zvuk, o narodo čedinđa pe hem inele zbunime, adalese so svako olendar šunđa e učenikonen sar vaćerena olesere čhibjaja. ");
INSERT INTO rmna_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Divinde pe hem čudinde pe, vaćerindoj: “Dikh, nane li sa akala kola vaćerena Galilejci? ");
INSERT INTO rmna_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Sar onda svako amendar šunela len pese ki čhib savi vaćeri pe adari kotar injam? ");
INSERT INTO rmna_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Maškar amende isi Parćanja, Međanja hem Elamcija, manuša tari Mesopotamija, Judeja, Kapadokija, Ponta, Tikori Azija, ");
INSERT INTO rmna_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigija, Pamfilija, Egipat hem taro thana e Libijakere uzali Kirina, hem okola kola ale taro Rim, ");
INSERT INTO rmna_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","(zajedno o Jevreja hem okola kola obratinde pe ki vera e jevrejengiri), o Krićanja hem o Arapija. Sare amen šunaja len sar ko amare čhibja vaćerena oto e Devlesere bare delja!” ");
INSERT INTO rmna_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","I sare zadivime hem zbunime, pučena ine jekh avere: “So akava značini?” ");
INSERT INTO rmna_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","A avera marde muj, vaćerindoj: “But pile gudli mol!” ");
INSERT INTO rmna_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Tegani o Petar, e dešujekhe apostolencar, terdino anglo lende, hem glasno phenđa lenđe: “Phraljalen Jevrejalen, hem sare tumen kola bešena ko Jerusalim, šunen mle lafija! Te džanen akava: ");
INSERT INTO rmna_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Akala manuša nane mate, sar so tumen mislinena, adalese soi pana enja o sati sabale. ");
INSERT INTO rmna_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Nego, akavai adava sostar vaćerđa o proroko o Joil: ");
INSERT INTO rmna_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Ko poslednja dive – phenela o Devel – ka čhorav mle Duho upro sa o manuša, hem tumare čhave hem čhaja ka prorokujinen, hem tumare terne čhaven ka ovel vizije, hem tumare purane ka dikhen sune. ");
INSERT INTO rmna_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","A hem upro mle sluge hem sluškinje adala dive ka čhorav mle Duho, hem on ka prorokujinen. ");
INSERT INTO rmna_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ka mothovav čudesija upre ko nebo hem znakija tele ki phuv – rat, jag hem oblaci oto dim. ");
INSERT INTO rmna_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","O kham ka ćerel pe ani tomina, a o masek ano rat angleder nego so avela o baro hem o slavno Dive e Gospodesoro. ");
INSERT INTO rmna_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Hem svako kova ka vičini o anav e Gospodesoro, ka ovel spasime.’ ");
INSERT INTO rmna_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Izraelconalen, šunen akala lafija: o Isus taro Nazaret inele manuš kole o Devel potvrdinđa angla tumende prekalo zorale delja, čudesija hem znakija save ćerđa prekalo leste, kad inele maškar tumende. Adava hem korkore tumen džanen. ");
INSERT INTO rmna_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ali o Devel džanđa so ka ovel, hem olesoro angleder ćerdo plan pherdilo kad o Isus inele predime tumenđe. Tumen, prekalo vasta e biedevlesere manušengere, kovinđen le ko krsto hem mudarđen le. ");
INSERT INTO rmna_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ali, o Devel vazdinđa le taro mule, hem oslobodinđa le taro e meribnasere muke, adalese so našti ine o meriba te ićeri le ani pli vlast. ");
INSERT INTO rmna_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","A o caro o David lestar vaćeri: ‘Uvek dikhljum e Gospode angla mande. Ovi maje oti desno strana, i adalese naka ovav peravdo. ");
INSERT INTO rmna_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Adalesei mlo vilo bahtalo hem mli čhib slavini e Devle oti radost, đi hem mlo telo ka živini ani nada, ");
INSERT INTO rmna_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","adalese so naka ačhave mli duša ano than e mulengoro, ni naka muke te Svecosoro telo te čirnjol. ");
INSERT INTO rmna_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Mothovđan maje e dživdipnasere droma, ka phere man bahtalipnaja ani ti prisutnost.’ ");
INSERT INTO rmna_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Phraljalen, sigurno injum ko akava so phenava tumenđe zako amaro pradad o David: ov mulo hem inele parume, a lesoroi grobo maškara amende sa đi akava dive. ");
INSERT INTO rmna_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ali, adalese so ov inele proroko hem džanđa da o Devel obećinđa lese ađahar so halja lese sovli da jekhe lesere potomkonendar ka čhivel lese ko than sar caro. ");
INSERT INTO rmna_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ov angleder dikhlja adava so valjani te ovel, i vaćerđa e Hristesere uštibnastar taro mule: ‘Na inele ačhavdo ano than e mulengoro, ni lesoro telo na čirnilo.’ ");
INSERT INTO rmna_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","O Devel akale Isuse vazdinđa taro mule, a sare amen injam svedoci adalestar. ");
INSERT INTO rmna_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Adalese so o Devel vazdinđa le ko počasno than, tari pli desno strana, e Dadestar priminđa e obećime Svetone Duho hem dinđa akava so akana tumen dikhena hem šunena. ");
INSERT INTO rmna_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Adalese so, o David na legardilo ko nebo, a palem, phenđa: ‘O Gospod phenđa mle Gospodese: Beš oti mli desno strana ");
INSERT INTO rmna_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","đikote na pašljarava te neprijateljen talo te pre.’ ");
INSERT INTO rmna_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Adalese sa e izraelesoro narodo šukar te džanel da akale Isuse, kole tumen čhivđen ko krsto, o Devel ćerđa te ovel hem Gospod hem Hrist.” ");
INSERT INTO rmna_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Kad adava šunde, but dukhandilo len ano vilo, hem pučle e Petre hem avere apostolen: “So valjani te ćera, phraljalen?” ");
INSERT INTO rmna_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","A o Petar phenđa lenđe: “Pokajinen tumen hem svako tumendar te krstini pe ano anav e Isuse Hristesoro zako oprostiba tumare grehengoro, hem ka priminen e Svetone Duho sar daro. ");
INSERT INTO rmna_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Adalese so, adavai obećanje tumenđe hem tumare čhavenđe hem sarijenđe kola živinena dur akatar, kolen amaro Gospod o Devel vičini kora peste.” ");
INSERT INTO rmna_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Hem pana bute avere lafencar svedočini lenđe ine hem upozorini len: “Spasinen tumen tari kazna savi avela upri akaja rumimi generacija.” ");
INSERT INTO rmna_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Tegani krstinde pe okola kola prihvatinde lesere lafija. Ađahar adava dive đi sar trin hiljade manuša pridružinde pe e učenikonenđe. ");
INSERT INTO rmna_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","On posvetinena pe ine ko sikaviba e apostolengoro, ko zajedništvo, ko phagiba o maro hem ko molitve. ");
INSERT INTO rmna_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","A i dar prelelja svakone manuše, adalese so but znakija hem čudesija inele ćerde prekalo apostolja. ");
INSERT INTO rmna_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","A sa o vernici inele zajedno hem sa ine lenđe zajedničko. ");
INSERT INTO rmna_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Biknena ine pumare phuvja hem okova so inolen hem delinena ine o pare svakonese edobor kobor valjanđa lese. ");
INSERT INTO rmna_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Svako dive bizo ačhojba hem sar jekh čedena pe ine ano Hram. Ko pumare čhera phagena ine o maro hem hana zajedno bahtale hem čačikane vileja. ");
INSERT INTO rmna_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Hvalinena ine e Devle hem sa o manuša mangena len ine. A o Gospod svako dive barjari ine o broj e spasimendar. ");
INSERT INTO rmna_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Jekhvar sar o Petar hem o Jovan džana ine ko Hram ki molitva, ko trin o sati, ");
INSERT INTO rmna_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","nesave manuša akharena ine e manuše kova našti ine te phirel pana taro bijandipe. Svako dive čhivena le ine uzali kapija e Hramesiri savi vičini pe Šuži, te prosini okolendar kola đerdinena ko Hram. ");
INSERT INTO rmna_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Kad dikhlja e Petre hem e Jovane sar mangena te đerdinen ko Hram, rodinđa lendar pare. ");
INSERT INTO rmna_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","A o Petar, zajedno e Jovaneja, šukar dikhlja ano leste hem phenđa lese: “Dikh amen!” ");
INSERT INTO rmna_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Hem ov dikhlja ano lende, adžićerindoj da ka den le nešto. ");
INSERT INTO rmna_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","A o Petar phenđa lese: “Nane man ni srebro, ni zlato, ali dava tut okova so isi man: ano anav e Isusesoro e Hristesoro taro Nazaret, ušti hem phir!” ");
INSERT INTO rmna_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","I dolinđa e manuše oto desno vas hem vazdinđa le. I otojekhvar lesere pre hem o ćanga ule zorjarde, ");
INSERT INTO rmna_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","i ov ripinđa ko pre hem lelja te phirel. Tegani olencar đerdinđa ko Hram, phirindoj, ripindoj hem hvalindoj e Devle. ");
INSERT INTO rmna_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Kad sa o manuša dikhle le sar phirela hem sar hvalini e Devle, ");
INSERT INTO rmna_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","pendžarde le dai ov okova kova bešela ine hem prosini angli e Hramesiri kapija vičimi Šuži. Adalese inele but začudime hem zadivime zako okova so ulo oleja. ");
INSERT INTO rmna_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Sar o sasljardo manuš na cidela pe ine e Petrestar hem e Jovanestar, sa o narodo inele začudime hem prastandilo koro lende ko trem savoi vičime e Solomonesoro. ");
INSERT INTO rmna_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Kad o Petar dikhlja adava, phenđa e narodose: “Izraelconalen, sose akava čudini tumen? Sose ađahar dikhena ana amende sar te phene da amen amare zoralipnaja ili zbog amari pobožnost ćerđam akava manuš te phirel? ");
INSERT INTO rmna_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","O Devel e Avraamesoro, e Isaakesoro hem e Jakovesoro, o Devel amare pradadengoro, proslavinđa ple sluga e Isuse, kole tumen dinđen te ovel mudardo hem odrekninđen tumen olestar anglo Pilat iako ov odlučinđa te mukel le. ");
INSERT INTO rmna_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Odrekninđen tumen e Svecostar hem e Pravednikostar, a rodinđen te mukel pe tumenđe e ubica. ");
INSERT INTO rmna_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Mudarđen okole kolestar avela o dživdipe, ali o Devel vazdinđa le taro mule, savese amen injam svedoci. ");
INSERT INTO rmna_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Pali vera ano e Isusesoro anav akava manuš, kole pendžarena hem dikhena, ulo sasto. I vera ano lesoro anav anđa o pherdo sastipe akale manušese anglo tumende sarijende. ");
INSERT INTO rmna_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","A akana, phraljalen, džanav da tumen, sar hem tumare vođe, ćerđen ađahar adalese so na džanđen. ");
INSERT INTO rmna_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ali o Devel ađahar pherđa okova so prekalo sa o proroci angleder vaćerđa – da lesoro Hrist ka patini. ");
INSERT INTO rmna_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Adalese, pokajinen tumen hem obratinen tumen te kosen pe tumare grehija, ");
INSERT INTO rmna_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","te šaj e Gospodestar avel o vreme zako nevo zoralipe hem te bičhali tumenđe e Isuse, kole već birinđa te ovel Hrist. ");
INSERT INTO rmna_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ov valjani te ačhol ko nebo sa đikote na avela o vreme o Devel te obnovini sa, sar so angleder obećinđa prekalo ple sveta proroci. ");
INSERT INTO rmna_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Adalese so, o Mojsije phenđa: ‘O Gospod, tumaro Devel, ka vazdel tumenđe tumare narodostar proroko sar mande. Šunen le šukar ko sa so ka vaćeri tumenđe! ");
INSERT INTO rmna_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","A svako kova naka šunel adale proroko, ka ovel cidime e Devlesere narodostar hem uništime.’ ");
INSERT INTO rmna_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Hem sa o proroci kola vaćerde, počindoj taro Samuilo, vaćerde zako akala dive. ");
INSERT INTO rmna_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Tumen injen naslednici oto obećanje savo o Devel dinđa prekalo proroci hem učestvujinena ano savez savo o Devel phandlja tumare pradadencar. Ov phenđa e Avraamese: ‘Prekalo to potomstvo ka oven blagoslovime sa o nacije ki phuv.’ ");
INSERT INTO rmna_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Kad o Devel vazdinđa ple sluga e Isuse, najangle tumenđe bičhalđa le, te blagoslovini tumen – te šaj svakone tumendar irini tumare bišukare dromendar.” ");
INSERT INTO rmna_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Sar o Petar hem o Jovan pana vaćerena ine e narodose, ale uzalo lende o sveštenici, o naredniko e hramesere stražakoro hem o sadukeja. ");
INSERT INTO rmna_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","On inele but uznemirime so o Petar hem o Jovan sikavena ine e manušen hem so, palo e Isusesoro primer, vaćerena ine oto uštiba taro mule, ");
INSERT INTO rmna_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","i dolinde len hem čhivde len ko phandlipe đi aver dive, adalese so već inele rat. ");
INSERT INTO rmna_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ali but okolendar kola šunde o Lafi poverujinde, i o broj e muršengoro barilo sar đi ko pandž hiljade. ");
INSERT INTO rmna_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Tejsa dive ko Jerusalim čedinde pe e jevrejengere šerutne, o starešine hem o učitelja e Zakonestar, ");
INSERT INTO rmna_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","o prvosvešteniko o Ana, o Kajafa, o Jovan, o Aleksandar hem avera tari porodica e šerutne sveštenikonengiri. ");
INSERT INTO rmna_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","On čhivde e Petre hem e Jovane angla pumende, i lelje te ispitujinen len: “Save zoralipnaja ili save anaveja sasljarđen e manuše?” ");
INSERT INTO rmna_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Tegani o Petar, pherdo e Svetone Duhoja, phenđa lenđe: “E narodosere šerutnalen hem starešinalen! ");
INSERT INTO rmna_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Te amenđe avdive sudini pe adalese so ćerđam šukaripe e namborme manušese, savejai ov sasljardo, ");
INSERT INTO rmna_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","onda te džanen sare tumen hem sa e izraelesoro narodo: akava manuš terđola angla tumende sasto, adalese soi sasljardo ano anav e Isuse Hristesoro taro Nazaret, kole tumen čhivđen ko krsto, a kole o Devel vazdinđa taro mule. ");
INSERT INTO rmna_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","O Isusi o ‘bar savo tumen o zidarija odbacinđen, a savo ulo najbitno bar e čheresoro.’ ");
INSERT INTO rmna_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Hem nane spasenje ano nijekh aver anav, adalese so e manušenđe nane dindo nijekh aver anav teleder o nebo saveja valjani te ova spasime.” ");
INSERT INTO rmna_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Kad dikhle so o Petar hem o Jovan na darana hem kad halile dai on obična manuša kola nane sikavde, začudinde pe. Džande da on inele e Isuseja, ");
INSERT INTO rmna_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ali, so dikhle e sasljarde manuše sar terđola olencar, na ine len so te phenen lenđe. ");
INSERT INTO rmna_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Tegani naredinde e Petrese hem e Jovanese te ikljon taro sabor, a on lelje te dogovorinen pe maškara pumende, ");
INSERT INTO rmna_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","vaćerindoj: “So te ćera akale manušencar? Sa o manuša taro Jerusalim džanen da prekalo lende inele ćerdo baro čudo hem amen našti te vaćera da na inele ađahar. ");
INSERT INTO rmna_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ali, te na širini pe akava više maškaro narodo, ka pretina len te na vaćeren više nikase ano adava anav.” ");
INSERT INTO rmna_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Tegani vičinde len, i naredinde lenđe nisar te na vaćeren hem te na sikaven više ano anav e Isusesoro. ");
INSERT INTO rmna_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ali o Petar hem o Jovan phende lenđe: “Tumen korkore dikhen soi ispravno anglo Devel, te ova poslušna tumenđe ili e Devlese. ");
INSERT INTO rmna_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","A amen našti te na vaćera okolestar so dikhljam hem so šunđam.” ");
INSERT INTO rmna_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","I on pana jekhvar pretinde len hem mukle len. Našti ine te arakhen sar te kazninen len adalese so sa o narodo slavinđa e Devle zako okova so ulo. ");
INSERT INTO rmna_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Adalese so, o manuš kova inele čudesno sasljardo inole više oto saranda berš. ");
INSERT INTO rmna_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kad o Petar hem o Jovan inele mukle, džele koro pumarende hem vaćerde lenđe adalestar so o šerutne sveštenici hem o starešine phende lenđe. ");
INSERT INTO rmna_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Kad on šunde adava, vazdinde pumaro glaso sar jekh hem molinde pe e Devlese akale lafencar: “O, Gospodarona, tu kova ćerđan o nebo hem i phuv, o more hem sa soi ano lende, ");
INSERT INTO rmna_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","tu e Svetone Duhoja, prekalo muj te slugasoro e Davidesoro, amare pradadesoro, phenđan: ‘Sose o avera nacije buninena pe, hem sose o narodija džabe planirinena zavere? ");
INSERT INTO rmna_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","O carija e phuvjakere uštena te džan ko mariba, hem o vladarija čedena pe zajedno hem džana protiv o Gospod hem protiv lesoro Pomazaniko.’ ");
INSERT INTO rmna_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Čače, o caro o Irod hem o vladari o Pontije Pilat ani akaja diz čedinde pe zajedno e avere nacijencar hem e Izraelesere narodoja protiv to sveto sluga o Isus, kole tu pomazinđan, ");
INSERT INTO rmna_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","te ćeren ađahar sar so tu angleder odredinđan pali ti volja hem palo to zoralipe. ");
INSERT INTO rmna_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","A akana, Gospode, dikh lengere pretnje hem de amenđe, te slugenđe, to Lafi te vaćera ani bari hrabrost. ");
INSERT INTO rmna_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Pružin to vas, te ovel sasljariba, znakija hem čudesija ano anav te svetone slugasoro e Isusesoro.” ");
INSERT INTO rmna_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Kad završinde i molitva, o than kote inele tresinđa hem sare pherdile e Svetone Duhoja, i lelje hrabro te vaćeren e Devlesoro lafi. ");
INSERT INTO rmna_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Sa o vernici inele jekh vileja hem dušaja. Nijekh na vaćerđa dai nešto oto lesoro barvalipe samo olesoro, nego sa adava ine lenđe zajedničko. ");
INSERT INTO rmna_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","O apostolja bare zoralipnaja svedočinena ine e Gospodesere e Isusesere uštibnastar taro mule, a e Devlesiri bari milost inele upro sarijende olende. ");
INSERT INTO rmna_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nikase olendar ništa na falinđa, adalese so okola kolen inele phuv ili čhera, biknena len ine ");
INSERT INTO rmna_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","hem anena o pare koro apostolja. Adalestar delinena ine o pare svakonese edobor kobor valjanđa lese. ");
INSERT INTO rmna_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ađahar hem nesavo Leviti palo anav Josif, taro Kipar, kole o apostolja vičinde Varnava (so značini da inele manuš kova ohrabrini), ");
INSERT INTO rmna_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","bikninđa pli njiva, a o pare anđa koro apostolja. ");
INSERT INTO rmna_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","A nesavo manuš kova vičinđa pe Ananija pla romnjaja e Sapfiraja bikninđa pli phuv, ");
INSERT INTO rmna_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","i dogovorinđa pe pla romnjaja te ačhaj pese nešto oto pare, a okova so ačhilo anđa koro apostolja. ");
INSERT INTO rmna_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Tegani o Petar phenđa lese: “Ananija, sose o Sotoni pherđa to vilo te hovave e Svetone Duho hem garavđan tuće nešto oto pare adalestar so bikninđan i njiva? ");
INSERT INTO rmna_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Na inele li ti njiva angleder so bikninđan la? A kad bikninđan la, našti li ine te ćere e parencar so tu mangeja? Sose ano to vilo odlučinđan te ćere akava? Tu na hovavđan e manušen, nego e Devle.” ");
INSERT INTO rmna_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Kad o Ananija šunđa adala lafija, ačhilo ko than mulo, a bari dar uklinđa sarijen kola adava šunde. ");
INSERT INTO rmna_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Nesave terne uštine hem paćarde lesoro telo, i ikalde le hem parunde le. ");
INSERT INTO rmna_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Đi sar palo trin saća ali e Ananijasiri romni, a na džanđa ništa adalestar so ulo. ");
INSERT INTO rmna_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","I o Petar pučlja la: “Vaćer maje, bikninđen li i njiva zako edobor pare?” A oj phenđa lese: “Oja, zako edobor pare.” ");
INSERT INTO rmna_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Tegani o Petar phenđa laće: “Sose dogovorinđen tumen te iskušinen e Gospodesere Duho? Ače, anglo udar terđovena okola kola parunde te rome, a hem tut ka ikalen.” ");
INSERT INTO rmna_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","I odmah i đuvli ko than ačhili muli anglo leste. Tegani đerdinde o terne hem arakhle la mulja, i ikalde la hem parunde la uzalo lakoro rom. ");
INSERT INTO rmna_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","I bari dar uklinđa sa e khanđirja hem sarijen kola šunde adava. ");
INSERT INTO rmna_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Prekalo apostolja ovena ine but znakija hem čudesija maškaro narodo. Sa o vernici sar jekh čedena pe ine ko trem e Solomonesoro. ");
INSERT INTO rmna_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Nijekh aver na tromandilo te pridružini pe lenđe, ali o narodo but hvalinđa len. ");
INSERT INTO rmna_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","A palem, inele sa više murša hem đuvlja kola poverujinde ano Gospod hem ule deo e vernikonendar. ");
INSERT INTO rmna_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Kad o Petar nakhela ine, o manuša ikalena ine pumare nambormen ko droma. Čhivena len ine ko than e pašljojbnasoro hem ko nosiljke te šaj barem lesiri senka perel upro lende. ");
INSERT INTO rmna_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","A but manuša avena ine hem taro dizja savei uzalo Jerusalim. Anena ine e nambormen hem e opsednutimen e bišukare duhencar, i sare ovena ine sasljarde. ");
INSERT INTO rmna_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Tegani o prvosvešteniko hem sa okola so inele oleja – oti stranka e sadukejengiri – ule but ljubomorna, ");
INSERT INTO rmna_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","i dolinde e apostolen hem frdinde len ano javno phandlipe. ");
INSERT INTO rmna_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ali kad peli i rat, o anđeo e Gospodesoro phravđa o udar e phandlipnasoro, i ikalđa len hem phenđa: ");
INSERT INTO rmna_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Džan ko Hram, terđoven anglo narodo hem vaćeren lenđe sa akale neve dživdipnastar.” ");
INSERT INTO rmna_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","I on šunde le, i rano sabaleja đerdinde ko Hram hem lelje te sikaven e narodo. Kad ale o prvosvešteniko hem okola so inele oleja, čedinde e manušen oto sabor, sa e izraelesere starešinen, i naredinde te anel pe taro phandlipe e apostolen. ");
INSERT INTO rmna_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ali, kad o stražarija resle ko phandlipe, na arakhle len adari, i irinde pe hem phende: ");
INSERT INTO rmna_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“O udar e phandlipnasoro inele šukar phandlo, a o stražarija terdine anglo udar. Ali, kad phravđam o udar, na arakhljam nikas andre.” ");
INSERT INTO rmna_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Kad šunde adava o naredniko e hramesere stražakoro hem o šerutne sveštenici, ule zbunime hem pučle pe so šaj te ovel adava. ");
INSERT INTO rmna_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Tegani neko alo hem phenđa lenđe: “Eče okola manuša kolen frdinđen ano phandlipe terđovena ano Hram hem sikavena e narodo!” ");
INSERT INTO rmna_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Tegani o naredniko ple stražarencar dželo hem anđa len, ali na zorjaja, adalese so darandile o narodo te na frden bara upro lende. ");
INSERT INTO rmna_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Kad ande len, čhivde len anglo sabor, a o prvosvešteniko lelja te ispitujini len: ");
INSERT INTO rmna_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Na li zorale naredinđam tumenđe te na sikaven e narodo ano adava anav? A palem tumen sa o Jerusalim pherđen tumare sikavibnaja hem mangena upro amende te perel o rat adale manušesoro.” ");
INSERT INTO rmna_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","A o Petar hem o avera apostolja phende: “E Devlese više valjani te ova poslušna nego e manušenđe. ");
INSERT INTO rmna_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","O Devel amare pradadengoro vazdinđa taro mule e Isuse, kole tumen čhivđen ko krsto hem mudarđen. ");
INSERT INTO rmna_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ole o Devel uzvisinđa hem čhivđa le pese ki desno strana sar Vođa hem Spasitelje, te šaj o Izrael te pokajini pe hem te oven lese oprostime o grehija. ");
INSERT INTO rmna_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Amen injam svedoci adalestar, sar hem o Sveto Duho, kole o Devel dinđa okolenđe kolai lese poslušna.” ");
INSERT INTO rmna_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kad o manuša oto sabor šunde adava, but holjande hem mangle te mudaren le. ");
INSERT INTO rmna_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ali tegani ko sabor uštino nesavo farisej palo anav Gamalilo, o učitelj e Zakonestar kole sa o narodo ceninđa. Ov naredinđa te ikalen hari avri e apostolen, ");
INSERT INTO rmna_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","i phenđa: “Izraelconalen, šukar razmislinen so ka ćeren akale manušencar. ");
INSERT INTO rmna_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Adalese so, angleder nesavo vreme iklilo o Tevda kova vaćerđa korkoro pese dai neko hem nešto, i verujinde lese đi sar štaršel manuša. Ali ov inele mudardo, a sa okola kola džele palo leste našle, i ađahar adalestar ništa na ulo. ");
INSERT INTO rmna_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Palo leste, zako vreme oto popis e manušengoro, iklilo o Juda o Galilejco hem pherđa e narodo te vazden buna. Hem ov inele mudardo, a sa okola kola džele palo leste našle. ");
INSERT INTO rmna_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Adalese akana vaćerava tumenđe te vazden tumare vasta akale manušendar hem te muken len. Adalese so, te lengoro plan hem o delo avela e manušendar, ka properel. ");
INSERT INTO rmna_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","A, te lengoro sikaviba avela e Devlestar, onda naka šaj te zaustavinen len, nego ka mothoven tumen sar okola kola marena pe e Devleja.” I o manuša oto sabor šunde le. ");
INSERT INTO rmna_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Tegani vičinde e apostolen te aven palem andre hem naredinde te šibinen len. Palo adava naredinde lenđe te na propovedinen ano anav e Isusesoro, i mukle len. ");
INSERT INTO rmna_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","O apostolja iklile taro sabor radosna adalese so o Devel dikhlja len dai dostojna te trpinen i lađ zbog o anav e Isusesoro. ");
INSERT INTO rmna_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","I svako dive ano Hram hem ano čhera bizo ačhojba sikavena ine e narodo hem propovedinena o Šukar lafi dai o Isus o Hrist. ");
INSERT INTO rmna_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Adala dive, sar o broj e učenikonengoro sa više barjola ine, o grčka Jevreja lelje te žalinen pe upro domaća Jevreja, adalese so lengere udovice inele zanemarime kad svako dive delini pe ine hajbnase. ");
INSERT INTO rmna_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Tegani o dešu duj apostolja vičinde kora pumende sa e učenikonen, i phende: “Nane šukar amen te zanemarina o propovediba o lafi e Devlesoro sar te raspodelina o hajba. ");
INSERT INTO rmna_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Adalese, phraljalen, arakhen maškara tumende efta manušen ko šukar glaso, kolai pherde Duhoja hem džandipnaja. Olen ka čhiva te ćeren akaja služba, ");
INSERT INTO rmna_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","a amen ka posvetina amen zaki molitva hem zako vaćeriba o lafi.” ");
INSERT INTO rmna_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Adava predlog inele šukar sa e čedimenđe, i birinde e Stefane, e manuše kova inele pherdo veraja hem e Svetone Duhoja, e Filipe, e Prohore, e Nikanore, e Timone, e Parmene hem e Nikola tari diz Antiohija, kova angleder obratinđa pe ki vera e jevrejengiri. ");
INSERT INTO rmna_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Adale efta manušen ande anglo apostolja, kola molinde pe hem čhivde pumare vasta upro lende. ");
INSERT INTO rmna_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ađahar e Devlesoro lafi širinđa pe. O broj e učenikonengoro ano Jerusalim but barilo, a maškaro lende inele hem but sveštenici e jevrejengere kola prihvatinde i vera. ");
INSERT INTO rmna_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","A o Stefan, o manuš pherdo milost hem zoralipe, ćerela ine bare čudesija hem znakija maškaro narodo. ");
INSERT INTO rmna_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ali, uštine nesave tari Sinagoga e oslobodimengiri (ađahar inele vičime) – o Jevreja tari Kirina, tari Aleksandrija, hem nesave tari Kilikija hem tari Tikori Azija, hem lelje te raspravinen pe e Stefaneja. ");
INSERT INTO rmna_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","A adalese so našti ine te suprotstavinen pe e džandipnase hem e Duhose saveja o Stefan vaćerđa, ");
INSERT INTO rmna_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","pherde nesave manušen te phenen: “Šunđam le sar vaćeri bišukar lafija e Mojsijastar hem e Devlestar.” ");
INSERT INTO rmna_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ađahar vazdinde pobuna maškaro narodo, maškaro starešine hem maškaro učitelja e Zakonestar, i on otojekhvar ale, dolinde le hem ande le anglo sabor. ");
INSERT INTO rmna_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Adari ande hem e hovavne svedokonen kola phende: “Akava manuš bizo ačhojba vaćeri protiv o sveto Hram hem protiv o Zakoni. ");
INSERT INTO rmna_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Šunđam le sar vaćeri da o Isus kovai tari Nazaret ka uništini akava Hram hem ka menjini o adetija save predinđa amenđe o Mojsije.” ");
INSERT INTO rmna_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","A sare kola bešle ko sabor zadikhle pe ano Stefan hem dikhle dai lesoro muj sar o muj e anđeosoro. ");
INSERT INTO rmna_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Tegani o prvosvešteniko pučlja e Stefane: “Čače li adava so vaćerena protiv tute?” ");
INSERT INTO rmna_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","A ov phenđa: “Phraljalen hem dadalen, šunen man! O Slavno Devel mothovđa pe amare pradadese e Avraamese sar pana inele ani Mesopotamija, angleder so dželo te živini ano Haran. ");
INSERT INTO rmna_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","O Devel phenđa lese: ‘Ačhav ti phuv hem te familija hem dža ki phuv savi me ka mothovav će.’ ");
INSERT INTO rmna_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","I o Avraam tegani ačhavđa i phuv e haldejconengiri hem dželo te živini ano Haran. Kad mulo lesoro dad, o Devel adathar anđa le te živini ki akaja phuv kaj tumen akana živinena. ");
INSERT INTO rmna_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","I na dinđa le nijekh najtikoro kotor oti phuv ano nasledstvo, nego dinđa le plo lafi da ka del adaja phuv ano nasledstvo olese hem lesere potomstvose palo leste, iako e Avraame pana na ine čhave. ");
INSERT INTO rmna_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","O Devel phenđa lese ađahar: ‘Te čhave ka oven abanđije ki averengiri phuv. Adari ka robujinen hem ka mučinen len štaršel berš.’ ");
INSERT INTO rmna_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","O Devel phenđa hem akava: ‘Ali me ka sudinav adale narodose kase on ka robujinen, a palo adava ka ikljoven adathar hem ka služinen man ko akava than.’ ");
INSERT INTO rmna_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Tegani o Devel dinđa e Avraamese savez, savesoroi znako o obreziba. I ađahar e Avraamese bijandilo o Isaak kole ko oftoto dive obrezinđa. E Isaakese bijandilo o Jakov, a e Jakovese o dešu duj bare dada. ");
INSERT INTO rmna_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","O bare dada inele ljubomorna upro pumaro phral o Josif, i bikninde le sar robo ano Egipat. Ali o Devel inele oleja ");
INSERT INTO rmna_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","hem ikalđa le taro sa olesere nevolje. Dinđa le džandipe hem ćerđa o faraon, o caro ano Egipat, te mislini olestar šukar. O faraon čhivđa le te ovel upravniko upro Egipat hem upri sa lesiri palata. ");
INSERT INTO rmna_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Tegani ano sa o Egipat hem ano Hanaan ulo bokhalipe hem bare nevolje, i amare pradada našti ine te arakhen hajbnase. ");
INSERT INTO rmna_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Kad o Jakov šunđa da ano Egipat isi điv, bičhalđa adari amare pradaden prvo puti. ");
INSERT INTO rmna_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","A kad o dujto puti džele adari, o Josif phenđa ple phraljenđe koi ov, i o faraon dodžanđa zaki e Josifesiri porodica. ");
INSERT INTO rmna_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Tegani o Josif bičhalđa palo plo dad o Jakov hem pali sa pli familija te aven ko Egipat – ukupno inele eftavardešu pandž džene. ");
INSERT INTO rmna_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ađahar o Jakov dželo ko Egipat kaj mulo ov hem amare pradada. ");
INSERT INTO rmna_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Olengere telija inele legarde ano Sihem hem inele čhivde ano grobo savo o Avraam ano Sihem činđa e Emoresere čhavendar zaki odredime cena. ");
INSERT INTO rmna_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Sar alo paše o vreme te pherđol o dindo lafi save o Devel dinđa e Avraamese, amaro narodo ano Egipat sa više barjola ine, ");
INSERT INTO rmna_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","sa đikote ano Egipat na lelja te vladini aver caro kova na džanđa e Josifese. ");
INSERT INTO rmna_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ov lukavo ćerđa amare narodoja: mučinđa amare pradaden hem ki zor čhivđa len te ačhaven avri pumare čhavoren, kola samo so bijandile, te meren. ");
INSERT INTO rmna_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ko adava vreme bijandilo o Mojsije. Ov inele posebno čhavoro anglo Devel. Trin masek inele arakhlo ple dadese ano čher. ");
INSERT INTO rmna_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","A kad ačhavde le avri, e faraonesiri čhaj lelja le hem arakhlja le sar ple čhave. ");
INSERT INTO rmna_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","O Mojsije inele barjardo ani sa i mudrost e Egipatesiri hem inele zoralo ano lafija hem ano delja. ");
INSERT INTO rmna_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Kad pherđa saranda berš, alo lese ki godi te džal te dikhel ple phraljen e Izraelconen. ");
INSERT INTO rmna_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Kad dikhlja sar jekh Egipćanin mučini jekhe Izraelco, ov lelja te branini le, hem osvetinđa le ađahar so mudarđa e Egipćanine. ");
INSERT INTO rmna_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mislinđa da lesere phralja ka haljoven da o Devel prekalo leste bičhali oslobođenje, ali on adava na halile. ");
INSERT INTO rmna_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Tejsato dive arakhlja duje Izraelconen sar marena pe. Ov dikhlja te mirini len vaćerindoj: ‘Manušalen, tumen injen phralja! Sose ćerena bišukaripe jekh averese?’ ");
INSERT INTO rmna_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","A jekh olendar kova lelja te marel pe ple pašutneja, gurinđa e Mojsija hem phenđa lese: ‘Ko tut čhivđa te ove vladari hem sudija upreder amende? ");
INSERT INTO rmna_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Na li mangeja hem man te mudare sar so erati mudarđan okole Egipćanine?’ ");
INSERT INTO rmna_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Kad o Mojsije šunđa adava, našlo taro Egipat hem dželo sar abanđija te živini ki phuv Midijan, kaj bijandile lese duj čhave. ");
INSERT INTO rmna_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Saranda berš palo adava, mothovđa pe lese o anđeo ki pustinja paše uzali gora Sinaj, ani jag upro grm savo thabljola ine. ");
INSERT INTO rmna_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","I dikhindoj adava, o Mojsije inele zadivime adaleja. Ali sar avela ine nakoro grm te dikhel po šukar, šunđa o glaso e Gospodesoro: ");
INSERT INTO rmna_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Me injum o Devel te pradadengoro, Devel e Avraamesoro, e Isaakesoro hem e Jakovesoro.’ O Mojsije tresinđa oti dar i na tromandilo te vazdel po šero te dikhel. ");
INSERT INTO rmna_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Tegani o Gospod phenđa lese: ‘Huljav o sandale te prendar, adalese so terđoveja ki sveto phuv. ");
INSERT INTO rmna_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Čače dikhljum o nevolje mle narodosere ano Egipat hem šunđum sar jecinena, i adalese huljiljum te oslobodinav len. Hajde akana! Ka bičhalav tut ko Egipat!’ ");
INSERT INTO rmna_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Adale Mojsija – kole odbacinde vaćerindoj: ‘Ko tut čhivđa te ove vladari hem sudija?’ – ole o Devel, prekalo anđeo kova mothovđa pe lese ko grmo, bičhalđa te ovel hem vladari hem izbavitelji. ");
INSERT INTO rmna_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","I ov ikalđa len adathar, ćerindoj čudesija hem znakija ano Egipat, ko Lolo more hem saranda berša ki pustinja. ");
INSERT INTO rmna_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Adavai okova Mojsije kova phenđa e Izraelconenđe: ‘O Devel tumare manušendar ka vazdel tumenđe proroko sar mande.’ ");
INSERT INTO rmna_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","O Mojsijei adava kova inele e čedime narodoja ki pustinja, e anđeoja kova vaćerđa lese ki gora Sinaj hem amare pradadencar. Ov priminđa o dživde lafija te predel len amenđe. ");
INSERT INTO rmna_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ali amare pradada na mangle te šunen le, nego odbacinde le hem pumare vileja irinde pe ano Egipat. ");
INSERT INTO rmna_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Phende e Aaronese: ‘Ćer amenđe devlen kola ka džan angla amende, adalese so na džana so ulo okole Mojsijaja kova ikalđa amen taro Egipat.’ ");
INSERT INTO rmna_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","I ko adala dive ćerde idole ano oblik e telcosoro, dinde lese žrtva hem slavinde zako adava so ćerde pumare vastencar. ");
INSERT INTO rmna_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Tegani o Devel irinđa pe olendar hem muklja len te slavinen o kham, o masek hem o čerenja ko nebo, sar soi pisime ano Lil e prorokonengoro: ‘Maje li dinđen žrtven hem darija saranda berš ani pustinja, o manušalen e Izraelesere? ");
INSERT INTO rmna_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Na, nego akharđen e Molohovesoro šatori hem i čereni tumare devlesiri e Refanesiri, e idolen save ćerđen te slavinen len! Adalese ka bičhalav tumen ano progonstvo’, po dur taro Vavilon. ");
INSERT INTO rmna_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Ki pustinja amare pradaden inele Šatori oto svedočanstvo, savo inele ćerdo ađahar sar so naredinđa Okova kova phenđa e Mojsijase te ćerel le palo nacrt savo dikhlja. ");
INSERT INTO rmna_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Amare pradada priminde le hem, legarde e Isuse Navinestar, ande le ani phuv e manušengiri kola na džande e Devlese kolen Devel ispudinđa adathar anglo lende. O šatori ačhilo adari sa đi o vreme e carosoro e Davidesoro. ");
INSERT INTO rmna_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","O David arakhlja milost anglo Devel, hem rodinđa lestar te šaj te vazdel čher e Jakovesere Devlese. ");
INSERT INTO rmna_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ali o Solomon inele adava kova vazdinđa lese čher. ");
INSERT INTO rmna_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ali, o Najbaro Devel na bešela ano čhera savei ćerde e manušengere vastencar, sar so phenela hem o proroko: ");
INSERT INTO rmna_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘O Gospod vaćeri: O neboi mlo presto, a i phuv than kote čhivava mle pre. Savo čher tumen šaj te vazden maje? Ili kaj o than mle odmoribnasoro? ");
INSERT INTO rmna_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Na ćerđa li mlo vas sa akava?’ ");
INSERT INTO rmna_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Tumen injen šerale manuša! Tumare vile hem o kana pana nane obrezime. Uvek protivinena tumen e Svetone Duhose! Ista injen sar tumare pradada! ");
INSERT INTO rmna_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Isi li proroko kole tumare pradada na progoninde? Mudarde đi hem okolen so angleder vaćerde oto aviba e Pravednikosoro, kole tumen akana izdajinđen hem mudarđen. ");
INSERT INTO rmna_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Tumen prekalo anđelja priminđen o Zakoni, ali na injenle lese poslušna.” ");
INSERT INTO rmna_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Kad šunde adava o šerutne e jevrejengere, but holjande upro leste, hem lelje te krcinen dandencar. ");
INSERT INTO rmna_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Tegani o Stefan, pherdo e Svetone Duhoja, dikhlja nakoro nebo hem dikhlja e Devlesiri slava hem e Isuse sar terđola e Devlese oti desno strana. ");
INSERT INTO rmna_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Tegani phenđa: “Ače, dikhava o nebo phravdo hem e Čhave e manušesere sar terđola e Devlese oti desno strana.” ");
INSERT INTO rmna_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","A ko adava on lelje te vičinen oto sa o glaso, phandle pumare kana hem sare sar jekh uštine upro leste. ");
INSERT INTO rmna_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ikalde le tari diz avri i lelje te frden bara upro leste. A o svedoci mukle pumare ogrtačija uzalo pre e ternesere kova vičinđa pe Savle. ");
INSERT INTO rmna_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","I sar frdena ine bara upro leste, o Stefan vičinđa: “Gospode Isuse, primin mle duho!” ");
INSERT INTO rmna_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Tegani pelo ko kočija hem vičinđa oto sa o glaso: “Gospode, ma računin lenđe akava greh!” I kad phenđa adava, mulo. ");
INSERT INTO rmna_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","A o Savle odobrinđa e Stefanesoro mudariba. I taro adava dive počinđa baro progonstvo upri Khanđiri ano Jerusalim, i sa o vernici, sem o apostolja, rasejinde pe ko thana e judejakere hem e samarijakere. ");
INSERT INTO rmna_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Nesave pobožna manuša parunde e Stefane hem but runde le. ");
INSERT INTO rmna_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","A o Savle lelja te uništini i Khanđiri. Džala ine oto čher ko čher, ki zor ikali e muršen hem e đuvljen hem čhivela len ine ko phandlipe. ");
INSERT INTO rmna_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Okola kola inele rasejime, propovedinena ine o Lafi kaj god džana. ");
INSERT INTO rmna_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ađahar o Filip huljilo ani jekh diz e samarijakiri hem propovedinđa lenđe e Hristestar. ");
INSERT INTO rmna_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","O narodo sare sar jekh šukar šunde lesere lafija hem dikhle o znakija save ćerđa. ");
INSERT INTO rmna_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Adalese so, o bišukar duhija vičindoj zorale ikljovena ine bute manušendar kola inele opsednutime, a sasljovena ine hem but manuša kola našti ine te phiren hem kola inele paralizujime. ");
INSERT INTO rmna_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Tegani uli bari radost ki adaja diz. ");
INSERT INTO rmna_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","A ki adaja diz već nesavo vreme o manuš palo anav Simon ćerela ine mađije savencar o narodo ani Samarija inele zadivime. Vaćeri ine pestar dai baro manuš, ");
INSERT INTO rmna_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","hem sare, oto najtikoro đi o najbaro, šukar šunena le ine hem vaćerena: “Akava manuš čačei e Devlesoro zoralipe, savo vičini pe Baro.” ");
INSERT INTO rmna_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Džana ine palo leste, adalese so već but vreme zadivini len ine ple mađijencar. ");
INSERT INTO rmna_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ali kad poverujinde e Filipese, kova propovedinđa o Šukar lafi e Devlesere carstvostar hem e Isuse Hristesere anavestar, krstinde pe hem o murša hem o đuvlja. ");
INSERT INTO rmna_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Hem korkoro o Simon poverujinđa hem krstinđa pe, hem stalno inele uzalo Filip. Ov inele oduševime dikhindoj o znakija hem o bare čudesija save ule. ");
INSERT INTO rmna_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Kad o apostolja ano Jerusalim šunde da o manuša tari Samarija prihvatinde e Devlesoro lafi, bičhalde adari e Petre hem e Jovane. ");
INSERT INTO rmna_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Kad on resle, molinde pe lenđe te priminen e Svetone Duho, ");
INSERT INTO rmna_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","adalese so o Sveto Duho pana na huljinđa upro nijekheste olendar, adalese so samo inele krstime ano anav e Gospodesoro e Isusesoro. ");
INSERT INTO rmna_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Tegani o apostolja, o Petar hem o Jovan, čhivde pumare vasta upro lende, hem on priminde e Svetone Duho. ");
INSERT INTO rmna_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Kad o Simon dikhlja so o manuša priminena e Svetone Duho ađahar so o apostolja čhivena pumare vasta upro lende, ov e apostolenđe manglja te del pare ");
INSERT INTO rmna_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","vaćerindoj: “Den hem maje adava zoralipe te šaj svako upra kaste ka čhivav mle vasta primini e Svetone Duho.” ");
INSERT INTO rmna_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","A o Petar phenđa lese: “Nek te pare zajedno tuja properen so mislinđan da e parencar šaj te čine e Devlesoro daro. ");
INSERT INTO rmna_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Tut ki akaja služba nane pravo adalese so to vilo nane šukar anglo Devel. ");
INSERT INTO rmna_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Adalese pokajin tut zako to bišukaripe hem molin tut e Gospodese hem šaj ka oprostini će so ano to vilo ine esavki misao. ");
INSERT INTO rmna_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Adalese so, dikhava tut da injan pherdo gorčina hem da injan phandlo ano greh.” ");
INSERT INTO rmna_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","A o Simon phenđa: “Molinen tumen e Gospodese maje te na arakhi man ništa adalestar so phenđen.” ");
INSERT INTO rmna_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Palo adava so svedočinde hem so mothovde lenđe o lafi e Gospodesoro, irinde pe ano Jerusalim, hem odrumal vaćerde o Šukar lafi ko but gava e Samarijakere. ");
INSERT INTO rmna_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Tegani o anđeo e Gospodesoro phenđa e Filipese: “Spremin tut, i dža nakoro jug ko drom savo maškari pustinja legari taro Jerusalim natele ki Gaza.” ");
INSERT INTO rmna_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","O Filip spreminđa pe hem dželo. Baš tegani reslja nesave manuše tari Etiopija, evnuho, kova inele baro manuš e caricakoro e Kandakoro, zadužime zako sa olakoro barvalipe. Ov inele ano Jerusalim te slavini e Devle. ");
INSERT INTO rmna_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Irindoj čhere taro Jerusalim beštino pese ani kočija hem čitinđa o Lil e prorokosoro e Isaijasoro. ");
INSERT INTO rmna_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Tegani o Duho phenđa e Filipese: “Dža nakori kočija hem ov paše uzalo late!” ");
INSERT INTO rmna_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","O Filip prastandilo uzali kočija, i kad šunđa da o Etiopljaninco čitini taro Lil e prorokosoro e Isaijasoro, pučlja le: “Haljoveja li adava so čitineja?” ");
INSERT INTO rmna_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","A o Etiopljaninco phenđa lese: “Sar šaj te haljovav kad nane ko te objasnini maje adava?” I vičinđa e Filipe te ukljel hem te bešel oleja. ");
INSERT INTO rmna_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","A ko adava than ko Lil savo o Etiopljaninco čitinđa, pisinđa akava: “Legarde le sar bakre ko čhiniba, hem sar so o bakroro traini anglo okola so muravena le, ađahar ni ov na phravđa plo muj. ");
INSERT INTO rmna_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Inele ponizime hem na sudinde lese pravedno. Niko naka vaćeri lesere potomkonendar, adalese so lelja pe lesoro dživdipe tari phuv.” ");
INSERT INTO rmna_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","A o evnuho pučlja e Filipe: “Phen maje, molinava tut, kastar adava o proroko vaćeri? Pestar ili nekastar averestar?” ");
INSERT INTO rmna_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Tegani o Filip, počindoj oto isto Lil, lelja te vaćeri lese o Šukar lafi e Isusestar. ");
INSERT INTO rmna_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","I sar džana ine dromeja ađahar, resle đi ko nesavo pani, i o evnuho phenđa: “Ače pani! So šaj te ačhaj man adalestar te ovav krstime?” ");
INSERT INTO rmna_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","A o Filip phenđa lese: “Šaj te krstine tut – te verujineja sa te vileja.” A o evnuho phenđa: “Verujinava dai o Isus Hrist e Devlesoro Čhavo.” ");
INSERT INTO rmna_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Tegani naredinđa i kočija te ačhol, hem soduj džene, o Filip hem o evnuho, huljinde đi ko pani, i o Filip krstinđa le. ");
INSERT INTO rmna_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","A kad iklile taro pani, o Duho e Gospodesoro otojekhvar lelja e Filipe, hem o evnuho više na dikhlja le, nego dželo ple dromeja radosno. ");
INSERT INTO rmna_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","A o Filip arakhlja pe ani diz Azot, i propovedini ine o Šukar lafi ko sa o dizja maškaro save nakhino sa đikote na reslo ani Cezareja. ");
INSERT INTO rmna_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","A o Savle, pana holjame pretini ine da ka mudari sa e Gospodesere učenikonen. Adalese dželo koro prvosvešteniko ");
INSERT INTO rmna_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","hem rodinđa lestar lila zako sinagoge ano Damask kote ka pisini da šaj, te arakhlja okolen kola džana palo Drom e Gospodesoro, muršen ili đuvljen, phandlen te anel len ko Jerusalim. ");
INSERT INTO rmna_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Kad alo paše uzalo Damask, otojekhvar svetlinđa taro nebo jekh zoralo svetlost upro leste. ");
INSERT INTO rmna_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","I ov pelo ki phuv hem šunđa glaso savo vaćeri lese: “Savle! Savle! Sose progonineja man?” ");
INSERT INTO rmna_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","A ov pučlja: “Ko injan tu, Gospode?” A o glaso phenđa lese: “Me injum o Isus, kole tu progonineja. ");
INSERT INTO rmna_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","A akana ušti hem đerdin ki diz hem adari ka phenel pe će so valjani te ćere.” ");
INSERT INTO rmna_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","A o manuša kola džana ine palo Savle ačhile bizo lafi, adalese so šunde o glaso, ali nikas na dikhle. ");
INSERT INTO rmna_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Kad o Savle uštino tari phuv, phravđa ple jaćha, ali ništa našti ine te dikhel, i adalese dolinde le oto vas hem legarde le ano Damask. ");
INSERT INTO rmna_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Trin dive našti ine te dikhel hem ništa ni halja ni pilja. ");
INSERT INTO rmna_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","A ano Damask inele nesavo učeniko palo anav Ananija. O Gospod ani vizija phenđa lese: “Ananija!” A ov phenđa: “Adathe injum, Gospode.” ");
INSERT INTO rmna_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","O Gospod phenđa lese: “Dža e Judase ko čher – ki ulica savi vičini pe Pravo, hem rode e Savle taro Tars. Ov akana molini pe. ");
INSERT INTO rmna_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ov ani vizija dikhlja manuše palo anav Ananija sar đerdini hem čhivela ple vasta upro leste te šaj dikhel.” ");
INSERT INTO rmna_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","A o Ananija phenđa lese: “Gospode, šunđum butendar da akava manuš ćerđa but bišukaripa te svetone manušenđe ano Jerusalim. ");
INSERT INTO rmna_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Đi hem akate isi le vlast oto šerutne sveštenici te phandel svakone kova verujini ano to anav.” ");
INSERT INTO rmna_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ali o Gospod phenđa lese: “Dža, adalese so me birinđum le prekalo leste te šunen maje avera nacije, o carija hem o narodo e Izraelesoro. ");
INSERT INTO rmna_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Me ka mothovav lese kobor valjani te trpini zako mlo anav.” ");
INSERT INTO rmna_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","I o Ananija dželo, đerdinđa ano čher hem čhivđa ple vasta upro leste hem phenđa lese: “Phrala Savle! O Gospod Isus, kova mothovđa pe će ko to drom nakari, bičhalđa man te šaj dikhe hem te pherđove e Svetone Duhoja.” ");
INSERT INTO rmna_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","I otojekhvar lesere jaćhendar pele nešto sar ljuske, i ov dikhlja. Tegani uštino hem krstinđa pe. ");
INSERT INTO rmna_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","I halja hem irinđa po zoralipe. Nekobor dive inele e učenikonencar ano Damask, ");
INSERT INTO rmna_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","hem odmah lelja ko sinagoge te propovedini dai o Isus o Čhavo e Devlesoro. ");
INSERT INTO rmna_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","I sare kola šunde le, inele začudime, hem pučle pe: “Nane li akava okova so ano Jerusalim mudari ine okolen so verujinena ano Isus? Na alo li akate te phandel len hem te legari len koro šerutne sveštenici?” ");
INSERT INTO rmna_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ali o Savle ovela ine sa po zoralo ano propovediba, dokažindoj e Jevrejenđe kola živinde ano Damask dai o Isus o Hrist, i ačhaj len ine bizo lafi. ");
INSERT INTO rmna_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","I kad nakhle but dive, o Jevreja dogovorinde pe te mudaren le, ");
INSERT INTO rmna_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ali o Savle dodžanđa zako lengoro plan. O Jevreja hem dive hem rat pazinena ine ko udar e dizjakere, sar te mudaren le, ");
INSERT INTO rmna_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ali lesere učenici jekh rat legarde le hem mukle le prekalo duvari e dizjakoro ani bari korpa. ");
INSERT INTO rmna_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Kad o Savle alo ko Jerusalim, manglja te ovel zajedno e učenikonencar, ali sare darandile lestar, adalese so na verujinde dai čače učeniko. ");
INSERT INTO rmna_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ali o Varnava pomožinđa lese hem legarđa le koro apostolja, i vaćerđa lenđe sar o Savle kad inele ko drom dikhlja e Gospode hem da o Gospod vaćerđa lese, hem sar ano Damask bizi dar propovedinđa e Isusese ko anav. ");
INSERT INTO rmna_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ađahar o Savle ačhilo olencar, i dželo maškaro Jerusalim hem bizi dar propovedinđa e Gospodese ko anav. ");
INSERT INTO rmna_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Vaćeri ine hem raspravini pe e Jevrejencar kola vaćerena ine grčki, ali on dikhle te mudaren le. ");
INSERT INTO rmna_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Kad o vernici šunde zako adava, legarde le ki Cezareja hem adathar bičhalde le ko Tars. ");
INSERT INTO rmna_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ađahar i Khanđiri ani sa i Judeja, ani Galileja hem ani Samarija inele ano mir. Ovela ine zorali, živindoj ani dar e Gospodestar, hem o broj e vernikonengoro barjola ine palo hrabriba e Svetone Duhostar. ");
INSERT INTO rmna_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","A sar o Petar nakhela ine maškaro adala regije, alo hem koro verna manuša kola živinde ki Lida. ");
INSERT INTO rmna_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Adari arakhlja nesave manuše palo anav Enej, kova ofto berš pašljola ine ki postelja nepokretno. ");
INSERT INTO rmna_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","I o Petar phenđa lese: “Enej, o Isus Hrist sasljari tut! Ušti hem namestin to than e pašljojbnasoro!” Hem ov otojekhvar uštino. ");
INSERT INTO rmna_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Kad dikhle e Eneja sare kola živinde ki Lida hem ko Saron, obratinde pe e Gospodese. ");
INSERT INTO rmna_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","A ki diz Jopa živinđa jekh učenica palo anav Tavita – so značini “Srna”, koja uvek ćerđa ine šukar delja hem pomožinđa e čororenđe. ");
INSERT INTO rmna_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","I ko adala dive oj namborsalili hem muli. Nanđarde la hem čhivde la ki upruni soba. ");
INSERT INTO rmna_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ali kad šunde o učenici dai o Petar ani Lida savi paše uzali Jopa, bičhalde koro leste duje manušen te phenen lese: “Molinaja tut odmah te ave amende!” ");
INSERT INTO rmna_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","O Petar uštino hem dželo olencar, a kad reslja, legarde le ki upruni soba. Sa o udovice terdine uzalo leste, runde hem mothovde lese o fostanja hem o šeja save i Tavita sivđa kad inele dživdi. ");
INSERT INTO rmna_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Tegani o Petar sarijen bičhalđa avri, i pelo ko kočija hem molinđa pe. Tegani irinđa pe nakoro mulo telo hem phenđa: “Tavito, ušti!” Oj phravđa ple jaćha, dikhlja e Petre hem beštini. ");
INSERT INTO rmna_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ov dinđa la plo vas hem vazdinđa la, i vičinđa e vernikonen hem e udovicen, hem mothovđa la olenđe dai dživdi. ");
INSERT INTO rmna_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","I adava šundilo ki sa i Jopa, i but džene poverujinde ano Gospod. ");
INSERT INTO rmna_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","A o Petar ačhilo ki Jopa nesavo vreme koro nesavo Simon kova inele kožari. ");
INSERT INTO rmna_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","A ki Cezareja živinđa jekh manuš palo anav Kornelije, kova inele e rimesoro kapetani upreder šel vojnici oti četa vičimi e Italijakiri. ");
INSERT INTO rmna_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ov inele pobožno hem darala ine e Devlestar, a ađahar hem sa lesere čherutne. Dela ine but milostinja e čorore Jevrejenđe hem stalno molini pe ine e Devlese. ");
INSERT INTO rmna_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Jekh dive, đi sar ko trin o sati diveste, jasno dikhlja ani vizija e Devlesere anđeo sar alo koro leste hem phenđa: “Kornelije!” ");
INSERT INTO rmna_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","O Kornelije dikhlja ano leste hem ki dar pučlja le: “Vaćer, Gospode?” A o anđeo phenđa lese: “O Devel na bisterđa upra tute adalese so prihvatinđa te molitve hem te milostinje sar žrtva. ");
INSERT INTO rmna_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Akana, bičhal te manušen ki Jopa te anen e Simone kovai vičime Petar. ");
INSERT INTO rmna_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ovi gosto nesave Simonesoro e kožaresoro, kasoroi čher uzalo more.” ");
INSERT INTO rmna_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Kad o anđeo kova vaćerđa lese dželo, o Kornelije vičinđa ple duje slugen hem jekhe pobožnone vojniko kova kandlja le, ");
INSERT INTO rmna_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","i vaćerđa lenđe sa hem bičhalđa len ki Jopa. ");
INSERT INTO rmna_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Tejsato dive đi sar ko ekvaš o dive, sar on džana ine dromeja hem avena paše nakori diz, o Petar uklinđa upro čher te molini pe. ");
INSERT INTO rmna_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","I bokhalilo hem manglja te hal, ali sar ćerena lese ine nešto hajbnase, ov dikhlja vizija. ");
INSERT INTO rmna_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Dikhlja phravdo nebo hem sar nešto sar baro platno savo ple štare krajonencar mukela pe ki phuv. ");
INSERT INTO rmna_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ano leste inele sa vrste e životinjendar saven isi štar pre, okolendar so lazinena phuvjaja hem e čirikljendar. ");
INSERT INTO rmna_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Tegani nesavo glaso phenđa lese: “Ušti, Petre, čhin hem ha!” ");
INSERT INTO rmna_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","A o Petar phenđa: “Nisar, Gospode! Adalese so nikad na haljum ništa soi palo amaro zakoni pogano hem nečisto.” ");
INSERT INTO rmna_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","A o glaso palem phenđa lese: “Ma tu vičin nečisto okova so o Devel ćerđa te ovel čisto!” ");
INSERT INTO rmna_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","I ađahar ulo trin puti, i onda o platno vazdinđa pe ko nebo. ");
INSERT INTO rmna_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","A sar o Petar pana čudini pe ine so šaj te ovel i vizija savi dikhlja, o manuša kolen o Kornelije bičhalđa raspučle pe kaj e Simonesoro čher i već inele angli kapija ");
INSERT INTO rmna_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","hem vičinde hem pučle adathe li bešela o Simon kovai vičime Petar. ");
INSERT INTO rmna_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Sar o Petar pana razmislini ine oti vizija, o Sveto Duho phenđa lese: “Eče, trin manuša rodena tut. ");
INSERT INTO rmna_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ušti, hulji hem dža olencar bizo te misline tut, adalese so me bičhalđum len.” ");
INSERT INTO rmna_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Tegani o Petar huljilo koro manuša hem phenđa: “Ače, me injum adava kole rodena. Sose aljen?” ");
INSERT INTO rmna_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","A on phende: “Bičhalđa amen e rimesoro kapetani o Kornelije, o pravedno manuš kova darala e Devlestar, kole ceninena sa o Jevreja. Olese o sveto anđeo phenđa te vičini tut pese ko čher, te šunel so isi tut te phene lese.” ");
INSERT INTO rmna_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Tegani o Petar vičinđa len andre hem ugostinđa len. I tejsato dive o Petar spreminđa pe hem dželo olencar, a oleja džele hem nesave phralja tari Jopa. ");
INSERT INTO rmna_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Aver dive reslja ki Cezareja. A o Kornelije adžićerđa len, i vičinđa pla familija hem ple paše amalen. ");
INSERT INTO rmna_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Kad o Petar đerdinđa ko čher, o Kornelije iklilo anglo leste, pelo uzalo lesere pre hem pokloninđa pe lese. ");
INSERT INTO rmna_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","O Petar vazdinđa le vaćerindoj: “Ušti! Hem me injum samo manuš.” ");
INSERT INTO rmna_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","I vaćerindoj oleja, o Petar đerdinđa hem arakhlja bute čedime manušen. ");
INSERT INTO rmna_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Tegani o Petar phenđa lenđe: “Tumen džanen da nane muklo e Jevrejcose te družini pe nekasar tari aver nacija ili te đerdini lese ko čher. Ali, o Devel maje mothovđa da nijekhe manuše na valjani te dikhav sar poganone ili nečistone. ");
INSERT INTO rmna_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Adalese, kad injumle vičime, aljum bizo te mislinav man. A akana phenen maje sose vičinđen man?” ");
INSERT INTO rmna_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","A o Kornelije phenđa lese: “Angleder štar dive, baš ko akava vreme, ko trin o sati prekalo dive, molinđum man maje ano čher, i otojekhvar terdino angla mande nesavo manuš ano sjajna šeja ");
INSERT INTO rmna_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","hem phenđa maje: ‘Kornelije, o Devel šunđa ti molitva hem dikhlja te milostinje e čororenđe. ");
INSERT INTO rmna_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Adalese bičhal nekas ki Jopa hem vičin e Simone kovai vičime Petar. Ovi gosto e Simonesoro e kožaresoro, kasoroi čher uzalo more.’ ");
INSERT INTO rmna_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Adalese odmah bičhalđum pala tute, a tu šukar ćerđan so aljan. Akana sare amen injam akate anglo Devel te šuna sa so naredinđa će o Gospod.” ");
INSERT INTO rmna_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Tegani o Petar lelja te vaćeri: “Čače akana dikhava da o Devel na ćerela razlika maškaro manuša, ");
INSERT INTO rmna_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","nego da taro svako narodo prihvatini okole kova lestar darala hem kova ćerela okova soi pravedno. ");
INSERT INTO rmna_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","O Devel bičhalđa o Lafi e Izraelconenđe, ađahar so mothovđa o Šukar lafi oto mir prekalo Isus Hrist – kovai Gospod sarijenđe. ");
INSERT INTO rmna_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Tumen džanen so ulo ki sa i Judeja, počindoj oti Galileja, palo krstiba savo o Jovan propovedinđa. ");
INSERT INTO rmna_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Džanen zako Isus taro Nazaret, kole o Devel pomazinđa e Svetone Duhoja hem e zoralipnaja. Ov dželo taro than ko than hem ćerđa šukaripe, sasljarindoj sa okolen kola inele tali vlast e bengesiri, adalese so o Devel inele oleja. ");
INSERT INTO rmna_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Amen injam svedoci zako sa adava so ćerđa ano Jerusalim hem ani sa i phuv e Jevrejengiri. On mudarde le ađahar so čhivde le ko krsto, ");
INSERT INTO rmna_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ali o Devel o trito dive vazdinđa le taro mule hem ćerđa te mothoj pe amenđe, ");
INSERT INTO rmna_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ali na sa e narodose, nego samo e svedokonenđe kolen o Devel angleder birinđa. Adala injam amen kola haljam hem piljam oleja palo lesoro uštiba taro mule. ");
INSERT INTO rmna_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ov naredinđa amenđe te propovedina e narodose hem te svedočina da ole o Devel odredinđa te ovel sudija e dživdenđe hem e mulenđe. ");
INSERT INTO rmna_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Olestar svedočinena sa o proroci, da svako kova verujini ano leste, prekalo lesoro anav primini oprostiba zako grehija.” ");
INSERT INTO rmna_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Sar pana o Petar vaćeri ine, o Sveto Duho huljilo upro sarijende kola šunde lesoro vaćeriba. ");
INSERT INTO rmna_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","A e jevrejengere vernici kola ale e Petreja, inele but zadivime so o Devel hem e manušenđe taro avera nacije dinđa sar daro e Svetone Duho, ");
INSERT INTO rmna_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","adalese so šunde len sar vaćerena ano avera jezici hem barjarena e Devle. Tegani o Petar phenđa: ");
INSERT INTO rmna_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Šaj li neko te zabranini akalenđe te oven krstime ano pani? Hem on priminde e Svetone Duho sar so hem amen.” ");
INSERT INTO rmna_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Tegani naredinđa te krstinen pe ano anav e Isuse Hristesoro. Palo adava on zamolinde e Petre te ačhol olencar pana nekobor dive. ");
INSERT INTO rmna_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","O apostolja hem o phralja ki sa i Judeja šunde so hem o manuša taro avera nacije priminde e Devlesoro lafi. ");
INSERT INTO rmna_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","A kad o Petar alo ko Jerusalim, nesave oto obrezime vernici lelje te kritikujinen le ");
INSERT INTO rmna_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","vaćerindoj: “Đerdinđan ko čher e manušengoro kola nane obrezime hem haljan olencar!” ");
INSERT INTO rmna_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Tegani o Petar redaja lelja te vaćeri lenđe sa so ulo: ");
INSERT INTO rmna_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Injumle ki diz Jopa hem molinđum man. Sar molinav man ine, dikhljum vizija. Dikhljum sar nešto sar baro platno savo ple štare krajonencar mukela pe ki phuv taro nebo hem avela đi mande. ");
INSERT INTO rmna_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Zadikhljum man ano adava hem dikhljum ano leste životinjen saven isi štar pre, divlja zverija, okolen so lazinena phuvjaja hem e čirikljen. ");
INSERT INTO rmna_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Tegani šunđum glaso savo phenđa maje: ‘Ušti, Petre, čhin hem ha!’ ");
INSERT INTO rmna_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","A me phenđum: ‘Nisar, Gospode! Adalese so nikad na čhivđum ano muj ništa soi palo amaro zakoni pogano ili nečisto.’ ");
INSERT INTO rmna_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","A o glaso odupral palem phenđa maje: ‘Ma tu vičin nečisto okova so o Devel ćerđa te ovel čisto!’ ");
INSERT INTO rmna_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","I ađahar ulo trin puti, i onda sa adava palem vazdinđa pe ko nebo. ");
INSERT INTO rmna_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","I ko adava momenti trin manuša, kola inele bičhalde kora mande tari Cezareja, terdine anglo čher ano savo injamle. ");
INSERT INTO rmna_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","A o Sveto Duho phenđa maje te džav olencar bizo te mislinav man. Mancar pođinde hem akala šov phralja, i đerdinđam ko čher adale manušesoro. ");
INSERT INTO rmna_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ov phenđa amenđe so dikhlja e anđeo sar terđola ano lesoro čher hem vaćeri: ‘Bičhal nekas ki Jopa te anen e Simone kovai vičime Petar. ");
INSERT INTO rmna_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ov ka vaćeri će o lafija palo save ka ove spasime tu hem sa te čherutne.’ ");
INSERT INTO rmna_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","I kad leljum te vaćerav lenđe, o Sveto Duho huljilo upro lende ađahar sar so huljilo upra amende ano početak. ");
INSERT INTO rmna_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Tegani setinđum man so o Gospod phenđa: ‘O Jovan krstinđa panjeja, a tumen ka oven krstime e Svetone Duhoja.’ ");
INSERT INTO rmna_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","I te o Devel dinđa len isto daro savo amen dinđa kad poverujinđam ano Gospod Isus Hrist, ko injum me te sprečinav e Devle ko adava?” ");
INSERT INTO rmna_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","A kad šunde adava, smirinde pe hem lelje te slavinen e Devle vaćerindoj: “Znači o Devel hem zako manuša taro avera nacije dinđa te obratinen pe hem te ovel len večno dživdipe!” ");
INSERT INTO rmna_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","A zako adava vreme o vernici kola inele rasejime zbog o progonstvo savo lelja te ovel kad o Stefan inele mudardo, resle sa đi Fenikija, Kipar hem Antiohija. On na propovedinde e Devlesoro lafi nikase sem e Jevrejenđe. ");
INSERT INTO rmna_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","A nesave olendar inele Kipranja hem Kirinci. I kad resle ki Antiohija, on vaćerde hem e Grkonenđe, mothovindoj lenđe o Šukar lafi e Gospodestar e Isusestar. ");
INSERT INTO rmna_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","O vas e Gospodesoro inele olencar, i but manuša poverujinde hem obratinde pe e Gospodese. ");
INSERT INTO rmna_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Adalestar šundilo đi ki khanđiri ano Jerusalim, i bičhalde e Varnava ki Antiohija. ");
INSERT INTO rmna_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Kad reslja adari hem kad dikhlja i milost e Devlesiri ko delo, ulo radosno hem lelja sarijen olen te ohrabrini te ačhoven verna e Gospodese sa pumare vileja, ");
INSERT INTO rmna_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","adalese so o Varnava inele šukar manuš, pherdo e Svetone Duhoja hem veraja. I but džene lelje te verujinen ano Gospod. ");
INSERT INTO rmna_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Palo adava o Varnava dželo ko Tars te rodel e Savle. ");
INSERT INTO rmna_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Kad arakhlja le, anđa le ki Antiohija. Adari berš dive čedena pe ine e khanđirjaja hem sikavena ine bute manušen. Najangle ki Antiohija o učenici inele vičime “hrišćanja”. ");
INSERT INTO rmna_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Adala dive ki Antiohija ale nesave proroci taro Jerusalim. ");
INSERT INTO rmna_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Jekh olendar, palo anav Agav, uštino hem pherdo e Duhoja prorokujinđa da ka ovel baro bokhalipe ko sa e rimesoro carstvo. (Adava hem ulo zako vreme e carosoro e Klaudijasoro). ");
INSERT INTO rmna_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","O učenici odlučinde te pomožinen e phraljenđe ki Judeja, ađahar so ka bičhalen lenđe sar kas kobor isi. ");
INSERT INTO rmna_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ađahar hem ćerde, i bičhalde o pare e starešinenđe palo Varnava hem o Savle. ");
INSERT INTO rmna_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ko adava vreme o caro o Irod lelja te mučini nesave manušen oti Khanđiri. ");
INSERT INTO rmna_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ađahar e mačeja mudarđa e Jovanesere phrale, e Jakove. ");
INSERT INTO rmna_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Kad o caro dikhlja dai adava šukar e jevrejengere šerutnenđe, naredinđa te dolen hem e Petre. Adava ulo zako Prazniko e bikvascone marengoro. ");
INSERT INTO rmna_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","A kad dolinđa le, frdinđa le ko phandlipe. Naredinđa te pazinen le štar straže po štar vojnici. O Irod manglja pali Pasha te ikali le anglo narodo te ovel lese sudime. ");
INSERT INTO rmna_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Sar e Petre pazinena ine ano phandlipe, i khanđiri zorale molinđa e Devle olese. ");
INSERT INTO rmna_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Angleder jekh rat nego so o Irod manglja te ikali e Petre anglo narodo, o Petar, phandlo duje lanconencar, suća maškaro duj vojnici, a o stražarija anglo udar pazinena ine o phandlipe. ");
INSERT INTO rmna_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Otojekhvar o anđeo e Gospodesoro mothovđa pe hem ulo baro svetlost ki ćelija kaj inele o Petar. O anđeo gurinđa e Petre ko rebrija hem džangavđa le vaćerindoj: “Hajde, sig ušti!” I o lancija e Petresere vastendar pele. ");
INSERT INTO rmna_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Palo adava o anđeo palem phenđa lese: “Phand tut o pojas hem čhiv će o sandale!” I o Petar ćerđa ađahar. Tegani o anđeo phenđa lese: “Uri tut o ogrtači hem phir pala mande!” ");
INSERT INTO rmna_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","I o Petar iklilo hem dželo palo leste, ali na džanđa dai čačimase adava so ćerela ine o anđeo, nego mislinđa da dikhela vizija. ");
INSERT INTO rmna_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Nakhle maškari prvo hem i dujto straža, i resle đi ki sastrenali kapija savi legari ki diz. Oj korkori phravdili anglo lende hem on iklile. Kad nakhle jekh ulica, o anđeo otojekhvar dželo olestar. ");
INSERT INTO rmna_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Tegani o Petar halilo so ulo hem phenđa: “Akana čače džanav da o Gospod bičhalđa ple anđeo hem spasinđa man e Irodesere vastendar hem oto sa so e jevrejengoro narodo adžićerđa te ovel mancar.” ");
INSERT INTO rmna_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Kad adava halilo, dželo đi o čher e Marijakoro, i daj e Jovanesiri kovai vičime Marko, kote but džene čedinde pe te molinen pe. ");
INSERT INTO rmna_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Kad o Petar khuvđa ko udar e kapijakoro, i sluškinja palo anav Roda dželi te dikhel koi adava. ");
INSERT INTO rmna_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Kad pendžarđa e Petresoro glaso, oti zorali radost na phravđa lese o udar, nego prastandili andre hem vaćerđa da o Petar terđola angli kapija. ");
INSERT INTO rmna_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","A on phende laće: “Tu na injan sasti!” A sar oj na ačhavđa te vaćeri dai adava čače, on phende: “Adavai lesoro anđeo!” ");
INSERT INTO rmna_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","A o Petar na ačhavđa te khuvel. I kad phravde o udar hem kad dikhle le, inele but zadivime. ");
INSERT INTO rmna_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","A o Petar e vasteja mothovđa lenđe te trainen, i palo adava vaćerđa lenđe sar o Gospod ikalđa le taro phandlipe, hem phenđa: “Javinen e Jakovese hem avere phraljenđe zako akava.” Palo adava iklilo hem dželo ko aver than. ");
INSERT INTO rmna_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Kad dislilo, uli bari pobuna maškaro vojnici zbog adava so ulo e Petreja. ");
INSERT INTO rmna_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","O Irod naredinđa te roden le, ali našti ine te arakhen le. Kad ispitujinđa e stražaren, naredinđa te mudaren len. Palo adava o Irod dželo tari Judeja ki Cezareja, i adari ačhilo nesavo vreme. ");
INSERT INTO rmna_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","A caro o Irod inele but holjame upro Tirćanja hem upro Sidoncija. I on čedinde pe zajedno hem ale koro leste te dikhen le. Adalese so pridobinde e carosere pomoćniko e Vlasta, zamolinde e Irode zako mir, adalese so lengiri phuv anela ine hajbnase tari e carosiri phuv. ");
INSERT INTO rmna_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ko dogovorime dive, o Irod urđa pe ple carikane šeja, beštino pese ko presto hem vaćerđa anglo narodo. ");
INSERT INTO rmna_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","A o narodo vičinđa: “Akavai o glaso e devlesoro, a na e manušesoro!” ");
INSERT INTO rmna_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","I otojekhvar o anđeo e Gospodesoro khuvđa e Irode, adalese so na dinđa slava e Devlese. Halje le o čirme hem mulo. ");
INSERT INTO rmna_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","A o lafi e Devlesoro širini pe ine hem o broj e vernikonengoro barjola. ");
INSERT INTO rmna_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","A o Varnava hem o Savle, kad završinde pumari buti, irinde pe taro Jerusalim ki Antiohija, a pumencar ande e Jovane vičime Marko. ");
INSERT INTO rmna_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ani khanđiri ani Antiohija inele akala proroci hem učitelja: o Varnava, o Simeon vičime Niger, o Lukija tari Kirina, o Manain, kova barilo e vladareja e Irodeja, hem o Savle. ");
INSERT INTO rmna_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","I sar jekhvar slavinena ine e Gospode hem postinena, o Sveto Duho phenđa: “Ciden maje akana e Varnava hem e Savle zaki buti ki savi me vičinđum len.” ");
INSERT INTO rmna_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Tegani on, palo postiba hem moliba, čhivde pumare vasta upro lende hem bičhalde len ko drom. ");
INSERT INTO rmna_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","A o Savle hem o Varnava, bičhalde e Svetone Duhostar, džele ki Selevkija, i adathar otplovinde ko Kipar. ");
INSERT INTO rmna_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Kad resle ki Salamina, mothovde e Devlesoro lafi ano e jevrejengere sinagoge, a o Jovan vičime Marko inele lengoro pomoćniko. ");
INSERT INTO rmna_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","I sar nakhena ine maškaro sa o ostrvo, resle đi ko Paf. Adari resle nesave vračare hem hovavne proroko, Jevreje palo anav Varisus Elima. ");
INSERT INTO rmna_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ov inele amal e upravnikosoro e Sergije Pavlesoro, kova inele mudro manuš. Ov vičinđa kora peste e Varnava hem e Savle hem rodinđa olendar te šunel e Devlesoro lafi. ");
INSERT INTO rmna_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ali, olenđe protivinđa pe o Elima, o vračari (adavai prevod lesere anavesoro), mangindoj te cidel e upravniko oti vera. ");
INSERT INTO rmna_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Tegani o Savle, kovai vičime hem Pavle, pherdo e Svetone Duhoja, dikhlja ano Elima ");
INSERT INTO rmna_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","hem phenđa lese: “Čhaveja e bengesereja hem neprijateljona zako sa soi pravedno! Pherdo injan oto svako lukavstvo hem hovajba! Đikote više ka banđare o prava droma e Gospodesere? ");
INSERT INTO rmna_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ače, akana e Gospodesoro vas uštela protiv tute: ka koroljove hem nesavo vreme naka dikhe o kham.” I otojekhvar i tomina hem o kalipe pele upro leste, i ov lelja te vrtini pe ko krugo rodindoj kas te dolel oto vas. ");
INSERT INTO rmna_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Kad o upravniko dikhlja adava so ulo, poverujinđa hem inele zadivime e Gospodesere sikavibnaja. ");
INSERT INTO rmna_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","O Pavle hem okola so inele oleja otplovinde taro Paf hem resle ki Perga ani Pamfilija. Adari o Jovan vičime Marko ačhavđa len hem irinđa pe ano Jerusalim. ");
INSERT INTO rmna_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","A on tari Perga lelje te džan po dur. Kad resle ki Antiohija e Pisidijakiri, ko savato đerdinde ki sinagoga hem beštine. ");
INSERT INTO rmna_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Palo čitiba taro Zakoni hem o Proroci, e sinagogakere vođe bičhalde lenđe akava lafi: “Phraljalen, te isi tumen nesavo lafi te ohrabrinen e narodo, vaćeren.” ");
INSERT INTO rmna_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Tegani o Pavle uštino, dinđa znako e vasteja te trainen hem lelja te vaćeri: “Izraelconalen hem tumen avera kola darana e Devlestar, šunen: ");
INSERT INTO rmna_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","O Devel akale narodosoro, e Izraelesoro, birinđa amare pradaden hem ćerđa amare narodo te ovel baro zako vreme kad inele ano Egipat sar abanđije, i ple zorale vasteja ikalđa le adathar. ");
INSERT INTO rmna_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Đi sar saranda berš trpinđa len ani pustinja. ");
INSERT INTO rmna_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","I kad ano Hanaan uništinđa eftane naroden, lengiri phuv dinđa e Izraelconenđe ano nasledstvo. ");
INSERT INTO rmna_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Sa adava ulo ano đi sar štaršelu pinda berš. Palo adava o Devel dinđa len sudijen, sa đi ko proroko o Samuilo. ");
INSERT INTO rmna_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Tegani rodinde caro hem o Devel dinđa len e Saule, e čhave e Kisesere, e manuše taro pleme e Venijaminesoro. Ov vladinđa saranda berš. ");
INSERT INTO rmna_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Kad o Devel cidinđa e Saule, čhivđa lenđe e Davide sar caro, kolese korkoro vaćerđa: ‘Arakhljum e Davide, e Jesejesere čhave, e manuše palo mlo vilo, kova ka ćerel sa okova so mangava.’ ");
INSERT INTO rmna_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Taro e Davidesoro potomstvo o Devel, palo plo obećanje, vazdinđa e Izraelese e Spasitelje e Isuse. ");
INSERT INTO rmna_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Angleder so o Isus alo, o Jovan o Krstitelj propovedinđa sa e izraelesere narodose da valjani te pokajinen pe hem te krstinen pe. ");
INSERT INTO rmna_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Kad o Jovan ćerđa okova so valjanđa, phenđa lenđe: ‘Na injum me adava kova tumen mislinena. Ali, ače, ov avela pala mande. Me na injum dostojno ni o dorikha oti lesiri obuća te phravav.’ ");
INSERT INTO rmna_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Phraljalen, e Avraamesere čhavalen hem tumen taro avera nacije so darana e Devlestar, amenđei bičhaldo akava Lafi oto spasenje. ");
INSERT INTO rmna_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Adalese so o dizutne taro Jerusalim hem lengere šerutne na pendžarde e Isuse, nego osudinde le. Ađahar pherde o lafija e prorokonengere save svako savato čitinena a na haljovena len. ");
INSERT INTO rmna_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Iako na arakhle nisavi krivica zaki savi zaslužini meriba, rodinde e Pilatestar te mudari le. ");
INSERT INTO rmna_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","A kad ćerde sa so olestar inele pisime, huljavde le taro krsto hem čhivde le ko grobo. ");
INSERT INTO rmna_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ali o Devel vazdinđa le taro mule, ");
INSERT INTO rmna_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","i ov but dive mothovđa pe okolenđe kola oleja ale tari regija Galileja ko Jerusalim, a kolai akana lesere svedoci anglo e izraelesoro narodo. ");
INSERT INTO rmna_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Amen vaćeraja tumenđe o Šukar lafi: o obećanje savo o Devel dinđa amare pradadenđe, ");
INSERT INTO rmna_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","pherđa le upro amare čhavende, adaleja so vazdinđa e Isuse taro mule, sar soi pisime ano dujto psalam: ‘Tu injan mlo Čhavo, avdive uljum tuće Dad.’ ");
INSERT INTO rmna_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","A adalestar so o Devel vazdinđa le taro mule, nikad lesoro telo te na čirnjol ano grobo, phenđa ađahar: ‘Ka dav tumen o sveta hem o sigurna blagoslovija save obećinđum e Davidese.’ ");
INSERT INTO rmna_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ađahar hem ko aver than vaćeri: ‘Tu naka muke te Svecosoro telo te čirnjol.’ ");
INSERT INTO rmna_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Akate na vaćeri pe e Davidestar, adalese so ov kandlja ple narodose pali e Devlesiri volja hem palo adava mulo hem inele parume, a lesoro telo čirnilo ano grobo. ");
INSERT INTO rmna_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Akate vaćeri pe nekastar averestar – kole o Devel vazdinđa taro mule hem kasoro telo na čirnilo. ");
INSERT INTO rmna_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Adalese, phraljalen, te džanen da prekalo Isus mothoj pe tumenđe o oprostiba e grehengoro. Hem oto sa ano so našti ine te opravdinen tumen e Mojsijasere zakoneja, ");
INSERT INTO rmna_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","e Isuseja opravdini pe svako kova verujini. ");
INSERT INTO rmna_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Adalese, pazinen te na resel tumen okova so o Devel phenđa prekalo proroci: ");
INSERT INTO rmna_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Dikhen, tumen so marena muj, čudinen tumen hem oven uništime, adalese so ka ćerav nešto ano tumare dive savese naka verujinen ine te neko vaćeri le ine tumenđe.’” ");
INSERT INTO rmna_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Sar o Pavle hem o Varnava ikljovena ine tari sinagoga, zamolinde len hem aver savato te vaćeren adalestar. ");
INSERT INTO rmna_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Kad o sastanak završinđa pe, but Jevreja hem o pobožna manuša kola obratinđe pe ki vera e jevrejengiri džele palo Pavle hem palo Varnava, kola vaćerena ine olencar hem hrabrinena len te oven istrajna ano živiba pali milost e Devlesiri. ");
INSERT INTO rmna_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Aver savato čedinde pe skoro sa o manuša tari diz, te šunen o lafi e Gospodesoro. ");
INSERT INTO rmna_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ali, kad o Jevreja dikhle adava so čedinde pe but manuša, pherdile ljubomora, i lelje te džan protiv e Pavlesere lafija hem vređinena le ine. ");
INSERT INTO rmna_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","A o Pavle hem o Varnava bizi dar phende lenđe: “Valjanđa o lafi e Devlesoro najangle te ovel tumenđe e Jevrejenđe mothovdo. Ali, adalese so tumen na mangena le hem na dikhena tumen sar dostojna zako večno dživdipe, akana irinaja amen nakoro manuša taro avera nacije. ");
INSERT INTO rmna_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Adalese so, ađahar o Gospod naredinđa amenđe: ‘Čhivđum tut te ove svetlost e manušenđe taro avera nacije, te ane o spasenje ko sa o thana e phuvjakere.’ ” ");
INSERT INTO rmna_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Kad o manuša taro avera nacije šunde adava, lelje te radujinen pe hem te slavinen e Gospodesoro lafi, i poverujinde sare kola inele odredime zako večno dživdipe. ");
INSERT INTO rmna_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","A o lafi e Gospodesoro širini pe ine ko sa adava krajo. ");
INSERT INTO rmna_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ali o Jevreja tegani vazdinde pobuna maškaro ugledna hem pobožna đuvlja hem o šerutne e dizjakere, i lelje te progoninen e Pavle hem e Varnava hem ispudinde len taro pumaro krajo. ");
INSERT INTO rmna_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","A on tresinde i prašina pumare prendar sar znako zako zoralo odbiba, i džele ko Ikonijum. ");
INSERT INTO rmna_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","A o učenici inele pherde bahtalipnaja hem e Svetone Duhoja. ");
INSERT INTO rmna_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Sar so hem ko avera thana, hem ano Ikonijum o Pavle hem o Varnava đerdinde ki sinagoga e jevrejengiri. Ađahar vaćerde e Isusestar da poverujinde but Jevreja hem Grci. ");
INSERT INTO rmna_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","A o Jevreja kola na poverujinde, pobuninde e manušen taro avera nacije hem pherde len te džan protiv o phralja. ");
INSERT INTO rmna_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Adalese o Pavle hem o Varnava ačhile adari pana but dive hem bizi dar vaćerde e Gospodestar, kova potvrdini ine o Lafi oti pli milost ađahar so dinđa len te ćeren znakija hem čudesija. ");
INSERT INTO rmna_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","A maškaro manuša tari adaja diz uli podela: nesave inele ki strana e jevrejengiri, a avera ki strana e apostolengiri. ");
INSERT INTO rmna_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","A nesave manuša taro avera nacije hem taro Jevreja, zajedno pumare šerutnencar, odlučinde te ćeren lenđe bišukaripe hem te frden bara upro lende sar te mudaren len. ");
INSERT INTO rmna_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Kad o Pavle hem o Varnava šunde zako adava, našle ki regija Likaonija, ko dizja Listra hem ki Derva hem ko lengoro krajo, ");
INSERT INTO rmna_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","hem adari propovedinena ine o Šukar lafi. ");
INSERT INTO rmna_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ki Listra bešela ine nesavo manuš kova našti ine te phirel; ov nikad na phirđa, adalese so pana taro bijandiba inele nepokretno. ");
INSERT INTO rmna_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Sar šunela ine e Pavle sar propovedini, o Pavle šukar dikhlja ano leste, hem adalese so dikhlja da isi le vera te ovel sasljardo, ");
INSERT INTO rmna_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","bare glasoja phenđa lese: “Ušti tuće ko pre!” I o manuš ripinđa ko pre hem lelja te phirel. ");
INSERT INTO rmna_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Kad o narodo dikhlja so o Pavle ćerđa, vičinde ki čhib e likaonijakiri: “O develja ule sar manuša hem huljile maškar amende!” ");
INSERT INTO rmna_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","E Varnava lelje te vičinen Zevs, a e Pavle Hermes, adalese so o Pavle inele glavno govorniko. ");
INSERT INTO rmna_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","A o svešteniko e Zevsesere hramesoro, savo inele odmah uzali diz, anđa e guruven hem o vencija anglo udar e dizjakoro, i manglja zajedno e narodoja te del žrtva e apostolenđe. ");
INSERT INTO rmna_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Kad šunde adava o apostolja o Varnava hem o Pavle, pharavde pumare šeja upra pumende adalese so na složinde pe adaleja, i džele maškaro narodo vičindoj: ");
INSERT INTO rmna_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Manušalen, so ćerena adava? Hem amen samo injam manuša sar tumen. Amen propovedinaja tumenđe o Šukar lafi, te ciden tumen taro akala beskorisna stvarija hem te irinen tumen e dživde Devlese, kova ćerđa o nebo hem i phuv, o more hem sa soi ano lende. ");
INSERT INTO rmna_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","O Devel ani prošlost muklja sa e naroden te džan pumare dromeja, ");
INSERT INTO rmna_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ali nikad na ačhavđa tumen bizo svedočanstvo pestar: ov ćerela tumenđe šukaripe, dela tumen o bršim taro nebo hem e i žetva kadi lakoro vreme, čaljari tumen hajbnaja hem pherela tumare vile bahtalipnaja.” ");
INSERT INTO rmna_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Vaćerindoj adava, jedva čhinavde e narodo te na den lenđe žrtva. ");
INSERT INTO rmna_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Tegani ale nesave Jevreja tari Antiohija hem taro Ikonijum hem pherde e narodo, i gađinde barencar e Pavle hem ikalde le avri tari diz, adalese so mislinde dai mulo. ");
INSERT INTO rmna_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ali kad o učenici čedinde pe uzalo leste, ov uštino hem irinđa pe ani diz, a tejsato dive dželo e Varnavaja ki Derva. ");
INSERT INTO rmna_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Kad vaćerde o Šukar lafi ki adaja diz hem kad ćerde bute učenikonen, irinde pe ki Listra, ko Ikonijum hem ki Antiohija. ");
INSERT INTO rmna_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Adari zorjarde e učenikonen hem hrabrinde len te ačhoven ani vera. Vaćerde lenđe: “Ano carstvo e Devlesoro valjani te đerdina prekalo but nevolje.” ");
INSERT INTO rmna_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ki svako khanđiri čhivde lenđe starešinen, i molibnaja hem postibnaja, poverinde len e Gospodese, ana kaste verujinde. ");
INSERT INTO rmna_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Palo adava nakhine maškari Pisidija hem resle ki Pamfilija. ");
INSERT INTO rmna_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Kad vaćerde e Devlesoro lafi ki Perga, džele ki Atalija. ");
INSERT INTO rmna_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Adathar otplovinde ki Antiohija, kaj angleder inele poverime zaki milost e Devlesiri zaki služba savi ćerde. ");
INSERT INTO rmna_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Kad resle, čedinde i khanđiri hem vaćerde lenđe oto sa so o Devel ćerđa prekalo lende, hem sar hem e manušenđe taro avera nacije phravđa o udar e verakere. ");
INSERT INTO rmna_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","I adari ačhile but vreme e učenikonencar. ");
INSERT INTO rmna_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","A nesave manuša ale tari Judeja, i lelje te sikaven e phraljen: “Te na obrezinđen tumen palo e Mojsijasoro adeti, našti te oven spasime.” ");
INSERT INTO rmna_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","I kad e Pavle hem e Varnava ine bari rasprava hem debata olencar, inele odredime o Pavle hem o Varnava hem pana nesave phralja, zbog akaja rasprava, te džan ko Jerusalim koro apostolja hem koro starešine. ");
INSERT INTO rmna_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ađahar i khanđiri bičhalđa len ko drom, a on, nakhindoj maškari Fenikija hem i Samarija, sa detaljno vaćerena ine oto obratiba e manušengoro kola nane Jevreja, hem adaleja ande bari radost sa e phraljenđe. ");
INSERT INTO rmna_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Kad resle ko Jerusalim, priminde len i khanđiri, o apostolja hem o starešine, a on vaćerde lenđe sa so o Devel ćerđa prekal olende. ");
INSERT INTO rmna_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ali uštine nesave vernici e farisejendar, i phende: “Okola kola nane Jevreja valjani te obrezinen pe hem valjani te naredini pe lenđe te ićeren pe ko e Mojsijasoro zakoni.” ");
INSERT INTO rmna_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","O apostolja hem o starešine čedinde pe te vaćeren adalestar. ");
INSERT INTO rmna_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Pali bari rasprava, o Petar uštino hem phenđa lenđe: “Phraljalen, tumen džanen da pana taro anglune dive o Devel birinđa man maškaro tumende te šaj o manuša taro avera nacije mle mujestar te šunen o Šukar lafi hem te poverujinen. ");
INSERT INTO rmna_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Hem o Devel, kova pendžari o vile, potvrdinđa da prihvatinđa len ađahar so dinđa len e Svetone Duho sar hem amen. ");
INSERT INTO rmna_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ov na ćerđa nisavi razlika maškar olende hem amende, adalese so hem olengere vile očistinđa prekali vera. ");
INSERT INTO rmna_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Sose, onda, akana iskušinena e Devle ađahar so čhivena jaram e učenikonenđe savo našti ine te akhara ni amen ni amare pradada? ");
INSERT INTO rmna_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ali amen verujinaja da injam spasime pali milost e Gospodesiri e Isusesiri isto ađahar sar soi hem on.” ");
INSERT INTO rmna_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Tegani sare trainde, i lelje te šunen e Varnava hem e Pavle kola vaćerde save sa znakija hem čudesija o Devel ćerđa prekal olende maškaro avera nacije. ");
INSERT INTO rmna_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Kad završinde, o Jakov phenđa: “Phraljalen, šunen man. ");
INSERT INTO rmna_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","O Simon Petar phenđa da o Devel najangle dikhlja maškaro avera nacije te birini pese narodo. ");
INSERT INTO rmna_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","A adaleja složinena pe hem o lafija e prorokonengere, sar soi pisime: ");
INSERT INTO rmna_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Palo adava ka irinav man hem palem ka vazdav o peravdo šatori e Davidesoro; tari ruševina ka vazdav le hem ka obnovinav le, ");
INSERT INTO rmna_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","te šaj hem avera manuša te roden e Gospode, hem sa o nacije kolen vičinđum te oven mle, vaćeri o Gospod kova adava ćerela. ");
INSERT INTO rmna_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","A adavai pendžarutno taro but angleder vreme.’ ");
INSERT INTO rmna_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Adalese me dikhava da na valjani te čhiva pharipe upro okola kola nane Jevreja kola obratinena pe e Devlese, ");
INSERT INTO rmna_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","nego te pisini pe lenđe te na han o hajba savoi žrtvujime e idolenđe, adalese soi nečisto, te ciden pe taro blud, te na han o mas e tasavde životinjengoro ano savo isi rat hem te na pijen o rat e životinjengoro. ");
INSERT INTO rmna_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Adalese so adala zakonja e Mojsijasere pana taro anglune vremenja propovedinena pe ani svako diz hem svako savato čitinena pe ano sinagoge.” ");
INSERT INTO rmna_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Tegani o apostolja hem o starešine sa e khanđirjaja odlučinde te birinen maškara pumende manušen kolen ka bičhalen e Pavleja hem e Varnavaja ki Antiohija. Ađahar birinde e Juda kola vičinde Varsava hem e Sila, kola inele vođe maškaro vernici. ");
INSERT INTO rmna_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Palo lende bičhalde akava lil: Amen, o apostolja hem o starešine, tumare phralja, pozdravinaja sa e phraljen taro avera nacije, ki Antiohija, ki Sirija hem ki Kilikija. ");
INSERT INTO rmna_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Šunđam da nesave manuša amendar ale tumende, iako amen na bičhalđam len, hem zbuninde tumen pumare lafencar hem uznemirinde tumen. ");
INSERT INTO rmna_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Adalese amen sare sar jekh odlučinđam te birina nesave manušen hem te bičhala len kora tumende zajedno amare volime phraljencar, e Varnavaja hem e Pavleja. ");
INSERT INTO rmna_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Adavai manuša kola pumaro dživdipe rizikujinde zbog amaro Gospod Isus Hrist. ");
INSERT INTO rmna_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Adalese bičhalaja e Juda hem e Sila, te vaćeren tumenđe isto sa akava. ");
INSERT INTO rmna_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Adalese so, zajedno e Svetone Duhoja, odlučinđam te na čhiva tumenđe aver pharipe, sem akalestar so valjani: ");
INSERT INTO rmna_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","te na han o hajba savoi žrtvujime e idolenđe, te na pijen o rat e životinjengoro hem te na han o mas e tasavde životinjengoro ano savo isi rat, hem te ciden pe taro blud. Šukar ka ćeren te ićerena tumen po dur sa akalestar. Oven pozdravime. ");
INSERT INTO rmna_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","I kad inele bičhalde ko drom, džele ki Antiohija kote čedinde e vernikonen hem dinde len o lil. ");
INSERT INTO rmna_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Kad on čitinde o lil, radujinde pe zako ohrabrenje. ");
INSERT INTO rmna_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","A o Juda hem o Sila, kola hem korkore inele proroci, bute lafencar ohrabrinde hem zorjarde e phraljen ani vera. ");
INSERT INTO rmna_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Palo nesavo vreme so inele adari, o vernici ano mir bičhalde len palal okolende kola bičhalde len. ");
INSERT INTO rmna_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ali o Sila odlučinđa te ačhol adari. ");
INSERT INTO rmna_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","A o Pavle hem o Varnava ačhile ki Antiohija. Zajedno bute averencar sikavena ine e narodo hem propovedinena o lafi e Gospodesoro. ");
INSERT INTO rmna_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Palo nesavo vreme o Pavle phenđa e Varnavase: “Hajde te irina men hem te dikha e phraljen ko sa o dizja ko save propovedinđam o lafi e Gospodesoro, te dikha sari.” ");
INSERT INTO rmna_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","A o Varnava manglja te legaren pumencar hem e Jovane vičime Marko, ");
INSERT INTO rmna_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ali o Pavle mislinđa da nane šukar pumencar te legaren okole kova ačhavđa len ine ki Pamfilija hem na nastavinđa olencar i buti. ");
INSERT INTO rmna_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","I edobor zorale na složinde pe da cidinde pe jekh averestar: o Varnava lelja e Marko hem otplovinđa ko Kipar, ");
INSERT INTO rmna_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","a o Pavle izabirinđa e Sila. I kad o phralja poverinde le ki milost e Gospodesiri, dželo. ");
INSERT INTO rmna_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","I nakhela ine maškari Sirija hem i Kilikija hem zorjari o khanđirja. ");
INSERT INTO rmna_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","O Pavle alo ki Derva i onda ki Listra, kaj živinđa o učeniko palo anav Timotej. Ov inele čhavo e Jevrejkakoro koja inele vernica, a lesoro dad na inele Jevrejco. ");
INSERT INTO rmna_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","O phralja ani Listra hem ano Ikonijum šukar vaćerde olestar. ");
INSERT INTO rmna_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","O Pavle manglja te legari le peja ko drom, i adalese obrezinđa le sar te prihvatinen le o Jevreja kola živinde ko adala thana, adalese so sare džande da lesoro dad na inele Jevrejco. ");
INSERT INTO rmna_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Nakhindoj maškaro dizja, vaćerena ine o odluke save ande o apostolja hem o starešine ano Jerusalim ko save valjande o manuša te ićeren pe. ");
INSERT INTO rmna_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","I ađahar o khanđirja ovena ine zorale ani vera hem barjola ine lengoro broj taro dive ko dive. ");
INSERT INTO rmna_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","A on nakhine maškari regija Frigija hem Galatija, adalese so o Sveto Duho na muklja lenđe te propovedinen e Devlesoro lafi ani Tikori Azija. ");
INSERT INTO rmna_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Kad resle ki granica e Mizijakiri, mangle te đerdinen ki Vitinija, ali o Duho e Isusesoro na muklja lenđe. ");
INSERT INTO rmna_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","I ađahar nakhine uzali Mizija hem ale ki diz Troada. ");
INSERT INTO rmna_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","I prekali rat e Pavle inele vizija: sar nesavo Makedonco terdino hem molinđa le: “Ava ki Makedonija hem pomožin amenđe!” ");
INSERT INTO rmna_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Palo adava so ine le vizija, amen dikhljam po sig te dža ki Makedonija, adalese so injamle uverime da o Devel vičinđa amen te mothova lenđe o Šukar lafi. ");
INSERT INTO rmna_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Tari Troada plovinđam pravo ko Samotrak, a tejsato dive ko Neapolj, ");
INSERT INTO rmna_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","a adathar ko Filipe, savo inele e rimesiri kolonija hem bari diz oto adava deo oti Makedonija. Ki adaja diz ačhiljam nekobor dive. ");
INSERT INTO rmna_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ko savato ikliljam taro e dizjakoro udar nakori len, kaj pretpostavinđam da isi than kaj čedena pe o manuša te molinen pe. Adari bešljam hem leljam te vaćera e đuvljencar kola čedinde pe adari. ");
INSERT INTO rmna_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","A šunđa amen hem jekh pobožno đuvli palo anav Lidija tari diz Tijatira koja biknela ine o skupa lole šeja. O Gospod phravđa lakoro vilo te šunel šukar okova so o Pavle vaćerđa. ");
INSERT INTO rmna_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","A kad oj hem lakere čherutne krstinde pe, oj molinđa amen vaćerindoj: “Te mislinena da verujinava ano Gospod, aven hem ačhoven maje ano čher.” I ađahar ubedinđa amen te ačhova koro late. ");
INSERT INTO rmna_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Jekhvar sar džaja ine ko than kaj čedena pe o manuša te molinen pe, reslja amen jekh ropkinja. Oj inele opsednutime bišukare duhoja kova ćerela la te džanel so ka ovel, i ađahar so dikhljari anela ine bari zarada ple gospodarenđe. ");
INSERT INTO rmna_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Oj džala ine palo Pavle hem pala amende, vičindoj: “Akalai manuša sluge e Najbare Devlesere! On mothovena tumenđe o drom e spasibnasoro!” ");
INSERT INTO rmna_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","I ađahar ćerela ine but dive, i kad e Pavlese alo đi o nak, irinđa pe hem phenđa e duhose: “ Naredinava će ko anav e Isuse Hristesoro te ikljove olatar!” I o duho odmah iklilo olatar. ");
INSERT INTO rmna_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","A kad lakere gospodarija dikhle da našalde i nada zaki pumari zarada, dolinde e Pavle hem e Sila hem vucinde len ko trg e dizjakoro anglo vladarija. ");
INSERT INTO rmna_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","I kad ande len anglo upravnici, phende: “Akala manuša, kolai Jevreja, anena nemir ani amari diz, ");
INSERT INTO rmna_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","hem propovedinena o adetija save amen, o Rimljanja, na tromaja te prihvatina ni te ićera.” ");
INSERT INTO rmna_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Tegani o narodo uštino protiv o Pavle hem o Sila, a o upravnici pharavde o šeja upro lende hem naredinde te šibinen len. ");
INSERT INTO rmna_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Kad zorale šibinde len, frdinde len ano phandlipe hem naredinde e stražarese šukar te arakhi len. ");
INSERT INTO rmna_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Kad o stražari dobinđa esavki naredba, ov frdinđa len ano maškarutno than e phandlipnasoro, a lengere pre phandlja ađahar so čhivđa len ano phalja. ");
INSERT INTO rmna_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","I đi sar ki ekvaš i rat, o Pavle hem o Sila molinde pe hem đilabde e Devlese, a o phandle manuša šunena len ine. ");
INSERT INTO rmna_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Otojekhvar ulo edobor zoralo zemljotres, da sa o temelja e phandlipnasere tresinde. Odmah phravdile sa o udara hem sarijendar phravdile o lancija. ");
INSERT INTO rmna_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Kad o stražari uštino taro sojba, i kad dikhlja da o udara e phandlipnasere phravde, lelja plo mači hem manglja te mudari pe, adalese so mislinđa da o phandle manuša našle. ");
INSERT INTO rmna_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ali, o Pavle oto sa o glaso vičinđa: “Ma ćer korkoro tuće bišukaripe! Sare akate injam!” ");
INSERT INTO rmna_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Tegani o stražari rodinđa svetlost, prastandilo hem tresindoj oti dar pelo ko kočija anglo Pavle hem anglo Sila. ");
INSERT INTO rmna_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Tegani ikalđa len taro phandlipe hem pučlja len: “Phenen maje, cenime manušalen, so valjani te ćerav te ovav spasime?” ");
INSERT INTO rmna_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","A on phende lese: “Verujin ano Gospod Isus, i ka ove spasime hem tu hem te čherutne.” ");
INSERT INTO rmna_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Tegani lese hem lesere čherutnenđe mothovde o Lafi e Gospodesoro. ");
INSERT INTO rmna_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ko adava isto sati adala raćakoro o stražari legarđa e Pavle hem e Sila hem thovđa lengere rane, a odmah palo adava krstinde pe hem ov hem lesere čherutne. ");
INSERT INTO rmna_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Tegani anđa len pese ano čher hem dinđa len te han, hem radujinđa pe ple čherutnencar so poverujinde ano Devel. ");
INSERT INTO rmna_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Kad dislilo, o upravnici bičhalde pumare službenikonen te phenen e stražarese te mukel e Pavle hem e Sila. ");
INSERT INTO rmna_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Tegani o stražari phenđa e Pavlese: “O upravnici phende maje te mukav tumen. Adalese akana ikljoven hem džan ano mir.” ");
INSERT INTO rmna_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","A o Pavle phenđa lenđe: “Marde amen anglo sa o manuša, bizo sudiba, iako injam e rimesere dizutne, hem frdinde amen ko phandlipe, a akana mangena garandoj te ikalen amen! Na! Nego, nek on korkore aven hem nek ikalen amen.” ");
INSERT INTO rmna_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","O službenici vaćerde adava e upravnikonenđe, i kad šunde dai o Pavle hem o Sila dizutne e Rimesere, darandile, ");
INSERT INTO rmna_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","i ale, izvininde pe hem ikalde len molindoj len te džan tari diz. ");
INSERT INTO rmna_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Kad iklile taro phandlipe, o Pavle hem o Sila džele e Lidijaće ano čher, dikhle pe e vernikonencar, ohrabrinde len, i džele adathar. ");
INSERT INTO rmna_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Kad nakhle o Pavle hem o Sila maškaro dizja Amfipolj hem Apolonija, resle ko Solun, kote inele e jevrejengiri sinagoga. ");
INSERT INTO rmna_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","O Pavle, palo plo adeti đerdinđa ki sinagoga, hem trin kurče ko savato raspravinđa e Jevrejencar oto Sveta lila. ");
INSERT INTO rmna_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Objasnini lenđe ine hem dokažini lenđe: “O Hrist valjanđa te patini hem te uštel taro mule. A adavai o Isus kolestar me vaćerava tumenđe, ovi o Hrist.” ");
INSERT INTO rmna_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Nesave olendar inele uverime hem pridružinde pe e Pavlese hem e Silase. Obratinde pe hem but pobožna Grci hem but ugledna džuvlja. ");
INSERT INTO rmna_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ali avera Jevreja inele ljubomorna i čedinde e bišukare manušen taro trg hem terinde len te vazden pobuna ani diz. I ale anglo e Jasonesoro čher hem rodinde lestar te ikali e Pavle hem e Sila te sudini pe lenđe. ");
INSERT INTO rmna_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","A kad na arakhle len, vucinde e Jasone hem pana nesave phraljen anglo e dizjakere šerutne, vičindoj: “Hem akate ale okola kola vazdinde pobuna ano sa o carstvo, ");
INSERT INTO rmna_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","a o Jason priminđa len pese ano čher! Sare on ćerena protiv e carosere naredbe, adalese so vaćerena da postojini aver caro – o Isus!” ");
INSERT INTO rmna_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Kad o narodo hem e dizjakere šerutne šunde adava, uznemirinde pe. ");
INSERT INTO rmna_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ali kad oto Jason hem oto avera lelje pare sar garancija, mukle len. ");
INSERT INTO rmna_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Samo so peli i rat, o phralja bičhalde e Pavle hem e Sila ki diz Verija. Kad resle adari, lelje te džan ani e jevrejengiri sinagoga. ");
INSERT INTO rmna_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Adari o Jevreja inele but po phravde zako Lafi nego okola ko Solun, i šukar priminde e Devlesoro lafi. Svako dive rodinde ano Sveta lila te dikhen čače li ađahar sar so vaćeri o Pavle. ");
INSERT INTO rmna_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","I ađahar but džene olendar poverujinde, hem but ugledna Grkinje hem Grci. ");
INSERT INTO rmna_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","A kad o Jevreja taro Solun šunde so o Pavle hem ki Verija mothoj e Devlesoro lafi, ale, hem adari uznemirinde hem pobuninde sa e narodo. ");
INSERT INTO rmna_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Tegani o phralja odmah bičhalde e Pavle nakoro more, a o Sila hem o Timotej ačhile ani Verija. ");
INSERT INTO rmna_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","A okola so džele e Pavleja legarde le ki diz Atina. I irinde pe ki Verija primindoj i naredba e Pavlestar zako Sila hem zako Timotej te džan so po sig oleste. ");
INSERT INTO rmna_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Sar o Pavle adžićeri ine e Sila hem e Timoteje ani Atina, inele uznemirime ano duho kad dikhlja dai i diz pherdi idolja. ");
INSERT INTO rmna_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","I e Jevrejencar hem e pobožnone Grkonencar raspravini ine ani sinagoga, a svako dive raspravini ine hem ko trg okolencar kola ovena ine adari. ");
INSERT INTO rmna_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ađahar e Pavleja lelje te raspravinen hem nesave filozofija – o epikurejci hem o stoici. Nesave phende: “So akava brbljini, so mangela te phenel?” A avera phende: “Sagod vaćeri avere devlendar” – adalese so o Pavle propovedini ine o Šukar lafi e Isusestar hem e uštibnastar taro mule. ");
INSERT INTO rmna_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Tegani dolinde le hem ande le ko Areopag, ko čediba e dizjakere šerutnengoro, i phende lese: “Šaj li te džana savoi adava nevo sikaviba savo tu sikaveja? ");
INSERT INTO rmna_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Šunaja so vaćereja nesave stvarija savei čudna amenđe, i mangaja te džana so šaj te ovel adava.” ");
INSERT INTO rmna_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","A sa o manuša tari Atina hem o abanđije kola živinde maškar olende trošinena ine sa pumaro vreme ko vaćeriba hem ko šuniba nešto nevo. ");
INSERT INTO rmna_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Tegani o Pavle terdino ko maškar oto Areopag, i phenđa: “Manušalen tari Atina, palo sa akava, dikhava da injen but religiozna. ");
INSERT INTO rmna_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Adalese so, sar nakhava ine i diz hem sar dikhava ine tumare svetinje, arakhljum hem jekh žrtveniko, ko savo pisini: ‘E Bipendžarutne Devlese.’ Me vaćerava tumenđe adale Devlestar kole tumen poštujinena, ali na pendžarena. ");
INSERT INTO rmna_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Adava Devel ćerđa o sveto hem sa soi ano leste. Ovi gospodari e nebosoro hem e phuvjakoro hem adalese na bešela ano hramija savei ćerde e manušikane vasteja, ");
INSERT INTO rmna_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","hem na valjani lese ništa e manušestar te ćerel olese. Adalese so, ovi adava kova sarijenđe dela dživdipe, o dah hem sa aver. ");
INSERT INTO rmna_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Jekhe manušestar ćerđa sa e narodo te pheren sa i phuv, angleder odredindoj o vremenja hem o thana kaj ka bešen. ");
INSERT INTO rmna_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","O Devel ćerđa adava sar te šaj o manuša roden le, sar te šaj nesar dolen le hem te arakhen le, iako ov nane dur nijekhestar amendar. ");
INSERT INTO rmna_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","‘Adalese so, ano leste živinaja, mrdinaja hem postojinaja’ – sar so phende hem nesave tumare pesnici: ‘Amen injam lesoro potomstvo.’ ");
INSERT INTO rmna_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","I adalese so injam e Devlesoro potomstvo, na valjani te mislina dai o Devel slično e kipese oto zlato, srebro ili bar – dai nešto so o manuš zamislinđa hem ćerđa ple vastencar. ");
INSERT INTO rmna_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Angleder kad o manuša na džande e Devlese, ov na dikhlja ko adava, ali akana naredini sa e manušenđe ko svako than te pokajinen pe. ");
INSERT INTO rmna_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Adalese so o Devel odredinđa o dive kad pravedno ka sudini e svetose prekalo manuš kole odredinđa hem kolestar sarijenđe dinđa dokazija ađahar so vazdinđa le taro mule.” ");
INSERT INTO rmna_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Kad šunde zako uštiba taro mule, nesave lelje te maren muj, a avera phende: “Adalestar ka šuna tut aver puti.” ");
INSERT INTO rmna_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","I o Pavle dželo olendar. ");
INSERT INTO rmna_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","A palem, nesave manuša olendar pridružinde pe lese hem poverujinde. Maškar olende inele o Dionisije – jekh e šerutnendar oto Areopag, i đuvli palo anav Damara hem avera. ");
INSERT INTO rmna_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Palo adava o Pavle dželo tari Atina ko Korint. ");
INSERT INTO rmna_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Adari arakhlja nesave Jevrejco palo anav Akila, kova inele taro Pont. Na nakhino but vreme sar pla romnjaja e Priskilaja alo tari Italija, adalese so e rimesoro caro o Klaudije naredinđa sa o Jevreja te džan taro Rim. O Pavle dželo koro lende, ");
INSERT INTO rmna_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","a adalese so ćerde isto buti – ćerde šatorija – ačhilo koro lende te ćerel buti olencar. ");
INSERT INTO rmna_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","A svako savato raspravini ine ani sinagoga, mangindoj te uverini e Jevrejen hem e Grkonen. ");
INSERT INTO rmna_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Kad o Sila hem o Timotej resle tari Makedonija, o Pavle posvetinđa pe samo zako vaćeriba e Devlesoro lafi, svedočindoj e Jevrejenđe dai o Isus o Hrist. ");
INSERT INTO rmna_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ali, adalese so on protivinde pe lese hem vređinde le, ov tresinđa i prašina ple šejendar sar znako zako zoralo odbiba hem phenđa lenđe: “Korkore injen kriva zaki tumari propast. Me injum čisto adalestar. Od akana džava koro manuša taro avera nacije.” ");
INSERT INTO rmna_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Hem dželo adathar, i đerdinđa ko čher jekhe manušesoro palo anav Titije Just kova na inele Jevrejco, a slavinđa e Devle, kasoro čher inele odmah uzali sinagoga. ");
INSERT INTO rmna_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","A o Krisp, o vođa e sinagogakoro, poverujinđa ano Gospod sa ple čherutnencar. A poverujinde hem krstinde pe hem but manuša taro Korint kola šunde le. ");
INSERT INTO rmna_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Jekh rat o Gospod phenđa e Pavlese ki vizija: “Ma dara, nego vaćer hem ma te traine. ");
INSERT INTO rmna_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Adalese so, me injum tuja hem niko našti te napadini tut hem te ćerel će bišukaripe, adalese so isi man but manuša ki akaja diz.” ");
INSERT INTO rmna_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Ađahar o Pavle adari ačhilo berš tekvaš, sikavindoj e manušen e Devlesere lafestar. ");
INSERT INTO rmna_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","A kad o Galion inele upravniko ki Ahaja, o Jevreja sar jekh lelje te džan protiv o Pavle, i ikalde le anglo sudo, ");
INSERT INTO rmna_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","vaćerindoj: “Akava manuš pherela e manušen te slavinen e Devle ađahar sar so nane muklo palo Zakoni.” ");
INSERT INTO rmna_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","A kad o Pavle manglja te phenel nešto, o Galion phenđa e Jevrejenđe: “O Jevrejalen, te ovel ine nesavo prekršaj ili bišukar buti, ka ovel man ine sose te šunav tumen. ");
INSERT INTO rmna_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ali, adalese soi akala rasprave zako lafi, zako anava hem zako tumaro zakoni, rešinen adava korkore. Me na mangava te ovav sudija ko adava.” ");
INSERT INTO rmna_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Hem ispudinđa len tari sudnica. ");
INSERT INTO rmna_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Tegani on sare dolinde e Sostene, e vođa e sinagogakere, i lelje te maren le anglo sudo. A o Galion ništa na phenđa ko adava. ");
INSERT INTO rmna_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","O Pavle ačhilo adari pana but dive, a palo adava pozdravinđa pe e phraljencar, i e Priskilaja hem e Akileja otplovinđa ki Sirija. Ki Kenhreja šišinđa pe, adalese so ćerđa zavet. ");
INSERT INTO rmna_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Kad resle ano Efes, ov ačhavđa len hem korkoro đerdinđa ki sinagoga hem lelja te raspravini e Jevrejencar. ");
INSERT INTO rmna_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","On zamolinde le te ačhol pana nesavo vreme, ali ov na manglja, ");
INSERT INTO rmna_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","nego pozdravinđa pe olencar vaćerindoj: “Ka irinav man tumende, te dinđa o Devel.” I otplovinđa taro Efes. ");
INSERT INTO rmna_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Kad reslja ani Cezareja, dželo upre ko Jerusalim hem pozdravinđa i khanđiri, i dželo ki Antiohija. ");
INSERT INTO rmna_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Nesavo vreme inele adari i dželo adathar. Onda dželo taro than ko than maškari regija Galatija hem Frigija hem zorjari ine sa e učenikonen. ");
INSERT INTO rmna_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","A ano Efes reslja nesavo Jevrejco palo anav Apolos, kovai bijando ki Aleksandrija. Ov džanđa šukar te vaćeri hem šukar džanđa o Sveta lila. ");
INSERT INTO rmna_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ov inele sikavdo e Gospodesere dromestar hem gorljivo vaćeri ine hem čačikane sikaj e Isusestar, iako džanđa samo zako e Jovanesoro krstiba. ");
INSERT INTO rmna_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ov lelja bizi dar te vaćeri ki sinagoga, i kad šunde le i Priskila hem o Akila, vičinde le kora pumende hem po šukar objasninde lese e Devlesoro drom. ");
INSERT INTO rmna_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","A adalese so o Apolos manglja te džal ki Ahaja, o phralja ohrabrinde le hem pisinde e učenikonenđe te priminen le. Kad reslja adari, but inele ko pomoć okolenđe kola poverujinde pali milost, ");
INSERT INTO rmna_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","adalese so zorale pobedini ine e Jevrejen ko javna rasprave, dokažindoj lenđe prekalo Sveta lila dai o Isus o Hrist. ");
INSERT INTO rmna_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Sar o Apolos inele ano Korint, o Pavle nakhino maškari upruni phuv hem reslja ano Efes. Adari arakhlja nesave učenikonen, ");
INSERT INTO rmna_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","i pučlja len: “Priminđen li e Svetone Duho kad poverujinđen?” A on phende lese: “Ni na šunđam da isi Sveto Duho.” ");
INSERT INTO rmna_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","A o Pavle pučlja len: “Save, onda, krstibnaja krstinđen tumen?” On phende lese: “E Jovanesere krstibnaja.” ");
INSERT INTO rmna_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","A o Pavle phenđa lenđe: “O Jovan krstinđa e krstibnaja oto pokajanje. Ov vaćerđa e izraelesere narodose te verujinen ano okova kova avela palo leste – ano Isus.” ");
INSERT INTO rmna_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Kad šunde adava, krstinde pe ano anav e Gospodesoro e Isusesoro, ");
INSERT INTO rmna_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","a kad o Pavle čhivđa ple vasta upro lende, o Sveto Duho huljinđa upro lende hem lelje te vaćeren ano avera jezici hem te prorokujinen. ");
INSERT INTO rmna_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","On zajedno inele đi sar dešu duj murša. ");
INSERT INTO rmna_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Tegani o Pavle trin masek džala ine ki sinagoga hem vaćeri bizi dar. Raspravini ine olencar hem ubedini len e Devlesere carstvostar. ");
INSERT INTO rmna_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ali, sar nesave olendar inele šerale hem neposlušna hem anglo sarijende vaćerena ine bišukar e Gospodesere dromestar, o Pavle dželo olendar. I lelja peja e učenikonen hem svako dive raspravini ine ani učionica nesave Tiranesiri. ");
INSERT INTO rmna_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Adava inele duj berš, i sa o dizutne e Tikora Azijakere, hem o Jevreja hem okola kola nane Jevreja, šunde o lafi e Gospodesoro. ");
INSERT INTO rmna_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","O Devel prekalo Pavle ćerđa bare čudesija. ");
INSERT INTO rmna_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ađahar da đi hem o maramice hem o pojasija save ov pipinđa legarena ine e nambormenđe, hem on ovena ine sasljarde pumare nambormipastar, a o bišukar duhija ikljona ine olendar. ");
INSERT INTO rmna_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","A nesave Jevreja kola džana ine taro than ko than hem ispudinena e bišukare duhen pokušinde upro opsednutime manuša te vičinen o anav e Gospodesoro e Isusesoro, vaćerindoj: “Ano anav e Isusesoro kole o Pavle propovedini, naredinava tumenđe te ikljoven!” ");
INSERT INTO rmna_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Adava ćerena ine efta džene kola inele e Skevasere čhave, kova inele e jevrejengoro šerutno svešteniko. ");
INSERT INTO rmna_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ali o bišukar duho phenđa lenđe: “E Isuse džanav, a hem e Pavlese šunđum, ali kola tumen injen?” ");
INSERT INTO rmna_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Hem o manuš ano koleste inele o bišukar duho ripinđa upro lende, i sarijen marđa hem edobor khuvđa len da taro adava čher našle nange hem ratvale. ");
INSERT INTO rmna_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Adava šunde sare, hem o Jevreja hem okola kola nane Jevreja, kola živinde ano Efes hem sarijen uklinđa i dar, i o anav e Gospodesoro e Isusesoro više barjarđa pe. ");
INSERT INTO rmna_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","But okolendar kola poverujinde avena ine hem phravdeste priznajinena pumare bišukar delja. ");
INSERT INTO rmna_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","But okolendar kola ćerena ine mađije čedinde pumare lila hem anglo sarijende tharde len. Kad računinde kobor vredinena o lila, iklilo da vredinde pinda hiljade srebrna kovanice. ");
INSERT INTO rmna_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ađahar e Gospodesoro Lafi zorale širinđa pe hem ulo po zoralo. ");
INSERT INTO rmna_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Palo sa adava, o Pavle ano Duho odlučinđa te nakhel maškari Makedonija hem i Ahaja, hem te džal ko Jerusalim, i phenđa: “Palo adava so ka ovav adari, moram te dikhav hem o Rim.” ");
INSERT INTO rmna_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Tegani bičhalđa ki Makedonija ple duje pomoćnikonen, e Timoteje hem e Eraste, a ov korkoro ačhilo pana hari ki Tikori Azija. ");
INSERT INTO rmna_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ko adava vreme uli bari pobuna protiv o Drom e Gospodesoro. ");
INSERT INTO rmna_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Adalese so nesavo kovači palo anav Dimitrije ćerela ine oto srebro tikore hramija e Artemidakere hem adaleja anela ine bari zarada e zanatlijenđe. ");
INSERT INTO rmna_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ov čedinđa olen hem okolen kola ćerde slično buti, i phenđa: “Manušalen, tumen džanen da šukar zaradinaja akala bućaja. ");
INSERT INTO rmna_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ali, dikhena hem šunena so akava Pavle ubedinđa hem prelelja bute narodo, na samo ano Efes nego hem skoro ani sa i Tikori Azija, vaćerindoj da nane develja okola kolai ćerde manušikane vastencar. ");
INSERT INTO rmna_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Isi opasnost na samo amaro zanati te šunđol ko bišukar glaso nego hem o hram e bara develinjakoro e Artemidakoro te našali plo značaj hem te našali plo baripe i Artemida kola slavini sa i Tikori Azija hem sa o sveto.” ");
INSERT INTO rmna_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Kad on šunde adava, uklinđa len bari holi, i vičinde: “Bari i Artemida taro Efes!” ");
INSERT INTO rmna_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Tegani uli pobuna ani sa i diz, i sare zajedno prastandile ano pozorište hem vucinde pumencar e Makedonconen e Gaje hem e Aristarhe, kola putujinena ine e Pavleja. ");
INSERT INTO rmna_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","O Pavle manglja te ikljol anglo narodo, ali o učenici na dinde le. ");
INSERT INTO rmna_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Đi hem nesave lesere amala, e Tikora azijakere šerutnendar, bičhalde lese poruka, molindoj le te na džal ko pozorište. ");
INSERT INTO rmna_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","A ano pozorište nesave vičinde jekh, a avera aver, adalese so sare inele zbunime – but olendar ni džande sose čedinde pe. ");
INSERT INTO rmna_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","O Jevreja gurinde e Aleksandre te ikljol anglal, hem lelje te sikaven le so te vaćeri. Ov dinđa znako vasteja te trainen, mangindoj te branini pe anglo narodo. ");
INSERT INTO rmna_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ali, kad dikhle dai ov Jevrejco, sare ko jekh glaso, đi sar duj saća vičinde: “Bari i Artemida taro Efes!” ");
INSERT INTO rmna_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Tegani e dizjakoro pisari smirinđa e narodo hem phenđa lenđe: “Manušalen taro Efes! Isi li manuš kova na džanel dai i diz Efes čuvari e bara Artemidakere hramesoro hem lakere kipesoro savo pelo taro nebo? ");
INSERT INTO rmna_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Adalese so sare složinena pe adaleja, valjani te smirinen tumen hem te na ćeren ništa ki sig. ");
INSERT INTO rmna_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Adalese so, anđen akale manušen akari iako na čorde o hram ni vređinde amara develinja. ");
INSERT INTO rmna_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Adalese, te mangle o Dimitrije hem o zanatlije kolai oleja te tužinen nekas, o suđai phravde, a adathei hem o upravnici – i nek tužinen pe. ");
INSERT INTO rmna_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","A te mangena nešto više, adava mora te rešini pe angli zakonito skupština. ");
INSERT INTO rmna_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Adalese so, pretini amen i opasnost te ova optužime zaki pobuna hem zako sa avdive so ulo, a nane amen nijekh razlog saveja šaj te opravdina akala neredija.” ");
INSERT INTO rmna_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Hem, kad phenđa adava, bičhalđa e čedime manušen čhere. ");
INSERT INTO rmna_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Kad i pobuna nakhli, o Pavle vičinđa kora peste e učenikonen hem ohrabrinđa len. I pozdravinđa pe olencar hem dželo ki Makedonija. ");
INSERT INTO rmna_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Nakhindoj maškaro adava krajo bute lafencar hrabrinđa e manušen. Ađahar reslja ki Grčko ");
INSERT INTO rmna_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","hem adari ačhilo trin masek. Ali kad valjanđa te otplovini ki Sirija, dodžanđa so o Jevreja čhivde lese zamka i adalese odlučinđa te irini pe prekali Makedonija. ");
INSERT INTO rmna_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Oleja džele: o Sopater, o čhavo e Piresoro tari Verija, o Aristarh hem o Sekund taro Solun, o Gaj tari Derva hem o Timotej, o Tihik hem o Trofim tari Tikori Azija. ");
INSERT INTO rmna_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","On džele angleder amendar hem adžićerde amen ani Troada. ");
INSERT INTO rmna_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Palo prazniko e Bikvascone marengoro dželjam e čamcoja taro Filipi hem pandž dive palo adava resljam len ki Troada, kaj ačhiljam efta dive. ");
INSERT INTO rmna_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ko prvo dive oto kurko, čedinđam amen ki Gospodnjo večera, a o Pavle propovedini lenđe ine. I adalese so manglja aver dive te putujini, propovedinđa sa đi ki ekvaš i rat. ");
INSERT INTO rmna_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ki upruni soba kote čedinđam amen, inele but svetiljke. ");
INSERT INTO rmna_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","A nesavo terno manuš palo anav Evtih bešela ine ko prozori. I adalese so o Pavle pherdo vaćerđa, ole ukljela le ine zoralo sojba. Kad prelelja le o sojba, ov pelo taro trito sprati, a kad lelje te vazden le, već inele mulo. ");
INSERT INTO rmna_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","O Pavle huljilo, pašlilo upro leste, zagrlinđa le hem phenđa: “Ma daran, dživdoi akana.” ");
INSERT INTO rmna_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Palo adava irinđa pe upre, delinđa i Gospodnjo večera hem halja maro olencar. Hem pana pherdo vaćerđa lenđe – sa đi sabale. I palo adava, dželo ko drom. ");
INSERT INTO rmna_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","A e terne čhave legarde čhere dživde, hem sare inele ohrabrime zbog adava. ");
INSERT INTO rmna_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","A amen angleder đerdinđam ano brodo hem otplovinđam ko Asos. Adathar valjanđam te legara e Pavle amencar. Ov ađahar manglja, adalese so đi ko Asos manglja te džal korkoro phirindoj. ");
INSERT INTO rmna_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Kad arakhljam amen oleja ano Asos, leljam le amencar ano brodo hem dželjam ki Mitilina. ");
INSERT INTO rmna_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Tejsato dive otplovinđam adathar hem resljam paše uzalo Hios. Aver dive resljam ko Samos, a aver dive resljam ko Milit. ");
INSERT INTO rmna_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","A o Pavle odlučinđa te na terđol ko Efes, sar te na ačhol but ani Tikori Azija. Siđarđa, te šaj ine, resel ko Jerusalim đi ko prazniko Pentekost. ");
INSERT INTO rmna_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","A taro Milit bičhalđa ple manušen ko Efes palo e khanđirjakere starešine. ");
INSERT INTO rmna_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Kad ale koro leste, o Pavle phenđa lenđe: “Tumen džanen sar me živinđum sa o vreme đikote injumle tumencar, taro prvo dive kad resljum ki Tikori Azija. ");
INSERT INTO rmna_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Služinđum e Gospodese ani sa i poniznost hem ano asva hem ano iskušenja save resle man zbog e jevrejengere zamke. ");
INSERT INTO rmna_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Sa vaćerđum tumenđe hem sikavđum tumen soi korisno tumenđe, javno hem ko čhera. ");
INSERT INTO rmna_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Upozorinava ine hem e Jevrejen hem averen te irinen pe ko Devel hem te verujinen ano amaro Gospod Isus. ");
INSERT INTO rmna_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Akana, ače, adalese so o Duho terini man, džava ko Jerusalim, a so ka arakhi man adari, na džanav. ");
INSERT INTO rmna_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Samo džanav da ki svako diz o Sveto Duho upozorini man ine hem vaćeri da adžićerena man okovija hem nevolje. ");
INSERT INTO rmna_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ali maje ni hari na ačhilo zako mlo dživdipe, samo te završinav mli trka hem i služba savi priminđum e Gospodestar e Isusestar – te svedočinav zako Šukar lafi oti e Devlesiri milost. ");
INSERT INTO rmna_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Akana, ače, džanav da niko tumendar maškaro kolende injumle, đikote putujinđum hem propovedinđum o carstvo e Devlesoro, više naka dikhel man. ");
INSERT INTO rmna_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Adalese akava dive jasno vaćerava tumenđe da na injum krivo nikasere meribnase, ");
INSERT INTO rmna_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","adalese so vaćerđum tumenđe sa i volja e Devlesiri. ");
INSERT INTO rmna_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Arakhen tumen hem sa e Devlesoro stado upro saveste o Sveto Duho čhivđa tumen sar nadglednikonen. Oven pastirija e Devlesere khanđirjakere, sava ov platinđa ple rateja. ");
INSERT INTO rmna_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Džanav da palo mlo džajba ka đerdinen maškara tumende o opasna ruva, kola naka štedinen o stado. ");
INSERT INTO rmna_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Čak hem maškara tumende korkorende ka aračhoven manuša kola ka banđaren o čačipe sar te šaj pala pumende te ciden učenikonen. ");
INSERT INTO rmna_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Adalese džangale pazinen! Setinen tumen so trin berš, rat hem dive, na ačhavđum, sa asvencar, te opomeninav svakonese tumendar. ");
INSERT INTO rmna_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","A akana poverinava tumen e Devlese hem e Lafese oti lesiri milost savo šaj te barjari tumen hem te del tumen nasledstvo maškaro sarijende kolai posvetime. ");
INSERT INTO rmna_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Nikad na mangljum averesoro srebro, zlato ili šeja. ");
INSERT INTO rmna_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Korkore džanen da mle vastencar ćerđum buti zako okova so valjanđa maje, hem zako okova so valjanđa okolenđe kola inele mancar. ");
INSERT INTO rmna_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ko sa dinđum tumen primer: da ađahar valjani te trudinen tumen hem te pomožinen e bizoralenđe, ađahar so ka setinen tumen ko lafija save korkoro o Gospod Isus phenđa: ‘Po blagoslovimei te del pe, nego te lel pe.’” ");
INSERT INTO rmna_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","I, kad adava phenđa, pelo ko kočija hem sarijencar olencar molinđa pe. ");
INSERT INTO rmna_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Tegani sare lelje zorale te roven, te grlinen hem te čumudinen e Pavle. ");
INSERT INTO rmna_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Najviše dukhandilo len okova so phenđa lenđe da više nikad naka dikhen le. Palo adava ispratinde le ko brodo. ");
INSERT INTO rmna_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Kad oprostinđam amen olencar, otplovinđam. I plovindoj pravo resljam ko ostrvo Kos, a tejsato dive resljam ko ostrvo Rodos, i adathar ki diz Patara. ");
INSERT INTO rmna_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Adari arakhljam brodo savo džala đi i Fenikija, i đerdinđam ano leste hem dželjam. ");
INSERT INTO rmna_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Kad dikhljam o Kipar, nakhavđam le tari levo strana e brodosiri hem dželjam nakori Sirija. Terdinjam ki diz Tir, adalese so adari valjanđa te huljaj pe o pharipe taro brodo. ");
INSERT INTO rmna_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Adari arakhljam e učenikonen, i olencar ačhiljam efta dive. A olenđe o Duho mothovđa so adžićeri e Pavle, i vaćerde lese te na džal ko Jerusalim. ");
INSERT INTO rmna_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Kad nakhle adala efta dive, dželjam adathar hem putujinđam, a on sare, pe romnjencar hem pe čhavencar, ispratinde amen đi avri oti diz. Ki obala peljam ko kočija hem molinđam amen. ");
INSERT INTO rmna_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Kad oprostinđam amen jekh averendar, amen đerdinđam ko brodo, a on irinde pe čhere. ");
INSERT INTO rmna_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Ađahar otplovinđam taro Tir ki diz Ptolemaida. Adari pozdravinđam e phraljen hem ačhiljam jekh dive olencar. ");
INSERT INTO rmna_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Tejsato dive putujindoj resljam ki diz Cezareja. Adari aljam ko čher e Filipesoro – o evanđelista, kova inele jekh oto efta izabirime ano Jerusalim te oven pomoćnici, hem ačhiljam koro leste. ");
INSERT INTO rmna_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","A ole inele štar bidinde čhaja, kola prorokujinde. ");
INSERT INTO rmna_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Ačhiljam adari duže vreme, a onda tari Judeja reslo nesavo proroko palo anav Agav. ");
INSERT INTO rmna_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ov alo uzalo amende, lelja e Pavlesoro kaiši, i phandlja ple pre hem ple vasta hem phenđa: “Akava vaćeri o Sveto Duho: ‘Ađahar o Jevreja ko Jerusalim ka phanden e manuše kasoroi akava kaiši hem ka preden le ko vasta e manušenđe kola nane Jevreja.’ ” ");
INSERT INTO rmna_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Kad adava šunđam, leljam hem amen hem o manuša kola živinde adari te molina e Pavle te na džal ko Jerusalim. ");
INSERT INTO rmna_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Tegani o Pavle phenđa: “So ćerena adava? Rovena hem phagena mlo vilo. Me injum spremno na samo te ovav phandlo, nego hem te merav ano Jerusalim zako anav e Gospodesoro e Isusesoro.” ");
INSERT INTO rmna_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","I adalese so našti ine te ubedina le, mukljam le vaćerindoj: “Nek ovel e Gospodesiri volja.” ");
INSERT INTO rmna_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Palo adala dive spreminđam amen hem dželjam ko Jerusalim. ");
INSERT INTO rmna_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","A amencar džele hem nesave učenici tari Cezareja, i legarde amen koro Mnason, kova inele taro Kipar, jekh oto anglune učenici, te ova lesere gostija. ");
INSERT INTO rmna_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Kad resljam ano Jerusalim, o phralja šukar priminde amen. ");
INSERT INTO rmna_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Tejsato dive o Pavle dželo amencar koro Jakov, kaj čedinde pe hem sa o starešine. ");
INSERT INTO rmna_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","O Pavle pozdravinđa len hem jekh po jekh stvaro vaćerđa lenđe so o Devel ćerđa prekali lesiri služba maškaro manuša taro avera nacije. ");
INSERT INTO rmna_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Kad on šunde adava, lelje te slavinen e Devle, i phende e Pavlese: “Dikh phrala, kobor hiljade Jevreja isi kola poverujinde hem sare on zorale ićerena o Zakoni. ");
INSERT INTO rmna_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","A on šunde zako tuće so sa e Jevrejen kolai maškaro manuša taro avera nacije sikaveja te ačhaven e Mojsijasoro Zakoni, vaćerindoj lenđe te na obrezinen pumare čhaven hem te na živinen palo adetija. ");
INSERT INTO rmna_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","So te ćera akana? Sigurno ka šunen so aljan. ");
INSERT INTO rmna_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Adalese ćer ađahar sar vaćeraja će: Isi amen štar manuša kola zavetujinde pe e Devlese. ");
INSERT INTO rmna_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Le olen, ćer o adeti e čistibnasoro zajedno olencar hem platin zako olenđe, te šaj muraven pumare šere. Tegani sare ka džanen da nane čače okova so šunde tutar, nego da hem tu ićereja o Zakoni hem živineja palo leste. ");
INSERT INTO rmna_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","A zako manuša taro avera nacije kola poverujinde, amen bičhalđam lenđe lil kote pisini adalestar so odlučinđam: te na han o hajba savoi žrtvujime e idolenđe, te na han o mas e tasavde životinjengoro hem ano savo isi rat hem te ciden pe taro blud.” ");
INSERT INTO rmna_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Tejsato dive o Pavle lelja peja okole manušen, i zajedno olencar ćerđa o adeti e čistibnasoro. Tegani đerdinđa ko Hram hem mothovđa da o dive lengere čistibnastar ka nakhen kad svakonese olendar ka del pe žrtva. ");
INSERT INTO rmna_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","A sar adala efta dive završinena pe ine, dikhle le ko Hram nesave Jevreja tari Tikori Azija, i pherde e narodo protiv oleste hem dolinde le, ");
INSERT INTO rmna_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","vičindoj: “Izraelconalen, pomožinen! Akavai adava kova ko sa o thana sikaj sa e manušen protiv amaro narodo, protiv amaro zakoni hem protiv akava than! Đi hem okolen kola nane Jevreja anđa ano Hram hem meljarđa akava sveto than!” ");
INSERT INTO rmna_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(Adalese so, angleder adaleste, dikhle e Trofime taro Efes e Pavleja ani diz, i mislinde da o Pavle anđa le ano Hram.) ");
INSERT INTO rmna_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Sa i diz uštini hem o manuša prastandile taro sa o strane, dolinde e Pavle, i holjame ikalde le taro Hram. I odmah phandle o udar e Hramesoro. ");
INSERT INTO rmna_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Sar on dikhena ine te mudaren le, alo o glaso đi ko šerutno naredniko e rimesere četakoro dai sa o Jerusalim uzbunime. ");
INSERT INTO rmna_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ov odmah lelja e vojnikonen hem e kapetanen, i prastandilo đi olende. I kad o Jevreja dikhle e naredniko hem e vojnikonen, na khuvde više e Pavle. ");
INSERT INTO rmna_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","O naredniko alo uzalo Pavle, dolinđa le hem naredinđa e vojnikonenđe te phanden le duje lanconencar, i pučlja: “Kovai akava manuš hem so ćerđa?” ");
INSERT INTO rmna_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","A taro narodo nesave vičinde jekh, a avera aver. I o naredniko na halilo ništa oti galama, hem adalese naredinđa te legaren e Pavle ki kasarna. ");
INSERT INTO rmna_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Kad o Pavle reslja đi o stepenice, o narodo edobor inele nasilno, da o vojnici morandile te akharen le. ");
INSERT INTO rmna_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","But narodo džala ine palo lende, vičindoj: “Mudar le!” ");
INSERT INTO rmna_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Kad valjande te legaren e Pavle ani kasarna, ov pučlja e naredniko: “Tromam li nešto te phenav će?” A o naredniko pučlja le: “Tu li džaneja grčki? ");
INSERT INTO rmna_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Onda tu na injan okova Egipćanin kova angleder nekobor dive vazdinđa buna hem ki pustinja peja legarđa štar hiljade pobunjenikonen?” ");
INSERT INTO rmna_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","A o Pavle phenđa lese: “Me injum Jevrejco taro Tars oti Kilikija, dizutno e pendžarutna dizjakoro. Molinava tut, muk maje te vaćerav nešto e narodose.” ");
INSERT INTO rmna_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Kad o naredniko muklja lese, o Pavle terdino ko stepenice hem e narodose dinđa znako vasteja da mangela te vaćeri, i sare trainde. Tegani ov lelja te vaćeri ko jevrejski: ");
INSERT INTO rmna_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Phraljalen hem dadalen, šunen akana so isi man te phenav tumenđe ki mli odbrana.” ");
INSERT INTO rmna_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Kad šunde sar vaćeri lenđe ki čhib e jevrejengiri, uli po bari tišina. I o Pavle phenđa lenđe: ");
INSERT INTO rmna_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Me injum Jevrejco, bijando ano Tars oti Kilikija, ali bariljum akate ano Jerusalim. Injumle e Gamalilesoro učeniko hem ov šukar sikavđa man o Zakoni amare pradadengoro. Zorale služinđum e Devlese sar hem sare tumen avdive. ");
INSERT INTO rmna_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Akale Dromesere sledbenikonen đi ko meriba progoninđum. E muršen hem e đuvljen ko lancija phandava ine hem čhivava len ano phandlipe. ");
INSERT INTO rmna_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Adava šaj te potvrdini o prvosvešteniko hem sa o starešine. Olendar resle maje lila save dinde man vlast te džav ko Damask palo phralja, i dželjum te dolav okolen kola inele adari hem phandlen te anav len ko Jerusalim te oven kaznime.” ");
INSERT INTO rmna_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Ali, sar džava ine dromeja hem avava paše uzalo Damask, ko ekvaš o dive, otojekhvar zoralo svetlost taro nebo sijajinđa uzala mande. ");
INSERT INTO rmna_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Peljum ki phuv hem šunđum o glaso savo vaćeri maje: ‘Savle, Savle, sose progonineja man?’ ");
INSERT INTO rmna_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Me pučljum: ‘Ko injan tu, Gospode?’ A ov phenđa maje: ‘Me injum o Isus taro Nazaret kole tu progonineja.’ ");
INSERT INTO rmna_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","O manuša kola inele mancar dikhle o svetlost, ali na halile o glaso okolesoro kova vaćerđa maje. ");
INSERT INTO rmna_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Tegani pučljum: ‘So te ćerav, Gospode?’ A o Gospod phenđa maje: ‘Ušti hem dža ko Damask. Adari ka vaćeri pe će sa soi tuće odredime te ćere.’ ");
INSERT INTO rmna_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Oto zoralo svetlost koroliljum, i okola so inele mancar legarde man oto vas, i ađahar đerdinđum ko Damask. ");
INSERT INTO rmna_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","A nesavo Ananija, manuš kovai pobožno palo Zakoni hem poštujime sa adale thanesere Jevrejendar, ");
INSERT INTO rmna_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","alo kora mande, terdino uzala mande hem phenđa maje: ‘Phrala Savle, dikh akana!’ I otojekhvar irinđa pe mlo dikhiba hem dikhljum ole. ");
INSERT INTO rmna_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ov phenđa maje: ‘O Devel amare pradadengoro birinđa tut te pendžare lesiri volja, te dikhe e Pravedniko hem te šune o glaso taro lesoro muj. ");
INSERT INTO rmna_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Adalese so, tu ka ove olese anglo sa o manuša svedoko zako okova so dikhljan hem so šunđan. ");
INSERT INTO rmna_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","A akana, so adžićereja? Ušti hem krstin tut, hem thov tut taro te grehija, vičindoj e Gospodesoro anav.’ ");
INSERT INTO rmna_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Kad irinđum man ko Jerusalim hem molinđum man ano Hram, ine man vizija ");
INSERT INTO rmna_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","hem dikhljum e Gospode sar vaćeri maje: ‘Siđar, hem odmah dža taro Jerusalim, adalese so naka prihvatinen to svedočanstvo mandar.’ ");
INSERT INTO rmna_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","A me phenđum lese: ‘Gospode, on džanen da džava ine tari sinagoga ki sinagoga te frdav ano phandlipe hem te marav okolen kola verujinena ana tute. ");
INSERT INTO rmna_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Hem kad čhordilo o rat te svedokosoro e Stefanesoro, hem me adari injumle, odobrinđum hem pazinđum o ogrtačija okolengere kola mudarena le ine.’ ");
INSERT INTO rmna_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","A ov phenđa maje: ‘Dža! Ka bičhalav tut dur – ko avera nacije.’ ” ");
INSERT INTO rmna_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","O manuša šunde le sa đi akava lafi, a onda vičinde: “Mudar le! Esavko manuš na zaslužini te živini!” ");
INSERT INTO rmna_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Sar on vičinena ine, frdinde pumendar pumare ogrtačija hem vazdinde prašina ano vazduho, ");
INSERT INTO rmna_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","o naredniko naredinđa te legaren e Pavle ki kasarna, te šibinen le hem te ispitujinen le, sar te dodžanel sose ađahar vičinde upro leste. ");
INSERT INTO rmna_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ali, kad phandle le kaišencar sar te šibinen le, o Pavle pučlja e kapetane kova terdino adari: “Troman li te šibinen e rimesere dizutne kolese pana nane sudime?” ");
INSERT INTO rmna_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Kad šunđa o kapetani adava, dželo uzalo naredniko hem phenđa lese: “So adava mangeja te ćere? Akavai manuš e rimesoro dizutno.” ");
INSERT INTO rmna_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Tegani o naredniko dželo uzalo Pavle hem pučlja le: “Phen maje, čače li tu injan e rimesoro dizutno?” A o Pavle phenđa: “Oja.” ");
INSERT INTO rmna_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","O naredniko phenđa lese: “Me but pare dinđum sar te ovav e rimesoro dizutno.” A o Pavle phenđa lese: “Me bijandiljum sar dizutno e rimesoro.” ");
INSERT INTO rmna_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Hem odmah lestar cidinde pe okola kola valjande te šibinen le. A o naredniko darandilo kad dodžanđa soi o Pavle, kole ov phandlja, e rimesoro dizutno. ");
INSERT INTO rmna_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Tejsato dive o naredniko oslobodinđa e Pavle, a adalese so manglja šukar te dodžanel zako so o Jevreja optužinena le, naredinđa e šerutne sveštenikonenđe hem zako sa o sabor te čeden pe, i anđa e Pavle hem čhivđa le anglo lende. ");
INSERT INTO rmna_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","O Pavle dikhlja ano manuša oto sabor hem phenđa lenđe: “Phraljalen, me sa đi akava dive anglo Devel živinđum ani čisto savest.” ");
INSERT INTO rmna_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ko adava o prvosvešteniko o Ananija naredinđa okolenđe kola terdine uzalo leste te khuven e Pavle ko muj. ");
INSERT INTO rmna_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","A o Pavle phenđa lese: “Tut ka khuvel o Devel, dujemujengereja – duvarona makhlo ano parno! Tu bešljan akate te sudine maje palo Zakoni, a isto adava Zakoni phageja adaleja so naredineja te khuven man!” ");
INSERT INTO rmna_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","A okola so terdine adari, phende: “Sar tromaš te vređine e Devlesere prvosvešteniko!” ");
INSERT INTO rmna_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","A o Pavle phenđa lenđe: “Na džanđum, phraljalen, dai ov prvosvešteniko. Adalese soi pisime ano Sveto lil: ‘Ma vaćer bišukar te narodosere šerutnestar.’” ");
INSERT INTO rmna_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Tegani o Pavle, adalese so halilo dai nesave olendar sadukeja, a avera fariseja, vičinđa ko sabor: “Phraljalen, me injum farisej, čhavo e farisejesoro! Sudini pe maje adalese so isi man nada ko uštiba taro mule!” ");
INSERT INTO rmna_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","So phenđa adava, uli rasprava maškaro fariseja hem o sadukeja, i ađahar o čedime podelinde pe. ");
INSERT INTO rmna_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Adalese so, o sadukeja vaćerena ine da nane uštiba taro mule, ni anđelja, ni duhija, a o fariseja vaćerena ine da sa adava isi. ");
INSERT INTO rmna_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","I ađahar uli bari galama, a nesave učitelja e Zakonestar tari e farisejengiri stranka uštine, i lelje zorale te protivinen pe, vaćerindoj: “Na arakhaja da akava manuš ćerđa nesavo bišukaripe. A so te o duho ili o anđeo vaćerđa lese?” ");
INSERT INTO rmna_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Ađahar uli edobor bari rasprava, da o naredniko darandilo te na pharaven e Pavle ko ekvaš, i naredinđa e vojnikonenđe te huljen maškaro manuša, te ikalen e Pavle hem te legaren le ki kasarna. ");
INSERT INTO rmna_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","A ki aver rat o Gospod terdino anglo Pavle hem phenđa: “Ma dara! Adalese so, sar so mandar svedočinđan ano Jerusalim, ađahar valjani te svedočine hem ano Rim.” ");
INSERT INTO rmna_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Kad dislilo, o Jevreja planirinde zamka hem hale sovli da naka han hem naka pijen đikote na mudarena e Pavle. ");
INSERT INTO rmna_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Inele prekalo saranda džene kola planirinde adaja zamka. ");
INSERT INTO rmna_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","On džele koro šerutne sveštenici hem koro starešine hem phende lenđe: “Bari sovli haljam da ništa naka čhiva ano muj đikote na mudaraja e Pavle. ");
INSERT INTO rmna_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Adalese akana tumen hem o sabor roden e narednikostar te anel le tumende, sar te šaj bađim po šukar te ispitujinen lesoro slučaj, a amen injam spremna te mudara le angleder so ka resel akari.” ");
INSERT INTO rmna_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ali e Pavlesere phenjakoro čhavo šunđa zaki adaja zamka, i dželo, đerdinđa ki kasarna hem phenđa adava e Pavlese. ");
INSERT INTO rmna_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","O Pavle vičinđa kora peste jekhe kapetane hem phenđa lese: “Legar akale terne koro naredniko, adalese so isi le nešto te phenel lese.” ");
INSERT INTO rmna_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","O kapetani lelja le peja hem legarđa le koro naredniko hem phenđa: “O Pavle, o phandlo, vičinđa man kora peste hem zamolinđa man te anav će akale terne, adalese so isi le nešto te phenel će.” ");
INSERT INTO rmna_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","O naredniko dolinđa e terne oto vas, cidinđa le ki strana hem pučlja le: “So isi tut te phene maje?” ");
INSERT INTO rmna_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","A ov phenđa lese: “O Jevreja dogovorinde pe te zamolinen tut tejsa te ane e Pavle ko sabor, sar te šaj bađim po šukar te ispitujinen lesoro slučaj. ");
INSERT INTO rmna_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ali tu ma ćer adava! Adalese so ka adžićeren le ki zamka više oto saranda manuša, kola hale sovli da naka han hem naka pijen sa đikote na mudarena le. Oni već spremna hem samo adžićerena tu te pristanine.” ");
INSERT INTO rmna_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Tegani o naredniko muklja e terne te džalfse hem naredinđa lese: “Nikase ma te vaćere so phenđan maje adava.” ");
INSERT INTO rmna_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Tegani o naredniko vičinđa ple duje kapetanen hem phenđa: “Spreminen dušel vojnikonen, eftavardešen ko grasta hem dušelen kopljencar te džan ko enja o sati erat ki Cezareja. ");
INSERT INTO rmna_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Spreminen e grasten saven ka jašini o Pavle hem legaren le dživde hem saste koro upravniko o Feliks.” ");
INSERT INTO rmna_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ov palo adava pisinđa akava lil: ");
INSERT INTO rmna_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Me, o Klaudije Lisija, pozdravinava e cenime upravniko e Felikse. ");
INSERT INTO rmna_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Akale manuše dolinde o Jevreja hem mangle te mudaren le, ali me aljum mle vojnikonencar hem spasinđum le adalese so dodžanđum dai ov e rimesoro dizutno. ");
INSERT INTO rmna_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Mangljum te džanav zako so optužinena le, i legarđum le ko lengoro sabor. ");
INSERT INTO rmna_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","I dikhljum da tužinena le zako nesave buća taro lengoro zakoni hem da nane krivo zako ništa so zaslužini meriba ili phandlipe. ");
INSERT INTO rmna_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","A kad šunđum da planirinde zamka te mudaren le, odmah bičhalđum le kora tute, a okolenđe kola optužinena le phenđum te phenen tuće zako so optužinena le.” ");
INSERT INTO rmna_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","I o vojnici, pali naredba, lelje e Pavle hem prekali rat legarde le ki diz Antipatrida. ");
INSERT INTO rmna_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Tejsato dive mukle e vojnikonen ko grasta te džan oleja po dur, a on irinde pe ki kasarna. ");
INSERT INTO rmna_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Kad resle ki Cezareja, dinde e upravnikose o lil hem ande e Pavle anglo leste. ");
INSERT INTO rmna_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","O upravniko čitinđa o lil, i pučlja e Pavle tari savi ov regija. Kad šunđa dai tari Kilikija, ");
INSERT INTO rmna_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","phenđa: “Ka šunav to slučaj kad ka resen okola kola optužinena tut.” I naredinđa te pazinen le ani palata e Irodesiri. ");
INSERT INTO rmna_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Palo pandž dive, resle ani Cezareja o prvosvešteniko o Ananija hem nekobor starešine nesave advokateja palo anav Tertul, i vaćerde e upravnikose o optužbe protiv o Pavle. ");
INSERT INTO rmna_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Kad vičinde e Pavle te đerdini, o Tertul lelja te vaćeri i optužba anglo upravniko: “Cenimeja Felikse, tu injan zaslužno so živinaja ano baro mir hem ano napredak savo ulo pali ti briga zako šukaripe e narodose, ");
INSERT INTO rmna_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","hem amen adava ko sa o načinja hem ko sa o thana bare zahvalibnaja priznajinaja. ");
INSERT INTO rmna_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ali, sar te na dosadinav tut više, ka zamolinav tut ano to šukaripe ukratko te šune amen. ");
INSERT INTO rmna_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Dikhaja dai akava manuš zaraza. Ov anela pobune maškaro Jevreja ko sa o carstvo hem ovi vođa zaki e nazarejakiri sekta. ");
INSERT INTO rmna_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Čak manglja hem o Hram te poganini, ali amen dolinđam le. Mangljam te sudina lese palo amaro Zakoni, ");
INSERT INTO rmna_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","ali o naredniko o Lisija alo e bara vojskaja hem ki zor lelja le amendar, ");
INSERT INTO rmna_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","naredindoj okolenđe so optužinena le te aven angla tute. Te ispitujinđan le, ka šaj hem korkoro olestar te dodžane sa okova zako sose optužinaja le.” ");
INSERT INTO rmna_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","A o Jevreja složinde pe oleja, potvrdindoj dai sa adava čače. ");
INSERT INTO rmna_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Kad o upravniko dinđa znako e Pavlese te vaćeri, ov phenđa: “Džanav da but berša injan sudija akale narodose, adalese maje šukar so ka braninav man angla tute. ");
INSERT INTO rmna_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Šaj te proverine da nane više oto dešu duj dive sar resljum ano Jerusalim te slavinav e Devle. ");
INSERT INTO rmna_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Na arakhle man da ano Hram nekasar raspravinava man, ni da pobuninava e narodo ano sinagoge ili ani diz, ");
INSERT INTO rmna_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","hem on našti te dokažinen će okova zako sose akana optužinena man. ");
INSERT INTO rmna_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ali, akava ka priznajinav će: Amare pradadengere Devlese služinava palo akava Drom, savese on vaćerena dai sekta. Verujinava ano sa okova soi palo Zakoni hem okova soi pisime ano lila e Prorokonengere. ");
INSERT INTO rmna_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Hem man isi nada ano Devel, sar so hem korkoren akalen isi – da ka ušten taro mule hem o pravedna hem o nepravedna. ");
INSERT INTO rmna_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Adalese uvek trudinav man te ovel man čisto savest anglo Devel hem anglo manuša. ");
INSERT INTO rmna_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","A palo but berša aljum ano Jerusalim te anav milostinja mle narodose hem te dav žrtve. ");
INSERT INTO rmna_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","I sar završinđum o adeti e čistibnasoro, on arakhle man ano Hram. Ali na inele čedime manuša uzala mande hem na inele nisavi galama. ");
INSERT INTO rmna_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Adala inele nesave Jevreja tari Tikori Azija. On valjani te terđoven angla tute hem te vaćeren pumare optužbe, te nešto isi len protiv mande. ");
INSERT INTO rmna_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ili, akala akate nek vaćeren korkore savi krivica arakhle upra mande kad terdinjum anglo sabor, ");
INSERT INTO rmna_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","sem te nane adava okova so vičinđum kad terdinjum maškaro lende: ‘Tumen maje avdive sudinena zbog o uštiba taro mule’.” ");
INSERT INTO rmna_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Tegani o Feliks, kova šukar pendžarđa adava so o manuša vičinena ine “Drom”, ačhavđa o sudiba zako nesavo aver dive vaćerindoj: “Kad ka avel o naredniko o Lisija, ka rešinav tumaro slučaj.” ");
INSERT INTO rmna_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","I naredinđa e kapetanese e Pavle te arakhi i straža, ali te del pe lese nesavi sloboda hem te na braninen nikase olesere manušendar te brininen pe olestar. ");
INSERT INTO rmna_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Palo nekobor dive, o Feliks alo pe romnjaja e Drusilaja, koja inele Jevrejka, i bičhalđa te anen e Pavle. Šunđa le sar vaćeri oti vera ano Isus Hrist, ");
INSERT INTO rmna_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","ali kad o Pavle lelja te vaćeri oti pravednost, oti samokontrola hem oto sudo savo avela, e Felikse dolinđa i dar, i phenđa lese: “Akana dža, a kad ka arakhav vreme, ka vičinav tut.” ");
INSERT INTO rmna_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ali uzalo adava, nadinđa pe da o Pavle ka del le pare. Adalese but puti vičini le ine hem vaćeri oleja. ");
INSERT INTO rmna_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","I palo duj berš, e Felikse nasledinđa o Porkije Fest. A o Feliks, adalese so manglja te ugodini e Jevrejenđe, ačhavđa e Pavle ano phandlipe. ");
INSERT INTO rmna_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Trin dive palo adava so prelelja i vlast upri provincija, o Fest dželo tari Cezareja upre ko Jerusalim. ");
INSERT INTO rmna_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Adari o šerutne sveštenici hem e jevrejengere šerutne phende lese zako so optužinena e Pavle, hem zamolinde le ");
INSERT INTO rmna_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","te ćerel lenđe usluga hem te naredini te anen e Pavle ko Jerusalim, adalese so planirinde zamka ko ekvaš drom te mudaren le. ");
INSERT INTO rmna_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Ali o Fest phenđa lenđe dai o Pavle ano phandlipe ani Cezareja hem da pana hari hem ov korkoro ka džal adari. ");
INSERT INTO rmna_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Tegani phenđa lenđe: “Nek nesave tumare vođendar aven mancar, hem nek optužinen e manuše tei krivo zako nešto.” ");
INSERT INTO rmna_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Palo adava so inele olencar ofto đi o deš dive, irinđa pe ki Cezareja. Tejsato dive beštino ki stolica e sudosiri hem naredinđa te anen e Pavle. ");
INSERT INTO rmna_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Kad o Pavle reslja, e jevrejengere šerutne kola ale taro Jerusalim okružinde le hem lelje te vaćeren phare optužbe protiv oleste, save našti ine te dokažinen. ");
INSERT INTO rmna_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","A o Pavle braninđa pe vaćerindoj: “Na ćerđum ništa soi protiv o Zakoni e jevrejengoro, ni protiv o Hram, ni protiv o caro.” ");
INSERT INTO rmna_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Ali o Fest, adalese so manglja te ugodini e Jevrejenđe, pučlja le: “Mangeja li te dža ko Jerusalim, adari te sudini pe će angla mande zako akava?” ");
INSERT INTO rmna_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","A o Pavle phenđa lese: “Na. Terđovava anglo e rimesere carosoro sudo, hem akate valjani te sudini pe maje. E Jevrejenđe na ćerđum nijekh bišukaripe, sar so hem tu šukar džane adava. ");
INSERT INTO rmna_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Te injum krivo hem te ćerđum nešto so zaslužini meriba, na našava oto meriba. Ali, te akala manuša akate bizo razlog krivinena man, niko našti te del man olenđe ko vasta. Mangava te sudini pe maje anglo e rimesoro caro.” ");
INSERT INTO rmna_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","O Fest tegani savetujinđa pe ple manušencar, i phenđa e Pavlese: “Mangljan te dža anglo e rimesoro caro, anglo leste hem ka dža.” ");
INSERT INTO rmna_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Palo nekobor dive, ani Cezareja resle o caro o Agripa hem i Vernika te posetinen e Feste. ");
INSERT INTO rmna_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Adalese so adari beštine više dive, o Fest vaćerđa e carose o slučaj e Pavlestar: “Akatei nesavo manuš kole o Feliks ačhavđa ano phandlipe. ");
INSERT INTO rmna_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Kad injumle ano Jerusalim, adari optužinde le o šerutne sveštenici hem e jevrejengere šerutne hem rodinde te ovel osudime. ");
INSERT INTO rmna_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Me phenđum lenđe da koro Rimljanja nane o adeti nekas te osudini pe angleder nego so ov, o optužime, na terđola anglo okola kola optužinena le hem na dobini prilika te branini pe taro optužbe. ");
INSERT INTO rmna_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Adalese, kad sare on mancar ale akari, me odmah tejsato dive, bizo odložiba, bešljum ki stolica e sudosiri hem naredinđum te anen adale manuše. ");
INSERT INTO rmna_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","O manuša kola optužinena le okružinde le, ali na optužinde le zako nijekh bišukaripe savo me očekujinđum, ");
INSERT INTO rmna_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","nego on oleja raspravinde pe oti lengiri vera hem oto nesavo Isus, kova mulo, kolese o Pavle tvrdini dai dživdo. ");
INSERT INTO rmna_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Me našti ine te haljovav adaja rasprava maškaro lende, i pučljum e Pavle da li mangela te džal ko Jerusalim, i adari te sudini pe lese zako adava. ");
INSERT INTO rmna_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ali, adalese so o Pavle rodinđa te arakha le đi o vreme kad o baro caro e Rimesoro ka sudini lese, naredinđum te ovel arakhlo ano phandlipe đikote na bičhalava le koro leste.” ");
INSERT INTO rmna_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Tegani o Agripa phenđa e Festese: “Hem korkoro me mangava te šunav adale manuše.” A o Fest phenđa lese: “Ka šune le tejsa.” ");
INSERT INTO rmna_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Tejsato dive o Agripa hem i Vernika ale ani svečano ceremonija e glavnone narednikonencar hem e dizjakere prešunde manušencar hem đerdinde ki sala, a o Fest naredinđa te anen e Pavle. ");
INSERT INTO rmna_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Tegani o Fest phenđa lese: “Carona Agripa, hem sare tumen kola injen akate, dikhen akale manuše. Zbog oleste ale kora mande sa o Jevreja taro Jerusalim hem akatar, vičindoj zorale da ov više na valjani te živini. ");
INSERT INTO rmna_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ali me na arakhljum da ov ćerđa nešto so zaslužini meriba, a adalese so ov korkoro manglja te sudini lese o baro caro e Rimesoro, odlučinđum te bičhalav le koro leste. ");
INSERT INTO rmna_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Adalese so nane man ništa određeno so te pisinav olestar mle gospodarese, ikalđum le angla tumende – najangle angla tute, carona Agripa – te šaj ovel man palo akava ispitujiba so te pisinav. ");
INSERT INTO rmna_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Adalese so nane smisla te bičhalav e phandle koro e rimesoro caro, a te na pisinav zako soi adava manuš optužime.” ");
INSERT INTO rmna_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Tegani o Agripa phenđa e Pavlese: “Akana šaj te vaćere ani ti odbrana.” O Pavle vazdinđa plo vas hem lelja te vaćeri: ");
INSERT INTO rmna_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Carona Agripa, bahtalo injum adalese so avdive angla tute ka braninav man taro sa zako so o Jevreja optužinena man, ");
INSERT INTO rmna_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","najviše adalese so tu but šukar džane sa o adetija e jevrejengere hem o verovanja ko save na složinena pe. Adalese molinava tut te šune man strpljivo. ");
INSERT INTO rmna_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Sa o Jevreja džanen sar taro tikoripe živinđum maškaro mlo narodo hem ano Jerusalim. ");
INSERT INTO rmna_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Džanen man oto angleder hem šaj, te mangena, te svedočinen da me sar farisej živinđum palo zahtevija oti najstrogo grupa amara verakiri. ");
INSERT INTO rmna_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","A akana sudini pe maje zbog mli nada ano obećanje savo o Devel dinđa amare pradadenđe. ");
INSERT INTO rmna_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Hem amare dešu duj plemija nadinena pe da adava obećanje ka pherđol hem taro sa o vilo služinena e Devle dive hem rat. Zbog adaja nada, carona, o Jevreja optužinena man. ");
INSERT INTO rmna_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Sose mislinena da e Devlese nane moguće te vazdel e mulen? ");
INSERT INTO rmna_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Hem me mislinđum da valjani zorale te džav protiv o anav e Isusesoro taro Nazaret. ");
INSERT INTO rmna_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ače so ćerđum ano Jerusalim: bute svetone manušen frdinđum ano phandlipe kad o šerutne sveštenici dinde man vlast. A kad mudarde len, me složinđum man adaleja. ");
INSERT INTO rmna_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Hem ko sa o sinagoge but puti mučibnaja terinđum len te hulinen upro Isus. Edobor injumle holjame upro lende da progoninđum len hem ano dizja e abanđijengere.” ");
INSERT INTO rmna_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Ađahar me, kad dobinđum vlast hem kad mukle maje o šerutne sveštenici, leljum te džav ko Damask. ");
INSERT INTO rmna_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","I ko ekvaš o dive, carona, sar džava ine dromeja, dikhljum svetlost taro nebo, savo po zorale taro kham sijajinđa upra mande hem okolende kola džele mancar. ");
INSERT INTO rmna_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Sare peljam ki phuv, a me šunđum glaso savo ki e jevrejengiri čhib vaćerđa maje: ‘Savle, Savle, sose progonineja man? Pharoi te borine tut protiv mli volja!’ ");
INSERT INTO rmna_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Me pučljum le: ‘Ko injan tu, Gospode?’ A o Gospod phenđa maje: ‘Me injum o Isus, kole tu progonineja. ");
INSERT INTO rmna_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","A akana ušti hem terđov ko pre. Mothovđum man tuće sar te čhivav tut te ove mlo sluga hem svedoko akalestar so dikhljan mandar hem okolestar so pana ka mothovav će. ");
INSERT INTO rmna_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Me ka spasinav tut te narodostar hem e manušendar taro avera nacije, kolende bičhalava tut. ");
INSERT INTO rmna_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Tu ka phrave lengere jaćha te irinen pe tari tomina ko svetlost, tari vlast e Sotonesiri ko Devel, te šaj priminen oprostiba e grehengoro hem than maškar okolende kolai posvetime veraja ana mande.’ ");
INSERT INTO rmna_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Adalese, carona Agripa, na injumle neposlušno e nebosere vizijaće. ");
INSERT INTO rmna_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Najangle propovedinđum e manušenđe ano Damask, onda okolenđe ano Jerusalim hem ani sa e judejakiri phuv, i e manušenđe taro avera nacije – te pokajinen pe hem te irinen pe ko Devel hem te ćeren šukar delja savencar ka mothoven da pokajinde pe. ");
INSERT INTO rmna_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Adalese o Jevreja dolinde man ano Hram hem mangle te mudaren man. ");
INSERT INTO rmna_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ali, o Devel arakhlja man sa đi akava dive, te terđovav akate hem te svedočinav hem e čororenđe hem e barvalenđe. Me na vaćerava ništa aver sem okova so o Proroci hem o Mojsije phende da ka ovel: ");
INSERT INTO rmna_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","da o Hrist ka patini hem, sar prvo kova uštino taro mule, ka mothoj o svetlost e Jevrejenđe hem avere nacijenđe.” ");
INSERT INTO rmna_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Sar o Pavle branini pe ine akale lafencar, o Fest zorale vičinđa: “Pavle, tu na injan sasto! Oto baro džandipe dilindiljan.” ");
INSERT INTO rmna_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","A o Pavle phenđa lese: “Me na injum dilino, cenimeja Feste, nego vaćerava čačikane hem razumna lafija. ");
INSERT INTO rmna_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","O caro o Agripa šukar džanel sa akava hem adalese me phravdeste vaćerava lese. Džanav dai lese sa akala stvarija pendžarutne, adalese so sa adava na ulo ko nesavo garavdo than. ");
INSERT INTO rmna_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Carona Agripa, verujineja li e prorokonenđe? Džanav da verujineja.” ");
INSERT INTO rmna_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Tegani o Agripa phenđa e Pavlese: “Pana hari hem ka ubedine man te ovav hrišćanin!” ");
INSERT INTO rmna_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","A o Pavle phenđa: “Pana hari ili but, me molinava e Devle na samo tu nego hem sare kola avdive šunena man te oven sar me, ali bizo akala lancija.” ");
INSERT INTO rmna_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Tegani uštine o caro, o upravniko, i Vernika hem okola kola olencar beštine, ");
INSERT INTO rmna_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","i, kad iklile, vaćerde maškara pumende: “Akava manuš na ćerela ništa so zaslužini meriba ili phandlipe.” ");
INSERT INTO rmna_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","A o Agripa phenđa e Festese: “Te na rodel ine e rimesoro caro te sudini lese, ka šaj ine te ovel muklo.” ");
INSERT INTO rmna_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Kad inele odlučime te otplovina ki Italija, e Pavle hem nesave avere phandlen dinde jekhe kapetaneste palo anav Julije oti četa e rimesere carosiri. ");
INSERT INTO rmna_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Đerdinđam ko nesavo brodo kova alo taro Adramit, savo džala ine nakori Tikori Azija, hem otplovinđam. A amencar inele o Aristarh, o Makedonco taro Solun. ");
INSERT INTO rmna_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Tejsato dive resljam ko Sidon. A o Julije, kova e Pavleja inele sar amal, muklja lese te džal koro ple amala, te den le sa so valjani lese. ");
INSERT INTO rmna_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Kad dželjam adathar, plovinđam severno oto Kipar, sar te na phudel i barval nakoro amende. ");
INSERT INTO rmna_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Kad plovinđam prekalo more uzali Kilikija hem i Pamfilija, resljam ki diz Mira ani Likija. ");
INSERT INTO rmna_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Adari o kapetani arakhlja nesavo brodo tari Aleksandrija savo džala ine ki Italija, i čhivđa amen ano leste. ");
INSERT INTO rmna_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Divencar plovinđam pohari hem jedva nesar resljam paše uzali Knid. Adalese so i barval na muklja amenđe te ićera amaro pravco, plovinđam uzali Salmona, tari južno strana oto Krit. ");
INSERT INTO rmna_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Phareste plovinđam uzali obala hem nesar resljam đi ko than vičime “Šukar Terđojbnase”, paše uzali diz Laseja. ");
INSERT INTO rmna_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","But vreme našalđam hem o ploviba ulo opasno, i adalese so hem o post e Jevrejengoro već nakhlo, o Pavle upozorinđa len: ");
INSERT INTO rmna_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Manušalen, dikhava da amaro ploviba ka ovel opasno hem da ka ovel bari šteta, na samo zako pharipe hem zako brodo, nego hem zako amaro dživdipe.” ");
INSERT INTO rmna_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ali o kapetani više verujinđa e manušese kova upravinđa e brodoja hem e manušese kasoro brodo inele nego e Pavlesere lafenđe. ");
INSERT INTO rmna_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Adalese so o than kote o brodija terđovena na inele šukar zako nakhaviba o jevend, više džene odlučinde te otplovinen adathar hem, te šaj, te resen đi ko Feniks kaj ka nakhaven o jevend. O Feniks inele luka ko Krit savi inele irime nakoro jugozapad hem severozapad. ");
INSERT INTO rmna_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Kad phudinđa tikori barval taro jug, mislindoj da ka ovel ađahar sar so planirinde, vazdinde o sidro hem plovinde paše uzali obala e Kritesiri. ");
INSERT INTO rmna_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Ali na nakhlo but palo adava, i taro Krit lelja te phudel jekh zorali barval vičime “Severoistočno barval”. ");
INSERT INTO rmna_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Kad i barval dolinđa o brodo savo našti ine te džal protiv olate, amen mukljam te legari amen. ");
INSERT INTO rmna_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Sar plovinaja ine tari južno strana oto tikoro ostrvo vičime Klauda, jedva nesar vazdinđam o čamco zako spasiba. ");
INSERT INTO rmna_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Kad vazdinde le, e šelencar phandle o brodo hem steđinde le te na phađol. Adalese so darandile te na zaglavinen pe ko pošikalo than talo pani uzali Libija, mukle o sidro, hem ađahar i barval legarđa len. ");
INSERT INTO rmna_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Adalese so i zorali barval zorale dolinđa amen, tejsato dive lelje te frden o pharipe taro brodo, ");
INSERT INTO rmna_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","a o trito dive frdinde čak hem o alati e brodosoro. ");
INSERT INTO rmna_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Sar ni o kham ni o čerenja na iklile but dive, a i zorali barval marela amen ine, našalđam svako nada da ka spasina amen. ");
INSERT INTO rmna_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Nakhino but sar na halja pe maro. Tegani o Pavle terdino anglo lende hem phenđa lenđe: “Manušalen, valjanđen te šunen man hem te na dža taro Krit. Ađahar naka dolel amen ine akaja nevolja hem i šteta. ");
INSERT INTO rmna_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ali akana vaćerava tumenđe te ohrabrinen tumen, adalese so nijekh tumendar naka našali plo dživdipe, samo o brodo ka ovel našaldo. ");
INSERT INTO rmna_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Prekali rat terdino angla mande o anđeo e Devlesoro kolese me preperava hem služinava ");
INSERT INTO rmna_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","hem phenđa maje: ‘Ma dara, Pavle. Tu valjani te terđove ko sudo anglo caro ano Rim. Hem, ače, o Devel ka arakhi sarijen kola plovinena tuja.’ ");
INSERT INTO rmna_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Adalese, ohrabrinen tumen, adalese so verujinava e Devlese da ka ovel ađahar sar so phenđa maje. ");
INSERT INTO rmna_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Ali mora te zaglavina amen ko nesavo ostrvo.” ");
INSERT INTO rmna_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Ki dešu štarto rat sar i barval legari amen ine upro Sredozemno more, ki ekvaš i rat o mornarija mislinde dai i obala paše, ");
INSERT INTO rmna_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","i merinde o hor e panjesoro hem dikhle da isi paše uzalo saranda metarija. Na nakhlo but palo adava, i palem merinde hem dikhle dai o hor e panjesoro paše uzalo trijanda metarija. ");
INSERT INTO rmna_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Adalese so darandiljam te na khuva ko nesave stene, mukle o štar sidrija taro paluno deo e brodosoro hem molinde pe te disljol. ");
INSERT INTO rmna_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","A o mornarija mangle te našen taro brodo i lelje te muken o čamco ko pani vaćerindoj bađim da mangena te muken o sidrija od anglal, ");
INSERT INTO rmna_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","a o Pavle phenđa e kapetanese hem e vojnikonenđe: “Te na ačhile akala manuša ko brodo, tumen naka spasinen tumen.” ");
INSERT INTO rmna_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Tegani o vojnici čhinde o šele save ićerde o čamco hem mukle le te perel. ");
INSERT INTO rmna_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Angleder so te disljol, o Pavle lelja te molini len te han nešto vaćerindoj: “Avdivei dešu štarto dive sar nakhavena adžićerindoj hem bizo hajba – ništa na čhivđen ano muj. ");
INSERT INTO rmna_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Adalese molinava tumen te han, te mangena te preživinen. A nijekhese tumendar naka perel nijekh bal oto šero.” ");
INSERT INTO rmna_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Kad adava phenđa, lelja o maro hem anglo sarijende zahvalinđa e Devlese, i phaglja le hem lelja te hal. ");
INSERT INTO rmna_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Tegani sare ohrabrinde pe hem lelje te han. ");
INSERT INTO rmna_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","A ko brodo injamle dušelu eftavardešu šov džene. ");
INSERT INTO rmna_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Kad čalile, lelje te ločharen o brodo frdindoj o điv ano more. ");
INSERT INTO rmna_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Kad dislilo, na pendžarde i obala, ali dikhle nesavo zaliv e plažaja, i odlučinde, te šaj ine, adari te uplovinen e brodoja. ");
INSERT INTO rmna_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Phravde o sidrija hem mukle len ano more, a ko adava momenti mukle o kormilja ano pani, vazdinde o angluno jedro nakori barval hem lelje te plovinen đi ki plaža. ");
INSERT INTO rmna_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ali o brodo alo upro pošikalo than talo pani hem ačhilo adathe. O angluno deo zaglavinđa pe hem našti ine te mrdini, a o paluno deo lelja te phađol oto zorale talasija. ");
INSERT INTO rmna_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Tegani o vojnici mangle te mudaren e phandlen, sar te na našel neko olendar plivindoj. ");
INSERT INTO rmna_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Ali o kapetani manglja te spasini e Pavle, hem na dinđa e vojnikonenđe te ćeren adava. Ov naredinđa okolenđe kola džanen te plivinen prva te ripinen ano pani hem te ikljoven ki obala, ");
INSERT INTO rmna_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","a avera te ićeren pe upro phalja ili upro nešto so ačhilo oto brodo. Ađahar sare dživde iklile ki obala. ");
INSERT INTO rmna_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Kad ađahar spasinđam amen, dodžanđam da adava ostrvo vičini pe Malta. ");
INSERT INTO rmna_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","O manuša kola živinena adari inele but šukar premalo amende. Šukar priminde amen hem tharde i jag, adalese so lelja te perel bršim hem inele šil. ");
INSERT INTO rmna_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","A kad o Pavle čedinđa kupa oto granke hem kad čhivđa la ki jag, taro granke iklilo o sap, adalese so inele tato, hem dolinđa pe lese ko vas. ");
INSERT INTO rmna_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Kad o manuša kola živinena adari dikhle sar o sap visini lese taro vas, phende jekh averese: “Akavai manuš sigurno ubica. Spasinđa pe oto more, ali i develin palo anav Pravda na mukela lese te živini.” ");
INSERT INTO rmna_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","A o Pavle tresinđa ple vastestar e sape ki jag hem ništa na ulo lese. ");
INSERT INTO rmna_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","A on sare adžićerde te šuvljol ili otojekhvar te perel mulo. Ali kad, palo adava so but adžićerde, dikhle da e Pavlese ništa nane, promeninde pumaro misliba olestar hem lelje te vaćeren dai ov devel. ");
INSERT INTO rmna_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","A paše uzalo adava than inele o imanje e šerutnesoro oto ostrvo, kova vičinđa pe Publije. Ov priminđa amen pese ko čher hem trin dive šukar ugostinđa amen. ");
INSERT INTO rmna_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","A e Publijesoro dad pašljola ine, adalese so ine le bari jag hem bare dukha ano vođi. O Pavle đerdinđa koro leste, molinđa pe, i čhivđa ple vasta upro leste hem sasljarđa le. ");
INSERT INTO rmna_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Palo adava lelje te aven hem avera namborme manuša taro ostrvo, hem inele sasljarde. ");
INSERT INTO rmna_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Zbog adava ko but načinja mothovde da poštujinena amen, hem kad leljam te dža adale thanestar on dinde amen sa okova so valjanđa amenđe. ");
INSERT INTO rmna_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Palo trin masek, đerdinđam ko nesavo brodo savo inele tari Aleksandrija hem savo nakhavđa o jevend ko ostrvo. A tari angluni strana ole ine znako e devlengoro e blizanconengoro. ");
INSERT INTO rmna_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Ađahar resljam ki diz Sirakuza, kote ačhiljam trin dive. ");
INSERT INTO rmna_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Adathar plovinđam hem resljam ki diz Regijum. Tejsato dive phudinđa i barval taro jug, i za duj dive resljam ki diz Puteole. ");
INSERT INTO rmna_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Adari arakhljam nesave phraljen, kola zamolinde amen te ačhova koro lende efta dive. I ađahar resljam hem ko Rim: ");
INSERT INTO rmna_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Kad o phralja so živinde ano Rim šunde so avaja, iklile te resen pe amencar đi ko Trg Api hem đi ko than Trin Gostionice. Kad o Pavle dikhlja len, zahvalinđa e Devlese hem ohrabrinđa pe. ");
INSERT INTO rmna_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Kad đerdinđam ko Rim, e Pavlese mukle te živini korkoro, jekhe vojnikoja kova pazinđa le. ");
INSERT INTO rmna_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Palo trin dive, o Pavle vičinđa e jevrejengere vođen, i, kad čedinde pe, phenđa lenđe: “Phraljalen, iako ništa na ćerđum protiv amaro narodo ni protiv o adetija amare pradadengere, ano Jerusalim injumle dolime hem predime e Rimljanende. ");
INSERT INTO rmna_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","On ispitujinde man hem mangle te muken man, adalese so na injumle krivo nisose so zaslužini meriba. ");
INSERT INTO rmna_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ali o Jevreja protivinde pe, i me morandiljum te rodav te sudini pe maje anglo e rimesoro caro, a na sar te šaj optužinav mle narodo. ");
INSERT INTO rmna_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Adalese zamolinđum tumen te aven te vaćerav tumencar, adalese so zbog mli vera ani nada e Izraelesiri injum phandlo akale lanconencar.” ");
INSERT INTO rmna_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","A on phende lese: “Na priminđam nisavo lil tutar tari Judeja, hem nijekh e phraljendar kola ale adathar na javinđa ili na phenđa nešto bišukar tutar. ");
INSERT INTO rmna_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Ali, amen mangaja tutar te šuna so mislineja, adalese so džanaja da protiv akaja sekta ko sa o thana vaćeri pe.” ");
INSERT INTO rmna_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","I ađahar odredinde jekh dive, hem ko than kaj bešela ine o Pavle ale više olendar. Ov taro sabale đi raćate vaćeri lenđe ine hem svedočini e Devlesere carstvostar, hem uverini len taro e Mojsijasoro zakoni hem taro Proroci ano sa okova so odnosini pe upro Isus. ");
INSERT INTO rmna_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Nesave inele uverime ano adava so o Pavle phenđa, a avera na verujinde. ");
INSERT INTO rmna_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","I sar našti ine te složinen pe maškara pumende, lelje te džanfse kad o Pavle phenđa lenđe pana akava: “Šukar o Sveto Duho phenđa prekalo proroko o Isaija tumare pradadenđe: ");
INSERT INTO rmna_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Dža ko akava narodo hem phen: Ka šunen hem ka šunen, ali naka haljoven; ka dikhen hem ka dikhen, ali naka pendžaren. ");
INSERT INTO rmna_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Adalese so akale manušengoro vilo ulo pharo, phareste šunena kanencar hem phandle pumare jaćha, te na dikhen jaćhencar hem te na šunen kanencar, a vileja te na haljoven. Adalese našti te irinen pe kora mande te sasljarav len.’ ");
INSERT INTO rmna_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Adalese, te džanen dai akava spasenje e Devlesoro bičhaldo e manušenđe taro avera nacije, hem on ka prihvatinen le.” ");
INSERT INTO rmna_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","A kad phenđa adava, o Jevreja džele ani bari rasprava maškara pumende. ");
INSERT INTO rmna_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","O Pavle duj pherde berša ačhilo ano plo iznajmime čher. Adari priminđa sarijen kola avena ine koro leste. ");
INSERT INTO rmna_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Propovedini ine e Devlesere carstvostar hem sikaj ine oto Gospod Isus Hrist phravdeste, hem niko na sprečinđa le te ćerel adava.");
INSERT INTO rmna_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Pisinava tumenđe me o Pavle, o sluga e Isuse Hristesoro, e Devlestar vičime sar apostoli hem odvojime te propovedinav o evanđelje, ");
INSERT INTO rmna_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","savo o Devel angleder obećinđa prekalo ple proroci ano Sveta lila. ");
INSERT INTO rmna_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Adavai o evanđelje lesere Čhavestar, kovai palo telo potomko e carosoro e Davidesoro, ");
INSERT INTO rmna_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","a palo Duho kova posvetini hem uštibnaja taro mule inele mothovdo sar Čhavo e Devlesoro ano sa o zoralipe. Ovi o Isus Hrist, amaro Gospod. ");
INSERT INTO rmna_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Prekalo leste amen dobinđam i milost te ova apostolja, te šaj olese ano anav te vičina e manušen taro sa o nacije te verujinen ano leste hem te oven lese poslušna. ");
INSERT INTO rmna_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Maškaro lende hem tumen injen vičime te pripadinen e Isuse Hristese. ");
INSERT INTO rmna_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Pisinava sarijenđe ano Rim, kolen o Devel volini hem kolen vičinđa te oven olesere manuša: Milost tumenđe hem mir e Devlestar, amare Dadestar, hem e Gospodestar e Isuse Hristestar. ");
INSERT INTO rmna_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Angleder sa, zahvalinava mle Devlese prekalo Isus Hrist zako sarijenđe tumenđe, adalese so tumare veratar vaćeri pe ano sa o sveto. ");
INSERT INTO rmna_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","O Devel, kolese služinava ano mlo duho, propovedindoj o Šukar lafi lesere Čhavestar, svedoko maje da uvek molinava zako tumenđe. ");
INSERT INTO rmna_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Stalno molinava zaki prilika, tei e Devlesiri volja, nesar te avav tumende. ");
INSERT INTO rmna_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Adalese so, edobor mangava te dikhav tumen te šaj delinav tumencar nesavo duhovno daro te zoraljoven – ");
INSERT INTO rmna_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","te ohrabrina jekh avere ani zajedničko vera. ");
INSERT INTO rmna_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Mangava te džanen phraljalen, da but puti mangljum te avav tumende, hem maškara tumende te čedav nesavo plod ani vera sar so čedinđum hem maškaro manuša taro avera nacije, ali sa đi akana injumle sprečime te avav. ");
INSERT INTO rmna_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Dužno injum te propovedinav zako civilizovana hem zako necivilizovana, zako mudra hem zako nerazumna. ");
INSERT INTO rmna_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Adalese but mangava te propovedinav o evanđelje hem tumenđe ano Rim. ");
INSERT INTO rmna_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Me na lađava oto evanđelje, adalese soi ov e Devlesoro zoralipe zako spasenje svakonese kova verujini – najangle zako Jevreja, a onda hem zako avera narodija. ");
INSERT INTO rmna_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Adalese so ano evanđelje mothoj pe i pravednost e Devlesiri, savi primini pe veraja, hem samo veraja, sar soi pisime ano Sveto lil: “O pravedniko ka živini pali vera.” ");
INSERT INTO rmna_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Taro nebo mothoj pe e Devlesiri holi protiv svako bezbožnost hem nepravednost e manušengiri kola pumare nepravednodne dživdipnaja sprečinena te dičhol o čačipe e Devlestar. ");
INSERT INTO rmna_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Adalese so, okova so e Devlestar šaj džanel pe, adavai olenđe već pendžarutno – o Devel adava mothovđa lenđe. ");
INSERT INTO rmna_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","A o večno zoralipe hem o božanstvo e Devlesoroi osobine save našti te dikhen pe, ali pana taro ćeriba e svetosoro jasno šaj te dikhen pe ano okova so o Devel stvorinđa, i adalese e manušen nane izgovor. ");
INSERT INTO rmna_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Adalese so, iako džande zako Devel, na dinde le čast hem hvala sar Devlese, nego lengoro misliba ulo uzaludno, a lengoro nerazumno vilo prelelja i tomina. ");
INSERT INTO rmna_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Iako tvrdinde dai mudra, ule nerazumna. ");
INSERT INTO rmna_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","I zameninde i slava e Devlesiri, kova nikad na merela, zako idolja savei ćerde te ličinen upro manuš kova merela, upro čiriklja, upro životinje saven isi štar pre hem upro okola so lazinena phuvjaja. ");
INSERT INTO rmna_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Adalese o Devel predinđa len lengere vilengere požudenđe, te oven nečista, te ćeren lađarutne stvarija jekh averese. ");
INSERT INTO rmna_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","On zameninde e Devlesoro čačipe zako hovajba, i slavinena hem služinena okolese soi stvorime, a na e Stvoriteljese, kole valjani zauvek te slavini pe. Amen. ");
INSERT INTO rmna_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Adalese o Devel predinđa len lengere lađarutne požudenđe. Ađahar lengere đuvlja o prirodno polno odnos zameninde okoleja savo nane prirodno. ");
INSERT INTO rmna_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Isto ađahar hem o murša ačhavde o prirodno polno odnos e đuvljencar, hem thabile ani pumari grešno požuda jekh palo avereste. Ađahar o murša e muršencar ćerena lađarutne stvarija hem adaleja priminde i zaslužime kazna zako pumaro perverzno živiba. ");
INSERT INTO rmna_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","I adalese so na dikhle dai vredno o čačikano pendžariba e Devle, o Devel predinđa len lengere bezvrednone mislenđe, te ćeren okova so na džala ano redo. ");
INSERT INTO rmna_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Oni pherde oti svako nepravednost, pokvarenost, pohlepa, bišukaripe, zavist, mudariba, kavga, prevara, zlonamernost. Oni ogovaračija, ");
INSERT INTO rmna_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","vaćerena bišukar jekh averestar, mrzinena e Devle, nasilna, umislime, barikane, izmislinena bišukaripe, nepokorna pumare dadese hem e dajaće, ");
INSERT INTO rmna_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","nerazumna, nepoverljiva, bezosećajna hem nemilosrdna. ");
INSERT INTO rmna_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Iako džanen zaki e Devlesiri pravedno naredba da zaslužinena meriba okola kola adava ćerena, on na samo da adava ćerena nego hem ohrabrinena averen te ćeren adava. ");
INSERT INTO rmna_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Adalese nane tut izgovor, manušeja kova sudineja, ko god tu te ove. Adalese so, adaleja so sudineja averese, korkoro tuće sudineja, adalese so hem tu kova sudineja ćereja isto adava. ");
INSERT INTO rmna_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","A amen džanaja da o Devel pravedno sudini okolen kola ađahar ćerena. ");
INSERT INTO rmna_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Tu li mislineja, manušeja kova sudineja okolenđe kola ćerena esavke stvarija, a tu korkoro ćereja ađahar, da ka naše e Devlesere sudostar? ");
INSERT INTO rmna_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Ili šaj dikheja po tele e Devlesoro baro šukaripe, lesoro podnosiba hem lesiri strpljivost? Na haljoveja li da o Devel šukaripnaja mangela te anel tut ko pokajanje? ");
INSERT INTO rmna_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Ali, adalese so injan šeralo hem so isi tut vilo savo na kajini pe, čhiveja upra tute i holi zako Dive e holjakoro, kad ka mothoj pe e Devlesoro pravedno sudo. ");
INSERT INTO rmna_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","O Devel svakonese ka irini palo lesere delja. ");
INSERT INTO rmna_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Okolenđe kola istrajno ćerena šukaripe rodindoj i slava, i čast hem o bimeripe, ka del večno dživdipe. ");
INSERT INTO rmna_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","A okolen kolai sebična hem nane poslušna e čačipnase, a poslušnai e nepravdaće, ka resel e Devlesiri but bari holi. ");
INSERT INTO rmna_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","I nevolja hem o pharipe ka resel sarijen kola ćerena bišukaripe, prvo e Jevrejen, a onda hem e avere naroden. ");
INSERT INTO rmna_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","A slava, čast hem mir e Devlestar sarijenđe kola ćerena šukaripe, prvo e Jevrejenđe, a onda hem avere narodenđe. ");
INSERT INTO rmna_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Adalese so o Devel na dikhela koi kova. ");
INSERT INTO rmna_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Adalese so okola kola bizo Zakoni grešinde, bizo Zakoni hem ka properen. A okolenđe kola grešinde, a ine len o Zakoni, palo Zakoni hem ka ovel lenđe sudime. ");
INSERT INTO rmna_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Adalese so, anglo Devel nane pravedna okola kola šunena o Zakoni, nego ka oven opravdime okola kola ćerena palo Zakoni. ");
INSERT INTO rmna_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Adalese so kad o manuša taro avera nacije kolen nane o Zakoni, prirodno ćerena okova so o Zakoni rodela, ondai on, iako nane len o Zakoni, korkore pumenđe zakoni. ");
INSERT INTO rmna_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","On ađahar mothovena dai ano lengere vile zapisime okova so rodela o Zakoni. Adava svedočini hem lengiri savest hem lengere mislija save ponekad optužinena len, a ponekad čak braninena len. ");
INSERT INTO rmna_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Adava ka dičhol ko dive kad o Devel prekalo Hrist Isus ka sudini okova soi garavdo ano manuša, premalo mlo evanđelje savo propovedinava. ");
INSERT INTO rmna_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","A tu pheneja da injan Jevrejco hem da čhiveja to pouzdanje ano Zakoni. Hvalineja tut e Devleja ");
INSERT INTO rmna_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","hem džaneja lesiri volja, a taro Zakoni sikliljan soi ispravno. ");
INSERT INTO rmna_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Injan uverime da injan vođa e kororenđe, svetlost okolenđe kolai ani tomina, ");
INSERT INTO rmna_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","okova kova sikaj e nerazumnonen, učitelj e čhavorenđe, adalese so ano Zakoni tut isi sa o džandipe hem o čačipe. ");
INSERT INTO rmna_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Znači tu, kova averen sikaveja, korkoro tut na sikaveja? Propovedineja te na čorel pe, a tu korkoro čoreja? ");
INSERT INTO rmna_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Vaćereja te na ćerel pe preljuba, a tu korkoro ćereja preljuba? Gadinena pe će o idolja, a tu korkoro čoreja lengere hramija? ");
INSERT INTO rmna_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Hvalineja tut e Zakoneja, a phageja adava isto Zakoni hem adaleja lađareja e Devle. ");
INSERT INTO rmna_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Sar soi hem pisime ano Sveto lil: “Zbog tumende maškaro avera nacije vređini pe o anav e Devlesoro.” ");
INSERT INTO rmna_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","O obreziba isi le vrednost te ićereja o Zakoni. Ali, te phageja o Zakoni, oveja sar okova kova nane obrezime. ");
INSERT INTO rmna_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","A te okova kova nane obrezime ićeri o odredbe e Zakonesere, sar o Devel naka uračunini le maškaro obrezime? ");
INSERT INTO rmna_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Ađahar okova kova nane telesno obrezime, a ićeri o Zakoni, ka sudini tuće kova phageja o Zakoni, iako isi tut o pisime Zakoni hem o obreziba. ");
INSERT INTO rmna_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Adalese so, nane Jevrejco okova kova ađahar samo dičhola, niti o pravo obreziba nane telesno stvaro. ");
INSERT INTO rmna_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Nego, pravo Jevrejcoi okova kovai adava andral, a pravo obreziba ovela ano vilo palo Duho, a na palo pisime Zakoni. Esavko na dobini pohvala e manušendar, nego e Devlestar. ");
INSERT INTO rmna_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Savi, onda, prednost isi e Jevrejen? Ili isi li nesavi korist oto obreziba? ");
INSERT INTO rmna_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Bari korist ano sa! Najanglei e Jevrejenđe poverime e Devlesere lafija. ");
INSERT INTO rmna_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","A so te nesave olendar inele neverna? O Devel li zbog adava naka ovel više verno? ");
INSERT INTO rmna_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Na, nisar! Iakoi svako manuš hovavno, o Develi adava kovai verno ano ple obećanja, sar soi pisime ano Sveto lil: “Ka mothove tut pravedno ano sa so ka vaćere, hem ka pobedine kad ka ove sudime.” ");
INSERT INTO rmna_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","A te amari nepravednost mothoj e Devlesiri pravednost, so ka phena ko adava? Dai o Devel nepravedno kad ikali pli holi upra amende? Manušikane akava pučava. ");
INSERT INTO rmna_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Na, nisar! Sar onda o Devel ka sudini ine pravedno e svetose? ");
INSERT INTO rmna_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Ali, te mlo hovajba služini te mothoj pe o izobilje oto e Devlesoro čačipe zaki olesiri slava, sose onda pana sudini pe maje sar grešnikose? ");
INSERT INTO rmna_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Hem sose te na phena: “Hajde te ćera bišukaripe sar te šaj avel o šukaripe?” Sar so nesave vaćerena bišukar hem tvrdinena da amen ađahar vaćeraja. Adalese ka oven pravedno osudime! ");
INSERT INTO rmna_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","So, onda? Isi li amen e Jevrejen nesavi prednost upreder avera? Na, nisar! Adalese so, već phenđam dai sare, hem o Jevreja hem okola kola nane Jevreja, tali vlast e grehesiri. ");
INSERT INTO rmna_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Sar soi pisime ano Sveto lil: “Nane nijekh pravedno, nijekh; ");
INSERT INTO rmna_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","nijekh nane kova razumini, nane nijekh kova rodela e Devle. ");
INSERT INTO rmna_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Sare cidinde pe e Devlestar, sare zajedno ule beskorisna. Nane nijekh kova ćerela šukaripe, nane nijekh. ");
INSERT INTO rmna_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Lengoroi grlo sar o phravdo grobo, lengiri čhib hovaj. E sapesoroi otrov lenđe ko vošta. ");
INSERT INTO rmna_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Lengerei muja pherde armanja hem gorčina. ");
INSERT INTO rmna_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Lengere pre siđarena te mudaren, ");
INSERT INTO rmna_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","kaj god džana, anena uništenje hem beda, ");
INSERT INTO rmna_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","a o drom oto mir na pendžarena. ");
INSERT INTO rmna_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Nane len nisavi dar oto Devel.” ");
INSERT INTO rmna_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Džanaja da sa so o Zakoni vaćeri, vaćeri okolenđe kolai talo Zakoni, te šaj svako muj te phandljol hem te šaj sa o sveto te terđol anglo sudo e Devlesoro. ");
INSERT INTO rmna_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Adalese anglo leste nijekh naka opravdini pe palo ićeriba o Zakoni, adalese so o Zakoni anela e manuše đi ko pendžariba dai grešno. ");
INSERT INTO rmna_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Ali akana mothovđa pe e Devlesiri pravednost bizo Zakoni, savatar svedočinena o Zakoni hem o Proroci. ");
INSERT INTO rmna_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Opravdime injam anglo Devel prekali vera ano Isus Hrist. Adava odnosini pe upro sarijende kola verujinena adalese so nane razlika maškaro manuša. ");
INSERT INTO rmna_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Adalese so, sare grešinde hem našalde i slava e Devlesiri, ");
INSERT INTO rmna_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","ali opravdimei pali lesiri milost prekalo otkupljenje savoi ano Hrist Isus. Adavai e Devlesoro daro. ");
INSERT INTO rmna_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","O Devel odredinđa e Hriste ple rateja te ovel žrtva zako pomirenje savo primini pe veraja. Adava ćerđa te mothoj pli pravednost. Adalese so, ov ani pli strpljivost na kazninđa o grehija savei ćerde angleder, ");
INSERT INTO rmna_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","a adava ćerđa sar te mothoj pli pravednost ano akava vreme, te šaj mothoj dai ov korkoro pravedno hem te opravdini okole kova verujini ano Isus. ");
INSERT INTO rmna_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Šaj li onda, korkore amencar te hvalina amen? Našti! Palo savo zakoni? Palo zakoni savo rodela delja? Na, nego palo zakoni savo rodela vera. ");
INSERT INTO rmna_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Adalese amen smatrinaja dai o manuš opravdime pali vera, a na palo ićeriba o Zakoni. ");
INSERT INTO rmna_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","O Devel li samo e Jevrejenđe Devel? Nane li ov Devel hem avere narodenđe? Oja, hem avere narodenđe isto. ");
INSERT INTO rmna_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","I adalese soi samo jekh Devel, kova prekali vera ka opravdini e obrezimen, ov prekali adaja isto vera ka opravdini hem okolen kola nane obrezime. ");
INSERT INTO rmna_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Amen li veraja čhinavaja o Zakoni? Na, nisar! Nego, amen veraja podržinaja o Zakoni. ");
INSERT INTO rmna_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","So, onda, te phena da otkrijinđa o Avraam, amaro pradad palo telo? ");
INSERT INTO rmna_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Adalese so, tei o Avraam opravdime palo ple delja, isi le soja te hvalini pe, ali na anglo Devel. ");
INSERT INTO rmna_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Adalese so o Sveto lil phenela: “O Avraam poverujinđa e Devlese hem adava ine lese uračunime ani pravednost.” ");
INSERT INTO rmna_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Okova kova ćerela buti, na dobini pli plata sar daro, nego zaradini adava so dobini. ");
INSERT INTO rmna_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","A okolese kova na ćerela buti, a verujini ano Devel kova opravdini e biedevlesere manuše, i vera uračunini pe ani pravednost. ");
INSERT INTO rmna_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Ađahar hem o David vaćeri dai bahtalo o manuš kase o Devel uračunini i pravednost bizo te lel ano obzir lesere delja: ");
INSERT INTO rmna_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Bahtalei okola kaserei prestupija oprostime hem o grehija učharde. ");
INSERT INTO rmna_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Bahtaloi o manuš kase o Gospod na uračunini o greh.” ");
INSERT INTO rmna_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Akava li bahtalipe samo zako obrezime ili hem zako okola kola nane obrezime? Adalese so, phenđam dai i vera e Avraamese uračunime ani pravednost. ");
INSERT INTO rmna_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","A kad adava ine lese uračunime? Kad inele obrezime ili kad na inele obrezime? Adava na inele palo obreziba, nego angleder o obreziba. ");
INSERT INTO rmna_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Ov priminđa o znako oto obreziba sar pečati oti pravednost sava dobinđa veraja pana kad na inele obrezime. Adaleja o Avraam ulo dad sarijengoro kola verujinena, a kola nane obrezime, te šaj hem olenđe adava te uračunini pe ani pravednost. ");
INSERT INTO rmna_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Ovi hem dad e obrezimengoro, okolengoro kola nane samo obrezime nego hem phirena dromeja oti vera amare dadesiri e Avraamesiri, savi ole ine kad pana na inele obrezime. ");
INSERT INTO rmna_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Adalese so, o obećanje e Avraamese, ili lesere potomstvose, da ka ovel nasledniko e svetosoro, nane dindo palo ićeriba o Zakoni, nego pali pravednost savi avela oti vera. ");
INSERT INTO rmna_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Adalese so, tei o naslednici okola kola ićerena o Zakoni, onda i vera nane vredno, a o obećanjei uzaludno. ");
INSERT INTO rmna_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Adalese so, o Zakoni peja akhari e Devlesiri holi, a kaj nane Zakoni, adari nane ni phagiba o Zakoni. ");
INSERT INTO rmna_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Adalese o obećanje terđola upri vera, te šaj o manuša prihvatinen le sar daro oti e Devlesiri milost, hem te šaj vredini zako sa o potomstvo, na samo zako okola kola ićerena o Zakoni, nego hem zako okola kolen isi vera sar e Avraamesiri. Ovi sarijenđe amenđe dad. ");
INSERT INTO rmna_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Sar soi pisime ano Sveto lil: “Ćerđum tut te ove dad bute narodengoro” – anglo Devel, ano kova poverujinđa, kova vazdela e mulen hem pali kasiri naredba oto ništa ovela nešto. ");
INSERT INTO rmna_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","O Avraam verujinđa hem nadinđa pe hem tegani kad na inele sose te nadini pe. Ađahar ulo dad bute narodengoro, adalese so o Sveto lil ađahar phenela: “Edobor baro ka ovel to potomstvo.” ");
INSERT INTO rmna_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","O Avraam džanđa da nakhlo lesoro vreme kad šaj ine te oven le čhave adalese so ine le paše đi o šel berš hem džanđa so i Sara našti ine te bijani, ali lesiri vera na peli. ");
INSERT INTO rmna_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Ov na sumnjinđa ano e Devlesoro obećanje, nego zoralilo ani vera hem dinđa slava e Devlese. ");
INSERT INTO rmna_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Inele pherdeste uverime da o Devel šaj te ćerel okova so obećinđa. ");
INSERT INTO rmna_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Adalese i vera ine lese uračunime ani pravednost. ");
INSERT INTO rmna_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","A o lafija: “ine lese uračunime”, na inele pisime samo olese, ");
INSERT INTO rmna_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","nego hem amenđe kolenđe ka uračunini pe, kola verujinaja ano Okoleste kova taro mule vazdinđa e Isuse, amare Gospode. ");
INSERT INTO rmna_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","O Isus inele dindo te merel zako amare prestupija, a uštino taro mule zako amaro opravdanje. ");
INSERT INTO rmna_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","I adalese, akana kad injam opravdime prekali vera, isi amen mir e Devleja prekalo amaro Gospod Isus Hrist. ");
INSERT INTO rmna_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Zbog amari vera ano Hrist šaj te ava ani milost e Devlesiri ani savi akana živinaja, hem hvalinaja amen ani nada da ka učestvujina ani slava e Devlesiri. ");
INSERT INTO rmna_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Hem na samo adava, nego hvalinaja amen hem e nevoljencar adalese so džanaja da ano nevolje sikljovaja te ova strpljiva. ");
INSERT INTO rmna_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Ani adaja strpljivost o Devel zorjari amaro karakteri, a adalestar bijanđola i nada. ");
INSERT INTO rmna_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Adaja nada na lađari amen, adalese so o Devel čhorđa plo mangipe ano amare vile prekalo Sveto Duho, kovai amenđe dindo. ");
INSERT INTO rmna_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Adalese so, ano pravo vreme, pana sar injamle bizorale, o Hrist mulo zako amenđe – biedevlesere manušenđe. ");
INSERT INTO rmna_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Pharoi da neko ka del plo dživdipe sar te spasini avere manuše, čak hem adava manuš te ovel pravedno. Iako šaj isi neko ko bi dela plo dživdipe zako but šukar manuš. ");
INSERT INTO rmna_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Ali, o Devel plo mangipe amenđe mothoj ađahar: pana sar injamle grešnici, o Hrist mulo zako amenđe. ");
INSERT INTO rmna_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Kobor više akana, adalese so injam opravdime lesere rateja, ka spasina amen oti holi e Devlesiri prekalo leste. ");
INSERT INTO rmna_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Adalese so, te injamle izmirime e Devleja lesere Čhavesere meribnaja, pana sar injamle lesere neprijatelja, kobor više akana ka ova spasime lesere Čhavesere dživdipnaja, akana kad injam izmirime! ");
INSERT INTO rmna_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Hem na samo adava, nego hem hvalinaja amen ano Devel prekalo amaro Gospod Isus Hrist, prekala kaste akana injam izmirime e Devleja. ");
INSERT INTO rmna_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Adalese, sar so o greh đerdinđa ano sveto prekalo jekh manuš, a prekalo greh o meriba, ađahar o meriba reslja sa e manušen, adalese so sare grešinde. ");
INSERT INTO rmna_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","O greh ano sveto inele angleder o Zakoni, ali o greh nikase na računini pe kad nane zakoni. ");
INSERT INTO rmna_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","A palem, o meriba vladinđa taro Adam đi o Mojsije hem upro okolende kola na grešinde ko isto način sar o Adam, kovai slika Okolesiri kova valjanđa te avel. ");
INSERT INTO rmna_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Ali i milost nane sar o prestup. Adalese so, te but džene mule zbog o prestup jekhe manušesoro, kobor više upro butende čhordili i milost e Devlesiri hem o daro savo alo prekali milost jekhe manušesiri, e Isuse Hristesiri. ");
INSERT INTO rmna_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Hem adava daro nane isto sar okova savo alo prekalo okoleste kova grešinđa. Adalese so, palo jekh prestup ali i osuda, a o milosno daro alo palo but prestupija hem anđa opravdanje. ");
INSERT INTO rmna_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Adalese so, te zbog o prestup jekhe manušesoro o meriba vladinđa prekalo adava jekh manuš, kobor više okola kola priminena izobilje oti milost hem daro oti pravednost ka vladinen ano dživdipe prekalo jekh manuš, prekalo Isus Hrist! ");
INSERT INTO rmna_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","I, sar so sa o manuša inele osudime zbog o prestup jekhe manušesoro, ađahar hem zbog jekh pravedno delo jekhe manušesoro sa o manuša ka oven opravdime hem ka ovel len dživdipe. ");
INSERT INTO rmna_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Adalese so, sar so palo neposlušnost jekhe manušesoro but džene ule grešna, ađahar hem pali poslušnost jekhe manušesiri but džene ka oven pravedna. ");
INSERT INTO rmna_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","O Zakoni alo te barjon o grehija. Ali, kaj barilo o greh, i milost barili po više, ");
INSERT INTO rmna_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","te šaj, sar so o greh vladinđa prekalo meriba, ađahar i milost e Devlesiri vladini prekali pravednost savi legari ano večno dživdipe prekalo Isus Hrist amaro Gospod. ");
INSERT INTO rmna_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","So onda ka phena? Valjani li te ačhova ano greh sar te barjol i milost e Devlesiri? ");
INSERT INTO rmna_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Na, nisar! Sar šaj amen kola muljam zako greh pana te živina ano leste? ");
INSERT INTO rmna_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Ili, na džanen li da sare amen kola injam krstime ano Hrist Isus injam krstime ano lesoro meriba? ");
INSERT INTO rmna_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Adalese, prekalo krstiba zajedno oleja injam parume ano lesoro meriba, te šaj hem amen, sar so o Hrist e Dadesere slavaja vazdime taro mule, živina neve dživdipnaja. ");
INSERT INTO rmna_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Adalese so, kad uljam jekh oleja ano meriba sar olesoro, isto ađahar ka ova jekh oleja ano uštiba taro mule sar olesoro. ");
INSERT INTO rmna_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Akava džanaja: amaro purano manuš čhivdoi ko krsto e Hristeja te šaj amaro grešno telo ovel uništime, te na ova više robija e grehese. ");
INSERT INTO rmna_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Adalese so, okova kovai mulo, oslobodimei oto greh. ");
INSERT INTO rmna_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","I, te muljam e Hristeja, verujinaja da hem ka živina oleja. ");
INSERT INTO rmna_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Adalese so džanaja da o Hrist, kova uštino taro mule, više naka merel – o meriba više nane le vlast upro leste. ");
INSERT INTO rmna_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Meribnaja saveja mulo, mulo jekhvar hem zauvek sar te phagel o zoralipe e grehesoro; a o dživdipe savo akana živini, živini zako Devel. ");
INSERT INTO rmna_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Ađahar hem tumen dikhen tumen da injen mule zako greh, a dživde zako Devel ano Hrist Isus. ");
INSERT INTO rmna_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Adalese o greh na tromal više te vladini ano tumaro telo savo merela, i te pokorinen tumen lesere požudenđe. ");
INSERT INTO rmna_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Ma den tumare udovija zako greh sar alatija zaki nepravda, nego den tumen zako Devel sar okola kola uštine taro mule hem tumare udovija den zako Devel sar alatija zaki pravednost. ");
INSERT INTO rmna_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Adalese so, o greh naka ovel le vlast upra tumende, adalese so na injen talo Zakoni, nego tali milost e Devlesiri. ");
INSERT INTO rmna_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","So te ćera? Te grešina adalese so na injam talo Zakoni, nego tali milost e Devlesiri? Na, nisar! ");
INSERT INTO rmna_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Na džanen li da injen robija okolesere kase pokorinena tumen, okolesere kase sar robija predena tumen te oven lese pokorna – bilo zako greh, so legari ano meriba, bilo zaki poslušnost, so legari ani pravednost. ");
INSERT INTO rmna_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Ali, hvala e Devlese so, iako injenle robija zako greh, sa vileja pokorinđen tumen zako adava sikaviba savese predinđen tumen. ");
INSERT INTO rmna_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Oslobodime injen oto greh hem uljen robija zaki pravednost. ");
INSERT INTO rmna_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Koristinava svakodnevna primerija ano vaćeriba zbog o bizoralipe tumare telosoro. Sar so nekad predinđen tumare udovija te služinen zaki nečistota hem zako bezakonje, ađahar akana preden tumare udovija te služinen zaki pravednost, so legari ani svetost. ");
INSERT INTO rmna_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Adalese so, kad injenle robija zako greh, injenle slobodna oti pravednost. ");
INSERT INTO rmna_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","I savi korist ine tumen adalestar savestar avdive lađana? Konačnoi rezultat adalestar o meriba. ");
INSERT INTO rmna_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Ali, akana kad injen oslobodime oto greh hem kad uljen robija e Devlesere, i korist savi isi tumen legari ani svetost, a konačnoi rezultat adalestar o večno dživdipe. ");
INSERT INTO rmna_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Adalese soi i plata zako greh meriba, a daro e Devlesoroi večno dživdipe ano amaro Gospod Hrist Isus. ");
INSERT INTO rmna_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Ili, na džanen li, phraljalen – vaćerava okolenđe kola džanen o Zakoni – da o Zakoni isi le vlast upro manuš samo đikotei dživdo? ");
INSERT INTO rmna_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Ađahari hem i dindi đuvli, palo Zakoni, phandli zako plo rom đikotei ov dživdo. Ali, te lakoro rom merela, slobodnoi taro Zakoni saveja inele phandli zako plo rom. ");
INSERT INTO rmna_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Adalese, te dželi avereja đikotei lakoro rom dživdo, ka vičini pe preljubnica. Ali, te lakoro rom merela, slobodnoi taro Zakoni hem nane preljubnica te lelja avere. ");
INSERT INTO rmna_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Ađahar hem tumen, mle phraljalen, prekalo telo e Hristesoro muljen zako Zakoni te pripadinen averese, Okolese kova uštino taro mule, hem te ova plodonosna zako Devel. ");
INSERT INTO rmna_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Adalese so, đikote živinđam palo telo, o bišukar požude save inele izazivime e Zakoneja vladinde ano amare udovija, a o plod adalestar inele meriba. ");
INSERT INTO rmna_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Ali, akana injam slobodna oto Zakoni adalese so muljam zako adava saveja injamle phandle. Akana služinaja e Devlese ko nevo način e Duhostar, a na ko purano način palo pisime Zakoni. ");
INSERT INTO rmna_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","So onda ka phena? Dai o Zakoni greh? Na, nisar! A palem, me naka džanav ine soi greh te na ovel ine o Zakoni. Adalese so, naka džanav ine soi požuda te na phenel ine o Zakoni: “Ma mang okova so nane klo!” ");
INSERT INTO rmna_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","A o greh iskoristinđa i prilika hem prekali adaja naredba ana mande izazivinđa svako vrsta oti požuda. Adalese so, o grehi bizo Zakoni mulo. ");
INSERT INTO rmna_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Nekad živinđum bizo Zakoni, a kad ali i naredba, o greh oživinđa, ");
INSERT INTO rmna_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","a me muljum. I ađahar i naredba, savi valjanđa te anel maje dživdipe, anđa maje meriba. ");
INSERT INTO rmna_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Adalese so, o greh iskoristinđa i prilika hem e naredbaja prevarinđa man hem mudarđa man. ");
INSERT INTO rmna_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Adalese, o Zakoni sveto hem i naredbai sveto, pravedno hem šukar. ");
INSERT INTO rmna_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Značini li da adava soi šukar anđa maje meriba? Na, nisar! A palem, o greh te mothoj pe dai greh, ov prekalo adava soi šukar anđa meriba, hem ađahar o greh prekalo naredbe te mothoj pe dai pherdeste grešno. ");
INSERT INTO rmna_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Džanaja dai o Zakoni duhovno, a da me injum telesno, biknime sar robo e grehese. ");
INSERT INTO rmna_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Na haljovava so ćerava, adalese so na ćerava okova so mangava, nego ćerava okova so mrzinava. ");
INSERT INTO rmna_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","A te ćerava okova so na mangava, značini da slažinav man dai o Zakoni šukar. ");
INSERT INTO rmna_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","A palem, adava na ćerava više me, nego o greh savo živini ana mande. ");
INSERT INTO rmna_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Adalese džanav da ana mande – ano mlo telo – na živini ništa šukar. Adalese so, isi man želja te ćerav okova soi šukar, ali na injum ano stanje te ćerav adava. ");
INSERT INTO rmna_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Adalese so, na ćerava o šukar, savo mangava, nego o bišukar, savo na mangava. ");
INSERT INTO rmna_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Ali, te ćerava okova so na mangava, onda adava na ćerava me, nego o greh savo živini ana mande. ");
INSERT INTO rmna_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Ađahar arakhljum akava zakoni: kad mangava te ćerav šukar, adathei odmah o bišukar. ");
INSERT INTO rmna_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Ano mlo vilo injum oduševime e Devlesere Zakoneja, ");
INSERT INTO rmna_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","ali dikhava da ano mle udovija delujini aver zakoni, savo marela pe protiv o zakoni mla gođakoro hem phandela man e grehesere zakoneja savoi ano mle udovija. ");
INSERT INTO rmna_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Kobor jadno injum me! Ko ka oslobodini man akale telostar savo merela? ");
INSERT INTO rmna_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Hvala e Devlese, kova oslobodini man prekalo amaro Gospod Isus Hrist! Ađahar me mla gođaja služinava e Devlesere Zakonese, a mle teloja e grehesere zakonese. ");
INSERT INTO rmna_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Adalese akana nane osuda okolenđe kolai ano Hrist Isus, ");
INSERT INTO rmna_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","adalese so o zakoni e Duhosoro savo anela dživdipe ano Hrist Isus oslobodinđa man oto zakoni e grehesoro hem e meribnasoro. ");
INSERT INTO rmna_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Adalese so, okova so o Zakoni našti ine te ćerel, zbog o bizoralipe e telosoro, ćerđa o Devel ađahar so bičhalđa ple Čhave ano obličje e grešnone telosoro te ovel žrtva zako greh. Hem ađahar osudinđa o greh ano telo, ");
INSERT INTO rmna_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","te šaj o pravedno zahtev e Zakonesoro pherđol ana amende kola na živinaja palo telo, nego palo Duho. ");
INSERT INTO rmna_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Adalese so, okola kola živinena palo telo, mislinena ko okova soi telesno, a okola kola živinena palo Duho, mislinena ko okova soi duhovno. ");
INSERT INTO rmna_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Adalese so, i godi legardi teloja anela meriba, a i godi legardi Duhoja anela dživdipe hem mir. ");
INSERT INTO rmna_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Adalese so, kadi i godi legardi teloja, oj džala protiv o Devel, adalese so nane pokorno e Devlesere Zakonese, niti nane sposobno te ćerel adava. ");
INSERT INTO rmna_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Ađahar, okola kolai legarde teloja našti te ugodinen e Devlese. ");
INSERT INTO rmna_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Ali, tumen na injen legarde teloja, nego Duhoja, te čače e Devlesoro Duho živini ana tumende. Te nekas nane e Hristesoro Duho, na pripadini e Hristese. ");
INSERT INTO rmna_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","A tei o Hrist ana tumende, o teloi mulo zbog o greh, ali o Duho dela tumen dživdipe adalese so injen opravdime anglo Devel. ");
INSERT INTO rmna_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","A te e Devlesoro Duho, kova vazdinđa e Isuse taro mule, živini ana tumende, onda o isto Devel kova e Hriste vazdinđa taro mule, prekalo Duho kova živini ana tumende, ka oživini hem tumare telija save merena. ");
INSERT INTO rmna_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Adalese, phraljalen, na injam dužna e telose te živina palo leste. ");
INSERT INTO rmna_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Adalese so, te živinena palo telo, mora hem te meren. Ali, te e Duhoja mudarena tumare telesna delja, ka živinen. ");
INSERT INTO rmna_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Adalese so, okola kolen legari e Devlesoro Duho, oni e Devlesere čhave. ");
INSERT INTO rmna_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Adalese so, e Duho kole priminđen na legari tumen ano ropstvo sar te šaj palem živinen ani dar, nego ćerđa tumen te oven e Devlesere čhave hem prekalo leste vičinaja: “Abba, Dade!” ");
INSERT INTO rmna_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Korkoro o Duho svedočini zajedno amare duhoja da injam e Devlesere čhave. ");
INSERT INTO rmna_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","I, te injam čhave, onda injam hem naslednici – naslednici e Devlesere hem zajedno naslednici e Hristeja, te čače e Hristeja patinaja, te šaj učestvujina ani lesiri slava. ");
INSERT INTO rmna_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Smatrinava da amare patnje save isi amen akana našti ni te uporedini pe e slavaja savi ka mothoj pe amenđe. ");
INSERT INTO rmna_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Adalese so, sa so o Devel stvorinđa željno adžićeri te mothoj pe i slava e Devlesere čhavengiri. ");
INSERT INTO rmna_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Adalese so, sa soi stvorime ulo bezvredno, na amara voljaja, nego e Devlesere voljaja, ani nada ");
INSERT INTO rmna_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","da ani slavno sloboda e Devlesere čhavengiri hem sa adava ka primini oslobođenje oto ropstvo savo legari ani propast. ");
INSERT INTO rmna_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Džanaja da sa soi stvorime e Devlestar uzdišini hem mučini pe sa đi akana, sar i đuvli anglo bijaniba. ");
INSERT INTO rmna_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Hem na samo okova soi stvorime, nego hem amen kola isi amen e Duho sar prvo daro e Devlesoro, isto uzdišinaja adžićerindoj o Devel pherdeste te usvojini amen, te otkupini amare telija. ");
INSERT INTO rmna_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Adalese so, ani adaja nada injam spasime. A i nada savi dičhola nane nada, adalese so niko na nadini pe okolese so već dikhela. ");
INSERT INTO rmna_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Ali, te nadinaja amen okolese so na dikhaja, onda adava strpljivo adžićeraja. ");
INSERT INTO rmna_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Isto ađahar hem o Duho amenđe pomožini ano amare bizoralipa. Amen na džanaja zako so valjani te molina, ali korkoro o Duho molini zako amenđe ano uzdisaja save lafencar našti te opisinen pe. ");
INSERT INTO rmna_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","A Okova kova ispitujini o vile džanel so o Duho mangela, adalese so o Duho pali volja e Devlesiri molini zako e Devlesere manuša. ");
INSERT INTO rmna_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Džanaja da sa džala ko šukar okolenđe kola volinena e Devle, okolenđe kolen ov vičinđa palo plo plan. ");
INSERT INTO rmna_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Adalese so, okolen kolen o Devel angleder džanđa, adalen hem predodredinđa te oven menjime premali slika lesere Čhavesiri, sar te šaj lesoro Čhavo ovel prvenco maškaro but phralja. ");
INSERT INTO rmna_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","A okolen kolen predodredinđa, adalen hem vičinđa. A kolen vičinđa, adalen hem opravdinđa. A kolen opravdinđa, adalen hem proslavinđa. ");
INSERT INTO rmna_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","So onda te phena ko sa akava? Tei o Devel amencar, ko šaj protiv amende? ");
INSERT INTO rmna_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Ov, kova čak ni ple Čhave na poštedinđa, nego dinđa le te merel zako sarijenđe amenđe, sigurno ka del amen hem sa aver zajedno oleja. ");
INSERT INTO rmna_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Ko šaj te optužini okolen kolen izabirinđa o Devel? Niko! O Develi adava kova opravdini len. ");
INSERT INTO rmna_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Ko ka osudini len? Niko! Adalese so o Hrist Isus kova mulo, hem soi po bitno, kova inele vazdime taro mule bešela ko počasno than oti desno strana e Devlesiri hem molini pe zako amenđe. ");
INSERT INTO rmna_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Ko ka cidel amen e Hristesere mangipnastar? I nevolja, o pharipe, o progonstvo, i bokh, o čororipe, i opasnost ili o meriba? ");
INSERT INTO rmna_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Sar soi pisime ano Sveto lil: “Zbog tuće mudarena amen svako dive, dikhena amen sar bakren zako čhiniba.” ");
INSERT INTO rmna_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Ali, ano sa adava zorale pobedinaja prekalo Okoleste kova zavolinđa amen. ");
INSERT INTO rmna_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Adalese so, uverime injum da ni o meriba, ni o dživdipe, ni o anđelja, ni o poglavarstvija, ni i sadašnjost, ni i budućnost, niti bilo savo zoralipe, ");
INSERT INTO rmna_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ni o učipe ni o hor, ni bilo so aver soi stvorime, našti te ciden amen e Devlesere mangipnastar savoi ano amaro Gospod Hrist Isus. ");
INSERT INTO rmna_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Vaćerava o čačipe ano Hrist, na hovavava, svedokoi maje mli savest ano Sveto Duho: ");
INSERT INTO rmna_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","mli žalost bari hem beskrajno dukh isi man ano vilo. ");
INSERT INTO rmna_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Adalese so, zako mle phralja, kolai mli familija palo telo, ka mangav ine me te ovav prokleto hem cidime oto Hrist, kad bi šaj ine adava te spasini len. ");
INSERT INTO rmna_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Oni o Izraelci. Olen o Devel usvojinđa, te oven lesere čhave. Olenđe o Devel mothovđa pli slava, hem dinđa len o savezija, o Zakoni, o način sar te služinen lese hem o obećanja. ");
INSERT INTO rmna_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Olengerei hem o pradada o Avraam, o Isaak hem o Jakov, a olendar, palo telo, avela hem o Hrist, kovai Devel upreder sa. Olese slava zauvek! Amen. ");
INSERT INTO rmna_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Ali, adava na značini da o Devel na ićerđa plo obećanje. Adalese so nane sare kolai palo bijandipe Izraelci, prava Izraelci, ");
INSERT INTO rmna_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","niti e Avraamesere čačikane čhave sare kolai lesoro potomstvo, nego: “To potomstvo ka računini pe prekalo Isaak.” ");
INSERT INTO rmna_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Adava značini da nane e Devlesere čhave sare kolai e Avraamesere potomci palo telo. Samoi o čhave oto obećanje e Devlesere čhave. ");
INSERT INTO rmna_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","A akavai o lafi oto obećanje: “Ka avav aver berš ko akava vreme, hem e Sara ka ovel čhavo.” ");
INSERT INTO rmna_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Hem na samo oj. Ko isto način i Reveka akharđa blizanconen amare pradadestar e Isaakestar. ");
INSERT INTO rmna_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","A angleder so o čhave bijandile hem angleder so šaj ine te ćeren nešto šukar ili bišukar – sar te ačhol ko zoralipe e Devlesoro plan oto izabiriba, ");
INSERT INTO rmna_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","savo na zavisini oto delja, nego Okolestar kova dela o poziv – ine olaće phendo: “O phureder ka služini e tiknederese.” ");
INSERT INTO rmna_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Sar soi pisime ano Sveto lil: “E Jakove zavolinđum, a e Isave zamrzinđum.” ");
INSERT INTO rmna_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","So onda te phena? Dai o Devel o nepravedno? Na, nisar! ");
INSERT INTO rmna_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Adalese so, ov e Mojsijase phenđa: “Ka smilujinav man kase me mangava te smilujinav man hem ka mothovav milosrđe kase me mangava te mothovav milosrđe.” ");
INSERT INTO rmna_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","I adalese na zavisini ništa oti amari želja ili oto amaro trud, nego e Devlestar kova smilujini pe. ");
INSERT INTO rmna_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Adalese so, o Devel ano Sveto lil phenela e faraonese: “Adalese čhivđum tut te ove vladari, sar te šaj mothovav mlo zoralipe prekala tute hem mlo anav te šunđol ki sa i phuv.” ");
INSERT INTO rmna_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","I adalese, smilujini pe kase ov mangela, hem steđini o vile okolengere kase ov mangela. ");
INSERT INTO rmna_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Neko šaj ka pučel man: “Sose onda o Devel pana krivini amen? Ko šaj te suprotstavini pe zaki lesiri volja?” ");
INSERT INTO rmna_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Ali, ko injan tu, manušeja, te raspravinen tut e Devleja? Šaj li okova soi stvorime te phenel ple stvoriteljese: “Sose ađahar ćerđan man?” ");
INSERT INTO rmna_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Nane li pravo okole kova ćerela buti e glinaja oti isto glina te ćerel jekh čaro zaki čast, a aver zaki ladž? ");
INSERT INTO rmna_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","A so te o Devel, mangindoj te mothoj pli holi hem plo zoralipe, ani bari strpljivost trpinđa okolen upro kolende inele holjame hem kola inele pripremime zaki propast? ");
INSERT INTO rmna_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Ov adava ćerđa sar te mothoj o barvalipe oti pli slava upro okolende kolenđe mothoj milosrđe, kolen angleder pripreminđa zaki slava. ");
INSERT INTO rmna_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Adala injam amen, kolen o Devel vičinđa na samo e Jevrejendar, nego hem e manušendar taro avera nacije. ");
INSERT INTO rmna_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Sar so o Devel phenela ano lil e prorokosoro e Osijasoro: “E manušen kola nane mlo narodo ka proglasinav dai mlo narodo hem okola koja nane volime, dai volime.” ");
INSERT INTO rmna_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Hem: “Ko adava than kaj ine lenđe phendo: ‘Tumen na injen mlo narodo’, ka oven proglasime dai ‘čhave e dživde Devlesere.’” ");
INSERT INTO rmna_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","A o proroko o Isaija phenđa e Izraelestar: “Iako isi Izraelci edobor, sar pošik ano more, samo tikoro broj olendar ka spasini pe. ");
INSERT INTO rmna_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Adalese so, o Gospod ka ćerel e phuvjaja okova so phenđa, hem sigate adava ka ćerel.” ");
INSERT INTO rmna_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Hem sar so o Isaija prorokujinđa: “Te na ačhaj amenđe ine potomstvo o Gospod kovai upreder o vojske, ka ova ine sar i Sodoma, hem ka ličina ine upri Gomora.” ");
INSERT INTO rmna_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","So onda te phena? Da o manuša taro avera nacije, kola na trudinde pe zaki pravednost, priminde i pravednost – i pravednost savi avela oti vera. ");
INSERT INTO rmna_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","A o Izraelci, kola edobor trudinde pe zaki pravednost palo ićeriba o Zakoni na uspinde ano adava. ");
INSERT INTO rmna_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Sose? Adalese so na trudinde pe te oven pravedna pali vera, nego palo pumare delja. Ađahar zapninde ko bar ko savo o manuša zapninena. ");
INSERT INTO rmna_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Sar soi pisime ano Sveto lil: “Ače, ko Sion čhivava bar ko savo ka zapninen hem stena savi ka ćerel len te peren. Ali, okova kova ano leste poverujini, naka lađal.” ");
INSERT INTO rmna_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Phraljalen, okova so taro sa o vilo mangava hem soi mli molitva e Devlese zako Izraelci adavai te oven spasime. ");
INSERT INTO rmna_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Adalese so me svedočinava zako olenđe da taro sa o vilo mangena te služinen e Devlese, ali nane len o čačikano haljojba. ");
INSERT INTO rmna_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","I adalese so na pendžarde i pravednost savi avela e Devlestar, mangle te uspostavinen pumari, hem ađahar na pokorinde pe zaki pravednost savi avela e Devlestar. ");
INSERT INTO rmna_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Adalese so o Hrist dovršinđa o Zakoni te šaj ovel opravdime svako kova verujini ano leste. ");
INSERT INTO rmna_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Oti pravednost savi avela oto Zakoni, o Mojsije pisini: “Ko ićeri o naredbe e Zakonesere, ano lende ka arakhi dživdipe.” ");
INSERT INTO rmna_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","A oti pravednost savi avela oti vera phenela ađahar: “Ma phen ano to vilo: ‘Ko ka uštel ko nebo?’ – so značini: ‘Ko ka anel e Hriste taro Nebo ki phuv?’” ");
INSERT INTO rmna_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Ili: “‘Ko ka huljel ano than e mulengoro’ – so značini: ‘Ko ka huljel te anel e Hriste taro mule?’ ” ");
INSERT INTO rmna_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Nego, so phenela? “O lafi e Devlesoroi će paše, ano to muj hem ano to vilo.” Adavai o Lafi oti vera savi propovedinaja: ");
INSERT INTO rmna_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","te priznajineja te mujeja dai o Isus Gospod hem vileja verujineja da o Devel vazdinđa le taro mule, ka ove spasime. ");
INSERT INTO rmna_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Adalese so, vileja verujini pe zako opravdanje, a mujeja priznajini pe zako spasenje. ");
INSERT INTO rmna_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Adalese o Sveto lil vaćeri: “Ko god poverujini ano leste, naka ladžal.” ");
INSERT INTO rmna_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Adalese so, nane razlika maškaro Jevrejco hem okova kova nane Jevrejco; adalese soi o Gospod jekh hem ovi isto zako sa o manuša; ov barvale blagoslovini sarijen kola vičinena lesoro anav. ");
INSERT INTO rmna_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Adalese so, “Svako kova vičini o anav e Gospodesoro, ka ovel spasime.” ");
INSERT INTO rmna_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Ali, sar te vičinen Okole ana kaste na verujinena? A sar te verujinen ano Okova kastar na šunde? Hem sar te šunen bizo propovedniko? ");
INSERT INTO rmna_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","A sar neko te propovedini e manušenđe te nane bičhaldo? Sar soi pisime ano Sveto lil: “Soi šuže o pre okolengere kola legarena o Šukar lafi.” ");
INSERT INTO rmna_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Ali, na prihvatinde sare o Šukar lafi, adalese so o Isaija phenela: “Gospode, ko poverujinđa amare lafese?” ");
INSERT INTO rmna_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","I vera avela prekalo šuniba, a o šuniba prekalo propovediba e Hristestar. ");
INSERT INTO rmna_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","A me pučava: O manuša li na šunde? Oja, šunde! Adalese so: “Lengoro glaso šundilo ki sa i phuv hem lengere lafija resle đi ko kraj e svetosoro.” ");
INSERT INTO rmna_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Hem pučava: O Izraelci li na halile? Oja, halile. Najangle o Devel prekalo Mojsije phenela: “Ka ćerav tumen te oven ljubomorna narodoja kova nane narodo, ka holjanćerav tumen narodoja kova nane razumno.” ");
INSERT INTO rmna_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","E Devlese ano anav, o Isaija bizi dar phenela: “Arakhle man okola kola na rodinde man. Mothovđum man okolenđe kola na pučle maje.” ");
INSERT INTO rmna_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","A zako Izrael phenela: “Celo dive pružinđum mle vasta premalo lende, ali oni neposlušna hem šerale.” ");
INSERT INTO rmna_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Adalese, pučava: o Devel li odbacinđa ple narodo? Na, nisar! Hem me injum Izraelco, e Avraamesoro potomko taro pleme e Venijaminesoro. ");
INSERT INTO rmna_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","O Devel na odbacinđa ple narodo, save izabirinđa angleder. Ili na džanen li so phenela o proroko o Ilija ano Sveto lil, kad žalinđa pe e Devlese protiv o Izrael? Phenđa: ");
INSERT INTO rmna_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“Gospode, mudarde sa te prorokonen hem peravde sa te žrtvenici. Samo me ačhiljum, a hem man mangena te mudaren.” ");
INSERT INTO rmna_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","I so o Devel phenđa lese? “Ačhavđum maje efta hiljade manušen kola na pele ko kočija anglo Vaal.” ");
INSERT INTO rmna_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Ađahari hem ano akava vreme: o Devel izabirinđa tikori grupa oto manuša pali pli milost. ");
INSERT INTO rmna_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Pa te izabirinđa len pali pli milost, onda adava nane zbog olengere delja. Inače, i milost e Devlesiri naka ovel više ine milost. ");
INSERT INTO rmna_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","So onda? O Izraelci na dobinde okova so rodinde. Adava dobinde okola kolen o Devel izabirinđa maškar olende, a averengere vile ule steđime. ");
INSERT INTO rmna_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Sar soi pisime ano Sveto lil: “O Devel dinđa len duho savo ćerela len zorale te soven, jaćhencar te na dikhen, hem kanencar te na šunen, sa đi ko avdisutno dive.” ");
INSERT INTO rmna_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","A o David phenela: “Nek lengiri gozba ovel lenđe zamka hem klopka, nek peren hem nek oven kaznime. ");
INSERT INTO rmna_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Nek koroljoven te na dikhen, a tu pharipnaja banđar lengere dume zauvek.” ");
INSERT INTO rmna_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","A me pučava: On li pele ano greh sar te na ušten više? Na, nisar. Nego, zbog olengoro prestup o spasenje alo hem avere narodenđe hem ćerđa e Jevrejen te oven ljubomorna. ");
INSERT INTO rmna_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","I, te olengoro prestup značini barvalipe zako sveto, a lengoro periba barvalipe zako avera narodija, kobor više barvalipe ka anel adava kad o pherdo broj oto Jevreja ka prihvatini o spasenje! ");
INSERT INTO rmna_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","A tumenđe kola na injen Jevreja, phenava: sar apostoli zako avera narodija hvalinava mli služba, ");
INSERT INTO rmna_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","te šaj nesar ćerav mle narodo te oven ljubomorna hem ađahar te spasinav nesaven olendar. ");
INSERT INTO rmna_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Adalese so, kad o Devel odbacinđa len, pomirinđa pe avere narodencar. So, onda, ka značini kad o Devel palem ka prihvatini len te na uštiba taro mule? ");
INSERT INTO rmna_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Tei o prvo kotor oto humer posvetime e Devlese, ondai hem sa o humer sveto; tei o koreno sveto, svetai hem o granke. ");
INSERT INTO rmna_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","I, tei nesave granke phage, a tu sar granka oti divljo maslina injan spojime maškar olende hem akana olencar delineja o koreno hem o sokija oti maslina, ");
INSERT INTO rmna_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","ma hvalin tut anglo phage granke. A te hvalinđan tut, setin tut da tu na akhareja o koreno, nego o koreno tut. ");
INSERT INTO rmna_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Tu ka phene: “O grankei phage sar te šaj me čhivav man olenđe ko than.” ");
INSERT INTO rmna_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Čače, oni phage adalese so na verujinde, a tu terđoveja olenđe ko than zbog ti vera. Samo, ma te ove barikano zbog adava, nego te dara. ");
INSERT INTO rmna_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Adalese so, te o Devel na poštedinđa o prirodna granke, naka poštedini ni tut. ");
INSERT INTO rmna_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Adalese, dikh e Devlesoro šukaripe hem lesiri strogoća. Ovi strogo premalo okola kola otpele, ali šukari premala tute te ačhiljan ano lesoro šukaripe. A te ačhavđan te verujine, hem tu ka ove čhindo. ");
INSERT INTO rmna_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","A hem on o Izraelci kola na ačhovena ani nevera ka oven palem spojime ko kaš, adalese so o Devel šaj te ćerel adava. ");
INSERT INTO rmna_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","I te tu, kova pali priroda injan granka oti divljo maslina, injan čhindo oto klo kaš hem injan spojime ko sadime kaš oti maslina, so nane prirodno, kobor po lokhe ka ovel zako prirodna granke te oven spojime ko pumaro kaš. ");
INSERT INTO rmna_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Phraljalen, mangava te džanen akaja tajna sar te na mislinen da sa džanen. Nesave Izraelci ule šerale hem ka ačhoven ađahar sa đikote o pherdo broj oto avera narodija na đerdini ano narodo e Devlesoro. ");
INSERT INTO rmna_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","I ađahar ka spasini pe sa o Izrael, sar soi pisime ano Sveto lil: “O Spasitelji ka avel taro Sion; ka cidel svako bezbožnost e Jakovesere potomkonendar. ");
INSERT INTO rmna_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Hem akavai mlo savez olencar kad ka cidav lengere grehija.” ");
INSERT INTO rmna_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Adalese so o Jevreja odbinde o evanđelje, ule neprijatelja e Devlesere zbog tumari korist, ali palem o Devel volini len adalese so izabirinđa lengere pradaden. ");
INSERT INTO rmna_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Adalese so, o Devel na menjini pli odluka kad dela darija hem pozivija. ");
INSERT INTO rmna_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Sar so tumen nekad injenle neposlušna e Devlese, a akana zbog olengiri neposlušnost priminđen milosrđe e Devlestar, ");
INSERT INTO rmna_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","ađahar hem on akana, ule neposlušna e Devlese zbog tumende, te šaj hem on te priminen milosrđe e Devlestar. ");
INSERT INTO rmna_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Adalese so o Devel sa e manušen phandlja ani neposlušnost te šaj sarijenđe mothoj plo milosrđe. ");
INSERT INTO rmna_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","O, kobori baro e Devlesoro barvalipe, i mudrost hem o džandipe! Lesere odluke niko našti te objasnini hem lesere droma niko našti te haljol! ");
INSERT INTO rmna_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Adalese so, ko pendžari i godi e Devlesiri? Ili ko inele lesoro savetniko? ");
INSERT INTO rmna_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Ili ko dinđa le nešto, i ov onda te dugujini lese? ");
INSERT INTO rmna_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Adalese so, sa avela olestar, hem sai ćerdo prekalo leste hem zako olese. Olese nek ovel slava zauvek! Amen. ");
INSERT INTO rmna_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Adalese molinava tumen, phraljalen, palo milosrđe savo mothovđa amenđe o Devel, te anen tumare telija sar dživdi žrtva, sveto hem ugodno e Devlese. Adavai pravo način sar te služini pe e Devlese. ");
INSERT INTO rmna_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Ma prilagodinen tumen akale svetose, nego muken e Devlese te menjini tumen ađahar so ka del tumen nevo razmisliba, te šaj džanen soi lesiri volja, soi šukar, ugodno hem savršeno. ");
INSERT INTO rmna_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Pali milost savi o Devel dinđa man, vaćerava svakonese tumendar: Ma mislinen tumendar bolje nego so valjani te mislinen, nego mislinen tumendar trezveno, pali mera oti vera savi o Devel odredinđa svakonese tumendar. ");
INSERT INTO rmna_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Adalese so, sar so isi amen but udovija ano jekh telo, a sa o udovija nane len isto uloga, ");
INSERT INTO rmna_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","ađahar hem amen, iako injam but, injam jekh telo ano Hrist, hem sare pripadinaja jekh averese. ");
INSERT INTO rmna_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Ađahar, isi amen različita darija pali milost savi priminđam e Devlestar. Kas isi daro te prorokujini, nek koristini le pali mera oti pli vera. ");
INSERT INTO rmna_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Kas isi daro te kandel, nek kandel; kas isi daro te sikaj, nek sikaj; ");
INSERT INTO rmna_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","kas isi daro te utešini, nek utešini; kas isi daro te del, nek ovel darežljivo; kas isi daro te upravini, nek upravini odgovorno; kas isi daro te mothoj milosrđe, nek ćerel adava radosno. ");
INSERT INTO rmna_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","O mangipe nek ovel čačikano, a na dujemujengoro. Mrzinen o bišukaripe, zorale ićeren tumen ko okova soi šukar. ");
INSERT INTO rmna_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Volinen jekh avere sar phraljen, poštujinen jekh avere više nego tumen. ");
INSERT INTO rmna_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Ma oven lenja, nego revno hem gorljivo služinen e Gospodese. ");
INSERT INTO rmna_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Zbog i nada savi isi tumen, oven radosna, kad injen ano nevolje, oven strpljiva, a ani molitva oven istrajna. ");
INSERT INTO rmna_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Delinen okova so isi tumen e Devlesere manušencar kolai ani potreba, hem oven gostoljubiva. ");
INSERT INTO rmna_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Blagoslovinen okolen kola progoninena tumen, blagoslovinen, a ma den armanja. ");
INSERT INTO rmna_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Radujinen tumen okolencar kola radujinena pe, roven okolencar kola rovena. ");
INSERT INTO rmna_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Oven složna maškara tumende; ma oven barikane, nego družinen tumen okolencar kolen avera dikhena da hari vredinena. Ma mislinen da sa džanen! ");
INSERT INTO rmna_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Nikase ma irinen bišukaripe zako bišukaripe. Dikhen te ćeren okova soi šukar anglo jaćha sa e manušenđe. ");
INSERT INTO rmna_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Te šaj – kobori đi tumende – živinen ano mir sa e manušencar. ");
INSERT INTO rmna_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Ma osvetinen tumen korkore, mle manglalen, nego ačhaven than e Devlesere holjaće. Adalese so ano Sveto lil pisini: “I osvetai mli, me ka irinav lenđe” – vaćeri o Gospod. ");
INSERT INTO rmna_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Umesto adava: “Tei to neprijatelji bokhalo, de le te hal, hem tei žedno, de le te pijel. Adalese so, te ćerđan ađahar, ka čhore lese jagalo žaro upro šero – ka lađare le.” ");
INSERT INTO rmna_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Ma muk o bišukaripe te pobedini tut, nego tu pobedin o bišukaripe šukaripnaja. ");
INSERT INTO rmna_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Nek svako manuš pokorini pe zako e phuvjakere vlastija. Adalese so nijekh vlast na postojini bizo e Devlesoro dopuštenje. Hem okola kola vladinena, i vlast dobinde e Devlestar. ");
INSERT INTO rmna_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Adalese, ko protivini pe zaki vlast, protivini pe okolese so o Devel postavinđa, a okola kola protivinena pe ka anen osuda upra pumende. ");
INSERT INTO rmna_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Okola kola ćerena soi šukar, na valjani te daran oti vlast. Oti vlast valjani te daran okola kola ćerena bišukaripe. Te na mangeja te dara oti vlast, ćer šukar hem i vlast ka hvalini tut. ");
INSERT INTO rmna_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Adalese so, i vlast služini e Devlese zako to šukaripe. Ali te ćereja bišukaripe, valjani te dara, adalese so i vlast na akhari o mači džabe. I vlasti e Devlesiri sluga, osvetniko kova ikali e Devlesiri holi upro okolende kola ćerena bišukaripe. ");
INSERT INTO rmna_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Adalese valjani te pokorinen tumen zako vlastija, na samo sar te našen oti e Devlesiri holi, nego hem zbog i čisto savest. ");
INSERT INTO rmna_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Adalese hem platinena o porezija. Okola kola vladinena e Devleserei službenici hem posvetinde pumaro vreme zako vladiba. ");
INSERT INTO rmna_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Den svakonese okova so dugujinena: kase porez – porez; kase carina – carina; kase poštujiba – poštujiba; kase čast – čast. ");
INSERT INTO rmna_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Nikase ništa ma oven dužna, sem te volinen jekh avere. Adalese so okova kova volini avere, pherđa e Devlesoro Zakoni. ");
INSERT INTO rmna_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Adalese so o naredbe: “Ma ćer preljuba, ma mudar, ma čor, ma mang okova so nane klo”, hem bilo savi aver, pripadinena ani akaja jekh: “Volin te pašutne sar korkore tut.” ");
INSERT INTO rmna_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Okova kova volini averen, naka ćerel lenđe bišukaripe. Adalesei o mangipe adava savo pherela e Devlesoro Zakoni. ");
INSERT INTO rmna_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Ćeren akava, adalese so džanen ano savo vreme živinaja. Alo o vreme te ušten taro sojba, adalese soi amenđe akana o spasenje po paše nego tegani kad poverujinđam. ");
INSERT INTO rmna_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","I rat nakhela, a o divei paše. Adalese, te frda amendar o delja e tominakere hem te urjava e svetlosiri oprema zako mariba. ");
INSERT INTO rmna_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Te živina pristojno sar so dolikujini e manušenđe kola živinena ano svetlost e divesoro – bizo divlja veselja hem mačojba, bizo blud hem nemoralno živiba, bizi kavga hem ljubomora! ");
INSERT INTO rmna_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Umesto adava, urjaven tumen ano Gospod Isus Hrist hem ma mislinen ko adava sar te udovoljinen e telosere požudenđe. ");
INSERT INTO rmna_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Prihvatinen okolen kolai bizorale ani vera, ali na adalese sar te raspravinen tumen olencar adalese so averčhane mislinena. ");
INSERT INTO rmna_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Neko verujini da tromal sa te hal, a o bizoralo ani vera hala samo povrće. ");
INSERT INTO rmna_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Okova kova hala sa, na valjani te mislini dai bolje okolestar kova na hala sa, ali ni okova kova na hala sa, na valjani te osudini okole kova hala sa, adalese so o Devel prihvatinđa sodujen. ");
INSERT INTO rmna_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Ko injan tu te osudine averesere sluga? Ovi odgovorno ple gospodarese kova ka odlučini da li ka ovel opravdime ili na. I ka ovel opravdime adalese so o Gospod šaj te opravdini le. ");
INSERT INTO rmna_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Neko smatrini dai nesave dive po bitna oto avera dive, a nekasei sa o dive jednaka. Samo, nek svako ovel potpuno uverime ano okova so mislini. ");
INSERT INTO rmna_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Ko mislini dai nesavo dive posebno, adava ćerela zbog o Gospod. Ko hala sa, hala zbog o Gospod, adalese so zahvalini e Devlese, a ko na hala sa, na hala zbog o Gospod hem zahvalini e Devlese. ");
INSERT INTO rmna_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Adalese so, niko amendar na živini korkoro pese hem niko na merela korkoro pese. ");
INSERT INTO rmna_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Te živinaja, zako Gospod živinaja, hem te meraja, zako Gospod meraja. Znači, bilo te živina ili te mera, pripadinaja e Gospodese. ");
INSERT INTO rmna_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Adalese o Hrist mulo hem oživinđa sar te šaj ovel Gospod hem e mulenđe hem e dživdenđe. ");
INSERT INTO rmna_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","I adalese, ko injan tu te osudine te phrale? Ili, sose mislineja da injan po šukar te phralestar? Sare ka terđova anglo sudo e Devlesoro. ");
INSERT INTO rmna_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Adalese soi pisime ano Sveto lil: “Hava sovli upro mlo dživdipe – vaćeri o Gospod – svako koč ka perel angla mande, hem svako čhib ka priznajini e Devle.” ");
INSERT INTO rmna_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","I adalese, svako amendar ka del računi e Devlese. ");
INSERT INTO rmna_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Adalese ma te osudina više jekh avere, nego najangle odlučinen te na ćeren ništa so šaj e phrale te legari te perel ili te grešini. ");
INSERT INTO rmna_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Džanav hem injum uverime ano Gospod Isus da nisavo hajba nane nečisto korkoro pestar. Nego te neko dikhela dai nešto nečisto, samoi olese nečisto. ");
INSERT INTO rmna_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Tei to phral ožalostime zbog nešto so tu haja, adava značini da na postupineja palo mangipe. Ma upropastin te hajbnaja okole zako kase o Hrist mulo. ");
INSERT INTO rmna_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Adalese, ma muk okova zako so džane dai šukar te šunđol ko bišukar glaso. ");
INSERT INTO rmna_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Adalese so, o carstvo e Devlesoro nane ano hajba hem ano piba, nego ani pravednost, ano mir hem ani radost ano Sveto Duho. ");
INSERT INTO rmna_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Adalese so, okova kova ađahar služini e Hristese, ugodnoi e Devlese hem poštujime e manušendar. ");
INSERT INTO rmna_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Adalese trudinaja amen te ćera okova so legari ano mir hem ano izgradiba jekh avere. ");
INSERT INTO rmna_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Ma uništin e Devlesoro delo zbog o hajba. Sa o hajbai čisto, ali nane šukar te neko hala nešto so avere ka legari ano greh. ");
INSERT INTO rmna_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Šukari te na hal pe o mas hem te na pijel pe i mol hem te na ćere ništa so šaj te legari te phrale ano greh. ");
INSERT INTO rmna_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Okova so verujineja, ićer tuće adava anglo Devel. Blago okolese kova korkoro pes na osudini zako okova ano soi uverime. ");
INSERT INTO rmna_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","A ko hala ani sumnja, pes osudini, adalese so adava na ćerela palo okova ano soi uverime. A sa so na ćerela pe palo uverenje, adavai greh. ");
INSERT INTO rmna_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Amen o zorale ani vera dužna injam te pomožina e bizoralen ano lengere bizoralipa, a na te ugodina amenđe. ");
INSERT INTO rmna_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Svako amendar nek ugodini ple pašutnese zako lesoro šukaripe hem izgradiba ani vera. ");
INSERT INTO rmna_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Adalese so, ni o Hrist na ugodinđa pese, nego sar soi pisime ano Sveto lil: “Upra mande pele o uvrede okolengere kola vređinde tut.” ");
INSERT INTO rmna_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","A sa soi ani prošlost pisime, pisimei amenđe zako sikaviba, te šaj prekali strpljivost hem i uteha save dela o Sveto lil, ovel amen nada. ");
INSERT INTO rmna_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","A o Devel, kova dela strpljivost hem uteha, nek del tumen te oven složna maškara tumende, sledindoj o primer e Hriste Isusesoro. ");
INSERT INTO rmna_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","Ađahar sare zajedno šaj, jekhe glasoja te den slava e Devlese hem e Dadese amare Gospodesere e Isuse Hristesere. ");
INSERT INTO rmna_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Adalese prihvatinen jekh avere, sar so o Hrist prihvatinđa tumen ki slava e Devlese. ");
INSERT INTO rmna_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Adalese so, phenava: O Hrist ulo sluga e obrezimenđe, te mothoj dai o Devel verno, te potvrdini o obećanja savei dinde e pradadenđe ");
INSERT INTO rmna_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","te šaj hem o manuša taro avera nacije te slavinen e Devle zbog olesoro milosrđe, sar soi pisime ano Sveto lil: “Adalese ka hvalinav tut maškaro manuša taro avera nacije hem ka đilabav zahvalna đilja te anavese.” ");
INSERT INTO rmna_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Hem pana phenela: “Veselinen tumen, manušalen taro avera nacije, olesere narodoja.” ");
INSERT INTO rmna_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Hem palem: “Hvalinen e Gospode, sa o manuša taro avera nacije; nek sa o narodija slavinen le.” ");
INSERT INTO rmna_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Hem palem o Isaija phenela: “Ka avel o potomko e Jesejesoro, okova kova ka uštel te vladini upro manuša taro avera nacije; ano leste o manuša taro avera nacije ka čhiven pumari nada.” ");
INSERT INTO rmna_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Nek o Devel, kastar avela i nada, pherel tumare vile svakone radujibnaja hem mireja ani vera. Ađahar tumari nada stalno ka barjol palo zoralipe e Svetone Duhosoro. ");
INSERT INTO rmna_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Mle phraljalen, me injum uverime da tumen injen pherde šukaripe, pherde svakone džandipnaja, sposobna te sikaven jekh avere. ");
INSERT INTO rmna_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","A palem, odlučnije pisinava tumenđe, te podsetinav tumen upro nesave stvarija, adalese soi maje dindi milost e Devlestar ");
INSERT INTO rmna_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","te ovav sluga e Hriste Isusesoro maškaro manuša taro avera nacije. Me služinava sar svešteniko propovedindoj e Devlesoro evanđelje, te šaj o manuša taro avera nacije oven e Devlese sar prihvatime žrtva, posvetime e Svetone Duhoja. ");
INSERT INTO rmna_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Adalese ponosno injum ano Hrist Isus upro stvarija save tičinena pe e Devlestar. ");
INSERT INTO rmna_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Adalese so, na osudinav man te vaćerav nesostar so o Hrist na ćerđa prekala mande. Prekalo mle lafija hem delja ćerđa e naroden oto avera nacije te oven poslušna e Devlese, ");
INSERT INTO rmna_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","zbog o zoralipe oto čudesna hem bare znakija save dikhle hem zbog o zoralipe e Devlesere Duhosoro. Ađahar oto Jerusalim, i sa đi ki Ilirika propovedinđum e Hristesoro evanđelje. ");
INSERT INTO rmna_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Ali uvek trudinđum man te na mothovav o evanđelje adari kaj o Hrist već pendžarutno, sar te na gradinav ko averesoro temelji. ");
INSERT INTO rmna_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Nego sar soi pisime ano Sveto lil: “Ka dikhen okola kolenđe nane vaćerdo, ka haljoven okola kola olese na šunde.” ");
INSERT INTO rmna_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Zbog adava but puti injumle sprečime te avav tumende. ");
INSERT INTO rmna_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Ali akana završinđum mli buti ko akala regije, a već beršencar but mangava te avav tumende. ");
INSERT INTO rmna_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","Planirinava te avav tumende kad ka džav ko drom zaki Španija hem te uživinav ano tumaro društvo. Nadinav man da palo adava tumen ka pomožinen maje zako mlo drom. ");
INSERT INTO rmna_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","A akana džava ko Jerusalim, adari te služinav e Devlesere manušenđe. ");
INSERT INTO rmna_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Adalese so o khanđirja ani Makedonija hem ani Ahaja phravde vileja odlučinde te čeden prilog zako čorore maškaro e Devlesere manuša ano Jerusalim. ");
INSERT INTO rmna_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Oja, on korkore odlučinde te čeden prilog, a hem dužna lenđe adava. Adalese so, te o manuša taro avera nacije ule učesnici ano lengere duhovna blagoslovija, dužnai te pomožinen lenđe hem ano lengere materijalna blagoslovija. ");
INSERT INTO rmna_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Adalese, kad ka ćerav adava hem kad ka ovav sigurno da priminde o pare savei lenđe čedime, ka pođinav ki Španija hem odrumal ka avav kora tumende. ");
INSERT INTO rmna_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","A džanav hem, kad ka avav kora tumende, da ka anav tumenđe pherdo blagoslov e Hristesoro. ");
INSERT INTO rmna_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Molinava tumen, phraljalen, ano anav e Gospodesoro e Isuse Hristesoro hem ano mangipe e Duhosoro te oven mancar zajedno ani borba molindoj e Devle zako maje. ");
INSERT INTO rmna_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Molinen tumen o Devel te spasini man e nevernikonendar ani Judeja hem mlo služiba ano Jerusalim te ovel prihvatime e Devlesere manušendar. ");
INSERT INTO rmna_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","I te šaj onda, tei e Devlesiri volja, avav tumende ani radost hem te odmorinav man zajedno tumencar. ");
INSERT INTO rmna_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Nek o Devel, kova dela mir, ovel sarijencar tumencar. Amen. ");
INSERT INTO rmna_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Preporučinava tumenđe amara phenja e Fiva, koja služini ani khanđ