﻿USE sofia;
DROP TABLE IF EXISTS sofia.rmn_vpl;
CREATE TABLE rmn_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES rmn_vpl WRITE;
INSERT INTO rmn_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Ангал о Дэл кердяс о булутя тай э пху. ");
INSERT INTO rmn_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Э пху сас би ништоско чючи, тэмина сас опэр хорипэ, тай о Духос э Дэвлэско урялас опэр пани. ");
INSERT INTO rmn_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","О Дэл пхэнляс: — Мэ овэл ярэки. Тай уло ярэки. ");
INSERT INTO rmn_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","О Дэл дикхляс, кай о ярэки лачё, тай паляшты лэс катар тэмина. ");
INSERT INTO rmn_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","О Дэл тхэдяс о ярэки «дес», ай э тэмина — «рат». Сас бэлвэль, тай сас сабаги — дес екхто. ");
INSERT INTO rmn_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","О Дэл пхэнляс: — Мэ овэл учярдипэ машкарэ ко паня, тэ палящиес о пани катар пани. ");
INSERT INTO rmn_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","О Дэл кердяс о учярдипэ тай паляшты о пани тал учярдипэ катар пани опэр лэстэ, тай уло аякха. ");
INSERT INTO rmn_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","О Дэл тхэдяс о учярдипэ «булутя». Сас бэлвэль, тай сас сабаги — дес дуйто. ");
INSERT INTO rmn_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","О Дэл пхэнляс: — О паня тал булутя тэ кидиндён екхетханэ, тай тэ овэл шукипэ. Тай уло аякха. ");
INSERT INTO rmn_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","О Дэл тхэдяс о шукипэ «пху», ай о кидинэ паня тхэдяс «морес». Тай дикхляс о Дэл, кай адава лачё. ");
INSERT INTO rmn_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","— Мэ керэл э пху зэлэниматэс: чяря гугусенца тай тэрэкя вэрсавэ сортенца опэр пху, савэ анэн имиша зэкенца, — пхэнляс о Дэл. Тай уло аякха. ");
INSERT INTO rmn_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Э пху кердяс алаи, со барёл: вэрсавэ сортя чяря, савэ анэн гугуся, тай вэрсавэ сортя тэрэкя, кай анэн имиша зэкенца. Тай о Дэл дикхляс, кай адава лачё. ");
INSERT INTO rmn_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Сас бэлвэль, тай сас сабаги — дес трито. ");
INSERT INTO rmn_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Тай о Дэл пхэнляс: — Мэ овэн ярэкя опэр учярдипэ ки булутенго, тэ палящиел о дес катар рат, тай он мэ овэн сикаипэ, тэ галярэн о вахытя, о деса тай о брэша. ");
INSERT INTO rmn_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Он мэ овэн ярэкя опэр учярдипэ ки булутенго, тэ овэл ярэки опэр пху. Тай уло аякха. ");
INSERT INTO rmn_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","О Дэл кердяс дуй барэ ярэкя — о баро ярэки, тэ гортярэл о дес, тай о тикно ярэки, тэ гортярэл э рат, тай генэ Ов кердяс о чергэня. ");
INSERT INTO rmn_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","О Дэл тхэдяс лэн опэр учярдипэ ки булутенго, тэ анэн ярэки опэр пху, ");
INSERT INTO rmn_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","гортярэнас о дес тай э рат тай палящиенас о ярэки катар тэмина. О Дэл дикхляс, кай адава лачё. ");
INSERT INTO rmn_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Сас бэлвэль, тай сас сабаги — дес штарто. ");
INSERT INTO rmn_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","О Дэл пхэнляс: — Мэ пхэрдёл о пани дживиндимаса, тай мэ урян чирикля опэр пху, опэр учярдипэ ки булутенго. ");
INSERT INTO rmn_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","О Дэл кердяс барэ моряки гайванен, вэрсавэ дживиндиматэс кажнес лэски породаса, кай вразэн андэ пани, тай чириклен пхакенца кажня лаки породаса. ");
INSERT INTO rmn_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","О Дэл алгышты лэн тай пхэнляс: — Мэ аракхлён тумэндэ пуя тай мэ овэн он бут, пхэрэн о паня андэ морес. Тай о чирикля мэ бутён опэр пху. ");
INSERT INTO rmn_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Сас бэлвэль, тай сас сабаги — дес панджто. ");
INSERT INTO rmn_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","О Дэл пхэнляс: — Мэ керэл э пху вэрсавэ сортя дживиндиматэс: кхерутнэ гайваня, тай кай балакадиен, тай вэшэски гайванен. Тай уло аякха. ");
INSERT INTO rmn_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","О Дэл кердяс вэрсавэ вэшэски гайванен, тай кхерутнэ гайванен, тай вэрсавэ, кай балакадиен. Тай дикхляс о Дэл, кай адава лачё. ");
INSERT INTO rmn_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Дэчи о Дэл пхэнляс: — Тэ керас манушэс, сар амэн, Амаро шавлин. Мэ овэл сагбус опэр маче ки моряки тай опэр чирикля ки булутенгерэ, опэр гайваня, опэр алаи ки пху тай опэр алаи, со бэшэл опэр пху. ");
INSERT INTO rmn_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Аякха о Дэл кердяс манушэс, сар Пэс; Ов кердяс лэс, По шавлин, сар шавлин э Дэвлэски; муршэс тай джювля Ов кердяс лэн. ");
INSERT INTO rmn_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","О Дэл алгышты лэн тай пхэнляс: — Мэ аракхлён тумэндэ пуя тай мэ овэн бут; пхэрэн э пху тай овэн сагбудэс опэр латэ. Овэн сагбудэс опэр маче ки моряки, тай опэр чирикля ки булутенги, тай опэр алаи, со бэшэл опэр пху. ");
INSERT INTO rmn_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Дэчи о Дэл пхэнляс: — Мэ дав тумэн алаи о чяря э гугусенца опэр алаи ки пху тай алаи о тэрэкя, кай дэн имиша зэкенца. Он кан овэн тумэнги хапэ. ");
INSERT INTO rmn_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Тай алаи э гайванен э пхуякерэн, тай алаи э чириклен опрунэн, тай алаи, со кхелавэлпэс опэр пху, — алаен, андэ кастэ си бэшыпэ, — Мэ дав тэ хан алаи э чяр. Тай уло аякха. ");
INSERT INTO rmn_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","О Дэл дикхляс опэр алаи, со Ов кердяс, тай алаи сас бут лачё. Сас бэлвэль, тай сас сабаги — дес шовто. ");
INSERT INTO rmn_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Аякха сас бытэрдимэ о кердипэ э булутенго тай э пхуяко тай алаеско, со си тай со бэшэл отхэ. ");
INSERT INTO rmn_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ко эфтато дес о Дэл бытэрды э бути, сави Ов керэлас, тай ко эфтато дес Ов на керэлас бути. ");
INSERT INTO rmn_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","О Дэл алгышты о эфтато дес тай кердяс лэс шужо, вай андэ адава дес Ов на керэлас бути. ");
INSERT INTO rmn_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Аки о пхукаипэ катар булутя тай пху, кана он сас кердэ. Кана о Дэл о Яхвэ кердяс э пху тай о булутя, ");
INSERT INTO rmn_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","опэр пху дага на сас нэ кущёки ливадяко, нэ ливадяки чяря, вай о Дэл о Яхвэ на бичялэлас опэр пху брышым, тай на сас мануш, тэ керэл бути опэр пху. ");
INSERT INTO rmn_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Екх диряв ваздиндёлас андар пху тай суслярэлас алаи ла. ");
INSERT INTO rmn_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Дэчи о Дэл о Яхвэ кердяс манушэс катар пхуяко прахос тай пхудиняс лэски андэ хэрня тынышы бэшымаско, тай о мануш уло дживиндо. ");
INSERT INTO rmn_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","О Дэл о Яхвэ барярдяс сади ко вастоки, андэ Эдэм, тай тхэдяс отхэ манушэс, савэс Ов кердяс. ");
INSERT INTO rmn_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","О Дэл о Яхвэ барярдяс катар пху алаи о тэрэкя, касавке си, шукара тэ дикхес тай лаче тэ хас. Машкарэ ко сади барёнас тэрэки бэшымаско тай тэрэки, кай галёс лачипэ тай джюнгалипэ. ");
INSERT INTO rmn_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Андар Эдэми чёрдёлас диряв, кай суслярэлас о сади, ай дэчи ой палящиеласпэс штарэ паненги. ");
INSERT INTO rmn_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","О екхто бучёлас Пишон: ов чёрдёл агорял алаи ки пху Хавила, катэ си пхоля. ");
INSERT INTO rmn_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Э пхол андэ одоя пху лачи, тай дага отэ си тэрэкеско смолас, кай шукар кхандэл, тай о бар шохам. ");
INSERT INTO rmn_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Дуйто диряв бучёл Гихон, ой чёрдёл агорял алаи ки пху Куш. ");
INSERT INTO rmn_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Трито диряв бучёл Тигр, ой чёрдёл карин вастоки катар Ашшур. Ай э штарто диряв — адава Евфрат. ");
INSERT INTO rmn_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","О Дэл о Яхвэ тхэдяс манушэс андэ Эдэмски сади, ов тэ дикхел пал лэстэ тай тэ кутардиел. ");
INSERT INTO rmn_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","О Дэл о Яхвэ диняс тхэдипэ э манушэс: — Ха имиша алаи катар тэрэкя андэ сади, ");
INSERT INTO rmn_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ай ма ха катар тэрэки, кай дэл тэ галёс лачипэ тай джюнгалипэ. Вай одова дес, кана ту кан хас имишы опрал лэстэ, ту чячес кан мэрэс. ");
INSERT INTO rmn_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","О Дэл о Яхвэ пхэнляс: — Нанай лачё манушэски тэ овэл екх. Мэ кан керав лэски ярдымарес, сар лэс. ");
INSERT INTO rmn_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","О Дэл о Яхвэ кердяс катар пху алаи э гайванен э вэшэскерэн тай алаи э чириклен опрунэн. Дэчи Ов андяс лэн ко мануш, тэ дикхел, сар одова лэн кан тхэл. Сар тхэдяс о мануш кажни дживиндо кердипэ, аякха да уло лэско нав. ");
INSERT INTO rmn_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Аякха о мануш диняс нава алаи э гайванен, алаи э чириклен опрунэн тай алаи э вэшэскерэ гайванен. Ай э Адамески на аракхлило тэ уйдиел ярдымари сар ов. ");
INSERT INTO rmn_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Дэчи о Дэл о Яхвэ диняс э манушэс зорало суно, тай бискай одова суто, лиляс екх андар лэски прашавандэ тай пханляс адава тхан тэнеса. ");
INSERT INTO rmn_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Андар прашаво, саво Ов никалдяс андар мануш, о Дэл о Яхвэ кердяс джювля тай андяс ла лэстэ. ");
INSERT INTO rmn_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","О мануш пхэнляс: — Адава кокало катар кокала минрэндар тай о тэни катар тэни минрэстэ. Ой кан бучёл «ромни», вай сас линди катар ром. ");
INSERT INTO rmn_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Оничин кан ачявэл о мануш дадэс тай дэя тай кан колизэл пэ ромняса, тай о дуй кан овэн екх тэни. ");
INSERT INTO rmn_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Тай о Адам, тай лэски ромни сас нанге, ай на сас ладжяво. ");
INSERT INTO rmn_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Андар алаи ки вэшэски гайваня, савэн кердяс о Дэл о Яхвэ, алаендар ярамази сас о сап. Ов пхучляс ки джювли: — Чячи о Дэл пхэнляс: «Ма хан нисавэ тэрэкестар андэ сади»? ");
INSERT INTO rmn_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Э джювли пхэнляс э сапэски: — Амэнги муклёл тэ хас имиша опрал тэрэкя андэ сади. ");
INSERT INTO rmn_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Ай о Дэл пхэнляс : «Ма хан имиша опрал тэрэки, саво машкарэ ко сади, тай ма астарэн лэн, я кан мэрэн». ");
INSERT INTO rmn_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","— На, тумэ на кан мэрэн, — пхэнляс о сап э джювляки. ");
INSERT INTO rmn_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","— О Дэл джянэл, кана тумэ кан хан лэн, тумарэ якха кан пхутэрдён тай тумэ кан овэн, сар о Дэл, саво джянэл о лачипэ тай о джюнгалипэ. ");
INSERT INTO rmn_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Дэчи э джювли дикхляс, кай о имишы э тэрэкеско сас лачё тэ хас тай шукар тэ дикхес, тай сас мангемаско, вай дэл годявэрипэ. Ой лиляс екх андар имиша тай халяс. Ой диняс имишы ли пэ ромэс, саво сас ласа, тай ов халас лэс. ");
INSERT INTO rmn_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Лэнги якха пхутэрдилэ, тай он галилэ, кай нанге. Дэчи он сивдэ пэски савутя опэр шалоя катар патря ки инжырески. ");
INSERT INTO rmn_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Бэлвэле пхудэлас балвалёри, сар шылоро. Он шунлэ, сар о Дэл о Яхвэ пхерэл андэ сади. О Адам тай лэски ромни гаравдэпэс катар Дэл Яхвэ машкарэ ко тэрэкя андэ сади. ");
INSERT INTO rmn_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","О Дэл о Яхвэ пхэнляс э Адамески: — Кай сан? ");
INSERT INTO rmn_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","О Адам пхэнляс: — Мэ шунлём Тут андэ сади, трашанилём, вай мэ нанго, тай гаравдёман. ");
INSERT INTO rmn_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","О Дэл о Яхвэ пхучляс: — Кон пхэнляс туки, кай ту нанго? Ту халян имиша катар тэрэки, савэстар Мэ динём тхэдипэ тэ на хас? ");
INSERT INTO rmn_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","О Адам пхэнляс: — Э джювли, савя Ту динян ман, тэ овэл ой манца, — адава ой диняс ман о имишы одолэ тэрэкестар, тай мэ халём лэс. ");
INSERT INTO rmn_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Дэчи о Дэл о Яхвэ пхэнляс э джювляки: — Со ту кердян? Э джювли пхэнляс: — О сап хохавдяс ман, аки мэ тай халём. ");
INSERT INTO rmn_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Дэчи о Дэл о Яхвэ пхэнляс э сапэски: — Андар одолэстэ, кай ту адава кердян, дино ту арман машкарэ алаи ки вэшэски тай кхерутнэ гайваня! Ту кан балакадиес опэр пэр, ту кан хас о прахос алаи о деса тэ бэшымаски. ");
INSERT INTO rmn_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Мэ кан керав душманлыки машкарэ тутэ тай ки джювли тай машкарэ тэ пуёстэ тай лаки пуёстэ: ов кан марэл то шэро, ай ту кан дандэлэс лэски патум. ");
INSERT INTO rmn_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ай э джювляки Ов пхэнляс: — Мэ кан керав то насвалипэ пуёстэ пхаро: о пуя кан аракхлён тутэ андэ хурлуки. Ту кан мангес тэ овэс опэр тэ ромэстэ, ай ов кан овэл сагбус опэр тутэ. ");
INSERT INTO rmn_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Э Адамески Ов пхэнляс: — Аякха кай ту шунлян э ромня тай халян о имишы опрал тэрэки, савэстар Мэ пхэнлёмас туки: «Ма ха лэстар», арман дини андар тутэ э пху: андэ пхари бути ту кан хас латар андэ алаи ко деса тэ бэшымаски. ");
INSERT INTO rmn_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ой кан барярэл туки хлядя тай налаче чяря, тай ту кан хас ливадяки гива. ");
INSERT INTO rmn_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","О манро кан казандиес пхарэс, бискай на кан джяс андэ пху, андар савятэ санас линдо. Вай ту — прахос, тай андэ прахос ту кан джяс. ");
INSERT INTO rmn_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","О Адам тхэдяс пэ ромня Ева, вай ой ули э дай алаи, кай бэшэн. ");
INSERT INTO rmn_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","О Дэл о Яхвэ кердяс савутя катар моркхи тай урявдяс андэ лэндэ Адамес тай лэски ромня. ");
INSERT INTO rmn_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Дэчи о Дэл о Яхвэ пхэнляс: — О мануш галило о лачипэ тай джюнгалипэ тай уло акана, сар екх андар Амэндэ. На камэл, ов тэ сидэл по васт тай тэ чинэл имишы ли опрал тэрэки ки бэшымаско, тэ хал лэс тай лиляс тэ бэшэл сальтя. ");
INSERT INTO rmn_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Тай о Дэл о Яхвэ кувды лэс андар сади Эдэм, тэ керэл ов бути опэр пху, андар савятэ сас линдо. ");
INSERT INTO rmn_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ов кувды э манушэс тай тхэдяс ко вастоки ангал сади Эдэм херувимен тай о камас, кай марэл алаи о рига ягаса, тэ дикхен пал ко дром ко тэрэки ки бэшымаско. ");
INSERT INTO rmn_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","О Адам сас э Еваса пэ ромняса, тай ой насвалили пуёстэ тай аракхлило о Каин. Ой пхэнляс: «Э ярдымеса э Сагбуски Яхвэскерэса мэ диндилём манушэс». ");
INSERT INTO rmn_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Дэчи латэ аракхлило лэско пхрал о Авель. О Авель чярявэлас э бакрэн тай бузнен, ай о Каин барярэлас опэр пху. ");
INSERT INTO rmn_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Вахытестар о Каин андяс имиша э пхуяки, сар башладипэ э Сагбуски э Яхвэски, ");
INSERT INTO rmn_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","о Сагбус о Яхвэ махтады э Авелес тай лэско башладипэ, ");
INSERT INTO rmn_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ай э Каинэс тай лэско башладипэ Ов на махтады. О Каин холясаило, тай лэско муй калило катар холи. ");
INSERT INTO rmn_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Дэчи о Сагбус о Яхвэ пхэнляс э Каинэски: — Соски ту холязэс? Соски то муй калило? ");
INSERT INTO rmn_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ту тэ керэса чячипэ, та со, ту на кан ваздэс то муй? Ай ту тэ керэс начячипэ, дэчи тэ ударэстэ гаравдэпэс бэзя: ов манген тэ овэн опэр тутэ, ай ту камэл тэ овэс опэр лэстэ. ");
INSERT INTO rmn_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","О Каин пхэнляс пэ пхралэски: — Гадэ ки ливади. Кана он сас ки ливади, о Каин читяспэс опэр пэ пхралэстэ ко Авель тай мудардяс лэс. ");
INSERT INTO rmn_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Дэчи о Сагбус о Яхвэ пхэнляс э Каинэски: — Кай то пхрал о Авель? — На джянав, — пхэнляс одова. — Та со, мэ дикхав пал мэ пхралэстэ? ");
INSERT INTO rmn_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","О Сагбус о Яхвэ пхэнляс: — Со ту кердян? О рат тэ пхралэско пхэнэл Манги андар пху. ");
INSERT INTO rmn_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Акана ту дино арман, кувдимэ андар пху, сави пхутэрдили, тэ лэл о рат тэ пхралэско, чёрдо тэ вастэса. ");
INSERT INTO rmn_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Кана ту кан керэс бути опэр пху, ой на кан дэл тут пэ имиша. Ту кан пхерэс опэр пху акарин-окорин, сар би кхерэско. ");
INSERT INTO rmn_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","О Каин пхэнляс э Яхвэ Сагбуски: — Мо хурлуки пхаро, ниш ми зор тэ накхав. ");
INSERT INTO rmn_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Анкха ту кувдиес ман катар муй ки пхуяко, тай мэ кан овав гаравдо Тутар. Мэ кан пхерав опэр пху акарин-окорин, сар би кхерэско, тай кон кан дикхел ман, одова кан мударэл ман. ");
INSERT INTO rmn_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Ай о Сагбус о Яхвэ пхэнляс лэски: — На. Кон кан мударэл э Каинэс, одова кан диндёл эфтавар бут. Тай о Сагбус о Яхвэ кан керэл э Каинэски метка, тай никхон, тэ дикхела лэс, тэ на мударэл лэс. ");
INSERT INTO rmn_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","О Каин гело катар Сагбус Яхвэ тай бэшэлас андэ пху Нод, ко вастоки катар Эдэми. ");
INSERT INTO rmn_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","О Каин сас пэ ромняса, тай ой насвалили пуёстэ тай аракхлило о Ханох. Одова вахыти о Каин тхэлас диз тай тхэдяс ла о нав пэ чявэско Ханох. ");
INSERT INTO rmn_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Ко Ханох аракхлило о Ирад, ко Ирад аракхлило о Мехиаэл, ко Мехиаэл аракхлило о Метушаэл, тай ко Метушаэл аракхлило о Ламех. ");
INSERT INTO rmn_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","О Ламех лиляс пэски ромнян до джювлен: екх бучёлас Ада, авэр — Цылла. ");
INSERT INTO rmn_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ки Ада аракхлило о Явал: ов уло о дад одолэнго, кон бэшэл андэ катунэс тай барярэл гайванен. ");
INSERT INTO rmn_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Лэско пхрал бучёлас Ювал: ов уло о дад алаенго, кон кхелэл опэр арфа тай дурули. ");
INSERT INTO rmn_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Ли ки Цылла сас чяво, Тувал-Каин, саво керэлас вэрсавэ шэя катар бронза тай састэр. Э пхэн э Тувал-Каинэски сас Наама. ");
INSERT INTO rmn_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","О Ламех пхэнляс пэ ромненги: — Ада тай Цылла, шунэн ман, ромня э Ламехески, шунэн мэ зборэс. Мэ мудардём муршэс андар одолэстэ, кай ов чиндяс ман, тэрнагарэс андар одолэстэ, кай ов чялавдяс ман. ");
INSERT INTO rmn_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Андар Каин тэ си о душманлыки эфтавар бут, андар Ламех — эфтадэша эфтавар бут. ");
INSERT INTO rmn_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","О Адам генэ сас пэ ромняса, тай латэ аракхлило чяво тай тхэдяс лэс Сиф, пхэнляс: «О Дэл башлады ман авэрэ пуёс ко тхан ки Авелеско, савэс мудардяс о Каин». ");
INSERT INTO rmn_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Ли ко Сиф сас чяво, тай ов тхэдяс лэс Енос. Одова вахыти о мануша лилэ тэ манген о нав э Сагбуски Яхвэско. ");
INSERT INTO rmn_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Аки о пхукаипэ катар Адам тай лэски пуендар. Кана о Дэл кердяс э манушэс, Ов кердяс лэс, тэ ушадиел Лэски. ");
INSERT INTO rmn_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Ов кердяс муршэс тай джювля тай алгышты лэн. Кана он сас кердэ, ов тхэдяс лэн «мануш». ");
INSERT INTO rmn_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Кана о Адам бэшло 130 брэш, лэстэ аракхлило чяво, сар ов, сар лэско шавлин, тай ов тхэдяс лэс Сиф. ");
INSERT INTO rmn_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Пал ко аракхлима ки Сифеско о Адам бэшло 800 брэш, тай лэстэ сас генэ чявэ тай чяя. ");
INSERT INTO rmn_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Алаи о Адам бэшло 930 брэш тай муло. ");
INSERT INTO rmn_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Кана о Сиф бэшло 105 брэш, лэстэ аракхлило о Енос. ");
INSERT INTO rmn_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Пал ко аракхлима ки Еносеско о Сиф бэшло 807 брэш, тай лэстэ сас генэ чявэ тай чяя. ");
INSERT INTO rmn_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Алаи о Сиф бэшло 912 брэш тай муло. ");
INSERT INTO rmn_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Кана о Енос бэшло 90 брэш, лэстэ аракхлило о Каинан. ");
INSERT INTO rmn_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Пал ко аракхлима ки Каинанеско о Енос бэшло 815 брэш, тай лэстэ сас генэ чявэ тай чяя. ");
INSERT INTO rmn_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Алаи о Енос бэшло 905 брэш тай муло. ");
INSERT INTO rmn_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Кана о Каинан бэшло 70 брэш, лэстэ аракхлило о Малелеил. ");
INSERT INTO rmn_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Пал ко аракхлима ки Малелеилеско о Каинан бэшло 840 брэш, тай лэстэ сас генэ чявэ тай чяя. ");
INSERT INTO rmn_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Алаи о Каинан бэшло 910 брэш тай муло. ");
INSERT INTO rmn_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Кана о Малелеил бэшло 65 брэш, лэстэ аракхлило о Яред. ");
INSERT INTO rmn_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Пал ко аракхлима ки Яредеско о Малелеил бэшло 830 брэш, тай лэстэ сас генэ чявэ тай чяя. ");
INSERT INTO rmn_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Алаи о Малелеил бэшло 895 брэш тай муло. ");
INSERT INTO rmn_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Кана о Яред бэшло 162 брэш, лэстэ аракхлило о Енох. ");
INSERT INTO rmn_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Пал ко аракхлима ки Енохеско о Яред бэшло 800 брэш, тай лэстэ сас генэ чявэ тай чяя. ");
INSERT INTO rmn_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Алаи о Яред бэшло 962 брэш тай муло. ");
INSERT INTO rmn_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Кана о Ханох бэшло 65 брэш, лэстэ аракхлило о Мафусал. ");
INSERT INTO rmn_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Пал ко аракхлима ки Мафусалеско о Ханох пхерэлас э Дэвлэса 300 брэш, тай лэстэ сас генэ чявэ тай чяя. ");
INSERT INTO rmn_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","О Ханох бэшло 365 брэш. ");
INSERT INTO rmn_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","О Ханох пхерэлас э Дэвлэса, дэчи лэс на уло, вай о Дэл лиляс лэс. ");
INSERT INTO rmn_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Кана о Мафусал бэшло 187 брэш, лэстэ аракхлило о Ламех. ");
INSERT INTO rmn_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Пал ко аракхлима ки Ламехеско о Мафусал бэшэлас 782 брэш, тай лэстэ сас генэ чявэ тай чяя. ");
INSERT INTO rmn_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Алаи о Мафусал бэшло 969 брэш тай муло. ");
INSERT INTO rmn_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Кана о Ламех бэшло 182 брэш, лэстэ аракхлило чяво. ");
INSERT INTO rmn_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Ов диняс лэс нав Ной тай пхэнляс: «Ов кан дэл рагати амэн андэ хэзмэти, андэ пхари бути амарэ васта, опэр пху, дини арман э Сагбуса э Яхвэса». ");
INSERT INTO rmn_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Пал ко аракхлима ки Ноеско о Ламех бэшло 595 брэш, тай лэстэ сас генэ чявэ тай чяя. ");
INSERT INTO rmn_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Алаи о Ламех бэшло 777 брэш тай муло. ");
INSERT INTO rmn_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Кана э Ноески сас 500 брэш, лэстэ аракхлилэ о Сим, о Хам тай о Яфет. ");
INSERT INTO rmn_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","О мануша лилэ тэ бутён опэр пху, тай лэндэ аракхлёнас чяя. ");
INSERT INTO rmn_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","О чявэ э Дэвлэски дикхлэ, кай о манушыканэ чяя шукара, тай лилэ тэ лэн пэски ромнен лэн, кажын савя мангляс. ");
INSERT INTO rmn_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","О Сагбус о Яхвэ пхэнляс: — На екхараи кан овэл о Духос Минро андэ мануш. О мануш э си тэни; мэ овэн о деса лэнги шэлу биш брэш. ");
INSERT INTO rmn_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Андэ адала деса (тай пал адалэ десендэ) опэр пху сас нефилимя, кана о чявэ э Дэвлэски лэнас э манушыканэ чяян тай овэнас лэндар пуя. Адава сас муршаря намлыдэс авгутнэ вахытендар. ");
INSERT INTO rmn_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","О Сагбус о Яхвэ дикхляс, кай о мануша опэр пху улэ бут канлыдэс, тай алаи лэнги тюшундиматэс екхараи бангёнас карин канлылыки. ");
INSERT INTO rmn_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","О Сагбус о Яхвэ аяды, кай кердяс манушэс опэр пху, тай о ило Лэско пхэрдило дукх. ");
INSERT INTO rmn_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Тай пхэнляс о Сагбус о Яхвэ: — Мэ кан кхосав опрал муй ки пхуяко э манушыкани порода, сави Мэ кердём. Мэ кан мударав ли э манушэн, ли э гайванен, тай кай балакадиен, тай э чириклен опрунэн, вай Мэ аядияв, кай кердём лэн. ");
INSERT INTO rmn_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ай о Ной аракхляс мила андэ якха ки Сагбуски Яхвэски. ");
INSERT INTO rmn_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Аки о пхукаипэ катар Ной тай лэски пуендар. Машкарэ ко мануша одолэ вахытески екх о Ной сас чячё тай бидошако; ов пхерэлас э Дэвлэса. ");
INSERT INTO rmn_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Ко Ной сас трин чявэ: о Сим, о Хам тай о Яфет. ");
INSERT INTO rmn_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Андэ Дэвлэски якха э пху паровдили, пхэрдили джюнгалипэ. ");
INSERT INTO rmn_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","О Дэл дикхляс, сар паровдили э пху андар одолэстэ, кай алаи о мануша опэр пху гелэ опэр налаче дрома. ");
INSERT INTO rmn_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Дэчи о Дэл пхэнляс э Ноески: — Мэ кан тхав бытима алаески, со бэшэл опэр пху, вай андар лэндэ э пху пхэрдили джюнгалимаса. Мэ кан кхосав лэн екхетханэ алаи э пхуяса. ");
INSERT INTO rmn_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Кер туки кавчеги катар тэрэки гофер, тай кер андэ лэстэ тхана, тай мак смоласа лэс андар тай аврял. ");
INSERT INTO rmn_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Аки сар ту камэл лэс тэ керэс: о кавчеги камэл тэ овэл 150 куня андэ дулгипэ, 25 куня андэ буглипэ тай 15 куня андэ учипэ. ");
INSERT INTO rmn_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Кер лэс опрал пханло тай э крыша опрал кер учи катар кавчеги екхпаш куни. Тхэ катар риг удар тай кер тэлуно, машкаруно тай опруно этажа. ");
INSERT INTO rmn_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Мэ кан бичялав опэр пху паня бугулдимаски, тэ мэрэл алаи, со бэшэл тал булутя, алаи о дживиндо, андэ савэстэ тэнышы бэшымаско. Алаи, со си опэр пху, кан мэрэл. ");
INSERT INTO rmn_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ай туса Мэ кан керав завети, тай ту кан дэс андэ кавчеги — ту тай тэ чявэ, тай ти ромни, тай о ромня тэ чявэнги. ");
INSERT INTO rmn_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Гел андэ кавчеги алаи э гайванен по дон, муршэс тай джювля, тэ ачён он дживиндэ екхетханэ туса. ");
INSERT INTO rmn_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Тутэ кан авэн, тэ ачён ли он дживиндэ, по дуй алаи андар вэрсавэ породэс андар чирикля, гайваня тай алаи о породэс, савэ балакадиен. ");
INSERT INTO rmn_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Лэ бут туса вэрсаво хапэ, тай тхэ екхетханэ, тэ хас ли ту, ли он. ");
INSERT INTO rmn_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","О Ной кердяс алаи аякха, сар пхэнляс лэски о Дэл. ");
INSERT INTO rmn_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","О Сагбус о Яхвэ пхэнляс э Ноески: — Дэ андэ кавчеги алаи э хорандаса. Мэ дикхав, кай машкарэ алаендэ, кай бэшэн андэ адава вахыти, екх ту чячё ангал Мандэ. ");
INSERT INTO rmn_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Лэ туса по эфта парэс андар вэрсавэ шужэ гайванен, муршэн тай джювлен, тай по екх пара андар кажни порода вэрсавэ нашужэ гайванен, муршэн тай джювлен, ");
INSERT INTO rmn_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","тай по эфта парэс андар вэрсавэ булутенги чириклен, муршэн тай джювлен, тэ гаравэн лэги порода опэр пху. ");
INSERT INTO rmn_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Эфта десендар Мэ кан бичялав брышым опэр пху саранда дес тай саранда ратя. Мэ кан кхосав опрал муй ки пхуяко алаи о дживиндо, савэс Мэ кердём. ");
INSERT INTO rmn_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","О Ной кердяс алаи, сар пхэнляс лэски о Сагбус о Яхвэ. ");
INSERT INTO rmn_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Кана о паня э бугулдимаски алэ опэр пху, э Ноески сас шовшэл брэш. ");
INSERT INTO rmn_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","О Ной, лэски чявэ, лэски ромни тай о ромня лэски чявэнги динэ андэ кавчеги, тэ кутардиенпэс катар бугулдима. ");
INSERT INTO rmn_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","О шужэ тай нашужэ гайваня, чирикля тай алаи, кай бэшэн по бут, ");
INSERT INTO rmn_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","алэ ко Ной тай динэ андэ кавчеги парэнца: мурш тай джювли, сар пхэнляс э Ноески о Дэл. ");
INSERT INTO rmn_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Эфта десендар опэр пху алэ о паня э бугулдимаски. ");
INSERT INTO rmn_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Кана э Ноески сас шовшэл брэш, андэ дэшуэфтато дес дуйто чёнэско, пхарэ алаи о тхана э хоримаски, пхутэрдилэ о пэнчерэс э булутенги, ");
INSERT INTO rmn_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","тай опэр пху чёрдёлас о брышым саранда дес тай саранда ратя. ");
INSERT INTO rmn_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Андэ одова жэ дес динэ андэ кавчеги о Ной, лэски чявэ о Сим, о Хам тай о Яфет, э ромни э Ноески тай о ромня лэски тринэ чявэнги. ");
INSERT INTO rmn_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Лэнца динэ андар алаи о породэс вэрсавэ гайваня: вэрсавэ породэс вэшэски гайваня, кхерутнэ гайваня, алаи о породэс, кай балакадиен опэр пху, алаи о породэс о чирикля, алаи о дживиндэ э пхакенца. ");
INSERT INTO rmn_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Алаи, андэ кастэ тэнышы бэшымаско, алэ ко Ной тай динэ андэ кавчеги парэнца, ");
INSERT INTO rmn_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","мурш тай джювли андар алаи ко породэс, сар пхэнляс э Ноески о Дэл. Тай дэчи о Сагбус о Яхвэ пханляс пал лэстэ о удар. ");
INSERT INTO rmn_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","О бугулдима сас опэр пху саранда дес, тай о паня бутёнас, ваздинэ о кавчеги, тай ов диняс джялдави опрал пху. ");
INSERT INTO rmn_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","О паня бутёнас тай ваздиндёнас, ай о кавчеги дэлас джялдави опэр пани. ");
INSERT INTO rmn_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Он ваздиндилэ опэр пху аякха учес, кай учярдэ алаи о уче горадэс тал булутя. ");
INSERT INTO rmn_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","О паня ваздиндилэ тай учярдэ алаи о горадэс учес, ниш дэшупандж куня. ");
INSERT INTO rmn_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Алаи о дживиндо, со кхелавэласпэс опэр пху, муло: чирикля, гайваня, вэшэски гайваня, алаи, со бэшэл бут опэр пху, тай алаи о мануша. ");
INSERT INTO rmn_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Алаи опэр шукипэ, андэ каски хэрнендэ сас тынышы бэшымаско, муло. ");
INSERT INTO rmn_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Алаи о дживиндо сас кхосло опрал пху: о мануша тай о гайваня, тай савэ балакадиен, тай о чирикля э булутенги. Ачило екх о Ной тай одола, кон сас лэса андэ кавчеги. ");
INSERT INTO rmn_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","О пани авэлас тай авэлас опэр пху шэлупэинда дес. ");
INSERT INTO rmn_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ай о Дэл тюшундиелас катар Ной тай катар алаи вэшэски гайваня тай катар кхерутнэ гайваня, савэ сас лэса андэ кавчеги, тай Ов бичялдяс балвал опэр пху, тай о паня лилэ тэ залагизэн. ");
INSERT INTO rmn_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","О тхана э хоримаски тай о пэнчерэс э булутенги пханлилэ, тай о брышым тэрдило тэ чёрдёл опрал. ");
INSERT INTO rmn_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","О пани тэмэли джялас опрал пху, тай ко шэлупэинда дес ов лачес гело. ");
INSERT INTO rmn_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ко дэшэфтато дес эфтато чёнэско о кавчеги тэрдило опэр горадэс Арарат. ");
INSERT INTO rmn_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","О паня генэ залагизэнас джи ко дэшто чён, тай андэ екхто дес ко дэшто чён лилэ тэ дикхиндён опрал о горадэс. ");
INSERT INTO rmn_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Саранда десендар о Ной пхутэрдяс э пэнчера, сави ов кердяс андэ кавчеги, ");
INSERT INTO rmn_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","тай мукляс э карга, тай одоя урялас тай авэлас палэ джи одолэ вахытески, бискай о пани опэр пху на шукило. ");
INSERT INTO rmn_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Дэчи о Ной мукляс голубес, тэ дикхел, гело о пани опрал пху. ");
INSERT INTO rmn_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ай о голуби на аракхляс шуко тхан тэ мукелпэс, тай ало ко Ной андэ кавчеги, вай о пани учярэлас алаи э пху. О Ной сидиняс по васт тай лиляс э голубес палэ пэстэ андэ кавчеги. ");
INSERT INTO rmn_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Накхло эфта дес, ов генэ мукляс э голубес андар кавчеги. ");
INSERT INTO rmn_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Кана бэлвэле о голуби ало, андэ муй лэстэ сас чинди зэлэно маслинаки патри. Дэчи о Ной галило, кай о пани гело опрал пху. ");
INSERT INTO rmn_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ов ишанды генэ эфта дес тай генэ мукляс э голубес, тай акана о голуби на ало палэ. ");
INSERT INTO rmn_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Кана сас э Ноески шовшэл екх брэш, андэ екхто дес ки екхе чёнэско лэски бэшымаско э пху шукили катар пани. О Ной пхутэрдяс опрал о кавчеги, ваздиняспэс тай дикхляс, кай э пху шуки. ");
INSERT INTO rmn_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ко биш эфтато дес ки дуйто чёнэско э пху ули алаи шуки. ");
INSERT INTO rmn_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Дэчи о Дэл пхэнляс э Ноески: ");
INSERT INTO rmn_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","— Никлё андар кавчеги ту, ти ромни, тэ чявэ тай лэнги ромня. ");
INSERT INTO rmn_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Никал аври алаи э дживиндэн, савэ туса: чириклен, гайванен тай алаен, кай балакадиен, он тэ пхэрэн э пху, тэ аракхлён лэндэ генэ тай тэ бутён. ");
INSERT INTO rmn_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Тай о Ной никлисто андар кавчеги екхетханэ пэ чявэнца, пэ ромняса тай пэ чявэнги ромнянца. ");
INSERT INTO rmn_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Алаи о гайваня, тай кай балакадиен, тай алаи о чирикля — алаи, со кхелавэлпэс опэр пху, — никлистэ андар кавчеги, екх порода пал екхаврэстэ. ");
INSERT INTO rmn_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","О Ной кердяс э Яхвэ Сагбуски алтари, лиляс шужэ гайванен тай чириклен андар кажни порода, чиндяс лэн тай алаи тхардяс опэр яг. ");
INSERT INTO rmn_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","О Сагбус о Яхвэ шунляс лачё кхандэл тай пхэнляс андэ Пэ илэстэ: — На кан дав генэ Мэ арманя э пху андар мануш. Тикнярила о ило э манушэско сидэлпэс ко канлыки, ай генэ на кан мударав алаи о дживиндо, сар кердём анкха. ");
INSERT INTO rmn_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Бискай си э пху, на кан бытиел о вахыти, кана о мануша барярэн тай кидэн о гив, кана овэл о шудрипэ тай тхарипэ, о милай тай о вэн, о дес тай э рат. ");
INSERT INTO rmn_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","О Дэл алгышты э Ноес тай лэски чявэн тай пхэнляс лэнги: — Мэ аракхлён пуя тай бутён, пхэрэн э пху. ");
INSERT INTO rmn_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Мэ лэл траш тай израипэ ангал тумэндэ алаи э гайванен э пхуякерэн тай алаи э чириклен э булутенгерэн, алаи, кай балакадиен, тай алаи э моряки мачен: он динэ тумэндэ андэ васта. ");
INSERT INTO rmn_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Алаи, со бэшэл тай со кхелавэлпэс, кан овэл тумэнги хапэ. Сар буруни Мэ динём тумэн зэлэниматэс, аякха ли анкха Мэ дав тумэн алаи. ");
INSERT INTO rmn_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Ами ма хан мас ратэса, саво си о бэшыпэ э гайваненго. ");
INSERT INTO rmn_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Тай андар тумаро рат Мэ чяльти кан мангав покиндима. Мэ кан мангав покиндима андар лэстэ кажни гайванестэ. Тай кажни манушэстэ Мэ кан пхучяв андар бэшыпэ лэски тухуместэ. ");
INSERT INTO rmn_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Кон би тэ на чёрэл рат манушэско, манушэски вастэса кан чёрдёл ли лэско рат. Вай о мануш кердо, сар о шавлин э Дэвлэско. ");
INSERT INTO rmn_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Мэ аракхлён пуя тай бутён, пхэрэн э пху тай бутён опэр латэ. ");
INSERT INTO rmn_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","О Дэл пхэнляс э Ноески тай лэски чявэнги: ");
INSERT INTO rmn_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","— Анкха Мэ керав завети тумэнца тай тумарэ пуенца, ");
INSERT INTO rmn_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","тай вэрсавэ дживиндимаса, саво си тумэнца: чирикли я, кхерутно гайвани я вэшэско гайвани — алаенца, кон никлисто тумэнца андар кавчеги, тай кажни гайванеса опэр пху. ");
INSERT INTO rmn_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Мэ керав тумэнца завети: на кан овэл генэ алаи о дживиндо мудардо бугулдимаски паненца, на кан овэл генэ о бугулдима тэ хурдярэл э пху. ");
INSERT INTO rmn_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","О Дэл пхэнляс: — Аки о сикаипэ э заветеско, саво Мэ керав машкарэ Мандэ тай тумэндэ тай алаи ко дживиндэ, савэ си тумэнца, алаи о породэс, савэ кан овэн. ");
INSERT INTO rmn_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Мэ тхав опрэ булутя Ми радуга, тай ой кан овэл сикаипэ э заветеско машкарэ Мандэ тай ки пху. ");
INSERT INTO rmn_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Кана би Мэ тэ на бичялав булутя опэр пху, андэ булутя кан овэл радуга, ");
INSERT INTO rmn_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","тай Мэ кан тюшундияв Мо завети машкарэ Мандэ тай тумэндэ тай алаи ко дживиндэ. Генэ о паня на кан чёрдён бугулдимаса, тэ мударэл алаи о дживиндо. ");
INSERT INTO rmn_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Екхараи, кана э радуга кан овэл андэ булутя, Мэ кан дикхав ла тай кан тюшундияв, кай на бытиел о завети машкарэ ко Дэл тай алаи ко дживиндэ, савэ си опэр пху. ");
INSERT INTO rmn_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Аякха пхэнляс о Дэл э Ноески: — Аки о сикаипэ э заветеско, саво Мэ кердём машкарэ Мандэ тай алаи, ко дживиндо опэр пху. ");
INSERT INTO rmn_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","О чявэ э Ноески, кай никлистэ андар кавчеги, сас о Сим, о Хам тай о Яфет. (О Хам — о дад э Ханаанеско.) ");
INSERT INTO rmn_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Адала трин чявэ э Ноески, тай лэндар улэ мануша, савэ бутилэ опэр алаи ки пху. ");
INSERT INTO rmn_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","О Ной лиляс тэ гортярэл э пху тай тэ барярэл дракх. ");
INSERT INTO rmn_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Екхвар ов пиляс винас, матило тай сас пашло нанго андэ пэ катунатэ. ");
INSERT INTO rmn_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","О Хам, о дад э Ханаанеско, дикхляс о нангипэ пэ дадэско тай никлисто, пхукавдяс адалэстар пэ пхралэнги. ");
INSERT INTO rmn_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Ай о Сим тай о Яфет лилэ савутя, тхэдэ лэн опэр пумарэ пхикендэ тай чёриндос динэ андэ тай учярдэ о нангипэ пумарэ дадэско. Лэнги муя сас болдинэ авэр риг, тэ на дикхен о нангипэ пумарэ дадэско. ");
INSERT INTO rmn_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Кана о Ной аинды тай галило, со кердяс лэса о тикно чяво. ");
INSERT INTO rmn_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Ов пхэнляс: — О Ханаан дино арман! Ов кан овэл пэ пхралэнги палуно андар иргатя. ");
INSERT INTO rmn_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Генэ ов пхэнляс: — Алгыштимэ о Сагбус о Яхвэ, о Дэл э Симеско! Мэ овэл о Ханаан иргати э Симеско. ");
INSERT INTO rmn_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Мэ буглярэл о Дэл э пху э Яфетески, мэ бэшэл о Яфет андэ катунэс ки Симески. Тай мэ овэл о Ханаан лэнги иргати. ");
INSERT INTO rmn_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Пал ко бугулдима о Ной бэшло 350 брэш. ");
INSERT INTO rmn_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Алаи о Ной бэшло 950 брэш тай муло. ");
INSERT INTO rmn_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Аки о пхукаипэ катар Сим, Хам тай Яфет, э Ноески чявэнго, савэндэ пал ко бугулдима аракхлилэ чявэ. ");
INSERT INTO rmn_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","О чявэ э Яфетескерэ: о Гомер, о Магог, о Мадай, о Яван, о Тувал, о Мешэх тай о Тирас. ");
INSERT INTO rmn_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","О чявэ э Гомерески: о Ашкеназ, о Рифат тай о Тогарма. ");
INSERT INTO rmn_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","О чявэ э Яванески: о Элиша, о Таршыш, о Киттим тай о Роданим. ");
INSERT INTO rmn_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Лэндар улэ паш ки моря о дюнядэс тай пхэрдилэ опэр пумарэ пхуя, машкарэ пумарэ дюнядэндэ; кажнестэ лэски чиб тай лэски порода. ");
INSERT INTO rmn_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","О чявэ э Хамески: о Куш, о Мицраим, о Пут тай о Ханаан. ");
INSERT INTO rmn_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","О чявэ э Кушэски: о Сева, о Хавила, о Савта, о Раама тай о Савтеха. О чявэ э Раамаски: о Шэва тай о Дедан. ");
INSERT INTO rmn_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","О Куш сас о дад ли э Нимродеско, саво уло о баштутно опэр пху зорало муршари. ");
INSERT INTO rmn_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ов сас баро астардимари э гайваненго ангал Сагбус Яхвэ, оничин пхэнлёлпэс: «Баро астардимари ангал Сагбус Яхвэ, сар о Нимрод». ");
INSERT INTO rmn_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","О баштутнэ диза андэ лэски патишайлыкестэ сас о Вавилон, Эрех, Аккад тай о Халне андэ пху Шынар. ");
INSERT INTO rmn_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Андар одолэ пхуятэ ов накхло андэ пху Ашшур, катэ тхэдяс э Ниневия, Реховот-Ир, Калах ");
INSERT INTO rmn_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","тай Ресен, машкарэ ки Ниневия тай ки бари диз Калах. ");
INSERT INTO rmn_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","О Мицраим сас о дад э лудеенго, анамеенго, легавеенго, нафтухеенго, ");
INSERT INTO rmn_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","патрусеенго, каслухеенго (савэндар улэ о филистимляня), тай кафтореенго. ");
INSERT INTO rmn_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","О Ханаан сас о дад э Сидонеско, о баштутно лэско, о Хет, ");
INSERT INTO rmn_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","ай генэ евусеенго, амореенго, гергашэенго, ");
INSERT INTO rmn_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","хивеенго, аркеенго, синеенго, ");
INSERT INTO rmn_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","арвадеенго, цэмареенго тай хаматеенго. Дэчи э Ханаанески порода паляштыпэс, ");
INSERT INTO rmn_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","тай о четя э Ханаанески сас катар Сидон ко Герар джи ки Газа, ай отхар ко Садом, Гамора, Адма тай Цэвоим джи ко Лаша. ");
INSERT INTO rmn_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Асавке улэ катар Хам дюнядэс андэ пумарэ породэс, пумарэ чибаса, андэ пумарэ пхуя. ");
INSERT INTO rmn_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Аракхлилэ чявэ ли ко Сим, ко баро пхрал ки Яфетеско. О Сим сас о дад алаи э Эверески чявэнго. ");
INSERT INTO rmn_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","О чявэ э Симески: о Элам, о Ашшур, о Арпахшад, о Луд тай о Арам. ");
INSERT INTO rmn_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","О чявэ э Арамески: о Уц, о Хул, о Гетер тай о Мешэх. ");
INSERT INTO rmn_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Ко Арпахшад аракхлило о Шэлах, ай ко Шэлах аракхлило о Эвер. ");
INSERT INTO rmn_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ко Эвер аракхлилэ дуй чявэ: о екх бучёлас Пелег (вай андэ лэски десендэ э пху сас палящимэ), ай лэски пхралэс — Ёктан. ");
INSERT INTO rmn_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","О Ёктан сас о дад э Алмодадеско, Шалефеско, Хацармаветеско, Ерахеско, ");
INSERT INTO rmn_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Гадорамеско, Узалеско, Дикласко, ");
INSERT INTO rmn_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Овалеско, Авимаилеско, Шэваско, ");
INSERT INTO rmn_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Офиреско, Хавиласко тай Ёвавеско. Алаи он сас о чявэ э Ёктанески. ");
INSERT INTO rmn_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Э область, катэ он бэшэнас, сас катар Меша джи ки Сефар андэ васточня горадэс. ");
INSERT INTO rmn_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Асавке улэ катар Сим дюнядэс андэ пумарэ породэс, пумарэ чибаса, андэ пумарэ пхуя. ");
INSERT INTO rmn_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Асавке породэс э Ноески чявэнги, лэнги породэндар андэ лэнги дюнядэс. Лэндар пал ко бугулдима улэ алаи о дюнядэс опэр пху. ");
INSERT INTO rmn_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Андэ алаи ко дюняс сас екх чиб тай екх зборэс. ");
INSERT INTO rmn_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","О мануша джянас ко вастоки тай никлистэ опэр шужы ливади андэ Шынари тай ачилэ тэ бэшэн отхэ. ");
INSERT INTO rmn_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Он пхэнлэ екхаврэски: — Элан керас кирпичя катар глина тай тэ тхарас лэн лачес. Аякха о мануша ки барэнго тхан тхэнас кирпичя, савэ он колискерэнас смоласа. ");
INSERT INTO rmn_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Дэчи он пхэнлэ: — Элан тхас амэнги диз башняса джи ко булутя. Аякха амэ кан махтадияс амаро нав, тай на кан дуряс опэр алаи ки пху. ");
INSERT INTO rmn_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","О Сагбус о Яхвэ фулистино тэ дикхел карин диз тай башня, савэ тхэнас о чявэ э манушэнги, ");
INSERT INTO rmn_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","тай пхэнляс: — Алаи о мануша — екх дюняс, лэндэ екх чиб. Тай он токо лилэ тэ керэн алаи. Акана со тэ на манген, алаи кан керэн. ");
INSERT INTO rmn_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Элан фуляс тэ намискерас лэнги зборэс, тэ на галён екхаврэс. ");
INSERT INTO rmn_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Тай о Сагбус о Яхвэ дурярдяс лэн отхар опэр алаи ко муй ки пхуяко, тай он тэрдилэ тэ тхэн одоя диз. ");
INSERT INTO rmn_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Аки соски ов сас тхэдо Вавилон — вай о Сагбус о Яхвэ намискердяс отхэ о зборэс алаи э дюняски. Отхар о Сагбус о Яхвэ дурярдяс лэн опэр муй алаи ки пхуяко. ");
INSERT INTO rmn_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Аки о пхукаипэ катар Сим тай лэски пуендар. Э Симески сас шэл брэш, кана лэстэ аракхлило о Арпахшад. Адава уло до брэшэндар пал ко бугулдима. ");
INSERT INTO rmn_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Пал ко аракхлима ки Арпахшадеско о Сим бэшло 500 брэш, тай лэстэ сас генэ чявэ тай чяя. ");
INSERT INTO rmn_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Кана о Арпахшад бэшло 35 брэш, лэстэ аракхлило о Шэлах. ");
INSERT INTO rmn_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Пал ко аракхлима ки Шэлахеско о Арпахшад бэшло 403 брэш, тай лэстэ сас генэ чявэ тай чяя. ");
INSERT INTO rmn_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Кана о Шэлах бэшло 30 брэш, лэстэ аракхлило о Эвер. ");
INSERT INTO rmn_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Пал ко аракхлима ки Эвереско, о Шэлах бэшло 403 брэш, тай лэстэ сас генэ чявэ тай чяя. ");
INSERT INTO rmn_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Кана о Эвер бэшло 34 брэш, лэстэ аракхлило о Пелег. ");
INSERT INTO rmn_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Пал ко аракхлима ки Пелегеско о Эвер бэшло 430 брэш, тай лэстэ сас генэ чявэ тай чяя. ");
INSERT INTO rmn_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Кана о Пелег бэшло 30 брэш, лэстэ аракхлило о Реу. ");
INSERT INTO rmn_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Пал ко аракхлима ки Реуско о Пелег бэшло 209 брэш, тай лэстэ сас генэ чявэ тай чяя. ");
INSERT INTO rmn_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Кана о Реу бэшло 32 брэш, лэстэ аракхлило о Серуг. ");
INSERT INTO rmn_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Пал ко аракхлима ки Серугеско о Реу бэшло 207 брэш, тай лэстэ сас генэ чявэ тай чяя. ");
INSERT INTO rmn_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Кана о Серуг бэшло 30 брэш, лэстэ аракхлило о Нахор. ");
INSERT INTO rmn_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Пал ко аракхлима ки Нахореско о Серуг бэшло 200 брэш, тай лэстэ сас генэ чявэ тай чяя. ");
INSERT INTO rmn_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Кана о Нахор бэшло 29 брэш, лэстэ аракхлило о Терах. ");
INSERT INTO rmn_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Пал ко аракхлима ки Терахеско о Нахор бэшло 119 брэш, тай лэстэ сас генэ чявэ тай чяя. ");
INSERT INTO rmn_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Пал отхэ сар о Терах бэшло 70 брэш, лэстэ аракхлилэ о Аврам, о Нахор тай о Аран. ");
INSERT INTO rmn_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Аки о пхукаипэ катар Терах тай лэски пуендар. Ко Терах аракхлилэ о Аврам, о Нахор тай о Аран. Ко Аран аракхлило о Лот. ");
INSERT INTO rmn_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Кана лэско дад о Терах сас дага дживиндо, о Аран муло андэ диз Ур, катэ бэшэнас о халдея, андэ пху, кай ов аракхлило. ");
INSERT INTO rmn_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","О Аврам тай о Нахор лилэ пэски ромнян. Э ромни э Аврамески бучёлас Сара, ай э ромни э Нахорески — Милка. О Аран — о дад э Милкако тай э Искако. ");
INSERT INTO rmn_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Ки Сара на сас пуя, вай латэ нащи аракхлёнас пуя. ");
INSERT INTO rmn_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","О Терах лиляс пэ чявэс э Аврамес, пэ турунес э Лотес, э чявэс э Аранескерэс, тай пэ боря э Сара, э ромня э Аврамески, тай екхетханэ он гелэ андар Ур, катэ бэшэнас о халдея, андэ Ханаан. Тай алэ джи ко Харан, катэ ачилэ тэ бэшэн. ");
INSERT INTO rmn_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","О Терах бэшэлас 205 брэш тай муло андэ Харан. ");
INSERT INTO rmn_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","О Сагбус о Яхвэ пхэнляс э Аврамески: — Ачяв ти пху, то дюняс тай тэ дадэско кхер тай джя ки пху, сави Мэ туки кан сикавав. ");
INSERT INTO rmn_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Мэ кан керав тутар баро дюняс, кан алгыштияв тут тай кан керав намлыс то нав. Ту аврэнги кан овэс бахт! ");
INSERT INTO rmn_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Мэ кан дав лачипэ одолэн, кон мангел туки лачипэ, тай кан дав арманя одолэс, кон дэл арманя тут. Булуб туки кан диндён бахт алаи о дюнядэс опэр пху. ");
INSERT INTO rmn_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Тай о Аврам гело ко дром, сар пхэнляс лэски о Сагбус о Яхвэ, тай о Лот гело екхетханэ лэса. Кана ов гело андар Харан, э Аврамески сас 75 брэш. ");
INSERT INTO rmn_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Ов лиляс пэса пэ ромня э Сара, пэ пхралэски чявэс э Лотес, алаи о мангин, саво он кидинэ, тай э манушэн, савэ лэндэ сас андэ Харан. Он гелэ андэ Ханаан тай ало отхэ. ");
INSERT INTO rmn_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","О Аврам накхло опэр адалэ пхуятэ джи одолэ тханэстэ андэ Шэхем, катэ сас тэрдо о тэрэки тэрэбинт, саво бучёлас Морэ. Одова вахыти отхэ бэшэнас о ханаанея. ");
INSERT INTO rmn_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","О Сагбус о Яхвэ сикавдяспэс э Аврамески тай пхэнляс: — Мэ кан дав адая пху тэ пуен. О Аврам кердяс отхэ алтари э Сагбуски э Яхвэски, Саво сикавдяспэс лэски. ");
INSERT INTO rmn_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Отхар ов гело андэ горадэнго тхан ко вастоки катар Вефиль. Тай тхэдяс пи катуна аякха, кай сас о Вефиль карин запад, ай о Гай — карин вастоки. Отхэ ов кердяс алтари э Сагбуски э Яхвэски тай мангляс Лэско нав. ");
INSERT INTO rmn_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Дэчи о Аврам гело катар тхан тай гело дром ко юги, ко Негев. ");
INSERT INTO rmn_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Опэр пху сас бокх, бут бари, тай о Аврам накхло ко Египти. ");
INSERT INTO rmn_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Кана он пашонас ко Египти, ов пхэнляс пэ ромняки э Сараки: — Алаи кан дикхен, кай ту шукар джювли. ");
INSERT INTO rmn_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Кана о египтяня кан дикхен тут, он кан тюшундиен: «Адая лэски ромни», — тай кан мударэн ман, ай тут кан ачявэн дживиндя. ");
INSERT INTO rmn_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Пхэн, кай сан ми пхэн. Дэчи булуб туки манца кан овэн лаче, тай кан ачяв дживиндо. ");
INSERT INTO rmn_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Кана о Аврам ало андэ Египти, о египтяня дикхлэ, кай э Сара бут шукар. ");
INSERT INTO rmn_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ай кана ла дикхлэ о князя э фараонески, он махтадылар ла э фараонески, тай э Сара лилэ лэстэ андэ патишайлытико кхер. ");
INSERT INTO rmn_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Ов кердяс лачипэ э Аврамески булуб э Сараки. Ко Аврам сас бузнэ, бакрэ, гурува, джёрэ тай джёря, иргатя тай иргатинкес, тай камилэс. ");
INSERT INTO rmn_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ай о Сагбус о Яхвэ бичялдяс джюнгалэ насвалиматэс опэр фараони тай алаи опэр лэски кхерутнэндэ, андар одолэстэ кай ов лиляс э Сара, э Аврамески ромня, андэ пэ кхерэстэ. ");
INSERT INTO rmn_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Дэчи о фараони диняс икос э Аврамес тай пхучляс: — Со кердян манца? Соски ту на пхэнлян манги, кай ой — ти ромни? ");
INSERT INTO rmn_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Соски ту пхэнлян, кай ой ти пхэн? Екх андар адалэстэ мэ манглём тэ лав ла. Аки ти ромни, лэла тай джя атхар! ");
INSERT INTO rmn_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","О фараони пхэнляс пэ манушэнги тэ кувдиен э Аврамес отхар екхетханэ э ромняса тай алаеса, со сас лэстэ. ");
INSERT INTO rmn_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","О Аврам пэ ромняса тай алаи э мангинэса гело андар Египти андэ Негев, тай о Лот гело лэса. ");
INSERT INTO rmn_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Ко Аврам акана сас бут гайваня, руп тай пхол. ");
INSERT INTO rmn_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Андар Негев ов гело англэ дром, бискай на ало андэ Вефиль, одолэ тханэстэ, катэ буруни тэрди лэски катуна, машкарэ ко Вефиль тай Гай, ");
INSERT INTO rmn_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","одолэ тханэстэ, катэ ов кердяс алтари. Отхэ о Аврам мангляс о нав э Сагбуско э Яхвэско. ");
INSERT INTO rmn_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Ли ко Лоти, саво ладэлас э Аврамеса, сас бузнэ, бакрэ, гурувня тай катунэс. ");
INSERT INTO rmn_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Тай э пху на рэсэлас лэнги э донги: лэндэ сас аякха бут алаи, кай он нащи бэшэнас екхетханэ. ");
INSERT INTO rmn_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Машкарэ ко чёбаня ки Аврамески тай ко чёбаня ки Лотески ули чингар. Озаман андэ одолэ пхуятэ бэшэнас о ханаанея тай о периззея. ");
INSERT INTO rmn_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Дэчи о Аврам пхэнляс э Лотески: — На камэл амэнги тай амарэ чёбаненги чингар, вай амэ тухумя. ");
INSERT INTO rmn_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Дикх! Алаи э пху ангал тутэ. Эла ту тэ джяса ки леви рик, мэ кан джяв ки прави рик, ай ту тэ джяса ки прави рик, дэчи мэ кан джяв ки леви рик. ");
INSERT INTO rmn_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","О Лот варды тай дикхляс, кай алаи э Иордански ливади джи ко Цоар лачес суслелас, сар сади э Сагбуско э Яхвэско, сар э пху египтески. Адава дага сас ангал, сар о Сагбус о Яхвэ хурдярдяс о Садом тай э Гомора. ");
INSERT INTO rmn_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","О Лот лиляс пэски алаи э ливади э Иордански тай гело ко вастоки. Он паляштыларпэс: ");
INSERT INTO rmn_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","о Аврам бэшэлас андэ пху ханаанеенги, ай о Лот бэшэлас машкарэ ко диза ки ливадякерэ, тхэдяс катунэс надур катар Садом. ");
INSERT INTO rmn_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","О мануша э Садомески сас нашужэ тай бут бэзялэ ангал ко Сагбус ко Яхвэ. ");
INSERT INTO rmn_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","О Сагбус о Яхвэ пхэнляс э Аврамески пал отхэ, сар о Лот паляштыпэс лэстар: — Дикх анкха агорял тутэ. Дикх карин север тай карин юги, карин вастоки тай карин запад. ");
INSERT INTO rmn_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Алаи э пху, сави ту дикхес, Мэ кан дав тут тай тэ пуен алаи э вахытески. ");
INSERT INTO rmn_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Мэ кан керав тэ пуен бут, сар кишай, тай кон кан гинэл э кишай, дэчи тэ пуя кан овэн гиндэ. ");
INSERT INTO rmn_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Джя, пхер опэр адалэ пхуятэ дулгимаса тай буглимаса, вай Мэ кан дав ла тутэ. ");
INSERT INTO rmn_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","О Аврам кидиняс о катунэс тай гело тэ бэшэл надур катар тэрэкя тэрэбинтя вэш Мамрэ андэ Хеврон. Ов тхэдяс отхэ алтари э Сагбуски э Яхвэски. ");
INSERT INTO rmn_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Одова вахыти о Амрафел, о патишаи э Шынареско, о Ариох, о патишаи э Элласареско, о Кедорлаомер, о патишаи э Эламеско, тай о Тидал, о патишаи э Гоимеско, ");
INSERT INTO rmn_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","екхетханэ гелэ маримаса опэр Бэра, ко патишаи ки Садомеско, опэр Бирша, ко патишаи ки Гаморако, опэр Шынав, ко патишаи ки Адмако, опэр Шэмевер, ко патишаи ки Цэвоимеско, тай опэр патишаи ки Бэлако (самким Цоар). ");
INSERT INTO rmn_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Адала патишая тхэдэ екхетханэ пумари зор андэ ливади Сиддим (катэ акана Лонди моря). ");
INSERT INTO rmn_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Дэшудуй брэш он э сас тал зор ки Кедорлаомерески, ай ко дэшутрито брэш ваздиндилэ. ");
INSERT INTO rmn_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Андэ дэшуштарто брэш о Кедорлаомер тай екхетханэ лэса о патишая никлистэ тай мудардэ э рефаимеен андэ Аштерот-Карнаим, э зузеен андэ Гам, э эмеен андэ Шавэ-Кирьятаим ");
INSERT INTO rmn_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","тай э хореен опэр горадэс Сеир, опэр дром андэ Эл-Паран, ко чети ки ливадяко. ");
INSERT INTO rmn_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Отхар он болдинэ палэ тай алэ ко Эн-Мишпат (самким ки Кадэш) тай лилэ алай э пху э амалекитяненги, тай аякха ли э амореенги, савэ бэшэнас андэ Хацацон-Тамар. ");
INSERT INTO rmn_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Мамуй лэндэ тэрдилэ о патишаи э Садомеско, о патишаи э Гаморако, о патишаи э Адмако, о патишаи э Цэвоимеско тай о патишаи э Бэлако (самким Цоар). Андэ ливади Сиддим он лилэ тэ марэнпэс ");
INSERT INTO rmn_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","мамуй ко Кедорлаомер, патишаи э Эламеско, ко Тидал, патишаи э Гоимеско, ко Амрафел, патишаи э Шынареско, тай ко Ариох, патишаи э Элласареско, — штар патишая мамуй панджендэ. ");
INSERT INTO rmn_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Андэ ливади Сиддим сас бут холя смоласки. Кана о патишая Садомеско тай Гаморако лилэ тэ нашэн, о бут пэлэ андэ холя, ай авэра нашлэ андэ горадэс. ");
INSERT INTO rmn_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Штар патишая лилэ алаи о мангин э Садомеско тай э Гаморако тай алаи лэнго хапэ тай гелэ. ");
INSERT INTO rmn_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Он лилэ ли э Лотес, э Аврамески пхралэски чявэс, саво бэшэлас андэ Садом, тай алаи лэско мангин. ");
INSERT INTO rmn_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Екх андар одолэндэ, кон кутардыпэс, ало тай пхукавдяс адалэстар э евреески э Аврамески. О Аврам бэшэлас надур катар тэрэкя тэрэбинтя, савэ сас э амореески э Мамрэски. О Эшкол тай о Анэр сас пхрала лэса. О Аврам тай он сас амала. ");
INSERT INTO rmn_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Кана о Аврам шунляс, кай лэско тухуми астардо, ов кидиняс тришэл дэшуохто муршэн, савэ аракхлилэ андэ лэски кхерэстэ, тай галёнас лачес тэ марэнпэс. Он прастанилэ пал ко штар патишая тай джянас пал лэндэ джи ко Дан. ");
INSERT INTO rmn_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","О Аврам паляшты пэ иргатен, рати пэло опэр лэндэ. Он лилэ тэ нашэн, ай о Аврам джялас пал лэндэ джи ки Хова, ко север катар Дамаск. ");
INSERT INTO rmn_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ов лиляс палэ алаи о мангин э душманенго. Тай генэ лиляс пэски пэ тухумес э Лотес, лэско мангин, э джювлен тай э манушэн. ");
INSERT INTO rmn_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Кана о Аврам мардяс э Кедорлаомерес тай э патишаен, савэ сас лэса, ов лиляс тэ джял кхерэ. Дэчи о патишаи э Садомеско никлисто тэ дикхел лэс ки ливади Шаве (самким Патишайлытико ливади). ");
INSERT INTO rmn_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","О Мелхисэдэк, о патишаи э Салимеско, никалдяс манро тай винас. Ов сас попази э Уче Дэвлэско. Ов алгышты э Аврамес акасавке зборэнца: ");
INSERT INTO rmn_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","— О Учё Дэл, саво кердяс о булутя тай э пху, мэ алгыштиел э Аврамес! ");
INSERT INTO rmn_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Тай махтадипэ э Уче Дэвлэски, саво диняс тэ марэс тэ душманен. О Аврам диняс лэс алаестар дэшто паи. ");
INSERT INTO rmn_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","О патишаи э Садомеско пхэнляс э Аврамески: — Дэ мандэ мэ манушэн, ай о мангин ачяв туки. ");
INSERT INTO rmn_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ай о Аврам пхэнляс э Садомески патишаески: — Мэ ваздинём мо васт ко Сагбус ко Яхвэ, ко Учё Дэл, Саво кердяс о булутя тай э пху, тай динём збора, ");
INSERT INTO rmn_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","кай на кан лав тутар джи тхав я кустик катар минис, на кан лав ништо тинро, ту тэ на пхэнэс: «Мэ барвалякердём э Аврамес». ");
INSERT INTO rmn_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Мэ кан лав екх одова, со халэ мэ мануша. Ай кон гело манца — о Анэр, о Эшкол тай о Мамрэ — мэ лэн по паи. ");
INSERT INTO rmn_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Пал атхэ о Сагбус о Яхвэ сикавдяспэс э Аврамески тай пхэнляс: — Ма траша, Аврам. Мэ — то кутардима. То башладима кан овэл бут баро. ");
INSERT INTO rmn_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ай о Аврам пхэнляс: — Вай, Сагбус Яхвэ, со Ту кан дэс ман? Вай мэ ачяв би пуенго, тай мо мангин кан диндёл ко Элиезер андар Дамаск. ");
INSERT INTO rmn_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","О Аврам генэ пхэнляс: — Ту на динян ман пуен, тай о иргати, кай аракхлило андэ мэ кхерэстэ, кан лэл мо мангин. ");
INSERT INTO rmn_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Тай сас лэски збора э Сагбуски э Яхвэски: — Ов на кан лэл. Кан лэл одова, саво кан овэл тутар. ");
INSERT INTO rmn_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Ов никалдяс лэс аври тай пхэнляс: — Дикх карин булутя тай гин о чергэня. Ту кан гинэс лэн? — Тай пхэнляс лэски: — Аборкха кан овэн тутэ пуя. ");
INSERT INTO rmn_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","О Аврам пакянило э Сагбуски э Яхвэски, тай Ов гиндяс лэс чячес. ");
INSERT INTO rmn_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Генэ Ов пхэнляс лэски: — Мэ — о Сагбус о Яхвэ, Саво никалдяс тут андар Ур ки халдеенго, тэ дэл тут адая пху. ");
INSERT INTO rmn_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ай о Аврам пхучляс: — Вай, Сагбус Яхвэ, сар мэ тэ галяв, кай ой кан овэл минри? ");
INSERT INTO rmn_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","О Сагбус о Яхвэ пхэнляс лэски: — Ан Манги тринэ брэшэнги гурувня, тринэ брэшэнги бузня тай тринэ брэшэнги бакрэс, тай генэ ан голубка тай тэрнэ голубес. ");
INSERT INTO rmn_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","О Аврам аякха ли кердяс. Ов чиндяс лэн дуй котора тай тхэдяс о котора о екх мамуй аврэстэ. Ай э чириклен ов на чиндяс дуй котора. ");
INSERT INTO rmn_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","О барэ канлыдэс чирикля кидэнаспэс опэр мулэ тэня, ай о Аврам кувдиелас лэн. ");
INSERT INTO rmn_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Сар бэшло о кхам, э Аврамес лиляс зорало суно. Атхэ вэркатэ фулистини кали тэмина, тай бари траш лиляс лэс. ");
INSERT INTO rmn_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","О Сагбус о Яхвэ пхэнляс лэски: — Тэ джянэс, кай тэ пуя кан овэн джятя андэ джяти пху; лэн кан керэн иргатен тай кан тасавэн штаршэл брэш. ");
INSERT INTO rmn_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ай Мэ кан тасавав о дюняс, саво кердяс лэн иргатен, тай дэчи он кан никлён отхар барэ мангинэса. ");
INSERT INTO rmn_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ту бут пхуро кан мэрэс андэ рагати тай кан овэс тэ дадэндэ. ");
INSERT INTO rmn_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Атхэ кан авэл о штарто роди тэ породако, вай дага о бэзя э амореенги на улэ джи ко чети. ");
INSERT INTO rmn_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Кана о кхам бэшло тай уло тэмина, бирдэн ули бари яг тай какаи ангарэнца, андар савятэ ваздиндёлас тхув. Он накхлэ машкарэ ко чиндэ котора. ");
INSERT INTO rmn_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Андэ одова дес о Сагбус о Яхвэ кердяс завети э Аврамеса тай пхэнляс: — Мэ дав тэ пуен адая пху, катар египтески диряв джи ки бари диряв Евфрат: ");
INSERT INTO rmn_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","э пху э кенеенги, кенезеенги, кадмонеенги, ");
INSERT INTO rmn_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","хетеенги, периззеенги, рефаимеенги, ");
INSERT INTO rmn_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","амореенги, ханаанеенги, гиргашэенги тай евусеенги. ");
INSERT INTO rmn_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Ки Сара, ки ромни ки Аврамески, на аракхлёнас пуя лэски. Латэ сас иргатинка андар Египти, ой бучёлас Агарь. ");
INSERT INTO rmn_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Э Сара пхэнляс э Аврамески: — О Сагбус о Яхвэ на диняс ман пуен. Джя, пашлё мэ иргатинкаса. Файма, латар мандэ кан овэн пуя? О Аврам кердяс, сар пхэнляс э Сара. ");
INSERT INTO rmn_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Э Сара, лэски ромни, лиляс пэ иргатинка, э египтянка э Агаря, тай диняс сар ромня пэ ромэстэ. Адава кана уло, о Аврам бэшэлас андэ Ханаан дэш брэш. ");
INSERT INTO rmn_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ов пашлило э Агаряса, тай ой насвалили пуёстэ. Кана э Агарь галили, кай насвали пуёстэ, ой лиляс тэ на гинэл пэ сагбуиса. ");
INSERT INTO rmn_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Дэчи э Сара пхэнляс э Аврамески: — Ой кай керэл манги хурлуки, ту сан дошало. Мэ динём э иргатинка тутэ опэр тхан, ай акана ой джянэл, кай насвали пуёстэ, тай на гинэл ман. Мэ керэл о Сагбус о Яхвэ амэнги цындос. ");
INSERT INTO rmn_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","— Вай ой ти иргатинка. Кер ласа, со мангес, — пхэнляс о Аврам. Дэчи э Сара лиляс аякха тэ тасавэл э Агаря, кай одоя нашли латар. ");
INSERT INTO rmn_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","О Миляики э Сагбуско э Яхвэско аракхляс э Агаря андэ ливади, надур катар ханинг. Адая ханинг сас паш ко дром ко Шур. ");
INSERT INTO rmn_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ов пхучляс: — Агарь, иргатинка э Сараки, катар ту алян тай кай джяс? — Мэ нашав мэ сагбуисатар катар Сара, — пхэнляс ой. ");
INSERT INTO rmn_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Дэчи о Миляики э Сагбуско э Яхвэско пхэнляс лаки: — Джя палэ тэ сагбуисатэ тай шун ла. ");
INSERT INTO rmn_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Генэ о Миляики э Сагбуско э Яхвэско пхэнляс лаки: — Мэ аякха бут кан керав тэ пуен, кай лэн нащи кан гинэс. ");
INSERT INTO rmn_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Генэ о Миляики э Сагбуско э Яхвэско пхэнляс лаки: — Ту акана насвали пуёстэ, тай кан аракхлёл тутэ чяво. Тхэ лэс Измаил, оничин о Сагбус о Яхвэ шунляс тэ хурлукестар. ");
INSERT INTO rmn_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ов кан овэл, сар вэшэско джёро; лэски васта кан овэн мамуй алаендэ, тай о васта алаенги кан овэн мамуй лэстэ, ов кан бэшэл андэ душманлыки алаи пэ пхралэнца. ");
INSERT INTO rmn_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Э Сагбуски э Яхвэски, Саво зборизэлас ласа, Агарь диняс нав Эль-Рои, вай ой пхэнляс: — Анкха мэ дикхлём Одолэс, Кон дикхел ман. ");
INSERT INTO rmn_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Аки соски одоя ханинг бучёлас Бээр-Лахай-Рои. Ой ли анкха отхэ, машкарэ ко Кадэш тай ко Беред. ");
INSERT INTO rmn_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Ки Агарь аракхлило чяво э Аврамески, тай ов тхэдяс пэ чявэс Измаил. ");
INSERT INTO rmn_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Э Аврамески сас охтодэша шов брэш, кана лэско чяво о Измаил аракхлило ки Агарь. ");
INSERT INTO rmn_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Кана э Аврамески сас энядэша эня брэш, о Сагбус о Яхвэ сикавдяспэс лэски тай пхэнляс: — Мэ — о Дэл о Баро-Зорало. Пхер ангал Мандэ тай ов чячё. ");
INSERT INTO rmn_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Мэ дав тут Мо завети тай кан дав тут бут-бут пуен. ");
INSERT INTO rmn_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","О Аврам бангило моса джи ки пху, тай о Дэл пхэнляс лэски: ");
INSERT INTO rmn_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","— Мэ ригатар, аки туки Мо завети: ту кан овэс о дад бутэ дюнядэнго. ");
INSERT INTO rmn_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Адалэ вахытестар туки на кан пхэнэн Аврам, то нав кан овэл Авраам, вай Мэ кердём тут о дад бутэ дюнядэнго. ");
INSERT INTO rmn_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Тутэ кан овэн бут пуя. Мэ кан керав тутар дюнядэс, тай тутар кан овэн патишая. ");
INSERT INTO rmn_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Мэ дав тут завети тай адава завети аякхажэ кан овэл алаи тэ пуенго алаи о вахытя: Мэ кан овав то Дэл тай о Дэл тэ пуенго. ");
INSERT INTO rmn_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Алаи э пху Ханаан, катэ ту анкха джяти, Мэ кан дав тутэ тай тэ пуендэ, тай ой кан овэл сальтя тинри. Тай Мэ кан овав лэнго Дэл. ");
INSERT INTO rmn_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","О Дэл пхэнляс э Авраамески: — Тэ ригатар, ту тай тэ пуя, кай кан овэн пал тутэ, алаи о вахыти камэл тэ керэс Мо завети. ");
INSERT INTO rmn_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Аки Мо завети туса тай тэ пуенца пал тутэ, саво камэл ту тэ керэс: кажын мурш мэ овэл абрезани. ");
INSERT INTO rmn_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Кажнески камэл тэ овэл кердо абрезания, тай адава кан овэл завети машкарэ Мандэ тай тумэндэ. ");
INSERT INTO rmn_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Кажын тумаро пуёс мурш камэл тэ овэл абрезани, кана лэски кан овэл охто дес; аякха камэл тэ керэн алаи о породэс. Тай одова, кон аракхлило андэ тэ кхерэстэ, тай одова, кон нанай андар тэ породатэ, ами киндо ловэнги джятендэ. ");
INSERT INTO rmn_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Тай кай аракхлило андэ тэ кхерэстэ, тай киндо ловэнги камэл тэ овэл абрезани. Мо завети опэр тумарэ тэнестэ кан овэл завети сальтя. ");
INSERT INTO rmn_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Одова, кон на кан овэл абрезани, кан овэл кувдимэ андар пэ дюнястэ, вай пхагердяс Манца о завети. ");
INSERT INTO rmn_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Генэ о Дэл пхэнляс э Авраамески: — Ма пхэн тэ ромняки Сара, лако нав кан овэл Сарра. ");
INSERT INTO rmn_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Мэ кан алгыштияв ла тай кан дав тут латар чявэс. Мэ кан алгыштияв ла аякха, кай ой кан овэл э дай э дюнядэнги тай э патишаенги. ");
INSERT INTO rmn_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","О Авраам бангило моса джи ки пху, ай асанило тай тюшунды: «Кан аракхлёл чяво ко мануш, савэски шэл брэш? Кан аракхлел пуёс ки Сарра, савяки энядэша?» ");
INSERT INTO rmn_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Тай ов пхэнляс э Дэвлэски: — Хоч о Измаил тэ овэл дживиндо ангал Тэ мостэ! ");
INSERT INTO rmn_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","О Дэл пхэнляс: — Адава тэ ромнятэ ки Сарра кан аракхлёл чяво, тай ту кан тхэс лэс Исаак. Адава лэс Мэ кан дав Мо завети. Адава кан овэл сальтя завети лэски тай лэски пуенги. ");
INSERT INTO rmn_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ли катар Измаил Мэ шунлём тут. Мэ кан алгыштияв лэс тай кан дав бутэ пуен. Ов кан овэл о дад дэшудо сагбудэнго тай барэ дюняско. ");
INSERT INTO rmn_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ай Мо завети кан дав ко Исаак, саво ки Сарра кан аракхлёл туки адава вахыти окова брэш. ");
INSERT INTO rmn_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","О Дэл бытэрды тэ зборизэл э Авраамеса тай ваздиндило лэстар. ");
INSERT INTO rmn_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Одова жэ дес о Авраам лиляс пэ чявэс э Измаилес тай алаен, кон аракхлило андэ лэски кхерэстэ тай киндо рупунэ ловэнги, алаи э муршэн андэ кхер, тай абрезал лэн, сар пхэнляс лэски о Дэл. ");
INSERT INTO rmn_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Кана сас о Авраам абрезани, лэски сас энядэша эня брэш. ");
INSERT INTO rmn_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ай лэски чявэски э Измаилески сас дэшутрин. ");
INSERT INTO rmn_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","О Авраам тай лэско чяво о Измаил ли о дуй сас абрезаня андэ екх дес. ");
INSERT INTO rmn_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Тай алаи лэса о мурша андэ кхер ки Авраамеско, ли одова, саво аракхлило андэ лэски кхерэстэ я киндо ко джятя, сас абрезаня екхетханэ лэнца. ");
INSERT INTO rmn_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Десе, кана тхарэлас о кхам, паш ко тэрэкя тэрэбинтя Мамрэ, кана о Авраам сас бэшло ангал пэ катунатэ, лэски сикавдяспэс о Сагбус о Яхвэ. ");
INSERT INTO rmn_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","О Авраам ваздиняс пэ якха тай дикхляс ангал пэс тринэ муршэн. Ов дикхляс лэн, прастанило катар удар ки катунако мамуй лэндэ тай бангило джи ки пху. ");
INSERT INTO rmn_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Ов пхэнляс: — Сагбус! Ов мандэ миласа, ма накх пашал мандэ Тэ иргатестэ. ");
INSERT INTO rmn_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Мэ анэн залак пани, тай мэ халярэн тумарэ пинрэ, тай рагантиен тал адалэ тэрэкестэ. ");
INSERT INTO rmn_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Тэ алянус тумэ тумарэ иргатестэ, мэ кан анав тумэнги тэ хан, тумэ кан хан тай кан джян англэ тумаро дром . — Бут лачё, — пхэнлэ он. — Кер, сар пхэнэс. ");
INSERT INTO rmn_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","О Авраам сигярдяс ки Сарра андэ катуна тай пхэнляс: — Дэба, никал трин тапцыес лачё варо, кер хумэр тай пэк питэс. ");
INSERT INTO rmn_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Дэчи ов прастанило ки атара, лиляс э лаче тэрнорэ гуруворэс тай диняс ко иргати, саво чяльти пэкляс лэс. ");
INSERT INTO rmn_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Дэчи ов андяс тхуд тай сути, тхэдяс ангал лэндэ э гуруворэс тэ хан. Бискай он ханас, ов сас тэрдо паш лэндэ тал тэрэки. ");
INSERT INTO rmn_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","— Кай ти ромни э Сарра? — пхучлэ он. — Окотэ, андэ катуна, — пхэнляс ов. ");
INSERT INTO rmn_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Дэчи о Сагбус о Яхвэ пхэнляс: — Мэ чячес кан авав тутэ авэр брэш, паш адава жэ вахыти, тай ки Сарра, тэ ромнятэ, кан овэл чяво. Э Сарра шунэлас, тэрди пал лэски думэстэ, андэ катуна. ");
INSERT INTO rmn_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","О Авраам тай э Сарра сас пхурэ тай барэ брэшэнги, тай одова, со овэл ки джювли, ки Сарра тэрдило. ");
INSERT INTO rmn_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Оничин э Сарра асанили андар пэстэ, тюшунды: «Мэ вай пхурилём, тай мо сагбус пхуро. Мандэ тэ овэл асавки лош?» ");
INSERT INTO rmn_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Дэчи о Сагбус о Яхвэ пхэнляс э Авраамески: — Соски э Сарра асал тай пхэнэл: «Та со, мандэ пхурятэ чячес кан овэл пуёс?» ");
INSERT INTO rmn_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Си шо-то, со нащи керэл о Сагбус о Яхвэ? Мэ кан авав тутэ авэр брэш андэ вахыти, саво камэл, тай ки Сарра кан овэл чяво. ");
INSERT INTO rmn_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Э Сарра трашанили тай лиляс тэ лэл пэ зборэс палэ: — Мэ на асанилём. Ай Ов пхэнляс: — На, ту асанилян. ");
INSERT INTO rmn_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","О мурша ущинэ тай лилэ тэ джян карин Садом. О Авраам гелдяс лэн. ");
INSERT INTO rmn_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","О Сагбус о Яхвэ пхэнляс: — Мэ на кан гаравав катар Авраам, со мангав тэ керав. ");
INSERT INTO rmn_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Катар Авраам кан овэл баро тай зорало дюняс, тай булуб лэски кан диндён бахт алаи о дюнядэс опэр пху. ");
INSERT INTO rmn_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Вай Мэ тхэдём лэс, ов тэ пхэнэл пэ пуенги, савэ кан аракхлён, тэ пхерэн о дром э Сагбуски э Яхвэско, тэ керэн о чячипэ тай о цындос. Дэчи Мэ, о Сагбус о Яхвэ, кан керав одова, со пхэнлём э Авраамески. ");
INSERT INTO rmn_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","О Сагбус о Яхвэ пхэнляс: — Э бэбэря мамуй ко Садом тай ко Гамора асавки бари, отхэ о мануша керэн пхарэ бэзя. ");
INSERT INTO rmn_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Кай тэ фуляв тэ дикхав, алаи си отхэ дошалэ я на. Тэ на, Мэ кан галяв. ");
INSERT INTO rmn_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","О мурша болдинэпэс тай гелэ ко Садом, ай о Авраам ачило ангал Сагбус ко Яхвэ. ");
INSERT INTO rmn_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","О Авраам пашыло карин Лэстэ тай пхэнляс: — Ту со, кан мударэс э надошалэс э дошалэса? ");
INSERT INTO rmn_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Со, тэ си андэ диз пэинда надошалэ? Ту со, кан хурдярэс тай на кан ачявэс адая диз булуб пэинда надошалэнги? ");
INSERT INTO rmn_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Нащи Ту керэс асавко, тэ мударэс э надошалэн э дошалэса, нащи керэс э надошалэски тай э дошалэски екх. Нащи Ту керэс аякха! Та со, о Цындомари алаи э пхуяко кан керэл начячипэ? ");
INSERT INTO rmn_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","О Сагбус о Яхвэ пхэнляс: — Мэ тэ аракхава андэ Садом пэинда надошалэн, кан аядияв булуб лэнги алаи адая диз. ");
INSERT INTO rmn_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Дэчи о Авраам пхэнляс генэ: — Аки, динём ман зор тэ зборизав э Сагбуса, хоч мэ прахос тай катрани. ");
INSERT INTO rmn_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Со, тэ си надошалэ пандженги залак, ниш пэинда? Кан хурдярэс Ту алаи э диз, кай на рэсэн пандж мануша? — Мэ тэ аракхава отхэ саранду пандж, — пхэнляс Ов, — на кан хурдярав ла. ");
INSERT INTO rmn_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","О Авраам пхэнляс Лэски генэ екхвар: — Со, отхэ тэ аракхлёна саранда? Ов пхэнляс: — Булуб саранданги Мэ на кан керав адава. ");
INSERT INTO rmn_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Дэчи одова пхэнляс: — Ма холязэ, Сагбуса, кан мукес ман тэ пхэнав. Со, тэ аракхлёна отхэ екх триянда? Ов пхэнляс: — Мэ на кан керав адава, тэ аракхава отхэ триянда. ");
INSERT INTO rmn_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","О Авраам пхэнляс: — Аки, мандэ сас асавки зор, кай пхэнлём э Сагбуски. Кай, тэ аракхлёна отхэ екх биш? Ов пхэнляс: — Булуб бишэнги Мэ на кан хурдярав ла. ");
INSERT INTO rmn_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Дэчи о Авраам пхэнляс: — Ма холязэ, Сагбуса, ами мук ман тэ пхэнав генэ екхвар. Со, тэ аракхлёна отхэ екх дэш? Ов пхэнляс: — Булуб дэшэнги Мэ на кан хурдярав ла. ");
INSERT INTO rmn_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Кана о Сагбус о Яхвэ бытэрды тэ зборизэл э Авраамеса, Ов гело, ай о Авраам ало кхерэ. ");
INSERT INTO rmn_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Дуй миляикя алэ андэ Садом бэлвэле, тай о Лот сас бэшло ки бар ки дизаки. Кана о Лот дикхляс лэн, ов ущино тай бангило джи ки пху. ");
INSERT INTO rmn_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","— Сагбудэс минрэ, — пхэнляс ов, — мангав тумэн, элан андэ кхер мандэ, тумарэ иргатестэ. Тумэ тэ кан халярэн тумарэ пинрэ тай тэ раткерэн, ай эртэс сабахтан тэ джян тумаро дром. — На, — пхэнлэ он, — амэ кан раткерас ко майдани. ");
INSERT INTO rmn_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ай ов аякха лачес мангляс лэн, кай он гелэ пал лэстэ тай динэ андэ кхер. Ов диняс лэн хабэ тай пэкляс лэнги писноя питэс, тай он халэ. ");
INSERT INTO rmn_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ай ангал отхэ сар он пашлилэ, алаи о мурша э Садомески, о тэрнэ тай о пхурэ, агорадылар о кхер. ");
INSERT INTO rmn_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Он дэнас бэбэря э Лотески: — Кай о мануша, савэ алэ тутэ бэлвэле? Никал лэн амэндэ, амэ мангас тэ совас лэнца. ");
INSERT INTO rmn_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","О Лот никлисто лэндэ тай пханляс пал пэстэ о удар. ");
INSERT INTO rmn_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Ов пхэнлём: -— На, мэ пхрала, ма керэн асавко джюнгалипэ. ");
INSERT INTO rmn_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Шунэн, мандэ си дуй чяя, савэ дага на сас ромэстэ. Эла мэ кан никалав лэн тумэндэ, тай керэн лэнца, со манген. Ай ма керэн ништо адалэ манушэнги, савэ алэ андэ мэ кхерэстэ. ");
INSERT INTO rmn_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Он пхэнлэ: — Джя катар дром! Тай пхэнлэ: — Аки ту, джяти, алян тай пхэнэс амэнги, со тэ керас! Амэ кан керас туки май хурлуки, ниш лэнги. Он лилэ тэ дэн бутуря э Лотес тай пашылэ тэ хурдярэн о удар. ");
INSERT INTO rmn_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ай о мурша, савэ сас андэ кхер, сидинэ э Лотес андэ кхер тай пханлэ о удар. ");
INSERT INTO rmn_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ай одолэн, кон э сас ко удар ки кхерэско, э тэрнэн тай э пхурэн, он корярдэ, аякха кай на аракхенас о удар. ");
INSERT INTO rmn_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Тай он пхэнлэ э Лотески: — Кон генэ тутэ атхэ си? Джямутрэ,чявэ, чяя, кон-то генэ андэ диз? Гел лэн атхар, ");
INSERT INTO rmn_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","вай амэ мангас тэ хурдярас адава тхан. Э бэбэря ангал Сагбус Яхвэ адалэ дюнястэ асавки бари, кай Ов бичялдяс амэн тэ хурдярас э диз. ");
INSERT INTO rmn_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","О Лот никлисто тай пхэнляс одолэнги, савэ кан овэн лэски джямутрэ, пэ чяянги дэхлэнги: — Чяльти, джян атхар! О Сагбус о Яхвэ кидэлпэс тэ хурдярэл э диз! Ай одола тюшундылар, кай керэл пхэряс. ");
INSERT INTO rmn_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Кана лиляс тэ десёл, о миляикя лилэ тэ сигярдярэн э Лотес, пхэнэнас: — Сигяр! Гел атхар тэ ромня тай тэ до чяян, я ту кан мэрэс екхетханэ адалэ бэзялэ дизаса. ");
INSERT INTO rmn_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ов на сигярэлас, тай одола о дуй лилэ лэс вастэндар, тай лэски ромня, тай до чяян, вай о Сагбус о Яхвэ сас лэндэ миласа, тай никалдэ лэн пал диз. ");
INSERT INTO rmn_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Тай пал диз о екх андар лэндэ бэбэряса пхэнляс: — Кутардие то бэшыпэ! Ма дикх палэ тай ма тэрдё опэр дром! Наш андэ горадэс, я ту кан мэрэс! ");
INSERT INTO rmn_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Ай о Лот пхэнляс лэнги: — На, Сагбус! ");
INSERT INTO rmn_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Ту аякха лачё манца, тэ иргатестэ, тай Ту сикавдян манги бари мила, кутардиесас мо бэшыпэ. Ай андэ горадэс мэ нащи кан прастав: о хурлуки кан астарэл ман, тай мэ кан мэрав. ");
INSERT INTO rmn_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Аки одоя дизори надур, отхэ мэ кан рэсав тэ прастав, ой набари. Мук ман тэ прастав отхэ — вай ой тикнёри, тай мэ кан овав кутардимэ. ");
INSERT INTO rmn_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ов пхэнляс: — Лачё, Мэ кан керав ли адава: Мэ на кан хурдярав э диз, савятар ту пхэнэс. ");
INSERT INTO rmn_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Праста отхэ чяльти, вай Мэ нащи керав ништо, бискай ту на кан авэс джи латэ. Оничин одоя диз бучёл Цоар. ");
INSERT INTO rmn_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","О кхам ваздиндило, кана о Лот ало ко Цоар. ");
INSERT INTO rmn_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Дэчи о Сагбус о Яхвэ чёрдяс опэр Садом тай Гамора, сар брышым, тхарди сера. Ой али катар Сагбус Яхвэ опрал булутя. ");
INSERT INTO rmn_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Ов хурдярдяс о диза тай алаи одоя риг, тай алаен, кон бэшэлас андэ диза, тай алаи, со барёлас опэр пху. ");
INSERT INTO rmn_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ай э ромни э Лотески дикхляс палэ тай ули лонэско столби. ");
INSERT INTO rmn_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Авэр сабаги о Авраам ущино эртэс тай ало одолэ тханэстэ, катэ ов сас тэрдо ангал Сагбус Яхвэ. ");
INSERT INTO rmn_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Ов дикхляс карин Садом тай Гамора, тай карин алаи ки ливади, тай дикхляс: бут тхув ваздиндёл катар пху, сар тхув андар пэчи. ");
INSERT INTO rmn_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Аякха, кана о Дэл тхардяс о диза э ливадяки, андэ савэндэ бэшэлас о Лот, Ов тюшунды катар Авраам тай кутарды э Лотес катар хурлуки. ");
INSERT INTO rmn_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","О Лот трашалас тэ ачёл андэ Цоар, оничин ов тай лэски дуй чяя нашлэ андэ горадэс. Он екхетханэ ачилэ тэ бэшэн андэ пищера. ");
INSERT INTO rmn_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Э бари чяй пхэнляс э тикняки: — Амаро дад пхуро, тай нанай мурш опэр пху, тэ пашлён амэнца, сар камэл. ");
INSERT INTO rmn_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Эла пиявдярас амарэ дадэс винас тай тэ пашляс лэса. Хоч амарэ дадэстар мэ овэн амэн пуя! ");
INSERT INTO rmn_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Одоя рат он пиявдярдэ пумарэ дадэс винас, тай э бари чяй али тай пашлили лэса. Ов на джянэлас, кана ой пашлили тай кана ой ущини. ");
INSERT INTO rmn_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Авэр дес э бари чяй пхэнляс э тикняки: — Окоя рат мэ пашлилём амарэ дадэса. Эла генэ пиявдярас лэс винас авдес бэлвэле, тай ту кан авэс тай кан пашлёс лэса. Хоч амарэ дадэстар мэ овэн амэн пуя! ");
INSERT INTO rmn_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Он пиявдярдэ пумарэ дадэс винас тай адая рат, ли э тикни чяй али тай пашлили лэса. Тай ов на джянэлас, кана ой пашлили тай кана ой ущини. ");
INSERT INTO rmn_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Аякха ли о дуй чяя э Лотески насвалилэ пуёстэ пумарэ дадэстар. ");
INSERT INTO rmn_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ки бари чяй аракхлило чяво, тай тхэдяс лэс Моав. Ов — о дад аканутнэ моавитяненго. ");
INSERT INTO rmn_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ли ки тикни чяй аракхлило чяво, тай тхэдяс лэс Бэн-Амми. Ов — о дад аканутнэ аммонитяненго. ");
INSERT INTO rmn_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Отхар о Авраам гело андэ Негев тай ачило тэ бэшэл машкарэ ко Кадэш тай Шур. Ов саво-то вахыти бэшэлас андэ Герар. ");
INSERT INTO rmn_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Отхэ ов алаенги пхэнэлас, кай э Сарра — лэски пхэн. Оничин о Авимелех, о патишаи э Герареско, бичялдяс пал Сарра тай лиляс ла пэстэ андэ кхер. ");
INSERT INTO rmn_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ай о Дэл ало ко Авимелех рати андэ суно тай пхэнляс лэски: — Ту кан мэрэс андар джювли, савя ту лилян тутэ андэ кхер. Ой ромэстэ. ");
INSERT INTO rmn_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Ай о Авимелех на колисаило латэ, оничин ов пхэнляс: — Сагбуса, та со, Ту кан мударэс надошалэ дюняс? ");
INSERT INTO rmn_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Адава мануш ов сам пхэнляс, кай ой лэски пхэн, тай ой аякхажэ пхэнляс. Андэ адалэ дилатэ мэ на кердём бэзя нэ андэ мэ илэстэ, нэ вастэнца. ");
INSERT INTO rmn_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","О Дэл пхэнляс лэски андэ суно: — Ва, Мэ джянав, кай адава ту кердян шужэ илэса. Адава Мэ астардём тут катар бэзя ангал Мандэ, оничин на муклём тут тэ колизэс латэ. ");
INSERT INTO rmn_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Акана дэ палэ э ромня ко ром, вай ов — прароки. Ов кан алгыштиел тут, тай ту кан ачёс дживиндо. Ай ту тэ на дэса ла, джян, кай ту тай тэ тухумя кан мэрэн. ");
INSERT INTO rmn_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Авэр дес эртэс сабахтан о Авимелех кидиняс алаи пэ иргатен тай пхукавдяс лэнги, со уло, тай он лачес трашанилэ. ");
INSERT INTO rmn_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Дэчи о Авимелех диняс икос э Авраамес тай пхэнляс: — Со ту амэнца кердян? Со джюнгалипэ мэ туки кердём, кай ту тхэдян тэ керас бэзя ман тай алаи мо патишайлыки? Ту кердян манца аякха, сар на камэл тэ керэс. ");
INSERT INTO rmn_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Тай о Авимелех пхучляс э Авраамес: — Со ту тюшундиесас, кана ту кердян асавко? ");
INSERT INTO rmn_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","О Авраам пхэнляс: — Мэ тюшундым, со адалэ тханэстэ о мануша чячес на трашан катар Дэл, тай он кан мударэн ман андар мэ ромнятэ. ");
INSERT INTO rmn_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Тай генэ ой чячес ми пхэн — огеи мэ дадэстар. Тай ой ули ми ромни. ");
INSERT INTO rmn_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Кана о Дэл бичялдяс ман андар кхер мэ дадэско аврэ пхуендэ, мэ пхэнлём лаки: «Сикав манги то дэхыпэ, пхэн, кай мэ то пхрал, кай би амэ тэ на авас». ");
INSERT INTO rmn_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Дэчи о Авимелех диняс ко Авраам э Сарра тай генэ андяс лэски бузнен, бакрэн, гурувнен, иргатен тай иргатинкен. ");
INSERT INTO rmn_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","О Авимелех пхэнляс: — Ми пху ангал тутэ: бэш, кай мангес. ");
INSERT INTO rmn_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Э Сарраки ов пхэнляс: — Мэ динём тэ пхралэс бини руп, тэ пхандэл якха алаенги, кон эси туса. Ту анкха ангал алаендэ шужы. ");
INSERT INTO rmn_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","О Авраам мангелас э Дэвлэс, тай о Дэл аиндырды э Авимелехес, лэски ромня тай э иргатинкен, тэ овэн лэндэ пуя. ");
INSERT INTO rmn_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Ай ангал отхэ андэ кхер ко Авимелех о Сагбус о Яхвэ на дэлас билиекхе джювля пуен андар Сарра, ки ромни ки Авраамески. ");
INSERT INTO rmn_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","О Сагбус о Яхвэ, сар Ов пхэнляс, сас миласа ки Сарра тай кердяс, со пхэнлясас. ");
INSERT INTO rmn_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Э Сарра насвалили пуёстэ, тай э пхурэ Авраамески аракхлило чяво, андэ одова вахыти, сар пхэнляс лэски о Дэл. ");
INSERT INTO rmn_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Пэ чявэс, саво аракхлило ки Сарра, о Авраам тхэдяс Исаак. ");
INSERT INTO rmn_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Кана лэски чявэски э Исаакески уло охто дес, о Авраам абрезал лэс, сар пхэнляс лэски о Дэл. ");
INSERT INTO rmn_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Кана аракхлило о Исаак, э Авраамески сас шэл брэш. ");
INSERT INTO rmn_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Э Сарра пхэнляс: — О Дэл тхэдяс ман тэ асав. Кажын, кон кан шунэл адалэстар, кан асал екхетханэ манца. ");
INSERT INTO rmn_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Тай генэ пхэнляс: — Кон би пхэнлясас э Авраамески, кай э Сарра кан хавдярэл колиндэса? Ай мандэ аракхлило чяво лэски андэ лэски пхуримастэ. ");
INSERT INTO rmn_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","О пуёс барило тай сас линдо катар колин. Одова дес, кана о Исаак сас линдо катар колин, о Авраам кердяс баро хабэ. ");
INSERT INTO rmn_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Э Сарра дикхляс, кай о чяво, саво аракхлило ки египтянка Агарь э Авраамески, асал катар Исаак, ");
INSERT INTO rmn_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","тай пхэнляс э Авраамески: — Кувдие адалэ иргатинка тай лаки чявэс, вай о чяво адалэ иргатинкако на кан палящиел о мангин мэ чявэса э Исаакеса. ");
INSERT INTO rmn_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","О Авраам сас бут касывэтлыс, вай адава сас лэско чяво. ");
INSERT INTO rmn_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ай о Дэл пхэнляс лэски: — Ма ов касывэтлыс андар чяворо тай иргатинка. Шун э Сарра тай кер алаи, сар ой пхэнэл, вай катар Исаак тутэ кан овэн пуя, савэндар Мэ туки пхэнлёмас. ");
INSERT INTO rmn_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ай Мэ кан керав дюняс ли катар чяво ки иргатинкако, вай ли ов — то чяво. ");
INSERT INTO rmn_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Авэр дес эртэс сабахтан о Авраам лиляс хапэ тай моркхяко гоно панеса тай диняс ки Агарь, тхэдяс лэн лаки опэр пхике тай бичялдяс ла екхетханэ э пуёса. Ой гели ко дром тай пхерэлас андэ ливади Бээр-Шэва. ");
INSERT INTO rmn_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Кана о пани андэ гоно быты, ой ачявдяс э чяворэс тал кущёки ");
INSERT INTO rmn_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","тай гели, бэшли надур, о дурипэ, сар кай мукес стрилас, вай тюшундиелас: «На мангав тэ дикхав, сар о чяворо мэрэл». Ой бэшли отхэ надур тай руни. ");
INSERT INTO rmn_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","О Дэл шунляс о роипэ э чяворэско, тай о миляики э Дэвлэско болдиняспэс карин Агарь опрал булутя тай пхэнляс лаки: — Со уло, Агарь? Ма траша! О Дэл шунляс, сар ровэл о чяворо отхэ, катэ ов пашло. ");
INSERT INTO rmn_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Ущи, ваздэ э чяворэс тай лэ лэс вастэстар, вай Мэ кан керав лэстар баро дюняс. ");
INSERT INTO rmn_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Тай о Дэл пхутэрдяс лаки якха, тай ой дикхляс ханинг панеса. Ой гили, пхэрдяс о гоно панеса тай пиявдярдяс э чяворэс. ");
INSERT INTO rmn_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","О Дэл сас э чяворэса. О Измаил барило, бэшэлас ки ливади тай уло одова, кай мукел стрилас. ");
INSERT INTO rmn_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Ов бэшэлас ки ливади Паран, тай э дай лиляс лэски ромня андар Египти. ");
INSERT INTO rmn_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Андэ одова вахыти о Авимелех тай о Пихол, о баро лэски армияко, пхэнляс э Авраамески: — О Дэл туса андэ алаестэ, со ту керэс. ");
INSERT INTO rmn_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Ха совля манги атхэ ангал Дэл, кай ту на кан керэс джюнгалипэ нэ манца, нэ мэ пуенца, нэ мэ породаса. Кер манги тай э пхуяки, андэ савятэ ту бэшэс, мила, сави кердём мэ туки. ");
INSERT INTO rmn_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","О Авраам пхэнляс: — Хав совля. ");
INSERT INTO rmn_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Дэчи о Авраам пхэнляс э Авимелехески катар ханинг э панеса, сави лилэ о иргатя э Авимелехески. ");
INSERT INTO rmn_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Ай о Авимелех пхэнляс: — Мэ на джянав, кон адава кердяс. Ту на пхэнлянас манги, тай джи адалэ десески мэ на шунлёмас адалэстар. ");
INSERT INTO rmn_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","О Авраам андяс э тикнэ тай э барэ гайванен тай диняс ко Авимелех, тай он кердэ завети машкарэ пэстэ. ");
INSERT INTO rmn_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","О Авраам лиляс андар атара эфта тэрнэ бакрэн, ");
INSERT INTO rmn_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","тай о Авимелех пхучляс ко Авраам: — Со си адала эфта тэрнэ бакрэ, савэн ту лилян аврэндар? ");
INSERT INTO rmn_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ов пхэнляс: — Лэ мэ эфта тэрнэ бакрэн. Мэ овэн он сикаипэ кай мэ хранлём адая ханинг. ");
INSERT INTO rmn_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Аки соски одова тхан сас тхэдо Бээр-Шэва: вай он о дуй отхэ халэ совля. ");
INSERT INTO rmn_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Кана он кердэ завети машкарэ пэстэ андэ Бээр-Шэва, о Авимелех тай о Пихол, о баро лэски армияко, алэ палэ андэ пху ки филистимляненги. ");
INSERT INTO rmn_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","О Авраам барярдяс андэ Бээр-Шэва тэрэки тамариски тай мангляс о нав э Сагбуско э Яхвэско, э Дэвлэс, Саво си Сальтя . ");
INSERT INTO rmn_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","О Авраам бэшэлас опэр пху ки филистимляненги бут вахыти. ");
INSERT INTO rmn_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Вахытестар о Дэл зумавдяс э Авраамес. Ов пхэнляс лэски: — Авраам! — Мэ атхэ, — пхэнляс о Авраам. ");
INSERT INTO rmn_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","О Дэл пхэнляс: — Лэ тэ екхе чявэс, э Исаакес, савэс ту дэхэс, джя ки пху Мориа тай ан лэс отхэ курбани, тхар опэр горас, опэр савэстэ Мэ кан сикава туки. ");
INSERT INTO rmn_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Авэр дес эртэс сабахтан о Авраам ущино, гортярдяс э джёрэс, лиляс пэса до иргатен тай пэ чявэс э Исаакес, пхагердяс кашта ягаки тай гело ко дром одолэ тханэстэ, савэстар пхэнляс лэски о Дэл. ");
INSERT INTO rmn_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Ко трито дес о Авраам ваздиняс пэ якха тай дикхляс дурал одова тхан. ");
INSERT INTO rmn_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ов пхэнляс э иргатенги: — Ачён атхэ э джёрэса, ай амэ э чяворэса кан джяс отхэ тай кан мангас э Дэвлэс, тай дэчи кан авас тумэндэ. ");
INSERT INTO rmn_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","О Авраам лиляс о кашта э ягаки тай тхэдяс лэн опэр думо ки Исаакеско, ай ов гелдяс э яг тай э чюри, тай он о дуй гелэ ко дром. ");
INSERT INTO rmn_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","О Исаак пхэнляс пэ дадэски э Авраамески: — Дадэ! — Ва, мо чяво? — пхэнляс о Авраам. — Амэндэ си яг тай кашта, — пхэнляс о Исаак, — ай кай о бакроро э курбанески? ");
INSERT INTO rmn_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","О Авраам пхэнляс: — О Дэл Ов сам кан гортярэл бакрорэс курбанески, мо чяво. Тай он о дуй гелэ англэ. ");
INSERT INTO rmn_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Кана он алэ ко тхан, савэстар пхэнляс лэски о Дэл, о Авраам кердяс отхэ алтари тай кидиняс опрал о кашта, пханляс пэ чявэс э Исаакес тай тхэдяс лэс опэр алтари опэр кашта. ");
INSERT INTO rmn_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ов сидиняс пэ васта тай лиляс чюри, тэ чинэл пэ чявэс. ");
INSERT INTO rmn_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ай о Миляики э Сагбуски Яхвэско пхэнляс лэски опрал булутя: — Авраам! Авраам! — Мэ атхэ, — пхэнляс ов. ");
INSERT INTO rmn_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","— Ма ваздэ то васт опэр чяворо, — пхэнляс Ов, — ма кер лэса ништо. Акана мэ джянав, кай ту трашас катар Дэл, вай ту на аядын Манги тэ екхе чявэс. ");
INSERT INTO rmn_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","О Авраам ваздиняс пэ якха тай дикхляс бакрэс, саво пакярдило шынгенца андэ чяря. Ов гело, лиляс э бакрэс тай андяс лэс курбани, тхардяс ко тхан ки чявэско. ");
INSERT INTO rmn_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","О Авраам тхэдяс одова тхан Яхвэ-Ирэ, тай отхар джи анкха пхэнлёлпэс: «Опэр горас ки Сагбуски Яхвэско кан аракхлёл». ");
INSERT INTO rmn_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","О Миляики э Сагбуски Яхвэско пхэнляс э Авраамески опрал булутя дуйто рази: ");
INSERT INTO rmn_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","— Дав совля опэр Мандэ, пхэнэл о Сагбус о Яхвэ: кай ту кердян адава тай на аядын Манги тэ екхе чявэс, ");
INSERT INTO rmn_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Мэ анкха кан алгыштияв тут тай кан керав тэ пуен бут, сар чергэня опэр булутя, сар кишай паш ки моря. Тай тэ пуя кан лэн о диза пумарэ душманенги. ");
INSERT INTO rmn_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Кай ту тхэдян кан Ман, андар тэ пуендэ кан диндён алгышы алаи о дюнядэс опэр пху. ");
INSERT INTO rmn_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","О Авраам ало ко иргатя, тай он екхетханэ гелэ андэ Бээр-Шэва. О Авраам ачило андэ Бээр-Шэва. ");
INSERT INTO rmn_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Накхло вахыти, тай э Авраамески пхэнлэ: — Ли э Милка ули дай, аракхлилэ латэ чявэ тэ пхралэски э Нахорески: ");
INSERT INTO rmn_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","о Уц, о баштутно, о Буз, лэско пхрал, о Кемуил (о дад э Арамеско), ");
INSERT INTO rmn_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","о Кесед, о Хазо, о Пилдаш, о Идлаф тай о Бетуил. ");
INSERT INTO rmn_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","О Бетуил уло о дад э Рэвэкако. Адала охто чявэ ки Милка аракхлилэ э Авраамески пхралэски э Нахорески. ");
INSERT INTO rmn_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Лэски иргатинкатэ, сави бучёлас Реума, аракхлилэ чявэ: о Тевах, о Гахам, о Тахаш тай о Мааха. ");
INSERT INTO rmn_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Э Сарра бэшли шэлу биш эфта брэш — адава о брэша э Сарраки. ");
INSERT INTO rmn_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Ой мули андэ Кирьят-Арба (самким Хеврон), андэ пху Ханаан, тай о Авраам ало тэ керэл касывэти пал Сарра тай тэ ровэл пал латэ. ");
INSERT INTO rmn_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Дэчи о Авраам ачявдяс пэ мулэ ромня тай гело ко хетеенги. Ов пхэнляс: ");
INSERT INTO rmn_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","— Мэ машкарэ тумэндэ джяти аврэ пхуятар. Бикнэн манги тхан тэ пароскерав э муля. ");
INSERT INTO rmn_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","О хетея пхэнлэ э Авраамески: ");
INSERT INTO rmn_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","— Сагбуса, шун, ту — Дэвлэско мануш машкарэ амэндэ. Пароскер э муля андэ зиядэ андар амарэ паромаски тханэндэ. Никхон андар амэндэ на кан пхэнэл туки, на дав тхан тэ пароскерэс э муля. ");
INSERT INTO rmn_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Дэчи о Авраам ущино, бангило э манушэнги одолэ пхуякерэнги, э хетеенги. ");
INSERT INTO rmn_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Ов пхэнляс лэнги: — Тэ мукен тумэ тэ пароскерав э муля, дэчи шунэн ман тай манген андар мандэ э Эфронес, э чявэс э Цохарескерэс, ");
INSERT INTO rmn_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ов тэ бикнэл манги э пищера э Махпела, сави си лэски тай си ко чети лэски ливадятэ. Мэ бикнэл ла манги э кимяки, сар керэл о тхан, катэ пароскерэс машкарэ тумэндэ. ");
INSERT INTO rmn_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","О хетеи о Эфрон бэшло машкарэ пэ дюнястэ тай пхэнляс э Авраамески ангал алаи ко хетея, савэ алэ ки бар лэски дизатэ. ");
INSERT INTO rmn_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Ов пхэнляс: — На, мо сагбуса, шун ман. Мэ дав тут э ливади тай дав тут э пищера, сави си опэр латэ. Мэ дав тут адава ангал мэ дюнястэ. Пароскер тэ муля. ");
INSERT INTO rmn_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","О Авраам генэ бангило э манушэнги одолэ пхуякерэнги ");
INSERT INTO rmn_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","тай пхэнляс э Эфронески ангал лэндэ: — Шун акана ту ман. Мэ кан покинав руп э ливадяки. Лэ лэс мандар, мэ тэ пароскерав отхэ э муля. ");
INSERT INTO rmn_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","О Эфрон пхэнляс э Авраамески: ");
INSERT INTO rmn_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","— Шун ман, мо сагбус. Э пху кай керэл штаршэл шэкеля руп. Та со, адава бут туки я манги? Пароскер тэ муля. ");
INSERT INTO rmn_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","О Авраам тхэдяс кан э Эфронес тай алды э кими э ливадяки, кай пхэнлили ангал хетея: штаршэл шэкеля руп, сар кинэн о кинимаря. ");
INSERT INTO rmn_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Аякха э ливади э Эфронески андэ Махпела паш Мамрэ — тай ливади, тай э пищера опэр латэ, тай алаи о тэрэкя опэр ливади — улэ ");
INSERT INTO rmn_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","э Авраамески ангал алаи ко хетея, савэ алэ ки дизаки бар. ");
INSERT INTO rmn_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Пал атхэ о Авраам пароскердяс пэ ромня э Сарра андэ пищера опэр ливади Махпела паш ки Мамрэ (кай андэ Хеврон), андэ пху Ханаан. ");
INSERT INTO rmn_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Э ливади, тай э пищера опэр латэ ули э Авраамески катар хетея сар тхан паромаски. ");
INSERT INTO rmn_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","О Авраам сас пхуро, барэ брэшэнго, тай о Сагбус о Яхвэ алгышты лэс андэ алаестэ. ");
INSERT INTO rmn_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","О Авраам пхэнляс э барэ иргатески андэ пэ кхерэстэ, саво дикхелас пал алаестэ, со лэстэ сас: — Тхэ то васт манги тал шалос ");
INSERT INTO rmn_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","тай ха совля манги э Сагбуса э Яхвэса, э булутенги Дэвлэса тай э пхуяки Дэвлэса, кай ту на кан лэс мэ чявэски ромня андар ханаанеенги чяя, машкарэ савэндэ мэ бэшав, ");
INSERT INTO rmn_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","ами кан джяс мэ пхуятэ, мэ тухумендэ, тай отхэ кан лэс ромня мэ чявэски э Исаакески. ");
INSERT INTO rmn_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","О иргати пхучляс лэс: — Ами тэ на мангела одоя джювли тэ джял манца атхэ, андэ адая пху? Со манги дэчи тэ керав, тэ гелав тэ чявэс андэ одоя пху, катар ту алян? ");
INSERT INTO rmn_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","О Авраам пхэнляс: — Тэ на гелэс отхэ мэ чявэс. ");
INSERT INTO rmn_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","О Сагбус о Яхвэ э булутенго, саво никалдяс ман андар кхер мэ дадэско тай андар мэ чяче пхуятэ, Саво зборизэлас манца тай халяс совля манги, пхэнляс: «Мэ кан дав адая пху тэ пуендэ». Ов кан бичялэл Пэ миляикес ангал тутэ, ту тэ лэс отхар ромня мэ чявэски. ");
INSERT INTO rmn_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Э джювли тэ на мангела тэ джял туса, ту кан овэс мукло адалэ совлендар. Ай мэ чявэс ма гел отхэ. ");
INSERT INTO rmn_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","О иргати тхэдяс по васт тал шалос пэ сагбустэ ко Авраам тай халяс совля лэски. ");
INSERT INTO rmn_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Дэчи о иргати лиляс дэшэ камилэн пэ сагбуски, пхэрдяс лэн лаче шэя лэстар тай гело ко дром. Ов гело андэ Арам-Нахараим, джялас андэ диз, катэ бэшэлас о Нахор. ");
INSERT INTO rmn_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ов тэрдярдяс э камилэн пал диз ки ханинг. Адава сас паш ки бэлвэль, кана о джювля авэн панески. ");
INSERT INTO rmn_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ов пхэнляс: — О Сагбус о Яхвэ, о Дэл мэ сагбуско э Авраамеско! Дэ ман авдес лачипэ тай кер мила мэ сагбуски э Авраамески. ");
INSERT INTO rmn_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Аки, мэ тэрдо ки ханинг, тай о чяя адалэ манушэнги авэн панески. ");
INSERT INTO rmn_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Мэ овэл аякха: тэ пхэнава мэ чяяки: «Мангав тут, мук о кхоро опрал пхико, мэ тэ пияв», — ай ой кан пхэнэл: «Пи, ай мэ кан пиявдярав тэ камилэн», — ла Ту да газырлыдын э иргатески Тинрэски э Исаакески. Аякха мэ кан галяв, кай Ту кердян мила мэ сагбуски. ");
INSERT INTO rmn_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Ов дага на бытэрды тэ пхэнэл, кай э Рэвэка, э чяй э Бетуилески, э Милкаки чявэски, э ромни э Авраамески пхралэски э Нахорески, никлисти ко пани кхорэса опэр пхико. ");
INSERT INTO rmn_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Ой сас бут шукар чяй, тэрнагар, сави дага на сас муршэса. Ой мукляспэс ко пани, пхэрдяс о кхоро тай гели палэ. ");
INSERT INTO rmn_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","О иргати сигярдяс мамуй тай пхэнляс: — Мангав тут, дэ ман набут пани андар тэ кхорэстэ. ");
INSERT INTO rmn_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","— Пи, мо сагбус, — пхэнляс ой, чяльти мукляс о кхоро опэр васта тай диняс лэс тэ пиел. ");
INSERT INTO rmn_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Кана ов пиляс лачес, ой пхэнляс: — Мэ кан пхэрав пани ли тэ камилэнги, бискай он на кан пиен лачес. ");
INSERT INTO rmn_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Ой чяльти чёрдяс о пани андар кхоро андэ копана, прастанили генэ ко пани тэ пхэрэл алаи лэски камилэнги. ");
INSERT INTO rmn_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ов тэныки дикхелас пал латэ, мангелас тэ галёл, башлады о Сагбус о Яхвэ лачимаса лэско дром. ");
INSERT INTO rmn_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Кана о камилэс пилэ, одова мануш никалдяс пхоляки чяни андэ накх, сави сас пхаримаса екпаш шэкели, тай дуй пхоляки бруслетя, савэ сас дэш шэкеля, ");
INSERT INTO rmn_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","тай пхучляс: — Пхэн манги, каски ту чяй? Нанай андэ кхер тэ дадэстэ тхан, амэнги тэ раткерас? ");
INSERT INTO rmn_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ой пхэнляс лэски: — Мэ э чяй э Бетуилески, э Милкаки чявэски, саво латэ аракхлило э Нахорески. ");
INSERT INTO rmn_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Тай генэ пхэнляс: — Амэндэ бут пхус, тай хапэ э гайваненги, тай си тхан тэ раткерэс. ");
INSERT INTO rmn_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Дэчи ов бангило тай махтады э Сагбус э Яхвэс, ");
INSERT INTO rmn_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","пхэнляс: — Махтадипэ э Яхвэски, Дэвлэски мэ сагбускерэски э Авраамески, Саво на ачявдяс би Пэ милако тай би чячимаско мэ сагбус! О Сагбус о Яхвэ андяс ман доврус андэ кхер ко тухумя мэ сагбускерэндэ. ");
INSERT INTO rmn_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Э чяй прастанили тай пхукавдяс алаестар андэ кхер пэ дэятэ. ");
INSERT INTO rmn_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Ки Рэвэка сас пхрал, саво бучёлас Лаван, тай ов сигярдяс одолэ манушэстэ ки ханинг. ");
INSERT INTO rmn_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Сар ов дикхляс э чяни э накхески тай бруслетя ко васта пэ пхэнятэ тай шунляс о пхукаипэ э Рэвэкако одолэстар, со пхэнляс лаки одова мануш, ов гело лэстэ, ай одова аякха да тэрдо э камилэнца ко панги. ");
INSERT INTO rmn_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","— Гадэ амэндэ, алгыштимэ э Сагбуса э Яхвэса, — пхэнляс о Лаван. — Соски ту тэрдо атхэ аври? Мэ гортярдём кхер тай тхан э камилэнги. ");
INSERT INTO rmn_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Одова мануш диняс андэ кхер, тай опрал камилэс сас линдэ о сидладэс. Э камилэнги андэ пхус тай хапэ, ай лэски тай лэски манушэнги андэ пани, тэ халярэн пумарэ пинрэ. ");
INSERT INTO rmn_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ангал лэстэ тхэдэ хапэ, ай ов пхэнляс: — Мэ на кан хав, бискай на пхукава, со камэл мэ тэ керав. — Пхукав, — пхэнляс о Лаван. ");
INSERT INTO rmn_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ов пхэнляс: — Мэ — о иргати э Авраамеско. ");
INSERT INTO rmn_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","О Сагбус о Яхвэ бут лачес алгышты мэ сагбус, тай ов уло барвало. Ов диняс лэс бакрэн, бузнен, гурувнен, руп тай пхол, иргатен тай иргатинкен, камилэн тай джёрэн. ");
INSERT INTO rmn_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Мэ сагбуски ромнятэ ки Сарра аракхлило лэски чяво опэр пхуримастэ, тай ов ачявдяс лэски алаи, со лэстэ си. ");
INSERT INTO rmn_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Мо сагбус пхэнляс манги тэ хав совля тай пхэнляс: «Ма лэ ромня мэ чявэски э ханаанеенги чяен, андэ каски пхуятэ мэ бэшав, ");
INSERT INTO rmn_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","ами джя мэ дадэски хорандастэ, мэ тухумендэ, тай отхар лэ ромня мэ чявэски». ");
INSERT INTO rmn_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Мэ пхучлём мэ сагбус: «Ай со, одоя джювли тэ на джяла манца?» ");
INSERT INTO rmn_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ов пхэнляс: «О Сагбус о Яхвэ, ангал муй Савэстэ мэ пхерав, кан бичялэл туса Пэ миляикес тай кан керэл лачипэ андэ ти дила, ту тэ лэс ромня мэ чявэски андар мэ тухумендэ тай андар мэ дадэски хорандастэ. ");
INSERT INTO rmn_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Екх озаман ту кан овэс мукло адалэ совлендар, кана кан овэс андэ кхер мэ дадэстэ, тай тэ пхэнэна, на дас ла тутэ, дэчи ту кан овэс мукло катар совля». ");
INSERT INTO rmn_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Кана мэ авдес алём ко пани, мэ пхэнлём: «О Сагбус о Яхвэ, о Дэл мэ сагбуско э Авраамеско, екх тэ дэсас би Ту лачипэ андэ мэ дилатэ, савяса мэ бичялдо! ");
INSERT INTO rmn_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Аки мэ тэрдо ко пани. Тэ никлёла чяй тэ пхэрэл пани, тай мэ кан пхэнав лаки: \"Мангав тут, дэ ман тэ пияв пани андар тэ кхорэстэ\", ");
INSERT INTO rmn_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","— тай ой тэ пхэнэла манги: \"Пи, ай мэ кан пхэрав пани ли тэ камилэнги\", — дэчи о Сагбус о Яхвэ гортярдяс ла мэ сагбуски чявэски». ");
INSERT INTO rmn_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Дага мэ на бытэрдым тэ мангав андэ мэ илэстэ, кана никлисти э Рэвэка э кхорэса опэр пхико. Ой мукляспэс ки ханинг тай пхэрдяс пани, тай мэ пхэнлём лаки: «Мангав тут, дэ ман тэ пияв». ");
INSERT INTO rmn_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Ой чяльти фулярдяс о кхоро опрал пхико тай пхэнляс: «Пи, ай мэ кан пиявдярав ли тэ камилэн». Тай мэ пилём пани, ай ой пиявдярдяс э камилэн. ");
INSERT INTO rmn_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Мэ пхучлём ла: «Каски ту чяй?» Ой пхэнляс: «Э чяй э Бетуилески, э Нахорески чявэски, саво лэски аракхлило ки Милка». Дэчи мэ динём ла чяни накхески тай бруслетя вастэнги ");
INSERT INTO rmn_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","тай бангилём, махтадым э Сагбус э Яхвэс. Мэ махтадым э Дэвлэс э Яхвэс, э Дэвлэс мэ сагбускерэс э Авраамескерэс, Саво чяче дромэса андяс ман, тэ лав лэски чявэски э туруниса мэ сагбуски пхралэскеря ромня. ");
INSERT INTO rmn_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Акана, тумэ тэ керэна мила тай чячипэ мэ сагбуски, аякха да пхэнэн манги. Ай тэ на, пхэнэн манги, со манги тэ керав. ");
INSERT INTO rmn_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","О Лаван тай о Бетуил пхэнлэ: — Адая дила катар Сагбус Яхвэ; на амэнги тэ пхэнас туки ва я на. ");
INSERT INTO rmn_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Аки э Рэвэка ангал тутэ; лэ ла тай джя, тай мэ овэл ой э ромни тэ сагбуски чявэски, сар гортярдяс о Сагбус о Яхвэ. ");
INSERT INTO rmn_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Кана э Авраамеско иргати шунляс адала зборэс, ов бангило ангал Сагбус Яхвэ джи ки пху. ");
INSERT INTO rmn_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Дэчи ов никалдяс о савутя, пхоляки тай рупунэ шэя тай башлады э Рэвэкаке, ай лаки пхралэс тай э дэя ов башлады багалыдэс шэя. ");
INSERT INTO rmn_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ов тай о мануша, кай сас лэса, ханас, пиенас тай ачилэ тэ раткерэн. Кана авэр дес он ущинэ, ов пхэнляс: — Мукен ман, мэ мангав тэ джяв дром мэ сагбустэ. ");
INSERT INTO rmn_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Ай лако пхрал тай э дай пхэнлэ: — Мэ ачёл э чяй амэнца генэ хоч дэш дес, дэчи джя. ");
INSERT INTO rmn_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ай ов пхэнляс: — Ма астарэн ман, кай о Сагбус о Яхвэ кердяс лачипэ мэ дилаки. Мукен ман ко дром, мэ тэ авав мэ сагбустэ. ");
INSERT INTO rmn_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Он пхэнлэ: — Кан дас икос э чяя тай кан пхучяс ла. ");
INSERT INTO rmn_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Он динэ икос э Рэвэка тай пхучлэ: — Кан джяс акалэ манушэса? — Кан джяв, — пхэнляс ой. ");
INSERT INTO rmn_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Тай он бичялдэ ко дром пэ пхэня э Рэвэка екхетханэ одоласа, сави хавдярэлас ла, э Авраамески иргатеса тай лэски манушэнца. ");
INSERT INTO rmn_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Он алгыштылар э Рэвэка тай пхэнлэ: — Амари пхэн, тэ овэн гиндэ тэ пуя биненца биня! Тэ лэн тэ пуя о кхера пэ душманенги! ");
INSERT INTO rmn_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Э Рэвэка тай лаки иргатинкес кидинэпэс, бэшлэ опэр камилэс тай гелэ пал одолэ манушэстэ. Аякха о иргати лиляс э Рэвэка тай гело ко дром. ");
INSERT INTO rmn_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","О Исаак ало андар Бээр-Лахай-Рои тай бэшэлас андэ Негев. ");
INSERT INTO rmn_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Бэлвэле ов никлисто андэ ливади, ваздиняс пэ якха тай дикхляс, кай авэн камилэс. ");
INSERT INTO rmn_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ли Рэвэка ваздиняс пэ якха тай дикхляс э Исаакес. Ой фулистини опрал камила ");
INSERT INTO rmn_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","тай пхучляс ко иргати: — Кон адава мануш андэ ливади, кай авэл мамуй амэндэ? — Адава мо сагбус, — пхэнляс о иргати. Дэчи ой лиляс басмас тай читяс опэр пэстэ. ");
INSERT INTO rmn_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","О иргати пхукавдяс э Исаакески алаестар, со ов кердяс. ");
INSERT INTO rmn_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","О Исаак андяс э Рэвэка андэ катуна пэ дэякири ки Сарраки тай лиляс ла ромня. Ой ули лэски ромни, тай ов дэхляс ла. Аякха о Исаак раганты пал пэ дэяки мэримастэ. ");
INSERT INTO rmn_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","О Авраам лиляс пэски аврэ ромня, сави бучёлас Хетура. ");
INSERT INTO rmn_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Лэски латэ аракхлило о Зимран, о Йокшан, о Медан, о Мадиан, о Ишбак тай о Шуах. ");
INSERT INTO rmn_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","О Йокшан сас о дад э Шэваско тай э Деданеско; о пуя э Деданески сас о ашшурея, о летушэя тай леуммея. ");
INSERT INTO rmn_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","О чявэ э Мадианески: о Эфа, о Эфер, о Ханох, о Авида тай о Элдаа — алаи он о пуя э Хетураски. ");
INSERT INTO rmn_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","О Авраам ачявдяс алаи, со сас лэстэ, э Исаакески. ");
INSERT INTO rmn_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Дага кана сас дживиндо, ов диняс э иргатинкенги чявэнги багалыдэс шэя тай бичялдяс пэ чявэстар катар Исаак ко вастоки, андэ вастокески пху. ");
INSERT INTO rmn_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Алаи о Авраам бэшло шэл эфтадэша пандж брэш. ");
INSERT INTO rmn_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Ов мукляс по тэнышы тай муло бут пхуро, чяло бэшымаса, тай гело пэ тухумендэ. ");
INSERT INTO rmn_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Лэски чявэ о Исаак тай о Измаил пароскердэ лэс андэ пищера Махпела паш ко Мамрэ, опэр ливади ки хетески э Эфронески, э чявэски э Цохарески, ");
INSERT INTO rmn_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","сави о Авраам киндяс ко хетея. Отхэ о Авраам сас паромэ паш пэ ромнятэ ки Сарра. ");
INSERT INTO rmn_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Пал ко мэрипэ ки Авраамеско о Дэл о Яхвэ алгышты лэски чявэс э Исаакес, саво озаман бэшэлас паш ко Бээр-Лахай-Рои. ");
INSERT INTO rmn_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Аки э порода э Измаилески, э Авраамески чявэски, саво аракхлило э Авраамески ки Сарраки иргатинка, ки египтянка Агарь. ");
INSERT INTO rmn_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Аки о нава э Измаилески чявэнги, пхэнлэ пал екхаврэстэ лэнго аракхлима: о Невайот, о баштутно э Измаилеско, о Кедар, о Адбеэл, о Мивсам, ");
INSERT INTO rmn_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","о Мишма, о Дума, о Масса, ");
INSERT INTO rmn_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","о Хадад, о Тема, о Етур, о Нафиш тай о Кедма. ");
INSERT INTO rmn_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Адава о нава э Измаилески чявэнги, о нава э дэшудо сагбудэнго породэс, катэ он бэшэнас тай катэ качюискерэнас. ");
INSERT INTO rmn_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","О Измаил бэшло 137 брэш. Ов мукляс по тэнышы тай муло, тай гело пэ тухумендэ. ");
INSERT INTO rmn_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Лэски пуя накхлэ андэ области катар Хавила джи ки Шур, паш ки граница ки Египтески, опэр дром ко Ашшур. Он бэшэнас андэ душманлыки алаи э пхралэнца. ");
INSERT INTO rmn_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Аки о пхукаипэ катар Исаак, ко чяво ки Авраамеско, тай лэски пуендар. Ко Авраам аракхлило о Исаак. ");
INSERT INTO rmn_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Э Исаакески сас саранда брэш, кана ов прандосаило опэр Рэвэка, э чяй арамеески э Бетуилески андар Паддан-Арам, э пхэн э арамеески э Лаванески. ");
INSERT INTO rmn_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","О Исаак мангелас э Сагбус э Яхвэс андар пэ ромнятэ, вай ой сас би пуенги. О Сагбус о Яхвэ кердяс, со о Исаак мангляс Лэстэ, тай лэски ромни э Рэвэка насвалили пуёстэ. ");
INSERT INTO rmn_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","О пуя лилэ тэ дэн бутуря екхаврэс андэ латэ, тай ой пхэнляс: — Андар состэ манги адава? Тай ой гели тэ пхучел ко Сагбус ко Яхвэ. ");
INSERT INTO rmn_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","О Сагбус о Яхвэ пхэнляс лаки: — Дуй породэс андэ тутэ, дуй дюнядэс кан овэн тутар тай кан палящиенпэс. О екх кан овэл зорало аврэстар, тай о баро кан керэл иргатлыки э тикнэски. ");
INSERT INTO rmn_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Кана ало вахыти латэ тэ аракхлён о пуя, андэ латэ чячес сас чяворэ-огизя. ");
INSERT INTO rmn_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","О екх аракхлило лоло, тай алаи о тэни лэско сас учярдо балэнца, сар балалэ савутенца. Оничин лэс тхэдэ Исав. ");
INSERT INTO rmn_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Дэчи сикавдяспэс лэско пхрал, ов астарэласпэс вастэса ки патум ки Исавески. Оничин ов сас тхэдо Яков. Э Исаакески сас 60 брэш, кана он аракхлилэ ки Рэвэка. ");
INSERT INTO rmn_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","О чяворэ барилэ. О Исав сас лачё ахотники, мануш э ливаденго, ай о Яков сас мануш тэныки, ов бэшэлас машкарэ ко катунэс. ");
INSERT INTO rmn_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","О Исаак, саво дэхэлас о дами э вэшэнги гайваненго, зиядэ дэхэлас э Исавес, ай э Рэвэка зиядэ дэхэлас э Яковес. ");
INSERT INTO rmn_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Екхвар, кана о Яков тавэлас чёрба, о Исав ало катар ливади бут бокхало. ");
INSERT INTO rmn_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ов пхэнляс э Яковески: — Чяльти, дэ ман тэ хав набут одова лоло, со ту тавэс! Мэ мэрав катар бокх! (Аки соски лэс динэ нав Эдом). ");
INSERT INTO rmn_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","О Яков пхэнляс: — Хани бикин манги то баштутно аракхлипэ. ");
INSERT INTO rmn_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","— Мэ мэрав катар бокх, — пхэнляс о Исав. — Со манги файдас катар баштутно аракхлипэ? ");
INSERT INTO rmn_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","О Яков пхэнляс: — Хани ха совля. Ов халяс совля, тай аякха бикиндяс по баштутно аракхлипэ э Яковески. ");
INSERT INTO rmn_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Дэчи о Яков диняс э Исавэс манро тай чечевични чёрба. Ов халяс, пиляс, ущино тай гело. Аякха о Исав ачявдяс по баштутно аракхлипэ. ");
INSERT INTO rmn_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Опэр пху сас бокх, — на одоя баштутни бокх, сави сас, кана сас о Авраам, — тай о Исаак гело ко Авимелех, ко патишаи ки филистимляненго, андэ Герар. ");
INSERT INTO rmn_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","О Сагбус о Яхвэ сикавдяспэс э Исаакески тай пхэнляс: — Ма джя андэ Египти, бэш опэр одолэ пхуятэ, катэ Мэ кан пхэнав туки тэ бэшэс. ");
INSERT INTO rmn_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ачё опэр акалэ пхуятэ вахытески, тай Мэ кан овав туса тай кан алгыштияв тут. Мэ кан керав, сар Мэ халёмас совля тэ дадэски э Авраамески, тай кан дав алаи адала пхуя тэ пуендэ. ");
INSERT INTO rmn_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Мэ кан керав тэ пуен бут, сар чергэня опэр булутя, тай кан дав лэн алаи адала пхуя. Тэ пуендар кан диндён алгышы алаи о дюнядэс опэр пху, ");
INSERT INTO rmn_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","андар одолэстэ кай о Авраам шунэлас Ман тай керэлас, со Мэ пхэнавас, о пхэнлиматэс тай о тхэдиматэс. ");
INSERT INTO rmn_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Тай о Исаак накхло андэ Герар. ");
INSERT INTO rmn_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Кана о мануша одолэ тханэски пхучлэ лэстэ лэски ромнятар, ов пхэнляс: «Адая ми пхэн». Ов трашалас тэ пхэнэл: «Адая ми ромни». Ов тюшунды: «О мануша адалэ тханэски тэ на мударэн ман андар Рэвэка, вай ой шукар». ");
INSERT INTO rmn_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Екхвар, кана о Исаак бут вахыти бэшло отхэ, о Авимелех, о патишаи э филистимляненго, дикхляс андар пэнчира тай дикхляс, сар о Исаак сыпады пэ ромня э Рэвэка. ");
INSERT INTO rmn_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","О Авимелех диняс икос э Исаакес тай пхэнляс: — Акана, ой ти ромни! Соски ту пхэнлян: «Ой ми пхэн»? О Исаак пхэнляс лэски: — Вай мэ тюшундым, тэ на мэрав андар латэ. ");
INSERT INTO rmn_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Дэчи о Авимелех пхэнляс: — Со ту кердян амэнца? Екх андар мурша кан пашлёлас тэ ромняса, тай ту кан керэсас опэр амэндэ дош. ");
INSERT INTO rmn_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","О Авимелех пхэнляс алаи э дюняски: — Кажын, кон кан астарэл адалэ манушэс я лэски ромня, кан овэл мудардо. ");
INSERT INTO rmn_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","О Исаак читяс тэ барел гив опэр ливади одолэ пхуятэ тай одова жэ брэш кидиняс шэлвар бут. О Сагбус о Яхвэ алгышты лэс. ");
INSERT INTO rmn_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","О Исаак барвалило, тай о мангин лэско сальтя барёлас, бискай ов на уло бут барвало. ");
INSERT INTO rmn_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Лэстэ сас асавке барэ атарэс бакрэ, бузня, гурувня, тай аборкха иргатя, кай о филистимляня кизгандиенас лэс. ");
INSERT INTO rmn_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Он чёрдэ пху опэр алаи ко ханинга, савэ дага андэ вахыти лэски дадэско хранлэ о иргатя лэски дадэски э Авраамески. ");
INSERT INTO rmn_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","О Авимелех пхэнляс э Исаакески: — Джя амэндар. Ту улян бут зорало амэнги. ");
INSERT INTO rmn_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","О Исаак гело отхар андэ ливади Герар тай ачило отхэ тэ бэшэл. ");
INSERT INTO rmn_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","О Исаак шужардяс о ханинга, савэ сас хранлэ андэ вахыти лэски дадэско ки Авраамеско, ай дэчи савэ учярдэ о филистимляня пал лэски мэримастэ. Ов диняс лэн одола нава, савэ буруни диняс лэско дад. ");
INSERT INTO rmn_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","О иргатя э Исаакески лилэ тэ храндэн андэ ливади ханинг тай аракхлэ отхэ шужо пани, ");
INSERT INTO rmn_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","ай о герарскя чёбаня лилэ тэ ирищиен э Исаакески чёбаненца тай пхэнэнас: «Адава амаро пани!» Ов тхэдяс э ханинг Эсек, вай он ирищиенас лэнца. ");
INSERT INTO rmn_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Дэчи он хранлэ авэр ханинг, ай андар латэ ули чингар, оничин ов тхэдяс ла Ситна. ");
INSERT INTO rmn_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Ов гело отхар тай хранляс генэ екх ханинг, андар савятэ ирищима на сас, тай ов тхэдяс ла Реховот, пхэнэл: «Акана о Сагбус о Яхвэ диняс амэн тхан, тай амэ кан бутяс андэ адалэ пхуятэ». ");
INSERT INTO rmn_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Отхар о Исаак гело андэ Бээр-Шэва. ");
INSERT INTO rmn_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Андэ одоя рат о Сагбус о Яхвэ сикавдяспэс лэски тай пхэнляс: — Мэ о Дэл о Яхвэ тэ дадэско э Авраамеско. Ма траша, Мэ туса. Мэ кан алгыштияв тут тай кан бутярав тэ пуен булуб Мэ иргатески э Авраамески. ");
INSERT INTO rmn_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","О Исаак кердяс отхэ алтари, мангляс о нав э Сагбуски э Яхвэско тай тхэдяс отхэ катуна. Ай о иргатя лэски хранлэ ханинг. ");
INSERT INTO rmn_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","О Авимелех ало лэстэ андар Герар екхетханэ э Ахузатеса, пэ ярдымареса, тай э Пихолеса, лэски армияки барэса. ");
INSERT INTO rmn_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","О Исаак пхучляс лэн: — Соски тумэ алянус, вай тумэ санусас душманя манги тай кувдынус ман? ");
INSERT INTO rmn_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Он пхэнлэ: — Амэ акана галилям, кай туса о Сагбус о Яхвэ, тай амэ гиндям, кай машкарэ тутэ тай амэндэ камэл тэ овэл совленго зборима. Эла керас завети машкарэ амэндэ, ");
INSERT INTO rmn_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","кай ту на кан керэс амэнги джюнгалипэ, сар амэ на астардям тут, ами самас туса сальтя лаче тай муклям тут лачимаса. Акана ту алгыштимэ э Сагбуса э Яхвэса. ");
INSERT INTO rmn_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","О Исаак кердяс лэнги мисяфири, тай он ханас тай пиенас. ");
INSERT INTO rmn_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Авэр дес эртэс сабахтан он динэ екхаврэс совля. О Исаак зборисаило лэнца, тай он гелэ лэстар лачимаса. ");
INSERT INTO rmn_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Одова жэ дес о иргатя э Исаакески алэ тай пхукавдэ лэски катар ханинг, сави он хранлэ. Он пхэнлэ: — Амэ аракхлям пани! ");
INSERT INTO rmn_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ов тхэдяс ла Шыва, тай джи авдес о нав адалэ дизако — Бээр-Шэва. ");
INSERT INTO rmn_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Кана э Исавески сас саранда брэш, ов лиляс ромнян э Ехудита, э чяя э хетеески э Бээрески, тай э Басемата, э чяя э хетеески э Элонески. ");
INSERT INTO rmn_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Лэндар э Исаакески тай Рэвэкаки сас бут касывэти. ");
INSERT INTO rmn_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Кана о Исаак пхурило тай о якха лэски на дикхенас, ов диняс икос э Исавес, пэ барэ чявэс, тай пхэнляс лэски: — Мо чяво! — Мэ атхэ, — пхэнляс о Исав. ");
INSERT INTO rmn_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","О Исаак пхэнляс: — Мэ ужэ пхуро, тай на джянав о дес мэ мэримаско. ");
INSERT INTO rmn_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Лэ то мултуки — тэ стриладэс тай то луки — тай никлё андэ ливади тэ аракхес манги гайванен. ");
INSERT INTO rmn_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Тав манги хапэ, саво мэ дэхав, тай ан манги тэ хав, тэ алгыштияв тут ангал мэ мэримастэ. ");
INSERT INTO rmn_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Э Рэвэка шунляс, сар о Исаак зборизэлас пэ чявэса э Исавеса. Кана о Исав гело ки ливади тэ мударэл тай тэ анэл гайванес, ");
INSERT INTO rmn_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","э Рэвэка пхэнляс пэ чявэски э Яковески: — Мэ шунлём, сар то дад пхэнляс тэ пхралэски э Исавески: ");
INSERT INTO rmn_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","«Ан гайванес тай тав манги дамлыс хапэ, мэ тэ алгыштияв тут ангал Сагбус Яхвэ, бискай мэрав». ");
INSERT INTO rmn_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Шун ман лачес, мо чяво, тай кер, сар мэ кан пхэнав. ");
INSERT INTO rmn_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Джя ки атара тай ан манги до зиядэ бузнорэн, тэ керав мэ дамлыс хапэ тэ дадэски, асавко, сар ов дэхэл. ");
INSERT INTO rmn_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Дэчи гел лэс тэ дадэстэ, ов кан хал тай кан алгыштиел тут ангал пэ мэримастэ. ");
INSERT INTO rmn_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","О Яков пхэнляс э Рэвэкаки, пэ дэяки: — Вай мо пхрал о Исав алаи балало, ай мандэ э моркхи би балэнги. ");
INSERT INTO rmn_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ами, мо дад тэ сыладиела ман? Мэ кан овав ангал лэстэ хохавно тай кан лав опэр мандэ арманя, ами на алгыштима. ");
INSERT INTO rmn_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Э дай пхэнляс лэски: — О арманя мэ овэн опэр мандэ, мо чяво, ай ту кер, сар мэ пхэнав: джя тай ан бузнорэн. ");
INSERT INTO rmn_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ов гело, лиляс э бузнорэн тай андяс лэн пэ дэятэ, тай ой тавдяс дамлыс хапэ, асавко, сар дэхэл о дад. ");
INSERT INTO rmn_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Дэчи э Рэвэка лиляс о лаче савутя пэ барэ чявэски э Исавески, савэ сас латэ андэ кхер, тай урявдяс опэр тикно, опэр Яков, ");
INSERT INTO rmn_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","ай лэски васта тай э мэн, катэ нанай бала, учярдяс э бузнорэнги моркхяса. ");
INSERT INTO rmn_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Дэчи ой диняс пэ чявэс э Яковес дамлыс хапэ тай манро, савэ тавдяс. ");
INSERT INTO rmn_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Ов ало пэ дадэстэ тай пхэнляс: — Мо дад! — Аки мэ, — пхэнляс одова. — Ту саво андар мэ чявэндэ? ");
INSERT INTO rmn_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","О Яков пхэнляс пэ дадэски: — Мэ — о Исав, то баштутно. Мэ кердём, сар ту пхэнлян. Мангав, ваздэтут, бэш тай ха мэ гайванен, ту тэ алгыштиес ман. ");
INSERT INTO rmn_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","О Исаак пхучляс пэ чявэс: — Сар ту аракхлян лэн аякха чяльти, мо чяво? — То Сагбус о Яхвэ диняс ман лачипэ, — пхэнляс ов. ");
INSERT INTO rmn_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","О Исаак пхэнляс э Яковески: — Пашо пашэ, мэ тэ сыладияв тут, мо чяво, чячес ту мо чяво о Исав я на. ");
INSERT INTO rmn_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","О Яков пашыло пашэ пэ дадэстэ ко Исаак, саво сылады лэс тай пхэнляс: — О сэси — сар ко Яков, ай о васта — сар ко Исав. ");
INSERT INTO rmn_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ов на пэнджярдяс лэс, вай о васта лэстэ сас балалэ, сар ко Исав, тай ов алгышты лэс. ");
INSERT INTO rmn_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","— Чячес ту мо чяво о Исав? — пхучляс о Исаак. Ов пхэнляс: — Ва, адава мэ. ");
INSERT INTO rmn_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","О Исаак пхэнляс: — Мо чяво, ан манги то хапэ пашэ, тай мэ кан хав, ай дэчи кан алгыштияв тут. О Яков диняс лэс о хапэ, тай ов халяс, андяс винас тай ов пиляс. ");
INSERT INTO rmn_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Дэчи лэско дад о Исаак пхэнляс лэски: — Пашо, мо чяво, тай чюмидэ ман. ");
INSERT INTO rmn_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Ов пашыло тай чюмидиняс лэс, тай пхэнляс: — Вай, мо чяво кхандэл, сар кхандэл э ливади, сави алгышты о Сагбус о Яхвэ. ");
INSERT INTO rmn_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","О Дэл мэ дэл тут катар булутенго пани тай катар имиша ки пхуяки, бут гив тай тэрно винас. ");
INSERT INTO rmn_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","О породэс мэ керэн туки иргатлыки, тай дюнядэс мэ бангён туки. Ов сагбус опэр тэ пхралэндэ, тай мэ бангён ангал тутэ о чявэ тэ дэякерэ. Мэ диндёл арманя одова, саво дэл тут арманя, ай кон алгыштиел тут, мэ овэл алгыштимэ. ");
INSERT INTO rmn_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Сар о Исаак бытэрды тэ алгыштиел тай о Яков никлисто пэ дадэстар, ало катар астардипэ лэско пхрал о Исав. ");
INSERT INTO rmn_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ли ов тавдяс дамлыс хапэ тай андяс пэ дадэски. Ов пхэнляс лэски: — Дадэ, ваздэтут, бэш тай ха мо хапэ, ай дэчи алгыштие ман. ");
INSERT INTO rmn_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Лэско дад о Исаак пхучляс: — Кон ту? — Мэ то чяво, — пхэнляс ов, — то баштутно, о Исав. ");
INSERT INTO rmn_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","О Исаак алаи изранило тай пхэнляс: — Кон эсас одова, саво мудардяс гайванес тай андяс манги? Мэ халём лэс ангал отхэ, кай ту алян, тай алгыштым лэс. Ов акана да кан овэл алгыштимэ! ");
INSERT INTO rmn_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","О Исав шунляс о зборэс пэ дадэски, лачес диняс бэбэря тай пхэнляс пэ дадэски: — Алгыштие ли ман, дадэ! ");
INSERT INTO rmn_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ай одова пхэнляс: — То пхрал ало ярамазлыкеса тай лиляс тутар о алгышы. ");
INSERT INTO rmn_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","О Исав пхэнляс: — На чячимаса ов тхэдо Яков? Дувар ов хохавдяс ман: лиляс мо баштутно аракхлипэ, акана ли мо алгышы! Тай пхучляс: — На ачило тутэ алгышы ли манги? ");
INSERT INTO rmn_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","О Исаак пхэнляс э Исавески: — Мэ кердём лэс сагбус опэр тутэ, тай алаи лэски тухумен динём лэстэ тэ овэн иргатя, тай башладым лэс манрэса тай тэрнэ винаса. Со камэл мэ акана тэ керав туки, мо чяво? ");
INSERT INTO rmn_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","О Исав пхэнляс пэ дадэски: — Тутэ екх алгышы си, дадэ? Алгыштие ли ман, мо дад! О Исав лачес руно. ");
INSERT INTO rmn_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Лэско дад о Исаак пхэнляс лэски: — Кан овэл то бэшыпэ дур катар имиша ки пхуяки, дур катар пани ки булутенго опрал. ");
INSERT INTO rmn_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ту кан бэшэс камаса тай кан керэс иргатлыки тэ пхралэски. Кан авэл вахыти, кана ту кан ваздиндёс, ту кан чес лэско пхарипэ опрал тэ мэнятэ. ");
INSERT INTO rmn_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","О Исав гаравдяс холи опэр Яков андар алгыштима, саво диняс лэс о дад, тай пхэнляс пэски: «О деса э роимаски пал мэ дадэстэ пашэ — дэчи мэ кан мударав мэ пхралэс э Яковес». ");
INSERT INTO rmn_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Э Рэвэкаки пхэнлэ, со пхэнляс лако баро чяво о Исав, тай ой бичялдяс пал тикно чяво, пал Яков, тай пхэнляс лэски: — То пхрал о Исав тюшундиел тэ мударэл тут. ");
INSERT INTO rmn_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Мо чяво, кер, сар кан пхэнав: чяльти праста андэ Харан мэ пхралэстэ ко Лаван. ");
INSERT INTO rmn_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Бэш лэстэ саво-то вахыти, бискай на кан тэныкизэл э холи тэ пхралэски. ");
INSERT INTO rmn_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Кана э холи тэ пхралэски кан тэныкизэл тай ов кан бристэл одова, со ту кердян лэски, дэчи мэ кан бичялав тэ пхэнэн туки, кай камэл тэ авэс палэ. Соски манги тэ нашавав тумэн э дон андэ екх дес? ");
INSERT INTO rmn_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Дэчи э Рэвэка пхэнляс э Исаакески: — Мэ бэшымаски на лошазав андар адалэ чяяндэ ки хетеенги. О Яков тэ лэла пэски ромня аканутнэ джювля, асавкя хетеянка, дэчи соски мэ тэ бэшав? ");
INSERT INTO rmn_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","О Исаак диняс икос э Яковес, алгышты лэс тай пхэнляс лэски: — Ма лэ ромня ханаанеянка. ");
INSERT INTO rmn_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Джя андэ Паддан-Арам, андэ кхер ко Бетуил, тэ дэяки дадэстэ. Лэ отхэ туки ромня андар чяя ки Лаванески, тэ дэяки пхралэстэ. ");
INSERT INTO rmn_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","О Дэл о Баро-Зорало мэ алгыштиел тут тай мэ дэл тут бутэ пуен, тутар тэ овэн бут дюнядэс. ");
INSERT INTO rmn_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Мэ дэл Ов тут тай тэ пуен о алгышы э Авраамеско, тутэ тэ овэл э пху, опэр савятэ ту анкха бэшэс, сар джяти, э пху, сави о Дэл диняс э Авраамес. ");
INSERT INTO rmn_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Дэчи о Исаак бичялдяс э Яковес, тай одова гело андэ Паддан-Арам ко Лаван, ко чяво ки арамееско ки Бетуилеско, ко пхрал ки Рэвэкако, э Яковески тай э Исавески дай. ");
INSERT INTO rmn_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","О Исав галило, кай о Исаак алгышты э Яковес тай бичялдяс лэс андэ Паддан-Арам, тэ лэл отхар ромня, кай ов алгышты лэс тай пхэнляс лэски: «Ма лэ ромня ханаанеянка», ");
INSERT INTO rmn_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","тай кай о Яков шунляс пэ дадэс тай пэ дэя тай гело андэ Паддан-Арам. ");
INSERT INTO rmn_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Дэчи о Исав галило, сар лэско дад о Исаак на мангелас ханаанеянкен. ");
INSERT INTO rmn_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","О Исав гело ко Измаил тай лиляс пэски ромня, булуб одолэндар, савэ лэстэ сас, э Махалатя, э Невайотаски пхэня, э Авраамеско чяво Измаилески чяя. ");
INSERT INTO rmn_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","О Яков ачявдяс э Бээр-Шэва тай гело андэ Харан. ");
INSERT INTO rmn_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Ов ало савэ-то тханэстэ тай тэрдило ратяки, вай о кхам бэшло. Ов лиляс отхэ бар, тхэдяс тал пэ шэрэстэ тай пашлило тэ совэл. ");
INSERT INTO rmn_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ов дикхляс суно: аки драбина, сави сас тэрди опэр пху тай сас джи ко булутя, тай о миляикя э Дэвлэски ваздэнаспэс тай фуленас опрал. ");
INSERT INTO rmn_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Опэр латэ сас тэрдо о Сагбус о Яхвэ тай пхэнэлас: — Мэ — о Сагбус о Яхвэ, о Дэл тэ дадэско э Авраамеско тай о Дэл э Исаакеско. Э пху, опэр савятэ ту анкха пашло, Мэ кан дав тут тай тэ пуен. ");
INSERT INTO rmn_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Тэ пуя кан овэн бут, сар пхуяко прахос, тай ту кан бутёс карин запад тай карин вастоки, карин север тай карин юги. Алаи о дюнядэс опэр пху кан диндён алгышы андар тутэ тай тэ пуендэ. ");
INSERT INTO rmn_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Мэ туса тай кан кутардияв тут, кай ту тэ на джяс, тай кан анав тут андэ адая пху. Мэ на кан ачявав тут тай кан керав алаи, со пхэнлёмас туки. ");
INSERT INTO rmn_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","О Яков джянгавдило тай тюшунды: «Чячес, адалэ тханэстэ о Сагбус о Яхвэ, ай мэ джи на джянавас». ");
INSERT INTO rmn_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ов трашанило тай пхэнляс: — Сар трашавэл адава тхан! Сар кай атхэ о кхер э Дэвлэски, тай адава — э бар э булутенги. ");
INSERT INTO rmn_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","О Яков ущино эртэс сабахтан, лиляс о бар, саво сас тал шэро, тхэдяс о бар тэрдиндос тай чёрдяс опэр лэстэ маслинаки олия. ");
INSERT INTO rmn_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ов тхэдяс адава тхан Вефиль, ай ангал одоя диз бучёлас Луз. ");
INSERT INTO rmn_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Дэчи о Яков халяс совля, тай пхэнляс: — О Дэл тэ овэла манца, тэ кутардиела ман опэр адалэ дромэстэ, тэ дэла ман манро тай хапэ тай савутя, ");
INSERT INTO rmn_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","тай мэ тэ авава тай тэ бэшава андэ рагати андэ кхер мэ дадэстэ, дэчи о Сагбус о Яхвэ кан овэл мо Дэл. ");
INSERT INTO rmn_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Тай адава бар, саво мэ тхэдём, сар сикаипэ, кан овэл э Дэвлэско кхер, тай алаестар, со Ту кан дэс ман, мэ кан дав Тут дэшто паи. ");
INSERT INTO rmn_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","О Яков гело англэ по дром тай ало ки пху ко васточня дюнядэс. ");
INSERT INTO rmn_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Отхэ ов дикхляс ханинг ки ливади тай паш латэ трин атарэс бакрэн, вай андар одолэ ханингатэ пиявдярэнас э гайванен. Э ханинг сас пханли барэ барэса. ");
INSERT INTO rmn_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Кана алаи о атарэс кидэнаспэс, о чёбаня пэравэнас опрал ханинг тай пиявдярэнас э бакрэн, ай дэчи тхэнас о бар палэ одолэ тханэстэ. ");
INSERT INTO rmn_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","О Яков пхучляс ко чёбаня: — Пхралалэн, катар тумэ? — Амэ андар Харан, — пхэнлэ он. ");
INSERT INTO rmn_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ов пхэнляс лэнги: — Джянэн тумэ э Лаванес, э Нахорески турунес? — Ва, джянас, — пхэнлэ он. ");
INSERT INTO rmn_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","О Яков пучляс: — Лэстэ алаи лачё ? — Лачё, — пхэнлэ он. — Ай аки э Рахиль, лэски чяй, авэл э бакрэнца. ");
INSERT INTO rmn_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","— О кхам дага учес, — пхэнляс ов, — дага нанай о вахыти тэ кидэс о атарэс. Пиявдярэн э бакрэн тай кувдиен лэн палэ ки ливади. ");
INSERT INTO rmn_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","— Амэ нащи, — пхэнлэ он, — бискай на кидэнпэс алаи о атарэс, тай о бар на кан пэравэн катар ханинг. Дэчи амэ кан пиявдярас э бакрэн. ");
INSERT INTO rmn_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Ов дага зборизэлас лэнца, тай пашыли э Рахиль э бакрэнца: ой чярярэлас э бакрэн. ");
INSERT INTO rmn_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Кана о Яков дикхляс э Рахиля, пэ какески э Лаванески чяя, ов пашыло, пэравдяс о бар катар ханинг тай пиявдярдяс э Лаванески бакрэн. ");
INSERT INTO rmn_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Дэчи о Яков чюмидиняс э Рахиля тай лачес руно, ");
INSERT INTO rmn_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","пхэнляс э Рахиляки, кай ов — тухуми лаки дадэско тай о чяво э Рэвэкако. Ой прастанили тай пхукавдяс адава пэ дадэски. ");
INSERT INTO rmn_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","О Лаван шунляс, кай ало лэско племянники о Яков, прастанило мамуй, диняс лэс ангали, чюмидиняс тай андяс пэстэ андэ кхер. О Яков пхукавдяс лэски алаестар, ");
INSERT INTO rmn_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","тай о Лаван пхэнляс: — Ту мо тэни тай мо рат. Кана о Яков бэшло лэстэ чён, ");
INSERT INTO rmn_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","о Лаван пхэнляс лэски: — Хоч ту сан манги тухуми, соски ту камэл тэ керэс манги бути ботени? Пхэн манги, со туки тэ покинав. ");
INSERT INTO rmn_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Ай ко Лаван сас дуй чяя: э бари бучёлас Лия, ай э тикни — Рахиль. ");
INSERT INTO rmn_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Ки Лия сас лаче шукара якха, ай ки Рахиль сас шукар ли о муй, ли о тэни. ");
INSERT INTO rmn_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","О Яков дэхляс э Рахиля тай пхэнляс э Лаванески: — Мэ кан керав бути туки эфта брэш андар тэ тикнэ чяятэ ки Рахиль. ");
INSERT INTO rmn_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","О Лаван пхэнляс: — Зиядэ мэ кан дав ла тутэ, ниш кастэ-то аврэстэ. Ачё мандэ. ");
INSERT INTO rmn_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","О Яков кердяс иргатлыки эфта брэш, тэ лэл э Рахиля, ай он дикхиндилэ лэски, сар набут дес, вай ов дэхэлас ла. ");
INSERT INTO rmn_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Дэчи о Яков пхэнляс э Лаванески: — Дэ ман мэ ромня, тэ бэшав ласа сар ромняса, ало мо вахыти. ");
INSERT INTO rmn_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","О Лаван диняс икос алаен, кай бэшэнас агорял, тай кердяс мисяфири. ");
INSERT INTO rmn_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ай кана ули бэлвэль, ов лиляс пэ чяя э Лия тай диняс ла ко Яков, тай о Яков пашлило ласа. ");
INSERT INTO rmn_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(О Лаван диняс пэ чяя иргатинка э Зилпа.) ");
INSERT INTO rmn_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Кана уло сабаги, о Яков галило, кай адая э Лия! Ов пхэнляс э Лаванески: — Со ту кердян манца? Мэ вай кердём иргатлыки туки андар Рахиль. Соски ту хохавдян ман? ");
INSERT INTO rmn_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","О Лаван пхэнляс: — Амэндэ аякха на керэн, тэ дэс ромэстэ э тикнэ чяя ангал бари. ");
INSERT INTO rmn_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Бэш базари адалэ чяяса, ай дэчи амэ кан дас тут ли э тикня, аврэ эфта брэшэнги иргатлыкески. ");
INSERT INTO rmn_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","О Яков аякха да кердяс: бэшло базари э Лияса, ай дэчи о Лаван диняс лэс ромня пэ чяя э Рахиля. ");
INSERT INTO rmn_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","О Лаван диняс э Рахиля пэ иргатинка э Билха. ");
INSERT INTO rmn_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","О Яков лиляс тэ бэшэл э Рахиляса тай дэхэлас э Рахиля бут, ниш э Лия. Ов керэлас бути э Лаванески генэ эфта брэш. ");
INSERT INTO rmn_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Кана о Сагбус о Яхвэ дикхляс, кай о Яков на дэхэлас э Лия, Ов кердяс, тэ овэн латэ пуя. Ай э Рахиль сас би пуенги. ");
INSERT INTO rmn_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Э Лия насвалили пуёстэ тай аракхлило латэ чяво. Ой пхэнляс: «О Сагбус о Яхвэ дикхляс мо касывэти. Акана мо ром, гэлбэтэм, кан дэхэл ман», тай тхэдяс лэс Рувим. ");
INSERT INTO rmn_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Ой генэ насвалили пуёстэ, тай кана аракхлило латэ чяво, пхэнляс: «Аякха кай о Сагбус о Яхвэ шунляс, кай ман на дэхэл, Ов диняс ман генэ ли адалэс». Тай ой тхэдяс лэс Симеон. ");
INSERT INTO rmn_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Ой генэ насвалили пуёстэ, тай кана латэ аракхлило чяво, пхэнляс: «Акана мо ром кан колизэл мандэ, вай мандэ аракхлилэ лэски трин чявэ». Оничин ов сас тхэдо Левий. ");
INSERT INTO rmn_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Тай генэ ой насвалили пуёстэ, тай кана аракхлило чяво, пхэнляс: «Адава рази мэ кан махтадияв э Сагбус э Яхвэс». Оничин ой тхэдяс лэс Иуда. Дэчи латэ на аракхлёнас пуя. ");
INSERT INTO rmn_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Э Рахиль дикхелас, кай латэ на аракхлён пуя э Яковески, тай кизганды пэ пхэня э Лия. Ой пхэнляс э Яковески: — Дэ ман пуен, я мэ кан мэрав! ");
INSERT INTO rmn_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","О Яков холясаило лаки тай пхэнляс: — Та со, мэ о Дэл, Саво на дэл тут пуен? ");
INSERT INTO rmn_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ой пхэнляс: — Аки э Билха, ми иргатинка. Пашлё ласа, латэ тэ аракхлёл пуёс, савэс мэ кан лав опэр мэ кочендэ, тай мэ кан гинав лэс минрэс. Аякха мандэ кан овэн пуя латар. ");
INSERT INTO rmn_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Аякха ой диняс лэс ромня пэ иргатинка э Билха. О Яков пашлило ласа, ");
INSERT INTO rmn_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","ой насвалили пуёстэ, тай аракхлило лэски чяво. ");
INSERT INTO rmn_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Дэчи э Рахиль пхэнляс: «О Дэл кердяс манги чячё цындос. Ов шунляс мо мангипэ тай диняс ман чявэс». Оничин ой тхэдяс лэс Дан. ");
INSERT INTO rmn_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Э Билха, э иргатинка Рахиляки, генэ насвалили пуёстэ, тай аракхлило латэ дуйто чяво э Яковески. ");
INSERT INTO rmn_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Дэчи э Рахиль пхэнляс: «Барэ маримаса маравасман мэ мэ пхэняса тай улём ангал». Тай ой тхэдяс лэс Неффалим. ");
INSERT INTO rmn_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Э Лия дикхляс, кай латэ на аракхлён пуя, лиляс пэ иргатинка э Зилпя тай диняс ла ко Яков ромня. ");
INSERT INTO rmn_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Ки Лияки иргатинка ки Зилпа аракхлило чяво э Яковески. ");
INSERT INTO rmn_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Дэчи э Лия пхэнляс: «Со бахт!» Тай ой тхэдяс лэс Гад. ");
INSERT INTO rmn_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Ки Лияки иргатинка ки Зилпа аракхлило дуйто чяво э Яковески. ");
INSERT INTO rmn_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Дэчи э Лия пхэнляс: «Со мэ бахтали! О джювля кан пхэнэн манги бахталие!» Тай ой тхэдяс лэс Асир. ");
INSERT INTO rmn_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","О вахыти, кана кидэнас о гив, о Рувим никлисто ки ливади, аракхляс мандрагоря тай андяс лэн пэ дэяки. Э Рахиль пхэнляс э Лияки: — Мангав, тут дэ ман мандрагоря тэ чявэски. ");
INSERT INTO rmn_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ай одоя пхэнляс лаки: — Ту ли аякха лилян мэ ромэс. Мангес акана тэ лэс ли о мандрагоря мэ чявэски? — Лачё, — пхэнляс э Рахиль, — мэ пашлёл ов туса авдес рати, ай ту дэ ман о мандрагоря тэ чявэски. ");
INSERT INTO rmn_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Кана бэлвэле о Яков ало катар ливадя, э Лия никлисти тэ ишандиел лэс тай тэ пхэнэл: — Ту камэл тэ пашлёс манца. Мэ покиндём андар тутэ о мандрагоря мэ чявэски. Тай ов пашлило ласа одоя рат. ");
INSERT INTO rmn_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","О Дэл шунляс э Лия, ой насвалили пуёстэ, тай латэ аракхлило э Яковески панджто чяво. ");
INSERT INTO rmn_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Дэчи э Лия пхэнляс: «О Дэл алгышты ман андар одолэстэ, кай мэ динём мэ ромэс мэ иргатинка». Тай ой тхэдяс лэс Иссахар. ");
INSERT INTO rmn_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Э Лия генэ насвалили пуёстэ, тай латэ аракхлило э Яковески шовто чяво. ");
INSERT INTO rmn_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Дэчи ой пхэнляс: «О Дэл башлады ман багалыс башладипэ. Акана мо ром кан гинэл ман, вай мандэ аракхлилэ лэски шов чявэ». Тай ой тхэдяс лэс Завулон. ");
INSERT INTO rmn_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Савэ-то вахытестар латэ аракхлили чяй, тай тхэдяс ла Дина. ");
INSERT INTO rmn_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Дэчи о Дэл тюшунды катар Рахиль. Ов шунляс ла тай пхутэрдяс ла. ");
INSERT INTO rmn_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ой насвалили пуёстэ, тай латэ аракхлило чяво. Ой пхэнляс: «О Дэл лиляс мо ладжяво». ");
INSERT INTO rmn_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ой пхэнляс: «Мэ дэл ман о Сагбус о Яхвэ генэ екхе чявэс», тай тхэдяс лэс Иосиф. ");
INSERT INTO rmn_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Пал отхэ сар ки Рахиль аракхлило о Иосиф, о Яков пхэнляс э Лаванески: — Мук ман тэ джяв палэ мэ чяче ригендэ. ");
INSERT INTO rmn_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Дэ ман мэ ромнен тай мэ пуен, андар савэндэ мэ кердём туки бути, тай мэ кан джяв ко дром. Ту джянэс, сар бут мэ керавас бути туки. ");
INSERT INTO rmn_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Ай о Лаван пхэнляс лэски: — Мэ тэ аракхлём мила андэ тэ якхендэ, мангав тут, ачё. Мэ галилём андар дорикерипэ, кай о Сагбус о Яхвэ алгыштиел ман булуб туки. ");
INSERT INTO rmn_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","— Тай пхэнляс: — Пхэн ти кими, мэ кан покинав ла. ");
INSERT INTO rmn_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","О Яков пхэнляс лэски: — Ту джянэс, сар мэ керавас бути туки тай касавке си тэ атарэс булуб мэ бутяки. ");
INSERT INTO rmn_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Лэн сас набут ангал отхэ, кай мэ алём, ай акана он бутилэ. О Сагбус о Яхвэ алгыштиел тут андар мандэ. Кана мэ кан кидав шо-то мэ кхерэски? ");
INSERT INTO rmn_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","О Лаван пхучляс: — Со тэ дав тут? — Манги ништо на камэл, — пхэнляс о Яков. — Кер манги екх, тай мэ англэ кан чярярав тай кан кутардияв тэ атарэс: ");
INSERT INTO rmn_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","мук ман тэ накхав алаи тэ атарэс тай тэ лав отхар э тапенги бакрэн, алаи э калэ бакрорэн тай алаи э тапенги бузнэн. Он да кан овэн ми кими. ");
INSERT INTO rmn_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Асавке палящимаса ту сальтя кан джянэс, алаи о чячипэ. Тэ дикхеса андэ мэ атаратэ бузнэн би тапенги я би полоскенги я парнэ бакрэн, тэ джянэс — кай адала чёрдиканэ. ");
INSERT INTO rmn_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","-— Лачё, — пхэнляс о Лаван. — Мэ овэл аякха, сар ту пхэнлян. ");
INSERT INTO rmn_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Одова жэ дес ов паляшты алаи э бузнэн э тапенца, алаи э тапенги бузнян — одолэн, опэр савэндэ сас парно, — тай алаи э калэ бакрорэн тай диняс лэн тэ дикхел пал лэндэ о чявэ. ");
INSERT INTO rmn_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Ов пхэнляс тэ овэл машкарэ лэстэ тай ко Яков дурипэ трин дес дром. Ай о Яков англэ чярярэлас э Лаванески авэрэн бакрэн тай бузнен. ");
INSERT INTO rmn_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","О Яков чингердяс веткес катар парно топаль, миндали тай чинари тай кердяс опэр лэндэ парнэ полоскес, шужардяс опрал тай нангярдяс о парно кашт андар. ");
INSERT INTO rmn_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Ов тхэдяс о чингердэ веткес алаи андэ копанэс, тэ овэн он доврус ангал бакрэ тай бузня, кана о гайваня авэнас тэ пиен. О вахыти о гайваня лэнаспэс. ");
INSERT INTO rmn_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Он лэнаспэс ангал веткес, тай о гайваня аракхлёнас тапенца. ");
INSERT INTO rmn_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Генэ о Яков болдэлас лэн карин тапенги тай карин калэ бакрэ тай бузня, савэ сас э Лаванески, ай э тэрнэн тхэлас аврэтхэ. Аякха лэстэ улэ лэски атарэс, тай ов астарэлас лэн аврэтхэ катар атарэс ки Лаванески. ");
INSERT INTO rmn_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Кана авэнас тэ пиен о зоралэ гайваня, о Яков тхэлас ангал лэндэ андэ копана веткес, он тэ лэнпэс ангал веткес. ");
INSERT INTO rmn_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ай о гайваня тэ на сас зоралэ, ов на тхэлас веткес. О назоралэ гайваня ачёнас э Лаванески, ай о зоралэ — э Яковески. ");
INSERT INTO rmn_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","О Яков лиляс тэ барвалёл, лэстэ акана сас барэ атарэс, тай генэ иргатинкес, иргатя, камилэс тай джёрэ. ");
INSERT INTO rmn_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","О Яков шунляс, сар о чявэ э Лаванески пхэнэнас: «О Яков лиляс алаи, со сас амарэ дадэстэ. Ов кидиняс пэски барвалипэ булуб амарэ дадэски». ");
INSERT INTO rmn_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","О Яков дикхляс, кай о Лаван сас лэса на аякха, сар буруни. ");
INSERT INTO rmn_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","О Сагбус о Яхвэ пхэнляс э Яковески: — Джя ки пху ки дадэнги, тэ тухумендэ, тай Мэ кан овав туса. ");
INSERT INTO rmn_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","О Яков бичялдяс тэ пхэнэн э Рахиляки тай э Лияки, тэ никлён он ки ливади, катэ сас лэски атарэс. ");
INSERT INTO rmn_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Ов пхэнляс лэнги: — Мэ дикхав, кай тумаро дад манца на аякха, сар буруни. Ай о Дэл мэ дадэско манца. ");
INSERT INTO rmn_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Тумэ джянэн, кай мэ керавас бути тумарэ дадэски алаи мэ зораса, ");
INSERT INTO rmn_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","ай тумаро дад хохавэлас ман, дэшвар паровэлас мо покинипэ. Ай о Дэл на диняс ман лэстэ андэ хурлуки. ");
INSERT INTO rmn_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Ов тэ пхэнэлас: «О покинипэ тинро кан овэл тапенги», алаи ко гайваня аракхлёнас тапенца, ай ов тэ пхэнэлас: «О покинипэ тинро кан овэн о чюбаря», алаи ко гайваня аракхлёнас чюбаря. ");
INSERT INTO rmn_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Аякха о Дэл лиляс э гайванен тумарэ дадэстэ тай диняс мандэ. ");
INSERT INTO rmn_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Екхвар, одова вахыти, кана лэнпэс о гайваня, мэ дикхлём суно: мэ ваздинём мэ якха тай дикхлём, кай о бузнэ, кай учярэнас э бузнян, сас полосатя тапенги тай чюбаря. ");
INSERT INTO rmn_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","О Миляики э Дэвлэско пхэнляс манги андэ суно: «Яков». Мэ пхэнлём: «Мэ атхэ». ");
INSERT INTO rmn_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ов пхэнляс: «Дикх, тай ту кан дикхес: алаи о бузня, кай учярэн э гайванен, — полосатя, чюбаря я тапенги. Мэ дикхлём, со кердяс туки о Лаван. ");
INSERT INTO rmn_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Мэ — о Дэл э Вефилеско, катэ ту чёрдян э маслинаки олия опэр тэрдо бар тай халян совля Манги. Ачяв адая пху тай джя палэ ки пху, катэ ту аракхлилян». ");
INSERT INTO rmn_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Э Рахиль тай э Лия пхэнлэ: — Ва ай си амэндэ генэ паи андэ мангин амарэ дадэско? ");
INSERT INTO rmn_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Та со, на дикхиндёл, кай ов гинэл амэн джятен? Ов бикиндяс амэн тай тхэдяс одова, со лиляс амэнги. ");
INSERT INTO rmn_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Гэлбэтэм, алаи о барвалипэ, саво о Дэл лиляс амарэ дадэстар, амаро си тай амарэ пуенго. Самким кер, сар пхэнэл туки о Дэл. ");
INSERT INTO rmn_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","О Яков бэшавдяс э пуен тай э ромнен опэр камилэс, ");
INSERT INTO rmn_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","кувды алаи э гайванен ангал пэстэ, лиляс алаи о мангин, саво ов кидиняс андэ Паддан-Арам, тай гело ко дром пэ дадэстэ ко Исаак ки пху Ханаан. ");
INSERT INTO rmn_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Кана о Лаван гело тэ моравэл э бакрэн, э Рахиль чёрдяс лэски дэвлэн. ");
INSERT INTO rmn_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Ай о Яков хохавдяс э арамеес э Лаванес, на пхэнляс лэски, кай джялпэски. ");
INSERT INTO rmn_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Ов нашло алаи пэ мангинэса, накхло э диряв тай гело ко горадэс Галаад. ");
INSERT INTO rmn_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Ко трито дес э Лаванески пхэнлэ, кай о Яков нашло. ");
INSERT INTO rmn_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","О Лаван лиляс пэса э тухумен, прастанило пал Яков тай эфта десендар аракхляс лэс андэ горадэс Галаад. ");
INSERT INTO rmn_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ай рати о Дэл сикавдяспэс э арамеески э Лаванески андэ суно тай пхэнляс лэски: «Сакёв, ма пхэн ништо э Яковески, нэ лачё, нэ джюнгало». ");
INSERT INTO rmn_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","О Лаван рэсло э Яковес. О Яков тхэдяс катуна андэ горадэс Галаад, ли о Лаван э тухуменца тхэдяс катуна отхэ. ");
INSERT INTO rmn_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","О Лаван пхэнляс э Яковески: — Со ту кердян? Ту хохавдян ман тай гелдян мэ чяян, сар пханлимарен ко марипэ. ");
INSERT INTO rmn_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Соски ту нашлян чёриндос? Соски ту на пхэнлян манги, тэ мукав тут лошаса тай гиленца, бубнэнца тай арфэнца? ");
INSERT INTO rmn_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ту на динян ман джи тэ чюмидав мэ турунен тай мэ чяян, кай джянпэски. Ту кердян битюшундимаски дила. ");
INSERT INTO rmn_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Мандэ си зор тэ керав туки джюнгалипэ, ай окоя рат о Дэл тэ дадэско пхэнляс манги: «Сакёв, ма пхэн э Яковески ништо, нэ лачё, нэ джюнгало». ");
INSERT INTO rmn_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Самким, ту гелян, вай ту манглян тэ джяс андэ кхер тэ дадэстэ, ами соски ту чёрдян мэ дэвлэн? ");
INSERT INTO rmn_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","О Яков пхэнляс э Лаванески: — Мэ трашавас тай тюшундиявас, кай ту зораса кан лэс мандар тэ чяян. ");
INSERT INTO rmn_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Ту тэ аракхеса атхэ кастэ-то тэ дэвлэн, одова на кан бэшэл. Ангал тэ тухумендэ дикх ту сам, си мандэ шо-то тинро. Тэ си, лэ палэ. О Яков на джянэлас, кай э дэвлэн чёрдяс э Рахиль. ");
INSERT INTO rmn_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","О Лаван диняс андэ катуна ки Яковески, андэ катуна ки Лияки тай андэ катуна до иргатинкенги, тай ништо на аракхляс. Пал ки катуна ки Лияки ов диняс андэ катуна ки Рахиляки. ");
INSERT INTO rmn_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Э Рахиль лиляс э кхерутнэ дэвлэн тай тхэдяс лэн андэ камилако сидлас тай бэшли опэр лэндэ. О Лаван родиняс алаи э катуна тай ништо на аракхляс. ");
INSERT INTO rmn_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Э Рахиль пхэнляс пэ дадэски: — Ма холязэ, мо сагбус, мэ нащи ущяв ангал тутэ, вай мандэ одова, со овэл ко джювля. Сар ов на родэлас, ов нащи аракхляс э дэвлэн. ");
INSERT INTO rmn_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","О Яков сас бут холямэ тай лиляс тэ пхэнэл э Лаванески: — Андэ состэ мо джюнгалипэ? — пхучляс ов. — Со бэзя мэ кердём, кай ту прастанилян пал мандэ тэ рэсэс? ");
INSERT INTO rmn_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ту родинян алаи мо мангин — со ту аракхлян андар тэ мангинэстэ? Тхэ, со аракхлян, ангал тэ тухумендэ тай минрэндэ, тай мэ керэн он амэнги цындос. ");
INSERT INTO rmn_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Биш брэш мэ бэшлём тутэ: тэ бакрэн тай бузнян на чясас, э бакрэн андар тэ атарэс мэ на халём. ");
INSERT INTO rmn_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Э мудардэ гайванен мэ на анавас тутэ, ами мэ сам покинавас андар лэндэ. Ту мангесас мандар тэ покинав андар алаестэ, со сас чёрдо, десе тэ сас адава я рати. ");
INSERT INTO rmn_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Аки сар сас манги: о тхарипэ тхарэлас ман десе, о шудрипэ магроскерэлас ман рати, тай о соипэ нашэлас мэ якхендар. ");
INSERT INTO rmn_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Асавке сас одола биш брэш, кай мэ бэшавас андэ тэ кхерэстэ. Мэ керавас бути опэр тутэ дэшуштар брэш андар тэ до чяяндэ тай шов брэш андар гайваня, ай ту дэшвар паровэсас одова, со покинэсас манги. ");
INSERT INTO rmn_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Тэ на овэлас би манца о Дэл мэ дадэско, о Дэл э Авраамеско, Одова, Кастар трашалас о Исаак, ту бичялдянас би ман чюче вастэнца. Ай о Дэл дикхляс мо чёрипэ тай ми пхари бути тай кердяс цындос амэнги окоя рат. ");
INSERT INTO rmn_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","О Лаван пхэнляс э Яковески: — Адала чяя — мэ чяя, пуя — мэ пуя, тай о атарэс — мэ атарэс. Алаи, со ту дикхес, — алаи минро. Ами со мэ акана тэ керав мэ чяянца я э пуенца, савэ лэндэ аракхлилэ? ");
INSERT INTO rmn_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Эла керас завети, ту тай мэ, тай ов мэ овэл сикаипэ машкарэ амэндэ. ");
INSERT INTO rmn_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","О Яков лиляс бар тай тхэдяс лэс тэрдиндос. ");
INSERT INTO rmn_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ов пхэнляс пэ тухуменги: — Кидэн бара. Он кидинэ бара горас тай бэшлэ пашэ тэ хан. ");
INSERT INTO rmn_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","О Лаван тхэдяс лэс Иегар-Сагадута, ай о Яков — Гал-Эд. ");
INSERT INTO rmn_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","О Лаван пхэнляс: — Авдес адава горас — сикаипэ машкарэ тутэ тай мандэ. Аки соски тхэдэ лэс Гал-Эд. ");
INSERT INTO rmn_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Тай генэ Мицпа, вай о Лаван пхэнляс: — Мэ дикхел о Сагбус о Яхвэ пал тутэ тай пал мандэ, кана кан овас дур екхаврэста. ");
INSERT INTO rmn_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Тэ овэса хурлуки мэ чяянца я кан лэс туки аврэ ромнян, булуб мэ чяяндар, — джи кана амэнца никхон нанай, тюшундие, кай о Дэл — машкарэ амэндэ. ");
INSERT INTO rmn_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Генэ о Лаван пхэнляс э Яковески: — Аки барэндар горас тай тэрдо бар, саво мэ тхэдём машкарэ тутэ тай мандэ. ");
INSERT INTO rmn_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Адала бара — сикаипэ, тай адава тэрдо бар — сикаипэ одолэски, кай мэ на кан накхав пал адава горас э барэнго тэ ригатэ, тэ керав туки джюнгалипэ, тай ту на кан накхес адава тэрдо бар тай адава горас э барэнго мэ ригатэ, тэ керэс манги хурлуки. ");
INSERT INTO rmn_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","О Дэл э Авраамеско тай о Дэл э Нахореско, о Дэл лэнги дадэско, мэ керэл цындос машкарэ амэндэ. О Яков халяс совля Одолэнги, Савэстар трашалас лэско дад о Исаак. ");
INSERT INTO rmn_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Ов кердяс курбани отхэ андэ горадэс тай диняс икос э тухумен тэ хан екхетханэ. Он халэ тай раткердэ отхэ. ");
INSERT INTO rmn_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Ай эртэс сабахтан о Лаван чюмидиняс э турунен тай э чяян, алгышты лэн тай гело кхерэ. ");
INSERT INTO rmn_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","О Яков англэ гело по дром, тай о миляикя э Дэвлэски никлистэ мамуй. ");
INSERT INTO rmn_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Кана о Яков дикхляс лэн, ов пхэнляс: — Адава э Дэвлэско табури! — тай тхэдяс одова тхан Маханаим. ");
INSERT INTO rmn_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","О Яков бичялдяс ангал пэстэ манушэс пэ пхралэстэ ко Исав ки пху Сеир, андэ ливади Эдом. ");
INSERT INTO rmn_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Ов пхэнляс лэнги: — Пхэнэн мэ сагбуски э Исавески акаякха: «То иргати о Яков пхэнэл: Мэ бэшавас ко Лаван тай сомас отхэ джи авдесутнэ десестэ. ");
INSERT INTO rmn_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Мандэ си гурува, джёрэ, бакрэ тай бузнэ, иргатя тай иргатинкес. Мэ бичялав адава габэри мэ сагбуски, тэ аракхав мила андэ тэ якхендэ». ");
INSERT INTO rmn_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","О бичялдэ алэ палэ тай пхэнлэ э Яковески: — Амэ самас тэ пхралэстэ ко Исав. Акана ов сам авэл мамуй тутэ, тай лэса штаршэл мануша. ");
INSERT INTO rmn_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Барэ трашаса тай прастаимаса о Яков паляшты до табуренги э манушэн, савэ сас лэса, тай о атарэс э барэ тай э тикнэ гайваненца тай э камилэн. ");
INSERT INTO rmn_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Ов тюшунды: «О Исав тэ пэрэла опэр екх табури, ай о дуйто кан ачёл дживиндо тай кан кутардиелпэс» . ");
INSERT INTO rmn_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","О Яков мангляс э Дэвлэс: — О Дэл мэ дадэско э Авраамеско, о Дэл мэ дадэско э Исаакеско, о Сагбус о Яхвэ, кай пхэнляс манги: «Джя ки пху тинрятэ, тэ тухумендэ, тай Мэ кан дав тут лачипэ»! ");
INSERT INTO rmn_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Мэ на керав одоя мила тай о лачипэ, савэ кердян Ту Тэ иргатески. Мандэ ништо на сас, булуб катар ровли, кана мэ накхлём о Иордани, ай акана мэ авав палэ до табуренца . ");
INSERT INTO rmn_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Мангав Тут, кутардие ман мэ пхралэстар катар Исав. Мэ трашав, кай ов кан авэл тай кан пэрэл опэр мандэ тай опэр дэя э пуенца. ");
INSERT INTO rmn_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Вай Ту пхэнлян: «Мэ чяльти кан дав тут лачипэ тай кан керав тэ пуен бут, сар моряки кишай, сави нащи гинэс». ");
INSERT INTO rmn_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Ов сас отхэ рат тай андар одолэстэ, со лэстэ сас, лиляс башладипэ пэ пхралэски э Исавески: ");
INSERT INTO rmn_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","душэл бузнян тай бишэ бузнэн, душэл бакрян тай бишэ бакрэн, ");
INSERT INTO rmn_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","триянда камилэн тикнорэ камилэнца, саранда гурувнен тай дэшэ гурувэн, бишэ джёрян тай дэшэ джёрэн. ");
INSERT INTO rmn_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Ов тхэдяс кажни атаратэ иргатес тай пхэнляс лэнги: — Джян ангал мандэ тай астарэн о атарэс дур екхаврэстар. ");
INSERT INTO rmn_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ов сиклярдяс одолэс, кон джялас ангал: — Кана мо пхрал о Исав кан дикхел тут тай кан пхучел: «Каско ту? Кай джяс? Каски гайванен ту кувдиес?» — ");
INSERT INTO rmn_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","дэчи ту пхэн: «О гайваня тэ иргатески э Яковески. Адава башладипэ туки лэстар мэ сагбуски э Исавески, ай ов авэл пал амэндэ». ");
INSERT INTO rmn_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Ов сиклярдяс ли э дуйтонэс, ли э тритонэс, тай алаи аврэн, кай авэнас пал атарэс: — Тай тумэ аякхажэ пхэнэн э Исавески, кана ов тумэн кан дикхел. ");
INSERT INTO rmn_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Тай генэ пхэнэн: «То иргати о Яков авэл пал амэндэ». Ов тюшунды: «Мэ кан ковлярав лэс адалэса башладимаса, кай бичялав лэски ангал мандэ, ай дэчи, кана амэ кан дикхас екхаврэс, ов, файма, кан мукел ман». ");
INSERT INTO rmn_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Аякха о мангин, кай башлады о Яков, сас бичялдо ангал, ай ов сас рат андэ табури. ");
INSERT INTO rmn_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Одоя рат о Яков ущино тай лиляс пэ до ромнян, до иргатинкен тай дэшуекх чявэн тай накхло опрал диряв Яббок. ");
INSERT INTO rmn_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Ов накхавдяс лэн опрал пани тай бичялдяс алаи по мангин. ");
INSERT INTO rmn_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Тай аки о Яков ачило коркоро, тай Кон-то ушарэлас лэса джи сабахтаняки. ");
INSERT INTO rmn_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Кана Ов дикхляс, кай нащи ушарэл э Яковес, Ов колисаило ко шалос ки Яковеско, аякха кай сас о шалос болавдо, кана ов ушарэлас Лэса. ");
INSERT INTO rmn_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Тай Ов пхэнляс: — Мук Ман, вай сиризэл. Ай о Яков пхэнляс: — На кан мукав, бискай на кан алгыштиес ман. ");
INSERT INTO rmn_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ов пхучляс: — Сар то нав? — Яков, — пхэнляс ов. ");
INSERT INTO rmn_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Дэчи Ов пхэнляс: — Акана то нав кан овэл на Яков, ами Израиль, вай ту ушардян э Дэвлэса тай э манушэнца тай ушардян лэн. ");
INSERT INTO rmn_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","О Яков пхэнляс: — Мангав Тут, пхэн манги То нав. Ай Ов пхэнляс: — Соски ту пхучес Мо нав? Тай Ов алгышты лэс. ");
INSERT INTO rmn_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","О Яков тхэдяс одова тхан Пениэл, пхэнляс: «Мэ дикхлём э Дэвлэс муй ко муй тай ачилём дживиндо». ");
INSERT INTO rmn_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","О кхам ущино опэр лэстэ, кана ов накхелас о Пениэл. Ов лангалас андар пэ шалостэ. ");
INSERT INTO rmn_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Аки соски джи авдес о израильтяня на хан жылэс опрал кокало ки шалоско: вай Ов колисаило ко кокало ки шалоско ки Яковеско паш ко жылэс. ");
INSERT INTO rmn_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","О Яков дикхляс, кай авэл о Исав тай лэса штаршэл мануша. Ов паляшты э пуен машкарэ ки Лия, ки Рахиль тай ко дуй иргатинкес. ");
INSERT INTO rmn_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ов тхэдяс э иргатинкен тай лэнги пуен ангал, э Лия тай лаки пуен пал лэндэ, ай э Рахиля э Иосифеса пал алаендэ. ");
INSERT INTO rmn_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ай ов гело ангал, пашолас пэ пхралэстэ тай бангило джи ки пху эфтавар. ");
INSERT INTO rmn_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ай о Исав прастанило мамуй ко Яков, диняс ангали лэс, читяспэс лэски мэнятэ тай чюмидиняс лэс, тай он рунэ. ");
INSERT INTO rmn_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","О Исав дикхляс э джювлен тай э пуен тай пхучляс: — Кон адава туса? О Яков пхэнляс: — Адала пуя, савэн о Дэл миласа диняс тэ иргатес. ");
INSERT INTO rmn_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Пашылэ о иргатинкес пумарэ пуенца тай бангилэ. ");
INSERT INTO rmn_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Дэчи пашылэ тай бангилэ э Лия тай лаки пуя. Пал алаендэ пашылэ о Иосиф тай э Рахиль ли бангилэ. ");
INSERT INTO rmn_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","О Исав пхучляс ко Яков: — Соски ту бичялдян алаи адала атарэс мамуй мандэ? — Мэ манглём тэ аракхав мила андэ тэ якхендэ, мо сагбус, — пхэнляс ов. ");
INSERT INTO rmn_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","О Исав пхэнляс: — Мандэ си алаи бут, мо пхрал. Ачяв тинро туки. ");
INSERT INTO rmn_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","— На, мангав тут! — пхэнляс о Яков. — Мэ тэ аракхлём мила андэ тэ якхендэ, дэчи лэ мандар адава башладипэ. Манги тэ дикхав то муй — адава сар тэ дикхав о муй э Дэвлэско, вай ту муклян ман аякха миласа. ");
INSERT INTO rmn_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Мангав тут, лэ мандар адава башладипэ, вай о Дэл сас миласа мандэ, тай мандэ си алаи, со манги камэл. О Яков лачес мангелас, тай о Исав лиляс о башладипэ. ");
INSERT INTO rmn_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Дэчи о Исав пхэнляс: — Гадэ, камэл тэ джяс ко дром. Мэ кан астаравман паш тутэ. ");
INSERT INTO rmn_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Ай о Яков пхэнляс: — Мо сагбус джянэл, кай о пуя би зораки тай мэ камэл тэ дикхав пал бакря тай гурувня, савэ дэн сути. Лэн лачес тэ кувдиеса хоть екх дес, о гайваня кан мэрэн. ");
INSERT INTO rmn_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Мэ джял мо сагбус ангал пэ иргатестэ, ай мэ кан джяв тэмэли, сар кан джян о атарэс ангал мандэ тай сар кан джян о пуя, бискай на кан авэн мэ сагбустэ андэ Сеир. ");
INSERT INTO rmn_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","О Исав пхэнляс: — Мук ман тэ ачявав туса мэ манушэн сарсавэн. — Соски? — пхучляс о Яков. — Рэсэл ли одова, кай мэ аракхлём мила андэ якха мэ сагбустэ. ");
INSERT INTO rmn_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Тай о Исав одова жэ дес гело палэ пэстэ андэ Сеир. ");
INSERT INTO rmn_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Ай о Яков гело андэ Суккот, катэ ов тхэдяс пэски кхер тай катунэс э гайваненги. Аки соски адава тхан бучёл Суккот. ");
INSERT INTO rmn_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","О Яков ало андар Паддан-Арам, лачимаса ало ки диз Шэхем андэ Ханаан тай ачило тэ бэшэл ангал диз. ");
INSERT INTO rmn_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Шэлэ рупунэ которэнги ов киндяс ко чявэ ки Хаморески, ко дад ки Шэхемеско, котор пху, опэр савятэ ов тхэдяс пи катуна. ");
INSERT INTO rmn_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Отхэ ов кердяс алтари тай тхэдяс лэс Эль-Элохей-Йисраэль. ");
INSERT INTO rmn_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Э Дина, э чяй э Лияки катар Яков, гели тэ дикхел аканутнэ чяян. ");
INSERT INTO rmn_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Кана о Шэхем, о чяво э хивееско э Хамореско, о сагбус одолэ областяко, дикхляс ла, астардяс, пашлило ласа тай лиляс ла. ");
INSERT INTO rmn_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","О ило лэско колисаило ки Дина, ки чяй ки Яковески, ов дэхляс ла тай зборизэлас ласа дэхымаса. ");
INSERT INTO rmn_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ов пхэнляс пэ дадэски э Хаморески: — Лэ манги адалэ чяя ромня. ");
INSERT INTO rmn_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Кана о Яков шунляс, кай лэски чяятар катар Дина кердэ маскаралыки, лэски чявэ сас ки ливади э атарэнца. Ов на пхэнэлас адалэстар, бискай он на алэ кхерэ. ");
INSERT INTO rmn_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","О Хамор, о дад э Шэхемеско, ало тэ зборизэл э Яковеса. ");
INSERT INTO rmn_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Кана о чявэ э Яковески шунлэ, со уло, он алэ катар ливадя. Он сас пхэрдэ касывэти тай холи, вай о Шэхем кердяс ладжяваски дила андэ Израиль, кана пашлило э Яковески чяяса. Асавко нащи овэл. ");
INSERT INTO rmn_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","О Хамор пхэнляс лэнги: — Мо чяво о Шэхем илэса пханлило тумарэ чяятэ. Мангав тумэн, дэн ла лэстэ ромня. ");
INSERT INTO rmn_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Элан овас тухумя: дэн амэндэ тумарэ чяян тай лэн амарэн. ");
INSERT INTO rmn_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Манген, бэшэн машкарэ амэндэ, — э пху ангал тумэндэ: бэшэн тай пхерэн опэр латэ, тай кинэн ла тумэнги. ");
INSERT INTO rmn_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","О Шэхем пхэнляс э Динаки дадэски тай э пхралэнги: — Мэ кан дав тумэн алаи, со тумэ кан пхэнэн, тэ аракхав мэ мила андэ тумарэ якхендэ! ");
INSERT INTO rmn_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Пхэнэн андар бори, саво манген калыни тай багалыдэс шэя, тай мэ кан покинав, екх дэн ман ла ромня. ");
INSERT INTO rmn_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Дэчи о чявэ э Яковески пхэнлэ э Шэхемески тай лэски дадэски э Хаморески хохаимаса, вай ов кердяс маскаралыки лэнги пхэнятар катар Дина. ");
INSERT INTO rmn_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Он пхэнлэ лэски: — Амэ нащи керас асавко: тэ дас амарэ пхэня не абрезани муршэстэ кан овэлас би амэнги ладжяво. ");
INSERT INTO rmn_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Амэ кан пхэнас лачё, тумэ тэ овэна, сар амэ, тай тэ керэна алаи тумарэ муршэнги абрезания. ");
INSERT INTO rmn_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Дэчи амэ кан дас тумэн амарэ чяян тай кан лас амэнги тумарэн. Амэ кан бэшас машкарэ тумэндэ тай кан овас тумэнца екх дюняс. ");
INSERT INTO rmn_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ай тумэ тэ на керэна абрезания, амэ кан лас амарэ пхэня тай кан джяс. ");
INSERT INTO rmn_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","О Хамор тай лэско чяво о Шэхем дэхляс лэнги зборэс. ");
INSERT INTO rmn_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","О тэрно мануш чяльти кердяс одова, со он пхэнлэ, вай ов бут лачес дэхэлас э Яковески чяя. Ай андэ кхер пэ дадэстэ о Шэхем сас алаендар намлыс. ");
INSERT INTO rmn_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Дэчи о Хамор тай лэско чяво о Шэхем алэ ки бар ки дизаки тай пхэнлэ э дюняски. ");
INSERT INTO rmn_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","— Адала мануша лаче амэнца, — пхэнлэ он. — Мэ бэшэн опэр амарэ пхуятэ тай мэ пхерэн опэр латэ. Опэр адалэ пхуятэ лэнги рэсэл тхан. Амэ кан прандозас опэр лэнги чяяндэ, тай он мэ прандозэн опэр амаряндэ. ");
INSERT INTO rmn_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ай амарэ мурша, сар он, камэл тэ овэн абрезаня. Екх озаман кан бэшэн адала мануша амэнца, сар екх дюняс. ");
INSERT INTO rmn_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Озаман лэнги атарэс, о мангин тай алаи лэнги гайваня кан овэн амарэ. Эла керас, со он пхэнлэ, тай он кан бэшэн машкарэ амэндэ. ");
INSERT INTO rmn_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Алаи, кон кидэласпэс ки дизаки бар, пхэнлэ лачё э Хаморески тай лэски чявэски э Шэхемески, тай алаи о мурша андэ диз сас абрезаня. ");
INSERT INTO rmn_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Тринэ десендар, кана лэндэ дага дукхалас, о дуй чявэ э Яковески — о Симеон тай о Левий, о пхрала э Динаки — лилэ о камадэс, бирдэн пэлэ опэр диз тай мудардэ алаи э муршэн. ");
INSERT INTO rmn_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Он мудардэ камаса э Хаморес тай лэски чявэс э Шэхемес, лилэ э Дина андар Шэхемеско кхер тай гелэ. ");
INSERT INTO rmn_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Дэчи о чявэ э Яковески алэ ко мудардэ тай чёрдэ э диз, катэ кердэ маскаралыки катар пхэн. ");
INSERT INTO rmn_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Он лилэ о атарэс э барэ тай э тикнэ гайваненца, джёрэн — алаи, со сас андэ диз тай ко ливадя. ");
INSERT INTO rmn_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Алаи лэнго барвалипэ, тай э пуен, тай э джювлен, тай алаи, со сас андэ кхера, он лилэ пэски. ");
INSERT INTO rmn_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Дэчи о Яков пхэнляс э Симеонески тай э Левиески: — Тумэ кердянус манги хурлуки, кердянус тэ на дэхэн ман о мануша адалэ пхуяки, о ханаанея тай о периззея. Амэндэ залак мануша, ай он кан овэн екхетханэ тай кан мударэн ман, тай алаи амаро дюняс кан мэрэл. ");
INSERT INTO rmn_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ай он пхэнлэ: — Та со, камэл тэ керэн амарэ пхэняса, сар кахпэисаса? ");
INSERT INTO rmn_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","О Дэл пхэнляс э Яковески: — Ваздэтут андэ Вефиль, ачё отхэ тай кер отхэ алтари э Дэвлэски, Саво сикавдяспэс туки, кана ту нашлян тэ пхралэстар катар Исав. ");
INSERT INTO rmn_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","О Яков пхэнляс пэ кхерутнэнги тай алаенги, кон эсас амэнца: — Шужарэн тумэн катар джятя дэла, савэ тумэнца, тай паровэн тумэнги о савутя. ");
INSERT INTO rmn_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Дэчи кидэнтумэн ко дром, тай амэ гелям андэ Вефиль, катэ мэ кан керав алтари э Дэвлэски, Саво зборисаило манца андэ дес ки хурлукеско тай сас манца, кай тэ на джяв. ");
INSERT INTO rmn_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Он динэ ко Яков алаи э джяте дэвлэн, савэ сас лэндэ, тай о чяня андар кана, тай о Яков хранляс лэн тал дуби андэ Шэхем. ");
INSERT INTO rmn_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Дэчи он гелэ ко дром. Э траш э Дэвлэски лиляс алаи о диза агорял лэндэ, аякха кай никхон на родэлас э Яковески пуен. ");
INSERT INTO rmn_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","О Яков тай алаи, кон сас лэса, алэ андэ Луз (самким Вефиль) ки пху Ханаан. ");
INSERT INTO rmn_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Отхэ ов кердяс алтари тай тхэдяс одова тхан Эль-Бет-Эль, вай отхэ о Дэл пхутэрдяспэс лэски, кана ов нашло пэ пхралэстар. ");
INSERT INTO rmn_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Э Девора, сави хавдярэлас э Рэвэка, мули тай сас паромэ тал дуби паш ко Вефили. Оничин ов сас тхэдо Аллон-Бахут. ");
INSERT INTO rmn_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Кана о Яков ало палэ андар Паддан-Арам, о Дэл генэ сикавдяспэс лэски тай алгышты лэс. ");
INSERT INTO rmn_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","О Дэл пхэнляс лэски: — То нав Яков, ай акана ту на кан бучёс Яков. То нав кан овэл Израиль. Аякха о Дэл тхэдяс лэс Израиль. ");
INSERT INTO rmn_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Ов пхэнляс лэски: — Мэ — о Дэл о Баро-Зорало. Мэ аракхлён тутар пуя тай бутё. Дюняс тай бут дюнядэс кан овэн тутар, тай патишая кан овэн тутар. ");
INSERT INTO rmn_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Э пху, сави Мэ динём э Авраамес тай э Исаакес, Мэ кан дав тутэ тай ла тэ пуендэ. ");
INSERT INTO rmn_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Тай о Дэл ваздиняспэс лэстар отхэ. ");
INSERT INTO rmn_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","О Яков тхэдяс о бар тэрдиндос одолэ тханэстэ, катэ о Дэл зборизэлас лэса, тай чёрдяс опэр лэстэ винас тай маслинаки олия. ");
INSERT INTO rmn_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","О Яков тхэдяс о тхан, катэ о Дэл зборизэлас лэса, Вефиль. ");
INSERT INTO rmn_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Он ачявдэ о Вефиль тай сас надур катар Эфрата, кана ки Рахиль лиляс тэ аракхлёл пуёс, тай о аракхлипэ сас бут пхаро. ");
INSERT INTO rmn_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ой бут сидэла дукх, кана аракхлёлас о пуёс. Э джювли, сави керэлас ярдыми тэ аракхлёл, пхэнляс лаки: — Ма траша, тутэ кан овэл генэ екх чяво. ");
INSERT INTO rmn_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Кана э Рахиль мукелас по тэнышы тай мэрэлас, ой тхэдяс пэ чявэс Бэн-Они, ай о дад тхэдяс лэс Вениамин. ");
INSERT INTO rmn_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Э Рахиль мули тай сас паромэ опэр дром ко Эфрата (самким Вифлееми). ");
INSERT INTO rmn_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Опэр лаки гробостэ о Яков тхэдяс бар тэрдиндос. Одова бар тэрдо опэр гробус ки Рахиляко джи авдес. ");
INSERT INTO rmn_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","О Израиль джялас англэ тай тхэдяс катуна пал Мигдал-Эдэр. ");
INSERT INTO rmn_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Кана о Израиль бэшэлас андэ одолэ пхуятэ, о Рувим пашлило пэ дадэски иргатинкаса э Билхаса, тай о Израиль галило адалэстар. Ко Яков сас дэшудуй чявэ. ");
INSERT INTO rmn_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Катар Лия: о Рувим, баштутно э Яковеско, о Симеон, о Левий, о Иуда, о Иссахар тай о Завулон. ");
INSERT INTO rmn_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Катар Рахиль: о Иосиф тай о Вениамин. ");
INSERT INTO rmn_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Катар Рахиляки иргатинка ки Билха: о Дан тай о Неффалим. ");
INSERT INTO rmn_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Катар Лияки иргатинка ки Зилпа: о Гад тай о Асир. Аки о чявэ э Яковески. Он аракхлилэ лэски андэ Паддан-Арам. ");
INSERT INTO rmn_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","О Яков ало пэ дадэстэ ко Исаак андэ Мамрэ, кай пашэ Кирьят-Арба (самким Хеврон), катэ бэшэнас о Авраам тай о Исаак. ");
INSERT INTO rmn_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Алаи о деса э бэшымаски э Исаакески сас шэлу охтодэша брэш. ");
INSERT INTO rmn_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","О Исаак сас пхуро тай чяло бэшымаса. Ов мукляс по тэнышы, муло тай гело пэ мулэ папудэндэ. Лэски чявэ о Исав тай о Яков пароскердэ лэс. ");
INSERT INTO rmn_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Аки о пхукаипэ катар Исав (ов да Эдом) тай лэски пуендар. ");
INSERT INTO rmn_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","О Исав лиляс пэски ромнян андар Ханаан: э Ада, э чяя хетеески э Элонески, э Оголивама, э Анаки чяя тай туруни э хивеески э Цывеонески, ");
INSERT INTO rmn_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","тай генэ э Басемата, Измаилески чяя, э пхэня э Невайотески. ");
INSERT INTO rmn_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ки Ада аракхлило э Исавески о Элифаз, ки Басемата аракхлило о Реуэл, ");
INSERT INTO rmn_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ки Оголивама аракхлило о Еуш, о Ялам тай о Корах. Адава о чявэ э Исавески, кай аракхлилэ лэски андэ Ханаан. ");
INSERT INTO rmn_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","О Исав лиляс пэ ромнян, чявэн, чяян тай алаи э кхерутнэн, лиляс о атарэс, э гайванен тай алаи о мангин, саво ов кидиняс андэ Ханаан, тай накхло андэ авэр пху пэ пхралэстар ко Яков, ");
INSERT INTO rmn_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","вай лэндэ сас бут мангин, тай нащи овэн он екхетханэ. Лэндэ сас аборкха гайваня, кай э пху, катэ он бэшэнас, нащи хавдярэлас лэн э дон. ");
INSERT INTO rmn_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Аякха о Исав (ов да о Эдом) ачило андэ горадэс андэ Сеир. ");
INSERT INTO rmn_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Аки о пхукаипэ катар Исав (ов си о дад э эдомитяненги кай бэшэлас андэ горадэс ки Сеир) тай лэски пуендар. ");
INSERT INTO rmn_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Аки о нава э Исавески чявэнги: о Элифаз, о чяво э Исавеско лэски ромнятар катар Ада, тай о Реуэл, о чяво э Исавеско лэски ромнятар катар Басемата. ");
INSERT INTO rmn_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","О чявэ э Элифазески: о Теман, о Омар, о Цэфо, о Гатам тай о Кеназ. ");
INSERT INTO rmn_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Ко чяво ки Исавеско ко Элифаз сас иргатинка, сави бучёлас Тимна, савятэ аракхлило лэски о Амалек. Адава о туруня э Исавески ромняки э Адаки. ");
INSERT INTO rmn_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","О чявэ э Реуэлески: о Нахат, о Зерах, о Шамма тай о Мизза. Адава о туруня э Исавески ромняки э Басематаки. Цефо* ");
INSERT INTO rmn_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","О чявэ э Исавески лэски ромнятар катар Оголивама, э чяй э Анаски тай э туруниса э Цывеонески, савэ аракхлилэ латэ э Исавески: о Еуш, о Ялам тай о Корах. ");
INSERT INTO rmn_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Аки о сагбудэс машкарэ ко пуя ки Исавески. О чявэ э Элифазески, о баштутно э Исавеско: о сагбудэс о Теман, о Омар, о Цэфо, о Кеназ, ");
INSERT INTO rmn_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","о сагбудэс о Корах, о Гатам тай о Амалек. Адава о сагбудэс, кай аракхлилэ катар Элифаз андэ Эдом; он сас о туруня э Адаки. ");
INSERT INTO rmn_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","О чявэ э Реуэлески, э Исавески чявэски: о сагбудэс о Нахат, о Зерах, о Шамма тай о Мизза. Адава о сагбудэс, савэ аракхлилэ катар Реуэл андэ Эдом; он сас о туруня э Исавески ромняки э Басематаки. ");
INSERT INTO rmn_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","О чявэ лэски ромнятар ки Оголивама: о сагбудэс о Еуш, о Ялам тай о Корах. Адава о сагбудэс, кай аракхлилэ катар Исавески ромни ки Оголивама, э чяй э Анаски. ");
INSERT INTO rmn_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Аки о чявэ э Исавески (ов да о Эдом) тай аки лэнги сагбудэс. ");
INSERT INTO rmn_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Аки о чявэ э Сеирески о хореи, кай бэшэлас андэ одоя область: о Лотан, о Шовал, о Цывеон, о Ана, ");
INSERT INTO rmn_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","о Дишон, о Эцэр тай о Дишан. Адала чявэ э Сеирески андэ Эдом сас сагбудэс э хореенги. ");
INSERT INTO rmn_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","О чявэ э Лотанески: о Хорий тай о Хемам. Э пхэн э Лотанески сас э Тимна. ");
INSERT INTO rmn_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","О чявэ э Шовалески: о Алван, о Манахат, о Эвал, о Шэфо тай о Онам. ");
INSERT INTO rmn_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","О чявэ э Цывеонески: о Айя тай о Ана. Адава одова Ана, саво пхутэрдяс андэ ливади тхарэ ханинга, кана чярярэлас э джёрэн пэ дадэскерэн э Цывеонески. ");
INSERT INTO rmn_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","О пуя э Анаски: о Дишон тай э Оголивама, чяй э Анаски. ");
INSERT INTO rmn_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","О чявэ э Дишонески: о Хемдан, о Эшбан, о Ифран тай о Херан. ");
INSERT INTO rmn_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","О чявэ э Эцэрески: о Билхан, о Зааван тай о Акан. ");
INSERT INTO rmn_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","О чявэ э Дишанески: о Уц тай о Аран. ");
INSERT INTO rmn_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Аки о сагбудэс э хореенги: о сагбудэс о Лотан, о Шовал, о Цывеон, о Ана, ");
INSERT INTO rmn_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","о сагбудэс о Дишон, о Эцэр тай о Дишан. Он сас сагбудэс э хореенги лэнги породэнги андэ пху Сеир. ");
INSERT INTO rmn_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Аки о патишая, савэ сас сагбудэс андэ Эдом, дага ангал отхэ, сар андэ Израиль улэ патишая: ");
INSERT INTO rmn_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","О Бэла, о чяво э Бэореско, сас патишаи андэ Эдом. Лэски диз бучёлас Динхава. ");
INSERT INTO rmn_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Пал ко мэрипэ ки Бэласко патишаи лэски тханэстэ уло о Иовав, о чяво э Зэрахеско, андар Боцра. ");
INSERT INTO rmn_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Пал ко мэрипэ ки Иовавеско патишаи лэски тханэстэ уло о Хушам катар пху ки теманитяненги. ");
INSERT INTO rmn_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Пал ко мэрипэ ки Хушамеско патишаи лэски тханэстэ уло о Хадад, о чяво э Бэдадеско, саво мудардяс э мадианитянен андэ пху ки Моавески. Лэски диз бучёлас Авит. ");
INSERT INTO rmn_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Пал ко мэрипэ ки Хададеско патишаи лэски тханэстэ уло о Самла андар Масрека. ");
INSERT INTO rmn_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Пал ко мэрипэ ки Самласко патишаи лэски тханэстэ уло о Саул андар Реховот, кай си ки диряв. ");
INSERT INTO rmn_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Пал ко мэрипэ ки Саулеско патишаи лэски тханэстэ уло о Баал-Ханан, о чяво э Ахбореско. ");
INSERT INTO rmn_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Пал ко мэрипэ ки Баал-Хананеско, э чявэско э Ахбореско, патишаи лэски тханэстэ уло о Хадар. Лэски диз бучёлас Пау. Ай о нав лэски ромняко сас Мэхэтавэль; ой сас э чяй э Матрэдэски, э туруниса э Мэ-Захавески. ");
INSERT INTO rmn_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Аки о нава э сагбудэнги, э Исавески пуенги, лэнги породэнги тай пхуенги. Лэнги нава: о сагбудэс о Тимна, о Алва, о Етет, ");
INSERT INTO rmn_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","о сагбудэс о Оголивама, о Эла, о Пинон, ");
INSERT INTO rmn_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","о сагбудэс о Кеназ, о Теман, о Мивцар, ");
INSERT INTO rmn_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","о сагбудэс о Магдиэл тай о Ирам. Адава о сагбудэс э Эдомески лэски тханэндэ андэ пху, опэр савятэ он си. Адава сас о Исав, о дад э эдомитяненго. ");
INSERT INTO rmn_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","О Яков бэшэлас андэ одолэ пхуятэ, катэ бэшэлас лэско дад, ки пху Ханаан. ");
INSERT INTO rmn_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Аки о пхукаипэ катар Яков тай лэски пуендар. О Иосиф, савэски сас дэшуэфта брэш, чярярэлас о атарэс э бакрэнца екхетханэ пэ пхралэнца — э Билхаки тай э Зилпаки чявэнца, э ромненги э Иосифески дадэски. О Иосиф пхукавэлас пэ дадэски налачё пэ пхралэндар. ");
INSERT INTO rmn_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","О Израиль дэхэлас э Иосифес бут алаи аврэ чявэндар, вай ов аракхлило лэски опэр пхуримастэ. О Израиль кердяс лэски бут шукара савутя. ");
INSERT INTO rmn_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Кана о пхрала дикхлэ, кай о дад дэхэл лэс бут, ниш лэн алаен, он на дэхлэ лэс тай нащи лачимаса зборизэнас лэса. ");
INSERT INTO rmn_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Екхвар о Иосиф дикхляс суно. Ов пхукавдяс лэстар пэ пхралэнги, тай он на дэхлэ лэс май бут. ");
INSERT INTO rmn_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Аки со ов пхэнляс лэнги: — Шунэн, со суно мэ дикхлём. ");
INSERT INTO rmn_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Амэ пхандасас о снопя гив ки ливади, тай бирдэн мо снопи ваздиняспэс тай гортярдяспэс, ай тумаро снопя тэрдило агорял лэстэ тай бангилэ. ");
INSERT INTO rmn_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","О пхрала пхэнлэ лэски: — Та со, ту кан овэс патишаи опэр амэндэ? Та со, амэ кан овас тутэ иргатя? Тай он май бут холясаилэ опэр лэстэ андар лэско суно тай андар адава пхукаипэ. ");
INSERT INTO rmn_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","О Иосиф дикхляс генэ екх суно тай генэ пхукавдяс лэстар пэ пхралэнги: — Шунэн, мэ дикхлём генэ екх суно: кай манги бангило о кхам, о чюнут тай о дэшуекх чергэня. ");
INSERT INTO rmn_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ов пхукавдяс о суно на екх пэ пхралэнги, ами ли пэ дадэски, тай о дад холясаило лэски: — Со суно адава ту дикхлян? Та со, мэ, ти дай тай тэ пхрала чячес кан авас тай кан бангяс туки джи ки пху? ");
INSERT INTO rmn_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","О пхрала кизгандиенас лэс, ай о дад тюшундиелас адалэстар. ");
INSERT INTO rmn_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","О пхрала гелэ тэ чярярэн атарэс пэ дадэски ко тхана андэ Шэхем, ");
INSERT INTO rmn_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","тай о Израиль пхэнляс э Иосифески: — Ту джянэс, кай тэ пхрала чярярэн о атарэс паш ко Шэхем. Мэ мангав тэ бичялав тут лэндэ. — Мэ газыри, — пхэнляс о Иосиф. ");
INSERT INTO rmn_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","О дад пхэнляс лэски: — Джя дикх, алаи лачё тэ пхралэнца тай э атарэнца, тай эла пхэн манги. Ов пхэнляс лэски адава ки ливади Хеврон, тай о Иосиф гело андэ Шэхем. ");
INSERT INTO rmn_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Отхэ ов родэлас ко ливадя, бискай на дикхляс лэс мануш тай пхучляс лэс: — Со ту родэс? ");
INSERT INTO rmn_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Ов пхэнляс: — Мэ родав мэ пхралэн. Мангав тут, пхэн манги, катэ он чярярэн пумарэ атарэс? ");
INSERT INTO rmn_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","— Он гелэ атхар, — пхэнляс о мануш. — Мэ шунлём, сар он зборизэнас: «Гадэн андэ Дотан». О Иосиф гело пал пэ пхралэндэ тай аракхляс лэн ко Дотан. ");
INSERT INTO rmn_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Он дикхлэ лэс дурал, тай ангал отхэ, сар ов пашыло лэндэ, зборисаилэ тэ мударэн лэс. ");
INSERT INTO rmn_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","— Аки авэл одова, саво дикхел сунэ! — пхэнлэ он екхаврэски. ");
INSERT INTO rmn_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","— Элан мударас лэс тай тэ чяс андэ шуки ханинг, ай амарэ дадэски пхэнаса, кай лэс халяс вэшэско гайвани. Дэчи кан дикхас, со кан никлёл андар лэски сунэндэ. ");
INSERT INTO rmn_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ай о Рувим шунляс тай кутарды лэс лэндар, пхэнляс: — На, на кан мударас лэс. ");
INSERT INTO rmn_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ма чёрэн рат. Чен лэс андэ акая ханинг атхэ, андэ ливади, ай ма ваздэн опэр лэстэ тумаро васт. О Рувим мангляс тэ кутардиел лэс лэндар тай тэ анэл ко дад. ");
INSERT INTO rmn_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Кана о Иосиф пашыло пэ пхралэндэ, он пхаравдэ опрал лэстэ о савутя — одола, савэ сас багалыс сивдэ, — ");
INSERT INTO rmn_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","тай читэ лэс андэ ханинг. Э ханинг сас чючи, би панески. ");
INSERT INTO rmn_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Дэчи он бэшлэ тэ хан, тай дикхлэ каравани э измаильтяненго, кай авэл андар Галаад. Лэнги камилэс сас пхэрдэ чяренца, бальзамеса тай мирраса, савэ он гелэнас андэ Египти. ");
INSERT INTO rmn_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","О Иуда пхэнляс пэ пхралэнги: — Со файдас амэнги, амэ тэ мударас амарэ пхралэс тай кан гаравас адава? ");
INSERT INTO rmn_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Зиядэ тэ бикнас лэс э измаильтяненги тай тэ на ваздас опэр лэстэ амарэ васта; вай ов амаро пхрал, амаро тэни тай рат. О пхрала пхэнлэ лачё. ");
INSERT INTO rmn_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Кана о мадианскя бикинимаря накхенас пашал, о пхрала никалдэ э Иосифес андар ханинг тай бикиндэ э измаильтяненги бишэ рупунэ которэнги. О измаильтяня лилэ лэс тай гелдэ андэ Египти. ");
INSERT INTO rmn_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Кана о Рувим ало ки ханинг, ов дикхляс, кай о Иосиф отхэ нанай, тай пхаравдяс опэр пэстэ о савутя. ");
INSERT INTO rmn_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ов ало пэ пхралэндэ тай пхэнляс: — О чяворо отхэ нанай! Кай манги акана тэ гарававман? ");
INSERT INTO rmn_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Дэчи он лилэ о савутя э Иосифески, чиндэ бузнэс тай макхлэ о савутя рат. ");
INSERT INTO rmn_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Он гелдэ о багалыдэс сивдэ савутя пумарэ дадэски тай пхэнлэ: — Аки со амэ аракхлям. Дикх, на о савутя адава тэ чявэски? ");
INSERT INTO rmn_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ов пэнджярдяс лэн тай диняс бэбэря: — Адава о савутя мэ чявэски! Лэс халяс вэшэско гайвани! Эйами, о Иосиф сас джирдимэ котора! ");
INSERT INTO rmn_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","О Яков пхаравдяс опэр пэстэ о савутя, урявдяс гонэски савутя тай бут дес ровэлас пэ чявэски. ");
INSERT INTO rmn_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Алаи лэски чявэ тай чяя алэ тэ аядиен лэс, ай ов на мангелас тэ аядиен лэс, пхэнэлас: — На, мэ аякха андэ касывэтестэ, тай кан джяв андэ дюняс ки мулэнго, мэ чявэстэ. Аякха о дад ровэлас пэ чявэски. ");
INSERT INTO rmn_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ай о мадианитяня одова вахыти бикиндэ э Иосифес андэ Египти э Потифарески, э фараонески ярдымарески, саво сас лэстэ баро опэр барэ. ");
INSERT INTO rmn_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","О Иуда одова вахыти ачявдяс пэ пхралэн тай бэшэлас екхе манушэстэ андар Адуллам, кай бучёлас Хира. ");
INSERT INTO rmn_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Отхэ о Иуда дикхляс чяя ханаанеескеря, саво бучёлас Шуа. Ов прандосаило опэр латэ тай лиляс тэ бэшэл ласа. ");
INSERT INTO rmn_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Ой насвалили пуёстэ, тай аракхлило чяво, савэс о Иуда тхэдяс Эр. ");
INSERT INTO rmn_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Ой генэ насвалили пуёстэ, тай аракхлило чяво, тай ой тхэдяс лэс Онан. ");
INSERT INTO rmn_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Латэ аракхлило генэ екх чяво, тай ой тхэдяс лэс Шэла. Латэ ов аракхлило андэ Хезив. ");
INSERT INTO rmn_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","О Иуда лиляс пэ баштутнэски э Эрески ромня, кай бучёлас Тамарь. ");
INSERT INTO rmn_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ай о Эр, э Иудеско баштутно, сас бэзяло андэ якха ки Сагбуски, тай о Сагбус о Яхвэ диняс лэс ко мэрипэ. ");
INSERT INTO rmn_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Дэчи о Иуда пхэнляс э Онанески: — Ту камэл тэ пашлёс тэ пхралэски ромняса, тэ керэс, со камэл тэ керэл о кумнатос, тэ овэн пуя тэ пхралэски. ");
INSERT INTO rmn_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ай о Онан джянэлас, кай о пуя на кан овэн лэски, оничин сальтя, кана пашлёлас пэ пхралэски ромняса, ов чёрэлас э муршэско ки пху, тэ на аракхлён пуя э пхралэски. ");
INSERT INTO rmn_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Одова, со ов керэлас, сас бэзя андэ якха ки Сагбуски Яхвэски, оничин Ов диняс ко мэрипэ ли Онанес. ");
INSERT INTO rmn_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Дэчи о Иуда пхэнляс пэ боряки э Тамаряки: — Бэш пхивли андэ кхер тэ дадэстэ, бискай на кан барёл мо чяво о Шэла. Ов тюшунды: «Сар би о Шэла тэ на мэрэл пал пэ пхралэндэ». Тай э Тамарь гели тэ бэшэл андэ кхер пэ дадэстэ. ");
INSERT INTO rmn_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Бутэ вахытестар э ромни э Иудаски, э чяй э Шуаски, мули. Кана о Иуда раганты, ов гело андэ Тимна ко мануша, савэ моравэнас лэски бакрэн, тай лэско амал адулламитяни о Хира гело лэса. ");
INSERT INTO rmn_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Э Тамаряки пхэнлэ: — То састро джял андэ Тимна тэ моравэл пэ бакрэн. ");
INSERT INTO rmn_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Ой читяс э пхивляки савутя, учярдяспэс, тэ на пэнджярэн ла, тай бэшли ангал Энаим, кай опэр дром андэ Тимна. Ой дикхелас, кай о Шэла барило, ай ла на динэ лэстэ сар ромня. ");
INSERT INTO rmn_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Кана о Иуда дикхляс ла, ов галило, кай кахпэиса, вай латэ сас пханло о муй. ");
INSERT INTO rmn_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Ов болдиняс катар дром латэ тай пхэнляс: — Гадэ, мук тэ пашляв мэ туса, — вай ов на джянэлас, кай адава лэски бори. Ой пхучляс: — Ай со кан дэс ман андар одолэстэ, тэ пашлёс манца? ");
INSERT INTO rmn_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Ов пхэнляс: — Мэ кан бичялав туки бузнорэс андар мэ атаратэ. Ой пхучляс: — Ай ту кан дэс ман шо-то джи одолэ вахытески, бискай бичялэс бузнорэс? ");
INSERT INTO rmn_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Ов пхэнляс: — Со тэ дав тут? Ой пхэнляс: — То печяти опэр гайтани тай ровли, сави тутэ андэ васт. Ов диняс ла алаи адава тай суто ласа, тай ой насвалили пуёстэ лэстар. ");
INSERT INTO rmn_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Ой гели отхар, пхучярдяспэс тай генэ урявдяс пхивляки савутя. ");
INSERT INTO rmn_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Одова вахыти о Иуда бичялдяс пэ амалэс э адулламитянес бузнорэса, тэ лэл палэ одова, со ачявдяс одолэ джювлятэ, ай о амал на аракхляс ла. ");
INSERT INTO rmn_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Ов пхучляс атхутнэ манушэндэ: — Кай э храмески кахпэиса, сави сас бэшли ко дром андэ Энаим? Он пхэнлэ: — Атхэ на сас нисави храмески кахпэиса. ");
INSERT INTO rmn_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Ов ало ко Иуда тай пхэнляс: — Мэ на аракхлём ла, тай о мануша одолэ тханэски пхэнлэ: «Атхэ нанай нисави храмески кахпэиса» . ");
INSERT INTO rmn_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","О Иуда пхэнляс: — Мэ ачявэл пэски одова, со лиляс, я кан овас андэ ладжявастэ. Вай мэ бичялдём лаки бузнорэс, ай ту ла на аракхлян. ");
INSERT INTO rmn_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Тринэ чёнэндар э Иудаски пхэнлэ: — Ти бори э Тамарь пэли андэ кахпэлыки тай одолэстар насвалили пуёстэ. О Иуда пхэнляс: — Никалэн ла, тай ой мэ овэл тхарди! ");
INSERT INTO rmn_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ай кана ла никалдэ аври, ой бичялдяс ко састро тэ пхэнэн: — Мэ насвали пуёстэ катар мануш, каски си акала шэя. — Генэ пхэнляс: — Дикх, на пэнджярэс, каски акава печяти, гайтани тай ровли? ");
INSERT INTO rmn_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","О Иуда пэнджярдяс лэн тай пхэнляс: — Ой чячи, ниш мэ, вай мэ на динём ла мэ чявэстэ ко Шэла. Ов генэ на пашлёлас ласа. ");
INSERT INTO rmn_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Кана ало лаки вахыти тэ аракхлёл пуёс, андэ латэ сас чяворэ-огизя. ");
INSERT INTO rmn_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Кана латэ аракхлёнас, о екх андар лэндэ никалдяс васт. Дэчи э джювли, кай керэлас ярдыми тэ аракхлён, лиляс лоло тхав, пханляс лэско васт тай пхэнляс: — Адава никлисто ангал. ");
INSERT INTO rmn_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ай ов сидиняс о васт палэ, тай никлисто лэско пхрал. Дэчи ой пхэнляс: — Сар адава ту накхлян? Тай лэс тхэдэ Парец. ");
INSERT INTO rmn_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Дэчи никлисто ли одова, савэстэ опэр васт сас лоло тхав, тай лэс тхэдэ Зерах. ");
INSERT INTO rmn_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","О измаилитяня андэ э Иосифес андэ Египти, тай о египтяни о Потифар, ярдымари э фараонеско тай баро опэр лэски барэндэ, киндяс лэс лэндэ. ");
INSERT INTO rmn_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","О Сагбус о Яхвэ сас э Иосифеса, тай лэстэ алаи сас лачё, кай бэшэлас андэ кхер пэ египетски сагбустэ. ");
INSERT INTO rmn_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Лэско сагбус дикхляс, кай о Сагбус о Яхвэ сас э Иосифеса тай кай Ов дэл лэс лачипэ андэ алаестэ, со ов керэл. ");
INSERT INTO rmn_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","О Иосиф аракхляс лачипэ андэ лэски якхендэ тай уло лэско иргати. О Потифар тхэдяс лэс опэр пэ кхерэстэ тай диняс лэс тэ дикхел пал алаи пэ мангинэстэ. ");
INSERT INTO rmn_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Тай одолэ вахытестар, сар ов тхэдяс лэс опэр пэ кхерэстэ тай опэр алаи ко мангин, о Сагбус о Яхвэ алгышты о кхер э египтянеско булуб э Иосифески. О алгыштима э Сагбуско сас опэр алаестэ, со сас ко Потифари, — тай андэ кхер, тай андэ ливади. ");
INSERT INTO rmn_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Оничин ов диняс, тэ дикхел о Иосиф пал алаестэ, со лэстэ сас. Булуб э Иосифески ов ништоски на керэлас касывэти, екх тэ хал. Ко Иосиф сас лачё стани тай шукар, ");
INSERT INTO rmn_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","тай вахытестар э ромни лэски сагбуски лиляс тэ дикхел карин лэстэ: — Пашлё манца! ");
INSERT INTO rmn_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ай ов на мангляс, пхэнляс: — Манца мо сагбус ништоски на керэл касывэти андэ кхер. Алаи, со си лэстэ, ов диняс мандэ тэ дикхав пал лэстэ. ");
INSERT INTO rmn_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Андэ адалэ кхерэстэ мэ алаендар баро. Мо сагбус диняс ман алаи, булуб тутар, вай ту — лэски ромни. Сар мэ тэ керав асавко баро джюнгалипэ тай керав бэзя ангал Дэл? ");
INSERT INTO rmn_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ой мангелас лэс кажын дес, ай ов на мангелас тэ пашлёл ласа тай джи тэ овэл ласа. ");
INSERT INTO rmn_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Екхвар ов диняс андэ кхер пэ дилаки, кана никхон андар кхерутнэ на сас андэ кхер. ");
INSERT INTO rmn_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Ой диняс бурнэк лэс савутендар тай пхэнляс: — Пашлё манца! Ай ов сидиняспэс тай нашло, ачявдяс опрунэ савутя латэ андэ васта. ");
INSERT INTO rmn_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Кана ой дикхляс, кай ов нашло тай ачявдяс о савутя латэ андэ васта, ");
INSERT INTO rmn_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ой диняс икос э кхерутнэ иргатен тай пхэнляс лэнги: — Дикхен, адалэ евреес андэ амэндэ андэ кхер, ай ов керэл амэнги маскаралыки! Ов ало атхэ тай мангляс тэ пашлёл манца, ай мэ лилём тэ дав бэбэря. ");
INSERT INTO rmn_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Ай ов мэ бэбэрятар ачявдяс пэ савутя тай нашло. ");
INSERT INTO rmn_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ой астарэлас о савутя э Иосифески пэстэ, бискай на ало кхерэ лэско сагбус. ");
INSERT INTO rmn_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Ой пхукавдяс лэски одова жэ пхукаипэ: — Адава иргати, о евреи, савэс ту амэндэ андян, ало мандэ тай мангляс мандар тэ керэл маскаралыки, ");
INSERT INTO rmn_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","ай мэ лилём тэ дав бэбэря, тай ов ачявдяс мандэ пэ савутя тай нашло. ");
INSERT INTO rmn_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Кана лэско сагбус шунляс о пхукаипэ пэ ромняко, сави пхэнляс: «Аки со то иргати кердяс манца», ов лачес холясаило. ");
INSERT INTO rmn_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Ов лиляс э Иосифес тай бэшавдяс лэс андэ пханли, катэ сас о патишайлытика пханлимаря. Тай аякха о Иосиф уло андэ пханли. ");
INSERT INTO rmn_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ай о Сагбус о Яхвэ сас лэса; Ов кердяс лэски мила, тай о баро опэр барэ сас лачё лэса. ");
INSERT INTO rmn_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","О баро опэр барэ тхэдяс э Иосифес опэр алаи ко пханлимаря, тай ов дикхелас пал алаи ко дилэс андэ пханли. ");
INSERT INTO rmn_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","О баро опэр барэ на дикхелас пал одолэстэ, пал состэ дикхелас о Иосиф, вай о Сагбус о Яхвэ сас э Иосифеса тай дэлас лэс лачипэ андэ алаи ко дилэс. ");
INSERT INTO rmn_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Сар савэ вахытестар э винаскочёрдимари тай о пэкимари э египтески патишаески сас дошалэ ангал пэ сагбустэ, ко патишаи э Египтеско. ");
INSERT INTO rmn_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","О фараони холясаило пэ до иргатенги, э барэ винаскичёрдимарески тай э барэ пэкимарески, ");
INSERT INTO rmn_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","тай пханляс лэн андэ пханли андэ кхер ки барэско опэр барэ, отхэ, катэ сас пханло о Иосиф. ");
INSERT INTO rmn_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","О баро опэр барэ диняс лэн ко Иосиф, тай одова дикхелас пал лэндэ. Он сас пханлэ сарсаво вахыти, ");
INSERT INTO rmn_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","тай аки он о дуй — э винаскочёрдимари тай о пэкимари э египтески патишаески, савэ сас бэшлэ андэ пханли, андэ екх рат дикхлэ сунэ, тай кажни суно галярэлас шо-то пинро. ");
INSERT INTO rmn_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Кана о Иосиф ало лэндэ авэр сабаги, ов дикхляс, кай он касывэтлыдэс. ");
INSERT INTO rmn_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Ов пхучляс э фараонески иргатен, пханлэн екхетханэ лэса андэ кхер лэски сагбустэ: — Соски тумэ авдес касывэтлыдэс? ");
INSERT INTO rmn_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","— Амэ о дуй дикхлям сунэ, — пхэнлэ он, — ай тэ галярэл лэн нанай кон. О Иосиф пхэнляс лэнги: — Та со, о галярипэ на катар Дэл? Пхукавэн манги тумарэ сунэ. ");
INSERT INTO rmn_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","О баро винаскочёрдимари пхукавдяс э Иосифески по суно: — Мэ дикхлём андэ суно дракхаки лазас, ");
INSERT INTO rmn_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","тай опэр лазас сас трин веткес. Залак сикавдэпэс о почкес тай пхари, тай о лулудя улэ бирдэн веткес дракхаки. ");
INSERT INTO rmn_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Мандэ андэ васт сас кадеи э фараонеско. Мэ лилём э дракх, бастым о соки андэ кадеи тай динём о кадеи ко фараони. ");
INSERT INTO rmn_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","— Аки со адава, — пхэнляс лэски о Иосиф. — Трин веткес — адава трин дес. ");
INSERT INTO rmn_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Тринэ десендар о фараони кан ваздэл тут тай кан тхэл, катэ санас, тай ту кан дэс ко фараони лэско кадеи, сар авгутнэ вахытя, кана ту санас лэско винаскочёрдимари. ");
INSERT INTO rmn_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ай мангав тут, андэ одола лаче деса тюшундие мандар тай кер манги мила: пхэн мандар э фараонески, тэ мукел ман андар пханли. ");
INSERT INTO rmn_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Вай ман зораса гелдэ катар пху ки евреенги, тай атхэ мэ ништо на кердём асавко, тэ бэшав андэ пханли. ");
INSERT INTO rmn_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","О баро пэкимари дикхляс, кай о Иосиф диняс лачё галярипэ, тай пхэнляс э Иосифески: — Ли мэ дикхлём суно: мэ астаравас опэр мэ шэрэстэ трин сэпэтя манрэса. ");
INSERT INTO rmn_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Андэ опрунятэ сас вэрсаво пэкипэ э фараонески, ай ла чюкудиенас о чирикля доврус андар сэпэти опэр мэ шэрэстэ. ");
INSERT INTO rmn_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","— Аки со си адава, — пхэнляс о Иосиф. — Трин сэпэтя — адава трин дес. ");
INSERT INTO rmn_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Тринэ десендар о фараони кан ваздэл ли тут — туки кан чинэн о шэро, ай о тэни кан илдиен опэр тэрэки, тай о чирикля кан чюкудиен лэс. ");
INSERT INTO rmn_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ко трито дес, андэ лэско дес, кана аракхлило о фараони, ов кердяс хабэ алаи пэ манушэнги, тай машкарэ лэндэ ов ваздиняс э барэ винаскичёрдимарес тай э барэ пэкимарес: ");
INSERT INTO rmn_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","э барэ винаскичёрдимарес ов тхэдяс лэски тханэстэ, тай одова генэ диняс о кадеи андэ васт ко фараони, ");
INSERT INTO rmn_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","ай э барэ пэкимарес илды опэр тэрэки, сар о Иосиф пхэнляс лэнги андэ пэ галяримастэ. ");
INSERT INTO rmn_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ай о баро винаскочёрдимари на тюшунды катар Иосиф; ов бристэрдяс лэстар. ");
INSERT INTO rmn_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Накхло дуй брэш, тай о фараони дикхляс суно: ов сас тэрдо паш ко диряв Нил, ");
INSERT INTO rmn_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","тай аки андар диряв ваздиндилэ эфта гурувня — шукара тай тхулэ — тай лилэ тэ чярён андэ трастникя. ");
INSERT INTO rmn_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Пал лэндэ никлистэ андар Нил авэра эфта гурувня — нашукара тай кишлэ — тай тэрдилэ паш одолэндэ паш ки диряв. ");
INSERT INTO rmn_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Тай о нашукара, о кишлэ гурувня халэ э эфта джяладимэнэн, тхулэ гурувнен. Тай о фараони джянгавдило. ");
INSERT INTO rmn_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ов суто генэ, тай ов дикхляс авэр суно: эфта эрнэкя — барэ тай пхэрдэ — барёнас опэр екх ветка. ");
INSERT INTO rmn_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Пал лэндэ барилэ генэ эфта эрнэкя — шуке тай тхардэ васточни балваляса. ");
INSERT INTO rmn_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","О шуке эрнэкя накхавдэ о эфта барэ, пхэрдэ. Тай о фараони джянгавдило. Адава сас суно. ");
INSERT INTO rmn_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Сабахтан э траш на мукелас лэс. Ов диняс икос алаи э магиен тай э бут годявэрэн э Египтески тай пхукавдяс лэнги пэ сунэ, ай никхон нащи лэн галярдяс. ");
INSERT INTO rmn_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Дэчи о баро винаскочёрдимари пхэнляс э фараонески: — Акана мэ тюшундияв, кай дошало. ");
INSERT INTO rmn_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Екхвар о фараони холясаило опэр пэ иргатендэ тай пханляс ман тай э барэ пэкимарес андэ кхер ки барэско опэр барэ. ");
INSERT INTO rmn_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Ли мэ, ли ов андэ екх рат дикхлям суно, тай кажни сунэстэ сас лэско галярипэ. ");
INSERT INTO rmn_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Отхэ амэнца сас тэрно евреи, о иргати э барэско опэр барэ. Амэ пхукавдям лэски амарэ сунэ, тай ов галярдяс лэн амэнги; кажнески ов галярдяс. ");
INSERT INTO rmn_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Тай сар ов галярдяс, аякха да уло: ман тхэдэ ки баштутни бути, ай околэс илдылар опэр тэрэки. ");
INSERT INTO rmn_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","О фараони бичялдяс пал Иосиф, тай лэс чяльти андэ андар пханли. Ов моравдяспэс, паровдяс о савутя тай тэрдило ангал фараони. ");
INSERT INTO rmn_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","О фараони пхэнляс э Иосифески: — Мэ дикхлём суно, тай никхон нащи галярэл лэс. Ай мэ шунлём тутар, кай ту галёс о сунэ тай галёс тэ галярэс лэн. ");
INSERT INTO rmn_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","О Иосиф пхэнляс: — На мэ, ами о Дэл кан пхэнэл э фараонески лачё галярипэ. ");
INSERT INTO rmn_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","О фараони пхэнляс э Иосифески: — Мэ дикхлём суно, кай мэ тэрдо паш ко диряв Нил, ");
INSERT INTO rmn_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","тай бирдэн андар диряв ваздиндилэ эфта гурувня, тхулэ тай шукара, тай лилэ тэ чярён андэ трастникя. ");
INSERT INTO rmn_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Пал лэндэ ваздиндилэ эфта авэра гурувня — кокалангерэ, кишлэ тай нашукара, савэ мэ буруни на дикхлём опэр алаи ки пху ки Египтески. ");
INSERT INTO rmn_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","О кишлэ, нашукара гурувня халэ о эфта тхулэ гурувнен, савэ никлистэ буруни. ");
INSERT INTO rmn_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ай адава на гело лэнги лачимаски: он ачилэ асавке жэ нашукара, сар сас. Тай мэ джянгавдилём. ");
INSERT INTO rmn_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Дэчи мэ дикхлём андэ суно эфта эрнэкя опэр екх ветка, пхэрдэ лачё гив. ");
INSERT INTO rmn_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Пал лэндэ барилэ авэра эфта эрнэкя — шуке, кишлэ тай тхардэ васточни балваляса. ");
INSERT INTO rmn_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","О шуке эрнэкя накхавдэ о эфта пхэрдэ эрнэкя. Мэ пхукавдём э магиенги, ай никхон нащи галярдяс манги. ");
INSERT INTO rmn_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","О Иосиф пхэнляс э фараонески : — О галярипэ э фараонески до сунэнго екх. О Дэл пхутэрдяс э фараонески, со Ов кидэлпэс тэ керэл. ");
INSERT INTO rmn_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Эфта лаче гурувня — адава эфта брэш, ай эфта лаче эрнэкя — адава эфта брэш; о галярипэ екх. ");
INSERT INTO rmn_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Эфта кишлэ, нашукара гурувня, савэ алэ палал, — адава эфта брэш. Аякхажэ эфта кишлэ эрнэкя, тхардэ васточни балваляса, — адава эфта брэш бокхаки. ");
INSERT INTO rmn_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Аки состар мэ пхэнавас, кана пхэнлём э фараонески, кай о Дэл пхутэрдяс лэски, со Ов мангел тэ керэл. ");
INSERT INTO rmn_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Опэр пху ки Египтески авэн эфта брэш барэ чялимаски, ");
INSERT INTO rmn_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","ай пал лэндэ кан авэн эфта брэш бокхаки, кана алаи о чялипэ андэ Египти кан овэл бристэрно, тай э бокх кан чючярэл э пху. ");
INSERT INTO rmn_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Ангалутно чялипэ кан бристэрдёл андэ адалэ пхуятэ андар бокх, саво кан авэл пал лэстэ, вай э бокх кан овэл зорали. ");
INSERT INTO rmn_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ай одова, кай о суно сас э фараонески дувар, си, кай о Дэл чячес кан керэл адава тай чяльти кан овэл, со Ов мангел тэ керэл. ");
INSERT INTO rmn_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Мэ аракхел о фараони галяримаски тай годявэрэ манушэс тай мэ тхэл лэс опэр пху ки Египтески. ");
INSERT INTO rmn_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Мэ тхэл о фараони барэн опэр алаи ки пху, тэ кидэн он панджто паи гив андэ Египти андэ одола эфта брэш э чялимаски. ");
INSERT INTO rmn_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Андэ одола лаче брэша он мэ кидэн алаи о хапэ, кай авэл лэндэ, тай э фараонески зораса мэ кидэн гив тай мэ гаравэн андэ диза. ");
INSERT INTO rmn_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Адава хапэ э пхуяки кан овэл ачявдо, э пху тэ на мэрэл андэ одола эфта брэш э бокхаки, савэ дэчи кан овэн андэ Египти. ");
INSERT INTO rmn_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","О фараони тай лэски ярдымаря пхэнлэ лачи адая дила. ");
INSERT INTO rmn_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","О фараони пхучляс пэ ярдымарен: — Кан аракхас амэ генэ асавкес, сар адава мануш, андэ савэстэ о Духос э Дэвлэско? ");
INSERT INTO rmn_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Тай о фараони пхэнляс э Иосифески: — Тэ пхутэрдяс о Дэл туки алаи адава, нанай асавко годявэр тай галярдо мануш, сар ту. ");
INSERT INTO rmn_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Мэ тхав тут опэр мэ кхерэстэ, тай алаи мо дюняс кан шунэл, со ту кан пхэнэс. Екх тронеса мэ кан овав учё тутар. ");
INSERT INTO rmn_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","О фараони пхэнляс э Иосифески: — Дикх, мэ тхав тут опэр алаи ки пху ки Египтески. ");
INSERT INTO rmn_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Ов читяс пэ наестар э ангрусти тай урявдяс ко най ки Иосифеско, ов урявдяс лэс андэ савутя санэ басмастар тай илды лэски мэнятэ пхоляки джянджир. ");
INSERT INTO rmn_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Ов пхэнляс тэ пхеравэн лэс андэ бричка сар дуйтонэс пал пэстэ тай тэ дэн бэбэря ангал лэстэ: «Бангём!» Аякха ов тхэдяс лэс опэр алаи ки пху ки Египтески. ");
INSERT INTO rmn_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","О фараони пхэнляс э Иосифески: — Мэ фараони, ай би тэ зборако никхон андэ алаи ко Египти на кан кхелавэл наеса. ");
INSERT INTO rmn_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Ов диняс э Иосифес нав Цафнат-Панеах тай диняс лэс ромня э Асната, э чяя Поти-Пераски, саво сас попази э дизако, кай бучёлас Он. Тай гело о Иосиф ко дром опэр алаи Египтески пху. ");
INSERT INTO rmn_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Э Иосифески сас триянда брэш, кана ов лиляс тэ керэл бути э фараонески, э Египтески патишаески. Ов никлисто катар фараони тай гело ко дром опэр алаи ко Египти. ");
INSERT INTO rmn_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Андэ эфта брэш ки чялимаски э пху дэлас бут гив. ");
INSERT INTO rmn_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","О Иосиф кидэлас алаи о гив одола эфта брэш э чялимаски андэ Египти тай тхэлас андэ диза. Андэ кажни дизатэ ов кидэлас о гив агорял катар ливадя. ");
INSERT INTO rmn_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","О гив, кай кидиняс о Иосиф, сас, сар кишай ки моря, тай ов тэрдило тэ гинэл лэс, вай нащи лэс гинэсас. ");
INSERT INTO rmn_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Ангал отхэ, кай алэ о брэша э бокхаки, ко Иосиф аракхлилэ дуй чявэ катар Асната, э чяй э Поти-Пераски. Ов сас о попази э дизако, кай бучёлас Он. ");
INSERT INTO rmn_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","О Иосиф тхэдяс пэ баштутнэс Манассия тай пхэнляс: «О Дэл диняс ман тэ бристав алаи мэ касывэтя тай о кхер мэ дадэско». ");
INSERT INTO rmn_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Э дуйтонэс чявэс тхэдяс Ефрем, пхэнляс: «О Дэл алгышты ман ки пху мэ касывэтестэ». ");
INSERT INTO rmn_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Эфта брэш э чялимаски андэ Египти бытылар, ");
INSERT INTO rmn_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","тай улэ эфта брэш бокхаки, сар о Иосиф галярдяс. Э бокх сас алаи авэрэ пхуендэ, екх андэ пху ки Египтески сас хапэ. ");
INSERT INTO rmn_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Кана алаи о Египти лиляс тэ бокхалёл, о дюняс мангляс ко фараони хапэ, тай о фараони пхэнляс э египтяненги: — Джян ко Иосиф тай керэн, сар ов кан пхэнэл. ");
INSERT INTO rmn_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Кана э бокх ули опэр алаи ки пху, о Иосиф пхутэрдяс о араня тай лиляс тэ бикнэл о гив э египтяненги, вай э бокх андэ Египти сас бари. ");
INSERT INTO rmn_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Андар алаи ко пхуя авэнас андэ Египти, тэ кинэн ко Иосиф гив, вай опэр алаи ко дюняс сас бари бокх. ");
INSERT INTO rmn_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Кана о Яков галило, кай андэ Египти си гив, ов пхэнляс пэ чявэнги: — Со тумэ дикхен карин екхаврэстэ? — ");
INSERT INTO rmn_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","тай генэ пхэнляс: — Мэ шунлём, кай андэ Египти си гив. Джян кинэн лэс амэнги, амэ тэ на мэрас. ");
INSERT INTO rmn_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Дэш пхрала э Иосифески гелэ андэ Египти, тэ кинэн гив, ");
INSERT INTO rmn_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","ай э Вениаминес, э Иосифески пхралэс, о Яков на мукляс авэрэ пхралэнца. Ов пхэнляс: — Тэ на овэл лэса хурлуки. ");
INSERT INTO rmn_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Аякха машкарэ аврэндэ ли о чявэ э Израилескерэ алэ тэ кинэн гив, вай ки пху Ханаан сас бокх. ");
INSERT INTO rmn_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","О Иосиф сас сагбус опэр алаи ки пху. Ов бикнэлас гив э дюняски андэ алаи ко Египти. Кана о пхрала э Иосифески алэ, он бангилэ лэски джи ки пху. ");
INSERT INTO rmn_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Сар о Иосиф дикхляс пэ пхралэн, ов пэнджярдяс лэн, ай кердяспэс, кай на джянэл лэн, тай зборисаило лэнца баримаса. — Катар тумэ алянус? — пхучляс ов. — Катар пху Ханаан, тэ кинас хапэ, — пхэнлэ он. ");
INSERT INTO rmn_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","О Иосиф пэнджярдяс пэ пхралэн, ай он на пэнджярдэ лэс. ");
INSERT INTO rmn_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Ов тюшунды пэ сунэ лэндар тай пхэнляс: — Тумэ — душманя! Тумэ алянус тэ вардиен о назоралэ тхана амарэ пхуятэ. ");
INSERT INTO rmn_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","— Ту со, сагбуса, — пхэнлэ он. — Тэ иргатя алэ тэ кинэн хапэ. ");
INSERT INTO rmn_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Амэ алаи о чявэ екхе дадэски. Тэ иргатя чяче мануша, на душманя. ");
INSERT INTO rmn_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Ов пхэнляс лэнги: — На, тумэ алянус тэ вардиен, катэ си андэ амарэ пхуятэ назоралэ тхана. ");
INSERT INTO rmn_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ай он пхэнлэ: — Тэ иргатя сас дэшудуй пхрала, чявэ екхе дадэски, саво бэшэл опэр пху Ханаан. О тикно ли анкха амарэ дадэса, ай о екх нанай. ");
INSERT INTO rmn_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","О Иосиф пхэнляс лэнги: — Мэ вай пхэнлём, кай тумэ — душманя! ");
INSERT INTO rmn_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Тай аки сар мэ тумэн кан галяв: хав совля э фараонески бэшымаса: тумэ на кан джян атхар, бискай на кан авэл атхэ тумаро тикно пхрал. ");
INSERT INTO rmn_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Бичялэн екхес андар тумэндэ пал тумарэ пхралэстэ, ай алаи кан овэн бэшлэ андэ пханли. Аякха мэ кан галяв тумарэ зборэс — чячипэ тумэ манги пхэнэн я на. Тэ на, хав совля э фараонески бэшымаса, тумэ душманя! ");
INSERT INTO rmn_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Тай ов пханляс лэн тринэ десенги. ");
INSERT INTO rmn_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ко трито дес о Иосиф пхэнляс лэнги: — Керэн, со мэ кан пхэнав, тай кан ачён дживиндэ, вай мэ трашав катар Дэл. ");
INSERT INTO rmn_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Тумэ тэ санус чяче мануша, о екх андар тумэндэ мэ ачёл атхэ андэ пханли, ай авэра мэ гелэн о гив тумарэ бокхалэ хорандадэнги. ");
INSERT INTO rmn_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Ай тумэ камэл тэ анэн мандэ тумарэ тикнэ пхралэс, тэ овэн тумарэ зборэс чяче тай тумэ тэ ачён дживиндэ. Аякха он да кердэ. ");
INSERT INTO rmn_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Он пхэнлэ екхаврэски: — Галилям, кай амэ сидас хурлуки андар амарэ пхралэстэ. Амэ дикхлям лэски касывэти, кана ов мангелас амэн, ай амэ на шунасас, тай аки амэнги уло одова жэ хурлуки. ");
INSERT INTO rmn_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","О Рувим пхэнляс: — Мэ вай пхэнавас тумэнги, ма керэн бэзя мамуй ко чяворо, ай тумэ на шунлянус! Акана авэл покиндима андар лэски ратэстэ. ");
INSERT INTO rmn_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Он на тюшундиенас, кай о Иосиф галёл лэн, вай ов зборизэлас лэнца манушэса, саво джянэлас лэнги чиб. ");
INSERT INTO rmn_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Ов болдиняспэс лэндар тай руно, дэчи генэ болдиняспэс тай зборисаило лэнца. Ов лиляс лэндар э Симеонес тай пханляс лэс ангал лэнги якхендэ. ");
INSERT INTO rmn_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","О Иосиф пхэнляс тэ пхэрэн лэнги гонэ гив, тэ тхэн лэнги руп кажнески палэ андэ лэски гонэстэ тай тэ пхэрэн лэнги опэр дром. Аякха да сас кердо. ");
INSERT INTO rmn_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Он тхэдэ о гив опэр джёрэ тай гелэ ко дром. ");
INSERT INTO rmn_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Кана он тэрдилэ тэ раткерэн, о екх андар лэндэ пхутэрдяс о гоно, тэ лэл хапэ э джёрэски, тай дикхляс андэ гоно по руп. ");
INSERT INTO rmn_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","— Мо руп палэ ало! — пхэнляс ов пэ пхралэнги. — Аки ов, андэ мэ гонэстэ. Лэнго ило тэрдило; он андэ траш болдинэпэс екхаврэстэ тай пхэнлэ: — Со адава кердяс амэнца о Дэл? ");
INSERT INTO rmn_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Он алэ пумарэ дадэстэ ко Яков ки пху Ханаан, пхукавдэ лэски алаестар, со лэнца уло. Он пхэнлэ: ");
INSERT INTO rmn_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","— О мануш, саво си опэр одолэ пхуятэ, зборизэлас амэнца зораса тай галило амэн душманен. ");
INSERT INTO rmn_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ай амэ пхэнлям лэски: «Амэ чяче мануша, на душманя. ");
INSERT INTO rmn_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Амэ самас дэшудуй пхрала, чявэ екхе дадэски. О екх анкха нанай, ай о тикно анкха э дадэса андэ Ханаан». ");
INSERT INTO rmn_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Дэчи о мануш, кай опэр одоя пху, пхэнляс амэнги: «Аки сар мэ кан галяв, тумэ чяче мануша я на: ачявэн екхе пхралэс атхэ манца, лэн хапэ тумарэ бокхалэ хорандадэнги тай джян тумаро дром. ");
INSERT INTO rmn_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ай анэн мандэ тумарэ тикнэ пхралэс. Аякха мэ кан галяв, кай тумэ на душманя, ами чяче мануша. Дэчи мэ кан дав тумэн тумарэ пхралэс тай кан мукав тумэн тэ пхерэн андэ адая пху». ");
INSERT INTO rmn_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Кана чючярэнас о гонэ, кажни аракхляс андэ по дорбасоро э рупаса. Кай дикхлэ э руп, ли он, тай ли лэнго дад трашанилэ. ");
INSERT INTO rmn_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","О Яков пхэнляс лэнги: — Тумэ ачявдянус ман би пуенго. О Иосиф тай о Симеон амэнца нанай, ай акана тумэ манген тэ лэн э Вениаминес. Алаи болдиндило мамуй мандэ! ");
INSERT INTO rmn_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","О Рувим пхэнляс пэ дадэски: — Мудар мэ до чявэн, мэ тэ на анава лэс палэ тутэ. Дэ лэс андэ мэ вастэндэ, тай мэ кан анав лэс палэ. ");
INSERT INTO rmn_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ай о Яков пхэнляс: — Мо чяво на кан джял отхэ туса. Лэско пхрал муло, ов ачило екх. Опэр дром лэса тэ овэла хурлуки, адалэ касывэтеса тумэ кан тхэн мо сиво шэро андэ дюняс ки мулэнго. ");
INSERT INTO rmn_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Андэ одолэ пхуятэ аякхажэ сас зорали, бари бокх. ");
INSERT INTO rmn_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Кана он халэ алаи о гив, кай андэ андар Египти, о дад пхэнляс лэнги: — Джян палэ тай кинэн генэ набут хапэ. ");
INSERT INTO rmn_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ай о Иуда пхэнляс лэски: — Одова мануш зораса пхэнляс амэнги: «Ма сикавэн тумэн мэ якхендэ, тумэнца тэ на овэла тумаро пхрал». ");
INSERT INTO rmn_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ту тэ мукеса амэнца амарэ пхралэс, амэ кан джяс тай кан кинас туки хапэ. ");
INSERT INTO rmn_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ай тэ на мукеса лэс, амэ на кан джяс, вай одова мануш пхэнляс амэнги: «Ма сикавэн тумэн мэ якхендэ, тумэнца тэ на овэла тумаро пхрал». ");
INSERT INTO rmn_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","— Соски тумэ кердянус манги адава касывэти, соски пхэнлянус одолэ манушэски, кай тумэндэ си генэ пхрал? — пхучляс о Израиль. ");
INSERT INTO rmn_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Он пхэнлэ: — Одова мануш алаи пхучелас амэн амэндар тай амарэ хорандастар: «Дживиндо дага тумаро дад? Нанай тумэн генэ пхрал?» Амэ пхэнасас лэски, со пхучелас. Катар амэ джянасас, кай ов кан пхэнэл: «Анэн атхэ тумарэ пхралэс»? ");
INSERT INTO rmn_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","О Иуда пхэнляс э Израилески, пэ дадэски: — Мук э чяворэс манца, тай амэ чяльти кан джяс, алаи амэ тэ овас дживиндэ тай тэ на мэрас: ли амэ, ли ту, тай амарэ пуя. ");
INSERT INTO rmn_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Мэ кан дикхав пал лэстэ; мандар ту кан пхучес лэс. Тэ на анава мэ лэс тутэ тай на кан тхав акатэ ангал тутэ, мэ кан овав дошало ангал тутэ, бискай на мэрав. ");
INSERT INTO rmn_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Тэ на овас тэмэля, кан джясас тай кан авасас дувар. ");
INSERT INTO rmn_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Дэчи лэнго дад о Израиль пхэнляс лэнги: — Тэ камэл адава тэ керэн, дэчи керэн аки со: тхэн андэ дорбадэс о лаче имиша адалэ пхуяки та гелэн, башладиен одолэ манушэс: бальзами тай бали, чяря тай мирра, фисташкес тай миндали. ");
INSERT INTO rmn_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Лэн дувар бут руп, тумэ тэ анэн тумэнца ли одова, со сас тхэдо палэ андэ тумарэ гонэ. Файма, он на галилэ. ");
INSERT INTO rmn_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Лэн ли тумарэ пхралэс тай джян генэ одолэ манушэстэ. ");
INSERT INTO rmn_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Мэ дэл о Дэл о Баро-Зорало тумэн мила ангал лэстэ, ов тэ мукел авэрэ тумарэ пхралэс, тай э Вениаминес тэ авэн палэ тумэнца. Ай мэ тэ камэл тэ ачяв би пуенго, мэ овэл аякха. ");
INSERT INTO rmn_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Он лилэ одова, со пхэнляс лэнги о дад, тай дувар бут руп, дэчи лилэ э Вениаминес тай гелэ ко Египти. Он тэрдилэ ангал Иосиф. ");
INSERT INTO rmn_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Кана о Иосиф дикхляс, кай о Вениамин лэнца, ов пхэнляс пэ ярдымарески: — Гел адалэ манушэн мандэ андэ кхер, чинэн савэ-то гайванес тай тавэн хапэ. Десе он кан хан манца. ");
INSERT INTO rmn_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","О мануш кердяс, сар сас лэски пхэнло, андяс лэн андэ кхер ко Иосиф. ");
INSERT INTO rmn_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Он трашанилэ, кана лэн андэ лэстэ андэ кхер, вай тюшундылар: «Амэн андэ атхэ андар руп, саво сас андэ амарэ гонэ баштутно рази. Ов мангел тэ пэрэл опэр амэндэ, тай тэ лэл амэн андэ иргатлыки, тай тэ лэл амарэ джёрэн». ");
INSERT INTO rmn_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Он пашылэ ко ярдымари ки Иосифеско тай зборисаилэ лэса паш ко удар, кай дэс андэ кхер: ");
INSERT INTO rmn_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","— Шун, сагбуса, — пхэнлэ он, — амэ екхвар алямас атхэ тэ кинас хапэ, ");
INSERT INTO rmn_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","ай кана амэ тэрдилям ратяки тай пхутэрдям о гонэ, кажын андар амэндэ аракхляс андэ по руп, сокабор сас. Оничин амэ андям лэс палэ. ");
INSERT INTO rmn_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Амэ андям амэнца генэ руп, тэ кинас хапэ. Амэ на джянас, кон баштутно рази тхэдяс амаро руп амэнги андэ гонэ. ");
INSERT INTO rmn_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ов пхэнляс: — Алаи лачё, ма трашан. Тумаро Дэл, о Дэл тумарэ дадэско, тхэдяс адава мангин андэ тумарэ гонэ. Ай ман динэ тумаро руп. Дэчи ов андяс лэндэ э Симеонес. ");
INSERT INTO rmn_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","О ярдымари андяс э пхралэн андэ кхер ко Иосиф, диняс лэн пани тэ халярэн пумарэ пинрэ тай диняс пхус лэнги джёрэн. ");
INSERT INTO rmn_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Он гортярдэ, со андэ, тэ дэн ко Иосиф, сар авэл десе, вай лэнги пхэнлэ, кай он отхэ кан хан. ");
INSERT INTO rmn_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Кана о Иосиф ало кхерэ, он динэ лэс, со андэ, тай бангилэ ангал лэстэ джи ки пху. ");
INSERT INTO rmn_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ов пхучляс лэнго такати, дэчи пхэнляс: — Ами сар си тумаро пхуро дад, савэстар тумэ пхэнэнас манги? Дживиндо ов дага? ");
INSERT INTO rmn_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Он пхэнлэ: — То иргати, амаро дад, дага дживиндо тай такатлыс. Тай бангилэ тэлэ, кай гинэн лэс. ");
INSERT INTO rmn_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","О Иосиф болдиняспэс тай дикхляс пэ пхралэс э Вениаминес, пэ дэяки чявэс. Ов пхучляс: — Адава — тумаро тикно пхрал? Одова, савэстар тумэ пхэнэнас манги? О Дэл мэ овэл миласа туки, мо чяво! ");
INSERT INTO rmn_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","О ило э Иосифеско пхэрдило дэхымаса тай ов кан ровэлас; Иосиф чяльти гело тай родэлас пханло тхан. Ов ало пэстэ тай отхэ лачес руно. ");
INSERT INTO rmn_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Дэчи ов халярдяс по муй, генэ никлисто тай астарэласпэс тэ на ровэл. Ов пхэнляс: — Анэн хапэ. ");
INSERT INTO rmn_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Лэски тхэдэ авэртэ тханэстэ, э пхралэнги тхэдэ авэртэ, тай э египтяненги, савэ ханас лэса, авэртэ, вай о египтяня нащи ханас э евреенца, адава сас гарами э египтяненги. ");
INSERT INTO rmn_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Э пхралэн бэшавдэ ангал лэстэ пал екхаврэстэ, катар баштутно джи ко тикно, тай он дикхенас карин екхаврэстэ шаштимэна. ");
INSERT INTO rmn_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Лэнги тхэнас хапэ опрал конас ки Иосифеско, ай э Вениаминески тхэнас панджвар бут, ниш аврэнги. Он ханас тай пиенас лэса. ");
INSERT INTO rmn_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","О Иосиф пхэнляс пэ ярдымарески: — Пхэр о гонэ адалэ манушэнги хапэ, сокабор кан гелэн, тай тхэ кажнески э руп палэ андэ гоно. ");
INSERT INTO rmn_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Ай андэ гоно ко тикно э рупаса андар гив тхэ мо кадеи, мо рупуно кадеи. Одова кердяс, сар пхэнляс о Иосиф. ");
INSERT INTO rmn_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Сар дисило, э пхралэн бичялдэ ко дром лэнги джёрэнца. ");
INSERT INTO rmn_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Он сас дага надур катар диз, кана о Иосиф пхэнляс э ярдымарески: — Чяльти рэс адалэ манушэн тай, кана кан рэсэс, пхэн лэнги: «Соски тумэ покиндянус джюнгалипэ э лачимаски? ");
INSERT INTO rmn_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Вай адава кадеи мэ сагбуско, андар савэстэ ов пиел тай опэр савэстэ ов дорикерэл! Тумэ кердянус налачи дила!» ");
INSERT INTO rmn_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ов рэсло лэн тай пхэнляс лэнги адала зборэс. ");
INSERT INTO rmn_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Он пхэнлэ: — Соски о сагбус пхэнэл асавке зборэс? Та со, тэ иргатя кан керэн асавко? ");
INSERT INTO rmn_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Вай амэ андям туки палэ катар пху Ханаан одова руп, саво аракхлям амэндэ андэ гонэ. Соски амэнги тэ чёрас руп я пхол андар кхер тэ сагбуско? ");
INSERT INTO rmn_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","О шэи тэ аракхлёла екхестэ андар тэ иргатендэ, мэ мэрэл ов, ай авэра мэ овэн иргатя амарэ сагбуски. ");
INSERT INTO rmn_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ов пхэнляс: — Лачё, мэ овэл аякха, сар тумэ пхэнэн: кастэ кан аракхлёл о кадеи, одова кан овэл мо иргати, ай авэра на кан овэн дошалэ. ");
INSERT INTO rmn_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","О пхрала чяльти муклэ кажни по гоно ки пху тай пхутэрдэ лэн. ");
INSERT INTO rmn_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","О ярдымари лиляс тэ родэл, катар баро джи ко тикно, тай о кадеи аракхлило андэ гоно ко Вениамин. ");
INSERT INTO rmn_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","О пхрала пхаравдэ опэр пэстэ о савутя, тхэдэ о гонэ, алаи кажни опэр пэ джёрэстэ, тай гелэ андэ диз. ");
INSERT INTO rmn_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","О Иуда тай лэски пхрала алэ андэ кхер ко Иосиф, саво дага сас отхэ. Он читэпэс ангал лэстэ ки пху. ");
INSERT INTO rmn_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","О Иосиф пхэнляс лэнги: — Со тумэ кердянус? Та со, тумэ на джянэнас, кай асавко мануш, сар мэ, кан галёл алаи андар дорикерипэ? ");
INSERT INTO rmn_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","— Со амэ тэ пхэнас мэ сагбуски? — пхэнляс о Иуда. — Сар амэнги тэ зборизас? Сар тэ галярас амаро чячипэ? О Дэл пхутэрдяс э дош тэ иргатенги. Акана амэ иргатя мэ сагбуски — ли амэ, ли одова, кастэ аракхлэ о кадеи. ");
INSERT INTO rmn_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","О Иосиф пхэнляс: — Та со, мэ кан керав асавко? Екх одова, кастэ аракхлило о кадеи, кан овэл мо иргати, ай тумэ джян тумарэ дадэстэ лачимаса. ");
INSERT INTO rmn_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Дэчи о Иуда пашыло лэстэ тай пхэнляс: — Мангав тут, мо сагбус, мук тэ иргатес тэ пхэнэл збора. Ма холязэ тэ иргатески, хоч ту — сар о фараони. ");
INSERT INTO rmn_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Мо сагбус пхучляс пэ иргатен: «Си тумэндэ дад я пхрал?» ");
INSERT INTO rmn_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Тай амэ пхэнлям: «Амэндэ си пхуро дад тай си лэско тэрно чяво, саво аракхлило лэски опэр пхуримастэ. Лэско пхрал муло, тай ов ачило екх андар чявэ пэ дэякерэндар, тай о дад дэхэл лэс». ");
INSERT INTO rmn_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Озаман ту пхэнлян тэ иргатенги: «Анэн лэс мандэ, мэ тэ дикхав карин лэстэ». ");
INSERT INTO rmn_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ай амэ пхэнлям мэ сагбуски: «О чяворо нащи кан ачявэл пэ дадэс. Ай тэ ачявэла, о дад кан мэрэл». ");
INSERT INTO rmn_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ай ту пхэнлян тэ иргатенги: «Бискай тумаро пхрал на кан авэл атхэ тумэнца, ма сикавэн тумэн мэ якхендэ». ");
INSERT INTO rmn_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Амэ алям тэ иргатестэ, амарэ дадэстэ, пхукавдям лэски, со пхэнляс мо сагбус. ");
INSERT INTO rmn_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Амаро дад пхэнляс: «Джян генэ тай кинэн генэ набут хапэ». ");
INSERT INTO rmn_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Ай амэ пхэнлям: «Амэ нащи джяс. Екх тэ джяла о тикно пхрал амэнца, дэчи амэ кан джяс. Амэ нащи джи ангал якха тэ сикавас амэн одолэ манушэски, тэ на овэла амэнца о тикно пхрал». ");
INSERT INTO rmn_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","То иргати, мо дад, пхэнляс амэнги: «Тумэ джянэн, кай мэ ромнятэ аракхлилэ дуй чявэ. ");
INSERT INTO rmn_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","О екх андар лэндэ на уло. Мэ пхэнлём: \"Гэлбэтэм, ов эсас джирдимэ котора\", — тай одолэ вахытестар мэ лэс на дикхлём. ");
INSERT INTO rmn_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Тумэ тэ лэна мандар ли аврэс, тай лэса кан овэл джюнгалипэ. Тумэ кан бичялэн мо сиво шэро катар касывэти андэ дюняс ки мулэнго». ");
INSERT INTO rmn_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Оничин, о чяворо тэ на овэла амэнца, кана мэ кан авав тэ иргатестэ, мэ дадэстэ, тай мо дад, саво аякха пханло адалэ чяворэстэ, ");
INSERT INTO rmn_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","кан дикхел, кай ов нанай амэнца, ов кан мэрэл. Тэ иргатя кан бичялэн о сиво шэро амарэ дадэско катар касывэти андэ дюняс ки мулэнго. ");
INSERT INTO rmn_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","То иргати пхэнляс ангал пэ дадэстэ, кай кан кутардиел э чяворэс. Мэ пхэнлём: «Дадэ, мэ тэ на анава лэс ангал тутэ, э дош ангал тутэ кан овэл опэр мандэ алаи мо бэшыпэ». ");
INSERT INTO rmn_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Акана, мангав тут, мук то иргати тэ ачёл атхэ иргати мэ сагбуско ко тхан ки чяворэско, тай мук э чяворэс тэ джял пэ пхралэнца. ");
INSERT INTO rmn_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Сар мэ тэ джяв мэ дадэстэ, о чяворо тэ на овэла манца? Тэ на дикхав мэ о касывэти мэ дадэско. ");
INSERT INTO rmn_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Озаман о Иосиф нащи астардяс пэс ангал иргатя тай пхэнляс: — Джян алаи мандар! Тай никхон на сас э Иосифеса, кана ов пхутэрдяспэс пэ пхралэнги. ");
INSERT INTO rmn_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ов аякха лачес руно, кай шунлэ о египтяня, тай шунлэ адалэстар джи ки бар ки фараонески. ");
INSERT INTO rmn_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","О Иосиф пхэнляс пэ пхралэнги: — Мэ — о Иосиф! Дживиндо дага мо дад? Ай о пхрала нащи пхэнлэ ништо — аякха он сас шаштимэна. ");
INSERT INTO rmn_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Дэчи о Иосиф пхэнляс пэ пхралэнги: — Пашон мандэ. Тай кана он пашылэ, ов пхэнляс: — Мэ — тумаро пхрал о Иосиф, савэс тумэ бикиндянус ко Египти! ");
INSERT INTO rmn_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ма керэн касывэти тай ма керэн генэ тумэн дошалэн андар одолэстэ, кай бикиндянус ман атхэ. Адава о Дэл бичялдяс ман ангал тумэндэ тэ кутардиндёл тумаро бэшыпэ. ");
INSERT INTO rmn_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ужэ дуй брэш, сар опэр пху бокх, тай генэ пандж брэш нэ на кан барярэн, нэ на кан кидэн. ");
INSERT INTO rmn_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Ай о Дэл бичялдяс ман ангал тумэндэ, тэ кутардиел тумарэ бэшыматэс тай тумари порода тэ ачёл опэр пху. ");
INSERT INTO rmn_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","На тумэ бичялдянус ман атхэ, ами о Дэл. Ов кердяс ман дад э фараонески, сагбус опэр алаи лэски кхерэстэ тай сагбус алаи э Египтеско. ");
INSERT INTO rmn_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Сигярэн тэ джян мэ дадэстэ тай пхэнэн лэски: «Аки со пхэнэл то чяво о Иосиф: \"О Дэл кердяс ман сагбус алаи э Египтеско. Чяльти элан мандэ. ");
INSERT INTO rmn_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ту кан бэшэс андэ область Гошэн тай кан овэс пашэ мандэ: ли ту, ли тэ пуя, ли тэ туруня, тэ барэ тай тикнэ гайваня, тай алаи, со тутэ си. ");
INSERT INTO rmn_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Отхэ мэ кан дикхав пал тутэ, вай кан овэн генэ пандж брэш бокх — я ли ту, ли то кхер, тай алаи, со си тинро, кан овэл андэ бокх\"». ");
INSERT INTO rmn_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Тумэ дикхен тумарэ якхенца, ли тумэ, ли мо пхрал о Вениамин, кай адава чячес мэ зборизав тумэнца. ");
INSERT INTO rmn_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Пхукавэн мэ дадэски одолэстар, сар мэ намлыс андэ Египти, тай алаестар, со тумэ дикхлянус. Тай чяльти анэн атхэ мэ дадэс. ");
INSERT INTO rmn_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Ов диняс ангали пэ пхралэс э Вениаминес тай руно. Ли о Вениамин ровэлас, кана дэлас ангали лэс. ");
INSERT INTO rmn_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ов чюмидиняс алаи пэ пхралэн тай роимаса дэлас ангали лэн. Дэчи о пхрала зборизэнас лэса. ");
INSERT INTO rmn_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","О нами одолэстар, кай алэ о пхрала э Иосифески, гело джи ки бар ки фараонески. О фараони тай лэски мануша лошасаилэ, ");
INSERT INTO rmn_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","тай о фараони пхэнляс э Иосифески: — Пхэн тэ пхралэнги: «Керэн аки со: тхэн опэр тумарэ гайванендэ хапэ тай джян палэ андэ пху Ханаан. ");
INSERT INTO rmn_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Анэн мандэ тумарэ дадэс тай хорандадэн. Мэ кан дав тумэн э зиядэ пху андэ Египти, тай тумэ кан бэшэн лаки лаче имишэнца». ");
INSERT INTO rmn_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Генэ пхэнав тэ пхэнэс лэнги: «Лэн андар Египти бричкес тумарэ пуенги тай ромненги, анэн тумарэ дадэс тай элан ли тумэ. ");
INSERT INTO rmn_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Ма аядиен тумаро мангин, вай алаи о зиядэ андэ Египти кан овэл тумаро». ");
INSERT INTO rmn_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","О чявэ э Израилески аякха да кердэ. О Иосиф диняс лэн бричкес, сар пхэнляс о фараони, тай хапэ дромэски. ");
INSERT INTO rmn_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Кажнески ов башлады нэвэ савутя, ай э Вениаминес диняс тришэл котора руп тай пандж парэс савутя. ");
INSERT INTO rmn_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Пэ дадэски ов бичялдяс дэшэ джёрэн, опрал пхэрдэ о зиядэ мангин э Египтеско тай дэшэ джёрян, опрал пхэрдэ гив, манро тай авэр хапэ дромэски. ");
INSERT INTO rmn_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Пал адалэстэ ов мукляс пэ пхралэн, тай кана он джянас, пхэнляс лэнги: — Ма ирищиен тумэ екхаврэса опэр дром! ");
INSERT INTO rmn_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Он гелэ ко дром андар Египти, алэ пумарэ дадэстэ ко Яков ки пху Ханаан ");
INSERT INTO rmn_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","тай пхэнлэ лэски: — О Иосиф дживиндо! Ов — о сагбус алаи э Египтеско! Ко Яков тэрдило о ило, тай ов на пакянило лэнги. ");
INSERT INTO rmn_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ай кана он пхукавдэ лэски алаи, со пхэнляс о Иосиф, тай кана ов дикхляс о бричкес, савэ о Иосиф бичялдяс, тэ анэн лэс, э духос э Яковески дживиндило. ");
INSERT INTO rmn_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Тай о Израиль пхэнляс: — Овэл! Мо чяво о Иосиф дживиндо! Кан джяв тай кан дикхав лэс, бискай на мулём! ");
INSERT INTO rmn_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","О Израиль гело ко дром алаеса, со сас лэстэ, ало андэ Бээр-Шэва тай андяс отхэ курбанен э Дэвлэски пэ дадэскерэски э Исаакески. ");
INSERT INTO rmn_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","О Дэл зборизэлас э Израилеса андэ ратяко дикхипэ тай пхэнляс: — Яков! Яков! — Аки мэ, — пхэнляс о Яков. ");
INSERT INTO rmn_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ов пхэнляс: — Мэ — о Дэл, о Дэл тэ дадэско. Ма траша тэ джяс андэ Египти. Мэ кан керав тутар отхэ баро дюняс. ");
INSERT INTO rmn_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Мэ кан джяв андэ Египти екхетханэ туса, тай Мэ жэ кан анав тут палэ. Тай о якха туки кан пхандэл о васт э Иосифеско. ");
INSERT INTO rmn_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","О Яков гело ко дром андар Бээр-Шэва. О чявэ э Израилески бэшавдэ пумарэ дадэс, э пуен тай э ромнен андэ бричкес, савэ о фараони бичялдяс, тэ анэн лэс. ");
INSERT INTO rmn_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Он лилэ пэса э гайванен тай о мангин, саво кидинэ андэ Ханаан, тай о Яков алаи пэ пуенца ало андэ Египти. ");
INSERT INTO rmn_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Ов лиляс пэса андэ Египти пэ чявэн тай э турунен, пэ чяен тай турунисэн — алаи пи порода. ");
INSERT INTO rmn_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Аки о нава э Израилески чявэнго, савэ алэ андэ Египти: О Яков тай лэски пуя: о Рувим, о баштутно э Яковеско. ");
INSERT INTO rmn_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","О чявэ э Рувимески: о Ханох, о Фаллу, о Хецрон тай о Кармий. ");
INSERT INTO rmn_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","О чявэ э Симеонески: о Емуэл, о Ямин, о Охад, о Яхин, о Цохар тай о Шаул, о чяво э ханаанеянкако. ");
INSERT INTO rmn_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","О чявэ э Левиески: о Гершон, о Кехат тай о Мерарий. ");
INSERT INTO rmn_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","О чявэ э Иудаски: о Эр, о Онан, о Шэла, о Парец тай о Зерах (ай о Эр тай о Онан мулэ андэ Ханаан). О чявэ э Парецэски сас о Хецрон тай Хамул. ");
INSERT INTO rmn_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","О чявэ э Иссахарески: о Тола, о Пувва, о Иов, тай о Шымрон. ");
INSERT INTO rmn_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","О чявэ э Завулонески: о Серед, о Элон тай о Яхлэл. ");
INSERT INTO rmn_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Адава о чявэ э Лияки, савэ латэ аракхлилэ э Яковески андэ Паддан-Арам. Латэ аракхлили ли чяй э Дина. Алаи лэн эсас триянду трин мануша. ");
INSERT INTO rmn_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","О чявэ э Гадески: о Цыфион, о Хаггий, о Шуний, о Эцбон, о Эрий, о Ародий тай о Арелий. ");
INSERT INTO rmn_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","О чявэ э Асирески: о Имна, о Ишва, о Ишвий тай о Бриа. Лэнги пхэн э Серах. О чявэ э Бриаски: о Хевер тай о Малкиэл. ");
INSERT INTO rmn_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Адава о пуя, савэ аракхлилэ ки Зилпа э Яковески, савя о Лаван диняс пэ чяятэ ки Лия. Алаи дэшушов мануша. ");
INSERT INTO rmn_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","О чявэ э Яковески ромняки э Рахиляки: о Иосиф тай о Вениамин. ");
INSERT INTO rmn_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Андэ Египти э Аснат, э чяй э Поти-Пераски, саво сас о попази э дизако э Он, латэ аракхлило э Иосифески о Манассия тай о Ефрем. ");
INSERT INTO rmn_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","О чявэ э Вениаминески: о Бэла, о Бэхер, о Ашбэл, о Гера, о Нааман, о Эхий, о Рош, о Муппим, о Хуппим тай о Ард. ");
INSERT INTO rmn_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Адава о чявэ э Рахиляки, савэ латэ аракхлилэ э Яковески. Алаи дэшуштар мануша. ");
INSERT INTO rmn_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","О чяво э Данеско: о Хушым. ");
INSERT INTO rmn_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","О чявэ э Неффалимески: о Яхцэл, о Гуний, о Ецэр тай о Шыллем. ");
INSERT INTO rmn_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Адава о чявэ, савэ аракхлилэ ки Билха э Яковески, савя о Лаван диняс пэ чяятэ ки Рахиль. Алаи эфта мануша. ");
INSERT INTO rmn_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Алаен, кон ало андэ Египти э Яковеса, — лэски пуя, тэ на гинэс лэски чявэнги ромнян, — сас эксинда шов мануша. ");
INSERT INTO rmn_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","О чявэ э Иосифески, савэ аракхлилэ лэски андэ Египти, сас дуй. Алаи о мануша э Яковески хорандаски, кай алэ андэ Египти, сас эфтадэша мануша. ");
INSERT INTO rmn_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","О Яков бичялдяс ангал пэстэ ко Иосиф э Иудас, тэ галёл о дром андэ Гошэн. Кана он алэ отхэ, ");
INSERT INTO rmn_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","о Иосиф гортярдяс э бричка тай гело андэ Гошэн, тэ дикхел пэ дадэс э Израилес. Ов тэрдило ангал лэстэ, диняс ангали лэс тай бут вахыти ровэлас. ");
INSERT INTO rmn_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","О Израиль пхэнляс э Иосифески: — Акана мэ рагати кан мэрав, вай дикхлем мэ якхенца, кай ту дживиндо. ");
INSERT INTO rmn_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","О Иосиф пхэнляс пэ пхралэнги тай пэ дадэски кхерутнэнги: — Мэ кан джяв ко фараони тай кан пхэнав лэски: «Мэ пхрала тай о кхер мэ дадэско, савэ бэшэнас ки пху Ханаан, алэ мандэ. ");
INSERT INTO rmn_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Адала мануша — чёбаня. Он барярэн гайванен тай андэ пумэнца пумарэ атарэс, тай андэ алаи пумаро мангин». ");
INSERT INTO rmn_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Кана о фараони кан дэл икос тумэн тай кан пхучел: «Со тумэ керэн?» — ");
INSERT INTO rmn_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","тумэ камэл тэ пхэнэн: «Тэ иргатя тэрнярила тай джи анкха барярэн гайванен, сар керэнас ли амарэ дада». Дэчи тумэн кан мукен тэ бэшэн ки пху Гошэн, вай о египтяня джириндиен катар чёбаня. ");
INSERT INTO rmn_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","О Иосиф гело ко фараони тай пхэнляс лэски: — Мо дад тай мэ пхрала пумарэ атарэнца, э барэ тай э тикнэ гайваненца тай алаи пумарэ мангинэса алэ катар пху Ханаан тай анкха си андэ Гошэн. ");
INSERT INTO rmn_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Ов лиляс панджен андар пхрала тай тхэдяс лэн ангал фараони. ");
INSERT INTO rmn_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","О фараони пхучляс э пхралэн: — Со тумэ галён тэ керэн? Он пхэнлэ э фараонески: — Тэ иргатя — чёбаня, сар амарэ дада. — ");
INSERT INTO rmn_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Генэ он пхэнлэ: — Амэ алям атхэ тэ бэшас, вай ки пху Ханаан бари бокх тай тэ иргатенги нанай катэ чярярэн о атарэс. Оничин мук тэ иргатен тэ бэшэн андэ Гошэн. ");
INSERT INTO rmn_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","О фараони пхэнляс э Иосифески: — То дад тай тэ пхрала алэ тутэ. ");
INSERT INTO rmn_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Э пху Египти — ангал тутэ; дэ тэ дадэс тай тэ пхралэн о зиядэ котор адалэ пхуяко. Мэ бэшэн андэ Гошэн. Ай ту тэ джянэс, кон андар лэндэ лачес керэс бути, тхэ лэн тэ дикхен пал мэ гайванендэ. ");
INSERT INTO rmn_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","О Иосиф андяс пэ дадэс э Яковес тай сикавдяс лэс э фараонески, тай о Яков алгышты э фараонес. ");
INSERT INTO rmn_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","О фараони пхучляс лэс: — Сокабор брэш туки? ");
INSERT INTO rmn_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","О Яков пхэнляс э фараонески: — О деса мэ пхуримаски — шэлу триянда брэш. Мэ бэшлём на бут, тай алаи о брэша мэ пхеравас опэр пху тай дикхавас бут хурлуки. Мэ дада бэшлэ мандар бут тай зиядэ. ");
INSERT INTO rmn_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","О Яков алгышты э фараонес тай гело. ");
INSERT INTO rmn_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Сар пхэнляс о фараони, о Иосиф андяс пэ дадэс тай пэ пхралэн андэ Египти тай диняс лэн зиядэ котор пху андэ пху Раамсес. ");
INSERT INTO rmn_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","О Иосиф диняс хапэ пэ дадэс, пэ пхралэн тай алаи пи порода, диняс кажне манушэс андэ хорандас. ");
INSERT INTO rmn_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Дэчи никатэ на сас хапэ, вай сас бари бокх; о Египти тай о Ханаан сас кхино катар бокх. ");
INSERT INTO rmn_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","О Иосиф кидиняс алаи э руп, савэ сас андэ Египти тай Ханаан, андар гив, саво лэстэ кинэнас. Ов гаравэлас ла андэ кхер ко фараони. ");
INSERT INTO rmn_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Кана быты э руп андэ Египти ли андэ Ханаан, алаи о египтяня алэ ко Иосиф тай пхэнлэ: — Дэ амэн манро. Соски амэнги тэ мэрас ангал тэ якхендэ? Амари руп быты. ");
INSERT INTO rmn_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","О Иосиф пхэнляс: — Тэ быты тумари руп, анэн тумарэ гайванен, мэ кан паровав манрэски. ");
INSERT INTO rmn_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Он андэ ко Иосиф э гайванен, тай ов диняс лэн манро паровдяс опэр грастэнги, бакрэнги тай бузнэнги, гурувэнги, гурувненги тай джёрэнги. Ов хавдярэлас лэн манрэса одова брэш, пароимаски алаи лэнги гайваненги. ");
INSERT INTO rmn_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Кана о брэш накхло, он алэ лэстэ тай пхэнлэ: — Амэ на кан гаравас амарэ сагбустар, кай амари руп быты, тай амарэ гайваня си тинрэ, тай амэндэ ништо на ачило тэ дас амарэ сагбус, булуб амарэ тэнендар тай амарэ пхуятар. ");
INSERT INTO rmn_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Соски амэнги тэ мэрас ангал тэ якхендэ, ли амэнги, ли амарэ пхуяки? Кин амэн тай амари пху манрэски, тай амэ амарэ пхуяса кан овас иргатя ко фараони. Дэ амэн гугуся, амэ тэ бэшас тай тэ на мэрас, тай адая пху тэ на чючёл. ");
INSERT INTO rmn_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Аякха о Иосиф киндяс алаи э пху андэ Египти э фараонески. О египтяня бикиндэ кажни пи ливади, вай э бокх тасавдяс лэн. Аякха э пху ули э фараонески, ");
INSERT INTO rmn_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","ай о дюняс э Иосиф кердяс иргатен, катар екх чети ки Египтеско джи аврэстэ. ");
INSERT INTO rmn_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ов на киндяс екх э пху э попазенги, вай он сальтя диндёнас паи катар фараони, тай адава паи, саво диняс лэн о фараони, лэнги рэсэлас хамаски. Аки соски он на бикиндэ пумари пху. ");
INSERT INTO rmn_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","О Иосиф пхэнляс э дюняски: — Акана, кана мэ киндём тумэн тай тумари пху э фараонески, аки тумэнги гугуся, тэ чен андэ пху. ");
INSERT INTO rmn_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Кана кан барел о гив, дэн о панджто паи лэстар э фараонес, ай окола штар пая кан овэн тумэнги гугуся э ливадянги тай хамаски тумэнги, э кхерутнэнги тай э пуенги. ");
INSERT INTO rmn_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Он пхэнлэ: — Ту кутардын амэнги о бэшыпэ. Тэ аракхас мила андэ якха амарэ сагбускерэ. Амэ кан овас о иргатя э фараонески. ");
INSERT INTO rmn_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Аякха о Иосиф тхэдяс андэ Египти тхэдипэ катар пху, саво ли авдес зорало: панджто паи о гив си э фараонеско, булуб о гив катар пху ки попазенги, сави на ули э фараонески. ");
INSERT INTO rmn_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","О израильтяня бэшэнас андэ Египти андэ область Гошэн. Лэндэ уло отхэ мангин тай сас лэндэ пуя, тай он бутилэ. ");
INSERT INTO rmn_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","О Яков бэшло андэ Египти дэшуэфта брэш, самким алаи ов бэшло шэлу саранда эфта брэш. ");
INSERT INTO rmn_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Кана ало вахыти ов тэ мэрэл, ов диняс икос пэ чявэс э Иосифес тай пхэнляс лэски: — Тэ аракхлём мэ мила андэ тэ якхендэ, тхэ то васт тал мэ шалостэ тай дэ збора, кай кан керэс манги мила тай чячипэ. Ма пароскер ман андэ Египти. ");
INSERT INTO rmn_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Ай кана мэ кан мэрав, никал ман андар Египти тай пароскер отхэ, катэ пароскердэ мэ папудэс. О Иосиф пхэнляс: — Мэ кан керав аякха, сар ту пхэнлян. ");
INSERT INTO rmn_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","— Ха совля, — пхэнляс ов. О Иосиф халяс совля лэски, тай о Израиль мангляс э Дэвлэс, астарэласпэс опэр пэ ровлятэ. ");
INSERT INTO rmn_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Вахытестар э Иосифески пхэнлэ: — То дад насвало. О Иосиф лиляс пэса до чявэн, э Манассияс тай э Ефремес. ");
INSERT INTO rmn_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Э Яковески пхэнлэ: — Тутэ ало то чяво о Иосиф. О Израиль кидиняспэс зораса, ваздиняспэс тай бэшло опэр тхан. ");
INSERT INTO rmn_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","О Яков пхэнляс э Иосифески: — Андэ Луз, ки пху Ханаан, манги сикавдяспэс о Дэл о Баро-Зорало тай алгышты ман. ");
INSERT INTO rmn_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Ов пхэнляс манги: «Мэ кан дав тут бутэ пуен, кан бутярав тут, кан керав тутар бут дюнядэс тай кан дав адая пху тэ овэл екхараи тэ пуенги». ");
INSERT INTO rmn_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Акана тэ чявэ о дуй, кай аракхлилэ туки андэ Египти бискай мэ алём атхэ, кан овэн минрэ. Сар о Рувим тай о Симеон, о Ефрем тай о Манассия кан овэн минрэ. ");
INSERT INTO rmn_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","О пуя, савэ кан аракхлён туки пал лэндэ, кан овэн тинрэ, тай лэндэ кан овэл котор пху андар паи лэнги пхралэнго. ");
INSERT INTO rmn_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Кана мэ ававас андар Паддан, ми Рахиль мули ки пху Ханаан, кана амэ самас дага опэр дром, надур катар Эфрата. Оничин мэ пароскердём ла отхэ, опэр дром ко Эфрата (самким Вифлееми). ");
INSERT INTO rmn_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","О Израиль дикхляс э Иосифески чявэн тай пхучляс: — Кон адала? ");
INSERT INTO rmn_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","О Иосиф пхэнляс пэ дадэски : — Адава о чявэ, савэн о Дэл диняс ман атхэ. О Израиль пхэнляс: — Ан лэн мандэ, тэ алгыштияв лэн. ");
INSERT INTO rmn_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","О Израиль катар пхурипэ на лачес дикхелас. О Иосиф андяс пэ чявэн пашэ пэ дадэстэ, тай одова чюмидиняс тай диняс ангали лэн. ");
INSERT INTO rmn_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","О Израиль пхэнляс э Иосифески: — Мэ джи на тюшундым генэ тэ дикхав тут, ай о Дэл диняс ман тэ дикхав джи тэ пуен. ");
INSERT INTO rmn_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","О Иосиф гелдяс лэн катар кочя ки Израилески тай бангело лэски джи ки пху. ");
INSERT INTO rmn_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Дэчи о Иосиф тхэдяс э Ефремес катар прави рик пэстар, катар леви васт катар Израиль, ай э Манассияс катар леви риг пэстар, катар прави катар Израиль, тай андяс лэн паш пэ дадэстэ. ");
INSERT INTO rmn_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ай о Израиль сидиняс о прави васт тай тхэдяс опэр шэро ки Ефремеско, хоч ов эсас о тикно, кердяс хачи пэ васта, тай о леви ов тхэдяс опэр шэро ки Манассияско, хоч о Манассия сас о баштутно. ");
INSERT INTO rmn_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Дэчи ов алгышты э Иосифес тай пхэнляс: — О Дэл, ангал Савэстэ пхерэнас о дада минрэ о Авраам тай о Исаак, о Дэл, Саво сас мо чёбани алаи мо бэшыпэ джи адалэ десески, ");
INSERT INTO rmn_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","о Миляики, саво кутардиелас ман вэрсавэ джюнгалимастар, мэ алгыштиел адалэ пуен. Мэ овэл андэ лэндэ мо нав тай о нав мэ дадэнго э Авраамеско тай э Исаакеско, тай мэ овэн бут лэнги пуя опэр пху. ");
INSERT INTO rmn_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Кана о Иосиф дикхляс, кай о дад тхэдяс о прави васт опэр шэро ки Ефремеско, ов уло касывэтлыс тай лиляс пэ дадэс вастэстар, тэ тхэл катар шэро ки Ефремеско опэр шэро ки Манассияско. ");
INSERT INTO rmn_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","О Иосиф пхэнляс: — На, дадэ, аки акава — о баштутно. Тхэ о прави васт опэр лэски шэрэстэ. ");
INSERT INTO rmn_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ай о дад на мангляс тай пхэнляс: — Мэ джянав, мо чяво, мэ джянав. Ли лэстар кан овэл дюняс, ли ов кан овэл баро. Ай лэско тикно пхрал кан овэл баро лэстар, тай лэски пуя кан овэн бут дюнядэс. ");
INSERT INTO rmn_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Тай ов алгышты лэн одова дес тай пхэнляс: — О израильтяня кан пхэнэл тумарэ нава, сар алгыштима: «Мэ керэл тут о Дэл, сар э Ефремес тай э Манассияс». Аякха о Израиль тхэдяс э Ефремес ангал Манассия. ");
INSERT INTO rmn_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","О Израиль пхэнляс э Иосифески: — Мэ мэрав, ай о Дэл кан овэл тумэнца тай кан анэл тумэн ки пху тумарэ дадэнги. ");
INSERT INTO rmn_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Мэ дав тут бут пху, ниш тэ пхралэн, дав тут генэ котор пху горадэнца, саво мэ лилём ко аморея камаса тай лукеса. ");
INSERT INTO rmn_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","О Яков диняс икос пэ чявэн тай пхэнляс: — Кидэнтумэн агорял, тай мэ кан пхэнав, со кан овэл тумэнца андэ деса, кай авэн. ");
INSERT INTO rmn_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Кидэнтумэн тай шунэн, о чявэ э Яковески, шунэн тумарэ дадэс э Израилес! ");
INSERT INTO rmn_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Рувим, ту — мо баштутно, ми зор, о баштутно имишы мэ муршыканэ зорако; ов алаендар зорало тай лэс алаи гинэн. ");
INSERT INTO rmn_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ай, сар пани, тут нащи тэрдярэс. Акана ту на кан овэс баштутно, вай ту пашлилян опэр тхан тэ дадэско тай гарамладын мо тхан. ");
INSERT INTO rmn_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","О Симеон тай о Левий — пхрала, лэнги камадэс керэн хурлуки. ");
INSERT INTO rmn_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Мэ на кан овав андэ лэнги дилэндэ, мэ на кан овав лэнца екх, вай он холясаилэ тай мударэнас э муршэн, манглэ тай чиндэ э гурувэн. ");
INSERT INTO rmn_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Дини арман лэнги холи, вай джюнгали, тай о канлылыки, вай бут баро! Мэ кан чяв лэн машкарэ ко пуя ки Яковески тай кан дурярав лэн андэ Израиль. ");
INSERT INTO rmn_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Иуда, тэ пхрала кан махтадиен тут, то васт кан овэл опэр мэн тэ душманенги, о чявэ тэ дадэски кан бангён туки. ");
INSERT INTO rmn_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ту — тэрно леви, Иуда; ту авэс хамаса, мо чяво. Сар леви, ов пэрэл ки пху тай пашлёл, сар львица — кон кан мангел лэс тэ астарэл? ");
INSERT INTO rmn_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","О скипетр на кан ачявэл э Иудас, тай о пуя лэски екхараи кан астарэн э ровли э патишаенги, бискай на кан авэл о Шыло, Кас кан тхэн кан о дюнядэс. ");
INSERT INTO rmn_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ов кан пхандэл пэ джёрэс ки дракхаки лазас, пэ джёрорэс — ки зиядэ ветка. Ов кан халярэл пэ савутя андэ винастэ, о уряипэ пинро — андэ рат ки дракхако. ");
INSERT INTO rmn_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","О якха лэски — калэ катар винас, о данда лэски — катар сути парнэ. ");
INSERT INTO rmn_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","О Завулон кан бэшэл паш ки моря тай лэстэ кан авэн караблядэс; лэски четя кан сидэнпэс джи ко Сидон. ");
INSERT INTO rmn_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","О Иссахар — зорало джёро, пашло машкарэ ко пхарэ гонэ. ");
INSERT INTO rmn_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Ов дикхляс, со лачё лэско тхан э рагатеско тай со лачи лэски пху; ов кан бангярэл пэ пхике тал пхарипэ тай кан керэл бути сар иргати. ");
INSERT INTO rmn_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","О Дан диндёл тэ керэл цындос пэ дюняски сар екх андар порода ки Израилески. ");
INSERT INTO rmn_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","О Дан кан овэл э сапэнги паш ко дром, гадюка ки ливади, сави дандэлэл э грастэс чянгатар, тай о атлыс пэрэл тэлэ. ");
INSERT INTO rmn_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","О Сагбус о Яхвэ, Тутэ родав мэ кутардипэ! ");
INSERT INTO rmn_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Опэр Гад кан пэрэн чёра, ай ов кан пэрэл опэр лэндэ палэ тай кан кувдиел. ");
INSERT INTO rmn_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","О хапэ э Асиреско кан овэл бут; ов кан анэл патишайлытико хапэ. ");
INSERT INTO rmn_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","О Неффалим — мукли лани, сави анэл шукарэ пуен. ");
INSERT INTO rmn_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","О Иосиф — имишэнго дракхако кущёки, имишэнго кущёки паш ко пани, савэски веткес ваздэнпэс опэр стинас. ");
INSERT INTO rmn_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Холинаса пэрэнас опэр лэстэ тай мукенас андэ лэстэ стриладэс. ");
INSERT INTO rmn_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ай о луки лэско ачило зорало, э зор лэски вастэнги — о зорало Дэл э Яковеско, о нав э Чёбанеско тай о Бар э Израилеско. ");
INSERT INTO rmn_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Ов — о Дэл тэ дадэско, Саво кан керэл туки ярдыми. Ов — о Дэл Баро-Зорало, Саво кан алгыштиел тут. Ов кан дэл тут алгыштима э булутенго опрал, тай безднако тэлал, тай алгыштима э дэенго, савэ хавдярэн э пуен. ");
INSERT INTO rmn_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","О алгыштима тэ дадэско зиядэ, ниш алгыштима э пуранэ горадэнго, ниш алгыштима э пуранэ ливаденго. Мэ овэн он алаи опэр шэро ки Иосифеско, опэр чикат ки тхэдэ князеско машкарэ пэ пхралэндэ. ");
INSERT INTO rmn_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","О Вениамин — джюнгало рув; сабахтан ов хал со астардяс, бэлвэле палящиел, со чёрдэ. ");
INSERT INTO rmn_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Аки касавке си дэшудуй породэс э Израилески. Аки со пхэнляс лэнги о дад, кана алгыштиелас лэн; кажнес ов диняс лэнго алгыштима. ");
INSERT INTO rmn_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","О Яков пхэнляс лэнги: — Мэ джяв мэ дадэндэ. Пароскерэн ман мэ дадэнца андэ пищера ки ливади ки хетеески ки Эфронески, ");
INSERT INTO rmn_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","андэ пищера ки ливади Махпела паш ко Мамрэ андэ Ханаан, сави о Авраам киндяс ко хетеи ко Эфрон сар паромаско тхан. ");
INSERT INTO rmn_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Отхэ сас пароскердэ о Авраам тай лэски ромни э Сарра, отхэ сас пароскердэ о Исаак тай лэски ромни э Рэвэка, тай отхэ мэ пароскердём э Лия. ");
INSERT INTO rmn_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Э ливади тай э пищера сас киндэ ко хетея. ");
INSERT INTO rmn_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","О Яков бытэрды тэ пхэнэл пэ чявэнги, ваздиняс пэ пинрэ опэр тхан, мукляс по тынышы тай гело пэ дадэндэ. ");
INSERT INTO rmn_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","О Иосиф пэло опэр пэ дадэстэ, руно опэр лэстэ тай чюмидиняс лэс. ");
INSERT INTO rmn_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ов пхэнляс пэ иргатенги э враченги тэ керэн бальзамирования лэски дадэски, тай о врачя кердэ бальзамирования э Израилески. ");
INSERT INTO rmn_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","О врачя керэнас адава саранда дес. Дэчи эфтадэша дес о египтяня ровэнас пал муло. ");
INSERT INTO rmn_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Кана накхлэ о деса э роимаски, о Иосиф пхэнляс э фараонески иргатенги: — Тэ аракхлём мэ мила андэ тумарэ якхендэ, манген андар мандэ э фараонес тай пхэнэн лэски: ");
INSERT INTO rmn_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","«Мо дад пхэнляс манги тэ хав совля тай пхэнляс: \"Мэ мэрав; тхэ ман андэ склепи, саво мэ гортярдём манги ки пху Ханаан\". Мук ман тэ джяв тэ пароскерав мэ дадэс. Пал отхэ мэ кан авав». ");
INSERT INTO rmn_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","О фараони пхэнляс: — Джя, пароскер тэ дадэс аякха, сар ту халян совля. ");
INSERT INTO rmn_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","О Иосиф гело тэ пароскерэл пэ дадэс, тай лэса гелэ алаи о иргатя тай о барэ мануша э фараонески, тай алаи о барэ мануша э Египтески, ");
INSERT INTO rmn_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","тай алаи о кхер э Иосифеско, тай лэски пхрала, тай алаи о кхер лэски дадэско. Андэ Гошэн ачилэ екх лэнги пуя тай о атарэс о барэ тай э тикнэ гайваня. ");
INSERT INTO rmn_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Лэнца сас бричкес тай атлыдэс; адава сас баро табури. ");
INSERT INTO rmn_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Он алэ ко тхан Горен-Атад, кай сас пал Иордани, тай отхэ лилэ лачес тэ ровэн. Отхэ о Иосиф эфта дес ровэлас пэ дадэски. ");
INSERT INTO rmn_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Кана о ханаанея, о мануша одолэ пхуяки, дикхлэ роипэ ко Горен-Атад, он пхэнлэ: «Ко египтяня баро роипэ тай касывэти». Аки соски одова тхан паш ко Иордани бучёл Авел-Мицраим. ");
INSERT INTO rmn_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Аякха о чявэ э Яковески кердэ, со ов пхэнляс: ");
INSERT INTO rmn_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","он гелдэ лэс ки пху Ханаан тай пароскердэ андэ пищера ки ливади Махпела, паш ко Мамрэ. Адая пищера о Авраам киндяс ко хетеи ко Эфрон екхетханэ э ливадяса, тэ овэл лэстэ тхан паромаски. ");
INSERT INTO rmn_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Кана о Иосиф пароскердяс пэ дадэс, ов екхетханэ пэ пхралэнца тай алаенца, кон гело лэса тэ пароскерэл э дадэс, гело палэ ко Египти. ");
INSERT INTO rmn_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Кана о дад муло, о пхрала э Иосифески тюшундылар: «Кай о Иосиф тэ гаравэл холи амэнги тай акана тэ кан покинэл амэнги андар алаи ко джюнгалипэ, саво амэ лэски кердям?» ");
INSERT INTO rmn_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Тай он бичялдэ ко Иосиф тэ пхэнэн: — Ангал мэрипэ о дад ачявдяс асавке пхэнлиматэс: ");
INSERT INTO rmn_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","«Аки со тумэ камэл тэ пхэнэн тумарэ пхралэски э Иосифески: \"Мэ мангав тут, апувикер тэ пхралэн лэнги дош тай о бэзя, савэ он кердэ, кай кердэ туса асавко джюнгалипэ. Акана мангав тут, апувикер о бэзя э иргатенги э Дэвлэски тэ дадэскерэски\"». О Иосиф ровэлас, кана лэски пхэнэнас адала зборэс. ");
INSERT INTO rmn_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Лэски пхрала алэ, пэлэ ангал лэстэ тай пхэнлэ: — Амэ — тэ иргатя. ");
INSERT INTO rmn_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","О Иосиф пхэнляс: — Ма трашан. Та со, мэ о Дэл? ");
INSERT INTO rmn_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Тумэ тюшундынус мамуй мандэ джюнгалипэ, ай о Дэл болдиняс лэс андэ лачипэ тай кутарды о бэшыпэ бутэ манушэнги. ");
INSERT INTO rmn_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Оничин ма трашан: мэ кан хавдярав ли тумэн, ли тумарэ пуен. Ов лошаскердяс лэн тай зборизэлас лэнца лачимаса. ");
INSERT INTO rmn_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","О Иосиф бэшэлас андэ Египти екхетханэ э хорандаса пэ дадэскерэса, тай бэшло шэлу дэш брэш. ");
INSERT INTO rmn_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Ов сас джи, кана сас э трито порода о пуя э Ефремески. Аякхажэ о Иосиф дикхляс тай астардяс опэр кочендэ э пуен э Махирескерэн, саво сас о чяво э Манассияско. ");
INSERT INTO rmn_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","О Иосиф пхэнляс пэ пхралэнги: — Мэ мэрав, ай о Дэл кан авэл тэ керэл ярдыми тумэнги тай кан никалэл тумэн андар адалэ пхуятэ ки пху, сави Ов халяс совля тэ дэл ко Авраам, э Исаак тай э Яков. ");
INSERT INTO rmn_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","О Иосиф пхэнляс э Израилески чявэнги тэ хан совля: — О Дэл кан авэл тумэндэ тэ керэл ярдыми, тай дэчи тумэ камэл тэ никалэн атхар мэ кокала. ");
INSERT INTO rmn_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Кана о Иосиф муло, лэски сас шэлу дэш брэш. Лэски кердэ бальзамирования тай тхэдэ андэ склепи андэ Египти.");
INSERT INTO rmn_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Одова вахыти, кана андэ Израиль сас цындомаря, ули бокх опэр пху. Екх мануш гело андар Вифлееми андэ Иудеи пэ ромняса тай пэ дуе чявэнца тэ бэшэн андэ ливадя ко Моавитскя. ");
INSERT INTO rmn_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Адава мануш бучёлас Элимелех, лэски ромня — Ноеминь, ай лэски дуе чявэн — Махлон тай Хилеон; он сас ефрафяня андар Вифлееми андэ Иудеи. Он алэ ко ливадя ко Моавитскя тай ачилэ отхэ. ");
INSERT INTO rmn_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","О Элимелех, о ром э Ноеминяко, муло, тай ой ачили пэ дуе чявэнца. ");
INSERT INTO rmn_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Он лилэ пэски ромнен моавитянкен, э екх бучёлас Орфа, ай авэр Руфь. Пал отхэ сар он бэшлэ отхэ паш ко дэш брэш, ");
INSERT INTO rmn_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","о Махлон тай о Хилеон мулэ, тай э Ноеминь ачили би чявэнго тай би ромэско. ");
INSERT INTO rmn_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Э Ноеминь шунляс андэ Моави, кай о Сагбус о Яхвэ ало ярдымеса Пэ дюнястэ тай диняс лэн хапэ. Ой пэ боренца гортярдэпэс тэ джян кхерэ. ");
INSERT INTO rmn_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Екхетханэ пэ боренца ой ачавдяс о тхан, катэ бэшэлас, тай гили ко дром, саво камэлас тэ анэл лэн палэ ки пху Иуда. ");
INSERT INTO rmn_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Э Ноеминь пхэнляс пэ боренги: — Джян кажни андэ кхер тэ дэятэ. Мэ овэл о Сагбус о Яхвэ миласа тумэндэ, сар тумэ санусас миласа тумарэ мулэндэ тай мандэ. ");
INSERT INTO rmn_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Мэ дэл о Сагбус о Яхвэ кажня андар тумэндэ тэ аракхен бахт андэ кхер ко нэво ром. Ой чюмиды лэн, тай он лачес рунэ ");
INSERT INTO rmn_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","тай пхэнлэ лаки: — Амэ туса кан джяс тэ дюнястэ. ");
INSERT INTO rmn_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Э Ноеминь пхэнляс: — Джян кхерэ, мэ чяя. Соски тумэ тэ джян манца? Та со, мандэ кан овэн авэра чявэ, савэ кан овэн тумэнги рома? ");
INSERT INTO rmn_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Джян кхерэ, мэ чяя; мэ бут пхури, тэ овэл мандэ авэр ром. Джи мэ тэ тюшундиявас, кай мандэ генэ си ишандипэ, — джи адая рат мэ би тэ овав ромэса, тай дэчи тэ аракхлён мандэ чявэ, ");
INSERT INTO rmn_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","— та со, кан ишандиен, бискай он кан барён? Камэл тумэнги тэ ишандиен тай тэ на джян ромэстэ? На, мэ чяя. Мэ бут касэвэтлыс пал тумэндэ, вай о васт э Сагбуско э Яхвэско уло мамуй мандэ! ");
INSERT INTO rmn_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Он ваздинэ бэбэря тай генэ лилэ тэ ровэн. Тай э Орфа чюмидиняс пэ саса тай гели пэ дюнястэ, ай э Руфь ачили ласа. ");
INSERT INTO rmn_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Э Ноеминь пхэнляс: — Аки, ти бори гели пэ дюнястэ тай пэ дэвлэндэ. Джя ли ту пал тэ борятэ. ");
INSERT INTO rmn_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Ай э Руфь пхэнляс: — Ма тхэ ман тэ мукав тут тай тэ джяв тутар. Кай ту кан джяс, отхэ ли мэ кан джяв, тай кай ту кан бэшэс, отхэ ли мэ кан бэшав. То дюняс кан овэл мо дюняс, тай то Дэл — мо Дэл. ");
INSERT INTO rmn_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Катэ кан мэрэс ту, кан мэрав ли мэ тай отхэ кан овав паромэ. О Сагбус о Яхвэ лачес мэ марэл ман, тэ авэр со-то, екх о мэрипэ кан лэл ман тутар. ");
INSERT INTO rmn_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Кана э Ноеминь галили, кай э Руфь лачес мангел тэ джял ласа, ой тэрдили ла тэ тхэл. ");
INSERT INTO rmn_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Тай джянас о дуй он, бискай на алэ андэ Вифлееми. Кана он алэ андэ Вифлееми, алаи э диз ваздиндили лэндар тай пхэнэнас: — Адава э Ноеминь? ");
INSERT INTO rmn_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","— Ма пхэнэн манги Ноеминь, — ой пхэнляс лэнги. — Ами пхэнэн манги Мара, вай о Зорало Дэл бичялдяс манги баро касэвэти. ");
INSERT INTO rmn_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Мэ никхлистём атхар мангинэса, ай о Сагбус о Яхвэ андяс ман палэ би ништоско. Соски тэ пхэнэн манги Ноеминь, кана о Сагбус о Яхвэ диняс ман касэвэти, тай о Зорало Дэл бичялдяс манги бибахталипэ? ");
INSERT INTO rmn_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Аякха э Ноеминь али кхерэ. Ай ласа катар ливадя ко Моавитскя али лаки бори, моавитянка э Руфь. Тай он алэ андэ Вифлееми, кана лилэ тэ кидэн о ячмени. ");
INSERT INTO rmn_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Ки Ноеминяко ром сас тухуми, саво бучёлас Боаз. Ов сас намлыс патювало мануш андар порода, катар сас о Элимелех. ");
INSERT INTO rmn_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Э моавитянка э Руфь пхэнляс э Ноеминяки: — Кан джяв ки ливади тэ кидав гив, кастэ кан аракхав мила? Э Ноеминь пхэнляс: — Джя, ми чяй. ");
INSERT INTO rmn_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Э Руфь гели тай лиляс тэ кидэл о гив, саво пэрэлас пал одолэндэ, савэ кидэнас о гив. Тай уло аякха, кай одоя ливади сас э Боазески, э порода э Элимелехески. ");
INSERT INTO rmn_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Тай аки, о Боаз ало андар Вифлееми тай пхэнляс одолэнги, савэ кидэн о гив: — О Сагбус о Яхвэ тумэнца! Он пхэнлэ лэски: — Мэ алгыштиел тут о Сагбус о Яхвэ! ");
INSERT INTO rmn_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","О Боаз пхучляс ко бутярно, саво сас опэр иргатя, савэ кидэн о гив: — Каски чяй адая? ");
INSERT INTO rmn_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","О бутярно, саво сас опэр иргатя, савэ кидэн о гив, пхэнляс: — Адая тэрни джювли моавитянка, али э Ноеминяса катар ливадя Моавитскя. ");
INSERT INTO rmn_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Ой пхэнляс: «Кан кидав о гив пал одолэндэ, кон кидэл о гив». Али сабахтан, ой си джякана атхэ тай дага на раганты. ");
INSERT INTO rmn_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","О Боаз пхэнляс э Руфяки: — Шун ман, ми чяй. Ма джя тэ кидэс аврэ ливадятэ тай ма джя атхар. Ов атхэ мэ иргатинкенца. ");
INSERT INTO rmn_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Дикх, катэ керэн бути джювля, тай джя пал лэндэ. Мэ пхэнлём мэ манушэнги тэ на холязэн туки. Тэ мангеса тэ пиес, пашо тай пи андар кхорэ, савэ пхэрдэ мэ иргатя. ");
INSERT INTO rmn_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Ой бангили моса джи ки пху тай пхэнляс лэски: — Ту манги керэс лачипэ тай дикхес пал мандэ, вай мэ сом джяти? ");
INSERT INTO rmn_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","О Боаз пхэнляс лаки: — Манги пхукавдэ одолэстар, со ту кердян тэ сасаки пал мэрипэ тэ ромэско: сар ту ачявдян тэ дадэс тай тэ дэя, ачявдян тэ дюняс тай гелян андэ пху, сави на джянэс. ");
INSERT INTO rmn_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Лачипэ мэ керэл туки о Сагбус о Яхвэ андар адалэстэ! Мэ овэл тутэ барвалипэ катар Яхвэ, Дэл ки Израилеско, Савэстэ ту алян! Мэ овэл рагати туки тал Лэски пхакендэ! ");
INSERT INTO rmn_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","— Лошани мэ тэ керав, со мангес ту, сагбус минро, — пхэнляс ой. — Ту кердян лачипэ тай рагати манги, тэ иргатинка, гэм мэ на сом машкарэ тэ иргатинкендэ. ");
INSERT INTO rmn_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Кана ало вахыти тэ хан, о Боаз пхэнляс э Руфяки: — Эла атхэ, ха, бол то котор манро андэ шутлипэ. Э Руфь бэшли паш ко мануша, савэ кидэн о гив, тай ов диняс ла жарини гив. Ой халяс, чялили, тай латэ дага ачило. ");
INSERT INTO rmn_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Дэчи э Руфь гели тэ кидэл о чёрдо гив, ай о Боаз пхэнляс пэ манушэнги: — Мэ кидэл ой ли машкарэ ко пханлэ снопи гив, ма холязэн лаки. ");
INSERT INTO rmn_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Тай андар снопи никалэн гив, чен лаки тай ачявэн, мэ кидэл ой, тай ма холязэн лаки. ");
INSERT INTO rmn_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Аякха ой кидэлас ки ливади джи ки бэлвэль, мардяс о ячмени, дэчи шужардяс тай сеискердяс, тай уло гоно гив. ");
INSERT INTO rmn_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Ой андяс о гоно андэ диз, тай лаки сасуй дикхляс, сокабор бут ой кидиняс. Генэ э Руфь никалдяс тай диняс ла одова, со ачило латэ, кана халас. ");
INSERT INTO rmn_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Тай пхэнляс лаки э сасуй: — Кай ту авдес кидэсас? Катэ керэсас бути? Мэ овэл лачипэ одолэски, кон мукляс тут! Э Руфь пхэнляс пэ сасаки, кастэ ой керэлас бути, тай пхэнляс: — Одова мануш, кастэ мэ авдес керэвас бути, бучёл Боаз. ");
INSERT INTO rmn_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","— Алгыштие лэс о Сагбус о Яхвэ! Ов на ачявдяс би милако ли э дживиндэнги, ли э мулэнги! — пхэнляс э Ноеминь пэ боряки. — Адава мануш — амаро пашутно тухуми. ");
INSERT INTO rmn_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Э моавитянка э Руфь пхэнляс: — Ов джи пхэнляс манги: «Ов мэ бутярнэнца, бискай он кан бытэрдиен тэ кидэн о гив опэр ми ливади». ");
INSERT INTO rmn_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Э Ноеминь пхэнляс пэ боряки э Руфяки: — Си лачё, ми чяй, кай ту кан пхерэс лэски иргатинкенца тай на кан холязэн туки аврэ ливадятэ. ");
INSERT INTO rmn_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Аякха э Руфь сас э иргатинкенца э Боазескерэнца, бискай на быты тэ кидэн о ячмени тай о гив, тай бэшэлас пэ сасатэ. ");
INSERT INTO rmn_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Э Ноеминь пхэнляс пэ боряки: — Ми чяй, тэ родав туки лачё тхан, катэ кан овэс рагати? ");
INSERT INTO rmn_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Аки о Боаз, э иргатинкенца савэнца ту санас, амаро тухуми. Ов адая рат кан шужарэл ячмени. ");
INSERT INTO rmn_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Ту халяр тут, мак тут, уряв тут шукар тай джя ко тхан, катэ шужарэн о ячмени, тай ма сикав тут э Боазески, бискай ов на кан бытэрдиел тэ хал тай тэ пиел. ");
INSERT INTO rmn_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Дикх, катэ ов кан пашлёл тэ совел, дэчи пашо, пхутэр лэс тай пашлё пашэ. Ов кан пхэнэл туки, со тэ керэс дэчи. ");
INSERT INTO rmn_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Э Руфь пхэнляс: — Мэ кан керав алаи, сар ту пхэнлян. ");
INSERT INTO rmn_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Ой гели ко тхан, катэ шужарэн о ячмени, тай кердяс, сар пхэнляс лаки э сасуй. ");
INSERT INTO rmn_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","О Боаз халяс, пиляс тай лошано пашлило тэ совэл паш ки бари кучя гив. Э Руфь погаля пашыли, пхучярдяс лэс тай пашлили пашэ. ");
INSERT INTO rmn_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Рати ов джянгавдило, лиляс тэ болдэлпэс тай дикхляс, кай паш лэстэ пашли джювли. ");
INSERT INTO rmn_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","— Ту кон? — пхучляс ов. Ой пхэнляс: — Мэ э Руфь, иргатинка тинри. Лэ тэ иргатинка тал тэ пхакатэ, вай ту мо тухуми. ");
INSERT INTO rmn_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Ов пхэнляс: — Мэ алгыштиел тут о Сагбус о Яхвэ, ми чяй! Ту кердян зиядэ, ниш буруни: на родинян туки тэрнэс, нэ чёрэс, нэ барвалэс. ");
INSERT INTO rmn_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Ма траша, ми чяй. Мэ кан керав алаи, со ту кан мангес, вай андэ адалэ дизатэ алаи джянэн, кай ту лачи джювли. ");
INSERT INTO rmn_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Адава чячи, мэ то тухуми. Ай си генэ тухумя май пашэ, ниш мэ. ");
INSERT INTO rmn_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Сов атхэ, ай рано, ов тэ керэла со камэл тэ керэл, — лачё, мэ керэл. Ай ов тэ на мангела тэ керэл ярдыми, дэчи мэ ангал Сагбус Яхвэ хав совля, мэ кан керав ярдыми туки. Сов, о сабаги дага дур. ");
INSERT INTO rmn_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Ой сути лэски пинрэндэ джи сабахтаняки тай ущини ангал отхэ, бискай на уло дисипэ. О Боаз тюшунды: «Зиядэ никхон мэ на джянэл, кай ой алисас атхэ». ");
INSERT INTO rmn_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Ов пхэнляс лаки: — Дэ ти накидка, сави опэр тутэ, тай астар ла. Кана ой кердяс адава, о Боаз чёрдяс андэ шов сырэс ячмени, тай кердяс ярдыми тэ чел о дорбаз опэр пхике. Пал отхэ гело андэ диз. ");
INSERT INTO rmn_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Э Руфь али пэ сасатэ, тай одоя пхучляс: — Ми чяй, сар ту? Э Руфь пхукавдяс лаки одолэстар, со кердяс о Боаз, ");
INSERT INTO rmn_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","тай генэ: — Ов диняс ман акала шов сырэс ячмени тай пхэнляс: «Ма джя тэ сасатэ чюче вастэнца». ");
INSERT INTO rmn_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Э Ноеминь пхэнляс: — Ишандие, ми чяй, бискай на кан галёс, сар алаи кан бытиел. Вай адава мануш на кан тэрдёл, бискай авдес на кан керэл о дилэс. ");
INSERT INTO rmn_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Ай о Боаз гело тай бэшло ки дизаки бар. Дикхел, авэл одова тухуми, савэстар ов пхэнэлас. О Боаз диняс икос лэс тай пхэнляс: — Амал, эл атхэ, бэш пашэ. Одова пашыло тай бэшло. ");
INSERT INTO rmn_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","О Боаз андяс дэшэ барэ манушэн э дизакерэн тай пхэнляс: — Бэшэн акатэ. Он бэшлэ. ");
INSERT INTO rmn_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","О Боаз пхэнляс э тухумески: — Э Ноеминь, сави али катар ливадя Моавитскя, бикнэл котор ливади, сави си амарэ пхралэски э Элимелехески. ");
INSERT INTO rmn_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Мэ тюшундым, кай камэл адалэстар тэ пхукавав туки. Ту тэ кинэс адая ливади ангал алаендэ, кон си атхэ, тай ангал барэ мануша ки дюняски. Мангес — кин, ай на мангес — пхэн манги, мэ тэ джянав. Вай ту камэл ангал тэ керэс адава, ай мэ — пал тутэ. — Мэ кан кинав лэс, — пхэнляс ов. ");
INSERT INTO rmn_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Дэчи о Боаз пхэнляс: — Одова дес, кана ту кан кинэс э пху ки Ноеминь, ту камэл тэ прандозэс опэр моавитянка Руфь, э пхивли э мулэски, тай кана тумэндэ кан аракхлёл чяво, э пху тэ ачёл э мулэски хорандаски. ");
INSERT INTO rmn_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Дэчи о тухуми пхэнляс: — На, мэ нащи кинав, аякха сар мэ кан чёраляв. Кин зиядэ ту, мэ нащи адава керав. ");
INSERT INTO rmn_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","(Авгос андэ Израиль, тэ кинэс я тэ дэс пху, екх андар кинимари челас по минис тай дэлас аврэстэ. Аякха камэлас тэ керэн андэ Израиль тэ сикавэн э дини збора.) ");
INSERT INTO rmn_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","— Кин ту, — пхэнляс о тухуми э Боазески тай читяс о минис. ");
INSERT INTO rmn_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Дэчи о Боаз пхэнляс э барэ манушэнги тай алаи э дюняски: — Авдес тумэ дикхен одова, кай мэ киндём ки Ноеминь алаи, со сас ко Элимелех, ко Хилеон тай ко Махлон. ");
INSERT INTO rmn_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Генэ мэ лилём манги ромня э моавитянка э Руфя, э Махлонески пхивля, тэ овэл э пху э мулэски хорандаски, лэско нав тэ на бристэн машкарэ лэски тухумендэ тай катар бар лэски чяче дизатар. Тумэ авдес дикхен! ");
INSERT INTO rmn_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Дэчи о барэ мануша тай алаи, кон сас ки бар, пхэнлэ: — Амэ дикхлям. Мэ керэл о Сагбус о Яхвэ дэя э джювля, сави авэл андэ тэ кхерэстэ, сар э Рахиль тай э Лия, савэ екхетханэ ваздинэ о кхер э Израилеско. Лэ барвалипэ андэ Ефрафа, тай мэ овэл то нами андэ Вифлееми. ");
INSERT INTO rmn_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Тэ пуендар, савэн о Сагбус о Яхвэ кан дэл тут адалэ тэрнэ джювлятар, ти порода мэ овэл, сар э порода ко Парец, саво аракхлило ки Фамарь тай ко Иуда. ");
INSERT INTO rmn_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","О Боаз лиляс э Руфя, тай ой ули лэски ромни. Ов сас ласа, тай о Сагбус о Яхвэ диняс ла тэ насвалёл пуёстэ, тай латэ аракхлило чяво. ");
INSERT INTO rmn_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","О джювля пхэнэнас э Ноеминяки: — Шукор э Сагбуски э Яхвэски, Саво на ачявдяс тут авдес би турунеско, саво кан дикхел пал тутэ. Мэ овэл о чяворо махтадимэ андэ Израиль! ");
INSERT INTO rmn_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Ов кан керэл то бэшыпэ нэво тай кан дикхел пал тутэ опэр пхуримастэ. Вай ов аракхлило тэ борятэ, сави дэхэл тут, тай сави си туки зиядэ эфта чявэндар. ");
INSERT INTO rmn_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Э Ноеминь лиляс э пуёс, пхеравэлас лэс андэ ангали тай дикхелас лэс. ");
INSERT INTO rmn_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","О джювля, савэ бэшэнас отхэ, пхэнэнас: — Ки Ноеминь аракхлило чяво. Он тхэдэ лэс Овид. Ов уло о дад э Иессееско, саво сас о дад э Давидеско. ");
INSERT INTO rmn_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Аки э порода э Парецки: о Парец сас о дад э Хецронеско, ");
INSERT INTO rmn_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","о Хецрон — о дад э Рамеско, о Рам — о дад э Аминадавеско, ");
INSERT INTO rmn_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","о Аминадав — о дад э Нахшонеско, о Нахшон — о дад э Салмонеско, ");
INSERT INTO rmn_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","о Салмон — о дад э Боазеско, о Боаз — о дад э Овидеско, ");
INSERT INTO rmn_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","о Овид — о дад э Иессееско, ай о Иессей — о дад э Давидеско.");
INSERT INTO rmn_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","О Сагбус о Яхвэ пхэнляс э Ионаски, чявэски э Амиттаески: ");
INSERT INTO rmn_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","— Ущи, джя андэ бари диз ки Ниневия тай пхэн манушэнги, о габэри лэнги джюнгалимастар ало джи Мандэ. ");
INSERT INTO rmn_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Ай о Иона кидиняспэс тэ нашэл катар Сагбус Яхвэ андэ Таршыш. Ов гело андэ Яффа, аракхляс карабляс, кай джял андэ Таршыш, покиндяс андар дром, бэшло опэр лэстэ, тэ джял катар Сагбус Яхвэ. ");
INSERT INTO rmn_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Ай о Сагбус о Яхвэ ваздиняс опэр пани бари зорали балвал, тай ваздиндило аякха лачес о пани, кай о карабляс сас газыри тэ хурдёл. ");
INSERT INTO rmn_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","О марякя трашанилэ, тай кажни лиляс тэ мангел пэ дэвлэс. Он читэ андэ пани алаи о шэя, савэ сас опэр карабляс, ов тэ локёл. Ай о Иона мукляспэс андэ трюми, пашлило отхэ тай лачес суто. ");
INSERT INTO rmn_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","О капитани ало лэстэ тай пхэнляс: — Со сан суто? Ущи, манг тэ Дэвлэс! Файма, Ов кан дикхел амэн, тай амэ на кан мэрас. ");
INSERT INTO rmn_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","О марякя пхэнлэ екхаврэски: — Эла чяс жреби тай галяс, андар кастэ амэндэ уло адава хатас. Он читэ жреби, тай о жреби пэло опэр Иона. ");
INSERT INTO rmn_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Дэчи он пхучлэ лэс: — Пхэн амэнги, кон эси дошало адалэ хатаски? Соса казандиес? Катар авэс? Со пхуятар ту сан? Андар со дюнястэ? ");
INSERT INTO rmn_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Ов пхэнляс: — Мэ евреи тай гинав э Сагбус э Яхвэс, э Дэвлэс опрунэс, Саво кердяс о пани тай э пху. ");
INSERT INTO rmn_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","О Иона пхукавдяс лэнги, кай ов нашэл катар Сагбус Яхвэ. Кана он адалэстар галилэ, он бут трашанилэ тай пхучлэ: — Со ту кердян? ");
INSERT INTO rmn_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Ай о пани ваздиндёлас май лачес тай лачес, тай дэчи он пхучлэ лэс: — Со амэнги тэ керас туса, тэ тэрдёл о пани ангал амэндэ? ");
INSERT INTO rmn_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","— Лэн ман тай чен андэ пани, — пхэнляс ов, — тай ов кан тэрдёл ангал тумэндэ. Мэ джянав, кай адая бари зорали балвал пэли опэр тумэндэ андар мандэ. ");
INSERT INTO rmn_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Ай он лилэ май зоралэс тэ дэн джялдави, тэ пашон ки пху, ай он адава нащи кердэ, вай о пани ваздиндёлас май лачес тай лачес. ");
INSERT INTO rmn_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Дэчи он лилэ тэ манген э Сагбус э Яхвэс: — Сагбус Яхвэ, ма дэ тэ мэрас андар адалэ манушэстэ. О мэрипэ э бидошалэ манушэско мэ на овэл опэр амэндэ, вай Ту, Сагбус Яхвэ, керэс одова, со мангес Ту. ");
INSERT INTO rmn_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Дэчи он лилэ э Ионас, читэ лэс андэ пани, тай о пани тэрдило. ");
INSERT INTO rmn_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","О марякя лачес трашанилэ катар Сагбус Яхвэ, кердэ э Сагбуски э Яхвэски курбани тай халэ совля. ");
INSERT INTO rmn_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","О Сагбус о Яхвэ бичялдяс барэ мачес, тай ов накхавдяс э Ионас. О Иона сас андэ маческо пэр трин дес тай трин ратя. ");
INSERT INTO rmn_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","Кана сас андэ маческо пэр, о Иона мангелас пэ Дэвлэс э Яхвэс. ");
INSERT INTO rmn_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Ов пхэнляс: — Андэ хурлуки мэ манглём э Сагбус э Яхвэс , тай Ов пхэнляс манги. Андар хорипэ ко дюняс ки мулэнго мэ динём бэбэря — тай Ту шунлян ми бэбэря. ");
INSERT INTO rmn_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Ту читян ман андэ хорипэ, андэ ило ки панеско; агорадылар ман о паня. Алаи Тэ кубукенги паня накхлэ опрал мандэ. ");
INSERT INTO rmn_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Мэ пхэнлём: «Кувдимэ мэ Тэ якхендар; ай мэ генэ кан дикхав о шужо храми Тинро». ");
INSERT INTO rmn_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","О паня учярдэ ман, о хорипэ агорады ман, тай э панески чяря колисаилэ мэ шэрэстэ. ");
INSERT INTO rmn_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Ко днас, ко кориня ки горадэнги мэ фулистинём, о клидя э пхуяки пханлилэ пал мандэ алаи э вахытески, ай Ту, Яхвэ, Дэл минро, никалдян ман андар хорипэ дживиндэс! ");
INSERT INTO rmn_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Кана о бэшыпэ бытиелас андэ мандэ, мэ катар Сагбус Яхвэ тюшундым, тай гело мо мангипэ джи Тутэ, андэ шужо храми Тинро. ");
INSERT INTO rmn_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Одола, кон гинэл э чюче дэвлэн, ачявдэ по пакяпэ Туки. ");
INSERT INTO rmn_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Ай мэ лошанэ гиленца кан анав Туки курбанен. Кай халём совля — кан керав. О кутардипэ — катар Сагбус Яхвэ! ");
INSERT INTO rmn_vpl VALUES ("JH2_11","033_2_11","JON","2","11","11","О Сагбус о Яхвэ пхэнляс э мачески, тай ов читяс э Ионас опэр пху. ");
INSERT INTO rmn_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","О Сагбус о Яхвэ пхэнляс э Ионаски дуйто рази: ");
INSERT INTO rmn_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","— Ущи, джя андэ бари диз ки Ниневия тай пхэн манушэнги, со Мэ туки пхэнав. ");
INSERT INTO rmn_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","О Иона тхэдяскан э Сагбус э Яхвэс збора тай кидиняспэс, гело ки Ниневия. Э Ниневия сас Дэвлэски бари диз — тэ накхес ла камэлас трин дес. ");
INSERT INTO rmn_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","О Иона диняс андэ диз тай састо дес перэлас тай бэбэряса пхэнэлас: «Генэ саранда дес, тай э Ниневия кан овэл хурдярди!» ");
INSERT INTO rmn_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","О ниневитяня пакянилэ э Дэвлэски тай лилэ оразас, тай алаи — катар барвало джи ко чёро — урявдэ гонэски савутя. ");
INSERT INTO rmn_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Кана адава габэри гело джи ко патишаи ки Ниневияко, ов ущино пэ тронестар, читяс пэ патишаитика савутя, урявдяс гонэски савутя тай бэшло андэ прахос. ");
INSERT INTO rmn_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","О патишаи кидиняс пэ барэ манушэн, тай екхетханэ он андэ Ниневия пхэнлэ асавко тхэдипэ: «О мануша мэ на хан тай мэ на пиен. Тай о гайваня мэ на джян тэ чярён тай тэ пиен пани. ");
INSERT INTO rmn_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Мэ урявэн ли э манушэн, ли э гайванен гонэски савутя. Кажни андар алаи пэ зоратэ мэ мангел э Дэвлэс. Мэ тэрдён тэ керэн джюнгалэ дилэс тай канлыки. ");
INSERT INTO rmn_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Кон джянэл, файма, о Дэл кан паровэл, со тюшундиелас, кан аядиел амэн тай кан тэрдёл тэ холязэл, тай амэ на кан мэрас». ");
INSERT INTO rmn_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Кана о Дэл дикхляс одова, со он кердэ, тай сар он ачявдэ пумарэ джюнгалэ дилэс, Ов кердяс мила лэнги тай на бичялдяс опэр лэндэ джюнгалипэ, саво Ов мангляс тэ бичялэл. ");
INSERT INTO rmn_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","О Иона холясаило, бут холясаило. ");
INSERT INTO rmn_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Ов лиляс тэ мангел э Сагбус э Яхвэс: — Сагбус Яхвэ, та со, мэ на адава пхэнавас, кана дага сомас кхерэ? Оничин мэ нашлём андэ Таршыш. Мэ джянавас, кай Ту о Дэл, саво керэл лачипэ тай мила, бутэдаяндимаско тай бутэдэхымаско тай Ту касывэтлыс андар бибахталипэ. ");
INSERT INTO rmn_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Ай акана, Сагбус Яхвэ, лэ мо бэшыпэ, вай манги зиядэ тэ мэрав, ниш тэ бэшав. ");
INSERT INTO rmn_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Ай о Сагбус о Яхвэ пхэнляс: — Лачё туки тэ холязэс? ");
INSERT INTO rmn_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","О Иона никлисто тай бэшло карин вастоки катар диз. Отхэ ов кердяс пэски катуна катар веткес, бэшло тэлал андэ салкыни тай лиляс тэ ишандиел, со кан овэл э дизаса. ");
INSERT INTO rmn_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Ай о Дэл о Яхвэ кердяс аякха, кай барило кущёки, саво ваздиндило опэр Иона, о салкыни опэр лэски шэрэстэ тэ кутардиел лэс катар кхам, тай о Иона бут лошасаило адалэ кущёкески. ");
INSERT INTO rmn_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Ай ангал сабахтанятэ авэр дес о Дэл бичялдяс кермэс, саво халяс о кущёки, тай ов шукило. ");
INSERT INTO rmn_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Кана о кхам ваздиндило, о Дэл бичялдяс тхари васточни балвал, тай о кхам лиляс тэ тхарэл о шэро э Ионаско аякха, кай э зор ачявэлас лэс. Ов мангляс тэ мэрэл тай пхэнляс: — Зиядэ си манги тэ мэрав, ниш тэ бэшав. ");
INSERT INTO rmn_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Ай о Дэл пхэнляс э Ионаски: — Лачё туки тэ холязэс андар кущёки? — Лачё! — пхэнляс ов. — Лачё на екх тэ холязав, ами джи тэ мэрав. ");
INSERT INTO rmn_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Ай о Сагбус о Яхвэ пхэнляс: — Ту аядиес о кущёки, саво ту на барярдян. Ов андэ рат барило тай андэ рат шукило. ");
INSERT INTO rmn_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Манги дэчи тэ на аядияв э бари диз э Ниневия, катэ си бут гайваня тай бут шэлэ бишэ бине манушэндар, савэ на джянэн, со си лачё, тай со си джюнгало?");
INSERT INTO rmn_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","О бут лилэпэс тэ яздиен одолэстар, со сас машкарэ амэндэ, ");
INSERT INTO rmn_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","со пхукавдило амэнги э манушэнца, савэ май ангал дикхлэ пумарэ якхенца, тай сас о иргатя э Збораки. ");
INSERT INTO rmn_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ли мэ лилём тэ галяв алаи лачес, со сас ангал, тай тэ пхукавав туки, намлысана Феофил, алаи пал екх аврэстэ, ");
INSERT INTO rmn_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","кай ту тэ галёс, со шунлян, си о чячипэ. ");
INSERT INTO rmn_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","О вахыти, кана о Ирод сас патишаи э Иудеяко, сас попази, саво бучёлас Захария, андар Авияско попазенго джемэяти, тай э ромни лэски андар порода ки Ааронески, кай бучёлас Елизавета. ");
INSERT INTO rmn_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Он ли о дуй сас чяче ангал Дэл, тай керэнас лачес алаи о пхэнлиматэс тай о тхэдиматэс э Сагбуски. ");
INSERT INTO rmn_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Лэндэ на сас пуя, э Елизавета сас бипуенги, ли о дуй он э сас пхурэ. ");
INSERT INTO rmn_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Екхвар э попазенги джемэятески э Захариескерэски ало вахыти тэ керэн хэзмэти ангал Дэл. ");
INSERT INTO rmn_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Сар екхараи керэнас, о попазя читэ жреби, тай э Захариески пэло тэ джял андэ храми ки Сагбуско, тэ тхарэл чяря, савэ кхандэн. ");
INSERT INTO rmn_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","О вахыти, кана тхарэлас о чяря, савэ кхандэн, андэ бар бут мануша пхэнэнас э Дэвлэски. ");
INSERT INTO rmn_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Бирдэн о Захария дикхляс э миляикес э Сагбускерэс, саво сас тэрдо катар прави риг ки алтарески, катэ тхарэнас о чяря, савэ кхандэн. ");
INSERT INTO rmn_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Кана о Захария дикхляс лэс, ов шашты тай трашанило. ");
INSERT INTO rmn_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","О миляики пхэнляс лэски: — Ма траша, Захария, О Дэл шунляс то мангипэ. Тэ ромнятэ ки Елизавета кан овэл чяво, тай ту кан тхэс лэс Иоанн. ");
INSERT INTO rmn_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","То ило кан пхэрдёл бахт тай лош, тай о бут кан лошазэн, кай ов аракхлило, ");
INSERT INTO rmn_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","вай ов кан овэл баро ангал Сагбус. Ов на кан пиел винас тай нисавэ матимаски пииматэс. Дага ангал отхэ, сар ов кан аракхлёл, ов кан овэл пхэрдо Шужэ Духоса. ");
INSERT INTO rmn_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Бутэ израильтянен ов кан анэл палэ ко Сагбус, лэнги Дэвлэстэ. ");
INSERT INTO rmn_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ов кан авэл ангал Сагбус андэ духос тай андэ зор ки Илияски, тэ болдэл о илэ э дадэнги ко пуя, ай савэ на тхэн кан — ко годявэрипэ ки чяче манушэнго, тай кан гортярэл э дюняс ангал отхэ, кай кан авэл о Сагбус. ");
INSERT INTO rmn_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","О Захария пхучляс э миляикес: — Сар мэ тэ галяв, кай адава кан овэл? Вай мэ сом пхуро, тай э ромни минри барэ брэшэнги. ");
INSERT INTO rmn_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","О миляики пхэнляс: — Мэ — о Гавриил, кай тэрдо ангал Дэл, тай мэ бичялдо тэ зборизав туса, тай тэ пхэнав туки адава лошано габэри. ");
INSERT INTO rmn_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ай анкха андар одолэстэ, кай ту на пакянилян мэ зборэнги, савэ кан овэн пумаро вахыти, ту сакави кан овэс тай нащи кан зборизэс джи одолэ вахытески, бискай адава на кан овэл. ");
INSERT INTO rmn_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ай адава вахыти о мануша ишандиенас э Захариес тай шаштиенас, соски ов аякха бут вахыти на никлёл андар храми. ");
INSERT INTO rmn_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Кана о Захария никлисто, ов нащи зборизэлас. Алаи галилэ, кай андэ храми лэски со-то сикавдило. Ов камэлас тэ зборизэл лэнца вастэнца, тай ачёлас сакави. ");
INSERT INTO rmn_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Кана о деса бытылар лэски попазески бутяко, о Захария ало кхерэ. ");
INSERT INTO rmn_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Андар набут вахытестар лэски ромни э Елизавета насвалили пуёстэ тай пандж чён на никлёлас андар кхер. ");
INSERT INTO rmn_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ой пхэнляс: — Аки со кердяс манги о Сагбус, кана мангляс тэ лэл опрал мандэ о ладжяво ангал мануша! ");
INSERT INTO rmn_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Кана э Елизавета сас шовто чён насвали пуёстэ, о Дэл бичялдяс миляикес э Гавриилес андэ галилейски диз, кай бучёл Назарет, ");
INSERT INTO rmn_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ки чяй, кай бучёлас Мария. Э Мария сас манглярди э Иосифеса, андар порода ки Давидески. ");
INSERT INTO rmn_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","О миляики ало латэ тай пхэнляс: — Сэлями туки, дини мила! Туса о Сагбус! ");
INSERT INTO rmn_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Э МариЯ адала зборэс бут шаштэрдылар, тай ой тюшундиелас, со адава сас асавко сэлями. ");
INSERT INTO rmn_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","О миляики пхэнэлас: — Ма траша, Мариё, вай о Дэл кердяс туки мила! ");
INSERT INTO rmn_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ту кан насвалёс пуёстэ тай кан аракхлёл тутэ Чяво, тай кан тхэс Лэс Исус. ");
INSERT INTO rmn_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ов кан овэл баро, тай Лэски кан пхэнэн о Чяво э Уче Дэвлэско. О Сагбус Дэл кан дэл Лэс о трони э Давидеско, саво андар Лэски папудэндэ, ");
INSERT INTO rmn_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","тай Ов кан овэл Патишаи опэр кхер ки Яковеско алаи о вахытя, тай Лэско Патишайлыки на кан бытиел. ");
INSERT INTO rmn_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","— Сар адава кан овэл? — пхучляс э Мария ко миляики. — Вай мэ дага на сомас муршэса. ");
INSERT INTO rmn_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ай о миляики пхэнляс лаки: — О Шужо Духос кан авэл опэр тутэ, тай тут кан учярэл э зор э Уче Дэвлэски. Оничин о Пуёс о Шужо, Саво кан аракхлёл тутэ, кан бучёл о Чяво э Дэвлэско. ");
INSERT INTO rmn_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Аки ли ти тухумиса э Елизавета, ли латэ кан аракхлёл чяво опэр пхуримастэ. Латар пхэнэнас, кай ой си бипуенги, ами ой си шовто чён насвали пуёстэ. ");
INSERT INTO rmn_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Э Дэвлэски нанай ништо, со нащи керэл. ");
INSERT INTO rmn_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","— Мэ иргатинка э Сагбуски, — пхэнляс э Мария, — мэ овэл алаи манца аякха, сар ту пхэнлян. Тай о миляики мукляс ла. ");
INSERT INTO rmn_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Пал адалэстэ э Мария кидиняспэс тай сигярдяс андэ диз, кай сас андэ горадэс ки Иудеяки. ");
INSERT INTO rmn_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ой диняс андэ кхер ки Захариеско тай диняс сэлями э Елизаветаса. ");
INSERT INTO rmn_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Кана э Елизавета шунляс о сэлями э Марияко, о пуёс андэ латэ читяспэс; э Елизавета пхэрдяс Шужо Духос, ");
INSERT INTO rmn_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","тай ой бэбэряса пхэнляс: — Махтадимэ ту машкарэ ко джювля, тай махтадимэ о Пуёс, Савэс ту пхеравэс! ");
INSERT INTO rmn_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Катар манги асавко, кай мандэ али э дай мэ Сагбуски? ");
INSERT INTO rmn_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Кана мэ шунлём то сэлями, о пуёс андэ мандэ читяспэс катар лош. ");
INSERT INTO rmn_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Бахтали э джювли, сави пакянили, кай кан овэл одова, со пхэнляс о Сагбус! ");
INSERT INTO rmn_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Э Мария пхэнляс: — Мо ило махтадиел э Сагбус, ");
INSERT INTO rmn_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","тай о ило минро лошазэл катар Дэл, о Кутардимари минро, ");
INSERT INTO rmn_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","вай Ов дикхляс, кай ивашы Лэски иргатинка. Акана алаи о породэс кан пхэнэн манги бахтали, ");
INSERT INTO rmn_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","андар одолэстэ, кай о Зорало Дэл кердяс асавки бари дила манги! Лэско нав шужо! ");
INSERT INTO rmn_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Катар порода ки порода Ов керэл мила одолэнги, кон трашал Лэстар! ");
INSERT INTO rmn_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Лэски вастэса кердэ барэ дилэс: Ов кердяс каипи э фалаки илэнгерэн, ");
INSERT INTO rmn_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","читяс э зоралэн лэнги тронестар тай ваздиняс э ивашэн! ");
INSERT INTO rmn_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ов чялярдяс лачимаса э бокхалэн, ай э барвалэн бичялдяс чючен. ");
INSERT INTO rmn_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ов кердяс ярдыми Пэ иргатески э Израилески, тай на бристэрдяс Пи збора, кай диняс амарэ дадэн, — ");
INSERT INTO rmn_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","тэ овэл миласа ко Авраам тай кон аракхлило лэстар алаи о вахытя. ");
INSERT INTO rmn_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Э Мария сас ки Елизавета паш ко трин чён тай дэчи али палэ кхерэ. ");
INSERT INTO rmn_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Кана ало о вахыти, ки Елизавета аракхлило чяво. ");
INSERT INTO rmn_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Лаки комшудэс тай о тухумя шунлэ одолэстар, кай о Сагбус кердяс лаки бари мила, тай лошазэнас екхетханэ ласа. ");
INSERT INTO rmn_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ко охтото дес алэ, тэ керэн э пуёски абрезания, тай манглэ тэ тхэн лэс, сар э дадэс, Захария. ");
INSERT INTO rmn_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ай э дай пхэнляс: — На! Ов кан бучёл Иоанн. ");
INSERT INTO rmn_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Лаки лилэ тэ пхэнэн: — Та вай машкарэ тумарэ тухумендэ нанай никхон асавке навэса! ");
INSERT INTO rmn_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Он лилэ вастэнца тэ пхучен ко дад, сар би ов мангелас тэ тхэл пэ чявэс. ");
INSERT INTO rmn_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","О Захария мангляс пхалёри тэ яздиел, тай э шаштимаски алаенгерэски, язды: «Лэско нав Иоанн». ");
INSERT INTO rmn_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Одова жэ сагати ов генэ лиляс тэ зборизэл, махтадиелас э Дэвлэс. ");
INSERT INTO rmn_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Алаи э комшудэн лиляс траш, тай о габэри адалэстар, со уло, накхло алаи о горадэс э Иудеяки. ");
INSERT INTO rmn_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Алаи, кон шунляс адалэстар, тюшундиенас андэ пумарэ илэндэ: — Кон кан овэл адава пуёс? — вай о васт э Сагбуско сас лэса. ");
INSERT INTO rmn_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","О Шужо Духос пхэрдяс э Захариес, э дадэс э Иоаннескерэс, тай ов лиляс тэ пхэнэл, сар прароки: ");
INSERT INTO rmn_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","— Махтадимэ о Сагбус, о Дэл э Израилеско, Саво ало Пэ дюнястэ, покиндяс тай кутарды лэс! ");
INSERT INTO rmn_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ов ваздиняс амэнги Кутардимарес андар кхер Пэ иргатестар ко Давид, ");
INSERT INTO rmn_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","сар Ов чёктан динясас збора андар Пэ шужэ прарокендэ, ");
INSERT INTO rmn_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","кай Ов кан кутардиел амэн катар душманя тай катар васт одолэнгерэндар, кон на дэхэл амэн. ");
INSERT INTO rmn_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Аякха Ов кердяс мила амарэ папудэнги тай на бристэрдяс По шужо завети, ");
INSERT INTO rmn_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","совля, савэ Ов халяс амарэ дадэски э Авраамески: ");
INSERT INTO rmn_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","кан кутардиел амэн катар васта амарэ душманенги, тай амэ битрашако тэ керас иргатлыки Лэски, ");
INSERT INTO rmn_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","тэ бэшас ангал Лэстэ андэ шужымастэ тай андэ чячимастэ алаи о деса амарэ бэшымаски! ");
INSERT INTO rmn_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ай ту, пуёс, кан бучёс прароки э Уче Дэвлэско тай кан джяс ангал Сагбус, тэ гортярэс Лэски дром, ");
INSERT INTO rmn_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","тэ пхукавэс Лэски дюняски, кай о кутардипэ авэл, кана о бэзя муклён. ");
INSERT INTO rmn_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Амаро Дэл милако, Ов кан бичялэл амэнги опрал, Сабахтутно Ярэки ");
INSERT INTO rmn_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","тай кан дэл ярэки одолэн, савэ бэшэн андэ тэмина тай андэ траш ангал мэрипэ, тай кан болдэл амарэ пинрэ ко дром ки лачимаско! ");
INSERT INTO rmn_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","О Пуёс барёлас тай зоралёлас духоса. Ов бэшэлас ки ливади джи одолэ вахытески, сар на сикавдяспэс ангал мануша ки Израилески. ");
INSERT INTO rmn_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Одола деса о император Август тхэдяс тэ гинэн тай тэ яздиен алаен опэр алаи ки пху, катэ бэшэн о мануша. ");
INSERT INTO rmn_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Кана э Сирияко сагбус сас о Квириний, адава сас о баштутно яздипэ. ");
INSERT INTO rmn_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Оничин кажни гело пэ дизатэ тэ яздиелпэс. ");
INSERT INTO rmn_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","О Иосиф гело андар галилейски диз Назарет андэ пху Иудея, андэ диз ки Давидески, кай бучёл Вифлееми, вай ов сас андар порода ки Давидески. ");
INSERT INTO rmn_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ов гело э Марияса отхэ тэ яздиелпэс. Ой сас лэса манглярди, тай сас насвали Пуёстэ. ");
INSERT INTO rmn_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ко Вифлееми э Марияки ало вахыти, тэ аракхлёл о пуёс, ");
INSERT INTO rmn_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","тай аракхлило о чяво лако баштутно, тай пакярдяс Лэс, тай тхэдяс андэ арани, вай лэнги на аракхлило тхан андэ кхер. ");
INSERT INTO rmn_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Надур сас чёбаня, савэ бэшэнас ки ливади тай дикхенас рати пал пумарэ атарэс. ");
INSERT INTO rmn_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Бирдэн тэрдило ангал лэндэ о миляики э Сагбуско, тай о нами э Сагбуско учярдяс лэн ярэкеса. О чёбаня лачес трашанилэ. ");
INSERT INTO rmn_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ай о миляики пхэнляс лэнги: — Ма трашан! Мэ алём тэ пхэнав тумэнги габэри, кай кан анэл бари лош алаи э дюняски! ");
INSERT INTO rmn_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Авдес андэ диз ки Давидески аракхлило тумаро Кутардимари — Христос, о Сагбус! ");
INSERT INTO rmn_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Аки тумэнги сикаипэ: тумэ кан аракхен э Пуёс, пакярдэс тай пашлэс андэ арани. ");
INSERT INTO rmn_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Бирдэн паш миляики улэ аборкха миляикя опрунэ, кай на дикхиндёлас о чети. Он махтадиенас э Дэвлэс тай бэбэряса пхэнэнас: ");
INSERT INTO rmn_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","— Махтадипэ э Дэвлэски андэ учипэ опрэ! Ай опэр пху рагати э манушэнги, савэнги Ов кердяс мила! ");
INSERT INTO rmn_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Кана о миляикя гелэ лэндар опрэ, о чёбаня пхэнлэ екх аврэски: — Гадэн андэ Вифлееми тай кан дикхас, со отхэ уло, состар адава амэнги пхэнляс о Сагбус. ");
INSERT INTO rmn_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Он сигярдэ отхэ тай аракхлэ э Мария, э Иосифес тай э Пуёс, пашлэс андэ арани. ");
INSERT INTO rmn_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Кана он Лэс дикхлэ, тай пхукавдэ алаи, со лэнги сас пхэнло адалэ Пуёстар. ");
INSERT INTO rmn_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Алаи, кон шунэлас, шаштиенас, со пхукавэн о чёбаня, ");
INSERT INTO rmn_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","э Мария ништо на бристэлас тай тюшундиелас адалэстар. ");
INSERT INTO rmn_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","О чёбаня гелэ палэ, барярэнас тай махтадиенас э Дэвлэс андар алаестэ, со он дикхлэ тай шунлэ: алаи уло аякха, сар лэнги сас пхэнло. ");
INSERT INTO rmn_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ко охтото дес, кана ало о вахыти тэ керэн Лэски абрезания, Лэс тхэдэ Исус, о нав, саво о миляики диняс Лэс дага, кана э Мария на сас насвали Пуёстэ. ");
INSERT INTO rmn_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Кана быты о вахыти э шужымаско, сар яздиндёл андэ Тхэдипэ ки Маисееско, э Мария тай о Иосиф гелдэ э Пуёс ко Иерусалими, тэ башладиен Лэс э Сагбуски. ");
INSERT INTO rmn_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Вай андэ Тхэдипэ ки Сагбуско яздимэ: «Кажни баштутно чяво камэл тэ овэл башладимэ э Сагбуски». ");
INSERT INTO rmn_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Сар си яздимэ андэ Тхэдипэ ки Сагбуско, он камэлас тэ анэн курбани — до барэ голубен я до тэрнэ голубен. ");
INSERT INTO rmn_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Андэ Иерусалими адава вахыти сас мануш, саво бучёлас Симеон. Ов сас Дэвлэско чячё мануш тай ишандиелас Одолэс, Кон кан анэл рагати э Израилески, тай опэр лэстэ сас Шужо Духос. ");
INSERT INTO rmn_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","О Шужо Духос пхутэрдяс лэски, кай ов на кан мэрэл, сар на дикхел э Сагбуски Христос. ");
INSERT INTO rmn_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Гелдо э Шужэ Духоса, о Симеон ало андэ храми, тай кана о дад тай э дай андяс э Пуёс э Исусес, тэ керэн опэр Лэстэ одова, со пхэнлёлас андэ Тхэдипэ, ");
INSERT INTO rmn_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","о Симеон лиляс э пуёс андэ васта, махтады э Дэвлэс тай пхэнляс: ");
INSERT INTO rmn_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","— Барэя! Сар Ту пхэнлян, акана Ту мукес Тэ иргатес лачимаса, ");
INSERT INTO rmn_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","вай мэ якха дикхлэ о кутардипэ Тинро, ");
INSERT INTO rmn_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","саво Ту гортярдян ангал муя алаи ки дюняски. ");
INSERT INTO rmn_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ов ярэки, саво кан учярэл алаи о дюнядэс, тай о нами э дюняски Тинрэски Израиль! ");
INSERT INTO rmn_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","О дад тай э дай э Исусески шаштиенас одолэски, со пхэнэнас Лэстар. ");
INSERT INTO rmn_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Дэчи о Симеон мангляс алгышы лэнги тай пхэнляс э Марияки, э дэяки Лэскеряки: — Аки пашло Одова, андар савэстэ о бут андэ Израиль кан пэрэн тай о бут кан ваздиндён. Вай ли то ило кан хэвлярэл о камас. Тай кан овэл адава Пуёс сикаипэ, савэстар о бут кан болдэнпэс, тай андар адалэстэ кан пхутэрдёл, состар он тюшундиенас андэ ило. ");
INSERT INTO rmn_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Отхэ сас ли э Анна, э прарочица, э чяй э Фануилески андар порода Асира. Ой э сас бут пхури. Э Анна гели ромэстэ тэрнёри тай бэшли эфта брэш пэ ромэса, ");
INSERT INTO rmn_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ай алаи по ачявдо бэшыпэ ой бэшэлас пхивли. Лаки сас охтодэша штар брэш. Ой били екхвар на джялас андар храми, ли о дес ли э рат керэлас иргатлыки оразаса тай мангимаса э Дэвлэски. ");
INSERT INTO rmn_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Адава вахыти ой пашыли тай барярдяс э Дэвлэс, тай пхэнэлас катар Пуёс алаенги, кон ишандиел кутардипэ э Иерусалимески. ");
INSERT INTO rmn_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Кана о дад тай э дай э Исусески кердэ алаи, сар си яздимэ андэ Тхэдипэ ки Сагбуско, он гелэ палэ ки Галилея, андэ пэ чяче дизатэ андэ Назарет. ");
INSERT INTO rmn_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","О Пуёс барёлас тай пхэрдёлас зор тай годи, тай э мила э Дэвлэски сас опэр Лэстэ. ");
INSERT INTO rmn_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Кажни брэш, кана авэл Пэсах, о дад тай э дай э Исусески джянас андэ Иерусалими. ");
INSERT INTO rmn_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Кана э Исусески сас дэшудуй брэш, он, сар екхараи, гелэ ко мисяфирлыки. ");
INSERT INTO rmn_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Пал отхэ, сар быты о мисяфирлыки, кана джянас кхерэ, о Чяворо о Исус ачило андэ Иерусалими, ай Лэско дад тай э дай адалэстар на джянэнас. ");
INSERT INTO rmn_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Тюшундиенас, кай Ов джял машкарэ аврэ манушэндэ, он пал ко састо дес дром лилэ тэ родэн Лэс машкарэ ко тухумя тай ко джянлэ мануша. ");
INSERT INTO rmn_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Кай на аракхлэ, он палэ гелэ ко Иерусалими, тэ родэн отхэ. ");
INSERT INTO rmn_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Тринэ десендар он аракхлэ э Чяворэс андэ храми. Ов бэшло сас машкарэ ко сикляримаря, шунэлас лэн тай пхучелас лэндэ. ");
INSERT INTO rmn_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Алаи, кон Лэс шунэлас, шаштиенас Лэски джянлимаски тай Лэски зборэнги. ");
INSERT INTO rmn_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","О дад тай э дай сас шаштимэна, кай дикхлэ Лэс отхэ. — Мо чяворо, соски Ту аякха амэнца кердян? — пхучляс Лэс э дай. — То дад тай мэ андэ касэвэтестэ самас тай родасас Тут. ");
INSERT INTO rmn_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","— Соски тумэ родэнас Ман? — пхучляс Ов. — Та со, тумэ на джянэнас, кай Мэ камэл тэ овав андэ кхер Мэ Дадэстэ? ");
INSERT INTO rmn_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ай он на галилэ, состар Ов лэнги пхэнэлас. ");
INSERT INTO rmn_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ов гело лэнца ко Назарет тай тхэлас кан лэн. Ай алаи, со уло, э дай Лэски гаравэлас андэ пэ илэстэ. ");
INSERT INTO rmn_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","О Исус барёлас тай овэлас май годявэр. Лэс дэхэнас ли о мануша, ли о Дэл. ");
INSERT INTO rmn_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Андэ дэшупанджто брэш ки императореско э Тиберияско, кана опэр Иудея сас о Понтий Пилат, о Ирод сас о сагбус-тетрархи э Галилеяко, лэско пхрал о Филипп — о сагбус-тетрархи э Итуреяко тай э Трахонияки областяко, о Лисаний — о сагбус-тетрархи э Авилинеяко, ");
INSERT INTO rmn_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ай о барэ попазя сас о Аннас тай о Кайафа, э збора э Дэвлэски сас э Иоаннески, э чявэски э Захариескерэски, ки ливади. ");
INSERT INTO rmn_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Пал отхэ о Иоанн гело алаи ко пхуя, савэ сас паш ко Иордани, тай пхэнэлас э манушэнги, тэ ачявэн пумарэ бэзя тай тэ болэнпэс, тэ мукел о Дэл лэнги бэзя. ");
INSERT INTO rmn_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Сар си яздимэ андэ книжка ки прарокески Исаиески: «Сэси шунлёл ки ливади: \"Гортярэн о дром э Сагбуски, керэн доврус о тхан, опрал савэстэ Ов кан накхел! ");
INSERT INTO rmn_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Кажни хорипэ мэ овэл пхэрдо, тай кажни горас тай учё тхан — мэ фулен тэлэ; о болавдэ дрома мэ овэн доврус, тай о камбуря дрома — мэ гортён, ");
INSERT INTO rmn_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","тай алаи о дживиндэ тэ дикхен э Дэвлэско кутардипэ\"». ");
INSERT INTO rmn_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ко Иоанн авэнас бут дюнядэс, тэ болэл ов лэн, ов лэнги пхэнэлас: — Тумэ, канлыс сапанэ породаки! Кон пхэнляс тумэнги тэ нашэн катар холи, кай авэл? ");
INSERT INTO rmn_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Дилэнца сикавэн, кай ачявдянус тумарэ бэзя. Ма тюшундиен тэ пхэнэн андэ тумэндэ: «Амаро дад — о Авраам!» Пхэнав тумэнги, кай ко Дэл си зор тэ керэл пуен э Авраамески акалэ барэндар. ");
INSERT INTO rmn_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","О товэр пашло ко корини ки тэрэкеско, тай саво тэрэки на анэл лаче имиша, кан овэл чиндо тай чито андэ яг. ");
INSERT INTO rmn_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","— Со амэнги тэ керас? — пхучелас о дюняс. ");
INSERT INTO rmn_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","О Иоанн пхэнляс: — Одова, кастэ си дуй гада, мэ дэл екх одолэс, савэстэ нанай били екх, тай одова, кастэ си хапэ, мэ керэл аякха жэ. ");
INSERT INTO rmn_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Кидимаря э налогенги авэнас тэ болэнпэс. — Сикляримарина, — пхученас он, — со амэнги тэ керас? ");
INSERT INTO rmn_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","— Ма лэн катар мануша бут, ниш камэл, — пхэнэлас ов лэнги. ");
INSERT INTO rmn_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Пхученас лэс о салдатя: — Ами со амэнги тэ керас? О Иоанн пхэнляс лэнги: — Ма лэн ко мануша ловэ зораса тай трашаимаса, никхас хохавнэс ма керэн тай дошалэс, бэшэн одолэса, со покинэн тумэнги. ");
INSERT INTO rmn_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","О дюняс ишандиенас, тай алаи мангенас тэ галён, на о Христос си о Иоанн. ");
INSERT INTO rmn_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Адалэски о Иоанн пхэнэлас лэнги алаенги: — Мэ болав тумэн панеса, ай кан авэл Одова, Саво май зорало мандар, мэ на керав тэ пхутрав э кустик Лэски минидэндэ. Ов кан болэл тумэн э Шужэ Духоса тай ягаса. ");
INSERT INTO rmn_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Лэстэ андэ васта сэнэки, тэ шужарэл о гив. О гив кан кидэл андэ Пэ аранестэ, ай о сипэс кан тхарэл андэ яг, сави на мэрэл. ");
INSERT INTO rmn_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Тай бут авэр пхэнэлас о Иоанн, тай галярэлас э дюняски, тай пхукавэлас лэски Лошано Габэри. ");
INSERT INTO rmn_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","О Иоанн лиляс тэ керэл дошалэс э сагбус-тетрархи э Иродес, кай лиляс э Иродиада, пэ пхралэски ромня, тай андар алаи ко канлыдэс дилэс лэскерэндэ. ");
INSERT INTO rmn_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","О Ирод алаи ко джюнгалипэ тхэдяс генэ екх, кай пханляс э Иоаннес андэ пханли. ");
INSERT INTO rmn_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Кана алаи о дюняс болдяспэс ко Иоанн, сас болдо ли о Исус, тай кана пал ко болдипэ Ов зборизэлас э Дэвлэса, пхутэрдило опрэ удар, ");
INSERT INTO rmn_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","тай опэр Лэстэ фулистино о Шужо Духос, фулистино андэ тэни, сар голуби. Тай опрал шунлило сэси: — Ту — Мо дэхло Чяво! Ту — Ми лош! ");
INSERT INTO rmn_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Э Исусески сас паш ко триянда брэш, кана Ов лиляс тэ керэл иргатлыки э Дэвлэски. Сар алаи тюшундиенас, Лэско дад сас о Иосиф, тай Лэски папудэс сас о Илий, ");
INSERT INTO rmn_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","о Матфат, о Левий, о Мелхий, о Ианнай, о Иосиф, ");
INSERT INTO rmn_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","о Маттафия, о Амос, о Наум, о Еслий, о Наггей, ");
INSERT INTO rmn_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","о Мааф, о Маттафия, о Шымьи, о Иосиф, о Иодай, ");
INSERT INTO rmn_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","о Иоханан, о Рисай, о Зоровавель, о Шэалтиил, о Нирий, ");
INSERT INTO rmn_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","о Мелхий, о Аддий, о Косам, о Элмадам, о Ир, ");
INSERT INTO rmn_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","о Иосий, о Элиезер, о Иорим, о Матфат, о Левий, ");
INSERT INTO rmn_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","о Симеон, о Иуда, о Иосиф, о Ионам, о Элиаким, ");
INSERT INTO rmn_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","о Мелеай, о Маинай, о Маттафай, о Нафан, о Давид, ");
INSERT INTO rmn_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","о Иессей, о Овид, о Боаз, о Сала, о Нахшон, ");
INSERT INTO rmn_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","о Аминадав, о Админ, о Арний, о Хецрон, о Парец, о Иуда, ");
INSERT INTO rmn_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","о Яков, о Исаак, о Авраам, о Терах, о Нахор, ");
INSERT INTO rmn_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","о Серуг, о Реу, о Пелег, о Евер, о Шэлах, ");
INSERT INTO rmn_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","о Каинан, о Арпахшад, о Сим, о Ной, о Ламех, ");
INSERT INTO rmn_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","о Мафусал, о Енох, о Иаред, о Малелеил, о Каинан, ");
INSERT INTO rmn_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","о Енос, о Сиф, о Адам, о Дэл. ");
INSERT INTO rmn_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","О Исус, пхэрдо о Шужо Духос, ало палэ катар Иордани, тай о Духос гелдяс Лэс ки ливади. ");
INSERT INTO rmn_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Отхэ Лэс саранда дес зумавэлас о Шэйтани. Алаи адава вахыти о Исус ништо на халас, ай дэчи бокхалило. ");
INSERT INTO rmn_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Озаман о Шэйтани пхэнляс Лэски: — Тэ сан Ту о Чяво э Дэвлэско, пхэн акалэ барэски тэ овэл манро. ");
INSERT INTO rmn_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","О Исус пхэнляс лэски: — Яздимэ си: «На екхе хамаса бэшэл мануш». ");
INSERT INTO rmn_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Андяс Лэс опэр учё тхан, о Шэйтани сикавдяс Лэски бут чяльти алаи о патишайлыки э пхуяко. ");
INSERT INTO rmn_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Тай пхэнляс Лэски: — Мэ кан дав Тут алаи лэнго барипэ тай о нами. Он динэ си мандэ, тай мэ дав лэн, кас мангав. ");
INSERT INTO rmn_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Акана, тэ бангёса ангал мандэ, алаи адава кан овэл Тинро. ");
INSERT INTO rmn_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","О Исус пхэнляс: — Яздимэ си: «Бангё ангал Сагбус, ангал Дэл тинрэстэ, тай кер иргатлыки Лэски екхески!» ");
INSERT INTO rmn_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Пал атхэ о Шэйтани андяс Лэс ко Иерусалими тай тхэдяс Лэс опэр сами учё тхан ки храмеско. — Тэ сан Ту о Чяво э Дэвлэско, — пхэнляс ов, — читут атхар тэлэ. ");
INSERT INTO rmn_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Вай яздимэ си: «Пэ миляикенги зораса кан пхэнэл тэ агорадиен Тут», ");
INSERT INTO rmn_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","тай «он кан гелэн Тут опэр вастэндэ, Ту тэ на чялавэс То пинро андэ бар». ");
INSERT INTO rmn_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","О Исус пхэнляс лэски: — Пхэнлило: «Ма зумав э Сагбус, э Дэвлэс тинрэс». ");
INSERT INTO rmn_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Кана о Шэйтани бытэрды тэ зумавэл, ов ачявдяс Лэс вахытески. ");
INSERT INTO rmn_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","О Исус ало палэ андэ Галилея, пхэрдо зор э Духоски. Лэстар шунлэ алаи одолэ пхуятэ. ");
INSERT INTO rmn_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ов сиклярэлас андэ синагогя, тай алаи махтадиенас Лэс. ");
INSERT INTO rmn_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Екхвар о Исус ало ко Назарет, андэ диз, катэ Ов барило, тай андэ суббота, сар екхараи Ов керэлас, гело андэ синагога. Отхэ о Исус ущино, тэ драпкерэл. ");
INSERT INTO rmn_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Лэс динэ книжка прароки Исаия. Ов пхутэрдяс ла тай аракхляс о тхан, катэ сас яздимэ: ");
INSERT INTO rmn_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«О Духос э Сагбуско опэр Мандэ, вай Ов макхляс Ман тэ пхукавав э чёрэнги о Лошано Габэри. Ов бичялдяс Ман тэ пхэнав э пханлэнги, кай лэн кан мукен, э корэнги, кай лэн кан дэн дикхипэ, тэ мукав э кхинэн, ");
INSERT INTO rmn_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","тэ пхэнав, кай ало вахыти э Сагбуски милако». ");
INSERT INTO rmn_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","О Исус пханляс э книжка, диняс ла ко иргати андэ синагога тай бэшло. О якха алаенги андэ синагога сас колимэна Лэстэ. ");
INSERT INTO rmn_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ов лиляс тэ пхэнэл: — Авдес, кана тумэ шунэнас, улэ адала зборэс э Яздимаски. ");
INSERT INTO rmn_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Алаи махтадиенас Лэс тай шаштиенас Лэски лаче зборэнги, савэ никлёнас андар Лэски мостэ. — Та со, Ов нанай о чяво э Иосифеско? — пхученас он. ");
INSERT INTO rmn_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","О Исус пхэнляс лэнги: — Тумэ Манги, гэлбэтэм, кан дэн мэ годятэ, сар пхэнлёлпэс: «Врачина! Аиндэрдие ту тут!» Тай кан пхэнэн Манги: «Амэ шунлям, кай Ту кердян бут чюдэс андэ Капернаум, кер ли атхэ, катэ Ту барилян, асавко». ");
INSERT INTO rmn_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ай пхэнав тумэнги о чячипэ, били екхе прарокес на гинэн андэ лэски дизатэ. ");
INSERT INTO rmn_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Пхэнав тумэнги чячипэ, андэ вахытя ки Илияски, кана трин тай екхпаш брэш на сас брышым тай опэр алаи ки пху сас бари бокх, андэ Израиль сас бут пхивля, ");
INSERT INTO rmn_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ай о Илия на сас бичялдо били екхатэ андар лэндэ, ами екх ки пхивли андэ Сарепта паш ко Сидон. ");
INSERT INTO rmn_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Бут сас андэ Израиль гералэ о вахытя кана сас о прароки Елисей, ай били екх андар лэндэ на сас шужардо, ами екх о сирийцы Нааман. ");
INSERT INTO rmn_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Алаи андэ синагога холясаилэ, кана шунлэ адава. ");
INSERT INTO rmn_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Он ущинэ, никалдэ э Исусес пал диз тай андэ Лэс ко чети ки гораско, опэр савэстэ сас тхэди э диз, тэ чен Лэс тэлэ. ");
INSERT INTO rmn_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ай о Исус накхло андар дюняс тай гело. ");
INSERT INTO rmn_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ов гело андэ галилейски диз ко Капернаум, тай андэ субботаки деса сиклярэлас отхэ дюняс. ");
INSERT INTO rmn_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","О мануша шаштиенас Лэски сикляримаски, вай андэ Лэски зборэндэ шунлёлас барипэ. ");
INSERT INTO rmn_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Андэ синагога сас мануш, андэ савэстэ сас о духос э бишужэ шэйтанеско, тай бирдэн ов диняс бэбэря: ");
INSERT INTO rmn_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","— А-а-а! Со Ту мангес амэндар, Исус андар Назарет? Ту алян, тэ мударэс амэн? Мэ джянав, Кон Ту! Ту — о Шужо э Дэвлэско! ");
INSERT INTO rmn_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","— Тэныкизэ! — холяса тхэдяс лэс о Исус. — Никлё андар лэстэ! Читяс э манушэс ангал алаендэ ки пху, о шэйтани никлисто андар лэстэ тай на дукхавдяс лэс. ");
INSERT INTO rmn_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Алаи шаштиенас тай пхэнэнас екх аврэски: — Со си адава? Асавке баримаса тай зораса Ов пхэнэл бишужэ духенги, тай он никлён! ");
INSERT INTO rmn_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","О зборэс катар Исус шунлёнас алаи ко тхана агорял. ");
INSERT INTO rmn_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Никлисто андар синагога, о Исус гело андэ кхер ко Симон. Ки сасуй ки Симонэски адава вахыти сас баро тхарипэ, э Исусес манглэ, тэ керэл лаки ярдыми. ");
INSERT INTO rmn_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Бангило опэр латэ, о Исус пхэнляс э тхаримаски тэ мукел э манушня, тай ов мукляс ла. Ой бирдэн ущини тай лиляс тэ тхэл лэнги конас. ");
INSERT INTO rmn_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Кана о кхам бэшло, алаи, кастэ сас насвалэ алаи э дукхенца, лилэ тэ анэн лэн ко Исус, тай Ов тхэлас опэр кажнестэ Пэ васта тай аиндэрдиелас лэн. ");
INSERT INTO rmn_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Аякхажэ ли о шэйтаня никлёнас андар бут мануша бэбэряса: — Ту — о Чяво э Дэвлэско! Ай о Исус на мукелас лэн тэ пхэнэн, вай он джянэнас, кай Ов — Христос. ");
INSERT INTO rmn_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Кана уло дес, о Исус никлисто андар диз тай гело андэ биманушэнго тхан. О мануша лилэ тэ родэн Лэс, тай кана аракхлэ, мангенас тэ ачёл лэндэ. ");
INSERT INTO rmn_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ай о Исус пхэнляс лэнги: — Мэ камэл тэ пхукавав Лошано Габэри катар Патишайлыки ки Дэвлэско ли аврэ дизэндэ, вай адалэски Мэ сом бичялдо. ");
INSERT INTO rmn_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Тай Ов сиклярэлас андэ синагогя ки Иудеяки. ");
INSERT INTO rmn_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Екхвар о Исус тэрдо сас паш ко бошы пани Генисарет, тай о дюняс тасавэнас Лэс агорял, тэ шунэн э збора э Дэвлэски. ");
INSERT INTO rmn_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","О Исус дикхляс паш ко пани дуй лодкес. О мануша, савэ астарэнас э мачен, никлистэ андар лодкес, чяйкадиенас пумарэ сеткес. ");
INSERT INTO rmn_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ов диняс андэ екх лодка, сави сас э Симонэски, тай мангляс лэс, тэ дэл джялдави залаг э лодкаса катар чети ки панеско. Дэчи Ов бэшло тай лиляс тэ сиклярэл э дюняс андар лодка. ");
INSERT INTO rmn_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Кана о Исус бытэрды тэ зборизэл, Ов пхэнляс э Симонэски: — Дэ джялдави э лодкаса ко хор тхан тай чи о сеткес, тэ астарэс мачен. ");
INSERT INTO rmn_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","О Симон пхэнляс: — Сикляримарина, амэ керасас пхари бути састи рат тай ништо на астардям, эй сар Ту аякха пхэнэс, кан чяв о сеткес. ");
INSERT INTO rmn_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Тай кана он кердэ адава, астардэ аборкха маче, кай о сеткес лилэ тэ пхаравдён. ");
INSERT INTO rmn_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Он вастэнца дэнас икос ярдымески э амалэн андар авэр лодка. Одола алэ, тай екхетханэ он пхэрдэ дуй лодкес аякха, кай о лодкес лилэ тэ бугулдиен. ");
INSERT INTO rmn_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Кана о Симон Пётар адава дикхляс, ов пэло ко чянга ки Исусески тай пхэнляс: — Наш мандар, Сагбуса, вай мэ мануш бэзяло! ");
INSERT INTO rmn_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ов пхэнляс аякха, кай лэс тай алаен, кон лэса астарэлас мачен, лиляс бари траш, кай дикхлэ аборкха маче. ");
INSERT INTO rmn_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Сас шаштимэна ли о амала э Симонэски: о Яков тай о Иоанн, о чявэ э Зеведеески. О Исус пхэнляс э Симонэски: — Ма траша, акана ту кан астарэс манушэн. ");
INSERT INTO rmn_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Тай никалдэ о лодкес опэр пху, он ачявдэ алаи тай гелэ пал Лэстэ. ");
INSERT INTO rmn_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Екхвар, кана о Исус сас андэ екхе дизатэ, Ов дикхляс манушэс, гералэс. Кана ов дикхляс э Исусес, пэло моса тэлэ тай лиляс лачес тэ мангел Лэс: — Сагбуса! Тэ мангес, Тутэ си зор тэ шужарэс ман. ");
INSERT INTO rmn_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","О Исус сидиняс по васт, колисаило лэстэ тай пхэнляс: — Мангав, шужо! Э гер бирдэн гили опрал лэстэ. ");
INSERT INTO rmn_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","О Исус пхэнляс лэски холяса никхаски адалэстар тэ на пхукавэл: — Джя, сикав тут э попазески тай ан курбанес, кай шужылян, сар адава пхэнляс о Маисей. Тай алаи мэ дикхен адава. ");
INSERT INTO rmn_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","О зборэс катар Исус шунлёнас май буглэс, тай бут мануша джянас Лэстэ, тэ шунэн Лэс тай тэ аиндиен катар дукха. ");
INSERT INTO rmn_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","О Исус бутвар джялас ки биманушэнги тхана тай зборизэлас э Дэвлэса. ");
INSERT INTO rmn_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Екхвар, кана о Исус сиклярэлас, пашэ бэшлэ сас о фарисея тай о сикляримаря э Тхэдимаски, савэ кидинэпэс андар алаи ко диза ки Галилеяки тай Иудеяки, тай андар Иерусалими. Э Исусеса сас э зор э Сагбуски, тэ аиндэрдиел э насвалэн. ");
INSERT INTO rmn_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Тай алэ мануша, анэнас опэр матрази астардэс, тай мангенас тэ гелэн лэс андэ кхер, тэ пашлярэн ангал Исус. ");
INSERT INTO rmn_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Тай андар дюняс он нащи адава кердэ, тай дэчи он ваздинэпэс опэр кхер, тай лилэ опрал э черепица, тай муклэ э насвалэс опэр матрази машкарэ ко кхер, доврус ангал Исус. ");
INSERT INTO rmn_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Кана о Исус дикхляс лэнго пакяпэ, Ов пхэнляс э насвалэски: — Амал, муклён туки тэ бэзя! ");
INSERT INTO rmn_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","О фарисея тай о сикляримаря э Тхэдимаски тюшундиенас андэ пэстэ: «Кон эси адава Мануш, Саво пхэнэл бэзялэ зборэс? Вай екх ко Дэл си зор, тэ мукел бэзя?» ");
INSERT INTO rmn_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Галило, состар он тюшундиен, о Исус пхэнляс лэнги: — Со тюшундима тумэндэ андэ ило? ");
INSERT INTO rmn_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Со локо — тэ пхэнэс: «Муклён туки тэ бэзя» — я тэ пхэнэс: «Ущи тай пхер?» ");
INSERT INTO rmn_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Тумэ тэ джянэн, кай ко Чяво ко Манушыкано си барипэ опэр пху тэ мукел э манушэнги о бэзя… Дэчи о Исус пхэнляс э астардэ манушэски: — Пхэнав туки, ущи, лэ то матрази тай джя кхерэ. ");
INSERT INTO rmn_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Одова бирдэн ангал алаенги якхендэ ущино, лиляс одова, опэр состэ сас пашло, гело кхерэ тай махтадиелас э Дэвлэс. ");
INSERT INTO rmn_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Алаи шаштылар, тай он махтадиенас э Дэвлэс. Тай трашавнэ, он пхэнэнас: — Барэ дилэс, савэ на овэн, амэ авдес дикхлям. ");
INSERT INTO rmn_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","О Исус никлисто андар адалэ кхерэстэ тай дикхляс кидимарес налогенгерэс, лэско нав Левий, бэшлэс ко тхан, кай кидэн о налогя. — Эла пал Мандэ, — пхэнляс лэски о Исус. ");
INSERT INTO rmn_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","О Левий ущино, ачявдяс алаи тай гело пал Лэстэ. ");
INSERT INTO rmn_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Дэчи о Левий кердяс пэстэ кхерэ баро мисяфирлыки э Исусески. Ко мисяфирлыки кидинэпэс бут кидимаря э налогенги тай авэр дюняс. Он сас пал конас екхетханэ э Исусеса. ");
INSERT INTO rmn_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","О фарисея тай о сикляримаря э Тхэдимаски холяса пхученас э сиклярдэн э Исусескерэн: — Соски тумэ хан тай пиен э кидимаренца э налогенгерэнца тай э бэзялэнца? ");
INSERT INTO rmn_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","О Исус пхэнляс лэнги: — На э састярдэнги камэл врачи, ами э насвалэнги. ");
INSERT INTO rmn_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Мэ алём тэ пхэнав на э чяченги, ами э бэзялэнги, тэ болдэнпэс катар бэзя. ");
INSERT INTO rmn_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Дэчи он пхэнлэ э Исусески: — О сиклярдэ э Иоаннески тай э фарисеенги бутвар астарэн оразас тай мангенпэс ко Дэл, ай Тэ сиклярдэ хан тай пиен. ");
INSERT INTO rmn_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","О Исус пхэнляс лэнги: — Та сар тэ тхэс э манушэн ко бияв, тэ астарэн оразас, кана си лэнца о джямутро? ");
INSERT INTO rmn_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Вай кан авэл вахыти, кана о джямутро кан линдёл лэндар, аки одола деса, он кан астарэн оразас. ");
INSERT INTO rmn_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ов генэ пхукавдяс лэнги пхукаипэ: — Никхон на сивэл котор пуранэ савутестэ, чиндо адалэски котор нэвэстар. Ов адава тэ керэла, ов ли о нэво савути кан аравэл, та ли ко пурано о котор на кан уйдиел. ");
INSERT INTO rmn_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Тай никхон на чёрэл о нэво винас андэ пуранэ моркхяки гонэ, вай о нэво винас кан пхаравэл лэн — тай кан чёрдёл, ай о гонэ кан пхаравдён. ");
INSERT INTO rmn_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","На, о нэво винас чёрэн андэ нэвэ моркхяки гонэ. ");
INSERT INTO rmn_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Тай никхон, кон пиел пурано винас, на кан мангел тэ пиел винас нэво, вай кан пхэнэл: «О пурано винас зиядэ». ");
INSERT INTO rmn_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Екхвар андэ суббота, кана о Исус накхелас андар ливадя, катэ барёлас о гив, Лэскерэ сиклярдэ чинэнас о гив, ронискерэнас лэс вастэнца тай ханас. ");
INSERT INTO rmn_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ай сарсавэ фарисея пхучлэ: — Соски тумэ керэн одова, со на муклёл тэ керэн андэ суббота? ");
INSERT INTO rmn_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","О Исус лэнги пхэнляс: — На драпкердянус тумэ одолэстар, со кердяс о Давид, кана ов тай кон сас лэса бокхалилэ? ");
INSERT INTO rmn_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ов диняс андэ кхер ки Дэвлэско, лиляс о манро, кай сас башладимэ э Дэвлэски, саво на муклёлас тэ хал никхон, екх о попазя, халяс, тай диняс лэс ли пэ манушэн. ");
INSERT INTO rmn_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Тай пхэнляс лэнги генэ: — О Чяво о Манушыкано си о Сагбус опэр суббота! ");
INSERT INTO rmn_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Авэр суббота о Исус диняс андэ синагога тай сиклярэлас. Отхэ сас мануш шуке чяче мусяса. ");
INSERT INTO rmn_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","О сикляримаря э Тхэдимаски тай о фарисея дикхенас пал Лэстэ, на кан аиндэрдиел Ов андэ суббота, вай родэнас, андар состэ тэ керэн дошалэс Лэс. ");
INSERT INTO rmn_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ай о Исус джянэлас, состар он тюшундиенас, тай пхэнляс э манушэски э шуке мусяса: — Ущи тай никлё ко машкар. Одова ущино тай никлисто ангал. ");
INSERT INTO rmn_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Дэчи о Исус пхэнляс лэнги: — Мэ пхучяв тумэн: со муклёлпэс тэ керэс андэ суббота, лачипэ я джюнгалипэ? Тэ кутардиес о бэшыпэ я тэ мударэс? ");
INSERT INTO rmn_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ов дикхляс карин лэндэ тай пхэнляс э манушэски: — Сидэ ти муси. Одова сидиняс, тай лэски муси састили. ");
INSERT INTO rmn_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ай он холясаилэ тай лилэ тэ зборизэн машкарэ пэстэ, со лэнги тэ керэн э Исусеса. ");
INSERT INTO rmn_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Одола деса о Исус ваздиняспэс опэр горас тай састи рат зборизэлас э Дэвлэса. ");
INSERT INTO rmn_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Кана уло дес, Ов диняс икос Пэ сиклярдэн тай лиляс андар лэндэ дэшудон, савэн тхэдяс апостолен: ");
INSERT INTO rmn_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","э Симонэс (савэс Ов тхэдяс Пётар), э пхралэс э Андреес, э Яковес, э Иоаннес, э Филиппес, э Варфоломеес, ");
INSERT INTO rmn_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","э Матфеес, э Фомас, э Яковес, э чявэс э Алфеескерэс, э Симонэс, савэски пхэнэнас Зилот, ");
INSERT INTO rmn_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","э Иудас, э чявэс э Яковескерэс, тай э Иудас Искариотес, саво уло пхукаимари. ");
INSERT INTO rmn_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","О Исус фулистино лэнца тэлэ опрал горас, опэр гортэ тханэстэ. Отхэ кидинэпэс бут Лэскерэ сиклярдэ тай бут мануша андар Иудея, Иерусалими тай андар диза ко Тир тай Сидон, савэ си паш ко бошы пани. ");
INSERT INTO rmn_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Он алэ тэ шунэн э Исусес тай тэ аиндиен катар насвалиматэс. Одола, кас кхинярэнас о бишужэ духя, ли одола улэ аиндимэна. ");
INSERT INTO rmn_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Алаи о дюняс мангенас тэ колизэн ко Исус, вай андар Лэстэ никлёлас зор, сави алаен аиндэрдиелас. ");
INSERT INTO rmn_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Дикхляс карин сиклярдэ, о Исус лиляс тэ пхэнэл: — Бахталэ тумэ, чёралэн, вай тумэндэ э Дэвлэско Патишайлыки. ");
INSERT INTO rmn_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Бахталэ тумэ, кон анкха бокхало, вай тумэ кан чялён. Бахталэ тумэ, кон анкха ровэл, вай тумэ кан асан. ");
INSERT INTO rmn_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Бахталэ тумэ, кана о мануша тумэн на дэхэн, кана тумэн кувдиен тай кушэн, кана калярэн тумаро нав андар Чяво ко Манушыкано. ");
INSERT INTO rmn_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Вай аякха керэнас э прарокенги о папудэс адалэ манушэнги. Одова дес лошаса чен тумэн, вай опрэ тумэн кан махтадиен! ");
INSERT INTO rmn_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ами касэвэти тумэнги, барвалалэн, вай тумэ анкха лилянус тумаро рагати. ");
INSERT INTO rmn_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Касэвэти тумэнги, кон анкха чяло, вай тумэ кан овэн бокхалэ. Касэвэти тумэнги, кон анкха асал, вай тумэ кан гаулизэн тай кан ровэн. ");
INSERT INTO rmn_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Касэвэти тумэнги, кана алаи махтадиен тумэн, вай аякха лэнги папудэс махтадиенас э хохавнэ прарокен. ");
INSERT INTO rmn_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","— Мэ пхэнав тумэнги, одолэнги, кон шунэл Ман: дэхэн тумарэ душманен, керэн лачипэ одолэнги, кон на дэхэл тумэн, ");
INSERT INTO rmn_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","манген алгышы одолэнги, кон арманя дэл тумэн, тай манген э Дэвлэс одолэндар, кон керэл тумэнги джюнгалипэ. ");
INSERT INTO rmn_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Одолэс, кон кан чялавэл ти екх фалка, тхэ ли авэр, ай одова, кон лэл тутар опрунэ савутя, мук мэ лэл ли о гад. ");
INSERT INTO rmn_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Кажнески, кон тумэндэ мангел, дэ; тай кон-то, кан лэл тинро, ма манг палэ. ");
INSERT INTO rmn_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Керэн э манушэнги аякха, сар тумэ манген, он тэ керэн тумэнги. ");
INSERT INTO rmn_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Тэ дэхэнa тумэ одолэн, кон дэхэл тумэн, андар состэ тумэн тэ махтадиен? Вай джи о бэзялэ дэхэн одолэн, кон лэн дэхэл. ");
INSERT INTO rmn_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Тэ керэн тумэ лачипэ одолэнги, кон керэн лачипэ тумэнги, андар состэ тумэн тэ махтадиен? Вай джи о бэзялэ керэн аякха. ");
INSERT INTO rmn_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Тэ дэн тумэ борджи екх одолэн, кастар ишандиен тэ лэн палэ, андар состэ тумэн тэ махтадиен? Вай джи о бэзялэ дэн борджи э бэзялэн, тай ишандиен, тэ лэн палэ оборкха, сокабор динэ. ");
INSERT INTO rmn_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ай тумэ дэхэн тумарэ душманен, керэн лэнги лачипэ тай дэн борджи, тай ма ишандиен палэ. Дэчи тумэн кан махтадиен опрэ, тай тумэ кан овэн о чявэ э Уче Дэвлэски. Вай Ов Сам лачё джи э налаченги тай э канлыдэнги. ");
INSERT INTO rmn_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Овэн милаки, сар милако тумаро Дад. ");
INSERT INTO rmn_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ма керэн цындос, тай тумэнги на кан керэн цындос. Ма керэн дошалэс, тай тумэн на кан керэн дошалэн. Апувикерэн, тай тумэн кан апувикерэн. ");
INSERT INTO rmn_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Дэн, тай ли тумэн кан дэн. Пхэрдо паи, тасавдо тай чёрдёл опрал чети, тумэнги кан чёрэн андэ тумарэ подятэ. Со паи дэн тумэ, асавко кан дэн ли тумэн. ");
INSERT INTO rmn_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","О Исус пхукавдяс лэнги акасавко пхукаипэ: — Кан гелэл о коро э корэс? Та со, он на кан пэрэн ли о дуй андэ хандаки? ");
INSERT INTO rmn_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","О сиклярдо нанай баро пэ сикляримарестар, ай кажни, кон алаи кан сиклёл, кан овэл сар по сикляримари. ");
INSERT INTO rmn_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Со ту дикхес карин тикноро кашторо андэ якх тэ пхралэстэ, кана андэ тинрятэ на дикхес бари ровли? ");
INSERT INTO rmn_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Сар ту пхэнэс тэ пхралэски: «Пхрала, дэ мэ кан никалав о кашторо андар тэ якхатэ», кана ту на дикхес бари ровли андэ тэ якхатэ? Домонго, никал ханик э бари ровли андар тэ якхатэ, ай дэчи лачес ту кан дикхес, сар тэ никалэс о кашторо андар якх тэ пхралэстэ. ");
INSERT INTO rmn_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","О лачё тэрэки на анэл кермалэ имиша, тай кермало тэрэки на анэл лаче имиша. ");
INSERT INTO rmn_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Кажни тэрэки галён катар имиша. Вай на кидэн опрал хлядяло тэрэки инжыри я опрал хлядяло кущёки дракх. ");
INSERT INTO rmn_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Андар ило, пхэрдо лачипэ, о лачё мануш никалэл лачипэ, ай о канлыс мануш никалэл канлыки андар ило, пхэрдо канлыки. Вай опэр чиб ки манушэски одова, соса си пхэрдо лэско ило. ");
INSERT INTO rmn_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Со тумэ дэн икос Ман: «Сагбуса, Сагбуса», ай на керэн, со Мэ пхэнав? ");
INSERT INTO rmn_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Мэ кан сикавав тумэнги, соски ушадиел кажни, кон авэл Мандэ, шунэл Мэ зборэс тай керэл лэн. ");
INSERT INTO rmn_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ов ушадиел одолэски, саво керэл кхер, саво хранляс хор хандаки тай тхэдяс о фундамент опэр барэстэ. Кана ваздиндило пани тай опэр кхер чёрдили диряв, ой на кхелавдяс лэс, вай ов сас зоралэс кердо. ");
INSERT INTO rmn_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ай одолэс, кон шунэл Мэ зборэс, ай на керэл лэн, ушадиел манушэски, саво тхэдяс кхер опэр пху бифундаментеско. Сар э диряв чёрдили опэр кхер, о хурдярдипэ, тай о пэрипэ лэско сас баро. ");
INSERT INTO rmn_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","О Исус бытэрды тэ пхэнэл э дюняски, гело ко Капернаум. ");
INSERT INTO rmn_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Отхэ екх баро, саво сас опэр шэлэ салдатендэ, лэстэ сас насвало тай пашло опэр мэримастэ иргати. Лэски сас бут багалыс адава лэско иргати. ");
INSERT INTO rmn_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Тай кана ов шунляс катар Исус, бичялдяс Лэстэ иудейски барэ манушэн, тэ манген тэ авэл тай тэ аиндэрдиел лэски иргатес. ");
INSERT INTO rmn_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","О барэ мануша алэ ко Исус тай лилэ бут лачес тэ манген Лэс: — Адава мануш керэл То ярдыми, ");
INSERT INTO rmn_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","вай ов дэхэл амарэ дюняс, тай адава ов кердяс амэнги синагога. ");
INSERT INTO rmn_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","О Исус гело лэнца. Ов пашолас ко кхер, тай бичялдяс о баро, саво сас опэр шэлэндэ, Лэстэ пэ амалэн, тэ пхэнэн: — Сагбуса, ма кхиняр Тут, вай мэ на керав одова, тэ дэс Ту андэ мэ кхерэстэ. ");
INSERT INTO rmn_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Мэ ли ман на гиндём, кай керав, тэ авав Тутэ. Ай пхэн екх збора, тай мо иргати кан аиндиел. ");
INSERT INTO rmn_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Вай ли опэр мандэ си барипэ, тай ли мандэ си, савэ тхэн кан ман салдатя. Мэ пхэнав екхески: «Джя!» — та`й ов джял, аврэски: «Эла!» — тай одова авэл. Иргатески минрэски пхэнав: «Кер акава!» — тай ов керэл. ");
INSERT INTO rmn_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","О Исус шунляс адава, шашты тай болдиняспэс ко дюняс, кай авэлас пал Лэстэ, пхэнляс: — Пхэнав тумэнги, кай джи андэ Израиль Мэ на аракхлём асавко пакяпэ. ");
INSERT INTO rmn_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Кана о бичялдэ алэ палэ андэ кхер, он дикхлэ о иргати аинды. ");
INSERT INTO rmn_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Набут пал отхэ о Исус гело андэ диз, кай бучёлас Наин. Лэса сас Лэскерэ сиклярдэ тай бут авэра мануша. ");
INSERT INTO rmn_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Кана Ов пашолас ки бар ки дизаки, андар латэ никалэнас мулэс, чявэс, саво сас екх ки дай, ай ой сас пхивли. Екхетханэ ласа андар диз никлёлас бут дюняс. ");
INSERT INTO rmn_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Кана о Сагбус дикхляс адалэ джювля, Ов аяды ла. — Ма ров, — пхэнляс Ов лаки. ");
INSERT INTO rmn_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Дэчи Ов пашыло тай колисаило ко гробос. Одола, кон гелэнас лэс, тэрдилэ, тай о Исус пхэнляс: — Тэрнагара, пхэнав туки: ущи! ");
INSERT INTO rmn_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","О муло бэшло тай лиляс тэ зборизэл, тай о Исус диняс лэс ки дай. ");
INSERT INTO rmn_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Алаен, кон отхэ сас, лиляс траш, тай о мануша махтадиенас э Дэвлэс: — Баро прароки уло машкарэ амэндэ! О Дэл ало Пэ дюнястэ! ");
INSERT INTO rmn_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","О зборэс катар Исус шунлилэ алаи ко Иудея тай агорял лаки пхуендэ. ");
INSERT INTO rmn_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","О сиклярдэ э Иоаннески пхукавдэ лэски алаестар, со уло. Тай дэчи о Иоанн диняс икос пэстэ дон андар лэндэ ");
INSERT INTO rmn_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","тай бичялдяс лэн ко Сагбус тэ пхучен: — Ту сан Одова, Кон камэл тэ авэл, я амэнги тэ ишандияс кас-то аврэс? ");
INSERT INTO rmn_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","О мурша алэ ко Исус тай пхэнлэ: — О Иоанн Болдимари бичялдяс амэн Тутэ тэ пхучяс: Ту сан Одова, Саво камэл тэ авэл, я амэнги тэ ишандияс кас-то аврэс? ");
INSERT INTO rmn_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","О Исус сами адава вахыти аиндэрды бутэ манушэн катар дукха тай катар насвалипэ, тай катар джюнгалэ духя, тай бутэ корэн башлады дикхипэ. ");
INSERT INTO rmn_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Тай Ов пхэнляс э бичялдэнги: — Джян, пхукавэн э Иоаннески одолэстар, со тумэ дикхлянус тай со шунлянус: о корэ дикхен, о банге пхерэн, о гералэ шужон, о кашуке шунэн, о мулэ дживиндён тай э чёрэнги пхукавдёл Лошано Габэри. ");
INSERT INTO rmn_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Бахтало одова, кон андар Мандэ на кан джял опрал дром! ");
INSERT INTO rmn_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Кана о бичялдэ э Иоаннески гелэ, о Исус лиляс тэ пхэнэл э дюняски катар Иоанн: — Со тумэ гелянусас тэ дикхен ки ливади? Карин камышы, кай кхелавдёл катар балвал? ");
INSERT INTO rmn_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Дэчи со тумэ гелянусас тэ дикхен? Манушэс, урявдэс андэ багалыдэс савутя? На, одола, кон урявэн багалыдэс савутя тай бэшэн андэ барвалимастэ, си андэ патишаитика кхера. ");
INSERT INTO rmn_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Дэчи со тумэ пхерэнас тэ дикхен? Э прарокес? Ва, тай пхэнав тумэнги, кай баро, ниш прароки. ");
INSERT INTO rmn_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ов одова, кастар яздимэ: «Аки, Мэ бичялав ангал Тутэ Мэ манушэс, саво кан гортярэл ангал Тутэ То дром». ");
INSERT INTO rmn_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Пхэнав тумэнги, машкарэ алаи, кай аракхлилэ джювлятар, нанай баро, ниш о Иоанн. Ами алаендар о тикно андэ Дэвлэско Патишайлыки — баро лэстар. ");
INSERT INTO rmn_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Тай алаи о дюняс, тай джи о кидимаря э налогенги, кай шунлэ о зборэс э Исусески, пакянилэ кай э Дэвлэско дром чячё, тай он лилэ о болдипэ э Иоаннеско. ");
INSERT INTO rmn_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","О фарисея тай о сикляримаря э Тхэдимаски на манглэ, тэ лэн болдипэ лэстар, динэ бутуря э Дэвлэско мангипэ. ");
INSERT INTO rmn_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","— Каса дэчи Манги тэ ушатэрдияв э манушэн адалэ вахытескерэн? — пхэнэлас о Исус. — Каски он ушадиен? ");
INSERT INTO rmn_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Он сар пуя, савэ бэшлэ ко майдани тай дэн бэбэря екх аврэски: «Амэ марасас тумэнги опэр дурули, ай тумэ на кхелэнас. Амэ дасас паромаски гиля, ай тумэ на ровэнас». ");
INSERT INTO rmn_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Дикхен, аки ало о Иоанн о Болдимари, на хал манро тай на пиел винас, тай тумэ пхэнэн: «Андэ лэстэ шэйтани» ");
INSERT INTO rmn_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ало о Чяво о Манушыкано, хал тай пиел, тай тумэ пхэнэн: «Аки о хавджяло тай о матимари, о амал э кидимаренго э налогенгерэнго тай э бэзялэнго». ");
INSERT INTO rmn_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Алаи о пуя э годявэримаски сикавэн, кай о годявэрипэ си чячё. ");
INSERT INTO rmn_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Екх андар фарисея диняс икос э Исусес пэстэ тэ хал. О Исус ало лэстэ андэ кхер тай лиляс тхан пал конас. ");
INSERT INTO rmn_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Адава вахыти екх джювли андар адалэ дизатэ, савя джянэнас, сар бэзяля, галили, кай о Исус хал андэ кхер ко фарисеи, андяс алебастрови кхоро, андэ савэстэ сас бут багалыс духыс. ");
INSERT INTO rmn_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Э джювли тэрдили палал ко чянга ки Исусески тай, ровэлас, чёрэлас Лэски пинрэндэ ався. Ой лиляс тэ кхосэл Лэски пинрэ пэ балэнца, чюмидэлас лэн тай макхелас духыса. ");
INSERT INTO rmn_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Кана о фарисеи, саво диняс икос э Исусес, дикхляс адава, ов тюшунды: «Тэ овэл би Адава Мануш чячес прароки, Ов би джянэлас, кай э джювли, сави Лэстэ колизэл, — бэзяли». ");
INSERT INTO rmn_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Дэчи о Исус пхэнляс лэски: — Симон, Мэ мангав туки со-то тэ пхэнав. — Пхэн, Сикляримарина, — пхэнляс ов. ");
INSERT INTO rmn_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","— Дуй мануша сас борджи екхе манушэски, — пхэнэлас о Исус. — О екх сас борджи панджшэл динаря, ай авэр — пэинда. ");
INSERT INTO rmn_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ли э екхески, ли аврэски на сас соса тэ дэн о борджи, тай мукляс о борджи лэнги э донги. Кон андар лэндэ, ту тюшундиес, кан дэхэл лэс бут? ");
INSERT INTO rmn_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","О Симон пхэнляс: — Мэ тюшундияв, одова, каски сас мукло о баро борджи. — Ту чячи тюшундын, — пхэнляс о Исус. ");
INSERT INTO rmn_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Тай болдиняспэс ки джювли, пхэнляс э Симонэски: — Ту дикхес адалэ джювля? Мэ алём андэ тэ кхерэстэ, тай ту на динян Ман джи пани, тэ халярав Мэ пинрэ, ай ой халярдяс Мэ пинрэ авсенца тай кхосляс пэ балэнца! ");
INSERT INTO rmn_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ту джи на чюмидын Ман, кана дикхлян, ай адая джювли одолэ вахытестар, сар Мэ алём андэ кхер, на тэрдёл тэ чюмидэл Мэ пинрэ. ");
INSERT INTO rmn_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ту на макхлян Манги Мо шэро олияса, ай ой макхляс багалыс духыса Мэ пинрэ. ");
INSERT INTO rmn_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Оничин Мэ пхэнав туки: лаки муклилэ бут бэзя, андар адалэстэ ой дэхляс лачес. Ай одова, савэски залаг муклило, дэхэл залаг. ");
INSERT INTO rmn_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Оничин пхэнляс о Исус э джювляки: — Тэ бэзя муклэ си. ");
INSERT INTO rmn_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ай авэра мануша, кай сас Лэса пал конас, лилэ тэ тюшундиен: «Кон Ов асавко, кай джи о бэзя мукел?» ");
INSERT INTO rmn_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","О Исус пхэнляс э джювляки: — То пакяпэ кутарды тут, джя лачимаса. ");
INSERT INTO rmn_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Пал атхэ о Исус пхерэлас андар диз андэ диз, андар гав андэ гав, пхукавэлас Лошано Габэри катар Дэвлэско Патишайлыки. Лэса сас о дэшудуй апостоля, ");
INSERT INTO rmn_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","тай сарсавэ джювля, савэ сас аиндимэна катар джюнгалэ духя тай катар дукха: э Мария, кай бучёлас Магдалина, андар савятэ никлистэ эфта шэйтаня, ");
INSERT INTO rmn_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","э Иоанна, э ромни э Хузаски, саво дикхел пал ко кхер ки Иродеско, э Сусанна тай бут авэра. Адала джювля керэнас ярдыми э Исусески тай Лэски сиклярдэнги андар одолэстэ, со сас лэндэ. ");
INSERT INTO rmn_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ко Исус генэ авэнас мануша андар бутэ дизэндэ. Тай кана кидиняспэс бут дюняс, Ов пхукавдяс лэнги пхукаипэ: ");
INSERT INTO rmn_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","— О мануш никлисто тэ чел андэ пху о гив. Тай кана ов чёрэлас лэс, сарсаво гив пэло паш ко дром, тай сас таптадимэ тай чюкудимэ э чирикленца. ");
INSERT INTO rmn_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Авэра пэлэ опрэ баруно тхан, тай, сар никлистэ, о ирнэкя шукилэ, кай на рэсэлас пани. ");
INSERT INTO rmn_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Авэра пэлэ андэ хлядя, тай кана о хлядя барилэ, пханлэ лэн. ");
INSERT INTO rmn_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Авэра пэлэ опэр лачи пху. Он никлистэ тай динэ шэлвар бут гив одолэстар, кай сас чито андэ пху. Пхукавдяс адава, о Исус лачес пхэнляс: — Кастэ си кана, тэ шунэн, мэ шунэл! ");
INSERT INTO rmn_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Кана о сиклярдэ пхучлэ, состар адава пхукаипэ, ");
INSERT INTO rmn_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","о Исус пхэнляс: — Тумэнги дино, тэ джянэн о гараипэ э Дэвлэски Патишайлыкеско, ай аврэнги алаи ачёл пхукаипэ, саво он на галён, «тэ дикхен, ай на дикхен, тэ шунэн, ай на галён». ");
INSERT INTO rmn_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Аки, со си адава пхукаипэ: гив — адава си э Дэвлэски збора. ");
INSERT INTO rmn_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Гив, кай пэло паш ко дром, — адава одола, кон шунэн э збора, ай дэчи авэл о Шэйтани тай чёрэл э збора андар лэнги илэндэ, тэ на пакян он тай тэ на овэн кутардимэна. ");
INSERT INTO rmn_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Гив, кай пэло опэр бар, — адава си одола, кон лошаса лэл э збора, кана шунэл ла. Ай лэндэ нанай корини. Ханик он пакян, ай кана авэл о вахыти о пхаро, он дурён. ");
INSERT INTO rmn_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Гив, кай пэло андэ хлядя, — адава си одола мануша, савэ шунэн э збора, ай вахытестар кажындесенги касэвэтя, барвалипэ тай соса манген тэ чялён, дурярэл лэн, тай о имишы лэнго на барёл. ");
INSERT INTO rmn_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Гив, кай пэло опэр лачи пху, — адава о мануша, савэ шунэн э збора, гаравэн ла андэ лачё тай андэ шужо ило тай анэн имиша андар одолэстэ, кай сас зоралэ андэ пакяпэ. ");
INSERT INTO rmn_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Никхон э тхарди лампа на тхэл тал какаи я тал кравати, ами тхэн опэр падставка, кон авэл тэ дикхел о ярэки. ");
INSERT INTO rmn_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Нанай ништо тэныки, со на овэлас би сикавдо, тай нанай ништо гаравдо, со на овэлас би джянло тай на никлисто аври. ");
INSERT INTO rmn_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Тай дикхен лачес, сар тумэ шунэн, вай кастэ си, одолэс кан овэл дино генэ, тай кастэ нанай, кан овэл линдо ли одова, со, сар лэски фаизэл, лэстэ си. ");
INSERT INTO rmn_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ко Исус алэ Лэски дай тай о пхрала, тай андар бут дюняс нащи пашылэ Лэстэ. ");
INSERT INTO rmn_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Кон-то Лэски пхэнляс: — Ти дай тай Тэ пхрала тэрдэ аври тай манген Тут тэ дикхен. ");
INSERT INTO rmn_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","О Исус пхэнляс лэнги: — Ми дай тай Мэ пхрала — одола, кон шунэл збора э Дэвлэски тай керэл ла. ");
INSERT INTO rmn_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Екхвар о Исус пхэнляс Пэ сиклярдэнги: — Кан накхас околэ ригатэ ки панеско. Он бэшлэ андэ лодка тай динэ джялдави. ");
INSERT INTO rmn_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Бискай он накхенас о пани, о Исус суто. Бирдэн опэр пани ваздиндили бари балвал, тай э лодка лиляс тэ учярэл о пани, аякха, кай он улэ андэ хатастэ. ");
INSERT INTO rmn_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Дэчи о сиклярдэ пашылэ ко Исус тай джянгавдэ Лэс, тай пхэнлэ: — Сикляримарина, Сикляримари, амэ бугулдияс! Тай джянгавдило о Исус тай тхэдяс тэ тэрдёл э балвал, тай о пани. Тай тэрдилэ э балвал тай о пани, тай уло тэныки. ");
INSERT INTO rmn_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","— Кай тумаро пакяпэ? — пхэнляс о Исус э сиклярдэнги. Он трашанилэ тай шаштимэна пхученас екх аврэстар: — Кон Ов, кай джи э балвалянги тай э панески пхэнэл, тай тхэн кан Лэс? ");
INSERT INTO rmn_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Он алэ андэ пху ки герасиненги, кай мамуй ки Галилея. ");
INSERT INTO rmn_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Кана о Исус никлисто андар лодка ки пху, Лэстэ мамуй никлисто мануш андар диз, андэ лэстэ сас шэйтаня. Опэр лэстэ чёктан на сас савутя, тай бэшэлас ов на андэ кхерэстэ, ами андэ склепя. ");
INSERT INTO rmn_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Кана ов дикхляс э Исусес, ов читяспэс Лэски чянгендэ тай диняс бэбэря алаи пэ сэсеса: — Со Ту мандар мангес, Исус, Чяво Уче Дэвлэско? Мангав Тут, ма кхиняр ман! ");
INSERT INTO rmn_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","— вай о Исус пхэнляс э бишужэ духоски тэ никлёл андар адалэ манушэстэ. О шэйтани екхараи джялас андэ адалэ манушэстэ, тай дэчи, джи кана лэс пхандэнас джянджирэнца о васта тай о чянга тай дикхенас пал лэстэ, ов чинэлас о джянджира, тай о шэйтани кувдиелас лэс ки биманушэнги тхана. ");
INSERT INTO rmn_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","О Исус пхучляс лэс: — Сар си то нав? — Легион, — пхэнляс одова, вай андэ лэстэ гелэ бут шэйтаня. ");
INSERT INTO rmn_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Тай он мангенас э Исусес тэ на бичялэл лэн андэ бездна. ");
INSERT INTO rmn_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Надур паш ко горас адава вахыти чярявэнаспэс бут чёчкадэс, тай о шэйтаня манглэ э Исусес тэ мукел лэн тэ джян андэ лэндэ. Ов мукляс. ");
INSERT INTO rmn_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Кана о шэйтаня никлистэ андар адалэ манушэстэ тай гелэ андэ чёчкадэс, алаи о чёчкадэс читэпэс опрал горас андэ пани, тай бугулдылар. ");
INSERT INTO rmn_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","О чёбаня э чёчкадэнги дикхлэ, со уло, прастанилэ тай пхукавдэ алаестар андэ диз тай агорял. ");
INSERT INTO rmn_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Кидинэпэс мануша тэ дикхен, со уло. Пашылэ ко Исус, он дикхлэ, кай о мануш, андар савэстэ никлистэ о шэйтаня, бэшло ко чянга ки Исусески, урявдо тай годявэр, тай трашанилэ. ");
INSERT INTO rmn_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Савэ дикхлэ, пхукавдэ лэнги одолэстар, сар сас аиндимэ андэ савэстэ сас шэйтаня. ");
INSERT INTO rmn_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Дэчи алаи, кон бэшэл андэ Герасински пху, лилэ тэ манген э Исусес тэ джял лэнги тханэндар, вай лачес трашанилэ. О Исус бэшло андэ лодка тай ало палэ. ");
INSERT INTO rmn_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","О мануш, андар савэстэ никлистэ о шэйтаня, мангелас, тэ лэл лэс Пэса, ай о Исус бичялдяс лэс тай пхэнляс: ");
INSERT INTO rmn_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","— Джя палэ кхерэ тай пхукав, со кердяс туки о Дэл. Одова гело, тай пхукавэлас алаи андэ диз одолэстар, со кердяс лэски о Исус. ");
INSERT INTO rmn_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Кана о Исус ало палэ, Лэс дэнас сэлями бут дюняс, вай алаи ишандиенас Лэс. ");
INSERT INTO rmn_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Лэстэ пашыло мануш, о нав савэско Иаир, саво сас баро мануш андэ синагога, тай пэло Лэски чянгендэ, лиляс тэ мангел э Исусес, тэ авэл лэстэ кхерэ: ");
INSERT INTO rmn_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","лэстэ сас екх чяй, савяки сас паш ко дэшудуй брэш, мэрэлас. О Исус гело отхэ машкарэ ко бут дюняс, савэ тасавэнас Лэс алаи катар рига. ");
INSERT INTO rmn_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Андэ дюняс сас джювли, дэшудуй брэш латэ чёрдёлас рат. Ой тхэдяс опэр врачя алаи, со сас латэ, ай никхон нащи ла аиндэрды. ");
INSERT INTO rmn_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ой пашыли палал ко Исус тай колисаили ко чети Лэски опрунэ савутендэ. Тай бирдэн тэрдило о рат. ");
INSERT INTO rmn_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","— Кон Мандэ колисаило? — пхучляс о Исус. Никхон на пхукавэласпэс, тай о Пётар пхэнляс: — Сикляримарина, агорял Тутэ бут дюняс та дэн бутуря алаи катар рига! ");
INSERT INTO rmn_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ай о Исус пхэнляс: — Кон-то Мандэ колисаило. Мэ тэнеса галилём, сар андар Мандэ никлисти зор. ");
INSERT INTO rmn_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Дэчи э джювли галили, кай нащи гаравдяспэс, пашыли, изравни, тай пэли ангал Исус. Ангал алаи ко дюняс ой пхукавдяс, соски ой Лэстэ колисаили тай сар бирдэн сас аиндимэ. ");
INSERT INTO rmn_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Дэчи о Исус пхэнляс лаки: — Ми чяй, то пакяпэ аиндэрды тут. Джя лачимаса. ");
INSERT INTO rmn_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","О Исус дага на бытэрды тэ зборизэл, кай ало мануш андар кхер ки барэско э синагогакерэско. — Ти чяй мули, — пхэнляс ов, — ма кхиняр генэ э Сикляримарес. ");
INSERT INTO rmn_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Шунляс адава, о Исус пхэнляс э Иаирески: — Ма траша, екх пакя, тай э чяёри кан овэл кутардимэ. ");
INSERT INTO rmn_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Кана Ов диняс андэ кхер, на мукляс никхон, тэ дэл Лэса, екх э Пётарэс, э Иоаннес, э Яковес тай э дадэс э дэяса э чяёрякерэн. ");
INSERT INTO rmn_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","О дюняс ровэнас тай гаулизэнас пал латэ. — Тэрдён тэ ровэн, — пхэнляс о Исус, — вай ой на мули, ами сути. ");
INSERT INTO rmn_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Он лилэ тэ асан Лэстар, вай джянэнас, кай э чяёри мули. ");
INSERT INTO rmn_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","О Исус лиляс ла вастэстар тай пхэнляс: — Пуёс, ущи! ");
INSERT INTO rmn_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","О духос э чяёряко ало палэ латэ, тай ой бирдэн ущини. О Исус пхэнляс, тэ дэн ла тэ хал. ");
INSERT INTO rmn_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","О дад тай э дай сас шаштимэна, ай о Исус тхэдяс лэн никхаски тэ на пхукавэн одолэстар, со уло. ");
INSERT INTO rmn_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Кидиняс екхетханэ э дэшудон апостолен, о Исус диняс лэн зор тай барипэ, тэ кувдиен алаи э шэйтанен тай тэ аиндэрдиен о дукха. ");
INSERT INTO rmn_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Пал отхэ Ов бичялдяс лэн, тэ пхукавэн катар Дэвлэско Патишайлыки тай тэ аиндэрдиен э насвалэн, ");
INSERT INTO rmn_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","пхэнляс лэнги: — Ништо ма лэн тумэнца ко дром: нэ ровли, нэ гоно, нэ манро, нэ ловэ, нэ дуйто савути. ");
INSERT INTO rmn_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Кана тумэ дэн андэ екх кхер, ачён отхэ, бискай на авэл вахыти тэ джян англэ. ");
INSERT INTO rmn_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ай катэ о мануша тумэн на кан мукен, дэчи джян андар одолэ дизатэ, кактиен о прахос опрал тумарэ пинрэндэ, тай он адава мэ дикхен. ");
INSERT INTO rmn_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","О апостоля гелэ ко дром, накхенас андар гава ко гава, пхукавэнас Лошано Габэри тай, кай сас, аиндэрдиенас э насвалэн. ");
INSERT INTO rmn_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Кана о сагбус-тетрархи Ирод шунляс адалэстар алаестар, ов на джянэлас, со тэ тюшундиел. Вай сарсавэ пхэнэнас, кай адава о Иоанн дживиндило андар мулэ, ");
INSERT INTO rmn_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","авэра — кай ало о Илия, май авэра — кай дживиндило екх андар пуранэ прарокя. ");
INSERT INTO rmn_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","О Ирод пхэнляс: — Э Иоаннески о шэро мэ чиндём, кон эси адава мануш, кастар манги пхукавэн? Тай родэлас тэ дикхел э Исусес. ");
INSERT INTO rmn_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","О апостоля алэ тай пхукавдэ э Исусески алаестар, со он кердэ. Дэчи Ов лиляс лэн Пэса, тай он гелэ коркорэ ки диз, кай бучёлас Вифсаида. ");
INSERT INTO rmn_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","О бут дюняс галилэ адалэстар тай гелэ пал Исус. Ов лошаса лэн лиляс тай пхэнэлас лэнги катар Дэвлэско Патишайлыки, тай генэ аиндэрдиелас одолэн, каски камэлас. ");
INSERT INTO rmn_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","О дес пашолас ки бэлвэль, тай о дэшудуй апостоля пашылэ ко Исус тай пхэнлэ: — Мук э дюняс, тэ джян он агорял ко диза тай андэ гава, тай тэ аракхен пэски, кай тэ совэн тай тэ хан, вай амэ атхэ сам ки ливадяко тхан. ");
INSERT INTO rmn_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","О Исус пхэнляс: — Тумэ дэн лэн тэ хан. Он пхэнлэ: — Ва вай амэндэ самой пандж манрэ тай дуй маче. Та со, амэнги тэ джяс, тэ кинас хапэ алаи адалэ манушэнги? ");
INSERT INTO rmn_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Отхэ сас паш ко пандж биня мурша. Ай о Исус пхэнляс э сиклярдэнги: — Бэшавэн э манушэн по пэинда. ");
INSERT INTO rmn_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","О сиклярдэ аякха да кердэ. Кана алаи бэшлэ, ");
INSERT INTO rmn_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","о Исус лиляс пандж манрэ тай дуй маче, ваздиняс Пэ якха опрэ тай алгышты о хапэ. Дэчи Ов лиляс тэ пхагерэл о манро тай о мачё, тай диняс лэн ко сиклярдэ, одола тэ дагытиен ко дюняс. ");
INSERT INTO rmn_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Алаи ханас тай чялилэ, тай ли кидинэ котора дэшудуй сэпэтя. ");
INSERT INTO rmn_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Екхвар, кана о Исус зборизэлас коркоро э Дэвлэса, тай надур Лэстар сас о сиклярдэ, Ов пхучляс лэн: — Сар кас гинэл Ман о дюняс? ");
INSERT INTO rmn_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Он пхэнлэ: — О Иоанн о Болдимари; авэра — о Илия; ай сарсавэ пхэнэн, кай о екх андар авэра пуранэ прарокя дживиндило. ");
INSERT INTO rmn_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","— Ами тумэ кас гинэн Ман? — пхучляс лэндар о Исус. — О Христос э Дэвлэско, — пхэнляс о Пётар. ");
INSERT INTO rmn_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ай о Исус пхэнляс лэнги, никхаски тэ на пхэнэн адалэстар, ");
INSERT INTO rmn_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","дэчи пхэнляс: — Э Чявэски э Манушыканэски камэл бут тэ сидэл касэвэти, тай тэ болдэнпэс Лэстар о барэ мануша, о барэ попазя тай о сикляримаря э Тхэдимаски. Ов кан овэл мудардо, ко трито дес кан дживиндёл. ");
INSERT INTO rmn_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Дэчи о Исус пхэнляс алаенги: — Кон мангел тэ джял пал Мандэ, мэ болдэлпэс пэстар, тай кажын дес лэл по хачи. Дэчи мэ джял пал Мандэ. ");
INSERT INTO rmn_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Вай одова, кон мангел тэ гаравэл по бэшыпэ, кан нашавэл лэс, ай кон кан нашавэл по бэшыпэ булуб Манги, одова кан кутардиел лэс. ");
INSERT INTO rmn_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Вай со файдас э манушэски, ов тэ лэла алаи о дюняс, ай ов кан нашавэл по бэшыпэ я кан керэл пэски джюнгалипэ? ");
INSERT INTO rmn_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Кон кан ладжял Мандар тай Мэ зборэндар, одолэстар кан ладжял ли о Чяво о Манушыкано, кана кан авэл андэ Пэ наместэ тай андэ нами ки Дадэско тай э шужэ миляикенго. ");
INSERT INTO rmn_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Пхэнав тумэнги чячес: сарсавэ андар тумэндэ, кай тэрдэ атхэ, на кан мэрэн, бискай на дикхен э Дэвлэско Патишайлыки. ");
INSERT INTO rmn_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Накхло паш ко охто дес пал адалэ зборэндэ. О Исус лиляс Пэса э Пётарэс, э Иоаннес тай э Яковес, ваздиняспэс опрэ горас, тэ зборизэл э Дэвлэса. ");
INSERT INTO rmn_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","О вахыти, кана зборизэлас э Дэвлэса, Лэско муй паровдило, ай о савутя улэ бут парнэ, сар страпи. ");
INSERT INTO rmn_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Тай аки, улэ дуй мануша тай лилэ тэ зборизэн э Исусеса, — адала сас о Маисей тай о Илия. ");
INSERT INTO rmn_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Алэ андэ нами, он пхэнэнас Лэски одолэстар, кай Ов камэл тэ джял андэ Иерусалими тай отхар тэ ачявэл адава дюняс. ");
INSERT INTO rmn_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ай э Пётарэс тай околэн, кон сас екхетханэ лэса, лиляс соипэ. Ай кана он джянгавдилэ, дикхлэ о нами э Исусеско тай э до муршэнго, кай тэрдэ сас пашэ Лэстэ. ");
INSERT INTO rmn_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Кана о мурша лилэ тэ джян, о Пётар пхэнляс э Исусески: — Сикляримарина, амэнги атхэ аякха лачё! Эла, амэ керас трин шалаша, екх Туки, екх э Маисеески тай екх э Илияски. Ов сам на джянэлас, со пхэнэл. ");
INSERT INTO rmn_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Кана ов дага пхэнэлас, сикавдило булути тай пханляс лэн. Кай улэ андэ булути, он бут трашанилэ. ");
INSERT INTO rmn_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ай андар булути шунлило сэси: — Адава Мо Чяво, Савэс Мэ тхэдём. Лэс шунэн! ");
INSERT INTO rmn_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Кана о сэси тэныкисаило, он дикхлэ э Исусес коркорэс. Он на зборизэнас адалэстар тай одова вахыти никхаски на пхукавэнас одолэстар, со дикхлэ. ");
INSERT INTO rmn_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Авэр дес, кана он фулистинэ опрал горас, э Исусес ишандиелас бут дюняс. ");
INSERT INTO rmn_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Тай екх мануш андар дюняс диняс бэбэря: — Сикляримарина, мангав Тут, дикх мэ чявэс! Ов мандэ екх. ");
INSERT INTO rmn_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Овэл, лэс лэл о духос, тай дэчи о чяворо бирдэн лэл тэ дэл бэбэря, лэс лэл изравни, аякха, кай лэстэ андар муй джял кубукя. О духос кхинярэл лэс тай пхарэс мукел лэс. ");
INSERT INTO rmn_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Мэ манглём Тэ сиклярдэн тэ кувдиен лэс, ай он нащи. ");
INSERT INTO rmn_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","— Бипакяки тай аравдо о дюняс адалэ вахытеско, — пхэнляс о Исус. — Сокабор Манги генэ тэ овав тумэнца тай тэ даяндияв тумэн? Ан тэ чявэс атхэ. ");
INSERT INTO rmn_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Кана о чяворо дага джялас, о шэйтани читяс лэс ки пху андэ израипэ. Ай о Исус пхэнляс зораса э бишужэ духоски тэ никлёл, аиндэрды э чяворэс, тай пал отхэ диняс лэс ко дад. ");
INSERT INTO rmn_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Алаи сас шаштимэна э баримаса э Дэвлэскерэса. Алаи шаштиенас адалэ дилэнги. О Исус пхэнляс Пэ сиклярдэнги: ");
INSERT INTO rmn_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","— Шунэн лачес, со Мэ кан пхэнав тумэнги анкха: генэ залаг, тай э Чявэс э Манушыканэс кан дэн андэ васта ки манушэнги. ");
INSERT INTO rmn_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ай он на галилэ, со Ов пхэнляс, лэндар адава сас гаравдо, ай тэ пхучен, со си Лэски збора, трашанас. ");
INSERT INTO rmn_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Машкарэ ко сиклярдэ уло ирищима одолэстар, кон андар лэндэ си баро. ");
INSERT INTO rmn_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","О Исус джянэлас, состар тюшундиен он андэ пумарэ илэндэ, лиляс тикнорэ пуёс тай тхэдяс лэс паш Пэстэ. ");
INSERT INTO rmn_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","— Кон булуб Манги гинэл акасавке пуёс, — пхэнляс о Исус, — одова гинэл ли Ман, ай кон гинэл Ман, одова гинэл ли одолэс, кон бичялдяс Ман. Кон машкарэ тумэндэ тикно алаендар, одова даси баро. ");
INSERT INTO rmn_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","О Иоанн пхэнляс Лэски: — Сикляримарина! Амэ дикхлям манушэс, саво Тэ навэса кувдиелас э шэйтанен, тай амэ тэрдярдям лэс, вай ов на джял пал Тутэ екхетханэ амэнца. ");
INSERT INTO rmn_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","— Ма тэрдярэн, — пхэнляс о Исус. — Кон нанай мамуй тумэндэ, одова си андар тумэндэ. ");
INSERT INTO rmn_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Кана э Исусески ало вахыти тэ овэл линдо опрэ, Ов гело ко Иерусалими. ");
INSERT INTO rmn_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ангал Пэстэ Ов бичялдяс манушэн, тай одола гелэ андэ екх самарянски диз, тэ гортярэн алаи, бискай Ов авэл. ");
INSERT INTO rmn_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ай о мануша одолэ гавэски на муклэ э Исусес, кай Ов джялас ко Иерусалими. ");
INSERT INTO rmn_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Дикхлэ адава, Лэскерэ сиклярдэ о Яков тай Иоанн пхэнлэ: — Сагбуса, мангес, амэ кан пхэнас э ягаки, тэ авэл опрал тай алаен лэн тэ тхарэл? ");
INSERT INTO rmn_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","56","Ай о Исус болдиняспэс, тэрдярдяс лэн. Тай он гелэ андэ аврэ дизатэ. ");
INSERT INTO rmn_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Кана он джянас опрэ дром, екх мануш пхэнляс э Исусески: — Мэ кан джяв пал Тутэ, кай би Ту тэ на джяс. ");
INSERT INTO rmn_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","О Исус пхэнляс: — Ко лисицэс си холя, ли ко чирикля опрунэндэ си гнездадэс, ай э Чявэски э Манушыканэски нанай кай По шэро тэ бангярэл. ");
INSERT INTO rmn_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Аврэ манушэски о Исус пхэнляс: — Эла пал Мандэ. Ай одова пхэнляс: — Сагбуса, мук ман ханик тэ джяв тэ пароскерав мэ дадэс. ");
INSERT INTO rmn_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","— Мук о мулэ он сам пароскерэн пумарэ мулэн, ай ту джя, пхукав э Дэвлэско Патишайлыки, — пхэнляс лэски о Исус. ");
INSERT INTO rmn_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Генэ екх мануш пхэнляс Лэски: — Мэ кан джяв пал Тутэ, Сагбуса, ай мук ман ханик тэ джяв тай тэ дикхав генэ екхвар мэ хорандас. ");
INSERT INTO rmn_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","О Исус пхэнляс: — Били екх мануш, саво тхэдяс васт опэр плуги тай дикхел палэ, на камэл э Дэвлэски Патишайлыкески. ");
INSERT INTO rmn_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Пал отхэ о Сагбус тхэдяс генэ эфтадэша сиклярдэн тай бичялдяс лэн по дон ангал Пэстэ андэ кажни дизатэ тай андэ кажни тханэстэ, кай Ов Сам кидэласпэс тэ авэл. ");
INSERT INTO rmn_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ов пхэнляс лэнги: — Бут гив си, тэ кидэн, ай о бутярнэ си залаг. Оничин манген э Сагбус э гивэскерэс, Ов тэ бичялэл бутярнэн тэ кидэн Лэско гив. ");
INSERT INTO rmn_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Джян! Аки, Мэ бичялав тумэн, сар бакрэн ко рува. ");
INSERT INTO rmn_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ма лэн тумэнца нэ киси, нэ гоно, нэ минидэс тай опэр дром никхас ма дэн сэлями. ");
INSERT INTO rmn_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Кана тумэ кан дэн андэ кхер, пхэнэн ханик: «Сэлями адалэ кхерэски». ");
INSERT INTO rmn_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Андэ одолэ кхерэстэ тэ бэшэл мануш сэлямеско, тумаро сэлями кан овэл опэр лэстэ, ай тэ на, ов кан авэл палэ тумэндэ. ");
INSERT INTO rmn_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ачён андэ адалэ кхерэстэ, хан, пиен одова, со тумэн кан дэн, вай о бутярно керэл пэ ловэ. Тай ма пхерэн катар кхер андэ кхер. ");
INSERT INTO rmn_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Тумэ тэ дэна андэ диз тай тумэн кан мукен, хан алаи, со тумэн кан дэн, ");
INSERT INTO rmn_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","аиндэрдиен лэнги насвалэн, савэ отхэ си, тай пхэнэн лэнги: «О Патишайлыки э Дэвлэско пашыло тумэндэ». ");
INSERT INTO rmn_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ай тэ дэна андэ савэ-то дизатэ тай отхэ тумэн на мукен, джян о улицэс адалэ дизаки тай пхэнэн: ");
INSERT INTO rmn_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","«Джи о прахос тумарэ дизако, кай колисаило амарэ пинрэндэ, амэ кактияс опэр тумэндэ. Ай тэ джянэн: о Патишайлыки э Дэвлэско пашэ!» ");
INSERT INTO rmn_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Пхэнав тумэнги, кай одова дес э Садомески кан овэл локес, ниш адалэ дизаки. ");
INSERT INTO rmn_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Касэвэти туки, Хоразин! Касэвэти туки, Вифсаидо! Вай андэ Тир тай андэ Сидон тэ овэлас кердэ одола чюдэс, со тумэндэ, он би чёктан урявэнас гонэ тай бэшэнас андэ прахос катар яг, тай ачявэнас пумарэ бэзя. ");
INSERT INTO rmn_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ай э Тирески тай э Сидонески кан овэл локо ко цындос, ниш тумэнги. ");
INSERT INTO rmn_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ли ту, Капернаум, тюшундиес, кай кан овэс ваздино джи опрэ? На, ту кан овэс чито андэ ади. ");
INSERT INTO rmn_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Кон шунэл тумэн, шунэл Ман, тай кон болдэлпэс тумэндар, болдэлпэс Мандар. Ай кон болдэлпэс Мандар, болдэлпэс Одолэстар, Кон бичялдяс Ман. ");
INSERT INTO rmn_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Эфтадэша сиклярдэ алэ палэ ко Исус лошанэ: — Сагбуса, — пхэнэнас он, — джи о шэйтаня тхэн кан амэн, кана амэ пхэнас лэнги Тэ навэса! ");
INSERT INTO rmn_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","О Исус пхэнляс: — Мэ дикхлём, сар о Сатанас пэло опрал, сар страпи! ");
INSERT INTO rmn_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Аки, Мэ динём тумэн барипэ тэ ущявэн опэр сапа тай опэр скарпионя, тай тэ пхагерэн алаи э зор э душманески. Тай ништо на кан анэл тумэнги джюнгалипэ. ");
INSERT INTO rmn_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ай лошазэн на одолэски, кай о духя тумэн шунэн, ами одолэски, кай тумарэ нава яздимэна опрэ. ");
INSERT INTO rmn_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Одова сагати о Исус лошасаило андэ Шужо Духос тай пхэнляс: — Мэ махтадияв Тут, Дадэ, Сагбуса опрунэско тай э пхуяко, андар одолэстэ, кай Ту гаравдян адава катар годявэра тай катар галярдэ, ай пхутэрдян адава пуенги. Ва, Дадэ, аякха Ту манглян! ");
INSERT INTO rmn_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","О Дад диняс Ман алаи. Никхон на джянэл, кон си о Чяво, екх о Дад, тай никхон на джянэл, кон си о Дад, екх о Чяво тай одолэски, каски о Чяво кан мангел тэ пхутрэл адава. ");
INSERT INTO rmn_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Дэчи Ов болдиняспэс карин Пэ сиклярдэндэ тай пхэнляс екх лэнги: — Бахталэ якха, кай дикхен одова, со тумэ дикхен. ");
INSERT INTO rmn_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Пхэнав тумэнги, кай бут прарокя тай патишая манглэ тэ дикхен одова, со тумэ дикхен, ай на дикхлэ, манглэ тэ шунэн одова, со тумэ шунэн, ай на шунлэ. ");
INSERT INTO rmn_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Екх сикляримари э Тхэдимаско ущино тай пхучляс ко Исус, тэ астарэл Лэс. — Сикляримарина, — пхучляс ов, — со манги тэ керав, тэ овэл мандэ бибытимаско бэшыпэ? ");
INSERT INTO rmn_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","— Ай со пхэнлёлпэс андэ Тхэдипэ? — пхучляс о Исус. — Со ту отхэ драпкерэс? ");
INSERT INTO rmn_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Одова пхэнляс: — Дэх э Сагбус, Дэвлэс тинрэс, алаи тэ илэса тай алаи тэ бэшымаса, алаи тэ зораса тай алаи тэ годяса, тай дэх тэ комшус, сар ту дэхэс тут. ");
INSERT INTO rmn_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","— Чячи ту пхэнлян, — пхэнляс лэски о Исус. — Кер аякха, тай ли ту кан бэшэс. ");
INSERT INTO rmn_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ай ов мангляс тэ сикавэл по чячипэ тай пхучляс э Исусес: — Ай кон манги о комшус? ");
INSERT INTO rmn_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","О Исус пхэнляс лэски: — Екх мануш авэлас андар Иерусалими андэ Иерихони. Опэр дром опэр лэстэ пэлэ прахаря, савэ нангярдэ лэс, мардэ аякха лачес, кай сас опэр мэримастэ, тай гелэ. ");
INSERT INTO rmn_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Уло аякха, одолэ дромэстар накхелас попази, дикхляс адалэ манушэс тай накхло пашал аврэ ригатар ки дромэско. ");
INSERT INTO rmn_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Аякха кердяс ли о левити: пашыло одолэ тханэстэ, дикхляс э мардэс тай накхло пашал лэстэ. ");
INSERT INTO rmn_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ай аки одолэ тханэстэ, катэ ов пашло, пашыло кай накхелас пашал самаряни. Ов дикхляс тай аяды лэс. ");
INSERT INTO rmn_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ов пашыло, халярдяс лэски дукхавнэ тхана олияса тай винаса, тай пханляс лэн. Дэчи ов бэшавдяс э мардэс опэр пэ джёрэстэ, андяс лэс андэ гастиница тай отхэ генэ дикхелас пал лэстэ. ");
INSERT INTO rmn_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Авэр дес ов диняс э сагбус э гастиницакерэс дуй динаря тай пхэнляс: «Дикх пал лэстэ, ай тэ тхэса бут, мэ кан дав тут, кана кан авав». ");
INSERT INTO rmn_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Кон андар адалэ тринэндэ сас, сар тюшундиес, комшус э манушэски, савэс мардэ о прахаря? ");
INSERT INTO rmn_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","О сикляримари э Тхэдимаско пхэнляс: — Одова, кон аяды лэс. Дэчи о Исус пхэнляс лэски: — Джя тай кер ли ту аякха. ");
INSERT INTO rmn_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Опэр дром о Исус э сиклярдэнца ало андэ екхе дизатэ. Отхэ джювли, кай бучёлас Марфа, диняс икос Лэс андэ пэ кхерэстэ. ");
INSERT INTO rmn_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Латэ сас пхэн, сави бучёлас Мария. Э Мария бэшли сас ко пинрэ ки Сагбуски тай шунэлас, со Ов пхэнэлас. ");
INSERT INTO rmn_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Э Марфа сас андэ хэзмэти ки таимаско. Ой пашыли ко Исус тай пхэнляс: — Сагбуса, Туки нанай дила одолэстэ, кай ми пхэн ачявдяс алаи о хэзмэти опэр мандэ коркорятэ? Пхэн лаки, тэ керэл ярдыми манги! ");
INSERT INTO rmn_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","— Марфо, Марфо, — пхэнляс о Сагбус, — ту касэвэти керэс бутэски, ");
INSERT INTO rmn_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ай камэл вай екх. Э Мария кердяс зиядэ, тай адава латар на кан линдёл. ");
INSERT INTO rmn_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Екхвар о Исус пхэнэлас э Дэвлэски, тай кана Ов бытэрды, екх андар сиклярдэ мангляс Лэс: — Сагбуса, сикляр амэн, со тэ пхэнас э Дэвлэски, сар о Иоанн сиклярдяс пэ сиклярдэн. ");
INSERT INTO rmn_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ов пхэнляс лэнги: — Кана пхэнэн э Дэвлэски, пхэнэн акаякха: Дадэ, кажни мэ гинэл То шужо нав! Мэ авэл То Патишайлыки! ");
INSERT INTO rmn_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Дэ амэн кажын дес амаро авдесутно манро. ");
INSERT INTO rmn_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Тай апувикер амарэ бэзя, вай ли амэ апувикерас кажнески, кон амэнги борджи. Ма дэ амэн тэ джяс катар дром. ");
INSERT INTO rmn_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Дэчи о Исус пхэнляс лэнги: — Тюшундиен, екх андар тумэндэ кан авэл рати пэ амалэстэ тай кан пхэнэл: «Амал, дэ борджи ман трин питэс. ");
INSERT INTO rmn_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Мандэ опрал дром ало амал, тай мандэ ништо нанай лэс тэ дав». ");
INSERT INTO rmn_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ай одова, сас андэ кхер, кан пхэнэл: «Ма лищие мандэ. О удар вай пханло, о пуя минрэ манца андэ тхан, нащи мэ анкха тэ ущяв тай тэ дав тут манро». ");
INSERT INTO rmn_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Пхэнав тумэнги, кай джи ов тэ на ущела тай тэ на дэл лэс, сар амалэс, ов кан ущел тай кан дэл лэс, сокабор камэл, кай одова на тэрдёл тэ мангел. ");
INSERT INTO rmn_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Оничин Мэ пхэнав тумэнги: манген — тай о Дэл тумэн кан дэл, родэн — тай кан аракхен, марэн — тай о Дэл тумэнги кан пхутрэл. ");
INSERT INTO rmn_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Вай кажни, кон мангел, одова диндёл, кон родэл, одова аракхел, тай одолэски, кон марэл, о Дэл пхутрэл. ");
INSERT INTO rmn_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Си машкарэ тумэндэ асавко дад, саво кан дэл пэ чявэс сапэс, кана кан мангел лэстэ мачес? ");
INSERT INTO rmn_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Я одова тэ мангела ванро, кан дэл лэс скарпионес? ");
INSERT INTO rmn_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Тай тумэ, кана холямэна, галён тэ дэн тумарэ пуен лачипэ, тай май зиядэ опрал о Дад кан дэл э Шужэ Духос одолэн, кон мангел Лэстэ! ");
INSERT INTO rmn_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Екхвар о Исус кувды э шэйтанес э сакавимаскерэс. Тай кана о шэйтани никлисто, о мануш, саво сас сакави, зборисаило. О мануша шаштиенас. ");
INSERT INTO rmn_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ай сарсавэ пхэнэнас: — Ов кувдиел э шэйтанен э Веельзевулески зораса, о баро опэр бишужэ. ");
INSERT INTO rmn_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Авэра зумавэнас э Исусес тай мангенас, тэ сикавэл лэнги чюда опрал. ");
INSERT INTO rmn_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ай о Исус джянэлас, со тюшундиен, пхэнляс лэнги: — Вэрсаво патишайлыки, кай паляштыпэс, кан овэл чючё, тай о кхер, катэ си чингара, кан хурдёл. ");
INSERT INTO rmn_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Тай о Сатанас тэ марэлпэс мамуй пэстэ, сар кан тэрдёл лэско патишайлыки? Ай тумэ пхэнэн, кай Мэ кувдияв э шэйтанен э Веельзевулески зораса. ");
INSERT INTO rmn_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Мэ тэ кувдияв э шэйтанен э Веельзевулески зораса, дэчи со зораса кувдиен лэн тумарэ чявэ? Оничин он кан керэн тумэнги цындос. ");
INSERT INTO rmn_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ай Мэ тэ кувдияв э шэйтанен э Дэвлэски наеса, адава сикавэл, кай о Патишайлыки э Дэвлэско ало тумэндэ. ");
INSERT INTO rmn_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Кана о зорало бутэ мултукенца мануш дикхел пал пэ кхерэстэ, лэско мангин кан овэл састо. ");
INSERT INTO rmn_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ай кон-то май зорало тэ пэрэла опэр лэстэ тай тэ марэла лэс, ов кан лэл о мултукя, савэнги ишандиелас о сагбус, тай кан палящиел, со лиляс. ");
INSERT INTO rmn_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Кон нанай Манца, одова си мамуй Мандэ, тай кон на кидэл Манца, одова чёрэл. ");
INSERT INTO rmn_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Кана о бишужо духос никлёл андар мануш, ов пхерэл ки бипаненги тхана, родэл тхан тэ рагантиел, тай на аракхел лэс. Дэчи ов пхэнэл: «Тэ джяв мэ андэ кхер, андар савэстэ никлистём». ");
INSERT INTO rmn_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Кана ов авэл палэ, аракхел о кхер шужэс шулавдо тай кидино. ");
INSERT INTO rmn_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Дэчи ов джял тай лэл эфта аврэ духен, май канлыдэн, ниш ов сам, тай он авэн тай бэшэн отхэ. Тай адава э манушэски май пхаро одолэстар, ниш кай сас буруни. ");
INSERT INTO rmn_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","О Исус дага пхэнэлас, кана екх джювли андар дюняс диняс бэбэря: — Бахтали си одоя дай, кай пхеравэлас андэ пэстэ Тут тай хавдярдяс! ");
INSERT INTO rmn_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","О Исус пхэнляс: — Бахталэ одола, кон шунэн э збора э Дэвлэски тай керэн ла. ");
INSERT INTO rmn_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Кана о мануша кидиндилэ май бут, о Исус лиляс тэ пхэнэл: — О дюняс адалэ вахытеско — канлыс. Ов родэл сикаипэ, ай лэски на кан овэл сикавдо нисаво сикаипэ, екх о сикаипэ э Ионеско. ");
INSERT INTO rmn_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Тай сар о Иона уло сикаипэ э дюняски, кай бэшэлас Ниневия, аякха о Чяво о Манушыкано кан овэл сикаипэ э дюняски адалэ вахытескерэски. ");
INSERT INTO rmn_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Э патишаинка катар юги кан дживиндёл ко цындос э дюняса адалэ вахытескерэса тай кан керэл цындос лэнги, вай ой али аврэ четестар ки дюняско тэ шунэл о годявэрипэ э Саламонеско. Ай анкха тумэнца Одова, Саво баро си катар Саламон. ");
INSERT INTO rmn_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","О мануша, кай бэшэнас Ниневия, кан дживиндён ко цындос екхетханэ э дюняса адалэ вахытескерэса тай кан керэн лэн дошалэн, вай он ачявдэ пумарэ бэзя одолэстар, кай пхукавдяс лэнги о Иона. Ай анкха си тумэнца Одова, Саво баро катар Иона. ");
INSERT INTO rmn_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Никхон, тхарди лампа, на тхэл ла андэ погриби я тал кумани. Ами ла тхэн опэр падставка, кон авэл тэ дикхел о ярэки. ");
INSERT INTO rmn_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ти якх си лампа тэ тэнески. Кана ти якх шужы, дэчи ли алаи то тэни пхэрдо ярэки. Ай кана джюнгали ти якх, дэчи алаи то тэни тэмина. ");
INSERT INTO rmn_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Дикх, одова ярэки, саво андэ тутэ, мэ на овэл тэмина. ");
INSERT INTO rmn_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Тэ си алаи то тэни пхэрдо ярэки тай андэ лэстэ нанай тэминако котор, ту алаи кан овэс пхэрдо ярэки, сар о ярэки э страпяко овэл опэр тутэ. ");
INSERT INTO rmn_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Кана о Исус аякха пхэнэлас, екх фарисеи диняс икос Лэс пэстэ тэ хал лэса. О Исус ало тай лиляс тхан пал конас. ");
INSERT INTO rmn_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","О фарисеи дикхляс, кай о Исус на халярдяспэс ангал хапэ, тай лачес шашты. ");
INSERT INTO rmn_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ай о Сагбус пхэнляс лэски: — Аки тумэ, фарисея, шужарэн кадея тай о тарелкес аврял, ай андар тумэ пхэрдэ бичялипэ тай джюнгалипэ. ");
INSERT INTO rmn_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Дэнилалэн! Та со, Одова, Кон кердяс аврял, на кердяс ли андар? ");
INSERT INTO rmn_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Дэн э чёрэн одолэстар, со си тумэндэ, дэчи алаи тумэнги кан овэл шужо. ");
INSERT INTO rmn_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Касэвэти тумэнги, фарисея! Тумэ дэн дэшто паи катар мята, катар рута тай аврэ чярендар, ай бристэн о цындос тай о дэхыпэ э Дэвлэско. Ли одова камэл тэ керэн, ли авэр тэ на ачявэн. ");
INSERT INTO rmn_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Касэвэти тумэнги, фарисея! Тумэ дэхэн тэ лэн лаче тхана андэ синагогя тай дэхэн, кана тумэн дэн сэлями андэ базаря. ");
INSERT INTO rmn_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Касэвэти тумэнги! Тумэ ушадиен э гробенги, савэ на дикхиндён. О мануша пхерэн опрал тай на джянэн. ");
INSERT INTO rmn_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Екх андар сикляримаря э Тхэдимаско пхэнляс Лэски: — Сикляримарина, кана Ту адава пхэнэс, Ту ли амэн дэс тэлэ. ");
INSERT INTO rmn_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","О Исус пхэнляс: — Касэвэти ли тумэнги, сикляримаря э Тхэдимаски! Тумэ чен опэр мануша пхарипэ, саво нащи гелэс, ай тумэ били екхе наеса на астарэн лэс. ");
INSERT INTO rmn_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Касэвэти тумэнги! Тумэ керэн памятникя э прарокенги, савэн мудардэ тумарэ дада. ");
INSERT INTO rmn_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Адалэса тумэ сикавэн, кай тумарэ дада лачё керэнас: одола мударэнас э прарокен, ай тумэ керэн лэнги памятникя. ");
INSERT INTO rmn_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Оничин э Дэвлэско годявэрипэ пхэнляс: «Мэ кан бичялав лэндэ прарокен тай апостолен, ай он э сарсавэн андар лэндэ кан мударэн, ай аврэн кан кувдиен». ");
INSERT INTO rmn_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Оничин о дюняс адалэ вахытеско кан покинэл андар рат алаи ки прарокенго, кай чёрдило, сар ули э пху, ");
INSERT INTO rmn_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","катар рат ки Авелеско тай джи ко рат ки Захариеско, э мудардэс машкарэ ко алтари тай ко храми. Ва, пхэнав тумэнги, дюняс адалэ вахытеско кан покинэл андар алаи. ");
INSERT INTO rmn_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Касэвэти тумэнги, сикляримаря э Тхэдимаски! Тумэ лилянус тумэнги о ключи катар джянлипэ. Ай тумэ сам на динянус андэ, тай одола, кон дэлас андэ, тумэ на муклянус лэн. ");
INSERT INTO rmn_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Кана о Исус никлисто андар кхер, о сикляримаря э Тхэдимаски тай о фарисея холинаса бут кхинярэнас Лэс пхучимаса. ");
INSERT INTO rmn_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Он тхэнас Лэски лавушкес, мангенас тэ астарэн збораса. ");
INSERT INTO rmn_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Одова вахыти кидинэпэс бут биня дюняс, тай о мануша тасавэнас екх аврэс. О Исус лиляс тэ пхэнэл ханик Пэ сиклярдэнги: — Трашан катар фарисейски ушлярипэ, самким катар домонги. ");
INSERT INTO rmn_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Нанай ништо гаравдо, со на кан пхутэрдёлас би, ли нанай ништо биджянло, со на кан овэл джянло. ");
INSERT INTO rmn_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Оничин одова, со тумэ пхэнэн тэминако, кан шунлёл ангал ярэки ки десеско, тай со пхэнлянус тэныки андэ кхер, кан овэл пхэнло опрал кхера. ");
INSERT INTO rmn_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Мэ пхэнав тумэнги, Мэ амала: ма трашан одолэндар, кон мударэл о тэни, ай дэчи нащи керэл ништо. ");
INSERT INTO rmn_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Мэ кан пхэнав тумэнги, Кастар тэ трашан: трашан Одолэстар, Кон мудардяс, Лэстэ си барипэ тэ чел андэ ягаки геена. Ва, пхэнав тумэнги, Лэстар трашан. ");
INSERT INTO rmn_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Та со, на бикнэн пандж чирикля до хурдэ капикенги? Тай били екх андар лэндэ нанай бристэрно э Дэвлэса. ");
INSERT INTO rmn_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ай тумэндэ джи о бала алаи опэр шэро гиндэ! Ма трашан — тумэ багалыдэс бутэ чириклендар! ");
INSERT INTO rmn_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Пхэнав тумэнги: кажнес, кон кан пхэнэл ангал мануша, кай джянэл Ман, о Чяво о Манушыкано кан пхэнэл ангал Дэвлэски миляикя, кай джянэл лэс, ");
INSERT INTO rmn_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ай кон кан пхэнэл ангал мануша, кай на джянэл Ман, ли Мэ кан пхэнав ангал Дэвлэски миляикя, кай на джянав лэс. ");
INSERT INTO rmn_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Тэ пхэнэла саво-то мануш мамуй ко Чяво ко Манушыкано, о Дэл кан мукел лэски адала бэзя, ай одова, кон кушэл о Шужо Духос, о Дэл на кан мукел адала бэзя. ");
INSERT INTO rmn_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Кана тумэн кан анэн ко цындос андэ синагогя, ко сагбудэс тай кастэ си барипэ, ма трашан одолэстар, со зборэс тэ пхэнэн мамуй, ");
INSERT INTO rmn_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","вай о Шужо Духос одова сагати кан сиклярэл тумэн, со тумэнги тэ пхэнэн. ");
INSERT INTO rmn_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Кон-то андар дюняс пхэнляс э Исусески: — Сикляримарина, пхэн мэ пхралэски, ов тэ палящиел манца, со ачило катар дад. ");
INSERT INTO rmn_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","О Исус пхэнляс: — Амал, кон Ман тхэдяс тэ овав цындомари я машкарэ тумэндэ тэ палящияв? ");
INSERT INTO rmn_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Тай Ов пхэнляс лэнги: — Сакёвэн, нашэн бичялимастар. О мангин э манушэско на сикавэл о барвалипэ э бэшымаско. ");
INSERT INTO rmn_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Озаман Ов пхукавдяс лэнги пхукаипэ: — Пху екхе барвалэ манушэски андяс лэски лаче имиша. ");
INSERT INTO rmn_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","«Со мэ тэ керав? Манги нанай кай тхав алаи о кидинэ имиша», — тюшунды ов. ");
INSERT INTO rmn_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","«Аки со мэ кан керав, — гиндяс ов озаман, — мэ кан пхагерав мэ араня тай кан керав барэ, тай кан тхав андэ мо гив тай авэр мангин. ");
INSERT INTO rmn_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Дэчи мэ кан пхэнав мэ манги: \"Акана тутэ си бут мангин бутэ брэшэнги. Рагантие, ха, пи, лошазэ\"». ");
INSERT INTO rmn_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ай о Дэл пхэнляс лэски: «Дэнлорэя! Авдес рати то бэшыпэ кан лэн тутар. Каски кан ачёл алаи, со ту газырлыдын?» ");
INSERT INTO rmn_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Аякха кан овэл кажнеса, кон кидэл барвалипэ пэски, ай на барвалёл андэ Дэл. ");
INSERT INTO rmn_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Дэчи о Исус пхэнляс Пэ сиклярдэнги: — Оничин Мэ пхэнав тумэнги: ма керэн касэвэти тумарэ бэшымаски, со тэ хан, я тумарэ тэнески, со тэ урявэн. ");
INSERT INTO rmn_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Вай о бэшыпэ багалыс хамастар, ли о тэни багалыс савутендар. ");
INSERT INTO rmn_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Дикхен карин каргэс, он на барярэн ли на кидэн, лэндэ нанай араня, ай о Дэл хавдярэл лэн. Сокаборэски тумэ багалыдэс адалэ чириклендар! ");
INSERT INTO rmn_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Тай кон андар тумэндэ, касэвэтлыс, кан дулгярэл пэски бэшыпэ хоч екхе сагатески? ");
INSERT INTO rmn_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Тэ нащи керэн тумэ джи адава, соски дэчи тумэнги касэвэтлыдэс тэ овэн аврэстар? ");
INSERT INTO rmn_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Тюшундиен одолэстар, сар барён э ливадяки лулудя. Он бути на керэн тай на сивэн, ай пхэнав тумэнги, кай джи о Саламон андэ алаи пэ баримастэ на урявэласпэс аякха, сар кажни андар лэндэ. ");
INSERT INTO rmn_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ай о Дэл аякха тэ урявэл э чяр ки ливади, сави авдес си, ай рано кан овэл чити андэ пэчи, тай на кан урявэл Ов ли тумэн, залагпакяки? ");
INSERT INTO rmn_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ма родэн, со тумэнги тэ хан я со тэ пиен, ма керэн касэвэти адалэстар. ");
INSERT INTO rmn_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Адава родэн о мануша адалэ дюняско, ай тумаро Дад джянэл, кай тумэнги камэл адава. ");
INSERT INTO rmn_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Родэн зиядэ Лэско Патишайлыки, тай ли адава кан овэл дино тумэн. ");
INSERT INTO rmn_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ма траша, тикни атара, вай тумаро Дад мангляс тэ дэл тумэн о Патишайлыки! ");
INSERT INTO rmn_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Бикнэн тумаро мангин тай дагытиен ко чёрэ. Лэн тумэнги асавке кися, савэ на пуранён, тэ кидэн барвалипэ опрэ, саво на тикнёл, катэ о чёр лэндэ на кан пашол, нэ моли лэн на кан хал. ");
INSERT INTO rmn_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Вай катэ си тумаро барвалипэ, отхэ кан овэл ли тумаро ило. ");
INSERT INTO rmn_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Овэн екхараи газыря: о савутя пханлэ, э лампа тхарди, ");
INSERT INTO rmn_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","сар одолэ иргатендэ, кай ишандиен пэ сагбус тэ авэл катар биявэско мисяфири, тай кана о сагбус кан авэл тай кан марэл, он бирдэн кан пхутрэн лэски. ");
INSERT INTO rmn_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Бахталэ одола иргатя, савэнго сагбус ало кхерэ тай дикхляс, кай он нанай сутэ. Пхэнав тумэнги чячипэ, дэчи ов сам кан пхандэлпэс, кан дэл икос лэн ко конас тай кан овэл ов иргати лэнги. ");
INSERT INTO rmn_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Бахталэ одола иргатя, савэнго сагбус кан дикхел, кай он си газыря, джи тэ авэла ов рати я опэр сабахтанятэ. ");
INSERT INTO rmn_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ай тэ джянэл о сагбус э кхерэско, со сагати кан авэл о чёр, ов на кан мукелас би лэс тэ челпэс андэ кхер. ");
INSERT INTO rmn_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ли тумэ камэл тэ овэн газыря, вай о Чяво о Манушыкано кан авэл одова сагати, кана тумэ Лэс на ишандиен. ");
INSERT INTO rmn_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","О Пётар пхучляс: — Сагбуса, Ту пхукавэс адава пхукаипэ амэнги я алаенги? ");
INSERT INTO rmn_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","О Сагбус пхэнляс: — Кон дэчи кан овэл исани тай годявэр иргати, саво дикхел пал кхер, савэс о сагбус тхэдяс опэр аврэ иргатендэ, по вахыти тэ дэл лэн хапэ? ");
INSERT INTO rmn_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Бахтало одова иргати, савэско сагбус, кана кан авэл, кан аракхел, кай керэл аякха. ");
INSERT INTO rmn_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Пхэнав тумэнги о чячипэ: ов кан дэл лэс тэ дикхел алаи по мангин. ");
INSERT INTO rmn_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ай одова иргати тэ пхэнэла: «Мо сагбус кан авэл дага на чяльти», — тай кан лэл тэ марэл э иргатен тай э иргатинкен, тэ хал, тэ пиел тай тэ матёл, ");
INSERT INTO rmn_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","кан авэл лэско сагбус одова дес, кана ов на ишандиел, тай одова сагати, кана ов на джянэл. Ов кан чинэл лэс дуй котора тай кан керэл лэски одова, со керэн э бипакякерэнца. ");
INSERT INTO rmn_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Одова иргати, саво джянэлас, со мангел лэско сагбус, тай на гортярдяспэс я на кердяс одова, со мангляс о сагбус, кан овэл лачес мардо. ");
INSERT INTO rmn_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ай одова, кон на джянэлас, тай кердяс, андар состэ камэл мардо, кан овэл мардо залаг. Кастэ сас бут дино, одолэстар бут ли кан линдёл, тай каски сас бут пакямаса дино, одолэстар бут ли кан пхучлёл. ");
INSERT INTO rmn_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Мэ алём тэ анав яг опэр пху, тай сар Мэ мангав, ой анкха тэ тхабол! ");
INSERT INTO rmn_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ай Манги дага камэл тэ накхав о болдипэ. Тай Мэ сар опэр сувьендэ сом, бискай адава кан овэл! ");
INSERT INTO rmn_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Тумэ тюшундиен, Мэ алём, тэ анав опэр пху рагати? На, пхэнав тумэнги, на рагати, ами палящима. ");
INSERT INTO rmn_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Хорандас андар пандж мануша кан палящиенпэс: о трин мамуй ко дуй, тай о дуй мамуй ко трин. ");
INSERT INTO rmn_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","О дад кан овэл мамуй пэ чявэстэ, о чяво мамуй пэ дадэстэ, э дай мамуй пэ чяятэ, э чяй мамуй пэ дэятэ, э сасуй мамуй пэ борятэ, э бори мамуй пэ сасатэ. ");
INSERT INTO rmn_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","О Исус генэ пхэнляс э дюняски: — Кана тумэ дикхен булутя ко запад, тумэ чяльти пхэнэн, кай кан овэл брышым, тай чячес джял брышым. ");
INSERT INTO rmn_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Тай кана пхудэл балвал катар юги, тумэ пхэнэн, кай кан овэл тхарипэ, аякха да овэл. ");
INSERT INTO rmn_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Домонгерэ! Тумэ джянэн, сар тэ галён, со тумэ дикхен опэр пху тай опрэ, дэчи соски тумэ на джянэн, саво вахыти ало? ");
INSERT INTO rmn_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Соски тумэ сам на тюшундиен, андэ со о чячипэ? ");
INSERT INTO rmn_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Кана ту джяс ко сагбус одолэса, саво керэл тут дошалэс, кер алаи аякха лачимаса тэ кутардиес тут лэстар дага опэр дром. Я ов кан сидэл тут ко цындомари, тай о цындомари кан дэл тут ко баро ки пханляко, тай одова кан чел тут андэ пханли. ");
INSERT INTO rmn_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Пхэнав туки, кай ту на кан никлёс отхар, бискай на покинэс алаи о борджи. ");
INSERT INTO rmn_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Сарсавэ андар одолэндэ, кон шунэлас э Исусес, пхукавдэ Лэски катар галилеяня, савэн о Пилат пхэнляс тэ мударэн одова вахыти, кана он керэнас курбанес. ");
INSERT INTO rmn_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","О Исус пхэнляс: — Тумэ тюшундиен, кай адала галилеяня аякха мулэ, кай он сас бэзялэ алаендар аврэ галилеянендар? ");
INSERT INTO rmn_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","На! Ай пхэнав тумэнги, тумэ тэ на ачявэна тумарэ бэзя, тумэ аякха кан мэрэн, сар он. ");
INSERT INTO rmn_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Я тэ лэс э дэшуохто манушэн, савэ мулэ, кана опэр лэндэ пэли э Силоамски башня. Тумэ тюшундиен, он сас дошалэ аврэндар алаендар, кон бэшэлас андэ Иерусалими? ");
INSERT INTO rmn_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","На, ай пхэнав тумэнги: тумэ тэ на ачявэна тумарэ бэзя, ли тумэ кан мэрэн, сар он. ");
INSERT INTO rmn_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Пал отхэ о Исус пхукавдяс лэнги пхукаипэ: — Екхе манушэстэ машкарэ ки дракх барёлас инжыри. Екхвар ов гело тэ дикхел, нанай опрал имиша, тай ништо на аракхляс. ");
INSERT INTO rmn_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Дэчи ов пхэнляс э манушэски, саво дикхел пал дракх: «Аки, трин брэш мэ авав тэ дикхав, нанай опрэ адалэ инжырестэ имиша, тай ништо на аракхав. Чин лэс, соски ов ботени лэл пху?» ");
INSERT INTO rmn_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","«Сагбуса, — пхэнляс о иргати, — ачяв лэс генэ екх брэш. Мэ лэс кан храндав агорял, кан тхав кхула э гайваненги, ");
INSERT INTO rmn_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","тай авэр брэш тэ овэна имиша — лачё, ай тэ на, чинэса лэс». ");
INSERT INTO rmn_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Андэ суббота о Исус сиклярэлас андэ екх синагога. ");
INSERT INTO rmn_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Отхэ сас джювли, андэ савятэ сас дэшуохто брэш о духос дукхако. Ой сас камбури тай нащи гортярэласпэс. ");
INSERT INTO rmn_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Дикхляс ла, о Исус диняс икос ла тай пхэнляс: — Джювлие! Ту кутардимэ тэ дукхатар! ");
INSERT INTO rmn_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ов тхэдяс опэр латэ Пэ васта, тай ой бирдэн гортили тай лиляс тэ махтадиел э Дэвлэс. ");
INSERT INTO rmn_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","О баро э синагогако холясаило, кай о Исус аиндэрды андэ суббота, тай ов пхэнляс э манушэнги: — Си шов дес, кана камэл тэ керэс бути. Аки одола деса элан аиндэрдиен, ами на андэ суббота. ");
INSERT INTO rmn_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Адалэски о Сагбус пхэнляс лэски: — Домонгерэ! Та со, андэ суббота тумэ алаи на пхутрэн андэ арани э гурувэс я джёрэс тай на гелэс лэс тэ пиявдярэн? ");
INSERT INTO rmn_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Тай на камэл тэ пхутрас э джянджир э дукхаки андэ суббота ли адалэ джювлятэ, э екх андар чяя ки Авраамески, аки, дэшуохто брэш пханля астарэлас ла о Сатанас? ");
INSERT INTO rmn_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Кана Ов адава пхэнляс, алаи Лэски душманенги уло ладжяво, ай алаи о дюняс лошазэлас э намески дилэнги, савэ Ов керэлас. ");
INSERT INTO rmn_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Пал отхэ о Исус пхэнляс: — Соски ушадиел э Дэвлэско Патишайлыки? Соса лэс тэ ушатэрдиес? ");
INSERT INTO rmn_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ов сар гэрчицако гугуси, саво о мануш лиляс тай читяс андэ пху андэ пэ барятэ. О гугуси барило тай уло тэрэки, аякха, кай джи о чирикля кердэ гнездадэс андэ лэски ровлендэ. ");
INSERT INTO rmn_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Тай генэ пхэнляс: — Соски ушадиел э Дэвлэско Патишайлыки? ");
INSERT INTO rmn_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ов сар шутлипэ, саво э джювли намискердяс тринэ барэ тапцыенца варэса, тэ шутлёл алаи о хумэр. ");
INSERT INTO rmn_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","О Исус накхелас андар диза тай гава, тай андэ алаендэ сиклярэлас дюняс. Джялас ко Иерусалими. ");
INSERT INTO rmn_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Кон-то пхучляс Лэс: — Сагбуса, та со, набут кан овэн кутардимэна? О Исус пхэнляс: ");
INSERT INTO rmn_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","— Тхэ зор тэ дэс андэ танг удар. Пхэнав тумэнги: вай бут кан манген тэ дэн, ай нащи. ");
INSERT INTO rmn_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Кана о сагбус э кхерэско кан ущел тай кан пхандэл о удар, тумэ кан овэн тэрдэ аврял кай марэн, мангимаса: «Сагбуса амаро, пхутэр амэнги!» Ай Ов кан пхэнэл: «На джянав тумэн, катар тумэ». ");
INSERT INTO rmn_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Дэчи тумэ кан пхэнэн: «Амэ хасас, пиясас ангал Тутэ, тай Ту сиклярэсас амэндэ андэ улицэс». ");
INSERT INTO rmn_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ай Ов кан пхэнэл: «Мэ на джянав тумэн, катар тумэ. Джян Мандар алаи, кай керэн канлыки!» ");
INSERT INTO rmn_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Отхэ кан овэл роипэ тай халипэ дандэнго, кана тумэ кан дикхен э Авраамес, э Исаакес, э Яковес тай алаи э прарокен андэ Дэвлэско Патишайлыки, ай тумэ кан овэн читэ отхар. ");
INSERT INTO rmn_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Кан авэн мануша катар вастоки тай катар запад, катар север тай катар юги, тай кан лэн тхан пал конас андэ Дэвлэско Патишайлыки. ");
INSERT INTO rmn_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Тай о палунэ кан овэн ангал, ай ангалунэ — палал. ");
INSERT INTO rmn_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Озаман ко Исус пашылэ сарсавэ фарисея тай пхэнлэ: — Джя Туки, ачяв адава тхан, вай о Ирод мангел Тут тэ мударэл. ");
INSERT INTO rmn_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","О Исус пхэнляс лэнги: — Джян тай пхэнэн адалэ лисицаки: «Мэ кан кувдияв э шэйтанен тай кан састярав манушэн авдес тай рано, ай ко трито дес Мэ кан бытэрдияв Ми дила». ");
INSERT INTO rmn_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ай авдес, рано тай овэр Мэ камэл тэ джяв англэ, вай прароки нащи мэрэл на андэ Иерусалими! ");
INSERT INTO rmn_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Иерусалими, Иерусалими, мударимари э прарокенго тай мударэс барэнца бичялдэн тутэ! Сокаборвар Мэ манглём тэ кидав тэ пуен, сар чирикли кидэл пэ пуен тал пэ пхакендэ, ай тумэ на манглянус! ");
INSERT INTO rmn_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Аки, тумаро кхер ачёл тумэнги чючё. Пхэнав тумэнги, кай тумэ на кан дикхен Ман джи одолэски, бискай на кан пхэнэн: «Махтадимэ Одова, Кон авэл андэ нав ки Сагбуско!» ");
INSERT INTO rmn_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Екхвар андэ суббота, кана о Исус ало тэ хал екхе барэ манушэстэ андар фарисея, одола лачес дикхенас пал Лэстэ. ");
INSERT INTO rmn_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Мамуй ко Исус бэшло мануш, насвало вадянка. ");
INSERT INTO rmn_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","О Исус пхучляс э сикляримарен э Тхэдимаскерэн тай э фарисеен: — Муклёл тэ аиндэрдиен андэ суббота? ");
INSERT INTO rmn_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Он тэныкя сас. Озаман о Исус колисаило ко мануш, аиндэрды лэс тай мукляс. ");
INSERT INTO rmn_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Дэчи Ов пхэнляс лэнги: — Кастэ-то андар тумэндэ чяво я гурув кан пэрэл андэ ханинг, та со тумэ, на кан никалэн лэс чяльти, джи адава тэ овэла андэ суббота? ");
INSERT INTO rmn_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Лэнги ништо на сас тэ пхэнэн адалэски. ");
INSERT INTO rmn_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","О Исус дикхелас, сар о мануша, савэн динэ икос, лэнас о зиядэ тхана пал конас, тай пхукавдяс лэнги пхукаипэ: ");
INSERT INTO rmn_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","— Кана тут дэн икос ки биявэско мисяфири, ма бэш зиядэ тханэстэ. Вай андар одолэндэ, кон диндило икос, кон-то кан овэл намлыс тутар, ");
INSERT INTO rmn_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","тай дэчи о сагбус, кай диняс икос ли тут, ли лэс, кан пашол тутэ тай кан пхэнэл: «Дэ о тхан акалэ манушэстэ». Тай туки кан камэл ладжяваса тэ лэс палуно тхан. ");
INSERT INTO rmn_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Кана тут дэн икос, джя тай бэш палунэ тханэстэ, о сагбус тэ пашол тутэ тай тэ пхэнэл: «Амал, накх ко лачё тхан». Дэчи туки кан овэл дино нами ангал алаи ко джемэяти. ");
INSERT INTO rmn_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Кажни, кон барярэлпэс, кан овэл тикнярдо, тай тикнярэлпэс кан овэл ваздино. ");
INSERT INTO rmn_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Пал отхэ о Исус пхэнляс э сагбуски: — Кана ту керэс хабэ десе я бэлвэле, ма дэ икос тэ амалэн, пхралэн, тухумен я барвалэ комшудэн, тай он тэ на дэн икос тут мамуй тай одолэса тэ на покинэн туки. ");
INSERT INTO rmn_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Кана ту керэс хабэ, дэ икос лэстэ э чёрэн, болавдэн, банген, корэн. ");
INSERT INTO rmn_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Аки дэчи ту кан овэс бахтало, вай он нащи тэ дэн палэ тут, тай ту кан диндёс палэ андэ дживиндипэ ки чяченго. ");
INSERT INTO rmn_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Кана екх андар савэндэ ханас шунляс адава, ов пхэнляс э Исусески: — Бахтало одова, кон кан хал манро андэ Патишайлыки ки Дэвлэско. ");
INSERT INTO rmn_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","О Исус пхэнляс лэски: — Екх мануш гортярдяс баро хабэ тай диняс икос бут дюняс. ");
INSERT INTO rmn_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Кана ало вахыти э хабэско, ов бичялдяс пэ иргатес тэ пхэнэл кас динэ икос: «Элан, алаи газыри». ");
INSERT INTO rmn_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ай екх пал аврэстэ он алаи лилэ тэ апувикерэнпэс. О екх пхэнляс: «Мэ киндём пху, тай манги камэл тэ джяв тай тэ дикхав ла. Апувикер ман, мангав тут». ");
INSERT INTO rmn_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Авэр пхэнляс: «Мэ киндём пандж парэс гурувэн тай джяв тэ галяв лэн. Апувикер ман, мангав тут». ");
INSERT INTO rmn_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","О трито пхэнляс: «Мэ прандосаилём тай оничин нащи авав». ");
INSERT INTO rmn_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","О иргати ало тай пхукавдяс алаи э сагбуски. Дэчи о сагбус э кхерэско холясаило тай пхэнляс э иргатески: «Джя чяльти ко улицэс тай ко танга дроморэ ки дизаки тай ан атхэ чёрэн, болавдэн, корэн тай банген». ");
INSERT INTO rmn_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","«Сагбуса, — пхэнляс о иргати, — одова, со ту пхэнлян, кердём, ай дага си тхан». ");
INSERT INTO rmn_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Дэчи о сагбус пхэнляс э иргатески: «Джя ко дрома тай пашал баря тай манг алаен, кас кан дикхес, тэ авэн атхэ, о кхер минро тэ овэл пхэрдо джемэяти. ");
INSERT INTO rmn_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Пхэнав тумэнги, кай андар ангалунэндэ, кас диням икос, никхон на кан хал мэ хабэстэ». ");
INSERT INTO rmn_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Э Исусеса джялас бут дюняс. Ов болдиняспэс лэндэ тай пхэнляс: ");
INSERT INTO rmn_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","— Кон авэл Мандэ тай дэхэл дадэс тай дэя, ромня тай пуен, пхралэн, пхэнен я джи по бэшыпэ бут, ниш Ман, ов нащи овэл Мо сиклярдо. ");
INSERT INTO rmn_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Одова, кон на гелэл по хачи тай на джял пал Мандэ, нащи овэл Мо сиклярдо. ");
INSERT INTO rmn_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Кон-то андар тумэндэ тэ мангела тэ тхэл башня, та со, ов на кан бэшэл ханик тай на кан гинэл алаи, со камэл, тэ джянэл, кан рэсэл лэски ловэ тэ бытэрдиел о тхэдипэ? ");
INSERT INTO rmn_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Вай ов тэ тхэла фундамент тай нащи кан бытэрдиел о тхэдипэ, тай алаи, кай дикхен адава, кан овэн лэстар, кай асан: ");
INSERT INTO rmn_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","«Адава мануш лиляс тэ тхэл, ай нащи бытэрды». ");
INSERT INTO rmn_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Я патишаи, саво кидэлпэс ко марипэ мамуй аврэ патишаестэ. Та со, ов на кан бэшэл ханик тай на кан тюшундиел, зорало ов дэшэ бине манушэнца кан тэрдярэл одолэс, кон кан авэл опэр лэстэ маримаса бишэ биненца? ");
INSERT INTO rmn_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Тэ нащи, дэчи, бискай о душмани дага дур, ов кан бичялэл бичялдэн тэ манген лачимаса. ");
INSERT INTO rmn_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Акана, одова андар тумэндэ, кон на кан ачявэл алаи, со си лэстэ, нащи овэл Мо сиклярдо. ");
INSERT INTO rmn_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Лон — лачё шэи, ай тэ нашавэла о лон по дами, тай со генэ кан керэл лэс лондо? ");
INSERT INTO rmn_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Нэ андэ пху ов на лачё, нэ андэ навози, лэс ачёл екх тэ чес. Кастэ си кана, тэ шунэл, мэ шунэл! ");
INSERT INTO rmn_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Тэ шунэн э Исусес кидинэпэс алаи о кидимаря э налогенги тай авэра бэзялэ. ");
INSERT INTO rmn_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","О фарисея тай о сикляримаря э Тхэдимаски холяса зборизэнас андэ пэстэ: — Ов зборизэл э бэзялэнца тай хал екхетханэ лэнца. ");
INSERT INTO rmn_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Озаман о Исус пхукавдяс лэнги пхукаипэ: ");
INSERT INTO rmn_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","— Кастэ-то андар тумэндэ тэ си шэл бакрэ, тай екх андар лэндэ тэ бирисаило. Та со, ов на кан ачявэл энядэша эня ки ливади тай на кан джял тэ родэл кай бирисаило, бискай на аракхел? ");
INSERT INTO rmn_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Тай кана ов кан аракхел лэс, лошаса кан лэл опэр пэ пхикендэ. ");
INSERT INTO rmn_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Тай кана ов кан авэл кхерэ, кан дэл икос пэ амалэн тай э комшудэн тай кан пхэнэл лэнги: «Лошазэн манца, вай мэ аракхлём мэ нашавдэ бакрэс!» ");
INSERT INTO rmn_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Пхэнав тумэнги, кай опрэ кан овэл май бари лош екхе манушэски, саво ачявдяс пэ бэзя, ниш э энядэша энянги э чяченги, савэнги на камэл тэ ачявэн пумарэ бэзя. ");
INSERT INTO rmn_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Я кана ки джювли си дэш рупунэ драхмэс тай ой екх андар лэндэ кан нашавэл, та со, ой на кан тхарэл э лампа тай на кан лэл тэ шулавэл алаи о кхер джи одолэ вахытески, бискай на кан аракхел ла? ");
INSERT INTO rmn_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Тай кана ой ла кан аракхел, ой кан дэл икос пэ амалинкен тай э комшуисэн, тай кан пхэнэл: «Лошазэн манца, мэ аракхлём ми нашавди драхма». ");
INSERT INTO rmn_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Акана, Мэ пхэнав тумэнги, кай аякха э Дэвлэски миляикя лошазэн э екхески, саво ачявдяс пэ бэзя! ");
INSERT INTO rmn_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","О Исус пхукавдяс: — Екхе манушэстэ сас дуй чявэ. ");
INSERT INTO rmn_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","О тикно пхэнляс пэ дадэски: «Дадэ, дэ ман одова паи э мангинэско, саво кан овэл минро». Тай о дад паляшты о барвалипэ машкарэ ко чявэ. ");
INSERT INTO rmn_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Набут десендар о тикно чяво кидиняс алаи, со лэстэ сас, тай гело андэ дур пху. Отхэ ов тхэдяс алаи по мангин, кай на дэласпэс годи, тхэлас ловэ. ");
INSERT INTO rmn_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Кана лэстэ ништо на ачило, одолэ пхуятэ ули бари бокх, тай ов уло андэ чёримастэ. ");
INSERT INTO rmn_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Дэчи ов гело тай тхэдяспэс бутятэ екхе манушэстэ андар одолэ пхуятэ, ай одова бичялдяс лэс пэ ливадяндэ тэ чярявэл э чёчкадэн. ");
INSERT INTO rmn_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ов аякха сас бокхало, кай мангляс тэ чялярэлпэс хамаса э чёчкадэнгерэса, ами ли одова лэс на дэнас. ");
INSERT INTO rmn_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Тай галилопэс, ов пхэнляс: «Сокабор бутярнэ андэ кхер мэ дадэстэ, тай лэндэ хапэ бут, ай мэ атхэ мэрав э бокхатар! ");
INSERT INTO rmn_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Кан джяв, тэ болдавман мэ дадэстэ тай кан пхэнав лэски: \"Дадэ! Бэзя кердём мамуй ко Дэл, кай си опрэ, тай мамуй тутэ. ");
INSERT INTO rmn_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Мэ на керав тэ бучяв то чяво, ов манца, сар екхеса андар тэ бутярнэндэ\"». ");
INSERT INTO rmn_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Тай ов ущино тай гело пэ дадэстэ. Кана ов сас дага дур, о дад дикхляс лэс тай аяды. Ов прастанило мамуй лэстэ, диняс ангали лэс тай лиляс тэ чюмидэл. ");
INSERT INTO rmn_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","О чяво пхэнляс лэски: «Дадэ! Кердём бэзя мамуй ко Дэл, кай си опрэ, тай мамуй тутэ. Мэ на керав тэ бучяв то чяво». ");
INSERT INTO rmn_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ай о дад пхэнляс пэ иргатенги: «Джян чяльти, анэн зиядэ савутя тай урявэн лэс. Тхэн ко най ангрусти тай урявэн лэс минидэс. ");
INSERT INTO rmn_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Анэн хавдярдэ гуруворэс тай чинэн лэс, кан керас хабэ тай кан лошазас. ");
INSERT INTO rmn_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Вай мо чяво сас муло, тай аки ов генэ дживиндило! Ов сас нашавдо тай аракхлило!» Тай он лилэ тэ лошазэн. ");
INSERT INTO rmn_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ай о баро чяво адава вахыти сас ки ливади. Кана ов пашолас ко кхер, тай шунляс, кай андэ кхер гиля тай кхелипэ. ");
INSERT INTO rmn_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ов диняс икос екхес андар иргатя тай пхучляс лэс, со овэлпэс. ");
INSERT INTO rmn_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","«То пхрал ало, — пхэнляс лэски одова, — тай то дад чиндяс хавдярдэ гуруворэс, кай лэско чяво ало дживиндо тай аиндимэ». ");
INSERT INTO rmn_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","О баро чяво холясаило тай на мангляс тэ дэл андэ кхер. Дэчи о дад никлисто тай лиляс лэс тэ мангел. ");
INSERT INTO rmn_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ай о чяво пхэнляс пэ дадэски: «Алаи адала брэша мэ керавас бути опэр тутэ, сар иргати, тай екхараи керавас одова, со ту пхэнэсас. Ту били екхвар на динян ман джи бузнорэс, тай мэ тэ лошазав амалэнца. ");
INSERT INTO rmn_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ай кана адава то чяво, саво тхэдяс то мангин э кахпэисэнца, ало кхерэ, ту чиндян лэски хавдярдэ гуруворэс!» ");
INSERT INTO rmn_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","«Чяворо, — пхэнляс дэчи о дад, — ту вай екхараи манца, тай алаи, со си мандэ, — алаи тинро. ");
INSERT INTO rmn_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ай амэ камэл тэ лошазас, вай то пхрал сас муло тай дживиндило, сас нашавдо тай аракхлило!» ");
INSERT INTO rmn_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","О Исус пхэнляс Пэ сиклярдэнги: — Екхе барвалэстэ сас баро бутярно, саво дикхелас пал лэски мангинэстэ. Екхвар э сагбуски пхэнлэ, кай адава бутярно тхэлас бут андар лэски мангинэстэ. ");
INSERT INTO rmn_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","О сагбус диняс икос лэс пэстэ тай пхэнляс: «Со адава мэ шунав тутар? Сикав манги алаи ти бути, со кердян. Ту нащи ачёс адалэ тханэстэ». ");
INSERT INTO rmn_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","О бутярно тюшунды: «Со манги акана тэ керав? О сагбус чел ман катар бути. Тэ джяв тэ храндав мандэ нанай зор, тэ мангав аври — ладжяв… ");
INSERT INTO rmn_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ай мэ джянав, со манги тэ керав, тай, кана ман атхар кан чен, тэ аракхлён мануша, савэ кан мукен ман пэстэ кхерэ». ");
INSERT INTO rmn_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Тай ов лиляс тэ дэл икос екхес пал аврэстэ э бордженгерэн пэ сагбускерэн. Э екхес ов пхучляс: «Сокабор ту борджи мэ сагбуски?» ");
INSERT INTO rmn_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","«Шэл бочкес маслинэнги олия», — пхэнляс одова. О бутярно пхэнляс лэски: «Лэ то лил, бэш чяльти тай яздие пэинда». ");
INSERT INTO rmn_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Пал отхэ ов пхучляс аврэс борджескерэс: «Ами ту сокабор борджи?» «Бини гонэ гив», — пхэнляс одова. О бутярно пхэнлясас лэски: «Лэ то лил тай яздие охтошэла гонэ». ");
INSERT INTO rmn_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","О сагбус махтады э хохавнэ бутярнэс андар лэски муршымастэ. О пуя адалэ дюняски годявэра андэ дилэс асавкенца, сар он, ниш о пуя э ярэкески. ");
INSERT INTO rmn_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Мэ пхэнав тумэнги, тумарэ нашужэ барвалимаса кинэн амалэн. Тай кана ов кан бытиел, тумэ тэ овэн муклэ андэ катунэс, савэ кан овэн екхараи. ");
INSERT INTO rmn_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Кон чячё андэ залаг, одова чячё ли андэ баро, тай кон начячё андэ залаг, одова начячё ли андэ баро. ");
INSERT INTO rmn_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Оничин, тумэ тэ на санусас чяче андэ тхэдипэ э пхуяки барвалимаса, тай кон кан дэл тумэн о чячикано? ");
INSERT INTO rmn_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Тай тумэ тэ на санусас чячимаса э барвалимаски аврэскерэски, дэчи кон кан дэл тумэн тумаро? ");
INSERT INTO rmn_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Били екх иргати нащи керэл иргатлыки до сагбудэнги. Ов я екхес на кан дэхэл, ай аврэс кан дэхэл, я екхески кан овэл чячимаса, ай аврэс на кан гинэл. Тумэ нащи андэ екх вахыти керэн иргатлыки ли Дэвлэски, ли барвалимаски. ");
INSERT INTO rmn_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","О фарисея, савэ дэхэнас ловэ, шунэнас алаи адава тай асанас катар Исус. ");
INSERT INTO rmn_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","О Исус пхэнляс лэнги: — Тумэ манген тэ сикавэн тумэн исаня ангал мануша, ай о Дэл джянэл тумарэ илэ. Одова, со гинэн о мануша, — гарами андэ якха ки Дэвлэски. ");
INSERT INTO rmn_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","О вахыти э Тхэдимаско тай э прарокенго сас джи ко Иоанн, анкха пхукавдёл Лошано Габэри катар Дэвлэско Патишайлыки, тай кажни тхэл зор, тэ пэрэл андэ лэстэ. ");
INSERT INTO rmn_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ай чяльти о булутя тай э пху кан нашавдён, ниш андар Тхэдипэ кан нашавдёл екх точка! ");
INSERT INTO rmn_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Кажни, кон чел пэ ромня тай лэл авря, керэл кахпэлыки, тай одова, кон кан лэл джювля, савя читяс о ром, аякхажэ керэл кахпэлыки. ");
INSERT INTO rmn_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Бэшэлас екх барвало мануш. Ов урявэласпэс андэ багалыдэс тай шукара савутя тай кажын дес лошаса лэлас катар бэшыпэ алаи. ");
INSERT INTO rmn_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ай лэски барятэ пашло чёро, саво бучёлас Лазарь. Ов сас алаи учярдо ярадэнца ");
INSERT INTO rmn_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","тай овэлас би лошано джи хамаски, кай пэрэл опрал конас ки барвалэско. Джюкела пашонас тай джяладиенас лэски ярадэс. ");
INSERT INTO rmn_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Тай аки, о чёро муло, тай миляикя гелдэ лэс ко Авраам. Муло ли о барвало, лэс пароскердэ. ");
INSERT INTO rmn_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Андэ ади, катэ о барвало сидэлас баро хурлуки, ов ваздиняс пэ якха тай дикхляс дурал э Авраамес, ай паш лэстэ э Лазарес. ");
INSERT INTO rmn_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ов диняс икос: «Дадэ Авраам, аядие ман! Бичял э Лазарес, тай одова тэ болэл о чети пэ наеско андэ пани тай тэ шудрярэл ми чиб, вай мэ сидав хурлуки андэ адалэ ягатэ». ");
INSERT INTO rmn_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ай о Авраам пхэнляс: «Пуёс, мэ авэл тэ годятэ, со ту лилян андэ тэ бэшымастэ лачё, ай о Лазарь лэлас екх джюнгало. Анкха ов атхэ лэл рагати, ай ту сидэс хурлуки. ");
INSERT INTO rmn_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Тай генэ, машкарэ амэндэ тай тумэндэ тхэди бари хэв, аякха кай джи кон-то би ли тэ мангелас атхар тэ джял тумэндэ, ов нащи, тай никхон отхар нащи авэл амэндэ». ");
INSERT INTO rmn_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","О барвало пхэнляс: «Дэчи мангав тут, дадэ, бичял э Лазарес андэ кхер мэ дадэско. ");
INSERT INTO rmn_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Вай мандэ пандж пхрала, мэ пхэнэл лэнги, тай ли он тэ на пэрэн андэ адава тхан ки хурлукеско». ");
INSERT INTO rmn_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","О Авраам пхэнляс: «Лэндэ си о Маисей тай о прарокя, мэ шунэн лэн». ");
INSERT INTO rmn_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","«На, дадэ Авраам, — пхэнляс о барвало, — аки би кон-то андар мулэ тэ авэла лэндэ, озаман би он ачявэнас пумарэ бэзя». ");
INSERT INTO rmn_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","О Авраам лэски пхэнляс: «Он э Маисеес тай э прарокен на шунэн, тай кон-то джи тэ дживиндёла андар мулэ, ли адава нащи лэн кан тхэл тэ пакян». ");
INSERT INTO rmn_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","О Исус пхэнляс пэ сиклярдэнги: — Со зумавэл э манушэс нащи тэ на овэл, ай касэвэти одолэски, кон дэл бутуря э манушэн андэ бэзя. ");
INSERT INTO rmn_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Одолэски, кон хоч екхес андар адалэ тикнэндэ кан дэл бутуря андэ бэзя, сас би зиядэ, лэски тэ урявэн ки мэн мельницако бар тай тэ чен андэ пани. ");
INSERT INTO rmn_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Оничин сакёвэн! То пхрал тэ керэл бэзя, тэрдяр лэс, тай ов тэ ачявэла о бэзя, апувикер лэс. ");
INSERT INTO rmn_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Тай джи ов тэ кердяс бэзя туки эфтавар андэ дес тай эфтавар тэ авэла тутэ тай тэ пхэнэла: «Мэ сом дошало», — апувикер лэс. ");
INSERT INTO rmn_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","О апостоля сар-то манглэ э Сагбус: — Баряр амаро пакяпэ! ");
INSERT INTO rmn_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","О Сагбус пхэнляс: — Тумэндэ тэ си пакяпэ, сар гэрчицако гугуси, тумэ дэчи тэ пхэнэна акалэ дюдяки тэрэкески: «Чиндё э коринеса тай бэшав тут андэ пани», — ов тумэн кан тхэл кан. ");
INSERT INTO rmn_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Кастэ-то андар тумэндэ си иргати, саво храндэл э пху я чярярэл бакрэн. Кан пхэнэн тумэ лэски, кана ов кан авэл катар ливади: «Эла, бэш тай ха»? ");
INSERT INTO rmn_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","На, тумэ дэба кан пхэнэн: «Газырлыдие манги хапэ, дэчи пхандэ тут опрал тай кер иргатлыки манги, бискай мэ хав тай пияв, ай дэчи кан хас, кан пиес коркоро». ");
INSERT INTO rmn_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Махтадиел о сагбус э иргатес андар одолэстэ, со одова керэл, со лэски пхэнлило? ");
INSERT INTO rmn_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Аякха ли тумэ, кана кан керэн алаи, со тумэнги сас пхэнло, пхэнэн: «Амэ сам иргатя, савэ на керэн лэн тэ махтадиес. Амэ кердям екх одова, со камэлас тэ керас». ");
INSERT INTO rmn_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Опэр дром ко Иерусалими о Исус накхелас машкарэ ки Самария тай ки Галилея. ");
INSERT INTO rmn_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Кана Ов дэлас андэ екх гав, Лэс дикхлэ дэш гералэ, савэ тэрдилэ надур ");
INSERT INTO rmn_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","тай лачес дэнас бэбэря: — Исус, Сикляримарина, аядие амэн! ");
INSERT INTO rmn_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Кана о Исус лэн дикхляс, Ов пхэнляс: — Джян тай сикавэн тумэн э попазенги. Одола гелэ тай опэр дром сас аиндимэна. ");
INSERT INTO rmn_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","О екх андар лэндэ, сар дикхляс, кай аинды, болдиняспэс, бэбэренца махтадиелас э Дэвлэс. ");
INSERT INTO rmn_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ов пэло ко чянга ки Исусески тай пхэнляс Лэски: «Бахт мэ дэл тут о Дэл!» Тай адава мануш сас самаряни. ");
INSERT INTO rmn_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","— Та со, на дэш мануша сас шужардэ? — пхучляс о Исус. — Кай авэра эня? ");
INSERT INTO rmn_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Соски никхон андар лэндэ, булуб акалэ джяти пхуяки манушэстар, на ало, тэ махтадиел э Дэвлэс? ");
INSERT INTO rmn_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Тай пхэнляс э самарянески: — Ущи тай джя, то пакяпэ кутарды тут. ");
INSERT INTO rmn_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Екхвар о фарисея пхучлэ ко Исус, кана кан авэл э Дэвлэско Патишайлыки. Ов пхэнляс: — Э Дэвлэско Патишайлыки на кан авэл аякха, кай кан дикхес лэс якхенца. ");
INSERT INTO rmn_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Никхон нащи кан пхэнэл: «Аки, ов акатэ!» я «Ов окотэ!» Э Дэвлэско Патишайлыки машкарэ тумэндэ. ");
INSERT INTO rmn_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Дэчи Ов пхэнляс э сиклярдэнги: — Кан авэл асавко вахыти, кана тумэ кан манген тэ дикхен хоч екх андар деса э Чявэс э Манушыканэс, тай на кан дикхен. ");
INSERT INTO rmn_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Тумэнги кан пхэнэн: «Аки, Ов окотэ!» я «Аки, Ов акатэ!» Ай тумэ ма прастан тэ дикхен. ");
INSERT INTO rmn_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Сар э страпи, кана тхабол, сикавэл алаи опрэ, катар чети джи ко чети, аякха кан овэл ли о Чяво о Манушыкано андэ дес, кана Ов кан авэл. ");
INSERT INTO rmn_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ай ханик Лэски камэл тэ даяндиел бут касэвэти, тай кан болдэнпэс Лэстар о мануша адалэ вахытески. ");
INSERT INTO rmn_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Сар сас андэ деса ки Ноескерэ, аякха кан овэл ли андэ деса ки Чявэско ки Манушыканэско. ");
INSERT INTO rmn_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","О мануша ханас, пиенас, прандозэнас тай джянас ромэстэ джи одолэ десестэ, кана о Ной бэшло андэ кавчеги. Дэчи ваздиндило баро пани тай алаен мудардяс. ");
INSERT INTO rmn_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Аякха сас андэ деса ки Лотески. О мануша ханас, пиенас, кинэнас тай бикнэнас, барярэнас тай керэнас. ");
INSERT INTO rmn_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ай андэ дес, кана о Лот мукляс о Садом, опрал чёрдили яг тай сера тай алаен лэн мудардяс. ");
INSERT INTO rmn_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Аякха кан овэл ли одова дес, кана кан авэл о Чяво о Манушыкано. ");
INSERT INTO rmn_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Одова дес кон-то тэ овэла опэр кхер, ай лэски шэя — андэ кхер, мэ на фулел тэлэ пал шэя. Тай кон ки ливади, мэ на авэл палэ. ");
INSERT INTO rmn_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Мэ овэл тумарэ годятэ э ромни э Лотески! ");
INSERT INTO rmn_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Кон мангел тэ гаравэл по бэшыпэ, одова кан нашавэл лэс, тай кон кан нашавэл по бэшыпэ, одова кан гаравэл лэс. ");
INSERT INTO rmn_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Пхэнав тумэнги, кай одоя рат дуй кан овэн опэр екх тхан, тай о екх кан овэл линдо, ай авэр ачявдо. ");
INSERT INTO rmn_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Дуй джювля паш екх аврэстэ кан ронискерэн гив, э екха кан лэн, э екха кан ачявэн. ");
INSERT INTO rmn_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","— Кай, Сагбуса? — пхучлэ о сиклярдэ. О Исус пхэнляс: — Катэ си муло, отхэ кан кидэнпэс ли арёля-стервятникя. ");
INSERT INTO rmn_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","О Исус мангелас тэ сикавэл э сиклярдэнги, кай камэл екхараи тэ мангес ко Дэл тай тэ на керэс касэвэти, тай пхукавдяс лэнги акасавко пхукаипэ. ");
INSERT INTO rmn_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","— Андэ екхе дизатэ сас цындомари, саво на трашалас катар Дэл тай на ладжялас катар мануша. ");
INSERT INTO rmn_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Андэ одолэ жэ дизатэ бэшэлас пхивли, сави екхараи пхерэлас лэстэ тай мангелас: «Чячимаса кер ми дила, кутардие ман мэ дошалэстар». ");
INSERT INTO rmn_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Саво-то вахыти о цындомари лаки пхэнэлас «на», тай дэчи тюшунды: «Мэ катар Дэл на трашав тай манушэндар на ладжяв, ");
INSERT INTO rmn_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ай адая пхивли на дэл ман рагати. Мэ кан кутардияв ла, тэ на авэл ой генэ тэ быздэрдиел ман». ");
INSERT INTO rmn_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Тай о Сагбус пхэнляс: — Шунэн, со пхэнляс о хохавно цындомари? ");
INSERT INTO rmn_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ай сар о Дэл на кан кутардиел одолэн, савэн Ов лиляс, савэ манген Лэс ли о дес ли э рат? Сар Ов кан сидэл э ярдымеса? ");
INSERT INTO rmn_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Пхэнав тумэнги: Ов бисидимаско кан кутардиел лэн. Ай кана о Чяво о Манушыкано кан овэл, Ов кан аракхел пакяпэ опэр пху? ");
INSERT INTO rmn_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Одолэнги, кон пакялас андэ пумаро чячипэ тай фаласа дикхенас карин аврэндэ, о Исус пхукавдяс акасавко пхукаипэ: ");
INSERT INTO rmn_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","— Дуй мануша алэ андэ храми тэ манген э Дэвлэс. О екх андар лэндэ сас фарисеи, ай авэр — кидимари э налогенго. ");
INSERT INTO rmn_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","О фарисеи ущино тай акаякха пхэнэлас э Дэвлэски: «Дэвла, лачипэ Туки, кай мэ на асавко, сар авэра мануша: чёра, наисаня, кахпэдэс я сар акава кидимари э налогенго. ");
INSERT INTO rmn_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Мэ астарав оразас дувар андэ базари тай дав дэшто паи мэ казандимастар». ");
INSERT INTO rmn_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ай о кидимари э налогенго тэрдо дурал, на мангелас джи пэ якха тэ ваздэл опрэ, ами марэлас по колин тай пхэнэлас: «Дэвла, ов миласа мандэ, бэзялэстэ». ");
INSERT INTO rmn_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Пхэнав тумэнги, кай адава мануш гело кхерэ чячё ангал Дэл, ами на о фарисеи. Вай кажни, кон ваздэлпэс, кан овэл тикнярдо, ай кажни, кон тикнярэлпэс, кан овэл ваздино. ");
INSERT INTO rmn_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Сарсавэ мануша анэнас ко Исус пуен, Ов тэ колизэл лэндэ. О сиклярдэ дикхенас адава тай тэрдярэнас лэн. ");
INSERT INTO rmn_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ай о Исус диняс икос лэн Пэстэ тай пхэнляс: — Мукен о пуя, мэ авэн Мандэ, ма астарэн лэн, вай э Дэвлэско о Патишайлыки си асавкенги, сар он. ");
INSERT INTO rmn_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Пхэнав тумэнги чячипэ: кон на кан лэл э Дэвлэско Патишайлыки, сар пуёс, одова на кан дэл андэ лэстэ. ");
INSERT INTO rmn_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Екх баро мануш пхучляс Лэс: — Лачё Сикляримарина, со манги тэ керав, тэ овэл мандэ бибытимаско бэшыпэ? ");
INSERT INTO rmn_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","— Соски ту пхэнэс Манги «лачё»? — пхэнляс о Исус. — Никхон нанай лачё, екх о Дэл. ");
INSERT INTO rmn_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ту джянэс о тхэдиматэс: ма кер кахпэлыки, ма мудар, ма чёр, ма хохав, гин дадэс тай дэя. ");
INSERT INTO rmn_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","— Алаи адава мэ керав дага катар деса мэ тикнимаскерэндар, — пхэнляс ов. ");
INSERT INTO rmn_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","О Исус шунляс адава тай пхэнляс лэски: — Екх туки на рэсэл. Бикин алаи, со си тутэ, тай дагытие о ловэ ко чёрэ, тай дэчи тутэ кан овэл барвалипэ опрэ. Дэчи эла тай джя пал Мандэ. ");
INSERT INTO rmn_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Кана о баро шунляс адава, ов уло касэвэтлыс, вай сас бут барвало. ");
INSERT INTO rmn_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","О Исус дикхляс карин лэстэ тай пхэнляс: — Со пхаро э барвалэнги тэ дэн андэ Дэвлэско Патишайлыки! ");
INSERT INTO rmn_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Локес эси э камилаки тэ накхел андар ки сувьяко кан, ниш э барвалэски тэ дэл андэ Дэвлэско Патишайлыки. ");
INSERT INTO rmn_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Одола, кон адава шунэлас, пхучлэ: — Кон дэчи кан кутардиелпэс? ");
INSERT INTO rmn_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","О Исус пхэнляс: — Со нащи керэл о мануш, си зор ко Дэл тэ керэл. ");
INSERT INTO rmn_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Дэчи о Пётар пхэнляс: — Аки, амэ ачявдям алаи, со амэндэ сас, тай гелям пал Тутэ. ");
INSERT INTO rmn_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","О Исус пхэнляс лэнги: — Пхэнав тумэнги чячипэ: кажни, кон мукляс кхер, я ромня, я пхралэн, я дадэс тай дэя, я пуен булуб э Дэвлэски Патишайлыкески, ");
INSERT INTO rmn_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","кан диндёл май бут адалэ вахытестэ, тай дэчи — э бибытимаско бэшыпэ. ");
INSERT INTO rmn_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","О Исус гелдяс дэшудо сиклярдэн ригатэ тай пхэнляс лэнги: — Аки, амэ ваздасамэн ко Иерусалими, тай отхэ кан овэл кердо алаи, со яздылар о прарокя катар Чяво ко Манушыкано. ");
INSERT INTO rmn_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ов кан овэл дино ко мануша, савэ на джянэн э Дэвлэс. Одола кан асан Лэстар, кан кушэн Лэс, кан чюнгарэн опэр Лэстэ, ");
INSERT INTO rmn_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","кан марэн камчияса тай пал отхэ кан мударэн. Ай ко трито дес Ов кан дживиндёл. ");
INSERT INTO rmn_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","О сиклярдэ ништо андар адалэстэ на галилэ; алаи, со Ов пхэнляс, сас лэнги пханло, тай он на галёнас, состар Ов пхэнляс. ");
INSERT INTO rmn_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Кана о Исус пашолас ко Иерихони, ко дром бэшло сас коро тай мангелас. ");
INSERT INTO rmn_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Кана ов шунляс, кай пашал джял дюняс, ов пхучляс, со овэл. ");
INSERT INTO rmn_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","— Авэл о Исус андар Назарет, — пхэнлэ лэски. ");
INSERT INTO rmn_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Дэчи о коро диняс бэбэря: — Исус, Чяво э Давидеско! Аядие ман! ");
INSERT INTO rmn_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Одола, кай джянас ангал, лилэ тэ пхэнэн ов тэ пхандэл по муй, ай о коро дэлас бэбэря май лачес: — Чяво Давидеско, аядие ман! ");
INSERT INTO rmn_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","О Исус тэрдило тай пхэнляс, адалэ манушэс тэ анэн Лэстэ. Кана одова пашыло, о Исус пхучляс лэс: ");
INSERT INTO rmn_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","— Со ту мангес, Мэ тэ керав туки? — Сагбуса, мэ мангав тэ дикхав, — пхэнляс о коро. ");
INSERT INTO rmn_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","О Исус пхэнляс лэски: — Дикх! То пакяпэ аиндэрды тут. ");
INSERT INTO rmn_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","О коро бирдэн лиляс тэ дикхел тай гело пал Исус, та ли махтадиелас э Дэвлэс. Тай алаи о дюняс, саво дикхелас адава, махтадиелас э Дэвлэс. ");
INSERT INTO rmn_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","О Исус диняс андэ Иерихони тай накхелас андар диз. ");
INSERT INTO rmn_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Отхэ сас мануш, саво бучёлас Закхей. Ов эсас барвало мануш тай баро опэр кидимаря ки налогенги. ");
INSERT INTO rmn_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ов мангелас тэ дикхел, кон эси адава Исус, тай нащи андар бут дюняс, вай сас тикнорэ боеско. ");
INSERT INTO rmn_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Озаман, тэ дикхел Лэс, о Закхей прастанило ангал тай никлисто опэр дюдяко тэрэки, катэ о Исус камэлас тэ накхел. ");
INSERT INTO rmn_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Кана о Исус пашыло одолэ тханэстэ, Ов дикхляс опрэ тай пхэнляс: — Закхей, фули чяльти! Авдес Мэ камэл тэ овав тутэ андэ кхер. ");
INSERT INTO rmn_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","О Закхей чяльти фулистино тай лошаса мангляс Лэс пэстэ кхерэ. ");
INSERT INTO rmn_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Алаи, кон дикхелас адава, лилэ тэ холязэн: — Ов гело кхерэ ко бэзяло! ");
INSERT INTO rmn_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","О Закхей ущино тай пхэнляс э Сагбуски: — Сагбуса! Екхпаш мэ мангинэстар мэ кан дав ко чёрэ, ай мэ кастар-то тэ лилём бут, ниш камэл, мэ кан дав лэс штарвар бут! ");
INSERT INTO rmn_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Дэчи о Исус пхэнляс лэски: — Авдес андэ адава кхер ало кутардипэ, вай ли адава мануш си о чяво э Авраамеско! ");
INSERT INTO rmn_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","О Чяво о Манушыкано ало тэ аракхел тай тэ кутардиел о нашавдо. ");
INSERT INTO rmn_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Одолэнги, кон адава шунэлас, о Исус пхукавдяс пхукаипэ. Он сас надур катар Иерусалими, тай о мануша тюшундиенас, кай э Дэвлэско Патишайлыки камэл аки-аки тэ авэл. ");
INSERT INTO rmn_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","О Исус пхэнляс: — Екх намлыс мануш джялас дур пхуятэ, тэ диндёл патишайлытико зор тай тэ авэл. ");
INSERT INTO rmn_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ов диняс икос пэ дэшэ иргатен тай диняс лэн по шэл драхмэс. «Мукен адала ловэ андэ бути, бискай мэ на авав», — пхэнляс ов. ");
INSERT INTO rmn_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ай о мануша лэски пхуяки на дэхэнас лэс тай бичялдэ пал лэстэ манушэн тэ пхэнэн: «Амэ на мангас, адава мануш тэ овэл амаро патишаи». ");
INSERT INTO rmn_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Кана ов диндило патишайлытико зор тай ало, пхэнляс тэ авэн лэстэ о иргатя, савэн диняс руп, тэ пхучел лэн, со он казандылар. ");
INSERT INTO rmn_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","О екхто ало тай пхэнляс: «Сагбуса, тэ шэл драхмэс андэ бини драхмэс казандима!» ");
INSERT INTO rmn_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","«Муршари! — пхэнляс о сагбус. — Ту лачё иргати. Ту санас чячё андэ залаг, оничин тутэ кан овэл барипэ опэр дэшэ дизэндэ». ");
INSERT INTO rmn_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ало о дуйто иргати тай пхэнляс: «Сагбуса, тэ шэл драхмэс андэ панджшэл драхмэс казандима!» ");
INSERT INTO rmn_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","О сагбус пхэнляс: «Лэ, дикх пал пандж диза». ");
INSERT INTO rmn_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Дэчи ало о трито иргати тай пхэнляс: «Сагбуса, аки тэ шэл драхмэс, мэ гарававас лэн пакярдэ андэ кхосно. ");
INSERT INTO rmn_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Мэ трашавас тутар, кай ту сан мануш канлыс. Ту лэс отхэ, катэ на тхэдян, тай кидэс, со на барярдян». ");
INSERT INTO rmn_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","О сагбус дэчи пхэнляс: «Ту налачё иргати! Мэ кан керав цындос туки тэ зборэнца! Ту джянэсас, кай мэ мануш канлыс, тай кай мэ лав отхэ, катэ на тхэдём, тай кидав, со на барярдём? ");
INSERT INTO rmn_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Соски ту на муклян мо руп андэ бути, тай, кана мэ кан авав, тэ дэс лэн мандэ кяреса?» ");
INSERT INTO rmn_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Тай ов пхэнляс э тэрдэнги отхэ: «Лэн лэстар лэски шэл драхмя тай дэн одолэстэ, кастэ си бини драхмэс». ");
INSERT INTO rmn_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","«Сагбуса, — пхэнлэ лэски, — ва вай лэстэ ли аякха си бини драхмэс!» ");
INSERT INTO rmn_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","О сагбус пхэнляс: «Пхэнав тумэнги, кастэ си, кан диндёл генэ, ай кастэ нанай, кан линдёл ли одова, со си лэстэ. ");
INSERT INTO rmn_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ай мэ душманен, савэ на мангенас, мэ тэ овав лэнго патишаи, анэн лэн атхэ тай мударэн лэн ангал мандэ». ");
INSERT INTO rmn_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","О Исус пхэнляс адава тай гело англэ ко Иерусалими. ");
INSERT INTO rmn_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Пашолас ки Виффагия тай ки Вифания, кай сас ки Маслинэнго горас, Ов бичялдяс ангал дон сиклярдэн, ");
INSERT INTO rmn_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","пхэнляс: — Джян андэ гав, саво си ангал тумэндэ. Кана тумэ кан дэн андэ лэстэ, тумэ кан аракхен пханлэ джёрэс, опэр савэстэ дага никхон на бэшло. Пхутрэн лэс тай анэн атхэ. ");
INSERT INTO rmn_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ай кон-то тумэн тэ пхучела: «Соски тумэ лэс пхутрэн?» — пхэнэн: «Ов камэл э Сагбуски». ");
INSERT INTO rmn_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","О сиклярдэ, савэн Ов бичялдяс, гелэ тай аракхлэ алаи аякха, сар лэнги пхэнляс о Исус. ");
INSERT INTO rmn_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Кана он пхутрэнас э джёрэс, о сагбудэс пхучлэ лэн: — Тумэ соски пхутрэн э джёрэс? ");
INSERT INTO rmn_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Он пхэнлэ: — Ов камэл э Сагбуски. ");
INSERT INTO rmn_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Он андэ э джёрэс ко Исус, читэ опэр лэстэ пумарэ савутя тай бэшавдэ опэр лэстэ э Исусес. ");
INSERT INTO rmn_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Кана Ов джялас, о мануша лилэ тэ джяйдиен опэр дром пумарэ савутя. ");
INSERT INTO rmn_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Тай кана Ов пашыло ко тхан, катэ о дром фулел опрал Маслинэнго горас, алаи о сиклярдэ лошаса тай лачес лилэ тэ махтадиен э Дэвлэс андар алаи ко чюдэс, савэ он дикхлэ: ");
INSERT INTO rmn_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","— Махтадимэ Патишаи, Саво авэл андэ нав ки Сагбуско! Рагати тай нами андэ учипэ опрэ! ");
INSERT INTO rmn_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Сарсавэ, кай сас андэ дюняс ки фарисеенго, пхэнэнас э Исусески: — Сикляримарина, тэрдяр Тэ сиклярдэн! ");
INSERT INTO rmn_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ов пхэнляс: — Пхэнав тумэнги: он тэ тэныкизэна, о бара кан дэн бэбэря. ");
INSERT INTO rmn_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Кана он пашонас ко Иерусалими тай дикхиндёлас э диз, о Исус руно лэски: ");
INSERT INTO rmn_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","— Тэ галёсас би ту авдес, со анэлас би туки рагати! Ай анкха адава гаравдо тэ якхендар. ");
INSERT INTO rmn_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Кан авэн деса, кана тэ душманя кан агорадиен тай кан тасавэн тут алаи катар рига. ");
INSERT INTO rmn_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Он кан хурдярэн тут тай тэ манушэн тай на кан ачявэн андэ тутэ бар опэр бар, кай ту на галилян о вахыти, кана о Дэл ало тутэ. ");
INSERT INTO rmn_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Дэчи о Исус диняс андэ храми тай лиляс тэ кувдиел отхар э бикинимарен. ");
INSERT INTO rmn_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","— Яздимэ си, — пхэнэл Ов лэнги: — «О кхер Минро кан овэл кхер, катэ зборизэн э Дэвлэса», ай тумэ кердянус лэс пэскерэнго кхер. ");
INSERT INTO rmn_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","О Исус кажын дес сиклярэлас андэ храми, ай о барэ попазя, о сикляримаря э Тхэдимаски тай о намлыдэс мануша родэнас, сар тэ мударэн Лэс. ");
INSERT INTO rmn_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ай он на джянэнас, сар адава тэ керэн, вай алаи о дюняс екхараи пхерэнас пал Исус тай шунэнас Лэс. ");
INSERT INTO rmn_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","3Андэ екх андар деса, кана о Исус сиклярэлас э дюняс тай пхукавэлас Лошано Габэри андэ храми, Лэстэ алэ барэ попазя, о сикляримаря э Тхэдимаски тай э барэ манушэнца. ");
INSERT INTO rmn_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","— Пхэн амэнги, каски баримаса Ту алаи адава керэс? Кон диняс Тут адава барипэ? — пхучлэ он. ");
INSERT INTO rmn_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","О Исус пхэнляс: — Ли Мэ тумэндар кан пхучяв. Пхэнэн, ");
INSERT INTO rmn_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","кана о Иоанн болэлас, адава сас опрал катар Дэл я катар мануша? ");
INSERT INTO rmn_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Он лилэ тэ зборизэн машкарэ пэстэ: «Амэ тэ пхэнаса: \"Опрал катар Дэл\", Ов кан пхучел: \"Соски тумэ лэски на пакянилянус?\" ");
INSERT INTO rmn_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ай тэ пхэнаса: \"Катар мануша\", алаи о дюняс кан марэн амэн барэнца, вай он пакян, кай о Иоанн сас прароки». ");
INSERT INTO rmn_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","— Амэ на джянас, кастар, — пхэнлэ он. ");
INSERT INTO rmn_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","— Дэчи ли Мэ тумэнги на кан пхэнав, каски баримаса Мэ алаи адава керав, — пхэнляс лэнги о Исус. ");
INSERT INTO rmn_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ов лиляс тэ пхукавэл э дюняски пхукаипэ: — Екх мануш барярдяс дракх, диняс ла ловэнги сарсавэ манушэндэ тэ дикхен пал латэ, ай ов гело бутэ вахытески ко джятя пхуя. ");
INSERT INTO rmn_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Кана ало вахыти, ов бичялдяс иргатес ко мануша, савэ дикхен пал дракх, тэ дэн лэс паи катар дракх. О мануша э дракхаки мардэ э иргатес тай бичялдэ лэс чюче вастэнца. ");
INSERT INTO rmn_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ов бичялдяс аврэ иргатес, ай он ли адалэс мардэ, асанилэ лэстар тай бичялдэ лэс чюче вастэнца. ");
INSERT INTO rmn_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ов бичялдяс тритонэ иргатес. Он ли адалэс бут лачес мардэ тай читэ лэс андар дракх. ");
INSERT INTO rmn_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Дэчи о сагбус э дракхако тюшунды: «Со манги тэ керав? Кан бичялав мэ дэхлэ чявэс, лэстар он кан ладжян». ");
INSERT INTO rmn_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Кана о мануша э дракхаки дикхлэ э чявэс, он гиндэ: «Адава, каски кан ачёл о мангин. Элан мударас лэс, тай о мангин тэ овэл амаро». ");
INSERT INTO rmn_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Он читэ лэс андар дракх тай мудардэ. Со акана кан керэл лэнца о сагбус э дракхако? ");
INSERT INTO rmn_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ов кан авэл тай кан мударэл одолэ манушэн э дракхакерэн, ай э дракх кан дэл аврэндэ. Кай шунлэ адава, динэ бэбэря: — Мэ на овэл адава! ");
INSERT INTO rmn_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ай о Исус дикхляс карин лэндэ, пхэнляс: — Со си о зборэс э Яздимаски: «Бар, савэс читэ о бутярнэ, уло баро э угласко»? ");
INSERT INTO rmn_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Кажни, кон кан пэрэл опэр Одова Бар, кан хурдёл котора, ай опэр кастэ Ов кан пэрэл, одолэс кан тасавэл. ");
INSERT INTO rmn_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","О сикляримаря э Тхэдимаски тай о барэ попазя галилэ, кай о Исус пхукавдяс адава лэндар, оничин он манглэ одова вахыти тэ астарэн Лэс, ами трашанилэ катар дюняс. ");
INSERT INTO rmn_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Он лилэ лачес тэ дикхен пал Исус тай бичялдэ Лэстэ манушэн, савэ керэнаспэс чяче, мангенас би тэ астарэн Лэс збораса тай тэ дэн андэ барипэ ко пракуратори. ");
INSERT INTO rmn_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Одола пхучлэ э Исусес: — Сикляримарина, амэ джянас, кай Ту чячипэ пхэнэс тай сиклярэс. Ту на дикхес карин муя тай чячё сиклярэс дром э Дэвлэско. ");
INSERT INTO rmn_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Камэл амэнги тэ покинас налоги э императорески я на? ");
INSERT INTO rmn_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","О Исус дикхляс лэнго хохаипэ тай пхэнляс: ");
INSERT INTO rmn_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","— Сикавэн Манги динари. Каско си опрал муй, тай каско опрал нав? — Э императореско, — пхэнлэ он. ");
INSERT INTO rmn_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","— Дэн э императореско ко император, ай э Дэвлэско — ко Дэл, — пхэнляс Ов лэнги. ");
INSERT INTO rmn_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Он нащи астарэнас Лэс ангал дюняс нэ опэр савэ Лэски зборатэ, тай, шаштимэна Лэски зборэнги, тэныкисаилэ. ");
INSERT INTO rmn_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ко Исус пашылэ сарсавэ саддукея. Он пакянас, кай о мулэ на дживиндён. Он пхучлэ Лэс: ");
INSERT INTO rmn_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","— Сикляримарина, о Маисей язды амэнги, кастэ-то тэ муло пхрал, савэстэ сас ромни, ай на сас пуя, ов камэл тэ лэл э пхивля тай тэ дэл ла пуен андар пэ пхралэстэ. ");
INSERT INTO rmn_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Тай аки, сас эфта пхрала. О баштутно пхрал прандосаило тай муло бипуенго. ");
INSERT INTO rmn_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Дэчи о дуйто ");
INSERT INTO rmn_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ли о трито прандосаило опэр латэ, тай аякха алаи о эфта мулэ тай пуен на ачявдэ. ");
INSERT INTO rmn_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Дэчи мули ли э джювли. ");
INSERT INTO rmn_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Кана алаи кан дживиндён, каски ромни ой кан овэл? Вай ли эфтанги ромни сас? ");
INSERT INTO rmn_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","О Исус пхэнляс лэнги: — О мануша адалэ вахытеско прандозэн тай джян ромэстэ. ");
INSERT INTO rmn_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Одолэн, савэн кан гинэл о Дэл, кай он адава керэн тэ дживиндён андар мулэ тай тэ бэшэн околэ дюнястэ, на кан прандозэн тай на кан джян ромэстэ. ");
INSERT INTO rmn_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Вай тэ мэрэн он нащи, ами овэн сар миляикя. Он си о чявэ э Дэвлэски, вай он дживиндён. ");
INSERT INTO rmn_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ай одова, кай о мулэ дживиндён, сикавдяс о Маисей андэ пхукаипэ катар хлядяло тэрэки, кана ов пхэнляс э Сагбуски «О Дэл э Авраамеско, о Дэл э Исаакеско тай о Дэл э Яковеско». ");
INSERT INTO rmn_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ов о Дэл на э мулэнго, ами э дживиндэнго. Вай Лэски алаи дживиндэ! ");
INSERT INTO rmn_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Сарсавэ андар сикляримаря э Тхэдимаски пхэнлэ: — Лачё Ту пхэнлян, Сикляримарина! ");
INSERT INTO rmn_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Тай никхон пал отхэ на пхучелас Лэстар ништо. ");
INSERT INTO rmn_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Пал отхэ о Исус пхучляс лэндэ: — Соски пхэнэн, кай о Христос — О Чяво э Давидеско? ");
INSERT INTO rmn_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Вай о Давид пхэнляс андэ книжка ки Псаломенги: «Пхэнляс о Сагбус э Сагбуски минрэски: Бэш ко прави васт Мандар, ");
INSERT INTO rmn_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","бискай Мэ на керав Тэ душманен скамейка тал Тэ пинрэндэ». ");
INSERT INTO rmn_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Вай о Давид пхэнэлас Лэски «Сагбус». Сар дэчи Ов лэско Чяво? ");
INSERT INTO rmn_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Алаи о дюняс шунэлас э Исусес, ай Ов пхэнляс Пэ сиклярдэнги: ");
INSERT INTO rmn_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","— Сакёвэн асавке сикляримарендар ки Тхэдимаски, савэ дэхэн тэ урявэн дулгя савутя тай дэхэн, кана лэн дэн сэлями ко майдани. Он дэхэн тэ бэшэн ко лаче тхана андэ синагогя тай ко хабэнатэс. ");
INSERT INTO rmn_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Он хохаимаса лэн о кхера э пхивленги тай ангал якха ки манушэнги бут пхэнэн э Дэвлэски. Асавкен ишандиел зорало цындос. ");
INSERT INTO rmn_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","О Исус дикхелас, сар о барвалэ ченас пумарэ ловэ, савэ андэ э Дэвлэски, андэ сундуки ки храмеско. ");
INSERT INTO rmn_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ов дикхляс аякхажэ ли э чёрэ пхивля, сави читяс дуй капикес. ");
INSERT INTO rmn_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","— Пхэнав тумэнги чячес, — пхэнляс о Исус, — адая чёри пхивли тхэдяс бут алаендар. ");
INSERT INTO rmn_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Вай алаи дэнас пумарэ барвалимастар, ай ой пэ чёримастар тхэдяс алаи, со латэ сас бэшымаски. ");
INSERT INTO rmn_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Кана о мануша зборисаилэ катар храми, одолэстар, сар ов урявдо шукарэ барэнца тай барвалимаса э манушэнгерэса, кай андэ э Дэвлэски, о Исус пхэнляс: ");
INSERT INTO rmn_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","— Кан авэл вахыти, кана алаестар, со тумэ атхэ дикхен, на кан ачёл бар опрэ бар, алаи кан овэл хурдярдо. ");
INSERT INTO rmn_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Лэс пхучлэ: — Сикляримарина, кана адава кан овэл? Тай со сикаипэ кан сикавэл, кай пашол адава вахыти? ");
INSERT INTO rmn_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ов пхэнляс: — Дикхен, никхон тэ на хохавэл тумэн, вай бут кан авэн тал Мэ навэстэ, кан пхэнэн: «Адава Мэ» тай «О вахыти ало». Ма джян пал лэндэ. ");
INSERT INTO rmn_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Кана тумэ кан шунэн катар чингара тай кай ваздиндилэ дюнядэс, ма трашан. Адава алаи камэл тэ овэл буруни, ай о бытима кан овэл на чяльти. ");
INSERT INTO rmn_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","О Исус пхэнэлас: — О дюняс кан ваздиндёл опэр дюняс, о патишайлыки опэр патишайлыки. ");
INSERT INTO rmn_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Кан изравэл бут лачес э пху, сарсавэ тханэндэ кан овэл бокх тай насвалиматэс, кан овэн бут трашавнэ вахытя, тай кан сикавдён барэ сикаиматэс опрэ. ");
INSERT INTO rmn_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ай дага ангал отхэ, сар адава алаи кан овэл, тумэн кан астарэн тай кан кувдиен. Тумэн кан анэн андэ синагогя тай кан чен андэ пханля, кан тхэн ангал патишая тай ангал сагбудэс-пракураторя, тай алаи адава андар Мэ навэстэ. ");
INSERT INTO rmn_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Дэчи тумэндэ кан овэл вахыти тэ сикавэн тумаро пакяпэ. ");
INSERT INTO rmn_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Тай ма тюшундиен ангал одолэстар, со тумэнги тэ пхэнэн, тэ кутардиен тумэн, ");
INSERT INTO rmn_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","вай Мэ кан дав тумэн асавке зборэс тай асавки годи, кай никхон андар тумарэ душманендэ нащи кан пхэнэл я кан тэрдёл мамуй тумэндэ. ");
INSERT INTO rmn_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Тумэн кан пхукавэн джи тумарэ дада, дэя, пхрала, тухумя тай амала, тай сарсавэн андар тумэндэ кан мударэн. ");
INSERT INTO rmn_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Алаи на кан дэхэн тумэн андар Мэ навэстэ, ");
INSERT INTO rmn_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ай били екх бал на кан пэрэл тумарэ шэрэстар. ");
INSERT INTO rmn_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Даяндиен тай кан кутардиен тумаро бэшыпэ. ");
INSERT INTO rmn_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Кана тумэ кан дикхен о Иерусалими агорадимэ салдатенца, тэ джянэн, кай о вахыти лэски хурдяримаско пашэ. ");
INSERT INTO rmn_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Дэчи одола, кон си андэ Иудея, мэ нашэн андэ горадэс, кон си андэ диз — мэ нашэн андар латэ, кон си на андэ диз — мэ на джян андэ латэ, ");
INSERT INTO rmn_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","вай адава кан овэл о вахыти э покиндимаско, кана кан овэл алаи, со си яздимэ. ");
INSERT INTO rmn_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Касэвэти э насвалянги пуёстэ тай кон хавдярэн колиндэса андэ одола деса, вай баро джюнгалипэ кан авэл опэр адая пху, тай холи кан чёрдёл опэр адалэ дюнястэ. ");
INSERT INTO rmn_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","О мануша кан мэрэн катар камас, тай лэн кан гелэн пханлэн андэ алаи ко дюнядэс. О Иерусалими кан таптадиен о джятя мануша, тай аякха джи одолэ вахытески, бискай о вахыти лэнго на кан бытиел. ");
INSERT INTO rmn_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Опэр кхам, чюнут тай чергэня кан овэл сикаипэ, ай опэр пху о мануша кан овэн андэ израимастэ тай касэвэтестэ катар бэбэря ки бошы панеско. ");
INSERT INTO rmn_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Он кан овэн бизораки катар траш ангал хурдярдипэ, кай авэл опэр дюняс, тай джи опрунэ зора кан изран. ");
INSERT INTO rmn_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Тай дэчи о мануша кан дикхен э Чявэс э Манушыканэс, кай авэл опэр булутя зораса тай барэ намеса. ");
INSERT INTO rmn_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Кана адава кан лэл тэ овэл, ущен тай ваздэн тумарэ шэрэ, вай тумаро кутардипэ си пашэ. ");
INSERT INTO rmn_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Дэчи Ов пхукавдяс лэнги акасавко пхукаипэ: — Дикхен карин инжыри тай карин алаи ко тэрэкя. ");
INSERT INTO rmn_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Кана опэр лэндэ овэн патря, тумэ джянэн, кай пашол анкха милай. ");
INSERT INTO rmn_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Аякха ли атхэ, кана тумэ кан дикхен, кай адава овэл, дэчи джянэн, о Патишайлыки э Дэвлэско си пашэ. ");
INSERT INTO rmn_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Пхэнав тумэнги чячипэ: дага на кан бытиел о дюняс адалэ вахытеско, сар алаи адава кан овэл. ");
INSERT INTO rmn_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","О булутя тай э пху кан накхен, ай Мэ зборэс на кан накхен. ");
INSERT INTO rmn_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Дикхен, тумарэ илэски тэ на овэн пхаро катар пэскеритико бэшыпэ, матипэ тай катар бэшымаско касэвэти, тай адава дес тэ на астарэл тумэн бирдэн, ");
INSERT INTO rmn_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","сар капкани. Адава дес кан авэл опэр алаи ко мануша, кай бэшэн опэр алаи ки пху. ");
INSERT INTO rmn_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ма совэн тай манген э Дэвлэс, тай тумэ тэ овэн зоралэ, тэ на пэрэн андэ алаи адава, со камэл тэ овэл, тай тэ тэрдён ангал Чяво ко Манушыкано. ");
INSERT INTO rmn_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Кажын дес о Исус сиклярэлас андэ храми, ай бэлвэле джялас опэр Маслинэнго горас тай овэлас отхэ састи рат. ");
INSERT INTO rmn_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ай эртэс сабахтан о дюняс кидэласпэс андэ храми, тэ шунэн Лэс. ");
INSERT INTO rmn_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Пашолас мисяфири Писное Питэнго, кай бучёлас Пэсах. ");
INSERT INTO rmn_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","О барэ попазя тай о сикляримаря э Тхэдимаски родэнас, сар тэ мударэн э Исусес, ами трашанас катар дюняс. ");
INSERT INTO rmn_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Дэчи о Сатанас гело андэ Иуда, савэски пхэнэнас Искариот, о екх андар дэшудуй. ");
INSERT INTO rmn_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","О Иуда гело тай зборисаило э барэ попазенца тай э салдатенца андар храми, сар тэ дэл лэндэ э Исусес. ");
INSERT INTO rmn_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Одола лошасаилэ тай пхэнлэ, кай кан покинэн лэски. ");
INSERT INTO rmn_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","О Иуда пхэнляс лачё тай лиляс тэ родэл вахыти, кана э Исусеса на кан овэл дюняс, тэ пхукавэл Лэс. ");
INSERT INTO rmn_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Уло о дес э Писное Питэнго, кана камэлас тэ чинэн пэсахески бакрорэс, ");
INSERT INTO rmn_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","тай о Исус бичялдяс э Пётарэс тай э Иоаннес: — Джян тай гортярэн амэнги э пэсахеско хапэ. ");
INSERT INTO rmn_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","— Катэ Ту мангес, амэ тэ гортярас? — пхучлэ он. ");
INSERT INTO rmn_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ов пхэнляс: — Кана тумэ кан авэн андэ диз, кан дикхен манушэс, кай гелэл кхоро панеса. Джян пал лэстэ андэ кхер, катэ ов кан дэл, ");
INSERT INTO rmn_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","тай пхэнэн э сагбуски э кхерэскерэски: «О Сикляримари пхучел тут: \"Кай о тхан, катэ Мэ кан хав э пэсахеско хапэ Мэ сиклярдэнца?\"» ");
INSERT INTO rmn_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ов кан сикавэл тумэнги баро тхан андэ кхер опрэ, катэ си алаи гортярдо; отхэ да гортярэн хапэ. ");
INSERT INTO rmn_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Он гелэ, тай алаи уло аякха, сар пхэнляс лэнги о Исус, тай он гортярдэ э пэсахеско хапэ. ");
INSERT INTO rmn_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Кана ало о вахыти, о Исус тай Лэскерэ апостоля кидинэпэс пал конас. ");
INSERT INTO rmn_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","О Исус пхэнляс лэнги: — Мэ бут манглём тэ хав адава Пэсах тумэнца ангал Мэ хурлукестэ. ");
INSERT INTO rmn_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Пхэнав тумэнги, Мэ на кан хав генэ лэс джи одолэ вахытески, бискай ов на кан овэл андэ Патишайлыки ки Дэвлэско. ");
INSERT INTO rmn_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Лиляс о кадеи, мангляс андар лэстэ э Дэвлэс, Ов пхэнляс: — Лэн адава кадеи тай пиен андар лэстэ алаи. ");
INSERT INTO rmn_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Пхэнав тумэнги, кай Мэ на кан пияв катар имишы ки дракхако джи одолэ вахытески, бискай на кан авэл э Дэвлэско Патишайлыки. ");
INSERT INTO rmn_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Дэчи Ов лиляс о манро тай мангляс андар лэстэ э Дэвлэс, пхагердяс лэс тай диняс лэндэ зборэнца: — Адава си Мо тэни, дино андар тумэндэ. Керэн адава, кана тюшундиен Мандар. ");
INSERT INTO rmn_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Аякха лиляс ли о кадеи пал хапэ тай пхэнляс: — Адава кадеи — о нэво завети, колимэ Мэ ратэса, саво андар тумэндэ чёрдёл. ");
INSERT INTO rmn_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Аки, о васт одолэско, кон пхукавэл Ман, опэр екх конас Манца. ");
INSERT INTO rmn_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Э Чявэса э Манушыканэса алаи кан овэл аякха, сар сас пхэнло, ай касэвэти одолэ манушэски, саво кан пхукавэл Лэс. ");
INSERT INTO rmn_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Дэчи о сиклярдэ лилэ тэ пхучен екх аврэстэ, кон андар лэндэ би керэлас асавко. ");
INSERT INTO rmn_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Дэчи он лилэ тэ ирищиен, кон андар лэндэ камэл тэ овэл о баро. ");
INSERT INTO rmn_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","О Исус дэчи пхэнляс лэнги: — О патишая дюнядэс барярэнпэс опэр пумарэ манушэндэ, лэнги сагбудэнги пхэнэн, кай он керэн лэнги лачипэ, ");
INSERT INTO rmn_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","ай тумэ ма овэн, сар он. Ами мэ овэл алаендар о баро андар тумэндэ сар алаендар о тикно, тай о баро — сар иргати. ");
INSERT INTO rmn_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Вай кон баро: одова, кон овэл пал конас, я одова, кон керэл иргатлыки? Та со, на одова, кон бэшло? Ай Мэ машкарэ тумэндэ сар иргати. ");
INSERT INTO rmn_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Тумэ санусас Манца андэ алаи Мэ пхаримастэ, ");
INSERT INTO rmn_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","тай сар Мо Дад диняс Ман патишайлыки, аякха Мэ акана дав лэс тумэн, ");
INSERT INTO rmn_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","тумэ тэ хан тай тэ пиен пал Мэ конастэ андэ Мэ Патишайлыкестэ. Тумэ кан бэшэн пал ко троня тэ керэн цындос дэшудо породэнги э Израилескерэнги. ");
INSERT INTO rmn_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","— Симон, Симон, о Сатанас мангляс, тумэ тэ овэн зумавдэ тай шужардэ, сар о гив катар чёплики, ");
INSERT INTO rmn_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ай Мэ мангавас э Дэвлэс андар тутэ, тэ на нашавэс ту то пакяпэ. Тай кана ту кан авэс Мандэ палэ, зоралякер тэ пхралэн. ");
INSERT INTO rmn_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","О Пётар пхэнляс: — Сагбуса, мэ газыри тэ джяв Туса ли андэ пханли, ли ко мэрипэ! ");
INSERT INTO rmn_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ай о Исус пхэнляс: — Пхэнав туки, Пётар, дага о башно на кан дэл бэбэря авдес, сар ту тривал кан пхэнэс, кай на джянэс Ман. ");
INSERT INTO rmn_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Дэчи о Исус пхучляс лэндэ: — Кана Мэ бичялавас тумэн би кисяко, би гонэско, би минидэнго, на рэсэлас тумэнги со-то? — Алаи рэсэлас, — пхэнлэ он. ");
INSERT INTO rmn_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","— Анкха, тэ си тумэндэ киси, лэн ла, лэн ли о гоно, тай тэ нанай тумэндэ камас, дэчи бикнэн тумарэ савутя тай кинэн камас. ");
INSERT INTO rmn_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Пхэнав тумэнги, кай Манца камэл тэ овэл, сар си яздимэ: «Лэс гиндэ сар прахарес». Алаи, со Мандар сас яздимэ, генэ залаг тай кан овэл. ");
INSERT INTO rmn_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","О сиклярдэ пхэнлэ: — Дикх, Сагбуса, амэндэ си дуй камадэс. — Адава рэсэл, — пхэнляс о Исус. ");
INSERT INTO rmn_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","О Исус, сар екхараи керэлас, гело опэр Маслинэнго горас, тай Лэскерэ сиклярдэ гелэ Лэса. ");
INSERT INTO rmn_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Кана алэ ко тхан, о Исус пхэнляс: — Манген э Дэвлэс, тэ на зумавдён. ");
INSERT INTO rmn_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ов гело лэндар аборкхески, сар кай чен бар, тэрдило опэр кочендэ тай лиляс тэ мангел э Дэвлэс: ");
INSERT INTO rmn_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","— Дадэ, тэ мангес Ту, гел адава кадеи пашал Мандэ. Эй мэ овэл алаи на сар Мэ мангав, ами сар мангес Ту. ");
INSERT INTO rmn_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Дэчи опрал Лэски ало миляики тай зоралякерэлас Лэс. ");
INSERT INTO rmn_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Андэ хурлуки о Исус лиляс тэ мангел э Дэвлэс май лачес, тай кердяспэс Лэско тэри сар каплес ратэски, саво пэрэлас ки пху. ");
INSERT INTO rmn_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Кана Ов ущино тай ало ко сиклярдэ, аракхляс лэн сутэн, вай он сас кхинэ катар касэвэти. ");
INSERT INTO rmn_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","— Соски тумэ сутэ? — пхучляс лэн о Исус. — Ущен тай манген э Дэвлэс, тэ на зумавдён. ");
INSERT INTO rmn_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ов дага пхэнэлас, кана пашыло бут дюняс, ангал джялас одова, саво бучёлас Иуда, о екх андар дэшудуй. Ов пашыло ко Исус, тэ чюмидэл Лэс. ");
INSERT INTO rmn_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","О Исус пхэнляс лэски: — Иуда, ту чюмидимаса пхукавэс э Чявэс э Манушыканэс? ");
INSERT INTO rmn_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Кана одола, кон сас э Исусеса, дикхлэ, со кердёлпэс, он пхучлэ: — Сагбуса, ами тэ чялаваса камаса? ");
INSERT INTO rmn_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Тай о екх андар лэндэ чялавдяс э иргатес э барэ попазескерэс тай чиндяс лэско кан катар прави риг. ");
INSERT INTO rmn_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ай о Исус пхэнляс: — Тэрдярэн, овэл! Ов колисаило ко кан ки иргатеско тай састярдяс лэс. ");
INSERT INTO rmn_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Дэчи о Исус пхэнляс э барэ попазенги, э салдатенги андар храми тай э барэ манушэнги, савэ алэ пал Лэстэ: — Та со, Мэ прахари, кай тумэ алянус камадэнца тай дэстэнца? ");
INSERT INTO rmn_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Мэ алаи о деса сомас тумэнца андэ храми, тай тумэ на лилянус Ман. Ай анкха тумаро вахыти, анкха о барипэ э тэминако. ");
INSERT INTO rmn_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Он астардэ Лэс тай гелдэ андэ кхер ки барэ попазеско. О Пётар астарэласпэс сар дур, джялас пал лэндэ. ");
INSERT INTO rmn_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Машкарэ ки бар тхардэ яг, о Пётар екхетханэ аврэ манушэнца бэшло ки яг. ");
INSERT INTO rmn_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Екх андар иргатинкес дикхляс, сар о Пётар бэшло паш ки яг, лачес дикхляс карин лэстэ тай пхэнляс: — Адава мануш сас Лэса. ");
INSERT INTO rmn_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ай о Пётар пхэнляс: «На». — Мэ на джянав Лэс, джювлие, — пхэнляс ов. ");
INSERT INTO rmn_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Дэчи кон-то авэр дикхляс лэс тай пхэнляс: — Ту сан екх андар лэндэ. — На, мануша, — пхэнляс о Пётар. ");
INSERT INTO rmn_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Накхло генэ сагати, тай кон-то чячимаса пхэнляс: — Чячес, адава мануш сас Лэса, вай ов галилеяни. ");
INSERT INTO rmn_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ай о Пётар пхэнляс: — Мануша, мэ на джянав, состар ту пхэнэс! Тай одова вахыти, кана ов дага пхэнэлас, диняс бэбэря о башно. ");
INSERT INTO rmn_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","О Сагбус болдиняспэс тай дикхляс карин Пётар. Дэчи ко Пётар ало ки годи о зборэс э Сагбуски, сар Ов пхэнляс лэски: «Бискай дэл бэбэря о башно авдес, ту тривал кан болдэстут Мандар». ");
INSERT INTO rmn_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Тай никлисто о Пётар аври, ов лачес руно. ");
INSERT INTO rmn_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","О салдатя, кай дикхенас пал Исус, лилэ тэ асан Лэстар тай тэ марэн Лэс. ");
INSERT INTO rmn_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Он пхандэнас Лэски якха тай пхученас: — Прароки, пхэн, кон Тут чялавдяс? ");
INSERT INTO rmn_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Тай пхэнэнас Лэски бут авэра кушымаски зборэс. ");
INSERT INTO rmn_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Кана уло дес, о барэ мануша э дюняски, о барэ попазя тай о сикляримаря э Тхэдимаски кидинэпэс екхетханэ. Андэ э Исусес тай тхэдэ Лэс ангал синедриони. ");
INSERT INTO rmn_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","— Ту тэ сан о Христос, пхэн амэнги, — пхэнэнас он. О Исус пхэнляс: — Мэ тэ пхэнава тумэнги, тумэ на кан пакян. ");
INSERT INTO rmn_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ай Мэ тумэн тэ пхучява, тумэ Манги на кан пхэнэн. ");
INSERT INTO rmn_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Акана о Чяво о Манушыкано кан овэл бэшло катар прави васт катар Дэвлэски зор. ");
INSERT INTO rmn_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Он алаи лилэ тэ пхучен: — Та со, Ту о Чяво э Дэвлэско? Ов пхэнляс: — Тумэ пхэнэн, кай адава Мэ. ");
INSERT INTO rmn_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Дэчи он пхэнлэ: — Касавке генэ амэнги камэл сикаиматэс? Амэ шунлям адава андар Лэски уштэндэ! ");
INSERT INTO rmn_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Алаи ущинэ тай гелдэ э Исусес ко Пилат. ");
INSERT INTO rmn_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Отхэ он лилэ тэ керэн дошалэс Лэс: — Амэ галилям, кай Адава Мануш гелэл катар чячё дром амарэ дюняс. Ов на мукел тэ покинэн налогя э императорески тай пхэнэл, кай си Ов о Христос, Патишаи. ");
INSERT INTO rmn_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","О Пилат пхучляс ко Исус: — Ту о Патишаи э иудеенго? — Ту сам аякха пхэнэс, — пхэнляс о Исус. ");
INSERT INTO rmn_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Дэчи о Пилат пхэнляс э барэ попазенги тай э дюняски: — Мэ на гинав, кай адава Мануш си дошало. ");
INSERT INTO rmn_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ай он екхараи пхэнэнас пумаро: — Ов Пэ сикляримаса ваздэл э дюняс алаи ки Иудея, ханик ки Галилея, акана ало атхэ. ");
INSERT INTO rmn_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","О Пилат шунляс адава тай пхучляс: — Адава Мануш — галилеяни? ");
INSERT INTO rmn_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Кана ов галило, кай о Исус сас андар пху, сави сас тал барипэ ки Иродески, саво сас адава вахыти андэ Иерусалими, ов бичялдяс э Исусес лэстэ. ");
INSERT INTO rmn_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Кана о Ирод дикхляс э Исусес, бут лошасаило, вай чёктан мангелас Лэс тэ дикхел. Ов бут шунляс катар Исус тай ишандиелас, кай Одова кан сикавэл лэски саво-то сикаипэ. ");
INSERT INTO rmn_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ов пхучелас Лэстар бут, ай о Исус ништо на пхэнэлас. ");
INSERT INTO rmn_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Тэрдэ отхэ о барэ попазя тай о сикляримаря э Тхэдимаски, бут лачес керэнас дошалэс э Исусес. ");
INSERT INTO rmn_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","О Ирод тай лэски салдатя прасанас тай марэнас э Исусес, ай дэчи урявдэ опэр Лэстэ шукара савутя тай бичялдэ палэ ко Пилат. ");
INSERT INTO rmn_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Адава дес о Ирод тай о Пилат улэ амала, ай буруни сас душманя. ");
INSERT INTO rmn_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","О Пилат кидиняс э барэ попазен, э барэ манушэн тай дюняс, ");
INSERT INTO rmn_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","пхэнляс лэнги: — Тумэ андянус мандэ Адалэ Манушэс тай пхэнлянус, кай Ов ваздэл э дюняс. Мэ пхучлём Лэс ангал тумэндэ тай на аракхлём Лэс дошалэс андэ одолэстэ, андэ состэ тумэ Лэс керэн дошалэс. ");
INSERT INTO rmn_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ли о Ирод на аракхляс андэ Лэстэ нисави дош тай бичялдяс Лэс палэ амэндэ. Сар дикхен, Ов на кердяс ништо, кай камэл тэ мударэн. ");
INSERT INTO rmn_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Оничин мэ кан пхэнав тэ марэн Лэс, ай дэчи тэ мукен. ");
INSERT INTO rmn_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Дэчи алаи екхе сэсеса динэ бэбэря: — Мэрипэ Лэски! Мук амэнги э Вараввес! ");
INSERT INTO rmn_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","О Варавва сас бэшло андэ пханли, кай ваздиняс андэ диз чингар тай андар мударипэ. ");
INSERT INTO rmn_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","О Пилат мангелас тэ мукел э Исусес тай генэ екхвар лиляс тэ зборизэл лэнца. ");
INSERT INTO rmn_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ай он генэ дэнас бэбэря: — Опэр хачи Лэс, опэр хачи! ");
INSERT INTO rmn_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","О Пилат трито рази пхучляс лэн: — Со джюнгалипэ Ов кердяс? Мэ на аракхлём пал Лэстэ нисави дош, андар савятэ Ов камэл тэ мэрэл. Мэ кан пхэнав тэ марэн Лэс, тай дэчи кан мукав! ");
INSERT INTO rmn_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ай он май лачес дэнас бэбэря тай мангенас, о Исус тэ овэл мардо опэр хачи. Пумарэ бэбэряса он тхэдэ лэс тэ керэл, со манглэ. ");
INSERT INTO rmn_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","О Пилат пхэнляс, кай кан керэл аякха, сар он манглэ. ");
INSERT INTO rmn_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ов мукляс, сар он манглэ, одолэс, кон сас андэ пханли андар чингар тай андар мударипэ, ай э Исусес диняс андэ лэнги вастэндэ. ");
INSERT INTO rmn_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Кана э Исусес гелэнас, о салдатя астардэ э Симонэс андар Кирени, кай авэлас катар ливади, тхэдэ опэр лэстэ о хачи тай пхэнлэ тэ гелэл лэс пал Исус. ");
INSERT INTO rmn_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Машкарэ бутэ дюнястэ, кай джянас пал Исус, сас ли джювля, савэ марэнас пэс андэ колин тай ровэнас пал Лэстэ. ");
INSERT INTO rmn_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","О Исус болдиняспэс лэндэ тай пхэнляс: — Чяя Иерусалимески, ма ровэн Манги, ровэн зиядэ пал тумэндэ тай пал тумарэ пуендэ. ");
INSERT INTO rmn_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Авэл асавко вахыти, кана кан пхэнэн: «Бахталэ э бипуенги, савэндэ на аракхлилэ пуя, тай савэ на хавдярдэ колиндэса!» ");
INSERT INTO rmn_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Дэчи о мануша кан пхэнэн э горадэнги: «Пэрэн опэр амэндэ!» тай э бугоренги: «Учярэн амэн!» ");
INSERT INTO rmn_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Вай э тэрнэ тай зэлэнэ тэрэкеса тэ керэн асавко, ами дэчи со кан овэл э шукеса? ");
INSERT INTO rmn_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Э Исусеса гелэнас тэ мударэн до прахарен. ");
INSERT INTO rmn_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Кана он алэ ко тхан, кай бучёлас Черэпи, отхэ мардэ опэр хачи ли Лэс, ли э прахарен, э екхес ки екх риг, аврэс ки авэр риг Лэстар. ");
INSERT INTO rmn_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","О Исус пхэнэлас: — Дадэ, апувикер лэн, вай он на джянэн, со керэн. О салдатя читэ жреби тай паляштылар машкарэ пэстэ о савутя э Исусески. ");
INSERT INTO rmn_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","О дюняс сас тэрдо кай дикхен. О барэ мануша асанас Лэстар: — Кутардиелас аврэн! Мэ кутардиел акана Ов Пэс, тэ си Ов э Дэвлэса тхэдо о Христос! ");
INSERT INTO rmn_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ли о салдатя асанас катар Исус. Он дэнас Лэс шутло винас ");
INSERT INTO rmn_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","тай пхэнэнас: — Кутардие Тут, Ту тэ сан о Патишаи э иудеенго! ");
INSERT INTO rmn_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ай опэр Исус сас яздимэ: «Адава о патишаи э иудеенго». ");
INSERT INTO rmn_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","О екх андар мардо опэр хачи о прахари кушэлас Лэс, пхэнэлас: — Та со, Ту на сан о Христос? Кутардие Тут тай амэн! ");
INSERT INTO rmn_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Авэр тэрдярэлас лэс тай пхэнэлас: — Ту катар Дэл на трашас? Вай ли туки кердэ цындос тэ овэс опэр хачи. ");
INSERT INTO rmn_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Амэ мардэ андар амарэ дилэндэ, диндилям андар джюнгалимастэ, саво кердям. Ай Адава Мануш на кердяс ништо джюнгало. ");
INSERT INTO rmn_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Тай ов пхэнляс: — Исус, ма бристэр ман, кана кан авэс андэ Тэ Патишайлыкестэ! ");
INSERT INTO rmn_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","— Пхэнав туки чячипэ: авдес ту кан овэс Манца андэ раи, — пхэнляс лэски о Исус. ");
INSERT INTO rmn_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Сас десе паш ко дэшудуй сагатя, тай опэр алаи ки пху уло тэмина джи ко трин сагатя, ");
INSERT INTO rmn_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","вай о кхам тэминисаило. Э штора андэ храми пхаравдили ко машкар. ");
INSERT INTO rmn_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","О Исус лачес диняс бэбэря: — Дадэ, андэ Тэ вастэндэ дав Мо духос! Ов пхэнляс адава, диняс По тынышы тай муло. ");
INSERT INTO rmn_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Кана о баро, саво сас опэр шэлэндэ, алаи адава дикхляс, ов махтады э Дэвлэс тай пхэнляс: — Адава Мануш чячес сас чячё! ");
INSERT INTO rmn_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Тай алаи о дюняс, кай кидиняспэс тэ дикхел о мэрипэ, дикхляс, со уло, гело кхерэ тай марэлас пэс андэ колин. ");
INSERT INTO rmn_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Тай алаи, кон джянэлас э Исусес, ли о джювля, савэ джянас пал Лэстэ андар Галилея, тэрдэ дурал тай алаи дикхенас. ");
INSERT INTO rmn_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Отхэ сас лачё тай чячё мануш, савэско нав Иосиф. Ов сас екх андар синедриони, ");
INSERT INTO rmn_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ай ов на дэхэлас одова, со он пхэнэнас тай керэнас. О Иосиф сас андар Аримафея андэ Иудея тай ишандиелас э Дэвлэско Патишайлыки. ");
INSERT INTO rmn_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Адава мануш гело ко Пилат тай мангляс о тэни э Исусеско. ");
INSERT INTO rmn_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ов лиляс о тэни опрал хачи, пакярдяс лэс андэ лёнески басмадэс тай тхэдяс андэ склепи, кердо андэ горас, катэ дага никхас ангал атхэ на пароскердэ. ");
INSERT INTO rmn_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Адава сас о дес э гортяримаско ки суббота, саво авэлас. ");
INSERT INTO rmn_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Пал ко Иосиф гелэ джювля, савэ алэ э Исусеса андар Галилея. Он дикхлэ о склепи тай одова, кай о тэни э Исусеско сас тхэдо андэ. ");
INSERT INTO rmn_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Он алэ палэ, гортярдэ духыдэс тай олия, кай кхандэл шукар. Субботако он сас андэ рагати, сар пхэнэл о Тхэдипэ. ");
INSERT INTO rmn_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Эртэс сабахтан, андэ баштутно дес ки базареско, о джювля лилэ о гортярдэ олиес, кай кхандэн шукар, тай алэ ко склепи. ");
INSERT INTO rmn_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Он дикхлэ, кай о бар, саво пхандэлас о склепи, си пэравдо. ");
INSERT INTO rmn_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Динэ андэ, он на аракхлэ о тэни э Сагбуско э Исусеско. ");
INSERT INTO rmn_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Тэрдэ шаштимэна, он дикхлэ, кай паш лэндэ бирдэн улэ дуй мануша андэ савутендэ, савэ лэнаспэс, сар страпи. ");
INSERT INTO rmn_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Андэ траш о джювля муклэ пумарэ муя карин пху, ай одола пхэнлэ лэнги: — Со тумэ родэн э дживиндэс машкарэ мулэндэ? ");
INSERT INTO rmn_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Лэс атхэ нанай, Ов дживиндило! Тюшундиен, со Ов пхэнэлас тумэнги дага андэ Галилея: ");
INSERT INTO rmn_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","«О Чяво о Манушыкано камэл тэ овэл дино андэ васта ки бэзялэнги, тэ мардёл опэр хачи, тай андэ трито дес кан дживиндёл». ");
INSERT INTO rmn_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Дэчи лэнги алэ ки годи о зборэс э Исусески. ");
INSERT INTO rmn_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Алэ палэ катар склепи тай пхукавдэ алаестар э дэшуекхенги тай алаенги аврэнги. ");
INSERT INTO rmn_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Машкарэ одолэндэ, кон пхукавдяс адава э апостоленги, сас э Мария Магдалина, э Иоанна, э Мария э дай э Яковески, тай авэра джювля. ");
INSERT INTO rmn_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ай о апостоля на пакянилэ, со пхукавдэ о джювля, лэнги сикавдило, кай адава чюче зборэс. ");
INSERT INTO rmn_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ай о Пётар прастанило ко склепи. Ов бангило, дикхляс андэ тай дикхляс екх э лёнески басмадэс. Ов ало пэстэ кхерэ, шаштимэ алаестар, со уло. ");
INSERT INTO rmn_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Андэ одова дес о дуй андар сиклярдэ джянас андэ диз, сави бучёлас Эммаус, кай си паш ко дэшудуй вэрся катар Иерусалими, ");
INSERT INTO rmn_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","тай зборизэнас алаестар, со уло. ");
INSERT INTO rmn_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Тай кана он зборизэнас тай ирищиенас, бирдэн о Исус пашыло тай гело лэнца. ");
INSERT INTO rmn_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ай он сас сар корэ тай на пэнджярдэ Лэс. ");
INSERT INTO rmn_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","О Исус пхучляс лэн: — Состар адава тумэ зборизэн машкарэ тумэндэ опрэ дром? Он тэрдилэ касэвэтлыдэ монца. ");
INSERT INTO rmn_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","О екх андар лэндэ, савэско нав Клеопа, пхэнляс: — Ту, файма, андар алаендэ, кон ало андэ Иерусалими, сан екх, саво на джянэл одолэстар, со уло андэ адала деса. ");
INSERT INTO rmn_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","— Состар? — пхучляс Ов. — Одолэстар, со уло э Исусеса андар Назарет, — пхэнлэ он. — Ов сас прароки, зорало ангал Дэл тай ангал мануша зборэнца тай дилэнца. ");
INSERT INTO rmn_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Амарэ барэ попазя тай о барэ мануша кердэ цындос Лэски мэримаски тай мардэ опэр хачи. ");
INSERT INTO rmn_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ай амэ ишандиясас, кай Ов Одова, Кон камэл тэ кутардиел о Израиль. Ами аки, авдес трито дес, сар алаи адава уло. ");
INSERT INTO rmn_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Сарсавэ андар амарэ джювлендэ шаштэрдылар амэн. Он гелэ авдес эртэс сабахтан ко склепи ");
INSERT INTO rmn_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","тай на аракхлэ отхэ Лэско тэни, алэ палэ тай пхукавдэ амэнги, кай лэндэ алэ миляикя тай пхэнлэ, кай Ов дживиндо. ");
INSERT INTO rmn_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Дэчи сарсавэ андар амарэ амалэндэ гелэ ко склепи тай дикхлэ алаи, сар пхэнлэ о джювля, ай Лэс он на дикхлэ. ");
INSERT INTO rmn_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","О Исус пхэнляс лэнги: — Со тумэ дэнилэ, со тэмэли галён, тэ пакян алаески, со пхэнлэсас о прарокя! ");
INSERT INTO rmn_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Та со, на камэлас о Христос тэ накхел андар алаи адава хурлуки тай дэчи тэ джял андэ Пэ наместэ? ");
INSERT INTO rmn_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Тай лиляс катар Маисей тай алаи ко прарокя тэ галярэл лэнги, со сас пхэнло Лэстар андэ алаи ко Яздипэ. ");
INSERT INTO rmn_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Кана он пашонас ки диз, кай он джянас, о Исус кердяспэс, кай мангел тэ джял англэ, ");
INSERT INTO rmn_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ами он лилэ лачес тэ манген Лэс: — Ачё амэнца, вай бэлвэль си, о дес бытиел. Тай Ов диняс андэ кхер тай ачило лэнца. ");
INSERT INTO rmn_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Пал конас о Исус лиляс о манро, алгышты лэс, пхагердяс тай диняс лэндэ. ");
INSERT INTO rmn_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Дэчи лэнги якха пхутэрдилэ, тай он пэнджярдэ Лэс. Ами Ов уло асавко, кай на дикхиндёл лэнги. ");
INSERT INTO rmn_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Он лилэ тэ пхэнэн екх аврэски: — Та со, на тхаболас андэ амэндэ амарэ илэ, кана Ов зборизэлас амэнца опэр дром тай галярэлас амэнги о Яздипэ?! ");
INSERT INTO rmn_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Он ущинэ тай бирдэн гелэ палэ андэ Иерусалими. Отхэ он аракхлэ э дэшуекхен тай одолэн, кон эсас екхетханэ лэнца. ");
INSERT INTO rmn_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Одола пхэнлэ лэнги, со о Сагбус чячес дживиндило тай сикавдило э Симонэски. ");
INSERT INTO rmn_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Дэчи адала дуй пхукавдэ алаи, со уло лэнца опэр дром, тай одова, сар он пэнджярдэ э Исусес, кана Ов пхагерэлас о манро. ");
INSERT INTO rmn_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Кана он дага зборизэнас, о Исус сикавдяспэс машкарэ лэндэ тай пхэнляс: — Сэлями тумэнги! ");
INSERT INTO rmn_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Он шаштылар катар траш, тюшундиенас, кай дикхен духос. ");
INSERT INTO rmn_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ов пхэнляс лэнги: — Соски тумэ аякха санус трашавнэ? Соски андэ тумарэ илэндэ нанай пакяпэ? ");
INSERT INTO rmn_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Дикхен карин Мэ вастэндэ тай карин Мэ пинрэндэ. Вай адава Мэ! Колизэн Мандэ тай дикхен. Вай ко духи нанай нэ тэни, нэ кокала, ай Мандэ, сар дикхен, си. ");
INSERT INTO rmn_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ов пхэнляс адава тай сикавдяс лэнги Пэ васта тай Пэ пинрэ. ");
INSERT INTO rmn_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Он лошазэнас тай шаштиенас, ай дага нащи пакянас. Дэчи о Исус пхучляс лэн: — Тумэндэ атхэ си со-то тэ хав? ");
INSERT INTO rmn_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Он динэ Лэс котор пэко мачё. ");
INSERT INTO rmn_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ов лиляс тай халас ангал лэндэ. ");
INSERT INTO rmn_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","— Адалэстар Мэ пхэнавас тумэнги, кана сомас дага тумэнца, — пхэнляс Ов. — Алаи, со си яздимэ Мандар андэ Тхэдипэ ки Маисееско, ко Прарокя тай андэ Псаломя, камэл тэ овэл. ");
INSERT INTO rmn_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Дэчи Ов пхутэрдяс лэнги годя тэ галён о Яздипэ. ");
INSERT INTO rmn_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","— Яздимэ, кай о Христос камэл тэ накхел хурлуки тай ко трито дес тэ дживиндёл андар мулэ, — пхэнляс Ов лэнги. ");
INSERT INTO rmn_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","— Ханик андэ Иерусалими, ай дэчи алаи э дюнядэнги кан овэл пхукавдо, тай он андэ Лэско нав кан болдэнпэс пумарэ бэзендар, дэчи кан овэн лэнги муклэ о бэзя. ");
INSERT INTO rmn_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Тумэ гелэн адава габэри э манушэнги. ");
INSERT INTO rmn_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Мэ кан бичялав тумэнги одова, со Мо Дад пхэнляс, кай кан дэл тумэн. Ай бискай тумэ на кан урявэн зор опрал, ачён андэ диз. ");
INSERT INTO rmn_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Дэчи Ов никалдяс лэн андар диз джи ки Вифания, ваздиняс Пэ васта тай диняс алгышы лэн. ");
INSERT INTO rmn_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ай одова вахыти, сар Ов дэлас алгышы лэн, Ов лиляс тэ дурёл лэндар тай ваздиндило опрэ. ");
INSERT INTO rmn_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","О сиклярдэ пэлэ ки пху ангал Лэстэ тай барэ лошаса алэ палэ андэ Иерусалими, ");
INSERT INTO rmn_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","катэ екхараи сас андэ храми тай махтадиенас э Дэвлэс.");
INSERT INTO rmn_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Намлысана Феофил, андэ мэ баштутнэ пхукаимастэ мэ яздым алаестар, со о Исус керэлас тай со Ов сиклярэлас ");
INSERT INTO rmn_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","джи одолэ десески, кана андар Шужо Духос пхэнляс э тхэдэнги Лэса апостоленги, со он камэл тэ керэн, тай Ов сас линдо опрэ. ");
INSERT INTO rmn_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Пал Пэ хурлукестэ Ов уло ангал лэндэ дживиндо тай сикавдяс дилэнца, кай си адава чячипэ. Саранда дес о Исус авэлас лэндэ тай пхэнэлас катар Дэвлэско Патишайлыки. ");
INSERT INTO rmn_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Екхвар, кана о апостоля сас екхетханэ, Ов пхэнляс лэнги тэ на ачявэн о Иерусалими, ами тэ ишандиен, со пхэнлило сас э Дадэса. — Адава одова си, со тумэ шунлянус Мандар. ");
INSERT INTO rmn_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Вай о Иоанн болэлас панеса, ай тумэ пал набут дес кан овэн болдэ э Шужэ Духоса. ");
INSERT INTO rmn_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Одола кон сас отхэ, он лилэ тэ пхучен Лэс: — Сагбуса, та со, Ту мангес тэ керэс анкха о патишайлыки э Израилеско, сар сас буруни? ");
INSERT INTO rmn_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ов пхэнляс лэнги: — На тумари дила си тэ джянэн о вахыти тай о деса, савэ о Дад тхэдяс Пэ зораса. ");
INSERT INTO rmn_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ай кана опэр тумэндэ кан фулел о Шужо Духос, тумэ кан лэн зор тай Мандар кан пхукавэн андэ Иерусалими, алаи ки Иудея, андэ Самария тай джи ко чети ки пхуяко. ");
INSERT INTO rmn_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Кана Ов пхэнляс адава, ангал лэнги якхендэ сас ваздино опрэ, тай о булути гаравдяс Лэс лэнги якхендар. ");
INSERT INTO rmn_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Он доврус дикхенас опрэ, бискай Ов ваздиндёлас, сар бирдэн паш лэндэ улэ дуй мануша андэ парнэ савутендэ. ");
INSERT INTO rmn_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","— Галилеяня, — пхэнлэ он, — со тумэ санус тэрдэ кай дикхен опрэ? Адава о Исус, Саво сас линдо тумэндар опрэ, кан авэл палэ аякха, касавкес тумэ дикхлянус Лэс, сар Ов гело опрэ. ");
INSERT INTO rmn_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Пал отхэ он алэ андэ Иерусалими опрал горас, кай бучёлас Маслинэнго, сави сас надур катар диз, о дурипэ э дромэско, кай муклёлас тэ накхес субботако дес. ");
INSERT INTO rmn_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Он алэ андэ кхер тай ваздинэпэс опрэ, катэ он бэшэнас. Отхэ сас о Пётар тай о Иоанн, о Яков тай о Андрей, о Филипп тай о Фома, о Варфоломей тай о Матфей, о Яков, о чяво э Алфееско, о Симон Зилот тай о Иуда, о чяво э Яковеско. ");
INSERT INTO rmn_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Алаи он кидэнаспэс екхетханэ тэ зборизэн э Дэвлэса. Лэнца сас набут джювля, э дай э Исусески э Мария тай Лэски пхрала. ");
INSERT INTO rmn_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Андэ одола деса о Пётар ущино машкарэ ко пхрала ко пакялэ (отхэ сас шэлубиш мануша) тай пхэнляс: ");
INSERT INTO rmn_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","— Пхралалэн, камэлас тэ овэл, со си яздимэ, катэ о Шужо Духос пхэнляс андар Давид катар Иуда, саво гелэлас одолэн, савэ джянас тэ лэн э Исусес. ");
INSERT INTO rmn_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","О Иуда сас о екх андар амэндэ тай керэлас амэнца о хэзмэти э апостоленго. ");
INSERT INTO rmn_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Э ловэнги, савэ лиляс андар пэ канлыкестэ, ов киндяс ливади, ай аякха лачес пэло ки пху, лэстэ пхаро о пэр тай со сас андэ пэр никлисто аври. ");
INSERT INTO rmn_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Адалэстар галилэ алаи, кон бэшэлас ко Иерусалими, тай тхэдэ э ливади опэр пумарэ чибатэ Акелдама, самким «Ратэскири ливади».) ");
INSERT INTO rmn_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Вай андэ книжка ки Псаломенги си яздимэ: «Мэ овэл лэско кхер чючё, мэ на бэшэл никхон андэ» тай «Авэр мэ лэл лэско тхан». ");
INSERT INTO rmn_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Оничин амэнги камэл тэ лас екхес андар одолэ манушэндэ, савэ сас амэнца алаи одова вахыти, кана о Сагбус Исус сас машкарэ амэндэ, ");
INSERT INTO rmn_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","одолэ вахытестар, кана о Иоанн болдяс э Исусес, джи одолэ десески, кана о Исус сас линдо амэндар. Ов, сар амэ, камэлас тэ дикхел, кай Ов дживиндило. ");
INSERT INTO rmn_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Пхэнлэ дон: э Иосифес, савэски генэ пхэнэн Вар-Савва я Юст, тай э Матфиес. ");
INSERT INTO rmn_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Тай пхэнлэ э Дэвлэски: — Сагбуса, Ту джянэс о ило кажнеско. О Иуда ачявдяс э апостоленго хэзмэти тай гело отхэ, кай камэлас тэ джял. Сикав амэнги, кас андар адалэ дондэ ту тхэдян лэски тханэстэ. ");
INSERT INTO rmn_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Оничин он читэ жреби, тай пэло опэр Матфий, тай ов сас тхэдо ко дэшуекх апостоля. ");
INSERT INTO rmn_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Уло о дес э Пэиндако, тай алаи он сас екхетханэ. ");
INSERT INTO rmn_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Бирдэн опрал шунлило шуми, саво ушадиел зоралэ балваляки, саво пхэрдяс алаи о кхер, катэ он сас бэшлэ. ");
INSERT INTO rmn_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","О сиклярдэ дикхлэ со-то, кай ушадиел э ягаки чибэнги, савэ паляштыларпэс тай тэрдилэ по екх опэр кажнестэ андар лэндэ. ");
INSERT INTO rmn_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Алаи он пхэрдилэ Шужэ Духоса тай лилэ тэ зборизэн опэр аврэ чибэндэ: сар дэлас о Духос лэн тэ пхэнэн. ");
INSERT INTO rmn_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Андэ Иерусалими адава вахыти сас э Дэвлэски иудея андар алаи ко пхуя ки дюняски. ");
INSERT INTO rmn_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ко шуми кидинэпэс бут дюняс; о мануша шаштиенас, вай кажын андар лэндэ шунляс, сар окола зборизэнас опэр лэски чибатэ. ");
INSERT INTO rmn_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Он бут шаштиенас тай пхученас: — Та со, алаи адала мануша, савэ зборизэн, нанай галилеяня? ");
INSERT INTO rmn_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Сар адава кажни андар амэндэ шунэл лэн, кай зборизэн опэр амарэ чибатэ? ");
INSERT INTO rmn_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Машкарэ амэндэ си парфяня, мидяня, еламитя, одола, савэ бэшэн ки Месапатамия, Иудея тай Каппадокия, Понт тай э правинцыя Азия, ");
INSERT INTO rmn_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Фригия тай Памфилия, Египти, о тхана э Ливияке, савэ паш ко Кирени, одола, савэ бэшэн ко Рим, ");
INSERT INTO rmn_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","о иудея тай о празелитя, о критяня тай о арабя. Тай алаи амэ шунас, сар он пхэнэн катар барэ дилэс ки Дэвлэски опэр амарэ чибэндэ! ");
INSERT INTO rmn_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Он шаштиенас, на джянэнас сар адава тэ галён, тай пхученас екх аврэстэ: — Со си адава? ");
INSERT INTO rmn_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Сарсавэ асанас лэндар: — Он пилэ тэрно винас! ");
INSERT INTO rmn_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","О Пётар ущино екхетханэ аврэ э дэшуекхенца тай пхэнляс э манушэнги бэбэряса: — О мурша о иудея тай алаи, кон бэшэл ко Иерусалими! Тумэнги тэ овэл галярдо, шунэн лачес, со мэ кан пхэнав. ");
INSERT INTO rmn_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","О мануша адала нанай матэ, сар тумэ тюшундиен: анкха вай сабаги си, эня сагатя. ");
INSERT INTO rmn_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Адава овэн о зборэс, савэ пхэнляс о прароки о Иоиль: ");
INSERT INTO rmn_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","«Андэ бытимаски деса, — пхэнэл о Дэл, — Мэ кан чёрав о Духос Минро опэр алаи ко мануша. Тумарэ чявэ тай чяя кан пхэнэн сар прарокя, тумарэ тэрнагара кан дикхен дикхиматэс, тай тумарэ пхурэ кан дикхен прарочискя сунэ. ");
INSERT INTO rmn_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Джи опэр иргатя тай опэр иргатинкес Минрэндэ Мэ кан чёрав одола деса Мо Духос, тай он кан пхэнэн сар прарокя. ");
INSERT INTO rmn_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Мэ кан сикавав чюдэс опрэ тай знамениес тэлэ опэр пху: рат, яг тай бут тхув. ");
INSERT INTO rmn_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","О кхам кан калёл, ай о чюнут кан овэл ратвало, ангал отхэ, сар кан овэл баро тай махтадимэ дес э Сагбуско. ");
INSERT INTO rmn_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Тай кажни, кон кан дэл икос о нав э Сагбуско, кан овэл кутардимэ». ");
INSERT INTO rmn_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","О мурша о израильтяня, шунэн, со мэ тумэнги кан пхэнав. Барэ зоралэ дилэнца, чюдэнца тай сикаиматэнца, сар тумэ джянэн, о Дэл кердяс андар Исус тумэндэ ангал якха, о Дэл сикавдяс амэнги, кай о Мурш о Исус андар Назарет ало Лэстар. ");
INSERT INTO rmn_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Сар мангляс тай тюшунды о Дэл, тумэ мардянус Лэс, кана динянус Лэс андэ васта ко бэзялэ, савэ мардэ Лэс опэр хачи. ");
INSERT INTO rmn_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ай о Дэл дживиндярдяс Лэс, кутарды андар хурлуки ки мэримаско, тай ко мэрипэ на сас зор Лэс тэ астарэл. ");
INSERT INTO rmn_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","О Давид пхэнэл Лэстар: «Сальтя Мэ дикхавас э Сагбус ангал Мандэ: Ов катар прави васт Мандар — Мэ на кан кхелавдяв. ");
INSERT INTO rmn_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Оничин лошазэл о ило Минро, тай лошазэл э чиб, тай о тэни Минро кан бэшэл ишандимаса. ");
INSERT INTO rmn_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Вай Ту на кан мукес Мо духос андэ дюняс ки мулэнго тай на кан дэс Тэ Шужэс тэ овэл прахос. ");
INSERT INTO rmn_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ту сикавдян Манги о дрома э бэшымаски, Ту кан пхэрэс Ман лошаса ангал муй Тинрэстэ». ");
INSERT INTO rmn_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Пхралалэн, мукен ман тэ пхэнав тумэнги доврус, кай о папус Давид муло тай сас пароскердо. Лэско склепи си амэндэ джи авдес. ");
INSERT INTO rmn_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ов сас прароки тай джянэлас, кай о Дэл динясас збора совленца тэ тхэл лэски тронестэ екхес андар лэски породатэ, ");
INSERT INTO rmn_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ов дикхелас, со кан овэл, пхэнэлас катар дживиндипэ ки Христоско, кай Ов на сас ачявдо андэ дюняс ки мулэнго тай Лэско тэни на уло прахос. ");
INSERT INTO rmn_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Тай аки, о Дэл дживиндярдяс адалэ Исусес, тай амэ алаи адава дикхлям! ");
INSERT INTO rmn_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ов сас ваздино э Дэвлэски чяче вастэса тай лиляс катар Дад о Шужо Духос, саво Ов пхэнляс кай кан дэл, тай чёрдяс Лэс опэр амэндэ. Тай анкха тумэ адава дикхен тай шунэн. ");
INSERT INTO rmn_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Вай о Давид на ваздиндило опрэ, ами ов пхэнляс: «Пхэнляс о Сагбус э Сагбуски минрэски: Бэш ко прави васт Мандар, ");
INSERT INTO rmn_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","бискай Мэ на керав Тэ душманен скамейка тал Тэ пинрэндэ». ");
INSERT INTO rmn_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Оничин алаи о кхер э Израилеско мэ джянэл одова, кай Адалэ Исусес, Савэс тумэ мардянус ко хачи, о Дэл кердяс Сагбус тай Христос! ");
INSERT INTO rmn_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Кана о мануша шунлэ адава, лилэ пумарэ илэндэ. Он пхученас ко Пётар тай аврэ апостолен: — Пхралалэн, со амэ тэ керас? ");
INSERT INTO rmn_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","О Пётар пхэнляс: — Ачявэн тумарэ бэзя, тай кажни андар тумэндэ мэ овэл болдо андэ нав ки Исусеско Христоско. Дэчи о Дэл кан мукел тумэнги тумарэ бэзя тай кан башладиел тумэн о Шужо Духос. ");
INSERT INTO rmn_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Вай адава, кай пхэнлило, си тумэнги, тумарэ пуенги тай одолэнги, кон эси дур: алаенги, кон кан диндёл икос э Сагбуса, амарэ Дэвлэса. ");
INSERT INTO rmn_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Тай бут авэра зборэс о Пётар пхэнэлас лэнги: — Кутардиен тумэн адалэ гарами дюнястар. ");
INSERT INTO rmn_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Одола, савэ лилэ лэнги зборэс, болдэпэс. Одова дес улэ лэнца паш ко трин биня мануша. ");
INSERT INTO rmn_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Он зоралэс астарэнаспэс ко сиклярипэ ки апостоленго, он екхараи сас екхетханэ, пхагерэн о манро тай зборизэн э Дэвлэса. ");
INSERT INTO rmn_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Алаи сас пхэрдэ траш ангал Дэл, вай о апостоля керэнас бут чюдэс тай сикаиматэс. ");
INSERT INTO rmn_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Алаи, савэ пакянас э Дэвлэски, сас екхетханэ, тай алаи лэнго сас екхетханэ. ");
INSERT INTO rmn_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Он бикнэнас пумарэ мангина тай дэнас алаендэ, каски сокабор камэлас. ");
INSERT INTO rmn_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Кажын дес он кидэнаспэс андэ храми, ай ко кхера пхагерэнас о манро тай ханас лошаса тай ивашы илэса, ");
INSERT INTO rmn_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","махтадиенас э Дэвлэс, тай алаи андэ дюняс лэн дэхэнас. О Сагбус кажын дес бутярэлас одолэн кон эсас кутардимэ. ");
INSERT INTO rmn_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Екхвар андэ трито сагати, о вахыти, кана мангенас э Дэвлэс, о Пётар тай о Иоанн джянас андэ храми. ");
INSERT INTO rmn_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Андэ адава вахыти отхэ андэ манушэс, саво нащи пхерэлас, сар аракхлило. Лэс кажын дес ачявэнас ки бар, сави бучёлас Шукар, тай ов мангелас ловэ одолэндэ, кон дэлас андэ храми. ");
INSERT INTO rmn_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Кана ов дикхляс э Пётарэс тай э Иоаннес, савэ джянас андэ храми, ов мангляс ли лэндэ. ");
INSERT INTO rmn_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","О Пётар тай о Иоанн лачес дикхлэ карин лэстэ, тай о Пётар пхэнляс: — Дикх карин амэндэ! ");
INSERT INTO rmn_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","О мануш ваздиняс пэ якха, ишандиелас тэ лэл лэндар со-то. ");
INSERT INTO rmn_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ай о Пётар пхэнляс: — Руп тай пхол мандэ нанай, ами одова, со си, мэ дав тут. Андэ нав ки Исусеско Христоско андар Назарет — ущи тай пхер! ");
INSERT INTO rmn_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ов лиляс лэс катар прави васт, кердяс ярдыми тэ ущел, тай бирдэн о патума тай о тубукя э бангески зоралилэ. ");
INSERT INTO rmn_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ов читяспэс опэр чянгендэ тай лиляс тэ пхерэл. Ов диняс лэнца андэ храми, пхерэлас, челаспэс тай махтадиелас э Дэвлэс. ");
INSERT INTO rmn_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Тай алаи о мануша дикхенас лэс, кай пхерэл тай махтадиел э Дэвлэс. ");
INSERT INTO rmn_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Он ушатэрдиенас андэ лэстэ одолэ манушэс, саво бэшэлас тай мангелас ки Шукар бар ки храмески, тай шаштиенас одолэски, со лэса уло. ");
INSERT INTO rmn_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","О чёро астарэласпэс ко Пётар тай ко Иоанн, тай алаи о дюняс шаштимэ агорады лэн андэ одоя риг ки храмески, сави бучёлас колоннада э Саламонески. ");
INSERT INTO rmn_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Кана о Пётар адава дикхляс, ов пхэнляс э дюняски: — Израильтяня, соски тумэн адава аякха шаштэрдиел? Соски тумэ дикхен карин амэндэ аякха, уроди адава амэ амарэ зораса я шужымаса кердям, кай адава мануш пхерэл? ");
INSERT INTO rmn_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","О Дэл э Авраамеско, э Исаакеско тай э Яковеско, о Дэл амарэ дадэнго, махтады Пэ Иргатес э Исусес, Савэс тумэ пхукавдянус тай Савэстар болдинянус тумэн ангал Пилат, ай ов мангляс тэ мукел Лэс. ");
INSERT INTO rmn_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ай тумэ болдинянус тумэн катар Шужо тай Чячё, тай тумэ мангенас, тумэнги тэ мукен э мударимарес. ");
INSERT INTO rmn_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Тумэ мудардянус э Барэс э бэшымаскерэс, ай о Дэл дживиндярдяс Лэс андар мулэ, тай адава амэ дикхлям. ");
INSERT INTO rmn_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","О нав Лэско зоралякердяс адалэ манушэс, савэс тумэ дикхен тай джянэн, тай о пакяпэ, саво Лэстар, аиндэрды лэс ангал тумарэ якхендэ. ");
INSERT INTO rmn_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Пхралалэн, мэ галяв, кай тумэ тай тумарэ барэ мануша на джянэнас, со керэн. ");
INSERT INTO rmn_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Екх аякха о Дэл кердяс одова, со Ов пхэнлясас андар алаи ко прарокя, кана пхэнэлас, кай э Христоски кан камэл тэ дикхел хурлуки. ");
INSERT INTO rmn_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Акана, ачявэн тумарэ бэзя тай болдэн тумэн ко Дэл, тумарэ бэзя тэ овэн кхослэ, ");
INSERT INTO rmn_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","тай катар Сагбус тэ авэн вахытя рагатески тай Ов тэ бичялэл одолэс, саво камэл тэ авэл тумэндэ, — э Исусес Христос. ");
INSERT INTO rmn_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ай о Исус камэл тэ ачёл опрэ, бискай на кан авэл вахыти, кана о Дэл кан керэл алаи, савэстар Ов чёктан пхэнэлас андар Пэ шужэ прарокендэ. ");
INSERT INTO rmn_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Вай о Маисей пхэнляс: «Андар тумарэ пхралэндэ о Сагбус, тумаро Дэл, кан тхэл тумэнги прарокес, сар мэ. Тумэ камэл тэ шунэн Лэс андэ алаестэ, со Ов кан пхэнэл тумэнги. ");
INSERT INTO rmn_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Кажни, кон на кан шунэл одолэ Прарокес, кан овэл кувдимэ андар дюняс». ");
INSERT INTO rmn_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Алаи о прарокя, о Самуил тай алаи пал лэстэ, пхэнэнас адалэ десендар. ");
INSERT INTO rmn_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Вай тумэ — о чявэ э прарокенги тай э заветески, саво о Дэл диняс тумарэ дадэн. Ов пхэнляс э Авраамески: «Ти порода кан анэл алгышы алаи э дюняски опэр пху». ");
INSERT INTO rmn_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Кана о Дэл дживиндярдяс Пэ Иргатес, Ов ханик бичялдяс Лэс тумэндэ, тэ алгыштиел тумэн тай тэ пхэнэл кажнески андар тумэндэ тэ ачявэн тумарэ джюнгалэ дилэс. ");
INSERT INTO rmn_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Бискай о Пётар тай о Иоанн пхэнэнас э дюняски, лэндэ пашылэ о попазя, о баро опэр храмески салдатя тай о саддукея, ");
INSERT INTO rmn_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","савэ сас холямэна, кай он сиклярэн э дюняс тай пхукавэн одолэстар, кай булуб э Исусески о мануша кан дживиндён андар мулэ. ");
INSERT INTO rmn_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Он астардэ э Пётарэс тай э Иоаннес тай, кай сас бэлвэль, пханлэ лэн джи сабахтаняки. ");
INSERT INTO rmn_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","О бут, савэ шунлэ о Габэри, пакянилэ, тай о гиндипэ э пакялэнго барило джи ко пандж биня. ");
INSERT INTO rmn_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Авэр дес о сагбудэс э джемэятески, о барэ мануша тай о сикляримаря э Тхэдимаски кидинэпэс екхетханэ андэ Иерусалими. ");
INSERT INTO rmn_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Отхэ сас о баро попази о Аннас, о Кайафа, о Иоанн, о Александр тай алаи о мануша э породаки э барэ попазески. ");
INSERT INTO rmn_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Он тхэдэ э линдэн ко машкар тай лилэ тэ пхучен лэн: — Со зораса я каски навэстар тумэ кердянус адава? ");
INSERT INTO rmn_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Дэчи о Пётар сас пхэрдо э Шужэ Духоса тай пхэнляс лэнги: — О сагбудэс э дюняски тай о барэ мануша! ");
INSERT INTO rmn_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Тумэ тэ манген авдес амэндар тэ галярас катар лачипэ, саво амэ кердям э бангески, сар ов сас аиндимэ, ");
INSERT INTO rmn_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","тай тэ джянэн, тумэ тай алаи о дюняс э Израилеско: адава мануш анкха тэрдо ангал тумэндэ аиндимэ андар нав ки Исусеско Христоско андар Назарет, Савэс тумэ мардянус опэр хачи тай Савэс о Дэл дживиндярдяс андар мулэ! ");
INSERT INTO rmn_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","О Исус да си одова Бар, Саво сас чито тумэнца, бутярнэнца, тай Саво уло э угласко бар. ");
INSERT INTO rmn_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Андэ никхастэ аврэстэ кутардипэ нанай, вай нанай диндо манушэнги нисаво авэр нав опэр пху, савэса камэлас амэнги тэ кутардияс амэн. ");
INSERT INTO rmn_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","О мануша э Синедрионески дикхлэ о муршыпэ э Пётарэско тай э Иоаннеско тай галилэ, кай он мануша насиклярдэ тай иваша. Ай кана андэ лэндэ пэнджярдэ э сиклярдэн э Исусескерэн, лачес шаштылар. ");
INSERT INTO rmn_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ай он дикхенас, кай паш лэндэ сас тэрдо аиндимэ мануш, тай нащи ништо лэнги пхэнэнас. ");
INSERT INTO rmn_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Дэчи он пхэнлэ лэнги тэ ачявэн о Синедриони тай лилэ тэ зборизэн машкарэ пэстэ. ");
INSERT INTO rmn_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","— Со амэнги тэ керас адалэ манушэнца? — пхэнэнас он. — Алаи, кон бэшэл андэ Иерусалими, джянэн, кай он кердэ бари чюда, тай амэ нащи пхэнас, кай на кердэ. ");
INSERT INTO rmn_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","О габэри адалэстар тэ на шунлёл май буглэс машкарэ ко дюняс, эла трашавас лэн, он тэ на пхукавэн никхаски адалэ навэстар. ");
INSERT INTO rmn_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Он динэ икос лэн тай пхэнлэ лэнги никхаски тэ на пхэнэн тай тэ на сиклярэн андэ нав ки Исусеско. ");
INSERT INTO rmn_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ай о Пётар тай о Иоанн пхэнлэ лэнги: — Тюшундиен тумэ, лачё ангал Дэл тэ шунас тумэн бут, ниш э Дэвлэс? ");
INSERT INTO rmn_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Вай нащи амэ тэ овас тэныки одолэстар, со амэ дикхлям тай шунлям. ");
INSERT INTO rmn_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","О мануша э Синедрионески холясаилэ лэнги генэ екхвар тай муклэ, вай на аракхлэ ништо, андар состэ тэ марэн лэн ангал дюняс, вай алаи о мануша махтадиенас э Дэвлэс андар одолэстэ, со уло. ");
INSERT INTO rmn_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Э манушэски, савэса ули адая чюда аиндимаски, сас бут саранда брэшэндар. ");
INSERT INTO rmn_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Кана э Пётарэс тай э Иоаннес муклэ, он алэ пумарэндэ тай пхукавдэ лэнги алаестар, со лэнги пхэнэнас о барэ попазя тай о барэ мануша. ");
INSERT INTO rmn_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Кана о пакялэ адалэстар шунлэ, он екхетханэ ваздинэ по сэси ко Дэл тай пхэнлэ: — Барэя! Ту кердян, со си опрэ, э пху, э моря тай алаи, со андэ лэндэ. ");
INSERT INTO rmn_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ту пхэнлян э Шужэ Духоса андар ушта амарэ дадэскерэндар тай Тэ иргатескерэндар ки Давидески: «Соски холязэн о дюнядэс тай о мануша тюшундиен чючё? ");
INSERT INTO rmn_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ваздиндилэ э пхуяки патишая, тай о сагбудэс кидинэпэс екхетханэ мамуй ко Сагбус тай мамуй Лэски Христостэ». ");
INSERT INTO rmn_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Вай чячес улэ екхетханэ андэ адалэ дизатэ о Ирод тай о Понтий Пилат э наиудеенца тай э манушэнца э Израилескерэнца мамуй Тэ шужэ Иргатестэ ко Исус, Савэс Ту макхлян. ");
INSERT INTO rmn_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Он кердэ одова, со Ту чёктан тюшундын тэ керэс Тэ зораса тай Тэ мангимаса. ");
INSERT INTO rmn_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Тай анкха, Сагбуса, дикх карин лэнги трашаимастэ тай дэ Тэ иргатен би трашако тэ пхукавэн Ти збора. ");
INSERT INTO rmn_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Сидэ о васт Тинро тай аиндэрдие э насвалэн, кер сикаипэ тай чюдэс э навэса Тэ шужэ Иргатескерэса э Исусеса! ");
INSERT INTO rmn_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Тай кана он манглэ э Дэвлэс, о тхан, катэ он эсас, изранило, тай он эсас пхэрдэ Шужо Духос тай битрашако пхукавэнас э збора э Дэвлэски. ");
INSERT INTO rmn_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Алаи, савэ пакянилэ, сас екхе илэса тай тынышэса. Никхон на гинэлас, кай лэско мангин си екх лэско, ами алаи лэндэ эсас екхетханэ. ");
INSERT INTO rmn_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","О апостоля барэ зораса пхукавэнас катар дживиндипэ ки Сагбуско Исусеско, тай о Дэл пхэрэлас алаен Пи бари мила. ");
INSERT INTO rmn_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Машкарэ лэндэ на сас били екх чёро, вай одола, кастэ сас пхуя тай кхера, бикнэнас лэн, анэнас э бикинимаски ловэ ");
INSERT INTO rmn_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","тай тхэнас ко пинрэ ки апостоленги. Адала ловэ палящиенас кажнески одолэски, со камэл. ");
INSERT INTO rmn_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Аки, о Иосиф, савэс о апостоля тхэдэ Варнава (адава си «чяво рагатеско»), о левити катар Кипр, ");
INSERT INTO rmn_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","бикиндяс пи ливади, андяс о ловэ тай тхэдяс ко пинрэ ки апостоленги. ");
INSERT INTO rmn_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Екх мануш, савэско нав Анания, екхетханэ пэ ромняса э Сапфираса, бикиндяс по мангин ");
INSERT INTO rmn_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","тай паи э ловэнго мукляс пумэнги. Лэски ромни джянэлас адалэстар. Ай со ачило, ов андяс тай тхэдяс ко пинрэ ки апостоленги. ");
INSERT INTO rmn_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","О Пётар пхэнляс лэски: — Анания, соски муклян э Сатанас андэ тэ илэстэ, пхэнлян начячипэ э Шужэ Духоски тай гаравдян туки андар ловэ ки ливадяки? ");
INSERT INTO rmn_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Вай э пху джи одолэски, сар ту ла бикиндян, сас тинри, тай о ловэ, савэ лаки лилян, си тинрэ. Соски ту тюшундын асавко? Ту пхэнлян начячипэ на э манушэнги, ами э Дэвлэски. ");
INSERT INTO rmn_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Сар о Анания шунляс адала зборэс, ов пэло, диняс по тынышы. Алаи, кон шунляс адалэстар, лачес трашанилэ. ");
INSERT INTO rmn_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Пашылэ тэрнэ мануша, пакярдэ лэско тэни, никалдэ тай пароскердэ. ");
INSERT INTO rmn_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Тринэ сагатендар али лэски ромни. Ой ништо на джянэлас, со уло. ");
INSERT INTO rmn_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","О Пётар пхучляс ла: — Пхэн манги, тумэ тэ ромэса асавки кими бикиндянус э ливади? — Ва, — пхэнляс ой, — асавки. ");
INSERT INTO rmn_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","О Пётар пхэнляс лаки: — Со адава тумэ зборисаилянус тэ зумавэн о Духос э Сагбуско? Ту шунэс, кай пхерэн паш удар? Адава авэн одола, савэ пароскердэ тэ ромэс. Он ли тут кан никалэн. ");
INSERT INTO rmn_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Тай одова сагати ой пэли лэски пинрэндэ тай диняс по тынышы. Тэрнэ мануша алэ, дикхлэ ла муля, никалдэ ла тай пароскердэ ла паш ко ром. ");
INSERT INTO rmn_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Алаен э кхангерен тай алаи э манушэн, кон адалэстар шунляс, лиляс бари траш. ");
INSERT INTO rmn_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Андар васта ки апостоленги андэ дюняс кердёлас бут сикаиматэс тай чюдэс. Алаи о пакялэ кидэнаспэс екхетханэ андэ колоннада ки Саламонески. ");
INSERT INTO rmn_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Тай авэра мануша трашанас тэ овэн паш лэндэ, ай о дюняс лэн бут гинэлас. ");
INSERT INTO rmn_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Одолэн, кай пакян э Сагбуски, овэнас май бут тай бут, ли э муршэн, ли э джювлен. ");
INSERT INTO rmn_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","О мануша никалэнас аври э насвалэн, тхэнас лэн опэр насилкес тай матразя, хоч о тени э Пётарэско тэ пэрэл опэр лэндэ, кана ов кан накхел пашал. ");
INSERT INTO rmn_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Тай андар диза, кай сас паш ко Иерусалими, авэнас бут дюняс. Он анэнас э насвалэн тай одолэн, андэ савэндэ сас бишужэ духя, тай алаи аиндиенас. ");
INSERT INTO rmn_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","О баро попази тай алаи лэски мануша, савэ сас андар джемэяти ки саддукиенго, сас пхэрдэ кизгандилима. ");
INSERT INTO rmn_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Он лилэ э апостолен тай пханлэ лэн андэ дюняски пханли. ");
INSERT INTO rmn_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ай рати о миляики э Сагбуско пхутэрдяс э бар э пханляки тай никалдяс лэн. ");
INSERT INTO rmn_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","— Джян, тэрдён андэ храми, — пхэнляс ов, — тай пхэнэн э манушэнги алаи адалэ нэвэ бэшымастар. ");
INSERT INTO rmn_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Он шунлэ, алэ эртэс сабахтан андэ храми тай лилэ тэ сиклярэн. Кана ало о баро попази тай лэски мануша, он динэ икос о Синедриони тай алаи э барэ манушэн э Израилескерэн тай бичялдэ ки пханли пал апостоля. ");
INSERT INTO rmn_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ай кана о иргатя алэ андэ пханли, он на аракхлэ лэн отхэ. Он алэ палэ тай пхукавдэ: ");
INSERT INTO rmn_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","— Амэ дикхлям, кай э пханляки бар лачес пханли, ай ки бар сас тэрдэ салдатя. Ай кана амэ диням андэ, амэ никхас отхэ на аракхлям. ");
INSERT INTO rmn_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Кана о баро опэр храмески салдатя тай о барэ попазя шунлэ лэн, он лачес шаштылар тай на джянэнас, сар адава тэ галён. ");
INSERT INTO rmn_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Дэчи кон-то ало тай пхэнляс лэнги: — Аки, дикхен, мануша, савэн тумэ пханлянус андэ пханли, тэрдэ андэ храми тай сиклярэн э дюняс. ");
INSERT INTO rmn_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Дэчи о баро опэр салдатя гело э иргатенца тай андяс э апостолен. Он би зорако лилэ лэн, вай трашанас, кай о дюняс кан марэл лэн барэнца. ");
INSERT INTO rmn_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Э апостолен андэ тай тхэдэ ангал Синедриони. О баро попази пхэнляс лэнги: ");
INSERT INTO rmn_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","— Амэ тумэнги холяса пхэнлям тэ на сиклярэл адалэ навэстар, ай тумэ алаи о Иерусалими пхэрдянус тумарэ сикляримаса тали дошалэн керэн амэн, кай муло Адава Мануш. ");
INSERT INTO rmn_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","О Пётар тай авэра апостоля пхэнлэ: — Амэ камэл бут тэ шунас э Дэвлэс, ниш э манушэн! ");
INSERT INTO rmn_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","О Дэл амарэ дадэнго дживиндярдяс э Исусес, Савэс тумэ илдынус опэр хачи тай мудардянус. ");
INSERT INTO rmn_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ай о Дэл ваздиняс Лэс тай бэшавдяс катар прави васт Пэстар сар Барэс тай Кутардимарес, о Израиль тэ ачявэл пэ бэзя тай о Дэл тэ апувикерэл лэн. ");
INSERT INTO rmn_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Амэ адава алаи дикхлям. Тай екхетханэ амэнца о Шужо Духос, Савэс о Дэл диняс одолэн, кон шунэл Лэс. ");
INSERT INTO rmn_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Кана одола, кон эсас отхэ, шунлэ адава, он холясаилэ тай манглэ тэ мударэн лэн. ");
INSERT INTO rmn_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Тай дэчи ущино екх андар Синедриони, фарисеи, кай бучёлас Гамалиил, о сикляримари э Тхэдимаско, гиндо алаи э дюняса. Ов пхэнляс тэ гелэн э апостолен савэ-то вахытески. ");
INSERT INTO rmn_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Дэчи ов пхэнляс: — Израильтяня, лачес тюшундиен одолэстар, со тумэ кидэнтумэн тэ керэн адалэ манушэнца. ");
INSERT INTO rmn_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","На чёктан ало атхэ о Февда, кердяс пэс саво-то намлыс. Пал лэстэ гело паш ко штаршэл мануша, ай кана ов сас мудардо, дэчи алаи, кон джялас пал лэстэ, нашлэ кон кай, тай алаи быты би ништоско. ");
INSERT INTO rmn_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Пал лэстэ сас о галилеяни о Иуда. Ов ало о вахыти, кана сас о яздипэ, тай гелдяс э дюняс пал пэстэ. Ли ов муло, тай лэски мануша нашлэ, кон кай. ");
INSERT INTO rmn_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Оничин анкха пхэнав тумэнги: ма астарэн адалэ манушэн. Мукен лэн. Тэ си одоя дила, со манген он тэ керэн, манушыкани, ой кан пэрэл. ");
INSERT INTO rmn_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Тэ си ой катар Дэл, тумэ нащи лэн кан тэрдярэн, ами тумэ кан овэн душманя э Дэвлэски. Он пакянилэ лэски зборэнги. ");
INSERT INTO rmn_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Он андэ э апостолен тай пхэнлэ лэн тэ марэн. Вай он генэ екхвар пхэнлэ лэнги тэ на пхэнэн катар нав ки Исусеско тай муклэ лэн. ");
INSERT INTO rmn_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","О апостоля гелэ андар Синедриони лошанэ одолэски, кай лэнца уло асавко ладжяво андар нав ки Исусеско. ");
INSERT INTO rmn_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Тай кажын дес андэ храми тай андэ кхера он на тэрдёнас тэ сиклярэн тай тэ пхукавэн о Лошано Габэри катар Исус Христос. ");
INSERT INTO rmn_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Андэ адала деса, кана о гиндипэ э сиклярдэнго лиляс тэ барёл, о эллинистя лилэ тэ ровэнпэс опэр еврея. Он пхэнэнас, кай одола бристэнас лэнги пхивлен, кана дагытиенас кажын дес о хапэ. ");
INSERT INTO rmn_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Дэчи о Дэшудуй динэ икос алаи э сиклярдэн тай пхэнлэ: — Нанай лачё амэнги тэ ачявас э бути э збораки э Дэвлэскеряки тай тэ ласамэн э бутяса э конадэнгеряса. ");
INSERT INTO rmn_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Оничин, пхралалэн, лэн андар тумарэндэ эфта манушэн лаче намеса тай пхэрдэ Духоса тай годявэримаса, тай амэ кан тхас опэр лэндэ адая дила. ");
INSERT INTO rmn_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ай амэ генэ кан мангас э Дэвлэс тай кан керас э бути э збораки. ");
INSERT INTO rmn_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Адая дила алаи дэхлэ, тай тхэдэ э Стэфанес, манушэс, пхэрдо пакямаса тай Шужэ Духоса, э Филиппес, э Прохорес, Никанорес, Тимонэс, Парменэс тай Никалаес, о празелитес андар Антиохия. ");
INSERT INTO rmn_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Лэн тхэдэ ангал апостоля, тай одола манглэ э Дэвлэс тай тхэдэ опэр лэндэ пумарэ васта. ");
INSERT INTO rmn_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Э збора э Дэвлэски джялас, тай о гиндипэ э сиклярдэнго андэ Иерусалими чяльти бутёлас, джи о бут попазя пакянилэ. ");
INSERT INTO rmn_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","О Стэфан, мануш, пхэрдо Дэвлэски лачимаса тай зораса, керэлас андэ дюняс барэ чюдэс тай сикаиматэс. ");
INSERT INTO rmn_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Э Стэфанеса лилэ тэ ирищиен сарсавэ мануша андар синагога, сави бучёлас Синагога э Муклэнги. Отхэ генэ пхерэнас о киренца тай о александрийца, тай генэ о мануша андар Киликия тай андар правинцыя Азия. ");
INSERT INTO rmn_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ай он ништо нащи кердэ мамуй э годявэримаски тай э зораки Духоски, савэнца пхэнэлас о Стэфан. ");
INSERT INTO rmn_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Дэчи он сиклярдэ сарсавэ манушэн тэ пхэнэн: «Амэ шунлям, сар о Стэфан пхэнэлас хохаимаски зборэс катар Маисей тай катар Дэл». ");
INSERT INTO rmn_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Он ваздинэ э дюняс, э барэн тай э сикляримарен э Тхэдимаскерэн. Он пэлэ опэр Стэфан, астардэ лэс тай сюрюдылар андэ Синедриони. ");
INSERT INTO rmn_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Отхэ он тхэдэ хохавнэ манушэн, савэ пхэнлэ: — Адава мануш екхараи пхэнэл мамуй ко шужо храми тай мамуй ко Тхэдипэ. ");
INSERT INTO rmn_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Амэ шунлям, сар ов пхэнэлас, кай о Исус андар Назарет кан хурдярэл адава храми тай кан паровэл о тхэдипэ, саво диняс амэн о Маисей. ");
INSERT INTO rmn_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Алаи, кон бэшэлас андэ Синедриони, лачес дикхенас карин Стэфан, кай о муй лэско уло, сар муй миляикеско. ");
INSERT INTO rmn_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Дэчи о баро попази пхучляс э Стэфанес: — Адава аякха? ");
INSERT INTO rmn_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","О Стэфан пхэнляс: — Пхралалэн тай дадалэн! Шунэн ман. О Дэл э намеско сикавдяс Пэс амарэ дадэски э Авраамески, кана ов бэшэлас дага андэ Месапатамия, ангал отхэ, сар ов ало андэ Харран. ");
INSERT INTO rmn_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","«Ачяв ти пху тай тэ тухумен, — пхэнляс Ов лэски, — тай джя ки пху, сави Мэ туки кан сикавав». ");
INSERT INTO rmn_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Озаман о Авраам ачявдяс э пху э халдеенги тай ало андэ Харран. Отхар, пал ко мэрипэ лэски дадэскерэстэ, о Дэл андяс э Авраамес андэ адалэ пхуятэ, андэ савятэ тумэ анкха бэшэн. ");
INSERT INTO rmn_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ов на диняс лэс пху джи тикноро котор. Ай о Дэл диняс збора, кай Ов кан дэл адая пху лэстэ тай лэски пуендэ, ай одова вахыти ко Авраам на сас пуёс. ");
INSERT INTO rmn_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","О Дэл пхэнляс лэски: «Тэ пуя кан овэн джятя андэ джяти пху; он кан овэн динэ андэ иргатлыки тай кан сидэн хурлуки штаршэл брэш. ");
INSERT INTO rmn_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ай Мэ кан марав э дюняс, саво кан керэл лэн иргатен, — пхэнляс о Дэл. — Тай дэчи он кан никлён отхар тай кан керэн бути Манги адалэ тханэстэ». ");
INSERT INTO rmn_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Дэчи Ов диняс э Авраамес завети абрезанияко. О Авраам уло о дад э Исаакеско тай кердяс лэски абрезания ко охтото дес, сар аракхлило, о Исаак уло о дад э Яковеско, ай о Яков — дэшудо патриарховенго. ");
INSERT INTO rmn_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","О патриархя катар кизгандилима бикиндэ Иосифес андэ Египти. Ай о Дэл сас лэса ");
INSERT INTO rmn_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","тай кутарды лэс катар алаи ко хурлуки. Ов диняс э Иосифес мила тай годявэрипэ ангал якха ко фараони, о патишаи э Египтеско. Одова кердяс э Иосифес сагбус алаи э Египтеско тай алаи пэ кхерэско. ");
INSERT INTO rmn_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Пал отхэ андэ Египти тай андэ Ханаан ули бокх тай баро хурлуки, тай амарэ дада нащи аракхенас хапэ. ");
INSERT INTO rmn_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Кана о Яков шунляс одолэстар, кай андэ Египти си гив, ов бичялдяс отхэ амарэ дадэн екхвар. ");
INSERT INTO rmn_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Кана он алэ дувар, о Иосиф пхутэрдяспэс пэ пхралэнги, тай о фараони галило катар тухумя ки Иосифески. ");
INSERT INTO rmn_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Пал отхэ о Иосиф бичялдяс пал пэ дадэстэ пал Яков тай пал алаи пэ тухумендэ, савэ гиндёнас эфтадэша пандж мануша. ");
INSERT INTO rmn_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","О Яков ало тэ бэшэл ко Египти, катэ муло ли ов, ли амарэ дадэнги дада. ");
INSERT INTO rmn_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","О тэня сас гелдэ андэ Шэхем тай тхэдэ андэ склепи, саво о Авраам киндяс рупаки ко чявэ ки Хаморески андэ Шэхем. ");
INSERT INTO rmn_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Сар пашолас о вахыти тэ овэл о пхэнлипэ, дино э Дэвлэса э Авраамес, барёлас о гиндипэ амарэ дюняско андэ Египти. ");
INSERT INTO rmn_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Аякха сас, бискай андэ Египти на бэшло опэр трони авэр патишаи, саво на джянэлас катар Иосиф. ");
INSERT INTO rmn_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ов сас ярамази амарэ тухуменца тай керэлас джюнгалипэ амарэ дадэнги: ов тхэлас лэн тэ чен э пуен, савэ аракхлилэ, тэ мэрэн одола. ");
INSERT INTO rmn_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Андэ адава вахыти аракхлило о Маисей, шукар ангал Дэл. Трин чён лэс хавдярэнас андэ дадэско кхер, ");
INSERT INTO rmn_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ай кана камэлас лэс тэ дэн, лэс лиляс э чяй э фараонески тай барярдяс, сар пэ чявэс. ");
INSERT INTO rmn_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","О Маисей сас сиклярдо алаи э египтеско годявэрипэ; ов сас зорало ли андэ збора, ли андэ дила. ");
INSERT INTO rmn_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Кана лэски сас саранда брэш, ов мангляс тэ дикхел пэ пхралэн израильтянен. ");
INSERT INTO rmn_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Екхвар ов дикхляс, кай екхес андар лэндэ хорладиел о египтяни, ов сыкылды тай андар пахылыки мудардяс лэс. ");
INSERT INTO rmn_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","О Маисей тюшунды, лэски пхрала кан галён, кай о Дэл лэски вастэнца дэл лэн кутардипэ, ай он на галилэ. ");
INSERT INTO rmn_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Авэр дес о Маисей дикхляс, сар дуй израильтяня марэнпэс. Ов мангляс тэ аклаштиел лэн. «Муршалэн, вай тумэ пхрала, — пхэнэлас ов. — Соски хорладиен екхаврэс?» ");
INSERT INTO rmn_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Дэчи о мануш, саво марэлас пэ комшус, диняс бутуря э Маисеес тай пхэнляс: «Кон тхэдяс тут барэс тай цындомарес опэр амэндэ? ");
INSERT INTO rmn_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Я ту мангес тэ мударэс ли ман, сар ич мудардян э египтянес?» ");
INSERT INTO rmn_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","О Маисей шунляс асавке зборэс, нашло тай ало андэ пху Мадиам сар джяти. Отхэ лэстэ аракхлилэ дуй чявэ. ");
INSERT INTO rmn_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Тай саранда брэшэндар ко Маисей ало миляики андэ тхардо хлядяло кущёки ки ливади, надур катар горас Синай. ");
INSERT INTO rmn_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","О Маисей сас шаштимэ, кана адава дикхляс. Ов пашыло пашэ, зиядэ тэ дикхел, тай шунляс сэси э Сагбуско: ");
INSERT INTO rmn_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","«Мэ о Дэл тэ дадэнго, о Дэл э Авраамеско, э Исаакеско тай э Яковеско». О Маисей изралас катар траш тай нащи ваздэлас пэ якха. ");
INSERT INTO rmn_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","О Сагбус пхэнляс лэски: «Чи тэ минидэс, вай о тхан, опэр савэстэ ту тэрдо, — шужы пху. ");
INSERT INTO rmn_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Мэ дикхлём о хурлуки Мэ дюняско андэ Египти тай шунлём лэнго роипэ. Мэ фулистинём, тэ кутардияв лэн. Ай акана джя, Мэ бичялав тут андэ Египти». ");
INSERT INTO rmn_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Одолэ Маисеес, савэстар он болдинэпэс тай савэстар пхэнэнас: «Кон тхэдяс тут барэс тай цындомарес?» — о Дэл бичялдяс сар барэс тай кутардимарес андар миляики, саво сикавдяспэс лэски андэ хлядяло кущёки. ");
INSERT INTO rmn_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","О Маисей никалдяс лэн тай саранда брэш керэлас чюдэс тай сикаиматэс андэ Египти, ки Лоли моря тай ки ливади. ");
INSERT INTO rmn_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Адава жэ Маисей пхэнляс э израильтяненги: «Андар тумарэ пхралэндэ о Дэл кан тхэл тумэнги Прарокес, сар мандэ». ");
INSERT INTO rmn_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ов, — одова мануш, саво сас э дюняса андэ ливади; ов сас отхэ амарэ дадэнца тай э миляикеса, саво зборизэлас лэса опэр горас Синай. Ов лиляс дживиндэ зборэс, тэ дэл лэн амэндэ. ");
INSERT INTO rmn_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Амарэ дада на манглэ тэ шунэн лэс, ами болдинэпэс лэстар тай болдинэ пумарэ илэ карин Египти. ");
INSERT INTO rmn_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Он пхэнлэ э Ааронески: «Кер амэнги дэвлэн, савэ кан джян ангал амэндэ, вай амэ на джянас, со уло адалэ Маисееса, кай никалдяс амэн андар Египти». ");
INSERT INTO rmn_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Андэ адала деса он кердэ гурувэс, андэ адалэ идолэски курбани тай лошазэнас э дилаки пэ вастэнгеряки. ");
INSERT INTO rmn_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","О Дэл болдиняспэс лэндар тай ачявдяс лэн тэ керэн иргатлыки э опрунэ армияки, сар си яздимэ андэ книжка ки прарокенги: «Кхер Израилеско, анэнас тумэ Манги башладиматэс тай курбанен саранда брэш андэ ливади? ");
INSERT INTO rmn_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Тумэ кердянус тумэнги шавлинен катуна э Молахески тай чергэн тумарэ дэвлэски э Ремфанески, бангёнас ангал лэндэ тай пхеравэнас лэн пэса. Оничин Мэ кан бичялав тумэн андэ пханлипэ дур катар Вавилон». ");
INSERT INTO rmn_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Амарэ дадэндэ андэ ливади сас Катуна Заветески. О Дэл сикавдяс э Маисеески, касавки ой камэл тэ овэл, тай ов аякха да кердяс. ");
INSERT INTO rmn_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Амарэ дада лилэ адая катуна, тай екхетханэ э Исусеса Навескерэса он андэ ла андэ пху ки дюняски, савэн о Дэл кувды ангал лэндэ. Тай аякха сас джи ко деса ки Давидески, ");
INSERT INTO rmn_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","савэс дэхэлас о Дэл. О Давид мангелас Лэс тэ мукел тэ аракхел катуна э Яковески кхерэски. ");
INSERT INTO rmn_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ай о кхер Лэски тхэдяс о Саламон. ");
INSERT INTO rmn_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ай о Учё Дэл на бэшэл андэ кхера, тхэдэ э манушэнца. О прароки пхэнэл адалэстар: ");
INSERT INTO rmn_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","«О булутя — о трони Минро, тай э пху — скамейка тал Мэ пинрэндэ! Касавко тумэ кан тхэн Манги кхер? — пхэнэл о Сагбус. — Катэ си тхан рагатеско Манги? ");
INSERT INTO rmn_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Та со, на Мэ вастэса алаи адава кердо?» ");
INSERT INTO rmn_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Тумэ — дюняс, савэстэ на бангёл э мэн, кастэ баруно ило тай пханлэ кана! Тумэ екхараи тэрдён мамуй ко Шужо Духос, сар тумарэ дада, аякха ли тумэ! ");
INSERT INTO rmn_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Кас андар прарокя тумарэ дада на кувдиенас? Он мудардэ одолэн, кон пхэнэлас, кай кан авэл о Чячё. Анкха тумэ улянус пхукаимаря тай мударимаря! ");
INSERT INTO rmn_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Тумэ лилянус о Тхэдипэ, дино тумэн андар миляикя, ай на кердянус лэс! ");
INSERT INTO rmn_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Кана он шунлэ адава, он холясаилэ тай лилэ тэ хан пумарэ данда катар холи. ");
INSERT INTO rmn_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ай о Стэфан, пхэрдо Шужо Духос, ваздиняс пэ якха опрэ тай дикхляс о нами э Дэвлэско тай э Исусеско, Саво сас тэрдо катар прави васт ки Дэвлэско. ");
INSERT INTO rmn_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","— Дикхен, — пхэнляс ов, — мэ дикхав пхутэрдэ булутя тай э Чявэс э Манушыканэс катар прави васт ки Дэвлэско! ");
INSERT INTO rmn_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Дэчи он екхвар пханлэ пумарэ кана, барэ бэбэряса читэпэс опэр лэстэ. ");
INSERT INTO rmn_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Он сидинэ э Стэфанес пал диз тай лилэ тэ чен андэ лэстэ бара. О дикхимаря э дошаки ачявдэ пумарэ савутя ко пинрэ ки тэрнэ манушэски, саво бучёлас Савл. ");
INSERT INTO rmn_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Кана он ченас андэ Стэфан бара, одова мангелас э Дэвлэс: — Сагбус Исус, лэ о духос минро! ");
INSERT INTO rmn_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ов пэло опэр кочя тай лачес пхэнляс: — Сагбус, ма хорладие лэн андар адалэ бэзендэ! Адалэ зборэнца ов муло. ");
INSERT INTO rmn_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","О Савл сас екхетханэ одолэнца, савэ мудардэ э Стэфанес. Одолэ десестар уло баро кувдипэ опэр Иерусалимски кхангери, тай алаи, булуб катар апостоля, нашлэ андэ алаи ко пхуя ки Иудеяки тай ки Самарияки. ");
INSERT INTO rmn_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Э Дэвлэски мануша пароскердэ э Стэфанес тай лачес ровэнас пал лэстэ. ");
INSERT INTO rmn_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ай о Савл лачес кувдиелас э кхангери. Ов челаспэс андэ кхера ки пакялэнги, никалэлас э муршэн тай э джювлен тай челас лэн андэ пханли. ");
INSERT INTO rmn_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Озаман о нашлэ пхукавэнас о Лошано Габэри катэ, он накхенас. ");
INSERT INTO rmn_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","О Филипп ало андэ екх диз ки Самарияки тай пхукавэлас отхэ катар Христос. ");
INSERT INTO rmn_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Бут дюняс лачес шунэнас одова, со ов пхэнэлас. Он шунэнас лэски зборэс тай дикхенас чюдэс, савэ ов керэлас. ");
INSERT INTO rmn_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Андар бут мануша никлёнас барэ бэбэряса бишужэ духя, тай о бут астардэ тай о банге аиндиенас. ");
INSERT INTO rmn_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Тай андэ диз одолатэ сас бари лош. ");
INSERT INTO rmn_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Сас отхэ екх мануш, саво бучёлас Симон, саво керэлас андэ адалэ дизатэ магия, шаштэрдиелас э манушэн э Самариякерэн. Ов пэстар пхэнэлас, кай си саво-то баро. ");
INSERT INTO rmn_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Алаи о мануша, ли о простоя, ли о намлыдэс, шунэнас лэс, пхэнэнас: — Адава мануш — бари зор э Дэвлэски. ");
INSERT INTO rmn_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Он шунэнас лэс одолэски, кай ов бут вахыти шаштэрдиелас манушэн пэ магияса. ");
INSERT INTO rmn_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ай кана он пакянилэ э Филиппески, кай пхукавэлас катар Патишайлыки ки Дэвлэско тай катар нав ки Исусеско Христоско, о мурша тай джювля лилэ болдипэ. ");
INSERT INTO rmn_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ли о Симон пакянило. Ов болдяспэс тай вэркатэ пхерэлас пал Филипп, дикхелас сикаиматэс тай барэ чюдэс тай шаштиелас. ");
INSERT INTO rmn_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Кана о апостоля андэ Иерусалими шунлэ одолэстар, кай андэ Самария пакянилэ э збораки э Дэвлэскеряки, он бичялдэ лэндэ э Пётарэс тай Иоаннес. ");
INSERT INTO rmn_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Одола алэ тай мангенас э Дэвлэс, тэ дэл лэн Шужо Духос. ");
INSERT INTO rmn_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Опэр никхастэ андар лэндэ о Духос дага на ало, он екх сас болдэ андэ нав ки Сагбуско Исусеско. ");
INSERT INTO rmn_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Пал отхэ о Пётар тай о Иоанн тхэдэ опэр лэндэ пумарэ васта, тай он диндилэ о Шужо Духос. ");
INSERT INTO rmn_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","О Симон дикхляс, кай о Духос си дино, кана тхэн пумарэ васта о апостоля, ов дэлас лэн ловэ ");
INSERT INTO rmn_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","тай пхэнляс: — Дэн ли ман асавки зор, тай одова, опэр кастэ мэ кан тхав мэ васта, тэ диндёл о Шужо Духос. ");
INSERT INTO rmn_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ай о Пётар пхэнляс: — То руп мэ нашавдёл екхетханэ туса, ту тэ тюшундиес тэ кинэс о башладипэ э Дэвлэско ловэнги! ");
INSERT INTO rmn_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ту нащи овэс андэ адалэ дилатэ, вай то ило нанай чячё ангал Дэл. ");
INSERT INTO rmn_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ачяв адава джюнгалипэ тай манг э Сагбус, файма, Ов кан апувикерэл туки асавке тюшундиматэс. ");
INSERT INTO rmn_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Мэ дикхав, кай ту пхэрдо керкипэ тай пханло джянджирэнца начячимаскерэнца. ");
INSERT INTO rmn_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","О Симон пхэнляс: — Манген андар мандэ э Сагбус, манца тэ на овэл ништо, со пхэнлянус тумэ. ");
INSERT INTO rmn_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","О апостоля пхукавэнас тай пхэнэнас отхэ э збора э Сагбуски. Дэчи он гелэ палэ андэ Иерусалими тай опэр дром пхукавэнас о Лошано Габэри андэ бут самарийскя гава. ");
INSERT INTO rmn_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","О миляики э Сагбуско пхэнляс э Филиппески: — Джя ко юги, опэр дром, кай гелэл андар ливади андар Иерусалими ки Газа. ");
INSERT INTO rmn_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","О Филипп ущино тай гело. Бирдэн опэр дром ов дикхляс э евнухес андар э Эфиопия. Ов сас намлыс мануш э Кандакияко, э патишаинкако э эфиопенги, тай дикхелас пал алаи лаки барвалимастэ. Ов алосас тэ бангёл ангал Дэл андэ Иерусалими ");
INSERT INTO rmn_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","тай акана джялас кхерэ. Ов бэшло андэ пэ урдонестэ тай драпкерэлас прароки Исаия. ");
INSERT INTO rmn_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","О Духи пхэнляс э Филиппески: — Пашо адалэ урдонестэ тай джя пашэ. ");
INSERT INTO rmn_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","О Филипп прастанило ко урдон тай шунляс, андэ лэстэ кай драпкерэл прароки Исаия. — Ту галёс одова, состар драпкерэс? — пхучляс о Филипп. ");
INSERT INTO rmn_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","— Сар манги тэ галяв би галяримаско? — мангляс одова э Филиппес тэ ваздэлпэс тай тэ бэшэл лэса. ");
INSERT INTO rmn_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ай драпкерэлас ов адава тхан андар Яздипэ: «Сар бакря, Лэс гелэнас ко чиндипэ, сар бакроро си тэрдо би зборэнго ангал одолэстэ, кай моравэл, аякха ли Ов на пхутрэла о ушта Пинрэн. ");
INSERT INTO rmn_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Лэстар асанас тай лилэ о тхэдипэ э чяче цындоско. Кон кан пхукавэл Лэски породатар? Вай Лэско бэшыпэ линдёл катар пху». ");
INSERT INTO rmn_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","О евнух пхучляс ко Филипп: — Пхэн манги, кастар атхэ пхэнэл о прароки, пэстар я кастар-то аврэстар? ");
INSERT INTO rmn_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Дэчи о Филипп лиляс тэ галярэл акалэ тханэстар ки Яздимаско тай пхукавдяс лэски Лошано Габэри катар Исус. ");
INSERT INTO rmn_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Он дага джянас опэр дром тай одова вахыти пашылэ савэ-то панестэ. — Дикх, аки пани, — пхэнляс о евнух. — Со на дэл ман тэ лав болдипэ? ");
INSERT INTO rmn_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ов пхэнляс тэ тэрдярэн о урдон, ли о дуй он, о Филипп тай о евнух, динэ андэ пани, тай о Филипп болдяс лэс. ");
INSERT INTO rmn_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ай кана он никлистэ андар пани, о Духос э Сагбуско гелдяс э Филиппес, тай о евнух лэс генэ на дикхляс. Лошано ов гело по дром. ");
INSERT INTO rmn_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ай о Филипп уло андэ диз Ашдод. Ов пхерэлас тай пхукавэлас о Лошано Габэри андэ алаи ко диза, бискай на ало андэ Кесария. ");
INSERT INTO rmn_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","О Савл генэ сас холямэ, мангелас мэрипэ э сиклярдэнги э Сагбускерэнги. Ов ало ко баро попази ");
INSERT INTO rmn_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","тай мангляс лэстэ о письмадэс э синагогенги андэ Дамаск, ов тэ линдярэл тай тэ анэл андэ Иерусалими алаен, савэн кан аракхел, муршэн я джювлен, кон бэшэлас андэ сиклярипэ «Дром». ");
INSERT INTO rmn_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Кана ов пашолас ки Дамаск, лэс бирдэн агорады о ярэки опрал. ");
INSERT INTO rmn_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ов пэло ки пху тай шунляс сэси: — Савл, Савл, соски ту Ман кувдиес? ");
INSERT INTO rmn_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","— Кон Ту, Сагбуса? — пхучляс о Савл. — Мэ о Исус, Савэс ту кувдиес, — пхэнляс Ов. ");
INSERT INTO rmn_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","— Ущи тай джя андэ диз, отхэ туки кан пхэнэн, со туки камэл тэ керэс. ");
INSERT INTO rmn_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","О мануша, кай пхерэнас э Савлэса, тэрдэ сакавя: он шунэнас сэси, ай никхас на дикхенас. ");
INSERT INTO rmn_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","О Савл ваздиняспэс катар пху, ай кана ов пхутэрдяс пэ якха, уло, кай ов ништо на дикхел; тай андэ лэс вастэндар андэ Дамаск. ");
INSERT INTO rmn_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Трин дес ов сас коро, ништо на халас тай на пиелас. ");
INSERT INTO rmn_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Андэ Дамаск бэшэлас сиклярдо, саво бучёлас Анания. О Сагбус пхэнляс лэски андэ дикхипэ: — Анания! — Ва, Сагбуса, — пхэнляс одова. ");
INSERT INTO rmn_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","О Сагбус пхэнляс лэски: — Джя ки улица ки Доврус андэ кхер ко Иуда тай аракх отхэ манушэс андар Тарс, кай си о нав Савл. Ов анкха мангел э Дэвлэс, ");
INSERT INTO rmn_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","тай андэ дикхипэ ов дикхляс манушэс, савэско нав сас Анания, саво ало тай тхэдяс опэр лэстэ пэ васта, ов тэ дикхел. ");
INSERT INTO rmn_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","О Анания пхэнляс: — Сагбуса, мэ бутэ манушэндар шунлём адалэ манушэстар, одолэстар, сар бут джюнгалипэ ов кердяс Тэ шужэнги андэ Иерусалими. ");
INSERT INTO rmn_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Тай атхэ лэстэ барипэ катар барэ попазя тэ линдярэл алаен, кон дэл икос То нав. ");
INSERT INTO rmn_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ай о Сагбус пхэнляс лэски: — Джя, вай о мануш адава — Мо мултуки. Ов кан пхукавэл Мэ навэстар э манушэнги бутэ пхуендэ, лэнги патишаенги тай э израильтяненги. ");
INSERT INTO rmn_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Мэ кан сикавав лэски ли одова, сокабор лэски кан камэл тэ овэл хурлуки андар Мэ навэстэ. ");
INSERT INTO rmn_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","О Анания гело, диняс андэ одова кхер, тхэдяс опэр Савл пэ васта тай пхэнляс: — Пхрала Савл, о Сагбус о Исус, Саво ало тутэ опэр тэ дромэстэ атхэ, бичялдяс ман тутэ, ту генэ тэ дикхес тай тэ овэс пхэрдо Шужэ Духоса. ");
INSERT INTO rmn_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Одова вахыти сар сипэс пэлэ опрал якха ко Савл, тай ов лиляс тэ дикхел. Ов ущино тай лиляс болдипэ. ");
INSERT INTO rmn_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Дэчи ов халяс, тай лэстэ али э зор. О Савл сас набут деса э сиклярдэнца андэ Дамаск ");
INSERT INTO rmn_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","тай бирдэн лиляс тэ пхукавэл андэ синагогя одолэстар, кай о Исус — Чяво Дэвлэско. ");
INSERT INTO rmn_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Алаи, кон лэс шунэлас, шаштиенас тай пхэнэнас: — Та со, на ов мударэлас андэ Иерусалими одолэн, савэ дэнас икос адава нав? Та со, ов на ало атхэ, тэ линдярэл лэн тай тэ гелэл ко барэ попазя? ");
INSERT INTO rmn_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","О Савл май барэ зораса сиклярэлас тай галярэлас, кай о Исус си о Христос. Адалэса ов шаштэрдиелас э иудеен, савэ бэшэнас андэ Дамаск. ");
INSERT INTO rmn_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Кана накхло назалаг деса, о иудея тюшундылар тэ мударэн э Савлэс. ");
INSERT INTO rmn_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ай о Савл галило адалэстар. Он о дес тай э рат дикхенас пал ки бар ки дизаки, тэ мударэн лэс, ");
INSERT INTO rmn_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ай лэски сиклярдэ рати лилэ тай муклэ лэс андэ сэпэти катар дизаки стинас. ");
INSERT INTO rmn_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","О Савл ало андэ Иерусалими тай мангелас тэ овэл э сиклярдэнца, ай он трашанас лэстар тай на пакянас, кай ли ов си сиклярдо. ");
INSERT INTO rmn_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","О Варнава андяс лэс ко апостоля тай пхукавдяс лэнги одолэстар, сар о Савл опэр дром дикхляс э Сагбус, сар о Сагбус зборизэлас лэса тай сар андэ Дамаск ов баримаса сиклярэлас катар нав ки Исусеско. ");
INSERT INTO rmn_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","О Савл сас лэнца саво-то вахыти тай пхерэлас андэ Иерусалими, битрашако сиклярэлас катар нав ки Сагбуско. ");
INSERT INTO rmn_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ов зборизэлас тай ирищиелас э эллинистенца. Одола манглэ тэ мударэн лэс. ");
INSERT INTO rmn_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Кана о пхрала галилэ адалэстар, он гелдэ э Савлэс андэ Кесария тай отхар бичялдэ лэс андэ Тарс. ");
INSERT INTO rmn_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Озаман э кхангеряки алаи ки Иудея, Галилея тай ки Самария уло рагатеско вахыти. Э кхангери зоралёлас тай барёлас, бэшэлас андэ траш ангал Сагбус. О Шужо Духос керэлас ярдыми э кхангеряки, тай ой барёлас. ");
INSERT INTO rmn_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","О Пётар пхерэлас катар тхан ко тхан, мангляс тэ джял ли ко шужэ, кай бэшэнас андэ Лидда. ");
INSERT INTO rmn_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Отхэ сас екх мануш, саво бучёлас Эней. Ов сас астардо тай на ущелас опрал тхан охто брэш. ");
INSERT INTO rmn_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","О Пётар пхэнляс лэски: — Эней! О Исус Христос аиндэрдиел тут. Ущи тай кидэ о тхан. Одова вахыти о Эней ущино. ");
INSERT INTO rmn_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Кана алаи, кон бэшэлас андэ Лидда тай Шарон, дикхлэ лэс аиндимэ, он болдинэпэс ко Сагбус. ");
INSERT INTO rmn_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Андэ Яффа сас екх сиклярди, сави бучёлас Тавита, самким «Газель». Ой екхараи керэлас лачипэ тай ярдыми э чёрэнги. ");
INSERT INTO rmn_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Тай аки адава вахыти ой насвалили тай мули. Ла халярдэ тай пашлярдэ опрэ андэ кхер. ");
INSERT INTO rmn_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Э Лидда си надур катар Яффа. Кана о сиклярдэ шунлэ, кай о Пётар сас отхэ, бичялдэ лэстэ дон манушэн тэ манген: — Тэ авэл чяльти амэндэ! ");
INSERT INTO rmn_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","О Пётар чяльти гело лэнца. Кана ов ало, лэс гелдэ опрэ андэ кхер. Агорял лэстэ кидинэпэс алаи о пхивля. Он ровэнас тай сикавэнас лэски э рока тай авэра савутя, савэ сивдяс лэнги э Газель, кана ой сас дживинди. ");
INSERT INTO rmn_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","О Пётар бичялдяс алаен катар тхан, тэрдило опэр кочендэ тай мангляс э Дэвлэс. Дэчи ов болдиняспэс ки мули тай пхэнляс: — Тавито, ущи! Ой пхутэрдяс пэ якха, дикхляс э Пётарэс тай бэшли. ");
INSERT INTO rmn_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ов лиляс ла вастэстар тай кердяс ярдыми тэ ущел опэр пинрэ. Дэчи ов диняс икос э шужэн тай э пхивлен тай сикавдяс лэнги э Тавита дживиндя. ");
INSERT INTO rmn_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Адалэстар уло джянло андэ алаи ки Яффа, тай бут мануша пакянилэ э Сагбуски. ");
INSERT INTO rmn_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","О Пётар сас андэ Яффа генэ назалаг дес, ов бэшэлас ко Симон, саво керэлас бути э моркхяса. ");
INSERT INTO rmn_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Андэ Кесария сас мануш, саво бучёлас Карнилий, баро опэр шэлэ манушэндэ, андар кагорти, саво пхеравэл нав Италийский. ");
INSERT INTO rmn_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","О Карнилий, сар ли алаи лэско кхер, сас мануш, саво керэлас лачипэ тай трашалас катар Дэл. Ов бут дагытиелас ловэ тай екхараи мангелас э Дэвлэс. ");
INSERT INTO rmn_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Екхвар десе паш ко трин сагатя э Карнилиески сас дикхипэ. Ов шужэс дикхелас э Дэвлэски миляикес, саво ало лэстэ тай пхэнляс: — Карнилий! ");
INSERT INTO rmn_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ов дикхляс карин лэстэ трашаса тай пхэнляс: — Со, сагбуса? О миляики пхэнляс: — О Дэл тюшунды тутар, вай то мангипэ тай ярдыми э чёрэнги ваздиндилэ Лэстэ. ");
INSERT INTO rmn_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Бичял манушэн андэ Яффа, тэ дэн икос он э Симонэс, савэски пхэнэн Пётар. ");
INSERT INTO rmn_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ов тэрдило ки моря андэ кхер ко Симон, саво керэлас бути э моркхяса. ");
INSERT INTO rmn_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Кана о миляики, кай зборисаило лэса, гело, о Карнилий диняс икос дон пэ иргатен тай лаче салдатес, саво керэлас лэски иргатлыки. ");
INSERT INTO rmn_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ов пхукавдяс лэнги алаи тай бичялдяс лэн андэ Яффа. ");
INSERT INTO rmn_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Десе авэр дес, кана о бичялдэ пашонас ки диз, паш ко дэшудуй сагатя о Пётар ваздиняспэс опэр кхер тэ мангел э Дэвлэс. ");
INSERT INTO rmn_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ов сас бокхало тай мангелас тэ хал. Бискай тавэнас хапэ, э Пётарэски сас дикхипэ. ");
INSERT INTO rmn_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ов дикхелас пхутэрдэ булутя тай сар бугло басмас, саво фулелас опэр пху, пханло штарэ четендар. ");
INSERT INTO rmn_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Андэ адалэ басмастэ сас бут штарэчянгенги гайваня тай одола, савэ балакадиен, тай чирикля. ");
INSERT INTO rmn_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Дэчи сэси пхэнляс лэски: — Ущи, Пётар, чин тай ха. ");
INSERT INTO rmn_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","— На, Сагбуса! — пхэнляс о Пётар. — Мэ дага на халём ништо гарами я нашужо. ");
INSERT INTO rmn_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Дэчи о сэси пхэнляс лэски дуйто рази: — Ма пхэн гарами одолэски, со о Дэл шужардяс. ");
INSERT INTO rmn_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Аякха сас тривал, тай одова сагати о басмас сас ваздино опрэ. ");
INSERT INTO rmn_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","О Пётар ништо на галёлас, со галярэл адава дикхипэ, кана о мануша, бичялдэ э Карнилиеса, пхучлэ катар кхер ки Симонэско, пашылэ тай тэрдилэ ки бар. ");
INSERT INTO rmn_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Он лилэ тэ пхучен, атхэ тэрдило о Симон, кай бучёл Пётар. ");
INSERT INTO rmn_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","О Пётар дага тюшундиелас катар дикхипэ, кана о Духос пхэнляс лэски: — Тут родэн трин мануша. ");
INSERT INTO rmn_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ущи тай фули тэлэ. Джя лэнца би сидимаско, вай адава Мэ бичялдём лэн. ");
INSERT INTO rmn_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","О Пётар фулистино тэлэ тай пхэнляс адалэ манушэнги: — Мэ одова, савэс тумэ родэн. Со дилаки тумэ алянус? ");
INSERT INTO rmn_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Он пхэнлэ: — О баро опэр шэлэ салдатендэ о Карнилий, мануш чячё тай трашал катар Дэл, гиндо алаи э иудеенца, диндило катар шужо миляики збора тэ дэл икос тут андэ пэ кхерэстэ тай тэ шунэл, со ту лэски кан пхэнэс. ");
INSERT INTO rmn_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Дэчи о Пётар диняс икос лэн андэ кхер тай кердяс лэнги лачипэ. Авэр дес о Пётар гело лэнца. Екхетханэ лэса гелэ аякха сарсавэ пхрала андар Яффа. ");
INSERT INTO rmn_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Авэр дес он алэ андэ Кесария. О Карнилий ишандиелас лэн, диняс икос пэ тухумен тай пашэ амалэн. ");
INSERT INTO rmn_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Кана о Пётар ало, о Карнилий дикхляс лэс, пэло лэски чянгендэ тай бангило лэски. ");
INSERT INTO rmn_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ай о Пётар ваздиняс лэс, пхэнляс: — Ущи, вай ли мэ мануш. ");
INSERT INTO rmn_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","О Пётар зборизэлас э Карнилиеса тай ало андэ кхер, катэ кидинэпэс бут дюняс. ");
INSERT INTO rmn_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ов пхэнляс лэнги: — Тумэ сам джянэн, кай э иудеески на муклёл тэ зборизэл наиудеенца тай тэ авэс лэндэ андэ кхер. Ай о Дэл сикавдяс манги, кай мэ били екхе манушэски на камэл тэ пхэнав гарами я нашужо. ");
INSERT INTO rmn_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Оничин, кана пал мандэ алэ, мэ гелём би сидимаско. Мукен ман тэ пхучяв акана, соски тумэ бичялдянус пал мандэ? ");
INSERT INTO rmn_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","О Карнилий пхэнляс: — Штарто дес андэ адалэ вахытестэ, десе паш ко трин сагатя мэ мангавас э Дэвлэс андэ мэ кхерэстэ, сар бирдэн ангал мандэ уло мануш андэ шужэ парнэ савутя. ");
INSERT INTO rmn_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","«Карнилий, — пхэнляс ов, — то мангипэ шунлило, тай о Дэл джянэл, кай ту керэс ярдыми э чёрэнги. ");
INSERT INTO rmn_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Бичял манушэн андэ Яффа пал Симон, савэски пхэнэн дага Пётар. Ов ки моря андэ кхер ко Симон, саво керэлас бути э моркхяса». ");
INSERT INTO rmn_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Мэ чяльти бичялдём пал тутэ, тай лачё, кай ту алян. Анкха алаи амэ атхэ, ангал Дэл, тай мангас тэ шунас одова, со о Сагбус диняс тут тэ пхэнэс. ");
INSERT INTO rmn_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","О Пётар лиляс тэ пхэнэл: — Акана мэ галяв, кай о Дэл чячес на дикхел карин муй ки манушэско, ");
INSERT INTO rmn_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","тай андэ кажни дюнястэ Ов дэхэл одолэс, кон трашал Лэстар тай керэл чячипэ! ");
INSERT INTO rmn_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ов бичялдяс э дюняски э Израилескерэски Лошано Габэри одолэстар, кай амэ овас лаче Лэса андар Исус Христос, Саво си о Сагбус алаи э манушэнго. ");
INSERT INTO rmn_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Тумэ джянэн одолэ дилэндар, савэ сас андэ алаи ки Иудея, ханик андэ Галилея, кана о Иоанн дэлас икос э манушэн тэ болэнпэс. ");
INSERT INTO rmn_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","О Дэл макхляс э Шужэ Духоса тай э зораса э Исусес андар Назарет, тай Ов пхерэлас, керэлас лаче дилэс тай аиндэрдиелас алаен, кон сас андэ зор ки Шэйтанески, вай Лэса сас о Дэл. ");
INSERT INTO rmn_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Амэ дикхлям алаи одова, со о Исус керэлас андэ пху ки иудеенги тай андэ Иерусалими. Лэс мудардэ, илдылар опэр каштуно хачи, ");
INSERT INTO rmn_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ай о Дэл ко трито дес дживиндярдяс Лэс тай диняс Лэс тэ сикавэлпэс э манушэнги — ");
INSERT INTO rmn_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","на алаи э дюняски, ами буруни никалдэ э Дэвлэса э дикхимаренги, самким амэнги. Амэ хасас тай пиясас Лэса пал отхэ, сар Ов дживиндило андар мулэ. ");
INSERT INTO rmn_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ов пхэнляс амэнги тэ сиклярас э манушэн тай тэ пхукавас одолэстар, кай Ов си тхэдо э Дэвлэса, тэ овэс Цындомари э дживиндэнги тай э мулэнги. ");
INSERT INTO rmn_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Лэстар пхукавэн алаи о прарокя тай пхэнэн, кай кажын пакяло андэ Лэстэ диндёл мукипэ бэзенго булуб Лэски навэски. ");
INSERT INTO rmn_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","О Пётар дага пхэнэлас адава, кана опэр алаендэ, кай шунэнас лэско Габэри, фулистино о Шужо Духос. ");
INSERT INTO rmn_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","О пакялэ иудея, савэнги кердэ абрезания, савэ алэ э Пётарэса, сас шаштимэна, кай о башладипэ э Шужэ Духоско сас чёрдо ли опэр наиудея. ");
INSERT INTO rmn_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Он шунлэ, сар одола пхэнэнас опэр наджянлэ чиба тай махтадиенас э Дэвлэс. Дэчи о Пётар пхэнляс: ");
INSERT INTO rmn_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","— Кон на кан мукел, тэ овэн болдэ панеса адала мануша, савэ диндилэ о Духос о Шужо аякха, сар амэ? ");
INSERT INTO rmn_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Тай ов пхэнляс лэнги, тэ лэн болдипэ андэ нав ки Исусеско Христоско. Дэчи о сагбудэс манглэ э Пётарэс тэ ачёл лэнца генэ набут деса. ");
INSERT INTO rmn_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","О апостоля тай о пхрала андэ Иудея шунлэ одолэстар, кай о наиудея пакянилэ э Дэвлэски збораки. ");
INSERT INTO rmn_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Оничин, кана о Пётар ало андэ Иерусалими, о пакялэ, савэнги кердэ абрезания, лилэ тэ асан лэстар. ");
INSERT INTO rmn_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","— Ту санас одолэндэ, савэнги на кердэ абрезания, тай хасас лэнца, — пхэнэнас он. ");
INSERT INTO rmn_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Дэчи о Пётар пал екхаврэстэ лиляс тэ галярэл лэнги, сар алаи уло. ");
INSERT INTO rmn_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","— Мэ сомас андэ диз ки Яффа тай мангавас э Дэвлэс, — пхэнляс ов, — тай адава вахыти мандэ сас дикхипэ: сар баро басмас, саво катар штар четя фулелас опрал доврус отхэ, катэ мэ сомас. ");
INSERT INTO rmn_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Дикхлём андэ лэстэ, мэ дикхлём штарэчянгенги гайванен э пхуякерэн тай э вэшэскерэн, тай одолэн, савэ балакадиен, тай чириклен. ");
INSERT INTO rmn_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Дэчи мэ шунлём сэси, саво пхэнэлас манги: «Ущи, Пётар, чин тай ха». ");
INSERT INTO rmn_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Мэ пхэнлём: «На-на, Сагбуса! Били екхвар мэ на лилём андэ муй ништо гарами я нашужо». ");
INSERT INTO rmn_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","О сэси опрал пхэнляс манги дуйто рази: «Ма пхэн гарами одолэски, со о Дэл шужардяс». ");
INSERT INTO rmn_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Аякха сас пхэнло тривал, тай дэчи о басмас сас генэ ваздино опрэ. ");
INSERT INTO rmn_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Одова вахыти ко кхер, катэ мэ сомас, тэрдилэ трин мурша, бичялдэ мандэ андар Кесария. ");
INSERT INTO rmn_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","О Духос пхэнляс манги тэ джяв лэнца тай тэ на пхучяв. Аки ли акала шов пхрала гелэ манца, тай амэ алям андэ кхер одолэстэ, кон ман диняс икос. ");
INSERT INTO rmn_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ов пхукавдяс амэнги одолэстар, сар ов дикхляс андэ пэ кхерэстэ миляикес. О миляики пхэнляс лэски: «Бичял манушэн андэ Яффа пал Симон, савэски пхэнэн Пётар, ");
INSERT INTO rmn_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","тай ов кан пхэнэл тумэнги одолэстар, сар ту тай алаи тэ кхерутнэ кан овэн кутардимэна». ");
INSERT INTO rmn_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Кана мэ лилём тэ пхэнав, опэр лэндэ фулистино о Шужо Духос аякха, сар Ов фулистино буруни ли опэр амэндэ. ");
INSERT INTO rmn_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Дэчи мандэ алэ ки годи о зборэс э Сагбуски: «О Иоанн болэлас панеса, ай тумэ кан овэн болдэ Шужэ Духоса». ");
INSERT INTO rmn_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Оничин, о Дэл тэ диняс лэн одова жэ башладипэ, со амэн, савэ пакянилэ андэ Сагбус Исус Христос, ай кон мэ асавко, тэ тэрдяв мамуй ко Дэл? ");
INSERT INTO rmn_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Кана он адава шунлэ, он тэныкисаилэ, ай дэчи махтадылар э Дэвлэс тай пхэнлэ: — Аки, о Дэл диняс ли э наиудеен тэ ачявэн пумарэ бэзя, тай тэ диндён о бэшыпэ! ");
INSERT INTO rmn_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ай о пакялэ, нашлэ катар кувдипэ, саво уло андар Стэфан, алэ джи ки Финикия, Кипр тай Антиохия, пхукавэнас э Дэвлэски збора екх э иудеенги. ");
INSERT INTO rmn_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ай сарсавэ андар лэндэ, кай бэшэн андэ Кипр тай Кирени, алэ андэ Антиохия тай лилэ тэ пхукавэн Лошано Габэри катар Сагбус Исус ли э эллинистенги. ");
INSERT INTO rmn_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","О васт э Сагбуско сас лэнца, тай о бут пакянилэ тай болдинэпэс ко Сагбус. ");
INSERT INTO rmn_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","О габэри адалэстар ало джи ки кхангери андэ Иерусалими. Отхар бичялдэ андэ Антиохия э Варнавес. ");
INSERT INTO rmn_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Кана о Варнава ало тай дикхляс э мила э Дэвлэски, ов лошасаило тай дэлас икос алаен тэ ачён шужэ илэса тай чяче э Сагбуски. ");
INSERT INTO rmn_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","О Варнава сас лачё мануш, пхэрдо Шужэ Духоса тай пакямаса, тай бут мануша алэ ко пакяпэ андэ Сагбус. ");
INSERT INTO rmn_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Дэчи о Варнава гело андэ Тарс, тэ родэл отхэ э Савлэс. ");
INSERT INTO rmn_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Тай кана ов аракхляс лэс, андяс лэс андэ Антиохия. Састо брэш он сас андэ антиохийски кхангери тай сиклярэнас бут дюняс. Андэ Антиохия э сиклярдэнги лилэ тэ пхэнэн «христианя». ");
INSERT INTO rmn_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Андэ адава вахыти андар Иерусалими андэ Антиохия алэ набут прарокя. ");
INSERT INTO rmn_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","О екх андар лэндэ, саво бучёлас Агав, ущино тай Духоса пхэнляс, кай опэр алаи ки пху кан овэл бари бокх, со ли уло андэ вахыти, кана сас о император Клавдий. ");
INSERT INTO rmn_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Оничин о сиклярдэ гиндэ тэ бичялэн ярдыми э пхралэнги, кай бэшэн андэ Иудея, кастэ сокабор сас тэ дэл. ");
INSERT INTO rmn_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Аякха он ли кердэ, бичялдэ э Варнавес тай э Савлэс тэ гелэн о кидинэ ловэ тай тэ дэн лэн ко барэ мануша. ");
INSERT INTO rmn_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Андэ адава вахыти о патишаи о Ирод линдярдяс сарсавэ манушэн андар кхангери, тэ керэл лэнги джюнгалипэ. ");
INSERT INTO rmn_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ов пхэнляс тэ мударэл камаса э Яковес, э пхралэс э Иоаннескерэс. ");
INSERT INTO rmn_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Кана ов дикхляс, кай о иудея адалэски лошазэн, ов линдярдяс ли э Пётарэс. Адава уло андэ вахыти, кана сас о мисяфири э Писное Питэнго. ");
INSERT INTO rmn_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Э Пётарэс линдярдэ, пханлэ андэ пханли тай тхэдэ штар группэс по штар салдатя тэ дикхен пал лэстэ. О Ирод мангелас пал ки Пэсах тэ никалэл э Пётарэс ко дюняс. ");
INSERT INTO rmn_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","О Пётар сас андэ пханли, ай э кхангери лачес мангелас андар лэстэ э Дэвлэс. ");
INSERT INTO rmn_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Рати ангал отхэ, кай о Ирод камэлас тэ никалэл лэс ко цындос, о Пётар суто сас машкарэ ко дуй салдатя, пханло до джянджирэнца, ай о барэ тэрдэ ангал удар тай дикхен пал пханли. ");
INSERT INTO rmn_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Бирдэн ало миляики э Сагбуско, тай э пханли тхабили ярэкеса. О миляики диняс бутуря э Пётарэс андэ риг тай джянгавдяс лэс. — Ущи дэба! — пхэнляс ов, тай о джянджира пэлэ катар васта ко Пётар. ");
INSERT INTO rmn_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","О миляики пхэнляс: — Пхандэ кустик тай уряв минидэс. О Пётар кердяс адава. — Уряв тэ савутя тай джя пал мандэ, — пхэнляс о миляики. ");
INSERT INTO rmn_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","О Пётар никлисто пал миляики андар пханли, на галёлас, кай алаи, со керэл о миляики, си чячес. Лэски сикавдёлас, кай ов дикхел дикхипэ. ");
INSERT INTO rmn_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Он накхлэ пашал ангалунэ барэ, дэчи пашал авэра тай пашылэ ки састурни бар, кай гелэл андэ диз. Э бар ой сам пхутэрдили ангал лэндэ, тай он никлистэ. Он накхлэ екх улица, тай бирдэн о миляики на уло. ");
INSERT INTO rmn_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Кана о Пётар галилопэс, ов пхэнляс: — Акана мэ чячес джянав, кай о Сагбус бичялдяс Пэ миляикес тай кутарды ман катар васт ки Иродеско тай одолэ хурлукестар, саво мангелас манги о иудейски дюняс. ");
INSERT INTO rmn_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Галило, со уло, о Пётар гело андэ кхер ки Мария, ки дай ки Иоаннески, савэски генэ пхэнэнас Марк, катэ кидиндилэ тэ манген э Дэвлэс бут дюняс. ");
INSERT INTO rmn_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","О Пётар мардяс э бар, тай гели тэ пхутрэл э иргатинка Рода. ");
INSERT INTO rmn_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ой пэнджярдяс э Пётарэс катар сэси тай бристэрдяс катар лош тэ пхутрэл э бар, прастанили палэ тэ пхэнэл, кай о Пётар тэрдо ки бар. ");
INSERT INTO rmn_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","— Ту дэнилилян! — пхэнлэ лаки. Ай ой пхэнэлас, кай си адава чячипэ. — Адава лэско миляики, — гиндэ он. ");
INSERT INTO rmn_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","О Пётар озаман генэ марэлас, тай кана он пхутэрдэ э бар тай дикхлэ лэс, улэ шаштимэна. ");
INSERT INTO rmn_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","О Пётар сикавдяс лэнги вастэса тэ тэныкизэн тай пхукавдяс, сар о Сагбус никалдяс лэс андар пханли. — Пхукавэн адалэстар э Яковески тай аврэ пхралэнги, — пхэнляс ов лэнги тай гело отхар андэ аврэ тханэстэ. ");
INSERT INTO rmn_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Сабахтан машкарэ ко салдатя уло баро прастаипэ, никхон на джянэлас, со уло э Пётарэса. ");
INSERT INTO rmn_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","О Ирод пхэнляс тэ родэн лэс, тай на аракхлэ. Ов зораса пхучляс ко барэ тай пхэнляс тэ мударэн лэн. Дэчи о Ирод гело андар Иудея андэ Кесария тай ачило отхэ саво-то вахыти. ");
INSERT INTO rmn_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","О Ирод сас холямэ опэр мануша андар Тир тай Сидон. Одола зборисаилэ машкарэ пэстэ, алэ лэстэ. Он динэ икос пумарэ ригатэ э Бластэс, саво дикхел пал ки патишаеско кхер. Он мангенас лачипэ тэ овэл машкарэ лэндэ, вай лэнги область лэлас о хапэ катар область ки патишаески. ");
INSERT INTO rmn_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Андэ пхэнло дес о Ирод урявдяс патишаитико мантия, бэшло опэр цындомаритико тхан тай пхэнляс лэнги. ");
INSERT INTO rmn_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","О мануша лилэ тэ пхэнэн: — Адава о сэси э дэвлэско, ами на мануш! ");
INSERT INTO rmn_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Тай озаман о миляики э Сагбуско мудардяс э Иродес, вай ов на махтады э Дэвлэс, тай о Ирод, хало э кермэнца, муло. ");
INSERT INTO rmn_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Э збора э Дэвлэски джялас дур тай дур. ");
INSERT INTO rmn_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","О Варнава тай о Савл кердэ андэ Иерусалими о хэзмэти, саво тхэдо опэр лэндэ, лилэ пэса э Иоаннес, савэски генэ пхэнэнас Марк, тай гелэ палэ. ");
INSERT INTO rmn_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Андэ кхангери андэ Антиохия сас прарокя тай сикляримаря: о Варнава, о Симон, кай бучёлас Нигер, о Луцый андар Кирени, о Манаин, саво барило екхетханэ э сагбуса-тетрархеса э Иродеса, тай о Савл. ");
INSERT INTO rmn_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Екхвар, кана он керэнас иргатлыки э Сагбуски тай астарэнас оразас, о Шужо Духос пхэнляс: — Лэн Манги э Варнавес тай э Савлэс э дилаки, савяки Мэ лэн динём икос. ");
INSERT INTO rmn_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Тай он пал ко оразас тай пал ко мангипэ э Дэвлэс тхэдэ опэр лэндэ пумарэ васта тай муклэ лэн. ");
INSERT INTO rmn_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Адала дуй апостоля, бичялдэ э Шужэ Духоса, гелэ андэ Селевкия, ай отхар гелэ опрал пани ко Кипр. ");
INSERT INTO rmn_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Он алэ андэ Саламис тай отхэ пхукавэнас э Дэвлэски збора андэ синагогя ки иудеенги. Ли о Иоанн сас лэнца тай керэлас ярдыми лэнги. ");
INSERT INTO rmn_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Он накхлэ алаи о острав тай алэ андэ Пафос. Отхэ он дикхлэ екхе иудеес, саво бучёлас Вар-Исус, саво сас магиенго тай хохавно прароки. ");
INSERT INTO rmn_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ов сас э римски праконсулеса э Сергиеса Павлэса, манушэса барэ годяса. О праконсул диняс икос э Варнавес тай э Савлэс, мангелас тэ шунэл э збора э Дэвлэски. ");
INSERT INTO rmn_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ай адава Элима, о нав савэско си «магиенго», сас мамуй лэндэ тай мангелас тэ болдэл э праконсулес катар пакяпэ. ");
INSERT INTO rmn_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Дэчи о Савл, ов ли о Павел, пхэрдило Шужо Духос, дикхляс доврус карин Элима ");
INSERT INTO rmn_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","тай пхэнляс: — Чяво э Шэйтанеско, ту пхэрдо хохаипэ тай холи, тай на дэхэс нисаво чячипэ! Кана ту кан тэрдёс тэ болавэс о доврудэс дрома э Сагбуски? ");
INSERT INTO rmn_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","О васт э Сагбуско мамуй тутэ, ту кан овэс коро саво-то вахыти, на кан дикхес э кхамэско ярэки. Тай озаман агорады лэс тумани тай тэмина. Тай ов лиляс тэ прастал андар риг ки риг, родэлас кас-то, кон тэ гелэл лэс вастэстар. ");
INSERT INTO rmn_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Кана о праконсул дикхляс, со уло, ов пакянило, шаштимэ э сикляримаса катар Сагбус. ");
INSERT INTO rmn_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","О Павел тай лэса о мануша гелэ андар Пафос тай алэ андэ Пергия андэ Памфилия. Отхэ о Иоанн ачявдяс лэн тай ало палэ андэ Иерусалими. ");
INSERT INTO rmn_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Андар Пергия он гелэ англэ андэ писидийски Антиохия. Андэ суббота он алэ андэ синагога тай бэшлэ. ");
INSERT INTO rmn_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Пал ко драпкерипэ андар Тхэдипэ тай андар Прарокя о барэ э синагогаки пхэнлэ лэнги: — Пхралалэн, тэ си тумэндэ со-то лачё тэ пхэнэн э манушэнги, пхэнэн. ");
INSERT INTO rmn_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","О Павел ущино, сикавдяс вастэса тай пхэнляс: — Муршалэн израильтяня тай алаи, кай трашан катар Дэл, шунэн ман! ");
INSERT INTO rmn_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","О Дэл амарэ израилески дюняско лиляс Пэски амарэ дадэн. Ов ваздиняс э дюняс о вахыти, кана ов сас андэ джяти пху андэ Египти, тай зоралэ вастэса никалдяс лэн отхар. ");
INSERT INTO rmn_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Саранда брэш Ов дикхелас пал лэндэ андэ ливади. ");
INSERT INTO rmn_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ов мудардяс андэ Ханаан эфта дюнядэн тай диняс лэнги пху амарэ дадэндэ. ");
INSERT INTO rmn_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Опэр адалэстэ гело паш ко штаршэл пэинда брэш. Дэчи, джи ко вахыти ки прарокеско ки Самуилеско, о Дэл дэлас лэн цындомарен. ");
INSERT INTO rmn_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Дэчи о дюняс мангляс пэски патишаес, тай о Дэл диняс лэн андар порода ки Вениаминески э Саулес, э чявэс э Кишэскерэс. О Саул сас сагбус саранда брэш. ");
INSERT INTO rmn_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Дэчи о Дэл читяс э Саулес тай кердяс лэнги патишаес э Давидес. Ов пхэнляс лэстар: «Мэ аракхлём э Давидес, э чявэс э Иессеескерэс, манушэс Мэ илэскерэс. Ов кан керэл алаи, со Мэ кан мангав». ");
INSERT INTO rmn_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Андар порода ки Давидески о Дэл, сар пхэнляс, бичялдяс э Израилески Кутардимарес — э Исусес. ");
INSERT INTO rmn_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ангал отхэ, сар ало о Исус, о Иоанн дэлас икос алаи о дюняс э Израилеско тэ ачявэн пумарэ бэзя тай тэ болэнпэс. ");
INSERT INTO rmn_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Кана о Иоанн бытэрдиелас по хэзмэти, ов пхэнляс: «Кас тумэ гинэн ман? Мэ на Ов. Ай пал мандэ авэл Одова, Кастэ мэ на керав джи тэ пхутрав э кустик э минидэнги ко пинрэ». ");
INSERT INTO rmn_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Пхралалэн, пуя э породаки э Авраамески породаки тай одола, кон трашал катар Дэл! Адава габэри катар кутардипэ сас бичялдо амэндэ! ");
INSERT INTO rmn_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","О мануша, кай бэшэн андэ Иерусалими, тай лэнги барэ на пэнджярдэ э Христос, он цындоскердэ Лэс тай одолэса кердэ о зборэс э прарокенги, савэ драпкердён кажни суббота. ");
INSERT INTO rmn_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Он на аракхлэ андэ Лэстэ нисави дош, андар савятэ Ов камэл тэ мэрэл, ай манглэ э Пилатес тэ мударэн Лэс. ");
INSERT INTO rmn_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Кана он кердэ алаи, со Лэстар сас яздимэ, он читэ Лэс опрал каштуно хачи тай тхэдэ андэ склепи. ");
INSERT INTO rmn_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ай о Дэл дживиндярдяс Лэс андар мулэ, ");
INSERT INTO rmn_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","тай генэ бут дес одола, кон ало екхетханэ Лэса андар Галилея андэ Иерусалими, дикхлэ Лэс. Анкха он пхукавэн Лэстар э дюняски. ");
INSERT INTO rmn_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ай амэ пхукавас тумэнги анкха адава Лошано Габэри: одова, кай о Дэл диняс збора амарэ дадэн, ");
INSERT INTO rmn_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ов кердяс амэнги, лэнги пуенги, кана дживиндярдяс э Исусес. Адалэстар си яздимэ андэ дуйто псаломи: «Ту Чяво Минро, авдес Мэ аракхлём Тут». ");
INSERT INTO rmn_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ай одолэстар, кай о Дэл дживиндярдяс Лэс андар мулэ, аякха кай о тэни Лэско генэ на кан овэл прахос, Ов пхэнляс аякха: «Мэ кан дав тумэн шужэ тай бипароимаски алгыша э Давидески». ");
INSERT INTO rmn_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ай аврэ тханэстэ Ов пхэнэл: «Ту на кан дэс Тэ Шужэски тэ овэл прахос». ");
INSERT INTO rmn_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","О Давид андэ пэ вахытестэ керэлас, со мангляс о Дэл. О Давид муло, лэс пароскердэ лэски дадэнца, тай о тэни лэско уло прахос. ");
INSERT INTO rmn_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Одолэстэ, Кас о Дэл дживиндярдяс, на тхабило о тэни. ");
INSERT INTO rmn_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Оничин, пхралалэн, мэ мангав, тумэ тэ джянэн, кай булуб Лэски тумэнги авдес пхукавдёл о мукипэ э бэзенго. О Тхэдипэ э Маисееско нащи керэлас э манушэс чячес, ");
INSERT INTO rmn_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ай кажни, кон пакял э Исусески, булуб Лэски диндёл чячипэ. ");
INSERT INTO rmn_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Дикхен, тэ на овэл тумэнца одова, состар пхэнлёл ко прарокя: ");
INSERT INTO rmn_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","«Дикхен, асаимаскерэ, шаштиен тай мэрэн, вай Мэ керав андэ тумарэ десендэ асавко, соски тумэ никана на пакянас, тэ пхукавэнас би тумэнги адалэстар». ");
INSERT INTO rmn_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Кана о Павел тай о Варнава никлёнас андар синагога, лэн манглэ тэ пхэнэн одолэстар генэ авэр суббота. ");
INSERT INTO rmn_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","О мануша андар синагога гелэ пэски, ай о бут иудея тай чяче мануша о празелитя гелэ пал Павел тай Варнава. Одола зборизэнас лэнца тай галярэнас лэнги ли англэ тэ бэшэн андэ Дэвлэски мила. ");
INSERT INTO rmn_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Авэр суббота би залагеско алаи э диз кидиняспэс тэ шунэн о зборэс э Сагбуски. ");
INSERT INTO rmn_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Кана о иудея дикхлэ сокабор дюняс, он пхэрдилэ кисгандилима тай лилэ тэ кушэн одова, со пхэнэл о Павел. ");
INSERT INTO rmn_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Дэчи о Павел тай о Варнава битрашако пхэнлэ лэнги: — Э збора э Дэвлэски камэл ангал тэ овэл пхукавди тумэнги. Ай аякха сар тумэ на манген адава тай на гинэн тумэн кай керэн э бибытимаско бэшыпэ, анкха амэ кан пхукавас наиудеенги. ");
INSERT INTO rmn_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Вай аякха о Сагбус пхэнляс амэнги: «Мэ кердём Тут ярэки алаи э дюнядэнги, тай андар Тутэ о кутардипэ тэ джял ко четя ки пхуяки». ");
INSERT INTO rmn_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Кана о наиудея шунлэ адава, он лошазэнас тай махтадиенас э Сагбус андар Лэски зборатэ, тай алаи, савэ камэл тэ овэн андэ бибытимаско бэшыпэ, пакянилэ. ");
INSERT INTO rmn_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Э збора э Сагбуски гили опэр алаи одоя пху. ");
INSERT INTO rmn_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","О иудея ваздинэ э чяче джювлен андар намлыдэс хорандадэс тай э барэн э дизакерэн, тай одола ваздинэ родипэ мамуй ко Павел тай ко Варнава тай кувдылар лэн андар пумарэ тханэндар. ");
INSERT INTO rmn_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Дэчи он кактылар о прахос опрал пумарэ пинрэндэ тай гелэ андэ Иконий. ");
INSERT INTO rmn_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","О сиклярдэ сас пхэрдэ лошаса тай Шужэ Духоса. ");
INSERT INTO rmn_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Андэ Иконий о Павел тай о Варнава динэ, сар екхараи, андэ иудейски синагога тай пхэнэнас аякха, кай пакянилэ бут иудея тай грекя. ");
INSERT INTO rmn_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ай о иудея, савэ на пакян, ваздинэ наиудеен тай болдинэ лэн мамуй ко пхрала. ");
INSERT INTO rmn_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ай о Павел тай о Варнава ачёнас отхэ бут вахыти. Он доврус пхэнэнас, ай о Сагбус зоралякерэлас По габэри катар мила кай дэлас лэн зор тэ керэн сикаиматэс тай чюдэс. ");
INSERT INTO rmn_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","О мануша андэ диз паляштыларпэс. Сарсавэ сас андар иудея, ай сарсавэ сас андар апостоля. ");
INSERT INTO rmn_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ай кана о наиудея тай о иудея екхетханэ пумарэ барэнца манглэ тэ холязэн лэнги тай тэ марэн лэн барэнца, ");
INSERT INTO rmn_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","одола галилэ адалэстар, нашлэ андэ диза ки Ликаонияки, андэ Листра тай Дервия тай ко тхана агорял лэндэ, ");
INSERT INTO rmn_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","катэ генэ пхукавэнас Лошано Габэри. ");
INSERT INTO rmn_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Андэ Листра бэшэлас мануш, савэски чянга на кхелавэнаспэс. Ов лангалас, сар аракхлило, тай никана на пхерэлас. Ов сас бэшло ");
INSERT INTO rmn_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","тай шунэлас одова, со пхэнэлас о Павел. О Павел дикхляс карин лэстэ тай дикхляс, кай одолэстэ си пакяпэ аиндимаски. ");
INSERT INTO rmn_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","— Ущи опрэ! — бэбэряса пхэнляс ов э бангески. Одова читяспэс тай лиляс тэ пхерэл. ");
INSERT INTO rmn_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","О мануша дикхлэ, со кердяс о Павел, тай лилэ тэ дэн бэбэря опэр ликаонски чиб: — Амэндэ фулистинэ о дэла, кай ушадиен манушэнги! ");
INSERT INTO rmn_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Он тхэдэ э Варнавес Зевс, ай э Павлэс Гермес, вай ов сас баро андэ зборима. ");
INSERT INTO rmn_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ангал диз сас храми э Зевсеско, тай лэско попази андяс ки дизаки бар гурувэн тай венокя, мангелас екхетханэ э дюняса тэ анэн лэнги курбанес. ");
INSERT INTO rmn_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Кана о апостоля о Варнава тай о Павел шунлэ адалэстар, он пхаравдэ пумарэ савутя, читэпэс андэ дюняс тай лилэ тэ дэн бэбэря: ");
INSERT INTO rmn_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","— Галёнтумэн, со тумэ керэн? Амэ асавке мануша, сар ли тумэ! Амэ андямус тумэнги Лошано Габэри, тай амэ мангас, тумэ тэ ачявэн адалэ бифайдаски дэвлэн тай тэ болдэн тумэн ко дживиндо Дэл, Саво кердяс одова, со си опрэ, тай э пху, э моря тай алаи, со си андэ лэндэ. ");
INSERT INTO rmn_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Буруни Ов мукелас э дюнядэн тэ пхерэн кажнески пэ дромэса, ");
INSERT INTO rmn_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ай генэ сикавэлас Пэс, керэлас лачипэ, бичялэлас тумэнги брышым опрал тай имиша андэ по вахыти, дэлас хапэ тай пхэрэлас тумарэ илэ лошаса. ");
INSERT INTO rmn_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ай джи адалэ зборэнца генэ залаг, тай кан анэнас лэнги курбанес. ");
INSERT INTO rmn_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ай о иудея, савэ алэ андар Антиохия тай Иконий, бангярдэ э дюняс пэ ригатэ. Э Павлэс мардэ барэнца тай сидинэ пал диз, тюшундиенас, кай ов муло. ");
INSERT INTO rmn_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ай кана о сиклярдэ кидинэпэс агорял лэстэ, ов ваздиняспэс тай гело палэ андэ диз. Авэр дес он э Варнавеса гелэ андэ Дервия. ");
INSERT INTO rmn_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Он пхукавэнас Лошано Габэри андэ адалэ дизатэ, тай лэндэ улэ бут сиклярдэ. Дэчи он гелэ палэ андэ Листра, Иконий тай Антиохия. ");
INSERT INTO rmn_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Отхэ он зоралякерэнас э сиклярдэн тай пхэнэнас лэнги тэ ачён зоралэ андэ пакяпэ. — Амэнги камэл тэ накхас бут хурлуки ангал отхэ, сар амэ кан дас андэ Дэвлэско Патишайлыки, — пхэнэнас он. ");
INSERT INTO rmn_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","О Павел тай о Варнава андэ кажни кхангерятэ тхэдэ барэн, манглэ э Дэвлэс оразаса тай динэ лэн ко Сагбус, андэ Савэстэ он пакянилэ. ");
INSERT INTO rmn_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Дэчи он накхлэ э Писидия тай алэ андэ Памфилия. ");
INSERT INTO rmn_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Пал отхэ, сар он пхукавдэ э збора андэ Пергия, он алэ андэ Атталия. ");
INSERT INTO rmn_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Андар Атталия он накхен опрал пани палэ андэ Антиохия. Атхэ кана-то лэн динэ э Дэвлэски лачимаса тэ керэн бути, сави он анкха бытэрдылар. ");
INSERT INTO rmn_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Кана он алэ андэ Антиохия, он кидинэ э кхангери тай пхукавдэ адалэстар, со кердяс о Дэл андар лэндэ тай сар Ов пхутэрдяс о удар э пакямаско наиудеенги. ");
INSERT INTO rmn_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Отхэ он сас бут вахыти екхетханэ э сиклярдэнца. ");
INSERT INTO rmn_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Андар Иудея андэ Антиохия алэ мануша, савэ лилэ тэ сиклярэн э пхралэн: — Тумэ тэ на керэна абрезания, сар пхэнляс о Маисей, тумэ нащи овэн кутардимэна. ");
INSERT INTO rmn_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Адава андяс ко барэ ирищиматэс тай ко чингара машкарэ лэндэ э Павлэса тай э Варнавеса. Он гиндэ, со о Павел, о Варнава тай набут мануша лэндар кан джян андэ Иерусалими тэ зборизэн адалэстар э апостоленца тай э барэ манушэнца. ");
INSERT INTO rmn_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Э кхангери мукляс лэн, тай он гелэ андар Финикия тай Самария, пхукавэнас отхэ одолэстар, сар наиудея лэн тэ пакян э Дэвлэски. Адава габэри лошаскерэлас алаи э пхралэн. ");
INSERT INTO rmn_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Кана он алэ андэ Иерусалими, он дихлэпэс э кхангеряса, э апостоленца тай э барэ манушэнца тай пхукавдэ лэнги алаестар, со о Дэл кердяс андар лэндэ. ");
INSERT INTO rmn_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ай о пакялэ, савэ сас андар джемэяти ки фарисеенго, пхэнэнас, о наиудея тэ керэн абрезания тай тэ бэшэн, сар пхэнэл о Тхэдипэ э Маисееско. ");
INSERT INTO rmn_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","О апостоля тай о барэ мануша кидинэпэс, тэ зборизэн адалэстар. ");
INSERT INTO rmn_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Пал ко бут зборима о Пётар ущино тай пхэнляс: — Пхралалэн, сар тумэ джянэн, накхло бут вахыти одолэ десестар, сар о Дэл лиляс андар тумэндэ ман тэ пхукавав э збора э Лошанэ Габэрески э наиудеенги, тай он тэ пакян. ");
INSERT INTO rmn_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","О Дэл, Саво джянэл э манушэнги илэ, башлады лэнги о Шужо Духос аякха, сар ли амэнги, тай сикавдяс адалэса, кай мукел лэн Пэстэ. ");
INSERT INTO rmn_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ов на керэл нисаво палящима машкарэ амэндэ тай лэндэ, ай андар пакяпэ шужардяс ли лэнги илэ! ");
INSERT INTO rmn_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ай соски тумэ зумавэн э Дэвлэс тай тхэн опэр мэня ки сиклярдэнги хамути, саво нащи гелэнас нэ амарэ дада, нэ амэ? ");
INSERT INTO rmn_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Вай амэ пакяс одолэски, кай диндяс кутардипэ андар мила ки Сагбуски Исусески. Аякха кутардиенпэс ли он. ");
INSERT INTO rmn_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Дэчи алаи тэныкисаилэ тай лилэ тэ шунэн о пхукаипэ э Варнавеско тай э Павлэско катар сикаипэ тай катар чюдэс, савэ о Дэл кердяс андар лэндэ машкарэ ко наиудея. ");
INSERT INTO rmn_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Кана он бытырдылар, о Яков пхэнляс: — Пхралалэн, шунэн ман. ");
INSERT INTO rmn_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","О Симон пхукавдяс амэнги одолэстар, сар о Дэл баштутнэс ало ко наиудея тай лиляс Пэски дюняс. ");
INSERT INTO rmn_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Адалэстар пхэнэн ли о прарокя, сар си яздимэ: ");
INSERT INTO rmn_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","«Дэчи Мэ кан авав тай генэ кан ваздав э пэравди катуна э Давидески. Мэ кан гортярав лако хурдярипэ тай доврус кан тхав ла, ");
INSERT INTO rmn_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","тай авэра мануша тай алаи о дюнядэс, савэ сас тхэдэ Мэ навэса, лилэ тэ родэн э Сагбус. Аякха пхэнэл о Сагбус, Саво керэл алаи адава, ");
INSERT INTO rmn_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","со Ов джянэл чёктан». ");
INSERT INTO rmn_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Оничин мэ гинав, кай амэ на камэл тэ керас пхарипэ э наиудеенги, савэ авэн ко Дэл. ");
INSERT INTO rmn_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ами амэ камэл тэ яздияс лэнги письмас, он тэ дурён катар шэя, гарамя э идолэнца, катар кахпэлыки, катар мас ки тасавдэ гайваненго тай катар рат. ");
INSERT INTO rmn_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Вай о Тхэдипэ э Маисееско чёктан пхукавдёл андэ кажни дизатэ тай драпкердёл андэ синагогя кажни суббота. ");
INSERT INTO rmn_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","О апостоля тай о барэ мануша екхетханэ э кхангеряса гиндэ тэ лэн сарсавэ манушэн андар пумарэндэ тай тэ бичялэн лэн э Павлэса тай э Варнавеса андэ Антиохия. Он лилэ э Иудас, савэски дага пхэнэнас Вар-Савва, тай э Силас. Адала дуй сас барэ машкарэ ко пхрала. ");
INSERT INTO rmn_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Лэнца бичялдэ акасавко письмас: «Катар пхрала апостоля тай барэ мануша э пхралэнги андар наиудея, савэ си андэ Антиохия, Сирия тай Киликия: Сэлями тумэнги! ");
INSERT INTO rmn_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Амэндэ шунлэ одолэстар, кай сарсавэ мануша, кай алэ амэндар, андэ тумэнги пумарэ зборэнца касэвэти тумарэ илэнги. Ай амэ лэнги ништо адава на пхэнлям. ");
INSERT INTO rmn_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Оничин амэ алаи екхетханэ гиндям тэ лас андар амарэндэ сарсавэ манушэн тай тэ бичялас лэн тумэндэ екхетханэ амарэ багалыдэнца э Варнавеса тай э Павлэса, ");
INSERT INTO rmn_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","савэ си газыри тэ мэрэн андар нав амарэ Сагбуско ки Исусеско Христоско. ");
INSERT INTO rmn_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Амэ бичялас тумэндэ э Иудас тай э Силас, тай он зборэнца тэ пхукавэн одова, со амэ яздияс. ");
INSERT INTO rmn_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","О Шужо Духос тай амэ гиндям тэ на керас тумэнги пхарипэ ништоса, екх одолэса, со камэл: ");
INSERT INTO rmn_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ма хан хапэ, саво андэ курбани аврэ дэвлэнги, мас тасавдэ гайваненго, рат, тай дурён катар кахпэлыки. Тумэ тэ керэн адава, тумэ кан керэн лачипэ. Ачён Дэвлэса!» ");
INSERT INTO rmn_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","О бичялдэ гелэ тай алэ андэ Антиохия. Отхэ он кидинэ э кхангери тай динэ о письмас. ");
INSERT INTO rmn_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","О мануша драпкердэ лэс тай лошасаилэ э лаче габэрески. ");
INSERT INTO rmn_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","О Иуда тай о Сила, савэ сас прарокя, пумарэ зборэнца зоралякерэнас тай сиклярэнас э пхралэн. ");
INSERT INTO rmn_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Он сас отхэ саво-то вахыти, тай о пхрала лачимаса муклэ лэн одолэндэ, кон лэн бичялдяс. ");
INSERT INTO rmn_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","О Павел тай о Варнава ачилэ андэ Антиохия, катэ он бутэ аврэ пхралэнца сиклярэнас тай пхукавэнас э збора э Сагбуски. ");
INSERT INTO rmn_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Вахытестар о Павел пхэнляс э Варнавески: — Эла джяс ко пхрала андэ алаи диза, катэ амэ пхукавасас э збора э Сагбуски, тай кан дикхас, сар лэндэ джял э дила. ");
INSERT INTO rmn_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","О Варнава мангляс тэ лэл пэса э Иоаннес, савэски генэ пхэнэнас Марк, ");
INSERT INTO rmn_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ай о Павел на мангелас тэ лэл пэса одолэс, кон ачявдяс лэн андэ Памфилия тай на кердяс ярдыми тэ керэн пумари бути. ");
INSERT INTO rmn_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","О ирищима сас асавко, кай он екхаврэстар дурилэ. О Варнава лиляс э Маркес тай гело опрал пани андэ Кипр, ");
INSERT INTO rmn_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ай о Павел лиляс э Силас. О пхрала динэ лэн андэ Сагбуски мила, тай он гелэ ко дром. ");
INSERT INTO rmn_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","О Павел накхелас андар Сирия тай Киликия тай зоралякерэлас о кхангеря. ");
INSERT INTO rmn_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","О Павел ало андэ Дервия тай Листра. Отхэ бэшэлас сиклярдо, саво бучёлас Тимафей. Э дай э Тимафеески сас пакяли иудейка, ай о дад лэско сас греки. ");
INSERT INTO rmn_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Катар Тимафей лачё пхэнэнас о пхрала андэ Листра тай Иконий. ");
INSERT INTO rmn_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","О Павел мангляс тэ лэл лэс пэса ко дром. Тай булуб э иудеенги, савэ бэшэнас одолэ дизэндэ, кердяс лэски абрезания, вай алаи джянэнас, кай о дад э Тимафееско сас греки. ");
INSERT INTO rmn_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","О Павел тай кон э сас лэса пхерэнас андар диз андэ диз тай сиклярэнас э пакялэн тэ астарэнпэс ко сиклярипэ ки апостоленго тай ки барэ манушэнго андэ Иерусалими. ");
INSERT INTO rmn_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","О кхангеря зоралёнас андэ пакяпэ, тай о гиндипэ э пакялэнго кажын дес бутёлас. ");
INSERT INTO rmn_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Он накхлэ андар Фригия тай Галатия, ай о Шужо Духос на мукляс лэн тэ пхукавэн э збора андэ правинцыя Азия. ");
INSERT INTO rmn_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Он пашылэ ко чети Мисия тай кидинэпэс тэ джян андэ Вифиния, ай о Духос э Исусеско на мукляс лэн, ");
INSERT INTO rmn_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","тай он накхлэ э Мисия тай алэ андэ Троас. ");
INSERT INTO rmn_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Рати о Павел дикхляс дикхипэ: лэстэ ало мануш андар Македония. Ов сас тэрдо тай мангелас лэс: — Эла андэ Македония тай кер ярдыми амэнги! ");
INSERT INTO rmn_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Пал адалэ дикхимастэ амэ гиндям, кай о Дэл бичялэл амэн тэ пхукавас лэнги о Лошано Габэри, тай лилэ тэ гортярэнпэс тэ джян андэ Македония. ");
INSERT INTO rmn_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Андар Троас амэ накхлям доврус андэ Самофракия тай отхар авэр дес андэ Неаполь. ");
INSERT INTO rmn_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Андар Неаполь амэ гелям андэ Филиппи, андэ римски калония тай андэ бари диз одолэ ригатэ ки Македония. Отхэ амэ самас набут дес. ");
INSERT INTO rmn_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Андэ суббота амэ никлистям пал бар ки дизаки ки диряв, катэ, сар амэ тюшундиясас, сас тхан тэ зборизас э Дэвлэса. Амэ бэшлям тай лилям тэ зборизас э джювлянца, савэ отхэ кидэнаспэс. ");
INSERT INTO rmn_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Машкарэ лэндэ сас екх, сави бучёлас Лидия, андар диз Фиатира, сави бикнэлас багалыдэс лолэ-синя басмадэс. Э Лидия гинэлас э Дэвлэс, тай о Сагбус пхутэрдяс лако ило одолэстэ, со пхэнэлас о Павел. ");
INSERT INTO rmn_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Пал отхэ, сар ой тай лаки кхерутнэ сас болдэ, ой диняс икос амэн пэстэ. — Тумэ тэ гинэн ман чячя э Сагбуски, дэчи элан тай ачён мандэ андэ кхер, — ой лачес-лачес мангелас, тай амэ кердям аякха. ");
INSERT INTO rmn_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Екхвар, кана амэ джясас ко тхан, катэ зборизасас э Дэвлэса, опэр дром дикхлям екхе иргатинка, андэ савятэ сас духос Питонеско. Дорикеримаса ой анэлас баро казандима пэ сагбудэнги. ");
INSERT INTO rmn_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Э иргатинка джялас пал ко Павел тай пал амэндэ тай дэлас бэбэря: — Адала мануша — иргатя э Уче Дэвлэски! Он пхукавэн тумэнги о дром э кутардимаско! ");
INSERT INTO rmn_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ой керэлас адава бут деса, тай кана э Павлэс адава быздэрды, ов болдиняспэс тай пхэнляс э духоски: — Андэ Нав ки Исусеско Христоско мэ пхэнав туки: никлё андар латэ! Бирдэн о духос ачявдяс ла. ");
INSERT INTO rmn_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Кана лаки сагбудэс галилэ, кай лэндэ быты о казандима, он астардэ э Павлэс тай э Силас тай сидинэ лэн ко майдани ки дизаки барэ. ");
INSERT INTO rmn_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Он андэ лэн ко преторя ки дизаки тай пхэнлэ: — Адала мануша — иудея, тай он ваздэн касэвэти андэ амарэ дизатэ. ");
INSERT INTO rmn_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Он сиклярэн тэ керас одова, со амэнги, э римляненги, на камэл нэ тэ пакяс, нэ тэ керас. ");
INSERT INTO rmn_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","О дюняс екхетханэ лэнца керэлас дошалэн э Павлэс тай э Силас, тай о преторя пхэнлэ тэ пхаравэн опрал лэндэ о савутя тай тэ марэн ровленца. ");
INSERT INTO rmn_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Лэн лачес мардэ тай читэ андэ пханли, ай одолэски, кай дикхел пал пханли, пхэнлэ лачес пал лэндэ тэ дикхел. ");
INSERT INTO rmn_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Кана шунляс, со пхэнлэ лэски, ов пханляс лэн андэ андарутни пханли тай мардяс лэнги пинрэ андэ каштэстэ. ");
INSERT INTO rmn_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Паш ки екхпаш рат о Павел тай о Сила мангенас э Дэвлэс тай дэнас Лэски махтадимаски гиля, ай авэра пханлимаря шунэнас лэн. ");
INSERT INTO rmn_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Бирдэн уло асавко зорало пхуяко израипэ, кай о фундамент э пханляко кхелавдило. Алаи о удара пхутэрдилэ, тай алаи ко пханлимаря о джянджира пэлэ катар пинрэ. ");
INSERT INTO rmn_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Кана э пханляко баро джянгавдило тай дикхляс, кай алаи о удара э пханляки пхутэрдэ, ов лиляс камас тай мангляс тэ мударэл пэс, тюшундиелас, кай алаи о пханлимаря нашлэ. ");
INSERT INTO rmn_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ай о Павел диняс бэбэря: — Ма кер туки джюнгалипэ! Амэ алаи атхэ! ");
INSERT INTO rmn_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","О баро лиляс ярэки, прастанило андэ тай трашаса пэло ангал Павел тай ангал Сила. ");
INSERT INTO rmn_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ов никалдяс лэн андар тай пхучляс: — Сагбудэс минрэ, со манги тэ керав, тэ овав кутардимэ? ");
INSERT INTO rmn_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","— Пакя э Сагбуски Исусески, — пхэнлэ он, — тай ту, тай тэ кхерутнэ кан овэн кутардимэна. ");
INSERT INTO rmn_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Тай он пхукавдэ э збора э Сагбуски лэски тай алаи лэски кхерутнэнги. ");
INSERT INTO rmn_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Одова ратяко вахыти э пханляко баро халярдяс лэнги мардэ тхана тай сас болдо, ов тай алаи лэски кхерутнэ. ");
INSERT INTO rmn_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ов андяс э Павлэс тай э Силас пэстэ кхерэ тай тхэдяс лэнги конас. Екхетханэ алаи пэ кхерутнэнца ов лошазэлас одолэски, кай пакянило э Дэвлэски. ");
INSERT INTO rmn_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Уло дес, тай о преторя бичялдэ пумарэ иргатен андэ пханли тэ пхэнэн: — Тэ мукен адалэ манушэн. ");
INSERT INTO rmn_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Э пханляко баро пхэнляс э Павлэски: — О преторя пхэнлэ тэ мукав тумэн! Оничин никлён тай джян лачимаса! ");
INSERT INTO rmn_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ай о Павел пхэнляс: — Он би цындомаско мардэ амэн ангал дюняс, на дихлэ одолэски, кай амэ сам римскя мануша, тай читэ амэн андэ пханли. Анкха он манген амэн тэ мукен аякха, никхон тэ на джянэл? На! Мэ авэн он сам тай мэ никалэн амэн. ");
INSERT INTO rmn_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","О иргатя пхэнлэ адалэстар э преторенги, тай кана одола шунлэ, кай о Павел тай о Сила римскя мануша, трашанилэ. ");
INSERT INTO rmn_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Он алэ, пхэнлэ лэнги апувикерэн амэн, никалдэ лэн андар пханли тай манглэ тэ джян андар диз. ");
INSERT INTO rmn_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","О Павел тай о Сила никлистэ андар пханли тай гелэ андэ кхер ки Лидия. Отхэ он дикхлэпэс э пхралэнца тай зоралякердэ лэн. Дэчи он гелэ. ");
INSERT INTO rmn_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Он накхлэ э Амфиполь тай Аполлония тай алэ андэ Фессалоники, катэ сас э синагога э иудеенги. ");
INSERT INTO rmn_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","О Павел, сар екхараи, гело андэ синагога тай отхэ трин субботэс пал екхаврэстэ зборизэлас э иудеенца катар Яздипэ, ");
INSERT INTO rmn_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","галярэлас тай сиклярэлас, кай о Христос камэлас тэ мэрэл тай тэ дживиндёл андар мулэ. — О Исус, Савэстар мэ тумэнги пхукавав, да си о Христос, — пхэнэлас о Павел. ");
INSERT INTO rmn_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Лэнги пакянилэ сарсавэ иудея, аякха ли бут грекя, савэ гинэнас э Дэвлэс, тай бут намлыдэс джювля. Тай алаи он лилэ тэ пхерэн э Павлэса тай э Силаса. ");
INSERT INTO rmn_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Адава ваздиняс кизгандилима андэ аврэ иудеендэ, тай он лилэ налаче манушэн, савэн аракхлэ андэ базари, кидинэ дюняс тай ваздинэ э диз. Он гелэ ко кхер ки Иасонэско, родэнас э Павлэс тай э Силас, тэ никалэн лэн ко дюняс. ");
INSERT INTO rmn_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Кана он лэн отхэ на аракхлэ, он сидинэ э Иасонэс тай аврэ пхралэн ки дизаки барэ. — Адала мануша ваздэн алаи о дюняс, ай анкха алэ атхэ, — дэнас бэбэря о мануша. ");
INSERT INTO rmn_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","— Тай о Иасон мукляс лэн андэ по кхер. Он на керэн, со пхэнэл о император, тай пхэнэн, кай си авэр патишаи, Саво бучёл Исус. ");
INSERT INTO rmn_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Кана о дюняс тай э дизаки барэ шунлэ адава, трашанилэ. ");
INSERT INTO rmn_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Он лилэ катар Иасон тай аврэндар баро джерэмэс тай муклэ лэн. ");
INSERT INTO rmn_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Сар ули рат, о пхрала бичялдэ э Павлэс тай э Силас андэ Верия. Он алэ отхэ тай гелэ андэ иудейски синагога. ");
INSERT INTO rmn_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","О мануша андэ Верия сас пхутэрдэ илэнца, ниш андэ Фессалоники. Он лачес пакянилэ одолэски, со пхэнэлас о Павел, тай кажын дес сиклёнас о Яздипэ, тэ галён, чячипэ си одова, со он шунлэ. ");
INSERT INTO rmn_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","О бут андар лэндэ пакянилэ, пакянилэ ли бут намлыдэс гречянкес тай бут грекя. ");
INSERT INTO rmn_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ай кана о иудея андэ Фессалоники галилэ одолэстар, кай о Павел пхукавэл э збора э Дэвлэски андэ Верия, он алэ ли отхэ тай лилэ тэ ваздэн э дюняс. ");
INSERT INTO rmn_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","О пхрала чяльти бичялдэ э Павлэс ки моря, ай о Сила тай о Тимафей ачилэ андэ диз. ");
INSERT INTO rmn_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Одола, савэ гелдэ э Павлэс, алэ лэса андэ Афини, ай дэчи гелэ палэ э письмаса э Силаски тай э Тимафеески чяльти тэ авэн лэстэ. ");
INSERT INTO rmn_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","О Павел ишандиелас пэ амалэн, пхерэлас андэ Афини, тай лэс холяскерэлас, кай сас бут идоля андэ адалэ дизатэ. ");
INSERT INTO rmn_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ов зборизэлас андэ синагога э иудеенца тай э грекенца, савэ гинэн э Дэвлэс. Кажын дес ов зборизэлас э манушэнца, савэ авэнас андэ базари. ");
INSERT INTO rmn_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Лэса зборизэнас ли философя андар школэс эпикурейцэнги тай стоикенги. Сарсавэ пхученас: — Та со адава чюче-зборэнго мангел тэ пхэнэл? Авэра пхэнэнас: — Сар амэ галяс, ов пхукавэл катар джятя дэла, — вай о Павел пхукавэлас о Лошано Габэри катар Исус тай катар дживиндипэ. ");
INSERT INTO rmn_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Э Павлэс андэ опэр Ареопаг тай манглэ: — Пхукав амэнги, со нэво сиклярипэ си адава, саво ту сиклярэс? ");
INSERT INTO rmn_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Амэ на галяс, со ту пхэнэс, тай амэ мангас тэ джянас, со си адава. ");
INSERT INTO rmn_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","О афиняня тай савэ авэнас аврэ дизэндар алаендар бут дэхэнас тэ пхукавэн я тэ шунэн со-то нэво. ");
INSERT INTO rmn_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","О Павел тэрдило машкарэ ко Ареопаг тай пхэнляс: — Афиняня! Мэ алаестар дикхав, кай тумэ бут аврэндар гинэн э дэвлэн. ");
INSERT INTO rmn_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Мэ пхеравас агорял тай лачес дикхавас тумарэ шужэ тхана. Опэр екх андар алтари сас яздимэ: «НАДЖЯНЛЭ ДЭВЛЭСКИ». Адалэ наджянлэ Дэвлэстар, Савэс тумэ на джянэн, ами гинэн, мэ пхэнав тумэнги. ");
INSERT INTO rmn_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","О Дэл, кай кердяс о дюняс тай алаи, со си андэ лэстэ, си э Сагбуско опрунэско тай э пхуяко. Ов на бэшэл андэ храмя, кай си кердэ э манушэнги вастэнца. ");
INSERT INTO rmn_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ов на мангел, о мануша тэ керэн Лэски иргатлыки пумарэ вастэнца, сар кай Лэски со-то на рэсэл. Ов Сам дэл алаи э манушэн бэшыпэ, тынышы тай алаи авэр. ");
INSERT INTO rmn_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Екхе манушэстар Ов кердяс алаи э дюняс, тай о мануша тэ пхэрэн алаи э пху, тай ангал гиндяс, кана тай катэ он кан бэшэн. ");
INSERT INTO rmn_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Алаи адава о Дэл кердяс адалэски, о мануша тэ родэн Лэс тай тэ аракхен Лэс, ай Ов ли нанай дур кажнестар андар амэндэ. ");
INSERT INTO rmn_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Вай андэ Лэстэ амэ бэшас, пхерас тай сам, сар адалэстар пхэнэнас савэ андар тумарэ яздимарендэ: «Вай амэ сам Лэски порода». ");
INSERT INTO rmn_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Тай тэ сам э порода э Дэвлэски, дэчи амэ на камэл тэ керас э Дэвлэс пхолякерэс, рупунэс я барунэ идолэс я сарсави-то шавлин, керди, сар мангел тай сар галёл о мануш. ");
INSERT INTO rmn_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Буруни, кана о мануша на джянэнас э Дэвлэс, Ов адалэски пхандэлас Пэ якха, ай акана Ов тхэл алаи э манушэнги вэркатэ тэ ачявэн пумарэ бэзя. ");
INSERT INTO rmn_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ов тхэдяс о дес, кана Ов кан керэл чячё цындос алаи э дюняски, тай Ов акана аракхляс Манушэс, Саво ли кан овэл о цындомари. Ов сикавдяс адава ангал алаендэ, кай дживиндярдяс Лэс андар мулэ! ");
INSERT INTO rmn_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Кана он шунлэ катар дживиндипэ андар мулэ, сарсавэ андар лэндэ лилэ тэ асан, авэра пхэнлэ: — Адалэстар амэ кан шунас тут авэрвар. ");
INSERT INTO rmn_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Адалэса о Павел гело лэндар. ");
INSERT INTO rmn_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Набут мануша пакянилэ тай лилэ тэ пхерэн пал Павел. Машкарэ лэндэ сас о Дионисий андар Ареопаг, э манушни, сави бучёлас Дамарь, тай авэра. ");
INSERT INTO rmn_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Пал одолэстэ о Павел ачявдяс э Афини тай гело андэ Каринфи. ");
INSERT INTO rmn_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Отхэ ов дикхляс иудеес, савэско нав сас Акила, саво аракхлило андэ Понт. Одова набут дес палэ ало катар Италия пэ ромняса э Прискилласа, вай о император Клавдий пхэнляс алаи э иудеенги тэ джян андар Рим. О Павел ало лэндэ ");
INSERT INTO rmn_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","тэ бэшэл тай тэ керэл бути лэнца, вай лэндэ сас екх дила — он керэнас катунэс. ");
INSERT INTO rmn_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Кажни суббота ов зборизэлас андэ синагога э иудеенца тай э грекенца, мангелас, он тэ пакян. ");
INSERT INTO rmn_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Кана андар Македония алэ о Сила тай о Тимафей, о Павел лиляс алаи по вахыти тэ галярэл э иудеенги, кай о Исус — Христос. ");
INSERT INTO rmn_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Кана он лилэ тэ холязэн лэски тай тэ кушэн лэс, ов какты о прахос опрал савутя тай пхэнляс лэнги: — Тумэ та санус дошалэ тумарэ мэримаски! Мэ шужо, тай акана мэ джяв ко наиудея. ");
INSERT INTO rmn_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","О Павел никлисто андар синагога тай гело ко Титий Юст, саво гинэлас э Дэвлэс. Лэско кхер сас паш ки синагога. ");
INSERT INTO rmn_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","О баро э синагогако о Крисп тай алаи лэски кхерутнэ аякха пакянилэ э Сагбуски. Тай о бут андар каринфяня, савэ шунэнас э Павлэс, пакянилэ тай сас болдэ. ");
INSERT INTO rmn_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Екхвар рати о Сагбус пхэнляс э Павлэски андэ дикхипэ: — Ма траша! Англэ зборизэ тай ма тэныкизэ. ");
INSERT INTO rmn_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Мэ туса тай никхон на керэла туки налачипэ. Андэ адалэ дизатэ си бут мануша, савэ си Минрэ. ");
INSERT INTO rmn_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Тай о Павел сас отхэ екх тай екхпаш брэш, сиклярэлас лэн э збора э Дэвлэски. ");
INSERT INTO rmn_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Одова вахыти, кана о Галлион сас о праконсул э правинцыяко Ахаия, о иудея кидинэпэс, астардэ э Павлэс тай андэ лэс ко цындос. ");
INSERT INTO rmn_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Он пхэнлэ: — Адава мануш тхэл э манушэн тэ гинэн э Дэвлэс на аякха, сар сиклярэл амаро Тхэдипэ. ");
INSERT INTO rmn_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","О Павел дага ништо на пхэнляс, кана о Галлион пхэнляс э иудеенги, савэ керэн э Павлэс дошалэс: — Иудея, ов тэ керэлас би со-то налачё я джюнгало, озаман мэ тумэн кан шунавас. ");
INSERT INTO rmn_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ай атхэ ирищиен андар сиклярипэ, нава тай тумаро Тхэдипэ, дэчи дикхен тумэ сам. Мэ на мангав тэ овав цындомари андэ асавке дилэндэ. ");
INSERT INTO rmn_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Тай ов кувды лэн андар тхан ки цындоско. ");
INSERT INTO rmn_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Дэчи алаи астардэ э барэс э синагогакерэс э Сосфенес тай мардэ лэс ангал тхан ки цындоско, ай о Галлион на кердяс адалэски ништо. ");
INSERT INTO rmn_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","О Павел сас дага бут дес андэ Каринфи. Пал отхэ ов ачявдяс пэ пхралэн тай екхетханэ э Прискилласа тай э Акиласа гело ки Сирия. Ангал отхэ о Павел чиндяс пэ бала андэ Кенхрея, вай ов кана-то диняс збора э Дэвлэски. ");
INSERT INTO rmn_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Он алэ андэ Эфес, катэ о Павел ачявдяс э Прискиллас тай э Акилас, ай ов гело андэ синагога тай зборизэлас отхэ э иудеенца. ");
INSERT INTO rmn_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Он мангенас лэс тэ ачёл лэндэ генэ саво-то вахыти, ай ов на мангляс. ");
INSERT INTO rmn_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","— Мэ кан авав, тэ мангела о Дэл, — пхэнляс о Павел тай гело андар Эфес. ");
INSERT INTO rmn_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ов фулистино опрал карабляс андэ Кесария, ало андэ Иерусалими тай диняс сэлями атхутнэ кхангеряса, ай дэчи гело андэ Антиохия. ");
INSERT INTO rmn_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Отхэ о Павел сас набут вахыти, ай отхар гело андэ пхуя ки Галатия тай Фригия тай зоралякерэлас алаи э сиклярдэн. ");
INSERT INTO rmn_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Андэ Эфес одова вахыти ало иудеи, саво бучёлас Аполлос. Ов аракхлило андэ Александрия, сас мануш сиклярдо тай лачес джянэлас о Яздипэ. ");
INSERT INTO rmn_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ов сас сиклярдо о Дрома э Сагбуски тай пхэнэлас тхарэ илэса, чячипэ сиклярэлас катар Исус, гэм ов сам джянэлас екх о болдипэ э Иоаннеско. ");
INSERT INTO rmn_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","О Аполлос лиляс битрашако тэ пхэнэл андэ синагога, тай кана э Прискилла тай о Акила лэс шунлэ, он динэ икос лэс пэстэ тай лачес галярдэ лэски о Дром э Дэвлэско. ");
INSERT INTO rmn_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","О Аполлос мангляс тэ джял андэ Ахаия, тай о пхрала дэнас такати лэс тай яздылар письмас э сиклярдэнги, савэ бэшэнас отхэ, тай мангенас тэ мукен э Аполлос. Кана ов ало отхэ, ов кердяс баро ярдыми одолэнги, савэ э Дэвлэски милаки пакянилэ. ");
INSERT INTO rmn_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","О Аполлос пхэнэлас мамуй ко иудея ангал дюняс тай галярэлас о Яздипэ, кай о Исус си о Христос. ");
INSERT INTO rmn_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Одова вахыти, кана о Аполлос сас андэ Каринфи, о Павел накхло андар горадэнги тхана тай ало андэ Эфес. Отхэ ов дикхляс набут сиклярдэн. ");
INSERT INTO rmn_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","— Лилянус тумэ о Шужо Духос, кана пакянилянус? — пхучляс ов лэн. — Амэ джи на шунлям одолэстар, кай си Шужо Духос, — пхэнлэ одола. ");
INSERT INTO rmn_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Дэчи о Павел пхучляс: — Сар тумэ санусас болдэ? — Сар болэлас о Иоанн, — пхэнлэ он. ");
INSERT INTO rmn_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","О Павел пхэнляс: — О болдипэ э Иоаннеско сас болдипэ тэ муклён о бэзя. Ов пхэнэлас э дюняски тэ пакян Одолэски, Кон камэлас тэ авэл пал лэстэ, самким э Исусески. ");
INSERT INTO rmn_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Кана он шунлэ адалэстар, он болдэпэс андэ нав ки Сагбуско Исусеско. ");
INSERT INTO rmn_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Тай кана о Павел тхэдяс опэр лэндэ пэ васта, опэр лэндэ фулистино о Шужо Духос. Он дэчи лилэ тэ зборизэн аврэ чибэнца тай пхэнэн сар прарокя. ");
INSERT INTO rmn_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Алаи лэн сас паш ко дэшудуй мануша. ");
INSERT INTO rmn_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","О Павел трин чён битрашако пхэнэлас андэ синагога, зборизэлас э манушэнца катар Дэвлэско Патишайлыки тай галярэлас лэнги. ");
INSERT INTO rmn_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Савэ андар лэндэ холязэнас тай на мангенас тэ пакян, ангал алаендэ кушэнас о Дром э Исусеско. Дэчи о Павел ачявдяс лэн. Ов лиляс э сиклярдэн тай кажын дес зборизэлас лэнца андэ школа ки Тираннески. ");
INSERT INTO rmn_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Аякха сас дуй брэш, тай алаи о иудея тай о грекя, кай бэшэнас андэ правинцыя Азия, шунлэ э збора э Сагбуски. ");
INSERT INTO rmn_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","О Дэл керэлас андар Павел барэ чюдэс. ");
INSERT INTO rmn_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Э насвалэн дэнас тэ колизэн ко кхоснэ тай ко фотэс, савэндэ буруни колизэлас о Павел, тай лэндэ накхенас о дукха, тай о джюнгалэ духя никлёнас андар лэндэ. ");
INSERT INTO rmn_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Сарсавэ иудейскя магиенги, кай пхерэнас опэр дром, лилэ тэ дэн икос о нав э Сагбуско э Исусеско опэр одолэндэ, андэ савэндэ сас бишужэ. Он пхэнэнас: — Мэ пхэнав тумэнги совленца андэ нав ки Исусеско, Савэс пхукавэл о Павел. ");
INSERT INTO rmn_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Адава керэнас ли о эфта чявэ э Скеваски, э иудейски барэ попазески. ");
INSERT INTO rmn_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ай о джюнгало духи пхэнляс лэнги: — Э Исусес мэ джянав, ли о Павел си манги джянло, ами тумэ кон эсанус асавке? ");
INSERT INTO rmn_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Тай о мануш, андэ савэстэ сас о джюнгало духи, читяспэс опэр лэндэ асавке зораса, кай мардяс лэн алаен, тай он нашлэ андар кхер нанге тай дукхавдэ. ");
INSERT INTO rmn_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Кана одолэстар галилэ о иудея тай о грекя, кай бэшэнас андэ Эфес, лэн лиляс траш, тай он лилэ тэ гинэн лачес о нав э Сагбуско э Исусеско. ");
INSERT INTO rmn_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","О бут, савэ пакянилэ, авэнас тай ангал алаендэ пхукавэнас пумарэ дилэс. ");
INSERT INTO rmn_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ай о бут, кай керэнас магия, анэнас пумарэ магиенги книжкес тай ангал алаендэ тхарэнас лэн. Кана гиндэ, сокабор керэнас о тхардэ лила, уло пэинда биня драхмя. ");
INSERT INTO rmn_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Аякха э збора э Сагбуски барёлас тай пхэрдёлас зор. ");
INSERT INTO rmn_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Пал алаестэ адалэстэ о Павел тюшунды тэ джял ко Иерусалими андар Македония тай Ахаия. — Пал отхэ, сар мэ кан овав андэ Иерусалими, манги камэл тэ джяв ли ко Рим, — пхэнэлас ов. ");
INSERT INTO rmn_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ов бичялдяс ки Македония до ярдымарен э Тимафеес тай э Эрастэс, ай ов сам генэ савэ-то вахытески ачило андэ правинцыя Азия. ");
INSERT INTO rmn_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Андэ адава вахыти ули бари чингар андар Дром ки Сагбуско. ");
INSERT INTO rmn_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","О мануш, кай бучёлас Димитрий, рупунэ бутяко бутярно, керэлас катар руп храми э дэвлинкако э Артэмидако тай одолэса дэлас аканутнэ бутярнэн бут тэ казандиен. ");
INSERT INTO rmn_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ов кидиняс лэн ли аврэн асавке бутярнэн тай пхэнляс: — Тумэ джянэн, кай адая бути дэл амэн лачё казандима. ");
INSERT INTO rmn_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ай тумэ дикхен тай шунэн, кай адава Павел галярдяс тай гелдяс андэ хохаипэ бутэ дюняс на екх атхэ андэ Эфес, ами ли алаи ки правинцыя Азия. Ов пхэнэл, кай о дэла, кай си кердэ вастэнца, — адава нанай дэла. ");
INSERT INTO rmn_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","На екх амари бути андар адалэстэ кан нашавэл по лачё нав, ами ли о храми э барэ дэвлинкако э Артэмидако ништо на кан гиндёлпэс. Тай ой сам э дэвлинка, савя гинэл алаи э правинцыя Азия тай алаи э пху, кан овэл би дэвлэски баримаско! ");
INSERT INTO rmn_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Он шунлэ адава тай холяса дэнас бэбэря: — Бари Артэмида Эфесески! ");
INSERT INTO rmn_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Чяльти алаи э диз ваздиндили. О мануша астардэ э амалэн э Павлэскерэн, э македонянен э Гаес тай э Аристархес, тай алаи екхетханэ прастанилэ андэ театра. ");
INSERT INTO rmn_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","О Павел мангляс тэ никлёл ко дюняс, ай о сиклярдэ лэс на муклэ. ");
INSERT INTO rmn_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Джи сарсавэ барэ мануша э правинцыяки, о амала э Павлэски, пхэнлэ лэски тэ на авэл андэ театра. ");
INSERT INTO rmn_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Авэра дэнас бэбэря екх, авэра авэр. Уло баро прастаима. О бут на джянэнас, соски алэ. ");
INSERT INTO rmn_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","О иудея динэ бутуря ангал э Александрэс. Кон-то андар дюняс пхучляс лэс, тай о Александр кердяс вастэса э дюняски тэ тэныкизэл, ов тэ пхэнэл кутардимаски збора. ");
INSERT INTO rmn_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ай кана алаи галилэ, кай ов иудеи, тай лилэ екхе сэсеса тэ дэн бэбэря: — Бари Артэмида Эфесески! Тай дэнас бэбэря паш ко дуй сагатя. ");
INSERT INTO rmn_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Озаман ко дюняс никлисто э дизако яздимари. Ов тэрдярдяс лэн тай пхэнляс: — Эфесяня, си хоч екх мануш, саво на джянэл, кай э диз Эфес си дикхимари э храмеско э барэ Артэмидако тай лаки шавлиняко, кай пэли опрал? ");
INSERT INTO rmn_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Никхон на пхэнэл мамуй адалэстэ. Оничин тумэ камэл тэ тэрдярэн тай тэ на керэн ништо би тюшундимаско. ");
INSERT INTO rmn_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Тумэ андянус атхэ адалэ манушэн, гэм он на чёрдэ андар храми тай на кушлэ амарэ дэвлинка. ");
INSERT INTO rmn_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Тэ си ко Димитрий тай аврэ бутярнэндэ опэр кастэ-то холи, амэндэ адалэски си цындос тай о праконсуля. Отхэ мэ гелэн пумарэ доша. ");
INSERT INTO rmn_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Тэ си тумэндэ генэ саво-то пхучипэ, пхукав лэн тэ дикхен ки тхэдимаско кидипэ. ");
INSERT INTO rmn_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Я си траш, кай пал авдесутнэ дилэндэ амэн кан керэн дошалэн андэ чингара, вай амэ нащи кан галярас, соски атхэ кидинямамэн. Адалэ зборэнца ов мукляс о кидипэ. ");
INSERT INTO rmn_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Кана о чингара тэныкисаилэ, о Павел кидиняс э сиклярдэн, диняс такати, пхэнляс ов: «Ачё Дэвлэса!» — тай гело ки Македония. ");
INSERT INTO rmn_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ов накхелас одолэ тханэндар, бутэ зборэнца дэлас такати э пакялэн. Дэчи о Павел ало ки Грецыя ");
INSERT INTO rmn_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","тай сас отхэ трин чён. Кана ов кидэласпэс тэ джял карабляса андэ Сирия, о иудея гортярдэпэс тэ мударэн лэс, тай ов галило адалэстар тай гело палэ андар Македония. ");
INSERT INTO rmn_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Лэса сас о Сопатр, о чяво э Пирраско андар Верия, о фессалоникийца о Аристарх тай о Секунд, о Гай андар Дервия тай о Тимафей, генэ о Тихик тай о Трофим андар правинцыя Азия. ");
INSERT INTO rmn_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Он гелэ англэ тай ишандиенас амэн андэ Троас. ");
INSERT INTO rmn_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Амэ пал мисяфири ки Писное Питэнго джясас карабляса андар Филиппи тай пандже десендар улям лэнца андэ Троас. Отхэ амэ самас эфта дес. ");
INSERT INTO rmn_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Андэ екхто дес ки базареско кидинямамэн екхетханэ тэ пхагерас о манро. Авэр дес о Павел мангляс тэ джял дром, оничин ов бут зборизэлас, тай о зборима сидиняспэс джи машкарэ ки рат. ");
INSERT INTO rmn_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Опрэ андэ кхер, катэ амэ кидиндилям, тхабонас бут лампэс. ");
INSERT INTO rmn_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Опэр пэнчира бэшло сас тэрно мануш, саво бучёлас Евтих. О Павел кай бут зборизэлас, о Евтих суто тай пэло ки пху катар трито этажы. Кана лэс ваздинэ, ов сас муло. ");
INSERT INTO rmn_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","О Павел фулистино, пашлило опэр тэрно мануш тай диняс ангали лэс. — Ма трашан, — пхэнляс ов, — ов дживиндо! ");
INSERT INTO rmn_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","О Павел ваздиняспэс опрэ, пхагердяс о манро тай лиляс тэ хал. Опэр сабахтанятэ о Павел бытэрды тэ зборизэл тай гело дром, ");
INSERT INTO rmn_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","ай э тэрнэ манушэс гелдэ кхерэ дживиндэс, тай алаен адава лошаскердяс. ");
INSERT INTO rmn_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Амэ бэшлям опэр карабляс тай гелям андэ Асс, мангенас тэ лэн отхэ э Павлэс. Ов аякха пхэнляс, вай мангляс тэ джял опрал шукипэ. ");
INSERT INTO rmn_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Андэ Асс ов дикхляс амэн, тай амэ лилям лэс опэр карабляс тай гелям андэ Митилини. ");
INSERT INTO rmn_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Отхар амэ гелям карабляса тай авэр дес алям мамуй ко Хиос. Накхло генэ екх дес, тай амэ алям андэ Самос, ай авэр дес — андэ Милит. ");
INSERT INTO rmn_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","О Павел тюшунды тэ накхел пашал Эфес тэ на ачёл андэ правинцыя Азия, вай ов сигярэлас, мангелас тэ рэсэл андэ Иерусалими ко дес ки Пэиндако. ");
INSERT INTO rmn_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Андар Милит о Павел бичялдяс андэ Эфес тэ манген э барэ манушэн андар кхангери тэ авэн лэстэ. ");
INSERT INTO rmn_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Кана одола алэ, ов пхэнляс лэнги: — Тумэ джянэн, сар мэ бэшавас атхэ тумэндэ алаи о вахыти, сар мэ алём андэ правинцыя Азия. ");
INSERT INTO rmn_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Мэ ивашымаса тай авсенца керавас иргатлыки э Сагбуски, на дикхавас карин алаи ко пхариматэс, кай о иудея керэнас манги. ");
INSERT INTO rmn_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Мэ на мукавас ништо андар одолэстэ, со овэлас би тумэнги лачё, пхукававас тай сикляравас тумэн ангал дюняс тай андэ кхера. ");
INSERT INTO rmn_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Мэ пхэнавас ли э иудеенги, тай э грекенги, кай он камэл тэ пхутрэн пумарэ бэзя э Дэвлэски тай тэ пакян амарэ Сагбуски Исусески. ");
INSERT INTO rmn_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Анкха мэ бичялдо э Духоса тай джяв андэ Иерусалими, на джянав, со отхэ манца кан овэл. ");
INSERT INTO rmn_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Мэ джянав екх, кай о Шужо Духос пхукавэл манги одолэстар, кай андэ кажни дизатэ ман ишандиел пханлипэ тай хурлуки. ");
INSERT INTO rmn_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Мэ на трашав мэ бэшымаски, манги екх тэ накхав мо дром тай тэ бытэрдияв э бути, со пхэнляс манги о Сагбус Исус, тэ пхукавав о Лошано Габэри катар мила ки Дэвлэски. ");
INSERT INTO rmn_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Тай анкха мэ джянав, кай алаи тумэ, каса мэ зборизавас тай каски пхукававас катар Патишайлыки, генэ тумэ ман на кан дикхен. ");
INSERT INTO rmn_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Оничин мэ пхэнав авдес: мэ на кан овав дошало андэ никхаски мэримастэ, ");
INSERT INTO rmn_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","вай мэ бигараимаско пхукававас тумэнги э Дэвлэско мангипэ. ");
INSERT INTO rmn_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Дикхен пал тумэндэ тай пал алаи ки атара, андэ савятэ о Шужо Духос тхэдяс тумэн дикхимарен. Дикхен пал кхангери ки Дэвлэски, сави Ов киндяс Пэски кимяса Пэ ратэскеряса. ");
INSERT INTO rmn_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Мэ джянав, кана мэ кан джяв, тумэндэ кан авэн джюнгалэ рува, ай он э атара на кан аядиен. ");
INSERT INTO rmn_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Джи машкарэ тумэндэ кан овэн мануша, савэ кан лэн тэ болдэн о яздипэ, тэ гелэн э сиклярдэн пал пэстэ. ");
INSERT INTO rmn_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Оничин дикхен лачес! Мабристэн, кай мэ састэ трин брэш пхэнавас авсенца ли о дес ли э рат кажнески андар тумэндэ. ");
INSERT INTO rmn_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Анкха мэ дав тумэн ко Дэл тай ки збора Лэски милаки, сави кан сиклярэл тумэн тай кан дэл тумэн о барвалипэ, саво Ов пхэнляс тэ дэл Пэ шужэ дюнястэ. ");
INSERT INTO rmn_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Мэ никхастэ на мангавас нэ руп, нэ пхол, нэ савутя. ");
INSERT INTO rmn_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Вай тумэ джянен, кай мэ казандиявас мэ вастэнца мэ бэшымаски тай э бэшымаски мэ амалэнги. ");
INSERT INTO rmn_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Андэ алаестэ, со би мэ тэ на керавас, мэ сикававас тумэнги, сар камэл тэ керэс бути, тэ керас ярдыми э назоралэнги тай тэ на бристас катар зборэс ки Сагбуски Исусески: «Зиядэ тэ дэс, ниш тэ лэс». ");
INSERT INTO rmn_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Кана о Павел пхэнляс адава, бангярдяс алаенца пэ кочя тай мангляс э Дэвлэс. ");
INSERT INTO rmn_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Алаи ровэнас, дэнас ангали э Павлэс тай чюмидэнас лэс. ");
INSERT INTO rmn_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Лэн диняс касэвэти лэски зборэс одолэстар, кай он генэ лэс на кан дикхен. Дэчи он гелэ э Павлэса джи ко карабляс. ");
INSERT INTO rmn_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Амэ пхэнлям лэнги: «Ачён Дэвлэса!», никлистям андэ моря тай гелям доврус ко острав Кос. Авэр дес амэ алям андэ Родос тай отхар гелям андэ Патара. ");
INSERT INTO rmn_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Отхэ амэ аракхлям карабляс, кай джялас андэ Финикия, бэшлям андэ лэстэ тай гелям англэ. ");
INSERT INTO rmn_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Амэ накхлям о Кипр, муклям лэс ки леви риг тай гелям андэ Сирия. Амэ тэрдилям андэ Тир. Отхэ амаро карабляс камэлас тэ ачявэл пхарипэ. ");
INSERT INTO rmn_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Андэ Тир амэ аракхлям сиклярдэн тай ачилям лэндэ эфта дес. Катар Духос он пхэнэнас э Павлэски тэ на джял андэ Иерусалими. ");
INSERT INTO rmn_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Кана адала деса накхлэ пашыло о вахыти, амэ гелям англэ. Алаи о сиклярдэ, лэнги ромня тай о пуя гелэнас амэн андар диз. Ко чети ки панеско амэ тэрдилям опэр кочендэ тай пхэнасас э Дэвлэски. ");
INSERT INTO rmn_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Дэчи амэ пхэнлям лэнги: «Ачён Дэвлэса!» тай бэшлям андэ карабляс, ай он гелэ палэ кхерэ. ");
INSERT INTO rmn_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Амэ ачявдям о Тир тай алям андэ Птолемаис. Отхэ амэ дикхлям э пхралэн тай ачилям лэнца екх дес. ");
INSERT INTO rmn_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ай авэр дес амэ гелям дром тай алям андэ Кесария. Отхэ амэ тэрдилям андэ кхер ко Филиппи, саво пхукавэл о Лошано Габэри, о екх андар эфта иргатя. ");
INSERT INTO rmn_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Лэстэ сас штар чяя тэрнагаря, савэ пхэнэнас сар прарокя. ");
INSERT INTO rmn_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Пал отхэ, сар амэ самас отхэ бут дес, андар Иудея ало прароки, саво бучёлас Агав. ");
INSERT INTO rmn_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ов пашыло амэндэ, лиляс э кустик э Павлэски, пханляс ласа пэ чянга тай пэ васта тай пхэнляс: — О Шужо Духос пхэнэл: «Аякха о иудея андэ Иерусалими кан пхандэн тай кан дэн андэ васта ки наиудеенги э манушэс, каски адая кустик». ");
INSERT INTO rmn_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Амэ шунлям адава тай атхутнэ манушэнца лилям тэ мангас э Павлэс, тэ на джял андэ Иерусалими. ");
INSERT INTO rmn_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ай о Павел адалэски пхэнляс: — Соски тумэ ровэн тай пхаравэн мо ило? Мэ сом газыри на екх тэ овав пханло, ами ли тэ мэрав андэ Иерусалими андар нав ки Сагбуско Исусеско. ");
INSERT INTO rmn_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Кана амэ галилям, кай ов си зорало андэ пэ дилатэ, амэ тэныкисаилям, пхэнляс екх: — Мэ овэл аякха, сар мангел о Сагбус. ");
INSERT INTO rmn_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Пал отхэ кидинямамэн тай гелям андэ Иерусалими. ");
INSERT INTO rmn_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Амэнца гелэ сарсавэ сиклярдэ андар Кесария. Он андэ амэн андэ кхер ко киприоти Мнасон, чёктанлыс сиклярдо, савэстэ амэ ачилям. ");
INSERT INTO rmn_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Кана амэ алям андэ Иерусалими, о пхрала лошаса амэн муклэ пэстэ. ");
INSERT INTO rmn_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Авэр дес о Павел екхетханэ амэнца гело ко Яков. Отхэ сас алаи о барэ мануша. ");
INSERT INTO rmn_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","О Павел диняс сэлями лэн тай алаи пхукавдяс одолэстар, со о Дэл кердяс машкарэ ко наиудея андар лэско иргатлыки. ");
INSERT INTO rmn_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Он шунлэ лэс тай махтадылар э Дэвлэс. Дэчи он пхэнлэ э Павлэски: — Пхрала, ту дикхес, сокабора биня иудея пакянилэ, тай алаи он си кизгандимаря тэ Тхэдимаски. ");
INSERT INTO rmn_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Лэнги пхэнэн, кай ту сиклярэс э иудеен, савэ бэшэн машкарэ ко наиудея, он тэ на гинэн о Тхэдипэ э Маисееско, тэ на керэн абрезания пумарэ чявэнги тай тэ на бэшэн, сар камэл амэндэ. ");
INSERT INTO rmn_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Со тэ керас? Он, гэлбэтэм, кан шунэн одолэстар, кай ту алян. ");
INSERT INTO rmn_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Оничин кер, со амэ туки кан пхэнас. Машкарэ амэндэ си штар мануша, савэ динэ збора ангал Дэл. ");
INSERT INTO rmn_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Лэ лэн, накх екхетханэ лэнца о абряди э шужымаско тай покин андар лэндэ, он тэ моравэн пумарэ шэрэ. Дэчи алаи кан дикхен, кай о шунлипэ тутар нанай чячипэ тай ту керэс алаи, со си яздимэ андэ Тхэдипэ. ");
INSERT INTO rmn_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ай э пакялэнги наиудеенги амэ яздымус амарэ гиндимастар: он камэл тэ на хан о хапэ э курбанеско, саво андило э идолэски, мас тасавдэ гайваненго, тэ на пиен рат тай тэ астарэнпэс дур катар кахпэлыки. ");
INSERT INTO rmn_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Авэр дес о Павел лиляс пэса адалэ манушэн тай накхло лэнца о шужыпэ, сар камэл тэ кердёл. Пал отхэ ов диняс андэ храми тай пхэнляс, кана кан бытиен о деса э шужымаски тай кана андар кажнестэ лэндэ кан овэл андо курбани. ");
INSERT INTO rmn_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Кана бытиенас о эфта дес, набут иудея андар правинцыя Азия, кай дикхлэ э Павлэс андэ храми, ваздинэ алаи э дюняс тай астардэ лэс ");
INSERT INTO rmn_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","бэбэряса: — Израильтяня! Керэн ярдыми! Адава одова мануш, саво алаен вэркатэ сиклярэл мамуй амарэ дюнястэ, амарэ Тхэдимастэ тай амарэ храместэ. Анкха ов андяс андэ храми э грекен тай кердяс гарами адава шужо тхан. ");
INSERT INTO rmn_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ангал атхэ андэ диз он дикхенас э Павлэс екхетханэ э эфесянеса э Трофимеса тай тюшундылар, кай о Павел андяс лэс андэ храми. ");
INSERT INTO rmn_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Алаи э диз ваздиндили, кидиндило дюняс. Э Павлэс астардэ, сюрюдылар андар храми, тай э бар э храмески чяльти сас пханли. ");
INSERT INTO rmn_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Он мангенас тэ мударэн э Павлэс, ай о габэри одолэстар, кай алаи о Иерусалими андэ трашатэ, гело джи ки бинеско баро ки римски кагортеско. ");
INSERT INTO rmn_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ов чяльти лиляс салдатен тай э шэлэнги барэн тай прастанило ко дюняс. Кана о иудея дикхлэ э бинески барэс тай лэски салдатен, он тэрдилэ тэ марэн э Павлэс. ");
INSERT INTO rmn_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","О баро пашыло, астардяс э Павлэс тай пхэнляс тэ пхандэн лэс до джянджирэнца. Ов пхучелас ко дюняс, кон си адава тай со ов кердяс. ");
INSERT INTO rmn_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Сарсавэ андар дюняс дэнас бэбэря екх, авэра — авэр, тай асавке бэбэрятар ов ништо нащи галёлас. Дэчи ов пхэнляс тэ гелэн э Павлэс андэ салдатенго кхер. ");
INSERT INTO rmn_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Кана он сас опэр басамакя, о дюняс лилэ тэ тасавэн аякха, кай о салдатя ваздинэ тай гелдэ э Павлэс. ");
INSERT INTO rmn_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Бут дюняс джянас пал лэндэ тай дэнас бэбэря: — Мэрипэ лэски! ");
INSERT INTO rmn_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Ангал удар ко кхер ки салдатенго о Павел пхэнляс э бинески барэски: — Мук тэ пхэнав туки со-то? — Ту джянэс э гречески чиб? — пхучляс одова. ");
INSERT INTO rmn_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","— Самким, ту на одова египтяни, саво набут палэ ваздиняс чингар тай гелдяс пал пэстэ андэ ливади штар биня чёримарен? ");
INSERT INTO rmn_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","О Павел пхэнляс: — Мэ иудеи андар Тарс андэ Киликия, мануш барэ дизако. Мангав тут, мук ман тэ пхэнав э дюняски. ");
INSERT INTO rmn_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","О баро мукляс лэс. Дэчи о Павел тэрдило опэр басамакя тай вастэнца сикавдяс э дюняски тэ тэныкизэн. Кана уло тэныки, ов зборисаило еврейски чиб: ");
INSERT INTO rmn_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","— Пхралалэн тай дадалэн, мукен ман со-то тэ пхэнав тумэнги. ");
INSERT INTO rmn_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Кана он шунлэ, кай ов пхэнэл опэр еврейски чиб, тай уло май тэныки. Тай ов пхэнляс: ");
INSERT INTO rmn_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","— Мэ иудеи, аракхлилём андэ Тарс андэ Киликия, ай барилём мэ андэ адалэ дизатэ ко Гамалиил тай сомас сиклярдо алаи о Тхэдипэ амарэ дадэнго. Мэ кизгандимари э дилаки э Дэвлэскеряки, сар кажни андар тумэндэ авдес. ");
INSERT INTO rmn_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Мэ кувдиявас, маравас тай джи мударавас одолэн, савэ пхерэн э Исусеско Дром, линдяравас э муршэн тай э джювлен тай чявас лэн андэ пханля. ");
INSERT INTO rmn_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Адалэстар джянэн — о баро попази тай о барэ мануша. Мэ джи диндилём лэндар письмас э пхралэнги андар Дамаск тай гелём отхэ, тэ линдярав одолэн, кон отхэ сас, тай тэ анав лэн андэ Иерусалими хурлукески. ");
INSERT INTO rmn_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Опэр дром, кана мэ пашавас ко Дамаск, паш ко екхпаш дес бирдэн агорады ман баро ярэки опрал. ");
INSERT INTO rmn_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Мэ пэлём ки пху тай шунлём сэси, саво пхэнэлас манги: «Савл! Савл! Соски ту кувдиес Ман?» ");
INSERT INTO rmn_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Мэ пхучлём: «Кон Ту, Сагбуса?» Ов пхэнляс: «Мэ о Исус андар Назарет, Савэс ту кувдиес». ");
INSERT INTO rmn_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Манца о мануша дикхлэ ярэки, ай о сэси, саво мэ шунлём, он на шунлэ. ");
INSERT INTO rmn_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Мэ пхучлём: «Сагбуса, со манги тэ керав?» О Сагбус пхэнляс: «Ущи тай джя андэ Дамаск. Отхэ туки кан пхэнэн алаи, со камэл туки тэ керэс». ");
INSERT INTO rmn_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Вай о ярэки аякха тхаболас, кай мэ корилём. Тай одола мануша, савэ сас манца, вастэстар андэ ман андэ Дамаск. ");
INSERT INTO rmn_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Отхэ мандэ ало мануш, саво бучёлас Анания, кай керэлас алаи о Тхэдипэ тай намлыс машкарэ ко атхутнэ иудея. ");
INSERT INTO rmn_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ов пашыло мандэ, тэрдило пашэ тай пхэнляс: «Пхрала Савл, дикх!» Тай бирдэн мандэ пхутэрдилэ мэ якха, тай мэ дикхлём адалэ манушэс. ");
INSERT INTO rmn_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ов пхэнляс: «О Дэл амарэ дадэнго тхэдяс тут, тэ галёс ту, со Ов мангел, тэ дикхес э Чячес тай тэ шунэс о сэси андар Лэски уштэндэ. ");
INSERT INTO rmn_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ту кан пхукавэс э манушэнги одолэстар, со ту дикхлян тай шунлян. ");
INSERT INTO rmn_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ма ов тэмэли! Ущи, дэ икос Лэско нав, лэ болдипэ тай халяр тэ бэзя». ");
INSERT INTO rmn_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Дэчи мэ алём палэ андэ Иерусалими, тай кана мэ мангавас э Дэвлэс андэ храми, манги сас дикхипэ. ");
INSERT INTO rmn_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Мэ дикхлём э Сагбус, Саво пхэнэлас манги: «Чяльти никлё андар Иерусалими, вай атхэ на кан шунэн то пхукаипэ Мандар». ");
INSERT INTO rmn_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Мэ пхэнлём: «Сагбуса, адала мануша джянэн, кай мэ пхеравас андар синагога андэ синагога, тэ линдяравас тай маравас одолэн, савэ пакян Туки. ");
INSERT INTO rmn_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Кана чёрдёлас о рат э Стэфанеско, саво пхэнэлас Тутар, мэ сомас тэрдо катар риг одолэнгерятар, савэ мударэнас лэс, тай дикхавас пал лэнги савутендэ. ");
INSERT INTO rmn_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Дэчи о Сагбус пхэнляс манги: «Джя, Мэ бичялав тут ко дюнядэс, савэ бэшэн дур атхар». ");
INSERT INTO rmn_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Джи адалэ зборэндэ о дюняс шунэлас э Павлэс, тай лилэ тэ дэн бэбэря: — Кхосэн лэс опрал муй ки пхуяко! Ов на камэл тэ бэшэл! ");
INSERT INTO rmn_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Он дэнас бэбэря, кактиенас пумарэ савутя тай ченас опрэ о прахос. ");
INSERT INTO rmn_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Э бинеско баро пхэнляс тэ гелэн э Павлэс андэ салдатенго кхер. Ов пхэнляс тэ марэн лэс тай тэ пхучен, тэ галёл, соски о дюняс аякха холязэл лэски. ");
INSERT INTO rmn_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ай кана э Павлэс пханлэ тэ марэн, ов пхэнляс э тэрдэски пашэ э шэлэнгески барэски: — Та со, о тхэдипэ мукел тэ марэн римлянес камчияса тай би цындоско? ");
INSERT INTO rmn_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Кана э шэлэнго баро адава шунляс, ов гело тай пхукавдяс э бинески барэски. — Со ту керэс? Адава мануш си римляни, — пхэнляс ов. ");
INSERT INTO rmn_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Э бинеско баро никлисто ко Павел тай пхучляс: — Ту римляни? — Ва, — пхэнляс ов. ");
INSERT INTO rmn_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Дэчи э бинеско баро пхэнляс: — Мэ покиндём бут ловэ тэ овав римляни. — Ай мэ джи бияндилём римляни, — пхэнляс о Павел. ");
INSERT INTO rmn_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Одола, савэ камэлас лэс тэ пхучен, бирдэн гелэ лэстар. Э бинеско баро трашанило, кана галило, кай ов пханляс джянджирэнца римлянес. ");
INSERT INTO rmn_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Авэр дес э бинеско баро мангелас зиядэ тэ галёл, соски о иудея керэн дошалэс э Павлэс, пхутэрдяс лэс катар джянджира тай пхэнляс, тэ кидэнпэс о барэ попазя тай алаи о Синедриони. Дэчи ов андяс э Павлэс тай тхэдяс лэс ангал лэндэ. ");
INSERT INTO rmn_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","О Павел дикхляс карин мануша андар Синедриони тай пхэнляс: — Пхралалэн, джи авдесутнэ десестэ мэ бэшавас шужэ илэса ангал Дэл. ");
INSERT INTO rmn_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Тай о баро попази о Анания баримаса пхэнляс одолэнги, савэ си тэрдэ паш Павел, тэ чялавэн лэски ушта. ");
INSERT INTO rmn_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","О Павел дэчи пхэнляс: — О Дэл кан марэл тут, домонго мануш! Ту сан бэшло атхэ тэ керэс цындос манги, сар пхэнэл о Тхэдипэ, ай ту сам пхагерэс о Тхэдипэ, кана пхэнэс, тэ марэн ман! ");
INSERT INTO rmn_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Одола, кон сас тэрдо паш Павел, пхэнлэ лэски: — Сар ту кушэс э Дэвлэски барэ попазес? ");
INSERT INTO rmn_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","О Павел пхэнляс: — Пхралалэ, мэ на джянавас, кай ов баро попази, вай о Яздипэ пхэнэл: «Ма пхэн налачё опэр баро тэ дюняскерэстэ». ");
INSERT INTO rmn_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","О Павел джянэлас, кай андэ Синедриони сарсавэ сас саддукея, авэра — фарисея, оничин ов лачес пхэнляс: — Пхралалэн, мэ фарисеи, о чяво э фарисееско, тай манги керэн цындос андар ишандипэ, кай о мулэ кан дживиндён. ");
INSERT INTO rmn_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Кана ов адава пхэнляс, машкарэ ко фарисея тай ко саддукея ваздиндили чингар, тай о дюняс паляштыпэс, ");
INSERT INTO rmn_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","вай со о саддукея пхэнэн, кай нанай нэ дживиндипэ, нэ миляикенго тай духенго. О фарисея вай андэ алаи адалэстэ пакян. ");
INSERT INTO rmn_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ваздиндили бари бэбэря, сарсавэ сикляримаря э Тхэдимаски андар фарисея ущинэ тай зораса пхэнлэ: — Амэ на аракхас андэ адалэ манушэстэ ништо налачё. Ай со, лэса тэ пхэнэлас о духи я о миляики? ");
INSERT INTO rmn_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Э чингар ваздиндили аборкха, кай э бинеско баро трашалас, э Павлэс тэ на пхаравэн котора, пхэнляс э салдатенги тэ лэн лэс лэндар зораса тай тэ гелэн андэ салдатенго кхер. ");
INSERT INTO rmn_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Авэр рат ангал Павел тэрдило о Сагбус тай пхэнляс: — Ма траша! Сар ту пхукавэсас Мандар андэ Иерусалими, аякха ту камэл тэ пхукавэс ли андэ Рим. ");
INSERT INTO rmn_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Сабахтан сарсавэ иудея кидинэпэс тай динэ совля ништо тэ на хан тай тэ на пиен, бискай на мударэн э Павлэс. ");
INSERT INTO rmn_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Андэ адалэ зборимастэ сас бут катар саранда мануша. ");
INSERT INTO rmn_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Он гелэ ко барэ попазя тай ко барэ мануша тай пхэнлэ: — Амэ диням совля ништо тэ на лас андэ амарэ мостэ, бискай на мударас э Павлэс. ");
INSERT INTO rmn_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Акана тумэ тай о Синедриони манген э бинески барэс тэ анэн лэс тумэндэ хай одолэски, тэ галён зиядэ лэски дила. Ай амэ кан овас гортярдэ тай кан мударас лэс дага ангал отхэ, кай ов кан авэл джи адалэ тханэстэ. ");
INSERT INTO rmn_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Адалэстар галило о тухуми э Павлэско, о чяво лэски пхэняко. Ов гело андэ салдатенго кхер тай пхукавдяс адалэстар э Павлэски. ");
INSERT INTO rmn_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Дэчи о Павел диняс икос екхес андар шэлэнги барэс тай пхэнляс лэски: — Гелэн адалэ тэрнэс ки бинеско баро, лэстэ си со-то багалыс тэ пхэнэл лэски. ");
INSERT INTO rmn_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Э шэлэнго баро гелдяс э тэрнэс ки бинеско баро тай пхэнляс: — О пханло Павел диняс икос ман тай мангляс тэ анав акалэ тэрнэс тутэ. Лэстэ си со-то багалыс тэ пхэнэл туки. ");
INSERT INTO rmn_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Э бинеско баро лиляс э тэрнэс вастэстар, гелдяс лэс ригатэ тай пхучляс: — Со ту мангес манги тэ пхэнэс? ");
INSERT INTO rmn_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","О тэрно пхэнляс: — О иудея гиндэ тэ манген тут тэ анэс рано э Павлэс андэ Синедриони хай одолэски, тэ галён зиядэ лэстар. ");
INSERT INTO rmn_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ай ту адалэски ма пакя, вай лэс ишандиен гаравдэ бут катар саранда мануша. Он динэ совля тэ на хан тай тэ на пиен, бискай на мударэн лэс. Он тэрдэ гортярдэ тай екх ишандиен ти збора. ");
INSERT INTO rmn_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","— Никхаски ма пхэн одолэстар, со ту манги анкха пхукавдян, — пхэнляс э бинеско баро э тэрнэски тай мукляс лэс. ");
INSERT INTO rmn_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Дэчи э бинеско баро диняс икос до шэлэнги барэн тай пхэнляс лэнги: — Гортярэн душэл салдатен, эфтадэша опэр грастэндэ тай душэл э пикенца одолэски, тэ никлён андэ Кесария ко эня сагатя бэлвэле. ");
INSERT INTO rmn_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Гортярэн э Павлэски грастэс тай анэн лэс андэ кутардимастэ ко сагбус-пракуратори Феликс. ");
INSERT INTO rmn_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Тай ов язды акасавко письмас: ");
INSERT INTO rmn_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«Катар Клавдий Лисий э намлыс пракураторески Феликсески: Сэлями туки! ");
INSERT INTO rmn_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Адалэ манушэс астардэ о иудея тай манглэ тэ мударэн лэс, ай мэ алём э салдатенца тай кутардым лэс, кай галилём, кай ов си римски мануш. ");
INSERT INTO rmn_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Мэ мангавас тэ галяв, соски он керэн лэс дошалэс, тай андём лэс андэ лэнги Синедриони. ");
INSERT INTO rmn_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Мэ галилём, кай э дош си андар ирищима лэнги Тхэдимастэ тай ов нанай дошало нэ андэ состэ, кай камэл тэ мэрэл я тэ пхандэн андэ пханли. ");
INSERT INTO rmn_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Манги пхэнлэ, кай лэс гортярэнпэс тэ мударэн, мэ чяльти бичялдём лэс тутэ, ай одолэнги, савэ керэн лэс дошалэс, мэ пхэнлём, он тэ джян тэ керэн лэс дошалэс ангал тутэ». ");
INSERT INTO rmn_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","О салдатя кердэ, со пхэнлэ лэнги, лилэ э Павлэс тай гелдэ лэс рати андэ Антипатрис. ");
INSERT INTO rmn_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Авэр дес он бичялдэ лэс э салдатенца опэр граста англэ, ай он сам алэ палэ андэ салдатенго кхер. ");
INSERT INTO rmn_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Кана о салдатя опэр граста алэ андэ Кесария, он динэ ко пракуратори о письмас тай ачявдэ лэстэ э Павлэс. ");
INSERT INTO rmn_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","О пракуратори драпкердяс о письмас тай пхучляс ко Павел, андар сави правинцыя ов си. Галило, кай о Павел андар Киликия, ");
INSERT INTO rmn_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","тай пхэнляс: — Мэ кан шунав тут, кана атхэ кан авэн одола, савэ керэн тут дошалэс, — тай пхэнляс э барэнги тэ дикхен пал Павел андэ патишайлытико кхер ки Иродеско. ");
INSERT INTO rmn_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Пандж дес пал отхэ о баро попази о Анания сарсавэ барэ манушэнца тай юристеса э Тертуллоса ало андэ Кесария, тэ сикавэн э сагбуски-пракураторески э дош мамуй ко Павел. ");
INSERT INTO rmn_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","3","Кана э Павлэс андэ, о Тертулл сикавдяс э дош мамуй лэстэ: — Намлысана Феликс! Андэ тэ годявэрэ кердимастэ амэ бэшас би чингарэнго. Лачипэ туки андар одолэ дилэндэ, савэ ту керэс амарэ дюняски. Амэ сальтя тай вэркатэ гинас лэн. ");
INSERT INTO rmn_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ай тут тэ на кхинярав, мэ мангав тут лачимаса тэ шунэс амаро харно мангипэ. ");
INSERT INTO rmn_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Амэ гинас, кай адава мануш — сар джюнгали дукх. Ов ваздэл чингар машкарэ ко иудея опэр алаи ки пху тай си о баро э назаретейски джемэятеско. ");
INSERT INTO rmn_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","7","Ов мангелас джи тэ гарамладиел о храми, ай амэ лэс линдярдям. ");
INSERT INTO rmn_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Кана ту кан пхучес лэс, ту сам кан галёс, соски амэ керас лэс дошалэс. ");
INSERT INTO rmn_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","О иудея сас лэски ригатэ, пхэнлэ, кай алаи си чячипэ. ");
INSERT INTO rmn_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","О сагбус-пракуратори сикавдяс э Павлэски, тай одова лиляс тэ пхэнэл: — Мэ джянав, кай ту бут брэш керэс цындос адалэ дюняски, тай мэ лошано, кай мэ пхэнав лэнги збора. ");
INSERT INTO rmn_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Туки на пхаро кан овэл тэ галёс одова, кай на бут дэшудо десендар палэ мэ алём тэ бангяв э Дэвлэски андэ Иерусалими. ");
INSERT INTO rmn_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Одола, савэ керэн ман дошалэс, на дикхлэ, кай мэ ирищияв каса-то андэ храми я тэ ваздав э дюняс андэ синагога я андэ савэ-то аврэ тханэстэ андэ диз. ");
INSERT INTO rmn_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Он нащи сикавэн э дош, сави пхэнэн мамуй мандэ. ");
INSERT INTO rmn_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ай мэ пхэнав туки: он пхэнэн э Дэвлэско Дром хохавно, ай мэ бэшав, сар пхэнэл адава сиклярипэ, тай аякха бангяв э Дэвлэски амарэ дадэнгерэски. Мэ пакяв алаески, со си яздимэ андэ Тхэдипэ тай ко Прарокя. ");
INSERT INTO rmn_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Ли мандэ асавко ишандима э Дэвлэски, сар адалэ манушэндэ, — о ишандима одолэски, кай кан овэл о дживиндипэ сар э чяченги, аякха ли э начяченги. ");
INSERT INTO rmn_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Оничин мэ керав алаи, тэ овэл мо ило шужо ангал Дэл тай ангал мануша. ");
INSERT INTO rmn_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Пал бут брэш мэ алём андэ Иерусалими, тэ дав мэ дюняс ловэ тай шэя э чёрэнги тай тэ анав курбаня. ");
INSERT INTO rmn_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Ман дикхлэ андэ храми, кана мэ шужаравас ман. Ай отхэ на сас бут дюняс тай нисаво ирищима, ");
INSERT INTO rmn_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","бискай на алэ иудея андар правинцыя Азия, савэнги камэлас би тэ пхэнэн атхэ, андар состэ ман керэн дошалэс. ");
INSERT INTO rmn_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Я кон си атхэ, мэ пхэнэн, со дош аракхлэ пал мандэ, кана ман пхучелас о Синедриони. ");
INSERT INTO rmn_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Файма, мэ дошало андар одолэстэ, кай динём бэбэря отхэ: «Манги керэн цындос авдес ангал тумэндэ андар ишандима, кай кан дживиндён о мулэ»? ");
INSERT INTO rmn_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","О Феликс, саво лачес джянэлас о Дром, тэрдярдяс о шунлипэ. — Мэ кан пхэнав, со тэ керэн андэ тумарэ дилатэ, кана кан авэл э бинеско баро о Лисий, — пхэнляс ов. ");
INSERT INTO rmn_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ов пхэнляс э шэлэнги барэски тэ дикхен пал Павел, ай тэ дэн лэс залаг локипэ тай тэ мукен лэски амалэн тэ керэн лэски иргатлыки. ");
INSERT INTO rmn_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Андар набут дес о Феликс ало пэ ромняса, э иудейкаса, кай бучёлас Друзилла, тай бичялдяс пал Павел, тэ шунэс лэски пакямастар андэ Исус Христос. ");
INSERT INTO rmn_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","О Павел пхэнэлас катар шужо бэшыпэ, одолэстар, кай камэл тэ дикхес пал тутэ, тай катар цындос, кай кан овэл. Э Феликсес адава трашавдяс, тай ов пхэнляс: — Рэсэл авдесески! Джя, ай кана кан овэл мандэ вахыти, мэ кан дав тут икос. ");
INSERT INTO rmn_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ов аякхажэ ишандиелас, кай о Павел кан дэл лэс ловэ, оничин сальтя мангелас тэ анэн лэс тай зборизэлас лэса. ");
INSERT INTO rmn_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Накхло дуй брэш, тай э Феликсес паровдяс о Порцый Фест. О Феликс мангелас тэ керэл лачипэ э иудеенги, оничин ачявдяс э Павлэс андэ пханли. ");
INSERT INTO rmn_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Тринэ десендар пал отхэ, сар о Фест ало андэ правинцыя, ов гело андар Кесария андэ Иерусалими. ");
INSERT INTO rmn_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Отхэ о барэ попазя тай э иудеяки барэ лилэ тэ керэн дошалэс э Павлэс ангал лэстэ. ");
INSERT INTO rmn_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Он лачес мангенас э Фестес, тэ керэл лэнги мила тай тэ гелэл э Павлэс андэ Иерусалими. Ай он кидэнаспэс опэр дром тэ астарэн лэс тай тэ мударэн. ");
INSERT INTO rmn_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","О Фест пхэнляс: — О Павел си пханло андэ Кесария, тай мэ сам набут вахытестар кан джяв отхэ. ");
INSERT INTO rmn_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Мэ джян тумарэ сагбудэс манца тай мэ сикавэн э дош мамуй лэстэ, тэ кердяс ов со-то налачё. ");
INSERT INTO rmn_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","О Фест сас лэнца охто-дэш дес, ай дэчи ало андэ Кесария тай авэр дес бэшло андэ цындоско тхан тай пхэнляс тэ анэн э Павлэс. ");
INSERT INTO rmn_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Кана о Павел ало, о иудея, савэ алэ андар Иерусалими, лилэ тэ керэн лэс дошалэс андэ бутэ тай барэ налаче дилэндар, ай он нащи сикавдэ, кай адава си чячипэ. ");
INSERT INTO rmn_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","О Павел лиляс тэ кутардиелпэс: — Мэ нэ андэ состэ на сом дошало тай на сом мамуй ко иудейски Тхэдипэ, нэ мамуй ко храми, нэ мамуй ко император. ");
INSERT INTO rmn_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","О Фест мангляс тэ овэл лачё э иудеенги тай оничин пхучляс ко Павел: — Мангес ту тэ джяс андэ Иерусалими, отхэ тэ керав мэ туки цындос? ");
INSERT INTO rmn_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","О Павел: — Мэ сом тэрдо ангал цындос ки императореско, тай атхэ камэл тэ керэн манги цындос. Мэ на кердём э иудеенги ништо налачё, сар ту лачес джянэс. ");
INSERT INTO rmn_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Тэ сом дошало тай камэл тэ мэрав, мэ сом газыри тэ мэрав. Ай э дош, кай пхэнэн о иудея мамуй мандэ, тэ си хохаипэ, дэчи никхон нащи дэл ман лэндэ. Мэ мангав о цындос э императореско! ");
INSERT INTO rmn_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","О Фест зборисаило пэ манушэнца тай пхэнляс: — Ту тэ манглян цындос э императореско, дэчи ко император да кан джяс. ");
INSERT INTO rmn_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Пал набут десендэ андэ Кесария ко Фест алэ тэ дикхен лэс о патишаи Агриппа тай э Вереника. ");
INSERT INTO rmn_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Он сас отхэ набут дес, тай о Фест зборизэлас э патишаеса катар дила ки Павлэски: — Атхэ си мануш, савэс о Феликс ачявдяс андэ пханли. ");
INSERT INTO rmn_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Кана мэ сомас андэ Иерусалими, о иудейскя барэ попазя тай о барэ мануша пхэнлэ мамуй лэстэ дош. Он мангенас, мэ тэ керав лэски цындос, тэ овэл дошало. ");
INSERT INTO rmn_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Мэ лэнги пхэнлём, кай ко римляня на кердёл аякха, кай савэ-то манушэс дэн андэ васта одолэндэ, кон керэл лэс дошалэс, ангал отхэ сар ов на кан дикхелпэс лэнца тай на кан пхэнэл, кай нанай дошало. ");
INSERT INTO rmn_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Он алэ манца атхэ, тай мэ чяльти авэр дес бэшлём андэ цындоско тхан тай пхэнлём, тэ анэн адалэ манушэс. ");
INSERT INTO rmn_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Он тэрдилэ агорял лэстэ, ай на кердэ лэс дошалэс андэ билиекхе дошатэ, сави би мэ гинавас бари. ");
INSERT INTO rmn_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Лэндэ сас ирищима андар дила лэнги пакямаски тай савэ-то Исусестэ, Саво муло, ай Савэстар о Павел пхэнэл, кай Ов дживиндо. ");
INSERT INTO rmn_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Мэ на джянавас, сар мэ тэ керав адая дила, тай пхучлём лэс, мангел ов тэ джял андэ Иерусалими тай отхэ тэ тэрдёл ангал цындос. ");
INSERT INTO rmn_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","О Павел лачес мангляс, лэски дила тэ дикхел о баро император, тай мэ пхэнлём э салдатенги тэ дикхен пал лэстэ, бискай на бичялав лэс ко император. ");
INSERT INTO rmn_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","О Агриппа пхэнляс э Фестески: — Ли мэ мангавас би тэ шунав адалэ манушэс. — Рано кан шунэс, — пхэнляс о Фест. ");
INSERT INTO rmn_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Авэр дес о Агриппа тай э Вереника барэ фаласа динэ андэ тхан ки цындоско э биненги барэнца тай намлыдэс манушэнца э дизакерэнца. О Фест пхэнляс, тэ анэн э Павлэс. ");
INSERT INTO rmn_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","О Фест пхэнляс: — Патишаи Агриппа тай алаи, кон атхэ кидиняспэс! Тумэ дикхен ангал тумэндэ манушэс, опэр савэстэ бут иудея андэ Иерусалими ли атхэ, андэ Кесария, пхэнэн манги, кай ов дошало. Он дэн бэбэря, кай ов на камэл тэ бэшэл. ");
INSERT INTO rmn_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ай мэ на аракхав андэ лэстэ нисави дош, андар савятэ ов камэл тэ мэрэл. Ай ов мангляс цындос ко баро император, оничин мэ гиндём тэ бичялав лэс отхэ. ");
INSERT INTO rmn_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ай мэ на джянав, со тэ яздияв э сагбуски. Оничин мэ мангав, тумэ, ай о бут ту, патишаи Агриппа, тэ пхучес лэс. Дэчи мэ кан джянав, со тэ яздияв. ");
INSERT INTO rmn_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Мэ тюшундияв, кай си дэнлипэ манги тэ бичялав пханлимарес тай тэ на сикавав, андар состэ ов дошало. ");
INSERT INTO rmn_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","— Мэ мукав тут тэ зборизэс андар тутэ, — пхэнляс о Агриппа э Павлэски. О Павел ваздиняс по васт тай лиляс тэ пхэнэл кутардимаски збора: ");
INSERT INTO rmn_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","— Патишаи Агриппа! Авдес мэ бахтало, кай кан сикавав туки, кай мэ на сом дошало андэ одолэстэ, андэ состэ керэн ман дошалэс о иудея. ");
INSERT INTO rmn_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Ту сам лачес джянэс, сар камэл тэ кердёл ко иудея тай андар состэ он ирищиен. Оничин мангав тут даяндимаса шун ман. ");
INSERT INTO rmn_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Алаи о иудея лачес джянэн мо бэшыпэ тай одова, кай мэ тикнярила бэшав машкарэ мэ дюнястэ андэ Иерусалими. ");
INSERT INTO rmn_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Он чёктан джянэн ман тай, тэ манген, мэ пхукавэн одолэстар, кай мэ бэшавас сар фарисеи, кай мэ сомас андэ зорало сиклярипэ андэ амарэ пакямастэ. ");
INSERT INTO rmn_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Авдес мэ тэрдо ангал цындос, вай ишандияв, кай о Дэл кан керэл Пи збора, сави диняс амарэ дадэн. ");
INSERT INTO rmn_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","О дэшудуй породэс амарэ дюняски о дес тай рат сальтя керэн иргатлыки э Дэвлэски тай ишандиен, кана адая збора э Дэвлэски кан овэл. Патишаи, андар адава ишандима о иудея керэн ман дошалэс. ");
INSERT INTO rmn_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Та со, тумэ гинэн, кай о Дэл нащи дживиндярэл э мулэн? ");
INSERT INTO rmn_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Ли мэ гинавас, кай камэл тэ керав алаи мамуй ко нав ки Исусеско андар Назарет. ");
INSERT INTO rmn_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Адава мэ да керавас андэ Иерусалими. Мэ диндилём барипэ катар барэ попазя тай бичялавас андэ пханли бутэ шужэн, ай кана лэн мударэнас, мэ сомас андар одолэндэ, савэ адава керэнас. ");
INSERT INTO rmn_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Мэ бутвар маравас лэн андэ синагогя, тай тхавас лэн тэ болдэнпэс пумарэ пакямастар. Мэ сомас асавко холямэ опэр лэндэ, кай кувдиявас лэн джи андэ джятя диза. ");
INSERT INTO rmn_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Екхвар асавке диласа мэ сомас бичялдо баримаса катар барэ попазя тай джявас андэ Дамаск. ");
INSERT INTO rmn_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Опэр дром отхэ, патишаи, машкарэ ко дес мэ дикхлём ярэки опрал, саво тхаболас лачес катар кхам. О ярэки агорады ман тай кон э сас манца. ");
INSERT INTO rmn_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Амэ алаи пэлям ки пху, тай мэ шунлём сэси, саво пхэнэлас манги опэр еврейски чиб: «Савл, Савл, соски ту Ман кувдиес? Пхаро туки тэ джяс мамуй Мандэ». ");
INSERT INTO rmn_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Мэ пхучлём: «Кон Ту, Сагбуса?» — «Мэ о Исус, Савэс ту кувдиес, — пхэнляс о Сагбус. ");
INSERT INTO rmn_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","— Ваздэтут тай ущи опэр пинрэ. Мэ алём, тэ керэс иргатлыки Манги тай тэ пхукавэс манушэнги, со ту ужэ дикхлян тай со мэ кан керав ангал тэ якхендэ. ");
INSERT INTO rmn_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Мэ кан кутардияв тут тэ дюнястар тай катар наиудея, савэндэ Мэ тут бичялав, ");
INSERT INTO rmn_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","тэ пхутрэс лэнги о якха тай тэ болдэс лэн катар тэмина ко ярэки, катар барипэ ко Сатанас ко Дэл, тэ овэн кхослэ лэнги бэзя тай он тэ овэн машкарэ одолэндэ, савэн Мэ шужардём пакямаса андэ Мандэ». ");
INSERT INTO rmn_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Патишаи Агриппа, мэ нащи тэ на тхавкан опрунэ дикхимас. ");
INSERT INTO rmn_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Мэ пхукававас ханик одолэнги, кон сас андэ Дамаск, дэчи андэ Иерусалими тай андэ алаи Иудея, тай дэчи ли наиудея, он тэ ачявэн пумарэ бэзя тай тэ болдэнпэс ко Дэл тай лэнги дилэс тэ сикавэн лэнго пароипэ. ");
INSERT INTO rmn_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Андар адалэстэ о иудея астардэ ман андэ храми тай манглэ тэ мударэн. ");
INSERT INTO rmn_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ай о Дэл джи авдесутнэ десестэ керэл ярдыми манги, тай аки мэ тэрдо атхэ тай пхукавав ли э тэрнэнги, ли э пхурэнги, мэ на пхэнав бут одолэстар, со пхэнлэ о прарокя тай о Маисей, со кан овэл. ");
INSERT INTO rmn_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Ами, кай о Христос камэлас тэ накхел хурлуки тай баштутно тэ дживиндёл андар мулэ, тэ пхукавэл о ярэки ли э иудеенги, ли на иудеенги. ");
INSERT INTO rmn_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Кана ов аякха кутардиеласпэс, о Фест тэрдярдяс лэс. — Ту дэнило, Павел, — диняс бэбэря ов, — о баро джянлипэ кердяс тут дэнилэс! ");
INSERT INTO rmn_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","О Павел пхэнляс: — Намлысана Фест, мэ на сом дэнило, тай одова, со мэ пхэнав, чячипэ тай годявэрипэ. ");
INSERT INTO rmn_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Адава джянэл о патишаи, ангал савэстэ мэ би трашако пхэнав. Мэ джянав, кай ништо андар адалэстэ на накхло, со ов на шунляс, вай адава на сас андэ гаравдо тхан. ");
INSERT INTO rmn_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Патишаи Агриппа, ту пакяс э прарокенги? Мэ джянав, кай пакяс. ");
INSERT INTO rmn_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","— Ту тюшундиес андэ асавке залаг вахытестэ тэ керэс ман христианес? — пхэнляс о Агриппа э Павлэски. ");
INSERT INTO rmn_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","О Павел пхэнляс: — Саво адава вахыти тэ на овэл, харно я дулго, мэ мангав э Дэвлэс, тэ на екх ту, ами ли алаи, кон шунэл ман авдес, тэ овэн асавке, сар мэ, булуб акалэ джянджирэндар. ");
INSERT INTO rmn_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","О патишаи ваздиняспэс, тай лэса ваздинэпэс о сагбус-пракуратори, э Вереника тай одола, кон бэшлэ лэса. ");
INSERT INTO rmn_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Он никлистэ, пхэнэнас екхаврэски: — Адава мануш на кердяс ништо, андар состэ камэл тэ мэрэл я тэ овэл андэ пханли. ");
INSERT INTO rmn_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","— Камэлас би лэс тэ мукас, тэ на мангел цындос ко император, — пхэнляс о Агриппа э Фестески. ");
INSERT INTO rmn_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Кана сас гиндо, кай амэ кан джяс андэ Италия, э Павлэс тай аврэ пханлэн динэ ко шэлэнго баро, саво бучёлас Юлий, андар кагорти э барэ императорески. ");
INSERT INTO rmn_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Амэ бэшлям опэр адрамитски карабляс, саво камэлас тэ джял андэ портя ки правинцыя Азия, тай гелям ко дром. Амэнца сас о македоняни о Аристарх андар Фессалоники. ");
INSERT INTO rmn_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Авэр дес амэ алям андэ Сидон. О Юлий сас лачё э Павлэса тай мукляс лэс тэ джял пэ амалэндэ, тэ лэл лэндар алаи, со камэл дромэски. ");
INSERT INTO rmn_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Амэ генэ гелям опэр моря тай накхлям о Кипр одолэ ригатар, сави кутардиелас амэн катар балвал, вай аврэ ригатар э балвал пхудэлас андэ амаро муй. ");
INSERT INTO rmn_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Амэ накхасас опрал моря, тай мамуй ачёнас э Киликия тай э Памфилия, тай тэрдилям андэ ликийски диз Мира. ");
INSERT INTO rmn_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Отхэ э шэлэнго баро аракхляс карабляс андар Александрия, кай джялас андэ Италия, тай бэшавдяс амэн опэр лэстэ. ");
INSERT INTO rmn_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Бут дес амэ тэмэли, джи пхаримаса джясас англэ тай алям андэ диз ки Книд. Э балвал на дэлас амэн тэ джяс, карин камэл, оничин амэ накхлям ко Крит катар риг ко Салмон, катэ амэ самас кутардимэна катар балвал. ");
INSERT INTO rmn_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Пхаримаса амэ накхасас пашал шукипэ тай алям андэ тхан, кай бучёл Лаче Пристаня, надур катар диз Ласея. ");
INSERT INTO rmn_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Амэ нашавдям бут вахыти, тай о дром опэр моря овэлас хаталыс, вай джи о дес э оразаско накхло. О Павел пхэнляс лэнги: ");
INSERT INTO rmn_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","— Муршалэн, мэ дикхав, кай амаро дром кан овэл хаталыс тай пхаро на екх э шэенги тай э карабляски, ами ли амарэ бэшымаски. ");
INSERT INTO rmn_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ай э шэлэнго баро шунляс э капитанес тай э сагбус, ай на э Павлэс. ");
INSERT INTO rmn_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Опэр адалэ пристанятэ нащи вэнкярэсас, тай о бут гиндэ тэ джян англэ, тэ овэла алаи лачё, тэ авэн андэ Финикс тай отхэ тэ вэнкярэн. О Финикс сас э пристань опэр Крит, пхутэрди э югески-западнески тай э северески-западнески риг. ");
INSERT INTO rmn_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Кана пхудиняс локи балвал катар юги, о матрося гиндэ, кай ой лэнги да камэл, ваздинэ о якори тай накхлэ пашал Крит. ");
INSERT INTO rmn_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Набут вахытестар катар острав пхудиняс бари зорали северески-вастокески балвал, кай бучёлас Эвракилон. ");
INSERT INTO rmn_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Ов лиляс о карабляс, саво нащи джялас мамуй лэстэ. Дэчи амэ динямамэн э волнэнги тай пхеравэнаспэс, карин кувдиелас э балвал. ");
INSERT INTO rmn_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Амэ улям катар риг ки тикнорэ остравески э Кавдаски, катэ амэ самас кутардимэна катар балвал. Отхэ амэ барэ пхаримаса гаравдям э лодка. ");
INSERT INTO rmn_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Кана ла ваздинэ опэр карабляс, о матрося сидинэ о тхулэ шэлэ тал карабляс тай пханлэ лэс. Катар траш тэ бэшэн опэр кишаенго мели ки Сиртис, он муклэ о парусадэс тай джянас англэ, карин челас лэн э балвал. ");
INSERT INTO rmn_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Э бари зорали балвал аякха лачес челас о карабляс, кай авэр дес он лилэ тэ чен о шэя андэ пани. ");
INSERT INTO rmn_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Ко трито дес он пумарэ вастэнца читэ андэ пани э карабляски шэя. ");
INSERT INTO rmn_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Набут дес на дикхиндёлас нэ о кхам, нэ о чергэня, ай э бари-зорали балвал май ваздиндёлас. Амэ нашавдям алаи о ишандима тэ кутардиясамэн. ");
INSERT INTO rmn_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","О мануша чёктан ништо на ханас. Дэчи о Павел ущино машкарэ лэндэ тай пхэнляс: — Муршалэн, тумэнги камэлас тэ шунэн ман тай тэ на джян андар Крит, озаман тумэндэ на кан овэнас асавке джюнгалиматэс тай нашаиматэс. ");
INSERT INTO rmn_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ай аканкха зоралён, никхон андар тумэндэ на кан мэрэл, екх о карабляс кан хурдёл. ");
INSERT INTO rmn_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Окоя рат мандэ ало о миляики э Дэвлэско, Каско мэ сом тай ангал кастэ мэ бангяв. ");
INSERT INTO rmn_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Ов пхэнляс манги: «Павел, ма траша. Ту камэл тэ тэрдёс ангал император. О Дэл булуб туки кан гаравэл о бэшыпэ алаенго, кон джял туса». ");
INSERT INTO rmn_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Муршалэн, акана лошазэн! Мэ ишандияв э Дэвлэски тай пакяв, кай алаи кан овэл аякха, сар сас манги пхэнло. ");
INSERT INTO rmn_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","О карабляс кан овэл чито опэр савэ-то остравестэ. ");
INSERT INTO rmn_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Андэ дэшуштарто рат, кана амэн дага пхеравэлас опэр Адриаски моря, машкарэ ки рат о матрося галилэ, кай амэ пашас ки пху. ");
INSERT INTO rmn_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Он меряскердэ о хорипэ, тай уло, о хорипэ сас трияндушов метрэс, ай кана меряскердэ дэчи, о хорипэ сас биш эфта метрэс. ");
INSERT INTO rmn_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","О матрося трашанас, кай кан чялавэл амэн андэ бара, тай муклэ опрал кармас ки карабляско штар якоря, мангенас, тэ овэл чяльти дес. ");
INSERT INTO rmn_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","О матрося манглэ тэ нашэн опрал карабляс тай лилэ тэ мукен лодка опэр пани, керэнаспэс, кай манген тэ мукен о якоря опрал накх ки карабляско. ");
INSERT INTO rmn_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","О Павел пхэнляс э шэлэнги барэски тай э салдатенги: — Адала мануша тэ на ачёна опэр карабляс, тумэнги на кан овэл кутардипэ. ");
INSERT INTO rmn_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Дэчи о салдатя чиндэ о шэлэ, савэ астарэнас э лодка, тай ой пэли андэ моря. ");
INSERT INTO rmn_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Опэр сабахтанятэ о Павел лиляс тэ мангел алаи э манушэн тэ хан. — О ачявдэ дэшуштар дес тумэ сальтя санус андэ трашатэ тай ништо дага на халянус, — пхэнляс ов. ");
INSERT INTO rmn_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","— Мэ лачес пхэнав тумэнги тэ хан. Адава кан керэл ярдыми тэ кутардиентумэн. Билиекхестэ андар тумэндэ джи бал катар шэро на кан пэрэл. ");
INSERT INTO rmn_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","О Павел пхэнляс адава, лиляс о манро, алгышты андар лэстэ э Дэвлэс, пхагердяс тай лиляс тэ хал. ");
INSERT INTO rmn_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Адава зоралякердяс алаен, тай он лилэ тэ хан. ");
INSERT INTO rmn_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Алаи опэр карабляс амэн сас душэл эфтадэша шов мануша. ");
INSERT INTO rmn_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Кана о мануша чялэс халэ, он лилэ тэ локярэн о карабляс, кай ченас андэ моря о гив. ");
INSERT INTO rmn_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Пал сабахтанятэ он на пэнджярдэ э пху, ами дикхлэ э бухта э кишаяки пхуяса, савятэ он манглэ тэ тэрдён, тэ овэл алаи лачё. ");
INSERT INTO rmn_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","О матрося чиндэ о якорядэс тай читэ лэн андэ моря, пхутэрдэ э рулески ровли, ваздинэ о тикноро парусас тай болдинэ о карабляс ко чети ки панеско. ");
INSERT INTO rmn_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ай о карабляс урянило опэр кишай тай бэшло опэр мели. О накх хор гело андэ кишай тай нащи кхелавэсас лэс, ай э кармас пхагерэнас о валнадэс. ");
INSERT INTO rmn_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","О салдатя манглэ тэ мударэн алаи э пханлимарен, никхон андар лэндэ, кана кан никлёл, тэ на нашэл. ");
INSERT INTO rmn_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Ай э шэлэнго баро мангелас тэ кутардиел э Павлэс тай тэрдярдяс лэн. Ов пхэнляс одолэнги, савэ галёнас тэ дэн джялдави, тэ ченпэс андэ пани ангал тай тэ джян ки пху. ");
INSERT INTO rmn_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Авэра камэлас тэ джян опэр пхалендэ тай опэр пхаге котора ки карабляски. Аякха алаи лачимаса никлистэ опэр пху. ");
INSERT INTO rmn_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Кана амэ кутардымусамэн, амэ галилям, кай о острав бучёл Мальта. ");
INSERT INTO rmn_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Аканутнэ мануша муклэ амэн пхутэрдэ илэса, со амэ на ишандиясас. Он тхардэ яг тай динэ икос амэн пумэндэ, вай сас шыл тай джялас брышым. ");
INSERT INTO rmn_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Кана о Павел кидиняс ангали кашта тай мангляс тэ чел лэн андэ яг, лэско васт астардяс сап, сави кутардиеласпэс катар яг тай балакады андар кашта. ");
INSERT INTO rmn_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Кана о аканутнэ дикхлэ, кай опрал Павлэско васт салындиел сап, он лилэ тэ пхэнэн екхаврэски: — Чячес адава мануш мударимари: ов кутардыпэс катар моря, ай э дэвлинка э цындоски на мукел лэс тэ ачёл дживиндо. ");
INSERT INTO rmn_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Ай о Павел какты э сапэс андэ яг, тай ой на кердяс лэски джюнгалипэ. ");
INSERT INTO rmn_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","О мануша ишандиенас, кай ов кан лэл тэ шувлёл я бирдэн кан пэрэл муло. Он ишандылар бут вахыти, тай кана дикхлэ, кай лэса ништо на уло, паровдэ по тюшундипэ тай лилэ тэ пхэнэн, кай ов саво-то дэл. ");
INSERT INTO rmn_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Надур сас мангин, саво сас э барэ манушэско опэр острав, савэско нав Публий. Ов лошаса мукляс амэн пэстэ, тай трин дес амэ самас лэстэ. ");
INSERT INTO rmn_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","О дад э Публияско сас насвало пашло опэр тхан. Ов сас тхаро, тай лэстэ сас дизентерия. О Павел ало лэстэ, мангляс э Дэвлэс, тхэдяс опэр лэстэ пэ васта тай аиндэрды лэс. ");
INSERT INTO rmn_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Кана адава уло, авэра о насвалэ э остравески лилэ тэ авэн тай тэ аиндиен. ");
INSERT INTO rmn_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Он кердэ амэнги бари пачя, тай кана амэ камэлас тэ джяс карабляса, он динэ амэн дромэски алаи, со камэлас. ");
INSERT INTO rmn_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Накхло трин чён, тай амэ никлистям опэр моря опэр караблястэ андар Александрия, саво вэнкярдяс опэр острав. Адава карабляс пхеравэлас нав «Дуй пхрала». ");
INSERT INTO rmn_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Амэ алям андэ Сиракузи тай самас отхэ трин дес. ");
INSERT INTO rmn_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Отхар амэ гелям тай алям андэ Ригий. Авэр дес пхудиняс балвал катар юги, тай екхе десестар амэ алям андэ Путеоли. ");
INSERT INTO rmn_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Отхэ амэ аракхлям пхралэн, тай он манглэ амэн тэ овас лэнца базари. Тай аки амэ алям андэ Рим. ");
INSERT INTO rmn_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","О пхрала андэ Рим шунлэ одолэстар, кай амэ камэл тэ авас, тай никлистэ мамуй джи ко Аппиеско Майдани тай джи ки дизори Трин Гастиницэс. Кана о Павел дикхляс лэн, ов махтады э Дэвлэс тай диндило такати. ");
INSERT INTO rmn_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Амэ алям андэ Рим, тай э Павлэс муклэ тэ бэшэл башка. Лэса бэшэлас екх салдати, саво дикхелас пал лэстэ. ");
INSERT INTO rmn_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Тринэ десендар о Павел диняс икос э намлыдэн иудеен. Кана он кидинэпэс, ов пхэнляс лэнги: — Пхралалэн, мэ сомас пханло андэ Иерусалими тай диндо ко римляня, ай мэ на кердём ништо мамуй амарэ дюнястэ, нэ мамуй ко дилэс амарэ дадэнги. ");
INSERT INTO rmn_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","О римляня кердэ манги цындос тай манглэ тэ мукен ман, вай пал мандэ нанай нисави дош, андар савятэ камэл тэ мэрав. ");
INSERT INTO rmn_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ай о иудея на мангенас адава, тай мэ камэлас тэ мангав цындос ко император. Ай мэ кердём адава на тэ керав дошалэс мэ дюняс. ");
INSERT INTO rmn_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Мэ оничин авдес динём икос тумэн, тэ дикхав тумэн тай тэ зборизав тумэнца. Вай андар ишандима ки Израилеско опэр мандэ адала джянджира. ");
INSERT INTO rmn_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","О иудея пхэнлэ э Павлэски: — Амэ на диндилям нисавэ письмадэс тутар андар Иудея, тай никхон андар пхрала, кай алэ отхар, на пхэнлэ амэнги тутар ништо джюнгало. ");
INSERT INTO rmn_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Ай амэ манглям тутар тэ шунас, сар ту тюшундиес. Вай амэ шунас екх налачё адалэ сикляримастар. ");
INSERT INTO rmn_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Он зборисаилэ э Павлэса, тай андэ пхэнло дес лэстэ кхерэ ало бут дюняс. О Павел катар сабаги тай джи ки бэлвэль пхэнэлас лэнги катар Дэвлэско Патишайлыки тай пхукавэлас лэнги катар Исус зборэнца андар Тхэдипэ ки Маисееско тай андар Прарокя. ");
INSERT INTO rmn_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Сарсавэ пакянилэ лэски, ай сарсавэ на. ");
INSERT INTO rmn_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Лэндэ уло чингар машкарэ пэстэ, тай кана он лилэ тэ джян, о Павел пхэнляс акасавке зборэс: — Шужо Духос чячи пхэнляс тумарэ дадэнги андар прароки Исаия: ");
INSERT INTO rmn_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","«Джя адалэ дюнястэ тай пхэн: \"Тумэ лачес кан шунэн, ай на кан галён, лачес кан дикхен, ай на кан дикхен. ");
INSERT INTO rmn_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","О ило адалэ дюняско уло баруно, он пхарэс шунэн канэнца, тай о якха пумарэ пханлэ, тэ на дикхен якхенца, тэ на шунэн канэнца, тэ на галён илэса тай тэ на болдэнпэс, тэ аиндэрдияв Мэ лэн\"». ");
INSERT INTO rmn_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","29","Акана джянэн, кай о кутардипэ э Дэвлэско бичялдо наиудеенги: он ли кан шунэн адава габэри! ");
INSERT INTO rmn_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","О Павел бэшэлас андэ Рим андэ астардо кхер генэ састэ дуй брэш тай мукелас пэстэ алаен, кон авэлас лэстэ. ");
INSERT INTO rmn_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Ов битрашако пхукавэлас о Патишайлыки э Дэвлэско тай сиклярэлас катар Сагбус Исус Христос пхутэрдэс, тай никхон лэс на тэрдярэлас.");
ALTER TABLE rmn_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
