﻿USE sofia;
DROP TABLE IF EXISTS sofia.rmczrb_vpl;
CREATE TABLE rmczrb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES rmczrb_vpl WRITE;
INSERT INTO rmczrb_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Авка, сар іма бутджяне кєздинде те пісінкєрен пал ода, со обачіляпес машкар аменде, ");
INSERT INTO rmczrb_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","сар аменґє передине одала, саве дикгле ода анґлунестар і саве есас совґі про Лав. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Авка, те ме рішиндьом міште те предикгєн аґорестар шорос-шоростар те пісінен тукє, драго Теофіл, ");
INSERT INTO rmczrb_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","гой ту те джянес ода сікавібе, саво ту хундял, ода гін чачібе. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Андро одала дівеса, кана есас о Ірод краліс андре Іудєя, джівелас єкг рашай про нав Захарія. Ов есас ле Авіоскєре рашаєндар. А лескєрі ромні есас ле Аароноскєре файтостар, нав лакє есас Єлізавета. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Оне дувджяне санас чачібнаскєре анґлал о Дейл, і іґєн фес долікєренас саворе заповіді Раєскєре, і джівенас пал Лескєро лав. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Кє ленде на есас чаве: Єлізавета наший ачіля пгарі, і дувджяненґє есас іма бут берша. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Єкгвар, кана есас овра те совґалінен ле Захаріяскєре рашаєнґє, ов совґалінелас анґлал о Дейл. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Пал пескєро обичай, рашая чіде жрєбій, і Захарія маїндя те заджян андро Раєскєро храмос те тгувінен сагошно тгув. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","І акор, сар тгувінелас о сагошно тгув ле Девлескє, саворо нийпос модлінеласпес аврунестар. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","А сікадяпес лескє анґєлос Раєскєро, і тердьолас пре чачі сийра ле алтаріскє кай тгувісальолас. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Сар лес дикгля о Захарія, чудаліндяпес і іґєн даранділя. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Та о анґєлос лескє пгендя: — На дара, Захарія, бо тийрі молітва шунді, а те тийрі ромні Єлізавета ловтярела тукє ле час, і ту дега лескє о нав Іоанн. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","І ейла тут барі бахт те радишаґос. І бутджяне радисальона, сар ов увльола, ");
INSERT INTO rmczrb_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","бо ов ейла баро анґлал о Рай. І на пієла е мол, ані нісаво матяркєрдо піїбе. А іма андрал о пгер пескєра дакєро ейла пгердо ле Свентне Духога. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","А бутджянен ле Ізраєльоскєре нийпостар вісарела ко ленґєро Рай, о Дейл. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ов джяла анґлал Лесте андро духос те андре зор Іліяскєрі, гой те вісарен о їле даденґєре ко чаве, а кадален, саве на шунен, — ґодяверіпе ле чачібнаскєре манушен, те кійсітинен о нийпос кє оди оврі, сар авела о Рай. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Та о Захарія пгендя ле анґєлоскє: — Пал состе ме ода прінджярава? Бо ме іма сом пгуро, і мійрі ромні іма андро берша. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Акор лескє о анґєлос отпгендя: — Ме сом анґєлос Гавріїл, ода, саво тердьол анґлал о Дейл. І ме бічадо важ ода, гой те вакєрав туга, і те пгенав тукє када Радишаґоскєро Гійрос. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","А канакє ту ейга нємо, і на ейга гонно те вакєрен джі кє ода дівес, адик ода ейла, важ ода, кай ту на патянлял мійре лавенґє, саве обаченапес андре пескєрі овра. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","А о нийпос ужарелас ле Захаріяс і чудалінеласпес, соске ов авка буталік залікєрдяпес андро храмос. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Та сар авля аврі, на бійріндя кє ленде те превакєрен. І оне ахаліле, со ов дикгля знаменіє андро храмос. Ов сікавелас ленґє ле вастенца, бо ачелас нємо. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","А сар преґейле лескєре дівеса те совґалінен, Захарія отґейля андро пескєро кгєр. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Пал одала дівеса лескєрі ромні Єлізавета ачіля пгарі, і панч чон на сікавеласпес ле манушенґє, і пгенелас: ");
INSERT INTO rmczrb_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","— Авка манґє кєрдя о Рай, сар закамля те лен мандар е ладж анґлал о мануша! ");
INSERT INTO rmczrb_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Про шовто чон есас бічадо анґєлос про нав Гавріїл ле Девлестар андро галілєйсько фоврос, со вічінелпес Назарет, ");
INSERT INTO rmczrb_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","кє чай Марія. Ой есас манґаді ле ромескє про нав Йосип, саво есас андало родос ле Давідоскєро. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","І сар заавля анґєлос кє лате, пгендя лакє: — Бахт тукє, ту хундял благіпе! О Рай туга! ");
INSERT INTO rmczrb_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","А ой чудаліндяпес лескєре лавенґє, і думінелас, со шай обозначінел ода палікєрібен. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","І акор анґєлос лакє пгендя: — На дара, Марія, бо о Дейл сікадя кє туте благіпе! ");
INSERT INTO rmczrb_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","А канакє ту ачега пгарі, і ловтярега ле Час, і дега лескє нав Ісус. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ов ейла баро, і Лес вічінкєрена о Ча Майопрунескєро. І дела Лескє о Рай о Дейл о тронос лескєре дадескєро Давідоскєро. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","І кралінела про саворо родос ле Яковскєро міндик, і Лескєре краліпнаскє на ейла ніґда аґор. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","А Марія пгендя ле анґєлоскє: — Сар ме шай авав пгарі, те ме минґ ромес на джянав? ");
INSERT INTO rmczrb_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","А анґєлос лакє отпгендя: — О Свентно Духос авела пре туте, е зор Майопрунескєрес учарела тут андре. Важ ода те чаворо, со тутар увльола, ейла Свентно, і вічінена Лес о Ча ле Девлескєро. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Дикг, акєс, тийре файтостар Єлізавета. Пре лате пгенен, со ой наший ловтярел, а ой іма гіні шовто чон пгарі, і ой гіні андро берша. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Бо пріґ о Дейл нане нісаво лав айсо, саво Ов те на бійріндялас те кєрен. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","І акор отпгендя Марія: — Ме сом ле Раєскєрі совґалкіня, мі ачелпес манґє пал тийро лав. І акор анґєлос латар отґейля. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Андре одала дівеса е Марія скіндяпес і ґейля сіґ андро фоврос, саво есас машкар Іудєякєре брегі. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Заавля андро кгєр ко Захарія і палікєрдя ле Єлізаветакє. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Сар шундя е Єлізавета о палікєрібен ле Маріякєро, закгелдя андре лате о чаворо, і Єлізавета есас пгердярді Свентне Духога, ");
INSERT INTO rmczrb_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","і пгендя зорале ганґога: — Ту сал бахталі машкар саворе ромня, і бахтало ода Чаворо, со гіно андре туте! ");
INSERT INTO rmczrb_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ко ме сом айсі, со мійре Раєскєрі дай авля кє манде? ");
INSERT INTO rmczrb_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Сар ме шундьом тийро палікєрібен, радишаґога закгелдя о чаворо андро мійро пгер! ");
INSERT INTO rmczrb_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Бахталі ту сал, бо патянлял, і ачелапес тукє ода, со пгендя о Рай! ");
INSERT INTO rmczrb_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Марія отпгендя: — Мійрі вовді барарел ле Раєс, ");
INSERT INTO rmczrb_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","а мійро духос радисальол важо Дейл, Саво ратинел ман, ");
INSERT INTO rmczrb_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","бо дикгля пре Пескєрі цікні совґалкіня. А канакєстар ман саворо родос вічінела бахталі, ");
INSERT INTO rmczrb_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Майзораледер кєрдя манґє баро! І Лескєро нав свентно! ");
INSERT INTO rmczrb_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Девлескєро лачіпе сікавелпес про саворе роди, про одала, со Лестар пес даран. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Лескєре вастега кєрде баре бувтя: Ов розтранля баріканен, кай тговенаспес аврі андро пескєро їло, ");
INSERT INTO rmczrb_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ле зорален чідя тейле пал ленґєро тронос, а ваздня чоре манушен. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ле бокгален чалярдя лачіпнага, а ле барвален бічадя нісога, ");
INSERT INTO rmczrb_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","лепердя о лав, саво диня амаре даденґє, ле Авраамоскє і лескєре чавенґє, гой мієл міндик лачоїлескєро про векі, і поможіндя ле Ізраєльоскє, Пескєре совґаскє. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Марія ачіля ле Єлізаветага варекай трін чон, а паліш вісаліля кгєйре кє песте. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Кана Єлізаветакє авля овра те ловтярен, і ой ловтярдя ле час. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Сар доджянле лакєре сомсійди те о файтос, со о Рай сікадя лакє Пескєро лачіпе, радисальонас лага. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Про охтото дівес ґейле те обчінен ле чаворес, і камле лескє те ден о нав пало лескєро дад, Захарія. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Та лескєрі дай Єлізавета пгендя: — Наа, лескєро нав ейла Іоанн. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Акор лакє отпгенде: — Ніко нане андре тийро файтос, кас увлягас айсо нав! ");
INSERT INTO rmczrb_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","І оне кєздинде те сікавен, і пгученас ле вастенца ле дадес, саво нав ов камел те ден ле часкє. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ов пескє манґля дескіца і пісіндя пре лате: «Лескєро нав Іоанн». І саворе чудаліненаспес. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","І єкгваресте кє лесте вісаліля вакєрібе, і ов кєздиндя те вакєрен і те ашарен ле Девлес. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Акор саворен обхундя е дар, со паж ленде джівенас. А пало цейлі партоскєрі Іудєйсько пгув есас лав пало ода. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Саворе, ко ода шунде, думіненас андро пескєро їло: — Ко ейла када чаворо? А ле Раєскєро васт есас пре лесте. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Захарія, о дад ле Іоанноскєро, пгердісаліля ле Свентне Духога і пророкінелас авка: ");
INSERT INTO rmczrb_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","— Ашардо Рай, о Дейл ле Ізраєльоскєро, саво авля те дикгєн Пескєро нийпос і ціндя лен аврі. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Андал родос Давідоскєро, Пескєре совґас, Ов бічадя аменґє зоралес, саво анела аменґє ратипе, ");
INSERT INTO rmczrb_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","авка, сар Ов іма чірлатунестар вакєрелас пріґ свентне пророка. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ов ратинела амен ле амаре врагендар, те андало васта саворен, ко амен мержінел. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ов сікадя о лачіпе амаре даденґє, і на забістердя Пескєро свентно заветос, ");
INSERT INTO rmczrb_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","кошкєрібен, саво Ов диня амаре дадескє ле Авраамоскє, ");
INSERT INTO rmczrb_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","те ратинен амен андало васта врагенґєре, гой те совґалінен Лескє бі е дар, ");
INSERT INTO rmczrb_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","і те авас анґлал Лесте чачібнаскєре і свентне саворо амаро джівіпе. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","А ту, чаворея, ейга вічіме пророкос Майопрунескєро, бо джяга анґлал о Рай, гой Лескє те кійсітинен о дром, ");
INSERT INTO rmczrb_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","гой те ден Лескєре нийпоскє те джянен, со Ов одмукєла ленґє о бійні і ратинела лен. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Амаро Дейл гіно іґєн лачоїлескєро, Ов бічавела аменґє Тосарутно Шветлос пало нєбос. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","гой мі ачел шветлос одаленґє, ко бешел андре цма те андре дар мерібнаскєрі, гой те анен амен про дром, саво анел ко мірос. ");
INSERT INTO rmczrb_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Чаворо баролас і зоральолас духога. Ов джівелас андре пустиня джі кє ода дівес, адик на сікадяпес Ізраєльоскєре нийпоскє. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Андре одала дівеса імператоріс Авґуст диня аврі о законос, гой те прееґєнен і те перепісінен ле манушен пал цейло Рімсько пгув. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Кана есас о Квіріній владаріс андре Сірія, кади перепісь кєрде першивар. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","А сако єкг ґейля те запісіненпес андро пескєро фоврос. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ґейля те о Йосип андал галілєйсько фоврос Назарет андро Іудєя, андро фоврос ле Давідоскєро, со вічінелпес Віфлієм, бо ов есас андал родос ле Давідоскєро. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ов ґейля те запісіненпес ле Маріяга, саві есас лега манґаді і ужарелас ле Чаворес. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ачіля авка, гой адик ой одя есас, авля лакє овра те ловтярен. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ой увліля пескєре перше Чаворес, патярдя Лес андро пгерноре і тгодя Лес андре ясля, бо на есас лен тган андре гостіно соба. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Надур есас пастера, саве джівенас пре маля і відязіненас раті пескєре бакрен. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Акор ачіля ле Раєскєро анґєлос анґлал ленде, а ле Раєскєрі слава лен заучардя. І хундя лен барі дар. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Та анґєлос ленґє пгендя: — На даран, бо авльом туменґє те пгенен Радишаґоскєро Гійрос, саво анела радишаґос саворе нийпоскє! ");
INSERT INTO rmczrb_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Дадіве туменґє увліля андро фоврос ле Давідоскєро Ратипен, саво гіно Хрістос, о Рай! ");
INSERT INTO rmczrb_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Акєс туменґє знаменіє: аракгєна цікне Чаворес андро пгерноре, саво пашльола андре ясля. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Єкгваресте сікадяпес ле анґєлога буте нєбоскєре суґлядя. Оне ашаренас ле Девлес і вакєренас: ");
INSERT INTO rmczrb_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","— Ашаріпе ле Девлескє опре про нєбос, а пре пгув мірос ле манушенґє, ко саве Ов сікавел Пескєрі лачі воля! ");
INSERT INTO rmczrb_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Кана анґєла лендар отґейле про нєбос, пгенде єкг аврескє о пастера: — Ноча, джяс джі андро Віфлієм те дикгєн, со пес одя обачіля пал ода лав, пал саво пгендял аменґє о Рай. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Сідяріндос, ґейле одя, і аракгле ле Марія те ле Йосип і ле Чаворес, саво пашльолас андре ясля. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Сар оне Лес дикгле, акор кєздинде те вакєрен саворо, со ленґє есас пгендо пало ода Чаворо. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Саворе, ко ода шунде, чудаліненаспес одалескє, со ленґє о пастера вакєренас, ");
INSERT INTO rmczrb_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","а Марія ґарувелас саворе кадала лава андро пескєро їло і думінелас пало ода. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Пастера вісаліле пале, те ашаренас і вазденас опре ле Девлес важ саворо, со оне шунде те дикгле. Саворо есас авка, сар ленґє есас пгендо. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Сар преґейля охто дівес і кампіля Лес те обчінен, дине Лескє нав Ісус, саво Лескє диня о анґєлос минґ сіґєредер, сар Лескєрі дай ачіля пгарі. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Сар преґейле одала дівеса, со обжувжаренпес пало Моїсєйоскєро Законос, Марія те о Йосип анде ле Чаворес андро Єрусалім, гой Лес те отден ле Раєске. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Бо андро Раєскєро Законос гін пісіме: «Доґдо єкг муршоро, со першо увльол, маїнел тейн солахардо ле Раєскє». ");
INSERT INTO rmczrb_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Пало Законос Раєскєро ленґє кампіля те анен андре жертва дує горлічкєн або дує цікне голубен. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Андро Єрусалім джівелас єкг мануш про нав Сімеон. Ов есас чачібнаскєро мануш, кай даралас ле Девлестар, і ужарелас, кана о Дейл подлікєрела ле Ізраєль. І Свентно Духос есас пре лесте. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Лескє есас сікадо ле Свентне Духога, со ов на мерела джі кє оди овра, адик на дикгєла ле Раєскєро Хрістос. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","І ліґєндо ле Духога, авля андро храмос. А е дай те о дад анде ле Чаворес, ле Ісус, гой те кєрен лега ода, со кєрелпес пало Законос. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Сімеон іля Лес пре пескєре васта, ашардя ле Девлес і пгендя: ");
INSERT INTO rmczrb_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","— Владаріс! Авка, сар Ту динял о лав, канакє Ту одмукєс Пескєре совґас ле мірога, ");
INSERT INTO rmczrb_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","бо мійре якга дикгле Тийро ратипе, ");
INSERT INTO rmczrb_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","саве Ту кійсітиндял анґлал саворе мануша. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ов гіно шветлос, саво прешвецінела пгувакєре манушен, і анела ашаріпе Тийре нийпоскє Ізраєльоскє! ");
INSERT INTO rmczrb_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ле Ісусоскєре дад те е дай чудаліненаспес одале лавенґє, со есас пгендо пал Лесте. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Сімеон благословіндя лен і пгендя ле Маріякє, Лескєра дакє: — Пріґ када Чаворо, саво пашльол аде, бутджяне андало Ізраєль перена і вазденапес опре. Ов ейла знаменіє, саво бутджяне мануша на прелена. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Те тукє коркоракє е шабля преджяла пріґ тийрі вовді. Акор ейла пгутердо думішоґос, со буте манушенґє гін андро їло. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Есас одя минґ пророкіня Анна, ле Фануілоскєрі чай, ле Асіроскєре файтостар. Лакє есас бут берша. Кана ой ґейля роместе, ой есас минґ терні чайорі, і преджівділя пескєре ромега ефта берш. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","А паліш ачіля вдова, і авка доджівділя ко охтовардеш те штар берш. Ой ніґда на авелас аврі андал о храмос, а рат і дівес совґалінелас ле Девлескє андро постос те андре молітві. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Андре оди овра авля те ой оде, і ашарелас ле Девлес. І вакєрелас пало Чаворо саворенґє, ко ужарелас, со авела ратипе пріґ Єрусалім. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Кана Ісусоскєре дада кєрде саворо, со пгенел ле Раєскєро Законос, оне вісаліле пале андре Галілєя, андро пескєро фоврос Назарет. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Чаворо баролас, те кіделас андре Песте зор те е ґовді, а ле Девлескєро благіпе есас пре Лесте. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Сако берш про патрадякєро ійнепос ле Ісусоскєре дада пгіренас андро Єрусалім. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Сар Лескє есас дешудуй берш, ґейле андро Єрусалім, авка, сар міндик кєренас про ійнепос. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Пало ійнепос саворе ґейле кгєйре. А чаворо Ісус ачіля андро Єрусалім, та Лескєре дада пал ода на джяненас. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Оне думіненас пескє, со Ов джял варекай машкар ола нийпос, со ленца джянас єкгєтане. Сар преґейле єкгєдівесескєро дром, хунде Лес те роден машкар пескєро файтос те машкар о прінджяркутне. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Сар Лес на аракгле, ґейле пале андро Єрусалім і роденас Лес одя. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","А пало трін дівес ле Ісус аракгле андро храмос. Ов бешелас машкар танітова, шунелас і пгучкєрелас лендар. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","А саворе, со Лес шуненас, чудаліненаспес, саво Ов ґодявер, і сар ленґє отпгенелас. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Сар Лес дикгле Лескєре дада, чудаліндепес, а е дай Лескє пгендя: — Чаворея, соскє Ту авка кєрдял? Тийро дад те ме Тут родагас, і іґєн дарагас важ Туте. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ов ленґє пгендя: — Соске тумен Ман роденас? Чі тумен на джяненас, со Ме мушінав те авен андро Мійре Дадескєро кгєр? ");
INSERT INTO rmczrb_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Та оне на ахаліле ола лава, со ленґє Ов пгендя. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Акор Ов вісаліля ленца, авля андро Назарет, і шунелас лен. А лескєрі дай ґарувелас саворо ода андро пескєро їло. ");
INSERT INTO rmczrb_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ісус баролас і ачелас ґодяведер. Лес каменас мануша те о Дейл. ");
INSERT INTO rmczrb_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Про дешупанчто берш, кана Тіберій есас імператоріс, Понтій Пілат управлінелас андро Іудєя, а о Ірод есас владаріс-тетрархос андре Галілєя, а лескєро пграл о Філіпп есас владаріс-тетрархос андре Ітурея те андро Трахоніцько пгув, а о Лісіній есас владаріс-тетрархос андро Авілінея. ");
INSERT INTO rmczrb_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Кана есас єкг баредер рашая о Аннас те о Каяфа, есас о лав ле Девлескєро ко Іоанн, Захаріяскєро ча, андре пустиня. ");
INSERT INTO rmczrb_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","І преґейля ов пал цейлі пгув паже ріка Іордан. Іоанн проповідінелас ле манушенґє, гой те покаїненпес і те болавенпес, гой о Дейл те одмукєл ленґє о бійні. ");
INSERT INTO rmczrb_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Сар пісіме андре кніжка ко пророкос Ісая: «Шундьол ганґос андре пустиня: \"Кійсітинен о дром ле Раєскє, ровнярен о дром прекал Лесте! ");
INSERT INTO rmczrb_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Сако яркос мі зачівен, і сако брегос те о грункос мі помукєнпес тейле, а банґє дрома мі ачен ровне, а харакєре дрома мі ачен гладке. ");
INSERT INTO rmczrb_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","І сако джівдо дикгєла ратипе ле Девлескєро\"». ");
INSERT INTO rmczrb_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Акор Іоанн вакєрелас ле бутенґє, саве авенас кє лесте те болавенпес: — Родос сапенґєро! Ко диня туменґє те джянен, гой тумен те денашен ле холятар, саві авел пре туменде? ");
INSERT INTO rmczrb_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","А канакє сікавен тумаро покаяніє одалега, со тумен кєрен. І на думінен те вакєрен андре песте: «Амаро дад Авраам». Бо пгенав туменґє, со о Дейл шай кадале барендар ваздел чавен ле Авраамоскє. ");
INSERT INTO rmczrb_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Іма те о тговер пажо кореня дубоскєре пашльол. Сако єкг дубос, саво на анел лачо плодос, ейла чінґєрдо, і чівена лес андре яґ. ");
INSERT INTO rmczrb_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","І пгучелас лестар о нийпос: — Со аменґє те кєрен? ");
INSERT INTO rmczrb_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","А ов ленґє отпгендя: — Кє касте гін дуй ґада, мі дел єкг одалескє, кас нане, і кє касте гін о хабен, мі кєрел те ов авка. ");
INSERT INTO rmczrb_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Мануша, саве іскіден налогі, авле те болавенпес кє лесте, і пгучле лестар: — Танітов, со аменґє те кєрен? ");
INSERT INTO rmczrb_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","А ов ленґє пгендя: — На марен аврі ле манушендар бутередер, сар туменґє тгодо. ");
INSERT INTO rmczrb_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","І пгученас лестар те о суґлядя: — А аменґє со те кєрен? Іоанн ленґє пгендя: — Нікастар ле зорага на зален о лове, і на вінінен нікас, те ода на чачібе, а радисальон одалескє, со тумен зароден. ");
INSERT INTO rmczrb_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Нийпос іґєн ужарелас, кана авела Хрістос, і думінелас андро пескєро їло, чі на Іоанн гіно Хрістос. ");
INSERT INTO rmczrb_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Іоанн про ода саворенґє пгендя: — Ме болавав тумен ле панєга, но авел Зораледер мандар, Савонескє ме на сом достойно те пгутерен о сірімос про Лескєре камашлі. Ов болавела тумен Свентне Духога те ле яґага. ");
INSERT INTO rmczrb_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Андре Лескєро васт гіні лопата, і Ов жувжарела Пескєро дів. І скідела е дів андре Пескєрі комора, а о пгуса лабарела ле яґага, саві ніґда на мурдальол. ");
INSERT INTO rmczrb_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Бут со ов акор вакєрелас, і убіждінелас ле нийпос, і вакєрелас Радишаґоскєро Гійрос. ");
INSERT INTO rmczrb_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Кана ов кєздиндя те вакєрен андро якга ле Іродоскє, саво есас владаріс-тетрархос, кай ов іля пескє важ ромні ле Іродіада, пгралескєра ромня, і важ саворо авер подліпе, саво ов кєрдя. ");
INSERT INTO rmczrb_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","А Ірод ко саворо ода подліпе додиня минґ єкг, со ле Іоанн тгодя те бешен андре тюрма. ");
INSERT INTO rmczrb_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Акор, сар боладяпес саворо нийпос, а те Ісус боладяпес ленца. Ов терділя андре молітва пало болавіпе, і акор пгутердяпес о нєбос, ");
INSERT INTO rmczrb_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","і Свентно Духос авля пре Лесте андро тєлоскєрі подоба, сар голубос. І шунділя о ганґос андал о нєбос: — Ту сал Мійро Чаворо камадо, Ту сал Мійро радишаґос! ");
INSERT INTO rmczrb_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Кана Ісус кєздиндя Пескєро совґалніпе, Лескє есас вай транда берш. Сар думінде, Лескєро дад есас Йосип, а лескєре папі есас Ілій, ");
INSERT INTO rmczrb_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Матфат, Лєвій, Мелхій, Іаннай, Йосип, ");
INSERT INTO rmczrb_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Маттафія, Амос, Наум, Еслій, Наггей, ");
INSERT INTO rmczrb_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Мааф, Маттафія, Шімій, Іосіх, Іодай, ");
INSERT INTO rmczrb_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Іоаханан, Рісай, Зоровавель, Шеалтііл, Нірій, ");
INSERT INTO rmczrb_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Мелхій, Аддій, Косам, Елмадам, Ір, ");
INSERT INTO rmczrb_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Іосій, Елієзер, Іорім, Матфат, Лєвій, ");
INSERT INTO rmczrb_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Сімеон, Іуда, Йосип, Іонам, Еліакім, ");
INSERT INTO rmczrb_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Мелєай, Маінай, Маттафай, Нафан, Давід, ");
INSERT INTO rmczrb_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ієссей, Овід, Боаз, Сала, Нахшон, ");
INSERT INTO rmczrb_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Амінадав, Адмін, Арній, Хецрон, Парец, Іуда, ");
INSERT INTO rmczrb_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Яков, Ісаак, Авраам, Тєрах, Нахор, ");
INSERT INTO rmczrb_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Сєруґ, Реу, Фалєґ, Євер, Шелах, ");
INSERT INTO rmczrb_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Каінан, Арпахшад, Сім, Ной, Ламех, ");
INSERT INTO rmczrb_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Мафусал, Єнох, Іаред, Малєлєіл, Каінан, ");
INSERT INTO rmczrb_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Єнос, Сіф, Адам, Дейл. ");
INSERT INTO rmczrb_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ісус, пгердярдо Свентне Духога, вісаліля пало Іордан, і акор о Духос ліґєндя Лес андре пустиня, ");
INSERT INTO rmczrb_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","кай есас саранда дівес пробаліме аврі ле бинґестар. І на халас ніч андре одала дівеса, а про аґор Ов іґєн бокгаліля. ");
INSERT INTO rmczrb_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","І пгендя Лескє о бинґ: — Те Ту сал о Ча ле Девлескєро, акор пген кадале барескє, мі ачел марескє. ");
INSERT INTO rmczrb_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Но Ісус лескє отпгендя: — Пісіме: «На єкгєга марега джівела о мануш». ");
INSERT INTO rmczrb_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","І акор іля Лес о бинґ і ваздня про увчо брегос, і єкгваресте сікадя Лескє саворе светоскєре краліпена. ");
INSERT INTO rmczrb_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","І пгендя Лескє о бинґ: — Тукє дава ленґєрі влада те слава. Важ ода бо ой предині манґє, а ме каскє камав, одалескє дава ла. ");
INSERT INTO rmczrb_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","А канакє, те Ту бандьога анґлал манде, акор када саворо ейла Тийро. ");
INSERT INTO rmczrb_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","І акор Ісус отпгендя лескє: — Пісіме: «Бандю ле Раєскє Девлескє тийрескє і Лескє коркорескє совґалін». ");
INSERT INTO rmczrb_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","І ов ліґєндя Лес андро Єрусалім, і тгодя Лес про єкг увчедер тган храмоскєро і пгендя Лескє: — Те Ту сал о Ча ле Девлескєро, хуті тейле адарік. ");
INSERT INTO rmczrb_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Важ ода бо пісіме: «Пескєре анґєленґє дела аврі, гой те меркінен пал Туте», ");
INSERT INTO rmczrb_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","і «про васта ліджяна Тут, гой те на демес ко бар Пескєре піндрега». ");
INSERT INTO rmczrb_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","І отпгендя лескє Ісус: — Пісіме: «На пробалін аврі ле Раєс Девлес тийрес». ");
INSERT INTO rmczrb_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","І сар преачіля о бинґ те пробалінен Лес аврі, отґейля Лестар пре варесаві овра. ");
INSERT INTO rmczrb_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","І акор вісаліля о Ісус андро Духоскєрі зор андре Галілєя, і розґейляпес пал Лесте баро вакєрібе пал цейлі пгув. ");
INSERT INTO rmczrb_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ов сікавелас лен андро сінаґоґа, і есас ашардо саворе манушенца. ");
INSERT INTO rmczrb_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Єкгвар Ов авля андро Назарет, кай Ов баріля аврі, і, пал пескєро обичай, Ов заавля сомбатоне андре сінаґоґа і ушіля, гой те еґєнен. ");
INSERT INTO rmczrb_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","І дине Лескє кніжка ле пророкоскєрі Ісая. І сар пгутердя ла, Ов аракгля о тган, кай есас пісіме: ");
INSERT INTO rmczrb_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«О Духос ле Раєскєро пре Манде, бо Ов помакгля Ман те вакєрен ле чоренґє Радишаґоскєро Гійрос. О Дейл бічадя Ман те вакєрав ле спганленґє, гой оне ейна свободне, а ле коренґє, со оне дикгєна, те мукєн пре воля одален, кас дикгєн тейле, ");
INSERT INTO rmczrb_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","те розвакєрен берш пало Раєскєро лачіпе». ");
INSERT INTO rmczrb_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Сар запганля е кніжка, отдиня ла ле совґаскє і бешля Пескє. Акор саворе мануша андре оди сінаґоґа дикгєнас пре Лесте. ");
INSERT INTO rmczrb_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ов кєздиндя ленґє те вакєрен: — Дадіве, кана тумен шуненас, обачілепес одала пісіме лава! ");
INSERT INTO rmczrb_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Саворе ашаренас Лес те чудаліненаспес ле благіпнакєре лавенґє, саве Ов вакєрелас. — Ов со, на ле Йосипоскєро Ча? — пгучкєренас оне. ");
INSERT INTO rmczrb_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","А Ов пгендя ленґє: — Га, тумен пгенена Манґє када вакєрібе: «Докторея, сасар коркоро тут! Амен шундям, со кєрдял андро Капернаум, кєр те аде, андро пескєро власно фоврос». ");
INSERT INTO rmczrb_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Чачібе пгенав туменґє, со ані єкгєс пророкос на прелен андре пескєро власно пгув. ");
INSERT INTO rmczrb_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Чачібе пгенав туменґє: бут есас вдові андро Іліяскєре дівеса андро Ізраєль, кана нєбос есас запганло про трін берш те шов чон, і есас акор барі бокг пал цейлі пгув. ");
INSERT INTO rmczrb_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","І ані кє єкг лендар на есас бічадо Ілія, а чак кє вдова андре Сарепта пажо Сідон. ");
INSERT INTO rmczrb_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","І бут есас андро Ізраєль прокажоне мануша, кана джівелас пророкос Єлісєй, та ані єкг лендар на жувжардяпес, чак єкг сірійцос Нааман. ");
INSERT INTO rmczrb_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Сар шунде кадала лава, барі руш авля пре саворенде андре сінаґоґа. ");
INSERT INTO rmczrb_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Оне хутіле ле тганендар і транле Лес аврі андало фоврос. І ліґєнде Лес про аґор ко брегос, кай тердьолас ленґєро фоврос, гой те чівен Лес тейле. ");
INSERT INTO rmczrb_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Та Ов преґейля машкар ленде і отґейля лендар. ");
INSERT INTO rmczrb_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ов авля андро Капернаум, фоврос галілєйсько. І сако сомбат сікавелас ле нийпос. ");
INSERT INTO rmczrb_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Оне чудаліненаспес Лескєре сікавібнакє, важ ода бо андро Лескєро лав есас влада. ");
INSERT INTO rmczrb_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Акор андре сінаґоґа есас о мануш, андро саво есас духос нажувже дємоностар. Ов завріскіндя баре ганґога: ");
INSERT INTO rmczrb_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","— Яй! Со Тукє кампел амендар, Ісус андал Назарет? Ту авлял те пгаґєрен амен? Джянав Тут, Ко Ту — Свентно Девлескєро! ");
INSERT INTO rmczrb_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","— Заціхісалю! — строгонес диня аврі лескє Ісус. — Джя аврі лестар! Дємон чідя одале манушега машкар сінаґоґа і авля аврі андал лесте, і на кєрдя лескє нісаві чкода. ");
INSERT INTO rmczrb_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Саворе чудаліненаспес і вакєренас єкг аврескє: — Со ода за сікавібе, кай гін Лес влада те е зор, кай Ов нажувже духенґє дел аврі, і оне джян аврі? ");
INSERT INTO rmczrb_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Розґейляпес о вакєрібе пал Лесте пало саворі оди пгув. ");
INSERT INTO rmczrb_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Сар ґейля аврі андал сінаґоґа, Ов заавля андро кгєр ко Сімон. Сасуй Сімонескєрі есас андре баре лазі, і оне манґєнас Лес важ лате. ");
INSERT INTO rmczrb_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Сар Ісус подавля кє лате, Ов диня аврі ле лазенґє те мукєн ла, і ой одмукля ла. Єкгваресте ой ушіля опре і ачіля те совґалінен ленґє. ");
INSERT INTO rmczrb_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Кана авелас тейле о кгам, саворе, кє касте есас насвале мануша про любо насвалібе, аненас лен ко Ісус. А Ов тговелас про сако мануш о васта і сасарелас лен аврі. ");
INSERT INTO rmczrb_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Бутендар авенас аврі дємони ле вріскішаґога: — Ту сал о Ча ле Девлескєро! Ов диня аврі ленґє, гой оне те на вакєрен. Бо оне джяненас, со Ов гіно Хрістос. ");
INSERT INTO rmczrb_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Кана ачіля о дівес, Ов ґейля андало ода фоврос андро біманушенґєро тган. А о мануша роденас Лес, а сар аракгле, на каменас те одмукєн Лес. ");
INSERT INTO rmczrb_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Та Ов пгендя ленґє: — Те авер фовренґє Ме маїнав те вакєрен Радишаґоскєро Гійрос пало Краліпе ле Девлескєро, бо пре када Ме сом бічадо. ");
INSERT INTO rmczrb_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","І Ов проповідінелас андре Іудєякєре сінаґоґі. ");
INSERT INTO rmczrb_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Єкгвар Ісус тердьолас пажо озеро Генісарет, а нийпос іскікіндяпес машкар Лесте і шунелас Девлескєро лав. ");
INSERT INTO rmczrb_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","І дикгля Ов дуй шіфі, со тердьонас пажо брегос. Галаса, саве авле андал пескєре шіфі, блійтиненас сіткі. ");
INSERT INTO rmczrb_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Сар заґейля андре єкг шіфа, кай есас Сімоноскєрі, Ісус манґля лес те одландьон надур ле брегостар. Паліш Ов бешля і андал е шіфа кєздиндя те сікавен ле нийпос. ");
INSERT INTO rmczrb_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","А кана Ов преачіля те вакєрен, пгендя ле Сімоноскє: — Преландю, кай баро пані, і зачів тийрі сітка, гой те худен е мачі. ");
INSERT INTO rmczrb_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Сімон отпгендя: — Танітов, цейло раті амен пгарес кєрагас, та те авка ніч на хундям. Та пал Тийро лав ме зачівава е сітка. ");
INSERT INTO rmczrb_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","А кана кєрде ода, оне хунде айці бут мача, кай ленґєрі сітка чіндьолас. ");
INSERT INTO rmczrb_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Оне кєздинде те сікавен ле вастенца баратенґє андал авер шіфа, гой мі авен те поможінен ленґє. Оне подланділе і пгердярде дуй шіфі авка, гой шіфі кєздинде те ташльон. ");
INSERT INTO rmczrb_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Сар дикгля ода о Сімон Петро, пейля ко піндре Ісусоскєре і пгендя: — Мук ман, Раєя, бо ме сом бійношно мануш! ");
INSERT INTO rmczrb_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ов пгендя авка важ ода, бо іґєн даранділя. І саворе, ко есас лега, предарадепес одалестар, кай оне хунде айці бут мача. ");
INSERT INTO rmczrb_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","А лега даранділе те лескєре барата: Яков те Іоанн, о чаве Зеведєйоскєре. Ісус пгендя ле Сімоноскє: — На дара, адале дівесестар ту худега ле манушен. ");
INSERT INTO rmczrb_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Сар цірдне про брегос о шіфі, оне мукле саворо і ґейле пало Ісус. ");
INSERT INTO rmczrb_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Єкгвар, кана Ов есас андро єкг фоврос, єкг мануш, саво есас прокажоно, дикгля ле Ісус, пейля про муй і іґєн манґєлас Лес: — Раєя! Те Ту камес, Ту шай ман жувжарес! ");
INSERT INTO rmczrb_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ісус прецірдня о васт, тгодя пре лесте і пгендя: — Камав, ав жувжо! І єкгваресте проказа ґейля лестар тейле. ");
INSERT INTO rmczrb_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Акор Ісус диня аврі одале манушескє нікаскє те на вакєрел пал када, а федер пгендя: — Джя і сікавпес ле рашаєскє. А важ ода, кай обжувжардялпес, ан е жертва, авка, сар пгендя Моїсєй, ленґє про свідєтєльство. ");
INSERT INTO rmczrb_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","О вакєрібе пало Ісус розґейляпес минґ дуредер, і бут нийпос авенас те шунен Лес і те сасарен пескєро насвалібе. ");
INSERT INTO rmczrb_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","А Ов джялас андро біманушенґєро тган і одя модлінеласпес. ");
INSERT INTO rmczrb_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Єкгвар, кана Ов сікавелас, бешенас оде фарісєї а те танітова Законоскєре, саве авле пал саворе Галілєякєре те Іудєякєре фовра, а те андал Єрусалім. І зор ле Раєскєрі есас про Ісус, і Ов сасарелас насвале манушен. ");
INSERT INTO rmczrb_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Акор паруджяне мануша анде про тган ле манушес, саво на бійрінелас пега те чалавен. Оне іґєн фес каменас те заліджян лес андро кгєр і те тговен лес анґлал Ісус. ");
INSERT INTO rmczrb_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","А сар на аракгле, катар те заліджян лес, бо бут есас мануша оде, вазднепес про падос, розкінде черепіца, і пріґ падос мукле лес ле тганега машкар мануша анґлал Ісус. ");
INSERT INTO rmczrb_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Кана Ісус дикгля ленґєро патябе, пгендя одале манушескє: — Манушея, одмукєнпес тукє тийре бійні! ");
INSERT INTO rmczrb_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","А танітова Законоскєре і фарісєї подуміненде андре песте: «Ко Ов айсо, кай вакєрел айсе бійношне лава? Ко шай одмукєл о бійне, те на чак єкг о Дейл?» ");
INSERT INTO rmczrb_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ісус джянелас, со ленґє гін пре ґовді, і важ ода пгендя: — Пал состе думінен андре тумаре їле? ");
INSERT INTO rmczrb_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Со ловкєдер те пгенен: «Одмукєнпес тукє тийре бійне», або те пгенен: «Уші те пгір»? ");
INSERT INTO rmczrb_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Но тумен маїнен те джянен, гой ко Ча ле Манушенґєро гін влада пре пгув те одмукєн о бійне. Акор Ов пгендя насвалескє: — Тукє пгенав: уші, ле тийро тган і джя андро тийро кгєр. ");
INSERT INTO rmczrb_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ов єкгваресте ушіля анґлал ленде, іля ода, пре состе пашльолас, те ґейля, ашаріпнага ле Девлес, андро пескєро кгєр. ");
INSERT INTO rmczrb_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Саворе чудаліненаспес і кєздинде те ашарен ле Девлес. Ле бара даратар оне вакєренас: — Дадіве амен дикглям ода, со наший айсо ейл. ");
INSERT INTO rmczrb_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Пало ода Ісус ґейля одарік і дикгля ле манушес, саво іскіделас налогі, про нав Лєвій, саво бешелас про тган, кай іскіден налогі, і пгендя лескє: — Ав пал Манде. ");
INSERT INTO rmczrb_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ов ушіля, мукля саворо і ґейля пал Лесте. ");
INSERT INTO rmczrb_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Паліш о Лєвій кєрдя андро пескєро кгєр баро дийлос прекал Ісус. Оде есас бут мануша, саве іскіденас налогі, а те авер мануша, саве есас ленца пажо скамін. ");
INSERT INTO rmczrb_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","А танітова Законоскєре те о фарісєї дудріненас про Ісусоскєре сікаден і вакєренас: — Соске тумен хан те пієн ле манушенца, саве іскіден налогі, а те ле бійношненца? ");
INSERT INTO rmczrb_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ісус ленґє отпгендя: — На ле састенґє кампел докторіс, а насваленґє. ");
INSERT INTO rmczrb_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ме авльом те звічінен на чачібнаскєрен, а ле бійношнен, гой те розвісаренпес ле бійнендар. ");
INSERT INTO rmczrb_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Акор оне пгенде ле Ісусоскє: — Соске Іоанноскєре сікаде бутвар гіне андро постос і міндик модліненпес, авка те о фарісєєнґєре, а Тийре хан те пієн? ");
INSERT INTO rmczrb_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Та Ісус отпгендя ленґє: — Чі шай тумен заставінен ле манушен те лікєрен постос, кана гіне про біяв, адик ленца гіно о терно? ");
INSERT INTO rmczrb_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Та авена айсе дівеса, кана залелапес лендар о терно, акор андро одала дівеса і лікєрена о постос. ");
INSERT INTO rmczrb_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","І розвакєрдя Ов ленґє єкг вакєрібе: — Ніко, сар отчінел, на пресівел о котор андал нейве голмі ко пгуране, бо акор те нейве голмі чінґєрсальона, і ко пгурано на подджял нейво котор. ");
INSERT INTO rmczrb_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","І ніко на чорел терні мол андро пгуране ґовне, бо акор чіндьона о ґовне ле терня молятар. І акор саворо чуляла аврі, а о ґовне проперена. ");
INSERT INTO rmczrb_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Терні мол кампел те зачорен андре нейве ґовне. ");
INSERT INTO rmczrb_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Та ніко, ко пробаліндя пгурані мол, на закамела нейві, бо пгенела: «Пгурані мол федер». ");
INSERT INTO rmczrb_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Єкгвар сомбатоне Ісус преджялас пріґ шеїме маля, а Лескєре сікаде чінґєркєренас е дів, і ле вастенца жувжаренас і ханас. ");
INSERT INTO rmczrb_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Вареко фарісєєндар пгучле лендар: — Соске тумен кєрен ода, со наший те кєрен сомбатоне? ");
INSERT INTO rmczrb_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ісус ленґє отпгендя: — Тумен со, на еґєндян, со кєрдя о Давід, кана бокгаліля коркоро, а те одала, ко есас лега? ");
INSERT INTO rmczrb_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ов заавля андро Девлескєро кгєр, іля маро, саво тговенас анґлал о Дейл, саво наший есас те хан нікаскє, ча єкгє рашаєнґє, і халас ов, і диня одаленґє, ко есас лега. ");
INSERT INTO rmczrb_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","А паліш додиня: — О Ча ле Манушенґєро гіно Хулай те ле сомбатоскєро! ");
INSERT INTO rmczrb_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Про авер сомбат Ов заґейля андре сінаґоґа і сікавелас. Одя есас єкг мануш, ко саво есас чачо васт шувко. ");
INSERT INTO rmczrb_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Танітова Законоскєре те о фарісєї дикгєнас пал Лесте, чі на сасарела Ов сомбатоне, важ ода бо роденас, сар ленґє те засудзінен Лес. ");
INSERT INTO rmczrb_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ісус джянелас, пал состе оне думінен, і важ ода пгендя ле манушескє, ко саво есас шувко васт: — Уші і тердю про машкар. Ов ушіля і терділя. ");
INSERT INTO rmczrb_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Акор Ісус пгендя ленґє: — Пгучав тумендар: со шай те кєрен сомбатоне — лачіпе чі подліпе, те ратинен джівіпе чі те мурдарен? ");
INSERT INTO rmczrb_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ов дикгля про саворе і акор пгендя манушескє: — Прецірде пескєро васт. Ов авка кєрдя, і ачіля лескєро васт цалком сасардо. ");
INSERT INTO rmczrb_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","А оне ачіле іґєн холяме і кєздинде те довакєренпес єкг аврега, со ленґє те кєрен ле Ісусога. ");
INSERT INTO rmczrb_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Обачіляпес але дівесенца: ваздняпес Ісус про брегос, гой те модліненпес, і есас цейло раті андро молітва ко Дейл. ");
INSERT INTO rmczrb_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","А кана ачіля о дівес, Ісус ізвічіндя Пескєре сікаден і іскіндя лендар дешудуєн, савен Ов і вічіндя апостоленца: ");
INSERT INTO rmczrb_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ле Сімон, савескє диня нав Петро, те ле Андріюс, лескєре пгралес, ле Яковс те ле Іоанн, ле Філіпп те ле Варфоломіюс, ");
INSERT INTO rmczrb_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ле Матфіюс те ле Фомас, ле Яковс, саво есас о ча ле Алфіюскєро, те ле Сімон, савес вічіненас Зілот, ");
INSERT INTO rmczrb_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ле Іудас, саво есас Яковскєро ча, і ле Іудас Іскаріот, саво паліш бікєндя ле Ісус. ");
INSERT INTO rmczrb_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Кана авля тейле, Ов терділя ленца про ровно тган. Одя іскіндепес пгердо Лескєре сікаде і іґєн бут нийпос андал саворі Іудєя, те андал Єрусалім, і пало фовра Тір те Сідон, саве тердьонас пажо морьос. ");
INSERT INTO rmczrb_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Оне авле те шунен Лес і те сасаренпес пескєре насвалібнендар. Те одала, саве есас мучіме нажувже духендар, і сасаренаспес аврі. ");
INSERT INTO rmczrb_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Сако єкг бутджянендар камелас те дохуденпес кє Лесте, бо Лестар авелас аврі зор, саві сасарелас саворен. ");
INSERT INTO rmczrb_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ісус дикгля про Пескєре сікаде і кєздиндя те вакєрен: — Бахтале тумен, чоре, важ ода кай тумаро гіно о Краліпе ле Девлескєро. ");
INSERT INTO rmczrb_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Бахтале тумен, бокгале дадіве, бо чальона. Бахтале тумен, кай ровен дадіве, бо тумен асанапес. ");
INSERT INTO rmczrb_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Бахтале тумен, кана мануша тумен мержінена, кана традкєрена тумен і кєрена тумендар ладж, кана джюнґлярена аврі тумаре нава, і са када кєрена туменца важо Ча ле Манушенґєро. ");
INSERT INTO rmczrb_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Радисальон андро ода дівес і кгєлен радишаґостар. Барі награда тумарі про нєбос! Авка кєренас ле пророкенца кадале манушенґєре дада. ");
INSERT INTO rmczrb_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","А туменґє, барвале, біда! Бо тумен іма хундян тумаро радишаґос. ");
INSERT INTO rmczrb_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Біда туменґє, чаленґє дадіве, бо тумен ейна бокгале. Біда туменґє, ко асал канакє, бо іґєн фес ровена. ");
INSERT INTO rmczrb_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Біда туменґє, кана саворе мануша вакєрена пал туменде лачіпе, бо авка кєренас ле лжепророкенца ленґєре дада. ");
INSERT INTO rmczrb_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","— Туменґє, ко шунел, пгенав: камен ле враген тумарен, кєрен лачіпе одаленґє, ко мержінел тумен, ");
INSERT INTO rmczrb_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","благословінен одален, ко кошкєрел тумен, і модліненпес важ одала, ко джюнґлярел тумен. ");
INSERT INTO rmczrb_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Одалескє, ко дикгєла тут тейле і марел тут пале чам, подтгов те авер, а одалестар, ко залел тутар опруне голмі, домук, мі залел те о ґад. ");
INSERT INTO rmczrb_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Саконескє, ко манґєл тутар, де; а одалестар, ко залел тийро, на манґ пале. ");
INSERT INTO rmczrb_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Кєрен ле манушенґє авка, сар тумен камен, гой оне те кєрен туменґє. ");
INSERT INTO rmczrb_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Те тумен камен чак одален, ко камел тумен, акор важ соске туменґє те палікєрен? Бо те о бійношне мануша камен одален, ко камел лен. ");
INSERT INTO rmczrb_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Те тумен кєрен лачіпе чак одаленґє, ко кєрел лачіпе туменґє, акор важ соске туменґє те палікєрен? Бо те о бійношне мануша авка кєрен. ");
INSERT INTO rmczrb_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Те тумен дена камібе чак одаленґє, кастар бійзіненпес те худен о камібе пале, акор важ соске туменґє те палікєрен? Бо те о бійношне мануша ден о камібе бійношне манушенґє, гой те худен пале айці. ");
INSERT INTO rmczrb_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Та тумен камен ле враген тумарен, кєрен ленґє лачіпе, і ден о камібе, та на ужарен, со вісарелапес. Акор ейла туменґє барі награда, і ейна тумен чаве Майопрунескєрес. Ов гіно лачо ко напатівале і ко холяме. ");
INSERT INTO rmczrb_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Авен лачеїлескєре авка, сар те о Дад тумаро лачоїлескєро. ");
INSERT INTO rmczrb_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","На судзінен, і на ейна судзіме. На осудзінен, і тумен на ейна осудзіме. Пребачінен, і тумен ейна пребачіме. ");
INSERT INTO rmczrb_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ден, і дена туменґє, лачі міра, тапошіме, разіме і препгердярді чівена туменґє андре брек тумаро. Бо сар тумен мійрінен авренґє, авка ейла мійріме те туменґє. ");
INSERT INTO rmczrb_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ісус розвакєрдя ленґє єкг вакєрібе: — Чі шай о коро ліджял ле корес? Чі на перена со дуйджяне андре хар? ");
INSERT INTO rmczrb_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Сікадо нане баредер пескєре танітовстар, та сако, ко сікльолапес аврі, ейла айсо, сар лескєро танітов. ");
INSERT INTO rmczrb_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Со ту дикгєс про шмецос андре якг тийре пгралескє, а о ційло андре пескєрі якг на дикгєс? ");
INSERT INTO rmczrb_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Бо сар шай пгенес пескєре пгралескє: «Пграла, де, мі лав аврі о шмецос андал тийрі якг», кана на дикгєс о ційло андре пескєрі якг? Буджяндо, ле аврі анґлал о ційло андал пескєрі якг, а паліш дикгєга, сар те лен аврі о шмецос андал якг пескєре пгралескє. ");
INSERT INTO rmczrb_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Бо нане лачо дубос, саво шай анел кірно плодос, і нане о дубос кірно, саво шай анел лачо плодос. ");
INSERT INTO rmczrb_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Бо сако дубос прінджярелапес пал пескєро плодос. Бо кгандрендар на іскіден інжірос, і ле тернячкєндар на іскіден дракга. ");
INSERT INTO rmczrb_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Лачо мануш андал лачі сокровіщніца пескєре їлестар анел аврі лачіпе, а налачо мануш андал налачі сокровіщніца пескєре їлестар анел аврі подліпе. Бо ле манушескє пре чіб ода, сога пгердярдо лескєро їло. ");
INSERT INTO rmczrb_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Соске тумен Ман вічінен: «Раєя, Раєя!», а на кєрен ода, со Ме вакєрав? ");
INSERT INTO rmczrb_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Сако, ко авел кє Манде, шунел Мійре лава і долікєрел лен, пгенава туменґє, пре касте ов пес марел. ");
INSERT INTO rmczrb_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ов марелпес про мануш, саво строїнел о кгєр, саво ваїнелас, і кєрдя барі хар, і тгодя фундаментос про бар. А кана обачіляпес, со авля барі ріка і савора зорага чулялас про ода кгєр, ой на бійрінелас лес те чалавен, бо ов есас міште строїме. ");
INSERT INTO rmczrb_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","А ко шунел і на долікєрел, ода марелпес про мануш, саво строїнел о кгєр пре пгув бі фундаментос. Про саво авля барі ріка, і ов єкгваресте пейля тейле, і лескєро пгаґєрдіпе есас баро. ");
INSERT INTO rmczrb_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Сар довакєрдя Пескєре лава ко нийпос, Ісус заґейля андро Капернаум. ");
INSERT INTO rmczrb_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Одя ко єкг сотнікос есас насвало совґас, саво пашльолас про мерібе. Ода совґас есас іґєн драго ле сотнікоскє. ");
INSERT INTO rmczrb_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Кана ов шундя пало Ісус, ов бічадя кє Лесте іудєєнґєре пгуредерен те манґєн Лес, гой Ов те авел те сасарен лескєрес совґас. ");
INSERT INTO rmczrb_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","А оне, сар авле ко Ісус, іґєн фес манґєнас Лес і пгенде: — Ов засовґаліндя, гой Ту те кєрес када лескє, ");
INSERT INTO rmczrb_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","важ ода бо ов камел амаро нийпос, і ода ов строїндя аменґє сінаґоґа. ");
INSERT INTO rmczrb_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ісус ґейля ленца. Кана Ов есас іма надур ле кгєрестар, о сотнікос бічадя кє Лесте ле баратен те пгенен Лескє: — Раєя, на мучін Тут, бо ме на засовґалінав, гой Ту те заавес андро мійро кгєр. ");
INSERT INTO rmczrb_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ме подуміндьом, со ме на засовґаліндьом те авен кє Туте. Та пген о лав, і ейла сасардо мійро совґас. ");
INSERT INTO rmczrb_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Бо ме сом о мануш і подчінінавман преказенґє, і гін кє манде суґлядя, саве ман шунен. І пгенав єкгєскє: «Джя», — і ов джял, і аврескє: «Ав», — і ов авел. Те ле совґаскє мійрескє пгенав: «Кєр ода», — і ов кєрел. ");
INSERT INTO rmczrb_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","А сар Ісус шундя када, чудаліндяпес лескє, і вісаліля ко нийпос, саво джялас пал Лесте, і пгендя: — Пгенав туменґє, минґ андро Ізраєль ме на аракгльом айсо патябе! ");
INSERT INTO rmczrb_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Кана одала бічаде вісаліле кгєйре, акор аракгле, со совґас есас іма сасардо. ");
INSERT INTO rmczrb_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Сіґ Ісус ґейля андро фоврос, со вічінелпес Наїн. І джянас Лега Лескєре сікаде і іґєн бут нийпос. ");
INSERT INTO rmczrb_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Кана Ов доавля кє фовроскєрі капура, одарік аненас аврі ле мувлес, саво есас єкг ча кє пескєрі дай, а ой есас вдова. І іґєн бут нийпос джянас лага андал фоврос. ");
INSERT INTO rmczrb_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Сар о Рай ла дикгля, іґєн ла посаїндя і пгендя лакє: — На ров. ");
INSERT INTO rmczrb_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ов подґейля і хундяпес ко мохто. А одала, со ліджянас, терділе. І Ов пгендя: — Чаворея, тукє пгенав: уші! ");
INSERT INTO rmczrb_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Мувло бешля і хундя те вакєрен. А Ісус перединя лес ле дакє. ");
INSERT INTO rmczrb_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Барі дар авля про саворе, і оне ашаренас ле Девлес, вакєрібнага: — Баро пророкос ачіля машкар аменде, бо о Дейл авля те поможінен Пескєре нийпоскє! ");
INSERT INTO rmczrb_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ода лав розґейля пал Лесте пал саворі Іудєя те пало саворе пашуне фовра. ");
INSERT INTO rmczrb_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ле Іоанноскєре сікаде розвакєрде лескє пал саворо ода, со ачіля. Акор Іоанн вічіндя кє песте дуєн пескєре сікадендар ");
INSERT INTO rmczrb_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","і бічадя лен ко Рай те пгучен: — Чі Ту сал Ода, Саво маїнел те авен, вай аменґє те ужарен аврес? ");
INSERT INTO rmczrb_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Одала мануша подавле ко Ісус і пгенде: — Іоанн Боладо бічадя амен кє Туте те пгучен: чі Ту сал Ода, кай маїнел те авен, вай аменґє те ужарен аврес? ");
INSERT INTO rmczrb_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Андре оди овра Ов сасардя буте джянен ле насвалібнендар те мучішаґостар, і одален, андре касте есас налаче духі, те буте коренґє пгутердя о якга, гой те дикгєн. ");
INSERT INTO rmczrb_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ісус ленґє отпгендя: — Джян, розвакєрен ле Іоанноскє, со тумен дикглян те шундян: коре ачен те дикгєн, банґє пгірен, прокажоне ачен жувже, кашукє шунен, мувле ачен джівде, чоренґє вакєрелпес Радишаґоскєро Гійрос. ");
INSERT INTO rmczrb_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Бахтало ода, ко на демелапес тейле пал дром важ Манде! ");
INSERT INTO rmczrb_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Кана ола, кас бічадя Іоанн, отґейле, Ісус кєздиндя те вакєрен ле нийпоскє пало Іоанн: — Пре состе тумен джянас те дикгєн анде пустиня? Про тростнікос, кай о барвал лес пгурдел? ");
INSERT INTO rmczrb_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Та пре касте тумен джянас те дикгєн? Талам, про мануш, саво есас урадо андро раїкане голмі? Та одала, ко кіделпес андро барвале голмі і джівел андро барваліпе, гіне андро кралєнґєре палаца. ");
INSERT INTO rmczrb_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Акор пре касте тумен пгіренас те дикгєн? Про пророкос? Га, пгенав туменґє, і бутер, сар про пророкос! ");
INSERT INTO rmczrb_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ов гіно пал, касте гін пісіме: «А канакє Ме бічавав Мійре бічадес анґлал Туте, саво кійсітинела Тийро дром анґлал Туте». ");
INSERT INTO rmczrb_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Пгенав туменґє: нане айсо, саво увліля ромнятар, саво увлялас баредер, сар Іоанн. Та єкг цікнедер андро Краліпе ле Девлескєро гіно баредер лестар. ");
INSERT INTO rmczrb_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Саворо нийпос, саво шунелас Лес, а те одала, саве іскіденас налогі, прінджярде Девлескєро чачібе, і боладепес ле Іоанноскєра болавіпнага. ");
INSERT INTO rmczrb_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","А фарісєї те танітова Законоскєре отпгендепес лестар те болавен, і отчіде Девлескєрі воля. ");
INSERT INTO rmczrb_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ісус пгендя: — Кага шай ровнярав када манушенґєро родос? Пре касте оне пес марен? ");
INSERT INTO rmczrb_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Оне маренпес про чаве, саве бешен про піяціс і вріскінен єкг аврескє: «Амен башавагас туменґє пре дудка, а тумен на кгєленас; амен ґілявагас туменґє парушаґоскєре ґіля, та тумен на ровенас». ");
INSERT INTO rmczrb_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Авля Іоанн Боладо, на хал о маро, на пієл е мол. А тумен вакєрен: «Андре лесте о дємон». ");
INSERT INTO rmczrb_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Авля о Ча ле Манушенґєро, хал те пієл, а тумен вакєрен: «Акєс мануш бокгалярдо і матяркєрдо, баратос одаленґє, ко іскідел налогі, те бійношненґє». ");
INSERT INTO rmczrb_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Та ґодяверіпе гіні оправдіме саворе лакєре чавенца. ");
INSERT INTO rmczrb_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Єкг фарісєй вічіндя ле Ісус кє песте про дийлос. Ісус заавля андро кгєр ко фарісєй і захундя тган пажо скамін. ");
INSERT INTO rmczrb_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Андро ода фоврос есас єкг ромні, пал саві саворе джяненас, со ой есас бійношні. Кана ой доджянля, гой Ісус хал о дийлос андро кгєр ко фарісєй, андя алабастрово флаконос драге духенца. ");
INSERT INTO rmczrb_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ой тердьолас палал паж Лескєре піндре і ровелас, а лакєре асва перенас про Лескєре піндре. Ой кєздиндя пескєре баленца те коскєрен Лескєре піндре, і чумідкєрелас лен, і акор кєздиндя те макгєн лен ле духенца. ");
INSERT INTO rmczrb_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Фарісєй, саво вічіндя Лес, дикгля ода і пгендя андре песте: «Те Ов увлягас пророкос, акор джянлялас, саві ромні худелпес Лестар, со ой бійношні». ");
INSERT INTO rmczrb_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Акор Ісус пгендя кє лесте: — Сімон, маїнав тукє варесо те пгенен. А ов Лескє пгенел: — Пген, Танітов. ");
INSERT INTO rmczrb_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ісус пгендя: — Єкг мануш диня камібе дує манушенґє: єкг камелас лескє панчшел дінарія, а дуйто — пенда. ");
INSERT INTO rmczrb_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Та ані єкг лендар на бійрінелас те вісарен лескє камібе, і ов одмукля со дувджяненґє. Сар пал тийро, ко лендар бутер лес камела? ");
INSERT INTO rmczrb_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Сімон отпгендя Лескє: — Ме думінав, ода, каскє бутер камібе одмукля. Ісус лескє пгендя: — Міште ту ахалілял. ");
INSERT INTO rmczrb_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","І акор вісаліля кє ромні і пгендя Сімоноскє: — Дикгєс кадала ромня? Ме заавльом кє туте андро кгєр, ту пані Манґє про піндре на подинял, а ой пескєре асвенца обмордя Мійре піндре і кгосля пескєре баленца. ");
INSERT INTO rmczrb_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ту на чуміндял Ман, а ой, отканастар Ме авльом, на преачел те чуміден Манґє о піндре. ");
INSERT INTO rmczrb_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Шейро Мійро ту на помакглял Манґє, а ой духенца помакгля Манґє о піндре. ");
INSERT INTO rmczrb_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Важ ода пгенав тукє: лакє одмукєнпес бут бійні, бо ой бут закамля. А каскє фріма пребачіме, ода фріма камел. ");
INSERT INTO rmczrb_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Акор Ісус пгендя ла ромнякє: — Одмукєнпес тукє тийре бійні. ");
INSERT INTO rmczrb_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","А саворе, ко есас Лега пажо скамін і ханас о дийлос, кєздинде те вакєрен андре песте: «Та ко Ов айсо, кай одмукєл о бійні?» ");
INSERT INTO rmczrb_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ісус пгендя ла ромнякє: — Патябе тийро ратиндя тут. Джя ле мірога. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Пало ода Ісус преджялас пало фоврос те пало ґава, і вакєрелас Радишаґоскєро Гійрос пало Краліпе ле Девлескєро. Лега пгіренас дешудуй апостоли, ");
INSERT INTO rmczrb_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","а минґ варесаве ромня, саве есас сасарде ле налаче духендар і насвалібнендар: е Марія, саві есас про нав Магдаліна, андал саві авля аврі ефта дємони, ");
INSERT INTO rmczrb_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","те Іоанна, ромні Хузаскєрі, саво додикгєлас пало Іродоскєро кгєр, Сусанна і авер бутджяне, саве совґалінелас ленґє пескєра хулаїпнага. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Андал сако фоврос ко Ісус авенас мануша. Кана кє Лесте іскіндепес бут мануша, Ов розвакєрдя ленґє єкг вакєрібе: ");
INSERT INTO rmczrb_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","— Авля аврі мануш те шіїнен дів. Кана ов шіїнелас, єкг попейля пажо дром і есас тапошіме, і чірікле нєбоскєре хале саворо опре. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Авер попейля про баруно пгув, а кана авля аврі, шутіля, важ ода кай хібінелас лакє ціндіпе. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Тріто попейля машкар кгандре, а кана кгандре баріле опре, на дине, гой дів те барол. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Минґ авер попейля пре лачі пгув, а, кана баріля аврі, андя плодос про шелвар бутер. Сар када пгендя, Ов додиня: — Кас гін кгана те шунен, мі шунел! ");
INSERT INTO rmczrb_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Сікаде пгучле ле Ісусостар: — Со шай обозначінел када вакєрібе? ");
INSERT INTO rmczrb_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ов пгендя: — Туменґє дино те джянен ґарувіпе пало Краліпе ле Девлескєро, а авренґє вакєрелпес андро вакєрібе, гой «сар дикгєна, те на дикгєн, і сар шунена, те на ахальон». ");
INSERT INTO rmczrb_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Шунен, со обозначінел када вакєрібе: дів гіно Девлескєро лав. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ода, со пейля пажо дром, — гіне одала, саве шунен о лав; а паліш авел о бинґ і човрел о лав андал ленґєро їло, гой оне те на патян і те на авен ратиме. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Дів, саво пейля про бара, — ода одала, саве шунен і ле радишаґога прелен о лав, та нане лен кореньос. Варесаві овра оне патян, а кана пробаліненпес аврі, акор отперен. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Дів, саво пейля андро кгандре, — ода одала, саве шунде о лав, та сакодівесескєре заботи, барваліпе і тєлоскєрі жадоба тасавен о лав, і важ ода ленґєро плодос на добарол. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","А дів, саво пейля андре лачі пгув, — ода одала, саве шунен о лав, лікєрен лес андро жувжо лачо їло, і тийріпнага оне анен плодос. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ніко залабарді лампа на тговел толо дийньос вай толо тган, а тговел ла опре, гой одала, саве авена андре, те дикгєн о шветлос. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Бо нане ніч ґарудо, гой паліш те на увлялас пгутердо аврі, а ода, со запганло, гой те на доджянляласпес і на авлялас аврі, бо те авка ейла пгутердо аврі. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Меркінен, сар тумен шунен; кас е гін, одалескє доделапес, а кас нане, одалестар одлелапес минґ те ода, со ов думінел, гой кє лесте гін. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Авля ко Ісус Лескєрі дай те лескєре пграла, і на бійріненас те подджян кє Лесте, важ ода кай паж Лесте есас бут мануша. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Мануша дине Лескє те джянен: — Овкєс Тийрі дай те о пграла тердьон аврі і камен Тут те дикгєн. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Акор Ов ленґє отпгендя: — Мійрі дай те Мійре пграла — ода одала, саве шунен і долікєрен Девлескєро лав. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Андре єкг дівес Ов заґейля Пескєре сікаденца андре шіфа і пгендя ленґє: — Преландювага пре дуйто сийра панєскє. Оне кєздинде те преландьон. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Адик оне ландьонас, Ісус засувтя. Акор про пані ваздняпес іґєн барі барвал, і пані кєздиндя те зачорен ленґєрі шіфа, авка со оне ачіле андре барі біда. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Сікаде подґейле, уштаде ле Ісус і пгенде Лескє: — Танітов, Танітов! Мерас! Ов ушіля опре і диня аврі ле барвалякє те ле панєскє те преачен. Оне преачіле, і ачіля ціхонес. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ісус пгендя ленґє: — Кай тумаро патябен? Оне ле дарага чудаліндепес і вакєренас єкг аврескє: — Та ко Ов гіно Айсо, со ле панєскє те ле барвалякє дел аврі, а оне шунен Лес? ");
INSERT INTO rmczrb_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ісус те Лескєре сікаде преланділе кє пгув Герасінсько, кай гіні некі Галілєякє. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Кана Ісус авля про брегос, некі Лескє авля єкг мануш андало ода фоврос, саво есас бут берша мучіме дємоненца. Ов іма чірла на гординелас голмі і джівелас на андро кгєр, а андро гробніці. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Кана ов дикгля ле Ісус, пейля анґлал Лесте і зорале ганґога завріскіндя: — Со Тукє кампел мандар, Ісус, о Ча ле Девлескєро Майопрунескєрес? Манґав Тут, на мучін ман! ");
INSERT INTO rmczrb_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Важ ода Ісус диня аврі нажувже духоскє, мі джял аврі андал ода мануш. Дємон буталік мучінелас лес. Одалескє манушескє іспганденас ле ланценца о васта те о піндре, і меркіненас пре лесте. Та ов чінґєрелас о ланці, і дємон традкєрелас лес пало біманушенґєре тгана. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ісус лестар пгучля: — Сар тукє нав? Ов Лескє пгендя: — Лєґіон! Важ ода кай бут дємони заґейле андре лесте. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Оне кєздинде Лес те манґєн, гой Ов те на традел лен андре бездна. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Надур про брегос пасіненаспес бут баліча. Дємони манґєнас ле Ісус, гой Ов те домукєл ленґє те заджян андро баліча. Ов домукля ленґє. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Акор дємони авле аврі ле манушестар і заґейле ко баліча. Акор одала бале чідепес тейле пало баро брегос андро пані і ташліле. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Сар дикгле пастера, со обачіляпес, денашле і розвакєрде саворо андро фоврос те пало ґава. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Авле о мануша, гой те дикгєн, со одя обачіляпес. Оне подавле ко Ісус і аракгле ле манушес, андал саво авле аврі о дємони, саво бешелас ле Ісусоскє пажо піндре, урадо і сасардя ґовдяга, і лен обхундя дар. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","А одала, саве дикгле ода, со пес обачіля, розвакєрде ленґє, сар есас сасардо захундо дємонога. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Саворо нийпос герасінсько манґєлас ле Ісус, гой Ов мі джял гет лендар, важ ода кай барі дар авля пре ленде. Акор Ов бешля андре шіфа і вісаліля пале. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Мануш, андал саво ґейле аврі дємони, манґєлас ле Ісус, гой мі лел лес Пега. Та Ісус одмукля лес і пгендя: ");
INSERT INTO rmczrb_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","— Вісар тут пале ко тийро кгєр і розвакєр, со кєрдя прекал туте о Дейл. Ов ґейля і вакєрелас пал цейло фоврос, со кєрдя лескє Ісус. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Кана Ісус вісаліля кє Галілєя, о нийпос палікєренас Лескє, бо саворе ужаренас пре Лесте. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Акор авля єкг мануш про нав Іаір. Ов есас єкг баредер пре сінаґоґа. Ов пейля про коча анґлал Ісус і манґєлас Лес те заджян кє лесте андро кгєр. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Кє лесте есас чак єкг оди чайорі, варекай дешудуй бершескєрі, і ой мерелас. Ісус джялас одя, і нийпос кікіделас Лес. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Оде есас єкг ромні, кє саві іма дешудуй берш чулялас рат. Ой розкєрдя про доктора саворо, со ла есас, та те авка ніко на бійрінелас ла те сасарен. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ой подґейля ко Ісус палал і хундяпес ко аґор Лескєре голмендар, і єкгваресте рат преачіля латар те чулян. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ісус пгендя: — Ко дохундяпес кє Манде? Кана ніко на прінджяреласпес, Петро пгендя: — Танітов! О нийпос обтерділе і кікіден Тут саворе сийрендар. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ісус пгендя: — Вареко хундяпес кє Манде, бо Ме шундьом, сар зор авля Мандар аврі. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Кана ромні дикгля, со ой на бійрінелпес те ґарувен, акор бара дарага подґейля, пейля анґлал Ісус і розвакєрдя Лескє анґлал саворо нийпос, соске дохундяпес кє Лесте і сар єкгваресте есас сасарді. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Акор Ов лакє пгендя: — Чайоріє, патябе тийро ратиндя тут! Джя ле мірога. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Кана Ісус минґ вакєрелас, авля о мануш андало кгєр, саво есас єкг пгуредер пре сінаґоґа, і пгендя лескє: — Чайорі тийрі мувля. Бутер на чалав ле Танітов. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Кана Ісус шундя, акор пгендя Іаіроскє: — На дара, чак патя, і ой сасарелапес аврі. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Кана авля андро кгєр, на домукля нікас те заджян Пега. А Лега есас чак о Петро, Яков, те Іоанн і ле чайоракєро дад те е дай. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Саворе іґєн ровенас, і барі жаля пал лате есас. Та Ісус пгендя: — На ровен! Ой на мувля, а совел. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Акор саворе кєздинде те асанпес Лестар, бо оне джяненас, со ой мувля. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","А Ов іля ла пало васт те пгендя лакє: — Чайоріє, уші! ");
INSERT INTO rmczrb_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","І вісаліля лакєро духос андре лате, і ой єкгваресте ушіля. Ісус пгендя, гой мі ден лакє те хан. ");
INSERT INTO rmczrb_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Радишаґостар о дад те е дай на джяненас, со те пгенен. Та Ісус диня аврі ленґє, гой нікаскє те на вакєрен пало ода, со пес обачіля. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ісус вічіндя дешудуєн, і диня ленґє зор те е влада те траден аврі саворе дємонен і те сасарен насвалібе. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ов бічадя лен те вакєрен пало Девлескєро Краліпе і те сасарен ле насвален. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ов пгендя ленґє: — На лен ніч пега андро дром: ані паца, ані ташка, ані маро і нісаве лове, і на лен пега авер голмі. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Андро саво кгєр заджяна, одя те ачен, а паліш одарік джян дуредер. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Те варекай мануша на прелена тумен, акор, сар авена аврі андало ода фоврос, разінен аврі о прахос пал тумаре піндре про свідєтєльство протів одала мануша. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Сікаде ґейле дромега. Оне пгіренас ґав ґавестар, вакєренас Радишаґоскєро Гійрос і вшадзік сасаренас ле насвале манушен. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Кана Ірод владаріс-тетрархос шундя пал саворо када, ов іґєн чудалінеласпес. Варесаве вакєренас, со ода Іоанн ушіля андал о мерібе, ");
INSERT INTO rmczrb_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","авер вакєренас, гой сікадяпес Ілія, а минґ варесаве мануша вакєренас, гой єкг чірлатуно пророкос ушіля андало мерібе. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ірод пгендя: — Ле Іоанноскє ме отчіндьом о шейро. Акор ко ода Мануш, пал Касте ме шунав айсо? Ов іґєн камелас те дикгєн ле Ісус. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Кана апостоли вісаліле, оне розвакєрде Лескє, со кєрде. А паліш Ов іля чак лен Пега, і оне ґейле коркоре андро фоврос, саво вічінелпес Віфсаїда. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Та нийпос доджянляпес пал ода і ґейле пал Лесте. Ов преіля лен і вакєрелас ленґє пало Краліпе ле Девлескєро, а ле насвален сасарелас. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Кана аврі ратісаліля, акор дешудуя подґейле ко Ісус і вакєренас Лескє: — Одмук ле нийпос, мі джян андре пашуне цікне те баре ґава те пресовен і те аракгєн пескє хавібе, бо амен андро біманушенґєро тган. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Акор Ісус ленґє отпгендя: — Ден тумен ленґє те хан. А оне пгенде: — Кє аменде ніч нане, чак панч маре і дуй мача. Чі аменґє те джян, те цінен хавібе пре кадала саворе мануша? ");
INSERT INTO rmczrb_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Чак ле муршен одя есас варекай панч езера манушен. Та Ов пгендя пескєре сікаденґє: — Тговен лен те бешен копенца по пенда мануша. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Оне кєрде авка і розтгоде те бешен саворен. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ісус іля панч маре і дуй мача, дикгля про нєбос, палікєрдя, препгаґля і диня ле сікаденґє, те розден ле нийпоскє. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Саворе ханас те чаліле, а одале которендар, саве на дохале, іскінде минґ дешудуй кошара. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Єкгвар, кана Ісус модлінеласпес коркоро, і надур Лестар есас Лескєре сікаде, Ов пгучля лендар: — Важ касте прелел Ман о нийпос? ");
INSERT INTO rmczrb_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Оне отпгенде Лескє: — Єкг пгенен, со Ту сал Іоанн Боладо, а авер пгенен, со Ту сал Ілія, а вареко пгенел, со єкг чірлатуно пророкос ушіля андало мерібен. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Та Ов пгучля лендар: — А тумен важ касте Ман прелен? Акор Петро отпгендя Лескє: — Важо Хрістос Девлескєро. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Акор Ов ленґє диня аврі нікаскє те на вакєрен пало ода, ");
INSERT INTO rmczrb_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","вакєрібнага: — Ле Манушенґєро Ча маїнел іґєн бут те семвединен. Ов ейла отчідо ле пгуредеренца, єкг баредер рашаєнца те ле танітовенца Законоскєре. І маїнел тейн мурдардо, а про тріто дівес ушела андал о мерібе. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","А паліш Ісус пгендя ленґє: — Те вареко тумендар камел те авен пал Манде, акор отпген тут пестар, сако дівес ле пескєро кєрестос і ав пал Манде. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ко камел те ратинен пескєро джівіпе, ода нашавела лес, а ко нашавела пескєро джівіпе важ Манде, ода ратинела лес. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Саві хасна ле манушескє те захудела саворо светос, та коркоро пескє мосарела джівіпе і доліджяла лес ко мурдаріпе? ");
INSERT INTO rmczrb_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Важ ода ко ладжялапес Мандар і Мійре лавендар, одалестар ладжяла те о Ча ле Манушенґєро, кана Ов авела андре Пескєрі слава, андре слава ле Дадескєрі і свентне анґєленґєрі. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Та чачес пгенав туменґє: гін мануша машкар туменде, саве тердьон аде, саве на мерена, адик на дикгєна о Краліпе ле Девлескєро. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Варекай толо охто дівес, сар Ісус пгендя адала лава, Ов іля ле Петрос, ле Іоанн те ле Яковс і ваздняпес ленца про партос те модліненпес. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","А кана Ов есас андре молітва, о муй Лескєро чіріндяпес, а Лескєре голмі ачіле парне і іґєн фес бліскіненас. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Акор варекатар сікадепес дуй мурша і вакєренас Лега, ода есас Моїсєй те Ілія. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Оне сікадепес андре слава те вакєренас пало ода, сар Ов отджяла адале светостар андал Єрусалім. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Акор про Петрос те про одален, ко есас лега андре єкг, авля совібе. А кана оне ушіле опре андал совібе, дикгле Лескєрі слава а те дує муршен, саве тердьонас пашес паж Лесте. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ачіля авка, кана одала дувджяне іма джянас Лестар, акор Петро пгендя ле Ісусоскє: — Танітов, міште аменґє аде! Домук аменґє, і амен кєрага аде трін шатрі: Тукє єкг, Моїсєйоскє єкг те ле Іліяскє єкг, — та ов коркоро на ахальолас, со вакєрел. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Кана ов минґ вакєрелас, сікадяпес е хмара і зучардя лен, і авля пре ленде барі дар, кана ачіле андре хмара. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","І есас ганґос андал е хмара, саво вакєрелас: — Када Мійро Ча іскіндно. Лес шунен! ");
INSERT INTO rmczrb_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Кана ганґос ціхісаліля, Ісус ачіля Коркоро. А оне нікаскє на вакєренас андро одала дівеса пало ода, со оне дикгле. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Про авер дівес, кана оне авле тейле пало партос, одя ле Ісус ужаренас іма бут мануша. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Акор єкг мануш андал ода нийпос кєздиндя те вріскінен: — Танітов, манґав Тут, дикг про мійро чаворо, бо ов кє манде чак єкг! ");
INSERT INTO rmczrb_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","О духос худел лес, і ов єкгваресте кєздинел те річінен. Ов разінел лес авка, со андал лескєро муй джял е пена. Духос мучінел лес і лєду біду одмукєл лес. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ме манґльом Тийре сікаден те траден лес аврі, та оне на бійрінде. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ісус отпгендя: — О, біпатябнаскєро те спорціме родос! Кєці Манґє минґ тейн туменца і те тийрінен тумен? Ан аде тийре чаворес. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Кана чаворо подавля капка пашедер, акор дємон чідя лега пре пгув і кєздиндя лега іґєн фес те разінен. Та Ісус диня аврі нажувже духоскє, сасардя ле чаворес і диня лес ле дадескє. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Саворе, ко одя есас, чудаліненаспес, саво баро Дейл. А кана саворе чудаліненаспес саворескє, со кєрдя Ісус, Ов пгендя пескєре сікаденґє: ");
INSERT INTO rmczrb_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","— Шунен міште, со Ме канакє туменґє пгенава: о Ча ле Манушенґєро маїнел тейн предино андро васта ле манушенґєре. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Та оне на ахаліле када лав, бо ода лав есас ґарудо лендар. Оне на ахаліле Лес, та даранас Лестар те пгучен пало ода. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Акор есас машкар ленде о спорос: ко лендар ейла баредер? ");
INSERT INTO rmczrb_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ісус джянелас, со оне думінен, і важ ода Ов іля ле чаворес і тгодя лес паж Песте. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","І пгендя ленґє: — Ко прелела кадале чаворес андро Мійро нав — Ман прелел, а ко Ман прелел — прелел Одалес, Ко бічадя Ман. А ко гіно єкг цікнедер машкар туменде, ода гіно баредер. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Акор Іоанн пгендя Лескє: — Танітов, амен дикглям єкгє манушес, саво Тийре навега траделас аврі манушендар ле дємонен. Амен пгендям, гой те на кєрел када, бо ов аменца на пгірел. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Та Ісус ленґє отпгендя: — На запріщінен лескє, бо ко нане протів туменде, ода важ туменде. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Кана ле Ісусоскє подавля овра, і Лес маїндяпес те лен про нєбос, Лескє есас про їло те джян андро Єрусалім. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Акор анґлал Песте Ов бічадя ле бічаден, і оне ґейле андро єкг самарійсько ґав, гой те прікєрен саворо. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Та ґавутуне мануша на преіле ле Ісус, бо Ов джялас андро Єрусалім. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Сар дикгле када Лескєре сікаде, о Яков те Іоанн, пгенде Лескє: — Раєя, камес, амен манґага, мі авел е яґ пало нєбос те мурдарел лен? ");
INSERT INTO rmczrb_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","56","Та Ісус вісаліляпес кє ленде і диня ленґє аврі. Акор оне ґейле андро авер ґав. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Кана оне джянас андро дром, вареко пгендя Лескє: — Ме джява пал Туте, кай Ту те на ґейлялас! ");
INSERT INTO rmczrb_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ісус лескє отпгендя: — Ле ліскен гін пескєре хара, а ко чірікле нєбоскєре гін пескєре гнізда, а ко Ча ле Манушенґєро нане кай о шейро те тговен. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Те дуйтонескє пгендя: — Ав пал Манде. Та ов пгендя: — Раєя! Мук ман єкгвар, мі джяв те парунен мійре дадес. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ісус лескє пгендя: — Мук, гой мувле мі парунен пескєре мувлен. А ту джя і розвакєр пало Краліпе ле Девлескєро. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Минґ єкг пгендя Лескє: — Ме джява пал Туте, Раєя! Та єкгвар домук манґє, те джяв пошлєдньо раз те дикгав мійро чаладос. ");
INSERT INTO rmczrb_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Та Ісус лескє пгендя: — Сако, ко тгодя пескєро васт про плугос, а дикгєл минґ палал, нане гонно пріґ о Краліпе ле Девлескєро. ");
INSERT INTO rmczrb_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Пал ода о Рай іскіндя авер ефтавардеш сікаден і бічадя лен по дувджяне анґлал Песте андро сако єкг фоврос те о ґав, кай Ов Коркоро камелас те джян. ");
INSERT INTO rmczrb_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ов пгендя ленґє: — Увліпе баро, а бувтякєрен фріма. Важ ода манґєн ле увліпнакєре Хулаєс, гой Ов мі бічавел ле бувтякєрен те іскіден Пескєро увліпе. ");
INSERT INTO rmczrb_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Джян! Ме бічавав тумен, сар бакрорен машкар о рува. ");
INSERT INTO rmczrb_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","На лен пега ані тарца, ані ташка, ані камашлі і пало дром нікаскє на палікєрен. ");
INSERT INTO rmczrb_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Кана тумен заджяна андро кгєр, акор анґлал пгенен авка: «Мірос одале кгєрескє!» ");
INSERT INTO rmczrb_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Те одя джівел о мануш міроскєро, акор тумаро мірос ачела пре лесте; те наа, акор ов вісальола кє туменде. ");
INSERT INTO rmczrb_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ачен андро ода кгєр; хан і пієн ода са, со кє ленде гін. Бувтякєро засовґалінел, гой лескє те потінен. На преджян андал єкг кгєр андро авер. ");
INSERT INTO rmczrb_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Те тумен заджяна андро фоврос і оне тумен оде прелена, хан одя саворо, со оне туменґє дена. ");
INSERT INTO rmczrb_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Сасарен ленґєре насвален, і вакєрен ленґє: «Краліпе Девлескєро іма пашес кє туменде!» ");
INSERT INTO rmczrb_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","А те тумен заджяна андре варесаво фоврос і одя тумен на прелена, акор джян пало фовроскєре уці і пгенен: ");
INSERT INTO rmczrb_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","«Минґ о прахос тумаро фовроскєро, со захундяпес амаре піндрендар, амен разінас пре туменде. Та джянен: Краліпе Девлескєро іма пашес!» ");
INSERT INTO rmczrb_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Пгенав туменґє, со андро ода дівес Содомоскє ейла ловкєдер, сар адале фовроскє. ");
INSERT INTO rmczrb_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Біда тукє, Хоразін! Біда тукє, Віфсаїда! Бо те андро Тір те андро Сідон увлянас сікаде чудєса, саве есас сікаде кє туменде, то оне чірла покаїндянаспес, і урдянас пре песте лепеди, і бешлянас андро прахос. ");
INSERT INTO rmczrb_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Та Тіроскє те ле Сідоноскє ейла ловкєдер про судос, сар туменґє. ");
INSERT INTO rmczrb_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","А ту, Капернаум, думінес, со ейга ваздно ко нєбос? Наа, ту ейга чідо андро адос! ");
INSERT INTO rmczrb_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ко тумен шунел — Ман шунел, і ко на прелел тумен — Ман на прелел, а ко на прелел Ман — на прелел Бічадес Ман! ");
INSERT INTO rmczrb_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ефтавардеш сікаде вісаліле ко Ісус ле радишаґога і пгенде: — Раєя, минґ те о дємони аменґє покорне, кана амен преказінас ленґє Тийре навега! ");
INSERT INTO rmczrb_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ісус ленґє отпгендя: — Ме дикгльом ле сатана, саво, сар кана перумос, пейля пало нєбос! ");
INSERT INTO rmczrb_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ме диньом туменґє влада те тердьон про сапа те про скарпіони, те пре саворі врагоскєрі зор, і ніч туменґє на анела чкода. ");
INSERT INTO rmczrb_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Но радисальон на одалескє, кай туменґє духі подчініненпес, а одалескє, со тумаре нава запісіме про нєбос. ");
INSERT INTO rmczrb_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Андре оди овра Ісус радисаліля андро Свентно Духос і пгендя: — Ашарав Тут, Даде, Рай ле нєбоскєро і ле пгувакєро! Ту таґадиндял ода ле ґодяверендар те аврі сікадендар, а пгутердял цікноре чаворенґє. Га, Дадея, ода есас Тийрі лачі воля! ");
INSERT INTO rmczrb_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Мійро Дад саворо прединя Манґє. Ніко на джянел, ко гіно о Ча, чак єкг о Дад. І ніко на джянел, ко гіно о Дад, чак єкг Лескєро Ча і ода, каскє о Ча закамела те пгутерен Лес. ");
INSERT INTO rmczrb_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Паліш Ов вісаліля ко Пескєре сікаде і пгендя ленґє авка, гой чак оне те шунен: — Бахтале якга, кай дикгєн ода, со тумен дикгєн! ");
INSERT INTO rmczrb_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Пгенав туменґє, бут пророка те о краля каменас те дикгєн ода, со тумен дикгєн, та на дикгле, те шунен ода, со тумен шунен, та на шунде. ");
INSERT INTO rmczrb_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Аде ушіля єкг танітов Законоскєро і задиня ле Ісусоскє пгучібе, гой Лес те пробалінен аврі: — Танітов, со манґє те кєрен, гой те худав вечно джівіпе? ");
INSERT INTO rmczrb_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ісус лескє отпгендя: — Андро Законос со пісіме? Сар еґєнес? ");
INSERT INTO rmczrb_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ов отпгендя: — «Кам ле Раєс, Девлес пескєрес, саворе тийре їлега, савора тийра вовдяга, савора тийра зорага і савора тийра ґовдяга», і «пашунес тийрес авка, сар коркоро пес». ");
INSERT INTO rmczrb_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ісус лескє пгендя: — Міште ту пгендял. Авка кєр, і акор джівега. ");
INSERT INTO rmczrb_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Та о танітов Законоскєро камля те оправдиненпес і важ ода пгучля Ісусостар: — Ко гіно манґє пашуно? ");
INSERT INTO rmczrb_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Акор Ісус лескє отпгендя: — Єкг мануш джялас андал Єрусалім андро фоврос Єріхон. Пало дром хутіле пре лесте жівана, саве розкінде лес, ізмарде, про єпаш мувлес мукле лес і ґейле гет. ");
INSERT INTO rmczrb_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Обачіляпес авка, со пало ода дром преджялас о рашай. Ов дикгля одалес манушес і обґейля лес пало дуйто дромескєрі сийра. ");
INSERT INTO rmczrb_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Авка кєрдя те о лєвіт. Сар подавля ко ода тган, дикгля ле ізмардес, ов обґейля лес ле сийрага. ");
INSERT INTO rmczrb_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Пало ода дром преджялас і єкг самарянос. Ов дикгля одалес чорес і іґєн лес посаїндя. ");
INSERT INTO rmczrb_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ов подґейля, премордя лескєре рані олєйога і ле моляга, перепганкєрдя лен. А паліш тгодя лес про пескєро сомаріс, андя лес андре гостіно двовра і додикгєлас дуредер пал лесте. ");
INSERT INTO rmczrb_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Про дуйто дівес, сар джялас одарік дуредер, іля аврі дуй дінарія, диня ле хулаєскє і пгендя: «Дикг пал лесте, а те розкєрега бутередер, та акор, сар вісалювава пале, вісарава тукє». ");
INSERT INTO rmczrb_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Сар ту думінес, ко ачіля пашуно одале трінендар одалескє, саво попейляпес ле жіваненґє? ");
INSERT INTO rmczrb_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Танітов Законоскєро отпгендя: — Ода, саво есас кє лесте їлескєро! Акор о Ісус пгендя лескє: — Джя, а те ту авка кєр. ");
INSERT INTO rmczrb_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Пало дром Ісус авля сікаденца андро єкг ґав. Одя есас єкг ромні про нав Марфа, саві преіля Лес андре пескєро кгєр. ");
INSERT INTO rmczrb_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ла есас пгєнь, сава вічіненас Марія. Ой бешелас пажо піндре ле Раєскє і шунелас, со Ов вакєрелас. ");
INSERT INTO rmczrb_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","А Марфа есас занято одалега, гой федер те кєрен о дийлос. Ой подґейля ко Ісус і пгендя Лескє: — Раєя, Тут на ердекєлінел, со мійрі пгєнь мукля саворі бувті пре манде єкга? Пген лакє, мі поможінел манґє! ");
INSERT INTO rmczrb_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Та о Рай лакє отпгендя: — Марфо, Марфо, ту старінестут бут сога і холярестут, ");
INSERT INTO rmczrb_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","а кампел чак єкг. Марія іскіндя ода, со єкг федер, і ода на одлелапес латар. ");
INSERT INTO rmczrb_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Єкгвар, кана Ісус модлінеласпес про єкг тган і преачіля, акор єкг Лескєре сікадендар пгендя Лескє: — Раєя, сікав амен те модліненпес, сар Іоанн сікадя пескєре сікаден. ");
INSERT INTO rmczrb_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ов ленґє пгендя: — Кана модліненпес, пгенен авка: Даде, мі ашарелпес Тийро свентно нав! Мі авел Тийро Краліпе! ");
INSERT INTO rmczrb_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Маро амаро сакодівесескєро де аменґє про сако дівес! ");
INSERT INTO rmczrb_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Одмук аменґє амаре бійні, бо те амен одмукас саконескє, ко аменґє камел. І на пробалін амен аврі. ");
INSERT INTO rmczrb_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Паліш Ісус пгендя ленґє: — Пгенага, кє варекасте тумендар гін баратос, і ту джяга кє лесте про єпаш рат і пгенега лескє: «Баратона, де манґє про кейчен трін маре, ");
INSERT INTO rmczrb_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","бо авля мійро баратос пало дром кє манде, і манґє нане, со лескє те ден». ");
INSERT INTO rmczrb_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Чі пгенела ов андрунестар: «Де манґє смійром! О вудар іма запганло, чаве мійре манца совен про тган, на бійрінав ме канакє те ушен і те ден тукє о маро»? ");
INSERT INTO rmczrb_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Пгенав туменґє, те ов на ушела і на дела лескє, со оне гіне барата, та важ ода, со ов на преачел те манґєн, ов ушела і дела лескє айці, кєці ов манґєл. ");
INSERT INTO rmczrb_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Важ ода Ме пгенав туменґє: манґєн — і дена туменґє, роден — і аракгєна, дуркінен — і пгутерена туменґє. ");
INSERT INTO rmczrb_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Бо сако, ко манґєл, худел, а ко родел, ода аракгєл, а одалескє, ко дуркінел, пгутерена. ");
INSERT INTO rmczrb_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Чі аракгєлапес машкар туменде айсо дад, саво дела пескєре чаворескє ле сапес, кана ода манґєла мачі? ");
INSERT INTO rmczrb_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Або, те ода манґєл о андро, дела лескє ле скарпіонос? ");
INSERT INTO rmczrb_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Те тумен сан подле, а джянен те ден пескєре чаворенґє лаче дарункі, та акор Нєбоскєро Дад минґ федер дела Свентне Духос одаленґє, ко Лестар манґєл! ");
INSERT INTO rmczrb_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ачіля, со Ісус транля аврі ле нємоскєре дємон. І кана дємон авля аврі, мануш, саво есас нємо, завакєрдя. А о нийпос чудалінеласпес. ");
INSERT INTO rmczrb_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Та вареко лендар пгендя: — Ов традел аврі ле дємонен Вельзєвулоскєра зорага, хулай дємоненґєро! ");
INSERT INTO rmczrb_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Авер камле те пробалінен ле Ісус аврі і манґєнас Лестар, гой Ов мі сікавел ленґє знаменіє пало нєбос. ");
INSERT INTO rmczrb_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Та Ісус джянелас, пал состе оне думінен, і пгендя ленґє: — Сако краліпе, саво розуладо андрунестар, чувчісальола. І о кгєр, саво розуладяпес коркоро андре песте, перела. ");
INSERT INTO rmczrb_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Те о сатана коркоро андре песте розуладяпес, акор, сар тердьола аврі лескєро краліпе? Тумен вакєрен, со Ме Вельзєвулоскєра зорага традав аврі ле дємонен. ");
INSERT INTO rmczrb_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Те Ме Вельзєвулоскєра зорага традав аврі ле дємонен, акор тумаре чаве кага траден аврі лен? Важ ода оне ейна судзі туменґє. ");
INSERT INTO rmczrb_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Те Ме Девлескєра зорага традав аврі ле дємонен, акор Краліпе ле Девлескєро авля кє туменде. ");
INSERT INTO rmczrb_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Кана зорало і міште оружоно мануш меркінел про пескєрі двовра, акор лескєро хулаїпе на проперела. ");
INSERT INTO rmczrb_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Та кана вареко, ко зораледер мануш, хутєла пре лесте і марела лес, акор залела лестар лескєро оружіє, про саво есас бійзошно о хулай, і акор розулавела лескєро хулаїпе. ");
INSERT INTO rmczrb_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ода, ко на Манца, ода джял протів Манде, і ко на іскідел Манца, ода розчівкєрел. ");
INSERT INTO rmczrb_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Кана нажувжо духос авел аврі ле манушестар, акор блудзінел пало біпанєскєре тгана і родел о тган те спочовінен, та на аракгєл лес. Акор ов пгенел: «Вісалювава ме андро кгєр, катар ме авльом аврі». ");
INSERT INTO rmczrb_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Кана авел пале, акор аракгєл ода кгєр шуладо аврі і жувжо. ");
INSERT INTO rmczrb_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Акор ов джял і лел пега авер ефта духі, саве минґ холяредер, сар ов. І кана оне авен, то ачен одя те джівен. І ода ачел минґ хужедер одалестар, со есас чірла. ");
INSERT INTO rmczrb_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ісус минґ вакєрелас, кана єкг ромні ле буте нийпостар завріскіндя: — Бахталі оди дай, саві ловтярдя Тут і годовіндя Тут аврі! ");
INSERT INTO rmczrb_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ісус отпгендя: — Бахталедер одала, ко шунел Девлескєро лав і кєрел авка! ");
INSERT INTO rmczrb_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Кана іскіденаспес минґ бутередер мануша, акор Ісус кєздиндя те вакєрен: — Када родос — подло. Оне чак роден знаменіє, та ода на делапес ленґє, чак о знаменіє ле Іонаскєро. ");
INSERT INTO rmczrb_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Бо сар о Іона ачіля знаменьога прекал мануша андро Ніневія, авка ейла те о Ча ле Манушенґєро кадале родоскє. ");
INSERT INTO rmczrb_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Кралєвна югостар тердьола про судос кадале родоскєре манушенца і судзінела лен. Ой пало авер пгувакєро аґор авля те шунен Соломоноскєро ґодяверіпе. А канакє туменца аде Ода, Саво гіно баредер Соломоностар! ");
INSERT INTO rmczrb_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Мануша андал Ніневія тердьона про судос кадале родоскєре манушенца і засудзінена лен, бо оне покаїндепес, кана шунде Іонаскєре лава. А канакє туменца Ода, Ко баредер Іонастар! ");
INSERT INTO rmczrb_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Кана вареко залабарел е лампа, на тговен ла те тердьол андро ґарудо тган або толо чаро, а чак про лампакєро тган, гой одала, саве заавен, мі дикгєн о шветлос. ");
INSERT INTO rmczrb_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Тийрі якг — лампа тийре тєлоскє. Кана якг тийрі жувжі, акор цейло тийро тєлос ейла пгердо ле шветлога. Те кє туте тийрі якг подло, акор те саворо тийро тєлос ейла цма. ");
INSERT INTO rmczrb_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Важ ода дикг, гой шветлос, саво андре туте, те на ейл цма. ");
INSERT INTO rmczrb_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Те тийро саворо тєлос пгердярдо ле шветлога і нане андре лесте нісаві цма, акор саворо тєлос ейла шветло, авка, сар кана е лампа ошвецінел тут пескєре віланіга. ");
INSERT INTO rmczrb_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Кана Ісус авка вакєрелас, єкг фарісєй вічіндя Лес кє песте про дийлос. Ісус авля і захундя о тган пажо скамін. ");
INSERT INTO rmczrb_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Фарісєй чудаліндяпес, кана дикгля, со Ісус на мордя о васта анґлал о хавібе. ");
INSERT INTO rmczrb_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Акор о Рай лескє пгендя: — Тумен, фарісєї, жувжарен кувча те о чаре аврунестар, а андрунестар тумен пгерде сан гамішаґога а те подліпнага. ");
INSERT INTO rmczrb_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Дилине! Чі Ода, Ко кєрдя аврунескєро, на кєрдя те андрунескєро? ");
INSERT INTO rmczrb_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ода, со андрунесте, ден сар мілостиня, і акор саворо прекал туменде ейла жувжо! ");
INSERT INTO rmczrb_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Біда туменґє, фарісєї! Тумен анен дештато котор андал е мята те андал е рута і андал шільяко чар, а чачібе те Девлескєро камібен тумен обджян! Кампел те кєрен те ода, та наший те бістерен те пало дуйто. ");
INSERT INTO rmczrb_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Біда туменґє, фарісєї! Тумен камен те бешен про єкг федер тгана андре сінаґоґа і камен, кана туменґє палікєрен про піяціс. ");
INSERT INTO rmczrb_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Біда туменґє! Тумен маренпес про нєобозначіме гробі, пал саве пгірен о мануша і на джянен пал ода! ");
INSERT INTO rmczrb_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Акор єкг танітов Законоскєро пгендя Лескє: — Танітов, Ту Тийре лавенца шіртинес те амен. ");
INSERT INTO rmczrb_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ісус отпгендя: — Біда туменґє, танітова Законоскєре! Тумен тговен про мануша пгарібена, саве пгарес те гординен, а тумен коркоре ані анґуштега на дотговена ко ода. ");
INSERT INTO rmczrb_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Біда туменґє! Тумен строїнен памятніка ле пророкенґє, савен тумаре дада мурдарде. ");
INSERT INTO rmczrb_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Одалега тумен сікавен, со подлікєрен ода, со кєренас тумаре дада. Оне мурдарнас ле пророкен, а тумен строїнен ленґє памятніка. ");
INSERT INTO rmczrb_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Важ ода ґодяверіпе Девлескєро і пгендя: «Бічавава Ме ленґє ле пророкен те ле апостолен, єкгє лендар мурдарена, а дуйтонен лендар традкєрена». ");
INSERT INTO rmczrb_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Важ ода дадівесескєре родостар пгучелапес важо рат саворе пророкенґєро, саво есас чьордо отканастар сотворіме есас о светос, ");
INSERT INTO rmczrb_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ле Авельоскєре ратестар джі ко Захаріяскєро рат, саво есас мурдардо машкар о алтаріс те о храмос. Га, пгенав туменґє, адале родостар пгучелапес важ саворо. ");
INSERT INTO rmczrb_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Біда туменґє, Законоскєре танітова! Тумен заілян е клєя ґодяверіпнастар; та коркоре на заґейлян, а те одаленґє, ко заджялас, на динян. ");
INSERT INTO rmczrb_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Кана Ісус авля аврі андал о кгєр, танітова Законоскєре а те о фарісєї кєздинде те худенпес кє Лесте і бут со пгучкєренас Лестар. ");
INSERT INTO rmczrb_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Оне камле те худен Лес про лав. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Андре оди овра іскіндепес іґєн бут нийпос авка, гой кікіденас єкг аврес. Ісус кєздиндя те вакєрен єкгвар ко Пескєре сікаде: — Меркіненпес фарісєйсько закваскатар, саві гіні буджяндіпе. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Нане ніч ґарудо, со паліш те на увлягас пгутердо, ані нане ніч, со човрал пес кєрел, гой паліш те на пгутерелпес аврі. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ода, со тумен вакєрен андре цма, шунена про шветлос, а со ціхонес пгендян андре андруні соба, ейла розвакєрдо пало кгєрескєре пади. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Пгенав туменґє, Мійре баратенґє: на даран одалендар, ко мурдарел тєлос, і бутер ніч на бійрінел те кєрен. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ме пгенава туменґє, Кастар те даран: даран Одалестар, кє Касте гін влада те мурдарен і те чівен андре ґєєна. Га, пгенав туменґє, Лестар даран. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Чі на панч цікне чірікле бікєнен важо дуй цікне копейкі? Та ані єкг лендар нане бістердо ле Девлега. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","А кє туменде те о бала про шейро гіне прееґєнде! На даран, бо тумен кучедер ле буте чіріклендар. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Пгенав туменґє: саконес, ко пгутердонес прінджярел Ман анґлал о мануша, одалес те о Ча ле Манушенґєро прінджярела анґлал анґєла ле Девлескєре, ");
INSERT INTO rmczrb_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","а ко отпгенелапес Мандар анґлал о мануша, одалестар те Ме отпгенавапес анґлал анґєла ле Девлескєре. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Саконескє, ко пгенела хоч єкг лав налачо про Ча ле Манушенґєро, одмукєлапес. А одалескє, ко вакєрела джюнґіпе про Свентно Духос, одалескє на одмукєлапес. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Кана анена тумен про судос андре сінаґоґі, ко пгуредера те ко владара, на думінен пало ода, сар туменґє кампел те заачен важ песте або со туменґє те вакєрен. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Свентно Духос андре оди овра сікавела тумен, со кампел те вакєрен. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Вареко ле нийпостар пгендя Лескє: — Танітов, пген мійре пгралескє, гой ов те розулавел манца ода, со мукляпес аменґє амаре дадестар. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Та Ов лескє отпгендя: — Манушея, ко Ман тгодя, гой Ме те авав судзас туменґє або те розулавав варесо машкар туменде? ");
INSERT INTO rmczrb_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","І Ов пгендя ленґє: — Дикгєн, гой тумен те на авен бокгмарде. Сар те на увлягас барвало о мануш, лескєро джівіпе одалестар нане завісімо. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ов розвакєрдя ленґє єкг вакєрібе: — Ко єкг барвало мануш есас баро увліпен пре маля. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ов думінелас андре песте: «Со манґє те кєрен? Нане ман, кай те іскідав саворо увліпе». ");
INSERT INTO rmczrb_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","І пгендя: «Кєрава авка: пгаґєрава мійре шопі і кєрава баредер, і акор іскідава одя мійро саворо дів і саворо мійро барваліпе. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Акор пгенава пескє: \"Джівіпе мійро, канакє кє туте бут барваліпе про бут берша! Кгіню, ха, пій і радисалю!\"» ");
INSERT INTO rmczrb_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Та о Дейл лескє пгендя: «Ту наґодявер! Дадіве раті залена тутар тийро джівіпе. Акор каскє ачела саворо, со ту кійсітиндял?» ");
INSERT INTO rmczrb_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Авка ейла саконега, ко іскідел барваліпе прекал песте, а на барвальол пріґ о Дейл. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Паліш пгендя Ісус Пескєре сікаденґє: — Важ ода пгенав туменґє: на даран пал тумаро джівіпе, со туменґє те хан, ані пал пескєро тєлос, андре состе туменґє пес те кіден. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Джівіпе кучедер ле хавібнастар, і тєлос важнедер голмендар. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Дикгєн про човкі: оне на шіїнен ані на іскіден; нане лен коморі ані о шопі, та о Дейл дел лен те хан. Та тумен кучедер одале чіріклендар! ");
INSERT INTO rmczrb_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ко тумендар, сар те на пережівінел, бійрінел те доден ко пескєро джівіпе хоча єкг оврі? ");
INSERT INTO rmczrb_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Те тумен на бійрінен минґ када те кєрен, акор, со тумен думінен пало авер? ");
INSERT INTO rmczrb_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Дикгєн про лілії, сар оне барон: оне бувті на кєрен, ані на сівен. Та пгенав туменґє, со минґ о Соломон андре саворі пескєрі слава на кіделаспес авка, сар єкг лендар. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Те о Дейл авка кідел е чар пре маля, саві дадіве гіні, а тайса ла чівена андре яґ, та чі на кідела Ов те тумен, фріма патябнаскєре? ");
INSERT INTO rmczrb_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","На думінен пало ода, со туменґє те хан, со те пієн, на пережівінен пало ода. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Бо када саворо роден нийпа светоскєре, а тумаро Дад джянел, со тумен нуждиненпес андро ода. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Єкг федер роден Лескєро Краліпе, і ода саворо доделапес минґ туменґє. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","На дара, цікно стадос! Бо тумаро Дад коркоро камля те ден туменґє Краліпе! ");
INSERT INTO rmczrb_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Бікєнен тумаро барваліпе і розден ле чоренґє. Кєрен пескє айсе тарці, саве на гординенпес тейле, барваліпе саво на фрімісальол, одя, кай о човрашіс кє ленде на подджял, а о кірме на хана лен опре. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Бо одя, кай тумаро гіно барваліпе, одя ейла те тумаро їло. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Авен міндик кійсітиме: голмі про дерекос препганле, і тумаре лампі мі лабон. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Авен сар мануша, саве ужарен ле хулай, кана авела пало біяв, і кана авела і дуркінела, акор єкгваресте лескє пгутерена. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Бахтале одала совґі, каскєро хулай, кана вісальола, аракгєла лен, со оне на совен. Чачібе пгенав туменґє, ов коркоро препгандела дерекос і сікавела ленґє тган пажо скамін і кєздинела ленґє те совґалінен. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Бахтале одала, ко на совела акор, кана ов авела про єпаш рат, чі анґлал ода, сар дівісальол. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Джянен, гой те джянлялас о хулай ле кгєрескєро, андре саві овра авела човрашіс, ов на домуклялас лескє те заджян андро пескєро кгєр. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Те тумен маїнен тейн кійсітиме, бо о Ча ле Манушенґєро авела андре айсі овра, кана тумен на ужарена пре Лесте. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Акор пгучля Лестар о Петро: — Раєя! Ту вакєрес када вакєрібе чак аменґє вай саворенґє? ");
INSERT INTO rmczrb_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Рай лескє отпгендя: — Акор ко ейла патівало і ґодявер управітеліс, савес о хулай тгодя про саворе авер совґі, гой кана авела овра те роздел ленґє о маро? ");
INSERT INTO rmczrb_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Бахтало ода совґас, савес лескєро хулай, кана авела, аракгєла, со кєрел авка. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Чачібе пгенав туменґє, со ов допатяла лескє саворо пескєро хулаїпе. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Та те ода совґас пгенела андро пескєро їло: «На сіґ авела мійро хулай», — і кєздинела те марен ле совґен те ле совґалкінєн, те хан, те пієн і те мулатинен, ");
INSERT INTO rmczrb_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","авела лескєро хулай андро ода дівес, кана ов на ужарел, а те андре оди овра, кана ов на джянел. Акор чінґєрела лес про єпаш і опреділінела лескє тган біпатябнаскєренца. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ода совґас, саво джянелас хулаєскєрі воля і на есас кійсітиме, і на кєрелас ода, со камелас хулай, мардьола іґєн бут. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","А ода, саво на джянел, а кєрел айсо, со засовґалінел, гой лес те покарінен, ейла мардо фрімедер. Одалескє, каскє есас дино бутередер, одалестар бутередер пгучена. І каскє есас бут допатянло, кадалестар бутередер те пгучена. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ме авльом яґ те анен пре пгув, і сар Ме камльомас, гой ов іма те розлабол! ");
INSERT INTO rmczrb_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Та Манґє минґ кампел те преджян болавіпе; і сар Манґє пгарес, адик ода на ачела! ");
INSERT INTO rmczrb_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Тумен думінен, со Ме авльом те анен мірос пре пгув? Наа, пгенав туменґє, на мірос, но розулавіпе. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Чаладос панч манушендар розулавелапес, трінджяне некі дуєджяненґє, дувджяне некі трінджяненґє. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Розулавелапес о дад ле чага і о ча ле дадега; а е дай — ле чайорага, а е чай — ле даяга; сасуй — боврага, а е боврі — ле сасага. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ісус пгендя те ле нийпоскє: — Кана тумен дикгєн, со вазделпес хмара западостар, тумен єкгваресте пгенен: «Ейла брішинд», — і чачес, перел брішинд. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","А кана пгурдел барвал югостар, тумен пгенен: «Ейла іґєн татес», — і ачел авка. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Буджянде! Ода, со ачел пре пгув а те про нєбос, тумен прінджярен, акор соске тумен на джянен, сар те прінджярен оди оврі? ");
INSERT INTO rmczrb_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Соске тумен коркоре на розсудзінен, андре состе чачібе? ");
INSERT INTO rmczrb_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Кана ту джяс тийре врагога ко начальнікос, постарінтут те пріміріненпес лега, адик сал лега минґ про дром, а те на, та акор ов анела тут ко судзас, а о судзас отдела тут сторожіскє, а ода чівела тут андре тюрма. ");
INSERT INTO rmczrb_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Пгенав тукє: на авега одарік аврі, адик на отдега лескє саворо джі кє єкг копейка. ");
INSERT INTO rmczrb_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Андре оди овра авле варесаве мануша і розвакєрде Лескє пало галілєянє, савен Пілат диня преказіс лен те мурдарен, кана оне аненас е жертва. ");
INSERT INTO rmczrb_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Пре када Ісус ленґє пгендя: — Тумен думінен, гой кадала галілєянє есас єкг бійношнедер саворендар андре Галілєя, со авка пострадинде? ");
INSERT INTO rmczrb_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Пгенав туменґє: Наа! Та те на покаїненапес, акор те тумен авка саворе мерена. ");
INSERT INTO rmczrb_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","А адала дешуохто мануша, пре саве пейля башня андро Сілоам і мурдардя лен? Чі тумен думінен, со оне санас єкг бійношнедер андро Єрусалім? ");
INSERT INTO rmczrb_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Пгенав туменґє: Наа! Та те на покаїненапес, акор те тумен саворе авка мерена. ");
INSERT INTO rmczrb_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Паліш розвакєрдя ленґє єкг вакєрібе: — Ко єкг мануш андро дракгєнґєро садос баролас єкг інжіріко дубос. Єкгвар ов ґейля те роден, чі нане пре лесте плодос, та ніч на аракгля. ");
INSERT INTO rmczrb_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Акор ов пгендя ле дракгаріскє: «Іма тріто берш ме авав аде, гой те аракгєн плодос пре када інжіріко дубос, та на аракгав. Чінґєр лес тейле, соске ов захудел е пгув?» ");
INSERT INTO rmczrb_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Та ов отпгендя Лескє: «Хулай, мук лес минґ пре єкг берш. Ме обкопалінава лес і обтговава ле гнойога. ");
INSERT INTO rmczrb_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Те про авер берш анела о плодос, акор міште. А те на анела, акор ту чінґєрега лес тейле». ");
INSERT INTO rmczrb_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Сомбатоне Ісус сікавелас андре єкг сінаґоґа. ");
INSERT INTO rmczrb_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Одя есас ромні, андре саві есас духос насвалкєрдо, ой есас ізбандярді і на бійрінелас те ровняренпес аврі дешуохто берш. ");
INSERT INTO rmczrb_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Сар дикгля ла о Ісус, вічіндя ла і пгендя лакє: — Ромніє! Ту сал свободно тийре насвалібнастар! ");
INSERT INTO rmczrb_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ов тгодя пре лате о васта, і ой єкгваресте ровнярдяпес аврі і ачіля те ашарен ле Девлес. ");
INSERT INTO rmczrb_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Та пгуредерес пре сінаґоґа іґєн розхолярдя ода, со Ісус сасардя сомбатоне, і ов пгендя ле нийпоскє: — Гін шов дівес, андре саве шай те кєрен. Андре адала дівеса авен і сасаренпес, а на сомбатоне. ");
INSERT INTO rmczrb_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Про ода Рай лескє отпгендя: — Буджянде! Чі на отпганден тумен сомбатоне андал о хлівос пескєре ґурувес чі ле сомаріс і на ліджян лес те поїнен? ");
INSERT INTO rmczrb_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ой гіні ле Авраамоскєрі чай, сава о сатана лікєрелас іспганля іма дешуохто берш. Чі на кампіля лакє те пгутерен ланці андре сомбатоскєро дівес? ");
INSERT INTO rmczrb_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Кана Ов пгендя када, саворенґє, ко джялас протів Лесте, ачілепес те ладжян, а саворо нийпос радисальолас славне бувтякє, со Ов кєрелас. ");
INSERT INTO rmczrb_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Паліш Ов пгендя: — Пре состе пес марел Краліпе ле Девлескєро? Сога шай лес те зровнярен? ");
INSERT INTO rmczrb_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ов сар горчічно дів, саво іля о мануш і шіїндя андро пескєро садос. Дів баріля, і кєрділяпес лестар о дубос, і о чірікле нєбоскєре ачіле те джівен андре лескєре конаркі. ");
INSERT INTO rmczrb_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ов минґ пгендя: — Пре состе пес марел Краліпе ле Девлескєро? ");
INSERT INTO rmczrb_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ода сар дрожі, саве іля е ромні і дювріндя хумер андре трін баре чаре, гой саворо те барол опре. ");
INSERT INTO rmczrb_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Сар лікєрелас дром андро Єрусалім, Ісус преджялас пало фоврі те пало ґава і сікавелас ле нийпос. ");
INSERT INTO rmczrb_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Вареко Лескє пгендя: — Раєя, со, чак набутджяне ейна ратиме? Ов ленґє пгендя: ");
INSERT INTO rmczrb_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","— Старіненпес те заавен пріґ узкі капура. Пгенав туменґє: бутджяне пробалінена те заджян, та на бійрінена. ");
INSERT INTO rmczrb_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Кана о хулай ле кгєрескєро ушела і запгандела о вудар, акор тумен тердьона аврунестар, дуркінена андро вудар і вакєрена: «Раєя! Пгутер аменґє!» Акор Ов туменґє пгенела: «На джянав тумен, катар сан». ");
INSERT INTO rmczrb_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Акор тумен пгенена: «Амен хагас те піягас анґлал Туте, і Ту сікавегас амен пре амаре уці». ");
INSERT INTO rmczrb_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Та Ов отпгенела: «Ме на джянав тумен, катар сан. Отджян Мандар саворе, ко кєрел подліпе!» ");
INSERT INTO rmczrb_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Одя ейла ровібе і рандена ле данденца, кана тумен дикгєна ле Авраам, ле Ісаак, ле Яковс те саворен пророкен андро Краліпе ле Девлескєро, а коркоре тумен ейна транле аврі. ");
INSERT INTO rmczrb_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Авена мануша пало восток і запад, і пало север і юг, і акор бешена про біяв андро Краліпе ле Девлескєро. ");
INSERT INTO rmczrb_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","І палуне ейна перше, а перше ейна палуне. ");
INSERT INTO rmczrb_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Акор ко Ісус подавле варесаве фарісєї і пгенде: — Джя адарік, бо Ірод камел Тут те мурдарен. ");
INSERT INTO rmczrb_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ісус отпгендя ленґє: — Джян і пгенен одала ліскакє: «Дадіве і тайса ме традав ле дємонен і сасарав ле манушен, а про тріто дівес Ме докєрава Мійрі бувті». ");
INSERT INTO rmczrb_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Дадіве, тайса і палтайсаскєро Ме маїнав те джян дуредер, важ ода кай пророкос наший мерел на андро Єрусалім. ");
INSERT INTO rmczrb_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Єрусалім, Єрусалім! Ту мурдарес ле пророкен і ле баренца марес бічаден кє туте! Кєцівар Ме камльом те іскіден тийре чаворен авка, сар чірікло іскідел пескєре чіріклорен толо пескєре кридлі, та тумен на закамлян! ");
INSERT INTO rmczrb_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Канакє тумаро кгєр ачелпес туменґє чувчо! Пгенав туменґє, со тумен Ман бутер на дикгєна, адик на пгенена: «Ашаріпе Одалескє, Ко авел андро Раєскєро нав!» ");
INSERT INTO rmczrb_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Єкгвар сомбатоне ачіля авка, гой Ісус заавля андро кгєр ко єкг баредер фарісєй про дийлос, а оне дикгєнас пал Лесте. ");
INSERT INTO rmczrb_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Анґлал Ісус бешелас о мануш, насвало про панєскєро насвалібе. ");
INSERT INTO rmczrb_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Акор Ісус пгучля ле танітовен Законоскєрен те ле фарісєєн: — Чі шай те сасарен сомбатоне, вай наа? ");
INSERT INTO rmczrb_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Оне ціхісаліле. Акор Ісус хундяпес ко мануш, сасардя лес і одмукля лес. ");
INSERT INTO rmczrb_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Паліш Ов ленґє пгендя: — Те кє варекасте тумендар о чаворо чі ґурув перела андре ханік, чі тумен на цірдена лес аврі єкгваресте, те ода ейла сомбат? ");
INSERT INTO rmczrb_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Оне ніч на бійрінде пре када те отпгенен. ");
INSERT INTO rmczrb_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Акор Ісус кєздиндя те вакєрен о вакєрібе ко ізвічіме мануша, бо дикгля, сар сако пескє роделас анґлуне тгана. Ов пгендя ленґє: ");
INSERT INTO rmczrb_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","— Кана тут вареко вічінела про біяв, на беш про першо тган, бо шай ачел авка, гой машкар вічіме гіно вареко, ко патіваледер, сар ту. ");
INSERT INTO rmczrb_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","І акор о хулай, саво вічіндя тут те лес, подавела кє туте і пгенела: «Одмук о тган кадале манушескє». І тукє кампела андре ладж те захуден єкг палуно тган. ");
INSERT INTO rmczrb_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Важ ода, кана тут вічінен, джя, беш тукє палал, гой о хулай мі подавел і те пгенел тукє: «Баратона, преджя про федер тган». Акор ейла тукє сікадо баро патів анґлал саворе гості. ");
INSERT INTO rmczrb_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Бо сако єкг, ко вазделпес опре, дикгєна лес тейле, а ко дикгєлапес тейле, ода ейла ваздно опре. ");
INSERT INTO rmczrb_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","І акор Ісус пгендя ле хулаєскє: — Кана кєрес о дийлос чі раті, на вічін пескєре баратен, ле пгрален, ані пескєро файтос, ані ле барвале сомсійден, важ ода гой оне паліш тут те на вічінен і авка туга те на потіненпес аврі. ");
INSERT INTO rmczrb_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Кана ту кєрега гостіна, вічін пре лесте ле чорен, калікєн, банґєн, ле корен. ");
INSERT INTO rmczrb_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Акор ту ейга бахтало, бо оне на бійрінен те вісарен тукє, і ту худега награда, кана чачібнаскєре джівдісальона. ");
INSERT INTO rmczrb_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Кана єкг одалендар, саве ханас о дийлос, шундя када, ов пгендя ле Ісусоскє: — Бахтало ода, ко хала о маро андро Краліпе ле Девлескєро! ");
INSERT INTO rmczrb_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ісус лескє пгендя: — Єкг мануш кєрдя барі гостіна і вічіндя бутджянен. ");
INSERT INTO rmczrb_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Кана авля овра, гой те бешен пажо скамін, ов бічадя пескєре совґас ко вічіме те пгенен: «Авен, бо іма саворо кійсно». ");
INSERT INTO rmczrb_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Акор саворе сар єкг кєздинде те отпгененпес. Першо лескє пгендя: «Ме ціндьом е малі, і манґє кампел те джян те дикгєн ла. Манґав тут, пребачін манґє». ");
INSERT INTO rmczrb_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Дуйто пгендя: «Ме ціндьом панч парі ґурува і канакє джяв те пробалінен лен аврі. Манґав тут, пребачін манґє». ");
INSERT INTO rmczrb_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Тріто пгендя: «Ме ільом манґє ромня і важ ода на бійрінав те авен». ");
INSERT INTO rmczrb_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","О совґас вісаліля і розвакєрдя саворо пескєре хулаєскє. Акор о хулай ле кгєрескєро холісаліля і пгендя ле совґаскє: «Джя сіґєредер пало баре те пало цікне уці і ан аде ле чорен, ле калікєн, ле корен те банґєн». ");
INSERT INTO rmczrb_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","І пгендя о совґас: «Хулай, саворо кєрдьом авка, сар ту манґє пгендял, та гін минґ аде о тгана». ");
INSERT INTO rmczrb_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Акор пгендя о хулай ле совґаскє: «Джя пало дрома те пало саворе аґора фовроскєре і преманґ саворен, те авен пре гостіна, гой мієл пгердо мійро кгєр. ");
INSERT INTO rmczrb_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Пгенав туменґє, гой одале манушендар, савен ме вічінавас анґлал ада, ніко на хала манца о дийлос». ");
INSERT INTO rmczrb_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ле Ісусога джянас бут мануша, і Ов вісаліля кє ленде і пгендя: ");
INSERT INTO rmczrb_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","— Те вареко авел кє Манде, но камел пескєре дадес, да, ле ромня, ле чавен, ле пгрален, ле пгєнєн, а минґ пескєро джівіпе бутер, сар Ман, ода наший ейл Мійро сікадо. ");
INSERT INTO rmczrb_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ода, ко на ліджял пескєро кєрестос і на авел пал Манде, наший ейл Мійро сікадо. ");
INSERT INTO rmczrb_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Представінен туменґє, со вареко тумендар камел те строїнен е башня. Чі на бешела ов анґлал і на подиґєнела, кєці лестар джяна о лове, чі гін лес айці, гой те доліджян ко аґор оди бувті? ");
INSERT INTO rmczrb_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Бо сар ов тговела фундаментос, а дуредер на бійрінела те докєрен стройка ко аґор, акор саворе, ко дикгєла ода, асана лес аврі. ");
INSERT INTO rmczrb_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","І пгенена: «Хундял те строїнен, а те доліджян ко аґор на бійрінел». ");
INSERT INTO rmczrb_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Саво краліс, кана джял про марібе про авер краліс, на бешела анґлал, гой те обвакєрен, чі шай джял ов деш езеренца про ода, саво джял пре лесте біше езеренца? ");
INSERT INTO rmczrb_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Те наший джял, та кана ода минґ дур, бічавел пескєре манушен те манґєн пало мірос. ");
INSERT INTO rmczrb_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Авка те ода ко тумендар на отпгенелапес саворестар, со лес гін, наший ейл Мійро сікадо. ");
INSERT INTO rmczrb_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Лон гіно лачо, но кана лон нашавел пескєро лондіпе, акор, со шай тє кєрен ле лондіпнага? ");
INSERT INTO rmczrb_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ой нане валовшно ані андре пгув, ані андре гнойоскєрі копа, а чак те чівен ла аврі. Кас гін кгана те шунен, мі шунел! ");
INSERT INTO rmczrb_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ле Ісус авенас те шунен саворе, ко іскіделас налогі, те авер бійношне мануша. ");
INSERT INTO rmczrb_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","А фарісєї те танітова Законоскєре дудріненас і вакєренас: — Ов прелел бійношне манушен і хал андре єкг ленца. ");
INSERT INTO rmczrb_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Акор Ов розвакєрдя ленґє єкг вакєрібе: ");
INSERT INTO rmczrb_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","— Пгенага авка, со кана кє туменде гін шел бакре і єкг лендар нашадяпес. Чі на мукєла ов ейнявардеш те ейня андре пустиня і чі на джяла те роден ола, саві пес нашадя, джі акор, адик на аракгєла? ");
INSERT INTO rmczrb_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Кана ов аракгєла ла, акор ле радишаґога лела ла про пескєре пійкє. ");
INSERT INTO rmczrb_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","І кана авела кгєйре, вічінела пескєрен баратен те сомсійден і пгенела ленґє: «Радисальон манца, бо ме аракгльом мійре нашаде бакрес!» ");
INSERT INTO rmczrb_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Пгенав туменґє, со про нєбос ейла бутер радишаґос важо єкг бійношно мануш, саво пес каїнел, сар важо ейнявардеш те ейня чачібнаскєре, саве на нуждиненпес андро покаяніє. ");
INSERT INTO rmczrb_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Те кє ромні гін деш драхмі, і ой нашавела єкг лендар, чі на залабарела лампа, чі на шулавела аврі саворо кгєр, чі на родела, адик на аракгєла ла? ");
INSERT INTO rmczrb_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","А сар аракгєла ла, вічінела пескєре камараткен те ле сомсійден і пгенела: «Радисальон манца, бо ме аракгльом драхма, саві ме нашадьом!» ");
INSERT INTO rmczrb_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Канакє Ме пгенав туменґє, со Девлескєре анґєла радисальон важо сако єкг бійношно мануш, саво пес каїнел. ");
INSERT INTO rmczrb_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ісус дуредер вакєрелас: — Ко єкг мануш есас дуй мурша. ");
INSERT INTO rmczrb_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Тернедер пгендя ле дадескє: «Даде, де манґє мійро котор барваліпнастар, саво ейла мійро». Акор о дад розуладя машкар ленде о хулаїпе. ");
INSERT INTO rmczrb_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Пріґ варесаве дівеса тернедер чаворо іскіндяпес і ґейля дур пре авер пгув. Одя ов розкєрдя саворо пескєро барваліпе, авка сар ліджялас тровґеріко джівіпе. ");
INSERT INTO rmczrb_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Кана кє лесте іма на ачіляпес ніч, пре оди пгув кєздиндяпес барі бокг, і ов ачіля андро баро чоріпе. ");
INSERT INTO rmczrb_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Акор ов ґейля і манґляпес пре бувті ко єкг мануш, саво джівелас пре оди пгув, а ов бічадя лес пре пескєре маля те додикгєн пало бале. ");
INSERT INTO rmczrb_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ов авка бокгальолас, кай радо есас те пгердярен пескєрі дьомра ле ціпенца, саве денас ле баленґє, та лескє минґ те ода на денас. ");
INSERT INTO rmczrb_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Кана ахаліля, со кєрдя, пгендя: «Кєці гін бувтякєре андро кгєр ко мійро дад, і кє ленде те хан пгердо, а ме аде мерав ле бокгатар! ");
INSERT INTO rmczrb_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ушава, джява манґє ко мійро дад і пгенава лескє: \"Даде! Кєрдьом бійнос анґлал о нєбос те анґлал туте. ");
INSERT INTO rmczrb_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ме бутер на сом достойно те вічіненпес тийре чаворега. Ліджяпес манца авка, сар єкгєга пескєре совґендар\"». ");
INSERT INTO rmczrb_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ов ушіля і ґейля ко пескєро дад. Кана ов есас минґ дур, дад дикгля і іґєн фес посаїндя ле чаворес. Ов подденашля кє лесте, обхундя і кєздиндя те чумідкєрен лес. ");
INSERT INTO rmczrb_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","О ча лескє пгендя: «Даде! Кєрдьом бійнос анґлал о нєбос те анґлал туте. Ме бутер на сом достойно те вічіненпес тийре чаворега». ");
INSERT INTO rmczrb_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Та о дад пгендя пескєре совґенґє: «Джян сіґєредер, анен єкг федер голмі і кіден лес. Тговен анґрушні про лескєро анґушто і урен лес андро камашлі. ");
INSERT INTO rmczrb_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Анен годовіме целятос, дочінен лес. Канакє хага те радисалювага! ");
INSERT INTO rmczrb_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Бо када мійро чаворо есас мувло, а канакє джівдо, нашліля, а канакє аракгляпес!» І оне кєздинде те радисальон. ");
INSERT INTO rmczrb_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","А пгуредер ча есас акор пре маля. Кана ов подавля пашедер ко кгєр, шундя ґіля те о кгелібе. ");
INSERT INTO rmczrb_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ов вічіндя єкгєс совґас і пгучля лестар: «Со пес аде обачіля?» ");
INSERT INTO rmczrb_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ов лескє пгендя: «Тийро пграл авля, і тийро дад дочіндя годовіме целятос, бо лескєро ча вісаліля джівдо те здраво». ");
INSERT INTO rmczrb_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Та пгуредер ча холісаліля і на камелас те заджян андро кгєр. Акор о дад авля аврі і преманґєлас лес. ");
INSERT INTO rmczrb_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Та ов отпгендя пескєре дадескє: «Ме айці берш кєравас пре туте, сар совґас, і міндик кєравас ода, со ту манґє пгенегас. Ту ніґда на динял манґє минґ козльонкос, гой ме те радисалював ле баратенца. ");
INSERT INTO rmczrb_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","А сар вісаліля акада тийро чаворо, саво прехаля саворо тийро барваліпе ле лубнєнца, ту дочіндял прекал лесте годовіме аврі целятос!» ");
INSERT INTO rmczrb_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Та о дад лескє пгендя: «Чаворея, ту сал міндик манца, і саворо, со гін кє манде, ода саворо тийро. ");
INSERT INTO rmczrb_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Амен маїнас те кгєлен і те радисальон, бо тийро пграл есас мувло, а канакє джівдо, есас нашадо, а канакє аракгляпес!» ");
INSERT INTO rmczrb_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ісус пгендя Пескєре сікаденґє: — Есас єкг барвало мануш. Кє лесте есас єкг бувтяріс, саво ліджялас бувті андро лескєро хулаїпе. Єкгвар лес обвінінде, со ов розкєрел хулаїпе пескєре хулаєс. ");
INSERT INTO rmczrb_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Акор ода хулай вічіндя лес і пгендя лескє: «Со када ме шунав пал туте? Ізде пескєрі бувті. Ту іма на дикгєга пал мійро хулаїпе». ");
INSERT INTO rmczrb_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ода бувтяріс подуміндя: «Со канакє манґє те кєрен? О хулай чівел ман тейле пале бувті. Те джян, те ваїнен нане ман зор, а те манґавкєрен ладжявман. ");
INSERT INTO rmczrb_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Канакє джянав, со кампел те кєрен, гой вареко мі лел ман кє песте андро кгєр, кана ачава бі е бувті». ");
INSERT INTO rmczrb_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Акор ов кєздиндя те вічінкєрен саконе єкгєс, ко ачіля те камен лескєре хулаєскє. Ов пгучля першонестар: «Кєці ту камес мійре хулаєскє?» ");
INSERT INTO rmczrb_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ода отпгендя: «Шел гордова олівково олєйос». Бувтяріс пгендя лескє: «Ле тийрі розпіска, і сіґєредер беш і пісін пенда». ");
INSERT INTO rmczrb_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Паліш пгендя те дуйтонескє: «А ту кєці камес?» Када отпгендя: «Езерос ґовне дів». Те лескє пгендя: «Ле тийрі розпіска, а пісін охтошел». ");
INSERT INTO rmczrb_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","І хундя хулай те ашарен біпатівакєре бувтяріс, важ ода кай ов авка ґодяверонес кєрдя. Кале векоскєре чаве федер пес ахальон, сар те ліджянпес ле манушенца, сар о чаве ле шветлоскєре. ");
INSERT INTO rmczrb_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ме туменґє пгенав, аракгєн пескє ле баратен нажувже барваліпнага, гой, кана лес на ейла, мі прелен тумен андро вечне кгєра. ");
INSERT INTO rmczrb_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ко патівало андро цікно, ода патівало те андро баро, а ко напатівало андро цікно, ода напатівало те андро баро. ");
INSERT INTO rmczrb_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Те тумен андро нажувжо барваліпе на санас патівале, акор ко туменґє допатяла чачуно? ");
INSERT INTO rmczrb_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Те тумен на санас патівале андро цузо, акор ко дела туменґє тумаро? ");
INSERT INTO rmczrb_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Нісаво совґас наший совґалінел дує хулаєнґє. Ов єкгєс кєздинела те мержінен, а дуйтонес камела, або єкгєга ліджялапес патівалонес, а дуйтонес дикгєла тейле. Тумен наший совґалінен те ле Девлескє, те ле барваліпнаскє. ");
INSERT INTO rmczrb_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Фарісєї, саве каменас о лове, шуненас саворо ода і асанас ле Ісусостар. ");
INSERT INTO rmczrb_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","А Ісус ленґє пгендя: — Тумен тговенпес аврі анґлал о мануша, со тумен сан чачібнаскє, та о Дейл джянел тумаре їле. Ода, со мануша цінінен, джюнґіпе андро Девлескєре якга. ");
INSERT INTO rmczrb_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Законос те о пророка есас джі ко Іоанн, а акадала овратар вакєрелпес Радишаґоскєро Гійрос пало Краліпе ле Девлескєро, і сако дотговел пескєрі зор, гой те заджян андре лесте. ");
INSERT INTO rmczrb_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Сіґєредер о нєбос те е пгув проперена, сар кана хоч єкг чорточка нашльола андало Законос! ");
INSERT INTO rmczrb_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Сако єкг, ко мукєл пескєра ромня, а паліш лел пескє авра ромня, кєрел лубіпен. І сако єкг, ко лел пескє ромня, саві розґейляпес пескєре ромега, кєрел лубіпен. ");
INSERT INTO rmczrb_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Есас єкг барвало мануш. Ов кіделаспес андре єкг кучедер і андро єкг раїканедер голмі і сако дівес іґєн мулатинелас. ");
INSERT INTO rmczrb_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Одя есас єкг чоро мануш про нав Лазар, саво пашльолас паж лескєрі капура, а ле насвалібнастар на есас жувжо тєлос пре лесте. ");
INSERT INTO rmczrb_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ов іґєн камелас те чальон ле которенца пало скамін, кай бешелас барвало. Руконе авенас і чаркєренас лескє рані. ");
INSERT INTO rmczrb_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ачіляпес, со мувля чоро мануш, і одліґєнде лес о анґєла пашес ко Авраам. Мувля те о барвало, те лес парунде. ");
INSERT INTO rmczrb_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Кана барвало есас андро адос, андре барі дукг, ов ваздня пескєре якга і дуралестар дикгля ле Авраам, а паж лесте те ле Лазар. ");
INSERT INTO rmczrb_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ов завріскіндя і манґляпес: «Даде Авраам! Посаїн ман і бічав ле Лазар, мі ціндярел пескєро анґушто андро пані, гой те шілісальол манґє е чіб, бо ме аде мучінавпес андре аді яґ». ");
INSERT INTO rmczrb_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Та Авраам отпгендя: «Чаворея! Лепер, ту іма хундял са лачо андро тийро джівіпе, а Лазар дикгля єкг подліпе. Канакє ов аде радисальол, а ту семвединес. ");
INSERT INTO rmczrb_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Та те авка машкар аменде гіні барі ховр, і важ ода, ко камел те преджян адарік кє туменде, на бійрінел, а те одарік кє аменде на авен». ");
INSERT INTO rmczrb_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Барвало пгендя: «Акор ме тут іґєн манґав, дадорея, бічав ле Лазар ко мійро дадескєро кгєр, ");
INSERT INTO rmczrb_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","бо кє манде минґ гін панч пграла. Мі джял, мі пгенел ленґє анґлал, гой те оне те на поперен андре ада мучішаґоскєро тган». ");
INSERT INTO rmczrb_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Авраам лескє отпгендя: «Кє ленде гін Моїсєй те о пророка, лен мі шунен». ");
INSERT INTO rmczrb_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Та ов лескє пгендя: «Наа, даде Авраам, те вареко ле мувлендар авела кє ленде, покаїненапес». ");
INSERT INTO rmczrb_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Про ода Авраам лескє отпгендя: «Те оне ле Моїсєй те ле пророкен на шунен, та хоч ушілялас вареко опре ле мувлендар, оне те авка на патяна». ");
INSERT INTO rmczrb_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ісус пгендя ко пескєре сікаде: — Андро светос міндик ейла ода, со ле манушен цірдел ко бійнос, та біда одалескє, прекал касте ода авел. ");
INSERT INTO rmczrb_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Федер увлягас, гой лескє те фійґінен мельнічно бар андре мен і те чівен лес андро морьос, сар спокушінела хоча єкгєс кадале цікнендар. ");
INSERT INTO rmczrb_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Меркінен пал туменде. Те кєрела тийро пграл бійнос, повакєр лега, а те покаїнелапес, одмук лескє. ");
INSERT INTO rmczrb_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Минґ те ефтавар про дівес кєрела о бійнос протів туте і ефтавар про дівес манґєла тутар, гой те одмукєс лескє, і пгенела тукє: «Каїнав ман», — одмук лескє. ");
INSERT INTO rmczrb_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Апостоли пгенде ле Раєскє: — Барар андре аменде патябе! ");
INSERT INTO rmczrb_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Рай ленґє отпгендя: — Те кє туменде гін патябе андро горчічно дів і тумен пгенена ле тутовскєре дубоскє: «Цірде тут аврі ле коренєнца і садзін тут андро морьос», — акор ов шунела тумен. ");
INSERT INTO rmczrb_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Домукага, со кє туменде гін о совґас, саво оврінел або пасінел ле бакрен. Чі пгенена тумен лескє, кана ов вісальола пале маля: «Ав сіґєредер і беш пажо скамін»? ");
INSERT INTO rmczrb_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Сіґєредер пгенена лескє авка: «Кєр манґє варесо те хан пре раті, а паліш препганд дерекос і совґалін манґє, адик ме хава те піява, а паліш коркоро хага те пієга». ");
INSERT INTO rmczrb_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Чі палікєрел о хулай ле совґаскє важ ода, со ода кєрел, со лескє есас пгендо? ");
INSERT INTO rmczrb_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Авка те тумен, кана кєрен ода, со туменґє есас преказіме, пгенен: «Амен сам совґі, саве ніч на тердьон, амен кєрдям чак ода, со маїндям те кєрен». ");
INSERT INTO rmczrb_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Кана Ісус джялас андро Єрусалім, то преджялас машкар Самарія те Галілєя. ");
INSERT INTO rmczrb_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Кана Ов заджялас андро єкг баро ґав, одя Лес ужаренас деш прокажоне мануша. Оне тердьонас надур ");
INSERT INTO rmczrb_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","і фес вріскіненас: — Ісус, Танітов! Посаїн амен! ");
INSERT INTO rmczrb_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Кана Ісус лен дикгля, Ов ленґє пгендя: — Джян і сікавенпес ле рашаєнґє. Оне ґейле і пало дром ачіле жувже. ");
INSERT INTO rmczrb_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Єкг лендар, сар дикгля, со ов гіно сасардо, вісаліля і баре ганґога ашарелас ле Девлес. ");
INSERT INTO rmczrb_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ов пейля ко Ісусоскєре піндре і палікєрелас Лескє. Ода мануш есас самарянос. ");
INSERT INTO rmczrb_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ісус пгучля: — Чі на деш мануша пес жувжарде? Та кай гіне авер ейняджяне? ");
INSERT INTO rmczrb_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Хіба на аракгляпес ані єкг, ко вісалілялас, гой те ашарен ле Девлес, чак када єкг цузопгувакєро? ");
INSERT INTO rmczrb_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","І пгендя Ісус лескє: — Уші і джя, патябе тийро ратиндя тут. ");
INSERT INTO rmczrb_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Єкгвар фарісєї пгучле Лестар, кана авела Краліпе ле Девлескєро. Ов отпгендя ленґє: — На авела Краліпе ле Девлескєро авка, со шай ейла лес те дикгєн. ");
INSERT INTO rmczrb_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ніко на ейла гонно те пгенен: «Акєс гіно», або: «Одя гіно». Бо Краліпе ле Девлескєро гіно машкар туменде. ");
INSERT INTO rmczrb_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Паліш пгендя Ов ле сікаденґє: — Авела айсі овра, кана тумен камена те дикгєн хоча бі єкг дівес ле Час Манушенґєрес, но на дикгєна. ");
INSERT INTO rmczrb_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Туменґє вакєрена: «Акєс гіно» або «Одя гіно», та тумен на денашен те дикгєн. ");
INSERT INTO rmczrb_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Бо, сар о перумос бліскінел пало єкг аґор нєбоскєро ко авер, авка ейла о Ча ле Манушенґєро андро дівес, кана Ов вісальола. ");
INSERT INTO rmczrb_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Та єкгвар Ов мушінел іґєн бут те семвединен, а паліш ейла отчідо кадале родога. ");
INSERT INTO rmczrb_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Сар есас андро Нойоскєре дівеса, авка ейла андро дівеса ле Час Манушенґєрес: ");
INSERT INTO rmczrb_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","мануша ханас, пієнас, ленас пескє ромня, джянас роместе джі ко ода дівес, сар о Ной заґейля андро ковчег. Акор авля баро пані і саворен мурдардя. ");
INSERT INTO rmczrb_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Авка есас те андро дівеса, кана джівелас о Лот: мануша ханас, пієнас, цінкєренас, бікєнкєренас, садзінкєренас і кєренас о кгєра. ");
INSERT INTO rmczrb_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Та андро дівес, кана Лот авля аврі андал Содом, акор кєздиндя те перен брішиндескєро яґ те сіра пало нєбос і саворен мурдардя. ");
INSERT INTO rmczrb_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Авка ейла те андро ода дівес, кана сікавелапес о Ча ле Манушенґєро. ");
INSERT INTO rmczrb_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Андро ода дівес, ко ейла про падос, а ренті лескєре андро кгєр, те на мукєлпес тейле пал ленде. І ко ейла пре маля, те на вісальол пале. ");
INSERT INTO rmczrb_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Паматинен Лотоскєра ромня! ");
INSERT INTO rmczrb_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Сако, ко камела те ратинен пескєрі вовді, ода нашавела ла, а ко нашавела пескєрі вовді, ода сохранінела ла. ");
INSERT INTO rmczrb_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Пгенав туменґє: андре оди раті дуйджяне ейна про єкг тган, єкгєс залена, а дуйтонес мукєна. ");
INSERT INTO rmczrb_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Дуй ромня андре єкг ірнінена е дів, та єкга залена, а дуйтона мукєна. ");
INSERT INTO rmczrb_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Сікаде пгучле Лестар: — Кай, Раєя? Ов ленґє пгендя: — Одя, кай трупос, одя ейна те орли. ");
INSERT INTO rmczrb_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Акор Ісус розвакєрдя ленґє єкг вакєрібе пал ода, со кампел міндик те модліненпес і те на мукєн тейле о васта: ");
INSERT INTO rmczrb_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","— Андро єкг фоврос есас судзас, саво Девлестар на даралас а ле манушендар на ладжялас. ");
INSERT INTO rmczrb_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Андро ода фоврос есас вдова, саві пгірелас кє лесте і вакєрелас: «Заач важ манде мійре врагостар». ");
INSERT INTO rmczrb_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ов буталік на камелас, а паліш пгендя коркоро андре песте: «Хоч ме ле Девлестар на дарав, а ле манушендар на ладжяв, ");
INSERT INTO rmczrb_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","та важ ода, кай кади вдова на дел манґє смійром, заачава важ лате, гой те преачел те пгірен кє манде, те мучінен ман». ");
INSERT INTO rmczrb_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","І пгендя о Рай: — Тумен шунен, со вакєрел када біпатівало судзас? ");
INSERT INTO rmczrb_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","А о Дейл? На заачела важ одала, кас Ов кіндя аврі, саве вічінен кє Лесте дівесе те ратяга? Чі Ов буталік ужарела? ");
INSERT INTO rmczrb_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Пгенав туменґє, со Ов сіґ заачела важ ленде. Та кана авела о Ча Манушенґєро, чі аракгєла патябе пре пгув? ");
INSERT INTO rmczrb_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Одаленґє, ко есас бійзошно андро пескєро чачібен і дикгєнас тейле саворен манушен, Ісус розвакєрдя айсо вакєрібе: ");
INSERT INTO rmczrb_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","— Дуй мануша авле андре храмос те модліненпес — єкг есас фарісєй, а дуйто ода, саво іскідел налогі. ");
INSERT INTO rmczrb_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Фарісєй тердьолас і модліндяпес важ песте авка: «Девла, палікєрав Тукє, кай ме на сом айсо, сар авер мануша: човраша, напатівале, одала, саве кєрен лубіпен, або сар када мануш, саво іскідел налогі. ");
INSERT INTO rmczrb_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Дувар про курко лікєрав о постос, а саворестар, со зародав, дав дештато». ");
INSERT INTO rmczrb_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","А ода, саво іскіделас налогі, тердьолас пре сийра і даралас те вазден пескєре якга про нєбос, мареласпес андро колін і вакєрелас: «Девла, посаїн ман, бійношнес». ");
INSERT INTO rmczrb_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Пгенав туменґє, со чак када мануш ґейля кгєйре оправдіме, а на першо. Сако, ко ваздел пескє опре, дикгєна лес тейле, а ко дикгєлпес тейле, ода ейла ваздно опре. ");
INSERT INTO rmczrb_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ко Ісус анде цікне чавен, гой Ов те тговел Пескєре васта пре ленде. Та кана дикгле сікаде када, на каменас лен те домукєн. ");
INSERT INTO rmczrb_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Акор Ісус вічіндя лен і пгендя: — Мукєн ле чавен, мі авен кє Манде. На запріщінен ленґє те авен, бо Краліпе Девлескєро гіно ленґєро. ");
INSERT INTO rmczrb_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Чачібе вакєрав туменґє: ко на прелела Краліпе Девлескєро, сар о чаворо, на заджяла андре лесте. ");
INSERT INTO rmczrb_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Єкг ле пгуредер манушендар пгучля Лестар: — Лачо танітов, со манґє те кєрен, гой те худав вечно джівіпе? ");
INSERT INTO rmczrb_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ісус лескє пгендя: — Соске ту вічінес Ман лачо? Ніко нане лачо, ча єкг о Дейл. ");
INSERT INTO rmczrb_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ту джянес е заповіді: на кєр лубіпен, на мурдар, на човр, на свідчін начачібе, кам пескєре дадес те пескєра да. ");
INSERT INTO rmczrb_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ов Лескє пгендя: — Саворо акада ме долікєрав мійре терне бершендар. ");
INSERT INTO rmczrb_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Сар шундя када, Ісус пгендя лескє: — Єкг тукє хібінел — саворо, со тут гін, бікєн і розде ле чоренґє, і ейла тут барваліпе про нєбос. Акор ав пал Манде. ");
INSERT INTO rmczrb_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Сар ов шундя саворо када, забаїндяпес, бо есас іґєн барвало. ");
INSERT INTO rmczrb_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ісус дикгля, со ов забаїндяпес, і пгендя: — Сар пгарес барваленґє те заджян андро Краліпе ле Девлескєро! ");
INSERT INTO rmczrb_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ловкєдер верблюдоскє те преджян пріґ сувакєро кганоро, сар барвалескє те заджян андо Краліпе Девлескєро. ");
INSERT INTO rmczrb_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Одала, ко ода шунелас, пгучле: — Акор ко шай ратинелпес? ");
INSERT INTO rmczrb_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ісус ленґє отпгендя: — Ода, со наший манушенґє, ода шай ле Девлескє. ");
INSERT INTO rmczrb_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Акор Петро пгендя: — Дикг, саворо, со кє аменде есас, амен муклям і ґейлям пал Туте. ");
INSERT INTO rmczrb_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ісус пгендя ленґє: — Чачібе пгенав туменґє: сако, ко мукля пескєро кгєр, вай ромня, вай ле пгрален, вай ле даден, вай ле чавен важо Краліпе ле Девлескєро, ");
INSERT INTO rmczrb_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","худела бутередер андре аді овра, а андро авер векос — вечно джівіпе. ");
INSERT INTO rmczrb_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Акор Ов вічіндя пескєре дешудуєн сікаден і пгендя ленґє: — Канакє амен джяс андро Єрусалім, і обачелапес одя саворо, со гін пісіме пріґ пророка пало Ча ле Манушенґєро. ");
INSERT INTO rmczrb_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ов ейла отдино манушенґє, саве на джянен ле Девлес. Оне асана Лес аврі, джюнґлярена Лес і чунґаркєрена пре Лесте, ");
INSERT INTO rmczrb_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","а пало марібе ле чупняга мурдарена Лес, та про тріто дівес Ов джівдісальола. ");
INSERT INTO rmczrb_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Сікаде ніч одалестар на ахаліле, бо када лав есас запганло лендар, і оне на джяненас, пал состе джялас вакєрібе. ");
INSERT INTO rmczrb_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Кана Ісус авелас пашедер ко Єріхон, єкг коро мануш бешелас пажо дром і манґєлас о лове. ");
INSERT INTO rmczrb_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Сар шундя, со паж лесте преджял нийпос, пгучля лендар: — Со пес обачіля? ");
INSERT INTO rmczrb_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Лескє пгенде: — Ісус андал Назарет преджял. ");
INSERT INTO rmczrb_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Акор о коро завріскіндя: — Ісус, о Ча ле Давідоскєро, посаїн ман! ");
INSERT INTO rmczrb_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","А одала, саве джянас анґлал, кєздинде те вакєрен лескє, гой ов те ціхісальол, та о коро минґ федер вріскінелас: — Ча Давідоскєро, посаїн ман! ");
INSERT INTO rmczrb_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ісус терділя і пгендя: — Анен лес кє Манде. Кана ов подавля кє Лесте, Ісус пгучля лестар: ");
INSERT INTO rmczrb_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","— Со ту камес, гой Ме тукє те кєрав? А о коро Лескє пгендя: — Раєя! Камав те дикгєн! ");
INSERT INTO rmczrb_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ісус лескє пгендя: — Пгутер о якга! Тийро патябе сасардя тут аврі! ");
INSERT INTO rmczrb_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Коро єкгваресте ачіля те дикгєн і ґейля пало Ісус, ле ашаріпнага ле Девлес. А саворо нийпос, саво дикгля када, ашарелас ле Девлес. ");
INSERT INTO rmczrb_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ісус заавля андро Єріхон і преджялас пріґ о фоврос. ");
INSERT INTO rmczrb_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Одя есас мануш про нав Закхей. Ов есас пгуредер про одала, саве іскіденас налогі, і есас барвало. ");
INSERT INTO rmczrb_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ов іґєн камелас те дикгєн ле Ісус, ко Ов айсо, та прекал ода, со оде есас бут мануша, на бійрінелас, важ ода бо ов есас цікно мануш. ");
INSERT INTO rmczrb_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Акор ов денашля анґлал, гой те вазденпес про тутовакєро дубос, гой одарік те дикгєн ле Ісус, кана Ов одарік преджяла. ");
INSERT INTO rmczrb_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Кана Ісус подавля пашедер ко ода тган, Ов дикгля опре про Закхей і пгендя лескє: — Закхей, ав сіґєредер тейле. Дадіве Ме маїнав те авен андро тийро кгєр! ");
INSERT INTO rmczrb_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ов єкгваресте авля тейле і ле радишаґога преіля ле Ісус. ");
INSERT INTO rmczrb_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Саворе, ко дикгля ода, хунде те дудрінен: — Ов ґейля андро гості ко бійношно мануш! ");
INSERT INTO rmczrb_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Акор Закхей ушіля і пгендя ле Раєскє: — Раєя! Єпаш мійро барваліпе ме роздава чоренґє, а те варекастар ме ільом опрал, ме вісарава лескє штарвал бутередер! ");
INSERT INTO rmczrb_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Акор Ісус лескє пгендя: — Дадіве авля ратипе андре када кгєр, бо те ов гіно о ча ле Авраамоскєро! ");
INSERT INTO rmczrb_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","О Ча ле Манушенґєро авля те аракгєн і те ратинен ода, со есас нашадо. ");
INSERT INTO rmczrb_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Одаленґє, ко ода шунелас, Ісус розвакєрдя єкг вакєрібе. Оне есас надур ле Єрусалімостар, і мануша думіненас, гой сіґ маїнел те пгутеренпес о Краліпе ле Девлескєро. ");
INSERT INTO rmczrb_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Важ ода Ов ленґє пгендя: — Єкг раїкано мануш джялас дур пре авер пгув, гой те прелен краліпе, а паліш те вісальон пале. ");
INSERT INTO rmczrb_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ов вічіндя пескєре дешен совґен, диня ленґє по шел драхмі і пгендя ленґє: «Кєрен лендар хасна, адик ме авава пале». ");
INSERT INTO rmczrb_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Но мануша лескєра пгуватар мержіненас лес і бічаде анґлал ле манушен, гой мі пгенен: «Амен на камас, гой ада мануш те ачел амаро краліс». ");
INSERT INTO rmczrb_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Кана ов преіля пескєро краліпе, то диня аврі те вічінен кє лесте совґен, савенґє ов допатяндя серебро, гой те пгучен лендар, ко кєці зарондя. ");
INSERT INTO rmczrb_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Першо сікадяпес і пгендя: «Хулай, тийре шел драхмі андя манґє езерос драхмі». ");
INSERT INTO rmczrb_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","О хулай лескє пгендя: «Міште, ту сал лачо совґас. Ту салас патівало андро цікно, важ ода ту ейга баредер про деш фовра». ");
INSERT INTO rmczrb_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Авля дуйто совґас і пгендя: «Хулай! Тийре шел драхмі анде манґє панчшел драхмі». ");
INSERT INTO rmczrb_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","О хулай те лескє пгендя: «Те ту ейга баредер про панч фовра». ");
INSERT INTO rmczrb_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Паліш авля те тріто совґас і пгендя: «Хулай! Акєс тийре шел драхмі, ме ґарудьом ла андро запатярдо кгосноро. ");
INSERT INTO rmczrb_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ме дарандільом тутар, авка сар ту жестоко мануш. Ту лес одя, кай ту на тгодял, і іскідес одя, кай на шіїндял». ");
INSERT INTO rmczrb_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Акор о хулай лескє пгендя: «Тийра чібага тут судзінава, налачо совґас! Ту джянлял, со ме жестоко мануш, со ме лав одя, кай на тгодьом, іскідав одя, кай ме на шіїндьом. ");
INSERT INTO rmczrb_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Соскє ту на муклял мійро серебро андро дєлос, гой, кана ме вісалювава, те вісарес манґє бутередер?» ");
INSERT INTO rmczrb_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","І ов пгендя одаленґє, ко одя тердьолас: «Лен лестар лескєре шел драхмі і ден одалескє, кє касте гін езерос». ");
INSERT INTO rmczrb_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Лескє пгенде: «Хулай! Кє лесте те авка гін іма езерос драхмі». ");
INSERT INTO rmczrb_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","О хулай отпгендя: «Пгенав туменґє: саконескє, кас гін, доделапес минґ, а кє касте нане, одлелапес минґ те ода, со лес гін. ");
INSERT INTO rmczrb_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","А мійре враген, саве на каменас, гой ме те ачав краліс пре ленде, анен лен аде і анґлал манде мурдарен». ");
INSERT INTO rmczrb_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Сар Ісус розвакєрдя када, Ов ґейля дуредер ко Єрусалім. ");
INSERT INTO rmczrb_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Кана авелас пашедер ко Віффагія і Віфанія, пажо Олівково партос, Ов бічадя анґлал дує сікаден, ");
INSERT INTO rmczrb_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","вакєрібнага: — Джян андро баро ґав, саво анґлал туменде, і сар заавена андре лесте, тумен аракгєна препганле терне сомаріс, про саво минґ ніко на бешелас. Розпганден лес і анен лес аде. ");
INSERT INTO rmczrb_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","А те вареко тумендар пгучела: «Соске тумен лес отпганден?» — пгенен лескє авка: «Ов кампел ле Раєскє». ");
INSERT INTO rmczrb_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Сікаде, савен Ов бічадя, ґейле і аракгле саворо авка, сар Ісус ленґє пгендя. ");
INSERT INTO rmczrb_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Кана оне розпганле терне сомаріс, акор лескєре хулая пгучле лендар: — Соске тумен розпганден ле сомаріс? ");
INSERT INTO rmczrb_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Оне отпгенде: — Ов кампел ле Раєскє. ");
INSERT INTO rmczrb_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Оне анде ле сомаріс ко Ісус і хунде те ракінен пре лесте пескєре голмі, а паліш тгоде те бешен пре лесте ле Ісус. ");
INSERT INTO rmczrb_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Кана Ов джялас, о мануша лачаренас пескєре голмі про дром. ");
INSERT INTO rmczrb_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Кана Ов авля пашедер ко тган, про дром, саво мукєлпес тейле пало Олівково партос, акор іґєн бут сікаде кєздинде ле радишаґога баре ганґога те ашарен ле Девлес важ саворе чудєса, саве оне дикгле. ");
INSERT INTO rmczrb_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Оне вакєренас: — Ашаріпе ле Краліскє, саво авел андро Раєскєро нав! Мірос про нєбос і слава опре андро увчібе! ");
INSERT INTO rmczrb_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Варесаве фарісєї машкар о нийпос пгенде Лескє: — Танітов, пген пескєре сікаденґє, мієн ціхо! ");
INSERT INTO rmczrb_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ов ленґє отпгендя: — Пгенав туменґє, те оне ейна ціхо, акор о бара кєздинена те вріскінен. ");
INSERT INTO rmczrb_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Кана Ов авля пашедер і дикгля про фоврос, Ов кєздиндя те ровен пал лесте ");
INSERT INTO rmczrb_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","і пгендя: — О, те ту прінджярдялас андре када тийро дівес, со шай анел тукє мірос! Та дадіве када ґарудо тийре якгендар. ");
INSERT INTO rmczrb_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Авена дівеса, кана тийре врагі окружінена тут барікаденца і пал сако єкг сийра кікідена тут. ");
INSERT INTO rmczrb_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Оне унічтожена тут і саворен, ко андре туте джівел, і на мукєна бар про бар, важ ода кай ту на прінджярдял оди овра, кана о Дейл авля кє туте. ");
INSERT INTO rmczrb_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Паліш Ісус заґейля андро храмос і кєздиндя те траден аврі ле торгашен ");
INSERT INTO rmczrb_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","і вакєрелас ленґє: — Пісіме: «Мійро кгєр ейла молітвено кгєр», а тумен кєрдян лестар о кгєр прекал о жівана. ");
INSERT INTO rmczrb_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ісус сако дівес сікавелас андро храмос. А єкг баредер рашая, танітова Законоскєре і пгуредера нийпоскєре роденас овра, гой Лес те мурдарен. ");
INSERT INTO rmczrb_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Та оне на джяненас, сар ода те кєрен, бо саворе мануша шуненас ле Ісус і на каменас те премукєн ані єкг лав. ");
INSERT INTO rmczrb_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ачіляпес андро єкг дівес, кана Ісус сікавелас андро храмос ле нийпос і вакєрелас ленґє Радишаґоскєро Гійрос, кє Лесте подавле єкг баредер рашая, танітова Законоскєре, а те пгуредера. ");
INSERT INTO rmczrb_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","І пгучле Лестар: — Пген аменґє, сава владага Ту када саворо кєрес? І ко диня Тукє кади влада? ");
INSERT INTO rmczrb_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Акор Ов ленґє пгендя: — Те Ме пгучава тумендар, а тумен пгенен Манґє — ");
INSERT INTO rmczrb_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","катар Іоанн хундя пескєрі влада те болавен, пало нєбос вай ле манушендар? ");
INSERT INTO rmczrb_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Оне кєздинде те вакєрен машкар песте: «Те амен пгенага: \"Пало нєбос\", акор Ов пгучела: \"Акор соске тумен на патянділян Лескє?\" ");
INSERT INTO rmczrb_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Те пгенага: \"Ле манушендар\", акор саворо нийпос марела амен ле баренца, бо оне патян, со Іоанн есас пророкос». ");
INSERT INTO rmczrb_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Акор оне отпгенде: — На джянас, катар. ");
INSERT INTO rmczrb_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Акор те Ісус ленґє пгендя: — І Ме на пгенава туменґє, сава владага Ме када кєрав. ");
INSERT INTO rmczrb_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ов кєздиндя те розвакєрен ле нийпоскє када вакєрібе: — Єкг мануш садзіндя дракгєнґєро садос. Ов диня лес важо лове ле бувтякєренґє, а коркоро ґейля пре цузо пгув про бутенґєрі овра. ");
INSERT INTO rmczrb_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Кана авля овра, ов бічадя ле совґас ко дракгара, гой оне мі ден лескє ода, со поперелпес лескє ле увліпнастар. Та бувтяра ізмарде ле совґас і бічаде лес чувче вастенца. ");
INSERT INTO rmczrb_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Акор ов бічадя минґ єкгєс совґас, та оне те лес ізмарде і кєрде лега пре ладж, а паліш бічаде лес чувче вастенца. ");
INSERT INTO rmczrb_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Акор ов бічадя трітонес, та оне те лес фес ізмарде і чіде лес аврі андало садос. ");
INSERT INTO rmczrb_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Акор о хулай дракгєнґєро пгендя: «Со манґє те кєрен? Бічавава мійре камаде чаворес, талам, лестар оне ладжянапес». ");
INSERT INTO rmczrb_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Та кана бувтяра дикгле ле час, кєздинде те вакєрен єкг аврескє: «Саворо када хулаїпе маїнел те ачен лескє. Авас, мурдарага лес, гой ада саворо те ачел аменґє». ");
INSERT INTO rmczrb_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Акор оне чіде лес аврі андало садос і мурдарде. Со канакє кєрела ленца дракгєнґєро хулай? ");
INSERT INTO rmczrb_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ов авела і мурдарела одален бувтякєрен, а садос отдела авренґє. А одала, кай шунде када, пгенде: — Те на ейл айсо! ");
INSERT INTO rmczrb_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Та Ісус дикгля пре ленде і пгендя: — Сар те ахальон када пісіме: «Бар, саво отчіде мурніка, ачіля єкг главнедер андро углос»? ");
INSERT INTO rmczrb_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Сако єкг, ко перела про ода бар, розмарелапес, а пре касте ов перела, одалес затасавела. ");
INSERT INTO rmczrb_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Танітова Законоскєре те єкг баредер рашая ахаліле, со ода вакєрібе Ісус розвакєрдя пал ленде, і важ ода камле єкгваресте те пганден тейле Лес, та даранас ле нийпостар. ");
INSERT INTO rmczrb_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Важ ода оне кєздинде те дикгєн пало Ісус і бічаде кє Лесте ле манушен, саве сікавнаспес, со оне гіне чачібнаскєре, гой те худен ле Ісус про лав і те ден Лес аврі ле владакє андро васта рімоскєре владаріскє. ");
INSERT INTO rmczrb_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Оне пгучле Лестар: — Танітов, амен джянас, со Ту міште вакєрес і міште сікавес, і на дикгєс про муя, а чачес сікавес Девлескєро дром. ");
INSERT INTO rmczrb_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Чі сабано аменґє те ден налогос імператоріскє вай наа? ");
INSERT INTO rmczrb_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ісус дикгля ленґєро буджяндіпе і важ ода пгендя ленґє: ");
INSERT INTO rmczrb_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","— Сікавен Манґє дінарій. Каскєро муй і каскєро нав пре лесте? Акор оне отпгенде: — Імператоріскєро. ");
INSERT INTO rmczrb_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","А Ов ленґє пгендя: — Важ ода ле імператоріскє ден імператоріскєро, а Девлескєро — ле Девлескє. ");
INSERT INTO rmczrb_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Оне на бійріненас Лес те хунде про лав анґлал о нийпос, чудаліненаспес, сар Ов отпгендя, і заціхісаліле. ");
INSERT INTO rmczrb_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Акор подавле ко Ісус варесаве саддукєї (оне вакєренас, со нане уштавібе мувленґєро) і пгучле Лестар: ");
INSERT INTO rmczrb_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","— Танітов, Моїсєй пісіндя аменґє, те кє варекасте мерела о пграл, ко саво есас ромні, но на есас ла о чаве, акор ов маїнел те лен ла ромнякє і важ пескєро пграл те ден лакє ле чавен. ");
INSERT INTO rmczrb_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Есас ефта пграла. Першо пграл іля пескє ромня і мувля бі о чаве. ");
INSERT INTO rmczrb_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Паліш те дуйто. ");
INSERT INTO rmczrb_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Те тріто іля ла пескє важо ромня; авка саворе ефтаджяне. Оне саворе мувле і на мукле пал песте ле чавен. ");
INSERT INTO rmczrb_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Паліш мувля те е ромні. ");
INSERT INTO rmczrb_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Важ ода, пало уштавібе ле мувленґєро, каскєрі ой ейла ромні? Бо ой есас ефтаджяненґє важе ромні. ");
INSERT INTO rmczrb_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ісус ленґє отпгендя: — Кале векоскєре мануша лен пескє ромнєн і джян роместе. ");
INSERT INTO rmczrb_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","А одала, саве ейна достойне те джівен андро авер векос і ейла уштадо опре андал о мерібе, на лена пескє ромнєн і роместе на джяна. ");
INSERT INTO rmczrb_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","І на бійрінена іма те мерен, бо оне ейна подобне про анґєла. Оне гіне Девлескєре чаве, бо лен участіє андро уштавібе мувленґєро. ");
INSERT INTO rmczrb_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","А ода, со мувле ушена андал о мерібе, Моїсєй сікадя пажо тернячкєнґєро кущос, саво лаболас, кана вічіндя ле Раєс, со ов гіно о Дейл Авраамоскєро, о Дейл Ісаакоскєро і о Дейл Яковскєро. ");
INSERT INTO rmczrb_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ов о Дейл на ле мувленґєро, а ле джівденґєро, бо пріґ Лесте саворе джівде. ");
INSERT INTO rmczrb_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Акор варесаве танітова Законоскєре пгенде: — Танітов, Ту міште отпгендял! ");
INSERT INTO rmczrb_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","І ніко іма на тромалас те пгучен Лестар ні пал состе. ");
INSERT INTO rmczrb_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Паліш Ісус пгучля лендар: — Соске вакєрен авка, со Хрістос гіно о Ча ле Давідоскєро? ");
INSERT INTO rmczrb_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Та Давід коркоро вакєрел андро кніжка Псалмі: «Пгендя о Рай мійре Раєскє: Беш пре чачі сийра паж Манде, ");
INSERT INTO rmczrb_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","адик на тговава Тийре враген Тукє толо піндре». ");
INSERT INTO rmczrb_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Давід вічінел Лес ле Раєга. Та акор, сар шай Ов авел лескєро Чаворо? ");
INSERT INTO rmczrb_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Саворо нийпос шунелас ле Ісус, а Ов пгендя Пескєре сікаденґє: ");
INSERT INTO rmczrb_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","— Меркіненпес ле танітовен Законоскєрен. Оне камен те пгірен андро діндярдо шукар уравіпе і камен, кана ленґє палікєрен про фовроскєре піяца. Оне бешен про єкг федер тгана андро сінаґоґа і про вічіме дийлос. ");
INSERT INTO rmczrb_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Оне зален пескє ле вдовенґєре кгєра і про якга ле манушенґє буталікпес модлінен. Айсе прелена єкг баредер судос. ");
INSERT INTO rmczrb_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ісус дикгєлас, сар барвале чівкєренас пескєре дари андре храмоскєрі скарбнічка. ");
INSERT INTO rmczrb_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Одя Ов дикгля єкга чора вдова, саві чідя дуй хурде копейкі. ");
INSERT INTO rmczrb_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Акор Ісус пгендя: — Чачібе пгенав туменґє, со кади чорі вдова чідя єкг бутередер саворендар. ");
INSERT INTO rmczrb_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Бо кадала саворе денас андал пескєро барваліпе, а ой айсі чорі, і чідя саворо, со ла есас про джівіпе. ");
INSERT INTO rmczrb_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Кана завакєрде варесаве мануша пало храмос, со ов гіно обракіме шукар бароренца те барваліпнага, саве аненас ле Девлескє, Ов пгендя: ");
INSERT INTO rmczrb_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","— Авена дівеса, со одалестар, со тумен канакє дикгєн, на ачела бар про бар, — саворо ейла розмардо. ");
INSERT INTO rmczrb_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Оне пгучле Лестар: — Танітов, кана ода обачелапес? І саво знаменіє сікавела про ода, кана ода маїнел те ачен? ");
INSERT INTO rmczrb_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ов ленґє пгендя: — Меркінен, гой ніко тумен те на дилинярел. Бо бутджяне, ко авена андро Мійро нав і пгенена: «Ода Ме» і «Овра іма обачіля». На джян пал ленде! ");
INSERT INTO rmczrb_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Кана тумен шунена пало войни те пал ода, со мануша ачен аврі єкг протів авересте, на даран. Бо саворо када маїнелпес те обачен анґлал, та аґор ачелапес на єкгваресте. ");
INSERT INTO rmczrb_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ов дуредер вакєрелас кє ленде: — Джяла нийпос про нийпос і краліпе про краліпе. ");
INSERT INTO rmczrb_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Акор разінелапес е пгув, і андро бут тгана ейла барі бокг те баро насвалібен, а про нєбос ейна страшне і баре знаменія. ");
INSERT INTO rmczrb_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Та анґлал ода, сар маїнел са када те ачен, тговена пре туменде пескєре васта і кєздинена тумен те траден, предена тумен андре сінаґоґі і андре тюрмі, і ліджяна тумен ко краля те ко владара. Саворо када туменца кєрена важ Мійро нав. ");
INSERT INTO rmczrb_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Акор ейла тумен возможность те свідчінен. ");
INSERT INTO rmczrb_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Но на думінен анґлал пало ода, со туменґє те отпгенен. ");
INSERT INTO rmczrb_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Бо Ме дава туменґє айсі ґовді те о лава, со ані єкг тумаре врагендар на бійрінела те отпгенен чі те тердьон аврі анґлал туменде. ");
INSERT INTO rmczrb_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Акор предена тумен тумаре дада, пграла, тумаро чаладос і тумаре барата, а варекас тумендар мурдарена. ");
INSERT INTO rmczrb_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Важ Мійро нав саворе тумен мержінена. ");
INSERT INTO rmczrb_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Та ані єкг бал пал тумаро шейро на проперела! ");
INSERT INTO rmczrb_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Тийрінен, і авка ратинена пескєрі вовді. ");
INSERT INTO rmczrb_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Кана тумен дикгєна Єрусалім, захундо буте суґлядєнца, акор джянен, гой авля овра, кана ов маїнел тейн розрушіме. ");
INSERT INTO rmczrb_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Акор одала, саве гіне андре Іудєя, мі денашен про брегі; ко андро фоврос, мі денашен андал лесте, одала, ко пре маля, те на джян пре лесте, ");
INSERT INTO rmczrb_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","бо андре одала дівеса о Дейл воздела ле манушенґє, і акор обачелапес саворо, со гіно пісіме. ");
INSERT INTO rmczrb_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Біда пгаре ромнєнґє і одаленґє, ко дел чувчі те пієн, андро одала дівеса, бо баро пгарібе ейла пре пгув, і руш зчордьолапес пре када нийпос! ");
INSERT INTO rmczrb_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Єкг мануша меркєрена ле шаблятар, а авер манушен спгандена і отліджяна про авер пгув. Єрусалім тапошінена піндренца шільяка мануша, адик на преджяла ленґєрі овра. ");
INSERT INTO rmczrb_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","І ейла знаменіє про кгам, про чон те про черхеня, нийпі пгувакєре шунена ровібе морьоскєро ле волнендар і ейна андро смуткос, і на джянена, со те кєрен. ");
INSERT INTO rmczrb_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Акор мануша слабісальона ле даратар, анґлал ода, со авел про цейло светос. Акор те нєбоскєрі зор разісальола. ");
INSERT INTO rmczrb_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Акор дикгєна ле Час Манушенґєрес, саво авел про хмара ле зорага те андре барі слава. ");
INSERT INTO rmczrb_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Кана када саворо кєздинелапес те обачен, ушен і вазден о шейре, важ ода, бо іма пашес тумаро ратипе. ");
INSERT INTO rmczrb_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Паліш Ов розвакєрдя ленґє айсо вакєрібе: — Дикгєн про інжірос і про саворе дубі. ");
INSERT INTO rmczrb_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Кана пре ленде сікавенпес прайтя, тумен дикгєн ода і джянен, гой пашес о нілай. ");
INSERT INTO rmczrb_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Авка те тумен, кана дикгєна, со када саворо обачелапес, джянен, со іма пашес о Краліпе ле Девлескєро. ");
INSERT INTO rmczrb_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Чачібе пгенав туменґє, минґ на шажнінела када родос, сар када саворо ачела. ");
INSERT INTO rmczrb_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","О нєбос те пгув преджяна, а Мійре лава на преджяна. ");
INSERT INTO rmczrb_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Меркінен пре туменде, гой тумаре їле те на замаренпес чак ле мулатипнага, піїбнага і джівіпнаскєре заботамі, гой ода дівес те на авел пре туменде акор, кана тумен лес на ужарен, ");
INSERT INTO rmczrb_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","сар сітка. Ов авела про саворе мануша, саве джівен пре цейлі пгув. ");
INSERT INTO rmczrb_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Міндик авен бодре і модліненпес, гой тумен мієл зор те преджян са, со маїнелпес те ачен, і те тердьон анґлал о Ча ле Манушенґєро. ");
INSERT INTO rmczrb_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Сако дівес Ісус сікавелас андро храмос, а ратяга джялас про Олівково партос і преліджялас одя е раті. ");
INSERT INTO rmczrb_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","А сіктосарастар саворо нийпос іскіделаспес андро храмос, гой те шунен Лес. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Авелас пашедер Маріклєнґєро ійнепос, саво вічінеласпес Патраді. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Єкг баредер рашая те танітова Законоскєре роденас, сар те мурдарен ле Ісус, та даранас ле нийпостар. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Акор о сатана заґейля андро Іудас, саво вічінеласпес Іскаріот, ов есас єкг ле дешудуєндар. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ов ґейля ко єкг баредер рашая а те ко храмоскєре сторожа і довакєрдяпес ленца, сар те преден аврі ленґє ле Ісус. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Оне радисаліле і дине лав те ден лескє лове. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Іуда диня ленґє лав і кєздиндя те роден овра, сар те ден ленґє аврі ле Ісус, кана Лега на ейла ле нийпос. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ачіля о дівес Маріклєнґєро, андро саво кампіля те дочінен патрадякєре бакрорес. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Акор Ов бічадя ле Петрос те ле Іоанн і пгендя ленґє: — Джян і кійсітинен аменґє патрадякєро хавібе. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Та оне Лестар пгучле: — Кай Ту камес, гой амен те кійсітинас? ");
INSERT INTO rmczrb_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ов ленґє отпгендя: — Кана тумен заджяна андро фоврос, тумен одя аракгєна ле манушес, саво ліджяла пані андро канчовс. Джян пал лесте андро ода кгєр, андро саво ов заджяла, ");
INSERT INTO rmczrb_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","і пгенен ле кгєрескєре хулаєскє авка: «Танітов пгучел тутар: \"Кай соба, андре саві Ме те мійре сікаде хага Патраді?\"» ");
INSERT INTO rmczrb_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ов сікавела туменґє опре барі соба, андре саві іма саворо прікєрдо. Одя і кійсітинен. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Оне ґейле і аракгле саворо авка, сар ленґє пгендя Ісус, і кійсітинде патрадякєро хавібе. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Кана авля овра, Ісус і Лескєре апостоли іскіндепес пажо скамін. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ов ленґє пгендя: — Ме іґєн камльом те хан кади Патраді туменца анґлал Мійро мучішаґос. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Пгенав туменґє, со Ме іма на хава ла джі ко ода, адик ой на обачелапес андро Краліпе ле Девлескєро. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Акор Ов іля е кувчі, палікєрдя важ лате ле Девлес і пгендя: — Лен і розулавен ла машкар туменде. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Пгенав туменґє, со Ме бутер на піява андал дракгєнґєро плодос, адик на авела о Краліпе ле Девлескєро. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Паліш іля маро, палікєрдя важ лесте ле Девлескє, препгаґля лес і диня ленґє ле лавенца: — Када Мійро тєлос, кай важ туменґє отделпес. Кєрен ада, кана леперена пал Манде. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Авка те пало ода, сар отхале, іля е кувчі і пгендя: — Кади кувчі — нейво заветос, спганло Мійре ратега, саво важ туменде чордьолпес. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Та о васт одалескєро, ко предел Ман, про єкг скамін Мійрега. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Та о Ча ле Манушенґєро джял авка, сар пал Лесте пісіме, та війґос одале манушескє, саво Лес предел. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Акор сікаде кєздинде єкг аврестар те пгучен, ко машкар аменде шай айсо кєрел. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Паліш оне кєздинде те споріненпес, ко лендар маїнел тейн єкг баредер. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ісус акор ленґє пгендя: — О краля нийпоскєре гіне хулая про мануша, а нийпоскєре рая вакєрен, со оне кєрен лачіпе. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","А тумен на кєрен авка, сар оне. Та єкг баредер машкар туменде мі ачел єкг цікнедер, а ко тумендар начальнікос — мієл айсо, сар совґас. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Бо ко баредер: ода, ко бешел пажо скамін, вай ода, ко совґалінел? На ода, саво бешел? Та Ме машкар туменде, сар совґас. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Тумен санас Манца міндик, кана сомас пробаліме аврі. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Сар Мійро Дад диня Манґє Краліпе, авка Ме канакє дав лес туменґє, ");
INSERT INTO rmczrb_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","гой тумен те бійрінен те хан і те пієн пажо Мійро скамін андро Мійро Краліпе. Тумен бешена про трона і судзінена дешудуй роди Ізраєльоскєре. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","І пгендя о Рай: — Сімон, Сімон! Акєс о сатана манґля Ман те прешіїнен тумен, сар дів. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Та Ме ман модліндьом пал туте, гой ту те на нашавес патябе. Ту коркоро, кана вісарегатут кє Манде, зорісалю пескєре пгрален. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Петро Лескє отпгендя: — Раєя! Та ме Туга кійсітиме сом те джян те андре тюрма, те про мерібе! ");
INSERT INTO rmczrb_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Та Ісус лескє пгендя: — Пгенав тукє, Петро, минґ дадіве на заґілявела кугутос, сар ту трівал пгенега, со на джянес Ман. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ісус пгучля лендар: — Кана Ме тумен бічававас бі е тарца, бі е ташка і бі е камашлі, чі хібінелас туменґє варесо? А оне Лескє отпгенде: — Наа. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Акор Ов ленґє пгендя: — А канакє, те кє туменде гін е тарца, мі лел ла пега. Лен те е ташка. Те кє туменде нане шабля, мі бікєнел пескєро голмос і мі цінел е шабля. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ме вакєрав туменґє, со ода, со гіно пісіме, маїнелпес те ачен Манца: «Ко жівана Лес зарахінде». Бо ода, со пал Манде пісіме, сіґ обачелапес. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Оне пгенде: — Раєя! Дикг, акєс дуй шаблі. Ов ленґє пгендя: — Дос іма. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Пал Пескєро обичай, Ісус ґейля про Олівково партос, і Лескєре сікаде ґейле Лега. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Сар авля про тган, Ов ленґє пгендя: — Модліненпес, гой тумен те на авен пробаліме аврі. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","А коркоро отґейля лендар варекай пре айці, пре кєці шай те чівен о бар, терділя про коча і кєздиндяпес те модлінен. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","І вакєрелас: — Даде, те Ту камес, кади кувчі мі обджял Ман! Но мієл на авка, сар Ме камав, а авка, сар Ту камес! ");
INSERT INTO rmczrb_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Акор сікадяпес Лескє анґєлос пало нєбос і додиня Лескє зор. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ісус минґ бутер модлінеласпес андро мучішаґос. Ачіля Лескєро кгамліпе, сар краплі ратескєре, саве перенас пре пгув. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Кана Ов ушіля опре ле молітватар і подґейля ко сікаде, Ов аракгля лен, со оне совен, бо оне сас мучіме ле жалятар. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ісус пгучля лендар: — Со тумен совен? Ушен і модліненпес, гой те на авен пробаліме аврі. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ов минґ вакєрелас, кана авля бут нийпос, а ленца Іуда, єкг дешудуєндар. Ов джялас анґлал ленде і подавля ко Ісус, гой те чуміден Лес. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Та Ісус лескє пгендя: — Іуда, ту ле чумібнага бікєнес ле Час Манушенґєрес? ");
INSERT INTO rmczrb_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Кана одала, ко есас ле Ісусога, дикгле, со одя кєрелпес, пгучле Лестар: — Раєя, а со, те амен демага шабляга? ");
INSERT INTO rmczrb_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Єкг лендар демадя єкг баредере рашаєскєрес совґас і отчіндя лескє о чачо кган. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Та Ісус ленґє отпгендя: — Доста! Преачен! Ов дотгодя паліш Пескєро васт кє лескєро кган і сасардя лес. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Паліш Ісус пгендя ко єкг баредер рашая те ко храмоскєре сторожа а те пгуредеренґє, саве авле пал Лесте: — Сар про жіванос тумен авлян пре Манде ле шабленца те ле паценца. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Сако дівес, кана Ме сомас машкар туменде андро храмос, тумен на тговенас пре Манде тумаре васта; но канакє тумарі овра і цмакєрі влада. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Акор оне хунде ле Ісус і анде Лес ко єкг баредер рашай андро кгєр. А Петро дуралестар джялас пал ленде. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Кана розракінде яґ машкар е двовра, о Петро авер манушенца бешля пажо яґ. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Єкг совґалкіня дикгля ле Петро андре яґакєро шветлос, міште предикгляпес пре лесте і пгендя: — Те ов есас Лега! ");
INSERT INTO rmczrb_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Но Петро отпгендя: — Ромніє, ме Лес на джянав! ");
INSERT INTO rmczrb_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Паліш минґ єкг лес дикгля і пгендя: — Те ту сал лендар. Та Петро лескє отпгендя: — Наа, манушея! ");
INSERT INTO rmczrb_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Преґейля варекай єкг овра, кана минґ єкг патябнага пгендя: — Чачес, те када есас Лега, бо ов гіно галілєянос. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Та о Петро лескє пгендя: — Манушея, ме на джянав, пал состе ту вакєрес! І єкгваресте, кана ов минґ вакєрелас, о кугутос заґілядя. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Акор о Рай вісаліля і задикгля про Петрос. Акор Петро лепердя Раєскєре лава, саве Ов лескє вакєрелас: «Анґлал ода, сар дадіве заґілявела о кугутос, ту трівал пгенега, со на джянес Ман». ");
INSERT INTO rmczrb_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Акор Петро ґейля аврі одарік і хундя андре барі жаля те ровен. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Мануша, саве лікєренас ле Ісус, бандяркєренаспес пре Лесте і маренас Лес. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Оне запганле Лескє о якга і пгученас: — Пророкін, ко Тут демадя? ");
INSERT INTO rmczrb_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","І бут джюнґ лава вакєренас пре Лесте. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Кана ачіля дівес, іскіндепес пгуредера ле нийпоскєре, єкг баредер рашая і танітова Законоскєре, одліґєнде Лес андро Сінєдріон ");
INSERT INTO rmczrb_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","і пгенде: — Те Ту сал о Хрістос, пген аменґє. Ов ленґє отпгендя: — Те Ме туменґє пгенава, тумен на патяна. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","А те Ме тумендар пгучава, на отпгенена Манґє. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ада дівесестар о Ча ле Манушенґєро бешела чачо сийратар ле Девлескєра зоратар. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Акор саворе кєздинде те пгучкєрен: — Та Ту сал о Ча ле Девлескєро? Ов ленґє отпгендя: — Тумен міште пгенен, со ода Ме сом. ");
INSERT INTO rmczrb_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Акор оне пгенде: — Со аменґє минґ кампел? Амен коркоре саворо шундям Лескєре муєстар, со Ов пгендя! ");
INSERT INTO rmczrb_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Оне саворе ушіле і одліґєнде ле Ісус ко Пілат. ");
INSERT INTO rmczrb_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Одя оне кєздинде те обвінінен Лес і пгенде: — Амен шундям, со Ов ваздел амаро нийпос. Ов на домукєл манушенґє те ден налогі ле імператоріскє і вакєрел, со Ов гіно Хрістос, о Краліс. ");
INSERT INTO rmczrb_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Пілат Лестар пгучля: — Ту сал Краліс іудєєнґєро? Та Ов лескє отпгендя: — Ту коркоро авка вакєрес. ");
INSERT INTO rmczrb_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Акор Пілат пгендя єкг баредер рашаєнґє те ле нийпоскє: — Ме на аракгав нісаві віна андре Када Мануш. ");
INSERT INTO rmczrb_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Та оне те авка тердьонас про пескєро і вакєренас: — Ов бунтінел ле манушен і сікавел лен пал саворі Іудєя, андал Галілєя і джі ко амаро фоврос. ");
INSERT INTO rmczrb_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Сар Пілат шундя када, акор пгучля: — Када Мануш галілєянос? ");
INSERT INTO rmczrb_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Кана Пілат доджянляпес, со Ісус гіно андал е пгув, саві есас подвласно ле Іродоскє, акор ов бічадя Лес ко Ірод, саво есас андре одала дівеса андро Єрусалім. ");
INSERT INTO rmczrb_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Сар дикгля Ірод ле Ісус, іґєн радисаліля, бо ов чірла камелас Лес те дикгєн. Ов бутвар шундя пало Ісус і бійзінелапес, со Ов кєрела варесаво знаменіє пріґ лесте. ");
INSERT INTO rmczrb_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ов заделас Лескє бут пгучібе, та Ісус лескє ніч на отпгенелас. ");
INSERT INTO rmczrb_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","А єкг баредер рашая те танітова Законоскєре тердьонас одя і зоралес обвініненас Лес. ");
INSERT INTO rmczrb_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ірод пескєре суґлядєнца дикгля Лес тейле і асандя Лес аврі, а паліш диня пре Лесте шукар голмі і бічадя Лес пале ко Пілат. ");
INSERT INTO rmczrb_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Одале дівесестар о Пілат те о Ірод ачіле барата; а ко ода оне враждиненас. ");
INSERT INTO rmczrb_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Акор Пілат ізвічіндя єкг баредер рашаєн, ле пгуредерен те ле нийпос ");
INSERT INTO rmczrb_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","і пгендя ленґє: — Тумен андян кє манде Кадале Манушес, сар Айсес, Саво ваздел ле нийпос. Дикгєн, ме допгучльом Лес анґлал туменде і на аракгльом нісаво подліпе, андре состе тумен Лес обвінінен. ");
INSERT INTO rmczrb_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Те о Ірод на аракгля андре Лесте нісаві віна і вісардя Лес минґ єкгвар кє аменде. Сар дикгєн, Ов на кєрдя ніч, важ состе Лес шай те мурдарен. ");
INSERT INTO rmczrb_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Важ ода ме дава Лес те марен ле чупняга, а паліш одмукава. ");
INSERT INTO rmczrb_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Та саворо нийпос ачіля те вріскінен: — Мурдар Лес! Мук аменґє аврі ле Вараввас! ");
INSERT INTO rmczrb_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Варавва бешелас андре тюрма важ ода, кай ов кєрдя андро фоврос бунтос, а те мурдаріпе. ");
INSERT INTO rmczrb_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Пілат камелас те мукєн аврі ле Ісус і важ ода минґ єкгвар пгучля лендар. ");
INSERT INTO rmczrb_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Та оне дуредер вріскінас: — Премар, премар Лес! ");
INSERT INTO rmczrb_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Пілат трітовар пгендя ленґє: — Саво подліпе Ов кєрдя? Ме на аракгльом нісаві віна, важ саві Лес шай те мурдарен. Ме дава Лес те марен ле чупняга, а паліш Лес одмукава! ");
INSERT INTO rmczrb_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Та оне минґ хужедер кєздинде те вріскінен і те манґєн, гой Лес те премарен. А пескєре вріскішаґога домардепес пескєро. ");
INSERT INTO rmczrb_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Акор Пілат кєрдя авка, сар оне манґєнас. ");
INSERT INTO rmczrb_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ов одмукля ленґє аврі ле тюрмашіс, саво бешелас важо бунтос і важо мурдаріпе, а ле Ісус диня пре ленґєрі воля, авка, сар оне манґєнас. ");
INSERT INTO rmczrb_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Кана ле Ісус ліджянас те премарен, хунде варесавес Сімон андало Кірінєя, саво джялас пале маля, і тгоде пре лесте кєрестос, гой те ліджял пало Ісус. ");
INSERT INTO rmczrb_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Машкар буте нийпостар, саве джянас пало Ісус, есас те о ромня, саве маренаспес андре колін і ровенас пал Лесте. ");
INSERT INTO rmczrb_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ісус вісаліля і пгендя кє ленде: — Чаяле єрусалімське, на ровен пал Манде. Федер ровен пал песте те пал тумаре чаве. ");
INSERT INTO rmczrb_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Бо авен айсе дівеса, кана пгенена: «Бахтале бічавенґєре, саве на ловтярде і на денас чувчі те пієн». ");
INSERT INTO rmczrb_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Акор мануша вакєрена брегенґє: «Перен пре аменде!» а ле грункєнґє: «Учарен амен!» ");
INSERT INTO rmczrb_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Те терне і желєне дубога кєрен айсо, акор со ейла шувкєга? ");
INSERT INTO rmczrb_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ле Ісусога ліджянас про мерібе минґ дує жіванен. ");
INSERT INTO rmczrb_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Кана оне авле про тган, саво вічінелпес Черепос, одя премарде Лес, а те ле жіванен, єкгєс пре чачі сийра, а дуйтонес пре балоґно сийра. ");
INSERT INTO rmczrb_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ісус вакєрелас: — Даде! Одмук ленґє, важ ода, бо оне на джянен, со кєрен! Суґлядя чівкєренас о жрєбій і розуладе машкар песте Лескєре голмі. ");
INSERT INTO rmczrb_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","О нийпос тердьолас і дикгєлас, а пгуредера асанас Лестар і вакєренас: — Ратинелас аврен, а канакє мі ратинелпес Коркоро, те Ов гіно Хрістос, аврі кіндо ле Девлега! ");
INSERT INTO rmczrb_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Минґ те о суґлядя асанаспес Лестар. Оне подавенас і денас Лескє шут. ");
INSERT INTO rmczrb_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","І вакєренас: — Те Ту сал о Краліс іудєєнґєро, ратин Тут Коркоро! ");
INSERT INTO rmczrb_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Опрал Лесте есас пісіме: «Ода гіно Краліс іудєєнґєро». ");
INSERT INTO rmczrb_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Єкг ле жіванендар, кай фійґінелас про кєрестос, джюнґлярелас Лес і вакєрелас: — Ту со, на сал Хрістос? Ратин Тут, а те амен! ");
INSERT INTO rmczrb_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","А дуйто препгендя Лескє і вакєрелас: — Ту со, на дарас ле Девлестар? Та те ту авка судзіме сал! ");
INSERT INTO rmczrb_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Амен наказіме сам пало чачібе і хундям ода, пре состе засовґаліндям. А када Мануш на кєрдя нісаво подліпе. ");
INSERT INTO rmczrb_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Акор ов пгендя: — Ісус, лепер ман, кана авега андро Тийро Краліпе! ");
INSERT INTO rmczrb_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ісус лескє отпгендя: — Чачібе пгенав тукє: дадіве ейга ту Манца андро райос. ");
INSERT INTO rmczrb_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Есас варекай дешудуй оврі, кана пре саворі пгув ачіля цма, і авка есас джі ко трін оврі. ");
INSERT INTO rmczrb_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Акор цма заучардя о кгам, і похтан андро храмос чінділя про єпаш. ");
INSERT INTO rmczrb_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ісус завріскіндя баре ганґога: — Даде! Андро васта Тийре отдав Мійро духос! Сар пгендя ада, Ов отдиня Пескєро духос. ");
INSERT INTO rmczrb_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Кана сотнікос дикгля, со пес ачіля, кєздиндя те ашарен ле Девлес і пгендя: — Чачес Када Мануш есас чачібнаскєро! ");
INSERT INTO rmczrb_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","А саворе мануша, саве авле те дикгєн, со обачіляпес одя, маренаспес андро колін і вісальонас пале. ");
INSERT INTO rmczrb_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Дуредер пре сийра тердьонас і дикгєнас саворе, ко джянелас ле Ісус. Те о ромня, саве джянас Лега андал Галілєя, дикгєнас, со одя пес кєрдьол. ");
INSERT INTO rmczrb_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Одя есас лачо і чачібнаскєро мануш про нав Йосип, саво есас єкг андало Сінєдріон, ");
INSERT INTO rmczrb_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","но ов на подлікєрелас ленґєре лава те ода, со оне кєренас. Ов есас андал іудєйсько фоврос Арімафея і ужарелас ле Девлескєро Краліпе. ");
INSERT INTO rmczrb_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ов авля ко Пілат і манґєлас лестар ле Ісусоскєро тєлос. ");
INSERT INTO rmczrb_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ов іля тейле о тєлос, обучардя Лес андро льоново похтан і тгодя андре гробніца, со есас кєрді андре скала, андре саві минґ джі ко ода нікас на паруненас. ");
INSERT INTO rmczrb_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ода есас дівес, кана кійсітиненпес ко сомбат, саво іма авелас. ");
INSERT INTO rmczrb_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Пало Йосип ґейле о ромня, саве авле ле Ісусога андал Галілєя. Оне дикгле гробніца і ода, сар тговенас Лескєро тєлос андре лате. ");
INSERT INTO rmczrb_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Сар вісаліле пале, оне кійсітинде сагошне олєї і духі. А сомбатоне кгіньонас, авка, сар пгенел заповідь. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Андро першо куркєскєро дівес, сіктосара, ромня іле преготовіме сагошне олєї і авле кє гробніца. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Одя оне аракгле, со о бар отчідо ле гробніцатар. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Сар заавле андре, оне на аракгле о тєлос ле Раєскєро Ісусоскєро. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ачіля, кана оне на ахальонас, со пес одя обачіля, дуй мурша терділе паж ленде андро бліскаце голмі. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Бара даратар ромня мукле пескєре муя кє пгув, та одала ленґє пгенде: — Со тумен роден джівдес машкар о мувле? ");
INSERT INTO rmczrb_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Лес аде нане — Ов джівдісаліля мерібнастар! Леперен чак, сар Ов вакєрелас туменґє, кана есас минґ андре Галілєя, ");
INSERT INTO rmczrb_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","кана пгендя, со о Ча ле Манушенґєро маїнел тейн предино андро васта ле бійношне манушенґє і маїнел тейн премардо про кєрестос, а про тріто дівес те джівдісальон мерібнастар. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Акор оне леперде Лескєре лава. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Кана вісаліле ле гробніцатар, оне розвакєрде саворо дешуєкг апостоленґє і саворе авренґє. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ода есас Марія Магдаліна, Іоанна, Марія Яковскєрі дай і авер ромня. Оне розвакєрде ода ле апостоленґє, ");
INSERT INTO rmczrb_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","та оне на патянділе ле ромнєнґє, ленґє дичолас, со ода чак чувче лава. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Та о Петро ушіля і єкгваресте денашля кє гробніца. Ов банділя і дикгля одя чак о похтан. Акор ов вісаліля кє песте і чудаліндяпес одалестар, со пес одя обачіля. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Андре ода же дівес дувджяне лендар джянас андро фоврос Еммаус, саво есас вай дешудуй кіломейтрі ле Єрусалімостар. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Оне вакєренас пал саворо, со пес обачіля. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Кана оне вакєренас і думіненас, коркоро Ісус подавля кє ленде і ґейля ленца андре єкг. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Та оне на прінджярде Лес, бо ленґєре якгендар ода есас запганло. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ісус лендар пгучля: — Пал состе тумен вакєрен машкар туменде пало дром? Оне терділе смутне муєнца. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Єкг лендар, савес вічіненас Клеопа, отпгендя: — Одалендар, ко авля андро Єрусалім, Ту єкг на джянес ода, со обачіляпес андре адала дівеса? ");
INSERT INTO rmczrb_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ов пгендя ленґє: — Пал состе Ме на джянав? І оне розвакєрде Лескє: — Пало ода, со пес обачіля ле Ісусога андал Назарет. Ов есас пророкос, зорало андро ода, со кєрелас, те андро лав анґлал о Дейл те анґлал саворе мануша. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Лес дине аврі єкг баредер рашая а те амаре пгуредера, гой те засудзінен Лес про мерібе, а паліш премарде Лес про кєрестос. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","А амен самас бійзошне, гой Ов гіно Ода, Саво маїнел те ратинен ле Ізраєль. Та канакє тріто дівес, сар када саворо ачіля. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Але варесаве амаре ромнєндар зачудалінде амен. Оне ґейле дадіве тосара кє гробніца ");
INSERT INTO rmczrb_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","і, сар на аракгле Лескєро тєлос, оне вісаліле і розвакєрде аменґє, со ленґє сікадепес анґєла, саве пгенде, со Ов гіно джівдо. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Паліш вареко амаре баратендар ґейле ко гробніца і аракгле одя саворо авка, сар вакєренас о ромня, а Лес одя оне на дикгле. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Паліш Ов ленґє пгендя: — Саве тумен наґодявер, сар половкєс тумен патян саворескє, со вакєренас пророка! ");
INSERT INTO rmczrb_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Чі на маїндя Хрістос те преджян саворо када семведипе, а паліш те заджян андре Пескєрі слава? ");
INSERT INTO rmczrb_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Паліш кєздиндя ле Моїсєйостар і саворе пророкендар, і пгутердя ленґє саворо, со есас пісіме пал Лесте андро Пісаніє. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Кана оне пашес авле ко ода ґав, кай оне джянас, Ісус диня ленґє те джянен, гой Ов камел те джян дуредер. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Та оне іґєн манґєнас Лес і вакєренас: — Ач аменца. Аврі іма ратісальол і ачел цма! І Ов заавля андро кгєр і ачіля ленца. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Кана Ісус бешелас ленца пажо скамін, Ов іля маро, палікєрдя, препгаґля і диня ленґє. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Акор пгутердепес ленґєре якга, і оне прінджярде Лес. Та Ов ачіля пріґ ленде надикгадо. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Оне кєздинде те вакєрен єкг аврескє: — Чі на лаболас андре аменде о їло, кана Ов вакєрелас аменца пало дром і кана пгутерелас аменґє Пісаніє? ");
INSERT INTO rmczrb_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Оне єкгваресте ушіле і ґейле минґ єкгвар андро Єрусалім. Одя оне аракгле андро єкг тган дешуєкг апостолен і саворен, ко есас ленца. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Одала ленґє пгенде, со о Рай те чачес джівдісаліля мерібнастар і сікадяпес ле Сімоноскє. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Паліш одала дувджяне розвакєрде саворо, со ленца есас про дром, і сар оне прінджярде ле Ісус, кана Ов препгаґля о маро. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Оне минґ вакєренас, кана Коркоро Ісус сікадяпес машкар ленде і пгендя ленґє: — Мірос туменґє! ");
INSERT INTO rmczrb_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","А оне ле даратар аж замувле, бо думіненас, со дикгєн ле духос. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Та Ов ленґє пгендя: — Состар сан айсе предараде, і соске тумен на патян? ");
INSERT INTO rmczrb_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Дикгєн, акєс Мійре васта те Мійре піндре. Ода Ме сом! Худенпес Мандар і дикгєн, бо ко духос тєлос і кокала нане, а, сар дикгєн, кє Манде гін. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","І сар ода пгендя, сікадя ленґє о васта те о піндре. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Та оне радисальонас і чудаліненаспес, та нісар на патянас. Акор Ов лендар пгучля: — Чі гін тумен аде варесо те захан? ");
INSERT INTO rmczrb_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Оне подине Лескє котор пейка мачатар. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ов іля і халас анґлал ленде. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Паліш Ов пгендя ленґє: — Пало ода Ме вакєравас туменґє, кана минґ сомас туменца: саворо, со гін пісіме пал Манде андро Моїсєйоскєро Законос, ко пророка і андро псалмі, маїнелпес те обачен. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Акор Ов пгутердя ленґє е ґовді, гой те ахальон Пісаніє, ");
INSERT INTO rmczrb_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","і пгендя ленґє: — Пісіме, со Хрістос маїнел те семвединен, а про тріто дівес те джівдісальон ле мерібнастар. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Анґлал андро Єрусалім, а паліш машкар саворе нийпі андро Лескєро нав вічінена ле манушен те покаїненпес, гой те одмукєнпес ленгє о бійне. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Тумен вакєрена пало ода саворе манушенґє. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","А канакє Ме бічавав туменґє ода, со обіціндя Мійро Дад. Та тумен ачен андро фоврос, адик на авела пре туменде е зор опрунестар. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Паліш Ісус ліґєндя лен андал о фоврос кє Віфанія. Одя Ов ваздня Пескєре васта і благословіндя лен. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","І обачіляпес авка, кана Ов благословінелас лен, Ов ачіля те дурісальон лендар і кєздиндя те вазденпес про нєбос. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Акор оне банділе анґлал Лесте і баре радишаґога вісаліле андро Єрусалім. ");
INSERT INTO rmczrb_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Оне міндик аченас андро храмос і ашаренас ле Девлес.");
ALTER TABLE rmczrb_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
