﻿USE sofia;
DROP TABLE IF EXISTS sofia.rki_vpl;
CREATE TABLE rki_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES rki_vpl WRITE;
INSERT INTO rki_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","အာဗြဟံ၏အနွယ် ဒါဝိဒ်၏အမျိုးမှ ဆင်းသက်လာသော ယေသျှု ခရစ်တော်၏ ဆွီစဉ်မျိုးဆက်စာရင်းမှာ ဤသို့ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","အာဗြဟံသည် ဣဇာက်၏ အဖ ဖြစ်၏၊ ဣဇာက်သည် ယာကုပ်၏ အဖ၊ ယာကုပ်သည် ယုဒနှင့် သူ့ညီအစ်ကို မောင်နှမတစ်စု၏ အဖ၊ ");
INSERT INTO rki_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ယုဒသည် မယားတမာနှင့် မွီးသောသား ဖာရက်နှင့် ဇာရရို့၏ အဖ၊ ဖာရက်သည် ဟေဇရုံ၏ အဖ၊ ဟေဇရုံသည် အာရံ၏ အဖ၊ ");
INSERT INTO rki_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","အာရံသည် အမိနဒပ်၏ အဖ၊ အမိနဒပ်သည် နာရှုန်၏ အဖ၊ နာရှုန်သည် စာလမုန်၏ အဖ၊ ");
INSERT INTO rki_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","စာလမုန်သည် မယားရာခပ်နှင့် မွီးသော ဗောဇ၏ အဖ၊ ဗောဇသည် မယားရုသနှင့် မွီးသော သြဗက်၏ အဖ၊ သြဗက်သည် ယေသျှဲ၏ အဖ၊ ");
INSERT INTO rki_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ယေသျှဲသည် ဒါဝိဒ်မင်းကြီး၏ အဖ ဖြစ်၏။ ဒါဝိဒ်မင်းကြီးသည် မယားဥရိယနှင့် မွီးသော သျှောလမုန်၏ အဖ၊ ");
INSERT INTO rki_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","သျှောလမုန်သည် ရောဗောင်၏ အဖ၊ ရောဗောင်သည် အဘိယ၏ အဖ၊ အဘိယသည် အာသ၏ အဖ၊ ");
INSERT INTO rki_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","အာသသည် ယောသျှဖတ်၏ အဖ၊ ယောသျှဖတ်သည် ယဟောရံ၏ အဖ၊ ယဟောရံသည် ဩဇိ၏ အဖ၊ ");
INSERT INTO rki_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ဩဇိသည် ယောသံ၏ အဖ၊ ယောသံသည် အာခတ်၏ အဖ၊ အာခတ်သည် ဟေဇကိ၏ အဖ၊ ");
INSERT INTO rki_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ဟေဇကိသည် မနာသျှေ၏ အဖ၊ မနာသျှေသသည် အာမုန်၏အဖ၊ အာမုန်သည် ယောသျှိ၏ အဖ၊ ");
INSERT INTO rki_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ဗာဗုလုန်ပြည်သို့ ဣသရေလအမျိုးသားတိအား ဖမ်းဆီးခေါ်ဆောင်လားချိန်၌ ယောသျှိသည် ယေခေါနိနှင့် သူ၏ညီအစ်ကိုများ၏ အဖ ဖြစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ဗာဗုလုန်ပြည်မှ ဣသရေလလူမျိုးတိ ပြန်လာပြီးနောက်၊ ယေခေါနိသည် သျှာလသေလ၏ အဖ ဖြစ်၏။ သျှာလသေလသည် ဇေရုဗဗေလ၏ အဖ၊ ");
INSERT INTO rki_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ဇေရုဗဗေလသည် အာဗျုဒ်၏ အဖ၊ အာဗျုဒ်သည် ဧလျှာကိမ်၏ အဖ၊ ဧလျှာကိမ်သည် အာဇော်၏ အဖ၊ ");
INSERT INTO rki_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","အာဇော်သည် ဇာဒုတ်၏ အဖ၊ ဇာဒုတ်သည် အာခိမ်၏ အဖ၊ အာခိမ်သည် ဧလုဒ်၏ အဖ၊ ");
INSERT INTO rki_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ဧလုဒ်သည် ဧလာဇာ၏ အဖ၊ ဧလာဇာသည် မဿန်၏ အဖ၊ မဿန်သည် ယာကုပ်၏ အဖ ");
INSERT INTO rki_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ယာကုပ်သည် မာရိ၏ လင်ယောက်ျား ယောသပ်၏ အဖ၊ မာရိသည် ခရစ်တော်ဟု ခေါ်သော ယေသျှုကို မွီးသော အမိ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ဤကား အာဗြဟံမှ ဒါဝိဒ်အထိ ဆွီစဉ်မျိုးဆက် တစ်ဆယ့်လေးဆက်၊ ဒါဝိဒ်မှ ဗာဗုလုန်ပြည်သို့ ဣသရေလလူမျိုးတိကို အကျဉ်းသားအဖြစ် ဖမ်းဆီးခေါ်ဆောင်ခံရသည့် အချိန်ထိ တစ်ဆယ့်လေးဆက်၊ ဗာဗုလုန်ပြည်မှ ထွက်လားသော အချိန်မှ ခရစ်တော်မွီးဖွားသည့် အချိန်ထိ ဆွီစဉ်မျိုးဆက် တစ်ဆယ့်လေးဆက် ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","ယေသျှု ခရစ်တော်၏ ဖွားမြင်တော်မူခြင်းမှာ ဤသို့ဖြစ်၏။ ယောသပ်နှင့် စိ့စပ်ပြီးနောက် ပေါင်းသင်းနီထိုင်ခြင်း မပြုခင် မယ်တော်မာရိသည် သန့်ယှင်းသောဝိညာဉ်တော်အားဖြင့် ပဋိသန္ဓေ စွဲနိန်၏။ ");
INSERT INTO rki_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ယောသပ်သည် ဖြောင့်မတ်သောသူ ဖြစ်သည်နှင့်အညီ မာရိကို လူပုံအလည်၌ အသရေမပျက်စီလို၍ လူသိသျှင်ကြား စိ့စပ်ထားသည်ကို တိတ်တဆိတ် ဖျက်သိမ်းရန် ကြံစည်နိန်၏။ ");
INSERT INTO rki_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ထိုသို့ ကြံစည်နိန်စဉ်တွင် အိပ်မက်ထဲ၌ သခင်ဘုရား၏ ကောင်းကင်တမန်တစ်ပါးသည် ပေါ်လာ၍ “ဒါဝိဒ်အမျိုး ယောသပ်၊ မာရိကို မယားအဖြစ် ပေါင်းသင်းနီထိုင်ဖို့ရန် မကြောက်ကေ့။ သူမ၏ကိုယ်ဝန်သည် သန့်ယှင်းသောဝိညာဉ်တော်အားဖြင့် ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","သူမသည် သားယောက်ျားကို ဖွားမြင်လိမ့်မည် — သူ၏လူတိကို အပြစ်မှ ကယ်တင်မည့်သူဖြစ်သောကြောင့် — သူ့ကို ယေသျှုဟူ၍ အမည်မှည့်ရလိမ့်မည်” ဟု ကောင်းကင်တမန်က ပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","အကြောင်းမူကား၊ ထာဝရဘုရားသည် ပရောဖက်အားဖြင့် မိန့်မှာထားသော ဗျာဒိတ်တော်အားလုံး ပြည့်စုံရန် ဖြစ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","ဗျာဒိတ်တော်သည်ကား “အပျိုစင်တစ်ယောက်သည် ပဋိသန္ဓေတည်၍ သားယောက်ျားကို ဖွားမြင်လိမ့်မည်၊ ထိုသားကို ဧမာနွေလဟူ၍ အမည်မှည့်ရလိမ့်မည်” ဟု လာသတည်း (ဧမာနွေလ၏အဓိပ္ပာယ်ကား “ငါရို့နှင့်အတူဟိသော ဘုရားသခင်” ဖြစ်၏)။ ");
INSERT INTO rki_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ယောသပ်သည် အိပ်ပျော်ရာမှ နိုးလာပြီးလျှင် သခင်ဘုရား၏ ကောင်းကင်တမန် မှာထားသည့်အတိုင်း မာရိကို လက်ထပ်ထိမ်းမြားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","သို့ရာတွင် သားကို ဖွားမြင်ပြီးသည့်တိုင်အောင် ယောသပ်သည် မာရိနှင့် ယှက်တင်ခြင်းကို မပြုဘဲ နိန်လေ၏။ ထို့နောက် ယောသပ်သည် ထိုသားကို ယေသျှု ဟူ၍ နာမည်မှည့်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ဟေရုဒ်မင်းကြီး နန်းစံကာလ၊ ယုဒပြည် ဗက်လင်မြို့၌ ယေသျှုကို ဖွားမြင်ခလေ၏။ ဖွားမြင်တော်မူပြီးနောက် အရှိ့အရပ်မှ နက္ခတ်ပညာဟိတချို့သည် ယေရုဆလင်မြို့သို့ ရောက်လာကြပြီးလျှင် ");
INSERT INTO rki_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“ဖွားမြင်တော်မူသော ယုဒလူမျိုးတိ၏ သျှင်ဘုရင်သည် ဇာနီရာမှာဟိလဲ။ ငါရို့သည် အရှိ့အရပ်၌ သူ၏မွီးနက္ခတ်နှင့်ဆိုင်သော ကြယ်ကို မြင်ရ၍ သူ့ကို ဖူးမြော်ရန် လာကြသည်” ဟု ပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ဤအကြောင်းကို ဟေရုဒ်မင်းကြားသော် မင်းကြီးနှင့်အတူ ယေရုဆလင်မြို့၌ ဟိသော အပေါင်းအဖော်များသည် အလွန်စိတ်နှလုံးမငြိမ်မသက် ဖြစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ဟေရုဒ်မင်းသည် ယဇ်ပုရောဟိတ်အကြီးတိနှင့် ကျမ်းတတ်ဆရာတိအားလုံးကို ခေါ်၍ “ခရစ်တော်ကို ဇာအရပ်မှာ ဖွားမြင်လိမ့်မည်နည်း” ဟု မိန်း၏။ ");
INSERT INTO rki_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","“ယုဒပြည် ဗက်လင်မြို့၌ ဖြစ်ပါ၏၊ အကြောင်းမူကား၊ ပရောဖက် ရီးထားခသည်မှာ၊ ");
INSERT INTO rki_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“ ‘အို၊ ယုဒပြည် ဗက်လင်မြို့၊ သင်သည် ယုဒပြည်၏မြို့များထဲမှာ သိမ်ငယ်သောမြို့ တစ်မြို့ မဟုတ်။ ငါ၏ဣသရေလလူမျိုးတိကို လမ်းပြမည့် ခေါင်းဆောင်တစ်ယောက်သည် သင်၏အထဲမှ ပေါ်ထွန်းလာလိမ့်မည် ဟူ၍ ဖြစ်သည်’ ” ဟု သူရို့က ဖြေကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","ထိုစကားကို ကြားသည်နှင့် ဟေရုဒ်မင်းကြီးသည် အရှိ့အရပ်က နက္ခတ်ပညာဟိများကို တိတ်တိတ်ချေ ခေါ်ပြီးလျှင် ကြယ်ပေါ်ချိန် အတိအကျကို မိန်းလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","“သင်ရို့သည် လား၍ သူငယ်ကို စိ့စိ့စပ်စပ် ရှာကတ်၊ ငါလည်း သူ့ကို လား၍ ဖူးမြော်ချင်သည်ဖြစ်၍ တွိ့လျှင် ငါ့ကို ပြောကြလော့” ဟု ပြောကာ မင်းကြီးက နက္ခတ်ပညာဟိရို့ကို ဗက်လင်မြို့သို့ ရွှတ်လိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","ထိုသူရို့သည် မင်းကြီးစကားကို နာခံပြီးနောက် ထွက်လာကြ၏၊ အရှိ့အရပ်၌ သူရို့ မြင်ခသည့် ကြယ်သည် သူရို့၏ရှိ့က လားလေ၏၊ သူငယ်ဟိရာအရပ်၏ အထက်တည့်တည့်သို့ ရောက်သောအခါ ထိုကြယ်သည် တန့်နိန်၏။ ");
INSERT INTO rki_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","သူရို့သည် ထိုကြယ်ကို မြင်ကြသောအခါ အလွန် ဝမ်းမြောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ကြယ်ပညာဟိရို့သည် အိမ်ထဲသို့ ဝင်ကြသောအခါ မိခင်မာရိနှင့်အတူ သူငယ်ကို တွိ့ကြသဖြင့် သူငယ်ကို ပျပ်ဝပ်လျက် ကိုးကွယ်ကြ၏။ သူရို့ယူလာသော လောဗန်၊ မုရန်၊ ရွှီ စသော လက်ဆောင်များကို ထုတ်၍ သူငယ်ကို ပူဇော်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ဘုရားသခင်က ဟေရုဒ်မင်းကြီးထံပါးသို့ ပြန်၍ မလားကြရန် အိပ်မက်ထဲ၌ နက္ခတ်ပညာဟိရို့ကို ပြောထားပြီးဖြစ်သောကြောင့် သူရို့သည် မိမိတိုင်းပြည်သို့ အခြားသောလမ်းဖြင့် ပြန်လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","နက္ခတ်ဗေဒပညာဟိရို့ ထွက်လားပြီးနောက် သခင်ဘုရား၏ ကောင်းကင်တမန်တစ်ပါးက ယောသပ်အား “ဟေရုဒ်မင်းကြီးသည် ဤသူငယ်ကို သတ်ခြင်းငှာ လိုက်ရှာနိန်၏။ ယေဇူးနန့် ထလော့၊ သူငယ်နှင့် သူ၏အမိကို ခေါ်၍ အဲဂုတ္တုပြည်သို့ ထွက်ဗြီးလားလီ၊ သင့်ကို ငါ တစ်ခုခု မပြောမချင်း အဲဂုတ္တုပြည်မှ ထွက်မလာကတ်ကေ့” ဟု အိပ်မက်ပီး၏။ ");
INSERT INTO rki_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ထို့ကြောင့် ယောသပ်သည် ချက်ချင်း ထ၍ သူငယ်နှင့် အမိကို ခေါ်၍ ညတွင်းချင်း အဲဂုတ္တုပြည်သို့ ထွက်ဗြီးကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ဟေရုဒ် အနိစ္စရောက်သည့်တိုင်အောင် အဲဂုတ္တုပြည်၌ နီထိုင်ကြလေ၏။ ဤကား “ငါ့သားသျှေကို အဲဂုတ္တုပြည်မှ ငါ ကိုယ်တိုင် ခေါ်ထုတ်လာမည်” ဟူသော ထာဝရဘုရားက ပရောဖက်အားဖြင့် ဟောထားခသောစကားသည် ပြည့်စုံခြင်းသို့ ရောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","ဟေရုဒ်သည် နက္ခတ်ပညာဟိရို့က မိမိအား လှည့်ဖျားလားခသည်ကို သိသောအခါ အလွန်ဒေါသဖြစ်လေ၏။ သို့ဖြစ်၍ သူသည် နက္ခတ်ပညာဟိရို့ပါးမှာ မိန်းမြန်းလေ့လာထားသော အချိန်ကာလအရ ဗက်လင်မြို့နှင့် အနီးတဝိုက်၌ ဟိကြသော အသက်နှစ်နှစ်နှင့် နှစ်နှစ်အောက် ယောက်ျားသူငယ်တိအားလုံးကို သတ်ရန် အမိန့်ထုတ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ထိုအခါ ပရောဖက် ယေရမိအားဖြင့် ဟောထားခစကားသည် ပြည့်စုံခြင်းသို့ ရောက်လေ၏။ သူ၏စကားမှာ၊ ");
INSERT INTO rki_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“ရာမအရပ်၌ ကြီးစွာသော ငိုကျွီးမြည်တမ်းသံကို ကြားရ၍၊ ရာခေလမှာ မိမိ၏သူငယ်တိအတွက် ငိုနိန်ရ၏၊ သို့ဖြစ်၍ ဖြေမဆည်နိုင် ဖြစ်ရလေ၏၊ အကြောင်းမူကား၊ သူငယ်တိအားလုံး သီကျလား၍ ဖြစ်၏” ဟူ၍ ဖြစ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ဟေရုဒ် အနိစ္စရောက်ပြီးနောက် အဲဂုတ္တုပြည်တွင် ယောသပ်၏အိပ်မက်ထဲ၌ သခင်ဘုရား၏ ကောင်းကင်တမန်တစ်ပါး ပေါ်လာ၍ ");
INSERT INTO rki_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“ယောသပ်၊ ထလော့၊ သူငယ်နှင့် သူ၏အမိကို ခေါ်ပြီးလျှင်၊ ဣသရေလပြည်သို့ ပြန်လားကတ်လီ၊ သူငယ်၏အသက်ကို သတ်ဖို့လူတိ သီကျလားပြီးယာ” ဟု ပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ထိုအခါ ယောသပ်သည် သားအမိနှစ်ယောက်ကို ခေါ်၍ ဣသရေလပြည်သို့ ပြန်လာလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","ထိုအချိန်၌ ဟေရုဒ်၏သား အာခေလသည် ယုဒပြည်၏ဘုရင်အဖြစ် ခမည်းတော်နန်းရာကို ဆက်ခံနိန်သည်ကို ကြားသဖြင့် ယောသပ်သည် ယင်းပြည်သို့ ပြန်လားဖို့ရန် ကြောက်နိန်၏။ အိပ်မက်ထဲ၌ ဗျာဒိတ်တော်ကို မြင်ပြီးခါမှသာ၊ ဂါလိလဲနယ်ထဲသို့ ဝင်ရောက်ကာ ");
INSERT INTO rki_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","နာဇရက်ဟုခေါ်သော မြို့တစ်မြို့တွင် နီထိုင်လေ၏။ ထို့ကြောင့် “ကိုယ်တော်အား နာဇရက်မြို့သားဟု ခေါ်ဝေါ်ကြလိမ့်မည်” ဟူသော ပရောဖက်တိအားဖြင့် ဟောထားခသောစကားသည် ပြည့်စုံခြင်းသို့ ရောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ထိုအချိန်၌ ဗတ္တိဇံယောဟန်သည် ယုဒပြည်၏ တောကန္တာရတွင် တရားတော်ကို စတင်ဟောပြောလျက်ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","သူဟောပြောသည်မှာ “ကောင်းကင်နိုင်ငံတော် တည်လုနီးပြီ ဖြစ်သောကြောင့် သင်ရို့သည် အပြစ်မှ နောင်တရကြပါ” ဟူ၍ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ပရောဖက်ဟေသျှာယက “တောကန္တာရထဲ၌ အော်ဟစ်နိန်သော သူ၏အသံမှာ၊ ‘ထာဝရဘုရား အတွက် လမ်းကို ပျင်ဆင်ကြလော့၊ ကိုယ်တော်အတွက် လမ်းကို ဖြောင့်စီကြလော့’” ဟူ၍ ဟောပြောခသည်မှာ ထိုယောဟန်ကို ဆိုလိုသတည်း။ ");
INSERT INTO rki_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ယောဟန်သည် ကုလားအုတ်အမွှီးနှင့် ရက်လုပ်ထားသော ဝတ်ရုံကိုဝတ်၍ ခါး၌ သားရီခါးပတ်ကို ပတ်ပြီးလျှင် ကျိုင်းကောင်နှင့် တောပျားရည်ကို စားသောက်လျက်နိန်၏။ ");
INSERT INTO rki_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","ယော်ဒန်မြစ်ဝှမ်းဒေသအားလုံးမှစ၍ ယေရုဆလင်မြို့အပါအဝင် ယုဒပြည်တဝှမ်းလုံးမှ လူအပေါင်းရို့သည် ယောဟန်ပါးသို့ ရောက်လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","သူရို့သည် မိမိ အပြစ်တိကို ဝန်ခံကြပြီးနောက် ယောဟန်သည်လည်း သူရို့အား ယော်ဒန်မြစ်၌ ဗတ္တိဇံကို ပီး၏။ ");
INSERT INTO rki_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ဖာရိယှဲရို့နှင့် ဇဒ္ဒုကဲရို့သည် ဗတ္တိဇံခံရန် လာကြသည်ကို ယောဟန် မြင်လျှင် “မြွီဆိုးအမျိုးတိ၊ သင်ရို့သည် ရောက်လတ္တံ့သော ဘုရားသခင်၏ အပြစ်စီရင်ခြင်းမှ လွတ်လိမ့်မည်ဟု ဇာသူက ပြောသနည်း။ ");
INSERT INTO rki_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","သင်ရို့သည် နောင်တရကြောင်းကို သင်ရို့အကျင့်နှင့် သက်သီ ပြကြလော့။ ");
INSERT INTO rki_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","သင်ရို့သည် အာဗြဟံအမျိုးဖြစ်၍ အပြစ်စီရင်ခြင်းမှ လွတ်လိမ့်မည်ဟု မထင်ကတ်ကေ့။ ငါဆိုသည်ကား ဘုရားသခင်သည် ဤကျောက်တုံးတိကို ပင်လျှင် အာဗြဟံ အမျိုးဖြစ်အောင် ဖန်ဆင်းနိုင်၏။ ");
INSERT INTO rki_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ကောင်းသောအသီးကို မသီးသောအပင်ဟိသမျှကို ခွတ်ပြီးလျှင် မီးထဲသို့ ချလိုက်ခြင်းငှာ ပေါက်ဆိန်ကို အပင်ခြီရင်း၌ အဆင်သင့် ထားလျက်ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","သင်ရို့ နောင်တရကြောင်းကို ပြသည့်အနိန်ဖြင့် ငါသည် သင်ရို့အား ရီ၌ ဗတ္တိဇံကို ပီး၏။ ငါ့နောက်မှ ကြွလာမည့်သူသည် ငါ့ထက်ကြီးမြတ်သူဖြစ်၍ ထိုသူသည် သင်ရို့အား သန့်ယှင်းသော ဝိညာဉ်တော်၌ လည်းကောင်း၊ မီး၌ လည်းကောင်း ဗတ္တိဇံကို ပီးလိမ့်မည်။ သူ၏ခြီနင်းတော်ကို ကိုင်ဆောင်ခြင်းငှာ ငါသည် မထိုက်တန်။ ");
INSERT INTO rki_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ထိုသူသည် မိမိ၏ ကောက်နယ်တလင်းကို ယှင်းလင်းရန် လက်၌ ဆန်ကောကို ကိုင်ထားတော်မူသည်ဖြစ်၍ ဂျုံစပါးတိကို ပုတ်ထဲတွင် စုသိမ်းပြီးလျှင် အဖျင်းတိကိုမူကား မငြိမ်းနိုင်သောမီးထဲ၌ လောင်ကျွမ်းစီတော်မူလိမ့်မည်” ဟု သူရို့ကို ပြောဆို၏။ ");
INSERT INTO rki_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","ထိုအချိန်၌ ယေသျှုသည် ယောဟန်ထံပါးတွင် ဗတ္တိဇံကို ခံယူရန် ဂါလိလဲနယ်မှ ယော်ဒန်မြစ်နားသို့ ရောက်လာ၏။ ");
INSERT INTO rki_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","“အကျွန်သည်သာ ကိုယ်တော့်ထံ၌ ဗတ္တိဇံကို ခံယူထိုက်သည်ဖြစ်၍ အကျွန့်ပါးသို့ ကိုယ်တော်ကြွလာခြင်းသည် အကျွန်နှင့် မထိုက်တန်ပါ” ဟု ယောဟန်က ဟန့်တားရန် ကြိုးစားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","သို့သော် ယေသျှုက “ငါရို့သည် ဘုရားသခင် အလိုတော်ဟိသမျှတိကို လုပ်ဆောင်ရမည်ဖြစ်သောကြောင့် အဂုပင် လုပ်ခွင့်ပီးပါ” ဟု ပြန်ပြောတော်မူ၏။ ထိုအခါ ယောဟန်သည် ဝန်ခံလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ယေသျှုသည် ဗတ္တိဇံကို ခံယူပြီး၊ ရီထဲမှ ထလာစဉ်တွင် ကောင်းကင်ဖွင့်လှစ်၍ ဘုရားသခင်၏ဝိညာဉ်တော်သည် မိမိအထက်၌ ဂြိုးငှက်ကဲ့သို့ ဆင်းသက်လာသည်ကို ကိုယ်တော်သည် မြင်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ထို့နောက် “ဤသူကား ငါနှစ်သက်မြတ်နိုးသော ငါ၏ချစ်သား ဖြစ်၏” ဟူသော ကောင်းကင်မှ အသံတော် ထွက်လာလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ထို့နောက် ဝိညာဉ်တော်သည် ယေသျှုကို တောကန္တာရထဲသို့ ပို့ဆောင်ပြီးလျှင် မာရ်နတ်၏ စုံစမ်းခြင်းကို ခံတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ယေသျှုသည် ရက်လေးဆယ်ပတ်လုံး အစာယှောင်ပြီးနောက် အလွန်ဆာမွတ်လျက်ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ထိုအခါ မာရ်နတ်သည် ရောက်လာပြီးလျှင် “သင်သည် ဘုရားသခင်၏ သားမှန်လျှင် ဤကျောက်ခဲတိကို မုန့်ဖြစ်အောင် အမိန့်ပီးတော်မူပါ” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ယေသျှုက “ကျမ်းစာလာသည်ကား၊ ‘လူသည် အစာအားဖြင့်သာ အသက်ရှင်သည်မဟုတ်၊ ဘုရားသခင် မိန့်တော်မူသမျှအားဖြင့်သာ အသက်ရှင်ရမည်’” ဟု ပြန်၍ မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ထို့နောက် မာရ်နတ်သည် ယေသျှုကို သန့်ယှင်းသောမြို့တော် ယေရုဆလင်သို့ ခေါ်ဆောင်၍ ဗိမာန်တော်၏ အမြင့်ဆုံးအထွဋ်၌ တင်ထားပြီးလျှင် ");
INSERT INTO rki_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ကျမ်းစာလာသည်ကား၊ “ဘုရားသခင်က သူ၏ကောင်းကင်တမန်တိကို သင့်အဖို့ မိန့်မှာတော်မူထားသည်ဖြစ်၍၊ သူရို့သည် မိမိရို့၏လက်များဖြင့် သင့်ကို ပင့်ချီထားကြလိမ့်မည်၊ ထို့ကြောင့် သင်၏ခြီကို ကျောက်နှင့် မထိမခိုက်စီရ၊ သို့ဖြစ်၍ သင်သည် ဘုရားသခင်၏သားမှန်လျှင် ခုန်ချလိုက်ပါ” ဟု ဆိုလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ယေသျှုက “သင်၏ဘုရားသခင် ထာဝရဘုရားကို စုံစမ်းခြင်း မပြုရဟူ၍ ကျမ်းစာ၌ ရီးထား၏” ဟု ပြန်၍ မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ထို့နောက် မာရ်နတ်သည် ယေသျှုကို အလွန်မြင့်မားသော တောင်ထိပ်သို့ ခေါ်ဆောင်၍ လောကီနိုင်ငံအသီးသီးနှင့်တကွ ထိုနိုင်ငံများ၏ ကြီးကျယ်ခန့်နားမှုများကို ပြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","မာရ်နတ်က “သင်သည် ငါ့ကို ပျပ်ဝပ်လျက် ကိုးကွယ်လျှင် ဤအရာ အားလုံးတိကို သင့်အား ငါပီးမည်” ဟု ပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ထိုအခါ ယေသျှုက “အချင်း စာတန်၊ ငါနှင့် ဝီးရာသို့ ထွက်လားလီ။ ကျမ်းစာက မိန့်မှာထားသည်မှာ သင်၏ဘုရားသခင် ထာဝရဘုရားသခင်ကိုသာ ကိုးကွယ်ရမည်၊ ထိုဘုရားသခင်၏ အမှုကိုသာ ဆောင်ရွက်ရမည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ထို့နောက် မာရ်နတ်သည် ယေသျှုထံပါးမှ ထွက်လားလေ၏။ ထိုအခါ ကောင်းကင်တမန်တိ ရောက်လာ၍ ကိုယ်တော့်ကို ပြုစုကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","ယောဟန်သည် ထောင်ထဲ၌ ချထားခြင်းကို ခံနိန်ရသည်ကို ယေသျှု ကြားလျှင် ဂါလိလဲပြည်သို့ ကြွလားတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","နာဇရက်မြို့ကို ကျော်ဖြတ်ကာ ဇာဗုလုန်ဒေသနှင့် နဿလိဒေသကြား၊ ဂါလိလဲအိုင်နား၌ဟိသော ကပေရနောင်မြို့၌ နီထိုင်ရန် ကြွတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ဤကား ပရောဖက် ဟေသျှာယအားဖြင့် ဟောထားခသောစကားသည် ပြည့်စုံခြင်းသို့ ရောက်လေ၏။ ထိုစကားမှာ၊ ");
INSERT INTO rki_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“အို၊ ဇာဗုလုန်ဒေသနှင့် နဿလိဒေသတည်းဟူသော ယော်ဒန်မြစ်တစ်ဖက်ကမ်း ပင်လယ်သို့ ထွက်ရာလမ်းတလျှောက်၌ဟိသော တခြားလူမျိုးတိနီထိုင်ရာ ဂါလိလဲပြည်၊ ");
INSERT INTO rki_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","မှောင်မိုက်ထဲ၌ နီထိုင်ကြသောသူတိသည် ကြီးစွာသောအလင်းတစ်ခုကို မြင်ရကြလိမ့်မည်။ သီမင်း၏အရိပ်ဖြစ်သော ထိုပြည်၌ နီထိုင်ကြသော သူရို့တွင် ထိုအလင်းသည် ထွန်းလင်းလာလိမ့်မည်” ဟူ၍ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ထိုအချိန်မှစ၍ ယေသျှုက “ကောင်းကင်နိုင်ငံတော် တည်လုနီးပြီ ဖြစ်သောကြောင့် သင်ရို့သည် အပြစ်မှ နောင်တရကြလော့” ဟူသော တရားတော်ကို စတင်၍ ဟောကြားတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ယေသျှုသည် ဂါလိလဲအိုင်ကမ်းနား၌ ကြွတော်မူစဉ် တံငါညီအစ်ကို နှစ်ယောက်ဖြစ်သော သျှိမုန်ဟု ခေါ်သော ပေတရုနှင့် သူ၏ညီ အန္ဒြေရို့သည် ပိုက်တစ်လက်ဖြင့် အိုင်ထဲမှာ ငါးဖမ်းနိန်သည်ကို တွိ့တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ယေသျှုက “ငါနှင့်အတူ လိုက်ကတ်၊ ငါသည် သင်ရို့အား လူတိကို ဖမ်းဖို့ သင်ပီးမည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","သူရို့သည် ပိုက်တိကို ချက်ချင်း ပစ်ထားခပြီးလျှင် ကိုယ်တော်နောက်သို့ လိုက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","တဖန် ကိုယ်တော်သည် ဆက်လက်၍ ကြွတော်မူလျှင်၊ ဇေဗေဒဲ၏သားနှစ်ယောက်ဖြစ်သော ယာကုပ်နှင့် ယောဟန် ညီအစ်ကိုနှစ်ယောက်ကို မြင်တော်မူ၏။ သူရို့သည် ဖခင်ဇေဗေဒဲနှင့်အတူ ငါးဖမ်းရန် လောင်းထဲ၌ ပိုက်တိကို ပျင်ဆင်နိန်ကြ၏။ ယေသျှုသည် ထိုသူရို့အား နောက်တော်သို့ လိုက်ရန် ခေါ်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","သူရို့သည် ဖခင်နှင့် သူရို့၏လောင်းကို ထားပစ်ခပြီးလျှင် ချက်ချင်း ယေသျှုနောက်သို့ လိုက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ယေသျှုသည် ဂါလိလဲပြည်တစ်ခုလုံးသို့ ကြွတော်မူပြီးလျှင် တရားဇရပ်များ၌ ဘုရားသခင်၏နိုင်ငံတော်နှင့်ဆိုင်သော သတင်းကောင်းကို ဟောကြားတော်မူလျက်၊ မကျန်းမာသူများကို ကျန်းမာစီ၏။ ရောဂါအမျိုးမျိုးကို ခံစားနိန်ကြရသော လူတိကိုလည်း ရောဂါပျောက်ကင်းစီတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ယေသျှု၏သတင်းတော်သည် ယှုရိပြည် တစ်ဝှမ်းလုံးသို့ ပြန့်နှံ့လား၏။ လူတိက သွက်ရှာပါဒရောဂါသည်၊ ဝက်ရူးပြန်ရောဂါသည်၊ နတ်ဆိုးဝင်ပူးနိန်သည့်သူများနှင့် အနာရောဂါအမျိုးမျိုး ခံစားနိန်သူများကို ကိုယ်တော့်ထံပါးသို့ ခေါ်ဆောင်လာကြ၏။ ယေသျှုသည် ထိုသူအားလုံး၏ အနာရောဂါတိကို ပျောက်ကင်းစီတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ဂါလိလဲပြည်၊ ဒေ​က​ပေါ​လိ​ပြည်၊ ယေရုဆလင်မြို့၊ ယုဒပြည်နှင့် ယော်ဒန်မြစ်တစ်ဘက်ကမ်းမှ လူအပေါင်းရို့သည်လည်း ကိုယ်တော်၏နောက်တော်သို့ လိုက်လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ယေသျှုသည် လူအုပ်ကြီးကို မြင်တော်မူလျှင် တောင်ကုန်းထက်သို့ တက်ကြွတော်မူပြီး ထိုနီရာ၌ ထိုင်တော်မူ၏။ တပည့်တော်ရို့သည်လည်း ကိုယ်တော်၏ပတ်လည်၌ ဝိုင်း၍ ထိုင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ထို့နောက် ဆုံးမဩဝါဒများကို ပီးတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“မိမိရို့သည် ဝိညာဉ်ရေးရာ၌ အားနည်းသူများ ဖြစ်ကြောင်း သိသောသူရို့သည် မင်္ဂလာဟိကြ၏၊ ကောင်းကင်နိုင်ငံတော်သည် ထိုသူရို့အတွက် ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","စိတ်မသာ ညည်းတွားလျက်ဟိသော သူရို့သည် မင်္ဂလာဟိကြ၏၊ ဘုရားသခင်သည် သူရို့ကို နှစ်သိမ့်ပီးတော်မူလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","စိတ်နှလုံးနှိမ့်ချသောသူရို့သည် မင်္ဂလာဟိကြ၏။ ထိုသူရို့သည် ဘုရားသခင်ပီးထားသော ကတိတော်ကို ခံစားရလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ဘုရားသခင်အလိုတော်ကို လုပ်ဆောင်လိုစိတ် ပြင်းပြသောသူရို့သည် မင်္ဂလာဟိကြ၏။ ဘုရားသခင်သည် သူရို့၏လိုအင်ဆန္ဒကို ပြည့်စုံစီလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","သူတစ်ပါးကို သနားကရုဏာထားသော သူရို့သည် မင်္ဂလာဟိကြ၏။ ထိုသူရို့သည် ဘုရားသခင်၏ သနားခြင်းကရုဏာကို ခံစားရကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","စိတ်နှလုံး သန့်ယှင်းဖြူစင်သော သူရို့သည် မင်္ဂလာဟိကြ၏။ သူရို့သည် ဘုရားသခင်ကို မြင်တွိ့ကြရလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ရန်အပေါင်းကို ငြိမ်းချမ်းစီသောသူရို့သည် မင်္ဂလာဟိ၏၊ ထိုသူရို့သည် ဘုရားသခင်၏ သားသမီးများဟု အခေါ်ခံရလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ဘုရားသခင်အလိုတော်ကို လိုက်နာသောကြောင့် ညှဉ်းပန်းနှိပ်စက် ခံရသောသူရို့သည် မင်္ဂလာဟိကြ၏၊ ထိုသူရို့သည် ကောင်းကင်နိုင်ငံတော်ကို အမွီခံရကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“သင်ရို့သည် ငါ့တပည့်ဖြစ်သောကြောင့် လူတိက မဟုတ်မမှန် စွပ်စွဲ၍ အပြစ်ရှာလျက် ညှဉ်းပန်းနှိပ်စက်လာကြသောအခါ သင်ရို့သည် မင်္ဂလာဟိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","အကြောင်းမူကား၊ သင်ရို့အတွက် ကောင်းကင်ဘုံ၌ ပျင်ဆင်ထားသောဆုကျေးဇူးသည် ကြီးမြတ်သည်ဖြစ်၍ ဝမ်းမြောက်ကြလော့။ သင်ရို့ရှိ့က ပေါ်ထွန်းခသော ပရောဖက်တိလည်း ထိုကဲ့သို့ ညှဉ်းပန်းနှိပ်စက်ခြင်းကို ခံခရကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“သင်ရို့သည် ဤလောက၏ ဆား ဖြစ်ကြ၏။ ဆားသည် အငန်ဓာတ်ကင်းပျောက်လားလျှင် ၎င်းကို တဖန်ဇာပိုင် ပြန်ရဖို့သိမ့်လဲ။ အပြင်သို့ ဝေးပစ်ခြင်းခံရပြီး လူတိ ကျော်နင်းခြင်းမှတစ်ပါး တစ်ခုလည်း အသုံးမဝင်ယာ။ ");
INSERT INTO rki_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“သင်ရို့သည် ဤလောက၏အလင်း ဖြစ်ကြ၏၊ တောင်ထိပ်၌ တည်ထားသောမြို့ကို ကွယ်ဝှက်၍ မရနိုင်။ ");
INSERT INTO rki_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","မီးခွက်ထွန်းပြီး တောင်းနှင့် အုပ်ထားသောသူဟူ၍ မဟိ၊ တစ်အိမ်လုံးကို အလင်းရစီခြင်းငှာ မီးခွက်စင်ထက်မှာသာ တင်၍ ထွန်းထားလေ့ဟိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","ထိုနည်းတူ လူတိုင်းသည် သင်ရို့ပြုသော ကောင်းသောအကျင့်တိကို မြင်၍ ကောင်းကင်ဘုံ၌ ဟိတော်မူသော သင်ရို့အဖကို ချီးမွမ်းစီခြင်းငှာ သင်ရို့၏အလင်းကို လူတိရှိ့မှာ လင်းကြလော့။ ");
INSERT INTO rki_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“မောသျှေ၏ပညတ်ကျမ်းနှင့် ပရောဖက်များ၏ကျမ်းတိကို ပယ်ဖျက်ခြင်းငှာ ငါလာသည် မဟုတ်။ ထိုကျမ်းတိကို ပယ်ဖျက်ခြင်းငှာ ငါလာသည် မဟုတ်၊ ပြည့်စုံစီခြင်းငှာ ငါလာ၏။ ");
INSERT INTO rki_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","ငါသည် သင်ရို့အား အမှန်ဆိုသည်ကား ကောင်းကင်နှင့် မြီကြီး တည်သရွေ့ကာလပတ်လုံး ပညတ်ကျမ်း၏ အငယ်ဆုံးသောစာလုံးနှင့် အငယ်ဆုံးသော ဝစ္စတစ်လုံးမျှ ပြည့်စုံခြင်းသို့ မရောက်ခင် မပျက်စီးစီရ။ ");
INSERT INTO rki_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ယေဇူးနန့် အငယ်ဆုံးသောပညတ်ကို လွှဲမှားစွာခံယူပြီး၊ သူတစ်ပါးကိုလည်း လွဲမှားစွာ သွန်သင်သောသူသည် ကောင်းကင်နိုင်ငံ၌ အငယ်ဆုံးသောသူ တစ်ယောက်သာ ဖြစ်လိမ့်မည်။ ထိုကျမ်းများကို တစ်လုံးမကျန် ကိုယ်တိုင် အတိအကျ နာခံပြီး တခြားလူတိကိုလည်း တိကျမှန်ကန်စွာ သင်ပီးသောသူသည် ကောင်းကင်နိုင်ငံတော်၌ အကြီးဆုံးသောသူ ဖြစ်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","ထို့အပြင်၊ ငါဆိုသည်ကား သင်ရို့သည် ဘုရားသခင်၏အလိုတော်ကို လိုက်လျှောက်ရာ၌ ဖာရိယှဲနှင့် ကျမ်းတတ်ဆရာတိ ကျင့်သောအကျင့်ထက် မသာလွန်လျှင် ကောင်းကင်နိုင်ငံတော်သို့ ဝင်ခွင့်ရကြလိမ့်မည် မဟုတ်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“သင်ရို့သည် ‘လူ့အသက်ကို မသတ်ရ၊ သတ်သောသူကား တရားစီရင်ခြင်းကို ခံရမည်’ ဟူသော ရှီးစကားကို ကြားဖူးကြပြီး ဖြစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","သို့သော်၊ သင်ရို့ကို ငါဆိုသည်ကား၊ မိမိညီအစ်ကိုအား စိတ်ဆိုးဒေါသဖြစ်သူသည် တရားရုံး၌ အပြစ်စီရင်ခြင်းကို ခံထိုက်၏၊ မိမိ၏ညီအစ်ကိုတစ်ယောက်ကို ‘အသုံးမကျသောသူ’ ဟု ပြောဆိုသောသူသည် လွှတ်တော်ရုံးရှိ့၌ တရားစီရင်ခြင်းကို ခံထိုက်၏။ မိမိညီအစ်ကိုအား တန်ဖိုးမဟိသောသူ၊ အရူးဟု ပြောဆိုသောသူသည် ငရဲမီးအိုင်ထဲသို့ ပစ်ချခြင်းကို ခံထိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","ထို့ကြောင့် သင်သည် ဘုရားသခင်ကို ပူဇော်သကာပြုခြင်းငှာ ယဇ်ပလ္လင်သို့ လာစဉ်၊ သင်၏ညီအစ်ကို တစ်ယောက်သည် သင်၌ အပြစ်တင်စရာ တစ်စုံတစ်ခု ဟိသည်ဟု သတိရလျှင် ");
INSERT INTO rki_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","သင်၏ပူဇော်သကာကို ယဇ်ပလ္လင်ရှိ့မှာ ချထားခပြီးလျှင် ထိုညီအစ်ကို ပါးသို့ ချက်ချင်း လား၍ အသင့်အတင့်ဖြစ်အောင် လုပ်ပြီးခါမှ ယဇ်ပလ္လင်သို့ ပြန်လာပြီး ထိုပူဇော်သကာကို ဆက်သလော့။ ");
INSERT INTO rki_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“တစ်စုံတစ်ယောက်က သင်ရို့ကို တရားစွဲရန် တရားရုံးသို့ ဆွဲခေါ်လားမည်ဆိုလျှင် တရားရုံးကို မရောက်ခင် လမ်းမှာ ထိုသူကို အချိန်မီ ကြေနပ်အောင် လုပ်လိုက်ပါ။ ထိုသို့ မဟုတ်လျှင် ထိုသူသည် သင့်ကို တရားသူကြီးလက်သို့ အပ်လိမ့်မည်။ တရားသူကြီးက သင့်အား ရဲလက်သို့ အပ်လိမ့်မည်။ ရဲတိက သင့်ကို ထောင်ထဲ၌ ချထားလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","သင်ရို့ကို ငါ အမှန် ဆိုသည်ကား၊ လျော်ပြစ်ငွီဟိသမျှကို မပီးမချင်း သင်သည် ထောင်ထဲက လွှတ်လိမ့်မည် မဟုတ်။ ");
INSERT INTO rki_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“သင်ရို့သည် ‘သူ့မယားကို မပြစ်မှားရ’ ဆိုသည့် စကားကို ကြားဖူးကြပြီးဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","သို့သော်၊ အဂု ငါဆိုသည်ကား၊ ကိလေသာစိတ်နှင့် မိန်းမတစ်ယောက်ကို ကြည့်သောသူသည် ထိုသူ၏စိတ်ထဲ၌ ထိုမိန်းမနှင့် ပြစ်မှားပြီးပြီ။ ");
INSERT INTO rki_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","အကယ်၍ သင်၏ညာဖက်မျက်စိက သင့်အား အပြစ် ဖြစ်စီလျှင် ယင်းမျက်စိကို ဖောက်ထုတ်၍ ဝေးပစ်လိုက်။ သင်၏ခန္ဓာတစ်ခုလုံး ငရဲထဲသို့ ကျသည်ထက် အင်္ဂါတစ်ခု ပျက်လားသည်က သာ၍ ကောင်းပေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","အကယ်၍ သင်၏ညာဖက်လက်က သင့်ကို အပြစ် ဖြစ်စီလျှင် ထိုလက်ကို ဖြတ်၍ ဝေးပစ်လိုက်။ သင်၏ခန္ဓာတစ်ခုလုံး ငရဲထဲသို့ ကျသည်ထက် အင်္ဂါတစ်ခု ပျက်လားသည်က သာ၍ ကောင်းပါ၏။ ");
INSERT INTO rki_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“ ‘မိမိမယားနှင့် ကွာယှင်းလိုသောသူသည် မယားကို ကွာယှင်းစာ ပီးရမည်’ ဟု ရှီးအဆိုဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","သို့သော်၊ အဂုသင်ရို့ကို ငါ ဆိုလိုသည်ကား၊ ဖောက်ပြန်တတ်သော မိန်းမကလွဲ၍ ဇာအကြောင်းနှင့်မဆို မိမိမယားကို ကွာသောသူသည် မိမိမယားကို ပြစ်မှားခြင်းဖြစ်၏။ လင်ကွာထားသောမိန်းမနှင့် ပေါင်သင်းသော ယောက်ျားသည်လည်း သူတစ်ပါးမယားကို ပြစ်မှားခြင်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“သင်ရို့သည် ‘ဘုရားသခင်ရှိ့၌ ကျိန်ဆိုထားသည့် သစ္စာကတိကို မဖျက်ရ၊ ကျိန်ဆိုထားသည့်အတိုင်း လုပ်ရမည်’ ဟု အယင်က လူတိပြောခသောစကားကို ကြားဖူးကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","သို့သော်၊ အဂု သင်ရို့ကို ငါဆိုသည်ကား၊ ဘုရားသခင်ရှိ့၌ ကျိန်ဆိုသစ္စာပြုခြင်း လုံးဝမလုပ်ရ။ ကောင်းကင်ဘုံသည် ဘုရားသခင်၏ ပလ္လင်တော်ဖြစ်သောကြောင့် ကောင်းကင်ဘုံကိုလည်းကောင်း၊ ");
INSERT INTO rki_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ထိုနည်းတူ ဤကမ္ဘာမြီကြီးသည် ဘုရားသခင်၏ ခြီတင်ရာခုံ ဖြစ်သောကြောင့် မြီကြီးကိုလည်းကောင်း၊ ထိုနည်းတူ ယေရုဆလင်မြို့သည် မဟာမင်းကြီး၏ မြို့တော်ဖြစ်သောကြောင့် ဤမြို့ကိုလည်းကောင်း တိုင်တည်၍ မကျိန်ဆိုရ။ ");
INSERT INTO rki_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ထိုနည်းတူ သင်ရို့သည်ကား၊ ဆံချည်တစ်မျှင်ကိုတောင်မှ ဖြူအောင်၊ မဲအောင် မလုပ်နိုင်ကြသည်ဖြစ်၍ မိမိဦးဂေါင်းကိုပင်လျှင် တိုင်တည်၍ မကျိန်ဆိုရ။ ");
INSERT INTO rki_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","ဟုတ်သည်ကို ‘အဟုတ်’ မဟုတ်သည်ကို ‘မဟုတ်’ ဟူ၍သာ ပြောရမည်၊ ဤထက်ပိုသောစကားသည် မကောင်းသောအရာနှင့် စပ်ဆိုင်၏။ ");
INSERT INTO rki_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“သင်ရို့သည် ‘မျက်စိအစား မျက်စိကိုလည်းကောင်း၊ သွားအစား သွားကိုလည်းကောင်း ပီးရမည်’ ဟူသော စကားကို ကြားဖူးကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","သို့ရာတွင် အဂု သင်ရို့ကို ငါ ပြောလိုသည်မှာ၊ သင်ရို့ကို ပြစ်မှားသော ဇာသူ့ကို မဆို လက်တုံ့မပြန်ကတ်ကေ့။ တစ်စုံတစ်ယောက်က သင်၏ညာဖက်ပါးကို သတ်လျှင် ဘယ်ဖက်ပါးကိုပါ လှည့်၍ ပီးလိုက်။ ");
INSERT INTO rki_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","တစ်စုံတစ်ယောက်က သင်၏အင်္ကျီကို လိုချင်လို့ တရားစွဲလာလျှင် သင်၏ ဝတ်ရုံကိုပါ ချွတ်ပီးလိုက်။ ");
INSERT INTO rki_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","တစ်စုံတစ်ယောက်က သင့်အား သူ၏ဝန်ထုပ်ကို ထမ်း၍ မိုင်တိုင်တစ်တိုင် အကွာအဝီးသို့ အနိုင်အထက်ပြု၍ လိုက်ပို့ခိုင်းလျှင် မိုင်တိုင်နှစ်တိုင်ခရီးထိ လိုက်ပို့ပီးလိုက်။ ");
INSERT INTO rki_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","သင်ရို့ကို တောင်းသောသူအား ပီးကတ်ပါ၊ သင်ရို့ပါးက ချီးငှားလိုသောသူကိုလည်း မငြင်းပယ်ကတ်ကေ့။ ");
INSERT INTO rki_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“သင်ရို့သည် ‘မိတ်ဆွီကို ချစ်ကြပါ၊ ရန်သူကို မုန်းကြပါ’ ဟူသော အဆုံးအမကို ကြားဖူးပြီးဖြစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","သို့ရာတွင် အဂု သင်ရို့ကို ငါ ပြောလိုသည်ကား၊ ရန်သူကို ချစ်ကတ်ပါ။ သင်ရို့ကို ညှဉ်းပန်းနှိပ်စက်သော သူတိအတွက် ဆုတောင်းပီးကတ်ပါ။ ");
INSERT INTO rki_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","သို့မှသာ ကောင်းကင်ဘုံ၌ဟိသော သင်ရို့အဖ၏သားသမီးများ ဖြစ်ကြလိမ့်မည်။ အကြောင်းမူကား၊ ကိုယ်တော်သည် ကောင်းသောသူ၊ မကောင်းသောသူတိ အထက်မှာ နီရောင်ခြည်ကို ထွန်းလင်းပီးတော်မူ၏။ သုစရိုက် ပြုသောသူနှင့် ဒုစရိုက် ပြုသောသူတိ အထက်မှာလည်း မိုးကို ရွာသွန်းပီးတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","သင်ရို့အား ချစ်သောသူတိကိုသာ ချစ်ကြမည်ဆိုလျှင် ဘုရားသခင်၏ဆုလာဘ်နှင့် ဇာပိုင် ထိုက်တန်မည်နည်း။ အခွန်ကောက်ခံသောသူရို့တောင်မှ ဤသို့ ပြုကြသည် မဟုတ်လား။ ");
INSERT INTO rki_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","သင်၏မိတ်ဆွီတိကိုသာ ပေါင်းသင်းဆက်ဆံလျှင် ဇာပိုင် ထူးမြတ်မည်နည်း။ သာသနာပလူတိတောင်မှ ထိုသို့ ပြုကြသည် မဟုတ်လား။ ");
INSERT INTO rki_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","သင်ရို့၏ ကောင်းကင်ဘုံသျှင်အဖသည် ပြည့်စုံသည့်နည်းတူ — သင်ရို့သည်လည်း ပြည့်စုံခြင်း ဟိကြလော့။ ");
INSERT INTO rki_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“သင်ရို့သည် ဘာသာရေးဆိုင်ရာ ဝတ္တရားများကို လူအများ မြင်သာအောင် လူမြင်ကွင်းမှာ မလုပ်ဆောင်ကြဖို့ အထူး သတိထားကတ်ပါ။ ယင်းပိုင် လူမြင်ကွင်းမှာ လုပ်ပြလျှင် ကောင်းကင်ဘုံသျှင် သင်ရို့အဖထံတော်ပါးက ဇာဆုကျေးဇူးကိုလည်း ရလိမ့်မည် မဟုတ်။ ");
INSERT INTO rki_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“ထို့ကြောင့် သင်သည် လိုအပ်နိန်သောသူတစ်ယောက်ကို တစ်စုံတစ်ခု ပီးကမ်းစွန့်ကြဲကြသောအခါ လမ်းဆုံလမ်းဝ၌ လည်းကောင်း၊ တရားဇရပ်၌ လည်းကောင်း၊ သူတော်ကောင်းယောင် ဆောင်သောသူရို့ကဲ့သို့ လူမြင်ကောင်းအောင် လုပ်ပြမနိန်ကတ်ကေ့။ သူတော်ကောင်းယောင် ဆောင်သောသူရို့သည် သူရို့ကို လူတိက ချီးမွမ်းစီချင်လို့ ထိုသို့ လုပ်ပြနိန်ကြခြင်း ဖြစ်၏။ ငါ အမှန်ဆိုသည်ကား ထိုသူရို့ လိုချင်စွာကို ရထားကြပြီး ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","သို့ဖြစ်၍ သင်သည် လိုအပ်နိန်သောသူ တစ်ယောက်ကို ကူညီကြသောအခါ သင်၏ အရင်းနီးဆုံး မိတ်ဆွီတစ်ယောက်ကိုတောင်မှ ထိုအကြောင်းကို မသိစီကေ့။ ");
INSERT INTO rki_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ထိုအမှုသည် ထိုသူ တစ်ဦးတစ်ယောက်နှင့်သာ သက်ဆိုင်သောကိစ္စဖြစ်ရမည်။ သို့မှသာ ဆိတ်ကွယ်ရာ၌ သင်ပြုသမျှကို သိမြင်တော်မူသော သင်၏အဖသည် သင်အား အကျိုးကို ထင်ရှားစွာ ပီးတော်မူလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“သင်သည် ဆုတောင်းကြသောအခါ သူတော်ကောင်း ယောင်ဆောင်သောသူတိပိုင် မတောင်းကတ်ကေ့။ သူရို့သည် လမ်းဆုံလမ်းခွ၌ လည်းကောင်း၊ တရားဇရပ်များ၌ လည်းကောင်း သူရို့ကို လူတိုင်းမြင်ကြစီရန် မတ်တပ်ရပ်၍ ဆုတောင်းခြင်းကို နှစ်သက်ကြ၏။ ငါ အမှန်ဆိုသည်ကား သူရို့အလို ပြည့်စုံပြီးဖြစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","သို့ဖြစ်၍ သင်သည် ဆုတောင်းသည့်အခါ အခန်းထဲသို့ ဝင်၍ တန်းခါးကို ပိတ်ပြီးလျှင် လူတိမမြင်နိုင်သော သင်၏အဖကို တောင်းကြလော့။ ဆိတ်ကွယ်ရာအရပ်၌ သင်ပြုသမျှကို သိမြင်တော်မူသော သင်၏အဖသည် သင့်အား ပီးတော်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“သင်သည် ဆုတောင်းသောအခါ သာသနာပလူတိကဲ့သို့ အဓိပ္ပာယ်မဟိသည့် စကားတိနှင့် အထပ်ထပ်မြွတ်ဆို၍ တောင်းမနိန်ကတ်ကေ့၊ သူရို့သည် ဆုအရှည်ကြီးတောင်းလျှင် တောင်းသမျှကို သူရို့ဘုရားတိက ကြားကတ်လိမ့်မည်ဟု ထင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","သူရို့ပိုင် မတောင်းကတ်ကေ့။ သင်မတောင်းခင်ကပင် သင်လိုအပ်သည်ကို သင်၏အဖက သိထားပြီးဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","ထို့ကြောင့် သင်ရို့ ဆုတောင်းရမည်မှာ၊ “ ‘ကောင်းကင်ဘုံသျှင် အကျွန်ရို့၏အဖ၊ ကိုယ်တော်၏ သန့်ယှင်းသောနာမတော်အား ရိုသီလေးမြတ်ခြင်း ဟိကြပါစီသောဝ်။ ");
INSERT INTO rki_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","နိုင်ငံတော် တည်ထောင်ပါစီသောဝ်။ အလိုတော်သည် ကောင်းကင်ဘုံ၌ ပြုသကဲ့သို့ မြီကြီးပေါ်၌ ပြုပါစီသောဝ်။ ");
INSERT INTO rki_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","အကျွန်ရို့လိုအပ်သောအစာကို ဤနိ့ ပီးသနားတော်မူပါ။ ");
INSERT INTO rki_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","သူတစ်ပါးသည် အကျွန်ရို့၌ ပြုမှားမိသောအပြစ်တိကို အကျွန်ရို့သည် ခွင့်ရွှတ်သကဲ့သို့ အကျွန်ရို့ ပြုမှားမိသော အပြစ်တိကိုလည်း ခွင့်ရွှတ်တော်မူပါ။ ");
INSERT INTO rki_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","အကျွန်ရို့၌ ကြီးမားသော စုံစမ်းသွီးဆောင်ခြင်းကို မကျရောက်စီဘဲ၊ မကောင်းသောအမှုမှလည်း ကယ်နုတ်တော်မူပါ။’ ဟူ၍ ဆုတောင်းကြလော့။ ");
INSERT INTO rki_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“သင်ရို့သည် သူတစ်ပါးက သင်ရို့ကို ပြုမှားမိသောအပြစ်တိကို ခွင့်ရွှတ်မှသာလျှင် ကောင်းကင်ဘုံ၌ ဟိတော်မူသော သင်ရို့အဖက သင်ရို့ကို ခွင့်ရွှတ်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","သို့သော် သင်ရို့သည် သူတပါးအပြစ်ကို ခွင့်မရွှတ်လျှင် သင်ရို့ ပြုမှားမိသော အပြစ်တိကိုလည်း သင်ရို့အဖက ခွင့်ရွှတ်လိမ့်မည် မဟုတ်ပေ။ ");
INSERT INTO rki_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“သင်ရို့သည် အစာယှောင်ကြသည့်အခါ သူတော်ကောင်းယောင်ဆောင်သောသူတိကဲ့သို့ မျက်နှာညှိုးငယ်ခြင်း မဟိကတ်ကေ့၊ ထိုသူရို့သည် သူရို့အစာယှောင်သည်ကို လူတိုင်းမြင်ကြစီရန် သူရို့၏သရုပ်မှန်ကို ကွယ်ဝှက်ထားတတ်ကြ၏။ ငါ အမှန်ဆိုသည်ကား သူရို့သည် မိမိရို့၏အကျိုးကို ခံစားရပြီးဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","သင်သည် အစာယှောင်ကြသောအခါ မျက်နှာကိုသစ်၍ ဂေါင်းကိုလည်း ဖြီးထားကတ်၊ ");
INSERT INTO rki_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","သင်အစာယှောင်နိန်သည်ကို တခြားလူတိအား မသိစီဘဲ မမြင်နိုင်သော သင်ရို့၏အဖကို သာလျှင် သိမြင်စီပါ။ သို့ပြုလျှင် ဆိတ်ကွယ်ရာအရပ်၌ သင်ရို့ပြုသမျှကို သိမြင်တော်မူသော သင်၏အဖသည် သင်အား ကောင်းချီးများစွာကို ပီးတော်မူလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“သံချီး၊ ပိုးရွ ဖျက်ဆီး၍ ဒါးပြတိ ထွင်းဖောက်ခိုးယူနိုင်သော မြီကြီးထက်မှာ မိမိအတွက် ဘဏ္ဍာကို မစုဆောင်းကတ်ကေ့။ ");
INSERT INTO rki_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","သို့သော်လည်း သံချီး၊ ပိုးရွ မဖျက်ဆီးနိုင်၊ ဒါးပြတိ မထွင်းဖောက်နိုင်သော ကောင်းကင်ဘုံ၌ မိမိအတွက် ဘဏ္ဍာကို စုဆောင်းကတ်။ ");
INSERT INTO rki_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","အကြောင်းမူကား သင်၏စိတ်နှလုံးသည် သင်၏ဘဏ္ဍာဟိသောအရပ်သို့ အစဉ်အမြဲ ရောက်တတ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“မျက်စိသည် ခန္ဓာ၏မီးခွက်ဖြစ်၏။ မျက်စိကြည်လင်လျှင် သင်၏ခန္ဓာတစ်ကိုယ်လုံး လင်းလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","သို့သော် သင်၏မျက်စိမကောင်းလျှင် သင်၏ခန္ဓာသည် မှောင်မိုက်ထဲ၌ ဟိနိန်လိမ့်မည်။ ထို့ကြောင့် သင်ရို့အထဲ၌ ဟိသော အလင်းသည် မှောင်မိုက်နိန်မည်ဆိုလျှင် ထိုမှောင်မိုက်သည် အလွန် ကြောက်စရာကောင်းပါ၏။ ");
INSERT INTO rki_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“ဇာသူလည်း သခင်နှစ်ယောက်၏ကျွန် မဖြစ်နိုင်။ သခင်တစ်ယောက်ကို မုန်း၍ တစ်ယောက်ကို ချစ်မည်၊ တစ်ယောက်ကို သစ္စာဟိ၍ တစ်ယောက်ကို ငြင်းပယ်မည်။ သင်ရို့သည် ဘုရားသခင်အမှုကိုလည်းကောင်း၊ လောကီစည်းစိမ်အမှုကိုလည်းကောင်း တစ်ပြိုင်တည်း မဆောင်ရွက်နိုင်ကြ။ ");
INSERT INTO rki_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“ထို့ကြောင့် သင်ရို့ကို ငါဆိုသည်ကား အသက်ရှင်ရန် သင်ရို့လိုအပ်သော အစားအသောက်အတွက် သော်လည်းကောင်း၊ သင်ရို့ခန္ဓာအတွက် လိုအပ်သော အဝတ်အတွက် သော်လည်းကောင်း မစိုးရိမ်ကတ်ကေ့။ အစာထက် အသက်က သာ၍ မြတ်ပြီး၊ အဝတ်ထက် ကိုယ်က သာ၍ မြတ်သည် မဟုတ်လော။ ");
INSERT INTO rki_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ငှက်တိကို ကြည့်ကတ်ပါ။ သူရို့သည် မျိုးစိ့လည်းမကြဲ၊ စပါးလည်းမရိတ်၊ ပုတ်ထဲ၌လည်း မစုဆောင်းကတ်၊ သို့သော်လည်း ဤသို့သော ငှက်တိကို တောင်မှ သင်ရို့၏ ကောင်းကင်ဘုံသျှင်အဖက ကျွေးမွီးထားလျှင် သင်ရို့သည် ငှက်တိထက် သာ၍ မြင့်မြတ်ကြသည် မဟုတ်လော။ ");
INSERT INTO rki_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","စိုးရိမ်ပူပန်ခြင်းအားဖြင့် ဇာသူက မိမိ၏အသက်ကို တစိကေလောက် ရှည်စီနိုင်သနည်း။ ");
INSERT INTO rki_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“ဇာကြောင့် အဝတ်အဖို့ စိုးရိမ်နိန်ကြသနည်း။ တောနှင်းပန်းများကို ကြည့်ကတ်ပါ။ ဤတောပန်းပွင့်များသည် မိမိရို့အတွက် ခြည်လည်းမငင်၊ ဗိုင်းလည်းမဝင့်ကြ။ ");
INSERT INTO rki_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","သို့သော်လည်း သင်ရို့ကို ငါ ဆိုသည်ကား ဘုန်းကြီးသော သျှောလမုန်တောင်မှ ဤတောပန်းပွင့် တစ်ပွင့်ကဲ့သို့ မဆင်မြန်းနိုင်ခပေ။ ");
INSERT INTO rki_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ယုံကြည်ခြင်း အားနည်းသူရို့၊ ဤနိ့မြင်၍ နက်ဖြန်ခါ မီးဖိုထဲသို့ ချရမည့် မြက်ရိုင်းပန်းတိကိုတောင်မှ ဤသို့သောအဝတ်နှင့် ဝတ်ဆင်ပီးသော ဘုရားသခင်သည် သာ၍ လှပသောအဝတ်များနှင့် သင်ရို့ကို ဝတ်ဆင်ပီးလိမ့်မည် မဟုတ်ပါလား။ ");
INSERT INTO rki_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“ထို့ကြောင့် ‘ငါ ဇာပိုင်စားရဖို့လဲ၊ ဇာပိုင် သောက်ရဖို့လဲ၊ ဇာပိုင် ဝတ်ရဖို့လဲ’ ဆိုသည်ကို မစိုးရိမ်ကတ်ကေ့။ ");
INSERT INTO rki_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","(သာသနာပလူတိကသာ ဤအရာများအတွက် စွဲလမ်းတတ်ကြ၏။) ကောင်းကင်ဘုံသျှင် သင်ရို့၏အဖသည် သင်ရို့ လိုအပ်ချက်ကို သိတော်မူပြီးဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","သို့ရာတွင် ဘုရားသခင်၏နိုင်ငံတော်နှင့် ဖြောင့်မတ်ခြင်းတရားကို ရှီးဦးစွာ ရှာကတ်ပါ။ နောက်မှ ဤအရာအားလုံးကို သင်ရို့အား ထပ်၍ ပီးတော်မူလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","နက်ဖြန်ခါအတွက် မစိုးရိမ်ကတ်ကေ့။ နက်ဖြန်နိ့က နက်ဖြန်နိ့အတွက် စိုးရိမ်လိမ့်မယ်။ ဤနိ့၌ဟိသော မကောင်းသောမှုအရာများသည် ဤနိ့အဖို့ လုံလောက်ပေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“တခြားလူတိကို တရားမစီရင်ကတ်ကေ့၊ ထိုသို့ပြုလျှင် သင်ရို့သည် ဘုရားသခင်၏ တရားစီရင်ခြင်းမှ ကင်းလွတ်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","သင်ရို့သည် တခြားလူတိကို တရားစီရင်သည့်နည်းတူ သင်ရို့ကိုလည်း ဘုရားသခင်က တရားစီရင်လိမ့်မည်။ သင်ရို့သည် တခြားလူတိကို ပြုသည့်နည်းတူ ဘုရားသခင်က သင်ရို့ကို ပြုလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","သင်၏မျက်စိထဲ၌ ဟိသော သစ်စကို အာရုံမစိုက်ဘဲ၊ သင်၏ညီအစ်ကိုမျက်စိထဲ၌ ဟိသော အမှုန်ကို ဇာဖြစ်လို့ ကြည့်နိန်လဲ။ ");
INSERT INTO rki_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","သင်၏မျက်စိထဲ၌ သစ်စ ဟိပါလျက်နှင့် ‘သင်၏ညီအစ်ကို မျက်စိထဲမှာဟိသော အမှုန်ကို ထုတ်ပီးပါရစီ’ ဟု ဇာကြောင့် ပြောဝံ့လဲ။ ");
INSERT INTO rki_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","သူတော်ကောင်းယောင် ဆောင်သောသူရို့၊ သင်ရို့မျက်စိထဲမှ သစ်စကို အယင် ထုတ်ပြီးခါမှ သင်၏ညီအစ်ကို မျက်စိထဲမှ အမှုန်ကို ယှင်းလင်းစွာ မြင်ရ၍ ထုတ်ပီးနိုင်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“သန့်ယှင်းသောအရာကို ခွီးတိကို မပီးကတ်ကေ့။ သူရို့သည် သင့်ကိုလှည့်၍ ကိုက်ကတ်လိမ့်မည်။ ပုလဲရတနာကို ဝက်တိရှိ့မှာ မချထားကတ်ကေ့။ သူရို့သည် ထိုအရာကို ကျော်နင်း၍ လားကတ်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“တောင်းကတ်ပါ၊ တောင်းလျှင် ရလိမ့်မည်။ ရှာကတ်ပါ၊ ရှာလျှင် တွိ့လိမ့်မည်။ ခေါက်ကတ်ပါ၊ သင်ရို့အဖို့ တန်းခါး ပွင့်လာလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","တောင်းသောသူတိုင်း ရလိမ့်မည်။ ရှာသောသူတိုင်း တွိ့လိမ့်မည်။ ခေါက်သောသူတိုင်းလည်း တန်းခါးကို ဖွင့်ပီးလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","သားသည် မုန့်ကိုတောင်းလျှင် ကျောက်ခဲကို ပီးသောအဖ သင်ရို့၌ ဟိကြသလား။ ");
INSERT INTO rki_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ထိုနည်းတူ ငါးကို တောင်းကေ မြွီကို ပီးသောသူ သင်ရို့၌ ဟိကြသလား။ ");
INSERT INTO rki_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","သင်ရို့သည် အဆိုးဖြစ်လျက်ပင် သားသမီးတိ တောင်းကြသည့်အခါ ကောင်းသောအရာတိကိုသာ ပီးတတ်ကြ၏။ ထိုသို့ဖြစ်လျှင် ကောင်းကင်ဘုံသျှင် သင်ရို့အဖက တောင်းသောသူတိအား သာ၍ ကောင်းသောအရာများကို ပီးလိမ့်မည် မဟုတ်ပါလား။ ");
INSERT INTO rki_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“သင်ရို့သည် မိမိကိုယ်ကို ပြုစုလိုသည့်အတိုင်း သူတစ်ပါးကို ပြုစုကတ်ပါ။ ဤတရားသည် မောသျှေ၏ပညတ်တရားနှင့် ပရောဖက်ရို့၏ သွန်သင်ချက်များ၌ အဓိကအချက် ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“ကျဉ်းသောတန်းခါးကို ဝင်ကတ်ပါ။ အကြောင်းမူကား၊ ငရဲသို့ ဝင်သောတန်းခါးဝသည် ကျယ်ဝန်း၍ ထိုအရပ်သို့ ဦးတည်သောလမ်းသည် လွယ်ကူ၏၊ ထို့ကြောင့် ထိုလမ်း၌ လားသောသူလည်း အလွန် များပြား၏။ ");
INSERT INTO rki_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","သို့သော်လည်း အသက်ရှင်ခြင်းသို့ ရောက်သောတန်းခါးဝသည် အလွန်ကျဉ်း၍ ထိုအရပ်သို့ ဦးတည်သောလမ်းသည် အလွန် ခက်ခဲ၏။ ထို့ကြောင့် ထိုလမ်းကို တွိ့၍ လားသောသူ အလွန် နည်း၏။ ");
INSERT INTO rki_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“မိစ္ဆာပရောဖက်တိကို သတိထားကတ်ပါ။ သူရို့သည် အတွင်း၌ ကြမ်းတမ်းသောမြီခွီး ဖြစ်သော်လည်း အပြင်ဖက်က သိုးကဲ့သို့ အယောင်ဆောင်၍ သင်ရို့ပါးကို လာကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","သင်ရို့သည် သူရို့ပြုသောအမူအားဖြင့် သူရို့ကို သိကြလိမ့်မည်။ ဆူးပင်များသည် စပျစ်သီးကို သီးလေ့မဟိ၊ ထိုနည်းတူ ဆူးလေးပင်များသည် သဖန်းသီးကို သီးလေ့မဟိ။ ");
INSERT INTO rki_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","ထို့အတူ ကောင်းသောအပင်သည် ကောင်းသောအသီးများကို သီးတတ်၏၊ သို့သော်လည်း မကောင်းသောအပင်သည် မကောင်းသောအသီးကို သီးတတ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ကောင်းသောအပင်သည် မကောင်းသောအသီးကို မသီးနိုင်၊ ထိုနည်းတူ မကောင်းသောအပင်သည် ကောင်းသောအသီးကို မသီးနိုင်။ ");
INSERT INTO rki_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ကောင်းသောအသီးကို မသီးသော ဇာအပင်ကိုမဆို ခွတ်၍ မီးထဲသို့ ချပစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ထိုသို့ဖြစ်လျှင် သူရို့ပြုသောအမှုအားဖြင့် မိစ္ဆာပရောဖက်တိကို သင်ရို့သည် သိကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“ငါ့ကို ‘အသျှင်ဘုရား၊ အသျှင်ဘုရား’ ဟု ခေါ်သောသူတိုင်း ကောင်းကင်နိုင်ငံသို့ ဝင်ရလိမ့်မည် မဟုတ်။ သို့သော် ကောင်းကင်ဘုံသျှင် ငါ့အဖ၏ အလိုတော်အတိုင်း လုပ်ဆောင်သော သူရို့သာလျှင် ကောင်းကင်နိုင်ငံတော်သို့ ဝင်ရလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","တရားစီရင်သောနိ့ ရောက်သောအခါ လူတိက ငါ့ကို ‘အသျှင်ဘုရား၊ အသျှင်ဘုရား၊ အကျွန်ရို့သည် ကိုယ်တော်၏နာမ၌ ဘုရားသခင်၏ သတင်းစကားကို ဟောပြောခကြ၏၊ အကျွန်ရို့သည် ကိုယ်တော်၏နာမဖြင့် နတ်ဆိုးတိကို မောင်းထုတ်ကြပြီးလျှင် နိမိတ်လက္ခဏာများစွာကို ပြခကြ၏’ ဟု ပြောကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","ထိုအခါ ငါက ထိုသူရို့အား ‘သင်ရို့ကို ငါ လုံးဝမသိ။ မတရားသောသူရို့၊ ငါ့နံပါးက ထွက်လားကတ်’ ဟု ပြောလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“ထို့နောက် ငါ့စကားတိကို ကြား၍ လိုက်နာသောသူတိုင်းသည် မိမိ၏အိမ်ကို ကျောက်ထက်မှာ တည်ဆောက်ထားသော ပညာဟိနှင့် တူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","မိုးရွာ၍ မြစ်ရီကြီးပြီး လီပြင်းတိုက်သော်လည်း ထိုအိမ်သည် ပြိုလဲကျလားခြင်းမဟိ၊ အကြောင်းမှာ ကျောက်ထက်မှာ တည်ဆောက်ထားသောကြောင့် ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“သို့သော်လည်း ငါ့စကားကို ကြား၍ မလိုက်နာသောသူသည် မိမိ၏အိမ်ကို သဲထက်မှာ တည်ဆောက်ထားသော ပညာမဟိသောသူနှင့် တူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","မိုးရွာ၍ မြစ်ရီကြီးပြီး လီပြင်းတိုက်ခိုက်သောအခါ ထိုအိမ်သည် ပြိုလဲလားခ၏။ ထိုသို့ဖြစ်လျှင် ထိုအိမ်သည် ကြီးစွာသော ပြိုလဲခြင်းဖြစ်လေ၏။” ");
INSERT INTO rki_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","ယေသျှုသည် ဤအရာများကို ဟောပြောပြီးသောအခါ လူအပေါင်းရို့သည် ကိုယ်တော်၏ဆုံးမသြဝါဒပီးခြင်းကို အလွန်အံ့သြကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","အကြောင်းမူကား ကိုယ်တော်သည် ကျမ်းတတ်ဆရာကဲ့သို့ မဟုတ်ဘဲ၊ အခွင့်အာဏာဟိသောသူ တစ်ယောက်ကဲ့သို့ ဆုံးမသြဝါဒပီးတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","ယေသျှုသည် တောင်ထက်မှ ဆင်းလာသောအခါ လူအုပ်ကြီးသည် ကိုယ်တော်နောက်သို့ လိုက်လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ထိုအခါ နူနာရောဂါ ခံစားနိန်ရသော လူတစ်ယောက်သည် ကိုယ်တော်ထံပါးသို့ ရောက်လာပြီး ကိုယ်တော်ရှိ့မှာ ဒူးထောက်၍ “ဆရာ၊ အလိုတော်ဟိလျှင် အကျွန့်ကို သန့်ယှင်းစီတော်မူပါ” ဟု လျှောက်ထားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ယေသျှုသည် လက်တော်ကိုဆန့်၍ ထိုသူကို တို့တော်မူပြီးလျှင် “ငါ အလိုဟိသည်ဖြစ်၍ သန့်ယှင်းခြင်းသို့ ရောက်စီ” ဟု မိန့်တော်မူသောအခါ ထိုသူသည် ချက်ချင်း နူနာရောဂါ ပျောက်ကင်းလား၏။ ");
INSERT INTO rki_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ထို့နောက် ယေသျှုက “နားထောင်၊ သင်သည် ဤအကြောင်းကို တစ်ယောက်ကိုလေ့ မပြောလီကေ့၊ ယဇ်ပုရောဟိတ်ပါးသို့ လား၍ သင့်ကိုယ်ကို ပြလော့။ ထို့နောက် သင့်ရောဂါကို ပျောက်ကင်းစီသည့်အကြောင်း လူတိုင်းရှိ့မှာ သက်သီဖြစ်ခြင်းငှာ မောသျှေမိန့်မှာထားခသည့်အတိုင်း ပူဇော်သကာကို ဘုရားသျှင်အား ဆက်ကပ်လော့” ဟု ထိုသူအား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ယေသျှုသည် ကပေရနောင်မြို့သို့ ရောက်လာသောအခါ ရောမစစ်ဗိုလ်တစ်ယောက်သည် ကိုယ်တော်ပါးသို့ ရောက်လာပြီးလျှင် ကူညီရန် တောင်းပန်သည်မှာ၊ ");
INSERT INTO rki_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“ဆရာ၊ အကျွန့်တပည့်တစ်ယောက်သည် အဖျားရောဂါကို ပြင်းထန်စွာ ခံစားနိန်ရ၍ အိမ်၌ အိပ်ရာထက်မှာ တုံးလုံးလှဲနိန်ပါ၏” ဟု ဆိုလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ယေသျှုကလည်း “ငါလား၍ သူ့ကို ကျန်းမာစီမည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ရောမစစ်ဗိုလ်က “ဤသို့ မဟုတ်ရပါ ဆရာ၊ ကိုယ်တော်တိုင် အကျွန့်အိမ်သို့ ကြွလာခြင်းငှာ အကျွန်နှင့် မထိုက်တန်ပါ။ အမိန့်ပီးလိုက်ရုံမျှဖြင့် အကျွန်၏တပည့်သည် နီကောင်းလားပါလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","အကြောင်းမူကား အကျွန်သည် အထက်အရာဟိတိ အမိန့်အာဏာအောက်၌ နီရသောသူတစ်ယောက် ဖြစ်ပါ၏။ အကျွန်မှာလည်း စစ်သားတိ အများကြီး ဟိပါ၏။ စစ်သားတစ်ယောက်ကို အကျွန်က ‘လား’ ဟု အမိန့်ပီးလိုက်လျှင် သူသည် လားရပါ၏၊ ‘လာ’ ဟု အမိန့်ပီးလိုက်လျှင် လာရပါ၏။ အကျွန့် အစီအပါအား ‘ဤအရာကို လုပ်ပါ’ ဟု အကျွန်က ဆိုလျှင် သူသည် လုပ်ရပါ၏” ဟု သူက လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ယေသျှုသည် ထိုစကားကို ကြားသောအခါ လွန်စွာအံ့သြတော်မူ၍ ကိုယ်တော်၏နောက်သို့ လိုက်လာကြသောလူများကို ဤသို့ မိန့်တော်မူ၏။ “ငါဆိုသည်ကား၊ ဤသို့သောယုံကြည်ခြင်းကို ဣသရေလလူမျိုးထဲ၌ပင်လျှင် ငါ မတွိ့ဖူးသိမ့်။ ");
INSERT INTO rki_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","သင်ရို့ကို ငါအမှန်ဆိုသည်ကား၊ လူရို့သည် အရှိ့ရပ်၊ အနောက်ရပ်က ရောက်လာကြပြီးလျှင် ကောင်းကင်နိုင်ငံ၏ပွဲတော်၌ အာဗြဟံ၊ ဣဇာက်၊ ယာကုပ်ရို့နှင့်အတူ ထိုင်ကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","သို့သော်လည်း နိုင်ငံတော်သား ဖြစ်ထိုက်သောသူများသည် ငိုကြွေးမြည်တမ်း၍ အံသွားကြိတ်နိန်ရမည့် မှောင်မိုက်ထဲသို့ ပစ်ချခြင်းကို ခံရကြလိမ့်မည်။” ");
INSERT INTO rki_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ထို့နောက် ယေသျှုသည် ရောမစစ်ဗိုလ်အား၊ “သင့်အိမ်သို့ ပြန်လော့၊ သင်ယုံကြည်သည့်အတိုင်း ဖြစ်လိမ့်မည်” ဟု မိန့်တော်မူ၏။ ထိုသို့ မိန့်တော်မူပြီးသည်နှင့် ရောမစစ်ဗိုလ်၏တပည့်သည် အဖျားရောဂါ ပျောက်ကင်းလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ယေသျှုသည် ပေတရုအိမ်သို့ ရောက်သောအခါ ဖျား၍ အိပ်ရာထက်မှာ လှဲနိန်သော ပေတရု၏ယောက္ခမကို တွိ့၏။ ");
INSERT INTO rki_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ကိုယ်တော်က ထိုမိန်းမ၏ လက်ကို တို့လိုက်သည်နှင့် ထိုမိန်းမသည် အဖျားရောဂါပျောက်၍ အိပ်ရာမှ ထပြီးလျှင် ကိုယ်တော့်အား အာဂန္တုဝတ်ကို ပြုလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","ညအချိန်ရောက်သောခါ၌ နတ်ဆိုးပူးနိန်သောသူတိကို ယေသျှုပါးသို့ ခေါ်ယူလာကြ၏။ ယေသျှုသည် နတ်ဆိုးတိကို စကားတစ်ခွန်းတည်းဖြင့် အမိန့်ပီး မောင်းထုတ်လိုက်သည်နှင့် ထိုသူအားလုံး ကျန်းမာကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","“အကျွန်ရို့၌ ဟိသော ဖျားနာခြင်းတိကို သူကိုယ်တိုင် နုတ်ယူ၍ အကျွန်ရို့၏ ရောဂါတိကိုလည်း ဖယ်ယှားပစ်လိမ့်မည်” ဟု ပရောဖက်ဟေသျှာယ ဟောထားခသော ကျမ်းစကားသည် ပြည့်စုံလာခြင်းသို့ ရောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","ယေသျှုသည် မိမိကို ဝိုင်းရံထားသော လူအစုအဝေးကို မြင်သောအခါ သူ၏တပည့်တိအား အိုင်တစ်ဖက်ကမ်းသို့ ကူးရန် မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ကျမ်းတတ်ဆရာတစ်ယောက်သည် ကိုယ်တော်ပါးသို့ ရောက်လာပြီးလျှင်၊ “ဆရာ၊ ကိုယ်တော်လားရာနောက်သို့ ကိုယ်တော်နှင့်အတူ အကျွန်လည်း လိုက်ပါမည်” ဟု ခွင့်တောင်း၏။ ");
INSERT INTO rki_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ယေသျှုက “မြီခွီးတိမှာ တွင်းဟိ၏၊ ငှက်တိမှာလည်း အသိုက်ဟိ၏၊ သို့သော် လူသားမှာ လဲလျှောင်းအနားယူဖို့ရန်ပင် နီရာမဟိ” ဟူ၍ မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","အခြားသော တပည့်တော်တစ်ယောက်က “ဆရာ၊ အကျွန်၏အဖကို ရှီးဦးစွာ သင်္ဂြိုဟ်ခြင်းငှာ ပြန်လားခွင့်ပီးပါ” ဟု လျှောက်သော်၊ ");
INSERT INTO rki_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ယေသျှုက “ငါ့နောက်သို့ လိုက်လော့၊ လူသီတိက မိမိရို့၏လူသီတိကို သင်္ဂြိုလ်ကြလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","ယေသျှုသည် လောင်းတစ်စင်းထဲသို့ တက်တော်မူလျှင် သူ၏တပည့်တော်တိလည်း ကိုယ်တော်နှင့်အတူ လိုက်ပါကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ထိုအခါ အိုင်ထဲတွင် လီပြင်းမုန်တိုင်းတစ်ခုသည် ရုတ်တရက် ထလာသောကြောင့် လောင်းသည် မြုပ်လုမြုပ်ချင် ဖြစ်နိန်၏။ သို့သော်လည်း ယေသျှုသည် အိပ်ပျော်နိန်၏။ ");
INSERT INTO rki_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","တပည့်တော်ရို့သည်လည်း ကိုယ်တော်ပါးသို့ လာ၍ ကိုယ်တော့်ကို နှိုးကြ၏။ “အသျှင်ဘုရား၊ အကျွန်ရို့ သီဖို့ယာ၊ အကျွန်ရို့ကို ကယ်တော်မူပါ” ဟု လျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ယေသျှုကလည်း “သင်ရို့သည် ဇာဖြစ်လို့ အကြောက်လွန်နိန်ကတ်လဲ၊ အလွန် ယုံကြည်ခြင်း နည်းကတ်တေကား” ဟု ဆိုပြီးနောက် အိပ်ရာမှ ထ၍ မုန်တိုင်းနှင့် ရီလှိုင်းကို ရပ်တန့်ရန် အမိန့်ပီးလိုက်သဖြင့် လီပြင်းမုန်တိုင်သည် ငြိမ်သက်လားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","လူတိသည် အလွန်အံ့ဩကြသည်ဖြစ်၍ “ဤသူကား ဇာပိုင်လူလဲ၊ လီနှင့် လှိုင်းတိတောင် သူ့အမိန့်ကို နာခံကတ်တေကား” ဟု ပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","ယေသျှုသည် အိုင်တစ်ဖက်ကမ်း၊ ဂါဒရနယ်စပ်ကို ရောက်သောအခါ နတ်ဆိုးဝင်ပူးနိန်သော သူနှစ်ယောက်သည် သင်္ချိုင်းဂူများကြားက ထွက်လာပြီး ကိုယ်တော့်ကို လာ၍ တွိ့ကြ၏။ လူများသည် ထိုနတ်ဆိုးပူးသော လူနှစ်ယောက်ကို အလွန်ကြောက်လန့်ကြသဖြင့် ထိုလမ်းမှ မလားဝံ့ကြ။ ");
INSERT INTO rki_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ချက်ချင်းပင်လျှင် ထိုသူနှစ်ယောက်က “ဘုရားသခင်၏သားတော် ယေသျှု၊ အကျွန်ရို့ကို ဇာလုပ်ပါဖို့လဲ၊ အချိန်မရောက်ခင် အကျွန်ရို့ကို အပြစ်ပီးဖို့ လာယာလား” ဟု အော်ဟစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ထိုအရပ်နှင့် မနီးမဝီးတွင် ဝက်အုပ်ကြီးတစ်အုပ် အစာစားနိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","“အကျွန်ရို့ကို နှင်ထုတ်မည် ဆိုလျှင် ထိုဝက်အုပ်ထဲသို့ ဝင်ခွင့်ပီးပါ” ဟု နတ်ဆိုးတိက ယေသျှုအား တောင်းပန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ထိုသို့ဆိုလျှင် “ဝင်ကတ်လီ” ဟု ယေသျှုက မိန့်တော်မူလိုက်သောကြောင့် နတ်ဆိုးများသည် ထိုသူရို့ထဲမှ ထွက်၍ ဝက်များထဲသို့ ဝင်ကြ၏။ ထိုဝက်အားလုံးသည် အိုင်ကမ်းထောင်းစောက်မှ ရီအိုင်ထဲသို့ တစ်ဟုန်ထိုး ဗြီးဆင်းကြပြီးလျှင် ရီထဲ၌ သီကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ဝက်ကျောင်းသားများသည်လည်း မြို့ထဲသို့ ဗြီး၍ ဝင်ကြပြီးလျှင် နတ်ဆိုးပူးနိန်သောသူတိ၌ ဖြစ်ခသည့်အကြောင်းစုံကို ပြောပြကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ထိုမြို့တွင် ဟိသမျှသော လူတိသည် ယေသျှုအား တွိ့ရန် ထွက်လာကြ၏။ ထို့နောက် သူရို့သည် ကိုယ်တော့်ကို တွိ့ကြသောအခါ သူရို့နယ်မှ ထွက်လားရန် တောင်းပန်ပြောဆိုကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ယေသျှုသည် လောင်းစီး၍ အိုင်ကို ဖြတ်ပြီးလျှင် မိမိ၏ဇာတိမြို့သို့ တဖန် ကြွတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","လူတချို့သည် ခြီ၊ လက်သီနိန်၍ အိပ်ရာထက်၌ တုံးလုံးလှဲနိန်သောသူတစ်ယောက်ကို အထံတော်သို့ ထမ်းယူလာကြ၏။ ယေသျှုသည် ထိုသူရို့၏ကြီးမားသော ယုံကြည်ခြင်းကို မြင်သောအခါ ခြီ၊ လက်သီနိန်သူအား “ငါ့သား၊ မစိုးရိမ်ကေ့၊ သင်၏အပြစ်အားလုံးကို ခွင့်ရွှတ်ပြီးယာ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ထို့နောက် တချို့ကျမ်းတတ်ဆရာတိက “ဤသူသည် ဘုရားသခင်ကို ပြစ်မှား ခြင်းဖြစ်သည်” ဟု မိမိရို့၏စိတ်ထဲ၌ ထင်မှတ်နိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ယေသျှုက သူရို့သည် ဇာကို စဉ်းစားနိန်ကြသည်ကို သိမြင်သောကြောင့် “သင်ရို့သည် ဇာကြောင့် အေပိုင် မကောင်းသောအမှုအရာတိကို စဉ်းစားနိန်ကတ်စွာလဲ၊ ");
INSERT INTO rki_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","‘သင့်အပြစ်ကို ခွင့်ရွှတ်ပြီးယာလို့ ပြောစွာက သာ၍ လွယ်ကူမည်လော’ သို့မဟုတ် ‘ထပြီးကေ လမ်းလျှောက်လိုက်’ ဟု ပြောစွာက သာ၍ လွယ်ကူမည်လော။ ");
INSERT INTO rki_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","လူသားသည် မြီကြီးထက်တွင် အပြစ်ရွှတ်ပိုင်ခွင့် အာဏာဟိသည်ကို ငါ သက်သီပြမည်။” ထို့ကြောင့် ကိုယ်တော်က ခြီလက်သီနိန်သူအား “ထ၍ သင့်အိပ်ရာကို ယူဆောင်ပြီးလျှင် အိမ်သို့ ပြန်လီ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ထိုအခါ ခြီ၊ လက်သီနိန်သောသူသည် ထ၍ အိမ်သို့ ပြန်လားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","လူတိက ဤအရာကို မြင်ကြသောခါ အလွန်ကြောက်ရွံ့ကြ၏။ ဤသို့သော အခွင့်အာဏာကို လူတိအား ပီးတော်မူသော ဘုရားသခင်၏ဂုဏ်တော်ကို ချီးမွမ်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ယေသျှုသည် ထိုအရပ်မှ ထွက်၍ လမ်းလျှောက်လာသောအခါ မဿဲဟုခေါ်သော အခွန်ကောက်ခံသူ တစ်ယောက်သည် သူ၏ရုံး၌ ထိုင်နိန်သည်ကို မြင်လျှင် “ငါ့နောက်ကို လိုက်ခ” ဟု မိန့်တော်မူ၏။ မဿဲသည်လည်း ထ၍ ယေသျှုနောက်သို့ လိုက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ယေသျှုသည် မဿဲ၏အိမ်၌ ထမင်းစားနိန်စဉ်တွင် အခွန်ကောက်ခံသောသူတိ၊ အပယ်ခံထားရသောသူတိသည်လည်း ယေသျှုနှင့် တပည့်တော်တိစားပွဲ၌ ဝင်ရောက်ကာ စားသောက်နိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ထိုအမှုအရာကို ဖာရိယှဲရို့သည် မြင်သောအခါ “သင်ရို့ဆရာသည် ဤသို့သောသူတိနှင့်အတူ ဇာကြောင့် စားသောက်နိန်သနည်း” ဟု တပည့်တော်ရို့အား မိန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ယေသျှုသည် ထိုအကြောင်းကို ကြားတော်မူလျှင် “ကျန်းမာသောသူတိသည် ဆီးသမားကို အလိုမဟိ၊ မကျန်းမာသောသူတိကသာ ဆီးသမားကို အလိုဟိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","‘တိရစ္ဆာန်နှင့် ယဇ်ပူဇော်ခြင်း အကျင့်ထက် သနားကရုဏာထားခြင်း အကျင့်ကို ငါ ပို၍ နှစ်သက်၏’ ဟူသော ကျမ်းစကားကို နားလည်စီခြင်းငှာ သင်ရို့သည် လား၍ သင်ယူကြလော့။ ငါမူကား ဖြောင့်မတ်သောသူတိကို ခေါ်ခြင်းငှာ လာသည် မဟုတ်၊ အပြစ်သားတိကို ခေါ်ခြင်းငှာ ကြွလာခြင်းဖြစ်၏။” ");
INSERT INTO rki_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","ထိုအခါ ဗတ္တိဇံယောဟန်၏တပည့်များသည် ယေသျှုထံပါးသို့ ရောက်လာကြပြီးလျှင် “အကျွန်ရို့နှင့် ဖာရိယှဲရို့သည် မကြာခဏ အစာယှောင်ကြပါ၏။ သို့ရာတွင် ကိုယ်တော်၏ တပည့်တော်ရို့သည်ကား ဇာကြောင့် အစာမယှောင်ကြသနည်း” ဟု မိန်းလျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ယေသျှုကလည်း “မင်္ဂလာဆောင်ပွဲ၌ အာဂန္တုရို့သည် မင်္ဂလာဆောင်သတို့သားနှင့် အတူဟိနိန်ကြစဉ်တွင် သူရို့သည် ဝမ်းနည်းကြမည်ဟု သင်ရို့ထင်ကြသလား။ ထိုသို့ မဟုတ်၊ မင်္ဂလာဆောင်သတို့သားကို သူရို့ထံပါးမှ ခွဲယူလားသောနိ့ ရောက်လာသောအခါ သူရို့သည် အစာယှောင်ကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“ဇာသူလည်း အင်္ကျီဟောင်းကို အထည်သစ်နှင့် ဖာလေ့မဟိ။ ထိုသို့ပြုလျှင် အထည်သစ်က စားသဖြင့် အင်္ကျီအပေါက်သည် သာ၍ ကျယ်တတ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ထိုနည်းတူ ဇာသူလည်း သားရီဘူးအဟောင်းထဲမှာ စပျစ်ရည်အသစ်ကို ထည့်လေ့မဟိ။ ထိုသို့ ထည့်လျှင် သားရီဘူးအဟောင်းသည် ကွဲထွက်၍ စပျစ်ရည်သည်လည်း ယိုထွက်လားပြီးလျှင် သားရီဘူးလည်း ပျက်စီးတတ်၏။ သို့ဖြစ်၍ စပျစ်ဝိုင်အသစ်ကို သားရီဘူးအသစ်ထဲ၌သာ ထည့်ကြ၏၊ ယေမှရာ နှစ်ခုစလုံးကို ကောင်းမွန်စွာ ထိန်းသိမ်းထားနိုင်လိမ့်မည်။” ");
INSERT INTO rki_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ယေသျှုသည် ဤအကြောင်းအရာများကို မိန့်တော်မူနိန်စဉ် ယုဒလူမျိုး အရာဟိတစ်ယောက်သည် ကိုယ်တော်ပါးသို့ ရောက်လာ၍ ကိုယ်တော်ရှိ့တော်၌ ပျပ်ဝပ်လျက် “အကျွန့်သမီး သီကျလားသည်မှာ မကြာသိမ့်ပါ၊ သို့သော်လည်း ကိုယ်တော်သည် ကြွလာ၍ သူမထက်မှာ လက်ကို တင်ပီးတော်မူပါ၊ သူမသည် အသက်ရှင်လာလိမ့်မည်” ဟု လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ထို့ကြောင့် ယေသျှုသည် ထ၍ သူ့နောက်သို့ လိုက်လေ၏၊ ကိုယ်တော်၏တပည့်တော်တိလည်း ကိုယ်တော်နှင့်အတူ လိုက်ပါကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ထိုအခါ တစ်ဆယ့်နှစ်နှစ်ကာလပတ်လုံး သွီးသွန်နာစွဲနိန်သော မိန်းမတစ်ယောက်သည် ယေသျှုနောက်သို့ လိုက်လာပြီး ကိုယ်တော်၏ဝတ်ရုံအနားပန်းဖွားကို တို့ထိလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","သူမက “အကျွန်သည် ကိုယ်တော်၏ဝတ်ရုံအနားပန်းဖွားကို တို့ထိခွင့်ရလျှင် တောင်မှ ကျန်းမာလားလိမ့်မည်” ဟု မိမိကို မိမိ ပြောဆိုနိန်၏။ ");
INSERT INTO rki_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ယေသျှုသည် နောက်သို့ ပြန်လှည့်ကြည့်၍ သူမကိုမြင်ပြီး “မစိုးရိမ်ကေ့ ငါ့သမီး၊ သင်၏ယုံကြည်ခြင်းသည် သင့်ကို ကျန်းမာစီယာ” ဟု မိန့်တော်မူ၏။ ယင်းအချိန်၌ပင် ထိုမိန်းမ၏အနာသည် ပျောက်ကင်းလားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ထိုနောက် ယေသျှုသည် အရာဟိအိမ်သို့ ရောက်လေ၏။ ကိုယ်တော်သည် အသုဘအခမ်းအနားအတွက် တီးမှုတ်နိန်ကြသူများနှင့် ရုတ်ရုတ်တ်သဲသဲ ဖြစ်နိန်ကြသောလူအုပ်ကြီးကို မြင်သောအခါ ");
INSERT INTO rki_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ကိုယ်တော်က “အားလုံး အပြင်သို့ ထွက်ကတ်၊ ဤမိန်းမသျှေသည်ကား သီလားစွာ မဟုတ် — အိပ်ပျော်နိန်စွာရာဖြစ်သည်” ဟု မိန့်တော်မူလိုက်၏။ ထိုအခါ သူရို့အားလုံးက ကိုယ်တော့်ကို ပျက်ရယ်ပြုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","သို့သော် လူတိ ထွက်လားကြသည်နှင့်တပြိုင်နက်၊ ယေသျှုသည် မိန်းမသျှေ၏အခန်းထဲသို့ ဝင်ပြီးလျှင် သူမ၏လက်ကို ကိုင်၍ ဆွဲထူလိုက်သောခါ သူမသည် မတ်တတ်ထလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ဤသတင်းသည် ထိုဒေသတစ်ခုလုံး၌ ပြန့်နှံ့လားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","ယေသျှုသည် ထိုအရပ်မှ ထွက်၍ လမ်းလျှောက်လာစဉ်တွင် မျက်ကန်းနှစ်ယောက်သည်လည်း ကိုယ်တော်၏နောက်မှ လိုက်လာကြ၏။ သူရို့က “ဒါဝိဒ်၏သားတော်၊ အကျွန်ရို့ကို သနားတော်မူပါ” ဟု အော်ဟစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ယေသျှုသည် အိမ်ထဲသို့ ဝင်သောအခါ မျက်ကန်းနှစ်ယောက်သည်လည်း ကိုယ်တော်၏နောက်က ဝင်လာကြသဖြင့် ကိုယ်တော်က “ငါသည် သင်ရို့ကို ကျန်းမာအောင် လုပ်နိုင်သည်ဟု သင်ရို့ ယုံကြည်ကတ်လား” ဟု သူရို့အား မိန်းတော်မူ၏။ သူရို့ကလည်း “ဟုတ်ပါရေ၊ ဆြာ” ဟု လျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","ထိုအခါ ယေသျှုသည် သူရို့၏မျက်စိကို တို့တော်မူပြီးလျှင် “သင်ရို့ ယုံကြည်သည့်အတိုင်း သင်ရို့၌ ဖြစ်ကတ်စီ” ဟု မိန့်တော်မူသည်နှင့် — ");
INSERT INTO rki_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","သူရို့သည် မျက်စိပြန်မြင်ကြလေ၏။ ယေသျှုက “ဤအကြောင်းကို တစ်ယောက်ကိုလည်း မပြောကတ်ကေ့” ဟု ထိုသူရို့အား တင်းကြပ်စွာ မိန့်မှာတော်မူလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","သို့သော်လည်း သူရို့ ထွက်လားပြီးနောက် ယေသျှု၏ သတင်းသည် ထိုဒေသတစ်ခုလုံးသို့ ပြန့်နှံ့လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ထိုသူနှစ်ယောက် ထွက်လားကြသောအခါ လူတချို့သည် နတ်ဆိုးဝင်ပူးနိန်သောကြောင့် စကားမပြောနိုင်သော လူအ တစ်ယောက်ကို ယေသျှုပါးသို့ ခေါ်ဆောင်လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","သို့သော် နတ်ဆိုးကို မောင်းထုတ်လိုက်သည်နှင့်တပြိုင်နက်၊ ထိုသူသည် စကားပြောနိုင်သည်ဖြစ်၍ လူတိုင်းက အံ့သြကြလေ၏။ သူရို့က “ဣသရေလလူမျိုးထဲ၌ ဤသို့သော အရာတိကို ငါရို့ တစ်ခါမျှ မတွိ့ဖူးပါကား” ဟု အံ့ဩကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","သို့ရာတွင် ဖာရိယှဲရို့က “နတ်ဆိုးတိကို မောင်းထုတ်ဖို့အတွက် နတ်ဆိုးခေါင်းဆောင်က ယေသျှုကို တန်ခိုးပီးထားခြင်း ဖြစ်သည်” ဟု ပြောဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ယေသျှုသည် အားလုံးသော မြို့များနှင့် ကျေးလက်တောရွာများကို လှည့်လည်၍ ကြွချီတော်မူ၏။ ကိုယ်တော်သည် တရားဇရပ်များ၌ ဆုံးဩဝါဒ ပီးတော်မူ၍ နိုင်ငံတော်နှင့်ဆိုင်သော သတင်းကောင်းကို ဟောကြားပြီးလျှင် မကျန်းမာသောသူတိနှင့် အနာရောဂါအမျိုးမျိုး ခံစားနိန်ရသောသူရို့ကို ကျန်းမာစီတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ကိုယ်တော်သည် လူစုလူဝေးကြီးကို မြင်သောအခါ သူ၏နှလုံးသားထဲ၌ ထိုသူများကို အလွန်သနားစိတ်ဝင်လေ၏။ ဇာကြောင့်ဆိုသော် သူရို့သည် သိုးထိန်းမဟိသော သိုးများကဲ့သို့ ကူညီသူမဟိဘဲ စိုးရိမ်စိတ် ဝင်နိန်ကြသောကြောင့်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ထို့ကြောင့် ကိုယ်တော်က “ရိတ်စရာစပါးတိ အများကြီးဟိသော်လည်း ရိတ်သိမ်းသောသူ အလွန်နည်းကြသည်ဖြစ်၍ ");
INSERT INTO rki_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","စပါးရိတ်သိမ်းမည့်သူများကို စီရွှတ်ပီးရန်၊ စပါးသျှင်ပါးမှာ ဆုတောင်းကြပါ” ဟု တပည့်တော်တိအား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","ယေသျှုသည် တပည့်တော် တစ်ဆယ့်နှစ်ယောက်ကို အတူတကွ ခေါ်ပြီးလျှင် ဝိညာဉ်ဆိုးတိကို နှင်ထုတ်နိုင်ခြင်းငှာ လည်းကောင်း၊ အနာရောဂါအမျိူးမျိူးကို ပျောက်ကင်းစီခြင်းငှာ လည်းကောင်း၊ သူရို့အား အခွင့်အာဏာများကို ပီးတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","ထိုတမန်တော်ဆယ့်နှစ်ယောက်၏ နာမည်များမှာ ပထမဆုံးအားဖြင့် သျှိမုန်ဟု ခေါ်သော ပေတရုနှင့် သူ၏ညီ အန္ဒြေ၊ ဇေဗေဒဲ၏သားနှစ်ယောက်ဖြစ်သော ယာကုပ်နှင့် သူ၏ညီ ယောဟန်၊ ");
INSERT INTO rki_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ဖိလိပ္ပု၊ ဗာသောလမဲ၊ သောမ၊ အခွန်ကောက်ခံသူ မဿဲ၊ အာလဖဲ၏သား ယာကုပ် နှင့် သဒ္ဒဲ၊ ");
INSERT INTO rki_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","မျိုးချစ်ပုဂ္ဂိုလ် သျှိမုန်နှင့် ကိုယ်တော့်ကို သစ္စာဖောက်သောသူ ယုဒသျှာကာရုတ် ဟူ၍ ဖြစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ယေသျှုက တပည့်တော် ဆယ့်နှစ်ယောက်ကို ဩဝါဒပီး၍ စီရွှတ်လိုက်တော်မူသည်မှာ၊ “သင်ရို့သည် ယှာမာရိ မြို့ရွာများနှင့် တစ်ပါးအမျိုးသားတိ အရပ်ဒေသသို့ မလားကတ်ကေ့။ ");
INSERT INTO rki_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ထိုသို့လားကြမည့်အစား၊ ဣသရေလလူမျိုး၌ ပျောက်ဆုံးနိန်သော သိုးတိ ဟိရာအရပ်သို့ လားကြပြီးလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","‘ကောင်းကင်နိုင်ငံတော် တည်လုနီးပြီ’ ဟု ဟောပြောကြလော့။ ");
INSERT INTO rki_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","မကျန်းမာသောသူတိကို ကျန်းမာစီကြလော့၊ သီနိန်သောသူတိကို ထမြောက်စီကြလော့၊ နူနာစွဲနိန်သောသူတိကို ပျောက်ကင်းစီကြလော့၊ ပြီးနောက် နတ်ဆိုးတိကို နှင်ထုတ်ကြလော့။ သင်ရို့သည် အဖိုးအခမပီးဘဲ ရထားကြသည်ဖြစ်သောကြောင့်၊ အဖိုးအခမယူဘဲ ပြန်ပီးကြလော့။ ");
INSERT INTO rki_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","သင်ရို့၏အိတ်ထဲ၌ ရွှီဒင်္ဂါး၊ ငွီဒင်္ဂါး၊ ကြီးဒင်္ဂါးတိကို ယူမလားကတ်ကေ့။ ");
INSERT INTO rki_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","လမ်းခရီးအတွက် ခရီးဆောင်အိတ်နှင့်တကွ အင်္ကျီအပို၊ ဖိနပ်အပိုနှင့် တောင်မွိ့တိကိုလည်း ယူမလားကတ်ကေ့။ အကြောင်းမူကား လုပ်ဆောင်သောသူသည် ကျွေးမွီးခြင်းကို ခံထိုက်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“သင်ရို့သည် မြို့တစ်မြို့ သို့တည်းမဟုတ် ရွာတစ်ရွာသို့ ဝင်ကြသောအခါ သင်ရို့အား လက်ခံလိုသောသူတိကို ရှာပြီးလျှင် ထိုအရပ်မှ ထွက်ခွာသည့်တိုင်အောင် ထိုသူ၏အိမ်၌ တည်းခိုကြလော့။ ");
INSERT INTO rki_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","သင်ရို့သည် အိမ်တစ်အိမ်သို့ ဝင်သောအခါ ‘သာလီစွပါ’ ဟု အယင်ဆုံး နှုတ်ဆက်ကြလော့။ ");
INSERT INTO rki_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ထိုအိမ်သည် ထိုက်တန်လျှင် သင်ရို့၏မင်္ဂလာစကားသည် ထိုအိမ်၌ ကျန်ခလိမ့်မည်။ သို့ရာတွင် ထိုအိမ်သည် မထိုက်တန်လျှင် သင်ရို့၏မင်္ဂလာစကားသည် သင်ရို့ပါးသို့ ပြန်လာလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ပြီးနောက် တချို့အိမ် သို့မဟုတ် မြို့တိက သင်ရို့စကားကို နားမထောင်၊ သင်ရို့ကို လက်မခံလျှင် သင်ရို့ခြီဖဝါးက မြီမှုန့်ကို ခါချပြီးလျှင် ထိုအရပ်မှ ပြန်ထွက်လာကြလော့။ ");
INSERT INTO rki_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ငါ အမှန်ဆိုသည်ကား တရားစီရင်သောနိ့ရက်၌ ဘုရားသခင်သည် ထိုမြို့၏လူများထက် သောဒုံနှင့် ဂေါမောရ မြို့သူမြို့သားတိကို သာ၍ သနားကရုဏာကို ပြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“နားထောင်ကတ်၊ မြီခွီးအုပ်စုထဲသို့ သိုးတိကို စီရွှတ်လိုက်သကဲ့သို့ သင်ရို့အား ငါ စီရွှတ်လိုက်၏။ ထို့ကြောင့် သင်ရို့သည် မြွီကဲ့သို့ လိမ္မာ၍ ဂြိုးငှက်ကဲ့သို့ အဆိပ်ကင်းကြလော့။ ");
INSERT INTO rki_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","သတိထားကတ်ပါ၊ သင်ရို့ကို ဖမ်းဆီး၍ တရားရုံးသို့ အပ်နှံကြလိမ့်မည်၊ ထိုသူရို့သည် တရားဇရပ်များထဲ၌ သင်ရို့အား သတ်ပုတ်ကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ငါ့ကြောင့် အာဏာပိုင်များနှင့် သျှင်ဘုရင်များ၏ရှိ့မှောက်၌ စစ်ဆီးမိန်းမြန်းရန်လည်းကောင်း၊ ထိုသူရို့နှင့်တကွ တခြားလူမျိုးတိကို သတင်းကောင်းတရား ဟောကြားခြင်းငှာလည်းကောင်း သင်ရို့ကို ဖမ်းဆီးခေါ်ဆောင်လားကတ်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","ထိုသူရို့က သင်ရို့ကို စစ်ဆီးမိန်းမြန်းရန် ခေါ်ဆောင်လားကြသောအခါ ဇာကိုပြောရမည် သို့မဟုတ် ဇာပိုင် ပြောရမည်ကို မစိုးရိမ်ကတ်ကေ့၊ အချိန်ရောက်လာသောအခါ သင်ရို့ ဇာကိုပြောရမည် ဆိုသည်ကို သိလာကတ်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","အကြောင်းမူကား၊ သင်ရို့ပြောရမည့်စကားသည် သင်ရို့ စကား မဟုတ်၊ ထိုစကားကို သင်ရို့အဖ၏ဝိညာဉ်တော်က သင်ရို့အားဖြင့် ပြောလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“ညီအစ်ကိုအချင်းချင်း တစ်ယောက်ကိုတစ်ယောက် အသီသတ်ကတ်လိမ့်မည်။ အဖက သားသမီးတိကိုလည်းကောင်း၊ သားသမီးက မိဖကိုလည်းကောင်း၊ အသီ သတ်ကတ်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","ငါ့ကြောင့် သင်ရို့ကို လူတိုင်းက မုန်းကတ်လိမ့်မည်။ သို့သော် အဆုံးထိတိုင်အောင် တည်ကြည်သောသူသည် ကယ်တင်ခြင်းခံရ လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","မြို့တစ်မြို့၌ သင်ရို့ကို ညှဉ်းဆဲကြလျှင် တခြားမြို့ တစ်မြို့သို့ ထွက်ဗြီးကြလော့။ ငါ အမှန်ဆိုသည်ကား သင်ရို့သည် ဣသရေလမြို့ရွာအားလုံး၌ သင်ရို့၏အလုပ် မပြီးစီးခင် လူသားသည် ကြွလာလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“ဆရာထက် သာသော တပည့် ဟူ၍ မဟိ၊ အသျှင်ထက် သာသော ကျွန်ဟူ၍ မဟိ။ ");
INSERT INTO rki_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ထို့ကြောင့် တပည့်သည် ဆရာကဲ့သို့လည်းကောင်း၊ ကျွန်သည် အသျှင်ကဲ့သို့လည်းကောင်း ဖြစ်လာလျှင် ကြေနပ်လောက်ပေ၏။ အိမ်ထောင်ဦးစီးကို ဗေလဇေဗုလ ဟူ၍ ခေါ်ကြလျှင် အိမ်သူအိမ်သားတိကို ဤထက်ဆိုးသောနာမည်ဖြင့် ခေါ်ကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“ထို့ကြောင့် ထိုသူရို့ကို မကြောက်ကတ်ကေ့။ အဂု ဖုံးထားသည့်အရာဟူသမျှသည် ပေါ်လာကြလိမ့်မည်။ လျှို့ဝှက်ထားသောအရာအားလုံးသည်လည်း ထင်ရှားလာကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ငါသည် သင်ရို့အား မှောင်မိုက်ထဲ၌ ပြောသောအရာများကို သင်ရို့သည် အလင်းထဲ၌ ပြန်ပြောကြရလိမ့်မည်။ ဆိတ်ကွယ်ရာ၌ သင်ရို့ကြားရသောစကားကို သင်ရို့သည် အိမ်ခေါင်မိုးထိပ်က ကြွေးကြော်ရလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ခန္ဓာကိုယ် ကိုသာ အသီသတ်နိုင်ပြီး စိတ်ဝိညာဉ်ကို အသီမသတ်နိုင်သော သူတိကို မကြောက်ကတ်ကေ့။ ခန္ဓာကိုယ်နှင့် စိတ်ဝိညာဉ်နှစ်ခုလုံးကို ငရဲထဲမှာ ဖျက်ဆီးနိုင်သော ဘုရားသခင် ကိုသာ ကြောက်ကြလော့။ ");
INSERT INTO rki_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","စာငှက်နှစ်ကောင်ကို ဒင်္ဂါးတစ်ပြားနှင့် ဝယ်ရသည် မဟုတ်လား၊ သင်ရို့အဖ အလိုမဟိလျှင် ထိုစာငှက်တစ်ကောင်မျှ မြီကြီးထက်သို့ မကျစီရ။ ");
INSERT INTO rki_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ထို့အပြင် သင်ရို့ဂေါင်းက ဆံပင်တိကို တောင်မှ တစ်ပင်မကျန် ရွီထားတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ထို့ကြောင့် ဇာသူ့ကိုလေ့ မကြောက်ကတ်ကေ့၊ သင်ရို့သည် များစွာသော စာငှက်တိထက် သာ၍ တန်ဖိုးဟိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“ငါ့အား လူအများတိရှိ့၌ ဝန်ခံသောသူကို ကောင်းကင်ဘုံသျှင် ငါ၏အဖရှိ့၌လည်း ငါ ဝန်ခံလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","သို့ရာတွင် ငါ့ကို လူအများတိရှိ့မှာ ငြင်းပယ်သောသူကို ကောင်းကင်ဘုံသျှင် ငါ့အဖ၏ရှိ့၌လည်း ငါ ငြင်းပယ်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“ဤလောကကြီးသို့ ငြိမ်သက်ခြင်းကို ယူဆောင်၍ ငါ ကြွလာသည် ဟု မထင်ကတ်ကေ့။ ငြိမ်သက်ခြင်းကို ယူဆောင်၍ ငါ ကြွလာသည် မဟုတ်၊ ပဋိပက္ခဖြစ်စီရန် ငါ ကြွလာခြင်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","သားက အဖကို ဆန့်ကျင်ဖက်ပြုခြင်းငှာ လည်းကောင်း၊ သမီးက အမိကို ဆန့်ကျင်ဖက်ပြုခြင်းငှာ လည်းကောင်း၊ ခြုပ်မက ယောက္ခမကို ဆန့်ကျင်ဖက်ပြုခြင်းငှာ လည်းကောင်း ငါ ကြွလာ၏။ ");
INSERT INTO rki_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","သင်၏မိသားစု ဝင်များသည် သင်၏အဆိုးဆုံးရန်သူများ ဖြစ်လာကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“မိမိ၏ အမိ အဖတိကို ငါ့ထက် သာ၍ ချစ်သောသူတိသည် ငါ၏တပည့် မဖြစ်နိုင်၊ မိမိ၏သားသမီးတိကို ငါ့ထက် သာ၍ ချစ်သောသူတိသည်လည်း ငါ၏တပည့် မဖြစ်နိုင်။ ");
INSERT INTO rki_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","မိမိ၏လက်ဝါးကပ်တိုင်ကို ထမ်း၍ ငါ၏ခြီရာနောက်သို့ မလိုက်သောသူတိသည် ငါ့တပည့် မဖြစ်နိုင်။ ");
INSERT INTO rki_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","မိမိအသက်ကို ရခြင်းငှာ ကြိုးစားသောသူသည် အသက်ယှုံးလိမ့်မည်။ သို့သော်လည်း ငါ၏အကျိုးအလို့ငှာ မိမိအသက်ကို စွန့်သောသူသည်ကား အသက်ကို ရလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“သင်ရို့ကို ကြိုဆိုလက်ခံသောသူသည် ငါ့ကို ကြိုဆိုလက်ခံသောသူ ဖြစ်၏၊ ငါ့ကို ကြိုဆိုလက်ခံသောသူသည်လည်း ငါ့ကို စီရွှတ်သောသူတစ်ယောက်ကို ကြိုဆိုလက်ခံသူဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ပရောဖက်တစ်ပါးကို ကြိုဆိုလက်ခံသောသူမည်သည်ကား ထိုသူသည် ပရောဖက်ဖြစ်သောကြောင့် ပရောဖက်၏အကျိုးကျေးဇူးကို ခံစားရလိမ့်မည်။ ထို့အပြင် သူတော်ကောင်းတစ်ယောက်ကို ကြိုဆိုလက်ခံသောသူ မည်သည်ကား ထိုသူသည် သူတော်ကောင်းဖြစ်သောကြောင့် သူတော်ကောင်းကပီးသော ကောင်းကျိုးကို ခံစားကြရလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ငါ၏တပည့်များထဲက အငယ်ဆုံးသောသူတစ်ယောက်ကို၊ သူသည် ငါ၏တပည့်ဖြစ်ခြင်းကြောင့် ရီအီးတစ်ခွက်ကို ပီးသောသူသည် ထိုရီတစ်ခွက်၏အကျိုးကို ဧကန်အမှန် ခံစားရပါလိမ့်မည်ဟု သင်ရို့အား ငါ အမှန်ဆို၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ယေသျှုသည် တပည့်တော် တစ်ဆယ့်နှစ်ပါးကို ဆုံးမဩဝါဒ ပီးပြီးလျှင် ထိုနီရာမှ ထွက်ခွာ၍ အနီးအနားမြို့ ရွာများသို့ ဆုံးမဩဝါဒပီးလျက် တရားဟောခြင်းငှာ ကြွတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ခရစ်တော်ပြုတော်မူသည့် အရာများကို ဗတ္တိဇံယောဟန်သည် ထောင်ထဲမှ ကြားသောခါ သူ၏တပည့်တချို့ကို ကိုယ်တော့်ပါးသို့ စီရွှတ်လိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","သူရို့က “ကိုယ်တော်သည် ဗတ္တိဇံယောဟန်ဟောထားသော ကြွလာတော်မူမည့် အသျှင်ဟုတ်ပါလား၊ ထိုသို့ မဟုတ်လျှင် အကျွန်ရို့သည် နောက်တစ်ပါးကို စောင့်နိန်ရပါဖို့သိမ့်လား၊ အကျွန်ရို့ကို ပြောပါ” ဟု ယေသျှုအား မိန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ယေသျှုကလည်း “ပြန်လားကြပြီးလျှင် သင်ရို့ ကြားသမျှ မြင်သမျှတိကို ယောဟန်အား ပြန်ပြောကြလော့၊ ");
INSERT INTO rki_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","မျက်စိကန်းသောသူများ ပြန်မြင်ကြပြီ၊ ခြီထောက်ကျိုးသောသူတိလည်း လမ်းလျှောက်နိုင်ကြပြီ၊ နူနာစွဲနိန်သည့်သူတိလည်း နူနာပျောက်ကင်းကြပြီ၊ နားပင်းသောသူတိလည်းနားကြားနိန်ကြပြီးလျှင် သီသောသူတိလည်း ထမြောက်ကြပြီ၊ ဆင်းရဲသားတိလည်း သတင်းကောင်းကို ကြားရကြပြီ၊ ");
INSERT INTO rki_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ငါ့အကြောင်းကို စိတ်မပျက်သောသူများသည် မင်္ဂလာဟိကြ၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ယောဟန်၏တပည့်များ ပြန်လားကြသောအခါ ယေသျှုက ယောဟန်နှင့် ပတ်သက်၍ လူထုပရိတ်သတ်အား မိန့်တော်မူသည်မှာ၊ “သင်ရို့သည် ယောဟန်နီထိုင်ရာ တောကန္တာရထဲသို့ လားကြသောအခါ ဇာချင့်ကို မြင်တွိ့ဖို့ မျှော်လင့်၍ လားကတ်ပါလဲ၊ လီတိုက်၍ လှုပ်နိန်သော ကျူပင်ကို မြင်တွိ့ဖို့ လားကတ်စွာလား၊ ");
INSERT INTO rki_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","သို့တည်းမဟုတ်၊ သင်ရို့သည် ဇာကို မြင်တွိ့ဖို့ လားကတ်စွာလဲ၊ ကောင်းမွန်သော အဝတ်တန်ဆာကို ဝတ်ဆင်ထားသော သူတစ်ယောက်ကို မြင်တွိ့ဖို့ လားကတ်စွာလား၊ ထိုသို့သော အဝတ်တန်ဆာတိကို ဝတ်ဆင်လေ့ဟိသူများသည် နန်းတော်တွင်း၌သာ နီထိုင်ကြသည် မဟုတ်ပါလား၊ ");
INSERT INTO rki_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ထို့အပြင် သင်ရို့သည် ဇာကို မြင်တွိ့ဖို့ ထွက်လားကတ်စွာလဲ၊ ပရောဖက်ကို မြင်တွိ့ဖို့ လားကတ်စွာလား၊ ငါ့ကို ပြောကြလော့။ ငါအမှန်ဆိုသည်ကား၊ သင်ရို့သည် ပရောဖက်ထက် ကြီးမြတ်သောသူကို မြင်တွိ့ ကြပြီးယာ။ ");
INSERT INTO rki_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","ကျမ်းစာ၌ ‘သင်၏လမ်းခရီးကို ပျင်ဆင်မည့် ငါ၏တမန်တော်တစ်ယောက်ကို သင်၏ရှိ့မှ ငါ စီရွှတ်လိုက်မည်’ ဟူ၍ ဖော်ပြထားသောသူမှာ ယောဟန်ပင်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","ငါ အမှန်ဆိုသည်ကား မိန်းမမွီးသော သူတိထဲမှာ ဗတ္တိဇံယောဟန်လောက် ကြီးမြတ်သောသူ တစ်ယောက်မျှ မဟိခသိမ့်။ သို့ရာတွင် ကောင်းကင်နိုင်ငံ၌ အငယ်ဆုံးသောသူတစ်ယောက်သည် ယောဟန်ထက် သာ၍ ကြီးမြတ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ယောဟန် လက်ထက်ကစ၍ အဂုကာလတိုင်အောင် ကောင်းကင်နိုင်ငံတော်ကို အနိုင်အထက်ပြုနိန်ကြ၏၊ ထိုသို့သော ရက်စက်ယုတ်မာသောသူတိသည် ကောင်းကင်နိုင်ငံတော်ကို လုယူရန် ကြိုးစားလျက်ဟိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","ဗတ္တိဇံယောဟန်၏ကာလ ရောက်သည့်တိုင်အောင် မောသျှေ၏ ပညတ်ကျမ်းနှင့် ပရောဖက်အားလုံးသည် ကောင်းကင်နိုင်ငံတော်အကြောင်းကို ဟောပြောနိန်ခကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","တဖန် သင်ရို့သည် ထိုပရောဖက်ရို့၏သတင်းစကားကို လက်ခံလိုစိတ် ဟိကြမည်ဆိုလျှင် ယောဟန်သည် ကြွလာတော်မူမည့် ဧလိယ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","နားဟိသောသူရို့ ကြားကတ်ပါစီ။ ");
INSERT INTO rki_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“ဤခေတ်ကာလလူတိကို ဇာဥပမာနှင့် နှိုင်းပြရဖို့လဲ၊ သူရို့သည် ပွဲလမ်းသဘင်၌ ထိုင်နိန်ကြသော သူငယ်တိနှင့် တူ၏။ သူငယ်တစ်စုက အခြားတစ်စုကို လှမ်း၍ အော်ကြသည်မှာ၊ ");
INSERT INTO rki_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘ငါရို့သည် သင်ရို့အတွက် နှဲကို ပျော်ရွှင်ဖွယ် တီးမှုတ်ကြသော်လည်း သင်ရို့သည် လိုက်၍ မကကြ။ ငါရို့သည် သင်ရို့အတွက် အလွမ်းတေးခြင်းကို ဆိုပီးနိန်ကြသော်လည်း သင်ရို့သည် မငိုတတ်ကြ’ ဟူ၍ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ဗတ္တိဇံယောဟန်သည် မစားမသောက်ဘဲ လာသောအခါ လူတိုင်းက ‘ဤသူသည် နတ်ဆိုးစွဲနိန်သောသူပါတကား’ ဟု ပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","လူသားသည် စားသောက်လျက် လာသောအခါ၌လည်း လူတိုင်းက ‘ကြည့်ကတ်၊ ဤသူသည် အစားကြီးသောသူ၊ စပျစ်ရည်သောက်ကြူးသောသူပါတကား၊ အခွန်ကောက်ခံသောသူ၊ အပြစ်သားတိ၏ အပေါင်းအသင်းပါတကား’ ဟု ပြောကြပြန်၏။ သို့သော်လည်း ဘုရားသခင်သည် မိမိ၏ဉာဏ်ပညာကို မိမိဖန်ဆင်းထားသော အရာများဖြင့် အမှန်ပင် ဖော်ပြလျက်ဟိ၏။” ");
INSERT INTO rki_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ထို့နောက် ယေသျှုသည် မိမိ၏နိမိတ်လက္ခဏာကို အများဆုံး ပြတော်မူခသောမြို့များမှ လူရို့သည် နောင်တမရကြသောကြောင့် ထိုမြို့ များကို အပြစ်တင်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“အို၊ ခေါရာဇိန်မြို့၊ သင်သည် အမင်္ဂလာဟိ၏။ အို၊ ဗက်ဇဲဒမြို့ သင်သည် အမင်္ဂလာဟိ၏။ သင်ရို့အား ငါ ပြခသော နိမိတ်လက္ခဏာတိကို တုရုနှင့် ဇိဒုန်မြို့၌သာ ငါ ပြခလျှင် ထိုမြို့သူမြို့သားများသည် ထိုကာလ၌ လျှော်တေအဝတ်ကို ဝတ်ကာ ပြာမှာ လူးလျက် မိမိရို့အပြစ်မှ နောင်တရကြောင်းကို ဖော်ပြကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","ငါအမှန်ဆိုသည်ကား၊ တရားစီရင်မည့်နိ့ရက်၌ တုရုမြို့နှင့် ဇိဒုန်မြို့မှ လူရို့သည် ဘုရားသခင်၏ သနားကရုဏာကို သင်ရို့ထက် သာ၍ ခံစားရကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","အို၊ ကပေရနောင်မြို့ သင်သည် မိမိကိုယ်ကို ကောင်းကင်နိုင်ငံထိတိုင်အောင် ချီးမြှောက်လိုသော်လည်း သင်သည် ငရဲထဲသို့ ပစ်ချခြင်းကို ခံရလိမ့်မည်။ အကြောင်းမူကား၊ သင်၌ ငါ ပြခသော နိမိတ်လက္ခဏာကို သောဒုံမြို့၌သာ ပြခလျှင် ထိုမြို့သည် အဂုကာလတိုင်အောင် တည်နိန်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","တရားစီရင်သောနိ့ရက်၌ ဘုရားသခင်သည် သောဒုံအရပ်ဒေသကို သင်ရို့ထက် သနားခြင်းကရုဏာပြလိမ့်မည်မှာ အမှန်ပင် ဖြစ်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ထိုအခါ ယေသျှုက “ကောင်းကင်နှင့် မြီကြီး၏အသျှင်သခင်ဖြစ်တော်မူသောအဖ၊ ကိုယ်တော်သည် ပညာဟိတိအား ဝှက်ထားသောအရာများကို အသျှေတိအား ဖွင့်ပြကာ သွန်သင်တော်မူသောကြောင့် ကျေးဇူးတော်ကို ချီးမွမ်းပါ၏။ ");
INSERT INTO rki_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","မှန်ပါ၏ အဖ၊ ဤသို့ ဖြစ်လာခြင်းသည် အဖ၏ အလိုတော်ကြောင့်သာ ဖြစ်ရပါ၏။ ");
INSERT INTO rki_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“ငါ၏အဖသည် အရာခပ်သိမ်းကို သားတော်အား ပီးထားပြီးဖြစ်၏။ အဖက လွဲ၍ သားတော်ကို တစ်ယောက်လည်း မသိကြ။ ထိုနည်းတူ သားတော်နှင့် သားတော်က ဖွင့်ပြရန် ရွီးချယ်သောသူရို့မှလွဲ၍ ခမည်းတော်ကို တစ်ယောက်လည်း မသိကြ။ ");
INSERT INTO rki_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“လေးသောဝန်ကို ထမ်း၍ ပင်ပန်းနိန်ကြသော သူအပေါင်းရို့၊ ငါ့ထံသို့ လာကြလော့၊ ငါသည် သင်ရို့ကို ချမ်းသာပီးမည်။ ");
INSERT INTO rki_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ငါ့ထမ်းပိုးကို ယူ၍ သင်ရို့ထက်မှာ တင်ကြလော့၊ ငါ့ထံ၌ သင်ခန်းစာ ယူကြလော့၊ ငါသည် နူညံ့သိမ်မွိ့၍ စိတ်နှလုံးနှိမ့်ချသောသူ ဖြစ်သဖြင့် သင်ရို့သည် စိတ်သက်သာခြင်း ရကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","အကြောင်းမူကား သင်ရို့ကို ငါပီးမည့် ထမ်းပိုးသည် ထမ်းရလွယ်၍ သင်ရို့ထက်မှာ ငါတင်ပီးမည့်ဝန်သည်လည်း ပေါ့၏။” ");
INSERT INTO rki_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","ထိုနောက် ယေသျှုသည် ဥပုသ်နိ့တစ်နိ့၌ သီးနှံခင်းများကို ဖြတ်၍ ကြွတော်မူစဉ်၊ သူ၏တပည့်တော်တိသည် ဝမ်းဆာသောကြောင့် သီးနှံများကို စားရန် ခူးဆွတ် ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ထိုအခြင်းအရာကို ဖာရိယှဲရို့သည် မြင်ကြသောအခါ သူရို့က “ကြည့်လိုက်ပါ၊ ဥပုသ်နိ့၌ ကိုယ်တော်၏တပည့်တော်တိ ဤသို့ ပြုခြင်းသည် ငါရို့၏ပညတ်တရားကို ဆန့်ကျင်နိန်ကြခြင်း ဖြစ်၏” ဟု ယေသျှုကို ပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ယေသျှုက “ဒါဝိဒ်သည် သူနှင့် သူ့အဖော်တိ ဝမ်းဆာလာကြသောအခါ ဇာပိုင် လုပ်ခသည်ကို သင်ရို့ တစ်ခါမျှ မဖတ်ဖူးကြလော။ ");
INSERT INTO rki_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","သူသည် ဘုရားသခင်၏အိမ်တော်ထဲသို့ ဝင်၍ ယဇ်ပုရောဟိတ်တိသာ စားခွင့်ဟိသော ဘုရားသခင်အား ပူဇော်ထားသည့်မုန့်ကို ယူ၍ သူနှင့် သူ့လူတိသည် ပညတ်တရားကို ချိုးဖောက်လျက် စားခကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","ဤတင်မကသိမ့်၊ ဗိမာန်တော်၌ဟိသော ယဇ်ပုရောဟိတ်များသည် ဥပုသ်နိ့တိုင်းတွင် ၎င်းဥပုသ်နိ့နှင့် ပတ်သက်သောပညတ်တရားများကို ချိုးဖောက်ကြသော်လည်း သူရို့သည် အပြစ်မကျ၊ ဟု မောသျှေ၏ပညတ်ကျမ်း၌ ရီးထားသည်ကို သင်ရို့သည် မဖတ်ဖူးကတ်လား။ ");
INSERT INTO rki_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ငါဆိုသည်ကား၊ ဗိမာန်တော်ထက် ကြီးမြတ်သောအရာသည် ဤအရပ်၌ ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","‘တိရစ္ဆာန်နှင့် ယဇ်ပူဇော်ခြင်းအကျင့်ထက် သနားကရုဏာထားခြင်းအကျင့်ကို ငါ အလိုဟိ၏’ ဟု ကျမ်းစာက ပြောထား၏။ ဤကျမ်းစာ ဆိုလိုချက်ကို သင်ရို့သည် အမှန်အကန် နားလည်ကြမည်ဆိုလျှင် အပြစ်မဟိသောသူကို အပြစ်တင်ကြလိမ့်မည် မဟုတ်ပေ။ ");
INSERT INTO rki_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","လူသားသည် ဥပုသ်နိ့၏ အသျှင်သခင် ဖြစ်၏။” ");
INSERT INTO rki_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ယေသျှုသည် ထိုနီရာမှထွက်၍ တရားဇရပ်တစ်ခုသို့ ဝင်ရောက်လေ၏၊ ");
INSERT INTO rki_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ထိုနီရာ၌ လက်တစ်ဖက်သီနိန်သော လူတစ်ယောက်ဟိ၏။ ယေသျှုကို အမှားရှာ၍ အပြစ်တင်စွပ်စွဲလိုသော လူအချို့သည်လည်း ထိုနီရာ၌ ဟိနိန်ကြ၏၊ ထို့ကြောင့် ထိုသူရို့က “ဥပုသ်နိ့မှာ အနာရောဂါပျောက်စီခြင်းသည် ငါရို့၏ ပညတ်တရားကို ဆန့်ကျင်သည် မဟုတ်ပါလား” ဟု မိန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ယေသျှုက “အကယ်၍ သင်ရို့ထဲက တစ်ယောက်ယောက်မှာ သိုးတစ်ကောင်ဟိ၏၊ ထိုသိုးသည် ဥပုသ်နိ့၌ တွင်းနက်ကြီးတစ်ခုထဲသို့ ကျနိန်လျှင် သင်ရို့သည် ထိုသိုးကို တွင်းထဲက ဆယ်တင်ကြမည်လော၊ မဆယ်တင်ဘဲ နီကြမည်လော။ ");
INSERT INTO rki_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","လူတစ်ယောက်သည် သိုးတစ်ကောင်ထက် သာ၍ တန်ဖိုးကြီး၏၊ သို့ဖြစ်၍ ဥပုသ်နိ့၌ တစ်စုံတစ်ယောက်ကို ကူညီခြင်းငှာ ငါရို့၏ပညတ်တရားက ငါရို့ကို ခွင့်ပြုထား၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ထို့နောက် ယေသျှုက လက်တစ်ဖက်သီနိန်သောသူအား “သင်၏လက်ကို ဆန့်လိုက်” ဟု မိန့်တော်မူသည့်အတိုင်း၊ ထိုသူသည် လက်ကို ဆန့်လိုက်လျှင် ထိုလက်သည် အခြားလက်တစ်ဖက်ကဲ့သို့ အကောင်းပကတိ ဖြစ်လားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ထိုအခါ ဖာရိယှဲရို့သည် တရားဇရပ်မှ ထွက်လား ကြပြီးလျှင် ယေသျှုကို သတ်ရန် ကြံစည်ကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ယေသျှုသည် သူ့အား လျှို့ဝှက်ကြံစည် နိန်ကြသည့်အကြောင်းကို ကြားသောခါ၊ ထိုအရပ်မှ ကြွတော်မူ၏။ လူအုပ်ကြီးကလည်း ကိုယ်တော်နောက်သို့ လိုက်လာကြ၏။ ကိုယ်တော်သည် မကျန်းမာသူအားလုံးကို ကျန်းမာစီတော်မူပြီးလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","သူ၏အကြောင်းကို တခြားလူတိအား မပြောကြရန် မိန့်မှာတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ဤသို့ ပြုတော်မူခြင်းမှာ ပရောဖက် ဟေသျှာယအားဖြင့် ပြောထားခသည့်ကျမ်းစကားတိ မှန်လာခြင်း ဖြစ်၏။ ကျမ်းစာလာသည်ကား၊ ");
INSERT INTO rki_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“ဤသူကား ငါ ရွီးချယ်ထားသော ငါ၏ကျွန် ဖြစ်၏။ ဤသူသည် ငါ့ကို ရွှင်လန်းစီ၍ ငါချစ်ရသောသူ ဖြစ်၏။ ငါ၏ဝိညာဉ်ကို သူ၌ တည်စီမည်။ သူသည် လူအမျိုးမျိုးတိအား ငါ၏တရားစီရင်ခြင်းအကြောင်းကို ဟောပြောလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","သူသည် အော်ဟစ်ခြင်း၊ ငြင်းခုံခြင်းကို မပြုသည်ဖြစ်၍ သူ၏အသံကို လမ်းများ၌ မည်သူမျှ မကြားစီရ။ ");
INSERT INTO rki_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ကောက်နိန်သော ကျူပင်ချေတစ်ပင်ကို မချိုး၊ မီးတောက်ငယ်တစ်ခုကို မမှုတ်သတ်၊ တရားမျှတမှုကို အောင်မြင်သည့်တိုင်အောင် မဆုတ်မနစ်ဆက်လက် ဆောင်ရွက်လိမ့်မည်ဖြစ်၍ ");
INSERT INTO rki_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","လူမျိုးအားလုံးက သူ့ကို မျှော်လင့်နိန်ကတ်လိမ့်မည်” ဟူ၍ ဖြစ်သတည်း။ ");
INSERT INTO rki_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","ထို့နောက် လူအချို့သည် နတ်ဆိုးဝင်ပူးသောကြောင့် မျက်စိကန်း၍ စကားအ နိန်သော သူတစ်ယောက်ကို ယေသျှုပါးသို့ ယူလာကြ၏။ ယေသျှုသည် ထိုသူအား ကျန်းမာစီတော်မူသဖြင့် ထိုသူသည် မျက်စိမြင်၍ စကားပြောနိုင်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ယေသျှုပြုတော်မူသောအမှုကို လူအပေါင်းရို့သည် အံ့သြကြလေ၏။ “ဤသူသည် ဒါဝိဒ်၏သား ဖြစ်သလော” ဟူ၍ သူရို့က မိန်းမြန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","ဤအကြောင်းကို ဖာရိယှဲတိကြားသောခါ၊ “သူသည် နတ်ဆိုးတိကို မောင်းထုတ်နိုင် သည်မှာ နတ်ဆိုးခေါင်းဆောင် ဗေလဇေဗုလက တန်ခိုးပီးထားသောကြောင့်ဖြစ်၏” ဟု ပြန်ပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ယေသျှုသည် ထိုသူရို့၏စိတ်ကို သိသောကြောင့် “တိုင်းနိုင်ငံတစ်ခု၌ အုပ်စုကွဲပြီး အချင်းချင်း တိုက်ခိုက်နိန်ကြလျှင် ထိုနိုင်ငံသည် မရပ်တည်နိုင်။ မိသားစုတစ်စု၊ မြို့ရွာတစ်ခုသည်လည်း အချင်းချင်း ကွဲပြားနိန်ကြလျှင် ထိုမိသားစု၊ ထိုမြို့ရွာတိသည်လည်း မရပ်တည်နိုင်။ ");
INSERT INTO rki_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","စာတန်က စာတန်ကို မောင်းထုတ်နိန်လျှင် သူသည် မိမိကိုယ်တိုင် ကွဲပြားအောင်လုပ်နိန်ခြင်းဖြစ်၏။ ထိုသို့ ဆိုသော် သူ၏နိုင်ငံသည် ဇာပိုင် ရပ်တည်နိုင်မည်နည်း။ ");
INSERT INTO rki_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ငါသည် ဗေလဇေဗုလ၏တန်ခိုးကို အမှီပြု၍ နတ်ဆိုးတိကို မောင်းထုတ်နိန်သည်ဟု သင်ရို့က ဆိုလျှင် သင်ရို့၏တပည့်တိသည် ဇာသူ့တန်ခိုးဖြင့် နတ်ဆိုးတိကို မောင်းထုတ်နိန်ကတ်စွာလဲ။ သင်ရို့တပည့်တိက သင်ရို့၏အမှားကို သက်သီပြနိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","ငါသည် ဗေလဇေဗုလနတ်ဆိုး၏တန်န်ခိုးနှင့် လုပ်နိန်သည် မဟုတ်၊ ဘုရားသခင်ဝိညာဉ်တော်တန်ခိုးဖြင့် နတ်ဆိုးတိကို နှင်ထုတ်နိန်ခြင်းဖြစ်၏။ သို့ဖြစ်၍ ဘုရားသခင်နိုင်ငံတော်သည် သင်ရို့ပါးသို့ ရောက်နိန်ယာ။ ");
INSERT INTO rki_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“ခွန်အားကြီးသော လူတစ်ယောက်၏ အိမ်သို့ ဝင်၍ ထိုသူ၏ပစ္စည်းများကို လုယူမည်ဆိုလျှင် ထိုသူကို ဦးစွာ ချိုင်ထားပြီးမှ သူ၏အိမ်၌ ဟိသောပစ္စည်းများကို ရယူနိုင်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“ငါ့ဖက်၌ မဟိသောသူသည် ငါ့ကို ဆန့်ကျင်ဘက် ပြုနိန်သောသူ ဖြစ်၏။ ငါနှင့်အတူ တစ်စုတည်း မဟိသောသူသည် ပြန့်ကြဲနိန်သောသူ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","သို့ဖြစ်၍ ငါဆိုသည်ကား လူတိသည် နှုတ်ဖြင့် ပြစ်မှားမိသော အပြစ်နှင့် အပြစ်အမျိုးမျိုးမှ ခွင့်ရွှတ်ခြင်းရနိုင်ကြ၏၊ သို့ရာတွင် သန့်ယှင်းသောဝိညာဉ်တော်ကို နှုတ်ဖြင့် ပြစ်မှားမိသောသူသည် အပြစ်မှ ခွင့်ရွှတ်ခြင်း မရနိုင်။ ");
INSERT INTO rki_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","ဇာသူမဆို လူသားကို ဆန့်ကျင်ပြောဆိုမိသောသူသည် အပြစ်မှ ခွင့်ရွှတ်ခြင်း ရနိုင်၏။ သို့ရာတွင် သန့်ယှင်းသောဝိညာဉ်တော်ကို နှုတ်ဖြင့် ပြစ်မှားသောသူတိုင်းသည် အဂုဘဝ၊ နောင်ဘဝ အပြစ်မှ ခွင့်ရွှတ်ခြင်း မရနိုင်။ ");
INSERT INTO rki_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“အပင်ကောင်းလျှင် ထိုအပင်၏အသီးသည် ကောင်းလိမ့်မည်၊ အပင်မကောင်လျှင် ထိုအပင်၏အသီးသည် ကောင်းလိမ့်မည် မဟုတ်။ အသီးအားဖြင့် အပင်၏သဘောကို သိရ၏။ ");
INSERT INTO rki_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","မြွီဆိုးအမျိုးရို့၊ သင်ရို့ကဲ့သို့ လူဆိုးလူယုတ်တိ၏နှုတ်ထဲက ကောင်းသောစကားတိ ဇာပိုင် ထွက်လာနိုင်ဖို့လဲ။ စိတ်နှလုံးထဲ၌ ပြည့်လျှံလာသောကြောင့် နှုတ်မှ ထွက်လာခြင်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","ကောင်းသောသူသည် ကောင်းသောဘဏ္ဍာတိုက်ထဲက ကောင်းသောအရာတိကိုသာ ထုတ်ဖော်တတ်၏၊ မကောင်းသောသူသည် မကောင်းသောဘဏ္ဍာတိုက်ထဲက မကောင်းသောအရာတိကိုသာ ထုတ်ဖော်တတ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“သို့ရာတွင် သင်ရို့ကို ငါဆိုသည်ကား တရားစီရင်သည့်နိ့ရက်၌ လူတိုင်းသည် မိမိပြောသမျှသော အကျိုးမဟိသည့်စကားအတွက် ပီးဆပ်ကြရလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","အကြောင်းမူကား သင်ရို့၏စကားအားဖြင့် သင်ရို့သည် အပြစ်လွတ်ကြလိမ့်မည်၊ ပြီးနောက် သင်ရို့၏စကားဖြင့် သင်ရို့သည် ပြစ်ဒဏ်စီရင်ခြင်းကို ခံကြရလိမ့်မည်။” ");
INSERT INTO rki_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","ထို့နောက် ကျမ်းတတ်ဆရာတချို့နှင့် ဖာရိယှဲတချို့က “ဆရာ၊ အကျွန်ရို့သည် ကိုယ်တော်ပြသော နိမိတ်လက္ခဏာတစ်ခုကို မြင်ချင်ပါ၏” ဟု ကိုယ်တော့်ကို တောင်းလျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ယေသျှုက “ဆိုးယုတ်ပြီး ဘုရားတရားမဲ့နိန်ကြသော ဤခေတ်လူရို့၊ သင်ရို့သည် ငါ့အား နိမိတ်လက္ခဏာကို တောင်းဆိုနိန်ကတ်တေလား။ မဖြစ်နိုင်။ သင်ရို့ကို ပြမည့်နိမိတ်လက္ခဏာမှာ ပရောဖက်ယောန၏ နိမိတ်လက္ခဏာမျှသာ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ယောနသည် ငါးကြီးဝမ်းခေါင်းထဲ၌ သုံးရက်နှင့် သုံးည ကြာနိန်ခသည့်နည်းတူ လူသားသည် မြီကြီးထဲမှာ သုံးရက်နှင့် သုံးည နီရလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","တရားစီရင်သည့်နိ့ရက်၌ နိနေဝေမြို့သူမြို့သားတိသည် သင်ရို့တစ်ဘက်မှာရပ်လျက် သင်ရို့ကို အပြစ်တင်ကဲ့ရဲ့ကြလိမ့်မည်။ အကြောင်းမူကား သူရို့သည် ယောန ဟောသောတရားကို ကြားသောအခါ အပြစ်မှ နောင်တရကြသောကြောင့်ဖြစ်၏။ ငါအမှန်ဆိုသည်ကား၊ ယောန ထက် ကြီးမြတ်သောသူသည် ဤအရပ်၌ ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","တရားစီရင်သည့်နိ့ရက်၌ တောင်ပြည်ကို အုပ်စိုးရသည့်မိဖုရားသည် သင်ရို့တစ်ဖက်၌ ရပ်၍ သင်ရို့ကို ပြစ်တင်ကဲ့ရဲ့လိမ့်မည်။ အကြောင်းမူကား ထိုမိဖုရားကြီးသည် သျှောလမုန်မင်းကြီး၏ ပညာတရားကို နာယူလို၍ ခရီးအဝီးကြီးက လာရောက်လေ့ဟိ၏။ ငါအမှန်ဆိုသည်ကား၊ သျှောလမုန်ထက် ကြီးမြတ်သောသူသည် ဤအရပ်၌ ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“ဝိညာဉ်ဆိုးတစ်ကောင်သည် လူတစ်ယောက်ထဲက ထွက်လာသောအခါ အလွန်ခြောက်သွိ့သော အရပ်ဒေသတစ်ခုလုံးကို လှည့်လည်လျက် နားခိုမည့်နီရာတစ်ခုကို လိုက်ရှာ၏။ တစ်နီရာ မတွိ့လျှင် ");
INSERT INTO rki_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","‘ငါ ထွက်လာသည့် အိမ်သို့ ပြန်လားရဖို့’ ဟု သူ့ကိုသူ ပြောလျက်၊ ထိုအိမ်သို့ ပြန်လာ၍ ထိုအိမ်၌ နီထိုင်သူ တစ်ယောက်လည်း မဟိဘဲ၊ သန့်ယှင်း သပ်ယပ်လျက်ဟိသည်ကို တွိ့ရ၏၊ ");
INSERT INTO rki_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ထိုအခါ ဝိညာဉ်ဆိုးသည် ထွက်လားပြီးနောက် မိမိထက်ဆိုးသော တခြား ဝိညာဉ်ဆိုး ခုနစ်ကောင်ကို ခေါ်၍ ထိုအိမ်သို့ ပြန်လာကာ ဝင်ရောက်နီထိုင်လေ၏။ ထိုအခါ ထိုသူ၏ နောက်မှဖြစ်လာသောအခြေအနေသည် ရှိ့ကဖြစ်ခသည့်အခြေအနေထက် သာ၍ ဆိုးလေ၏။ ဤခေတ်ကာလ၏ ဆိုးသောသူတိသည်လည်း ဤသို့ ဖြစ်လာကြလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","ယေသျှုသည် ပရိသတ်တိနှင့် စကားပြောနိန်သောအခါ သူ့အမိနှင့် သူ၏ညီအစ်ကိုတိ ရောက်လာကြ၏။ သူရို့သည် သူနှင့် စကားပြောချင်၍ အပြင်က ရပ်စောင့်နိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ပရိသတ်ထဲမှ တစ်ယောက်က “ကြည့်လိုက်ပါ၊ ကိုယ်တော်၏အမိနှင့် ညီအစ်ကိုရို့သည် ကိုယ်တော်နှင့် စကားပြောချင်၍ အပြင်မှာ ရပ်စောင့်နိန်ကြ၏” ဟု ပြော၏။ ");
INSERT INTO rki_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ယေသျှုက “ငါ့အမိသည် ဇာသူနည်း၊ ငါ့ညီအစ်ကိုတိကား ဇာသူရို့ဖြစ်သနည်း” ဟူ၍ မိန်း၏။ ");
INSERT INTO rki_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ထို့နောက် ကိုယ်တော်က သူ၏တပည့်တော်တိကို လက်ညှိုးထိုးပြပြီးလျှင် “ကြည့်ကတ်ပါ၊ ဤနီရာ၌ ဟိသောသူတိသည် ငါ့အမိနှင့် ငါ့ညီအစ်ကိုတိ ဖြစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ကောင်းကင်ဘုံသျှင် ငါ့အဖ၏ အလိုတော်ကို လုပ်ဆောင်သောသူသည် ငါ့အမိ၊ ငါ့ညီအစ်ကိုနှင့် ငါ့ညီမဖြစ်ကြ၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","ထိုနိ့၌ ယေသျှုသည် အိမ်မှထွက်၍ အိုင်ဘေးနားသို့ လားပြီးလျှင် တရားဟောခြင်းငှာ ထိုင်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","လူအုပ်ကြီးသည် ကမ်းခြီ၌ ရပ်နိန်ကြစဉ်တွင် ကိုယ်တော်၏ပတ်လည်၌ စုရုံးရောက်လာကြသည့်လူတိသည် အလွန်များလာကြသဖြင့် ကိုယ်တော်သည် လောင်းတစ်စင်းထက်သို့ တက်၍ ထိုင်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ကိုယ်တော်သည် ပုံဥမာတိနှင့် ခိုင်းနှိုင်းကာ သူရို့အား ဆုံးမသြဝါဒ ပီးတော်မူ၏။ တစ်ခါက လူတစ်ယောက်သည် မျိုးစိကြဲရန်လားခ၏။ ");
INSERT INTO rki_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","မျိုးစိတိကို လယ်ထဲ၌ ကြဲသည့်အခါ မျိုးစိတချို့သည် လမ်းမှာကျသဖြင့် ငှက်တိ လာ၍ ကောက်စားပလိုက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","တချို့မျိုးစိတိသည် မြီဆီလွှာနည်းသော ကျောက်တောမှာ ကျကြ၏။ ထိုမျိုးစိတိသည် မြီဆီလွှာပါးသောကြောင့် ချက်ချင်း အညှောက်ပေါက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","သို့သော်လည်း အမြစ်များသည် ကျောက်ခဲတိကို မထိုးဖောက်နိုင်သောကြောင့်၊ နီထွက်လာသောအခါ အပင်ချေတိကို နီပူလောင်သဖြင့် ထိုအပင်ချေတိသည် ချက်ချင်း ခြောက်လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","အချို့မျိုးစိတိသည် ဆူးပင်များကြား၌ ကျသဖြင့်၊ ဆူးပင်တိသည် ကြီးထွားကာ ထိုအပင်ချေတိကို ဖိစီးထားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","သို့သော် မျိုးစိတချို့သည် ကောင်းသောမြီဆီလွှာမှာ ကျသဖြင့် အပင်များသည် အသီးသီးကြပြီးလျှင် အဆသုံးဆယ်၊ အဆခြောက်ဆယ်၊ အဆတစ်ရာ စသည်ဖြင့် ပွားများကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ယေသျှုက “နားဟိသောသူတိ ကြားကတ်ပါစီ” ဟူ၍ အဆုံးသတ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","ထို့နောက် တပည့်တော်ရို့သည် ယေသျှုပါးသို့ ချဉ်းကပ်၍ “ကိုယ်တော်သည် လူတိကို ပြောသည့်အခါ ပုံဥမာတိကို ဇာကြောင့် အသုံးပြုပါလဲ” ဟု မိန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ယေသျှုကလည်း “သင်ရို့သည် ကောင်းကင်နိုင်ငံတော်နှင့် ပတ်သက်သော နက်နဲခက်ခဲသည့် လျှို့ဝှက်ချက်တိကို သိရသောအခွင့်ဟိကြသော်လည်း ထိုသူရို့မူကား သိခွင့်မဟိကြ။ ");
INSERT INTO rki_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","ထို့ကြောင့် ရတတ်သောသူကို သာ၍ ပြည့်စုံစီခြင်းငှာ တဖန်ထပ်၍ ပီးလိမ့်မည်၊ ဆင်းရဲသောသူ၌ သူ့မှာဟိသမျှကို နုတ်ယူလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","ငါသည် သူရို့ကို ပုံဥမာတိသုံး၍ ပြောရသည့်အကြောင်းရင်းမှာ၊ ဤသူရို့သည် ကြည့်သော်လည်း မမြင်၊ နားထောင်သော်လည်း မကြား၊ နားမလည်ကြသည့်အတွက်ကြောင့်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","ထို့ကြောင့် ပရာဖက်ဟေသျှာယက သူရို့ကို ဤသို့ ဟောထားခ၏၊ “ ‘ဤသူရို့သည် နားထောင်ပြီးယင်း နားထောင်သော်လည်း နားမလည်ကတ်၊ သူရို့သည် ကြည့်ပြီးယင်း ကြည့်သော်လည်း မမြင်ကတ်၊ ");
INSERT INTO rki_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ဇာကြောင့်လဲဆိုကေ၊ သူရို့၏စိတ်နှလုံးသည် အမှောင်ဖုံးနိန်သောကြောင့်ဖြစ်၏။ သူရို့၏နားသည် ပင်းနိန်ကတ်၏။ သူရို့၏မျက်စိသည်လည်း ကန်းနိန်ကတ်၏။ ထိုသို့ မဟုတ်လျှင် သူရို့မျက်စိသည် မြင်ကတ်လိမ့်မည်။ နားသည်လည်း ကြားကတ်လိမ့်မည်။ သူရို့၏အသိစိတ်ထဲမှာ နားလည်သဘောပေါက်ကြလျှင် သူရို့သည် ငါ့ပါးသို့ ပြန်လှည့်လာကြလိမ့်မည်ဟု ဘုရားသခင်က မိန့်တော်မူ၏၊ ငါသည်လည်း သူရို့ကို ကျန်းမာစီမည်။’ ");
INSERT INTO rki_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“သို့သော် သင်ရို့၏မျက်စိတိသည် မြင်သောကြောင့်၊ သင်ရို့၏နားတိသည် ကြားသောကြောင့် မင်္ဂလာဟိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","သင်ရို့ကို ငါ အမှန်ဆိုသည်ကား ပရောဖက်တိနှင့် ဘုရားသခင်၏လူတိသည် သင်ရို့မြင်သည့်အရာများကို အလွန် မြင်ချင်ခသော်လည်း မမြင်ခရကတ်။ သင်ရို့ကြားသည့်အရာများကို အလွန် ကြားချင်ခသော်လည်း မကြားခရကတ်။ ");
INSERT INTO rki_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“မျိုးစိကြဲသူ ပုံဥပမာ၏ ဆိုလိုရင်းကို နားထောင်၍ သင်ခန်းစာယူကြလော့။ ");
INSERT INTO rki_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","နိုင်ငံတော်၏တရားစကားကို ကြားသော်လည်း နားမလည်သောသူသည် လမ်းတလျှောက်မှာ ကျနိန်ခသည့် မျိုးစိများနှင့် တူ၏။ နတ်ဆိုးသည် လာ၍ သူရို့၏စိတ်နှလုံးထဲ၌ ဟိသောတရားစကားကို လုယူဖယ်ယှားတတ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","ကျောက်ခံမြီမှာ ကျသည့် မျိုးစိများသည်ကား တရားစကားကို ကြားသည်နှင့် ဝမ်းမြောက်စွာ လက်ခံတတ်သောသူကို ဆိုလိုခြင်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","သို့သော်လည်း ထိုတရားစကားသည် သူရို့၏ စိတ်နှလုံးထဲ၌ အမြစ်မစွဲသဖြင့် ကြာရှည်စွာမခံ၊ ထိုတရားစကားကြောင့် အမှုအခင်း သို့မဟုတ် နှိပ်စက်ညှဉ်းဆဲခြင်းနှင့် ကြုံတွိ့ရသောအခါ သူရို့သည် ချက်ချင်း ဖောက်ပြန်လားတတ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","ဆူးပင်များကြား၌ ကျသောမျိုးစိဟူသည်ကား တရားစကားကို ကြားသော်လည်း ဤဘဝအတွက် စိုးရိမ်စိတ်များနှင့် လောကီတပ်မက်မှုများက တရားစကားကို လွှမ်းမိုးကြီးစိုးထားသဖြင့် အသီးမသီးနိုင်သောသူကို ဆိုလိုခြင်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ထို့နောက် ကောင်းသောမြီမှာ ကျသောမျိုးစိ တိသည်ကား တရားစကားကို ကြား၍ သဘောပေါက်နားလည်ပြီး အဆသုံးဆယ်၊ အဆခြောက်ဆယ်၊ အဆတစ်ရာ၊ စသည်ဖြင့် ပွားများကာ အသီးကို သီးတတ်သောသူတိကို ဆိုလိုခြင်းဖြစ်သည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ယေသျှုသည် သူရို့အား အခြားသောပုံဥမာကို ဆောင်၍ မိန့်တော်မူသည်မှာ “ကောင်းကင်နိုင်ငံတော်သည် ဤပုံဥပမာနှင့် တူ၏။ လူတစ်ယောက်သည် မိမိလယ်၌ ကောင်းသောမျိုးစိကို ကြဲထားခ၏။ ");
INSERT INTO rki_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","တစ်ညတွင် လူတိ အိပ်နိန်ကြသောအခါ ရန်သူတစ်ဦးသည် လာ၍ ဂျုံမျိုးစိများကြားထဲ၌ မြက်ရိုင်းမျိုးစိများကို ကြဲထားခပြီး၊ အဝီးကို ထွက်လားခ၏။ ");
INSERT INTO rki_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","အပင်တိကြီးထွားလာပြီး ကောက်နှံထွက်လာချိန်တွင် ဂျုံပင်တိနှင့်အတူ မြက်ရိုင်းပင်တိလည်း ပေါ်ထွက်လာ၏။ ");
INSERT INTO rki_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ယင်းအခါ အခိုင်းအစီတိက ပိုင်သျှင်ပါးသို့ ရောက်လာကာ ‘ဆရာ၊ လယ်ကွက်ထဲ၌ ကောင်းသောဂျုံမျိုးစိများကိုသာ ကြဲခသည် မဟုတ်ပါလား၊ ဤမြက်ရိုင်းပင်တိသည်ကား ဇာက ရောက်လာကတ်ပါလဲ’ ဟု မိန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ပိုင်သျှင်က ‘ဤသည်ကား ရန်သူတချို့ ကြဲထားခစွာ ဖြစ်တေ’ ဟု ပြန်ပြော၏၊ ‘အကျွန်ရို့သည် ဤမြက်ရိုင်းပင်တိကို လား၍ နုတ်ပစ်ခီရပါဖို့လား’ ဟု သူရို့က မိန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","ပိုင်သျှင်က ‘နုတ်စရာမလို၊ ဇာကြောင့်လဲဆိုကေ မြက်ရိုင်းပင်တိကို နုတ်လိုက်လျှင် ထိုအပင်တိနှင့်အတူ ဂျုံပင်တိပါ ရောပါလားလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ရိတ်သိမ်းချိန်ရောက်သည့်တိုင်အောင် မြက်ရိုင်းပင်တိသည် ဂျုံပင်တိနှင့်အတူ ကြီးထွားနိန်ကတ်ပါစီ။ ရိတ်သိမ်းချိန်ရောက်ခါမှသာ မြက်ရိုင်းပင်တိကို ဦးစွာ ရွီးနုတ်ပြီး စုစည်းကာ မီးရှို့ပစ်လိုက်ကတ်၊ ဂျုံနှံတိကိုမူကား ရိတ်သိမ်း၍ ပုတ်ထဲမှာ စုထားလိုက်ကတ်ဟု ကောက်ရိတ်သမားတိကို ငါ မှာထားမည်’ ဟု မိန့်တော်မူ၏။” ");
INSERT INTO rki_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ယေသျှုသည် အခြားသော ပုံဥပမာတစ်ခုကို သူရို့အား ပြောပြသည်မှာ “ကောင်းကင်နိုင်ငံတော်သည် ဤပုံဥပမာနှင့် တူ၏။ လူတစ်ယောက်သည် မုန်ညှင်းစိ တစ်စိကို ယူ၍ သူ၏လယ်ထဲ၌ ကြဲလိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","မှန်ညှင်းစိသည် မျိုးစိအားလုံးထဲမှာ အသေးငယ်ဆုံးဖြစ်သော်လည်း အပင်ပေါက်၍ ကြီးလာသောခါ သီးနှံပင်အားလုံးထဲမှာ အကြီးဆုံး အပင်တစ်ပင် ဖြစ်လာ၏။ အပင်ကြီးတစ်ပင် ဖြစ်လာသောအခါတွင် ငှက်တိ လာ၍ ထိုအပင်၏ အကိုင်းအခက်များ၌ မိမိရို့၏အသိုက်များကို တည်ဆောက်တတ်ကြ၏” ဟူ၍ မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ယေသျှုသည် တပည့်တော်တိအား အခြားသော ပုံဥမာတစ်ခုဖြင့် မိန့်တော်မူသည်မှာ၊ “ကောင်းကင်နိုင်ငံတော်သည် ဤကဲ့သို့ဖြစ်၏။ မိန်းမတစ်ယောက်သည် တဆီးအချို့ကို ယူ၍ မုန့်ညက်သုံးတောင်းနှင့် ရောနယ်လိုက်သောအခါ ထိုတဆီးသည် မုန့်ညက်အားလုံးကို ဖောင်းပွလားစီတတ်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ယေသျှုသည် လူထုပရိသတ်များအား ဟောပြောသောခါတိုင်း၌ ပုံဥမာများကို အသုံးပြုတော်မူ၏၊ ကိုယ်တော်သည် သူရို့အား ပုံဥပမာမသုံးဘဲ ဇာအကြောင်းကိုမျှ ဟောပြောတော်မမူ။ ");
INSERT INTO rki_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ဤသို့ ဟောပြောရသည့်အကြောင်းမှာ ပရောဖက် ဟောထားခသော ကျမ်းစကား ပြည့်စုံလာခြင်းဖြစ်၏။ ထိုကျမ်းစကားများမှာ၊ “သူရို့ကို ငါ ပြောသောအခါ ပုံဥပမာများကိုသာ အသုံးပြုမည်။ ဤလောကကို ဖန်ဆင်းစဉ်ကတည်းကပင် သူရို့မသိယောင် ဝှက်ထားသောအရာများကို ငါသည် ဖော်ထုတ်၍ ပြောရလိမ့်မည်” ဟု ဖြစ်သတည်း။ ");
INSERT INTO rki_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","ယေသျှုသည် လူစုလူဝေးကို ထားခပြီး အိမ်ထဲသို့ ဝင်ရောက်လာ၏။ သူ၏တပည့်တော်ရို့သည်လည်း နောက်တော်သို့ လိုက်လာလျက်၊ “အကျွန်ရို့အား မြက်ရိုင်းပင်၏ ပုံဥပမာအကြောင်းကို ယှင်းပြတော်မူပါ” ဟု လျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ယေသျှုကလည်း “လူသားသည် ကောင်းသောမျိုးစိကို ကြဲသောသူဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","လယ်ကွက်သည်ကား လောကဖြစ်၏။ ကောင်းသောမျိုးစိ ဟူမူကား နိုင်ငံတော်သားတိ ဖြစ်ကြပြီး၊ မြက်ရိုင်းပင်များမှာ နတ်ဆိုး၏သားများ ဖြစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","မြက်ရိုင်းမျိုးစိကို ကြဲသောရန်သူမှာ မာရ်နတ်ဖြစ်၏။ ရိတ်သိမ်းသောကာလသည်ကား ကပ်ကမ္ဘာကုန်ဆုံးချိန် ဖြစ်၍ ကောက်ရိတ်သမားများမှာ ကောင်းကင်တမန်များဖြစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","မြက်ရိုင်းပင်တိကို စုသိမ်း၍ မီးရှို့သကဲ့သို့ ကပ်ကမ္ဘာကုန်ဆုံးချိန်၌ ထိုသို့ ဖြစ်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","လူသားသည် မိမိ၏ကောင်းကင်တမန်တိကို စီရွှတ်ပြီး မကောင်းမှုကို ပြုသောသူတိနှင့် အပြစ်သို့ သွီးဆောင်သောသူ အားလုံးကို သူ၏နိုင်ငံတော်ထဲက ရွီးထုတ်ရန် သူ၏ကောင်းကင်တမန်များကို စီရွှတ်လိမ့်မည်၊ ");
INSERT INTO rki_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ထို့နောက် ထိုကောင်းကင်တမန်များသည် ထိုသူရို့ကို မီးအိုင်ထဲသို့ ပစ်ချလိမ့်မည်၊ ထိုသူရို့သည် ထိုမီးအိုင်ထဲ၌ အံသွားခဲကြိတ်ကာ ငိုကျွီးရကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ထို့နောက် ဘုရားသခင်၏ လူတိသည်ကား သူရို့အဖ၏နိုင်ငံတော်၌ နီကဲ့သို့ ထွန်းလင်းကြလိမ့်မည်။ နားဟိသောသူရို့ ကြားကတ်ပါစီ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“ကောင်းကင်နိုင်ငံတော်သည် ဤကဲ့သို့ ဖြစ်၏။ လူတစ်ယောက်သည် လယ်ကွက်တစ်ခု၌ ဝှက်ထားသော ပစ္စည်းဥစ္စာကို တွိ့၏။ ထိုသူသည် ထိုပစ္စည်းဥစ္စာကို တဖန် ဖုံးအုပ်ထားခပြီးလျှင် ဝမ်းမြောက်သောစိတ်ဖြင့် ပြန်လားကာ သူ၌ ဟိသမျှ ပစ္စည်းကို ရောင်း၍ ထိုလယ်ကို ဝယ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“ကောင်းကင်နိုင်ငံတော်သည် ဤကဲ့သို့လည်း ဖြစ်၏။ လူတစ်ယောက်သည် ကောင်းသော ပုလဲကို ရှာနိန်၏။ ");
INSERT INTO rki_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ထိုသူသည် ထူးဆန်းသောပုလဲကို တွိ့သောအခါ သူသည် ပြန်လား၍ မိမိ၌ ဟိသမျှကို ရောင်းချပြီးလျှင် ထိုပုလဲကို ဝယ်ယူလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“ကောင်းကင်နိုင်ငံတော်သည် ဤကဲ့သို့လည်း ဖြစ်၏။ တံငါသည် တချို့သည် သူရို့၏ငါးဖမ်းပိုက်ကို အိုင်၌ ချကာ ငါးမျိုးစုံတိကို ဖမ်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ငါးမျိုးစုံတိ ပိုက်မှာ ကျနိန်ကြသောအခါ ထိုတံငါများသည် ပိုက်ကို သောင်ပြင်သို့ ဆွဲတင်၍ ငါးရွီးရန် ထိုင်ကြ၏၊ ကောင်းသောငါးများကို ပလိုင်းထဲသို့ ထည့်ကြပြီးလျှင် မကောင်းသောငါးများကိုမူကား ဝေးပစ်လိုက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","ကပ်ကမ္ဘာကုန်ဆုံးချိန်၌ ဤကဲ့သို့ ဖြစ်လာလိမ့်မည်၊ ကောင်းကင်တမန်တိ ဆင်းလာကြပြီးလျှင် ဖြောင့်မတ်သောသူရို့အထဲမှ ဆိုးသောသူတိကို ရွီးထုတ်ကာ ");
INSERT INTO rki_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","မီးအိုင်ထဲသို့ ပစ်ချကြလိမ့်မည်၊ ထိုသူရို့သည် ထိုမီးအိုင်ထဲ၌ အံသွားခဲကြိတ်၍ ငိုကျွီးရကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“သင်ရို့သည် ဤအရာများကို နားလည်ကတ်လား” ဟု ယေသျှုက မိန်းတော်မူသောအခါ၊ တပည့်တော်ရို့က “နားလည်ပါရေ” ဟု ပြန်၍လျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ထိုအခါ ကိုယ်တော်ကလည်း “ကောင်းကင်နိုင်ငံတော်၌ တပည့်တော် တစ်ယောက်ဖြစ်လာသော ကျမ်းတတ်ဆရာသည်ကား မိမိအိမ်၏စတိုခန်းထဲက ပစ္စည်းအဟောင်းနှင့် အသစ်များကို ထုတ်ယူသုံးစွဲတတ်သော အိမ်သျှင်နှင့် တူ၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","ယေသျှုသည် ဤပုံဥပမာများကို ပြောပြီးနောက် ထိုအရပ်မှ ထွက်ခွါပြီးလျှင် ");
INSERT INTO rki_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","သူ၏ဇာတိမြို့သို့ ပြန်ကြွတော်မူ၏။ တရားဇရပ်၌ ဆုံးမဩဝါဒများကို သွန်သင်တော်မူ၍ ကြားနာသောသူများသည် အလွန်အံ့သြကြ၏။ “ဤသူကား ဤသို့သောပညာကို ဇာနီရာက ရလာစွာလဲ။ သူသည် ဤနိမိတ်လက္ခဏာတိကို ဇာကြောင့် လုပ်နိုင်စွာလဲ။ ");
INSERT INTO rki_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","သူသည် လက်သမား၏သားဖြစ်သည် မဟုတ်လား။ သူ့အမိသည် မာရိဖြစ်ပြီး ယာကုပ်၊ ယောဟန်၊ သျှိမုန် နှင့် ယုဒရို့သည် သူ၏ညီအစ်ကိုတိ ဖြစ်ကြသည် မဟုတ်လား။ ");
INSERT INTO rki_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","သူ၏ညီမတိလည်း ဤအရပ်၌ နီထိုင်ကြသည် မဟုတ်ပါလား။ သူသည် ဤအရာတိကို ဇာနီရာက ရလာစွာလဲ” ဟု အချင်းချင်း ပုတ်ခတ်ပြောဆိုလျက် ");
INSERT INTO rki_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ကိုယ်တော့်ကို ငြင်းပယ်ကြ၏။ ထို့ကြောင့် ယေသျှုက သူရို့အား “ပရောဖက်တစ်ယောက်သည် မိမိဇာတိမြို့နှင့် မိမိ၏မိသားစု ကလွဲ၍ နီရာတိုင်းမှာ အရိုအသီခံရ၏” ဟူ၍ မိန့်တော် မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","သူရို့သည် မယုံကြည်ကြသောကြောင့် ကိုယ်တော်သည်လည်း ထိုအရပ်၌ နိမိတ်လက္ခဏာများစွာကို ပြတော်မမူခပေ။ ");
INSERT INTO rki_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ထိုအချိန်၌ ဂါလိလဲပြည်ကို အုပ်ချုပ်သည့် ဟေရုဒ်မင်းသည် ယေသျှုအကြောင်းကို ကြားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ထိုအခါ သူက “ဤသူသည် သီခြင်းက ထမြောက်လာသော ဗတ္တိဇံယောဟန် အမှန်ပင်ဖြစ်၏။ ထို့ကြောင့် နိမိတ်လက္ခဏာတိကို ပြရန် တန်ခိုးဟိ၏” ဟု မိမိအရာဟိတိကို ပြော၏။ ");
INSERT INTO rki_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","ဟေရုဒ်မင်းသည် မိမိ၏ညီ ဖိလိပ္ပု၏မယား ဟေရောဒိနှင့် ပတ်သက်၍ ယောဟန်ကို သံကြိုးနှင့် ချိုင်၍ ဖမ်းဆီးကာ ထောင်ထဲ၌ ချထားခ၏။ ");
INSERT INTO rki_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","အကြောင်းမူကား၊ ဗတ္တိဇံယောဟန်က “သင်သည် ဟေရောဒိကို လက်ထပ်ခြင်းသည်ကား တရားတော်နှင့် မကိုက်ညီ” ဟု မကြာမကြာ ပြောဆိုခြင်းကြောင့် ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ဟေရုဒ်သည် ယောဟန်ကို သတ်လိုသော်လည်း ယုဒလူများက သူသည် ပရောဖက်တစ်ပါးဖြစ်သည် ဟု သိနိန်ကြသောကြောင့် ထိုသူရို့ကို ကြောက်နိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","ဟေရုဒ်၏မွီးနိ့ပွဲတွင် ဟေရောဒိ၏သမီးသည် ပရိသတ်တိရှိ့တွင် ကပြဖျော်ဖြေ၏။ ဟေရုဒ်မင်းသည် အလွန်စိတ်ရွှင်လန်းသည်ဖြစ်၍ ");
INSERT INTO rki_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","“သင်တောင်းသမျှကို ငါ ပီးမည်ဟု သင့်ကို ငါ ကျိန်ပြော၏” ဟု သူမအား ကတိပီးလိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","ထိုမိန်းမငယ်ကလည်း သူမ၏မိခင် အကြံပီးထားသည့်အတိုင်း “ဗတ္တိဇံယောဟန်၏ဦးဂေါင်းကို ဤဗျ့ထက်၌ အဂုပင်လျှင် ပီးတော်မူပါ” ဟု တောင်းလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ထိုအခါ မင်းကြီးသည် အလွန် စိတ်ထိခိုက်သော်လည်း ဧည့်ပရိသတ်ရှိ့တွင် ကတိပီးထားပြီးဖြစ်သောကြောင့်၊ သူမ၏ဆန္ဒအတိုင်း လုပ်ပီးရန် အမိန့်ပီးလိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ယေဇူးနန့် ထောင်ထဲ၌ ချထားသော ယောဟန်၏ဦးဂေါင်းကို ဖြတ်ပြီးလျှင် ");
INSERT INTO rki_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ဗျ့၌ ထည့်၍ သူမအား ပီးလိုက်၏။ သူမသည် ယောဟန်၏ဦးဂေါင်းကို မိခင်၏လက်သို့ အပ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ယောဟန်၏တပည့်များသည်လည်း ယောဟန်၏ အလောင်းကို သယ်ယူ၍ သင်္ဂြိုလ်ကြ၏။ ထို့နောက် သူရို့သည် လား၍ ယေသျှုအား ပြောကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","ယေသျှုသည် ယောဟန်၏သတင်းကို ကြားသောခါ၊ ထိုအရပ်မှ လောင်းတစ်စီးဖြင့် လူသူကင်းမဲ့ရာအရပ်သို့ တစ်ယောက်တည်း ကြွတော်မူ၏။ ဤသတင်းကို လူတိကြားသောအခါ မိမိရို့မြို့ရွာအသီးသီးမှ ထွက်၍ ကုန်းကြောင်းခရီးဖြင့် ကိုယ်တော်၏နောက်သို့ လိုက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ယေသျှုသည် လောင်းထက်မှ ဆင်းပြီးနောက် လူအုပ်ကြီးကို မြင်သောအခါ စိတ်နှလုံးထဲ၌ အလွန် သနားတော်မူသည်ဖြစ်၍ မကျန်းမာသောသူများကို ကျန်းမာစီတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ထိုနိ့ညစာဖက်၌ တပည့်တော်တိသည် ကိုယ်တော်အပါးသို့ ရောက်လာကြပြီးလျှင် “မိုးချုပ်ပြီဖြစ်၍ လူသူကင်းမဲ့သည့် အရပ်ဖြစ်၏။ ဤသူရို့အဖို့ စားစရာဝယ်ခြင်းငှာ လူအချို့ကို ကျေးရွာများသို့ စီရွှတ်တော်မူပါ” ဟု လျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","ယေသျှုကလည်း “သူရို့လားစရာမလို၊ သင်ရို့ကိုယ်တိုင် သူရို့ကို စားစရာ တစ်စုံတစ်ခု ပီးကတ်ရဖို့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ထိုအခါ တပည့်တော်တိက “အကျွန်ရို့အားလုံးမှာ မုန့်ငါးလုံးနှင့် ငါးနှစ်ကောင်ရာ ဟိပါ၏” ဟု ပြန်လျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ကိုယ်တော်ကလည်း “ထိုသို့ဆိုသော်၊ သင်ရို့မှာ ဟိသောအရာများကို ငါ့ပါးသို့ ယူလာကတ်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ကိုယ်တော်သည် လူပရိသတ်တိကို မြက်ခင်းပြင်ထက်မှာ ထိုင်ခိုင်းလိုက်၏။ ထို့နောက် မုန့်ငါးလုံးနှင့် ငါးနှစ်ကောင်ကို ယူ၍ ကောင်းကင်သို့ မျှော်ကြည့်လျက် ဘုရားသခင်၏ကျေးဇူးတော်ကို ချီးမွမ်းပြီးမှ မုန့်ကိုဖဲ့၍ တပည့်တော်တိကို ပီး၏၊ တပည့်တော်တိသည် ထိုမုန့်ကို လူတိအား ဝီငှပီးကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","လူအားလုံး ဝစွာစားကြပြီးမှ၊ စားကြွင်းစားကျန်တိကို လိုက်၍ ကောက်သိမ်းသောအခါ တောင်းနှင့် တစ်ဆယ့်နှစ်တောင်း အပြည့် ရ၏။ ");
INSERT INTO rki_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","စားသုံးကြသောလူဦးရေမှာ မိန်းမနှင့် အသျှေတိမပါဘဲ၊ ယောက်ျားတိချည်း သီးသန့် ၅,၀၀၀ ခန့် ဟိလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ယေသျှုသည် လူတိကို ပြန်ရွတ်တော်မူစဉ်၊ တပည့်တော်ရို့ကိုလည်း လောင်းထဲသို့ ဝင်ခိုင်းကာ အိုင်တစ်ဘက်ကမ်းသို့ သူ၏ရှိ့က ကူးခိုင်းလိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","လူတိကို ပြန်ရွှတ်လိုက်ပြီးနောက် ကိုယ်တော်သည် ဆုတောင်းရန် တောင်ကုန်းထက်သို့ တက်လား၏။ ညအချိန်ရောက်သောအခါ ကိုယ်တော်သည် ထိုအရပ်၌ တစ်ယောက်တည်း ဟိလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ထိုအချိန်၌ လောင်းသည် ကမ်းနှင့် ဝီးကွာလာသောခါ၊ လီဆန်ဖြစ်သောကြောင့် လှိုင်းထသဖြင့် လောင်းသည် လူးလွန့်လျက် ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","မိုးသောက်ဘက် သုံးချက်တီးချိန်နှင့် ခြောက်ချက်တီးအချိန်ကြားတွင် ယေသျှုသည် ရီထက်၌ လမ်းလျှောက်၍ တပည့်တော်တိပါးသို့ လာ၏။ ");
INSERT INTO rki_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ထိုသို့ ကိုယ်တော်သည် ရီထက်က လမ်းလျှောက်လာသည်ကို တပည့်တော်ရို့သည် မြင်ကြသောအခါ ထိန့်လန့်တုန်လှုပ်လျက်၊ “ဆစ်စီ” ဟု ကြောက်ရွံ့စွာ အော်ဟစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ယေသျှုလည်း ချက်ချင်းပင် “မကြောက်ကတ်ကေ့။ တည်ကြည်ကြလော့။ ငါရာဖြစ်၏” ဟု ပြန်ပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ထိုအခါ ပေတရုက “သခင်ဘုရား၊ ကိုယ်တော်သာမှန်လျှင် အကျွန်လည်း ရီထက်က လမ်းလျှောက်၍ ကိုယ်တော်ပါးသို့ လာစီခြင်းငှာ မိန့်တော်မူပါ” ဟု လှမ်း၍ ပြော၏။ ");
INSERT INTO rki_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ယေသျှုကလည်း “လာလော့” ဟု အမိန့် ပီးလိုက်သည်နှင့် ပေတရုသည် လောင်းထဲက ဆင်းကာ ရီထက်မှာ လမ်းလျှောက်၍ ယေသျှုပါးသို့ လား၏။ ");
INSERT INTO rki_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","သို့သော် သူသည် လီကြမ်းတိုက်သည်ကို သတိထားမိသဖြင့် ကြောက်စိတ်ဝင်လာ၍ ရီထဲသို့ မြုပ်လုသည်ဟိသော် “အသျှင်၊ အကျွန့်ကို ကယ်တော်မူပါ” ဟု အော်ဟစ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ယေသျှုသည် ချက်ချင်း လက်ကို ဆန့်၍ ပေတရုကို ဆွဲကိုင်ပြီးလျှင် “ယုံကြည်ခြင်းအားနည်းသောသူ ဇာကြောင့် မယုံသင်္ကာဖြစ်နိန်လဲ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","သူရို့နှစ်ယောက်သည် လောင်းထက်သို့ ရောက်သောအခါ လီသည်လည်း ငြိမ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ထိုအခါ လောင်းထဲ၌ ဟိသောတပည့်တော်တိက ယေသျှုကို ကိုးကွယ်လျက် “ကိုယ်တော်သည် ဘုရားသား အမှန်ပင် ဖြစ်၏” ဟု လျှောက်ကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ယေသျှုနှင့် တပည့်တော်ရို့သည် အိုင်ကို ဖြတ်၍ ဂင်္နေသရက်အရပ်သို့ ရောက်လာကြ၍ ");
INSERT INTO rki_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ထိုအရပ်၌ နီထိုင်ကြသော လူများက ကိုယ်တော့်ကို သိကြ၏။ ထို့ကြောင့် သူရို့သည် ပတ်ဝန်းကျင်အနီးအနားမှ မကျန်းမာသောသူများကို ယေသျှုထံသို့ ခေါ်ဆောင်လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ထိုမကျန်းမာသောသူများက ကိုယ်တော်၏ဝတ်ရုံအနားပန်းဖွားကို တို့ခွင့်ရစီခြင်းငှာ တောင်းဆိုကြ၏။ ဝတ်ရုံအစွန်အဖျားချေကို တို့ရုံမျှဖြင့် လူမမာတိအားလုံး ကျန်းမာကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","ထိုအခါ ဖာရိယှဲနှင့် ကျမ်းတတ်ဆရာတချို့သည် ယေရုဆလင်မြို့မှ ယေသျှုပါးသို့ ရောက်လာကြပြီးလျှင် ");
INSERT INTO rki_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“ကိုယ်တော်၏တပည့်တော်တိသည် အစာမစားခင် လက်ကို မဆီးကြသည်မှာ အကျွန်ရို့အဖိုးအဖီးတိ၏ ရိုးရာအစဉ်လာကို ချိုးဖျက်နိန်ကတ်၏၊ ဇာကြောင့်ပါလဲ” ဟု ကိုယ်တော့်ကို မိန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ယေသျှုကလည်း “သင်ရို့သည် ဘုရားသခင်၏ပညတ်တော်တိကို ချိုးဖျက်၍ သင်ရို့ ဖိုးဖီးများ၏သွန်သင်မှုနောက်ကို လိုက်နိန်ကြသည်မှာ ဇာကြောင့်လဲ ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ဘုရားသခင် မိန့်တော်မူသည်ကား ‘သင်ရို့၏ အမိနှင့် အဖကို ရိုသီစွာ ပြုကြပါ’ ထို့နောက် ‘သင်ရို့သည် သင်ရို့၏အမိ သို့မဟုတ် အဖကို ကျိန်ဆဲသောသူသည် အသီသတ်ခြင်းကို ခံထိုက်၏။’ ");
INSERT INTO rki_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","သို့ရာတွင်၊ လူတစ်ယောက်၌ သူ၏အမိ သို့မဟုတ် အဖအား ထောက်ပံ့ရန် ပစ္စည်းတစ်စုံတစ်ခု ဟိသော်လည်း ‘ဤအရာသည် ဘုရားသခင်နှင့် သက်ဆိုင်တော်မူ၏။’ ");
INSERT INTO rki_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","မိမိ၏အဖအား ကန်တော့ရန် မလို ဟူ၍ ပြောဆိုလျက် သင်ရို့သည် သွန်သင်နိန်ကြ၏။ ဤနည်းအားဖြင့် သင်ရို့သည် ဖိုးဖီးရို့၏သွန်သင်မှုနောက်ကို လိုက်နာရန် ဘုရားသခင်၏ပညတ်တော်ကို ပယ်ထားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","သူတော်ကောင်းယောင်ဆောင်သောသူရို့၊ ပရောဖက် ဟေသျှာယသည် သင်ရို့အတွက် ဟောထားခသည်မှာ ကောင်းကောင်း မှန်နိန်၏။ ");
INSERT INTO rki_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“ ‘ဤလူတိကား ငါ့ကို နှုတ်ဖြင့်သာ ရိုသေကြ၏။ စိတ်နှလုံးမူကား ငါနှင့် အမှန်ပင် ဝီးကွာလျက် ဟိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ငါ့အား ဝတ်ပြုခြင်းသည် သူရို့အတွက် အချည်းနှီးဖြစ်၏။ အကြောင်းမူကား သူရို့သည် လူ၏ကျင့်ဝတ်ကို ငါ၏ ပညတ်ကဲ့သို့ သွန်သင်နိန်ကြ၏။’ ” ");
INSERT INTO rki_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ထို့နောက် ယေသျှုသည် လူအပေါင်းရို့ကို မိမိထံပါးသို့ ခေါ်ပြီးလျှင်၊ “နားထောင်၍ သဘောပေါက်ကြလော့။ ");
INSERT INTO rki_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","လူတစ်ယောက်၏ ခံတွင်းထဲသို့ ဝင်သောအရာများသည် ထိုသူကို ညစ်ညမ်းစီသည်မဟုတ်။ ထိုသူ၏ခံတွင်းထဲမှ ထွက်လာသောအရာများကသာ ထိုသူကို ညစ်ညမ်းစီ၏” ဟု မိန့်တော် မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ထို့နောက် တပည့်တော်ရို့သည် ကိုယ်တော်ထံပါးသို့ လာ၍ “ကိုယ်တော် ပြောသောစကားကြောင့် ဖာရိယှဲရို့သည် အလွန် စိတ်နာကြသည်ကို ကိုယ်တော်သိပါလား” ဟု လျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ယေသျှုကလည်း “ကောင်းကင်ဘုံသျှင် အကျွန့်အဖ စိုက်တော်မမူသော အပင်ဟိသမျှသည် အမြစ်ပါ မကျန်ယောင် နုတ်ပစ်ခြင်းခံရလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","ဖာရိယှဲတိကို စိုးရိမ်စရာမလို။ သူရို့သည် မျက်စိကန်းနိန်သောသူရို့ကို လမ်းပြနိန်ကြသော မျက်ကမ်းလမ်းပြများသာ ဖြစ်ကြ၏။ အကန်းကို အကန်းက လမ်းပြလျှင် ထိုသူနှစ်ယောက်စလုံးသည် ချောက်ထဲသို့ ကျလားကတ်လိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ပေတရုကလည်း “ဤပုံဥပမာကို အကျွန်ရို့အား ယှင်းပြပီးပါ” ဟု လျှောက်ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ယေသျှုက “သင်ရို့သည် အခြားလူတိထက် သာလွန်သောဉာဏ်ပညာ မဟိကြသိမ့်ပါကား။ ");
INSERT INTO rki_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","လူတစ်ယောက်၏ခံတွင်းထဲသို့ ဝင်သောအရာဟူသမျှသည် သူ၏အစာအိမ်ထဲသို့ ဝင်လားပြီးနောက် ခန္ဓာကိုယ်၏ပြင်ပ ရီအိမ်ထဲသို့ ထွက်လားသည်ကို သင်ရို့ မသိကတ်သိမ့်လား။ ");
INSERT INTO rki_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","သို့သော်လည်း ခံတွင်းမှ ထွက်သောအရာများသည် စိတ်နှလုံးထဲမှ လာကြသောကြောင့် ကိုယ်ကျင့်သီလနှင့်ပတ်သက်၍ လူကို ညစ်ညမ်းစီတတ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","အဘယ်ကြောင့်ဆိုသော်၊ လူအသက်ကို သတ်ခြင်း၊ သူ့မယားကို ပြစ်မှားခြင်း၊ မတရားသောမေထုန်မှီဝဲခြင်း၊ သူတစ်ပါးဥစ္စာကို ခိုးယူခြင်း၊ မမှန်သောသက်သီခံခြင်း၊ သူတစ်ပါးကို အတင်းပြောခြင်း စသောအရာတိကို ပြုခြင်းငှာ ထိုသူအား ဦးဆောင်နိန်သော မကောင်းသည့် အကြံအစည်များမှာ စိတ်နှလုံးထဲမှ ထွက်လာကြခြင်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ဤအရာများသည် လူတစ်ယောက်ကို ညစ်ညမ်းစီသည့်အရာများ ဖြစ်ကြ၏။ သို့ရာတွင် သူရို့ပြောသည့်အတိုင်း လက်မဆီးဘဲ အစာစားခြင်းသည်ကား လူတစ်ယောက်ကို ညစ်ညမ်းစီသည် မဟုတ်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ယေသျှုသည် ထိုအရပ်မှ ထွက်ခွါပြီး တုရုနှင့် ဇိဒုန်မြို့ အနီးဝန်းကျင်ဒေသသို့ ကြွတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ထိုဒေသ၌ နီထိုင်သော ခါနာန်မိန်းမ တစ်ယောက်သည် ယေသျှုပါးသို့ ရောက်လာပြီး “ဒါဝိဒ်၏သားတော် အကျွန့်ကို သနားတော်မူပါ အသျှင်၊ အကျွန်၏သမီးသည် နတ်ဆိုး ဝင်ပူး၍ ပြင်းထန်စွာ ဝေဒနာခံစားနိန်ရပါ၏” ဟု ငိုယို၍ လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","သို့သော်လည်း ယေသျှုသည် သူမအား စကားတစ်ခွန်းမျှ ပြန်ပြောတော်မမူ။ ကိုယ်တော်၏တပည့်တော်ရို့သည် ကိုယ်တော့်ပါးသို့ လာရောက်ကာ “သူမကို ပြန်ခိုင်းလိုက်ပါ၊ သူမသည် နားပူနားဆာ လုပ်ကာ အကျွန်ရို့နောက်က လိုက်နိန်ပါရေ” ဟု တောင်းပန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ယေသျှုကလည်း “ဣသရေလအမျိုးထဲမှ ပျောက်နိန်ကြသောသိုးများ အတွက်သာ ငါ့ကို စီရွှတ်လိုက်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","သို့သော်လည်း ထိုအမျိုးသမီးသည် ကိုယ်တော်၏ ခြီတော်ရင်းသို့ လာ၍ ပျပ်ဝပ်လျက် “ဆရာ၊ အကျွန့်ကို ကူညီတော်မူပါ” ဟု လျှောက်၏။ ");
INSERT INTO rki_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ယေသျှုကလည်း “သားသမီးတိ စားမည့်အစာကို ခွီးတိကို မချပီးအပ်” ဟု ပြန်ပြောတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","မိန်းမကလည်း “မှန်ပါ၏ အသျှင်၊ သို့သော်လည်း ခွီးတိတောင်မှ မိမိသခင်၏စားပွဲက ကျလာသော စားကြွင်းစားကျန်တိကို စားရခွင့်ဟိပါ၏” ဟု လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ထို့နောက် ယေသျှုက “အချင်းမိန်းမ၊ သင်သည် ယုံကြည်ခြင်းကြီးမားသော သူတစ်ယောက် ဖြစ်၏။ သင် လိုသမျှ ပြည့်စုံပါစီ” ဟု မိန့်တော်မူ၏။ ထိုခဏခြင်းတွင် ထိုမိန်းမ၏သမီးသည် ကျန်းမာခြင်းသို့ ပြန်ရောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ယေသျှုသည် ထိုအရပ်မှ ထွက်၍ ဂါလိလဲအိုင်နားတလျှောက် ကြွတော်မူ၏။ ကိုယ်တော်သည် တောင်ကုန်းထက်သို့ တက်၍ ထိုင်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","လူအပေါင်းရို့သည် ခြီမစွမ်းသူ၊ မျက်စိကန်းသူ၊ ကိုယ်အင်္ဂါချို့တဲ့သူ၊ ဆွံ့အသူများနှင့် တခြားရောဂါစွဲသူများကို ခေါ်ဆောင်လာကြပြီးလျှင် ကိုယ်တော်၏ခြီတော်ရင်း၌ ချထားကြ၏။ ကိုယ်တော်ကလည်း ထိုသူအပေါင်းရို့ကို ကျန်းမာစီတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","သူရို့သည် ဆွံ့အ သူများ စကားပြောနိုင်သည်ကိုလည်းကောင်း၊ ကိုယ်အင်္ဂါချို့တဲ့သူများ ပကတိ ကျန်းမာခြင်း ရကြသည်ကိုလည်းကောင်း၊ ခြီမစွမ်းသူများ လမ်းလျှောက်နိုင်ကြသည်ကိုလည်းကောင်း၊ မျက်စိကန်းသူများ ပြန်မြင်နိုင်ကြသည်ကိုလည်းကောင်း တွိ့မြင်ရသောအခါ အံ့ဩကြသည်ဖြစ်၍ ဣသရေလလူမျိုး၏ဘုရားသခင်ကို ချီးမွမ်းကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ယေသျှုသည် တပည့်တော်တိကို မိမိထံပါးသို့ ခေါ်ပြီးလျှင် “ငါသည် ဤလူတိကို သနားမိပါ၏၊ ဇာကြောင့်လဲဆိုကေ ဤသူရို့သည် သုံးရက်ကြာ ငါနှင့် အတူနီထိုင်ကြပြီးပြီဖြစ်၍ ဂုအချိန်၌ သူရို့မှာ စားစရာတစ်ခုလေ့ မဟိကတ်ယာ။ ငါသည် သူရို့ကို တစ်ခုလည်း မကျွေးဘဲ ပြန်မရွှတ်ချင်၊ သူရို့သည် လမ်းခရီး၌ အားပြတ်ကြလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","တပည့်တော်ရို့ကလည်း “ဤကန္တာရတော၌ ဤမျှလောက် များစွာသောလူရို့ကို ကျွေးမွီးခြင်းငှာ လုံလောက်သောအစာကို ဇာနီရာမှာ အကျွန်ရို့ ရှာရပါဖို့လဲ” ဟု လျှောက်တော်မူကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ယေသျှုက “သင်ရို့၌ မုန့် ဇာလောက်ဟိလဲ” ဟု မိန်းတော်မူလျှင်၊ တပည့်တော်ရို့က “မုန့်ခုနစ်လုံးနှင့် ငါးချေ အနည်းငယ် ဟိပါ၏” ဟု လျှောက်ကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","ထိုအခါ ယေသျှုကလည်း လူတိကို မြီကြီးထက်မှာ ထိုင်ကြရန် မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ထို့နောက် ကိုယ်တော်သည် မုန့်ခုနစ်လုံးနှင့် ငါးများကို ယူ၍ ဘုရားသခင်အား ကျေးဇူးတော်ချီးမွမ်းပြီးမှ၊ မုန့်နှင့် ငါးကို ဖဲ့ပြီးလျှင် တပည့်တော်တိအား ပီးလေ၏၊ တပည့်တော်တိကလည်း ထိုမုန့်နှင့် ငါးကို လူတိအား ဝီပီးကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","လူအပေါင်းရို့သည် ဝစွာ စားကြလေ၏။ ပြီးနောက် တပည့်တော်ရို့သည် စားကြွင်းစားကျန်များကို ကောက်သိမ်းကြသောအခါ တောင်းခုနစ်လုံး အပြည့် ရလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","စားသုံးသောသူများတွင် မိန်းမနှင့် သူငယ်တိ မပါဘဲ ယောက်ျားချည်းသက်သက် ၄,၀၀၀ ဟိလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ထိုနောက် ယေသျှုသည် လူတိကို ပြန်ရွှတ်လိုက်ပြီးလျှင် လောင်းထက်သို့ တက်ကာ မာဂဒါလနယ်သို့ ကြွတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ယေသျှုထံပါးသို့ ရောက်လာကြသော ဖာရိယှဲနှင့် ဇဒ္ဒုကဲအချို့သည် ကိုယ်တော့်ကို စုံစမ်းလိုစိတ်ဟိကြ၏။ ထို့ကြောင့် ဘုရားသခင်သည် ကိုယ်တော်ဖက်မှာဟိကြောင်း ထင်ရှားစီခြင်းငှာ နိမိတ်လက္ခဏာ တစ်ခုကို သူရို့အားလားပြရန် တောင်းဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","သို့သော်၊ ယေသျှုက “နီဝင်ချိန်၌ ‘အာကာပြင်သည် အနီရောင်တောက်ပနိန်သောကြောင့် ရာသီဥတု သာယာမည်’ ဟု သင်ရို့သည် ပြောဆိုတတ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","မိုးထစောစော၌ ‘အာကာပြင်သည် နီ၍ မည်းမှောင်နိန်သောကြောင့် မိုးရွာမည်’ ဟု သင်ရို့သည် ပြောဆိုတတ်ကြ၏။ သင်ရို့သည် အာကာပြင်ကို ကြည့်၍ ရာသီဥတုကို ခန့်မှန်းနိုင်သော်လည်း မျက်မှောက်ကာလ၌ ဖြစ်နိန်သော အမှတ်လက္ခဏာများ၏ အဓိပ္ပာယ်ကို မသိနိုင်ကတ်ပါတကား။ ");
INSERT INTO rki_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","အဂုကာလ၌ ဆိုးမိုက်၍ ဖောက်ပြန်နိန်ကြသောသူရို့၊ သင်ရို့သည် ငါ့အား နိမိတ်လက္ခဏာ တစ်ခုကို တောင်းဆိုနိန်ကတ်တေလား။ မဖြစ်နိုင်။ သင်ရို့ကိုပြမည့် နိမိတ်လက္ခဏာသည် ယောန၏နိမိတ်လက္ခဏာမျှသာဖြစ်သည်” ဟု ပြောဆိုပြီး၊ ကိုယ်တော်သည် သူရို့ကို ထားခပြီးလျှင် ထွက်ခွါလားတော်မူလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","တပည့်တော်ရို့သည် အိုင်တစ်ဘက်ကမ်းသို့ ရောက်ကြသောအခါ သူရို့သည် မည်သည့်စားစရာကိုမျှ မယူလာမိခပေ။ ");
INSERT INTO rki_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ယေသျှုက တပည့်တော်ရို့အား “သင်ရို့သည် ဖာရိယှဲနှင့် ဇဒ္ဒုကဲရို့၏ တဆီးကို အထူး သတိထားကြလော့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","တပည့်တော်ရို့ကလည်း “ငါရို့သည် စားစရာတစ်ခုမျှ မယူလာခသောကြောင့် ကိုယ်တော်သည် ဤသို့ ပြောခြင်းဖြစ်သည်” ဟု အချင်းချင်း ပြောဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","ယေသျှုသည် သူရို့ပြောဆိုနိန်ကြသည်ကို သိတော်မူ၏၊ ထို့ကြောင့် ကိုယ်တော်က “သင်ရို့သည် စားစရာမဟိသည်ကို ဇာကြောင့် အချင်းချင်း ပြောဆိုနိန်ကတ်လဲ။ ကောင်းကောင်း ယုံကြည်ခြင်း အားနည်းတက်တေကား။ ");
INSERT INTO rki_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","သင်ရို့သည် ဂုထိတောင် နားမလည်ကတ်သိမ့်လား။ ငါသည် မုန့်ငါးလုံးနှင့် လူ ၅,၀၀၀ ကို ကျွေးမွီးခစွာကို သင်ရို့ သတိမရကတ်ယာလား။ စားကြွင်းစားကျန်ကို သင်ရို့ ဇာနှစ်တောင်း ကောက်သိမ်းရခလဲ။ ");
INSERT INTO rki_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ထို့အပြင် မုန့်ခုနစ်လုံးနှင့် လူ ၄,၀၀၀ ကို ကျွေးခသိမ့်ရေမလား၊ စားကြွင်းစားကျန် ဇာနှစ်တောင်း သင်ရို့ ကောက်သိမ်းရခလဲ။ ");
INSERT INTO rki_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","အစားအစာနှင့် ပတ်သက်၍ သင်ရို့ကို ငါပြောနိန်ခြင်း မဟုတ်သည်ကို ဇာပိုင် နားမလည်ကတ်စွာလဲ။ ဖာရိယှဲနှင့် ဇဒ္ဒုကဲရို့၏ တဆီးကို သင်ရို့ကိုယ်တိုင် သတိထားကြလော့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ထို့နောက် တပည့်တော်ရို့သည် မုန့်၌ ထည့်သောတဆီးကို ယှောင်ကြဉ်ရန် ကိုယ်တော်က သူရို့ကို သတိပီးနိန်ခြင်း မဟုတ်၊ ဖာရိယှဲနှင့် ဇဒ္ဒုကဲရို့၏ သွန်သင်မှုကို ယှောင်ကြဉ်ရန် သတိပီးနိန်ခြင်းဖြစ်ကြောင်းကို နားလည်လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","ယေသျှုသည် ဖိလိပ္ပုကဲသရိမြို့အနီး ကျေးလက်ဒေသသို့ ရောက်သောအခါ “လူတိက လူသားကို ဇာသူလို့ ပြောနိန်ကတ်လဲ” ဟု တပည့်တော်တိအား မိန်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","တပည့်တော်ရို့ကလည်း “တချို့က ဗတ္တိဇံယောဟန်ဖြစ်သည် ဟူ၍လည်းကောင်း၊ တချို့က ဧလိယဖြစ်သည် ဟူ၍လည်းကောင်း၊ တချို့က ပရောဖက်ယေရမိဖြစ်သည် ဟူ၍လည်းကောင်း၊ တချို့က တခြားပရောဖက်တစ်ပါးပါးဖြစ်သည် ဟူ၍လည်းကောင်း ပြောနိန်ကြ၏” ဟု လျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ကိုယ်တော်က “သင်ရို့သည် ငါ့ကို ဇာသူဖြစ်သည် ဟု ပြောကြသနည်း” ဟု တပည့်တော်တိအား မိန်းလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","သျှိမုန်ပေတရုက “ကိုယ်တော်သည် အသက်ရှင်တော်မူသော ဘုရားသခင်၏သားတော် မေသျှိယ ဖြစ်တော်မူ၏” ဟု ပြန်လျှောက်၏။ ");
INSERT INTO rki_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ယေသျှုကလည်း “ယောန၏သား၊ သျှိမုန် သင်သည် မင်္ဂလာဟိ၏။ အကြောင်းမူကား ဤအမှန်တရားသည် လူအားဖြင့် မဟုတ်၊ ကောင်းကင်ဘုံ၌ဟိတော်မူသော ငါ၏အဖသည် သင့်အား တိုက်ရိုက် ဖော်ပြတော်မူခြင်းဖြစ်၏။” ");
INSERT INTO rki_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","ထို့အပြင် ငါဆိုသည်ကား “သင်သည် ပေတရု ဖြစ်၏။ ငါသည် ဤကျောက်ထက်၌ ငါ၏အသင်းတော်ကို တည်ထောင်မည်။ ဤအသင်းတော်သည် မရဏာနိုင်ငံ၏တန်းခါးကို ကျော်လွှားနိုင်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","ငါသည် သင့်အား ကောင်းကင် နိုင်ငံတော်၏ သော့များကို ပီးမည်။ သင်က မြီကြီးထက်၌ တားမြစ်သည့်အရာများကို ကောင်းကင်ဘုံတွင်လည်း တားမြစ်လိမ့်မည်။ သင်က မြီကြီးထက်၌ ခွင့်ပြုသမျှကို ကောင်းကင်ဘုံ၌လည်း ခွင့်ပြုလိမ့်မည်။” ");
INSERT INTO rki_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","ဤသို့ တပည့်တော်တိအား ဆုံးမသွန်သင်ပြီးနောက် ယေသျှုက သူသည် မေသျှိယဖြစ်ကြောင်းကို ဇာသူ့ကိုမျှ မပြောစီခြင်းငှာ တပည့်တော်တိအား မိန့်မှာတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ထိုအချိန်မှစ၍ ယေသျှုက “ငါသည် ယေရုဆလင်ကို လားရမည်။ ဘာသာရေးခေါင်းဆောင်တိ၊ ယဇ်ပုရောဟိတ်တိ၊ ကျမ်းတတ်ဆရာတိ လက်ထဲ၌ ဒုက္ခဝေဒနာကို ပြင်းစွာခံစားရမည်။ အသီသတ်ခြင်းကိုလည်း ခံရလိမ့်မည်။ သို့သော်လည်း ငါသည် သုံးရက်မြောက်သောနိ့၌ သီခြင်းမှ ထမြောက်လာလိမ့်မည်” ဟု တပည့်တော်တိအား ပွင့်လင်းထင်ရှားစွာ မိန့်ကြားတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ပေတရုက ကိုယ်တော့်ကို ဘေးနားသို့ ခေါ်ယူကာ “သခင်ဘုရား၊ ဘုရားသခင်သည် ထိုအမှုကို တားဆီးတော်မူ၏၊ ထိုအမှုသည် ကိုယ်တော်၌ လုံးဝ မဖြစ်စီရ” ဟု တားမြစ်ပြောဆို၏။ ");
INSERT INTO rki_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ယေသျှုကလည်း ပေတရုဘက်သို့ လှည့်ကြည့်ပြီးလျှင် “အချင်းစာတန်၊ ငါ့အနားက ထွက်လားလီ။ သင်သည် ငါ၏လမ်းခရီး၌ အတားအဆီး ဖြစ်၏။ သင်၏အတွေးကား ဘုရားသခင်ထံမှ လာသည် မဟုတ်၊ လူ၏အတွေးသာ ဖြစ်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","ထို့နောက် ယေသျှုသည် တပည့်တော်ရို့အား “ဇာသူမဆို ငါနှင့်အတူ လိုက်ချင်လျှင် မိမိကိုယ်ကို ငြင်းပယ်ရမည်၊ မိမိ၏လက်ဝါးကပ်တိုင်ကို ထမ်း၍ လိုက်ကြရမည်။ ");
INSERT INTO rki_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ဇာသူမဆို မိမိအသက်ကို ကယ်တင်လိုသောသူသည် အသက်ဆုံးယှုံးရလိမ့်မည်။ ဇာသူမဆို ငါ့အတွက်ကြောင့် မိမိအသက်ကို ဆုံးယှုံးခံသောသူသည် အသက်ကိုရ လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","လူသည် လောကတစ်ခုလုံးကို အစိုးရသော်လည်း မိမိအသက်ဆုံးယှုံးလျှင် ဇာမှာ အကျိုး ဟိပါဖို့သိမ့်လဲ။ မိမိအသက်ကို ဇာအရာနှင့် လှဲနိုင်ပါဖို့လဲ။ ");
INSERT INTO rki_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","အကြောင်းမူကား၊ လူသားသည် မိမိအဖ၏ဘုန်းတန်ခိုးတော်ဖြင့် ကောင်းကင်တမန်များနှင့် အတူ ကြွလာလိမ့်မည်၊ ထိုအခါ လူတစ်ယောက်စီတိုင်းအား မိမိရို့ ပြုသည့်အတိုင်း ခံစားစီလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","သင်ရို့ကို ငါ အမှန်ဆိုသည်ကား လူသားသည် သျှင်ဘုရင်အဖြစ်ဖြင့် ကြွလာတော်မူသည်ကို မြင်ကြရသည့်တိုင်အောင် ဤအရပ်၌ ဟိနိန်ကြသော လူတချို့သည် မသီကြရသိမ့်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ခြောက်ရက်ကြာသောအခါ ယေသျှုသည် ပေတရု၊ ယာကုပ်၊ ယာကုပ်ညီ ယောဟန်ရို့ကို မိမိနှင့် အတူ ခေါ်ယူပြီးလျှင် လူသူကင်းမဲ့သော တောင်ကုန်းမြင့်ထက်သို့ ကြွတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ထိုအရပ်၌ တပည့်တော်ရို့ ရှိ့တွင် ယေသျှုသည် အဆင်းသဏ္ဌာန်ပြောင်းလဲလာ၏၊ ကိုယ်တော်၏မျက်နှာတော်သည် နီကဲ့သို့ ထွန်းလင်းနိန်ပြီး၊ ဝတ်ရုံတော်သည် ငွီရောင်ကဲ့သို့ လင်းလက်တောက်ပနိန်၏။ ");
INSERT INTO rki_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ထို့နောက် သူရို့ရှိ့၌ မောသျှေနှင့် ဧလိယသည် ပေါ်လာ၍ ယေသျှုနှင့် စကားပြောနိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ထိုအခါ ပေတရုက “အသျှင်ဘုရား၊ ဤအရပ်သည် အကျွန်ရို့အတွက် နီစရာကောင်းပါ၏။ သို့ဖြစ်၍ ကိုယ်တော်အလိုဟိလျှင် အကျွန်သည် ကိုယ်တော်အတွက် တဲတစ်ဆောင်၊ မောသျှေအတွက် တဲတစ်ဆောင်၊ ဧလိယအတွက် တဲတစ်ဆောင်၊ တဲသုံးဆောင် ဆောက်ပါမည်” ဟု ယေသျှုအား ပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ပေတရု စကားပြောနိန်ချိန်မှာ တလက်လက်တောက်ပနိန်သော မိုးတိမ်တိုက်တစ်ခုသည် သူရို့ထက်၌ ပေါ်လာပြီး “ဤသူသည် ငါ နှစ်သက်မြတ်နိုးသော ငါ၏ချစ်သား ဖြစ်၏၊ သူ၏စကားကို နားထောင်ကြလော့” ဟူသော အသံဖြင့် ထိုမိုးတိမ်မှ မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","တပည့်တော်ရို့သည် ထိုအသံကို ကြားသောအခါ အလွန်ကြောက်ရွံ့တုန်လှုပ်လျက် မိမိရို့၏မျက်နှာကို မြီကြီးပြင်၌ ကပ်ထားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ထိုအခါ ယေသျှုသည် ရောက်လာ၍ သူရို့ကို လက်နှင့် ပုတ်ပြီးလျှင် “ထ၊ ကြောက်မနိန်ကတ်ကေ့” ဟု ပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","တပည့်တော်ရို့က မော့ကြည့် လိုက်သည့်အခါ ယေသျှုမှတပါး တခြားမည်သူမျှ မဟိ။ ");
INSERT INTO rki_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","သူရို့သည် တောင်ထက်မှ ဆင်းလာကြသောအခါ ယေသျှုက “လူသားသည် သီခြင်းမှ ထမြောက်လာသောအချိန်ထိ သင်ရို့ မြင်တွိ့ခသည့်အရာကို ဇာသူ့ကိုလည်း ဖွင့်မပြောကတ်ကေ့ဦး” ဟု တပည့်တော်တိကို မိန့်မှာတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ထိုအခါ တပည့်တော်တိက “ဧလိယအယင်ဆုံး ရောက်လာလိမ့်မည်ဟု ကျမ်းတတ်ဆရာတိက ဇာအကြောင်းကြောင့် ပြောနိန်ကတ်ပါလဲ” ဟု ယေသျှုအား မိန်းလျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ယေသျှုက “ဧလိယ အယင်ရောက်လာမည်မှာ အမှန်ပင်ဖြစ်၏။ သူသည် အရာအားလုံးကို အဆင်သင့်ပျင်ဆင်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","သို့သော်၊ သင်ရို့ကို ငါဆိုသည်ကား ဧလိယ ရောက်လာခပြီးပြီ၊ သို့သော်လည်း လူတိ မသိလိုက်ကြ။ ထို့ကြောင့် သူ့ကို လူတိက စိတ်တိုင်းကျ နှိက်စက်ကြ၏။ ထိုနည်းတူ သူရို့သည် လူသားကို နှိက်စက်ကြလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","ထိုအခါမှ ကိုယ်တော်သည် ဗတ္တိဇံယောဟန်အကြောင်း သူရို့အား ပြောပြနိန်သည်ကို တပည့်တော်တိက နားလည်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ယေသျှုနှင့် တပည့်တော်ရို့သည် လူထုပရိသတ်ပါးသို့ ပြန်ရောက်လာကြသောအခါ လူတစ်ယောက်သည် ကိုယ်တော်ထံပါးသို့ ရောက်လာပြီး ရှိ့မှာ ဒူးထောက်လျက်၊ ");
INSERT INTO rki_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“အသျှင်ဘုရား၊ အကျွန့်သားကို သနားတော်မူပါ။ သူသည် ဝက်ရူးပြန်ရောဂါကို ပြင်းထန်စွာ ခံစားနိန်ရပြီးလျှင် မီးထဲ၌လည်းကောင်း၊ ရီထဲ၌လည်းကောင်း မကြာမကြာ လဲကျတတ်ပါ၏။ ");
INSERT INTO rki_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","အကျွန်သည် ကိုယ်တော်၏တပည့်တိပါးသို့ သူ့ကို ပို့ဆောင်ပြီးပါပြီ။ သို့သော် သူရို့သည် သူ့ကို ကျန်းမာစီခြင်းငှာ မတတ်နိုင်ကတ်ပါ” ဟု လျှောက်၏။ ");
INSERT INTO rki_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ထိုအခါ ယေသျှုက “သင်ရို့သည် ယုံကြည် ခြင်းမဟိ၊ ဖောက်ပြန်တတ်သောအမျိုးပါကား၊ ငါသည် သင်ရို့နှင့်အတူ ဇာလောက်ကြာကြာ နီရပါဖို့လဲ။ ငါသည် သင်ရို့ကို ဇာလောက်ကြာကြာ သည်းခံနိန်ရပါဖို့လဲ။ သူငယ်ကို ငါ့ပါးသို့ ယူလာခ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ယေသျှုက နတ်ဆိုးကို အမိန့်တစ်ချက် ပီးလိုက်သည်နှင့် ထိုနတ်ဆိုးသည် သူငယ်ပါးမှ ထွက်လားသဖြင့်၊ သူငယ်သည် ချက်ချင်း ကျန်းမာလား၏။ ");
INSERT INTO rki_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ထို့နောက် တပည့်တော်ရို့သည် ယေသျှုပါးသို့ သီးသန့် လာတွိ့ကြပြီးလျှင် “အကျွန်ရို့သည် နတ်ဆိုးကို ဇာဖြစ်လို့ မမောင်းထုတ်နိုင်ကတ်ပါလဲ” ဟု မိန်းလျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ကိုယ်တော်က “သင်ရို့၌ ယုံကြည်ခြင်း အလွန် အားနည်းသောကြောင့်ဖြစ်၏။ ငါ အမှန်ဆိုသည်ကား သင်ရို့သည် မုန်ညှင်းစိလောက်မျှ ယုံကြည်ခြင်းဟိမည်ဆိုလျှင် ဤတောင်ကို ‘ဤနီရာက ထိုနီရာသို့ ရွှိ့လော့’ ဟု ဆိုလျှင် တောင်သည် ရွှိ့လားမည်ဖြစ်၏။ သင်ရို့မလုပ်နိုင်သောအရာသည်မဟိ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","ဂါလိလဲဒေသ၌ အားလုံးသော တပည့်တော်တိနှင့် အတူကြွတော်မူစဉ်၊ ယေသျှုက “လူသားကို လူရို့လက်သို့ အပ်နှံကြလိမ့်မည်၊ ");
INSERT INTO rki_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ထိုသူရို့က သူ့ကို သီယောင် သတ်ကတ်လိမ့်မည်။ သို့သော်လည်း သုံးရက်မြောက်သောနိ့မှာ သူသည် သီခြင်းက ထမြောက်လာလိမ့်မည်” ဟု သူရို့အား မိန့်မှာတော်မူ၏။ ထိုအခါ တပည့်တော်ရို့သည် အလွန်ဝမ်းနည်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","ယေသျှုနှင့် သူ၏တပည့်တော်ရို့သည် ကပေရနောင်မြို့သို့ ရောက်လာကြသောအခါ ဗိမာန်တော် အခွန်ကောက်သူများသည် ပေတရုပါးသို့ ရောက်လာကြပြီးလျှင် “သင်ရို့ဆရာသည် ဗိမာန်တော်အခွန်ကို ပီးပါလား” ဟု မိန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“ပီးပါရေ” ဟု ပေတရုက ပြန်ပြော၏။ ပေတရုသည် အိမ်ထဲသို့ ဝင်လာသောအခါ ယေသျှုက “သျှိမုန်၊ သင်၏ထင်မြင်ယူဆချက်က ဇာပိုင်လဲ။ လောကီ သျှင်ဘုရင်တိကို ဇာသူတိက အခွန်ပီးကတ်ရလဲ။ တပါးအမျိုးသားတိက ပီးကတ်ရလား၊ မိမိနိုင်ငံသားတိက ပီးကတ်ရလား” ဟု ဦးစွာ မိန်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","“တပါးအမျိုးသားတိကသာ အခွန် ပီးကတ်ရပါရေ” ဟု ပေတရုက ဖြေ၏။ ထိုအခါ ယေသျှုက “ကောင်းပြီ၊ ဆိုလိုသည်မှာ မိမိနိုင်ငံသားတိက ပီးစရာမလို။ ");
INSERT INTO rki_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","သို့သော်လည်း ငါရို့သည် အခွန်ကောက်သောသူရို့ကို စော်ကားပြစ်မှားခြင်းငှာ အလိုမဟိ။ ထို့ကြောင့် အိုင်သို့ လား၍ ငါးမျှားခီ။ သင်သည် ပထမဆုံး မျှားလို့ရသည့်ငါးကို ဆွဲတင်၍ ထိုငါး၏ ပါးစပ်ကို ဖွင့်လိုက်လျှင် ငါနှင့် သင်ရို့၏ ဗိမာန်တော်အခွန်အတွက် လုံလောက်သော ဒင်္ဂါးတစ်ပြားကို တွိ့လိမ့်မည်။ ထိုဒင်္ဂါးကို ယူ၍ ငါ့ရို့အတွက် အခွန်ကို သူရို့အား ပီးလိုက်ကြ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","ထိုအချိန်၌ တပည့်တော်ရို့သည် ယေသျှုထံပါးသို့ ရောက်လာကြပြီးလျှင် “ကောင်းကင်နိုင်ငံတော်မှာ ဇာသူသည် အကြီးဆုံးဖြစ်ပါလဲ” ဟု မိန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ယေသျှုက သူငယ်တစ်ယောက်ကို ခေါ်၍ တပည့်တော်တိရှိ့မှာ ရပ်ခိုင်းထားပြီးလျှင် ");
INSERT INTO rki_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“သင်ရို့ကို ငါ အမှန်ဆိုသည်ကား သင်ရို့သည် သူငယ်တိကဲ့သို့ မပြောင်းလဲလျှင် ကောင်းကင်နိုင်ငံသို့ လုံးဝ ဝင်ရကြလိမ့်မည် မဟုတ်။ ");
INSERT INTO rki_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ဤသူငယ်ကဲ့သို့ မိမိကိုယ်ကို နှိမ့်ချသောသူသည် ကောင်းကင်နိုင်ငံတော်၌ အကြီးဆုံးသောသူ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ပြီးနောက် ဇာသူမဆို ငါ၏ နာမည်ကို ထောက်၍ ဤကဲ့သို့သော သူငယ်တစ်ယောက်ကို လက်ခံသောသူသည် ငါ့ကို လက်ခံသောသူ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“သို့ရာတွင် မည်သူမဆို ငါ့ကို ယုံကြည်သော ဤသူငယ်များထဲက တစ်ဦးတစ်ယောက်ကို ပြစ်မှားစီသောသူဖြစ်လျှင် ထိုသူသည် ကြိတ်ဆုံကျောက်တုံးကြီးကို မိမိလိုင်ပင်းမှာ ချိုင်ဆွဲကာ ပင်လယ်နက်ထဲမှာ နှစ်မြုပ်ခြင်းကို ခံရသည်က သာ၍ ကောင်း၏။ ");
INSERT INTO rki_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","လူတိကို ပြစ်မှားစီတတ်သော အရာများသည် ဤလောက၌ ဟိနိန်ကြသောကြောင့် ဤလောကသည် အမင်္ဂလာဟိ၏။ ဤသို့သော အရာများသည် ဟိနိန်ကြရမည်။ သို့သော်လည်း ထိုသို့ ပြစ်မှားစီသောသူသည် အမင်္ဂလာဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“သင်၏လက် သို့မဟုတ် သင်၏ခြီက သင့်ကို ပြစ်မှားစီလျှင် ၎င်းကို ဖြတ်၍ ဝေးပစ်လိုက်။ ခြီစုံ၊ လက်စုံနှင့် ငရဲမီးထဲကို ပစ်ချခံရသည်ထက် ခြီ၊ လက် မပါဘဲ အသက်ရှင်ရခြင်းသည် သာ၍ ကောင်း၏။ ");
INSERT INTO rki_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","သင်၏ မျက်စိက သင့်ကို ပြစ်မှားစီလျှင် ၎င်းကို ထုတ်၍ ဝေးပစ်လိုက်။ မျက်စိအစုံနှင့် ငရဲမီးထဲသို့ ပစ်ချ ခံရသည်ထက် မျက်စိတစ်ဘက်နှင့် အသက်ရှင်ရခြင်းသည် သာ၍ ကောင်း၏။ ");
INSERT INTO rki_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“သင်ရို့သည် ဤသူငယ်များထဲက ဇာသူတစ်ဦး တစ်ယောက်ကိုမျှ မထီမဲ့မြင် မပြုစီခြင်းငှာ သတိထားကတ်ပါ။ သင်ရို့ကို ငါဆိုသည်ကား သူရို့၏ ကောင်းကင်တမန်များသည် ကောင်းကင်ဘုံ၌ ငါ့အဖ၏ရှိ့မှာ အမြဲတမ်း ခစားနိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“သင်ရို့ ဇာပိုင် စဉ်းစားကတ်ဖို့လဲ၊ လူတစ်ယောက်၌ သိုးအကောင် ၁၀၀ ဟိ၏၊ ထိုအထဲက တစ်ကောင် ပျောက်လားသော်၊ ထိုသူသည် သိုး ၉၉ ကောင်ကို စားကျက်ကောင်းသည့် တောင်ကုန်းထက်မှာ ထားခပြီးလျှင် ပျောက်သည့်သိုးတစ်ကောင်ကို လား၍ ရှာလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","သင်ရို့ကို ငါ ဆိုသည်ကား၊ ထိုသူသည် သူ၌ဟိသော သိုး ၉၉ ကောင်ကို မြင်၍ ဝမ်းမြောက်သည်ထက် ပျောက်လားသည့် သိုးတစ်ကောင်ကို ပြန်တွိ့သောအခါ သာ၍ ဝမ်းမြောက်၏၊ ");
INSERT INTO rki_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","ထိုနည်းတူစွာ ကောင်းကင်ဘုံ၌ ဟိတော်မူသော သင်ရို့၏အဖသည် ဤသူငယ်များထဲက ဇာသူတစ်ဦး တစ်ယောက်ကိုမျှ ဆုံးယှုံးရန် အလိုမဟိပေ။ ");
INSERT INTO rki_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“သင်၏ညီအစ်ကို တစ်ယောက်သည် သင့်ကို ပြစ်မှား မိလျှင် သူ့ပါးသို့ လား၍ သူ၏အမှားကို သူ့အား ဖော်ပြပါ။ သို့ရာတွင် ထိုအမှုကို နှစ်ယောက်တည်း တိတ်ဆိတ်စွာ ဆောင်ရွက်ပါ။ သူသည် သင့်စကားကို နားထောင်လျှင် သင်သည် သင့်ညီအစ်ကိုအား ပြန်ရယာ။ ");
INSERT INTO rki_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","သို့သော် သူက သင့်စကားကို နားမထောင်လျှင် သင်နှင့်အတူ လူတစ်ယောက် နှစ်ယောက်ကို ခေါ်၍ သူ့အား ပြောပြလော့။ အကြောင်းမူကား ကျမ်းစာလာသည့်အတိုင်း သင်၏စွပ်စွဲချက်များကို နှစ်ဦး သို့မဟုတ် နှစ်ဦးထက်ပိုသော သက်သီတိဖြင့် အတည်ပြုရန် ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","သူသည် ထိုသူရို့၏စကားကိုလည်း နားမထောင်လျှင် ဖြစ်သမျှအားလုံးကို အသင်းတော်အား တိုင်ကြားလော့။ နောက်ဆုံးအနေဖြင့် သူသည် အသင်းတော်၏စကားကိုလည်း နားမထောင်လျှင် ထိုသူကို ဘုရားတရားမဲ့ သာသနာပလူ သို့မဟုတ် အခွန်ခံကဲ့သို့ ပြုကြလော့။ ");
INSERT INTO rki_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“တဖန် သင်ရို့အားလုံးကို ငါ ဆိုသည်ကား၊ သင်ရို့သည် မြီကြီးထက်မှာ တားဆီးပိတ်ပင်သမျှတိကို ကောင်းကင်ဘုံမှာ တားဆီးပိတ်ပင်လိမ့်မည်။ သင်ရို့သည် မြီကြီးထက်မှာ ခွင့်ပြုသမျှကို ကောင်းကင်ဘုံမှာလည်း ခွင့်ပြုလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“တဖန်၊ သင်ရို့ကို ငါ ဆိုသည်ကား၊ သင်ရို့သည် မြီကြီးထက်မှာ စိတ်သဘော တစ်ညီတစ်ညွတ်တည်း နှစ်ယောက်အတူ ဆုတောင်းလျှင် ကောင်းကင်ဘုံ၌ ဟိတော်မူသော ငါ၏အဖက သင်ရို့ တောင်းသည့်အရာကို ပီးလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","အကြောင်းမူကား လူနှစ်ယောက် သို့မဟုတ် သုံးယောက်သည် ငါ၏နာမ၌ အတူစုရုံးကြလျှင် ငါသည်လည်း ထိုနီရာ၌ သူရို့နှင့် အတူဟိ၏။” ");
INSERT INTO rki_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ထိုအခါ ပေတရုသည် ယေသျှုပါးသို့ လာပြီးလျှင် “အသျှင်ဘုရား၊ အကျွန့်ကို အပြစ်လုပ်နိန်သော အကျွန်၏ညီအစ်ကို တစ်ယောက်ကို ဇာနှစ်ကြိမ်၊ ဇာနှစ်ခါ ခွင့်ရွှတ်ရပါဖို့လဲ၊ ခုနစ်ကြိမ်လား” ဟု မိန်း၏။ ");
INSERT INTO rki_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","“ခုနစ်ကြိမ်မက ခုနစ်ဆယ့်ခုနစ်ကြိမ် ခွင့်ရွှတ်ရမည်” ဟု ယေသျှုက မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","အကြောင်းမှာ၊ ကောင်းကင်နိုင်ငံတော်သည်ကား ဤဥပမာနှင့် တူ၏။ တစ်ခါက မိမိ၏အခိုင်းအစီများနှင့် အကြွီးစာရင်းကို ယှင်းလိုသော သျှင်ဘုရင်တစ်ပါး ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ထိုသျှင်ဘုရင်သည် အမှုထမ်းအားလုံးထဲက ဖဲသာအများကြီး အကြွီးတင်နိန်သော သူတစ်ယောက်ကို ခေါ်၍ အကြွီးစာရင်းယှင်းသည့်အခါ ");
INSERT INTO rki_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ထိုသူ၌ အကြွီးဆပ်ရန် ဖဲသာမဟိသောကြောင့် ဘုရင်ကြီးက သူနှင့်တကွ သူ၏မယား၊ သားသမီးမှစ၍ ဟိသမျှအားလုံးကို ရောင်းချပြီးလျှင် ထိုအကြွီးအာလုံးကို ပြန်ပီးရန် အမိန့်ထုတ်လိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","ထိုအခါ ထိုအမှုထမ်းသည် မင်းကြီးရှိ့မှာ ပျပ်ဝပ်လျက် “အကျွန့်ကို သည်းခံတော်မူပါ၊ အကြွီးအားလုံးကို အသျှင်အား အကျွန် ပြန်ဆပ်ပါမည်” ဟု တောင်းပန်သောအခါ ");
INSERT INTO rki_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","မင်းကြီးက သူ့အား အလွန် သနားတော်မူသည်ဖြစ်၍ ထိုအခိုင်းအစီ၏ အကြွီးအားလုံးကို ရွှတ်ပီးလိုက်ကာ သူ့ကို ပြန်ခွင့်ပြုလိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","ထိုသူသည် မင်းကြီးထံပါးမှ ထွက်လာ၍ သူ့ပါးမှာ ဖဲသာ စိတ်ကေချေ အကြွီးတင်နိန်သော သူ၏အမှုထမ်းတစ်ယောက်ကို တွိ့၏။ သူက ထိုသူအား လှမ်းဆွဲကာ လိုင်စိ့ကို ဖျစ်လျက် “မင်း ငါ့ကို ပီးစရာဟိရေ အကြွီးကို ပြန်ပီး” ဟု တောင်းလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","သူ၏အမှုထမ်းက “အကျွန်ကို သည်းခံပီးပါ။ အကျွန်ပီးစရာဟိသော အကြွီးကို ပြန်ပီးပါ့မယ်” ဟု ပျပ်ဝပ်လျက် တောင်းပန်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","သို့သော်လည်း သူသည် လက်မခံဘဲ၊ ထိုသူအား အကြွီးတိကို မပီးမချင်း ထောင်ထဲမှာ ချထားလိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ထိုအဖြစ်အပျက်ကို အခြားအမှုထမ်းတိ မြင်ကြသောအခါ သူရို့သည် အကြီးအကျယ် ဒေါသဖြစ်လျက် အကြောင်းစုံကို အသျှင်မင်းကြီးအား လျှောက်တိုင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","ထိုအခါ အသျှင်မင်းကြီးသည် ထိုအမှုထမ်းကို ခေါ်ပြီးလျှင် “အသုံးမကျသည့် ကျွန်စုတ် သင်တောင်းပန်သည့်အတိုင်း ငါ့အား ပီးစရာဟိသော အကြွီးအားလုံးကို ငါသည် ခွင့်ရွှတ်ထားခ၏။ ");
INSERT INTO rki_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ငါသည် သင့်ကို သနားကြင်နာသကဲ့သို့ သင်သည်လည်း သင်၏အခိုင်းအစီတိကို သနားကရုဏာ ထားသင့်ပေ၏” ");
INSERT INTO rki_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ဟူ၍ အသျှင်မင်းကြီးက အလွန်စိတ်ဆိုးဒေါသထွက်ကာ သူ၏အကြွီးအားလုံးကို မကျီမချင်း ထိုအမှုထမ်းကို အပြစ်ပီးရန် အကျဉ်းထောင်ထဲသို့ ပို့လိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","ဤပုံပြင်ကို အဆုံးသတ်ပြီးလျှင် ယေသျှုက “သင်သည် သင့်နှလုံးသားထဲ၌ သင်၏ညီအစ်ကိုအား ခွင့်မရွှတ်လျှင် ကောင်းကင်ဘုံ၌ ဟိတော်မူသော ငါ၏အဖသည် သင့်ကို ခွင့်ရွှတ်လိမ့်မည် မဟုတ်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","ယေသျှုသည် ဤတရားတော်များကို ဟောပြောပြီးသောအခါ ဂါလိလဲပြည်မှ ထွက်ခွါပြီး ယော်ဒန်မြစ် တစ်ဖက်ကမ်း ယုဒနယ်သို့ ကြွတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","လူစုလူဝေးကြီးသည်လည်း ကိုယ်တော်နောက်သို့ လိုက်ပါလာကြ၏။ ကိုယ်တော်သည် ထိုနီရာ၌ သူရို့ကို ကျန်းမာစီတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ဖာရိယှဲတချို့သည် ကိုယ်တော်ထံပါးသို့ ရောက်လာကြပြီးလျှင် “မိမိ၏ ဆန္ဒသဘောဖြင့် ဇာအကြောင်းပြချက်နှင့်မဆို မိမိမယားနှင့် ကွာချင်သောသူကို ပညတ်တရားက ကွာခွင့်ပြုပါလား” ဟု ကိုယ်တော့်ကို ပရိယာယ်ဆင်၍ မိန်းမြန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ယေသျှုက “ဖန်ဆင်းသျှင်သည် အစကတည်းက ယောက်ျားနှင့် မိန်းမကို ဖန်ဆင်းတော်မူခသည်ဟူသော ကျမ်းစာကို သင်ရို့ မဖတ်ဖူးကတ်လားဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","‘ဤအကြောင်းကြောင့် ယောက်ျားသည် သူ၏အမိ အဖကို စွန့်၍ သူ၏မယားနှင့် တစ်လုံးတစ်ဝတည်း ပေါင်းသင်း နီထိုင်လိမ့်မည်၊ သို့ဖြစ်၍ သူရို့နှစ်ယောက်သည် ခန္ဓာကိုယ်တစ်ခုတည်း ဖြစ်လာလိမ့်မည်’ ဟု ဘုရားသခင် မိန့်တော်မူခ၏။ ");
INSERT INTO rki_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","ထို့ကြောင့် သူရို့သည် ခန္ဓာနှစ်ခု မဟုတ်၊ တစ်ခန္ဓာတည်း ဖြစ်၏။ သို့ဖြစ်၍ ဘုရားသခင် အတူတကွ ပေါင်းဖက်ထားသည်ကို လူသည် ခွဲခွါခွင့်မဟိ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","“ဤသို့ဆိုလျှင် လူတစ်ယောက်သည် သူ၏မယားကို ကွာယှင်းစာပီး၍ ကွာလို့ ရသည်ဟု မောသျှေက ပညတ်ထားခသည်မှာ ဇာကြောင့်ပါလဲ” ဟု ဖာရိယှဲတိက ကိုယ်တော့်ကို မိန်းကြပြန်၏။ ");
INSERT INTO rki_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ယေသျှုက “သင်ရို့သည် စိတ်နှလုံးခက်ထန်မာကျောသူများ ဖြစ်သောကြောင့် မောသျှေက သင်ရို့ကို သင်ရို့မယားနှင့် ကွာခွင့် ပီးထားခ၏။ အစဦးက ထိုသို့ မဟုတ်။ ");
INSERT INTO rki_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","သင်ရို့ကို ငါ ဆိုသည်ကား၊ မည်သူမဆို ကာမဖောက်ပြန်ခြင်းကလွဲ၍ မိမိမယားကို ကွာပြီး တခြားမိန်းမနှင့် ပေါင်းသင်းသောသူသည် သူတစ်ပါးမယားကို ပြစ်မှားခြင်းဖြစ်၏။” ");
INSERT INTO rki_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","“လင်နှင့်မယားကိစ္စသည် ဤသို့ ဖြစ်နိန်လျှင် လက်မထပ်ပါက သာ၍ ကောင်းပါဖို့သိမ့်” ဟု တပည့်တော်တိက ကိုယ်တော့်ကို လျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ထိုအခါ ယေသျှုက “ဤစကားကို လူတိုင်းလက်မခံနိုင်၊ အခွင့်ပီးထားသောသူရို့သာလျှင် လက်ခံနိုင်၏။ ");
INSERT INTO rki_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","အကြောင်းမူကား တချို့မှာ မွီးကတည်းက မယူမများ ဖြစ်ကြ၏၊ တချို့မှာ မယူမဖြစ်ယောင် ပြုလုပ်ခြင်းခံကြရ၏။ တချို့မှာ ကောင်းကင်နိုင်ငံတော်အကျိုးကို ထောက်၍ အိမ်ထောင်မပြုကြ။ ဤစကားကို လက်ခံနိုင်သောသူသာလျှင် လက်ခံကြပါ” ဟူ၍ ဖြေကြားတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","လူအချို့သည် လက်တင်၍ ဆုတောင်းပီးခြင်းငှာ သငယ်တိကို ယေသျှုပါးသို့ ခေါ်လာကြ၏။ တပည့်တော်တိက ထိုသူရို့ကို အပြစ်တင်၍ တားမြစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ယေသျှုက “သငယ်တိကို ငါ့ပါးသို့ လာခွင့်ပြုလိုက်ပါ၊ သူရို့ကို မတားဆီးကတ်ကေ့။ ဇာကြောင့်လဲဆိုကေ၊ ကောင်းကင်နိုင်ငံတော်သည် သူရို့အတွက် ဖြစ်တေ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ထို့နောက် ကိုယ်တော်သည် သူငယ်တိဂေါင်းထက်၌ မိမိ၏လက်ကို တင်တော်မူပြီးလျှင် ထိုအရပ်မှ ထွက်ခွာလားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","တစ်နိ့တွင် လူတစ်ယောက်သည် ယေသျှုပါးသို့ လာ၍ “ဆရာ၊ ထာဝရအသက်ကို ရခြင်းငှာ ဇာကုသိုလ်ကောင်းမှုကို အကျွန် လုပ်ရပါဖို့လဲ” ဟု မိန်းလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ယေသျှုက “ဇာအရာသည် ကောင်းမြတ်ပါလဲလို့ ငါ့ကို ဇာကြောင့် လာမိန်းနိန်လဲ။ ကောင်းမြတ်သောအသျှင် တစ်ပါးတည်းသာ ဟိ၏။ သင်သည် အသက်ရှင်ခြင်းသို့ ဝင်ရောက်လိုလျှင် ပညတ်တရားတိကို စောင့်ထိန်းလော့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","“ဇာပညတ်တိကို စောင့်ထိန်းရပါဖို့လဲ” ဟု သူက လျှောက်ပြန်၏။ ယေသျှုက “လူ့အသက်ကို မသတ်ကေ့။ မတရားသောမေထုန်ကို မပြုကေ့။ သူ့ဥစ္စာကို မခိုးကေ့။ ဇာသူ့ကိုမဆို မမှန်သော သက်သီကို မခံကေ့။ ");
INSERT INTO rki_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","သင်၏အမိနှင့် အဖကို ရိုသီစွာပြုလော့။ ပြီးနောက် မိမိနှင့် အတူ နီထိုင်ကြသောသူရို့ကို မိမိကဲ့သို့ ချစ်ပါ” ဟုမိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ထိုလူငယ်က “အကျွန်သည် ဤပညတ်အားလုံးကို စောင့်ထိန်းပါ၏။ တခြား ဇာတိကို အကျွန် လုပ်ရပါဖို့သိမ့်လဲ” ဟု မိန်းလျှောက်ပြန်၏။ ");
INSERT INTO rki_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ထိုအခါ ယေသျှုက “သင်သည် ပြည့်စုံသောသူတစ်ယောက်ဖြစ်ချင်လျှင် သခင်၏ဥစ္စာဟိသမျှကို ရောင်းချပြီး၊ ဆင်းရဲသားတိကို ပီးလိုက်ပါ။ ထိုသို့ပြုလျှင် သင်သည် ကောင်းကင်ဘုံ၌ ဘဏ္ဍာကို ရလိမ့်မည်။ ပြီးမှ ပြန်လာ၍ ငါ့နောက်သို့ လိုက်လော့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ထိုလူငယ်သည် ဤစကားကို ကြားသောအခါ ဝမ်းနည်းစွာဖြင့် ထွက်လား၏။ အကြောင်းမှာ သူသည် များစွာသောစည်းစိမ်ဥစ္စာတိကို ပိုင်ဆိုင်ထားသောကြောင့် ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ထို့နောက် ယေသျှုသည် တပည့်တော်တိကို မိန့်မှာတော်မူသည်မှာ၊ “သင်ရို့ကို ငါ အမှန်ဆိုသည်ကား စည်းစိမ်ဥစ္စာ ကြွယ်ဝသောသူတိသည် ကောင်းကင်နိုင်ငံတော်သို့ ဝင်ရောက်ရန် လွန်စွာ ခဲယင်း၏။ ");
INSERT INTO rki_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","တဖန်ငါဆိုသည်ကား စိည်းစိမ်ဥစ္စာ ကြွယ်ဝချမ်းသာသူများသည် ကောင်းကင်နိုင်ငံတော်သို့ ဝင်ရောက်ရန်အလို့ငှာ ကုလားအုတ်တစ်ကောင်ကို အပ်နဖားပေါက်ထဲသို့ မောင်းသွင်းရသည်ထက် သာ၍ ခက်ပေ၏။” ");
INSERT INTO rki_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","တပည့်တော်ရို့သည် ဤစကားကို ကြားသောခါ လွန်စွာ အံ့အားသင့်ကြလေ၏။ “ဤသို့ဆိုလျှင် ကယ်တင်ခြင်းကို ဇာသူ ရနိုင်ပါဖို့လဲ” ဟု သူရို့က မိန်းလျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ယေသျှုက သူရို့ကို စိုက်ကြည့်ပြီးလျှင် “ကယ်တင်ခြင်းရရန် လူ့အနေဖြင့် မတတ်နိုင်သော်လည်း ဘုရားသခင်သည် အရာအားလုံးကို တတ်နိုင်တော်မူ၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ထိုအခါ ပေတရုက “အကျွန်ရို့သည် ဟိသမျှကို စွန့်၍ အသျှင်ဘုရားနောက်ကို လိုက်လာကြပါ၏။ အကျွန်ရို့မှာ ဇာအကျိုး ဟိပါဖို့လဲ” ဟု ကိုယ်တော့်ကို လျှောက်၏။ ");
INSERT INTO rki_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ယေသျှုက “ခပ်သိမ်းသောအရာများသည် အသစ်ဖြစ်လာသောကာလ၌ လူသားသည် မိမိ၏ ဘုန်းတန်ခိုးပလ္လင်တော်ထက်၌ စိုးစံတော်မူသောအခါ ငါ၏ တပည့်တိဖြစ်ကြသော သင်ရို့သည် ဣသရေလလူမျိုး တစ်ဆယ့်နှစ်မျိုးကို တရားစီရင်လျက် ပလ္လင်တစ်ဆယ့်နှစ်လုံးထက်၌ ထိုင်ကတ်ရလိမ့်မည်ဟု သင်ရို့ကို ငါ အမှန်ပြောလိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ငါ၏အကျိုးကို ထောက်ရှု၍ မိမိရို့၏အိမ်၊ ညီအစ်ကိုမောင်နှမ၊ အမိအဖ၊ သားသမီး၊ လယ်ယာကိုင်းကျွန်း တစ်ခုခုကို စွန့်ထားခသောသူသည် ထိုထက်မက အဆတစ်ရာများပြားစွာ ခံစားရလိမ့်မည်၊ ထိုမျှမက ထာဝရအသက်ကို အမွီခံရလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","သို့သော် အဂုတွင် ရှိ့ဆုံးက ရောက်သောသူတိသည် နောက်ဆုံး၌ ဟိကြလိမ့်မည်။ နောက်ဆုံး ရောက်လာသော သူရို့သည် ရှိ့ဆုံး၌ ဟိကြလိမ့်မည်” ဟု ယေသျှုက တပည့်တော်တိကို မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“ကောင်းကင်နိုင်ငံတော်သည် ဤဥပမာ နှင့်တူ၏။ တစ်ခါက လူတစ်ယောက်သည် မိမိ၏စပျစ်ဥယျာဉ်၌ အလုပ်လုပ်ရန် လူတချို့ကို ငှားဖို့ မိုးထစောစော ထွက်လာ၏။ ");
INSERT INTO rki_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","တစ်ရက်လျှင် လုပ်ခ ငွီဒင်္ဂါး တစ်ပြားစီဖြင့် သဘောတူကြပြီးလျှင် အလုပ်သမားများကို ဥယျာဉ်ထဲသို့ ရွှတ်လိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","သူသည် ကိုးနာရီလောက်တွင် ဈီးသို့ တဖန် လားသည့်အခါ အလုပ်လက်မဲ့ ရပ်နိန်ကြသည့်လူတချို့ကို တွိ့၏။ ");
INSERT INTO rki_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ထိုအခါ သူက ‘သင်ရို့သည်လည်း ငါ၏စပျစ်ဥယျာဉ်သို့ လား၍ အလုပ်လုပ်ကြ၊ ငါသည် သင်ရို့အား သင့်တော်သောလုပ်ခကို ပီးမည်’ ဟု သူရို့ကို ပြော၏။ ");
INSERT INTO rki_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ထို့ကြောင့် သူရို့သည်လည်း ထိုဥယျာဉ်သို့ လား၍ အလုပ်လုပ်ကြ၏။ သူသည် ထိုနည်းတူ နောက်ထပ် ဆယ့်နှစ်နာရီမှာ တစ်သုတ်၊ သုံးနာရီမှာ တစ်သုတ်၊ အလုပ်လုပ်ရန် ဥယျာဉ်ထဲသို့ စီရွှတ်လိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","သူသည် ငါးနာရီလောက်တွင် ဈီးသို့ တဖန်လားသောအခါ အလုပ်လက်မဲ့ရပ်နိန်ကြသည့်လူတိကို တဖန်တွိ့ပြန်သဖြင့် ‘သင်ရို့သည် ဇာဖြစ်လို့ တစ်ရက်လုံး အလုပ်လက်မဲ့ အချိန်ဖြုန်းနိန်ကတ်လဲ’ ဟု သူရို့ကို မိန်း၏။ ");
INSERT INTO rki_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","‘အကျွန်ရို့ကို ငှားမည့်သူ မဟိလို့ပါ’ ဟု သူရို့က ပြောကြသောအခါ ဥယျာဉ်သျှင်က ‘ကောင်းပြီ ဤသို့ဆိုလျှင် သင်ရို့သည်လည်း ငါ၏ဥယျာဉ်သို့ လား၍ အလုပ်လုပ်ကတ်ပါ’ ဟု သူရို့ကို ပြော၏။ ");
INSERT INTO rki_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“ညစာဘက်ချိန်ရောက်သောအခါ ပိုင်သျှင်က ‘နောက်ဆုံးငှားလာသော အလုပ်သမားမှစ၍ ပထမဆုံးငှားသည့် အလုပ်သမားများထိ၊ အလုပ်သမားအားလုံးကို လုပ်ခပီးဖို့ ခေါ်လိုက်’ ဟု သူ၏အလုပ်ကြပ်ကို ပြော၏။ ");
INSERT INTO rki_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“ငါးနာရီမှစ၍ အလုပ်လုပ်ကြသော အလုပ်သမားများကို ငွီဒင်္ဂါးတစ်ပြားစီ ပီး၏။ ");
INSERT INTO rki_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ပထမငှားခသော အလုပ်သမားတိက သူရို့ကို ငွီဒင်္ဂါး ပို၍ ပီးလိမ့်မည် ဟု စိတ်အထင်ဖြင့် လာကြ၏၊ သို့ရာတွင် သူရို့ကိုလည်း ငွီဒင်္ဂါး တစ်ပြားစီသာ ပီးလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ထို့ကြောင့် သူရို့သည် ထိုငွီကို ရသောအခါ အလုပ်သျှင်ကို မကြေနပ်ကြောင်း ပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘နောက်ဆုံး ငှားလာသောသူရို့သည် တစ်နာရီမျှသာ အလုပ်လုပ်ကြ၏၊ အကျွန်ရို့မှာ နီပူထဲ၌ တစ်ရက်လုံး လုပ်ကြရ၏၊ သို့သော်လည်း သင်သည် ငါရို့ကို ပီးသလောက် သူရို့ကို ပီးပါရေကား’ ဟု သူရို့က ပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“ထိုအခါ ဥယျာဉ်ပိုင်သျှင်က ‘အဆွီ၊ ငါ့စကားကို နားထောင်၊ သင့်ကို ငါ မဟုတ်မမှန် လုပ်သည် မဟုတ်။ သင်သည် တစ်ရက်လုပ်ခ ငွီဒင်္ဂါးတစ်ပြားနှင့် အလုပ်လုပ်ဖို့ သဘောတူခသည် မဟုတ်လား။ ");
INSERT INTO rki_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","နောက်ဆုံး အငှားသားကိုလည်း သင့်ကို ပီးသည့်နည်းတူ ငါပီးလို၏၊ သို့ဖြစ်၍ သင်သည် မိမိလုပ်ခကို ယူပြီးလျှင် အဂုပင် အိမ်သို့ ပြန်လော့၊ ");
INSERT INTO rki_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ငါ့ငွီကို ငါ့ဆန္ဒအတိုင်း လုပ်ရသော အခွင့်မဟိပါလား၊ သို့မဟုတ် ငါ သဘောကောင်းသည်ကို သင်ရို့သည် မနာလိုဖြစ်သလော’ ” ဟု သူရို့ထဲက တစ်ယောက်ကို ပြော၏။ ");
INSERT INTO rki_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ယေသျှုက “သို့ဖြစ်၍ နောက်ကျသောသူများသည် အဦးဆုံး ဖြစ်ကြလိမ့်မည်။ အဦးကျသောသူများသည် နောက်ဆုံး ဖြစ်ကြလိမ့်မည်” ဟု နောက်ဆုံးမိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ယေသျှုသည် ယေရုဆလင်မြို့သို့ ကြွတော်မူစဉ်၊ တပည့်တော် တစ်ဆယ့်နှစ်ပါးကို ဘေးနားက ခေါ်ဆောင်လျက် လမ်းလျှောက်ယင်း သူရို့အား သီးသန့် မိန့်မှာတော်မူသည်မှာ၊ ");
INSERT INTO rki_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“နားထောင်ကတ်။ ငါရို့သည် ယေရုဆလင်မြို့သို့ လားကြပြီ။ ထိုနီရာ၌ လူသားကို ယဇ်ပရောဟိတ်အကြီးအကဲတိ၊ ကျမ်းတတ်ဆရာတိ လက်ထဲသို့ အပ်နှံကြလိမ့်မည်။ သူရို့သည် လူသားကို အသက်သီယောင်ထိ ပြစ်ဒဏ်ပီးကတ်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ထို့နောက် သူရို့သည် လူသားကို လူမျိုးခြားတိလက်သို့ အပ်ကြလိမ့်မည်၊ ထိုသူရို့သည် လူသားကို လှောင်ပြောင်ခြင်းကိုပြု၍ ကြာပွတ်နှင့် သတ်ကြလိမ့်မည်။ နောက်ဆုံး၌ လူသားကို လက်ဝါးကပ်တိုင်မှာ တင်၍ သတ်ကြလိမ့်မည်၊ သို့သော်လည်း လူသားသည် သုံးရက်မြောက်သောနိ့မှာ သီခြင်းက ထမြောက်လိမ့်မည်” ဟု ပြော၏။ ");
INSERT INTO rki_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","ထိုအခါ ဇေဗေဒဲ၏မယားသည် သူမ၏သား နှစ်ယောက်နှင့်အတူ ယေသျှုထံပါးသို့ ရောက်လာ၍ ယေသျှုရှိ့မှာ ပျပ်ဝပ်ကာ သူမ လိုချင်သောအရာတစ်ခုကို တောင်းဆို၏။ ");
INSERT INTO rki_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ယေသျှုက၊ “သင်သည် ဇာကို လိုချင်ပါလဲ” ဟု သူမအား မိန်း၏။ “အသျှင်ဘုရားသည် သျှင်ဘုရင်ဖြစ်လာသောအချိန်မှာ အကျွန့်သားနှစ်ယောက်ကို အသျှင်ဘုရား၏ လက်ယာရံ၊ လက်ဝဲရံ အဖြစ်စံမြန်းရပါမည့်အကြောင်း ကတိစကားတစ်ခွန်းကို အကျွန့်အား ပီးတော်မူပါ” ဟု ထိုမိန်းမက တောင်းလျှောက်၏။ ");
INSERT INTO rki_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ယေသျှုကလည်း “သင်ရို့ ဇာကို တောင်းနိန်သည်ကို သင်ရို့ မသိကတ်။ ငါ သောက်ရမည့် ခွက်ကို သင်ရို့ သောက်နိုင်ကတ်ဖို့လား” ဟု သူမ၏ သားနှစ်ယောက်ကို မိန့်တော်၏။ သူရို့ကလည်း “အကျွန်ရို့ သောက်နိုင်ပါ၏” ဟု လျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ယေသျှုက “သင်ရို့သည် ငါ၏ခွက်ကို အမှန်ပင် သောက်ရကြလိမ့်မည်။ သို့သော် ငါ၏လက်ယာဖက်၊ လက်ဝဲဖက်မှာ ထိုင်မည့်သူတိကို ငါသည် ရွီးချယ်ပိုင်ခွင့် မဟိ။ ငါ၏အဖက ရွီးချယ်ထားသောသူရို့သာ ဤနီရာကို ပိုင်ထိုက်တော်မူ၏” ဟု သူရို့အား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ကျန်သော တပည့်တော်ဆယ်ယောက်က ဤအကြောင်းကို ကြားကြသောအခါ ထိုညီအစ်ကို နှစ်ယောက်ကို စိတ်ဆိုးကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ထို့ကြောင့် ယေသျှုက တပည့်တော်အားလုံးကို ခေါ်ပြီးလျှင်၊ “လောကီမင်းတိမှာ လူထုကို အုပ်ချုပ်ရန် အာဏာသုံးကြ၏၊ အစိုးရခေါင်းဆောင်တိမှာလည်း အခွင့်အာဏာကို ကျင့်သုံးကြသည်ကို သင်ရို့ သိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","သို့သော်လည်း သင်ရို့တွင် ဤသို့ မဟုတ်၊ အကြီးအကဲ လုပ်ချင်သောသူသည် အားလုံး၏ အခိုင်းအစီဖြစ်ရမည်။ ");
INSERT INTO rki_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","သင်ရို့တွင် အမြင့်ဆုံးမှာ နီချင်သောသူသည် အားလုံး၏အစီခံကျွန် ဖြစ်ရမည်။ ");
INSERT INTO rki_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","လူသားသည် သူတစ်ပါးကို စီခိုင်းရန် ကြွလာခြင်း မဟုတ်၊ လူတိကို ရွီးနုတ်ခြင်းငှာ မိမိအသက်ကို စွန့်၍ အစီခံရန် ကြွလာခြင်းဖြစ်၏” ဟု ဆုံးမသြဝါဒ ပီးတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ယေသျှုနှင့် သူ၏တပည့်တော်ရို့သည် ယေရိခေါမြို့က ထွက်လာကြသောအခါ လူအုပ်ကြီးလည်း နောက်မှ လိုက်လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","လမ်းဘေးမှာ ထိုင်နိန်သော မျက်မမြင်နှစ်ယောက်က ယေသျှု ဖြတ်လားသည်ကို ကြားသောအခါ “ဒါဝိဒ်၏သားတော် အကျွန်ရို့ကို သနားတော်မူပါ၊ အသျှင်” ဟု အော်ဟစ်၍ လျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","လူအုပ်ကြီးက သူရို့ကို ဆူပူကြိမ်းမောင်းလျက် တိတ်ဆိတ်စွာ နီကြရန်ပြောကြ၏။ သို့သော်လည်း သူရို့က “ဒါဝိဒ်၏သားတော် အကျွန်ရို့ကို သနားတော်မူပါ၊ အသျှင်” ဟု သာ၍ ကျယ်သောအသံနှင့် အော်ဟစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ထိုအခါ ယေသျှုက ရပ်တော်မူလျက် သူရို့ကို ခေါ်၍ “သင်ရို့အဖို့ ငါ ဇာလုပ်ပီးရဖို့လဲ” ဟု မိန်း၏။ ");
INSERT INTO rki_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","သူရို့က “အသျှင်၊ အကျွန်ရို့ မျက်စိမြင်ချင်ပါရေ” ဟု တောင်းလျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ယေသျှုသည် လွန်စွာ သနားစိတ်ဝင်၍ သူရို့၏မျက်စိကို တို့တော်မူလျှင် သူရို့သည် ချက်ချင်း မျက်စိမြင်လာကြပြီး ကိုယ်တော်နောက်သို့ လိုက်လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ယေသျှုနှင့် သူ၏တပည့်တော်ရို့သည် ယေရုဆလင်မြို့သို့ လာကြရာ၊ သံလွင်တောင်ခြီရင်း၌ဟိသော ဗက်ဖာဂေရွာနားသို့ ရောက်လာကြ၏။ ထိုနီရာ၌ ယေသျှုသည် တပည့်တော်နှစ်ယောက်ကို၊ ");
INSERT INTO rki_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“သင်ရို့သည်ကား ရှိ့က ရွာကို လားကတ်လီ။ ရောက်လျှင် ဘေးနားမှာ သားချေတစ်ကောင်နှင့် တွဲ၍ ချိုင်ထားသော မြည်းမတစ်ကောင်ကို တွိ့လိမ့်မည်။ ယင်း မြည်းမနှင့် မြည်းချေကို ကြိုးဖြီပြီးလျှင် ငါ့ပါးသို့ ယူလာကတ်။ ");
INSERT INTO rki_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","သို့သော် တစ်ယောက်ယောက်က တစ်ခုခုပြောလျှင် ‘သခင်က ဤမြည်းမနှင့် မြည်းချေကို အလိုဟိလို့ပါ’ ဟု သူ့ကို ပြန်ပြောလိုက်ပါ၊ သူသည် ချက်ချင်း ယူခွင့်ပီးလိမ့်မည်” ဟု ညွန်ကြားကာ ရှိ့က စီရွှတ်လိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ဤအကြောင်းအရာကား ပရောဖက် ဟောထားချက်တိ ပြည့်စုံလာခြင်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“ကြည့်ကတ်ပါ၊ သင်ရို့၏ သျှင်ဘုရင်သည် မြည်းမနှင့် မြည်းချေကို စီး၍ စိတ်နှလုံးကို နှိမ့်ချလျက် သင်ရို့ပါးသို့ ရောက်လာယာ ဟု ဇိအုန်သတို့သမီးကို ပြောကတ်ပါ” ဟူ၍ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","တပည့်တော်ရို့သည် ထွက်လားကြပြီးလျှင် ယေသျှု စီခိုင်းသည့်အတိုင်း လုပ်ဆောင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","သူရို့သည် သားချေတစ်ကောင်နှင့် မြည်းမကို ယူဆောင်လာကြပြီးလျှင် ထိုမြည်းထက်၌ သူရို့၏ဝတ်ရုံများကို ခင်းပြီးနောက် ယေသျှုသည် စီးတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","များစွာသောလူရို့သည် မိမိရို့၏ဝတ်ရုံများကို လမ်းမထက်မှာ ဖြန့်ခင်းထားကြ၏။ တချို့သည် သစ်ပင်မှ အကိုင်းအခက်များကို ခွတ်၍ လမ်းမထက်မှာ ဖြန့်ခင်းထားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ယေသျှု၏ ရှိ့မှလည်းကောင်း၊ နောက်မှလည်းကောင်း လမ်းလျှောက် လာကြသော လူတိက “ဒါဝိဒ်သားတော်အား ဟောသျှဏ္ဏ ဖြစ်ပါစီ။ ထာဝရဘုရားသခင်၏ နာမတော်နှင့် ကြွလာသော သူသည် မင်္ဂလာဟိပါစီ။ အမြင့်ဆုံးသောကောင်းကင်၌ ဟောသျှဏ္ဏ ဖြစ်ပါစီ” ဟု ကြွေးကြော်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ယေသျှုသည် ယေရုဆလင်မြို့သို့ ဝင်လာသောအခါ တစ်မြို့လုံး ရုတ်ရုတ်သဲသဲ ဖြစ်ကြပြီးလျှင် “ဤသူက ဇာသူလဲ” ဟု အချင်းချင်း မိန်းမြန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","လူအုပ်ကြီးက “ဤသူသည် ဂါလိလဲပြည် နာဇရက်မြို့သား ပရောဖက် ယေသျှု ဖြစ်၏” ဟု ပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ယေသျှုသည် ဗိမာန်တော်သို့ ဝင်လာပြီး၊ ဗိမာန်တော်ထဲ၌ အရောင်းအဝယ် လုပ်နိန်ကြသောသူ အားလုံးကို မောင်းထုတ်၏။ ငွီလှဲကောင်တာစားပွဲတိ ဂြိုးငှက်ရောင်းသူများ၏ ထိုင်ခုံ စားပွဲတိကို တွန်းလှဲကာ မှောက်လှန်ပစ်လိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ကိုယ်တော်က “ဘုရားသခင်နှုတ်ကပတ်တော်ကျမ်းစာ၌ ရီးထားသည်မှာ ‘ငါ၏အိမ်တော်ကို ဆုတောင်းပတ္ထနာပြုရာ အိမ်တော်ဟု ခေါ်ဆိုရလိမ့်မည်’ ဟု ဖော်ပြထား၏။ သို့ရာတွင် သင်ရို့သည် ဤဗိမာန်တော်ကို သူခိုးဓါးပြ ပုန်းအောင်းသည့် နီရာအဖြစ် လုပ်နိန်ကြသည်တကား” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ယေသျှုသည် ဗိမာန်တော်ထဲမှာ ဟိနိန်သောအခါ မျက်မမြင်များနှင့် ခြီထောက်မသန်စွမ်းသူများသည် ကိုယ်တော်အပါးသို့ ရောက်လာကြ၏။ ကိုယ်တော်က သူရို့၏ရောဂါများကို ပျောက်ကင်းစီတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ယဇ်ပရောဟိတ်အကြီးအကဲများနှင့် ကျမ်းတတ်ဆရာများသည် ကိုယ်တော်ပြုတော်မူသော အံ့သြဘွယ်အရာများကို မြင်၍ လည်းကောင်း၊ ဗိမာန်တော်ထဲမှာ ဟိနိန်ကြသောသူငယ်တိက “ဒါဝိဒ်၏သားတော်အဖို့ ဟောသျှဏ္ဏဖြစ်ပါစီ” ဟု ကြွေးကြော်နိန်ကြသည်ကို မြင်ရ၍လည်းကောင်း၊ ဒေါသထွက်လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ထို့ကြောင့် သူရို့က “ဤသူငယ်တိ၊ ဇာပိုင် အော်နိန်ကြသည်ကို သင်ကြားသလား” ဟု ယေသျှုကို မိန်းကြ၏။ ယေသျှုက “ငါ အမှန်ပင် ကြား၏၊ ‘ကိုယ်တော်သည် နိ့စို့သူငယ်တိနှင့် အချေတိကို ကျေးဇူးတော် ချီးမွမ်းတတ်စီရန် သင်ကြားပီးလေပြီ’ ဟု ကျမ်းစာမှာ ရီးထားသည်ကို သင်ရို့ မဖတ်ဖူးကတ်လား” ဟု ယေသျှုက ပြော၏။ ");
INSERT INTO rki_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ယေသျှုသည် သူရို့ကို ထားခပြီးလျှင် မြို့မှ ထွက်ခွါ၍ ဗေသနိရွာသို့ ကြွတော်မူကာ ထိုရွာ၌ ညအိပ်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","ယေသျှုသည် နောက်တစ်နိ့ မိုးထစောစော မြို့သို့ ပြန်ကြွတော်မူသောအခါ လမ်းမှာ ဝမ်းဆာတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ကိုယ်တော်သည် လမ်းဘေးမှာ သဖန်းပင်တစ်ပင်ကို မြင်၍ လားကြည့်တော်မူ၏၊ သို့ရာတွင် အရွက်များသာဟိပြီး အသီးတစ်လုံးမျှ မတွိ့သဖြင့် ကိုယ်တော်က “ဤအပင်သည် နောက်တစ်ခါမျှ အသီးမသီးပါစီကေ့” ဟု မိန့်တော်မူလိုက်သည်နှင့် သဖန်းပင်သည် ချက်ချင်း ခြောက်သွိ့လားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","တပည့်တော်ရို့သည် ဤအခြင်းအရာတိကို မြင်ကြသောအခါ အလွန်အံ့အားသင့်ကြ၏။ “ဤသဖန်းပင်သည် ချက်ချင်း ဇာပိုင် ခြောက်လခလဲ” ဟု သူရို့က မေးကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ယေသျှုက “သင်ရို့ကို ငါ အမှန်ဆိုသည်ကား သင်ရို့မှာ သံသယကင်းသည့်ယုံကြည်ခြင်းသာ ဟိမည်ဆိုလျှင် ဤသဖန်းပင်ကို ငါ လုပ်ရေပိုင် လုပ်နိုင်သည်သာမက ဤတောင်ကုန်းကို ‘ပင်လယ်ထဲသို့ ကျလီ’ ဟု ဆိုလျှင် သင်ရို့ဆိုသည့်အတိုင်း ဖြစ်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","သင်ရို့သည် ယုံကြည်ခြင်း ဟိကြလျှင် သင်ရို့ တောင်းသမျှကို ရကြလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ယေသျှုသည် ဗိမာန်တော်သို့ ဝင်ရောက်၍ ဆုံးမဩဝါဒကို ပီးတော်မူစဉ်တွင် ယဇ်ပရောဟိတ် အကြီးအကဲရို့နှင့် ဘာသာရေးခေါင်းဆောင်ရို့သည် ကိုယ်တော်ပါးသို့ ရောက်လာကြ၏။ သူရို့က “သင်သည် ဤရာတိကို ဇာအခွင့်အာဏာနှင့် လုပ်နိန်ပါလဲ။ ယေပြီးကေ သင့်အား ဤအခွင့်အာဏာကို ဇာသူက ပီးထားလဲ” ဟု မိန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ယေသျှုက “ငါလည်း သင်ရို့ကို မိန်းခွန်းတစ်ခု မိန်းမေ။ သင်ရို့ ငါ့ကို အဖြေပီးနိုင်လျှင် ငါသည်လည်း ဤအရာတိကို ဇာအခွင့်အာဏာနှင့် လုပ်နိန်လည်းဆိုစွာကို သင်ရို့အား ငါ ပြောပြမည်။ ");
INSERT INTO rki_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ဗတ္တိဇံပီးခြင်းငှာ ယောဟန်၏အခွင့်အာဏာသည် ဇာက လာလဲ၊ ဘုရားပါးက လာလား သို့တည်းမဟုတ် လူပါးကလား” ဟု မိန်းလေ၏။ “ငါရို့ ဇာပိုင် ဖြေရပါဖို့လဲဟု သူရို့အချင်းချင်း ငြင်းခုံကြ၏။ ‘ဘုရားပါးက’ ဟု ငါရို့ ဖြေလျှင် ‘သင်ရို့သည် ယောဟန်ကို ဇာကြောင့် မယုံကတ်လဲ’ ဟု သူက ငါရို့ကို မိန်းမည်။ ");
INSERT INTO rki_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","သို့တည်းမဟုတ် ‘လူပါးက’ ဟု ဖြေလျှင် သူရို့အားလုံး ယောဟန်ကို ပရောဖက်တစ်ပါးလို့ ယုံကြည်ထားရေ အတွက်ကြောင်း လူထုပရိသတ်ကို ငါ့ရို့ ကြောက်ရ၏” ");
INSERT INTO rki_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ထို့ကြောင့် သူရို့က “အကျွန်ရို့မသိပါ” ဟု ပြန်ပြောကြ၏။ ထိုအခါ ယေသျှုက “ငါသည်လည်း ဤအရာတိကို ဇာအခွင့်အာဏာနှင့် လုပ်နိန်သည်ကို သင်ရို့အား ပြောလိမ့်မည် မဟုတ်” ဟု သူရို့အား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“အဂု သင်ရို့ ဇာကို စဉ်းစားနိန်ကတ်လဲ။ တစ်ခါက လူတစ်ယောက်မှာ သားနှစ်ယောက် ဟိ၏။ သူသည် သားကြီးပါးသို့ လားပြီးလျှင် ‘သားကြီး၊ ဤနိ့ စပျစ်ဥယျာဉ်မှာ အလုပ် လားလုပ်ခီ’ ဟု ရွှတ်လိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","သားကြီးက ‘အကျွန် မလားချင်ပါ’ ဟု ပြောသော်လည်း သူသည် တဖန် စိတ်ပြောင်းလဲကာ ဥယျာဉ်သို့ လား၍ အလုပ်လုပ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","သူသည် သားငယ်ပါးသို့ လား၍ ထိုနည်းတူပြောသောခါ သားငယ်က ‘အကျွန် လား၍ လုပ်ခိမေ’ ဟု ပြောသော်လည်း မလားဘဲနိန်၏။ ");
INSERT INTO rki_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","ထိုသားနှစ်ယောက်တွင် ဇာသူက သူ့အဖ၏အလိုတော်ကို လုပ်ဆောင်လဲ” ဟု ယေသျှုက မိန်း၏။ “သားကြီးပါ” ဟု သူရို့က ဖြေကြားကြ၏။ ယေသျှုက “သင်ရို့ကို ငါ အမှန်ဆိုသည်ကား အခွန်ကောက်သောသူတိနှင့် ပြည့်တန်ဆာမတိသည် သင်ရို့ထက် ရှိ့က ဘုရားသခင်၏နိုင်ငံတော်သို့ ဝင်နိန်ကတ်ယာ” ဟု သူရို့အား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","အကြောင်းမူကား ဗတ္တိဇံယောဟန်သည် သင်ရို့အား ဖြောင့်မတ်ခြင်းတရားလမ်းကို ညွှန်ပြရန် သင်ရို့ပါးသို့ ရောက်လာခယာ။ သင်ရို့သည် သူ့ကို မယုံခကတ်။ အခွန်ကောက်သောသူတိနှင့် ပြည့်တန်ဆာမတိက သူ့ကို ယုံကတ်တေ။ သင်ရို့သည် ဤအကြောင်းအရာကို မြင်တွိ့ခသော်လည်း သူ့ကို ယုံကြည်ရန် သင်ရို့သည် နောက်တဖန် စိတ်ပြောင်းလဲခြင်း မဟိကတ်ပါတကားဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","ယေသျှုက “နောက် ပုံဥပမာတစ်ခုကို နားထောင်ကတ်။ တစ်ခါက စပျစ်ဥယျာဉ်စိုက်ပျိုးသော မြီပိုင်သျှင်တစ်ယောက်ဟိ၏။ သူသည် ဥယျာဉ်ဝင်းပတ်လည်ကို ခြံစည်းရိုး ကာပြီး၊ ခြံထဲ၌ စပျစ်သီးနယ်ရန် တွင်းကို တူး၍ လင့်စင်တစ်ခုကို ဆောက်၏။ ပြီးလျှင် သူသည် ထိုစပျစ်ဥယျာဉ်ကို ဥယျာဉ်စိုက်ပျိုးသူတချို့ကို ငှားထားခပြီးနောက် ခရီးလားခလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","စပျစ်သီးခူးချိန် ရောက်သောအခါ သူသည် သူ၏ခြံငှားခရမည့် သီးနှံဝီစုကို တောင်းရန် သူ၏ကျွန်တိကို ခြံငှားတိပါးသို့ ရွှတ်လိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","ခြံငှားတိက သူ၏ ကျွန်တိကို ဖမ်းဆီးကာ တစ်ယောက်ကို ရိုက်ပုတ်ကြ၏။ တစ်ယောက်ကိုကား အသီသတ်ကြ၏၊ တစ်ယောက်ကို ကျောက်ခဲနှင့် ပစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","ခြံပိုင်သျှင်က ပထမအကြိမ်ထက်များသော ကျွန်တိကို နောက်ထပ်တစ်ခါ ရွှတ်လိုက်၏။ ခြံငှားတိက ထိုနည်းအတိုင်း ပြု၍ ရွှတ်လိုက်ကြပြန်၏။ ");
INSERT INTO rki_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","နောက်ဆုံး၌ ပိုင်သျှင်က ‘သူရို့သည် ငါ၏သားကို အမှန် ရိုသီကြလိမ့်မည်’ ဟု ဆိုကာ သူ့သားကို သူရို့ပါးသို့ ရွှတ်လိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","သို့ရာတွင် သီးစားအငှားသားတိက သူ၏သားကို မြင်သောအခါ ‘ဤသူသည် ခြံပိုင်သျှင်သား ဖြစ်တေ၊ လာကတ်၊ သူ့ကို သတ်ပြီးကေ သူ့အမွီကို ငါရို့ ယူကတ်မေ’ ");
INSERT INTO rki_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ဟု ခြံငှားတိက ပိုင်သျှင်၏သားကို ဖမ်းဆီးကာ ခြံပြင်သို့ ထုတ်၍ သတ်ပစ်လိုက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“သို့ဖြစ်လျှင် စပျစ်ခြံပိုင်သျှင် လာသောအခါ သူသည် ထိုခြံငှားတိကို ဇာပိုင် လုပ်လိမ့်မည်နည်း” ဟု ယေသျှုက မိန်းတော်မူ၏၊ ");
INSERT INTO rki_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","“သူရို့က သူသည် ထိုဆိုးယုတ်သောသူတိကို ဧကန်မုချ သတ်ပစ်လိမ့်မည်၊ သူ၏စပျစ်ဥယျာဉ်ကိုလည်း အသီးပေါ်ချိန်မှာ သီးစားခပီးသော တခြားလူတိကို ငှားပစ်လိမ့်မည်” ဟု ဖြေကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ယေသျှုက သမ္မာကျမ်းစာကို သင်ရို့ တစ်ခါလည်း မဖတ်ဖူးကတ်လား၊ “ ‘တိုက်အိမ်ကို ဆောက်သောသူတိက အသုံးမဝင်၍ ပယ်ထားသော ကျောက်တုံးသည် အဆောက်အဦးတစ်ခုလုံး၏ အရေးအကြီးဆုံးနီရာ၌ ပြန်ရောက်လာ၏။ ဤကား ဘုရားသခင် ပြုတော်မူသောအမှု ဖြစ်၏။ ငါရို့ အမြင်မှာ အလွန်အံ့သြဖို့ ကောင်း၏’ ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“ထို့ကြောင့် ယေသျှုက သင်ရို့ကို ငါဆိုသည်ကား ဘုရားသခင်၏နိုင်ငံတော်ကို သင်ရို့ပါးက သိမ်းယူ၍ နိုင်ငံတော်၏အသီးကို သီးမည့် လူတိပါးသို့ ပီးအပ်လိမ့်မည်” ဟု ထပ်၍ မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ယဇ်ပုရောဟိတ်အကြီးအကဲများနှင့် ဖာရိယှဲများသည် ယေသျှုပြောသည့် ပုံဥမာကို ကြားကြသောအခါ မိမိရို့၏အကြောင်းကို ပြောနိန်သည်ဟု သိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ထို့ကြောင့် သူရို့သည် ယေသျှုကို ဖမ်းဆီးရန် ကြိုးစားကြ၏။ သို့သော်လည်း လူအများက ယေသျှုသည် ပရောဖက်တစ်ပါးဖြစ်သည်ဟု ယုံကြည်ကြသောကြောင့် လူထုပရိသတ်ကို ကြောက်နိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","ယေသျှုသည် လူတိကို ပုံဥပမာကို သုံး၍ တဖန် မိန့်တော်မူပြန်၏။ ");
INSERT INTO rki_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“ကောင်းကင်နိုင်ငံတော်သည် ဤဥပမာနှင့် တူ၏။ အယင်က သျှင်ဘုရင်တစ်ပါးသည် မိမိသားတော်အတွက် မင်္ဂလာပွဲတစ်ခုကို ပျင်ဆင်ကျင်းပ၏။ ");
INSERT INTO rki_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ထိုမင်းကြီးသည် မိမိ၏အခိုင်းအစီများအား မင်္ဂလာပွဲသို့ ဖိတ်ထားသော ဧည့်သည်တော်များကို ခေါ်ခိုင်းလိုက်၏။ သို့သော်လည်း သူရို့သည် မလာဘဲနိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","မင်းကြီးက ‘ငါ၏နွားထီးတိ၊ နွားချေတိကို သတ်ပြီး အားလုံးကို အဆင်သင့်ပျင်ထားပြီးယာ၊ သို့ဖြစ်၍ မင်္ဂလာပွဲတော်သို့ လာရောက်ရန် ဖိတ်ကြားထားသောသူတိကို လားပြောကတ်ခီ’ ဟု သာ၍များသော အခိုင်းအစီတိကို စီရွှတ်လိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","သို့သော်လည်း ဖိတ်ကြားထားသောသူများသည် ဂရုမစိုက်ဘဲ မိမိရို့၏စီးပွားရေးအလုပ်သို့သာ လားကြ၏၊ တစ်ယောက်က လယ်တောသို့ လား၏၊ တခြားတစ်ယောက်က ဈီးရောင်းဖို့ ထွက်လား၏၊ ");
INSERT INTO rki_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","တခြားလူတိက အခိုင်းအစီတိကို ဖမ်းဆီး၍ ထုထောင်းကာ သတ်ဖြတ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","ထို့ကြောင့် ဘုရင်မင်းကြီးသည် လွန်စွာစိတ်ဆိုးလျက် သူ၏ စစ်တပ်ကို စီရွှတ်၍ ထိုလူသတ်သမားတိကို သတ်ဖြတ်ပြီးလျှင် သူရို့၏ မြို့ကိုလည်း မီးတိုက်ပစ်လိုက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","ထိုအခါ ဘုရင်မင်းကြီးက အခိုင်းအစီကျွန်တိကို ခေါ်ပြီးလျှင် ‘ငါ၏ မင်္ဂလာပွဲသည် အဆင်သင့် ဖြစ်နိန်ပြီ သို့သော်လည်း ငါ ဖိတ်ထားသောသူတိသည် မင်္ဂလာပွဲသို့ လာရောက်ခြင်းငှာ မထိုက်တန်။ ");
INSERT INTO rki_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ထို့ကြောင့် သင်ရို့သည် အဂုပင် လမ်းဆုံ လမ်းခွများသို့ လား၍ တွိ့သမျှ လူတိကို မင်္ဂလာပွဲသို့ ဖိတ်ခေါ်ကတ်ခီ’ ဟု စီရွှတ်လိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ထို့ကြောင့် အခိုင်းအစီများသည် လမ်းကြိုလမ်းကြားသို့ ဝင်၍ လူဆိုးလူကောင်းမကျန် တွိ့သမျှ လူတိကို စုလိုက်ကြသဖြင့် မင်္ဂလာခန်းမတစ်ခုလုံး လူတိ ပြည့်လျှံလားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“သို့သော်လည်း မင်းကြီးသည် ဧည့်သည်တိကို ကြည့်ရှုရန်ဝင်လာသောခါ မင်္ဂလာအခမ်းအနားဝတ်စုံ မဝတ်ထားသော လူတစ်ယောက်ကို မြင်တွိ့၏။ ");
INSERT INTO rki_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","မင်းကြီးက ‘အဆွီ၊ သင်သည် မင်္ဂလာအခမ်းအနားဝတ်စုံ မဝတ်ဘဲ ဤနီရာကို ဇာပိုင် ရောက်လာလဲ’ ဟု ထိုသူအား မိန်းလေ၏။ သို့ရာတွင် ထိုသူက တစ်ခုလည်း ပြန်မပြောဘဲ နိန်၏။ ");
INSERT INTO rki_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","ထိုအခါ ဘုရင်မင်းကြီးက ‘ဤသူ၏ ခြီလက်တိကို တုတ်ချိုင်ပြီးလျှင် ပွဲအပြင်ဖက် မှောင်မိုက်ထဲသို့ ဝေးထုတ်ပစ်လိုက်ကတ်။ ယင်းသူသည် ယင်းနီရာမှာ အံကြိတ်၍ ငိုကျွီးလျက် နိန်ရလိမ့်မည်’ ဟု အခိုင်းအစီတိကို မိန့်တော်မူ၏။” ");
INSERT INTO rki_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","ယေသျှုက “ဖိတ်ခေါ်ထားသောသူ များစွာဟိသော်လည်း ရွီးကောက်ခံရသူ အလွန်နည်း၏” ဟု ပြော၍ ပုံပြင်ကို အဆုံးသတ်လိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","ဖာရိယှဲများ ထွက်လားပြီးနောက် ယေသျှုကို မိန်းခွန်းများ မိန်း၍ အပြစ်ရှာခြင်းငှာ စီမံကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ထို့ကြောင့် သူရို့သည် မိမိ၏တပည့်တိနှင့် ဟေရုဒ်၏လူရို့ကို ကိုယ်တော်ပါးသို့ စီရွှတ်လိုက်ကြ၏။ သူရို့က “ဆရာ ကိုယ်တော်သည် ဇာသူတစ်ယောက်၏ အဆင့်အတန်းကိုလည်း စိတ်မဝင်းစားသည်ဖြစ်၍ တခြားလူတိ၏ ထင်မြင်ချက်ကို စိုးရိမ်စိတ် မဟိဘဲ လူတိအား ဘုရားသခင်အလိုတော်နှင့် ဆိုင်သော သမ္မာတရားကို သွန်သင်ပီးပါ၏။ ကိုယ်တော်သည် သမ္မာတရားကို ဟောကြားတော်မူသည်ကို အကျွန်ရို့ သိကြပါ၏။ ");
INSERT INTO rki_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","သို့ဖြစ်၍ ရောမဧကရာဇ်ဘုရင်ကို လူခွန်ပီးခွင့် ဟိပါသလား၊ ကိုယ်တော်၏ ထင်မြင်ချက်က ဇာပိုင်လဲ၊ အကျွန်ရို့အား မိန့်ကြားတော်မူပါ” ဟု လျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","သို့သော်လည်း ယေသျှုသည် သူရို့၏ယုတ်ညံ့သော အစီအစဉ်ကို သတိမူ၍ “သူတော်ကောင်းယောင်ဆောင်သောသူတိ၊ ငါ့ကို အပြစ်ရောက်စီခြင်းငှာ ဇာကြောင့် ကြိုးစားနိန်ကတ်လဲ၊ ");
INSERT INTO rki_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","သင်ရို့ အခွန်ပီးသော ဒင်္ဂါးပြားကို ငါ့ကို ပြကတ်ပါ” ဟု မိန့်တော်မူ၏။ သူရို့သည် ဒင်္ဂါးပြားကို ယေသျှုပါးသို့ ယူလာကြသောအခါ၊ ");
INSERT INTO rki_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ကိုယ်တော်က “ဤဒင်္ဂါးပြားမှာ ဇာသူ၏မျက်နှာပုံနှင့် နာမည်ပါလဲ” ဟု သူရို့ကို မိန်း၏။ ");
INSERT INTO rki_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","သူရို့က “ဧကရာဇ်မင်းကြီး၏ မျက်နှာပုံနှင့် နာမည်ပါ၏” ဟု လျှောက်ကြ၏။ ထို့ကြောင့် ယေသျှုက “ကောင်းယာ၊ ဧကရာဇ်မင်းကြီးပိုင်သောအရာကို ဧကရာဇ်မင်းကြီးအား ပီးကြ။ ဘုရားသခင်ပိုင်သောအရာကို ဘုရားသခင်အား ပီးကြ” ဟူ၍ မိန့်တော်မူလိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","သူရို့သည် ဤစကားကို ကြားကြသောအခါ အလွန်အံ့သြလျက် ကိုယ်တော်ပါးက ထွက်ခွါလားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ထိုနိ့၌ ဇဒ္ဒုကဲရို့သည် ယေသျှုပါးသို့ ရောက်လာကြ၏။ ထိုသူရို့က လူသည် သီပြီးလျှင် သီခြင်းက ထမြောက်ခြင်းမဟိဟု အခိုင်အမာ ယုံကြည်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","သူရို့က “ဆရာ၊ မောသျှေက အကျွန်ရို့ကို ပြောထားခသည်မှာ အချေမရဘဲ သီကျလားသည့် လူတစ်ယောက်အတွက် မျိုးဆက်မပြတ်စီခြင်းငှာ၊ ကျန်နိန်ခသော မုဆိုးမကို သူ၏ညီ တစ်ယောက်ယောက်နှင့် ပီးစပ်ရမည်ဟူ၍ ပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ဂုအချိန်မှာ ဤအရပ်၌ ညီအစ်ကို ခုနစ်ယောက်ဟိပါ၏။ အစ်ကိုအကြီးဆုံးသည် လက်ထပ်ပြီး၍ အချေမရဘဲ သီလားခ၏၊ ထို့ကြောင့် ကျန်နိန်ခသည့် မုဆိုးမကို ဒုတိယညီဖြစ်သူက လက်ထပ်ယူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","သူသည်လည်း သူမကို လက်ထပ်ပြီးနောက် သားသမီးမရဘဲ သီလားခသဖြင့် တတိယညီက ထိုမိန်းမကို လက်ထပ်ပြန်၏။ နောက်ဆုံး ညီအစ်ကို ခုနစ်ယောက်လုံးနှင့် လက်ထပ်ပြီးသော်လည်း သားသမီးမရဘဲ ညီအစ်ကိုအားလုံး သီကျလားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","နောက်ဆုံး၌ ထိုမိန်းမပါ သီကျလား၏။ ");
INSERT INTO rki_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ဤသို့ဖြစ်လျှင် ထိုသူအားလုံးသည် သီခြင်းက ထမြောက်လာကြသည့်အခါ ထိုမိန်းမသည် လက်ထပ်ကြသောညီအစ်ကို ခုနစ်ယောက်ထဲက ဇာသူ့မယား ဖြစ်လီပါဖို့လဲ” ဟု မိန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ယေသျှုက “သင်ရို့သည် ဘုရားသခင်၏တန်ခိုးကိုလည်းကောင်း ကျမ်းစာကိုလည်းကောင်း မသိကြသောကြောင့် အလွန် လွဲမှားနိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","သီခြင်းက ထမြောက်ကြသောသူများသည် ကောင်းကင်တမန်များကဲ့သို့ ဖြစ်ကြပြီးလျှင် လက်ထပ်ထိမ်းမြားခြင်းကို မပြုကတ်ယာ။ ");
INSERT INTO rki_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","သင်ရို့သည် သီခြင်းက ထမြောက်ခြင်းနှင့် ပတ်သက်၍ ဘုရားသခင်၏နှုတ်ကပတ်တော်ကို တစ်ခါလည်း မဖတ်ဖူးကတ်ပါလား။” ");
INSERT INTO rki_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“ငါသည် အာဗြဟံဘုရား၊ ဣဇာက်ဘုရား၊ ယာကုပ်ဘုရား ဖြစ်၏” ဟု မိန့်တော်မူခသည့်အတိုင်း “ဘုရားသခင်သည် သီကျလားသူရို့၏ဘုရား မဟုတ်။ အသက်ရှင်နိန်သောသူရို့၏ဘုရား ဖြစ်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","လူအုပ်ကြီးက ဤအကြောင်းကို ကြားကြသောအခါ သူ၏ဆုံးမဩဝါဒကို အလွန် ချီးမွမ်းအံသြကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","ယေသျှုသည် ဇဒ္ဒုကဲရို့ ပြန်မပြောနိုင်လောက်အောင် သြဝါဒ ပီးတော်မူသည်ကို ဖာရိယှဲရို့ ကြားကြသည့်အခါ သူရို့သည် အတူတကွ စုရုံးကြ၏၊ ");
INSERT INTO rki_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ထိုအခါ သူရို့အထဲက ကျမ်းတတ်ဆရာတစ်ယောက်သည် မိန်းခွန်းတစ်ခုကို မိန်းကာ ကိုယ်တော့်ကို အပြစ်ရှာရန် ကြိုးစားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“ဆရာ၊ ပညတ်တရားထဲမှာ ဇာပညတ်သည် အကြီးမြတ်ဆုံးပါလဲ” ဟု သူက မိန်း၏။ ");
INSERT INTO rki_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ယေသျှုက “‘သင်ရို့၏အသျှင် ထာဝရဘုရားကို မိမိ၏ စိတ်နှလုံး အကြွင်းမဲ့ ဉာဏ်ဟိသမျှနှင့် ချစ်ကြလော့။’ ");
INSERT INTO rki_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ဤပညတ်သည် ပထမဆုံးနှင့် အကြီးမြတ်ဆုံး ပညတ်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ထို့နောက် ဒုတိယပညတ်မှာ ‘ကိုယ်နှင့်စပ်ဆိုင်သောသူကို ကိုယ်နှင့်အမျှ ချစ်လော့’ ဟူ၍ ဖြစ်၏၊ ပထမပညတ်နှင့် တူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ဤပညတ်နှစ်ပါးသည် မောသျှေ၏ပညတ္တိကျမ်းနှင့် ပရောဖက်ကျမ်းများ၏ အချုပ်ဖြစ်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ဖာရိယှဲရို့ အတူတကွ စုရုံးနိန်ကြသောအခါ ယေသျှုက၊ ");
INSERT INTO rki_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“သင်ရို့သည် မေသျှိယအကြောင်းကို ဇာပိုင် စဉ်းစားနိန်ကတ်လဲ၊ သူသည် ဇာသူ၏သားလဲ” ဟု သူရို့ကို မိန်း၏။ သူရို့က “သူသည် ဒါဝိဒ်၏သား” ဟု ဖြေကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","ယေသျှုက “ယင်းပိုင်ဆိုကေ ဒါဝိဒ်သည် ဝိညာဉ်တော်အားဖြင့် မေသျှိယကို ‘သခင်’ ဟု ခေါ်သည်ကို ဇာပိုင် ဟိကတ်ဖို့လဲ။ အကြောင်းမူကား ဒါဝိဒ်က ပြောသည်မှာ ");
INSERT INTO rki_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“ ‘ထာဝရဘုရားသည် ငါ၏သခင်အား မိန့်တော်မူသည်မှာ ငါသည် သင်၏ရန်သူအားလုံးကို သင်၏ခြီဖဝါးအောက်၌ ချထားသည့်တိုင်အောင် သင်သည် ငါ၏လက်ယာဖက်၌ ထိုင်နိန်လော့’ ဟူ၍ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","ထိုသို့ ဒါဝိဒ်က မေသျှိယကို ‘သခင်’ ဟု ခေါ်ခလျှင် မေသျှိယသည် ဒါဝိဒ်၏သား ဇာပိုင် ဖြစ်နိုင်ဖို့လဲ” ဟု ဖာရိယှဲရို့ကို မိန်း၏။ ");
INSERT INTO rki_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ယေသျှု၏ မိန်းခွန်းကို တစ်ယောက်လည်း မဖြေနိုင်ကြ။ ထိုနိ့မှစ၍ မည်သူတစ်ဦးတစ်ယောက်ကမျှ ယေသျှုအား မိန်းမြန်းစုံစမ်းခြင်း မလုပ်ဝံ့ကတ်ယာ။ ");
INSERT INTO rki_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","ထို့နောက် ယေသျှုသည် မိမိ၏တပည့်တော်ရို့နှင့် လူထုပရိသတ်တိကို မိန့်တော်မူသည်မှာ ");
INSERT INTO rki_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“ကျမ်းတတ်ဆရာနှင့် ဖာရိယှဲရို့သည် မောသျှေ၏ပညတ်တရားများကို ဘာသာပြန်ခွင့်ဟိသူများ ဖြစ်ကြ၏၊ ");
INSERT INTO rki_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ထို့ကြောင့် သင်ရို့သည် သူရို့ ပြောသမျှကို နာခံ၍ လိုက်လျှောက်ကတ်။ သို့သော်လည်း သူရို့ကျင့်သည့်အတိုင်း မကျင့်ကတ်ကေ့၊ အကြောင်းမူကား သူရို့သည် မိမိရို့ဟောပြောသည့်အတိုင်း မကျင့်ကတ်။ ");
INSERT INTO rki_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","ထိုသူရို့သည် အလွန်လေး၍ ထမ်းရန်ခက်ခဲသောဝန်ထုပ်များကို သူတစ်ပါး ပက်ကုန်းထက်မှာ တင်တတ်ကြ၏၊ သို့သော်လည်း သူရို့မူကား ထိုဝန်ထုပ်များကို ထမ်းခြင်းငှာ သူရို့ကိုယ်တိုင် လက်ဖျားနှင့်တောင် မတို့ချင်ကြ၊ ");
INSERT INTO rki_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","သူရို့သည် မိမိရို့ပြုသမျှကို လူအများ မြင်စီခြင်းငှာ ပြုတတ်ကြ၏။ သူရို့သည် ပန်းဖွားအရှည်ကြီး ထိုးထားသည့် ဝတ်ရုံများကို ဝတ်ဆင်၍ မိမိရို့၏နဖူးနှင့် လက်မောင်းများတွင် သမ္မာကျမ်းစာပါသော အဆောင်လက်ဖွဲ့များကို ပတ်စည်းကာ ");
INSERT INTO rki_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","စားသောက်ပွဲများ၌ ဂုဏ်သိက္ခာဟိသော နီရာများကိုလည်းကောင်း တရားဇရပ်များ၌ ထည်ဝါခန်းနားသော ထိုင်ခုံများကိုလည်းကောင်း ကြိုက်တတ်ကြ၏၊ ");
INSERT INTO rki_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","သူရို့သည် လူစည်ကားရာအရပ်၌ ရိုသီစွာဖြင့် နှုတ်ဆက်ခြင်းကိုလည်းကောင်း ‘အသျှင်ဘုရား’ ဟူ၍ ခေါ်ဝေါ်ခြင်းကိုလည်းကောင်း အလွန် နှစ်သက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","သို့ရာတွင် သင်ရို့သည် ‘ဆရာ’ ဟူ၍ ခေါ်ဝေါ်ခြင်းကို မခံကတ်ကေ့၊ အကြောင်းမူကား သင်ရို့အားလုံးသည် ညီအစ်ကိုတိ ဖြစ်ကြ၏၊ သင်ရို့တွင် ဆရာ ဟူ၍ တစ်ဆူတည်းသာ ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","မြီကြီးပေါ်၌ ဇာသူ့ကိုလေ့ ‘အဖ’ ဟု မခေါ်ကတ်ကေ့၊ သင်ရို့တွင် ကောင်းကင်ဘုံ၌ အဖ တစ်ပါးတည်းသာ ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","သင်ရို့သည် ‘ဥပဇ္ဈာယ်ဆရာ’ ဟူ၍ ခေါ်ဝေါ်ခြင်းကို မခံကတ်ကေ့၊ အကြောင်းမူကား သင်ရို့၌ ဥပဇ္ဈာယ်ဆရာတည်းဟူသော မေသျှိယ တစ်ပါးတည်းသာ ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","သင်ရို့၌ အကြီးဆုံးဖြစ်သောသူသည် သင်ရို့အားလုံး၏အခိုင်းအစီ ဖြစ်ရမည်။ ");
INSERT INTO rki_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ဇာသူမဆို မိမိကိုယ်ကို ချီးမြှောက်သောသူသည် နှိမ့်ချခြင်းကို ခံရမည်၊ မိမိကိုယ်ကို နှိမ့်ချသောသူသည် ချီးမြှောက်ခြင်းကို ခံရလိမ့်မည် ဟူ၍ မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“ကျမ်းတတ်ဆရာတိနှင့် ဖာရိယှဲတိ၊ သင်ရို့သည် အမင်္ဂလာဟိကြ၏။ သင်ရို့သည် သူတော်ကောင်းယောင်ဆောင်သောသူတိ ဖြစ်ကြ၏။ သင်ရို့သည် ကောင်းကင်နိုင်ငံတန်းခါးပေါက်ကို လူတိရှိ့က ပိတ်ထားကြ၏၊ သင်ရို့သည် ကိုယ်တိုင်လည်းမဝင်၊ ဝင်ဖို့ ကြိုးစားနိန်သော သူတိကိုလည်း ဝင်ခွင့်မပြုကြ။ ");
INSERT INTO rki_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“ကျမ်းတတ်ဆရာနှင့် ဖာရိယှဲတိ၊ သင်ရို့သည် အမင်္ဂလာဟိကြ၏။ သင်ရို့သည် သူတော်ကောင်းယောင်ဆောင်သောသူတိ ဖြစ်ကြ၏။ သင်ရို့သည် လူတစ်ယောက်ကို ဘာသာသွင်းခြင်းငှာ ရီ မြီအနှံ့ လှည့်လည်ကြ၏၊ သင်ရို့သည် ဘာသာသွင်းပြီးသောအခါ၌လည်း သူရို့ကို မိမိရို့ထက် နှစ်ဆသောငရဲကို ခံစီကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“မျက်ကန်းလမ်းပြတိ၊ သင်ရို့သည် အမင်္ဂလာဟိကြ၏။ ‘မည်သူမဆို ဗိမာန်တော်ကို တိုင်တည်၍ ကျိန်ဆိုလို့ မရ၊ ဗိမာန်တော်ထဲ၌ ဟိသောရွှီကို တိုင်တည်၍ ကျိန်ဆိုမှရာ ရ၏’ ဟု သင်ရို့သည် သွန်သင်နိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","မျက်ကန်းလမ်းပြတိ၊ ရွှီက ကြီးမြတ်လား၊ ရွှီကို သန့်ယှင်းစီတော်မူသော ဗိမာန်တော်က သာ၍ ကြီးမြတ်သလား။ ");
INSERT INTO rki_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","သင်ရို့က ‘မည်သူမဆို ယဇ်ပလ္လင်ကို တိုင်တည်၍ ကျိန်ဆိုလျှင် မရ။ ယဇ်ပလ္လင်ထက်မှာ ဟိသော ယဇ်ပူဇော်သကာကို တိုင်တည်၍ ကျိန်ဆိုမှရာ ရ၏’ ဟု သွန်သင်နိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","သင်ရို့သည် မျက်ကန်းတိပါကား။ ယဇ်ပူဇော်သကာက ကြီးမြတ်တော်မူသလော၊ ယဇ်ပူဇော်သကာကို သန့်ယှင်းစီတော်မူသော ယဇ်ပလ္လင်က သာ၍ ကြီးမြတ်တော်မူသလော။ ");
INSERT INTO rki_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ထို့ကြောင့် ယဇ်ပလ္လင်ကို တိုင်တည်၍ ကျိန်ဆိုသောသူသည် ယဇ်ပလ္လင်နှင့်တကွ ယဇ်ပလ္လင်ထက်မှာ ဟိသမျှတိကို တိုင်တည်၍ ကျိန်ဆိုခြင်း ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","သို့ဖြစ်၍ ဗိမာန်တော်ကို တိုင်တည်ပြီး ကျိန်ဆိုသောသူသည် ဗိမာန်တော်နှင့်တကွ ဗိမာန်တော်၌ ကိန်းဝပ်တော်မူသောအသျှင်ကို တိုင်တည်၍ ကျိန်ဆိုခြင်း ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ကောင်းကင်ဘုံကို တိုင်တည်၍ ကျိန်ဆိုသောသူသည် ဘုရားသခင်၏ပလ္လင်တော်နှင့်တကွ ထိုပလ္လင်တော်၌ စံနိန်တော်မူသော အသျှင်ကို တိုင်တည်၍ ကျိန်ဆိုခြင်း ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“ကျမ်းတတ်ဆရာနှင့် ဖာရိယှဲတိ၊ သင်ရို့သည် အမင်္ဂလာဟိကြ၏။ သင်ရို့သည် သူတော်ကောင်းယောင်ဆောင်သောသူတိ ဖြစ်ကြ၏။ သင်ရို့သည် နှုန်း၊ စမုစပါး၊ ဇီယာ အစဟိသည့် ဟင်းမွှီးမဆလာတိမှာတောင်မှ ဘုရားသခင်ကို ဆယ်ဖို့တစ်ဖို့ ပီးကြ၏။ သို့ရာတွင် သင်ရို့သည် တရားမျှတမှု၊ သနားကရုဏာထားမှု၊ သစ္စာဟိမှုတည်းဟူသော သာ၍ အရေးကြီးသည့် ပညတ်တရားများကို ဘေးဖယ်ထားကတ်ပါကား။ ဦးစွာဖော်ပြသော ပညတ်တရားများကို ဘေးဖယ်မထားဘဲ နောက်ဖော်ပြသော ပညတ်တရားများကိုလည်း လက်တွိ့လိုက်နာအပ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","မျက်ကန်းလမ်းပြတိ၊ သင်ရို့သည် ခြင်ချေတစ်ကောင်မျှ မပါရယောင် ရီကို စစ်ကြပြီးလျှင် ကုလားအုတ်ကို အကောင်လိုက် မျိုချနိန်ကတ်ပါကား။ ");
INSERT INTO rki_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“ကျမ်းတတ်ဆရာနှင့် ဖာရိယှဲတိ၊ သင်ရို့သည် အမင်္ဂလာဟိကြ၏။ သင်ရို့သည် သူတော်ကောင်းယောင်ဆောင်သောသူတိ ဖြစ်ကြ၏။ သင်ရို့သည် သင်ရို့၏လောင်ပွန်း၊ ခွက်ဖလားတိကို အပြင်ဖက်က စင်ကြယ်အောင် ဆီးကြောကြသော်လည်း သင်ရို့၏အတွင်း၌ကား အတ္တမာနနှင့် အနိုင်ကျင့်မှုတိ ပြည့်နိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","မျက်ကန်းဖာရိယှဲ၊ ခွက်ဖလားအတွင်းကို အလျှင် စင်ကြယ်အောင် ဆီးကြောကတ်ပါ။ ထိုသို့ ပြုလျှင် အပြင်၌လည်း သန့်ယှင်းစင်ကြယ်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“ကျမ်းတတ်ဆရာတိနှင့် ဖာရိယှဲတိ၊ သင်ရို့သည် အမင်္ဂလာဟိကြ၏။ သင်ရို့သည် သူတော်ကောင်းယောင်ဆောင်သောသူတိ ဖြစ်ကြ၏။ သင်ရို့သည် ထုံးဖြူသုတ်ထားသည့်သင်္ချိုင်းအုတ်ဂူနှင့် တူ၏။ သင်္ချိုင်းအုတ်ဂူသည် အပြင်ဖက်က လှပသယောင်ဟိသော်လည်း အတွင်း၌ကား လူသီကောင်ရို့၏အရိုးတိ၊ အညစ်အကြေးတိနှင့် ပြည့်နိန်၏။ ");
INSERT INTO rki_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ထိုနည်းတူစွာ သင်ရို့သည် အပြင်သဏ္ဌာန်အားဖြင့် လူတိကို သူတော်ကောင်းယောင်ဆောင်ပြပြီးလျှင် အတွင်း၌ကား ဟန်ဆောင်မှု၊ မတရားမှုတိနှင့် ပြည့်နိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“ကျမ်းတတ်ဆရာတိနှင့် ဖာရိယှဲတိ၊ သင်ရို့သည် အမင်္ဂလာဟိကြ၏။ သင်ရို့သည် သူတော်ကောင်းယောင်ဆောင်သောသူတိ ဖြစ်ကြ၏။ သင်ရို့သည် ပရောဖက်များ၏သင်္ချိုင်းဂူကို ကောင်းစွာပြုလုပ်၍ သူတော်ကောင်းရို့၏သင်္ချိုင်းဂူကို အလှဆင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","တဖန် သင်ရို့က ငါရို့သည် ငါရို့၏ ဘိုးဘွားလက်ထက်က ဟိခလျှင် ပရောဖက်ရို့၏အသွီးကို သွန်းခြင်း၌ သူရို့နှင့်အတူ ပါဝင်ကြလိမ့်မည် မဟုတ်ဟု ပြောဆိုလေ့ဟိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ထိုသို့ ပြောဆိုခြင်းသည်ကား သင်ရို့သည် ပရောဖက်တိကို သတ်သောအမျိုး ဖြစ်ကြောင်း သင်ရို့ကိုယ်တိုင် သက်သီခံနိန်ကြခြင်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","သင်ရို့သည် သင်ရို့အဖိုးအဖီးတိက စ၍ လုပ်ခသည့်အလုပ်ကို ပြီးဆုံးသည့်တိုင်အောင် ဆက်ပြီး လုပ်ကတ်ပါ။ ");
INSERT INTO rki_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","အသင်မြွီတိနှင့် မြွီဆိုးအမျိုးတိ၊ သင်ရို့သည် ပြစ်ဒဏ်ခံရမည့်ငရဲက လွတ်လိမ့်မည်ဟု ထင်နိန်ကတ်လား။ ");
INSERT INTO rki_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","သင်ရို့ပါးသို့ ပရောဖက်တိ၊ ပညာဟိတိနှင့် ကျမ်းတတ်ဆရာတိကို ငါ ရွှတ်လိုက်၏။ သင်ရို့သည် သူရို့ထဲက တချို့ကို သတ်ကြလိမ့်မည်၊ တချို့ကို လက်ဝါးကပ်တိုင်မှာ တင်၍ သတ်ကြလိမ့်မည်၊ တချို့ကို တရားဇရပ်ထဲ၌ သတ်ပုတ်ကြလိမ့်မည်၊ တစ်မြို့ ပြီး တစ်မြို့ လိုက်၍ ဖမ်းကြလိမ့်မည်၊ ");
INSERT INTO rki_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ဖြောင့်မတ်သော အာဗေလမှစ၍ ဗာရခိသား ဇာခရိတိုင်အောင် ယဇ်ပလ္လင်နှင့် ဗိမာန်တော်ကြား မြီကြီးထက်မှာ သင်ရို့သတ်ထားခသော အပြစ်မဲ့လူတိ၏ အသွီးနှင့်ပတ်သက်သော အပြစ်အားလုံးသည် သင်ရို့ထက်သို့ ပုံ၍ ကျကတ်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ငါသည် အမှန်အတိုင်း သင်ရို့ကို ပြောရလျှင် ဤအပြစ်အားလုံးသည် အဂုဟိနိန်ကြသော လူတိထက်မှာ ကျလာကတ်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“ယေရုဆလင်မြို့၊ ယေရုဆလင်မြို့ သင်သည် ပရောဖက်တိကို သတ်မြဲ သတ်နိန်ပါရေကား၊ သင့်ပါးသို့ ဘုရားသခင်စီရွှတ်လိုက်သော တမန်တော်တိကို ကျောက်ခဲနှင့်ပစ်၍ မောင်းထုတ်မြဲ မောင်းထုတ်နိန်ကတ်ပါရေကား။ ကြက်မသည် ကြက်ချေတိကို မိမိ၏ အတောင်အောက်မှာ စုသိမ်းလျက် အုပ်ထိန်းထားသကဲ့သို့ ငါသည် သင်ရို့အားလုံးကို စုသိမ်းလျက် အုပ်ထိန်းထားချင်ပါ၏။ သို့သော်လည်း သင်ရို့သည် မလိုလားကတ်ပါကား။ ");
INSERT INTO rki_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","သို့ဖြစ်၍ သင်ရို့၏ ဗိမာန်တော်သည် စွန့်ပစ်ခြင်းကို ခံရသဖြင့် လူသူကင်းမဲ့လျက်ဟိလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ထို့ကြောင့် သင်ရို့ကို ငါဆိုသည်ကား ‘ထာဝရဘုရား၏နာမတော်ဖြင့် ကြွလာသောသူအား ဘုရားသခင် ကောင်းကြီးပီး ပါစီ’ ဟု သင်ရို့နှုတ်က မပြောသည့်တိုင်အောင် သင်ရို့သည် အဂုအချိန်မှစ၍ ငါ့ကို နောက်တဖန် မြင်ကြရလိမ့်မည် မဟုတ်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","ယေသျှုသည် ဗိမာန်တော်ထဲမှ ထွက်လာတော်မူပြီးနောက် တပည့်တော်တိက ဗိမာန်တော်အဆောက်အဦးကို ကြည့်ရန် လာ၍ခေါ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ထိုအခါ ယေသျှုက “သင်ရို့သည် ဤအဆောက်အဦးများကို မြင်ကြသလား။ သင်ရို့ကို ငါ အမှန် ဆိုသည်ကား ဤဗိမာန်တော်နီရာ၌ ကျောက်ခဲတစ်လုံးထက်မှာ တစ်လုံး မကျန်ဘဲ အားလုံးကို ဖြိုဖျက်ခြင်း ခံရလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","ယေသျှုသည် သံလွင်တောင်ထက်မှာ ထိုင်နိန်သောအခါ တပည့်တော်ရို့သည် တိတ်တဆိတ် လာတွိ့ကြပြီးလျှင် “ဤအရာအားလုံးသည် မည်သည့် အချိန်ခါတွင် ဖြစ်လာမည်ကိုလည်းကောင်း၊ ကိုယ်တော်ပြန်ကြွလာမည့် အချိန်နှင့် ကပ်ကာလကုန်ဆုံးချိန်ကို သိနိုင်ရန် ဇာပိုင် နိမိတ်လက္ခဏာတိ ဖြစ်လာမည် ကိုလည်းကောင်း အကျွန်ရို့အား မိန့်တော်မူပါ” ဟု မိန်းလျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ယေသျှုက “သင်ရို့သည် လိမ်လည်လှည့်ဖျားခြင်းကို မခံရစီရန် အထူးသတိပြုနိန်ကတ်ပါ။ ");
INSERT INTO rki_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","အကြောင်းမူကား လူများစွာရို့က ‘ငါသည် မေသျှိယဖြစ်၏’ ဟု ဆိုလျက် ငါ၏နာမဖြင့် ရောက်လာကြပြီးလျှင် လူများစွာတိကို လှည့်စားကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","သင်ရို့သည် စစ်ဖြစ်နိန်ကြသည့်အကြောင်းကိုလည်းကောင်း၊ စစ်ဖြစ်နိန်ကြကြောင်း ကောလာဟလသတင်းစကားတိကိုလည်းကောင်း ကြားကတ်ရလိမ့်မည်၊ သို့သော်လည်း စိုးရိမ်ထိန့်လန့်ခြင်း မဖြစ်ကြစီခြင်းငှာ သတိထားကြလော့။ ထိုသို့သောအရာများသည် ဖြစ်လာရမည်၊ သို့သော်လည်း နောက်ဆုံးအချိန်ကား မရောက်သိမ့်။ ");
INSERT INTO rki_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","လူတစ်မျိုးက တခြားလူမျိုးတစ်မျိုးကိုလည်းကောင်း နိုင်ငံတစ်နိုင်ငံက အခြားတစ်နိုင်ငံကိုလည်းကောင်း ရန်ပြုလာကြလိမ့်မည်။ နီရာများစွာ၌ ငတ်မွတ်ခေါင်းပါးခြင်း၊ မြီငလျှင်လှုပ်ခြင်းတိ ဖြစ်လာလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ဤအရာအားလုံးသည် သားဖွားခြင်းဝေဒနာ၏အစဦးသာ ဖြစ်သိမ့်၏။ ");
INSERT INTO rki_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“ထိုအခါ လူတိက သင်ရို့ကို နှိပ်စက်ညှဉ်းဆဲခြင်းငှာလည်းကောင်း၊ အသီသတ်ခြင်းငှာလည်းကောင်း အပ်နှံကြလိမ့်မည်။ ငါ့ကြောင့် သင်ရို့ကို လူမျိုးအားလုံးက မုန်းကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ထိုကာလ၌ လူအများသည် ယုံကြည်မှုလွဲမှားကာ အချင်းချင်း သစ္စာဖောက်လျက် မုန်းကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","မိစ္ဆာပရောဖက် များစွာ ပေါ်လာပြီး လူများစွာကို လှည့်ဖျားကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ဆိုးယုတ်မှုတိ များပြားလာသောကြောင့် မေတ္တာတရား ခေါင်းပါးလာလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","သို့သော်လည်း အဆုံးထိ အခိုင်အမာရပ်တည်သောသူသည် ကယ်တင်ခြင်းခံရလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","နိုင်ငံတော်နှင့်ပတ်သက်သော ဤသတင်းကောင်းကို လူမျိုးအပေါင်းရို့အား သက်သီခံ၍ တစ်ကမ္ဘာလုံး၌ ဟောပြောကတ်လိမ့်မည်။ ထို့နောက် ကပ်ကမ္ဘာကုန်ဆုံးချိန်သည် ရောက်လာလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“ထို့ကြောင့် ပရောဖက်ဒံယေလ ပြောခဖူးသည့် ပျက်စီးမှုကို ဖြစ်စီသော ‘ဆိုးရွားသည့် စက်ဆုပ်ရွံစာဖွယ်ရာ’ သည် သန့်ယှင်းမြင့်မြတ်သောနီရာ၌ ရောက်နိန်ကြသည်ကို မြင်ရလိမ့်မည်။” (ဇာကို ဆိုလိုသည်ကို ကျမ်းစာဖတ်သောသူသည် သေသေချာချာ နားလည်ကြစီ။) ");
INSERT INTO rki_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ထိုအခါ ယုဒပြည်မှာ ဟိသောသူတိ တောင်ထက်သို့ တက်ဗြီးကတ်လီ။ ");
INSERT INTO rki_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","အိမ်ခေါင်မိုးထက်မှာ ဟိသောသူတိ၊ အိမ်ထဲကပစ္စည်းတိကို ယူဖို့ ဆင်းမနိန်ကတ်ကေ့။ ");
INSERT INTO rki_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","လယ်ထဲမှာ ဟိသောသူသည် မိမိ၏ဝတ်ရုံကို ယူခြင်းငှာ ပြန်မလားစီကေ့။ ");
INSERT INTO rki_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","ထိုနိ့ရက်ကာလ၌ ကိုယ်ဝန်ဆောင်မိခင်နှင့် နို့စို့သူငယ်ဟိသော မိခင်ရို့အတွက် အလွန် ခက်ကတ်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","သင်ရို့၏ ထွက်ဗြီးရမည့်အချိန်သည် ဥပုသ်နိ့ သို့မဟုတ် ဆောင်းရာသီကာလမှာ မဖြစ်ဖို့ ဆုတောင်းကတ်။ ");
INSERT INTO rki_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ဤမျှလောက် ကြောက်စရာကောင်းသည့် ဒုက္ခကပ်ဆိုးကြီးသည်ကား ကမ္ဘာဦးအစကပင် ဂနိ့ထိတိုင်အောင် တစ်ခါမျှ မဖြစ်ဖူးခသိမ့်။ နောင်တွင်လည်း ဤကဲ့သို့ တစ်ခါမျှ ဖြစ်လိမ့်မည် မဟုတ်။ ");
INSERT INTO rki_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","သို့သော်လည်း ဤနိ့ရက်ကာလကို တိုတောင်းစီတော်မမူလျှင် တစ်ယောက်လည်း အသက်ရှင်ကတ်လိမ့်မည် မဟုတ်၊ ရွီးကောက်ထားသူတိအတွက် ဤကာလကို တိုတောင်းစီလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“ထိုကာလ၌ တစ်စုံတစ်ယောက်သောသူက ‘ကြည့်လော့၊ ဤအရပ်၌ မေသျှိယ ဟိ၏၊ ထိုအရပ်၌ မေသျှိယ ဟိ၏’ ဟု ပြောကြသော်လည်း ထိုစကားကို မယုံကတ်လီကေ့။ ");
INSERT INTO rki_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","အကြောင်းမူကား မေသျှိယအယောင်ဆောင်တိ၊ ပရောဖက်အယောင်ဆောင်တိ ပေါ်လာ၍ ဖြစ်နိုင်လျှင် ရွီးကောက်ထားသောသူတိကိုပင် လှည့်ဖျားနိုင်ခြင်းငှာ အံ့ဩဖွယ်ရာများ၊ ကြီးမားသောနိမိတ်လက္ခဏာများကို ပြကတ်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","ဤအချိန်မရောက်ခင် သင်ရို့အား ငါ ပြောထားခသောစကားတိကို နားထောင်ထားကတ်။ ");
INSERT INTO rki_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“လူတိက ‘မေသျှိယသည် တောထဲ၌ ပွင့်တော်မူနိန်ယာ’ ဟု ပြောကြသော်လည်း မလားကတ်လီကေ့။ ‘မေသျှိယသည် ဤအရပ်၌ လျှို့ဝှက်စွာ ကိန်းဝပ်နိန်တော်မူ၏’ ဟု ပြောကြသော်လည်း မယုံကတ်လီကေ့။ ");
INSERT INTO rki_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","အကြောင်းမူကား အရှိ့အရပ်မှ အနောက်အရပ်ထိ အာကာတစ်ပြင်လုံးကို ဖြတ်၍ လျှပ်ပြက်သကဲ့သို့ လူသားသည် ကြွလာတော်မူလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“အသီကောင်ဟိသောအရပ်၌ လင်းတငှက်တိ စုလာကတ်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“ဤဒုက္ခကပ်ဆိုးကြီးကာလ ကုန်ဆုံးလားပြီးနောက် မကြာခင်မှာ နီကို မိုက်လားစီပြီးလျှင် လသည် မိမိ၏အလင်းရောင်ကို ပီးလိမ့်မည် မဟုတ်။ ကြယ်တိသည် အာကာပြင်မှ ကြွီကျကြပြီးလျှင် ကောင်းကင်တန်ခိုးများကို တုန်လှုပ်စီလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","ထို့နောက် လူသား၏နိမိတ်လက္ခဏာသည် အာကာပြင်၌ ပေါ်ထွန်းလာလိမ့်မည်။ ကောင်းကင်တိမ်တိုက်များထက်တွင် ကြီးမြတ်သောဘုန်းတန်ခိုးတော်နှင့် ကြွလာတော်မူသော လူသားကို မြင်ကြသောအခါ မြီကြီးထက်၌ဟိသော လူမျိုးနွယ်စုအားလုံးသည် ဝမ်းနည်းကြီကွဲကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ထို့နောက် လူသားသည် ကျယ်လောင်သော တံပိုးမှုတ်သံဖြင့် သူ၏ကောင်းကင်တမန်များကို စီရွှတ်လိမ့်မည်၊ ထိုအခါ ကောင်းကင်တမန်များသည် မိမိရွီးကောက်ထားသောသူတိကို ကောင်းကင်တစ်ဖက်စွန်းမှ အခြားတစ်ဖက်စွန်းတိုင်အောင် အရပ်လေးမျက်နှာမှ စုသိမ်းကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“ဤအချိန်၌ သဖန်းပင်မှ ဤသင်ခန်းစာကို သင်ယူကြလော့။ ဤအပင်၏အကိုင်းအခက်များ နုလာ၍ အရွက်များထွက်လာသည်နှင့် နွီရာသီရောက်ခါနီးယာ ဆိုသည်ကို သင်ရို့ သိကတ်ပါ။ ");
INSERT INTO rki_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ထိုနည်းတူ သင်ရို့သည် ဤအရာအားလုံးကို မြင်တွိ့ကြရသောအခါ၌ လူသားသည် တန်းခါးဝတိုင်ယောင် အနီးသို့ ရောက်နိန်ယာ ဆိုသည်ကို သင်ရို့သိကတ်ပါ။ ");
INSERT INTO rki_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","သင်ရို့ကို ငါ အမှန်ဆိုသည်ကား အဂုအသက်ရှင်လျက်ဟိသောလူတိ မသီခင် ဤအရာများအားလုံးသည် ဖြစ်လာကြလိမ့်မည်ကို မှတ်ထားကြလော့။ ");
INSERT INTO rki_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ကောင်းကင်နှင့် မြီကြီး ပျောက်ကွယ်လားသော်လည်း၊ ငါ့စကားသည် တစ်ခါလည်း ကွယ်ပျောက်လားလိမ့်မည် မဟုတ်ချေ။ ");
INSERT INTO rki_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“သို့သော်လည်း ထိုနိ့ရက်ကာလနှင့် ပတ်သက်၍ ဇာသူလည်း မသိ — ကောင်းကင်တမန်များသော်လည်းကောင်း၊ သားတော်သော်လည်းကောင်း မသိကြ၊ သို့သော်လည်း အဖ တစ်ပါးတည်းသာ သိတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","လူသားကြွလာသောအခါတွင် နောဧလက်ထက်၌ ဖြစ်ခသကဲ့သို့ ဖြစ်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","အကြောင်းမူကား ရီလွှမ်းမိုးခြင်းမဖြစ်ခင် နိ့များ၌၊ နောဧသည် သင်္ဘောထဲသို့ ဝင်သည့်နိ့တိုင်အောင် လူများသည် စားသောက်လျက်၊ ထိမ်းမြားစုံဘက်ခြင်းကို ပြုလျက်နိန်ခကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ထိုအခါ ရီလွှမ်းမိုးခြင်းသည် ရောက်လာ၍ သူရို့အားလုံးကို သုတ်သင်ဖယ်ရှားလားသည့်တိုင်အောင် သူရို့သည် မည်သို့ ဖြစ်ခသည်ကို မသိခကတ်။ လူသားကြွလာသည့်အခါ၌ ထိုကဲ့သို့ ဖြစ်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","ထိုအချိန်တွင် လယ်တောထဲ၌ ဟိသောသူ နှစ်ယောက်တွင်၊ တစ်ယောက်ကို ယူလားပြီး တစ်ယောက်သည် ကျန်ခလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ဆန်ဖွတ်နိန်သော မိန်းမနှစ်ယောက်တွင်၊ တစ်ယောက်ကို ယူလားပြီး တစ်ယောက်သည် ကျန်ခလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“ထို့ကြောင့် သင်ရို့၏သခင်ဘုရားသည် ဇာနိ့မှာ ကြွလာမည်ကို မသိသောကြောင့် သင်ရို့သည် သတိနှင့် စောင့်ကြည့်နိန်ကြလော့။ ");
INSERT INTO rki_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","သူခိုးလာမည့်အချိန်ကို အိမ်သျှင် သိလျှင် သူသည် သတိနှင့် စောင့်ကြည့်နိန်သောကြောင့် ထိုသူခိုးသည် မိမိအိမ်ကို ဖောက်ထွင်းခွင့် ရလိမ့်မည် မဟုတ်ချေ။ ");
INSERT INTO rki_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","ထို့ကြောင့် သင်ရို့ မမျှော်လင့်သောအချိန်မှာ လူသားသည် ကြွလာမည်ဖြစ်၍ သင်ရို့သည်လည်း အဆင်သင့် ဖြစ်နိန်ကြရမည်။ ");
INSERT INTO rki_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“ထို့နောက် သခင်သည် မိမိအိမ်ထောင်စု၌ဟိသော အစီခံတိကို အချိန်တန်လျှင် သူရို့အတွက် စားနပ်ရိက္ခာများကို ပီးကမ်းရန် အအုပ်အချုပ် ခန့်ထားသည့် သစ္စာဟိ၍ ဉာဏ်အမြော်အမြင်နှင့် ပြည့်စုံသော အစီခံဟူသည်ကား ဇာသူလဲ။ ");
INSERT INTO rki_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ထိုအစီခံသည် သခင်ပြန်လာသောအခါ၌ ဤသို့ ပြုလျက်ဟိသည်ကို သခင်သည်တွိ့၏၊ ထိုအစီခံသည် မင်္ဂလာဟိလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","သင်ရို့ကို ငါ အမှန်ဆိုသည်ကား သခင်သည် ထိုအစီခံအား သူပိုင်ဆိုင်သောအရာအားလုံး၏ အအုပ်အချုပ်အဖြစ် ခန့်အပ်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","သို့ရာတွင် ဆိုးယုတ်သောအစီခံသည်ကား ငါ၏သခင် ပြန်လာရန် ကြာဖို့သိမ့်ဟု စိတ်ထင်ဖြင့်၊ ");
INSERT INTO rki_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","အရက်သမားတိနှင့် သောက်စားမူးယစ်ကာ မိမိ၏လက်အောက်ငယ်သားတိကို ထုထောင်းသတ်ပုတ်ရန် စတင်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","မိမိ မျှော်လင့်မထားသောနိ့ရက်၊ မိမိ သတိမထားမိသောအချိန်၌ ထိုအစီခံ၏သခင်ပြန်လာသောအခါ ");
INSERT INTO rki_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ထိုဆိုးယုတ်သောအစီခံကို ပြင်းထန်စွာ ပြစ်ဒဏ်ပီးပြီးနောက် သူတော်ကောင်းယောင်ဆောင်သောသူများနှင့်အတူ နီရာချလိမ့်မည်။ သူသည် ထိုနီရာ၌ အံကြိတ်၍ ငိုကျွီးနိန်ရလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“ထိုအခါ ကောင်းကင်နိုင်ငံတော်သည် မင်္ဂလာဆောင်သတို့သားကို ကြိုဆိုရန် မိမိရို့၏ဆီမီးခွက်များကို ယူဆောင်လျက် ထွက်လာကြသည့် အပျိုရံဆယ်ယောက်နှင့် တူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ထိုသူရို့ ထဲက ငါးယောက်သည် ပညာအမြော်အမြင် မဟိကြ။ ကျန်ငါးယောက်ကား ပညာအမြော်အမြင် ဟိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ပညာအမြော်အမြင် မဟိသောသူများသည် မိမိရို့၏ဆီမီးခွက်များကို ယူလာကြသော်လည်း မိမိရို့နှင့်အတူ ဆီကို မယူခကြ။ ");
INSERT INTO rki_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","သို့သော်လည်း ပညာအမြော်မြင်ဟိသောသူရို့သည် မိမိရို့နှင့်အတူ ဖန်ဘူးများဖြင့် ဆီကိုပါ ယူလာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","မင်္ဂလာဆောင်သတို့သားသည် အလာနောက်ကျနိန်သည်ဖြစ်၍ သူရို့အားလုံးသည် ငိုက်မျဉ်းကာ အိပ်ပျော်လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“ညဉ့်သန်းခေါင်ယံချိန်၌ ‘မင်္ဂလာဆောင်သတို့သား ရောက်လာယာ၊ ကြိုဆိုဖို့ ထွက်လာကတ်’ ဟု အော်ခေါ်သံကို ကြားလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","အပျိုရံအားလုံးသည် နိုးလာကြပြီး မိမိရို့၏ဆီမီးခွက်များကို ပျင်ဆင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ထိုအခါ ဉာဏ်အမြော်အမြင် မဟိသော သူရို့က ‘ငါ့ရို့မီးခွက် မီးသီလားခယာ၊ နင်ရို့ပါးက ငါ့ရို့ကို ဆီ ဆိတ်ကေချေလောက် ပီးကတ်ပါ’ ဟု ဉာဏ်အမြော်အမြင်ဟိသောသူရို့၌ တောင်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","ဉာဏ်အမြော်အမြင်ဟိသော သူရို့က ‘ငါရို့အတွက်ရော နင်ရို့အတွက်ပါဆိုကေ ဆီလောက်ဖို့ မဟုတ်၊ သို့ဖြစ်၍ နင်ရို့မှာ ဆီရောင်းသူရို့ပါးသို့ လားလို့ ဝယ်ကတ်ခီ’ ဟု ပြန်ပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","သို့ရာတွင် သူရို့သည် ဆီဝယ်ဖို့ လားနိန်စဉ်၊ မင်္ဂလာဆောင်သတို့သားသည် ရောက်လာ၏။ အဆင်သင့်ဖြစ်နိန်ကြသော အပျိုရံများသည် သူနှင့်အတူ မင်္ဂလာခန်းမထဲသို့ ဝင်ကြ၏၊ ပြီးနောက် တန်းခါးကို ပိတ်လိုက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“ထို့နောက် ဆီဝယ်လားကြသော သူရို့သည်လည်း ပြန်လာ၍ ‘ဆရာ၊ ဆရာ၊ အကျွန်ရို့ကို တန်းခါးဖွင့်ပီးပါ’ ဟု ပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","သို့သော် မင်္ဂလာဆောင်သတို့သားက ‘သင်ရို့ကို ငါ အမှန်ဆိုသည်ကား ငါသည် သင်ရို့ကို မသိ’ ဟု ပြန်ပြောလိုက်၏။” ");
INSERT INTO rki_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“ထို့ကြောင့် သင်ရို့သည် ထိုနိ့ရက်ကာလကို မသိကြသောကြောင့် သတိနှင့် စောင့်နိန်ကြလော့” ဟု မိန့်တော်မူလျက် ယေသျှုက ပုံပြင်ကို အဆုံးသတ်လိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“တဖန်၊ ကောင်းကင်နိုင်ငံတော်သည်ကား မိမိ၏အစီခံတိကို ခေါ်၍ မိမိဥစ္စာများကို အပ်နှံကာ ခရီးတစ်ခုသို့ ထွက်လားသော လူတစ်ယောက်နှင့် တူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ထိုသူက တစ်ယောက်ကို ရွှီဒင်္ဂါး အပြား ၅,၀၀၀၊ နောက်တစ်ယောက်ကို ၂,၀၀၀၊ နောက်တစ်ယောက်ကို ၁,၀၀၀ စသည်ဖြင့် တစ်ဦးစီတိုင်းအား မိမိရို့ စွမ်းရည်ဟိကြသည့်အတိုင်း ပီးအပ်ပြီး ခရီးထွက်လား၏။ ");
INSERT INTO rki_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","ရွှီဒင်္ဂါး ၅,၀၀၀ ရသောသူသည် ချက်ချင်း ထွက်လား၍ မိမိ၏ဥစ္စာကို အရင်းအနှီးလုပ်သဖြင့် ၅,၀၀၀ ထက်ပိုသော ရွှီဒင်္ဂါးများကို ရ၏။ ");
INSERT INTO rki_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ထိုနည်းတူ လုပ်ဆောင်သဖြင့် ရွှီဒင်္ဂါး ၂,၀၀၀ ရသောသူမှာလည်း ၂,၀၀၀ ထက်ပိုသော ရွှီဒင်္ဂါးများကို ရ၏။ ");
INSERT INTO rki_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","သို့ရာတွင် ဒင်္ဂါး ၁,၀၀၀ ရသောသူသည် ထွက်လားပြီးလျှင် မြီကြီးထဲမှာ တွင်းတူး၍ သူ့သခင်၏ဒင်္ဂါးတိကို မြှုပ်ထားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“ကာလအတန်ကြာပြီးနောက် သူရို့၏သခင်သည် ပြန်ရောက်လာ၍ သူရို့နှင့် စာရင်းယှင်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ရွှီဒင်္ဂါးငါးထောင်ရသောသူသည် နောက်ထပ် ၅,၀၀၀ ကိုပါ ယူလာခပြီးလျှင် ‘သခင် သင်သည် အကျွန်အား ရွှီဒင်္ဂါး ၅,၀၀၀ ကို ပီးအပ်ခ၏၊ ကြည့်ပါ၊ အကျွန်သည် ၅,၀၀၀ ထက်ပို၍ အမြတ်ရထားပြီးဖြစ်၏’ ဟု ပြော၏။ ");
INSERT INTO rki_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","သခင်က ‘ကောင်းယာ၊ သင်သည် သစ္စာဟိသော အစီခံကောင်းတစ်ယောက် ဖြစ်၏၊ သင်သည် အနည်းငယ်သောအရာ၌ သစ္စာဟိခ၏၊ များစွာသောအရာတိကို စီမံခန့်ခွဲသူအဖြစ် သင့်အား ငါ ခန့်အပ်မည်၊ မိမိသခင်၏ချမ်းသာသုခကို လာ၍ ခံစားလော့’ ဟု သခင်က ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“ရွှီဒင်္ဂါး ၂,၀၀၀ ရသောသူသည်လည်း ရောက်လာပြီးလျှင် ‘သခင်၊ သင်သည် အကျွန်အား ရွှီဒင်္ဂါး ၂,၀၀၀ ကို ပီးအပ်ခ၏၊ ကြည့်ပါ၊ အကျွန်သည် ၂,၀၀၀ ထက်ပို၍ အမြတ်ရထားပြီးဖြစ်၏’ ဟု ပြော၏။ ");
INSERT INTO rki_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","‘ကောင်းယာ၊ သင်သည်လည်း သစ္စာဟိသော အစီခံကောင်းတစ်ယောက် ဖြစ်၏။ သင်သည် အနည်းငယ်သောအရာ၌ သစ္စာဟိခသောကြောင့် များစွာသောအရာတိကို စီမံခန့်ခွဲသူအဖြစ် သင့်အား ငါ ခန့်ထားမည်၊ မိမိသခင်၏ချမ်းသာသုခကို လာ၍ ခံစားလော့’ ဟု သခင်က ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“ထို့နောက် ဒင်္ဂါး ၁,၀၀၀ ရသော သူသည်လည်း ရောက်လာပြီး ‘သခင်၊ သခင်သည် မိမိမျိုးစိ့မချသော မြီ၌ သီးနှံကို ရိတ်တတ်သော၊ မိမိမျိုးစိ့မကြဲသော မြီ၌ သီးနှံကို စုသိမ်းတတ်သော အလွန် ခက်ထန်သည့် သူတစ်ယောက် ဖြစ်သည်ကို အကျွန် သိပါ၏။ ");
INSERT INTO rki_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ထို့ကြောင့် အကျွန်သည် သခင့်ကိုကြောက်၍ သခင်၏ရွှီဒင်္ဂါးတိကို မြီကြီးထဲမှာ ဝှက်ထားခပါ၏။ ကြည့်ပါ၊ ဤကား သခင့်ဥစ္စာဖြစ်၏’ ဟု ဆိုလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“သူ၏သခင်က ‘ဆိုးယုတ်ပျင်းရိသော ကျွန်၊ ငါသည် မိမိမျိုးစိ့မချသော မြီ၌ သီးနှံကို ရိတ်တတ်သော၊ မိမိမျိုးစိ့မကြဲသော မြီ၌ သီးနှံများကို စုသိမ်းတတ်သော သူတစ်ယောက်ဖြစ်သည်ဟု သင် သိသလော။ ");
INSERT INTO rki_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ဟုတ်ယာ၊ ယင်းပိုင်ဆိုကေ ငါ ပြန်လာသည့်အခါ ဘဏ်တိုးသော်လည်း ရစီခြင်းငှာ သင်သည် ငါ့ဒင်္ဂါးများကို ဘဏ်၌ အပ်ထားသင့်၏။ ");
INSERT INTO rki_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","အဂုပင်လျှင် သူ့ပါးက ဒင်္ဂါးများကို ယူ၍ ဒင်္ဂါး ၁၀,၀၀၀ ရသောသူကို ပီးလိုက်ကတ်။ ");
INSERT INTO rki_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","အကြောင်းမူကား ရတတ်သောသူကို သာ၍ ပီးလိမ့်မည်၊ ထို့နောက် သူသည် ကြွယ်ဝပြည့်စုံခြင်း ဟိလိမ့်မည်။ မရတတ်သောသူပါးက ထိုသူ၌ ဟိသမျှကိုပင် နုတ်ယူလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ထို့ကြောင့် အသုံးမကျသော ထိုအခိုင်းအစီကို အပြင်ဘက် မှောင်မိုက်ထဲသို့ နှင်ထုတ်ပစ်လိုက်ကတ်၊ သူသည် ထိုနီရာ၌ အံကြိတ်၍ ငိုကျွီးနိန်ရလိမ့်မည်’ ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“လူသားသည် ကောင်းကင်တမန်အားလုံးနှင့်အတူ မိမိ၏ဘုန်းတန်ခိုးတော်ဖြင့် ကြွလာတော်မူသောအခါ၊ မိမိ၏ ဘုန်းတော်နှင့်ပြည့်စုံတော်မူသော ပလ္လင်တော်ထက်၌ စိုးစံတော်မူလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","လူမျိုးအပေါင်းရို့သည် ကိုယ်တော်၏ရှိ့တော်၌ စုရုံးရကြလိမ့်မည်။ ထို့နောက် သိုးထိန်းသည် ဆိတ်များထဲက သိုးများကို ခွဲထုတ်သကဲ့သို့ ကိုယ်တော်သည် လူတိကို အုပ်စုနှစ်ခု ခွဲခြားတော်မူလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ကိုယ်တော်သည် ဖြောင့်မတ်သောသူတိကို မိမိ၏လက်ယာဘက်၌လည်းကောင်း၊ တခြားသူများကို လက်ဝဲဘက်၌လည်းကောင်း ထားတော်မူလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","ထို့နောက် သျှင်ဘုရင်က မိမိ၏လက်ယာဘက်၌ ဟိသောသူများကို ‘ငါ့အဖ ကောင်းချီးပီးခြင်းကို ခံရသောသူအပေါင်းရို့၊ လောကကို ဖန်ဆင်းကတည်းက သင်ရို့အတွက် ပျင်ဆင်ထားသော နိုင်ငံတော်၏အမွီကို လာ၍ ယူကြလော့။ ");
INSERT INTO rki_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","အကြောင်းမူကား ငါသည် ဝမ်းဆာသောအခါ သင်ရို့သည် ငါ့အား စားစရာကို ပီးခကြ၏။ ငါသည် ရီသောက်ငတ်သောအခါ သင်ရို့သည် ငါ့အား သောက်စရာကို ပီးခ၏။ ငါသည် အာဂန္တု ဖြစ်နိန်ခစဉ်က သင်ရို့သည် ငါ့ကို ခေါ်ဖိတ်လက်ခံကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ငါသည် အဝတ်လိုအပ်သောအခါ၊ သင်ရို့သည် ငါ့အား အဝတ်ကို ဝတ်ပီးခကြ၏၊ ငါ ဖျားနာနိန်စဉ်က သင်ရို့သည် ငါ့အား ပြုစုစောင့်ယှောင့်ကြ၏။ ငါသည် ထောင်ကျခံနိန်ရစဉ်က သင်ရို့သည် ငါ့ကို လာတွိ့ကြ၏။’ ");
INSERT INTO rki_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“ထိုအခါ ဖြောင့်မတ်သောသူရို့က ‘အသျှင်ဘုရား၊ အကျွန်ရို့သည် ဇာအချိန်အခါ၌ အသျှင်ဘုရား ဝမ်းဆာနိန်သည်ကို မြင်၍ ကျွေးမွီးခပါလဲ။ ဇာအချိန်အခါ၌ အသျှင်ဘုရား ရီသောက်ငတ်နိန်သည်ကို မြင်၍ သောက်စရာကို ပီးဖူးခပါလဲ။ ");
INSERT INTO rki_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ဇာအချိန်အခါ၌ အသျှင်ဘုရား ဧည့်သည် ဖြစ်နိန်ခသည်ကို မြင်၍ အကျွန်ရို့သည် ကိုယ်တော့်ကို ဖိတ်ခေါ်ခပါလဲ။ ဇာအချိန်အခါ၌ အသျှင်ဘုရား အဝတ် လိုအပ်သည်ကို မြင်၍ အကျွန်ရို့သည် ကိုယ်တော့်ကို အဝတ် ဝတ်ပီးခပါလဲ။ ");
INSERT INTO rki_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ဇာအချိန်အခါ၌ အသျှင်ဘုရား ဖျားနာနိန်ခသည်ကိုလည်းကောင်း၊ ထောင်ကျနိန်ခသည်ကိုလည်းကောင်း ကျွန်ရို့သည် မြင်၍ လာတွိ့ဖူးပါလဲ’ ဟု လျှောက်ကြသောအခါ ");
INSERT INTO rki_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","သျှင်ဘုရင်က ‘သင်ရို့ကို ငါ အမှန် ဆိုသည်ကား၊ ဤသို့သော ငါ၏ညီအစ်ကို မောင်နှမတိထဲက အငယ်ဆုံးသောသူတစ်ယောက်ကို ပြုစုခြင်းသည် ငါ့အား ပြုစုခြင်းဖြစ်၏’ ဟု မိန့်တော်မူလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“ထို့နောက် မိမိ၏လက်ဝဲဘက်မှာ ဟိသောသူတိကိုကား၊ ‘ကျိန်ခြင်းကို ခံရသောသူရို့ ငါ့အနားက ထွက်လားကတ်။ သင်ရို့သည် မာရ်နတ်နှင့် သူ၏စီတမန်များအတွက် ပျင်ဆင်ထားသော ထာဝရမီးအိုင်ထဲသို့ ဆင်းကြလော့။ ");
INSERT INTO rki_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","အကြောင်းမူကား ငါသည် ဝမ်းဆာနိန်စဉ်က သင်ရို့သည် ငါ စားဖို့ တစ်ခုလည်း မပီးခကတ်၊ ငါသည် ရီသောက်ငတ်နိန်စဉ်က ငါ့အား သောက်စရာကို မပီးခကက်၊ ");
INSERT INTO rki_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ငါသည် အာဂန္တု ဖြစ်နိန်ခစဉ်က သင်ရို့သည် ငါ့ကို မဖိတ်ခေါ်ခကတ်၊ ငါသည် အဝတ် လိုအပ်နိန်န်စဉ်က သင်ရို့သည် ငါ့ကို အဝတ် ဝတ်မပီးခကတ်၊ ငါသည် ဖျားနာနိန်စဉ်ကသော်လည်းကောင်း ထောင်ကျခံနိန်စဉ်ကသော်လည်းကောင်း သင်ရို့သည် ငါ့အား မပြုစုခကတ်ပါကား။’ ");
INSERT INTO rki_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“သူရို့ကလည်း ‘အသျှင်ဘုရား အကျွန်ရို့သည် ဇာအချိန်အခါ၌ ကိုယ်တော် ဝမ်းဆာနိန်ခသည်ကိုလည်းကောင်း၊ ရီသောက်ငတ်နိန်ခသည်ကိုလည်းကောင်း၊ အာဂန္တုဖြစ်နိန်ခသည်ကိုလည်းကောင်း၊ အဝတ်လိုအပ်နိန်ခသည်ကိုလည်းကောင်း၊ ဖျားနာနိန်ခသည်ကိုလည်းကောင်း၊ ထောင်ချခံထားရသည်ကိုလည်းကောင်း အကျွန်ရို့သည် မြင်၍ မပြုစုခပါလဲ’ ဟု ပြန်၍ လျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ထိုအခါ မင်းကြီးက ‘သင်ရို့ကို ငါ အမှန် ဆိုသည်ကား ဤသို့သော ငါ၏ညီအစ်ကို မောင်နှမများထဲက အငယ်ဆုံးသောသူတစ်ယောက်ကို မပြုစုခခြင်းသည် ငါ့ကို မပြုစုခခြင်းဖြစ်၏’ ဟု ပြန်၍ မိန့်တော်မူလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","ထို့ကြောင့် ဤသူရို့သည် ထာဝရပြစ်ဒဏ်စီရင်ခြင်းသို့ ရောက်ကြလိမ့်မည်၊ သို့သော်လည်း ဖြောင့်မတ်သောသူရို့သည် ထာဝရအသက်ရှင်ခြင်းသို့ ရောက်ကြလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ယေသျှုသည် အလုံးစုံသော ဤတရားတော်များကို ဟောပြောပြီးသောအခါ၊ ကိုယ်တော်က မိမိ၏တပည့်တော်ရို့အား ");
INSERT INTO rki_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“သင်ရို့သိကြသည့်အတိုင်း နောက်နှစ်ရက်ကြာလျှင် ပသခါပွဲတော် ကျင်းပကြမည်။ လူသားကို လက်ဝါးကပ်တိုင်မှာတင်၍ သတ်ခြင်းငှာ အပ်နှံကြလိမ့်မည်၏” ဟု မိန့်တော်မူခ၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ထို့နောက်တွင် ယဇ်ပုရောဟိတ်အကြီးအကဲရို့နှင့် လူရို့၌ အကြီးအကဲရို့သည် ယဇ်ပုရောဟိတ်မင်းကြီး ကယာဖ၏ အိမ်ဝင်းထဲ၌ စုရုံးကာ ");
INSERT INTO rki_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ယေသျှုကို လျှို့ဝှက်စွာ ဖမ်းဆီး၍ သတ်ပစ်ရန် စီစဉ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","သို့သော်လည်း “ပသခါပွဲတော်ရက်အတွင်းမှာ မလုပ်ကတ်ကေ့။ ထိုသို့ပြုလျှင် လူတိက ရုံးရင်းဆန်ခတ်ဖြစ်ကတ်လိမ့်မည်” ဟူ၍ တိုင်ပင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ယေသျှုသည် ဗေသနိရွာ၌ နူနာရောဂါဖြစ်ခဖူးသော သျှိမုန်၏ အိမ်၌ ဟိတော်မူစဉ်၊ ");
INSERT INTO rki_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ကိုယ်တော်သည် အစားအစာကို သုံးဆောင်နိန်သောအခါ၊ မိန်းမတစ်ယောက်သည် အလွန်တန်ဖိုးကြီးသည့် ဆီမွှီးကို ဖြည့်ထားသော ကျောက်ဖြူအိုးတစ်လုံးကို ကိုယ်တော်ပါးသို့ ယူလာကာ ကိုယ်တော်၏ဦးဂေါင်းကို ထိုဆီမွှီးနှင့် လောင်း၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ထိုသို့ ပြုသည်ကို တပည့်တော်ရို့ မြင်ကြသောအခါ၊ မခံမရပ်နိုင်ဖြစ်လျက် “ဇာဖြစ်လို့ အေပိုင် ဖြုန်းတီးနိန်လဲ၊ ");
INSERT INTO rki_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ဤဆီမွှီးကို အဖိုးများစွာနှင့် ရောင်း၍ ဒင်္ဂါးများကို ဆင်းရဲသားတိအား ပီးသင့်၏” ဟု ပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","သူ၏တပည့်တိ ပြောနိန်ကြသည်ကို သိတော်မူသောအခါ ယေသျှုက “သင်ရို့သည် ဤမိန်းမကို ဇာကြောင့် စိတ်အနှောက်အယှက်ဖြစ်အောင် လုပ်နိန်ကတ်လဲ။ သူသည် ငါ့အား ကောင်းသောအမှုကို ပြုခြင်း ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","ဆင်းရဲသားတိကား သင်ရို့နှင့် အမြဲတမ်း ဟိကြမည်။ ငါသည်ကား သင်ရို့နှင့် အမြဲဟိလိမ့်မည် မဟုတ်။ ");
INSERT INTO rki_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ဤမိန်းမသည် ဤဆီမွှီးကို ငါ၏ခန္ဓာမှာ သွန်းလောင်းခြင်းသည် ငါ့ကို သင်္ဂြိုဟ်ခြင်းငှာ ပျင်ဆင်ခြင်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","သင်ရို့ကို ငါ အမှန် ဆိုသည်ကား ကမ္ဘာမြီကြီးအနှံ ဤသတင်းကောင်းကို ဟောကြားသော နီရာတိုင်း၌ ဤမိန်းမကို အောက်မိ့သတိရခြင်းဖြင့် သူပြုခသောအရာများကိုလည်း ပြောကြားရလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ထိုအခါ တပည့်တော် ဆယ့်နှစ်ယောက်ထဲက တစ်ယောက်ဖြစ်သော ယုဒသျှာကာရုတ်သည် ယဇ်ပုရောဟိတ်ကြီးအကဲတိပါးသို့ လားပြီးလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“ယေသျှုကို သင်ရို့လက်ထဲသို့ အပ်မည်ဆိုလျှင် သင်ရို့သည် အကျွန့်ကို ဇာလောက် ပီးပါဖို့လဲ” ဟု မိန်း၏။ ယဇ်ပုရောဟိတ်အကြီးအကဲတိက ငွီဒင်္ဂါး အပြားသုံးဆယ် သတ်မှတ်ပီးကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ထိုအချိန်မှစ၍ ယုဒသည် ယေသျှုကို အပ်နှံရန် အခွင့်ကောင်းကို စောင့်ကြည့်နိန်၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","တဆီးမပါသောမုန့်ဖြင့် ပွဲတော်တည်ရသော ပွဲတော်၏ပထမနိ့တွင် တပည့်တော်တိသည် အသျှင်ယေသျှုထံပါးသို့ ရောက်လာကြပြီး “ကိုယ်တော်သည် ပသခါပွဲ သုံးဆောင်ခြင်းငှာ အကျွန်ရို့ကို ဇာအရပ်၌ ပျင်ဆင်လိုပါလဲ” ဟု မိန်းလျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ကိုယ်တော်က “မြို့ထဲသို့ဝင်၍ စိတ်ချရသောသူတစ်ယောက်ပါးကို လားပြီး ‘ဆရာက မိန့်မှာလိုက်သည်မှာ၊ ငါ၏သတ်မှတ်ထားသောအချိန် ရောက်ခါနီးယာ၊ ငါသည် သင်၏အိမ်၌ ငါ၏တပည့်တိနှင့် ပသခါပွဲတော်ကို ကျင်းပမည်’ ဟူ၍ပြော” ဟု ပြန်၍ မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ထို့ကြောင့် ယေသျှု ညွှန်ကြားလိုက်သည့်အတိုင်း တပည့်တော်ရို့သည် ပသခါပွဲကို ပျင်ဆင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ညစာဘက်ရောက်သည့်အခါ ယေသျှုသည် တပည့်တော် ဆယ့်နှစ်ယောက်နှင့်အတူ စားပွဲနား၌ ထိုင်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","သူရို့သည် စားနိန်ကြစဉ်တွင် ကိုယ်တော်က “သင်ရို့ကို ငါ အမှန်ဆိုသည်ကား၊ သင်ရို့ထဲက တစ်ယောက်သည် ငါ့အား သစ္စာဖောက်လိမ့်မယ်” ဟု ပြော၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","တပည့်တော်တိသည် အလွန် စိတ်မချမ်းမသာဖြစ်ကြပြီး “အသျှင်ဘုရား၊ ကိုယ်တော်သည် အကျွန့်ကို ဆိုလိုခြင်း မဟုတ်သည်မှာ သေချာပါ၏လော” ဟု တစ်ယောက်ပြီး တစ်ယောက် ကိုယ်တော့်ကို မိန်းလျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ယေသျှုက “ဤခွက်၌ ငါနှင့်အတူ လက်ဆုံကျသောသူသည် ငါ့ကို သစ္စာဖောက်မည့်သူ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","လူသားသည် ကျမ်းစာ ပြောသည့်အတိုင်း လားရလိမ့်မည်။ သို့သော်လည်း လူသားကို သစ္စာဖောက်သောသူသည်ကား အမင်္ဂလာဟိ၏။ ထိုသူကို မမွီးဖွားလျှင် သာ၍ ကောင်းလိမ့်မည်” ဟု ပြန်၍ မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ထိုအချိန်တွင် ကိုယ်တော့်ကို သစ္စာဖောက်မည့်သူတစ်ယောက်ဖြစ်သော ယုဒက “အသျှင်ဘုရား၊ ကိုယ်တော်သည် အကျွန့်ကို ဆိုလိုခြင်း မဟုတ်သည်မှာ သေချာပါ၏လော” ဟု မိန်းလျှောက်၏။ ယေသျှုက “သင်ပြောသည့်အတိုင်း ဖြစ်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","သူရို့သည် စားနိန်ကြစဉ်တွင်၊ ယေသျှုသည် မုန့်ကို ယူ၍ ကျေးဇူးတော် ချီးမွမ်းပြီးမှ ထိုမုန့်ကို ဖဲ့ပြီးလျှင် “ဤမုန့်ကား ငါ၏ခန္ဓာကိုယ် ဖြစ်၏၊ ယူ၍ စားကြလော့” ဟု ပြောလျက် မိမိ၏တပည့်တော်တိကို ပီး၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ထို့နောက် ကိုယ်တော်သည် ခွက်ကို ယူ၍ ကျေးဇူးတော်ချီးမွမ်းပြီးမှ “သင်ရို့ အားလုံးသည် ဤခွက်ကို သောက်ကြလော့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","“ဤသည်ကား အပြစ်များမှ လွတ်ခြင်းငှာ လူအများကို သွန်းလောင်းသည့် ပဋိညာဉ်တရားနှင့်ဆိုင်သောငါ၏သွီး ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","သင်ရို့ကို ငါဆိုသည်ကား ငါသည် ငါ့အဖ၏နိုင်ငံတော်၌ သင်ရို့နှင့်အတူ အသစ်သောစပျစ်ရည်ကို သောက်ရသောနိ့တိုင်အောင် အဂုမှစ၍ ဤစပျစ်ရည်ကို နောက်တစ်ခါ မသောက်ရယာ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ထို့နောက် သူရို့သည် ဓမ္မတေးခြင်းတစ်ပုဒ် ဆိုပြီးမှ သံလွင်တောင်သို့ တက်လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","ယေသျှုက တပည့်တော်ရို့ကို မိန့်တော်မူသည်မှာ၊ “ ‘ငါသည် သိုးထိန်းကို သတ်၍ သိုးများကို သိုးအုပ်ထဲမှ ကွဲလားစီလိမ့်မည်’ ဟု ကျမ်းစာပြောထားသည့်အတိုင်း၊ ဤနိ့ည၌ပင် သင်ရို့အားလုံးသည် ငါ့ကို ထားခပြီးလျှင် ထွက်ဗြီးလားကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","သို့သော်လည်း ငါသည် သီခြင်းက ထမြောက်ပြီးနောက် ဂါလိလဲပြည်သို့ သင်ရို့ရှိ့က ရောက်နိန်လိမ့်မည်” ဟူ၍ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ပေတရုက “အားလုံးသောသူရို့သည် ကိုယ်တော့်ကို ထား၍ ထွက်ဗြီးလားကြသော်လည်း အကျွန်သည် လုံးဝ ထွက်မဗြီးပါ” ဟု ပြန်၍ လျှောက်၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ယေသျှုက “သင့်ကို ငါ အမှန် ဆိုသည်ကား၊ ဤနိ့ည ကြက်မတွန်ခင် သင်သည် ငါ့ကို သုံးကြိမ် ငြင်းလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","သို့ရာတွင် ပေတရုက “အကျွန်သည် ကိုယ်တော်နှင့်အတူ သီရမည်ဟု ဆိုလျှင်တောင်မှ ကိုယ်တော့်ကို လုံးဝ ငြင်းမည် မဟုတ်ပါ” ဟု ဆို၏။ ထို့နောက် အခြားသော တပည့်တော်တိကလည်း ထိုနည်းတူ ပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","ထိုအခါ ယေသျှုသည် တပည့်တော်တိနှင့်အတူ ဂေသယျှေမန် ဟု ခေါ်သော ဥယျာဉ်သို့ ရောက်တော်မူ၏။ ကိုယ်တော်က “ငါသည် ထိုနီရာသို့ လား၍ ဆုတောင်းနိန်စဉ်၊ သင်ရို့ ဤနီရာ၌ ထိုင်နိန်ကတ်” ဟု မိန့်တော်မူပြီး၊ ");
INSERT INTO rki_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ပေတရုနှင့် ဇေဗေဒဲသားနှစ်ယောက်ကို သူနှင့်အတူ ခေါ်လား၏။ ကိုယ်တော်သည် ဝမ်းနည်းခြင်းနှင့် စိတ်ပူပန်ခြင်းသို့ ရောက်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ထိုအခါ ကိုယ်တော်က “ငါ၏စိတ်နှလုံးထဲ၌ သီဖို့လောက် ဝမ်းနည်းလျက် ဟိ၏၊ ဤနီရာက နီ၍ ငါ့ကို စောင့်နိန်ကတ်” ဟု သူရို့ကို မိန့်တော်မူ၍၊ ");
INSERT INTO rki_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ရှိ့သို့ အနည်းငယ်ကြွတော်မူပြီး၊ ပြပ်ဝပ်လျက်၊ “အကျွန်၏အဖ၊ ဖြစ်နိုင်မည်ဆိုလျှင် ဤခွက်ကို အကျွန့်ပါးက ဖယ်ယှားပီးတော်မူပါ။ သို့သော်လည်း အကျွန်၏အလိုအတိုင်း မဖြစ်စီဘဲ၊ ကိုယ်တော်၏အလိုတော်အတိုင်းသာ ဖြစ်စီတော်မူပါ” ဟု ဆုတောင်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ပြီးလျှင် ကိုယ်တော်သည် မိမိ၏တပည့်တော်တိအပါးသို့ ပြန်လာသောအခါ သူရို့ကို အိပ်ပျော်လျက် တွိ့၏။ ထိုအခါ ကိုယ်တော်က ပေတရုအား “သင်ရို့သည် တစ်နာရီလောက်တောင်မှ ငါ့ကို မစောင့်နိုင်ကတ်ပါကား” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","ကိုယ်တော်က “စုံစမ်းခြင်းထဲသို့ မကျရောက်စီခြင်းငှာ ဆုတောင်း၍ စောင့်နိန်ကတ်။ စိတ်အလိုသို့ ကိုယ်မလိုက်နိုင်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ကိုယ်တော်သည် ဒုတိယအကြိမ် ထွက်ကြွတော်မူပြီးလျှင် “အကျွန်၏အဖ၊ အကျွန်မသောက်ဘဲ ဤခွက်ကို ဖယ်ယှားပီးခြင်းငှာ မဖြစ်နိုင်လျှင်၊ ကိုယ်တော်၏အလိုတော် ပြည့်စုံတော်မူပါစီသောဝ်” ဟု ဆုတောင်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ကိုယ်တော်သည် ပြန်လာသောအခါ တပည့်တော်ရို့ သည် မိမိရို့၏မျက်စိလေးလံသဖြင့် သူရို့သည် အိပ်ပျော်နိန်ကြသည်ကို တဖန် တွိ့ရပြန်၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ထို့ကြောင့် ကိုယ်တော်သည် သူရို့ကို ထားခပြီး နောက်တဖန်လား၍ မိမိတောင်းခသည့်အတိုင်း တတိယအကြိမ် ဆုတောင်းပြန်၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ထို့နောက် ကိုယ်တော်သည် တပည့်တော်ရို့ပါးသို့ ပြန်လာ၍ “သင်ရို့သည် အိပ်စက်နားခိုနိန်ကတ်တုန်းလား။ ကြည့်လော့၊ လူသားကို အပြစ်သားတိလက်သို့ အပ်နှံရန် အချိန်ရောက်လာယာ။ ");
INSERT INTO rki_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ကြည့်လော့၊ ငါ့ကို သစ္စာဖောက်သောသူသည် ဤနီရာသို့ ရောက်လာယာ။ ထကတ်၊ လားကတ်မေ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ကိုယ်တော် စကားပြောနိန်စဉ်မှာပင်၊ တပည့်တော် တစ်ဆယ့်နှစ်ယောက်ထဲက တစ်ယောက်ဖြစ်သည့် ယုဒသျှကာရုဒ်သည် ယဇ်ပုရောဟိတ်အကြီးအကဲတိနှင့် လူ့အဖွဲ့အစည်းခေါင်းဆောင်တိက ရွှတ်လိုက်သော တုတ်၊ ဓါး ကိုင်ဆောင်ထားသည့် လူအုပ်ကြီးနှင့်အတူ ရောက်လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ဤအချိန်၌ သစ္စာဖောက်သောသူက “ငါ နမ်းသောသူသည် ထိုသူ ဖြစ်၏။ သူကို ဖမ်းကြလော့” ဟု သူရို့နှင့် စီစဉ်ထားသည့် အမှတ်အသား အတိုင်း၊ ");
INSERT INTO rki_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ချက်ချင်း ယေသျှုပါးသို့ ရောက်လာ၍ ယုဒက “အသျှင်ဘုရား၊ သာလီစွပါ” ဟု နှုတ်ဆက်ပြီး ကိုယ်တော့်ကို နမ်း၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ယေသျှုက “မိတ်ဆွီ၊ သင်လာရင်းကိစ္စကိုသာ လုပ်ပါ” ဟု မိန့်တော်မူ၏။ ထိုအခါ ထိုလူများသည် ရှိ့သို့တိုးလာပြီး၊ ကိုယ်တော့်ကို ချုပ်ကိုင်ကာ ဖမ်းဆီးကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ထိုစဉ် ယေသျှု၏အပေါင်းအဖော်များထဲမှ တစ်ယောက်က မိမိဓါးကို ဆွဲထုတ်ကာ ယဇ်ပုရောဟိတ်အကြီးအကဲ၏ကျွန်တစ်ယောက်ကို ခွတ်လိုက်သဖြင့် သူ၏နားရွက်သည် ပြတ်ထွက်လား၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","“သင်၏ဓါးကို ဓါးနီရာမှာ ထားလိုက်။ ဓါးကို အသုံးပြုသောသူသည် ဓါးနှင့် သီရလိမ့်မည်” ဟု ယေသျှုက တားမြစ်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","ငါ၏အဖသည် ငါ့ကို ကူညီခြင်းငှာ တပ်ကြီး ဆယ့်နှစ်တပ်ထက် များပြားသော ကောင်းကင်တမန်တပ်ကြီးကို ချက်ချင်း ရွှတ်လိုက်မည်အကြောင်း ငါ မတောင်းနိုင်ဟု သင်ရို့ ထင်ကတ်လား။ ");
INSERT INTO rki_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","ထိုသို့ဆိုလျှင် ဤသို့ဖြစ်ရမည်ဟု မိန့်တော်မူထားသော သမ္မာကျမ်းစာသည် ဇာပိုင် ပြည့်စုံခြင်းသို့ ရောက်လိမ့်မည်နည်း။ ");
INSERT INTO rki_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ထိုအချိန်တွင် ယေသျှုသည် လူအုပ်ကြီးကို မိန့်တော်မူသည်မှာ “သင်ရို့သည် ငါ့အား ဓါးပြ တစ်ယောက်ကို ဖမ်းသကဲ့သို့ တုတ်၊ ဓါး၊ လက်နက်များ ကိုင်ဆောင်လျက် ဖမ်းဆီးရန် ရောက်လာကြသလော။ ငါသည် နိ့တိုင်း ဗိမာန်တော်၌ ထိုင်လျက် သွန်သင်ဆုံးမနိန်သောအခါ သင်ရို့ ငါ့ကို လာ၍ မဖမ်းကတ်ပါကား။ ");
INSERT INTO rki_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","ဤသို့ ဖြစ်ရခြင်းမှာ ပရောဖက်တိ ရီးထားခသည့်ကျမ်းစာ ပြည့်စုံလာခြင်းဖြစ်၏။” ထိုအခါ တပည့်တော်တိသည် ကိုယ်တော့်ကို စွန့်ခွါ၍ ထွက်ဗြီးလားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ထိုသူရို့သည် ယေသျှုကို ဖမ်းဆီး၍ ဘာသာရေးခေါင်းဆောင်များ၊ ကျမ်းတတ်ဆရာများ စုရုံးလျက်ဟိသော ယဇ်ပုရောဟိတ်မင်း ကယာဖ၏အိမ်သို့ ခေါ်ဆောင်လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ပေတရုသည် ယဇ်ပုရောဟိတ်မင်း၏အိမ်တော်ဝင်းခြံပေါက်ဝထိ၊ မျက်စိတစ်မြင်အကွာကနီ၍ လိုက်လာပြီးလျှင် အမှု၏အဆုံးကိုသိလိုသဖြင့် အိမ်တော်ဝင်းအတွင်းသို့ဝင်၍ ကိုယ်ရံတော်တပ်သားတိနှင့်အတူ ထိုင်နိန်၏ ");
INSERT INTO rki_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ယဇ်ပုရောဟိတ်မင်းများနှင့် ယုဒတရားလွှတ်တော် အဖွဲ့ဝင်အားလုံးက ယေသျှုကို သီဒဏ်ပီးနိုင်အောင် မမှန်သောသက်သီများကို ကြိုးစား၍ ရှာကြံထားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ထိုသို့ မမှန်သောသက်သီများဖြင့် ကြိုးစား၍ အပြစ်ရှာကြသော်လည်း အပြစ်တစ်စုံတစ်ခုချေမျှ မတွိ့ကြချေ။ နောက်ဆုံး၌ လူနှစ်ယောက် ထွက်လာပြီးလျှင် ");
INSERT INTO rki_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“ဤသူကား ‘ငါသည် ဘုရားသခင်ဗိမာန်တော်ကို ဖြိုချ၍ သုံးရက်အတွင်းမှာ ပြန်ဆောက်နိုင်သည်’ ဟု ပြောသောသူဖြစ်၏” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ထိုအခါ ယဇ်ပုရောဟိတ်မင်းတစ်ယောက်က ထ၍ “ဤသူရို့က သင့်ကို ဤသို့သော သက်သီထွက်ဆိုချက်သည်ကား ဇာပိုင်ဟိလဲ၊ သင့်မှာ ချေပဖို့ အဖြေ မဟိယာ မလား” ဟု ယေသျှုကို မိန်း၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","သို့ရာတွင် ယေသျှုသည်ကား စကားတစ်ခွန်းမျှ ပြန်မပြောဘဲနိန်၏။ ယဇ်ပုရောဟိတ်မင်းက “ငါသည် အသက်ရှင်တော်မူသောဘုရားသခင်၌ ကျမ်းကျိန်လျက် သင့်ကို မိန်း၏၊ သင်သည် ဘုရားသခင်၏သားတော် မေသျှိယ ဟုတ်လား၊ မဟုတ်လားဆိုသည်ကို ငါရို့ကို ပြောပါ” ဟု ကိုယ်တော့်ကို မိန်း၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ယေသျှုက “သင်ပြောသည့်အတိုင်းပင် ဖြစ်၏။ သို့သော် သင်ရို့အားလုံးကို ငါ ဆိုသည်ကား၊ လူသားသည် အနန္တတန်ခိုးသျှင်၏ လက်ယာဖက်၌ ထိုင်လျက် ကောင်းကင်မိုးတိမ်ထက်က ကြွလာတော်မူသည်ကို သင်ရို့သည် အဂုမှစ၍ မြင်ကြရလိမ့်မည်” ဟု ပြန်၍ မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ထိုအခါ ယဇ်ပုရောဟိတ်မင်းသည် မိမိ၏အင်္ကျီကို ဆုတ်ဖြဲကာ “သူသည် ဘုရားသခင်ကို ပြစ်မှားပြောဆို၏။ ငါရို့မှာ နောက်ထပ်သက်သီ ဇာပိုင် လိုဖို့သိမ့်လဲ။ ကြည့်ကတ်၊ ဘုရားသခင်ကို ပြစ်မှားပြောဆိုခြင်းကို သင်ရို့ အဂုပင် ကြားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","သင်ရို့ ဇာပိုင် ထင်ကတ်လဲ” ဟု ဆိုသော်၊ “သူသည် သီထိုက် ပါရေ” ဟု သူရို့က ပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ထိုအခါ သူရို့သည် ကိုယ်တော်၏မျက်နှာကို တန်းထွီးနှင့် ထွီးကာ ခန္ဓာကို လက်သီးနှင့် ထိုးကြ၏။ တချို့က ပါးကို သတ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ထို့နောက် “မေသျှိယ၊ သင့်ကို ဇာသူ လက်သီးနှင့်ထိုးလဲ၊ ငါရို့ကို ပရောဖက်ဉာဏ်နှင့် ဟော” ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ပေတရုသည် ယဇ်ပုရောဟိတ် အိမ်တော်ဝင်းပြင်ဖက်၌ ထိုင်နိန်သောအခါ ယဇ်ပုရောဟိတ်အကြီးအကဲ၏အစီခံမိန်းမချေတစ်ယောက်သည် သူ့နံပါးသို့ ရောက်လာပြီး၊ “သင်သည်လည်း ဂါလိလဲပြည်သား ယေသျှုနှင့်အတူ ဟိခသောသူတစ်ယောက် ဖြစ်တေ” ဟုဆို၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","သို့ရာတွင် ပေတရုက “သင်ပြောစွာကို ငါ မသိပါကား” ဟု သူရို့အားလုံး ရှိ့မှာ ငြင်းလိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ထို့နောက် သူသည် အိမ်ဝင်းတန်းခါးပေါက်ဖက်သို့ ထွက်လာရာ၊ တခြားအစီခံမိန်းမချေ တစ်ယောက်သည် သူ့ကိုတွိ့၍ “ဤသူသည် နာဇရက်မြို့သား ယေသျှုနှင့် အတူဟိခသော သူတစ်ယောက် ဖြစ်၏” ဟု ထိုနီရာ၌ ဟိသောလူတိကို ပြော၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ပေတရုက “ထိုသူကို အကျွန်မသိပါ” ဟု ကျိန်ဆိုလျက် တဖန် ငြင်းလိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","တအောင့်ချေလောက် ကြာသောအခါ၊ ထိုနီရာမှာ ရပ်နိန်သောသူရို့သည် ပေတရု နံပါးသို့ လာ၍ “သင်ပြောဆိုသည့် စကားလီသံကိုထောက်၍ သင်သည် သူရို့ထဲက တစ်ယောက်ဖြစ်သည်မှာ သေချာ၏” ဟု သူရို့က ပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","ထိုအခါ ပေတရုက “ထိုသူကို အကျွန် မသိပါ၊ အကျွန်သည် အမှန်ကို ပြော၍ ကျိန်ဆိုပါ၏၊ အကျွန်ပြောသည့်စကား မမှန်လျှင် အကျွန်သည် ဘုရားသခင်ပီးသောအပြစ်ကို ခံရပါစီ” ဟု ပြောလိုက်၏။ ထိုသို့ ပြောပြီးသည်နှင့် ချက်ချင်း ကြက် တွန်၏။ ");
INSERT INTO rki_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ထိုအခါ၌ ပေတရုသည် “သင်သည် ကြက်မတွန်ခင် ငါ့ကို သုံးကြိမ် ငြင်းလိမ့်မည်” ဟု မိမိအား ယေသျှု ပြောခသောစကားကို သတိရသဖြင့် အပြင်သို့ ထွက်၍ အလွန်ဝမ်းနည်းစွာ ငိုကြွီးလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","မိုးထစောစော၌ အားလုံးသော ယဇ်ပုရောဟိတ်မင်းတိနှင့် လူရို့တွင် အကြီးအကဲဖြစ်သောသူရို့သည် စုရုံးကြပြီးလျှင် ယေသျှုကို ဇာပိုင် အသီသတ်ရန် အစီအစဉ်များကို ချမှတ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","သူရို့သည် ကိုယ်တော့်ကို ကြိုးနှင့် ချိုင်၍ ခေါ်ဆောင်ကာ ရောမဘုရင်ခံ ပိလတ်မင်းလက်သို့ အပ်လိုက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ယေသျှုကို သစ္စာဖောက်သော ယုဒသျှကာရုဒ်သည် ယေသျှုအား ပြစ်ဒဏ်စီရင်ကြသည်ကို မြင်သောအခါ၊ အလွန်နောင်တရစိတ် ပေါ်ပေါက်လာပြီး ငွီဒင်္ဂါး သုံးဆယ်ကို ယဇ်ပုရောဟိတ်မင်းတိနှင့် လူအကြီးအကဲရို့လက်သို့ ပြန်ပီး၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","သူက “ငါ ပြစ်မှားမိယာ၊ အပြစ်မဟိသောသူ၏ အသွီးကို အပ်မိယာ” ဟု ပြော၏။ ထိုသူရို့က “ယင်းစွာ ငါရို့နှင့် ဇာဆိုင်လဲ၊ သင့်တာဝန်ရာ ဖြစ်တေ” ဟု သူရို့က ပြန်ပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ထိုအခါ ယုဒသည် ယင်းငွီကို ဗိမာန်တော်၌ ပစ်ချထားခ၏။ ထို့နောက် သူသည် ထွက်လားပြီးလျှင် မိမိကိုယ်ကို ကြိုးဆွဲချ၍ သီလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ယဇ်ပုရောဟိတ်အကြီးအကဲတိသည် ယင်းငွီဒင်္ဂါးတိကို ကောက်ယူပြီးလျှင် “ဤကား သွီးစွန်းသောငွီဖြစ်သောကြောင့် ဗိမာန်တော်၏ဘဏ္ဍာငွီထဲသို့ ထည့်လိုက်လျှင် ငါရို့၏ ပညတ်တရားနှင့် ဆန့်ကျင်၏” ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ထို့ကြောင့် သူရို့သည် တစ်ပါးအမျိုးသားရို့အတွက် သင်္ချိုင်းမြီလုပ်ရန် အိုးလုပ်သမား၏ မြီကွက်ကို ထိုငွီနှင့် ဝယ်ရန် ဆုံးဖြတ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ထို့ကြောင့် ၎င်းမြီကွက်ကို ဂနိ့တိုင်အောင် “သွီးမြီ” ဟုခေါ် ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ထို့ကြောင့် ပရောဖက်ယေရမိ ဟောခသော အနာဂတ္တိစကားသည် ပြည့်စုံခြင်းသို့ ရောက်လာ၏။ သူ၏ အနာဂတ္တိစကားမှာ၊ “သူရို့သည် ဣသရေလအမျိုးသားများက သူ့အား တန်ဖိုးဖြတ်ထားသော ငွီဒင်္ဂါးသုံးဆယ်ကို ယူ၍ ");
INSERT INTO rki_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ထာဝရဘုရားက ငါ့အား မှာထားတော်မူသည့်အတိုင်း ထိုငွီဖြင့် အိုးထိန်းသည်၏မြီကွက်ကို ဝယ်ကြ၏” ဟူ၍ ဖြစ်သတည်း။ ");
INSERT INTO rki_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ထိုအချိန်၌ ယေသျှုသည် ရောမဘုရင်ခံ ရှိ့၌ ရပ်နိန်၏။ ရောမဘုရင်ခံက ကိုယ်တော့်ကို “သင်သည် ယုဒလူမျိုးတိ သျှင်ဘုရင်လား” ဟု မိန်း၏။ ယေသျှုက “မင်းကြီးပြောသည့်အတိုင်း ဖြစ်၏” ဟု ပြန်ပြော၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ယဇ်ပုရောဟိတ်မင်းတိနှင့် လူအကြီးအကဲရို့၏ စွပ်စွဲမိန်းမြန်းချက်များကိုမူကား ကိုယ်တော်သည် လုံးဝ ပြန်ပြောတော်မမူ။ ");
INSERT INTO rki_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","ထို့ကြောင့် ပိလတ်မင်းက “သူရို့က သင့်ကို စွပ်စွဲနိန်ကြသည်ကို မကြားလား” ဟု ကိုယ်တော့်ကို မိန်း၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ယေသျှုသည် စကားတစ်ခွန်းမျှ ပြန်မပြောတော်မူသည်ဖြစ်၍ ပိလတ်မင်းသည် လွန်စွာ အံ့သြတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ထိုစဉ်က ပွဲတော်ချိန်၌ လူထုက တောင်းဆိုသော အကျဉ်းသားတစ်ယောက်ကို ရွှတ်ပီးသည့် ရောမဘုရင်ခံ၏ထုံးတမ်းစဉ်လာတစ်ခု ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ထိုအချိန်၌ သူရို့တွင် “ယေသျှု ဗာရဗ္ဗ” ဟု ခေါ်သော နာမည်ကြီး အကျဉ်းသားတစ်ယောက် ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ထိုသို့အလို့ငှာ လူရို့သည် စုရုံးရောက်လာကြသောအခါ ပိလတ်မင်းက သူရို့အား “သင်ရို့သည် ယေသျှု ဗာရဗ္ဗနှင့် မေသျှိယဟု ခေါ်သော ယေသျှု ရို့တွင် သင်ရို့အတွက် ဇာသူ့ကို ရွှတ်ပီးလိုကတ်လဲ” ဟု မိန်း၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","အကြောင်းမူကား ယဇ်ပုရောဟိတ်မင်းတိနှင့် လူအကြီးအကဲရို့က မနာလိုစိတ်ဖြင့် ယေသျှုကို မိမိလက်သို့ လာရောက်အပ်နှံကြကြောင်းကို ပိလတ်မင်း သိထားပြီးဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ပိလတ်မင်းသည် တရားပလ္လင်ထက်၌ ထိုင်နိန်စဉ်တွင် မိမိ၏ဇနီးက “အပြစ်ကင်းသောဤသူနှင့် တစ်ခုလည်း ပတ်သက်မှု မဟိစီကေ့၊ ဇာကြောင့်လဲဆိုကေ အကျွန်သည် ညက အိပ်မက်ထဲမှာ ဤသူကြောင့် အလွန် စိတ်ဒုက္ခ ရောက်ခရပါ၏” ဟု သတင်း ပို့လိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","ယဇ်ပုရောဟိတ်အကြီးအကဲတိနှင့် လူအကြီးအကဲရို့က ဗာရဗ္ဗကို ရွှတ်ပီးပြီး ယေသျှုကို အသီသတ်ရန် ပိလတ်မင်းအား တောင်းဆိုကြဖို့ လူထုကို တိုက်တွန်းလှုံ့ဆော် ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ပိလတ်မင်းက “ငါသည် ဤသူနှစ်ယောက်ထဲက ဇာသူ့ကို သင်ရို့အတွက် ရွှတ်ပီးစီချင်ပါလဲ” ဟု မိန်းသောအခါ၊ “ဗာရဗ္ဗကို ရွှတ်ပီးပါ” ဟု သူရို့က ဖြေကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ထို့နောက် ပိလတ်မင်းက “မေသျှိယဟု ခေါ်သော ယေသျှုကို ငါ ဇာပိုင် လုပ်ရပါဖို့လဲ” ဟု မိန်း၏။ သူရို့အားလုံးက “သူ့ကို လက်ဝါးကပ်တိုင်မှာ တင်၍ အသီသတ်လိုက်ပါ” ဟု တောင်းဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ပိလတ်မင်းက “သူသည် ဇာအပြစ်ကို ကျူးလွန်ထားပါလဲ” ဟု မိန်း၏။ သို့ရာတွင် သူရို့က “ဤသူကို လက်ဝါးကပ်တိုင်မှာ တင်၍ အသီသတ်လိုက်ပါ” ဟူ၍ အသံကုန် ဟစ်အော်လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ပိလတ်မင်းက မိမိသည် ဆက်လက်လုပ်ဆောင်ရန် မဖြစ်နိုင်။ သို့ရာတွင် ရုန်းရင်းဆန်ခတ် ဖြစ်စပြုလာသည်ကို မြင်သောအခါ၊ ရီကို ယူ၍ လူထုပရိတ်သတ်ရှိ့၌ မိမိလက်ကို ဆီးကာ “ဤသူ၏အသွီးသည် ငါနှင့် မဆိုင်၊ သင်ရို့ ပြုလုပ်ခြင်းသာဖြစ်သည်” ဟု ဆိုလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","လူထုပရိတ်သတ်အားလုံးက “ဤသူ၏ အသွီးသည် ငါရို့ ထက်သို့ လည်းကောင်း၊ ငါရို့ သားသမီးထက်သို့ လည်းကောင်း ကျပါစီ” ဟူ၍ အော်ဟစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","ထိုအခါ ပိလတ်မင်းက လူဆိုး ဗာရဗ္ဗကို ရွှတ်လိုက်၏။ ယေသျှုကိုမူကား ကြာပွတ်ဖြင့် ရိုက်ပြီးလျှင် လက်ဝါးကပ်တိုင်မှာ တင်၍ သတ်ရန် သူရို့၏ လက်ထဲသို့ အပ်လိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","ထို့နောက် ပိလတ်မင်း၏စစ်သားများသည် ယေသျှုကို အိမ်တော်ဝင်းထဲသို့ ယူဆောင်လာကြ၏။ ခြီလျှင်တပ်ခွဲ တစ်ခွဲလုံးဖြင့် ကိုယ်တော့်ကို ပတ်လည်ဝိုင်းထားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","စစ်သားများသည် ကိုယ်တော်၏အဝတ်တော်ကို ချွတ်ကာ ကြက်သွီးရောင်နီနီရဲရဲဝတ်ရုံကို ဝတ်ပီးကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ထို့နောက် ကိုယ်တော်၏ဂေါင်းထက်တွင် ဆူးခက်များနှင့် ရက်လုပ်ထားသော ဂေါင်းပေါင်းသရဖူကို ဆောင်းပီးထားကြ၏။ လက်ယာလက်၌ တုတ်ချေတစ်ချောင်းကို ကိုင်ထားစီပြီးလျှင် “ယုဒလူမျိုးတိ သျှင်ဘုရင် သက်တော်ရာကျော် ရှည်ပါစီ” ဟု ကိုယ်တော်၏ရှိ့မှာ ဒူးထောက်ခစားလျက် ပြက်ရယ်ပြုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","သူရို့သည် ကိုယ်တော့်ကို တန်းထွီးနှင့် ဝိုင်းထွီးကြ၏။ ကိုယ်တော်၏လက်ထဲမှ တုတ်ကို ယူ၍ ဦးဂေါင်းကို သတ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ထိုသို့ ကိုယ်တော့်ကို လှောင်ပြောင်၍ ပြက်ရယ်ပြုကြပြီးလျှင် အနီရောင်ဝတ်ရုံကို ပြန်ချွတ်၍ ကိုယ်တော်၏ဝတ်ရုံကို တဖန် ဝတ်စီကြပြန်၏။ ပြီးလျှင် လက်ဝါးကပ်တိုင်မှာ တင်၍ သတ်ရန် ယူဆောင်လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","သူရို့သည် ယေသျှုကို သတ်ရန် ယူဆောင်လာကြစဉ် လမ်း၌ သျှိမုန်ဟု ခေါ်သော ကုရေနေပြည်သား တစ်ယောက်ကို တွိ့သဖြင့် စစ်သားများက သူ့ကို အနိုင်ကျင့်၍ ယေသျှု၏လက်ဝါးကပ်တိုင်ကို ထမ်းခိုင်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","သူရို့သည် ဂေါလဂေါသဟု ခေါ်တွင်၍ ဦးဂေါင်းခွံအရပ်ဟု အဓိပ္ပာယ်ရသော အရပ်သို့ ရောက်သောအခါ၊ ");
INSERT INTO rki_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ယေသျှုအား ဆီးခါးနှင့်ရောထားသည့် စပျစ်ရည်ကို တိုက်ကြ၏။ ကိုယ်တော်သည် မြည်းစမ်းရုံသာ မြည်းစမ်းသော်လည်း သောက်ခြင်းငှာ ငြင်းဆန်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ထို့နောက် သူရို့သည် ကိုယ်တော့်ကို လက်ဝါးကပ်တိုင်မှာ တင်၍ ရိုက်ထားကြ၏။ ဝတ်ရုံတော်ကိုလည်း မဲခွဲ၍ ဝီယူကတ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ထို့နောက် ရောမစစ်သားများသည် ထိုနီရာတွင် ထိုင်ကာ ကိုယ်တော့်ကို စောင့်ကြည့်နိန်ကတ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","သူရို့က “ဤသူကား ယုဒလူမျိုးရို့၏ သျှင်ဘုရင် ယေသျှု ဖြစ်သတည်း” ဟု ရီးထားသော ကမ္ပည်းစာကို ကိုယ်တော်၏ ဦးဂေါင်းထက်တွင် ထားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ကိုယ်တော်နှင့်အတူ ဓါးပြ နှစ်ယောက်ကိုလည်း ကိုယ်တော်၏ လက်ယာဘက်၌ တစ်ယောက်၊ လက်ဝဲဘက်၌ တစ်ယောက် လက်ဝါးကပ်တိုင်တွင် တင်၍ ရိုက်ထားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","လမ်းလားလမ်းလာလူတိက ဂေါင်းတညိတ်ညိတ်ဖြင့် ကိုယ်တော့်ကို ကဲ့ရဲ့ဆဲဆိုလားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","သူရို့က “သင်သည် ဗိမာန်တော်ကို ဖြိုဖျက်၍ သုံးရက်တည်းဖြင့် ပြန်ဆောက်ပီးနိုင်သည်ဟု ပြော၏၊ သင်သည် ဘုရားသခင်သားမှန်လျှင် လက်ဝါးကပ်တိုင်မှ ဆင်း၍ မိမိကိုယ်ကို ကယ်တင်လိုက်ပါ” ဟူ၍ ပြောလားကတ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ယဇ်ပုရောဟိတ်အကြီးအကဲတိ၊ ကျမ်းတတ်ဆရာတိနှင့် လူရို့တွင် အကြီးအကဲဖြစ်သောသူရို့ကလည်း ကိုယ်တော့်ကို ထိုနည်းတူ ကဲ့ရဲ့လှောင်ပြောင်ကတ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","သူရို့က “ဤသူကား သူတစ်ပါးကို ကယ်တင်ခ၏၊ သို့သော်လည်း မိမိကိုယ်ကို မကယ်တင်နိုင်ပါကား၊ သူသည် ဣသရေလလူမျိုးရို့ သျှင်ဘုရင်ဖြစ်၏၊ လက်ဝါးကပ်တိုင်က သူ့ကို အဂု ဆင်းခိုင်းလိုက်ပါ၊ ယေဆိုကေ သူ့ကို ငါရို့ ယုံကတ်ပါဖို့၊ ");
INSERT INTO rki_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","သူသည် ဘုရားသခင်ကို ယုံကြည်ကိုးစား၏၊ သူက ‘ငါသည် ဘုရားသခင်၏သားတော် ဖြစ်သည်’ ဟု ပြောခ၏၊ ဘုရားသခင် အလိုဟိလျှင် အဂုပင် သူ့ကို ကယ်တင်ပါစီ” ဟူ၍ ပြောဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ကိုယ်တော်နှင့်အတူ လက်ဝါးကပ်တိုင်မှာ တင်၍ ရိုက်ထားခြင်းခံရသော ဓါးပြတိကလည်း ကိုယ်တော့်ကို ထိုနည်းတူ ကဲ့ရဲ့အပြစ်တင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","မွန်းတည့်ချိန်မှစ၍ မွန်းလွဲသုံးချက်တီးချိန်ထိတိုင်အောင် မြီကြီးတစ်ပြင်လုံး မှောင်မိုက်အတိ ဖြစ်လားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","မွန်းလွဲ သုံးချက်တီးချိန်လောက်တွင် ယေသျှုက “ဧလိ၊ ဧလိ၊ လာမ ရှာဗခသာနိ” ဟု ကျယ်လောင်သောအသံနှင့် အော်ဟစ်တော်မူ၏။ အဓိပ္ပာယ်မှာ “အကျွန်၏ဘုရားသခင်၊ အကျွန်၏ဘုရားသခင် ကိုယ်တော်သည် အကျွန့်ကို ဇာဖြစ်လို့ စွန့်ပစ်ထားခပါလဲ” ဟူ၍ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ထိုအရပ်၌ ရပ်နိန်ကြသည့် တချို့သော သူရို့က ကိုယ်တော်၏စကားကို ကြားကြသောအခါ “ဤသူသည် ဧလိယကို ခေါ်နိန်၏” ဟု ပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","သူရို့ထဲက လူတစ်ယောက်သည် ချက်ချင်း ဗြီးထွက်လာပြီးလျှင် ရီမြုပ်တစ်ခုကို ယူ၍ ချဉ်သောဝိုင်ထဲ၌ နှစ်မြှုပ်ကာ တုတ်ဖျားမှာတပ်၍ ယေသျှုအား သောက်ခြင်းငှာ ပီးလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","တခြားလူတိက “အဂု သူ့ကို လုံးချင်းတည်း ထားခ၊ သူ့ကို ကယ်ဖို့ ဧလိယ လာဖို့ မလာဖို့ကို စောင့်ကြည့်နိန်ကတ်မေ” ဟု ပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ထို့နောက် ယေသျှုသည် ကျယ်သောအသံနှင့် နောက်တဖန် အော်ဟစ်ပြီးသောအခါ သူသည် မိမိ၏အသက်ကို စွန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ထိုအချိန်၌ ဗိမာန်တော်ကန့်လန့်ကာသည် အထက်စွန်းမှ အောက်စွန်းတိုင်အောင် နှစ်ခြမ်း ကွဲလေ၏။ မြီကြီးတုန်လှုပ်သဖြင့် ကျောက်ဆောင်တိ ပြိုကွဲကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","သင်္ချိုင်းဂူများလည်း ပွင့်ထွက်ကာ သီနိန်ပြီးသော သန့်ယှင်းသူများစွာ၏အလောင်းများသည် ထမြောက်ခြင်းသို့ ရောက်ကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ယေသျှုသည် သီခြင်းက ထမြောက်လာပြီးနောက် ထိုသူရို့သည် သင်္ချိုင်းဂူများကို စွန့်ခွါပြီး သန့်ယှင်းမြင့်မြတ်သောမြို့တော်သို့ ဝင်လားကြပြီးလျှင် လူများစွာရို့အား ထင်ရှားစီ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ယေသျှုကို စောင့်ကြည့်နိန်ကြသော တပ်မှူးနှင့်တကွ ရောမစစ်သားများသည် ငလျှင်လှုပ်ခြင်းမှစ၍ ဖြစ်ပျက်သမျှအားလုံးကို မြင်တွိ့ကြသည့်အခါ ကြောက်ရွံ့တုန်လှုပ်ကြပြီးလျှင် “ယေသျှုသည် ဘုရားသခင်၏သား အမှန်ပင် ဖြစ်သည်” ဟု ဝန်ခံပြောဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ထိုနီရာ၌ မလှမ်းမကမ်းမှ ကြည့်နိန်ကြသော မိန်းမများလည်း ဟိကြ၏။ သူရို့သည် ကိုယ်တော့်ကို အလုပ်အကျွေးပြုရန် ဂါလိလဲပြည်မှ ကိုယ်တော့်နောက်ကို လိုက်လာကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","သူရို့အထဲ၌ မာဂဒလမြို့သူ မာရိ၊ ယာကုပ်နှင့် ယောသပ်အမိ မာရိ၊ ဇေဗေဒဲ၏ ဇနီးမယားရို့လည်း ပါကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ညစာဘက်သို့ရောက်သောအခါ အရိမဿဲမြို့မှ လူချမ်းသာ တစ်ယောက် ရောက်လာ၏။ သူ၏နာမည်မှာ ယောသပ်ဖြစ်ပြီး သူသည်လည်း ယေသျှု၏တပည့်တော် တစ်ယောက် ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","သူသည် ပိလတ်မင်း ထံပါးသို့ ဝင်ရောက်ကာ ယေသျှု၏အလောင်းကို တောင်းလေ၏။ ပိလတ်မင်းကလည်း အလောင်းတော်ကို ယောသပ်အား ပီးရန် မိန့်တော်မူလိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ယောသပ်သည် အလောင်းတော်ကို ယူ၍ ဖြူစင်သော ပိတ်စအသစ်ဖြင့် ပတ်ရစ်ပြီး၊ ");
INSERT INTO rki_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ကျောက်ဆောင်၌ ထွင်းထားသည့် မိမိပိုင် အသစ်သော ကျောက်ဂူသင်္ချိုင်းအတွင်း၌ ယေသျှု၏အလောင်းကို ထည့်သွင်းကာ သင်္ချိုင်းဂူအပေါက်ဝတွင် ကျောက်တုံးကြီးတစ်တုံးကို တွန်းလှိမ့်၍ ထားခပြီးမှ ထွက်လားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","မာဂဒလမြို့သူ မာရိနှင့် အခြားသောမာရိရို့သည် ထိုအရပ်၌ သင်္ချိုင်းဂူ၏ ရှိ့မှာ ထိုင်နိန်ခကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","နောက်တစ်နိ့ ဥပုသ်နိ့ရောက်လာသောအခါ ယဇ်ပုရောဟိတ်အကြီးအကဲတိနှင့် ဖာရိယှဲတိသည် ပိလတ်မင်းထံသို့ လား၍ ");
INSERT INTO rki_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“အသျှင်မင်းကြီး၊ ထိုလှည့်ဖျားတတ်သောသူက ‘ငါသည် သုံးရက်မြောက်သောနိ့တွင် ထမြောက်လိမ့်မည်’ ဟု ထိုသူ အသက်ရှင်နိန်ခသောအချိန်၌ ပြောခသည်ကို အကျွန်ရို့ သတိရပါ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ထိုသို့ အလို့ငှာ ထိုသူ၏တပည့်များသည် သူ၏အလောင်းကို လာ၍ ခိုးယူပြီးလျှင် ထိုသူသည် သီခြင်းက ထမြောက်ပြီဟု လူတိကို ပြောကြလိမ့်မည်။ ဤသို့သော နောက်ဆုံး လှည့်ဖျားခြင်းသည် ပထမလှည့်ဖျားခြင်းထက် သာ၍ ဆိုးလိမ့်မည်။ ထို့ကြောင့် သင်္ချိုင်းဂူကို လုံခြုံစီခြင်းငှာ သုံးရက်မြောက်သည့်တိုင်အောင် စောင့်ကြည့်နိန်ခွင့်ပီးပါ” ဟု သူရို့က တောင်းလျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ပိလတ်မင်းက “အစောင့်တပ် တစ်တပ်ကို ခေါ်၍ သင်္ချိုင်းဂူ လုံခြုံစီခြင်းငှာ သင်ရို့တတ်နိုင်သမျှ လား၍ စောင့်နိန်ကတ်” ဟု ခွင့်ပြုလိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ထို့ကြောင့် သူရို့သည် လား၍ သင်္ချိုင်းဂူလုံခြုံစီခြင်းငှာ ကျောက်တုံးတွင် တံဆိပ်ရိုက်ပြီး အစောင့်တပ်ကို ချထားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ဥပုသ်နိ့လွန်ပြီးနောက် တလင်္ဂနီနိ့ အရုဏ်တက်ချိန်တွင် မာဂဒလမြို့သူ မာရိနှင့် တခြားမာရိ ရို့သည် သင်္ချိုင်းဂူသို့ ကြည့်ရန် လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ထိုနီရာ၌ ပြင်းထန်သော မြီငလျင်တစ်ခု လှုပ်လေ၏။ အကြောင်းမူကား ထာဝရဘုရား၏ကောင်းကင်တမန် တစ်ပါးသည် ကောင်းကင်မှ ဆင်းလာ၍ သင်္ချိုင်းဂူ၌ ပိတ်ထားသော ကျောက်တုံးကို လှိမ့်ဖယ်၍ ထိုကျောက်တုံးထက်တွင် ထိုင်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","သူ၏ အဆင်းသဏ္ဌာန်သည် လျှပ်ပြက်သကဲ့သို့ လင်းလက်ကာ သူ၏အဝတ်သည်လည်း နှင်းပွင့်ကဲ့သို့ ဖြူဖွေးလျက်ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","အစောင့်တပ်သားများသည် ထိုကောင်းကင်တမန်အား အလွန်ကြောက်လန့်ကြပြီး သူရို့သည် တုန်လှုပ်လျက် အသီကောင်ကဲ့သို့ ဖြစ်လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ကောင်းကင်တမန်က “မကြောက်ကတ်ကေ့၊ သင်ရို့သည် လက်ဝါးကပ်တိုင်မှာ တင်၍ အသတ်ခံရသော ယေသျှုကို ရှာနိန်ကြသည်ကို ငါသိ၏။ ");
INSERT INTO rki_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","သူသည် ဤအရပ်၌ မဟိယာ၊ သူပြောထားခသည့်အတိုင်း သီခြင်းက ထမြောက်လားယာ၊ ဤနီရာသည် သူလဲလျောင်းနိန်ခသော နီရာ ဖြစ်၏၊ လာ၍ ကြည့်ကြလော့။ ");
INSERT INTO rki_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","အဂုပင်လျှင် သူ၏ တပည့်တော်တိပါးသို့ အလျှင်အမြန် လားပြောကတ်ခီ။ ‘ကိုယ်တော်သည် သီခြင်းက ထမြောက်တော်မူ၍ ဂါလိလဲပြည်သို့ သင်ရို့ရှိ့က ကြွတော်မူပြီ။ သင်ရို့သည် ထိုနီရာ၌ သူ့ကို တွိ့ကြလိမ့်မည်။’ အဂုပင် ငါသည် သင်ရို့အား ပြော၏” ဟု ထိုမိန်းမများကို ပြော၏။ ");
INSERT INTO rki_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ထိုကြာင့် မိန်းမရို့သည် ကြောက်ရွံ့သော်လည်း ဝမ်းမြောက်ဝမ်းသာစိတ်နှင့် သင်္ချိုင်းဂူမှ အလျှင်အမြန် ထွက်လာကြပြီးလျှင် ကိုယ်တော်၏တပည့်တော်တိပါးသို့ ပြောရန် လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ယေသျှုသည် ရုတ်တရက် သူရို့ကို တွိ့ဆုံ၍ “သာလီစွပါ” ဟု နှုတ်ဆက်၏။ မိန်းမများသည် ကိုယ်တော်အပါးသို့ ချဉ်းကပ်ပြီး ကိုယ်တော်၏ခြီကို ဖက်၍ ကိုယ်တော့်ကို ကိုးကွယ်ဝတ်ပြုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","ယေသျှုက “မကြောက်ကတ်ကေ့၊ ငါ့ညီအစ်ကိုတိကို ဂါလိလဲပြည်သို့ လားကြရန် ပြောလိုက်ပါ၊ ထိုအရပ်၌ ငါ့ကို တွိ့ကြလိမ့်မည်” ဟု ထိုမိန်းမတိကို မိန့်တော်မူလိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","ထိုမိန်းမရို့သည် ထွက်လားကြသည့်အခါ အစောင့်စစ်သားတိထဲက တချို့သည် မြို့ထဲသို့ ဝင်လာ၍ ဖြစ်ခသည့်အကြောင်းစုံကို ယဇ်ပုရောဟိတ်အကြီးအကဲရို့အား ပြောကြားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ယဇ်ပုရောဟိတ်အကြီးအကဲတိသည် ဘာသာရေးခေါင်းဆောင်ရို့နှင့်တွိ့ဆုံ၍ တိုင်ပင်ကြပြီးမှ အစောင့်စစ်သားများကို ငွီအမြောက်အမြား ပီး၍၊ ");
INSERT INTO rki_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“သူ၏တပည့်တော်တိသည် ညဉ့်အခါ၌ ရောက်လာကြပြီးလျှင် အကျွန်ရို့ အိပ်နိန်ကြသောအချိန်တွင် သူ၏အလောင်းကို ခိုးယူလားကတ်တေဟု ပြောကတ်။ ");
INSERT INTO rki_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","အကယ်၍ ဤသတင်းသည် ဘုရင်ခံပါးသို့ ရောက်လားသော်လည်း သင်ရို့၌ ပြဿနာ မဟိစီခြင်းငှာ ငါရို့သည် ဘုရင်ခံအား စိတ်ကြေနပ်စီခြင်းငှာ ပြောဆိုပီးထားမည်” ဟု ပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","အစောင့်စစ်သားများသည် ငွီကို ယူ၍ သူရို့ကို ညွှန်ကြားထားသည့်အတိုင်း ပြောကြ၏။ ထို့ကြောင့် ဤသတင်းသည် ယုဒလူမျိုး အသိုင်းအဝိုင်းထဲမှာ ဂနိ့တိုင်အောင် ပြန့်နှံ့လျက်ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ထိုအခါ တပည့်တော်ဆယ့်တစ်ယောက်သည် ဂါလိလဲပြည်သို့ လား၍ ယေသျှု မှာထားခသည့် တောင်ကုန်းထက်သို့ တက်လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","သူရို့သည် ကိုယ်တော့်ကို တွိ့မြင်၍ ကိုးကွယ်ဝတ်ပြုကြ၏။ သို့သော်လည်း တပည့်တော်တချို့သည်ကား သံသယစိတ်ဟိနိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ထို့ကြောင့် ယေသျှုသည် မိမိ၏တပည့်တော်တိပါးသို့ လာ၍ မိန့်မှာတော်မူသည်မှာ၊ “ငါသည် ကောင်းကင်ဘုံ၌လည်းကောင်း၊ မြီကြီးပေါ်၌လည်းကောင်း အုပ်စိုးပိုင်သော တန်ခိုးအာဏာကို ရထားပြီးပြီ။ ");
INSERT INTO rki_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ထို့ကြောင့် သင်ရို့သည် လား၍ လူမျိုးအားလုံးကို ငါ့တပည့် ဖြစ်စီလျက်၊ ခမည်းတော်၊ သားတော်၊ သန့်ယှင်းသောဝိညာဉ်တော်၏ နာမ၌ ဗတ္တိဇံကို ပီးကြလော့။ ");
INSERT INTO rki_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ငါသည် သင်ရို့အား ပီးထားသမျှသော ပညတ်တော်တိကို စောင့်ထိန်းကြစီခြင်းငှာ သူရို့အား ဆုံးမဩဝါဒ ပီးကြလော့။ ငါသည် ကပ်ကမ္ဘာ ကုန်သည့်တိုင်အောင် သင်ရို့နှင့်အတူ အမြဲတမ်း ဟိနိန်လိမ့်မည်” ဟု မိန့်တော်မူ၏။");
INSERT INTO rki_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ဘုရားသခင်၏သားတော် ယေသျှုခရစ်တော်၏ သတင်းကောင်းတရားတော် စတင်ပုံကို ဆိုပေအံ့။ ");
INSERT INTO rki_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ပရောဖက် ဟေသျှာယ၏ ကျမ်းစာ၌၊ “ဘုရားသခင် မိန့်တော်မူသည်ကား၊ ‘သင်ရို့၏ လမ်းခရီးကို ပျင်ဆင်ခြင်းငှာ၊ ငါ၏တမန်ကို သင်ရို့အရှိ့၌ ငါ စီရွှတ်မည်။’ ");
INSERT INTO rki_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","တောကန္တာရ၌ ဟစ်ကြော်သောသူ၏အသံကား ‘ထာဝရဘုရား ကြွတော်မူရာလမ်းကို ပျင်ဆင်ကြလော့၊ ထိုအသျှင်၏ လမ်းခရီးတော်ကို ပြောင့်တန်းစီကြလော့’” ဟု ရီးထားသည်နှင့်အညီ၊ ");
INSERT INTO rki_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ဗတ္တိဇံဆရာယောဟန်သည် တောကန္တာရ၌ ပေါ်ထွန်းလာ၍ တရားဟောလျက်၊ ဗတ္တိဇံပီးလျက် နိန်၏။ ထိုသူသည် လူရို့အား “နောင်တရပြီး၊ ဗတ္တိဇံကို ခံယူကြ။ ယင်းမှသာ ဘုရားသခင်သည် သင်ရို့၏အပြစ်များကို ခွင့်ရွှတ်လိမ့်မည်” ဟု ဟောပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ယုဒပြည် ကျေးလက်ဒေသနှင့် ယေရုဆလင်မြို့မှ လူအပေါင်းရို့သည် ယောဟန်ပါးသို့ လာပြီးလျှင်၊ မိမိရို့၏အပြစ်များကို ဝန်ခံကြသည်ဖြစ်၍ ယောဟန်သည် ထိုသူရို့အား ယော်ဒန်မြစ်၌ ဗတ္တိဇံကို ပီးလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ယောဟန်သည် ကုလားအုတ်အမွီးနှင့် ရက်လုပ်ထားသော အဝတ်ကိုဝတ်ပြီး၊ ခါး၌ သားရီဖြင့် လုပ်ထားသောခါးပတ်ကို ပတ်ထားလျက်၊ ကျိုင်းကောင်နှင့် တော၌ ဟိသောပျားရည်ကို မှီဝဲလို့နိန်၏။ ");
INSERT INTO rki_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ယောဟန်က “ငါ့နောက်၌ ကြွလာသောသူကား၊ ငါ့ထက်သာ၍ ကြီးမြတ်သောသူဖြစ်၏။ ငါသည် ထိုသူ၏ ခြီနင်းကြိုးကိုတောင်မှ ငုံ့၍ ဖြီဖို့ မထိုက်။ ");
INSERT INTO rki_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ငါကား၊ ရီ၌ ဗတ္တိဇံကို ပီး၏။ သို့ရာတွင် ထိုသူသည် သင်ရို့အား သန့်ယှင်းသောဝိညာဉ်တော်၌ ဗတ္တိဇံကို ပီးလိမ့်မည်” ဟု ဟောပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ထိုအခါ ယေသျှုသည် ဂါလိလဲပြည် နာဇရက်မြို့မှ ကြွလာပြီးလျှင် ယော်ဒန်မြစ်၌ ယောဟန်အားဖြင့် ဗတ္တိဇံကို ခံတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ယေသျှုသည် ရီထဲမှ ပေါ်ထလာစဉ်တွင် ကောင်းကင်ဖွင့်၍ သန့်ယှင်းသော ဝိညာဉ်တော်သည် ဂြိုးငှက်ကဲ့သို့ မိမိအထက်၌ ဆင်းသက်တော်မူသည်ကို မြင်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ထို့နောက် ကောင်းကင်မှလည်း “သင်ကား ငါ နှစ်သက်မြတ်နိုးရာ ငါ၏ ချစ်သားဖြစ်၏” ဟု အသံထွက်ပေါ်လာ၏။ ");
INSERT INTO rki_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ထို့နောက် သန့်ယှင်းသောဝိညာဉ်တော်သည် ယေသျှုအား တောကန္တာရသို့ ချက်ချင်းပို့ဆောင်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ထိုအရပ်၌ စာတန်မာရ်နတ်သည် ယေသျှုအား ရက်ပေါင်းလေးဆယ်ပတ်လုံး စုံစမ်းသွီးဆောင်တော်မူ၏။ ထိုအရပ်၌ သားရဲတိရစ္ဆာန်တိလည်း ဟိ၏၊ သို့သော် ကောင်းကင်တမန်ရို့သည် ထိုအသျှင်အား စောင့်ရှောက်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ယောဟန်သည် ထောင်၌ အကျဉ်းချခံရပြီးနောက် ယေသျှုသည် ဂါလိလဲပြည်သို့ လားပြီးလျှင် ဘုရားသခင်၏ သတင်းကောင်းတရားကို ဟောပြောတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ထိုသတင်းကောင်းတရားဟူမူကား “ချိန်းချက်တော်မူသော အချိန်ရောက်ယာ၊ ဘုရားသခင်၏ နိုင်ငံတော်သည် အနီးအပါး၌ ဟိယာ။ နောင်တရ၍၊ သတင်းကောင်းတရားကို ယုံကြည်ကြလော့” ဟူ၍ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ယေသျှုသည် ဂါလိလဲအိုင် ကမ်းခြီတလျှောက်၌ ကြွတော်မှုစဉ်၊ သျှိမုန်နှင့် သူ၏ ညီအန္ဒြေရို့သည် ပိုက်ဖြင့် ငါးဖမ်းနိန်သည်ကို မြင်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ယေသျှုကလည်း ထိုသူရို့အား “လာကြ၊ ငါ့နောက်သို့ လိုက်ကြ။ သင်ရို့အား လူကို မျှားသောတံငါ ဖြစ်စီခြင်းငှာ ငါ သင်ပီးမည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ထိုသူရို့သည် ချက်ချင်းပင် မိမိရို့၏ ငါးဖမ်းပိုက်ကို စွန့်ပစ်ပြီး ကိုယ်တော်၏နောက်သို့ လိုက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ထိုမှ အနည်းချေလွန်လားလျှင် ကိုယ်တော်သည် အခြားညီကိုနှစ်ယောက်ဖြစ်သော ဇေဗေဒဲ၏သား ယာကုပ်နှင့် ယောဟန်ရို့သည် လောင်းထဲ၌ ငါးဖမ်းပိုက်အား အဆင်သင့်ဖြစ်စီခြင်းငှာ ပြုပျင်နိန်သည်ကို တွိ့မြင်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ကိုယ်တော်သည် သူရို့ကို မြင်၍ ချက်ချင်း ခေါ်တော်မှုလျှင် သူရို့က ဖခင်ဖြစ်သူ ဇေဗေဒဲကို လူငှားတိနှင့်အတူ လောင်းထဲတွင် ထားခပြီး နောက်တော်သို့ လိုက်ကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ယေသျှုနှင့် တပည့်တော်ရို့သည် ကပေရနောင်မြို့သို့ ရောက်လာကြပြီး၊ နောက်တစ်နိ့ ဥပုသ်နိ့၌ တရားဇရပ်သို့ လား၍ ဆုံးမဩဝါဒ ပီးလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ထိုအသျှင်၏ ဆုံးမဩဝါဒကို ကြားရသောသူရို့သည် အံ့ဩခြင်းသို့ ရောက်ကြ၏။ အကြောင်းမူကား ကျမ်းတတ်ဆရာတိကဲ့သို့ မဟုတ်ဘဲ အခွင့်အာဏာဟိသောသူကဲ့သို့ ဆုံးမဩဝါဒကို ပီးတော်မူသောကြောင့်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","ထိုအချိန်၌ တရားဇရပ်တွင် ဝိညာဉ်ဆိုးပူးသော လူတစ်ယောက်ဟိ၏။ ထိုသူသည် အော်ဟစ်ကြောက်လန့်၍၊ ");
INSERT INTO rki_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“နာဇရက်မြို့သားယေသျှု၊ ကိုယ်တော်သည် အကျွန်ရို့နှင့် ဇာသို့ ဆိုင်သနည်း။ အကျွန်ရို့ကို ဖျက်ဆီးဖို့ ရောက်လာသည်လော။ ကိုယ်တော်သည် ဘုရားသခင်ထံမှ ကြွလာသော သန့်ယှင်းသော သူဖြစ်သည်ကို — အကျွန်သိပါ၏” ဟု ဟစ်ကြော်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ယေသျှုကလည်း “တိန်း၍ နီပြီးလျှင် ထိုသူအထဲက ထွက်လားလော့” ဟု ဝိညာဉ်ဆိုးကို အမိန့်ပီးတော်မူလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ဝိညာဉ်ဆိုးသည် ထိုသူကို တက်စီပြီး ကြီးသောအော်ဟစ်ခြင်းကို ပြုပြီးမှ ထွက်လားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ထိုအခြင်းအရာကို တွိ့မြင်သောသူရို့သည် မိန်းမောတွေဝေ၍ “ဤချင့်ကား ဇာသို့နည်း။ ဤဆုံးမခြင်းမျိုးက ဇာပိုင်မျိုးနည်း။ အာဏာဖြင့် အမိန့်ပီးသည်နှင့် ဝိညာဉ်ဆိုးရို့ နားထောင်ကြ၏” ဟု အချင်းချင်း ပြောဆိုနိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ကိုယ်တော်၏ သတင်းတော်သည်လည်း ဂါလိလဲပြည်တလျှောက်၌ လျင်မြန်စွာ ပြန့်လားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ထို့နောက် ယေသျှုနှင့်တပည့်တော်ရို့သည် တရားဇရပ်မှ ထွက်လာ၍ သျှိမုန်နှင့် အန္ဒြေရို့၏အိမ်သို့ ကြွတော်မူ၏။ ယောဟန်နှင့် ယာကုပ်ရို့လည်း အတူလိုက်လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","သျှိမုန်၏ယောက္ခမသည် အိပ်ရာထဲ၌ ဖျားနာ၍ တုံးလုံးလှဲနိန်သည်ကို ထိုအိမ်သို့ ရောက်လျှင်ရောက်ချင်း ယေသျှုအား လျှောက်ထားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ယေသျှုသည် သူမအနားသို့ လားပြီးလျှင် လက်ကိုကိုင်ဆွဲ၍ ထူမတော်မူ၏။ ထိုအခါ သူမသည် ဖျားနာပျောက်၍ အာဂန္တုဝတ်ကို ပြုလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","နီဝင်၍ ညချမ်းအချိန်ရောက်သောအခါ လူရို့သည် မကျန်းမာသောသူရို့နှင့် နတ်ဆိုးပူးသောသူရို့ကို အထံတော်သို့ ခေါ်ဆောင်လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","တစ်မြို့လုံးမှ လူရို့သည် အိမ်ရှိ့၌ လာရောက်စုရုံးလျက်ဟိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ကိုယ်တော်သည် ရောဂါအမျိုးမျိုး ခံစားနိန်ကြသောလူတိကို ကျန်းမာစီတော်မူလျက် နတ်ဆိုးတိကိုလည်း မောင်းထုတ်တော်မူ၏။ ကိုယ်တော်သည် နတ်ဆိုးတိအား စကားတစ်ခွန်းကိုမျှ ပြောခွင့်ပီးတော်မမူ။ အကြောင်းမူကား နတ်ဆိုးရို့သည် ကိုယ်တော့်ကို မည်သူဖြစ်ကြောင်းကို သိသောကြောင့်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","နောက်တစ်နိ့ မိုးထစောစော၌ ယေသျှုသည် အိပ်ရာမှထကာ အိမ်မှထွက်၍ တိတ်ဆိတ်ရာအရပ်သို့ ကြွလားတော်မူပြီးလျှင်၊ ထိုအရပ်၌ ဆုတောင်းပတ္ထနာ ပြုတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","သျှိမုန်နှင့် သူ၏အပေါင်းအပါရို့သည် ကိုယ်တော့်ကို လိုက်ရှာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ကိုယ်တော့်ကို တွိ့သောအခါ သူရို့သည် “လူတိက ကိုယ်တော့်ကို ရှာနိန်ကတ်ရေ” ဟု လျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ကိုယ်တော်ကလည်း “ဤအရပ်မှ နီးစပ်ရာ အခြားရွာများသို့ တရားဟောခြင်းငှာ ငါရို့ လားကြမည်။ ယင်းအတွက်နန့် ငါ ကြွလာရခြင်းဖြစ်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ကိုယ်တော်သည် ဂါလိလဲပြည် အရပ်ရပ်၌ဟိသော တရားဇရပ်များတွင် တရားဟောခြင်း၊ နတ်ဆိုးများကို မောင်းထုတ်ခြင်းတိကို ပြုတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","အနူရောဂါသည် တစ်ယောက်သည် ကိုယ်တော်၏ ရှိ့တော်သို့ ရောက်လာပြီး၊ ဒူးထောက်လျက် “ကိုယ်တော် အလိုတော်ဟိလျှင် အကျွန့်ကို သန့်ယှင်းစီပါ” ဟု တောင်းပန်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ယေသျှုသည် သနား တော်မူသဖြင့်၊ လက်တော်ကိုဆန့်၍ ထိုသူကို တို့ပြီး “ငါ အလိုဟိ၏၊ သန့်ယှင်းစီလော့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ထိုသူသည် ချက်ချင်း နူနာပျောက်၍ သန့်ယှင်းခြင်းသို့ ရောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","ထို့နောက် ယေသျှုက “ဤအကြောင်းအရာတိကို ဇာသူကိုမျှ မပြောကေ့၊ သို့သော် ယဇ်ပုရောဟိတ်ပါးသို့ လား၍ သင်၏ကိုယ်ကိုပြပြီး၊ သင်၌ သန့်ယှင်းသည်ကို လူရို့၌ သက်သီဖြစ်စီခြင်းငှာ မောသျှေစီရင်မှာထားခသော ပူဇော်သကာကို ပြုလော့” ဟု ထိုသူအား ကြပ်တည်းစွာ မှာထား၍ ရွှတ်လိုက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ထိုသူသည် မိန့်မှာထားတော်မှုသည့်အတိုင်း ဝီးရာသို့ ထွက်လားလေ၏။ သို့သော် မိမိ၌ ဖြစ်ပျက်သမျှအကြောင်းအား ပြောကြားခြင်းဖြင့် ထိုသတင်းသည် နီရာအနှံ့အပြားသို့ ရောက်လေ၏။ ထို့ကြောင့် ကိုယ်တော်သည် ဇာမြို့၊ ဇာရွာကိုမျှ ထင်ရှားစွာ မဝင်ဘဲ၊ ဆိတ်ငြိမ်ရာ တောအရပ်၌သာ နိန်တော်မူ၏။ သို့သော် အရပ်ရပ်မှ လူရို့သည် ကိုယ်တော်ပါးသို့ ရောက်လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ရက်အနည်းချေ လွန်ပြီးနောက် ယေသျှုသည် ကပေရနောင်မြို့သို့ ရောက်လာ၏။ ကိုယ်တော်သည် အိမ်၌ ဟိတော်မူသည့်အကြောင်း သတင်းတော်သည် ပြန့်နှံ့လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ထို့ကြောင့် လူအပေါင်းရို့သည် စုရုံးရောက်လာကြသဖြင့် အိမ်ခန်းမှစ၍ အိမ်ရှိ့၌ပင် ခြီချစရာ နီရာမဟိပေ။ ယေသျှုသည်လည်း ထိုလူအပေါင်းရို့ကို တရားဟောတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ထိုစဉ် လူလေးယောက်ရို့သည် လီဖြတ်သော လူတစ်ယောက်ကို ကိုယ်တော့်အထံတော်ပါးသို့ သယ်ယူလာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","သို့သော် လူအပေါင်းရို့သည် ပြည့်ကျပ်နိန်သဖြင့် ကိုယ်တော့်ထံသို့ တိုး၍ မပေါက်နိုင်ကြ။ ထို့ကြောင့် ကိုယ်တော်ဟိသည့် နီရာအထက်မှ အိမ်ခေါင်မိုးကိုဖွင့်ပြီး၊ လူမမာအား လှဲနိန်သောဖျာနှင့်တကွ လျောချကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ယေသျှုကလည်း ထိုသူရို့၏ ယုံကြည်ခြင်းကို မြင်လျှင် လီဖြတ်သောလူအား “ငါ့သား၊ သင်၏အပြစ်ကို ခွင့်ရွှတ်ယာ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ထိုအရပ်၌ ထိုင်နိန်ကြသော ကျမ်းတတ်ဆရာအချို့က၊ ");
INSERT INTO rki_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“ဤသူသည် ဇာကြောင့် ဤပိုင် ပြောရသနည်း။ ဤသည်ကား ဘုရားကို ပြစ်မှားခြင်းဖြစ်၏။ ဘုရားသခင် တစ်ပါးတည်းရာ အပြစ်ကို ရွှတ်နိုင်သောသူဖြစ်၏” ဟူ၍ တွေးတောနိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ထိုသူရို့သည် မိမိရို့၏စိတ်နှလုံးထဲ၌ ထိုသို့ တွေးတောနိန်သည်ကို ယေသျှုသည် မိမိဉာဏ်တော်အားဖြင့် ချက်ချင်း သိတော်မူသဖြင့် “သင်ရို့ ဇာတွက် ယင်းပိုင် တွေးတောကြသနည်း။ ");
INSERT INTO rki_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","လီဖြတ်နိန်သော သူအား ‘သင်၏ အပြစ်ကို ခွင့်ရွှတ်ယာ’ ဟု ပြောသည်က ပို၍ လွယ်သလော၊ ထိုသို့ မဟုတ် ‘ထပြီးလျှင် သင့်ဖျာကို လိပ်ကာ ပြန်လားလော့’ ဟု ပြောသည်က ပို၍ လွယ်သလော။ ");
INSERT INTO rki_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","လူသားသည် ဤလောက၌ အပြစ်ရွှတ်ပိုင်ခွင့် တန်ခိုးအာဏာဟိသည်ကို သင်ရို့သည် တွိ့မြင်ရလိမ့်မည်” ဟု ပြောဆိုပြီးလျှင် လီဖြတ်သောသူအား ");
INSERT INTO rki_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“သင့်အား ငါ ဆိုသည်ကား၊ ထပြီးလျှင် သင်၏ဖျာကို ကောက်၍ အိမ်သို့ ပြန်လော့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ထိုသူသည်လည်း မိမိ၏ဖျာကို ကောက်ပြီးလျှင် လူအပေါင်းရို့ရှိ့မှ ထွက်လားလေ၏။ ထိုအမှုအရာကို တွိ့မြင်သောလူရို့သည် အလွန်တရာအံ့ဩကြပြီး “ဤပိုင် ငါရို့တစ်သက်မှာ တခါမှ မမြင်ဖူးပါ” ဟု ဆိုလျက် ဘုရားသခင်၏ ဂုဏ်တော်ကို ချီးမွမ်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","တဖန်၊ ယေသျှုသည် ဂါလိလဲကမ်းခြီသို့ ကြွတော်မူ၏။ လူအစုအဝေးရို့သည် ကိုယ်တော်ပါးသို့ ရောက်လာကြသဖြင့် ကိုယ်တော်သည် ထိုသူရို့အား ဟောပြောသွန်သင်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ထိုမှ ကြွတော်မူစဉ် အကောက်ခွန်ရုံး၌ အာလဖဲ၏သား လေဝိထိုင်နိန်သည်ကို မြင်တော်မူလျှင်၊ ကိုယ်တော်က “ငါ့နောက်သို့ လိုက်လော” ဟု မိန့်တော်မူ၏။ ထိုသူသည် ချက်ချင်းထပြီး ကိုယ်တော်၏ နောက်တော်သို့ လိုက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ထို့နောက် ယေသျှုသည် လေဝိ၏အိမ်၌ တပည့်တော်ရို့နှင့်အတူ စားသောက်လျက်နိန်စဉ်၊ အခွန်ခံများနှင့် အပယ်ခံသောသူများသည် လိုက်လာကြသဖြင့် တပည့်တော်ရို့နှင့်အတူ ဝင်ရောက်စားသောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ထိုသို့ ကိုယ်တော်သည် ထိုသူရို့နှင့် စားသောက်လျက်နိန်သည်ကို ကျမ်းပြုဆရာအချို့နှင့် ဖာရိယှဲအချို့သည် မြင်ကြလျှင် “ဤသူကား ဇာဖြစ်လို့ အခွန်ခံသောလူ၊ အပယ်ခံသောလူတိနှင့်အတူ စားသောက်နိန်သနည်း” ဟု တပည့်တော်ရို့အား မိန်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ကိုယ်တော်သည် ထိုစကားကို ကြားလျှင် “ကျန်းမာသောသူရို့သည် ဆီးသမားကို အလိုမဟိ၊ မကျန်းမာသော လူတိရာ အလိုဟိကြ၏။ ငါ ကြွလာသည်ကား၊ အရိုအသီခံရသော လူတိအတွက် လာသည် မဟုတ်၊ အပယ်ခံရသောလူတိနှင့် ဆိုးသွမ်းသောလူတိအတွက် ငါ ကြွလာခြင်းဖြစ်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","တစ်နိ့၌ ဗတ္တိဇံဆရာယောဟန်၏ တပည့်ရို့နှင့် ကျမ်းပြုဆရာရို့သည် အစာယှောင်နိန်ကြ၏။ လူတချို့က၊ ကိုယ်တော်ထံတော်ပါးသို့ ရောက်လာပြီးလျှင် “ဗတ္တိဇံဆရာယောဟန်၏ တပည့်ရို့နှင့် ဖာရိယှဲတပည့်ရို့က အစာယှောင်ကြ၏။ သို့သော် ကိုယ်တော်၏ တပည့်ရို့က ဇာကြောင့် အစာမယှောင်ကြသနည်း” ဟု မိန်းလျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ယေသျှုကလည်း၊ “မင်္ဂလာဆောင်သတို့သား၏ အပေါင်းအပါရို့သည် မင်္ဂလာပွဲ၌ သတို့သားနှင့်အတူ ဟိနိန်ကြသောအခါ၊ ယင်းသူရို့ အစာယှောင်နိန်ကြသလော။ သတို့သားနှင့်အတူ ဟိသောအချိန်ကာလပတ်လုံး သူရို့သည် အစာမယှောင်တတ်ကြ။ ");
INSERT INTO rki_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","သို့သော် သတို့သားကို ထိုသူရို့ပါးက ခွဲယူလားသောနိ့ ရောက်လိမ့်မည်၊ သို့ပြီးမှသာ သူရို့သည် အစာယှောင်ကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“ပိတ်စအသစ်ဖြင့် အထည်ဟောင်းကို ဇာသူမျှ ဖာသားမချ။ ထိုသို့ ဖာသားချသော်လည်း ပိတ်စအသစ်သည် ရုန်း၍ ပိုပြီး စုတ်ပြဲလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ယင်းနည်းတူ သားရီဘူးအဟောင်းထဲ၌ အသစ်သောစပျစ်ရည်ကို ထည့်လေ့မဟိ၊ ထိုသို့ထည့်သော် စပျစ်ရည်အသစ်ကြောင့် သားရီဘူးသည် ပေါက်ကွဲတတ်သည်ဖြစ်၍ နှစ်ခုစလုံး ပျက်စီးလိမ့်မည်။ ယင်းကြောင့် စပျစ်ရည်အသစ်ကို သားရီဘူးအသစ်၌ရာ ထည့်ရမည်” ဟု ထိုသူရို့အား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ဥပုသ်နိ့၌ ကိုယ်တော်သည် ဂျုံခင်းကို ဖြတ်၍လားစဉ်၊ တပည့်တော်ရို့သည် ဂျုံနှံများကို ခြွီယူကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ထိုအခါ ဖာရိယှဲရို့က “ကြည့်ပါ၊ ငါရို့၏ပညတ်ကျမ်းအရ ဥပုသ်နိ့၌ မပြုအပ်သောအမှုတိကို သူရို့က ဇာကြောင့် ပြုကြသနည်း” ဟု ကိုယ်တော့်ကို မိန်းလျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ယေသျှုကလည်း “ယဇ်ပုရောဟိတ်မင်း အဗျာသာလက်ထက်၌ ဒါဝိဒ်သည် ဝမ်းဆာနိန်သောအချိန်တွင် မိမိအဖော်တိနှင့်အတူ၊ ");
INSERT INTO rki_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ဘုရားသခင်၏ အိမ်တော်သို့ ဝင်ပြီးလျှင် အကျွန်ရို့၏ပညတ်ကျမ်းအရ ယဇ်ပုရောဟိတ်တိမှတစ်ပါး ဇာသူမျှ မစားအပ်သော ရှိ့တော်မုန့်ကို စားပြီး — မိမိ၏အဖော်ရို့ကိုလည်း ပီးကြောင်းကို ကျမ်းစာထဲ၌ မဖတ်ဖူးကြသလော” ဟု မိန်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ထို့နောက် ကိုယ်တော်က “ဥပုသ်နိ့အဖို့ လူကို ဖန်ဆင်းထားသည် မဟုတ်။ လူ့အဖို့ရာ ဥပုသ်နိ့ကို သတ်မှတ်ထားခြင်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","ယင်းကြောင့် လူသားသည် ဥပုသ်နိ့၏ အသျှင်သခင် ဖြစ်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ထို့နောက် ယေသျှုသည် တရားဇရပ်သို့ ကြွတော်မူပြန်လျှင်၊ ထိုတရားဇရပ်၌ လက်တစ်ဖက် သီနိန်သောသူ တစ်ယောက်ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ထိုအရပ်၌ ဟိသောလူအချို့သည် ကိုယ်တော့်ကို ပြစ်တင်စွပ်စွဲခွင့် ရခြင်းငှာ ဥပုသ်နိ့၌၊ ထိုသူ၏ရောဂါကို ကိုယ်တော်သည် ပျောက်ကင်းစီတော်မူမည်၊ မမူမည်ကို အနီးကပ် စောင့်ကြည့်နိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ယေသျှုသည် ထိုသူအား “ရှိ့သို့လာ၍ ရပ်လော့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ထို့နောက် ကိုယ်တော်က လူရို့အား “ငါရို့ပညတ်ကျမ်းအရ ဥပုသ်နိ့၌ ကောင်းသောအရာကို ပြုသင့်သလော၊ သို့မဟုတ် ဆိုးသောအရာကို ပြုသင့်သလော။ လူ့အသက်ကို ကယ်သင့်သလော၊ သို့မဟုတ် သတ်သင့်သလော” ဟု မိန်းတော်မူလျှင်၊ လူရို့သည် တိန်းနိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ထိုအခါ ကိုယ်တော်သည် အမျက်ထန်တော်မူ၍ လှည့်ပတ်ကြည့်ပြီး ထိုသူရို့၏စိတ်နှလုံးသည် မိုက်မဲသောကြောင့် ကိုယ်တော်သည် ဝမ်းနည်းတော်မူ၏။ ကိုယ်တော်ကလည်း “သင်၏လက်ကို ဆန့်လော့” ဟု လက်သီနိန်သောသူအား မိန့်တော်မူ၏။ ထိုသူသည် မိမိလက်ကို ဆန့်လျှင် အကောင်းပကဓိ ဖြစ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ထို့ကြောင့် ဖာရိယှဲရို့သည် တရားဇရပ်မှ ချက်ချင်းထွက်ကြပြီးလျှင် ကိုယ်တော့်ကို သတ်ခြင်းငှာ ဟေရုဒ်၏တပည့်ရို့နှင့် ဆွေးနွေးတိုင်ပင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ယေသျှုနှင့် တပည့်တော်ရို့သည် ဂါလိလဲအိုင်နားသို့ ကြွတော်မူ၏။ ဂါလိလဲပြည်၊ ယုဒပြည်မှ လည်းကောင်း၊ ");
INSERT INTO rki_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ယေရုဆလင်မြို့မှစပြီး ဣဒုမဲပြည်နှင့် ယော်ဒန်မြစ် အရှိ့ဖက်ကမ်းမှ လူတိနှင့် တုရုမြို့၊ ဇိဒုန်မြို့ပတ်ဝန်းကျင်အရပ်မှ များစွာသောလူရို့သည် ကိုယ်တော်ပြုတော်မူသော အမှုအရာများကို ကြားတော်မူလျှင် ကိုယ်တော်၏ နောက်တော်သို့ လိုက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ကိုယ်တော်သည် မိမိကို လူအုပ်ကြီး မနင်းမိစီမည့်အကြောင်း လောင်းတစ်စင်းကို အသင့်ထားခြင်းငှာ တပည့်တော်ရို့အား မိန့်မှာတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","အကြောင်းမူကား ကိုယ်တော်သည် မကျန်းမာသော လူတိကို ကျန်းမာစီတော်မူသဖြင့် ရောဂါခံစားနိန်ရသော လူရို့သည် ကိုယ်တော့်ကို တို့ခြင်းငှာ တိုးလာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ဝိညာဉ်ဆိုးတိစွဲသော လူရို့သည်လည်း ကိုယ်တော့်ကို မြင်သောအခါ ရှိ့တော်၌ ပျပ်ဝပ်၍ “ကိုယ်တော်သည် ဘုရားသခင်၏ သားတော်ဖြစ်၏” ဟု ဟစ်အော်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ကိုယ်တော်က မိမိသည် မည်သူဖြစ်ကြောင်းကို မည်သူ့ကိုမျှ ထုတ်ဖော်၍ မပြောစီခြင်းငှာ ဝိညာဉ်ဆိုးများအား တင်းကြပ်စွာ ပညတ်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ထို့နောက် ယေသျှုသည် တောင်ထက်သို့ ကြွတော်မူပြီး အလိုတော်ဟိသော သူရို့ကိုသာ ခေါ်တော်မူ၍ သူရို့သည် အထံတော်ပါးသို့ ရောက်လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ကိုယ်တော်သည် တစ်ဆယ့်နှစ်ယောက်သော လူရို့ကို ရွီးချယ်တော်မူပြီးလျှင် တမန်တော်များဟူ၍ ခေါ်ဝေါ်သမုတ်တော်မူ၏။ ထို့နောက် ထိုသူရို့အား “သင်ရို့ကို ငါ ရွီးချယ်သည်ကား ငါနှင့်အတူ နီစီခြင်းငှာလည်းကောင်း၊ တရားဟောထွက်စီခြင်းငှာ လည်းကောင်း၊ ");
INSERT INTO rki_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","နတ်ဆိုးတိကို မောင်းထုတ်ဖို့ အခွင့်အာဏာ ဟိစီခြင်းငှာ လည်းကောင်း ဖြစ်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ကိုယ်တော် ရွီးချယ်ထားသော တပည့်တော် တစ်ဆယ့်နှစ်ပါး၏ နာမည်ကား၊ (ပေတရုဟု ခေါ်သူ) သျှိမုန်၊ ");
INSERT INTO rki_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","(မိုးကြိုး၏သားများဟု အနက်ကို ရ၍ ဗောနေရဂက်ဟု အမည်သစ်ကိုရသော) ဇေဗေဒဲ၏ သားနှစ်ယောက် ယာကုပ်နှင့် ယောဟန်၊ ");
INSERT INTO rki_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","အန္ဒြေ၊ ဖိလိပ္ပု၊ ဗာသောလမဲ၊ မဿဲ၊ သောမ၊ အာလဖဲ၏သား ယာကုပ်၊ သဒ္ဒဲ၊ မျိုးချစ်စိတ်ထက်သန်သူ သျှိမုန်နှင့် ");
INSERT INTO rki_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ကိုယ်တော့်ကို သစ္စာဖောက်သူ ယုဒသျှာကာရုတ် ရို့ဖြစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ထို့နောက် ယေသျှုသည် အိမ်သို့ဝင်လျှင်၊ လူအပေါင်းရို့သည် တဖန် စုရုံးလာကြသဖြင့် ကိုယ်တော်နှင့် တပည့်တော်ရို့သည် အစားအစာသုံးဆောင်ရန်ပင် အချိန်မရကြ။ ");
INSERT INTO rki_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","လူတချို့က “ကိုယ်တော်ကား စိတ်ဖောက်လားယာ” ဟု ပြောဆိုကြ၏။ ထိုအကြောင်းကို ကိုယ်တော်၏ မိသားစုရို့သည် ကြားကြလျှင် ကိုယ်တော့်ကို စောင့်ရှောက်ခြင်းငှာ အထံတော်သို့ လိုက်လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","ယေရုဆလင်မြို့မှ ရောက်လာကြသော ကျမ်းတတ်ဆရာရို့က “ဤသူကား ဗေလဇေဗုလဟုခေါ်သော နတ်ဆိုးခေါင်းဆောင် ဝင်ပူးခြင်းပင်ဖြစ်၏။ ထိုနတ်ဆိုးဘုရင်ကို အမှီပြု၍သာ နတ်ဆိုးတိကို မောင်းထုတ်ခြင်းဖြစ်သည်” ဟု ပြောဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ယေသျှုသည် ထိုသူရို့ကို ခေါ်ပြီးလျှင် ပုံဥပမာကို ဆောင်၍ “စာတန်မာရ်နတ်က စာတန်မာရ်နတ်ကို ဇာပိုင် မောင်းထုတ်နိုင်မည်နည်း။ ");
INSERT INTO rki_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","အုပ်စုကွဲပြားနိန်သော နိုင်ငံကား မတည်မရပ်နိုင်။ ");
INSERT INTO rki_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","မိသားစု၌လည်း အချင်းချင်းစိတ်ဝမ်းကွဲနိန်လျှင် ယင်းအိမ်ထောင်သည် ရပ်တည်နိုင်မည် မဟုတ်။ ");
INSERT INTO rki_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","ယင်းနည်းတူ စာတန်မာရ်နတ်သည်လည်း အချင်းချင်းမသင့် စိတ်ဝမ်းကွဲလျှင် ထိုသူရို့၏ နိုင်ငံသည် မရပ်မတည်နိုင်ဖြစ်ပြီး ပျက်စီးခြင်းသာ ဖြစ်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“အားကြီးသောသူကို အယင်မတုပ်ဘဲနှင့် ထိုသူ၏အိမ်သို့ ဝင်၍ ပစ္စည်းဥစ္စာများကို ဇာသူလေ့ မလုယူနိုင်။ တုပ်ပြီးမှရာ လုယူနိုင်၏။ ");
INSERT INTO rki_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“သင်ရို့အား ငါ အမှန်ဆိုသည်ကား လူတိက မိမိရို့ လွန်ကျူးသော အပြစ်ဟိသမျှကိုလည်းကောင်း၊ လိမ်လည်သော စကားအမျိုးမျိုးအတွက်လည်းကောင်း အပြစ်ရွှတ်ခွင့်ရနိုင်၏။ ");
INSERT INTO rki_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","သို့ရာတွင် သန့်ယှင်းသောဝိညာဉ်တော်ကို ပြစ်မှားသောသူကား တစ်ခါမျှ အပြစ်မှ လွတ်ခွင့်မရ။ ထိုသူကား ထာဝရအပြစ်ကို ပြုသောသူဖြစ်၏” ဟု မိန့်တော်မူ၏။ ( ");
INSERT INTO rki_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","ဤသို့ မိန့်တော်မူရခြင်းမှာ လူအချို့သည် ကိုယ်တော့်ကို “ဝိညာဉ်ဆိုး ပူးသောသူဟု စွပ်စွဲကြသောကြောင့်ဖြစ်၏။”) ");
INSERT INTO rki_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ထို့နောက် ယေသျှု၏မိခင်နှင့် ညီတော်ရို့သည် ရောက်လာလျှင် အိမ်အပြင်၌ ရပ်လျက်၊ ရောက်နိန်ကြောင်းကို ကိုယ်တော့်ကို ကြားပြောခိုင်း၏။ ");
INSERT INTO rki_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","လူအပေါင်းရို့သည် ကိုယ်တော့်ကို ခြံရံလျက် ထိုင်နိန်ကြ၏။ သူရို့က “ကိုယ်တော်၏ အမိနှင့် ညီတိ၊ ညီမတိ အိမ်အပြင်၌ ရောက်နိန်ပါ၏၊ ထိုသူရို့သည် ကိုယ်တော့်ကို ရှာနိန်ကြ၏” ဟု လျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ကိုယ်တော်က “ငါ့အမိ၊ ငါ့ညီတိကား ဇာသူရို့နည်း” ဟု မိန်းတော်မူပြီး၊ ");
INSERT INTO rki_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","မိမိပတ်လည်တွင် ထိုင်နိန်ကြသောသူရို့အား ကြည့်တော်မူလျက် “ငါ့အမိ၊ ငါ့ညီတိကား၊ ဤသူရို့ပင် ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ဘုရားသခင်၏ အလိုတော်အတိုင်း ဆောင်ရွက်သောသူ မှန်သမျှသည် ငါ့ညီ၊ ငါ့နှမ၊ ငါ့အမိ ဖြစ်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","တဖန် ယေသျှုသည် ဂါလိလဲအိုင်ကမ်းဘေးတွင် ဆုံးမဩဝါဒ ပီးတော်မူစဉ် များစွာသောလူရို့သည် အထံတော်သို့ ရောက်လာကြ၏။ ထိုသို့ လူများသဖြင့် ကိုယ်တော်သည် အိုင်ထဲ၌ဟိသော လောင်းတစ်စင်းထဲသို့ ဝင်၍ ထိုင်တော်မူပြီး ထိုလောင်းကိုလည်း ကမ်းမှ ခွာစီတော်မူ၏။ လူအပေါင်းရို့သည်လည်း ကမ်းခြီရီစပ်နားအထိ ရပ်နိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ထို့နောက် ကိုယ်တော်သည် ပုံဥပမာကိုဆောင်၍ များစွာသော အကြောင်းအရာတိဖြင့် သွန်သင်တော်မူသည်မှာ၊ ");
INSERT INTO rki_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“နားထောင်ကြလော့။ မျိုးစိ့ကြဲသောသူသည် မျိုးစိ့ကြဲခြင်းငှာ ထွက်လားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ယင်းမျိုးစိ့ကို ကြဲသောအခါ၊ အချို့မျိုးစိ့တိက လမ်း၌ ကျသဖြင့် ငှက်များသည် လာ၍ ကောက်စားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","အချို့မျိုးစိ့တိက မြီသားနည်းပြီး ကျောက်ရောမြီ၌ ကျသဖြင့် မြီသားတိမ်သောကြောင့် ထိုမျိုးစိ့သည် အယင် အညှောက်ပေါက်သော်လည်း၊ ");
INSERT INTO rki_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","အမြစ်မစွဲနိုင်သောကြောင့် နီပူသောခါ၊ ချက်ချင်း ညှိုးနွမ်းခြောက်သွိ့လားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","အချို့မျိုးစိ့တိက ဆူးတော၌ ကျသဖြင့် ဆူးပင်တိကြီးထွား၍ ညဉ်းဆဲသောကြောင့် ယင်းအပင်ရို့သည် အသီးကိုမသီးနိုင်ကြ။ ");
INSERT INTO rki_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","အချို့မျိုးစိ့တိက ကောင်းသောမြီ၌ ကျသဖြင့် အပင်ပေါက်၍ ကြီးထွားလျက် အဆသုံးဆယ်၊ အဆခြောက်ဆယ်၊ အဆတစ်ရာ ပွါးများပြီးလျှင် အသီးကို သီးကြ၏။” ");
INSERT INTO rki_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","“ကြားစရာနား ဟိသောသူမည်သည်ကား ကြားပါစီ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","ယေသျှုတစ်ပါးတည်းသာ ဟိနိန်ချိန်၌ တစ်ဆယ့်နှစ်ပါးသော တပည့်တော်နှင့်တကွ ကြားနာသော သူရို့သည် ထိုပုံဥပမာ၏ အဓိပ္ပာယ်ကို မိန်းလျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ကိုယ်တော်ကလည်း “သင်ရို့သည် ဘုရားသခင်နိုင်ငံတော်၏ နက်နဲသောအရာတိကို သိရသောအခွင့်ဟိကြ၏။ သို့သော် အပြင်၌ ဟိသောသူတိကား ပုံဥပမာအားဖြင့်သာ ကြားရကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","အကြောင်းမူကား၊ “ ‘သူရို့သည် ကြည့်လျက်နှင့်ပင် မမြင်ကတ်။ နားထောင်နှင့်လျက်ပင် နားမလည်ကတ်။ အကယ်၍ သူရို့သည် မြင်၍ နားလည်ပြီး၊ ဘုရားသခင်ထံသို့ ပြန်လာကြလျှင်၊ ဘုရားသခင်သည် သူရို့၏အပြစ်ကို ရွှတ်လိမ့်မည်’” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ကိုယ်တော်က “သင်ရို့သည် ဤဥပမာတောင်မှ နားမလည်လျှင် အခြားဥပမာများကို ဇာပိုင် နားလည်နိုင်မည်နည်း။ ");
INSERT INTO rki_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","မျိုးစိ့ကြဲသောသူသည် ဘုရားသခင်၏ တရားစကားကို ကြဲ၏။ ");
INSERT INTO rki_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","တချို့လူတိကား လမ်း၌ကျသော မျိုးစိ့နှင့်တူ၏။ ဘုရားသခင်၏ တရားစကားတော်ကို ကြားကြားချင်းပင် စာတန်မာရ်နတ်သည် လာ၍ ထိုတရားစကားကို နုတ်ယူလား၏။ ");
INSERT INTO rki_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ထိုသို့ တချို့လူတိကား ကျောက်ခံမြီ၌ ကျသောမျိူးစိ့နှင့်တူ၏။ သူရို့သည် တရားစကားကို ကြားကြားချင်း ဝမ်းမြောက်ဝမ်းသာခံယူကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","သို့သော် ထိုတရားစကားသည် သူရို့အထဲ၌ အမြစ်မစွဲ၊ တစ်အောင့်ချေရာ တည်၏။ ထိုတရားစကားကြောင့် ဒုက္ခနှင့် ညှဉ်းပန်းနှိပ်စက်ခြင်းကို ကြုံတွိ့ရသောအခါ သူရို့သည် ဖောက်ပြန်လားတတ်၏။ ");
INSERT INTO rki_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","တချို့လူတိကား ဆူးတောမြီ၌ ကျသော မျိုးစိ့နှင့်တူ၏။ သူရို့လည်း တရားစကားကို ကြားရကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","သို့သော်လည်း သူရို့သည် ဘဝရပ်တည်နိုင်ဖို့အတွက် စိုးရိမ်ကြောင့်ကြစရာများ၊ စည်းစိမ်ချမ်းသာ ခံစားလိုမှုများနှင့် အခြားသော ဆန္ဒလိုအပ်ချက်များ ထွက်ပေါ်လာပြီးလျှင် တရားတော်ကို လွှမ်းမိုးသောကြောင့် ထိုသူရို့၌ အသီးမသီးနိုင်ကြ။ ");
INSERT INTO rki_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","အခြားသော လူတိကား ကောင်းသောမြီ၌ ကျသောမျိုးစိ့နှင့်တူ၏။ ထိုသူရို့တိကား တရားစကားကို ကြား၍ ခံယူကြသောကြောင့် အဆသုံးဆယ်၊ အဆခြောက်ဆယ်၊ အဆတစ်ရာ တိုးပွါးပြီးလျှင် အသီးကို သီးလေ၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ယေသျှုက “ဆီမီးခွက်ကို တောင်းဖြင့် အုပ်ထားလေ့မဟိ။ ကုတင်အောက်၌ ထားလေ့မဟိ။ ဆီမီးခွက်ကို ဆီမီးခုံထက်မှာသာ တင်ထားရမည် မဟုတ်လော။ ");
INSERT INTO rki_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ဖုံးအုပ်လျက် ဟိသမျှသော အရာများသည် ပေါ်လာပြီးလျှင် ကွယ်ဝှက်၍ ထားသမျှသောအရာများသည် ပွင့်လာလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ကြားစရာနားဟိသောသူသည်ကား ကြားကြစီ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ထိုမှတစ်ပါး ကိုယ်တော်က “သင်ရို့ ကြားသောအရာကို ဂရုစိုက်၍ နားထောင်ကြလော့။ သင်ရို့က အခြားသောသူတိကို စစ်ကြောသည်အတိုင်း ဘုရားသခင်သည် သင်ရို့ကို စစ်ကြောစီရင်လိမ့်မည် — ထိုထက်မက ပို၍ ပြင်းစွာသောစစ်ကြောခြင်းကို ခံရလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ရတတ်သောသူကို ပို၍ ပီးလိမ့်မည်။ မဟိသောသူပါးမှလည်း သူရို့၌ ဟိသမျှကိုပင် နုတ်ယူလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","ယေသျှုက “ဘုရားသခင်၏ နိုင်ငံတော်ကား ဤအရာနှင့်တူ၏။ လူတစ်ယောက်သည် မိမိလယ်၌ မျိုးစိ့ကိုကြဲ၏။ ");
INSERT INTO rki_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ယင်းပြီးမှ မကြည့်မမှတ်ဘဲ နိ့နှင့်ည အိပ်လျက်၊ နိုးလျက်နိန်၏။ ထိုစဉ် မျိုးစိ့သည် အညှောက်ထွက်၍ အပင်ပေါက်ကာ ကြီးထွားလေ၏။ ထိုသို့ ဖြစ်လာပုံကို လယ်သျှင်သည် မသိ။ ");
INSERT INTO rki_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","မြီကြီးသည် အလိုအလျောက်အပင်တိကို ကြီးထွားစီ၍ ကောက်နှံကို ဦးစွာ ဖြစ်စီပြီးလျှင် ကောက်ဆံအောင်သော အသီးများကို သီးစီ၏။ ");
INSERT INTO rki_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ယင်းနောက် အသီးမှည့်၍ ရိတ်သိမ်းချိန်ရောက်သောအခါ လယ်သျှင်က တန်းစဉ်ဖြင့် ရိတ်သိမ်းလေ၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","ထို့နောက် ယေသျှုက၊ “ဘုရားသခင်၏ နိုင်ငံတော်ကို ဇာပိုင် ပြောရမည်နည်း။ ဇာပုံဥပမာနှင့် နှိုင်းပြရအံ့နည်းဟူမူကား၊ ");
INSERT INTO rki_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","ဘုရားသခင်၏ နိုင်ငံတော်သည် ဤအရာနှင့်တူ၏။ လူတစ်ယောက်သည် မုန်ညှင်းစိ့တစ်စိ့ကို မြီ၌ စိုက်ပျိုးသောအခါ အစိ့ဟိသမျှထဲတွင် အငယ်ဆုံးဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","စိုက်ပျိုးပြီးနောက် ကြီးထွားလာသောအခါ အခြားသော သီးနှံပင်တိထက် ပို၍ ကြီးထွား၏။ ယင်းအပင်၌ ငှက်တိပင် အရိပ်ခို၍ အသိုက်ဆောက်နိုင်လောက်အောင် အကိုင်းအခက်တိကို ဖြစ်စီတတ်၏” ဟုမိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ထိုသို့သော ပုံဥပမာများအားဖြင့် ကိုယ်တော်သည် ပရိသတ်ရို့ နားလည်နိုင်သည့်အတိုင်း တရားတော်ကို ဟောပြောတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ပုံဥပမာများနှင့်ကင်း၍ ဇာချင့်တရားကိုမျှ ဟောတော်မမူ။ ကိုယ်တော်သည် တပည့်တော်ရို့အား လူပရိသတ်များ ကင်းယှင်းချိန်၌ ဟောခသမျှသော အရာတိကို ယှင်းပြတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ထိုနိ့ ညနီချမ်းအချိန်တွင် ကိုယ်တော်က တပည့်တော်ရို့အား “အိုင်ကမ်းတစ်ဖက်သို့ ကူးကြကုန်အံ့” ဟု မိန့်တော်မူလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","တပည့်တော်ရို့သည် လူစုလူဝေးမှ ထွက်ကာ ကိုယ်တော်ဟိနှင့်ပြီးသော လောင်းထက်သို့ တက်၍ ကိုယ်တော်နှင့်အတူ ရွက်ရွှင့်ကြ၏။ အခြားသော လောင်းများလည်း လိုက်ပါကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ထိုအခါ ရုတ်တရက် ပြင်းထန်သော လီမုန်တိုင်းတိုက်ခတ်လာ၍ လှိုင်းများထသောကြောင့် လောင်းထဲ၌ ရီပြည့်လုပြည့်ချင် ဖြစ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ကိုယ်တော်မူကား လောင်း၏ပဲ့ပိုင်း၌ ခေါင်းအုံးထက်တွင် ကျိန်းစက်လျက် နီတော်မူ၏။ တပည့်တော်ရို့သည် ကိုယ်တော့်ကို နှိုးပြီးလျှင် “ဆရာ၊ အကျွန်ရို့ သီဘေးနှင့် ကြုံနိန်ရသည်ကို ဥပေက္ခာပြုတော်မူပါသည်လော” ဟု မိန်းလျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ကိုယ်တော်သည် ထ၍ လီနှင့်လှိုင်းများအား “တိတ်ဆိတ်ငြိမ်ဝပ်စွာ နီလော့” ဟု အမိန့်ပီးတော်မူလျှင် လီသည်ငြိမ်၍ လှိုင်းသည် မထလီယာ။ ");
INSERT INTO rki_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","ထို့နောက် ကိုယ်တော်သည် တပည့်တော်ရို့အား “ဇာတွက်နှင့် ဤမျှလောက် ကြောက်ကြသနည်း။ ဇာကြောင့် ယုံကြည်ခြင်း မဟိသနည်း” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ထိုအခါ သူရို့သည် အလွန်ကြောက်လန့်၍ “ဤလူကား ဇာပိုင်လူလဲ၊ လီနှင့်လှိုင်းတောင်မှ ဤလူ၏ အမိန့်ကို လိုက်နာကြ၏” ဟု အချင်းချင်း ပြောဆိုနိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ယေသျှုနှင့် တပည့်တော်ရို့သည် ဂါလိလဲအိုင် တစ်ဖက်ကမ်းဟိ ဂါရစဒေသသို့ ရောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ယေသျှုသည် လောင်းမှ ဆင်းတော်မူသည်နှင့်တစ်ပြိုင်နက် ဝိညာဉ်ဆိုးပူးသော သူတစ်ယောက်သည် ကိုယ်တော့်ကို တွိ့ခြင်းငှာ သင်္ချိုင်းမှ ထွက်လာလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ထိုသူသည် သင်္ချိုင်းအုတ်ဂူများကြား၌ နိန်တတ်ပြီး၊ သူ့ကို ဇာသူတစ်ယောက်မျှ သံကြိုးနှင့်တုပ်၍ မထားနိုင်။ ");
INSERT INTO rki_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ထိုသူအား လက်ထိတ်၊ ခြီကျဉ်းရို့ကို သံကြိုးများဖြင့် အကြိမ်ကြိမ်တုပ်ထားခဖူး၏။ သို့သော် ထိုကြိုးများသာ ပြတ်လား၏။ ဇာသူမျှ သူ့ကို ထိန်းချုပ်၍ မရ။ ထိုသူသည် ခွန်အားကြီးသောသူဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ထိုသူသည် သင်္ချိုင်းအုတ်ဂူများကြား၌ သော်လည်းကောင်း၊ တောင်ကုန်းများအထက်၌ သော်လည်းကောင်း နိ့၊ ညမပြတ် ဟစ်အော်၍ လှည့်ပတ်လားလာကာ ကျောက်စောင်းနှင့် ကိုယ်ကို ပြတ်စီ၏။ ");
INSERT INTO rki_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ထိုသူသည် အဝီးမှ ယေသျှုကို မြင်လျှင် ဗြီးလာကာ ရှိ့တော်၌ ပျပ်ဝပ်လျက်၊ ");
INSERT INTO rki_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","“အမြင့်ဆုံးသော ဘုရားသခင်၏ သားတော်ယေသျှု၊ ကိုယ်တော်သည် အကျွန်နှင့် ဇာသို့ ဆိုင်သနည်း။ အကျွန့်အား မညှဉ်းဆဲပါကေ့။ ဘုရားသခင်ကို တိုင်တည်၍ တောင်းဆိုပါ၏” ဟု ကျယ်သောအသံဖြင့် အော်ဟစ်တောင်းပန်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ထိုသို့ လျှောက်ထားသည့်အကြောင်းကား ယေသျှုသည် ထိုသူအား “ဆိုးညစ်သောဝိညာဉ်၊ ဤလူထဲက ထွက်လော့” ဟု မိန့်တော်မူသောကြောင့် ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","ကိုယ်တော်က “သင်၏နာမည်ကား မည်သို့နည်း” ဟု မိန်းတော်မူလျှင်၊ ထိုဝိညာဉ်ဆိုးက၊ “အကျွန်၏အမည်ကား၊ ‘လေဂေါင်’ ဖြစ်ပါ၏ — အကျွန်ရို့က အများဖြစ်ပါ၏” ဟု လျှောက်ထားပြီးမှ၊ ");
INSERT INTO rki_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","မိမိရို့အား ထိုအရပ်မှ နှင်ထုတ်တော် မမူစီခြင်းငှာ အကြိမ်ကြိမ်တောင်းပန်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ထိုအချိန်၌ တောင်ခါးစောင်း၌ ကျက်စားနိန်သော ဝက်အုပ်တစ်အုပ်ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ထိုဝိညာဉ်ဆိုးတိက “အကျွန်ရို့အား ထိုဝက်တိပါးသို့ ဝင်ပူးရသော အခွင့်ကို ပီးတော်မူပါ” ဟု တောင်းပန်ကြလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ကိုယ်တော်သည် ချက်ချင်း အခွင့်ပီးတော်မူ၏။ ထိုဝိညာဉ်ဆိုးရို့သည် ထိုသူပါးမှ ထွက်၍ ဝက်တိ၌ ဝင်ကြ၏။ အကောင်ရွီအားဖြင့် ၂,၀၀၀ ခန့် ဟိသော ဝက်အုပ်သည် — အိုင်ကမ်းထောင်းစောက်သို့ တစ်ဟုန်ထိုးဗြီးဆင်း၍ အိုင်၌ နစ်မွမ်းသီဆုံးကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ဝက်ကျောင်းသော သူရို့သည် မြို့၊ ရွာများသို့ ဗြီး၍ သတင်းတော်ကို ပြောကြသဖြင့်၊ လူရို့သည် ထိုအမှုအရာများအား ကြည့်ရှုအံ့သောငှာ လာရောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ထိုသူရို့သည် ယေသျှုထံပါးသို့ ရောက်လာသောအခါ နတ်ဆိုးရို့ဝင်ပူးသောသူသည် အဝတ်ကို ဝတ်လျက် လူကောင်းပကတိအတိုင်း ထိုင်နိန်သည်ကို မြင်လျှင် အလွန်ကြောက်ရွံ့ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ထိုအဖြစ်ပျက်ကို မျက်မြင်တွိ့ရသောသူရို့က နတ်ဆိုးပူးသောသူနှင့် ဝက်အုပ်၌ ဖြစ်ပျက်ခသောအရာများကို နောက်ရောက်ဟိလာကြသော လူတိအား ပြောပြကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ထို့ကြောင့် ထိုသူရို့သည် ကိုယ်တော့်ကို မိမိရို့ဒေသမှ ထွက်လားရန် တောင်းပန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ကိုယ်တော်သည် လောင်းထက်သို့ တက်တော်မူစဉ် နတ်ဆိုးပူးခဖူးသောသူသည် ကိုယ်တော်နှင့်အတူ လိုက်ပါခွင့်ပြုစီခြင်းငှာ တောင်းပန်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","သို့သော်လည်း ကိုယ်တော်သည် ခွင့်ပြုတော်မမူဘဲ၊ “သင့်အိမ်သို့ လားပြီးလျှင် သခင်ဘုရားသည် သင်၌ သနားခြင်းကရုဏာနှင့် ဇာလောက်ကျေးဇူးပြုသည်ကို ဆွီမျိုးသားချင်းရို့အား ပြောပြလော့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ထို့ကြောင့် ထိုသူသည် ထွက်လား၍၊ ယေသျှုသည် မိမိ၌ ဇာမျှလောက် ကျေးဇူးပြုတော်မူကြောင်းကို၊ မြို့ဆယ်မြို့ဟိသော ဒေကာပေါလိပြည် တလျှောက်လုံးတွင် အနှံ့အပြား ပြောကြားရာ ကြားရသောသူရို့သည် အံ့ဩကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ထို့နောက် ယေသျှုသည် ကမ်းတစ်ဖက်သို့ ပြန်ကူး၍ အိုင်နား၌ ဟိတော်မူစဉ် များစွာသောလူရို့သည် အထံတော်သို့ စုရုံးလာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ထိုအခါ ယာဣရုဟု အမည်ဟိသူ တရားဇရပ်မှူးတစ်ယောက်သည် လာ၍ ယေသျှုကို မြင်လျှင် ခြီတော်ရင်း၌ ပျပ်ဝပ်လျက်၊ ");
INSERT INTO rki_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","“အကျွန်၏သမီးသျှေ သီဖို့ ဖြစ်နိန်ယာ။ ထိုအသျှေကို အသက်ရှင်ကျန်းမာစီခြင်းငှာ ကိုယ်တော်ကြွပြီးလျှင် အသျှေထက်မှာ လက်တော်ကို တင်ပီးတော်မူပါ” ဟု ကိုယ်တော့်ကို အနူးအညွှတ်တောင်းပန်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ထို့ကြောင့် ယေသျှုသည် ထိုသူနှင့်လိုက်လား၏။ များစွာသောလူရို့သည် ဝိုင်းအုံလျက် လိုက်သဖြင့် ကိုယ်တော့်ကို တို့မိ၊ ထိမိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ထိုအခါ မိန်းမတစ်ယောက်သည် တစ်ဆယ့်နှစ်နှစ်ပတ်လုံး သွီးသွန်နာခံစားရ၍၊ ");
INSERT INTO rki_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ဆီးသမားပေါင်းစုံ၌ ကုသမှုကို ခံယူသောကြောင့် မိမိ၌ ဟိသမျှသောဥစ္စာများပင် ကုန်ဆုံးသော်လည်း သက်သာခြင်းမဟိသည့်အပြင် အခြေအနေပို၍ ဆိုးဝါးလာ၏။ ");
INSERT INTO rki_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","သူမသည် ယေသျှု၏ သတင်းတော်ကို ကြားသည်ဟိသော်၊ “ထိုသူ၏အဝတ်တော်ကို အကျွန်သည် တို့ထိခွင့်ရလျှင် ဤရောဂါမှ ပကတိကျန်းမာလားမည်” ဟု ဆိုလျက်၊ လူအပေါင်းရို့ကြားမှ တိုးဝင်းကာ ကိုယ်တော်၏ နောက်တော်သို့ ရောက်လာ၍ အဝတ်တော်ကို တို့လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ထိုသို့ တို့ပြီးသည်နှင့် ချက်ချင်း သွီးသွန်ခြင်း တန့်လားသည်ဖြစ်၍ မိမိကိုယ်ခန္ဓာ၌ ထိုရောဂါ ပျောက်ကင်းသည်ကို သိလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ယေသျှုသည် မိမိကိုယ်မှ တန်ခိုးထွက်သည်ကို ချက်ချင်း သိတော်မူလျှင်၊ နောက်တော်သို့ လှည့်၍ “ငါ့ အဝတ်ကို ဇာသူ တို့သနည်း” ဟု မိန်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","တပည့်တော်တိကလည်း “ကိုယ်တော်၊ ဤမျှလောက် လူတိကြိတ်ကြိတ်တိုးကာ လိုက်နိန်ကြသည်ကို မြင်လျက်နှင့်ပင် ‘ငါ့ကို ဇာသူ တို့သနည်း’ ဟု မိန်းတော်မူသိမ့်လော” ဟု မိန်းလျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","သို့ရာတွင် ကိုယ်တော်သည် မိမိအား မည်သူ တို့သည်ကို သိတော်မူခြင်းငှာ လှည့်ပတ်ကြည့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ထိုအမျိုးသမီးသည် မိမိ၌ မည်သို့ဖြစ်သည်ကို သိသောကြောင့် ကြောက်ရွံ့တုန်လှုပ်လျက်၊ ရှိ့တော်သို့ လာရောက်ပျပ်ဝပ်၍ ဖြစ်သမျှသော အကြောင်းအရာတိကို အဟုတ်အမှန် ကြားလျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ယေသျှုကလည်း “ငါ့သမီး၊ သင်၏ယုံကြည်ခြင်းသည် သင့်ကို ကျန်းမာစီယာ၊ စိတ်ချလက်ချရာ ပြန်လားလီ၊ သင်၏အနာရောဂါပျောက်ကင်းစီ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ထိုသို့ မိန့်တော်မူစဉ် ယာဣရု၏အိမ်မှ လူသည် ရောက်လာ၍ “သင်၏ သမီးကား သီယာ။ ဤဆရာကို ဇာတွက် ဒုက္ခပီးနိန်သိမ့်သနည်း” ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ယေသျှုသည် ထိုသူရို့၏စကားကို ကြားသော်လည်း၊ စိတ်နှလုံးထဲ၌ မထားဘဲ ထိုသူအား “မကြောက်ကေ့။ ယုံကြည်ခြင်းသာ ဟိလော့” ဟု တရားဇရပ်မှူးအား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ထို့နောက် ကိုယ်တော်သည် ပေတရု၊ ယာကုပ်နှင့် ယာကုပ်ညီ ယောဟန်ရို့ မှတစ်ပါး မည်သူကိုမျှ မလိုက်စီဘဲ၊ ");
INSERT INTO rki_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ယာဣရု၏အိမ်သို့ကြွ၍ ရောက်လျှင် လူရို့သည် အုတ်အုတ်သဲသဲ ပြုနိန်ကြသည်ကိုလည်းကောင်း၊ လွန်စွာ မြည်တမ်းငိုကြွီးနိန်ကြသည်ကိုလည်းကောင်း မြင်တော်မူလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ကိုယ်တော်သည် အိမ်ထဲသို့ ဝင်၍ “ဇာကြောင့် ဝိုင်းအုံ၍ ငိုနိန်ကြသနည်း။ ဤသူငယ်မသျှေ သီကျလားသည် မဟုတ် — အိပ်ပျော်နိန်ခြင်းသာ ဖြစ်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","ထိုအခါ လူရို့သည် ကိုယ်တော့်ကို လှောင်ပြောင်ကြ၏။ ကိုယ်တော်သည် ထိုသူရို့ကို အပြင်သို့ ထွက်ခိုင်းစီပြီးမှ သူငယ်မ၏ မိဘတိနှင့် တပည့်တော်သုံးယောက်ကို ခေါ်၍ သူငယ်မသျှေဟိရာ အခန်းသို့ ဝင်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ကိုယ်တော်သည် သူငယ်မသျှေ၏ လက်ကိုဆုပ်ကိုင်ကာ “တလိသကုမိ” ဟု မိန့်တော်မူ၏။ အနက်ကား “မိန်းမငယ် ထလော၊ ငါ ဆို၏” ဟု ဆိုလိုသတည်း။ ");
INSERT INTO rki_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ထိုသို့ မိန့်တော်မူပြီးနောက် သူငယ်မသျှေသည် ချက်ချင်းထ၍ လမ်းလျှောက်လေ၏။ ထိုသူငယ်မသျှေကား တစ်ဆယ့်နှစ်နှစ် သမီးအရွယ် ဖြစ်၏။ ထိုအခါ လူရို့သည် အလွန်အံ့သြကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ကိုယ်တော်ကလည်း ထိုအမှုအရာကို မည်သူ့ကိုမျှ မပြောစီခြင်းငှာ ထိုသူရို့အား တင်းကြပ်စွာမိန့်တော်မှုပြီးလျှင် “ဤသူငယ်မသျှေကို စားစာရာ တစ်စုံတစ်ခု ကျွေးလော့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","ယေသျှုသည် တပည့်တော်ရို့နှင့်အတူ ထိုအရပ်မှကြွ၍ မိမိနီသောမြို့သို့ ရောက်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ဥပုသ်နိ့ ရောက်သောအခါ ကိုယ်တော်သည် တရားဇရပ်၌ ဟောပြောသွန်သင်တော်မူ၏။ လူအပေါင်းရို့သည် ကိုယ်တော်၏ သွန်သင်တော်မူချက်ကို ကြားရလျှင် အံ့သြကြသည်ဖြစ်၍ “ဤသူကား ဤပညာကို ဇာကရသနည်း။ ဤသူရဟိသော ပညာကား ဇာမျိုး ပညာနည်း။ ဇာပိုင် ဤနိမိတ်လက္ခဏာတိကို ပြနိုင်သနည်း။ ");
INSERT INTO rki_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","ဤသူကား လက်သမား မဟုတ်လော။ မာရိ၏သား မဟုတ်လော။ ယာကုပ်၊ ယောသေ၊ ယုဒနှင့် သျှိမုန်ရို့၏ အစ်ကို မဟုတ်လော။ သူ့နှမလည်း ဤအရပ်၌ နီသည် မဟုတ်လော” ဟု ပြောဆိုကြ၏။ သို့ဖြစ်၍ သူရို့သည် ကိုယ်တော့်ကို လက်မခံကြပေ။ ");
INSERT INTO rki_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ယေသျှုကလည်း “ပရောဖက်မည်သည်ကား မိမိနီရင်းမြို့၊ ဆွီမျိုး၊ မိသားစုမှတစ်ပါး ဇာအရပ်မှာမဆို ဂုဏ်အသရေဟိ၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ကိုယ်တော်သည် ထိုမြို့တွင် ဖျားနာသူ တချို့ကိုသာ လက်တော်တင်၍ ကျန်းမာစီတော်မူသည် မှတစ်ပါး မည်သည့် နိမိတ်လက္ခဏာကိုမျှ ပြုတော်မမူ။ ");
INSERT INTO rki_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ကိုယ်တော်သည် ထိုသူရို့၏ ယုံကြည်ခြင်းကင်းမဲ့သည်ကို အံ့သြတော်မူ၏။ ထို့နောက်၊ ယေသျှုသည် အနီးအနား၌ဟိသော ကျေးရွာများသို့ လား၍ ဟောပြောသွန်သင်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ကိုယ်တော်သည် တပည့်တော် တစ်ဆယ့်နှစ်ပါးရို့အား အထံတော်သို့ ခေါ်ပြီးလျှင် နှစ်ယောက်စီတွဲ၍ စီရွှတ်ကာ သူရို့အား ဝိညာဉ်ဆိုးများကို နိုင်ရသောအခွင့်ကိုလည်း ပီးတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ကိုယ်တော်က “သင်ရို့၊ လမ်းခရီးအတွက် တောင်မွိ့မှအပ ဇာတစ်ခုကိုမျှ ယူမလားကေ့ — ရိက္ခာ၊ လွယ်အိတ်နှင့် သင်၏ခါး၌ ဖေသာဒင်္ဂါးတိကို ကျိတ်ယူမလားကေ့။ ");
INSERT INTO rki_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ခြီနင်းကို စီးကြလော့။ အင်္ကျီအပိုလည်း မယူကေ့။ ");
INSERT INTO rki_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ဇာမြို့၌မဆို သင်ရို့ကိုလက်ခံသော အိမ်တွင် ယင်းအရပ်မှ မထွက်ခွာသည်ထိတိုင်အောင် တည်းနိန်ကြလော့။ ");
INSERT INTO rki_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","မြို့တစ်မြို့သို့ ဝင်သောအခါ ယင်းအရပ်မှ လူတိက သင်ရို့ကို လက်မခံ၊ ဟောပြောသမျှကို နားမထောင်လျှင်၊ ယင်းနီရာက ထွက်လာကြလော့။ ယင်းသို့ ထွက်လာသောခါ သူရို့တစ်ဖက်၌ သက်သီဖြစ်စီခြင်းငှာ သင်ရို့ခြီဖဝါးက မြီမှုန့်ကို ခါချပစ်ခလော့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","တပည့်တော်ရို့သည် ထွက်လား၍ လူရို့အား၊ နောင်တနှင့်ဆိုင်သော သတင်းစကားကို ဟောပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","သူရို့သည် များစွာသောနတ်ဆိုးတိကို နှင်ထုတ်ပြီးလျှင်၊ ဖျားနာသောသူတိကို ဆီနှင့်လူး၍ ကျန်းမာစီကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ယေသျှု၏ သတင်းတော်သည် ကျော်ကြားလာသဖြင့် ဟေရုဒ်မင်းကြီး၏ နားတော်သို့ ရောက်လားလေ၏။ လူတချို့က “ဗတ္တိဇံဆရာယောဟန်သည် သီရာကနိန် ပြန်ရှင်လာယာ။ ယင်းကြောင့် နိမိတ်လက္ခဏာများကို ပြနိုင်ခြင်းဖြစ်၏” ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","လူတချို့က “ထိုသူသည် ဧလိယဖြစ်၏” ဟု ဆိုကြ၏။ တချို့ကလည်း “အယင်က ပရောဖက်ကဲ့သို့ ပရောဖက် တစ်ပါးဖြစ်၏” ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ထိုအကြောင်းအရာများကို ဟေရုဒ်မင်းကြီးကြားလျှင် “ဤသူကား၊ ငါ ဂေါင်းဖြတ်သတ်ခသော ယောဟန်သည် အဂု အသက်ပြန်ရှင်လာယာ” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","အထက်က ဟေရုဒ်မင်းသည် ညီဖြစ်သူ ဖိလိပ္ပု၏မယား၊ ဟေရောဒိကို သိမ်းယူသောအမှုနှင့် ပတ်သက်၍ ယောဟန်ကို ဖမ်းဆီးပြီးလျှင် ထောင်၌ ချုပ်ထားစီ၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","အကြောင်းမူကား ယောဟန်သည် ဟေရုဒ်အား “သင့်ညီ၏မယားကို မသိမ်းယူအပ်” ဟု အကြိမ်ကြိမ်ပြောသောကြောင့်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ထို့ကြောင့် ဟေရောဒိသည် ယောဟန်ကို ရန်ငြိုးဖွဲ့၍ သတ်လိုသော်လည်း ဟေရုဒ်ကြောင့် အခွင့်မရနိုင်။ ");
INSERT INTO rki_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","အကြောင်းမူကား ယောဟန်သည် ကောင်းမြတ်ပြီး၊ သန့်ယှင်းသူဖြစ်ကြောင်းကို ဟေရုဒ် သိသဖြင့် ကြောက်၍ စောင့်ရှောက်လျက် ထား၏။ ယောဟန်၏ ဟောပြော သွန်သင်ချက်များကို ကြားနာရသောအခါ၌ စိတ်အနှောက်အယှက်ဖြစ်သော်လည်း ဝမ်းမြောက်စွာနှင့်ပင် ကြားနာလေ့ ဟိသောကြောင့်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ထို့နောက် ဟေရုဒ်၏ မွီးနိ့ပွဲ၌ ဟေရောဒိအတွက် အခါအခွင့် ရောက်လာ၏။ ဟေရုဒ်သည် မိမိ၏ မွီးနိ့ပွဲ၌ ဂါလိလဲပြည်မှ ခေါင်းဆောင်ကြီးတိ၊ စစ်သူကြီးတိ၊ မှူးမတ်တိကို ဖိတ်ကြား၍ ကျွေးမွေးတော်မူစဉ်၊ ");
INSERT INTO rki_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ဟေရောဒိ၏ သမီး သည် ဝင်၍ ကပြဖျော်ဖြေသဖြင့် ဟေရုဒ်နှင့် ဧည့်သည်တော်အပေါင်းရို့၏ စိတ်ကို ရွှင်လန်းစီ၏။ ဟေရုဒ်မင်းက သူမအား “သင် ဇာကို လိုချင်သနည်း။ သင် နှစ်သက်သည်ကို တောင်းလော့၊ သင့်အား ငါ ပီးမည်။ ");
INSERT INTO rki_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ငါ၏နိုင်ငံ တစ်ဝက်တိုင်အောင် သင် တောင်းသမျှကို ငါ ပီးမည်” ဟု ကျိန်ဆို၍ ပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","သူမသည် မင်းကြီးထံပါးမှ ထွက်၍ မိခင်အား “အကျွန်၊ ဇာကို တောင်းရပါမည်နည်း” ဟု မိန်း၏။ မိခင်က “ဗတ္တိဇံဆရာယောဟန်၏ ဦးဂေါင်းကိုသာ တောင်းလော့” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","သူမသည် ချက်ချင်း မင်းကြီးထံပါးသို့ တဖန်ဝင်ပြီးလျှင် “ဗတ္တိဇံဆရာ ယောဟန်၏ ဦးဂေါင်းကို ဗျ့ထက်မှာ တင်ပြီးလျှင် အဂု ပီးတော်မူပါ” ဟု လျှောက်၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ထိုအခါ မင်းကြီးသည် လွန်စွာဝမ်းနည်းသော်လည်း အာဂန္တုရို့ အရှိ့၌ မိမိကျိန်ဆိုပီးခသော ကတိကို ထောက်၍ သူမ တောင်းလျှောက်သည်ကို မငြင်းပယ်လိုပေ။ ");
INSERT INTO rki_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ထို့ကြောင့် ယောဟန်၏ ဦးဂေါင်းကို ယူလာစီခြင်းငှာ အစောင့်တစ်ယောက်အား ချက်ချင်း အမိန့်ပီးလေ၏။ ထိုသူသည် အကျဉ်းထောင်သို့ လား၍ ယောဟန်၏ ဦးဂေါင်းကို ဖြတ်ပြီးလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ဗျ့၌ ထည့်၍ ယူဆောင်လာကာ ထိုမိန်းမငယ်အား ပီးလေသော်၊ သူမသည် ယူ၍ မိခင်အား ပီးလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ယောဟန်၏ တပည့်ရို့သည် ထိုသတင်းတော်ကို ကြားသောအခါ လာ၍ ယောဟန်၏အလောင်းကို သယ်ဆောင်လားပြီးလျှင် ဂူသွင်းသင်္ဂြိုလ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","တမန်တော်ရို့သည် ယေသျှုထံတော်သို့ ပြန်လာပြီးလျှင်၊ မိမိရို့ လုပ်ဆောင်ခသမျှသောအရာနှင့် သွန်သင်ခသမျှသောအရာများကို လျှောက်တင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","များစွာသောလူရို့သည် ဝင်ထွက်လားလာလျက် ဟိကြသည်ဖြစ်၍၊ ကိုယ်တော်နှင့် တပည့်တော်ရို့သည် အစားအစာ သုံးဆောင်ခြင်းငှာ အချိန်ပင် မရကြပေ။ ထို့ကြောင့် ကိုယ်တော်က “ငါရို့၊ ဆိတ်ငြိမ်ရာ နီရာသို့ လားပြီးလျှင် တအောင့်ချေလောက် အနားယူကြကုန်အံ့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ထို့ကြောင့် ကိုယ်တော်နှင့်အတူ တပည့်တော်ရို့သည် လောင်းစီး၍ ဆိတ်ငြိမ်ရာ အရပ်သို့ လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ထိုသို့ ထွက်လားသည်ကို လူရို့သည်မြင်၍ ကိုယ်တော်ဖြစ်သည်ကို သိကြလျှင် အမြို့မြို့၊ အရွာရွာမှ လူအပေါင်းရို့သည် ကိုယ်တော်လားရာ အရပ်သို့ ကုန်းကြောင်းဖြင့် အယင် လားကြသည်ဖြစ်၍ ကိုယ်တော်နှင့်တပည့်တော်ရို့ မရောက်ခင် ရောက်နှင့်နိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ကိုယ်တော်သည် လောင်းမှ တက်လာတော်မူသောအခါ လူထုကြီးကို မြင်လျှင်၊ ထိုသူရို့သည် ထိန်းသူမဟိသော သိုးများကဲ့သို့ ဖြစ်သောကြောင့် သူရို့ကို သနားတော်မူသဖြင့် များစွာသောတရားစကားကို ဟောပြောသွန်သင်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ယင်းနိ့ နီဝင်စပြုသောအခါ တပည့်တော်ရို့သည် အထံတော်ပါးသို့ ချဉ်းကပ်ပြီးလျှင် “ဤအရပ်ကား၊ လူသူမဟိသော အရပ်ဖြစ်ပါ၏။ မိုးလည်း ချုပ်ယာ။ ");
INSERT INTO rki_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ဤလူတိကို ပတ်ဝန်းကျင်ဟိ တောရွာများနှင့် ယာတောများသို့ စားစရာဝယ်စီခြင်းငှာ စီရွှတ်တော်မူပါ” ဟု လျှောက်ထားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ကိုယ်တော်က “သူရို့အား စားစရာတစ်စုံတစ်ခုကို သင်ရို့ပီးကြလော့” ဟု မိန့်တော်မူ၏။ တပည့်တော်တိက “အကျွန်ရို့သည် ငွီဒင်္ဂါးပြား ၂၀၀ ဖို့ အစားအစာဝယ်ပြီးလျှင် ဤသူရို့ကို ကျွေးရမည်လော” ဟု လျှောက်ထားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ကိုယ်တော်ကလည်း၊ “သင်ရို့၌ မုန့်ဇာလောက်ဟိသည်ကို လား၍ကြည့်လော့” ဟု မိန့်တော်မူ၏။ တပည့်တော်ရို့သည် ရှာ၍တွိ့သောအခါ “မုန့်ငါးလုံးနှင့် ငါးနှစ်ကောင် ဟိပါ၏” ဟု လျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","ထိုအခါကိုယ်တော်သည် လူအပေါင်းရို့ကို စိမ်းလန်းသောမြက်ခင်းထက်၌ အုပ်စုလိုက်ထိုင်စီခြင်းငှာ တပည့်တော်ရို့အား စီခိုင်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","လူရို့သည် တစ်ရာစု၊ ငါးဆယ်စုဖြင့် စီတန်း၍ထိုင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","ထို့နောက် ကိုယ်တော်သည် မုန့်ငါးလုံးနှင့်ငါးနှစ်ကောင်ကို ယူ၍ ကောင်းကင်သို့ မျှော်ကြည့်လျက် ဘုရားသခင်၏ ကျေးဇူးတော်ကို ချီးမွမ်းပြီးမှ မုန့်ကို ဖဲ့တော်မူပြီးလျှင် လူတိကို ဝီငှစီခြင်းငှာ တပည့်တော်ရို့အား ပီးတော်မူ၏။ ထိုနည်းတူ ငါးနှစ်ကောင်ကိုလည်း ခွဲဝီပီးတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","လူအပေါင်းရို့သည် ဝစွာစားကြပြီးမှ၊ ");
INSERT INTO rki_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","မုန့်နှင့်ငါး အကြွင်းအကျန်ကို ကောက်သိမ်းကြရာတွင် တစ်ဆယ့်နှစ်တောင်း အပြည့်ရကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","မုန့်ကိုစားသော ယောက်ျားအရီအတွက်ကား လူ ၅,၀၀၀ မျှလောက် ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ထို့နောက် ကိုယ်တော်သည် လူအပေါင်းရို့ကို ပြန်စီတော်မူစဉ်၊ တပည့်တော်ရို့အား လောင်းထက်သို့ ချက်ချင်း တက်စီပြီး အိုင်တစ်ဖက်ကမ်း၌ဟိသော ဗက်ဇဲဒရွာသို့ ဦးစွာ ကူးနှင့်စီတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ကိုယ်တော်သည် လူအပေါင်းရို့ကို နှုတ်ဆက်ပြီးမှ ဆုတောင်းပတ္ထနာပြုခြင်းငှာ တောင်ထက်တစ်နီရာသို့ တက်ကြွတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ညအချိန်ရောက်သောအခါ လောင်းသည် အိုင်အလယ်၌ ဟိနိန်၏။ ကိုယ်တော်မူကား ကုန်းထက်၌ တစ်ယောက်တည်းဟိနိန်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","တပည့်တော်ရို့သည် လီမသင့်သောကြောင့် တက်ဖြင့်လှော်ခတ်၍ ညောင်းရိ့ကြသည်ကို ကိုယ်တော်သည်မြင်လျှင် ရီထက်မှ စက်တော်ဖြန့်၍ တပည့်တော်ရို့ပါးသို့ ကြွလာတော်မူ၏။ ထိုအချိန်ကား မိုးသောက်ယံဖြစ်၏။ ကိုယ်တော်သည် သူရို့အနားမှ ကျော်ဖြတ်ခြင်းငှာ ပြု၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ထိုသို့ ရီထက်မှာ စက်တော်ဖြန့်၍ ကြွတော်မူသည်ကို သူရို့သည် မြင်လျှင် “စစ္ဆီ” ဟု ထင်မှတ်ပြီး အော်ကျွီးကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ထိုသူအပေါင်းရို့သည် ကိုယ်တော့်ကို မြင်သောအခါ ထိတ်လန့်ကြောက်ရွံ့ကြ၏။ ကိုယ်တော်သည် ချက်ချင်းနှုတ်ဆက်၍ “မစိုးရိမ်ကတ်ကေ့။ မကြောက်ကတ်ကေ့။ ငါ ရာဖြစ်၏” ဟု သူရို့အား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ထို့နောက် ကိုယ်တော်သည် တပည့်တော်ရို့ဟိရာ၊ လောင်းထက်သို့ တက်တော်မူလျှင် လီသည် ငြိမ်းလေ၏။ ထိုသူရို့လည်း လွန်စွာအံ့သြကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","အကြောင်းမှာ သူရို့၏စိတ်နှလုံးသည် မာကြောလျက် ဟိသောကြောင့် လူ ၅,၀၀၀ ကို ကျွေးမွေးခြင်းနှင့်ပတ်သက်၍ ပြသောတန်းခိုးတော်၏ အဓိပ္ပာယ်ကို နားမလည်ကြ။ ");
INSERT INTO rki_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ကိုယ်တော်နှင့် တပည့်တော်ရို့သည် အိုင်တစ်ဖက်သို့ ကူးပြီး ဂင်္နေသရက်မြို့သို့ ရောက်ကြလျှင် လောင်းကို ကပ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","လောင်းထက်မှ ဆင်းလျှင်ဆင်းချင်း လူရို့သည် ယေသျှုကို မှတ်မိကြသည်ဖြစ်၍၊ ");
INSERT INTO rki_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ကိုယ်တော်သည် မည်သည့်အရပ်၌ ဟိတော်မူကြောင်းကို ကြားကြသောအခါ ပတ်ဝန်းကျင်အရပ်ရပ်သို့ ဗြီးပြီးလျှင် လူနာတိကို သူရို့၏ အိပ်ရာများဖြင့် ထမ်းလာခကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ကိုယ်တော်ကြွတော်မူရာ မြို့၊ ရွာနှင့် ယာတောများမှ လူနာတိကို ဈီးများ၌ ချထားကြ၏။ ကိုယ်တော်၏ အဝတ်တော်ပန်းဖွားကိုမျှ လူနာရို့အား တို့၊ ထိခွင့် ရစီခြင်းငှာ တောင်းပန်ကြ၏။ ထိုသို့ တို့၊ ထိခွင့်ရသမျှသော လူရို့သည် ကျန်းမာလာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","ထိုအခါ ယေရုဆလင်မြို့မှ လာသော ဖာရိယှဲတချို့နှင့် ကျမ်းတတ်ဆရာတချို့သည် ယေသျှုအပါး၌ လာရောက်စုဝေးကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ယေသျှု၏ တပည့်တော်တချို့သည် မစင်ကြယ်သော လက်တည်းဟူသော ရီမဆီးသောလက်ဖြင့် အစာစားကြသည်ကို တွိ့မြင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ဖာရိယှဲရို့နှင့် ယုဒအမျိုးသားရို့သည် ရှီးလူကြီးရို့၏ သွန်သင်ချက်နှင့်အညီ လက်မဆီးဘဲ အစာစားလေ့ မဟိကြ။ ");
INSERT INTO rki_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ဈီးမှဝယ်လာသမျှ အရာအားလုံးကိုလည်း အယင် မဆီးကြောဘဲ မစားကြ။ အိုး၊ ခွက်၊ ကြီးဖလားနှင့် အိပ်ရာများကို ဆီးကြောလျှော်ဖွတ်ပြီးမှ အသုံးပြုကြ၏။ အခြားသော ဓလေ့အစဉ်အလာများကိုလည်း သူရို့သည် လိုက်နာကျင့်သုံးကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ထို့ကြောင့် ဖာရိယှဲနှင့် ကျမ်းတတ်ဆရာရို့က၊ “ကိုယ်တော်၏တပည့်ရို့သည် ရှီးလူကြီးရို့၏ ထုံးတမ်းအစဉ်အလာကို ဇာကြောင့် လိုက်နာကျင့်သုံးခြင်းမဟိဘဲ၊ မစင်ကြယ်သောလက်ဖြင့် စားကြသနည်း” ဟု ကိုယ်တော့်ကို မိန်းလျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ယေသျှုကလည်း “သင်ရို့အဖို့ ပရောဖက်ဟေသျှာယ ဟောပြောသည်ကား ကောင်းကောင်းမှန်၏။ သင်ရို့က သူတော်ကောင်း ယောင်ဆောင်သောသူတိဖြစ်၏။ ယင်းကြောင့် ဟေသျှာယက သင်ရို့ကို ရည်မှတ်၍ ရီးထားသည်ကား၊ “ ‘ဤလူမျိုးသည် နှုတ်ခမ်းနှင့်သာ ငါ့ကို ရိုသီကြ၏။ စိတ်နှလုံးမူကား ငါနှင့်ဝီးကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","လူ့ပညတ်တိကို ငါ၏ ပညတ်တရားကဲ့သို့ သွန်သင်ကြပြီးလျှင်၊ ငါ့ကို အချည်နှီး ကိုးကွယ်ကြ၏။’ ");
INSERT INTO rki_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“သင်ရို့သည် ဘုရားသခင်၏ ပညတ်ကို ပယ်၍ လူရို့၏ဓလေ့ ထုံးတမ်းကိုသာ လိုက်နာကြ၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","တဖန် ကိုယ်တော်က၊ “သင်ရို့သည် မိမိရို့၏ ထုံးတမ်းအစဉ်အလာတိကို ကျင့်သုံးနိုင်ဖို့အတွက် ဘုရားသခင်၏ပညတ်ကို လိမ္မာပါးနပ်စွာ ပယ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","သင်၏မိဘကို ရိုသီစွာပြုလော့။ မိဘကို ကျိန်ဆဲသောသူသည် အသီသတ်ခြင်းကို ခံစီဟု မောသျှေက ပညတ်ထားခ၏။ ");
INSERT INTO rki_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","သို့သော် သင်ရို့က အကြင်သူ၌ မိဘကိုကူညီခြင်းငှာ ပစ္စည်းတစ်စုံတစ်ခု ဟိလျက်နှင့် ယင်းပစ္စည်းကို ‘ကော်ဘန်’ ဟုခေါ်သော ဘုရားသခင်အဖို့ လှူထားပြီးသော ပစ္စည်းဖြစ်၏ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ထိုသူသည် သားသမီးရို့ ပြုအပ်သောဝတ်ကို ပြုဖို့မလိုဟု သွန်သင်၏။ ");
INSERT INTO rki_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ယင်းပိုင် သင်ရို့ လက်ဆင့်ကမ်းပီးသော ထုံးတမ်းစဉ်လာတိနှင့် ဘုရားသခင်၏ နှုတ်ကပက်တော်ကို ပယ်ကြ၏။ ထိုသို့ အခြားသော အကျင့်ဓလေ့များကိုလည်း သင်ရို့သည် ပြုကြ၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","ထို့နောက် ကိုယ်တော်သည် လူပရိသတ်ရို့အား တဖန်ခေါ်တော်မူပြီးလျှင်၊ “သင်ရို့အားလုံး ငါ့စကားကို နာယူ၍ နားလည်သိမှတ်ကြလော့။ ");
INSERT INTO rki_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","လူ၏ပြင်ပမှ ဝင်သောအရာ တစ်စုံတစ်ခုမျှ လူကို မညစ်ညမ်းစီနိုင်။ လူ၏အတွင်းမှ ထွက်သောအရာကသာ လူကို ညစ်ညမ်းစီနိုင်၏။” ");
INSERT INTO rki_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ကိုယ်တော်သည် ပရိသတ်အစုအဝေးဟိရာမှ ထ၍ အိမ်ထဲသို့ ကြွတော်မူသောအခါ တပည့်တော်ရို့သည် ကိုယ်တော်မိန့်တော်မူခသော ပုံဥပမာများ၏ အဓိပ္ပာယ်များကို မိန်းလျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","ကိုယ်တော်က “သင်ရို့သည် ဤမျှပင် အသိဉာဏ် မဟိကြသလော။ အပြင်မှ လူ၏အတွင်းသို့ ဝင်သမျှသည် စိတ်နှလုံးထဲသို့မဝင်၊ အစာအိမ်ထဲသို့ ဝင်ပြီးလျှင် ရီအိမ်ထဲသို့ ဆင်းလားသောကြောင့် လူ၏ကိုယ် အတွင်းသို့ ဝင်သောအရာတိကား လူကို မညစ်ညမ်းစီနိုင်ကြောင်းကို နားမလည်ကြသလော” ဟု မိန့်တော်မူ၏။ (ဤသို့ မိန့်တော်မူခြင်းမှာ မသန့်ယှင်းသော အစားအစာ မဟိကြောင်းကို ဆိုလိုသတည်း။) ");
INSERT INTO rki_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","တဖန် ကိုယ်တော်က “လူအတွင်းမှ ထွက်လာသော အရာများသာ လူကို ညစ်ညမ်းစီသော အရာဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","လူ၏အတွင်း စိတ်နှလုံးထဲက ထွက်လာသော ညစ်ညမ်းသော အကြံအစည်၊ ကာမဂုဏ်လိုက်စားခြင်း၊ သူ့မယားကို ပြစ်မှားခြင်း၊ တရားမဲ့ပြုမူခြင်း၊ ");
INSERT INTO rki_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","သူ့ဥစ္စာကို ခိုးခြင်း၊ လူ့အသက်ကို သတ်ခြင်း၊ လောဘလွန်ကျူးခြင်း၊ ဆိုးယုတ်မိုက်မဲခြင်း၊ လိမ်လည်ခြင်း၊ မနာလိုခြင်း၊ သူ့အသရေကို ဖျက်ခြင်း၊ မာနထောင်ခြင်း၊ လျှပ်ပေါ်ခြင်း — ");
INSERT INTO rki_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","စသော ဤအရာအားလုံးရို့သည် လူ၏ကိုယ်အတွင်းမှ ထွက်လာ၍ လူကို ညစ်ညမ်းစီသော အရာများဖြစ်ကြ၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ထို့နောက် ယေသျှုသည် ထိုအရပ်မှထွက်၍ တုရုမြို့နယ်သို့ ကြွတော်မူ၏။ ရောက်လျှင်၊ အိမ်တစ်အိမ်တွင် ဝင်၍ တည်းခိုတော်မူ၏။ မိမိရောက်ကြောင်းကို ဇာသူ့ကိုမျှ မသိစီလိုသော်လည်း ပုန်းအောင်း၍ မနိန်နိုင်ပေ။ ");
INSERT INTO rki_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ဝိညာဉ်ဆိုးပူးသော မိန်းမသျှေတစ်ယောက်၏ အမိသည် ယေသျှု ရောက်သည်ကို ကြားလျှင် ချက်ချင်း ရောက်လာ၍ ခြီတော်ရင်း၌ ပျပ်ဝပ်ပြီးနိန်၏။ ");
INSERT INTO rki_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","သူမသည် တစ်ပါးအမျိုး၊ ယှုရိပြည် ဖိနိတ်နယ်သူ ဖြစ်၏။ မိမိ၏သမီးပါးမှ နတ်ဆိုးကို နှင်ထုတ်ပီးတော်မူခြင်းငှာ ကိုယ်တော့်ကို တောင်းပန်၏။ ");
INSERT INTO rki_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ကိုယ်တော်ကလည်း၊ “သားသမီးတိကို ဦးစွာ ဝအောင်ကျွေးရ၏။ သားသမီးတိအဖို့ ကောင်းသောအစာကို ယူပြီးလျှင် ခွီးတိအား မကျွေးအပ်” ဟု သူမအား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ထိုအမျိုးသမီးကလည်း “မှန်ပါ၏အသျှင်၊ ထိုသို့ဆိုသော်လည်း သားသမီးရို့၏ စားကြွင်း၊ စားကျန်တိကို စားပွဲအောက်မှ ခွီးတိစားရကြပါ၏” ဟု ပြန်၍ လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ထိုအခါ ယေသျှုက “သင်သည် ဤသို့ လျောက်ပတ်စွာ လျှောက်ထားသောကြောင့် အိမ်သို့ ပြန်လားလော့၊ နတ်ဆိုးသည် သင်၏သမီး အထဲက ထွက်လားယာ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ထိုအမျိုးသမီးသည် မိမိအိမ်သို့ ပြန်၍ အိပ်ရာထဲ၌ လဲနိန်သော သူမ၏သမီးပါးမှ နတ်ဆိုးထွက်လားကြောင်းကို တွိ့ရလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","တုရုဒေသမှ အပြန်တွင် ယေသျှုသည် ဇိဒုန်မြို့ကိုလည်းကောင်း၊ ဒေကာပေါလိပြည် အလယ်ပိုင်းကိုလည်းကောင်း ဖြတ်၍ ဂါလိလဲအိုင်သို့ ကြွတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ထိုအခါ လူတချို့သည် ဆွံ့အ၍၊ နားပင်းနိန်သော လူတစ်ယောက်ကို အထံတော်သို့ ခေါ်ဆောင်ခပြီး၊ ထိုသူ၏အထက်တွင် လက်တော်ကို တင်ပါမည့်အကြောင်း၊ ကိုယ်တော့်ကို တောင်းပန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ယေသျှုသည် ထိုသူအား လူပရိသတ်အထဲမှ ခေါ်ထုတ်ပြီးလျှင် ထိုသူ၏ နားနှစ်ဖက်လုံးကို လက်ညှိုးတော်ဖြင့် တို့တော်မူ၏။ တန်းတွီးထွီး၍ ထိုသူ၏လျှာကိုလည်း တို့တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ထို့နောက် ကောင်းကင်သို့ မျှော်ကြည့်ပြီး သက်ပြင်းချကာ၊ “ဧဖသ” ဟု မိန့်တော်မူ၏။ အဓိပ္ပာယ်ကား “ပွင့်စီ” ဟူ၍ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ချက်ချင်းပင် ထိုသူ၏နားသည် ပွင့်၍၊ လျှာသည်လည်း သွက်လက်လာသဖြင့် ထိုသူသည် စကားပီသစွာ ပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","ကိုယ်တော်သည် လူတိအား ဤအဖြစ်အပျက်ကို မည်သူ့ကိုမျှ မပြောကြားစီခြင်းငှာ တားမြစ်တော်မူ၏။ ထိုသို့ တားမြစ်သော်လည်း လူရို့သည် ထိုသတင်းတော်ကို သာ၍ ကြားပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ထိုအဖြစ်အပျက်၊ အကြောင်းအရာများကို ကြားရသောသူရို့သည် လွန်စွာအံ့သြကြလျက် “ကိုယ်တော်သည် ခပ်သိမ်းသော အမှုအရာများကို လျောက်ပတ်စွာ ပြုတော်မူယာ။ နားမကြားသော သူတိကို ကြားစီတော်မူပြီး၊ စကားအသော သူတိကိုလည်း စကားပြောနိုင်စီ၏” ဟု ပြောဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ထိုအခါ အခြားသောလူရို့လည်း လာရောက်စုရုံးကြ၏။ သူရို့၌ စားစရာတစ်ခုမျှ မဟိသဖြင့်၊ ယေသျှုသည် တပည့်တော်ရို့ကို ခေါ်၍၊ ");
INSERT INTO rki_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“ဤသူရို့ကို ငါသည် သနား၏။ အကြောင်းမူကား သူရို့သည် သုံးရက်ပတ်လုံး ငါနှင့်အတူ ဟိနိန်ကြ၏။ အဂု သူရို့၌ စားစရာတစ်ခုလေ့ မဟိ။ ");
INSERT INTO rki_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","တချို့က ခရီးဝီးကနိန် လာကြသည်ဖြစ်၍ သူရို့ကို မကျွေးမမွီးဘဲနှင့် အိမ်သို့ ပြန်ရွှတ်လိုက်လျှင်၊ ဝမ်းဆာသောကြောင့် လမ်း၌ မူးလဲကျလားလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","တပည့်တော်ရို့ကလည်း ကိုယ်တော့်ကို “ဤတောကန္တာရတွင် ဤလူတိကို ဇာပိုင် ဝအောင်ကျွေးနိုင်မည်နည်း” ဟု မိန်းလျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ယေသျှုက “သင်ရို့၌ မုန့်ဇာလောက် ဟိသနည်း” ဟု မိန်းတော်မူလျှင်၊ တပည့်တော်ရို့က “မုန့်၊ ခုနစ်လုံး ဟိပါ၏” ဟု လျှောက်ထားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ကိုယ်တော်သည် လူရို့ကို မြီထက်၌ ထိုင်စီခြင်းငှာ မိန့်တော်မူ၏။ ထို့နောက် ကိုယ်တော်သည် မုန့်ခုနစ်လုံးကို ယူပြီးလျှင် ဘုရားသခင်၏ ကျေးဇူးတော်ကို ချီးမွမ်းပြီးမှ မုန့်ကိုဖဲ့၍ လူအပေါင်းရို့အား ဝီပီးစီခြင်းငှာ တပည့်တော်ရို့ကို စီခိုင်းတော်မူသဖြင့် တပည့်တော်ရို့လည်း မိန့်တော်မူသည့်အတိုင်း ပြုတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","သူရို့၌ ငါးသျှေ အနည်းချေ ဟိကြသည်ဖြစ်၍ ကျေးဇူးတော်ကို ချီးမွမ်းပြီးမှ လူအပေါင်းရို့အား ဝီပီးစီခြင်းငှာ တပည့်တော်ရို့အား စီခိုင်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","လူအပေါင်းရို့သည်လည်း ဝစွာစားကြပြီးမှ — စားကြွင်းစားကျန်များပင်လျှင် တောင်းဖြင့် ခုနစ်တောင်းအပြည့် ကောက်သိမ်းရကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","မုန့်စားသောသူ အရီအတွက်ကား ၄,၀၀၀ မျှ ဟိသတည်း။ ယေသျှုသည် လူအပေါင်းရို့ကို ထိုအရပ်မှ ပြန်ရွှတ်တော်မူပြီးမှ၊ ");
INSERT INTO rki_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","တပည့်တော်ရို့နှင့်အတူ လောင်းထက်သို့ တက်၍ ဒါလမနုသဒေသသို့ ကြွတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ထိုအခါ ဖာရိယှဲတချို့သည် ယေသျှုထံသို့ လာ၍ ဆွေးနွေးငြင်းခုံကြ၏။ သူရို့သည် အပြစ်ရှာလိုသောစိတ်ဖြင့် ကိုယ်တော့်ကို ဘုရားသခင်သည် နှစ်သက်တော်မူကြောင်းကို သက်သီဖြစ်စီခြင်းငှာ ကောင်းကင်မှဖြစ်သော နိမိတ်လက္ခဏာ တစ်ပါးပါးကို ပြတော်မူရန် တောင်းဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","သို့ရာတွင် ယေသျှုသည် သက်ပြင်းချတော်မူပြီး “အဂုခေတ်လူရို့သည် ဇာကြောင့် နိမိတ်လက္ခဏာကို တောင်းဆိုကြသနည်း။ ငါ အမှန်အကန်ဆိုသည်ကား ဤသူရို့ကို ဇာနိမိတ်လက္ခဏာကိုမျှ ငါ မပြ” ဟု မိန့်တော်မူပြီးလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ထိုသူရို့ပါးမှ ထွက်ကြွတော်မူ၍ လောင်းထက်သို့ တဖန်တက်ကာ အိုင်တစ်ဖက်သို့ ကူးတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","တပည့်တော်ရို့သည် အစားအစာ လုံလောက်စွာ ယူလာခြင်းငှာ မိ့ကျန်ကြသည်ဖြစ်၍ လောင်းထက်တွင် သူရို့၌ မုန့်တစ်လုံးသာ ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ယေသျှုက “သင်ရို့သည် ဖာရိယှဲရို့၏ တဆီးနှင့် ဟေရုဒ်၏တဆီးကို သတိဖြင့် ယှောင်ကြလော့” ဟု တပည့်တော်ရို့အား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","တပည့်တော်ရို့ကလည်း “ငါရို့၌ မုန့် တစ်ခုမျှ မဟိသောကြောင့် ကိုယ်တော်သည် ဤသို့ ပြောခြင်းဖြစ်၏” ဟု ပြောဆိုနိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ထိုသို့ ပြောဆိုနိန်ကြသည်ကို ယေသျှုသည် သိတော်မူလျှင် “သင်ရို့၌ မုန့်တစ်ခုမျှ မဟိသည်ကို ဇာကြောင့် ပြောနိန်ကြသနည်း။ အဂုထိတောင် မသိ၊ နားမလည်ကြသိမ့်သလော။ သင်ရို့သည် ဇာကြောင့် အသိဉာဏ်နည်းကြသနည်း။ ");
INSERT INTO rki_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","သင်ရို့တွင် မျက်စိဟိယင့်နှင့်ပင် — မမြင်၊ နားဟိယင့်နှင့်ပင် — မကြားကြသလော။ ");
INSERT INTO rki_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ငါသည် မုန့်ငါးလုံးကို ဖဲ့၍ လူ ၅,၀၀၀ ကို ဝစွာကျွေးပြီးမှ အကြွင်းအကျန်ကို ကောက်သိမ်းရာတွင် တောင်းအပြည့် ဇာနှစ်တောင်း ရသည်ကို သင်ရို့ မမှတ်မိကြသလော” ဟု မိန်းတော်မူလျှင်၊ တပည့်တော်ရို့က “တစ်ဆယ့်နှစ်တောင်းအပြည့် ကောက်သိမ်းရပါ၏” ဟု ပြန်လျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","တဖန် ယေသျှုကလည်း “ငါသည် မုန့်ခုနစ်လုံးကို ဖဲ့ပြီးလျှင် လူပေါင်း ၄,၀၀၀ ကို ဝစွာကျွေးပြီးမှ အကြွင်းအကျန်ကို ကောက်သိမ်းရာတွင် အပိုတောင်းအပြည့် ဇာနှစ်တောင်း ရသနည်း” ဟု မိန်းတော်မူလျှင်၊ “ခုနစ်တောင်းအပြည့် ကောက်သိမ်းရပါ၏” ဟု တပည့်တော်ရို့က ပြန်၍ လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ကိုယ်တော်ကလည်း “သို့ပင်သျှောင် သင်ရို့က နားမလည်ကြသိမ့်သလော” ဟု တပည့်တော်ရို့အား မိန်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","သူရို့သည် ဗက်ဇဲဒမြို့သို့ ရောက်လာကြသည်ဟိသော် လူတချို့သည် မျက်မမြင်တစ်ဦးကို ယေသျှုထံသို့ ခေါ်ဆောင်လာပြီးလျှင် ထိုသူအား တို့ထိခြင်းကို ပြုတော်မူစီမည့်အကြောင်း တောင်းပန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ယေသျှုသည် မျက်စိမမြင်သောသူ၏ လက်ကိုဆွဲ၍ ရွာပြင်သို့ ခေါ်လားတော်မူပြီးလျှင် ထိုသူ၏မျက်စိကို တန်းထွီးဖြင့်ထွီးကာ ထိုသူအထက်မှာ လက်တော်ကို တင်လျက် “သင် တစ်ခုခုကို မြင်ရသလော” ဟု မိန်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ထိုသူသည် အထက်သို့ မောကြည့်၍ “လူတိကို မြင်ရပါ၏။ သို့ပင်သျှောင်လည်း ထိုသူရို့သည် သစ်ပင်ပိုင် ဖြစ်ပြီးလျှင် လမ်းလျှောက်နိန်ကြပါ၏” ဟု လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ထိုအခါ၊ ယေသျှုသည် ထိုသူ၏မျက်စိ၌ လက်တော်ကို တဖန် တင်တော်မူ၍ ကြည့်စီတော်မူပြန်၏။ ထိုသူသည်လည်း အားစိုက်၍ကြည့်ရာ မျက်စိအလင်းကိုရ၍ အရာခပ်သိမ်းကို ယှင်းလင်းစွာမြင်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ယေသျှုကလည်း “ရွာထဲသို့ ပြန်မဝင်ကေ့” ဟု ပညတ်တော်မူ၍ သူ၏အိမ်သို့ ရွှတ်လိုက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ထို့နောက် ယေသျှုနှင့် တပည့်တော်ရို့သည် ဖိလိပ္ပုကဲသရိမြို့ အနီးအနား၌ဟိသော ကျေးရွာများသို့ ကြွတော်မူစဉ် လမ်းခရီး၌ “ငါ့ကို ဇာသူဖြစ်သည်ဟူ၍ လူတိက ပြောနိန်ကြသနည်း” ဟု တပည့်တော်တိအား မိန်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","တပည့်တော်ရို့ကလည်း “တချို့က ကိုယ်တော့်ကို ဗတ္တိဇံဆရာယောဟန် ဖြစ်ကြောင်းကို ပြောကြ၏၊ တချို့က ဧလိယဖြစ်သည်ဟု ပြောနိန်ကြ၏၊ တချို့က အသျှင်ကို ပရောဖက် တစ်ပါးဖြစ်သည်ဟု ဆို၏” ဟု လျှောက်ထားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","ထိုအခါ ကိုယ်တော်က “သင်ရို့က ငါ့ကို ဇာသူဖြစ်သည်ဟု ပြောမည်နည်း” ဟု မိန်းတော်မူလျှင်၊ ပေတရုက “ကိုယ်တော်သည် မေသျှိယဖြစ်၏” ဟု လျှောက်တင်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ထိုအခါ ယေသျှုက “ငါသည် ဇာသူဖြစ်ကြောင်းကို တစ်ယောက်ကိုမျှ မပြောကတ်ကေ့” ဟု တပည့်တော်ရို့အား ပညတ်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","ထို့နောက် ယေသျှုသည် တပည့်တော်ရို့အား “လူသားသည် ဒုက္ခကြီးစွာ ခံရလိမ့်မည်။ ဘာသာရေးခေါင်းဆောင်တိ၊ ယဇ်ပုရောဟိတ်အကြီးအကဲတိနှင့် ကျမ်းတတ်ဆရာတိက လူသားကို ငြင်းပယ်ကြလိမ့်မည်။ ထိုသူသည် အသီသတ်ခြင်းကို ခံရမည်။ သုံးရက်မြောက်သောနိ့၌ ရှင်ပြန်ထမြောက်လိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ကိုယ်တော်သည် ဤသွန်သင်ချက်အား လျှို့ဝှက်ခြင်း အလျှင်းမဟိဘဲ မိန့်ကြားတော်မူသဖြင့် ပေတရုသည် ကိုယ်တော့်ကို မိမိနှင့်အတူ ဘေးနားသို့ ပင့်ခေါ်၍ အပြစ်တင်သောစကားကို လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","ယေသျှုသည် မျက်နှာတော်ကိုလှည့်၍ တပည့်တော်ရို့ကို ကြည့်တော်မူလျှက် ပေတရုအား “အချင်း မာရ်နတ်၊ ငါ့ထံပါးက ထွက်လားလော့။ သင်၏အတွေးကား ဘုရားသခင်ထံပါးက လာခြင်း မဟုတ်၊ လူ၏အတွေးသာ ဖြစ်၏” ဟု ဆုံးမတော်၏။ ");
INSERT INTO rki_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ယေသျှုသည် တပည့်တော်ရို့နှင့် လူပရိသတ်ရို့ကို မိမိထံပါးသို့ ခေါ်တော်မူပြီးလျှင် “ငါ့တပည့် ဖြစ်လိုသောသူသည် ကိုယ့်ကိုယ်ကို ငြင်းပယ်ရမည်။ ကိုယ့်လက်ဝါးကပ်တိုင်ကို ထမ်း၍ ငါ့နောက်သို့ လိုက်ရမည်။ ");
INSERT INTO rki_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","မိမိအသက်ကို ကယ်လိုသောသူကား အသက်ဆုံးယှုံးလိမ့်မည်။ ငါ့ကြောင့် သော်လည်းကောင်း၊ ဧဝံဂေလိတရားကြောင့် သော်လည်းကောင်း မိမိ၏အသက်ကို ဆုံးယှုံးသောသူကား အသက်ကိုရလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","လူသည် ဤလောကတစ်ခုလုံးကို အုပ်စိုးရသော်လည်း မိမိ၏အသက်ကို ဆုံးယှုံးလျှင် ဇာချင့် အကျိုးဟိမည်နည်း။ ");
INSERT INTO rki_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","မိမိအသက်ကို ဆုံးယှုံးလျှင် ဇာနှင့်မျှ မရွီးယူနိုင်။ ");
INSERT INTO rki_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ဖောက်ပြန်၍၊ ဒုစရိုက်တိနှင့် ပြည့်နိန်သော ဤလောက၌ အကြင်သူသည် ငါနှင့် ငါ၏သြဝါဒကို ရှက်လျှင်၊ လူသားသည်လည်း အဖခမည်းတော်၏ ဘုန်းတန်ခိုးတော်ကို ဆောင်၍ သန့်ယှင်းသော ကောင်းကင်တမန်ရို့နှင့် ကြွလာသောအခါ ထိုသူကို ရှက်လိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ထို့နောက် ကိုယ်တော်က “သင်ရို့ကို ငါ အမှန်ဆိုသည်ကား ဘုရားသခင်၏ နိုင်ငံတော်သည် တန်ခိုးအာဏာနှင့်တကွ တည်သည်ကို ဤအရပ်၌ဟိသော လူတချို့သည် မမြင်ရဘဲ၊ မသီဆုံးရကြ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","ခြောက်ရက်လွန်သောအခါ ယေသျှုသည် ပေတရု၊ ယာကုပ်နှင့် ယောဟန်ရို့မှတစ်ပါး အခြားတစ်ယောက်မှ မပါဘဲ မြင့်သောတောင်တစ်ခုထက်သို့ ခေါ်ဆောင်လားတော်မူ၏။ ထိုအခါ ယေသျှုသည် သူရို့၏ရှိ့၌ အဆင်းသဏ္ဌာန်တော် ပြောင်းလဲ၍၊ ");
INSERT INTO rki_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","အဝတ်တော်လည်း တောက်ပြောင်လျက် — ဤလောက၌ မည်သည့်ခဝါသည်မှ မတတ်နိုင်အောင် ဖြူဖွီးလျက်ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","တပည့်တော် သုံးပါးရို့ရှိ့တွင် ဧလိယနှင့် မောသျှေရို့သည် ပေါ်လာ၍ ယေသျှုနှင့် စကားပြောနိန်ကြသည်ကို မြင်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ထိုအခါ ပေတရုက ယေသျှုအား၊ “ဆရာ၊ ဤအရပ်၌ နီဖို့ကောင်းပါ၏။ ယင်းကြောင့် အသျှင်ဖို့ တဲတစ်ဆောင်၊ မောသျှေအဖို့ တဲတစ်ဆောင်နှင့် ဧလိယအဖို့ တဲတစ်ဆောင်၊ တဲသုံးဆောင်ကို အကျွန်ရို့ဆောက်ပါရစီ” ဟု လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","အကြောင်းမူကား တပည့်တော်ရို့သည် အလွန်ကြောက်ရွံ့သောကြောင့် ပေတရုသည် ထိုသို့ ယောင်းယမ်း၍ လျှောက်ထားခြင်းပင် ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ထိုအခါ မိုးတိမ်တိုက်သည် ပေါ်လာပြီး သူရို့အား အုပ်မိုး၍ “ဤသူကား ငါ နှစ်သက်မြတ်နိုးရာ ငါ၏ချစ်သားဖြစ်ပေ၏ — သူ၏စကားကို နားထောင်ကြလော့” ဟု မိုးတိမ်တိုက်မှ အသံတော် ထွက်ပေါ်လာ၏။ ");
INSERT INTO rki_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ထိုအခါ တပည့်တော်ရို့သည် ချက်ချင်း မိမိရို့ပတ်လည်သို့ လှည့်ပတ်ကြည့်ရှုလျှင် ယေသျှုမှတစ်ပါး အခြားမည်သူ့ကိုမျှ မတွိ့ကြပေ။ ");
INSERT INTO rki_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ထို့နောက် ကိုယ်တော်နှင့် တပည့်တော်ရို့သည် တောင်ထက်မှ ဆင်းလာစဉ် ကိုယ်တော်က “သင်ရို့ တွိ့မြင်ခသော အမှုအရာများကို လူသားသည် သီခြင်းမှ မထမြောက်မီတိုင်အောင် ဇာသူ့ကိုမျှ မပြောကတ်ကေ့” ဟု တပည့်တော်ရို့အား ပညတ်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","တပည့်တော် တစ်ဆယ့်နှစ်ပါးရို့သည် ထိုပညတ်ချက်ကို လိုက်နာကြသော်လည်း “သီခြင်းမှ ထမြောက်သည်ဟု ဆိုသည်ကား မည်သို့နည်း” ဟု အချင်းချင်း ဆွေးနွေးမိန်းမြန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ထို့နောက် သူရို့သည် ယေသျှုအား “ကျမ်းတတ်ဆရာရို့က ဧလိယသည် အယင်ကြွလာလိမ့်မည်ဟု ဇာတွက် ပြောဆိုကြသနည်း” ဟု မိန်းလျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ကိုယ်တော်ကလည်း “အမှုအရာ အားလုံးကို အသင့်ပျင်ဆင်ဖို့ ဧလိယသည် အယင်ကြွလာရသည်ကား မှန်ပေ၏။ သို့ရာတွင် ကျမ်းစာတော်မြတ်၌ ‘လူသားသည် များစွာသော ဒုက္ခဆင်းရဲခြင်းကိုလည်းကောင်း၊ ငြင်းပယ်ခြင်းကိုလည်းကောင်း ခံရမည်’ ဟု ရီးထားသည်ကား ဇာပိုင်နည်း။ ");
INSERT INTO rki_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","သို့သော် သင်ရို့အား ငါ အမှန်ဆိုသည်ကား ဧလိယသည် ကြွလာခပြီးယာ။ သူ၏အကြောင်းကို ကျမ်းစာ၌ ရီးထားသည်ကား ‘လူရို့သည် သူ့အား ပြုချင်သမျှကို ပြုခယာ’ ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","သူရို့သည် အခြားသောတပည့်တော်များ ဟိရာသို့ ရောက်လာကြသောအခါ လူပရိသတ်ရို့သည် သူရို့ပတ်လည်၌လည်းကောင်း၊ ကျမ်းပြုဆရာရို့သည်လည်း သူရို့နှင့် အငြင်းအခုံ ပြောဆိုနိန်ကြသည်ကိုလည်းကောင်း မြင်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","စုဝေးလျက်ဟိကြသော လူရို့သည် ယေသျှုကိုမြင်လျှင် အံသြခြင်းဟိလျက် အထံတော်သို့ ဗြီး၍ နှုတ်ဆက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ယေသျှုသည် တပည့်တော်ရို့အား “သင်ရို့သည် ဤသူရို့နှင့် ဇာအကြောင်းကို ငြင်းခုံ ပြောဆိုနိန်ကြသနည်း” ဟု မိန်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","လူစုလူဝေးထဲမှ လူတစ်ယောက်က “ဆရာ၊ ဝိညာဉ်ဆိုးဝင်ပူးပြီး စကားအနိန်သော အကျွန်၏သားသျှေကို ကိုယ်တော်ထံသို့ ခေါ်လာပါ၏။ ");
INSERT INTO rki_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ဝိညာဉ်ဝင်ပူးသည့်အခါတိုင်း သားသျှေသည် မြီကြီးထက်မှာ လဲကျတတ်ပါ၏။ ပါးစပ်မှလည်း အမြှုပ်ထွက်၍ အံသွားကြိတ်ကာ ခန္ဓာကိုယ်ကိုလည်း မာတောင့်စီပါ၏။ ဆရာတပည့်တိကို ယင်းဝိညာဉ်အား နှင်ထုတ်ပီးစီခြင်းငှာ တောင်းပန်သော်လည်း သူရို့သည် မတတ်နိုင်ကြပါ” ဟု ကိုယ်တော့်ကို လျှောက်ထား၏။ ");
INSERT INTO rki_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ကိုယ်တော်က “အို၊ ယုံကြည်ခြင်း မဟိသောအမျိုး၊ ငါသည် သင်ရို့နှင့် ဇာလောက်ကြာကြာနီရမည်နည်း။ ဇာလောက်ကြာကြာ သင်ရို့ကို သည်းခံရမည်နည်း။ ယင်းသူငယ်ကို ငါ့ပါးသို့ ယူလာကြလော့” ဟု မိန့်တော်မူသည်အတိုင်း၊ ");
INSERT INTO rki_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","သူရို့သည် သူငယ်အား ယေသျှုထံသို့ ယူလာကြ၏။ ထိုဝိညာဉ်သည် ယေသျှုကို မြင်လျှင်မြင်ချင်း သူငယ်အား ပြင်းစွာတုန်တတ်စီပြီး မြီထက်သို့ လဲကျကာ လူးလိမ့်လျက် သူငယ်၏ပါးစပ်မှ အမြှုပ်ထွက်လျက် နိန်၏။ ");
INSERT INTO rki_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","ယေသျှုကလည်း “ဤပိုင် ဖြစ်နိန်သည်ကား ကြာယာလော့” ဟု သူငယ်၏ဖခင်အား မိန်းတော်မူလျှင်၊ ဖခင်က “အသျှေကတည်းမှစ၍ ဖြစ်နိန်ပါ၏။ ");
INSERT INTO rki_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ယင်းဝိညာဉ်ဆိုးသည် သားသျှေကို သီစီခြင်းငှာ မီးထဲ၌ လည်းကောင်း၊ ရီထဲ၌ လည်းကောင်း အလီလီ လဲစီတတ်ပါ၏။ ကိုယ်တော် တတ်နိုင်သည်ဆိုလျှင် အကျွန်ရို့ကို သနား၍ ကယ်မတော်မူပါ” ဟု ပြန်၍ လျှောက်ထား၏။ ");
INSERT INTO rki_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ယေသျှုက “ဇာကြောင့် ‘တတ်နိုင်တော်မူလျှင်’ ဟူ၍ ပြောသနည်း။ ယုံကြည်ခြင်းဟိသောသူအဖို့ ခပ်သိမ်းသော အမှုအရာကို တတ်စွမ်းနိုင်သည်” ဟု ထိုသူအား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ထိုအခါ သူငယ်၏ဖခင်က “အကျွန် ယုံကြည်ပါ၏။ သို့သော် အကျွန်၌ဟိသော ယုံကြည်ခြင်းကို ပိုပြီးဟိဖို့ မစတော်မူပါ” ဟု အသံကျယ်စွာ အော်ဟစ်၍ လျှောက်ထားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","လူစုလူဝေးရို့သည် စုရုံး၍ ဗြီးလာကြသည်ကို ယေသျှုသည် မြင်တော်မူလျှင် “ဆွံ့အ၍ နားပင်းစီသော နတ်၊ ယင်းအသျှေပါးက ထွက်လော့။ ဇာခါမျှ ပြန်ဝင်မပူးကေ့၊ ငါ အမိန့်ပီး၏” ဟု ဝိညာဉ်ဆိုးအား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ထိုဝိညာဉ်သည် အော်ဟစ်ပြီးလျှင် သူငယ်အား ပြင်းစွာတက်စီပြီးမှ ထွက်လားလေ၏။ သူငယ်သည်လည်း လူသီကဲ့သို့ ဖြစ်နိန်သဖြင့် လူအပေါင်းရို့က “အသျှေ သီယာ” ဟု ပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","သို့ရာတွင် ယေသျှုသည် သူငယ်၏လက်ကို ကိုင်၍ ထူမတော်မူလျှင် သူငယ်သည် ထလာ၏။ ");
INSERT INTO rki_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ကိုယ်တော်သည် အိမ်ထဲသို့ ဝင်တော်မူပြီးမှ တပည့်တော်ရို့က “အကျွန်ရို့သည် ယင်းနတ်ကို မောင်းထုတ်၍ ဇာအတွက် မရနိုင်ပါသနည်း” ဟု မိန်းလျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ကိုယ်တော်က “ဆုတောင်းခြင်းမှတစ်ပါး အခြားဇာနည်းနှင့်မျှ ထိုနတ်မျိုးကို နှင်ထုတ်လို့မရနိုင်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ယေသျှုနှင့် တပည့်တော်ရို့သည် ထိုအရပ်မှထွက်၍ ဂါလိလဲပြည်ကို ဖြတ်လားကြ၏။ ထိုသို့ ဖြတ်လားကြောင်းကို ကိုယ်တော်သည် မည်သူ့ကိုမျှ မသိစီလို။ ");
INSERT INTO rki_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","အကြောင်းမူကား ကိုယ်တော်သည် တပည့်တော်ရို့အား “လူသားကို လူတိလက်သို့ အပ်နှံကြပြီးလျှင်၊ အသီသတ်ကြလိမ့်မည်။ သို့ရာတွင် သုံးရက်ကြာသောအခါ လူသားသည် ရှင်ပြန်ထမြောက်လိမ့်မည်” ဟူ၍ သွန်သင်နိန်သောကြောင့် ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","တပည့်တော်ရို့သည် ကိုယ်တော်၏ သွန်သင်ခြင်းကို နားမလည်ကြသော်လည်း ကိုယ်တော့်ကို ကြောက်ရွံ့၍ မမိန်းလျှောက်ဝံ့ကြ။ ");
INSERT INTO rki_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ကိုယ်တော်နှင့် တပည့်တော်ရို့သည် ကပေရနောင်မြို့သို့ ရောက်ကြ၏။ အိမ်ထဲသို့ ဝင်ပြီးနောက် ကိုယ်တော်က “သင်ရို့သည် လမ်း၌ ဇာအကြောင်းကို ငြင်းခုံနိန်ကြသနည်း” ဟု တပည့်တော်ရို့အား မိန်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","သို့သော် တပည့်တော်ရို့သည် နှုတ်ဆိတ်နိန်ကြ၏။ အကြောင်းမူကား မိမိရို့အထဲ၌ ဇာသူသည် အကြီးမြတ်ဆုံးဖြစ်သည်ကို လမ်းတွင် ဆွေးနွေးငြင်းခုံကြသောကြောင့် ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ထိုအခါ ယေသျှုသည် ထိုင်လျက် တစ်ဆယ့်နှစ်ပါးသော တပည့်တော်ရို့အား ခေါ်၍ “အမြင့်ဆုံး ဖြစ်လိုသောသူသည် အားလုံး၏ အောက်ဆုံးဖြစ်ရမည်။ လူတိုင်း၏ အစီခံလည်း ဖြစ်ရမည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ထို့နောက် ကိုယ်တော်သည် အသျှေတစ်ယောက်အား ခေါ်၍ သူရို့ရှိ့၌ ထားပြီးမှ၊ ထိုအသျှေကို ဖက်လျက်၊ ");
INSERT INTO rki_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“ငါ၏နာမကို ထောက်၍ ဤပိုင် အသျှေရို့ထဲက တစ်ယောက်ယောက်ကို လက်ခံသောသူသည် ငါ့ကို လက်ခံ၏။ ငါ့ကို လက်ခံသောသူက ငါ့ကိုသာ လက်ခံသည် မဟုတ်၊ ငါ့ကို စီရွှတ်တော်မူသော အသျှင်ကိုလည်း လက်ခံခြင်း ဖြစ်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ယောဟန်က “ဆရာ၊ ဆရာ၏နာမကို အမှီပြု၍ နတ်ဆိုးတိကို မောင်းထုတ်နိန်သော လူတစ်ယောက်အား အကျွန်ရို့ မြင်တွိ့ခပါ၏။ ယင်းသူကား အကျွန်ရို့နှင့် အပေါင်းအပါ မဟုတ်သောကြောင့် ကိုယ်တော်၏နာမကို အသုံးမပြုဖို့ တားမြစ်ခပါ၏” ဟု ကိုယ်တော့်ကို လျှောက်လျှင်၊ ");
INSERT INTO rki_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ယေသျှုက “ထိုသူ့ကို မတားကေ့၊ ငါ့နာမကို အမှီပြုကာ အံ့ဖွယ်သောအမူကို ပြုပြီးလျှင် ငါ့အား ပုတ်ခတ်ပြောဆိုနိုင်မည့် လူတစ်ယောက်မျှ မဟိ။ ");
INSERT INTO rki_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ငါရို့ကို မဆန့်ကျင်သောသူသည် ငါရို့ ဘ ဖက်သားဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","သင်ရို့အား ငါ အမှန်ဆိုသည်ကား၊ ငါ့လူ ဖြစ်ကြောင့်ကို ထောက်၍ သင်ရို့အား သောက်ရီတစ်ခွက်ကို တိုက်သောသူကား ယင်းရီတစ်ခွက်၏အကျိုးကို ခံစားရလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“ငါ့ကို ယုံကြည်သော ဤအသျှေတစ်ယောက်ယောက်ကို မှောက်မှားလမ်းလွဲစီသောသူသည် မိမိ၏လိုင်ပင်း၌ ကြီးသောကြိတ်ဆုံကျောက်ကို ဆွဲလျက် ပင်လယ်ထဲမှာ ပစ်ချခံရသည်က ယင်းသူ့အဖို့ ပို၍ကောင်း၏။ ");
INSERT INTO rki_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","သင်၏လက်သည် သင်၏ယုံကြည်ခြင်းကို ပျက်ပြားစီမည်ဆိုလျှင် ယင်းလက်ကို ဖြတ်ပစ်လော့။ လက်နှစ်ဖက် အစုံအလင်နှင့် ပိုးမသီ၊ မီးမငြိမ်းနိုင်သော ငရဲ၌ ကျသည်ထက်၊ လက်တစ်ဖက်မဟိဘဲ ထာဝရအသက်ကို ရခြင်းက ပို၍ ကောင်း၏။ ");
INSERT INTO rki_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","သင်၏ခြီက သင်၏ယုံကြည်ခြင်းကို ပျက်ပြားစီမည်ဆိုလျှင် ယင်းခြီကို ဖြတ်ပစ်လော့။ ခြီနှစ်ဖက် အစုံအလင်နှင့် ငရဲ၌ ကျသည်ထက် ခြီတစ်ဖက် မဟိဘဲနှင့် ထာဝရအသက်ကို ရသည်က ပို၍ကောင်း၏။ ");
INSERT INTO rki_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","သင်၏မျက်စိက သင့်ယုံကြည်ခြင်းကို ပျက်ပြားစီသည်ဆိုလျှင် ယင်းမျက်စိကို ထုတ်ပစ်လော့။ ");
INSERT INTO rki_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘မျက်စိအစုံနှင့် ပိုးမသီ၊ မီးမငြိမ်းနိုင်သော ငရဲ၌ကျစွာထက် ဘုရားသခင်၏ နိုင်ငံတော်ထဲသို့ မျက်လုံးတစ်ဖက်မဟိဘဲနှင့် ဝင်ခွင့်ရသည်က ပို၍ကောင်း၏။’ ");
INSERT INTO rki_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“ယဇ်ကောင်ကို ဆားအားဖြင့် သန့်စင်သည့်နည်းတူ လူတိုင်းသည် မီးအားဖြင့် သန့်စင်ခြင်းကို ခံရလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“ဆားသည် အသုံးဝင်၏၊ သို့သော် ယင်းဆားသည် အငံဓာတ်ပျောက်ကင်းလားလျှင် အငံဓာတ်ကို ပြန်ရအောင် ဇာပိုင်ပြုနိုင်မည်နည်း။ “သင်ရို့တွင် မိတ်ဖွဲ့ခြင်း၌ ဆားဟိစီကြလော့၊ သင်ရို့သည်လည်း အချင်းချင်း သင့်မြတ်စွာ နိန်ကြလော့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ထို့နောက်၊ ယေသျှုသည် ထိုအရပ်မှ ထွက်ပြီးလျှင်၊ ယော်ဒန်မြစ်ကမ်းတစ်ဖက်သို့ ကူး၍ ယုဒနယ်သို့ ကြွတော်မူ၏။ လူအပေါင်းရို့သည် ကိုယ်တော်ထံ၌ တဖန် လာရောက်စုဝေးကြ၍ ကိုယ်တော်သည် ပြုလေ့ဟိသည့်အတိုင်း လူရို့ကို ဆုံးမသြဝါဒ ပီးတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ဖာရိယှဲတချို့သည် ကိုယ်တော့်ထံသို့ ရောက်လာပြီးလျှင် “အကျွန်ရို့၏ ဥပဒေအရ လူသည် မိမိမယားနှင့် ကွာယှင်းသင့်ပါသလား၊ အကျွန်ရို့ကို ပြောပါ” ဟု ပရိယာယ်ဖြင့် မိန်းလျှောက်ကြလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ယေသျှုကလည်း၊ “မောသျှေသည် သင်ရို့ကို ဇာပိုင် ပညတ်ထားခသနည်း” ဟု ပြန်၍ မိန်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","သူရို့က “မိမိမယားကို ကွာစာပီး၍ ကွာယှင်းရသည်ဟု မောသျှေက ပညတ်ထားပါ၏” ဟု ပြန်၍ လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","ယေသျှုကလည်း “သင်ရို့သည် စိတ်နှလုံးခိုင်မာသော လူတိဖြစ်သောကြောင့် မောသျှေသည် ယင်းပညတ်ကို ရီးသားခခြင်း ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ကျမ်းစာ၌ လာသည်ကား၊ ဘုရားသခင်သည် ဖန်ဆင်းတော်မူစ၌ ယောက်ျားနှင့် မိန်းမကိုသာ ဖန်ဆင်းခ၏။ ");
INSERT INTO rki_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","ဤအကြောင်းကြောင့်၊ ယောက်ျားသည် ကိုယ့်မိဘကို ထား၍၊ မိမိ၏မယားနှင့် ပေါင်းသင်းနီထိုင်သဖြင့်၊ ");
INSERT INTO rki_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ထိုနှစ်ယောက်သည် တစ်သားတစ်ကိုယ်တည်း ဖြစ်ရလိမ့်မည်။ ထို့ကြောင့် ယင်းသူရို့သည် နှစ်ယောက် မဟုတ် တစ်ယောက်တည်းသာ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ယင်းကြောင့် ဘုရားသခင် စုံဖက်ပီးသောအရာကို လူက မခွဲမခွါစီကေ့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","တပည့်တော်ရို့သည် အိမ်၌ ဟိကြသောအခါ၊ အထက်က အကြောင်းအရာများကို ယေသျှုအား တဖန် မိန်းလျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ကိုယ်တော်က “လူတစ်ယောက်သည် မိမိမယားကို ကွာ၍ အခြားမိန်းမနှင့် အိမ်ထောင်ပြုလျှင်၊ ယင်းသူသည် မိမိမယားကို ပြစ်မှားယာ။ ");
INSERT INTO rki_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ယင်းနည်းတူ မိန်းမတစ်ယောက်သည် ကိုယ့်လင်ယောက်ျားကို ကွာ၍ အခြားသော ယောက်ျားတစ်ယောက်နှင့် အိမ်ထောင်ပြုလျှင် ယင်းမိန်းမသည် မိမိလင်ယောက်ျားကို ပြစ်မှားယာ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","ထိုအခါ လူတချို့သည် အသျှေရို့ကို ယေသျှု၏ လက်တော်ဖြင့် တို့ထိတော်မူစီခြင်းငှာ အထံတော်သို့ ခေါ်ဆောင်ခကြ၏။ ထို့ကြောင့် တပည့်တော်ရို့သည် ထိုသူရို့ကို အပြစ်တင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ယေသျှုသည် ထိုအခြင်းအရာတိကို မြင်တော်မူလျှင် အမျက်တော်ထွက်၍ “အသျှေတိ၊ ငါ့ပါးသို့ လာကတ်ပါစီ။ မတားကတ်ကေ့။ ဘုရားသခင်၏ နိုင်ငံတော်သည် ထိုသို့သောသူရို့၏ နိုင်ငံဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ငါ အမှန်ဆိုသည်ကား၊ ဘုရားသခင်၏ နိုင်ငံတော်ကို အသျှေတစ်ယောက်ပိုင် မခံယူတတ်သောသူသည် ကောင်းကင်နိုင်ငံတော်သို့ မရောက်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ထို့နောက် ကိုယ်တော်သည် အသျှေရို့ကို ပွိ့ဖက်ပြီးလျှင်၊ သူရို့ထက်၌ လက်တော်ကို တင်လျက် ကောင်းကြီးပီးတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","တဖန်၊ ယေသျှုသည် လမ်း၌ ကြွတော်မူစဉ် လူတစ်ယောက်သည် အထံတော်သို့ ဗြီးလာ၍ ရှိ့တော်၌ ဒူးထောက်လျက် “ကောင်းမြတ်သောဆရာ၊ အကျွန်သည် ထာဝရအသက်ကို ရစီခြင်းငှာ မည်သို့ လုပ်ရပါမည်နည်း” ဟု မိန်းလျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ယေသျှုကလည်း “ငါ့ကို ကောင်းမြတ်သည်ဟု ဇာကြောင့် ခေါ်သနည်း။ ဘုရားသခင်တစ်ပါးတည်းမှ လွဲ၍ ကောင်းမြတ်သောသူ တစ်စုံတစ်ယောက်မျှမဟိ။ ");
INSERT INTO rki_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","‘လူ့အသက်ကို မသက်ကေ့၊ သူ့မယားကို မပြစ်မှားကေ့၊ သူ့ဥစ္စာကို မခိုးကေ့၊ မမှန်သောသက်သီကို မခံကေ့၊ မုသာမသုံးကေ့၊ သင်၏မိဘကို ရိုသေစွာပြုလော့’ ဟူသောပညတ်တိကို သင်သိသည် မဟုတ်လော” ဟုမိန်းတော်မူလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","“ဆရာ၊ အကျွန်သည် အသျှေကတည်းကနိန် ဤဟိသမျှပညတ်တိကို စောင့်ထိန်းခပါယာ” ဟု ပြန်၍ လျှောက်ထား၏။ ");
INSERT INTO rki_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ယေသျှုသည် ထိုသူကို စိစိကြည့်ကာ ချစ်သောစိတ် ဟိသည်ဖြစ်၍ “သင့်၌ တစ်ခု လိုသိမ့်၏။ လားပြီးလျှင်၊ သင်၏ဥစ္စာတိကို ရောင်းချ၍ ဆင်းရဲသောလူရို့ကို ပီးကမ်းစွန့်ကြဲလော့။ ထိုသို့ပြုလျှင် ကောင်းကင်ဘုံ၌ ဘဏ္ဍာကို ရလိမ့်မည်။ ယင်းပြီးမှသာ ငါ့နောက်သို့ လိုက်လော့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ထိုသူကား ဥစ္စာပစ္စည်းများစွာ ကြွယ်ဝသောသူဖြစ်သဖြင့် ထိုစကားကို ကြားသောအခါ မျက်နှာညှိုးငယ်၍ စိတ်မချမ်းမသာဖြစ်လျက် ထွက်လားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ယေသျှုကလည်း တပည့်တော်ရို့ကို လှည့်ကြည့်တော်မူလျက်၊ “ဥစ္စာကြွယ်ဝသောသူသည် ဘုရားသခင်၏နိုင်ငံတော်သို့ ဝင်ဖို့အတွက် အလွန်ခက်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","တပည့်တော်ရို့သည် ကိုယ်တော်၏စကားတော်ကို ကြားလျှင် လွန်စွာ မိန်းမောတွေဝေကြ၏။ ယေသျှုက “ချစ်သားရို့၊ ဘုရားသခင်၏ နိုင်ငံတော်ကို ဝင်ဖို့ရန် ဇာမျှလောက် ခက်သည်မှာ၊ ");
INSERT INTO rki_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","အပ်နဖားပေါက်ထဲသို့ ကုလားအုတ်လျှိုဝင်၍ လွယ်ကောင်းလွယ်လိမ့်မည်။ ဥစ္စာရတတ်သောသူကား ဘုရားသခင်၏ နိုင်ငံတော်သို့ ဝင်ဖို့ရန် အလွန်ခက်၏” ဟု တပည့်တော်ရို့အား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","တပည့်တော်ရို့သည် သာ၍ မိန့်မောတွေဝေကြသဖြင့် “ယင်းသို့ဆိုလျှင် ဇာသူသည် ကယ်တင်ခြင်းကို ရနိုင်ပါမည်နည်း” ဟု အချင်းချင်း ပြောဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ယေသျှုသည် ထိုသူရို့ကို စိစိကြည့်ပြီးလျှင် “ဤအမှုကို လူတိ မတတ်နိုင်သော်လည်း ဘုရားသခင် တတ်နိုင်တော်မူ၏။ ဘုရားသခင်သည် ခပ်သိမ်းသောအမှုအရာတိကို တတ်နိုင်တော်မူ၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ထိုအခါ ပေတရုက “အကျွန်ရို့သည် အားလုံးကို စွန့်၍ ကိုယ်တော်၏ နောက်တော်သို့ လိုက်လာကြပါ၏” ဟု လျှောက်ထားလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ယေသျှုက “ငါ အမှန်ဆိုသည်ကား ငါ့အတွက် သော်လည်းကောင်း၊ ဧဝံဂေလိတရားအတွက် သော်လည်းကောင်း၊ အိမ်၊ မြီ၊ ညီအစ်ကိုမောင်နှမ၊ မိဘ၊ သားသမီး တည်းဟူသော တစ်ပါးပါးကို စွန့်သောသူသည်၊ ");
INSERT INTO rki_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","အဂုကာလ၌ ညှဉ်းပန်းနှိပ်စက်ခြင်းနှင့်တကွ အဆတစ်ရာဟိသော အိမ်၊ မြီ၊ ညီအစ်ကိုမောင်နှမ၊ မိဘ၊ သားသမီးတိကို ရဟိလိမ့်မည် — ယင်းထက်မက နောင်ဘဝ မှာလည်း ထာဝရအသက်ကိုပါ ရဟိလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","သို့ရာတွင် အယင်ကျသောသူရို့သည် နောက်ကျလိမ့်မည်။ နောက်ကျသောသူရို့သည် အယင်ကျလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","ယေသျှုနှင့် တပည့်တော်ရို့သည် ယေရုဆလင်မြို့သို့ လားကြရာလမ်း၌ ယေသျှုသည် တပည့်တော်ရို့၏အရှိ့မှ ကြွတော်မူ၏။ သူရို့သည်လည်း ထိတ်လန့်တုန်လှုပ်၍ ကြောက်ရွံ့သောစိတ်နှင့် လိုက်ကြ၏။ ထိုအခါ တစ်ကျိပ်နှစ်ပါးသော တပည့်တော်ရို့ကို ခေါ်၍၊ ");
INSERT INTO rki_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“နားထောင်၊ ငါရို့ ခရီးပြုနိန်သော ယေရုဆလင်မြို့၌ လူသားသည် ယဇ်ပုရောဟိတ် အကြီးအကဲတိနှင့် ကျမ်းတတ်ဆရာတိလက်သို့ အပ်နှံခြင်းကို ခံရလိမ့်မည်။ ထိုသူရို့သည် လူသားကို သီဒဏ်စီရင်ကာ တခြားလူမျိုးတိလက်သို့ အပ်နှံကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","သူရို့လည်း လူသားကို ပျက်ရယ်ပြုလျက် သတ်ပုတ်ခြင်း၊ တန်းထွီးနှင့် ထွီးခြင်း၊ အသီသတ်ခြင်းကို ပြုကြလိမ့်မည်။ သို့ရာတွင် သုံးရက်မြောက်သောနိ့၌ ရှင်ပြန်ထမြောက်လိမ့်မည်” ဟု မိမိကြုံတွိ့ရမည့် အမှုအရာများကို မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ထို့နောက် ဇေဗေဒဲ၏သားများဖြစ်သော ယာကုပ်နှင့် ယောဟန်ရို့သည် အထံတော်ပါးသို့ ချဉ်းကပ်၍ “ဆရာ၊ အကျွန်ရို့တောင်းသော ဆုကို ပြုစီလိုပါသည်” ဟု လျှောက်ထားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ကိုယ်တော်ကလည်း “ငါသည် သင်ရို့ကို ဇာပိုင် ပြုစီလိုသနည်း” ဟု မိန်းတော်မူလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","သူရို့က “ကိုယ်တော်သည် ကောင်းကင်နိုင်ငံတော်၏ ရာဇပလ္လင်ထက်၌ ဘုန်းတန်ခိုးတော်နှင့် စိုးစံတော်မူသောအခါ အကျွန်ရို့ ညီအစ်ကိုနှစ်ယောက်ကို အသျှင်၏ လက်ယာဖက်၌ တစ်ယောက်၊ လက်ဝဲဖက်၌ တစ်ယောက်စီ အသျှင်နှင့်အတူ ထိုင်ရသောအခွင့်ကို ပီးတော်မူပါ” ဟု လျှောက်ထားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ယေသျှုကလည်း “သင်ရို့တောင်းနိန်သော ဆုကို သင်ရို့မသိသလော။ ငါ သောက်ရမည့် ဒုက္ခခွက်ဖလားကို သောက်ခြင်းငှာ လည်းကောင်း၊ ငါ ခံရမည့် ဗတ္တိဇံကို ခံခြင်းငှာ လည်းကောင်း သင်ရို့ တတ်စွမ်းနိုင်သလော” ဟု မိန်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ထိုသူရို့ကလည်း “အကျွန်ရို့ တတ်နိုင်ပါ၏” ဟု ပြန်၍ လျှောက်ထားကြ၏။ ယေသျှုက၊ “သင်ရို့သည် ငါ သောက်ရမည့် ဖလားကိုသောက်၍၊ ငါ ခံရမည့် ဗတ္တိဇံကိုလည်း ခံရလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","သို့သော်၊ ငါ၏လက်ယာဖက်၊ လက်ဝဲဖက်၌ ထိုင်ရသောအခွင့်ကိုကား ငါ၌ ပီးပိုင်ခွင့်မဟိ။ ဤအခွင့်သည် ဘုရားသခင် ပျင်ဆင်ပီးထားသော သူတိအဖို့သာ ဖြစ်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ဤအကြောင်းအရာကို အခြားသောတပည့်တော် ဆယ်ယောက်ရို့သည် ကြားကြလျှင်၊ ယာကုပ်နှင့် ယောဟန်ရို့ကို ဒေါသထွက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ထိုအခါ ယေသျှုသည် သူရို့အားလုံးကို ခေါ်၍ “လောကီမင်းတိက ပြည်သူတိကို အစိုးတရပြုကြ၏၊ အကြီးအကဲတိကလည်း တန်ခိုးအာဏာကို သုံးကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","သို့သော်၊ သင်ရို့၌ကား ထိုသို့ မဟုတ်။ သင်ရို့အထဲက အကြီးအကဲ ဖြစ်လိုသောသူသည် လူတိုင်း၏ အခိုင်းအစီကို ခံစီ။ ");
INSERT INTO rki_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","သင်ရို့ထဲက အကြီးမြတ်ဆုံး လုပ်လိုသောသူသည် အားလုံး၏ အခိုင်းအစီဖြစ်ရမည်။ ");
INSERT INTO rki_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","အကြောင်းမူကား လူသားပင်လျှင် သူတစ်ပါးကို ခိုင်းစီဖို့ရန် လာသည် မဟုတ်၊ သူတစ်ပါး၏ အခိုင်းအစီကို ခံခြင်းငှာ လည်းကောင်း၊ မိမိအသက်ကို စွန့်၍ လူတိကို ရွီးနုတ်ခြင်းငှာလည်းကောင်း ကြွလာခြင်းဖြစ်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ကိုယ်တော်နှင့် တပည့်တော်ရို့သည် ယေရိခေါမြို့သို့ ရောက်ကြ၏။ ထို့နောက် များစွာသော လူရို့နှင့်တကွ ထိုမြို့မှ ထွက်ကြွတော်မူစဉ် တိမဲ၏သား ဗာတိမဲဆိုသူ မျက်မမြင် သူတောင်းစားတစ်ယောက်သည် လမ်းနားတွင် ထိုင်နိန်၏။ ");
INSERT INTO rki_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ထိုသူသည် နာဇရက်မြို့သား ယေသျှု ရောက်ဟိလာကြောင်းကို ကြားသောအခါ “ဒါဝိဒ်၏သားတော် ယေသျှု၊ အကျွန့်ကို သနားတော်မူပါ” ဟု ဟစ်အော်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","လူရို့က ထိုသူကို တိတ်ဆိတ်စွာ နိန်စီခြင်းငှာ အော်ငေါက်၍ ပြောဆိုသော်လည်း၊ “ဒါဝိဒ်၏သားတော် ယေသျှု၊ အကျွန့်ကို သနားတော်မူပါ” ဟု သာ၍ ကျယ်လောင်စွာ အော်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ထိုအခါ ယေသျှုသည် ရပ်တန့်တော်မူ၍ “ယင်းသူကို ခေါ်လာလော့” ဟု မိန့်တော်မူ၏။ ထို့ကြောင့် ထိုသူရို့သည် မျက်စိမမြင်သောသူအား “အားမငယ်ကေ့။ ထ၊ သင့်ကို ကိုယ်တော် ခေါ်နိန်၏” ဟု ပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ထိုသူသည် မိမိ၏အဝတ်ကို ဘေးသို့ ပစ်ချပြီးလျှင် ထ၍ ယေသျှုထံပါးသို့ လာ၏။ ");
INSERT INTO rki_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ယေသျှုက၊ “သင့်အဖို့ ငါ ဇာလုပ်ပီးရမည်နည်း” ဟု ထိုသူအား မိန်းတော်မူလျှင်၊ ထိုသူက “ဆရာ၊ အကျွန့်မျက်စိ ပြန်မြင်ချင်ပါ၏” ဟု ကိုယ်တော့်ကို လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ယေသျှုက၊ “သင်၏ယုံကြည်ခြင်းက သင့်ကို အကောင်းပကတိ ဖြစ်စီယာ။ ပြန်လားလော့” ဟု မိန့်တော်မူပြီးနောက်၊ ချက်ချင်းပင် ထိုသူသည် မျက်စိမြင်၍ ကိုယ်တော်ကြွတော်မူရာနောက်သို့ လိုက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ယေသျှုနှင့် တပည့်တော်ရို့သည် ယေရုဆလင်မြို့သို့ ကြွလာကြရာ သံလွင်တောင်ခြီရင်း အနီး၌ဟိသော ဗေသနိရွာနှင့် ဗက်ဖာဂေရွာသို့ ရောက်လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ထိုအခါ ကိုယ်တော်သည် တပည့်တော်နှစ်ယောက်အား “သင်ရို့၏ရှိ့၌ ဟိသောရွာသို့ လားကြလော့။ ရွာထဲသို့ ဝင်လျှင်ဝင်ချင်း ဇာသူမျှ မစီးဖူးသိမ့်သော မြည်းသျှေတစ်ကောင်အား ကြိုးနှင့်ချိုင်ထားသည်ကို သင်ရို့ တွိ့လိမ့်မည်။ ယင်းမြည်းကို ကြိုးဖြီ၍ ယူလာလော့။ ");
INSERT INTO rki_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","တစ်ယောက်ယောက်က သင်ရို့ကို ဇာလုပ်နိန်သနည်း ဟူ၍ မိန်းလျှင် အကျွန်ရို့သခင်က အလိုဟိပါ၏။ ပြီးလျှင်၊ ချက်ချင်း ပို့ပီးပါမည် ဟူ၍ ပြောလော့” ဟု မိန့်မှာ၍ စီရွှတ်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ထိုတပည့်တော်နှစ်ယောက်ရို့သည် လားကြ၍ လမ်းဘေး၌ဟိသော အိမ်တန်းခါးနား၌ ကြိုးနှင့် ချိုင်ထားသော မြည်းချေတစ်ကောင်ကို တွိ့လျှင် ကြိုးကိုဖြီကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ထိုအခါ အနီးအနား၌ ဟိသောလူတချို့က “မြည်းချေကို ဇာလုပ်ဖို့ ကြိုးဖြီကြသနည်း” ဟု တပည့်တော်ရို့ကို မိန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","တပည့်တော်ရို့သည် ယေသျှုမိန့်မှာထားသည့်အတိုင်း ပြောပြကြသောအခါ မြည်းချေကို ကြိုးဖြီခွင့် ပြုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","တပည့်တော်ရို့သည် မြည်းချေကို ယေသျှုပါးသို့ ဆွဲလာပြီးလျှင် ထိုမြည်းချေထက်၌ မိမိရို့၏ ဝတ်ရုံတိကို တင်ကြ၏။ ထို့နောက် ကိုယ်တော်သည် မြည်းကို စီးတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","များစွာသောလူရို့သည် မိမိရို့၏ ဝတ်ရုံတိကို လမ်း၌ ဖြန့်ခင်းကြ၏။ အချို့မူကား ကွင်းပြင်မှ သစ်ရွက်သစ်ခက်များကို လမ်း၌ ဖြန့်ခင်းထားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ကိုယ်တော်၏ရှိ့တော်မှ လည်းကောင်း၊ နောက်တော်မှ လည်းကောင်း လိုက်ပါလာကြသော လူရို့က “ဟောသျှဏ္ဏ ဖြစ်စီသတည်း။ သခင်ဘုရား၏ နာမတော်၌ ကြွလာသောအသျှင်သည် မင်္ဂလာဟိပါစီသတည်း။ ");
INSERT INTO rki_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","တည်လုသော ငါရို့အဖ ဒါဝိဒ်မင်းကြီး၏နိုင်ငံတော်သည် မင်္ဂလာဟိပါစီ။ အမြင့်ဆုံးသောအရပ်၌ ဟောသျှဏ္ဏ ဖြစ်စီသတည်း” ဟု ကြွေးကြော်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ယေသျှုသည် ယေရုဆလင်မြို့သို့ ရောက်သောအခါ ဗိမာန်တော်သို့ ဝင်ပြီးလျှင် ဟိသမျှသောအရာတိကို လှည့်လည်၍ ကြည့်တော်မူ၏။ ထို့နောက် နီဝင်ချိန်နီးသဖြင့် တပည့်တော်တစ်ဆယ့်နှစ်ပါးနှင့်အတူ ဗေသနိရွာသို့ ကြွတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","နောက်တစ်နိ့၌ ယေသျှုနှင့် တပည့်တော်ရို့သည် ဗေသနိရွာမှ ပြန်လာကြစဉ်တွင် ကိုယ်တော်သည် ဆာလောင်မွတ်သိပ်ခြင်းသို့ ရောက်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ကိုယ်တော်သည် အရွက်တိဖုံးနိန်သော သဖန်းပင်တစ်ပင်ကို အဝီးမှ မြင်တော်မူလျှင် အသီးကို တွိ့လိုတွိ့ငြား လား၍ ကြည့်တော်မူ၏။ သို့ရာတွင် သဖန်းသီး သီးချိန် မဟုတ်သောကြောင့် အသီးကို မတွိ့ဘဲ အရွက်တိကိုသာ တွိ့တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ထိုအခါ ကိုယ်တော်က သဖန်းပင်ကို “နောက်အစဉ်အဆက် သင်၏အသီးကို တစ်ယောက်မှ မစားစီရ” ဟု မိန့်တော်မူ၏။ ထိုသို့ မိန့်တော်မူသည်ကို တပည့်တော်ရို့သည် ကြားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ကိုယ်တော်နှင့် တပည့်တော်ရို့သည် ယေရုဆလင်မြို့သို့ ရောက်ကြသောအခါ၊ ကိုယ်တော်သည် ဗိမာန်တော်သို့ ကြွတော်မူ၍ ဗိမာန်တော်အတွင်း၌ ရောင်းဝယ်နိန်ကြသော သူရို့ကို နှင်ထုတ်တော်မူ၏။ ဖေသာဒင်္ဂါး လဲလှယ်နိန်သော သူရို့၏ စားပွဲကိုလည်း မှောက်လှန်၍ ဂြိုးငှက်ရောင်းသော သူရို့၏ ထိုင်ခုံတိကိုလည်း တွန်းလှဲတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ဗိမာန်တော်ဝင်းကို ဖြတ်၍ သယ်ဆောင်ခြင်းငှာ မည်သူ့ကိုမျှ ခွင့်ပြုတော်မမူ။ ");
INSERT INTO rki_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ထိုသူရို့အား ကိုယ်တော်က “ ‘ငါ၏ဗိမာန်ကို လူမျိုးတကာရို့၏ ဆုတောင်းရာအိမ်တော်ဟူ၍ ခေါ်ဆိုကြလိမ့်မည်’ ဟု ကျမ်းစာတော်မြတ်၌ ရီးသားထားသည် မဟုတ်လော။ သို့ရာတွင်၊ ဤနီရာကို သူခိုးဒါးပြတိ ခိုအောင်းသောနီရာ ဖြစ်စီသည်တကား” ဟု ဆုံးမသွန်သင်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ယဇ်ပုရောဟိတ်အကြီးအကဲရို့နှင့် ကျမ်းတတ်ဆရာရို့သည် ထိုစကားကို ကြားကြလျှင် ယေသျှုကို သတ်ခြင်းငှာ နည်းလမ်းရှာကြ၏။ သို့ရာတွင် လူအပေါင်းရို့သည် ကိုယ်တော်၏သွန်သင်မူကို လွန်စွာအံ့သြလျက် ဟိကြသောကြောင့် ထိုသူရို့သည် ကိုယ်တော့်ကို ကြောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ညနီစောင်းအချိန်ရောက်သောအခါ ကိုယ်တော်နှင့် တပည့်တော်ရို့သည် ထိုမြို့မှ ထွက်လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","နောက်တစ်နိ့ မိုးထက်စောစောအချိန်၌ ကိုယ်တော်နှင့် တပည့်တော်ရို့သည် လမ်း၌ လျှောက်လားကြစဉ်၊ သဖန်းပင်ကို မြင်ကြ၏။ ထိုအပင်သည် အမြစ်မှစ၍ တစ်ပင်လုံး ခြောက်သွိ့ညှိုးနွမ်းလျက် ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ပေတရုသည် သတိရ၍ “ဆရာ၊ ကြည့်တော်မူပါ၊ ကိုယ်တော် ဒဏ်ခတ်ခသော သဖန်းပင်သည် ညှိုးနွမ်းခြောက်သွိ့လားခယာ” ဟု လျှောက်ထား၏။ ");
INSERT INTO rki_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ယေသျှုက “ဘုရားသခင်ကို ယုံကြည်ကြလော့။ ");
INSERT INTO rki_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ငါ အမှန်ဆိုသည်ကား၊ အကြင်သူသည် စိတ်နှလုံးထဲ၌ သံသယမဟိဘဲ၊ ‘မိမိပြောဆိုသည်အတိုင်း ဖြစ်မည်ဟု’ ယုံကြည်ခြင်း ဟိသောသူသည် ‘ဤတောင်ကို နီရာမှ ရွိ့လော့။ ပင်လယ်၌ ကျလော့ ဟုဆိုလျှင် ထိုသူဆိုသည့်အတိုင်း ဖြစ်လိမ့်မည်။’ ");
INSERT INTO rki_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ထို့ကြောင့် ငါ ဆိုသည်ကား သင်ရို့သည် မိမိတောင်းလျှောက်သော အရာကို မုချရယာဟု ယုံကြည်ကြလျှင် တောင်းသမျှကို ရကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","သင်ရို့ ဆုတောင်းသောအခါ သူတစ်ပါး၏ အပြစ်တိကို ခွင့်ရွှတ်ရမည်။ ထိုမှသာ၊ ကောင်းကင်ဘုံ၌ ဟိတော်မူသော သင်ရို့အဖသည် သင်ရို့၏အပြစ်တိကို ခွင့်ရွှတ်တော်မူလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","တဖန် ယေသျှုနှင့် တပည့်တော်ရို့သည် ယေရုဆလင်မြို့သို့ ရောက်တော်မူလျှင်၊ ကိုယ်တော်သည် ဗိမာန်တော်၌ လမ်းလျှောက်တော်မူ၏။ ယဇ်ပုရောဟိတ် အကြီးအကဲတိ၊ ကျမ်းတတ်ပုဂ္ဂိုလ်တိနှင့် ဘာသာရေးခေါင်းဆောင်ရို့သည် အထံတော်သို့ ချဉ်ကပ်၍၊ ");
INSERT INTO rki_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ကိုယ်တော့်ကို “သင်သည် ဤအမှုအရာတိကို ဇာအခွင့်ဖြင့် ပြုသနည်း။ ဇာသူက ဤအခွင့်ကို ပီးသနည်း” ဟု မိန်းလျှောက်ကြလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ယေသျှုက “သင်ရို့ကို ငါ မိန်းခွန်းတစ်ခု မိန်းမည်။ သင်ရို့ဖြေကြလော့၊ သို့ပြုလျှင် ဤအမှုအရာတိကို ဇာသူ့အခွင့်ဖြင့် ပြုသည်ကို သင်ရို့အား ငါ ပြောပြမည်။ ");
INSERT INTO rki_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ယောဟန်သည် ဗတ္တိဇံကို ပီးသောအခါ ဘုရားသခင်ပါးက အခွင့်ဖြင့်လော၊ လူပါးက အခွင့်ဖြင့်လော။ ထိုအရာကို ငါအား ပြောလော့” ဟု မိန်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ထိုသို့ မိန်းတော်မူလျှင် သူရို့က “ငါရို့ ဇာပိုင် ပြောရမည်နည်း။ အကယ်၍ ‘ဘုရားအခွင့်ဖြင့် ပြုသည်’ ဟု ဖြေလျှင် ‘ယောဟန်ကို ဇာတွက် မယုံကြည်ကြသနည်း’ ဟု ဤသူက ငါရို့ကို မိန်းဖို့။ ");
INSERT INTO rki_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ယင်းပုံစံ ‘လူပါးက အခွင့်နှင့် ပြုသည်ဟု ဖြေရဖို့လား’ လူတိက ယောဟန်ကို ပရောဖက်အမှန်ဖြစ်သည်ဟု မှတ်ယူထားကြ၏” ဟူ၍ အချင်းချင်း ဆွေးနွေးကြပြီး လူတိကို ကြောက်ရွံ့ကြသောကြောင့်၊ ");
INSERT INTO rki_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","“အကျွန်ရို့ မသိပါ” ဟု ကိုယ်တော့်ကို လျှောက်ကြ၏။ ထိုအခါ ယေသျှုက၊ “ထို့အတူ ဤအမူတိကို ဇာသူ့အခွင့်ဖြင့် ငါ ပြုနိန်သည်ကို သင်ရို့အား ငါလည်း မပြော” ဟု သူရို့အား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","ထို့နောက်၊ ယေသျှုသည် သူရို့အား ပုံဥပမာဖြင့် “တစ်ခါက လူတစ်ယောက်သည် စပျစ်ဥယျာဉ်၌ စပျစ်ပင်တိစိုက်ပြီးလျှင် ခြံစည်းရိုးကာထား၏။ စပျစ်သီးနယ်ခြင်းငှာ တွင်းကို တူး၍ လင့်စင်ကိုလည်း ဆောက်ထား၏။ ထို့နောက် ထိုသူသည် စပျစ်ဥယျာဉ်ကို သီးစား အငှားချထားပြီးလျှင် အခြားအရပ်သို့ ခရီးထွက်လားခ၏။ ");
INSERT INTO rki_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","စပျစ်သီးခူးသောအချိန် ရောက်သောအခါ မိမိရမည့် ဝီစုကို ယူခြင်းငှာ မိမိ၏ အခိုင်းအစီတစ်ယောက်ကို သီးစားအငှားသမားရို့ပါးသို့ စီရွှတ်လိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","သီးစားအငှားသမားရို့ပါးသို့ ရောက်သောခါ ထိုအခိုင်းအစီကို သတ်ပုတ်ပြီးလျှင် လက်ချည်းသက်သက် ပြန်ရွှတ်လိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ဥယျာဉ်သျှင်က နောက်တဖန် အခိုင်းအစီတစ်ယောက်ကို စီရွှတ်လိုက်ပြန်၏။ သီးစားသမားရို့က ယင်းအခိုင်းအစီ၏ အဂေါင်းကို ရိုက်ပုတ်ကာ အရှက်ကွဲ အကျိုးနည်းဖြစ်အောင် လုပ်ပြီးပြန်ရွှတ်လိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ဥယျာဉ်သျှင်ကလည်း အခြားကျွန်တစ်ယောက်ကို စီရွှတ်ပြန်၏။ သီးစားသမားရို့ကလည်း ယင်းအခိုင်းအစီကို အသီသတ်လိုက်ကြ၏။ အခြားသောကျွန်တိကိုလည်း တချို့ကိုသတ်ပြီး၊ တချို့ကို ရိုက်ပုတ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ထို့ကြောင့် ဥယျာဉ်သျှင်က ‘ငါ၌ တစ်ဦးတည်းသာ ဟိသော၊ ငါ၏ချစ်သောသားကို စီရွှတ်လိုက်လျှင် ထိုသူရို့သည် ငါ့သားကို အားနာကြမည်’ ဟု ဆို၍ မိမိသားကို စီရွှတ်လိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","သို့ရာတွင် သီးစားသမားရို့က ဥယျာဉ်သျှင်၏ သားကိုမြင်သောအခါ ‘ဤသူကား ဥယျာဉ်သျှင်၏ အမွီခံမည့်သူ ဖြစ်၏။ လာကတ်၊ သူ့ကို သတ်ကြကုန်အံ့။ ယင်းမှရာ ဤဥယျာဉ်သည် ငါရို့အပိုင်ဖြစ်မည်’ ဟု အချင်းချင်းပြောဆို၍၊ ");
INSERT INTO rki_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ထိုစပျစ်ဥယျာဉ်သျှင်၏သားကို ဖမ်းကာ သတ်ပြီးလျှင် ဥယျာဉ်အပြင်သို့ ထုတ်ပစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“ယင်းပိုင်ဆိုလျှင် ဥယျာဉ်သျှင်က ဥယျာဉ်ကို ဇာပိုင် လုပ်လိမ့်မည်နည်း။ ထိုသူသည် ဥယျာဉ်သို့ လာ၍ သီးစားသမားရို့ကို သတ်ပြီးလျှင်၊ စပျစ်ဥယျာဉ်ကို အခြားသူရို့လက်သို့ အပ်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","ကျမ်းစာတော်မြတ်၌ “ ‘တိုက်ကိုဆောက်သောသူရို့ ပယ်ထားသောကျောက်သည်၊ အားလုံးထက်၊ အရေးကြီးဆုံးသောနီရာ၌ သုံးရသောကျောက်ဖြစ်လာရ၏။ ");
INSERT INTO rki_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ဤအမှုကား သခင်ဘုရားပြုတော်မူသော အမှုဖြစ်၏၊ ငါရို့ မျက်စိရှိ့၌ပင် အံ့ဖွယ်ဖြစ်လီစွတကား’ ဟူ၍ ရီးသားထားသည်ကို သင်ရို့ မဖတ်ဖူးကြသလော” ဟု မိန်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ယုဒခေါင်းဆောင်ရို့သည် မိမိရို့အား ရည်ရွယ်၍ ထိုပုံဥပမာကို မိန့်တော်မူကြောင်း သိသဖြင့် ယေသျှုအား ဖမ်းဆီးခြင်းငှာ ကြိုးစားကြ၏။ သို့ရာတွင် လူအစုအဝေးကို ကြောက်ကြသဖြင့် အထံတော်မှ ထွက်လားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ယေသျှုအား အပြစ်တင်ခွင့်ကို ရခြင်းငှာ မိန်းခွန်းများကို မိန်းစီရန် ဖာရိယှဲ တချို့နှင့် ဟေရုဒ်၏တပည့်တိကို ယေသျှုထံသို့ စီရွှတ်လိုက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","သူရို့သည် အထံတော်သို့ လာကြပြီးလျှင် “ဆရာ၊ ဆရာက လူတိ ဇာပိုင် ထင်မှတ်ထင်မှတ်၊ ဂရုမစိုက်ဘဲ၊ မှန်သောစကားကိုသာ ပြောတတ်ပါ၏။ လူ့မျက်နှာကို မထောက်ဘဲ၊ ဘုရားသခင်၏တရားလမ်းကို အမှန်အတိုင်း သွန်သင်တော်မူကြောင့်ကို အကျွန်ရို့ သိကြပါ၏။ ယင်းအတွက်ကြောင့် အကျွန်ရို့သည် ရောမဧကရာဇ်မင်းအား အခွန်ဆက်အပ်သလော၊ မဆက်အပ်သလော ဆိုသည်ကို ပြောပြပါ” ဟု ပရိယာယ်ဆင်၍ မိန်းလျှောက်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ယေသျှုသည် ထိုသူရို့၏ ပရိယာယ်ကို သိတော်မူလျှင် “သင်ရို့က ငါ့ကို ဇာဖြစ်လို့ အပြစ်ရှာချင်ကြသနည်း။ ငွီဒင်္ဂါးပြား တစ်ပြားကို ယူခ၊ ငါ ကြည့်မည်” ဟု မိန့်တော်မူလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","သူရို့သည် ယူလာကြ၏။ ကိုယ်တော်က “ဤဒင်္ဂါးပြား၌ ဇာသူ့ရုပ်ပုံနှင့် ဇာသူ့နာမည် ပါသနည်း” ဟု မိန်းတော်မူလျှင်၊ သူရို့က “ဧကရာဇ်မင်း၏ရုပ်ပုံနှင့် သူ၏နာမည်ပါ၏” ဟု ပြန်လျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","ယေသျှုကလည်း “ဧကရာဇ်မင်းနှင့် သက်ဆိုင်သောအရာတိကို ဧကရာဇ်မင်းအား ဆက်သလော့။ ဘုရားသခင်နှင့် သက်ဆိုင်သောအရာကို ဘုရားအား ဆက်သလော့” ဟု မိန့်တော်မူလျှင်၊ သူရို့သည် အံ့သြကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","သီခြင်းမှ ရှင်ပြန်ထမြောက်ခြင်းမဟိဟု ခံယူထားကြသော ဇဒ္ဒုကဲတချို့သည် အထံတော်ပါးသို့ ချဉ်းကပ်၍ ");
INSERT INTO rki_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“ဆရာ၊ ‘လူတစ်စုံတစ်ယောက်က သားသမီးမရဘဲ သီလားခလျှင် အသက်ရှင်ကျန်ခသည့် အစ်ကို၏မယားကို ညီဖြစ်သောသူက ဆက်ခံရမည်’ ဟု အကျွန်ရို့ကို မောသျှေက မိန့်မှာခပါ၏။ ");
INSERT INTO rki_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","တစ်ခါက ညီအစ်ကိုခုနစ်ယောက် ဟိပါ၏။ အစ်ကိုအကြီးဆုံးသည် အိမ်ထောင်ပြုပြီး သားသမီး မရဘဲ သီကျလားပါ၏။ ");
INSERT INTO rki_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ထိုအခါ ဒုတိယအစ်ကိုက သူ့မရီးကို ဆက်ခံသိမ်းပိုက်ပါ၏။ ထိုအစ်ကိုသည်လည်း သားသမီးမရဘဲ သီကျလားပြန်၏။ ယင်းနည်းတူ တတိယအစ်ကိုလည်း သားသမီးမရဘဲ သီကျလားပြန်၏။ ");
INSERT INTO rki_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ယင်းနည်းတူ ညီအစ်ကို ခုနစ်ယောက်လုံးသည် ထိုမိန်းမကို လက်ထပ်၍ သားသမီးမရဘဲ သီကျလားပါ၏။ အဆုံးမှာ ယင်းမိန်းမလေ့ သီကျလား၏။ ");
INSERT INTO rki_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ညီအစ်ကို ခုနစ်ယောက်လုံး ယင်းမိန်းမနှင့် အိမ်ထောင်ပြုခသည်ဖြစ်၍ ရှင်ပြန်ထမြောက်ရာနိ့မှာ ယင်းမိန်းမသည် ဇာသူ၏ မယားဖြစ်ပါမည်နည်း” ဟု မိန်းလျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ယေသျှုက “သင်ရို့တိ ကျမ်းစာတော်မြတ်ကို နားမလည်၊ ဘုရားသခင်၏ တန်ခိုးတော် အကြောင်းကိုလည်း မသိကတ်။ ထို့ကြောင့် အယူလွဲနိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","လူသည် သီခြင်းက ထမြောက်ကြသောအခါ ထိမ်းမြားပေါင်းသင်းခြင်းကို မပြု၊ စုံဖက်ခြင်းကို မပြုဘဲ ကောင်းကင်ဘုံ၌ ကောင်းကင်တမန်တိပိုင် ဖြစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","သီလွန်သောလူတိ ရှင်ပြန်ထမြောက်သည့် အကြောင်းကို မောသျှေကျမ်း၌ မဖတ်ဖူးကြသလော။ မီးလောင်နိန်သော ခြုံပုတ်အကြောင်းကို ဖော်ပြထားသည့် ကျမ်းပိုဒ်၌ ဘုရားသခင်က ‘ငါကား အာဗြဟံ၊ ဣဇက်၊ ယာကုပ်ရို့၏ ဘုရားပေတည်း’ ဟု မောသျှေအား မိန့်တော်မူကြောင်း ဖော်ပြထား၏။ ");
INSERT INTO rki_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ထိုအသျှင်သည် သီလွန်လားခသော လူရို့၏ ဘုရားသခင် မဟုတ်၊ အသက်ရှင်သောလူရို့၏ ဘုရားသခင်ဖြစ်၏။ သင်ရို့တိ ကကောင်းကို အယူလွဲနိန်ကြသည်တကား” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ထိုသို့ မိန့်တော်မူနိန်စဉ် သူရို့အပါး၌ ကျမ်းတတ်ဆရာတစ်ယောက်ဟိ၏။ ထိုသူသည် ဇဒ္ဒုကဲရို့အား ကိုယ်တော်၏ လျောက်ပတ်စွာ ဖြေကြားတော်မူချက်ကို ကြားသဖြင့် ရှိ့တော်သို့ လာပြီးလျှင် “ပညတ်ဟိသမျှ၌ ဇာပညတ်က အကြီးမြတ်ဆုံးနည်း” ဟု ကိုယ်တော့်ကို မိန်းလျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","ယေသျှုက၊ “အို၊ ဣသရေလ အမျိုးသားရို့ နားထောင်ကြလော့။ ငါရို့၏အသျှင် ဘုရားသခင်သည် တစ်ဆူတည်းသော သခင်ဘုရားဖြစ်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","‘သင်ရို့၏ အသျှင်ဘုရားသခင်ကို စိတ်နှလုံးအကြွင့်မဲ့၊ စိတ်ဝိညာဉ်အကြွင်းမဲ့၊ ဉာဏ်စွမ်းဟိသမျှ၊ ကိုယ်စွမ်းဟိသမျှနှင့် ချစ်ရမည်’ ဟူသော ပညတ်သည် အကြီးမြတ်ဆုံးသော ပညတ်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","‘ကိုယ်နှင့်စပ်ဆိုင်သောသူကို ကိုယ်နှင့်အမျှ ချစ်ရမည်’ ဟူသော ပညတ်သည် ဒုတိယအကြီးမြတ်ဆုံး ပညတ်ဖြစ်၏။ ဤပညတ်နှစ်ပါးထက် သာ၍ ကြီးမြတ်သော ပညတ်မဟိ” ဟု ဖြေကြားတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ကျမ်းတတ်ဆရာကလည်း “ဆရာ၊ ဆရာ ဖြေကြားတော်မူချက်ကား သင့်မြတ်လှပါ၏။ ဘုရားသခင်သည် တစ်ဆူတည်းသော ဘုရားသခင်ဖြစ်တော်မူ၏။ ထိုဘုရားသခင်မှတစ်ပါး အခြားသောဘုရားမဟိပါ။ ");
INSERT INTO rki_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","‘ဘုရားသခင်အား စိတ်နှလုံးအကြွင်းမဲ့၊ စိတ်ဝိညာဉ်အကြွင်းမဲ့၊ ကိုယ်စွမ်းဟိသမျှ၊ ဉာဏ်စွမ်းဟိသမျှနှင့် ချစ်ရမည်။ ကိုယ်နှင့်စပ်ဆိုင်သောသူကို ကိုယ်နှင့်အမျှ ချစ်ရမည်’ ဟူသော ပညတ်တော်ကို လိုက်နာခြင်းသည် ဘုရားသခင်အား ပူဇော်သော မီးယှို့ရာယဇ်နှင့် အခြားယဇ်အပေါင်းတိထက် သာ၍ မြတ်ပါ၏” ဟု လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ထိုသူသည် ဤသို့အသိပညာနှင့် လျှောက်ထားသည်ကို ယေသျှုသည် သိမြင်လျှင် “သင်သည် ဘုရားသခင်၏ နိုင်ငံတော်နှင့်မဝီး” ဟု မိန့်တော်မူ။ ထို့နောက် မည်သူမျှ ကိုယ်တော့်ကို ထပ်၍ မမိန်းလျှောက်ဝံ့ကြပေ။ ");
INSERT INTO rki_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ယေသျှုသည် ဗိမာန်တော်၌ ဟောပြောသွန်သင်လျက် နိန်တော်မူစဉ် “မေသျှိယကား ဒါဝိဒ်၏မျိုးနွယ်မှ ဆင်းသက်လာလိမ့်မည်ဟု ကျမ်းတတ်ဆရာရို့က ဇာကြောင့် ပြောကြသနည်း။ ");
INSERT INTO rki_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","သန့်ယှင်းသောဝိညာဉ်တော်အားဖြင့် ဒါဝိဒ် မြွက်ဆိုသည်ကား၊ “ ‘သင်၏ရန်သူတိကို သင်၏ခြီဖဝါးအောက်သို့ ငါ ရောက်စီမည်။ ယင်းသို့ မရောက်မီကာလတိုင်အောင် ငါ၏လက်ယာဖက်၌ ထိုင်နိန်လော့’ ဟု ထာဝရဘုရားက ငါ၏အသျှင်အား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","ယင်းပိုင် ဒါဝိဒ်ကိုယ်တိုင်က ‘အသျှင်’ လို့ခေါ်သည်ဖြစ်၍ မေသျှိယသည် ဇာပိုင် ဒါဝိဒ်၏သား ဖြစ်မည်နည်း” ဟု မိန့်တော်မူ၏။ လူအပေါင်းရို့သည်လည်း ကိုယ်တော်၏ တရားဒေသနာတော်ကို ဝမ်းမြောက်စွာဖြင့် နာယူကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ထိုသို့ သွန်သင်လျက်နိန်တော်မူစဉ် ကိုယ်တော်က “ကျမ်းတတ်ဆရာရို့ကို သတိနှင့် ယှောင်ကြလော့။ ယင်းသူရို့က ဝတ်ရုံရှည်တိကို ဝတ်ပြီးလျှင် လမ်းလျှောက်တတ်ကြ၏။ ဈီးတိမှာ ရိုသီစွာ နှုတ်ဆက်သည်ကို ခံလိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","တရားဇရပ်တိ၌လည်း သီးသန့်ထားသည့် နီရာများကိုလည်းကောင်း၊ ပွဲလမ်းသဘင်တိမှာ အကောင်းဆုံးသောနီရာထိုင်ခင်းများကိုလည်းကောင်း ကြိုက်နှစ်သက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","မုဆိုးမရို့၏အိမ်တိကို မတရားသိမ်းယူကာ လူတိရှိ့၌ နားကြားကောင်းအောင် ရှည်လျားစွာ ဆုတောင်းခြင်းကို ပြုတတ်ကြ၏။ ထိုသူရို့သည် ပိုပြီး ကြီးလေးသော ပြစ်ဒဏ်ကို ခံရကြလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ယေသျှုသည် ဗိမာန်တော်၏ အလှူခံသေတ္တာအနားတွင် ထိုင်လျက်၊ သေတ္တာထဲသို့ ဖေသာဒင်္ဂါး ထည့်ဝင်လှူဒါန်းကြသည်ကို ကြည့်ရှုလျက် နိန်တော်မူ၏။ ဖေသာဒင်္ဂါး ရတတ်သောသူရို့သည် များစွာ ထည့်ဝင်လှူဒါန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ဆင်းရဲသော မုဆိုးမတစ်ယောက်သည် လာ၍၊ ကြီးဒင်္ဂါးနှစ်ပြားကို အလှူခံသေတ္တာထဲသို့ ထည့်၏။ ");
INSERT INTO rki_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ထိုအခါ ကိုယ်တော်က တပည့်တော်ရို့ကို ခေါ်၍ “‘ဤဆင်းရဲသော မုဆိုးမသည် ဗိမာန်တော်၏ အလှူခံသေတ္တာထဲတွင် ထည့်ဝင်လှူဒါန်းကြသော လူအပေါင်းရို့ထက် သာ၍ လှူဒါန်းခယာ’ ဟု သင်ရို့အား ငါအမှန် ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","အကြောင်းမူကား ထိုသူရို့က ပိုလျှံသော ဖေသာဒင်္ဂါးတိကိုသာ ထည့်လှူကြ၏။ သို့ရာတွင် ဤမုဆိုးမကား ဆင်းရဲလျက်နှင့်ပင် — မိမိ၏ချွေးနဲစာ ဟိသမျှကို ပီးလှူခ၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ယေသျှုသည် ဗိမာန်တော်မှ ထွက်ကြွတော်မူစဉ် တပည့်တော်တစ်ယောက်က “ဆရာ၊ ကြည့်ပါ။ ဧရာမကျောက်တုံးတိနှင့် ခန်းနားထည်ဝါသော အဆောက်အဦးတိပါတကား” ဟု လျှောက်လျှင်၊ ");
INSERT INTO rki_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ယေသျှုက “ဤအဆောက်အဦးကြီးတိကို သင်သည် အဂု မြင်ရ၏။ ဤအဆောက်အဦးတိမှာ ကျောက်တုံးတိ တစ်တုံးမျှမကျန် ဖြိုချခံရလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","ယေသျှုသည် သံလွင်တောင်ထက်၌ ဗိမာန်တော်ဖက်သို့ မျက်နှာမူ၍ ထိုင်နိန်တော်မူစဉ် ပေတရု၊ ယာကုပ်၊ ယောဟန်နှင့် အန္ဒြေရို့သည် ကိုယ်တော့်ထံသို့ သီးသန့်ချဉ်းကပ်ပြီးလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“ကိုယ်တော် မိန့်တော်မူသောအရာတိကား ဇာကာလ၌ ဖြစ်ပျက်မည်နည်း။ ထိုအမှုအရာများ ဖြစ်ပျက်ချိန်၌ ဇာပိုင် နိမိတ်လက္ခဏာတိ ဖြစ်လာမည်ကို အကျွန်ရို့အား မိန့်တော်မူပါ” ဟု လျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ယေသျှုက “သူတစ်ပါးလှည့်စားခြင်းကို သင်ရို့မခံရဖို့ သတိပြုကြလော့။ ");
INSERT INTO rki_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","လူအများက၊ ငါ၏အကွန်ကို ဆောင်ပြီး လာကြလိမ့်မည်။ ‘ငါကား၊ မေသျှိယ ဖြစ်၏’ ဟု ဆိုပြီးလျှင် လူတိကို လှည့်ဖြားကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","သင်ရို့သည် အဝီး၊ အပါးမှ စစ်တိုက်သောသတင်းကိုလည်းကောင်း၊ စစ်တိုက်အံ့သော သတင်းကိုလည်းကောင်း ကြားသောအခါ မထိတ်လန့်ကတ်ကေ့။ ထိုအမှုအရာတိကား ဖြစ်လာရမည်။ သို့သော်လည်း ကပ်ကမ္ဘာကုန်ဆုံးချိန်ကား မရောက်သိမ့်။ ");
INSERT INTO rki_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","လူမျိုးတစ်မျိုးနှင့်တစ်မျိုး၊ နိုင်ငံတစ်နိုင်ငံနှင့်တစ်နိုင်ငံ စစ်ဖြစ်လိမ့်မည်။ နီရာအနှံ့တွင် ငလျှင်လှုပ်ခြင်း၊ ငတ်မွတ်ခေါင်းပါးခြင်း ဖြစ်လိမ့်မည်။ ထိုအမှုအရာတိကား ရောက်လာမည့် ဆင်းရဲဒုက္ခများ၏ ရှိ့ဗြီးဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“သင်ရို့ကို သင်ရို့ သတိနှင့်နိန်ကြလော့။ လူတချို့က သင်ရို့ကို တရားရုံးသို့ ပို့ဆောင်ကြလိမ့်မည်။ တရားဇရပ်များ၌ သင်ရို့ကို ရိုက်နှက်ကြလိမ့်မည်။ သင်ရို့သည် ငါ့အတွက်ကြောင့် အာဏာပိုင်များနှင့် သျှင်ဘုရင်ရို့၏ရှိ့မှောက်သို့ ရောက်ပြီးလျှင် သတင်းကောင်းဟောပြောရသော အခွင့်ကို ရကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","သို့ရာတွင် ကပ်ကမ္ဘာကုန်ဆုံးချိန် မရောက်လာမီ သတင်းကောင်းကို လူမျိုးအပေါင်းရို့အား ဟောပြောရကြမည်။ ");
INSERT INTO rki_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","သင်ရို့ကို ဖမ်း၍ တရားရုံးသို့ ပို့သောအခါ မည်သို့ ပြောဆိုရမည်ကို မစိုးရိမ်ကတ်ကေ့။ ထိုခဏချင်းတွင် သင်ရို့၏စိတ်ထဲ၌ ပေါ်လာသော စကားတိကိုသာ ပြောလော့။ ယင်းစကားတိကား သင်ရို့၏စကား မဟုတ်၊ သန့်ယှင်းသောဝိညာဉ်တော်၏ စကားတိရာဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","ထိုကာလ၌ ညီအစ်ကိုချင်း တစ်ယောက်ကိုတစ်ယောက် သီစီခြင်းငှာ အပ်ကြလိမ့်မည်။ ဖခင်က သားကို အပ်သည်နည်းတူ သားသမီးတိကလည်း မိဘတိကို ရန်ပြုကာ သီစီကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","ငါ့ကြောင့် သင်ရို့ကို လူတိုင်းက မုန်းကြလိမ့်မည်။ သို့ရာတွင် အဆုံးတိုင်အောင် တည်ကြည်သောသူသည် ကယ်တင်ခြင်းကို ခံရလိမ့်မည်ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“ဖျက်ဆီးတတ်သော ရွံစာရာကောင်းသောအရာသည် မဟိအပ်သောနီရာ၌ ဟိနိန်သည်ကို သင်ရို့မြင်ရကြလိမ့်မည်။ ကျမ်းစာဖတ်သောသူကား ဤအချက်တိကို နားလည်လိမ့်မည်။ ယင်းပိုင် မြင်သည့်အခါ ယုဒပြည်၌ဟိသောလူတိ တောင်ထက်သို့ ဗြီးကြလော့။ ");
INSERT INTO rki_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ခေါင်မိုးထက်၌ ဟိသောသူတိ၊ အောက်သို့ဆင်းပြီးလျှင် တစ်စုံတစ်ခု ယူခြင်းငှာ အိမ်ထဲသို့ မဝင်စီကေ့။ ");
INSERT INTO rki_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","လယ်၌ ဟိသောသူကိုလည်း မိမိ၏အဝတ်ကို ယူဖို့ အိမ်သို့ မပြန်စီကေ့။ ");
INSERT INTO rki_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ထိုနိ့ရက်ကာလ၌ ပဋိသန္ဓေလွယ်သော မိန်းမနှင့် နို့စို့သူငယ်ဟိသော မိခင်ရို့သည်ကား ကကောင်းကို ခက်ခဲကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ယင်းအမှုအရာများသည် ဆောင်းရာသီတွင် မဖြစ်မည်အကြောင်း ဆုတောင်းကြလော့။ ");
INSERT INTO rki_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","အကြောင်းမူကား လောကကြီးကို ဘုရားသခင်ဖန်ဆင်းတော်မူသော ကမ္ဘာဦးအချိန်မှစ၍ အဂု မျက်မှောက်ကာလထိတိုင်ယောင် လူရို့တိ မကြုံဖူး။ နောင်ကာလ၌လည်း ကြုံရလိမ့်မည် မဟုတ်သော ထိုဆင်းရဲဒုက္ခမျိုးသည် ယင်းနိ့ရက်၌ ဖြစ်ပျက်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","သခင်ဘုရားသည် ယင်းနိ့ရက်ကာလကို တိုတောင်းစီတော်မမူလျှင် ဇာသူမျှ ထိုဖီးဒဏ်နှင့် ကင်းလွတ်နိုင်လိမ့်မည် မဟုတ်။ သို့သော်လည်း၊ ဘုရားသခင်သည် မိမိရွီးချယ်ထားသော လူတိအဖို့ ယင်းနိ့ရက်ကာလကို တိုတောင်းစီတော်မူမည်။ ");
INSERT INTO rki_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“ယင်းအချိန်ကာလ၌ တစ်စုံတစ်ယောက်သောသူက၊ ‘ကြည့်လော့။ ဤအရပ်၌ မေသျှိယ ဟိ၏၊ ထိုအရပ်၌ မေသျှိယ ဟိ၏’ ဟု ပြောဆိုသော်လည်း — မယုံကြည်ကတ်ကေ့။ ");
INSERT INTO rki_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","အကြောင်းမှုကား၊ မေသျှိယ အကွန်ဆောင်နှင့် မိစ္ဆာပရောဖက်များသည် ပေါ်လာကြလိမ့်မည်။ သူရို့သည် ဖြစ်နိုင်လျှင် ဘုရားသခင် ရွီးချယ်ထားသော သူရို့ကိုပင် လှည့်စားနိုင်ခြင်းငှာ အံ့ဖွယ်သော အမှုအရာတိနှင့် နိမိတ်လက္ခဏာတိကို ပြကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","သင်ရို့ သတိနှင့် နီကြလော့။ ဤအမှုအရာအားလုံး မဖြစ်လာမီ သင်ရို့အား ငါ ကြိုတင်ဖော် ပြထားယာ။ ");
INSERT INTO rki_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“ထိုကာလ၌ ဆင်းရဲဒုက္ခရောက်လာပြီးနောက် နီသည် မှောင်မိုက်အတိ ဖြစ်ပြီးလျှင်၊ လသည်လည်း အလင်းရောင်ကို မပီး။ ");
INSERT INTO rki_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ကြယ်တိလည်း ကောင်းကင်မှ ကြွီကျလိမ့်မည်။ ကောင်းကင်တန်းခိုးတိလည်း တုန်လှုပ်ကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ယင်းအခါ လူသားသည် ကြီးစွာသော ဘုန်းတန်ခိုးအာနုဘော်နှင့် မိုးတိမ်ထဲက ကြွလာသည်ကို မြင်ရကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ယင်းနောက် လူသားသည် မြီကြီးတစ်ပြင်လုံး၌ မိမိရွီးချယ်ထားသော လူတိကို စုရုံးစီခြင်းငှာ ကောင်းကင်တမန်တိကို မြီကြီးအရပ်လေးမျက်နှာသို့ စီရွှတ်တော်မူလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“သဖန်းပင်ကိုကြည့်၍ ကာလအချိန်ကို သိမှတ်ကြလော့။ ယင်းအပင်၏ အခက်အလက်တိက ရွက်နုထွက်လာလျှင် နွီကာလ ရောက်လုနီးသည်ကို သင်ရို့သိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ယင်းနည်းတူ ဖော်ပြခသော အမှုအရာများ ဖြစ်ပျက်နိန်သည်ကို တွိ့မြင်ရသောခါ၊ လူသားသည် သင်ရို့၏ အနီးအပါး၊ တန်းခါးဝနားသို့ ရောက်တော်မူသည်ကို သိမှတ်ကြလော့။ ");
INSERT INTO rki_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ငါ အမှန်ဆိုသည်ကား၊ အဂု အသက်ရှင်နိန်သောလူတိ မသီဆုံးမီ ဤအမှု အရာအားလုံးသည် ဖြစ်ပျက်ရလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ကောင်းကင်နှင့် မြီကြီး မတည်သော်လည်း ငါ့စကားသည် တည်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“သို့သော်၊ ယင်းအမှုအရာများ ဖြစ်ပျက်မည့် ကာလအချိန်ကိုကား — ခမည်းတော်မှတစ်ပါး ဇာသူမျှမသိ၊ ကောင်းကင်တမန်တိလည်း မသိ၊ သားတော်လည်းမသိ။ ");
INSERT INTO rki_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ထိုကာလအချိန်သည် ဇာအချိန်ရောက်လာမည်ကို သင်ရို့ မသိကြသောကြောင့်၊ သတိဖြင့် စောင့်နိန်ကြလော့။ ");
INSERT INTO rki_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ဥပမာကား၊ လူတစ်ယောက်သည် မိမိအိမ်မှ အခြားသောအရပ်သို့ ခရီးလားသောအခါ မိမိအိမ်ကို အခိုင်းအစီရို့လက်သို့ အပ်ထားခ၏။ သူရို့အား၊ ကိုယ်စီလုပ်ဆောင်ရန် လုပ်ငန်းတာဝန်များကို ပီးအပ်ခပြီး၊ တန်းခါးစောင့်ကိုလည်း သတိနှင့်စောင့်နိန်ဖို့ မှာထားခ၏။ ");
INSERT INTO rki_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","အိမ်သျှင်သည် ညဉ့်ဦးအချိန်၊ သန်းခေါင်အချိန်၊ ကြက်တွန်ချိန်၊ မိုးထဖက် အချိန်များတွင် — ဇာအချိန်၌ ပြန်လာမည်ကို သင်ရို့မသိသောကြောင့် စောင့်နိန်ကြလော့။ ");
INSERT INTO rki_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","အိမ်သျှင်သည် ရုတ်တရက် ရောက်လာသောအခါ သင်ရို့ အိပ်ပျော်နိန်သည်ကို မတွိ့စီခြင်းငှာ သတိဖြင့် စောင့်နိန်ကြလော့။ ");
INSERT INTO rki_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","သင်ရို့ သတိဖြင့် စောင့်နိန်ကြလော့ဟု ငါ ဆိုသည်အတိုင်း ခပ်သိမ်းသော သူရို့ကိုလည်း ငါ သတိပီး၏။ ယင်းကြောင့် သတိဖြင့် စောင့်နိန်ကြလော့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ပသခါပွဲနှင့် တဆီးမဲ့မုန့်ပွဲတော်မကျမီ နှစ်ရက်အလိုတွင် ကျမ်းတတ်ဆရာရို့နှင့် ယဇ်ပုရောဟိတ်အကြီးအကဲရို့သည် ယေသျှုအား တိတ်တဆိတ်ဖမ်းဆီးပြီး၊ သတ်ခြင်းငှာ နည်းလမ်းရှာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ထိုသူရို့သည် ပွဲတော်ကာလအတွင်း၌ ဖမ်းဆီးလျှင် လူရို့သည် ရုန်းရင်းဆန်ခတ်ဖြစ်မည်ကို စိုးရိမ်သောကြောင့် “မဖမ်းကေ့သိမ့်” ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","ယေသျှုသည် ဗေသနိရွာ၌ အရီပြားရောဂါ ခံစားခဖူးသော သျှိမုန်၏အိမ်၌ အစားအစာသုံးဆောင်နိန်တော်မူစဉ်၊ မိန်းမတစ်ယောက်သည် အလွန်အဖိုးထိုက်သော နာဒုဆီမွှီးအစစ်နှင့်ပြည့်သော ကျောက်ဖြူဘူးကို ခွဲ၍ ယေသျှု၏ဂေါင်းထက်မှာ သွန်းလောင်းလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","လူတချို့က မာန်ပါ၍ “ဇာကြောင့် ဆီမွှီးကို ဤပိုင်အကျိုးမဟိ ဖြုန်းတီးရသနည်း။ ");
INSERT INTO rki_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ယင်းဆီမွှီးအား ငွီဒင်္ဂါးအပြား ၃၀၀ ကျော်ဖြင့် ရောင်းပြီးလျှင် ဆင်းရဲသောလူတိကို ပီးသင့်၏” ဟု အချင်းချင်း ပြောဆို၍ ထိုမိန်းမကို အပြစ်တင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","သို့ရာတွင် ယေသျှုက၊ “ထိုမိန်းမကို ထားလိုက်။ ယင်းမိန်းမကို ဇာကြောင့် နှောက်ယှက်ကြသနည်း။ ငါ၌ သူမ ပြုသောအမှုကား လျောက်ပတ်သောအရာနှင့် ကောင်းသောအမှုအရာဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ဆင်းရဲသောလူတိကား သင်ရို့နှင့် အမြဲဟိနိန်ကြ၏။ သင်ရို့ အလိုဟိသည့်အခါ၌ သူရို့ကို ကူညီနိုင်၏။ ငါမူကား သင်ရို့နှင့် အမြဲဟိမနိန်။ ");
INSERT INTO rki_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","ဤမိန်းမသည် သူမ တတ်နိုင်သမျှနှင့် ငါ့ကို ပြုစုလီယာ။ ငါ၏ရုပ်ခန္ဓာကို သင်္ဂြိုဟ်ခြင်းငှာ ဆီမွှီးနှင့် ကြိုတင်လိမ်းကျန်လီယာ။ ");
INSERT INTO rki_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","သင်ရို့အား ငါ အမှန်ဆိုသည်ကား သတင်းကောင်းတရားကို ဟောပြောဝီငှသော လောကတစ်ခုလုံး၌ ဤမိန်းမအား အောက်မိ့သတိရစီခြင်းငှာ သူမ ပြုခသောကောင်းမှုကို ပြောကြားကြလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ထို့နောက် တပည့်တော်တစ်ဆယ့်နှစ်ပါး အပါအဝင်ဖြစ်သော ယုဒသျှာကာရုတ်သည် ယေသျှုအား ယဇ်ပုရောဟိတ်အကြီးအကဲရို့၏လက်သို့ အပ်ခြင်းငှာ လားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ထိုသူရို့သည် ယုဒ လာကြောင်းကို ကြားသိလျှင် ဝမ်းမြောက်ကြသဖြင့် သူ့အား ဖေသာပီးခြင်းငှာ ကတိကဝတ် ပြုကြ၏။ ထို့ကြောင့် ယုဒသည် ကိုယ်တော့်ကို ရန်သူ့လက်သို့ အပ်ခြင်းငှာ အခါအခွင့်ကောင်းကို ရှာကြံလျက် နိန်၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","ပသခါသိုးသူငယ်ကို သတ်ပြီး၊ ပူဇော်ရသောနိ့တည်းဟူသော တဆီးမဲ့မုန့်ပွဲတော် ပထမနိ့၌ တပည့်တော်တိက “ကိုယ်တော်အဖို့၊ ပသခါညစာပွဲကို အကျွန်ရို့သည် ဇာအရပ်သို့ လားပြီးလျှင် ပျင်ဆင်ရပါမည်နည်း” ဟု ကိုယ်တော့်ကို မိန်းလျှောက်တော်မူလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","ကိုယ်တော်သည် တပည့်တော်နှစ်ယောက်အား “သင်ရို့၊ မြို့ထဲသို့ လား၍ ရီအိုးထမ်းလာသောသူကို တွိ့လိမ့်မည်။ ထိုသူ့နောက်သို့ လိုက်လား၍၊ ");
INSERT INTO rki_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ထိုသူ ဝင်သောအိမ်သို့ ဝင်ပြီးလျှင် အိမ်သျှင်အား ‘ငါနှင့် ငါ၏တပည့်တော်ရို့သည် ပသခါညစာ စားပွဲကို စားမည့် အခန်းကား၊ ဇာမှာနည်း’ ဟု ဆရာက မိန်းကြောင်းကို ပြောကြလော့။ ");
INSERT INTO rki_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ထိုအခါ ထိုသူက အထက်ဆုံးအထပ်၌ဟိသော အသင့်ပျင်ဆင် ခင်းကျင်းထားသောအခန်းကို ပြလိမ့်မည်။ ထိုအခန်း၌ ငါရို့အဖို့ ညစာကို ပျင်ကြလော့” ဟု မိန့်မှာ၍ စီရွှတ်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ထိုတပည့်တော် နှစ်ယောက်ရို့သည် ထွက်လား၍၊ မြို့ထဲသို့ ရောက်သောအခါ ကိုယ်တော်မိန့်မှာသည်အတိုင်း တွိ့၍ ပသခါညစာကို အသင့်ပျင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ညချမ်းအချိန်ရောက်လျှင် ယေသျှုသည် တပည့်တော် တစ်ဆယ့်နှစ်ပါးရို့နှင့်အတူ ကြွလာတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ကိုယ်တော်နှင့် တပည့်တော်ရို့သည် စားပွဲ၌ စားသောက်နိန်စဉ် ယေသျှုက၊ “သင်ရို့ကို ငါ အမှန်ဆိုသည်ကား သင်ရို့အထဲ၌ — ငါနှင့်အတူ စားသောသူတစ်ယောက်သည် — ငါ့ကို သစ္စာဖောက်လိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","တပည့်တော်တိကလည်း စိတ်မကောင်းဖြစ်ကြပြီးလျှင် “ထိုသူကား အကျွန်လော” ဟု ကိုယ်တော့်ကို တစ်ယောက်ပြီးတစ်ယောက် မိန်းလျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ယေသျှုကလည်း၊ “ထိုသူကား တစ်ကျိပ်နှစ်ပါးရို့တွင် တစ်ယောက် အပါအဝင်ဖြစ်၏။ ထိုသူကား ငါနှင့်အတူ လောင်ပွန်း၌ လက်နှိုက်သောသူဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","ကျမ်းစာလာသည်အတိုင်း၊ လူသားသည် အသီခံရမည်။ သို့ရာတွင် လူသားကို ရန်သူ့လက်ထဲသို့ အပ်သောသူကား အမင်္ဂလာဟိ၏။ ထိုသူသည် မွီးဖွားခြင်းကို မခံရလျှင်၊ သူ့အတွက် ပိုပြီး ကောင်းသိမ့်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ကိုယ်တော်နှင့် တပည့်တော်ရို့သည် ညစာစားပွဲကို သုံးဆောင်လျက် နီကြစဉ်၊ ကိုယ်တော်သည် မုန့်ကိုယူ၍ ဘုရားသခင်၏ကျေးဇူးတော်ကို ချီးမွမ်းလေ၏။ ထို့နောက် မုန့်ကို ဖဲ့၍ “ဤမုန့်ကား ငါ၏ကိုယ်ခန္ဓာဖြစ်၏။ ယူပြီးလျှင် စားကြလော့” ဟု မိန့်တော်မူပြီး တပည့်တော်ရို့အား ပီးတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ထို့နောက် စပျစ်ရည်ခွက်ကို ယူ၍ ဘုရားသခင်၏ ကျေးဇူးတော်ကို ချီးမွမ်းပြီးမှ တပည့်တော်ရို့အား ပီးတော်မူလျှင် သူရို့အားလုံးသည်လည်း သောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ယေသျှုကလည်း “ဤစပျစ်ရည်ကား လူတိအဖို့ သွန်းသော ဘုရားသခင်၏ပဋိညာဉ်တော်ကို တံဆိပ်ခတ်နှိပ်ထားသော ငါ၏အသွီးပင် ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","သင်ရို့အား ငါ အမှန်ဆိုသည်ကား ဘုရားသခင်၏နိုင်ငံတော်၌ အသစ်သောစပျစ်ရည်ကို သောက်ရသည့်နိ့မတိုင်မီ ငါသည် ဤစပျစ်ရည်ကို နောက်တဖန် မသောက်” ဟု တပည့်တော်ရို့အား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ထို့နောက်တွင် ကိုယ်တော်နှင့် တပည့်တော်ရို့သည် ဓမ္မတေးခြင်းကို ဆိုလျက် သံလွင်တောင်သို့ ထွက်လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","ယေသျှုက တပည့်တော်ရို့အား၊ “ကျမ်းစာတော်မြတ်၌ ‘ငါသည် သိုးထိန်းကို ရိုက်သတ်သဖြင့် သိုးများသည် ကစဉ့်ကလျား ဖြစ်ကြလိမ့်မည်’ ဟု လာသည်နှင့်အညီ သင်ရို့သည် ငါ့ကို စွန့်ပစ်ပြီး၊ ထွက်ဗြီးလားကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","သို့သော်လည်း၊ ငါသည် သီခြင်းမှ ထမြောက်ပြီးနောက် ဂါလိလဲပြည်သို့ သင်ရို့ထက် အယင်လားနှင့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ပေတရုကလည်း “တခြားလူရို့သည် ကိုယ်တော့်ကို စွန့်ပစ်ကြသော်လည်း၊ အကျွန် မစွန့်ပါ” ဟု လျှောက်လျှင်၊ ");
INSERT INTO rki_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ယေသျှုက “သင့်ကို ငါ အမှန်ပြောမည်။ ဤနိ့ညဉ့်၌ပင် ကြက်နှစ်ကြိမ်မတွန်မီ သင်သည် ငါ့ကို မသိဟု သုံးကြိမ်တိုင်တိုင် ငြင်းဆိုလိမ့်မည်” ဟု ပေတရုအား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ပေတရုကလည်း “အကျွန်ကား ကိုယ်တော်နှင့်အတူ သီရသော်လည်း ကိုယ်တော့်ကို မသိဟု မငြင်းပါ” ဟူ၍ တည်ကြည်စွာ လျှောက်ထား၏။ အခြားသောတပည့်တော်ရို့သည်လည်း ထိုနည်းတူ လျှောက်ထားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ထို့နောက် ယေသျှုနှင့် တပည့်တော်ရို့သည် ဂေသယှေမန်ဟု တွင်သောအရပ်သို့ ရောက်ကြ၏။ ကိုယ်တော်က “ငါ ဆုတောင်းနိန်စဉ် သင်ရို့သည် ဤနီရာ၌ ထိုင်နိန်ကြလော့” ဟု တပည့်တော်ရို့အား မိန့်တော်မူပြီးလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ပေတရု၊ ယာကုပ်နှင့် ယောဟန်ရို့ကို မိမိနှင့်အတူ ခေါ်လားတော်မူ၏။ ထိုအခါ ကိုယ်တော်သည် စိတ်ဆင်းရဲခြင်းနှင့် ပူပန်ခြင်းသို့ ရောက်တော်မူသဖြင့်၊ ");
INSERT INTO rki_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","“ငါသည် သီမတတ် စိတ်နှလုံး ညှိုးငယ်ရ၏။ ဤအရပ်မှ သတိဖြင့် စောင့်နိန်ကြလော့” ဟု တပည့်တော်သုံးယောက်အား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ထို့နောက် ကိုယ်တော်သည် ရှိ့သို့ အနည်းငယ် ကြွတော်မူ၍ မြီထက်၌ ပျပ်ဝပ်တော်မူပြီးလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“ဖခမည်းတော်၊ ကိုယ်တော်သည် ခမ်းသိမ်းသောအမှုအရာတိကို တတ်နိုင်တော်မူပါ၏။ ယင်းကြောင့် ဤဒုက္ခဝေဒနာခွက်ကို အကျွန်ပါးက လွှဲဖယ်ပီးတော်မူပါ။ သို့သော် အကျွန်၏ အလိုဆန္ဒအတိုင်း မဟုတ်ဘဲ၊ ကိုယ်တော်၏ အလိုတော်အတိုင်းသာ ဖြစ်စီတော်မူပါ” ဟု ဆိုလျက် မိမိခံရမည့် ဝေဒနာကို ဖြစ်နိုင်တော်မူလျှင် လွှဲဖယ်ပီးတော်မူခြင်းငှာ ဆုတောင်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ထို့နောက် ကိုယ်တော်သည် တပည့်တော်သုံးယောက် ပါးသို့ ပြန်လာတော်မူရာတွင် သူရို့သည် အိပ်ပျော်နိန်ကြသည်ကို တွိ့တော်မူ၍ “သျှိမုန်၊ သင်သည် အိပ်ပျော်နိန်သလော။ မအိပ်ဘဲနှင့် တစ်နာရီလောက်တောင် စောင့်၍ မနိန်နိုင်သလော” ဟု ပေတရုအား မိန်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","ထို့နောက် ကိုယ်တော်က “သင်ရို့သည် စုံစမ်းသွီးဆောင်ရာသို့ မလိုက်မပါစီရန် ဆုတောင်း၍ စောင့်နိန်ကြလော့။ စိတ်ဝိညာဉ်ကား စေတနာဟိသော်လည်း၊ ကိုယ်မူကား အားနည်း၏” ဟု သူရို့အား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ကိုယ်တော်သည် တဖန် ကြွတော်မူ၍ အယင်နည်းတူ ဆုတောင်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ယင်းနောက် တပည့်တော်သုံးယောက်ပါးသို့ ကြွလာတော်မူသောအခါ သူရို့သည် မျက်စိလီးလံသဖြင့် တဖန် အိပ်ပျော်နိန်ကြသည်ကို တွိ့မြင်တော်မူ၏။ သူရို့သည် ကိုယ်တော့်ကို မည်သို့ လျှောက်ထားရမည်ကို မသိကြ။ ");
INSERT INTO rki_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ကိုယ်တော်သည် သူရို့ထံပါးသို့ တတိယအကြိမ် ကြွလာပြီးလျှင်၊ “သင်ရို့၊ အဂုထိတိုင် အိပ်ပျော်နိန်တုန်း၊ နားနိန်တုန်းလော့။ ကောင်းယာ။ ထကြလော့။ လူသားကို ဆိုးသောသူရို့၏ လက်ထဲသို့ အပ်နှံမည့်အချိန် အဂုရောက်လာယာ။ ");
INSERT INTO rki_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ထကြ။ ငါရို့ လားကတ်မေ။ ငါ့ကို ရန်သူ၏လက်သို့ အပ်မည့်သူသည် ရောက်လာဗျာယ်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ယေသျှုသည် ထိုသို့ မိန့်တော်မူစဉ်တွင် တစ်ကျိပ်နှစ်ပါးအဝင်ဖြစ်သော ယုဒနှင့်အတူ လူရို့သည် တုတ်၊ ဓားကို ကိုင်ဆောင်၍ ရောက်လာကြ၏။ ထိုသူရို့သည် ယဇ်ပုရောဟိတ်အကြီးအကဲတိ၊ ကျမ်းတတ်ဆရာတိနှင့် ဘာသာရေးခေါင်းဆောင်တိက စီရွှတ်သောကြောင့် ရောက်လာကြ ခြင်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ယုဒကလည်း “ငါ နမ်းသောသူကား ယေသျှုပင်ဖြစ်၏။ ယင်းသူကို ဖမ်းဆီးပြီးလျှင် အစောင့်တိနှင့် ခေါ်လားကြ” ဟု သူရို့အား အမှတ်ပီးထားခ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ယုဒသည် ရောက်လာလျှင် ချက်ချင်းပင် ယေသျှု အပါးသို့ ကပ်၍ “ဆရာ” ဟု ဆိုလျက် ကိုယ်တော့်ကို နမ်းလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ထို့နောက် လူတိက ယေသျှုကို ဖမ်းဆီးချုပ်ကိုင် ထားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ထိုအခါ အနား၌ ရပ်နိန်သော သူတစ်ယောက်သည် ဓားကို ဆွဲထုတ်၍ ယဇ်ပုရောဟိတ်မင်း၏ အခိုင်းအစီတစ်ယောက်ကို ခွတ်လိုက်ရာ၊ ထိုသူသည် နားရွက်ပြတ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","ယေသျှုက “သင်ရို့သည်၊ ဒါးပြတစ်ယောက်ကို ဖမ်းသည့်နည်းတူ ငါ့ကို ဖမ်းဖို့ တုတ်၊ ဒါးတိနှင့် လာကြသလော။ ");
INSERT INTO rki_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ငါသည် နိ့စဉ်နိ့တိုင်း ဗိမာန်တော်ထဲ၌ ဟောပြောသွန်သင်လျက် သင်ရို့နှင့်အတူ ဟိနိန်သောအခါ သင်ရို့သည် ငါ့ကို မဖမ်းကတ်။ သို့သော်၊ ကျမ်းစာလာသည်အတိုင်း ဖြစ်ရမည်” ဟု ထိုသူရို့အား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ထိုအခါ တပည့်တော်ရို့သည် ကိုယ်တော့်ကို စွန့်၍ ထွက်ဗြီးကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ပိတ်စလွှာတစ်ခုကိုဝတ်ထားသော လူငယ်တစ်ယောက်သည် ကိုယ်တော်၏ နောက်မှ လိုက်လာ၏။ လူအချို့က ထိုသူကို ဖမ်းဆီးခြင်းငှာ ပြုသောအခါ ");
INSERT INTO rki_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ထိုသူသည် ပိတ်စလွှာကို စွန့်ပစ်၍ အဝတ်မပါဘဲ ထွက်ဗြီးလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ထိုသူရို့သည် ယေသျှုအား ယဇ်ပုရောဟိတ်မင်းထံသို့ ခေါ်ဆောင်လားကြ၏။ ထိုနီရာ၌ ယဇ်ပုရောဟိတ်အကြီးအကဲရို့၊ လူအကြီးအကဲရို့နှင့် ကျမ်းတတ်ဆရာရို့သည် စုရုံးလျက် ဟိနိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ပေတရုသည် ယဇ်ပုရောဟိတ်မင်း၏ ကျောင်းတော်ဝင်းအတွင်းထိတိုင် ကိုယ်တော်နှင့် မနီးမဝီးမှ လိုက်လာပြီးလျှင်၊ ယဇ်ပုရောဟိတ်မင်း၏ ကိုယ်ရံတော်တပ်သားတိနှင့်အတူ မီးလှုံ၍ နိန်၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ယဇ်ပုရောဟိတ်အကြီးအကဲရို့နှင့်တကွ ယုဒတရားလွှတ်တော် အဖွဲ့ဝင်အပေါင်းရို့သည် ယေသျှုအား သီဒဏ်ပီးနိုင်ခြင်းငှာ သက်သီအထောက်အထားများကို ရှာကြသော်လည်း မတွိ့နိုင်ကြ။ ");
INSERT INTO rki_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","လူရို့သည် မမှန်သောသက်သီများကို ပြုကြ၏။ သို့သော် သူရို့၏ ထွက်ဆိုချက်များသည် ကိုက်ညီမှုမဟိကြပေ။ ");
INSERT INTO rki_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","ထို့နောက် လူတချို့သည် ထ၍ မမှန်သောသက်သီဖြင့် ယေသျှုတစ်ဖက်၌ ပြောကြသည်မှာ၊ ");
INSERT INTO rki_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“ဤသူကား၊ လူ့လက်ဖြင့် ဆောက်လုပ်ထားသော ဤဗိမာန်တော်ကို ငါ ဖြိုဖျက်ပြီးလျှင် လူ့လက်ဖြင့် မဆောက်ရသော ဗိမာန်တော်ကို သုံးရက်အတွင်း ငါ တည်ဆောက်မည်ဟု ပြောသည်ကို အကျွန်ရို့ကိုယ်တိုင် ကြားပါ၏” ဟု မမှန်သော သက်သီကို ထွက်ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","သို့ရာတွင် သူရို့၏ ထွက်ဆိုချက်များသည် အချင်းချင်းပင်လျှင် မကိုက်ညီကြပေ။ ");
INSERT INTO rki_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ယဇ်ပုရောဟိတ်မင်းသည် လူရို့ရှိ့၌ ရပ်ပြီးလျှင် ယေသျှုအား “ယင်းသူရို့က သင့်အား စွပ်စွဲပြောဆိုနိန်ကြသည်ကို သင်သည် ပြန်ပြောဖို့ ဇာတစ်ခုမျှ မဟိသလော” ဟု မိန်း၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","သို့သော် ကိုယ်တော်က ဇာတစ်ခွန်းမျှ မဖြေဘဲ တိန်းနိန်တော်မူ၏။ တဖန် ယဇ်ပုရောဟိတ်မင်းက ကိုယ်တော့်ကို “သင်ကား မင်္ဂလာဟိတော်မူသော ဘုရားသခင်၏ သားတော် မေသျှိယလော” ဟု မိန်း၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ယေသျှု ကလည်း “မှန်ပေ၏။ သင် ပြောသည့်အတိုင်း ငါ ဖြစ်၏။ လူသားသည် အနန္တတန်ခိုးသျှင်၏ လက်ယာဖက်၌ ထိုင်လျက်၊ မိုးတိမ်ကို စီးလျက် ကြွလာသည်ကို သင်ရို့သည် မြင်ရကြလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ထိုအခါ ယဇ်ပုရောဟိတ်မင်းသည် မိမိအဝတ်ကို ဆွဲဖြဲ၍ “ငါရို့ ဇာသက်သီကို လိုသိမ့်သနည်း။ ");
INSERT INTO rki_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ဤသူသည် ဘုရားသခင်အား ပြစ်မှားပြောဆိုသည်ကို သင်ရို့ ကြားရကြဗျာယ်။ သင်ရို့ ဇာပိုင် စီရင်ချက် ချမှတ်မည်နည်း” ဟု ဆို၏။ ထိုအခါ သူရို့သည် ယေသျှုအား သီဒဏ်ပီးရန် သဘောတူကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","လူတချို့က ယေသျှုကို တန်းထွီးနှင့်ထွီးကြ၏။ မျက်နှာတော်ကို ဖုံးအုပ်ပြီးလျှင် ရိုက်နှက်ကြ၏။ “သင့်အား ဇာသူ ရိုတ်နှက်သည်ကို ဟောပြောပါ” ဟု ပြောဆိုကြ၏။ ထို့နောက် ယဇ်ပုရောဟိတ်မင်း၏ ကိုယ်ရံတော်တပ်သားရို့သည် ကိုယ်တော့်ကို ခေါ်ဆောင်လားကြ၏။ သူရို့သည် ကိုယ်တော်၏ ပါးကိုလည်း သတ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ပေတရုသည် ကျောင်းတော်ဝင်းအတွင်း၌ ဟိနိန်စဉ် ယဇ်ပုရောဟိတ်မင်း၏ အစီခံမိန်းမသျှေ တစ်ယောက်သည် ရောက်လာ၍၊ ");
INSERT INTO rki_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ပေတရု မီးလှုံနိန်သည်ကို မြင်သောအခါ သူ့ကို စိ့စိ့ကြည့်လျက် “သင်သည်လည်း နာဇရက်မြို့သား ယေသျှု၏ အပေါင်းအပါ ဖြစ်၏” ဟု ဆိုလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ပေတရုက “သင် ပြောနိန်စွာကို ငါ မသိ၊ ငါ နားမလည်” ဟု ငြင်းဆိုပြီးလျှင် ခြံဝင်း၏ ဝင်ပေါက်သို့ လားလေ၏။ ထိုအချိန်၌ ကြက်တစ်ကြိမ် တွန်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","အစီခံမိန်းမသျှေသည် ပေတရုကို တဖန် မြင်ပြန်လျှင် အနား၌ ရပ်နိန်ကြသောသူရို့အား “ဤသူကား ထိုသူရို့နှင့် အပေါင်းအပါဖြစ်၏” ဟု ဆိုပြန်၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ပေတရုကလည်း မဟုတ်ကြောင်းကို ငြင်းဆိုပြန်၏။ ထို့နောက် အနား၌ ရပ်နိန်သောသူရို့က “သင်သည် ဂါလိလဲပြည်သားဖြစ်၍ သူရို့နှင့် အပေါင်းအပါ အမှန်ပင်ဖြစ်မည်” ဟု ပေတရုအား ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ပေတရုကလည်း “သင်ရို့ပြောသောသူကို ငါ အမှန်မသိကြောင်းကို ငါကျိန်ဆို၏။ ငါ ပြောသောအရာ မမှန်လျှင် ဘုရားသခင်သည် ငါ့အား ဒဏ်ခတ်ပါစီ” ဟု ပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ထိုသို့ ပြောဆိုပြီးခဏချင်းတွင် ဒုတိယအကြိမ် ကြက်တွန်လေ၏။ ထိုအခါ “ကြက်နှစ်ကြိမ်မတွန်ခင် သင်သည် ငါ့ကို မသိဟူ၍ သုံးကြိမ်တိုင်တိုင် ငြင်းလိမ့်မည်” ဟု ယေသျှု မိန့်တော်မူခသောစကားကို ပြန်သတိရသဖြင့် ပေတရုသည် ပြင်းစွာ ငိုကြွီးလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","မိုးထစောစော၌ ယဇ်ပုရောဟိတ်အကြီးအကဲသည် ကျမ်းပြုဆရာတိ၊ လူအကြီးအကဲတိ၊ ယုဒတရားလွှတ်တော် အဖွဲ့ဝင်တိနှင့် အလျင်အမြန် တွိ့ဆုံကာ စည်းဝေးတိုင်ပင်ကြ၏။ ထို့နောက် ယေသျှုအား ကြိုးဖြင့်တုပ်ပြီးလျှင် ပိလတ်မင်းထံသို့ ပို့ဆောင်၍ အပ်လိုက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ပိလတ်မင်းက “သင်သည် ယုဒသျှင်ဘုရင်ဆိုသည်မှာ မှန်သလော” ဟု ကိုယ်တော့်ကို မိန်းလေ၏။ ယေသျှုက “မင်းကြီးပြောသည့်အတိုင်း အမှန်ပင်ဖြစ်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","ယဇ်ပုရောဟိတ်အကြီးအကဲရို့သည် ယေသျှုကို အမျိုးမျိုး ပြစ်တင်စွပ်စွဲကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ထို့ကြောင့် ပိလတ်မင်းသည် ကိုယ်တော့်ကို “သင်သည် တစ်ခွန်းမျှမဖြေဘဲ နိန်ပါသည်တကား။ သင့်ကို ဇာလောက် အပြစ်တင်စွပ်စွဲ နိန်ကြသည်ကို ကြည့်ပါ” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ယေသျှုသည် စကားတစ်ခွန်းကိုမျှ ပြန်၍ ဖြေတော်မမူသဖြင့် ပိလတ်မင်းသည် အံ့သြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ပိလတ်မင်းသည် ပသခါပွဲအချိန်ကျတိုင်း လူရို့တောင်းဆိုသော ထောင်သားတစ်ယောက်ကို လွတ်ငြိမ်းခွင့် ပီးလေ့ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ထိုအချိန်တွင် ဗာရဗ္ဗအမည်ဟိသော သူတစ်ယောက်သည် ဆူပူအုံကြွမှု၌ ပုန်ကန်မှု နှင့် လူသတ်မှုဖြင့် အခြားသောပုန်ကန်သူများနှင့်အတူ ထောင်ကျလျက် ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","လူအပေါင်းရို့သည် ပွဲတော်အချိန်အခါ၌ ပြုလေ့ဟိသည့်အတိုင်း ပြုစီခြင်းငှာ ပိလတ်မင်းထံ စုရုံးပြီး တောင်းဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ထိုအခါ ပိလတ်မင်းက “သင်ရို့၊ ယုဒသျှင်ဘုရင်ကို လွတ်စီချင်သလော” ဟု မိန်း၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ထိုသို့ မိန်းရသည့်အကြောင်းမှာ ယဇ်ပုရောဟိတ်အကြီးအကဲရို့သည် ယေသျှုအား မနာလိုသောစိတ်နှင့် မိမိထံသို့ အပ်နှံကြကြောင်းကို သိသောကြောင့်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","သို့ရာတွင် ယဇ်ပုရောဟိတ်အကြီးအကဲရို့က ယေသျှုကို မလွတ်စီဘဲ၊ ဗာရဗ္ဗကိုသာ လွတ်စီခြင်းငှာ ပိလတ်မင်းအား တောင်းဆိုကြရန် လူစုလူဝေးကို ပို၍လှုံ့ဆော်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","တဖန် ပိလတ်မင်းက “သင်ရို့ ‘ယုဒသျှင်ဘုရင်’ ဟု ခေါ်သောသူကို ဇာပိုင်လုပ်ရမည်နည်း” ဟု ပြန်၍မိန်းလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","လူအုပ်ကြီးက “ယင်းသူကို လက်ဝါးကပ်တိုင်ထက်မှာ တင်၍ထားပါ” ဟု အော်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ပိလတ်မင်းကလည်း “ဤသူ ဇာအပြစ်ကို လုပ်ထားသနည်း” ဟု မိန်းတော်မူလျှင်၊ ထိုသူအပေါင်းရို့သည် “ယင်းသူကို လက်ဝါးကပ်တိုင်ထက်မှာ တင်ထားပါ” ဟု ပို၍ အော်ဟစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ပိလတ်မင်းသည်လည်း လူအပေါင်းရို့၏စိတ်ကို ကြေနပ်စီလို၍ သူရို့အဖို့ ဗာရဗ္ဗကို လွတ်စီပြီးလျှင် ယေသျှုကိုမူ ကြာပွတ်ဖြင့် ရိုက်စီပြီး လက်ဝါးကပ်တိုင်ထက်၌ သတ်ခြင်းငှာ အပ်လိုက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ထိုအခါ စစ်သားရို့သည် ယေသျှုအား အိမ်ဝင်းအတွင်းသို့ ခေါ်ဆောင်လားပြီးလျှင် စစ်သားတိကို စုရုံးစီပြီးမှ၊ ");
INSERT INTO rki_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ကိုယ်တော့်ကို နီမောင်းသောအဝတ်ကို ဝတ်စီပြီးလျှင် ဆူးဖြင့် ရက်သောသရဖူကို ဆောင်းစီ၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ထို့နောက် “ယုဒသျှင်ဘုရင် အသက်တော်ရှည်ပါစီ” ဟု ပျက်ရယ်ပြုလျက်၊ အရိုအညွှတ် ပြုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ဦးဂေါင်းတော်ကို ကျူလုံးနှင့် ရိုက်ပုတ်ပြီးလျှင်၊ တန်းထွီးဖြင့် ထွီးကာ ရှိ့တော်၌ ဒူးထောက်လျက် ဦးညွှတ်ရှိခိုးကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ထိုသို့ သရော်ကြပြီးလျှင် နီမောင်းသောအဝတ်ကို ချွတ်၍၊ ကိုယ်တော်၏အဝတ်ကို ပြန်၍ ဝတ်စီပြီး၊ လက်ဝါးကပ်တိုင်ထက်၌ သတ်ခြင်းငှာ ထုတ်လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","ထိုအချိန်၌ အာလေဇန္ဒြုနှင့် ရုဖုရို့၏အဖ သျှိမုန်အမည်ဟိသော ကုရေနေပြည်သား တစ်ယောက်သည် တောရွာမှ မြို့သို့လာ၏။ စစ်သားရို့ကလည်း ထိုသူအား အတင်းခေါ်၍ ယေသျှုထမ်းသော လက်ဝါးကပ်တိုင်ကို ထမ်းစီကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ထို့နောက် ယေသျှုကို ဦးဂေါင်းခွံအရပ်ဟု ခေါ်တွင်သော ဂေါလဂေါသအရပ်သို့ ခေါ်ဆောင်လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","သူရို့သည် မုရန်နှင့် ရောစပ်ထားသော စပျစ်ရည်ကို ကိုယ်တော့်ကို သောက်စီခြင်းငှာ တိုက်ကြ၏။ သို့ရာတွင် ကိုယ်တော်သည် သောက်တော်မမူ။ ");
INSERT INTO rki_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ထို့နောက် သူရို့သည် ကိုယ်တော့်ကို လက်ဝါးကပ်တိုင်ထက်၌ ရိုက်ထားကြ၏။ အဝတ်တော်ကိုကား မဲနှိုက်၍ ခွဲဝီယူကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ကိုယ်တော့်ကို လက်ဝါးကပ်တိုင်ထက်တွင် ရိုက်ထားသောအချိန်ကား မိုးထဖက် ကိုးနာရီအချိန်၌ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","အပြစ်ဖော်ပြသော ကမ္ပည်းလိပ်စာဟူမူကား “ယုဒသျှင်ဘုရင်” ဟု ရီးထားကာ၊ ကိုယ်တော်၏ဦးဂေါင်းတော်ထက်၌ ကပ်ထား၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ကိုယ်တော်နှင့်အတူ ဒါးပြနှစ်ယောက်ကိုလည်း လက်ယာတော်ဖက်၌ တစ်ယောက်၊ လက်ဝဲတော်ဖက်၌ တစ်ယောက် ထား၍ လက်ဝါးကပ်တိုင်ထက်တွင် ရိုက်ထားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","လမ်း၌ လား၊ လာနိန်ကြသောသူ များကလည်း “လွန်း၊ ဗိမာန်တော်ကို ဖြိုဖျက်ပြီး၊ သုံးရက်အတွင်းမှာ ပြန်ပြီးတည် ဆောက်ပြမည့်သူ၊ ");
INSERT INTO rki_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ကိုယ့်ကိုယ်ကို ကယ်တင်ပါလား၊ လက်ဝါးကပ်တိုင်ထက်က ဆင်းလာပါလား” ဟု ခေါင်းတညိတ်ညိတ်ဖြင့် ကဲ့ရဲ့ကာ အော်ဟစ်ပြောဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","ထိုနည်းတူ ယဇ်ပုရောဟိတ်အကြီးအကဲရို့နှင့် ကျမ်းတတ်ဆရာရို့ကလည်း “ဤသူသည် သူတစ်ပါးကို ကယ်တင်တတ်ပြီးလျှင် ကိုယ့်ကိုယ်ကို မကယ်တင်နိုင်ပါတကား၊ ");
INSERT INTO rki_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ဣသရေလသျှင်ဘုရင်၊ မေသျှိယသည် ကိုယ့်ကိုယ်ကို ကယ်တင်ကာ လက်ဝါးကပ်တိုင်ထက်မှ အဂု ဆင်းလာပါ။ ယင်းပိုင် ဆင်းလာလျှင် ငါရို့ယုံကြည်မည်” ဟု အချင်းချင်း ပြောဆို၍ လှောင်ပြောင်သရော်ကြ၏။ ကိုယ်တော်နှင့်အတူ လက်ဝါးကပ်တိုင်ထက်၌ ရိုက်ထားခြင်းကို ခံရသူတိကလည်း ထိုသို့ သရော်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","မွန်းတည့်အချိန်မှ စ၍ မွန်းလွဲသုံးနာရီတိုင်အောင် မြီကြီးတစ်ပြင်လုံး၌ မှောင်မိုက်အတိ ဖြစ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","မွန်းလွဲ သုံးနာရီအချိန်၌ ယေသျှုသည် “ဧလိ၊ ဧလိ၊ လာမ ရှာဗခသာနိ” ဟု အသံကျယ်စွာ အော်ကြွီးတော်မူ၏။ အဓိပ္ပာယ်ကား “အကျွန့် ဘုရားသခင်၊ အကျွန့် ဘုရားသခင်၊ အကျွန့်ကို ဇာကြောင့် စွန့်ပစ်သနည်း” ဟူ၍ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","အနီးအပါး၌ ရပ်နိန်သော လူတချို့သည် ထိုစကားကို ကြားလျှင် “နားထောင်လော့၊ သူသည် ဧလိယကို ခေါ်သည်” ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","လူတစ်ယောက်သည် ဗြီးလာ၍ ပုံးရည်ကို ရီမြုပ်ဖြင့် စုပ်ယူပြီးနောက် ထိုရီမြုပ်ကို ကျူလုံးဖျား၌ တပ်၍ ကိုယ်တော့်ကို သောက်စီခြင်းငှာ ပီးလျက်၊ “ဧလိယက လက်ဝါးကပ်တိုင်မှ သူ့ကိုကယ်ဖို့လာမည်၊ မလာမည်ကို ငါရို့ ကြည့်နိန်ကြကုန်အံ့” ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","ယေသျှုသည် ကြီးသောအသံနှင့် ကြွေးကြော်တော်မူပြီးနောက် အသက်တော်ကို စွန့်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ထိုအချိန်၌ ဗိမာန်တော်၏ကန့်လန့်ကာသည် အထက်စွန်းမှ အောက်စွန်းထိတိုင် နှစ်ခြမ်းကွဲလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ကိုယ်တော်၏ရှိ့တွင် ရပ်နိန်သောတပ်မှူးသည် ကိုယ်တော်၏ အသက်တော်ချုပ်ပုံကို မြင်သဖြင့် “ဤသူကား၊ စင်စစ် ဘုရားသခင်၏ သားတော်ဖြစ်၏” ဟု ဆိုလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","မိန်းမတချို့သည် အဝီးမှ ရပ်၍ ကြည့်နိန်ကြ၏။ ထိုမိန်းမရို့တွင် မာဂဒလမြို့သူ မာရိ၊ လူငယ်ယာကုပ်နှင့် ယောသေ ရို့၏အမိ မာရိနှင့် သျှာလုံ ရို့လည်းပါ၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ထိုမိန်းမရို့ကား၊ ကိုယ်တော်သည် ဂါလိလဲပြည်၌ ဟိတော်မူခစဉ် နောက်တော်သို့ လိုက်၍ အလုပ်အကျွေးပြုကြသူများ ဖြစ်ကြ၏။ သူမရို့သာမက ကိုယ်တော်နှင့်အတူ ယေရုဆလင်မြို့သို့ လိုက်ပါလာသော အခြားမိန်းမများလည်း ထိုအရပ်၌ ဟိနိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","ထိုနိ့ကား အဖိတ်နိ့ဖြစ်၏။ ညအချိန် ရောက်သောအခါ၊ အသရေဟိသော လွှတ်အရာဟိ၊ အရိမဿဲမြို့သား ယောသပ်သည် ဘုရားသခင်၏ နိုင်ငံတော်ကို မျှော်လင့်နိန်သော သူဖြစ်သည်အလျောက်၊ ပိလတ်မင်းထံသို့ ရဲရင့်စွာ ဝင်ပြီးလျှင် ယေသျှု၏အလောင်းတော်ကို တောင်းလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ကိုယ်တော်၏ အသက်ချုပ်တော်မူကြောင်းကို ပိလတ်မင်းကြားလျှင် အံ့ဩခြင်းဟိသဖြင့် တပ်မှူးကို ခေါ်၍ ယေသျှုသီလားသည်ကား ကြာဗျာလောဟု မိန်းလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","သီကြောင်းကို တပ်မှူးအားဖြင့် သိရလျှင် အလောင်းတော်ကို ယောသပ်အား ပီးလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ယောသပ်သည် ပိတ်ချောထည်ကို ဝယ်ပြီးလျှင် အလောင်းတော်ကို လက်ဝါးကပ်တိုင်ထက်မှ ချ၍ ပိတ်စထည်ဖြင့်ပတ်၏။ ထို့နောက် ကျောက်၌ထွင်းထားသော သင်္ချိုင်းဂူတွင် သင်္ဂြိုဟ်ပြီးလျှင် ဂူဝ၌ ကျောက်တုံးကြီးကို လှိမ့်၍ ပိတ်ထားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","မာဂဒလမြို့သူ မာရိနှင့် ယောသေ၏အမိ မာရိ ရို့သည် အလောင်းတော်အား သင်္ဂြိုဟ်သောနီရာကို တွိ့မြင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ဥပုသ်နိ့ လွန်ပြီးနောက် မာဂဒလမြို့သူ မာရိ၊ ယာကုပ်၏အမိ မာရိနှင့် သျှာလုံ ရို့သည် ယေသျှု၏အလောင်းတော်ကို လိမ်းကျန်ခြင်းငှာ အမွှီးနံ့သာများကို ဝယ်ယူကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","တလင်းဂနီနိ့ မိုးထစောစော၊ နီထွက်ချိန်၌ သင်္ချိုင်းသို့ လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","ထိုသို့ လားကြစဉ်တွင် လမ်း၌ သူမရို့သည် “ဂူဝမှာ ပိတ်ထားသောကျောက်ကို အကျွန်ရို့အတွက် ဇာသူက လှိမ့်ဖယ်ပီးမည်နည်း” ဟု အချင်းချင်း ပြောဆိုကြ၏။ အကြောင်းမူကား ထိုကျောက်တုံးသည် အလွန်ကြီးမားသောကြောင့်ဖြစ်သတည်း။ သို့ရာတွင် သင်္ချိုင်းဂူဝသို့ ရောက်၍ ကြည့်လိုက်သောအခါ ကျောက်တုံးမှာ လှိမ့်ဖယ်ထားပြီးသား ဟိသည်ကို တွိ့ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ထိုမိန်းမရို့သည် ဂူထဲသို့ ဝင်ကြလျှင် ဝတ်ရုံဖြူကို ဝတ်ဆင်ထားသော လုလင်တစ်ယောက်သည် လက်ယာဖက်၌ ထိုင်နိန်သည်ကို မြင်ကြသဖြင့် — ကြောက်လန့်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ထိုသူကလည်း “မကြောက်ကတ်ကေ့။ သင်ရို့သည် လက်ဝါးကပ်တိုင်ထက်မှာ တင်၍ အသတ်ခံရသော နာဇရက်မြို့သား ယေသျှုကို လာရှာကြသည် မဟုတ်လော။ ထိုအသျှင်ကား ဤအရပ်တွင် မဟိ — သီခြင်းမှ ထမြောက်အသက်ရှင်တော်မူဗျာ။ ကြည့်ကြလော့။ ဤနီရာကား ထိုအသျှင်၏ အလောင်းတော်ကို ထားသောနီရာဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","သင်ရို့က ပေတရုနှင့်တကွ အခြားသောတပည့်တော်တိပါးသို့ အဂုလား၍ အယင်က သင်ရို့ကို မိန့်တော်မူခသည့်အတိုင်း၊ ကိုယ်တော်သည် ဂါလိလဲပြည်သို့ သင်ရို့ထက် အယင် ကြွလားတော်မူကြောင်းကို ပြောပြကြလော့။ ထိုပြည်တွင် ကိုယ်တော့်ကို တွိ့လိမ့်မည်” ဟု ပြောဆို၏။ ");
INSERT INTO rki_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ထိုမိန်းမရို့သည် ထိန့်လန့်တုန်လှုပ်၍ သင်္ချိုင်းဂူမှ ထွက်ဗြီးကြ၏။ သူမရို့သည် ကြောက်လန့်သောကြောင့် မည်သူ့ကိုမျှ မပြောပြကြပေ။ သတင်းကောင်း၏ နည်းဟောင်းအဆုံးသတ်တစ်မျိုး  ");
INSERT INTO rki_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","ယေသျှုသည် သီခြင်းမှ ထမြောက်တော်မူပြီးနောက် တလင်းဂနီနိ့ မိုးထစောစောအချိန်၌ မာဂဒလမြို့သူ မာရိအား ဦးစွာကိုယ်ထင်ပြတော်မူ၏။ ကိုယ်တော်သည် သူမထံပါးမှ နတ်ဆိုးခုနစ်ကောင်ကို နှင်ထုတ်ပီးခဖူး၏။ ");
INSERT INTO rki_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ထိုမာရိသည် ညည်းတွားငိုကြွီးလျက် ဟိနိန်ကြသော တပည့်တော်ရို့ပါးသို့ လား၍ ထိုသတင်းတော်ကို ကြားပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","ယေသျှုသည် အသက်ရှင်တော်မူကြောင်းကိုလည်းကောင်း၊ မာရိသည် ယေသျှုကို တွိ့မြင်ခရသည်ကိုလည်းကောင်း၊ သူရို့သည် ကြားကြသော်လည်း မယုံကြပေ။ ");
INSERT INTO rki_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ထို့နောက်၊ တပည့်တော်နှစ်ပါးရို့သည် တောရွာသို့ လားကြစဉ်တွင် ယေသျှုသည် ထူးခြားသောအသွင်ဖြင့် သူရို့အား ကိုယ်ထင်ပြတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","သူရို့သည် အခြားသော တပည့်တော်ရို့ပါးသို့ လား၍ ထိုသတင်းကို ပြောကြ၏။ သို့ရာတွင် သူရို့သည်လည်း မယုံကြည်ကြပေ။ ");
INSERT INTO rki_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ထို့နောက်၊ တစ်ကျိပ်တစ်ပါးသော တပည့်တော်ရို့သည် စားပွဲ၌ ထိုင်၍ စားသောက်နိန်ကြစဉ်၊ ကိုယ်တော်သည် ကိုယ်ထင်ပြတော်မူ၏။ သူရို့သည် ကိုယ်တော် ထမြောက်တော်မူကြောင်းကို မြင်သောသူရို့၏စကားကို ကြားကြသော်လည်း၊ စိတ်နှလုံးခိုင်မာ၍ မယုံကြည်ကြသောကြောင့် ကိုယ်တော်သည် သူရို့အား ပြစ်တင်ဆုံးမတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ထို့နောက် ကိုယ်တော်က၊ “သင်ရို့သည် လောကီနိုင်ငံအရပ်ရပ်သို့ လားပြီးလျှင် လူသတ္တဝါအပေါင်းရို့အား ဧဝံဂေလိသတင်းကောင်းတရားကို ဟောပြောကြလော့။ ");
INSERT INTO rki_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ယုံကြည်၍ ဗတ္တိဇံမင်္ဂလာကို ခံယူသောသူတိုင်း ကယ်တင်တော်မူခြင်းကို ခံရမည်။ မယုံကြည်သောသူမူကား အပြစ်စီရင်ခြင်းကို ခံရမည်။ ");
INSERT INTO rki_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ယုံကြည်လက်ခံသောသူရို့၌ကား၊ ငါ၏နာမကို အမှီပြု၍ အံ့သြဖွယ်နိမိတ်လက္ခဏာတိကို ပြနိုင်ကြလိမ့်မည်။ နတ်ဆိုးတိကို နှင်ထုတ်လိမ့်မည်။ ထူးခြားသောဘာသာစကားတိကို ပြောဆိုကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","မြွီဆိုးများကို ကိုင်ဖမ်းသော်လည်းကောင်း၊ သီစီတတ်သော အဆိပ်အတောက်ကို သောက်သော်လည်းကောင်း၊ သူရို့သည် ဘေးဥပါဒ်နှင့် ကင်းလွတ်ကြလိမ့်မည်။ နာမကျန်းသော သူရို့အထက်မှာ လက်ကိုတင်၍ ကျန်းမာစီကြလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","ထိုသို့ တပည့်တော်ရို့အား မိန့်တော်မူပြီးသောအခါ အသျှင်ယေသျှုသည် ကောင်းကင်ဘုံသို့ ဆောင်ယူခြင်းကို ခံတော်မူပြီး၊ ဘုရားသခင်၏ လက်ယာတော်ဖက်၌ ထိုင်နိန်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","တပည့်တော်ရို့လည်း အရပ်ရပ်သို့လား၍ တရားတော်ကို ဟောပြောကြ၏။ သခင်ဘုရားသည်လည်း သူရို့နှင့်အတူ လုပ်ဆောင်၍ ဟောပြောသော တရားတော်သည် မှန်ကန်ကြောင်းကို ပြုတော်မူသော နိမိတ်လက္ခဏာများအားဖြင့် သက်သီပြတော်မူ၏။ အခြား နည်းဟောင်း အဆုံးသတ်  ");
INSERT INTO rki_vpl VALUES ("MK16_21","071_16_21","MRK","16","21","21","ထိုမိန်းမများသည် ပေတရုနှင့် သူ၏အပေါင်းအပါရို့ပါးသို့ လား၍ မိမိရို့ တွိ့မြင်ခရသမျှသော အရာများကို ပြောပြကြ၏။ ");
INSERT INTO rki_vpl VALUES ("MK16_22","071_16_22","MRK","16","22","22","ထို့နောက်၊ ယေသျှုကိုယ်တော်တိုင် မိမိ၏တပည့်တော်ရို့အားဖြင့် မြင့်မြတ်ပြီး ထာဝရအသက်နှင့်ဆိုင်သော ကယ်တင်ခြင်း သတင်းစကားကို ကမ္ဘာကြီး၏ အရှိ့စွန်းမှ အနောက်စွန်းတိုင်အောင် ပြန့်နှံ့စီတော်မူ၏။");
INSERT INTO rki_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","မြတ်သော သော်ဖိလု၊ အကျွန်ရို့ကြား၌ ဖြစ်ခသည့် အကြောင်းအရာများကို ကောင်းစွာ ရီးသားပြုစုသော လူများစွာ ဟိခပါ၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","အစအဦးမှ မျက်မြင်သက်သီများနှင့် အမှုတော်ကို ဆောင်ရွက်သောသူရို့က ငါရို့အား ပြောကြားသည့်အတိုင်း သူရို့သည် ရီးသားပြုစုခပါသည်။ ");
INSERT INTO rki_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ထို့ကြောင့် အကျွန်ကလည်း ထိုအကြောင်းအရာအားလုံးကို အစဦးမှ သေသေချာချာဂရုစိုက် လေ့လာခသူဖြစ်သည့်အလျောက်၊ သင် ဖတ်ရှု နိုင်ခြင်းငှာ စနစ်တစ်ကျ ပြုစုရသော် ကောင်းမည်ဟု ယူဆရပါသည်။ ");
INSERT INTO rki_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","သင်အား သင်ကြားပီးခသော အကြောင်းအရာများသည် ဧကန်အမှန်ဖြစ်ကြောင်းကို သင်သည် သိစီခြင်းငှာ ဤအရာများကို ရီးလိုက်ပါ၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ယုဒသျှင်ဘုရင် ဟေရုဒ်လက်ထက်၌ ဇာခရိဟု နာမည်ဟိသော ယဇ်ပုရောဟိတ်တစ်ပါးဟိ၏။ ထိုသူသည် အဘိယယဇ်ပုရောဟိတ်အဖွဲ့ဝင်ဖြစ်ပြီး သူ၏မယားက ဧလိဇဗက်ဟု နာမည်ဟိ၏။ ဧလိဇဗက်ကလည်း ယဇ်ပရောဟိတ်အာရုန် အနွယ်ဝင်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ထိုသူနှစ်ဦးမှာ ဘုရားသခင်၏ ရှိ့တော်မှောက်တွင် သူတော်ကောင်းဖြစ်ပြီးလျှင် သခင်ဘုရား၏ ပညတ်တော်ဟိသမျှနှင့် မိန့်တော်မူချက်အားလုံးကို လိုက်နာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","သို့ရာတွင် ဧလိဇဗက်သည် အမြုံမဖြစ်သည့်အတွက် သူရို့မှာ အချေ မဟိပါ၊ သူရို့နှစ်ဦးလုံးသည် အသက်အိုမင်း နိန်ပြီဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","တစ်နိ့၌ ဇာခရိသည် မိမိ၏အလှည့်ကျလာသည့်အတွက် ဗိမာန်တော်၌ ယဇ်ပုရောဟိတ်ဝတ္တရားကို ဆောင်ရွက်နိန်၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ယဇ်ပုရောဟိတ်ရို့၏ ထုံးတမ်းစဉ်လာအရ ယဇ်ပလ္လင်၌ နံ့သာပေါင်းကို မီးရှို့ပူဇော်ရန် စာရီးတံချ၍ ရွီးခြယ်ခြင်းခံရလေ၏။ ထို့ကြောင့် သခင်ဘုရား၏ ဗိမာန်တော်အတွင်းသို့ ဝင်ပြီးလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","မီးယှို့ပူဇော်နိန်သည့် အချိန်တွင် လူစုလူဝေးရို့သည် အပြင်ဖက်တွင် ဆုတောင်းနိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ထိုအချိန်၌ သခင်ဘုရား၏ ကောင်းကင်တမန်သည် ဇာခရိ ရှိ့တွင် ပေါ်လာပြီးလျှင် နံ့သာပေါင်းမီးရှို့ရာ ယဇ်ပလ္လင်၏ လက်ယာဖက်တွင် ရပ်နိန်၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ဇာခရိကလည်း ကောင်းကင်တမန်ကို မြင်သောအခါ စိုးရိမ်၍ ကြောက်ရွံ့တုန်လှုပ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","သို့သော်လည်း ကောင်းကင်တမန်က “ဇာခရိ၊ မကြောက်ကေ့၊ ဘုရားသခင်သည်၊ သင်၏ ဆုတောင်းပတ္ထနာကို နားညောင်းတော်မူဗျာယ်၊ သင်၏မယား ဧလိဇဗက်သည်လည်း သားရတနာကို ဖွားမြင်လိမ့်မည်။ သင်သည် ထိုသားကို ယောဟန်ဟု နာမည်ပီးရမည်။ ");
INSERT INTO rki_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","သင်လည်း ဝမ်းမြောက်ပျော်ရွှင် ရလိမ့်မည်၊ ထိုသို့ သားမွီးဖွားလာသည့်အတွက် အခြားသော လူအပေါင်းရို့လည်း ပျော်ရွှင်ကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","သူသည် သခင်ဘုရား၏ ရှိ့တော်မှောက်၌ ကြီးမြတ်သောသူ ဖြစ်လိမ့်မည်။ ထိုသူသည် စပျစ်ရည်နှင့် သီရည်သီရက်ကို သောက်လိမ့်မည် မဟုတ်။ အမိဝမ်းထဲကပင် သူသည် သန့်ယှင်းသော ဝိညာဉ်တော်နှင့် ပြည့်ဝလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","များစွာသော ဣသရေလလူမျိုးတိကိုလည်း မိမိရို့ အသျှင် ဘုရားသခင် အထံတော်ပါးသို့ ပြန်လည်ပို့ဆောင်ပီးလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","သူသည် သခင်ဘုရား၏ ရှိ့တော်ဗြီးဖြစ်ပြီးလျှင် ပရောဖက်ဧလိယကဲ့သို့ ခွန်အားတန်ခိုး ကြီးလိမ့်မည်။ ထိုသူသည် အဖတိနှင့် သားသမီးတိကို ပြန်လည်သင့်မြတ်စီလိမ့်မည်၊ နားမထောင်သောသူရို့အား ဖြောင့်မတ်ခြင်းတရားကို ပြန်လည်ရစီလိမ့်မည်၊ ကိုယ်တော်အတွက် အဆင်သင့်ဖြစ်စီခြင်းငှာ သခင်ဘုရား၏ လူစုကို ပျင်ဆင်ပီးလိမ့်မည်” ဟု ဇာခရိအား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ဇာခရိက “ဤပိုင်ဖြစ်လာဖို့ကို ဇာပိုင် အကျွန် သိရပါမည်နည်း။ အကျွန်ကလည်း အိုဗျာယ်၊ အကျွန်၏မယားလဲ အိုဗျာယ်” ဟု ကောင်းကင်တမန်အား ပြန်ပြော၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ကောင်းကင်တမန်ကလည်း “ငါကား ဘုရားသခင်၏ မျက်မှောက်တော်၌ ခစားနိန်သော ဂါဗြေလဖြစ်၏။ သင့်အား ဤသတင်းကောင်းကို ပြောကြားဖို့ ငါ့ကို ရွှတ်လိုက်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","သင်သည် ငါ့ပြောသောစကားကို မယုံကြည်သော်လည်း အချိန်တန်သောအခါ ဖြစ်ပေါ်လာလိမ့်မည်။ သင်သည် ငါ့စကားကို မယုံကြည်သောကြောင့်၊ သင်၌ ငါ၏ကတိတော် ပြည့်စုံလာသည့်နိ့ တိုင်အောင် စကားမပြောနိုင်ဘဲ တိတ်ဆိတ်စွာ နိန်ရလိမ့်မည်” ဟုဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","လူတိက ဇာခရိကို စောင့် နိန်ကြသော်လည်း ဗိမာန်တော်ထဲ၌ ကြန့်ကြာနိန်သည်ကို အံ့သြနိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ဇာခရိသည် ဗိမာန်တော်မှ ထွက်လာသောအခါ သူရို့ကို စကားမပြောနိုင် ဖြစ်နိန်သောကြောင့် ဗိမာန်တော်ထဲ၌ ဗျာဒိတ်ရူပါရုံ မြင်ခရကြောင်းကို သူရို့ ရိပ်မိကြ၏။ ဇာခရိကလည်း စကားမပြောနိုင်သောကြောင့် ကိုယ်လက်အမူအရာဖြင့် ပြ၍သာ နိန်၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ဇာခရိလည်း ဗိမာန်တော်ထဲ၌ အမှုပြီးဆုံးသောအချိန်တွင် အိမ်သို့ ပြန်လားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","ကာလအတန်ကြာသောအခါ သူ၏မယား ဧလိဇဗက်က ပဋိသန္ဓေတည်၍ သူသည် ငါးလပတ်လုံး အိမ်ထဲ၌ အောင်းနိန်၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","သူမကလည်း “ယခုတွင် ငါ့ကို သခင်ဘုရား ကျေးဇူးပြုတော်မူဗျာယ်၊ ငါ့ကို လူတိက ကဲ့ရဲ့ကြသည်ကိုလည်း ကိုယ်တော်က ဖယ်ယှားစီဗျာယ်” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ဧလိဇဗက်၏ကိုယ်ဝန် ခြောက်လသို့ရောက်သောအခါ ဘုရားသခင်သည် ကောင်းကင်တမန် ဂါဗြေလအား ဂါလိလဲပြည်၊ နာဇရက်မြို့သို့ ရွှတ်လိုက်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ထိုကောင်းကင်တမန်၏ သတင်းစကားသည် ဒါဝိဒ်အမျိုးဖြစ်သော ယောသပ်နှင့် စိ့စပ်ထားသူ သတို့သမီးကညာအဖို့ ဖြစ်၏။ သူမ၏နာမည်မှာ မာရိဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ကောင်းကင်တမန်က သူမပါးသို့ လာပြီးလျှင် “သင်သည် ကြီးစွာသောမင်္ဂလာကို ခံစားရသူဖြစ်၏။ သင်၌ ငြိမ်သက်ခြင်း ဟိပါစီ။ သခင်ဘုရားသည် သင်နှင့်အတူ ဟိ၏” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ကောင်းကင်တမန် စကားကို ကြားသောအခါ မာရိသည် လွန်စွာပူပင်သောက ရောက်လျက်၊ ဤနှုတ်ဆက်စကားက ဇာပိုင်ဖြစ်မည်နည်းဟု အံ့သြနိန်၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ကောင်းကင်တမန်က “မာရိ၊ မကြောက်ကေ့၊ သင်သည် ဘုရားသခင်ရှိ့တော်မှာ မျက်နှာရဗျာယ်။ ");
INSERT INTO rki_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","သင်သည် ပဋိသန္ဓေယူပြီးလျှင် သားရတနာကို မွီးဖွားလိမ့်မည်။ ထိုသားကို ယေသျှုဟု နာမည်မှည့်ခေါ်ရမည်။ ");
INSERT INTO rki_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ထိုသားသည် ကြီးမြတ်သောသူ ဖြစ်ပြီးလျှင် အမြင့်မြတ်ဆုံးသော ဘုရား၏သားတော်ဟု ခေါ်ဝေါ်ခြင်းကို ခံရလိမ့်မည်။ ထာဝရအသျှင် ဘုရားသခင်သည် သူ၏အဖဒါဝိဒ်၏ ရာဇပလ္လင်ကို သူ့အား ပီးတော်မူလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ထိုသူသည် ယာကုပ်၏အမျိုးအနွယ်ရို့ကို အစဉ်အမြဲအုပ်စိုးပြီးလျှင် သူ၏ နိုင်ငံတော်လည်း အဆုံး ဟိလိမ့်မည် မဟုတ်” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","မာရိကလည်း “အကျွန်သည် ယောက်ျားနှင့် မဆက်ဆံဖူး၍ ဤအမှုအရာသည် ဇာပိုင်ဖြစ်နိုင်ပါမည်နည်း” ဟု ကောင်းကင်တမန်အား ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ကောင်းကင်တမန်ကလည်း “သန့်ယှင်းသောဝိညာဉ်တော်သည် သင့်အပေါ်၌ သက်ရောက်ပြီးလျှင် ဘုရားသခင်၏တန်ခိုးတော်သည် သင့်ကို လွမ်းခြုံလိမ့်မည်။ ထို့ကြောင့် သန့်ယှင်းမြင့်မြတ်သောသူငယ်ကို ဖွားမြင်လာပြီးလျှင် သူ့ကို ဘုရားသခင်၏သားတော်ဟု ခေါ်ဝေါ်ခြင်းကို ခံရကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","သင်၏ ဆွီမျိုးဖြစ်သော ဧလိဇဗက်ကိုလည်း သတိရပါ။ သူမသည် အသက်ကြီးခါမှ ပဋိသန္ဓေလွယ်နိန်ရဗျာယ်။ အမြုံမဟု အခေါ်ခံနိန်ရသောသူသည် အဂုဆိုကေ ပဋိသန္ဓေခြောက်လ ဟိနိန်ဗျာယ်။ ");
INSERT INTO rki_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ဘုရားသခင် မတတ်နိုင်သောအရာ တခုလည်းမဟိ” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","မာရိကလည်း “အကျွန်သည် ဘုရားသခင်၏ အခိုင်းအစီဖြစ်၏။ အသျှင် ဖော်ပြသည်အတိုင်း ဖြစ်ပါစီ” ဟု ပြန်ပြော၏။ ထိုအခါ ကောင်းကင်တမန်ကလည်း သူမပါးမှ ထွက်လားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","များမကြာခင် မာရိသည် အသင့်ပျင်ဆင်ပြီးလျှင် ယုဒပြည် တောင်ပေါ်ဒေသ၌ဟိသော မြို့တစ်မြို့သို့ အယင်လားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","သူမသည် ဇာခရိအိမ်သို့ ဝင်ပြီးလျှင် ဧလိဇဗက်ကို နှုတ်ဆက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","မာရိ၏ နှုတ်ဆက်စကားကို ဧလိဇဗက်သည် ကြားသောအခါ သူမ၏ဝမ်းထဲက အချေကလည်း လှုပ်လေ၏။ ဧလိဇဗက်ကလည်း သန့်ယှင်းသောဝိညာဉ်တော်နှင့် ပြည့်ဝပြီးလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ကျယ်သောအသံဖြင့် “သင်သည် ဟိသမျှသော မိန်းမတိထက် မင်္ဂလာဟိ၏။ သင်မွီးဖွားလာမည့်သားလည်း မင်္ဂလာဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","အကျွန့်သခင်၏မိခင်သည် အကျွန့်ပါးကို လာရသော အခွင့်ထူးကို ဇာကြောင့် ခံစားရပါမည်နည်း။ ");
INSERT INTO rki_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","သင်၏ နှုတ်ဆက်စကားကို အကျွန် ကြားသောအခါ အကျွန့်ဝမ်းထဲက အချေလည်း ဝမ်းမြောက်လို့ ခုန်ပါ၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","သခင်ဘုရားပီးတော်မူသော ဗျာဒိတ်တော်အတိုင်း ဖြစ်လိမ့်မည်ဟု သင်ယုံကြည်သည့်အတွက် ဇာလောက် ဝမ်းမြောက်လိမ့်မည်နည်း” ဟု ပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","မာရိက၊ “ငါ၏ စိတ်နှလုံးသည် သခင်ဘုရားကို ချီးမွမ်းပါ၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ငါ၏ကယ်တင်သျှင် ဘုရားသခင်ကြောင့် ငါ၏စိတ်ဝိညာဉ်သည် ဝမ်းမြောက်ရွှင်လန်းပါ၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ကိုယ်တော်သည် မိမိအခိုင်းအစီ၏ နိမ့်ကျသောအဖြစ်ကို အောက်မိ့သတိရပြီးလျှင်၊ အဂုမှစ၍ လူအပေါင်းရို့သည် ငါ့ကိုမင်္ဂလာဟိသူဟု ခေါ်ကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","အကြောင်းမူကား အနန္တတန်ခိုးသျှင် ဘုရားသခင်သည် ငါ့အတွက် ကြီးမြတ်တော်မူသော အကြောင်းအရာတိကို ပြုတော်မူခ၍ ဖြစ်၏။ ကိုယ်တော်၏နာမတော်သည် သန့်ယှင်းပါ၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ကိုယ်တော့်ကို ကြောက်ရွံ့ရိုသီကြသောသူရို့ကို သားစဉ်မြီးဆက် ကရုဏာထားတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","တန်ခိုးကြီးသော လက်ရုံးတော်နှင့် တားဆီးပြီးလျှင် အတွင်းစိတ်သဘော၌ မာနကြီးသောသူရို့ကို ကွဲလွင့်စီပါ၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","တန်ခိုးကြီးသော ဘုရင်တိကို ရာဇပလ္လင်ထက်မှ ဆွဲချပြီးလျှင် နိမ့်ကျသောသူရို့ကို ချီးမြှောက်တော်မူပါ၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ငတ်မွတ်သောသူရို့ကို ကောင်းသောအရာတိနှင့် ပြည့်ဝစီပြီး၊ ချမ်းသာကြွယ်ဝသောသူရို့ကို လက်ဗလာဖြင့် ရွှတ်လိုက်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","အကျွန်ရို့ အဖိုးအဖီးတိကို ကိုယ်တော်ပီးခသည့် ကတိတော်နှင့်အညီ မိမိ၏အခိုင်းအစီ ဣသရေလလူမျိုးတိကို မစတော်မူပြီ။ ");
INSERT INTO rki_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","အာဗြဟံနှင့် သူ၏မျိုးနွယ်များအတွက် ထားတော်မူခသော ကရုဏာတော်နှင့်အညီ အစဉ်အမြဲပြုခြင်းငှာ သတိရတော်မူပြီ” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","ထို့နောက် မာရိသည် ဧလိဇဗက်ပါးတွင် သုံးလလောက်နီပြီးလျှင် အိမ်သို့ ပြန်လားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ဧလိဇဗက်သည် အချိန်စိ့သောအခါ သားရတနာကို ဖွားမြင်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ထိုကဲ့သို့ သူမအား သခင်ဘုရားသည် အံ့သြရလောက်အောင် ကျေးဇူးပြုသည်အကြောင်းကို ကြားကြသောအခါ အိမ်နီးချင်းနှင့် ဆွီမျိုးသားချင်းတိကလည်း သူမနှင့်အတူ ဝမ်းမြောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ထို့နောက် သျှစ်ရက်မြောက်သော နိ့တွင် သူရို့သည် သူငယ်အား အရီဖျားလှီးရန် လာကြပြီး သူငယ်ကို အဖနာမည်ဖြစ်သော ဇာခရိအမည်ဖြင့် မှည့်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","သို့သော် သူငယ်၏ မိခင်က၊ “ယင်းနာမည်ကို မမှည့်ပါကေ့၊ ယောဟန်ဟု နာမည်မှည့်ခေါ်ရမည်” ဟု ဆိုလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","သူရို့ကလည်း၊ “သင်ရို့အမျိုး၌ ထိုနာမည် တစ်ယောက်လေ့ မဟိ” ဟု သူမကို ပြန်ပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ထို့နောက် သူငယ်ကို နာမည်ပီးရန် သူ၏ဖခင်အား လက်ဟန်အမူအရာဖြင့် မိန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ဇာခရိကလည်း သင်းပုန်းတစ်ချပ်ကို တောင်းယူပြီးလျှင် “သူငယ်၏နာမည်က ယောဟန်ဖြစ်သည်” ဟု ရီးလိုက်သောအခါ သူရို့အားလုံး အလွန်အံ့သြကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ထိုခဏချင်းတွင် ဇာခရိကလည်း စကားပြန်ပြောနိုင်သဖြင့် ဘုရားသခင်၏ ကျေးဇူးတော်ကို ချီးမွမ်းလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","အိမ်နီးချင်းတိကလည်း ကြောက်ရွံ့ကြပြီး၊ ထိုသတင်းသည်လည်း ယုဒပြည် တောင်တန်းဒေသ တလျှောက်လုံးကို ပြန့်နှံ့လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ဤသတင်းကို ကြားသောသူအပေါင်းရို့သည် စဉ်းစားလျက် “ဤသူငယ်ကား ဇာပိုင်ဖြစ်လာမည်နည်း” ဟု ဆိုကြ၏။ အကြောင်းမူကား သခင်ဘုရား၏ တန်ခိုးတော်သည် သူငယ်အထက်၌ သက်ရောက်လျက် ဟိလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ယောဟန်၏အဖ ဇာခရိသည် သန့်ယှင်းသောဝိညာဉ်တော်နှင့် ပြည့်ဝပြီးလျှင် ဘုရားသခင်၏ သတင်းစကားတော်ကို ဟောပြောသည်မှာ၊ ");
INSERT INTO rki_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“ဣသရေလအမျိုးသားရို့၏အသျှင် ဘုရားသခင်သည် မင်္ဂလာဟိစီသတည်း။ အကြောင်းမူကား ကိုယ်တော်သည် သူ၏လူမျိုးကို ကူညီမစဖို့ရန် ကြွလာတော်မူ၍ သူရို့ကို ရွီးနုတ်တော်မူဗျာယ်။ ");
INSERT INTO rki_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ကိုယ်တော်သည် အကျွန်ရို့အဖို့ တန်ခိုးကြီးမားသော ကယ်တင်သျှင်ကို မိမိအစီခံ ဒါဝိဒ်အမျိုးအနွယ်ထဲမှ ပေါ်ထွန်းစီတော်မူပြီ။ ");
INSERT INTO rki_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ရှီးသန့်ယှင်းသူ ပရောဖက်တိမှတဆင့် ကတိတော် ထားခသည်နှင့်အညီ၊ ");
INSERT INTO rki_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ကိုယ်တော်က အကျွန်ရို့ကို အကျွန်ရို့၏ ရန်သူတိနှင့်၊ အကျွန်ရို့အား မုန်းတီးသောသူရို့လက်မှ ကယ်ထုတ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","အကျွန်ရို့ အဖိုးအဖီးတိကို ကရုဏာထားတော်မူကြောင်းနှင့်၊ မိမိ၏ သန့်ယှင်းသော ပဋိညာဉ်တော်ကို အောက်မိ့တော်မူကြောင်း မိန့်တော်မူခ၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","အကျွန်ရို့ အဖိုးအဖီး အာဗြဟံအား ဂတိသစ္စာ ပြုတော်မူခသည်နှင့်အညီ၊ အကျွန်ရို့တိကို ရန်သူရို့လက်မှ ကယ်ပြီးလျှင်၊ ကြောက်ရွံ့ခြင်းမဟိဘဲ ကိုယ်တော်၏ အမှုတော်ကို ဆောင်ရွက်စီမည်။ ");
INSERT INTO rki_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ယင်းအတွက်ကြောင့် အကျွန်ရို့လည်း ကိုယ်တော်၏ မျက်မှောက်တော်၌ သန့်ယှင်းခြင်းနှင့် ဖြောင့်မတ်ခြင်းအားဖြင့် တစ်သက်လုံး ရှင်သန်ဖို့ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“ငါ့သား၊ သင်သည် အမြင့်ဆုံးသော ဘုရား၏ ပရောဖက်ဟု ခေါ်ဝေါ်ခြင်းကို ခံရလိမ့်မည်၊ သင်သည် ထိုသခင်ဘုရားအတွက် လမ်းကို ပျင်ဆင်ခြင်းငှာ သခင်ဘုရား၏ ရှိ့တော်ဗြီး ဖြစ်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ကိုယ်တော်၏ လူတိကိုလည်း သူရို့၏ အပြစ်မှ ခွင့်ရွှတ်ပြီးလျှင် ကယ်တင်တော်မူမည့်အကြောင်း ပြောကြားရလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","အကျွန်ရို့ ဘုရားသခင်သည် သနားခြင်းကရုဏာနှင့် ပြည့်ဝတော်မူ၏။ ကိုယ်တော်၏ ကယ်တင်ခြင်း ကျေးဇူးတော်သည် ကောင်းကင်မှ နီ၏အရောင်ကဲ့သို့ အကျွန်ရို့အထက်၌ ထွန်းလင်းစီတော်မူပြီးလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","သီမင်းအရိပ်၏ မှောင်မိုက်ထဲ၌ နီထိုင်သူရို့၌ အလင်းသည် ပေါ်ထွန်းလျက်၊ အကျွန်ရို့ကို ငြိမ်သက်ခြင်းလမ်းသို့ ညွှန်ပြတော်မူလိမ့်မည်” ဟု ဆိုလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","သူငယ်သည် ကြီးပြင်းလာပြီးလျှင် ဝိညာဉ်အရာ၌ တိုးပွါးလေ၏။ သူသည် ဣသရေလလူမျိုးတိရှိ့တွင် ထင်ရှားမည့် နိ့ရက်တိုင်အောင် တောကန္တာရ၌ နီထိုင်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","ထိုကာလ၌ ဧကရာဇ်ဘုရင် သြဂုတ္တုသည် ရောမအင်ပါယာတစ်ခုလုံးကို သန်းခေါင်စာရင်း ကောက်ယူရန် အမိန့်တော်ထုတ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ဤသည်ကား ကုရေနိသည် ယှုရိဘုရင်ခံဖြစ်သောအခါ ပထမဆုံးအကြိမ် သန်းခေါင်စာရင်း ကောက်ခြင်း ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","သို့ဖြစ်၍ လူတိုင်းသည် စာရင်းသွင်းရန် မိမိရို့၏ဇာတိမြို့ရွာသို့ လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ထို့ကြောင့် ယောသပ်သည်လည်း ဒါဝိဒ်၏အမျိုးအနွယ် ဖြစ်သောကြောင့် ဂါလိလဲနယ် နာဇရက်မြို့မှ ဒါဝိဒ်၏မြို့ဖြစ်သည့် ယုဒပြည် ဗက်လင်မြို့သို့ လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","သူသည် ထိမ်းမြားရန် စိ့စပ်ထားသော မာရိနှင့်အတူ စာရင်းသွင်းရန် လားလေ၏။ သူမ၌ ကိုယ်ဝန်လွယ်ထားလျက် ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","သူရို့သည် ဗက်လင်မြို့တွင် ဟိနိန်စဉ် အချေ မွီးဖွားချိန် ရောက်လာ၍၊ ");
INSERT INTO rki_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","သူမသည် မိမိ၏သားဦးကို ဖွားမြင်လေ၏။ တည်းခိုသည့်အိမ်တွင် သူရို့အတွက် နီရာမဟိသောကြောင့် သူမသည် သူငယ်ကို အဝတ်စနှင့်ပတ်ကာ နွားစာခွက်တွင် သိပ်ထားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ထိုအခါ ထိုပြည်၌ သိုးထိန်းရို့သည် ညဉ့်အခါ ကွင်းပြင်၌ မိမိရို့၏သိုးအုပ်ကို စောင့်ရှောက်နိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","သခင်ဘုရား၏ ကောင်းကင်တမန်တစ်ပါးသည် သူရို့၌ ပေါ်လာပြီး၊ သခင်ဘုရား၏ ဘုန်းတန်ခိုးတော်သည် သူရို့ပတ်လည်တွင် ထွန်းလင်းတောက်ပလေ၏။ ထိုသူရို့သည် အလွန် ကြောက်လန့်ကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","သို့ရာတွင် ကောင်းကင်တမန်က “မကြောက်ကတ်ကေ့၊ ငါသည် လူတိအားလုံးအတွက် အလွန်ဝမ်းမြောက်စရာ သတင်းကောင်းကို သင်ရို့ပါးသို့ ယူလာ၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ဤနိ့တွင် ဒါဝိဒ်မြို့၌ အသျှင်ခရစ်တော်တည်းဟူသော ကယ်တင်သျှင်သည် သင်ရို့အဖို့အလို့ငှာ ဖွားမြင်ခြင်းကို ခံတော်မူဗျာယ်။ ");
INSERT INTO rki_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","သင်ရို့အတွက် ဤအကြောင်းအရာ၏ နိမိတ်လက္ခဏာဟူမူကား၊ မွီးကင်းစအချေ တစ်ယောက်ကို အဝတ်စနှင့် ရစ်ပတ်ပြီးလျှင် နွားစာခွက်၌ သိပ်ထားသည်ကို တွိ့မြင်ရလိမ့်မည်” ဟု မြွက်ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ထိုကောင်းကင်တမန်နှင့်အတူ ကောင်းကင် ဗိုလ်ခြေအပေါင်းရို့သည် ရုတ်တရက်ပေါ်လာကြပြီးလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“အမြင့်ဆုံးသော ကောင်းကင်ဘုံ၌ ဟိတော်မူသော ဘုရားသခင်သည် ဘုန်းကြီးတော်မူပါစီသောဝ်။ မြီကြီးထက်မှာလည်း ကိုယ်တော် နှစ်သက်တော်မူသော လူအပေါင်းရို့၌ ငြိမ်သက်ခြင်း ဟိပါစီသောဝ်” ဟု ဘုရားသခင်ကို ချီးမွမ်းမြွတ်ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ကောင်းကင်တမန်ရို့သည် သူရို့ပါးမှ ထွက်ခွါ၍ ကောင်းကင်ဘုံသို့ ပြန်ကြသောအခါ သိုးထိန်းရို့က “ထာဝရဘုရားသည် ငါရို့အား ပြောကြားတော်မူသော ဤအမှုအရာများကို ဗက်လင်မြို့သို့ လား၍ ကြည့်ကြကုန်အံ့” ဟု အချင်းချင်း ပြောဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ထို့ကြောင့် သူရို့သည် အယင်လားကြပြီးလျှင် မာရိနှင့်ယောသပ်ကိုလည်းကောင်း၊ နွားစာခွက်၌ သိပ်ထားလျက်ဟိသော သူငယ်တော်ကိုလည်းကောင်း မြင်တွိ့ကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","သူငယ်ကို မြင်တွိ့သောအခါ သူရို့သည် သူငယ်တော်နှင့်ပတ်သက်၍ ကောင်းကင်တမန် ပြောပြသော အကြောင်းအရာများကို ပြောပြကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","သိုးထိန်းတိပြောသော စကားကို ကြားရသောသူ အပေါင်းရို့သည် အလွန်အံ့သြကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","မာရိကလည်း ထိုအကြောင်းအရာအားလုံးကို မှတ်ထားပြီးလျှင် အလေးအနက် စဉ်းစားဆင်ခြင်လျက် နိန်၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","သိုးထိန်းရို့က ကောင်းကင်တမန် ဖော်ပြသည့်အတိုင်း ကြားရ၊ မြင်ရသဖြင့် ဘုရားသခင်ကို ချီးမွမ်းမြွက်ဆိုလျက် ပြန်လားကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","သျှစ်ရက်မြောက်သောနိ့တွင် သူငယ်အား အရီဖျားလှီးခြင်းမင်္ဂလာကို ပီးသောအခါ၊ သူငယ်ပဋိသန္ဓေမယူခင် ကောင်းကင်တမန်ကပီးသော နာမည်ဖြစ်သည့် ယေသျှုဟူသောနာမည်ဖြင့် မှည့်ကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","မောသျှေ၏ ပညတ်တရားအရ ယောသပ်နှင့်မာရိသည် စင်ကြယ်ခြင်းဝတ်ကို ပြုရမည့် အချိန်ရောက်သောအခါ ဘုရားသခင် ရှိ့တော်၌ ဆက်ကပ်ရန် သူငယ်ကို ယေရုဆလင်မြို့သို့ ခေါ်ဆောင်လား၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","“သားဦးယောက်ျားမှန်သမျှကို ဘုရားသခင်အား ဆက်ကပ်ရမည်” ဟူ၍ ဘုရားသခင်၏ ပညတ္တိကျမ်း၌ ဖော်ပြထား၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","သူရို့သည်လည်း “ဂြိုးချေ နှစ်ကောင်ကို ဖြစ်စီ၊ ခိုနှစ်ကောင်ကို ဖြစ်စီ ပူဇော်ရမည်” ဟူ၍ လည်းကောင်း ဘုရားသခင်၏ ပညတ္တိကျမ်းတွင် ဖော်ပြပါဟိသည့်အတိုင်း ဆက်ကပ်ပူဇော်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ထိုအချိန်၌ သျှုမောင်ဟု ခေါ်သော လူတစ်ယောက်သည် ယေရုဆလင်မြို့တွင် နီထိုင်လျက်ဟိ၏။ သူသည် ဖြောင့်မတ်သောသူဖြစ်၍ ဘာသာတရားကိုင်းယှိုင်းသောသူဖြစ်၏။ သူသည် ဣသရေလလူမျိုးတိ ကယ်တင်ခြင်းရဖို့ရန် စောင့်မျှော်နိန်သောသူလည်း ဖြစ်ပြီး သန့်ယှင်းသောဝိညာဉ်တော်သည် သူ၌ တည်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","သူသည် ဘုရားသခင်၏ မေသျှိယကို မဖူးရခင်မသီရဟု သန့်ယှင်းသောဝိညာဉ်တော်အားဖြင့် ဗျာဒိတ်တော်ကို ရထားသူလည်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ထိုအခါ သျှုမောင်သည် ဝိညာဉ်တော်၏ ဦးဆောင်မှုအားဖြင့် ဗိမာန်တော်ထဲသို့ ဝင်လေ၏။ ပညတ်တရားအတိုင်း ဆောင်ရွက်ရန် မိဖနှစ်ပါးရို့သည် သူငယ် ယေသျှုကို ဗိမာန်တော်ထဲသို့ ခေါ်လာကြသောအခါ၊ ");
INSERT INTO rki_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","သျှုမောင်သည် သူငယ်ကို သူ့လက်ဖြင့် ပွိ့ချီ၍ ဘုရားသခင်၏ ကျေးဇူးတော်ကို ချီးမွမ်းလေသည်မှာ၊ ");
INSERT INTO rki_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“ဘုရားသခင်၊ ကိုယ်တော်၏ ကတိတော်သည် အဂု ပြည့်စုံ နိန်ပြီ ဖြစ်သည့်အတွက်၊ ကိုယ်တော်၏ အခိုင်းအစီကို ငြိမ်သက်စွာ လားရသောအခွင့်ကို ပီးတော်မူပါ။ ");
INSERT INTO rki_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","32","တစ်ပါးအမျိုးသားတိအတွက် ကိုယ်တော်၏အလင်းကို လင်းစီရန်နှင့် ကိုယ်တော့်လူမျိုးတော် ဣသရေလ၏ ဘုန်းအသရေ ထွန်းလင်းလာစီရန်၊ လူမျိုးအပေါင်းရို့ရှိ့၌ ကိုယ်တော်သျှင် ပျင်ဆင်ထားသော၊ ကယ်တင်ခြင်းကို အကျွန့်မျက်စိနန့် တပ်အပ်မြင်ရဗျာယ်” ဟု မြွက်ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","သူငယ်၏မိဖရို့သည် သူငယ်နှင့်ပတ်သက်၍ သျှုမောင် ပြောဆိုသောစကားကို ကြားသောအခါ အံ့သြကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","သျှုမောင်သည် သူရို့ကို ကောင်းကြီးပီး၍ သူ၏မိခင် မာရိအား၊ “များစွာသော ဣသရေလလူမျိုး၌ ဖျက်ဆီးခံရသူများနှင့် ကယ်တင်ခြင်းခံရသူများ အတွက် ဤသူငယ်ကို ဘုရားသခင်သည် ရွီးခြယ်ခန့်ထားတော်မူဗျာယ်။ ဤသူသည် ဘုရားသခင်ထံပါးမှ အမှတ်လက္ခဏာဖြစ်ပြီးလျှင် သူ့ကို လူတိက ဆန့်ကျင်ပြောဆိုခြင်းဖြင့်၊ ");
INSERT INTO rki_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","သူရို့၏ စိတ်နှလုံးအကြံအစီတိကို ပေါ်လွင်စီကြလိမ့်မည်။ သင်၏နှလုံးကို သံလျက်ဓါးနန့် ထိုးဖေါက်ခံရသကဲ့သို့ နာကြင်စွာခံစားရလိမ့်မည်” ဟု ပြောဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","အာသျှာအမျိုးအနွယ်ဝင်၊ ဖနွေလ၏သမီး၊ အန္နအမည်ဟိသည့် အသက်ကြီးရင့်သော ပရောဖက်မတစ်ယောက် ဟိ၏။ သူမသည် အိမ်ထောင်ပြု၍ ခုနစ်နှစ်သာ ပေါင်းသင်းခရပြီး၊ ");
INSERT INTO rki_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","အဂု အသက် ၈၄ နှစ်တိုင်တိုင် မုဆိုးမဘဝနှင့် နီထိုင်ရ၏။ သူမသည် အစာယှောင်၍ ဆုတောင်းလျက် နိ့ညမလပ် ဘုရားဝတ်ပြုကာ ဗိမာန်တော်မှမခွါဘဲ နိန်၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","သူမသည်လည်း ထိုအချိန်၌ ရောက်လာပြီးလျှင် ဘုရားသခင်၏ကျေးဇူးတော်ကို ချီးမွမ်းလျက် ယေရုဆလင်မြို့ ရွီးနုတ်ကယ်တင်ခံရမည့်အကြောင်းကို စောင့်မျှော်နိန်သော လူအပေါင်းရို့အား သူငယ်အကြောင်းကို ပြောဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ယောသပ်နှင့် မာရိရို့သည် ဘုရားသခင်၏ ပညတ်တော်ဟိသမျှကို ဆောင်ရွက်ပြီးလျှင် သူရို့၏ မြို့ဖြစ်သော ဂါလိလဲပြည်၊ နာဇရက်မြို့သို့ ပြန်လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","သူငယ်သည် ကြီးထွားသန်မာလာပြီး ဉာဏ်ပညာနှင့် ပြည့်စုံကာ ဘုရားသခင်၏ ကျေးဇူးတော်သည် သူ့အထက်၌ တည်လျက်ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","ယေသျှု၏မိဖရို့သည် နှစ်စဉ်နှစ်တိုင်း ပသခါပွဲတော်ကိုခံယူရန် ယေရုဆလင်မြို့သို့ လားကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ယေသျှုသည် အသက်တစ်ဆယ့်နှစ်နှစ် ဟိသောအခါ သူရို့သည် ထုံးစံဟိသည်အတိုင်း ပွဲတော်သို့ လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","သူ၏မိဖရို့သည် ပွဲတော်ပြီးဆုံးချိန်၌ အိမ်သို့ပြန်ကြသော်လည်း သူငယ်ယေသျှုသည် ယေရုဆလင်မြို့တွင် ကျန်ခလေ၏။ ထိုသို့ ကျန်ခသည်ကို သူ၏မိဖရို့သည် မသိကြ။ ");
INSERT INTO rki_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ထို့ကြောင့် သူ၏မိဖရို့က သူသည် သူရို့၏ အပေါင်းအဖော်များထဲတွင် ဟိလိမ့်မည်ဟု ထင်မှတ်လျက် တစ်နိ့တာခရီး လားပြီးမှ မိမိရို့၏ မိတ်ဆွီတိနှင့် ဆွီမျိုးသားချင်းတိကြားတွင် သူ့ကို ရှာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","သူရို့သည် သူ့ကို မတွိ့သောအခါ ယေရုဆလင်မြို့သို့ ပြန်လား၍ ရှာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","တတိယမြောက်နိ့တွင် သူရို့သည် သူငယ်ကို ဗိမာန်တော်ထဲတွင် တွိ့ကြ၏။ သူသည် ယုဒဆရာများနှင့် အတူထိုင်ကာ သူရို့၏တရားစကားများကို ကြားနာလျက် သူရို့နှင့် ဆွေးနွေး မိန်းမြန်းလျက် နိန်၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","သူ၏စကားကို ကြားသောသူတိုင်းကလည်း သူ၏ဉာဏ်စွမ်းနန့် ဖြေကြားချက်ကို အံ့သြကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","သူ၏မိဖရို့သည် သူ့ကို တွိ့သောအခါ အံ့မောကျ၍၊ သူ၏ မိခင်က “ငါ့သား၊ ဇာဖြစ်လို့ ငါရို့ကို ဤသို့ ပြုသနည်း၊ မေမေနှင့်ဘာဘာကလည်း ကောင်းကောင်း စိတ်ပူပြီးလျှင် သားချေကို ရှာခရသည်” ဟု ပြော၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","သူက၊ “ဇာဖြစ်လို့ အကျွန့်ကို ရှာကြပါသနည်း။ အကျွန့်အဖအိမ်တော်၌ ဟိ နိန်ရမည် ဆိုသည်ကို မသိကြသလား” ဟု မိဖရို့အား ပြန်ပြော၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","သို့ရာတွင် သူရို့က သူသည် မိမိရို့အား ဇာကို ပြောနိန်သည်ကို နားမလည်ကြ။ ");
INSERT INTO rki_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ထို့ကြောင့် ယေသျှုသည် မိဖရို့နှင့်အတူ နာဇရက်မြို့သို့ လိုက်လာပြီး မိဖရို့၏စကားကို နာခံလျက်နိန်၏။ သူ၏မိခင်သည်ကား ဖြစ်ပျက်ခသမျှကို မိမိစိတ်နှလုံးထဲတွင် မှတ်သားထားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ယေသျှုသည်လည်း ခန္ဓာနှင့် ဉာဏ်ပညာပိုင်းတွင် တိုးတက်ကြီးထွားလျက် ဘုရားသခင်နှင့် လူရှိ့၌ မျက်နှာပွင့်လန်းလျက် ဟိလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","ဧကရာဇ်ဘုရင် တိဗေရိ နန်းစံနှစ် တစ်ဆယ့်ငါးနှစ်ဟိသောအခါ ယုဒပြည်တွင် ပုန္တိပိလတ်သည် ဘုရင်ခံဖြစ်၏။ ဂါလိလဲပြည်တွင် ဟေရုဒ်၊ ဣတုရဲနယ်နှင့် တြာခေါနိတ်နယ်တွင် ဟေရုဒ်၏ညီ ဖိလိပ္ပု၊ အဘိလင်နယ်တွင် လုသာနိရို့သည် အသီးသီး နယ်စားများ ဖြစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","အန္နနှင့် ကယာဖရို့က ယဇ်ပုရောဟိတ်မင်းများ ဖြစ်ကြ၏။ ထိုအချိန်တွင် တောကန္တာရ၌ဟိသော ဇာခရိ၏သား ယောဟန်သည် ဘုရားသခင်၏ ဗျာဒိတ်တော်ကို ခံရ၏။ ");
INSERT INTO rki_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ထို့ကြောင့် ယောဟန်သည် ယော်ဒန်မြစ်ဝှမ်းတလျှောက် လားပြီးလျှင် “အပြစ်မှ နောင်တရပြီးလျှင် ဗတ္တိဇံကို ခံယူကတ်ပါ၊ သို့မှသာ ဘုရားသခင်သည် သင်ရို့အပြစ်ကို လွှတ်တော်မူလိမ့်မည်” ဟု ဟောပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ပရောဖက် ဟေသျှာယကျမ်းစာ၌ ရီးသားထားသည်မှာ၊ “တောကန္တာရတွင် ဟစ်ကြော်သောသူ၏ အသံမှာ၊ ‘ထာဝရဘုရား ကြွတော်မူရာလမ်းကို အသင့်ပျင်ဆင်ကြလော့၊ ကိုယ်တော်၏လမ်းကို ပြောင့်တန်းအောင် ပြုလုပ်ကြလော့၊ ");
INSERT INTO rki_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ချိုင့်ဝှမ်းဟိသမျှကို ဖို့ပြီးလျှင် တောင်ကြီးတောင်ငယ်တိကို ဖြိုကြလော့။ ကောက်သောလမ်းကို ပြောင့်တန်းစီပြီးလျှင်၊ ကြမ်းတမ်းသောလမ်းကိုလည်း ချောမွတ်စီကြလော့၊ ");
INSERT INTO rki_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","လူအပေါင်းရို့သည် ဘုရားသခင်၏ ကယ်တင်ခြင်းကို တွိ့မြင်ရလိမ့်မည်’” ဟု ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ယောဟန်သည် မိမိထံ၌ ဗတ္တိဇံခံယူရန် ရောက်လာကြသော လူအပေါင်းရို့အား “အချင်း မြွီဆိုးအမျိုးရို့၊ ကျရောက်လတ္တံသော အမျက်တော်၏ ဖီးမှ ယှောင်ဗြီးရန် သင်ရို့ကို ဇာသူက သတိပီးသနည်း။ ");
INSERT INTO rki_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","နောင်တရခြင်းနှင့်ဆိုင်သော အသီးကို သီးကြလော့။ အာဗြဟံသည် ငါရို့အဖ ဖြစ်သည်ဟု မပြောကတ်ကေ့။ ဘုရားသခင်သည် ဤကျောက်ခဲတိကို အာဗြဟံ၏ အမျိုးအနွယ်တိဖြစ်လာအောင် ဖန်ဆင်းနိုင်တော်မူသည် ဟု သင်ရို့ကို ငါပြောဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ပေါက်ဆိန်ကို သစ်ပင်အရင်း၌ အသင့် ပျင်ထားသည်ဖြစ်သဖြင့် ကောင်းသောအသီးကို မသီးသော အပင်ဟိသမျှကို ခွတ်ပစ်ပြီး မီးအိုင်ထဲသို့ ဝေးပစ်ခြင်း ခံရလိမ့်မည်” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","လူအပေါင်းရို့က “ထိုသို့ဆိုလျှင် အကျွန်ရို့ ဇာပိုင်လုပ်ရပါမည်နည်း” ဟု မိန်းကြလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ယောဟန်က “အင်္ကျီနှစ်ထည် ဟိသောသူက အင်္ကျီမဟိသောသူအား အင်္ကျီတစ်ထည်ကို ပီးလော့၊ စားစရာဟိသောသူကလည်း ထိုနည်းအတိုင်း မျှဝီပီးလော့” ဟု ပြန်ပြော၏။ ");
INSERT INTO rki_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","တချို့သော အခွန်ခံသူရို့ကလည်း ဗတ္တိဇံကို ခံယူရန် လာကြ၍ သူရို့က “ဆရာ၊ အကျွန်ရို့ ဇာလုပ်ရပါဖို့လဲ” ဟု မိန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ယောဟန်ကလည်း “တရားဝင်သတ်မှတ်ထားသည်ထက် အခွန်ကို ပိုမကောက်ကတ်ကေ့” ဟု ပြန်ပြော၏။ ");
INSERT INTO rki_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","ထို့နောက် တချို့သော စစ်သားတိကလည်း “အကျွန်ရို့ ဇာပိုင်လုပ်ရပါမည်နည်း” ဟု မိန်းကြ၏။ ယောဟန်က “သင်ရို့သည် ဇာသူ့ကိုလည်း မတရား မစွပ်စွဲကတ်ကေ့၊ ဇာသူ့ဖဲသာကိုလည်း အားဓမ္မ မယူကေ့။ သင်ရို့ရသည့် လစာနှင့် ရောင့်ရဲကြလော့” ဟု ပြန်ပြော၏။ ");
INSERT INTO rki_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","လူတိက မေသျှိယ ကြွလာဖို့ယာ ဟု စောင့်မျှော်နိန်ချိန်ဖြစ်ရာ ယောဟန်သည် မေသျှိယပင် ဖြစ်နိန်သလောဟု စိတ်နှလုံးထဲ၌ တွေးတောလျက်နိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","သို့ဖြစ်၍ ယောဟန်က “ငါက သင်ရို့ကို ရီအားဖြင့် ဗတ္တိဇံမင်္ဂလာကို ပီး၏။ ငါ့ထက်ကြီးမြတ်သောသူသည် ငါ့နောက်၌ ပေါ်ထွန်းလာလိမ့်မည်။ ငါသည် ထိုအသျှင်၏ ခြီနင်းကြိုးကိုတောင် မဖြီထိုက်။ ထိုအသျှင်သည် သင်ရို့ကို သန့်ယှင်းသောဝိညာဉ်တော်နှင့် လည်းကောင်း၊ မီးနှင့် လည်းကောင်း ဗတ္တိဇံမင်္ဂလာကို ပီးတော်မူလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ထိုသူသည် မိမိ၏ ကောက်နယ်တလင်းကို ယှင်းလင်းရန် လက်၌ ဆန်ကောကို ကိုင်ထားတော်မူသည်ဖြစ်၍ ဂျုံစပါးတိကို ပုတ်ထဲတွင် စုသိမ်းပြီးလျှင် အဖျင်းတိကို မငြိမ်းနိုင်သော မီးထဲ၌ လောင်ကျွမ်းစီတော်မူလိမ့်မည်” ဟု သူရို့ကို ပြောဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ယောဟန်သည် ခြားနားသော နိုးဆော်ချက်များနှင့် ထိုသူရို့၏ အကျင့်တိကိုလည်း ပြောင်းလဲစီရန် လူတိကို တိုက်တွန်း၍ သတင်းကောင်းကို သူရို့အား ဟောပြောတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","သို့သော် ယောဟန်သည် နယ်စားဟေရုဒ်အား၊ သူ့ညီ၏မယားဖြစ်သော ဟေရောဒိကို သိမ်းပိုက်ခြင်းနှင့် အခြားသော မကောင်းမှုများကို ကျူးလွန်ခသောကြောင့် ဆုံးမခ၏။ ");
INSERT INTO rki_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ထို့နောက် ယောဟန်ကို ထောင်ထဲတွင် ချုပ်ထားစီခြင်းဖြင့် ဟေရုဒ်သည် ပို၍ ဆိုးရွားသော အပြစ်ကို ကျူးလွန်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","လူအပေါင်းရို့သည် ဗတ္တိဇံကို ခံယူကြပြီးသောအခါ ယေသျှုသည်လည်း ဗတ္တိဇံမင်္ဂလာကို ခံယူတော်မူ၏။ ကိုယ်တော်သည် ဆုတောင်းတော်မူစဉ် ကောင်းကင်ပွင့်ဟ၍၊ ");
INSERT INTO rki_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","သန့်ယှင်းသော ဝိညာဉ်တော်သည် ဂြိုးငှက်အသွင်ဖြင့် ကိုယ်ထင်ရှား၍ ကိုယ်တော်၏အပေါ်သို့ ဆင်းသက်တော်မူ၏။ ကောင်းကင်မှအသံတော်ကား “သင်သည် ငါနှစ်သက်မြတ်နိုးရာ ငါ၏ချစ်သားဖြစ်သည်” ဟု ထွက်ပေါ်လာ၏။ ");
INSERT INTO rki_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","အမှုတော်ကို စတင်ဆောင်ရွက်ချိန်၌ ယေသျှုသည် အသက်သုံးဆယ်ခန့် ဟိတော်မူ၏။ လူများအထင်မှာ ကိုယ်တော်သည် ယောသပ်၏သား ဖြစ်၏။ ယောသပ်သည် ဧလိ၏ သားတည်း။ ");
INSERT INTO rki_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ဧလိသည် မဿတ်၏သား၊ မဿတ်သည် လေဝိ၏သား၊ လေဝိသည် မေလခိ၏သား၊ မေလခိသည် ယန္န၏သား၊ ယန္နသည် ယောသပ်၏သား ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ယောသပ်သည် မတ္တသိ၏သား၊ မတ္တသိသည် အာမုတ်၏သား၊ အာမုတ်သည် နာဟုံ၏သား၊ နာဟုံသည် ဧသလိ၏သား၊ ဧသလိသည် နဂ္ဂဲ၏သားဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","နဂ္ဂဲသည် မာအတ်၏သား၊ မာအတ်သည် မတ္တသိ၏သား၊ မတ္တသိသည် သျှေမိ၏သား၊ သျှေမိသည် ယောသပ်၏သား၊ ယောသပ်သည် ယုဒ၏သား ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ယုဒသည် ယောဟန္န၏သား၊ ယောဟန္နသည် ရေသ၏သား၊ ရေသသည် ဇေရုဗဗေလ၏သား၊ ဇေရုဗာဗေလသည် သျှာလသေလ၏သား၊ သျှာလသေလသည် နီရဲ၏သား ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","နေရဲသည် မေလခိ၏သား၊ မေလခိသည် အဒ္ဒိ၏သား၊ အဒ္ဒိသည် ကောသံ၏သား၊ ကောသံသည် ဧလမောဒံ၏သား၊ ဧလမောဒံသည် ဧရ၏သား ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ဧရသည် ယောသျှု၏သား၊ ယောသျှုသည် ဧလျေဇာ၏သား၊ ဧလျေဇာသည် ယောရိမ်၏သား၊ ယောရိမ်သည် မဿတ်၏သား၊ မဿတ်သည် လေဝိ၏သား ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","လေဝိသည် သျှိမောင်၏သား၊ သျှိမောင်သည် ယုဒ၏သား၊ ယုဒသည် ယောသပ်၏သား၊ ယောသပ်သည် ယောနန်၏သား၊ ယောနန်သည် ဧလျာကိမ်၏သား ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ဧလျာကိမ်သည် မေလေ၏သား၊ မေလေသည် မဲနန်၏သား၊ မဲနန်သည် မတ္တသ၏သား၊ မတ္တသသည် နာသန်၏သား၊ နာသန်သည် ဒါဝိဒ်၏သား ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ဒါဝိဒ်သည် ယေသျှဲ၏သား၊ ယေသျှဲသည် သြဗက်၏သား၊ သြဗက်သည် ဗောဇ၏သား၊ ဗောဇသည် စာလမုန်၏သား၊ စာလမုန်သည် နာရှုန်၏သားဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","နာရှုန်သည် အမိနဒပ်၏သား၊ အမိနဒပ်သည် အဒ်မိန်၏သား၊ အဒ်မိန်သည် အာရံနိ၏သား၊ အာရံနိ့သည် ဟေဇရုံ၏သား၊ ဟေဇရုံသည် ဖာရက်၏သား၊ ဖာရက်သည် ယုဒ၏သား ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ယုဒသည် ယာကုပ်၏သား၊ ယာကုပ်သည် ဣဇာက်၏သား၊ ဣဇာက်သည် အာဗြဟံ၏သား၊ အာဗြဟံသည် တေရ၏သား၊ တေရသည် နာခေါ်၏သားဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","နာခေါ်သည် စေရောက်၏သား၊ စေရောက်သည် ရာဂေါ၏သား၊ ရာဂေါသည် ဖာလက်၏သား၊ ဖာလက်သည် ဟေဗာ၏သား၊ ဟေဗာသည် သျှာလ၏သား ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","သျှာလသည် ကာဣနန်၏သား၊ ကာဣနန်သည် အာဖာဇဒ်၏သား၊ အာဖာဇဒ်သည် သျှေမ၏သား၊ သျှေမသည် နောဧ၏သား၊ နောဧသည် လာမက်၏သား ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","လာမက်သည် မသုသျှလ၏သား၊ မသုသျှလသည် ဧနောက်၏သား၊ ဧနောက်သည် ယာရက်၏သား၊ ယာရက်သည် မဟာလေလ၏သား၊ မဟာလေလသည် ကာနန်၏သား ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ကာနန်သည် ဧနုတ်၏သား၊ ဧနုတ်သည် သျှေသ၏သား၊ သျှေသသည် အာဒံ၏သား၊ အာဒံသည် ဘုရားသခင်၏သား ဖြစ်သတည်း။ ");
INSERT INTO rki_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ယေသျှုသည် သန့်ယှင်းသောဝိညာဉ်တော်နှင့် ပြည့်ဝပြီး ယော်ဒန်မြစ်မှ ပြန်ကြွလာတော်မူစဉ် ဝိညာဉ်တော်သည် ကိုယ်တော့်ကို တောကန္တာရသို့ ပို့ဆောင်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ထိုအရပ်၌ ရက်လေးဆယ်ပတ်လုံး မာရ်နတ်၏ စုံစမ်းသွီးဆောင်ခြင်းကို ခံတော်မူ၏။ ထိုနိ့ရက်များအတွင်း မည်သည့်အစားအစာကိုမျှ သုံးဆောင်တော်မမူသောကြောင့် ထိုအချိန်လွန်သောအခါ ကိုယ်တော်သည် ဆာမွတ်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ထိုအခါ မာရ်နတ်က “သင်သည် ဘုရားသခင်၏သားဖြစ်သည်ဟု ဆိုလျှင်၊ ဤကျောက်ခဲကို မုန့်ဖြစ်စီဖို့ အမိန့်ပီးပါ” ဟု လျှောက်၏။ ");
INSERT INTO rki_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ယေသျှုကလည်း၊ “လူသည် မုန့်အားဖြင့်သာ အသက်ရှင်သည် မဟုတ် ဟူ၍ ကျမ်းစာ၌လာ၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ထို့နောက် မာရ်နတ်သည် ကိုယ်တော့်ကို တောင်ထက်သို့ ခေါ်ဆောင်လားပြီးနောက် လောကီနိုင်ငံဟိသမျှကို ချက်ချင်း ညွှန်ပြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ထိုအခါ မာရ်နတ်က “ဤဘုန်းတန်ခိုးစည်းစိမ် ဟိသမျှတိကို သင့်အားပီးမည်။ ဤအရာတိကို ငါ့အား ပီးအပ်ထားသည်ဖြစ်၍ ငါသည် ပီးချင်သောသူကို ပီးနိုင်၏။ ");
INSERT INTO rki_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","သို့ဖြစ်၍ သင်သည် ငါ့ကို ကိုးကွယ်သည်ဟိသော် ဤအရာအားလုံးသည် သင်၏ ဥစ္စာဖြစ်လိမ့်မည်” ဟု ပြော၏။ ");
INSERT INTO rki_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ယေသျှုကလည်း၊ “ကျမ်းစာလာသည်ကား၊ ‘သင်ရို့၏အသျှင် ဘုရားသခင်ကိုသာ ကိုးကွယ်၍ ထိုအသျှင်၏ အမှုကိုသာ ဆောင်ရွက်ရမည်’ ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","မာရ်နတ်သည် ယေသျှုကို ယေရုဆလင်မြို့သို့ ခေါ်လားပြီး ဗိမာန်တော်အထွဋ်ထိပ်၌ ထားပြီးလျှင် “သင်သည် ဘုရားသခင်၏သားတော် ဖြစ်သည်မှန်လျှင်၊ သင်ကိုယ်တိုင် ဤနီရာမှ အောက်သို့ ခုန်ချလိုက်ပါ။ ");
INSERT INTO rki_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ကျမ်းစာတော်မြတ်တွင် ‘သင့်ကို စောင့်ရှောက်ဖို့ ကောင်းကင်တမန်တိကို ဘုရားသခင်က မိန့်မှာထားတော်မူ၏၊’ ");
INSERT INTO rki_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ထို့အပြင် ‘သင်၏ခြီကို ကျောက်နန့် မထိခိုက်စီခြင်းငှာ သူရို့လက်နှင့် သင့်ကို ကိုင်ထားကြလိမ့်မည်’” ဟူ၍လည်း ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ယေသျှုကလည်း “ ‘သင်၏ ဘုရားသခင် ထာဝရဘုရားကို စုံစမ်းခြင်းမပြုရ’ ဟု ကျမ်းစာ၌လာ၏” ဟူ၍ မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","မာရ်နတ်သည် စုံစမ်းသွီးဆောင်ခြင်း အားလုံးကို ပြုပြီးသောအခါ ကိုယ်တော်ထံပါးမှ အဝီးသို့ ထွက်လားပြီးလျှင် အခါအခွင့်ကောင်းကို စောင့်နိန်၏။ ");
INSERT INTO rki_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ထို့နောက် ယေသျှုသည် သန့်ယှင်းသော ဝိညာဉ်တော်တန်ခိုးနှင့် ပြည့်ဝလျက် ဂါလိလဲပြည်သို့ ပြန်ကြွလာတော်မူ၏။ ကိုယ်တော်၏ သတင်းတော်သည် ထိုဒေသဝန်းကျင်တစ်ခုလုံးသို့ ပြန့်လားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ကိုယ်တော်သည် တရားဇရပ်များ၌ ဟောပြောသွန်သင်သောကြောင့် လူတိုင်းက ကိုယ်တော့်ကို ချီးမွမ်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","ထို့နောက် ယေသျှုသည် မိမိကြီးပြင်းရာ နာဇရက်မြို့သို့ ကြွတော်မူပြီးလျှင် ဥပုသ်နိ့၌ ထုံးစံဟိသည်အတိုင်း တရားဇရပ်သို့ ဝင်တော်မူ၏။ ကိုယ်တော်သည် ကျမ်းစာကို ဖတ်ခြင်းငှာ ထတော်မူလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ပရောဖက်ဟေရှာယ ကျမ်းစာကို ကိုယ်တော်အား ပီးတော်မူ၏။ ကိုယ်တော်သည် ကျမ်းစာကို ဖွင့်၍ တွိ့တော်မူသော ကျမ်းစာ၌ ရီးထားသည်မှာ၊ ");
INSERT INTO rki_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“ထာဝရဘုရား၏ ဝိညာဉ်တော်သည် ငါ့အထက်၌ တည်တော်မူပြီးလျှင်၊ ဆင်းရဲသားရို့အား သတင်းကောင်းကို ပြောကြားရန် ငါ့ကို ရွီးခြယ်တော်မူပြီ။ အချုပ်အနှောင်ခံရသူများကို လွတ်မြောက်စီရန်အကြောင်းနှင့် မျက်စိကန်းသူရို့ကို မျက်စိပြန်မြင်စီရန်၊ ညှည်းပန်းနှိပ်စက်ခံရသူရို့ကို ကယ်မရန်နှင့်၊ ");
INSERT INTO rki_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ထာဝရဘုရားသည် မိမိလူရို့ကို ကယ်တင်ခြင်းငှာ အချိန်ရောက်ပြီဖြစ်ကြောင်း ကြေငြာရန် ငါ့ကို ရွှတ်လိုက်တော်မူ၏” ဟူ၍ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ထို့နောက် ယေသျှုက ကျမ်းစာလိပ်ကိုလိပ်၍ တရားဇရပ်မှူးအား ပြန်ပီးပြီးနောက် ထိုင်တော်မူ၏။ တရားဇရပ်ထဲ၌ဟိသော လူအပေါင်းရို့သည် ကိုယ်တော့်ကို စိုက်ကြည့်နိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ကိုယ်တော်က “ဤကျမ်းစာ၌ပါသော အကြောင်းအရာများသည် သင်ရို့ကြားသည်အတိုင်း ဤနိ့ ပြည့်စုံလီဗျာယ်” ဟု သူရို့အား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","လူအပေါင်းရို့သည် ကိုယ်တော်၏အကြောင်းကို ချီးကျူးပြောဆိုပြီး နှုတ်တော်ထွက်စကားများကို အံ့သြကြ၏။ သူရို့က “ဤသူသည် ယောသပ်သား မဟုတ်လား” ဟုပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ကိုယ်တော်ကလည်း၊ “သင်ရို့သည် ‘အချင်း ဆီးဆရာ၊ သင့်ရောဂါကို သင်ပျောက်အောင် ကုလော့’ ဆိုသည့် ဆိုရိုးစကားကို အသုံးပြု၍ ငါ့အား ဧကန်အမှန် ဆိုလိမ့်မည်။ ‘ကပေရနောင်မြို့၌ အသျှင်ပြုခသည့် အမှုကို အကျွန်ရို့ ကြားသည်အတိုင်း အသျှင်နီထိုင်ရာမြို့၌လည်း ပြုတော်မူပါ’ ဟု ငါ့ကို ပြောကြလိမ့်မည်။” ");
INSERT INTO rki_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ယေသျှုကလည်း “ငါအမှန်ဆိုသည်ကား၊ ပရောဖက်ရို့သည် မိမိနီရပ်မြို့၌ မျက်နှာမရတတ်။” ဟု ထပ်၍ မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“ငါအမှန်ဆိုသည်ကား၊ ဧလိယလက်ထက် ဣသရေလ နိုင်ငံတွင် သုံးနှစ်နှင့်ခြောက်လပတ်လုံး မိုးခေါင်ပြီးလျှင် ကြီးစွာသော အစာငတ်မွတ်ခြင်းဖီး ကျရောက်သောအခါ၌ ဣသရေလအမျိုး မုဆိုးမတိ ဟိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","သို့သော်လည်း ပရောဖက်ဧလိယအား ဇာသူတစ်ယောက်ပါးကိုမျှ ရွှတ်လိုက်တော်မမူ။ ဇိဒုံပြည်၊ ဇရတ္တမြို့သူ မုဆိုးမပါးသို့သာ ရွှတ်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","ပရောဖက်ဧလိသျှဲ လက်ထက်တွင်လည်း ဣသရေလအမျိုးသားရို့သည် နူနာရောဂါသည် အများဟိသော်လည်း ဇာသူတစ်ယောက်မျှ ကျန်းမာခြင်းကို မရကတ်၊ ယှုရိပြည်သား နေမန်သာလျှင် ကျန်းမာခြင်းကို ရ၏” ဟု သူရို့အား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","တရားဇရပ်၌ဟိသော လူအပေါင်းရို့သည် ထိုစကားကို ကြားသောအခါ အလွန် ဒေါသ ထွက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","သူရို့သည် ထ၍၊ ယေသျှုအား တောင်ကမ်းပါးမှ တွန်းချရန် မြို့တည်ရာ တောင်ထိပ်စွန်းသို့ ခေါ်ဆောင်လားကြ၍ ကိုယ်တော့်ကို တောင်ကမ်းပါးစွန်းမှ တွန်းချရန် ရည်ရွယ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","သို့ရာတွင် ကိုယ်တော်သည် ပရိသတ်အလယ်မှ လျှောက်၍ ကြွလားတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ထို့နောက် ယေသျှုသည် ဂါလိလဲပြည်၊ ကပေရေနောင်မြို့သို့ ရောက်သောအခါ ဥပုသ်နိ့၌ လူတိကို ဟောပြောသွန်သင်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ကိုယ်တော်၏ ဟောပြောချက်များသည် အခွင့်အာဏာ ပါဟိသောကြောင့် သူရို့သည် အံ့သြကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","တရားဇရပ်ထဲတွင် ညစ်ညူးသောနတ်ဆိုး ဝင်ပူးခံရသူတစ်ဦး ဟိ၏။ မိစ္ဆာနတ်ဆိုးက၊ ");
INSERT INTO rki_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“အို၊ နာဇရက်မြို့သား ယေသျှု၊ ကိုယ်တော်သည် အကျွန်ရို့နှင့် ဇာဆိုင်လဲ၊ အကျွန်ရို့ကို ပျက်စီးစီရန်အတွက် ကြွလာသလား၊ ကိုယ်တော်သည် ဇာသူဖြစ်သည်ကို အကျွန် သိပါ၏။ ကိုယ်တော်သည် ဘုရားသခင်၏ သန့်ယှင်းသောသူဖြစ်ပါ၏” ဟု ကျယ်လောင်စွာ ဟစ်အော်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","ယေသျှုကလည်း၊ “တိတ်ဆိတ်စွာ နိန်၍ သူ့အထဲက ထွက်လားလော” ဟု မိန့်တော်မူ၏။ ထို့နောက် နတ်ဆိုးသည် ထိုသူကို လူအများရှိ့၌ လှဲချပြီးလျှင် အနာတရ မဖြစ်စီဘဲ သူ့အထဲမှ ထွက်လားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","လူအပေါင်းရို့သည် အံ့သြလျက် “ဤစကားက ဇာပိုင်မျိုးလဲ၊ ဤသူသည် ဝိညာဉ်ဆိုးတိကို ထွက်လားရန် တန်ခိုးအာဏာဖြင့် အမိန့်ပီး၍ သူရို့ ထွက်လားကြပါသည်တကား” ဟု အချင်းချင်း ပြောဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ယေသျှု၏ သတင်းတော်သည် ပတ်ဝန်းကျင်ဒေသ တလျှောက်တွင် ပြန့်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ယေသျှုသည် တရားဇရပ်မှ ထွက်ကြွပြီး သျှိမုန်၏အိမ်သို့ ကြွတော်မူ၏။ သျှိမုန်၏ယောက္ခမသည် အဖျားဝေဒနာကို ပြင်းစွာ ခံစားနိန်သည်ဖြစ်၍ သူရို့သည် ထိုအကြောင်းကို ကိုယ်တော်အား လျှောက်ထားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","သို့ဖြစ်၍ ကိုယ်တော်သည် သူမ၏အနားတွင် ရပ်ပြီးလျှင် အဖျားပျောက်စီရန် အမိန့်ပီးတော်မူလျှင် အဖျားပျောက်သဖြင့် ချက်ချင်းထ၍ သူရို့အား အာဂန္တုဝတ်ကို ပြုလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","နီဝင်ပြီးနောက် လူတိက ရောဂါအမျိုးမျိုးဟိသောသူ အပေါင်းရို့ကို ယေသျှုထံတော်သို့ ခေါ်ဆောင်ခသည်ဖြစ်၍ ကိုယ်တော်သည် ထိုသူရို့၏ ဂေါင်းထက်မှာ လက်ကိုတင်၍ ရောဂါများကို ပျောက်စီတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","မိစ္ဆာနတ်ဆိုးရို့က “အသျှင်သည် ဘုရားသခင်၏သားတော်ဖြစ်၏” ဟု အော်ဟစ်လျက် လူတိထဲမှ ထွက်လားကြ၏။ ယေသျှုသည် နတ်ဆိုးတိအား စကားတစ်ခွန်းကိုမျှ ပြောခြင်းကို မပြုခြင်းငှာ အမိန့်ပီးတော်မူ၏။ အကြောင်းမူကား သူရို့သည် ကိုယ်တော်အား မေသျှိယဖြစ်ကြောင်းကို သိသောကြောင့် ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","မိုးလင်းသောအခါ ယေသျှုသည် လူသူကင်းဝီးသော အရပ်သို့ ကြွတော်မူ၏။ လူရို့သည် ကိုယ်တော့်ကိုရှာ၍ တွိ့သောအခါ မိမိရို့ပါးမှ ထွက်ကြွမလားစီရန် ကြိုးစားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","သို့စေကာမူ ကိုယ်တော်က၊ “ငါသည် အခြားမြို့များကိုလည်း ဘုရားသခင်၏ နိုင်ငံတော် သတင်းကောင်းကို ဟောပြောရမည်။ အကြောင်းမူကား ဤအတွက်ကြောင့် ငါ့ကို ရွှတ်လိုက်ခြင်းဖြစ်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ထို့ကြောင့် ကိုယ်တော်သည် ယုဒပြည် တရားဇရပ်များတွင် လှည့်လည်၍ တရားဟောတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","တစ်နိ့၌ ယေသျှုသည် ဂင်္နေသရက်အိုင်ကမ်းခြီတွင် ရပ်နိန်တော်မူစဉ် လူတိက ဘုရားသခင်၏ နှုတ်ကပါတ်တော်ကို ကြားနာခြင်းငှာ ကိုယ်တော်ထံပါးသို့ တိုးဝင်လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ထိုအခါ ကိုယ်တော်သည် ကမ်းနား၌ ကပ်ထားသော လောင်းနှစ်စင်းကို မြင်၏။ တံငါသည်ရို့သည် လောင်းထက်ကဆင်းပြီးနောက် ပိုက်များကို ဆီးကြောလျက်နိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ယေသျှုသည် လောင်းများအနက် သျှိမုန်၏ လောင်းထက်သို့ တက်တော်မူပြီးလျှင် လောင်းကို ကမ်းမှအနည်းချေခွါရန် သျှိမုန်အား ပြော၏။ ထို့နောက် ယေသျှုသည် ထိုင်ပြီးလျှင် လူပရိတ်သတ်ရို့အား ဟောပြောသွန်သင်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ထိုသို့ ဟောပြောပြီးသောအခါ၊ ကိုယ်တော်က “ရီနက်ရာသို့ ရွှိ့လား၍ သင့်အဖော်တိနှင့်အတူ ပိုက်ကိုချပြီး ငါးဖမ်းကြလော့” ဟု သျှိမုန်အား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","သျှိမုန်က၊ “သခင်၊ အကျွန်ရို့ တစ်ညလုံးကြိုးစား၍ ငါးရှာကြသော်လည်း ငါးချေ တစ်ကောင်တောင် မရ။ သို့သော် ကိုယ်တော် မိန့်တော်မူသောကြောင့် ပိုက်တိကို ချပါမည်” ဟုလျှောက်ထား၏။ ");
INSERT INTO rki_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","သူရို့သည် ပိုက်တိကို ချပြီးနောက် အုပ်မိသောငါး များလွန်းသဖြင့် ပိုက်များပင် စုတ်ပြဲလုမတက်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ထို့ကြောင့် လာရောက်ကူညီခြင်းငှာ အခြားသော လောင်းတွင်ဟိသော အဖော်များကို အချက်ပြ၍ ခေါ်ကြ၏။ ထိုသူရို့သည် လာ၍ လောင်းနှစ်စင်း၌ ထည့်ကြရာ ငါးနှင့်ပြည့်သဖြင့် လောင်းများ နစ်မြုပ်လုနီးပါး ဖြစ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ထိုအခြင်းအရာကို သျှိမုန်ပေတရုမြင်သောအခါ ယေသျှု၏ ခြီတော်ရင်းတွင် ပျပ်ဝပ်လျက် “အသျှင်၊ အကျွန်သည် အပြစ်များသောသူဖြစ်၍ အကျွန်ရို့ပါးမှ ကြွလားတော်မူပါ” ဟုလျှောက်၏။ ");
INSERT INTO rki_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ထိုသို့လျှောက်ရသည်မှာ ဖမ်းမိသော ငါးများပြားသဖြင့် သျှိမုန်နှင့် သူ့အပေါင်းအဖော်ရို့သည် အံ့သြကြသောကြောင့် ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","သျှိမုန်၏ လုပ်ဖော်ဆောင်ဖက်များဖြစ်ကြသော ဇေဗေဒဲ၏သား ယာကုပ်နှင့် ယောဟန်သည်လည်း အံ့သြကြ၏။ ယေသျှုက သျှိမုန်အား “မကြောက်ကတ်ကေ့၊ သင်ရို့သည် အဂုအချိန်ကစပြီးလျှင် လူကိုမျှားသော တံငါဖြစ်လိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ထိုသူရို့သည် လောင်းကို ကမ်းနားမှာ ကပ်ထားပြီးလျှင် ဟိသမျှကိုစွန့်၍ နောက်တော်သို့ လိုက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","တစ်နိ့တွင် ယေသျှုသည် မြို့တစ်မြို့၌ ဟိတော်မူစဉ် ထိုမြို့၌ တစ်ကိုယ်လုံး နူနာစွဲသူတစ်ယောက်သည် ဟိ၏။ သူသည် ယေသျှုကို မြင်လျှင် ပျပ်ဝပ်လျက် “အသျှင်၊ အလိုတော်ဟိလျှင် အကျွန့်ကို သန့်ယှင်းနိုင်ပါ၏” ဟု လျှောက်တင်၏။ ");
INSERT INTO rki_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ယေသျှုသည် လက်ကိုဆန့်၍ ထိုသူကို တို့တော်မူပြီးလျှင် “ငါအလိုဟိ၏။ သန့်ယှင်းစီ” ဟု မိန့်တော်မူလျှင် ချက်ချင်းပင် ထိုသူသည် ရောဂါပျောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","ယေသျှုက “ဤအကြောင်းအရာကို တစ်ယောက်ကိုလေ့ မပြောကေ့” ဟု တားမြစ်ပြီး “သင်သည် ယဇ်ပုရောဟိတ်ပါးကို လားပြီးလျှင် ကိုယ်ကိုပြလော့၊ သင့်ရောဂါ ပျောက်ကင်းကြောင်း လူတိရှိ့၌ သက်သီဖြစ်ဖို့အတွက် မောသျှေ မိန့်မှာထားသော ပူဇော်သကာကို ဆက်သလော့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","သို့ရာတွင် ယေသျှု၏သတင်းတော်သည် ပို၍ ပြန့်လားသဖြင့် လူအပါင်းရို့သည် ကိုယ်တော်၏တရားတော်ကို ကြားနာရန်နှင့် မိမိရို့၏အနာရောဂါများမှ ကျန်းမာခြင်းရစီရန် လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","သို့သော်လည်း ကိုယ်တော်သည် လူသူကင်းဝီးရာအရပ်၌ ဆုတောင်းရန် ကြွလားလေ့ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","တစ်နိ့၌ ယေသျှုသည် ဟောပြောသွန်သင်တော်မူစဉ် ဖာရိယှဲတိနှင့် ကျမ်းတတ်ဆရာတချို့သည် ထိုင်နိန်ကြ၏။ သူရို့သည် ယုဒပြည်နှင့် ဂါလိလဲပြည် မြို့ရွာအသီးသီးမှလည်းကောင်း၊ ယေရုဆလင်မြို့မှလည်းကောင်း လာရောက်ကြသောသူများ ဖြစ်ကြ၏။ ရောဂါများကို ပျောက်ကင်းစီရန် ထာဝရဘုရား၏ တန်ခိုးတော်သည် ယေသျှု၌ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","လူတချို့သည် လီဖြတ်သူတစ်ယောက်ကို အိပ်ရာနန့်မ၍ ယူလာကြပြီးလျှင် ယေသျှု ရှိ့တော်မှောက်၌ ချထားရန်အတွက် အိမ်ထဲသို့ ဝင်နိုင်ခြင်းငှာ ကြိုးစားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","လူထုပရိသတ်ကြောင့် သူရို့သည် လူနာကို သယ်ယူရန် လမ်းကို ရှာမတွိ့နိုင်ကြပေ။ ထို့ကြောင့် လူနာကို အိပ်ရာနှင့်တကွ အိမ်ခေါင်ထက်သို့ မတင်လာပြီးလျှင် အိမ်ခေါင်ကို ဖွင့်၍ လူအုပ်အလယ်၌ဟိသော ယေသျှု၏ ရှိ့မှောက်သို့ လျောချကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ယေသျှုသည် ထိုသူရို့၏ ယုံကြည်ခြင်းကို မြင်သောအခါ၊ လူနာအား “အဆွီ၊ သင်၏အပြစ်ကို ရွှတ်ဗျာယ်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ကျမ်းတတ်ဆရာတိနှင့် ဖာရိယှဲတိက “ဤသူကား ဇာသူလဲ၊ ဘုရားသခင်ကို ပြစ်မှား ပြောဆိုပါသည်တကား၊ ဘုရားသခင်မှလွဲ၍ အပြစ်ကို ဇာသူက ရွှတ်ပီးနိုင်မည်နည်း” ဟု တွေးတော နိန်၏။ ");
INSERT INTO rki_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ယေသျှုသည် သူရို့ တွေးတောနိန်သည်ကို သိတော်မူသဖြင့် “သင်ရို့ ဇာဖြစ်လို့ ယင်းပိုင် တွေးတော နိန်ကြသနည်း၊ ");
INSERT INTO rki_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","‘သင်၏အပြစ်ကို ရွှတ်ဗျာယ်’ ဟု ပြောသည်က ပို၍ လွယ်မည်လား၊ ထိုသို့ မဟုတ်လျှင် ‘ထ၍ လှမ်းလားလော့’ ဟု ပြောသည်က ပို၍ လွယ်မည်လား၊ ");
INSERT INTO rki_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","လူသားသည် ဤလောက၌ အပြစ်လွှတ်ပိုင်သည်ကို သင်ရို့ကို သက်သီပြမည်” ဟု ဆိုလျက် လီဖြတ်သူအား “သင့်ကို ငါပြောမည်၊ ‘ထ’ အိပ်ရာလိပ်ကို ထမ်းပြီးလျှင် အိမ်သို့ပြန်လော့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ချက်ချင်းပင် ထိုသူသည် လူတိရှိ့တွင် ထရပ်လျက် မိမိလဲလျောင်းနိန်ခသော အိပ်ရာကို ထမ်းပြီးလျှင် ဘုရားသခင်၏ ကျေးဇူးတော်ကို ချီးမွမ်းလျက် အိမ်သို့ ပြန်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","လူအပေါင်းရို့သည် အလွန်ပင် အံ့သြလျက် “ငါရို့သည် အံ့သြစရာတိကို ဤနိ့တွင် တွိ့မြင်ရဗျာယ်” ဟု ထိတ်လန့်စွာ ပြောဆို၍ ဘုရားသခင်၏ ဂုဏ်တော်ကို ချီးမွမ်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ထို့နောက် ယေသျှုသည် ထွက်ကြွတော်မူ၍ လေဝိအမည်ဟိသော အခွန်ခံတစ်ယောက်သည် အခွန်ရုံး၌ ထိုင်နိန်သည်ကို မြင်တော်မူလျှင် လေဝိအား၊ “ငါ့နောက်သို့ လိုက်လော့” ဟု မိန့်တော်မူလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","လေဝိသည် ထ၍ ဟိသမျှကို စွန့်ပြီး နောက်တော်သို့ လိုက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ထို့နောက် လေဝိသည် မိမိ၏အိမ်၌ ယေသျှုအတွက် ဧည့်ခံပွဲကြီးကို ကျင်းပရာ များစွာသော အခွန်ခံတိနှင့် အခြားသောသူရို့သည် သူရို့နှင့်အတူ စားသောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","တချို့သော ဖာရိယှဲနှင့် သူရို့၏ ကျမ်းတတ်ဆရာတချို့က “ဇာဖြစ်လို့ သင်ရို့သည် အခွန်ခံတိ၊ အခြားအပယ်ခံသူရို့တိနှင့်အတူ စားသောက်ကြသနည်း” ဟု တပည့်တော်ရို့အား ကဲ့ရဲ့ပြစ်တင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ထိုအခါ ယေသျှုက “ကျန်းမာသူသည် ဆီးဆရာကို အလိုမဟိ၊ ဖျားနာနိန်သောသူသာ အလိုဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ဖြောင့်မတ်သောလူတိကို ခေါ်ဖို့ ငါလာသည် မဟုတ်၊ အပြစ်လုပ်သောလူတိကို နောင်တရဖို့အတွက်သာ ခေါ်ဖို့ ငါလာ၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","လူတချို့က “ယောဟန်တပည့်တိက အစာယှောင်ခြင်း၊ ဆုတောင်းခြင်းတိကို မကြာမကြာ ပြုလေ့ဟိ၏။ ထို့နည်းတူ ဖာရိယှဲတပည့်တိလည်း ပြုကြ၏။ သို့သော်လည်း ကိုယ်တော်တပည့်တော်ရို့က စားသောက်၍ နိန်ကြသည်တကား” ဟု ကိုယ်တော့်ကို လျှောက်ထားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ယေသျှုကလည်း၊ “မင်္ဂလာဆောင်ပွဲ၌ သတို့သားနှင့်အတူ ဟိကြသော အပေါင်းအဖော်ရို့ကို အစာယှောင်ခိုင်း နိုင်မည်လော။ ");
INSERT INTO rki_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","သို့သော်လည်း သတို့သားကို သူရို့အပါးမှ ဆောင်ယူမည့်အချိန် ရောက်လာလိမ့်မည်။ ထိုအခါ သူရို့သည် အစာယှောင်ကြလိမ့်မည်။” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ယေသျှုသည် ပုံဥပမာဆောင်လျက် “ဇာသူတစ်ယောက်မှ အထည်သစ်က အစတစ်စကို ဆုတ်ပြီးလျှင် အထည်ဟောင်းနှင့် စပ်ဖာထည်းလေ့မဟိ။ ထိုသို့ ဖာထည်းခလျှင် အထည်သစ်သည် ပျက်စီးလားရုံမျှမက၊ အထည်ဟောင်းနှင့်လည်း လိုက်ဖက်လိမ့်မည် မဟုတ်။ ");
INSERT INTO rki_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ထိုနည်းတူ၊ စပျစ်ရည်သစ်ကို သားရီဘူးအဟောင်း၌ ထည့်လေ့မဟိ၊ ထည့်ခသည်ဟိသော် သားရီဘူးပေါက်ကွဲပြီးလျှင် စပျစ်ရည် ယိုထွက်လာလိမ့်မည်၊ သားရီဘူးလည်း ပျက်စီးလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","စပျစ်ရည်အသစ်ကို သားရီဘူးအသစ်တွင် ထည့်ရမည်။ ");
INSERT INTO rki_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ပြီးလျှင် စပျစ်ရည်အဟောင်းကို သောက်သူက စပျစ်ရည်အသစ်ကို သောက်ချင်မည် မဟုတ်။ ‘စပျစ်ရည်အဟောင်းက သာ၍ ကောင်းသည်’ ဟု ဆိုတတ်သည်” ဟူ၍ မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ဥပုသ်နိ့၌ ယေသျှုသည် ဂျုံစပါးခင်းများကို ဖြတ်၍ ကြွတော်မူစဉ် တပည့်တော်ရို့သည် ဂျုံစပါးများကို ခြွီယူပြီးလျှင် လက်ဖြင့် ပွတ်နယ်လျက် စားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ဖာရိယှဲတချို့က “ဥပုသ်နိ့၌ မလုပ်အပ်သောအရာကို သင်ရို့ ဇာကြောင့် လုပ်ကြသနည်း” ဟု မိန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ယေသျှုက “ဒါဝိဒ်သည် သူနန့် သူ၏လူတိ ဝမ်းဆာသောအချိန်တွင် ဇာပိုင် ပြုခကြောင်းကို သင်ရို့ မဖတ်ဖူးကြသလော။ ");
INSERT INTO rki_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","သူသည် ဘုရားသခင်၏ အိမ်တော်သို့ဝင်ပြီး ပညတ်တော်အရ ယဇ်ပုရောဟိတ်မှတစ်ပါး ဇာသူမျှ မစားထိုက်သော ရှိ့တော်မုန့်ကို ယူစားပြီးလျှင် သူ၏ လူတိကိုလည်း ပီးခ၏။” ");
INSERT INTO rki_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ထို့နောက် ယေသျှုက “လူသားသည် ဥပုသ်နိ့၏ အသျှင်ဖြစ်သည်” ဟု သူရို့အား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","အခြားသော ဥပုသ်နိ့ တစ်နိ့တွင် ယေသျှုသည် တရားဇရပ်ထဲသို့ ဝင်ပြီးလျှင် ဟောပြောသွန်သင်တော်မူ၏။ ထိုနီရာ၌ လက်ျာဖက် လက်သီသူတစ်ဦးဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","တချို့သော ကျမ်းတတ်ဆရာရို့နှင့် ဖာရိယှဲရို့သည် ယေသျှုကို အပြစ်ရှာလိုသဖြင့် ဥပုသ်နိ့၌ ထိုသူအား ကျန်းမာခွင့်ပီးမည်၊ မပီးမည်ကို စောင့်ကြည့်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","သို့သော် ယေသျှုသည် ထိုသူရို့၏ အကြံအစည်ကို သိသောအခါ လက်သီသောသူအား “ထလာပြီးလျှင် ရှိ့တွင်လာရပ်ပါ” ဟု မိန့်တော်မူသည်အတိုင်း ထိုသူသည် ထ၍ မတ်တပ်ရပ် နိန်၏။ ");
INSERT INTO rki_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ထိုအခါ ယေသျှုက “သင်ရို့ကို ငါမိန်းမေ။ ပညတ်တရားအရ ဥပုသ်နိ့၌ ကျေးဇူးပြုသင့်သလား၊ သူ့အကျိုးကို ဖျက်ဆီးသင့်သလား။ လူတစ်ယောက်၏အသက်ကို ကယ်သင့်သလား၊ ဖျက်ဆီးသင့်သလား” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ကိုယ်တော်သည် ထိုသူရို့အား လှည့်ပတ်၍ ကြည့်တော်မူပြီးလျှင် လက်သီသောသူအား “သင့်၏လက်ကို ဆန့်လော့” ဟု မိန့်တော်မူ၏။ ထိုသူသည် လက်ကို ဆန့်လိုက်သောအခါ အကောင်းပကတိ ဖြစ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","ထိုသူရို့သည် အလွန်ဒေါသထွက်သဖြင့် ယေသျှုအား မည်သို့ပြုရမည်ကို အချင်းချင်းဆွေးနွေးကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ထိုနိ့ရက်ကာလ၌ ယေသျှုသည် ဆုတောင်းပတ္ထနာပြုရန် တောင်ထက်သို့ တက်ကြွတော်မူပြီးလျှင် တစ်ညလုံး ဘုရားသခင်ထံတော်၌ ဆုတောင်းပတ္ထနာပြုလျက် နိန်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","မိုးလင်းသောအခါ တပည့်တော်တိကို ကိုယ်တော့်ထံသို့ ခေါ်တော်မူပြီးလျှင် ထိုသူရို့အထဲမှ တစ်ဆယ့်နှစ်ပါးကို ရွီးချယ်၍ တမန်တော်များဟု နာမည်ပီးလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ထိုတစ်ဆယ့်နှစ်ပါးကား ပေတရုအမည်သစ်ကိုရသော သျှိမုန်နှင့် သူ၏ညီ အန္ဒြေ၊ ယာကုပ်နှင့် ယောဟန်၊ ဖိလိပ္ပုနှင့် ဗာသောလမဲ၊ ");
INSERT INTO rki_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","မဿဲနှင့် သောမ၊ အာလဖဲ၏သား ယာကုပ်၊ မျိုးချစ်စိတ်ထက်သန်သူ သျှိမုန်၊ ");
INSERT INTO rki_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ယာကုပ်၏သား ယုဒ၊ သစ္စာဖောက်သူ ယုဒသျှကာရုတ်ရို့ဖြစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ယေသျှုသည် တမန်တော်တိနှင့်အတူ တောင်ထက်မှ ဆင်းကြွတော်မူပြီးလျှင် များစွာသော တပည့်တော်တိနှင့်အတူ မြီညီရာအရပ်၌ ရပ် နိန်တော်မူ၏။ ထိုနီရာ၌ ယုဒပြည်၊ ယေရုဆလင်မြို့အပြင် ပင်လယ်ဆိပ်ကမ်းမြို့များဖြစ်သော တုရုမြို့နှင့် ဇိဒုန်မြို့များမှ လူအစုအဝေးရို့သည် ဟိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ထိုသူရို့သည် ကိုယ်တော်၏ တရားတော်ကို နာကြားရန်နှင့် မိမိရို့၏ အနာရောဂါများ ပျောက်ကင်းစီရန် လာရောက်ကြခြင်း ဖြစ်၏။ နတ်ဆိုး၏ နှိပ်စက်မှုကို ခံရသောသူတိလည်း အနာပျောက်ကင်းခြင်းကို ခံရကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ကိုယ်တော်အထံတော်မှ တန်ခိုးထွက်၍ အနာရောဂါပျောက်စီသောကြောင့် လူအပေါင်းရို့သည် ကိုယ်တော့်ကို တို့ထိရန် ကြိုးစားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","ယေသျှုသည် တပည့်တော်ရို့ကို ကြည့်တော်မူပြီးလျှင် “ဆင်းရဲသားရို့၊ သင်ရို့သည် မင်္ဂလာဟိကြ၏၊ အကြောင်းမူကား ဘုရားသခင် နိုင်ငံတော်သည် သင်ရို့၏ နိုင်ငံဖြစ်၏။” ");
INSERT INTO rki_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“အဂု ဆာမွတ်နိန်သောသူရို့၊ သင်ရို့သည် မင်္ဂလာဟိကြ၏။ အကြောင်းမူကား သင်ရို့သည် ဝပြောရလိမ့်မည်။” အဂု ငိုကြွီးနိန်သောသူရို့၊ သင်ရို့သည် မင်္ဂလာဟိကြ၏။ အကြောင်းမူကား သင်ရို့သည် ရယ်မောရလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“လူသားကြောင့် သင့်ကို လူတိက မုန်းတီးခြင်း၊ ငြင်းပယ်ခြင်း၊ မထီလေးစားပြုခံရခြင်းနှင့် အသရေရှုံ့ချ ခံရသောအခါ မင်္ဂလာဟိကြ၏။” ");
INSERT INTO rki_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“ထိုသို့ တွိ့ကြုံရသောအခါ ဝမ်းမြောက်ကြပါ။ ရွှင်မြူး ကခုန်ကတ်ပါ။ အကြောင်းမူကား ကောင်းကင်ဘုံ၌ သင်ရို့ရဖို့အကျိုးသည် ကြီးမားကြ၏။ ထိုအတိုင်းပင် သူရို့ အဖိုးအဖီးတိကလည်း ပရောဖက်တိကို ပြုခ၏။” ");
INSERT INTO rki_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“ယေဒါလည်း အဂုဘဝ၌ ချမ်းသာသောသူရို့၊ သင်ရို့သည် အမင်္ဂလာဟိကြ၏။ အကြောင်းမူကား သင်ရို့သည် သက်သာစွာ နီထိုင်ရကြ၏။” ");
INSERT INTO rki_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“အဂု ဝစွာစားရသောသူရို့၊ သင်ရို့သည် အမင်္ဂလာဟိကြ၏၊ အကြောင်းမူကား သင်ရို့သည် ဆာမွတ်ရလိမ့်မည်။ အဂု ရယ်မောရသူရို့၊ သင်ရို့သည် အမင်္ဂလာဟိကြ၏၊” အကြောင်းမူကား သင်ရို့သည် ငြီးတွားငိုကြွီးရလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“လူအပေါင်းရို့က သင့်ကို ချီးမွမ်းကြသောအခါ၊ သင်ရို့သည် အမင်္ဂလာဟိကြ၏။ ထိုသို့အတိုင်းပင် သူရို့အဖိုးအဖီးတိကလည်း မိစ္ဆာပရောဖက်တိကို ချီးမွမ်းခကြ၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“သို့ရာတွင် ငါ၏ တရားစကားကို နာကြားသောသူရို့၊ သင်ရို့အား ငါဆိုသည်မှာ သင်ရို့၏ ရန်သူကို ချစ်လော့။ သင်ရို့အား မုန်းသောသူရို့ကို ကျေးဇူးပြုကြလော့။” ");
INSERT INTO rki_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","သင်ရို့အား ကျိန်ဆဲသောသူကို မေတ္တာပို့ကြလော့။ နှောက်ယှက်သောသူတိအတွက် ဆုတောင်းပီးကြလော့။ ");
INSERT INTO rki_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","သင်၏ပါးတစ်ဖက်ကို သတ်သူကို၊ ကျန်သောတစ်ဖက်ကိုလည်း သတ်စီလော့။ သင်၏ဝတ်ရုံကို ယူလားသောသူအား အင်္ကျီကိုလည်း ပီးလိုက်လော့။ ");
INSERT INTO rki_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","သင့်ပါး၌ တောင်းခံသောသူကို ပီးလော့၊ တစ်စုံတစ်ယောက်က သင်၏ပစ္စည်းကို ယူလားကေ ပြန်မတောင်းကေ့။ ");
INSERT INTO rki_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","သင်ရို့သည် မိမိ၌ သူတစ်ပါး ပြုစီချင်သည့်အတိုင်း သူတစ်ပါးကိုလည်း ပြုကြလော့။ ");
INSERT INTO rki_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","သင်ရို့ကို ချစ်သောသူတိကိုသာ ချစ်တုံ့ပြန်လျှင် ဇာပိုင် ကောင်းကြီးမင်္ဂလာကို ခံစားရမည်နည်း။ အပြစ်သားတိပင်လျှင် မိမိကို ချစ်သောလူတိကို ပြန်ချစ်တတ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","သင်ရို့အား ကျေးဇူးပြုသောသူကို သာလျှင် ကျေးဇူးတုံ့ပြန်လျှင် ဇာပိုင် ကောင်းကြီးမင်္ဂလာကို ခံရမည်နည်း။ အပြစ်သားတိပင် ဤသို့ ပြုလုပ်တတ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","ပြန်ဆပ်နိုင်မည်ဟု မျှော်လင့်ရသူကိုသာ ချီးငှားလျှင် ဇာပိုင် ကောင်းကြီးမင်္ဂလာကို ခံစားရမည်နည်း။ အပြစ်သားတိပင်လျှင် ပြန်ဆပ်ပီးမည်ဟု အချင်းချင်း မျှော်လင့်ပြီးလျှင် ချီးငှားတတ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","ထိုသို့မဟုတ်၊ သင်ရို့၏ရန်သူကို ချစ်လော့။ ကျေးဇူးပြုလော့။ တစ်စုံတစ်ခုပြန်ရဖို့ကို မမျှော်လင့်ဘဲ ချီးငှားကြလော့။ ထိုသို့ဆိုလျှင် သင်ရို့သည် ကြီးမြတ်သောဆုကို ရရုံသာမက အမြင့်ဆုံးသော ဘုရား၏သား ဖြစ်လိမ့်မည်။ ထိုအသျှင်သည် ကျေးဇူးမသိတတ်သောသူ၊ ဆိုးမိုက်သောသူရို့ကို ကျေးဇူးပြုတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","သင်ရို့၏ အဖဘုရားသည် သနားကြင်နာတော်မူသည့်အတိုင်း သင်ရို့လည်း သနားကြင်နာခြင်း ဟိကြလော့။ ");
INSERT INTO rki_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“သူတစ်ပါးတိကို မစစ်ကြောမစီရင်ကတ်ကေ့၊ သို့မှသာ ဘုရားသခင်သည် သင်ရို့ကို မစစ်ကြောမစီရင်ဘဲ နိန်လိမ့်မည်။ သူတစ်ပါးကို မကဲ့ရဲ့ကတ်ကေ့၊ သို့မှသာ ဘုရားသခင်သည် သင်ရို့ကို မကဲ့ရဲ့ဘဲ နိန်လိမ့်မည်။ သူတစ်ပါးကို ခွင့်ရွှတ်လော့။ သို့မှသာ ဘုရားသခင်က သင်ရို့ကို ခွင့်ရွှတ်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","သူတစ်ပါးကို ပီးကမ်းလော့၊ သို့မှသာ ဘုရားသခင်သည် သင်ရို့ကို ပီးတော်မူလိမ့်မည်။ လှုပ်လျက်၊ သိပ်လျက်၊ ပြည့်လျှံသည့် တောင်းပမာဏနှင့် သင်ရို့လက်ထဲကို ပီးတော်မူလိမ့်မည်။ သင်ရို့သည် သူတစ်ပါးအား ချိန်တွယ်ပီးသည့် တောင်းပမာဏအတိုင်း ဘုရားသခင်သည် သင်ရို့ကို ပီးတော်မူလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ထို့နောက် ယေသျှုသည် ထိုသူရို့အား ပုံဥပမာဆောင်၍ “လူကန်းတစ်ယောက်သည် အခြားလူကန်းတစ်ယောက်ကို လမ်းပြ နိုင်မည်လော၊ သူရို့ လားလို့ဟိလျှင် နှစ်ယောက်စလုံး တွင်းထဲသို့ ကျလိမ့်မည် မဟုတ်လော။ ");
INSERT INTO rki_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","တပည့်တိုင်းသည် ဆရာထက် မသာနိုင်၊ သို့သော်လည်း ပညာသင်၍ ပြီးဆုံးသောအခါ တပည့်တိုင်းသည် မိမိရို့၏ဆရာကဲ့သို့ ဖြစ်လိမ့်မည်။” ");
INSERT INTO rki_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","သင်ရို့သည် ဇာကြောင့် ကိုယ့်မျက်စိ၌ဟိသော သစ်သားစကိုမမြင်ဘဲ၊ ညီအစ်ကိုမျက်စိ၌ဟိသော ငြောင့်ချေကို ဇာအတွက်နန့် မြင်ကြသနည်း။ ");
INSERT INTO rki_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","“မိမိ၏မျက်စိ၌ဟိသော သစ်သားစကို မမြင်ဘဲ ဇာကြောင့် သင်၏ညီအစ်ကိုအား ‘သင်၏မျက်စိ၌ဟိသော ငြောင့်ချေကို ထုတ်ပီးမည်’ ဟု ပြောကြသနည်း။ သူတော်ကောင်းယောင်ဆောင်သောသူ၊ သင်၏မျက်စိ၌ဟိသော သစ်သားစကို ဦးစွာထုတ်ပစ်ပါ။ ပြီးမှ သင့်ညီအစ်ကို မျက်စိ၌ဟိသော ငြောင့်ချေကို ကောင်းစွာမြင်၍ ထုတ်ယူ နိုင်လိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“ကောင်းသောအပင်သည် ဖျင်းသောအသီးကို မသီးနိုင်သကဲ့သို့ သိမ်လှီသောအပင်ကလည်း ကောင်းသောအသီးကို မသီးနိုင်” ");
INSERT INTO rki_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","“အသီးသီးသည်ကို ကြည့်ခြင်းအားဖြင့် အပင်တိုင်း၏ အကြောင်းကို သိရ၏။ သဖန်းသီးကို ဆူးပင်မှ မဆွတ်ခူးနိုင်သကဲ့သို့ စပျစ်သီးကို ဆူးခြုံပင်က သင်ရို့ မဆွတ်ခူးနိုင်ကတ်။” ");
INSERT INTO rki_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","“ကောင်းသောလူရို့သည် ကောင်းသောအရာတိနှင့် ပြည့်နိန်သော စိတ်နှလုံးဘဏ္ဍာတိုက်ထဲက ကောင်းသောအရာကိုသာ ထုတ်ဖော်တတ်ကြ၏။ သူယုတ်သည်ကား သူ၏ဘဏ္ဍာတိုက်ထဲက ဆိုးယုတ်သောအရာများကိုသာ ထုတ်ဖော်ကြ၏။ ဇာကြောင့်ဆိုသော် စိတ်နှလုံးထဲ၌ ဟိသမျှသောအရာတိကို နှုတ်ကပြောထုတ်တတ်ကြ၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“သင်ရို့သည် ငါပြောသော အရာကို မကျင့်သုံးဘဲ ငါ့ကို ‘သခင်၊ သခင်’ ဟု ဇာဖြစ်လို့ ခေါ်ကြသနည်း။ ");
INSERT INTO rki_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ငါ့ထံသို့ လာပြီး ငါ့စကားကို နားထောင်၍ လိုက်နာသောသူသည် ဇာသူနှင့်တူကြောင်းကို ဖော်ပြမည်။ ");
INSERT INTO rki_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ထိုသူသည် မြီကြီးကို အနက်ကြီးတူးပြီးလျှင် ကျောက်ထက်မာ အုတ်မြစ်ချ၍ အိမ်ဆောက်သောလူနှင့် တူ၏။ ရီကြီးသောအခါ မြစ်ရီသည် ထိုအိမ်ကို တိုက်သော်လည်း ထိုအိမ်သည် မလှုပ်နိုင်။ ဇာကြောင့်ဆိုသော် အိမ်ကို ခိုင်ခန့်စွာ ဆောက်ထားသောကြောင့် ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","သို့သော်လည်း ငါ့တရားစကားကို ကြားပြီး နားမထောင်သောသူကား အုတ်မြစ်မချဘဲ မြီကြီးထက်၌ အိမ်ဆောက်သောလူနှင့် တူ၏။ မြစ်ရီကြီးပြီး ထိုအိမ်ကို တိုက်သောအခါ ချက်ချင်းပြိုလဲလား၏။ ထိုအိမ်ပျက်စီးမှုက ကြောက်ရွံ့ဖွယ် ကောင်းလွန်းပါသည်တကား” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ယေသျှုသည် လူတိအား ထိုသို့ ဟောပြောသွန်သင်ပြီးနောက် ကပေရနောင်မြို့သို့ ကြွတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ထိုမြို့၌ ရောမတပ်မှူးတစ်ဦးတွင် အလွန်အားထားရသော အခိုင်းအစီတစ်ယောက်သည် ဖျားနာလျက် သီလုမျောပါးဖြစ် နိန်၏။ ");
INSERT INTO rki_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","တပ်မှူးသည် ယေသျှု၏သတင်းတော်ကို ကြားသောအခါ ယုဒအ​မျိုး အ​ကြီး​အ​ကဲ​တိကို ကိုယ်တော့်ထံသို့ ရွှတ်လိုက်ပြီး၊ ကိုယ်တော်ကြွ၍ မိမိ၏အခိုင်းအစီအား ကျန်းမာစီရန် တောင်းလျှောက်စီ၏။ ");
INSERT INTO rki_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","သူရို့သည် ယေသျှုထံသို့ ရောက်လာ၍ “ထိုသူသည် ကိုယ်တော်၏ ကျေးဇူးပြုခြင်းကို ခံထိုက်သူဖြစ်ပါ၏။ ");
INSERT INTO rki_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","သူသည် အကျွန်ရို့လူမျိုးတိကိုချစ်လို့ အကျွန်ရို့အတွက် တရားဇရပ်တစ်ဆောင်ကို ဆောက်လုပ်ပီးသူလည်း ဖြစ်ပါ၏” ဟု လေးနက်စွာလျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ယေသျှုသည် ထိုသူရို့နှင့်အတူ ကြွတော်မူ၏။ တပ်မှူးအိမ်နှင့် မနီးမဝီးသို့ ရောက်သောအခါ တပ်မှူးသည် မိတ်ဆွီများကို ကိုယ်တော်ထံသို့ ရွှတ်လိုက်၍ “အသျှင်ဘုရား၊ ဒုက္ခမရှာပါကေ့။ ကိုယ်တော်သည် အကျွန့်အိမ်ထဲသို့ ဝင်ခြင်းကိုပင် အကျွန် မခံယူထိုက်ပါ။ ");
INSERT INTO rki_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ယင်းနည်းတူ အကျွန်ကလည်း ကိုယ်တော်ထံပါးကို လာထိုက်သူ မဟုတ်ဟု ယူဆပါ၏။ အမိန့်တော်ကိုသာ ပီးတော်မူပါလျှင် အကျွန်၏ အခိုင်းအစီသည် ကျန်းမာလာပါလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","အကျွန်ကိုယ်တိုင်ပင် အထက်အရာဟိ အောက်၌ အမှုထမ်းသူဖြစ်ပြီးလျှင် အကျွန့် လက်အောက်၌လည်း စစ်သားများ ဟိပါ၏။ တစ်ဦးကို ‘လားလော့’ ဟု ဆိုလျှင် လား၍၊ တစ်ဦးကို ‘လာလော’ ဟု ဆိုလျှင် လာကြပါ၏။ အခိုင်းအစီတိကို ‘ဤအလုပ်ကို လုပ်လိုက်’ ဟု ဆိုလျှင် လုပ်ကြပါ၏” ဟု လျှောက်ထားစီ၏။ ");
INSERT INTO rki_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ယေသျှုသည် ထိုစကားကိုကြားတော်မူလျှင် အံ့သြတော်မူ၍ နောက်တော်မှလိုက်လာကြသော လူထုပရိသတ်ဖက်သို့ လှည့်ကြည့်တော်မူပြီးလျှင်၊ “ငါဆိုသည်ကား၊ ဤပိုင်ယုံကြည်ခြင်းကို ဣသရေလလူမျိုးထဲ၌ပင် တစ်ခါလေ့ ငါမတွိ့သိမ့်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","တပ်မှူး ရွှတ်လိုက်သော သူရို့သည် အိမ်သို့ ပြန်ရောက်သောအခါ ထိုအခိုင်းအစီသည် ကျန်းမာလျက်ဟိသည်ကို တွိ့ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ထိုမှ အနည်းငယ်လွန်သော် ယေသျှုသည် နာဣန ဟု ခေါ်သောမြို့သို့ ကြွတော်မူသော် တပည့်တော်ရို့နှင့် လူထုပရိသတ်ကြီးလည်း လိုက်လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","မြို့တံခါးနားသို့ ရောက်သော အချိန်တွင် လူရို့သည် အလောင်းကို သင်္ဂြိုဟ်ရန် မြို့ပြင်သို့ ထမ်းထုတ်ကာ စီတန်း၍ လာကြ၏။ ထိုသူသည် မုဆိုးမ၏ တစ်ဦးတည်းသောသား ဖြစ်၏။ ထိုမုဆိုးမနှင့်အတူ မြို့သူမြို့သားတိလည်း လိုက်ပို့ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","သခင်ဘုရားသည် ထိုမိန်းမကိုမြင်သောအခါ အလွန် သနားသောစိတ်ဟိတော်မူ၍၊ “မငိုကေ့” ဟု သူမအား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ထို့နောက် အနားသို့ ကြွတော်မူပြီးလျှင် တလားကို လက်တော်ဖြင့် တို့တော်မူလျှင် တလားထမ်းသူရို့သည် ရပ်နိန်ကြ၏။ ကိုယ်တော်က၊ “အချင်းလူငယ်၊ ထလော့၊ သင့်ကို ငါဆို၏” ဟု မိန့်တော်မူလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","သီသောသူသည် ထ၍ ထိုင်ပြီးလျှင် စကားပြောလေ၏။ ထို့နောက် ကိုယ်တော်သည် သူ့ကို မိခင်ပါးသို့ အပ်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","လူအပေါင်းရို့သည် ကြောက်ရွံ့လျက် ဘုရားသခင်ကို ချီးမွမ်းကြ၏။ သူရို့က “ငါရို့ထဲ၌ ပရောဖက်ကြီးတစ်ပါး ပေါ်ထွန်းယာ၊ ဘုရားသခင်သည် သူ့လူတိကို ကယ်တင်ဖို့ ကြွလာတော်မူယာ” ဟု ပြောဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ယေသျှု၏သတင်းတော်သည် ယုဒပြည်တလျှောက်လုံးနှင့် ပတ်ဝန်းကျင်ဒေသအားလုံး၌ ပျံ့နှံ့လားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ယောဟန်တပည့်ရို့သည် ဖြစ်ပျက်သမျှသော အကြောင်းအရာအားလုံးကို ယောဟန်အား ပြောကြားကြ၏။ ထိုအခါ သူသည် သူရို့အထဲက တပည့်နှစ်ဦးကို ခေါ်ပြီးလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","သူရို့ကို သခင်ဘုရားထံသို့ ရွှတ်၍ “ကိုယ်တော်သည် ဗတ္တိဇံယောဟန်ပြောသည့် ကြွလာတော်မူမည့်သူလား၊ ယေပိုင် မဟုတ်ကေ အခြားပုဂ္ဂိုလ်တစ်ဦးကို စောင့် နိန်ရအုံးမည်လော” ဟု မိန်းလျှောက်စီ၏။ ");
INSERT INTO rki_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ထိုသူနှစ်ဦးသည် ယေသျှုထံပါးသို့ လာပြီးလျှင် “ကိုယ်တော်သည် ဗတ္တိဇံယောဟန်ပြောသည့် ကြွလာတော်မူမည့်သူလား၊ ထိုသို့ မဟုတ် အခြားပုဂ္ဂိုလ်တစ်ဦးကို စောင့် နိန်ရအုံးမည်လော။ ဤသို့ မိန်းလျှောက်ရန် ဗတ္တိဇံယောဟန်က အကျွန်ရို့ကို ရွှတ်လိုက်ပါ၏” ဟု လျှောက်ထားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ထိုအချိန်၌ ယေသျှုသည် လူအပေါင်းရို့၏ ရောဂါဝေဒနာများကို ပျောက်ကင်းစီခြင်းနှင့် ဝိညာဉ်ဆိုးတိကို နှင်ထုတ်၍ မျက်မမြင်တိကို မျက်စိမြင်စီတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ကိုယ်တော်က “သင်ရို့မြင်ရ၊ ကြားရသောအရာတိကို ယောဟန်ပါးသို့ ပြန်လားပြီးလျှင် ပြောပြကြလော့။ မျက်စိကန်းသူတိ မြင်ရဗျာယ်၊ ခြီကျိုးနိန်သောလူတိ လမ်းလျှောက်နိုင်ဗျာယ်၊ နူနာရောဂါသည်တိ စင်ကြယ်ခြင်း ရဗျာယ်၊ နားမကြားသောလူတိ ကြားရဗျာယ်၊ သီသောလူ အသက်ပြန်ရှင်ဗျာယ်၊ ဆင်းရဲသားရို့ သတင်းကောင်းကိုကြားရဗျာယ်။ ");
INSERT INTO rki_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ငါ့အကြောင်းကို ယုံမှားခြင်းကင်းသူသည် မင်္ဂလာဟိ၏” ဟု ယောဟန်၏ စီတမန်တိအား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ယောဟန်၏ စီတမန်များသည် အထံတော်မှ ထွက်လားကြပြီးနောက် ယေသျှုသည် ယောဟန်အကြောင်းနှင့် ပတ်သတ်၍ လူအစုအဝေးအား၊ “သင်ရို့သည် ဇာကို ကြည့်ရှုခြင်းငှာ တောကန္တရသို့ လားကြသနည်း၊ လေတိုက်၍ လှုပ်သည့် ကျူပင်ကို ကြည့်ရန် လားကြသလော၊ ");
INSERT INTO rki_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","သို့တည်း မဟုတ် ဝတ်ကောင်းစားကောင်း ဝတ်ထားသောလူကို ကြည့်ခြင်းငှာ လားကြသလော၊ ဝတ်ကောင်းစားကောင်း ဝတ်ပြီးလျှင် စည်းစိမ်ခံစားနိန်သော လူတိကား မင်းစိုးရာဇာအိမ်တိတွင် နီထိုင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ငါ့ကို ပြောလော့၊ ပရောဖက်ကို ကြည့်ရန် လားကြသလော၊ မှန်ပါ၏။ ပရောဖက်ထက် သာ၍ ကြီးမြတ်သူကို ကြည့်ဖို့ လားကြခြင်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ကျမ်းစာလာသည်ကား၊ ‘သင်၏လမ်းကို အသင့်ဖြစ်စီရန် ငါ့၏ စီတမန်ကို သင်၏ ရှိ့၌ ငါစီရွှတ်မည်’ ဟု ဆိုရာ၌ ယောဟန်ကို ဆိုလိုခြင်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","ငါဆိုသည်ကား၊ မိန်းမမွီးသော လူတိထဲ၌ ယောဟန်ထက်ကြီးမြတ်သော လူတစ်ယောက်မှ မဟိ။ သို့သော်လည်း ဘုရားသခင်၏ နိုင်ငံတော်၌ အငယ်ဆုံးသောသူသည် ယောဟန်ထက် သာ၍ ကြီးမြတ်သည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","အခွန်ခံသောသူတိမှစ၍ လူအပေါင်းရို့သည် ယောဟန်၏ဗတ္တိဇံကို ခံယူခသဖြင့် ကိုယ်တော်၏စကားကို ကြားသောအခါ ဘုရားသခင်သည် ဖြောင့်မတ်တော်မူသည်ကို အသိမှတ်ပြုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","သို့စေကာမူ ဖာရိယှဲနှင့် ကျမ်းတတ်ဆရာရို့က၊ မိမိရို့အတွက် ဘုရားသခင်ထားတော်မူသော အကြံအစည်တော်ကို ငြင်းပယ်သူများ ဖြစ်ကြသောကြောင့် ယောဟန်ပါးတွင် ဗတ္တိဇံကို မခံယူကြ။ ");
INSERT INTO rki_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","ထို့ကြောင့် ယေသျှုက၊ “အဂု လူတိကို ဇာချင့်နန့် ခိုင်းနှိုင်းပြရမည်နည်း။ သူရို့သည် ဇာချင့်နှင့် တူသနည်း။ ");
INSERT INTO rki_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","သူရို့ကား ဈီး၌ထိုင်နိန်သော အချေတိနှင့် တူ၏။ ‘ငါရို့သည် သာယာစွာတီးမှုတ်သော်လည်း၊ သင်ရို့ မကခုန်ကတ်။ ငါရို့ ငိုခြင်းကို ဆိုသော်လည်း သင်ရို့ မငိုကတ်’ ဟု အချင်းချင်း အော်ဟစ်ပြောဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ဗတ္တိဇံယောဟန်က အစားအစာမစား၊ စပျစ်ရည်ကို မသောက်ဘဲ လာသောခါ သင်ရို့က ‘ဤသူသည် နတ်ဆိုးဝင်ပူးသူ’ ဟု ဆိုတတ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","လူသားသည် စားသောက်၍ လာသည့်အခါ သင်ရို့က ‘ဤသူကို ကြည့်လော့။ သူသည် စားသောက်ကြူးသူ ဖြစ်၏။ အခွန်ခံ၊ အပယ်ခံရို့နှင့် မိတ်ဖွဲ့သူဖြစ်သည်’ ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","သို့စေကာမူ ဘုရားသခင်၏ ဉာဏ်ပညာကို လက်ခံသူသောသူအပေါင်းရို့က ထိုပညာ မှန်ကန်ကြောင်းကို ပြသကြသည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ဖာရိယှဲတစ်ဦးသည် ယေသျှုအား မိမိနှင့်အတူ ညစာသုံးဆောင်ရန် ပင့်ဖိတ်တော်မူသောကြောင့် ယေသျှုသည် ဖာရိယှဲအိမ်သို့ဝင်၍ စားပွဲတွင်ထိုင်၍ သုံးဆောင်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ထိုမြို့တွင် အပြစ်များသော မိန်းမတစ်ယောက်ဟိ၏။ သူမသည် ဖာရိယှဲအိမ်၌ ယေသျှုသည် ညစာသုံးဆောင်နိန်သည်ကို ကြားလျှင် ဆီမွှီးအပြည့်ပါသော ကျောက်ဖြူဘူး တစ်လုံးကိုယူ၍၊ ");
INSERT INTO rki_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ယေသျှု၏ ခြီတော်ရင်းနောက်တွင် ရပ်လျက် ငိုယိုကာ နိန်၏။ သူမ၏မျက်ရည်သည် ကိုယ်တော်၏ ခြီတော်တွင်ကျသဖြင့် မိမိဆံပင်ဖြင့် သုတ်လေ၏။ ထိုမိန်းမသည် ကိုယ်တော်၏ခြီတိကို နမ်းပြီး ဆီမွှီးဖြင့် သုတ်လိမ်းလျက် နိန်၏။ ");
INSERT INTO rki_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ထိုအခြင်းအရာကို ဖာရိယှဲသည်မြင်လျှင် “ဤသူသည် ပရောဖက်တစ်ပါး အမှန် ဖြစ်သည်ဆိုလျှင် သူ၏ခြီကို ကိုင်နိန်သော မိန်းမသည် ဇာသူဖြစ်ကြောင်းကိုလည်းကောင်း၊ ဇာအပြစ်ကို လုပ်နိန်သည်ကိုလည်းကောင်း သိလိမ့်မည်” ဟု ရေရွတ်နိန်၏။ ");
INSERT INTO rki_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ထိုအခါ ယေသျှုက ထိုသူအား၊ “သျှိမုန်၊ သင့်ကို ငါပြောစရာ တစ်ခုဟိသည်” ဟု မိန့်တော်မူလျှင်၊ သျှိမုန်က “ဟုတ်ပါ၏ ဆရာ၊ အမိန့်ဟိပါ” ဟု လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ယေသျှုက “ငွီချီးစားသူတစ်ယောက်၌ အကြွီးတင်သူ နှစ်ယောက်ဟိ၏၊ တစ်ယောက်က ငွီဒင်္ဂါး ၅၀၀၊ အခြားတစ်ယောက်မှာကား ငါးဆယ် အကြွီးတင်၏။ ");
INSERT INTO rki_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","သူရို့သည် အကြွီးမဆပ်နိုင်၍ အကြွီးသျှင်က ထိုအကြွီးတိကို လျော်ပစ်လိုက်၏။ သူရို့နှစ်ယောက်ထဲက ဇာသူက အကြွီးသျှင်ကို ပိုပြီးချစ်မည်နည်း” ဟု မိန်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","သျှိမုန်က “ပို၍ ငွီလျော်ပစ်ခြင်းခံရသူသည် သာ၍ ချစ်မည်ဟု ထင်ပါ၏” ဟု လျှောက်၏။ ကိုယ်တော်က “သင်မှန်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ထို့နောက် ကိုယ်တော်သည် မိန်းမဖက်သို့လှည့်၍ သျှိမုန်အား၊ “သင်သည် ဤမိန်းမကို မြင်သလော၊ ငါသည် သင့်အိမ်ထဲသို့ ဝင်သောအခါ သင်သည် ငါ့ကို ခြီဆီးဖို့အတွက် ရီကိုမပီး၊ သို့သော်လည်း သူမက မျက်ရည်နှင့် ငါ၏ခြီကို ဆီးပြီးလျှင် သူ၏ဆံပင်နှင့် သုတ်ပီး၏။ ");
INSERT INTO rki_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","သင်က ငါ့ကို ကြိုဆိုသည့် အနမ်းဖြင့် မနမ်း၊ ဤမိန်းမသည် အိမ်ထဲသို့ ဝင်သောအချိန်ကစ၍ ငါ၏ခြီကို အဆက်မပြတ် နမ်းလီဗျာယ်။ ");
INSERT INTO rki_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","သင်သည် ငါ့ဂေါင်းကို ဆီနန့် မလိမ်း၊ သူမမူကား ငါ့ခြီကို ဆီမွှီးနန့် လိမ်းပီးဗျာယ်။ ");
INSERT INTO rki_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","ထို့ကြောင့် ငါဆိုသည်ကား၊ ဤမိန်းမသည် များစွာသောအပြစ်တိမှ ခွင့်ရွှတ်ခြင်း ရကြောင်းကို သူမ၏ ကြီးမားသော မေတ္တာက သက်သီပြနိန်၏။ အပြစ်အနည်းချေရာ ခွင့်ရွှတ်ခံရသူက အနည်းချေရာ ချစ်တတ်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ထို့နောက် ယေသျှုက၊ “သင်၏အပြစ်ကို ခွင့်ရွှတ်ဗျာယ်” ဟု မိန်းမအား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","စားပွဲ၌ ထိုင် နိန်ကြသော တခြားလူတိက “အပြစ်ကိုပင် လွှတ်နိုင်သော ဤသူကား ဇာသူလဲ” ဟု အချင်းချင်းပြောဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","သို့စေကာမူ ကိုယ်တော်က ထိုမိန်းမအား၊ “သင်၏ယုံကြည်ခြင်းသည် သင့်ကို ကယ်တင်ဗျာယ်၊ ငြိမ်းဝပ်စွာလားလီ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ကာလအတန်ကြာသောအခါ ယေသျှုသည် မြို့ရွာများကို ကြွတော်မူ၍ ဘုရားသခင် နိုင်ငံတော်အကြောင်း သတင်းကောင်းကို ဟောကြားတော်မူ၏။ ကိုယ်တော်နှင့်အတူ တပည့်တော်တစ်ဆယ့်နှစ်ပါးသည်လည်း လိုက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","အနာရောဂါဖီး၊ ဝိညာဉ်ဆိုးဖီးမှ ကင်းလွတ်ကျန်းမာခွင့်ရခသော မိန်းမတချို့လည်း လိုက်လာကြ၏။ ထိုသူရို့ထဲတွင် နတ်ဆိုးခုနစ်ကောင် ထွက်လားသော မာဂဒလရွာသူ မာရိ၊ ");
INSERT INTO rki_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ဟေရုဒ်မင်း၏စားတော်ကဲ ခုဇ၏မယား ယောဟန္န၊ သျှုယှန္နနှင့် အခြားမိန်းမများလည်းပါ၏။ ထိုအမျိုးသမီးရို့သည် မိမိရို့စရိတ်ဖြင့် ယေသျှုနှင့် တပည့်တော်ရို့အား လုပ်ကျွေးသမှု ပြုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","ယေသျှုထံပါးသို့ အမြို့မြို့မှလာကြသော လူအပေါင်းရို့သည် စုရုံးလျက် နိန်ကြစဉ် ကိုယ်တော်သည် ပုံဥပမာဆောင်၍၊ ");
INSERT INTO rki_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“မျိုးစိ့ကြဲသောသူသည် မျိုးစိ့ကိုကြဲဖို့ရန် ထွက်လားလေ၏။ မျိုးစိ့ကြဲသောအခါ တချို့မျိုးစိ့ရို့သည် လမ်း၌ကျသဖြင့် လူတိက ကျော်နင်းပြီးလျှင် ငှက်တိက ကောက်စားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","တချို့မျိုးစိ့ရို့သည် ကျောက်ခံမြီ၌ကျသဖြင့် အပင်ပေါက်သော်လည်း မြီဆီအစိုဓာတ် မဟိသောကြောင့် ညှိုးနွမ်းခြောက်သွိ့လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","တချို့အစိ့တိကား ဆူးတော၌ကျသဖြင့် အပင်ပေါက်သော်လည်း ဆူးပင်များသည် ညှည်းဆဲသောကြောင့် မကြီးထွားနိုင်။ ");
INSERT INTO rki_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","တချို့အစိ့ရို့သည် ကောင်းသောမြီဆီလွှာ၌ကျသဖြင့် အပင်ပေါက်ပြီးလျှင် အဆတစ်ရာအသီးနှံကို ဖြစ်ထွန်းလေ၏” ဟု မိန့်တော်မူ၏။ ထိုသို့ မိန့်တော်မူပြီးနောက် ယေသျှုက “ကြားစရာနား ဟိသောလူတိကား၊ ကြားပါစီ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","တပည့်တော်ရို့သည် ထိုပုံဥပမာများ၏ အနက်အဓိပ္ပာယ်ကို ယေသျှုအား မိန်းလျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ကိုယ်တော်ကလည်း “သင်ရို့သည် ဘုရားသခင်၏ နိုင်ငံတော်နှင့်ဆိုင်သော နက်နဲသည့် အရာတိကို သိရခြင်းငှာ အခွင့်ဟိကြ၏။ သို့သော် အခြားသော လူတိအား ‘ကြည့်လျက်နန့် မမြင်၊ ကြားလျက်နန့် နားမလည်’ သည့်အတွက် ပုံဥပမာကိုသာ ဟောရခြင်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“ဤပုံဥပမာ၏ အနက်အဓိပ္ပာယ်ကား ဤသို့တည်း၊ မျိုးစိ့က ဘုရားသခင်၏ တရားစကားဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","လမ်း၌ကျသည့် မျိုးစိ့ကား တရားစကားကို ကြားရသော်လည်း နတ်ဆိုးတိက ထိုသူရို့သည် ယုံကြည်၍ ကယ်တင်ခြင်းသို့ မရောက်စီရန် လာပြီးလျှင် သူရို့စိတ်နှလုံးထဲက နှုတ်ကပါတ်တရားတော်ကို နုတ်ယူလားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ကျောက်ခံမြီ၌ ကျသောမျိုးစိ့ကား နှုတ်ကပတ်တရားတော်ကို ကြားသောအခါ ဝမ်းမြောက်စွာ ခံယူသူကို ဆိုလို၏။ သို့သော်လည်း သူရို့၏ စိတ်နှလုံး၌ အမြစ်မစွဲ၊ ကာလအနည်းချေရာ ယုံကြည်လက်ခံကြ၏။ စုံစမ်းနှောက်ယှက်ခြင်းနှင့်တွိ့သောအခါ သူရို့သည် ဖောက်ပြန်လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ဆူးတော၌ ကျသောမျိုးစိ့ကား နှုတ်ကပတ်တရားတော်ကို ကြား၏၊ သို့သော် စိုးရိမ်ပူပန်မှု၊ ချမ်းသာကြွယ်ဝမှု၊ ကာမဂုဏ်ခံစားမှုများ လွှမ်းမိုးနိန်သည့်အတွက် အသီးကောင်းကို မသီးနိုင်။ ");
INSERT INTO rki_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","ကောင်းသောမြီဆီလွှာ၌ ကျသောမျိုးစိ့ကား တရားစကားကို ကြား၍ ဖြောင့်မတ်နာခံတတ်သော နှလုံးသားနှင့် နှုတ်ကပါတ်တရားတော်ကို စွဲမြဲစွာ ခံယူပြီးလျှင် သည်းခံသောအားဖြင့် အသီးသီးသောသူကို ဆိုလိုသတည်း။” ");
INSERT INTO rki_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“ဆီးမီးကိုထွန်းပြီး တောင်းနှင့်အုပ်ထားခြင်း၊ ကုတင် အောက်၌ထားခြင်းကို ဇာသူလေ့ မပြုတတ်။ ဝင်လာသောလူတိ အလင်းကိုမြင်စီဖို့ ဆီးမီးခုံထက်၌ တင်ထားလေ့ ဟိ၏။” ");
INSERT INTO rki_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“အကြောင်းမူကား ကွယ်ဝှက်ထားသောအရာတိ ပေါ်လာပြီးလျှင် ဖုံးအုပ်ထားသော အရာမှန်သမျှသည်လည်း ထင်ရှားလာပြီး အလင်းထဲသို့ ယူဆောင်လာလိမ့်မည်။” ");
INSERT INTO rki_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“ထို့ကြောင့် သင်ရို့ ဇာပိုင်ကြားနာရမည်ကို သတိပြုကြလော့။ အကြောင်းမူကား ဟိသောသူကို ထပ်၍ ပီးလိမ့်မည်။ မဟိသူပါးက ဟိသည်ဟု ထင်သောအရာတိကိုပင် သိမ်းယူလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ယေသျှု၏မယ်တော်နှင့် ညီတော်ရို့သည် ကိုယ်တော်ထံသို့ လာကြ၏။ သို့စေကာမူ လူပရိသတ်တိအား တိုးမပေါက်နိုင်သဖြင့် တွိ့ခွင့်မရ နိုင်ကြ။ ");
INSERT INTO rki_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","လူတစ်ယောက်က ယေသျှုအား “ကိုယ်တော်၏ မယ်တော်နှင့် ညီတော်တိက ကိုယ်တော့်ကို တွိ့ချင်သောကြောင့် အပြင်မှာ စောင့်နိန်ကြပါ၏” ဟု လျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ထိုအခါ ယေသျှုက “ဘုရားသခင်၏ နှုတ်ကပါတ်တော်ကို ကြားနာလိုက်လျှောက်သော လူတိကား ငါ့အမိ၊ ငါ့ညီပင် ဖြစ်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","တစ်နိ့၌ ယေသျှုနှင့် တပည့်တော်ရို့သည် လောင်းထက်သို့ တက်ကြ၏။ ထို့နောက်ကိုယ်တော်က၊ “အိုင်တစ်ဖက်ကို ကူးကြကုန်အံ့” ဟု မိန့်တော်မူသဖြင့် တပည့်တော်ရို့သည် ရွက်ရွှင့်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","သူရို့ ရွက်ရွှင့်ကြစဉ် ယေသျှုသည် အိပ်လျက် နိန်တော်မူ၏။ ရုတ်တရက် အိုင်တွင် လီမုန်တိုင်းကျလာသဖြင့် လောင်းသည် ရီနှင့်ပြည့်လုပြည့်ချင် ဟိသောကြောင့် တပည့်တော်ရို့သည် ကြီးစွာသော ဒုက္ခဖီးနှင့် ကြုံရလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","တပည့်တော်ရို့သည် ချဉ်းကပ်ပြီး ယေသျှုကို နှိုးပြီးလျှင် “သခင်၊ သခင်၊ အကျွန်ရို့ သီရပါဖို့ ဗျာယ်” ဟု ဆိုကြ၏။ ယေသျှုသည် ထတော်မူပြီးလျှင် လီနှင့်လှိုင်းတိကို အမိန့်ပီးတော်မူသဖြင့် လီနှင့်လှိုင်းသည် ငြိမ်သက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ထို့နောက် ကိုယ်တော်က၊ “သင်ရို့ ယုံကြည်ခြင်းက ဇာမာလဲ” ဟု တပည့်တော်တိအား မိန်းတော်မူ၏။ သို့သော် သူရို့သည် ကြောက်ရွံ့အံ့သြလျက် “ဤသူကား ဇာပိုင်မျိုးလူလဲ၊ လီနှင့်လှိုင်းတိကိုပင် အမိန့်ပီးသောအခါ သူရို့သည် အမိန့်နာခံကြသည်တကား” ဟု အချင်းချင်း ပြောဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ယေသျှုနှင့် သူ၏တပည့်တော်ရို့သည် ဂါလိလဲပြည်နှင့် အိုင်တစ်ဖက်ဖြစ်သော ဂါရစနယ်သို့ ရွက်ရွှင့်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ယေသျှုသည် ကမ်းထက်သို့ တက်သည်နှင့် နတ်ဆိုးတိပူးသောသူ တစ်ယောက်သည် မြို့မှလာ၍ ကိုယ်တော့်ကို လာရောက် တွိ့ဆုံလေ၏။ ထိုသူသည် အဝတ်ကိုမဝတ်၊ အိမ်တွင်မနီဘဲ သင်္ချိုင်းကုန်းများတွင်သာ နီသည်မှာ ကြာပြီဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ယေသျှုကိုမြင်လျှင် သူသည် အော်ဟစ်ကာ ရှိ့တော်၌ပျပ်ဝပ်လျက် “ယေသျှု၊ အမြင့်မြတ်ဆုံးသော ဘုရားသခင်၏သားတော်၊ အကျွန့်ပါးက ဇာအလိုဟိပါသလဲ၊ အကျွန့်ကို မနှိပ်စက်ပါကေ့၊ တောင်းပန်ပါ၏” ဟု ကျယ်သောအသံဖြင့် အော်ဟစ် လျှောက်ထားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","ထိုသို့ လျှောက်ထားရသည့်အကြောင်းမှာ ယေသျှုသည် ဝိညာဉ်ဆိုးအား ထိုသူအထဲမှ ထွက်လားရန် အမိန့်ပီးလိုက်သောကြောင့်ဖြစ်၏။ ဝိညာဉ်ဆိုးသည် ထိုသူအား ကြိမ်ဖန်များစွာ ဝင်ပူးခ၏။ သူ၏ခြီ၊ လက်တိကို သံကြိုးများနှင့် တုတ်နှောင်ဖမ်းချုပ် စောင့်ကြပ်ထားသော်လည်း ထိုသူသည် သံကြိုးများကို ချိုးဖြတ်ကာ တောကန္တာရသို့ ထွက်ပြီးတတ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ယေသျှုက နတ်ဆိုးအား “သင့်နာမည်က ဇာလဲ” ဟု မိန်းတော်မူလျှင်၊ “အကျွန့်နာမည် လေဂေါင်ဖြစ်ပါ၏” ဟု ပြန်လျှောက်လေ၏။ အကြောင်းမှာ ထိုသူအား နတ်ဆိုးရို့သည် ပူးကပ်နိန်သောကြောင့်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","နတ်ဆိုးရို့က “အကျွန်ရို့ကို အဆုံးမဟိသော တွင်းနက်ထဲ၌ လားဖို့ အမိန့်မပီးပါကေ့” ဟု ယေသျှုအား တောင်းပန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ထိုအရပ်၌ ဝက်အုပ်ကြီးတစ်အုပ်သည် တောင်ခါးစောင်းနားတွင် ကျက်စားလျက်ဟိ၏။ နတ်ဆိုးရို့သည် ထိုဝက်တိထဲသို့ ဝင်ပူးခွင့်ပြုရန် ယေသျှုကို တောင်းပန်ကြ၏။ ကိုယ်တော်သည်လည်း ထိုသူရို့အား အခွင့်ပီးတော်မူလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","နတ်ဆိုးရို့သည် လူမှခွါ၍ ဝက်တိထဲသို့ ဝင်ပူးကြ၏။ ထိုအခါ ဝက်တစ်အုပ်လုံးသည် အိုင်ကမ်းထောင်းစောက်သို့ တဟုန်ထိုး ဗြီးဆင်းလျက် အိုင်ထဲ၌ ရီနစ်သီဆုံးကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ဤသို့ဖြစ်ပျက်သည့် အကြောင်းအရာများကို ဝက်ထိန်းသားရို့သည် မြင်လျှင် ဗြီး၍ မြို့ရွာများသို့ လားကာ ထိုအခြင်းအရာကို ပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","လူတိကလည်း ထိုအဖြစ်အပျက်ကို ကြည့်ရန်ထွက်လာကြ၏။ ယေသျှုထံပါးသို့ ရောက်သောအခါ နတ်ဆိုး ထွက်လားသောသူသည် အဝတ်ကိုဝတ်၍ ယေသျှု၏ ခြီတော်ရင်းတွင် အကောင်းပကတိ ထိုင်နိန်သည်ကို မြင်လျှင် သူရို့အားလုံးသည် ကြောက်ရွံ့ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ထိုအရာကို မြင်သောလူတိက ထိုသူသည် မည်သို့ ပြန်ကောင်းလာကြောင်းကို အခြားလူတိအား ပြန်ပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ထိုအခါ ဂါရစနယ်မှ လူအပေါင်းရို့သည် အလွန်ကြောက်လန့်သဖြင့် မိမိရို့အရပ်မှ ထွက်လားရန် ယေသျှုအား တောင်းပန်ကြ၏။ ထိုအခါ ယေသျှုသည် လောင်းထက်သို့တက်၍ ထိုအရပ်မှ ထွက်ခွါတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","နတ်ဆိုး ထွက်လားသောသူသည် ယေသျှုအား “ကိုယ်တော်နှင့်အတူ လိုက်ခွင့်ပြုပါ” ဟု တောင်းပန်၏။ သို့သော် ယေသျှုက၊ ");
INSERT INTO rki_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“အိမ်ကို ပြန်ပြီးလျှင် ဘုရားသခင်က သင့်ကို ဇာလောက်ထိ ကျေးဇူးပြုတော်မူသည်ကို ပြောပြပါ” ဟု မိန့်တော်မူ၍ သူ့ကိုပြန်လားစီ၏။ ထိုသူသည် အထံတော်မှ ထွက်လားပြီးလျှင် ယေသျှုသည် မိမိအား မည်သို့ကျေးဇူးပြုကြောင်းကို မြို့အနှံ့ ပြောကြားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","ယေသျှု ပြန်ကြွလာတော်မူသောအခါ လူအပေါင်းရို့သည် ကမ်းတစ်ဖက်တွင် ကိုယ်တော့်ကို စောင့်မျှော်ကြလျက် ခရီးဦးကြိုပြုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","ထိုအခါ တရားဇရပ်မှူး ယာဣရုဆိုသောသူသည် ကိုယ်တော်ထံသို့ ရောက်လာ၍ ယေသျှု၏ ခြီတော်ရင်းတွင် ပြပ်ဝပ်လျက် သူ၏အိမ်သို့ ကြွတော်မူရန် ကိုယ်တော့်ကို တောင်းပန်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","အကြောင်းမှာ သူ၌ တစ်ဆယ့်နှစ်နှစ်အရွယ် တစ်ဦးတည်းသော သမီးသည် သီခါနီး ဖြစ်နိန်သောကြောင့် ဖြစ်၏။ ယေသျှုသည် သူနှင့်အတူ လိုက်လားကြသောအခါ လူအပေါင်းရို့သည် ကိုယ်တော့်ကို တိုက်မိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","တစ်ဆယ့်နှစ်နှစ်ပတ်လုံး သွီးသွန်နာ စွဲနိန်သော မိန်းမတစ်ယောက်သည် မိမိ၌ဟိသော ငွီကြေးများ အကုန်ခံပြီး ဆီးဆရာများနှင့် ကုသသော်လည်း မည်သည့်ဆီးဆရာမှ ရောဂါကို ပျောက်နိုင်စွမ်း မဟိကြ။ ");
INSERT INTO rki_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ထိုမိန်းမသည် ယေသျှု၏ နောက်တော်သို့ ချဉ်းကပ်၍ ကိုယ်တော်၏ ဝတ်ရုံပန်းဖွားတော်ကို တို့လေ၏။ ထိုခဏချင်းတွင် သွီးသွန်နာ ပျောက်ကင်းလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ယေသျှုကလည်း၊ “ငါ့ကို ဇာသူ တို့သနည်း” ဟု မိန်းတော်မူလျှင်၊ လူအပေါင်းရို့သည် ငြင်းလတ်သော်၊ ပေတရုက “သခင်၊ လူတိက သခင့်ကို ဝိုင်းရံ နိန်ကြပါလျက်နှင့် ‘ငါ့ကို ဇာသူ တို့သနည်း’ ဟု မိန့်တော်မူပါသည်တကား” ဟုလျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","သို့သော်လည်း ယေသျှုက “တစ်ယောက်ယောက်က ငါ့ကို တို့၏။ ငါ့ကိုယ်က တန်ခိုးထွက်လားသည်ကို ငါသိရ၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ထိုမိန်းမသည် မိမိပြုခသည့်အမှုကို ဖုံးကွယ်ထား၍ မရကြောင်း သိလာသောအခါ တုန်လှုပ်လျက် ရှိ့တော်သို့လာပြီး ပျပ်ဝပ်ကာ ယေသျှုအား တို့ထိရသည့်အကြောင်းကိုလည်းကောင်း၊ ချက်ချင်းပင် မိမိ၏ရောဂါ ပျောက်ကင်းကြောင်းကိုလည်းကောင်း လူအပေါင်းရို့၏ရှိ့တွင် လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ယေသျှုကလည်း၊ “ငါ့သမီး၊ သင်၏ ယုံကြည်ခြင်းသည် သင့်ကို ကျန်းမာစီဗျာယ်၊ ငြိမ်ဝပ်စွာလားလော” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","ထိုသို့ ကိုယ်တော်မိန့်တော်မူစဉ် တရားဇရပ်မှူးအိမ်မှ လူတစ်ယောက်လာ၍ “သခင်၏သမီး သီဗျာယ်၊ ဆရာကို မနှောင့်ယှက်ကေ့ဖိ” ဟု ယာဣရုအား ပြော၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ထိုစကားကို ယေသျှုကြားတော်မူလျှင် ယာကုရုအား၊ “မစိုးရိမ်ကေ့၊ ယုံကြည်ခြင်း တစ်ခုရာ ဟိလော၊ သူငယ်မချေ ကျန်းမာလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","တရားဇရပ်မှူးအိမ်သို့ ရောက်သောအခါ ပေတရု၊ ယောဟန်၊ ယာကုပ်နှင့် သူငယ်မ၏ မိဖနှစ်ပါးမှတစ်ပါး မည်သူ့ကိုမျှ မိမိနှင့်အတူ ဝင်စီတော်မမူ။ ");
INSERT INTO rki_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","သူငယ်မချေ သီဆုံးသည့်အတွက် လူတိုင်းသည် ငိုကြွီးမြည်တမ်းလျက် ဟိကြ၏။ ယေသျှုက “မငိုကတ်ကေ့၊ သူငယ်မချေ သီစွာ မဟုတ်၊ အိပ်ပျော် နိန်ခြင်းသာဖြစ်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","ထိုအခါ သူရို့သည် သူငယ်မချေ သီဆုံးပြီးကြောင်းကို သိကြသည်ဖြစ်၍ ကိုယ်တော့်ကို လှောင်ပြောင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","သို့သော် ယေသျှုသည် သူငယ်မ၏လက်ကို ဆုပ်ကိုင်ကာ “ကလိန့်မေချေ၊ ထလော့” ဟု ခေါ်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","သူငယ်မသည် အသက်ပြန်ရှင်လာ၍ ချက်ခြင်းပင် ပြန်ထလေ၏။ ယေသျှုသည် သူငယ်မအား အစားအစာကျွေးမွေးရန် မိန့်မှာတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","မိဖရို့သည် များစွာအံ့သြကြ၏။ ယေသျှုက ဤအဖြစ်အပျက်ကို မည်သူ့ကိုမျှ မပြောစီရန် သူရို့အား ပညတ်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","ယေသျှုသည် တပည့်တော် တစ်ဆယ့်နှစ်ပါးကို ခေါ်တော်မူပြီးလျှင် နတ်ဆိုးအပေါင်းကို နှင်ထုတ်ရန်နှင့် အနာရောဂါများကို ပျောက်ကင်းစီနိုင်သော တန်ခိုးအာဏာကို ပီးအပ်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ထို့နောက် ကိုယ်တော်သည် သူရို့အား ဘုရားသခင်၏ နိုင်ငံတော်အကြောင်းကို ဟောပြောရန်နှင့် ဖျားနာသူများကို ကျန်းမာစီရန် ရွှတ်တော်မူပြီးလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ထိုသူရို့အား “လမ်းခရီးအတွက် သင်ရို့သည် ဇာတစ်ခုကိုလည်း မယူကေ့။ တောင်မွိ့၊ လွယ်အိတ်၊ စားစရာ၊ ဖေသာဒင်္ဂါးတိကို မယူကေ့။ အင်္ကျီတစ်လုံးတောင် အပိုမပါကတ်ကေ့။” ");
INSERT INTO rki_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","“ဇာအိမ်ကမဆို သင်ရို့ကို လက်ခံလို့ဟိကေ ထိုမြို့က ထွက်လားသောအချိန်ထိ ထိုအိမ်၌ တည်းနိန်ပါ။” ");
INSERT INTO rki_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","“သင်ရို့ကို လက်မခံသော လူတိကို သတိပီးသည့်အနိန်နန့် ထိုမြို့ကနိန် ထွက်လားသောအချိန်၌ သင့်ခြီဖဝါးမှ ခြီမှုန့်ကို ခါချပစ်ခလော့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","တပည့်တော်ရို့သည်လည်း ထွက်လားပြီးလျှင် အနယ်နယ်အရပ်ရပ်သို့ လှည့်လည်လျက် သတင်းကောင်းကို ဟောပြောပြီး နီရာတိုင်း၌ လူတိ အနာရောဂါများကို ပျောက်ကင်းစီကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ဂါလိလဲနယ်စား ဟေရုဒ်သည် ထိုဖြစ်ပျက်နိန်သော အမှုအရာ အားလုံးကို ကြားသောအခါ အလွန် စိတ်မွိ့လျက်ဟိ၏။ အကြောင်းမှာ လူတချို့က ဗတ္တိဇံယောဟန် “သီရာမှ ပြန်ရှင်လာဗျာယ်” ဟု ပြောဆိုသောကြောင့် လည်းကောင်း၊ ");
INSERT INTO rki_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","လူတချို့က “ဧလိယ ပေါ်ထွန်းလာဗျာယ်” ဟူ၍ လည်းကောင်း၊ တချို့က ရှိ့ပရောဖက်တစ်ပါးပါး “အသက် ပြန်ရှင်လာဗျာယ်” ဟူ၍ လည်းကောင်း ပြောဆိုကြသောကြောင့် ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ဟေရုဒ်ကလည်း “ယောဟန်ဂေါင်းကို ငါဖြတ်ခပြီးဗျာယ်။ သို့သော်လည်း ငါသတင်းကြားရသော ဤသူကား ဇာသူလဲ” ဟု ပြောဆိုပြီး ယေသျှုကို တွိ့မြင်ခြင်းငှာ ကြိုးစားလျက် နိန်၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","တမန်တော်ရို့သည် ယေသျှုထံသို့ ပြန်လာကြပြီးလျှင် မိမိရို့ လုပ်ဆောင်သမျှကို ပြန်ပြောကြ၏။ ကိုယ်တော်သည် သူရို့ကိုခေါ်၍ ဗက်ဇဲဒဟုခေါ်သော မြို့သို့ ကြွတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","လူထုပရိသတ်ရို့သည် ကိုယ်တော် ကြွလားကြောင်းကို ကြားကြသောအခါ နောက်တော်သို့ လိုက်ကြ၏။ ကိုယ်တော်သည် သူရို့ကို လက်ခံကြိုဆိုလျက် ဘုရားသခင်၏ နိုင်ငံတော်အကြောင်းကို ဟောပြောပြီးလျှင် မကျန်းမာသောသူတိကိုလည်း ကျန်းမာစီတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","နီဝင်စပြုသောအခါ တပည့်တော် တစ်ဆယ့်နှစ်ပါးသည် ကိုယ်တော်ထံသို့ လာ၍ “ဤလူတိကို ပတ်ဝန်းကျင်၌ဟိသော ကျေးရွာဇာနပုဒ်များနှင့် ယာတောများသို့လားပြီး တည်းခိုဖို့နီရာနှင့် အစားအစာကို ရှာစီပါ။ ဇာကြောင့်ဆိုသော် ဤနီရာသည် လူသူဝီးသောအရပ် ဖြစ်ပါ၏” ဟု လျှောက်ထားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","သို့သော် ယေသျှုကလည်း “သူရို့ စားစရာဖို့ သင်ရို့ကိုယ်တိုင် ပီးလော့” ဟု မိန့်တော်မူ၏။ သူရို့က “အကျွန်ရို့က ဤလူတိအတွက် စားစရာကို လားပြီး ဝယ်ရပါမည်လော။ အကျွန်ရို့၌ မုန့်ငါးလုံးနှင့် ငါးနှစ်ကောင်ရာ ဟိပါ၏” ဟု ပြန်လည် လျှောက်ထားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(ထိုသို့ လျှောက်ထားရခြင်းမှာ ထိုနီရာ၌ လူကြီး အယောက် ၅,၀၀၀ ခန့် ဟိသောကြောင့်ဖြစ်၏။) ယေသျှုက “ဤလူတိကို လူငါးဆယ်ခန့်စီ အစုလိုက် ထိုင်စီလော့” ဟု တပည့်တော်ရို့အား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","တပည့်တော်ရို့သည် ကိုယ်တော် မိန့်တော်မူသည့်အတိုင်း ဆောင်ရွက်ကြပြီးနောက်၊ ");
INSERT INTO rki_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ကိုယ်တော်သည် မုန့်ငါးလုံးနှင့် ငါးနှစ်ကောင်ကို ယူတော်မူကာ ကောင်းကင်သို့ မျှော်ကြည့်လျက် ဘုရားသခင်၏ ကျေးဇူးတော်ကို ချီးမွမ်းတော်မူပြီးမှ မုန့်နှင့်ငါးကို ဖဲ့တော်မူ၍ လူတိအား ဝီငှစီခြင်းငှာ တပည့်တော်ရို့အား ပီးအပ်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","သူရို့အားလုံးသည် ဝစွာစားကြပြီးနောက် တပည့်တော်ရို့သည် စားကြွင်းများကို စုသိမ်းရာ တောင်းတစ်ဆယ့်နှစ်တောင်း အပြည့်ရ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","တစ်နိ့သောခါ ယေသျှုသည် လုံးချင်းတည်း ဆုတောင်းလျက်နိန်သောအခါ တပည့်တော်ရို့သည် ကိုယ်တော်ထံပါးသို့ လာကြ၏။ “လူတိက ငါ့ကို ဇာသူလို့ ပြောကြသနည်း” ဟု ကိုယ်တော်က မိန်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","တပည့်တော်ရို့ကလည်း “တချို့က ဗတ္တိဇံယောဟန်ဖြစ်သည်ဟု ဆိုကြပါ၏။ တချို့က ဧလိယဟု ဆိုပါ၏။ တချို့က ရှီးပရောဖက်တစ်ပါး အသက်ပြန်ရှင်လာခြင်းဖြစ်သည်ဟု ပြောဆိုကြပါ၏” ဟု လျှောက်ထားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ထိုအခါ ကိုယ်တော်က “သင်ရို့က ငါ့ကို ဇာသူလို့ ဆိုကြမည်နည်း” ဟု မိန်းတော်မူလျှင်၊ ပေတရုက “ကိုယ်တော်သည် ဘုရားသခင်၏ မေသျှိယဖြစ်ပါ၏” ဟု လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","ယေသျှုကလည်း ဤအကြောင်းကို ဇာသူ့ကိုမှ မပြောမိစီရန် ကြပ်တည်းစွာ ပညတ်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ကိုယ်တော်က “လူသားသည် ဒုက္ခဝေဒနာတိကို ပြင်းစွာခံရမည်။ အသက်ကြီးသောသူတိ၊ ယဇ်ပုရောဟိတ် အကြီးအကဲတိနှင့် ကျမ်းတတ်ဆရာတိက ငြင်းပယ်ကြလိမ့်မည်။ လူသားသည် အသီခံရမည်။ သို့သော်လည်း သုံးရက်မြောက်သော နိ့၌ ရှင်ပြန်ထမြောက်လိမ့်မည်” ဟု တပည့်တော်ရို့အား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ထို့နောက် ကိုယ်တော်က ထိုသူရို့အား၊ “ငါ့နောက်ကို လိုက်လိုသောသူသည် ကိုယ့်ကိုကိုယ် ငြင်းပယ်ရမည်၊ ကိုယ့်လက်ဝါးကပ်တိုင်ကို နိ့တိုင်းထမ်း၍ ငါ့နောက်သို့ လိုက်ရမည်။ ");
INSERT INTO rki_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","အကြောင်းမူကား မိမိအသက်ကို ကယ်တင်လိုသူသည် အသက်ဆုံးယှုံးလိမ့်မည်။ ငါ့ကြောင့် အသက်ဆုံးယှုံးသူသည် မိမိအသက်ကို ကယ်တင်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","လူသည် လောကတစ်ခုလုံးကို ပိုင်ဆိုင်ခွင့်ရသော်လည်း မိမိအသက်ဆုံးယှုံးလျှင် ဇာအကျိုး ဟိမည်နည်း။ ");
INSERT INTO rki_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","အကြင်သူသည် ငါနန့် ငါ၏ တရားစကားကြောင့် ရှက်လျှင် လူသားသည် မိမိ၏ ဘုန်းတန်ခိုးတော်၊ ခမည်းတော်၏ ဘုန်းတန်ခိုးတော်၊ သန့်ယှင်းသော ကောင်းကင်တမန်ရို့၏ ဘုန်းတန်ခိုးကိုဆောင်ပြီး ကြွလာသောအခါ ထိုသူကို ရှက်တော်မူလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","ငါအမှန်ဆိုသည်ကား၊ ဤအရပ်၌ဟိသော လူတချို့သည် ဘုရားသခင်၏ နိုင်ငံတော်ကို မမြင်ရခင် မသီရ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ဤသို့ မိန့်တော်မူပြီးနောက် သျှစ်ရက်ခန့် ကြာသောအခါ ယေသျှုသည် ပေတရု၊ ယောဟန်၊ ယာကုပ်ရို့ကို ခေါ်၍ ဆုတောင်းခြင်းငှာ တောင်ထက်သို့ တက်ကြွတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ဆုတောင်းတော်မူစဉ် မျက်နှာတော်၏ အဆင်းသဏ္ဌာန်သည် ပြောင်းလဲလာ၍ အဝတ်တော်သည်လည်း ဖြူဖွေးတောက်ပလာ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","လူနှစ်ဦးသည် ရုတ်တရက်ပေါ်လာ၍ ကိုယ်တော်နှင့် စကားပြောလျက် နိန်၏။ ထိုသူရို့ကား မောသျှေနှင့် ဧလိယပင်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","သူရို့သည် ဘုန်းတန်ခိုးတော်နှင့်တကွ ပေါ်လာ၍ ဘုရားသခင်၏ အလိုတော်နှင့်အညီ မကြာမီ ယေရုဆလင်မြို့၌ အသက်တော် စွန့်ရမည့်အကြောင်းကို ယေသျှုနှင့် ပြောနိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ပေတရုနှင့် အဖော်များသည် ငိုက်မျဉ်းလျက် နိန်ကြ၏။ သို့ရာတွင် သူရို့ နိုးလာသောအခါ ယေသျှုသည် ဘုန်းတန်ခိုးတော်နှင့် လည်းကောင်း၊ ကိုယ်တော်နှင့်အတူ ရပ်နိန်သူနှစ်ဦးကိုလည်းကောင်း မြင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ထိုသူနှစ်ဦးရို့သည် ယေသျှုထံမှ ထွက်ခွါလားကြစဉ် ပေတရုက “သခင်၊ ဤနီရာ၌ နီစရာကောင်းပါ၏။ ကိုယ်တော်အတွက် တဲတစ်ဆောင်၊ မောသျှေအတွက် တဲတစ်ဆောင်၊ ဧလိယအတွက် တဲတစ်ဆောင်၊ တဲသုံးဆောင်ကို အကျွန်ရို့ ဆောက်ပီးပါမည်။” ဟု (ပြောမိပြောရာ ပြောသည်) လျှောက်ထား၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ဤသို့ လျှောက်ထားစဉ် မိုးတိမ်တိုက်တစ်ခုသည် ပေါ်လာ၍ သူရို့အထက်၌ တိမ်ရိပ် အုပ်မိုးလေ၏။ မိုးတိမ်တိုက်သည် သူရို့အထက်သို့ ရောက်လာသောအခါ သူရို့သည် ကြောက်လန့်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","မိုးတိမ်ထဲမှ အသံတော်ကား “ဤသူသည် ငါရွီးချယ်ထားသော ငါ့၏သား ဖြစ်၏၊ သူ၏စကားကို နားထောင်ကြလော့” ဟု ထွက်ပေါ်လာ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","အသံတော် တိတ်လားသောအခါ ထိုနီရာ၌ ယေသျှုတစ်ပါးတည်းကိုသာ တွိ့ရ၏။ ထိုနိ့ရက်ကာလ၌ တပည့်တော်ရို့သည် မိမိရို့ မြင်တွိ့ရသော အကြောင်းအရာများကို ဇာသူကိုမှမပြောဘဲ တိတ်ဆိတ်စွာနိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","နောက်တစ်နိ့၌ ယေသျှုနှင့် တပည့်တော်သုံးဦးရို့သည် တောင်ပေါ်မှဆင်းလာကြသောအခါ များစွာသော လူထုပရိသတ်ရို့သည် ကိုယ်တော့်ကို ခရီးဦးကြိုပြုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ပရိသတ်ထဲမှ လူတစ်ယောက်က “ဆရာ၊ အကျွန်၏ တစ်ဦးတည်းသောသားကို ကြည့်ရှုတော်မူပါ၊ တောင်းပန်ပါ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","နတ်ဝင်ပူးလို့ ရုတ်တရက် အော်ဟစ်တတ်ပါ၏။ နတ်က သူ့ကိုလှဲချ၍ မာတောင့်စီပြီးလျှင် ပါးစပ်မှအမြှုပ် ထွက်လာပါ၏။ နတ်ဆိုးက သူ့ကို နာကြင်အောင် နှိပ်စက်ပြီး ထွက်လားပါ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","အကျွန်ကလည်း ကိုယ်တော်၏တပည့်တော်တိကို နှင်ထုတ်ပီးဖို့ တောင်းပန်သော်လည်း သူရို့ မတတ် နိုင်ကြပါ” ဟု အော်၍ လျှောက်ထား၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ယေသျှုက “ယုံကြည်ခြင်းမဟိ၊ ဖောက်ပြန်တတ်သောလူတိ၊ ငါသည် သင်ရို့နှင့်အတူ ဇာအချိန်ထိကြာအောင် နီရမည်နည်း။ ဇာလောက်ထိ သည်းခံရမည်နည်း” ဟု မိန့်တော်မူ၏။ ထို့နောက် ထိုသူအား “သင်၏သားကို မ၍ ဤနီရာသို့ ယူလာလော့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ထိုလူငယ် လာစဉ်မှာပင် နတ်ဆိုးသည်သူ့အား မြီကြီးထက်၌လှဲချပြီး မာတောင့်စီ၏။ ယေသျှုသည် နတ်ဆိုးအား အမိန့်ပီး၍ လူငယ်ကို ကျန်းမာစီတော်မူပြီးနောက် ဖခင်အား ပြန်လည် အပ်ပီးတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","လူအပေါင်းရို့သည် ဘုရားသခင်၏ မဟာတန်ခိုးတော်ကို မြင်ရ၍ အံ့သြကြကုန်၏။ လူရို့သည် ယေသျှုပြုတော်မူခသော အမှုအရာများကြောင့် အံ့သြနိန်ကြစဉ်၊ ကိုယ်တော်က၊ ");
INSERT INTO rki_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“ငါပြောသော အကြောင်းကို သင်ရို့ ဂရုတစိုက် နားထောင်ကြလော့။ လူသားသည် လူတိလက်သို့ အပ်နှံခြင်းကို ခံရလိမ့်မည်” ဟု တပည့်တော်ရို့အား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","သို့ရာတွင် တပည့်တော်ရို့သည် ထိုစကားအဓိပ္ပာယ်ကို မသိကြ။ ထိုသို့ သူရို့သည် နားမလည်ကြစီရန် ထိုအရာတိကို ကွယ်ဝှက်ထားလျက်ဟိ၏။ သူရို့သည်လည်း ကိုယ်တော့်ကို မိန်းလျှောက်ရန်လည်း ကြောက်ရွံ့ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","ထိုအခါ တပည့်တော်ရို့သည် မိမိရို့ထဲတွင် ဇာသူသည် အကြီးမြတ်ဆုံးနည်း ဟု အချင်းချင်း ငြင်းခုန် ပြောဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ယေသျှုသည် ထိုသို့ ငြင်းခုန် နိန်ကြသည်ကို သိတော်မူသဖြင့် သူငယ်တစ်ယောက်ကိုယူ၍ မိမိဘေးနားတွင် ရပ်စီတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ထို့နောက် ကိုယ်တော်က သူရို့အား “ငါ၏နာမကိုထောက်၍ ဤအချေ တစ်ယောက်ကို လက်ခံသောသူသည် ငါ့ကို လက်ခံခြင်းဖြစ်၏။ ငါ့ကို လက်ခံသောသူသည် ငါ့ကို စီရွှတ်တော်မူသော အသျှင်ကို လက်ခံခြင်းဖြစ်၏။ အကြောင်းမူကား သင်ရို့တွင် အငယ်ဆုံးသောသူသည် အကြီးမြတ်ဆုံးသောသူဖြစ်သည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ယောဟန်က “သခင်၊ ကိုယ်တော်၏နာမကို အမှီပြု၍ နတ်ဆိုးတိကို နှင်ထုတ်နိန်သော လူတစ်ယေက်ကို အကျွန်ရို့ တွိ့မြင်ခပါ၏။ ထိုသူသည် အကျွန်ရို့အဖွဲ့ဝင် မဟုတ်သောကြောင့် အကျွန်ရို့သည် ထိုသူအား တားမြစ်ခပါသည်” လျှောက်ထား၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ယေသျှုကလည်း “ထိုသူကို မတားမြစ်ကတ်ကေ့၊ သင်ရို့ကို မဆန့်ကျင်သောသူသည် သင်ရို့ဖက်သားဖြစ်၏” ဟု ယောဟန်အား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","ကောင်းကင်ဘုံသို့ ဆောင်ယူခြင်းကို ခံတော်မူမည့်အချိန် နီးလာသောအခါ ယေသျှုသည် ယေရုဆလင်မြို့သို့ ကြွတော်မူရန် စိတ်ပိုင်းဖြတ်တော်မူလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ထိုအခါ ကိုယ်တော်သည် စီတမန်များကို မိမိအဖို့ အဆင်သင့်ဖြစ်စီခြင်းငှာ ယှာမာရိနယ်၏ ရွာတစ်ရွာသို့ ကြိုတင် ရွှတ်လိုက်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","သို့သော်လည်း ရွာသားရို့သည် လက်မခံကြ။ အကြောင်းမူကား ကိုယ်တော်သည် ယေရုဆလင်မြို့သို့ ဦးတည်လျက် ခရီးပြုနိန်သောကြောင့်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ဤအချင်းအရာများကို တပည့်တော်များဖြစ်ကြသော ယာကုပ်နှင့် ယောဟန်သည် မြင်ကြသောအခါ “သခင်ဘုရား၊ အကျွန်ရို့သည် ကောင်းကင်က မီးကျစီ၍ ယင်းသူရို့ကို လောင်ကျွမ်းစီဖို့ အလိုတော်ဟိပါ၏လော” ဟု လျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","သို့သော် ကိုယ်တော်သည် လှည့်၍ သူရို့အား ဆုံးမတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ထို့နောက် ယေသျှုနှင့် တပည့်တော်ရို့သည် အခြားရွာသို့ ထွက်လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ထိုသို့ သူရို့သည် ခရီးပြုနိန်ကြစဉ် လူတစ်ယောက်က “အကျွန်သည်၊ ကိုယ်တော်ကြွတော်မူရာ အရပ်ရပ်သို့ လိုက်ပါမည်” ဟု ကိုယ်တော့်ကို လျှောက်ထား၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ယေသျှုက “မြီခွီးမှာ တွင်းဟိ၏။ ငှက်မှာလဲ အသိုက်ဟိ၏။ သို့သော် လူသားမှာကား ဂေါင်းချစရာ နီရာတောင်မဟိ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ကိုယ်တော်သည် အခြားလူတစ်ယောက်အား “ငါ့နောက်သို့လိုက်လော့” ဟု မိန့်တော်မူ၏။ သို့သော်လည်း ထိုသူက “အသျှင်၊ အကျွန့်အဖ၏အလောင်းကို အယင် လား၍ သင်္ဂြိုဟ်ခွင့် ပီးတော်မူပါ” ဟု လျှောက်၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ယေသျှုကလည်း “လူသီရို့က မိမိရို့လူသီအား သင်္ဂြိုဟ်ကတ်ပါစီ၊ သင်မူကား လား၍ ဘုရားသခင်၏ နိုင်ငံတော်အကြောင်းကို ဟောပြောလော့” ဟု ထိုသူအား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","အခြားသောသူတစ်ယောက်က “အသျှင်၊ အကျွန်သည် ကိုယ်တော့်နောက်သို့ လိုက်ပါမည်။ သို့သော် အကျွန်၏ အိမ်သူအိမ်သားတိကို လား၍ ဦးစွာ နှုတ်ဆက်ခွင့် ပြုတော်မူပါ” ဟု လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ယေသျှုကလည်း “ထွန်ကိုင်းကိုကိုင်လျက် နောက်လှည့်ကြည့်သောသူသည် ဘုရားသခင်၏ နိုင်ငံတော်အတွက် အသုံးမဝင်” ဟု ပြန်၍ မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ထို့နောက် သခင်ဘုရားသည် အခြားသောတပည့်တော် ၇၂ ဦး ကို ရွီးခြယ်၍ နှစ်ယောက်တစ်တွဲစီတွဲလျက် ကိုယ်တော် ကြွတော်မူမည့် မြို့ရွာအသီးသီးသို့ မိမိ ရှိ့က စီရွှတ်လိုက်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ကိုယ်တော်က သူရို့အား “ရိတ်စရာစပါး များစွာဟိ၏။ သို့သော် ရိတ်သိမ်းသောသူ နည်း၏။ စပါးရိတ်သူတိကို စပါးခင်းထဲသို့ စီရွှတ်နိုင်ရန် စပါးပိုင်သျှင်ထံ ဆုတောင်းကြလော့။ ");
INSERT INTO rki_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","လားကတ်၊ တောခွီးစုထဲသို့ သိုးသငယ်များကို စီရွှတ်သည့်နည်းတူ သင်ရို့ကို ငါ ရွှတ်လိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ဖဲသာအိတ်၊ လွယ်အိတ်၊ ခြီနင်းတိကို ယူမလားကတ်ကေ့။ လမ်းမာရပ်ပြီး တစ်ယောက်ကိုလေ့ နှုတ်မဆက်ကတ်ကေ့။ ");
INSERT INTO rki_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","သင်ရို့သည် အိမ်တစ်အိမ်သို့ ဝင်သောအခါ၌ ‘ဤအိမ်၌ ငြိမ်သက်ခြင်းဟိပါစီ’ ဟု ဦးစွာ မေတ္တာပို့ကြလော့။ ");
INSERT INTO rki_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","ထိုအိမ်၌ ငြိမ်သက်ခြင်းကို လိုလားသူဟိလျှင်၊ သင်ရို့ ပို့သသည့် မေတ္တာကို ခံစားရလိမ့်မည်။ ထိုကဲ့သို့သောသူ တစ်ယောက်မှ မဟိလျှင် သင်ရို့ပို့သသော မေတ္တာသည် ပြန်လာလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","သင်ရို့သည် သူရို့ကျွေးမွေးသော အစာကို စားသောက်လျက် ထိုအိမ်၌ တည်းခိုနိန်ကြလော့၊ ဇာကြောင့်ဆိုသော် အလုပ်သမားများသည် မိမိရို့၏လုပ်ခကို ခံစားထိုက်၏။ တစ်အိမ်မှ အခြားတစ်အိမ်သို့ လှည့်လည်၍ မလားကတ်ကေ့။ ");
INSERT INTO rki_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","မြို့တစ်မြို့သို့ ဝင်သောအခါ သင်ရို့အား ကြိုဆိုပြီး ကျွေးမွေးသောအရာတိကို စားကြလော့။ ");
INSERT INTO rki_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ထိုမြို့၌ဟိသော လူမမာတိကို ကျန်းမာစီပြီးလျှင် ထိုအရပ်၌ဟိသော လူရို့အား ဘုရားသခင်၏ နိုင်ငံတော်တည်ချိန် နီးပြီဖြစ်ကြောင်း ဟောပြောကြလော့။ ");
INSERT INTO rki_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","သို့သော် သင်ရို့သည် မြို့တစ်မြို့သို့ ဝင်၍ ကြိုဆို လက်ခံခြင်းမဟိလျှင် လမ်းတိ၌ ထွက်ပြီးလျှင် ဤသို့ ပြောလော့။ ");
INSERT INTO rki_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘ငါရို့သည် သင်ရို့ကို ဆန့်ကျင်သည့်အနေဖြင့် ငါရို့ခြီမှာ ကပ်ပါလာသော သင်ရို့မြို့က မြီမှုန့်ကို ငါရို့ ခါချလိုက်ဗျာယ်။ ယေဒါလေ့ ဘုရားသခင်၏ နိုင်ငံတော်သည် သင်ရို့အနားတွင် ရောက်နိန်ပြီးဖြစ်ကြောင်းကို သိမှတ်ကြလော့။’ ");
INSERT INTO rki_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","သင်ရို့အား ငါ အမှန်ဆိုသည်ကား၊ တရားစီရင်တော်မူရာနိ့၌ ဘုရားသခင်သည် ထိုမြို့ထက် သောဒုံမြို့ကို ပို၍ ကရုဏာထားတော်မူလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“အို၊ ခေါရာဇိန်မြို့၊ သင်သည် အမင်္ဂလာဟိ၏။ အို၊ ဗက်ဇဲဒမြို့၊ သင်သည်လည်း အမင်္ဂလာဟိ၏။ သင်ရို့ထံ၌ ပြုခသော အံ့ဖွယ်အမှုအရာတိကို တုရုမြို့နှင့် ဇိဒုန်မြို့၌သာ ပြုခပါမူ သူရို့သည် ရှီးပဝေသဏီကပင် လျှော်တေအဝတ်ကို ဝတ်ပြီး ပြာပုံ၌ ထိုင်၍ နောင်တရကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","ဘုရားသခင်သည် တရားစီရင်တော်မူရာကာလ၌ သင်ရို့ထက် တုရုမြို့နှင့် ဇိဒုန်မြို့ကို ပို၍ ကရုဏာထားတော်မူလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","အို၊ ကပေရနောင်မြို့၊ သင်သည် ကိုယ့်ကိုကိုယ် ကောင်းကင်ဘုံထိ ချီးမြှောက်ခြင်းကို ခံလိုသလော။ မရဏာနိုင်ငံထိ နှိမ့်ချခြင်းကို ခံရလိမ့်မည်။” ");
INSERT INTO rki_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ယေသျှုသည် တပည့်တော်ရို့အား၊ “သင်ရို့၏စကားကို နားထောင်သောသူသည် ငါ့စကားကို နားထောင်သူဖြစ်၏။ သင်ရို့ကို ငြင်းပယ်သူသည် ငါ့ကို ငြင်းပယ်သူဖြစ်၏။ ငါ့ကို ငြင်းပယ်သောသူသည်လည်း ငါ့ကို ရွှတ်လိုက်တော်မူသောသူကို ငြင်းပယ်သူဖြစ်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","တပည့်တော် ၇၂ ဦး ရို့သည် အလွန်ဝမ်းမြောက်စွာ ပြန်လာပြီးလျှင် “အသျှင်၊ ကိုယ်တော်၏ နာမတော်၌ နတ်ဆိုးတိပင် အကျွန်ရို့ကို နာခံကြပါ၏” ဟု လျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ယေသျှုကလည်း “ကောင်းကင်က လျှပ်စစ်ကျသကဲ့သို့ စာတန် ကျလာစွာကို ငါ မြင်ရ၏။ ");
INSERT INTO rki_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","နားထောင်ကတ်၊ မြွီဆိုးတိ၊ ကင်းမီးကောက်တိကို နင်းလားနိုင်ခြင်းငှာ လည်းကောင်း၊ ရန်သူ၏တန်ခိုးအားလုံးကို အောင်နိုင်ခြင်းငှာလည်းကောင်း အခွင့်အာဏာကို သင်ရို့အား ငါ ပီးအပ်ထားပြီးဖြစ်၏။ သို့ဖြစ်၍ သင်ရို့အား ဇာအရာကလည်း နာကြင်အောင် မလုပ်နိုင်။ ");
INSERT INTO rki_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","သို့သော် ဝိညာဉ်ဆိုးရို့သည် သင်ရို့ကို နာခံကြသောကြောင့် ဝမ်းမသာကတ်ကေ့။ သင်ရို့နာမည်များသည် ကောင်းကင်၌ စာရင်းဝင်ရသည်ကို ဝမ်းမြောက်ကြလော့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","ထိုအချိန်၌ ယေသျှုသည် သန့်ယှင်းသော ဝိညာဉ်တော်အားဖြင့် ရွှင်လန်းဝမ်းမြောက်တော်မူသည်ဖြစ်၍ “ကောင်းကင် မြီကြီး၏အသျှင် ဖြစ်တော်မူသော အဖ၊ ကိုယ်တော်သည် ပညာဟိသူနှင့် ပညာတတ်သူတိကို ထိမ်ဝှက်ထားသော အရာတိကို ပညာမဲ့သူရို့အား ဖော်ပြပီးသည့်အတွက် ကိုယ်တော့်ကို ကျေးဇူးတင်ပါ၏။ မှန်ပါ၏၊ အဖ၊ ဤအရာသည်ကား ကိုယ်တော်၏ ကောင်းမြတ်သော အလိုတော် ဖြစ်ပါ၏” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“ငါ၏အဖသည် အရာအားလုံးကို ငါ့အား ပီးအပ်တော်မူပြီ။ သားတော်သည် ဇာသူဖြစ်ကြောင်းကို ခမည်းတော်မှတစ်ပါး တစ်ယောက်လေ့ မသိ။ ခမည်းတော်သည် ဇာသူဖြစ်ကြောင်းကိုလည်း သားတော်နှင့် သားတော် ဖော်ပြလိုသောသူမှလွဲ၍ တစ်ယောက်လေ့ မသိ” ဟု မြွက်ဆိုတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ထို့နောက် ကိုယ်တော်သည် တပည့်တော်တိဖက်သို့ လှည့်၍ “အဂု မြင်သမျှသောအရာများကို မြင်ရသော သင်ရို့၏ မျက်စိများသည် မင်္ဂလာဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","အကြောင်းမူကား ပရောဖက်တိနှင့် သျှင်ဘုရင်တိက သင်ရို့ မြင်သောအရာတိကို မြင်ချင်ခသော်လည်း၊ မမြင်ခရ။ သင်ရို့ ကြားရသည့်အရာတိကို ကြားချင်ခသော်လည်း မကြားခရဟု သင်ရို့ကို ငါ ဆို၏။” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ကျမ်းတတ်ဆရာတစ်ယောက်သည် ရောက်လာပြီးလျှင် ယေသျှုကို စုံစမ်းခြင်းငှာ ကြိုးစားလေ၏။ သူက “ဆရာ၊ ထာဝရအသက်ကို ရရန်အတွက် အကျွန် ဇာလုပ်ရပါဖို့လဲ” ဟု မိန်း၏။ ");
INSERT INTO rki_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ယေသျှုက “မောသျှေ၏ ပညတ္တိကျမ်း၌ ဇာပိုင် ဖော်ပြထားသလဲ၊ သင်သည် ထိုကျမ်းစာတိကို ဇာပိုင် အဓိပ္ပာယ်ကောက်ယူလဲ” ဟု သူ့အား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ထိုသူက “‘သင်၏ဘုရားသခင် ထာဝရဘုရားကို စိတ်နှလုံးအကြွင်းမဲ့၊ စိတ်ဝိညာဉ်ဟိသမျှ၊ အစွမ်းသတ္တိဟိသမျှ၊ ဉာဏ်ဟိသမျှနှင့် ချစ်လော့၊’ ပြီးလျှင် ‘ကိုယ်​နှင့်​စပ်​ဆိုင်​သော​သူ​ကို ကိုယ်​နှင့်​အ​မျှ ချစ်​လော့’ ” ဟု လျှောက်၏။ ");
INSERT INTO rki_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ယေသျှုကလည်း “သင်၏ အဖြေမှန်၏။ ထိုသို့ပြုလျှင် သင်သည် အသက်ရှင်လိမ့်မည်” ဟု ပြန်ပြောတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","သို့သော် ကျမ်းတတ်ဆရာသည် မိမိကိုယ်ကို သူတော်ကောင်းဖြစ်ကြောင်း ဖော်ပြလိုသဖြင့် “ဇာသူသည် ကိုယ်​နှင့်​စပ်​ဆိုင်​သော​သူ ဖြစ်ပါသလဲ” ဟု မိန်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ယေသျှုက “လူတစ်ယောက်သည် ယေရုဆလင်မြို့မှ ယေရခေါမြို့သို့ လားသည့်လမ်း၌ ဒါးပြတိုက်ခံရ၏။ ထိုဓါးပြတိက သူ၏အဝတ်အစားများကို ချွတ်ယူ၍ သူ့ကို သတ်ပုတ်ပြီးလျှင် သီခါနီးမှ ပစ်ထားခ၏။ ");
INSERT INTO rki_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ယဇ်ပုရောဟိတ်တစ်ဦးသည် ထိုလမ်းအတိုင်း လာသောအခါ ထိုသူကို မြင်သော်လည်း အခြားတစ်ဖက်မှ လားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ထိုနည်းတူ လေဝိအမျိုးသားတစ်ယောက်သည်လည်း ယင်းလမ်းအတိုင်းလာ၍ ထိုသူကို မြင်သောအခါ အခြားတစ်ဖက်မှ ကျော်လားခပြန်၏။ ");
INSERT INTO rki_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","သို့သော်လည်း ခရီးလားသော ယှာမာရိ အမျိုးသားတစ်ယောက်သည် ထိုသူအနားသို့ ရောက်သောအခါ ထိုသူကို ကြည့်၍ ကရုဏာစိတ်ဟိသဖြင့်၊ ");
INSERT INTO rki_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ထိုသူအနားသို့ တိုးလာပြီးလျှင် သူ၏ဒဏ်ရာတိကို ဆီနှင့် စပျစ်ရည်ဖြင့် လိမ်းပြီး အဝတ်စနှင့် ပတ်စည်းပီးလေ၏။ ထို့နောက် မြည်းထက်၌ လူနာကို တင်၍ တည်းခိုခန်းတစ်ခုသို့ သယ်ဆောင်လားကာ ပြုစုလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","နောက်တစ်နိ့၌ သူသည် ငွီဒင်္ဂါးနှစ်ပြားကို တည်းခိုခန်း ပိုင်သျှင်အား ပီးပြီးလျှင် ‘ဤသူ့ကို စောင့်ရှောက်ပြုစုပီးပါ၊ နောက်ထပ် ကုန်ကျသမျှကို အကျွန်ပြန်လာသောအခါ ပီးပါမည်’” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ယေသျှုက “ယင်းသူရို့သုံးဦးထဲက ဇာသူက ဒါးပြတိုက်ခံရသူနှင့် စပ်ဆိုင်သောသူ ဟု သင် ထင်လဲ” ဟု မိန်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ကျမ်းတတ်ဆရာကလည်း “သူ့ကို သနားကြင်နာစွာ ပြုစုသောသူဖြစ်ပါ၏” ဟု လျှောက်လျှင်၊ ယေသျှုကလည်း “သင်လားပြီးလျှင်၊ ထိုနည်းတူ ပြုပါ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ယေသျှုနှင့် တပည့်တော်ရို့သည် ခရီးလားကြစဉ် ရွာတစ်ရွာသို့ ဝင်တော်မူသောအခါ မာသအမည်ဟိသောမိန်းမသည် မိမိ၏အိမ်တွင် ကိုယ်တော့်ကို ကြိုဆို၍ အာဂန္တုဝတ်ကို ပြုလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","သူမ၌ မာရိဟုခေါ်သော ညီမတစ်ယောက်ဟိ၏။ သူမသည် ယေသျှု၏ ခြီတော်ရင်းတွင်ထိုင်ပြီး ကိုယ်တော်၏ တရားစကားကို နားထောင်လျက်နိန်၏။ ");
INSERT INTO rki_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","မာသမူကား အာဂန္တုဝတ်ဖြင့် ပျာယာခတ်နိန်၍ ကိုယ်တော်ထံသို့ ချဉ်းကပ်ပြီးလျှင်၊ “သူမသည် အကျွန့်ကို တစ်ယောက်တည်း အလုပ်လုပ်ခြင်းငှာ ချန်ထားခသည်ကို အသျှင်က လစ်လျူယှုနိန်သလား၊ အကျွန့်ကို ကူညီပီးဖို့ သူမကို ပြောပီးတော်မူပါ” ဟု လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","သခင်ဘုရားကလည်း “မာသ၊ မာသ၊ သင်သည် များစွာသော အမှုကိစ္စကြောင့် စိတ်ပူပန်သောက ရောက်နိန်၏။ ");
INSERT INTO rki_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","သို့ရာတွင် လိုအပ်ချက်တစ်ခုသာ ဟိ၏။ မာရိက ကောင်းမြတ်သောအရာကို ရွီးချယ်လီဗျာယ်။ ထိုအရာတိကို သူမပါးမှ နုတ်ယူလို့မရ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","တစ်နိ့၌ ယေသျှုသည် တစ်ခုသောအရပ်တွင် ဆုတောင်းလျက်နိန်တော်မူ၏။ ဆုတောင်းပြီးသောအခါ တပည့်တော်တစ်ဦးက “အသျှင်ဘုရား၊ ယောဟန်က မိမိတပည့်တိကို ဆုတောင်းနည်း သင်ပီးစွာပိုင် အကျွန်ရို့ကိုလည်း သင်ပီးပါ” ဟု လျှောက်ထား၏။ ");
INSERT INTO rki_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ယေသျှုကလည်း ထိုသူရို့အား၊ “သင်ရို့ ဆုတောင်းသောအခါ၊ “ ‘အဖ၊ ကိုယ်တော်၏ နာမတော်အား ရိုသီလေးမြတ်ခြင်း ဟိပါစီသောဝ်၊ နိုင်ငံတော် တည်ထောင်ပါစီသောဝ်။ ");
INSERT INTO rki_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","အကျွန်ရို့ လိုအပ်သော အစားအစာကို နိ့တိုင်း ပီးသနားတော်မူပါ။ ");
INSERT INTO rki_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","သူတစ်ပါးက အကျွန်ရို့အား ပြစ်မှားသော အပြစ်တိကို၊ အကျွန်ရို့ ခွင့်ရွှတ်ပီးစွာပိုင်၊ အကျွန်ရို့ အပြစ်တိကိုလည်း ခွင့်ရွှတ်တော်မူပါ။ အကျွန်ရို့၌ ကြီးစွာသော စုံစမ်းသွီးဆောင်ခြင်းကို မရောက်ပါစီကေ့ ဟူ၍ မြွက်ဆိုကြလော့’ ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","တဖန် ယေသျှုက တပည့်တော်ရို့အား မိန့်တော်မူသည်ကား “သင်ရို့ထဲမှ တစ်ယောက်ယောက်က သန်းခေါင်ချိန်၌ မိတ်ဆွီတစ်ဦး၏ အိမ်သို့ လား၍ ‘အဆွီ၊ ကျေးဇူးပြု၍ အကျွန့်ကို မုန့်သုံးလုံး ချီးပီးပါ။ ");
INSERT INTO rki_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","အကျွန်၏ အဆွီသည် ခရီးလားယင်း အကျွန့်ပါးမာ ရောက်နိန်ပါသဖြင့် သူ့ကို ကျွေးစရာ တစ်ခုလေ့ မဟိ’ ဟု ဆိုသော်၊ ");
INSERT INTO rki_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ထိုသူက ‘အကျွန့်ကို မနှောက်ယှက်ကေ့၊ တန်းခါး ပိတ်ထားဗျာယ်၊ အကျွန်နှင့် အကျွန့် သားသမီးရို့သည် အိပ်ယာဝင် နိန်ဗျာယ်။ အကျွန် ထပြီးလျှင် သင့်ကို တစ်ခုလေ့ မပီးနိုင်’ ဟု အိမ်ထဲက ပြောလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","ငါပြောမည်၊ မိတ်ဆွီတစ်ဦးအနိန်နှင့် ထပြီး သင့်ကို မပီးကေလည်း၊ ရှက်ကြောက်ခြင်းမဟိဘဲ ဆက်တိုက် တောင်းနိန်သည်ဖြစ်၍ အိမ်သျှင်က ထပြီးလျှင် လိုအပ်သလောက် မုန့်တိကို ပီးလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“သင်ရို့ကို ငါပြောမည်။ တောင်းကြလော့၊ တောင်းလျှင် ရကြလိမ့်မည်။ ရှာကြလော့၊ ရှာလျှင် တွိ့ရလိမ့်မည်။ တန်းခါးကို ခေါက်ကြလော့၊ ခေါက်လျှင် တန်းခါးကို ဖွင့်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","အကြောင်းမူကား တောင်းသောသူတိုင်း ရလိမ့်မည်၊ ရှာသောသူ တွိ့လိမ့်မည်၊ တန်းခါးကို ခေါက်သောသူအား တန်းခါးကို ဖွင့်ပီးလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","သင်ရို့၌ အဖဖြစ်သူသည် မိမိသားက ငါးတောင်းသောအခါ မြွီကို ပီးမည်လော။ ");
INSERT INTO rki_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ကြက်ဥ တောင်းစွာကို ကင်းမီးကောက်ကို ပီးမည်လော။ ");
INSERT INTO rki_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","သင်ရို့သည် အဆိုးဖြစ်လျက်ပင် သားသမီးရို့အား ကောင်းသောအရာများ ပီးရမည်ကို သိကြလျှင်၊ ထိုမျှမက ကောင်းကင်ဘုံသျှင် အဖသည် တောင်းသောသူရို့အား သန့်ယှင်းသောဝိညာဉ်တော်ကို သာ၍ ပီးတော်မူမည် မဟုတ်လော” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ယေသျှုသည် ဆွံ့အသော နတ်ဆိုးကို နှင်ထုတ်တော်မူ၏။ နတ်ဆိုး ထွက်လားပြီးနောက် ဆွံ့အသောသူသည် စကားပြောလေ၏၊ ထို့ကြောင့် လူထုပရိသတ်ရို့သည် အံ့သြကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","သို့သော် လူတချို့က “ဤသူသည် နတ်ဆိုးဘုရင် ဗေလဇေဗုလက ပီးသောတန်ခိုးဖြင့် နတ်ဆိုးတိကို နှင်ထုတ်နိန်သည်” ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","အခြားသော သူရို့က ကောင်းကင်က နိမိတ်လက္ခဏာတစ်ခုကို တောင်းခံ၍ ကိုယ်တော့်ကို စုံစမ်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","သို့သော် ယေသျှုသည် ထိုသူရို့၏ အကြံအစည်ကို သိတော်မူသဖြင့်၊ ထိုသူရို့အား “မိမိအတွင်းမှာ ဆန့်ကျင်ကွဲပြားနိန်သော ဇာတိုင်းနိုင်ငံ မဆို ပျက်စီးလားဖို့ရာ ဖြစ်တေ။ မိမိအတွင်း၌ ဆန့်ကျင်ကွဲပြားနိန်သော အိမ်ထောင်စု တစ်ခုသည်လည်း ကျဆုံးလားဖို့ရာ ဖြစ်တေ။ ");
INSERT INTO rki_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","ယေဇူးနန့် စာတန်၏နိုင်ငံသည်လည်း အချင်းချင်း ဆန့်ကျင်တိုက်ခိုက်နိန်ကြသော အုပ်စုများ ဟိလျှင် ထိုနိုင်ငံသည် ဇာပိုင် ရပ်တည်နိုင်ဖို့လဲ။ သင်ရို့က ငါသည် ဗေလဇေဗုလက ပီးသောတန်ခိုးဖြင့် နတ်ဆိုးတိကို နှင်ထုတ်နိန်သည်ဟု ဆိုကတ်တေ။ ");
INSERT INTO rki_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","အကယ်၍ ငါသည် ဗေလဇေဗုလက ပီးသောတန်ခိုးဖြင့် နတ်ဆိုးတိကို နှင်ထုတ်နိန်သည်ဟု ဆိုလျှင်၊ သင်ရို့၏ တပည့်ရို့သည် နတ်ဆိုးကို ဇာပိုင် နှင်ထုတ်ကတ်စွာလဲ။ ယင်းကြောင့် သူရို့သည် မှားယွင်းနိန်ကြောင်းကို သင်ရို့၏တပည့်ရို့က သက်သီပြလျက်ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","သို့ရာတွင် ငါသည် ဘုရားသခင်၏လက်တော်ဖြင့် နတ်ဆိုးတိကို နှင်ထုတ်နိန်၏၊ ထို့ကြောင့် ဘုရားသခင်၏ နိုင်ငံတော်သည် သင်ရို့ပါးသို့ ရောက်နိန်ဗျာယ်။ ");
INSERT INTO rki_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“ခွန်အားကြီးသောသူတစ်ယောက်သည် လက်နက်အစုံအလင်နှင့် မိမိအိမ်ကို စောင့်ကြပ်နိန်သောအခါ သူ၏ ဥစ္စာပစ္စည်းများသည် လုံခြုံလျက်ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","သို့သော်လည်း သူ့ထက် ခွန်အားကြီးသောသူတစ်ယောက်သည် သူ့ကို တိုက်ခိုက်၍ အနိုင်ရသောအခါ သူသည် ထိုသူအားကိုးသည့် လက်နက်များကို သိမ်းယူပြီး၊ ထိုသူ၏ ဥစ္စာပစ္စည်းတိကိုလည်း ခွဲဝီကြလိမ့်မည်။” ");
INSERT INTO rki_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“ငါနန့်အတူ မဟိသောသူသည် ငါ့ကို ဆန့်ကျင်သောသူဖြစ်၏။ ငါနန့်အတူ တစ်စုတည်း မဟိသောသူသည်လည်း ဖြန့်ကြဲနိန်သောသူဖြစ်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“နတ်ဆိုး တစ်ကောင်သည် လူထဲက ထွက်လားပြီးလျှင် ခြောက်သွိ့သောအရပ်၌ လှည့်လည်ကာ နားခိုရာ ရှာနိန်၏။ ရှာလို့ မတွိ့သောအခါ ‘ငါ ထွက်လာခသည့်အိမ်ကို ပြန်လားရဖို့’ ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ထိုနတ်ဆိုးသည် ထိုအိမ်သို့ ရောက်လာသည့်အခါ အိမ်သည် သန့်ယှင်းလျက်ဟိသည်ကို တွိ့ရ၍၊ ");
INSERT INTO rki_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","သူသည် လား၍ မိမိထက် သာ၍ ဆိုးရွားသော တခြားနတ်ဆိုး ခုနစ်ကောင်ကို ခေါ်လာပြီးလျှင် သူရို့သည် ထိုနီရာ၌ ဝင်ရောက် နီထိုင်ကြလေ၏။ ဤသို့ဖြင့် ထိုလူ၏ နောက်မှ ဖြစ်လာသော အခြေအနေသည် ရှိ့က ဖြစ်ခသော အခြေအနေထက် သာ၍ ဆိုးလေ၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","ယေသျှုသည် ဤအကြောင်းအရာကို ဟောပြောနိန်စဉ် လူအုပ်ထဲမှ မိန်းမကြီးတစ်ယောက်က “အသျှင့်ကို မွီးဖွား၍ ပြုစုစောင့်ရှောက်သော မိခင်သည် မင်္ဂလာဟိပါ၏” ဟု ဟစ်အော်ပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","သို့ရာတွင် ယေသျှုက “ဘုရားသခင်၏ နှုတ်ကပါတ်တော်ကို ကြားရ၍ လိုက်နာသောသူသည် သာ၍ မင်္ဂလာဟိ၏” ဟု မိန့်တော်မူလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","လူထုပရိသတ်ရို့သည် များပြားလာကြသောအခါ ယေသျှုက “ဤသူရို့သည် ဆိုးယုတ်သောအမျိုး ဖြစ်ကြ၏၊ သူရို့သည် နိမိတ်လက္ခဏာတစ်ခုကို တောင်းဆိုကြ၏။ ယေဒါလည်း ယောန၏ နိမိတ်လက္ခဏာမှတစ်ပါး ဇာနိမိတ်လက္ခဏာကိုမှ သူရို့ကို ပြလိမ့်မည် မဟုတ်။ ");
INSERT INTO rki_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ယောနသည် နိနေဝေမြို့သားတိအတွက် နိမိတ်လက္ခဏာဖြစ်သကဲ့သို့ လူသားသည် ဤသူရို့အတွက် နိမိတ်လက္ခဏာ ဖြစ်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","တရားစီရင်တော်မူရာ နိ့၌ ယှေဘပြည်က ဘုရင်မသည် ထရပ်ပြီးလျှင် ဤသူရို့ကို ပြစ်ဒဏ်စီရင်လိမ့်မည်။ ဇာကြောင့်ဆိုသော် ယှေဘပြည်က ဘုရင်မသည် သျှောလမုန်မင်းကြီး၏ ပညာစကားကို နားထောင်ရန် အလွန်ကွာဝီးလျက်ဟိသောမိမိ၏ တိုင်းပြည်မှ လာရောက်လေ၏။ သျှောလမုန်ထက် ကြီးမြတ်သောသူသည် ဤအရပ်၌ ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","တရားစီရင်တော်မူရာ နိ့ရက်၌ နိနေဝေမြို့သားတိက ထရပ်ပြီး ဤလူတိကို ပြစ်ဒဏ်စီရင်ကြလိမ့်မည်။ ဇာကြောင့်ဆိုသော် ယောနသည် ဟောပြောစဉ်တွင် နိနေဝေမြို့သားတိသည် နောင်တရကြလေ၏။ ယောနထက် ကြီးမြတ်သောသူသည် ဤအရပ်၌ ဟိ၏ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“ဆီမီးခွက်ကို ထွန်း၍ တောင်း အောက်၌ ထားလေ့မဟိ၊ ဝင်လာသောသူတိ အလင်းကို မြင်စီခြင်းငှာ မီးတင်ခုံထက်၌သာ တင်ထားလေ့ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","သင်၏မျက်စိသည် သင့်ခန္ဓာကိုယ်၏ မီးခွက်ဖြစ်၏။ သင့်မျက်စိကြည်လင်လျှင် သင့်တစ်ကိုယ်လုံးသည်လည်း လင်းလျက်ဟိ၏။ သို့ရာတွင် သင်၏ မျက်စိမကောင်းလျှင်မူကား သင့်တစ်ကိုယ်လုံးသည် မှောင်လျက်ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","ထို့ကြောင့် သင်ရို့၌ဟိသော အလင်းသည် အမှောင်မဖြစ်စီဖို့ သတိပြုကတ်ပါ။ ");
INSERT INTO rki_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","အကယ်၍ သင့်ခန္ဓာတစ်ကိုယ်လုံးသည် အလင်း၌ ဟိလျှင် မှောင်မိုက်ဟူ၍ မဟိဘဲ ဆီမီးခွက်၏အလင်းသည် လင်းလက်နိန်သကဲ့သို့ သင်၏ ခန္ဓာကိုယ်တစ်ခုလုံးသည်လည်း လင်းလက်နိန်လိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ယေသျှုသည် မိန့်တော်မူပြီးသောအခါ၊ ဖာရိယှဲတစ်ယောက်သည် ကိုယ်တော့်ကို မိမိနှင့်အတူ စားသောက်တော်မူရန် ပင့်ဖိတ်လေ၏။ ထို့ကြောင့် ကိုယ်တော်သည် သူ၏အိမ်သို့ကြွ၍ စားပွဲ၌ ထိုင်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ယေသျှုသည် အစာကို မသုံးဆောင်မှီ လက်ကိုဆီးကြောခြင်း ပြုတော်မမူသည်ကို ဖာရိယှဲသည် မြင်သောအခါ အံ့သြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","ထို့ကြောင့် သခင်ဘုရားက၊ “သင်ရို့ ဖာရိယှဲတိက လောင်ဗွန်း၊ ခွက်တိကို အပြင်ဖက်၌သာ စင်ကြယ်အောင် ဆီးကြောသော်လည်း အတွင်း၌မူကား သင်ရို့သည် လောဘကြီးခြင်း၊ ဆိုးညစ်ခြင်းများဖြင့် ပြည့်နှက်လျက်ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","အချင်းလူမိုက်ရို့၊ အပြင်ဖက်ကို ဖန်ဆင်းတော်မူသော ဘုရားသခင်သည် အတွင်းဖက်ကိုလည်း ဖန်ဆင်းတော်မူသည် မဟုတ်လော။ ");
INSERT INTO rki_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","ယေဒါလည်း သင်ရို့၏ လောင်ဗွန်းနှင့် ခွက်တိ၌ဟိသော အရာတိကို ဆင်းရဲသားရို့အား ပီးကမ်းကြလော့။ ထိုသို့ပြုလျှင် အရာအားလုံးသည် သင်ရို့အတွက် သန့်ယှင်းလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“ဖာရိယှဲရို့၊ သင်ရို့သည် အမင်္ဂလာဟိကြ၏။ သင်ရို့သည် ဟင်းသီးဟင်းရွက်များနှင့် အခြားဆီးဖက်ဝင် အရွက်အမျိုးမျိုးကို ဆယ်ဖို့တစ်ဖို့ ပီးလှူကြသော်လည်း တရားသဖြင့်စီရင်ခြင်း၊ ဘုရားသခင်အား ချစ်ခြင်းတိကို ဥပေက္ခာပြုထားကြ၏။ အခြားအရာတိကို ဥပေက္ခာမပြုဘဲ၊ ဤအရာတိကို ကျင့်သုံးသင့်၏။” ");
INSERT INTO rki_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“ဖာရိယှဲရို့၊ သင်ရို့သည် အမင်္ဂလာဟိ၏။ သင်ရို့သည် တရားဇရပ်တိ၌ မြင့်မြတ်သောနီရာတိကိုလည်းကောင်း၊ စျီးထဲ၌ ရိုသီစွာ နှုတ်ဆက်ခြင်းကိုလည်းကောင်း နှစ်သက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","သင်ရို့သည် အမင်္ဂလာဟိကြ၏။ သင်ရို့သည် အမှတ်အသားမဟိသော သင်္ချိုင်းတွင်းနှင့် တူကြ၏။ လူရို့သည် ထိုတွင်းထက်မှ လားလာကြသော်လည်း သင်္ချိုင်းတွင်းမှန်း မသိကြ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ကျမ်းတတ်ဆရာတိထဲမှ တစ်ယောက်က၊ “ဆရာ၊ ဤသို့ မိန့်တော်မူသည်ကား အကျွန်ရို့ကိုလည်း စော်ကားရာ ကျပါ၏” ဟု လျှောက်၏။ ");
INSERT INTO rki_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ယေသျှုကလည်း၊ “ကျမ်းတတ်ဆရာရို့၊ သင်ရို့သည် အမင်္ဂလာဟိကြ၏။ ထမ်းရခက်သော ဝန်ထုပ်တိကို လူတိကို ထမ်းစီပြီးလျှင်၊ သင်ရို့ကိုယ်တိုင်က ထိုဝန်ထုပ်တိကို လက်ဖျားနှင့်တောင် မတို့ကတ်။ ");
INSERT INTO rki_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","သင်ရို့သည် အမင်္ဂလာဟိကြ၏။ သင်ရို့သည် မိမိရို့အဖိုးအဖီးတိ သတ်ခသော ပရောဖက်တိအတွက် တင့်တယ်သော အုတ်ဂူတိကို တည်ဆောက်ပီးကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","ထို့ကြောင့် သင်ရို့၏ အဖိုးအဖီးတိ ကျူးလွန်ခသောအမှုတိ၌ သင်ရို့က အလိုတူအလိုပါ ဖြစ်ကြ၏။ သင်ရို့ အဖိုးအဖီးရို့က ပရောဖက်တိကိုသတ်ပြီး သင်ရို့က အုတ်ဂူတိကို တည်ဆောက်ပီးကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ယင်းအတွက်ကြောင့် ဘုရားသခင်သည် မိမိ၏ ဉာဏ်ပညာအားဖြင့် ‘ငါသည် ပရောဖက်တိ၊ တမန်တော်တိကို ဤလူတိပါးသို့ စီရွှတ်မည်။ သူရို့သည်ကား တချို့ကို ညှည်းဆဲပြီးလျှင်၊ တချို့ကို သတ်ကြလိမ့်မည်’ ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","ထို့ကြောင့် အာဗေလမှစ၍ သန့်ယှင်းရာဌာနနှင့် ယဇ်ပလ္လင်ကြားတွင် အသတ်ခံခရသော ဇာခရိအထိ၊ ကမ္ဘာတည်ချိန်မှစပြီး အသတ်ခံခရသော ပရောဖက်ရို့၏ အသွီးကြောင့် ဤလူမျိုးရို့သည် ပြစ်ဒဏ်စီရင်ခြင်းကို ခံရကြလိမ့်မည်။ ငါဆိုသည်ကား၊ ဤလူမျိုးရို့သည် ယင်းအမှုအရာအားလုံးအတွက် အပြစ်စီရင်ခြင်းကို ခံရကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“ကျမ်းတတ်ဆရာရို့၊ သင်ရို့သည် အမင်္ဂလာဟိကြ၏။ သင်ရို့သည် အသိပညာအိမ်တန်းခါးကို ဖွင့်သော သော့ကို သိမ်းထားကြပြီးကေ ကိုယ်တိုင်လည်းမဝင်၊ ဝင်ဖို့ကြိုးစားနိန်ကြသော သူရို့ကိုလည်း ဆီးတားထားကြ၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ထိုအရပ်မှ ယေသျှုသည် ထွက်ကြွတော်မူသောအခါ၊ ဖာရိယှဲနှင့် ကျမ်းတတ်ဆရာရို့သည် ကိုယ်တော်အား ခါးသီးစွာ ဝေဖန်ပြောဆိုခြင်းကို စတင်ကြလေ၏၊ အကြောင်းအရာ များစွာကိုလည်း မိန်းမြန်းကာ၊ ");
INSERT INTO rki_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","နှုတ်တော်ထွက်စကားတွင် အမှားရှာ၍ ဖမ်းဆီးရန် ကြိုးစားကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","ထိုအခါ ထောင်ပေါင်းများစွာသော လူရို့သည် စုဝေးလာကြသဖြင့် အချင်းချင်း နင်းမိကြ၏။ ယေသျှုသည် တပည့်တော်ရို့အား ဦးစွာ မိန့်တော်မူသည်မှာ၊ “ဖာရိယှဲရို့၏ တဆီးဖြစ်သည့် သူတော်ကောင်းယောင်ဆောင်ခြင်းကို သတိပြုကတ်ပါ။ ");
INSERT INTO rki_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","ဖုံးထားသောအရာများတွင် ဖွင့်ပြ​ခြင်း​မ​ခံရ​မည့် အရာ​တစ်စုံတစ်ခု​မျှ​မ​ဟိ။ ထိမ်ဝှက်ထားသော အရာတိတွင် ဖော်ပြ​ခြင်း​မ​ခံရ​မည့်​အရာ​လည်း တစ်စုံတစ်ခု​မျှ​မ​။ ");
INSERT INTO rki_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","သို့ဖြစ်၍ မှောင်မိုက်၌ သင်ရို့ ပြောသောစကားတိကို အလင်း၌ ကြားကြလိမ့်မည်။ အိမ်ခန်းထဲ၌ သင်ရို့ တီးတိုးပြောသော စကားတိကို အိမ်ခေါင်ထက်မှ ကြွေးကြော်ကြလိမ့်မည်။” ");
INSERT INTO rki_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“ငါ့အဆွီရို့၊ သင်ရို့ကို ငါဆိုသည်ကား ကိုယ်ခန္ဓာကို သတ်ခြင်းမှတစ်ပါး အခြားတစ်ခုကိုမျှ အန္တရာယ်မပြုနိုင်သူတိကို မကြောက်ကတ်ကေ့။ ");
INSERT INTO rki_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","သင်ရို့ ကြောက်သင့်သောသူကို ငါဖော်ပြမည်။ ကိုယ်ခန္ဓာကိုသတ်ပြီး သင်ရို့ကို ငရဲ၌ ချပစ်နိုင်သော တန်ခိုးဟိသည့် ဘုရားသခင်ကို ကြောက်ကြလော့။ မှန်ပါ၏၊ ထိုအသျှင်ကို ကြောက်ရမည်ဟု သင်ရို့အား ငါဆို၏။” ");
INSERT INTO rki_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“စာချေငါးကောင်ကို ဖဲသာနှစ်ပြားနှင့် ရောင်းရသည် မဟုတ်လော။ သို့ရာတွင် ဘုရားသခင်က စာချေတစ်ကောင်ကိုတောင် မိ့ထားတော်မမူ။ ");
INSERT INTO rki_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","သင်ရို့ဂေါင်းက ဆံပင်တိကိုပင် တစ်ခုမကျန် ရီတွက်ထားတော်မူ၏။ ထို့ကြောင့် မကြောက်ကတ်ကေ့။ သင်ရို့က စာငှက်တိထက် သာ၍ မြတ်ကြ၏။” ");
INSERT INTO rki_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“ငါအမှန်ဆိုသည်ကား၊ ဇာသူမဆို လူတိရှိ့၌ ငါ့အား ဝန်ခံသောသူကို လူသားကလည်း ဘုရားသခင်၏ ကောင်းကင်တမန်တိရှိ့၌ ထိုသူ့ကို ဝန်ခံမည်။ ");
INSERT INTO rki_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ငါ့ကို လူတိရှိ့၌ ငြင်းပယ်သူကို လူသားသည် ဘုရားသခင်၏ ကောင်းကင်တမန်တိရှိ့၌ ထိုသူကို ငါ ငြင်းပယ်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“လူသားကို နှုတ်ဖြင့် ပြစ်မှားသောသူ အားလုံးသည် အပြစ်ခွင့်ရွှတ်ခြင်း ရနိုင်သော်လည်း သန့်ယှင်းသောဝိညာဉ်တော်ကို ပြစ်မှားပြောဆိုသူကား အပြစ်ခွင့်ရွှတ်ခြင်း ရနိုင်လိမ့်မည် မဟုတ်။ ");
INSERT INTO rki_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“လူတိက သင်ရို့ကို တရားဇရပ်တိထဲသို့ လည်းကောင်း၊ အုပ်ချုပ်သူနှင့် အစိုးရအာဏာပိုင်တိရှိ့၌ လည်းကောင်း ခေါ်လားကြသောအခါ ဇာပိုင် ချေပရမည်၊ ဇာပိုင် ပြောဆိုရမည်ကို မစိုးရိမ်ကတ်ကေ့။ ");
INSERT INTO rki_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","အကြောင်းမူကား၊ ထိုအချိန်၌ သင်ရို့ ဇာပိုင်ပြောရမည်ဆိုသည်ကို သန့်ယှင်းသောဝိညာဉ်တော်က သွန်သင်တော်မူလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ပရိသတ်ထဲမှ လူတစ်ယောက်က “ဆရာ၊ အကျွန်၏အဖ ထားခသောအမွီကို အကျွန်အား ခွဲပီးခြင်းငှာ အကျွန့်အစ်ကိုအား မိန့်တော်မူပါ” ဟု ကိုယ်တော့်ကို လျှောက်ထား၏။ ");
INSERT INTO rki_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ယေသျှုကလည်း၊ “အဆွီ၊ ငါ့ကို တရားသူကြီးအဖြစ် လည်းကောင်း၊ သင်ရို့ နှစ်ယောက်ကြားတွင် အမွီခွဲဝီပီးသူအဖြစ် လည်းကောင်း၊ ဇာသူက ခန့်ထားသနည်း” ဟု ပြန်၍ မိန်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ထို့နောက် လူတိအား၊ “လောဘလွန်ကြူးခြင်း အမျိုးမျိုးကို သတိနန့် ယှောင်ကြည်ကြလော့။ အကြောင်းမူကား လူ့အသက်သည် ဥစ္စာပစ္စည်းကြွယ်ဝမှု၌ မတည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ထို့နောက် ယေသျှုသည် ဤပုံဥပမာကို သူရို့အား၊ “သူဌေးတစ်ဦး၌ မိမိ၏လယ်ယာမှ အသီးအနှံ အများကြီးထွက်သည်ဖြစ်၍၊ ");
INSERT INTO rki_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","‘ငါ၏ သီးနှံတိကို သိုထားဖို့ နီရာမဟိ။ ငါ ဇာပိုင် လုပ်ရမည်နည်း’ ဟု တစ်ယောက်တည်း တွေးတောနိန်၏။ ");
INSERT INTO rki_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","‘ငါ ဤပိုင်လုပ်မည်၊ စပါးရိုင် အဟောင်းတိကို ဖျက်၍ ပို၍ ကြီးသော စပါးရိုင်ကြီးတိကို တည်ဆောက်မည်။ ငါ၏ဂျုံစပါးတိနှင့် အခြားအသီးအနှံတိကို ရိုင်သစ်ကြီး၌ သိုထားမည်။ ");
INSERT INTO rki_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","သို့ဖြစ်၍ သင်သည် နှစ်ပေါင်းများစွာ စားသောက်ဖို့ သီးနှံတိကို သိုထားပြီဖြစ်၍ စိတ်ချမ်းသာစွာ နီထိုင်လော့။ စားသောက်ပျော်ပါးပြီးလျှင် ပျော်ရွှင်စွာနီထိုင်လော့’ ဟု ငါ့ကိုငါ ပြောမည်ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","သို့သော် ဘုရားသခင်က ‘အသင် လူမိုက်၊ ဤည၌ သင့်၏အသက် ချုပ်ငြိမ်းရလိမ့်မည်။ သို့ဖြစ်၍ သင်စုဆောင်းထားသော ဥစ္စာပစ္စည်းတိက ဇာသူ့ ဥစ္စာ ဖြစ်လိမ့်မည်နည်း’” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","ယေသျှုက၊ “မိမိအဖို့ ဥစ္စာများကို သိုထားသော်လည်း ဘုရားသခင်၏ ရှိ့တော်မှောက်၌ ကြွယ်ဝခြင်း မဟိသောသူသည် အဆိုပါ သူဌေးနှင့် တူ၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ထို့နောက် ယေသျှုကလည်း တပည့်တော်ရို့အား၊ “ယင်းအတွက်ကြောင့် ငါဆိုသည်ကား၊ သင်ရို့သည် အသက်ရှင်ဖို့အတွက် ဇာပိုင် စားရဖို့လဲ ဆိုပြီးကေ မစိုးရိမ်ကတ်ကေ့။ ကိုယ်ခန္ဓာအတွက် ဇာပိုင် ဝတ်ရမည် ဆိုသည်ကိုလည်း မစိုးရိမ်ကတ်ကေ့။ ");
INSERT INTO rki_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","အကြောင်းမူကား အစာထက် အသက်က သာ၍ အရေးကြီးသကဲ့သို့ အဝတ်ထက် ခန္ဓာက သာ၍ အရေးကြီး၏။ ");
INSERT INTO rki_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","တောကျီးကန်းတိကို ကြည့်ရှု ဆင်ခြင်ကြလော့။ သူရို့သည် မျိုးစိ့မကြဲ၊ အသီးနှံတိကို မရိတ်မသိမ်း။ သိုထားစရာ အခန်းတိ၊ စပါးရိုင်တိမဟိ။ သို့သော်လည်း သူရို့တိကို ဘုရားသခင် ကျွေးမွေးတော်မူ၏။ သင်ရို့က ငှက်တိထက် အများကြီး မြတ်သည် မဟုတ်လော။ ");
INSERT INTO rki_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","ဇာသူက စိုးရိမ်ခြင်းအားဖြင့် မိမိ၏ အသက်ကို အနည်းချေလောက် ပို၍ ရှည်စီနိုင်သနည်း။ ");
INSERT INTO rki_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ဤသို့ သေးငယ်သောအမှုကိုတောင် မတတ်နိုင်လို့ဟိလျှင် ဇာဖြစ်လို့ အခြားအမှုတိအတွက် စိုးရိမ်ကြသနည်း။ ");
INSERT INTO rki_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","တောနှင်းပင်တိ ဇာပိုင် ကြီးထွားလာလဲ ဆိုသည်ကို ကြည့်ရှုဆင်ခြင်ကတ်ပါ။ ထိုပန်းပင်တိသည် အလုပ်မလုပ်၊ ခြည်ဖြစ်စီဖို့အတွက် ဗိုင်းမငင်။ သို့သော်လည်း ဘုန်းကြီးသော သျှောလမုန်မင်းကြီးတောင် ထိုပန်းကဲ့သို့ မဝတ်ဆင်နိုင်ဟု ငါပြောဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ယုံကြည်ခြင်း အားနည်းသောသူရို့၊ ဤနိ့ အသက်ရှင်ပြီးလျှင် နက်ဖြန်ခါ မီးဖိုထဲသို့ ရောက်သည့်မြက်ပင်ကို ဘုရားသခင်သည် ဤလောက်ထိ အဝတ်နှင့်ဖုံးလွှမ်းတော်မူလျှင် သင်ရို့ကို ဤထက်မက အဝတ်နှင့် ဝတ်ဆင်ပီးတော်မူလိမ့်မည် မဟုတ်လော။ ");
INSERT INTO rki_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“ထို့ကြောင့် ဇာပိုင်စားရဖို့၊ သောက်ရဖို့လဲ ဆိုပြီးလျှင် စိုးရိမ်ပူပန်မှု မဟိကတ်ကေ့။ ");
INSERT INTO rki_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ထိုအရာတိကို သာသနာပလူတိကသာ ရှာဖွီတတ်ကြ၏။ ထိုအရာတိကို သင်ရို့ လိုအပ်ကြောင်း သင်ရို့အဖ သိတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","သင်ရို့မူကား ဘုရားသခင်၏ နိုင်ငံတော်ကို ရှာကြလော့။ နောက်မှ ထိုအရာတိကိုလည်း ထပ်၍ ပီးတော်မူလိမ့်မည်။” ");
INSERT INTO rki_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","သိုးစုချေ၊ မကြောက်ကတ်ကေ့။ အကြောင်းမူကား သင်ရို့အဖသည် သင်ရို့အား နိုင်ငံတော်ကိုပီးဖို့ အလိုဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","သင်ရို့၌ ဟိသည့် အရာအားလုံးကို ရောင်း၍ ဆင်းရဲသားတိကို ပီးကမ်းစွန့်ကြဲလော့။ မဆွီးနိုင်သော ဖဲသာအိတ်တိကို ဆောင်ကြလော့။ သူခိုး မကပ်၊ ပိုးရွလည်း မဖျက်ဆီးနိုင်သည့် ကောင်းကင်ဘုံ၌ မကုန်ခန်းနိုင်သော ဘဏ္ဍာကို ဆည်းပူးကြလော့။ ");
INSERT INTO rki_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","အကြောင်းမူကား သင်ရို့၏ ဘဏ္ဍာဟိသောအရပ်၌ သင်ရို့၏ စိတ်နှလုံးရောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“သင်ရို့သည် ခါးကိုစည်းပြီး၊ မီးခွက်တိကိုထွန်း၍ အဆင်သင့် ဟိနိန်ကြလော့။ ");
INSERT INTO rki_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","မိမိရို့သခင်က မင်္ဂလာဆောင်ပွဲမှ ပြန်လာသောအခါ တန်းခါးကိုခေါက်လျှင် ချက်ချင်းဖွင့်ပီးရန် စောင့်မျှော်နိန်ကြသော အခိုင်းအစီကဲ့သို့ ဖြစ်ကြလော့။ ");
INSERT INTO rki_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ထိုအခိုင်းအစီတိ စောင့်မျှော်နိန်ကြသည်ကို သခင်ပြန်ရောက်ချိန်၌ တွိ့ရလျှင် ယင်းအခိုင်းအစီရို့သည် မင်္ဂလာဟိကြ၏။ ငါအမှန်ဆိုသည်ကား၊ သခင်သည် ခါးပန်းကိုစည်းပြီးလျှင် အခိုင်းအစီတိကို စားပွဲ၌ ထိုင်ခိုင်းစီပြီး ကျွေးမွေးလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","သခင်သည် သန်းခေါင်အချိန်၌ ဖြစ်စီ၊ မိုးသောက်အချိန်၌ ဖြစ်စီ ကြွလာသောအခါ၊ စောင့်မျှော် နိန်ကြသော အခိုင်းအစီရို့သည် မင်္ဂလာဟိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","အိမ်သျှင်သည် သူခိုးလာမည့်အချိန်ကို သိထားလျှင် မိမိအိမ်ကို သူခိုး ဖောက်ထွင်းခံလိမ့်မည် မဟုတ်ကြောင်း သိမှတ်ကြလော့။ ");
INSERT INTO rki_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","သင်ရို့သည်လည်း အသင့်ပျင်ဆင်ထားကြလော့။ အကြောင်းမူကား လူသားသည် သင်ရို့ မထင်မှတ်ထားသောအချိန်၌ ကြွလာလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ပေတရုက “အသျှင်၊ ဤဥပမာကို အကျွန်ရို့အတွက် မိန့်တော်မူပါသလော။ သို့မဟုတ် လူတိုင်းအတွက် မိန့်တော်မူသလော” ဟု မိန်းလျှောက်လျှင်၊ ");
INSERT INTO rki_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","သခင်ဘုရားက၊ “သခင်သည် အခိုင်းအစီတိကို အုပ်ချုပ်ရန်နှင့် အချိန်တန်လျှင် အစားအသောက်တိကို ခွဲဝီပီးစီခြင်းငှာ ခန့်ထားသည့် သစ္စာဟိပြီး လိမ္မာသော အခိုင်းအစီကား ဇာသူလဲ။ ");
INSERT INTO rki_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ထိုအရာကို ကောင်းစွာ ပြုနိန်သည်ကို သူ၏သခင် ပြန်လာချိန်၌ တွိ့ရလို့ဟိလျှင် ထိုအခိုင်းအစီသည် မင်္ဂလာဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","သင်ရို့အား ငါအမှန်ဆိုသည်ကား၊ သခင်သည် ကိုယ့်ဥစ္စာဟိသမျှတိကို စီမံအုပ်ချုပ်ဖို့ ထိုအခိုင်းအစီကို အပ်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","သို့သော်လည်း၊ ထိုအခိုင်းအစီက၊ ‘ငါ့သခင် ပြန်လာဖို့ ကြာဖို့သိမ့်’ ဟု စိတ်ထဲ၌ အောက်မိ့ပြီးလျှင် အခိုင်းအစီ ယောက်ျား၊ မိန်းမတိကို သတ်ပုတ်၍ သောက်စားမူးယစ် နိန်၏။ ");
INSERT INTO rki_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ထိုသူ ထင်မထားသောနိ့၊ မသိသောအချိန်တွင် သခင်သည် ပြန်လာပြီးလျှင် ထိုကျွန်ကို ပြင်းထန်စွာ ဆုံးမ၍ သစ္စာမဟိသူရို့ လားရာ ပျက်စီးခြင်းလမ်း၌ နီရာကျလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“သခင်၏အလိုကို သိလျက်နှင့် အဆင်သင့်မထား၊ သခင်၏ အလိုအတိုင်း မလုပ်ဆောင်ဘဲနိန်သော အခိုင်းအစီသည် ပြင်းစွာသော ကြိမ်ဒဏ်ဖြင့် အပြစ်ပီး ခံရလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","သို့သော်လည်း သခင်၏ အလိုဆန္ဒကိုမသိဘဲ ကြိမ်ဒဏ်ခံရမည့်အမှုကို ပြုသော အခိုင်းအစီကား ကြိမ်ဒဏ်အပြစ် အနည်းချေကိုသာ ခံရမည်။ ကျေးဇူးပြုခြင်း များစွာခံရသောသူသည်၊ များစွာပီးဆပ်ရမည်။ သာ၍ များသော ကျေးဇူးကို ခံရသောသူကား သာ၍ များသည့်အရာကို ပီးရလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“ဤမြီကြီးကို မီးလောင်စီခြင်းငှာ ငါလာ၏။ မီးလောင်စီခြင်းငှာလည်း အလိုဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","ငါခံရမည့် ဗတ္တိဇံတစ်ပါးဟိ၏။ ထိုအမှုကို မဆောင်ရွက်မချင်း ငါသည် စိတ်ဒုက္ခရောက်ရ၏။ ");
INSERT INTO rki_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","ဤလောကကို ငြိမ်သက်ခြင်းပီးရန် ငါလာသည်ဟု ထင်ကြသလော။ ထိုသို့ မဟုတ်၊ ကွဲပြားစီခြင်းငှာ ငါလာခြင်း ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ယခုမှစ၍ ငါးယောက်ဟိသော မိသားစု၌ သုံးယောက်သည် နှစ်ယောက်ကိုလည်းကောင်း၊ နှစ်ယောက်သည် သုံးယောက်ကိုလည်းကောင်း ဆန့်ကျင်ကြ၍ ကွဲပြားလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","အဖသည် သားကိုလည်းကောင်း၊ သားသည် အဖကိုလည်းကောင်း၊ အမိသည် သမီးကိုလည်းကောင်း၊ သမီးသည် အမိကိုလည်းကောင်း၊ ယောက္ခမသည် ခြုပ်မကိုလည်းကောင်း၊ ခြုပ်မသည်လည်း ယောက္ခမကိုလည်းကောင်း အချင်းချင်း ဆန့်ကျင်၍ ကွဲပြားလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ထို့နောက် ကိုယ်တော်သည်၊ “အနောက်အရပ်မှ မိုးတိမ် တက်လာသည်ကိုမြင်လျှင် ‘မိုးရွာဖို့ဗျာယ်’ ဟု ချက်ချင်း ပြောတတ်ကြ၏။ သင်ရို့ ပြောသည်အတိုင်းလည်း ဖြစ်တတ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","တောင်လီ လာသောအခါ နီပူလိမ့်မည်ဟု သင်ရို့ ပြောတတ်ကြ၏။ သင်ရို့ ပြောသည်အတိုင်းလည်း ဖြစ်တတ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","သူတော်ကောင်းယောင်ဆောင်သောသူရို့၊ သင်ရို့တိက မိုး၊ မြီ အရိပ်အခြေကို ကြည့်၍ ရာသီဥတုအခြေအနေကို ပိုင်းခြား သိနိုင်ကြပါလျက်နှင့် အဂုခေတ်ကာလကို ဇာဖြစ်လို့ ပိုင်းခြား၍ မသိနိုင်ကြသနည်း။ ");
INSERT INTO rki_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“ထိုမှတစ်ပါး မှန်သောအမှုကိုပြုရန် ဇာကြောင့် သင်ရို့ကိုယ်တိုင် မဆင်ခြင်ကြသနည်း။ ");
INSERT INTO rki_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","သင်၏ တရားတွိ့ဖက်နှင့်အတူ တရားသူကြီးပါးသို့ လားကြသောအခါ လမ်း၌ သူနန့် ကြေအီးအောင် ဆွေးနွေးကြလော့။ သို့မဟုတ်ပါက သူသည် သင့်ကို တရားသူကြီးရှိ့သို့ ဆွဲခေါ်လားလိမ့်မည်။ တရားသူကြီးကလည်း သင့်ကို မင်းမှုထမ်းလက်၌ အပ်လိမ့်မည်။ မင်းမှုထမ်းကလည်း သင့်ကို ထောင်ချလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","လျော်ပီး ငွီအားလုံး မပီးမချင်း သင်သည် ထိုနီရာ၌ နီရလိမ့်မည်ဟု ငါဆိုသည်” ဟု ပရိတ်သတ်ရို့အား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","ထိုအချိန်၌ လူတချို့သည် ယေသျှုထံပါးသို့လာ၍ ပိလတ်မင်းသည် ဂါလိလဲလူရို့၏ အသွီးကို သူရို့ပူဇော်နိန်သော ယဇ်တိနှင့် ရောနှောခကြောင်းကို လျှောက်ထားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ယေသျှုက “သူရို့သည် ထိုကဲ့သို့ အသီသတ်ခံရ၍ အခြားသော ဂါလိလဲလူတိထက် ပိုပြီး အပြစ်များသည်ဟု သင်ရို့ ထင်ကြသလော။ ");
INSERT INTO rki_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","သင်ရို့အား ငါဆိုသည်ကား၊ သူရို့က သာ၍ အပြစ်များသည် မဟုတ်။ သင်ရို့လည်း နောင်တမရလျှင် ထိုသူရို့နည်းတူ သီကြီပျက်စီးလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","သျှိလောင်းပြအိုး ပြိုကျသဖြင့် ပိ၍ သီသောသူ တစ်ဆယ့်သျှစ်ယောက်သည် အခြားသော ယေရုဆလင်မြို့၌ နီထိုင်သော လူတိထက် ပိုပြီး အပြစ်များသည်ဟု သင်ရို့ ထင်ကြသလော။ ");
INSERT INTO rki_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","ထိုသို့ မဟုတ်။ သင်ရို့အား ငါဆိုသည်ကား၊ သင်ရို့အားလုံးလည်း နောင်တမရလျှင် ထိုသူရို့ကဲ့သို့ သီကြီပျက်စီးလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ယေသျှုသည် လူအပေါင်းရို့အား ပုံဥပမာကိုဆောင်၍၊ “လူတစ်ယောက်သည် စပျစ်ဥယျာဉ်ထဲ၌ သင်္ဘောသဖန်းပင်တစ်ပင်ကို စိုက်ပျိုးထား၏။ ဥယျာဉ်သျှင်သည် သဖန်းပင်အနားကို လား၍ အသီးကိုရှာသော်လည်း အသီးကိုမတွိ့ရ။ ");
INSERT INTO rki_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ထို့ကြောင့် ဥယျာဉ်မှူးအား ‘ငါသည် ဤသဖန်းပင်သို့ လာ၍ သဖန်းသီးရှာသည်မှာ သုံးနှစ်တောင်ဟိဗျာယ်။ ယေဒါလေ့ တစ်လုံးတောင် မတွိ့ရ။ ဤသစ်ပင်ကို ခွတ်ပလိုက်၊ ဇာဖြစ်လို့ မြီဆီလွှာကို အကျိုးမဟိ ဖြစ်စီဖို့လဲ’ ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ထိုအခါ ဥယျာဉ်မှူးက ‘ဆရာ၊ ထိုအပင်ကို ဤနှစ် တစ်နှစ်ထားပါဦး။ အပင်အရင်းကိုတူးဆွ၍ မြီသြဇာ ထည့်ပါဦးမည်။ ");
INSERT INTO rki_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ထိုသို့ပြုလျှင် နောင်နှစ်ခါ အသီးသီးကောင်း သီးပါလိမ့်မည်။ အသီးမသီးခသည်ဟိသော် ခွတ်ပလိုက်ပါမည်’ ဟု ပြန်လျှောက်လေ၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","တစ်နိ့သော ဥပုသ်နိ့၌ ယေသျှုသည် တရားဇရပ်တစ်ခုတွင် ဟောပြောသွန်သင်လျက်ဟိရာ၊ ");
INSERT INTO rki_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","တစ်ဆယ့်သျှစ်နှစ်ပတ်လုံး နတ်ဆိုးပူး၍ ရောဂါနှိပ်စက်ခြင်းကို ခံနိန်ရသော မိန်းမတစ်ယောက်ဟိ၏။ သူမသည် ကျောကုန်း၍ မိမိခါးကို လုံးဝမဆန့်နိုင်။ ");
INSERT INTO rki_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ယေသျှုသည် သူမကို မြင်သောအခါ အထံတော်သို့ ခေါ်တော်မူလျက်၊ “အချင်းမိန်းမ၊ သင်၏ရောဂါမှ လွတ်မြောက်ဗျာယ်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ကိုယ်တော်သည် သူမ၏အထက်၌ လက်ကို တင်တော်မူသဖြင့် သူမသည် ချက်ချင်းပင် ခါးဆန့်လားပြီး ဘုရားသခင်၏ကျေးဇူးတော်ကို ချီးမွမ်းလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","ထိုသို့ ဥပုသ်နိ့၌ ယေသျှုသည် အနာရောဂါကို ပျောက်ကင်းစီတော်မူ၍ တရားဇရပ်မှူးသည် စိတ်ဆိုးသဖြင့် “အလုပ်လုပ်ရသောရက် ခြောက်ရက်ဟိ၏။ ထိုနိ့တိ၌ လာပြီး ရောဂါပျောက်ကင်းခြင်း ကျေးဇူးကို ခံယူကတ်ပါ။ ဥပုသ်နိ့၌ကား မလုပ်ကတ်ပါကေ့” ဟု လူတိအား ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","သခင်ဘုရားက၊ “သူတော်ကောင်းယောင်ဆောင်သောသူတိ၊ သင်ရို့သည် ဥပုသ်နိ့၌ သင်ရို့၏ နွားတိ၊ မြည်းတိကို တင်းကုတ်က ကြိုးကို ဖြီပြီးလျှင် ရီတိုက်ဖို့ ခေါ်ယူလားကြသည် မဟုတ်လော။ ");
INSERT INTO rki_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","အဂုတွင် အာဗြဟံ၏သမီးဖြစ်သည့် ဤမိန်းမသည် တစ်ဆယ့်သျှစ်နှစ်ပတ်လုံး စာတန်၏တုပ်နှောင်ခြင်းကို ခံနိန်ရ၏။ သူမကို ဥပုသ်နိ့၌ ထိုတုပ်နှောင်ခြင်းမှ မလွှတ်အပ်သလော” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ဤသို့ မိန့်တော်မူလိုက်သောအခါ ကိုယ်တော့်ကို ရန်ဖက်ပြုသူရို့သည် အရှက်ရကြ၏။ လူထုပရိတ်သတ် အပေါင်းရို့သည် ကိုယ်တော်ပြုတော်မူသော အံ့သြစရာများကြောင့် ရွှင်လန်းဝမ်းမြောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ယေသျှုက၊ “ဘုရားသခင်၏ နိုင်ငံတော်သည် ဇာနန့်တူသလဲ၊ ဇာချင့်နှင့် နှိုင်းပြရဖို့လဲ ဟူမူကား၊ ");
INSERT INTO rki_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ဤသို့သော အရာနှင့်တူ၏။ လူတစ်ယောက်သည် မုံညှင်းစိ့ကိုယူ၍ မိမိဥယျာဉ်၌ စိုက်လေ၏။ ထိုအစိ့သည် အပင်ပေါက်လာ၍ ကြီးထွားပြီးလျှင် အပင်ကြီးဖြစ်လာပြီး အကိုင်းအခက်တိတွင် ငှက်တိ အသိုက်လုပ်နိန်ကြ၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","တဖန် ယေသျှုက၊ “ဘုရားသခင်၏ နိုင်ငံတော်ကို ဇာအရာနှင့် နှိုင်းပြရဖို့လဲ။ ");
INSERT INTO rki_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","မိန်းမတစ်ယောက်သည် တဆီးအချို့ကိုယူပြီး မုန့်မှုန့်သုံးစိတ်၌ ရောထည့်လိုက်သောအခါ မုန့်မှုန့်အားလုံးကို ဖောင်းပွစီသော တဆီးနန့် တူ၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ထို့နောက် ယေသျှုသည် မြို့ရွာများကို လှည့်လည်၍ လူအပေါင်းရို့အား ဟောပြောသွန်သင်တော်မူလျက် ယေရုဆလင်မြို့သို့ ကြွတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","လူတစ်ယောက်က၊ “အသျှင်ဘုရား၊ ကယ်တင်ခြင်း ခံရသူရို့သည် အရီအတွက်အားဖြင့် နည်းပါ၏လော့” ဟု မိန်းလျှောက်ကြ၏။ ယေသျှုက ထိုသူရို့အား၊ ");
INSERT INTO rki_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“သင်ရို့သည် ကျဉ်းမြောင်းသော တန်းခါးပေါက်သို့ ဝင်ဖို့ ကြိုးစားအားထုတ်ကြလော့။ အကြောင်းမူကား လူများစွာရို့သည် ဝင်ဖို့ ကြိုးစား နိန်ကြသော်လည်း မတတ်နိုင်ကတ်။ ");
INSERT INTO rki_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","အိမ်သျှင်သည်ထ၍ တန်းခါးကို ပိတ်လိုက်ခါမှ၊ သင်ရို့သည် အိမ်အပြင်မှရပ်၍ တန်းခါးကိုခေါက်လျက် ‘ဆရာ၊ အကျွန်ရို့ကို တန်းခါး ဖွင့်ပီးတော်မူပါ’ ဟု တောင်းလျှောက်သော်လည်း၊ အိမ်သျှင်က၊ ‘သင်ရို့တိ ဇာကလာလဲ ဆိုစွာကို ငါမသိ’ ဟု ဆိုလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","ထိုအခါ သင်ရို့က၊ ‘အကျွန်ရို့သည် အသျှင်နန့်အတူ စားသောက်ခပါ၏။ ကိုယ်တော်သည် အကျွန်ရို့မြို့၌လည်း ဟောပြောခပါ၏။’ ");
INSERT INTO rki_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","ယေဒါလေ့ အိမ်သျှင်က၊ ‘သင်ရို့ ဇာကလာသည်ကို ငါမသိ၊ မတရားသောလူတိ ငါ့နားက ထွက်လားကတ်’ ဟု ပြန်၍ ပြောလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","အဗြဟံ၊ ဣဇာက်၊ ယာကုပ်နှင့် ပရောဖက်အပေါင်းရို့သည် ဘုရားသခင်၏ နိုင်ငံတော်ထဲသို့ ရောက်ခသည်ကို မြင်လျက်ပင် သင်ရို့သည် အပြင်ဖက်ကို နှင်ထုတ်ခြင်းခံရသောအခါ ငိုကြွီးခြင်း၊ အံသွားခဲကြိတ်ခြင်း ဟိကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","လူရို့သည် အရှိ့၊ အနောက်၊ တောင်၊ မြောက် အရပ်လေးမျက်နှာမှ လာ၍ ဘုရားသခင်၏ နိုင်ငံတော်ပွဲ၌ ဝင်ကြရလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ထိုအခါ အဂု နောက်ကျသောလူတိသည် အယင်ကျပြီး အယင်ကျသော လူတိ နောက်ကျလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","ထိုအချိန်တွင် ဖာရိယှဲတချို့သည် ယေသျှုထံပါးကို လာပြီးလျှင်၊ “ဟေရုဒ်သည် ကိုယ်တော့်ကို အသီသတ်လိုသည် ဖြစ်၍ ဤအရပ်မှ ထွက်လားပြီး အခြားသော အရပ်သို့ ကြွတော်မူပါ” ဟု ကိုယ်တော့်ကို လျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ယေသျှုက “ငါသည် ဤနိ့နှင့် နက်ဖြန်နိ့၌ နတ်ဆိုးတိကို နှင်ထုတ်ပြီးလျှင် အနာရောဂါတိကို ပျောက်စီမည်။ သုံးရက်မြောက်သော နိ့၌ကား ငါ့အလုပ်ကို အဆုံးသတ်မည်ဖြစ်ကြောင်း၊ လား၍ ထိုမြီခွီးကို ပြောလော့။ ");
INSERT INTO rki_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","သို့သော်လည်း ဤနိ့၊ နက်ဖြန်၊ သန်ဘက်ခါနိ့တိ၌ ငါခရီးလားရဦးမည်။ ပရောဖက်ဟူသည် ယေရုဆလင်မြို့မှတစ်ပါး အခြားအရပ်၌ အသီမခံရ။ ");
INSERT INTO rki_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“အို၊ ယေရုဆလင်မြို့၊ ယေရုဆလင်မြို့၊ သင်သည် ပရောဖက်တိကို အသီသတ်သည့်မြို့၊ ဘုရားသခင် ရွှတ်လိုက်သော တမန်တိကိုလည်း ကျောက်ခဲနန့် ပစ်သည့်မြို့၊ ကြက်မက ကြက်ချေတိကို မိမိအတောင် အောက်၌ စုသိမ်းထားသကဲ့သို့ ငါလည်း သင်၏လူတိကို စုသိမ်းထားလိုသည်မှာ အကြိမ်ပေါင်း များလီဗျာယ်။ သို့သော်လည်း သင်ကား ငါ့ကို ဤသို့ မပြုစီချင်။ ");
INSERT INTO rki_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","သို့ဖြစ်၍ သင်ရို့၏ ဗိမာန်ကို ဘုရားသခင် စွန့်တော်မူလိမ့်မည်။ သင့်အား ငါဆိုသည်ကား၊ ‘ဘုရားသခင်၏ နာမတော်နှင့် ကြွလာတော်မူသော အသျှင်သည် မင်္ဂလာဟိစီသတည်း’ ဟု သင်မြွက်ဆိုသည့် နိ့မတိုင်ခင် သင်သည် ငါ့ကို မြင်ရလိမ့်မည် မဟုတ်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ဥပုသ်နိ့တစ်နိ့၌ ယေသျှုသည် အစားအစာ သုံးဆောင်တော်မူရန် ဖာရိယှဲ အကြီးအကဲတစ်ဦး၏ အိမ်သို့ ဝင်တော်မူ၏။ ထိုအခါ လူအပေါင်းရို့သည် ယေသျှုကို အနီးကပ် စောင့်ကြည့်နိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","လက်နှင့်ခြီတွင် ရီဖျဉ်းနာ စွဲနိန်သူတစ်ယောက်သည် ယေသျှု၏ရှိ့တော်၌ ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ထိုအခါ ယေသျှုကလည်း “ဥပုသ်နိ့၌ အနာပျောက်ကင်းခြင်းသည် တရားတော်နန့် ညီသလော၊ မညီသလော” ဟု ကျမ်းတတ်ဆရာရို့နှင့် ဖာရိယှဲရို့ကို မိန်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","သို့သော်လည်း သူရို့သည် တိတ်တိတ်နိန်ကြ၏။ ယေသျှုက လူနာကိုခေါ်လျက် ရောဂါကို ပျောက်စီပြီးလျှင် သူအား ပြန်လားစီတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ထို့နောက် ကိုယ်တော်က “သင်ရို့အထဲက ဇာသူမဆို ကိုယ့်သားဖြစ်စီ၊ နွားဖြစ်စီ ဥပုသ်နိ့၌ ရီတွင်းထဲသို့ ကျလားခလျှင် ချက်ချင်းမဆွဲတင်ဘဲ နိန်ကြမည်လော့” ဟု မိန်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","သို့သော်လည်း သူရို့သည် ဤအကြောင်းအရာနှင့်ပတ်သတ်၍ အဖြေမပီးနိုင်ကြပေ။ ");
INSERT INTO rki_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ခေါ်ဖိတ်ထားသော သူရို့သည် အကောင်းဆုံးသော နီရာများ ရွီးချယ်နိန်ကြကြောင်းကို ယေသျှုသည် သတိထားမိ့တော်မူသောအခါ၊ ထိုသူရို့အား ပုံဥပမာတစ်ခုဖြင့် မိန့်တော်မူသည်ကား၊ ");
INSERT INTO rki_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“သင်သည် မင်္ဂလာဆောင်ပွဲ၌ ဖိတ်ခေါ်ခြင်းခံရသောအခါ အကောင်းဆုံးသောနီရာတွင် မထိုင်ကေ့။ မထင်မှတ်ဘဲ သင့်ထက် ဂုဏ်အသရေဟိသော လူတစ်ယောက်ကို ဖိတ်ခေါ်ထားလို့ဟိလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","သင်ရို့နှစ်ဦးလုံးကို ဖိတ်ခေါ်ထားသော ပွဲသျှင်သည် သင်ရို့ပါးကိုလာပြီး ‘ဤသူ့ကို နီရာပီးလိုက်ပါ’ ဟု ပြောလိမ့်မည်။ ထိုအခါ သင်သည် အရှက်ရပြီး အနိမ့်ဆုံးနီရာတွင် ထိုင်ရလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","ထို့ကြောင့် သင်သည် ဖိတ်ခေါ်ခြင်းကို ခံရလျှင် လားပြီး အနိမ့်ဆုံးနီရာ၌ ထိုင်ပါ။ ထိုသို့ ထိုင်လို့ဟိလျှင် ပွဲသျှင်သည်လာ၍ ‘အဆွီ၊ ကောင်းသောနီရာသို့ ကြွပါ’ ဟု သင့်အား ဆိုလိမ့်မည်။ ထိုအခါ သင်သည် ဖိတ်ထားခံရသော လူတိရှိ့၌ ဂုဏ်သရေ ဟိလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","အကြောင်းမူကား ကိုယ့်ကိုကိုယ် ချီးမြှောက်သောသူရို့သည် နှိမ့်ချခြင်းကို ခံရပြီး ကိုယ့်ကိုကိုယ် နှိမ့်ချသောသူရို့သည် ချီးမြှောက်ခြင်း ခံရလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ထို့နောက် ယေသျှုက အိမ်သျှင်အား၊ “သင်သည် မိုးသောက်စာဖြစ်စီ၊ ညစာဖြစ်စီ ကျွေးမွေးဖို့လုပ်သောအခါ အဆွီခင်ပွန်း၊ ညီအစ်ကို၊ ဆွီမျိုးတိ၊ ချမ်းသာသော အိမ်နီးချင်းတိကို မဖိတ်ခေါ်ကေ့။ ဖိတ်ခေါ်ခကေကား သင့်ကို ပြန်ဖိတ်ခေါ်ပြီးလျှင် ကျေးဇူးဆပ်ကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","သို့သော် သင်သည် ဧည့်ခံပွဲ ပြုလုပ်သောအခါ၌ ဆင်းရဲသူ၊ မသန်စွမ်းသူ၊ ဒုက္ခိတ၊ မျက်ကန်းတိကို ဖိတ်ခေါ်လော့။ ");
INSERT INTO rki_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ထိုသို့ ဖိတ်ခေါ်လျှင် သင်သည် မင်္ဂလာဟိလိမ့်မည်။ အကြောင်းမူကား သူရို့သည် သင့်ကို ပြန်ပြီး ကျေးဇူးမဆပ်နိုင်သဖြင့် ဖြောင့်မတ်သောသူရို့၏ ရှင်ပြန်ထမြောက်သော နိ့၌ သင်သည် ကျေးဇူးဆပ်ခြင်းကို ခံရလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ယေသျှုနှင့်အတူ စားပွဲ၌ထိုင်နိန်သော လူတစ်ယောက်သည် စကားတော်ကိုကြားလျှင် ယေသျှုအား၊ “ဘုရားသခင်၏ နိုင်ငံတော်၌ ပွဲဝင်ရသောသူသည် မင်္ဂလာဟိပါ၏” ဟု လျှောက်၏။ ");
INSERT INTO rki_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ယေသျှုကလည်း၊ “လူတစ်ယောက်သည် ကျွေးမွေးဧည့်ခံပွဲကြီးကို ကျင်းပရန် လူအများကြီးကို ခေါ်ဖိတ်ခလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ပွဲခံချိန်ရောက်သောအခါ ဖိတ်ခေါ်ထားသော လူတိပါးကို အခိုင်းအစီတစ်ယောက်အား ရွှတ်လိုက်ပြီးလျှင် ‘လာကတ်ပါ၊ အားလုံးအဆင်သင့် ဖြစ်နိန်ဗျာယ်’ ဟု ပြောကြားစီ၏။ ");
INSERT INTO rki_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","သို့သော်လည်း သူရို့အားလုံးက တစ်ယောက်ပြီးတစ်ယောက် ခွင့်တောင်းကြ၏။ ပထမလူက ‘အကျွန်သည် လယ်တစ်ကွက် ဝယ်ထားသည်ဖြစ်၍ ထိုလယ်ကို လား၍ ကြည့်ခြင်းငှာ အကျွန့်ကို ခွင့်ပီးဖို့ တောင်းပန်ပါ၏’ ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","နောက်တစ်ယောက်က ‘အကျွန်က နွားငါးရှဉ်းကို ဝယ်ထားလို့ လားပြီး ကျင့်ခိုင်းရပါမည်၊ အကျွန့်ကို ခွင့်ပီးဖို့ တောင်းပန်ပါ၏’ ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","အခြားတစ်ယောက်က ‘အကျွန်က အဂု အိမ်ထောင်ပြုခါစဖြစ်လို့ မလာနိုင်ပါ’ ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","အခိုင်းအစီသည် မိမိသခင်ထံပါးသို့ ပြန်လာပြီးလျှင် ထိုအကြောင်းအရာတိကို လျှောက်လေ၏။ ထိုအခါ အိမ်သျှင်သည် စိတ်ဆိုးပြီးလျှင် ‘မြို့၏လမ်းမ၊ လမ်းကြားကို အယင်လား၍ ဆင်းရဲသူ၊ မသန်စွမ်းသူ၊ မျက်စိကန်းသူ၊ ဒုက္ခိတတိကို ခေါ်လာလော့’ ဟု အခိုင်းအစီအား စီခိုင်းလိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","မကြာခင် အခိုင်းအစီသည် ‘သခင် ခိုင်းလိုက်သည်အတိုင်း ဆောင်ရွက်ပြီးပါဗျာယ်။ ယေဒါလေ့ နီရာလပ်ဟိပါသိမ့်၏’ ဟု လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ထို့ကြောင့် သခင်က ‘တောလမ်း၊ လမ်းမတိကို လားပြီး အိမ်ပြည့်အောင် လူတိကို ရအောင် ခေါ်လာလော့။ ");
INSERT INTO rki_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","အထက်က ငါဖိတ်ခေါ်ထားသောလူ တစ်ယောက်မျှ ငါ၏ စားသောက်ပွဲကို မြည်းစမ်းရမည် မဟုတ်ဟု သင်ရို့အား ငါဆို၏’” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","များစွာသော လူထုပရိသတ်အပေါင်းရို့သည် ယေသျှုနှင့်အတူ လိုက်လားကြ၍ ကိုယ်တော်သည် ထိုသူရို့အား လှည့်ကြည့်တော်မူပြီးလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“ငါ့ထံသို့ လာသောသူသည် ငါ့ကို ချစ်သည်ထက် မိဖ၊ သားမယား၊ ညီအစ်ကိုမောင်နှမနှင့် ကိုယ့်ကိုကိုယ် ချစ်သောသူသည် ငါ့တပည့် မဖြစ်နိုင်။ ");
INSERT INTO rki_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ကိုယ့်လက်ဝါးကပ်တိုင်ကို ထမ်း၍ ငါ့နောက်သို့ မလိုက်သောသူသည်လည်း ငါ့တပည့် မဖြစ်နိုင်။ ");
INSERT INTO rki_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","သင်ရို့ထဲမှ လူတစ်ယောက်သည် တိုက်တစ်လုံးတည်ဆောက်ရန် အကြံဟိလျှင်၊ ပြီးစီးအောင် ဆောက်ဖို့အတွက် ငွီအလုံလောက်ဟိသည်၊ မဟိသည်ကိုသိဖို့ အယင်ထိုင်ပြီး မတွက်ချက်ဘဲ နိန်မည်လော။ ");
INSERT INTO rki_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","ထိုသို့ တွက်ချက်မကြည့်ဘဲ တိုက်မြစ်ချ၍ အဆုံးသတ်နိုင်စွမ်း မဟိလျှင် မြင်ကြသောလူတိက ထိုလူကို လှောင်ပြောင်ကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘ဤသူကား တည်ဆောက်မှုကို အစပြု၏။ သို့သော်လည်း အဆုံးသတ်နိုင်စွမ်း မဟိပါတကား’ ဟု ဆိုကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","တနည်းကား သျှင်ဘုရင်တစ်ပါးသည် အခြားဘုရင်တစ်ပါးနှင့် စစ်ပြိုင်ဖို့ အကြံဟိလျှင်၊ စစ်သည် ၂၀,၀၀၀ နှင့် ချီလာသောဘုရင်ကို စစ်သည် ၁၀,၀၀၀ နှင့် ခုခံ နိုင်မည်လော ဆိုသည်ကို အယင်ထိုင်၍ မစဉ်းစားဘဲ နိန်မည်လော။ ");
INSERT INTO rki_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","အကယ်၍ မခုခံနိုင်လျှင် စစ်ချီလာသောဘုရင် အဝီး၌ဟိနိန်စဉ် တမန်တိကို ရွှတ်၍ စစ်ပြေငြိမ်းရေးစကားကို ကမ်းလှမ်းရလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","ထိုနည်းအတိုင်း၊ သင်ရို့ထဲက ဇာသူမဆို ကိုယ့်၌ဟိသမျှတိကို မစွန့်လျှင် ငါ့တပည့် မဖြစ်နိုင်။” ");
INSERT INTO rki_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“ဆားသည် ကောင်း၏။ သို့သော်လည်း အငန်ကင်းပျောက်လျှင် ငန်သောအရသာကို ပြန်၍ မရနိုင်။ ");
INSERT INTO rki_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","မြီဖို့ဖြစ်စီ၊ မြီသြဇာဖို့ဖြစ်စီ အသုံးမဝင်သဖြင့် အပြင်သို့ ဝေးပစ်လိုက်ကြ၏။ “ကြားစရာနားဟိသော လူကား ကြားပါစီ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","တစ်နိ့၌ အခွန်ခံသူများနှင့် အပြစ်သားအပေါင်းရို့သည် ယေသျှု၏တရားစကားကို နားထောင်ရန် အထံတော်သို့ လာကြသောအခါ၊ ");
INSERT INTO rki_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ဖာရိယှဲနှင့် ကျမ်းတတ်ဆရာရို့က “ဤသူသည် အပြစ်သားတိကို လက်ခံပြီးလျှင် သူရို့တိနှင့်အတူ စားသောက် နိန်ပါသည်တကား” ဟု စတင်၍ ညည်းတွားပြောဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ထို့ကြောင့် ယေသျှုသည် သူရို့အား ပုံဥပမာဆောင်လျက် ပြောကြားတော်မူသည်မှာ၊ ");
INSERT INTO rki_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“သင်ရို့ထဲက တစ်ယောက်သောသူ၌ သိုးအကောင်တစ်ရာဟိပြီး၊ တစ်ကောင်ပျောက်လားလျှင် ဇာပိုင် လုပ်ကြမည်နည်း။ သူသည် သိုးကိုးဆယ်ကိုးကောင်ကို စားကျက်တွင်ထားခပြီး ပျောက်လားသော သိုးတစ်ကောင်ကို လား၍ ရှာလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ထိုသိုးကို တွိ့သောအခါ သူသည် ပျော်ရွှင်စွာဖြင့် မိမိ၏ပခုံးထက်တွင် ထမ်းလာလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","သူသည် အိမ်သို့ ပြန်ရောက်သောအခါ မိမိ၏အဆွီခင်ပွန်းတိနှင့် အိမ်နီးချင်းတိကို ခေါ်၍ ‘ငါသည် ပျောက်လားခသောသိုးကို ပြန်တွိ့သည်ဖြစ်၍ ငါနန့်အတူ ဝမ်းမြောက်ပျော်ရွှင်ကြလော့’ ဟု ဆိုလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","ယင်းနည်းတူ နောင်တမရသော ဂုဏ်သရေဟိသောလူ ကိုးဆယ်ကိုးယောက်ထက် နောင်တရသော အပြစ်သားတစ်ယောက်အတွက် ကောင်းကင်ဘုံ၌ သာ၍ ဝမ်းမြောက်ရွှင်လန်းစရာဖြစ်လိမ့်မည်ဟု သင်ရို့ကို ငါဆို၏” ဟူ၍ ဖြစ်သတည်း။ ");
INSERT INTO rki_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“မိန်းမတစ်ယောက်မှာ ငွီဒင်္ဂါးဆယ်ပြားဟိစွာထဲက တစ်ပြားပျောက်လားခလျှင်၊ သူမသည် ဆီမီးခွက်ထွန်းလျက် မိမိ၏အိမ်ကို လှဲကျင်းကာ မတွိ့မချင်း စိ့စိ့စပ်စပ် ရှာမည် မဟုတ်လော။ ");
INSERT INTO rki_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","သူမသည် ဒင်္ဂါးပြားကို တွိ့သောအခါ မိမိ၏အဆွီခင်ပွန်း၊ အိမ်နီးချင်းတိကို ခေါ်၍ ‘ပျောက်လားခသောဒင်္ဂါးကို ငါပြန်တွိ့ဗျာယ်၊ ငါနန့်အတူ ဝမ်းမြောက်ကြလော့’ ဟု ဆိုလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","ယင်းနည်းတူ အပြစ်သားတစ်ယောက် နောင်တရခြင်းသည် ဘုရားသခင်၏ ကောင်းကင်တမန်ရို့ရှိ့၌ ဝမ်းမြောက်ရွှင်လန်းစရာဖြစ်၏ဟု သင်ရို့ကို ငါဆိုသတည်း” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ယေသျှုက “လူတစ်ယောက်မှာ သားနှစ်ယောက် ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","သားငယ်က မိမိ၏ဖခင်အား ‘အဘာ၊ အကျွန်၏ အမွီရပိုင်ခွင့်ကို ခွဲဝီပီးပါ’ ဟု ဆို၏။ ထို့ကြောင့် ဖခင်က မိမိ၏ဥစ္စာကို သားနှစ်ယောက်အား ခွဲဝီပီးလိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ထို့နောက် ရက်အနည်းချေ ကြာသောအခါ သားငယ်သည် မိမိဥစ္စာပစ္စည်းအားလုံးကို ရောင်းချပြီးလျှင် ရသောဖဲသာတိကို ယူ၍ ဝီးသောတိုင်းပြည်သို့ ထွက်လားလေ၏။ သူသည် ထိုပြည်တွင် အပျော်အပါးလိုက်စားကာ ဖဲသာတိကို ဖြုန်းတီးပစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ဟိသမျှဖဲသာ ကုန်လားသောအခါ ထိုတိုင်းပြည်တစ်ပြည်လုံး၌ အလွန်အစာခေါင်းပါးခြင်း ဖြစ်သဖြင့် သူလည်း ငတ်ပြတ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ထိုအခါ သူသည် ထိုပြည်သားတစ်ယောက်ပါးသို့ လား၍ အငှားခံလေ၏။ အလုပ်သျှင်က သူ့အား မိမိ၏လယ်ထဲသို့ ဝက်စာပီးရန် ရွှတ်လိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","သူသည် ဝက်တိစားနိန်သော ပဲတောင့်ကိုပင် စားချင်လောက်အောင် ငတ်မွတ်သော်လည်း ဇာသူမှလည်း သူအား အစာကို မကျွေးကြ။ ");
INSERT INTO rki_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ထိုအခါ သူသည် အမြင်မှန်ရပြီးလျှင်၊ ‘ငါ့အဖ၏ အငှားသားတိတောင်မှ အစာကို ဝမ်းဝအောင် စားကြရ၏။ ငါမူကား ဤနီရာ၌ သီလောက်အောင် ငတ်မွတ်နိန်ယာ။ ");
INSERT INTO rki_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ငါသည် ဤအရပ်မှ ထွက်ခွါ၍ ငါ့အဖပါးသို့ ပြန်လားပြီးလျှင်၊ အဘာ၊ အကျွန်သည် ဘုရားသခင်ကိုလည်းကောင်း အဖကိုလည်းကောင်း ဆန့်ကျင်၍ ပြစ်မှားမိပါဗျာယ်။ ");
INSERT INTO rki_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","အကျွန်သည်ကား အဖ၏သားဟူ၍ ခေါ်ခြင်းငှာ မထိုက်တန်ယာ၊ အဖ၏အငှားသားတစ်ယောက်ကဲ့သို့ အကျွန့်ကို မှတ်တော်မူပါ’ ဟု ပြောမည့်အကြံဖြင့်၊ ");
INSERT INTO rki_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","သူသည် ထ၍ မိမိ၏အဖပါးသို့ ပြန်လားလေ၏။ “သို့ရာတွင် သူ၏ဖခင်သည် အဝီးကပင် သူ့ကို မြင်လျှင် အလွန်သနားသော စိတ်ဖြင့် မိမိသားပါးသို့ ဗြီးလားပြီးလျှင် သားကို ဖက်၍ နမ်းလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","သားဖြစ်သူက ‘ဘာဘာ၊ အကျွန်သည် ဘုရားသခင်ကိုလည်းကောင်း အဘာကိုလည်းကောင်း ဆန့်ကျင်၍ ပြစ်မှားမိပါဗျာယ်၊ အဘာ၏သားဟူ၍ ခေါ်ခြင်းငှာ မထိုက်တန်ယာ’ ဟု ဖခင်အား ပြော၏။ ");
INSERT INTO rki_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","သို့ရာတွင် ဖခင်က မိမိ၏အခိုင်းအစီတိအား ‘အယင်လာကတ်၊ အကောင်းဆုံးဝတ်ရုံကို ယူလာပြီးလျှင် သူ့အား ဝတ်ပီးကတ်။ သူ့လက်၌ လက်စွပ်ကို ဝတ်ပီးပြီးလျှင် သူ့ခြီထောက်မှာ ဖိနပ်ကိုလည်း စီးပီးကတ်။ ");
INSERT INTO rki_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ပြီးလျှင် ဆူဖြိုးအောင် ကျွေးထားသော နွားပေါက်ချေကို သတ်ပြီးလျှင် ငါရို့တိ ပျော်ပွဲစားကြကုန်အံ့။ ");
INSERT INTO rki_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","အကြောင်းမူကား ငါ၏သားသည် သီကျလားပြီး တဖန်ပြန်၍ အသက်ရှင်လာ၏။ ပျောက်ဆုံးလားခပြီး ပြန်တွိ့ရ၏’ ဟု ဆိုလေ၏။ ထို့နောက် သူရို့သည် ပျော်ပွဲစားကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“ယင်းအချိန်၌ သားကြီးဖြစ်သူသည် လယ်ထဲ၌ ရောက်နိန်၏။ သူသည် ပြန်လာ၍ အိမ်နားသို့ ရောက်သောအခါ တီးမှုတ် ကခုန်သံကို ကြားရ၏။ ");
INSERT INTO rki_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ထို့ကြောင့် သူသည် အခိုင်းအစီတစ်ယောက်ကို ခေါ်ပြီး ‘ဇာတိ လုပ်နိန်ကတ်လဲ’ ဟု သူ့အား မိန်း၏။ ");
INSERT INTO rki_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","‘သခင်၏ညီသည် အိမ်ကို ပြန်ရောက်လာဗျာယ်၊ သို့ဖြစ်၍ သခင်၏အဖသည် ဘေးမသီ ရန်မခ မိမိသားကို ပြန်ရသောကြောင့် ဝအောင် ကျွေးထားသော နွားပေါက်ချေကို ပေါ်လိုက်ပါ၏’ ဟု အခိုင်းအစီက ပြန်ပြော၏။ ");
INSERT INTO rki_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","သားကြီးသည် စိတ်ဆိုး၍ အိမ်ထဲသို့ မဝင်ဘဲနိန်၏။ ထို့ကြောင့် သူ၏ဖခင်သည် အပြင်ကို ထွက်လာပြီးလျှင် သားဖြစ်သူကို အိမ်ထဲသို့ဝင်ရန် ဖျောင်းဖျလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","သို့သော်လည်း သားကြီးက ‘စဉ်းစားကြည့်ပါ၊ အကျွန်သည် နှစ်ပေါင်းများစွာ အဖကို အလုပ်အကျွေးပြုလျက် အဖ၏ စီခိုင်းချက်များကိုလည်း တစ်ခါချေတောင်မှ မလွန်ဆန်ခပါ။ သို့သော်လည်း အဖသည် အကျွန်၏သူငယ်ချင်းတိနှင့်အတူ ပျော်ပွဲစားခြင်းငှာ ဆိတ်တစ်ကောင်တောင် အကျွန့်အတွက် မပီးဖူးပါကား။ ");
INSERT INTO rki_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","သို့ရာတွင် အဖ၏ဥစ္စာတိကို မိန်းမပျက်တိနှင့် ပျော်ပါးကာ ဖြုန်းတီးပစ်ခသော အဖ၏သား အိမ်သို့ ပြန်လာသောအခါ အဖသည် သူ့အတွက် ဝအောင် ကျွေးထားသော နွားပေါက်ချေကို ပေါ်ပီးပါသည်တကား’ ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","အဖက ‘ငါ့သား၊ သင်သည် ငါနန့်အတူ အမြဲနီ၏။ ငါမှာ ဟိသမျှသောအရာသည် သင်၏ဥစ္စ္စာဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","သို့ရာတွင် ငါရို့မှာ ပျော်ပွဲစား၍ ဝမ်းသာစရာအကြောင်း ဟိ၏၊ အကြောင်းမူကား သင်၏ညီသည် သီကျလားခပြီးလျှင် အသက်ပြန်ရှင်လာ၏။ ပျောက်ဆုံးလားခပြီးလျှင် ပြန်တွိ့ရ၏၊’” ဟူ၍ မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ယေသျှုသည် တပည့်တော်ရို့အား၊ “တစ်ခါက သူဌေးတစ်ဦး၌ အခိုင်းအစီ ဘဏ္ဍာစိုး တစ်ယောက်ဟိ၏။ ထိုသူသည် သခင်၏ ဥစ္စာပစ္စည်းတိကို သုံးဖြုန်းနိန်ကြောင်းကို လူတိက သူဌေးအား တိုင်တန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","သူဌေးသည် သူ့ကို ခေါ်ပြီး ‘သင်၏အကြောင်းကို ငါကြားရသည်မှာ ဇာပိုင်လဲ။ သင့်လက်ထဲ၌ဟိသော ငါ့ဥစ္စာတိကို တင်ပြပါ။ သင်သည် ဆက်ပြီး ငါ၏ဘဏ္ဍာစိုး လုပ်ရလိမ့်မည် မဟုတ်’ ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ဘဏ္ဍာစိုးက၊ ‘ငါ ဇာပိုင် လုပ်ရမည်နည်း၊ ငါ့သူဌေးက ဘဏ္ဍာစိုးအရာကို နုတ်လားခဗျာယ်။ လယ်လုပ်ဖို့ ခွန်အားလည်း ငါ့မှာမဟိ၊ တောင်းစားဖို့လည်း ရှက်ဖို့ကောင်း၏။ ");
INSERT INTO rki_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ရာထူးပြုတ်ပြီးနောက် မိတ်ဆွီတိက ငါ့ကို သူရို့အိမ်၌ လက်ခံစီခြင်းငှာ ဇာပိုင်လုပ်ရမည်ကို ငါသိ၏’ ဟူ၍ တကိုယ်တည်း ပြောဆိုကာ။ ");
INSERT INTO rki_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","သူ၏ သခင်ကို အကြွီးပီးရမည့်သူ အားလုံးကို ခေါ်၍ ပထမလူအား ‘ငါ့သူဌေးကို သင်ပီးဖို့ အကြွီး ဇာလောက်ဟိသနည်း၊’ ဟု မိန်း၏။ ");
INSERT INTO rki_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ထိုသူက ‘သံလွင်ဆီ ဂါလံ ၈၀၀ ဟိပါ၏’ ဟု ပြန်ပြော၏။ ထိုအခါ ဘဏ္ဍာစိုးက၊ ‘သင်၏စာရင်းကို ယူလိုက်၊ ဂါလံ ၄၀၀ လို့ ထိုင်ပြီးလျှင် မှတ်လိုက်’ ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","ထို့နောက် အခြားတစ်ယောက်အား ‘သင်သည်လည်း အကြွီးဆပ်ဖို့ ဇာလောက်ဟိသနည်း’ ဟု မိန်း၏။ ထိုသူက ‘ဂျုံစပါးတင်း ၁,၀၀၀ ဟိပါ၏’ ဟု ဆိုလျှင်၊ ‘သင်၏စာရင်းတွင် တင်း ၈၀၀ လို့ မှတ်လိုက်’ ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","ထိုအခါ သူဌေးသည် သစ္စာမဟိသော ဘဏ္ဍာစိုး၏ လိမ္မာပါးနပ်စွာပြုသော လုပ်ဆောင်ချက်အတွက် သူ့ကို ချီးမွမ်းလေ၏။ အကြောင်းမူကား ဤလောကသားတိသည် လောကီကိစ္စဆောင်ရွက်ရာ၌ အလင်း၏ သားသမီးတိထက် လိမ္မာပါးနပ်ကြ၏။” ");
INSERT INTO rki_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“တဖန် ငါဆိုသည်ကား၊ လောကီစည်းစိမ်ချမ်းသာအားဖြင့် အဆွီခင်ပွန်းရအောင် ပြုကြလော့။ သို့ပြုလျှင် စည်းစိမ်ချမ်းသာကုန်ဆုံးသောအခါ သင်ရို့ကို ထာဝရအိမ်တော်၌ ကြိုဆိုလက်ခံလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","သေးငယ်သည့်အမှု၌ သစ္စာဟိသူသည် ကြီးသောအမှု၌လည်း သစ္စာဟိလိမ့်မည်။ သေးငယ်သောအမှု၌ သစ္စာမဟိသူကား ကြီးသောအမှု၌လည်း သစ္စာမဟိနိုင်။ ");
INSERT INTO rki_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","သို့ဖြစ်၍ သင်ရို့သည် လောကီစည်းစိမ်ကို အသုံးပြုရာတွင် သစ္စာမဟိလျှင် သင်ရို့ကို မှန်သော စည်းစိမ်ချမ်းသာကို အပ်ဖို့ ဇာသူက ယုံနိုင်မည်နည်း။ ");
INSERT INTO rki_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","သင်ရို့သည် သူတစ်ပါး၏ ပစ္စည်းဥစ္စာနှင့်ပတ်သတ်၍ သစ္စာမဟိလျှင် ဇာသူက သင်ရို့ကို အပိုင်ပီးမည်နည်း။ ");
INSERT INTO rki_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“မည်သည့် အခိုင်းအစီတစ်ယောက်မျှ သခင်နှစ်ဦး၏ အခိုင်းအစီကို မခံနိုင်။ သခင်တစ်ဦးကို မုန်း၍ တစ်ဦးကို ချစ်လိမ့်မည်။ တစ်ဦးကို သစ္စာဟိပြီး တစ်ဦးကို မလိ့မခန့် ပြုလိမ့်မည်။ သင်ရို့သည် တစ်ချိန်တည်း၌ ဘုရားသခင်၏ အခိုင်းအစီနှင့် လောကစည်းစိမ်၏ အခိုင်းအစီကို မခံနိုင်ကတ်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ငွီကို တပ်မက်သော ဖာရိယှဲရို့သည် ထိုစကားကိုကြားလျှင် ယေသျှုကို ပြက်ရယ်ပြုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ယေသျှုက “သင်ရို့သည် လူတိရှိ့၌ မိမိကိုယ်ကို ဖြောင့်မတ်ယောင်ဆောင်သော်လည်း၊ ဘုရားသခင်က သင်ရို့စိတ်နှလုံးကို သိတော်မူ၏။ လူတိ အမြတ်တနိုးထားသောအရာသည် ဘုရားသခင်၏ ရှိ့တော်၌ စက်ဆုပ်ဖွယ်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“ပညတ်ကျမ်းနှင့် ပရောဖက်ကျမ်းများသည် ဗတ္တိဇံဆရာ ယောဟန်လက်ထက် တိုင်အောင် သက်ရောက်လျက် ဟိ၏။ ယောဟန်လက်ထက်မှစ၍ ဘုရားသခင်၏ နိုင်ငံတော်အကြောင်း သတင်းကောင်းကို ဟောပြောလျက်ဟိ၏။ လူအပေါင်းရို့သည် နိုင်ငံတော်သို့ အနိုင်အထက် တိုးဝင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","သို့ရာတွင် ပညတ္တိကျမ်း၌ ဗိန္ဓုတစ်လုံး ပျက်စီးမည်ထက် ကောင်းကင်နှင့် မြီကြီး ပျက်စီးရန် ပိုလွယ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“အကြင်သူသည် မိမိမယားနှင့် ကွာ၍ အခြားသောမိန်းမနှင့် လက်ထပ်လျှင် ကာမဖောက်ပြားသောသူ ဖြစ်၏။ ကွာယှင်းထားသော မိန်းမနှင့် လက်ထပ်သောသူကလည်း ကာမဖောက်ပြားသောသူ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“တစ်ခါက သူဌေးတစ်ဦးသည် ကမ္ဗလာနီနှင့် ပိတ်ချောကို နိ့တိုင်းဝတ်ဆင်၍ စည်းစိမ်ခံစားနိန်၏။ ");
INSERT INTO rki_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","လာဇရုနာမည်ဟိသော သူဆင်းရဲတစ်ယောက်သည် ခန္ဓာတစ်ခုလုံး သွီးစုနာပေါက်၍ သူဌေး၏ အိမ်တန်းခါးနား၌ တုံးလုံးလဲ နိန်၏။ ");
INSERT INTO rki_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","သူသည် သူဌေးစားပွဲမှကျသော စားကြွင်းစားကျန်တိကို စားရဖို့ တောင့်တနိန်၏။ ခွီးတိကလည်း သူ၏ သွီးစုနာတိကို လာ၍ လျက်နိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“ဆင်းရဲသားသည် သီလွန်၍ ကောင်းကင်တမန်ရို့သည် သူ့ကို အာဗြဟံ၏ ရင်ခွင်ပါးသို့ ယူဆောင်လားကြ၏။ သူဌေးကလည်း သီဆုံး၍ သင်္ဂြိုဟ်ခြင်းကို ခံရ၏။ ");
INSERT INTO rki_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","သူသည် မရဏာနိုင်ငံတွင် ဝေဒနာကို ပြင်းစွာ ခံစားနိန်သောကြောင့် အထက်သို့ မျှော်ကြည့်လိုက်သောအခါ အဗြဟံကိုလည်းကောင်း၊ အာဗြဟံရင်ခွင်၌ လာဇရုကိုလည်းကောင်း မြင်ရလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ထို့ကြောင့် သူဌေးကလည်း၊ ‘အဖအာဗြဟံ၊ အကျွန့်ကို သနားပါ။ အကျွန်သည် ဤမီးတောက်ထဲ၌ ဝေဒနာကို ပြင်းထန်စွာ ခံစားနိန်ရပါ၏။ လာဇရု၏ လက်ဖျားကို ရီမှာနှိုက်ပြီး အကျွန့်လျှာကို အီးစီဖို့ သူ့ကို အကျွန်ပါးသို့ ရွှတ်ပီးပါ’ ဟု အော်ဟစ် ပြောဆိုလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“သို့သော်လည်း အာဗြဟံက၊ ‘ငါ့သား၊ သင်သည် အသက်ရှင်နိန်စဉ်က သုခချမ်းသာ ခံစားရပြီး လာဇရုက ဆင်းရဲဒုက္ခ ခံခရသည်ကို အောက်မိ့ပါ။ အဂုမှာ သူသည် သက်သာခြင်းကို ခံစားရပြီး သင်ကား ဒုက္ခဝေဒနာ ခံစားနိန်ရ၏။ ");
INSERT INTO rki_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","ထိုမျှမက သင်နှင့် ငါရို့စပ်ကြားတွင် အသူရာချောက်ကြီးတစ်ခု ဟိသဖြင့် သင်ရို့ဖက်မှ ငါရို့ဖက်သို့ လည်းကောင်း၊ ငါရို့ဖက်မှ သင်ရို့ဖက်သို့ လည်းကောင်း ကူးချင်သော်လည်း မကူးနိုင်ကြ’ ဟု ပြန်ပြော၏။ ");
INSERT INTO rki_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","သူဌေးက၊ ‘အဖအာဗြဟံ၊ ဤသို့ဆိုလျှင် လာဇရုကို အကျွန့်အဖအိမ်သို့ ရွှတ်ပီးဖို့ တောင်းပန်ပါ၏။ ");
INSERT INTO rki_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","အကြောင်းမူကား အကျွန့်မှာ ညီငါးယောက် ဟိပါ၏။ သူရို့သည်လည်း ဝေဒနာခံစားရသော ဤအရပ်သို့ မရောက်စီရန် သူ့ကို သတိပီးခိုင်းလိုက်ပါ’ ဟု တောင်းဆိုလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“အာဗြဟံကလည်း၊ ‘သင်၏ ညီအစ်ကိုတိကို သတိပီးရန် မောသျှေမှစ၍ ပရောဖက်တိ ဟိကြ၏။ ထိုသူရို့စကားကို နားထောင်ကတ်ပါစီ’ ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","သူဌေးကလည်း၊ ‘အဖအာဗြဟံ၊ ထိုသို့ မဟုတ်ပါ။ သီလားခသောလူထဲက တစ်ယောက်သည် ထမြောက်၍ သူရို့ပါးသို့ လားလျှင် သူရို့သည် အပြစ်မှ နောင်တရကြပါလိမ့်မည်’ ဟု ပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","အာဗြဟံကလည်း ‘သူရို့သည် မောသျှေနန့် ပရောဖက်စကားတိကို နားမထောင်လျှင်၊ တစ်ယောက်သောသူသည် သီဆုံးခြင်းမှ ထမြောက်သော်လည်း သူရို့ ယုံကြည်ကြလိမ့်မည် မဟုတ် ဟု ဆိုလေ၏’” ဟူ၍ မိန့်တော်မူလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ယေသျှုက၊ “လူသည် အပြစ်ပြုလုပ်နိုင်သည့်အကြောင်း မုချဟိ၏။ သို့သော်လည်း အပြစ်ပြုလုပ်ခြင်းကို ဖြစ်စီသူသည် အမင်္ဂလာဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ဤသူသည် သူငယ်တစ်ယောက်ကို လမ်းလွဲစီသည်ထက် မိမိလိုင်ပင်း၌ ကြိတ်ဆုံကျောက်ကိုဆွဲပြီး ပင်လယ်ထဲသို့ ပစ်ချခံရသည်ကား ပို၍ ကောင်း၏။ ");
INSERT INTO rki_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","သို့ဖြစ်၍ ကိုယ့်ကိုကိုယ် သတိပြုကြလော့။ “သင်၏ညီအစ်ကိုသည် သင့်ကိုပြစ်မှားလျှင် သူ့ကိုဆုံးမလော့။ သူသည် နောင်တရလျှင် သူ့ကို ခွင့်ရွှတ်လော့။ ");
INSERT INTO rki_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","တစ်နိ့တည်းတွင် ခုနစ်ကြိမ်တိုင်တိုင် သင့်ကိုပြစ်မှားပြီး ခုနစ်ကြိမ်တိုင်တိုင် သင့်ပါးသို့လာ၍ ‘ငါနောင်တရပါဗျာယ်’ ဟုဆိုလျှင် သင်သည် သူ၏အပြစ်ကို ခွင့်ရွှတ်ရမည်” ဟု တပည့်တော်ရို့အား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","တမန်တော်ရို့က သခင်ဘုရားအား “အကျွန်ရို့၏ ယုံကြည်ခြင်းကို တိုးပွါးစီတော်မူပါ” ဟု လျှောက်ထားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","သခင်ဘုရားက၊ “သင်ရို့သည် မုံညှင်းစိ့မျှသာ ယုံကြည်ခြင်းဟိလျှင် ဤပိုးစာပင်ကို ‘အမြစ်ပါကျွတ်ပြီး ပင်လယ်ထဲစိုက်နိန်လော့’ ဟု ဆိုလျှင် သင်ရို့စကားကို နားထောင်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“သင်ရို့တွင် လယ်ထွန်သားဖြစ်စီ၊ သိုးကျောင်းသားဖြစ်စီ အခိုင်းအစီတစ်ယောက်ဟိသည်ဟု ဆိုပါစို့။ ထိုသူသည် လယ်ထဲက ပြန်လာသောအခါ ညစာစားဖို့ရန် အယင်လာထိုင် ဟု သင်ရို့ထဲက ဇာသူက ပြောမည်နည်း။ ");
INSERT INTO rki_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ထိုသို့မဆိုဘဲ၊ ‘ငါ့အတွက် ညစာကိုပျင်လိုက်၊ ငါစားသောက်နိန်စဉ် ခါးကိုစည်း၍ ငါ့ကို လုပ်ကျွေးလော့။ ပြီးမှ သင်စားသောက်လော့’ ဟု ဆိုမည် မဟုတ်လော။ ");
INSERT INTO rki_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","အခိုင်းအစီသည် မိမိအသျှင် စီခိုင်းသည့်အတိုင်း ဆောင်ရွက်သောကြောင့် သခင်သည် သူ့အား ကျေးဇူးတင်မည်လော။ ");
INSERT INTO rki_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ထိုနည်းတူ သင်ရို့ကလည်း မိမိရို့အား စီခိုင်းသောအရာအားလုံးကို ဆောင်ရွက်ပြီးစီးချိန်၌ ‘ငါရို့သည်လည်း သာမန်အခိုင်းအစီများပင် ဖြစ်ကြ၏။ ငါရို့ဆောင်ရွက်စရာ တာဝန်ဝတ္တရားကို ဆောင်ရွက်ခြင်းသာဖြစ်သည်’ ဟု ဆိုကြလော” ဟူ၍ မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ယေသျှုသည် ယေရုဆလင်မြို့သို့ ခရီးပြုတော်မူစဉ် ယှာမာရိနယ်နှင့် ဂါလိလဲနယ်စပ်ကြားတလျှောက် ကြွတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ရွာတစ်ရွာသို့ ဝင်သောအခါ နူနာသည်ဆယ်ယောက်သည် ကိုယ်တော့်ကို ခရီးဦးကြိုပြုကြ၏။ သူရို့သည် အဝီးတွင်ရပ်လျက်၊ ");
INSERT INTO rki_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","“ယေသျှု၊ အကျွန်ရို့ကို သနားတော်မူပါ” ဟု ဟစ်အော်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ယေသျှုသည် ထိုသူရို့ကို မြင်တော်မူလျှင်၊ “သင်ရို့သည် ယဇ်ပုရောဟိတ်တိပါးသို့ လား၍ ကိုယ်ကိုပြကြလော့” ဟု မိန့်တော်မူ၏။ သူရို့သည် လားနိန်စဉ် သန့်ယှင်းခြင်းသို့ ရောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","သူရို့အထဲက တစ်ယောက်သည် ရောဂါပျောက်ကင်းကြောင်းကို သိမြင်သောအခါ အထံတော်သို့ ပြန်လာ၍ ဘုရားသခင်၏ ဂုဏ်တော်ကို ကျယ်သောအသံဖြင့် ချီးမွမ်းလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ထို့နောက် ယေသျှု၏ ခြီတော်ရင်းတွင် ပြပ်ဝပ်လျက် ကျေးဇူးတော် ချီးမွမ်းလေ၏။ ထိုသူကား ယှာမာရိအမျိုးသားဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ယေသျှုက “တစ်ကျိပ်သောလူရို့သည် သန့်ယှင်းခြင်းသို့ ရောက်ကြသည် မဟုတ်လော။ ကျန်သော ကိုးယောက်ကား ဇာမှာ ဟိကြသနည်း။ ");
INSERT INTO rki_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ဤတစ်ပါးအမျိုးသား မှတစ်ပါး ဘုရားသခင်၏ ဘုန်းတော်ကို ချီးမွမ်းရန် ပြန်လာသောသူ တစ်ယောက်မျှ မဟိသလော” ဟု မိန်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ထို့နောက် ယေသျှုက “သင်ထ၍ လားလော့။ သင်၏ယုံကြည်ခြင်းသည် သင့်ရောဂါကို ပျောက်စီ ဗျာယ်” ဟု ထိုသူအား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ဖာရိယှဲတချို့က၊ ဘုရားသခင်၏ နိုင်ငံတော်သည် ဇာအချိန်၌ တည်မည်နည်း၊ ဟု ယေသျှုအား မိန်းလျှောက်ကြ၏။ ထိုအခါ ကိုယ်တော်က “ဘုရားသခင်၏ကောင်းကင် နိုင်ငံတော်သည် မြင်နိုင်သည့်အရပ်၌ မတည်။ ");
INSERT INTO rki_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ဤအရပ်၌ကြည့်လော့၊ ထိုအရပ်၌လည်း ကြည့်လော့ဟု မပြောနိုင်။ အကြောင်းမူကား ဘုရားသခင်၏ နိုင်ငံတော်သည် သင်ရို့အထဲ၌ တည်လျက်ဟိသည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ကိုယ်တော်က တပည့်တော်ရို့အား “လူသား၏ နိ့ရက်တစ်ရက်ကို မြင်တွိ့ချင်သော်လည်း မမြင်တွိ့ရသော အချိန်ကာလ ရောက်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","လူတိက ‘လူသားသည် ဤအရပ်၌ ဟိ၏။ ထိုအရပ်၌ ဟိ၏’ ဟု ဆိုသော်လည်း လိုက်ပြီး မရှာကတ်ကေ့။ ");
INSERT INTO rki_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ကောင်းကင်တစ်ဖက်မှ လျှပ်ပြက်သော အလင်းရောင်သည် ကောင်းကင်တစ်ခွင်လုံး ထွန်းတောက်သကဲ့သို့ လူသားသည် မိမိနိ့ရက်၌ ဖြစ်တော်မူလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","သို့သော်လည်း လူသားသည် များစွာသော ဒုက္ခဝေဒနာတိကိုလည်းကောင်း၊ ဤခေတ် လူတိ ငြင်းပယ်ခြင်းကိုလည်းကောင်း ဦးစွာခံရလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","နောဧလက်ထက်၌ ဖြစ်ပျက်သကဲ့သို့ လူသားလက်ထက်တွင်လည်း ဖြစ်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","သင်္ဘောထဲသို့ နောဧဝင်ပြီးနောက် ရီလွှမ်းမိုးလာသဖြင့် လူအားလုံး သီကြီပျက်စီးသည့်နိ့ တိုင်အောင် လူအပေါင်းရို့သည် စားသောက်လျက်၊ အိမ်ထောင်ပြုလျက်နိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ယင်းနည်းတူ လောတလက်ထက်၌ လူအပေါင်းရို့သည် စားသောက် ရောင်းဝယ်လျက်၊ စိုက်ပျိုးတည်ဆောက်လျက်နိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","သောဒုံမြို့မှ လောတ ထွက်ခွါလားသောနိ့တွင် ကောင်းကင်မှ ကန့်နှင့်ရောသော မီးမိုးရွာ၍ သူရို့အားလုံးသည် သီကြီပျက်စီးကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","လူသား ပေါ်ထွန်းတော်မူသော နိ့တွင်လည်း ဤကဲ့သို့ ဖြစ်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“ယင်းနိ့ရက်၌ အိမ်ခေါင်ထက်တွင် ဟိသောသူသည် အိမ်ထဲ၌ဟိသော ဥစ္စာပစ္စည်းကို ယူဖို့ မဆင်းစီကေ့။ ယင်းနည်းတူ လယ်ထဲ၌ဟိသောသူသည် အိမ်မပြန်စီကေ့။ ");
INSERT INTO rki_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","လောတ၏မယားကို အောက်မိ့ကြလော့။ ");
INSERT INTO rki_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","မိမိအသက်ကို ကယ်လိုသောသူသည် အသက်ယှုံးလိမ့်မည်။ ကိုယ့်အသက်ကို ဆုံးယှုံးရသောသူမူကား အသက်ကို ကယ်ဆယ်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","သင်ရို့ကို ငါဆိုသည်ကား၊ ယင်းနိ့ည၌ အိပ်ရာတစ်ခုထဲတွင် အိပ်နိန်သူ လူနှစ်ယောက်ထဲက တစ်ယောက်ကို သိမ်းယူ၍ တစ်ယောက်ကို ထားခလတ္တံ့။ ");
INSERT INTO rki_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ကြိတ်ဆုံကြိတ်နိန်သော မိန်းမနှစ်ယောက်ထဲက တစ်ယောက်ကို သိမ်းယူပြီး တစ်ယောက်ကို ထားခလတ္တံ့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","တပည့်တော်ရို့က “အသျှင်၊ ဇာအရပ်တွင် ဤအရာတိ ဖြစ်ပျက်ပါမည်နည်း” ဟု မိန်းလျှောက်ကြလျှင်၊ ယေသျှုက “အသီကောင်ဟိသောအရပ်၌ လင်းတတိ စုရုံးလာကြလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ထို့နောက် ယေသျှုသည် တပည့်တော်ရို့အား စိတ်အားမလျော့ဘဲ အမြဲတမ်းဆုတောင်းပတ္ထနာ ပြုသင့်ကြောင်းကို ပုံဥပမာဆောင်၍ သွန်သင်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“မြို့တစ်မြို့၌ ဘုရားသခင်ကိုမကြောက်၊ လူ့မျက်နှာကိုမထောက်သော တရားသူကြီးတစ်ယောက် ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","ထိုမြို့၌ဟိသော မုဆိုးမတစ်ယောက်သည် တရားသူကြီးပါးသို့ အကြိမ်ကြိမ်လားပြီး ‘အကျွန့်ဖက်ကနိန်၍ အကျွန့်ကို တရားသဖြင့် စီရင်တော်မူပါ’ ဟု လျှောက်ထား၏။ ");
INSERT INTO rki_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","တရားသူကြီးသည် မုဆိုးမ၏လျှောက်ထားချက်ကို အချိန်ကြာကြာ ငြင်းဆန်နိန်ခ၏။ တရားသူကြီးက ‘ငါသည် ဘုရားသခင်ကိုမကြောက်၊ လူ့မျက်နှာကို မထောက်တတ်၊ ");
INSERT INTO rki_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","သို့သော်လည်း ဤမုဆိုးမသည် ငါ့ကို နှောက်ယှက်နိန်သည်ဖြစ်၍ သူမအတွက် တရားမျှတမှုဟိစီရန် သူမ၏အမှုကို ငါစီရင်မည်။ သို့မဟုတ်လျှင် သူမသည် ငါ့အား ဆက်လက်နှောက်ယှက်လျှင် နောက်ဆုံး၌ ငါပင်ပန်းလိမ့်မည်’ ဟု စိတ်ထဲ၌ ရေရွတ်နိန်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ထိုအခါ သခင်ဘုရားက၊ “အကျင့်ပျက်သော တရားသူကြီးပြောဆိုပုံကို နားထောင်ကြလော့။ ");
INSERT INTO rki_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ရွီးကောက်တော်မူသည့် လူတိက တရားမျှတမှုအတွက် နိ့ညမပြတ် အော်ဟစ် တောင်းလျှောက်နိန်ကြလျှင် ဘုရားသခင်သည် သူရို့ကိုကူညီရန် နှောင့်နှေးတော်မူမည်လော။ ");
INSERT INTO rki_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","သင်ရို့အား ငါဆိုသည်ကား၊ သူရို့ဖက်၌ အလျင်အမြန် တရားစီရင်တော်မူလိမ့်မည်။ သို့သော်လည်း လူသားကြွလာတော်မူသောအခါ ယုံကြည်ခြင်းကို ဤလောက၌ တွိ့နိုင်မည်လော” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ကိုယ့်ကိုကိုယ်ကောင်းမြတ်သည်ဟု ထင်မှတ်လျက် သူတစ်ပါးကို မထီလေးစားပြုတတ်သော လူတချို့အား ယေသျှုသည် ပုံဥပမာကိုဆောင်၍၊ ");
INSERT INTO rki_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“တစ်ခါက လူနှစ်ယောက်သည် ဆုတောင်းရန် ဗိမာန်တော်သို့ လားကြ၏။ တစ်ယောက်က ဖာရိယှဲဖြစ်ပြီး အခြားတစ်ယောက်က အခွန်ခံဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ဖာရိယှဲသည် တစ်ယောက်တည်းရပ်၍ ဆုတောင်း သည်မှာ ‘အိုဘုရားသခင် အကျွန်သည် အခြားတိလူကဲ့သို့ လောဘကြီးသူ၊ မရိုးဖြောင့်သူ၊ သူ့မယားကို ပြစ်မှားသူနှင့် ဤအခွန်ခံကဲ့သို့ မဟုတ်၍ ကိုယ်တော့်ကို ကျေးဇူးတင်ပါ၏။ ");
INSERT INTO rki_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","အကျွန်သည် တစ်ပတ်တွင် နှစ်ရက် အစာယှောင်ပါ၏။ အကျွန်၏ ဝင် ငွီအားလုံးထဲက ဆယ်ဖို့တစ်ဖို့ကို ပီးလှူပါ၏’ ဟူ၍ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","သို့သော်လည်း အခွန်ခံမူကား အဝီးကရပ်လျက် ကောင်းကင်ကို မော်မကြည့်ဝံ့ဘဲ ‘အို ဘုရားသခင်၊ အပြစ်သားဖြစ်သော အကျွန့်ကို သနားတော်မူပါ’ ဟု ရင်ဖတ်တီးပြီးလျှင် ဆုတောင်းလေ၏။” ");
INSERT INTO rki_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“သင်ရို့ကို ငါဆိုသည်ကား၊ အခွန်ခံသည် ဘုရားသခင်၏ အပြစ်လွှတ်ခြင်းကို ခံရပြီးလျှင် အိမ်ကိုပြန်လေ၏။ ဖာရိယှဲက အပြစ်လွှတ်ခြင်းမခံရ။ အကြောင်းမူကား ကိုယ့်ကိုကိုယ်ချီးမြောက်သောသူသည် နှိမ့်ချခြင်းခံရပြီးလျှင်၊ ကိုယ့်ကိုကိုယ် နှိမ့်ချသောသူကား ချီးမြောက်ခြင်းကို ခံရလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","လူတချို့သည် မိမိရို့၏ အချေတိကို ယေသျှု၏လက်တော်နှင့် တို့ထိနိုင်စီရန်အတွက် ကိုယ်တော့်ထံပါးသို့ ခေါ်ဆောင်လာကြသည်ကို တပည့်တော်ရို့မြင်လျှင် ထိုသူရို့အား အပြစ်တင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","သို့ရာတွင် ယေသျှုသည် အချေတိကို အထံတော်သို့ ခေါ်လျက် “အချေတိ ငါ့ပါးကို လာကတ်ပါစီ။ မတားဆီးကတ်ကေ့။ အကြောင်းမူကား ဘုရားသခင်၏ နိုင်ငံတော်သည် ထိုသို့သောသူရို့၏ နိုင်ငံဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ငါအမှန်ဆိုသည်ကား၊ အကြင်သူသည် ဘုရားသခင်၏ နိုင်ငံတော်ကို အချေကဲ့သို့ မခံယူလျှင် နိုင်ငံတော်ကို ဝင်ရလိမ့်မည် မဟုတ်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","ယုဒအမျိုးသား ခေါင်းဆောင်တစ်ယောက်က “ကောင်းမြတ်သောဆရာ၊ ထာဝရအသက်ကိုရဖို့ အကျွန်သည် ဇာချင့်ကို လုပ်ရပါမည်နည်း” ဟု ယေသျှုအား မိန်းလျှောက်၏။ ");
INSERT INTO rki_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ယေသျှုကလည်း “သင်သည် ငါ့ကိုဇာကြောင့် ကောင်းမြတ်သောသူဟု ခေါ်သနည်း။ ဘုရားသခင်မှတစ်ပါး ကောင်းမြတ်သောသူ တစ်ယောက်လေ့ မဟိ။ ");
INSERT INTO rki_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","သင်သည် ပညတ်တော်တိကို သိသည် မဟုတ်လော။ ‘သူ့မယားကို မပြစ်မှားကေ့။ လူ့အသက်ကို မသတ်ကေ့။ သူ့ဥစ္စာကို မခိုးကေ့။ မမှန်သောသက်သီကို မခံကေ့။ မိဖကို ရိုသီစွာပြုလော့’” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ထိုသူက “ဤပညတ်တိကို အကျွန်သည် ငယ်ရွယ်စဉ်ကတည်းက စောင့်ထိန်းခပါ၏” ဟု ပြန်လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ထိုစကားကို ကြားတော်မူလျှင် ယေသျှုက “သင်၌ တစ်ခုလိုသိမ့်၏။ သင်၌ ဥစ္စာဟိသမျှကို ရောင်းပြီး ဆင်းရဲသားတိကို ပီးကမ်းစွန့်ကြဲလော့။ ထိုသို့ပြုလျှင် ကောင်းကင်ဘုံ၌ ဘဏ္ဍာကို ရလိမ့်မည်။ ထို့နောက်မှ လာ၍ ငါ့နောက်သို့ လိုက်လော့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","သို့သော် ထိုသူသည် အလွန်ဥစ္စာကြွယ်ဝသူ ဖြစ်သောကြောင့် ကိုယ်တော်၏ စကားတော်ကို ကြားသောအခါ အလွန်ပင် စိတ်မချမ်းသာဖြစ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ထိုအခြင်းအရာကို ယေသျှုမြင်သောအခါ “ဥစ္စာရတတ်သူရို့သည် ဘုရားသခင်၏ နိုင်ငံတော်ထဲသို့ ဝင်ရောက်ရန် ခက်ခဲ၏။ ");
INSERT INTO rki_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ဥစ္စာရတတ်သူက ဘုရားသခင်၏ နိုင်ငံတော်သို့ ဝင်ရမည်ထက် ကုလားအုတ်သည် အပ်နဖားကို လျှိုဝင်ရန် ပိုလွယ်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","စကားတော်ကို ကြားသောလူတိကလည်း “သို့ဖြစ်လျှင် ဇာသူက ကယ်တင်ခြင်းကို ရနိုင်ပါမည်နည်း” ဟု မိန်းလျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ယေသျှုက “လူမတတ်နိုင်သော အရာကို ဘုရားသခင် တတ်နိုင်တော်မူ၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ထိုအခါ ပေတရုသည်၊ “ကြည့်ပါ၊ အကျွန်ရို့သည် ကိုယ့်အိမ်ကို စွန့်ပြီးလျှင် ကိုယ်တော်၏ နောက်တော်သို့ လိုက်လာကြပါသည်” ဟု လျှောက်၏။ ");
INSERT INTO rki_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ကိုယ်တော်က “ငါအမှန်ဆိုသည်ကား၊ ဘုရားသခင်၏ နိုင်ငံတော်အတွက် မိမိအိမ်၊ မယား၊ ညီအစ်ကိုမောင်နှမ၊ မိဖ၊ သားသမီးတိကို စွန့်သောသူသည်၊ ");
INSERT INTO rki_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ဤဘဝ၌ အဆပေါင်းများစွာ အကျိုးကို ခံစားရပြီးလျှင် နောင်ဘဝ၌လည်း ထာဝရအသက်ကို ရလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","ယေသျှုသည် တပည့်တော်တစ်ကျိပ်နှစ်ပါးကို ခေါ်ပြီးလျှင် “နားထောင်ကြလော့၊ ငါရို့သည် ယေရုဆလင်မြို့သို့ လားကြမည်။ လူသားအကြောင်းနှင့်ပတ်သတ်ပြီးလျှင် ပရောဖက်တိ ရီးသားထားသောအရာအားလုံး ထိုနီရာ၌ ပြည့်စုံလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","လူသားကို လူမျိုးခြားလက်ထဲသို့ အပ်နှံလိမ့်မည်။ သူ့ကို လှောင်ပြောင်စော်ကားပြီးလျှင် တံထွီးနှင့် ထွီးကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","လူသားကို ကြာပွတ်နန့်ရိုက်၍ အသီသတ်ကြလိမ့်မည်။ သို့သော်လည်း သုံးရက်မြောက်သောနိ့၌ ရှင်ပြန်ထမြောက်လိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","သို့ရာတွင် တပည့်တော်ရို့သည် ကိုယ်တော်၏ စကားတော်တစ်ခွန်းကိုမျှ နားမလည်ခကြ။ ထိုစကား၏ အနက်အဓိပ္ပာယ်သည် ကွယ်ဝှက်ထားခြင်း ခံရသည်ဖြစ်၍ ကိုယ်တော်၏ မိန့်တော်မူချက်ကို သူရို့နားမလည်ခကြ။ ");
INSERT INTO rki_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","ယေသျှုသည် ယေရိခေါမြို့နားသို့ ရောက်တော်မူစဉ် မျက်မမြင်တစ်ဦးသည် လမ်းဘေးနားတွင်ထိုင်၍ တောင်းစားလျက် နိန်၏။ ");
INSERT INTO rki_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","သူသည် လူထုပရိသတ်ကြီး လားကြသံကို ကြား၍ အကြောင်းကို စုံစမ်းမိန်းမြန်း၏။ ");
INSERT INTO rki_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","လူတိက “နာဇရက်မြို့သား ယေသျှု ကြွလာတော်မူလျက်ဟိကြောင်း” ကို ပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ထိုသူက “ဒါဝိဒ်၏ သားတော် ယေသျှု၊ အကျွန့်ကို သနားတော်မူပါ” ဟု အော်ဟစ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ရှိ့တွင် ဟိနိန်သည့် လူတိက သူ့အား တိတ်တိတ်နီရန် ငေါက်ငန်းပြောဆိုကြ၏။ သို့သော်လည်း သူသည် “ဒါဝိဒ်၏ သားတော်၊ အကျွန့်ကို သနားတော်မူပါ” ဟု ပို၍ပင် ကျယ်လောင်စွာ ဟစ်အော်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","သို့ဖြစ်၍ ယေသျှုသည် တန့်တော်မူလျက် မျက်မမြင်အား ခေါ်ခပါဟု မိန့်တော်မူ၏။ ထိုသူသည် အနားသို့ရောက်လျှင်၊ ယေသျှုက၊ ");
INSERT INTO rki_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“သင်သည် ငါ့အား ဇာအမှုကို ပြုစီလိုသနည်း” ဟု မိန်းတော်မူလျှင်၊ “သခင်ဘုရား၊ အကျွန် မျက်စိပြန်မြင်ချင်ပါ၏” ဟု မျက်မမြင်က လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","ယေသျှုကလည်း၊ “သင်၏ မျက်စိမြင်စီ၊ သင်၏ ယုံကြည်ခြင်းသည် သင့်မျက်စိကို မြင်စီ ဗျာယ်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ထိုခဏအတွင်း သူသည် မျက်စိမြင်၍ ဘုရားသခင်၏ဂုဏ်ကျေးဇူးတော်ကို ချီးမွမ်းလျက် ကိုယ်တော်၏နောက်သို့ လိုက်လေ၏။ လူထုပရိသတ်ရို့သည် ထိုအခြင်းအရာကို မြင်လျှင် ဘုရားသခင်ကို ချီးမွမ်းကြကုန်၏။ ");
INSERT INTO rki_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ယေသျှုသည် ယေရိခေါမြို့ကို ဖြတ်၍ ကြွတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ထိုအရပ်တွင် ဇက္ခဲဟု နာမည်ဟိသော ချမ်းသာကြွယ်ဝသူ အခွန်ခေါင်းတစ်ယောက်ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","သူက ယေသျှုသည် ဇာသူဖြစ်ကြောင်းကို တွိ့မြင်လိုသဖြင့် ကြိုးစား၍ ကြည့်၏။ သို့ရာတွင် အရပ်ပုသူဖြစ်သဖြင့် လူထုပရိသတ်ကြောင့် ကိုယ်တော့်ကို မမြင်နိုင်။ ");
INSERT INTO rki_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ထို့ကြောင့် ယေသျှုကို တွိ့မြင်နိုင်ရန် ကြွတော်မူမည့်လမ်းအတိုင်း ရှိ့သို့ ဗြီး၍ သဖန်းပင်တစ်ပင်ထက်သို့ တက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ယေသျှုသည် ထိုနီရာသို့ ရောက်သောအခါ မော်၍ ကြည့်တော်မူပြီးလျှင်၊ “ဇက္ခဲ၊ အယင် ဆင်းလာ၊ ဤနိ့ သင့်အိမ်၌ ငါတည်းခိုမည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ဇက္ခဲသည် အယင်ဆင်းလာပြီးလျှင် ကိုယ်တော့်ကို ဝမ်းမြောက်စွာဖြင့် ကြိုဆိုလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ဤအခြင်းအရာကို လူတိက မြင်သောအခါ “ဤသူသည် အပြစ်သားတစ်ယောက်၏အိမ်၌ တည်းခိုရန် လားပါသည်တကား” ဟု စတင်၍ ကဲ့ရဲ့ပြစ်တင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ဇက္ခဲသည်ရပ်လျက် သခင်ဘုရားအား၊ “အသျှင်၊ နားထောင်ပါ၊ အကျွန်၏ဥစ္စာတစ်ဝက်ကို ဆင်းရဲသားရို့အား ပီးကမ်းပါမည်။ တဦးတစ်ယောက်ပါးက မတရား တောင်းယူထားမိ့သော ငွီ ဟိပါလျှင် ထို ငွီ၏ လေးဆကို ပြန်ပီးပါမည်” ဟု လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ယေသျှုကလည်း၊ “အာဗြဟံ၏ သားဖြစ်ခြင်းကို သူ၏ အပြုအမူအားဖြင့် ပြသောကြောင့် ကယ်တင်ခြင်းသည် ဤနိ့ပင် ဤအိမ်ထက်သို့ သက်ရောက်လီဗျာယ်။ ");
INSERT INTO rki_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","လူသားသည် ပျောက်ဆုံးသူတိကို ရှာဖို့နန့် ကယ်တင်ဖို့ရန် ကြွလာခြင်းဖြစ်သည်” ဟု ဇက္ခဲအား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","ကိုယ်တော်သည် ဤအကြောင်းအရာတိကို နားထောင်နိန်ကြသော သူရို့အား ပုံဥပမာတစ်ခုကို ထပ်၍ မိန့်တော်မူ၏။ အကြောင်းမူကား ကိုယ်တော်သည် ယေရုဆလင်မြို့အနားသို့ ရောက်လာတော်မူသဖြင့် ဘုရားသခင်၏ နိုင်ငံတော် ချက်ချင်းပေါ်ထွန်းမည်ဟု ထင်မှတ်ကြသောကြောင့် ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ထို့ကြောင့် ကိုယ်တော်က “အမတ်တစ်ယောက်သည် ဝီးသောတိုင်းပြည်တစ်ခုကို ထွက်လားပြီးလျှင် ဘုရင်အရာကိုခံယူပြီး ကိုယ့်တိုင်းပြည်ကို ပြန်လာရန် အကြံဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ခရီးမထွက်ခင် မိမိ၏အခိုင်းအစီ ဆယ်ယောက်ကိုခေါ်ပြီး ‘ငါပြန်လာသည့်အချိန်ထိ ကုန်သွယ်မှုကို ပြုပြီးနီကြလော့’ ဟု ဆို၍ ရွှီဒင်္ဂါးတစ်ပြားစီ ပီးလိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","သို့သော် သူ၏ ပြည်သူပြည်သားရို့သည် သူ့ကို မုန်းကြသဖြင့်၊ ‘ထိုသူသည် ဘုရင်အဖြစ် အုပ်ချုပ်မှုကို ငါရို့မခံလို’ ဟု တမန်တစ်ယောက်ကို ထိုသူနောက်သို့ စီရွှတ်ပြီးလျှင် လျှောက်ထားစီ၏။ ");
INSERT INTO rki_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“ထိုအမတ်သည် ဘုရင်အရာကို ခံယူပြီး ပြန်လာ၏။ သူသည် ချက်ချင်းပင် စီးပွါးရှာရန် ပီးထားခသော ရွှီဒင်္ဂါးဖြင့် ဇာလောက် အမြတ်ရထားသည်ကို သိချင်၍ အခိုင်းအစီတိကို ခေါ်စီ၏။ ");
INSERT INTO rki_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","ပထမတစ်ဦးသည် လာ၍ ‘ဆရာ၊ ဆရာပီးခသော ရွှီဒင်္ဂါးတစ်ပြားနှင့် အမြတ်ဆယ်ပြားရပါ၏’ ဟု လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","သခင်က ‘သာဓု၊ သင်သည် ငယ်သားကောင်းဖြစ်၏။ ငယ်သောအမှု၌ သစ္စာဟိသူဖြစ်၍ သင်သည် မြို့ကြီးဆယ်မြို့ကို အုပ်ချုပ်လော့’ ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ဒုတိယ အခိုင်းအစီကလည်း လာပြီးလျှင် ‘အသျှင်၊ အသျှင်ပီးခသော ရွှီဒင်္ဂါးတစ်ပြားနှင့် အမြတ် ငါးပြားရပါ၏’ ဟု လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","အသျှင်က ‘သင်သည်လည်း မြို့ကြီးငါးမြို့ကို အုပ်ချုပ်လော့’ ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","အခြားသော အခိုင်းအစီသည် လာပြီးလျှင် ‘အသျှင်၊ အသျှင်ပီးခသော ရွှီဒင်္ဂါး ဤမှာဟိပါ၏။ ထို ရွှီဒင်္ဂါးကို အကျွန်သည် ပုဝါနှင့်ထုပ်၍ သိမ်းထားပါ၏။ ");
INSERT INTO rki_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","အသျှင်သည် ပြတ်သားသောသူ ဖြစ်သောကြောင့် အကျွန်ကြောက်ပါ၏။ အသျှင်သည် မိမိမပိုင်သောအရာတိကို သိမ်းယူတတ်ပြီးလျှင်၊ မိမိမစိုက်မပျိုးသော သီးနှံတိကိုလည်း ရိတ်သိမ်းတတ်ပါ၏’ ဟု လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","မင်းကြီးက ‘အခိုင်းအစီဆိုး၊ သင်၏ နှုတ်ထွက်စကားအတိုင်း သင့်ကို ငါစီရင်မည်။ ငါသည် ပြတ်သားသောသူဖြစ်ပြီး ကိုယ်မပိုင်သောအရာတိကို သိမ်းယူတတ်၍ ကိုယ်မစိုက်မပျိုးသော အသီးအနှံတိကို ရိတ်သိမ်းတတ်သည်ကို သိပါလျက်နှင့်၊ ");
INSERT INTO rki_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ငါပီးထားသော ငွီကို ငါပြန်လာသော အချိန်တွင် အတိုးနှင့်တကွ ပြန်ပီးနိုင်ဖို့ ဇာကြောင့် ဘဏ်၌ အပ်မထားသနည်း’ ဟု မိန်း၏။ ");
INSERT INTO rki_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","ထို့နောက် မင်းကြီးက အနားတွင် ရပ်နိန်သောသူရို့အား ‘ထိုသူပါးက ရွှီဒင်္ဂါးကိုယူ၍ ရွှီဒင်္ဂါးဆယ်ပြားဟိသူကို ပီးလိုက်လော့’ ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","ယေဒါလည်း လူတိက ‘အသျှင်၊ ထိုသူ၌ ရွှီဒင်္ဂါးဆယ်ပြား ဟိပြီးဖြစ်ပါ၏’ ဟု လျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","မင်းကြီးက ‘သင်ရို့အား ငါဆိုသည်ကား၊ အကြင်သူသည် ရတတ်၏။ သူအား သာ၍ ပီးဦးမည်။ အကြင်သူသည် ဆင်းရဲ၏။ သူ့ပါးမှ ဟိသမျှကိုပင် သိမ်းယူခြင်းခံရမည်။ ");
INSERT INTO rki_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ထိုမှတစ်ပါး ဘုရင်အဖြစ် ငါ၏ အုပ်ချုပ်မှုကို မခံလိုသော ငါ၏ရန်သူတိကို ငါ့ရှိ့တွင် ယူလာ၍ အသီသတ်လိုက်ကြလော့’ ဟု စီရင်တော်မူသည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ထိုသို့ မိန့်တော်မူပြီးနောက် ယေသျှုသည် တပည့်တော်တိရှိ့က ကြွတော်မူ၍ ယေရုဆလင်မြို့သို့ တက်ကြွတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","သံလွင်တောင်၌ဟိသော ဗက်ဖာဂေရွာနှင့် ဗေသနိရွာအနားသို့ ရောက်တော်မူသောအခါ တပည့်တော်နှစ်ယောက်ကို အယင် ရွှတ်လိုက်၍၊ ");
INSERT INTO rki_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“သင်ရို့ရှိ့၌ဟိသောရွာသို့ လားကြလော့။ ထိုရွာကို ဝင်သောအခါ တစ်ယောက်လေ့ မစီးဖူးသော မြည်းပေါက်ချေတစ်ကောင် ချည်ထားသည်ကို တွိ့လိမ့်မည်။ မြည်းကြိုးကိုဖြီ၍ ဆွဲလာကြလော့။ ");
INSERT INTO rki_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","လူတစ်ယောက်က ‘ဇာဖြစ်လို့ ကြိုးကို ဖြီသနည်း’ ဟု သင်ရို့အား မိန်းလျှင် ‘အသျှင် အလိုဟိသည်’ ဟု ပြန်ပြောကြလော့” ဟူ၍ မှာကြား၍ ရွှတ်လိုက်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ရွှတ်လိုက်ခြင်းခံရသော သူရို့သည်လည်း ထွက်လားကြသောအခါ ယေသျှု မိန့်တော်မူသည့်အတိုင်း အားလုံးကို တွိ့မြင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","သူရို့သည် မြည်းကြိုးကို ဖြီနိန်စဉ် မြည်းပိုင်သျှင်က “သင်ရို့ဇာကြောင့် မြည်းကြိုးကို ဖြီသနည်း” ဟု မိန်း၏။ ");
INSERT INTO rki_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","သူရို့ကလည်း “အသျှင် အလိုဟိသည်” ဟု ပြန်ပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ထို့နောက် သူရို့သည် မြည်းကို ယေသျှုထံပါးသို့ ယူလာကြ၏။ မြည်း၏နောက်ကုန်းထက်တွင် မိမိရို့၏အဝတ်များကို တင်ပြီး ကိုယ်တော့်ကို စီးစီကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ကိုယ်တော် မြည်းစီး၍ ကြွတော်မူစဉ် လူအပေါင်းရို့သည် မိမိရို့၏အဝတ်ကို လမ်းထက်၌ ဖြန့်ခင်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ယေရုဆလင်မြို့အနားသို့ ရောက်လာစဉ် သံလွင်တောင်အဆင်းလမ်းတွင် သူ၏တပည့်တော် လူအပေါင်းရို့သည် မိမိရို့ တွိ့မြင်ခရသည့် အံ့သြဖွယ်အမှုအရာများအတွက် ဝမ်းမြောက်ရွှင်လန်းလျက် ဘုရားသခင်အား ကျယ်သောအသံနှင့် ချီးမွမ်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“ထာဝရဘုရား၏ နာမတော်နှင့် ကြွလာတော်မူသော ဘုရင်သည် မင်္ဂလာဟိစီသတည်း။ ကောင်းကင်ဘုံ၌ ငြိမ်သက်ခြင်း ဟိစီသတည်း။ ဘုရားသခင်သည် ဘုန်းကြီးတော်မူစီသတည်း” ဟု ကြွေးကြော်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","ထိုအခါ လူပရိသတ်ထဲမှ ဖာရိယှဲတချို့က “ဆရာ၊ ဆရာ၏တပည့်တော်တိကို တိတ်ဆိတ်စွာနိန်ဖို့ အမိန့်ပီးပါ” ဟု ကိုယ်တော့်ကို လျှောက်ထားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ယေသျှုက “သင်ရို့အား ငါဆိုသည်ကား၊ ဤသူရို့သည် တိတ်တိတ်နိန်ကြလျှင် ကျောက်ခဲတိက ကြွေးကြော်ကြလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","ကိုယ်တော်သည် ယေရုဆလင်မြို့အနားသို့ ရောက်တော်မူ၍ ကြည့်တော်မူလျှင် ထိုမြို့အတွက် ငိုကြွီးလျက်၊ ");
INSERT INTO rki_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“သင်သည် ငြိမ်သက်ခြင်းအတွက် လိုအပ်သည့်အရာကို ဤနိ့ သိမြင်စီခြင်းငှာ ငါအလိုဟိ၏။ သို့သော်လည်း သင်သည် ထိုအရာကို မသိမမြင်နိုင်။ ");
INSERT INTO rki_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ရန်သူရို့သည် သင့်ပတ်လည်၌ တပ်ချ၍ အဖက်ဖက်မှ ဝန်းရံပိတ်ဆို့နိန်သည့် အချိန်ရောက်လာလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","သူရို့သည် သင်နှင့် သင်၏မြို့ရိုးအတွင်း၌ဟိသော လူတိကို ဖျက်ဆီးကြလိမ့်မည်။ ကျောက်တစ်တုံးအထက်မှာ တစ်တုံး တင်ကျန်ရလိမ့်မည် မဟုတ်။ အကြောင်းမူကား သင်ရို့ကို ကယ်တင်ဖို့ ဘုရားသခင်ကြွလာသော အချိန်ကာလကို မသိမမြင်လို့ ဖြစ်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","ထို့နောက် ယေသျှုသည် ဗိမာန်တော်သို့ ဝင်တော်မူပြီးလျှင် ရောင်းဝယ်သောသူရို့ကို နှင်ထုတ်တော်မူပြီး၊ ");
INSERT INTO rki_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ထိုသူရို့အား “ဘုရားသခင်က၊ ‘ငါ၏ဗိမာန်တော်သည် ဆုတောင်းရာအိမ် ဖြစ်၏’ ဟု ကျမ်းစာ၌ ရီးထားသည်ဟု မိန့်တော်မူထားသော်လည်း သင်ရို့က ငါ၏ဗိမာန်တော်ကို သူခိုးတွင်း ဖြစ်စီဗျာယ်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","ကိုယ်တော်သည် နိ့တိုင်း ဗိမာန်တော်၌ ဟောပြောသွန်သင်တော်မူ၏။ ယဇ်ပုရောဟိတ်ကြီးများ၊ ကျမ်းတတ်ဆရာများနှင့် လူအကြီးအကဲရို့သည် ကိုယ်တော့်ကို အသီသတ်ရန် အခွင့်ရှာကြသော်လည်း၊ ");
INSERT INTO rki_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","လူအပေါင်းရို့သည် တရားစကားများကို အာရုံစိုက်၍ နာယူနိန်ကြသောကြောင့် သူရို့သည် ကိုယ်တော်အား သတ်ရမည့်အခွင့်ကို ရှာ၍ မရနိုင်ကြ။ ");
INSERT INTO rki_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","တစ်နိ့၌ ယေသျှုသည် ဗိမာန်တော်တွင် လူတိအား ဆုံးမသြဝါဒပီး၍ သတင်းကောင်းကို ဟောပြောလျက်နိန်စဉ် ယဇ်ပုရောဟိတ် အကြီးအကဲများ၊ ကျမ်းတတ်ဆရာများနှင့် လူအကြီးအကဲရို့သည် ကိုယ်တော်ထံသို့ လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","သူရို့က “ကိုယ်တော်သည် ဤအမှုအရာများကို ဇာအခွင့်နှင့် ပြုတော်မူသနည်း။ ဤအခွင့်ကို ဇာသူက ပီးတော်မူသနည်း။ အကျွန်ရို့ကို ပြောပြပါ” ဟု မိန်းမြန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ယေသျှုက “ငါလည်း သင်ရို့အား မိန်းခွန်းတစ်ခုကို မိန်းဦးမည်။ ");
INSERT INTO rki_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ယောဟန်၏ဗတ္တိဇံသည် ဘုရားသခင်ထံမှ လာသလော။ သို့မဟုတ် လူတိပါးမှ လာသလော ငါ့ကိုပြောလော” ဟု မိန်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","သူရို့သည် “‘ဘုရားသခင်ထံမှ လာသည်’ ဟု ငါရို့ဆိုကေ ‘ယောဟန်အား သင်ရို့ဇာကြောင့် မယုံကြည်ကြသနည်း’ ဟု မိန်းလာလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","သို့သော်လည်း ‘လူတိပါးမှ လာသည်’ ဟု ဆိုလျှင် လူတိက ယောဟန်အား ပရောဖက်တစ်ပါး ဖြစ်ကြောင်းကို အမှန်ယုံကြည်ကြ၍ ငါရို့ကို ကျောက်ခဲနန့် ပစ်ကြလိမ့်မည်” ဟု အချင်းချင်း တိုင်ပင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ထို့ကြောင့် သူရို့က၊ “ဇာသူ့ပါးက လာသည်ကို အကျွန်ရို့မသိပါ” ဟု ဖြေကြားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","ထိုအခါ ယေသျှုကလည်း၊ “ငါသည်လည်း ဇာအခွင့်အာဏာနန့် ဤအရာများကို ပြုနိန်သည်ကို သင်ရို့အား ပြောလိမ့်မည် မဟုတ်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ထို့နောက် ယေသျှုက လူတိအား မိန့်တော်မူခသော ပုံဥပမာကား၊ “လူတစ်ယောက်သည် စပျစ်ဥယျာဉ်ကို စိုက်ပျိုးပြီး သီးစားချထားကာ အခြားပြည်သို့ လား၍ ကာလအတန်ကြာ နီထိုင်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","အသီးပေါ်ချိန် ရောက်သောအခါ ကျွန်တစ်ယောက်ကို ခြံသမားထံပါးသို့ စီရွှတ်ပြီးလျှင် သီးစားခကို တောင်းစီ၏။ သို့သော်လည်း ခြံသမားတိက ထိုကျွန်ကို သတ်ပုတ်၍ လက်ခစီး ပြန်ရွှတ်လိုက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ထို့ကြောင့် ဥယျာဉ်သျှင်သည် အခြားကျွန်တစ်ယောက်ကို စီရွှတ်ပြန်၏။ သို့သော်လည်း ခြံသမားရို့သည် သူ့ကိုလည်း သတ်ပုတ်ပြီးလျှင် အရှက်ခွဲ၍ လက်ခစီး ပြန်ရွှတ်လိုက်ပြန်၏။ ");
INSERT INTO rki_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ထို့နောက် ဥယျာဉ်သျှင်သည် တတိယကျွန်ကို စီရွှတ်လိုက်သော်လည်း ခြံသမားတိက ထိုကျွန်အား ရိုက်ပုတ်လျက် ဒဏ်ရာရစီပြီးလျှင် အပြင်ဖက်သို့ နှင်ထုတ်လိုက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","စပျစ်ဥယျာဉ်ပိုင်သျှင်က ‘ငါ ဇာပိုင် လုပ်ရမည်နည်း၊ ငါ၏ ချစ်သောသားကို ရွှတ်လိုက်လျှင် သူရို့က ရိုသီလေးစားလောက်သည်’ ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","သို့သော်လည်း ခြံသမားရို့သည် ဥယျာဉ်သျှင်၏သားကို မြင်သောခါ ‘ဤသူသည် အမွီခံဖြစ်၏။ ငါရို့သည် ထိုသူ့အမွီကိုရအောင် သူ့ကို အသီသတ်ပစ်လိုက်ကြမည်’ ဟု အချင်းချင်း တိုင်ပင်ပြီးလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","စပျစ်ဥယျာဉ်ပိုင်သျှင်၏သားကို ဥယျာဉ်၏ အပြင်ကိုထုတ်၍ အသီသတ်ပစ်ကြ၏။ “ထို့ကြောင့် ဥယျာဉ်ပိုင်သျှင်သည် ခြံသမားတိအား ဇာပိုင်လုပ်မည်နည်း” ဟု ယေသျှုက မိန်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ထိုအခါ ယေသျှုက “စပျစ်ဥယျာဉ်သျှင်သည် လာပြီးလျှင် သူ့ရို့ကို အသီသတ်ပြီး ဥယျာဉ်ကို အခြားသော သီးစားခြံသမားတိပါးသို့ အပ်လိမ့်မည်” ဟု မိန့်တော်မူ၏။ ထိုစကားကို ကြားသောအခါ သူရို့က၊ “ထိုသို့ မဖြစ်ပါစီကေ့” ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ယေသျှုက လူတိအား ကြည့်ရှုတော်မူပြီးလျှင်၊ “သို့ဖြစ်၍ ကျမ်းစာ၌ ဖော်ပြသည်ကား မည်သို့နည်း။ “ ‘တိုက်ကိုဆောက်သောလူတိ ပယ်ထားသောကျောက်သည်၊ အရေးကြီးဆုံးဖြစ်သော တိုက်ထောင့်ကိုချုပ်သော ကျောက်ဖြစ်လာရ၏။’ ");
INSERT INTO rki_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","ထိုကျောက်ထက်၌ ကျသောသူသည် အပိုင်းပိုင်းကျိုးလိမ့်မည်။ ထိုကျောက် ကျခြင်းခံရသည့် သူသည်လည်း အမှုန့်ကြိတ်ခံရလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ကျမ်းတတ်ဆရာများနှင့် ယဇ်ပုရောဟိတ်အကြီးအကဲရို့သည် မိမိရို့အား ရည်ညွှန်း၍ ဤပုံဥပမာဖြင့် မိန့်တော်မူကြောင်းကို သိကြသဖြင့် ယေသျှုကို ဖမ်းဆီးကြရန် ရှာကြံလေ၏။ သို့သော်လည်း လူတိကို ကြောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ထို့ကြောင့် အခွင့်ကောင်းကို စောင့်ကြည့်လျက် ယေသျှုစကားတွင် အမှားကိုရှာပြီးလျှင် ကိုယ်တော်အား ရောမဘုရင်ခံ၏လက်သို့ အပ်နိုင်ရန် လူတချို့ကို အခငွီပီးပြီး သူတော်ကောင်းယောင်ဆောင်စီကာ သူလျှိုအဖြစ် ကိုယ်တော်ထံသို့ စီရွှတ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","သူလျှိုတိက၊ “ဆရာ၊ ဆရာ ဟောပြောသွန်သင်တော်မူသော အရာအားလုံး မှန်ကန်ကြောင်းကို အကျွန်ရို့သိပါ၏။ ဆရာသည် လူမျက်နှာကိုမထောက်ဘဲ ဘုရားသခင်၏ တရားလမ်းကို ဖြောင့်မတ်စွာ သွန်သင်တတ်ပါ၏။ ");
INSERT INTO rki_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","အကျွန်ရို့သည် ကဲသာဘုရင်ကို အခွန်ဆက်သခြင်းသည် ပညတ္တိကျမ်းနှင့် ညီပါသလား၊ မညီသလား” ဟု မိန်းလျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ယေသျှုသည် သူရို့၏ ပရိယာယ်ကို သိတော်မူသဖြင့်၊ သူရို့အား ");
INSERT INTO rki_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“ငွီဒင်္ဂါးတစ်ပြားကို ငါ့အားပြလော၊ ဤ ငွီဒင်္ဂါး၌ ဇာသူ့ပုံ၊ ဇာသူ့နာမည် ပါသနည်း” ဟု မိန်းတော်မူ၏။ သူရို့က “ကဲသာဘုရင်၏ ပုံနှင့် သူ၏ နာမည်ဟိပါ၏” ဟု ပြန်လျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ထို့ကြောင့် ယေသျှုက “ကဲသာဘုရင်ပိုင်သည့်အရာကို ကဲသာဘုရင်အား ဆက်သကြလော၊ ဘုရားသခင်ပိုင်သည့်အရာကို ဘုရားသခင်အား ဆက်သကြလော” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","သူရို့သည် လူတိရှိ့တွင် ကိုယ်တော်၏စကား၌ အပြစ်မတွိ့သဖြင့် ကိုယ်တော်၏ ဖြေကြားတော်မူပုံကို အံ့သြလျက် တိတ်ဆိတ်နိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","ထို့နောက် လူသည် သီခြင်းမှ ရှင်ပြန်ထမြောက်ခြင်းမဟိဟု ယုံကြည်ကြသော ဇဒ္ဒုကဲတချို့သည် ယေသျှုထံသို့ ချဉ်းကပ်၍၊ ");
INSERT INTO rki_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“ဆရာ၊ ‘မယားဟိသောသူ တစ်ယောက်သည် သားသမီးမထွန်းကားဘဲ သီဆုံးလားလျှင် ကျန်ခသည့် မုဆိုးမကို ညီဖြစ်သောသူက လက်ထပ်ယူ၍ အစ်ကိုမျိုးဆက်ကို တိုးပွားစီရမည်’ ဟု အကျွန်ရို့ကို မောသျှေ စီရင်ခပါ၏။ ");
INSERT INTO rki_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","တစ်ခါက ညီအစ်ကိုခုနစ်ယောက် ဟိပါ၏။ အစ်ကိုကြီးသည် အိမ်ထောင်ကျသော်လည်း သားသမီးမထွန်းကားဘဲ သီဆုံးလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ပြီးလျှင် ဒုတိယညီသည် သူ့မရီးအား လက်ထပ်လိုက်သော်လည်း သားသမီးမထွန်းကားဘဲ သီဆုံးလားပြန်၏။ ");
INSERT INTO rki_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","တတိယညီကလည်း လက်ထပ်ပြန်၏။ ထိုနည်းတူ ညီအစ်ကိုခုနစ်ယောက်စလုံးသည် သားသမီးမထွန်းကားဘဲ သီဆုံးလားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","နောက်ဆုံး၌ မိန်းမကြီးလည်း သီဆုံးလားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ထို့ကြောင့် ရှင်ပြန်ထမြောက်သောနိ့၌ ထိုမိန်းမသည် ဇာသူမယား ဖြစ်မည်နည်း။ ထိုသူ ခုနစ်ယောက်စလုံးသည် သူမနှင့် လက်ထပ်ထားသူများ ဖြစ်ကြ၏” ဟု မိန်းလျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ယေသျှုကလည်း “ဤဘဝ၌ လူသည် အိမ်ထောင်ပြုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","သို့သော်လည်း သီခြင်းမှ ရှင်ပြန်ထမြောက်ပြီး နောင်ဘဝကို ဝင်ရသည့် လူတိမှာကား အိမ်ထောင်ပြုခြင်းမဟိ။ ");
INSERT INTO rki_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ထိုသူရို့သည် သီဆုံးခြင်းမဟိဘဲ ကောင်းကင်တမန်ပိုင် ဖြစ်ကြလိမ့်မည်။ သူရို့သည် သီဆုံးခြင်းမှ ရှင်ပြန်ထမြောက်သောသူများဖြစ်၍ ဘုရားသခင်၏သား ဖြစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","မီးလောင်နိန်သော ခြုံပုတ်အကြောင်း ဖော်ပြရာ၌ မောသျှေက သခင်ဘုရားသည် ‘အာဗြဟံ၏ဘုရား၊ ဣဇာက်၏ဘုရား၊ ယာကုပ်၏ ဘုရားဖြစ်သည်’ ဟုဆိုရာ၌ သီလွန်သောသူရို့သည် ရှင်ပြန်ထမြောက်ကြောင်းကို ယှင်းလင်းစွာ ဖော်ပြခြင်းပင်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ထိုသူရို့သည် ဘုရားသခင်၏ရှိ့၌ အသက်ရှင်သော သူတိဖြစ်သည့်အတွက် ဘုရားသခင်သည် သီသောလူတိ ဘုရား မဟုတ်။ အသက်ရှင်သော သူရို့၏ ဘုရားဖြစ်တော်မူ၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ကျမ်းတတ်ဆရာတချို့က၊ “ဆရာ၊ ဆရာ၏စကားသည် အလွန်လျှောက်ပတ်ပါ၏” ဟု လျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","သူရို့က နောက်ထပ် မိန်းခွန်းများကို ကိုယ်တော့်အား မမိန်းလျှောက်ဝံ့ကြ။ ");
INSERT INTO rki_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ယေသျှုက ထိုသူရို့အား၊ “မေသျှိယသည် ဒါဝိဒ်၏သားမြီးဖြစ်သည်ဟု ဇာကြောင့်ပြောကြသနည်း။ ");
INSERT INTO rki_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","ဒါဝိဒ်ကိုယ်တိုင် ဆာလံကျမ်း၌ “ ‘ထာဝရဘုရားက ငါသည် သင်ရို့၏ ");
INSERT INTO rki_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ရန်သူတိကို သင်သည် ခြီတင်ရန် သင်၏ခြီ အောက်၌ ငါ မချထားခင်တိုင်အောင်၊ ငါ၏ လက်ယာဖက်၌ ထိုင်နိန်လော့၊ ဟု ငါ့အသျှင်အား မိန့်တော်မူသည်’ ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","ဒါဝိဒ်သည် မေသျှိယအား၊ ‘အသျှင်’ ဟုခေါ်လျှင် ဇာကြောင့် မေသျှိယသည် ဒါဝိဒ်၏သား ဖြစ်နိုင်မည်နည်း” ဟု မိန်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","လူအပေါင်းရို့သည် နားထောင်လျက် နိန်ကြစဉ် ကိုယ်တော်သည် တပည့်တော်ရို့အား၊ ");
INSERT INTO rki_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“ကျမ်းတတ်ဆရာတိကို သတိနန့်ယှောင်ကြလော့။ သူရို့သည် ဝတ်ရုံရှည်ကို ဝတ်၍ လမ်းလျှောက်ခြင်းကို နှစ်သက်ကြ၏။ စျီးနီရာတိ၌ ရိုသီစွာ နှုတ်ဆက်ခြင်းနှင့် တရားဇရပ်၊ ပွဲသဘင်များတွင် မြင့်မြတ်သောနီရာ၌ ထိုင်ခြင်းငှာ နှစ်သက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","မုဆိုးမအိမ်တိကို လိမ်လည်လှည့်ဖြားကာ သိမ်းယူပြီးလျှင် လူအထင်ကြီးအောင် အကြာကြီး ဆုတောင်းတတ်ကြ၏။ သူရို့သည် မှားယွင်းမှုကြောင့် ပို၍ ကြီးမားသောအပြစ်ကို ခံရလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","ယေသျှုသည် မျှော်ကြည့်သောအခါ ချမ်းသာသောသူများသည် ဗိမာန်တော်၏ ဘဏ္ဍာတိုက်ထဲသို့ ထည့်ဝင်နိန်ကြသည်ကို မြင်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ဆင်းရဲသော မုဆိုးမတစ်ယောက်သည်လည်း သေးငယ်သော ကြေးဒင်္ဂါးနှစ်ပြား လှူဒါန်းနိန်သည်ကို မြင်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ကိုယ်တော်ကလည်း၊ “သင်ရို့အား ငါဆိုသည်ကား၊ ဆင်းရဲသော မုဆိုးမသည် အခြားသော လူတိထက် ပို၍ ထည့်ဝင်လှူဒါန်းလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ချမ်းသာသောလူတိက သူရို့၏ ငွီပိုငွီလျှံထဲက ထည့်ဝင်လှူဒါန်းကြ၏။ ဤဆင်းရဲသော မုဆိုးမသည် ဆင်းရဲသော်လည်း သူမ၌ဟိသော ဝမ်းစာအားလုံးကိုပင် ပီးလှူ ဗျာယ်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","တပည့်တော်တချို့က ဗိမာန်တော်သည် လှပသောကျောက်တုံးများ၊ ဘုရားသခင်အား ပူဇော်လှူဒါန်းထားသော ဝတ္ထုပစ္စည်းများနှင့် အလွန်တင့်တယ်လျက်ဟိကြောင်းကို ပြောဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","ယေသျှုက “သင်ရို့မြင်ရသော အရာများသည် ကျောက်ခဲတစ်တုံးတောင်မှ မူလနီရာ၌ တင်၍ မဟိအောင် ပြိုပျက်သည့်အချိန် ရောက်လာလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ထိုသူရို့က “ဆရာ၊ ဤအမှုအရာများသည် ဇာအချိန်၌ ဖြစ်ပျက်ပါမည်နည်း။ ထိုအမှုအရာများ ဖြစ်ပျက်ချိန်၌ ဇာနိမိတ်လက္ခဏာတိ ပေါ်ထွန်းလာမည်နည်း” ဟု မိန်းလျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ယေသျှုကလည်း၊ “သင်ရို့သည် လှည့်စားခြင်း မခံရစီခြင်းငှာ သတိထားကြလော့။ လူတိက ငါ့အယောင်ဆောင်၍ ‘ငါသည် မေသျှိယဖြစ်သည်’ ဟု ဆို၍ လည်းကောင်း၊ ‘အချိန်ရောက်လာဗျာယ်’ ဟု ဆို၍ လည်းကောင်း၊ သင်ရို့ပါးကို ရောက်လာကြလိမ့်မည်။ ထိုသူရို့နောက်ကို မလိုက်ကတ်ကေ့။ ");
INSERT INTO rki_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","သင်ရို့သည် စစ်တိုက်ခြင်းအကြောင်းနှင့် တော်လှန်ပုန်ကန်ခြင်းအကြောင်း သတင်းကို ကြားကြသောအခါ ကြောက်ရွံ့စိုးရိမ်ခြင်း မဟိကတ်ကေ့။ ဤအမှုအရာတိသည် အယင်ဦးစွာ ဖြစ်ပျက်ရမည်။ သို့သော်လည်း နောက်ဆုံးသော အချိန်ကား မရောက်သိမ့်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","ထို့ပြင် ကိုယ်တော်က၊ “လူတစ်မျိုးနှင့် တစ်မျိုး၊ နိုင်ငံတစ်နိုင်ငံနှင့် တစ်နိုင်ငံ စစ်ဖြစ်ကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","နီရာအနှံ့တွင် မြီငလျင် ပြင်းထန်စွာလှုပ်ခြင်း၊ အစာခေါင်းပါးခြင်း၊ ကပ်ရောဂါ ကျရောက်ခြင်းများ ဖြစ်လိမ့်မည်။ ကောင်းကင်မှလည်း ကြောက်မက်ဖွယ်သော အရာများနှင့် ပုဗ္ဗနိမိတ်များ ဖြစ်ပေါ်လာကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","ဤအမှုအရာတိ မဖြစ်ခင် ငါ၏နာမကြောင့် သင်ရို့ကို လူတိက ဖမ်းဆီးညှဉ်းဆဲပြီးလျှင် တရားဇရပ်များတွင် လည်းကောင်း၊ အကျဉ်းထောင်များတွင် လည်းကောင်း အပ်နှံကြလိမ့်မည်။ သျှင်ဘုရင်၊ အုပ်ချုပ်သူတိပါးသို့ ပို့ဆောင်ကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ဤသို့အားဖြင့် သင်ရို့သည် သတင်းကောင်းကို ပြောရသောအခွင့် ရကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ထို့ကြောင့် သင်ရို့ကိုယ်တိုင် ဇာပိုင် ပြန်ပြောရမည်ကို ကြိုတင်၍ မစိုးရိမ်ကြစီခြင်းငှာ စိတ်ကိုခိုင်ခန့်စီကြလော့။ ");
INSERT INTO rki_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","အကြောင်းမူကား သင်ရို့၏ ရန်သူတစ်ဦးတစ်ယောက်မျှ မငြင်းခုံ၊ မဟန့်တားနိုင်အောင် သင်ရို့အား နှုတ်သတ္တိ၊ ဉာဏ်သတ္တိကို ငါပီးမည်။ ");
INSERT INTO rki_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","သင်ရို့ကို မိဖ၊ ညီအစ်ကို၊ ဆွီမျိုးသားချင်း၊ အဆွီခင်ပွန်းတိက ရန်သူ့လက်ကို အပ်နှံကြပြီးလျှင် တချို့ကို အသီသတ်ကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","လူတိုင်းက ငါ၏နာမကြောင့် သင်ရို့ကို မုန်းတီးကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","သို့သော်လည်း သင်ရို့၏ဂေါင်းမှ ဆံချည်တစ်မျှင်တောင်မျှ ပျက်စီးလိမ့်မည် မဟုတ်။ ");
INSERT INTO rki_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","သင်ရို့သည် တည်ကြည်သောအားဖြင့် ကယ်တင်ခြင်းသို့ ရောက်ကြလော့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“ယေရုဆလင်မြို့ကို စစ်တပ်များ ပတ်လည်ဝိုင်းရံထားသည်ကို သင်ရို့မြင်သောအချိန်ကား ထိုမြို့သည် မကြာမီ ပျက်စီးလိမ့်မည်ကို သင်ရို့သိထား၏။ ");
INSERT INTO rki_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ထိုအချိန်၌ ယုဒပြည်၌ဟိသော လူတိက တောင်ထက်သို့ ဗြီးကြစီ။ မြို့ထဲ၌ ဟိနိန်သော လူရို့သည် မြို့ပြင်ကို ထွက်လားစီ။ တောရွာ၌ ဟိနိန်ကြသောသူသည် မြို့ထဲကို မဝင်စီကတ်ကေ့။ ");
INSERT INTO rki_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","အကြောင်းမူကား၊ ထိုနိ့ရက်ကာလများသည် ကျမ်းစာ၌ ဖော်ပြထားသောအရာအားလုံး ပြည့်စုံမည့် ‘ပြစ်ဒဏ်စီရင်သော နိ့ရက်ကာလ’ ပင် ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ထိုနိ့ရက်ကာလ၌ ကိုယ်ဝန်လွယ်ထားသော မိန်းမတိနှင့် နို့စို့ချေဟိသော မိခင်တိအတွက် အလွန်ခက်ခဲလိမ့်မည်။ ယုဒပြည်သည် အတိဒုက္ခရောက်ပြီးလျှင် တိုင်းသူပြည်သားရို့သည် အမျက်တော် သင့်ကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","လူတချို့သည် ဒါးဖီးနှင့် သီရပြီးလျှင် တချို့က သုံးပန်းအဖြစ် အတိုင်းတိုင်းအပြည်ပြည်သို့ ဖမ်းလားခြင်း ခံရလိမ့်မည်။ တစ်ပါးအမျိုးသားရို့သည် မိမိရို့အချိန်ကာလ ပြည်စုံသည်အထိ ယေရုဆလင်မြို့ကို နင်းခြီကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“နီ၊ လ၊ ကြယ်နက္ခတ်များ၌ ပုဗ္ဗနိမိတ်တိ ထင်ရှားလိမ့်မည်။ မြီကြီးထက်၌လည်း လူမျိုးအသီးသီးရို့သည် သမုဒ္ဒရာလှိုင်းတံပိုး ကြီးခြင်းကြောင့် မငြိမ်မသက်ဖြစ်ခြင်း၊ ကြောက်ရွံ့တုန်လှုပ်ခြင်း ဖြစ်ကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","လူတိက ကမ္ဘာမြီကြီး၌ ကျရောက်လတ္တံ့သော ကပ်ဖီးများကို မျှော်ကြည့်၍ ကြောက်လန့်ကာ မိ့မောကြလိမ့်မည်။ အကြောင်းမူကား ကောင်းကင်တန်ခိုးများ တုန်လှုပ်ကြသောကြောင့် ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ထိုအချိန်၌ လူသားသည် တိမ်ကိုစီးပြီး ကြီးစွာသော ဘုန်းတန်ခိုးကိုဆောင်၍ ကြွလာတော်မူသည်ကို သူရို့သည် မြင်ကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ဤအမှုအရာများ ဖြစ်ပျက်လာသောအခါ သင်ရို့အား ရွီးနုတ်ကယ်တင်တော်မူခြင်းငှာ အချိန်နီးကပ် နိန်ပြီဖြစ်၍ သင်ရို့၏ဂေါင်းကို မော့၍ အထက်ကို မျှော်ကြည့်ကြလော့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ထို့နောက် ကိုယ်တော်သည် သူရို့အား ပုံဥပမာဆောင်၍၊ “သင်္ဘောသဖန်းပင်နှင့် အခြားသော သစ်ပင်တိကို မှတ်ကြလော့။ ");
INSERT INTO rki_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ထိုအပင်များ ရွက်နုထွက်သည်ကို သင်ရို့မြင်သောအခါ နွီကာလ နီးပြီဖြစ်ကြောင်း သိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ထိုနည်းတူ ဖော်ပြခသော အမှုအရာများ ဖြစ်ပျက်နိန်သည်ကို မြင်ရလျှင် ဘုရားသခင်၏ နိုင်ငံတော်တည်ချိန် နီးပြီဖြစ်ကြောင်း သိမှတ်ကြလော့။ ");
INSERT INTO rki_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“ငါအမှန်ကန်ဆိုသည်ကား၊ အဂု အသက်ရှင်နိန်သော လူများမသီဆုံးခင် ဤအကြောင်းအရာအားလုံး ဖြစ်ပျက်ရလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ကောင်းကင်နှင့်မြီကြီး မတည်သော်လည်း ငါ့စကားတည်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“သင်ရို့သည် သောက်စားမူးယစ်ခြင်း၊ လောကီမှုအတွက် စိုးရိမ်ပူပန်ခြင်းများနှင့် အချိန်မကုန်စီရန် သတိနန့် နိန်ကြလော့။ သို့မဟုတ် ငါပြန်ကြွလာမည့် ထိုနိ့ရက်သည် ထောင်ချောက်ပိုင် သင်ရို့ပါးသို့ ရုတ်တရက် ရောက်လာလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","အကြောင်းမူကား ထိုနိ့ရက်သည် လောက၌ဟိသော လူသားအားလုံးကို အုပ်မိလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","နိုးနိုးကြားကြားနီ၍ အစဉ်မပြတ် ဆုတောင်းကြလော့။ အကြောင်းမူကား ကျရောက်လာမည့်ဖီးနှင့် ကင်းလွတ်ပြီး လူသား၏ရှိ့တော်မှောက်၌ မတ်မတ်ရပ်နိုင်မည် အကြောင်းတည်း” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ကိုယ်တော်သည် နိ့အခါ၌ ဗိမာန်တော်၌ ဟောပြောသွန်သင်တော်မူပြီးလျှင် ညအခါ၌ သံလွင်တောင်သို့လား၍ ညဉ့်ကို လွန်စီတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","လူအပေါင်းရို့သည် ဗိမာန်တော်၌ တရားတော်နားထောင်ကြရန် နံနက်စောစောထ၍ ကိုယ်တော့်ထံသို့လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","ပသခါပွဲဟု ခေါ်သော တဆီးမဲ့မုန့် ပွဲတော်အချိန် နီးလာလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ယဇ်ပုရောဟိတ်ကြီးရို့နှင့် ကျမ်းတတ်ဆရာရို့သည် လူတိကို ကြောက်သောကြောင့် ကိုယ်တော့်ကို လျှို့ဝှက်စွာသတ်ရန် နည်းလမ်း ရှာဖွီလျက်နိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ထိုအခါ စာတန်သည် တပည့်တော်တစ်ဆယ့်နှစ်ပါး အပါဝင်ဖြစ်သော ယုဒသျှကာရုတ်ထဲသို့ ဝင်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ထို့ကြောင့် ယုဒသည် ယဇ်ပုရောဟိတ်ကြီးရို့နှင့် ဗိမာန်တော်မှူးရို့ပါးသို့ လား၍ ကိုယ်တော့်ကို မည်သည့်နည်းဖြင့် အပ်ရန် ဆွေးနွေးတိုင်ပင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","သူရို့သည် ဝမ်းမြောက်ကြ၍ ဖဲသာပီးမည်ဟု ဝန်ခံကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ယုဒသည် သဘောတူညီလျက် လူများမသိအောင် ယေသျှုအား သူရို့လက်သို့ အပ်ရန် အချိန်ကောင်းကို ရှာကြံလျက် နိန်၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","တဆီးမဲ့မုန့် ပွဲတော်တွင် ပသခါသိုးသူငယ်ကိုသတ်၍ ပူဇော်ရာနိ့ရက် ကျရောက်လာ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ယေသျှုက ပေတရုနှင့် ယောဟန်ရို့အား “ငါရို့စားရန် ပသခါပွဲညစာကို လားပြီး ပျင်ဆင်ကြလော” ဟု ဆို၍ စီရွှတ်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","သူရို့က “ဇာအရပ်တွင် ပျင်ဆင်ရပါမည်နည်း” ဟု မိန်းလျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ကိုယ်တော်က “သင်ရို့သည် မြို့တွင်းကို ဝင်သောအခါ ရီအိုးကို ထမ်းလာသော လူတစ်ယောက်က သင်ရို့ကို ကြိုဆိုလိမ့်မည်။ သူ့နောက်ကိုလိုက်ပြီး သူဝင်လားသော အိမ်ထဲသို့ ဝင်ကြလော့။ ");
INSERT INTO rki_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","အိမ်သျှင်အား ‘ငါနန့် ငါ့တပည့်တော်တိ ပသခါပွဲညစာကိုစားဖို့ အခန်းကား ဇာမာလဲ၊ ဆရာက မိန်းသည်’ ဟု ပြောပါ။ ");
INSERT INTO rki_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ထိုသူက ပျင်ဆင်ထားသော ကျယ်ဝန်းသော အထက်ခန်းကို ပြလိမ့်မည်။ ထိုအခန်း၌ အသင့် ပျင်ဆင်ကြလော” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","သူရို့သည် ထွက်လားပြီးနောက် ကိုယ်တော် မိန့်မှာတော်မူသည့်အတိုင်း တွိ့ရကြသဖြင့် ပသခါပွဲတော်ကို အသင့်ပျင်ဆင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","ထိုအချိန် ရောက်လာသောအခါ ယေသျှုသည် တမန်တော်ရို့နှင့်အတူ စားပွဲတွင် ထိုင်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ကိုယ်တော်က၊ “ငါသည် အသီမခံရခင် ဤပသခါပွဲညစာကို သင်ရို့နှင့်အတူစားဖို့ အလွန်အလိုဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","ငါဆိုသည်ကား၊ ပသခါပွဲ၏ ရည်ရွယ်ချက်သည် ဘုရားသခင်၏ နိုင်ငံတော်၌ ပြည့်စုံခြင်းသို့ မရောက်ခင်အထိ နောက်တဖန် ငါစားလိမ့်မည် မဟုတ်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ထို့နောက် ယေသျှုသည် ခွက်ကိုယူ၍ ဘုရားသခင်၏ကျေးဇူးတော်ကို ချီးမွမ်းတော်မူပြီးလျှင် “ဤခွက်ကိုယူပြီး အချင်းချင်း မျှဝီကြလော့။ ");
INSERT INTO rki_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","သင်ရို့အား ငါဆိုသည်ကား၊ အဂုမှစ၍ ဘုရားသခင်၏ နိုင်ငံတော်မတည်မချင်း ဤစပျစ်ရည်ကို နောက်တဖန် ငါသောက်လိမ့်မည် မဟုတ်” ဟု မိန့်တော်မူလျက်၊ ");
INSERT INTO rki_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ကိုယ်တော်သည် မုန့်ကိုယူ၍ ဘုရားသခင်၏ကျေးဇူးတော်ကို ချီးမွမ်းပြီးမှ မုန့်ကိုဖဲ့၍ တပည့်တော်ရို့အား ပီးတော်မူပြီးလျှင် “ဤမုန့်ကား သင်ရို့အတွက်စွန့်သော ငါ၏ကိုယ်ခန္ဓာဖြစ်၏။ ငါ့ကို အောက်မိ့ဖို့ ဤသို့ပြုကြလော့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","ထိုနည်းတူ ညစာစားပြီးနောက် ခွက်ကို ယူတော်မူလျက် “ဤခွက်ကား သင်ရို့အဖို့ သွန်းသော ငါ၏အသွီးနှင့်ပြုသည့် ပဋိညာဉ်တရားသစ်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“သို့သော်လည်း ကြည့်ရှုကြလော့။ ငါ့ကို ရန်သူလက်သို့ အပ်မည့်သူသည် ငါနန့်အတူ စားပွဲ၍ ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","လူသားသည် ဘုရားသခင် ခန့်ခွဲမှတ်သားတော်မူသည်အတိုင်း အသီခံရန် အမှန်ပင်လားရမည်။ သို့သော်လည်း လူသားကို ရန်သူလက်သို့ အပ်နှံသူသည် အမင်္ဂလာဟိ၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","တပည့်တော်ရို့သည် မိမိရို့အထဲမှ ဇာသူက ဤအမှုကို ပြုလိမ့်မည်နည်းဟု အချင်းချင်း မိန်းမြန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","တပည့်တော်ရို့သည် မိမိရို့ထဲတွင် ဇာသူက အကြီးမြတ်ဆုံးဖြစ်သနည်းဟု ငြင်းခုံကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ယေသျှုက၊ “လောကီမင်းရို့သည် တိုင်းသူပြည်သားတိအထက်၌ သြဇာအာဏာဟိကြ၏။ အာဏာပိုင်တိကလည်း မိမိရို့ကို ‘ကျေးဇူးသျှင်များ’ ဟု အခေါ်ခံတတ်ကြ၏။” ");
INSERT INTO rki_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","သင်ရို့သည် ထိုသို့ မဖြစ်သင့်။ သင်ရို့ထဲ၌ အကြီးမြတ်ဆုံး ဖြစ်သောသူက အငယ်ဆုံးသောသူကဲ့သို့ ဖြစ်ရလိမ့်မည်။ ခေါင်းဆောင်ဖြစ်သောသူက အစီခံကဲ့သို့ ဖြစ်ရမည်။ ");
INSERT INTO rki_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","စားပွဲ၌ထိုင်နိန်သူနှင့် လုပ်ကျွေးသောသူထဲက ဇာသူက သာ၍ ကြီးမြတ်သူ ဖြစ်သနည်း။ စားပွဲ၌ ထိုင်သူ မဟုတ်လော။ သို့သော်လည်း ငါက သင်ရို့ထဲ၌ လုပ်ကျွေးသူပိုင်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“သင်ရို့သည် ငါနန့်အတူ စုံစမ်းနှောင့်ယှက်မှုများကို ရင်ဆိုင်ခသူတိ ဖြစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ခမည်းတော်က ငါ့အား အုပ်စိုးခွင့်ကို ပီးအပ်တော်မူသကဲ့သို့ ငါသည်လည်း သင်ရို့အား အုပ်စိုးခွင့်ကို ပီး၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","သင်ရို့သည် နိုင်ငံတော်ထဲတွင် ငါ့စားပွဲဝိုင်း၌ စားသောက်ရကြလိမ့်မည်။ ပြီးလျှင် ပလ္လင်ထက်၌ ထိုင်၍ ဣသရေလလူမျိုး တစ်ဆယ့်နှစ်မျိုးကို အုပ်စိုးရကြလိမ့်မည် ဟု မိန့်တော်မူ၏။” ");
INSERT INTO rki_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","ယေသျှုကလည်း၊ “သျှိမုန်၊ သျှိမုန်၊ နားထောင်လော့။ လယ်သမားသည် ကောင်းသောဂျုံစပါးမှ မကောင်းသော ဂျုံစပါးကို ဆန်ခါနှင့် ချသကဲ့သို့ သင်ရို့အားလုံးကို စုံစမ်းရန် စာတန်က အခွင့်ရလီဗျာယ်။ ");
INSERT INTO rki_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ယေကေလေ့ သျှိမုန်၊ သင်၏ ယုံကြည်ခြင်း မပျက်စီးစီရန် ငါဆုတောင်းနိန်၏။ သင်သည် သတိပြန်ရကြသောအခါ သင်၏ ညီအစ်ကိုတိကို ခိုင်ခန့်စီလော” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ပေတရုက၊ “သခင်ဘုရား၊ အကျွန်သည် ထောင်ထဲ၌ဖြစ်စီ၊ သီရဖို့ပင်ဖြစ်စီ ကိုယ်တော်နှင့်အတူလိုက်ရန် အသင့်ဟိပါ၏” ဟု လျှောက်၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ကိုယ်တော်က၊ “ပေတရု၊ ငါပြောမည်၊ ဤနိ့ည ကြက်မတွန်ခင် သင်သည် ငါ့ကို မသိဟု ဆိုပြီး သုံးကြိမ်တိုင်တိုင် ငြင်းဆိုလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ထို့နောက် ယေသျှုက “ငါသည် သင်ရို့အား ဖဲသာအိတ်၊ လွယ်အိတ်နှင့် ဖိနပ်ကိုမယူဘဲ စီရွှတ်ခသောအခါ တခုခုလိုသိမ့်လား” ဟု မိန်းလျှင်၊ “တစ်ခုလေ့ မလိုပါ” ဟု တပည့်တော်ရို့က လျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ယေသျှုက “အဂုကား ဖဲသာအိတ်၊ လွယ်အိတ်ဟိလျှင် ယူလာလိုက်။ ဒါးမဟိလျှင် အဝတ်ကိုရောင်း၍ ဒါးကိုဝယ်ကတ်။ ");
INSERT INTO rki_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","သင်ရို့အား ငါဆိုသည်ကား၊ ‘ထိုသူသည် ပြစ်မှုကျူးလွန်သူများနှင့် ရီတွက်ခြင်းခံရ၏’ ဟု ကျမ်းစာက ပြောသည်အတိုင်း ငါခံရမည်။ ဇာကြောင့်ဆိုသော် ငါ့အကြောင်းကို ရီးသားထားသော ကျမ်းစာအတိုင်း ဖြစ်ပျက်နိန်သောကြောင့်ဖြစ်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","တပည့်တော်ရို့က “သခင်ဘုရား၊ ကြည့်တော်မူပါ၊ ဤမှာ ဒါးနှစ်လက် ဟိပါ၏” ဟု လျှောက်သော်၊ ကိုယ်တော်က “လုံလောက်ပြီ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","ယေသျှုသည် မြို့မှထွက်လာပြီးနောက် ပြုလေ့ဟိသည်အတိုင်း သံလွင်တောင်သို့ ကြွတော်မူ၏။ တပည့်တော်ရို့သည်လည်း နောက်တော်သို့ လိုက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ထိုအရပ်သို့ ရောက်တော်မူလျှင် ကိုယ်တော်က “သင်ရို့သည် စုံစမ်းသွီးဆောင်ရာသို့ မကျရောက်စီရန် ဆုတောင်းကြလော့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ထို့နောက် တပည့်တော်ရို့နှင့် ကျောက်ခဲ တစ်ပစ်စာလောက် ဝီးသောအရပ်သို့ ကြွတော်မူပြီး ဒူးထောက်လျက်၊ ");
INSERT INTO rki_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“အိုအဖ၊ အလိုတော်ဟိလျှင် ဤဒုက္ခဝေဒနာခွက်ကို အကျွန်နှင့် ဝီးစီတော်မူပါ။ သို့သော်လည်း အကျွန့်အလိုတိုင်း မဖြစ်ပါစီကေ့။ အဖ၏အလိုတော်တိုင်းသာ ဖြစ်စီတော်မူပါ” ဟု ဆုတောင်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ထိုအခါ ကောင်းကင်တမန်သည် ထင်ရှားလာ၍ ကိုယ်တော့်ကို အားပီးလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ကိုယ်တော်သည် ပြင်းစွာသောဝေဒနာကို ခံစားပြီး အထူးကြိုးစား၍ ဆုတောင်းတော်မူသောကြောင့် ကိုယ်တော်၏ချွေးပေါက်များသည် မြီကြီးတွင်ကျသော သွီးစက်ကဲ့သို့ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ကိုယ်တော်သည် ဆုတောင်းရာမှ ထတော်မူပြီးလျှင် တပည့်တော်ရို့ဟိရာသို့ ပြန်ကြွတော်မူသောအခါ သူရို့သည် ညှိုးငယ်သောစိတ်နှင့် အိပ်ပျော် နိန်ကြသည်ကို မြင်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ကိုယ်တော်က၊ “သင်ရို့ဇာကြောင့် အိပ်ပျော် နိန်ကြသနည်း။ ထကြလော့။ စုံစမ်းသွီးဆောင်ခြင်းသို့ မကျရောက်စီရန် ဆုတောင်းကြလော့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ထိုသို့ ယေသျှုသည် မိန့်တော်မူစဉ် တပည့်တော် တစ်ဆယ့်နှစ်ပါး အပါဝင်ဖြစ်သော ယုဒသျှကာရုတ်သည် လူထုကြီးကို ဦးဆောင်၍ ရောက်လာပြီး၊ ယေသျှုအား နမ်းခြင်းငှာ ချဉ်းကပ်လာ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ယေသျှုက “ယုဒ၊ သင်သည် နမ်းခြင်းကိုပြု၍ လူသားအား ရန်သူလက်သို့ အပ်သလော” ဟု မိန်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","တပည့်တော်ရို့သည် အခြေအနေကို မြင်သောအခါ ယေသျှုအား “သခင်ဘုရား၊ အကျွန်ရို့ဓါးနှင့် ခွတ်ရပါမည်လော” ဟု မိန်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","တပည့်တော်တစ်ယောက်သည် ယဇ်ပုရောဟိတ်မင်း၏ ကျွန်တစ်ယောက်ကို ခွတ်လိုက်လျှင် ထိုသူ၏ ညာဖက်နားရွက် ပြတ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","ထိုအခါ ယေသျှုက “တန်ဖိ” ဟု မိန့်တော်မူ၏။ ကိုယ်တော်သည် ထိုသူ၏နားရွက်ကို လက်တော်နှင့် တို့တော်မူ၍ အနာကို ပျောက်စီတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ထို့နောက် ယေသျှုက မိမိအားဖမ်းဆီးရန် ရောက်လာကြသည့် ယဇ်ပုရောဟိတ်အကြီးအကဲတိ၊ ဗိမာန်တော်စောင့်တပ်မှူးတိ၊ လူအကြီးအကဲတိအား “သင်ရို့သည် ဒါးပြကို ဖမ်းစွာပိုင် ငါ့ကိုဖမ်းဖို့ ဒါးတိ၊ တုတ်တိနှင့် လာကြသလော။ ");
INSERT INTO rki_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ငါသည် ဗိမာန်တော်ထဲ၌ နိ့တိုင်းဟိသောအခါ သင်ရို့သည် ငါ့ကို မဖမ်းဆီးကတ်။ ယေဒါလည်း ဤအချိန်ကား သင်ရို့၏ အချိန်ဖြစ်၏။ မှောင်မိုက်တန်ခိုး ကြီးစိုးရာ အချိန်လည်းဖြစ်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ထိုသူရို့သည် ယေသျှုကို ဖမ်းဆီးပြီးလျှင် ယဇ်ပုရောဟိတ်မင်း၏အိမ်တော်သို့ ခေါ်ဆောင်လားကြ၏။ ပေတရုသည် မနီးမဝီးမှနိန်၍ လိုက်လာ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","အိမ်တော်ဝင်းအလယ်၌ လူအပေါင်းရို့သည် မီးဖို၍ ထိုင်နိန်ကြ၍ ပေတရုကလည်း သူရို့အထဲ၌ ထိုင်နိန်၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ထိုသို့ ပေတရုထိုင်နိန်သည်ကို မြင်သော အစီခံမိန်းမတစ်ယောက်သည် စိ့စိ့ကြည့်၍ “ဤသူသည် ယေသျှု၏ အပေါင်းအပါဖြစ်သည်” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","သို့ရာတွင် ပေတရုက “အချင်းမိန်းမ ထိုသူကိုငါမသိ” ဟု ငြင်းဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ထို့နောက် တအောင့်ကြာပြီးမှ လူတစ်ယောက်သည် ပေတရုကိုမြင်သဖြင့် “သင်လည်း ထိုသူရို့ထဲက တစ်ယောက်ဖြစ်၏” ဟု ဆိုသော်၊ ပေတရုက၊ “အချင်းလူ၊ ငါသည် သူရို့ထဲက မဟုတ်” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ထို့နောက် တစ်နာရီလောက် ကြာပြီးသောအခါ အခြားသော လူတစ်ယောက်က “ဤသူသည် ဂါလိလဲလူဖြစ်ပြီး ယေသျှု၏ အပေါင်းအပါဖြစ်သည်ကို ယုံမှားစရာမဟိ” ဟု အခိုင်အမာဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","သို့သော်လည်း ပေတရုက “အချင်းလူ၊ သင်ပြောသည့်အကြောင်းကို ငါမသိ” ဟု ဆို၏။ ဤသို့ ပေတရုပြောနိန်စဉ် ကြက်တွန်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","သခင်ဘုရားသည်လည်း လှည့်၍ ပေတရုကို စိ့စိ့ကြည့်တော်မူ၏။ ထိုအခါ ပေတရုသည် “ဤနိ့ည ကြက်မတွန်ခင် သင်သည် ငါ့ကိုမသိဟု သုံးကြိမ်တိုင်အောင် ဆိုလိမ့်မည်” ဟူသော သခင်ဘုရား ပြောခသည်ကို ပြန်၍ သတိရသဖြင့်၊ ");
INSERT INTO rki_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ပေတရုသည် ပြင်သို့ထွက်၍ ပြင်းစွာ ငိုကြွီးလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","ယေသျှုကို စောင့်ကြပ်နိန်သူရို့က လှောင်ပြောင်၍ ရိုက်ပုတ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","သူရို့သည် ကိုယ်တော်၏ မျက်နှာတော်ကို ဖုံးပြီးလျှင် “သင့်အား ဇာသူ ရိုက်ပုတ်ကြောင်းကို ပြောပါ” ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","သူရို့သည် ကိုယ်တော့်ကို အခြားသော စကားများဖြင့်လည်း စော်ကားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","မိုးလင်းသောအခါ ယုဒခေါင်းဆောင်တိ၊ ယဇ်ပုရောဟိတ်ကြီးတိနှင့် ကျမ်းတတ်ဆရာရို့သည် စုဝေးကြ၍ ကိုယ်တော့်ကို တရားလွှတ်တော်သို့ ခေါ်ဆောင်လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","သူရို့က “သင်သည် မေသျှိယဖြစ်သလော၊ ငါရို့ကိုပြောပါ” ဟု ဆိုကြ၏။ ကိုယ်တော်က “ငါပြောလျှင် သင်ရို့ ယုံကြမည် မဟုတ်။ ");
INSERT INTO rki_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","သင်ရို့အား ငါ မိန်းသော်လည်း သင်ရို့ဖြေမည် မဟုတ်။ ");
INSERT INTO rki_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","အဂုကစပြီး လူသားသည် အနန္တတန်ခိုးသျှင် ဘုရားသခင်၏ လက်ယာဖက်၌ ထိုင်တော်မူလတ္တံ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ထိုသူရို့ကလည်း “ထိုသို့ဆိုသော် သင်သည် ဘုရားသခင်၏ သားတော်ဖြစ်ပါသလော” ဟု မိန်းကြလျှင်၊ ကိုယ်တော်ကလည်း၊ “သင်ရို့ ပြောသည့်အတိုင်း မှန်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ထိုအခါ သူရို့က၊ “ဇာသက်သီ လိုသိမ့်လဲ၊ ငါရို့ကိုယ်တိုင် သူ၏စကားကို ကြားရဗျာယ်” ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","တရားလွှတ်တော်၌ စုဝေးသောသူအပေါင်းရို့သည် ထ၍ ယေသျှုကို ပိလတ်ထံသို့ ယူဆောင်လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ထို့နောက် ထိုသူရို့က “ဤသူသည် ပြည်သူပြည်သားတိကို လှည့်ဖြား၍ ကဲသာဘုရင်အား အခွန်တော်မဆက်ကေ့ဟု တားမြစ်သည်ကိုလည်းကောင်း၊ မိမိသည် မေသျှိယဆိုသော ဘုရင်တပါးဖြစ်ကြောင်း ပြောဆိုသည်ကိုလည်းကောင်း အကျွန်ရို့ တွိ့ရပါ၏” ဟု ဆို၍ ကိုယ်တော့်ကို စတင်၍ စွပ်စွဲကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ထိုအခါ ပိလတ်ကလည်း “သင်သည် ယုဒသျှင်ဘုရင်မှန်သလော” ဟု ယေသျှုအား မိန်းတော်မူလျှင်၊ ယေသျှုက “သင် ပြောသည့်အတိုင်း ဖြစ်၏” ဟု ဖြေတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ထို့နောက် ပိလတ်က “ဤသူကို စွဲချက်တင်ရန် အကြောင်းတစ်စုံတစ်ခုကိုမျှ ငါမတွိ့” ဟု ယဇ်ပုရောဟိတ်ကြီးများနှင့် လူအပေါင်းရို့အားဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","သို့သော် ထိုသူရို့က “သူသည် ဂါလိလဲပြည်မှစ၍ ဤအရပ်ဒေသထိတိုင်အောင် ယုဒပြည်အနှံ့အပြား၌ ဟောပြောပြီးလျှင် ပြည်သူတိကို ရုန်းရင်းဆန်ခတ်ဖြစ်အောင် လှုံ့ဆော် နိန်ပါ၏” ဟု ပို၍ ကျယ်သောအသံဖြင့် တိုက်တွန်းပြောဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ပိလတ်သည် ထိုစကားကို ကြားသောအခါ “ဤသူကား ဂါလိလဲပြည်သားလော” ဟု မိန်း၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ယေသျှုသည် ဟေရုဒ်အုပ်ချုပ်သော ဂါလိလဲပြည်သားဖြစ်ကြောင်းကို သိလျှင် ကိုယ်တော့်ကို ဟေရုဒ်ထံသို့ ပို့လေ၏။ ထိုအချိန်တွင် ဟေရုဒ်သည် ယေရုဆလင်မြို့၌ ရောက်နိန်ချိန်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ဟေရုဒ်သည် ယေသျှုကို မြင်သောအခါ အလွန်ဝမ်းမြောက်ခြင်းဟိ၏။ ကိုယ်တော်၏သတင်းတော်ကို များစွာ ကြားခရသဖြင့် ကိုယ်တော့်ကို တွိ့မြင်လိုသည်မှာ ကြာဗျာယ်။ ကိုယ်တော်ပြသည့် နိမိတ်လက္ခဏာတစ်ခုခုကို မြင်ရလိမ့်မည်ဟု မျှော်လင့်နိန်၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ထို့ကြောင့် ဟေရုဒ်က ယေသျှုကို မိန်းခွန်းများစွာ မိန်းသော်လည်း ယေသျှုက ဖြေကြားတော်မူခြင်းမဟိ။ ");
INSERT INTO rki_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ယဇ်ပုရောဟိတ်ကြီးရို့နှင့် ကျမ်းတတ်ဆရာရို့သည် ရှိ့သို့လာ၍ ယေသျှုကို ပြင်းထန်စွာ စွပ်စွဲပြောဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ဟေရုဒ်နှင့် သူ၏စစ်သားရို့သည် ယေသျှုအား မထီလေးစားပြု၍ သရော်ကြ၏။ ထို့နောက် ကိုယ်တော့်အား တင့်တယ်သောဝတ်ရုံကို ဝတ်ပီးပြီးလျှင် ကိုယ်တော့်ကို ပိလတ်ထံသို့ ပြန်ပို့စီ၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","အယင်က ရန်သူဖြစ်ခသော ပိလတ်နှင့် ဟေရုဒ်ရို့သည် ထိုနိ့တွင် သင့်မြတ်လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ပိလတ်က ယဇ်ပုရောဟိတ်ကြီးတိ၊ ယုဒခေါင်းဆောင်တိနှင့် လူတိကိုခေါ်၍၊ ");
INSERT INTO rki_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ထိုသူရို့အား “ဤသူသည် ပုန်ကန်ဖို့ တိုင်းသူပြည်သားတိကို လှုံ့ဆော်သူဖြစ်သည်ဆို၍ သင်ရို့က ဤသူ့ကို ငါ့အပါးသို့ ခေါ်လာကြ၏။ သင်ရို့ရှိ့၌ ငါ စစ်ဆေးခဗျာယ်။ ယေကေလေ့ သင်ရို့ဆိုသည်အတိုင်း ထိုသူ့ကို စွပ်စွဲနိုင်ရန် အပြစ်တစ်စုံတစ်ခုမျှ ငါမတွိ့။ ");
INSERT INTO rki_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ဟေရုဒ်လည်း အပြစ်မတွိ့၍ ငါရို့ပါးသို့ ပြန်ပို့ခြင်းဖြစ်၏။ ဤသူသည် သီဒဏ်ထိုက်သည့်အပြစ် တစ်စုံတစ်ခုကိုတောင် မကျူးလွန်ခ။ ");
INSERT INTO rki_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","ယေဇူးနန့် ဤသူ့ကို ကြိမ်ဒဏ်ပီးပြီးကေ လွှတ်လိုက်မည်” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","လူထုပရိသတ်အားလုံးက “သူ့ကို သီဒဏ်ပီးပါ။ အကျွန်ရို့အတွက် ဗာရဗ္ဗကို လွှတ်ပီးပါ” ဟု တညီတညွတ်တည်း အော်ဟစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(ဗာရဗ္ဗကား မြို့၌ ပုန်ကန်ခြင်းအပြစ်၊ လူသတ်ခြင်း အပြစ်များကြောင့် ထောင်ကျခံနိန်ရသူ ဖြစ်၏။) ");
INSERT INTO rki_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ပိလတ်သည် ယေသျှုအား လွှတ်စီချင်သောကြောင့် လူတိအား တဖန် ပြောဆိုလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","သို့သော် လူတိက “သူ့ကို လက်ဝါးကပ်တိုင်၌ တင်၍ အသီသတ်ပါ၊ လက်ဝါးကပ်တိုင်၌ တင်၍ အသီသတ်ပါ” ဟု ပြန်၍ အော်ဟစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ပိလတ်က “သူသည် ဇာအပြစ်ကို ကျူးလွန်ထားလဲ။ ဤသူ့ကို သီဒဏ်ပီးသင့်သည့်အကြောင်း တစ်စုံတစ်ခုကိုမျှ ငါမတွိ့။ ယင်းအတွက်ကြောင့် သူ့ကို ကြိမ်ဒဏ်ပီးပြီးကေ လွှတ်လိုက်မည်” ဟု ထိုသူရို့အား တတိယအကြိမ်ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","ယေဒါလည်း လူတိက ယေသျှုကို လက်ဝါးကပ်တိုင်၌ တင်သတ်ရန် အသံကုန် အော်ဟစ်တောင်းဆိုကြသဖြင့် နောက်ဆုံး၌ တောင်းဆိုချက် အနိုင်ရလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ပိလတ်သည် သူရို့ တောင်းဆိုသည့်အတိုင်း ယေသျှုအား စီရင်ချက် ချမှတ်လိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ပုန်ကန်ထကြွမှုနှင့် လူသတ်မှုတိအတွက် ထောင်ကျသူအား သူရို့တောင်းဆိုသည့်အတိုင်း လွတ်ငြိမ်းခွင့် ပီးလိုက်ပြီး ယေသျှုကိုကား သူရို့အလိုအတိုင်း လက်ထဲသို့ အပ်လိုက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","စစ်သားရို့သည် ယေသျှုကို ခေါ်ထုတ်လားကြစဉ် သျှိမုန်နာမည်ဟိသော ကုရေနေမြို့သားတစ်ယောက်သည် တောရွာမှလာသည်ကို သူရို့တွိ့ကြသော် ဖမ်းဆီး၍ လက်ဝါးကပ်တိုင်ကို ထမ်းစီပြီး ယေသျှုနောက်တော်သို့ လိုက်စီ၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","နောက်တော်၌ လိုက်ကြသော လူအုပ်ထဲတွင် ကိုယ်တော်အတွက် ငိုကြွီးမြီတမ်းနိန်သော မိန်းမတချို့လည်းပါ၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","ယေသျှုက ထိုမိန်းမတိဖက်သို့လှည့်၍ “ယေရုဆလင်မြို့သူရို့ ငါ့အတွက် မငိုကြွီးကတ်ကေ့။ သင်နှင့် သင်ရို့သားသမီးတိအတွက် ငိုကြွီးကြလော့။ ");
INSERT INTO rki_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","‘မြုံသောမိန်းမ၊ ပဋိသန္ဓေ မယူဖူးသော ဝမ်းနှင့် အချေ နို့မစို့ဖူးခသော သားမြတ်များသည် မင်္ဂလာဟိ၏’ ဟု ဆိုရသောနိ့ရက် ရောက်လာလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ထိုအချိန်၌ လူတိက တောင်များအား ‘အကျွန်ရို့အထက်၌ ပြိုကျပါ’ ဟူ၍ လည်းကောင်း၊ တောင်ကုန်းများအား ‘အကျွန်ရို့ကို ဖုံးလိုက်ပါ’ ဟူ၍ လည်းကောင်း ဆိုကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","အကြောင်းမူကား စိမ်းသောသစ်ပင်ကို ဤသို့ပြုလျှင် ခြောက်သောအပင်ကိုကား ဇာကဲ့သို့ ဖြစ်လိမ့်မည်နည်း” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","သူရို့သည် လူဆိုးနှစ်ယောက်ကိုလည်း ကိုယ်တော်နှင့်အတူသတ်ရန် ခေါ်ဆောင်လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","“ဦးဂေါင်းခွံအရပ်” ဟု နာမည်ဟိသော အရပ်သို့ ရောက်သောအခါ ကိုယ်တော်နှင့်အတူ လူဆိုးနှစ်ဦးကို လက်ယာဖက်တစ်ယောက် လက်ဝဲဖက်တစ်ယောက်ထား၍ လက်ဝါးကပ်တိုင်တွင် ရိုက်ထားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ယေသျှုက “အိုအဖ၊ သူရို့၏ အပြစ်ကို ခွင့်ရွှတ်တော်မူပါ။ သူရို့သည် ကိုယ်ပြုနိန်သောအမှုကို မသိကတ်ပါ” ဟု မြွက်ဆိုတော်မူ၏။ ထိုသူရို့သည် ကိုယ်တော်၏အဝတ်တော်ကို မဲချ၍ ဝီယူကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","လူအပေါင်းရို့သည် ရပ်လျက် ကြည့်နိန်ကြစဉ်၊ ယုဒခေါင်းဆောင်ရို့က “ဤသူသည် အခြားသူတိကို ကယ်တင်၏။ အကယ်၍ ဘုရားသခင် ရွီးချယ်တော်မူသော မေသျှိယ ဖြစ်သည်ဆိုလျှင် ကိုယ့်ကိုကိုယ် ကယ်တင်ပါစီ” ဟု ဆို၍ လှောင်ပြောင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","စစ်သားတိကလည်း ကိုယ်တော့်ကို လှောင်ပြောင်ကြပြီး ပုံးရည်ကို တိုက်လျက်၊ ");
INSERT INTO rki_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“သင်သည် ယုဒသျှင်ဘုရင် ဖြစ်သည်ဆိုလျှင် သင့်ကိုသင် ကယ်တင်ပါ” ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ကိုယ်တော်၏ ဦးဂေါင်းထက်တွင် “ဤသူကား ယုဒသျှင်ဘုရင်ပေတည်း” ဟု ကမ္ပည်း ရီးထိုးထား၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","လက်ဝါးကပ်တိုင်တွင် ရိုက်ဆွဲထားသော လူဆိုးနှစ်ဦးထဲက တစ်ယောက်က “သင်သည် မေသျှိယမှန်လျှင် မိမိကိုယ်ကိုလည်းကောင်း၊ အကျွန်ရို့ကိုလည်းကောင်း ကယ်တင်ပါ” ဟု ကိုယ်တော့်ကို ကဲ့ရဲ့ပြောဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","အခြားလူဆိုးတစ်ယောက်က ထိုသူအား “သင်သည် ဘုရားသခင်ကို မကြောက်သလော၊ အကြောင်းမူကား သင်သည် ဤသူနည်းတူ အပြစ်စီရင်ခြင်းကို ခံရ၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ငါရို့ကား မိမိအပြစ်အလျှောက် ထိုက်သင့်သည့် အပြစ်ဒဏ်ကို ခံရကြ၏။ သို့ရာတွင် ဤအသျှင်ကား ဇာအပြစ်ကိုလည်း မကျူးလွန်ခ” ဟု ပြောဆိုဆုံးမ၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ထို့နောက် ယေသျှုအား၊ “အသျှင်သည် သျှင်ဘုရင်အဖြစ် ကြွလာသောအခါ အကျွန့်ကို သတိရတော်မူပါ” ဟု လျှောက်၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ယေသျှုက “ဤနိ့ပင် သင်သည် ငါနန့်အတူ ပရဒိသုဘုံ၌ ဟိလိမ့်မည်ဟု ငါ ကတိပီး၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","ထိုအချိန်သည် မွန်းတည့်အချိန်ဖြစ်၍ သုံးချက်တီးအချိန်တိုင်အောင် မြီတပြင်လုံး၌ အလင်းကွယ်ပျောက်၍ မှောင်မိုက်အတိ ဖြစ်လေ၏။ ဗိမာန်တော်ကန့်လန့်ကာသည်လည်း နှစ်ခြမ်းကွဲလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ယေသျှုသည် “အိုအဖ၊ အကျွန်၏ ဝိညာဉ်ကို ကိုယ်တော်၏ လက်တော်သို့ အပ်ပါ၏” ဟု ကြီးသောအသံနှင့် ကြွေးကြော်ပြီးလျှင် အသက်ချုပ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","တပ်မှူးသည် ဤအဖြစ်အပျက်ကို မြင်သောအခါ “အမှန်စင်စစ် ဤသူသည် ဖြောင့်မတ်သောသူဖြစ်၏” ဟု ဆို၍ ဘုရားသခင်ကို ချီးမွမ်းလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ထိုအမှုကို ကြည့်ရှုရန် စုရုံးလာကြသော လူအပေါင်းရို့သည် ထိုအခြင်းအရာကိုမြင်လျှင် ဝမ်းနည်းစွာဖြင့် ရင်ဘတ်ကိုတီးလျက် အိမ်သို့ပြန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ဂါလိလဲပြည်မှ ကိုယ်တော်၏ နောက်သို့လိုက်ကြသော မိန်းမတိအပါအဝင် ယေသျှုကို သိကျွမ်းသူအပေါင်းရို့သည် အဝီးကရပ်ပြီး ကြည့်ရှုနိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","ထိုအခါ ယုဒပြည်၌ ယောသပ်အမည်ဟိသော အရိမဿဲမြို့သားဖြစ်၍ လူကောင်းလူဖြောင့်တစ်ယောက် ဖြစ်သည်နှင့်အညီ ဘုရားသခင်၏ နိုင်ငံတော် တည်လာမည့်အချိန်ကို စောင့်မျှော်နိန်သူဖြစ်၏။ သူသည် လွှတ်တော်အဖွဲ့ဝင် တစ်ယောက်ဖြစ်သော်လည်း တရားလွှတ်တော်၏ ဆုံးဖြတ်ချက်နှင့် လုပ်ဆောင်ချက်ကို သဘောမတူခပေ။ ");
INSERT INTO rki_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","သူသည် ပိလတ်ထံသို့ဝင်၍ ယေသျှု၏အလောင်းတော်ကို တောင်းလေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","အလောင်းတော်ကို အောက်သို့ချပြီး ပိတ်ချောဖြင့်ပတ်ရစ်ပြီးလျှင် တစ်ခါမှ မသင်္ဂြိုဟ်ဖူးသော သင်္ချိုင်းကျောက်ဂူ၌ သင်္ဂြိုဟ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ထိုနိ့ကား သောကြာနိ့ဖြစ်၍ ဥပုသ်နိ့ကိုကူးရန် အချိန်နီးပေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ဂါလိလဲပြည်မှ ယေသျှုနှင့်အတူလာသော မိန်းမရို့သည် ယောသပ်နှင့်အတူ သင်္ချိုင်းတော်ကိုလည်းကောင်း၊ အလောင်းတော်ကို မည်သို့ထားသည်ကိုလည်းကောင်း တွိ့မြင်ခြင်းငှာ လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ထို့နောက် သူရို့သည် အိမ်သို့ပြန်၍ အလောင်းတော်အတွက် ဆီမွှီးနန့် အမွှီးနံ့သာကို အသင့်ပျင်ထား၏။ သူရို့သည် ပညတ်တော်ဟိသည့်အတိုင်း ဥပုသ်နိ့၌ အနားယူကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","တလင်းဂနီနိ့ မိုးထက်စောစောအချိန်၌ မိန်းမရို့သည် အသင့်ပျင်ဆင်ထားသော ဆီမွှီးကိုယူ၍ သင်္ချိုင်းတော်သို့ လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","သင်္ချိုင်းဂူဝမှ ကျောက်တုံးအား လှိမ့်ဖယ်ထားသည်ကို တွိ့မြင်သဖြင့်၊ ");
INSERT INTO rki_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","သူရို့သည် အတွင်းသို့ ဝင်ကြသောအခါ အသျှင်ယေသျှု၏ အလောင်းတော်ကို မတွိ့ရပေ။ ");
INSERT INTO rki_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ထိုအခြင်းအရာတိကို တွေးမရဖြစ်နိန်ကြစဉ် တောက်ပသည့်ဝတ်ရုံကို ဝတ်ထားသော လူနှစ်ယောက်သည် ရုတ်တရက်ပေါ်လာ သူရို့အနား၌ ရပ်နိန်၏။ ");
INSERT INTO rki_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","မိန်းမရို့သည် ကြောက်လန့်၍ ပျပ်ဝပ်နိန်ကြစဉ် ထိုသူနှစ်ယောက်က “သင်ရို့သည် ဇာအတွက်ကြောင့် အသီကောင်ဟိသောအရပ်၌ အသက်ရှင်သူကို ရှာကြသနည်း။ ");
INSERT INTO rki_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ကိုယ်တော်သည် ဤအရပ်၌ မဟိဗျာယ်၊ ရှင်ပြန်ထမြောက်တော်မူလားခဗျာယ်။ ကိုယ်တော်က ဂါလိလဲပြည်၌ ဟိတော်မူခစဉ်က၊ ");
INSERT INTO rki_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘လူသားသည် အပြစ်သားတိလက်သို့ အပ်နှံခြင်းကို ခံရလိမ့်မည်။ အသီသတ်ခြင်းကို ခံရ ပြီးလျှင် သုံးရက်မြောက်သောနိ့၌ သီခြင်းမှ ရှင်ပြန်ထမြောက်လိမ့်မည်’ ဟု ပြောခသောစကားကို အောက်မိ့ကြပါ” ဟုဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ထိုအခါ မိန်းမရို့သည် ကိုယ်တော်ပြောခသောစကားကို ပြန်သတိရ၍၊ ");
INSERT INTO rki_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","သင်္ချိုင်းတော်မှ မိမိအိမ်သို့ ပြန်လာကြပြီးလျှင် တစ်ကျိပ်တစ်ပါးသောသူမှစ၍ တပည့်တော်အပေါင်းအား အကြောင်းစုံကို ပြောပြကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","ထိုအကြောင်းအရာကို တမန်တော်တိအား ပြောပြသူရို့မှာ မာဂဒလရွာသူ မာရိ၊ ယောဟန္န၊ ယာကုပ်၏အမိ မာရိမှစသော အခြားသော မိန်းမတိ ဖြစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","သို့ရာတွင် သူရို့ ပြောသောစကားများသည် တမန်တော်တိအတွက် ယုတ္တိမဟိသောကြောင့် သူရို့သည် မယုံကြပေ။ ");
INSERT INTO rki_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","သို့သော်လည်း ပေတရုသည် သင်္ချိုင်းတော်သို့ဗြီးလား၍ ရောက်သောအခါ ငုံ့ကြည့်လိုက်ရာ ပိတ်စကိုသာ တွိ့ရလေ၏။ ထို့ကြောင့် ထိုအကြောင်းအရာကို အံ့သြလျက် မိမိအိမ်သို့ ပြန်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","ထိုနိ့၌ပင် တပည့်တော်နှစ်ယောက်သည် ယေရုဆလင်မြို့မှ ခုနစ်မိုင်ခန့်ကွာဝီးသော ဧမောက်ရွာသို့ ခရီးလားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ထိုသူနှစ်ဦးသည် ဖြစ်ပျက်ခသော အကြောင်းအရာအလုံးစုံတိကို ပြောဆိုနိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ထိုသို့ ဆွေးနွေးပြောဆိုနိန်ကြစဉ် ယေသျှုကိုယ်တိုင် အနားသို့ကပ်လာပြီး သူရို့နှင့်အတူ ကြွတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","သို့သော်လည်း သူရို့သည် အကြောင်းတစ်စုံတခုကြောင့် မျက်စိမှောက်၍ ကိုယ်တော်ဖြစ်သည်ကို မမှတ်မိကြ။ ");
INSERT INTO rki_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ယေသျှုက သူရို့အား “သင်ရို့ ခရီးလားယင်းနန့် ဇာအကြောင်းကို ပြောနိန်ကြသနည်း” ဟု မိန်းတော်မူ၏။ သူရို့သည် မျက်နှာညှိုးငယ်လျက် ထိုနီရာတွင် ရပ်နိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","သူရို့ထဲမှ ကလောဖဆိုသူက “ဤနိ့အတောအတွင်း ဖြစ်ပျက်ခသော အကြောင်းအရာတိကို ယေရုဆလင်မြို့၌ လာလည်သော အာဂန္တုထဲက သင်တစ်ယောက်တည်းသာ မသိဘဲနိန်သလော” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ကိုယ်တော်က “ဇာအမှုအရာတိလဲ” ဟု မိန်းတော်မူလျှင်၊ သူရို့က “နာဇရက်မြို့သား ယေသျှုနှင့် ပတ်သတ်သော အကြောင်းအရာများပင် ဖြစ်ပါ၏။ ထိုသူစွာ ဘုရားသခင်ရှိ့၊ လူအပေါင်းရို့ရှိ့၌ နှုတ်သတ္တိ၊ လက်သတ္တိနှင့် ပြည့်စုံသော ပရောဖက်တစ်ပါးဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ငါရို့၏ ယဇ်ပရောဟိတ်အကြီးတိနန့် အာဏာပိုင်တိက ထိုသူ့ကို သီဒဏ်စီရင်ဖို့ အပ်နှံ့ပြီးကေ လက်ဝါးကပ်တိုင်မှာ တင်သတ်လိုက်ကတ်ဗျာယ်။ ");
INSERT INTO rki_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ထိုအသျှင်က ဣသရေလလူမျိုးတိကို လွတ်မြောက်စီနိုင်သောအသျှင် ဖြစ်သည်ဟု ငါရို့ မျှော်လင့်ခပါ၏။ ထိုအကြောင်းအရာ ဖြစ်ပျက်ခစွာကား သုံးရက်ဟိပါဗျာယ်။ ");
INSERT INTO rki_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ငါရို့အပေါင်းအဖော်ထဲက မိန်းမတချို့သည် မိုးထက်စောစော သင်္ချိုင်းတော်သို့ လားကြသောအခါ ငါရို့ကို အံ့သြစီပါ၏။ ");
INSERT INTO rki_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","အကြောင်းမှာ ကိုယ်တော်၏ အလောင်းတော်ကို မတွိ့ခသောကြောင့်ဖြစ်၏။ ယေသျှုက အသက်ရှင်လျက် ဟိတော်မူကြောင်း ပြောပြသော ကောင်းကင်တမန်တိကို ရူပါရုံ၌ မြင်တွိ့ခသည်ကို သူရို့ ပြန်လာပြီး အကျွန်ရို့အား ပြောပြကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ငါရို့ထဲက လူတချို့ကလည်း သင်္ချိုင်းတော်သို့ လားကြသောအခါ ထိုမိန်းမတိပြောသည့်အတိုင်း ကိုယ်တော့်ကို မတွိ့ခပါ” ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ထိုအခါ ယေသျှုက သူရို့အား၊ “ပရောဖက်တိ ဟောကြားခသမျှကို ယုံကြည်ရန် အားနည်းနိန်သော အို... လူမိုက်တိ၊ ");
INSERT INTO rki_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","မေသျှိယသည် ဘုန်းတန်ခိုးတော်ကို မခံယူခင် ဤကဲ့သို့ ဒုက္ခဝေဒနာတိကို ခံစားရန် လိုအပ်သည် မဟုတ်လော” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ထို့နောက် ယေသျှုသည် မောသျှေ ကျမ်းမှစ၍ ပရောဖက်ကျမ်းအားလုံးတွင် မိမိအားရည်မှတ်၍ ရီးထားသမျှသော ကျမ်းချက် အနက်အဓိပ္ပာယ်တိကို ထိုသူရို့အား ယှင်းလင်းဖော်ပြတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","ထိုသူရို့လားသည့် ရွာအနီးသို့ရောက်ကြလျှင် ယေသျှုသည် ရှိ့သို့ ဆက်လားမည့်ဟန်ပြု၏။ ");
INSERT INTO rki_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","သို့သော် သူရို့က “တစ်နိ့တာကုန်၍ မှောင်စပြုနိန်လို့ အကျွန်ရို့နှင့်အတူ လာတည်းပါ” ဟု ကိုယ်တော့်ကို မရမက ဖိတ်ခေါ်၏။ ကိုယ်တော်ကလည်း သူရို့နှင့်အတူ တည်းခိုရန် လိုက်လားတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","စားပွဲတွင် သူရို့နှင့်အတူ ထိုင်တော်မူလျက် မုန့်ကိုယူ၍ ကျေးဇူးတော်ချီးမွမ်းပြီးမှ မုန့်ကိုဖဲ့ပြီးလျှင် သူရို့အား ပီးတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ထိုအခါ သူရို့၏မျက်စိအမြင်သည် ပွင့်လာပြီးလျှင် ကိုယ်တော်မှန်းသိကြသော်လည်း ကိုယ်တော်သည် သူရို့ရှိ့မှ ကွယ်ပျောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","သူရို့ကလည်း “ကိုယ်တော်သည် လမ်း၌ ငါရို့ကို စကားပြောသည့်အခါ၌ လည်းကောင်း၊ ကျမ်းစာ၏အနက်ကို ဖွင့်ပြတော်မူသောအခါ၌ လည်းကောင်း၊ ငါရို့၏ စိတ်နှလုံးထဲတွင် မီးထတောက်သကဲ့သို့ ဖြစ်နိန်ခသည် မဟုတ်ပါလော” ဟု အချင်းချင်း ပြောဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","သူရို့သည် ချက်ချင်းထ၍ ယေရုဆလင်မြို့သို့ ပြန်ကြ၏။ ထိုအရပ်၌ တစ်ကျိပ်တစ်ပါးသော တပည့်တော်ရို့နှင့် အခြားသောတပည့်တော်ရို့ အတူတကွ စုဝေးနိန်ကြသည်ကို တွိ့ရကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ထိုသူရို့ကလည်း “အမှန်ပင် သခင်ဘုရား ထမြောက်ဗျာယ်။ ကိုယ်တော်သည် သျှိမုန်အား ကိုယ်ထင်ပြဗျာယ်” ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","ထို့နောက် ထိုသူနှစ်ယောက်သည် လမ်းတွင် ဖြစ်ပျက်ခသည့် အကြောင်းအရာကိုလည်းကောင်း၊ မုန့်ကိုဖဲ့ချိန်ကျမှ ကိုယ်တော်ဖြစ်မှန်း သိလာခြင်းကိုလည်းကောင်း ယှင်းပြကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ထိုအကြောင်းအရာကို တပည့်တော်နှစ်ယောက်ရို့သည် ပြောပြနိန်စဉ် ယေသျှုသည် သူရို့အလယ်၌ ရုတ်တရက်ပေါ်လာပြီး ရပ်လျက် “သင်ရို့၌ ငြိမ်သက်ခြင်း ဟိစီသတည်း” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","သူရို့သည် စစ္ဆီခြောက်သည်ဟု ထင်မှတ်သဖြင့် ကြောက်ရွံ့တုန်လှုပ်နိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ကိုယ်တော်ကလည်း “ဇာကြောင့် ကြောက်လန့် နိန်ကြသနည်း၊ ဇာကြောင့် ယုံမှားသံသယ ဟိကြသနည်း။ ");
INSERT INTO rki_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ငါ့လက်တိ၊ ခြီတိကိုကြည့်ပါ။ သင်ရို့မြင်ရသည့်အတိုင်း ငါပင်ဖြစ်၏။ ငါ့ကို စမ်းသပ်ကြည့်ကြလော့။ သင်ရို့မြင်ရသည်အတိုင်း ငါ့၌အရိုးအသားနှင့် ပြည့်စုံ၏။ စစ္ဆီ၌ကား အရိုးအသားမဟိ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ကိုယ်တော်သည် မိန့်တော်မူပြီးလျှင် မိမိ၏လက်တော်၊ ခြီတော်တိကို တပည့်တော်ရို့အား ပြတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","သူရို့သည် အလွန် ဝမ်းမြောက်အံ့သြလျက် ဟိကြသော်လည်း မယုံနိုင်ကြသဖြင့်၊ ကိုယ်တော်က “သင်ရို့၌ စားစရာတစ်ခုခု ဟိသလော” ဟု မိန်းတော်မူလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","သူရို့က ငါးကင်တစ်ပိုင်းကို ပီးကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ကိုယ်တော်သည် ယူ၍ သူရို့ရှိ့တွင် သုံးဆောင်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","ထို့နောက် ကိုယ်တော်ကလည်း သူရို့အား “မောသျှေ ပညတ္တိကျမ်း၊ ပရောဖက်ကျမ်းနှင့် ဆာလံကျမ်းတွင် ငါ့အကြောင်းကို ရီးသားထားသော အမှုအရာအားလုံးသည် ဖြစ်ပျက်ရမည်ဟု သင်ရို့နှင့်အတူ ဟိသောအခါက ငါပြောခသည့်အတိုင်း အဂု ဖြစ်ပျက်လျက်ဟိ၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","ထို့နောက် တပည့်တော်ရို့သည် ကျမ်းစာကို နားလည်ကြစီရန် သူရို့၏ အသိဉာဏ်ကို ဖွင့်ပီးတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ကိုယ်တော်ကလည်း တပည့်တော်ရို့အား၊ “ကျမ်းစာတော်မြတ်၌ မေသျှိယသည် ဒုက္ခခံ၍ အသီခံတော်မူပြီးမှ သုံးရက်မြောက်သောနိ့၌ ထမြောက်တော်မူရမည်။ ");
INSERT INTO rki_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","နာမတော်ကိုအမှီပြု၍ နောင်တရခြင်းတရားနှင့် အပြစ်လွှတ်ခြင်းတရားတိကို ယေရုဆလင်မြို့မှစ၍ လူမျိုးတကာရို့ကို ဟောပြောရမည်။ ");
INSERT INTO rki_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","သင်ရို့သည် ဤအကြောင်းအရာများ၏ သက်သီများ ဖြစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ငါ့ခမည်းတော် ကတိထားတော်မူသည့်အတိုင်း သင်ရို့အထက်သို့ ငါ စီရွှတ်လိုက်မည်။ သို့သော်လည်း သင်ရို့အထက်သို့ ကောင်းကင်ကတန်ခိုး ရောက်လာသည်အထိ ယေရုဆလင်မြို့၌ စောင့်နိန်ကြလော” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","ထို့နောက် ကိုယ်တော်သည် တပည့်တော်တိကို ဗေသနိရွာသို့ ခေါ်ဆောင်လားတော်မူပြီးလျှင် လက်တော်ကိုဆန့်၍ ကောင်းကြီးပီးတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ဤသို့ ကောင်းကြီးပီးတော်မူစဉ် ကိုယ်တော်သည် တပည့်တော်ရို့ပါးမှ ခွာလျက် ကောင်းကင်သို့ ချီဆောင်ခြင်းကို ခံတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","တပည့်တော်ရို့သည် ကိုယ်တော့်ကို ပြပ်ဝပ်ကိုးကွယ်ကြပြီးလျှင် အလွန်ဝမ်းမြောက်ရွှင်လန်းစွာဖြင့် ယေရုဆလင်မြို့သို့ ပြန်လာ၍၊ ");
INSERT INTO rki_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ဘုရားသခင်၏ ဗိမာန်တော်၌ အမြဲမပြတ် ကျေးဇူးတော်ကို ချီးမွမ်းလျက်နိန်ကြ၏။");
INSERT INTO rki_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","အစအဦး၌ နှုတ်ကပတ်တော် ဟိ၏။ နှုတ်ကပတ်တော်သည် ဘုရားသခင်နှင့်အတူ ဟိတော်မူ၏။ ထိုနှုတ်ကပတ်တော်သည် ဘုရားသခင် ဖြစ်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","အစအဦးမှစ၍ နှုတ်ကပတ်တော်သည် ဘုရားသခင်နှင့်အတူ ဟိတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ဘုရားသခင်သည် ထိုနှုတ်ကပတ်တော်အားဖြင့် အရာခပ်သိမ်းကို ဖန်ဆင်းတော်မူ၏။ ထိုနှုတ်ကပတ်တော်နှင့် ကင်း၍ ဖန်ဆင်းထားသည့်အရာ တစ်ခုမျှမဟိ။ ");
INSERT INTO rki_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ထိုနှုတ်ကပတ်တော်သည် အသက်၏ အရင်းအမြစ်ဖြစ်၏။ ထို အသက်သည်ကား လူသားရို့အဖို့ အလင်းကို ယူဆောင်လာ၏။ ");
INSERT INTO rki_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ထိုအလင်းသည် မှောင်မိုက်၌ ထွန်းလင်း၍၊ မှောင်မိုက်သည် ဇာခါမျှ မကွယ်နိုင်။ ");
INSERT INTO rki_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","ဘုရားသခင်သည် ယောဟန်ဟု နာမည်ခေါ်သော မိမိ၏ စီတမန်ကို စီရွှတ်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ထိုသူသည် အလင်းတော်အကြောင်းကို လူအပေါင်းရို့သည် ကြား၍ ယုံကြည်ခြင်းငှာ ဟောပြောသက်သီခံရန် ကြွလာသောသူဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ထိုသူသည် အလင်းတော်မဟုတ်၊ အလင်းတော်၏အကြောင်းကို ဟောပြောသက်သီခံခြင်းငှာ လာ၏။ ");
INSERT INTO rki_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ထိုအလင်းတော်သည် လောကသို့ ကြွလာပြီးလျှင် လူသားအပေါင်းရို့တွင် ထွန်းလင်းပြီး — စစ်မှန်သောအလင်း ဖြစ်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ထိုနှုတ်ကပတ်တော်သည် လောက၌ ဟိတော်မူ၏။ ဘုရားသခင်သည် နှုတ်ကပတ်တော်အားဖြင့် လောကကို ဖန်ဆင်းတော်မူသော်လည်း လောကသည် ထိုသူကို မသိ။ ");
INSERT INTO rki_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","ထိုသူသည် မိမိလူမျိုးရို့ပါးသို့ ကြွတော်မူသော်လည်း မိမိလူရို့က လက်မခံကြ။ ");
INSERT INTO rki_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","သို့ရာတွင် ထိုသူအား ယုံကြည်လက်ခံသမျှသော သူသည် ဘုရားသခင်၏သားသမီးတိ ဖြစ်ခွင့်ကို ရကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ထိုသူရို့သည် လူ့အသွီးအသားအားဖြင့် မွီးသောသားသမီးတိ မဟုတ်၊ သို့သော် ဘုရားသခင် ဖြစ်ပွားစီတော်မူသော သားသမီးတိ ဖြစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","နှုတ်ကပတ်တော်သည် လူ့ဇာတိကို ခံယူ၍ ကျေးဇူးတော်နှင့်လည်းကောင်း၊ သစ္စာတော်နှင့်လည်းကောင်း ပြည့်စုံလျက် ငါရို့တွင် နီထိုင်တော်မူ၏။ ငါရို့သည် ထိုသူ၏ ဘုန်းတန်ခိုးတော်ကို ဖူးမြင်ရကြ၏။ ထိုဘုန်းတန်ခိုးတော်ကား ခမည်းတော်၌ တစ်ပါးတည်းသော သားတော်၏ ဘုန်းတန်ခိုးတော်ကဲ့သို့ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ယောဟန်သည် ထိုသူ၏ အကြောင်းကို ဟောပြောသက်သီခံသည်ကား၊ “ ‘ထိုသူသည် ငါ့နောက် ကြွလာမည်၊ သို့သော် ငါမမွီးမီကပင် ဟိနှင့်နိန်သည် ဖြစ်သောကြောင့် ငါ့ထက် ကြီးမြတ်သောသူ ဖြစ်သည်’ ဟု ဆိုရာတွင် ထိုသူကို ဆိုလိုခြင်းဖြစ်၏” ဟု ကြွေးကြော်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ထိုသူသည် ကျေးဇူးတော်နှင့် ပြည့်စုံသည်ဖြစ်၍ ငါရို့အား ကောင်းကြီးတစ်ခုပြီးတစ်ခု ပီးတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","ဘုရားသခင်သည် ပညတ်တရားကို မောသျှေအားဖြင့် ပီးတော်မူ၏။ သို့သော် ကျေးဇူးတော်နှင့် သစ္စာတော်မူကား ယေသျှုခရစ်တော်အားဖြင့် ရောက်လာ၏။ ");
INSERT INTO rki_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","ဇာသူမျှ ဘုရားသခင်ကို မမြင်ဖူးကြသော်လည်း ခမည်းတော်၏ ရင်ခွင်၌ ဟိတော်မူသည့် ဘုရားသခင် ဖြစ်တော်မူသော တစ်ပါးတည်းသော သားတော်သည် ဘုရားသခင်အား ထင်ရှားစီတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","ယေရုဆလင်မြို့၌ ဩဇာဟိသော ယုဒလူရို့သည် ယဇ်ပုရောဟိတ်ရို့နှင့် လေဝိရို့ကို ယောဟန်ပါးသို့ စီရွှတ်၍ “သင်ကား ဇာသူနည်း” ဟု သူရို့သည် မိန်းကြလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ယောဟန်က “မေသျှိယကား ငါ မဟုတ်” ဟု ထိမ်ဝှက်ခြင်းမဟိဘဲ ပွင့်လင်းစွာ ဟောပြော သက်သီခံတော်မူလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","ထိုသူရို့ကလည်း “ထိုသို့ဆိုလျှင် သင်ကား ဇာသူနည်း။ ဧလိယ ဖြစ်သလော” ဟု မိန်းလျှင်၊ ယောဟန်က၊ “ငါသည် ဧလိယ မဟုတ်” ဟု ဆို၏။ တဖန် သူရို့က “သင်သည် ပရောဖက်တစ်ပါး ဖြစ်သလော” ဟု မိန်းပြန်၏။ ယောဟန်ကလည်း “မဟုတ်” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","ထိုသူရို့ကလည်း “သင်ကား ဇာသူနည်း။ ငါရို့ကို စီရွှတ်လိုက်သော သူရို့အား ပြန်ပြောပြနိုင်ခြင်းငှာ သင့်ကိုယ်သင် ဇာသူဖြစ်သည်ဟု ပြောမည်နည်း” ဟု မိန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ယောဟန်က “ငါကား ‘ပရောဖက်ဟေသျှာယ ဟောပြောခသည်အတိုင်း သခင်ဘုရား၏ လမ်းခရီးတော်ကို ဖြောင့်စီကြလော့’ ဟူ၍ တောကန္တာရ၌ ဟစ်အော်နိန်သောသူ၏ အသံဖြစ်၏” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ထိုသူရို့သည် ဖာရိယှဲရို့ပါးမှ စီရွှတ်လိုက်သောသူတိ ဖြစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","တဖန် ထိုသူရို့က “သင်သည် မေသျှိယ မဟုတ်၊ ဧလိယလည်း မဟုတ်၊ ပရောဖက်တစ်ပါးလည်း မဟုတ်ဘဲနှင့် ဇာကြောင့် ဗတ္တိဇံမင်္ဂလာကို ပီးသနည်း” ဟု မိန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ယောဟန်ကလည်း “ငါသည် ရီ၌ ဗတ္တိဇံကို ပီး၏။ သို့သော် သင်ရို့အထဲတွင် သင်ရို့ မသိသောသူတစ်ယောက် ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ထိုသူသည် ငါ့နောက်မှ ကြွလာသော်လည်း ငါသည် သူ၏ခြီနင်းကြိုးကို ဖြီပီးဖို့ရန်ပင် မထိုက်တန်” ဟု ပြန်ပြော၏။ ");
INSERT INTO rki_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ဤအမှုအရာများသည် ယောဟန် ဗတ္တိဇံပီးနိန်သော ယော်ဒန်မြစ် အရှိ့ဖက်ကမ်း၊ ဗေသနိရွာ၌ ဖြစ်ပျက်သော အမှုအရာများဖြစ်သတည်း။ ");
INSERT INTO rki_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","နောက်တစ်နိ့၌ ယောဟန်သည် မိမိထံသို့ ယေသျှုကြွလာသည်ကို မြင်သော်၊ “လောကသားရို့၏ အပြစ်ကို ယူဆောင်လားတော်မူမည့် ဘုရားသခင်၏ သိုးသူငယ်တော်ကို ကြည့်ကြလော့။ ");
INSERT INTO rki_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","ငါ မမွီးခင်ကပင် ဟိနိန်သောသူဖြစ်၍ ငါ့ထက် ကြီးမြတ်သောသူသည် ငါ့နောက်မှ ကြွလာလိမ့်မည်ဟု ငါဆိုခသည်မှာ ထိုသူကို ဆိုလိုသတည်း။ ");
INSERT INTO rki_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","ထိုသူသည် ဇာသူဖြစ်သည်ကို ငါ မသိခ။ သို့ပင်သျှောင် ဣသရေလလူရို့သည် ထိုသူအား သိနိုင်ကြစီရန် ငါသည် ရီဖြင့် ဗတ္တိဇံကိုပီး၏” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","ထို့နောက် ယောဟန် သက်သီခံသည်ကား၊ “ဝိညာဉ်တော်သည် ဂြိုးငှက်ကဲ့သို့ ကောင်းကင်မှဆင်းသက်၍ ကိုယ်တော်အထက်၌ နားနိန်သည်ကို ငါမြင်ရ၏။ ");
INSERT INTO rki_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","ကိုယ်တော်သည် ဇာသူဖြစ်ကြောင်းကို ငါမသိ။ သို့ပင်သျှောင် ရီဖြင့်ဗတ္တိဇံကို ပီးဖို့အတွက် ငါ့ကို စီရွှတ်တော်မှုသော ဘုရားသခင်က ‘ဝိညာဉ်တော်သည် ဆင်းသက်၍ လူသားတစ်ယောက်အထက်၌ နားတော်မူသည်ကို သင်မြင်ရလိမ့်မည်။ ထိုသူသည် သန့်ယှင်းသောဝိညာဉ်တော်၌ ဗတ္တိဇံကို ပီးလိမ့်မည်’ ဟု အကျွန့်အား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","ထိုသို့ မိန့်တော်မှုသည်အတိုင်း ငါတွိ့မြင်ရသည်ဖြစ်၍ ဤသူသည် ဘုရားသခင်၏သားတော် ဖြစ်ကြောင်းကို ငါသည် သက်သီခံ၏” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","နောက်တစ်နိ့၌ ယောဟန်သည် မိမိ၏တပည့်တော် နှစ်ယောက်နှင့်အတူ ထိုအရပ်၌ တဖန် ရပ်လျက်နိန်စဉ်၊ ");
INSERT INTO rki_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ယေသျှု ကြွတော်မှုသည်ကို မြင်လျှင် “ဘုရားသခင်၏ သိုးသူငယ်တော်ကို ကြည့်ကြလော့” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","တပည့်တော်နှစ်ယောက်ရို့သည် ထိုစကားကို ကြားလျှင် ယေသျှုနောက်သို့ လိုက်လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ယေသျှုသည် နောက်တော်သို့ လှည့်၍ ထိုသူရို့သည် နောက်မှ လိုက်နိန်သည်ကို မြင်တော်မူလျှင် “သင်ရို့ ဇာအရာကို ရှာဖွီနိန်ကြသနည်း” ဟု မိန်းတော်မူ၏။ ထိုသူရို့ကလည်း “ရဗ္ဗိ၊ ကိုယ်တော်သည် ဇာမှာနီတော်မူသနည်း” ဟု မိန်းလျှောက်ကြ၏။ ရဗ္ဗိ၏ အနက်ကား “ဆရာ” ဟူ၍ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ကိုယ်တော်ကလည်း “လာ၍ ကြည့်ကြလော့” ဟု မိန့်တော်မှု၏။ ထိုအချိန်ကား ညနီလေးနာရီခန့် အချိန်ဖြစ်၏။ ထိုသူရို့သည် ကိုယ်တော်နှင့်အတူ လိုက်၍ နီထိုင်တော်မူရာ အရပ်ကို ကြည့်မြင်ပြီးလျှင် ထိုနိ့ကို ကိုယ်တော်နှင့်အတူ ကုန်လွန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ထိုသူနှစ်ယောက်ထဲမှ ယောဟန်၏ စကားကို ကြားသောသူကား သျှိမုန်ပေတရု၏ညီ အန္ဒြေဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ထိုသူသည် မိမိအစ်ကို သျှိမုန်အား တွိ့လျှင်တွိ့ချင်း “အကျွန်ရို့သည် မေသျှိယကို တွိ့ပါယာ” ဟု ဆို၏။ (မေသျှိယ၏အနက်ကား “ခရစ်တော်” ဖြစ်သတည်း။) ");
INSERT INTO rki_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","ထို့နောက် သူသည် သျှိမုန်အား ယေသျှုထံသို့ ခေါ်ဆောင်လားလေ၏။ ယေသျှုသည် ထိုသူကို ကြည့်လျက် “သင်သည် ယောဟန်၏သား သျှိမုန်ဖြစ်၏။ သို့ရာတွင် သင့်ကို ‘ကေဖ’ ဟူ၍ ခေါ်လိမ့်မည်” ဟု မိန့်တော်မူ၏။ (ကေဖ၏အနက်ကား ပေတရုနာမည်နှင့်တူသော “ကျောက်” ဟူ၍ ဖြစ်၏)။ ");
INSERT INTO rki_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","နောက်တစ်နိ့၌ ယေသျှုသည် ဂါလိလဲပြည်သို့ ကြွခြင်းငှာ အလိုဟိ၏။ ဖိလိပ္ပုကို တွိ့လျှင် “ငါ့နောက်သို့ လိုက်လော့” ဟု ထိုသူအား မိန့်တော်မူ၏။ ( ");
INSERT INTO rki_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ဖိလိပ္ပုသည် ဗက်ဇဲဒမြို့သား ဖြစ်၏။ ထိုမြို့သည် အန္ဒြေနှင့် ပေတရုရို့ နီထိုင်ရာမြို့ ဖြစ်သတည်း။) ");
INSERT INTO rki_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ဖိလိပ္ပုသည်လည်း နာသနေလအား တွိ့လျှင် “မောသျှေ၏ ပညတ်ကျမ်းနှင့် ပရောဖက်ကျမ်းများတွင် ရီးသားဖော်ပြထားသူကို အကျွန်ရို့ တွိ့ရယာ။ ထိုသူသည် နာဇရက်မြို့မှ ယောသပ်၏သား ယေသျှုဖြစ်၏” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","နာသနေလကလည်း “နာဇရက်မြို့က ကောင်းသောအရာ တစ်စုံတစ်ခု ထွက်နိုင်သလော” ဟု မိန်းလျှင်၊ ဖိလိပ္ပုက “လာ၍ ကြည့်ပါ” ဟု ဖြေလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ယေသျှုသည် မိမိထံသို့ နာသနေလ လာနိန်သည်ကို မြင်တော်မူလျှင် “ဤအရပ်၌ ဖောက်ပြန်ခြင်းနှင့် ကင်းသောသူဖြစ်ပြီး စစ်မှန်သော ဣသရေလအမျိုးသားကို ကြည့်ကြလော့” ဟု ထိုသူအား ရည်ရွယ်၍ မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","နာသနေလကလည်း “ကိုယ်တော်သည် အကျွန့်ကို မည်သို့ သိသနည်း” ဟု မိန်းလျှောက်လေ၏။ ယေသျှုကလည်း “ဖိလိပ္ပုသည် သင့်ကို မခေါ်မီ သဖန်းပင်အောက်၌ ဟိနိန်စဉ်ကပင် သင့်ကို ငါမြင်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","နာသနေလကလည်း “ဆရာ၊ ကိုယ်တော်သည် ဘုရားသခင်၏သားတော် ဖြစ်ပါ၏။ ဣသရေလလူမျိုးရို့၏ ဘုရင်ဖြစ်ပါ၏” ဟု လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ယေသျှုက “သဖန်းပင်အောက်တွင် သင်ဟိနိန်ချိန်ကပင် သင့်ကို ငါမြင်ယာဟု ဆိုသောကြောင့် သင်ယုံကြည်သလော။ ယင်းချင့်ထက်ကြီးသော အမှုအရာတိကို သင်မြင်ရလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","ထို့နောက် ကိုယ်တော်က “ငါအမှန်ဆိုသည်ကား၊ သင်ရို့သည် ကောင်းကင်ဖွင့်လှစ်၍ ဘုရားသခင်၏ ကောင်းကင်တမန်ရို့သည် လူသားအထက်မှာ ဆင်းလျက်၊ တက်လျက်ဟိနိန်သည်ကို မြင်ရကြလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","နောက်နှစ်ရက်ကြာသောအခါ ဂါလိလဲပြည်၊ ကာနမြို့၌ ထိမ်းမြားမင်္ဂလာပွဲ ကျင်းပရာ ယေသျှု၏မယ်တော်သည် ထိုနီရာ၌ ဟိတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ယေသျှုနှင့် တပည့်တော်ရို့ကိုလည်း ဖိတ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","စပျစ်ရည်ကုန်လားသောအခါ ယေသျှု၏မယ်တော်က “သူရို့မှာ စပျစ်ရည် ကုန်လားယာ” ဟု ကိုယ်တော့်ကို ပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","ယေသျှုကလည်း “မယ်တော်၊ ဇာအမှုကို ပြုရမည်ကို ငါ့အား မပြောပါကေ့။ ငါ့အချိန်မရောက်သိမ့်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ထိုအခါ မယ်တော်ကလည်း “သူစီခိုင်းသမျှကို လုပ်ဆောင်ကြလော့” ဟု အခိုင်းအစီတိအား မှာထားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ထိုနီရာ၌ ယုဒအမျိုးသားရို့၏ ဘာသာဓလေ့အရ စင်ကြယ်ခြင်းအဖို့အလို့ငှာ ရီနှစ်ထမ်း သုံးထမ်းခန့် ဝင်သောကျောက်ရီအိုး ခြောက်အိုးဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ယေသျှုက “ဤရီအိုးများတွင် ရီအပြည့်ဖြည့်လော့” ဟု အခိုင်းအစီရို့အား မိန့်တော်မူလျှင်၊ သူရို့သည် ရီအိုး နှုတ်ခမ်းအထိ ရီအပြည့်ဖြည့်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ထို့နောက် ကိုယ်တော်သည် ထိုသူရို့အား “အဂု၊ ရီအချို့ကို ခပ်ပြီးလျှင် ပွဲအုပ်ပါးသို့ ယူလားကြလော့” ဟု မိန့်တော်မူသည့်အတိုင်း သူရို့သည်လည်း ပြုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ပွဲအုပ်သည် ရီမှ စပျစ်ရည်အဖြစ်သို့ ပြောင်းလဲလားသော ရီကို မြည်းကြည့်လေ၏။ ရီခပ်ယူလာသော အခိုင်းအစီရို့သည် ထိုစပျစ်ရည်ကို ဇာပိုင်ရကြသည်ကို သိသော်လည်း ပွဲအုပ်မူကား မသိပေ။ ထို့ကြောင့် သတို့သားအား ခေါ်ပြီးလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“လူတိုင်းက အကောင်းဆုံးသော စပျစ်ရည်နှင့် ဦးစွာ ဧည့်ခံကြ၏။ လူတိ ဝစွာသောက်ကြပြီးမှ ညံ့သောစပျစ်ရည်ကို ဧည့်ခံလေ့ဟိကြ၏။ သို့သော်လည်း သင်မူကား အကောင်းဆုံးသော စပျစ်ရည်ကို အဂုထက်ထိ ထုတ်ပီးပါသည်တကား” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ယေသျှုသည် ဂါလိလဲပြည်၊ ကာနမြို့၌ ထိုသို့ ပထမဆုံးသော နိမိတ်လက္ခဏာကို ပြတော်မူလျက် မိမိ၏ဘုန်းတန်ခိုးတော်ကို ထွန်းတောက်စီ၏။ တပည့်တော်ရို့သည်လည်း ကိုယ်တော့်ကို ယုံကြည်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ဤအမှုအရာပြီးလျှင် ယေသျှုသည် မယ်တော်မှစ၍ ညီတော်၊ တပည့်တော်ရို့နှင့် ကပေရနောင်မြို့သို့ လားကြပြီး ရက်အနည်းချေ တည်းခိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","ယုဒအမျိုးသားရို့၏ ပသခါပွဲတော်နီးကပ်လာသောအခါ ယေသျှုသည် ယေရုဆလင်မြို့သို့ ကြွတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ကိုယ်တော်သည် ဗိမာန်တော်အထဲတွင် နွားများ၊ သိုးများ၊ ဂြိုးငှက်များကို ရောင်းသောသူများထိုင်နိန်သည်ကိုလည်းကောင်း ငွီလဲလှယ်နိန်သော သူရို့သည် သူရို့၏စားပွဲများ၌ ထိုင်နိန်သည်ကိုလည်းကောင်း တွိ့တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ထို့ကြောင့် ကိုယ်တော်သည် ကြိုးဖြင့် ကြာပွတ်ကိုလုပ်ပြီး သိုး၊ နွားမှစ၍ အားလုံးသောတိရစ္ဆာန်တိကို ဗိမာန်တော်ထဲမှ မောင်းထုတ်တော်မူ၏။ ငွီလဲလှယ်နိန်သောသူရို့၏ စားပွဲကိုလည်း မှောက်လှန်တော်မူ၍ သူရို့၏ ဒင်္ဂါးများသည် ပြန့်ကြဲလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ကိုယ်တော်သည် ဂြိုးငှက်ရောင်းသော သူတိကိုလည်း “ဤချင့်တိကို ဤနီရာမှ ယူလားကြလော့။ ငါ့အဖ၏အိမ်တော်ကို စျီးနီရာ မဖြစ်စီကတ်ကေ့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","ထိုအခါ တပည့်တော်ရို့သည် “အို၊ ဘုရားသခင်၊ ကိုယ်တော်၏အိမ်တော်အဖို့ ပြင်းပြသော ငါ၏စိတ်သည် ငါ့ကိုယ်၌ မီးတောက်သဖွယ် လောင်ကျွမ်းလျက် ဟိပါ၏” ဟူသော ကျမ်းစာလာသည်ကို သတိရကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ယုဒအာဏာပိုင်ရို့ကလည်း “သင်သည် ဤအမှုအရာတိအား လုပ်ပိုင်ခွင့်ဟိကြောင်းကို သိနိုင်စီခြင်းငှာ ငါရို့အား ဇာနိမိတ်လက္ခဏာကို ပြမည်နည်း” ဟု ပြန်လျှောက်ကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ယေသျှုကလည်း “ဤဗိမာန်တော်ကို ဖြိုချလော့။ သုံးရက်အတွင်း၌ ပြန်၍ ငါတည်ဆောက်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","သူရို့ကလည်း “ဤဗိမာန်တော်ကို လေးဆယ်ခြောက်နှစ်တိုင်တိုင် တည်ဆောက်ခရ၏။ သင်မူကား သုံးရက်အတွင်း ပြန်တည်ဆောက်မည်လော” ဟု လျှောက်ကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","သို့သော် ယေသျှု ထိုသို့ မိန့်တော်သည်မှာ မိမိ၏ကိုယ်ခန္ဓာတည်းဟူသော ဗိမာန်တော်အကြောင်းကို ပြောဆိုခြင်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ထို့ကြောင့် တပည့်တော်ရို့သည် သီခြင်းမှ ကိုယ်တော် ရှင်ပြန်ထမြောက်တော်မူသောအခါ ဤသို့ ကိုယ်တော် မိန့်တော်မူခသောစကားကို သတိရကြ၍ ကျမ်းစာတော်မြတ်ကိုလည်းကောင်း၊ ယေသျှု မိန့်တော်မူခသော စကားတော်ကိုလည်းကောင်း ယုံကြည်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","ယေသျှုသည် ယေရုဆလင်မြို့၌ ကျင်းပသည့် ပသခါပွဲတော်အတွင်း ဟိနိန်စဉ် ကိုယ်တော်ပြုတော်မူသော နိမိတ်လက္ခဏာကို တွိ့မြင်သောသူရို့သည် ကိုယ်တော့်ကို ယုံကြည်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","သို့သော် ယေသျှုသည် ထိုသူရို့၏အကြောင်းကို သိတော်မူသောကြောင့် ထိုသူရို့အား မယုံပေ။ ");
INSERT INTO rki_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ကိုယ်တော်သည် သူရို့၏ စိတ်နှလုံးထဲ၌ ဟိသောအရာများကို သိသောကြောင့် မည်သူမျှ သူရို့၏ အကြောင်းကို ကိုယ်တော့်ကို ပြောပြရန် မလိုပေ။ ");
INSERT INTO rki_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","နိကောဒင်ဟု နာမည်ဟိသော ယုဒအမျိုးသား ခေါင်းဆောင်တစ်ယောက်ဟိ၏။ ထိုသူသည် ဖာရိယှဲရို့၏ အဖွဲ့ဝင်တစ်ဦးဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","သူသည် ညဉ့်အခါ ကိုယ်တော့်ထံသို့ လာ၍ “ဆရာ၊ ကိုယ်တော်သည် ဘုရားသခင် စီရွှတ်တော်မူသော ဆရာတစ်ပါး ဖြစ်ကြောင်းကို အကျွန်ရို့ သိကြပါ၏။ ကိုယ်တော်ပြတော်မူသော နိမိတ်လက္ခဏာတိကို ဘုရားသခင်အတူ မပါဟိလျှင် မည်သူမျှ ပြနိုင်မည် မဟုတ်ပါ” ဟု လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","ယေသျှုကလည်း “ငါအမှန်ဆိုသည်ကား၊ တဖန် မွီးဖွားခြင်းကို မခံသောသူသည် ဘုရားသခင်၏ နိုင်ငံတော်ကို မမြင်ရ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","နိကောဒင်ကလည်း “အသက်ကြီးသော သူသည် တဖန် မွီးဖွားခြင်းကို ဇာပိုင် ခံရမည်နည်း။ မိခင်ဝမ်းထဲသို့ တဖန် ဝင်ပြီးလျှင် ဒုတိယအကြိမ် မွီးဖွား၍ မရနိုင်သည်မှာ သေချာပါ၏” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","ယေသျှုကလည်း “သင်ရို့အား ငါအမှန် ဆိုသည်ကား၊ ရီ၌ လည်းကောင်း၊ ဝိညာဉ်တော်၌ လည်းကောင်း မွီးဖွားခြင်းကို မခံသောသူသည် ဘုရားသခင်၏နိုင်ငံတော်သို့ မဝင်ရ။ ");
INSERT INTO rki_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","အသွီးအသားအားဖြင့် မွီးဖွားသောသူသည် အသွီးအသားနှင့် ဆိုင်၏။ ဝိညာဉ်တော်အားဖြင့် မွီးဖွားသောသူသည် ဝိညာဉ်နှင့်သာ ဆိုင်၏။ ");
INSERT INTO rki_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","လူတိုင်း တဖန် မွီးဖွားခြင်းကို ခံရမည်ဟု ငါ ပြောသည်ကို မအံ့ဩကေ့။ ");
INSERT INTO rki_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","လီသည် မိမိ တိုက်လိုရာသို့ တိုက်တတ်၏။ လီ၏အသံကို ကြားရသော်လည်း ဇာအရပ်မှ တိုက်လာသည်ကိုလည်းကောင်း၊ ဇာအရပ်သို့ တိုက်လိမ့်မည်ကိုလည်းကောင်း မသိနိုင်။ ဝိညာဉ်တော်အားဖြင့် မွီးဖွားသောသူသည်လည်း ဤကဲ့သို့ ဖြစ်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","နိကောဒင်ကလည်း “ဤအမှုအရာကား ဇာပိုင် ဖြစ်နိုင်မည်နည်း” ဟု မိန်းလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","ယေသျှုကလည်း “သင်သည် ဣသရေလအမျိုးသားရို့တွင် ဆရာတစ်ပါး ဖြစ်ပါလျက်၊ ဤအကြောင်းအရာကို နားမလည်သလော။ ");
INSERT INTO rki_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","ငါအမှန် ဆိုသည်ကား၊ ငါရို့သည် ကိုယ်တိုင် သိသောအရာများကိုသာ ပြောကြ၏။ ကိုယ်မြင်သော အရာကိုသာ သက်သီခံကြ၏။ သို့သော်လည်း ငါရို့၏ သက်သီခံချက်တိကို သင်ရို့ လက်မခံသိမ့်သလော။ ");
INSERT INTO rki_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","လောကနှင့် ဆိုင်သောအရာတိကို ငါ ပြောပြသော်လည်း သင်ရို့မယုံ၊ အထက်ကောင်းကင်နှင့် ဆိုင်သောအရာကို ငါ ပြောသော် သင်ရို့ ဇာပိုင် ယုံကြည်နိုင်မည်နည်း။ ");
INSERT INTO rki_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ကောင်းကင်ဘုံမှ ကြွဆင်းလာသော လူသားမှတစ်ပါး တစ်စုံတစ်ယောက်မျှ ကောင်းကင်ဘုံသို့ မရောက်ဖူးကြ” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","မောသျှေသည် တောကန္တာရ၌ ကြီးဝါမြွီရုပ်ကို တိုင်ထက်မှာ ဆွဲထားသကဲ့သို့ လူသားသည်လည်း ဆွဲထားခြင်းကို ခံရလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","အကြောင်းမူကား၊ ထိုသူအား ယုံကြည်သောသူ အပေါင်းရို့သည် ထာဝရအသက်ကို ရစီရန် ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ဘုရားသခင်သည် လောကသားရို့ကို လွန်စွာချစ်တော်မူသဖြင့် မိမိ၌ တစ်ပါးတည်းသောသားတော်ကို ပီးတော်မူ၏။ အကြောင်းမူကား ထိုသားတော်ကို ယုံကြည်သော သူရို့သည် ပျက်စီးခြင်းသို့ မရောက်ဘဲ ထာဝရအသက်ကို ရစီခြင်းငှာဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ဘုရားသခင်သည် မိမိ၏သားတော်အား လောကသို့ စီရွှတ်တော်မူသည်မှာ အပြစ်စီရင်ခြင်းငှာ မဟုတ်။ လောကသားရို့အား ကယ်တင်ခြင်းငှာ ဖြစ်သတည်း။ ");
INSERT INTO rki_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ထိုသားတော်ကို ယုံကြည်သောသူ အပေါင်းရို့သည် အပြစ်စီရင်ခြင်းကို မခံရ။ သို့သော်လည်း မယုံကြည်သော သူရို့မူကား ဘုရားသခင်၌ တစ်ပါးတည်းသော သားတော်ကို မယုံကြည်သောကြောင့် အဂုပင် အပြစ်စီရင်ခြင်းကို ခံရလျက်ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","တရားစီရင်ခြင်းကား ဤသို့ဖြစ်၏။ အလင်းသည် ဤလောကထဲသို့ ကြွလာ၏။ သို့သော် လူတိကား အလင်းထက် အမှောင်ကို သာ၍ နှစ်သက်ကြ၏။ အကြောင်းမူကား သူရို့၏ အကျင့်သီလသည် ဆိုးယုတ်သောကြောင့်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","မကောင်းမှုကို ပြုသောသူအပေါင်းရို့သည် အလင်းကို မုန်းကြ၏။ ထိုသူရို့သည် အလင်းသို့ လာကြလိမ့်မည် မဟုတ်။ အကြောင်းမူကား သူရို့၏ မကောင်းသောအကျင့် ပေါ်လားမည်ကို အလိုမဟိကြ။ ");
INSERT INTO rki_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","သို့ပင်သျှောင်လည်း သမ္မာတရားကို ကျင့်သောသူရို့မူကား မိမိရို့ကျင့်သော တရားသည် ဘုရားသခင်၏အလိုတော်နှင့် ညီသည်ကို ထင်ရှားစီခြင်းငှာ အလင်းသို့ လာကြ၏ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ထိုသို့ မိန့်တော်မူပြီးနောက် ယေသျှုနှင့် တပည့်တော် ရို့သည် ယုဒအရပ်ဒေသသို့ ကြွတော်မူ၏။ ကိုယ်တော်သည် သူရို့နှင့်အတူ ထိုအရပ်၌ နီတော်မူပြီးလျှင် ဗတ္တိဇံမင်္ဂလာကို ပီးလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ယောဟန်သည်လည်း ယှာလိန်မြို့နှင့်မဝီးသော အဲနုန်အရပ်တွင် ဗတ္တိဇံပီးလျက် နိန်၏။ အကြောင်းမူကား ထိုအရပ်၌ ရီပေါသီစွာ ဟိသောကြောင့်ဖြစ်၏။ လူအပေါင်းရို့သည် ယောဟန်ပါးသို့ လာကြပြီးလျှင် ဗတ္တိဇံမင်္ဂလာကို ခံယူကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(ထိုအချိန်၌ ယောဟန်သည် အကျဉ်းမကျသိမ့်ပေ။) ");
INSERT INTO rki_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","ယောဟန်၏ တပည့်တချို့နှင့် ယုဒလူမျိုးတစ်ယောက်သည် ဘာသာတရားနှင့်ဆိုင်သော သန့်ယှင်းခြင်းအကြောင်းကို ဆွေးနွေးငြင်းခုံနိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ထို့ကြောင့် သူရို့သည် ယောဟန်ပါးသို့ လာ၍ “ဆရာ၊ ယော်ဒန်မြစ် အရှိ့ဖက်ကမ်းမှာ ဆရာနှင့်အတူ နီခဖူးသော သူတစ်ယောက်ကို မှတ်မိပါသလော။ ထိုသူ၏အကြောင်းကို ဆရာပြောပြခဖူး၏။ ထိုသူသည် အဂု လူတိကို ဗတ္တိဇံပီးနိန်ယာ။ လူတိလည်း ထိုသူ့ထံသို့ လားနိန်ကြယာ” ဟု လျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ယောဟန်ကလည်း “ဘုရားသခင် ပီးတော်မမူလျှင် လူသည် ဇာတစ်ခုကိုမျှ မခံမယူနိုင်။ ");
INSERT INTO rki_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","ငါကား မေသျှိယ မဟုတ်။ သို့သော် ထိုအသျှင်၏ ရှိ့ဗြီးသာ ဖြစ်၏။ ထိုသို့ဖြစ်ကြောင်းကို ငါပြောသမျှဖြင့် သင်ရို့ကိုယ်တိုင် ငါ၏ သက်သီခံဖြစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","မင်္ဂလာဆောင်သတို့သမီးကို ပိုင်ဆိုင်သည့်လူကား မင်္ဂလာဆောင်သတို့သားဖြစ်၏။ သတို့သား၏ မိတ်ဆွီကား ရပ်လျက် နားထောင်ပြီး နိန်၏။ သတို့သား၏အသံကို ကြားသောအခါ အလွန်ဝမ်းမြောက်သကဲ့သို့ ငါသည်လည်း ဝမ်းမြောက်ခြင်းနှင့် ပြည့်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ထိုအသျှင်သည် တိုးပွားခြင်း ဟိရမည်။ ငါမူကား ဆုတ်ယုတ်ခြင်း ဟိရမည်” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","အထက်မှ ကြွလာသောသူကား အလုံးစုံတိထက် ကြီးမြတ်သောသူဖြစ်၏။ မြီကြီးမှ လာသောသူသည် မြီကြီးနှင့်သာဆိုင်၏။ ထိုသူသည်လည်း မြီကြီးအကြောင်းကိုသာ ပြောတတ်၏။ သို့သော်လည်း ကောင်းကင်မှ လာသောသူကား အရာအားလုံးထက် ကြီးမြတ်သောသူဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ထိုသူသည် မိမိမြင်ခသမျှ၊ ကြားခသမျှကို ဟောပြော၏၊ သို့ရာတွင် ဇာသူမျှ ထိုသူ၏ သက်သီခံချက်တိကို လက်မခံကြ။ ");
INSERT INTO rki_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","သို့သော် ထိုအသျှင်၏ သက်သီခံချက်များကို လက်ခံယုံကြည်သမျှသော သူရို့သည် ဘုရားသခင်သည် သစ္စာသျှင် ဖြစ်ကြောင်းကို သက်သီခံသောသူတိ ဖြစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ဘုရားသခင် စီရွှတ်တော်မူသောသူသည် ဘုရားသခင်၏ နှုတ်ကပတ်တော်များကို ပြောဆိုတတ်၏။ အကြောင်းမူကား ဘုရားသခင်သည် ထိုသူအား ဝိညာဉ်တော်ကို ပြည့်ဝစွာ ပီးတော်မူသောကြောင့်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","ခမည်းတော်သည် မိမိသားတော်ကို ချစ်တော်မူသောကြောင့် ခပ်သိမ်းသော တန်ခိုးအာဏာကို သားတော်၌ ပီးအပ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ထိုသားတော်ကို ယုံကြည်လက်ခံသောသူသည် ထာဝရအသက်ကို ရ၏။ သားတော်ကို မယုံကြည်သောသူမူကား အသက်ကိုမရဘဲ ဘုရားသခင်၏ အမျက်တော်အောက်၌ နိန်သောသူ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ယေသျှုသည် ယောဟန်ထက် ပို၍များသောသူရို့ကို တပည့်တော်ဖြစ်စီပြီး ဗတ္တိဇံပီးကြောင်းကို ဖာရိယှဲရို့သည် ကြားသိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","သို့ရာတွင် ယေသျှုသည် မိမိကိုယ်တိုင် ဗတ္တိဇံကို ပီးသည် မဟုတ်။ တပည့်တော်တိကသာ လုပ်ဆောင်ကြခြင်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ယေသျှုသည် ကြားတော်မူလျှင် ယုဒပြည်မှထွက်၍ ဂါလိလဲပြည်သို့ ကြွတော်မူ၏၊ ");
INSERT INTO rki_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","လမ်းခရီး၌ ယှာမာရိပြည်ကို ဖြတ်၍လားရ၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ထို့ကြောင့် ယှာမာရိပြည်၌ ယှုခါ အမည်ဟိသောမြို့သို့ ရောက်တော်မူ၏။ ထိုမြို့ကား ယာကုပ်သည် မိမိ၏သား ယောသပ်အား ပီးသော မြီကွက်အနားတွင် တည်ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ယာကုပ်၏ ရီတွင်းလည်း ထိုအရပ်၌ဟိ၏။ ယေသျှုသည် ခရီးပန်းသောကြောင့် ရီတွင်းအနား၌ ထိုင်တော်မူ၏။ ထိုအချိန်ကား နီမွန်းတည့် အချိန်၌ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ယှာမာရိ မိန်းမတစ်ယောက်သည် ရီခပ်ခြင်းငှာ လာ၏။ ယေသျှုကလည်း ထိုမိန်းမအား “ငါ သောက်ဖို့ ရီတစ်ခွက် ပီးလော့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","ကိုယ်တော်၏ တပည့်တော်တိကား စားစရာဝယ်ခြင်းငှာ မြို့ထဲသို့ လားနိန်ခိုက်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","မိန်းမကလည်း “သင်ကား ယုဒလူမျိုးတစ်ယောက် ဖြစ်၏။ အကျွန်ကား ယှာမာရိ လူမျိုးတစ်ယောက်ဖြစ်၏။ သို့ပင်သျှောင် ဇာအတွက်နှင့် အကျွန့်ပါးမှာ သောက်ဖို့ရီကို တောင်းရသနည်း” ဟုဆို၏။ အကြောင်းမူကား ယုဒလူမျိုးသည် ယှာမာရိလူမျိုး သုံးသော ရီခွက်၊ ဇလုံများကို အတူတကွ အသုံးမပြုကြပေ။ ");
INSERT INTO rki_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ယေသျှုကလည်း “ဘုရားသခင်ပီးသော အရာတိကိုလည်းကောင်း၊ သင့်ပါးမှ ရီသောက်ဖို့ တောင်းသောသူကိုလည်းကောင်း သိလျှင် သင်သည် ထိုသူပါးက တောင်းလိမ့်မည်၊ ထိုသူလည်း သင့်ကို အသက်ရီကို ပီးလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","မိန်းမက “ဆရာ၊ သင့်မှာ ရီဆွဲပုံးလည်း မဟိ။ ရီတွင်းကလည်း နက်၏။ သင်သည် အသက်ရီကို ဇာကနိန် ရနိုင်ပါမည်နည်း။ ");
INSERT INTO rki_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","ဤရီတွင်းကား အကျွန်ရို့ အဖိုးအဖီးဖြစ်သော ယာကုပ်က အကျွန်ရို့ကို ပီးထားခသည့် ရီတွင်းဖြစ်၏။ သူနှင့် သူ၏သားသမီးများနှင့် သိုးတိရစ္ဆာန်အားလုံးသည် ဤက ရီကိုသောက်ကြ၏။ သင်သည် အကျွန်ရို့အဖိုးအဖီးဖြစ်သူ ယာကုပ်ထက် ကြီးမြတ်ပါသလော” ဟု မိန်းလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ယေသျှုကလည်း “ဤရီကို သောက်သောသူတိုင်း တဖန် ရီဆာဖို့သိမ့်။ ");
INSERT INTO rki_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","သို့သော်လည်း ငါ ပီးသောရီကို သောက်သောသူကား နောက်တဖန် ရီမမွတ်ယာ။ ထိုရီသည် ထိုသူရို့၏ အထဲ၌ အသက်စမ်းရီဖြစ်စီပြီး ထာဝရအသက်ကိုလည်း ပီးလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","ထိုမိန်းမကလည်း “အသျှင်၊ ထိုရီကို အကျွန်အား ပီးပါ။ ထိုမှသာ အကျွန်သည် ရီမွတ်ခြင်းနှင့် ကင်းလွတ်လိမ့်မည်။ ထိုသို့ မဟုတ်လျှင် အကျွန်သည် ဤနီရာသို့ လာ၍ ရီခပ်နိန်ရမည်” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ယေသျှုသည် သူမအား “လား၍ သင်၏လင်ကို ခေါ်လာလော့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","ထိုမိန်းမကလည်း “အကျွန့်မှာ လင်မဟိပါ” ဟု လျှောက်လေ၏။ ယေသျှုကလည်း “သင်၌ လင်မဟိဟု ပြောသည်မှာ မှန်ပေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","သင်သည် ယောက်ျားငါးယောက်နှင့် အိမ်ထောင်ပြုခဖူးယာ။ အဂု သင်နှင့်နီသော သူလည်း သင်၏ လင် မဟုတ်။ သင်သည် မှန်သောစကားကို ငါ့အား ပြောယာ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","ထိုမိန်းမက “အသျှင်၊ သင်သည် ပရောဖက်တစ်ပါးဖြစ်သည်ကို အကျွန် သိမြင်ပါ၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","အကျွန်ရို့ အဖိုးအဖီးတိက ဘုရားသခင်ကို တောင်ထက်မှာသာ ကိုးကွယ်ကြ၏။ သို့ရာတွင် အသျှင်ရို့ ယုဒလူမျိုးတိက ‘ယေရုဆလင်မြို့၌သာ ဘုရားသခင်ကို ဝတ်ပြုကိုးကွယ်ရမည်’ ဟူ၍ ဆိုကြပါ၏” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","ယေသျှုက “အသင် မိန်းမ၊ ငါ့ကို ယုံကြည်လော့။ ဤတောင်သို့မလာ၊ ယေရုဆလင်မြို့၌ မဟုတ်ဘဲ၊ ခမည်းတော်ကို ကိုးကွယ်ရမည့်အချိန် ရောက်လာလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ယှာမာရိလူမျိုးဖြစ်သော သင်ရို့သည် မိမိရို့ မသိသောဘုရားကို ကိုးကွယ်ကြ၏။ သို့သော်လည်း ငါရို့ယုဒလူမျိုးတိက မိမိရို့ ကိုးကွယ်သောဘုရားကို သိကျွမ်းကြ၏။ အကြောင်းမူကား ကယ်တင်ခြင်းသည် ယုဒလူမျိုးပါးမှ ဆင်းသက်လာသောကြောင့် ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","သို့ပင်သျှောင် ခမည်းတော်ဘုရားအား ကိုးကွယ်သောသူ မှန်သမျှရို့သည် ဝိညာဉ်ဖြင့် လည်းကောင်း၊ သစ္စာနှင့်လည်းကောင်း ကိုးကွယ်ရမည့်အချိန်သည် လာ၍ အဂုပင် ရောက်လျက်ဟိ၏။ အကြောင်းမူကား ထိုသို့ ကိုးကွယ်သောသူရို့ကို ခမည်းတော်သည် အလိုဟိတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ဘုရားသခင်သည် နာမ်ဝိညာဉ်ဖြစ်တော်မူသည်အတိုင်း ကိုးကွယ်သောသူ မှန်သမျှရို့သည်လည်း ဝိညာဉ်နှင့်လည်းကောင်း၊ သစ္စာနှင့်လည်းကောင်း ကိုးကွယ်ရမည်” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","ထိုမိန်းမကလည်း “မေသျှိယ ကြွလာမည်ကို အကျွန် သိပါ၏။ ထိုအသျှင်ကြွလာသောအခါ အရာခမ်းသိမ်းကို အကျွန်ရို့အား ဖွင့်ပြလိမ့်မည်” ဟု လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ယေသျှုလည်း “ထိုအသျှင်ကား သင်နှင့်စကားပြောနိန်သော ငါပင်ဖြစ်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ထိုအချိန်၌ တပည့်တော်ရို့သည် ပြန်ရောက်လာကြရာ ကိုယ်တော်နှင့် ထိုမိန်းမသည် စကားပြောနိန်သည်ကို တွိ့လျှင် လွန်စွာအံ့ဩကြ၏။ သို့သော်လည်း ထိုမိန်းမအား “ဇာအလိုဟိသည်ကိုလည်းကောင်း၊” ကိုယ်တော့်ကို “ထိုမိန်းမနှင့် ဇာကြောင့် စကားပြောတော်မူသည် လည်းကောင်း” ဇာသူမျှ မမိန်းဝံ့ကြပေ။ ");
INSERT INTO rki_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ထို့နောက် ထိုမိန်းမသည် သူမ၏ရီအိုးကို ထားခပြီးလျှင် မြို့ထဲသို့ ပြန်၍ လူအပေါင်းရို့အား၊ ");
INSERT INTO rki_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“အကျွန် ပြုလုပ်ခသောအရာများကို ပြန်ပြောပြနိန်သောသူအား လာ၍ ကြည့်ကြလော့။ ထိုသူသည် မေသျှိယ ဖြစ်နိုင်မည်လော” ဟု ပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ထို့ကြောင့် လူရို့သည် မြို့မှ ထွက်လာကြကာ ယေသျှုထံပါးသို့ လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ထိုအချိန်အတောအတွင်း၌ တပည့်တော်ရို့က “ဆရာ၊ စားစရာတစ်ခုခုကို သုံးဆောင်ပါလော့” ဟု ယေသျှုအား တောင်းပန်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","သို့ရာတွင် ကိုယ်တော်က “သင်ရို့ မသိသောအစာကို ငါသုံးဆောင်ပြီးယာ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","ထို့ကြောင့် တပည့်တော်ရို့သည် “တစ်စုံတစ်ယောက်က ကိုယ်တော့်အား အစားအစာကို ပီးလှူထားပြီလော” ဟု အချင်းချင်း မိန်းမြန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","ယေသျှုလည်း “ငါ၏ စားစရာကား၊ ငါ့ကို စီရွှတ်သော အသျှင်၏အလိုတော်ကို နာခံခြင်းနှင့် ထိုအသျှင်က ငါ့ကို ပီးအပ်ထားသော လုပ်ငန်းတာဝန်ကို ပြီးစီးအောင် လုပ်ဆောင်ခြင်းပင် ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","‘တဖန်၊ လေးလလွန်လျှင် ကောက်ရိတ်သိမ်းချိန် ရောက်ယာ’ ဟု သင်ရို့က ပြောတတ်ကြ၏။ သို့သော်လည်း သင်ရို့ကို ငါပြောမည်၊ သင်ရို့မျက်စိဖွင့်ပြီး လယ်ပြင်တိကို ကြည့်လိုက်လော့။ ကောက်နှံတိ ဝင်းမှည့်ပြီး ရိတ်သိမ်းခြင်းငှာ အချိန်တန်နိန်ယာ။ ");
INSERT INTO rki_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","ကောက်ရိတ်သောသူသည် ရိတ်သိမ်းခကို ယူ၍ ထာဝရအသက်နှင့်ဆိုင်သော သီးနှံများကို ရိတ်သိမ်း၏။ ထို့ကြောင့် စိုက်ပျိုးသောသူနှင့် ရိတ်သိမ်းသောသူရို့သည် အတူတကွ ဝမ်းမြောက်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","‘တစ်ယောက်က စိုက်ပျိုး၍ နောက်တစ်ယောက်က ရိတ်သိမ်းရ၏’ ဟူသော ဆိုရိုးစကားသည် မှန်ကန်လျက်ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","သင်ရို့ မစိုက်ပျိုးသောလယ်၌ ရိတ်သိမ်းခြင်းငှာ သင်ရို့အား ငါစီရွှတ်တော်မူ၏။ ထိုအရပ်၌ အခြားသောသူရို့သည် အလုပ်လုပ်ကြပြီး ထိုသူရို့၏အလုပ်မှ သင်ရို့သည် အကျိုးကို ရကြ၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ယှာမာရိမြို့သားအပေါင်းရို့သည် ယေသျှုကို ယုံကြည်ကြ၏။ အကြောင်းမူကား ထိုယှာမာရိမိန်းမက “သူသည် အကျွန်ပြုခဖူးသမျှသော အမှုအရာများကို အကျွန်အား ပြောပြခပါ၏” ဟု ပြောဆိုသောကြောင့်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ထို့ကြောင့် ယှာမာရိ မြို့သားအပေါင်းရို့သည် ကိုယ်တော်ထံသို့ ရောက်လာကြသောအခါ မိမိရို့နှင့်အတူ တည်းခိုရန် တောင်းပန်သောကြောင့် ယေသျှုသည်လည်း နှစ်ရက် တည်းနိန်တော်မူလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","များစွာသောလူရို့သည်လည်း ကိုယ်တော်၏ တရားတော်ကြောင့် ယုံကြည်သူများ ဖြစ်လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ထို့နောက် သူရို့က “အဂု အကျွန်ရို့ ယုံကြည်သည်မှာ သင်၏ ပြောပြခြင်းကြောင့် မဟုတ်၊ အကျွန်ရို့ကိုယ်တိုင် ကြားရပြီးလျှင် ထိုအသျှင်သည် လောက၏ စစ်မှန်သော ကယ်တင်သျှင်ဖြစ်ကြောင်းကို အကျွန်ရို့ သိသောကြောင့်ဖြစ်၏” ဟု ထိုမိန်းမအား ပြောဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","နှစ်ရက်လွန်ပြီးနောက် ယေသျှုသည် ထိုအရပ်မှ ထွက်၍ ဂါလိလဲပြည်သို့ လားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ယေသျှုကိုယ်တော်တိုင်၊ “ပရောဖက်မည်သည်ကား မိမိနီရင်းပြည်၌ ဂုဏ်အသရေမဟိ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ကိုယ်တော်သည် ဂါလိလဲပြည်၌ ရောက်သောအခါ ထိုပြည်သားရို့သည် ကိုယ်တော့်ကို ကြိုဆိုကြ၏။ အကြောင်းမူကား သူရို့သည် ယေရုဆလင်မြို့၌ ပသခါပွဲတော်သို့ လားကြပြီး ထိုပွဲတော်အတွင်း ကိုယ်တော်ပြုခသော အရာခပ်သိမ်းကို တွိ့မြင်ခပြီးသောကြောင့် ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ထို့နောက် ယေသျှုသည် ဂါလိလဲပြည် ကာနမြို့သို့ ပြန်ကြွလေ၏။ ထိုနီရာကား ရီကို စပျစ်ရည် ဖြစ်စီသောနီရာ ဖြစ်သတည်း။ ထိုမြို့၌အစိုးရသော အရာဟိတစ်ယောက်၏သားသည် ကပေရနောင်မြို့တွင် ဖျားနာလျက် ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ယေသျှုသည် ယုဒပြည်မှ ဂါလိလဲပြည်သို့ ကြွလာတော်မူကြောင်းကို ထိုသူသည် ကြားသိကြသောအခါ ကိုယ်တော်ထံသို့ လာပြီးလျှင် ကပေရနောင်မြို့သို့ ကြွ၍ သီလုနီးပါးဖြစ်နိန်သော မိမိ၏သားကို ကျန်းမာစီခြင်းငှာ တောင်းလျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ယေသျှုကလည်း “သင်ရို့သည် နိမိတ်လက္ခဏာနှင့် အံ့ဩဖွယ်များကို မမြင်ရလျှင် ယုံကြည်ကြမည် မဟုတ်” ဟု ထိုသူအား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","အရာဟိကလည်း “ဆရာ၊ အကျွန့်သား သီဆုံးမလားခင် အကျွန်နှင့်အတူ လိုက်ပါလော့” ဟု ပြန်၍ လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","ယေသျှုကလည်း “ပြန်လားလော၊ သင်၏သား သက်သာလိမ့်မည်” ဟု ထိုသူအား မိန့်တော်မူ၏။ ထိုသူသည်လည်း ယေသျှု၏စကားကို ယုံကြည်သဖြင့် ပြန်လားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ထိုသူသည် အိမ်သို့ ပြန်သောလမ်း၌ မိမိ၏အခိုင်းအစီများနှင့် တွိ့လျှင် “သင်၏သားသည် သက်သာလားယာ” ဟု ပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ထိုသူကလည်း အခိုင်းအစီတိကို မိမိသားသည် မည်သည့်အချိန်၌ သက်သာလားသည်ကို မိန်းလေ၏။ ထိုသူရို့ကလည်း “ဖျားနာခြင်းမှ သက်သာလာသည်ကား ညက မွန်းလွဲ တစ်ချက်တီးအချိန်၌ ဖြစ်ပါ၏” ဟု ပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","ထိုအခါ သူငယ်၏ဖခင်သည် မိမိသား၌ ဖြစ်ပျက်သောအချိန်သည် ယေသျှုက “သင့်သားသည် သက်သာလိမ့်မည်” ဟု မိန့်တော်မူသော အချိန်ပင်ဖြစ်ကြောင်းကို သတိရလေ၏။ ထို့ကြောင့် သူနှင့် သူ၏ မိသားစုအားလုံးသည် ယုံကြည်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ဤသည်ကား ယေသျှုသည် ယုဒပြည်မှ ဂါလိလဲပြည်သို့ ကြွတော်မူပြီးနောက် ဒုတိယအကြိမ် ပြုသော အံ့ဖွယ်နိမိတ်လက္ခဏာပင် ဖြစ်သတည်း။ ");
INSERT INTO rki_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ထို့နောက် ယေသျှုသည် ယုဒဘာသာရေးပွဲတော် ဟိသည်ဖြစ်၍ ယေရုဆလင်မြို့သို့ ကြွတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","ယေရုဆလင်မြို့၌ ဟိသော သိုးတန်းခါးနားတွင် ရီကန်တစ်ကန် ဟိ၏။ ထိုရီကန်အား ဆင်ဝင်ငါးခုဖြင့် ကာရံထားပြီး ဟေဗြဲဘာသာစကားအားဖြင့် ဗေသေသဒ ဟု ခေါ်ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","မျက်စိမမြင်သောသူ၊ ကိုယ်လက်မသန်စွမ်းသူနှင့် လီဖြတ်သောသူ — စသည့် လူမမာများစွာရို့သည် ထိုဆင်ဝင်များ၌ လဲလျောင်းလျက် နိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","သုံးဆယ်သျှစ်နှစ်ပတ်လုံး ဖျားနာခြင်းဝေဒနာကို ခံစားနိန်ရသော လူတစ်ဦးသည်လည်း ထိုနီရာ၌ ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ယေသျှုသည်လည်း လဲလျောင်းနိန်သော ထိုသူကို မြင်လျှင် ကာလကြာမြင့်စွာ ရောဂါခံစားနိန်ရကြောင်းကို သိတော်မူ၏။ ထို့ကြောင့် ကိုယ်တော်သည် ထိုသူအား “သင်သည် ကျန်းမာခြင်း ရလိုသလော” ဟု မိန်းလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ထိုဖျားနာနိန်သောသူကလည်း “ဆရာ၊ ရီလှုပ်ခတ်လာသောအခါ အကျွန့်အား ရီကန်ထဲသို့ ချပီးမည့်လူ တစ်ယောက်မျှ မဟိပါ။ အကျွန်သည် ရီကန်ထဲသို့ ဆင်းခြင်းငှာ ကြိုးစားနိန်စဉ် တခြားသူတစ်ယောက်သည် ဦးစွာ ရောက်လားတတ်ပါ၏” ဟု လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ယေသျှုကလည်း “ထလော့၊ သင်၏ ဖျာကိုယူ၍ လှမ်းလားလော့” ဟု မိန့်တော်မူလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","ထိုသူသည် ချက်ချင်းပင် ကျန်းမာလားသဖြင့် မိမိဖျာကို ယူ၍ လှမ်းလားလေ၏။ ထိုအမှုအရာ ဖြစ်ပျက်သောနိ့ကား ဥပုသ်နိ့၌ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ထို့ကြောင့် ယုဒအာဏာပိုင်ရို့သည် ကျန်းမာလားသောသူအား “ဤနိ့သည် ဥပုသ်နိ့ဖြစ်သောကြောင့် သင်၏ဖျာကို သယ်ယူခြင်းသည် ငါရို့၏ ပညတ်ကို ဆန့်ကျင်ခြင်းဖြစ်၏” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ထိုသူကလည်း “အကျွန့်ကို ကျန်းမာစီသော သူသည် ဖျာကို ကောက်၍ လှမ်းလားစီခြင်းငှာ အကျွန့်အား မိန့်တော်မူခပါ၏” ဟု ပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ထိုအခါ သူရို့သည် “သင့်ကို ဤပိုင် လုပ်ခိုင်းသောသူကား ဇာသူနည်း” ဟု ထိုသူအား မိန်းလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","သို့ရာတွင် ထိုကျန်းမာလာသောသူသည် မိမိအား စီခိုင်းသောသူသည် ယေသျှုဖြစ်သည်ကို မသိပေ။ အကြောင်းမူကား ထိုနီရာ၌ လူများ၍ ယေသျှုသည်လည်း အဝီးသို့ မထင်မရှား ကြွလားတော်မူသောကြောင့် ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ထို့နောက်မှ ယေသျှုသည် ထိုသူအား ဗိမာန်တော်၌ တွိ့လျှင် “နားထောင်၊ အဂု သင် နီကောင်းယာ။ ထို့ကြောင့် ဒုစရိုက်အပြစ်ပြုခြင်းကို ရပ်တန့်လော့၊ ထိုသို့ မဟုတ်လျှင် ဤထက်ဆိုးသော အရာတိ သင်၌ ဖြစ်လာလိမ့်မည်” ဟု မိန့်တော်မူလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ထိုအခါ ကျန်းမာလာသောသူသည် ထွက်လား၍ ယုဒအာဏာပိုင်ရို့ကို မိမိအား ကျန်းမာစီသောသူသည် ယေသျှုဖြစ်ကြောင်းကို ပြောကြားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ထို့ကြောင့် ယုဒအာဏာပိုင်ရို့သည် ယေသျှုအား ညှဉ်းပန်းခြင်းငှာ စတင်လေ၏။ အကြောင်းမူကား ကိုယ်တော်သည် ဥပုသ်နိ့၌ ကျန်းမာခြင်းအမှုအား ပြုသောကြောင့်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ယေသျှုကလည်း “ငါ့ခမည်းတော်သည် အစဉ်မပြတ် အလုပ်လုပ်နိန်၏။ ထို့ကြောင့် ငါသည်လည်း အလုပ်လုပ်ရမည်” ဟု ထိုသူရို့အား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ဤသို့ မိန့်တော်မူသောကြောင့် လည်းကောင်း၊ ဥပုသ်နိ့၏ စည်းကမ်းကို ဖောက်ဖျက်ခြင်းကြောင့် လည်းကောင်း၊ ဘုရားသခင်ကို မိမိ၏အဖဟု ခေါ်၍ မိမိကိုယ်မိမိ ဘုရားသခင်နှင့် တစ်တန်းတည်း ထားသောကြောင့် လည်းကောင်း ယုဒအာဏာပိုင်တိက ကိုယ်တော့်ကို အသီသတ်ခြင်းငှာ ပို၍ ကြံစည်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ထို့ကြောင့် ယေသျှုသည် ယုဒအာဏာပိုင်ရို့အား “ငါအမှန်ဆိုသည်ကား၊ သားတော်သည် မိမိအလိုအတိုင်း ဇာတစ်ခုမျှ မပြုနိုင်။ သူ၏ခမည်းတော် ပြုတော်မူသမျှသော အရာတိကို မြင်၍သာ ပြု၏။ ခမည်းတော်ပြုသမျှကို သားတော်လည်း ပြု၏။ ");
INSERT INTO rki_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ခမည်းတော်သည် သားတော်ကို ချစ်သောကြောင့် မိမိပြုသမျှ အလုံးစုံတိကို သားတော်အား ဖွင့်ပြတော်မူ၏။ ခမည်းတော်သည် ဤအမှုအရာထက် ကြီးစွာသောအရားတိကို ပြုခြင်းငှာ သားတော်အား ဖွင့်ပြပီးဦးမည် ဖြစ်သောကြောင့် သင်ရို့သည် အံ့ဩခြင်း ဟိကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","ခမည်းတော်သည် သီသောသူကိုပင် ထမြောက်စီပြီး ထိုသူရို့အား အသက်ကို ပီးတော်မူ၏။ ထိုနည်းတူ သားတော်သည်လည်း မိမိအလိုဟိသော သူရို့အား အသက်ကို ပီးလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","ခမည်းတော်သည် ဇာသူ့ကိုမျှ တရားစီရင်တော်မူမည် မဟုတ်။ သားတော်အား တရားစီရင်ရသောအခွင့် အလုံးစုံကို ပီးအပ်ထားပြီးဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","အကြောင်းမူကား လူရို့သည် ခမည်းတော်အား ရိုသီသည့်နည်းတူ သားတော်ကိုလည်း ရိုသီကြစီရန် ဖြစ်၏။ သားတော်အား မရိုသီသောသူ ဟိသမျှရို့သည် ထိုသားတော်အား စီရွှတ်တော်မူသော ခမည်းတော်ကိုလည်း မရိုသီသောသူ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“ငါအမှန်ဆိုသည်ကား၊ ငါ့စကားကို ကြားလျက် ငါအား စီရွှတ်သောသူကို ယုံကြည်သော သူရို့သည် ထာဝရအသက်ကို ရ၏။ ထိုသူရို့သည် တရားစီရင်ခြင်းကို မခံရဘဲ သီခြင်းမှ အသက်ရှင်ခြင်းသို့ ကူးမြောက်သော သူများ ဖြစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","ငါအမှန်ဆိုသည်ကား၊ သီသောသူရို့သည် ဘုရားသခင်သားတော်၏ အသံကို ကြားသောအခါ ပြန်၍ အသက်ရှင်လာမည့် အချိန်သည် လာ၍ အဂုပင် ရောက်လျက်ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","အကြောင်းမူကား ခမည်းတော် ကိုယ်တိုင် အသက်၏ အရင်းအမြစ် ဖြစ်သကဲ့သို့ သားတော်ကိုလည်း ထိုသို့ ဖြစ်စီခြင်းငှာ အခွင့်ပီးတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ခမည်းတော်သည် သားတော်အား တရားစီရင်ပိုင်သော အခွင့်ကိုလည်း ပီးတော်မူ၏။ အကြောင်းမူကား ထိုသူသည် လူသား ဖြစ်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","ဤအမှုအရာကြောင့် မအံ့ဩကတ်ကေ့။ သီလွန်သောသူအားလုံးသည် သားတော်၏ အသံကိုကြား၍၊ သူရို့၏ အုတ်ဂူအသီးသီးမှ ထလာရမည့်အချိန်သည် အဂုပင် ရောက်လျက် ဟိ၏။ ကောင်းသောအကျင့်ကို ကျင့်သောသူရို့သည် အသက်ကို ရ၍၊ မကောင်းသောအကျင့်ကို ကျင့်သောသူရိုသည် ထမြောက်ပြီး အပြစ်စီရင်ခြင်းကို ခံရလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","ယေသျှုကလည်း “ငါသည် မိမိအခွင့်အာဏာဖြင့် ဇာအရာကိုမျှ မပြုနိုင်။ ဘုရားသခင် ဖော်ပြသမျှကိုသာ တရားစီရင်၏။ ထို့ကြောင့် ငါစီရင်ခြင်းသည် မှန်ကန်၏။ အကြောင်းမူကား ငါသည် ကိုယ့်အလိုသို့ လိုက်၍ ပြုခြင်းငှာ မကြိုးစားဘဲ၊ ငါ့အား စီရွှတ်တော်မူသော သူ၏အလိုသို့သာ လိုက်၍ ငါ ပြုသောကြောင့်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“ငါသည် ကိုယ့်အကြောင်းကိုသာ သက်သီခံလျှင် ငါ၏သက်သီသည် လက်ခံနိုင်ဖွယ်မဟိ။ ");
INSERT INTO rki_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ငါ့ကိုယ်စား သက်သီခံသောသူ တစ်ပါးဟိ၏။ ငါ့အကြောင်းကို ထိုသူ၏ သက်သီခံချက်များသည် မှန်ကန်ကြောင်းကို ငါသိ၏။ ");
INSERT INTO rki_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","သင်ရို့သည် ယောဟန်ပါးသို့ သင်ရို့၏တမန်ရို့ကို စီရွှတ်ခ၏။ ယောဟန်သည် သမ္မာတရားဖက်၌ သက်သီခံ၏။ ");
INSERT INTO rki_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","လူတိဖက်မှ သက်သီခံပီးသည်ကို ငါ လို၍ မဟုတ်။ သို့ရာတွင် သင်ရို့ ကယ်တင်ခံရစီခြင်းငှာ ငါဆို၏။ ");
INSERT INTO rki_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ယောဟန်သည် ထွန်းလင်းတောက်ပသော ဆီမီးနှင့် တူ၏၊ သင်ရို့သည် ထိုသူ၏ အလင်း၌ ခဏသာပျော်မွိ့ရန် ဆန္ဒဟိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","သို့ရာတွင် ယောဟန်၏ သက်သီထက် ကြီးမြတ်သောသက်သီတစ်ခုသည် ငါ၌ ဟိ၏။ ခမည်းတော်သည် ငါ့အား အလုပ်ကို ပြီးမြောက်အောင်လုပ်ဆောင်ရန် အပ်ပီးတော်မူသဖြင့် အဂု ငါ လုပ်ဆောင်လျက်ဟိသော အမှုအရာတိကား၊ ငါ့အား ခမည်းတော် စီရွှတ်တော်မူကြောင်းကို သက်သီခံခြင်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ထို့ကြောင့် ငါ့ကို စီရွှတ်သောခမည်းတော်ကိုယ်တိုင် ငါ၏အကြောင်းကို သက်သီခံတော်မူ၏။ သင်ရို့သည် ခမည်းတော်၏ အသံတော်ကို ဇာခါမျှ မကြားဖူး၊ မျက်နှာတော်ကိုလည်း မမြင်ဖူး။ ");
INSERT INTO rki_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ခမည်းတော် စီရွှတ်တော်မူသောသူကို သင်ရို့သည် မယုံကြည်သောကြောင့် နှုတ်ကပတ်တော်သည် သင်ရို့၏စိတ်နှလုံးထဲ၌ မတည်ကြ။ ");
INSERT INTO rki_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","သင်ရို့သည် ကျမ်းစာတော်မြတ်ကို ကြိုးစား၍ လေ့လာကြ၏။ အကြောင်းမူကား သင်ရို့သည် ထိုအထဲ၌ ထာဝရအသက်ကို ရှာတွိ့လိမ့်မည်ဟု ထင်သောကြောင့်ဖြစ်၏။ ထိုကျမ်းစာတော်မြတ်ပင်လျှင် ငါ၏အကြောင်းကို သက်သီခံ၏။ ");
INSERT INTO rki_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","သို့သော် သင်ရို့သည် အသက်ကို ရအံ့သောငှာ ငါ့ထံပါးသို့ မလာလိုကြပေ။ ");
INSERT INTO rki_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“ငါသည် လူတိ ချီးမွမ်းဂုဏ်ပြုခြင်းကို မရှာ။ ");
INSERT INTO rki_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","သို့သော် သင်ရို့သည် ဇာပိုင် လူအမျိုးအစား ဖြစ်ခြင်းကိုလည်းကောင်း၊ သင်ရို့၏စိတ်နှလုံး၌ ဘုရားသခင်ကို ချစ်ခြင်းမဟိသည်ကိုလည်းကောင်း ငါသိ၏။ ");
INSERT INTO rki_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ငါ၏ ခမည်းတော် အခွင့်နှင့် ငါသည် ကြွလာသော်လည်း သင်ရို့သည် ငါ့ကို လက်မခံကြ။ သို့သော် အခြားသူတစ်ယောက်သည် မိမိအခွင့်နှင့် ကြွလာပါမူ သင်ရို့သည် ထိုသူအား လက်ခံကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","သင်ရို့သည် အချင်းချင်းပီးသော ချီးမြှောက်ခြင်းကို ခံလိုကြ၏။ သို့သော် တစ်ဆူတည်းဟိတော်မူသော သင်ရို့၏ ဘုရားသခင်ထံပါးမှ ချီးမြှောက်ခြင်းကိုမူ ရဟိခြင်းငှာ မကြိုးစားကြ။ သို့ဖြစ်၍ သင်ရို့သည် ငါ့ကို ဇာပိုင် ယုံကြည်နိုင်မည်နည်း။ ");
INSERT INTO rki_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","သို့ရာတွင် ငါသည် သင်ရို့အား ငါ၏ ခမည်းတော်ရှိ့၌ အပြစ်တင်စွပ်စွဲလိမ့်မည် ဟူ၍ မထင်ကတ်ကေ့။ သင်ရို့အား အပြစ်တင်စွပ်စွဲမည့်သူကား သင်ရို့ မျှော်လင့်သော မောသျှေပင် ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","သင်ရို့သည် မောသျှေအား စစ်မှန်စွာ ယုံကြည်ခလျှင် ငါ့ကိုလည်း ယုံကြည်ခကြလိမ့်မည်။ အကြောင်းမူကား သူသည် ငါ့အကြောင်းကို ရီးသားထားသောကြောင့်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","သို့သော်လည်း သင်ရို့သည် မောသျှေ ရီးသားထားသမျှကိုပင် မယုံကြည်လျှင် ငါပြောသောစကားကို ဇာပိုင် ယုံကြည်နိုင်မည်နည်း” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ထိုသို့ မိန့်တော်မူပြီးနောက် ယေသျှုကလည်း ဂါလိလဲအိုင် (တိဗေရိအိုင်ဟု လည်းခေါ်ကြ၏) ကို ဖြတ်ကူးတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ကြီးစွာသော လူအစုအဝေးရို့သည် နောက်တော်သို့ လိုက်လာကြ၏။ အကြောင်းမူကား သူရို့သည် မကျန်းမာသောသူရို့၌ ကျန်းမာစီခြင်းငှာ ကိုယ်တော်ပြုခသော နိမိတ်လက္ခဏာများကို တွိ့မြင်ခသောကြောင့်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ယေသျှုသည် တောင်ကုန်းတစ်ခုထက်သို့ တက်၍ တပည့်တော်ရို့နှင့်အတူ ထိုင်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","ထိုအချိန်ကား ယုဒလူမျိုးရို့၏ ပသခါပွဲတော် ကျရောက်မည့်အချိန် ရောက်လုနီးသတည်း။ ");
INSERT INTO rki_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","ယေသျှုသည် လှည့်ပတ်ကြည့်ပြီး များစွာသော လူပရိသတ်ရို့သည် မိမိထံသို့ လာနိန်ကြသည်ကို မြင်လေ၏။ ထိုအခါ ယေသျှုသည် ဖိလိပ္ပုအား “ဤလူတိအားလုံးအဖို့ လုံလောက်အောင် ကျွေးခြင်းငှာ အစားအစာများကို ဇာမှာ ဝယ်လို့ ရပါဖို့လဲ” ဟု မိန်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ဤသို့ မိန်းရခြင်းမှာ ဖိလိပ္ပုအား အကဲခက်လိုသောကြောင့်ဖြစ်၏။ ယေသျှုက မိမိမည်သို့ ပြုရမည်ကို သိထားပြီး ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ဖိလိပ္ပုကလည်း “လူတစ်ယောက်စီကို အစားအစာ တစိကေချေလောက်သာ ပီးမည်ဆိုလျှင်ပင် ငွီဒင်္ဂါးပြား ၂၀၀ အဖိုးနှင့် မလောက်ပါ” ဟု လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ကိုယ်တော်၏ တပည့်တော်ထဲမှ တစ်ယောက်ဖြစ်သော သျှိမုန်ပေတရု၏ညီ အန္ဒြေကလည်း၊ ");
INSERT INTO rki_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“မုန့်ငါးလုံးနှင့် ငါးနှစ်ကောင်ဟိသော အသျှေတစ်ယောက် ဤမှာ ဟိပါ၏။ သို့ရာတွင် ထိုမုန့်နှင့် ငါးများသည် ဤလူအားလုံးအတွက်မူ မလုံလောက်ပါ” ဟု လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","ယေသျှုကလည်း “လူတိကို ထိုင်ခိုင်းကြလော့” ဟု တပည့်တော်ရို့အား မိန့်တော်မူ၏။ ထိုနီရာ၌ မြက်ပင်ထူထပ်လျက်ဟိ၏။ ထို့ကြောင့် ၅,၀၀၀ လောက်ဟိသော ယောက်ျားရို့သည် ထိုနီရာ၌ ထိုင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ထို့နောက် ယေသျှုသည် မုန့်ကို ယူ၍ ကျေးဇူးတော်ကို ချီးမွမ်းပြီးမှ ထိုင်နိန်သော လူအပေါင်းရို့အား ဝီငှပီးတော်မူ၏။ ထိုနည်းတူ ကိုယ်တော်သည် ငါးကိုယူ၍ ဝီငှပီးပြီးလျှင် လူအပေါင်းရို့သည် ဝလင့်စွာစားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ထိုသို့ လူရို့သည် ဝလင့်စွာစားကြပြီးနောက် ကိုယ်တော်သည် တပည့်တော်ရို့အား “စားကြွင်းစားကျန်များ အလေအလွင့် မဖြစ်စီခြင်းငှာ စုသိမ်းကြလော့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ထို့ကြောင့် လူအပေါင်းရို့က ဝလင့်စွာစားကြပြီး တပည့်တော်ရို့သည် မုယောမုန့်ငါးလုံးမှ စားကြွင်းစားကျန်တိကို စုသိမ်းကြရာတွင် တောင်းဖြင့် ဆယ့်နှစ်တောင်း အပြည့်ရလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","ယေသျှုပြုတော်မူသော နိမိတ်လက္ခဏာကို မြင်သောသူအပေါင်းရို့က “ဤသူသည် ဤလောကသို့ ကြွလာသော စစ်မှန်သော ပရောဖက်ဖြစ်၏” ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ယေသျှုက လူအပေါင်းရို့သည် လာ၍ မိမိအား အတင်းခေါ်ဆောင်ကာ သျှင်ဘုရင် မြှောက်ကြလိမ့်မည်ကို သိတော်မူသဖြင့် တစ်ကိုယ်တည်း တောင်ထက်သို့ ကြွတော်မူ။ ");
INSERT INTO rki_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ညချမ်းချိန် ရောက်သောအခါ ယေသျှု၏ တပည့်တော်ရို့သည် ဂါလိလဲအိုင်သို့ ဆင်းလားတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","လောင်းထက်သို့ တက်ကြပြီးလျှင် အိုင်ကိုဖြတ်၍ ကပေရနောင်မြို့သို့ ပြန်လားကြ၏။ ညအချိန် ရောက်လာသော်လည်း ယေသျှုသည် တပည့်တော်ရို့ပါးသို့ မကြွလာသိမ့်။ ");
INSERT INTO rki_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ထိုအချိန်၌ လီပြင်းတိုက်သောကြောင့် အိုင်တွင် လှိုင်းထလာ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","တပည့်တော်ရို့သည် သုံး၊ လေးမိုင်ခန့် လှော်ခတ်ပြီးသောအခါ ယေသျှုသည် ရီထက်တွင် စက်တော်ဖြန့်၍ လောင်းအနားသို့ ကြွလာသည်ကို မြင်ကြသောကြောင့် သူရို့သည် ကြောက်လန့်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ထိုအခါ ယေသျှုက “မကြောက်ကတ်ကေ့၊ ငါပင်ဖြစ်၏” ဟု တပည့်တော်ရို့အား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ထိုအခါ သူရို့သည် ဝမ်းမြောက်စွာဖြင့် ကိုယ်တော့်ကို လောင်းထက်သို့ တက်စီကြပြီးနောက် တစ်ခဏချင်းတွင် လောင်းသည် မိမိရို့ ခရီးဦးတည်ရာ ကမ်းခြီသို့ ရောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","နောက်တစ်နိ့တွင် အိုင်တစ်ဖက်ကမ်း၌ ကျန်ခသော လူပရိသတ်ရို့သည် ထိုအရပ်၌ လောင်းတစ်စီးသာ ဟိခသည်ကို သတိရကြ၏။ ယေသျှုသည် ထိုလောင်း၌ လိုက်ပါတော်မမူဘဲ တပည့်တော်ရို့သာ လားကြကြောင်းကို သိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","သို့ရာတွင် တိဗေရိမြို့မှလာသော လောင်းအချို့ကား သခင်ဘုရားသည် ကျေးဇူးတော်ကို ချီးမွမ်းပြီးမှ လူအပေါင်းရို့ကို ကျွေးခသော အရပ်နားသို့ ရောက်လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","လူအစုအဝေးရို့သည် ထိုအရပ်၌ ယေသျှုနှင့် တပည့်တော်တိကို မတွိ့ကြသောအခါ ထိုလောင်းများထက်၌ တက်၍ ကိုယ်တော့်ကို ရှာခြင်းငှာ ကပေရနောင်မြို့သို့ လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","လူအပေါင်းရို့သည် အိုင်တစ်ဖက် ကမ်း၌ ယေသျှုကို တွိ့မြင်ကြသောအခါ သူရို့က “ဆရာ၊ ဇာအချိန်ကပင် ဤအရပ်သို့ ကြွလာတော်မူသနည်း” ဟု မိန်းလျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ယေသျှုလည်း “သင်ရို့အား ငါအမှန်ဆိုသည်ကား၊ သင်ရို့သည် ငါ့ကို ရှာကြသည်မှာ ငါပြသော နိမိတ်လက္ခဏာများကို နားလည်၍ မဟုတ်ဘဲ သင်ရို့လိုသမျှသော အစားအစာကို ဝစွာစားရသောကြောင့်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ပုပ်ပျက်တတ်သော အစားအစာဖို့ မလုပ်ဆောင်ကတ်ကေ့။ သို့သော် လူသားသည် သင်ရို့အား ပီးတော်မူမည့် ထာဝရအသက်ကို ရစီနိုင်ခြင်းငှာ မပုပ်ပျက်တတ်သော အစာအဖို့သာ လုပ်ဆောင်ကြလော့။ အကြောင်းမူကား အဖဘုရားသခင်သည် လူသားအား တံဆိပ်ခတ်ထားသောသူဖြစ်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","ထို့ကြောင့် သူရို့ကလည်း ကိုယ်တော့်ကို “အကျွန်ရို့သည် ဘုရားသခင် အလိုတော်ဟိသော အရာကို ဆောင်ရွက်နိုင်စီခြင်းငှာ ဇာပိုင် ပြုရပါမည်နည်း” ဟု မိန်းလျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ယေသျှုကလည်း “ဘုရားသခင် အလိုဟိတော်မူသည့် အရာကား ထိုအသျှင် စီရွှတ်တော်မူသောသူကို ယုံကြည်ရန်ဖြစ်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","သူရို့ကလည်း “အကျွန်ရို့သည် ကိုယ့်မျက်စိနှင့် မြင်၍ ကိုယ်တော့်ကို ယုံကြည်နိုင်စီခြင်းငှာ ဇာနိမိတ်လက္ခဏာကို ပြပါမည်နည်း။ ဇာအမှုကို ကိုယ်တော်သည် ပြုပါမည်နည်း။ ");
INSERT INTO rki_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","ကျမ်းစာလာသည်ကား၊ ‘ကိုယ်တော်သည် ထိုသူရို့၏ စားစာရာအဖို့ ကောင်းကင်မှ မုန့်ကို ချပီးတော်မူ၏’ ဟု ဆိုသည့်အတိုင်း အကျွန်ရို့၏ အဖိုးအဖီးများသည် တောကန္တာရ၌ မန္နမုန့်ကို စားကြရပါ၏” ဟု လျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ယေသျှုကလည်း၊ “ငါအမှန်ဆိုသည်ကား၊ သင်ရို့အား မောသျှေ ပီးသောမုန့်သည် ကောင်းကင်မှ လာသည် မဟုတ်။ ငါ၏ခမည်းတော်သည် သင်ရို့အား ကောင်းကင်မှ စစ်မှန်သောမုန့်ကို ပီးတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ဘုရားသခင် ပီးတော်မူသော ထိုမုန့်ကား ကောင်းကင်ဘုံမှ ဆင်းသက်၍ ဤလောကီသားအား အသက်ကို ပီးသောသူဖြစ်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ထိုသူရို့ကလည်း “ဆရာ၊ ထိုမုန့်ကို အကျွန်ရို့အား အစဉ်အမြဲ ပီးတော်မူပါ” ဟု ကိုယ်တော်ထံ တောင်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ယေသျှုကလည်း ထိုသူရို့အား “ငါသည် အသက်မုန့်ဖြစ်၏။ ငါ့ထံသို့ လာသောသူသည် ဇာခါမျှ ဆာမွတ်လိမ့်မည် မဟုတ်။ ငါ့ကို ယုံကြည်သောသူသည် တဖန် ဇာခါမျှ ရီငတ်လိမ့်မည် မဟုတ်။ ");
INSERT INTO rki_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","သင်ရို့ကို ငါပြောနိန်စဉ် သင်ရို့သည် ငါ့ကိုမြင်၏။ သို့သော် ငါ့ကို ယုံကြည်လိမ့်မည် မဟုတ်။ ");
INSERT INTO rki_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","ငါ၏ခမည်းတော်က ငါ့အား ပီးတော်မူသော သူတိုင်းသည် ငါ့ထံသို့ လာကြလိမ့်မည်။ ငါသည်လည်း ငါ့ပါးသို့ လာသောသူကို ကြောခိုင်း၍မထား။ ");
INSERT INTO rki_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","အကြောင်းမူကား၊ ကောင်းကင်မှ ငါ ကြွလာခြင်းသည် ကိုယ့်အလိုအတိုင်း လုပ်ဆောင်ခြင်းငှာ ငါ ကြွလာသည် မဟုတ်။ သို့သော် ငါ့ကို စီရွှတ်တော်မူသော သူ၏အလိုအတိုင်း လုပ်ဆောင်ခြင်းငှာ ကြွလာခြင်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ငါ့ကို စီရွှတ်တော်မူသော သူ၏အလိုတော်ကား၊ ငါ့အား ထိုအသျှင် ပီးအပ်ထားသော သူအပေါင်းရို့သည် ဆုံးယှုံးခြင်းသို့ မရောက်စီဘဲ နောက်ဆုံးသောနိ့၌ ရှင်ပြန်ထမြောက်စီခြင်းငှာ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","သားတော်ကို မြင်တွိ့၍ ယုံကြည်သောသူ အပေါင်းရို့သည် ထာဝရအသက်ကို ရစီခြင်းငှာ ခမည်းတော်သည် အလိုဟိ၏။ ငါသည်လည်း နောက်ဆုံးသောနိ့၌ ထိုသူရို့အား သီခြင်းမှ ရှင်ပြန်ထမြောက်စီတော်မူမည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","ထိုအခါ ယုဒလူရို့သည် ကိုယ်တော့်ကို ညည်းညူကြ၏။ အကြောင်းမူကား ကိုယ်တော်က၊ “ငါသည် ကောင်းကင်မှ ဆင်းကြွလာသော မုန့်ဖြစ်သည်” ဟု ဆိုသောကြောင့်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ထိုသူရို့က၊ “ဤသူသည် ယောသပ်၏သား ယေသျှုဖြစ်သည် မဟုတ်လော၊ သူ့အမိနှင့်အဖကို ငါရို့သိကြ၏။ သို့ဖြစ်ပါလျက် ‘ငါသည် ကောင်းကင်ဘုံမှ ဆင်းကြွလာသည်’ ဟု ဆိုရသလော” ဟု ပြောဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","ထိုအခါ ယေသျှုက “သင်ရို့ အချင်းချင်း ညည်းညူမနိန်ကတ်ကေ့။ ");
INSERT INTO rki_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","ခမည်းတော်သည် လူတိကို ငါ့ထံသို့ မပို့ဆောင်လျှင် ဇာသူမျှ ငါ့ထံသို့ မလာနိုင်။ ငါသည်လည်း ထိုသူရို့အား နောက်ဆုံးသောနိ့၌ ရှင်ပြန်ထမြောက်စီမည်။ ");
INSERT INTO rki_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ပရောဖက်ကျမ်းများ၌ လာသည်ကား၊ ‘ထိုသူအပေါင်းရို့သည် ဘုရားသခင်၏ သွန်သင်တော်မူချက်ကို ခံရလိမ့်မည်’ ဟူ၍ ဖြစ်၏။ ထို့ကြောင့် ခမည်းတော်၏ မိန့်တော်မူသောစကားကို ကြား၍ သင်ယူသောသူ အပေါင်းရို့သည် ငါ့ထံသို့ လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ဤသို့ဆိုရာတွင် ဘုရားသခင်ထံမှ ကြွလာသောသူမှတစ်ပါး ခမည်းတော်ကို မြင်ဖူးသောသူ တစ်စုံတစ်ယောက်ဟိသည်ဟု ငါမဆို။ ဘုရားသခင်ထံမှ ကြွလာသောသူသာလျှင် ခမည်းတော်ကို မြင်ဖူးသောသူ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","သင်ရို့အား ငါအမှန်ဆိုသည်ကား၊ ငါ့ကို ယုံကြည်သောသူသည် ထာဝရအသက်ကို ရ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ငါသည် အသက်မုန့်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","သင်ရို့၏ အဖိုးအဖီးရို့သည် တောကန္တာရ၌ မန္နမုန့်ကို စားခကြ၏။ သို့သော်လည်း သူရို့သည် သီဆုံးလားခရ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","သို့သော် ကောင်းကင်ဘုံမှ ဆင်းသက်လာသောမုန့်ကို စားသောသူမည်သည်ကား သီဆုံးရလိမ့်မည် မဟုတ်။ ");
INSERT INTO rki_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ငါသည် ကောင်းကင်ဘုံမှ ဆင်းသက်တော်မူသော အသက်ရှင်သော မုန့်ဖြစ်၏။ သင်ရို့သည် ထိုမုန့်ကို စားလျှင် ထာဝရ အသက်ရှင်လိမ့်မည်။ လောကသားရို့သည် အသက်ရှင်နိုင်မည့်အကြောင်း ငါပီးသောမုန့် ဟူမူကား ငါ၏အသွီးအသားပင် ဖြစ်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","ထို့နောက် ယုဒလူရို့က “ဤသူသည် ငါရို့စားဖို့ သူ၏အသားကို ဇာပိုင် ပီးနိုင်ပါမည်နည်း” ဟု အချင်းချင်း ပြင်းစွာ စတင်ငြင်းခုံကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ယေသျှုသည်လည်း ထိုသူရို့အား “ငါအမှန်ဆိုသည်ကား၊ သင်ရို့သည် လူသား၏ အသားကို မစား၊ အသွီးကို မသောက်ကြလျှင် သင်ရို့၌ အသက်မဟိ။ ");
INSERT INTO rki_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ငါ့အသားကိုစား၍ ငါ့အသွီးကို သောက်သောသူသည် ထာဝရအသက်ကိုရ၏။ ငါသည်လည်း ထိုသူရို့ကို နောက်ဆုံးသောနိ့၌ သီခြင်းမှ ရှင်ပြန်ထမြောက်စီတော်မူမည်။ ");
INSERT INTO rki_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ငါ့အသားသည် စစ်မှန်သောစားစရာ ဖြစ်၏။ ငါ၏အသွီးသည်လည်း စစ်မှန်သော သောက်စာရာ ဖြစ်ပေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ငါ့အသားကို စား၍၊ ငါ့အသွီးကို သောက်သောသူသည် ငါ၌ တည်၏။ ငါသည်လည်း ထိုသူ၌ တည်၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","အသက်ရှင်သော ခမည်းတော်သည် ငါ့အား စီရွှတ်တော်မူ၏။ ငါသည်လည်း ခမည်းတော်အားဖြင့် အသက်ရှင်၏။ ထိုနည်းတူ ငါ၏အသွီးကို သောက်၍ အသားကို စားသောသူရို့သည် ငါ့ကြောင့် အသက်ရှင်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ထို့ကြောင့် ဤမုန့်သည် ကောင်းကင်မှ ဆင်းသက်လာသော မုန့်ဖြစ်၏။ သင်ရို့၏ အဖိုးအဖီးရို့သည် စားပြီး သီဆုံးလားသော မုန့်မျိုး မဟုတ်။ သို့သော် ဤမုန့်ကို စားသောသူသည် ထာဝရ အသက်ရှင်လိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ယေသျှုသည် ကပေရနောင်မြို့၌ဟိသော တရားဇရပ်တွင် ဟောပြောသွန်သင်စဉ် ဤဩဝါဒများကို ပီးတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ထိုသွန်သင်ချက်များကို ကိုယ်တော်၏ တပည့်တော်ရို့သည် ကြားကြလျှင် “ဤသွန်သင်ချက်ရို့သည် ခက်ခဲလွန်းသောကြောင့် ဇာသူ လိုက်နာနိုင်ပါမည်နည်း” ဟု ပြောဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","ထိုသို့ တပည့်တော်တိ ပြောဆိုကြသည်ကို ယေသျှုသည် သိတော်မူသဖြင့် “ဤစကားကြောင့် သင်ရို့ ညည်းညူလျက် နိန်ကြသလော။ ");
INSERT INTO rki_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","လူသားသည် မိမိ၏ အယင်နီရာသို့ တက်ကြွလားသည်ကို သင်ရို့မြင်တွိ့လျှင် ဇာပိုင် ထင်မှတ်ကြမည်နည်း။ ");
INSERT INTO rki_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ဘုရားသခင်၏ ဝိညာဉ်တော်သာလျှင် အသက်ကို ပီးနိုင်၏။ လူသားရို့၏ အစွမ်းတန်ခိုးမူကား အသက်ကို မပီးနိုင်။ သင်ရို့အား ငါပြောသောစကားသည် အသက်ရှင်စီသော ထိုဝိညာဉ်တော်နှင့်သာ သက်ဆိုင်၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","သို့သော် သင်ရို့အထဲမှ တချို့သည် မယုံကြည်ကြ” ဟု မိန့်တော်မူ၏။ ဤသို့ မိန့်တော်မူသည်မှာ ယေသျှုသည် မိမိအား မယုံကြည်သော သူများကိုလည်းကောင်း၊ သစ္စာဖောက်မည့်သူကိုလည်းကောင်း အစကတည်းကပင် သိတော်မူပြီးဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","တဖန် ကိုယ်တော်ကလည်း “ဤအကြောင်းကြောင့် သင်ရို့အား ငါဆိုခသည့်အတိုင်း ခမည်းတော်သည် အခွင့်ပီးတော်မမူလျှင် ဇာသူမျှ ငါ့ထံသို့ မလာနိုင်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ထိုအချိန်မှ စ၍ များစွာသော ယေသျှု၏ နောက်လိုက်ရို့သည် အထံတော်ပါးမှ ဆုတ်ခွါလားကြပြီး ထပ်၍တစ်ကြိမ်တစ်ခါမျှ မလိုက်ကတ်လီယာ။ ");
INSERT INTO rki_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","ထို့ကြောင့် ကိုယ်တော်သည် တပည့်တော် တစ်ဆယ့်နှစ်ပါးအား၊ “သင်ရို့သည်လည်း ငါ့ထံမှ ထွက်လားလိုကြသလော” ဟု မိန်းလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ထိုအခါ သျှိမုန်ပေတရု ကလည်း “အသျှင်၊ အကျွန်ရို့ ဇာသူ့ပါးသို့ လားရပါမည်နည်း။ ထာဝရအသက်နှင့်ဆိုင်သော တရားကို ကိုယ်တော် ဟောပါ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ကိုယ်တော်သည် ဘုရားသခင်ထံမှ ကြွလာသော သန့်ယှင်းသောသူ ဖြစ်ကြောင်းကို အကျွန်ရို့သည် ယုံကြည်သောကြောင့် သိကြပါ၏” ဟု လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ထိုအခါ ယေသျှုက၊ “သင်ရို့ တစ်ဆယ့်နှစ်ပါးကို ငါ ရွီးချယ်သည် မဟုတ်သလော။ သို့သော် သင်ရို့၌ မာရ်နတ်တစ်ဦး ဟိ၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ကိုယ်တော်သည် သျှိမုန်သျှာကာရုတ်၏သား ယုဒကို ရည်မှတ်၍ ပြောဆိုခြင်းဖြစ်၏။ အကြောင်းမူကား ယုဒသည် တစ်ကျိပ်နှစ်ပါးသော တပည့်တော်တိ အဝင်ဖြစ်သော်လည်း မိမိအား ရန်သူ့လက်သို့ အပ်မည့်အကြောင်းကို သိတော်မူသောကြောင့်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ထို့နောက် ယေသျှုသည် ဂါလိလဲပြည်တလျှောက် ဒေသစာရီ လှည့်လည်တော်မူ၏။ ယုဒအာဏာပိုင်ရို့က ကိုယ်တော့်ကိုသတ်ရန် ကြံစည်နိန်ကြသဖြင့် ကိုယ်တော်သည် ယုဒပြည်၌ လှည့်လည်ခြင်းငှာ အလိုမဟိပေ။ ");
INSERT INTO rki_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","ယုဒအမျိုးသားရို့၏ သကေနေပွဲတော် ကျရောက်မည့်အချိန်ကား နီးကပ်လာလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ထို့ကြောင့် ညီတော်များက ယေသျှုအား “သင်ပြုသော အမှုအရာတိကို သင်၏ နောက်လိုက်တိ တွိ့မြင်စီခြင်းငှာ ဂါလိလဲပြည်မှ ထွက်၍ ယုဒပြည်သို့ လားပါလော့။ ");
INSERT INTO rki_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ထင်ပေါ်ကျော်ကြားလိုသော သူသည် ဇာအမှုကိုမျှ ဆိတ်ကွယ်ရာ၌ ပြုလေ့မဟိ။ သင်သည် ဤသို့သောအမှုအရာများကို ပြုမည်ဆိုပါက လောကတစ်ခုလုံးက သိအောင် ပြုပါလော့” ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","အကြောင်းမူကား ကိုယ်တော်၏ ညီတော်များသည်ပင်လျှင် ကိုယ်တော့်ကို မယုံကြည်ကြပေ။ ");
INSERT INTO rki_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","သို့သော် ယေသျှုက “ငါ၏အချိန် မရောက်သိမ့်။ သင်ရို့၏အချိန်ကား ကာလအစဉ် အသင့်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","လောကီသားတိက သင်ရို့ကို မမုန်းနိုင်ကြ။ သို့သော် ငါ့ကိုမူကား မုန်းကြ၏။ အကြောင်းမူကား ငါသည် သူရို့၏ မကောင်းသောအကျင့်များကို ထုတ်ဖော်ပြောဆိုသောကြောင့်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","ထိုပွဲသို့ သင်ရို့ လားကြလော့။ ငါမူကား မလား။ အကြောင်းမူကား ငါ၏အချိန် မရောက်သိမ့်သောကြောင့် ဖြစ်၏” ဟု ညီတော်များအား မိန့်တော်မူလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ထိုသို့ မိန့်တော်မူပြီးနောက် ကိုယ်တော်သည် ဂါလိလဲပြည်၌ နီတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","ထိုပွဲတော်သို့ ကိုယ်တော်၏ညီတော်တိ လားပြီးမှ ယေသျှုသည်လည်း မထင်မရှား ကြွတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","ယုဒအာဏာပိုင်ရို့သည် ထိုပွဲ၌ ကိုယ်တော့်ကို ရှာလျက် “ထိုသူကား ဇာမှာနည်း” ဟု မိန်းမြန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","လူအစုအဝေးကလည်း ကိုယ်တော်အကြောင်းကို များစွာ တီးတိုးပြောဆိုနိန်ကြ၏။ တချို့လူရို့က “ထိုသူသည် သူတော်ကောင်းဖြစ်၏” ဟူ၍လည်းကောင်း၊ တခြားသောလူတိကလည်း “သူတော်ကောင်း မဟုတ်၊ လူတိကို မှောက်မှားစီသော သူသာဖြစ်၏” ဟူ၍ လည်းကောင်း ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","သို့ပင်သျှောင် လူတိက ယုဒအာဏာပိုင်တိကို ကြောက်လန့်ကြသဖြင့် ကိုယ်တော့်အကြောင်းကို မည်သူမျှ ပွင့်လင်းစွာ မပြောဝံ့ကြပေ။ ");
INSERT INTO rki_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ထိုပွဲကျင်းပသောကာလ ထက်ဝက်ခန့်မျှ ရောက်လာသောအခါ ယေသျှုသည် ဗိမာန်တော်သို့ ကြွ၍ စတင်ဟောပြောသွန်သင်လျက် နိန်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ထိုအရပ်၌ဟိကြသော ယုဒလူရို့သည်လည်း အံ့ဩကြ၍ “ဤသူသည် ဇာအတန်းပညာကိုမျှ မသင်ယူဖူးဘဲ ဤပညာများကို မည်သို့ရသနည်း” ဟု ပြောဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ယေသျှုကလည်း “ငါသွန်သင်သော တရားသည် ငါ၏တရား မဟုတ်။ ငါ့ကို စီရွှတ်တော်မူသောသူ၏ တရားပင်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","ဘုရားသခင်၏အလိုကို လိုက်လျှောက်လိုသော သူရို့မူကား၊ ငါဟောပြောသောတရားသည် ဘုရားသခင်၏ တရားဖြစ်သလော၊ သို့မဟုတ် ငါ၏ တရားဖြစ်သလော ဟူ၍ ခွဲခြားသိမြင်ကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","မိမိရို့၏တရားကို ဟောပြောသောသူသည် မိမိ၏ဘုန်းကို ရဟိ၏။ သို့သော် မိမိအား စီရွှတ်တော်မူသောသူ၏ ဘုန်းတန်ခိုးကို ရှာသောသူမူကား ရိုးသားစွာ ဟောပြောတတ်၏။ ထိုသူ၌ အမှားမဟိ။ ");
INSERT INTO rki_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","မောသျှေသည် သင်ရို့အား ပညတ်တရားကို ပီးခသည် မဟုတ်လော။ သို့သော်လည်း သင်ရို့တစ်ယောက်မျှ ထိုပညတ်တရားကို မလိုက်လျှောက်ကြ။ သင်ရို့သည် ငါ့ကို ဇာကြောင့် သတ်ခြင်းငှာ ကြိုးစားနိန်ကြသနည်း” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","လူအပေါင်းရို့ကလည်း “သင်သည် နတ်မိစ္ဆာ ဝင်ပူးခံရသောသူဖြစ်၏။ မည်သူသည် သင့်အား သတ်ရန် ကြိုးစားနိန်သနည်း” ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ယေသျှုကလည်း “ငါသည် နိမိတ်လက္ခဏာတစ်ခုကို ပြုသောအခါ သင်ရို့အားလုံးသည် အံ့ဩကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","မောသျှေသည် သင်ရို့၏ သားသျှေတိအား အရီဖျားလှီးခြင်းကို ပြုခြင်းငှာ ပညတ်ခ၏။ ထို့ကြောင့် သင်ရို့သည် ဥပုသ်နိ့၌ပင် အရီဖျားလှီးခြင်းကို ပြုကြ၏။ သို့သော် ထိုအရီဖျားလှီးခြင်းကို မောသျှေမှစတင်၍ ခံခသည် မဟုတ်၊ သင်ရို့၏ အဖိုးအဖီးတိမှ စတင်၍ ပြုခကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","မောသျှေ၏ပညတ်အား မချိုးဖောက်စီခြင်းငှာ သင်ရို့သည် ဥပုသ်နိ့တွင် ယောက်ျားသျှေတစ်ယောက်အား အရီဖျားလှီးခြင်းကို ပြုကြလျှင် ငါသည် လူတစ်ဦးအား ကျန်းမာစီသောအခါ သင်ရို့သည် ငါ့ကို ဇာကြောင့် အမျက်ထွက်ကြသနည်း။ ");
INSERT INTO rki_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","အပြင်ပန်းသဏ္ဌာန်ကိုသာ ကြည့်၍ အပြစ်စီရင်ခြင်း မပြုကတ်ကေ့။ မှန်ကန်သော တရားဖြင့်သာ အပြစ်စီရင်ကြလော့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","ထိုအခါ ယေရုဆလင်မြို့မှ လူတချို့က “ဤသူကို အာဏာပိုင်တိက သတ်ရန် ရှာနိန်ကြသည် မဟုတ်လော။ ");
INSERT INTO rki_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ကြည့်ပါ၊ ဤသူသည် ထင်ရှားစွာ ဟောပြောသွန်သင်လျက် နိန်၏။ သူရို့သည် ကိုယ်တော့်ကို စကားတစ်ခွန်းမျှ မပြောနိုင်ကြ။ ဤသူသည် မေသျှိယဖြစ်ကြောင်းကို အာဏာပိုင်များက အမှန်ပင် သိကြသလော။ ");
INSERT INTO rki_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","မေသျှိယ ကြွလာသောအခါ ထိုအသျှင်သည် ဇာအရပ်မှ ကြွလာသည်ကို မည်သူမျှ သိလိမ့်မည် မဟုတ်။ သို့သော် ဤသူ၏ ဇာတိကို ငါရို့သိကြ၏” ဟု အချင်းချင်း ပြောဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","ယေသျှုသည် ဗိမာန်တော်၌ ဆုံးမဩဝါဒ ပီးတော်မူစဉ်၊ “သင်ရို့သည် ငါ့ကိုလည်းကောင်း၊ ငါသည် ဇာအရပ်မှ လာသည်ကိုလည်းကောင်း သိကြ၏။ ငါသည် ကိုယ့်အလိုဖြင့် လာသည် မဟုတ်။ ငါ့ကို စီရွှတ်တော်မူသော သူသည် သစ္စာနှင့် ပြည့်စုံတော်မူ၏။ ထိုအသျှင်ကို သင်ရို့ မသိကြသလော။ ");
INSERT INTO rki_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","သို့ရာတွင် ငါမူကား ထိုအသျှင်ထံပါးမှ လာ၍ ထိုအသျှင်သည် ငါ့ကို စီရွှတ်တော်မူသောကြောင့် ငါသည် ထိုအသျှင်ကို သိ၏” ဟု ကျယ်သောအသံဖြင့် မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ထို့နောက် ထိုသူရို့သည် ကိုယ်တော့်ကို ဖမ်းဆီးခြင်းငှာ အခွင့်ရှာကြ၏။ သို့သော် အချိန်မကျသိမ့်သောကြောင့် တစ်ဦးတစ်ယောက်ကမှ မဖမ်းဆီးနိုင်ကြ။ ");
INSERT INTO rki_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","လူအစုအဝေးထဲမှ အများသောသူရို့သည် ကိုယ်တော့်ကို ယုံကြည်လာကြပြီးလျှင် “မေသျှိယ ကြွလာသောအခါ ဤသူပြုသော နိမိတ်လက္ခဏာထက် သာ၍ ပြုမည်လော” ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","လူအစုအဝေးရို့သည် ယေသျှု၏အကြောင်းကို တိုးတိုးချေ ပြောဆိုနိန်ကြသည်ကို ဖာရိယှဲရို့သည် ကြားကြ၏။ ထို့ကြောင့် ဖာရိယှဲရို့နှင့် ယဇ်ပုရောဟိတ် အကြီးအကဲများသည် ကိုယ်တော့်ကို ဖမ်းဆီးခြင်းငှာ အစောင့်စစ်သည်များအား စီရွှတ်လိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ယေသျှုက “ငါသည် သင်ရို့နှင့်အတူ အချိန်အနည်းချေမျှသာ နီပြီးလျှင်၊ ငါ့ကို စီရွှတ်တော်မူသော သူ၏ထံသို့ လားရမည်။ ");
INSERT INTO rki_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","သင်ရို့သည် ငါ့ကို ရှာကြသော်လည်း တွိ့ကြလိမ့်မည် မဟုတ်။ အကြောင်းမူကား ငါဟိမည့်အရပ်သို့ သင်ရို့သည် မလားနိုင်ကြ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","ယုဒအာဏာပိုင်ရို့က “ငါရို့ကို မတွိ့စီခြင်းငှာ ဤသူသည် ဇာအရပ်သို့ လားမည်နည်း။ ဤသူသည် ဟေလသမြို့များ၌ ကွဲလွင့်လျက်ဟိသော ငါရို့လူမျိုးပါးသို့ လားပြီး ဟေလသလူမျိုးရို့ကို ဩဝါဒပီး မည်လော။ ");
INSERT INTO rki_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","သင်ရို့သည် ငါ့ကို ရှာသော်လည်း တွိ့လိမ့်မည် မဟုတ်။ ငါဟိရာ အရပ်သို့ သင်ရို့ မလားနိုင်ကြဟု ဆို၏။ ဤစကားများ၏ အနက်ကား မည်သို့နည်း” ဟု အချင်းချင်း မိန်းမြန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ပွဲတော်၏ နောက်ဆုံးနိ့ဖြစ်သော အရေးအကြီးဆုံးသောနိ့၌ ယေသျှုသည် ရပ်၍ “ရီငတ်သောသူသည် ငါ့ထံသို့လာ၍ သောက်ကြလော့၊ ");
INSERT INTO rki_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ငါ့ကို ယုံကြည်၍ ထိုရီကို သောက်သောသူသည် ကျမ်းစာလာသည်အတိုင်း ‘အသက်ရီစီးထွက်ရာ စမ်းရီတွင်း ဖြစ်လိမ့်မည်’” ဟု ကျယ်သောအသံနှင့် မိန့်တော်မူလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ထိုသို့ မိန့်တော်မူသည်တွင် ယုံကြည်သောသူရို့၌ ခံရမည့် ဝိညာဉ်တော်ကို ရည်မှတ်၍ မိန့်တော်မူ၏။ ထိုအချိန်၌ ယေသျှုသည် ဘုန်းပွင့်တော် မမူသိမ့်သောကြောင့် ယုံကြည်သောသူရို့အား ဝိညာဉ်တော်ကို ပီးတော်မမူသိမ့်။ ");
INSERT INTO rki_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","လူအစုအဝေးထဲမှ လူတချို့သည် ကိုယ်တော်၏ စကားတော်ကိုကြားကြလျှင် “ဤသူသည် အမှန်စင်စစ် ပရောဖက်ဖြစ်၏” ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","တချို့ကလည်း “ဤသူသည် မေသျှိယ ဖြစ်၏” ဟု ဆိုကြ၏။ သို့ရာတွင် တချို့က “မေသျှိယသည် ဂါလိလဲပြည်မှ ပေါ်ထွန်းမည်လော။ ");
INSERT INTO rki_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ကျမ်းစာလာသည်ကား မေသျှိယသည် ဒါဝိဒ်၏အမျိုး၊ ဒါဝိဒ်၏မြို့တည်းဟူသော ဗက်လင်မြို့မှ ပေါ်ထွန်းလာလိမ့်မည်” ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","လူအပေါင်းရို့သည် ယေသျှုနှင့် ပတ်သက်၍ စိတ်သဘောကွဲကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","လူတချို့သည် ကိုယ်တော့်ကို ဖမ်းဆီးလိုကြ၏။ သို့သော်လည်း ကိုယ်တော့်ကို ဇာသူမျှ မဖမ်းဆီးကြပေ။ ");
INSERT INTO rki_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","အစောင့်စစ်သည်များသည် ယဇ်ပုရောဟိတ်အကြီးအကဲရို့နှင့် ဖာရိယှဲရို့ထံပါးသို့ ပြန်လာကြသောအခါ ထိုသူရို့အား “ဇာကြောင့် ထိုသူကို ဖမ်းခေါ်မလာကြသနည်း” ဟု မိန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","အစောင့်စစ်သည်များက “ထိုသူ ဟောပြောသည့်နည်းတူ ဇာသူမျှ မဟောဖူးပါ” ဟု ပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ထိုအခါ ဖာရိယှဲရို့က “သင်ရို့သည်လည်း ထိုသူ၏လှည့်စားခြင်းကို ခံရပြီလော။ ");
INSERT INTO rki_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","အာဏာပိုင်ရို့၊ ဖာရိယှဲရို့ထဲက တစ်စုံတစ်ယောက်သည် ထိုသူ့ကို ယုံကြည်နိန်ပြီလော။ ");
INSERT INTO rki_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ဤလူစုလူဝေးက မောသျှေ၏ ပညတ်တရားကို မသိသောကြောင့် ဘုရားသခင်၏ ကျိန်ခြင်းအောက်၌သာ ဟိနိန်ကြ၏” ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ထိုဖာရိယှဲရို့အထဲတွင် နိကောဒင်ဆိုသူလည်းပါ၏။ ထိုသူသည် အယင်က ယေသျှုထံပါးသို့ လာဖူး၏။ ");
INSERT INTO rki_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","နိကောဒင်ကလည်း ထိုသူရို့ပါးသို့လား၍ “ငါရို့ပညတ်အရ တစ်စုံတစ်ယောက်၏ ပြုမူခြင်းကို မတွိ့ရ၊ သူပြောသောစကားကို မကြားရခင် ထိုသူကို ငါရို့ အပြစ် မစီရင်နိုင်” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ထိုသူရို့ကလည်း “သင်သည်လည်း ဂါလိလဲပြည်သား ဖြစ်သလော။ ကျမ်းစာတော်မြတ်ကို လေ့လာကြည့်ပါ၊ ဂါလိလဲပြည်က ဇာပရောဖက်မျှ မပေါ်ထွန်းဖူးသည်ကို သင်သိလိမ့်မည်” ဟု ဆိုကြ၏။  ");
INSERT INTO rki_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ထို့နောက် လူအပေါင်းရို့သည် မိမိအိမ်သို့ အသီးသီး ပြန်လားကြသော်လည်း၊ ");
INSERT INTO rki_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ယေသျှုက သံလွင်တောင်သို့ တက်ကြွတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","နောက်တစ်နိ့ မိုးထက်စောစော ဗိမာန်တော်သို့ ပြန်ကြွလာသောအခါ လူအပေါင်းရို့သည် အထံတော်သို့ စုရုံးလာကြ၏။ ကိုယ်တော်သည် ထိုင်တော်မူ၍ လူအပေါင်းရို့အား ဟောပြောသွန်သင်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ကျမ်းတတ်ဆရာရို့နှင့် ဖာရိယှဲရို့သည် ဖောက်ပြန်ခြင်းအမှုကို ပြုနိန်သော မိန်းမတစ်ယောက်ကို ဖမ်းဆီးကာ ကိုယ်တော်ထံသို့ ဆောင်ယူလာ၍ သူရို့ရှိ့တွင် ရပ်ခိုင်းထားပြီးလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ယေသျှုအား၊ “ဆရာ၊ ဤမိန်းမသည် မှားယွင်းခြင်းအမှုကို ပြုနိန်စဉ် ငါရို့ တွိ့၍ ဖမ်းလာခ၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","မောသျှေစီရင်သော ငါရို့၏ ပညတ်တရား၌ ထိုသို့သော မိန်းမတိကို ကျောက်ခဲနှင့် ပစ်သတ်ရမည်ဟု အကျွန်ရို့အား ပညတ်ခပါ၏။ ကိုယ်တော်က အဂု မည်သို့ မိန့်တော်မူပါမည်နည်း” ဟု လျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","သူရို့သည် ယေသျှုကို ပြစ်တင်စွပ်စွဲနိုင်ရန် ဤသို့ အကွက်ဆင်၍ မိန်းကြခြင်းဖြစ်၏။ သို့သော်လည်း ကိုယ်တော်သည် ငုံ့၍ မြီကြီးထက်တွင် လက်ညှိုးတော်ဖြင့် ရီးခြစ်လျက် နိန်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ထိုသူရို့သည် ထပ်ကာထပ်ကာ မိန်းလျှောက်ကြသောအခါ ကိုယ်တော်က မော့ကြည့်တော်မူလျက် “သင်ရို့အထဲက အပြစ်ကင်းသူသည် အယင်ဆုံး ဤမိန်းမကို ကျောက်ခဲနှင့် ပစ်ပါ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ထို့နောက် တဖန် ငုံ့၍ မြီကြီးတွင် ရီးခြစ်လျက် နိန်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ထိုသူရို့သည် မိန့်တော်မူချက်ကို ကြားလျှင် အသက်ကြီးသောသူမှစ၍ တစ်ယောက်ပြီးတစ်ယောက် ထွက်လားကြ၏။ ယေသျှုသည် တစ်ယောက်တည်း ကျန်ခတော်မူ၍၊ မိန်းမသည် ရပ်နိန်သိမ့်၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ယေသျှုသည် မော်၍ ကြည့်တော်မူသောအခါ၊ “သူရို့ကား ဇာမာလဲ၊ သင့်ကို အပြစ်စီရင်မည့်သူ တစ်ယောက်လည်း မဟိကြသလော” ဟု သူမအား မိန်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","ထိုမိန်းမကလည်း “တစ်ယောက်လည်း မဟိယာ၊ ဆရာ” ဟု လျှောက်လေ၏။ ယေသျှုက “ငါလည်း သင့်ကို အပြစ်မစီရင်၊ ပြန်လားလီ၊ နောက်တစ်ခါ အပြစ်မလုပ်လီကေ့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","တဖန် ယေသျှုက ဖာရိယှဲရို့အား “ငါသည် လောက၏ အလင်းဖြစ်၏။ ငါ့နောက်သို့ လိုက်သောသူသည် အသက်၏အလင်းကို ရကြပြီးလျှင် မှောင်မိုက်ထဲ၌ လုံးဝ လျှောက်လားရလိမ့်မည် မဟုတ်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ဖာရိယှဲရို့က “သင်သည် ကိုယ့်အကြောင်းကိုသာ သက်သီခံခြင်း ဖြစ်၏။ သင်၏ သက်သီခံခြင်းသည် အထောက်အထားမဟိ” ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ယေသျှုက “ငါသည် ကိုယ့်အကြောင်းကိုသာ သက်သီခံသော်လည်း ငါ၏ သက်သီခံချက်သည် မှန်၏။ အကြောင်းမူကား ငါသည် မည်သည့်အရပ်က လာသည်ကိုလည်းကောင်း၊ မည်သည့်အရပ်သို့ လားရမည်ကိုလည်းကောင်း ငါသိ၏။ သင်ရို့သည် ငါ မည်သည့်အရပ်က လာသည်ကိုလည်းကောင်း၊ ငါ မည်သည့်အရပ်သို့ လားရမည်ကိုလည်းကောင်း မသိကြ။ ");
INSERT INTO rki_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","သင်ရို့သည် လူ့နည်းလမ်းအတိုင်းသာ တရားစီရင်တတ်ကြ၏။ ငါကား တစ်ယောက်ကိုလေ့ မစီရင်။ ");
INSERT INTO rki_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","ငါသည် တရားစီရင်သော်လည်း ငါ၏စီရင်ခြင်းသည် မှန်ကန်၏။ အကြောင်းမူကား ငါသည် တစ်ယောက်တည်း စီရင်သည် မဟုတ်။ ငါ့ကို စီရွှတ်တော်မူသော ဖခမည်းတော်က ငါနှင့်အတူ ဟိနိန်သောကြောင့်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","သင်ရို့၏ ပညတ်တော်၌ သက်သီနှစ်ဦး ထွက်ဆိုလျှင် သင်ရို့ပြောသမျှ မှန်သည်ဟု ဖော်ပြထား၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ငါသည် ကိုယ့်အကြောင်းကိုသာ သက်သီခံသည့်အပြင် ငါ့ကို စီရွှတ်တော်မူသော ခမည်းတော်ကလည်း ငါ့အကြောင်းကို သက်သီခံတော်မူ၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ထိုသူရို့ကလည်း “သင်၏ ခမည်းတော်က ဇာမာလဲ” ဟု မိန်းလျှောက်ကြ၏။ ယေသျှုက “သင်ရို့သည် ငါ့ကို မသိကြ။ ခမည်းတော်ကိုလည်း မသိကြ။ ငါ့ကို သိလျှင်မူကား ငါ့ခမည်းတော်ကိုလည်း သိကြမည်” ဟု ဖြေကြားတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ကိုယ်တော်သည် ဤစကားတော်များကို ဗိမာန်တော်၏ အလှူခံသေတ္တာထားရာ အခန်း၌ ဟောပြောတော်မူ၏။ သို့သော် ကိုယ်တော်၏အချိန် မရောက်သိမ့်သောကြောင့် မည်သူမျှ ကိုယ်တော့်ကို မဖမ်းဆီးကြ။ ");
INSERT INTO rki_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","တဖန် ယေသျှုက၊ “ငါသည် လားရမည်။ သင်ရို့သည် ငါ့ကို ရှာကြလိမ့်မည်။ သို့ရာတွင် သင်ရို့သည် ကိုယ့်အပြစ်များကြောင့် သီဆုံးကြလိမ့်မည်။ ငါလားမည့်အရပ်သို့ သင်ရို့မလားနိုင်ကြ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","ထို့ကြောင့် ယုဒအာဏာပိုင်များက “ငါလားမည့်အရပ်သို့ သင်ရို့ မလားနိုင်ကြဟု သူပြောယာ။ သူသည် သူ့ကိုယ်သူ သတ်သီလားမည်လော” ဟု ပြောဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ယေသျှုက “သင်ရို့သည် အောက်အရပ်က ဖြစ်ကြသော်လည်း ငါကား အထက်အရပ်က ဖြစ်၏။ သင်ရို့ကား လောကသားတိ ဖြစ်ကြသော်လည်း ငါကား လောကသား မဟုတ်။ ");
INSERT INTO rki_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","ထို့အတွက်ကြောင့် သင်ရို့သည် သင်ရို့အပြစ်များကြောင့် သီဆုံးရလိမ့်မည်ဟု ငါဆို၏။ ‘ငါဖြစ်သည်အတိုင်း ငါဖြစ်သည်’ ကို သင်ရို့ မယုံကြည်ကြလျှင် သင်ရို့သည် သင်ရို့အပြစ်များကြောင့် သီဆုံးကြလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ထိုသူရို့က “သင်ကား ဇာသူနည်း” ဟု မိန်းလျှင်၊ ယေသျှုကလည်း “ငါသည် ဇာသူဖြစ်သည်ကို အယင်က သင်ရို့ကို ငါပြောခယာ။ ");
INSERT INTO rki_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","သင်ရို့အကြောင်းကို ငါပြောဆိုစရာ၊ အပြစ်စီရင်စရာများစွာ ဟိသိမ့်၏။ ငါ့ကို စီရွှတ်တော်မူသောသူသည် သစ္စာနှင့် ပြည့်စုံတော်မူ၏။ ငါသည် ထိုအသျှင်ထံပါးက ကြားရသောအရာများကို ဤလောက၌ ငါဟောပြော၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","ယေသျှုသည် ခမည်းတော်၏အကြောင်းကို ရည်မှတ်၍ မိန့်တော်မူသည်ကို သူရို့သည် မရိပ်မိကြ။ ");
INSERT INTO rki_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ထို့နောက် ယေသျှုက “သင်ရို့သည် လူသားကို မြီကြီးမှ မြှောက်ထားသောအခါ ‘ငါဖြစ်သည်အတိုင်း ငါဖြစ်သည်’ ကိုလည်းကောင်း၊ ငါသည် ကိုယ့်အခွင့်အာဏာနှင့် ဇာအမှုကိုမျှ မပြုဘဲ ခမည်းတော်က ငါ့ကို သွန်သင်တော်မူသည်အတိုင်း ငါဟောပြောသည်ကို သင်ရို့ သိကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","ငါ့ကို စီရွှတ်တော်မူသော အသျှင်သည် ငါနှင့်အတူ ဟိတော်မူ၏။ အကြောင်းမူကား ထိုအသျှင် နှစ်သက်သောအမှုကို ငါသည် အစဉ်မပြတ် လုပ်ဆောင်သည်ဖြစ်သောကြောင့် ငါ့အား တစ်ယောက်တည်း စွန့်ပစ်ထားတော်မမူ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","ဤသို့ မိန့်တော်မူချက်ကို ကြားရသောသူအပေါင်းရို့သည် ယေသျှုကို ယုံကြည်လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","ယေသျှုသည် ယုဒ ယုံကြည်သူရို့အား “သင်ရို့သည် ငါဟောပြောသော သွန်သင်ချက်အတိုင်း နာခံလိုက်လျှောက်လျှင် ငါ့တပည့် အမှန်ဖြစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","သင်ရို့သည် သမ္မာတရားကို သိပြီးလျှင် ထိုသမ္မာတရားက သင်ရို့အား လွတ်မြောက်စီလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","သူရို့က “ငါရို့သည် အာဗြဟံ၏အမျိုး ဖြစ်ကြ၏။ တစ်ခါမျှ သူတစ်ပါး၏ကျွန် မဖြစ်ခဖူးပါ။ ‘သင်ရို့ လွတ်မြောက်လိမ့်မည်’ ဟု ဇာကြောင့် ပြောဆိုသနည်း” ဟု မိန်းလျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ယေသျှုက “သင်ရို့အား ငါအမှန်ဆိုသည်ကား၊ အပြစ်ကို ကျူးလွန်သော သူတိုင်းသည် အပြစ်၏ ကျွန်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ကျွန်သည် မိသားစုဝင် အစဉ်ဖြစ်သည် မဟုတ်၊ သားဖြစ်သူသာလျှင် အစဉ် ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","အကယ်၍ သင်ရို့အား သားတော်က လွတ်မြောက်ခွင့်ပီးလျှင် သင်ရို့သည် အမှန်ပင် လွတ်မြောက်ခြင်း ရကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","သင်ရို့သည် အာဗြဟံ၏အမျိုးဖြစ်ကြောင်း ငါသိ၏။ သို့သော်လည်း သင်ရို့သည် ငါ၏သွန်သင်ချက်ကို လက်ခံလိမ့်မည် မဟုတ်သောကြောင့် ငါ့အား သတ်ရန် ကြိုးစားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ငါသည် ငါ့ခမည်းတော် ဖော်ပြသမျှကိုသာ ငါဟောပြော၏။ သင်ရို့ကား သင်ရို့အဖ ညွှန်ကြားသည့်အတိုင်း ပြုကြ၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","ထိုသူရို့ကလည်း “အာဗြဟံသည် ငါရို့ အဖဖြစ်ပါသည်” ဟု ဆိုကြ၏။ ယေသျှုက “သင်ရို့သည် အာဗြဟံ၏ သားသမီး အစစ်အမှန် ဖြစ်ခသည်ဆိုလျှင် အာဗြဟံကဲ့သို့ ကျင့်ကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ဘုရားသခင်ထံပါးက ကြားနာရသမျှသော သမ္မာတရားကို သင်ရို့အား ဟောပြောသော ငါ့ကို သတ်ရန် သင်ရို့က ကြံစည်နိန်ကြ၏။ အာဗြဟံကား ဤသို့ မကျင့်ခ။ ");
INSERT INTO rki_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","သင်ရို့သည် သင်ရို့အဖ ကျင့်ခသည်အတိုင်း ကျင့်တတ်ကြ၏” ဟု ပြန်၍ မိန့်တော်မူ၏။ ထိုသူရို့ကလည်း၊ “ငါရို့၌ ဘုရားသခင်တည်းဟူသော ခမည်းတော် တစ်ပါးတည်းသာ ဟိ၏။ ငါရို့သည် ထိုဘုရားသခင်၏ စစ်မှန်သော သားသမီးများဖြစ်ကြ၏” ဟု လျှောက်ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ယေသျှုကလည်း “ဘုရားသခင်သည် သင်ရို့၏အဖ ဖြစ်သည်ဆိုလျှင် သင်ရို့သည် ငါ့အား ချစ်ကြလိမ့်မည်။ အကြောင်းမူကား ငါသည် ဘုရားသခင်ထံတော်ပါးမှ လာပြီးလျှင် အဂု ဤနီရာ၌ ရောက်နိန်၏။ ငါသည် ကိုယ့်အခွင့်အာဏာနှင့် လာသည် မဟုတ်။ သို့သော် ဘုရာသခင်သည် ငါ့ကို စီရွှတ်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","သင်ရို့သည် ငါ့စကားကို နားမလည်ကြခြင်းအကြောင်းမှာ ငါ၏တရားကို နာယူနိုင်စွမ်း မဟိသောကြောင့် ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","သင်ရို့သည် သင်ရို့၏အဖဖြစ်သော မာရ်နတ်၏ သားသမီးများ ဖြစ်ကြသောကြောင့် သင်ရို့အဖ၏ အလိုသို့လိုက်၍ လုပ်ဆောင်ကြ၏။ မာရ်နတ်သည် အစဦးကပင် လူသတ်သမား ဖြစ်၏။ ထိုသူသည် သစ္စာတရားမဟိ၊ သမ္မာတရားဖက်၌လည်း မနီ။ ထိုသူသည် မုသာကိုပြောသောအခါ ပင်ကိုယ်ပကတိအတိုင်း မုသာကို ပြောဆိုတတ်၏။ အကြောင်းမူကား လိမ်လည် ပြောဆိုတတ်သူဖြစ်ပြီး မုသာ၏ ဖခင်လည်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ငါသည် မှန်သောစကားကို ပြောသော်လည်း သင်ရို့သည် ငါ့အား မယုံကြည်ကြ။ ");
INSERT INTO rki_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","ငါသည် အပြစ်ဟိကြောင်း ဇာသူက သက်သီ ပြနိုင်မည်နည်း။ ငါသည် မှန်သောစကားကို ပြောသော်လည်း ဇာကြောင့် ငါ့ကို မယုံကြည်ကြသနည်း။ ");
INSERT INTO rki_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ဘုရားသခင်နှင့် စပ်ဆိုင်သူသည် ဘုရားသခင်၏စကားကို နားထောင်တတ်ကြ၏။ သင်ရို့သည် ဘုရားသခင်နှင့် မစပ်ဆိုင်သည့်အတွက် နားမထောင်ကြ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ယုဒလူတိက ယေသျှုအား “သင်သည် ယှာမာရိလူဖြစ်ပြီး နတ်ဆိုး ဝင်ပူးခံရသူလည်း ဖြစ်သည်ဟု ငါရို့ ပြောသည်မှာ မှန်သလော” ဟု မိန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ယေသျှုကလည်း “ငါသည် နတ်ဆိုး ဝင်ပူးခံနိန်သူ မဟုတ်။ ငါသည် ငါ့ခမည်းတော်ကို ချီးမြှောက်၏။ သို့သော်လည်း သင်ရို့က ငါ့ကို ရှုတ်ချကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ငါသည် ကိုယ့်ဘုန်းကို မရှာ။ သို့ရာတွင် ငါ၏ဘုန်းကို ရှာ၍ စီရင်တော်မူသောသူ ဟိသိမ့်၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ငါ အမှန်ဆိုသည်ကား၊ ငါ့စကားကို နားထောင်သောသူသည် သီဆုံးခြင်းနှင့် အစဉ်မပြတ် ကင်းလွတ်လိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","ယုဒလူတိကလည်း၊ “သင်သည် နတ်ဆိုး ပူးနိန်သူဖြစ်ကြောင်း အဂု ငါရို့သိရယာ။ အာဗြဟံလည်း သီလားခယာ။ ပရောဖက်တိလည်း သီလားခယာ။ ယေဒါလည်း ‘ငါ့စကားကို နားထောင်သောသူသည် သီခြင်းနှင့် အစဉ်မပြတ် ကင်းလွတ်လိမ့်မည်’ ဟု ဆိုသည်တကား။ ");
INSERT INTO rki_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","သင်သည် သီလွန်ခသူ ငါရို့အဖ အာဗြဟံထက် ကြီးမြတ်သလော။ ပရောဖက်တိလည်း သီလွန်လားခယာ။ သင့်ကိုယ်သင် ဇာသူဟု ထင်မှတ်နိန်သနည်း” ဟု မိန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ယေသျှုကလည်း “ငါသည် ကိုယ့်ကိုကိုယ် ချီးမြှောက်သည်ဆိုလျှင် ငါ၏ဘုန်းသည် အလာကားပင်ဖြစ်၏။ ငါ့ကို ချီမြှောက်သူကား ငါ့ခမည်းတော်ဖြစ်၏။ ထိုအသျှင်ကို သင်ရို့သည် ငါရို့၏ ဘုရားသခင် ဟု ဆိုတတ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ယေဒါလည်း ထိုဘုရားသခင်ကို သင်ရို့ လုံးဝ မသိကြသော်လည်း ငါမူကား သိ၏။ အကယ်၍ ငါမသိဟု ဆိုလျှင် ငါသည် သင်ရို့ကို လိမ်ပြောသူ ဖြစ်လိမ့်မည်။ ထိုဘုရားသခင်ကို ငါသိ၏။ ဘုရားသခင်၏ စကားကိုလည်း နားထောင်၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","သင်ရို့အဖ အဗြဟံသည် ငါကြွလာမည့် အချိန်ကာလကို မြင်ခြင်းငှာ အလိုဟိ၏။ မြင်ရသောခါ၌လည်း ဝမ်းမြောက်ဝမ်းသာ ဟိ၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ယုဒလူရို့ကလည်း “သင်သည် အသက် ငါးဆယ်ပင် မဟိသိမ့်။ သို့ဖြစ်၍ သင်သည် အာဗြဟံကို မြင်ဖူးသလော” ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","ယေသျှုက “ငါ အမှန်ဆိုသည်ကား၊ အာဗြဟံ မမွီးဖွားခင် ငါဟိ၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ထိုအခါ သူရို့သည် ကိုယ်တော့်အား ပစ်ရန် ကျောက်ခဲများကို ကောက်ယူကြ၏။ သို့သော်လည်း ယေသျှုသည် တိမ်းယှောင်၍ ဗိမာန်တော်မှ ထွက်လားတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ယေသျှုသည် လမ်း၌ကြွတော်မူစဉ် မွီးရာပါ မျက်ကန်းတစ်ယောက်ကို တွိ့မြင်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","တပည့်တော်ရို့က “ဆရာ၊ ဤသူသည် ဇာသူ့အပြစ်ကြောင့် မွီးရာပါ မျက်စိကန်းရသနည်း။ မိမိအပြစ်ကြောင့် ဖြစ်သလော၊ မိဘတိအပြစ်ကြောင့် ဖြစ်သလော” ဟု မိန်းလျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ယေသျှုက “သူ၏ အပြစ်ကြောင့် မဟုတ်၊ မိဘ အပြစ်ကြောင့်လည်း မဟုတ်။ ဤသူ၌ ဖြစ်သောအရာကား ဘုရားသခင်၏ တန်ခိုးတော်ကို ထင်ရှားစီရန် ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ငါ့ကို စီရွှတ်တော်မူသော အသျှင်၏ အမှုတော်မြတ်ကို နိ့အချိန်ဟိစဉ် ငါရို့ လုပ်ဆောင်ရမည်။ တစ်ယောက်လည်း မလုပ်နိုင်သော ညဉ့်အချိန် ရောက်လာလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ငါသည် ဤလောကတွင် ဟိနိန်စဉ် လောက၏ အလင်းဖြစ်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ဤသို့ မိန့်တော်မူပြီးနောက် ကိုယ်တော်သည် မြီကြီးကို တန်းထွီးဖြင့် ထွီးပြီးလျှင် ကျုတ်လုပ်၍၊ သူ၏မျက်စိကို လူးပီးတော်မူပြီး၊ ");
INSERT INTO rki_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","“သျှိလောင်ရီကန်၌ မျက်နှာသစ်ရန် လားလော” ဟု မိန့်တော်မူ၏။ သျှိလောင်၏ အဓိပ္ပာယ်ကား “ရွှတ်လိုက်သည်” ဟု ဆိုလိုသတည်း။ ထိုသူသည် လား၍ မျက်နှာသစ်ပြီးနောက် မျက်စိမြင်လျက် ပြန်လာလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","သူသည် သူတောင်းစားဖြစ်သဖြင့် အယင်က သူ့ကို မြင်ဖူးသောသူများနှင့် အိမ်နီးချင်းများက “ဤသူသည် ထိုင်၍ တောင်းစားနိန်သူ မဟုတ်ပါလား” ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","လူတချို့က၊ “ဤသူ ဟုတ်ပါ၏” ဟူ၍ လည်းကောင်း၊ တချို့က “ဤသူ မဟုတ်၊ သူနှင့် တူ၏” ဟူ၍ လည်းကောင်း ဆိုကြ၏။ သူကိုယ်တိုင်ကလည်း “ငါက ထိုသူပင် ဖြစ်ပါ၏” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ထိုသူရို့က “သင်က ဇာပိုင် မျက်စိမြင်လာသနည်း” ဟု မိန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","သူကလည်း “ယေသျှုဟု ခေါ်သော လူတစ်ယောက်က ကျုတ်တစိတ်ကေလုပ်၍ အကျွန့်မျက်စိကို လူးပြီးလျှင် သျှိလောင်ရီကန်သို့လား၍ အကျွန့်ကို မျက်နှာသစ်ခိုင်းပါ၏။ ထို့ကြောင့် အကျွန်သည် လား၍ မျက်နှာသစ်လိုက်သည့်အခါ မျက်စိမြင်လာပါ၏” ဟု ပြန်ပြော၏။ ");
INSERT INTO rki_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ထိုသူရို့ကလည်း၊ “ထိုသူကား ဇာမှာလဲ” ဟု မိန်းကြလျှင်၊ “အကျွန် မသိပါ” ဟု ပြန်ပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","ထို့နောက် ထိုသူရို့သည်လည်း မျက်စိကန်းသောသူကို ဖာရိယှဲရို့ အပါးသို့ ခေါ်လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ယေသျှုသည် ကျုတ်ဖြင့် မျက်စိမြင်စီသောနိ့ကား ဥပုသ်နိ့ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","ထို့ကြောင့် ဖာရိယှဲရို့သည် ထိုသူ မျက်စိပြန်မြင်လာပုံကို မိန်းမြန်းကြ၏။ ထိုသူက “သူသည် အကျွန့်မျက်စိကို ကျုတ်နှင့် လူးပီးပါ၏။ ပြီးလျှင် မျက်နှာသစ်လိုက်သည့်အခါ မျက်စိပြန်မြင်လာပါ၏” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","တချို့သော ဖာရိယှဲရို့က “ထိုသူသည် ဥပုသ်နိ့ကို မစောင့်သည့်အတွက် ဘုရားသခင်ထံပါးမှ လာသောသူ မဟုတ်” ဟု ပြောဆိုကြ၏။ တချို့က “ဒုစရိုက်ကိုပြုသောသူသည် ဤသို့သော နိမိတ်လက္ခဏာများကို ဇာကြောင့် လုပ်နိုင်ပါသနည်း” ဟု ဆိုကြ၏။ ထိုသို့ သူရို့သည် အချင်းချင်း စိတ်ဝမ်းကွဲပြားလျက် ဟိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ထို့ကြောင့် ဖာရိယှဲရို့က မျက်စိကန်းဖူးသူအား “သင့်ကို မျက်စိမြင်စီသောသူသည် ဇာပိုင်မျိုးလူဖြစ်သနည်း” ဟု မိန်းကြ၏။ ထိုသူက “သူသည် ပရောဖက်ဖြစ်ပါ၏” ဟု ဖြေကြားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","သို့ရာတွင် ယုဒအာဏာပိုင်ရို့က သူသည် အယင်က မျက်စိကန်းသည်ကိုလည်းကောင်း၊ အဂု မျက်စိမြင်လာသည်ကိုလည်းကောင်း မယုံနိုင်သိမ့်သောကြောင့် သူ၏မိဘများကို ခေါ်၍ မိန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ထိုသူရို့ကလည်း “ဤသူသည် သင်ရို့၏ သားဖြစ်သလော၊ သင်ရို့ ပြောသည်အတိုင်း မွီးရာပါ မျက်စိမမြင်သောသူ ဖြစ်သလော။ ထို့ကြောင့် ဤသူသည် ဇာအတွက်ကြောင့် မျက်စိမြင်ရသနည်း” ဟု မိန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","သူ၏မိဘရို့ကလည်း “ဤသူသည် အကျွန်ရို့သား မှန်ပါ၏။ မွီးရာပါ မျက်မမြင်တစ်ယောက်လည်း ဖြစ်ပါ၏။ ");
INSERT INTO rki_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","သို့သော်လည်း ဇာကြောင့် မျက်စိမြင်လာသည်ကိုလည်းကောင်း၊ ဇာသူက မျက်စိမြင်စီသည်ကိုလည်းကောင်း အကျွန်ရို့ မသိပါ။ သူ့ကို မိန်းကြည့်ပါ။ သူသည်လည်း အရွယ်ရောက်သောသူဖြစ်၍ သူ့အကြောင်းကို သူကိုယ်တိုင် ပြောပြနိုင်ပါလိမ့်မည်” ဟု ဖြေကြား၏။ ");
INSERT INTO rki_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","သူ၏မိဘများသည် ဤသို့ ဖြေကြားရခြင်းမှာ ယေသျှုအား မေသျှိယအဖြစ်နှင့် ယုံကြည်ကြောင်း ပြောဆိုသောသူတိုင်းကို တရားဇရပ်မှ နှင်ထုတ်ရန် သဘောတူ ဆုံးဖြတ်ထားသော ယုဒအာဏာပိုင်တိကို ကြောက်သောကြောင့် ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","ထို့ကြောင့် သူ၏မိဘရို့က “သူသည်လည်း အရွယ်ရောက်သောသူဖြစ်၍ သူ့အား မိန်းကြည့်ပါ” ဟု ဆိုခြင်းဖြစ်သည်။ ");
INSERT INTO rki_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","ထိုသူရို့ကလည်း မျက်စိကန်းဖူးသူကို ဒုတိယအကြိမ် ပြန်ခေါ်၍ “ဘုရားသခင်၏ ဘုန်းတော်ရှိ့၌ အမှန်တိုင်းပြောပါ။ သင့်၏မျက်စိကို မြင်စီသူသည် ဒုစရိုက်ကို ပြုသောသူဖြစ်ကြောင်း ငါရို့သိ၏” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","ထိုသူကလည်း၊ “ထိုသူသည် ဒုစရိုက်ကိုပြုသောသူ ဟုတ်သည်၊ မဟုတ်သည်ကို အကျွန်မသိ။ အကျွန်သိသော အရာတစ်ခုမှာ အကျွန်သည် အယင်က မျက်စိကန်း၏။ အဂု မျက်စိမြင်လာသည့် အကြောင်းကိုသာ အကျွန်သိပါ၏” ဟု ပြန်ပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ထိုသူရို့ကလည်း “သူသည် သင့်အား မည်သို့ပြုနည်း။ သင်၏မျက်စိကန်းနိန်သည်ကို ဇာပိုင် ကုသမည်နည်း” ဟု မိန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ထိုသူက “အကျွန်က သင်ရို့ကို တစ်ကြိမ်ပြောပြီးယာ၊ သင်ရို့က နားမထောင်ကြ။ မည်သို့ဖြစ်သည်ကို ထပ်ကာထပ်ကာ ကြားချင်ကြသလော။ သင်ရို့ကလည်း သူ့တပည့် ဖြစ်ချင်ကြသလော” ဟု ပြန်၍ မိန်းလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ထိုသူရို့ကလည်း ထိုသူအား ကြိမ်းမောင်းလျက် “သင်သာလျှင် သူ၏ တပည့်ဖြစ်၏။ ငါရို့မူကား မောသျှေတပည့်တိ ဖြစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","ဘုရားသခင်သည် မောသျှေအား ဗျာဒိတ်ပီးတော်မူခကြောင်းကို ငါရို့ သိကြ၏။ ဤသူသည် ဇာကလာသည်ကိုပင် ငါရို့မသိ” ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ထိုသူက၊ “သူသည် အကျွန့်မျက်စိကန်းနိန်သည်ကို ကုသခသောသူ ဖြစ်၏။ သို့သော်လည်း သင်ရို့က သူသည် ဇာကလာကြောင်းကို မသိသည်ကား အံ့သြဖို့ ကောင်းပါ၏။ ");
INSERT INTO rki_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ဘုရားသခင်သည် အပြစ်သားတိ ဆုတောင်းသည်ကို နားညောင်းတော်မမူပါ။ ဘုရားသခင်အား ရိုသီလေးမြတ်၍ အလိုတော်အတိုင်း လုပ်ဆောင်နိန်သောသူရို့၏ ဆုတောင်းခြင်းကို နားညောင်းတော်မူသည်ကို အကျွန်ရို့ သိပါ၏။ ");
INSERT INTO rki_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","မွီးရာပါ မျက်စိကန်းသူအား မျက်စိပြန်မြင်စီနိုင်သည်ကို ရှီးကာလမှစ၍ တစ်ခါလေ့ မကြားဖူးသိမ့်။ ");
INSERT INTO rki_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","ဤသူသည် ဘုရားသခင်ထံတော်မှ ကြွလာသူ မဟုတ်လျှင် ဤသို့သောအမှုကိုလည်း မတတ်နိုင်ပါ” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","ထိုသူရို့ကလည်း “သင်သည် မွီးရာပါအပြစ်နှင့် ကြီးပြင်းလာသူ ဖြစ်လျက်ပင် — ငါရို့ကို ဆုံးမခြင်းငှာ ကြိုးစားနိန်ပါသည်တကား” ဟု ဆို၍ တရားဇရပ်မှ နှင်ထုတ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","ဤသို့ နှင်ထုတ်သည်အကြောင်းကို ယေသျှုသည် ကြားတော်မူပြီးမှ ထိုသူ့ကို တွိ့တော်မူလျှင်၊ “သင်သည် လူသားကို ယုံကြည်သလော” ဟု မိန်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ထိုသူကလည်း “ဆရာ၊ အကျွန် ယုံကြည်နိုင်ရန်အတွက် လူသားကား ဇာသူဖြစ်ကြောင်း အကျွန့်ကို ပြောပြပါ” ဟု လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ယေသျှုက “သူ့ကို သင်မြင်ဖူး၏။ ထိုသူကား သင်နှင့် အဂု စကားပြောနိန်သူပင်ဖြစ်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","ထိုသူကလည်း “ယုံကြည်ပါ၏ အသျှင်” ဟု လျှောက်၍ ယေသျှုအား ပျပ်ဝပ်ကိုးကွယ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","ယေသျှုက “မျက်စိကန်းနိန်သောသူသည် မျက်စိမြင်စီပြီးလျှင် မြင်သောသူတိ မျက်စိကန်းစီရန် ငါသည် ဤလောကသို့ တရားစီရင်ခြင်းငှာ ကြွလာခြင်းဖြစ်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ကိုယ်တော်နှင့်အတူ ဟိနိန်သော ဖာရိယှဲတချို့သည် စကားတော်ကို ကြားရသဖြင့် “ငါရို့ကလည်း မျက်စိကန်းနိန်သောသူတိ ဖြစ်ကြသည်ဟု ဆိုလိုသလော” ဟု ပြောဆိုမိန်းမြန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ယေသျှုက “သင်ရို့သည် မျက်စိကန်းသောသူရို့ ဖြစ်သည်ဟုဆိုလျှင် အပြစ်ဟိသည် မဟုတ်။ အဂုကား သင်ရို့က ‘ငါရို့ မျက်စိမြင်ပါ၏’ ဟု ဆိုသည့်အတွက်ကြောင့် သင်ရို့၌ အပြစ်၌ ဟိနိန်တုန်းပင်ဖြစ်သည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ယေသျှုက “ငါအမှန် ဆိုသည်ကား၊ သိုးခြံထဲသို့ တန်းခါးပေါက်မှ မဝင်ဘဲ အခြားသောလမ်းဖြင့် ကျော်ဝင်သောသူသည် သူခိုးဒါးပြ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","တန်းခါးပေါက်မှ ဝင်သောသူကား သိုးထိန်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ထိုသူအား တန်းခါးစောင့်သည် တန်းခါးကို ဖွင့်ပီး၏။ သိုးများသည် သူ့အသံကို နားထောင်တတ်ကြ၏။ သူသည် မိမိ၏သိုးများကို နာမည်ခေါ်၍ သိုးခြံမှ ထုတ်ပြီးလျှင် သိုးများကို ဦးဆောင်လားတတ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","သိုးအားလုံးကို ထုတ်၍ ရှိ့ကနိန် ဦးဆောင်လားတတ်၏။ သိုးများသည်လည်း သူ၏အသံကို သိသောကြောင့် နောက်သို့လိုက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","သိုးများသည် အခြားသောသူ၏နောက်သို့ မလိုက်တတ်ဘဲ အခြားသောသူ၏အသံကို မသိသောကြောင့် ထိုသူ့ထံပါးမှ ထွက်ဗြီးလားကြလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ယေသျှုသည် ဤပုံဥပမာကိုဆောင်၍ ထိုသူရို့အား မိန့်တော်မူသော်လည်း သူရို့သည် အနက်အဓိပ္ပာယ်ကို နားမလည်ကြ။ ");
INSERT INTO rki_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","တဖန် ယေသျှုက၊ “ငါအမှန် ဆိုသည်ကား၊ ငါသည် သိုးဝင်သော တန်းခါးဝဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ငါမတိုင်မှီ ရောက်လာသော အခြားသောသူရို့သည် သူခိုးဒါးပြတိ ဖြစ်ကြ၏။ ယေဒါလည်း သိုးသည် ထိုသူရို့စကားကို နားမထောင်ကြ။ ");
INSERT INTO rki_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","ငါသည် တန်းခါးဝဖြစ်၏။ ငါ့အားဖြင့် ဝင်သောသူသည် ဘေးကင်းစွာ ဝင်ထွက်လားလာ၍ စားကျက်ကို တွိ့ရလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","သူခိုးသည် ခိုးခြင်း၊ သတ်ခြင်းနှင့် ဖျက်ဆီးခြင်းငှာ လာ၏။ ငါမူကား သိုးတိကို အသက်ရှင်စီရုံသာမက ကြွယ်ဝပြည့်စုံသောအသက်နှင့် ရှင်သန်နိုင်ကြစီရန် လာခြင်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“ငါသည် ကောင်းသော သိုးထိန်းဖြစ်၏။ ကောင်းသော သိုးထိန်းသည် သိုးတိအတွက် မိမိအသက်ကို စွန့်တတ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","အငှားသမားမူကား သိုးထိန်း မဟုတ်။ သိုးသျှင်လည်း မဟုတ်။ တောခွီး လာသည်ကို မြင်သောအခါ သိုးတိကိုထား၍ ထွက်ဗြီးလားတတ်၏။ တောခွီးကလည်း သိုးတိကို ကိုက်ဖမ်းသောကြောင့် သိုးများသည် ဖရိုဖရဲ ကွဲလွင့်စီ၏။ ");
INSERT INTO rki_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","အငှားသမားသည် အငှားသမားဖြစ်သောကြောင့် သိုးတိကို ဂရုမစိုက်ဘဲ ထွက်ဗြီးတတ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","ငါသည် ကောင်းသောသိုးထိန်း ဖြစ်၏။ ခမည်းတော်သည် ငါ့ကို သိတော်မူ၍၊ ငါသည်လည်း ခမည်းတော်ကို သိသကဲ့သို့ ငါ၏သိုးတိကို ငါသိ၏။ ငါ့သိုးတိကလည်း ငါ့ကိုသိကြ၏။ ငါသည် သိုးတိအတွက် အသက်ကိုစွန့်၏။ ");
INSERT INTO rki_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ဤသိုးခြံထဲသို့ မဝင်သော အခြားသိုးတိကိုလည်း ငါပိုင်သိမ့်၏။ ထိုသိုးတိကို ငါ ယူဆောင်ခရမည်။ သူရို့သည် ငါ့အသံကို နားထောင်ကြလိမ့်မည်။ ထို့ကြောင့် သူရို့သည် သိုးထိန်းတစ်ပါးတည်းဟိသော သိုးအုပ်တစ်အုပ် ဖြစ်လာလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“ငါသည် ကိုယ့်အသက်ကို အလိုလျောက် စွန့်တော်မူသည့်အတိုင်း နောက်တဖန် အသက်ကို ပြန်ယူဦးမည် ဖြစ်သောကြောင့်၊ ခမည်းတော်သည် ငါ့ကို ချစ်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","ဇာသူတစ်ယောက်မှ ငါ့ပါးမှ အသက်ကို မလုယူနိုင်။ ကိုယ့်အလိုအလျောက် စွန့်ခြင်းသာဖြစ်၏။ ငါသည် အသက်ကို စွန့်ပိုင်ခွင့်နှင့် ပြန်ယူပိုင်ခွင့် ငါ့၌ ဟိ၏။ ဤသို့ ပြုနိုင်ရန် ခမည်းတော်သည် ငါ့ကို အမိန့်ပီးတော်မူ၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","ထိုစကားတော်ကြောင့် ယုဒလူရို့သည် တဖန် ကွဲပြားကြပြန်၏။ ");
INSERT INTO rki_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","သူရို့ထဲမှ လူအများက “ဤသူသည် နတ်ဆိုး ဝင်ပူးနိန်သော အရူးဖြစ်၏။ ဇာကြောင့် သူ့စကားကို သင်ရို့ နားထောင်ကြသနည်း” ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","သို့ရာတွင် အခြားသူရို့က “နတ်ဆိုးဝင်ပူးသောလူသည် ဤသို့သော စကားကိုမပြောနိုင်။ နတ်ဆိုးသည် မျက်စိကန်းသောသူတိကို မြင်စီခြင်းငှာ တတ်နိုင်ပါမည်လော” ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","ဆောင်းကာလဖြစ်၍ ယေရုဆလင်မြို့တွင် ဗိမာန်တော်အား ဆက်ကပ်သည့်ပွဲတော် ကျရောက်လျက်ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ယေသျှုသည် ဗိမာန်တော်၌ဟိသော သျှောလမုန်ဆင်ဝင်တွင် စင်္ကြန်ကြွနိန်၏။ ");
INSERT INTO rki_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ထိုအခါ ယုဒလူရို့သည် ကိုယ်တော့်ကို ဝိုင်းရံလျက် “သင်သည် ဇာလောက်ကြာအောင် ငါရို့၏ စိတ်နှလုံးကို ဒွိဟ ဖြစ်စီမည်နည်း။ မေသျှိယ ဖြစ်သည်ဆိုလျှင် အတိအလင်း ပြောပြပါ” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ယေသျှုက “သင်ရို့ကို ငါပြောပြီးယာ။ ယေဒါလည်း သင်ရို့က မယုံကြ။ ငါ့ခမည်းတော်အခွင့်နှင့် ငါပြုသော အမှုများသည် ငါ့အကြောင်းကို သက်သီခံနိန်ကြခြင်း ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","သို့ရာတွင် သင်ရို့သည် ငါ့သိုးမဟုတ်သောကြောင့် ငါ့ကို မယုံနိုင်ကြ။ ");
INSERT INTO rki_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","ငါ့သိုးရို့သည် ငါ့စကားကို နားထောင်တတ်ကြ၏။ ငါသည် သူရို့ကို သိသည်ဖြစ်၍ သူရို့လည်း ငါ့နောက်သို့ လိုက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ငါသည် သူရို့အား ထာဝရအသက်ကို ပီးသည်ဖြစ်၍ သူရို့သည် သီခြင်းနှင့် အစဉ်မပြတ် ကင်းလွတ်လိမ့်မည်။ ဇာသူတစ်ယောက်မှ သူရို့တိကို ငါ့လက်ကနိန် လုမယူနိုင်။ ");
INSERT INTO rki_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ထိုသိုးတိကို ငါ့ထံ၌ အပ်ပီးတော်မူသည့် ခမည်းတော်သည် ဟိသမျှသော သူတိထက် ကြီးမြတ်တော်မူသည်ဖြစ်၍၊ ဇာသူတစ်ယောက်မှ သိုးတိကို ခမည်းတော်လက်က မလုမယူနိုင်။ ");
INSERT INTO rki_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ခမည်းတော်နှင့် ငါသည် တစ်လုံးတစ်ဝတည်း ဖြစ်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ထိုအခါ ယုဒလူအပေါင်းရို့သည် ကိုယ်တော့်ကို ပစ်ရန် ကျောက်ခဲကို တဖန် ကောက်ယူကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ယေသျှုက “ခမည်းတော် စီခိုင်းတော်မူသဖြင့် ငါသည် များစွာသော ကောင်းမြတ်သောအမှုတိကို ပြခယာ။ ထိုအမှုတိထဲက ဇာအမှုအတွက်ကြောင့် သင်ရို့က ငါ့ကို ကျောက်ခဲနှင့်ပစ်ရန် လုပ်ကြသနည်း” ဟု မိန်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","ယုဒလူတိကလည်း “ကောင်းမြတ်သောအမှုတိကို ပြခသည့်အတွက်ကြောင့် သင့်ကို ကျောက်ခဲနှင့်ပစ်ရန် လုပ်ကြသည် မဟုတ်။ သင်သည် လူစင်စစ်ဖြစ်လျက်ပင် ဘုရားအယောင်ဆောင်၍ ဘုရားသခင်ကို ပြစ်မှားသော စကားကြောင့် ကျောက်ခဲနှင့်ပစ်ရန် လုပ်ကြခြင်း ဖြစ်သည်” ဟု ပြန်ပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ယေသျှုက “သင်ရို့၏ ပညတ်ကျမ်းထဲ၌ ဘုရားသခင်က ‘သင်ရို့သည် ဘုရားများ ဖြစ်ကြ၏’ ဟု ဖော်ပြထား၏။ ");
INSERT INTO rki_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","ထိုကျမ်းစာ၌ ဖော်ပြထားသည့်အရာများ အမြဲမှန်ကန်ကြောင်းကို သင်ရို့ သိကြ၏။ ဘုရားသခင်၏ ဗျာဒိတ်တော် ခံရသော လူတိကို ‘ဘုရားများ’ ဟု ဖော်ပြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ခမည်းတော်သည် ငါ့ကို ရွီးချယ်၍ ဤလောကသို့ စီရွှတ်တော်မူ၏။ ထို့အတွက်ကြောင့် ‘ငါသည် ဘုရားသခင်၏ သားတော်ဖြစ်၏’ ဟု ဆိုသည်ကား ဘုရားသခင်ကို ပြစ်မှားသောစကားဟု ဇာကြောင့် သင်ရို့ ဆိုကြသနည်း။ ");
INSERT INTO rki_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ငါ့ခမည်းတော်၏ အလိုတော်အတိုင်း ငါ မဆောင်ရွက်လျှင် ငါ့ကို မယုံကတ်ကေ့။ ");
INSERT INTO rki_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","ဆောင်ရွက်ခလျှင်မူကား ငါ့ကို မယုံသော်လည်း ငါဆောင်ရွက်ခသော အမှုတိကို ယုံကြလော့။ ထိုသို့ယုံလျှင် ခမည်းတော်သည် ငါ့အထဲ၌ ဟိတော်မူသကဲ့သို့၊ ငါလည်း ခမည်းတော်အထဲ၌ ဟိနိန်သည်ကို သင်ရို့ သိနားလည်ကြလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ထိုအခါ သူရို့သည် ယေသျှုကို ဖမ်းဆီးရန် ကြိုးစားကြပြန်၏။ သို့ရာတွင် ကိုယ်တော်သည် သူရို့လက်မှ လွတ်မြောက်၍ ထွက်ကြွတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ထို့နောက် ယေသျှုသည် ယော်ဒန်မြစ် တစ်ကမ်း၌ဟိသော အယင်က ယောဟန်သည် ဗတ္တိဇံမင်္ဂလာ ပီးရာအရပ်သို့ ပြန်လည် ကြွလားတော်မူ၍ ထိုအရပ်တွင် နီတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","သူရို့က “ယောဟန်သည် အံ့ဖွယ်နိမိတ်လက္ခဏာ ဇာတစ်ခုကိုမှ မပြခသော်လည်း ဤသူအကြောင်းနှင့်ပတ်သတ်၍ ယောဟန်ပြောခသည်မှာ အားလုံးမှန်သည်” ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","သို့ဖြစ်၍ ထိုအရပ်၌ဟိသော များစွာသောလူရို့သည် ယေသျှုကို ယုံကြည်လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","မာရိနှင့် သူမ၏ ညီမဖြစ်သူ မာသရို့ နီထိုင်ကြသော ဗေသနိရွာတွင် လာဇရုဆိုသူ လူတစ်ယောက်သည် ဖျားနာလျက်ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ထိုမာရိကား သခင်ဘုရား၏ ခြီတော်ထက်မာ ဆီမွှီးလောင်း၍ မိမိ၏ဆံပင်နှင့် သုတ်ပီးသူဖြစ်၏။ ဖျားနာနိန်သော လာဇရုသည် သူမ၏မောင် ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ညီအစ်မနှစ်ယောက်ရို့က “အသျှင်၊ အသျှင်ချစ်တော်မူသောသူသည် ဖျားနာနိန်ပါ၏” ဟု ယေသျှုထံတော်သို့ သတင်းပို့လိုက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ထိုသတင်းကို ယေသျှုကြားတော်မူလျှင် “လာဇရု၏ ဖျားနာခြင်းသည် သီနာ မဟုတ်။ ဘုရားသခင်၏ဘုန်းတော် ထင်ရှားရန် ဖြစ်၏။ ထိုဖျားနာခြင်းကြောင့် ဘုရားသခင်၏ သားတော်သည် ဘုန်းတော်ထင်ရှား လိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","ယေသျှုသည် မာသ၊ သူမ၏အစ်မနှင့် လာဇရုရို့ကို ချစ်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","လာဇရု ဖျားနာနိန်ကြောင်းကို ကိုယ်တော်သည် ကြားတော်မူလျှင်၊ ကိုယ်တော်သည် မိမိရောက်ရာ အရပ်တွင် နှစ်ရက် ဆက်၍ နီတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ထို့နောက် တပည့်တော်ရို့အား “ယုဒပြည်သို့ ပြန်လားကြမည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","တပည့်တော်ရို့ကလည်း “ဆရာ၊ ယုဒလူတိက ဆရာကို မကြာသိမ့်သောအချိန်က ကျောက်ခဲနှင့် ပစ်ခြင်းငှာ အကြံဟိကြသည်ဖြစ်၍ ထိုအရပ်သို့ ပြန်ကြွဦးမည်လော” ဟု မိန်းလျှောက်ကြလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ယေသျှုက “တစ်နိ့တွင် တစ်ဆယ့်နှစ်နာရီ ဟိသည် မဟုတ်လော၊ ဇာသူမဆို လောက၌ နိ့အချိန်တွင် အလင်းရောင်ကို မြင်ရသောကြောင့် ခလုတ်မတိုက်ဘဲ ကောင်းမွန်စွာ လားလာနိုင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","သို့သော်လည်း ညအချိန်၌ကား အလင်းရောင် မဟိသောကြောင့် လားလာကြသော လူတိသည် ခလုတ်တိုက်ပြီး လဲတတ်ကြ၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ကိုယ်တော်သည် ထိုသို့ မိန့်တော်မူပြီးနောက် “ငါရို့အဆွီ လာဇရုသည် အိပ်နိန်ခြင်းသာဖြစ်၍ သူ့ကို နှိုးခြင်းငှာ လားကြမည်” ဟု ထပ်၍ မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","တပည့်တော်ရို့က “အသျှင်၊ သူသည် အိပ်ပျော်နိန်သည်ဆိုလျှင် ကျန်းမာလာပါလိမ့်မည်” ဟု လျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ယေသျှုကလည်း၊ လာဇရုသီဆုံးကြောင်းကို ရည်ရွယ်၍ မိန့်တော်မူသော်လည်း သာမန် အိပ်ပျော်ကြောင်းကို ဆိုလိုသည်ဟု တပည့်တော်ရို့က ထင်မှတ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","ထို့ကြောင့် ယေသျှုသည်၊ “လာဇရုက သီလားခယာ။ ");
INSERT INTO rki_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ထိုအရပ်၌ ငါမဟိသည်ကို ထောက်၍ သင်ရို့အတွက် ငါ ဝမ်းမြောက်ခြင်း ဟိ၏။ ထို့ကြောင့် သူရို့ ယုံကြည်လာလိမ့်မည်။ သူ့ပါးသို့ လားကြကုန်အံ့” ဟု ပွင့်လင်းစွာ မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","(အမြွှာပူးဟု ခေါ်သော) သောမက “အကျွန်ရို့လည်း ဆရာနှင့်အတူ အသီခံဖို့ လိုက်လားကြမည်” ဟု မိမိ၏ အပေါင်းအဖော်ဖြစ်သော တပည့်တော်ရို့အား ပြောဆို၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","ယေသျှုသည် ရောက်တော်မူသောအခါ လာဇရုအား သဂြိုဟ်ခသည်မှာ လေးရက် ကြာပြီဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ဗေသနိရွာသည် ယေရုဆလင်မြို့နှင့် နှစ်မိုင်ခန့်သာ ဝီးသည်ဖြစ်၍၊ ");
INSERT INTO rki_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ယုဒလူရို့သည် မာရိနှင့် မာသရို့၏မောင် သီဆုံး၍ သူရို့ကို နှစ်သိမ့်ပီးရန် လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","ယေသျှုလာသည်ကို မာသသည် ကြားလျှင် ကိုယ်တော့်ကို ခရီးဦးကြိုပြုရန် ထွက်လားသော်လည်း မာရိကား အိမ်တွင် ကျန်ခ၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","မာသက ယေသျှုအား၊ “အသျှင်၊ အသျှင်သာ ဤနီရာ၌ ဟိမည်ဆိုလျှင် အကျွန့်မောင် သီဆုံးလိမ့်မည် မဟုတ်ပါ။ ");
INSERT INTO rki_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","ယေဒါလည်း အဂုပင်လျှင် အသျှင် တောင်းသမျှအရာတိအား ဘုရားသခင်က ပီးမည်ဆိုသည်ကို အကျွန်သိပါ၏” ဟု လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ယေသျှုကလည်း “သင်၏မောင်သည် အသက်ပြန်ရှင်လိမ့်မည်” ဟု သူမအား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","မာသက “နောက်ဆုံးနိ့ဖြစ်သော ထမြောက်ရာကာလ၌ သူသည် ထမြောက်လိမ့်မည်ဆိုသည်ကို အကျွန်သိပါ၏” ဟု ပြန်လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ယေသျှုကလည်း “ငါသည် ထမြောက်ခြင်းနှင့် အသက်ရှင်ခြင်း ဖြစ်၏။ ငါ့ကို ယုံကြည်သောသူသည် သီလွန်သော်လည်း အသက်ရှင်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ငါ့ကို ယုံကြည်ပြီး အသက်ရှင်နိန်သည့် လူတိလည်း သီခြင်းတရားနှင့် အစဉ်မပြတ် ကင်းလွတ်လိမ့်မည်။ ငါစကားကို ယုံသလော” ဟု မိန်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","မာသက၊ “ယုံပါ၏ အသျှင်။ အသျှင်သည် ဤလောကသို့ ကြွလာသော ဘုရားသခင်၏သားတော် မေသျှိယ ဖြစ်တော်မူကြောင်းကို အကျွန် ယုံပါ၏” ဟု လျှောက်၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ထိုသို့ လျှောက်ထားပြီးနောက် မာသသည် အိမ်သို့ပြန်၍ သူမ၏အစ်မ မာရိအား တိုးတိတ်စွာခေါ်၍ “ဆရာ ရောက်လာတော်မူယာ။ သင့်ကို မိန်းနိန်၏” ဟု ပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","မာရိသည် ထိုစကားကြားလျှင် အယင် ထပြီးလျှင် ကိုယ်တော်ပါးသို့ လားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ယေသျှုသည် ရွာထဲကို မဝင်ရသိမ့်။ မာသ ခရီးဦးကြိုပြုသော အရပ်တွင်သာ ဟိသိမ့်၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","မာရိအား နှစ်သိမ့်ခြင်းငှာ အိမ်သို့ ရောက်နိန်ကြသော ယုဒလူရို့သည် မာရိ အလျင်အမြန် ထလားသည်ကို မြင်လျှင် ငိုကြွီးရန် သင်္ချိုင်းသို့ လားသည်ဟု ထင်မှတ်ကြ၏။ သူရို့သည်လည်း မာရိနောက်သို့ လိုက်လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","မာရိသည် ယေသျှုဟိရာအရပ်သို့ ရောက်သောအခါ ကိုယ်တော့်ကို မြင်သဖြင့် ရှိ့တော်၌ ပျပ်ဝပ်လျက် “အသျှင်၊ အသျှင်သာ ဤအရပ်၌ ဟိတော်မူခလျှင် အကျွန့်မောင် သီရမည် မဟုတ်ပါ” ဟု လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","မာရိမှစ၍ သူမနှင့်အတူ လိုက်လာကြသော ယုဒလူအားလုံး ငိုကြွီးနိန်သည်ကို ယေသျှုသည် မြင်တော်မူလျှင် စိတ်တော်အလွန်ညှိုးငယ်၍ စိတ်မချမ်းမသာ ဖြစ်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ကိုယ်တော်က “သူ့အလောင်းကို ဇာမှာ သင်္ဂြိုဟ်ကြသနည်း” ဟု မိန်းတော်မူလျှင်၊ ထိုသူရို့က၊ “အသျှင်၊ လာ၍ ကြည့်တော်မူပါ” ဟု လျှောက်ထားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ယေသျှုသည် မျက်ရည်ကျတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ယုဒလူအပေါင်းရို့က “ဤသူသည် လာဇရုကို ဇာလောက် ချစ်သည်ကို ကြည့်ကတ်ပါ” ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","တချို့သော သူရို့က “မျက်ကန်းတိကို မျက်စိပြန်မြင်စီသောသူသည် လာဇရုကို မသီစီခြင်းငှာ မတတ်နိုင်လား” ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ယေသျှုသည် စိတ်နှလုံး အလွန်ညှိုးငယ်၍ သင်္ချိုင်းဂူသို့ ကြွတော်မူ၏။ ထိုသင်္ချိုင်းဂူ အပေါက်ဝကိုလည်း ကျောက်တုံးဖြင့် ပိတ်ထား၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","ယေသျှုကလည်း “ကျောက်တုံးကို ဖယ်လိုက်ကြ” ဟု အမိန့်ပီးတော်မူ၏။ သီဆုံးသူ၏ အစ်မဖြစ်သော မာသက “အသျှင်၊ သင်္ဂြိုဟ်ထားသည်မှာ လေးရက်ဟိနီပြီဖြစ်၍ အနံ့ထွက်နိန်ဖို့ယာ” ဟု လျှောက်၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","ယေသျှုကလည်း “သင်ယုံကြည်လျှင် ဘုရားသခင်၏ ဘုန်းတန်ခိုးတော်ကို မြင်ရလိမ့်မည်၊ ငါပြောထားသည် မဟုတ်လော” ဟု သူမအား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","သူရို့သည် ကျောက်တုံးကို ဖယ်လိုက်ကြ၏။ ယေသျှုသည် အထက်သို့ မျှော်ကြည့်တော်မူပြီးလျှင် “အဘ၊ ကိုယ်တော်သည် အကျွန့်စကားကို နားညောင်းတော်သောကြောင့် ကျေးဇူးတော်ကြီးမားလှပါ၏၊ ");
INSERT INTO rki_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ကိုယ်တော်သည် အကျွန့်စကားကို အစဉ်အမြဲ နားညောင်းတော်မူကြောင်းကို အကျွန်သိပါ၏။ သို့ရာတွင် ကိုယ်တော်သည် အကျွန့်ကို စီရွှတ်တော်မူကြောင်း၊ ဤလူအပေါင်းရို့ ယုံကြည်ကြရန် သူရို့အကျိုးကို ထောက်၍ လျှောက်ပါ၏” ဟု မြွက်ဆိုတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ထိုသို့မိန့်တော်မူပြီးနောက် ကိုယ်တော်က “လာဇရု ထွက်လာလော့” ဟု ကျယ်သောအသံနှင့် ဟစ်ခေါ်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ထိုအခါ သီလွန်သောသူသည် အသုဘအဝတ်ဖြင့် ခြီနှင့် လက်တိကို ရစ်ပတ်ထားပြီး၊ မျက်နှာ၌ အဝတ်ဖြင့် ပတ်ထားလျက် ထွက်လာလေ၏။ ယေသျှုကလည်း “သူ့ကို ဖြီပီး၍ လားခွင့်ပြုကြလော့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","ထိုအခါ မာရိပါးသို့ လာလည်ကြသော ယုဒလူအပေါင်းရို့သည် ယေသျှု ပြုတော်မူသောအမှုကို တွိ့မြင်ကြသဖြင့် ကိုယ်တော့်ကို ယုံကြည်လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","သို့ရာတွင် လူတချို့သည် ဖာရိယှဲရို့ပါးသို့လား၍ ယေသျှု ပြုတော်မူသည့်အကြောင်းကို ပြောပြကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","သို့ဖြစ်၍ ဖာရိယှဲရို့နှင့် ယဇ်ပုရောဟိတ် အကြီးအကဲရို့သည် ယုဒလွှတ်အရာဟိတိကို စည်းဝေးစီ၍ “ဤသူသည် အံဖွယ်နိမိတ်လက္ခဏာတိကို ပြနိန်၏။ ငါရို့ ဇာပိုင် လုပ်ကြရမည်နည်း။ ");
INSERT INTO rki_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","သူ့ကို ဤသို့ ခွင့်ပြုထားလျှင် လူတိုင်းက သူ့ကို ယုံကြည်လာကြလိမ့်မည်။ ရောမ အာဏာပိုင်တိကလည်း လာပြီးလျှင် ငါရို့ ဗိမာန်တော်နှင့် ငါရို့ လူမျိုးတိကို ဖျက်ဆီးပစ်ပါလိမ့်မည်” ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","သူရို့ထဲမှ ထိုနှစ်အတွက် ယဇ်ပုရောဟိတ်မင်းဖြစ်သော ကယာဖဆိုသူက “သင်ရို့သည် ဇာကြောင့် ပညာကန်းနိန်ကြသနည်း၊ ");
INSERT INTO rki_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ယုဒတစ်မျိုးသားလုံး ပျက်စီးရသည်ထက်၊ လူအားလုံးအတွက် လူတစ်ယောက် သီရသည်ကား သာ၍ကောင်းသည်ကို မသိကြသလော” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ထိုသို့ဆိုရာ၌ မိမိကိုယ်ပိုင်ဉာဏ်ဖြင့် ဆိုသည် မဟုတ်။ ပရောဖက်ဉာဏ်ဖြင့် ထိုနှစ်အတွက် ယဇ်ပုရောဟိတ်မင်းဖြစ်လျက် ယေသျှုသည် ယုဒတစ်မျိုးသားလုံးအတွက် သီရမည် ဟူ၍လည်းကောင်း၊ ");
INSERT INTO rki_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ယုဒလူမျိုးတိအတွက်သာမက ကွဲလွင့်နိန်သော ဘုရားသခင်၏ လူမျိုးတော်များကို တစ်စုတစ်လုံးတည်း ဖြစ်စီရန် အသီခံရမည် ဟူ၍လည်းကောင်း ကြိုတင် ဟောကြားခြင်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","ထိုနိ့မှစ၍ ယုဒအာဏာပိုင်ရို့သည် ယေသျှုကိုသတ်ရန် စီစဉ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ထို့ကြောင့် ယေသျှုသည် ယုဒပြည်တွင် ထင်ရှားစွာ လားလာခြင်းကို မပြုလီယာ။ သို့ရာတွင် ထိုအရပ်မှ ထွက်ခွါတော်မူ၍ တောကန္တာရအနား၊ ဧဖရိမ်အမည်ဟိသော မြို့သို့ ကြွတော်မူပြီးလျှင် တပည့်တော်ရို့နှင့်အတူ နီတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","ပသခါပွဲတော်အခါ နီးလာပြီဖြစ်၍ အရပ်ရပ်မှ များစွာသော ယုဒလူရို့သည် မိမိရို့အား သန့်ယှင်းစင်ကြယ်စီရန် ပွဲတော်အခါမစခင် ယေရုဆလင်မြို့သို့ လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ထိုသူရို့သည် ယေသျှုကိုရှာလျက် ဗိမာန်တော်တွင် စုရုံးလာကြသောအခါ “သူသည် ဤပွဲတော်ကို မလာမည်မှာ သေချာသလား။ သင်ရို့ မည်သို့ ထင်ကြသနည်း” ဟု အချင်းချင်း မိန်းမြန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ယဇ်ပုရောဟိတ်အကြီးအကဲရို့နှင့် ဖာရိယှဲရို့က ဇာသူမဆို ယေသျှုဟိသော အရပ်ကိုသိလျှင် သူရို့သည် ကိုယ်တော့်ကို ဖမ်းဆီးနိုင်ရန် အကြောင်းကြားရမည်ဟု အမိန့်ထုတ်ထားပြီး ဖြစ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","ယေသျှုသည် ပသခါပွဲတော် အခါမကျမီ ခြောက်ရက်အလို၌ သီပြီးမှပြန်၍ အသက်ရှင်လာသူ၊ ဗေသနိရွာ၌ဟိသော လာဇရုနီထိုင်ရာ အိမ်သို့ ကြွတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ကိုယ်တော့်ကို ညစာဖြင့် ဧည့်ခံရာ၌ မာသသည် အာဂန္တုဝတ်ကို ပြုလေ၏။ ယေသျှုနှင့်အတူ စားပွဲ၌ လျောင်းနိန်သော သူရို့ထဲတွင် လာဇရုလည်းပါ၏။ ");
INSERT INTO rki_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","ထိုအခါ မာရိသည် အလွန်တန်ဖိုးကြီးသော နာဒုဆီမွှီးစစ်စစ် နှစ်ဆယ်ကျပ်သားကို ယူ၍ ယေသျှု၏ ခြီတော်ကို လောင်းချပြီးနောက် မိမိဆံပင်ဖြင့် သုတ်လေ၏။ ဆီမွှီး၏အနံ့သည် တစ်အိမ်လုံးကို မွှီးကြိုင်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ယေသျှု၏ တပည့်တော်တစ်ဦးဖြစ်ပြီး ကိုယ်တော့်ကို အပ်နှံမည့်သူ ယုဒသျှာကာရုတ်က၊ ");
INSERT INTO rki_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“ဤဆီမွှီးကို ငွီဒင်္ဂါး ၃၀၀ နှင့်ရောင်း၍ ဆင်းရဲသားရို့အား ဇာကြောင့် မပီးသနည်း” ဟု ဆို၏။ ထိုငွီဒင်္ဂါး ၃၀၀ သည် လူတစ်ယောက်၏ တစ်နှစ်စာ လုပ်အားခနှင့် ညီမျှ၏။ ");
INSERT INTO rki_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ဤသို့ ပြောဆိုရာ၌ သူသည် ဆင်းရဲသားရို့အား ကြင်နာထောက်ထား၍ မဟုတ်၊ သူသည် ခိုးတတ်သောသူ ဖြစ်သောကြောင့် ဖြစ်သည်။ သူသည် ဖဲသာအိတ်ကို လွယ်ရသူဖြစ်ပြီး ဖဲသာများကို ကိုယ့်အဖို့ နှိုက်ယူ သုံးစွဲလေ့ ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","ယေသျှုကလည်း “ထိုမိန်းမကို မနှောက်ယှက်ကေ့။ သူမသည် ငါ့အလောင်းကို သင်္ဂြိုဟ်ခြင်းငှာ ပျင်ဆင်ရသော နိ့အတွက် ဤဆီမွှီးကို သိမ်းထားပါစီ။ ");
INSERT INTO rki_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","ဆင်းရဲသားရို့ကား သင်ရို့နှင့်အတူ အစဉ်အမြဲ ဟိနိန်ကြ၏။ သို့သော်လည်း သင်ရို့မူကား ငါနှင့် အစဉ်အမြဲ ဟိလိမ့်မည် မဟုတ်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","ဗေသနိရွာ၌ ယေသျှု ဟိတော်မူကြောင်းကို ကြားလျှင် များစွာသော ယုဒလူရို့သည် ထိုရွာသို့ ရောက်လာကြ၏။ သူရို့သည် ယေသျှုကြောင့်သာ လာကြခြင်း မဟုတ်ဘဲ၊ ကိုယ်တော်က သီခြင်းမှ အသက်ပြန်ရှင်စီသူ လာဇရုကိုလည်း တွိ့မြင်လို၍ လာကြခြင်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","ထို့ကြောင့် ယဇ်ပုရောဟိတ်အကြီးအကဲရို့က လာဇရုကိုလည်း သတ်ရန် ကြံစည်ခြင်း ဖြစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","အကြောင်းမူကား လာဇရုကြောင့် များစွာသော ယုဒလူရို့သည် ထိုသူရို့ကို စွန့်ခွာ၍ ယေသျှုကို ယုံကြည်သောကြောင့် ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","နောက်တစ်နိ့၌ ပသခါပွဲတော်သို့ လာကြသော လူစုလူဝေးကြီးသည် ယေရုဆလင်မြို့သို့ ယေသျှု ကြွလာတော်မူမည့် အကြောင်းကို ကြားသိကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ထို့ကြောင့် သူရို့သည် စွန်ပလွံခက်များကို ယူ၍ “ဘုရားသခင်ကို ချီးမွမ်းကြလော့။ သခင်ဘုရား၏ နာမတော်နှင့် ကြွလာတော်မူသော သူသည် မင်္ဂလာဟိစီသတည်း။ ဣသရေလ သျှင်ဘုရင်သည် မင်္ဂလာဟိစီသတည်း” ဟု ကြွေးကြော်လျက် ကိုယ်တော့်ကို ကြိုဆိုရန် ထွက်လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","ယေသျှုသည် မြည်းသျှေတစ်ကောင်ကို တွိ့၍ စီးတော်မူ၏။ ကျမ်းစာတော်မြတ်တွင်၊ ");
INSERT INTO rki_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“အို ဇိအုန်မြို့၊ မကြောက်ကေ့။ သင်ရို့၏ သျှင်ဘုရင်သည် မြည်းသျှေကိုစီး၍၊ ကြွလာသည်ကို ကြည့်ရှုကြလော” ဟု ဆိုထားသည်နှင့်အညီ ဖြစ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","ထိုအချိန်ခါက တပည့်တော်ရို့သည် ဤကျမ်းစာကို နားမလည်ကြ။ ယေသျှုသည် ဘုန်းတော်နှင့် ထမြောက်တော်မူသောအခါမှ ဤကျမ်းစာချက်ကား ကိုယ်တော်၏အကြောင်း ဖော်ပြသည်ကိုလည်းကောင်း၊ သူရို့သည် ကိုယ်တော်အတွက် ထိုသို့ပြုခသည်ကိုလည်းကောင်း မှတ်မိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","ယေသျှုသည် လာဇရုအား သင်္ချိုင်းတွင်းထဲမှ ခေါ်ထုတ်၍ အသက်ပြန်ရှင်လာသောအခါက ကိုယ်တော်နှင့်အတူ လိုက်ကြသော သူရို့သည် ထိုအဖြစ်ပျက်ကို သက်သီခံကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ကိုယ်တော်ပြုခသော အံ့ဖွယ်နိမိတ်လက္ခဏာအကြောင်းကို ကြားရသောကြောင့် များစွာသော လူရို့သည် ကိုယ်တော့်ကို ကြိုဆိုရန် လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ဖာရိယှဲရို့ကလည်း “ငါရို့သည် အောင်မြင်ခြင်း မဟိသည်ကို မြင်သလော။ ကြည့်ကတ်၊ လောကကြီးတစ်ခုလုံးက သူ့နောက်သို့ လိုက်ပါလားကြပြီတကား” ဟု အချင်းချင်း ပြောဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ပွဲတော်အတွင်း ဝတ်ပြုကိုးကွယ်ရန် ယေရုဆလင်မြို့သို့ လာကြသော လူထဲတွင် ဟေလသအမျိုးသား တချို့ပါ၏။ ");
INSERT INTO rki_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","သူရို့သည် ဂါလိလဲပြည် ဗက်ဇဲဒမြို့သားဖြစ်သူ ဖိလိပ္ပုပါးသို့ လားကြ၍ “ဆရာ၊ အကျွန်ရို့သည် ယေသျှုကို မြင်ချင်ပါ၏” ဟု တောင်းဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ဖိလိပ္ပုသည် ထိုအကြောင်းကို အန္ဒြေအား ပြောပြပြီးလျှင် သူရို့နှစ်ယောက်သည် ယေသျှုထံသို့ အတူတကွလား၍ လျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ယေသျှုက သူရို့အား “လူသားသည် ကြီးမြတ်သော ဘုန်းပွင့်တော်မူရန် အချိန် အဂုပင် ရောက်လာပြီ။ ");
INSERT INTO rki_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","မှန်သောစကားကို ငါပြောမည်၊ ဂျုံစိ့သည် မြီကြီးသို့မကျ၊ မပျက်စီးလျှင် အစိ့တစ်စိ့ထက် တိုးပွါးလိမ့်မည် မဟုတ်။ ပျက်စီးလျှင်မူကား အသီးအနှံများစွာ တိုးပွါးလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ကိုယ့်အသက်ကို ချစ်သောသူသည် အသက်ဆုံးယှုံးလိမ့်မည်။ ဤလောက၌ မိမိအလိုသို့ မလိုက်သောသူသာလျှင် ထာဝရအသက်ကို စောင့်ရှောက်သူဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","ငါ့အမှုကို ဆောင်ရွက်သောသူသည် ငါ့နောက်သို့ လိုက်ရမည်။ ငါ့အမှုကို ဆောင်ရွက်သောသူဖြစ်သောကြောင့် ငါဟိသည့်အရပ်၌ ဟိလိမ့်မည်။ ငါ့အမှုကို ဆောင်ရွက်သူကို ခမည်းတော်သည် ချီးမြောက်တော်မူလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“အဂုတွင် ငါသည် စိတ်နှလုံး ပူပန်ခြင်းဟိ၏။ ဇာသို့ လျှောက်ရအံ့နည်း။ ‘အဖ အကျွန့်ကို စိတ်ပူပန်ခြင်းမှ ကင်းလွတ်စီတော်မူပါ’ ဟု မြွက်ဆိုရမည်လော။ ယေဒါလည်း ငါသည် ဤဒုက္ခဝေဒနာကို ခံစားရန် ယခုအချိန်နာရီသို့ ရောက်လာခြင်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","အဖ၊ ကိုယ်တော်၏နာမတော်အား ဘုန်းထင်ရှားစီတော်မူပါ” ဟု မြွက်ဆိုတော်မူ၏။ ထိုအခါ ကောင်းကင်မှ အသံတော်ကား “ငါ၏ ဘုန်းတော်ကို ငါ့နာမ၌ ထွန်းတောက်စီယာ။ နောက်တဖန်လည်း ထွန်းတောက်စီဦးမည်” ဟု လာ၏။ ");
INSERT INTO rki_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","ထိုနီရာတွင် ရပ်နိန်ကြသော လူအစုအဝေးရို့သည် ထိုအသံကိုကြား၍ လူတချို့က မိုးကြိမ်းသည်ဟု ဆိုကြ၏။ တချို့က “ကိုယ်တော့်ကို ကောင်းကင်တမန်က စကားပြောသည်” ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","သို့သော် ယေသျှုက ထိုသူရို့အား “ဤအသံတော် ထွက်ပေါ်လာခြင်းက ငါ့အကျိုးတွက် မဟုတ်။ သင်ရို့အကျိုးတွက် ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","ဤလောကသည် အဂုပင် တရားစီရင်ခြင်းကို ခံရမည့်အချိန် ဖြစ်၏။ ဤလောကကို အုပ်ချုပ်သူကလည်း အဂုပင် အပြင်သို့ နှင်ထုတ်ခြင်းကို ခံရ၏။ ");
INSERT INTO rki_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","ငါသည် မြီကြီးမှခွါ၍ မြှောက်ထားခြင်းကို ခံရသည့်အခါ လူတိုင်းကို ငါ့ထံသို့ ငါဆွဲမည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","ဤသို့ မိန့်တော်မူရသည်မှာ မိမိသည် ဒုက္ခဝေဒနာကိုခံရ၍ မည်သို့ အသီခံရမည်ကို အရိပ်အမြွက်အားဖြင့် ဖော်ပြတော်မူခြင်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","လူအစုဝေးကလည်း၊ “မေသျှိယသည် အစဉ်အမြဲ အသက်ရှင်သည်ဟု အကျွန်ရို့ ပညတ္တိကျမ်း၌ ဆို၏။ သို့ဖြစ်လျှင် လူသားသည် မြီကြီးကခွါ၍ မြှောက်ထားခြင်းကို ခံရမည်ဟု ဇာပိုင် ပြောနိုင်သနည်း။ လူသားကား ဇာသူနည်း” ဟု မိန်းမြန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","ယေသျှုကလည်း၊ “အလင်းသည် သင်ရို့၌ ခဏသာ ဟိလိမ့်မည်။ သင်ရို့အား အမှောင် မဖုံးလွှမ်းစီရန် အလင်းဟိစဉ်၌ လားလာကြလော့။ အမှောင်၌ လားလာနိန်သူသည် ဇာအရပ်သို့ လားလာသည်ကိုမသိ။ ");
INSERT INTO rki_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ထို့ကြောင့် အလင်းဟိနိန်ခိုက်တွင် ထိုအလင်းကို ယုံကြည်ကြလော့။ သို့မှသာ သင်ရို့သည် အလင်း၏သားသမီးတိ ဖြစ်လာကြလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ဤသို့ မိန့်တော်မူပြီးနောက် ယေသျှုသည် ထွက်ကြွ၍ ထိုသူရို့ကို တိမ်းယှောင်လျက်နိန်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","သူရို့မျက်မှောက်တွင် နိမိတ်လက္ခဏာများစွာကို ပြခသော်လည်း ကိုယ်တော့်ကို မယုံကြည်ကြ။ ");
INSERT INTO rki_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ပရောဖက်ဟေသျှာယ ဟောဖူးသည်ကား၊ “အို သခင်ဘုရား၊ ငါရို့ ဟောပြောသည့်စကားကို ဇာသူ ယုံပါမည်နည်း၊ သခင်ဘုရားသည် တန်ခိုးတော်ကို ဇာသူ့ထံပါးသို့ ထင်ရှားပါမည်နည်း” ဟူသော စကားသည် ပြည့်စုံခြင်းပင်ဖြစ်သတည်း။ ");
INSERT INTO rki_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","ထိုစကားကြောင့် သူရို့သည် ယုံကြည်ခြင်းသို့ မရောက်နိုင်ကြ။ အကြောင်းမှာ ဟေသျှာယက၊ ");
INSERT INTO rki_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“ဘုရားသခင်သည် သူရို့မျက်စိကို ကွယ်စီတော်မူ၏၊ သူရို့၏ စိတ်နှလုံးကို မိုက်စီသောကြောင့်၊ သူရို့မျက်စိသည် မမြင်နိုင်၊ သူရို့၏ စိတ်နှလုံးသည် နားမလည်နိုင်၊ သူရို့သည် နောင်တမရနိုင်ကြသောကြောင့်၊ သူရို့သည် ကျန်းမာခြင်းကို မရကြ ဟူ၍ ဘုရားသခင်မိန့်တော်မူ၏” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","ဟေသျှာယသည် ယေသျှု၏ ဘုန်းတန်ခိုးတော်ကို ဖူးမြင်ရသဖြင့် ကိုယ်တော်၏ အကြောင်းကို ဤသို့ မြွက်ဆိုခြင်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","သို့စေကာမူ များစွာသော ယုဒအာဏာပိုင်ရို့ကလည်း ယေသျှုကို ယုံကြည်ကြ၏။ သို့သော်လည်း ဖာရိယှဲရို့ကြောင့် တရားဇရပ်မှ နှင်ထုတ်ခံရမည်ကို ကြောက်၍ မိမိရို့ ယုံကြည်ကြကြောင်းကို ပွင့်လင်းစွာ ဝန်မခံကြပေ။ ");
INSERT INTO rki_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ထိုသူရို့က ဘုရားသခင်၏ ချီးမွမ်းခြင်းထက် လူရို့၏ ချီးမွမ်းခြင်းကို ပို၍ နှစ်သက်ကြသူများ ဖြစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","ယေသျှုက အော်ဟစ်၍ “ငါ့ကို ယုံကြည်သူသည် ငါ့ကိုသာ မဟုတ် ငါ့ကို စီရွှတ်တော်မူသည့် သူကိုပင်လျှင် ယုံကြည်၏။ ");
INSERT INTO rki_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ငါ့ကို မြင်သောသူသည်လည်း ငါ့ကို စီရွှတ်တော်မူသော သူကိုလည်း မြင်၏။ ");
INSERT INTO rki_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","ငါ့ကို ယုံကြည်သောသူတိုင်းကို မှောင်မိုက်ထဲ၌ မကျန်ခစီရန်အတွက် ငါသည် အလင်းအဖြစ်ဖြင့် လောကကို ကြွလာပြီ။ ");
INSERT INTO rki_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","ငါ၏ သတင်းစကားကို ကြားလျက်နှင့် မနာခံသောသူကို ငါသည် တရားမစီရင်။ လောကသားတိကို အပြစ်စီရင်ရန် ငါလာသည် မဟုတ်၊ ကယ်တင်ဖို့ရန် လာခြင်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ငါ့ကိုပယ်၍ ငါဟောပြောသော သတင်းစကားကို နာမခံသောသူအား တရားစီရင်မည့်သူ ဟိသိမ့်၏။ ငါဟောပြောသည့်စကားပင် နောက်ဆုံးသောနိ့၌ ထိုသူရို့ကို တရားစီရင်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","ဇာကြောင့်ဆိုသော် ငါသည် ကိုယ့်အခွင့်အာဏာနှင့် ဟောပြောသည် မဟုတ်။ သို့ရာတွင် ငါဟောပြောသော အရာအားလုံးသည် ငါ့ကို စီရွှတ်တော်မူသော ခမည်းတော်က ဟောပြောခိုင်းသည့်အတိုင်း ငါဟောပြောခြင်း ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ခမည်းတော်၏ ပညတ်တော်သည် ထာဝရအသက် ယူဆောင်လာသည်ကို ငါသိ၏။ ထို့ကြောင့် ငါဟောပြောသောအရာသည်ကား ခမည်းတော်သည် ငါ့အား ဟောပြောခိုင်းသည့်အတိုင်း ငါဟောပြောခြင်းဖြစ်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","အဂုအခါကား ပသခါပွဲတော်မတိုင်ခင် တစ်ရက်ဖြစ်၏။ ယေသျှုသည် ဤလောကမှ ထွက်ခွါ၍ ခမည်းတော်ထံပါးသို့ ကြွတော်မူရမည့် အချိန်ကို သိတော်မူ၏။ ကိုယ်တော်သည် ဤလောက၌ဟိသော မိမိလူတိကို အစဉ်အမြဲ ချစ်သောကြောင့် အဆုံးတိုင်အောင် သူရို့ကို ချစ်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","ယေသျှုနှင့် တပည့်တော်ရို့သည် ညစာစားလျက်နိန်ကြ၏။ ယေသျှုကို ရန်သူ့လက်သို့ အပ်နှံရန် မာရ်နတ်သည်သျှိမုန်သျှာကာရုတ်၏သား ယုဒ၏ စိတ်နှလုံးထဲ၌ အကြံအစည်ကို ထည့်ထားပြီး ဖြစ်သတည်း။ ");
INSERT INTO rki_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ခမည်းတော်သည် မိမိအား အလုံးစုံသောတန်ခိုး အပ်တော်မူထားသည်ကိုလည်းကောင်း၊ မိမိသည် ဘုရားသခင်ထံပါးမှ ကြွလာ၍ ဘုရားသခင်ထံတော်ပါးသို့ ပြန်ကြွလားမည်ကိုလည်းကောင်း သိတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ထို့ကြောင့် ကိုယ်တော်သည် စားပွဲမှထ၍ ဝတ်ရုံတော်ကို ချွတ်တော်မူပြီးလျှင် ပုဝါပိုင်းကိုယူ၍ ခါး၌ ချိုင်ထား၏။ ");
INSERT INTO rki_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ထို့နောက် ကိုယ်တော်သည် ရီအချို့ကို အင်ဒုံ၌ လောင်းထည့်၍ တပည့်တော်ရို့၏ ခြီကို ဆီးတော်မူပြီးလျှင် ခါး၌ ပတ်ထားသော ပုဝါပိုင်းနှင့် သုတ်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","သျှိမုန်ပေတရုပါးသို့ ရောက်တော်မူလျှင်၊ ပေတရုက “အသျှင်၊ အကျွန့်ခြီကို ဆီးတော်မူပါမည်လော” ဟု မိန်းလျှောက်၏။ ");
INSERT INTO rki_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ယေသျှုကလည်း၊ “ငါပြုသောအမှုကို သင်သည် အဂု နားမလည်သိမ့်။ သို့ရာတွင် သင်ရို့သည် နောက်မှ နားလည်လာလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ပေတရုက “ကိုယ်တော်သည် အကျွန်၏ခြီကို မည်သည့်အခါမှ မဆီးရပါ” ဟု လျှောက်ဆို၏။ ယေသျှုကလည်း “သင့်ခြီကို ငါမဆီးရလျှင်၊ သင်သည် ငါ၏တပည့် မဖြစ်နိုင်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","သျှိမုန်ပေတရုက၊ “အသျှင်၊ အကျွန်၏ ခြီကို မဆီးဘဲ လက်နှင့် ဦးဂေါင်းကိုသာ ဆီးပီးပါ” ဟု လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ယေသျှုကလည်း၊ “ရီချိုးပြီးသောသူသည် တစ်ကိုယ်လုံး စင်ကြယ်သည်ဖြစ်၍ ခြီကိုဆီးကြောခြင်းမှလွဲ၍ တစ်ကိုယ်လုံး ဆီးကြောစရာမလို။ တစ်ယောက်သောသူမှတစ်ပါး သင်ရို့အားလုံးသည် စင်ကြယ်ကြ၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ယေသျှုသည် မိမိအား သစ္စာဖောက်မည်ကို သိသောကြောင့် ကိုယ်တော်က၊ “တစ်ယောက်သောသူမှတစ်ပါး သင်ရို့အားလုံးသည် စင်ကြယ်ကြ၏” ဟု မိန့်တော်မူခြင်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ကိုယ်တော်သည် တပည့်တော်ရို့၏ခြီကို ဆီးတော်မူပြီးမှ ဝတ်ရုံကို ပြန်၍ဝတ်ပြီး စားပွဲ၌ ထိုင်တော်မူ၏။ ကိုယ်တော်က၊ “သင်ရို့အတွက် ငါပြုခသည့်အမှုကို နားလည်ကြသလော။ ");
INSERT INTO rki_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","သင်ရို့က ငါ့ကို ဆရာ ဟူ၍လည်းကောင်း၊ အသျှင် ဟူ၍လည်းကောင်း ခေါ်တတ်ကြ၏။ အကြောင်းမူကား၊ သင်ရို့ ခေါ်သည်မှာ ဟုတ်မှန်သည်ဖြစ်၍ လျောက်ပတ်ပေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ငါကား သင်ရို့၏ ဆရာဖြစ်သကဲ့သို့ သင်ရို့၏သခင်ဘုရားလည်း ဖြစ်လျက်နှင့်ပင် သင်ရို့ခြီကို ဆီးပီး၏။ ထို့ကြောင့် သင်ရို့လည်း အချင်းချင်းခြီကို ဆီးပီးကြလော။ ");
INSERT INTO rki_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","သင်ရို့၌ ငါပြုသကဲ့သို့ သင်ရို့ အချင်းချင်းလည်း ပြုကြစီရန် စံနမူနာကို ငါပြခယာ။ ");
INSERT INTO rki_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ငါအမှန်ဆိုသည်ကား၊ ကျွန်သည် သခင်ထက် မကြီးမြတ်နိုင်သကဲ့သို့ စီရွှတ်ခြင်းခံရသူတိလည်း စီရွှတ်သူထက် မကြီးမြတ်နိုင်။ ");
INSERT INTO rki_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ဤစကားကို သင်ရို့ အဂု သိကြပြီ။ သိသည်အတိုင်းကျင့်လျှင် မင်္ဂလာ ဟိကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“သင်ရို့အားလုံးကို ရည်မှတ်ပြီး ငါပြောသည် မဟုတ်၊ ငါရွီးချယ်ထားသော သူတိကို ငါသိ၏။ ယေဒါလည်း ကျမ်းစာတော်မြတ်၌ ‘ငါ့ထမင်းကို စားသောသူသည် ငါ့ကို ခြီနှင့် ပြန်ကျောက်သတည်း’ ဟု ဖော်ပြထားသည်အတိုင်း ပြည့်စုံလာရမည်။ ");
INSERT INTO rki_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ထိုအဖြစ်ပျက်တိ မဖြစ်ပျက်ခင် ‘ငါဖြစ်သည်အတိုင်း၊ ငါဖြစ်သည်’ ကို သင်ရို့ ယုံကြည်လာကြစီရန် အဂုပင်လျှင် ကြိုတင်၍ သင်ရို့အား ငါပြောထားပြီ။ ");
INSERT INTO rki_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","ငါအမှန်ဆိုသည်ကား၊ ငါစီရွှတ်သောသူကို လက်ခံသောသူသည် ငါ့ကို လက်ခံခြင်းဖြစ်၏။ ငါ့ကို လက်ခံသောသူသည်လည်း ငါ့ကို စီရွှတ်သော အသျှင်ကိုလက်ခံ၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ဤသို့ မိန့်တော်မူပြီးသောအခါ ယေသျှုသည် အလွန်စိတ်သောက ရောက်တော်မူ၍ “ငါအမှန် ဆိုသည်ကား၊ သင်ရို့အထဲက တစ်ယောက်သည် ငါ့အား ရန်သူ့လက်သို့ အပ်နှံလိမ့်မည်” ဟု ပွင့်လင်းစွာ မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ဇာသူ့ကို ရည်စူး၍ မိန့်တော်မူသည်ကို တပည့်တော်ရို့သည် စဉ်းစားမရနိုင်သဖြင့် တစ်ယောက်ကိုတစ်ယောက် ကြည့်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ထိုသူရို့ထဲမှ ယေသျှုချစ်တော်မူသော တပည့်တော်သည် ကိုယ်တော့်နားကပ်၍ ထိုင်နိန်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","သျှိမုန်ပေတရုကလည်း “ကိုယ်တော်က ဇာသူ့ကို ရည်ရွယ်၍ မိန့်တော်မူပါသနည်း” ဟု မိန်းလျှောက်ရန် ထိုတပည့်တော်အား မျက်ရိပ်ပြ၍ မိန်းစီ၏။ ");
INSERT INTO rki_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ထို့ကြောင့် ထိုတပည့်တော်သည် ယေသျှုအနားသို့ ချဉ်းကပ်၍ “အသျှင်၊ ထိုသူကား ဇာသူဖြစ်သနည်း” ဟု လျှောက်၏။ ");
INSERT INTO rki_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ယေသျှုက “ဤမုန့်တစ်ဖဲ့ကို အချဉ်ရည်၌ တို့၍ ငါပီးသောသူဖြစ်၏” ဟု မိန့်တော်မူ၏။ ထို့နောက် မုန့်တစ်ဖဲ့ကို အချဉ်ရည်ခွက်ထဲ၌ တို့ပြီးလျှင် သျှိမုန်သျှာကာရုတ်၏သား ယုဒကို ပီးလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ယုဒသည် ထိုမုန့်ကို ခံယူလိုက်သည်နှင့်တပြိုင်နက် စာတန်မာရ်နတ်သည် သူအထဲသို့ ဝင်လေ၏။ ယေသျှုကလည်း၊ “သင် ပြုရမည့်အမှုကို အလျင်အမြန်ပြုလော့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","သို့ရာတွင် စားပွဲ၌ လျောင်းနိန်သောသူရို့က ယေသျှုသည် ဇာဖြစ်၍ ထိုသို့ မိန့်တော်မူကြောင်းကို နားမလည်ကြပေ။ ");
INSERT INTO rki_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ယုဒသည် ဖဲသာအိတ်ကို ကိုင်ဆောင်ရသူဖြစ်၍ ပွဲတော်အတွက် လိုအပ်သည်များကို ဝယ်ယူရန် သော်လည်းကောင်း၊ ဆင်းရဲသားရို့အား ပီးကမ်းရန် သော်လည်းကောင်း ယေသျှုမှာထားသည်ဟု တပည့်တော်တချို့က ထင်မှတ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ယုဒသည် မုန့်တစ်ဖဲ့ကို ခံယူပြီးလျှင် ချက်ချင်း ထွက်လားလေ၏။ ထိုအချိန်ကား ညအချိန်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ယုဒ ထွက်လားပြီးနောက် ယေသျှုက၊ “အဂုတွင် လူသားသည် ဘုန်းတော်ထင်ရှားလျက် ဟိသည်ဖြစ်၍၊ ဘုရားသခင်၏ ဘုန်းတန်ခိုးတော်လည်း လူသားအားဖြင့် ထင်ရှားခြင်းဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ဘုရားသခင်သည် လူသားအားဖြင့် ဘုန်းတန်ခိုးတော် ထင်ရှားတော်မူလျှင်၊ ဘုရားသခင်သည် မိမိကိုယ်တိုင်အားဖြင့် သားတော်အား ဘုန်းထင်ရှားစီတော်မူ၍ သူ၏ဘုန်းတော်ကို ချက်ချင်း ထင်ရှားစီတော်မူလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ချစ်သားရို့၊ ငါသည် သင်ရို့နှင့်အတူ ခဏသာ နီရ၏။ သင်ရို့ ငါ့ကို ရှာကြလိမ့်မည်။ ‘ငါလားမည့် နီရာသို့ သင်ရို့ မလိုက်နိုင်ကြ’ ဟု ယုဒအာဏာပိုင်တိကို ပြောခသည်အတိုင်း သင်ရို့ကိုလည်း အဂု ငါပြော၏။ ");
INSERT INTO rki_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","‘အချင်းချင်း ချစ်ကြလော့’ ဟူသော ပညတ်အသစ်ကို သင်ရို့အား အဂု ငါပီး၏။ ငါသည် သင်ရို့ကိုချစ်ခသကဲ့သို့ သင်ရို့လည်း အချင်းချင်းချစ်ကြလော့။ ");
INSERT INTO rki_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","သင်ရို့ အချင်းချင်းချစ်ကြလျှင် လူတိုင်းက သင်ရို့သည် ငါ့တပည့်တိဖြစ်ကြောင်း သိကြလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","သျှိမုန်ပေတရုက “အသျှင်၊ ဇာအရပ်သို့ ကြွတော်မူပါမည်နည်း” ဟု လျှောက်သော်၊ ယေသျှုကလည်း “ငါလားမည့်နီရာသို့ သင်သည် အဂု မလိုက်နိုင်၊ နောက်မှ လိုက်ရလိမ့်မည်” ဟု ဖြေကြားတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ပေတရုက၊ “အသျှင်၊ အကျွန်သည် ဇာဖြစ်လို့ အဂု မလိုက်နိုင်ရသနည်း။ အကျွန်သည် ကိုယ်တော်အတွက် အသက်စွန့်ဖို့ အဆင်သင့်ဟိပါ၏” ဟု လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ယေသျှုကလည်း၊ “သင်သည် ငါ့အတွက် အသက်စွန့်ရန် အဆင့်သင့်ဟိသည်ကား အမှန်လား။ ငါအမှန် ဆိုသည်ကား၊ သင်သည် ကြက်မတွန်ခင် ငါ့ကိုမသိဟု သုံးကြိမ်တိုင်အောင် ငြင်းဆိုလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","ယေသျှုက “သင်ရို့ စိတ်ပူပန်ခြင်း မဟိကတ်ကေ့။ ဘုရားသခင်ကို ယုံကြည်ပါ။ ငါ့ကိုလည်း ယုံကြည်ပါ။ ");
INSERT INTO rki_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ငါ့အဖအိမ်တော်၌ အခန်းများစွာဟိ၏။ သင်ရို့အတွက် နီရာကို ပျင်ဆင်ရန် ငါလားရဦးမည်။ ထိုသို့ မဟုတ်လျှင် မဟုတ်ကြောင်းကို သင်ရို့အား ငါမပြောဘဲမနိန်။ ");
INSERT INTO rki_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","ငါလားပြီးလျှင် သင်ရို့အတွက် နီရာကို ပျင်ဆင်ပြီးမှ ငါသည် ပြန်လာ၍ ငါဟိသည့်အရပ်၌ သင်ရို့ ဟိကြစီရန်အတွက် သင်ရို့ကို ငါ့ထံသို့ ခေါ်ဆောင်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ငါလားသည့်အရပ်သို့ ရောက်စီမည့်လမ်းကို သင်ရို့ သိကြ၏” ဟု သူရို့အား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","သောမက ကိုယ်တော့်ကို “အသျှင်၊ အသျှင်ဇာအရပ်သို့ လားမည်ဆိုသည်ကို အကျွန်ရို့ မသိသည်ဖြစ်၍ ထိုလမ်းခရီးကို အကျွန်ရို့ ဇာသို့ သိနိုင်ပါမည်နည်း” ဟု လျှောက်၏။ ");
INSERT INTO rki_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ယေသျှုကလည်း၊ “ငါသည် လမ်းခရီးဖြစ်၏။ သမ္မာတရားလည်း ဖြစ်၏။ အသက်လည်း ဖြစ်၏။ ငါ့ကို အမှီမပြုလျှင် ခမည်းတော်ထံသို့ တစ်ယောက်မျှ မရောက်နိုင်။ ");
INSERT INTO rki_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","အဂု သင်ရို့သည် ငါ့ကိုသိလျှင်၊ ငါ့ခမည်းတော်ကိုလည်း သိကြမည်၊ အဂုမှစပြီး ခမည်းတော်ကို သင်ရို့သည် သိမြင်ကြ၏” ဟု ထိုသူအား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ဖိလိပ္ပုက “အသျှင်၊ ခမည်းတော်ဘုရားကို အကျွန်ရို့အား ပြတော်မူပါ။ ထိုသို့ ပြတော်မူလျှင် အကျွန်ရို့အလို ပြည့်စုံပါမည်” ဟု လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ယေသျှုကလည်း “ဖိလိပ္ပု၊ သင်ရို့အားလုံးသည် ငါနှင့်အတူ အချိန်အကြာကြီး ဟိနိန်ခလျက်ပင် ငါ့ကို သင်မသိသလော။ ငါ့ကို မြင်ရသောသူသည် ခမည်းတော်ဘုရားကို မြင်ရသောသူ ဖြစ်၏။ ‘ခမည်းတော်ဘုရားအား ငါရို့ကို ပြပါ’ ဟု ဇာကြောင့် ပြောရသနည်း။ ");
INSERT INTO rki_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ငါသည် ခမည်းတော်ဘုရား၌ တည်နိန်သည်ကိုလည်းကောင်း၊ ခမည်းတော်ဘုရားကလည်း ငါ၌ တည်နိန်သည်ကိုလည်းကောင်း သင် မယုံသလော။ သင်ရို့အား ငါပြောသောစကားသည် ငါ့စကား မဟုတ်။ သို့ရာတွင် ငါ့အထဲ၌ ဟိတော်မူသော ခမည်းတော်ဘုရား ပြုတော်မူသော အမှုတိပင်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ငါသည် ခမည်းတော်ဘုရား၌ တည်နိန်သကဲ့သို့ ခမည်းတော်ဘုရားသည်လည်း ငါ့အထဲ၌ တည်နိန်၏ဟု ငါပြောသည်ကို ယုံကြည်ကြသလော။ ငါ့စကားကိုမယုံလျှင် ငါပြုသည့် အမှုများကိုထောက်၍ ယုံကြည်ကြလော။ ");
INSERT INTO rki_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","ငါအမှန် ဆိုသည်ကား၊ ငါ့ကို ယုံကြည်သောသူသည် ငါပြုသောအမှုကို ပြုလိမ့်မည်။ ထိုမျှမက ထိုအမှုတိထက် ကြီးမြတ်သောအမှုတိကိုပင် ပြုလိမ့်မည်။ ဇာကြောင့်ဆိုသော် ငါသည် ခမည်းတော်ထံသို့ လားရမည်။ ");
INSERT INTO rki_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","ခမည်းတော်သည် သားတော်အားဖြင့် ဘုန်းထင်ရှားစီခြင်းငှာ ငါ့နာမကိုအမှီပြု၍ သင်ရို့ တောင်းလျှောက်သည်အတိုင်း ငါပြုမည်။ ");
INSERT INTO rki_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ငါ့နာမကို အမှီပြု၍ သင်ရို့ ဇာဆုကိုမဆို ငါ့ကိုတောင်းလျှင်၊ တောင်းသည့်အတိုင်း ငါပြုမည်။ ");
INSERT INTO rki_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“သင်ရို့သည် ငါ့ကိုချစ်လျှင် ငါ၏ပညတ်တိကို စောင့်ရှောက်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ငါသည် ခမည်းတော်ကို တောင်းလျှောက်လျှင် သင်ရို့နှင့်အတူ အစဉ်မပြတ်ဟိ၍ သင်ရို့ကို မစတော်မူရန် အခြားတစ်ပါးသော ကူညီမစသောသူကို ပီးတော်မူလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ထိုအသျှင်သည် ဘုရားသခင်၏ သမ္မာတရားကို ဖော်ပြသော ဝိညာဉ်တော်ဖြစ်၏။ လောကီသားတိက ထိုဝိညာဉ်တော်ကို မသိမမြင်ကြသောကြောင့် မခံယူနိုင်ကြ။ သို့ရာတွင် ထိုအသျှင်ကို သင်ရို့ သိကြ၏။ အကြောင်းမူကား ထိုဝိညာဉ်တော်သည် သင်ရို့ထဲ၌ ကိန်းဝပ်တော်မူသည်ဖြစ်၍ သင်ရို့၌ ဟိလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“ငါလားသော်လည်း သင်ရို့ကို မိဘမဲ့ ဖြစ်စီမည် မဟုတ်။ သင်ရို့ထံပါးသို့ ငါပြန်လာဦးမည်။ ");
INSERT INTO rki_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ခဏကြာလျှင် ဤလောကသားတိ ငါ့ကို မမြင်ရသော်လည်း သင်ရို့ကား မြင်ရလိမ့်မည်။ ငါသည် အသက်ရှင်သည်ဖြစ်၍ သင်ရို့လည်း အသက်ရှင်ကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ငါသည် ခမည်းတော်၌ တည်နိန်သည်ကိုလည်းကောင်း၊ သင်ရို့သည် ငါ့၌ တည်နိန်သည်ကိုလည်းကောင်း၊ ငါသည်လည်း သင်ရို့၌ တည်နိန်သည်ကိုလည်းကောင်း ထိုနိ့ရက်၌ သင်ရို့ သိကြလိမ့်မည်။” ");
INSERT INTO rki_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“ငါ့ပညတ်တိကို ခံယူ၍ စောင့်ထိန်းသူရို့သည် ငါ့ကို ချစ်သောသူတိဖြစ်၏။ ငါ့ကို ချစ်သောသူကို ခမည်းတော်ကလည်း ချစ်တော်မူ၏။ ငါကလည်း သူရို့ကို ချစ်၍ သူရို့အား ငါကိုယ်တိုင် ထင်ရှားစီမည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","ယုဒ (ယုဒသျှာကာရုတ် မဟုတ်သူ) က၊ “အသျှင်၊ လောကသားတိအား မဖော်ပြဘဲ ငါရို့အား ဇာကြောင့် အသျှင်ကိုယ်တိုင် ဖော်ပြတော်မူမည်နည်း” ဟု မိန်းလျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ယေသျှုကလည်း၊ “ငါ့ကိုချစ်သောသူသည် ငါ၏ သွန်သင်ချက်ကို ခံယူလိမ့်မည်။ ငါ့ခမည်းတော်သည်လည်း ထိုသူကို ချစ်တော်မူလိမ့်မည်။ ငါနှင့် ငါ့ခမည်းတော်သည်လည်း သူ့ထံသို့ လာပြီးလျှင် သူနှင့်အတူ ကိန်းဝပ်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ငါ့ကို မချစ်သောသူသည် ငါ၏သွန်သင်ချက်ကို မခံယူတတ်။ သင်ရို့ ကြားရသော သွန်သင်ချက်ကား ငါ၏ သွန်သင်ချက် မဟုတ်။ ငါ့ကို စီရွှတ်တော်မူသော ခမည်းတော်ထံပါးမှလာသော သွန်သင်ချက်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“ငါသည် သင်ရို့နှင့်အတူ ဟိနိန်စဉ် ဤအရာများကို ပြောပြပြီးဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ယေဒါလည်း ခမည်းတော်က ငါ၏ နာမကြောင့် စီရွှတ်တော်မူသော ကူညီမစသော သူတည်းဟူသော သန့်ယှင်းသော ဝိညာဉ်တော်သည် ဟိသမျှအရာတိကို ပြသသွန်သင်တော်မူ၍ ငါပြောသမျှသော စကားတိကို သင်ရို့အား ပြန်လည်သတိရစီတော်မူလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“ငြိမ်သက်ခြင်းကို သင်ရို့နှင့်အတူ ငါထားခ၏။ ငါ၏ငြိမ်သက်ခြင်းကိုလည်း သင်ရို့ကို ငါပီး၏။ လောကသားတိ ပီးသကဲ့သို့ ငါပီးသည် မဟုတ်။ သင်ရို့ စိတ်မပူပန်ခြင်း၊ စိုးရိမ်ခြင်း မဟိကတ်ကေ့။ ");
INSERT INTO rki_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","‘ငါသည် အဂု လားသော်လည်း သင်ရို့ထံပါးသို့ ငါပြန်လာအုံးမည်’ ဟု ပြောခသည်ကို သင်ရို့ ကြားရကြပြီ။ ခမည်းတော်သည် ငါ့ထက် ကြီးမြတ်၏။ ထို့ကြောင့် သင်ရို့သည် ငါ့ကိုချစ်လျှင် ခမည်းတော်ထံပါးသို့ ငါလားသည်ကို ဝမ်းမြောက်ကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","ထိုအကြောင်းအရာတိ ဖြစ်ပျက်လာသောခါ သင်ရို့ ယုံကြည်ကြစီရန် ထိုအရာတိမဖြစ်ပျက်ခင် သင်ရို့အား အဂုပင် ငါ ပြောထားခြင်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","လောကကို အုပ်ချုပ်သူသည် လာနိန်သောကြောင့် ငါသည် သင်ရို့နှင့် အချိန်အကြာကြီး စကားမပြောနိုင်ယာ။ သူသည် ငါ့ကို မည်သို့မျှ မပြုနိုင်။ ");
INSERT INTO rki_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ယေဒါလည်း ငါသည် ခမည်းတော်ကို ချစ်ကြောင်း လောကသားတိအား သိစီရန် လိုအပ်၏။ ထို့ကြောင့် ခမည်းတော်က ငါ့အား မိန့်မှာတော်မူသည့်အတိုင်း လိုက်နာဆောက်ရွက်ခြင်းဖြစ်၏။ “လာကြ၊ ဤနီရာမှ လားကြကုန်အံ့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“ငါသည် မှန်သောစပျစ်နွယ်ပင် ဖြစ်၏။ ငါ၏ခမည်းတော်သည် ဥယျာဉ်မှူးဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","သူသည် ငါ၌ အသီးမသီးသော အကိုင်းအခက်ဟူသမျှကို ဖြတ်ထုတ်ပစ်၏။ အသီးသီးသော အကိုင်းအခက်တိကို သာ၍ သီးစီခြင်းငှာ သုတ်သင်ယှင်းလင်းလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ငါသည် သင်ရို့ကို ငါ၏ နှုတ်ကပတ်တော်ဖြင့် သန့်ယှင်းထားပြီးဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ငါသည် သင်ရို့၌ တည်သကဲ့သို့ သင်ရို့သည်လည်း ငါ၌ တည်ကြလော့။ မည်သည့်အခက်မျှ ကိုယ့်အလိုအလျှောက် အသီးမသီးနိုင်။ စပျစ်ပင်၌ တည်မှသာလျှင် အသီးသီးနိုင်၏။ ထိုကဲ့သို့ပင် သင်ရို့သည်လည်း ငါနှင့် ကွာလျှင် အသီးမသီးနိုင်ကြပေ။ ");
INSERT INTO rki_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“ငါသည် စပျစ်ပင် ဖြစ်၏။ သင်ရို့သည်ကား အကိုင်းအခက်တိ ဖြစ်ကြ၏။ သင်ရို့သည် ငါ၌ တည်၍ ငါသည် သင်ရို့၌ တည်လျှင် များစွာသော အသီးကို သီးကြလိမ့်မည်။ သင်ရို့သည် ငါနှင့်ကွာလျှင် ဇာတစ်ခုကိုမျှ မလုပ်နိုင်ကြပေ။ ");
INSERT INTO rki_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ငါ၌ မတည်သော သူသည် ခြောက်သွိ့သော အကိုင်းအခက်များ ကဲ့သို့ အပြင်သို့ ရွှင့်ပစ်ခြင်းကို ခံရ၏။ ထိုသို့သော အကိုင်းအခက်များကို စုသိမ်း၍ မီးထဲသို့ ပစ်ချခြင်းကို ခံရသဖြင့် လောင်ကျွမ်းခြင်းကို ခံရ၏။ ");
INSERT INTO rki_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","သင်ရို့သည် ငါ၌ တည်၍ ငါ၏စကားသည် သင်ရို့၌ တည်လျှင် သင်ရို့သည် လိုချင်သမျှကို တောင်း၍ ရကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","သင်ရို့သည် များစွာသောအသီးကို သီးခြင်းအားဖြင့် ငါ့ခမည်းတော်၏ ဘုန်းတော်ကို ထင်ရှားသောသူများ ဖြစ်ကြ၏။ ထိုသို့အားဖြင့် သင်ရို့သည် ငါ့တပည့် အမှန် ဖြစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","ငါ၏ခမည်းတော်သည် ငါ့ကို ချစ်သကဲ့သို့ ငါသည်လည်း သင်ရို့ကို ချစ်၏။ သင်ရို့သည် ငါ၏မေတ္တာ၌ တည်နိန်ကြလော့။ ");
INSERT INTO rki_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ငါသည် ငါ့ခမည်းတော်၏ ပညတ်တိကို စောင့်ထိန်း၍ ငါ့ခမည်းတော်၏ မေတ္တာ၌ တည်နိန်သကဲ့သို့ သင်ရို့သည်လည်း ငါ၏ပညတ်တိကို စောင့်ထိန်းလျှင် ငါ၏မေတ္တာ၌ တည်နိန်ကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“ငါ၏ဝမ်းမြောက်ခြင်းသည် သင်ရို့၌ တည်စီခြင်းငှာလည်းကောင်း၊ သင်ရို့သည် ဝမ်းမြောက်ခြင်းနှင့် ပြည့်ဝကြစီခြင်းငှာ လည်းကောင်း ဤစကားများကို သင်ရို့အား ငါပြော၏။ ");
INSERT INTO rki_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","ငါ၏ ပညတ်သည်ကား၊ ငါသည် သင်ရို့ကို ချစ်သကဲ့သို့ သင်ရို့သည်လည်း အချင်းချင်း ချစ်ကြလော့။ ");
INSERT INTO rki_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","ကိုယ့်မိတ်ဆွီရို့အတွက် ကိုယ့်အသက်ကို စွန့်ပီးခြင်းမေတ္တာထက် သာ၍ ကြီးမြတ်သော မေတ္တာဟူ၍ မဟိ။ ");
INSERT INTO rki_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","သင်ရို့သည် ငါ့ ပညတ်ကို ကျင့်လျှင် ငါ၏မိတ်ဆွီ ဖြစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","ငါသည် သင်ရို့ကို အခိုင်းအစီ ဟူ၍ မခေါ်။ အခိုင်းအစီဆိုသည်ကား မိမိ၏သခင် လုပ်သမျှကို သိရကြသည် မဟုတ်။ သို့သော် ငါသည် ငါ့ခမည်းတော်ထံမှ သင်ယူခသမျှတိကို သင်ရို့အား သိစီပြီးဖြစ်၍ သင်ရို့ကို မိတ်ဆွီများဟု ငါ ခေါ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","သင်ရို့သည် ငါ့ကို ရွီးကောက်ကြသည် မဟုတ်။ သင်ရို့သည် လား၍ တည်ကြည်သော အသီးတိကို သီး၍ ပွားများစီခြင်းငှာ ငါသည် သင်ရို့ကို ရွီးကောက်၍ ခန့်ထားခြင်း ဖြစ်၏။ သို့ဖြစ်၍ ငါ၏နာမ၌ တောင်းသမျှကို ခမည်းတော်သည် သင်ရို့အား ပီးတော်မူလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","ငါ၏ပညတ်သည်ကား သင်ရို့သည် တစ်ယောက်ကို တစ်ယောက် ချစ်ကြလော့ ဟူ၍ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“လောကသားတိက သင်ရို့ကို မုန်းကြလျှင် သင်ရို့ကို မမုန်းခင်ကတည်းက ငါ့ကို မုန်းကြခြင်းဖြစ်သည်ဟု မှတ်ယူကြလော့။ ");
INSERT INTO rki_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","သင်ရို့သည် လောကနှင့် သက်ဆိုင်လျှင် လောကသား အချင်းချင်းဖြစ်သောကြောင့် လောကသားများက သင်ရို့ကို ချစ်ကြလိမ့်မည်။ သို့ရာတွင် ငါသည် သင်ရို့ကို လောကထဲက ရွီးကောက်ထားသောကြောင့် လောကနှင့် မသက်ဆိုင်သည်ဖြစ်၍ လောကသားတိက သင်ရို့ကို မုန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","‘ကျွန်သည် သခင်ထက် ကြီးမြတ်သည် မဟုတ်’ ဟု သင်ရို့အား ငါပြောခသည်ကို မှတ်ထားကြလော့။ လူတိက ငါ့ကို ညှဉ်းဆဲကြလျှင် သင်ရို့ကိုလည်း သာ၍ ညှဉ်းဆဲကြလိမ့်မည်။ သူရို့သည် ငါ၏အဆုံးအမကို နာခံလျှင် သင်ရို့၏ အဆုံးအမကိုလည်း နာခံကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","ထိုသူရို့သည် ငါ့ကို စီရွှတ်လိုက်သော အသျှင်ကို မသိကြသည်ဖြစ်၍ ငါ၏နာမကြောင့် သင်ရို့ကိုလည်း ပြုကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","ငါသည် ကြွလာ၍ သူရို့ကို မဟောပြောခလျှင် သူရို့၌ အပြစ်ဟိကြလိမ့်မည် မဟုတ်။ သို့ရာတွင် အဂုအခါ သူရို့သည် မိမိရို့၏အပြစ်ကို ဝှက်၍ မထားနိုင်ကြ။ ");
INSERT INTO rki_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ငါ့ကို မုန်းသောသူရို့သည်ကား ငါ့ခမည်းတော်ကိုလည်း မုန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","ငါသည် တစ်စုံတစ်ယောက်မျှ မပြုဖူးသော အရာများကို သူရို့ ရှိ့မှာ မပြုလုပ်ခလျှင် သူရို့၌ အပြစ်ဟိကြလိမ့်မည် မဟုတ်။ သို့ရာတွင် အဂု ငါပြုသောအမှုကို သူရို့သည် မြင်ကြလျက်ပင် ငါနှင့် ငါ့ခမည်းတော်ကို မုန်းကြခြင်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","ဤသို့ ဖြစ်ရခြင်းမှာ ‘သူရို့သည် အကြောင်းပြချက်မဟိဘဲ ငါ့ကို မုန်းကြလေ၏’ ဟူ၍ သူရို့၏ ပညတ္တိကျမ်း၌ ရီးထားသမျှသည် ပြည့်စုံလာခြင်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“ခမည်းတော်ထံပါးက လာသည့် ဘုရားသခင်နှင့် ပတ်သက်၍ သမ္မာတရားကို ထုတ်ဖော်ပြောကြားသော ဝိညာဉ်တော်တည်းဟူသော ကူညီမစသောသူသည် ရောက်လာလိမ့်မည်။ ထိုဝိညာဉ်တော်ကို ခမည်းတော်ထံမှ သင်ရို့ပါးသို့ ငါရွှတ်လိုက်သည်ဖြစ်၍ သူသည် ငါ့အကြာင်းကို ပြောပြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ထို့အပြင် သင်ရို့သည်လည်း ငါ့အကြောင်းကို ပြောကြလိမ့်မည်၊ အကြောင်းမူကား သင်ရို့သည် အစကတည်းကပင် ငါနှင့်အတူ ဟိခဖူးသောကြောင့် ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“သင်ရို့သည် မိမိရို့၏ ယုံကြည်ခြင်း မပျက်စီခြင်းငှာ ဤစကားတိကို သင်ရို့အား ငါပြောထား၏။ ");
INSERT INTO rki_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","သင်ရို့ကို တရားဇရပ်များထဲက နှင်ထုတ်ကြလိမ့်မည်။ သင်ရို့ကို အသီသတ်သောသူများသည် ဘုရားသခင်၏အမှုတော်ကို ဆောင်ရွက်ခြင်းဖြစ်သည်ဟု ထင်မှတ်ကြသောအချိန်သည် ရောက်လာလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","သူရို့သည် ငါ့ကို သို့မဟုတ် ခမည်းတော်ကို မသိကြသည်ဖြစ်၍ ဤသို့ ပြုမူကြခြင်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","သို့ရာတွင် ထိုအချိန်ကာလ ရောက်လာသောအခါ သူရို့နှင့်ပတ်သက်၍ သင်ရို့အား ငါသတိပီးခသည်ကို သတိရကြစီခြင်းငှာ ငါသည် ဤအကြောင်းအရာများကို ပြောထားခြင်းဖြစ်၏။ “ငါသည် သင်ရို့နှင့်အတူ ဟိနိန်ခသောကြောင့် အစကတည်းကပင် ဤအကြောင်းအရာများကို သင်ရို့အား ငါမပြောခ။ ");
INSERT INTO rki_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","သို့ရာတွင် အဂုအချိန်၌ ငါ့ကို စီရွှတ်လိုက်သော သူ၏ထံသို့ ငါလားရဖို့ယာ။ ‘ဇာနီရာသို့ လားပါမည်နည်း’ ဟု သင်ရို့ မည်သူတစ်ဦးတစ်ယောက်မျှ ငါ့ကို မမိန်းကြ။ ");
INSERT INTO rki_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","အဂုအချိန်၌ ဤအကြောင်းအရာများကို သင်ရို့အား ငါ ပြောလိုက်သောကြောင့် သင်ရို့သည် အလွန်ဝမ်းနည်းကြရ၏။ ");
INSERT INTO rki_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","ငါအမှန် ဆိုသည်ကား ငါ ထွက်ခွါလားခြင်းသည် သင်ရို့အတွက် သာ၍ ကောင်းပေ၏။ ငါ မလားလျှင် သင်ရို့ကို ကူညီမစမည့်အသျှင်သည် ရောက်လာလိမ့်မည် မဟုတ်ပေ။ သို့ရာတွင် ငါ လားမှသာလျှင် ကူညီမစမည့်အသျှင်ကို သင်ရို့ပါးသို့ ငါ စီရွှတ်လိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","ထိုအသျှင် ရောက်လာသောအခါ အပြစ်တရားကို ပြုလျက် ဟိနိန်ကြကြောင်းကိုလည်းကောင်း၊ ဖြောင့်မတ်ခြင်းအကြောင်းကိုလည်းကောင်း၊ ဘုရားသခင်၏ တရားစီရင်ခြင်းအကြောင်းကိုလည်းကောင်း ထိုလောကီသားတိကို ဖော်ပြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","သူရို့သည် ငါ့ကို မယုံကြည်ကြသောကြောင့် အပြစ်နှင့်ပတ်သက်၍ မှားယွင်းလျက်ဟိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ငါသည် ခမည်းတော်ထံသို့ လားမည်ဖြစ်၍ သင်ရို့သည် ငါ့ကို မမြင်ရသောကြောင့် ဖြောင့်မတ်ခြင်းတရားကို ဖော်ပြမည်။ ");
INSERT INTO rki_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ဤလောကကို အုပ်စိုးသောသူသည် တရားစီရင်ခြင်းကို ခံရသောကြောင့် သူရို့သည် တရားစီရင်ခြင်းအကြောင်းနှင့် ပတ်သက်၍ မှားယွင်းလျက်ဟိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“ငါသည် သင်ရို့အား ပြောစရာအများကြီး ဟိသော်လည်း သင်ရို့သည် အဂုအခါ မှတ်ယူနိုင်ကြလိမ့်မည် မဟုတ်ပေ။ ");
INSERT INTO rki_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","ဘုရားသခင်နှင့်ပတ်သက်၍ သမ္မာတရားအကြောင်းကို ဖော်ပြသော ဝိညာဉ်တော်သည် ရောက်လာသောအခါ အလုံးစုံသော သမ္မာတရားထဲသို့ သင်ရို့ကို လမ်းပြပို့ဆောင်လိမ့်မည်။ ထိုဝိညာဉ်တော်သည် မိမိ၏သဘောအတိုင်း သင်ရို့ကို သွန်သင်လိမ့်မည် မဟုတ်၊ သူ ကြားသမျှကို ပြောလိမ့်မည်။ နောက်ဖြစ်လာမည့် အရာများကိုလည်း သင်ရို့အား ပြောပြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","ထိုဝိညာဉ်တော်သည် ငါပြောသမျှတိကို ယူ၍ သင်ရို့အား ပြောပြသောကြောင့် ငါ၏ ဘုန်းတော်ကို ထင်ရှားစီလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","ငါ၏ခမည်းတော် ပိုင်ဆိုင်သောအရာခပ်သိမ်းသည် ငါပိုင်ဆိုင်သော အရာများဖြစ်၏။ ထိုဝိညာဉ်တော်သည် ငါပြောသမျှကို မှတ်ယူ၍ သင်ရို့အား ပြောပြပီးလိမ့်မည်ဟု ငါပြော၏။ ");
INSERT INTO rki_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“တအောင့်ကြာလျှင် သင်ရို့သည် ငါ့ကို မြင်တွိ့ရလိမ့်မည် မဟုတ်။ တအောင့်ကြာပြီးမှ သင်ရို့သည် ငါ့ကို တဖန် ပြန်၍ မြင်တွိ့ကြရလိမ့်မည်။” ");
INSERT INTO rki_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ထိုအခါ တပည့်တော်တချို့က “တအောင့်ကြာလျှင် သင်ရို့သည် ငါ့ကို မြင်တွိ့ကြရလိမ့်မည် မဟုတ်ဟူ၍ လည်းကောင်း၊ သင်ရို့သည် တအောင့်ကြာပြီးမှ ငါ့ကို ပြန်၍ မြင်တွိ့ကြရလိမ့်မည်ဟူ၍ လည်းကောင်း၊ ‘အကြောင်းမူကား ငါသည် ခမည်းတော်ထံသို့ လားရဦးမည်’ ဟူ၍ လည်းကောင်း ကိုယ်တော်သည် ငါရို့အား မိန့်တော်မူသည်မှာ ဇာကို ဆိုလိုပါသနည်း။ ");
INSERT INTO rki_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","‘ခဏ’ ဟူသောစကားသည် ဇာကို ဆိုလိုပါသနည်း၊ ကိုယ်တော် မိန့်တော်မူသည်ကို အကျွန်ရို့ နားမလည်ကြပါ” ဟု အချင်းချင်း မိန်းမြန်းနိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ယေသျှုက တပည့်တော်ရို့သည် ဤအကြောင်းကို မိန်းမြန်းလိုကြသည်ကို သိတော်မူသည်ဖြစ်၍ “‘တအောင့်ကြာလျှင် သင်ရို့သည် ငါ့ကို မြင်တွိ့ရကြလိမ့်မည် မဟုတ်။ တအောင့်ကြာပြီးမှ သင်ရို့သည် ငါ့ကို ပြန်၍ မြင်တွိ့ကြရလိမ့်မည်’ ဟု ငါပြောခသည်ကို သင်ရို့သည် အချင်းချင်း မိန်းမြန်းနိန်ကြသည် မဟုတ်လောဟု သူရို့အား မိန်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","ငါအမှန် ဆိုသည်ကား၊ သင်ရို့ ဝမ်းနည်း ငိုကြွီးရလိမ့်မည်။ သို့ရာတွင် ထိုအချိန်၌ လောကသားတိ ဝမ်းမြောက်ကြလိမ့်မည်။ သင်ရို့သည်ကား ဝမ်းနည်း ရကြလိမ့်မည်။ သို့သော် သင်ရို့၏ ဝမ်းနည်းခြင်းသည် ဝမ်းသာခြင်း ဖြစ်လာလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","အသျှေမွီးဖွားမည့် မိန်းမတစ်ယောက်သည် မွီးချိန် ရောက်လာသောအခါ နာကျင်ခြင်းဝေဒနာကို ခံစားရသောအချိန် ရောက်လာမည်ဖြစ်သောကြောင့် ဝမ်းနည်းရ၏။ သို့ရာတွင် အသျှေကို မွီးဖွားသောအခါ၌မူကား လောကထဲသို့ အသျှေတစ်ယောက်ကို မွီးဖွားပီးလိုက်ပြီဟူသော ဝမ်းမြောက်ခြင်းဖြင့် ထိုမိန်းမသည် မိမိ၏နာကျင်ခြင်းဝေဒနာကို မိ့လျော့လားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","ထိုနည်းတူ အဂုတွင် သင်ရို့သည် ဝမ်းနည်းပူဆွီးရကြ၏။ သို့သော်လည်း ငါသည် သင်ရို့ကို တဖန် မြင်တွိ့သောခါ၊ သင်ရို့၏စိတ်နှလုံးသည် ဝမ်းသာခြင်းနှင့် ပြည့်ဝကြလိမ့်မည်။ သင်ရို့၏ဝမ်းသာခြင်းကို မည်သူမျှ နုတ်ယူနိုင်လိမ့်မည် မဟုတ်ပေ။ ");
INSERT INTO rki_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“ထို နိ့ရောက်လာသောခါ သင်ရို့သည် ငါ၌ တောင်းလျှောက်ရန် မလိုယာ။ ငါ အမှန်ဆိုသည်ကား ငါ၏နာမ၌ သင်ရို့တောင်းသမျှကို ခမည်းတော်သည် သင်ရို့အား ပီးတော်မူလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","အဂုအချိန်ထိ ငါ့နာမ၌ သင်ရို့သည် တစ်စုံတစ်ခုကိုမျှ မတောင်းကြသိမ့်။ သင်ရို့သည် ဝမ်းသာခြင်းနှင့် ပြည့်ဝကြစီခြင်းငှာ တောင်းကြလော့။ တောင်းလျှင် ရကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“ဤအကြောင်းအရာတိကို သင်ရို့အား ပုံဥပမာသုံး၍ ငါဟောပြောရ၏။ ပုံဥပမာမသုံးဘဲ ဟောပြောရသောအချိန် ရောက်လာလိမ့်မည်။ ထိုအချိန်ရောက်သောအခါ ခမည်းတော်အကြောင်းကို သင်ရို့အား ယှင်းလင်းစွာ ငါပြောပြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ထိုနိ့ရောက်လာသောအခါ သင်ရို့သည် ငါ့နာမ၌ ခမည်းတော်ထံသို့ တောင်းလျှောက်ကြလိမ့်မည်။ သင်ရို့ကိုယ်စား ခမည်းတော်ထံပါး၌ ငါတောင်းပီးမည်ဟု သင်ရို့ကို ငါပြောသည် မဟုတ်။ ");
INSERT INTO rki_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ငါသည် ဘုရားသခင်ထံပါးက ဆင်းလာသည်ကို သင်ရို့သည် ယုံကြည်ကြပြီး ငါ့ကိုလည်း ချစ်ကြသောကြောင့် ခမည်းတော်ကိုယ်တိုင် သင်ရို့ကို ချစ်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ငါသည် ခမည်းတော်ထံပါးမှ ဤလောကသို့ ဆင်းလာခြင်းဖြစ်၏၊ အဂုအချိန်၌ ငါသည် ဤလောကမှ ထွက်ခွာ၍ ခမည်းတော်ထံပါးသို့ ပြန်လားရမည်” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ယေသျှု၏ တပည့်တော်တိက “အဂုအခါ ကိုယ်တော်သည် အကျွန်ရို့ကို ဥပမာမသုံးဘဲ ယှင်းလင်းစွာ ပြောလေပြီ။ ");
INSERT INTO rki_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ကိုယ်တော်သည် အရာခပ်သိမ်းကို သိမြင်တော်မူကြောင်းကိုလည်းကောင်း၊ မည်သူမျှ ကိုယ်တော့်ကို မိန်းလျှောက်ရန် မလိုအပ်ကြောင်းကိုလည်းကောင်း အကျွန်ရို့သည် အဂု သိကြပါ၏။ ဤအကြောင်းကို ထောက်၍ ကိုယ်တော်သည် ဘုရားသခင်ထံပါးမှ ဆင်းလာသည်ကို အကျွန်ရို့သည် ယုံကြည်ကြပါ၏” ဟု လျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ယေသျှုက “အဂုအချိန်၌ သင်ရို့ ယုံကြည်ကြပြီလော။ ");
INSERT INTO rki_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","သင်ရို့သည် တကွဲတပြားစီဖြစ်လျက် အသီးသီး မိမိရို့အိမ်သို့ ပြန်လားကြပြီးလျှင် ငါ့ကို တစ်ယောက်တည်း ထားပစ်ခမည့်အချိန်သည် ရောက်လာမည်ဖြစ်၍ အဂုပင် ရောက်လာလေပြီ။ သို့သော်လည်း ငါသည် တစ်ယောက်တည်း မဟုတ်၊ ခမည်းတော်သည် ငါနှင့်အတူ ဟိတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","သင်ရို့အားလုံး ငါနှင့် တစ်လုံးတစ်ဝတည်းဟိနိန်ခြင်းဖြင့် ငြိမ်သက်ခြင်းဟိကြစီခြင်းငှာ ငါသည် ဤအရာကို သင်ရို့အား ဟောပြောထား၏။ သင်ရို့သည် ဤလောက၌ ဒုက္ခ တွိ့ရကြလိမ့်မည်။ သို့သော်လည်း မကြောက်ကတ်ကေ့၊ ငါသည် လောကကို အောင်ပြီ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","ယေသျှုသည် ဤသို့ ဆုံးမသြဝါဒ ပီးတော်မူပြီးနောက် ကောင်းကင်သို့ မျှော်ကြည့်လျက် ဆုတောင်းပတ္ထနာ ပြုတော်မူသည်မှာ “အို အဖ၊ အချိန်ရောက်ပါပြီ၊ သားတော်သည် ကိုယ်တော်၏ ဘုန်းတော်ကို ထင်ရှားစီခြင်းငှာ သားတော်အား ဘုန်းတန်ခိုးတော်ကို ပီးသနားတော်မူပါ။ ");
INSERT INTO rki_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","အကြောင်းမူကား ကိုယ်တော်သည် သားတော်ကို ပီးအပ်ထားသော သူရို့အား ထာဝရအသက်ကို ရစီခြင်းငှာ လူသားအားလုံးကို အစိုးရသောအခွင့်အာဏာကို သားတော်အား ပီးအပ်ထားပြီးဖြစ်ပါ၏။ ");
INSERT INTO rki_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","ထာဝရအသက်ဟူသည်ကား စစ်မှန်၍ တစ်ဆူတည်းဖြစ်တော်မူသော ဘုရားသခင်ကိုလည်းကောင်း၊ ကိုယ်တော် စီရွှတ်လိုက်သော ယေသျှုခရစ်တော်ကိုလည်းကောင်း သိကျွမ်းခြင်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ကိုယ်တော်သည် အကျွန့်အား လုပ်ဆောင်စီသောအမှုကို ပြီးမြောက်အောင် လုပ်ဆောင်ခြင်းအားဖြင့် အကျွန်သည် မြီကြီးထက်မှာ ကိုယ်တော်၏ဘုန်းတန်ခိုးတော်ကို ထင်ရှားစီပြီးယာ။ ");
INSERT INTO rki_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","အို အဖ၊ ဤကမ္ဘာ မတည်ခင်ကပင် ကိုယ်တော်နှင့်အတူ ဟိခဖူးသော ဘုန်းတော်ကို အဂု ကိုယ်တော်၏ မျက်မှောက်တော်၌ အကျွန်အား ထင်ရှားစီတော်မူပါ။ ");
INSERT INTO rki_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“ဤလောကထဲမှ အကျွန်အား ပီးတော်မူသောသူရို့အား ကိုယ်တော့်ကို သိမြင်စီခြင်းငှာ အကျွန်သည် ဖော်ပြပြီးဖြစ်ပါ၏။ ကိုယ်တော် ပိုင်တော်မူသော သူရို့ကို အကျွန်အား ပီးထားသည်ဖြစ်၍ သူရို့သည်လည်း ကိုယ်တော်၏ နှုတ်ကပတ်တော်ကို နာခံကြပြီးဖြစ်ပါ၏။ ");
INSERT INTO rki_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","အကျွန်အား ပီးသနားတော်မူသော ခပ်သိမ်းသောအရာအားလုံးသည် ကိုယ်တော်ထံပါးက လာသည်ကို သူရို့သည် အဂု သိကြပြီးဖြစ်ပါ၏။ ");
INSERT INTO rki_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","အကြောင်းမူကား ကိုယ်တော်သည် အကျွန်အား ပီးတော်မူသော နှုတ်ကပတ်တော်ကို သူရို့အား အကျွန် ဟောပြောပြီးဖြစ်၍ သူရို့သည်လည်း လက်ခံကြပါ၏။ အကျွန်သည် ကိုယ်တော်ထံမှ လာသူဖြစ်ကြောင်းကို သူရို့သည် အမှန်သိကြပါ၏။ အကျွန်သည် ကိုယ်တော်စီရွှတ်သူဖြစ်ကြောင်းကို သူရို့သည် ယုံကြည်ကြပါ၏။ ");
INSERT INTO rki_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“သူရို့အတွက် အကျွန် ဆုတောင်းပါ၏။ လောကသားတိအတွက် ဆုတောင်းသည် မဟုတ်။ ကိုယ်တော်က အကျွန်အား ပီးအပ်ထားသော ကိုယ်တော်ပိုင်သောသူရို့အတွက် အကျွန် ဆုတောင်းပါ၏။ ");
INSERT INTO rki_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","အကျွန်၌ ဟိသမျှသောအရာအားလုံးသည် ကိုယ်တော် ပိုင်တော်မူသောအရာများ ဖြစ်ကြသည်နှင့်အညီ ကိုယ်တော်၌ ဟိသမျှသော အရာအားလုံးသည်လည်း အကျွန်ပိုင်သောအရာများ ဖြစ်ကြသည်ဖြစ်၍ ထိုသူရို့အားဖြင့် အကျွန်၏ဘုန်းတော်ကို ထင်ရှားလျက် ဟိပါ၏။ ");
INSERT INTO rki_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","အကျွန်သည် ကိုယ်တော်ထံသို့ လာနိန်ပြီဖြစ်သဖြင့် လောကထဲ၌ မဟိယာ။ သို့ရာတွင် သူရို့မူကား လောက၌ ကျန်နိန်ခကြ၏။ မြင့်မြတ်သန့်ယှင်းတော်မူသောအဖ၊ ကိုယ်တော်နှင့် အကျွန်သည် တစ်လုံးတစ်ဝတည်းဖြစ်သကဲ့သို့ သူရို့ကိုလည်း တစ်လုံးတစ်ဝတည်း ဖြစ်စီခြင်းငှာ အကျွန်အား စောင့်ရှောက်တော်မူသော ကိုယ်တော်၏နာမတော် တန်ခိုးဖြင့် သူရို့ကို စောင့်ရှောက်တော်မူပါ။ ");
INSERT INTO rki_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","အကျွန်သည် သူရို့နှင့်အတူ ဟိနိန်သောအချိန်မှာ ကိုယ်တော်၏နာမတော်တန်ခိုးဖြင့် အကျွန်အား ပီးထားသော သူရို့ကို အကျွန်သည် စောင့်ရှောက်ထားပါ၏။ ကျမ်းစာ ပြည့်စုံစီမည့်အကြောင်း တစ်ယောက်သောသူမှ လွဲ၍ သူရို့အားလုံးကို မပျက်စီးစီရန် အကျွန်စောင့်ရှောက်ထားပါ၏။ ");
INSERT INTO rki_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","အဂုအချိန်၌ အကျွန်သည် ကိုယ်တော်ထံပါးသို့ လာနိန်ပြီဖြစ်၍ အကျွန်၏ဝမ်းမြောက်မှုသည် သူရို့၏ နှလုံးသားထဲ၌ အပြည့်အဝခံစားကြစီရန် အကျွန်သည် ဤလောက၌ ဟိနိန်စဉ် ဤအရာတိကို အကျွန် ပြောဆိုခပါ၏။ ");
INSERT INTO rki_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","အကျွန်သည် ကိုယ်တော်၏ နှုတ်ကပတ်တော်ကို သူရို့အား ဟောထားပြီးဖြစ်ပါ၏။ အကျွန်သည် ဤလောကနှင့် မဆက်ဆံသကဲ့သို့ သူရို့သည်လည်း မဆက်ဆံကြသောကြောင့် လောကသားတိက သူရို့ကို မုန်းကြပါ၏။ ");
INSERT INTO rki_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","အကျွန်သည် သူရို့ကို ဤလောကမှ နုတ်ယူပါစီကြောင်း တောင်းလျှောက်နိန်ခြင်း မဟုတ်ပါ၊ ဒုစရိုက်အပြစ်မှ ကင်းဝီးပါစီကြောင်း အကျွန် ဆုတောင်းပါ၏။ ");
INSERT INTO rki_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","အကျွန်သည် လောကနှင့် မဆက်ဆံသကဲ့သို့ သူရို့လည်း မဆက်ဆံကြပါ။ ");
INSERT INTO rki_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","သမ္မာတရားအားဖြင့် သူရို့ကို သန့်ယှင်းစီတော်မူပါ။ ကိုယ်တော်၏နှုတ်ကပတ်တော်သည် သမ္မာတရားဖြစ်ပါ၏။ ");
INSERT INTO rki_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ကိုယ်တော်သည် အကျွန်အား လောကထဲသို့ စီရွှတ်လိုက်သကဲ့သို့ သူရို့ကိုလည်း အကျွန်သည် ဤလောကထဲသို့ စီရွှတ်လိုက်ပါ၏။ ");
INSERT INTO rki_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","သူရို့သည် အမှန် သန့်ယှင်းစင်ကြယ်စီခြင်းအလို့ငှာ အကျွန်သည် သူရို့အတွက် ကိုယ့်ကိုယ်ကို သန့်ယှင်းစင်ကြယ်ပါ၏။ ");
INSERT INTO rki_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“အကျွန်သည် သူရို့အတွက်သာ ဆုတောင်းသည် မဟုတ်ပါ၊ သူရို့၏ နှုတ်ကပတ်တော်အားဖြင့် အကျွန့်ကို ယုံကြည်လာကြမည့် သူရို့အတွက်လည်း ဆုတောင်းပါ၏။ ");
INSERT INTO rki_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","အို အဖ၊ ကိုယ်တော်သည် အကျွန်၌ လည်းကောင်း၊ အကျွန်သည် ကိုယ်တော်၌ လည်းကောင်း တစ်လုံးတစ်ဝတည်းဖြစ်သကဲ့သို့ သူရို့အားလုံးသည်လည်း အကျွန်ရို့နှင့် တစ်လုံးတစ်ဝတည်း ဖြစ်ပါစီအကြောင်း အကျွန် ဆုတောင်းပါ၏။ အကျွန့်အား ကိုယ်တော်စီရွှတ်လိုက်ကြောင်းကို လောကသားတိ ယုံကြည်ကြစီရန် ထိုသူရို့ကို တစ်လုံးတစ်ဝတည်း ဖြစ်စီတော်မူပါ။ ");
INSERT INTO rki_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","ကိုယ်တော်နှင့် အကျွန်သည် တစ်လုံးတစ်ဝတည်း ဖြစ်သကဲ့သို့ သူရို့သည်လည်း တစ်လုံးတစ်ဝတည်း ဖြစ်ကြစီခြင်းငှာ အကျွန်သည် ကိုယ်တော်ပီးထားသော ဘုန်းတန်ခိုးတော်ကို သူရို့အား ပီးထားပြီးဖြစ်ပါ၏။ ");
INSERT INTO rki_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","သူရို့သည် တစ်လုံးတစ်ဝတည်း၌ စုံလင်ကြစီရန် ကိုယ်တော်သည် အကျွန်၌ ဟိတော်မူ၍ အကျွန်သည်လည်း သူရို့၌ ဟိတော်မူပါ၏။ ထိုသို့အားဖြင့် ကိုယ်တော်သည် အကျွန့်ကို ချစ်တော်မူသကဲ့သို့ သူရို့ကိုလည်း ချစ်တော်မူကြောင်းကိုလည်းကောင်း ကိုယ်တော်သည် အကျွန့်အား စီရွှတ်လိုက်သည်ကိုလည်းကောင်း လောကသားတိ သိကြပါလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“အို အဖ၊ ကိုယ်တော်သည် အကျွန့်ကို ချစ်တော်မူသောကြောင့် ဤကမ္ဘာမတည် မဟိခင်ကပင် အကျွန့်အား ပီးထားသော ဘုန်းတန်ခိုးတော်ကို သူရို့သည် မြင်ကြစီခြင်းငှာ အကျွန့်အား ကိုယ်တော် ပီးအပ်ထားသော ဤသူရို့ကို အကျွန်ဟိသောနီရာ၌ အကျွန်နှင့်အတူ ဟိနိန်ကြစီခြင်းငှာ အကျွန် လိုလားပါ၏။ ");
INSERT INTO rki_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ဖြောင့်မတ်တော်မူသောအဖ၊ လောကီသားရို့သည် ကိုယ်တော့်ကို မသိကြသော်လည်း အကျွန်သည် သိပါ၏။ ကိုယ်တော်သည် အကျွန့်အား စီရွှတ်လိုက်သည်ကို ဤသူရို့သည် သိကြပါ၏။ ");
INSERT INTO rki_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","အကျွန့်ကို ချစ်တော်မူသော ကိုယ်တော်၏ မေတ္တာတော်သည် သူရို့၌ တည်၍ အကျွန်ကိုယ်တိုင်လည်း သူရို့၌ တည်စီခြင်းငှာ ကိုယ်တော်၏နာမတော်ကို သူရို့အား ညွှန်ပြပြီးဖြစ်၏။ အစဉ်အမြဲ ညွှန်ပြပါဦးမည်” ဟု ဆုတောင်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","ယေသျှုသည် ဤသို့ ဆုတောင်းတော်မူပြီးလျှင် တပည့်တော်ရို့နှင့်အတူ ထွက်ခွာလာပြီးနောက် ကေဒြုန်ချောင်းကို ဖြတ်ကြ၍ ထိုအရပ်၌ဟိသော ဥယျာဉ်တစ်ခုထဲသို့ ဝင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ထိုနီရာကား ယေသျှုသည် တပည့်တော်ရို့နှင့် အကြိမ်များစွာ တွိ့နိန်ကျ နီရာတစ်ခု ဖြစ်သောကြောင့် သစ္စာဖောက် ယုဒသျှာကာရုတ်သည်လည်း ထိုအရပ်ကို သိ၏။ ");
INSERT INTO rki_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ထို့ကြောင့် ယုဒသျှကာရုတ်သည် ယဇ်ပုရောဟိတ်အကြီးအကဲရို့နှင့် ဖာရိယှဲရို့က စီရွှတ်လိုက်သည့် ဗိမာန်တော်အစောင့်စစ်သားတချို့နှင့် ရောမစစ်သားများကို သူနှင့်အတူ ခေါ်လာကာ ထိုဥယျာဉ်သို့ ရောက်လာ၏။ သူရို့သည် မီးအိမ်၊ မီးတုတ်နှင့် လက်နက်များကို ကိုင်ဆောင်လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ယေသျှုသည် မိမိ၌ ဖြစ်လာမည့် ဤအကြောင်းအရာအားလုံးကို ကြိုတင်၍ သိတော်မူပြီး ဖြစ်သောကြောင့် သူရို့ထံပါးသို့ လားကာ “သင်ရို့သည် ဇာသူ့ကို ရှာနိန်ကြသနည်း” ဟု မိန်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","သူရို့က “နာဇရက်မြို့သား ယေသျှု” ဟု ပြောကြ၏။ ကိုယ်တော်က “ငါသည် ထိုသူပင် ဖြစ်၏” ဆိုလေ၏။ သစ္စာဖောက် ယုဒသျှကာရုတ်သည် ထိုအရပ်၌ဟိသောသူရို့နှင့်အတူ ရပ်လျက်ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ယေသျှုက “ငါသည် ထိုသူဖြစ်၏” ဟု သူရို့ကို ပြောလိုက်သောအခါ သူရို့သည် နောက်သို့ လန်၍ မြီကြီးသို့ လဲကျလားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","“သင်ရို့သည် ဇာသူ့ကို ရှာနိန်ကြသနည်း” ဟု ယေသျှုက တဖန် မိန်းပြန်၏။ “နာဇရက်မြို့သား ယေသျှု” ဟု သူရို့က ပြောကြပြန်၏။ ");
INSERT INTO rki_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","“ငါသည် ထိုသူဖြစ်သည်ဟု သင်ရို့ကို ပြောပြီးပြီ။ သင်ရို့သည် ငါ့ကို ရှာနိန်ကြလျှင် တခြားလူတိကို ပြန်ရွှတ်လိုက်” ဟု ယေသျှုက ပြော၏။ ");
INSERT INTO rki_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ဤသို့ ပြောရခြင်းမှာ “အို အဖ၊ ငါ့ကို ပီးထားသောသူတိအားလုံး တစ်ယောက်မျှ မပျက်စီးပါစီကေ့” ဟု သူပြောထားသော စကားသည် ပြည့်စုံလာစီခြင်းငှာ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","ဒါးကိုလွယ်ထားသည့် သျှိမုန်ဟု ခေါ်သော ပေတရုသည် ဒါးကို ဆွဲထုတ်ကာ ယဇ်ပုရောဟိတ်မင်း၏ ကျွန်တစ်ယောက်ကို ခွတ်လိုက်သဖြင့် သူ၏ လက်ယာဖက် နားရွက်သည် ပြတ်လားလေ၏။ ထိုကျွန်၏အမည်ကား မာလခု ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ယေသျှုက “သင်၏ဒါးကို ဒါးအိမ်၌ ပြန်ထားလိုက်။ ငါ၏ခမည်းတော်ပီးသော ဒုက္ခခွက်ဖလားကို ငါသည် မသောက်ဘဲ နိန်ရမည်လော” ဟု ပေတရုအား ပြော၏။ ");
INSERT INTO rki_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","ထို့နောက် ရောမစစ်သားတိနှင့် စစ်သူကြီးတိ၊ ယုဒလူမျိုး အစောင့်စစ်သားရို့သည် ယေသျှုကို ဖမ်းဆီး၍ ကြိုးနှင့်တုပ်ပြီးလျှင် ");
INSERT INTO rki_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","အန္နတ်မင်းရှိ့မှောက်သို့ ယူဆောင်လာကြ၏။ အန္နတ်မင်းကား ထိုနှစ်တွင် ယဇ်ပုရောဟိတ်မင်းအဖြစ် ဆောင်ရွက်နိန်သည့် ကယာဖ၏ယောက္ခမ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ထိုကယာဖသည်ကား လူအားလုံးအတွက် လူတစ်ယောက်က အသီခံပီးလျှင် သာ၍ ကောင်းပေ၏ဟု ယုဒလူမျိုး ခေါင်းဆောင်ရို့အား အကြံပီးခဖူးသော သူတစ်ယောက် ဖြစ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","သျှိမုန် ပေတရုနှင့် အခြားသော တပည့်တော် တစ်ယောက်သည် ယေသျှုနောက်သို့ လိုက်ပါကြလေ၏။ ထိုအခြားသော တပည့်တော်သည် ယဇ်ပုရောဟိတ်မင်းနှင့် သိကျွမ်းသဖြင့် ယေသျှုနှင့်အတူ လိုက်၍ ယဇ်ပုရောဟိတ်မင်း၏ အိမ်ခြံဝင်းသို့ ဝင်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ပေတရုသည် ယဇ်ပုရောဟိတ်မင်း အိမ်ခြံဝင်း၏ တန်းခါးအပြင်၌ ရပ်လျက်နိန်စဉ် ထိုတပည့်တော်သည် ထွက်လာကာ တန်းခါးတွင် စောင့်နိန်သော အစီခံမိန်းမအား ပြောဆို၍ ပေတရုကို အိမ်ထဲသို့ ခေါ်သွင်းလာ၏။ ");
INSERT INTO rki_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","တန်းခါးစောင့်မိန်းမက “သင်သည်လည်း ယေသျှု၏တပည့်တော် တစ်ယောက်ဖြစ်သည် မဟုတ်လော” ဟု မိန်းသောအခါ၊ ပေတရုက “ငါ မဟုတ်” ဟု ဖြေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ချမ်းအီးသောကာလ ဖြစ်သဖြင့် အစီခံများနှင့် အစောင့်စစ်သည်များသည် မီးသွီးမီးဖို တစ်ခုကို ဖို၍ ပတ်လည်ဝိုင်းကာ ရပ်လျက် မီးလှုံနိန်ကြ၏။ ပေတရုသည်လည်း သူရို့နှင့်အတူ မတ်တပ်ရပ်လျက် မီးလှုံလျက်နီ၏။ ");
INSERT INTO rki_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","ယဇ်ပုရောဟိတ်မင်းက ယေသျှု၏ တပည့်တော်တိအကြောင်းကိုလည်းကောင်း၊ သူ၏ သွန်သင်မှုများအကြောင်းကိုလည်းကောင်း စစ်ဆီးမိန်းမြန်း၏။ ");
INSERT INTO rki_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ယေသျှုက “ငါသည် လောကလူအပေါင်းရို့ ရှိ့တွင် ထင်ရှားစွာ ဟောပြောခ၏။ ယုဒလူတိ စုဝေးကြသော ဗိမာန်တော်၌ သို့မဟုတ် တရားဇရပ်များ၌ အစဉ်မပြတ် ဟောပြောသွန်သင်ခ၏။ ");
INSERT INTO rki_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","ဇာကြောင့် ငါ့ကို မိန်းနိန်ရသနည်း။ ငါဟောပြောခသော ငါ၏သွန်သင်မှုများကို ကြားထားပြီးသောသူတိအား မိန်းမြန်းကြည့်ကြလော့” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","ယေသျှုက ဤသို့ မိန့်တော်မူသောအခါ ထိုနီရာ၌ဟိသော အစောင့်စစ်သည်တစ်ယောက်က “သင်သည် ယဇ်ပုရောဟိတ်မင်းကြီးကို ဤသို့ ပြောဆိုရဲသလော” ဟု ဆို၍ ပါးကို သတ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ယေသျှုက “ငါပြောသည့်စကား မှားသည်ဆိုလျှင် ဤအရပ်၌ဟိသော လူတိုင်းကို မိန်းကြည့်ကြလော့။ ငါပြောသည့်စကား မှန်လျက်သားနှင့် ငါ့ကို ဇာဖြစ်လို့ သတ်ရသနည်း” ဟု ပြန်ပြော၏။ ");
INSERT INTO rki_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","ထို့နောက် အန္နတ်မင်းသည် ကိုယ်တော့်ကို တုပ်နှောင်ထားသည့်အတိုင်း တုပ်နှောင်ကာ ယဇ်ပုရောဟိတ်မင်းကြီး ကယာဖထံပါးသို့ ပို့လိုက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","သျှိမုန်ပေတရုသည် ထိုနီရာ၌ မတ်တပ်ရပ်ကာ မီးလှုံလျက်ဟိ၏။ “သင်သည်လည်း ထိုသူ၏ တပည့်တစ်ယောက် ဖြစ်သည် မဟုတ်လော” ဟု တခြားလူတိက သူ့ကို မိန်းကြ၏။ ပေတရုက “ငါ မဟုတ်ပါ” ဟု ငြင်းဆိုလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ပေတရု ဒါးနှင့် ခွတ်၍ နားရွက် ပြတ်လားသောသူ၏ ဆွီမျိုးတစ်ယောက်ဖြစ်သည့် ယဇ်ပုရောဟိတ် ကျွန်တစ်ယောက်က “သင်သည် ဥယျာဉ်ထဲ၌ သူနှင့်အတူ ဟိသည်ကို ငါမြင်ခသည် မဟုတ်လော” ဟု မိန်း၏။ ");
INSERT INTO rki_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","ပေတရုက “ငါ မသိ” ဟု တဖန်ထပ်၍ ငြင်းပြီးသည်နှင့် — ချက်ချင်း ကြက်တွန်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","မိုးထစောစောတွင် ယေသျှုကို ကယာဖအိမ်မှ ဘုရင်ခံ၏ အိမ်တော်သို့ ယူဆောင်လားကြ၏။ ယုဒဘာသာရေး ခေါင်းဆောင်ရို့သည် ပသခါပွဲကို ခံယူခြင်းငှာ ဘာသာတရားဆိုင်ရာ ညစ်ညူးခြင်း မဖြစ်စီခြင်းငှာ အိမ်တော်ထဲသို့ သူရို့ကိုယ်တိုင် မဝင်ကြပေ။ ");
INSERT INTO rki_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","ထို့ကြောင့် ပိလတ်သည် သူရို့ဟိရာ အိမ်အပြင်သို့ ထွက်ပြီးလျှင် “ဇာအပြစ်နှင့် စွပ်စွဲပြီးကေ ဤသူကို ခေါ်လာကြသနည်း” ဟု မိန်းသော်၊ ");
INSERT INTO rki_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","“အကျွန်ရို့သည် ဤသူကို ပြစ်မှားခြင်း မဟိဘဲ ခေါ်လာကြသည် မဟုတ်ပါ” ဟု သူရို့က ပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ပိလတ်မင်းက “ဤသူကို သင်ရို့၏ ပညတ်တရားအတိုင်း သင်ရို့ကိုယ်တိုင် တရားစီရင်ကြလော့” ဟု ပြော၏။ ယုဒလူရို့က “အကျွန်ရို့သည် မည်သူ့ကိုမျှ အသီသတ်ပိုင်ခွင့် မဟိပါ” ဟု ပြန်ပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ဤသည်ကား မိမိသည် မည်သို့သော သီခြင်းမျိုးနှင့် သီရမည်ကို ယေသျှုပြောခသည့် စကားအတိုင်း ပြည့်စုံစီခြင်းငှာ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ပိလတ်သည် အိမ်တော်ထဲသို့ ပြန်ဝင်၍ ယေသျှုကို ခေါ်ပြီးလျှင် “သင်သည် ယုဒလူမျိုး၏ သျှင်ဘုရင်လား” ဟု မိန်း၏။ ");
INSERT INTO rki_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","“ဤမိန်းခွန်းသည် မင်းကြီး၏ စကားလား သို့မဟုတ် တခြားလူတိက မင်းကြီးအား ငါ့အကြောင်းကို လျှောက်ကြသလော” ဟု ယေသျှုက မိန်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ပိလတ်မင်းက “သင် ငါ့ကို ယုဒလူမျိုးဟု ထင်မှတ်နိန်လား။ သင်ရို့လူမျိုးတိနှင့် ယဇ်ပုရောဟိတ်အကြီးအကဲရို့က သင့်ကို ငါ့ပါးသို့ လာရောက်အပ်နှံကြ၏။ သင်သည် မည်သို့ ပြုလုပ်ခသနည်း” ဟု ပြန်ပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ယေသျှုက “ငါ၏ နိုင်ငံတော်သည် ဤလောကနှင့် မသက်ဆိုင်၊ ဤလောကနှင့် သက်ဆိုင်လျှင် ငါ၏လူရို့သည် ငါ့ကို ယုဒအာဏာပိုင်တိ လက်ထဲသို့ မရောက်ရအောင် တိုက်ခိုက်ကြလိမ့်မည်။ သို့ရာတွင် ငါ၏နိုင်ငံတော်သည် ဤအရပ်နှင့် မသက်ဆိုင်” ဟု မိန့်တော်မူလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","ပိလတ်မင်းက “သို့ဖြစ်လျှင် သင်သည် သျှင်ဘုရင်တစ်ပါး ဖြစ်ပါသလော” ဟု မိန်းပြန်၏။ ယေသျှုက “ငါသည် သျှင်ဘုရင်တစ်ပါးဖြစ်သည်ဟု သင်ဆို၏။ ငါသည် သမ္မာတရားကို သက်သီခံခြင်းငှာ ဤလောကထဲ၌ မွီးဖွားခြင်းကိုခံ၍ ဆင်းသက်လာ၏။ သမ္မာတရားနှင့် သက်ဆိုင်သောသူတိုင်းသည် ငါ့စကားကို နားထောင်ကြ၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","“သမ္မာတရားဆိုသည်မှာ ဇာလဲ” ဟု ပိလတ်မင်းက မိန်း၏။ ပိလတ်မင်းက ယုဒလူမျိုးတိပါးသို့ ပြန်လာပြီးလျှင် “ဤသူကို ပြစ်ဒဏ် ပီးစရာအကြောင်း ငါတစ်ခုမျှ မတွိ့။ ");
INSERT INTO rki_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","သို့သော်လည်း ပသခါပွဲချိန်၌ ငါသည် သင်ရို့အတွက် အကျဉ်းသားတစ်ယောက်ကို လွှတ်ပီးသော သင်ရို့၌ ထုံးစံဟိသည်အတိုင်း ယုဒလူမျိုးများ၏ သျှင်ဘုရင်ကို သင်ရို့အတွက် ရွှတ်ပီးလိုကြသလော” ဟု မိန်းသော်၊ ");
INSERT INTO rki_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","သူရို့က “ဤသူကို မလွှတ်ပီးပါကေ့။ ဗာရဗ္ဗကိုသာ ရွှတ်ပီးပါ” ဟု ပိလတ်အား အော်ဟစ်၍ တောင်းဆိုကြ၏။ ဗာရဗ္ဗသည်ကား လူဆိုးဒါးပြ တစ်ယောက်ဖြစ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","ထိုအခါ ပိလတ်မင်းက ယေသျှုကို ဆွဲယူကာ ကြာပွတ်ဖြင့် သတ်ခိုင်းလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","စစ်သားရို့သည် ဆူးခက်ဖြင့် ယက်လုပ်ထားသော သရဖူကို သူ၏ဂေါင်းမှာ ဆောင်းစီပြီးမှ နီမောင်းသောဝတ်ရုံကို ဝတ်စီပြီး၊ ");
INSERT INTO rki_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ကိုယ်တော်ထံသို့ ချဉ်းကပ်ကြပြီးလျှင် “ယုဒသျှင်ဘုရင် အသက် ရှည်ပါစီ” ဟု ပြောကာ ပါးကို သတ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","ပိလတ်မင်းက လူအစုအဝေးဟိရာသို့ တဖန် ထွက်လာပြီးလျှင် “ဤသူကို ပြစ်ဒဏ်ပီးစရာအကြောင်း တစ်ခုမျှ မတွိ့သည်ကို သင်ရို့ မြင်စီခြင်းငှာ ထုတ်ပြမည်၊ ကြည့်ကတ်ပါ” ဟု ပြောပြီးနောက် ");
INSERT INTO rki_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ယေသျှုသည် နီမောင်းသော ဝတ်ရုံကို ဝတ်ဆင်လျက်၊ ဆူးဖြင့် ယက်လုပ်ထားသည့် သရဖူကို ဆောင်း၍ ထွက်လာသောအခါ ပိလတ်မင်းက “ဤသူပင် ဖြစ်၏” ဟု သူရို့အား ဆိုလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ယဇ်ပုရောဟိတ်အကြီးအကဲရို့နှင့် ဗိမာန်တော် အစောင့်စစ်သည်များက သူ့ကို မြင်ကြသောအခါ “ဤသူကို လက်ဝါးကပ်တိုင်မှာ တင်ပြီး သတ်ပစ်လိုက်ပါ၊ ဤသူကို လက်ဝါးကပ်တိုင်မှာ တင်ပြီး သတ်ပစ်လိုက်ပါ” ဟု အော်ဟစ် တောင်းဆိုကြ၏။ ပိလတ်မင်းက “သင်ရို့သည် သူ့ကို ခေါ်ဆောင်ပြီးလျှင် လက်ဝါးကပ်တိုင်တွင် တင်ပြီး အသီသတ်လိုက်ကြ။ သူ့အား အပြစ်စီရင်ရန် အကြောင်းကို ငါသည် ရှာမတွိ့” ဟု ဆိုလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","ယုဒခေါင်းဆောင်ရို့က “ဤသူသည် သူ့ကိုယ်သူ ဘုရားသခင်၏သားဟု ပြောဆိုနိန်သောကြောင့် ငါရို့၏ ပညတ်တရားအတိုင်း အသီသတ်ပစ်ရပါမည်” ဟု ပြန်၍ ဖြေကြားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ပိလတ်သည် ထိုသို့တောင်းဆိုသံကို ကြားသောအခါ အလွန်ကြောက်ရွံ့လျက်၊ ");
INSERT INTO rki_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","အိမ်တော်သို့ ပြန်ဝင်ပြီးလျှင် “သင်သည် ဇာအရပ်က လာသနည်း” ဟု ယေသျှုကို မိန်း၏။ သို့ရာတွင် ယေသျှုကလည်း ပြန်ပြောတော်မမူ။ ");
INSERT INTO rki_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","ပိလတ်ကလည်း “သင်သည် ငါ့ကို စကားမပြောချင်သလား၊ ငါသည် သင့်ကို လွှတ်လိုက လွှတ်နိုင်သည်၊ လက်ဝါးကပ်တိုင်မှာ တင်ပြီး သတ်လိုက သတ်နိုင်သော အာဏာ အပြည့်အဝဟိသည်ကို သင်သည် မသိသလော” ဟု မိန်း၏။ ");
INSERT INTO rki_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ယေသျှုက “ဘုရားသခင် အခွင့် မပီးလျှင် မင်းကြီးသည် ငါ၌ မည်သည့် အခွင့်အာဏာမျှ မဟိပါ။ ငါ့ကို မင်းကြီးလက်သို့ အပ်နှံသော သူသည် သာ၍ အပြစ်ကြီးပါ၏” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ဤစကားကို ပိလတ်ကြားသောခါ၊ သူသည် ယေသျှုကို ပြန်လွှတ်ရန် ကြိုးစားပြန်၏။ သို့ရာတွင် ယုဒလူမျိုး အပေါင်းရို့က “ထိုသူအား လွှတ်ပီးလိုက်လျှင် မင်းကြီးသည် ဧကရာဇ်မင်း၏ မိတ်ဆွီ မဟုတ်ယာ၊ မိမိကိုယ်ကို ဘုရင်ဟု ဆိုသူသည် ဧကရာဇ်မင်း၏ ရန်သူသာ ဖြစ်ပါ၏” ဟု အော်ဟစ်ပြောဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ပိလတ်သည်လည်း ထိုစကားသံကို ကြားသောအခါ ယေသျှုကို အပြင်သို့ ထုတ်လာပြီးမှ ဟေဗြဲဘာသာစကားဖြင့် “ဂဗ္ဗသ” ဟု ခေါ်သည့် ကျောက်ပြား စင်္ကြံ၌ ဟိသော တရားပလ္လင်ထက်တွင် ထိုင်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ထိုနိ့ကား ပသခါပွဲနိ့အတွက် ပျင်ဆင်နိန်ရသော အဖိတ်နိ့ မွန်းတည့်ချိန် ဖြစ်၏။ ပိလတ်က ယုဒလူအပေါင်းရို့အား “ဤသူကား သင်ရို့၏ သျှင်ဘုရင်” ဟု ပြော၏။ ");
INSERT INTO rki_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","ထိုသူရို့က “သူ့ကို လက်ဝါးကပ်တိုင်မှာ တင်ပြီး သတ်ပစ်လိုက်ပါ။ သူ့ကို လက်ဝါးကပ်တိုင်မှာ တင်ပြီး သတ်ပစ်လိုက်ပါ။ သူ့ကို လက်ဝါးကပ်တိုင်မှာ တင်ပြီး သတ်ပစ်လိုက်ပါ” ဟု အော်ဟစ်၍ တောင်းဆိုကြ၏။ ပိလတ်မင်းက “သင်ရို့သည် ငါ့အား သင်ရို့၏ သျှင်ဘုရင်ကို လက်ဝါးကပ်တိုင်မှာ တင်၍ သတ်ခိုင်းနိန်ကြသလော” ဟု မိန်း၏။ ထိုအခါ ယဇ်ပုရောဟိတ်အကြီးအကဲများက “ငါရို့မှာ ဧကရာဇ်ဘုရင် တစ်ပါးတည်းသာ ဟိပါ၏” ဟု ပြန်ပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","ထို့နောက် ပိလတ်က ယေသျှုကို လက်ဝါးကပ်တိုင်မှာ တင်ပြီး အသီသတ်ရန် ထိုသူရို့၏ လက်သို့ အပ်လိုက်လေ၏။ ထို့နောက် သူရို့သည် ယေသျှုကို ထုတ်ယူလာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ကိုယ်တော်သည် မိမိလက်ဝါးကပ်တိုင်ကို မိမိကိုယ်တိုင် ထမ်းရွက်ကာ “ဦးဂေါင်းခွံအရပ်” ဟု ခေါ်တွင်ကြသော အရပ်သို့ ထွက်လာကြ၏။ ထိုအရပ်ကို ဟေဗြဲဘာသာအားဖြင့် ဂေါလဂေါသ ဟု ခေါ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","သူရို့သည် ထိုနီရာ၌ အခြားနှစ်ယောက်နှင့်အတူ ယေသျှုကို အလယ်၌ ထားကာ လက်ဝါးကပ်တိုင်မှာ တင်၍ သတ်လိုက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ပိလတ်က “ယုဒလူမျိုးများ၏သျှင်ဘုရင် နာဇရက်မြို့သား ယေသျှု” ဟု ကဗျည်းစာ တစ်ခုကို ရီးကာ လက်ဝါးကပ်တိုင်တွင် ချိတ်ဆွဲထားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","ထိုကဗျည်းစာကို ဟေဗြဲဘာသာ၊ လက်တင်ဘာသာ၊ ဟေလသဘာသာစကားများနှင့် ရီးထား၏။ ယေသျှုကို လက်ဝါးကပ်တိုင်မှာ တင်ပြီး သတ်ထားသော နီရာသည် မြို့နှင့် မဝီးသောကြောင့် များစွာသော ယုဒလူမျိုးအပေါင်းရို့သည် ထိုစာကို ဖတ်ကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","ယဇ်ပုရောဟိတ်အကြီးအကဲတိက “‘ယုဒလူမျိုးများ၏ သျှင်ဘုရင်’ ဟု မရီးပါကေ့၊ ထိုသို့ ရီးမည့်အစား ‘ဤသူက ငါသည် ယုဒလူမျိုးတိ၏ သျှင်ဘုရင်ဖြစ်သည်ဟု ပြောဆို၏’ ဟူ၍ ရီးပါ” ဟု ပိလတ်အား လျှောက်ထားကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","သို့သော်လည်း ပိလတ်က “ငါရီးထားသည့်အတိုင်း ငါရီးထားပြီးပြီ” ဟု ပြန်၍ မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","စစ်သားရို့သည် ယေသျှုကို လက်ဝါးကပ်တိုင်မှာ တင်၍ သတ်ထားပြီးနောက် သူ၏အပြင်ဝတ်ရုံကို လေးပိုင်းပိုင်းကာ တစ်ယောက်လျှင် တစ်ပိုင်းစီ ခွဲဝီ၍ ယူကြလေ၏။ ကိုယ်တော်၏အတွင်းခံ အဝတ်သည် အထက်မှ အောက်သို့ထိတိုင်အောင် ခြုပ်ရိုး လုံးဝမဟိဘဲ ရက်လုပ်ထားခြင်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","စစ်သားတိက “ဤဝတ်ရုံကို မဆုတ်မဖြဲ ကတ်ကေ့။ ရထိုက်သောသူ ရယူစီခြင်းငှာ မဲနှိုက်၍ ဆုံးဖြတ်ကတ်မေ” ဟု အချင်းချင်း ပြောဆိုကြ၏။ ဤကား ကျမ်းစာ၌ ရီးထားသည့်အတိုင်း၊ “သူရို့သည် ငါ၏အဝတ်ကို ပိုင်းဖြတ်ကာ ခွဲဝီ၍ ယူကြပြီးလျှင် ငါ၏ဝတ်ရုံကိုကား မဲနှိုက်၍ ယူကြလေ၏” ဟူသော စကား ပြည့်စုံလာစီရန် ဖြစ်လာခြင်း ဖြစ်၏။ သို့ဖြစ်၍ စစ်သားရို့ ဤသို့ ပြုလုပ်ကြခြင်း ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ယေသျှု၏အမိ မာရိ၊ မယ်တော်မာရိ၏ညီမဖြစ်သူ ကလောဖ၏မယား မာရိနှင့် မာဂဒလရွာသူ မာရိရို့သည် ယေသျှု၏ လက်ဝါးကပ်တိုင်နားတွင် ရပ်လျက်ဟိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ယေသျှုသည် ထိုနီရာ၌ မတ်တပ်ရပ်နိန်ကြသည့် သူ၏မိခင်နှင့် သူချစ်သော တပည့်တော် တစ်ယောက်ကို မြင်သောအခါ ကိုယ်တော်က မယ်တော်အား “သူသည် မယ်တော်၏သားဖြစ်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ထို့နောက် ဤတပည့်တော်အား “ထိုမိန်းမသည် သင်၏အမိ ဖြစ်၏” ဟု မိန့်တော်မူ၏။ ထိုအချိန်မှစ၍ ဤတပည့်တော်က မယ်တော်အား မိမိအိမ်၌ နီထိုင်ရန် ခေါ်ဆောင်လားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","ယေသျှုသည် ကျမ်းစာပြည့်စုံစီခြင်းငှာ အလုံးစုံကို လုပ်ဆောင်ပြီးဖြစ်ကြောင်းကို သိတော်မူ၍ “ငါ ရီသောက်ငတ်တေ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ထိုနီရာတွင် ပုံးရည် အပြည့်ထည့်ထားသော အိုးတစ်လုံး ဟိ၏။ ရီမြုပ်တစ်ခုကို ယူ၍ ထိုအနား၌ဟိသော ပုံးရည်အိုးထဲတွင် နှိုက်ပြီးလျှင် ထိုရီမြှုပ်ကို ဟုဿုပ်ပင် အကိုင်းဖျားမှာ တပ်၍ ကိုယ်တော်၏နှုတ်ခမ်းကို ကပ်၍ ထားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ယေသျှုသည် ထိုပုံးရည်ကို သောက်တော်မူပြီးမှ “အမှုပြီးပြီ” ဟု နှုတ်မှ မြွက်ဆိုလေ၏။ ထို့နောက် ဦးဂေါင်းကို ငိုက်စိုက်ချကာ မိမိ၏အသက်တော်ကို စွန့်တော်မူလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","ထိုနိ့သည် အဖိတ်နိ့ဖြစ်၏။ နောက်တစ်နိ့သည် မြင့်မြတ်သော ဥပုသ်နိ့ဖြစ်သဖြင့် ထိုနိ့တွင် လူသီအလောင်းများကို လက်ဝါးကပ်တိုင်၌ မဟိစီခြင်းငှာ ယုဒလူမျိုးအာဏာပိုင်များက လက်ဝါးကပ်တိုင်မှာ တင်၍ သတ်ထားခြင်းခံရသောသူများ၏ ခြီထောက်ကို ချိုး၍ လက်ဝါးကပ်တိုင်မှ ချခွင့်ပီးရန် ပိလတ်မင်းထံ တောင်းလျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ထို့ကြောင့် စစ်သားရို့သည် လာ၍ ယေသျှုနှင့်အတူ လက်ဝါးကပ်တိုင်၌ သတ်ထားသည့် လူနှစ်ယောက်အား တစ်ယောက်ပြီးတစ်ယောက် ခြီထောက်ကို သတ်၍ ချိုးကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","သူရို့သည် ယေသျှုအပါးသို့ ရောက်သည့်အခါ ကိုယ်တော်သည် သီနိန်ပြီးဖြစ်ကြောင်းကို မြင်တွိ့ကြသည်ဖြစ်၍ ကိုယ်တော်၏ခြီထောက်ကို မချိုးဘဲ ထားခကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","စစ်သားတစ်ယောက်သည် ယေသျှု၏နံဘေးကို လှံနှင့် ထိုးလိုက်သဖြင့် သွီးနှင့် ရီသည် ချက်ချင်း ထွက်ကျလာ၏။ ");
INSERT INTO rki_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","သင်ရို့သည် ယုံကြည်စီခြင်းငှာ ဤအဖြစ်အပျက်ကို ကိုယ်တိုင် မြင်တွိ့ခသော သူတစ်ယောက်က ဤအကြာင်းကိုပြောခ၏။ သူသည် သမ္မာတရားအကြောင်းကို ပြောသည်ဖြစ်၍ သူ၏သက်သီခံချက်မှာ အမှန်ပင်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","ဤသို့ ဖြစ်ပျက်ခသည်မှာ “သူ၏အရိုး တစ်ချောင်းကိုမျှ မကျိုးစီရ” ဟူသော ကျမ်းစာသည် အမှန်ပင် ပြည့်စုံလာခြင်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ပြီးနောက် အခြားကျမ်းစာ တစ်ပိုဒ်တွင် “ထိုသူရို့သည် သူရို့၏လှံဖြင့် ထိုးထားသောသူကို ကြည့်ကြလိမ့်မည်” ဟု ဟောထား၏။ ");
INSERT INTO rki_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","ထို့နောက် အရိမဿဲမြို့သားတစ်ယောက်ဖြစ်သော ယောသပ်သည် ပိလတ်မင်းထံပါးသို့ ဝင်၍ ယေသျှု၏အလောင်းကို ယူခွင့် တောင်းလျှောက်လေ၏။ ပိလတ်မင်းက ယူခွင့်ပီးလိုက်သဖြင့် အလောင်းတော်ကို ယူလားလေ၏။ ယောသပ်သည် ယေသျှု၏ တပည့်တော်တစ်ယောက် ဖြစ်သော်လည်း ယုဒအာဏာပိုင်များကို ကြောက်၍ လျှို့ဝှက်စွာ နီထိုင်သူ တစ်ယောက် ဖြစ်သည်။ ");
INSERT INTO rki_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ယေသျှုနှင့် တွိ့ရန် ညဉ့်အခါ လာရောက်ဖူးသည့် နိကောဒင်သည်လည်း မုရန်နှင့် အကျော် ရောထားသော နံ့သာပေါင်း ပိဿာသုံးဆယ်ခန့်ကို ယူဆောင်ကာ ယောသပ်နှင့်အတူ လိုက်လား၏။ ");
INSERT INTO rki_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","သူရို့နှစ်ယောက်သည် ယေသျှု၏ အလောင်းတော်ကို ယူ၍ သင်္ဂြိုဟ်သည့်အခါ ယုဒလူမျိုးတိ ဓလေ့ထုံးစံဟိသည့်အတိုင်း အမွှီးနံ့သာနှင့်အတူ ပိတ်ချောအဝတ်ဖြင့် ပတ်ရစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ယေသျှုကို လက်ဝါးကပ်တိုင်မှာ တင်ပြီး သတ်သည့်နီရာ၌ ဥယျာဉ်တစ်ခု ဟိလေ၏။ ထိုဥယျာဉ်၌ မည်သူတစ်ဦးတစ်ယောက်ကိုမှ သင်္ဂြိုဟ်ခြင်း မပြုရသိမ့်သော သင်္ချိုင်းဂူအသစ် တစ်ခု ဟိလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ယုဒလူမျိုး၏ အဖိတ်နိ့ဖြစ်သောကြောင့် သူရို့နှစ်ယောက်သည် ယေသျှု၏ အလောင်းတော်ကို ယူ၍ အနီးအနားတွင်ဟိသော ထိုသင်္ချိုင်းဂူထဲ၌ သွင်းထားကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","တလင်းဂနီနိ့ မိုးထက်ဖက် မိုးမလင်းခင်အချိန်တွင် မာဂဒလရွာသူ မာရိသည် သင်္ချိုင်းဂူသို့ ရောက်လားရာ၊ ဂူပေါက်ဝ၌ ပိတ်ထားသော ကျောက်တုံးသည် ရွိ့လျက်ဟိသည်ကို မြင်တွိ့လေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","သူမသည် သျှိမုန်ပေတရုနှင့် ယေသျှုချစ်သော တပည့်တော်ပါးသို့ ဗြီးလား၍ “သူရို့သည် သခင်ဘုရားအလောင်းကို သင်္ချိုင်းဂူထဲက ထုတ်ယူလားခယာ၊ ဇာနီရာမှာ ထားကြသည်ကို အကျွန်ရို့ မသိပါ” ဟု ပြော၏။ ");
INSERT INTO rki_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ထို့နောက် ပေတရုနှင့် တခြားသော တပည့်တော်တစ်ယောက်သည် သင်္ချိုင်းဂူသို့ လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","နှစ်ယောက်သား အဗြီးအလွှား လားကြ၏။ သို့ရာတွင် ထိုအခြားသော တပည့်တော်တစ်ယောက်သည် သင်္ချိုင်းဂူသို့ ပေတရုထက် ရှိ့က ရောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","သူသည် သင်္ချိုင်းဂူကို ငုံ့ကြည့်သောအခါ အလောင်းကို ပတ်ရစ်ထားသည့် ပိတ်ချောကိုသာ တွိ့မြင်၏။ သို့သော် ဂူအတွင်းသို့ မဝင်ဘဲနိန်၏။ ");
INSERT INTO rki_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","သူ၏နောက်က ရောက်လာသော သျှိမုန်ပေတရုသည် ဂူထဲသို့ တန်း၍ ဝင်လေ၏။ သူသည် အလောင်းကို ပတ်ရစ်ထားသော ပိတ်ချောစကိုလည်းကောင်း၊ ");
INSERT INTO rki_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ယေသျှု၏ ဂေါင်းမှာ ပေါင်းထားသည့် အဝတ်သည် ပိတ်ချောစနှင့် အတူမဟိဘဲ တခြားစီ လိပ်လျက် ဟိသည်ကိုလည်းကောင်း တွိ့ရ၏။ ");
INSERT INTO rki_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","သင်္ချိုင်းဂူသို့ အယင်ရောက်သော တပည့်တော်သည်လည်း ဂူထဲသို့ ဝင်ကြည့်သောအခါမှ မြင်ရသည်ဖြစ်၍ ယုံလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","ကိုယ်တော်သည် သီဆုံးခြင်းက ထမြောက်ရမည်ဆိုသော ကျမ်းစာကို သူရို့သည် နားမလည်ကြသိမ့်ပေ။ ");
INSERT INTO rki_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","ထို့နောက် တပည့်တော်ရို့သည် အိမ်သို့ ပြန်လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","မာရိသည် သင်္ချိုင်းဂူအပြင်၌ ငိုလျက် ရပ်နိန်၏။ သူမသည် ငိုလျက် ဂူထဲသို့ ငုံ့ကြည့်သောအခါ ");
INSERT INTO rki_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","အဖြူရောင်ဝတ်ထားသော ကောင်းကင်တမန်နှစ်ပါးသည် ယေသျှု အလောင်းထားသည့်နီရာ၏ ဂေါင်းရင်း၌ တစ်ပါး၊ ခြီရင်း၌တစ်ပါး ထိုင်လျက် ဟိကြသည်ကို မြင်၏။ ");
INSERT INTO rki_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","သူရို့က “အို မိန်းမ၊ သင်သည် ဇာကြောင့် ငိုနိန်သနည်း” ဟု မိန်းကြသော်၊ “အကျွန်၏ သခင်ဘုရားကို ယူလားကြသောသူရို့သည် ထိုအသျှင်အား ဇာနီရာမှာ ထားသည်ကို အကျွန် မသိလို့ပါ” ဟု သူမက ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ထို့နောက် သူမသည် လှည့်ကြည့်လိုက်သောအခါ မတ်တပ်ရပ်နိန်သော ယေသျှုကို မြင်လေ၏။ သို့သော်လည်း သူမက ယေသျှုဖြစ်သည်ကို မသိ။ ");
INSERT INTO rki_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","“အသင် မိန်းမ၊ ဇာဖြစ်လို့ ငိုနိန်သနည်း၊ ဇာသူ့ကို ရှာနိန်သနည်း” ဟု ယေသျှုက မိန်း၏။ သူမသည် ကိုယ်တော့်ကို ဥယျာဉ်စောင့်တစ်ယောက်ဖြစ်သည်ဟု ထင်မှတ်လျက် “ဆရာ၊ သင်သည် သူ့ကို ယူလားသောသူဖြစ်လျှင် ဇာနီရာမှာ ထားသည်ကို အကျွန့်ကို ပြောပြပါ၊ အကျွန်သည် သူ့ကို လား၍ ယူပါမည်” ဟု ပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","ယေသျှုက သူမအား “မာရိ” ဟု ခေါ်လိုက်၏။ မာရိကလည်း ကိုယ်တော်ဖက်သို့ လှည့်၍ ဟေဗြဲဘာသာစကားအားဖြင့် “ရဗ္ဗနိ့” ဟု ထူးလေ၏။ “ရဗ္ဗနိ့” ဆိုသည်မှာ “ဆရာ” ဟူ၍ အဓိပ္ပာယ်ရ၏။ ");
INSERT INTO rki_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","“ငါသည် အဖထံပါးသို့ မတက်ရသိမ့်ဖြစ်၍ ငါ့ကို မဖက် ကေ့ဦး။ သို့သော်လည်း ငါသည် ငါ၏အဖတည်းဟူသော သင်ရို့၏အဖနှင့် ငါ၏ဘုရားသခင်တည်းဟူသော သင်ရို့၏ ဘုရားသခင်ပါးသို့ တက်ရဦးမည်အကြောင်းကို ငါ၏ညီအစ်ကိုတိပါးသို့ လား၍ ပြောပြလော့” ဟု ယေသျှုက မာရိအား ပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ထို့နောက် မာဂဒလရွာသူ မာရိသည် တပည့်တော်တိပါးသို့ လားပြီးလျှင် သူမသည် သခင်ဘုရားကို တွိ့မြင်ခသည်ကိုလည်းကောင်း၊ ကိုယ်တော်က သူမအား မည်သို့ မိန့်မှာလိုက်သည်ကိုလည်းကောင်း သူရို့ကို ပြောပြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","အချိန်ကား တလင်းဂနီနိ့၏ မိုးချုပ်စချိန် ဖြစ်၏။ ယုဒအာဏာပိုင်တိကို ကြောက်၍ တပည့်တော်ရို့သည် တန်းခါး ပိတ်ကာ အတူတကွ စုရုံးလျက် နိန်ကြ၏။ ထိုအခါ ယေသျှုသည် ဝင်ရောက်လာ၍ တပည့်တော်တိကြား၌ မတ်တပ်ရပ်ပြီးလျှင် “သင်ရို့၌ ငြိမ်သက်ခြင်းဟိပါစီသောဝ်” ဟု နှုတ်ဆက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ယေသျှုသည် ထိုသို့ မိန့်တော်မူပြီးနောက် သူ၏လက်ဝါးနှင့် သူ၏နံဘေးကို သူ၏တပည့်တော်တိအား ပြ၏။ တပည့်တော်ရို့သည် သခင်ဘုရားကို မြင်ရ၍ အလွန်ဝမ်းမြောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ယေသျှုက “သင်ရို့၌ ငြိမ်သက်ခြင်း ဟိပါစီသောဝ်” ဟု တဖန် နှုတ်ဆက်ပြီးလျှင် “အဖ က ငါ့ကို စီရွှတ်သကဲ့သို့ သင်ရို့ကိုလည်း ငါစီရွှတ်လိုက်၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ထို့နောက် သူရို့အထက်၌ မှုတ်တော်မူလျက် “သန့်ယှင်းသောဝိညာဉ်တော်ကို ခံယူကြလော့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","“သင်ရို့သည် လူရို့၏အပြစ်ကို လွှတ်လျှင် ထိုသူရို့သည် အပြစ်မှ လွှတ်ခြင်းကို ခံရလိမ့်မည်၊ သင်ရို့သည် လူရို့၏အပြစ်ကို မလွှတ်လျှင် ထိုသူရို့သည်လည်း အပြစ်မှ မလွတ်ကြ” ဟု မိန့်မှာတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ယေသျှု ကြွလာတော်မူသောအခါ တပည့်တော်တစ်ဆယ့်နှစ်ပါးထဲက တစ်ပါးဖြစ်သော အမြွှာဟုခေါ်သည့် သောမသည် သူရို့နှင့်အတူ မဟိပေ။ ");
INSERT INTO rki_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ထို့ကြောင့် “ငါရို့သည် သခင်ဘုရားကို တွိ့ပြီးပြီ” ဟု အခြားသောတပည့်တော်တိက သူ့ကို ပြောကြသောအခါ သောမ က “ကိုယ်တော်၏ လက်ဝါးနှစ်ဖက်၌ ဟိသော သံမှုတ်ဒဏ်ရာကို ငါ့လက်ဖျားနှင့် မထိရ၊ ကိုယ်တော်၏နံဘေးမှာဟိသော ဒဏ်ရာကို ကိုယ်တိုင် လက်နှင့် မစမ်းရလျှင် အကျွန်သည် ယုံကြည်လိမ့်မည် မဟုတ်ပါ” ဟု ပြော၏။ ");
INSERT INTO rki_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","တစ်ပတ်ကြာပြီးနောက် တပည့်တော်ရို့သည် အိမ်ထဲ၌ တဖန် အတူတကွ စုရုံးကြ၏။ သူရို့နှင့်အတူ သောမလည်း ပါ၏။ အိမ်တန်းခါးများကို ပိတ်ထားကြသော်လည်း ယေသျှုသည် ဝင်ရောက်လာပြီးလျှင် သူရို့အလယ်တွင် မတ်တပ်ရပ်လျက်၊ “သင်ရို့၌ ငြိမ်သက်ခြင်းဟိပါစီသောဝ်” ဟု နှုတ်ဆက်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ထို့နောက် ကိုယ်တော်က သောမအား “သင်၏လက်ချောင်းဖြင့် ငါ၏လက်ဖဝါးတိကို စမ်းကြည့်လော့။ သင်၏လက်ကိုဆန့်၍ ငါ၏နံဘေးကို စမ်းကြည့်လော့။ သံသယကင်းစွာဖြင့် ငါ့ကို ယုံကြည်လော့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ထိုအခါ သောမသည်လည်း “ကိုယ်တော်သည် အကျွန်၏အသျှင်၊ အကျွန်၏ ဘုရားသခင် ပါတကား” ဟု လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ယေသျှုက သောမအား “သင်သည် ငါ့ကို မြင်ရသောကြောင့် ယုံကြည်သလော။ ငါ့ကို မမြင်ဘဲ ယုံကြည်သောသူသည် မင်္ဂလာဟိ၏” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ယေသျှုသည် ဤစာအုပ်၌ ရီးမထားသော တခြားသော နိမိတ်လက္ခဏာများစွာကို သူ၏တပည့်တော်တိ ရှိ့၌ ပြခ၏။ ");
INSERT INTO rki_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","သို့သော်လည်း ယေသျှုသည် မေသျှိယတည်းဟူသော ဘုရားသခင်၏သားတော် ဖြစ်သည်ကို ယုံကြည်ကြစီခြင်းငှာလည်းကောင်း၊ ထိုသို့ယုံကြည်ခြင်းအားဖြင့် ကိုယ်တော်၏နာမတော်မြတ်၌ အသက်ကို ရစီခြင်းငှာ လည်းကောင်း ဤအရာများကို ရီးထားခြင်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ထိုသို့ ဖြစ်ပျက်ပြီးနောက် ယေသျှုသည် တပည့်တော်တိအား တိဗေရိအိုင်တွင် နောက်တဖန် ကိုယ်ထင်ပြတော်မူခ၏။ ပြတော်မူသည်မှာ ဤသို့ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","သျှိမုန်ပေတရုနှင့် အမြွှာပူးဟု ခေါ်သည့် သောမ၊ ဂါလိလဲပြည် ကာနမြို့သား နာသနေလ၊ ဇေဗေဒဲ၏ သားများနှင့် အခြားသော ယေသျှု၏တပည့်တော်နှစ်ယောက်သည်လည်း အတူတကွ ဟိနိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","သျှိမုန်ပေတရုက “အကျွန် ငါးဖမ်း လားဖို့ယာ” ဟု ပြောသောအခါ၊ တခြားလူတိက “သင်နှင့်အတူ အကျွန်ရို့လည်း လိုက်ပါဖို့” ဟု ဆို၍ သူရို့သည် လောင်းတစ်စီးဖြင့် ထွက်လာကြ၏။ သို့ရာတွင် သူရို့သည် ထိုညတွင် ဇာတစ်ခုမျှ မရကြပေ။ ");
INSERT INTO rki_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","မိုးလင်းလာသောအခါ ယေသျှုသည် ရီကမ်းစပ်နားတွင် ရပ်နိန်တော်မူ၏။ သို့သော်လည်း တပည့်တော်တိက ယေသျှုဖြစ်သည်ကို မသိကြ။ ");
INSERT INTO rki_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","ထိုအခါ ကိုယ်တော်က “မိတ်ဆွီရို့ ငါး မရကြသလော” ဟု သူရို့အား မိန်း၏။ “တစ်ခုလည်း မရပါ” ဟု သူရို့က ပြန်ပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ကိုယ်တော်က “သင်ရို့၏ပိုက်ကို လောင်း၏ညာဖက်မှာ ချကြလော့၊ ငါးတိ ရလာလိမ့်မည်” ဟု မိန့်တော်မူသည့်အတိုင်း သူရို့သည် ပိုက်ကို ချကြသောအခါ များစွာသော ငါးတိကို ဖမ်းမိသောကြောင့် ပိုက်ကိုပင် ဆွဲ၍ မတင်နိုင်ကြပေ။ ");
INSERT INTO rki_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","ယေသျှု ချစ်သောတပည့်တော်က “သခင်ဘုရား ဖြစ်ပေ၏” ဟု ပေတရုအား ပြောလေ၏။ “သခင်ဘုရား ဖြစ်ပေ၏” ဟူသောစကား သျှိမုန်ပေတရုသည် ကြားလျှင်ကြားချင်း အဝတ်မဝတ်ဘဲ၊ အပြင်အင်္ကျီကို မိမိကိုယ်၌ ပတ်စည်းကာ ရီထဲသို့ ခုန်ဆင်းလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","အခြားသော တပည့်တော်ရို့သည် ငါးများနှင့် ပြည့်နိန်သော ပိုက်ကို လက်လံငါးဆယ်လောက် ကွာဝီးသည့်နီရာက လောင်းဖြင့် ဆွဲ၍ ကမ်းခြီသို့ လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","သူရို့သည် ကမ်းခြီသို့ ရောက်ကြသောအခါ မီးကျီးခဲမီးဖိုကိုလည်းကောင်း၊ ကင်ထားသော ငါးများကိုလည်းကောင်း၊ မုန့်တချို့ကိုလည်းကောင်း တွိ့ကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ယေသျှုကလည်း “သင်ရို့ အဂု ဖမ်းမိသော ငါးတချို့ကို ယူခကြလော့” ဟု သူရို့အား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","သျှိမုန်ပေတရုသည် လောင်းထက်သို့ ပြန်၍ တက်ပြီးလျှင် ငါးကြီး ၁၅၃ ကောင်နှင့် ပြည့်နိန်သည့် ပိုက်ကွန်ကို ကုန်းထက်သို့ ဆွဲတင်လာ၏။ ငါးများသော်လည်း ပိုက်ကွန်သည် စုတ်ပြဲခြင်းမဟိပေ။ ");
INSERT INTO rki_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","ယေသျှုက “လာ၍ စားကြလော့” ဟု တပည့်တော်ရို့အား မိန့်တော်မူ၏။ တပည့်တော်တိကလည်း သခင်ဘုရား ဖြစ်တော်မူကြောင်းကို သိကြသောကြောင့် “သင်ကား ဇာသူဖြစ်သနည်း” ဟု မည်သူမျှ မမိန်းဝံ့ကြပေ။ ");
INSERT INTO rki_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ယေသျှုသည်လာ၍ မုန့်ကို ယူပြီးလျှင် တပည့်တော်တိကို ပီးတော်မူ၏။ ထိုနည်းတူ ငါးကိုလည်း ပီးတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ဤကား ယေသျှုသည် သီခြင်းက ထမြောက်ပြီးနောက် တပည့်တော်တိအား သုံးကြိမ်မြောက် ကိုယ်ထင်ပြတော်မူခြင်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","သူရို့သည် စားပြီးကြသောအခါ ယေသျှုက သျှိမုန်ပေတရုအား “ယောဟန်၏သား သျှိမုန် သင်သည် ဤအရာတိထက် ငါ့ကို ပို၍ ချစ်သလော” ဟု မိန်းသော်၊ “ချစ်ပါ၏ အသျှင်၊ အကျွန်သည် ကိုယ်တော့်အား ချစ်သည်ကို ကိုယ်တော်သိပါ၏” ဟု ပြောလေ၏။ ယေသျှုက “ငါ၏သိုးငယ်တိကို စောင့်ရှောက်လော့” ဟု သျှိမုန်ပေတရုအား မိန့်မှာတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","တဖန် ယေသျှုက “ယောဟန်၏သား သျှိမုန် သင်သည် ငါ့ကို ချစ်သလော” ဟု ဒုတိယအကြိမ် မိန်းတော်မူပြန်၏။ သျှိမုန်ပေတရုက “ချစ်ပါ၏ အသျှင်၊ အကျွန်သည် ကိုယ်တော့်အား ချစ်သည်ကို ကိုယ်တော်သိပါ၏” ဟု လျှောက်သော်၊ ယေသျှုက “ငါ့ သိုးတိကို စောင့်ရှောက်လော့” ဟု သျှိမုန်ပေတရုအား မိန့်မှာတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ယေသျှုက “ယောဟန်သား သျှိမုန် သင်သည် ငါ့ကို ချစ်သလော” ဟု တတိယအကြိမ် မိန်းတော်မူပြန်၏။ ယေသျှုက “သင်သည် ငါ့ကို ချစ်သလော” ဟု သူ့အား သုံးကြိမ် သုံးလီ မိန်းလာသောကြောင့် ပေတရုသည် ဝမ်းနည်းလာ၏။ ထို့ကြောင့် သူသည် ကိုယ်တော့်ကို “အသျှင်၊ ကိုယ်တော်သည် အလုံးစုံကို သိတော်မူ၏၊ ကိုယ်တော့်ကို အကျွန် ချစ်သည်ကို ကိုယ်တော်သိပါ၏” ဟု လျှောက်လေ၏။ ယေသျှုက “ငါ၏ သိုးတိကို စောင့်ရှောက်လော့။ ");
INSERT INTO rki_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ငါအမှန် ဆိုသည်ကား၊ သင်သည် အသက်အရွယ် နုပျိုသောအခါ သင်၏ ခါးပတ်ကို ပတ်စည်း၍ သင်လားချင်သော အရပ်ကို လားနိုင်သော်လည်း အသက်အရွယ် ကြီးလာသောအခါ သင်၏ လက်နှစ်ဖက်ကို ဆန့်၍ လူတချို့က သင့်ကို ပတ်စည်းပြီးလျှင် သင် မလားချင်သောအရပ်သို့ ပို့ဆောင်ကြလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ဤကား ပေတရုသည် မည်သို့ သီရမည်ကိုလည်းကောင်း၊ ဘုရားသခင်၏ဘုန်းတော်ကို မည်သို့ ထင်ရှားလိမ့်မည်ကိုလည်းကောင်း မိန့်တော်မူခြင်းဖြစ်၏။ ထို့နောက် ယေသျှုက ပေတရုအား “ငါ့နောက်သို့ လိုက်လော့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ပေတရုသည် နောက်ကို လှည့်၍ ကြည့်လိုက်သောအခါ ယေသျှု ချစ်သော တပည့်တော်သည် သူရို့ နောက်မှ လိုက်လာသည်ကို မြင်လေ၏။ ထိုသူသည် တစ်ချိန်က ညစာ စားကြသောအခါ သခင်ဘုရား၌ မှီလျက် “သခင်ဘုရားကို ဇာသူက သစ္စာဖောက်လိမ့်မည်နည်း” ဟု မိန်းသော တပည့်တော်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ပေတရုက သူ့ကို မြင်သောအခါ “အသျှင်ဘုရား၊ ဤသူကား ဇာပိုင် ဖြစ်လိမ့်မည်နည်း” ဟု ယေသျှုအား မိန်းလျှောက်၏။ ");
INSERT INTO rki_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ယေသျှုက “ငါ ကြွလာသည့်တိုင်အောင် သူ့ကို အသက်ရှင်စီခြင်းငှာ ငါ အလိုဟိလျှင် သင်နှင့် ဇာဆိုင်လဲ၊ သင်မူကား ငါ့နောက်သို့ လိုက်လော့” ဟု ပေတရုအား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","ထို့ကြောင့် ဤတပည့်တော်သည် မသီ ဟူသော သတင်းသည် ယေသျှု၏နောက်လိုက်တိပါးသို့ ပြန့်နှံ့လားလေ၏။ သို့သော် ထိုသူ မသီ ဟု ကိုယ်တော်က ပြောခြင်း မဟုတ်ပေ။ “ငါ ကြွလာသည့်တိုင်အောင် သူ့အား အသက်ရှင်စီခြင်းငှာ ငါအလိုဟိလျှင် သင်နှင့် ဇာဆိုင်လဲ” ဟု ကိုယ်တော်က မိန့်တော်မူခခြင်း ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ထိုတပည့်တော်ကား ဤအကြောင်းအရာများကို သက်သီခံ၍ ရီးထားခသောသူ ဖြစ်၏။ သူ၏ သက်သီခံချက် မှန်သည်ကို ငါရို့ သိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","အဂုတွင် ယေသျှုပြုတော်မူခသော အကြောင်းအရာများစွာ ဟိသိမ့်၏။ ဤအကြောင်းအရာ ဟိသမျှကို တစ်ခုပြီးတစ်ခု ရီးသားမည်ဆိုလျှင် စာအုပ်များသည် လောကတစ်ခုလုံး မဆန့်နိုင်အောင် များပြားပေလိမ့်မည်ဟု အကျွန် ထင်မြင်မိပါ၏။");
INSERT INTO rki_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","အဆွီ သော်ဖိလု၊ ယေသျှုသည် အမှုတော်ဆောင်ရွက်ခြင်းနှင့် သွန်သင်ခြင်းတိကို အစပြုတော်မူသည့်အချိန်မှစ၍၊ ");
INSERT INTO rki_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ရွီးကောက်တော်မူသော တမန်တော်တိကို သန့်ယှင်းသောဝိညာဉ်တော်အားဖြင့် မိန့်မှာတော်မူပြီးနောက် အထက်သို့ ဆောင်ယူခြင်း ခံတော်မူသောနိ့တိုင်အောင် ဖြစ်ပျက်သမျှတိကို ပထမစာစောင်၌ ငါရီးသားဖော်ပြခ၏။ ");
INSERT INTO rki_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ကိုယ်တော်သည် အသီခံတော်မူပြီးနောက် ရက်ပေါင်းလေးဆယ်တိုင်အောင် တမန်တော်ရို့အား မိမိအသက်ရှင်တော်မူကြောင်းကို ခိုင်လုံသော သက်သီအားဖြင့် အကြိမ်ပေါင်းများစွာ ဖော်ပြတော်မူ၏။ တမန်တော်ရို့သည် ကိုယ်တော့်ကို တွိ့မြင်ကြရပြီး၊ ကိုယ်တော်ကလည်း သူရို့အား ဘုရားသခင်၏ နိုင်ငံတော်အကြောင်းကို ဟောပြောသွန်သင်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","သူရို့သည် စုရုံးလာကြသောအခါ ကိုယ်တော်က “ယေရုဆလင်မြို့မှ ထွက်မလားကတ်ကေ့။ ငါ၏ခမည်းတော် ကတိပီးထားတော်မူခသော ဆုကျေးဇူးတိကို စောင့်မျှော်နိန်ကြလော့။ ထိုကတိတော်အကြောင်းကို အယင်က သင်ရို့ကို ငါဖော်ပြထားပြီးဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","ယောဟန်က ရီ၌ ဗတ္တိဇံကို ပီး၏။ သို့သော် သင်ရို့သည် ရက်အင်တန်ကာလအတွင်း သန့်ယှင်းသောဝိညာဉ်တော်၌ ဗတ္တိဇံကို ခံရကြလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","တမန်တော်ရို့သည် ယေသျှုနှင့် အတူတကွ တွိ့ဆုံကြသောအခါ “အသျှင်၊ ဤအချိန်၌ ဣသရေလလူမျိုးတိအတွက် နိုင်ငံတော်ကို ပြန်ပီးတော်မူပါမည်လော့” ဟု မိန်းလျှောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ယေသျှုက “ခမည်းတော်က မိမိ၏ အခွင့်အာဏာဖြင့် ဖြစ်လာမည့် အချိန်ကာလနှင့် နိ့ရက်များကို သင်ရို့ သိပိုင်ခွင့်မဟိ။ ");
INSERT INTO rki_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","သို့ရာတွင် သင်ရို့အထက်၌ သန့်ယှင်းသောဝိညာဉ်တော် ဆင်းသက်လာသောအခါ၊ သင်ရို့သည် တန်ခိုးဖြင့် ပြည့်ဝပြီးလျှင် ယေရုဆလင်မြို့မှစ၍ ယုဒပြည်တစ်ခုလုံး၊ ယှာမာရိပြည်နှင့် ကမ္ဘာမြီကြီးအစွန်းတိုင်အောင် ငါ၏သက်သီဖြစ်ကြလိမ့်မည်” ဟု သူရို့အား မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ဤသို့ မိန့်တော်မူပြီးနောက် တမန်တော်ရို့ ကြည့်လျက်နိန်ကြစဉ် ကိုယ်တော်သည် ကောင်းကင်ဘုံသို့ ချီဆောင်ခြင်းကို ခံတော်မူ၍ မိုးတိမ်သည် ကိုယ်တော့်ကို ဖုံးကွယ်သဖြင့် သူရို့ မမြင်ရပေ။ ");
INSERT INTO rki_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ထိုသို့ ကိုယ်တော် ကြွတော်မူစဉ် တမန်တော်ရို့သည် အာကာပြင်သို့ စိ့စိ့ကြည့်နိန်ကြ၏။ ထိုအခါ ဝတ်ဖြူစင်ကြယ်နှင့် လူနှစ်ယောက်သည် သူရို့အနားတွင် ရုတ်တရက် ရပ်လာပြီးလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","“ဂါလိလဲပြည်သားရို့၊ ဇာဖြစ်လို့ ရပ်လျက် အာကာပြင်ကို ကြည့်နိန်ကြသနည်း။ ယေသျှုသည် သင်ရို့ပါးမှ ကောင်းကင်ဘုံသို့ ချီဆောင်ခြင်းကို ခံတော်မူသည်ကို သင်ရို့ မြင်ရသည့်နည်းတူ ကောင်းကင်မှ တဖန် ကြွလာတော်မူလိမ့်မည်” ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ထို့နောက် တမန်တော်ရို့သည် သံလွင်တောင်မှ မိုင်ဝက်ခန့်ဝီးသော ယေရုဆလင်မြို့သို့ ပြန်လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","သူရို့သည် မြို့ထဲသို့ဝင်၍ မိမိရို့တည်းခိုသော အိမ်အထက်ခန်းသို့ တက်ကြ၏။ ထိုသူရို့ကား သျှိမုန်ပေတရု၊ ယောဟန်၊ ယာကုပ်၊ အန္ဒြေ၊ ဖိလိပ္ပု၊ သောမ၊ ဗာသောလမဲ၊ မဿဲ၊ အာလဖဲ၏သား ယာကုပ်၊ မျိုးချစ်စိတ်ထက်သန်သူသျှိမုန်နှင့် ယာကုပ်၏သား ယုဒရို့ဖြစ်ကြ၏၊ ");
INSERT INTO rki_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","သူရို့သည် ယေသျှု၏ မယ်တော်မာရိ အပါအဝင် မိန်းမတချို့နှင့် လည်းကောင်း၊ ကိုယ်တော်၏ ညီတော်များနှင့် လည်းကောင်း၊ မကြာမကြာ စုရုံး၍ အတူတကွ ဆုတောင်းလျက်နိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","ရက်အင်တန်ကြာပြီးနောက် ၁၂၀ ခန့် ဟိသော ယုံကြည်သူရို့ စုဝေးနိန်ကြစဉ် ပေတရုသည် စကားပြောရန် ထ၍၊ ");
INSERT INTO rki_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“ညီအစ်ကိုမောင်နှမရို့၊ ယေသျှုကို ဖမ်းဆီးဖို့ လမ်းပြသူ ယုဒသျှာကရုတ်ကို ရည်မှတ်၍ သန့်ယှင်းသောဝိညာဉ်တော်က ဒါဝိဒ်အားဖြင့် ကျမ်းစာတော်မြတ်၌ ဖော်ပြခသည့်အတိုင်း အမှန်ပင် ပြည့်စုံရမည်။ ");
INSERT INTO rki_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ယုဒသျှာကရုတ်သည် ငါရို့အဖွဲ့ထဲက အဖွဲ့ဝင်တစ်ယောက်ဖြစ်ခ၏။ အကြောင်းမူကား သူသည် ငါရို့နှင့်အတူ အမှုတော်ဆောင်ရန် ရွီးချယ်ခံထားသူ ဖြစ်ခ၏” ဟု ဟောပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","ယုဒသည် မတရားသဖြင့် ရသောငွီဖြင့် မြီတစ်ကွက်ကို ဝယ်ပြီးနောက် ထိုမြီကွက်တွင် လဲကျပြီး သီဆုံးကာ ဝမ်းပေါက်၍ အူများထွက်ကျလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ယေရုဆလင်မြို့၌ နီထိုင်သမျှသောသူ အပေါင်းရို့သည် ထိုအကြောင်းကို ကြား၍ ထိုမြီကွက်ကို မိမိရို့ ဘာသာစကားဖြင့် အကေလဒမဟု ခေါ်ဆိုကြ၏။ ၎င်း၏အနက်ကား “သွီးမြီ” ဟူ၍ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“ဆာလံကျမ်းစာ၌၊ “ ‘သူ၏ အိမ်သည် လူကင်းမဲ့သောအိမ် ဖြစ်ပါစီ၊’ ‘ထိုအိမ်၌ နီထိုင်သူ တစ်ယောက်လည်း မဟိပါစီကေ့။’ ‘သူ၏ အရိုက်အရာကိုလည်း တခြားသူ ယူပါစီ’ ဟု ရီးသားထားပါ၏။ ");
INSERT INTO rki_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“ထို့ကြောင့်၊ အသျှင်ယေသျှုသည် ငါရို့ပါး၌ ဝင်ထွက်လားလာသည့် အချိန်တလျှောက်လုံး ငါရို့နှင့်အတူ နီထိုင်ခသူတစ်ဦး ဖြစ်ရမည်၊ ");
INSERT INTO rki_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ထိုသူသည် ယောဟန်၏ ဗတ္တိဇံတရားအကြောင်းကို ဟောပြောနိန်သည့် အချိန်မှစ၍ ယေသျှုကို အကျွန်ရို့ပါးမှ ကောင်းကင်ဘုံသို့ ချီဆောင်ခြင်းကို ခံတော်မူချိန်ထိတိုင်အောင် ငါရို့နှင့်အတူ နီထိုင်ခသူတစ်ဦး ဖြစ်ရမည်။ ကိုယ်တော်၏ ရှင်ပြန်ထမြောက်ခြင်းအကြောင်းကို ငါရို့နှင့်အတူ သက်သီခံဖို့ရန် လူတစ်ယောက်ဖြစ်ရမည်” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","ထို့ကြောင့် တပည့်တော်ရို့သည် လူနှစ်ယောက်ကို အဆိုပြုကြ၏။ ထိုသူနှစ်ယောက်သည်ကား ဗာသျှဗဟု ခေါ်သော ယုတ္တု အမည်သစ်ကိုရသော ယောသပ်နှင့် မဿိရို့ ဖြစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","ထို့နောက် တပည့်တော်ရို့သည် “အို အသျှင်ဘုရား၊ ကိုယ်တော်သည် လူတိစိတ်နှလုံးကို သိတော်မူပါ၏။ ဤသူနှစ်ယောက်ထဲက ဇာသူ့ကို ကိုယ်တော်သျှင်က ရွီးချယ်ခန့်ထားတော်မူကြောင်းကို အကျွန်ရို့ကို ဖော်ပြပီးတော်မူပါ။ ");
INSERT INTO rki_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","အကြောင်းမူကား မိမိနှင့် ထိုက်တန်သောအရပ်သို့ ထွက်ခွာလားသော ယုဒ၏နီရာ၌ တမန်တော်တစ်ပါးအဖြစ် အမှုတော်ကို ဆောင်ရွက်ရန် ဖြစ်ပါသည်” ဟု ဆုတောင်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ထို့နောက် သူရို့နှစ်ယောက်ကို မဲဖြင့်ရွီးချယ်ကြရာ မဿိသည် မဲကျသဖြင့် သူ့အား တမန်တော် တစ်ကျိပ်တစ်ပါးရို့နှင့်အတူ တမန်တော်အဖြစ် ရွီးချယ်ခန့်ထားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","ပင်တေကုတ္တေပွဲတော်နိ့ ရောက်သောအခါ ယုံကြည်သူအပေါင်းရို့သည် တစ်နီရာတည်းတွင် စုရုံးနိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ထိုအခါ လီပြင်း တိုက်ခတ်သံနှင့်တူသော အသံသည် အာကာပြင်မှ ရုတ်တရက်ပေါ်လာပြီး တပည့်တော်တိ နီထိုင်ရာအိမ်တစ်ခုလုံးသည် ထိုအသံနှင့် ပြည့်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ထို့နောက် လျှာနှင့်တူသော မီးတောက်များသည် အဖြာဖြာကွဲလျက် သူရို့အသီးသီးအထက်၌ တည်နိန်သည်ကို မြင်ရကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ထိုအခါ ထိုသူအပေါင်းရို့သည် သန့်ယှင်းသောဝိညာဉ်တော်နှင့် ပြည့်ဝပြီးလျှင် ဝိညာဉ်တော်သည် ထိုသူရို့အား အခွင့်ပီးသောကြောင့် အခြားသော ဘာသာစကားများဖြင့် စတင်၍ ပြောဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ထိုကာလတွင် လောက၌ဟိကြသော တိုင်းပြည်အသီသီးမှ လာကြသည့် ဘာသာတရား ကြည်ညိုသူ ယုဒလူမျိုးများသည် ယေရုဆလင်မြို့၌ တည်းခိုနိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ထိုအသံကို ကြားသောအခါ လူအပေါင်းရို့သည် စုရုံးလာကြ၏။ တပည့်တော်ရို့ ဟောပြောချက်များကို လူတိုင်း မိမိဘာသာစကားအားဖြင့် ကြားရသည်ဖြစ်၍ သူရို့သည် အံ့မောကျကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","သူရို့သည် အံ့မောကျကြလျက်၊ “ဤကဲ့သို့ ဟောပြောနိန်ကြသော ဤလူတိကား ဂါလိလဲပြည်သားတိ မဟုတ်ပါလား။ ");
INSERT INTO rki_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","သို့ဖြစ်၍ ငါရို့အသီးသီးသည် ငါရို့၏ ဇာတိဘာသာစကားအတိုင်း ကြားရသည်ကား ဇာပိုင်ဖြစ်သနည်း။ ");
INSERT INTO rki_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","ငါရို့သည် ပါတိပြည်၊ မေဒိပြည်၊ ဧလံပြည်၊ မေသောပေါတာမိပြည်၊ ယုဒပြည်၊ ကပ္ပဒေါကိပြည်၊ ပုန္တုပြည်၊ အာယှိပြည်၊ ");
INSERT INTO rki_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ဖြူဂိပြည်၊ ပမ်ဖုလိပြည်၊ အဲဂုတ္တုပြည်နှင့် ကုရေနေမြို့အနား လိဗုနယ်ပယ်ဒေသတိမှ လာကြသူများ ဖြစ်ကြ၏။ ငါရို့ထဲက တချို့သော သူရို့ကား ရောမမြို့မှ ရောက်လာသော၊ ");
INSERT INTO rki_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ယုဒအမျိုးသားတိနှင့် ယုဒဘာသာသို့ ကူးပြောင်းလာကြသော တခြားလူမျိုးတိ ဖြစ်ကြပြီး၊ ငါရို့ထဲမှ တချို့သည် ကုရေတေပြည်သားနှင့် အာရပ်အမျိုးသားများ ဖြစ်ကြ၏။ သို့သော် ငါရို့သည် ဘုရားသခင်ပြုတော်မူသော ကြီးမြတ်သည့် အမှုများကို ငါရို့ဘာသာစကားဖြင့် သူရို့ ဟောပြောသည်ကို ကြားရယာ” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","သူရို့သည် အံ့မောကျလျက် ဝေခွဲမရဖြစ်ကာ “ဤအမှုအရာကား ဇာသို့သောအမှုအရာ ဖြစ်သနည်း” ဟု အချင်းချင်း ပြောဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","သို့သော် အခြားသူတိက ယုံကြည်သူရို့အား “ဤသူရို့ကား ယစ်မူးနိန်ကြသော သူများဖြစ်ကြ၏” ဟု ကဲ့ရဲ့ပြောဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","ထို့နောက် ပေတရုသည် တစ်ကျိပ်တစ်ပါးသော တမန်တော်ရို့နှင့်အတူ ရပ်လျက် ကျယ်သောအသံဖြင့် လူအစုအဝေးကြီးအား ပြောဆိုသည်မှာ “ယုဒအမျိုးသားရို့နှင့် ယေရုဆလင်မြို့၌ နီထိုင်သူအပေါင်းရို့၊ ငါ့စကားကို နားထောင်ကြလော့။ ဤအမှုအရာတိကို ငါယှင်းပြပါမည်။ ");
INSERT INTO rki_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","အဂုအချိန်ကား မိုးထဖက် ကိုးချက်တီးအချိန်သာ ဟိသိမ့်သည်ဖြစ်၍ သင်ရို့ထင်သည်အတိုင်း ဤသူရို့သည် ယစ်မူးနိန်ကြသည် မဟုတ်။ ");
INSERT INTO rki_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","ဤအရာသည် ပရောဖက်ယောလ ဟောပြောခသောအရာ အမှန်ပင်ဖြစ်၏။ ဟောပြောသော အကြောင်းအရာမူကား၊ ");
INSERT INTO rki_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“ ‘ဘုရားသခင် မိန့်တော်မူသည်ကား နောက်ဆုံးသောနိ့တွင်၊ ငါသည် လူအပေါင်းရို့အထက်၌ ငါ့ဝိညာဉ်တော်ကို သွန်းလောင်းမည်။ သင်ရို့၏ သားသမီးရို့သည် ငါ့နှုတ်ကပါတ်တရားတော်ကို ဟောပြောကြလိမ့်မည်။ သင်ရို့၏ လူငယ်တိ ဗျာဒိတ်ရူပါရုံကို ရကြပြီးလျှင်၊ သင်ရို့၏ လူအိုတိလည်း အိပ်မက်တိကို မြင်မက်ရကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ထိုနိ့ရက်၌ ငါ၏အခိုင်းအစီ ယောက်ျားနှင့် မိန်းမတိအထက်၌ ငါ့ဝိညာဉ်တော်ကို သွန်းလောင်းပြီးလျှင်၊ သူရို့သည် ပရောဖက်ဉာဏ်ဖြင့် ဟောပြောကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","အာကာပြင်ထက်၌ နိမိတ်လက္ခဏာတိကိုလည်းကောင်း၊ အောက်အရပ် မြီကြီးထက်၌ အံ့သြဖွယ်ရာတိ ဖြစ်ကြသော သွီး၊ မီးလျှံ၊ မီးခိုးလုံး စသည်ရို့ကိုလည်းကောင်း ငါပြမည်။ ");
INSERT INTO rki_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","သခင်ဘုရား၏ ထူးမြတ်သောနိ့ မကျရောက်ခင်၊ နီမင်းသည် မှောင်မိုက်အတိ ဖြစ်၍ လသည်လည်း သွီးကဲ့သို့ နီလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ထိုအခါ သခင်ဘုရားထံ ကူညီမစခြင်းကို တောင်းခံကြသောသူမှန်သမျှသည် ကယ်တင်တော်မူခြင်းကို ခံရလိမ့်မည်’ ဟူ၍ ဟောပြောခ၏။ ");
INSERT INTO rki_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“အို၊ ဣသရေလအမျိုးသားရို့၊ ငါ့စကားကို နားထောင်ကြလော့။ နာဇရက်မြို့သား ယေသျှုသည် ဘုရားသခင်၏ အံ့ဖွယ်ရာများနှင့် နိမိတ်လက္ခဏာများကို ပြသခသော ဘုရားသခင်၏ အခွင့်အာဏာရသည့် လူသားတစ်ယောက်ဖြစ်ကြောင်းကို သင်ရို့အား ထင်ရှားစွာ သက်သီပြတော်မူခယာ။ ထိုအရာများသည် သင်ရို့ကြားမှာ ဖြစ်ပျက်ခသည်ကို သင်ရို့ကိုယ်တိုင် သိခကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ဘုရားသခင်သည် ယေသျှုကို သင်ရို့လက်သို့ အပ်နှံလိမ့်မည်ဟု ဆုံးဖြတ်ထားသော မိမိ၏ အကြံအစည်တော်အတိုင်း သင်ရို့သည် မတရားသောသူရို့လက်သို့ အပ်နှံ၍ လက်ဝါးကပ်တိုင်၌ ထိုအသျှင်ကို တင်၍ ကွပ်မျက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","သို့သော်လည်း ဘုရားသခင်သည် ထိုအသျှင်ကို သီခြင်းတရားမှ ထမြောက်စီတော်မူပြီး သီခြင်းတရား၏တန်ခိုးမှ လွတ်မြောက်စီတော်မူ၏။ ဇာကြောင့်ဆိုသော် သီခြင်းတရားသည် ထိုအသျှင်ကို အစဉ်အမြဲ ချုပ်နှောင်ထား၍ မရနိုင်။ ");
INSERT INTO rki_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ထိုအသျှင်နှင့်ပတ်သတ်၍ ဒါဝိဒ်က၊ “ ‘ငါသည် သခင်ဘုရားကို အစဉ်မပြတ် မျက်မှောက်ပြု၏။ ဇာကြောင့်ဆိုသော် ငါသည် ဒုက္ခဆင်းရဲခြင်းမှ ကင်းလွတ်စီရန်၊ ကိုယ်တော်သည် ငါ့အနား၌ ဟိတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ထို့ကြောင့် ငါ၏ စိတ်နှလုံးသည် ပျော်ရွှင်၍၊ ငါ့စကားသည်လည်း ရွှင်မြူးခြင်းနှင့် ပြည့်ဝနိန်၏။ ငါ၏ ခန္ဓာသည်လည်း၊ မျှော်လင့်ခြင်း၌ ခိုလှုံလိမ့်မည်၊ ");
INSERT INTO rki_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ဇာကြောင့်ဆိုသော် ကိုယ်တော်သည် ငါရို့ကို မရဏာနိုင်ငံ၌ စွန့်ပစ်ထားတော်မူသည် မဟုတ်။ ကိုယ်တော်၏ သန့်ယှင်းသူတိကိုလည်း သင်္ချိုင်းတွင်း၌ ပုပ်ပျက်စီတော်မူမည် မဟုတ်။ ");
INSERT INTO rki_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ကိုယ်တော်သည် ငါ့အား အသက်ရှင်ခြင်းလမ်းကို ပြညွှန်တော်မူပြီး၊ ရှိ့တော်၌ ငါ့ကို ဝမ်းမြောက်ခြင်းနှင့် ပြည့်ဝစီတော်မူလိမ့်မည်’ ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“ညီအစ်ကိုမောင်နှမရို့၊ ငါရို့၏ ထင်ရှားသော ရှီးအဖိုးအဖီး ဒါဝိဒ်မင်းကြီးနှင့်ပတ်သတ်၍ ငါသည် သင်ရို့အား အတိအလင်း ပြောပြပါမည်။ သူသည် သီလွန်ပြီး သင်္ဂြိုဟ်ခြင်းကိုခံရလျှင်လည်း သူ၏ သင်္ချိုင်းဂူသည် ဤနိ့တိုင်အောင် ငါရို့အရပ်၌ ဟိသိမ့်၏။ ");
INSERT INTO rki_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","သူသည် ပရောဖက်ဖြစ်၍ ဘုရားသခင်၏ ကတိတော်သည် သူ၌ ဟိကြောင်းကိုသိ၏။ ဘုရားသခင်သည် မိမိကို သျှင်ဘုရင်အဖြစ် ချီးမြှောက်သကဲ့သို့ မိမိ၏သားမြီးတစ်ယောက်ကို မိမိ၏ပလ္လင်ထက်၌ ထိုင်စီမည်ဟု ဘုရားသခင် ကျိန်ဆိုခသော ကတိတော်ကို သိခ၏။ ");
INSERT INTO rki_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","နောင်အခါ၌ ဘုရားသခင်က ဇာသို့ပြုတော်မူမည်ကို ဒါဝိဒ်သည် မြင်ခပြီး ခရစ်တော်၏ ရှင်ပြန်ထမြောက်ခြင်း အကြောင်းနှင့်ပတ်သတ်၍၊ “ ‘ကိုယ်တော့်ကို မရဏာနိုင်ငံ၌ စွန့်ပစ်ထားတော်မမူ၊ ကိုယ်တော်၏ ခန္ဓာတော်ကိုလည်း သင်္ချိုင်းထဲ၌ ပုပ်ပျက်စီတော်မူရန် မဟုတ်’ ဟု ဟောပြောခ၏။ ");
INSERT INTO rki_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","ဘုရားသခင်က ထိုအသျှင်ယေသျှုအား သီခြင်းတရားမှ ထမြောက်စီတော်မူကြောင်းကို ငါရို့အားလုံးသည် ထိုအကြောင်းရင်း၏ သက်သီပင်ဖြစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ကိုယ်တော့်ကို ဘုရားသခင်၏ လက်ယာတော်ဖက်၌ ချီးမြှောက်တော်မူပြီးနောက် ကတိထားတော်မူသည်အတိုင်း သန့်ယှင်းသောဝိညာဉ်တော်ကို ခမည်းတော်ထံမှ ခံယူလေ၏။ အဂုတွင် သင်ရို့ တွိ့မြင်ကြားသိနိန်သော ထိုဝိညာဉ်တော်ကို ငါရို့အထက်၌ သွန်းလောင်းတော်မူပြီ။ ");
INSERT INTO rki_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","ဒါဝိဒ်သည် ကောင်းကင်ဘုံသို့ ချီဆောင်ခြင်းခံရသည် မဟုတ်။ သို့သော်လည်း ဒါဝိဒ်က၊ ‘သခင်ဘုရားသည် ငါ့အသျှင်ကို မိန့်တော်မူသည်ကား၊ ");
INSERT INTO rki_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","သင်၏ရန်သူတိကို သင်၏ခြီအောက်၌ ခြီတင်ခုံဖြစ်စီရန် ငါ ပြုပီးသည်တိုင်အောင် ငါ့လက်ယာဖက်၌ ထိုင်နိန်လော့’ ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“ထို့ကြောင့် ဣသရေလလူမျိုးအပေါင်းရို့၊ သင်ရို့က လက်ဝါးကပ်တိုင်၌ တင်သတ်လိုက်သော ယေသျှုသည် သခင်အဖြစ်နှင့် လည်းကောင်း၊ မေသျှိယအဖြစ်နှင့် လည်းကောင်း ဘုရားသခင်က ခန့်ထားသောသူဖြစ်ကြောင်းကို စွဲမြဲစွာ သိမှတ်ကြလော့” ဟု ဟောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ထိုစကားကို ကြားရသောအခါ သူရို့၏စိတ်နှလုံးသည် လွန်စွာ ပူပင်သောကရောက်ကြလျက် ပေတရုနှင့် အခြားတမန်တော်ရို့အား “ညီအစ်ကိုရို့၊ ငါရို့ ဇာသို့ ပြုရပါမည်နည်း” ဟု မိန်းမြန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","ပေတရုက၊ “သင်ရို့၏အပြစ်မှ ခွင့်ရွှတ်ခြင်းရစီရန် တစ်ယောက်စီတိုင်း နောင်တရပြီးလျှင် ယေသျှုခရစ်တော်၏ နာမတော်မြတ်၌ ဗတ္တိဇံကို ခံယူကြလော။ ထိုသို့ပြုလျှင် ဘုရားသခင်၏ လက်ဆောင်ဖြစ်သော သန့်ယှင်းသောဝိညာဉ်တော်ကို လက်ခံရကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","အကြောင်းမူကား ဘုရားသခင်၏ ကတိတော်သည် သင်ရို့နှင့် သင်ရို့၏သားသမီးတိမှစ၍ အဝီး၌ဟိသောသူ အားလုံး၏အသျှင် ငါရို့၏ဘုရားသခင် ခေါ်တော်မူသော သူရို့အတွက်ဖြစ်၏” ဟု ဆိုလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ပေတရုသည် အခြားသော စကားများဖြင့် သတိပီးလျက်၊ “သင်ရို့သည် မတရားသောသူရို့၌ ကျရောက်လာမည့် ပြစ်ဒဏ်မှ မိမိကိုယ်ကို ကယ်တင်ကြလော့” ဟု ထိုသူရို့အား တိုက်တွန်းလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ထိုအခါ ပေတရု၏စကားကို လက်ခံယုံကြည်သော များစွာသော သူရို့သည် ဗတ္တိဇံကိုခံယူကြသဖြင့် ထိုနိ့၌ လူပေါင်း ၃,၀၀၀ ခန့် တိုးပွားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ထိုသူရို့သည် တမန်တော်ရို့၏ သွန်သင်ခြင်းကိုခံယူခြင်း၊ မိတ်ဖွဲ့ခြင်း၊ မုန့်ဖဲ့ခြင်း၊ ဆုတောင်းခြင်းများဖြင့် အချိန်ကုန်လွန်စီကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","တမန်တော်ရို့သည် များစွာသော အံ့ဩဖွယ်ရာများနှင့် နိမိတ်လက္ခဏာများကို ပြကြသဖြင့် လူတိုင်းက အလွန်ကြောက်လန့်ကြကုန်၏။ ");
INSERT INTO rki_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","ယုံကြည်သူ အားလုံးသည် အတူတကွ မိတ်ဖွဲ့နီထိုင်ကြ၍ မိမိဥစ္စာပစ္စည်းများကို အချင်းချင်း ဝီမျှသုံးဆောင်ကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","သူရို့သည် မိမိဥစ္စာများနှင့် ပိုင်ဆိုင်မှုများကိုရောင်းချ၍ ရဟိသောငွီများကို တစ်ဦးချင်း လိုအပ်မှုဟိသည်အတိုင်း ဝီမျှကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","သူရို့သည် နိ့စဉ်နိ့တိုင်း ဗိမာန်တော်၌ စုဝေးကြပြီးလျှင် သူရို့၏အိမ်များတွင် မုန့်ကိုဖဲ့လျက် စေတနာစိတ်နှင့် ဝမ်းမြောက်စွာ အတူတကွ အစားအစာများကို သုံးဆောင်ကြကာ၊ ");
INSERT INTO rki_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ဘုရားသခင်ကိုလည်း ချီးမွမ်းပြီးလျှင် လူအပေါင်းရို့ရှိ့တွင် မျက်နှာပွင့်လန်းလျက် ဟိကြ၏။ သခင်ဘုရားသည်လည်း ကယ်တင်ခြင်းခံရသူရို့၏ အရီအတွက်ကို နိ့စဉ်နှင့်အမျှ တိုးပွားစီတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","တစ်နိ့၌ ပေတရုနှင့် ယောဟန်ရို့သည် မွန်းလွဲ သုံးချက်တီး ဆုတောင်းသောအချိန်တွင် ဗိမာန်တော်သို့ လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ထိုစဉ် လူတိက ဝမ်းတွင်းပါ ခြီမသန်စွမ်းသူ ယောကျ်ားတစ်ယောက်ကို ထမ်းလာကြ၏။ ဗိမာန်တော်ထဲသို့ လာကြသောသူတိပါးမှ ငွီကြေးတောင်းခံနိုင်ရန် နိ့စဉ်နိ့တိုင်း ထိုသူကို တင့်တယ်ဟု ခေါ်သော တန်းခါးအနားတွင် ချထားလေ့ဟိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ထိုသူသည် ပေတရုနှင့် ယောဟန်ရို့ ဗိမာန်တော်ထဲသို့ ဝင်လာသည်ကို မြင်လျှင် တစ်စုံတစ်ခုကို ပီးကမ်းစွန့်ကြဲရန် သူရို့အား တောင်းခံလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","သူရို့သည် သူ့ကို စိ့စိ့ကြည့်လျက်၊ ပေတရုက “ငါရို့ကို ကြည့်လော့” ဟု ဆိုလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ထို့ကြောင့် သူသည် သူရို့ပါးမှ တစ်စုံတစ်ခုရမည်ဟု မျှော်လင့်လျက် သူရို့ကိုကြည့်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","သို့သော် ပေတရုက “ငါ၌ ငွီကြေးမဟိ၊ ယေဒါလေ့ ဟိသောအရာကို သင့်အား ပီးမည်။ နာဇရက်မြို့သား ယေသျှုခရစ်တော်၏ နာမတော်မြတ်အားဖြင့် ထ၍ လှမ်းလားလော့” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ထို့နောက် ပေတရုသည် မိမိ၏ ညာဖက်လက်ဖြင့် ဆွဲကိုင်ကာ ထူမလိုက်သည်နှင့်တပြိုင်နက် သူ၏ခြီနှင့် ခြီဆစ်ရို့သည် ချက်ချင်း သန်မာလာသဖြင့်၊ ");
INSERT INTO rki_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ထိုသူသည် ထခုန်လျက် ရပ်ကာ လမ်းလျှောက်လေ၏။ ထို့နောက် ဘုရားသခင်၏ဂုဏ်တော်ကို ချီးမွမ်းလျက် ခုန်ပေါက်လမ်းလျှောက်ကာ ဗိမာန်တော်ထဲသို့ သူရို့နှင့်အတူ လိုက်လားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ထိုသူသည် လျှောက်လှမ်းစဉ် ဘုရားသခင်အား ချီးမွမ်းသည်ကို ထိုနီရာ၌ဟိသော လူအပေါင်းရို့သည် မြင်ကြ၏၊ ");
INSERT INTO rki_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ထိုသူသည် တင့်တယ်တန်းခါးတွင် ထိုင်လေ့ဟိသည့် သူတောင်းစားဖြစ်ကြောင်းကို မှတ်မိကြသဖြင့် သူရို့သည် ထိုသူ၌ ဖြစ်ပျက်သည့် အမှုအရာများကို အလွန်ပင် အံ့သြကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ထိုသူသည် ပေတရုနှင့် ယောဟန်ရို့ကို ကပ်လျက်နီစဉ် လူအပေါင်းရို့သည် အံ့သြသဖြင့် ထိုသူရို့ဟိရာ သျှောလမုန်မုခ်ဟုခေါ်သော နီရာသို့ ဗြီး၍ လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ပေတရုသည် ထိုသူရို့ကို မြင်သောအခါ “ဣသရေလအမျိုးသားရို့၊ ဇာဖြစ်လို့ ဤအမှုအရာကို အံ့သြနိန်ကြပြီး၊ ဇာကြောင့် ငါရို့ကို စိ့စိ့ကြည့်နိန်ကြသနည်း။ ငါရို့၏ တန်ခိုး၊ ငါရို့၏ အကျင့်သီလအားဖြင့် ဤလူကို လမ်းလျှောက်နိုင်အောင် လုပ်နိုင်သည်ဟု ထင်ကြသလော။ ");
INSERT INTO rki_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","ငါရို့အဖိုးအဖီးတိ၏ဘုရား၊ အာဗြဟံ၊ ဣဇာက်၊ ယာကုပ်ရို့၏ ဘုရားသခင်သည် မိမိ၏အခိုင်းအစီ ယေသျှုအား ဘုန်းတန်ခိုးတော်ကို ပီးတော်မူခယာ။ သင်ရို့သည် ထိုအသျှင်ကို အာဏာဟိသောသူတိလက်၌ အပ်သော်လည်း သူ့ကို လွှတ်ပီးရန် ဆုံးဖြတ်ထားသော ပိလတ်၏ ရှိ့တော်၌ ငြင်းပယ်ခကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","သင်ရို့သည် သန့်ယှင်းဖြောင့်မတ်သည့် အသျှင်ကို ငြင်းပယ်၍ သင်ရို့အတွက် လူသတ်သမားကို လွှတ်ပီးရန် တောင်းဆိုလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ထို့ကြောင့် အသက်ကို ပီးပိုင်သောသူကို ကွပ်မျက်လိုက်ကြ၏။ သို့သော် ဘုရားသခင်သည် ထိုသခင်ကို သီခြင်းတရားမှ ရှင်ပြန်ထမြောက်တော်မူ၏။ ငါရို့သည် ထိုအကြောင်းအရာ၏ သက်သီဖြစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ယေသျှု၏နာမတော်၌ ယုံကြည်ခြင်းဖြင့် သင်ရို့ မြင်ရ၊ သိရသော ဤသူသည် သန်စွမ်းလားခယာ။ ထိုသို့ ဖြစ်ခြင်းသည် ယေသျှု၏နာမတော်ကို ယုံကြည်ခြင်းသည် ထိုအသျှင်အားဖြင့်လာ၍ သင်ရို့ မြင်သမျှအတိုင်း ထိုသူအား လုံးဝ ကျန်းမာလာစီခြင်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“ညီအစ်ကိုရို့၊ အဂုတွင် သင်ရို့သည် သင်ရို့၏ ခေါင်းဆောင်တိ လုပ်ဆောင်ခသည့်နည်းတူ အသိဉာဏ်မဲ့စွာ ပြုနိန်ကြကြောင်းကို ငါသိ၏။ ");
INSERT INTO rki_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","မိမိ၏ မေသျှိယသည် ဒုက္ခဝေဒနာ ခံရမည်ဖြစ်ကြောင်းကို အားလုံးသော ပရောဖက်တိအားဖြင့် ကြိုတင်၍ ဘုရားသခင်က ဗျာဒိတ်ထားတော်မူခသော အရာတိကို ပြည့်စုံစီတော်မူယာ။ ");
INSERT INTO rki_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","သို့ဖြစ်၍ ဘုရားသခင်သည် သင်ရို့၏ အပြစ်တိကို လွှတ်ပီးစီရန် နောင်တရ၍ ပြောင်းလဲကြလော့။ ထိုသို့ပြုလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ဝိညာဉ်တန်ခိုး သွန်းလောင်းမည့်အချိန်သည် သခင်ဘုရားထံတော်မှ ရောက်လာလိမ့်မည်၊ ကိုယ်တော်သည် သင်ရို့အဖို့ ရွီးချယ်ထားတော်မူသော ကယ်တင်သျှင်ယေသျှုကို သင်ရို့ထံပါးသို့ စီရွှတ်တော်မူလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","ရှီးကာလက မိမိ၏ သန့်ယှင်းသူ ပရောဖက်တိမှတဆင့် ပီးတော်မူခသော ဘုရားသခင်၏ ဗျာဒိတ်တော်နှင့်အညီ ထိုအသျှင်သည် အရာအားလုံးကို အသစ်ပြုပျင်သောကာလ ရောက်လာသည့်တိုင်အောင် ကောင်းကင်ဘုံ၌ ဟိနိန်တော်မူမည်။ ");
INSERT INTO rki_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","မောသျှေက၊ ‘သင်ရို့၏အသျှင် ဘုရားသခင်သည် ငါ့ကို စီရွှတ်တော်မူသည့်နည်းတူ ပရောဖက်တစ်ပါးကိုလည်း သင်ရို့ပါးသို့ စီရွှတ်တော်မူလိမ့်မည်။ ထိုအသျှင်သည် သင်ရို့၏ လူမျိုးထဲက ဖြစ်လိမ့်မည်။ ထိုအသျှင် ဟောပြောသမျှစကားတိကို သင်ရို့နာခံကြရမည်။ ");
INSERT INTO rki_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","ဇာသူမဆို ထိုပရောဖက်စကားကို မနာခံသောသူသည် ဘုရားသခင်၏ လူမျိုးတော်ဖြစ်ခြင်းမှ ဖယ်ယှား၍ ဖျက်ဆီးခြင်းကို ခံရလိမ့်မည်’ ဟု မိန့်မြွက်တော်မူခ၏။ ");
INSERT INTO rki_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","သျှာမွေလမှစ၍ နောင်မှာပေါ်ထွန်းလာသည့် ပရောဖက်အားလုံးက ဗျာဒိတ်တော်အားဖြင့် အဂု နိ့ရက်ကာလ၌ ဖြစ်ပျက်နိန်သော အကြောင်းအရာတိကို ဟောပြောကြေညာခ၏။ ");
INSERT INTO rki_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","ထိုပရောဖက်တိအားဖြင့် ဘုရားသခင်ပီးတော်မူသော ကတိတော်များသည် သင်ရို့နှင့် ဆိုင်၏။ သင်ရို့အဖိုးအဖီးတိနှင့် ဘုရားသခင်ပြုတော်မူခသော ပဋိညာဉ်တော်ကလည်း သင်ရို့နှင့်ဆိုင်၏။ ဘုရားသခင်က အာဗြဟံအား၊ ‘သင်၏ အမျိုးအနွယ်အားဖြင့် မြီကြီးသားအပေါင်းရို့သည် ကောင်းကြီးမင်္ဂလာကို ခံစားရလိမ့်မည်’ ဟု မိန့်တော်မူခ၏။ ");
INSERT INTO rki_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ထို့ကြောင့် သင်ရို့တစ်ယောက်စီတိုင်းသည် မတရားသောလမ်းမှ နောင်တရခြင်းအားဖြင့် ကောင်းကြီးမင်္ဂလာကို ခံစားကြစီရန် ဘုရားသခင် ရွီးချယ်ထားသော မိမိအခိုင်းအစီအား သင်ရို့ပါးသို့ အဦးဆုံး စီရွှတ်တော်မူသည်” ဟု ဟောပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","ပေတရုနှင့် ယောဟန်ရို့သည် လူအပေါင်းရို့အား ဟောပြောလျက်နီကြစဉ် တချို့သော ယဇ်ပုရောဟိတ်များ၊ ဗိမာန်တော်မှူးနှင့် ဇဒ္ဒုကဲတချို့သည် ရောက်လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","တမန်တော် နှစ်ပါးက ယေသျှု၌ သီခြင်းတရားမှ ရှင်ပြန်ထမြောက်ခြင်းတရားအကြောင်းကို လူတိအား သွန်သင်ဟောပြောကြသောကြောင့် သူရို့သည် စိတ်အနှောက်အယှက်ဖြစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","ထို့ကြောင့် သူရို့သည် တမန်တော်ရို့ကို ဖမ်းဆီးကြပြီး မိုးချုပ်ပြီဖြစ်သောကြောင့် နောက်တစ်နိ့တိုင်အောင် အချုပ်ခန်းထဲ၌ ထည့်ထားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","သို့သော် နှုတ်ကပတ်တရားတော်ကို ကြားနာကြသူရို့သည် ကိုယ်တော့်ကို ယုံကြည်သက်ဝင်လာကြပြီး အရီအတွက်အားဖြင့် ယုံကြည်သူ ၅,၀၀၀ ခန့် တိုးပွားလာသတည်း။ ");
INSERT INTO rki_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","နောက်တစ်နိ့၌ ယုဒ ခေါင်းဆောင်တိ၊ အသက်ကြီးသူတိနှင့် ကျမ်းတတ်ဆရာရို့သည် ယေရုဆလင်မြို့တွင် စုဝေးကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","သူရို့သည် ယဇ်ပုရောဟိတ်မင်း အန္နတ်၊ ကယာဖ၊ ယောဟန်၊ အလက်ဇန္ဒြားနှင့် တခြားသော ယဇ်ပုရောဟိတ်မင်း၏ မိသားစုဝင်များ အစဟိသောသူအပေါင်းရို့နှင့် တွိ့ဆုံကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","ထိုသူရို့ရှိ့တွင် တမန်တော်နှစ်ပါးကို ရပ်စီလျက် “သင်ရို့သည် ဇာသူ့တန်ခိုး၊ ဇာသူ့နာမနှင့် ဤအမှုကိုပြုသနည်း” ဟု မိန်းမြန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","ထိုအခါ ပေတရုသည် သန့်ယှင်းသော ဝိညာဉ်တော်နှင့် ပြည့်ဝလျက် “လူတိ ခေါင်းဆောင်တိနှင့် အသက်ကြီးသူရို့၊ ");
INSERT INTO rki_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ဤနိ့တွင် ငါရို့သည် ခြီမသန်စွန်းသူတစ်ယောက်ကို ကောင်းကျိုးပြုသည့်အကြောင်းနှင့် သူသည် အကောင်းပကတိဖြစ်လာပုံ အကြောင်းနှင့်ပတ်သတ်၍ စစ်ဆီးခံနိန်ရပါ၏၊ ");
INSERT INTO rki_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","သင်ရို့သည် လက်ဝါးကပ်တိုင်ထက်၌ တင်၍ သတ်လိုက်ပြီး ဘုရားသခင်က ရှင်ပြန်ထမြောက်စီတော်မူသော နာဇရက်မြို့သား ယေသျှုခရစ်တော်၏ နာမတော်တန်ခိုးတော်အားဖြင့် ထိုသူသည် လုံးဝ ခြီသန်စွမ်းလာပြီးလျှင် အဂု သင်ရို့ရှိ့၌ ရပ်နိန်သည်ကို သင်ရို့နှင့်အတူ ဣသရေလလူမျိုးအပေါင်းရို့ သိအပ်ပေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","ယေသျှုကို ရည်မှတ်၍ ကျမ်းစာ၌ ဖော်ပြထားသည်ကား၊ “ ‘တိုက်အိမ်ဆောက်သောသူတည်းဟူသော သင်ရို့က မသုံးလို၍ ပယ်ထားသောကျောက်သည်၊ အရေးအကြီးဆုံး အဓိကနီရာ၌ အသုံးဝင်လာရသည်’ ဟူ၍ ဖြစ်သတည်း။ ");
INSERT INTO rki_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","ကယ်တင်ခြင်းသည် အခြားသော သူတစ်ယောက်၌မျှမဟိ၊ အကြောင်းမူကား ထိုနာမမှတစ်ပါး ငါရို့ကို ကယ်တင်နိုင်သော အခြားသောနာမကို ကောင်းကင်အောက်၌ ဇာသူ့ကိုမျှ ပီး၍မထား” ဟု သူရို့အား ဖြေကြားတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ပေတရုနှင့် ယောဟန်ရို့သည် ပညာမတတ်သောသူ၊ သာမန်လူများသာ ဖြစ်လျက်ပင် ဤသို့ ရဲရင့်ကြသည်ကို တရားလွှတ်တော်အဖွဲ့ဝင်များ မြင်တွိ့ကြသောအခါ အလွန်အံ့သြကြ၏။ ထိုသူရို့သည် ယေသျှု၏အပေါင်းအဖော်များ ဖြစ်ခကြသည်ကိုလည်း သတိပြုမိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","သို့ရာတွင် အနာရောဂါပျောက်ကင်းခသူသည် ပေတရု၊ ယောဟန်ရို့နှင့်အတူ ရပ်နိန်သည်ကို မြင်သောကြောင့် သူရို့သည် မည်သို့မျှ ငြင်းဆိုမှုကို မပြုနိုင်ကြ။ ");
INSERT INTO rki_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","ထို့ကြောင့် သူရို့သည် တမန်တော်ရို့အား တရားလွှတ်တော်ထဲမှ ထွက်လားခိုင်းပြီးလျှင် သူရို့သည် စတင်၍ ဤသို့ တိုင်ပင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“ဤသူရို့ကို ငါရို့ ဇာပိုင် လုပ်ရမည်နည်း။ ဤထူးခြားသော နိမိတ်လက္ခဏာတစ်ရပ်သည် သူရို့အားဖြင့် ဖြစ်ခသည်ကို ယေရုဆလင်မြို့၌ဟိသော လူတိုင်း ကောင်းစွာ သိကြသည် ဖြစ်၍ ဤအရာကို ငါရို့ ငြင်း၍ မရနိုင်။ ");
INSERT INTO rki_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","သို့သော်လည်း လူတိကြား၌ ဤကိစ္စကို ထပ်၍ ပြန့်နှံ့မလားစီခြင်းငှာ နောက်တစ်ခါ ယေသျှုနာမကို အမှီပြု၍ ဇာသူ့ကိုမျှ မဟောပြောစီရန် ထိုသူရို့အား တင်းကြပ်စွာ သတိပီးကြမည်” ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ထို့နောက် သူရို့သည် တမန်တော်တိအား ပြန်၍ ခေါ်သွင်းပြီး ယေသျှုနာမတော်ကို အမှီပြု၍ နောက်တစ်ခါ ဟောပြောသွန်သင်ခြင်းကို မပြုရန် ပညတ်ထားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","သို့ရာတွင် ပေတရုနှင့် ယောဟန်ရို့က “ဘုရားသခင်၏ စကားတော်ထက် သင်ရို့၏ စကားကို နားခံခြင်းသည် ဘုရားသခင်၏ ရှိ့တော်မှောက်၌ မှန်သလော ဆိုသည်ကို သင်ရို့ကိုယ်တိုင် စီရင်ပီးကြလော။ ");
INSERT INTO rki_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","ငါရို့ကား ငါရို့ကိုယ်တိုင် ကြားရ၊ မြင်ရသည့် အမှုအရာတိကို မဟောပြောဘဲ မနိန်နိုင်” ဟု ပြန်ပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","ထိုအခါ သူရို့သည် တမန်တော်ရို့အား တင်းကြပ်စွာ သတိပီး၍ ပြန်ရွှတ်လိုက်ကြ၏။ အကြောင်းမူကား လူအပေါင်းရို့သည် ဖြစ်ပျက်ခသည့်အရာအတွက် ဘုရားသခင်၏ ဘုန်းတော်ကို ချီးမွမ်းနိန်ကြသည်ဖြစ်၍ တရားလွှတ်တော်အဖွဲ့ဝင်ရို့သည် တမန်တော်ရို့အား အပြစ်ဒဏ်ပီးရန် နည်းလမ်းကို ရှာမတွိ့ပေ။ ");
INSERT INTO rki_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ဤနိမိတ်လက္ခဏာအားဖြင့် ရောဂါပျောက်ကင်းသူသည် အသက်လေးဆယ်ကျော်အရွယ်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ပေတရုနှင့် ယောဟန်ရို့သည် လွတ်မြောက်လာပြီးသည်နှင့် ချက်ချင်းပင် မိမိလူစုပါးသို့ ပြန်လာကြပြီးလျှင် ယဇ်ပုရောဟိတ်အကြီးအကဲတိနှင့် ဘာသာရေးခေါင်းဆောင်တိ ပြောကြားလိုက်သမျှကို ပြောပြကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ထိုအကြောင်းကို ကြားကြသောအခါ ယုံကြည်သူရို့သည် ဘုရားသခင်အထံတော်သို့ တညီတညွတ်တည်း အသံကိုရွှင့်လျက်၊ “အစိုးရတော်မူသောအသျှင်၊ ကိုယ်တော်သည် ကောင်းကင်၊ မြီကြီး၊ ပင်လယ်သမုဒ္ဒရာနှင့် ထိုအရပ်၌ ဟိသမျှအရာတိကို ဖန်ဆင်းတော်မူသော အသျှင်ဖြစ်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ကိုယ်တော်သျှင်သည် မိမိ၏အခိုင်းအစီဖြစ်သော အကျွန်ရို့၏ အဖိုးအဖီး ဒါဝိဒ်ကတစ်ဆင့် သန့်ယှင်းသော ဝိညာဉ်တော်အားဖြင့် မိန့်တော်မူသည်မှာ၊ “ ‘လူမျိုးခြားရို့သည် ဇာအတွက်ကြောင့် ရုန်းရင်းဆန်ခတ် ပြုကြသနည်း၊ လူတိလဲ ဇာအတွက်ကြောင့် အကျိုးမဟိဘဲ လျှို့ဝှက်ကြံစည်ကြသနည်း၊ ");
INSERT INTO rki_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","လောကီသျှင်ဘုရင်ရို့သည် အသင့်ပျင်ဆင်ပြီး အုပ်ချုပ်သူတိနှင့် စုဝေးကြကာ သခင်ဘုရားနှင့် ကိုယ်တော်၏ မေသျှိယကို ဆန့်ကျင်ကြ၏’ ဟူ၍ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","ထိုနည်းတူစွာ ဟေရုဒ်နှင့် ပုန္တိပိလတ်ရို့သည် လူမျိုးခြားများ၊ ဣသရေလလူမျိုးများနှင့်အတူ ဤမြို့ထဲ၌ စုဝေးခပြီးလျှင် ယေသျှုအား ဆန့်ကျင်ကြ၏။ ထိုသူသည် ကိုယ်တော်၏ သန့်ယှင်းသော အခိုင်းအစီဖြစ်ပြီး မေသျှိယအဖြစ် ဘိသိက်ခံရသူဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ထိုသူရို့ စုဝေးကြခြင်းမှာ ကိုယ်တော်သျှင်၏ တန်ခိုးတော်နှင့် အလိုတော်အရ ခွဲခန့်မှတ်သားသော အရာများကို ဖြစ်ပျက်လာစီရန် လုပ်ဆောင်ခြင်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","အို၊ သခင်ဘုရား၊ အဂုခါ ထိုသူရို့၏ ခြိမ်းခြောက်ခြင်းကို သိမှတ်တော်မူပါ။ ကိုယ်တော်သျှင်၏ အခိုင်းအစီတိအား အသျှင်၏တရားတော်ကို ရဲရင့်စွာ ဟောပြောနိုင်ခွင့် ပြုတော်မူပါ။ ");
INSERT INTO rki_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","အနာရောဂါပျောက်ကင်းစီရန် ကိုယ်တော်၏လက်တော်ကို ဆန့်တော်မူပြီးလျှင် ကိုယ်တော်သျှင်၏ သန့်ယှင်းသောအခိုင်းအစီ ယေသျှု၏ နာမတော်မြတ်အားဖြင့် နိမိတ်လက္ခဏာနှင့် အံ့ဩဖွယ်သောအရာများကို ပြုခွင့်ပီးတော်မူပါ” ဟု ဆုတောင်းကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ထိုသို့ ဆုတောင်းပြီးသောအခါ၌ သူရို့စုဝေးနိန်သောအရပ်သည် တုန်လှုပ်လေ၏။ သူရို့သည်လည်း သန့်ယှင်းသော ဝိညာဉ်တော်နှင့် ပြည့်ဝလျက် ဘုရားသခင်၏ တရားတော်ကို ရဲရင့်စွာ စတင်၍ ဟောပြောကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","ယုံကြည်သူရို့၏ အစုအဝေးသည် တစ်စိတ်တစ်ဝမ်းတည်းဖြစ်ကြ၍ သူရို့၏ပစ္စည်းဥစ္စာများကို မိမိပိုင်သည်ဟု မပြောဘဲ၊ ဟိသမျှသော ပစ္စည်းဥစ္စာများကို အချင်းချင်း ဝီမျှသုံးဆောင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","တမန်တော်ရို့သည် အသျှင်ယေသျှု ရှင်ပြန်ထမြောက်တော်မူခြင်းအကြောင်းကို ကြီးစွာသောတန်ခိုးဖြင့် သက်သီခံကြ၏။ ဘုရားသခင်သည် သူရို့အားလုံးကို ကြွယ်ဝသော ကောင်းကြီးမင်္ဂလာဖြင့် သွန်းလောင်းတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","ထိုသူရို့အထဲတွင် ဆင်းရဲသောသူ တစ်ယောက်မျှမဟိ။ အကြောင်းမူကား မြီကွက် သို့မဟုတ် အိမ်ကို ပိုင်ဆိုင်ကြသူရို့သည် မိမိရို့ပိုင်ဆိုင်ကြသော ပစ္စည်းများကိုရောင်းချ၍ ရသည့်ငွီများကို ယူလာကာ၊ ");
INSERT INTO rki_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","တမန်တော်ရို့အား ပီးအပ်ကြ၍ တစ်ဦးချင်း လိုအပ်မှုဟိသည်အတိုင်း အသီးသီးရို့အား ဝီပီးကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","ယောသပ် နာမည်ဟိ၍ နှစ်သိမ့်ခြင်း၏သားဟု ဆိုလိုသည့် ဗာနဗဟူ၍ နာမည်သစ်ဖြင့် တမန်တော်ရို့ မှည့်ခေါ်သော ကုပရုပြည်သား လေဝိလူမျိုးတစ်ယောက်သည်၊ ");
INSERT INTO rki_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","မိမိပိုင်သောမြီကွက်ကို ရောင်း၍ ရလာသောငွီကို ယူလာပြီးလျှင် တမန်တော်ရို့အား ပီးအပ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","အာနနိဟု နာမည်ဟိသူနှင့် သူ၏မယား သျှာဖိရေရို့သည် မိမိရို့ပိုင်ဆိုင်သည့် ပိုင်ဆိုင်မှုတချို့ကို ရောင်းချကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","သို့ရာတွင် အာနနိသည် မိမိမယားနှင့် သဘောတူညီချက်အရ ရောင်း၍ရသော ငွီထဲမှ တချို့ကို မိမိအဖို့ဖယ်ထားပြီးမှ ကျန်ငွီတိကို တမန်တော်ရို့အား ပီးအပ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ပေတရုက “အာနနိ၊ သင်သည် စာတန်မာရ်နတ်ကို ဇာကြောင့် သင့်စိတ်နှလုံးထဲ၌ အုပ်စိုးခွင့်ပီးပြီးလျှင် သန့်ယှင်းသောဝိညာဉ်တော်ကို လိမ်လည်ပြီး မြီကွက်ရောင်းရသော ငွီထဲက တချို့ကို ဇာကြောင့် ဖယ်ထားသနည်း။ ");
INSERT INTO rki_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","ထိုမြီကို မရောင်းခင် သင်ပိုင်သည် မဟုတ်လော။ ရောင်းပြီးလျှင်လည်း မြီကွက်ရောင်းရငွီကို သင်ပိုင်သည် မဟုတ်လော။ ဇာဖြစ်လို့ ထိုအကြံစည်ကို ကြံစည်သနည်း။ သင်သည် လူကို လိမ်လည်ခြင်း မဟုတ်ဘဲ ဘုရားသခင်ကို လိမ်လည်ခြင်းဖြစ်သည်” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","အာနနိသည် ထိုစကားကို ကြားသည်နှင့်တပြိုင်နက် လဲကျ သီဆုံးလေ၏။ ထိုအဖြစ်အပျက်ကို ကြားရသောသူအပေါင်းရို့သည် အလွန်ကြောက်လန့်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","လုလင်ရို့သည် ဝင်လာ၍ အာနနိ၏ရုပ်အလောင်းကို အဝတ်နှင့်ပတ်ပြီးလျှင် အပြင်သို့ထုတ်ယူလားပြီး သင်္ဂြိုဟ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","သုံးနာရီခန့်ကြာသောအခါ ဖြစ်ပျက်ခသော အကြောင်းအရာကိုမသိဘဲ အာနနိ၏မယားသည် ဝင်ရောက်လာ၏။ ");
INSERT INTO rki_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ထိုအခါ ပေတရုက၊ “ငါ့ကို ပြောလော့၊ သင်ရို့၏မြီကွက်ကို ဤမျှလောက်သောတန်ဖိုးနှင့် ရောင်းသလော” ဟု သူမအား မိန်းလျှင်၊ “ဟုတ်ပါ၏။ ဤမျှလောက်သောတန်ဖိုးနှင့် ရောင်းပါ၏” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ပေတရုကလည်း၊ “သင်ရို့သည်၊ သခင်ဘုရား၏ ဝိညာဉ်တော်ကို လိမ်လည်ရန် ဇာကြောင့် သဘောတူ ကြံစည်ကြသနည်း။ ကြည့်ပါ၊ သင်၏လင် အလောင်းကို သင်္ဂြိုဟ်ခသော လူတိ၏ခြီသည် တန်းခါးဝ၌ အဂုရောက်နီယာ။ သူရို့သည် သင့်ကိုလည်း ဆောင်ယူလားလိမ့်အုံးမည်” ဟု သူမအား ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ချက်ချင်းပင် ထိုမိန်းမသည် ပေတရု၏ခြီရင်းတွင် လဲကျ သီဆုံးလေ၏။ လုလင်ရို့သည် ဝင်လာကြသောအခါ ထိုမိန်းမသီဆုံးနီသည်ကို တွိ့ရသဖြင့် အလောင်းကို အပြင်သို့ထုတ်ဆောင်ပြီးလျှင် သူမ၏လင် ဘေးနားတွင် သင်္ဂြိုဟ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","ထိုအဖြစ်ပျက်ကို အသင်းတော်တစ်ခုလုံးနှင့် ကြားရသော အခြားသောသူအပေါင်းရို့သည် အလွန် ကြောက်လန့်ကြကုန်၏။ ");
INSERT INTO rki_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","တမန်တော်ရို့သည် လူအပေါင်းရို့ရှိ့တွင် များစွာသော အံ့ဖွယ်ရာများနှင့် နိမိတ်လက္ခဏာများကို ပြကြ၏။ ယုံကြည်သူအပေါင်းရို့သည် သျှောလမုန်ကနားပြင်တွင် အတူတကွ စုဝေးကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","လူရို့သည် ထိုသူရို့အား ချီးကျူးပြောဆိုကြသော်လည်း မည်သူတစ်ယောက်မှ ထိုသူရို့ကို မပေါင်းသင်းဝံ့ပေ။ ");
INSERT INTO rki_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","သို့သော် သခင်ဘုရားကို သက်ဝင်ယုံကြည်သူ မိန်းမ၊ ယောက်ျား အရေအတွက်သည်လည်း ပို၍ပို၍ များပြားလာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","တမန်တော်များသည် ထိုသို့ လုပ်ဆောင်မှု၏ အကျိုးရလဒ်ကြောင့် လူရို့သည် နာမကျန်းသောသူများကို လမ်းမထက်သို့ ယူဆောင်လာကြပြီး အိပ်ရာများ၊ ကုတင်များနှင့် ထားကြကာ ပေတရု ဖြတ်လားသောအခါ သူ၏အရိပ်ကိုပင် နာမကျန်းသောသူတချို့၌ ကျရောက်စီရန် ကြိုးစားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","ထို့ပြင် ယေရုဆလင် ပတ်ဝန်းကျင်မြို့ရွာများမှ လူထုပရိသတ်ရို့သည် ဖျားနာသူများ၊ ဝိညာဉ်ဆိုး ဝင်ပူးနိန်သူများကို ခေါ်ဆောင်လာကြ၍ သူရို့အားလုံးသည်လည်း ကျန်းမာခြင်းသို့ ရောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","ထိုအခါ ယဇ်ပုရောဟိတ်မင်းနှင့် သူ၏ အပေါင်းအဖော်များဖြစ်ကြသော ဒေသဆိုင်ရာ ဇဒ္ဒုကဲအဖွဲ့ဝင်များသည် တမန်တော်ရို့ကို အလွန် မနာလိုဖြစ်ကြ၏၊ ထို့ကြောင့် သူရို့ကို အရေးယူရန် ဆုံးဖြတ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","သူရို့သည် တမန်တော်ရို့ကို ဖမ်းဆီးပြီးလျှင် ထောင်၌ အကျဉ်းချထား၏။ ");
INSERT INTO rki_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","သို့သော် ထိုည၌ သခင်ဘုရား၏ ကောင်းကင်တမန်သည် ထောင်တန်းခါးကို ဖွင့်၍ တမန်တော်တိကို အပြင်သို့ ခေါ်ထုတ်ပြီးလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“သင်ရို့၊ ဗိမာန်တော်သို့ လားပြီးလျှင် လူအပေါင်းရို့အား အသစ်သော အသက်ရှင်ခြင်း အကြောင်းကို ဟောပြောကြလော့” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","တမန်တော်ရို့သည် ကောင်းကင်တမန်စကားကို နာခံ၍ အရုဏ်တက်ချိန်၌ ဗိမာန်တော်ထဲသို့ဝင်ပြီး စတင်၍ သွန်သင်ကြ၏။ ယဇ်ပုရောဟိတ်မင်းနှင့် သူ၏ အပေါင်းအပါရို့သည် စုံညီတရားလွှတ်တော် အစည်းအဝေးကို ပြုလုပ်ရန် ယုဒခေါင်းဆောင်အားလုံး စုရုံးစီကြ၏။ ထို့နောက် တမန်တော်ရို့ကို သူရို့ရှိ့သို့ ခေါ်ထုတ်လာရန် အစောင့်တပ်သားရို့ကို အမိန့်ပီး၍ အကျဉ်းထောင်သို့ စီရွှတ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","သို့သော် ထိုအစောင့်စစ်သည်ရို့သည် အကျဉ်းထောင်သို့ ရောက်ကြသောအခါ တမန်တော်ရို့ကို မတွိ့ကြသဖြင့် တရားလွှတ်တော်သို့ ပြန်လာကြပြီးလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“အကျွန်ရို့ အကျဉ်းထောင်သို့ ရောက်ကြသောအခါ၊ အကျဉ်းထောင်တန်းခါးကို သေချာစွာပိတ်ထားလျက် ဟိနိန်ပြီး ထောင်စောင့်တိလည်း တန်းခါးအပြင်ဖက်၌ ရပ်နိန်ကြသည်ကို အကျွန်ရို့ တွိ့ရပါ၏။ သို့သော် အကျွန်ရို့သည် တန်းခါးကို ဖွင့်လိုက်သောခါ အထဲ၌ တစ်ယောက်ကိုမျှ အကျွန်ရို့ မတွိ့ရပါ” ဟု တင်ပြကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ဗိမာန်တော်မှူးနှင့် ယဇ်ပုရောဟိတ်မင်းရို့သည် ထိုစကားကိုကြားလျှင် ဤအရာကား မည်သို့ ဖြစ်လိမ့်မည်နည်းဟု တမန်တော်ရို့နှင့်ပတ်သတ်၍ အံ့သြနိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ထိုအခါ လူတစ်ယောက်သည် ရောက်လာ၍ “နားထောင်ကတ်ပါ၊ အသျှင်ရို့ ထောင်ချထားသော လူရို့သည် ဗိမာန်တော်ထဲ၌ လူတိကို သွန်သင်နိန်ကြပါ၏” ဟု လျှောက်၏။ ");
INSERT INTO rki_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","ထို့ကြောင့် ဗိမာန်တော်မှူးသည် မိမိအစောင့်စစ်သည်တိနှင့် လား၍ တမန်တော်တိကို ပြန်၍ခေါ်လာကြ၏။ သို့သော် မိမိရို့အား လူထုက ကျောက်ခဲနှင့် ပစ်မည်ကို ကြောက်သောကြောင့် တမန်တော်တိအား အနိုင်အထက်မပြုဘဲ ခေါ်လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","သူရို့သည် တမန်တော်တိကို ခေါ်သွင်းလာပြီးလျှင် တရားလွှတ်တော်ရှိ့တွင် ရပ်စီပြီးနောက် ယဇ်ပုရောဟိတ်မင်းက သူရို့ကို စစ်ဆီးလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","ယဇ်ပုရောဟိတ်မင်းက “ငါရို့သည် သင်ရို့အား ထိုသူ၏နာမကို အမှီပြု၍ ဟောပြောသွန်သင်ခြင်းမပြုရန် တင်းကြပ်စွာ အမိန့်ပီးခ၏။ သို့သော် သင်ရို့သည် ယေရုဆလင်တစ်မြို့လုံး၌ ပြန့်နှံ့စွာ ဟောပြောသွန်သင်ပြီး ထိုသူ သီဆုံးရသည်မှာ ငါရို့ကြောင့်ဖြစ်သည်ဟု အပြစ်တင်လိုပါသည်တကား” ဟု တမန်တော်ရို့အား ပြောကြားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ပေတရုနှင့် အခြားသောတမန်တော်ရို့က “ငါရို့သည် လူ၏အမိန့်ထက် ဘုရားသခင်၏အမိန့်ကို နားထောင်ရမည်။ ");
INSERT INTO rki_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ငါရို့အဖိုးအဖီးရို့၏ဘုရားသခင်သည် လက်ဝါးကပ်တိုင်ထက်၌ သံမှိုဖြင့်ရိုက်၍ သင်ရို့ သတ်ခသော ယေသျှုကို ရှင်ပြန်ထမြောက်စီတော်မူခယာ။ ");
INSERT INTO rki_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ဘုရားသခင်သည် ဣသရေလလူမျိုးရို့၏ အပြစ်တိကို နောင်တရခြင်းနှင့် အပြစ်ခွင့်ရွှတ်ခြင်းကို ပီးသနားတော်မူရန် ထိုအသျှင်ကို ကယ်တင်သျှင်နှင့် အုပ်စိုးပိုင်သောအသျှင်အဖြစ် မိမိလက်ယာဖက်၌ ချီးမြှောက်တော်မူခယာ။ ");
INSERT INTO rki_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ဤအကြောင်းအရာနှင့် ပတ်သက်၍ ငါရို့သည် သက်သီများဖြစ်ကြပြီး ဘုရားသခင်သည် မိမိ၏စကားကို နာခံသူတိအတွက် ချပီးတော်မူသော သန့်ယှင်းသောဝိညာဉ်တော်ကလည်း သက်သီဖြစ်တော်မူ၏” ဟု ပြန်ဖြေကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","တရားလွှတ်တော်အဖွဲ့ဝင်ရို့သည် ထိုစကားကို ကြားကြလျှင် အလွန် ဒေါသထွက်သောကြောင့် တမန်တော်ရို့အား အသီသတ်ရန် ကြံစည်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","သို့သော်လည်း လူအားလုံးက လေးစားကြသော ကျမ်းတတ်ဆရာတစ်ယောက်ဖြစ်သည့် ဂါမလျေလဟု နာမည်ဟိသော ဖာရိယှဲတစ်ယောက်သည် တရားလွှတ်တော်၌ ထရပ်၍ တမန်တော်ရို့အား တစ်အောင့်ချေလောက် အပြင်သို့ခေါ်ထုတ်လားရန် အမိန့်ပီးပြီးလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ထိုသူက တရားလွှတ်တော်အဖွဲ့ဝင်ရို့အား “ဣသရေလအမျိုးသားရို့၊ သင်ရို့သည် ဤသူရို့အား သတိနှင့် ပြုမူကြလော့။ ");
INSERT INTO rki_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","အကြောင်းမူကား လွန်ခသောအချိန်က သုဒဟု ဆိုသူက မိမိကိုယ်ကို ကြီးမြတ်သည့်ဟု ဆိုလျက် ပေါ်ပေါက်ခပြီးလျှင် သူ့နောက်ကို လူ ၄၀၀ လောက် လိုက်ကြသည်ကို မှတ်မိကြသလော။ သို့သော် ထိုသူသည် အသီသတ်ခံရပြီးနောက်တွင် သူ၏နောက်လိုက်များသည် တကွဲတပြားစီ ဖြစ်လားပြီးလျှင် သူ၏လှုပ်ယှားမှုတိလည်း ပျောက်ကွယ်လားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","ထိုသူ၏နောက်တွင် သန်းခေါင်စာရင်းကောက်ချိန်၌ ယုဒဆိုသော ဂါလိလဲလူတစ်ယောက် ပေါ်လာပြီးလျှင် လူထုကို ဆွဲဆောင်စည်းရုံးပြန်၏။ သို့ရာတွင် ထိုသူလည်း အသီသတ်ခံရပြီးလျှင် သူ၏နောက်လိုက် အားလုံးသည်လည်း တကွဲတပြားဖြစ်ကုန်၏။ ");
INSERT INTO rki_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","ထို့ကြောင့် ဤကိစ္စနှင့်ပတ်သတ်၍ သင်ရို့ကို ငါပြောမည်။ ထိုသူရို့ကို အရေးမယူကြနှင့်။ ရွှတ်ထားလိုက်။ သူရို့ကြံစည်သော အမှုကိစ္စသည် လူ၏အမှုသာ ဖြစ်သည်ဆိုလျှင် ပျက်စီးရလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","သို့သော် ဘုရားသခင်က လာသည့် အမှုကိစ္စဖြစ်လျှင် ထိုသူရို့ကို သင်ရို့ မဖျက်ဆီးနိုင်ပေ။ သင်ရို့လည်း ဘုရားသခင်ကို ဆန့်ကျင်ဖက် ပြုရာကျမည်” ဟု ဆို၏။ တရားလွှတ်တော်ကလည်း ဂါမေလေလျ၏ အကြံပီးချက်ကို လက်ခံကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ထို့နောက် သူရို့သည် တမန်တော်ရို့ကို ခေါ်သွင်း၍ ကြိမ်ဒဏ်ပီးပြီးလျှင် ယေသျှုနာမ၌ နောက်တစ်ခါ ဟောပြောသွန်သင်ခြင်းကို မပြုရန် အမိန့်ပီးကာ ပြန်ရွှတ်လိုက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","တမန်တော်ရို့သည် တရားလွှတ်တော်မှ ထွက်လာကြစဉ် ဝမ်းမြောက်လျက်ဟိကြ၏။ အကြောင်းမူကား ဘုရားသခင်က ထိုသူရို့အား ယေသျှု၏ နာမတော်အဖို့ ဂုဏ်အသရေပျက်ခြင်းကို ခံထိုက်သူဟု မှတ်တော်မူခြင်းခံရသောကြောင့် ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ထို့နောက် ထိုသူရို့သည် နိ့စဉ်နိ့တိုင်း ဗိမာန်တော်တွင် လည်းကောင်း၊ လူရို့၏အိမ်များတွင် လည်းကောင်း ယေသျှုသည် မေသျှိယဖြစ်တော်မူကြောင်း သတင်းကောင်းကို အဆက်မပြတ် ဟောပြောသွန်သင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","ကာလအင်တန်ကြာပြီးနောက် တပည့်တော် အရီအတွက် များပြားလာသဖြင့် ဟေလသစကားကို ပြောသော ယုဒလူမျိုးတိနှင့် ဒေသခံ ယုဒလူမျိုးရို့ကြား အငြင်းပွားကြ၏။ ဟေလသစကားကို ပြောသော ယုဒလူမျိုးရို့က မိမိရို့၏ မုဆိုးမများသည် နိ့စဉ်အစားအသောက် ထောက်ပံ့မှု၌ လစ်လျူရှု ခံထားရသောကြောင့် ပြစ်တင်ပြောဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","ထို့ကြောင့် တစ်ကျိပ်နှစ်ပါးသော တမန်တော်ရို့သည် ယုံကြည်သူအားလုံးကို စုဝေးစီပြီးလျှင်၊ “ငါရို့သည် ဘုရားသခင်၏ နှုတ်ကပတ်တရားတော် ဟောပြောမှုကို ဂရုမထူဘဲ ငွီကြေးကိစ္စကို စီမံဆောင်ရွက်ရန်မသင့်။ ");
INSERT INTO rki_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ထို့ကြောင့် ညီအစ်ကိုမောင်နှမရို့၊ သင်ရို့အထဲမှ သန့်ယှင်းသောဝိညာဉ်တော်နှင့် လည်းကောင်း၊ ဉာဏ်ပညာနှင့် လည်းကောင်း ပြည့်ဝပြီးလျှင် ဂုဏ်သရေဟိသော လူခုနစ်ယောက်ကို ရွီးချယ်ကြလော့။ ငါရို့သည် ထိုသူရို့ကို ဤတာဝန်အတွက် ခန့်ထားမည်။ ");
INSERT INTO rki_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ငါရို့ကား ဆုတောင်းခြင်းနှင့် နှုတ်ကပတ်တော် ဟောပြောခြင်း အမှုကိုသာ အစဉ်တစိုက် ဆောင်ရွက်ကြမည်” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","တမန်တော်ရို့၏ စကားကို ယုံကြည်သူအားလုံးသည် နှစ်သက်ကြသဖြင့် သူရို့သည် ယုံကြည်ခြင်းနှင့် လည်းကောင်း၊ သန့်ယှင်းသောဝိညာဉ်တော်နှင့် လည်းကောင်း ပြည့်ဝသော သတေဖန်မှစ၍ ဖိလိပ္ပု၊ ပြောခေါ်၊ နိကနော်၊ တိမုန်၊ ပါမေနနှင့် အန္တိအုတ်မြို့မှ ယုဒဘာသာသို့ ပြောင်းလဲလာသော တစ်ပါးအမျိုးသားဖြစ်သူ နိကောလ ရို့ကို ရွီးချယ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ယုံကြည်သူများက ထိုသူရို့ကို တမန်တော်ရို့ရှိ့၌ ထားကြပြီးလျှင်၊ တမန်တော်ရို့က သူရို့ဂေါင်းထက်တွင် လက်ကိုတင်၍ ဆုတောင်းပီးကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","ဤသို့ဖြင့် ဘုရားသခင်၏ နှုတ်ကပတ်တရားတော်သည် ဆက်လက်၍ ပြန့်နှံ့လေ၏။ ယေရုဆလင်မြို့၌ တပည့်တော် အရီအတွက်သည်လည်း အလွန်တိုးပွားလာပြီး များစွာသော ယဇ်ပုရောဟိတ်ရို့သည် ယုံကြည်လက်ခံလာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","သတေဖန်သည် ဘုရားသခင်၏ ကောင်းကြီးမင်္ဂလာကို ကြွယ်ဝစွာ ခံစားရသောသူဖြစ်၍၊ တန်ခိုးတော်နှင့် ပြည့်ဝသူဖြစ်သောကြောင့် ကြီးမားသော အံ့ဩဖွယ်သောအမှုအရာများနှင့် နိမိတ်လက္ခဏာများကို လူတိကြားထဲ၌ ပြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","သို့ရာတွင် လူတချို့သည် သူ့ကို အတိုက်အခံ ပြုကြ၏။ ထိုသူရို့ကား၊ ကုရေနေနှင့် အာလေဇန္ဒြိမြို့၌ဟိသော ယုဒလူမျိုးတိပါဝင်သော လွတ်လပ်သူများ (ဟုခေါ်သည့်) တရားဇရပ်အဖွဲ့ဝင်များ ဖြစ်ကြ၏။ ထိုသူရို့နှင့်တကွ ကိလိကိပြည်နှင့် အာယှိပြည်မှ ယုဒအမျိုးသားတချို့ရို့သည် သတေဖန်နှင့် စတင်ငြင်းခုံကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","သို့ရာတွင် သတေဖန်သည် ဝိညာဉ်တော်ကပီးသည့် အသိပညာနှင့် ဟောပြောသဖြင့် ထိုသူရို့ မချေပနိုင်ကြပေ။ ");
INSERT INTO rki_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","ထို့ကြောင့် သူရို့သည် လူတချို့ကို လာဘ်ထိုး၍ “ဤသူသည် မောသျှေအား လည်းကောင်း၊ ဘုရားသခင်အားလည်းကောင်း စော်ကားပြောဆိုသည်ကို ငါရို့ကြားရယာ” ဟု ပြောစီကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ဤသို့ဖြင့် သူရို့သည် လူများ၊ အကြီးအကဲများ၊ ကျမ်းပြုဆရာများကို နှိုးဆော်ပီးကြ၏။ သူရို့သည် သတေဖန်အား ဖမ်းဆီးကာ တရားလွှတ်တော်ရှိ့သို့ ခေါ်ဆောင်လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ထို့နောက် သူရို့သည် သတေဖန်၏အကြောင်းကို မမှန်သော သက်သီထွက်ဆိုရန် လူတချို့ကိုခေါ်လာ၍ “ဤသူသည် သန့်ယှင်းသောဗိမာန်တော်နှင့် မောသျှေ၏ ပညတ်တော်ကို ဆန့်ကျင်သော စကားကို အစဉ်အမြဲ ပြောဆိုပါ၏။ ");
INSERT INTO rki_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ထိုစကားမှာ နာဇရက်မြို့သား ယေသျှုသည် ဗိမာန်တော်ကို ဖျက်ဆီးပြီးလျှင် မောသျှေက အကျွန်ရို့အား ပီးအပ်ခသော ထုံးတမ်းစဉ်လာတိကို ပြောင်းလဲစီလိမ့်မည် ဖြစ်ကြောင်း၊ ပြောဆိုသည်ကို အကျွန်ရို့ ကြားကြပါ၏” ဟု ထွက်ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","တရားလွှတ်တော်တွင် ထိုင်နိန်ကြသော သူအပေါင်းရို့သည် သတေဖန်ကို စိ့စိ့ကြည့်ကြသောအခါ သူ၏မျက်နှာသည် ကောင်းကင်တမန်၏ မျက်နှာနှင့် တူသည်ကို တွိ့မြင်ရကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ယဇ်ပုရောဟိတ်မင်းက သတေဖန်အား၊ “ဤစကား မှန်သလော” ဟု မိန်းသော်၊ ");
INSERT INTO rki_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","သတေဖန်က “ညီအစ်ကိုရို့နှင့် ဖခင်ရို့၊ နားထောင်ကြလော့။ အကျွန်ရို့၏အဖ အာဗြဟံသည် ခါရန်မြို့သို့ လား၍ နီထိုင်ခြင်းမပြုခင် မေသောပေါတာမိပြည်၌ ဟိနိန်စဉ် ဘုန်းတန်ခိုးတော်နှင့် ပြည့်စုံတော်မူသော ဘုရားသခင်ကို သူ၌ ထင်ရှားလာပြီးလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ထိုသူအား၊ ‘သင်၏ပြည်နှင့် ဆွီမျိုးသားချင်း ရို့ထံက ထွက်ပြီးလျှင် ငါ ပြမည့်ပြည်ကို လားလော’ ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","ထို့ကြောင့် အာဗြဟံသည် ခါလဒဲပြည်က ထွက်ပြီးလျှင် ခါရန်ပြည်သို့ လားပြီး နီထိုင်လေ၏။ သူ၏ဖခင် သီဆုံးပြီးနောက် ထိုမြို့မှ အဂု သင်ရို့နီထိုင်သောပြည်ကို ဘုရားသခင်က ရွှိ့ပြောင်းစီခိုင်း၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","ထို့နောက် ကိုယ်တော်က အာဗြဟံအား ထိုပြည်၌ အမွီအဖြစ် ခြီဖဝါးတစ်နီရာစာကိုတောင် ပီးတော်မမူ။ သို့သော်လည်း သူနှင့် သူ၏ သားစဉ်မြီးဆက်အား ထိုပြည်ကို အပိုင်ပီးမည်ဟု သားသမီးတစ်ယောက်မျှ မဟိခင်ကပင် သူ့ကို ကတိပီးတော်မူခ၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ဘုရားသခင်က အာဗြဟံအား ‘သင်၏မျိုးနွယ်သည် အခြားသောတိုင်းပြည်၌ ကျွန်ဘဝနှင့် နီရပြီးလျှင် အနှစ် ၄၀၀ ပတ်လုံး နှိပ်စက်ခြင်းကို ခံရလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","သို့သော်လည်း သူရို့ကို ကျွန်ပြုသောလူမျိုးတိအား ငါ စီရင်မည်။ ထို့နောက် သင်၏မျိုးနွယ်သည် ထိုပြည်မှ ထွက်လာပြီးလျှင် ဤအရပ်၌ ငါ့အား ကိုးကွယ်ဝတ်ပြုကြလိမ့်မည်’ ဟု မိန့်တော်မူခ၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","ထို့နောက် ဘုရားသခင်သည် ပဋိညာဉ်တော်၏ အမှတ်လက္ခဏာတစ်ခုအနိန်ဖြင့် အရီဖျားလှီးခြင်းမင်္ဂလာကို အာဗြဟံအား ပီးတော်မူခ၏။ ထို့ကြောင့် အာဗြဟံက သားဣဇာက်ကို ရပြီးနောက် သျှစ်ရက်မြောက်သောနိ့၌ အရီဖျားလှီးခြင်းမင်္ဂလာကို ပီး၏။ ထိုနည်းတူ ဣဇာက်က သားယာကုပ်ကိုလည်းကောင်း၊ ယာကုပ်က သားဆယ့်နှစ်ယောက်ကိုလည်းကောင်း၊ အရီဖျားလှီးခြင်း မင်္ဂလာကို ပီး၏။ ယာကုပ်သား တစ်ဆယ့်နှစ်ယောက်သည်ကား ငါရို့လူမျိုး၏ အဖိုးအဖီး တစ်ဆယ့်နှစ်ပါးဖြစ်သတည်း။ ");
INSERT INTO rki_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“ယာကုပ်၏သား ယောသပ်အား အစ်ကိုဖြစ်သောသူတိက မနာလိုသဖြင့် အဲဂုတ္တုပြည်၌ ကျွန်ခံစီခြင်းငှာ ရောင်းလိုက်ကြ၏။ သို့သော်လည်း ဘုရားသခင်သည် သူနှင့်အတူ ဟိတော်မူသည်ဖြစ်၍၊ ");
INSERT INTO rki_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ဒုက္ခဆင်းရဲအပေါင်းမှ သူ့ကို ကယ်နုတ်တော်မူ၏။ ဘုရားသခင်သည် ယောသပ်ကို အဲဂုတ္တုဘုရင်ရှိ့၌ မျက်နှာပွင့်လန်းစီပြီးလျှင် ဉာဏ်ပညာကိုလည်း ပီးတော်မူ၏။ သျှင်ဘုရင်က သူ့အား အဲဂုတ္တုဘုရင်ခံအဖြစ်နှင့် လည်းကောင်း၊ နန်းတော်ဝန်အဖြစ်နှင့် လည်းကောင်း ခန့်ထားတော်မူလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","အဲဂုတ္တုပြည်နှင့် ခါနာန်ပြည်တလျှောက်လုံး၌ ငတ်မွတ်ခေါင်းပါးခြင်းနှင့် ကြီးစွာသော ဆင်းရဲဒုက္ခရောက်၍ အကျွန်ရို့အဖိုးအဖီးတိသည် အစာရီစာကို မရနိုင်ကြပေ။ ");
INSERT INTO rki_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","သို့သော်လည်း အဲဂုတ္တုပြည်၌ ဆန်စပါးဟိကြောင်းကို ယာကုပ်ကြားသောအခါ ငါရို့ အဖိုးအဖီးတိဖြစ်ကြသော သူ၏သားတိကို ထိုပြည်သို့ ပထမအကြိမ် စီရွှတ်လိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ဒုတိယအကြိမ် လာရောက်ကြသောခါ ယောသပ်က မိမိသည် ဇာသူဖြစ်ကြောင်းကို သူ၏အစ်ကိုရို့အား ပြောပြလိုက်၍ ယောသပ်၏ မိသားစုအကြောင်းကို အဲဂုတ္တုဘုရင်က သိလားခလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","ထို့နောက် ယောသပ်သည် မိမိ၏ဖခင်ယာကုပ်နှင့်အတူ စုစုပေါင်း ၇၅ ယောက်သော မိသားစုတိကို အဲဂုတ္တုပြည်သို့ လာစီခြင်းငှာ သတင်းစကား ပါးလိုက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","ထို့ကြောင့် ယာကုပ်သည် အဲဂုတ္တုပြည်သို့ လိုက်လားလေ၏။ ထိုပြည်၌ သူနှင့်သူ၏ သားရို့သည် သီဆုံးကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","သူရို့၏ ရုပ်အလောင်းတိကို ယှေခင်မြို့သို့ သယ်ယူလားပြီးလျှင် ဟာမော်သားတိပါးမှ အာဗြဟံက အဖိုးခပီး၍ ဝယ်ထားခသော သင်္ချိုင်းဂူ၌ သင်္ဂြိုဟ်ခကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“ဘုရားသခင်က အာဗြဟံအား ထားတော်မူခသည့် ကတိတော်ကို ပြည့်စုံစီဖို့ရန် အချိန်နီးလာသောခါ အဲဂုတ္တုပြည်၌ အကျွန်ရို့လူမျိုးများသည် အလွန်တိုးပွားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ထို့နောက်တွင် ယောသပ်ကိုမသိသော ဘုရင်တစ်ပါးသည် အဲဂုတ္တုပြည်၌ စတင်၍ အုပ်ချုပ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ထိုဘုရင်က အကျွန်ရို့ အဖိုးအဖီးတိကို လှည့်စားပြီးလျှင် သူရို့တိကို နှိပ်စက်ညှဉ်းဆဲကြ၏။ သူရို့ကို အနိုင်အထက်ပြု၍ အသျှေတိကိုလည်း သီဆုံးစီခြင်းငှာ အိမ်အပြင်၌ ပစ်ထားစီကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ထိုအချိန်ကာလကား အလွန်လှပသော အချေ မောသျှေကို ဖွားမြင်သော ကာလပင်ဖြစ်၏။ သူ့ကို သုံးလတိုင်အောင် သူ၏အိမ်၌ ပြုစုစောင့်ရှောက်ခြင်းကို ခံရခ၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","သူသည် အိမ်ပြင်၌ ပစ်ထားခြင်းကိုခံရသောအခါ သျှင်ဘုရင်၏သမီးတော်က မိမိ၏သားအဖြစ် မွီးစားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","မောသျှေအား အဲဂုတ္တုအမျိုးသားတိတတ်အပ်သော အတတ်ပညာအလုံးစုံကို ဆည်းပူးစီပြီးသောအခါ သူသည် နှလုံးရည် လက်ရုံးရည်တိနှင့် ပြည့်စုံသူတစ်ဦး ဖြစ်လာ၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“သူသည် အသက်လေးဆယ် ပြည့်သောအခါ၌ မိမိအမျိုးသားချင်းဖြစ်သော ဣသရေလ ညီအစ်ကိုတိ ပါးသို့ လည်ပတ်ရန် စိတ်ပိုင်းဖြတ်ထားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","ထိုသို့ လည်ပတ်ချိန်၌ အဲဂုတ္တုအမျိုးသား တစ်ယောက်က ဣသရေလအမျိုးသား တစ်ယောက်အား နှိပ်စက်နိန်သည်ကို မြင်လျှင် မိမိလူဖက်မှ ဝင်ရောက်ကူညီပြီးလျှင် အဲဂုတ္တုလူကို လက်တုန့်ပြန်၍ အသီသတ်လိုက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","မောသျှေသည် မိမိလူတိကို ကယ်တင်ရန် မိမိအား ဘုရားသခင်က ရွှတ်လိုက်တော်မူခကြောင်းကို သူရို့နားလည်လိမ့်မည်ဟု ထင်မှတ်ခ၏။ သို့သော်လည်း သူရို့ နားမလည်ကြ။ ");
INSERT INTO rki_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","နောက်တစ်နိ့၌ ဣသရေလလူနှစ်ယောက် ရန်ဖြစ်နိန်သည်ကိုမြင်၍ ငြိမ်းချမ်းစီလိုသဖြင့် မောသျှေက၊ ‘နားထောင်ကတ်ပါ။ သင်ရို့သည် ညီအစ်ကိုချင်းဖြစ်လျက်ပင် ဇာဖြစ်လို့ ရန်ဖြစ်နိန်ကြသနည်း’ ဟု သူရို့အား ဖြန်ဖြေရန် ကြိုးစားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","သို့သော်လည်း အနိုင်ကျင့်သောလူက မောသျှေအား တိုးထုတ်လိုက်ပြီးလျှင် ‘ငါရို့ကို တရားစီရင်အုပ်ချုပ်ရန် သင့်အား ဇာသူက ခန့်ထားသနည်း။’ ");
INSERT INTO rki_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","‘တစ်နိ့က အဲဂုတ္တုလူတစ်ယောက်ကို အသီသတ်လိုက်သကဲ့သို့ ငါ့ကိုလည်း အသီသတ်ချင်သလော’ ဟု မိန်းလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ထိုစကားကို မောသျှေကြားသောအခါ အဲဂုတ္တုပြည်မှ ထွက်ဗြီးလားပြီးလျှင် မိဒျန်ပြည်၌ နီထိုင်လေ၏။ ထိုပြည်၌ သားနှစ်ယောက်ကို ရလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“နှစ် ၄၀ ကြာပြီးနောက် သိနာတောင်အနား တောကန္တာရ၌ ကောင်းကင်တမန်တစ်ပါးသည် မီးလောင်နိန်သော ခြုံပုတ်ထဲမှ မောသျှေကို ထင်ရှားပြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","ထိုအခြင်းအရာကို မောသျှေမြင်သောအခါ အံ့သြသည်ဖြစ်၍ သေချာစွာကြည့်ရန် အနားသို့ ချဉ်းကပ်လေ၏။ သို့သော် သခင်ဘုရား၏ အသံတော်ကို ကြားရသည်ကား၊ ");
INSERT INTO rki_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘ငါသည် သင့်အဖိုးအဖီးရို့၏ဘုရား၊ အာဗြဟံ၊ ဣဇာက်၊ ယာကုပ်ရို့၏ ဘုရားသခင်ဖြစ်သည်’ ဟု ကြားရသောကြောင့် မောသျှေသည် ကြောက်ရွံ့တုန်လှုပ်ပြီးလျှင် မကြည့်ဝံ့ဘဲနိန်၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","သခင်ဘုရားက မောသျှေအား ‘သင် ရပ်နိန်သော နီရာသည် သန့်ယှင်းသော မြီဖြစ်သောကြောင့် သင့်၏ဖိနပ်ကို ချွတ်လော့။ ");
INSERT INTO rki_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ငါသည် အဲဂုတ္တုပြည်၌ ငါ၏လူမျိုးတိ ခံနိန်ရသော ဒုက္ခဆင်းရဲကို မြင်ယာ။ ငါသည် သူရို့၏ ညည်းတွားသံတိကိုလည်း ကြားရယာ။ ထို့ကြောင့် ငါသည် သူရို့အား ကယ်တင်ရန် ဆင်းလာယာ။ အဂု လာလော့။ ငါသည် သင့်ကို အဲဂုတ္တုပြည်သို့ စီရွှတ်မည်’ ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“မောသျှေကား ဣသရေလလူမျိုးတိ ပစ်ပယ်ခြင်းကို ခံရသူဖြစ်၏။ သူရို့က ‘ငါရို့ကို အုပ်ချုပ်ဖို့နှင့် တရားစီရင်ဖို့ သင့်ကို ဇာသူခန့်ထားသနည်း’ ဟု မိန်းကြ၏။ သူသည် ခြုံပုတ်ထဲမှ မီးတောက်အားဖြင့် ထင်ရှားပြသော ကောင်းကင်တမန် အကူအညီအားဖြင့် ဣသရေလလူမျိုးတိကို အုပ်ချုပ်ရန်နှင့် လွတ်မြောက်စီရန် ဘုရားသခင် စီရွှတ်တော်မူသောသူဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","သူသည် လူတိကို အဲဂုတ္တုပြည်မှ ခေါ်ထုတ်လာ၍ အဲဂုတ္တုပြည်နှင့် ပင်လယ်နီ၌ လည်းကောင်း၊ အနှစ်လေးဆယ်ပတ်လုံး တောကန္တာရ၌ လည်းကောင်း၊ နိမိတ်လက္ခဏာနှင့် အံ့သြဖွယ်ရာများကို ပြုခ၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","မောသျှေသည် ဣသရေလ လူမျိုးရို့အား ‘ဘုရားသခင်သည် သင်ရို့ထံသို့ ငါ့ကို စီရွှတ်သကဲ့သို့ ပရောဖက်တစ်ပါးကို စီရွှတ်တော်မူလိမ့်မည်၊ ထိုသူသည် သင်ရို့ လူမျိုးထဲကတစ်ယောက် ဖြစ်လိမ့်မည်’ ဟု ပြောကြားခသူတစ်ယောက်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","သူသည် ဣသရေလလူမျိုးတိနှင့် တောကန္တရ၌ စုဝေးခသော သူတစ်ယောက်ဖြစ်၏။ သူသည် သိနာတောင်၌ စကားပြောခသော ကောင်းကင်တမန်တိနှင့် လည်းကောင်း၊ ငါရို့အဖိုးအဖီးနှင့် လည်းကောင်း ထိုနီရာ၌ဟိခသောသူဖြစ်ပြီး ငါရို့အား ပီးအပ်ရန် ဘုရားသခင်၏ အသက်ရှင်သော ဗျာဒိတ်တော်ကို ခံယူခသူဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“သို့သော်လည်း ငါရို့အဖိုးအဖီးတိက သူ၏စကားကို နာမခံကြ။ သူ့ကိုဖယ်ထားပြီးလျှင် အဲဂုတ္တုပြည်ကို ပြန်လိုသောဆန္ဒ ဟိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ထို့ကြောင့် သူရို့က ‘ငါရို့ကို အဲဂုတ္တုပြည်မှ ထုတ်ဆောင်ခသော မောသျှေသည် ဇာပိုင် ဖြစ်လားသည်ကို မသိ။ ထို့ကြောင့် ငါရို့ကို ဦးဆောင်တော်မူမည့် ဘုရားတိကို ပြုလုပ်ပီးပါ’ ဟု အာရုန်အား တောင်းဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","ထို့နောက် သူရို့သည် နွားပုံသဏ္ဌာန် ရုပ်တုကို သွန်းလုပ်ပြီး ပူဇော်သကာကို ယူဆောင်ကာ မိမိရို့လက်ဖြင့် ပြုလုပ်သော ထိုရုပ်တုကို ပူဇော်၍ ပျော်မြူးနိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","ထို့ကြောင့် ဘုရားသခင်သည် သူရို့ကို မျက်နှာလွှဲတော်မူ၍ ကောင်းကင်မှ ကြယ်တိကို ကိုးကွယ်စီရန် စွန့်ပစ်ထားတော်မူ၏။ ထိုအကြောင်းအရာနှင့်ပတ်သတ်၍ ပရောဖက်ကျမ်းစာ၌ ရီးသားထားသည်ကား၊ “ ‘ဣသရေလအမျိုးရို့၊ သင်ရို့သည် တောကန္တာရ၌၊ အနှစ်လေးဆယ်ပတ်လုံး ယဇ်ကောင်တိကို သတ်၍ ပူဇော်ခကြ၏။ ထိုပူဇော်ခြင်းသည်ကား ငါ့ကို ပူဇော်သည် မဟုတ်။ ");
INSERT INTO rki_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","သင်ရို့ သယ်ဆောင်လားသော မောလုတ်ဘုရား၏ တဲတော်နှင့်၊ သင်ရို့၏ ရင်ဖန်ဘုရား၏ ကြယ်ရုပ်တုဖြစ်၏။ ထိုအရာတိသည် သင်ရို့ ဝတ်ပြုကိုးကွယ်ဖို့ ပြုလုပ်ထားသော ရုပ်တုတိသာဖြစ်ကြ၏။ ထို့ကြောင့် ငါသည် သင်ရို့ကို ဗာဗုလုန်မြို့ ကျော်လွန်အောင် ပြည်နှင်ဒဏ် ပီးလိမ့်မည်။’ ");
INSERT INTO rki_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“တောကန္တာရ၌ ငါရို့အဖိုးအဖီးတိနှင့်အတူ ဘုရားသခင်ကိန်းဝပ်ရာ တဲတော်ဟိ၏။ မောသျှေသည် သူမြင်ရသည့်ပုံစံနှင့်အညီ တဲတော်ကို ပြုလုပ်ရန် မြွက်ဆိုတော်မူသော ဘုရားသခင်က မှာကြားသည့်အတိုင်း ပြုလုပ်ထားသော တဲတော်ဖြစ်၏။ မောသျှေအား ဖော်ပြထားတော်မူသည့်ပုံနှင့်အညီ သက်သီခံတော်မူရာ တဲတော်ကို တည်ဆောက်ခ၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ငါရို့ အဖိုးအဖီးရို့သည် မိမိရို့အဖတိထံပါးမှ ထိုတဲတော်ကို ဆက်ခံပြီးလျှင် ဘုရားသခင် နှင်ထုတ်တော်မူသော အခြားလူမျိုးတိပြည်ကို ယောသျှုနှင့်အတူ ချီတက်သိမ်းပိုက်ကြသောခါ ထိုတဲတော်ကို သယ်ဆောင်လားကြ၏။ ထိုတဲတော်ကား ဒါဝိဒ်လက်ထက်တိုင် ဟိလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","သူသည် ဘုရားသခင်၏ရှိ့တော်၌ ကျေးဇူးတော် ခံစားရသူ ဖြစ်ပြီးလျှင် ယာကုပ်၏ဘုရား ကိန်းဝပ်တော်မူရာအရပ်ကို တည်ဆောက်ခွင့်ပြုရန် ဘုရားသခင်ထံတော်သို့ တောင်းလျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","သို့သော်လည်း ဘုရားသခင်၏ အိမ်တော်ကို တည်ဆောက်ခွင့်ရသူကား သျှောလမုန် ဖြစ်၏။” ");
INSERT INTO rki_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“သို့သော်လည်း အမြင့်ဆုံးသောဘုရားသခင်သည် လူ့လက်ဖြင့် တည်ဆောက်သည့် အိမ်တိ၌ ကိန်းဝပ်တော်မမူ။ ထိုအကြောင်းအရာနှင့်ပတ်သက်၍ ပရောဖက်က၊ ");
INSERT INTO rki_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“ ‘သခင်ဘုရား မိန့်တော်မူသည်ကား၊ ကောင်းကင်ဘုံသည် ငါ့၏ပလ္လင်ဖြစ်၏၊ မြီကြီးသည်လည်း ငါ့၏ခြီတင်ခုံဖြစ်၏။ သင်သည် ဇာပိုင်မျိုး အိမ်ကို ငါ့အတွက် တည်ဆောက်မည်နည်း။ ငါ ကိန်းဝပ်မည့် အရပ်ကား ဇာမှာနည်း။ ");
INSERT INTO rki_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","ဤအရာအားလုံးတိကို ငါကိုယ်တိုင် ဖန်ဆင်းသည် မဟုတ်လော’ ဟူ၍ ဆိုထားသည်အတိုင်း ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“သတေဖန်က သင်ရို့သည် အလွန်ပင် ဂေါင်းမာကြ၏။ သင်ရို့၏ စိတ်နှလုံး၌ ဘုရားတရား ကင်းမဲ့ကြပြီးလျှင် ဘုရားသခင်၏ ဗျာဒိတ်စကားကို ကြားနာရန် နားပင်းနိန်ကြသည်တကား။ သင်ရို့သည် မိမိအဖိုးအဖီးတိကဲ့သို့ သန့်ယှင်းသောဝိညာဉ်တော်ကို အစဉ်အမြဲ ဆန့်ကျင်ဖက်ပြုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","သင်ရို့အဖိုးအဖီးတိ နှိပ်စက်ခြင်းကို မခံရသော ပရောဖက်ဟူ၍ ဇာသူတစ်ယောက် ဟိခသနည်း။ သူရို့သည် ဘုရားသခင် ကြွလာမည့်အကြောင်းကို ကြိုတင်ဟောကြားမည့် ဖြောင့်မတ်သော အခိုင်းအစီတိကို အယင်ကပင်လျှင် အသီသတ်ခကြ၏။ အဂုလည်း သင်ရို့သည် ထိုအသျှင်ကို သစ္စာဖောက်သောသူနှင့် သတ်ဖြတ်သောသူများဖြစ်ကြပြီ။ ");
INSERT INTO rki_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","သင်ရို့သည် ကောင်းကင်တမန်တိ အားဖြင့် ပီးအပ်တော်မူခသော ဘုရားသခင်၏ ပညတ်တော်ကို — ရလျှင်လည်း မလိုက်နာကြပေ” ဟု မြွက်ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","သတေဖန်စကားကို ကြားသောအခါ ယုဒတရားလွှတ်တော် အဖွဲ့ဝင်ရို့သည် အလွန် ဒေါသထွက်ကြ၍ အံကြိတ်နိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","သို့သော် သတေဖန်သည် သန့်ယှင်းသောဝိညာဉ်တော်နှင့် ပြည့်ဝလျက် ကောင်းကင်သို့ မော်ကြည့်လိုက်သောအခါ ဘုရားသခင်၏ ဘုန်းတန်ခိုးတော် လည်းကောင်း၊ ဘုရားသခင်၏လက်ယာဖက်တွင် ယေသျှုရပ်နိန်သည်ကိုလည်းကောင်း မြင်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","သူက “ကြည့်ပါ၊ ကောင်းကင်ပွင့်၍ လူသားသည် ဘုရားသခင်၏ လက်ယာဖက်၌ ရပ်နိန်သည်ကို ငါမြင်ရ၏” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","ကောင်စီဝင်အားလုံးသည် ကျယ်လောင်စွာ အော်ဟစ်လျက် နားကို လက်ဖြင့်ပိတ်ထားကြ၏။ ထိုအခါ ချက်ချင်း သတေဖန်ပါးသို့ တဟုန်ထိုး ဗြီးလာကြပြီး၊ ");
INSERT INTO rki_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","သူ့ကို မြို့ပြင်သို့ ဆွဲထုတ်ပြီးလျှင် ကျောက်သီးဖြင့် ပစ်ကြ၏။ အသိသက်သီရို့သည် မိမိရို့၏ အဝတ်များကို သျှောလုဟု ဆိုသော လူငယ်တစ်ယောက်ထံ၌ အပ်ထားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","ဤသို့ သူ့ကိုကျောက်သီးနှင့် ပစ်နိန်ကြစဉ် သတေဖန်က “အို၊ အသျှင်ယေသျှု၊ အကျွန့်ဝိညာဉ်ကို ရုပ်သိမ်းတော်မူပါ” ဟု သခင်ဘုရားကို ဆုတောင်းလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","သူသည် ဒူးထောက်၍ ကျယ်လောင်သော အသံဖြင့် “အသျှင်ဘုရား၊ ဤသူရို့ပြုသော ပြစ်မှားခြင်းတိကို မှတ်တော်မမူပါကေ့” ဟု ဆို၍ ကြွေးကြော်ပြီးလျှင် အသက်ချုပ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","သတေဖန်ကို သတ်သည့်အမှုတွင် သျှောလုသည် အလိုတူအလိုပါဖြစ်သတည်း။ ထိုနိ့မှစ၍ ယေရုဆလင်မြို့၌ဟိသော အသင်းတော်များသည် ညှဉ်းပန်းနှိပ်စက်ခြင်းကို ပြင်းစွာခံရလေ၏။ ထို့ကြောင့် တမန်တော်ရို့မှတစ်ပါး ယုံကြည်သူအားလုံးရို့သည် ယုဒပြည်နှင့် ယှာမာရိပြည်တလျှောက်သို့ ပြန့်ကြဲလားကြကုန်၏။ ");
INSERT INTO rki_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","ဘုရားကိုကြည်ညိုသော လူတချို့သည် ပြင်းစွာသော ငိုကြွီးခြင်းကို ပြုလျက် သတေဖန်ကို သင်္ဂြိုဟ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","သျှောလုသည် အသင်းတော်ကို ဖျက်ဆီးရန် ကြိုးစား၍ ယုံကြည်သူ မိန်းမယောက်ျားတိကို တစ်အိမ်ဝင်တစ်အိမ်ထွက်လျက် ဆွဲငင်ကာ ထောင်ချထားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","ပြန့်ကြဲလားသော ယုံကြည်သူရို့သည် သတင်းကောင်းကို အရပ်ရပ်သို့ လား၍ ဟောပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ဖိလိပ္ပုသည် ယှာမာရိပြည်၏မြို့တော်သို့ လား၍ မေသျှိယအကြောင်းကို ဟောပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","လူအစုအဝေးရို့သည် ဖိလိပ္ပုပြောသောစကားကို အာရုံစိုက်၍ နားထောင်းနိန်ကြစဉ် သူပြုသော နိမိတ်လက္ခဏာများကို မြင်ရကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","ဝိညာဉ်ဆိုးရို့သည် ကျယ်လောင်စွာအော်ဟစ်လျက် များစွာသောလူထဲမှ ထွက်လားကြ၏။ လီဖြတ်သောသူ၊ ခြီလက်မသန်စွမ်းသော သူရို့သည်လည်း ကျန်းမာခြင်းသို့ ရောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ထို့ကြောင့် မြို့သူမြို့သားအပေါင်းရို့သည် အလွန် ဝမ်းမြောက်ပျော်ရွှင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ထိုမြို့တွင်နီထိုင်သည့် သျှိမုန်ဟု ခေါ်သော လူတစ်ယောက်သည် ယှာမာရိလူမျိုးတိအား မိမိ၏ မှော်အတတ်ဖြင့် အချိန်အင်တန်ကြာ အံ့သြစီလျက် ဟိ၏။ သူသည် မိမိကိုယ်ကို ကြီးမြတ်သည်ဟု ဝါကြွား၍၊ ");
INSERT INTO rki_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","လူတန်းစား အသီးသီးမှ လူတိအားလုံးက “ဤသူသည် ဘုရားသခင်၏ မဟာတန်ခိုးတော် ဖြစ်သည်” ဟု ဆိုလျက် သူ၏စကားကို အာရုံစိုက်၍ နားထောင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","သူရို့သည် သျှိမုန်အား ဤသို့ အာရုံစိုက်ကြခြင်းမှာ သူသည် ကာလကြာမြင့်စွာ မှော်အတတ်ဖြင့် သူရို့ကို အံ့သြစီခသောကြောင့်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","သို့သော် ဖိလိပ္ပုသည် ဘုရားသခင်၏ နိုင်ငံတော်အကြောင်းနှင့် ယေသျှုခရစ်တော်၏ သတင်းကောင်းကို ဟောပြောသောအခါ သူရို့သည် ယုံကြည်လာကြသဖြင့် ယောက်ျားမိန်းမအပေါင်းရို့သည် ဗတ္တိဇံကိုခံယူကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","သျှိမုန်ကိုယ်တိုင်လည်း ယုံကြည်သဖြင့် ဗတ္တိဇံကို ခံယူပြီးနောက် ဖိလိပ္ပုထံတွင် ဆည်းကပ်၍ ကြီးစွာသော အံ့ဩဖွယ်ရာ နိမိတ်လက္ခဏာများကို မြင်တွိ့ရသောအခါ လွန်စွာအံ့သြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ယေရုဆလင်မြို့၌ဟိသော တမန်တော်ရို့သည် ယှာမာရိပြည်သားတိ ဘုရားသခင်၏ နှုတ်ကပတ်တရားတော်ကို လက်ခံလာကြကြောင်းကို ကြားသိရသောအခါ ပေတရုနှင့် ယောဟန်ရို့ကို သူရို့ပါးသို့ စီရွှတ်လိုက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","တမန်တော်နှစ်ပါးသည် ရောက်လာကြသောအခါ၊ သူရို့သည် ယုံကြည်သူ လူသစ်များအား သန့်ယှင်းသောဝိညာဉ်တော်ကို ခံယူနိုင်စီရန်အတွက် ဆုတောင်းပီးကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ဇာကြောင့်ဆိုသော် ထိုသူရို့သည် အသျှင်ယေသျှု၏နာမ၌ ဗတ္တိဇံကို ခံယူမျှသာဖြစ်၍ ထိုသူရို့ထဲတွင် ဇာသူ့၌မျှ သန့်ယှင်းသောဝိညာဉ်တော် ဆင်းသက်တော် မမူသိမ့်သောကြောင့်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","ထိုအခါ ပေတရုနှင့် ယောဟန်ရို့သည် ထိုသူရို့အထက်၌ လက်ကိုတင်ကြသောအခါ ထိုသူရို့သည် သန့်ယှင်းသောဝိညာဉ်တော်ကို ခံယူကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","သျှိမုန်သည် တမန်တော်ရို့၏ လက်တင်ခြင်းကို ခံရခြင်းအားဖြင့် ထိုသူရို့သည် ဝိညာဉ်တော်ကို ခံယူရဟိကြောင်းကို မြင်သောအခါ သူသည် တမန်တော်ရို့အား ငွီကို ယူလာ၍၊ ");
INSERT INTO rki_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“ဇာသူ့ကိုမဆို အကျွန်၏ လက်ကိုတင်လိုက်သောအခါ ထိုသူရို့၌ သန့်ယှင်းသောဝိညာဉ်တော်ကို ရစီခြင်းငှာ အကျွန်အား တန်ခိုးကို ပီးပါ” ဟု ဆိုလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","ပေတရုကလည်း “ဘုရားသခင်၏ ဆုကျေးဇူးတော်ကို ငွီနှင့် ဝယ်ယူရန် စိတ်အကြံဟိသောကြောင့် သင်၏ငွီသည် သင်နှင့်အတူ ပျက်စီးပါစီ။ ");
INSERT INTO rki_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ဘုရားသခင်ရှိ့တော်၌ သင်၏စိတ်ထား မမှန်ကန်သောကြောင့် ငါရို့၏ အပေါင်းအပါလည်းမဖြစ်နိုင်။ ငါရို့၏အလုပ်၌လည်း မပါဝင်နိုင်။ ");
INSERT INTO rki_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ထို့ကြောင့် သင်၏ ဆိုးညစ်မှုအတွက် နောင်တရပြီးလျှင် သင်၏စိတ်နှလုံးထဲ၌ ထိုသို့ ကြံစည်သဖြင့် ခွင့်ရွှတ်ခြင်း ရစီခြင်းငှာ သခင်ဘုရားထံပါး၌ ဆုတောင်းလော့။ ");
INSERT INTO rki_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","သင်သည် မနာလိုမုန်းတီးစိတ်မွန်းပြီးလျှင် ဒုစရိုက်အပြစ်၏ ကျွန်တစ်ယောက်ဖြစ်သည်ကို ငါမြင်သည်” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","သျှိမုန်ကလည်း ပေတရုနှင့် ယောဟန်အား၊ “သင်ရို့ပြောသော အမှုအရာတိ အကျွန်၌ မဖြစ်လာစီရန် အကျွန့်အတွက် သခင်ဘုရားထံ ဆုတောင်းပီးကြပါ” ဟု ဆိုလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","ပေတရုနှင့် ယောဟန်ရို့သည် သခင်ဘုရား၏ နှုတ်ကပတ်တရားကို သက်သီခံ၍ ဟောပြောကြပြီးနောက် ယေရုဆလင်မြို့သို့ ပြန်လာကြ၏။ အပြန်လမ်းခရီးတွင် များစွာသော ယှာမာရိ ရွာများတွင် သတင်းကောင်းကို ဟောပြောကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","သခင်ဘုရား၏ ကောင်းကင်တမန်သည် ဖိလိပ္ပုအား၊ “သင်သည် အသင့်ပျင်၍ ယေရုဆလင်မြို့မှ ဂါဇာမြို့သို့ လားသောလမ်းအတိုင်း တောင်ဖက်သို့ လားလော့” ဟု ဆို၏။ (ထိုလမ်းကို ယခုခေတ်တွင် မသုံးယာ)။ ");
INSERT INTO rki_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","ထို့ကြောင့် ဖိလိပ္ပုသည် အသင့်ပျင်၍ လားလေ၏။ ထိုစဉ် အဲသယောပိဘုရင်မ၏ အမတ်တစ်ဦးဖြစ်ပြီး ဘုရင်မ၏ဘဏ္ဍာအားလုံးကို စီမံအုပ်ချုပ်ရသော အဲသယောပိပြည်သား မိန်းမစိုး အရာဟိ တစ်ယောက်သည် ယေရုဆလင်မြို့သို့ လားပြီး ဘုရားသခင်အား ဝတ်ပြုကိုးကွယ်လေ၏။ သူသည် အပြန်လမ်းခရီးတွင် မြင်းရထားထက်၌ ထိုင်လျက် ပရောဖက် ဟေသျှာယကျမ်းကို ဖတ်နိန်၏။ ");
INSERT INTO rki_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","သန့်ယှင်းသော ဝိညာဉ်တော်က ဖိလိပ္ပုအား “ထိုမြင်းရထား အနားသို့ လားပြီး ကပ်၍လိုက်လော့” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","ဖိလိပ္ပုသည် ဗြီးလား၍ ပရောဖက်ဟေသျှာယကျမ်းအား ဖတ်လျက်နိန်သည်ကို ကြားသဖြင့် “သင် ဖတ်နိန်သော အရာကို နားလည်သလော” ဟု ထိုသူအား မိန်းလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ထိုအရာဟိက၊ “ငါ့ကို အနက်ဖွင့်ပြသူ မဟိဘဲ ဇာပိုင် နားလည်နိုင်ပါမည်နည်း” ဟု ပြန်ပြောပြီးနောက်၊ ဖိလိပ္ပုအား ရထားထက်တက်၍ မိမိနှင့်အတူထိုင်ရန် ဖိတ်ခေါ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ထိုသူ ဖတ်နိန်သည့် ကျမ်းစာပိုဒ်ကား၊ “အသီသတ်ရန် ဆွဲယူလားသော သိုးကဲ့သို့၊ သူ့ကို ဆောင်ယူလားကြ၏။ သိုးချေသည် အမွီးညှပ်သူရို့ရှိ့၌ နှုတ်ဆိတ်၍နိန်သကဲ့သို့၊ မိမိနှုတ်ကို မဖွင့်ဘဲနိန်၏။ ");
INSERT INTO rki_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","သူသည် ကဲ့ရဲ့ယှုတ်ချခြင်းကို ခံရစဉ် တရားမျှတမှု ဟိစီရန် သူ့အတွက် ဆောင်ရွက်ပီးသူမဟိ။ ဤလောကမှ သူ့အသက်ကို ရုပ်သိမ်းလားသည်ဖြစ်၍၊ ဇာသူသည် သူ၏သားမြီးတိကို ပြောပြနိုင်မည်နည်း” ဟူ၍ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","ထိုအရာဟိက ဖိလိပ္ပုအား၊ “ငါ့ကို ပြောပြလော။ ထိုပရောဖက်က ဇာသူ့အကြောင်းကို ပြောဆိုနိန်ပါသနည်း။ မိမိအကြောင်းလား၊ အခြားတစ်ယောက် အကြောင်းလား” ဟု မိန်းမြန်းလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ထို့ကြောင့် ဖိလိပ္ပုသည် ထိုကျမ်းစာပိုဒ်နှင့် အစပြု၍ ယေသျှုအကြောင်း သတင်းကောင်းကို ဟောပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","သူရို့သည် ဆက်လက်ပြီး ခရီးပြုကြစဉ် ရီဟိသောအရပ်သို့ ရောက်ကြသဖြင့် အရာဟိက၊ “ဤအရပ်၌ ရီဟိပါ၏။ ငါသည် ဗတ္တိဇံမင်္ဂလာ ခံယူရန် တားဆီးနိုင်သည့်အရာ ဟိပါသလော” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","အရာဟိသည် မြင်းရထားကို ရပ်တန့်စီပြီးနောက် သူရို့နှစ်ယောက်သည် ရီထဲသို့ ဆင်းလားကြပြီးလျှင် ဖိလိပ္ပုသည် အရာဟိအား ဗတ္တိဇံမင်္ဂလာကို ပီးလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","သူရို့သည် ရီထဲက တက်လာကြသောအခါ သခင်ဘုရား၏ ဝိညာဉ်တော်သည် ဖိလိပ္ပုအား အဝီးသို့ ဆောင်ယူလားတော်မူသဖြင့် အရာဟိသည် ဖိလိပ္ပုကို နောက်တဖန် မတွိ့ရပေ။ သူသည်လည်း ဝမ်းမြောက်စွာဖြင့် ခရီးဆက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ဖိလိပ္ပုသည် အာဇုတ်မြို့၌ ပေါ်လာ၍ ကဲသရိမြို့သို့ ရောက်သည့်တိုင်အောင် လမ်းတလျှောက်၌ဟိသော မြို့တိုင်း၌ သတင်းကောင်းကို ဟောပြော၍ ခရီးဆက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","ထိုအတောအတွင်း သျှောလုသည် သခင်ဘုရား၏တပည့်တော်ရို့အား သတ်ဖြတ်ရန် ခြိမ်းခြောက်လျက်နိန်၏။ သူသည် ယဇ်ပုရောဟိတ်မင်းထံသို့ လားပြီးလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","သခင်ဘုရား၏ လမ်းစဉ်ကို လိုက်လျှောက်သောမိန်းမ၊ ယောက်ျားတိကို တွိ့ပါက ဖမ်းဆီး၍ ယေရုဆလင်မြို့သို့ ခေါ်ဆောင်နိုင်ခြင်းငှာ ဒမာသက်မြို့၌ဟိသော တရားဇရပ်များသို့ ညွှန်ကြားစာ ပီးပါရန် တောင်းဆိုလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","သျှောလုသည် ဒမာသက်မြို့အနားသို့ ရောက်သောအခါ အာကာထက်မှ အလင်းသည် သူ့ပတ်လည်တွင် ရုတ်ကနဲ ထွန်းတောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","သူသည် မြီကြီးထက်တွင် လဲကျလားပြီး၊ “သျှောလု၊ သျှောလု ငါ့ကို ဇာကြောင့် ညှဉ်းဆဲနှိပ်စက်သနည်း” ဟု မိမိအား မိန်းမြန်းနိန်သော အသံတစ်ခုကို ကြားရ၏။ ");
INSERT INTO rki_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","သျှောလုက၊ “အသျှင်၊ အသျှင်ကား ဇာသူနည်း” ဟု မိန်းလျှောက်၏။ “ငါကား သင် ညှဉ်းဆဲနှိပ်စက်နိန်သူ ယေသျှုပင်ဖြစ်သည်” ဟု အသံတော်လာ၏။ ");
INSERT INTO rki_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","“ယေဒါလေ့ ထပြီးလျှင် မြို့ထဲသို့ ဝင်လော့။ သင် ပြုရမည့်အရာကို ထိုအရပ်၌ သင့်အား ပြောကြားလိမ့်မည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","သျှောလုနှင့်အတူ ခရီးပြုနိန်သော သူရို့သည် ထိုအသံကို ကြားရသော်လည်း လူတစ်ယောက်ကိုမျှ မတွိ့ရသဖြင့် အံ့မောကျလျက် ရပ်နိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","သျှောလုသည် မြီကြီးမှ ထပြီးလျှင် မျက်လုံးကို ဖွင့်လိုက်သောအခါ မည်သည့်အရာကိုမျှ မမြင်ရလီယာ။ ထို့ကြောင့် သူရို့သည် သူ၏လက်ကိုဆွဲ၍ ဒမာသက်မြို့သို့ ခေါ်ဆောင်လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","သူသည် သုံးရက်လုံးလုံး မျက်စိမမြင်ရ၍ ထိုကာလအတွင်း ဇာတစ်ခုကိုမျှ မစားမသောက်ဘဲနိန်၏။ ");
INSERT INTO rki_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ဒမာသက်မြို့တွင် အာနနိဟု ခေါ်သော တပည့်တော်တစ်ယောက် ဟိ၏။ သူ၏ဗျာဒိတ်ရူပါရုံထဲတွင် သခင်ဘုရားက “အာနနိ” ဟု ခေါ်တော်မူလျှင်၊ အာနနိက “အကျွန် ဤအရပ်၌ ဟိပါ၏၊ အသျှင်” ဟု ပြန်လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","သခင်ဘုရားကလည်း “သင်ထပြီးလျှင် လမ်းပြောင့်ဟု အမည်တွင်သော လမ်းသို့လားပြီးလျှင် တာယှုမြို့သား သျှောလုဟု ခေါ်သောသူကို ယုဒ၏ အိမ်၌ စုံစမ်းမိန်းမြန်းလော့။ သူသည် ဆုတောင်းလျက်နိန်၏။ ");
INSERT INTO rki_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ထိုသူသည်လည်း ဗျာဒိတ်ရူပါရုံ၌ အာနနိဟု ခေါ်သောသူသည် လာ၍ မိမိအထက်၌ လက်တင်ခြင်းဖြင့် မျက်စိအလင်း ပြန်ရသည်ကို မြင်ရလီယာ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","အာနနိက၊ “အသျှင်၊ ထိုသူသည် ယေရုဆလင်မြို့၌ဟိသော ကိုယ်တော်၏ သန့်ယှင်းသောလူတိအား ဇာလောက်ထိ ဒုက္ခပီးကြောင်း လူအများက ပြောကြသည်ကို အကျွန် ကြားပါ၏။ ");
INSERT INTO rki_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ထိုသူသည် ကိုယ်တော့်ကို ကိုးကွယ်ကြသောသူမှန်သမျှကို ဖမ်းဆီးရန် ယဇ်ပုရောဟိတ်အကြီးအကဲရို့ထံပါးက အခွင့်အာဏာဖြင့် ဤအရပ်သို့ ရောက်လာခြင်းဖြစ်ပါ၏” ဟု လျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","သို့ရာတွင် သခင်ဘုရားက၊ “လားလော့၊ ဤသူကား ငါ ရွီးချယ်ထားသူဖြစ်ပြီးလျှင် တခြားလူမျိုးတိ၊ သျှင်ဘုရင်တိနှင့် ဣသရေလလူမျိုးတိရှိ့၌ ငါ့နာမကို ထင်ရှားစီမည့်သူ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ငါ၏နာမအဖို့အလို့ငှာ သူခံရမည့် ဒုက္ခဆင်းရဲခြင်း အကြောင်းကို အားလုံးကို ငါကိုယ်တိုင် သူ့ကိုဖော်ပြမည်” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ထို့ကြောင့် အာနနိသည် လား၍ သျှောလုဟိသည့်အိမ်သို့ ဝင်ပြီး သူ၏အထက်၌ လက်ကိုတင်ပြီးလျှင်၊ “ငါ့ညီ သျှောလု၊ သင်သည် မျက်စိပြန်မြင်စီဖို့နှင့် သန့်ယှင်းသော ဝိညာဉ်တော်နှင့် ပြည့်ဝလာစီဖို့အတွက် သင် ဤအရပ်သို့ လာနိန်စဉ် လမ်းခရီး၌ ထင်ရှားတော်မူသော သခင်ဘုရားတည်းဟူသော ယေသျှုက ငါ့ကို သင့်ပါးသို့ စီရွှတ်တော်မူလိုက်သည်” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ထိုအခါ ခဏချင်းတွင် သျှောလုမျက်စိမှ ငါးအကြီးခွံများကဲ့သို့ သော အရာများ ကွာကျပြီး မျက်စိပြန်မြင်လီ၏။ သူသည်လည်း ထ၍ ဗတ္တိဇံကို ခံယူပြီးလျှင်၊ ");
INSERT INTO rki_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","သူသည် အစားအစာ သုံးဆောင်ပြီးနောက် ခွန်အားနှင့် ပြည့်လာ၏။ သျှောလုသည် ဒမာသက်မြို့တွင် တပည့်တော်တိနှင့်အတူ ရက်အနည်းငယ် နီထိုင်ခ၏။ ");
INSERT INTO rki_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ထိုသူသည် ချက်ချင်းပင် တရားဇရပ်များသို့ လား၍ ယေသျှုသည် ဘုရားသခင်၏ သားတော်ဖြစ်ကြောင်း စတင်၍ ဟောပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","သူ၏စကားကို ကြားသောသူ အပေါင်းရို့သည် အံ့သြကြ၍ “ဤသူသည် ယေရုဆလင်မြို့၌ ယေသျှုနာမအား ဆုတောင်းပတ္ထနာပြုသော သူတိကို သတ်ဖြတ်ခသူ မဟုတ်ပါလော၊ ထို့ပြင် ထိုသူရို့အား ဖမ်းဆီး၍ ယဇ်ပုရောဟိတ်အကြီးအကဲတိထံပါးသို့ ပို့ဆောင်လားရန် ရည်ရွယ်ချက်များဖြင့် ရောက်လာသူ မဟုတ်ပါလော” ဟု ပြောဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","သို့သော် သျှောလုသည် ခွန်အားနှင့် ပို၍ပြည့်စုံလာပြီး ယေသျှုသည် မေသျှိယဖြစ်တော်မူကြောင်းကို ယုံကြည်လောက်အောင် သက်သီပြ၍ ဟောပြောရာ ဒမာသက်မြို့တွင် နီထိုင်သူ ယုဒလူမျိုးရို့သည် မချေပနိုင်ကြပေ။ ");
INSERT INTO rki_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ထို့နောက် ရက်ပေါင်းများစွာ ကြာလာသောအခါ ယုဒလူမျိုးရို့သည် အတူတကွ တွိ့ဆုံပြီး၊ သျှောလုကို အသီသတ်ရန် ကြံစည်ကြ၏၊ ");
INSERT INTO rki_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","သို့သော်လည်း သူရို့၏ အကြံစည်ကို သျှောလု သိလေ၏။ သူရို့သည် မြို့တန်းခါးတိတွင် နိ့၊ ညမပြတ် စောင့်ကြည့်ပြီး သျှောလုအား အသီသတ်ရန် မှာထားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","သို့ရာတွင် သျှောလု၏ နောက်လိုက်ရို့သည် ညဉ့်အချိန်တွင် သူ့ကို ခေါ်ဆောင်လားကာ တောင်းထဲတွင်ထည့်၍ မြို့ရိုးထက်မှ အောက်သို့ လျှောချကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","သျှောလုသည် ယေရုဆလင်မြို့သို့ ရောက်သောအခါ တပည့်တော်ရို့နှင့် ဆက်သွယ်ရန် ကြိုးစားလေ၏။ သို့သော်လည်း သူသည် တပည့်တော်တစ်ဦးဖြစ်လာကြောင်းကို မယုံကြည်ကြသောကြောင့် ထိုသူရို့အားလုံးသည် သူ့ကို ကြောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ထိုအခါ ဗာနဗသည် လာ၍ သူ့အား ကူညီရန် တမန်တော်တိပါးသို့ ခေါ်လားလေ၏။ သူက သျှောလုသည် လမ်းခရီးတွင် သခင်ဘုရားအား ဖူးမြင်ခပုံနှင့် သခင်ဘုရားက သူ့အား ဇာပိုင် အမိန့်ဟိခပုံကို ထိုသူရို့အား ယှင်းပြခ၏။ သူသည် ဒမာသက်မြို့တွင် ယေသျှု၏နာမကို အမှီပြု၍ ရဲရင့်စွာ ဟောပြောခပုံကိုလည်း ပြောပြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","သျှောလုသည်လည်း တမန်တော်တိနှင့်အတူ နီထိုင်ပြီး ယေရုဆလင်တစ်မြို့လုံးသို့ လားလာလှုပ်ယှားလျက် သခင်ဘုရား၏ နာမကို အမှီပြု၍ ရဲရင့်စွာ ဟောပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","သျှောလုသည် ဟေလသဘာသာစကားကို ပြောသော ယုဒအမျိုးသားရို့နှင့် အခြီအတင် ဆွေးနွေးလေ၏။ သို့သော် သူ့အား သတ်ဖြတ်ရန် ကြံစည်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","ထိုအကြောင်းကို ယုံကြည်သူရို့သည် ကြားသိကြသောအခါ သူ့ကို ကဲသရိမြို့သို့ ပို့ဆောင်ပြီးလျှင် တာယှုမြို့သို့ ရွှတ်လိုက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ထို့ကြောင့် ထိုကာလတွင် ယုဒပြည်၊ ဂါလိလဲပြည်နှင့် ယှာမာရိပြည် အရပ်ရပ်၌ အသင်းတော်သည် ငြိမ်ဝပ်စွာနိန်ရလေ၏။ အသင်းတော်သည် သခင်ဘုရားအား ကြောက်ရွံ့ရိုသီသော စိတ်နှင့် လည်းကောင်း၊ သန့်ယှင်းသောဝိညာဉ်တော်၏ အားပီးတိုက်တွန်းအားဖြင့် လည်းကောင်း အသက်ရှင် နီထိုင်ကြသောကြောင့် အရီအတွက် တိုးပွားများပြား လာလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ပေတရုသည် အရပ်ရပ်သို့ လှည့်လည်လျက် လုဒ္ဒမြို့တွင်နီထိုင်သော ဘုရားသခင်၏ သန့်ယှင်းသောလူများပါးသို့ ရောက်လာ၏။ ");
INSERT INTO rki_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ထိုမြို့တွင် လီဖြတ်၍ သျှစ်နှစ်ပတ်လုံး အိပ်ရာထဲတွင် တုံးတုံးလဲနိန်သူ အဲနေ ဟူ၍ နာမည်ဟိသော သူတစ်ယောက်ကို တွိ့၏။ ");
INSERT INTO rki_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ထိုအခါ ပေတရုက၊ “အဲနေ၊ ယေသျှုခရစ်တော်က သင့်ကို ကျန်းမာစီယာ။ ထရပ်ပြီးလျှင် ကိုယ့်အိပ်ရာကို သိမ်းလော့” ဟု ဆို၏။ အဲနေသည် ချက်ချင်း ထရပ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","လုဒ္ဒမြို့နှင့် ယှာရုန်လွင်ပြင်၌ နီထိုင်သော လူအပေါင်းရို့သည် သူ့ကိုတွိ့မြင်၍ သခင်ဘုရားထံတော်သို့ ပြောင်းလဲလာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","ယုပ္ပေမြို့၌ တဗိသ နာမည်ဟိသော ယုံကြည်သူတစ်ဦး ဟိ၏။ (သူမ၏နာမည်ကား ဟေလသ ဘာသာစကားဖြင့် ဒေါ်ကာ ဖြစ်၍ “ဒရယ်” ဟု ဆိုလိုသတည်း။) သူမသည် ကောင်းသောအလုပ်နှင့် စွန့်ကြဲပီးကမ်းခြင်းအမှုကို အစဉ်သဖြင့် လုပ်တတ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","ထိုအချိန်၌ သူမသည် ဖျားနာ၍ သီဆုံးလေ၏။ သူမ၏အလောင်းကို ရီချိုးပီးကြပြီးနောက် အထက်ခန်းတွင် ထားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","လုဒ္ဒမြို့သည် ယုပ္ပေမြို့နှင့် မဝီးသဖြင့် လုဒ္ဒမြို့တွင် ပေတရုဟိကြောင်းကို ယုံကြည်သူရို့ ကြားသိကြလျှင် လူနှစ်ဦးကို သူ့ပါးသို့ ရွှတ်လိုက်ကာ “အကျွန်ရို့ပါးကို လျင်မြန်စွာ ကြွလာတော်မူပါ” ဟု တောင်းပန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","ထို့ကြောင့် ပေတရုသည် ထိုသူရို့နှင့်အတူ လိုက်လာ၏။ သူသည် ရောက်လာသောအခါ ပေတရုကို အထက်ခန်းသို့ ခေါ်ဆောင်လားကြ၏။ မုဆိုးမရို့သည် ပေတရု၏အနားတွင် ဝိုင်းအုံလျက် ငိုယိုကာ ဒေါ်ကာ အသက်ထင်ရှားစဉ် ခြုပ်ထားခသော အပြင်ခံအင်္ကျီများနှင့် အတွင်းခံအင်္ကျီများကို ပြကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","ပေတရုသည် ထိုသူရို့ အားလုံးကို အခန်းတွင်းမှ ထွက်စီပြီးလျှင် ဒူးထောက်၍ ဆုတောင်းလေ၏။ ထို့နောက် အလောင်းဖက်သို့လှည့်၍ “တဗိသ၊ ထလော့” ဟု ဆိုလျှင် သူမသည် မျက်စိဖွင့်၍ ပေတရုကို မြင်သောအခါ ထ၍ ထိုင်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ပေတရုသည် သူမအား လက်ကိုကမ်းပြီးလျှင် ထရပ်နိုင်ရန် ဖေးမလေ၏။ ထို့နောက် မုဆိုးမများ အပါအဝင် ယုံကြည်သူများ အားလုံးကိုခေါ်၍ သူမ အသက်ရှင်လျက်ဟိကြောင်းကို ပြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ထိုသတင်းသည် ယုပ္ပေတစ်မြို့လုံးတွင် ပျံ့နှံ့လားသဖြင့် လူအပေါင်းရို့သည် သခင်ဘုရားကို ယုံကြည်သက်ဝင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","ပေတရုသည် ယုပ္ပေမြို့၌ သားရီနယ်လုပ်သား သျှိမုန်ဆိုသူနှင့်အတူ ရက်ပေါင်းများစွာ တည်းခိုလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","ကဲသရိမြို့၌ ဣတလိတပ်ဟု ခေါ်သော ရောမတပ်တွင် ကော်နေလိဟု ခေါ်သည့် တပ်မှူးတစ်ယောက်ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","သူသည် ဘာသာတရား ကြည်ညိုသောသူ တစ်ယောက်ဖြစ်၏။ သူနှင့် သူ၏မိသားစုအားလုံးသည် ဘုရားသခင်ကို ဝတ်ပြုကိုးကွယ်ကြ၏။ ယုဒလူမျိုး ဆင်းရဲသူ ဆင်းရဲသားတိအား ရက်ရောစွာ ပီးကမ်းစွန့်ကြဲကာ ဘုရားသခင်အား အစဉ်ဆုတောင်းလျက်နိန်၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","တစ်နိ့၌ မွန်းလွဲ သုံးချက်တီးခန့်အချိန်တွင် ဗျာဒိတ်ရူပါရုံတစ်ခု၌ သူ့အား “ကော်နေလိ” ဟု ခေါ်သည့် ဘုရားသခင်၏ ကောင်းကင်တမန်တစ်ပါးကို ထင်ရှားစွာ မြင်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","သူသည် ထိုကောင်းကင်တမန်အား ကြောက်ရွံ့စွာဖြင့် စိစိကြည့်ပြီးလျှင် “ဇာကိစ္စ ဟိပါလဲ၊ ဆရာ” ဟု မိန်းလေ၏။ ကောင်းကင်တမန်က “သင်၏ ဆုတောင်းခြင်းနှင့် ပီးကမ်းစွန့်ကြဲခြင်းကို ဘုရားသခင် နှစ်သက်တော်မူသည်ဖြစ်၍ သင်၏ဆုတောင်းခြင်းကို သိမှတ်တော်မူယာ။ ");
INSERT INTO rki_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","အဂုပင်လျှင် ယုပ္ပေမြို့သို့ လူတချို့ကို စီရွှတ်၍ သျှိမုန် ပေတရုဟု ခေါ်သော လူတစ်ယောက် ကို ဖိတ်ခေါ်လော့။ ");
INSERT INTO rki_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ထိုသူသည် ပင်လယ်နားမှာ နီထိုင်သော သားရီနယ်လုပ်သား သျှိမုန်၏ အိမ်မှာ တည်းနိန်သော အာဂန္တုတစ်ယောက်ဖြစ်၏” ဟု ပြောဆို၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ထို့နောက် ကောင်းကင်တမန်သည် ထွက်ခွာလားလေ၏။ ထိုအခါ ကော်နေလိသည် မိမိ၏အစီခံနှစ်ယောက်နှင့်၊ သူ၏ကိုယ်ရံတော်တိထဲက ဘုရားတရားကို ရိုသီကိုင်းယှိုင်းသူ စစ်သားတစ်ယောက်ကို ခေါ်ပြီးလျှင် ");
INSERT INTO rki_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","အကြောင်းစုံကို ပြောပြကာ သူရို့အား ယုပ္ပေမြို့သို့ စီရွှတ်လိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","နောက်တစ်ရက်တွင် သူရို့သည် ခရီးထွက်လာကြရာ ယုပ္ပေမြို့ အနီးသို့ ရောက်ကြလေ၏။ မွန်းတည့်ချိန်ခန့်တွင် ပေတရုသည် ဆုတောင်းခြင်းငှာ အိမ်ခေါင်ထက်သို့ တက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","သူသည် ဝမ်းဆာလာသည်ဖြစ်၍ တစ်စုံတစ်ခုကို စားလိုသဖြင့် အစားအစာကို ပျင်ဆင်စဉ်တွင် ရူပါရုံတစ်ခုကို မြင်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ထိုရူပါရုံ၌ ကောင်းကင်ဖွင့်လှစ်ကာ လေးထောင့်ပုံ ခြုံလွှာကြီးတစ်ခုနှင့်တူသော အရာတစ်ခုသည် မြီကြီးထက်သို့ ကျဆင်းလာသည်ကို မြင်ရလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ထိုအထဲ၌ မြီကြီးထက်၌ တွား၍လားသည့် သတ္တဝါများမှစ၍ ခြီလေးချောင်းသတ္တဝါ အမျိုးမျိုးနှင့် လီထဲမှာ ကျင်လည်ကြသော ငှက်များ ဟိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","“ပေတရု ထ၍ သတ်စားလော့” ဟု ပြောသောအသံကို ကြားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","သို့ရာတွင် ပေတရုက “မဖြစ်နိုင်ပါ အသျှင်၊ ဘာသာတရားအရ မသန့်ယှင်း မစင်ကြယ်သော အစာကို အကျွန် စားလေ့ မဟိပါ” ဟု ပြန်လျှောက်သော်၊ ");
INSERT INTO rki_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","တဖန်စကားသံက “ဘုရားသခင်က သန့်ယှင်းသည်ဟု မိန့်တော်မူထားပြီးသောအရာတိကို မသန့်ယှင်း ဟူ၍ ထင်မှတ်မနိန်ကေ့” ဟု လာပြန်၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ထိုသို့ သုံးကြိမ်၊ သုံးလီ ဖြစ်ပျက်ပြီးနောက် ထိုခြုံလွှာကြီးကို ကောင်းကင်သို့ ပြန်၍ ရုတ်သိမ်းလားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ပေတရုသည် ဤဗျာဒိတ်ရူပါရုံ၏ အဓိပ္ပာယ်ကို စဉ်းစားနိန်သောအခါ ကော်နေလိက စီရွှတ်လိုက်သော လူရို့သည် သျှိမုန်အိမ်ကို မိန်းမြန်းရှာဖွီကြပြီးလျှင် အဂုတွင် သူရို့သည် အိမ်တန်းခါးရှိ့၌ ရောက်လာ၍ မတ်တပ်ရပ်နိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","သူရို့က “သျှိမုန် ပေတရု ဟု ခေါ်သော အာဂန္တုတစ်ယောက် ဤအိမ်၌ ဟိပါလား” ဟု အော်၍ မိန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","ပေတရုသည် ထိုဗျာဒိတ်ရူပါရုံ၏အဓိပ္ပာယ်ကို နားလည်ဖို့ ကြိုးစားနိန်စဉ်၊ ဝိညာဉ်တော်က “နားထောင်လော့၊ လူသုံးယောက်သည် ဤနီရာ၌ သင့်ကို လိုက်ရှာနိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","သူရို့သည် ငါ ရွှတ်လိုက်သော သူတိဖြစ်သောကြောင့် အဆင်သင့်ပျင်၍ ဆင်းပြီးလျှင် သံသယမဟိဘဲ သူရို့နှင့်အတူ လိုက်လားလီ” ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","ထို့ကြောင့် ပေတရုသည်လည်း အိမ်ထက်က ဆင်းလာပြီးလျှင် “ငါသည်ကား သင်ရို့ ရှာနိန်သောသူဖြစ်၏။ သင်ရို့သည် ဇာအကြောင်းကြောင့် ရောက်လာကတ်ပါလဲ” ဟု ထိုသူရို့အား မိန်း၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ထိုသူရို့က “ဘုရားသခင်ကို ကြည်ညို၍ ယုဒလူမျိုးအားလုံးက အလွန်လေးစားရသော၊ သူတော်ကောင်းတစ်ယောက်ဖြစ်သူ တပ်မှူး ကော်နေလိက အကျွန်ရို့ကို ရွှတ်လိုက်ပါ၏။ အကြောင်းမှာ သင်၏စကားကို ကြားနာခြင်းငှာ သင့်ကို သူ့အိမ်သို့ ခေါ်ဖိတ်ရန် ဘုရားသခင်၏ သန့်ယှင်းသောကောင်းကင်တမန်တစ်ပါးက သူ့အား ပြောသောကြောင့် အကျွန်ရို့ လာရခြင်းဖြစ်ပါ၏” ဟု ပြန်ပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","ပေတရုသည် ထိုလူတိကို အိမ်ထဲသို့ ဖိတ်ခေါ်၍ ထိုအိမ်၌ ညအိပ်ရန် ပြော၏။ နောက်တစ်နိ့တွင် ပေတရုသည် အသင့်ပျင်ဆင်၍ ထိုသူရို့နှင့်အတူ လိုက်လားလေ၏။ ယုပ္ပေမြို့မှ ယုံကြည်သူတချို့လည်း ပေတရုနှင့်အတူ လိုက်ပါကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","နောက်တစ်ရက်၌ သူရို့သည် ကဲသရိမြို့သို့ ရောက်ကြ၏။ ကော်နေလိသည် မိမိ ဖိတ်ခေါ်ထားသော ဆွီမျိုး၊ မိတ်ဆွီအပေါင်းအသင်းတိနှင့် အတူတကွ ထိုမြို့၌ စောင့်ကြိုနိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","ပေတရု ရောက်လာသောအခါ ကော်နေလိသည် သူနှင့် တွိ့ဆုံ၍ သူ၏ခြီရင်း၌ ပျပ်ဝပ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","သို့ရာတွင် ပေတရုက “ထလော့၊ ငါသည် လူသားတစ်ယောက်သာ ဖြစ်ပါ၏” ဟု ပြောကာ သူ့အား ထခိုင်းလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ပေတရုသည် ကော်နေလိအား စကားပြောဆိုလျက် အိမ်ထဲသို့ ဝင်သောအခါ စုရုံးနိန်ကြသော လူများကို တွိ့ရလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ပေတရုက ထိုသူရို့အား “ယုဒလူမျိုးတစ်ယောက်သည် သူ၏ ဘာသာရေးအရ တခြားလူမျိုးတိပါးသို့ လည်ပတ်ခြင်း၊ မိတ်ဖွဲ့ခြင်း ထုံးစံမဟိသည်ကို သင်ရို့ကိုယ်တိုင် ကောင်းကောင်း သိကြပါ၏။ သို့ရာတွင် ဇာသူ့ကိုမျှ ဘာသာရေးအရ မသန့်ယှင်း၊ မစင်ကြယ် ဟူ၍ မထင်မှတ်ရဟု ဘုရားသခင်က ငါ့ကို သင်ပြထားပြီးဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ထို့ကြောင့် သင်သည် ငါ့အား ခေါ်ခိုင်းလိုက်သောအခါ ငါသည် ငြင်းဆန်ခြင်းမပြုဘဲ၊ လိုက်လာခြင်းဖြစ်၏၊ သင်သည် ငါ့ကို ဇာကြောင့် ခေါ်ခိုင်းသနည်း” ဟု ပေတရုက ကော်နေလိအား မိန်း၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","ကော်နေလိကလည်း “လွန်ခသော သုံးရက်ခန့်က မွန်းလွဲသုံးချက်တီး ဤအချိန်တွင် အကျွန်သည် အကျွန့်အိမ်၌ ဆုတောင်းနိန်စဉ်၊ အရောင်တောက်ပသော အဝတ်ကို ဝတ်ဆင်ထားသော လူတစ်ယောက်သည် အကျွန်၏ရှိ့မှာ အမှတ်မထင် လာရပ်ပြီးလျှင် ");
INSERT INTO rki_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","‘ကော်နေလိ၊ သင်၏ ဆုတောင်းပတ္ထနာပြုခြင်းကို ဘုရားသခင် ကြားတော်မူ၍ သင်၏ပီးကမ်းစွန့်ကြဲခြင်းကိုလည်း အသိအမှတ်ပြုတော်မူယာ။ ");
INSERT INTO rki_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","သို့ဖြစ်၍ တစ်စုံတစ်ယောက်သောသူအား ယုပ္ပေမြို့သို့ စီရွှတ်၍ သျှိမုန် ပေတရု ဟု နာမည်တွင်သော လူတစ်ယောက်ကို ခေါ်ခိုင်းလိုက်ပါ။ ထိုသူသည် ပင်လယ်ကမ်းနားမှာ နီထိုင်သည့် သားရီနယ်လုပ်သား သျှိမုန်၏အိမ်တွင် တည်းခိုနိန်သော အာဂန္တုတစ်ယောက်ဖြစ်သည်’ ဟု ပြောဆို၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ထို့ကြောင့် အကျွန်သည် ကိုယ်တော်ပါးသို့ ချက်ချင်း စီရွှတ်လိုက်သည် ဖြစ်၍ ကိုယ်တော်ကြွလာခြင်းအတွက် ကျေးဇူးတင်ပါ၏။ အဂုတွင် အကျွန်ရို့ အားလုံးသည် ကိုယ်တော့်အား သခင်ဘုရား သွန်သင်ထားသော ဩဝါဒစကားတိကို ကြားနားခြင်းငှာ စောင့်ဆိုင်းလျက် ဘုရားသခင်၏ရှိ့မှောက် ဤအရပ်၌ ရောက်နိန်ကြခြင်းဖြစ်ပါသည်” ဟု ပေတရုအား ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","ပေတရုက စတင်၍ ဟောပြောသည်မှာ၊ “အကယ်စင်စစ် ဘုရားသခင်သည် လူတိုင်းကို အဆင့်အတန်းမခွဲခြားဘဲ တန်းတူ ဆက်ဆံတော်မူကြောင်းကို အကျွန်သည် အဂုမှ သဘောပေါက်လာ၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","လူမျိုးသည် အဓိက မဟုတ်၊ ဘုရားသခင်ကို ကြောက်ရွံ့၍ ဖြောင့်မတ်ခြင်းတရားကို ကျင့်သောသူရို့အား ဘုရားသခင်သည် လက်ခံတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","လူသားအားလုံး၏ အသျှင်ဖြစ်တော်မူသော ယေသျှုခရစ်တော်အားဖြင့် ငြိမ်းသက်ခြင်းဆိုင်ရာ သတင်းကောင်းကို ကြေညာတော်မူလျက်၊ ဣသရေလလူမျိုးတိပါးသို့ ဘုရားသခင် ပို့ဆောင်ပီးလိုက်သော သတင်းကောင်းတရားကို သင်ရို့ သိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","ယောဟန်သည် မိမိ၏ ဗတ္တိဇံတရားကို ဟောကြားပြီးနောက် ဂါလိလဲပြည်မှစ၍ ယုဒပြည် တဝှမ်းလုံးမှာ ဖြစ်ပျက်ခသည့် ကြီးကျယ်သော အဖြစ်အပျက်ကို သင်ရို့ သိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","နာဇရက်မြို့သား ယေသျှုအကြောင်းကိုလည်းကောင်း၊ ဘုရားသခင်သည် သန့်ယှင်းသော ဝိညာဉ်တော်နှင့် တန်ခိုးတော်ကို ထိုအသျှင်အား ဘိသိက်ပီးတော်မူသည်ကိုလည်းကောင်း သင်ရို့သည် သိကြ၏။ ဘုရားသခင်သည် ထိုအသျှင်နှင့်အတူ ဟိတော်မူသောကြောင့်၊ ထိုအသျှင်သည် မာရ်နတ်၏ တန်ခိုးအောက်မှာ ဟိနိန်ကြသောသူ အားလုံးကို ကျန်းမာ စီတော်မူလျက်၊ ကောင်းမြတ်သောအမှုတိကို လုပ်ဆောင်ကာ အရပ်ရပ်သို့ လှည့်လည်တော်မူခသည်ကို သင်ရို့သည် သိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","ငါရို့သည် ယေရုဆလင်မြို့နှင့် ဣသရေလနိုင်ငံ၌ ထိုအသျှင် ပြုတော်မူခသမျှသော အမှုအရာများ၏ အသိသက်သီတိ ဖြစ်ကြ၏။ သူရို့သည် ထိုအသျှင်ကို လက်ဝါးကပ်တိုင်မှာ သံမှိုဖြင့် ခတ်ကာ အသီသတ်ကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","သို့သော်လည်း ဘုရားသခင်သည် သုံးရက်မြောက်သောနိ့တွင် ထိုအသျှင်ကို သီခြင်းမှ ထမြောက်စီတော်မူပြီးလျှင် ကိုယ်ထင်ပြစီတော်မူခ၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","သို့ရာတွင် လူတိုင်းကို ပြတော်မမူ၊ ဘုရားသခင် ရွီးချယ်ထားတော်မူသော သက်သီခံများ ဖြစ်ကြသည့် သီခြင်းတရားက ထမြောက်ပြီးနောက် ကိုယ်တော်နှင့်အတူ စားသောက်ခကြသော ငါရို့ကိုသာ ပြတော်မူခ၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ထို့အပြင် ထိုအသျှင်က ငါရို့အား လူတိကို သတင်းကောင်းတရား ဟောကြားခြင်းငှာ လည်းကောင်း၊ သူသည် အသက်ရှင်သောသူ၊ သီသောသူတိကို တရားစီရင်ခြင်းငှာ ဘုရားသခင် ဘိသိက်ပီးထားသော အသျှင်တစ်ပါး ဖြစ်ကြောင်းကို သက်သီခံခြင်းငှာလည်းကောင်း မိန့်မှာတော်မူခ၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ထိုသခင်ကို ယုံကြည်သမျှသော သူတိသည် ထိုအသျှင်၏ နာမတော်တန်ခိုးအားဖြင့် မိမိရို့၏အပြစ်မှ လွတ်မြောက်ခြင်းကို ခံရကြလိမ့်မည်ဟု ပရောဖက်တိ အားလုံးက ထိုအသျှင်၏အကြောင်းကို ဟောပြောခကြ၏” ဟု ဆိုလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","ပေတရုသည် ထိုသို့ ဟောပြောနိန်စဉ်တွင် သူ၏နှုတ်ကပတ်တော်ကို နားထောင်နိန်ကြသော လူအားလုံးပါးသို့ သန့်ယှင်းသောဝိညာဉ်တော် ဆင်းသက်လာတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ဘုရားသခင်သည် မိမိ၏သန့်ယှင်းသော ဝိညာဉ်တော် ဆုကျေးဇူးကို တခြားလူမျိုးတိကိုလည်း သွန်းလောင်းတော်မူသည်ကို ပေတရုနှင့်အတူ ယုပ္ပေမြို့မှ လိုက်ပါလာကြသော ယုဒလူမျိုး ယုံကြည်သူများသည်လည်း မြင်ကြရသည်ဖြစ်၍ အံ့သြကြရလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","အကြောင်းမူကား သူရို့သည် အခြားသော ဘာသာစကားဖြင့် ပြောကာ ဘုရားသခင်၏ ဂုဏ်တော်ကြီးမြတ်တော်မူခြင်းကို ချီးမွမ်းကြသည်ကို ကြားရသောကြောင့်ဖြစ်၏။ ထိုအခါ ပေတရုသည် ထ၍ ပြောသည်မှာ၊ ");
INSERT INTO rki_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“ဤသူရို့သည် ငါရို့ကဲ့သို့ သန့်ယှင်းသော ဝိညာဉ်တော်ကို ရကြပြီ၊ ဤသူရို့အား ရီဖြင့် ဗတ္တိဇံပီးခြင်းကို ဇာသူသည် တားဆီးနိုင်အံ့နည်း” ဟု ဆိုလျက်၊ ");
INSERT INTO rki_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ပေတရုက သူရို့ကို ယေသျှုခရစ်တော်၏ နာမတော်မြတ်၌ ဗတ္တိဇံပီးခြင်းငှာ စီစဉ်၏။ ထို့နောက် သူရို့က ပေတရုအား သူရို့နှင့်အတူ ရက်အတန်ကြာ နီထိုင်ရန် တောင်းပန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","တခြားလူမျိုးတိလည်း ဘုရားသခင်၏နှုတ်ကပတ်တော် ခံယူကြသည်ကို ယုဒပြည်၌ ဟိကြသော တမန်တော်များနှင့် တခြားသော ယုံကြည်သူများသည်လည်း ကြားသိကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ပေတရုသည် ယေရုဆလင်မြို့သို့ ရောက်သောအခါ အရီဖျားလှီးခြင်း ခံယူထားသော ယုံကြည်သူတိက ");
INSERT INTO rki_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“သင်သည် အရီဖျားလှီးခြင်းကို မခံသော တခြားလူမျိုးတိ အိမ်၌ အဂန္တုတစ်ယောက်အဖြစ်ဖြင့် လည်ပတ်ပြီးလျှင် သူရို့နှင့် အတူ စားသောက်ပါသည်တကား” ဟု ပေတရုအား အပြစ်တင်ဝေဖန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ထို့ကြောင့် ပေတရုသည် ဖြစ်ပျက်ခသော အကြောင်းအရာ အလုံးစုံကို သူရို့အား တစ်ခုချင်းစီ ယှင်းပြသည်ကား၊ ");
INSERT INTO rki_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“ငါသည် ယုပ္ပေမြို့၌ ဆုတောင်းလျက်နိန်စဉ် ဗျာဒိတ်ရူပါရုံ တစ်ခုကို မြင်လေ၏။ ထိုရူပါရုံ၌ လေးထောင့်စပ် ခြုံလွှာကြီးတစ်ခုနှင့်တူသော အရာတစ်ခုသည် ကောင်းကင်မှ ကျဆင်းလာပြီးလျှင် ငါ့ပါးသို့ ရောက်လာ၏။ ");
INSERT INTO rki_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ငါသည် အနီးသို့ ကပ်၍ အတွင်းထဲကို ကြည့်လိုက်သောအခါ မြီကြီးထက်၌ တွား၍လားသည့် သတ္တဝါမှစ၍ ခြီလေးချောင်းသတ္တဝါ၊ သားရဲတိရစ္ဆာန်များ၊ လီထဲမှာ ကျင်လည်ကြသော ငှက်များကို မြင်တွိ့ရ၏။ ");
INSERT INTO rki_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ထိုအခါ ‘ပေတရု၊ ထ၍ သတ်စားလော့’ ဟု ငါ့အား ပြောသော အသံတော်ကို ကြားရ၏။ ");
INSERT INTO rki_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","သို့သော် ငါကလည်း ‘မဖြစ်နိုင်ပါ အသျှင်၊ အကျွန်သည် မစင်ကြယ်သောအစာ၊ ညစ်ညူးသောအစာကို အကျွန့် ခံတွင်းထဲသို့ မသွင်းဖူးပါ’ ဟု ပြောလိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","တဖန်ကောင်းကင်မှ အသံတော် လာသည်ကား ‘ဘုရားသခင်က သန့်ယှင်းသည်ဟု မိန့်တော်မူထားပြီးသော အရာတိကို မသန့်ယှင်းဟု ထင်မှတ်မနိန်ကေ့’ ဟူ၍ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","ဤသို့ သုံးကြိမ် သုံးလီ ပေါ်လာပြီး၊ နောက်ဆုံး၌ ထိုအရာသည် ကောင်းကင်သို့ ပြန်၍ ရုတ်သိမ်းလား၏။ ");
INSERT INTO rki_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","ထိုအချိန်၌ ကဲသရိမြို့က ငါ့ပါးသို့ ရွှတ်လိုက်သော လူသုံးယောက်သည် ငါတည်းခိုနိန်သည့်အိမ်သို့ ရောက်လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","ဝိညာဉ်တော်က ငါ့ကို သံသယမဟိဘဲ ထိုသူရို့နှင့် အတူလိုက်လားရန် ပြော၏။ ဤသို့ဖြင့် ငါသည် ယုပ္ပေမြို့မှ ယုံကြည်သူ ညီအစ်ကို ခြောက်ယောက်နှင့်အတူ ကဲသရိမြို့သို့ လိုက်ပါလားကြသဖြင့် ငါရို့အားလုံးသည် ကော်နေလိအိမ်သို့ ရောက်လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ထိုကော်နေလိက ငါရို့ကို ပြောသည်မှာ ကောင်းကင်တမန်တစ်ပါးသည် သူ့အိမ်ထဲ၌ ရပ်လျက် ပေါ်လာပြီးလျှင် ‘သျှိမုန် ပေတရု ဟု ခေါ်သောသူတစ်ယောက်ကို ပင့်ခေါ်ခြင်းငှာ တစ်စုံတယောက်ကို ယုပ္ပေမြို့သို့ စီရွှတ်လိုက်ပါ’ ");
INSERT INTO rki_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","သူသည် သင်နှင့်တကွ သင်၏မိသားစုအားလုံးကို ကယ်တင်ခြင်းရစီခြင်းငှာ သင်ရို့အား နှုတ်ကပတ်တရားတော်ကို ပြောကြားလိမ့်မည် ဟူ၍ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","ထို့နောက် ငါသည် ဟောပြောရန် အစပြုစဉ်တွင် သန့်ယှင်းသောဝိညာဉ်တော်သည် အယင်က ငါရို့ပါးသို့ ဆင်းသက်တော်မူသကဲ့သို့ သူရို့ပါးသို့လည်း ဆင်းသက်လာတော်မူလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","ထိုအခါ ‘ယောဟန်သည် ရီနှင့် ဗတ္တိဇံပီးခ၏၊ သို့သော်လည်း သင်ရို့ကို သန့်ယှင်းသောဝိညာဉ်တော်နှင့် ဗတ္တိဇံပီးလိမ့်မည်’ ဟု သခင်ဘုရားက မိန့်မှာခသည်ကို ငါ သတိရလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ငါရို့သည် အသျှင်ယေသျှုခရစ်တော်၌ ယုံကြည်သောအခါ ဘုရားသခင်သည် ငါရို့အား ဆုကျေးဇူးကို ပီးတော်မူသည့်နည်းတူ တခြားလူမျိုးတိကိုလည်း ပီးတော်မူသည်မှာ ထင်ရှားစွာ တွိ့ရ၏။ ငါသည်ကား ဇာပိုင်လူဖြစ်လို့ ဘုရားသခင်ကို တားဆီးနိုင်အံ့နည်း” ဟု ပေတရုက ပြော၏။ ");
INSERT INTO rki_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","သူရို့သည် ပေတရု၏စကားကို ကြားကြသောအခါ ပြစ်တင်ဝေဖန်ခြင်းကို ရပ်ကြပြီးလျှင် “ဘုရားသခင်သည် လူမျိုးခြားတိကိုလည်း နောင်တရ၍ အသက်ရှင်ရန် အခွင့်ထူးကို ပီးတော်မူယာ” ဟု ဆို၍ ဘုရားသခင်၏ကျေးဇူးတော်ကို ချီးမွမ်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","သတေဖန်ကို ကွပ်မျက်လိုက်ပြီးနောက် နှိပ်စက်ညှဉ်းပန်းခြင်း ဖြစ်ပေါ်လာသောကြောင့် ကွဲပြားလားကြသော ယုံကြည်သူများထဲက တချို့သည် ယုဒလူမျိုးတိကိုသာ သတင်းကောင်းတရား ဟောပြောလျက်၊ ဖိနိတ်ပြည်၊ ကုပရုကျွန်းနှင့် အန္တိအုတ်မြို့များသို့ ရောက်လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","သို့ရာတွင် ထိုယုံကြည်သူများထဲမှ တချို့သည် ကုပရုနှင့် ကုရေနေပြည်သားများ ဖြစ်ကြ၏။ ထိုသူရို့သည် အန္တိအုတ်မြို့သို့ လားပြီး အသျှင်ယေသျှု၏အကြောင်း သတင်းကောင်းကို ထိုသူရို့အား ပြောဆိုယင်း တခြားလူမျိုးတိကိုပါ ထိုသတင်းကောင်းတရားကို ကြေညာကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","သခင်ဘုရား၏တန်ခိုးတော်သည် သူရို့နှင့်အတူ ဟိသောကြောင့် များစွာသောသူရို့သည် ယုံကြည်ခြင်းသို့ ရောက်ကြပြီးလျှင် သခင်ဘုရားထံသို့ ပြောင်းလဲလာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ဤအကြောင်းနှင့်ပတ်၍ သတင်းစကားများသည် ယေရုဆလင်မြို့အသင်းတော်သို့ ရောက်လားသောအခါ သူရို့သည် ဗာနဗကို အန္တိအုတ်မြို့သို့ စီရွှတ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ဗာနဗသည် ထိုမြို့သို့ ရောက်သောအခါ ဘုရားသခင်ပီးထားသော ကျေးဇူးတော်ကို မြင်ရ၍ အားရဝမ်းသာဖြစ်ရလေ၏။ သို့ဖြစ်၍ သခင်ဘုရားအား မိမိ၏စိတ်နှလုံးကို ပုံအပ်၍ ယုံကြည်ကိုးစားပြီး သစ္စာစောင့်ကြရန် သူရို့အားလုံးကို တိုက်တွန်းနှိုးဆော်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ဗာနဗသည် သူတော်ကောင်းတစ်ယောက်ဖြစ်၍ ယုံကြည်ခြင်း၌ လည်းကောင်း၊ သန့်ယှင်းသောဝိညာဉ်တော်နှင့် လည်းကောင်း ပြည့်စုံသောကြောင့် များစွာသောသူတိကို သခင်ဘုရားထံသို့ ပို့ဆောင်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","ထို့နောက် ဗာနဗသည် သျှောလုကို ရှာဖွီခြင်းငှာ တာယှုမြို့သို့ လားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","သျှောလုကို တွိ့သောအခါ အန္တိအုတ်မြို့သို့ ခေါ်လာပြီး၊ သူရို့နှစ်ယောက်သည် တစ်နှစ်ပတ်လုံး အသင်းတော်နှင့်အတူ နီထိုင်လျက် များစွာသောသူတိကို ဆုံးမသြဝါဒ ပီးကြ၏။ ယုံကြည်သူတိကို ခရစ်ယာန်ဟု အန္တိအုတ်မြို့၌ အစပြု၍ ခေါ်ဝေါ်ကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","ထိုအချိန်တွင် ပရောဖက်တချို့သည် ယေရုဆလင်မြို့မှ အန္တိအုတ်မြို့သို့ ရောက်လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","သူရို့အထဲက အာဂဗုဟုခေါ်သော သူတစ်ယောက်သည် ထ၍ မြီကြီးတစ်ပြင်လုံးတွင် ကြီးစွာသော ငတ်မွတ်ခေါင်းပါးခြင်း ဖြစ်လာမည်ဟု ဝိညာဉ်တော်တန်ခိုးဖြင့် ကြိုတင်ဟောလေ၏။ ထိုငတ်မွတ်ခေါင်းပါးခြင်းသည်ကား ကဲသာဘုရင် ကလောဒိ လက်ထက်၌ ဖြစ်ခလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","ထိုအချိန်၌ တပည့်တော်ရို့သည် ယုဒပြည်၌ နီထိုင်ကြသော မိမိရို့၏ယုံကြည်သူ ညီအစ်ကိုတိအား တတ်နိုင်သလောက် အကူအညီအထောက်အပံ့ ပို့ပီးရန် ဆုံးဖြတ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","သူရို့သည် ဤသို့ ဆုံးဖြတ်ချက်ချပြီးနောက် သျှောလုနှင့် ဗာနဗအားဖြင့် အသင်းတော်လူကြီးတိပါးသို့ ငွီများကို ပို့ပီးလိုက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","ထိုအချိန်၌ ဟေရုဒ်မင်းသည် အသင်းဝင်သူအချို့ကို ညှဉ်းဆဲနှိပ်စက်ရန် စတင်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","သူသည် ယောဟန်၏အစ်ကို ယာကုပ်ကို ဓါးဖြင့် ကွပ်မျက်လိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ဤသို့ပြုခြင်းကို ယုဒလူမျိုးတိက ကြေနပ်အားရကြသည်ကို မြင်လျှင် သူသည် ပေတရုအား ဆက်လက်၍ ဖမ်းဆီး၏။ ဤကား တဆီးမပါသော မုန့်ပွဲတော်ကျင်းပသည့်ကာလ၌ ဖြစ်သတည်း။ ");
INSERT INTO rki_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","သူသည် မိမိဖမ်းဆီးထားသော ပေတရုအား ထောင်ထဲမှာ လှောင်ထားကာ သူ့ကို စောင့်ကြပ်ရန် တပ်စု တစ်စုလျှင် စစ်သားလေးယောက်စီပါသော တပ်စုလေးစုအား အပ်နှံထား၏။ ဟေရုဒ်သည် ပသခါပွဲတော်ပြီးလျင် သူ့အား စစ်ဆီးရန် လူထုလက်သို့ အပ်မည်ဟု စီစဉ်ထား၏။ ");
INSERT INTO rki_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","ထို့ကြောင့် ပေတရုသည် အကျဉ်းထောင်ထဲ၌ အကျဉ်းချခံနိန်ရ၏။ သို့ရာတွင် အသင်းတော်၏ယုံကြည်သူများသည် သူ့အတွက် ဘုရားသခင်ထံ၌ စိတ်အားထက်သန်စွာဖြင့် ဆုတောင်းပီးနိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ဟေရုဒ်သည် ပေတရုကို လူထုလက်သို့ မအပ်နှံခင် ညဉ့်အခါ၌ သူ့ကို သံကြိုးနှစ်ပင်နှင့် တုပ်နှောင်ထား၏။ ပေတရုသည် အစောင့်စစ်သား နှစ်ယောက်ကြားတွင် အိပ်ပျော်နိန်၏။ အကျဉ်းထောင်၏ တန်းခါးဝတွင်လည်း အစောင့်စစ်သားများ စောင့်နိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","သခင်ဘုရား၏ကောင်းကင်တမန်တစ်ပါးသည် ရုတ်တရက် ပေါ်လာ၍ အလင်းတန်းတစ်ခုသည် အချုပ်ခန်းထဲ၌ ထွန်းလင်းလာ၏။ ထိုကောင်းကင်တမန်က “အယင် ထလော့” ဟု ပေတရု၏ပခုံးကို လှုပ်၍ နှိုးသောအခါ သံကြိုးသည် ပေတရု၏လက်မှ ချက်ချင်း ကျွတ်လား၏။ ");
INSERT INTO rki_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ထို့နောက် ကောင်းကင်တမန်က “သင်၏ ခါးပတ်ကို ပတ်၍ ခြီနင်းကို စီးလော့” ဟု ဆိုသည့်အတိုင်း ပေတရုသည် ပြုလေ၏။ တဖန် ကောင်းကင်တမန်က “သင်၏ ဝတ်ရုံကို ဝတ်၍ ငါ့နောက်က လိုက်လော့” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ထိုအခါ ပေတရုသည် အကျဉ်းထောင်ထဲမှ ထွက်၍ ထိုကောင်းကင်တမန်နောက်သို့ လိုက်လေ၏။ သို့သော်လည်း ထိုကောင်းကင်တမန် ပြုသောအမှုသည် မှား၏၊ မှန်၏ ဆိုသည်ကို မသိဘဲ၊ သူသည် ရူပါရုံတစ်ခုကို မြင်သည်ဟု ထင်မှတ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","သူရို့သည် ပထမကင်း၊ ဒုတိယကင်းများကို ကျော်ဖြတ်ပြီး၊ နောက်ဆုံး၌ မြို့ဝင် သံတန်းခါးဝသို့ ရောက်လာကြ၏။ ထိုတန်းခါးသည် သူရို့အဖို့အလို့ငှာ အလိုအလျောက် ပွင့်လာသည်ဖြစ်၍ သူရို့သည်လည်း ထိုသံတန်းခါးဝမှ ထွက်ကာ တစ်လမ်းတည်းအတူ လမ်းလျှောက်လာကြပြီးမှ ထိုကောင်းကင်တမန်သည် ပေတရုအနားမှ ရုတ်တရက် ထွက်ခွာလားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","ထိုအခါ ပေတရုသည် သူ၌ ဖြစ်ခသည့် အမှုအရာတိကို သဘောပေါက်လာပြီး “သခင်ဘုရားသည် ဟေရုဒ်၏လက်မှ လည်းကောင်း၊ ယုဒလူမျိုးတိ မျှော်လင့်ထားသောအရာတိုင်းမှ လည်းကောင်း၊ ငါ့အား ကယ်တင်ခြင်းငှာ မိမိ၏ကောင်းကင်တမန်ကို စီရွှတ်လိုက်သည်မှာ လုံးဝ မှန်ကန်သည်ကို အဂု ငါ သိရယာ” ဟု ဆိုလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ပေတရုသည် မိမိရောက်နိန်သည့် နီရာကို သတိထားမိကာ ယောဟန် မာကု၏အမိ မာရိ အိမ်သို့ လားလေ၏။ ထိုအိမ်သည်ကား လူအများစုဝေးကာ ဆုတောင်းနိန်ကြသော နီရာဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","ပေတရုသည် အပြင်မှ တန်းခါးကို ခေါက်လိုက်သောအခါ ရောဒေ ဟုခေါ်သော အစီခံမိန်းမချေ တစ်ယောက်သည် တန်းခါးကို ဖွင့်ခြင်းငှာ ရောက်လာ၏။ ");
INSERT INTO rki_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","သူမသည် ပေတရု၏အသံကို မှတ်မိသည်ဖြစ်၍ အလွန်ဝမ်းမြောက်သောစိတ်ဖြင့် တန်းခါးကို မဖွင့်ခဘဲ အိမ်ထဲသို့ ပြန်၍ ဗြီးဝင်ကာ ပေတရုသည် အပြင်မှာ ရောက်နိန်ကြောင်းကို အံအားသင့်စွာ ပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","သူရို့က “သင် ရူးနိန်ယာ” ဟု သူမအား ဆိုကြ၏။ သို့သော် သူမက မိမိပြောသည်မှာ အမှန်ပင်ဖြစ်သည်ဟု ပြန်၍ အခိုင်အမာဆိုလေ၏။ ထိုအခါ သူရို့က “ထိုသူကား ပေတရုကို စောင့်ရှောက်သော ကောင်းကင်တမန်သာ ဖြစ်ရမည်” ဟု ပြောကြပြန်၏။ ");
INSERT INTO rki_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","ထိုအချိန်တွင် ပေတရုသည် တန်းခါးကို ဆက်လက်၍ ခေါက်နိန်သည်ဖြစ်၍ နောက်ဆုံး၌ သူရို့သည် တန်ခါးကို ဖွင့်ကြည့်လိုက်သော်၊ ပေတရုကို တွိ့မြင်ကြသဖြင့် သူရို့သည် အလွန် အံ့ဩကြရလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","ပေတရုသည် သူရို့အား တိတ်တိတ် နိန်ကြရန် လက်ရိပ်ပြလျက်၊ ပြီးမှ သခင်ဘုရားသည် အကျဉ်းထောင်ထဲက မိမိအား ဇာပိုင် ကယ်ထုတ်လိုက်ကြောင်း သူရို့ကို ယှင်းပြလေ၏။ “ဤအကြောင်းကို ယာကုပ်နှင့် ကျန်သော ယုံကြည်သူ တိကိုလည်း ပြောပြလိုက်ကြ” ဟု ဆိုကာ အခြားတစ်နီရာသို့ ထွက်လား၏။ ");
INSERT INTO rki_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","မိုးလင်းသောအခါ ပေတရု၌ ဖြစ်ပျက်ခသည်နှင့် ပတ်သက်၍ အစောင့်စစ်သားများသည် ဝရုန်းသုန်းကား ဖြစ်နိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ထို့ကြောင့် ဟေရုဒ်က ပေတရုကို ရှာဖွီရန် အမိန့်ပီးလိုက်၏။ သို့သော်လည်း စစ်သားတိက ပေတရုကို ရှာမတွိ့နိုင်ကြပေ။ ထိုအခါ ဟေရုဒ်သည် အစောင့်စစ်သားများကို မိန်းမြန်းစစ်ဆီးပြီးလျှင် သူရို့ကို အသီ သတ်ပစ်ရန် အမိန့်ပီးလိုက်လေ၏။ ထို့နောက် ဟေရုဒ်သည် ယုဒပြည်မှ ထွက်ခွာ၍ ကဲသရိမြို့၌ အချိန်အင်တန်ကြာ နန်းစံတော်မူလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ဟေရုဒ်သည် တုရုနှင့် ဇိဒုန်မြို့သားတိကို အကြီးအကျယ် ဒေါသထွက်လေ၏။ ထို့ကြောင့် သူရို့သည် ဟေရုဒ်အား တွိ့ခြင်းငှာ အုပ်စုဖွဲ့၍ ရောက်လာကြ၏။ သူရို့က မိမိရို့အား အကူအညီပီးရန် နန်းရင်းဝန် ဗလတ္တုအား ဦးစွာ စည်းရုံးလေ၏။ ထို့နောက် သူရို့သည် ဟေရုဒ်ပါးသို့ ဝင်ရောက်ကာ မင်းကြီး၏ဒေါသစိတ်ကို ပြေငြိမ်းစီခြင်းငှာ တောင်းပန်ကြ၏။ အကြောင်းမူကား သူရို့၏နိုင်ငံသည် မင်းကြီး၏နိုင်ငံမှ အစားအစာ ထောက်ပံ့မှုများကို အမှီပြုနိန်ရသောကြောင့်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ချိန်းဆိုထားသော နိ့တစ်နိ့တွင် ဟေရုဒ်သည် မိမိ၏မင်းဝတ်တန်ဆာများကို ဝတ်ဆင်၍ တရားပလ္လင်ထက်မှာ ထိုင်ကာ လုထုကို မိန့်ခွန်းပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","ထိုအခါ လူတိက “ဤအသံကား လူတစ်ယောက်၏စကားသံ မဟုတ်၊ နတ်ဘုရား တစ်ပါး၏ စကားသံသာ ဖြစ်တော်မူသည်တကား” ဟု ကြွေးကြော်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ထိုမင်းသည် ဘုရားသခင်ကို ရိုသီချီးမွမ်းခြင်း မဟိသောကြောင့် သခင်ဘုရား၏ကောင်းကင်တမန်သည် ချက်ချင်း ဟေရုဒ်ကို ဒဏ်ခတ်တော်မူလေ၏။ ထို့နောက် သူ့ကို သန်ကောင်များ ကိုက်စားပြီးလျှင် အနိစ္စရောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","ထိုအချိန်ကာလအတွင်း ဘုရားသခင်၏ နှုတ်ကပတ်တော်သည်ကား ဆက်လက်၍ ပြန့်ပွားသဖြင့် ယုံကြည်သူများလည်း သာ၍ တိုးပွားလာလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ဗာနဗနှင့် သျှောလုသည်လည်း မိမိရို့၏ သာသနာပြုခြင်းအမှုကို ပြီးမြောက်ပြီဖြစ်သောကြောင့်၊ ယောဟန် မာကု ကို သူရို့နှင့်အတူ ခေါ်ဆောင်၍ ယေရုဆလင်မြို့မှ ပြန်လာကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","အန္တိအုတ်မြို့ အသင်းတော်၌ဟိကြသော တချို့သော ဆရာတိနှင့် ပရောဖက်များမှာ၊ ဗာနဗ၊ နိဂါဟု ခေါ်သော သျှုမောင်၊ ကုရေနေပြည်သား လုကိ၊ (ဟေရုဒ်မင်းနှင့်အတူ ကြီးပြင်းလာသူ တစ်ယောက်ဖြစ်သော) မာနင်နှင့် သျှောလု ရို့ဖြစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","သူရို့သည် အစာယှောင်လျက် သခင်ဘုရားကို ဝတ်ပြုကိုးကွယ်နိန်ကြစဉ်၊ သန့်ယှင်းသော ဝိညာဉ်တော်က “ငါ၏အမှုကို ဆောင်ရွက်ရန် ငါခေါ်ထားသော ဗာနဗနှင့် သျှောလုကို ရွီးချယ်၍ ခန့်အပ်ကြလော့” ဟု သူရို့အား ပြော၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","သူရို့သည် အစာယှောင်၍ ဆုတောင်းပြီးမှ ဗာနာဗနှင့် သျှောလု၏ဂေါင်းထက်တွင် လက်ကိုတင်၍ စီရွှတ်လိုက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","ထိုသို့ သန့်ယှင်းသောဝိညာဉ်တော် ပို့ဆောင်ခြင်းဖြင့် ဗာနဗနှင့် သျှောလုသည် သေလုကိမြို့သို့ ရောက်ကြ၏။ ထိုမြို့မှ တဖန် ကုပရုကျွန်းသို့ သင်္ဘောဖြင့် ရွက်ရွှင့်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","သူရို့သည် ယှာလမိမြို့သို့ ရောက်ကြသောအခါ ယုဒလူမျိုးရို့၏ တရားဇရပ်များ၌ ဘုရားသခင်၏ နှုတ်ကပတ်တော်ကို ဟောပြောကြ၏။ ယောဟန် မာကု သည်လည်း သူရို့ကို အလုပ်ကူညီခြင်းငှာ သူရို့နှင့်အတူ လိုက်လာ၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","သူရို့သည် တစ်ကျွန်းလုံးကို လှည့်လည်ကြပြီးမှ ပါဖုမြို့သို့ ရောက်ကြ၏။ ထိုမြို့၌ သူရို့သည် မိမိကိုမိမိ ပရောဖက်တစ်ပါးဟု ကြွေးကြော်နိန်သည့် ယုဒလူမျိုး ဗာယေသျှုဟု ခေါ်သော မှော်ဆရာတစ်ယောက်နှင့် တွိ့ဆုံကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","ထိုသူသည် ဉာဏ်အမြော်အမြင်ဟိသော ကျွန်းပိုင်မင်း သေရဂိပေါလု၏ သူငယ်ချင်းတစ်ယောက် ဖြစ်၏။ ထိုကျွန်းပိုင်မင်းသည် ဘုရားသခင်၏နှုတ်ကပတ်တော်ကို ကြားနာလိုသဖြင့် သျှောလုနှင့် ဗာနဗကို သူ၏ရှိ့မှောက်သို့ ဖိတ်ခေါ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","သို့ရာတွင် ကျွန်းပိုင်မင်းကို ယုံကြည်ခြင်းမှ လမ်းလွဲစီရန် ကြိုးစားသည့် ဟေလသဘာသာ စကားအားဖြင့် ဧလုမဟု ခေါ်သော ထိုမှော်ဆရာသည် တမန်တော်တိကို ဟန့်တားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","ထိုအခါ ပေါလုဟု လူသိများသော သျှောလုသည် သန့်ယှင်းသောဝိညာဉ်တော်နှင့် ပြည့်လျက် ထိုမှော်ဆရာအား စိစိကြည့်ကာ ");
INSERT INTO rki_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“သင်သည်ကား မာရ်နတ်၏သား၊ ဖြောင့်မတ်ခြင်းတရား ဟူသမျှ၏ ရန်သူ ဖြစ်၏။ သင်သည် ကောက်ကျစ်ယုတ်မာသော ပရိယာယ်အမျိုးမျိုးဖြင့် သခင်ဘုရား၏ သမ္မာတရား တိကို လှည့်ဖြားခြင်းငှာ အစဉ်မပြတ် ကြိုးစားနိန်သည်တကား။ ");
INSERT INTO rki_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","အဂုတွင် သခင်ဘုရား၏လက်တော်သည် သင့်ပါးသို့ ကျရောက်၍ သင်သည် နိ့၏အလင်းကိုတောင် မမြင်နိုင်လောက်အောင် ကာလအတန်ကြာ မျက်စိကန်းနိန်လိမ့်မည်” ဟု ဆိုလေ၏။ ထိုသို့ ဆိုသည်နှင့် ဧလုမ၏မျက်စိသည် ချက်ချင်း ကန်းလားလေ၏။ ထိုအခါ သူသည် တဝဲလည်လည်ဖြင့် လက်ဆွဲခေါ်ဆောင်မည့်သူကို ရှာနိန်ရလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ထိုအဖြစ်အပျက်ကို ကျွန်းပိုင်မင်းက မြင်သောခါ၊ သခင်ဘုရားနှင့် ပတ်သက်သော သွန်သင်ချက်ကို အကြီးအကျယ် အံ့ဩလားပြီးလျှင် သူသည် ယုံကြည်ခြင်းသို့ ရောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","ပေါလုနှင့် သူ၏အပေါင်းအဖော်များသည် ပါဖုမြို့မှ ရွက်ရွှင့်၍ လာကြရာ ပမ်ဖုလိပြည် ပေရဂံမြို့သို့ ရောက်ကြ၏။ ယောဟန်သည် သူရို့ကို ထိုနီရာ၌ ထားခပြီးလျှင် ယေရုဆလင်မြို့သို့ ပြန်လာလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","သူရို့သည် ပေရဂံမြို့မှ ထွက်လာပြီးနောက် ပိသိဒိပြည် အန္တိအုတ်မြို့သို့ ရောက်ကြပြီးလျှင် သူရို့သည် ဥပုသ်နိ့၌ တရားဇရပ်သို့ လားရောက်၍ ဝင်ထိုင်ကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","မောသျှေ၏ပညတ်တရားကျမ်းနှင့် ပရောဖက်ကျမ်းများကို ဖတ်ရွတ်ပြီးသောအခါ တရားဇရပ်မှူးများက တမန်တော်တိအား “ညီအစ်ကိုရို့၊ သင်ရို့မှာ လူတိကို အားပီးတိုက်တွန်းစကား ဟောပြောစရာဟိလျှင် သူရို့ကို ဟောပြောပီးကြပါရန် အကျွန်ရို့ လိုလားပါ၏” ဟု လူတစ်ယောက်ကို ရွှတ်၍ ပြောခိုင်းလိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ထိုအခါ ပေါလုသည် မတ်တတ်ထ၍ လက်ရိပ်ပြကာ စတင်၍ ဟောပြောလိုက်သည်မှာ၊ “ဤနီရာ၌ ဟိကြသော မိတ်ဆွီ ဣသရေလလူမျိုးတိနှင့် ဘုရားသခင်ကို ဝတ်ပြုကိုးကွယ်ကြသော တခြားလူမျိုးအပေါင်းရို့၊ ငါ့စကားကို နားထောင်ကြလော့၊ ");
INSERT INTO rki_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ဣသရေလလူမျိုး၏ ဘုရားသခင်သည် ငါရို့၏ အဖိုးအဖီးတိကို ရွီးကောက်တော်မူ၍ သူရို့သည် အဲဂုတ္တုပြည်၌ တိုင်းတစ်ပါးသားအဖြစ် နီထိုင်ကြစဉ်တွင် သူရို့ကို လူမျိုးကြီးအဖြစ် ချီးမြှောက်တော်မူခ၏။ ဘုရားသခင်သည် မိမိ၏ကြီးမြတ်သော တန်ခိုးတော်ဖြင့် ထိုသူရို့ကို အဲဂုတ္တုပြည်မှ ထုတ်ဆောင်တော်မူခ၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ထို့အပြင် ကိုယ်တော်သည် သူရို့ကို တောကန္တာရ၌ အနှစ်လေးဆယ် ကာလပတ်လုံး သည်းခံတော်မူခ၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ကိုယ်တော်သည် ခါနာန်ပြည်၌ ဟိသော လူမျိုး ခုနစ်မျိုးကို ဖျက်ဆီးပြီးလျှင် ထိုပြည်ကို မိမိလူမျိုးအား အပိုင်ပီးတော်မူခ၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ဤသို့ဖြစ်ပျက်ခသည်မှာ နှစ်ပေါင်း ၄၅၀ ခန့် ကြာခလေ၏။ “ဤသို့ ဖြစ်ပျက်ခပြီးနောက် ဘုရားသခင်သည် သူရို့ကို ပရောဖက် သျှာမွေလ ကာလတိုင်အောင် တရားသူကြီးများဖြင့် အုပ်ချုပ်စီခ၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","ထို့နောက် သူရို့က သျှင်ဘုရင်တစ်ပါးကို တောင်းကြသောအခါ ဘုရားသခင်က ဗင်္ယာမိန်လူမျိုး ကိသျှ၏သား သျှောလု ကို သူရို့၏သျှင်ဘုရင်တစ်ပါးအဖြစ် အနှစ် ၄၀ ကြာ အုပ်ချုပ်စီတော်မူခ၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","ဘုရားသခင်သည် သျှောလုကို ဖယ်ယှားပြီးနောက် ဒါဝိဒ်ကို သူရို့၏ သျှင်ဘုရင်အဖြစ် ချီးမြောက်တော်မူ၏။ ဘုရားသခင်က ဒါဝိဒ်နှင့်ပတ်သက်၍ ထောက်ခံပြောဆိုသည်မှာ ‘ယေသျှဲ၏သား ဒါဝိဒ်သည် ငါ နှစ်သက်သောသူ တစ်ယောက်ဖြစ်၏၊ သူသည်ကား ငါ့စိတ်အလိုဟိသည့် အရာအားလုံးကို လုပ်ဆောင်ပီးမည့်သူ တစ်ယောက်ဖြစ်သည်ကို ငါတွိ့ရ၏’ ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","ဘုရားသခင်သည် မိမိ ကတိပီးထားသည့်အတိုင်း ဣသရေလလူမျိုးများ၏ကယ်တင်သျှင်ကို ချီးမြှောက်ပီးတော်မူ၏။ ထိုသူမှာ ဒါဝိဒ်၏မျိုးမှ ဆင်းသက်လာသူတစ်ယောက်ဖြစ်သော ယေသျှုပင်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","ယေသျှုသည် သူ၏သာသနာလုပ်ငန်းကို မစတင်ခင်၊ ယောဟန်သည် ဣသရေလလူမျိုး အပေါင်းရို့အား မိမိရို့အပြစ်မှ နောင်တရ၍ ဗတ္တိဇံကို ခံယူကြရန် ဟောပြောခ၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ထို့နောက် ယောဟန်သည် မိမိ၏သာသနာ လုပ်ငန်းကို အဆုံးသတ်မည့်အကြောင်း လူတိကို ပြောကြားသည်မှာ၊ ‘သင်ရို့က ငါသည် ဇာသူဖြစ်သည်ဟု ထင်ကြသနည်း၊ ငါသည်ကား သင်ရို့ စောင့်မျှော်နိန်သော သူတစ်ယောက် မဟုတ်၊ ထိုသူကား ငါ့နောက်မှ ကြွလာသောသူဖြစ်၏။ သူ၏ ခြီနင်းကြိုးကို ဖြီပီးဖို့ရန်ပင် ငါသည် မထိုက်တန်’ ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“အာဗြဟံမျိုးနွယ်ဖြစ်ကြသော ငါ၏ညီအစ်ကို ဣသရေလလူမျိုးများနှင့် ဘုရားသခင်ကို ဝတ်ပြုကိုးကွယ်ကြသော တခြားသောလူမျိုးအပေါင်းရို့၊ ဤကယ်တင်ခြင်း သတင်းကောင်းကို ပို့ဆောင်ပီးလိုက်သည်မှာ ငါရို့အတွက် ဖြစ်ပေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","ယေရုဆလင်မြို့၌ နီထိုင်ကြသောသူတိနှင့် သူရို့၏ခေါင်းဆောင်တိ ကား ထိုအသျှင်သည် ကယ်တင်သျှင်ဖြစ်သည်ကို မသိကြ၊ ဥပုသ်နိ့တိုင်း ရွတ်ဖတ်ကြသော ပရောဖက်များ၏ စကားကိုလည်း နားမလည်ကြ။ ထို့ကြောင့် သူရို့သည် ယေသျှုကို ပြစ်ဒဏ်စီရင်ခြင်းအားဖြင့် ပရောဖက်တိ စကားကို ပြည့်စုံလာစီ၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","သူရို့သည် ကိုယ်တော်၌ သီဒဏ်ပီးလောက်သောအပြစ် တစ်စုံတစ်ခုမျှ မတွိ့သော်လည်း ကိုယ်တော့်ကို အသီသတ်ခြင်းငှာ ပိလတ်မင်းထံ၌ တောင်းဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","သူရို့သည်ကား ကိုယ်တော့်ကို ရည်မှတ်၍ ရီးထားသောကျမ်းစာအတိုင်း လုပ်ဆောင်ကြပြီးလျှင် အလောင်းတော်ကို လက်ဝါးကပ်တိုင်မှ ချ၍ သင်္ချိုင်းဂူ တစ်ခုထဲ၌ သွင်းထားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","သို့သော်လည်း ဘုရားသခင်သည် ကိုယ်တော့်ကို သီခြင်းမှ ထမြောက်စီတော်မူပြီးလျှင် ");
INSERT INTO rki_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ကိုယ်တော်သည် ဂါလိလဲပြည်မှ ယေရုဆလင်မြို့ထိတိုင် မိမိနှင့်အတူ ခရီးလားလာခသော သူတိကို နိ့ရက်များစွာ ကိုယ်ထင်ပြတော်မူခ၏။ ထိုသူရို့သည်ကား အဂုအခါ ဣသရေလလူမျိုးတိအတွက် ကိုယ်တော်၏မျက်မြင်သက်သီများ ဖြစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","ငါရို့သည် ဘုရားသခင်က ငါရို့ အဖိုးအဖီးတိအား ကတိပီးထားခသော သတင်းကောင်းတရားကို သင်ရို့အား ဟောပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ဘုရားသခင်သည် ယေသျှုကို သီခြင်းတရားက ထမြောက်စီခြင်းအားဖြင့် ထိုအဖိုးအဖီးရို့မှ ဆင်းသက်လာကြသော ငါရို့အတွက် ထိုဂတိတော်သည် ပြည့်စုံလာ၏။ ဆာလံကျမ်း၏ ဒုတိယအခန်း၌ ထိုကတိတော်အကြောင်းကို ရီးထားသည်မှာ၊ “ ‘သင်သည် ငါ၏သား ဖြစ်၏။ ဤနိ့၌ ငါသည်လည်း သင်၏အဖ ဖြစ်၏’ ဟူ၍ ဖြစ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","တဖန်ကိုယ်တော့်ကို သီခြင်းတရားက ထမြောက်တော်မူပြီး သင်္ချိုင်းတွင်း၌ ပုပ်ပျက်ခြင်းနှင့် အစဉ်ကင်းလွတ်စီမည့်အကြောင်း ဘုရားသခင် မိန့်တော်မူခသည်မှာ၊ ‘ငါသည် ဒါဝိဒ်အား ကတိပီးထားခသည့်အတိုင်း သန့်ယှင်းမြင့်မြတ်၍ စစ်မှန်သော ကောင်းကြီးမင်္ဂလာကို သင့်အား ပီးမည်’ ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ထို့ကြောင့် တခြားသော ဆာလံကျမ်းစာ၌ ဒါဝိဒ် ပြောထားသည်မှာ ‘ကိုယ်တော်သည် မိမိ၏သစ္စာဟိသော အခိုင်းအစီကို သင်္ချိုင်းတွင်း၌ ပုပ်ပျက်စီခြင်းငှာ အခွင့်ပီးတော်မမူ’ ဟု လာ၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","ဒါဝိဒ်သည် သူ၏ဘဝတလျှောက်၌ ဘုရားသခင်၏ အလိုတော်ကို ဆောင်ရွက်ခ၏။ ထို့နောက် သူသည် အနိစ္စရောက်ပြီးလျှင် သူ၏အဖိုးအဖီးတိနှင့်အတူ သင်္ဂြိုဟ်ခြင်းကို ခံရ၏၊ သူ၏ခန္ဓာသည်လည်း သင်္ချိုင်းတွင်း၌ ပုပ်ပျက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","သို့ရာတွင် ဘုရားသခင် သီခြင်းတရားက ထမြောက်စီတော်မူသော သူသည်ကား ပုပ်ပျက်ခြင်းသို့ မရောက်စီရ။ ");
INSERT INTO rki_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","ထို့ကြောင့် ငါ၏ညီအစ်ကို ဣသရေလလူမျိုးရို့၊ သင်ရို့အား ဟောပြောခသော အပြစ်လွှတ်ခြင်းဆိုင်ရာ တရားတော်သည် ယေသျှုအားဖြင့် ဖြစ်သည်ကိုလည်းကောင်း၊ ယေသျှုကို ယုံကြည်သောသူတိုင်းသည် မောသျှေ၏ ပညတ်တရားအားဖြင့် သင်ရို့ မလွတ်နိုင်သော အပြစ်အားလုံးမှ လွတ်မြောက်ခွင့်ရသည်ကိုလည်းကောင်း ငါရို့သည် သင်ရို့အား သိစီလိုပါ၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ပရောဖက်ရို့ ဟောပြောခသည့်အတိုင်း သင်ရို့၌ မဖြစ်စီခြင်းငှာ သတိပြုကြလော့။ ထိုဟောပြောချက်မှာ၊ ");
INSERT INTO rki_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘ပျက်ရယ်ပြု လှောင်ပြောင်ကြသောသူရို့၊ ကြည့်ထားကြ၊ သင်ရို့သည် အံ့ဩ၍ ပျက်စီးဆုံးယှုံးခြင်းသို့ ရောက်ကြရမည်၊ အကြောင်းမူကား ဤနိ့၌ ငါ ပြုလုပ်နိန်သော အရာများကို သင်ရို့သည် ယုံကြည်ကြလိမ့်မည် မဟုတ်၊ သင်ရို့အား ထိုအမှုကို ယှင်းပြသောသူ ဟိသော်လည်း သင်ရို့သည် ယုံကြည်ကြလိမ့်မည် မဟုတ်’ ” ဟူ၍ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ပေါလုနှင့် ဗာနဗသည် တရားဇရပ်မှ ထွက်ခွာလာကြစဉ်တွင် လူများက ဤအကြောင်းအရာများကို သူရို့အား နောက်တစ်ပတ် ဥပုသ်နိ့တွင် ဤထက်မက ဟောကြားပီးပါရန် တောင်းပန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","လူအပေါင်းရို့သည် ဝတ်ပြုစည်းဝေးပွဲမှ ထွက်ခွာလားကြပြီးနောက် ယုဒလူမျိုးတိနှင့် ယုဒဘာသာဝင်အဖြစ်သို့ ခံယူထားကြသော တခြားလူမျိုးများစွာရို့သည် ပေါလုနှင့် ဗာနဗ၏ နောက်သို့ လိုက်ပါလားကြ၏။ တမန်တော်တိက သူရို့အား ပြောဆို၍ ဘုရားသခင်၏ ကျေးဇူးတော်၌ အစဉ်အမြဲ ရှင်သန်ကြရန် သူရို့ကို အားပီးတိုက်တွန်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","နောက်တစ်နိ့ ဥပုသ်နိ့တွင် မြို့လုံးကျွတ်နီးပါးသော လူများစွာရို့သည် ဘုရားသခင်၏နှုတ်ကပတ်တော်ကို ကြားနာခြင်းငှာ ရောက်လာကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","ယုဒလူမျိုးတိသည် ထိုလူစုလူဝေးကို မြင်သောအခါ မနာလိုစိတ်ဖြစ်ကြပြီးလျှင် ပေါလုပြောသမျှကို ဆန့်ကျင်လျက် ကဲ့ရဲ့ဆဲဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","ထိုအခါ ပေါလုနှင့် ဗာနဗ ရို့က “ငါရို့သည် သင်ရို့အား ဘုရားသခင်၏ နှုတ်ကပတ်တော်ကို အဦးဆုံး ပြောပြလိုပါ၏။ သို့သော်လည်း သင်ရို့သည် ထာဝရအသက်ကို တန်ဖိုးမထားဘဲ ဘုရားသခင်၏ နှုတ်ကပတ်တော်ကို ငြင်းပယ်ကြသောကြောင့် ငါရို့သည် သင်ရို့ကို ထားခပြီးလျှင် အခြားလူမျိုးတိပါးသို့ ခရီးဆက်ကြရမည်ဟု ရဲရင့်ပြတ်သားစွာ ထုတ်ဖော်ပြောဆိုကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","သခင်ဘုရားက ငါရို့အား ပီးထားသော ပညတ်တရားမှာ၊ “ ‘ငါသည် သင်ရို့ကို တခြားသောလူမျိုးတိအတွက် အလင်း ဖြစ်စီခြင်းငှာ ခန့်ထားပြီးပြီ။ ထို့ကြောင့် လောကသားအားလုံး ကယ်တင်ခြင်းသို့ ရောက်စီခြင်းငှာ ဆောင်ရွက်ကြလော့’ ဟူ၍ ဖြစ်၏။” ");
INSERT INTO rki_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","လူမျိုးခြားတိက သခင်ဘုရား၏သတင်းစကားကို ကြားသောအခါ သူရို့သည် အလွန်ဝမ်းမြောက်ကြသည်ဖြစ်၍ သခင်ဘုရား၏တရားတော်ကို ချီးမွမ်းကြ၏။ ထာဝရအသက်ကို ရစီခြင်းငှာ ရွီးချယ်ထားသော သူရို့သည်လည်း ယုံကြည်သူများ ဖြစ်လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","သခင်ဘုရား၏နှုတ်ကပတ်တော်သည် ထိုဒေသ၏နီရာတိုင်းသို့ ပြန့်နှံ့လားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","သို့ရာတွင် ယုဒလူမျိုးရို့က မြို့မိမြို့ဖတိနှင့် ဘုရားသခင်ကို ကိုးကွယ်ကြသော ဂုဏ်အသရေဟိ လူမျိုးခြား မိန်းမတိကို သွီးထိုး လှုံ့ဆော်ကြ၏။ ထို့ကြောင့် ထိုသူရို့သည် ပေါလုနှင့် ဗာနဗ ကို စတင်၍ ညည်းပန်းနှိပ်စက်ကြပြီးလျှင် မိမိရို့၏အရပ်ဒေသမှ နှင်ထုတ်ကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","တမန်တော်တိကလည်း ထိုသူရို့ကို ဆန့်ကျင်သောအားဖြင့် မိမိရို့၏ ခြီဖဝါး၌ ကပ်နိန်သော မြီမှုန့်ကို ခါချပြီးလျှင် ဣကောနိမြို့သို့ ခရီးဆက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","အန္တိအုတ်မြို့ ယုံကြည်သူများသည်လည်း ဝမ်းမြောက်ခြင်းနှင့်လည်းကောင်း၊ သန့်ယှင်းသောဝိညာဉ်တော်နှင့်လည်းကောင်း ပြည့်ဝကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","ပေါလုနှင့် ဗာနဗ သည် ဣကောနိမြို့သို့ ရောက်လျှင် ယခင်နည်းတူ ယုဒတရားဇရပ်သို့ လားရောက်၍ ဟောပြောကြသဖြင့်၊ ယုဒလူမျိုးများနှင့် တခြားလူမျိုးများစွာရို့သည် ယုံကြည်သူများ ဖြစ်လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","သို့ရာတွင် ယုံကြည်ခြင်းကို ငြင်းပယ်သော ယုဒလူမျိုးတိက ယုံကြည်သူတိအား ဆန့်ကျင်တိုက်ခိုက်ရန် တခြားလူမျိုးရို့၏ စိတ်ကို လှုံ့ဆော်ပီးကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","တမန်တော်ရို့သည် သခင်ဘုရားအကြောင်းကို ရဲရင့်စွာဟောပြောလျက် ထိုနီရာ၌ အချိန်အတန်ကြာ တည်းခိုနိန်ခလေ၏။ အသျှင်ဘုရားကလည်း တမန်တော်တိအား နိမိတ်လက္ခဏာနှင့် အံဖွယ်သောအမှုအရာတိကို ပြနိုင်စီခြင်းငှာ တန်ခိုးပီးတော်မူသည်ဖြစ်၍ သူရို့ဟောပြောသော သတင်းကောင်းတရားသည် သခင်ဘုရား၏ကျေးဇူးတော် အမှန်ပင်ဖြစ်ကြောင်းကို သက်သီပြတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","ထိုမြို့သူမြို့သားအပေါင်းရို့သည် ကွဲပြားကာ တချို့သည် ယုဒလူမျိုးရို့ဖက်၌ လည်းကောင်း၊ တချို့သည် တမန်တော်ရို့ဖက်၌လည်းကောင်း နီကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","ထို့နောက် တချို့သော ယုဒလူမျိုးတိနှင့် တချို့သော အခြားလူမျိုးရို့သည် မိမိရို့၏ခေါင်းဆောင်တိနှင့် ပူပေါင်းကာ တမန်တော်တိကို ညှဉ်းဆဲရန်နှင့် ကျောက်သီးနှင့် ပစ်ရန်ဆုံးဖြတ်ချက် ချထားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","တမန်တော်ရို့က ထိုအကြောင်းကို သိလျှင် လုကောနိပြည်၌ဟိသော လုတ္တရမြို့၊ ဒေရဗေမြို့နှင့် ပတ်ဝန်းကျင်ဒေသများသို့ ထွက်ဗြီးကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ထိုအရပ်များ၌ သူရို့သည် သတင်းကောင်းတရားကို ဆက်လက်၍ ဟောပြောကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","လုတ္တရမြို့၌ လမ်းမလျှောက်နိုင်သော ဝမ်းတွင်းပါ ခြီမစွမ်းသူ တစ်ယောက်ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ထိုသူသည် ပေါလုဟောပြောသည်ကို ထိုင်လျက် နားထောင်နိန်၏။ ပေါလုသည် ထိုသူ၌ ရောဂါပျောက်ကင်းနိုင်လောက်သော ယုံကြည်ခြင်းဟိသည်ကို မြင်လျှင် သူ့အား စိ့စိ့ ကြည့်လျက်၊ ");
INSERT INTO rki_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","“ထ၍ မတ်တတ်ရပ်လော့” ဟု ကျယ်သောအသံဖြင့် ပြောလိုက်သဖြင့်၊ ထိုသူသည် ခုန်၍ ထပြီးလျှင် စတင်၍ လမ်းလျှောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","ထိုအခါ လူအပေါင်းရို့သည် ပေါလု ပြုသောအမှုကို မြင်ကြသော် “နတ်ဘုရားတိ လူယောင်ဆောင်၍ ငါရို့ပါးသို့ ဆင်းလာကတ်ယာ” ဟု မိမိရို့၏လုကောနိ ဘာသာစကားဖြင့် အော်ဟစ်၍ ပြောဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","ပေါလုသည် အဓိကဟောပြောသောသူဖြစ်သောကြောင့် သူ့ကို ဟေရမေ ဟူ၍ လည်းကောင်း၊ ဗာနဗ အား ဇုသ ဟူ၍လည်းကောင်း သူရို့က နာမည်ပီးကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ထိုမြို့၏ဝင်ဝ၌ ယဇ်ပလ္လင်တည်၍ ကိုးကွယ်ထားကြသော ဇုသ နတ်ဘုရား၏ ယဇ်ပုရောဟိတ်သည် နွားထီးများနှင့် ပန်းကုံးများကို မြို့တံခါးနားသို့ ယူဆောင်လာကြပြီးလျှင် သူနှင့် လူအပေါင်းရို့သည် တမန်တော်များအား ယဇ်ပူဇော်ရန် ပြုလုပ်နိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","သူရို့သည် ထိုသို့ပြုသည်ကို တမန်တော်များဖြစ်ကြသော ဗာနဗနှင့် ပေါလု ကြားသောအခါ မိမိရို့ အဝတ်ကို ဆုတ်၍ လူအုပ်ထဲသို့ ဗြီးဝင်ပြီးလျှင် အော်ဟစ်လျက်၊ ");
INSERT INTO rki_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“သင်ရို့သည် ဇာကြောင့် ဤအရာတိကို လုပ်နိန်ကတ်လဲ၊ ငါရို့သည် သင်ရို့ပိုင် လူသားတိရာ ဖြစ်ပါ၏။ ငါရို့သည် သတင်းကောင်းတရားကို ဟောပြောဖို့ ဤနီရာသို့ ရောက်လာခြင်းဖြစ်၏၊ အကြောင်းမှာ သင်ရို့သည် အကျိုးမဟိသော ဤအရာတိကို ဖယ်ယှားပြီးလျင်၊ ကောင်းကင်၊ မြီကြီး၊ ပင်လယ်နှင့်တကွ ခပ်သိမ်းသော အရာတိကို ဖန်ဆင်းတော်မူသည့် အသက်ရှင်တော်မူသော ဘုရားသခင်ထံပါးသို့ ပြောင်းလဲကြစီခြင်းငှာ ဖြစ်ပါ၏။ ");
INSERT INTO rki_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","အတိတ်ကာလ၌ ဘုရားသခင်သည် လူမျိုးအပေါင်းရို့အား မိမိရို့၏နည်းလမ်းအတိုင်း လိုက်လျှောက်ကြရန် အခွင့်ပီးခ၏။ ");
INSERT INTO rki_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","သို့ရာတွင် ဘုရားသခင်သည် အာကာပြင်မှ မိုးရီကို ရွာသွန်းကာ အချိန်တန်လျှင် သင်ရို့အား ကောက်ပဲသီးနှံများကို ပီးလျက်၊ အစားအစာများကို ကျွေးမွေးတော်မူ၏။ ထို့ကြောင့် သင်ရို့၏နှလုံးသည် ရွှင်လန်းဝမ်းမြောက်မှုနှင့် ပြည့်စုံလျက်ဟိကြ၏။ အကြောင်းမူကား ကိုယ်တော်သည် ကောင်းသောအမှုအရာတိကို ပြုတော်မူလျက် မိမိဟိတော်မူကြောင်းကို အစဉ်အမြဲ ထင်ရှားစွာ ပြတော်မူ၏” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","ဤသို့ဖြင့် ယဇ်ပူဇော်ခြင်းကို မပြုကြရန် တမန်တော်တိက လူစုလူဝေးကြီးကို ခက်ခဲစွာ တားမြစ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","သို့ရာတွင် ပိသိဒိပြည် အန္တိအုတ်မြို့နှင့် ဣကောနိမြို့မှ ရောက်လာကြသော ယုဒလူမျိုးတချို့သည် လူစုလူဝေးကြီးကို မိမိဖက်သို့ ပါအောင် စည်းရုံးသိမ်းသွင်းပြီးလျှင် ပေါလုကို ကျောက်သီးနှင့် ပစ်၍ သီလားယာဟု စိတ်ထင်မှတ်သောကြောင့် မြို့ပြင်သို့ ဆွဲထုတ်ထားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","သို့ရာတွင် ယုံကြည်သူတိက သူ့ကို ဝိုင်းရံထားကြစဉ်တွင် သူသည် ထ၍ မြို့ထဲသို့ ပြန်ဝင်လား၏။ နောက်တစ်ရက်တွင် သူသည် ဗာနဗနှင့်အတူ ဒေရဗေမြို့သို့ ထွက်ခွာလား၏။ ");
INSERT INTO rki_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ပေါလုနှင့် ဗာနဗ ရို့သည် ဒေရဗေမြို့၌ သတင်းကောင်းတရားတော်မြတ်ကို ဟောပြောကြပြီးနောက် များစွာသောသူရို့သည် တပည့်တော်များဖြစ်လာကြ၏။ ထို့နောက် လုတ္တရမြို့၊ ဣကောနိမြို့နှင့် ပိသိဒိပြည် အန္တိအုတ်မြို့သို့ ပြန်လားခလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","သူရို့သည် ယုံကြည်သူများကို စစ်မှန်သောယုံကြည်ခြင်း၌ တည်ကြည်စီရန် အားပီး တိုက်တွန်းနှိုးဆော်ကြ၏။ “ဘုရားသခင်၏နိုင်ငံတော်သို့ ဝင်ရောက်ခြင်းငှာ ငါရို့သည် များစွာသော ဆင်းရဲဒုက္ခတိကို ကျော်ဖြတ်ကြရမည်” ဟု သွန်သင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","သူရို့သည် အသင်းတော်တိုင်း၌ အသင်းတော်လူကြီးတိကို ခန့်ထားပြီးလျှင် အစာယှောင်၍ ဆုတောင်းပတ္ထနာ ပြုလျက်၊ သခင်ဘုရားကို ယုံကြည်ကိုးစားကြသူရို့အား သခင်ဘုရား၏ လက်တော်သို့ အပ်နှံကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ပိသိဒိပြည် ဒေသတလျှောက် လားပြီးနောက် ပမ်ဖုလိပြည်သို့ လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ထိုပြည်၌ဟိသော ပေရဂံမြို့၌ သူရို့သည် နှုတ်ကပတ် တရားတော်ကို ဟောပြောကြပြီးနောက် အတ္တလိမြို့သို့ လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ထို့နောက် ထိုမြို့မှ သင်္ဘောဖြင့် ရွက်ရွှင့်ကာ အန္တိအုတ်မြို့သို့ ပြန်လာကြ၏။ ဤမြို့ကား သူရို့သည် အဂု ဆောင်ရွက်ပြီးခသော အမှုတော်မြတ်အတွက် ဘုရားသခင်၏ ကျေးဇူးတော်ကို သူရို့အား အပ်နှံခသော နီရာဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","သူရို့သည် အန္တိအုတ်မြို့သို့ ရောက်ကြသောအခါ အသင်းတော်၌ ဟိသောသူတိကို အတူတကွ စုဝေး၍ ဘုရားသခင်သည် သူရို့နှင့်အတူ ပြုတော်မူခသော အမှုအရာတိကိုလည်းကောင်း၊ လူမျိုးခြားတိ ယုံကြည်လာကြစီရန် ဘုရားသခင်က ဇာပိုင် လမ်းဖွင့်ပီးခသည်ကိုလည်းကောင်း သူရို့အား ပြောပြကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ထို့နောက် သူရို့သည် ယုံကြည်သူများနှင့်အတူ ထိုမြို့၌ အချိန်အတန်ကြာ နီထိုင်ခလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","ယုဒပြည်မှ အန္တိအုတ်မြို့သို့ ရောက်လာကြသော တချို့သောသူတိက “သင်ရို့သည် မောသျှေ၏ ပညတ်တရားအတိုင်း အရီဖျားလှီးခြင်းကို မခံလျှင် ကယ်တင်တော်မူခြင်းသို့ မရောက်နိုင်” ဟု ယုံကြည်သူတိကို ဆုံးမဩဝါဒပီးကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","ဤကိစ္စနှင့်ပတ်သက်၍ ပေါလုနှင့် ဗာနဗ ရို့သည် ထိုသူရို့နှင့် ပြင်းထန်စွာ ငြင်းခုံကြ၏။ ထို့ကြောင့် ပေါလု၊ ဗာနဗနှင့်အတူ အန္တိအုတ်မြို့မှ ယုံကြည်သူတချို့သည် ဤပြဿနာကြောင့် ယေရုဆလင်မြို့သို့လား၍ တမန်တော်တိ၊ အသင်းတော်လူကြီးတိနှင့် တွိ့ဆုံသင့်ကြောင်း ဆုံးဖြတ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","အသင်းတော်က သူရို့ကို ပို့ဆောင်ပီးသဖြင့် သူရို့သည် ဖိနိတ်ပြည်နှင့် ယှာမာရိပြည်ကို လျှောက်လားကြစဉ်တွင် လူမျိုးခြားတိ ဘုရားသခင်ထံသို့ ဇာပိုင် ပြောင်းလဲကြပုံကို ပြောပြကြသဖြင့် ယုံကြည်သူတိအားလုံး အလွန်ဝမ်းမြောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","သူရို့သည် ယေရုဆလင်မြို့သို့ ရောက်ကြသောအခါ တမန်တော်တိနှင့် အသင်းတော်လူကြီးတိ၊ အသင်းသူ အသင်းသားတိက သူရို့ကို ကြိုဆိုလက်ခံကြ၏။ သူရို့ကလည်း ဘုရားသခင်သည် မိမိရို့အားဖြင့် ပြုတော်မူခသော အရာအားလုံးကို ပြောပြကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","သို့ရာတွင် ဖာရိယှဲအုပ်စုထဲက ယုံကြည်သူတချို့သည် ထလျက် “လူမျိုးခြားတိ အရီဖျားလှီးခြင်းကို ခံယူပြီးလျှင် မောသျှေ၏ ပညတ်တရားကို လိုက်နာကြရမည်” ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","ထိုအခါ ဤအမှုကို စဉ်းစားဆင်ခြင်ရန် တမန်တော်တိနှင့် အသင်းတော်လူကြီးရို့သည် အတူတကွ တွိ့ဆုံကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","အချိန်အင်တန်ကြာ အပြန်အလှန် ဆွေးနွေးငြင်းခုံကြပြီးနောက် ပေတရုသည် ထလျက် “ညီအစ်ကို မောင်နှမရို့၊ လူမျိုးခြားတိသည် သတင်းကောင်းတရားကို ကြားနာ၍ ယုံကြည်ခြင်းသို့ ရောက်ကြစီခြင်းငှာ ထိုတရားကို ဟောပြောရန်အတွက် ဘုရားသခင်သည် ရှိ့ဦးစွာအားဖြင့် သင်ရို့အထဲက ငါ့ကို ရွီးကောက်တော်မူသည်ကို သင်ရို့သိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","ထို့ပြင် လူတိုင်း၏စိတ်နှလုံးအကြံအစည်ကို သိတော်မူသော ဘုရားသခင်သည် သန့်ယှင်းသောဝိညာဉ်တော်ကို ငါရို့ အားပီးသည့်နည်းတူ သူရို့ကိုလည်း ပီးတော်မူကြောင်းကို ထိုလူမျိုးခြားတိအားဖြင့် သက်သီပြတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ကိုယ်တော်သည် သူရို့နှင့် ငါရို့ကို ခွဲခြားထားသည် မဟုတ်။ အကြောင်းမူကား သူရို့သည် ယုံကြည်ကြသောကြောင့် ကိုယ်တော်သည် သူရို့၏အပြစ်ကို လွှတ်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","သို့ဖြစ်၍ သင်ရို့သည် ငါရို့ကိုယ်တိုင်သာမက ငါရို့ အဖိုးအဖီးတိကိုယ်တိုင် မထမ်းနိုင်ခသော ထမ်းပိုးကို ယုံကြည်သူတိ၏ နောက်ကုန်းထက်မှာ တင်ပြီးလျှင် ဇာကြောင့် ဘုရားသခင်ကို မထီလေးစားလုပ်နိန်ကတ်စွာလဲ။ ");
INSERT INTO rki_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","ယင်းပိုင် မလုပ်သင့်ပါကား။ အသျှင်ယေသျှု၏ ကျေးဇူးတော်ကြောင့် ငါရို့သည် ကယ်တင်တော်မူခြင်းကို ခံကြရသည်နည်းတူ၊ သူရို့သည်လည်း ခံကြရသည်ကို ငါရို့ ယုံကြည်ကြသည်” ဟူ၍ ပေတရုက ပြောဆို၏။ ");
INSERT INTO rki_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","ဗာနဗနှင့် ပေါလုက မိမိရို့အားဖြင့် လူမျိုးခြားတိ၌ ဘုရားသခင်ပြုတော်မူသော နိမိတ်လက္ခဏာတိ၊ အံ့ဩဖွယ်သောအမှုအရာတိကို ပြန်လည်ပြောပြကြသည်ကို ကြားရသောအခါ လူအပေါင်းရို့သည် ဆိတ်ငြိမ်နိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","သူရို့ ပြောဆိုပြီးမှ၊ ယာကုပ်သည် ထ၍ “ငါ၏ညီအစ်ကို မောင်နှမရို့၊ ငါ့စကားကို နားထောင်ကတ်ပါ။ ");
INSERT INTO rki_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ဘုရားသခင်သည် ရှီးဦးစွာ တခြားလူမျိုးတိထဲက လူတချို့ကို မိမိအဖို့ ကယ်နုတ်တော်မူခြင်းဖြင့် ထိုလူမျိုးခြားတိကို ဇာပိုင် ဂရုစိုက်တော်မူကြောင်း ဖော်ပြသည်ကို သျှိမုန်သည် ဂုတင်က ပြောပြခပြီးယာ။ ");
INSERT INTO rki_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ထိုအကြောင်းအရာသည်လည်း ပရောဖက်တိ ပြောခသော စကားနှင့် လုံးဝ ကိုက်ညီပေ၏။ ကျမ်းစာလာသည်ကား၊ ");
INSERT INTO rki_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“ ‘သခင်ဘုရားမိန့်တော်မူသည်မှာ၊ ငါသည် ပြန်လာပြီးလျှင် ဒါဝိဒ်၏နိုင်ငံကို ပြန်လည် တည်ဆောက်မည်၊ ငါသည် ထိုနိုင်ငံ၏အပျက်အစီးတိကို ပြုပြင်၍ ထိုနိုင်ငံတော်ကို တဖန်ခိုင်ခံ့စီမည်။ ");
INSERT INTO rki_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ပြီးနောက် လူမျိုးအားလုံး ငါ့ပါးသို့ လာကြလိမ့်မည်။ ငါခေါ်ထားသော တခြားလူမျိုးတိအားလုံးသည် ငါ၏လူတိ ဖြစ်လာကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ဤကား ရှီးကာလကပင် ဤအရာများကို သိတော်မူသော သခင်ဘုရား၏ မိန့်တော်မူချက် ဖြစ်သတည်း။’ ");
INSERT INTO rki_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“ထို့ကြောင့် ငါ့သဘောအတိုင်းဆိုလျှင် ဘုရားသခင်ပါးသို့ ပြောင်းလဲလာကြသည့် တခြားလူမျိုးတိကို ငါရို့က ဒုက္ခ မပီးသင့်ပေ၊ ");
INSERT INTO rki_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ဤသို့ ပြောမည့်အစား၊ ရုပ်တုဆင်းထုတိကို ပူဇော်ပသထားသည့် မစင်ကြယ်သော အစားအစာတိကိုလည်းကောင်း၊ မတရားသောမေထုန်လွန်ကျူးခြင်းကိုလည်းကောင်း၊ လိုင်ပင်းကို ညှစ်၍ သတ်ထားသောတိရစ္ဆာန်တိကိုလည်းကောင်း၊ အသွီးကိုလည်းကောင်း ယှောင်ကြဉ်ကြစီခြင်းငှာ စာရီး၍ သူရို့ကို မှာလိုက်သင့်၏။ ");
INSERT INTO rki_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","အကြောင်းမူကား၊ မောသျှေ၏ပညတ္တိကျမ်းကို ဥပုသ်နိ့တိုင်း တရားဇရပ်များတွင် ရွတ်ဖတ်လာကြသည်မှာ အချိန်ကာလ ကြာညောင်းခယာ၊ ထို့အပြင် သူ၏တရားတော်မြတ်ကို မြို့တိုင်းမှာ ဟောပြောလျက်ဟိကြ၏” ဟု ယာကုပ်က ပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","ထို့နောက် တမန်တော်တိ၊ အသင်းတော်လူကြီးတိနှင့် အသင်းတော် တစ်ခုလုံးက မိမိရို့အထဲမှ လူတချို့ကို ရွီးချယ်၍ ပေါလုနှင့် ဗာနဗ ရို့နှင့်အတူ အန္တိအုတ်မြို့သို့ စီရွှတ်ရန် ဆုံးဖြတ်ကြ၏။ ထိုအခါ ယုံကြည်သူများ အလွန်ရိုသီလေးစားကြသော ဗာသျှဗ ခေါ် ယုဒနှင့် သိလကို ရွီးချယ်၍ ");
INSERT INTO rki_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","သူရို့နှင့်အတူ စာကို ပို့လိုက်ကြ၏။ ထိုစာ၌၊ “တမန်တော်တိ၊ အသင်းတော်လူကြီးတိနှင့်တကွ သင်ရို့၏ ညီအစ်ကိုတိက အန္တိအုတ်မြို့မှစ၍ ယှုရိပြည်၊ ကိလိကိပြည်၌ နီထိုင်ကြသည့် တခြားလူမျိုးတိဖြစ်သော ငါရို့ ညီအစ်ကို အားလုံးကို နှုတ်ဆက်လိုက်ပါ၏။ ");
INSERT INTO rki_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","ငါရို့အထဲက လူတချို့သည် ငါရို့ပါးက ညွှန်ကြားချက် မပီးဘဲ သင်ရို့ပါးသို့ လား၍ သင်ရို့အား စိတ်အနှောင့်အယှက် ဖြစ်စီကြသည်ဟု ငါရို့ ကြားရ၏။ ");
INSERT INTO rki_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","သို့ဖြစ်၍ ငါရို့သည် အတူတကွ ဆွေးနွေးတိုင်ပင်ကြပြီးလျှင် လူတချို့ကို ရွီးချယ်၍ သင်ရို့ပါးသို့ စီရွှတ်ရန် အားလုံးက သဘောတူကြ၏။ ထိုသူရို့သည် ငါရို့၏ မိတ်ဆွီဖြစ်သော ဗာနဗသည် ပေါလုနှင့်အတူ ရောက်လာကြလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ထိုသူရို့ကား ငါရို့အသျှင် ယေသျှုခရစ်တော်၏ အမှုတော်ကို ဆောင်ခြင်းငှာ မိမိရို့၏အသက်ကို အပ်နှံထားသူများဖြစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","ထို့နောက် ငါရို့ ရီးပီးလိုက်သောစာအတိုင်း သင်ရို့အား နှုတ်ဖြင့် ပြောပြရန် ယုဒနှင့် သိလကို စီရွှတ်လိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","သန့်ယှင်းသောဝိညာဉ်တော်သည် လည်းကောင်း၊ ငါရို့သည် လည်းကောင်း ဤသို့သော လိုက်နာရမည့် စည်းမျဉ်းစည်းကမ်းမှတစ်ပါး အခြားသောဝန်ကို သင်ရို့ထက်မှာ တင်စီခြင်းငှာ မလိုလားအပ်ပေ။ ");
INSERT INTO rki_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ထိုလိုက်နာရမည့် စည်းမျဉ်းစည်းကမ်းများမှာ ရုပ်တုကို ပူဇော်ထားသော ယဇ်ကောင်ကိုလည်းကောင်း၊ အသွီးကိုလည်းကောင်း၊ လိုင်ပင်းညှစ်၍ သတ်ထားသော တိရစ္ဆာန်ကိုလည်း မစားရ။ မတရားသောမေထုန်လွန်ကျူးခြင်းကို ယှောင်ကြဉ်ကြရမည်။ သင်ရို့သည် ဤအရာတိကို မပြုလုပ်ဖို့ ဂရုစိုက်ကြမည်ဆိုလျှင် ကောင်းသောအမှုကို ပြုခြင်းဖြစ်၏။ လိုရာဆန္ဒ ပြည့်ဝကတ်ပါစီ” ဟူ၍ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","ထိုစီတမန်များသည် စီရွှတ်လိုက်သည်နှင့်အညီ၊ အန္တိအုတ်မြို့သို့ ရောက်ကြသောအခါ ယုံကြည်သူအားလုံးကို စုဝေးစီပြီးလျှင် ထိုစာကို သူရို့လက်သို့ ပီးအပ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ထိုသူရို့သည် စာကို ဖတ်ရသောအခါ ထိုစာ၌ပါသော အားပီးတိုက်တွန်းစကားကြောင့် ဝမ်းမြောက်ခြင်းနှင့် ပြည့်ဝကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ယုဒနှင့် သိလသည် သူရို့ကိုယ်တိုင် ပရောဖက်တိ ဖြစ်ကြသည်နှင့်အညီ ယုံကြည်သူတိကို အားပီးတိုက်တွန်းကာ အချိန်ကြာမြင့်စွာ ဟောပြောနိန်ခကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ထိုနီရာ၌ အချိန်အင်တန်ကြာ နီထိုင်ပြီးနောက် ယုံကြည်သူရို့က သူရို့အား ငြိမ်းချမ်းစွာ ပို့ဆောင်လိုက်ကြသဖြင့် သူရို့သည် မိမိရို့ကို စီရွှတ်လိုက်သော သူရို့ပါးသို့ ပြန်လားကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","ပေါလုနှင့် ဗာနဗရို့သည် အန္တိအုတ်မြို့၌ အချိန်အင်တန်ကြာ နီထိုင်၍ တခြားသူတိနှင့်အတူ ဆုံးမဩဝါဒပီးခြင်း၊ သခင်ဘုရား၏သတင်းကောင်းတရားကို ဟောပြောခြင်းများကို လုပ်ဆောင်ကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","ကာလအင်တန်ကြာသောအခါ ပေါလုက ဗာနဗအား “ငါရို့သည် သခင်ဘုရား၏ နှုတ်ကပတ်တရားတော်ကို ဟောပြောခသည့် မြို့တိုင်းမှာ ဟိကြသော ငါရို့၏ ညီအစ်ကိုမောင်နှမတိ ဇာပိုင် ဟိနိန်ကြသည်ကို မြင်တွိ့လို၍ တဖန် အလည်လား ကြမည်” ဟု ပြော၏။ ");
INSERT INTO rki_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","ဗာနဗက ယောဟန် မာကု ကို သူရို့နှင့်အတူ လိုက်စီလို၏။ ");
INSERT INTO rki_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","သို့သော်လည်း ပေါလုက သူ့ကို မခေါ်လိုပေ။ အကြောင်းမူကား သူသည် မိမိရို့သာသနာလုပ်ငန်းမှာ မိမိရို့နှင့်အတူ ဆုံးခန်းတိုင်အောင် မလိုက်ဘဲ၊ ပမ်ဖုလိပြည်၌ မိမိရို့ကို ထားပစ်ခပြီး ပြန်လားသောကြောင့်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ထိုအကြောင်းအရာနှင့်ပတ်သက်၍ အချင်းချင်း ပြင်းထန်စွာ အငြင်းပွားကြပြီး သဘောထားကွဲပြားကာ ဗာနဗသည် မာကုကို ခေါ်၍ ကုပရုကျွန်းသို့ ရွက်ရွှင့်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ပေါလုသည် သိလကို ရွီးချယ်၍ ထွက်ခွာလားစဉ် ယုံကြည်သူတိက သခင်ဘုရား၏ကျေးဇူးတော်သည် သူရို့၌ တည်စီခြင်းငှာ ဆုတောင်း အပ်နှံကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","သူသည် အသင်းတော်တိကို ခွန်အားပီးလျက် ယှုရိပြည်နှင့် ကိလိကိပြည် တလျှောက် သိလနှင့်အတူ ထွက်ခွာလားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","ပေါလုသည် ဒေရဗေမြို့သို့ ခရီးထွက်လာခပြီး တိမောသေ ဟုခေါ်သော တပည့်တော်တစ်ယောက် နီထိုင်သည့် လုတ္တရမြို့သို့ ရောက်လာ၏။ ထိုသူ၏အမိသည် ယုဒလူမျိုး ယုံကြည်သူ တစ်ယောက်ဖြစ်ပြီး သူ၏အဖသည်ကား၊ ဟေလသလူမျိုးဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","လုတ္တရမြို့နှင့် ဣကောနိမြို့၌ ဟိသော ယုံကြည်သူ အားလုံး၌ တိမောသေ၏ ဂုဏ်သတင်းသည် ကျော်ဇောလျက်ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","ပေါလုသည် တိမောသေကို မိမိနှင့်အတူ ခေါ်လိုသည်ဖြစ်၍ ထိုအရပ်တွင် နီထိုင်ကြသော ယုဒလူမျိုးတိကြောင့် သူ့အား အရီဖျားလှီးခြင်းကို ပီးလေ၏။ အကြောင်းမူကား သူ၏အဖသည် ဟေလသလူမျိုး တစ်ယောက်ဖြစ်သည်ကို သူရို့အားလုံး သိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","သူရို့သည် တစ်မြို့ဝင် တစ်မြို့ထွက် လှည့်လည်ကာ ယေရုဆလင်မြို့မှ တမန်တော်တိနှင့် အသင်းတော်လူကြီးတိက ဆုံးဖြတ်ချက်ချထားသော စည်းမျဉ်းစည်းကမ်းများကို ယုံကြည်သူတိအား ဖြန့်ဝီပီးကြပြီးလျှင် ဤစည်းမျဉ်းစည်းကမ်းများကို လိုက်လျှောက်ကြရန် သူရို့အား နှိုးဆော်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","ထို့ကြောင့် အသင်းတော်များသည် ယုံကြည်ခြင်း၌ သာ၍ ခိုင်မာလာကြပြီးလျှင် အရီအတွက်အားဖြင့်လည်း နိ့စဉ်နိ့တိုင်း တိုးပွားလာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","အာယှိပြည်၌ နှုတ်ကပတ်တရားတော်ကို ဟောပြောရန် သန့်ယှင်းသောဝိညာဉ်တော်က သူရို့ကို ခွင့်ပြုတော်မမူသောကြောင့် ပေါလုနှင့် သူ၏အပေါင်းအဖော်ရို့သည် ဖြူဂိပြည်နှင့် ဂလာတိပြည်သို့ ခရီးဆက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","သူရို့သည် မုသိနယ်စပ်သို့ ရောက်သောအခါ ဗိသုနိပြည်ထဲသို့ ဝင်ရောက်ဖို့ ကြိုးစားကြသော်လည်း ယေသျှု၏ဝိညာဉ်တော်က သူရို့ကို အခွင့်မပီးခပေ။ ");
INSERT INTO rki_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","ထို့ကြောင့် သူရို့သည် မုသိပြည်ကို လျှောက်၍ တရောမြို့သို့ ဆင်းလာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ပေါလုသည် ညဉ့်အခါ၌ မာကေဒေါနိပြည်သား တစ်ယောက်က “မာကေဒေါနိပြည်သို့ ကူး၍ ငါရို့ကို ကူညီပါ” ဟု ရပ်လျက် သူအား တောင်းပန်နိန်သော ဗျာဒိတ်ရူပါရုံ တစ်ခုကို မြင်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ပေါလုသည် ဤရူပါရုံကို မြင်လျှင်မြင်ချင်း ငါရို့သည် မာကေဒေါနိပြည်သို့ ထွက်ခွာရန် အဆင်သင့်ပျင်ကြ၏။ အကြောင်းမူကား ထိုပြည်၌ဟိသော လူတိအား သတင်းကောင်းတရားကို ဟောကြားခြင်းငှာ ဘုရားသခင် ငါရို့ကို ခေါ်တော်မူသည်ဟု ငါရို့သည် ဆုံးဖြတ်ချက် ချလိုက်ကြသောကြောင့်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","ငါရို့သည် တရောမြို့မှ သင်္ဘောဖြင့် ထွက်ခွာ၍ သာမောသရက်ကျွန်းသို့ တည့်တည့်ဖြတ်၍ ရွက်ရွှင့်လာကြရာ နောက်တစ်နိ့၌ နာပေါလိမြို့သို့ ရောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ငါရို့သည် ထိုမြို့မှ ကုန်းကြောင်းခရီးဖြင့် ထွက်လာကြပြီး ဖိလိပ္ပိမြို့သို့ ရောက်ကြ၏။ မာကေဒေါနိပြည်၏ ပထမဆုံး ခရိုင်မြို့ တစ်မြို့ဖြစ်သော ထိုမြို့သည် ရောမလက်အောက်ခံ မြို့တစ်မြို့ဖြစ်၏။ ငါရို့သည် ထိုမြို့၌ ရက်အင်တန်ကြာ နီခကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ဥပုသ်နိ့၌ ငါရို့သည် ယုဒလူမျိုးများ ဆုတောင်းရန် စုဝေးကြသည့် နီရာတစ်ခု ဟိလိမ့်မည်ဟု စိတ်အထင်ဖြင့် မြို့အပြင်ဖက် မြစ်နားသို့ ထွက်လာကြ၏။ ငါရို့သည် ထိုနီရာ၌ ဝင်ထိုင်ကြပြီးလျှင် စုဝေးနိန်ကြသော မိန်းမတိအား ဟောပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","နီမောင်းသောအထည်များကို ရောင်းချသည့် လုဒိဟုခေါ်သော သွာတိရမြို့သူ တစ်ယောက်သည်လည်း ငါရို့ဟောပြောသော တရားကို ကြားနာကြသောသူရို့ထဲက တစ်ယောက်ဖြစ်၏။ သူမသည် ဘုရားသခင်ကို ဝတ်ပြုကိုးကွယ်သော မိန်းမတစ်ယောက်ဖြစ်သည်နှင့်အညီ သခင်ဘုရားသည် ပေါလုဟောသော တရားကို အာရုံဝင်စားစီခြင်းငှာ ထိုမိန်းမ၏စိတ်နှလုံးကို ဖွင့်ပီးတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ထိုမိန်းမသည် မိမိ၏ အိမ်သူအိမ်သားတိနှင့်အတူ ဗတ္တိဇံကို ခံပြီးနောက် “အကျွန်သည် သခင်ဘုရား၏ စစ်မှန်သော ယုံကြည်သူတစ်ယောက် ဖြစ်သည်ဟု သင်ရို့ သတ်မှတ်လျှင် အကျွန့်အိမ်၌ လာ၍ တည်းကြပါ” ဟု တောင်းပန်၍ သူမသည် ငါရို့အား လိုက်ပါဖို့ရန် ဆွဲဆောင်ပြောဆိုလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","တစ်နိ့သ၌ ငါရို့သည် ဆုတောင်းရာနီရာသို့ လားကြစဉ်တွင် နတ်ဝင်၍ နောင်ဖြစ်လတံ့သောအရာတိကို ဟောပြောခြင်းအားဖြင့် မိမိ၏သခင်အား ဝင်ငွီများစွာ ရှာပီးနိန်သော အစီခံမိန်းမချေတစ်ယောက်သည် ငါရို့ကို တွိ့လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","ထိုအခါ ထိုမိန်းမချေက “ဤသူရို့သည် အမြင့်ဆုံးသော ဘုရားသခင်၏ အမှုတော်ဆောင်များ ဖြစ်ကြပြီး၊ သင်ရို့အား ကယ်တင်ခြင်းလမ်းကို ဟောပြောနိန်သောသူများဖြစ်ကြ၏” ဟု အော်ဟစ်၍ ပေါလုနှင့် ငါရို့နောက်က လိုက်ပါလာ၏။ ");
INSERT INTO rki_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","ထိုမိန်းမ‌ချေသည် ရက်ပေါင်းများစွာ ဤသို့ လုပ်လာသောအခါ ပေါလုသည် ခံပြင်းသောစိတ်ဖြင့် လှည့်ကြည့်ကာ “ယေသျှုခရစ်တော်၏ နာမတော်၌ သင့်ကို ငါ နှင်ထုတ်၏၊ အေမိန်းမချေ ပါးက ထွက်လား” ဟု နတ်ကို အမိန့်ပီးလိုက်သည်နှင့် ထိုနတ်သည် ထိုမိန့်မချေပါးက ချက်ချင်း ထွက်လားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","ထိုမိန်းမချေ၏ သခင်ရို့က မိမိရို့၏ငွီရပေါက် ပိတ်လားကြောင်းကို သိလားကြသောအခါ ထိုသူရို့က ပေါလုနှင့် သိလကို ဖမ်းဆီး၍ ပြည်သူ့ရင်ပြင်၌ဟိသော အာဏာပိုင်တိပါးသို့ ဆွဲခေါ်လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ရောမအရာဟိတိ ရှိ့သို့ ရောက်သောအခါ ထိုသူရို့က “ဤလူတိသည် ယုဒလူမျိုးတိဖြစ်ကြပြီး အကျွန်ရို့မြို့မှာ ရုန်းရင်းဆန်ခတ်ဖြစ်အောင် လုပ်နိန်ကြပါ၏၊ ");
INSERT INTO rki_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","သူရို့သည် အကျွန်ရို့ ဥပဒေနှင့် ဆန့်ကျင်သော ဓလေ့ထုံးစံတိကို သွန်သင်နိန်ကြပါ၏၊ အကျွန်ရို့သည် ရောမနိုင်ငံသားများဖြစ်၍ ဤဓလေ့ထုံးစံတိကို အကျွန်ရို့ လက်မခံနိုင်ပါ၊ ကျင့်လည်း မကျင့်နိုင်ကြပါ” ဟု လျှောက်ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","ထိုအခါ လူအပေါင်းရို့သည် ပေါလုနှင့် သိလ ကို တိုက်ခိုက်ခြင်းငှာ စုဝေးလာကြ၏။ ထို့နောက် အရာဟိတိက ပေါလုနှင့် သိလ၏ အဝတ်ကို ဆွဲချွတ်၍ ကြာပွတ်နှင့် သတ်ခိုင်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","ပြင်းထန်စွာ သတ်ကြပြီးနောက် ပေါလုနှင့် သိလကို ထောင်ထဲသို့ သွင်းထားကာ တင်းကြပ်စွာ လှောင်ထားဖို့ရန် ထောင်မှူးကို အမိန့်ပီးထားလိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ဤအမိန့်အတိုင်း ထောင်မှူးသည် သူရို့ကို ထောင်အတွင်းခန်းထဲသို့ ဆွဲသွင်းပြီးလျှင် လေးလံသောသစ်သား ထိတ်တုံးဖြင့် သူရို့ခြီထောက်ကို ခတ်ထားလိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","ညဉ့်သန်းခေါင်အချိန် ခန့်တွင် ပေါလုနှင့် သိလသည် ဘုရားသခင်ကို ဆုတောင်းပတ္ထနာပြု၍ ချီးမွမ်းတေးခြင်းများကို ဆိုနိန်ကြ၏။ တခြားထောင်သားများကလည်း သူရို့တေးခြင်းကို နားထောင်နိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ထိုအခါ ပြင်းထန်သော မြီငလျှင်တစ်ခုသည် ရုတ်တရက် လှုပ်သောကြောင့် ထောင်၏အုတ်မြစ် တုန်လှုပ်ကာ ထောင်တန်းခါးအားလုံးသည် ချက်ချင်း ပွင့်လာကြပြီးလျှင် ထောင်သားအားလုံးသည် ချိုင်ထားသော သံကြိုးမှ လွတ်မြောက်ကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","ထောင်မှူးသည် နိုးလာ၍ ထောင်တန်းခါးတိ ပွင့်နိန်သည်ကို မြင်လျှင် ထောင်သားတိ လွတ်မြောက်လားကြပြီဟု ထင်မှတ်ကာ မိမိ၏ဓါးကို ဆွဲထုတ်ပြီး မိမိကိုယ်ကို အဆုံးစီရင်ရန် ပြုလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","သို့ရာတွင် ပေါလုက “ကိုယ့်ကိုယ်ကို အန္တရာယ် မပြုကေ့။ ငါရို့ အားလုံး ဤနီရာ၌ပင် ဟိကြ၏” ဟု ကျယ်သောအသံနှင့် အော်ပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","ထောင်မှူးသည် မီးခွက်တစ်ခုကို တောင်း၍ ထောင်ထဲသို့ ဗြီးဝင်ပြီးလျှင် ပေါလုနှင့် သိလရို့၏ခြီရင်း၌ တုန်လှုပ်လျက် ပြပ်ဝပ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ထို့နောက် ထောင်မှူးသည် သူရို့ကို အပြင်သို့ ခေါ်ထုတ်လာပြီးလျှင် “ဆရာရို့၊ အကျွန်သည် ကယ်တင်ခြင်းရရန် ဇာလုပ်ရပါဖို့လဲ” ဟု မိန်းလျှောက်၏။ ");
INSERT INTO rki_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","ထိုအခါ သူရို့က “အသျှင်ယေသျှုကို ယုံကြည်လော့။ ထိုသို့ ယုံကြည်လျှင် သင်နှင့် သင်၏အိမ်သူ အိမ်သားတိသည် ကယ်တင်ခြင်းသို့ ရောက်ကြလိမ့်မည်” ဟု ပြော၏။ ");
INSERT INTO rki_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ထို့နောက် ပေါလုနှင့် သိလသည် ထောင်မှူးနှင့် သူ၏အိမ်သူအိမ်သားအားလုံးကို သခင်ဘုရား၏ နှုတ်ကပတ်တရားတော်ကို ဟောပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","ထိုညဉ့်အချိန်၌ပင် ထောင်မှူးသည် ပေါလုနှင့်သိလကို ထုတ်ယူ၍ သူရို့၏ဒဏ်ရာများကို ဆီးကြောပီးလေ၏။ ထို့နောက် သူနှင့် သူ၏မိသားစုအားလုံးသည် ချက်ချင်း ဗတ္တိဇံကို ခံယူကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","ထို့နောက် ထောင်မှူးသည် ပေါလုနှင့် သိလကို မိမိအိမ် အထက်ခန်းသို့ ဖိတ်ခေါ်၍ အစားအစာကို ကျွေးမွေးလေ၏၊ အဂုတွင် သူနှင့် သူ့မိသားစုအားလုံးသည် ဘုရားသခင်ကို ယုံကြည်ကြသောကြောင့် ဝမ်းမြောက်မှုနှင့် ပြည့်စုံကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","မိုးလင်းသောအခါ ရောမအာဏာပိုင်များသည် ရုံးလုလင်တိကို စီရွှတ်ကာ “ထိုသူရို့ကို ရွှတ်ပီးလိုက်” ဟု မိန့်မှာလိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","ထို့ကြောင့် ထောင်မှူးက ပေါလုအား “အရာဟိတိက သင်နှင့် သိလအား ရွှတ်ရန် အမိန့်ပီးလိုက်၏၊ ထို့ကြောင့် သင်ရို့သည် ငြိမ်းချမ်းစွာဖြင့် ထွက်ခွာ၍ လားကတ်လီဖိ” ဟု ပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","သို့ရာတွင် ပေါလုက “ငါရို့မှာ ဒုစရိုက်အပြစ် တစ်ခုမျှ မတွိ့သော်လည်း သူရို့သည် ရောမနိုင်ငံသားဖြစ်သော ငါရို့ကို လူသိသျှင်ကြား တုတ်ဖြင့် သတ်ကာ ထောင်ထဲမှာ လှောင်ထားကြ၏။ အဂုခါ သူရို့သည် ငါရို့ကို လျှို့ဝှက်စွာဖြင့် နှင်ထုတ်လိုကြ၏၊ ယင်းပိုင်လုပ်လို့မရ။ ရောမအရာဟိတိ ကိုယ်တိုင် ဤနီရာသို့ လာပြီးလျှင် ငါရို့ကို လွှတ်ပီးရမည်” ဟု ရုံးလုလင်တိအား ပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","ဤစကားကို ရုံးလုလင်တိက ရောမအရာဟိတိပါးသို့ သတင်းပို့လိုက်သောအခါ ပေါလုနှင့် သိလရို့သည် ရောမနိုင်ငံသားတိဖြစ်ကြောင်းကို သူရို့သည် ကြားသိကြလျှင် သူရို့သည် ကြောက်လန့်ကြရလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ထို့ကြောင့် သူရို့သည် ပေါလုနှင့် သိလပါးသို့ ရောက်လာကြပြီးလျှင် သူရို့ကို တောင်းပန်ပြီးနောက် ထောင်ထဲက ထုတ်ကာ ဤမြို့မှ ထွက်လားကြရန် မေတ္တာရပ်ခံကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ထိုအခါ ပေါလုနှင့် သိလသည် ထောင်မှ ထွက်၍ လုဒိအိမ်သို့ လားကြ၏။ ထိုနီရာ၌ ဟိသော ယုံကြည်သူတိနှင့် တွိ့ဆုံပြီး၊ သူရို့ကို အားပီးစကားများ ပြောဆိုပြီးမှ ထိုအရပ်မှ ထွက်လားကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","ပေါလုနှင့် သိလသည် အံဖိပေါလိမြို့နှင့် အာပေါလောနိမြို့ကို လှည့်လည်လာကြပြီးလျှင် သက်သာလောနိတ်မြို့သို့ ရောက်လာကြ၏။ ထိုမြို့၌ ယုဒတရားဇရပ် တစ်ခု ဟိလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","3","ပေါလုသည် မိမိပြုလေ့ဟိသည့်အတိုင်း တရားဇရပ်သို့ လား၍ ခရစ်တော်သည် ဒုက္ခဝေဒနာကို ခံယူပြီးမှ အသီခံခြင်းက ထမြောက်တော်မူမည့်အကြောင်းကို ကျမ်းစာကို အမှီပြု၍ ယှင်းပြပြီး ဥပုသ် သုံးပတ်တိုင်တိုင် လူတိနှင့် ဆွေးနွေးလေ၏။ ပေါလုက “ငါသည် သင်ရို့အား ဟောပြောနိန်သော ယေသျှုသည်ကား ကယ်တင်သျှင်ဖြစ်၏” ဟူ၍ ဆိုလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ထိုသူများအထဲမှ တချို့သည် ယုံကြည်လာကြသည်ဖြစ်၍ ပေါလုနှင့် သိလပါးသို့ လာရောက် ပေါင်းဖော်ကြ၏။ ဘုရားသခင်ကို ကိုးကွယ်ကြသော ဟေလသလူမျိုးအပေါင်းရို့နှင့် အမျိုးသမီးခေါင်းဆောင်ရို့လည်း ပါဝင်လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","သို့ရာတွင် ယုဒလူမျိုးတချို့သည် မနာလို ဖြစ်ကြသဖြင့်၊ လမ်းကြိုလမ်းကြားမှ အသုံးမကျသော ဆိုးသောသူအချို့ကို စုစည်းကာ ရုန်းရင်းဆန်ခတ်ပြုကြရန် ဖန်တီးကြသည်ဖြစ်၍ တစ်မြို့လုံးသည် ရုတ်ရုတ်သဲသဲဖြစ်လျက်ဟိ၏။ သူရို့သည် ယာသုန်၏အိမ်ကို ဝင်၍ ပေါလုနှင့် သိလကို လူတိရှိ့သို့ ဆွဲထုတ်ရန် ရှာဖွီကာ တိုက်ခိုက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","သို့ရာတွင် သူရို့သည် ပေါလုနှင့် သိလကို ရှာမတွိ့ကြသောအခါ ယာသုန်နှင့် ယုံကြည်သူတချို့ကို မြို့အုပ်ချုပ်သူ အာဏာပိုင်တိရှိ့သို့ ဆွဲထုတ်ကာ “ဤလူတိသည် နီရာတိုင်းမှာ ပြဿနာ ဖြစ်စီခြင်းငှာ လုပ်ဆောင်ကြ၏။ အဂုတွင် ဤသူရို့သည် အကျွန်ရို့မြို့သို့ ရောက်လာကြပြီး ");
INSERT INTO rki_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ယာသုန်သည် သူရို့ကို မိမိ၏အိမ်၌ လက်ခံထား၏။ သူရို့သည် ဧကရာဇ်မင်း၏ ဥပဒေများကို ချိုးဖောက်၍ ယေသျှုဟု နာမည်ဟိသည့် တခြားသော သျှင်ဘုရင်တစ်ပါး ဟိသိမ့်ကြောင်း ပြောဆိုနိန်ကြပါ၏” ဟု အော်ဟစ် ပြောဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","သူရို့သည် ဤသို့သော စကားများဖြင့် မြို့အုပ်ချုပ်သူ အာဏာပိုင်တိနှင့် လူအများကို အုတ်အုတ်သဲသဲဖြစ်စီရန် သိမ်းသွင်းကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","အာဏာပိုင်များက ယာသုန်နှင့် တခြားလူတိအား အာမခံငွီများကို ပီးဆောင်စီပြီးလျှင် ပြန်လွှတ်လိုက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","ညဉ့်အချိန် ရောက်လျှင်ရောက်ချင်း၊ ယုံကြည်သူတိက ပေါလုနှင့် သိလကို ဗေရိမြို့သို့ ပို့ဆောင်လိုက်ကြ၏။ ထိုမြို့သို့ ရောက်လျှင် သူရို့သည် ယုဒ တရားဇရပ်သို့ ဝင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","ဗေရိ မြို့သူမြို့သားရို့သည် သက်သာလောနိတ် မြို့သူမြို့သားတိထက်မက သာ၍ ကြည်ညိုစိတ်ဟိကြသည်ဖြစ်၍ သူရို့သည် နှုတ်ကပတ်တရားတော်ကို စိတ်အားထက်သန်စွာ ခံယူကြပြီးလျှင် ပေါလုပြောသည်မှာ မှန်၏၊ မမှန်၏ကို သိခြင်းငှာ ကျမ်းစာကို နိ့စဉ်နိ့တိုင်း လေ့လာဆန်းစစ်ကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ထို့ကြောင့်၊ သူရို့အထဲမှ များစွာသောလူရို့သည် ယုံကြည်လာကြ၏။ များစွာသော အထက်တန်းလွှာ ဟေလသမိန်းမနှင့် ယောက်ျားရို့သည်လည်း ယုံကြည်လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","သို့ရာတွင် ပေါလုသည် ဗေရိမြို့၌လည်း ဘုရားသခင်၏ နှုတ်ကပတ်တရားတော်ကို ဟောပြောနိန်သည်ကို သက်သာလောနိတ်မြို့သား ယုဒလူမျိုးများက ကြားသိကြလျှင် သူရို့သည် ဗေရိမြို့သို့ ရောက်လာ၍ လူအပေါင်းရို့အား သွီးထိုး၍ ဆူပူမှုဖြစ်စီရန် လှုံ့ဆော်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ထို့ကြောင့် ယုံကြည်သူများက ပေါလုကို ပင်လယ်ကမ်းခြီသို့ ချက်ချင်း ပို့ဆောင်လိုက်ကြ၏။ သို့ရာတွင် သိလနှင့် တိမောသေ နှစ်ယောက်တည်း ဗေရိမြို့၌ ကျန်လိုက်ခ၏။ ");
INSERT INTO rki_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ပေါလုကို လိုက်ပို့သောသူရို့သည် အေသင်မြို့တိုင်အောင် လိုက်ပို့ကြပြီးနောက် သိလနှင့် တိမောသေအား မိမိပါးသို့ တတ်နိုင်သလောက် အလျင်အမြန် လိုက်လာကြရန် ပေါလု၏အမှာစာကို ယူဆောင်၍ သူရို့သည် ဗေရိမြို့သို့ ပြန်လာကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","ပေါလုသည် အေသင်မြို့၌ သိလနှင့် တိမောသေကို စောင့်နိန်စဉ်၊ ထိုမြို့ တစ်မြို့လုံး၌ ရုပ်တုများနှင့် ပြည့်လျက်ဟိသည်ကို မြင်လျှင် သူသည် အလွန် စိတ်ပျက်ရလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","ထို့ကြောင့် သူသည် တရားဇရပ်၌ ယုဒလူမျိုးရို့အပြင် ဘုရားသခင်ကို ဝတ်ပြုကိုးကွယ်ကြသော တခြားလူမျိုးရို့နှင့် လည်းကောင်း၊ လူအများ စုဝေးရာအရပ်၌ နိ့တိုင်း တွိ့သမျှသော သူတိနှင့် လည်းကောင်း ဆွေးနွေးပြောဆိုခြင်းများ လုပ်ဆောင်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","ဧပိကုရု၏တပည့်တိနှင့် သတောအိတ်ဟု ခေါ်သော အတွေးအခေါ်ပညာသျှင်ရို့သည်လည်း ပေါလုနှင့် ဆွေးနွေးငြင်းခုံခြင်းငှာ စတင်ကြလေ၏။ အချို့က “ဤစကားအိုးသည် ဇာအကြောင်းကို ပြောပြဖို့ ကြိုးစားနိန်စွာလဲ” ဟု ဆို၏။ အချို့ကလည်း “ဤသူသည် နိုင်ငံခြားနတ်ဘုရားတိ အကြောင်းကို ပြောဆိုနိန်ပုံရ၏” ဟု ဆိုကြ၏။ သူရို့က ဤသို့ ပြောဆိုရသည့်အကြောင်းမှာ၊ ပေါလုသည် ယေသျှုနှင့် ရှင်ပြန်ထမြောက်ခြင်းအကြောင်း သတင်းကောင်းကို ဟောပြောနိန်ခြင်းကြောင့် ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","ထို့ကြောင့် ထိုသူရို့သည် အာရေတောင်၌ဟိသော မြို့တော်ကောင်စီရှိ့သို့ ပေါလုကို ခေါ်လာကြပြီးလျှင် “သင် ဟောပြောနိန်သော ဤအယူဝါဒသစ်ကို ငါရို့ သိချင်ပါ၏။ ");
INSERT INTO rki_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","သင် ပြောနိန်သောအရာတိကို ငါရို့ ကြားရသည်မှာ တချို့သည် ငါရို့အတွက် အထူးအဆန်း ဖြစ်နိန်ပါ၏။ ထိုအရာတိကား ဇာကို ဆိုလိုသည်ကို ငါရို့ သိချင်ပါ၏” ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","အေသင်မြို့သူမြို့သားအပေါင်းနှင့် ထိုမြို့၌ နီထိုင်ကြသော တပါးအမျိုးသားများသည် အသစ်သော သတင်းစကားများကို နားထောင်ယင်း၊ ပြောကြားယင်းဖြင့် မိမိရို့၏ အချိန်ကာလအားလုံးကို အသုံးချရန် လိုလားကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","ထိုအခါ ပေါလုသည် အာရေတောင် မြို့တော်ကောင်စီရှိ့၌ မတ်တပ်ရပ်လျက် “အေသင်မြို့သူမြို့သားအပေါင်းရို့၊ သင်ရို့သည် နည်းအမျိုးမျိုးနှင့် ဘာသာတရားတိကို အလွန်ကြည်ညိုကြသည်ကို ငါ သိမြင်ရပါ၏။ ");
INSERT INTO rki_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","အကြောင်းမူကား ငါသည် သင်ရို့မြို့ကို လှည့်လည်ပြီး သင်ရို့ ကိုးကွယ်ဝတ်ပြုကြသည့်အရာတိကို ကြည့်သောအခါ၌ ‘ငါရို့မသိသောဘုရားသခင်အတွက်’ ဟူ၍ ကမ္ပည်းထိုးထားသော ယဇ်ပလ္လင်တစ်ခုကို တွိ့ပါ၏။ သင်ရို့သည် မသိဘဲလျက် ကိုးကွယ်နိန်ကြသော ဘုရားအကြောင်းကို အဂု ငါ ဟောပြောပါမည်။ ");
INSERT INTO rki_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","လောကနှင့်တကွ လောက၌ ဟိသမျှတိကို ဖန်ဆင်းတော်မူသော ဘုရားသခင်သည် ကောင်းကင်နှင့် မြီကြီး၏ အသျှင်သခင်လည်း ဖြစ်တော်မူ၏။ ထိုဘုရားသခင်သည် လူလက်ဖြင့် တည်ဆောက်သော ဗိမာန်တော်များ၌ ကိန်းဝပ်တော်မူသည် မဟုတ်။ ");
INSERT INTO rki_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ထို့နောက် ထိုဘုရားသခင်သည် လူတိအား အသက်နှင့်တကွ ထွက်သက်ဝင်သက်နှင့် အရာခပ်သိမ်းတိကို ပီးတော်မူသော အသျှင်ဖြစ်သောကြောင့် ကိုယ်တော်သည် လူသားတိက ဆောင်ရွက်ပီးသော မည်သည့် အထောက်အပံ့ကိုမျှ မလိုအပ်ပေ။ ");
INSERT INTO rki_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ထိုဘုရားသခင်သည် လူတစ်ဦး တစ်ယောက်မှစ၍ မြီကြီးထက်မှာ ဟိသမျှသော လူမျိုးအားလုံးကို ဖန်ဆင်းတော်မူ၍ သူရို့ကို မြီကြီးတစ်ပြင်လုံး၌ အသက်ရှင်ခွင့် ပီးတော်မူ၏။ ဘုရားသခင်သည် သူရို့၏ အချိန်ကာလနှင့် နီရာဒေသ အပိုင်းအခြားကို သူကိုယ်တိုင် ကြိုတင်၍ သတ်မှတ်ပီးထားတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","အကြောင်းမူကား ဘုရားသခင်သည် လူတိက ကိုယ်တော့်ကို ရှာဖွီ၍ အထံတော်သို့ ရောက်ဟိပြီးလျှင် ကိုယ်တော့်ကို တွိ့ကောင်းတွိ့နိုင်စီခြင်းငှာ ဤသို့ ပြုတော်မူခြင်း ဖြစ်၏။ အမှန်အားဖြင့် ဘုရားသခင်သည် ငါရို့ထဲက မည်သူတစ်ဦးတစ်ယောက်နှင့်မျှ ဝီးတော်မမူပေ။ ");
INSERT INTO rki_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ထို့ကြောင့် ဆိုရိုးစကား ဟိသည်မှာ၊ “ ‘ငါရို့သည် ဘုရားသခင်၌ အသက်ရှင်လျက်၊ လှုပ်ရှားလျက်၊ ဖြစ်တည်လျက် ဟိကြ၏။’ သင်ရို့၏ လင်္ကာဆရာများထဲက တစ်စုံတစ်ယောက် ဖွဲ့ဆိုထားသည်မှာ၊ ‘ငါရို့သည်ကား ဘုရားသားသမီးတိ ဖြစ်ကြ၏၊’ ဟူ၍ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","ငါရို့သည် ဘုရားသခင်၏ သားသမီးများ ဖြစ်သောကြောင့် ဘုရားသခင်၏ ဇာတိတော်သည် လူ၏ အသိပညာ၊ အတတ်ပညာအားဖြင့် ထုလုပ်ထားသော ရွှီရုပ်တု သို့မဟုတ် ငွီရုပ်တု သို့မဟုတ် ကျောက်ရုပ်တု စသည့် မည်သည့် ရုပ်တုနှင့်မျှ တူတော်မူသည်ဟု မယူဆအပ်ပေ။ ");
INSERT INTO rki_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","လူတိသည် အတိတ်ကာလက ဘုရားကို မသိခသည်ကို ဘုရားသခင်သည် အပြစ်မယူခပေ၊ သို့သော်လည်း အဂုတွင် မြီကြီးတစ်ပြင်လုံး၌ ဟိကြကုန်သော လူသားအားလုံးကို မိမိရို့၏အပြစ်မှ နောင်တရကြရန် ဘုရားသခင် မိန့်တော်မူလျက်ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","ဘုရားသခင်သည် သူရွီးချယ်ထားသော သူတစ်ယောက်အားဖြင့် လောကလူသားအာလုံးကို ဖြောင့်မတ်ခြင်း တရားတော်နှင့်အညီ တရားစီရင်မည့် နိ့ရက်ကို သတ်မှတ်ထားပြီးဖြစ်၏။ ထိုသူကို အသီခံခြင်းမှ ရှင်ပြန်ထမြောက် စီတော်မူသောအားဖြင့် လူတိုင်းအား ဤသက်သီကို ပြတော်မူပြီးပြီ” ဟု ပေါလုက ဟောပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","သူရို့သည် ပေါလုပြောသည့် အသီခံခြင်းမှ ရှင်ပြန်ထမြောက်ခြင်းအကြောင်းကို ကြားလျှင် အချို့က ပေါလုကို လှောင်ပြောင်သရော်ကြ၏။ အချို့က “သင်ပြောသည့် အကြောင်းအရာတိကို နောက်တစ်ခါ အကျွန်ရို့ နားထောင်ချင်သိမ့်၏” ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","ထိုသို့ ပြောဆိုကြသောကြောင့် ပေါလုသည် ထိုအစည်းအဝေးပွဲမှ ထွက်လားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","လူအချို့သည် ပေါလုနှင့် မိတ်ဖွဲ့၍ ယုံကြည်ခြင်းသို့ ရောက်ကြ၏။ ထိုသူတိမှာ ဒယောနုသိ ဟုခေါ်ကြသော အာရေတောင်ကောင်စီဝင် တစ်ယောက်နှင့် ဒမောရိ ဟုခေါ်ကြသော မိန်းမတစ်ယောက်အပြင် အခြားသူတိလည်း ပါကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","ထို့နောက် ပေါလုသည် အေသင်မြို့မှ ထွက်ခွာ၍ ကောရိန္သုမြို့သို့ ရောက်၏။ ");
INSERT INTO rki_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","ထိုအခါ ကလောဒိမင်းက ယုဒလူမျိုးတိအားလုံး ရောမမြို့မှ ထွက်လားရမည်ဟု အမိန့်တော်ထုတ်လိုက်သောကြောင့် မိမိမယား ပြစ်ကိလနှင့်အတူ ဣတလိပြည်မှ မကြာခင်က ထွက်ခွာလာခသော ပုန္တုပြည်သား အာကုလ ဟုခေါ်သည့် ယုဒလူမျိုးတစ်ယောက်နှင့် သူသည် တွိ့ဆုံလေ၏။ ပေါလုသည် သူရို့နှင့်တွိ့ဆုံရန် သူရို့ပါးသို့ လားလေ၏၊ ");
INSERT INTO rki_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","အကြောင်းမူကား သူသည် တဲရှင်လုပ်ငန်း လုပ်ကိုင်ခြင်းဖြင့် မိမိ၏အသက်မွီးဝမ်းကျောင်းအတွက် ဝင်ငွီရှာသူဖြစ်၍ အလုပ်ချင်း တူသောကြောင့် သူရို့နှင့်အတူ နီထိုင်ကာ အလုပ်လုပ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","ပေါလုသည် ယုဒနှင့် ဟေလသလူမျိုးတိကို ယုံကြည်လာကြစီရန် ဆွဲဆောင်သည့်အနေဖြင့် ဥပုသ်နိ့တိုင်း တရားဇရပ်၌ တရားဆွေးနွေးခြင်းများကို ကျင်းပလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","သိလနှင့် တိမောသေသည် မာကေဒေါနိပြည်မှ ရောက်လာကြသောအခါ ပေါလုသည် ယုဒလူမျိုးတိအား ယေသျှုသည် မေသျှိယ ဖြစ်ကြောင်းကို သက်သီခံလျက် မိမိအချိန်အားလုံး၌ တရားဟောခြင်းအမှုကိုသာ ဆောင်ရွက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","ယုဒလူမျိုးများက ပေါလုကို ကဲ့ရဲ့ပြောဆို၍ ဆန့်ကျင်ကြသောအခါ သူသည် မိမိ၏အဝတ်များမှ ဖုန်ကို ခါချလိုက်ပြီးလျှင် “သင်ရို့သည် ပျက်စီးခြင်းသို့ရောက်လျှင် သင်ရို့အပြစ်အတွက် သင်ရို့ကိုယ်တိုင် ခံယူကြရမည်၊ ငါ့မှာ တာဝန်မဟိယာ၊ အဂုမှစ၍ ငါသည် တခြားလူမျိုးတိ ပါးသို့ လားရဦးမည်” ဟု ဆိုလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","ထို့နောက် သူရို့ကို ထားခပြီးလျှင် ထာဝရဘုရားသခင်ကို ကိုးကွယ်သည့် တိတု ယုတ္တု ဟူ၍ အမည်ဟိသော တစ်ပါးအမျိုးသားတစ်ယောက်၏အိမ်၌ နီထိုင်ရန်လားလေ၏။ သူ၏အိမ်သည် တရားဇရပ်နှင့် ကပ်လျက်ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","တရားဇရပ်မှူး ကရိပ္ပုသည် မိမိ၏အိမ်သူအိမ်သားအားလုံးနှင့် အတူတကွ သခင်ဘုရား၌ ယုံကြည်ကြလေ၏။ ထို့အပြင် တခြားသော ကောရိန္သုမြို့သူ မြို့သားများ များစွာရို့သည်လည်း သတင်းကောင်းတရားကို ကြားနာရကြသည်ဖြစ်၍ ယုံကြည်ခြင်းသို့ ရောက်ကြပြီးလျှင် ဗတ္တိဇံကို ခံကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","တစ်ညတွင် ပေါလုသည် ဗျာဒိတ်ရူပါရုံတစ်ခုကို မြင်လေ၏၊ ထိုရူပါရုံ၌ သူ့အား အသျှင်ဘုရားက ပြောသည်မှာ “မကြောက်ကေ့၊ ဆက်လက်၍ ဟောပြောလော့၊ လက်မြှောက်အရှုံးမပီးကေ့၊ ");
INSERT INTO rki_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","အကြောင်းမူကား ငါသည် သင်နှင့် အတူဟိ၏၊ မည်သူတစ်ဦး တစ်ယောက်မျှ သင့်ကို ညှဉ်းဆဲခြင်းငှာ မတတ်နိုင်၊ ဤမြို့၌ ငါ၏လူတိ များစွာ ဟိကြ၏” ဟူ၍ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","ထို့ကြောင့် ပေါလုသည် ထိုမြို့၌ ဘုရားသခင်၏ နှုတ်ကပတ်တရားတော်ကို လူတိအား ဟောပြောသွန်သင်ကာ တစ်နှစ်ခွဲကြာ နီခလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ဂါလျုန်ကို အခါယပြည်၏ ရောမဘုရင်ခံ မြှောက်လိုက်သောအခါ ယုဒလူမျိုးများသည် ကောရိန္သုမြို့သို့ စုရုံး၍ ရောက်လာကြပြီး ပေါလုကို ဖမ်းဆီး၍ တရားပလ္လင်ရှိ့သို့ ခေါ်ဆောင်လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","သူရို့က “ဤသူသည် ပညတ်တရားကို ဆန့်ကျင်၍ ဘုရားသခင်ကို ဝတ်ပြုခြင်းငှာ လူတိကို ဆွဲဆောင် သိမ်းသွင်းနိန်၏” ဟု လျှောက်တင်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","ပေါလု ပြောဖို့ လုပ်သောအခါ ဂါလျုန်က ယုဒလူမျိုးတိအား “ကျူးလွန်ခသော ရာဇဝတ်ပြစ်မှုတချို့ သို့တည်းမဟုတ် မှားယွင်းမှုတချို့ ဟိခလျှင် သင်ရို့ ယုဒလူမျိုးတိကို ငါ့အတွက် သည်းခံနိုင်စရာ အကြောင်းဟိလိမ့်မည်၊ ");
INSERT INTO rki_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","သို့ရာတွင် သင်ရို့၏ယုဒဘာသာရေးနှင့်ဆိုင်သော စကားလုံးတိ၊ အမည်နာမတိ၊ ပညတ်တရားတိနှင့် ပတ်သက်၍ အငြင်းပွားမှု ဖြစ်သောကြောင့် သင်ရို့၏ကိစ္စကို သင်ရို့ရာ ဖြေယှင်းကြ၊ ငါသည် ဤကိစ္စကို တရားစီရင်လိမ့်မည် မဟုတ်” ဟု ဆိုလျက်၊ ");
INSERT INTO rki_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ယုဒလူမျိုးတိကို တရားပလ္လင်မှ မောင်းထုတ်လိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","ထိုအခါ သူရို့အားလုံးသည် တရားဇရပ်မှူး သုဿင်ကို ဖမ်းဆီး၍ တရားရုံးရှိ့၌ သတ်ပုတ်ကြ၏။ ထိုသို့ ပြုကြသော်လည်း မြို့ဝန်မင်း ဂါလျုန်သည်ကား မျက်ကွယ်ပြုထားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","ပေါလုသည် ကောရိန္သုမြို့၌ ယုံကြည်သူများနှင့် ရက်အတန်ကြာ နီထိုင်ပြီး ပြစ်ကိလနှင့် အာကုလနှင့်အတူ ယှုရိပြည်သို့ ရွက်ရွှင့်ကြလေ၏။ ကင်ခြေမြို့မှ ရွက်ရွှင့်မထွက်ခွာခင် သစ္စာကတိ ပြုထားခသည် နှင့်အညီ ပေါလုသည် မိမိဂေါင်းကို ရိတ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","သူရို့သည် ဧဖက်မြို့သို့ ရောက်သောအခါ ပေါလုသည် ပြစ်ကုလနှင့် အာကုလကို ထိုမြို့၌ ထားခပြီးလျှင် တရားဇရပ်သို့ ဝင်ရောက်၍ ယုဒလူမျိုးများနှင့် ဆွေးနွေးခြင်းကို ပြုလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ထိုသူရို့က ပေါလုအား ကာလအတန်ကြာ နီစီခြင်းငှာ တောင်းပန်သော်လည်း သူက မလိုက်လျော့ခပေ။ ");
INSERT INTO rki_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","သူထွက်ခွာချိန်၌ “ဘုရားသခင်အလိုတော်ဟိလျှင် သင်ရို့ပါးသို့ ငါ ပြန်လာဦးမည်” ဟူ၍ သူသည် ကတိပြုပြီးလျှင် ဧဖက်မြို့မှ ရွက်ရွင့်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","သူသည် ကဲသရိမြို့သို့ ဆိုက်ကပ်ပြီးလျှင် ယေရုဆလင်မြို့သို့ တက်၍ အသင်းတော်ကို နှုတ်ဆက်ပြီးမှ အန္တိအုတ်မြို့သို့ ဆင်းလားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","သူသည် ထိုမြို့၌ အင်တန်ကြာ နီထိုင်ပြီးနောက် ထွက်ခွာလာပြီးလျှင် ယုံကြည်သူအပေါင်းရို့အား ခွန်အားပီးယင်း ဂလာတိနယ်နှင့် ဖြူဂိနယ် တလျှောက်လုံး၌ လှည့်လည်ခလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","ထိုအချိန်၌ အာပေါလုဟု အမည်တွင်သော အာလေဇန္ဒြိမြို့၌ မွီးဖွားသည့် ယုဒလူမျိုး တစ်ယောက်သည် ဧဖက်မြို့သို့ ရောက်လာ၏။ ထိုသူသည် စကားပြောကောင်းသူ တစ်ယောက်ဖြစ်သည့်အပြင် ကျမ်းစာ ဗဟုသုတ ကြွယ်ဝသောသူတစ်ယောက်လည်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","သူသည် သခင်ဘုရား၏လမ်းစဉ်ကို နာခံထားပြီးလျှင် စိတ်အားထက်သန်စွာ ဟောပြောလျက် ယေသျှုအကြောင်း ဖြစ်ရပ်မှန်များကို မှန်ကန်စွာ သွန်သင်ပီး၏။ သို့သော်လည်း သူသည် ယောဟန်၏ ဗတ္တိဇံတရားကိုသာ သိ၏။ ");
INSERT INTO rki_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ထိုသူသည် တရားဇရပ်၌ ရဲရင့်စွာဖြင့် ဟောပြောခြင်းငှာ စတင်လေ၏။ ပြစ်ကိလနှင့် အာကုလရို့သည် သူဟောပြောသည်ကို ကြားသောအခါ ထိုသူ့ကို မိမိရို့အိမ်သို့ ခေါ်ယူ၍ ဘုရားသခင်၏တရားလမ်းကို သာ၍ မှန်ကန်စွာ သိစီခြင်းငှာ သူ့အား ယှင်းပြကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","ထို့နောက် အာပေါလုက အခါယနယ်သို့ လားရန် ဆုံးဖြတ်လိုက်သောကြောင့် ဧဖက်မြို့မှ ယုံကြည်သူများက အခါယနယ်မှာ ဟိကြသော ယုံကြည်သူများပါးသို့ သူ့အား ကြိုဆိုလက်ခံကြစီခြင်းငှာ တိုက်တွန်းစာရီး၍ ထိုသူကို ကူညီလိုက်ကြ၏။ အာပေါလု ရောက်လားသောအခါ သူသည် ဘုရားသခင်၏ကျေးဇူးတော်အားဖြင့် ယုံကြည်သူ ဖြစ်လာကြသောသူများအတွက် ကြီးမားသော အကူအညီတစ်ခု ဖြစ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","အကြောင်းမူကား သူက ယေသျှုသည် မေသျှိယ ဖြစ်တော်မူကြောင်းကို ကျမ်းစာကို သက်သီပြုကာ မိမိ၏ခိုင်မာသော ချေပပြောဆိုမှုများဖြင့် ယုဒလူမျိုးများ၏ဝေဖန်ဆွေးနွေးမှုများကို လူအများရှိ့မှာ အနိုင်ရလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","အာပေါလုသည် ကောရိန္သုမြို့တွင် ဟိနိန်စဉ် ပေါလုသည် ကုန်းမြင့်ပိုင်းဒေသ တလျှောက်သို့ လှည့်လည်ပြီးနောက် ဧဖက်မြို့သို့ ရောက်ဟိလာ၏။ သူသည် ထိုမြို့၌ တပည့်တော် တချို့ကိုလည်း တွိ့၏။ ");
INSERT INTO rki_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ထိုအခါ ပေါလုက “သင်ရို့သည် ယုံကြည်သူများ ဖြစ်လာကြပြီးနောက် သန့်ယှင်းသောဝိညာဉ်တော်ကို ခံယူယာလား” ဟု မိန်းလျှင်၊ သူရို့က “အကျွန်ရို့သည် သန့်ယှင်းသောဝိညာဉ်တော် ဟုဆိုသည်ကို တစ်ခါမျှ မကြားဖူးပါ” ဟု ပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","ပေါလုကလည်း “သို့ဖြစ်လျှင်၊ သင်ရို့ ခံသော ဗတ္တိဇံကား ဇာပိုင် မျိုးနည်း” ဟု မိန်းလျှင်၊ သူရို့ကလည်း “ယောဟန်၏ ဗတ္တိဇံကို ခံယူပါ၏” ဟု ပြောဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","ထိုအခါ ပေါလုက “ယောဟန်၏ ဗတ္တိဇံသည် နောင်တတရားနှင့်ဆိုင်သော ဗတ္တိဇံ ဖြစ်၏။ ယောဟန်က၊ မိမိနောက်၌ ကြွလာတော်မူမည့် သူကို ယုံကြည်စီခြင်းငှာ ဣသရေလလူရို့အား ဟောပြောခ၏။ ထိုအသျှင်သည်ကား ယေသျှုပေတည်း” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ထိုသူရို့သည် ထိုစကားကို ကြားလျှင် အသျှင်ယေသျှု၏ နာမ၌ ဗတ္တိဇံကို ခံယူကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ပေါလုသည် သူရို့၏ ဂေါင်းထက်တွင် လက်ကို တင်လိုက်သောအခါ သန့်ယှင်းသောဝိညာဉ်တော်သည် သူရို့အထက်၌ သက်ရောက်လေ၏။ ထိုအခါ သူရို့သည် ထူးဆန်းသော ဘာသာစကားများဖြင့် ပြောကြပြီးလျှင် ဘုရားသခင်၏ သတင်းစကားတော်ကိုလည်း ဟောပြောကြေငြာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","ထိုသူအပေါင်းရို့သည် တစ်ဆယ့်နှစ်ယောက်မျှ ဟိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","ပေါလုသည် တရားဇရပ်သို့ ဝင်၍ ထိုနီရာ၌ လူရို့အား သုံးလပတ်လုံး ရဲ့ရင့်စွာ ဟောပြောလျက် ဘုရားသခင်၏ နိုင်ငံတော်အကြောင်းကို ထိုသူရို့ နားလည်သဘောပေါက်စီခြင်းငှာ ဆွေးနွေးနှီးနှောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","သို့ရာတွင် သူရို့အထဲက လူတချို့ရို့သည် ဂေါင်းမာပြီး မယုံကြည်သဖြင့် လူအပေါင်းရို့ရှိ့တွင် သခင်ဘုရား၏ သွန်သင်ချက်ကို လှောင်ပြောင်ပြောဆိုကြ၏။ သို့ဖြစ်၍ ပေါလုသည် ယုံကြည်သူရို့ကို ခေါ်၍ ထိုလူအပေါင်းရို့ ပါးမှ ထွက်ပြီး တုရန္နု၏စာသင်ခန်းမ၌ နိ့စဉ်နိ့တိုင်း ဆွေးနွေးခြင်းကို ပြုလျက်နိန်၏။ ");
INSERT INTO rki_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ဤသို့ဖြင့် နှစ်နှစ်ပတ်လုံး ဆွေးနွေးခြင်းကိုပြုရာ အာယှိပြည်တွင် နီထိုင်ကြသော ယုဒလူမျိုးရို့နှင့် တခြားလူမျိုးအပေါင်းရို့သည် သခင်ဘုရား၏ နှုတ်ကပတ်တရားတော်ကို ကြားနာရကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","ဘုရားသခင်သည် ပေါလုအားဖြင့် ထူးဆန်းသော နိမိတ်လက္ခဏာများကို ပြုတော်မူလျက်ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ပေါလု အသုံးပြုသည့် လက်ကိုင်ပဝါ၊ ခါးပန်း စသည်များကိုပင် မကျန်းမာသောသူရို့ ပါးသို့ ယူဆောင်လားခြင်းဖြင့် မကျန်းမာသော သူရို့သည် ရောဂါပျောက်ကင်း၍ ဝိညာဉ်ဆိုး ဝင်ပူးခံရသော သူရို့၌လည်း လွတ်မြောက်ခြင်းကို ရဟိလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","တချို့သော ယုဒလူမျိုး နယ်လှည့်ပယောဂဆရာရို့သည် အသျှင်ယေသျှု၏ နာမတော်ကို အသုံးပြု၍ ဝိညာဉ်ဆိုးကို နှင်ထုတ်ခြင်းငှာ ကြိုးစားကြ၏။ သူရို့က ဝိညာဉ်ဆိုးအား “ပေါလုဟောပြောသော ယေသျှု၏နာမကို တိုင်တည်၍ သင်ရို့ကို ငါ အမိန့်ပီး၏” ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","ထိုပယောဂဆရာရို့ကား၊ ယုဒအမျိုး ယဇ်ပုရောဟိတ် အကြီးအကဲဖြစ်သော သကေဝ၏ သားခုနစ်ယောက်ဖြစ်သတည်း။ ");
INSERT INTO rki_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","သူရို့သည် ထိုသို့ လုပ်ဆောင်ကြသော်လည်း ဝိညာဉ်ဆိုးက “ယေသျှုကို ငါသိ၏။ ပေါလု၏အကြောင်းကိုလည်း ငါသိ၏။ သို့သော် သင်ရို့ကား ဇာသူနည်း” ဟု သူရို့ကို မိန်းလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ထို့နောက် ဝိညာဉ်ဆိုး ဝင်ပူးသောသူသည် ထိုသူရို့အား ပြင်းထန်စွာ သတ်ပုတ်တိုက်ခိုက်၍ နိုင်သဖြင့်၊ သူရို့သည် အနာတရ ရပြီး အဝတ်မပါဘဲ ထိုအိမ်မှ ထွက်ဗြီးရကြလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","ထိုအကြောင်းအရာများကို ဧဖက်မြို့၌ ဟိကြသော ယုဒလူရို့နှင့် ဟေလသ လူရို့သည် ကြားကြလျှင် သူရို့သည် ကြောက်ရွံ့ခြင်းသို့ ရောက်ကြ၍ အသျှင်ယေသျှု၏ နာမတော်ကို အလွန် ချီးမွမ်းကြကုန်၏။ ");
INSERT INTO rki_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","ယုံကြည်လာသော သူရို့အထဲမှ များစွာသောသူရို့သည် လာကြ၍ မိမိရို့ပြုမူခသမျှသော အရာတိကို လူအပေါင်းရို့ရှိ့၌ ပွင့်လင်းစွာ ဝန်ခံကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","မှော်အတတ်ကို သုံးခသောသူများသည် ၎င်းနှင့်သက်ဆိုင်သော မိမိရို့၏စာလိပ်များကို ယူလာပြီး လူအပေါင်းရို့ရှိ့၌ မီးတိုက်ကြ၏။ သူရို့သည် ထိုစာလိပ်များ၏ တန်ဖိုးကို တွက်ကြည့်ရာ ငွီဒင်္ဂါးပြား ၅၀,၀၀၀ တန်ဖိုး ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ထိုသို့ဖြင့် သခင်ဘုရား၏ သာသနာတော်သည် ပြန့်နှံ့လျက် တန်ခိုးတော်အားဖြင့် ကြီးထွားတိုးပွားလျက်ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","ဤအမှုအရာများ ဖြစ်ပျက်ပြီးနောက်၊ မာကေဒေါနိပြည်နှင့် အခါယပြည်ကို ဖြတ်၍ ယေရုဆလင်မြို့သို့ ခရီးပြုမည်ဟု ပေါလုသည် စိတ်ပိုင်းဖြတ်လေ၏။ “ငါသည် ထိုဒေသများသို့ လားပြီးနောက် ရောမမြို့ကို မြင်ရလိမ့်မည်” ဟု ပေါလု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","ထို့ကြောင့် သူသည် အာယှိပြည်၌ ကာလအင်တန် တည်းခိုနီစဉ်၊ မိမိအား အလုပ်အကျွေးပြုသောသူ တိမောသေနှင့် ဧရတ္တုရို့ကို မာကေဒေါနိပြည်သို့ စီရွှတ်လိုက်၏။ ");
INSERT INTO rki_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","ထိုအချိန်၌ သခင်ဘုရား၏ သွန်သင်ချက်လမ်းစဉ်ကြောင့် ဧဖက်မြို့၌ ဆူပူအုံကြွမှုကြီး တစ်ရပ်ဖြစ်ပေါ်လာ၏။ ");
INSERT INTO rki_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","ဒေမေတရိ ဟူ၍ နာမည်ဟိသော ငွီပန်းထိမ်ဆရာတစ်ယောက်သည် အာတေမိနတ်သမီး၏ ငွီနတ်ကွန်းပုံတူချေများကို ပြုလုပ်ခြင်းဖြင့် ပန်းထိမ်အလုပ်သမားရို့အတွက် ဝင်ငွီများစွာ တိုးပွားစီခ၏။ ");
INSERT INTO rki_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ထိုသူသည် ပန်းထိမ်သမားရို့အား စုဝေးစီကြပြီး “အချင်းလူရို့၊ ဤလုပ်ငန်းဖြင့် ဝင်ငွီတိုးသည်ကို သင်ရို့သိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","အဂုတွင် ပေါလုက၊ ဧဖက်မြို့တွင်သာမက၊ အာယှိပြည်တလျှောက်လုံး၌ ‘လူ့လက်ဖြင့်လုပ်သော ဘုရားများသည် ဘုရားတိမဟုတ်’ ဟု ဆို၍ လူအပေါင်းရို့အား ဖြားယောင်းသည်ကို သင်ရို့ ကြားရ၊ မြင်ရကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","ထိုသို့ ငါရို့အလုပ်သည်လည်း နာမည်ပျက်ရုံသာမက ကြီးမြတ်သော နတ်ဘုရားမ အာတေမိ၏ ဗိမာန်တော်သည် ပျက်စီးလားမည်ဖြစ်၍ အာယှိပြည်နှင့် တစ်လောကလုံး ကိုးကွယ်သည့် နတ်ဘုရားမ၏ ကြီးမြတ်မှုသည်လည်း ဂုဏ်အသရေ ညှိုးနွမ်းလားမည် ဖြစ်ပါ၏” ဟု ပြောဆို၏။ ");
INSERT INTO rki_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ထိုစကားကိုကြားလျှင် ထိုသူရို့သည် ဒေါသထွက်၍ “ဧဖက်လူရို့၏ အာတေမိနတ်ဘုရားမသည် ကြီးမြတ်ပေ၏” ဟု ကြွေးကြော်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","တစ်မြို့လုံး ရုန်းရင်းဆန်ခတ်ဖြစ်၍၊ လူအများရို့သည် ပေါလုနှင့်အတူ ခရီးလားဖော်တိဖြစ်သော မာကေဒေါနိပြည်သား ဂါယုနှင့် အာရိတ္တာခုရို့ကို ဖမ်းဆီး၍ ပွဲခံရာဇရပ်သို့ ဆွဲခေါ်လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","ပေါလုသည် မိမိကိုယ်တိုင် ထိုလူစုအရှိ့သို့ လားခြင်းငှာ အလိုဟိသော်လည်း၊ ယုံကြည်သူရို့က တားမြစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","ပေါလု၏ အဆွီဖြစ်ကြသော နယ်အာဏာပိုင် တချို့ရို့ကလည်း ပွဲခံရာဇရပ်ထဲသို့ ကိုယ့်ကိုကိုယ် မအပ်နှံရန် လူလွှတ်၍ တောင်းပန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ထိုစဉ် စုဝေးလျက်ဟိသော လူရို့သည် အုတ်အုတ်သဲသဲပြု၍ တစ်ယောက်တစ်မျိုးစီ အော်ဟစ်သဖြင့် ထိုလူရို့ထဲက အများစုသည် မိမိရို့စုဝေးရသည့်အကြောင်းကိုပင် မိမိရို့မသိကြပေ။ ");
INSERT INTO rki_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","ယုဒလူမျိုးရို့သည် အာလေဇန္ဒြုကို လူအပေါင်းရို့ရှိ့သို့ ထွက်စီသဖြင့် လူထုအထဲမှ အချို့သည် ဖြစ်ပေါ်လျက်ဟိသော ပြဿနာ၏ အရင်းအမြစ်မှာ အာလေဇန္ဒြု ဖြစ်သည်ဟု ထင်မှတ်ကြ၏။ သူသည် လူထုပရိသတ်အား ဆိတ်ဆိတ်နိန်စီခြင်းငှာ လက်ရိပ်ပြပြီးလျှင် ချေပပြောဆိုရန် ကြိုးစား၏။ ");
INSERT INTO rki_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","သို့ရာတွင် ထိုသူသည် ယုဒလူမျိုး ဖြစ်ကြောင်းကို လူအပေါင်းရို့သိကြသောအခါ “ဧဖက်မြို့၏ အာတေမိနတ်ဘုရားမသည် ကြီးမြတ်ပေ၏” ဟု နှစ်နာရီတိတိ သံပြိုင်ကြွေးကြော်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","နောက်ဆုံး၌ မြို့စာရေးသည် ထိုလူတိကို ဆိတ်ဆိတ်နိန်စီပြီးလျှင် “ဧဖက်မြို့သားရို့၊ ကြီးမြတ်သော အာတေမိနတ်ဘုရားမ၏ နတ်ကွန်းနှင့် ကောင်းကင်ဘုံမှ ကျလာသည့် သူမ၏ ရုပ်တုကို စောင့်ထိန်းသော သူများဖြစ်ကြောင်းကို လူတိုင်း သိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","ဤအရာတိကို တစ်ယောက်မျှ မငြင်းနိုင်ရာ။ ထို့ကြောင့် သင်ရို့သည် တိတ်ဆိတ်စွာနီသင့်၏။ မဆင်ခြင်ဘဲ ဇာအမှုအရာကိုမျှ မပြုကေ့။ ");
INSERT INTO rki_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","ဗိမာန်တော်အား လုယူဖျက်ဆီးခြင်း အမှုကိုလည်း မပြု၊ ငါရို့၏ဘုရားများကိုလည်း ကဲ့ရဲ့ပြစ်မှားခြင်း မပြုသော ထိုသူရို့ကို သင်ရို့သည် ဤနီရာသို့ ဆောင်ခကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","ဒေမေတရိမှစ၍ သူ၏အပေါင်းအပါရို့သည် လူတစ်စုံတစ်ယောက်ကို တရားတွိ့လိုလျှင် တရားရုံးလည်းဟိ၏။ အာဏာပိုင်များလည်း ဟိ၏။ တရားရုံး၌ အမှုသည် အချင်းချင်း တွိ့ကြစီ။ ");
INSERT INTO rki_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","သို့ရာတွင် သင်ရို့၌ အခြားအမှုဟိလျှင် တရားဝင်အစည်းအဝေး၌ စီရင်ဆုံးဖြတ်ရမည်။ ");
INSERT INTO rki_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","ဤနိ့ ရုန်းရင်းဆန်ခတ်ဖြစ်ခြင်းသည် ငါရို့ကြောင့်ဟု စွပ်စွဲခံရမည်ကို စိုးရိမ်စရာဟိ၏။ ဤသို့ အုတ်အုတ်သဲသဲ ဖြစ်စရာ အကြောင်းမဟိ၊ ဤအကြောင်းအရာနှင့်ပတ်သတ်၍လည်း ဆင်ခြီပီးစရာ အကြောင်းမဟိ” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ဤသို့ပြောပြီးလျှင် မြို့စာရေးသည် စုဝေးသောသူရို့ကို ထိုနီရာမှ ထွက်လားစီတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ထိုရုန်းရင်းခတ်သောအမှု ပြီးလားသည့်နောက် ပေါလုသည် ယုံကြည်သူရို့ကို ခေါ်၍ အားပီးစကားပြောပြီး နှုတ်ဆက်လေ၏။ ထို့နောက် သူသည် မာကေဒေါနိပြည်သို့ ထွက်ခွာလားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","သူသည် ထိုဒေသတလျှောက်သို့လားကာ လူတိကို များစွာသော တရားစကားဖြင့် တိုက်တွန်းနှိုးဆော်ပြီးလျှင် အခါယပြည်သို့ လား၍၊ ");
INSERT INTO rki_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","သူသည် ထိုပြည်၌ သုံးလတိုင်တိုင် တည်းခိုလေ၏။ ထို့နောက် ယှုရိပြည်သို့ သင်္ဘောဖြင့် ရွက်ရွှင့်မည်ပြုစဉ် ယုဒလူရို့သည် မိမိအား လုပ်ကြံရန် ကြံစည်နိန်သည်ကို သိသဖြင့်၊ မာကေဒေါနိပြည်လမ်းဖြင့် ပြန်မည်ဟု စိတ်ပိုင်းဖြတ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","ပေါလုနှင့်အတူ အာယှိပြည်သို့ လိုက်သောသူရို့မှာ ဗေရိမြို့သားဖြစ်သော ပုရု၏သား သောပတရု၊ သက်သာလောနိတ်မြို့သား အာရိတ္တာခုနှင့် သေကုန္ဒု၊ ဒေရဗေမြို့သား ဂါယု၊ လုတ္တရမြို့သား တိမောသေ၊ အာယှိပြည်သား တုခိတ်နှင့် တရောဖိမ်ရို့ဖြစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ထိုသူရို့သည် အရှိ့မှ လား၍ တရောမြို့တွင် ငါရို့ကို စောင့်နိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","ငါရို့မူကား အဇုမပွဲတည်းဟူသော တဆီးမဲ့မုန့်ပွဲ လွန်ပြီးနောက် ဖိလိပ္ပိမြို့မှ သင်္ဘောဖြင့် ရွက်ရွှင့်လာခရာ ငါးရက်ကြာပြီးနောက် သူရို့ဟိရာ တရောမြို့သို့ ရောက်၍ ထိုနီရာ၌ ခုနစ်ရက်တည်းခိုနိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","စနီနိ့ ညဇာဖက်၌ ငါရို့သည် အတူတကွ မိတ်ဆုံ စားသုံးခြင်းငှာ စုရုံးကြ၏။ နောက်တစ်နိ့တွင် ပေါလုသည် ထိုမြို့မှ ထွက်လားရန် အကြံဟိသဖြင့် သန်းခေါင်ယံတိုင်အောင် လူတိအား သွန်သင်လျက်ဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ငါရို့ စည်းဝေးရာ အထက်ခန်း၌ ထွန်းညှိထားသော မီးခွက်များစွာဟိ၏။ ");
INSERT INTO rki_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ပေါလုသည် ကြာမြင့်စွာ ဟောပြောသဖြင့် ဥတုခု ဟု နာမည်ဟိသော လူငယ်တစ်ယောက်သည် ပြတင်းပေါက်နား၌ ထိုင်၍ ငိုက်မျိုင်းအိပ်ပျော်နိန်၏။ နောက်ဆုံး သူသည် နှိုက်နှိုက်ချိုက်ချိုက် အိပ်မောကျသောကြောင့် အိမ်သုံးဆင့် အထက်မှ ပြုတ်ကျလေ၏။ သူရို့သည် သူ့ကို ထူမလိုက်သောအခါ သီဆုံးနိန်သည်ကို တွိ့ရ၏။ ");
INSERT INTO rki_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","ပေါလုသည်လည်း အောက်သို့ဆင်း၍ ထိုသူ၏အထက်၌ ကိုယ်ကို လှဲချ၍ ဖက်ပြီးလျှင် “မစိုးရိမ်ကတ်ကေ့။ သူသည် အသက်ရှင်လျက် ဟိသည်” ဟု ဆိုလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","ထို့နောက် ပေါလုသည် အိမ်ထက်သို့ ပြန်တက်ပြီးလျှင် မုန့်ကိုဖဲ့၍ စားလေ၏။ အစားအစာ သုံးဆောင်ပြီးနောက် ပေါလုသည် ထိုသူရို့နှင့်အတူ အရုဏ်တက်သည့်တိုင်အောင် ကြာမြင့်စွာ စကားပြောပြီးနောက် ထိုမြို့မှ ထွက်လားလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","သူရို့သည်လည်း ထိုအသက်ရှင်လျက် ဟိသောလူငယ်ကို အိမ်သို့ ဆောင်လားပြီးမှ အလွန်စိတ်သက်သာရာ ရကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","ငါရို့သည် သင်္ဘောထက်သို့ အယင်တက်၍ အဿုမြို့သို့ ရွက်ရွှင့်ကြ၏။ ထိုမြို့မှသာ ပေါလုကို သင်္ဘောဖြင့် လိုက်စီခြင်းငှာဖြစ်၏။ အကြောင်းမူကား ပေါလုသည် ထိုမြို့သို့ ကုန်းလမ်းဖြင့် လားသောကြောင့် ဤသို့ စီမံထားခခြင်းဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","သူသည် အဿုမြို့၌ ငါရို့ကို တွိ့လျှင်၊ ငါရို့သည် သူ့ကို သင်္ဘောထက်သို့ ခေါ်တင်ပြီး မိတုလင်မြို့သို့ လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","ထိုမှ ရွက်ရွှင့်ကြရာ နောက်တစ်နိ့၌ ခိအုကျွန်းသို့ ရောက်ကြ၏။ နောက်တစ်ရက်ကြာသော် သာမုကျွန်းသို့ ရောက်ကြပြီးလျှင် ထိုမှတစ်ဆင့် နောက်တစ်ရက် ကြာသောအခါ မိလက်မြို့သို့ ရောက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","ပေါလုသည် အာယှိနယ်၌ အချိန် မကုန်ဆုံးစီလိုသဖြင့် ဧဖက်မြို့နားမှဖြတ်၍၊ ဖြစ်နိုင်လျှင် ပင်တေကုတ္တေ ပွဲတော်နိ့အမီ ယေရုဆလင်မြို့သို့ စောလျင်စွာ ရောက်နိုင်ခြင်းငှာ ရွက်ရွှင့်ရန် စိတ်ပိုင်းဖြတ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","ပေါလုသည် ဧဖက်မြို့၌ဟိသော အသင်းတော်လူကြီးများအား မိမိနှင့် လာရောက်တွိ့ဆုံခြင်းငှာ မိလက်မြို့မှ သတင်းပါးလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","ထိုသူရို့ရောက်လာကြသောအခါ၊ ပေါလုက “ငါသည် အာယှိပြည်သို့ ရောက်သော ပထမနိ့မှစ၍ သင်ရို့နှင့်အတူ တစ်ချိန်လုံး ဇာပိုင် အသက်ရှင်ခသည်ကို သင်ရို့သိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ယုဒလူမျိုး တချို့၏ မကောင်းသော အကြံအစည်များကြောင့် ဆင်းရဲဒုက္ခ ခံရချိန်တွင် ငါသည် စိတ်နှလုံးနှိမ့်ချကာ မျက်ရည်ကျလျက် သခင်ဘုရား၏ အခိုင်းအစီအဖြစ် အမှုတော်မြတ်ကို ထမ်းဆောင်ခ၏။ ");
INSERT INTO rki_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","သင်ရို့၏ အိမ်များ၌သော်လည်းကောင်း၊ လူထုပရိသတ်ရို့၏ ရှိ့၌သော်လည်းကောင်း ငါသည် ဟောပြောသွန်သင်ပီးသောအခါ သင်ရို့၌ အကျိုးဟိစီမည့် ဇာစကားကိုမျှ ချန်၍ မထားခသည်ကို သင်ရို့သိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","ငါသည် ယုဒလူမျိုးရို့နှင့် ဟေလသလူရို့အား မိမိရို့အပြစ်မှ နောင်တရ၍ ဘုရားသခင်ပါးသို့ လှည့်လာစီခြင်းငှာ လည်းကောင်း၊ အသျှင်ယေသျှုကို ယုံကြည်ကြစီခြင်းငှာ လည်းကောင်း လေးနက်စွာ သတိပီးခ၏။ ");
INSERT INTO rki_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","အဂုမှာ ငါသည် သန့်ယှင်းသောဝိညာဉ်တော်ကို နာခံ၍ ယေရုဆလင်မြို့သို့ လားရမည်။ ထိုမြို့တွင် ငါ၌ ဇာပိုင် ဖြစ်မည်ကို ငါမသိ။ ");
INSERT INTO rki_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","သန့်ယှင်းသောဝိညာဉ်တော်သည် ငါအား သတိပီးသော အရာမူကား၊ ချုပ်နှောင်ခြင်းနှင့် ဒုက္ခဆင်းရဲများခြင်းသည် ငါ့အား မြို့အသီးသီးမှ စောင့်ကြိုနိန်သည် ဟူ၍ ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","သို့သော် ငါသည် ငါ့အသက်ကို နှမြောခြင်းမဟိဘဲ၊ ငါ၏အမှုတော်ကို ပြည့်စုံစီခြင်းငှာ လည်းကောင်း၊ အသျှင်ယေသျှု ပီးအပ်တော်မူသည့် အလုပ်တာဝန်ကိုလည်းကောင်း ပြီးဆုံးအောင် ဆောင်ရွက်နိုင်မှုကိုသာလျှင် ပမာဏပြု၏။ ကိုယ်တော် ပီးအပ်တော်မူသော အမှုတော်မူကား ဘုရားသခင်၏ ကျေးဇူးတော်အကြောင်း သတင်းကောင်းကို ဟောပြောကြေညာရန်ပင် ဖြစ်သတည်း။ ");
INSERT INTO rki_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“ငါသည် သင်ရို့ပါးသို့ လှည့်လည်၍ ဘုရားသခင်၏ နိုင်ငံတော်အကြောင်းကို ဟောပြောခ၏။ သို့သော် အဂုကား ငါ့မျက်နှာကို နောက်တဖန် မြင်ရကြလိမ့်မည် မဟုတ်ကြောင်းကို ငါသိ၏။ ");
INSERT INTO rki_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","သို့ဖြစ်၍ သင်ရို့ထဲမှ တစ်ဦးတစ်ယောက်သည် အသက်ဆုံးယှုံးလျှင် ငါနှင့် မသက်ဆိုင်ကြောင်းကို ငါသည် ဤနိ့ သင်ရို့ကို လေးနက်စွာပြော၏။ ");
INSERT INTO rki_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","အကြောင်းမူကား၊ ငါသည် တွန့်ဆုတ်ခြင်းမဟိဘဲ သင်ရို့အား ဘုရားသခင်၏အကြံအစည်ကို အကုန်အစင် ဟောပြောကြေငြာရန်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","ထို့ကြောင့် သင်ရို့သည် မိမိကိုယ်ကိုလည်းကောင်း၊ သန့်ယှင်းသောဝိညာဉ်တော် ပီးထားသော သိုးစုရို့ကိုလည်းကောင်း ကြည့်ရှုစောင့်ရှောက်ကြလော့။ ဘုရားသခင့် အသင်းတော်၏ သိုးထိန်းများ ဖြစ်စီကြလော့။ ထိုအသင်းတော်မူကား ဘုရားသခင်သည် မိမိသားတော်၏ အသွီးတော်အားဖြင့် မိမိပိုင်ဆိုင်ရာ အသင်းတော် ဖြစ်စီ၏။ ");
INSERT INTO rki_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","ငါမဟိသည့်နောက်၌ ရက်စက်ကြမ်းကြုတ်သော တောခွီးရို့သည် သင်ရို့ပါးသို့ လာ၍ သိုးစုတိကို ညှာတာလိမ့်မည် မဟုတ်သည်ကို ငါသိ၏။ ");
INSERT INTO rki_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","သင်ရို့အထဲမှ တချို့သော လူတိက လိမ်ဝါပြောဆိုကာ ယုံကြည်သူများကို သူရို့နောက်သို့ ဆွဲဆောင်လားမည့် အချိန်ကာလသည် ရောက်လာလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ထို့ကြောင့် သတိဖြင့် နီကြလော့။ ငါသည် နိ့၊ ညဉ့်မပြတ် သုံးနှစ်ပတ်လုံး မျက်ရည်ကျပြီး သင်ရို့ တစ်ယောက်ချင်းစီတိုင်းအား သွန်သင်ပီးခသည်ကို သတိရကြလော့။ ");
INSERT INTO rki_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“အဂု ငါသည် သင်ရို့အား ဘုရားသခင်၏ လက်တော်သို့ လည်းကောင်း၊ ကျေးဇူးတရားလက်သို့ လည်းကောင်း အပ်နှံ၏။ ထိုကျေးဇူးတရားသည် သင်ရို့ကို တည်ဆောက်လျက် မိမိ၏လူအားလုံးအဖို့ လျာထားသော ဘုရားသခင်၏ ကောင်းကြီးမင်္ဂလာကို သင်ရို့အား ပီးလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","ငါသည် သူတစ်ပါး၏ ရွှီ၊ ငွီနှင့် အဝတ်အစားတိကို လိုချင်တပ်မက်ခြင်း မဟိ။ ");
INSERT INTO rki_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","ငါနှင့် ငါ့အပေါင်းဖော်ရို့၏ လိုအပ်ချက်များအတွက် ငါသည် ငါ့လက်ဖြင့် အလုပ်လုပ်၍ ထောက်ပံ့ခကြောင်းကို သင်ရို့ကိုယ်တိုင် သိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","သင်ရို့အား ငါ ပြသခသည့်အတိုင်း ခပ်သိမ်းသောအရာ၌ အလုပ်ကို ကြိုးစားလုပ်ဆောင်ပြီး အားနည်းသောသူရို့ကို ကူညီမစ ကြလော့။ အသျှင်ယေသျှုကိုယ်တိုင် ပြောခသော ‘ပီးကမ်းခြင်းသည် ရယူခြင်းထက် သာ၍ မင်္ဂလာဟိ၏’ ဟူသော စကားကို အောက်မိ့ကြလော့” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ပေါလုသည် ထိုသို့ပြောပြီးမှ ထိုသူရို့နှင့်အတူ ဒူးထောက်၍ ဆုတောင်းလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","ထိုသူအပေါင်းရို့သည် ငိုယိုလျက် ပေါလုအား ဖက်၍ နမ်းပြီးလျှင် နှုတ်ဆက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","အကြောင်းမူကား ပေါလုသည် သင်ရို့ ငါ့မျက်နှာကို နောက်တဖန် မမြင်ရယာဟု ဆိုသောကြောင့် ထိုသူရို့ အလွန် ဝမ်းနည်းကြသောကြောင့် ဖြစ်၏။ ထို့နောက် ထိုသူရို့သည် ပေါလုအား သင်္ဘောသို့ လိုက်ပို့ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ငါရို့သည် ထိုသူရို့အား နှုတ်ဆက် ထွက်ခွာလာပြီးနောက် ကောသကျွန်းသို့ တည့်တည့်ရွက်ရွှင့်ရာ နောက်တစ်နိ့၌ ရောဒုကျွန်းသို့ ရောက်ကြပြီး ထိုကျွန်းမှ ပတရမြို့သို့ ခရီးဆက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","ထိုမြို့၌ ဖိနိတ်ပြည်သို့ ကူးသော သင်္ဘောကိုတွိ့လျှင် ထိုသင်္ဘောထက်သို့ တက်၍ ရွက်ရွှင့်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","ငါရို့သည် ကုပရုကျွန်းကို မြင်ရသောအခါ ထိုကျွန်း၏တောင်ဖက်အရပ်မှ ဖြတ်၍ ယှုရိပြည်သို့ ရွက်ရွင့်ကြလေ၏။ တုရုမြို့၌ ကုန်ပစ္စည်းများကို ချရမည်ဖြစ်သောကြောင့် သင်္ဘောသည် ထိုမြို့တွင် ဆိုက်ကပ်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","ထိုအရပ်တွင် ယုံကြည်သူတချို့ကို ငါရို့သည် တွိ့သဖြင့် ထိုသူရို့နှင့်အတူ ရက်သတ္တတစ်ပတ် တည်းခိုကြ၏။ ဝိညာဉ်တော်၏ တန်ခိုးတော်အားဖြင့် ထိုသူရို့သည် ပေါလုအား ယေရုဆလင်မြို့သို့ မလားစီခြင်းငှာ ပြောကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","သို့ပိုင်သျှောင် ခုနစ်ရက်လွန်သောအခါ ငါရို့သည် ထိုအရပ်မှ ထွက်၍ ငါရို့၏ ခရီးစဉ်အတိုင်း ခရီးဆက်ကြ၏။ သူရို့သည်လည်း မိမိရို့၏မယားတိ၊ အချေတိနှင့်အတူ မြို့ပြင်ကမ်းခြီသို့ လိုက်ပို့ကြ၏။ ထိုနီရာတွင် ငါရို့အားလုံးသည် ဒူးထောက်ပြီး ဆုတောင်းကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ထို့နောက် ငါရို့သည် အချင်းချင်း နှုတ်ဆက်ပြီး သင်္ဘောထက်သို့ တက်ကြ၏။ သူရို့သည်လည်း မိမိအိမ်သို့ ပြန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","ငါရို့သည် တုရုမြို့မှ ခရီးဆက်ကြပြန်၍ ပတောလင်မြို့သို့ ရောက်ကြ၏။ ငါရို့သည် ထိုမြို့တွင် ယုံကြည်သူများနှင့် တွိ့၍ မိတ်ဆက်ပြီး ထိုသူရို့၌ တစ်ရက်တာ တည်းခိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","နောက်တစ်နိ့၌ ငါရို့သည် ထိုမြို့မှ ထွက်ခွာလျှင် ကဲသရိမြို့သို့ ရောက်ကြ၏။ ငါရို့သည် ထိုမြို့တွင် ဧဝံဂေလိဆရာ ဖိလိပ္ပု၏အိမ်၌ တည်းခိုကြ၏။ ထိုဖိလိပ္ပုမူကား၊ ယေရုဆလင် အသင်းတော်မှ ရွီးချယ်ထားသော ဆရာခုနစ်ပါးထဲမှ တစ်ပါးအပါအဝင်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","သူ၌ အိမ်ထောင်မပြုရသိမ့်သော သမီးလေးယောက် ဟိ၏။ သူမရို့သည် ဘုရားသခင်၏ သတင်းတော်ကို ဟောပြောကြေငြာသော သူများဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","အကျွန်ရို့သည် ထိုအိမ်တွင် ရက်တာရှည်စွာ တည်းခိုကြသောအခါ၊ အာဂဗုဟု နာမည်ဟိသော ပရောဖက်တစ်ယောက်သည် ယုဒပြည်မှ ရောက်လာ၏။ ");
INSERT INTO rki_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ထိုသူသည် အကျွန်ရို့ပါးသို့ လာ၍ ပေါလု၏ ခါးပတ်ကြိုးကို ယူပြီးလျှင်၊ မိမိ၏ခြီနှင့် လက်တိကို တုပ်နှောင်ကာ “ဤခါးပတ်ကြိုး ပိုင်သျှင်သည် ယေရုဆလင်မြို့၌ ဟိသောယုဒလူမျိုးရို့၏ ဤပိုင် တုပ်နှောင်ခြင်းကို ခံရပြီးလျှင် တခြားလူမျိုးရို့၏ လက်သို့ အပ်နှံခြင်းကို ခံရလိမ့်မည်ဟု သန့်ယှင်းသောဝိညာဉ်တော် မိန့်တော်မူသည်” ဟူ၍ ဆိုလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ထိုစကားကို ကြားကြသောအခါ အကျွန်ရို့နှင့် ထိုအရပ်၌ ဟိသောလူရို့သည် ပေါလုအား ယေရုဆလင်မြို့သို့ ဆက်မလားရန် တောင်းပန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","သို့ရာတွင် ပေါလုက၊ “သင်ရို့သည် ဇာကြောင့် ဤပိုင် ငိုယိုပြီးလျှင် ငါ့နှလုံးကို ကြီကွဲအောင် လုပ်နိန်ကြသနည်း။ ငါသည် အသျှင်ယေသျှု၏ နာမအဖို့အလို့ငှာ ယေရုဆလင်မြို့၌ တုပ်နှောင်ခံရန် သာမက အသီခံရန်ပင် အသင့်ဟိ၏” ဟု ပြန်ပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","အကျွန်ရို့လည်း ပေါလုအား ဖျောင်းဖျ၍ မရသောကြောင့် “သခင်ဘုရား၏ အလိုတော်အတိုင်း ဖြစ်ပါစီ” ဟု ဆို၍ လက်လျော့လိုက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","ထိုနီရာ၌ ကာလအင်တန်ကြာပြီးနောက်၊ အကျွန်ရို့သည် ပစ္စည်းများကို ထုပ်ပိုးကြပြီး ယေရုဆလင်မြို့သို့ ခရီးဆက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","ကဲသရိမြို့မှ တပည့်တော်တချို့သည်လည်း အကျွန်ရို့နှင့်အတူ လိုက်ကြပြီး ကုပရုကျွန်းသား ယုံကြည်သူ လူဟောင်းတစ်ဦးဖြစ်သူ မနာသုန်အိမ်၌ တည်းခိုခြင်းငှာ အကျွန်ရို့အား ခေါ်လားကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","ယေရုဆလင်မြို့သို့ အကျွန်ရို့ရောက်ကြသောအခါ၊ ယုံကြည်သူများက အကျွန်ရို့ကို နွီးထွီးစွာကြိုဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","နောက်တစ်နိ့၌ ပေါလုသည် အကျွန်ရို့နှင့်အတူ ယာကုပ်ပါးသို့ လားရောက်တွိ့ဆုံ၏။ အသင်းတော်လူကြီး အပေါင်းရို့လည်း သူ့ထံ၌ ရောက်နိန်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","ပေါလုသည် ထိုသူရို့အား မိတ်ဆက်ပြီးနောက် မိမိ၏အမှုတော်အားဖြင့် တခြားလူမျိုးရို့၌ ဘုရားသခင်ပြုတော်မူသော အမှုအရာအလုံးစုံတိကို ပြည့်စုံစွာ တင်ပြတော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ထိုသို့ တင်ပြသမျှကို ကြားပြီးသည့်နောက်၊ သူရို့အားလုံးသည် ဘုရားသခင်အား ချီးမွမ်းကြ၏။ ထို့နောက် သူရို့အပေါင်းက “ညီအစ်ကို ပေါလု၊ သင်မြင်သည့်အတိုင်း ထောင်ပေါင်းများစွာသော ယုဒလူများသည် ယုံကြည်သူများ ဖြစ်လာကြပြီး ထိုသူအပေါင်းရို့သည်လည်း ပညတ်တရားကို ဆည်းကပ်စွဲလန်းသောသူတိ ဖြစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","သင်သည် တခြားလူမျိုးရို့ကြား၌ နီထိုင်ကြသော ယုဒလူမျိုးတိအား မောသျှေ၏တရားကို စွန့်ပစ်စီရန် လည်းကောင်း သူရို့၏ အချေတိအား အရီဖျားလှီးခြင်းကို မခံစီခြင်းငှာ လည်းကောင်း၊ ယုဒထုံးတမ်းကို မလိုက်နာကြစီရန် လည်းကောင်း သွန်သင်ပီးနီကြောင်းကို သူရို့သည် ကြားသိကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","သင် ရောက်လာကြောင်းကို ထိုသူရို့ ကြားကြမည်မှာ သေချာပါ၏။ သို့ဖြစ်၍ ဇာပိုင် လုပ်ရပါမည်နည်း။ ");
INSERT INTO rki_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","ထို့ကြောင့် ငါရို့ပြောသည့်အတိုင်း လုပ်ပါလော။ သစ္စာပြုပြီးသော လူလေးယောက်သည် ဤအရပ်၌ ဟိပါ၏။ ");
INSERT INTO rki_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","ထိုသူရို့ကို ခေါ်လားပြီးလျှင် စင်ကြယ်ခြင်း မင်္ဂလာကို သူရို့နှင့်အတူ ပြုပါလော့။ သူရို့သည် ဂေါင်းရိတ်ခြင်းကို ပြုနိုင်စီခြင်းငှာ သူရို့အတွက် ကုန်ကျစရိတ်ကို သင် ပီးပါလော့။ ထိုသို့ ပြုပါလျှင် သူရို့ ကြားခကြသော သင်၏အကြောင်းမှာ မှန်ကန်မှု မဟိကြောင်းကိုလည်းကောင်း၊ သင်ကိုယ်တိုင်ပင် မောသျှေ၏ ပညတ်တရားအတိုင်း အသက်ရှင်ကြောင်းကိုလည်းကောင်း သိကြပါလိမ့်မည်။ ");
INSERT INTO rki_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","သို့ပိုင်သျှောင် တခြားလူမျိုးမှ ယုံကြည်သူ ဖြစ်လာသောလူရို့အတွက်ကား၊ ရုပ်တုကို ပူဇော်ထားသော အစားအစာများကိုလည်းကောင်း၊ အသွီးကိုလည်းကောင်း၊ လိုင်ပင်းကို လိမ်၍ သတ်သောအသားနှင့် မတရားသောမေထုန်ကိုလည်းကောင်း ယှောင်ကြရန် ငါရို့ စီရင်ဆုံးဖြတ်ချက်ကို စာရီး၍ ပို့ပြီးပါယာ” ဟု ဆိုကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","ထို့ကြောင့် နောက်တစ်နိ့၌ ပေါလုသည် ထိုလူလေးယောက်ရို့ကို ခေါ်ပြီးလျှင် သူရို့နှင့်အတူ စင်ကြယ်ခြင်းမင်္ဂလာကို ခံယူ၏။ ထို့နောက် သူသည် ဗိမာန်တော်ထဲသို့ ဝင်လား၍ သူရို့အတွက် တစ်ယောက်ချင်းစီ ပူဇော်သကာဆက်သရမည့် အချိန်တည်းဟူသော သန့်စင်ခြင်းကိုပြုရသော ပြီးဆုံးမည့်နိ့ရက်အချိန်ကို ပြောလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","ထိုခုနစ်ရက်တာ ကာလကုန်ဆုံး လုသောအခါ အာယှိမှ လာသော ယုဒလူအချို့သည် ဗိမာန်တော်၌ ပေါလုကို မြင်တော်မူ၏။ သူရို့သည် စုဝေးလျက်ဟိသော လူအပေါင်းရို့၏စိတ်ကို ထိုးဆွ၍ ပေါလုအား ဖမ်းဆီးကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","သူရို့က “ဣသရေလအမျိုးသားရို့၊ အကျွန်ရို့ကို ကူမကြပါ။ ဤသူသည် လားသောနီရာတိုင်းမှာ ငါရို့လူမျိုးကိုလည်းကောင်း၊ ပညတ်တရားနှင့် ဤအရပ်ကိုလည်းကောင်း ဆန့်ကျင်ပြီး သွန်သင်နိန်သောသူ ဖြစ်ပါ၏။ အဂုလည်း ဤသူသည် သန့်ယှင်းသော ဌာနတော်ကို ညစ်ညူးစီရုံသာမက ဤဗိမာန်တော်ထဲကိုလည်း တခြားလူမျိုးတချို့ကို ခေါ်သွင်းလီယာ” ဟု ဟစ်အော်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","ဤသို့ သူရို့ပြောရခြင်းကား၊ ပေါလုအား ဧဖက်မြို့မှ တရောဖိမ်ဟု အမည်ဟိသော သူနှင့်အတူ မြို့ထဲ၌ တွိ့မြင်ခသဖြင့် ထိုသူအား ပေါလုသည် ဗိမာန်တော်ထဲသို့ ခေါ်သွင်းသည်ဟု ထင်မှတ်သောကြောင့်ဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","တစ်မြို့လုံး ရုန်းရင်းဆန်ခတ်ဖြစ်ပြီး၊ လူရို့သည်လည်း တညီတညွတ်တည်း ဗြီးလာကာ ပေါလုအား ဖမ်းဆီးပြီး ဗိမာန်တော်၏ အပြင်ဖက်သို့ ဆွဲခေါ်လားကြ၏။ ထို့နောက် ချက်ချင်းပင် ဗိမာန်တော်၏ တန်းခါးများကို ပိတ်လိုက်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","လူရို့သည် ပေါလုအား အသီသတ်ခြင်းငှာ ကြိုးစားနိန်စဉ်၊ ရောမတပ်မှူးသည် ယေရုဆလင်တစ်မြို့လုံး ရုန်းရင်းဆန်ခတ် ဖြစ်နိန်ကြောင်းကို သတင်းရလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ရောမတပ်မှူးသည်လည်း စစ်သားတိနှင့် တပ်ခွဲမှူးတချို့ကို ချက်ချင်း ခေါ်၍ သူရို့ဟိရာသို့ ချက်ချင်းပင် ဗြီးလာကြ၏။ လူအပေါင်းရို့သည်လည်း ထိုသို့ ရောမတပ်မှူးနှင့် စစ်သားရို့ လာကြသည်ကို မြင်လျှင် ပေါလုကို မသတ်ဘဲ နီကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","ထိုအခါ တပ်မှူးသည် ပေါလု အနားသို့ရောက်လာ၍ ဖမ်းပြီး၊ သံကြိုးနှစ်ပင်ဖြင့် တုပ်နှောင်ကာ ထားစီ၏။ ထို့နောက် တပ်မှူးက “ဤသူကား ဇာသူနည်း၊ ဇာအမှုကို ပြုသနည်း” ဟု မိန်းမြန်းလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","လူအပေါင်းရို့ထဲမှ တချို့ကလည်း တစ်ယောက်တစ်မျိုးစီ ပြောဆိုနိန်ကြ၏။ ထိုဆူညံသံများကြောင့် တပ်မှူးသည် အဖြစ်မှန်ကို မသိနိုင်ဖြစ်၍၊ ပေါလုအား တပ်စခန်းထဲသို့ ခေါ်ဆောင်လားရန် မိမိလူရို့အား အမိန့်ပီးလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","လူရို့သည် ရုန်းရင်းဆန်ခတ်ဖြစ်သောကြောင့် လှီကားသို့ ရောက်သောအခါ စစ်သားရို့သည် ပေါလုကို ပွိ့မ၍ ယူရကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","လူအပေါင်းရို့သည်လည်း “ယင်းသူကို အသီသတ်ပါ” ဟု ဟစ်အော်လျက် နောက်မှ လိုက်လာကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","စစ်သားရို့က ပေါလုအား တပ်စခန်းထဲသို့ ခေါ်ယူမည်ပြုစဉ်၊ ပေါလုက တပ်မှူးအား “သင်နှင့် ငါ စကား စိကေချေ ပြောခွင့်ပီးပါ” ဟု တောင်းလျှင်၊ တပ်မှူးက “သင်သည် ဟေလသစကား ပြောတတ်သလော။ ");
INSERT INTO rki_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","သင်သည် မကြာသိမ့်သော အချိန်က ပုန်ကန်မှုကို အစပြုခပြီး ဓားပြ ၄,၀၀၀ အား တောကန္တာရသို့ ခေါ်လားသော အဲဂုတ္တုလူဖြစ်သည် မဟုတ်လော” ဟု မိန်းလေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","ထိုအခါ ပေါလုက “ငါသည် ကိလိကိပြည် တာယှုမြို့၌ မွီးဖွားသော ယုဒလူမျိုးဖြစ်ပြီး သာမည မြို့သား မဟုတ်ပါ။ ဤသူရို့အား စကားပြောရသောအခွင့် ပီးပါ” ဟု တောင်းပန်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","တပ်မှူးသည်လည်း အခွင့်ပီးလေ၏။ ထိုအခါ ပေါလုသည် လှီကားထက်တွင် မတ်တပ်ရပ်၍ ဆိတ်ဆိတ်နိန်ရန် လက်ဖြင့် အချက်ပြလေ၏။ လူရို့သည် တိတ်ဆိတ်စွာ နီကြသောအခါ ပေါလုသည် ဟေဗြဲဘာသာစကားဖြင့် ပြောဆိုသည်မှာ၊ ");
INSERT INTO rki_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“ညီအစ်ကိုရို့နှင့် ဖခင်ရို့၊ ငါ၏ ဖြေယှင်းချက်ကို နားထောင်ကြပါ” ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","ထိုသို့ ပေါလုသည် ဟေဗြဲဘာသာစကားနှင့် ပြောသည်ကို သူရို့သည် ကြားကြလျှင် သာ၍ တိတ်ဆိတ်စွာနီကြ၏။ ထိုအခါ ပေါလုက ဆက်လက်၍၊ ");
INSERT INTO rki_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“ငါသည် ကိလိကိပြည်၊ တာယှုမြို့တွင် မွီးဖွားသော ယုဒလူမျိုးဖြစ်ပါ၏။ ယေရုဆလင်မြို့တွင် ကြီးပြင်းလာ၍ ဂါမလျေလထံတွင် ပညာဆည်းပူးလာသူ တစ်ယောက်ဖြစ်ပြီး ငါရို့ အဖိုးအဖီးရို့၏ နည်းဥပဒေသကို တိကျစွာ ခံယူလာသောသူ တစ်ယောက်ဖြစ်ပါ၏။ ဤနိ့ ဤနီရာ၌ ဟိသော လူအားလုံးကဲ့သို့ ဘုရားသခင်၏ အမှုတော်ဖက်၌ စိတ်အားကြီးသော သူဖြစ်ပါ၏။ ");
INSERT INTO rki_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ငါသည် ဤသွန်သင်ချက်ကို လိုက်လျှောက်သောသူရို့ကို သီဆုံးသည်ထိတိုင်အောင် ညှဉ်းဆဲခပြီးလျှင် ယောက်ျား၊ မိန်းမရို့ကိုလည်း ဖမ်းဆီး၍ ထောင်ထဲ၌ ချထားခပါ၏။ ");
INSERT INTO rki_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","ငါပြောသောအရာသည် မှန်ကန်ကြောင်းကို ယဇ်ပုရောဟိတ်မင်းနှင့် လွှတ်တော်တစ်ရပ်လုံးက သက်သီခံနိုင်ကြပါ၏။ ငါသည် ထိုသူရို့ပါးမှ ဒမာသက်မြို့၌ နီသော ယုဒလူမျိုးညီအစ်ကိုရို့ကို ရီးလိုက်သောစာတိကို လက်ခံရဟိသောကြောင့် ထိုဘာသာ၌ ယုံကြည်သက်ဝင်သော သူရို့ကို ဖမ်းဆီးပြီး သံကြိုးများဖြင့် တုပ်၍ ယေရုဆလင်မြို့သို့ ပြစ်ဒဏ်ပီးခြင်းငှာ ခေါ်ဆောင်လာရန် ထိုမြို့သို့ လားခပါ၏။ ");
INSERT INTO rki_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“ငါသည် ခရီးလား၍ ဒမာသက်မြို့ အနားသို့ ရောက်သောအခါ၊ မွန်းတည့်အချိန်ခန့်တွင် အာကာမှ တောက်ပသော အလင်းတန်းသည် ငါ၏ ပတ်လည်၌ ရုတ်ကနဲ ထွန်းတောက်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ငါသည်လည်း မြီထက်မှာ လဲကျပြီး ‘သျှောလု၊ သျှောလု၊ ငါ့ကို ဇာကြောင့် ညှဉ်းဆဲနိန်သနည်း’ ဟု ငါအား ပြောသောစကားသံကို ကြားရ၏။ ");
INSERT INTO rki_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","ငါကလည်း ‘အသျှင်၊ သင်ကား ဇာသူနည်း’ ဟု မိန်းလျှင်၊ ‘ငါကား သင် ညှည်းဆဲနိန်သော နာဇရက်မြို့သား ယေသျှု ဖြစ်၏’ ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","ငါနှင့်အတူ လိုက်လာကြသောသူရို့ကလည်း ထိုအလင်းကို မြင်ကြ၏။ သို့သော် ငါ့ကို ပြောနိန်သော ထိုသူ၏စကားသံကိုကား သူရို့ တစ်ယောက်မျှ မကြားကြ။ ");
INSERT INTO rki_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","ငါကလည်း ‘အသျှင်၊ အကျွန် ဇာချင့် လုပ်ရပါမည်နည်း’ ဟု မိန်းလျှင်၊ ထိုအသျှင်က ‘သင် ထပြီး ဒမာသက်မြို့ထဲသို့ လားလော့၊ သင်ဆောင်ရွက်စရာအဖို့ ဘုရားသခင်က ခွဲခန့်သတ်မှတ်ထားသော အမှုအရာတိကို ထိုမြို့၌ ပြောပြလိမ့်မည်’ ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","ထိုတောက်ပသော အလင်းတန်းကြောင့် ငါသည် မျက်စိကွယ်လေ၏။ ထို့ကြောင့် ငါနှင့်လိုက်လာသောသူရို့က ငါ့ကို လက်ဆွဲ၍ ဒမာသက်မြို့ထဲသို့ ခေါ်လား၏။ ");
INSERT INTO rki_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“ထို့နောက် အာနနိဆိုသူ တစ်ယောက်သည် ငါ့ပါးသို့ ရောက်လာ၏။ ထိုသူသည် ငါရို့၏ပညတ်တရားကို လိုက်လျှောက်၍ ဘုရားဝတ်၌ မွိ့ပျော်သောသူ ဖြစ်သည်နှင့်အညီ ထိုအရပ်၌ နီထိုင်ကြသော ယုဒလူအားလုံး၏ ရိုသီလေးစားခြင်းကို ခံရသော သူဖြစ်၏။ ");
INSERT INTO rki_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","ထိုသူသည် ငါ့ပါးသို့ လာပြီး အနား၌ ရပ်ကာ ‘ငါ့ညီ သျှောလု၊ မျက်စိ ပြန်၍ မြင်စီ’ ဟု ဆိုသည်နှင့် တစ်ပြိုင်နက် ငါ၏မျက်စိသည် ပြန်မြင်၍ သူ့ကို ကြည့်လေ၏။ ");
INSERT INTO rki_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","သူက၊ ‘ငါရို့အဖိုးအဖီးတိ ကိုးကွယ်သော ဘုရားသခင်သည် မိမိ၏ အလိုတော်ကို သိစီခြင်းငှာ လည်းကောင်း၊ မိမိ၏ ဖြောင့်မတ်သော အခိုင်းအစီကို တွိ့မြင်စီခြင်းငှာ လည်းကောင်း၊ မိမိ၏ နှုတ်တော်မှ ထွက်သောအသံတော်ကို ကြားစီခြင်းငှာ လည်းကောင်း သင့်အား ရွီးချယ်တော်မူယာ။ ");
INSERT INTO rki_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","အကြောင်းမူကား သင်သည် မြင်သမျှ၊ ကြားသမျှတိကို လူအပေါင်းရို့အား ဟောပြောစီခြင်းငှာ ထိုအသျှင်၏ သက်သီခံဖြစ်လိမ့်မည်၏။ ");
INSERT INTO rki_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","အဂု၊ သင်သည် ဇာကြောင့် ဆိုင်းငံ့နိန်သနည်း။ သင်ထ၍ ဗတ္တိဇံကို ခံယူလော့။ သင်၏အပြစ်ကို ဆီးကြောစီခြင်းငှာ ဘုရားသခင်၌ ဆုတောင်းပတ္ထနာပြုလော့’ ဟု ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“ထို့နောက် ငါသည် ယေရုဆလင်မြို့သို့ ပြန်၍၊ ဗိမာန်တော်၌ ဆုတောင်းနိန်စဉ် ရူပါရုံ တစ်ခုကို မြင်ရ သည်မှာ၊ ");
INSERT INTO rki_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","သခင်ဘုရားက ‘သင်သည် ယေရုဆလင်မြို့မှ အလျင်အမြန် ထွက်လားလော့။ အကြောင်းမူကား ဤမြို့သားရို့သည် သင်သက်သီခံသော ငါ၏အကြောင်းကို လက်ခံကြမည် မဟုတ်’ ဟု မိန့်တော်မူ၏။ ");
INSERT INTO rki_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","ငါကလည်း ‘သခင်ဘုရား၊ အကျွန်သည် တရားဇရပ်များသို့ လားပြီး၊ ကိုယ်တော့်ကို ယုံကြည်သောသူများအား ဖမ်းဆီး၍ သတ်ပုတ်ကြောင်းကို သူရို့သည် ကောင်းစွာ သိကြပါ၏။ ");
INSERT INTO rki_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","ကိုယ်တော်၏ သက်သီခံဖြစ်သူ သတေဖန်ကိုလည်း အသီသတ်ခသောအခါ၊ အကျွန်ကိုယ်တိုင် ထိုအရပ်၌ ဟိပါ၏။ ထိုသူကို အသီသတ်သောလူရို့ကို ထောက်ခံပီးပြီး ထိုသူရို့၏ အဝတ်အစားများကို စောင့်ကြည့်နိန်ခပါ၏’ ဟု လျှောက်ဆို၏။ ");
INSERT INTO rki_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","ထိုအခါ၊ သခင်ဘုရားကလည်း၊ ‘လားလော့။ သင့်ကို တခြားလူမျိုးရို့အဖို့ ဝီးသောအရပ်သို့ ငါစီရွှတ်ယာ’ ဟု ငါ့ကို မိန့်တော်မူ၏။” ");
INSERT INTO rki_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","လူရို့သည် ထိုမျှတိုင်အောင် ပေါလု၏ စကားကို နားထောင်ပြီးနောက်၊ သူရို့က “ဤသူကို မြီကြီးထက်မှာ ထားဖို့မသင့်၊ အသက်ရှင်ဖို့ မတန်၊ အသီသတ်ပစ်လိုက်” ဟု အသံကုန်အောင် အော်ဟစ်ကြ၏။ ");
INSERT INTO rki_vpl VALUES ("AC22_23","074_22_23","ACT","22","2