﻿USE sofia;
DROP TABLE IF EXISTS sofia.rkbNT_vpl;
CREATE TABLE rkbNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES rkbNT_vpl WRITE;
INSERT INTO rkbNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Sesus Kiristu zotsa naro maha. Sesus Kiristu taparakta Abarão tsekokatsa niy. Idiri Dawi niwatihi taparakta Abarão tsekokatsa niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Tapara Abarão niy. Iwaze Isake ta Abarão tse. Sako ta Isake tse. Suda ta Sako tse itukytsa tuk. Sako hyrytsa niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Pereszo Sudata usta tse Sera zinarokota, sije Tama zinarokotatsa Tama niy. Iwaze Esrõ ta Peres tse niy. Arão ta Esrõ tse niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aminadabe ta Arão tse. Nasõ ta Aminadabe tse, Saramao ta Nasõ tse. ");
INSERT INTO rkbNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Boas ta Saramao tse, ije Hahabe zinarokotatsa. Obede ta Boas ije Hute zinarokotatsa. Sese ta Obede tse. ");
INSERT INTO rkbNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Takino Dawizo. Iwa taparakta Abarão tsekokatsa niaha. Iwaze Saromao ta Dawi tse ije tapara Urias oke niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Hoboã ta Saromao tse niy. Abias ta Hoboã tse. Asa ta Abias tse. ");
INSERT INTO rkbNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Sosapa ta Asa tse niy. Sorã ta Sosapa tse niy. Usias ta Sorã tse. ");
INSERT INTO rkbNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Sotã ta Usias tse niy. Akas ta Sotã tse niy. Esekias ta Akas tse niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Manases ta Esekias tse niy. Amo ta Manases tse, Sosias ta Amo tse niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Sekonias ta Sosias tse itukytsa tuk niy. Iwa niy. Kyze kytsa Sudeutsa Babironija bo nisioktyhyryknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Anaeze Sarateu ta Sekonia tse nipuruk. Kyze Sorababeu ta Sarateu tse niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Abiu ta Sorababeu tse. Aso ta Eriakĩ tse. ");
INSERT INTO rkbNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Sadoke ta Aso tse. Akĩ ta Sadoke tse. Eriude ta Akĩ tse niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ereasa ta Eriude tse. Matã ta Ereasa tse niy. Sako ta Matã tse. ");
INSERT INTO rkbNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Sako ta Sose zo atahi Maria barikta niyzik. Atatsa katsa Deus zipehata Sesus je niyzik. Sesus Deus zipehata mywata niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Iwa Sesus Kiristu zotsa naro. Taparakta Abarão tsekokatsa Dawi bo zinaropyknahaze iwa katorise sinaro niaha. Taparakta Dawi kyze Babironija ezektsa Sudeutsa meky botu nisioktyhyryknaha iwa katorise sinaro. Iwaze Sudeutsa Babironija ekze ziksizonaha kyze Sesus Kiristu purukwy bo iwa katorise sinaro. Iwa hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kyze Sesus Kiristu nipuruk. Tapara Maria soho Sose: — Byri puẽtsikze piakse — niy. Kyze ibo tatyhyrizikwyhabyitatu itabykyhy. Deus hyrikoso humo tabykyhy. Ana humo hi Sose batu ihyrinymyry. ");
INSERT INTO rkbNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Iwaze Sose: — O mektatu ja ibo natahyrizikwy nikara mytsaty ahabyita nikara. Ituk batu kasukza tsihik. Iwatatu atatsa humo batu kakyri — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Iwaze mytsaty nikara zuruze zitsotospykyryk bijoikpe iknykta Deus tsumuẽhĩtsa ibo inasik. Bijoikpe iknykta: — O apyby byihukta Sose! Maria barikta tsimozik! Ibykyhy mektatsebyita tu Deus tse. ");
INSERT INTO rkbNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mopurukze Sesus ty tsipinaro. Kytsa simysapybyitsa tu ziknakaranaha Deus ihumo mysiokzohik — niy. Inaro Sudeu harere tihi: — Atakta Deus bo aparakbaha mysioktyhyrykta — my. ");
INSERT INTO rkbNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Iwa bijoikpe iknykta niy, Deus harere humo. Tubabatu Deus sohokotsa inarokota Isaijas ziwatahaka, aba zuba atsatu mykara. ");
INSERT INTO rkbNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","— Atatsa ityrykduwyhybyitatsa tu itabykyhy, itse mopurukze Imanue ty pinaro mykara — niy. Inaro piwatawy Deus mypauk baze tu. Deus sohokotsa tubabatu ziwataha abazuba atsatu niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Sose inapupuze: Hyỹ niy. Iwatahi iaktaba haĩhaĩbyi niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ibo ka batu hyrizikwy — Byriktsa! Abykyhy mopurukze tu — niy. Iwa niy. Iwaze nipurukze Sose taskyrywy Sesus zinaroko niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Kyze Erodes Sudeja ezektsa pehatsa niyzikze Sesus nipuruk. Atakta Berẽhe eze tu nipuruk. Berẽhe Sudeja eze niy. Nipurukze kytsa sisukmotsa Serusarẽhe bo niukurunaha. Serusarẽhe niwatihi Sudeja eze niy. Sisukmotsa byrisoiktsa humo zinymyrykynaha, sihudikhudikwy nokponi haramwe sukewy taba sihudikhudikwytsa. ");
INSERT INTO rkbNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Serusarẽhe bo izumunahaze asahi: — Haneze sa ibykyhy nipuruk. Atahi Deus zipehata mywata Sudeutsa pehatsa mozik. Iwatawy byrisoik bo iktsa tsikaha, haramwe sukewy taba byrisoik bo iktsa tsikaha. Iwatsahi iapik tsikumukunaha. Ibo tsimytsaso tsihikiknaha. O ikia tsamysapyrẽta. Tsikpuruk ana humo hi mykurẽtsa tsimaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","— Ana soho Erodes ziwabyze paikpa mytsaty nikara. “Uta zuba kytsa pehakatsa mozik iky” — mytsaty nikara. Serusarẽhe ezektsa niwatihi paikpa mytsaty nikaranaha. Erodes pokso sipybyrẽtsa. ");
INSERT INTO rkbNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Iwaze kytsa sizubarẽtsa Erodes bo izumukunaha. Wastuhu taparaktsa Deus wahoro zubata eze ziknapamykysonahatsa, ustsa asaktsa Deus harere zinymyrynahatsa kino niwatihi iwa. Sizubarẽtsa inasikypykbanaha. Erodes tihi: — Haneze sa Kiristu Deus zipehata mopuruk atakta aparakbaha mypehatsa mozik. Hana eze sa mopuruk — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","— O Berẽhe Sudeja eze niaha. Anaeze Deus zipehata mopuruk. Tubabatu Deus sohokotsa botu ziwataha Deus tihi: ");
INSERT INTO rkbNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","— Berẽhe Sudeja eze tisapyrẽna. Anahudikhudikwy ezektsa batu sisikpyby. Berẽhe ezekta hi kytsa kabo mysioktyhyrykta, katyryktsa mysioktyhyryk — niy. — Iwa Deus sohokotsa tubabatu botu ziwatahaka — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Iwaze Erodes sisukmotsa bo huahua niy. Asazubaze atahi: — Nawa zuruze sa byrisoik bo iktsa tsikaha — niy. — O nawa zuruze byrisoik bo iktsa tsikaha — niaha. Yhỹ Erodes niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","— Iwaze ikiahatsa Berẽhe boktsa! tsimaha niy. Berẽhe bo makuskyry bo tynakozorẽnaha tsimaha. Atahi nataberiki. Ibo tsipomonaha zeka ja iwaze kabo tyziksizonaha. Uta kino niwatihi ibo mynakozore ipe: “Ikia tsamysapyrẽta” my — mybarapetu niy. Iwa sisukmotsa pe niy. Tapetu nikara — O makuskyry pibeze tsihikik — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Iwaze sisukmotsa iharere ziwabykynahaze niukurunaha. Niukurunahaze byrisoik bo iktsa niaha. Asta botu iktsa niaha tasapy eze tuze niaha. Ana bo hi iktsa niahaze sakurẽtsa. Byrisoik siharaze niukuru iwaze asa kino iapik niukurunaha. Maku skyry purukwy bo zumuze byrisoik iharapu bete pyk niy. Byrisoik natahyrikobaik niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Iwaze sisukmotsa wahoro bo nipupunaha. Anaeze maku skyry taje Maria tuk ahatsa bo izumunaha. Maku skyry bo iktsa niahaze iokeryk tahaekaratsa humo puruk puruk niaha. Asahi: — Ikia tsamysapyrẽta ahumo mykurẽtsa — niaha. Iwaze isapyha ty ibo nyny niaha. Isapyhaty ouro ty hi ibo nyny niaha. Tsipokzitsiarẽna ty. Iwaze jokmorẽnikia ty parakĩsẽ inarokoha tsonok mahaze tsokmorẽna anatyhi nyny niaha. Iwaze mira usaty jokmorẽnikia ty ibo nyny niaha iwa isapyha ty ibo nyny niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Iwaze unata nisitsotyspykyrykzoze bijoikpe iknykta Deus tsumuẽhĩtsa ispe niy: — Erodes bo ka ja erete erete byitaha! Ahahudikhudikwy bo mekta ske buruk tu tsiksinahaktsa! — niy. Yhỹ niaha. Iwaze tahahudikhudikwy bo ziksikinahaze mekta ske buruk tu niukurunaha. Nawa Deus tsumuẽhĩtsa ispe niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kyze Sose zuruze. Hinipỹ niyze zitsotospykyk bijoikpe iknykta Deus tsumuẽhĩtsa ipe niy: — Kyiktykta! Makuskyry ije tuk tysioktyhyk! Esito bo nokponi tuwaknaha. Anaeze tynapykyknaha. Erodes makuskyry myziberiki pibeze tsihikik iwatsahi ipokso Esito bo tuwaknaha! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Iwaze aidy kyik niy. Unata niukurunaha. Sose makuskyry ije ahatsa nisioktyhyryk Esito bo niwakiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Anaeze nitarenaha. Erodes nihyrikosokdaze zuba ziksizonaha. Tubabatu Deus sohokotsa ziwataha tihi: — Katse Esito ikny myziksizo — niy. Iwa Deus sohokotsa niy tubabatu ziwataha abazuba atsatu niy. Esito eze hudikspyk nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Kyze Erodes takyrikize. Sisukmotsa ibo zukbyitahi tsiokaniarẽta nikara: — O Sisukmotsa zikspihikbatakanaha. Kabo mybarapetu niaha — niy. Sihumo takyriki. Iwaze Erodes: — Aba makuskyry wahoro batu kahyrinymyry iwatahi makuskyrytsa sizubarẽtsa mysiba — mytsaty niy. Iwaze sodadutsa pe: — Berẽhe bo pãotaha: Nabo makuskyrytsa tysibanaha! Makuskyrytsa petok ziytyk tsehenahatsa, tysibabaiknaha! — niy. Hyỹ niaha. Petok ziytyk tseheze niy sisukmotsa harere humo. Nitsasonahaze nawa zuruze byrisoik izoize ana humo makuskyrytsa petok ziytyk tsehenahatsa nisiba tsihikik. Iwa hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Iwaze hawa ha ty Deus sohokotsa Seremias tubabatu ziwataha atsa tu niy. Atahi: ");
INSERT INTO rkbNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","— Hama Berẽhe hudikhudikwy baze tu iaksoho ty ziwaby. Wytykyryk nipuziukunaha sisukatsihikrẽza niapykyryknaha. Tapara kykyryk nipuziukunaha. Hakeu hyrytsa pokzi nipuziukunaha “Hana bo kahyrytsa. Kahyrytsa hana bo ja” nikaranaha. Tahahyrytsa pokzi sijeza ziknapuziukunaha — niy. Iwa Deus sohokotsa tubabatu ziwataha, atsatu niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Kyze Erodes niraze bijoikpe iknykta Deus tsumuẽhĩtsa Sose pe niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Atakta zitsotospykykze bijoikpe iknykta tihi ipe: — Kyikty! Isareu bo tsiksizo. Makuskyry ije tuk tysioktyhyk. Makuskyry zibezekyzykynahatsa botu niakbabanaha iwaze Isareu bo tsiksizo — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yhỹ niy. Sose Maria makuskyry ahatsa pe: — Tupaktsa! Isareu bo tsipiksizonaha — niy. Iwa Isareu bo ziksizonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Anabo zumunahaze Erodes tse, Arekeraus inarokota tazo inazapyzeky niy. Abaka atakta Sudeja ezektsa pehakatsa niy. Ana humo hi Sose zinymyryze ipokso tsipybyrẽta niyzik. Iwaze hinipỹ niyze zitsotospykzoze Deus ipe: — Sudeja bo ka pão pãobyity, Karireja bo tsiksikta! — bijoikpe iknykta niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Iwaze Karireja bo zumunaha. Nasare hudikhudikwy bo niaha. Anaeze niapykyryknaha. Deus sohokotsa tubabatu ziwatahanaha. — Atakta Nasare ezekta my — niaha. Tubabatu ziwatahanaha abazuba atsatu niy. Iwa Sesus Nasare eze niapykyryk ");
INSERT INTO rkbNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tubabatu Suão Batista zumu jerukbara bo niy. Sudeja jerukbara eze Deus harere myzubaha bo nitsasokoro. ");
INSERT INTO rkbNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ata tihi: — O kytsa ahamysapybyi tsimoewybaiknahaktsa! Deus zipehata humo tsipikymynahaktsa! Abaka kytsa Deus tyryktsa moziknaha hana wa puruze mozumu — nikara. ");
INSERT INTO rkbNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ata soho Deus sohokotsa tubabatu ziwataha, Isaijas inarokota isoho tihi: — “Aty ja jerukbara eze huahua my. ‘Pykyhytuty Deus zipehata ske bo tsimy. Iske buruhuwa tsiskezozekta!’ ” niy. Hawa kytsa piskezokonaha iwa Suão kytsa Deus zipehata humo pikymynaha, Suão tihi kytsa simysapybyitsa tysimoewynaha iwa pikymynaha Deus zipehata humo. — Iwa Isaijas niy tubabatu ziwataha abazuba atsatu Suão Batista nikara. ");
INSERT INTO rkbNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Atakta Suão kamero hwyk isuk niy. Irikpidiwy siraratsa hwyk niy. Masetsa zuba ziknasiboroko. Pete zuba zikzerukuk. Iwa. ");
INSERT INTO rkbNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Kyze Serusarẽhe ezektsa, Sudeja ezektsa, kytsa buburu Sorodão bazektsa iwa sizubarẽtsa ibo niukurunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Nisiharasusukuze asaktsa: — Taparaka mysapybyitsa tsikykaranaha. Abaka batu. Mekywa tu tsimoziknaha, mysapybara tahamoewybaiknaha — niaha. Iwa nisiharasusuze niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Kyze Pariseutsa asaktsa Moises harere humo sihyrinymyrẽtsa. Sadusitsa kino niwatihi Suão bo zumunaha. Suão sibo iktsa niyze atahi: — Ikiahatsa pyryhyk myrawy watsa. Katsaktsa pyryhyktsa batu mykparawy Deus niwatihi ahamysapybyritsa humo batu iakparawy. ");
INSERT INTO rkbNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ahape tu ahasopyk “O Suão mymyharasusu zeka ana humo hi Deus bazik takyri” tsimaha. Ahamysapybyitsa ty tsipimoewynaha zeka ana hi tsipiwatawykynahaktsa! Niwazuba Deus ba ziktakyri ahamysapyrẽtsa tsimoziknaha ana hi Deus tsihyrinymyrẽta — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Batu ahape tu ahasopyk: — O Abarão taparakta mydiri iwatahi Deus myhumo bazik takyri — tsimaha. — Anaharere Deus tuk batu imysapy my. Batu ahahyrinymyry Deus haraharetsa tuk Abarão tsekokatsa mysisukniki ana hi ihumo batu ihokdaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ikiahatsa hwi watsa. Deus maku wywyk tuk wata. Aba wywyk pizowy, hwitsa mysikakare. Iharatatsa buruk tu mysikakarehikare. Hwi iharatatsa sapybyita tu piweke. Izo bo pioktsokik. Iwa Deus ahabo my, ahamysapybyitsa tu tsimykaranaha isty moewy ahabyi zeka — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Kyze kytsa sizubarẽtsa pe: — Utakta paharasusu. Ahamysapybyitsa ty tsipimoewynahaze pihik ty paharasusu. Usta mozumu. Atahi tsimysapyrẽta. Tsimyhyrizikwyrẽta. Tsizikwyrẽta iwatahi ibo zuba tsimykaranaha. Atahi tsimysapyrẽta. Utakta batu. Iwatahi kasikpybyrẽta. Ipyrysuk pibokik zeka kasikpybyrẽta pitsumuẽhĩ naha humo kasikpybyrẽta. Atahi mysiharasusu, Deus hyrikoso ihumo ahabo mynasik. Deus hyrikoso izo waha, izo ykpyri nikorobaik. Deus hyrikoso mynasikze ahamysapybyitsa ty tsikykaranaha ihumo mysiokzohiknaha ahamysapyrẽtsa tsimoziknaha ahabo mynasikze ahatuk mynapykyryk. ");
INSERT INTO rkbNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Atakta Kiristu mozumuze dua ty wabe mykara tawata my. Ahostsa mysizyzyky. Kytsa simysapyrẽtsa ahostsa watsa tu maha. Ahostsa zuba mysizyzykynaha. Atuja bo mysidodokonaha sipesuktsa mysipaparakanaha, izo bo mysiwezokonaha. Iwaze kytsa batu simysapy ahostsa pesuktsa watsa maha. Izo bazikbe, nabo mysioktsoknaha. Iwa Kiristu kytsa metutu mysisapy simysapyrẽtsa Deus tuk mynapykyryk, simysapybyitsaktsa, izo bo mysioktsotsokiknaha — Suão niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Iwaze Sesus izumu. Karireja ikny niparak Sorodão buburu bo niy. Nabo Suão bo taharasusu tsihikik. Iwatahi: — O Suão tsikarasusu — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","— O batu. Ikia abazubata batu amyi iwatahi tsipikarasu zeka wasani my. Ikia tsamysapyrẽta tu amo sa kabo tsikzumu — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Sesus ipe niyzo: — Aba tsipikarasu zeka wasani my. Katsaktsa Deus nawahi mozihikik tsimaha ana hi tisapyrẽna, iwatahi tsikarasusu — niy. Yhỹ niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","17","Iwaze Suão Sesus ziharasusu. Pihik ikny inazoze atsoko bijoikpe sakpare niy. Deus hyrikoso ibo inasik. Amytudu wata ibo inasik inatsatsaka isukara bete inazo. Iaksoho bijoikpe ikny ziwaby: — Ikia hi katse babata. Ikia humo kamypokzitsiarẽta. Ikia humo ka kakurẽta hỹ — Iwa Deus Sesus pe niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Iwaze Deus hyrikoso Sesus jerukbara bo zioktyhyryk. Iwaze hyrikoso sapybara pehakatsa myzokwy Diabo inarokota ibo izumu. Sesus bo zumuze atahi Sesus Deus harere bo ka yhỹ byitykta nizihikik. ");
INSERT INTO rkbNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Sesus jerukbara eze niapykyryk, estuba byzoje zirahaze nawa kuarẽta zuruze niapykyryk. Anaeze hauk ahabyitatu zikzuruku iwatahi tsiaraparẽta nikara. ");
INSERT INTO rkbNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Iwaze Diabo ibo zumu Sesus tsiaraparẽta nikara ipe niy: — Ikia Deus tse babata zeka haraharetsa pe “Atsikara tuziktykta tsimy” — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Batu Sesus niy. Tubabatu taparaktsa Deus harere papeu humo ziwatahakanaha: — Mybarawy ezektsa disahawy humo zuba ba zikzurukunaha sidisahawy ty hauk mahaze sispitu zuba mykaranaha. Mybarawy ezektsa Deus harere bo hyỹ maha zeka sakurẽtsa moziknaha. Sakurẽtsa hỹ — niaha. Iwa taparaktsa ziwatahakanaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kyze Diabo Serusarẽhe bo Sesus zioktyhyryk. Anaeze Deus wahoro zubata hara bete ziriktohohikare. Jobonikia bo zioktyhyryk niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Niytahi ipe niy: — Ikia Deus tse babata zeka tykbo tukutyny. Tykbo tynapurukta! Taparaktsa Deus harere ziwatahakanaha: “Bijoikpe iknyktsa Deus tsumuẽhĩtsitsa ikia bo nasiakzo. Paperykynaha. Ikia humo simypokzitsiukrẽtsa. Haraharetsa bete tsimynaraha zeka tahatsyhyrypetsa ty paik paik maha. Iwatahi ba zik kahyrikywy” niaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","— Batu ba — Sesus niy. — Tubabatu taparaktsa Deus harere ziwatahakanahazo: “Deus ta ba ziakzobyrinaha Deus batu imyiwyky. Hawa ha tsimyzihikik Deus ty batu typeha” niaha. Iwa taparaktsa ziwatahakanaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kyze Diabo Sesus hara joboni tabo zioktyhyrykzo ipe niy: — Nanabyi bo iktsa tykta — niy. Atsoko mybarawy tsizubarẽna bo iktsa niy. Sityryktsa kino niwatihi natakaha. Iwaze Diabo tihi: — Uta anaty hi abo nynybaik my. Ikia hi sipehatsa tsimozik. Sityryktsa ikia pe abazubata maha. ");
INSERT INTO rkbNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Estuba zuba kaokeryk puruk puruk tsimy zeka kabo tsimytsaso zeka: “ikia tsamysapyrẽta aharere bo hyỹ my” tsimy. Ana tyhi tsimy zeka sityryktsa ty ikia bo nynybaik my — Diabo niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","— Batu ba. Nabo pãoty Satanas! — Sesus niy. — Tubabatu taparaktsa Deus harere papeu humo ziwatahakanaha hi: “Deus bo zuba tynapamykysokonaha ‘Ikia tsamysapyrẽta’ atabo hi ‘Ikia zuba tsimysapyrẽnikita’ tsimy, iharere bo zuba hyỹ tynakaranaha.” Deus watahaha, iwa taparaktsa ziwatahakanaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Iwaze Diabo Sesus zerekekspyk. Iwaze bijoikpe iknyktsa Deus tsumuẽhĩtsitsa Sesus humo simypokzitsiarẽtsa nikaranaha iwatsahi ipokzitsiwy tuk inasiknaha. Nawa de. ");
INSERT INTO rkbNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Kyze kytsa tihi: — O kytsa Suão Batista sakyriukrẽnikitsa hurukwy bo zioktyhyryknaha — niaha. Ana hi Sesus ziwabyze Karireja bo niukuru. Nasare bo ziksizo anaeze taypykyryk. ");
INSERT INTO rkbNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Anabo zumuze Nasare eze batu are aha, Kaparanaũ bo niy. Kaparanaũ Karireja pihikzotsabyri sak eze niapykyryk. Anaeze Napatari Seburõ niwatihi parakbaha niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Iwa niy. Iwatahi hawa haty Deus sohokotsa Isaijas tubabatu ziwataha atsatu niy. Isaijas tihi: ");
INSERT INTO rkbNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","16","— O Seburõ ezektsa, Napatari ezektsa myzubaha pihikzotsabyri ezektsa Karireja ezektsa, buburu Sorodão sak ezektsa asaktsa Sudeutsabyitsa iwa sizubarẽtsa tapara simysapybyitsa humo batu siaku. Kytsa watsa miwa eze pyik pyik nikaranaha asahi niwatihi sihyrinymyrybyitsa tu abaka Deus sibo zumu. Atahi situk mynapykyryk iwatsahi sakurẽtsa mykaranaha. Kytsa okoro hyritywaha moziknaha sihyrinymyrẽtsa — niy. Iwa Isaijas tubabatu ziwataha. Sesus Karireja boze anaharere atsatu niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Sesus Karireja zumuze kytsa nisihyrinymyryky. Tahi: — O kytsa ahamysapybara ty tsimoewynaha! Abaka Deus zipehata mozumu iwatsahi ityryktsa tsimoziknaha nawa zuruze botu izumu — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Kyze Sesus Karireja pihikzotsabyri sak taba zitabaka. Anaburuk ziknaukuruze Peduru, Ãdere ahatsa bo nikozo. Ãdere Peduru tsy. Tõhõryk pihik bo zioktsoktsokoknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Sesus ispe niy: — Uta kapik tynaunaha! Tapara piknutsa ziknasidokonaha. Abaka, uta katuk, mektsa tu tysitsumuẽhĩnaha. Kytsa bo Deus soho tsimytsasonaha. Ahaharere humo ka aparakbaha Deus harere bo hyỹ maha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Iwaze atsoko tahatõhõryk zerekbaiknaha. Sesus hapik niukurunaha, ituk pinymyrynaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ana puẽtsik Sesus zitabakaze mektsa botu nikozo. Tsiaku, Suão ahatsa bo niwatihi nikozozo. Suão Tsiaku tsy. Tsaraha eze tahazo tuk tahatõhõryk zizozikiknaha. Iwaze Sesus nisihuahuaka. ");
INSERT INTO rkbNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Iwaze atsoko tahazo zerekeknaha tsaraha niwatihi. Sesus hapik niukurunaha atahi nisihyrinymyryky. ");
INSERT INTO rkbNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Kyze nanabyitaba Karireja bo Sesus niukuru. Deus wahoro bo nikaraze kytsa nisihyrinymyryky. Deus wasania ty sizubarẽtsa bo nipamykysoko. Hawa kytsa Deus tyryktsa moziknaha nitsasoko. Kytsa simyitsapyritsa nisizororowy, ustsa batu siaku nisipunihikwyky. ");
INSERT INTO rkbNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Hawa haty nikara kytsa sizubarẽtsa ziwabynaha. Nanabyitaba Sirija bo niwatihi kytsa isoho ziwabykynaha. Iwatsahi simyitsapyritsa, asaktsa hyrikoso sapybara sibo pororo ziknakaranaha kuanare zikybyikitsa asaktsa sityrykmyitsa iwatsa sizubarẽtsa ibo nisioktyhyryknaha. Sizubarẽtsa nisizororowy. ");
INSERT INTO rkbNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Sizubarẽtsa Sesus hapik niukurunaha. Karireja ezektsa, Dekaporis ezektsa, Serusarẽhe ezektsa, Sudeja ezektsa, buburu Sorodão koiknyktsa iwatsa sizubarẽtsa Sesus hapik niukurunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Kyze Sesus myzubaha bo iktsa niyze hara bo nido. Anaeze tadyhy zinymyrykynahatsa ibo zumunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Iwaze nisihyrinymyryky ispe niy: ");
INSERT INTO rkbNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","— O sakurẽtsa asaktsa tahapetu sisopyk zeka “O Deus ikia soho humo batu myhyrinymyry” — maha. Sihyrinymyrybyitsa tuze Deus tyryktsa moziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","— O sakurẽtsa asaktsa sisukatsihikrẽtsa tahamysapybara humo iwaze Deus hi mysiakuwyky, sakurẽtsa moziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","— O sakurẽtsa asaktsa ba zik tahakyrinaha Deus harere bo zuba hyỹ mykaranaha, iwaze Deus tsizubarẽna ty sibo nyny mykara. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","— O sakurẽtsa asaktsa hawa Deus mozihikik zuba anahumo hi hyỹ mozihikiknaha, Deus mysitsumuẽhĩ iwaze simysapyrẽtsa moziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","— O sakurẽtsa asaktsa ustsa kytsa mysisapywykynaha hawaze Deus sibo hi pisapywyky. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","— O sakurẽtsa asaktsa Deus humo zuba mytsaty mykaranaha, hawa ihumo simypokzitsiukrẽtsa moziknaha, iwatsahi asahi zuba Deus tuk mynapykyknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","— O sakurẽtsa asaktsa kytsa naharape harereziuzonaha iwaze siharereziuwy moziknaha. Deus ispe: “kahyrytsa isopyk. Kawatsa maha” — my. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","— O sakurẽtsa asaktsa kytsa mysiapikiknahaze Deus harere bo hyỹ mykaranaha humo, asahi Deus tyryktsa moziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","— Ahakurẽtsa ustsa kytsa ahasoho mybarapetu mykaranahaze katuk kytsa humo iwaze ahakurẽtsa tsimaha. Pahamyijakaranahaze ahakurẽtsa tsimaha. Pahasukyrykynahaze kahumo ahakurẽtsaktsa. Nawaze ikiahatsa katuktsa humo tsimaha ahakurẽtsaktsa! ");
INSERT INTO rkbNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Tsahayzikrẽtsaktsa! Katuktsa babatsa tsimaha zeka ahanamy bijoikpe eze tu tsizubarẽna my. Pahapikiknaha zeka tsahayzikrẽtsa. Tubabatu kytsa Deus sohokotsa nisimyijakanaha atsawatu pahamyijakazonaha. Iwaze ahakurẽtsaktsa! — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Kyze Sesus tihi: — Ikiahatsa poro watsa tsimaha. Myzubaha mysitsumuẽhĩnaha. Katsaktsa poro mydisahawy tsimytsakykynahaze tisapyrẽna my. Iwa ikiahatsa kytsa tsimysitsumuẽhĩnahaze tisapyrẽna my. Poro mytsarakbyrize ba ziktsakykynaha. Poro wytyk kykywy humo batu sapy. Iwaze ape bo tututaha. Tahorobaik zuba. Ana bete kytsa mopaparibaiknaha. Ikiahatsa ahamysapybyitsa tu tsimykaranaha zeka ustsa kytsa batu isty tsumuẽhĩ poro iõrỹkbara wa tsimoziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","— Ikiahatsa rika watsa tsimaha. Kytsa sizubarẽtsa mysitsumuẽhĩnaha. Hudikhudikwy hara joboni nizuknikinahaze iwaze aparakbaha ihumo nikozonaha. Batu okpitsĩ zikaha ikiahatsa hudikhudikwy watsa tsimoziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Batu aty tohi rika inapok zeka kyze peryk pukezi zik my. Iwa zeka kytsa miwa eze nitarenaha. Rika inapokze jobo zuba zik my, iwaze wahoro ezektsa iktsa maha mypubyi rika humo. Ikiahatsa rika watsa hawa tisapyrẽna tsimahaktsa! ");
INSERT INTO rkbNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Anawata kytsa mysitsumuẽhĩnaha zeka kytsa ahabo iktsa mahaze tihi: “O Deus bijoikpe ezekta sizo. Atahi imysapyrẽnikita, katsa ihyrytsa bo iktsa tsimahaze ustsa kytsa mysitsumuẽhĩnaha iwatsahi sizo imysapyrẽnikita myhyrinymyrẽtsa” maha. Iwa hỹ, — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Kyze Sesus tihi: — Mybarawy bo ikzumuze kytsa mysihyrinymyry. Batu tyso “O Moises harere bo batu hỹ tsimaha, hawa Deus sohokotsitsa ziwatahakanaha batu hỹ tsimaha” ana ty kino batu tyso. Hawa Moises harere zahahyrinymyryky, hawa ha ty Deus sohokotsitsa ziwatahakanaha nitsasoba ana humo kino pahahyrinymyrybahani kytsa — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","— Ahaspiriktsokdabyihu ja! Moises harere ba zikokza. Mahani ihokzaha bijoikpe epykbyize. Mahani ihokzaha mybarawy kino epykbyize niwatihi iwatahaha ba zikokza. Hawa ty tubabatu ziwatahaka mahani ba zikokza. Tsizubarẽna Deus Moises bo nyny niy atsatu wasani my. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Iwatsahi aty tohi Deus harere bo batu hỹ my, iwaze ustsa pe: “Wastuhu Deus harere bo tsimaha byizeka wasani my” atakta Deus tuk my zeka tisikpybyrẽta. Atakta Deus harere bo pykyhytuty hyỹ my kyze ustsa pe “Deus harere bo tsizubarẽna hyỹ tsimykta!” atakta Deus tuk my zeka Deus tihi: “O ikia tsimysapyrẽta” Deus my. Atakta batu isikpyby. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ikiahatsa Deus tyryktsa tsimoziknaha zeka iharere bo pykyhytutaha hyỹ tsimaha. Hawa ha ty Pariseutsa nikaranaha. Hawa ha ty Moises harere humo zinymyrykynahatsa nikaranaha. “Katsaktsa Deus harere bo hyỹ tsimaha” mytsaty ahabyitsa mykaranaha. Ikiahatsa puẽtsik tsimykaranaha Deus harere bo zuba hyỹ tsimykaranaha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Kyze Sesus tihi: Tubabatu myzotsa kytsa nisihyrinymyrykynaha: — Harape ty beze beze byitaha! — niy. Aty myharape bezenaha zeka sinini my zeka wasani my. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Uta hi ahape: — Abaka aty tatukytsa humo takyrikize imysapybyitahi pimyiwyky atahi myharape bezenahaze tawata atakta sinini my zeka wasani my. Aty tatukytsa pe: “Asopyksapybyita” batu imysapy niwatihi, atakta Sudeutsa kytsaharerewabykytsitsa bo pioktyhyrykze pisininiwyky zeka wasani my. Aty tatukytsa pe: “Ityrykmyita” tsimy, atakta pimyiwyky niwatihi sinini ykarawy bo my. Wasani my. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Iwatahi Deus wahoro zubata bo tsimytsuk zeka myrara ty Deus bo nyny tsimyze iwaze mytsaty tsimy. “O katukta kahumo takyriki” apetu asopyk. Deus bo batu kasopyksapy tsimy. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Iwa zeka myraratsa anamy niwatihi tsierikik Deus sapy baze tu tsierikik. Batu anamy ty ibo nyny ziky. Taparaka atukta bo tsimy. Ikia tihi: “O katukta kahumo takyri kaharereziuwy tsimozikzokta! my” tsimy. Iwaze Deus okze wasani tsimy. Iwaze Deus wahoro zubata tsimyziksizoze Deus bo anamy ty nyny tsimy — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","— Aidy Deus bo tsimy iokzeka wasani tsimy. Aty zeka kytsaharerewabytsitsa bo paoktyhyryk zeka aidy atsatu ibo tsimynakokozo ske buruk tsimyzurukuze kytsaharerewabytsitsa bo taharapehanaha yhỹ tsimaha. Tsikukurunahaze tu wasani tsimaha. Ske buruk wasani byizeka maku atsipa humo paoktyhyryk, ikia sakyriukanikitsa hurukwy bo tsimytsuk. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Anaeze tsimytare. Aokyrysaro tsizubarẽna ty nyny tsimyzeka tsimyzoi. Iwatsahi aidy Deus bo tsimy — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Sesus tihi: — Tubabatu myzotsa kytsa nisihyrinymyryky: “Mektatsa ty ka okty okty byitaha” ");
INSERT INTO rkbNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Uta hi ahape: Abaka aty mekta oke bo iktsaziu myze tapetu isopyk “Uta atatsa piakse tsihikik” atakta mytsaty mykara pimyi anahumo hi Deus okze ka atakta atatsa botu ziakse. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Pykyhytutaha. Hawa iktsa tsimaha humo pykyhytutaha! Tsimysapybyikinaha zeka ahahyrizik ty hyrykokik ty. Ahyriziktsa humo ahahyirizikubyita tu tsimozik ana hi batu sapy, ikia sinini ykarawy bo zeka ana eze hi isapybarababa. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Atsawatu ahatsyhyrypetsa ty tsimaha. Atsyhyrype apanuryk taba asiba tsimyi zeka tsezykikta! Iwaze imysapybara humo pyk tsimy. Atsyhyrype ty estuba zuba tsimy zeka batu sapy, Deus sinini ykarawy bo papeha zeka ana bo hi batu isapybarababa. Pykyhytu hawa iktsa tsimy. Pykyhytu hawa tsimy tatsyhyrype tuk — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Kyze Sesus tihi: — Tubabatu myzotsa kytsa nisihyrinymyrykynaha: “Aty taoke perekek zeka papeu ty ibo nyny my. Papeu humo piwatahaka. ‘Utakta kaoke pe nabo pãoty my’. Iwaze usta atatsa piakse zeka wasani my” mytsaty ahabyitsa mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Uta hi ahape abaka aty ioke pe nabo pãoty Deus okzeka imysapybyita mykara. Tapara tatsa mekta tu ziakse zeka kyze tabarikta pe. Nabo pãoty my wasani my. Abaka aty tatsa bo tasukza zeka Deus okzeka imysapybyita mykara — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Kyze Sesus ispe niy: — Tubabatu myzotsa kytsa nisihyrinymyrykynaha siharere soho kino tsiwabynaha. Asaktsa: “Tsimytsaso zeka ‘Uta iwa tihi my’ atsatu tsimy. Hawa ha ty Deus okze ka tsimytsasoko atsatu tsimy” — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Utahi ahape: — Hawa tsimaha tsimytsasonahaze Deus naro ty ba zikaha. Deus sapy anaeze ityryktsa mysipehaka iwatsahi anawatu zekaha humo. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Hawa tsimaha tsimytsasonahaze mybarawy naro ty batu tyso, mybarawy kino Deus pyrytsa sapy waha my, iwatsahi awatutaha. Serusarẽhe kino Deus abazubata ihudikhudikwy iwatsahi awatutaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ahaharek humo kino batu tyso, aharadi estuba zika tsibarazarẽta zeka batu aharere humo nioktsirõrõ mozik. Iwatahi usta naro ty batu tyso, kytsa bo tsimysiwatawy tsihikze “Kaharere ty my” tsimy. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ikiahatsa tihi: “Niwatihi my” kyze atsatu tsimy. “Niwatihi batu yhỹ” kyze ana ty hi batu tsimy. Hawa wasani zuba tsimytsaso, ustsa naro ty batu tyso. Ustsa naro ty tsimytsasonaha zeka Satanas harere mozik — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Sesus: — Tubabatu myzotsa kytsa nisihyrinymyrykynaha: “Aty mekta hyrizik pibokik zeka, iwaze kytsa pihyrizikbokiknaha wasani my. Aty mekta tsapu pibokik zeka iwaze kytsa pitsapubokiknaha wasani my” iwa Moises kytsa nisihyrinymyryky. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Utahi ahape mykara, aty pahasapybyiki zeka ba zikahatsapusarenaha. Aty paokpyk zeka usta taba kino niwatihi nataba tuktuty tsimy. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Aty akpyzazawy pibok zeka iwaze ziakse asuk humo niwatihi ibo nynytaha. Wasani my. Ba zikakyri. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Sodadu ape my zeka “Kanamy ty kirometero bytykareze tu puhyryty” my. “Yhỹ anamy ty petok tykareze tu pesikik za” tsimy. Asapy baze tu perekek. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Aty ape my zeka “Kabo ja kabo ja” my zeka ibo nyny tsimy. Aty ape. “Anamy ty kabo nynyre tsimy bykyze ity wabehyrykzo” my. Yhỹ tsimy, kanamy ty nynyrezo tsimy — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Kyze Sesus tihi: — Tubabatu myzotsa kytsa nisihyrinymyrykynaha: “Ahaututsa pauktsitsa humo tysipokzitsikinahaktsa kytsa! Asaktsa ahasukyrytsitsa mysisapybyikinaha” niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Uta hi ahape: Ahasukyrytsitsa niwatihi tysipokzitsikinahaktsa kytsa! Asaktsa pahamyijakanaha sitsyhyryze Deus bo tsimypamykysokonahaze tihi: “O Deus myzo mysukyrytsitsa bo tysisapywykta” tsimaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Iwa tsimaha zeka ahazo wata astatu tsimaha. Ihyrytsa tsimoziknaha. Atahi haramwe nizukni. Haramwe aparakbaha bo naharamweke, kytsa simysapyrẽtsa kytsa simysapybyitsa bo kino niwatihi naharamweke. Deus hyritsik myziwõkõ simysapyrẽtsa bo simysapybyitsa bo kino niwatihi aparakbaha bo pisapywyky. Ikiahatsa tihiktsa! ");
INSERT INTO rkbNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ahasukyrytsitsa bo tsipisapywykynaha. Ikiahatsa ahaututsa pauktsitsa bo zuba tsipisapywykynaha zeka ustsa kytsa bo batu Deus mytsaty “kaokzeka ahamysapybyitsa tu tsimykaranaha” my. Asaktsa simysapybyitsa tu atsatu mykaranaha. Siotutsa pauktsitsa myharape pokzitsikinaha. Ikiahatsa batu ahamysapy siwatsa zuba tsimaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ikiahatsa ahaututsa pauktsitsa zuba awahoro bo mozumunahaze “O paku pakutynaha! Kawahoro eze ahawanu ty haĩtaha. Mydisahawy ty hauk tsimy” tsimaha. Iwa tsimaha zeka ahazikeditsa bo zuba ustsa kytsa ba ziksipokzitsi Deus okze ka sispirikpobyitsa watsa, asaktsa atsatu maha. ");
INSERT INTO rkbNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ikiahatsa mekywatsa tu tsimoziknaha. Abazubatsa humo ahamypokzitsiukoktsa! Deus ahazo wata astatu kytsa nasipokzitsiki hỹ — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Kyze Sesus tihi: — Wabyziutaha kytsa! Hawa tsimyzurukunaha kytsa mysitsumuẽhĩnaha Deus humo ahaspirikporẽtsa. Ata zuba tsakurẽta ana hi tsimyzihikiknaha iwatsahi kytsa mysitsumuẽhĩnaha zeka kytsa bo zuba batu tsimaha. Ahasoho kytsa motsasonaha zeka “O asaktsa wasani” maha. Kytsa pahasapywyky ana hi tsimyzihikiknaha. Ana kino Deus okze batu imysapy my. Iwa ahasopyk zeka bijoikpe eze batu ahahuakak ahazo batu ahabo nyny my. ");
INSERT INTO rkbNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Iwatsahi inamybyita tsipitsumuẽhĩze batu tyso “O kytsa hawa ty mykara iktsa tsimahaktsa!” tsimy. Iwa ahasopyk zeka zispihikbatakanahatsa watsa tsimaha. Asahi Deus wahoro eze motsasokonaha. “Mybo iktsataha! ske buruk kino niwatihi motsasokonaha mybo iktsa tsimaha” mykaranaha. Kytsa sisoho “O simysapyrẽtsa” maha. Deus ja. Deus sisoho nawa batu tyso. Kytsa zuba sisoho motsasokonaha. Bijoikpe eze batu sihuakak, Deus tuk sihuakak hana bo ja. Bykyze Deus isapyrẽnikia ty batu sibo nyny my. ");
INSERT INTO rkbNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Iwaze inamybyikita tsipitsumuẽhĩze aharereziuwy bo batu tyso. Amy ty tsimy usta bo tsipitsumuẽhĩ ikia zuba tsinymyry. ");
INSERT INTO rkbNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Iwa ibo nyny tsimy zeka kytsa papa tu Deus zuba iktsa my. Atahi asoho: “Hawa ty tsimy wasani my. Ikia tsamysapyrẽta” my — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Kyze Sesus tihi: — Deus bo tsimypamykysonahaze siharawatahanahatsa watsa byitaha! Asaktsa Deus bo mopamykysonahaze Deus wahoro eze ziknariktohokonaha iwaze kytsa sibo iktsa mykaranaha. Ske myparawy eze niwatihi nabo kytsa sibo iktsa mykaranaha ana kino mozihikiknaha. Kytsa sisoho tihi: “O asaktsa simysapyrẽtsa” mykaranaha. Deus okzeka batu. Asaktsa bijoikpe eze tu batu sihuakak. Deus sapyhaty batu sibo nyny my. ");
INSERT INTO rkbNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ikiahatsa Deus bo tsimypamykysokonahaze ahaõtutsakarawy bo tsimaha. Hokbotaha. Iwaze Deus tuk tsimypamykysonaha. Atahi iktsa zikybyi tahi atatu my. Kyze ahazo pahawabyze amy ty tsizapykykynahaze atsatu ahabo nyny my. ");
INSERT INTO rkbNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","— Deus bo tsimypamykysokonahaze ahaharere tsizubarẽna batu tyso. Kytsa watsa asaktsa Deus humo sispirikpobyitsa asaktsa: “O katsaktsa tsimypamykysobanahaze Deus myhumo piwaby, katsa myharere atsatu tsimytsasoikiknahaze iwaze Deus myhumo piwabyky” mytsaty ahabyi mykaranaha. Siwatsabyitsa — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","— Iwa zeka batu ahasopyk. Ahazo ahasoho humo tsihyrinymyrẽta. Amy humo ahakubyri tsihyrinymyrẽta. Amy humo ahaku byri zeka tsizapykykynahaze botu inymyry. Tysapyky ahabyizetu ana humo tsihyrinymyrẽta — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Iwaze Deus bo tsimypamykysokonahaze tihi: — O Deus myzo bijoikpe ezekta tu my. Aparakbaha panynahaze “O atahi imysapyrẽnikita batu aty tohi asapyzekyhu” anatyhi tsimyzihikiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Aparakbaha myzubarẽtsa atyryktsa tsimoziknaha, sipehatsa tsimozik. Mybarawy ezektsa aharere bo hyỹ mahaktsa bijoikpe ezektsa atsumuẽhĩtsitsa watsa maha. Iwa tsimyzihikiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Mydisahawy humo tyzibyituhukutu mybo nyny tynakara anahi tsimyzihikiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Mysapybyitsa tsikykaranaha iwatsa tu tymyokzohik. Katsa niwatihi, asaktsa mybo simysapybyitsa nikaranaha iwatsa tu tsimyokzonaha niwatihi. ");
INSERT INTO rkbNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Satanas katsa mype Deus harere bo batu yhỹ tsimaha. Hawa mozumuze, tsihokdaharẽna tynamytsumuẽhĩkta. Myhumo tymypokzitsikikta! Iwaze Satanas hyrikoso sapybara pehatsa harere bo ka batu yhỹ tsimaha. Katsa ikia humo mypunihikrẽtsa tsimoziknaha. Iwa Deus bo tsimypamykysokonaha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","— Yhỹ ikiahatsa ustsa simysapybyitsa ty ahabo nikaranaha tysiokzohiknaha Deus ahazo niwatihi atahi ahamysapybyitsa ty tsikykaranaha pahaokzohik. ");
INSERT INTO rkbNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Niwazuba! Ikiahatsa ustsa kytsa simysapybyitsa ty ahabo nikaranaha tysiokzo byizeka Deus niwatihi atahi ahamysapybyitsa ty tsikykaranaha batu pahaokzo isopyk. Iwa — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Kyze Sesus tihi: — Deus pokzi hauk byizeka ustsa kytsa bo tysoso byitaha! Ahaok ahasuka tsihikikbyihu ja myziharawataharanaha ziky watsa asahi haukbyize izohyrizikoro ty tahahok bo tsuku tsuku sisopyk iwaze kytsa sisoho: “O asaktsa simysapyrẽtsa humo ka Deus pokzi batu hauk maha” mytsaty ahabyi maha. Anaharere mozihikiknaha iwaze kytsa sisoho “simysapyrẽtsa” maha. Deus ja. Deus sisoho ty batu tyso, kytsa zuba sisoho maha. Bijoikpe eze batu sihuakak. Deus tuk sihuak hana bo ja. ");
INSERT INTO rkbNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ikiahatsa Deus pokzi batu hauk tsimaha zeka hokpiktaha! Ahaharadi tsiziurẽna mozik jokmorẽnikia ty ahaharek bo tsuku tsuku tahaktsa! ");
INSERT INTO rkbNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Iwaze ustsa kytsa batu sihyrinymyry ikiahatsa batu hauk tsimaha zeka ana humo batu sihyrinymyry. Deus zuba ahasoho zinymyry. Hawa ty tsimahaze kytsa papatu tsimaha zeka Deus ahabo iktsa my atahi isapyrẽnikia ty ahabo nyny my — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Kyze Sesus nipamykysokozo: — Ahanamy tsizubarẽna ty zozozo byitaha! Ahanamy tsizubarẽna zeka wazazatsa piokbanaha, ahanamy myworoba moktsirõrõ, sitsyhyryboarẽtsa ahawahoro bo mynapupunahaze ahanamy pebykbanaha iwa ahanamy tsizubarẽna soho. ");
INSERT INTO rkbNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Hawa ha Deus mozihikik ana hi atsa tu tatsihikik iwaze Deus namy ahatsyhyryze bijoikpe bo myzizozoko! Ahamysapyrẽtsa tsimoziknahaze Deus tisapyrẽna ty ahabo nyny my, bijoikpe eze pizozoko, iwa ahanamy Deus baze mopykyryk. Anaeze ahanamy ba ziksapybyri, wazazatsa ba zioknaha, ahanamy ba zikwõrõ, sitsyhyryboarẽtsa ba zebyknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ahanamy Deus baze bijoikpe eze tu zeka, iwaze ikiahatsa Deus soho mytsaty tsimykaranaha — niy. Iwa hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Kyze Sesus tihi: — Ahyriziktsa rika watsa ahanamy bo iktsa tsimaha. Ahyriziktsa sisapyrẽtsa zeka amy ty tisapyrẽna sihyrinymyrẽtsa. Hawa mytsaty tsimaha na wata niwatihi. Amo tisapyrẽna bo mytsaty tsimaha zeka ahakurẽtsa tsimoziknaha. Ahahyrinymyrẽtsa. Ahanamy bo mytsaty mytsaty byitaha. Amy ty tisapyrẽna tsimyzihikiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ahahyriziktsa sapy byizeka ikiahatsa miwa eze tu tsimypykyknaha. Batu iktsa ziky miwa zuba. Hawa mytsaty tsimaha na wata niwatihi. Ahanamy bo zuba mytsaty tsimaha zeka amy ty tisapyrẽna batu tsimyzihikiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Kyze Sesus tihi: — Ikia ispehatsa petoktsa bo batu tarabaja zikaha. Iwaze petoktsa hyriziktsokzawy tsimy zeka estuba harere bo hyỹ tsimy. Usta bo batu, tsikaeni zuba akparawy. Ikia tihi: “O estuba maku kakparawy. Usta batu, tsikaeni zuba kakparawy” tsimy. Ikiahatsa niwatihi. Ikiahatsa Deus harere bo hyỹ tsimaha zeka, okyrysaro bo tsikaeni zuba ahakparawy. Ikiahatsa okyrysaro ahakparawy zeka, Deus harere bo batu yhỹ tsimaha. Okyrysaro humo tsimyzihikiknahatsa Deus harere bo batu yhỹ tsimaha. Ahanamy tsikaeni zuba ahakparawy iwaze Deus zuba ahakparawy hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","— Iwaze ahanamy bo mytsaty mytsaty byitaha! Iwa paikpa mytsaty tsimykaranaha. “O amy ty sa tsimymydisahanaha ba zikaha. Amy ty sa mysuk ty korobyk tsimaha” ba zikaha. Ahadisahawy ty tsimykaranahaze wasani. Ahasukok ty tsimykaranahaze wasani niwatihi. Ikiahatsa hi iwatsa tu tsimykzonaha Deus baze mywahi tsimynapykyryknaha zeka mysapyrẽnikia niy. Niwazuba atahi ahadisahawy ty, ahapowy ty, ahasuk ty iwa ahabo nyny my hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Piyktsa bo iktsataha! Asaktsa batu sitsohoko, ba ziksipariknaha, Wahoro eze sidisahawy batu izozowyky. Piyktsa batu sipokzitsi Deus sihumo tsimypokzitsiarẽta sidisahawy ty sibo nyny my. Ikiahatsa ja. Deus ahahumo tsimypokzitsiukrẽta iwatahi ahadisahawy ty nyny mykara hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Mytsatyziu tsimaha zeka ja usta puruze nahyrizikpo. Batu ba. Mytsaty tsimykaranaha zeka ja ba zik kara. Iwatsahi ikiahatsa tsikaeni zuba zikaha zeka, amy skaraba disahawy humo mytsaty tsimykaranaha. Amy skaraba asuk humo mytsaty tsimykaranaha — Sesus nikara. ");
INSERT INTO rkbNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Sesus tihi: — Isazik bo iktsataha! Isazik amytsĩ eze tu taypyk zuba. Isazik mazori ty ka pyryryk pyryryk byitaha. Sisuk ba zikwowo. Tisapyrẽna mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Tubabatu Saromao pehatsa tsinamyrẽta. Inamy tsiziuwyrẽna. Tasuk tisapyrẽna korobyk ziknakara. Nanabyi isazik ka abazuba tsiziurẽna. Saramao suk ka jokboha ziu. ");
INSERT INTO rkbNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nawaze Deus isazik humo tsimypokzitsiukrẽta. Jaba okyrysaro ispitu wahatu byri hu hana bo ja. Nepyk. Izo bo mokorobaik. Ikiahatsa ja. Deus ahahumo tsimypokzitsiukrẽta hỹ. Iwatahi Deus ahasuk ty nyny mykara. Amy skaraba Deus humo ahaspirikpo tsikaeni zuba! — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","— Iwatsahi mytsaty mytsaty byitaha. Batu tyso: “Amy ty sa tsimymydisahanaha. Amy ty sa tsipikukunaha. Amy ty mysuk ty korobyk tsimaha.” Iwa mytsaty mytsaty byitaha! ");
INSERT INTO rkbNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kytsa Deus humo batu sispirikpo iwaze mytsaty nikaranaha. Ikiahatsa batu. Deus ahazo hi tsihyrinymyrẽta. Atahi ahadisahawy ty ahabo nyny my. Ahasuk humo kino niwatihi ahabo nyny mykara. ");
INSERT INTO rkbNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Katuktsa Deus tyryktsa soho sibo hi mytsaty tsimykaranaha. Hawa Deus harere bo hyỹ tsimaha. Hawa kytsa tsimysitsumuẽhĩnaha. Iwa mytsaty tsimykaranaha zeka Deus ahanamy ty nyny mykara. ");
INSERT INTO rkbNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Iwatsahi byiri ka mytsaty mytsaty byitaha! Aba zuba mytsaty tsimaha. Abaka amy ty tsihokdaharẽna tsimaha zeka Deus pahatsumuẽhĩ. Amy ty tsihokdaharẽna byiri ka mytsaty mytsaty byitaha. Aba zuba ahaspitu tsimaha. Byriri ja. Byri mozumu zeka kyze hawa tsimaha zeka mytsaty tsimaha. Deus ahahumo tsimypokzitsiukrẽta, tahi pahatsumuẽhĩ — Sesus niy. Iwa zinymyrynahatsa pe niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Sesus tuk zinymyrykynahatsa bo nipamykysokozo: — Kyze ustsa kytsa soho ty batu tyso “O atakta batu imysapy” ba zikaha. Iwa batu tyso. Kyze Deus asoho ty batu tyso. “Atakta batu imysapy” my. ");
INSERT INTO rkbNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Hawa ustsa kytsa soho ty tsimytsasoko atsawatu Deus asoho motsaso. Hawa ustsa kytsa soho bo mytsaty tsimy iwa Deus asoho bo mytsaty my. ");
INSERT INTO rkbNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ahatukytsa simysapybyitsa tu mykaranaha zeka batu iktsa tsimy. Iktsa tsimy zeka maku wata atahi hwi piak tsibik bo iziky hyrizik eze iktsa my. Hwi puho tahyrizikok eze tuze batu zikozo. ");
INSERT INTO rkbNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Tsimytsaso zeka “O byri kaziky, uta ahyrizik oke bo humo hu my” tsimy. Anaharere batu isapy my. Hwi puho ahyrizik eze tuze batu iktsa ziky. Tapara hwi puho ahyrizik eze taty hyrybokty iwaze aziky hyrike bo hu ty. Atsawatuze “O utakta kamysapyrẽta” tsimykara. Ikia batu amysapy tsimy. ");
INSERT INTO rkbNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Taparaka ahamysapybyitsa tu tsimykaranahaze pyktahaktsa. Iwaze zuba ustsa kytsa tysitsumuẽhĩnaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","— Amy ty tisapyrẽna, anaharere Deus botu ahabo nipamykyso ana kino kytsa Deus humo batu sispirikpo batu tyso tsimy. Asaktsa sispirikpobyitsa tu tsikuparinitsa watsa maha. Mydisahawy tisapyrẽna ty batu tsikuparinitsa bo nyny tsimaha. Atsawatu amy ty tisapyrẽna Deus botu ahabo nipamykysoko kytsa Deus humo batu sispirikpo batu sibo tyso. Kyze amy ty tsipokzitsiarẽna atsawy wata pazaharezatsa bo batu nyny tsimy. Atsawy watsa ty nyny tsimy zeka mysiharatotonaha zuba, amy ty tisapyrẽna humo batu sihyrinymyry. Iwaze amy ty tisapyrẽna Deus ahabo nipamykysoko kytsa simysapybyitsa batu wabytokto zikaha iwatsahi sibo batu tyso. Asaktsa Deus wasania ty yhỹ byri nikaranaha iwaze tsimyserekek ustsa kytsa bo tsimaha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Sesus tihi: — Kyze batu ahape tu ahasopyk “Deus mybo piwaby ja, batu kahyrinymyry” Deus bo tsimyzapykynaha zeka Deus ahabo nyny my. Deus bo tsipiberikinaha zeka tsimozikahanaha. Hokbowy humo toto tsimaha zeka hokbowy ty zoksapare my. ");
INSERT INTO rkbNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Aty isapyrẽnikia ty myzapyky zeka Deus ibo nyny my. Aty Deus bo piberi zeka ibo natakaha. Aty Deus bo huahua my zeka Deus piwaby hokbowy zoksapare mynakara. ");
INSERT INTO rkbNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Aty ahatukze ikiahatsa izo zeka iwaze itse ipe my zeka: “O kazo atsikara ty kabokta!” my zeka ikia atse bo harahare ty ba ibo nyny ziky. ");
INSERT INTO rkbNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Itse ipe my zeka: “Kazo piknu ty kabokta!” my zeka ikia atse bo pyryhyk ty ba nyny ziky. ");
INSERT INTO rkbNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ikiahatsa ahamysapybyitsa tu tsimykaranaha zeka iwatsatu amy ty tisapyrẽna ty ahahyrytsa bo nyny tsimaha. Niwazuba! Azo hi bijoikpe eze tahi imysapyrẽnikita. Ibo hi tsimyzapykynaha zeka isapyrẽnikia ty zuba ahabo nyny mynakara. ");
INSERT INTO rkbNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","— Kyze amy tisapyrẽna ty ustsa kytsa bo niwatihi tahaktsa! Hawa tisapyrẽnikia ty ahabo tsimyzihikiknaha atsatu sisopyk tsimaha. Tsisapykynahaktsa! Ana soho Moises harere my. Deus sohokotsitsa kino niwatihi atsatu nitsasokonaha. Taharere hi Deus nitsasoko hỹ — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Nisihyrinymyrykyzo: — Kyze hokbowy jakebyita Deus bo mopupunaha! Aba Deus tuk tsimyzurukunaha zeka ske jakebyita tsibik wata buruk tu tsimykurunaha. Usta ske buruk sinini ykarawy bo, ata ske hi tsiakiarẽta, kytsa sizubarẽtsa ata ske buruk mokurunaha. Ata sketa batu ihokdaha iwatsahi sizubarẽtsa ataske buruk mokurunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Asaktsa Deus tuk mynapykyryknaha. Mekywatu siske. Ata ske buruk bijoikpe bo tsihokdaharẽna asaktsa ata bo mokurunaha Deus tuk tahawahi mynapykyknaha. Sakurẽtsa. Ata ske buruk kytsa batu sizuba mokurunaha, batu sizuba hokbowy wata paku maha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Sesus nipamykysokozo: — Pykyhytutaha! Kytsa ikiahatsa kaske buruk pão pão byitaha sisopyk iwaze asa tihi: “Katsaktsa Deus sohokotsa tsimaha” mybarapetu mykaranaha. Deus harere zimyikinaha. Ahabo mozumunahaze ahaharereziuwy watsa, batu ba asaktsa parinitsa watsa batu sisapy maha. Kaske buruk tsimykurunaha zeka batu siakparawy, kaharere bo hỹbyri tsimaha zeka anahi mozihikiknaha, iwatsahi pykyhytutaha! ");
INSERT INTO rkbNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Hawa simysapybyitsa tu mykaranaha humo tsipimytsatyhykynaha, “O isapy byizeka sispihikbatakanahatsa” tsimaha. Pisapybyinahaze simyspihikbatarẽtsa tsipinymyrynaha. Wihara batu tsarak taypykykze iktsa tsimaha zeka katsa hi: “Atahwi isapy byizeka” tsimaha. Hwi batu sapy byizeka ihara kino niwatihi batu itsãrãk. Tahwi ty umaha wata “duabohotsa” watsa batu ihara ty zizyzykyryknaha. Maku wasani mytsaty mynakara zeka tsimysapyrẽta mozik. Maku batu wasani mytsaty mynakara zeka imysapybyitatu mynakara. Hawa mytsaty tsimykaranaha ana tihi tsimykaranaha. Maku isapybyikita tu mykara ibo iktsa tsimahaze “O atakta batu wasani mytsaty mykara” myhyrinymyrẽtsa. ");
INSERT INTO rkbNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Hwi taypykyk zeka tisapyrẽna ihara kino tisapyrẽna hwi isapybyita tu taypykyk zeka ihara kino batu isapy maha. ");
INSERT INTO rkbNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Hwi tisapyrẽna taypykyk zeka ihara kino tisapyrẽna. Hwi isapybyita taypykyk zeka ihara kino batu isapy. ");
INSERT INTO rkbNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kytsa atahwi hi piwekenaha iwaze izo bo pioktsotsoknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Iwaze kytsa wihara watsa. Hawa mykaranaha humo sisoho ahahyrinymyrẽtsa. Iwatsahi asaktsa tihi: “Katsaktsa Deus sohokotsitsa tsimaha” mybarapetu nikaranaha, anatyhi ahahyrinymyrẽtsa. Hawa mykaranaha humo ahahyrinymyrẽtsa — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Nisihyrinymyrykyzo: — Kytsa kabo motsasokonaha zeka “O ikia kapehatsa” mytsaty ahabyi mykaranaha. Asahi hawa Deus mozihikik anahumo hi yhỹ hãbyri zeka asahi Deus sapy bo ba ziknapupunaha, Deus tyryktsa ba zikyziknaha. Asazuba Deus harere bo hyỹ mykaranaha, hawa Deus mozihikik anahumo zuba ma mykaranaha asa zuba Deus sapy bo mynapupunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Hana wa puruze Deus myzubaha pe my “Ikia tsamysapyrẽta” my. Usta pe “Ikia batu amysapy” my. Asaktsa hawa Deus zikzihikik naha humo batu yhỹ ziknakaranaha ipe: “O mypehatsa mysapyrẽtsa tsiknakaranaha wasania ty tsiktsasokonaha aharere ty kytsa bo tsiksihyrinymyrykynaha, anaro humo hyrikoso sapybara tsiksiksiwyhiknaha. Hawa kytsa zikaha bara ty katsa tsikykaranaha azikwy humo zuba. Iwatsahi atuk tsimynapykyryknaha” maha. ");
INSERT INTO rkbNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Iwaze Deus ispe my: “Ikiahatsaktsa batu kanyhy. Hana iknyktsa skaraba. Ahamysapybyitsa tsikykaranaha iwatsahi kasapy bo paku pakubyitaha! Nabo pãotaha” my — niy. Iwa mymyhyrinymyryky Sesus ziwatawy. ");
INSERT INTO rkbNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Iwaze Sesus tihi: — Aty skaraba kaharere ziwabytahi kaharere bo hyỹ nikara. Atakta maku wata zinymyrytatu haraharetsa bete tawahoro nizokniki. Tukuke bo iharakorowy sapy tsioke tsihyrizizirẽna bo zitsek. ");
INSERT INTO rkbNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Kyze zopoktsa mynabybyknahaze, hyritsik mynawõze. Pihik wytyk ikny mynapokze. Pihik mynapokze wahoro bo mozumuze batu ziknatsehepetok. Iwa maha zeka ba ziknazuru. Atakta kaharere bo hyỹ nikarata myhyrinymyrytsa wata my. ");
INSERT INTO rkbNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","— Aty skaraba kaharere ziwabytahi kaharere bo batu yhỹ ziky. Atakta maku wata ihyrinymyrybyitatu tawahoro nizukniki nimyra eze tu ziukuru. Jokboha zuba batu ioketsehezeze iwa tawahoro nizokniki. Tukuke bo tsikaeni zuba ziu. Iharakorowy sapy batu ioketsehezeze batu zihi bo tohi ahabyitatu. ");
INSERT INTO rkbNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Zopoktsa mynabybyknahaze, hyritsik nawõze. Pihik wytyk ikny inapokze. Pihik mynapokze wahoro bo mozumuze wahoro naktsehepetokyk. Mynakbi — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Sesus nisihyrinymyrybaze myzubaha sipybyrẽtsa. ");
INSERT INTO rkbNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Kytsa nisihyrinymyryze Sesus tihi: — Uta ahape hawa tsimaha — niy. Hawa ha ty Deus mozihikik naha humo tsihyrinymyrẽta. Sudeutsa sihyrinymyrykytsa tihi: — Amy ty taparaktsa nikaranaha ahape hawa ja mytsaty zuba tsimaha — niaha. Iwaze kytsa Sesus harere humo sipybyrẽtsa — O iharere wasani my — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Kyze Sesus hara jobonita ikny inasikze myzubaha iapik niukurunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Iwaze maku inakõrõrõbaikta Sesus bo zumu. Atakta Sesus okeryk taekaratsa humo puruk puruk niy. Sesus humo tispirikporẽta iwatahi puruk puruk niy. Ipe niy: — O ahyrinymynikita, hawa tsimyzeka tsipikzororowy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Kyze Sesus ihumo tsimypokzitsiarẽta ihumo paik niy. Ipe niy: — Uta pazororowy hỹ — Sesus niy. Atsoko siakõrõrõtsa nihokdanaha. Nizororo. ");
INSERT INTO rkbNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Iwaze Sesus zipeha: — Wabyziuty! Sosobyitykta! Ba aty tohi bo ziktsaso. Ikia ziknapamykysokota bo tsikawatawykta! Iwa taparakta Moises ziwataha papeu humo atsatu Deus bo nyny tsimy. Siraratsa ty Deus bo nyny tsimy. Iwatsahi kytsa bo nisiwatawyky tsikzororo — niy. Iwa Sesus inakõrõrõbaikta zizororowy. ");
INSERT INTO rkbNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Kyze Sesus Kaparanaũ bo zumuze sodadu Homa ibo niy. Atakta sẽ sodadutsa mynasipehaka. ");
INSERT INTO rkbNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Tatsumuẽhĩtsa zizororowy tsihikik iwaze nizapykyky: — O myhyrinymyrykytsa katsumuẽhĩtsa mohoeke. Imyiziubyita tu sinini mykara. Tsimyitsapyrẽta — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Sesus: — Utakta awahoro bo my. Pizororowy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","— O kamysapybyita tu mykara kawahoro bo paku pakubyity, kasikpybyrẽta Sudeubyitatu iwatahi ikia kabo paku pakubyi tsimy. O myhyrinymyrykytsa tytsasozubakta! Aharere humo estuba zuba tsimyzeka katsumuẽhĩtsa mozororo. ");
INSERT INTO rkbNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Uta kahyrinymyrẽta aharere soho humo uta kino niwatihi kapehatsa harere bo hyỹ kasopyk. Sodadutsa kaharere bo hyỹ sisopyk, mysipehaze: “Nabo pãotaha!” Pão atsoko motururuknaha. Ustsa pe: “Pany pãotaha!” atsoko mozumunaha hỹ. Katsumuẽhĩtsa pe: “Tihi tsimykta!” Hyỹ my — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Anaharere Sesus ziwabyze paikpa mytsaty nikara. Sizubarẽtsa pe tihi: — Wabytaha! Sudeutsa batu kahumo sispirikpo maha sodadutsa taparakta wata my. Atahi kahumo ispirikpota babata Sudeutsa batu — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ikiahatsa pe: — Nanabyitaba kytsa sizubarẽtsa kabo mozumunaha. Deus myikaha maha. Taparaktsa Abarão, Isake, Sako iwatsa situk modyhydyhykynaha Deus tuk asaktsa ityryktsa moziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Sudeutsa asaktsa sispirikpobyitsa tu batu Deus tyryktsa moziknaha. Sispirikpobyitsa tu miwa eze zuba mynapykyknaha nabo mysipaparahik. Deus mysipeha sinini ykarawy bo anaeze mopuziukunaha. Tahakyrikinaha tsahi tahatsaputsa dydydy mykaranaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kyze Sesus taparakta sodadutsa pe niy: — Awahoro bokta! Kahumo aspirikporẽta tu hawa ha tsimyzihikik atsatu my — niy. Iwaze babatu itsumuẽhĩtsa nizororo. ");
INSERT INTO rkbNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Kyze Sesus Peduru wahoro bo niy. Inatsukze tsaikbatatsa Peduru wapyry ihumuẽzumu ibo iktsa niy. Atatsa tawanu eze nihoekik. ");
INSERT INTO rkbNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Iwaze Sesus iwanu bo hamuba itsyhyrype humo paik niy. Itsyhyrype humo paik niyze nizororo. Ihumuẽzukbyitatsa tu idisahawy ty ibo nyny niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nubaze kytsa sizubarẽtsa ibo nisioktyhyryknaha. Asaktsa hyrikoso sapybara pororo ziknakaranaha sipiakmyitsa hyrikoso sapybara pokso. Iwaze Sesus hyrikoso sapybara nisipehahik. Ispe nabo pãotaha niy. Iharere pokso ziksihiknaha. Ustsa kytsa simyitsapyritsa Sesus bo nasioktyhyryknaha nisizororowybaik. ");
INSERT INTO rkbNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yhỹ, hawa Deus sohokotsa Isaijas tubabatu ziwataha Sesus atsatu nikara. Tubabatu Isaijas tihi: — Simyitsapyritsa mysizororowy. Myzubaha izikwy humo sakurẽtsa — niy. Iwa Isaijas Sesus soho tubabatu ziwataha, anahi Sesus nikara, iwatahi Isaijas harere wasani niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Kyze Sesus myzubaha tazahara niapykyryk. Iwatahi zinymyrynahatsa pe: — Koikny tsinaporenahaktsa kytsa! — niy. Yhỹ niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Kyze maku atakta Moises harere ziwatahaka Sesus bo zumu. Atahi: — O tynamyhyrinymyryta uta kino ikia tuk mykara. Ikia tuk paikpa mynakara atuk mynapykyryk — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Sesus ipe niy: — Tsoromamatsaktsa tahahoke eze mynapykyknaha. Piyktsa kino niwatihi tahasuk eze tu mynapykyknaha. Utakta Deus zikpehata ahawata ikyzik batu kawanu sapyky. Batu haneze tohi zikuru my — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Kyze usta zinymyrykyta ipe: — Byikta tapara kazo bo piksizo. Tapara kazo myziyktykare — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Sesus tihi: — Nihyrikosokdanahatsa arekektaha. Mohyrikosokdaze ituk kytsa piytyknaha. Ikia kino Deus wasania ty ityryktsa soho tytsasoko — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Iwaze tsaraha bo takorohyk. Zinymyrykynahatsa ituk kokokorohyk niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Atsoko zopoktsa nabybyknaha. Hyritsik inawõkõ. Pihik ihiridawy wa niukuru. Pihik ty asiba tsaraha inaharek. Asiba nitaboknaha. Sesus kino tsapukteze zurubaka. ");
INSERT INTO rkbNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Iwatsahi zituzutuzukunaha ity zipopowynahaze ipe niaha: — O mypehatsa batu iktsa ziky! Tsimymybabakanaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","— Amy pokso ahapybyrẽtsa. “Sesus batu imypokzitsiu” tsimaha — niy. Kyik niy: — O zopoktsa akso byitaha! Niwazuba, pihik pykty! — niy. Zopoktsa atsoko paỹ niaha. Pihik atsoko nitsikyrituhudi byri. Jakara zikbohota bo mahani itsikpepepe zuba. ");
INSERT INTO rkbNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kytsa sipybyrẽtsa tahapetu sisopyk: — Atakta Sesus aty skaraba. Zopoktsa pihik aha iharere humo ziwabynaha pyk niaha. Aty skaraba Sesus — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Kyze amykta taba bo byu niaha. Kadara eze tu. Tsaraha ty byuzo niyze makutsa petoktsa Sesus bo izumunaha. Hyrikoso sapybara sibo pororo ziknakaranaha. Sihumo sakyriukrẽtsa ziknakaranaha kytsa sipokso sipauktaba ba harakmo zikaha. Mytyk sisapy niaha anaeze hudik ziknakaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Sesus okeryk ziktoriktonaha. Atsoko kakaik niaha: — Amy skaraba Sesus, ikia Deus tse. Amy skaraba mybo tsikzumu. Aba sinini ykarawy bo ja tsimymypeha. Bykyzehu zuba tsimaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Na bytykarezetu pazaharezatsa sizubarẽtsa hara sukpetara humo tahadisahakanaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Kyze hyrikoso sapybara Sesus bo nizapykykynaha: — O sinini ykarawy bo myty pehabyity, tsimysiksiwyhik zeka pazaharezatsa bo tsimymypeha — hyrikoso sapybara niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Sesus ispe: — Nabo pãotaha. Pazaharezatsa bo za — niy. Kyze hyrikoso sapybara kytsa ekze ziponahaze nitururuknaha. Pazaharezatsa bo nipupunahaze pazaharezatsa iharatsupetoho bo inatururukiknaha. Pihik bo niharazukzukbaiknaha. Niakbabaiknaha. Hyrikoso sapybara kino tahawahi nihokdanaha. Batu sibo zukzo niaha. De. ");
INSERT INTO rkbNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Iwaze pazaharezatsa perytsitsa iktsa niahaze hi sihudikhudikwy bo nitururukiknaha. Kytsa bo nipamykysonaha. Hawa Sesus hyrikoso sapybara ty nisisiksiwyhik anatyhi nipamykysokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kyze anahudikhudikwy ezektsa sizubarẽtsa Sesus zihobyknaha. Inakozorenaha. Ibo zumukunahaze asa tihi: — O tsiksizokta! katsa mybaze ba ziktare. Tsimyparakta! — niaha. Iwaze niparak. ");
INSERT INTO rkbNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Kyze Sesus tsaraha bo takorohykzo tahudikhudikwy bo koikny nipozo. Kaparanaũ tahudikhudikwy bo zinymyrykynahatsa tuk zumunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Kyze kytsa ityrykniakbata ibo zebykyryknaha. Ityrykniakbata pãozikybyita tawanu bete niy, ituktsa iwanuze zebykyryknaha. Sesus siharereziuwytsa pe: — O kytsa “Sesus myhumo tsimypokzitsiukrẽta” tsimaha, ikiahatsa humo kakurẽta — niy. Iwaze Sesus ityryk niakbata pe: — O katse tsipunihikrẽtakta! Amysapybyri tsikykara Deus pe: “batu yhỹ” tsimy. Iwahatu paokzohik. Amysapybara ty kahumo niokzohik — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Kyze Moises harere zihyrinymyrykynahatsa anatyhi ziwabykynahaze tahapetu sisopyk: — O Deus soho tsiharerewabymybarẽta. Amo skaraba nitsasoko. Deus zuba pahaokzohik. Atahi zuba “kahumo niokzohik” mykara — mytsaty nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Kytsa anawahi mytsaty nikaranaha ana kino Sesus tsihyrinymyrẽta iwaze ispe: — O hawa tuza kytsa. Amy humo sa mytsaty nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","“Iwaha tu pahaokzohik” my zeka tsihokdaharẽna. “Kyiktykta” my zeka, ana kino niwatihi tsihokdaharẽna. ");
INSERT INTO rkbNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Iwatu utakta Deus zikpehata wyzik niwatihi my — niy. Ityrykniakbata pe: — O papeha kyiktykta! Awanu ty pohyrykty! Tsiksikta! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Iwaze atsoko itarikto tawanu ty kokpuhyryk niy. Tawahoro bo ziksiki. ");
INSERT INTO rkbNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kytsa ana humo nipybybaiknaha. Deus bo mosakibazikiknaha: — O ikia humo ka mykurẽtsa. Ikia maku bo zikwy nyny tsimy iwaze anawa niy. Ikia hi ityrykniakbata nipazyryk tsizororowy. Iwa ty ka batu tyny — niaha. Iwa hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Iwaze Sesus niparak. Niukuruze ske buruk maku Mateus inarokota bo iktsa niy. Atakta siokyrysaro bykwy sapy baze ziknadyhyky anaeze tarabaja ziknakara. Sesus ipe niy: — Panykta katuk! — niy. Hyỹ niy. Kyikyk niy. Sesus hapik niukuru ituk zinymyryky. ");
INSERT INTO rkbNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Kyze Sesus tuk zinymyrykynahatsa tuk Mateus wahoro bo niaha. Anaeze tadisahakanaha. Kytsa siokyrysaro bykyktsitsa sizubarẽtsa ustsaktsa simysapybyitsa kytsa simymyijanikitsa iwa Sesus tuk tahadisahakanaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Pariseutsa asaktsa Moises harere soho sihyrinymyrẽtsa ana bo iktsa niahaze Sesus tuk zinymyrykynahatsa pe: — Amo skaraba ahahyrinymyrykytsa nawa kytsa tuk maha. Siokyrysaro byktsitsa tuk tumy pikukunaha, simysapybyitsa tuk tahadisahakanaha, batu wasani my — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Siharere Sesus ziwabyze ispe niy: — Simysapybyitsa simyitsapyrẽtsa hyrity watsa niy. Sakurẽtsaktsa myzororowytsa bo ba zikumunaha. Simyitsapyrẽtsa zuba myzororowytsa bo pomonaha. Kytsa simysapybyitsa tu simysapyrẽtsa moziknaha iwatahi ikzumu kahumo simysapybyitsa simysapyrẽtsa moziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Iwatahi simysapyrẽnikitsa bo batu zuk. Utakta mybarawy bo iknasik simysapybyitsa bo, asahi tahamysapybara pimoewynaha — niy. Deus sohokotsa tubabatu ziwataha — Tyharape pokzi tsikinahaktsa kytsa! Siraratsa ty kabo nyny tsimaha zeka tsikaeni zuba mozihikik, tsipaharapepokzi tsikinaha zeka ana hi mozihikik hỹ — Deus niy. — Iwa Deus sohokotsa tubabatu ziwataha abazuba atsatu my. Ana harere humo mytsatyziutaha! — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Iwaze Suão Batista zinymyrykynahatsa Sesus bo zumunaha. Ipe: — Katsaktsa hauk habyitsa tu tsizurukunaha, Pariseutsa niwatihi hauk habyitsa ziknakaranaha. Iwaze Deus bo tsimynapamykysonaha. Atuk zinymyrykynahatsa tahadisahakanaha. Amy skaraba atuk zinymyrykynahatsa batu mywatu hauk habyitsa — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Sesus ispe niy: — Maku tasukzaze tatukytsa tuk tamyikaha tumy pikukunaha. Isukzata situk tu sydikrẽtsa maha. Kyze isukzata moparakze ituk kytsa batu siaku iwatsahi hauk ahabyitsa maha. Uta bijoikpe bozoze katuk zinymyrykynahatsa batu siaku iwatsahi haukabyitsa maha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Hawa kytsa Deus tyryktsa moziknaha Sesus nisihyrinymyryky. Ata tihi: — Batu aty tohi panu ezytyk izyzykyha humo isuk ibyky humo ba zikzutsunaha. Iwa my zeka isuk mysykbaik. Isuk ibykta tu panu ezytyk tatu mymyibaik. ");
INSERT INTO rkbNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","— Batu aty tohi duabohotsa tsik ezytyk ty ba sirara hwyk ibykta bo ba zisusu my. Iwa myzeka duabohotsa tsik ezytyk mynapytoze ibykta tsasuk mytok niy. Mopokobaik. Isuk ibykta pimyibaik iwaze duabohotsa tsik mypukuba. Duabohotsa tsik ezytyk hi tsasuk ezytyk eze tu tsipisusuku. Iwaze duabohotsa tsik isuk kino tisapyrẽna maha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Kyze Sesus sibo nipamykysokoze maku ibo zumu. Sairu inarokota, atakta Sudeu wahoro taparaktsa. Sesus bo zumu iokeryk taekaratsa humo puruk puruk niy. Sesus humo tispirikporẽta iwatahi puruk puruk niy. Ipe niy: — Pany Sesus! Tupakta kawahoro bo, kaste pomozaka. Aidytykta. Ikia atsyhyrype ty ihumo paik tsimy zeka mozororo — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yhỹ niy. Iwaze Sesus iapik niukuru. Zinymyrykynahatsa niwatihi situk niukurunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Kyze wytyk iapik niukuru. Tsimyitsapyrẽtatsa. Ispu byri ahabyitatsa. Batu pyk ziky. Dose ziytyk tseheze imyitsapyrẽtatsa ziknapykyk. Atatsa ibo izumu. ");
INSERT INTO rkbNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Atatsa tape tu nikara — O ikza isuk humo paik my zeka mozororo — mytsaty nikara. Iwaze ipapatu isuk tsihara humo paik niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Sesus tasukpe bo atatsa bo iktsa niy. Ipe niy: — Kaste askyrypunihikoktsa! “Sesus pikzororo” tsiky. Ikia kahumo tsikspirikpoze azororowy — niy. Atsoko ispu inapyk. Nizororo. ");
INSERT INTO rkbNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kyze Sesus taparakta wahoro bo paku niy. Anaeze kytsa sizubarẽtsa nipuziukunaha. Nipukarakanaha. Berekzetsa ty nipamykyzunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Sibo iktsa niyze ispe: — Ahasuka byitaha! Nabo pãotaha! Tatsa ste mahani isukmuza byitatsa tu purubaka tu — niy. Anaharere humo ziwabynahatsa hazi nikaranaha. Zimyijakanaha hazi nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kytsa sizubarẽtsa ape bo zipoiknahaze Sesus taparaktsa ste wanusapy bo zumu. Itsyhyrype humo paik niy. Iwaze kyik niy. Nahyrizikpo. ");
INSERT INTO rkbNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Kytsa ana soho nipamykysokonaha. Hawa Sesus niy kytsa nanabyitaba nipamykysokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Iwaze Sesus niparak. Niukuruze petoktsa sihyrizikubyritsa iapik niukurunaha. Asaktsa zihuahuakanaha: — O Deus zipehata, Dawi tsekokatsa tymypokzitsikta! Tymytsumuẽhĩkta! — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Sesus iwahoro bo inatsukze sihyrizikubyitsa ibo zumunaha ispe niy: — Ahahyriziktsa mysizororowyzik anatyhi yhỹ tsimaha. Kazikwy humo tsimyspirikponaha — niy. — Yhỹ tsimaha. Azikwy humo myhyriziktsa tsimykozozonaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Iwaze Sesus sihyriziktsa ty tsikatsika nikara. Ispe niy: — Amy tsimyzihikiknaha atsatu my. Ahahyriziktsa mysizororowykta! Kahumo ahaspirikporẽtsawy ahahyriziktsa zororowy. ");
INSERT INTO rkbNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Iwaze nikozozonaha. Kyze Sesus ispe niy: — Wabyziutaha! Hawa ahabo iky, soso byitaha — iwa ispe niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Asaktsa myzubaha bo nipamykysokonaha. Hawa Sesus niy nanabyitaba nipamykysokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Kytsa nitururuknahaze usta maku, Sesus bo zioktyhyryknaha. Atakta ihyrikoso sapybara humo batu harere ziky. ");
INSERT INTO rkbNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Iwaze Sesus ihyrikoso sapybara iharerebyita ekze ziksiwyhik, nabo pãoty niy. Iwaze maku taharereke ihyrikoso sapybara nihokda naha humo. Kytsa sipybyrẽtsa Sesus zikwy humo asaktsa: — Hawa mykara. Nawa ty ka katsa batu ityny Isareu eze tu — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pariseutsa Moises harere sihyrinymyrẽtsa: — Satanas hyrikoso sapybara pehakatsa ihumo ihyrikoso sapybara ziksiwyhik atahi tazikwy ty ibo nyny my — mybarapetu nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Kyze Sesus nanabyitaba bo inaukuru. Ihudikhudikwytsa myzubahatsa sizubarẽna iwa niukuru. Deus wahoro eze kytsa nisihyrinymyryky, kytsa Deus tyryktsa moziknaha ana soho nitsasoko. Deus wasania ty nitsasoko. Kytsa simyitsapyritsa nisizororowy, ustsa kytsa siakubyitsa nisipunihikwyky. Iwa Sesus nikara. ");
INSERT INTO rkbNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Sesus kytsa sizubarẽtsa bo iktsa niyze sihumo tsimypokzitsiarẽta. Tapetu isopyk: — Paikpa mytsaty mykaranaha batu siaku. Hozipyrykzatsa watsa, hozipyrykzatsa siperynymyrybyitsa hỹ — mytsaty nikara. ");
INSERT INTO rkbNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Mytsaty nikaraze zinymyrykynahatsa pe: — Waratok eze tsizubarẽna niubaranaha. Wihara nijakuk. Sitsumuẽhĩtsa batu sizuba. Wihara myzibakanaha tsumuẽhĩtsa batu sizuba. Kytsa sizubarẽtsa wihara watsa. Waratok tsihitsa Deus wata my — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","— Iwatsahi waratok tsihitsa pe: “Ikiakta tsumuẽhĩtsitsa waratok boktsa! Tysizoziknaha. Wihara bo tysipeha” maha. Nawa tihi Deus bo tsimypamykysokonaha. Hawa tsihitsa pe: “O waratok boktsa” wihara niakuk, ikiahatsa Deus pe “O kytsa sizubarẽtsa humo wasania ty batu tywaby sihyrinymyrybyitsa tu ikia kytsa siboktsa wasania ty motsasokonaha” iwa Deus bo tsimypamykysokonaha — Sesus niy. Iwa nisihyrinymyryky. ");
INSERT INTO rkbNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Kyze Sesus dose zinymyrykynahatsa pe niy. — Pany! Kazikwy ahatuk mynapykyryk iwaze hyrikoso sapybara mybarawy ezektsa pororo nakaranahaze ispe: “Nabo pãotaha” tsimaha. Hyỹ maha. Kazikwy humo tysiksiwyhiknaha. Ikiahatsa kino simyitsapyrẽtsa kazikwy humo tsimysizororowynaha, kytsa siakubyitsa tysiakuwykynaha kazikwy humo sispihikrẽtsa moziknaha iwa tsimahaktsa! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Sesus sakzohotsa nisiwatawyhik. Tapara Simaõ Peduru ty zinaroko, itsy Ãdere niwatihi, Tsiaku, Sebedeu tse itsy Suão niwatihi ziwatawy. ");
INSERT INTO rkbNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Piripi, Baratoromeu, Tome, Mateus okyrysaro byktsa, Tsiaku Arapeu tse, Tadeu. ");
INSERT INTO rkbNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simaõ Kanaã ezekta, Sudas usta Iskariotses inarokota atahi Sesus isukyrytsitsa bo zioktyhyrykta iwatsa Sesus nisiwatawy. ");
INSERT INTO rkbNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Asaktsa dose kytsa nisipeha. Atahi: — Ahatukytsa boktsa kytsa! Tsipiksinahaktsa! Ske buruk Sudeutsabyitsa hudikhudikwy bo ba zikumunaha. Samarija ezektsa hudikhudikwy bo ba zikumunaha ahatukytsa bo zuba tsipiksinaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Asaktsa hozipyrykzatsa watsa. Hawa hozipyrykzatsa batu ske buruk nawa sizaratsa nikaranaha. Sudeutsa kahyrinymyrywy bo batu yhỹ zikaha, iwaze sizaratsa watsa niwatihi. ");
INSERT INTO rkbNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ske buruk tsimyzurukunahaze nisihobyknahatsa pe “Abaka myzubaha Deus tyryktsa moziknaha” tsimaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Simyitsapyrẽtsa tysizororowynahaktsa! Niakbanahatsa tynasihyrizikponahaktsa! Kytsa nibibibaiknahatsa sakõrõrõtsa humo tysizororowynahaktsa! Mybarawy ezektsa asahi hyrikoso sapybara pororo ziknakaranaha tysiksiwyhiknahaktsa! Deus hi sapyhaty ahabo nyny mykara iwatsahi myzubaha bo isapyha ty nyny tsimaha tysitsumuẽhĩnaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Okyrysaro ty koro koro byitaha! ");
INSERT INTO rkbNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ske buruk tsimykurunahaze ahaborohobyitsa ty! Wanuty pu pu byitaha! Ahasuk ty kino pok pok byitaha! ahahumokta tyzuba tsimaha. Ahapyrysuk ty estuba zuba korobyktaha! Ahazozowy ty wabehyryk wabehyryk byitaha. Amy tsimyzihikiknaha ana ty hi kytsa ahabo nyny maha. Ahahyriziktsokzawy humo ahadisahawy ty ahabo nyny maha. ");
INSERT INTO rkbNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Tsipomokonahaze myzubaha bo anahudikhudikwy ezektsa ahape maha: “Kawahoro bo pakutynaha” maha zeka yhỹ tsimaha. Iwahoro bo tsinapupunahaze anaeze tsimypykyryknaha. Ituk tsimytarenaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ata wahoro bo tsinapupunahaze iwa tsimaha “O wahoro ezektsa ahatsyhyryze Deus bo tsimaha ‘Myzo tysisapywyky ahumo sakurẽtsa moziknaha’ ” tsimaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Anaeze tsimypykyryknaha wahoro ezektsa Deus wasania ty yhỹ mykaranaha zeka sakurẽtsa moziknaha. Wahoro ezektsa Deus wasania ty ahabyizeka batu siaku moziknaha. Ikiahatsa hi ahakurẽtsa tsimyziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Asaktsa Deus wasania ty ahabyi zeka, ahaharere bo waby ahabyizeka meky botu tsimykurunaha. Tsimykuruzonahaze ahapyrysuk ty bok bokyktaha. Wytyk tazy ty mynatõ mysiwatawy. “Tahudikhudikwy ezektsa Deus harere bo batu hỹ” my. ");
INSERT INTO rkbNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Hanawa puruze Deus aparakbaha soho motsasoze, hawa ha ty kytsa tisapyrẽna nikaranahaze “O wasani nikaranaha” my. Ustsa kytsa hawa ha ty batu isapy nikaranahaze “O simysapybyitsa nikaranaha” my. Iwa purunahaze asaktsa Sodoma ezektsa humo tsihokdarẽna, Korora ezektsa humo kino niwatihi tsihokdaharẽna. Anahudikhudikwy anaeze Deus wasania ty batu hỹ nikaranaha tsihokdaharẽna baba — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Mytsatyziutaha! Nanabyitaba pahapehaka ikiahatsa hozipyrykzatsa watsa parinitsa ahatuk maha. Iwatsahi pykyhytutaha! Wohorektsa watsa sispirikporẽtsa siwatsa kytsa bo tsimytsatyziukunaha. Amytudutsa watsa batu sakyri, ikiahatsa siwahatsa batu ahakyri tsimaha! ");
INSERT INTO rkbNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Pykyhytutaha! Sudeutsa siharerewabynahatsa pahaoktyhyryknaha. Sudeutsa sidyhydyhywytsa bo anaeze hwitsa ty pahakikinaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Kytsa sipehatsa, sikapitãotsa kino niwatihi sibo pahaoktyhyryknaha. Ikiahatsa siokerykze Deus wasania ty sibo tsimytsasonaha. Iwa Sudeutsabyitsa Deus wasania ty piwabynaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ahatsipa humo pahaoktyhyryknaha zeka ahaharere soho bo mytsaty mytsaty byitaha! Sipehatsa okeryk tsimytsasonahaze Deus pahatsumuẽhĩ. Iwatsahi ahaharere ty Deus hyrikoso humo mytsaty tsimaha. Ihumo ahahyrinymyrẽtsa hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ikiahatsa zuba batu tyso Deus hyrikoso ahatuk mynapykyryk iwaze wasani tsimytsasonaha. Atahi ahaharere piakse nawa pahatsumuẽhĩ. Ihumo ahahyrinymyrẽtsa hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Sesus tuk zinymyrykynahatsa pe: — Kytsa situkytsa sisukyrytsitsa bo mysioktyhyryknaha, tsipahabawynaha. Iwa situkytsa tahabawynaha. Wastuhu Deus harere bo hyỹ mykaranaha. Ustsa kytsa Deus harere bo batu hỹ mykaranaha iwaze myharape metuwykynaha. Izotsa siharereziubyitsa tu sihyrytsa mysioktyhyrykyknaha iwaze tahabawynaha. Ihyrytsa niwatihi sizotsa humo tahakyrikinaha Deus harere humo sisukyrytsitsa bo tysioktyhyknaha tahabawynaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Sizubarẽtsa kahumo batu siakparawy iwatsahi ahabo niwatihi batu siakparawy. Ikiahatsa kahumo ahaspirikporẽtsa tu iwatsahi kytsa aha humo batu siakparawy. Atakta tybyi zuba niy kahumo tispirikporẽta babata. Aty kaharere bo hyỹ mynakara zeka iwaze sinini my atakta Deus tuk tawahi mynapykyryk. ");
INSERT INTO rkbNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Estuba hudikhudikwy eze pahasukyrykynahaze usa hudikhudikwy bo tywakiknahaktsa! Anaeze pahasukyrynahaze usa hudikhudikwy bo tywakik. Utakta mybarawy bo iknasik. Bykyze bijoikpe bo modo. Tapara ahahyriziktsokzawy tsipipyknahaze zuba mybarawy bo myziksizo. Uta mozumuze ikiahatsa Deus wasania ty tsimytsasonaha. Isareu ezektsa bo batu ahapyk. ");
INSERT INTO rkbNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","Abaka pahahyrinymyry hawa kytsa sisopyk ikiahatsa katuktsa babatsa tsimaha zeka kawata tsipinymyryky. Aty pinymyrykyta batu puẽtsik ziky. Pinymyryziu zeka tahyrinymyrykytsa wata mozik. Estuda mopyk zeka tahyrinymyrykytsa wata mozik. Tahyrinymyrykytsa ihumo tsakurẽta. Sitsumuẽhĩtsa niwatihi. Maku sitsumuẽhĩtsa puẽtsik tatu ipehatsa ihyrizikwani. Sitsumuẽhĩtsa tapehatsa watsa mozik zeka ipehatsa ihumo tsakurẽta. Kytsa mytukytsa taparakta soho “Atakta Beserebu hyrikoso sapybara pehakatsa” maha. Iwa mypehatsa motsasonaha zeka amy skaraba mytukytsa mysinaropykyknaha. Kytsa sisoho sinaro ty batu isapybyikia motsasokonaha. Iwaze asaktsa ziksukyrykynaha ikiahatsa niwatihi, ikiahatsa katuktsa babatsa tsimaha zeka pahasukyrykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","— Iwaze siharereziubyitsa bo ahapyby byihu ja! Hawa ha ty kytsa papatu mynakaranaha bykyzehu myzubahatsa sihyrinymyrẽtsa. Hawa ha ty kytsa akbyibatu mopamykysokonaha humo sizubarẽtsa pinymyrykynaha. Hawa ha ty imysapybara mynakaranaha humo aibani sizubarẽtsa sihyrinymyrẽtsa. ");
INSERT INTO rkbNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Hawa ha ty ahabo motsaso kytsa papatu bykyzehu sizubarẽtsa bo opykani tsimytsasonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kytsa pahabanaha zuba sipokso ahapyby byihu ja! Ikiahatsa pahabanaha. Bykyze batu zikaha. Ba amy tohi ahabo zikaha. Ahahyrizikararawy ba ziksibanaha. “Aty pokso sa mypybyrẽtsa.” tsimaha. Deus pokso ahapybyrẽtsaktsa! Ata zuba kytsa sinini ykarawy bo nasipehaka. Iwatsahi Deus pokso ahapybyrẽtsa! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","— Amy ty piyk huak ty okyrysaro ty tsipisihyrykzo. Estuba zuba ja. Yhỹ. Piyk estuba zuba zibeze zeka ahazo tsihyrinymyrẽta. Yhỹ niy. Deus hi piyktsa humo ba zikspiriktsokda. Sihumo tsimypokzitsiukrẽta, iokzeka sipokzitsarẽtsa. ");
INSERT INTO rkbNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ikiahatsa ja. Deus ahasoho humo tsihyrinymyrẽta. Tsihyrinymyrẽta babata. ");
INSERT INTO rkbNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Iwatsahi kytsa pokso ahapyby byihu ja! Hawa ahabo mykaranaha ahapyby byihu ja! Deus okzeka ahahumo tsimypokzitsiarẽta. Iokzeka piyktsa sipokzitsarẽtsa ikiahatsa pokzitsiuwy abazuba. Iwatahi Deus ahahumo tsimypokzitsiukrẽta hỹ — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ikiahatsa myzubaha okze tihi: — Uta Sesus tukta my. Sesus iny — tsimaha. Iwa tsimytsasonaha zeka uta kino niwatihi bijoikpe eze tu utakta kazo pe my: — Atakta katukta pinyky my — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ikiahatsa myzubaha okze tihi: — Sesus batu kanyhy — tsimaha. Iwa tsimytsasokonaha zeka uta kino niwatihi, bijoikpe eze tu utakta kazo pe my: — Atakta batu kanyhy my — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","— Mybarawy bo inasik kytsa nisihyrinymyryky. Tozeka ja kytsa astsabanitsa ja tsimaha mytsaty ahabyitsa tsimaha. Asaktsa kaharere bo hỹbyri tsimykaranahaze metutu mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Itse tazo batu iakparawy. Izo Deus harere bo hyỹ mykara, itse batu, iwatahi tazo humo batu iakparawy. Iste taje humo batu iakparawy. Ije Deus harere bo hyỹ mykara iste batu iwatatsahi taje humo batu iakparawy. Iwapyryza ihyrytsa iokeza batu iakparawy. Atatsa Deus harere bo hyỹ mykara ihyrytsa iokeza batu, iwazahi ihyrytsa iokeza humo batu iakparawy. Iwa katukytsa kaharere humo metutu mynapykyryknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Maku iwahoro ezektsa sisukyrytsitsa moziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Amakta zeky izo ije izotsa iwatsa sihumo ka iakparawytsa zuba iwatahi kahumo ka tsikaeni zuba iakparawy iwatahi batu katuktsa babatsa. Aty zeky itse iste ihyrytsa iwatsa sihumo ka iakparawytsa zuba iwatahi kahumo ka tsikaeni zuba iakparawy iwatahi batu katuktsa babatsa my. ");
INSERT INTO rkbNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Sinini tsimahaze tu tsikahazoziknaha! Aty zeka iharapatawyhyta tasukyry buruk piskek zeka mohyrikosokda atahi nikara. Ikiahatsa tihiktsa! Katuk babatsa tsimoziknaha zeka sinini tsimykaranaha! Pabeze tsihikiknaha zeka kahumo ahaspirikpo batu pyk tsimaha. Tsikspirikpotohinaha kahyrinykyryk sinini tsimaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Aty tabo zuba mytsaty myze: “O utakta ba zik hyrikosokda tapara Sesus bo batu yhỹ iwatahi Sesus soho ‘batu kanyhy’ ” my, atahi Deus tuk batu tawahi mynapykyryk. Atakta Sesus humo sinini my zeka atahi Deus tuk tawahi mynapykyryk, ipauk baze mynapykyryk tsakurẽta my — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","— Aty ahape: “O kawahoro bo pakutynaha. Mytuk tsipadisaha hỹ” my. Atakta kabo hi mykara. Ikiahatsa tsasohokotsa tu kabo mynakaranaha. Deus bo mynakaranaha. Utakta Deus zikpehata ahawata tu Deus bo mynakaranaha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","— Aty Deus sohokotsa pe my “O kawahoro bo pakutyny. Mytuk tsipadisaha” my. Atakta Deus sohokotsa tuk Deus sapyha ty sibo nyny my. Atahi maku tsimysapyrẽta bo atakta Deus harere bo hyỹ mykara. “Pany! Kawahoro bo pakutyny tsimy” my. Iwa tsimysapyrẽta humo, atahi tsimysapyrẽta Deus sapyha ty sibo nyny my. “O sibo mysisapywyky” — Deus my. ");
INSERT INTO rkbNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","— Aty zeka pihik ty katukta bo nyny my zeka atahi katukta bo nyny my iwaze Deus isapyha ty ibo nyny my hỹ — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Kyze Sesus dose zinymyrykynahatsa pe nitsasobaze niukuruzo. Karireja bo niukuru. Anaeze Deus wasania ty nitsasokoro kytsa nisihyrinymyryky. ");
INSERT INTO rkbNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Iwaze Suão Batista sakyriukrẽnikitsa hurukwy eze, Kiristu Deus zipehata mywata niyzik hawa nikara ana hi ziwaby. Iwaze wastuhu zinymyrykynahatsa pe niy: — Pany pãotyny Sesus boktsa! “Ikia Deus zapehata ja” ipe tsimaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Iwaze Sesus bo niukurunaha. Ibo zumunahaze asa tihi: — Tapara Suão tihi: “Deus zipehata mozumu” niy. Ikia Deus zapehata ja. Usta ja tsipiperykynaha — Suão zinymyrynahatsa niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Sesus ispe niy: — Suão bo tsipiksizonahaktsa! Hawa ha bo iktsa tsimaha, hawa tsiwabynaha ana ty hi Suão bo typamykysonahaktsa! ");
INSERT INTO rkbNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Sihyrizikubyitsa myhyrizikzororonaha. Siekbyritsa pitabakanaha. Kytsa sakõrõrõtsa humo nibibibaiknahatsa mozororobaiknaha. Siharawitsa piwabykynaha. Niakbakanahatsa inahyrizikponaha atsatuzo niaha. Asaktsa sinamybyikitsa Deus wasania ty piwabykynaha, Deus wasania ty sibo motsasoko. Iwa Suão bo typamykysonaha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","— Tsakurẽta atakta kasoho ty “O atahi Deus bo kytsa mysioktyhyryk” my. Batu iaku atakta kasoho ty “O atahi Deus zipehata ja. Batu kanyhy my” — niy. Iwa batu tyso. ");
INSERT INTO rkbNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Kyze Suão Batista tuk zinymyrykynahatsa nitururuknahaze Sesus kytsa sizubarẽtsa bo nipamykysoko. Suão soho nitsaso atahi: — Jerukbara bo tsikurukunahaze Suão harere tsiwabynaha. Amo skaraba tsiny tsihikiknaha. Estuba hwi tsibik wata zopok humo wãkwãk nikara. Maku iwata batu iktsa tsikaha. Suão Batista ta hwi tsibik byiwata niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Amo skaraba tsiny tsihikiknaha. Maku tisukziurẽta bo tsikaha. Batu. Kytsa sisukziurẽtsa sipehatsa wahoro sihezõni eze mopykyknaha. Suão batu tsinamyrẽta wata — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","— Kyze amo skaraba jerukbara bo tsikny tsihikiknaha Deus harere sohokotsa bo tsikaha. Yhỹ, Suão Batista Deus sohokotsa hiba. ");
INSERT INTO rkbNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tubabatu Deus sohokotsa ziwataha. Deus tihi: “Iktsa tsimaha! Katsumuẽhĩtsa Kiristu haraze iakzohota itsyhyryze pikymy. Hawa kytsa ske buruk pizozikbanaha pykyhytuty iwata ihumo pikymy” niy. Iwa Suão Batista soho Deus sohokotsa tubabatu ziwataha, abazuba atsatu niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Tsiwabytoktonaha! Kytsa sizubarẽtsa botu nipupurukuknaha Suão Batista imyhyrizikwani niy. Iwatuze aty Deus tyryktsa mozik, atahi wasania ty my zeka yhỹ my imyhyrizikwanikita mozik Suão batu. ");
INSERT INTO rkbNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Suão Batista motsasoko zumuze kytsa nisihyrinymyryky. Abaka Sesus izumu kytsa Deus tyryktsa moziknaha, zikwy humo sipunihikrẽtsa moziknaha. Deus hyrikoso zikwy humo iwa kytsa Deus tyryktsa moziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Tapara Suão izumu, Deus sohokotsa, Moises harere kino niwatihi iwa Deus tyryktsa soho botu nitsasonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Siharere bo yhỹ tsimahaze Suão Erias wata. Hawa nikara Erias wata. Hawa ha ty Deus sohokotsa Erias soho nitsasoko atsatu nikara, Suão zumuze atsatu nikara. ");
INSERT INTO rkbNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ana kino tsiwabynahaze wabyziutahaktsa kytsa! — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Atahi: — Abaktsa kytsa sa hawa, uta pahawatawyky. Jabyitsa watsa maha. Jabastsa mowakyrikinaha kõparasapy eze nidyhydyhykynaha. Paikpa harape bo huahua nikaranaha. Asa zuba mopamykysokonaha: ");
INSERT INTO rkbNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Katsaktsa tsipamykyzukunaha ikiahatsa ba zikarinaha. Kyze katsaktsa tsikzeharawatahakanaha kytsa watsa nirata humo tapokzi. Ikiahatsa ba zikpunaha, mytuk batu huehue zikaha” niaha. Hawa jabyitsa mowakyrikinaha wastuhu batu siakparawy tahaoktsĩnaha. Ikiahatsa siwatsa tsimaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Suão Batista zumu. Zumuze hauk habyita tu niy. Duabohotsa tsik batu tsõ. Kytsa isoho “O atakta ihyrikoso sapybara tuk mynapykyryk” mybarapetu niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Kyze utakta Deus zikpehata ahawata ikyzik ahabo ikzumu. Mydisahawy pihauk. Duabohotsa tsik piku. Kasoho kytsa tihi: “Iktsa tsimaha. Atakta titsaurẽta. Okyrysaro byktsa tuk tadisahaka. Ustsa kytsa simysapybyitsa tu iakparawy my” niaha. Jabyitsa watsa. Iwa abaktsa kytsa Deus hyrinymyrywy babaha soho mybarapetu nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Kyze Sesus Karireja pihikzotsabyri sihudikhudikwy ezektsa nisibetsakak. Anaeze amy ty kytsa batu zikaha atsatu nikara. Simyitsapyrẽtsa nisizororowy. Niakbanahatsa ihumo inahyrizikponaha. Iwatsa tu ihumo batu sispirikpo iwatahi nisibetsakak. ");
INSERT INTO rkbNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","— O hudikhudikwy Tsoratsĩ inarokoha. Anaezektsa sinini mykaranaha. Kahumo sispirikpobyitsa iwatsahi sinini mykaranaha. O hudikhudikwy Beseza inarokoha. Anaezektsa sinini mykaranaha. Kahumo sispirikpobyitsa iwatsahi sinini mykaranaha. Anatu kazikwy zinynaha. Atsatu zeka Tiro ezektsa mykara. Atsatu zeka Sodoma ezektsa niwatihi mykara zeka tubabatu siezektsa Deus harere bo yhỹ nikaranaha. Simysapybyitsa tu nikaranaha ana kino zimoewynaha. Iwaze siakubyitsa izohyri ty tahapiakwatahakanaha tahasopyk tyty humo iwa kytsa bo ziwatawykynaha simysapybyitsa tu nikaranaha ana hi zerekbaiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Bykyzehu Deus kytsa simysapyrẽtsa pe: O ikiahatsa ahamysapyrẽtsa, kyze simysapybyitsa pe: O ikiahatsa batu ahamysapy tsimaha my. Nawa zuruze Tiro ezektsa sinini mykaranaha. Sodoma ezektsa niwatihi jokboa zuba sinini mykaranaha. Ikiahatsa hi sininitohi tsimykaranaha, ba zik zororonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","O hudikhudikwy Kaparanaũ inarokoha. Anaezektsa mytsaty nikaranaha. “Katsaktsa abazubatsa tsimoziknaha” iwa mytsaty ahabyitsa nikaranaha. Deus hi sinini ykarawy bo mysipeha. Kaparanaũ ezektsa kahumo sispirikpobyitsa tu amy ty kytsa batu zikaha situk ikykara. Atsatu zeka iky Sodoma ezektsa humo Deus takyri humo batu koro. ");
INSERT INTO rkbNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Iwaze Deus kytsa soho motsasoko Sodoma ezektsa sinini mykaranaha, Kaparanaũ ezektsa kahumo sispirikpobyitsa sinini mykaranaha, Deus sinini ykarawy bo mysipeha. ");
INSERT INTO rkbNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kyze Sesus Deus bo nipamykyso: — O kazo abazubata. Ikia hi bijoikpe ezektsa pehatsa. Ikia hi mybarawy ezektsa pehatsa. Ikia zuba wasani tsimykara. Tapara hawa tsimykara sihyrinymyrẽtsa bo ziokpitsĩ. Batu isty watawy. Sihyrinymyrẽtsa papatu batu isty watawy. Asaktsa sihyrinymyrybyitsa tu sibo hi tsiksiwatawyky. Hawa tsimykara tsiksiwatawy. Kytsa jabasitsa watsa tsiksiwatawyky. Asaktsa batu simyi. ");
INSERT INTO rkbNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Iwa tsimyzihikik iwatahi “O tisapyrẽna” kazo my — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Kyze Sesus nipamykysokozo zinymyrykynahatsa pe niy: — Deus kazo hi anamy ty kabo nyny niy. Ba aty tohi ta ja itse ziky ikatahi zuba. Kazo babata. Niwatihi ba aty tohi ta ja kazo ziky ikatahi itse babata ziny. Asa kino mysiwatawy tsihikik. Iwa hỹ — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Iwaze Sesus myzubaha pe niy: — Panytaha! Kabo tyzumunahaktsa! Ikiahatsa batu ahaku ikiahatsa ahakubyrisorokbyitsa ikiahatsa kino kabo panytaha! Iwaze kahumo ahakurẽtsa tsimoziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Kaharere bo hyỹ tsimaha. Utakta zinymyrykynahatsa tuk kakubyrisorokrẽta uta kamysapyrẽta bazimyi iwatsahi katuk tsinymyrykynahaktsa! Ahakurẽtsa tsimoziknaha, katuk tsimynapykyknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kaharere humo batu ihokdaha. Kamyspirikpowy ahape tisapyrẽna sihumo ahapyby byihu ja iwatsahi kamysopykwy tsimahaktsa — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Kyze nawa zuruze tabyrykyze Sesus waratok bo niukuru. Zinymyrykynahatsa siarapa zumu iwatsahi tiriko inasibakanaha. Nisityhyktyhykyknaha iwaze nisiborokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Pariseutsa sibo nikozonahaze Sesus pe niaha: — O iktsa tykta! Ikia tuk zinymyrykynahatsa tarabaja mykaranaha. Amo skaraba niwa mykaranaha. Nawa zuruze tabyryky eze Deus harere humo katsaktsa batu tarabaja zikaha. Ana kino Moises harere tubabatu nimyhyrinymyryky — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Iwaze Sesus ispe niy: — Hawa taparakta Dawi niy baija ahahyrinymyry. Papeu humo Dawi soho ziwatahaka. Taparakta Dawi itukytsa siaraparẽtsa tuze Deus wahoro bo inapupunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Deus wahoro bo nitsukze atsikara waha zibyk, ana hi Deus bo ky zituha. Zioko itukytsa niwatihi ziokoknaha. Moises harere tihi: “Ana atsikara waha kytsa batu hauk zikaha. Ziknapamykysokonahatsa zuba zikziokoknaha” niy. Dawi ziok, itukytsa kino ziokoknaha. Ana papeu humo ka ja batu ahahyrinymyry — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","— Ahahyrinymyrẽtsa nawa zuruze tabyryky eze ziknapamykysokonahatsa Deus wahoro eze tarabaja nikaranaha. Moises harere humo “batu tarabaja maha” ziknapamykysokonahatsa siraratsa nisiba. Deus bo nyny nikaranaha. Iwatsatu wasani ziknakaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Utakta ahatuk kamyspirikpowy ezytyk abazuba my, ahasopykwy Deus wahoro soho nepykyknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Deus harere tubabatu ziwatahaka “Tyharape pokzitsikinahaktsa kytsa! Siraratsa ty kabo nyny tsimaha zeka tsikaeni zuba mozihikik, tyharape pokzitsikinaha zeka ana hi mozihikik” niy. Deus sohokotsa tubabatu ziwatahaka ana harere inymyry baba, anahumo hi zinymyrykynahatsa bo batu ahasapybyi. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Utakta Deus zikpehata ahawata ikyzik. Anahumo hi uta kino nawa zuruze tabyryky eze tsihitsa ikyzik, nawa zuruze mybyrywy eze pipehaka my — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Kyze Sesus niparak Deus wahoro bo nitsuk. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Anaeze estuba maku itsyhyrype noikta niy. Wastuhu kytsa Sesus humo batu siakparawy iwatsahi motsasonaha — “Sesus hawa imysapybara ty mykara” iwa motsaso tsihikiknaha. Nizokparakanaha. Iwatsahi ipe: “Mybyrykywy pomoze tahabyi mopykyryknahaze maku tsipizororowy wasani ja. Moises harere humo tsipizororowy zeka wasani ja” — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Sesus tihi: — Aty hozipyrykza estuba zuba zeka. Nawa zuruze pororo mykara tahabyi mopykyryk hozipyrykza wytyk hoke bo mynatokoro zeka hawa tsimy. Hozipyrykza bo iwaze atsoko ity paik my. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Hozipyrykzatsaktsa myraratsa zuba. Makuta Deus humo ka tsipokzitsiarẽta. Iwatahi kytsa pitsumuẽhĩ. Nawa puruze tahabyi mopykyryk kytsa mysitsumuẽhĩnaha zeka wasani my — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Iwaze itsyhyrype noikta pe niy: — Atsipa ty kabo nynytyny — niy. Maku tatsipa ty Sesus bo nyny niy. Atsoko nizororohik. Usta tsyhyrype wata niyzik. Sesus itsyhyrype zizororowy. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Pariseutsa ana bo iktsa niahaze tahaokanikinaha, niunaha. Asa zuba nipamykysonaha — Hawa skaraba Sesus tsipibezenaha — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Siharere soho humo tsihyrinymyrẽta iwatahi ana ekze kuorẽ niy. Kytsa sizubarẽtsa iapik niukurunaha. Asaktsa simyitsapyrẽtsa nisizororowyba. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Nisizororowyze ispe niy: — Hawa mykara kytsa bo soso byitaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Iwa niy. Iwatahi amy ty Deus sohokotsa tubabatu ziwatahaka atsatu nikara. Ta ziwataha Deus tihi: ");
INSERT INTO rkbNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","— Atakta katsumuẽhĩtsa utakta ibo piwatawy. Ihumo kakurẽta hiba. Ihumo kamypokzitsiarẽta. Kahyrikoso ibo pipeha ituk tawahi mynapykyryk, kahyrikoso ituktu mynapykyryk ihumo kazikwy ituk my. Kasopykwy tisapyrẽna kytsa bo my. Hawa mozihikik aparakbaha bo motsaso. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ba zikaha pebetsak sizubarẽtsa tuk batu kakaik my, batu aty tohi ske buruk ba zikaha pebetsak. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Kytsa asaktsa siakubyitsa hwi tsibik wata ihumo sipunihikrẽtsa moziknaha. Asaktsa batu siaku izo mybeke ta hyrity wa ihumo sakurẽtsa moziknaha, sihumo batu imyi. Myzubaha kaharere bo hyỹ mykaranaha mozihikik. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kytsa abazubatsa ihumo sispirikporẽtsa maha — niy. Iwa Deus sohokotsa Isaijas inarokota tubabatu Sesus soho ziwataha aba zuba atsatu my. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Kyze kytsa maku ihyrizikubyita Sesus bo zioktyhyryknaha. Ana humo kino iharerebyita ihyrikoso sapybara humo. Sesus zizororowy iwatahi inataharerezo, iwaze iktsazo niy. Tsakurẽta niyzik. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Hawa Sesus niy kytsa sizubarẽtsa paikpa iktsa nikaranaha. Nimypybybaiknaha. Asahi: — Tozeka ja Deus zipehata, tozeka ja taparakta Dawi tsekoka — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kyze Pariseutsa ana hi ziwabynahaze asa kino: — O Beresebuhu Satanas usa naro hyrikoso sapybara pehatsa zikwy humo Sesus maku zizororowy. Izikwy humo hyrikoso sapybara nisipehaka — mybarapetu nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Hawa ha humo mytsaty nikaranaha Sesus tsihyrinymyrẽta. Iwaze ispe niy: — Ityryktsa asa zuba niharapebakanaha zeka nepyknaha. Nawaze kytsa metutu niakmyinaha. Wahoro ezektsa moharapebakanaha zeka mopyknaha. Hyrikoso sapybara wahoro ezektsa watsa. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Iwahatu Satanas tatyryktsa mysibaka zeka mopyk. Hyrikoso sapybara mysiksiwyhik zeka iwaze atahi metutu mozik iwaze mopyk. Batu sipehatsa my. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ikiahatsa iwa mybarapetu tsimykaranaha “O tahi Beserebu zikwy humo hyrikoso sapybara nisiksiwyhik” tsimaha niy. Utakta hyrikoso sapybara mysiksiwyhik zeka Beserebu humo ahatuktsa zinymyrykynahatsa ja. Aty zikwy humo sa atuk zinymyrykynahatsa hyrikoso sapybara mysiksiwyhiknaha. Iwatsahi atuk zinymyrykynahatsa pahawatawynaha, uta batu izikwy humo hyrikoso sapybara mysiksiwyhik ana humo pahawatawy. Ahatuk zinymyrykynahatsa niwatihi Satanas zikwy humo ba hyrikoso sapybara ziksiksiwynaha batu zikaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Utakta Deus hyrikoso zikwy humo hyrikoso sapybara mysiksiwyhik. Utakta Deus zikpehata kytsa wata ikyzik abaka Deus tyryktsa ahatuk mozumu ana humo hi ahahyrinymyrẽtsa. Kytsa Deus harere bo botu hyỹ mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Batu aty tohi tsipaikrẽta wahoro bo mytsukze inamy piakse. Batu zik. Taparaka tsipaikrẽta ziakwaraka iwaze iwahoro bo mytsuk, inamy piakse. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Aty batu katukta kabete batu yhỹ niy. Aty katy tsumuẽhĩ byizeka kytsa Deus bo batu mysioktyhyryk atakta metutu myzapyk batu katukta. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Iwatsahi kytsa simysapybyitsa ty nikaranaha Deus mysiokzohik, siharerebyitsa ty Deus mysiokzohik. Aty zeka Deus hyrikoso pisapybyiki zeka ana hi Deus ba ziokzo. Atakta amy ty tisapyrẽna “batu sapy” mykara Deus anahumo hi ba zikspiritsokdatawy batu zik. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Aty skaraba Deus zipehata soho pisapybyikinaha zeka ana kino Deus mysiokzohik, aty Deus hyrikoso humo pisapybyikinaha zeka ana kino Deus ba zikokzowy. Imysapybara ty tawahi kytsa tuk mynapykyryk ba zikokzowy ziknakara — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","— Kyze hwi tisapyrẽta zeka wihara bobatu zeka tisapyrẽna. Hwi batu sapy my zeka wihara batu isapy. Wihara humo hwitsa soho tsinymyrynaha. Uta hwi tisapyrẽta wata, hawa ha ty mykara tisapyrẽta. Hawa ha ty mytsaty mykara wasani wihara tisapyrẽna waha. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ikiahatsa pyryhyktsa watsa tsimaha. Pyryhyktsa batu simysapy maha. Ikiahatsa kino niwatihi ahaharere batu imysapy tsimaha. “Katsaktsa mysapyrẽtsa tsimaha” mybarapetu tsimykaranaha. Iwa batu tyso tsimaha. Mysapyrẽtsa tu zeka hawa ha ty wasani zuba mytsaty tsimykaranaha. Hawa kytsa mysitsumuẽhĩnaha ana bo hi mytsaty tsimykaranaha. Atakta imysapybyita tu zeka amy ty batu sapy mytsaty mykara ana humo hi imysapybyitsa ty mykara. Hawa mytsaty tsimykaranaha ana hi tsimoziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mysapyrẽtsa tu zeka isapyha ty mytsaty tsimykaranaha iwatsahi myharere tisapyrẽna tsimaha. Atakta hwi tisapyrẽta wata wihara niwatihi tisapyrẽna my. Katsa mysapybyitsa tu zeka hawa batu mysapy mytsaty tsimykaranaha iwatsahi myharere batu sapy tsimaha. Atakta hwi batu sapy wata my, wihara niwatihi batu sapy my. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Hana wa puruze Deus kytsa soho motsasoze abazubatsa Deus bo amy skaraba tahaharere nitsasonaha. Wastuhu tahaharere batu sapy ana soho Deus bo mopamykysonaha. Ustsa tahaharere wasani ana soho Deus bo mopamykysonaha. Abazubatsa tahaharere soho Deus bo motsasonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Taharere humo Deus tihi: Sihareresapyrẽtsa pe: “Ikia tsamysapyrẽta” my. Sihareresapybyitsa pe: “Ikia batu amysapy” my. Iwatsahi ahaharere humo pykyhytutaha! — Sesus niy. — Hwi wihara batu metutu zikaha. Ikiahatsa ahaharere niwatihi batu metutu zikaha. Hawa mytsaty tsimykaranaha ana kino tsimoziknaha, iwa hỹ — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kyze asaktsa Deus harere zinymyrynahatsa Pariseutsa niwatihi Sesus pe: — O myhyrinymyrykytsa, Deus zikwy mybo tsiwatawykta! Amy ty kytsa zikahabara ty tsimyktsa ana hi tsimyzihikiknaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","— Batu yhỹ niy. Abaktsa kytsa Deus harere bo batu ma zikaha. Kape tsimaha “Watahatykta” tsimaha. Batu yhỹ my. Tubabatu amy ty Deus zikwy Sonas bo niy ana hi pahawatawy ana humo kino pahahyrinymyryky. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Sonas piknu puẽtsikbyita hakoke eze niapykyryk harakykbyi zuru. Anawahi Deus zipehata wytyk eze harakykbyi hi puru. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Sonas Ninewe ezektsa bo Deus harere nitsasokoze asaktsa: “O mysapybyitsa tsimaha. Imysapybara tsimoewynaha” niaha. Asaktsa hanawa puruze Deus kytsa mynasihyrizikpowynahaze abaktsa kytsa bo asahi ahape: “Batu wasani tsimaha. Ahamysapybyitsa tsimaha” maha. Ninewe ezektsa Sonas nitsasokoze iwatsahi Deus harere bo hyỹ nikaranaha. Abaktsa kytsa Deus wasaniha bo batu yhỹ zikaha. Utakta abazubata kaharere bo batu yhỹ zikaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Hanawa puruze Deus kytsa soho motsasoze Seba tyryktsa pehatsata atatsa mynahyrizikpoze abaktsa kytsa pe: “Ikiahatsa batu ahamysapy tsimaha” my. Atatsa nokponi niukuru. Soromao harere tawaby. Tsihyrinymyrẽta harere piwaby tsihikik. Soromao hyrinymyry baba tisapyrẽna. Kaharere hi abazuba Deus wasaniha soho tisapyrẽnikia — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","— Ihyrikoso sapybara maku ekze poize pitabaka zuba. Maku wahoro wata, atakta ihyrikoso sapybara sapy nikara. Hyrikoso isapybara tseheha bo pitabaka. Taty byryhabyita tu hana eze tabyrywy myziberiki. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Iwaze tapetu isopyk: “Piksizo. Nezeba maku ekze ikzoihik atabo hi piksizo” my. Kyze anasapy bozo. Zumuze batu ihyrikoso sapybara. Iwaze wahoro bo itsarawybyita wata. Tsiziurẽna wahoro itsytsykyha niy. Maku wahoro wata niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Kyze niparakzo. Hyrikoso sapybara nisihobykzo. Ustsa bo, sete ispe my: “Panytaha! Katuk tsimahaktsa. Maku bo tsimaha” mykara. “Atakta anaeze mysapy ziknakara. Ibo pororo tsimykaranahaktsa! Ituk tsimypykyknaha” niy. Iwa hyrikoso sapybara simysapybyikitsa maku bo nisioktyhyryk. Maku tuk mynapykyryknaha. Tapara maku batu iaku ihyrikoso sapybara estuba ituk. Abaka tisukatsihikrẽta babata iakubyikita hyrikoso sapybara oito humo. Iwa ikiahatsa niwatihi batu simysapy tsimaha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Iwaze Sesus myzubaha bo nipamykysokoze taje tukytsa kino niwatihi zumunaha. Batu ibo zikzumunaha, kytsa pokso ba zikzumunaha. Asahi: — Katsaktsa Sesus bo tsimypamykyso tsihikiknaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Iwaze tohi Sesus pe niy: — Aje atukytsa niwatihi ape baze maha. Atuk mopamykyso tsihikiknaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Sesus: — Aty skaraba kajebabatatsa hawa hatsa skaraba katuk kytsa babatsa — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Iwaze tatsyhyrype ty zinymyrykynahatsa nisiwatawy: — Iktsa tsimahaktsa! Asahi kaje watatsa, sihumo kamypokzitsiarẽta kaje watatsa mykara. Asaktsa katukytsa watsa, sihumo kamypokzitsiarẽta katukytsa watsa mykara. ");
INSERT INTO rkbNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Aty zeka kazo bijoikpe eze tu iharere bo zuba hyỹ mykara asahi kajebabaza katukytsa babatsa — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Kyze nawa zuruze Sesus wahoro eze zoi. Karireja pihikzotsabyri baze nidyhyky kytsa nisihyrinymyryky. Deus tyryktsa soho nisihyrinymyryky. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Sizubarẽtsa ibaze niriktotohokonaha. Zihyrizabaiknaha. Iwaze tsaraha bo takoro, anaeze dyhy niy. Kytsa sizubarẽtsa zarape sak eze niriktotohokonaha iharere ziwabykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nisihyrinymyry. Nipamykysoko atahi nisihyrinymyryky. Hawa kytsa mektsaktsa Deus harere humo maha, wastuhu iharere bo hyỹ nikaranaha ustsaktsa batu yhỹ nikaranaha ana humo hi nisihyrinymyryky. Atahi: — Kyze maku waratok bo niy. Atahi nisiparikik. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Nisiparikikze ske sak buruk wastuhu natsukunaha asaktsa piyktsa zumukunaha nisihorozukbaiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Iwaze mektsatu nisiparikikze harahareziktsa bo inatsukunahatsa. Iaksukpe bete tu zipokonaha iwatsahi niakbabaiknaha harahareziktsa humo niakbabaiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Batu siharatatsaka. Iwatsahi niakbabaiknaha haramwe humo niakbabaiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Iwaze ustsa nisiparikikze inikoso bo hi inatsukurunaha. Tahaypykyknahaze, ini saha humo hi batu tahatypyk, niakbabaiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Iwaze ustsa riktsa jytykziuha bo inatsukunahatsa. Niahatsahi tahaypykyknahaze tahasuknaha nipopobaiknaha. Asahi niubaranahaze tirĩta riktsa. Ustsa niwatihi niubaranahaze sesẽta riktsa. Ustsaktsa niubaranahababa sẽ riktsa. Sizubarẽtsa hiba riktsa ty siytyk tisapyrẽna bo nisiparikik. Iwa hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kaharere tsiwabynaha zeka wabyziutaha! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Kyze zinymyrykynahatsa ibo niaha. Asa zuba ibo nipamykysokonaha: — Amy skaraba riktsa soho kytsa tsimysihyrinymyryky — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","— Deus kaharere ahabo piwatawy tsihikik pahahyrinymyry tsihikik. Deus tyryktsa soho pahawatawyky. Ikiahatsa kasoho ezytyk humo yhỹ tsimaha. Deus tyryktsa tsimoziknaha. Ustsa batu. Iwatahi tsasohowy humo tysihyrinymyryky. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Aty zeka kaharere tsikaeni zuba pinymyryky Deus ibo mopamykysotohi my. Atakta pihyrinymyrytsihik zeka mopamykysotohi. Aty zeka kaharere batu ihyrinymyry batu ihyrinymyry za. Batu amy tohi Deus ibo ba zik pamykysozo. Hawa ha ty botu zinymyry ana kino pispiriktsokda. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Iwatahi tsasohowy humo kytsa mysihyrinymyry. Asaktsa iktsazuba maha batu sihyrinymyry. Piwabykynaha zuba batu sihyrinymyry. Kaharere bo batu yhỹ zikaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Hawa Deus sohokotsa Isaijas tubabatu ziwatahaka atsatu mykaranaha. Atahi: “Tsiwabyikiknaha batu ahahyrinymyry hỹ. Tsiksisuparaikiknaha batu ahahyrinymyry hỹ” niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Asaktsa kytsa batu simytsatyhy piwabynahaze tahaty spioki zuzuk sisopyk, iwatsahi batu waby zikaha. Iwa hawa wasani abaka batu iktsa zikaha, hawa wasani abaka batu ziwabynaha. Iktsaziu maha zeka hawa wasani mytsaty maha. Piwabytoktokonaha zeka, simysapybyitsa ty mykaranaha pimoewy tsihikiknaha. Iwaze Deus simysapybyri ty nikaranaha mysiokzohik iwaze mysizororowy — niy. Iwa Deus sohokotsa Isaijas tubabatu ziwatahaka abaktsa kytsa soho, asahi kaharere piwabynaha zuba batu sihyrinymyry tsihikik. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","— Ikiahatsa ahakurẽtsa tsimaha. Hawa motsasoko Deus tyryktsa soho tsipiwabytoktokonaha ahahyrinymyrẽtsa. Hawa mykara ana kino iktsaziu tsimaha ana humo hi ahahyrinymyrẽtsa. Iwatsahi ahakurẽtsa tsimoziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Kaharere tsiwabytoktonahaktsa! Tubabatu Deus sohokotsa, asaktsa Deus harere bo hyỹ nikaranaha niwatihi hawa ikiahatsa tsiwabynaha ana kino ziwaby tsihikiknaha. Batu zikaha. Amy ty iktsa tsimaha ana kino ziny tsihikiknaha. Batu zikaha. Ikiahatsa hi kaharere tsinymyrykynaha. Ikiahatsa hi kabo iktsa tsimaha iwatsahi ahakurẽtsa tsimoziknaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","— Abaka wabytoktoktaha! Amy ty tsasohowy sipariktsa soho pahawatawy. Asaktsa kamyspirikpowy ezytyk humo hyỹ maha zeka Deus tyryktsa moziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Aparakbaha Deus wasania ty piwabynaha. Asahi riktsa watsa ske sak bo inatsukunahatsa. Asahi Deus wasaniha piwabykynahaze Satanas sibo mozumuze Deus harere ziakse. Kytsa sihyrinymyrybyitsatuze Satanas Deus harere ziakse piyktsa hyrity watsa, iwatsahi Deus wasaniha humo batu sispirikpo. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ustsa Deus harere piwabykynaha. Asahi riktsa watsa asahi harahareziktsa bo inatsukunahatsa siharatatsa zuba byitsa watsa. Taparaka wasaniha ziwabykynahaze sakurẽtsa. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Iwaze riktsa wytyk supe bete inatsukunahatsa watsa asahi tsikaeni zuba zinymyrykynaha. Tsihokdaharẽna zeka Deus harere bo batu yhỹ zikaha, iharere humo nispiriktsokdanaha. Ustsa kytsa Deus harere zimyijakanahaze Deus wasania ty zerekeknaha. Deus humo sispirikpobyitsa hi nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ustsa Deus harere piwabykynaha. Asahi riktsa hyrity watsa inikoso bo inatsukunaha. Wasaniha piwabykynahaze tahanamy bo zuba mytsaty mytsaty nikaranaha. Tahanamy mozihikiknaha zuba. Deus harere humo sakubyri zumunahaze ihumo batu sispirikpo. Asahi wihara waha batu jakuk. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ustsa Deus harere piwabykynaha. Asahi riktsa jytykziuha bo inatsukunaha hyrity watsa. Ustsa kytsa Deus harere ziwabynahatsa watsa. Deus wasaniha piwabyziukunaha. Piwabynahaze iharere humo sispirikporẽtsa Deus harere bo hyỹ mykaranaha. Iwatsahi wihara nijakuk. Wastuhu niubaranaha tirĩta riktsa. Ustsa niubaranaha sesẽta riktsa. Ustsa niubaranaha sẽ riktsa. Sizubarẽtsa hiba — niy. Deus tuktsa niwatihi iharere bo hyỹ mykaranahaze simysapyrẽtsa moziknaha wihara nijakuk naha waha. Iwaze hawa kytsa Sesus ihyrinymyrywy ezytyk piwabykynaha iwaze tysihyrinymyryky. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Kyze usa soho sibo nipamykysokozo. Deus tyryktsa soho humo nisihyrinymyryky. Sesus tihi: — Maku tsuhuk bo riktsa nisiparikik. Tiriko riktsa tisapyrẽna waratok buruk nisiparikik. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Unata zurubanahaze isukyrytsa itsuhuk bo izumu. Kytsa papatu towahaditsa nisiparikik, tirikotsa tazahara buruk towahaditsa nisiparikik, nesepykze ziksizo. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kyze tiriko zipokonahaze towahaditsa tuk zipokonaha. Tiriko towahaditsa tuk tayhapykyknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Iwaze tsumuẽhĩtsa tsihitsa pe “O mypehakatsa riktsa tisapyrẽna zuba atsuhuk eze tsiksiparikik. Hawa sa towahaditsa tiriko tuk taypyknaha” niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Kasukyrytsa iwa niy, atahi towahaditsa nisiparikik” niy. Iwaze sitsumuẽhĩtsa tihi: “Towahaditsa sa tahaboboknaha” niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Batu. Towahaditsa tsimysiboboknaha zeka tirikotsa tuk tu tsimysiboboknaha byri tsinasiboboknaha. Siharatatsa tuk tu nisiakwarabaiknaha. Byriktsa!” ");
INSERT INTO rkbNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Abaka niwatihi zitahaypyknaha. Aibani tirikotsa muanahaze tu kytsa mysipurunaha. Ispe my: “Tapara towahaditsa tysiboboknahaktsa! Tsimysiboboknahaze haĩhaĩ tsimaha, izo bo tysioktsotsoknaha. Kyze tirikotsa tysipurunaha katirikododowytsa bo tysizozonaha” my. Yhỹ niaha. — iwa Sesus tiriko soho towahaditsa niwatihi nitsasoko. Aty Deus harere bo hyỹ mykara zeka tiriko watsa. Aty Deus harere bo yhỹ habyi zeka towahaditsa watsa my ana humo hi nisihyrinymyryky. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Kyze usa soho humo sibo nitsasoko. Deus tyryktsa soho humo nisihyrinymyryky. Sesus tihi: — Deus tyryktsa sirikbuzubyitsa watsa. Mostarada riktsa watsa niy. Maku waratok eze ziparikze. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ziktsa buzubyitsa tuze ziponaha. Taypykze hwi puẽtsikbyita mozik. Tisarapatsazubarẽta. Iwaze piyktsa isarapatsa bete tahasukuknaha — niy. Iwa nitsasoko hawa Deus tyryktsa sizubarẽtsa moziknaha. Hawa mostarada nisiubara iwatsa Deus tyryktsa mysiubaraka. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Kyze Sesus usa soho humo sibo nitsasoko Deus tyryktsa soho humo nisihyrinymyryky. Atahi: — Deus tyryktsa atsikara pytowy hyrity waha. Wytyk tiriko tsizubarẽna ty, iwaze ipytowy ty tsikaeni zuba tiriko eze nitsakyky iwaze napytoko. Abahi atsikara ziharazoko — niy. Iwa nipamykysoko Deus tyryktsa soho. — Taparaka Deus tyryktsa hudikhudikwy eze estuba zuba. Aibani nanabyitaba kytsa Deus tyryktsa moziknaha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Iwaze Sesus isoho tsizubarẽna myzubaha bo nipamykysoko. Iwa Deus tyryktsa soho humo nisihyrinymyryky. Kytsa nisihyrinymyrykyze isoho humo zuba nipamykysoko. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Iwa niyze hawa ha ty Deus sohokotsa tubabatu ziwataha atsatu nikara. Deus sohokotsa tihi: — Uta isoho humo kytsa mysihyrinymyryky. Isuknihibyize Deus ispirikpowy iokpitsĩ abaka kytsa mysihyrinymyry isoho humo — niy. Deus sohokotsa, tubabatu ziwataha iwa Sesus atsatu nikara. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Kyze Sesus kytsa sizubarẽtsa nisierekze wahoro bo nitsuk. Zinymyrykynahatsa ibo zumunaha. Ipe niaha: — Hawa ha sa tiriko towahaditsa soho mybo tytsasoziu — niaha. Iwaze sibo nitsasoko. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Aty wata ja: — Tiriko riktsa itsuhuk eze nisiparikik utakta Deus zikpehata kytsa wata ikyzik, tawata atakta riktsa nisiparikik, utakta Deus harere ty mysihyrinymyryky. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Itsuhuk mybarawy ezektsa watsa. Tiriko riktsa tisapyrẽtsa Deus tyryktsa watsa ituktsa maha. Towahaditsa hi Satanas tuktsa watsa. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Sisukyrytsitsa towahaditsa nisiparikik atakta Satanas hyrikoso sapybara pehakatsa watsa. Ziubara mybarawy nepykze wata astatu my. Asaktsa nisiubara mysipurunaha bijoikpe iknyktsa Deus tsumuẽhĩtsitsa watsa maha. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Towahaditsa tysipurunaha izo bo tysioktsotsoknaha iwaze Deus Satanas tuktsa sinini ykarawy bo mysipehahik. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Utakta Deus zikpehata kytsa wata ikyzik, utakta bijoikpe iknyktsa Deus tsumuẽhĩtsitsa mysipeha mybarawy ezektsa bo my. Asaktsa kytsa mysimyiwynahatsa asahi simysapybyikitsa tu nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Izo bo tysioktsotsoknaha, sinini ykarawy bo tysipaparanaha. Anaeze niakmyinahatsa tahatsaputsa ty dydydy mykaranaha. Tahakyrikinaha humo mopuziukunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Iwaze kytsa Deus harere bo hyỹ mykaranaha wasani mykaranaha haramwe haneze watsa. Jekyrikoso watsa maha. Deus tuktsa soho “O ikiahatsa ahamysapyrẽtsa” my. Kytsa niwatihi sibo iktsa mahaze “O simysapyrẽtsa” mykaranaha. Deus tahazo tuk tahawahi mynapykyknaha — Sesus niy. — Kaharere tsipiwabynaha zeka tsiwabytoktonaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Kyze Sesus usa soho humo sibo nitsasoko Deus tyryktsa soho humo nisihyrinymyryky. Atahi: — Deus tyryktsa tisapyrẽna tsipokzitsiarẽna waha ty. Maku tsuhukze tisapyrẽna tsipokzitsiarẽna zikaha. Atsoko ziytykikzo ziokpitsĩhikzo. Tsakurẽta anamy tsizubarẽna okyrysaro humo zihuak. Iwaze itsuhuk tsihitsa bo, itsuhuk okyrysaro humo zihuakak iwaze tisapyrẽna ty tsipokzitsiarẽna ziakse. Ikiahatsa Deus tyryktsa tsimyzihikiknaha zeka sakurẽtsa maku wata, atakta tisapyrẽna tsipokzitsiarẽna ziakse niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Kyze Sesus nitsasokozo: — Deus tyryktsa maku wata atahi peroratsa ty ziakse. Perora haraharezipyryktsa sipokzitsiarẽtsa. Perora tisapyrẽnikia ty zuba ziakse tsihikik. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Perora isapyrẽnikia zikahaze tanamy tsizubarẽna okyrysaro humo zihuakak iwaze perora isapyrẽnikia ziakse. Perora humo tsakurẽta my. Ikiahatsa ahakurẽtsa iwatsa Deus tyryktsa tsimoziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Kyze Sesus Deus tyryktsa tõhõryk waha my. — Piknutsa tõhõryk bo sasabyitsa sizubarẽtsa piknutsa inapupukunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Inahareknahaze piknutsa hokyktsitsa nimyra eze nidyhydyhykynaha. Piknutsa nisinykynaha sisapyrẽtsa ty nataba sisapybyitsa ty natabaha niaha. Piknutsa sisapyrẽnikitsa ty ka peryk bo nisipupukunaha. Piknutsa sisapybyitsaktsa ty ka nisipaparakanaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Mybarawy mopykze iwa my. Bijoikpe iknyktsa Deus tsumuẽhĩtsitsa mozumunaha. Kytsa simysapyrẽtsa asaktsa Deus harere bo hyỹ mykaranaha Deus bo mysioktyhyryknaha. Simysapybyikitsa kino niwatihi metutu mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Simysapybyikitsa izo bo mysioktsotsoknaha sinini ykarawy bo maha. Anaeze simysapybyikitsa tahatsapu ty dydydy mynakaranaha. Tahakyrikinaha humo mynapuziukunaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Kyze Sesus tuk zinymyrykynahatsa pe niy: — Kaharere ja tsinymyrynaha — niy. Yhỹ niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","— Kyze niwazuba asaktsa zinymyrykynahatsa babatsa Deus tyryktsa tuk sihyrinymyrykytsa moziknaha. Wahoro tsihitsa watsa, anamy zozowy eze wahoro ezektsa bo nyny my. Iwata sinymyrykytsa kytsa bo mysihyrinymyrykynaha. Hawa ty botu ziwabynaha Moises harere mysihyrinymyrykyzo kaharere ezytyk humo kino niwatihi kytsa mysihyrinymyryky aba zuba anasoho piwabykynaha — niy. De. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Sesus nitsasobaze anaeze niparak. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Nasare bo niukuru anaeze hi taypykyryk naha bo zumu. Deus wahoro bo nitsuk. Anaeze kytsa nisihyrinymyryky. Ihumo sipybyrẽtsa. Asa tihi: — Atakta hawa zinymyryky. Hawa myhyrinymyrywy babaha ja. Aty ja zispirikpoko. Amy ty kytsa batu zikaha ana ty hi mykara. Aty zikwy sa ituk mynapykyryk — niaha. Iwa asa zuba nipamykysokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","— Hwitsa bikitsa tse ja. Hawa skaraba Maria ije. Hawa skaraba Tsiaku, Sudas, Soses, Simaõ ahatsa itukytsa maha. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ituk kykyryk mytuk mopykyryknaha ja. Iwaze izikwy ihyrinymyrywy babaha iwa hana eze sa zinymyryky — nikaranaha. Iwatsahi ihumo batu sispirikpo. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ihumo kyze ky sisopyk. Sesus ispe niy: — Nanabyitaba kytsa Deus sohokotsa harere piwabynaha. Atakta tahudikhudikwy eze tuze ka batu wasani zikaha. Tawahoro ezektsa tu zeka batu wasani zikaha. Itukytsa tukze ka batu wasani zikaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Sesus Nasare eze tu zikwy batu watawy. Amy ty kytsa batu zikaha Nasare eze tu batu zik. Kytsa ihumo sispirikpobyitsa tu iwatahi zikwy batu watawy. ");
INSERT INTO rkbNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Iwaze Erodes Karireja ezektsa pehakatsa Sesus soho ziwaby. Sesus zikwy humo nikara amy ty kytsa batu zikaha izikwy humo nikara ana ziwaby. ");
INSERT INTO rkbNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Iwaze Erodes tatsumuẽhĩtsitsa pe: — O atahi Suão Batista, inahyrizikpo iwatahi tsizikwyrẽta amy ty kytsa batu zikaha ana ty hi mykara — mytsaty ahabyi nikara. ");
INSERT INTO rkbNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Tapara Suão Erodes pe niy: — Ikia Deus harere humo batu hỹ tsimy. Deus harere humo usta oke ba ziakse. Ikia ja. Atsy oke Erodias tsiakse iwatahi Deus harere bo batu yhỹ tsimy. Batu wasani tsimy — nikara. Ana harere humo Erodes takyriki. Kyze Erodes sodadutsa pe: — Suão tyzioktyhyknaha! Sakyriukrẽnikitsa hurukwy bo tytsahurukiknaha. Anaeze tsipawaranaha — niy. Hyỹ niaha. Iwa hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Erodes Suão zibeze tsihikik. Kytsa Sudeutsa humo batu zik. Kytsa Suão soho: — O atakta Deus sohokotsa my — nikaranaha. Iwatahi Erodes batu tybeze, kytsa mymyhudizunaha pokso. ");
INSERT INTO rkbNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Iwaze Erodes ipurukwy zumuze mytsaty nikaranaha. Tumy tsizubarẽna nikymynahaze. Imyikaha humo tumy tsizubarẽna nikymynahaze sizubarẽtsa siakzohotsa huahua niaha. Sizubarẽtsa imyikaha bo zumunaha. Erodias hi Erodes oke my. Atatsa ste tsarawybara bo kytsa okze nikariki. Kytsa sakzohotsa okze nikariki atatsa humo nakokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Iwaze Erodes ihumo tsakurẽta iwatahi ipe niy: — Amy tsimyzihikik kabo tsimyzapyky zeka atsatu abo nyny my — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Kyze Erodias tatsapusare tsihikik. Suão harere humo iwaze tatsa taste pe: — Suão harek ty tuzapykyky — niy. Iwaze ije harere humo atatsa tihi: — Suão Batista harek ty kabo nyny tsimy. Aidy mypewy eze iharek ty kabo nyny tsimy iwaze nihyrikosokda my iwahi mozihikik — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Kyze Erodes tisukatsihikrẽta. Sudeutsa ihumo ba ziktahakyrinaha. Iharere Deus bo nitsaso, anaharere sakzohotsa okze niwatihi nitsasoko, ana ty kino mytsaty nikara. ");
INSERT INTO rkbNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Iwatahi sodadu pe: — Suão Batista harek ty bokokik ty! Sakyriukrẽnikitsa hurukwy bo tsimy anaeze isoik buruk bokokik ty. Iharekty kabo wabehyrykty — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Yhỹ niy. Suão Batista harek ty bokokik mypewy eze korohyk niy, niytahi atatsa bo wabehyryk niy. Kyze atatsa taje bo nyny niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Kyze Suão zinymyrykynahatsa zumunaha sakyriukrẽnikitsa hurukwy bo zumunaha inury zuba ziytyknaha. Iwaze nitururuknaha Sesus bo zumunaha. Hawa niy Sesus bo nipamykysonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Sesus Suão soho ziwabyze niparak. Pihikzotsabyri bo. Iwaze ituktsa tuk tsaraha bo kokokorohyk, jerukbara bo koikny niaha, batu aty tohi isapy bo niaha. Kytsa sizubarẽtsa isohowy zinymyrykynaha iwatsahi, — O Sesus bo tupaktsa! — niaha. Iwaze ibo hara taba niukurunaha. Zitabakanahatsa tu jerukbara bo tapara zumunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Kyze Sesus tsaraha nipoze kytsa sizubarẽtsa bo iktsa niy. Sihumo tsimypokzitsiarẽta iwatahi simyitsapyritsa nisizororowy. ");
INSERT INTO rkbNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nubaze zinymyrykynahatsa ituk nitsasokonaha: — O Sesus, abaka punubaka batu mydisahawyky. Tykara eze ka batu mydisahawyky. Kytsa tysipehakta! “Ahahudikhudikwy boktsa! Ahadisahawy tyzebykyknahaktsa” tsimy — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","— Kyzekta nabytykara ezetu. Ikiahatsa hi sidisahawy ty sibo nyny tsimaha! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","— Katsa zuba atsikara mytsyhyry wa zuba piknutsa kino petok zuba tsimaha, iwaze kino ke ba nawatsatu ba zik mydisahanaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","— Ana ty hi kabo wabehyryk tynaha — niy. Yhỹ niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Iwaze Sesus sizubarẽtsa pe: — Dyhy dyhy tahaktsa! Parakbaha dyhy dyhy tahaktsa! — niy. Hyỹ niaha. Towahaditsa sisapyrẽtsa bete tahadyhydyhykynaha. Iwaze atsikara ty piknutsa ty iwahaty okok niyze bijo bo iktsa niy. Deus pe: — Ikia humo ka mykurẽtsa — niy. Atsikara zitsakze zinymyrykynahatsa bo nyny niy. — Sibo nynytahaktsa! — niy. Kytsa bo zibiakaknahaze tsizubarẽna niyzikik nyny nikaranahaze kino hawa zuba ja nikara. Piknutsa kino niwatihi, sizubarẽtsa nisisukniwy. ");
INSERT INTO rkbNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kyze kytsa tihi: — O tsikmyksorokbanaha — nikaranaha. Tahadisahabanahaze itsatsakyhy ha jerehe peryktsa eze zipukpukunaha dose peryktsa zinymyrykynahatsa inasihareknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Kytsa, sĩko miutsa tahadisahakanaha. Wytykyryk sihyrytsa iwatsa sizubarẽtsa tahadisahabanaha. Abazuba hiba. ");
INSERT INTO rkbNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kyze aidy Sesus tuk zinymyrykynahatsa pe: — Tsaraha boktsa! Kaharaze pihikzotsabyri koikny typunahaktsa kytsa! Bykyze pomo — niy. Yhỹ niaha. Zinymyrykynahatsa pihik koikny zitsikzanaha. Iwaze Sesus kytsa sizubarẽtsa nisipeha: — Ahawahoro bo tsiksinahaktsa! — niy. Nitururuknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kytsa sizubarẽtsa nitururukbanahaze Sesus tapetu isopyk: — Kazo bo mopamykysoko. — Kyze hara bo nido. Deus bo nipamykysoko. Zunubakaze ata zuba Deus bo nipamykyso. ");
INSERT INTO rkbNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Kyze zinymyrykynahatsa pihik tsikpukteze, ziturikinahaze zopoktsa nabybyknaha. Pihik ihiridawy hyrity waha niyzik zopoktsa humo. ");
INSERT INTO rkbNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Zokorobyitu Sesus sibo zumu. Miwa botu kytsa pihikzotsabyri tsikpukteze sibo niukuru. Pihik tsiksukpe buruk niukuru. ");
INSERT INTO rkbNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Sibo zumubanize sipybyrẽtsa nikaranaha. Sesus pihik tsiksukpe buruk niukuru tapokso kakaik niaha, sipybyrẽtsa nikaranaha: — O myhyrikoso ja — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Sesus tihi: — Ahapyby byihu ja! Ahapunihikrẽtsaktsa kytsa! Uta hiba — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Iwaze Peduru tihi: — O mypehatsa ikia hehỹ my zeka kape: “Pany! Kabo pihik tsiksukpe buruk tynaukta” tsimy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Sesus tihi: — Pany pãoty — niy. Iwaze Peduru tsaraha ekze niparak, Sesus bo pihik tsiksukpe buruk niukuru. ");
INSERT INTO rkbNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kyze zopoktsa bo iktsa niyze tsipybyrẽta iwaze asiba niharazuk: — O kapehatsa katy paikty — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Atsoko Sesus itsyhyrype humo paik niy. Iwaze Sesus ipe niy: — Amy pokso tsapybyrẽta “Sesus batu kamypokzitsiuk” tsimy. Amo skaraba kaharere humo batu aspirikpo. Zopoktsa pokso tsapybyrẽta — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Tsaraha bo kokokorohyk niahaze zopoktsa pyk niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Zinymyrykynahatsa tsaraha eze tu: — Batu aty tohi pihik tsiksukpe buruk zitaba iwaze ikia zuba Deus tse babata. Ikia humo mykurẽtsa hỹ — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Kyze pihikzotsabyri koikny niaha. Byu niahaze Kenasere bo niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Kenasere ezektsa Sesus zinynahaze paikpa nitsasokonaha. Siotutsa pauktsitsa pe: — Panytaha! Ahamyitsapyritsa Sesus boktsa! — niaha. Iwaze kytsa simyitsapyritsa Sesus bo nisioktyhyryknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Sizikeditsa ipe: — O asuk tsihara humo paik tsimaha zeka mykurẽtsa — niaha. Yhỹ niy. Iwaze asaktsa Sesus suk tsihara humo paik niahaze nisizororowy. Simyitsapyritsa sizubarẽtsa nisizororowybaik. ");
INSERT INTO rkbNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kyze wastuhu Pariseutsa Moises harere humo zinymyrynahatsa kino niwatihi Serusarẽhe ikny nitururuknaha. Sesus bo zumunahaze ipe niaha: ");
INSERT INTO rkbNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","— Atuk pinymyrykynahatsa taparaktsa myzotsa sopyk humo batu yhỹ nikaranaha. Tapara tahatsyhyrype piknaha iwaze tadisahanaha. Taha ty tsyhyrype pik byizeka ba zik tahadisahanaha. Asahi taha ty tsyhyrype pikbyitsa tu ziknatahadisahakanaha iwa taparaktsa harere bo batu yhỹ ziknakaranaha. Batu sapy — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","— Ikiahatsaktsa ja. Ikiahatsa niwatihi Deus harere bo batu yhỹ zikaha tahanymyrywy humo zuba yhỹ tsimykaranaha. Batu sapy my Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Deus ahape niy: “Ahazotsa humo tysipokzitsikinahaktsa! Ahazo ahajeza humo kino niwatihi wasani ahasopyk. Atakta tazotsa mysisapy byizeka tysibaik” Deus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ikiahatsa kytsa pe tihi: “O kazo kaje kaokyrysaro ty ahabo nyny mykara. Ana okyrysaro ty Deus bo nyny my iwa zeka ba zahatsumuẽhĩ” — tsimaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Anaty hi tsimytsasokonahaze kytsa bo tsipimyikinaha. Kytsa tahanamy tahazotsa bo pibiak tsihikiknaha. Ahahumo hi batu nyny maha. Iwatsahi ikiahatsa humo kytsa niakmyinaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ahamyspihikbatarẽtsa Deus sohokotsa Isaijas inarokota tubabatu ahasoho ziwatahaka. Hawa ha ty ziwataha wasani. Deus harere tihi: ");
INSERT INTO rkbNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","— Asaktsa kytsa ziharawatakanahatsa watsa “O Deus harere bo zuba hyỹ tsimykaranaha” — mybarapetu nikaranaha. — Kaharere bo batu yhỹ niaha. Hawa ha bo mytsaty nikaranaha mektsatu niy, iwatsahi kaharere bo batu yhỹ. Iwaze ziharawatakanahatsa watsa. ");
INSERT INTO rkbNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Hawa ha ty kabo nitsasokonaha asahi batu ma zikaha. Asahi: “Myharere hi Deus sopyk atsatu maha” iwa kytsa bo mybarapetu mykaranaha — niy. Batu ba tahaharere zuba nitsasokonaha Deus sohokotsa Isaijas Pariseutsa soho tubabatu iwa ziwataha. ");
INSERT INTO rkbNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","11","Kyze Sesus sizubarẽtsa bo huahua niy. Izumubanahaze ispe niy: — Wabyziutaha! Iwaze tsinymyrynaha. Amy ty maku hauk myze ana humo hi ba zikmyi. Batu disahawy humo Deus okzeka imysapybyita niyzik. Batu ba. Hawa ha ty motsasoko, iharere batu mysapy motsasoko zeka ana humo hi Deus okzeka imysapybyita mozik — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kyze ituk zinymyrykynahatsa ibo zumunaha: — Pariseutsa aharere humo batu siakparawy ana kino tsinymyryky ja — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Iwaze Sesus ispe niy: — Pariseutsa hyrinymyrywy iparikihi haratatsa watsa. Hawa kytsa iparikihi haratatsa watsa mysibobokonaha batu iakubarahi zibobokok naha humo anawata Deus sihyrinymyrywy nepyk, batu iharere humo hawa asahi mytsaty nikaranaha zuba. Iwatahi Pariseutsa hyrinymyrywy nepyk. ");
INSERT INTO rkbNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Pariseutsa sihyrizikubyitsa watsa. Ihyrizikubyrita usta ihyrizikubyrita ske piwatawy zeka petoktsa mynarahanaha. Sihyrizikubyitsa petoktsa wytyk hoke bo mynarahanaha. Pariseutsa siwahatsa, kytsa bo mybarapetu mykaranaha iwatsahi Pariseutsa humo amy ty wasani batu hỹ mykaranaha. Iwaze asaktsa Pariseutsa ty arekektaha! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Kyze Peduru tihi: — Asoho hawa tsipihauknaha mybo tytsaso — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","— Ikiahatsa ja. Ikiahatsa myzubaha watsa kasoho batu ahahyrinymyry. ");
INSERT INTO rkbNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Kytsa tadisahakanahaze siworozik bo zuba tasapy. Bykyze pikaranahaze hana bo ja. ");
INSERT INTO rkbNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Amy ty batu imysapybara ty kytsa mozihikiknaha ana soho mytsaty ziknakaranaha, ana humo hi simysapybyitsa niyziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kytsa amy ty batu imysapy mytsaty mykaranaha zeka atsatu mykaranaha. Hawa mytsaty mykaranaha humo kytsa pibeze tsihikiknaha, ustsa okeza piakse tsihikiknaha, ustsa kytsa mysiwo tsihikiknaha ustsa namy piakse tsihikiknaha sitsyhyryboarẽtsa moziknaha. Kytsa mysimyiwynaha sisoho mybarapetu mykaranaha. Siharerewabymybarẽtsa moziknaha hawa mytsaty mykaranaha batu imysapybara humo. ");
INSERT INTO rkbNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ana humo hi kytsa batu simysapy maha, Deus okzeka simysapybyitsa mykaranaha. Kytsa ba zik tahatsyhyrypetsa piknaha Deus okzeka mahani. Asahi ipe: “O ikia zuba tsamysapyrẽnikita” maha. Iwa Deus bo mopamykysokonaha — Sesus niy. De. ");
INSERT INTO rkbNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Iwaze Sesus Tiro bo niparak. Sidõ bo kino niwatihi. ");
INSERT INTO rkbNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kyze wytyk anaezektatsa Sudeubyitatsa tu ibo zumu. Atatsa kakaik niy. Atatsa tihi: — O kapehatsa Deus zipehata Dawi tsekokatsa kahumo tsimypokzitsiarẽta. Kaste sinini mynakara, ihyrikoso sapybara pokso atakta pororo ziknakara iwatatsahi sinini mynakara. ");
INSERT INTO rkbNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Sesus batu iharere ty batu tyso. Zinymyrykynahatsa ipe: — O amy sa myzapykyky ikia atatsa bo nyny tsimyzeka bykyze ipe: nabo pãoty tsimy. Atatsa myhapik ka mynakara batu pyk aha. ");
INSERT INTO rkbNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Iwaze Sesus: — Utakta Deus zikpehata Sudeutsa bo zuba asaktsa hozipyrykza watsa batu siperynymyryhy, nizaranahatsa watsa maha, iwa hozipyrykza watsa. ");
INSERT INTO rkbNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Atatsa ana kino ziwabyze ibo izumu, iokeryk taekaratsa humo puruk puruk niy — O kapehatsa ikia amysapyrẽnikita tyziktsumuẽhĩ ky — niy: ");
INSERT INTO rkbNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Sesus: — Tapara kytsa hyrytsa zitadisahakanaha bykyze zuba kytsa disahawy tsihirik ty tsikuparinitsa bo nyny maha. Tapara sidisahawy ty tsikuparinitsa bo nyny my zeka batu sapy my. Isopyksapybyitsa. Ihyrytsa hi tapara tysidisahawynaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","— O kapehatsa wasape tsiky. Ikia Sudeutsa bo hỹ. Katsaktsa Sudeutsabyitsa tsikuparinitsa watsa, amy ty Sudeutsa ty tsihik byizeka katsaktsa yhỹ tsimaha. Tsikuparinitsa zipyryktsa mesa hwitsabihi pukezi tu asahi sitsatsakyhy arehe ty tahadisahakanaha. Itsatsakyhy inatsukunahaze ana ty hi tsikuparinitsa zipyryktsa tahadisahakanaha katsa kino niwatihi amy ty Sudeutsa batu yhỹ zikaha katsaktsa yhỹ tsimaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","— Aharere wasani my. Kahumo aspirikporẽtatsa iwatatsahi awahoro boktsa! Aste pizororowy ihyrikoso sapybara botu iksiwyhik hana bo ja. Aste tsakurẽtatsa hỹ — Sesus niy. Iwa hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Kyze Sesus niparak Karireja pihikzotsabyri sak bo niukuru. Kyze hara bo nido anaeze nidyhyky. ");
INSERT INTO rkbNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kytsa sizubarẽtsa ibo izumunaha. Siekbyritsa, sihyrizikubyitsa, siharerebyitsa, simyiziubyitsa simyitsapyritsa sizubarẽtsa iwatsa nisioktyhyryknaha, Sesus paukbaze isty dyhy dyhy niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Sesus nisizororowyba. Kytsa ihumo sipybyrẽtsa. Pãozikahabyitsa zitabazonaha, sihyrizikubyitsa iktsazo nikaranaha, simyiziubyitsa nizororobanaha, siharerebyitsa nipamykysozonaha kytsa ana bo iktsa niahaze sipybyrẽtsa. Ana humo hi Deus bo: — Ikia Isareu Deus my, ikia zuba Deus babata ahumo mykurẽtsa — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Kyze Sesus ituk zinymyrykynahatsa bo huahua niy: — Panytahaktsa! Utakta sizubarẽtsa humo kamypokzitsiarẽta. Harakykbyihi katuk zurunaha, batu sidisahawyky niaha. Ispe my zeka: “Tsiksinahaktsa kytsa ahawahoro boktsa” iwa zeka taharapatsapyrispyk ske buruk mynarahanaha iwatahi batu isty peha siwahoro bo. Tapara sidisahawy ty sibo nyny tsimaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","— Hawa skaraba tsimaha. Batu aty tohi sidisahawy ty sibo nyny my. Jerukbara eze batu mydisahawyky. Katsaktsa ba ziksitsumuẽhĩnaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","— Hawa skaraba atsikara — niy. — Nawa, usta tsyhyry humo petok sete atsikara niaha. Piknutsa zipyryktsa kino batu sizuba — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Kyze Sesus kytsa sizubarẽtsa pe: — Wytyk humo dyhy dyhy taha! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Iwaze atsikara sete aha ty okokyk niy, piknutsa zipyryktsa kino niwatihi nisibykyk iwaze Deus pe: — Ikia humo ka mykurẽtsa tsimaha. Ikia hi mydisahawy ty mybo nyny tsimy — niy. Iwaze atsikara zitsakze zinymyrykynahatsa bo nyny niy. Piknutsa zipyryktsa kino niwatihi nyny niy. — O kytsa bo sidisahawy ty nynytaha! — niy. Sizubarẽtsa bo zibiakaknaha tsizubarẽna ty nyny nynyzo niaha. Ziubarawy. ");
INSERT INTO rkbNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Bykyze kytsa: — O mysorokrẽtsa — niaha. Tahadisahabanahaze itsatsakyhy arehe zipupukunaha. Peryktsa bo pukpuk nikaranaha. Iwa sete peryktsa bo zipupukunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Kytsa abazubatsa. Kwatero miu ahatsa kytsa, tahadisahakanaha wytykyryk sihyrytsa ahatsa kino niwatihi iwatsa tahadisahakanaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Iwaze Sesus ispe niy: — Ahawahoro bo tsiksinaha — niy. Iwaze ziksikinaha. Ziksibanahaze tsaraha bo takoro Makadã bo niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Kyze Pariseutsa asaktsa Moises harere sihyrinymykynahatsa, Sadusitsa kino niwatihi Sesus bo zumunaha. Sispirikpobyitsa tu ibo nizokparakanaha. Sesus Moises harere bo batu yhỹ mozihikiknaha iwatsahi nizokparakanaha. Niharapebetsakaknaha. Iwa ipe: — Deus zikwy mybo tsiwatawykta watawy tsimy zeka Deus zapeha iwa katsa tsipinymyrynaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Sesus tihi: — Nubaze bijoikpe tsaririha mozik zeka “O byri hyritsik ba zik nawõ” tsimaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Miwa botuze bijoikpe tsaririha zatata mozik zeka “O aba hyritsik nawõ” tsimaha. Wasani tsimaha. Bijoikpe iwatawy humo ahahyrinymyrẽtsa. Abaka amy ty mykara ana kino batu ahahyrinymyry, kawatahawy batu ahahyrinymyry. ");
INSERT INTO rkbNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Abaktsa kytsa iwatawywy piberikinaha asahi simysapybyikitsa Deus harere bo batu yhỹ nikaranaha. Kape tsimaha “Iwatawy tsimykta” tsimaha. “Batu hỹ” my. Tubabatu amy ty Deus zikwy ziwatawy Sonas bo niy, ana kino pahawatawy ana kino pahahyrinymyry — niy. Sesus niparak asa zuba niriktotohokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Kyze Sesus tuk zinymyrykynahatsa tuk Karireja pihikzotsabyri koikny niaha. Zinymyrykynahatsa tahadisahawy humo nispiriktsokdanaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Sesus ispe niy: — O pykyhytutaha kytsa! Pariseutsa Sadusitsa niwatihi simihipytowy humo pykyhytutaha! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Iwaze asa zuba nipamykysokonaha: — Ana hi nitsaso atsikara humo batu tywabehyk — mytsaty ahabyitsa nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Sesus siharere humo tsinymyrẽta iwatahi ispe niy: — Hawa ha ty skaraba tsimypamykysokonaha. “Katsaktsa atsikara awani iwatahi anapytowy soho nitsaso” tsimaha. Ikiahatsa kahumo batu ahaspirikpoziu, “Sesus myhumo batu tsimypokzitsiuk” tsimaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Amy skaraba batu tsihyrinymyrykynaha. Deus zikwy kabo nyny niy ana bo hi ikiahatsa botu iktsa tsikaha iwatsa tu kahumo batu ahaspirikpo. Hawa ha ty botu ikykara tsispiriktsokdanaha ja. Atsikara mytsyhyry tsawata zitsaktsakze kytsa abazubatsa “sĩko miu ahatsa” bo nyny iky. Hana wa ja itsatsakyhy jereheha ty peryktsa bo tsipupunaha — niy. — Dose peryktsa tsiknasihareknaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","— Atsikara sete zitsaktsakze kytsa abazubatsa kwatero miu ahatsa bo nyny iky. Hana wa ja itsatsakyhy jereheha ty peryktsa bo tsipupunaha — niy. — Sete peryktsa tsiknasihareknaha — niaha. — Ana soho tsikspiriktsokdanaha ja — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","— Amy humo kaharere anapytowy soho batu ahawabyhy. Amy humo batu ahahyrinymyry hỹ. Iktsasokoze Pariseutsa Sadusitsa niwatihi anapytowy humo pykyhytutaha atsikara soho batu tyso sihyrinymyrywy soho pykyhytutaha iky, sihyrinymyrywy anapytowy waha my — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kyze itsaso Pariseutsa Sadusitsa kino niwatihi anapytowy ty batu atsikara soho, sihyrinymyrywy ana soho pykyhytutaha ispe niy. Hawa anapytowy humo atsikara inawerekbaik anawaha sihyrinymyrywy kytsa mysimyiwynaha. Aba zuba sihyrinymyrẽtsa iharere ziwabyziukunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Iwaze Sesus tuk zinymyrykynahatsa tuk Sesareja Piripi hudikhudikwy bo zumubahaninahaze Sesus ispe niy: — Kytsa kasoho paikpa nipamykysokonaha. Utakta Deus zikpehata kytsa wata aty skaraba kahumo maha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","— Wastuhu “O ikia hi Suão Batista” mykaranaha. Ustsaktsa “ata hi Erias” mykaranaha. Mektsaktsa “ikia Seremias” mykaranaha “tozeka ja usta Deus sohokotsa” mykaranaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","— Ikiahatsa ja. Aty skaraba uta ahaokze ka — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Kyze Simaõ Peduru tihi: — Ikia hi Kiristu Deus tse babata. Ikiakta Deus koikny bakta tu zapeha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","— O Simaõ Suãotse ikia tsakurẽta hỹ. Deus zatsumuẽhĩ. Anaharere kasoho kytsa humo batu ahyrinymyry. Deus kazo bijoikpe eze tu anaharere zahyrinymyry. Uta Kiristu Deus zikpehata, ata hi zawatawy hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Uta kino ape Peduru my ikia hi harahare wata my. Hawa ha ty botu nitsaso Deus hi zawatawy ana kino katuktsa sakurẽtsa moziknaha. Hawa wahoro tisapyrẽna my harahare humo, katuktsa sakurẽtsa moziknaha aharere humo wasani. Satanas hyrikoso sapybara niwatihi katuktsa tuk myharape pehakanahaze batu kazikwy humo simyiwy. ");
INSERT INTO rkbNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Aty moparak zeka myhyrizikpyryrykwytsa ty mekta botu nyny my atahi wahoro perytsa. Atawata ikia katuktsa mysipokzitsiki asahi kawahoro wata. Deus tuktsa sopyk sisoho “wasani tsimaha zeka” wasani hỹ. Sisopyk soho “batu imysapy” tsimaha zeka batu imysapy hỹ. Deus hi ahaharere soho “wasani” my — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Iwaze Sesus tuk zinymyrykynahatsa pe — Utakta Kiristu. Abaka ana ty hi kytsa bo soso byitaha! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kyze Sesus tuk zinymyrykynahatsa bo hawa mohyrikosokda soho mypubara ty nitsasoko. Iharere batu tsihokdaharẽna. Atahi: — Uta Serusarẽhe bo my. Anaeze Sudeutsa sistsaikbatsa, taparaktsa Deus wahoro zubata eze ziknapamykysokonahatsa, iwatahatsitsa iwatsa piksukyrykynaha. Sinini mykara. Kytsa pikbezenaha. Iwaze petok puruze Deus mynahyrizikpowy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Iwaze Peduru Sesus zioktyhyryk. Atazubata tu zibetsakak ipe niy: — Awatu tykta! Ana humo kino abo batu mykara, ikia hi batu sinini tsimy iwatahi anatyhi batu tyso — niy. Iwa zibetsakak. ");
INSERT INTO rkbNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Sesus Peduru bo iktsaziu niy. Zipehahik: — Nabo pãoty Satanas. Ikia Deus harere bo batu yhỹ tsimy, hawa kytsa mytsaty mykaranaha ana bo hi yhỹ tsimykara. Ikia kape: “O kytsa pikbezenahaze batu yhỹ tsimy” iwatahi tsikykniki ikia harahare wata ske zihiza — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kyze Sesus tuk zinymyrykynahatsa pe: — Aty katuk babata mozihikik zeka. Atakta pibyituhukutu ta humo tu mospiriktsokda, amy ty imysapybyri kino pimoewy. Pibyituhukutu kytsa pahasapybyikinaha yhỹ tsimaha Deus pokzi sinini tsimykaranaha mohyrikosokdata wa. Hawa sinini mykara atakta niwatihi katuk babata mozik zeka kawata sinini mynakara. Iwatsahi tsikymynahaktsa kytsa! — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Sesus tihi: — Aty “O utakta ba zikyrikosokda iwaze Sesus harere bo batu yhỹ iwaze kytsa ba zikbezenaha” my. Atahi Deus tuk batu tawahi mynapykyryk niy. Atakta hiba katuk babata tu kahumo sinini my zeka atakta Deus tuk tawahi mynapykyryk — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","— Atakta tanamy zuba mytsaty mykara zeka atahi ihyrizikararawy Deus tuk batu tawahi mynapykyryk atahi tisukatsihikrẽta mozik. Tanamy tsizubarẽna nizihikik, anahi zihokzaba. Tahyrizikararawy kino niwatihi mohokda, batu amy tohi sihumo ba zikwak. ");
INSERT INTO rkbNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Utakta Deus zikpehata ahawata myziksizoze kazo zikwy tuk mynasik, bijoikpe iknyktsa Deus tsumuẽhĩtsitsa niwatihi katuk mynasiknaha. Hawa skaraba kytsa nikaranaha mybarawy eze zikzurukunahaze sisoho motsaso. Asaktsa hawa ha ty wasani nikaranaha “O ahamysapyrẽtsa” my. Asaktsa simysapybyitsa nikaranaha. “O ikiahatsa batu ahamysapy” my. Iwa kytsa bo motsasoko. ");
INSERT INTO rkbNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Kaharere bo wabytoktoktaha! Ikiahatsa tazaharaeze tu sihyrikosokda byize tu tapara Deus pehatsa ahawata parakbaha moziknaha ana bo iktsa maha, Deus tyryktsa bo pinynaha bykyze mohyrikosokdanaha hawa ha ty iktsaso wasani my ana bo kino iktsa maha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Iwaze seis ziharamuze Sesus Peduru, Tsiaku itsy Suão iwatsa nisioktyhyryk. Ustsa zinymyrykynahatsa nitarenaha. Iwaze asaktsa harakykbyitsa iapik hara bijobonita bo nidokoknaha. Asa zuba Sesus tuktsa hara bijobonita bo niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Sesus tuktsa ibo iktsa niahaze meky watu tahyrity. Iok haramwe wata niyzik. Tisukbarazarẽta okoroze waha niyzik. Katsaktsa ibarazabaharẽta batu inyhuk. ");
INSERT INTO rkbNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ibaze kytsa petoktsa natakahanaha. Erias, Moises ahatsa, tubabatu nihyrikosokdanahatsa, ituk nipamykysokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Iwaze Peduru: — O mypehatsa katsa ahumo mykurẽtsa tsimykaranaha. Nabytykareze tu tsimytarenaha. Hawa tsimyzihikik zeka ahaparik tsipizinaha harakykbyihi ahaparik tazi, estuba ikia bo, estuba Moises bo, iwaze usta Erias bo iwa — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nipamykysokoze atsoko haramwe zihiza bijo satata haramwe zihiza naikny Deus yksoho ziwabynaha. Atahi ispe niy: — Atakta katse babata ihumo ka kakurẽta hỹ. Iharere tsiwabytoktonaha! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Zinymyrykynahatsa anaharere ziwabynahaze sipybyrẽtsa niyziknaha. Sipybyrẽtsa wytyk bo inarahanaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Sesus sibo zumuze isty tuzu tuzu niy. — Kyiktaha! Ahapyby byihu ja! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Bijo bo iktsa niahaze Sesus bo zuba nikozonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Iwaze hara jobonita ekze inasikzonahaze Sesus: — O jaba tsiknynaha ty ka ja kytsa bo ka soso byitaha. Byi puẽtsik utakta Deus zikpehata kytsa wata mohyrikosokdaze mynahyrizikpoze ana zuba kytsa bo tsimypamykysonaha — niy. Yhỹ niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Kyze zinymyrykynahatsa pe: — Katsaktsa asoho Kiristu Deus zipehata tsimy yhỹ tsimaha. Amy humo asaktsa Moises harere sihyrinymyrytsa tihi: “Tapara Erias myziksizo bykyze zuba Kiristu mozumu”. Amy humo Erias aharaze izumu. Siharere ty mybo tsipiwatawy — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","— “Wasape” nikaranaha. Tapara Erias mozumuze hatsa ty ezytyk tisapyrẽna mokymyky, atahi kaharaze zizokzikik. ");
INSERT INTO rkbNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Aba ahape Erias botu izumu kytsa ity batu sinyhy. Sisukyrytsitsa zimyijakaranaha zibezenaha. Utakta Deus zikpehata ahawata ikyzik iwata sinini my piksukyrikiknaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Kyze zinymyrykynahatsa sihyrinymyrẽtsa niyziknaha. Sesus Erias soho batu tyso, Suão Batista Erias wata isoho nitsaso. ");
INSERT INTO rkbNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Iwaze Sesus Peduru, Suão, Tsiaku ahatsa iwa ustsa zinymyrykynahatsa bo ziksizonaha. Kytsa sizubarẽtsa bo zumuzonaha. Iwaze maku estuba Sesus okeryk taekaratsa humo puruk puruk niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","— O myhyrinymyrytsa katse humo amypokzitsiukta! Atakta iakmyita sinini mykara izo bo naoktsok inarahaikik pihik bo niwatihi inaharazuzukikik ziknakara, iwatahi tsizororowy. ");
INSERT INTO rkbNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Atuk zinymyrykynahatsa bo ikzioktyhyryk batu tyzororowy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Sesus tihi: — O katuk tsinymyrykynahatsa ikiahatsa Deus humo batu ahaspirikpo. Kaharere bo batu yhỹ tsimaha. Iwatsa tu ahatuk mynapykyryk Deus zikwy bo iktsa tsimaha kytsa batu isty tsumuẽhĩ iwatahi ahahumo batu kaku. — Iwaze maku pe: — Pany atse kabo tyzioktyhyk — niy. Yhỹ niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Tatse Sesus bo zioktyhyrykze Sesus ihyrikoso sapybara pe: — Nabo pãoty! — niy. Taharere humo ihyrikoso sapybara ziksiwyhik itse nizororo tsakurẽta niyzik. ");
INSERT INTO rkbNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kyze asazubaze zinymyrykynahatsa ipe: — Amo sa katsa myhumo ihyrikoso sapybara ty batu tyiksiwyhik — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Sesus ispe niy: — Deus humo tsikaeni zuba ahaspirikpo iwatsahi hyrikoso sapybara ba zikponaha. Deus humo puẽtsik ahaspirikpo zeka ihyrikoso sapybara tsimysisukewyhiknaha. Deus humo tsimyspirikpotohinaha zeka amy ty tsimyzapykynaha zeka atsatu ahabo nyny my. Iwa zeka hara jobonita pe. “Nabo pãoty!” tsimaha zeka. Ahaharere humo moparak Deus humo tsimyspirikpotohinahaze batu amy tohi ihokdaha. Tsizubarẽna ahaharere bo hyỹ maha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Kyze Karireja eze Sesus tuk zinymyrykynahatsa nisihyrinymyryky: — Utakta Deus zikpehata ahawata ikyzik aibani kasukyrytsitsa pikbezenaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Pikbezenahaze petok puruze mynahyrizikpo — niy. Iharere humo sisukatsihikrẽtsa niyziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Kyze Sesus tuk zinymyrykynahatsa niukurunaha. Kaparanaũ zumunahaze Deus wahoro zubata okyrysaro bykyktsitsa Peduru pe niaha: — Ahyrinymyrykytsa Deus wahoro zubata okyrysaro ja bykyktsitsa bo nyny my — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Yhỹ niy. Wahoro bo nitsukze Sesus ipe niy: — Simaõ Peduru aty sa kytsa sipehatsa bo okyrysaro ty nyny maha. Situkytsa ja. Bipyritsa ja. Amy soho bo mytsaty tsimykara — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","— O bipyritsa zuba — niy. — Niwazuba! Sipehatsa tahatukytsa siokyrysaro ty sibo batu nyny maha niy. Iwaze situkytsa okyrysaro ty batu nyny maha. Iwatahi utakta Deus tse babata okyrysaro ba nyny zeky, iwatatu okyrysaro ty sibo nyny my. ");
INSERT INTO rkbNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Katsa bykyktsitsa mysoho “O asaktsa Deus harere batu ma maha” nawa batu tyso. Iwaze pihikzotsabyri bo tsimykta! Amyzowy ty pihik bo tu tsimyze taparababa piknu tsimyzezota. Isake ty zokbare tsimyze tsinieru isake eze tsimozikaha, ana ty hi mytsyhyryze Deus wahoro zubata bykyktsitsa bo nyny tsimy — niy. Hyỹ niy. Iwa hỹ niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Iwazebabatu zinymyrykynahatsa Sesus bo zumunaha. Ipe niaha: — Aty skaraba imyhyrizikwani Deus tyryktsa tuk — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Iwaze kyry bo huahua niy. Ibo zumuze situk niriktohoko. Sesus zebyk. ");
INSERT INTO rkbNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","— O zinymyrykynahatsa kaharere bo wabytoktoktaha! Ikiahatsa kino tawa kyrywa zeka anawahi mozihikik. Jabastsa zotsa pe: “Ma” nikaranaha. Amy ty sizotsa mozihikiknaha atsa tu nikaranaha siharere humo, iwa Deus harere bo hyỹ tsimaha iwaze Deus tyryktsa tsimoziknaha. Iwa ma ahabyizeka Deus tyryktsa ba zikyziknaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","— Aty Deus harere bo hyỹ my atahi jabasta wata. Hawa sizotsa jabastsa zipehaka aty tohi Deus myzipehaka atahi Deus tyryktsa tuk myhyrizikwanita mozik — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","— Aty jabasta humo tsimypokzitsiukrẽta, atahi kaharere bo hyỹ my, ihumo kakurẽta. Utakta ihumo kakurẽta Deus kino niwatihi tsakurẽta. Atahi mybarawy bo zikpeha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Jabyitsa kahumo sispirikporẽtsa, aty mysimyiwy zeka iwaze kahumo batu sispirikpo atakta imysapybyita mykara. Harahare ty pisoikaĩnaha iwaze pihik maporik bo tapapykik anaeze moharazukik anatyhi batu sapy my. Atakta jabasta imyitsihikik sinini ykarawy bo pipeha anaeze tawahi mynapykyryk, atahi imysapybyikita babata. ");
INSERT INTO rkbNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Asaktsa ustsa kytsa mysimyi tsihikiknaha Deus sinini ykarawy bo pipehahik. Kytsa kahumo sispirikporẽtsa batu siakparawy iwaze mysimyi tsihikiknaha. Aty kytsa mysimyi tsihikiknaha atahi Deus sinini ykarawy bo mysipehahik. ");
INSERT INTO rkbNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Amy ty atsyhyrype humo imysapybara ty mozihikikze atsyhyrype ty iykzykikty. Hana bo apyry imysapybara ty tsimoparak tsihikze pão pãobyity apyry ty iykzykikty! Deus tuk tawahi tsimypykyryk zeka atsyhyrype estuba zuba iwaze apyry estuba zuba niwatihi ana kino wasani. Ikiahatsa apyrytsa petoktsa atsyhyrypetsa petoktsa iwaze Deus sinini ykarawy bo papeha zeka ana bo hi wasanibara bo tsipasapy. Anaeze izo napokorok ba zikbe. ");
INSERT INTO rkbNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Amy ty imysapybara ty bo iktsa tsimy iwaze tsimyzihikik iktsa iktsabyity. Ahyrizik ty hyrykokik ty. Deus tuk tawahi tsimypykyryk zeka ahyrizik estuba zuba wasani. Ikiahatsa ahyriziktsa petoktsa tsimaha zeka iwaze Deus sinini ykarawy bo papeha zeka ana kino wasanibara bo tsipasapy. Anaeze izo napokorok ba zikbe. ");
INSERT INTO rkbNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","— Pykyhytutaha! Jabastsa humo tsipiwabykynaha! Batu tyso. “O asaktsa siharereharẽtsa” tsimaha. Bijoikpe iknyktsa Deus tuk mopykyryknaha Deus ispe: “Jabastsa humo tysipokzitsikinahaktsa” niy. Iwatsahi jabastsa mynasiperykynaha. — Sesus nisihyrinymyrykyzo. Iwaze hozipyrykzatsa tsihitsa myraratsa humo tsimypokzitsiukrẽta. ");
INSERT INTO rkbNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","— Hozipyrykzatsa tsihitsa, sẽ sizubarẽtsa hozipyrykzatsa my, estuba myzara zeka hawa sa my. Ustsa ty ka arek niy, hara buruk zitahadisahakanaha iwatahi nizarata hapik niukuru. Nizarata piberiki tyberi beri wasani ibo zuk niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Myzikahazoze tsakurẽta niyzik. Ustsaktsa batu zara, iwaze nizarata humo tsakurẽta. ");
INSERT INTO rkbNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Iwatahi ahazo bijoikpe ezekta. Jabyitsa estuba ba zikzara — niy. — Deus hozipyrykza tsihitsa wata, aty Deus harere bo yhỹ habyi zeka izarata wata jabastsa hozipyrykzatsa watsa ahazo estuba zuba ba zikzara hozipyrykza nizarata watsa. Kytsa iharere bo hyỹ maha mozihikik — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","— Kyze Sesus tukta pasapy byizeka ituk tsimypamykysokonaha petok zuba typamykysonahaze imysapybara ty ibo tsipiwatawyky. “Amysapybyi ty tytsaso tsimy” tsimaha. Aharere bo yhỹ my zeka wasani my. Atakta “O uta batu kamysapy my kasapybara ty pimoewy” my. Iwaze ata hi Sesus tukta babata iwatsahi ahakurẽtsa tsimaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Abo batu yhỹ my zeka ustsa Sesus tuktsa atuktsa mysioktyhyryk. Ibo mysapybara soho tsimytsasokozo. Hawa tsimyzeka Deus harere bo hyỹ tsimy. Iharere tihi: “Maku pisapybyize batu ta zuba zikumu ustsa kytsa aharere piwabynaha. Ustsa kytsa anaharere piwabynaha amy ty wasani zuba mopamykysokonaha iwa ustsa kytsa pokso batu mybarapetu maha.” Iwaze amy ty wasape zuba kytsa motsasonaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","— Atakta maku ahaharere bo yhỹ ahabyizeka imysapybara humo ka iwaze Sesus tuktsa ziknapykyknahatsa bo tsimytsasoziunaha. Kyze Sesus tuktsa maku pe: “O ikia amysapybara ty batu moewy” maha. Atakta maku Sesus tuktsa harere bo batu yhỹ my zeka ahaokze ka Sudeutsabyitsa ahasopyk ispirikpobyita tu okyrysaro bykyktsa ahasopyk. ");
INSERT INTO rkbNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Iwaze ahape: — Sesus tuktsa tahasopyk tyhi nikaranaha sisoho “wasani tsimaha zeka” wasani. Deus niwatihi ahaharere wasani my. Ustsa Sesus tuktsa tahasopyk tyhi nikaranaha sisoho “batu imysapy” tsimaha zeka batu imysapy. Deus niwatihi ahaharere soho wasani my — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","— Pahahyrinymyrykyzo mybarawy ezektsa petoktsa zuba amy ty Deus bo myzapykykynaha atsa ty ty mytsaty mykaranaha iwaze Deus kazo siharere piwabytokto amy ty myzapykykynaha atsatu sibo nyny my. ");
INSERT INTO rkbNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Katuktsa petoktsa harakykbyihi niwatihi mynakypyknaha zeka kahumo simypokzitsirẽtsa, Deus bo myzapykykynahaze uta sipauk baze mynapykyryk — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Peduru Sesus baze babatu ipe niy: — O mypehatsa! Usta atukta kabo piksapybyriki zeka hana wa ja piokzohik. Imysapybyita tuze sete mykara zeka nawa ha sa piokzohik — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","— Ba sete humo tsipiokzo tsimynakara. Imysapybara ty watu tsipiokzoikik. ");
INSERT INTO rkbNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Kyze Sesus usta soho humo nipamykysoko. Deus tyryktsa soho humo nisihyrinymyry. Hawa kytsa simysapybyikitsa tu nikaranaha sibo mysiokzoikiknahaze tu nisihyrinymyryky. — Kyze ipehakatsa tapetu isopyk: “Katsumuẽhĩtsitsa hawa sa mykaranaha sibo iktsa my. Sihyriziktsokzawytsa ty pykyhytu maha zeka iktsa myze” niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ana hi pikymyze kytsa tsumuẽhĩtsa estuba ibo zioktyhyryknaha. Atakta okyrysaro tsizubarẽna ziakse, tsizubarẽna hỹ, iwatahi ana hi ziserezo. ");
INSERT INTO rkbNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Atakta ipehakatsa bo batu tyserezo batu ziky. Iwaze ipehakatsa kytsa pe: “Atakta, taoke ty, tahyrytsa ty, iwatsa mysioktyhyryk katsyhyryze piktsumuẽhĩkĩnaha kyze inamy tsizubarẽna zeka okyrysaro humo tyzihuaknaha! Iwaze okyrysaro ty kabo nyny tynaha hawa ziakse zeka piserezo” niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Iwaze atakta ipehakatsa iokeryk taekaratsa humo puruk puruk niy. Ipe niy: “O kapehakatsa kahumo tsikpokzitsikta! Ahyrizikbarasorokokta aokyrysaro ty ka abo nynyrezo my” niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Iwaze ipehakatsa ana harere ziwabyze imypokzitsi zumu. Atahi: “Okyrysaro ty kabo tysizotyk iwatatu mahani ziky” niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Iwaze maku zoihik. Niparakze usta itukta tsumuẽhĩtsa zihobyk. Atakta okyrysaro tsikaeni zuba ibo zisirezo. Iwaze isoik humo nizobatsik zisoikzyzyky. “Okyrysaro ty kabo tysizotyk kabo nynyty” niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Kyze atakta okyrysaro tsikaeni zuba zisirezo iokeryk taekaratsa humo puruk puruk niy. Atahi: “Ahyrikbarasorokokta! Aokyrysaro ty abo nyny my” niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Batu! Abaka kaokyrysaro ty kabo nyny tsimy” niy. Iwaze okyrysarobyita hi sakyriukrẽnikitsa hurukwy bo zioktykyryk. Nyny zikybyikita pe: “Anaeze tutare. Kaokyrysaro ty kabo nyny tsimyze tu tsimyzoizo” niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kyze ipehakatsa ustsa tsumuẽhĩtsitsa maku itukta zipehahik sakyriukrẽnikitsa hurukwy bo okyrysaro tsikaeni humo zuba iktsa niahaze tahakyrikinaha. Iwaze sipehakatsa bo niaha. Hawa ja nyny zikybyikita soho ibo nipamykysokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Iwaze ipehakatsa tihi: “Nyny zikybyikita kabo tyzioktyhykta!” niy. Izumuze ipe: “O ikia iakmyita! Okyrysaro ty nynyhabyita tu mahani iky. Ikspiriktsokda ahuak ty kabo batu nynyrezo. Tsikzapykykze ahuak ty mahani iky. Ikia ja. ");
INSERT INTO rkbNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Amo sa atukta humo kawata batu amypokzitsiu. Utakta ahumo kamypokzitsiarẽta ikykara iwatahi ikia kino atukta humo amypokzitsiarẽta tsimy ikia batu kawata tsimykara” niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ipehakatsa ihumo takyriki. Iwatahi kytsa pe “Atakta maku sakyriukrẽnikitsa hurukwy bo tyoktyhyryktaha! Ihuak ty kabo nynyrezo my zeka myzoik anaeze sinini mynakara” niy. Deus ahasapybyitsatu tsikykaranaha pahaokzohik iwaze ikia ustsa kytsa simysapybyikitsa tu nikaranaha tsimysiokzohiknaha niwatihi. ");
INSERT INTO rkbNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Iwa Sesus nipamykysoko: — Kazo bijoikpe eze tu nawa ahasopyk my. Ikiahatsa ahatukytsa simysapybyikitsa tu nikaranaha isty okzo byizeka kazo niwatihi ahamysapybyitsa tu tsikykaranaha batu pahaokzo — Sesus niy. Iwatsahi ustsa kytsa simysapybyikitsa tu nikaranaha tsimysiokzohiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Sesus nisihyrinymyrybaze Karireja ekze niparak. Sudeja bo buburu Sorodão inarokota koikny zitsikza. ");
INSERT INTO rkbNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kytsa sizubarẽtsa iapik niukurunaha, asaktsa simyitsapyritsa nisizororowyba. ");
INSERT INTO rkbNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Kyze wastuhu Pariseutsa ibo zumunaha. Asaktsa Sesus nizokparakanaha Sesus Moises harere bo batu yhỹ ana hi mozihikiknaha iwatsahi piwabytoktokonaha. Kyze ipe niaha: — Maku taoke moewy zeka Deus harere bo ja yhỹ my — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Sesus ispe niy: — Deus harere humo tsahahyrinymyrẽtsa. Taparaka Deus mybarawy nizukni maku wytyk ahatsa nisisukni. Nisisuknize maku wytyk piakse zeka iwahahi Deus mozihikik. ");
INSERT INTO rkbNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Iwatsahi kytsa tahazotsa bara botu tahasapynaha, tahaoke tuk zuba tahasapynaha. Isukzata batu ata zuba mozuru harapetok mozurukunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Iwatsahi Deus okzeka estuba zubata wata my. Deus tihi petoktsa nisisukni iwatahi batu aty tohi sibo ziky. Batu aty tohi zipyriryky. Ustsa kytsa okeza ziknasipyrirykynaha zeka iwa metutu mykara — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Kyze Pariseutsa: — Yhỹ Moises harere ziwatahaka maku taoke perek tsihik zeka tapara atatsa soho papeu humo piwatahaka. Atahi: “Utakta kaoke perekek abaka ikia batu kaoke tsimy.” Bykyzehu atatsa perekek za niy. Moises iwa niy iwatahi maku taoke zerekek niy — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Sesus: — Batu. Moises ana kino ziwatahaka hawa Deus mozihikik humo batu yhỹ tsikaha. Ikiahatsa tsikauktsĩnaha, hawa Deus mozihikik batu yhỹ tsikaha hawa ha Deus mozihikik mybarawy nizuknize batu ahawabyhy. ");
INSERT INTO rkbNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Abaka ahape: Aty taoke pimoewy zeka papeu ty atatsa bo nyny my, papeu tyhi “Utakta kaoke pe: ‘nabo pãoty!’ ” my ana hi batu mysapy my. Atatsa mekta botu zeka iwaze tabarikta perek zeka yhỹ my. Iwaze maku atatsa pe: nabo pãoty wasani za. Aty mektatsa botu tasukza zeka Deus iozeka imysapybyikia ty mykara. ");
INSERT INTO rkbNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Iwaze zinymyrynahatsa. — Aharere bo yhỹ tsimaha zeka tsihokdaharẽna, iwatsahi katsa mysukza byizeka wasani my, katsa zuba tsinapykyryknaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Sesus ispe niy: — Kytsa kaharere bo yhỹ maha zeka tsihokdaharẽna batu sizuba pinymyrykynaha. Deus hyrikoso zuba kytsa kaharere mysihyrinymyryky. ");
INSERT INTO rkbNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Wastuhu kytsa sihyrytsabyitsa humo batu tahasukza niaha nipupurukuknahaze iwa niaha. Ustsa kytsa sihyrytsabyitsa humo kytsa sirikara ezektsa bobokohotsa iwatsahi ba zik tahasukzanaha. Ustsa kytsa Deus tsyhyryze batu tahasukzanaha. Tapara Deus tsumuẽhĩkĩ iwatsahi batu sisukza tsihik. Deus zuba kaharere ty kytsa mysihyrinymyryky. Aty kaharere bo hyỹ my iwaze ba ziksukza wasani mykara. Asaktsa kaharere tsihokdaharẽna zeka iwatsahi tahasukzanaha wasani mykara naha niwatihi — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kyze wastuhu kytsa tahahyrytsa Sesus bo nisioktyhyryknaha. — O Sesus myhyrytsa humo paik tsimyzeka mykurẽtsa. Deus bo sitsyhyryze tsimypamykyso zeka tisapyrẽna my — niaha. Batu ibo zuk niaha. Sesus tuk zinymyrykatsa sisakparẽtsa sizotsa nisibetsakaknaha. — O nabo tsiksizonahaktsa! — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Sesus ana humo ziwabyze takyriki. Sesus: — O batu “Nabo tsiksizonahaktsa!” batu tahaktsa! Jabyitsa uta kabo tynasioktyhyryknahaktsa! Deus tyryktsa jabyitsa watsa. Jabyitsa kino: yhỹ sisopyk. Jabyitsa watsa zeka, Deus pe: yhỹ tsimaha. Deus pe: yhỹ ahabyi zeka ityryktsabyitsa tu — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Sesus sihyrytsa nisibykyk sihumo paik niy. Sipokzi Deus pe: — O sihyrytsa tysipokzitsikikta kazo! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Iwaze mykyryburukta Sesus pauk baze rikto, ipe niy: — Myhyrinymyrykytsa. Hawa sa mykara iwatahi mohyrikosokdaze uta Deus tuk kawahi mynapykyryk — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Sesus ipe niy: — Hawa amy ty tisapyrẽna soho tsikzapykyky. Deus zuba tsimysapyrẽta. Deus tuk awahi tsizasapy tsihikik zeka iharere bo hyỹ tsimykara, Moises hyrinymyrywy bo yhỹ tsimykara — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","— Moises hyrinymyrywy bo yhỹ mynakara — niy. Sesus tihi: — Ba zibezenaha. Mektsa okeza ba ziksipyriryknaha. Usta namy ty hyryk hyryk byitaha. Kytsa soho ba zikspihikbataka. ");
INSERT INTO rkbNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Azotsa humo awatu ty atukytsa tysipokzitsiki. Aotutsa pauktsitsa humo tynasipokzi tsihikik awata tynasipokzitsiki! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","— Uta jabasize tu aharere humo wasani ziknakara. Amo tohi my, usta harere bo yhỹ — mykyryburukta niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","— Tsimysapyrẽta tsimyzihikik zeka anamy ty nynybaik anamy ty okyrysaro humo huak ty! Iwaze aokyrysaro ty sinamybyitsa bo nynybaik tsimy iwaze anamy hi bijoikpe eze tu tsimy. Anamy hi mynapykyryk ikia Deus tuk tsimynapykyryk. Bykyze Pany! Kapikta tynao — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ana harere ziwabyze tisukatsihikrẽta niyzik. Tsinamyrẽta hi tanamy pokzi tsiwy tuk batu yhỹ niy iwatahi batu iaku. Sesus pauk baze tatu niparak. ");
INSERT INTO rkbNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Iwaze Sesus tuk zinymyrykynahatsa pe niy: — Sinamynikitsa humo ka Deus tyryktsa moziknaha tsihokdaharẽna. Asaktsa tahanamy bo zuba mytsaty mykaranaha, iwatsahi Deus harere bo hyỹ maha humo tsihokdaharẽna. Katukta babata mozik tsihokdaharẽna. ");
INSERT INTO rkbNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Tsihokdaharẽna sirara kamero inarokota mysukwowowy ispioke buruk mytsuk. Uta ahape tsinamyrẽta Deus harere bo hyỹ mynakara iwaze katukta babata mozik ana hi abazuba tsihokdaharẽna — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Zinymyrykynahatsa ana ziwabykynahaze sipybyrẽtsa. Sinamyrẽtsa Deus bo yhỹ aha byizeka batu aty tohi iharere bo yhỹ my. — Batu aty tohi Deus bo yhỹ mynakara itukbabata za. Batu aty tohi Deus bo myzioktyhyryk ja — mytsaty ahabyi nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Sesus: — Kytsa asazubaze Deus harere bo hyỹ ana kino batu zikaha. Deus tuk batu amy tohi ihokdaha. Ba hawa tohi zikzukninaha, atahi kytsa mysitsumuẽhĩ iwatsahi iharere bo hyỹ maha. ");
INSERT INTO rkbNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Kyze Peduru tihi: — Katsa mynamy tserekbaiknaha ikia tuk tsimyzurukunaha. Hawa Deus mymysapywyky — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Kaharere wasani my. Wabytoktotahaktsa! — Hawa Deus pahasapywyky ahabo motsaso. Utakta Deus zikpehata ahawata ikyzik mybarawy bo mynasikzoze kytsa mysipeha, ikiahatsa katuk ahadyhywytsa bete modyhydyhynaha. Sizubarẽtsa katuk mysipehakanaha mybarawy ezytyk eze Isareu siparakbahatsa dose mysipehaka ikiahatsa tsiktsumuẽhĩnaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","— Aty tawahoro perek zeka katukta mozik, atakta Deus wasaniha humo tispirikporẽta babata. Atahi abaka sẽ sizubarẽtsa wahoro ty nyny mykara. Iwata aty tazikeditsa myserekek zeka tatukytsa, taje, tazo, tahyrytsa iwatsa kapokzi myserekba zeka katukta babata mozik. Ustsa zikeditsa watsa nyny my. Aty tatsuhuk perekek zeka kapokzi katukta babata mozik usta ty itsuhuk ty nyny my. Deus baze tawahi mynapykyryk. Isapyhaty ibo nyny my. ");
INSERT INTO rkbNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Sinamyrẽtsa tihi: “O katsaktsa myhyrizikwanitsa Deus tyryktsa tuk tsimaha” mytsaty ahabyi mykaranaha. Batu. Sinamybyitsa tihi: “O katsaktsa myhyrizikwybyitsa zuba tsimaha” mytsaty ahabyi mykaranaha. Asahi myhyrizikwanitsa Deus tyryktsa tuk maha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Sesus usa soho nipamykysokozo. Hawa Deus isapyha ty ityryktsa bo nyny my ana soho humo nisihyrinymyry. Atahi: — Miwa botu maku duabohotsa tsihitsa kytsa bo niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Iwaze kytsa pe: “Duabohotsa sukpesapy humo tahaktsa! Kyze haramwe punubaze ihuak ty okyrysaro ty ahabo nyny my” niy. Yhỹ niaha. Iwaze duabohotsa bo niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Nazotoktokoze ustsa kytsa bo asahi niriktohokonaha zuba. Ispe niy: ");
INSERT INTO rkbNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","“Duabohotsa sukpesapy humo tahaktsa! Haramwe punubaze ihuak ty okyrysaro ty ahabo nyny my” niy. Yhỹ niaha. Iwaze duabohotsa bo niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Iwaze niparak. Duabohotsa tsihitsa tokbaha astatu niy. Tykboze astatu niy. Ustsa kytsa duabohotsa sukpesapy humo nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Nubaze niparakzo. Kytsa zihobyk asaktsa niriktohokonaha zuba. Ispe niy: “Amo skaraba tsimyriktoriktohokonaha zuba” niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Batu aty tohi mype ‘Katsyhyryze sukpesapy humo tsimaha’ iwatsahi tsipiperykynaha zuba” niaha. Tsihitsa ispe niy: “Duabohotsa sukpesapywy humo tahaktsa!” niy. Yhỹ niaha. Iwaze duabohotsa bo niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Haramwe zunubakaze duabohotsa tsihitsa itsumuẽhĩtsa huahua niy. Ipe: “Kytsa duabohotsa sukpesapy humo mykaranahatsa bo huahua tykta! Ihuak ty okyrysaro ty sibo nyny tsimy. Tapara asaktsa kytsa nubaze izumunaha. ‘Asahi tapara siokyrysaro ty sibo nyny tsimy’ ” niy. Hyỹ niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Iwaze asaktsa kytsa nubaze zuba duabohotsa bo zumunaha, sitsumuẽhĩtsa bo zukzuk niaha. Estuba estuba zuba ihuak ty okyrysaro ty sibo nyny niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Taparaktsa kytsa asaktsa zokorobyituze sisukpesapy humo nikaranaha tahapetu zuba nikaranaha: “Duabohotsa tsihitsa okyrysaro ty puẽtsik mybo nyny my” mytsaty ahabyitsa nikaranaha. Zumunahaze estuba zuruze okyrysaro ty ihuak ty sibo nyny niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Siokyrysaro ziaksenaha. Iwaze tsihitsa soho zisapybyrikinaha. Asa tihi: ");
INSERT INTO rkbNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Asaktsa kytsa nubaze zuba duabohotsa bo zumunaha tsikaeni zuba sukpesapy humo nikaranaha. Katsaktsa zokorobyitu sisukpesapy humo tsikykaranaha, haramwe buruk tu sisukpesapy humo tsikykaranaha. Okyrysaro ty sibo nyny tsiky atsa tu myokyrysaro my” niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Tsihitsa estuba maku pe: “Katukta wabyty! Uta ahaty batu spihikbata, zokorobyituze aokyrysaro soho iktsaso, yhỹ tsiky atsatu nyny my. Anaharere estuba estuba ziwaby. Iwatahi tsiksapybyikize batu mysapy my. ");
INSERT INTO rkbNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Abaka aokyrysaro tsiakse awahoro bo tsiksikta! Uta tatihikta siapiktsa bo okyrysaro pinyny tsihikik aokyrysaro atsatu my. ");
INSERT INTO rkbNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Amy ty kaokyrysaro tuk mozihikik ana ty hi mykara wasani my. Kahumo ahazokdiharẽtsa iwatatu kamysapyrẽta” niy. Uta sizubarẽtsa bo okyrysaro ty nyny my. Kytsa nubaze zumunaha okyrysaro estuba zuruze ihuak ty sibo nyny my. Deus tsimysapyrẽta isapyha ty kytsa bo nyny my. Isapyhaty ahabo nyny my tytsumuẽhĩ habyita humo — anahi Sesus nisihyrinymyry. ");
INSERT INTO rkbNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Iwa Sesus nipamykyso Deus tyryktsa soho. Tapara Sesus: — Aty sa kytsa katyryktsa tuk myokzeka “O asaktsa simyhyrizikwanitsa maha” mytsaty ahabyitsa mykaranaha. Sinamybyitsa maha. Aty sa kytsa tihi “O sinamybyitsa maha” simyhyrizikwanitsa maha — niy. Iwaze tasoho ty nitsasoko. Sesus abazubata myze wastuhu ituktsa itsyhyryze tarabaja mynakaranaha batu simyhyrizikwabyitsa maha. Ustsa ituktsa itsyhyryze tarabaja tsikaeni zuba, sihyrizikwanitsa maha. Hawa mozihikik ihuak ty sibo nyny my. ");
INSERT INTO rkbNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Kyze Sesus tuk zinymyrykynahatsa Serusarẽhe bo niukurunaha. Niukurunahaze asa zuba nipamykysokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Sesus: — Abaka Serusarẽhe bo tsimykurunaha. Anaeze utakta Deus zikpehata hi ahawata ikyzik taparaktsa Deus wahoro zubata ziknapamykysonahatsa ustsa asaktsa Deus harere ziwatahakanahatsa sibo hi pikoktyhyryknaha, asahi: “O atakta tybeze” maha. Iwa kasoho motsasonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Bipyritsa bo pikoktyhyryknaha, asaktsa pikmyijakanaha. Pikikinaha. Iharapatawyhyta bete pikyriziknaha iwa pikbezenaha. Iwaze petok puruze Deus hi myzihyrizikpowy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Kyze Sebedeu oke tahyrytsa tuk Sesus bo zumukunaha. Atatsa tasopyk ty hi iokeryk taekaratsa humo puruk puruk niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Sesus ipe niy: — Amo. Atatsa: “Ikia aparakbaha abazubakta tsimozikze kahyrytsa abaze dyhy maha. Estuba apanuryk taba dyhy my. Usta apawazo taba dyhy my ana hi mozihikik” — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Sesus Tsiaku itsy Suão kino niwatihi ispe: — Amy ty tsimyzapykykynaha batu ahahyrinymyry. Sinini mykara. Ikiahatsa ja. Kawata sinini tsimykaranaha ja. Pikbezenahaze ikiahatsa ja. Kawata pahabezenaha zeka ana kino ahapunihiku ja — niy. Yhỹ niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","— Kawata sinini tsimaha. Aty kabaze dyhy my batu tyso ziky. Aty kapanuryk taba aty kapawazo taba dyhy dyhy maha ana kino ba ziktsaso. Deus zuba ana hi motsaso atahi mysiwatawy asaktsa kabaze dyhy dyhy maha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ustsa zinymyrykynahatsa des ana hi ziwabynahaze taokanikinaha. Tsiaku itsy Suão sihumo niwatihi sisakparẽtsa. ");
INSERT INTO rkbNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Iwaze Sesus tuk zinymyrykynahatsa nisihuahua. Izumubanahaze ispe niy: — Bipyritsa pehatsa asaktsa Deus humo batu sispirikpo kytsa mysipehakanaha ziknakaranaha, siharere pokso kytsa hyỹ ziknakaranaha ana humo ahahyrinymyrẽtsa. ");
INSERT INTO rkbNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ikiahatsa ahatuk batu. Aty mypehatsa ahatuk mozihikik atakta sizubarẽtsa mysitsumuẽhĩ tsihikik. ");
INSERT INTO rkbNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Aty myhyrizikwanita ahatuk mozihikik, atakta ahatsyhyryze tarabaja mykara. ");
INSERT INTO rkbNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ikiahatsa iwa tsimyzurukunahaze kawata tsimoziknaha. Utakta Deus zikpehata mybarawy bo iknasik ahawata ikyzikze kytsa bo mysitsumuẽhĩ, iwaze aparakbaha Deus tuk tahawahi mynapykyryknaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Kyze Sesus tuk zinymyrykynahatsa tuk Serikoho bo nitururuknahaze kytsa sizubarẽtsa iapik niukurunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Kytsa petoktsa sihyrizikubyitsa ske eze nidyhydyhykynaha. Kytsa ske buruk nikurunahaze ispe: — Mybo ja mybo ja — nikaranaha. Sihyrizikubyitsa Sesus tuk zinymyrykynahatsa ziharamukunaha ana ziwabynaha. Iwaze asaktsa huahua niaha: — O Deus zipehata mywata Dawi tsekokata myhumo tymypokzitsiukta! Tymytsumuẽhĩkĩkta! — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kytsa sizubarẽtsa piharamunaha iwatsahi nisibetsakaknaha. — O akso byitaha! — nikaranaha. Sisakparẽtsa nikaranaha. Asahi opykani hua huazo niaha. — O Deus zipehata Dawi tsekokata myhumo tymypokzitsiukta! Tymytsumuẽhĩkta! — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Sesus pyk niy: — Panytaha! Uta kabo tynasioktyhyknaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ibo zumunahaze ispe: — Amy skaraba, hawa sa my — niy. — O batu iktsa zikaha. Myhyriziktsa tysizororowykta! — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Sesus sihumo tsimypokzitsiarẽta nisihyriziktsa tsika tsikaka. Atsoko iktsazo niaha. Nihyriziktsa zororonahaze iapik niukurunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Kyze Sesus tuk zinymyrykynahatsa Serusarẽhe ske buruk niukurunaha. Betepake bo zumunaha. Betepake Oriwereja hwitsa hara baze my. Zumubahaninahaze Sesus tatuktsa petoktsa nisipeha: ");
INSERT INTO rkbNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","— Nabo sihudikhudikwy bo pãotaha! kytsa. Atsaezubaha eze tsimypupunahaze pikuza tsipipiktumunaha. Itse tuk. Atatsahi isoikãihikta tsipinynaha. Satsukyktaha! Kabo tyzioktyhyknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ustsa kytsa: “Hawa sa tsimykaranaha” maha zeka. “Mypehakatsa tihi mype niy pikuza kabo tyzioktyhyknaha” tsimaha! “Bykyze ahabo tasirezonaha” tsimahakta — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Tubabatu Deus sohotsa isoho botu ziwataha aba zuba atsatu iwaze ana harere wasani niy. Atahi: ");
INSERT INTO rkbNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","— O Serusarẽhe ezektsa ahapehatsa ahabo mozumu. Batu imyi pikuza tsibik bete modyhyky Deus sohotsa niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kyze zinymyrykynahatsa petoktsa Sesus harere bo yhỹ niaha. Atsatu niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Pikuza ty itse ahatsa ty Sesus bo nisioktyhyryknaha. Tasuk pikuza bete zizozokonaha. Sesus ibete tadyhyhyk. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Wastuhu kytsa tahasuk ske buruk zipaparakanaha. Tsarakzapatsa jerukbara eze ty bokok bokok ky niaha ana humo kino niwatihi ske buruk nisipaparakanaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Kytsa Sesus iharaze kazi nikaranaha, kytsa iapiktsa niwatihi sizubarẽtsa kazi nikaranaha: — Sesus Deus tuk niapykyryk. Atahi Deus zipehata mywata niyzik Dawi tsekokata. Deus bazekta tu mybo inasik. Atakta tsimysapyrẽta. O mykurẽtsa — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Sesus Serusarẽhe bo nitsukze kytsa paikpa mytsaty nikaranaha. Serusarẽhe ezektsa tihi: — Amakata skaraba — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","— Atakta Sesus, Deus sohokotsa Nasare ezekta. Nasare Karireja eze. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Kyze Sesus Deus wahoro zubata bo nitsuk. Anaeze kytsa myraratsa ty hozipyrykzatsa ziknasihuakaknaha okyrysaro humo. Asaktsa nisiksiwykik. Atsoko nitururuknaha. Asaktsa okyrysaro ty nisihuakaknaha hwibihitsa nisitsihipetotokorok. Asaktsa amytudutsa nisihuakaknaha sidyhywytsa nisitsihipetotokbaik. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Deus harere tihi: — “Kawahoro zubata anaeze kytsa sizubarẽtsa kabo mynapamykysonaha” ziwataha. Ikiahatsaktsa kawahoro sitsyhyryboarẽtsa parik waka tsimyzahuaknaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Kyze sihyrizikubyitsa, simyiziubyitsa kino niwatihi ibo Deus wahoro zubata isturupeze bo zumunaha. Nisizororowybaik. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Amy ty kytsa batu zikaha kytsa nisizororo Sesus tazikwy humo nikara. Tisapyrẽna niy. Deus wahoro zubata isturupeze eze ihyrytsa Sesus soho ziwabynahaze kazi nikaranaha: — O Deus zipehata mywata tsikyzik Dawi tsekoka ikia humo mykurẽtsa. Ikia tsamysapyrẽta hỹ — nikaranaha. Ana humo hi taparaktsa Deus wahoro zubata ziknapamykysonahatsa, ustsa asaktsa Deus harere ziwatahakanahatsa iwatsa tahakyrikinaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Sisakparẽtsa Sesus pe niaha: — Siharere tsiwaby sa — niaha. Yhỹ niy. Deus harere papeu humo tsinymyrynaha ja. Ziwataha Deus tihi: — O Deus ikia ibykyhytsa jabastsa kino niwatihi hawa abo mosakibazikiknaha nisihyrinymyry. Asahi abo mosakibazikiknaha, sinymyryrẽtsa hỹ — niy. Iwa papeu humo ziwataha. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Kyze Sesus Serusarẽhe ekze niparak. Betanija bo niy anaeze zuru. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Zokorobyitu Sesus Serusarẽhe bo niukuru irapa zumu. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ẽrykani ske sak betekta ta bo hwi umaha bo iktsa niy. Umaha bo zumuze ihara bo ziberiki batu iharaka isaro zuba. Kyze Sesus umaha pe niy: — Abaka ba ziktaharazokta ba aty tohi ahara zezukzo — niy. Iwaze babata. Atsoko niharapara. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Zinymyrykynahatsa ana bo nikozonahaze sipybyrẽtsa: — Hawa hãta sa atsoko niharapara — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","— Kaharere wasani isoho mytsatyziu tsimaha. Deus humo tsispirikponaha zeka umahaty ikahaty ikiahatsa kino atsawatu tsimaha. Tsimytsasonaha zeka: “Deus hawa ha ty abo myzapyky mykara ja. Batu kanyhy”. Iwa mytsaty tsimaha zeka hawa ha ty ibo tsimyzapykykynaha batu yhỹ my. Deus humo tsimyspirikpobabanaha zeka hara jobonita pe: “Hara pe nabo pãoty buburuzuba bo tsimy” tsimaha. Nawa tihi my ahaharere humo. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ikiahatsa Deus bo tsimyzapykykynahaze atsatu ahabo my. Deus ihumo tsimyspirikpobabanahaze hawa ha ty ibo tsimozapykykynaha atsatu ahabo nyny mykara — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Kyze Sesus Deus wahoro zubata bo nitsukzo. Anaeze kytsa nisihyrinymyrykyze taparaktsa Deus wahoro eze ziknapamykysokonahatsa, Sudeutsa taparaktsa kapitãotsa kino niwatihi ibo zumunaha. Ipe niaha: — Aty skaraba ape “Katsa tysihyrinymyrykykta, katsyhyryze tarabajatykta!” — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Sesus tihi: — Uta kino niwatihi kaharere estuba zuba ahabo my. Kaharere bo tsimaha zeka kyzeka aty sa kape “Katsyhyryze tarabajatykta!” my ahabo mykara — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Sesus ispe niy: — Aty sa Suão Batista pe: “Kytsa tysiharasusukta! niy. Deus ja. Kytsa ja. Aty skaraba ana hyriziktsokzawy zipeha kabo tsimytsasonaha.” — niy. Kyze kytsa asa zuba nipamykysohokonaha asaktsa: — Hawa sa tsimaha. Deus ipe: “tysiharasusukta” niy tsimaha zeka kyze atahi mype. “Amy skaraba ihumo batu ahaspirikpo my”. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Katsaktsa “Kytsa ipe tysiharasusukta!” niaha tsimaha zeka kytsa sizubarẽtsa Suão Deus sohokotsa humo sispirikporẽtsa iwatsahi kytsa pokso batu tyso kytsa ipe “tysiharasusukta!” batu tyso tsimaha — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Iwaze ipe niaha: — Aharere Suão Batista soho batu myhyrinymyryhy — niaha. Sesus: — Uta niwatihi, ahaharere “aty sa kape tarabajatykta! my” batu tyso — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Kyze Sesus myhyrizikwanitsa, taparaktsa upykyhytsa niwatihi ispe: — Kasoho humo ka hawa sa mytsaty tsimaha — niy. — Kyze maku ihyrytsa petoktsa. Taparakta pe: “Katse duabohotsa bokta sukpesapy humo tsimykta! Abaka nabo tsimykta!” niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Batu yhỹ” niy. Abahi tapetu isopyk: “Kazo harere bo hyỹ my duabohotsa sukpesapy bo my” niy. Niparak duabohotsa sukpesapy humo nikara. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Kyze maku iykpykbita pe “Katse duabohotsa bokta sukpesapy humo tsimykta! Abaka nabo tsimykta!” niy. Yhỹ niy. Atakta batu pão. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Aty sa tazo harere bo hyỹ niy — Sesus niy. — O taparakta — niaha. Iwaze Sesus ispe niy: — Kaharere wasani my, kytsa okyrysaro ty zibykyknahatsa. Homa pehakatsa tsyhyryze sibykyhynahatsa, wytykyryk simysapybyiza kino niwatihi Deus tyryktsa moziknaha ikiahatsa batu. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Suão Batista Sudeutsa bo zumu. Hawa ha ty Deus okzeka wasani zahawatawy. Ihumo batu ahaspirikpo, okyrysaro zibykyryknahatsa wytykyryk simysapybyiza kino niwatihi asahi iharere humo sispirikporẽtsa. Iwatsahi Deus humo sispirikporẽtsa ana bo iktsa tsikaha. Iwatuze ikiahatsa ahamysapybyitsa tu tsikykaranaha batu tymoewy Suão harere bo batu ma zikaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Usta soho ahabo mopamykysoko wabytaha! — Kyze maku waratok tsihitsa duabohotsa nisiparikik. Duabohotsa istsarãkatsa. Duabohotsa okarawytsa tyokehyry okehyry haraharetsa zozo nikara. Anaeze sokarawy eze harahare hoke duabohotsa tsikpypyrikwy nizukninaha. Kyze jobo isparik ziziki anaeze ziperykykta duabohotsa nisisukparaka. Iwaze wastuhu kytsa pe: “Utakta meky botu mokuru. Ikiahatsa duabohotsa tysiperykynahaktsa! Wihara huak ty ahabo nyny my okyrysaro ty tsapukte ahabo nyny my, katsyhyryze sukpesapy” niy. Yhỹ niaha. Iwaze niparak, mekybotu itasapy. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Duabohotsa nijakuknahaze tsihitsa tatsumuẽhĩtsa siperytsitsa bo zipehe. Okyrysaro humo nisipeha. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kyze itsumuẽhĩtsa siperytsitsa bo zumuze nizokbatsinaha. Tapara itsumuẽhĩtsa nitsakikinaha, ustakta zibezehiknaha, usta haraharezipyryktsa ty nisipaparakanaha. Iwa itsumuẽhĩtsa sisopyk niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kyze duabohotsa tsihitsa ustsa tsumuẽhĩtsa puẽtsik nisipeha siperytsitsa bo niy. Hawa tapara sitsumuẽhĩtsa sisopyk atsatu ustsa bo niaha. Nisisapybyrikinaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Bykyze duabohotsa tsihitsa tatse babata sibo zipeha. Tapetu nikara: “Katse humo ka wasani sisopyk maha ihumo batu ipyriryk. Ata humo ka ba zikaha” niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Kyze siperytsitsa itse bo iktsa niahaze asa zuba nipamykysokonaha. “Iktsa tsimaha! Atakta duabohotsa tsihitsa tse niaha. Ata kino izo mohyrikosokdaze tazo namy piakse, duabohotsa tsihitsa mozik. Tabezehikta kytsa! Tabeze zeka katsa hi duabohotsa tahaksenaha. Iwaze duabohotsa tsihitsitsa tsimoziknaha” niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kyze nizokbatsinaha. Waratok bara bo zioktyhyryknaha anaeze zibezenaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Kyze Sesus ispe niy: “Duabohotsa tsihitsa myziksizoze amo skaraba siperytsitsa bo mykara. Hawa sa mytsaty tsimaha” — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","— O asaktsa iperytsitsa sisapybyinahatsa tu mysiba. Duabohotsa mektsa bo tu nyny my asahi tsapukte okyrysaro wihara humo ibo nyny maha hawa ha ty wasani maha — niaha. Iwa Sesus ustsa perytsitsa soho ty nipamykysoko. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","— Deus harere papeu humo tsinymyrykynaha sa — Sesus niy. Deus harere papeu humo iwataha: — Kytsa wahoro nizuknikinahaze nitsasonaha, “O ana harahare batu isapy my” iwaze nipapyknaha. Ata hi harahare abazubata niyzik. Ana humo hi harahare tisapyrẽna humo ustsa harahareziktsa buruhuwa babatu niaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","44","Iwaze ahape: — Ikiahatsa Deus tyryktsa batu tsimoziknaha, asaktsa Deus harere bo hyỹ maha asahi Deus tyryktsa moziknaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kyze simyhyrizikwanitsa Deus wahoro zubata eze ziknapamykysonahatsa, Pariseutsa kino niwatihi Sesus soho ziwabynahaze sihyrinymyrẽtsa. Sisoho nitsasoko ana ty hi zinymyrykynaha iwatsahi tahakyrikinaha. — Katsaktsa siperytsitsa batu sapy watsa — mytsaty nikaranaha. Iwatsahi tahakyrikinaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Sesus tsipa humo pioktyhyry tsihikiknaha batu zikaha kytsa sizubarẽtsa pokso. Kytsa Sesus soho — Atakta Deus sohokotsa humo ka tsimaha — niaha. Iwaze simyhyrizikwanitsa kytsa pokso Sesus batu zioktyhyryk. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Kyze Sesus usa soho nipamykysokozo Deus tyryktsa soho humo nisihyrinymyryky. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Hawa Deus kytsa nisiwatawy nisihyrinymyryky. Batu sizuba hyỹ maha ana humo hi nisihyrinymyryky. Kyze maku myhyrizikwanita tse myikaha inakymy. Itse isukzata humo myikaha zihitsa niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Kyze zihitsa sitsumuẽhĩtsitsa nisipeha — Kytsa tynasakzo! “Pany aidy botu nakymy ispe tsimaha” — niy. Iwaze nitururuknaha. Sakzohotsa batu yhỹ niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Iwaze zihitsa ustsa mektsatu nasakzorenaha. Iharere tihi: — Panytaha! katse tasukzata pimyikahaka. Pikuzatsa botu nisibanaha — niy. Anaharere sitsumuẽhĩtsitsa nasiakzokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Anaharere bo batu mytsatyziu niaha. Estuba tatsuhuk bo niparak. Usta tanamy bo niparak. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Iwaze ustsa sitsasohotsitsa nisisukbatsinaha nisikikinaha. Nisibaiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Iwatahi zihitsa takyriki sodadutsa pe: — Kytsa sakzohotsa botaha niy! Asaktsa katsumuẽhĩtsa nisibanahatsa tysibaiknaktsa! Sihudikhudikwy tsipokiknahaktsa! — niy. Iwa hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Kyze zihitsa sitsasohokotsitsa hua huazo niy ispe niy: — Katse myikaha inakymy sakzohotsa batu sisopyksapy maha. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Abaka ske buruktaha! Nabo kytsa sihobykwy watu tysipehanaha niy. Ikiahatsa tihi: “Panytaha! Abazubata tse myikaha sukzawy humo panytaha! tsimaha” niy. Yhỹ niaha. Nasiakzobanaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Iwaze sitsasohokotsitsa ske buruk maha. Sizubarẽtsa zihobyknaha. Simysapyrẽtsa pe simysapybyitsa pe asa kino niwatihi imyikaha bo mysioktyhyryk. Hamyikaha bo inahareknaha sizubarẽtsa hỹ. — Anaeze tahadisahakanaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Kyze abazubata zihitsa inatsukze sakzohotsa bo iktsa niy. Iwa kytsa abazubata zihitsa sisuk humo nisisukba iwa sisopyk. Estuba maku batu, tasuk tyzuba korobyk niy, zihitsa suk humo batu hỹ niy. Iwaze zihitsa maku pe, atakta tasuk tyzuba korobyk. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","— Hawa kamyikaha bo tsimy. Asukbyita tu mymyikaha bo tsiknatsuk — niy. Maku batu harere tisikpybyrẽta. Abazubata zihitsa suk batu yhỹ ana hi batu tyso. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Kyze abazubata zihitsa sitsumuẽhĩtsa pe: — Maku kasuk batu yhỹ atahi pipawarahiknaha! Ape bo miwaha bo typapykik nabo sinini my iwaze mopuziuku takyrikita tu tatsapu ty dydydy mykara — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Kyze Sesus isoho nitsasoziuku. Atahi: — Deus zihitsa wata sizubarẽtsa mysiakzo ityryktsa moziknaha batu sizuba iharere bo hyỹ mykaranaha — niy. Asahi nisiwatawy. Batu sizuba iharere bo hyỹ mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Kyze wastuhu Pariseutsa ziponaha, asa zuba niaksohokiknaha. Tahatuktu nipamykysokonaha. — Sesus Moises harere bo batu yhỹ mozihikiknaha — iwa mytsaty nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Kyze ituktsa Erodes tuktsa kino niwatihi Sesus nizokparakanaha. Iharere humo batu imysapy mozihikiknaha ana humo hi Sesus bo zumukunaha. Asahi: — O myhyrinymyrykytsa tisapyrẽna haty zuba nisihyrinymyryky ana humo hi myhyrinymyrẽtsa. Kytsa pokso batu apyby. Kytsa abazubatsa humo batu asikpyby. Kytsa aharere siakparawy byizeka batu asikpyby. Moises harere tsinymyryziuku ahyrinymyrywy baba my. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Mypehatsa abazubata Sesa okyrysaro ja ibo nyny tsimaha. Katsaktsa Sudeutsa Moises harere bo yhỹ tsimykaranaha okyrysaro ty Homa abazubata nyny tsimaha zeka wasani ja. Ana soho humo ikia mytsaty tsimy — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Sesus simysapybyi humo tsihyrinymyrẽta hỹ. Ispe niy: — Ikiahatsa tawatahakanahatsa watsa. Amo kaharere humo uta imysapybara tsimyzihikiknaha ana hi tsipiperykynaha. Iwatatu ahape my: ");
INSERT INTO rkbNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Okyrysaro ty estuba kabo nynytaha! Atakta kytsa bo nyny tsimy — niy. Napiri wata ty estuba ibo nyny niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","— Aty naro sa okyrysaro humo ziwatahaka. Aty hyrikoso sa okyrysaro humo ziwatahaka — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","— Abazubata Sesa hyrikoso okyrysaro humo — niaha. Sesus ispe niy: — Niwazuba! Sesa namy ty ibo tu tysizotahaktsa! Deus mozihikik ana ty zuba Deus bo nyny tahaktsa! Deus hawa ha ty mozihikik ibo tysizotaha hỹ — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Iharere humo sipybyrẽtsa. Iwaze nitururuknaha, Sesus ta zuba nitare. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Bykyze Sadusitsa Sesus bo zumunaha. Asahi. — Kytsa mohyrikosokdanahaze ba zikyrizikpozonaha — mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Iwatsahi Sesus pe: — O myhyrinymyrykytsa. Tubabatu Moises Deus harere botu ziwatahaka: “Maku ihyrytsa byitatu mohyrikosokda zeka itsy haramukuka piakse”. Iwaze atatsa tabykyhyze itse mopurukze kytsa tihi: “O izikytse mopuruk” maha — niy. Iwa Deus harere my. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","— Kyze kytsa itukytsa sete niaha. Taparakta tasukza. Bykyze ihyrytsa byita tu nihyrikosokda. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Niytahi itsy haramukuka ziakse. Itsy kino ihyrytsa byita tu nihyrikosokda. Bykyze itsy taziky wanu sapy ziakse. Ihyrytsa byita tu ata kino nihyrikosokda. Kyze sete ahatsa astatsa tu ziakse. Estuba nihyrikosokdaze usta atatsa ziakse. Iwa kytsa sete itukytsa iwatsa niakbanaha. Itukytsa hyrytsa habyitsa tu niakbakanaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Iwaze atatsa kino niwatihi nihyrikosokda. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kyze nawa puruze kytsa mynahyrizikponahaze aty sa atatsa barikta babata. Sete itukytsa ziaksenaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Kyze Sesus ispe niy: — Kytsa nahyrizikponaha soho batu ahahyrinymyry. Deus harere humo batu ahaspirikpo Deus zikwy batu ahanyhỹ. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Abaktsa kytsa zuba tahasukzanaha. Wytykyryk zioktyhyryknaha. Aparakbaha inahyrizikponahaze kytsa sisukzabyitsa, wytykyryk ba zitahapytsazonaha. Niwazuba! Bijoikpe iknyktsa Deus tsumuẽhĩtsitsa watsa moziknaha batu sisukza — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","— Kytsa inahyrizikponaha hawa ha ty Deus botu ziwatahaka batu ahahyrinymyry niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Deus tihi: “Utakta Deus, Abarão kahumo tispirikporẽta. Adiri Isake kahumo tispirikporẽta. Adiri Sako kahumo tispirikporẽta iwatsa. Aba kahumo sispirikporẽtsa.” Kytsa niakbanahatsa Deus humo batu sispirikpo. Iwatsahi mynahyrizikponaha Deus humo sispirikporẽtsa — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Myzubaha ihyrinymyrywy ziwabynahaze sipybyrẽtsa maha. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","35","Kyze Pariseutsa ziwabynahaze hawa Sesus harere Sadusitsa bo niy. Nisiharere pykiknaha. Wastuhu Pariseutsa inakypyknahaze estuba Deus harere zihyrinymyryta Sesus imyiwy mozihikik iwatahi ipe niy: ");
INSERT INTO rkbNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","— O myhyrinymyrytsa! Hawa ha sa Deus harere abazuba — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Sesus tihi: — Deus humo ahamypokzitsirẽtsa babatsa. Iharere bo zuba ma tsimykaranaha! Ibo zuba mytsatyziuty! Itsyhyryze tarabajaziuba tsimykaranaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","39","— Ana harere hi abazuba my. Usa harere wasani ahaotuktsa pauktsitsa tynasipokzitsikinaha, ahumo tsinakara naha wa tihi taha. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Anaharere petoktsa abazubaha. Hawa ha ty Deus sohokotsa kytsa nisihyrinymyrykynaha hawa ha ty Moises harere ziwatahaka niwatihi anaharere petoktsa abazubaha humo my atsatu my — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Iwaze wastuhu Pariseutsa inakypykyknahaze. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Sesus ispe niy: — Deus zipehata aty sa itsekoka my. Aty soho sa mytsaty tsimaha — niy. — O Kiristu Deus zipehata Dawi tsekoka my — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Sesus: — Iwa zeka amy humo sa Dawi Deus hyrikoso humo ipe: “Kapehatsa.” ");
INSERT INTO rkbNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Dawi tihi: Deus hi Kiristu zipehata: “Kabaze dyhy ty! Ikia abazubata mozik kazikwy humo. Kapanuryk taba dyhy ty! Bykyzehu utakta Deus asukyrytsitsa apyrytsa pukezi tysipykwy iwatsahi asukyrytsitsa aharere bo hyỹ maha” niy — Dawi niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","— Dawi Deus zipehata pe “Kapehatsa” batu itsekoka hawa Deus zipehata Dawi tsekoka. Atahi Dawi tsekoka ipehatsa niwatihi. Dawi nipurukze Deus zipehata koikny baktatu Deus tsekoka humo — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Batu aty tohi ziky. Iharere myhyrinymyrykyta babata tuze batu aty tohi zikmypeha. Sisikpybyrẽtsa iwatsahi batu harere zikaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Kyze Sesus kytsa sizubarẽtsa bo zinymyrykynahatsa ahatsa pe: ");
INSERT INTO rkbNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","— Pariseutsa, kytsa asaktsa Moises harere humo zihyrinymyrykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Deus harere zihyrinymyrynaha iwatsahi siharere tsiwabytoktonahaktsa! Siharere bo hyỹ tsimykaranaha. Hawa mykaranaha humo ahamysopykzubyihu ja. Tahahyrinymyrywy humo batu sisopyk. ");
INSERT INTO rkbNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Asahi: “Taparaktsa harere bo hyỹ tsimahaktsa!” maha. Tahahyrinymyrywy batu yhỹ maha. Ustsa kytsa Deus harere bo hyỹ mozihikiknahaze asaktsa ba zik mytsumuẽhĩnaha. Kytsa watsa asaktsa titsakyrikrẽna ty puhyrykty ba zikmytsumuẽhĩnaha iwa Pariseutsa sisopyk. Taparaktsa harere bo hyỹ tsimahaktsa maha asahi batu yhỹ niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Hawa mykaranaha kytsa sibo iktsa maha ana hi mozihikiknaha. Deus harere iwatahaha tahaokpe humo zikzisikiknaha tahatsipa humo kino niwatihi haĩ niaha. Sisuk mekywahatu. Kytsa tihi. “O saktsa Deus okeze ka wasani maha. Deus harere batu sispiriktsokda. Mysisapywyky” anaharere piwaby tsihikiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Sudeutsa wahoro zumubanahaze sidyhydyhywytsa sisapyrẽtsa zuba siakparawy. Kytsa pe “Nabo pãotaha” tabete dyhy tsimy. Tahamyikaha nahaze isapyha ty zuba tahadisahakanaha. Sisorokrẽtsa nikaranaha hawa ha ty tisapyrẽna ziaksenaha. “Katsaktsa myhyrizikwanitsa” mytsaty ahabyitsa nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kytsa mysihobyknahaze sibo mopamykysoziukunaha ana hi siakparawy. Nabo kytsa namy huakwy sapy eze sibo mopamykysoziukunaha ispe: “Myhyrinymyrytsa” sisopyk ana hi siakparawy. ");
INSERT INTO rkbNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ikiahatsa ahahyrinymyrykytsa estuba zubata, utakta Sesus ahahyrinymyrykytsa ikiahatsa humo kamypokzitsiukrẽta, ikiahatsa kino ahatukytsa katuktsa tsimaha. Iwatsahi batu tahapetu sisopyk “Myhyrinymyrytsa”. Batu ustsa kape: “Myhyrinymyrytsa”. ");
INSERT INTO rkbNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Pariseutsa tihi ikiahatsa mysopyk “myzo” tsimaha ikiahatsa ahazo estuba zubata atahi bijoikpe eze tu my, iwatsahi usta maku mybarawy ezektsa tu batu ipe: “myzo” ahasopyk. ");
INSERT INTO rkbNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ustsa kytsa batu isty peha: “abazubata” ahasopyk, utakta Deus humo zikpehata abazubata estuba zubata my. ");
INSERT INTO rkbNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Aty pehatsa ahatuk mozihikik atakta sizubarẽtsa mysitsumuẽhĩ mykara hawa ikykara, atakta niwatihi. ");
INSERT INTO rkbNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Aty tapetu isopyk “Utakta mypehakatsa mozihikik” ustsa kytsa isty tsumuẽhĩ byizeka, atakta Deus okzeka batu imysapy. Atahi “O sizubarẽtsa mysitsumuẽhĩ tsihikik” atahi Deus okzeka myhyrizikwani mozik — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","— O Pariseutsa Deus harere zihyrinymyrykynahatsa niwatihi ahahumo kasukatsihikrẽta. Ikiahatsa ahamysapybyitsa tu tsimykaranaha iwatsahi sinini tsimaha. Ikiahatsa myzihawatahakanahatsa watsa ahahumo kasukatsihikrẽta. Deus tyryktsa wahoro wata, ikiahatsa hokbowy pihyrizikpyrykwyhik, ba zikpupunaha iwaze Deus tyryktsa batu tsimoziknaha. Ustsa kytsa mopupu tsihikiknahaze Deus tyryktsa moziknaha ikiahatsa tihi “Batu paku tsimaha” iwa tsimaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","O Pariseutsa Deus harere zihyrinymyrynahatsa niwatihi aha humo kasukatsihikrẽta. Ikiahatsa ahamysapybyi tsimykaranaha iwatsahi sinini tsimaha. Ikiahatsa myzihawatahakanahatsa watsa aha humo kasukatsihikrẽta. Ikiahatsa haramukuka namy tsipiaksenaha. Kytsa okzeka Deus bo tsimypamykysobanaha sipapatu haramukuka namy tsipiaksenaha. Ana humo hi sinini tsimykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","O Pariseutsa Deus harere zihyrinymyrynahatsa niwatihi. Ikiahatsa myzihawatahakanahatsa watsa ahahumo kasukatsihikrẽta. Sinini tsimaha. Nanabyitaba tsimykurunaha, hara taba tsimykurunaha pihik koikny niwatihi kytsa bo tsimykurunaha, aparakbaha ahaharere humo ahawatsa moziknaha. Ahawatsa Sudeutsa moziknaha anaty hi tsimyzihikiknaha. Atakta ahaparakbaha tu zeka iwataharakatsa mozik ahawatsa sinini ykarawy bo my. ");
INSERT INTO rkbNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","— O ahahyrizikubyitsa watsa. Ustsa kytsa batu isty tsumuẽhĩ okryrysaro humo ahakparawy. Ikiahatsa tihi: “Aty kytsa bo motsaso zeka. ‘Hawa Deus wahoro zubata Serusarẽhe eze my kaharere wasani my’ iwa motsaso zeka iharere wasape ja batu myhyrinymyry.” Ata tihi zeka “O kaokyrysaro Deus wahoro zubata nyny my” niy. Iwaze iharere wasani myhyrinymyrẽtsa. Okyrysaro Deus wahoro zubata bo nyny my zeka iharere wasani my ana humo myhyrinymyrẽtsa iharere wasapehe my. Hawa ha ty kytsa pe mykara wasape my. ");
INSERT INTO rkbNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ikiahatsa ahamyikitsa! Ahyrizikubyitsa watsa! Deus humo ka okyrysaro batu ipokzitsi tawahoro zubata tisapyrẽna my. Deus wahoro zubata hi abazubaha my hỹ — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","— Ikiahatsa tihi: “Aty Deus bo motsaso zeka ‘Anaeze myraratsa wezowy eze Deus bo nyny tsimaha anaeze Deus wahoro zubata eze tu, kaharere wasani my’ iwa motsaso zeka iharere wasape ja batu myhyrinymyry”. Ata tihi zeka “O myraratsa ty hi atakta Deus bo nyny my zeka iharere wasani my” ana humo myhyrinymyrẽtsa. ");
INSERT INTO rkbNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ahahyrizikubyitsa watsa. Ahararatsa harazowy tisapyrẽna Deus wahoro zubata eze hi abazubaha hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Iwatsahi aty myraratsa wezowy motsasoze iwaze iharere humo wasani ja, niwazuba isapyhatsa ty sizubarẽna wezowy bete kino motsasoko iwaze iharere wasani my. ");
INSERT INTO rkbNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Iwatsahi aty Deus wahoro zubata motsaso zeka iharere humo wasani ja niwazuba atakta tawahoro eze inapykyrykta kino motsasoko iwaze iharere tisapyrẽna my. ");
INSERT INTO rkbNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Aty bijoikpe motsasoze iwaze iharere humo ja wasani, niwazuba atakta bijoikpe eze tu kino motsasoko iwaze iharere wasani my. Bijoikpe Deus dyhywy wata zubata my — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","— O Pariseutsa, Deus harere zihyrinymyrykynahatsa kino niwatihi sinini tsimaha. Ikiahatsa ahanamy mytsyhyrytsa wa tsimaha zeka estuba zuba Deus bo nyny tsimaha. Wasani tsimaha. Ikiahatsa ahadisahawykykywy ty Deus bo nyny tsimaha. Deus harere bo hyỹ jokboa zuba tsimaha. Hawa ha ty wasania ty Deus okzeka batu yhỹ tsimaha. Kytsa bo batu wasani ahasopyk tsimaha. Ustsa humo batu ahamypokzitsiuk. Kytsa ahamyi ty tsimysisapybyrikinaha. Hawa tsimahaze Deus harere bo batu yhỹ tsimaha. Niwazuba Deus harere wasaniha bo hyỹ tsimahaktsa! Ustsa harere niwatihiktsa! Iwa ahadisahawykykywytsa Deus bo nyny tsimaha, iharere bo kino niwatihi hyỹ tsimaha, Deus harere bo hyỹ tsimaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ahahyrizikubyitsa watsa. Ustsa kytsa batu isty tsumuẽhĩnaha. Ikiahatsa tihi: “Katsa mysapyrẽtsa ustsa bo mysitsumuẽhĩ” mytsaty ahabyitsa tsimaha. Ikiahatsa jokboa kaharere humo pykyhytu hyỹ tsimaha. Ikiahatsa kytsa watsa asaktsa tsikaeni ahabo zuba mytsaty ahasopyk. Abazubaha bo batu yhỹ tsimaha, iwatsahi ustsa kytsa humo batu ahamypokzitsiu, ahadisahawy soho bo zuba mytsaty tsimykaranaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","— O Pariseutsa, Deus harere zihyrinymyrykynahatsa niwatihi. Ikiahatsa myzihawataharakanahatsa watsa ahahumo kasukatsihikrẽta. Ikiahatsa sinini tsimaha. Ikiahatsa ahamypewytsa ahaporosuktsa ty ispetaba zuba tsimysipikiknaha tsibarazarẽna. Ioketabaka nioktsirõrõ siokpekehiziuhu batu siziu. Amy ty mytsaty tsimykaranaha batu wasani my. Taha bo zuba mytsaty tsimynakaranaha, amy ty ahakparawy atsatu tsimykaranaha. Ahamysapybara ty batu moewy iwatsahi batu ahamysapy tsimaha. Kytsa okzeka tsahi simysapyrẽtsa watsa, batu ba, batu ahamysapy tsimaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Pariseutsa ahahyrizikubyitsa watsa. Kytsa Deus bo batu mysioktyhyryk. Tapara ahaporosuktsa tysiokepiknaha. Tysiokepikik. Iwaze sisukpetaba motsapik tsimaha. Iwatsa hawa ha ty tsimyzihikiknaha zeka wasani my hawa kytsa ahasopyk wasani tsimaha. Ikiahatsa hawa tsimyzihikiknaha batu imysapy ahaporosuktsa watsa asahi batu isty pik — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","— O Pariseutsa, Deus harere zihyrinymyrykynahatsa niwatihi. Ikiahatsa tsihawataharakanahatsa watsa ahahumo kasukatsihikrẽta. Ikiahatsa sinini tsimaha. Ikiahatsa mytyk watsa, mytyk ape taba tsibarazarẽna. O “siziurẽna” kytsa mykaranaha. Batu ba. Anaeze siakbatsa nibibibakanaha, sipoiktsa zuba. Iwa ikiahatsa ustsa bo ahamysapyrẽtsa watsa. Batu. Ikiahatsa siakbatsa watsa batu ahamysapy tsimaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Iwa ikiahatsa tsimaha. Hawa tsimykaranaha kytsa ahasoho “asaktsa simysapyrẽtsa” maha, ikiahatsa ahamysapybyitsa tu tsimykaranaha iwatsahi kytsa tsimysisapybyriwynaha. Ikiahatsa tsiwataharakanahatsa watsa — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","— O Pariseutsa, Deus harere zihyrinymyrykynahatsa niwatihi. Ikiahatsa myzihawataharakanahatsa watsa ahahumo kasukatsihikrẽta. Ikiahatsa sinini tsimaha. Ikiahatsa Deus sohokotsitsa siytyk tisapyrẽna tsikzokninaha, kytsa simysapyrẽtsa Moises harere bo hyỹ nikaranaha siytyk tisapyrẽna tsikzokninaha. Iwatsa tu batu ahamysapy tsimaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ikiahatsa tihi: “Katsaktsa taparaktsa tuk tsikapykyryknaha zeka Deus sohokotsitsa batu tsiksibanaha” mytsaty ahabyitsa tsimykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Iwatuze iwa tsimypamykysokonaha, ikiahatsa Deus sohokotsitsa tsiksibanaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Niwazuba hawa ha ty taparaktsa ahadiritsa nikaranaha atsatu tsimykaranaha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","— Ikiahatsa pyryhyk myrawy watsa tsimaha. Tsimysapybyi zeka Deus sinini ykarawy bo pahapehahik ba zik zoinaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Iwaze ustsa Deus sohokotsa ahabo myzipeha kytsa sispirikporẽtsa, sihyrinymyrykytsa iwatsa ahabo mysipehahik, pahatsumuẽhĩnaha humo. Wastuhu tsiksibanaha iharapatawyhytsa humo tsiksihyrizikiknaha iwa tsiksibanaha, ustsa Sudeutsa dyhydyhywy eze tu tsiksikikinaha. Ustsa nanabyitaba tsiksiberikinaha tsiksijakanaha. Tsiksibanaha taparaktsa watsa asahi Deus sohokotsa nisibanaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Asaktsa ahabo mysipehahik iwaze kytsa simyiwybyinahatsa tu sihyriziktsokzawy humo sinini tsimaha. Taparaktsa ahadiritsa Abeu zibezenaha. Ustsa sohokotsa nisibanaha. Ziharawy babata Sakarias zibezenaha. Deus wahoro eze zibezehiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Asaktsa simysapyrẽtsa niaha, asa humo hi ikiahatsa abaktsa kytsa sinini tsimaha. Ikiahatsa atsatu tsimaha iwatsahi sinini tsimaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Kyze Sesus nipamykysokozo: — O Serusarẽhe ezektsa. Ikiahatsa Deus sohokotsitsa tsiksibanaha. Asaktsa zahahyrinymyrykynaha tsiksibanaha. Deus sohokotsitsa bo haraharetsa zipyryktsa tsiksipaparakanaha iwa tsiksibanaha. Hawa pahakypyk tsihikik kokuaro wata mykara. Kokuaro tahyrytsa tasara paik puke eze mysipokzitsiki eze atatsa watsa. Iwa uta ahahumo kamypokzitsiarẽta. Ikiahatsa kabaze batu hỹ tsikaha. Ikiahatsa katuk batu hỹ tsikaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Iwaze ahawahoro perikik kytsa wahoro monakbiba. Deus tihi ahudikhudikwy soho “tsipiharakbaiknaha” my. ");
INSERT INTO rkbNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kabo ba ziknyzonaha. Ikiahatsa tsimytsasonaha zeka “Atakta Deus zipehata myziksizo ihumo mykurẽtsa tsimoziknaha iharere bo hyỹ tsimaha”. Iwaze kabo iktsazo tsimahaze ahakurẽtsa tsimoziknaha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Iwaze Sesus Deus wahoro zubata ekze niparakze zinymyrykynahatsa ibo zumunaha ipe niaha: — O myhyrinymyrykytsa Deus wahoro zubata bo iktsa tsimykta! Hawa tawahoro zubata tisapyrẽna zoihitsa sisapyrẽtsa — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yhỹ niy. Aba haraharetsa bo iktsa tsimaha. Aibatohi haraharetsa ba harape bete zozo zikaha. Haraharetsa mynatõtõbaiknaha. Kytsa Deus wahoro zubata mynakarakba. Tsizubarẽna nepykbaik. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Kyze Sesus Oriwereja hwitsa hara bo niy. Anaeze nidyhyky. Iwaze zinymyrykynahatsa asazubaze ipe niaha: — Hawaze sa Deus wahoro zubata mynakarakbaik amy ty sa mybo tsipiwatawy. Ikia tsimyziksizoze amy ty mybo tsipiwatawy. Hawaze mybarawy mopyk, amy ty mybo tsipiwatawy — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ana soho mopamykysoko Sesus tihi: — Pykyhytutaha! Kytsa pahaspihikbatanaha. Siharere bo ba wabyziu tsimaha! ");
INSERT INTO rkbNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kytsa sizubarẽtsa ahape maha “Utakta Deus zikpehata Kiristu” mybarapetu maha. Siharere batu wasani my. Kytsa mysispihikbatakanaha zuba, kytsa siharere bo yhỹ maha, siharere wasani mytsaty ahabyitsa mykaranaha. Iwa kytsa bo mybarapetu mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kytsa ẽryktsa mowatsorokonaha. Kytsa bytykara ezektsa kino niwatihi mowatsorokonaha. Ana soho tsipiwabynaha. Ahapyby byihu ja. Tapara wa tihi my mybarawy abanury ty ka ba zikpyk. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tatyryktsa usta tyryktsa bo mowatsoronaha. Nanabyi tabatsa myharape sukyryikiknaha. Nanabyitaba wytyk mytydydykyryk. Kytsa sizubarẽtsa taharapa piyknaha. Batu sidisahawyky. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Iwa sinini mykaranaha. Bykyze sinini puẽtsik maha. Hawa wytyk tsimyitsapyrẽtatsa tabykyhy pipurukze, bykyze sinini mykara puẽtsik atatsa watsa kytsa sinini mykaranaha. Bykyze puẽtsik sinini mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Iwaze ahasukyrytsitsa ahatsipa humo pahaoktyhyryknaha. Pahasukyrikinaha. Kahumo ahaspirikporẽtsa pahabanaha. Kytsa sizubarẽtsa ahahumo batu siakparawy. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Iwaze sizubarẽtsa katuktsa kahumo batu sispirikpo. Kytsa myharape sapybyikinaha, siharerewabymybarẽtsa moziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Kytsa asaktsa: “Katsaktsa Deus sohokotsa tsimaha” mybarapetu maha. Asahi kytsa bo mozumunaha zeka mysimyiwynaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Iwaze amy ty batu imysapy kytsa mynakaranaha. Simyiwynahatsa sizubarẽtsa maha. Ana humo hi ba zikapepokzitsinaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Aty kahumo tispirikporẽta tsipunihikrẽta mozik. Tsimysapyrẽta mozik, atahi Deus tuk tawahi mynapykyryk. Aty sinini mykaraze tsipunihikrẽta mozik atahi Deus tuk tawahi mynapykyryk hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Deus wasania ty kytsa ityryktsa moziknaha soho kytsa aparakbaha bo niy. Nanabyitaba Deus wasania ty motsasonaha iwaze kytsa abazubaha iharere piwabynaha. Kytsa abazubatsa Deus wasania ty piwabynahaze iwaze hi mybarawy mopykba. Ana zuba mybarawy mopykba — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Sesus ispezo niy: — Isapybyiwy imyrawyta Deus wahoro zubata eze perikiknaha. Deus wahoro zubata sapy eze my. Deus sohokotsa Danieu anasoho botu ziwatahaka. Ata bo kino iktsa tsimahaze tywakiknahaktsa! — Sesus niy. Aty tapapeu piny ihyrinymyry tahi my. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Sesus tihi: — Hawa myze asaktsa Sudeja eze tuze hara bo tywakiknahaktsa! ");
INSERT INTO rkbNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Atakta wahoro harapu bete modyhyky zeka mynasik tanamy bo batu paku my, mowakik zuba. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Atakta tatsuhuk eze tu zeka tasuk bo wahoro eze batu erete mowakik zuba! ");
INSERT INTO rkbNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Wytykyryk siseheza sibykyhykyza sisukatsihikrẽza. Tahabykyhytsa tu sisukatsihikrẽza. Mywaknahaze tsihokdaharẽna. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Deus bo tsimypamykysonaha: “O myzo tsimywaknaha zeka mybo ba hyritsik tyziwõ tsimaha. Tsimywaknaha zeka batu mybyrykywy eze ba zikunaha mysopyk tsimaha” niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Iwaze tihi kytsa sinini mykaranaha. Deus bijoikpe wytyk nizuknize kytsa anawa batu sinini niaha. Ba sininizo zikaha. Anawaze zuba sinini tsimykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Deus zikwy humo jokbohatu sinini tsimaha, kytsa pokzitsiuwy jokbohatu nawa puruze mopyk habyizeka batu aty tohi ispitutsa zikokpykyryknaha. Deus iwatahawytsitsa pokzitsiuwy jokbohatu. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Kyze aty ahabo zeka. “Iktsa tsimahaktsa! Anahudikhudikwy bo Deus zipehata my”. Usta ahabo zeka. “Iktsa tsimahaktsa! Atahi Deus zipehata my” mybarapetu mykaranaha. Ana harere bo ba hỹ tsimaha! ");
INSERT INTO rkbNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Sizubarẽtsa mozumunaha asaktsa: “Utakta Deus zikpehata” mybarapetu mykaranaha. “Utakta Deus sohokotsa” mybarapetu mykaranaha. Amy ty kytsa batu zikaha ana ty hi mykaranaha, iwaze kytsa tahapetu sisopyk. “Atakta Deus sohokotsa babata, atakta Deus zipehata babata” mytsaty ahabyitsa mykaranaha. Deus nisiwatahawyhiknahatsa bo mysimyiwy tsihikiknaha, batu zikaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Sesus ispezo niy: — Kapehawy tsiwabytoktonahaktsa! Abaka taharere ahabo my iwaze kytsaktsa mozumunahaze siharere bo batu yhỹ tsimaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Kyze ahape maha zeka: “Iktsa tsimahaktsa! Deus zipehata jerukbara eze tu my” maha. Usta ahape “Iktsa tsimahaktsa! Deus zipehata wahoro bo inatsuk” maha. Siharere humo batu ahaspirikpo. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Utakta Deus zikpehata ahawata mynasikzoze paparizo mykaranaha hyrikoso waha my. Bijoikpe eze tu nanabyitaba hyrikoso my anawa abazubatsa kabo iktsa maha. Aparakbaha hyrikoso bo iktsa maha. Anawatsa aparakbaha kabo iktsa maha. Utakta myziksizoze iwa hi my. Atsoko myziksizo, aparakbaha kabo iktsa maha hyrikoso waha. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Myziksizo hỹ. Amakata nihyrikosokda zeka ihoro bo urubutsa mozumubaiknaha. Piborobaiknaha. Urubutsa Deus sohokotsabyitsa watsa, urubutsa tsihoroharẽna ziborokonaha. Deus sohokotsabyitsa kytsa Deus humo sispihikbyitsa bo mybarapetu mykaranaha. Kaharere humo myziksizo naha soho wasani my — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Sesus ispezo: — Kyze sinini ykarawy mopykze iwatahawytsa mynatakaha. Haramwe ba ziknaharamwe ihizikubyita hi miwa my. Byzoje kino niwatihi ba ihiziku. Byrisoiktsa, bijoikpe ikny mynatsunaha. Bijoikpezektsa mytydydykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Iwaze bijoikpe eze iwatawy natakahaze utakta Deus zikpehata mynasikzo piwatawy. Kytsa aparakbaha anawatahawy bo hi iktsa maha. Ana bo iktsa mahaze sipybyrẽtsa. Mybarawy ezektsa kapokso mopuziukunaha. Utakta bijoikpe satata tuk mynasik iwa kytsa kabo iktsa maha. Mynasikze kamysapyrẽta kahyrizikporẽta kazikwyrẽta ana bo iktsa mahaze mopuziukunaha. Kamysapyrẽta tu iwatsatu mopuziukunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kyze porawy wata opykani pypy mykaraze tawata my, iwaze bijoikpe iknyktsa Deus tsumuẽhĩtsitsa siwatawytsitsa bo mysipeha. Nanabyitaba mybarawy ikny iwatawyhiktsitsa mynakypyknaha — niy. Sesus iwa nisihyrinymyrykyzo. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Sesus ispezo: — Kyze umaha bo iktsa tsimaha. Hyritsik nawõze pahahyrinymyry. Umaha taypykze tapara isarapatsa ytsik humo tasaropok zeka iwaze okyrysaro mozipokoroknahaze “O hyritsik mynawõkõ” tsimaha. Ahahyrinymyrẽtsa. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Anawatawywahi mahaze utakta mynasikzoze ahahyrinymyrẽtsa hỹ. Bijoik ezektsa mytydydykynaha iktsa tsimaha utakta mynasikzoze ahahyrinymyrẽtsa hỹ. Atsatu my. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Kaharere wasani wabyziutaha! Abaktsa kytsa kaharere pinymyrybaiknaha. Kaharere atsatu mykaraze bykyzehu zuba mohyrikosokdanaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Bijoikpe mohokda. Wytyk kino mohokda. Kaharere ka ba zikokza. Ba zikpyk. Kaharere tawahi mynapykyk — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ispezo niy: — Myziksizo naha humo batu myhyrinymyry. Batu aty tohi nawa taize ja ziky ba zikaha. Bijoikpe iknyktsa Deus tsumuẽhĩtsitsa kino batu sihyrinymyryhy. Uta kino Deus tse babata tu batu kahyrinymyryhy. Kazo zuba tsihyrinymyrẽta. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Tapara utakta Deus zikpehata mynasikzoze kytsa Noe okzekywatihi my. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Zibyituhukutu tahadisahakanaha, zikukunaha, tahasukzakanaha, wytykyryk nisioktyhyryknaha. Iwa nikaranaha iwaze Noe tsaraha puẽtsikbyita nizuknize atsaeze takoroze atsoko hyritsik inawõ. Ustsa kytsa pihik humo tahababaiknaha. Sispirikpobyitsa tahaharazukik. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Anawahi utakta Deus zikpehata myziksizoze kytsa sispihikbyitsa tuze atsoko myziksizo. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","— Iwaze makutsa petoktsa waratok eze pitetekenaha. Estuba Deus piwatawy, kabo pioktyhyryk ustakta motare. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Petokzahaza wanatsitsa mysiwazikinaha. Estuba Deus piwatawy, kabo pioktyhyryk ustatsa katsa motare. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Mytsatyziu tykaranaha! Ahaspihik tsiwabykynaha! Haneze ahapehatsa mynasikzo ana humo batu ahahyrinymyry hỹ iwatsahi ahaspihik tsiwabyky nahaktsa! ");
INSERT INTO rkbNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Wahoro tsihitsa zinymyryky zeka hawaze unata titsyhyryboarẽta iwahoro bo mytsukze, piperyky, ba zikuru, iwatahi itsyhyryboarẽta iwahoro ba ziktsuk. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Iwatsahi ahaspihik tsiwabykynahaktsa! Tsimykymynaha atsoko utakta mynasikzo iwatsahi tsimykymynaha wahoro zihitsa watsa ahaspihik tsiwabykynahaktsa! Iwa tsipiperykynahaktsa — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Sesus puẽtsik nisihyrinymyryky ikiahatsa tsumuẽhĩtsitsa watsa. Atahi: — Hawa tsumuẽhĩtsa tsimysapyrẽta ahabo motsasoko. Aty ipehatsa harere bo hyỹ mykara. Iharekykarabyita tu tisokpykziurẽta babata ipehatsa nikuruze tsumuẽhĩtsa pe: “Kanamy tsiperyta! Kawahoro ezektsa tysipokzitsiuktsa! Ustsa tsumuẽhĩtsa sidisahawy ty sibo nyny tsimy” my. Iwaze meky botu niukuru. Sitsumuẽhĩtsa nitare. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Atakta itarabaja pykyhytu mynakara bykyzehu ipehatsa myziksizoze ihumo tsakurẽta hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ipehatsa tihi: “Ikia tsamysapyrẽta tu kanamy tsizubarẽna tsiperyky iwatahi ahumo kakurẽta my, katsyhyryze tarabajaziu tsikykara iwatahi pasapywyky” my. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Sitsumuẽhĩtsa ihyriziktsokzawy pykyhytu habyi zeka tapetu isopyk: “O kapehatsa azymyny. Batu aidy erete ziky mykara” my iwatahi ipehatsa harere bo batu yhỹ niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Iwaze ustsa tsumuẽhĩtsitsa mysikiki. Tadisahaikik siopuwy pikuikik. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ipehatsa myziksizoze sitsumuẽhĩtsa batu ity pery. Haramwe haneze sa batu inymyryhy. Ihyrinymyrybyita tu ipehatsa atsoko ziksi. ");
INSERT INTO rkbNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ipehatsa ihumo takyriki sinini ykarawy bo pipeha. Iharawatakanahatsitsa tuk sinini mykara. Situk mopuziuku nabo tahatsapu ty dydydy mykaranaha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","— Iwaze uta mybarawy bo mynasikzoze Deus tyryktsa hawa ja my — niy. Iwatahi usa soho humo nipamykysozo. Deus tuktsa soho humo nisihyrinymyry. Hawa ihumo tsipiperykynaha, asaktsa ihumo piperykynaha Deus bo mysioktyhyryk. Ustsa batu ziperynaha sinini mykaranaha iwatsahi — Aperykynahaktsa — niy. Atahi: — Kyze sityrykduwybyiza des niaha. Asiza hi taharikapuwy zisuhyknaha mytasukzata zihobyk tsihikiknaha. Sisopyk hi. Sityrykduwybyiza tasukzata myikaha bo zuba niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Sityrykduwybyiza mytsyhyry waza sispirikpoza. Sityrykzowybyiza mytsyhyry waza batu sispirikpo. Iwa. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Sispirikpobyiza taharikapuwytsa tsihirik tuk zuba niaha. Ituta taharikapuwytsa eze tsikaeni zuba. Awatu haty batu tysuhyk. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Usiza sispirikpoza awatuha zisuhyknaha. Taharikapuwy ty zihareknaha usa awatuha zibykyryknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Sityrykduwybyiza tasukzata ziperykynaha typerypery batu zuk. Tasukzata ba zikzumu, haneze ja mozumu batu sihyrinymyry. Siõtutsarẽza tu hini nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Unopokteze aty ja kakaik niy. “O tasukzata mozumuku iokeryk pãotaha!” niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Iwaze sityrykduwybyiza taharikapuwy ty zikymynaha taharika humo pokpok niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Kyze sispirikpobyiza sispirikporẽza pe “Ahazikaopuwy ty katsa mybo ja! Katsa myrikapuwy nepykbaik” niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Katsa kino batu niaha. Sozeka ja katsa myrika opuwy batu huhu my katsa ahabo nyny tsimaha zeka myrika opuwy tsikaeni zuba. Kytsa bo ahazikaopuwy tyzisuhyryknaha okyrysaro humo” niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Iwazahi nitururuknaha, rika opuwy zisuhyknaha. Asiza sapy baze tasukzata izumu. Sityrykduwybyiza sispirikporẽza iperykynahaza iapik niaha. Nikymynahaze tu imyikaha bo niaha. Imyikaha sapy bo nipupunaha kyze aty hokbowy ziokbohik. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Iwaze usiza sityrykduwybyiza izumunaha. Sispirikpobyiza hokbowy eze huahua niaha. Isukzata bo hua nikaranaha. “O mypehatsa hokbowy ty zoksaparety” niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Batu ba niy. Hokbowy ty ahabo zoksapare ba ziky ikiahaka siza batu kanyhy” niy. — Iwa Sesus sityrykduwybyiza soho humo nipamykysoko hawa ihumo tsipiperykynaha nisihyrinymyryky. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Kyze atahi: — Hawa taeze myziksizo naha humo batu ahahyrinymyry. Hanawa puruze myziksizoze batu ahahyrinymyry iwatsahi tsiperykynahaktsa! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Kyze utakta myziksizoze Deus tuktsa hawa ja my. Iwaze usa soho humo nipamykysoko, iwa nisihyrinymyryky. — Maku niparak meky botu niparak. Niparakakze sitsumuẽhĩtsa pe: “Kanamy tsizubarẽna tsiperykykta” niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Tapara sitsumuẽhĩtsa pe: “Pany! Okyrysaro ouro hi mytsyhyry wa sĩko miutsa abo nyny my. Ahawatu nyny nyny my! Kaokyrysaro humo puẽtsik tsipiakse!” niy. Yhỹ niy. Kyze usta tsumuẽhĩtsa pe: “Pany! Okyrysaro ty ouro hi petok miutsa abo nyny my. Ahawatu nyny nyny my! Kaokyrysaro humo puẽtsik tsipiakse!” niy. Yhỹ niy. Kyze usta tsumuẽhĩtsa pe: “Pany! Okyrysaro ty ouro hi estuba miu abo nyny my. Ahawatu nyny my! Kaokyrysaro humo puẽtsik tsipiakse!” niy. Yhỹ niy. Iwa niy. Estuba estuba tsumuẽhĩtsa izikwy humo okyrysaro ibo nyny niy. Iwaze niparak meky botu niukuru. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Atakta tsumuẽhĩtsa okyrysaro mytsyhyry wa miutsa ty aidy kytsa bo. Okyrysaro humo ziaksetohi iwaze okyrysaro puẽtsik ziakseta, usta okyrysaro mytsyhyry tsawa sĩko miutsa ziakse. Abaka okyrysaro mytsyhyrytsa sepyk niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Atakta tsumuẽhĩtsa okyrysaro petok miutsa tu atsatu niy. Okyrysaro humo ziaksetohi iwaze okyrysaro puẽtsik ziakse usta okyrysaro petok miutsa ziakseta. Abaka okyrysaro napetok napetok niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Atakta tsumuẽhĩtsa okyrysaro estuba zuba miu ziakseta wytyk hoke bo zikorohik, tapehatsa okyrysaro ziokpitsĩ. Abaka okyrysaro estuba zuba nitare. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Kyze sipehatsa meky botu niapykyryk. Aiba ziksizoze tapetu isopyk: “Katsumuẽhĩtsa bo iktsa my kaokyrysaro ty sibo nyny iky hawa ja ity nakaranaha iktsa my. Sihyriziktsokzawy ty pykyhytu maha zeka ana bo hi iktsa my” niy. Iwaze sitsumuẽhĩtsa sibo huahua niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kyze tapara itsumuẽhĩtsa ibo zumuze tihi: “Ikia aokyrysaro ty mytsyhyry wa miutsa kabo nyny tsiky. Uta okyrysaro mytsyhyry wa puẽtsik ziakse abaka okyrysaro ty mytsyhyrytsa wa sepyk abo nynyrezo my” niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ipehatsa “O wasani. Ikia tsisapyba, ikia sitsumuẽhĩtsa tsimysapyrẽta tsimy. Ahyriziktsokzawy tsikaeni zuba pykyhytu tsikykara abaka amy ty ipamabikia ty abo nyny my. Kamyikaha bokta! Katuk tsakurẽtakta!” niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Kyze ustsa itsumuẽhĩtsa ibo zumuze: “Ikia aokyrysaro ty petok miutsa kabo nyny tsiky. Uta okyrysaro petok puẽtsik ziakse abaka okyrysaro ty napetok napetok abo nynyrezo my” niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ipehatsa: “O wasani. Ikia tsisapyba ikia sitsumuẽhĩtsa tsimysapyrẽta niy. Ahyriziktsokzawy tsikaeni zuba pykyhytu tsikykara aba amy ty ipamabikia ty abo nyny my. Kamyikaha bokta! Katuk tsakurẽtakta” niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Kyze usta itsumuẽhĩtsa ibo zumuze: “Ikia aokyrysaro ty estuba zuba miu kabo nyny tsiky. Ikia humo kytsa sinamybyitsa. Ikia atsuhuk sizõjanita bo ba ziksiparik. Tsimysizozeke zuba. Batu tywe kytsa nisizozokonaha ikia tsyhyryze. Ana ty hi kahyrinymyrẽta. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Iwatahi apokso kapybyrẽta. Wytyk eze aokyrysaro iytykik. Abaka aokyrysaro estuba zuba miu abo nynyrezo my” niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Iwaze ipehatsa zibetsakak: “O ikia katsumuẽhĩtsa batu atsyhyry. Ikia iakmyita. Ikia mytsaty kahumo kytsa sinamybyitsa. Ikia mytsaty isty parikbyita tu tsiksizozoko zuba. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Iwa mytsaty tsimyzeka amy skaraba maku okyrysaro zozowy bo kaokyrysaro ty batu nynyspyk tsiky. Atakta kaokyrysaro humo ziakse tohi. Iwaze kaokyrysaro humo tsiky zeka tihi, zibiakakta okyrysaro nynyrezoze kaokyrysaro tsikaeni zuba tsiakse. Iwa ziksizoze kaokyrysaro puẽtsik zuba kabo nynyrezo tsimy” niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Kyze pehatsa ustsa tsumuẽhĩtsa pe: “Okyrysaro ty estuba zuba taty okoktaha! Tapara tsumuẽhĩtsa atakta okyrysaro mytsyhyrytsa wa sĩko miutsa nynytahaktsa ibo hi ana okyrysaro ty estuba nyny tsimaha” niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Aty tapehatsa tsyhyryze tarabajaziu my zeka tsakurẽta iwatahi ihyriziktsokzawy tohi my. Tisokpykziurẽta mozik. Aty tapehatsa tsyhyryze batu tarabaja my ihyriziktsokzawy tsikaeni zuba ziaksebaik. Itsyhyrybyita tuze inamybyita mozik. Ihumo batu iaku iwatahi batu ihyriziktsokza nabo pãoty my. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Tatsumuẽhĩtsa iakmyita ape bo miwa ha zuba typapykik nabo mopuziuku takyrikita tu tatsapu ty dydydy mykara niy. Iwa sisoho Sesus nipamykysoko Deus tyryktsa soho humo nisihyrinymyryky. Hawa Deus isapyha ty ituktsa bo nyny my nisihyrinymyryky. Wastuhu sisokpykziurẽtsa moziknaha ustsa ituktsa isapyha ty batu yhỹ maha zeka ana kino Deus piakse ustsa bo nyny my — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Kyze Sesus tihi: — Utakta Deus zikpehata ahawata ikyzik mynasikzoze abazuba my. Izikwyrẽnikita my. Iwatahi kadyhywy tisapyrẽta bete modyhyky. Mynasikzoze bijoikpe iknyktsa Deus tsumuẽhĩtsitsa sizubarẽtsa katuk mynasiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Iwaze bijoikpe iknyktsitsa mybarawy ezektsa sizubarẽtsa kaokeryk mysioktyhyryknaha. Nabo sizubarẽtsa mynapykyknaha. Hawa hozipyrykzatsa perytsa myraratsa ty meky taba tu hozipyrykzatsa usta taba kaberitotsa, anawata utakta mybarawy ezektsa petok metutu my. Nataba simysapyrẽtsa mekytaba tu simysapybyitsa iwa kaokeryk mynapykyrykbanaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Asaktsa simysapybyitsa kapawazo taba maha. Ustsa simysapyrẽtsa kino kapanuryk taba maha. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Kyze kytsa kapanuryk tabaktsa pe my: “Pany!” Ikiahatsa bo Deus kazo pahasapywyky, abaka ityryktsa babatsa tsimoziknaha. Deus isuknihibyize ikiahatsa soho mytsaty nikara hawa ityryktsa tsimoziknaha ana ty hi mytsaty nikara. Isapyhaty ahabo nyny my, hawa ihyrytsa bo nyny my nawata ty ikiahatsa niwatihi ahabo nyny my. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","36","Karaparẽta ikykaraze ahadisahawy ty kabo nyny tsikykaranaha. Karapukrẽta ikykaraze pihik ty kabo nyny tsikykaranaha. Utakta bipyritsa mozikze ikiahatsa kape: “Paku tsimy. Mywahoro awanu sapy bo” tsikykaranaha. Kakpyrẽta ikykaraze ahasuk ty kabo nyny tsikykaranaha. Kamyitsapyrẽta ikykaraze kahumo ahamypokzitsiukrẽtsa. Sakyriukrẽnikitsa hurukwy bo zikuruknahaze ikiahatsa kabo tsikozorẽnaha. Kape “O katsa abo tsimytsumuẽhĩ tsihikiknaha.” tsikykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","38","Iwaze simysapyrẽtsa kape maha: “O abazubata iwaze batu tsikykaranaha. Katsaktsa ikia araparẽtaze disahawyty batu abo nyny tsikaha. Ikia arapukrẽtaze batu abo nyny tsikaha. Ikia bipyri tuze batu ape ‘paku tykta!’ batu ape ha tsikaha. Ikia batu asuku batu abo nyny tsikaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ikia amyitsapyrẽtaze ahumo batu mypokzitsiuk. Ikia sakyriukrẽnikitsa hurukwy eze katsaktsa batu abo kozore” niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Iwaze utakta abazubata tihi: “Sinamybyitsa bo tsiksapywykynahaze kabo hi tsiksapywykynaha. Batu kabo tsikykaranaha sinamybyitsa bo tsikykaranaha, sibo tsiksitsumuẽhĩnahaze kabo tsiktsumuẽhĩnaha kabo tsizasapykynahaze kakurẽta. Ikiahatsa sinamybyitsa tsizasapykynahaze kakurẽta kino asahi katukytsa watsa humo.” ");
INSERT INTO rkbNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Iwaze utakta kytsa bo simysapybyikitsa kapawazo taba ispe my: “Nabo pãotaha!” Ikiahatsa ahahumo Deus takyriki sinini ykarawy bo pahapeha, anaeze izo eze tynakoronaha ba zikbe. Anasapy Deus botu zikymy Satanas tsyhyryze iapiktsa kino niwatihi zikymy. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","43","Karaparẽtaze ahadisahawy ty batu kabo nyny tsikaha. Karapukrẽtaze pihik ty batu kabo nyny tsikaha. Bipyri tuze ikiahatsa batu tyso. “Paku tsimy mywahoro awanu sapy” iwa batu tyso. Kakpyrẽtaze batu kasuku humo ahasuk ty batu kabo nyny tsikaha. Kamyitsapyrẽtaze kahumo batu ahamypokzitsiuk. Sakyriukrẽnikitsa hurukwy eze ikypykyrykze batu kabo kozore zikoktyhyryknaha ikiahatsa kahumo batu ahamypokzitsiuk, iwatahi Deus sinini ykarawy bo pahapehahik. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Iwaze asaktsa simysapybyitsa kape maha: “O abazubata batu atyny tsikaha. Katsaktsa ikia araparẽtaze batu abo iktsa tsikaha. Ikia arapukrẽta, bipyri, amyitsapyrẽta, sakyriukrẽnikitsa hurukwy eze iwatsa batu abo iktsa tsikaha, iwatsahi batu aty tsumuẽhĩ” maha. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Iwaze utakta abazubata tihi: “Sinamybyikitsa bo tsisapybyikinahaze kabo hi tsiksapybyikinaha, batu isty tsumuẽhĩze batu katy tsumuẽhĩ” my. Sinamybyikitsa katuk kytsa watsa. ");
INSERT INTO rkbNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Asaktsa simysapybyikitsa tu kapawazo taba sinini ykarawy bo mysipehahik. Ustsa kapanuryk taba simysapyrẽtsa tu iwatsahi Deus tuk tahawahi mynapykyryknaha. Iwa atsaezubaha metutu my — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Kyze Sesus kytsa bo nisihyrinymyrybaze zinymyrykynahatsa pe: — Petok puruze Sudeutsa myikaha Paskoa my. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Nawa puruze Deus taparaktsa nisitsumuẽhĩze bo mytsaty ziknakaranaha. Simyikaha bo tsimahaze utakta Deus zikpehata kasukyrytsitsa pikbezenaha, iharapatawyhyta humo pikyrizikiknaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Kyze taparaktsa Deus wahoro zubata eze ziknapamykysokonahatsitsa, taparaktsa kapitaõtsa Sudeutsa ahatsa niwatihi inapykyknaha, taparakta ziknapamykysokota Kajapas inarokota iwahoro bo inauzuzuknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Asaktsa Sesus isukyrytsitsa niaha. Itsipa humo zioktyhyryknaha tabeze tsihikik. Kytsa papatu tsahi Sesus pibeze tsihikiknaha. Asa zuba tihi: — Hawa zeka kytsa papatu tabezehik — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","— Mymyikaha eze tuze Sesus ba zibezenaha, kytsa pokso mypybyrẽtsa. Tabeze zeka nawa puruze kytsa mymybabanaha, sizubarẽtsa moakmyinaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Kyze Sesus Betanija hudikhudikwy bo niy. Simaõ wahoro bo nitsuk. Tapara Simaõ iakõrõrõtsa humo nibibibaka ata hi nizororota niy. Inaro Simaõ iakõrõrõta niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Anaeze Sesus tadisahakaze sidisahakawy hwibihitsa baze nidyhyky iwaze wytyk inatsuk. Atatsa ibo zumu. Atatsa jokmorẽnikia ty tsipokzitsiarẽna zibykyk. Jokmorẽnikia suk tisapyrẽna arabastero harahare hi tsipokzitsarẽna. Atatsa Sesus bo zumuze tasuk zisoiktsakik iwaze jokmorẽnikia ty zihareksusuku. Iwa nikara. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Zinymyrykynahatsa atatsa bo iktsa niahaze ihumo tahakyrikinaha. Sisakparẽtsa. Atatsa jokmorẽnikia ty ba ziharasusu mytsaty nikaranaha. — Amy skaraba jokmorẽnikia ty ziharasusuku. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ana jokmorẽnikia tsipokzitsiarẽna hỹ. Katsaktsa jokmorẽnikia ty tahuak zeka okyrysaro tsizubarẽna tsimaha. Kyze okyrysaro tsizubarẽna ty sinamybyikitsa bo nyny tsimaha zeka wasani tsimaha — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Kyze siharere humo Sesus tsihyrinymyrẽta. Atahi: — Awatu betsak betsak byitaha. Atatsa tsimysapyrẽtatsa. Amy humo sa tsasukatsihikarẽtsa atatsa kahumo wasani nikara. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Sinamybyikitsa ahapauk baze mynapykyryknaha. Tysitsumuẽhĩekiknaha zeka wasani my. Utakta ahatuk batu mopykyryk kabo ka ba nyny zikaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Abanurytu pikbezenaha. Mohyrikosokda. Atatsa kanury ziharasusuku kymyba. Mohyrikosokdaze atatsa botu jokmorẽnikia ty pikarasusu — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","— Kaharere wasani nanabyitaba Deus wasania ty kytsa sizubarẽtsa bo motsasonaha. Hawa atatsa katsyhyryze niy ana kino niwatihi nanabyitaba mynapamykysokonaha niwatihi iwaze kytsa atatsa soho bo mytsaty mykaranaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kyze Sudas Iskariotses estuba Sesus zinymyrykyta isukyrytsitsa bo zumu. Imyspihikbatanikita tu Deus wahoro zubata eze ziknapamykysokonahatsa tuk taparakta bo zumu. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Atahi: — O Sesus humo batu ahakparawy. Tsipibeze tsihikiknaha. Uta pahatsumuẽhĩ. Bykyze uta hi ibo pahaoktyhyryk. Uta pahatsumuẽhĩ zeka amy ty sa kabo nyny tsimaha — niy. — O ikia tsimytsumuẽhĩ zeka okyrysaro ty abo nyny tsimaha, tirĩta okyrysaro parata hi abo nyny tsimaha — niaha. — Yhỹ. Bykyzehuta! Aba piksizo. — Yhỹ. Tsipiksi. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kyze Sudas mytsaty nikara — Hawa sa Sesus bo mysioktyhyryk. Yhỹ ja. Bykyzehu — niy. Ziperyky zuba. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Kyze estuba puruze imyikaha eze Sudeutsa Deus taparaktsa nisitsumuẽhĩ naha bo mytsaty ziknakaranaha. Atsikara ikpytowybara tu ty ziokoknaha tamyikaha eze nikaranaha. Nawa puruze zinymyrykynahatsa Sesus pe: — Hana eze sa mymyikaha tsipikymynaha. Hana eze sa ikia baze tsimymydisahanaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","— O nabo myzubaha boktsa! Tohi boktsa! ipe myhyrinymyrykytsa tihi: “Bykyze pikbezenaha. Awahoro eze mymyikaha bo tsimaha. Awahoro utakta zinymyrykynahatsa tuk hauk tsimaha” tsimaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Yhỹ niaha. Sesus harere bo hyỹ niaha. Simyikaha nakymy, hozipyrykzatsa ni nizokonaha. Wasani niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Zunubakaze Sesus tuk zinymyrykynahatsa sizubarẽtsa dose tahadisahakanaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Tahadisahakanahaze Sesus ispe niy: — Kaharere wasani ahatuk estuba. “O Sesus kaharereziuwybyita. Abaka batu Sesus tukta my” mykara. Atakta kahumo iakyriwy tu mozuruku kasukyrytsitsa tuk kabo nasioktynaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Iwaha ziwabynahatsa hi batu siaku. Sisukatsihikrẽtsa tu ipe: — O aty skaraba “Utakta batu Utakta batu” — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","— Estuba katuk tamihi ty sok mytahi kasukyrytsitsa bo pikoktyhyryk. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Utakta Deus zikpehata kytsa wata ikyzik ahasapyzeky mohyrikosokda. Tubabatu kytsa Deus harere papeu humo isoho botu ziwatahakanaha. Abaka ziwatahakanaha atsatu my. Atakta Deus zikpehata humo iakyriwy tu mozuruku sinini mykara. Atakta ipuruk byizeka wasani my, atahi sinini ykarawy bo tawahi mynapykyryk — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Iwaze Sudas iakyriwy tuze Sesus pe niy: — O kahyrinymyrykytsa, ikia hi sa kasoho tsimytsaso — niy. — Ikia hi tsimytsasoko — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Kyze tahadisahabanahaze, Sesus atsikara hyritywaha ty okok niy Deus pe: — Ikia tsamysapyrẽta ahumo ka mykurẽtsa — niy. Atsikara ty tsak niy. Zinymyrykynahatsa bo nyny niy: — O hauk tahaktsa! Atsikara kanury waha my. Naka hauk tsimahaze kanury soho bo mytsaty tsimaha. “Sesus mysapyzeky nihyrikosokda” tsimaha — niy. Iwa niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kyze taoporosuk ty paik niy Deus pe: — Ikia tsamysapyrẽta ahumo ka mykurẽtsa — niy. Taoporosuk ty zinymyrykynahatsa bo nyny niy: — O tsõtahaktsa kytsa! ");
INSERT INTO rkbNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Duabohotsa tsik kaspu waha my. Tsõ tsimahaze kaspu soho bo mytsaty tsimaha. Hawa ahasapyzeky nihyrikosokda. Tubabatu kaharere nawa niy abazuba atsatu my. Iwatahi Deus ahasoho pe my: “simysapybara humo mysiokzo iwatsahi kaokzeka meky watu moziknaha” Deus nikara — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","— Utakta aba zuba duabohotsa tsik piku. Pikuzoze Deus kazo tuk kytsa tuk asaktsa kaharere bo hyỹ mykaranaha katyryktsa moziknaha. Deus tyryktsa mozumunahaze pikuzo — niy. Iwaze sizubarẽtsa duabohotsa tsik zikukunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Iwaze Deus bo nisakibazikiknaha — O ikia tsamysapyrẽta — niaha. Deus bo nisakibazibanahaze ape bo ziponaha. Oriwereja inarokoha hara bo niukurunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Kyze Sesus ispe niy: — Utakta mohyrikosokda. Aba ikiahatsa kahumo batu ahaspirikpo, tsipikarekbaiknaha. Tubabatu Deus harere tihi: “Uta hozipyrykzatsa irarakata pibeze iwaze hozipyrykzatsa nanabyitaba mowakbaiknaha” Deus niy. Iharere taparakta ituktsa kino niwatihi sisoho nitsasoko. Iwaha kabo my. Kasukyrytsitsa pokso tsimywakiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Deus mozikyrizikpowyzoze aharaze Karireja bo my — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Kyze Peduru: — Ustsa ahumo batu sispirikpo utakta batu. Uta kino atuk mykara ba zaharek — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","— O Peduru, kyze kokuaro ipobyi tu “Batu Sesus kanyhy”. Iwa harakykbyi mybarapetu tsimy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","— O niwazubakta! Atuk tu pikbezenaha zeka “Utakta Sesus tukta zinymyrykyta” my — niy. Sizubarẽtsa kino niwatihi nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Kyze Sesus tuk zinymyrykynahatsa tuk niukurunaha. Kesemani isaziktsa koso bo zumunahaze ispe niy: — Anaeze dyhy dyhytaha. Uta kino nohi eze Deus bo mopamykyso — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ustsa dyhy dyhy niahaze, tatuktsa Peduru, Suão, Tsiaku iwatsa nisioktyhyk. Sesus mytsaty nikara. — O bykyze pikbezenaha — nikara. Batu iaku. Tisukatsihikrẽta. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Tatuktsa pe: — O batu kaku. Kasukatsihikrẽta tu pomoza tawa muku. Tykareze tu tsipiperynaha. Ahatõtsabyrihu ja! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Siharapu bo harakmotohi niy. Wytyk bo okmymy niy. Deus bo nipamykysoko. Iwaze Deus pe niy: — O kasukyrytsitsa kabo mozumunaha kazo. Sinini mynakara. Nabo kabara botu sakpyty. Utakta batu kahyrikosokda tsihik. Ikia kape: “Tyhyrikosokdakta” tsimy zeka mohyrikosokda aharere bo hyỹ my — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Kyze tatuktsa harakykbyihi ahatsa bo ziksizo zurubakanaha. Peduru pe niy: — O tsikurubaiknaha ja kytsa. Katuk batu tsiperykynaha ja hini hini byitahaktsa. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ikiahatsa Deus bo typamykysonahaktsa! Ikiahatsa tihi: “O Deus myzo katsaktsa batu mypunihik ana kino tsinymyry mysapybara humo batu mykparawy iwatahi tymytsumuẽhĩ” iwatsahi Satanas harere bo batu hỹ tsimaha. Hawa ha ty wasani tsipitsihikiknaha, ahapunihikbyitsa tu kaharere bo batu yhỹ tsimaha ana humo hi kahyrinymyrẽta — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Siharapu bozo niyze iwaze Deus bo nipamykysokozo: — O kazo hawa ha ty tsimyzihikik ana bo hi hyỹ my. “Tyhyrikosokda” tsimy zeka, uta mohyrikosokda sinini mynakara — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Iwaze tatuktsa bo ziksizo. Zurubakazonaha. Siõtutsarẽtsa. Iwaze niparakzo. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Sesus siharapu bozo niyze Deus bo nipamykysokozo. Iharere atsatu Deus bo nipamykysokozo. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Iwaze zinymyrykynahatsa bo ziksizo. — O tsikpurubakanaha zuba. Tsipahabyrykynaha. Abaka batukta! Utakta Deus zikpehata kytsa wata ikyzik kasukyrytsitsa kabo mozumukunaha abahi pikbezenaha. Sinini mynakara. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Kyiktahaktsa! Tupaktsa! Atakta kahumo iakyriwy kasukyrytsitsa kabo mynasioktykyryk mozumubahanikinaha. Kasukyrytsitsa tuk mozumuku. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ana hi nipamykysokoze Sudas ibo zumu. Sudas zinymyrykyta iharereziubyitsa tuk, isukyrytsitsa Sesus bo inasioktykyryk. Kytsa sizubarẽtsa ituk tahatanoratsa tahaupepetsa iwa nasebykyknaha. Sudeutsa, taparaktsa Deus wahoro zubata eze ziknapamykysokonahatsa kino niwatihi nisipehanaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Tapara Sudas ispe niy: — Kytsa Sesus tuk piwatawyze piharapyrykze ahanyhybyitsa tsipinynaha. Ataty paiktahaktsa! Itsipa humo tsioktyhyryknahaktsa! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Iwaze Sesus bo zumuze: — O kahyrinymyrytsa ikzumu — niy. Sesus ziharapyryk. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Sesus: — Katukta katy hawa tsimy aidytykta tsimy — niy. Kyze kytsa Sesus nizokbatsinaha itsipa humo zioktyhyknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ipaukbazekta Sesus tuk zinymyrykyta tasokorotsapu zibokik. Ziknapamykysokota taparakta itsumuẽhĩtsa ispi zezykik. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Sesus: — Niwazubakta. Asokorotsapu isapy bo kurukty. Ikiahatsa ahasokorotsaputsa tuk tsipihuzedukunaha zeka ikiahatsa kino niwatihi sokorotsaputsa ty pahabanaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Kazo bo myzapyky zeka: “O kazo tsipiktsumuẽhĩkta my zeka tahi bijoikpe iknyktsitsa sizubarẽtsa kabo mysipeha ana kino ahahyrinymyryhu ja. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","O kazo tsipiktsumuẽhĩkta” batu tsaso ana kino my zeka Deus harere batu wasani my. Tubabatu Deus harere kasoho botu nitsaso iwa atsatu mykara hỹ — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Iwaze Sesus kytsa sizubarẽtsa pe niy: — Utakta katsyhyryboabyita. Batu kakyri iwaze amy skaraba ahaupepetsa ahatanorotsa iwatsa tsiknasebykyknaha! Awatutaha. Ikiahatsa tuk zikzibyituhukutu Deus wahoro zubata eze ahahyrinymyryky. Iwatsa tu sa batu katsipa humo katy oktyhyryk. Abaka wasiza katsipa humo tsikoktyhyryknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kytsa pikoktyhyryknaha iwa niy. Hawa ha ty Deus harere tubabatu nikara atsatu mykara. Iharere wasani my — niy. Iwaze anaty ziwabynahaze zinymyrykynahatsa niwakbaiknaha. Sipybyrẽtsa. Kytsa pokso niwakiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Iwaze asaktsa Sesus tsipa humo zioktyhyryknaha Kajapas wahoro bo niaha. Kajapas imyhyrizikwanikita, Deus wahoro zubata eze ziknapamykysokonahatsa tuk. Moises harere kytsa nisihyrinymyrykynahatsa, Sudeutsa taparaktsa iwatsa sizubarẽtsa anaeze ziknapykyryknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Peduru Sesus hapik atazuba niukuru. Iwaze Kajapas wahoro peze nidyhyky. Deus wahoro zubata perytsitsa tuk nidyhyky. Hawa sa maha ana kino ziwaby tsihikik iwatahi kytsa baze nidyhyky. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Taparaktsa Deus wahoro zubata eze ziknapamykysokonahatsa, ustsaktsa kytsa Deus wahoro siharerewabytsitsa ahatsa hawa kytsa imysapybyi ziwabykynaha. Asahi inakypyknahaze kytsa Sesus soho metuwy piwaby tsihikiknaha. Iwaze siharere humo pibeze tsihikiknaha. Isoho mekywa tu nitsasokonaha iwatsahi batu tybeze. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Kytsa isoho zispihikbatakanaha, siharere batu amy tohi iwatsahi Sesus batu tybeze. Mekywatu nitsasokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Kyze kytsa petoktsa tihi: — Atakta maku tihi “Deus wahoro zubata mokarakbaik zeka petok puruze mozoknizo” niy — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nitsasobanahaze, Kajapas myhyrizikwanikita rikto niyze: — Amo Sesus kytsa asoho nitsasokonaha asoho zisapybyikinaha ana soho tsiwaby. Hawa sa tsimy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Batu harere, tahabyi pyk zuba niy. Iwaze ziknapamykysokota tihi: — Deus okzeka atahi aharere piwabyky hawa Sesus. Ikiahi ja Deus zapehata. Ikia ja Deus tse — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","— Ikiahi iwa tsimytsasoko. Abaka Deus zipehata atahi Deus zikwyrẽnikita ipanuryk taba dyhy my. Utakta bijoikpe satata tuk mynasikzo ana bo kino iktsa tsimaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Imyhyrizikwanikita anaharere ziwabyze takyriki. Tasuk zisykik iwa takyrikize ziwatawyky iwa sisopyk. Atahi: — Deus soho ziharereziubyiki anaharere tsiwabykynaha. Niwazuba ustsa kytsa harere batu mywaby — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","— Hawa ha ty isoho mytsaty tsimykaranaha. Hawa sa ity tsimaha — niy. — Hawa batu sapy nikara mytsaty tsimykaranaha. Iwaze tabezehikta! tabezehikta! — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Zehezozokoknaha. Zihyrizikwarakanahaze nitsakikinaha. — Aty sa zaki. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Deus zapehata babata tsimy zeka. Aty sa zaki — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Kyze Peduru wahoro peze nidyhyky. Itsumuẽhĩtsata ibo nikozo. Atatsahi: — O ikia hi sa Sesus Karireja ezekta tukta — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Peduru: — O batu. Batu kanyhy — kytsa pe niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Kyze pakuwyta boze ustatsa itsumuẽhĩtsata kytsa pe: — Atakta Sesus Nasare ezekta tukta — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","— O batukta niy. Kaharere wasani my Sesus batu kanyhy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kyze kytsa ibo niaha. Asaktsa: — Ikia Sesus tukta tsimy. Aharere Karireja ezekta wata — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Iwaze Peduru tsipybyrẽta nitsaso: — Batu kanyhy. Aty skaraba Sesus. Deus okzeka motsaso iwaze kaharere imysapybara zeka, Deus piksininiwyky, motsasozo Sesus batu kanyhy — niy. Nitsasokoze atsoko kokuaro nipo ");
INSERT INTO rkbNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Peduru mytsaty niy. Tapara Sesus: — O kokuaro pobyituze “Batu Sesus kanyhy” iwa tsimytsaso — niy. Peduru niparak. Ape baze nipuziuku. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kyze zokorobyitu Sudeutsa taparaktsa sizubarẽtsa ziknapamykysokonahatsa Deus wahoro zubata eze iwa inakypyknahaze asaktsa hi: — Hawa sa tsimaha iwaze Sesus tabezehik. Katsaktsa ba zibezenaha batu zikaha iwatsahi Piratus bo abazubata ata hi zuba mymypeha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Iwaze kytsa Sesus zipawarakanaha, Piratus bo zioktyhyryknaha. Piratus myhyrizikwanikita iharere awatu zeka Sudeutsa ba zibezenaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Kyze Sudas atakta Sesus humo iakyriwy — Sesus tabeze — ana hi ziwabyze tisukatsihikrẽta niyzik. Imysapybyita hi zerekyzyky iwatahi okyrysaro parata hi ziknapamykysokonahatsa taparaktsa kapitãotsa ahatsa sibo okyrysaro ty nynyrezo niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Atahi: — Utakta kamyspihikbatakanikita Sesus tsimysapyrẽta aba kytsa pibezenaha — niy. Kytsa ipe: — Hawa tsiky ana humo hi batu mytsaty. Hawa tsiky ikia hi ana humo mytsatyziu tsimykara — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Iwaze Sudas okyrysaro parata hi Deus wahoro zubata eze nisipaparahikze zoihik. Atatu tabeze tsazikiha humo tatsubere borok iwa tabeze. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ziknapamykysokonahatsa taparaktsa okyrysaro parata hi zebykyknaha atsahi: — Okyrysaro maku huakba ziaksenaha iwaze Deus wahoro zubata okyrysaro suk bo batu koro tsimaha. Moises harere ana hi nimyhyrinymyryky. Hawa ja tsimaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Iwaze nahapepehaikiknahaze okyrysaro ty itsuhuk zihuaknaha. Maku aektsikni humo tarabaja nikara itsuhuk ziaksenaha okyrysaro humo. Anaeze Sudeutsabyitsa mysiytyknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Aba kino — Iytyk spu — inarokoha nikaranaha. Okyrysaro itsuhuk huak niaha maku nihyrikosokda. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ana ty hi niahaze Deus sohokotsa Seremias tubabatu ziwatahaka atsatu my. Ta tihi: — Okyrysaro ty okyrysaro parata hi zibykyknaha, ana kino Sudeutsa ihumo zihuaknaha, kyze itsuhuk ty bo ziaksehyk niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ana okyrysaro ty itsuhuk huak ziaksehyknaha. Aektsikni humo tarabaja ziknakarata itsuhuk huak ziaksehyk naha okyrysaro tuk — Seremias niy. Hawa Deus niy Seremias botu ziwatahaka abazuba anaharere atsatu niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Kyze Sesus Piratus myhyrizikwanikita bo zioktykyryknaha. Piratus: — O Sesus ikia ja Sudeutsa pehatsa — niy. — Yhỹ ikia hi tsiktsaso — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ziknapamykysokonahatsa taparaktsa kapitaõtsa kino niwatihi nitsasokonaha: — Atakta zisapybyiki — nikaranaha. Sesus sibo batu harere. Tahabyi ziwaby zuba. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Iwaze Piratus ipe niy: — Siharere ty sa batu waby. Amo sa batu mysapy asoho nitsasokonaha. Iwa sa wasani — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Batu harere. Iwatahi Piratus tsipybyrẽta nikara iwatahi: — O amo skaraba batu harere ziky, batu aokani — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Tubabatu Paskoa myikaha eze tahasopyk ty hi ziknakaranahaze Piratus maku estuba nizuke. Kytsa maku ziwatawyhik. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Kytsa sizubarẽtsa sakyriukrẽnikitsa hurukwy eze, estuba Bahabas inarokota. Kytsa bakatsa iwata hi nitsahuruknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kytsa sizubarẽtsa inakypyknahaze Piratus ispe niy: — Aty sa myzuke. Bahabas ja ahabo myzuke. Sesus kytsa isoho “O Kiristu Deus zipehata” maha, atahi ja ahabo myzuke. Aty sa tsipiwatawynaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ziknapamykysokonahatsa sizokdirẽtsa iwatsahi Sesus ibo zioktyhyryknaha ana humo hi Piratus tsihyrinymyrẽta. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Piratus kytsa harerewabykywy eze nidyhyky. Kyze ioke mysohokotsa zipeha. Atahi: — O aoke tihi “Unata Sesus soho zitsotospykze. Atakta tsimysapyrẽta. Batu imyi. Mybara botu sapy ty katsotyspyk humo mytsatyziu tsimykara” niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ziknapamykysokonahatsa taparaktsa kapitaõtsa kino niwatihi kytsa sizubarẽtsa bo niaha. Nisipehaka “O Bahabas tsipiwatawynaha.” Sesus “tabezekta” tsimykaranaha, iwa Piratus bo tsimykaranaha — nikaranaha. Iwa kytsa papatu sukyryze nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kyze Piratus kytsa sizubarẽtsa pe: — O aty sa myzuke. Bahabas ja myzuke. Sesus ja myzuke. Aty skaraba iwatawyhyta — niy. — Bahabas! — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","— Sesus ja. Atakta kytsa isoho Deus zipehata Kiristu my. Hawa sa my Sesus ty — niy. — Tabezekta! Iharapatawyhyta humo tabezekta! — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","— Hawa niyta sa tsipibeze tsihikiknaha. Batu imyiki — niy. Kytsa aparakbaha: — Tabezekta! — kazi nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Kytsa sizubarẽtsa asiba niharapehudidunaha iwaze Piratus harere batu siwabyhy ana humo hi tsipybyrẽta. Iwaze pihik ty tatsyhyrype pikik. Sizubarẽtsa okzeka tatsyhyrype pikikze atahi ispe niy: — Atakta maku tsimysapyrẽta. Iwatahi tsipibezenaha zeka batu kamyzihik ikiahatsa zuba “tsibezenaha” — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Kyze kytsa sizubarẽtsa tihi: — Katsa mytsekokatsa niwatihi ata maku mynamopykwy zeka wasi — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Iwaze Bahabas nizuke, Sesus ta batu, sodadutsa pe: — O tytsakinahaktsa! Siraratsa hwyk tsadikihi ty tytsakinaha. Bykyze iharapatawyhyta humo tsibezenahaktsa! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Iwaze sodadutsa Piratus wahoro bo zioktyhyryknaha. Sodadutsa sizubarẽtsa iharape inakypykyknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Isuk ty hyrykok niaha. Isuk tsahirita ty zisuknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Inisaha ty zitsorikiknahaze iharek humo pu niaha. Hwi sarapa tsibik ty ipanuryk taba tybykyhy niaha. Iwaze zimyijakanaha. Tahaekaratsa humo iokeryk puruk puruk nikaranaha, sipehakatsa okeryk watsa iwa zisininiwy. Asa tihi: — O Sudeutsa abazubata ja. Tsizuruku mypehatsa ana kino tsimyzihikiknaha — mybarapetu nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ity zehezozokikiknaha. Hwi ty tahawa tu ziharektotokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Zimyijabanahaze isuk tsahirita ty hyrykok niaha. Isukbabata ty ihumo korobykzo niaha. Iwaze mekybotu zioktyhyryknaha. Nabo tabeze nikaranaha. Iharapatawyhyta humo tabeze nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ske buruk niukurunahaze Simaõ nasihobyk. Simaõ Sireni ezekta niy. Sodadutsa ipe niaha: — O iharapatawyhyta tsebykta! — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Nabo zebykyryk. Anasapy kokota inarokota Sudeutsa harere iharekpokoso ziwatawy. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Anabo zumunahaze mymyitsapyri hwi ty Sesus bo nyny niaha. Naka isipianikia ty tsikaeni zuba ziakpy batu tsõ. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Sodadutsa iharapatawyhyta humo zihyrizikiknaha. Ipapepe eze zihyrizikiknaha. Ipyrytsa eze kino niwatihi zihyrizikiknaha zikymynahaze iharapatawyhyta zitseknahaze ziriktonaha. Sodadutsa isuk ziakse tsihikiknahatsa haraharezipyryktsa ty nisipaparakanaha. Aty ja Sesus suk piakse nikaranaha tsahi ziwatawykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Iwaze nidyhydyhykynaha. Sesus iharapatawyhyta humo zihyrikbanahaze zihaperykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Iharapu bete iwatahaha. SUDEUTSA PEHATSA ziwatahakanaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Kytsa petoktsa ituk nisibanaha. Sitsyhyryboanikitsa. Siharapatawyhytsa humo nisibanaha, estuba ipanuryk taba usta ipawazo taba ahatsa niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Iwaze kytsa nabaze ske buruk nikaranahatsa zisapybyrikinaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Asaktsa: — O Ikia “Deus wahoro zubata myokarabaka bykyze petok puruze usta mozoknizo” tsikykara abaka tsimyhyrikosokda. Ikia Deus tse tsimyzeka ja parany! tsimy. Tynasikta! Bazekara — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Deus wahoro zubata eze ziknapamykysokonahatsa taparaktsa kapitaõtsa, Moises harere iwatahatsitsa iwatsa zisakpybyrikinaha niwatihi. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","— O ustsa tsiksitsumuẽhĩkĩ, ikia tu tsikaktsumuẽhĩkta! Sudeutsa pehatsa ja. Iwatatu sa tsipomozaka. Sudeutsa pehatsa babata zeka, Deus tse zeka tynasikta! Iwa bo tsimykozonaha zeka “O Sesus Sudeutsa pehatsa” tsimaha — mybarapetu nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","— Atahi Deus humo tispirikporẽta, “Utakta Deus tse” niy. Abaka Deus ihumo tsimypokzitsiurẽta zeka iktsa tsimaha. Deus ity pitsumuẽhĩ naha bo iktsa tsimaha — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Sitsyhyryboanikitsa siharapatawyhytsa humo mohyrikosokdanaha nataba natabaha ibo atsatu zisapybyrikinaha ");
INSERT INTO rkbNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kyze tokbaha eze miwa niyzik. Batu haramweke. Nanabyitaba haramwe byitatu. Bykyze iharakibikia bo zoize inaharamwezo. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Iharakibikia boze Sesus opykani huahua niy: — “Eri Eri rama sabaktani” kaka niy. Myharere piwatawy, “O Deus ikia humo kaspirikporẽta. Amy skaraba uta zuba tsipikarikik.” — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Wastuhu nabaze niriktohokonaha ana harere ziwabynahaze: — O amo sa Erias bo hua mykara — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Tohi duabohotsa tsik itsãrãkbara ty morosuk eze ky ty tsikok niy. Anabo mazori waha ty duabohotsa tsik bo sokyk niy, zipypyiki. Mazori waha ty hwi humo zitsihi jobo Sesus sak bo tsyktsyk nikara. Sesus batu tsõ. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ustsa kytsa tihi: — Byriktsa! Tozeka ja Erias mozumu tsiperynahaktsa kytsa! — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Iwaze Sesus kakazo niyze nihyrikosokda. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Iwaze panu ipamaba ipokpedawy Deus wahoro zubata eze ky nisykbaik. Tsapukte buruk bijoikny tu niaksykyryk. Wytyk nitydydykyk tu. Haraharetsa nitõbaiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Tahaytykeze kytsa puke puke niaha. Siakbatsa Deus humo sispirikporẽtsa inahyrizikpobanaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Bykyze Sesus inahyrizikpoze Serusarẽhe bo inapupunaha. Anaeze kytsa sizubarẽtsa sibo nikozonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kyze sodadutsa Sesus ziharaperykynaha. Wytyk nidydykyze sipybyrẽtsa. Hawa sa nikaranaha niakozonahaze sipybyrẽtsa: — O atahi Deus tse babata — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Kykyryk tihi ẽrykzatu nikozokonaha. Asiza Karireja ikny iapik niukurunaha. Sitsumuẽhĩza tu ihumo simypokzitsiukrẽza. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Situk Maria Madarena, ustatsa Maria Tsiaku Sose ahatsaje, ustatsa Sebedeu oke iwaza ẽryk tu ibo nikozokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Kyze nubaze Sose Arimeteja ezekta zumu. Tsinamyrẽta niy. Atakta niwatihi Sesus tuk zinymyrykyta niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Piratus bo izumu. Sose: — O Sesus nury ty uta kabokta Piratus! Uta iytyk bo mytsahorok — niy. Yhỹ niy. Iwaze sodadu pe: — Sesus nury ty Sose bo nynyty! — niy. Iwa hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Sose inury nazipikze panu tsiziurẽna eze ziakwaraka. Tubatu Sose taytyk zitua bo anabo hi nitsahorok. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Iyktaba ezytyk anaeze inury ty hoekare niy. Harahare bobyri ihok bo zihokbore. Iwaze niparak. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Madarena, ustatsa Maria iytyk nizokparakanaha. Iytyk baze nidyhydyhykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Hinipỹ sesta-peira ziharamuze okoroze sibyrykywy bo zumu ziknapamykysokonahatsa Deus wahoro zubata taparaktsa, Pariseutsa iwatsa Piratus bo niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Asa tihi: — Mypehakatsa, mospihikbatakata atatuze petok puruze Deus mozihyrizikpowy niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Iwatahi sodadutsa tysipeha iytyk pehaperykynaha, okoroze. Iwaze zinymyrykynahatsa inury ba ziakse naha kytsa pe “O Sesus inahyrizikpo” maha ana harere pokso iytyk bo sodadutsa pe pykyhytutaha. Zinymyrykynahatsa tihi “Sesus Deus zipehata” niaha ana harere batu sapy niy, abaka “Sesus inahyrizikpo” maha zeka ana harere isapybara baba — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","— Ahaharere humo sodadutsa ahatuk mysipeha. Iytyk pykyhytu tsizoziknaha iwaze batu aty tohi ana bo ba ziktsuk — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Iwaze nitururuknaha. Iytyk bo niaha. Harahare bobyri zihokbore tsazikihia tuk zihirikiknaha nawa batu aty tohi ana bo ba ziktsuk. Iwaze sodadutsa pe niaha: — Iytyk tsihaperykynaha! — niaha. Iwa hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Kyze petok zuruze, sabado ziharamuze kykyryk iytyk bo niukuruzonaha. Domiko miwa botu Maria Madarena ustatsa Maria kino niwatihi iytyk bo zumuzonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Atsoko wytyk nitydydydykyktu. Iwaze bijoikpe iknykta Deus tsumuẽhĩtsa inasik harahare bobyri zipetu ibete nidyhyky. ");
INSERT INTO rkbNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Bijoikpe iknykta tisukbarazarẽta katsaktsa ibarazabaharẽta batu mynyhy. Paiparezo mykaranaha ihyrikoso waha bijoikpe myze iwa bijoikpe iknykta wata my. ");
INSERT INTO rkbNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Sodadutsa ipokso mytydydykyknaha. Sipybyrẽtsa nikaranaha iwatsahi wytyk bo inarahanaha. Siakbatsa watsa niyziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Bijoikpe iknykta kykyryk pe niy: — Ahapyby byihu ja! Sesus iharapatawyhyta humo nihyrikosokdata tsipiberikinaha ana kino kanymyrẽta. ");
INSERT INTO rkbNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Atakta iytyk eze hana bo ja. Hawa botu niy nahyrizikpo. Iktsataha isapy bo anaeze nihoeke. ");
INSERT INTO rkbNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Aidytyktsa! Nabo zinymyrykynahatsa bo tynakozorenahaktsa! ispe tsimaha: “O inahyrizikpo aharaze Karireja bo my, nabo ibo iktsa tsimaha. Aba tsipinynaha”. Kaharere tsiwabyziunaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Iwaze iytyk ekze nitururuknaha. O Sesus nahyrizikpo sakurẽza nikaranaha. Sipybyrẽza nikaranaha Sesus tuk zinymyrykynahatsa pe aidy niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Atsoko Sesus nisihobyk: — Awy ahapyby byihu ja! Ahapunihikrẽtsaktsa! — niy. Kykyryk ibo zumunahaze ipyrytsa humo paik paik niaha. — Ikia tsamysapyrẽta ahumo zuba mykurẽza — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","— Ahapyby byihu ja! Zinymyrykynahatsa bo katuk kytsa bo tsimahaktsa! Ispe tsimaha: “Karireja bo tsimaha nabo kabo iktsa tsimaha” tsimaha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Iwaze wytykyryk ske buruk niukurunahaze wastuhu sodadutsa, asahi iytyk ziharaperykynaha sihudikhudikwy bo ziksizonaha. Hawa ty nikara Deus wahoro zubata ziknapamykysokonahatsa taparaktsa bo nipamykysokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Kyze taparaktsa ziknapamykysokonahatsa taparaktsa ypykytsa bo niaha. Asa zuba inapamykysonaha. — Hawa sa tsimaha — nikaranaha. Iwaze tsizubarẽna okyrysaro ty sodadutsa bo nyny niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ispe niaha: — Ikiahatsaktsa kytsa pe “Unata eze tsikurunahaze iwaze zinymyrykynahatsa izumunaha inury zibykyknaha” tsimaha iwa kytsa bo tytsaso — niaha. Yhỹ niaha. Iwa humo okyrysaro ty sodadutsa bo nyny niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Homa pehatsaktsa Piratus taharere piwaby zeka, katsaktsa ipe: — Sodadutsa wasani maha tsimaha. Iwa ahahumo batu takyri, iperykynahatsa sõtutsarẽtsa tuze batu takyri myharere humo. Iwatsahi mytsaty mytsaty byijataha! — ziknapamykysokonahatsa niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Iwaze Sudeutsa perykynahatsa okyrysaro tsizubarẽna ziaksenaha. Hawa ha ty ziknapamykysokonahatsa sibo nitsasonaha atsatu ziknapamykysokonaha. Sudeutsa anaharere bo yhỹ mykaranaha abaka bo yhỹ mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Kyze zinymyrykynahatsa õse Karireja bo niukurunaha. Hara bo nidokoknaha. Anaeze Sesus botu nitsaso nabo izumunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Sesus bo inakozonahaze iokeryk taekaratsa humo puruk puruk niaha. — O ikia tsamysapyrẽta tsimy ikia humo mykurẽtsa — ipe nikaranaha. Wastuhu kytsa — O inahyrizikpo ja batu kanyhy nikaranaha. — Ustsa kytsa sihyrinymyrẽtsa nikaranaha ihumo sispirikporẽtsa. ");
INSERT INTO rkbNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Sesus sipauk baze tu natakaha ispe niy: — Kanamy tsizubarẽna, bijoikpe eze tu mysipehaka, mybarawy eze tu mysipehaka tsizubarẽna ty Deus kabo nyny niy. ");
INSERT INTO rkbNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Iwatahi aparakbaha naboktsa! Nanabyitaba tsimykurunaha ityryktsa aparakbaha bo wasanihaty tytsasonahaktsa! Katuktsa moziknaha tsipiksopykzukunaha kaharere bo yhỹ mykaranaha. Iwaze mysiharasusukunahaze Deus inaokota tytsasonaha. Iharere humo mysiharasusukunaha Deus myzo, Deus tse, Deus hyrikoso iwa tytsasonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Hawa botu zahahyrinymyry hyỹ tsimykaranaha atsatu tysihyrinymyrykynahaktsa! Ahatuk mynapykyryk pahatsumuẽhĩ mykara. Mybarawy nepykze ahapauk baze tu mykara tawahi mynapykyryk. Iwa hỹ — Sesus niy.");
INSERT INTO rkbNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Papeu humo Deus wasania ty Sesus Kiristu soho ziwatahaka. Sesus Kiristu Deus tse. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ata hi mybarawy bo inasikta ana kino Deus sohotsa Isaijas botu ziwatahaka. Isaijas hawa niy, tubabatu ziwatahaka tahi: — Tapara katsumuẽtsa aharaze pipeha. Hawa katsa myske piskezozeke atahi aske piwatawy. Piskezozeke. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Atahi jerukbara eze hua mykara “Pykyhytuty Deus zipehata ske buruk tsimaha. Tsipiskezozekeknaha. Iske buruhuwa tu taha. Iwa iske takymy” iwaze Deus zipehata mozumuze mokuru — niy. Iwa Deus sohokotsa niy. Hawa kytsa mokymynaha Deus zipehata harere bo yhỹ mykaranaha ana hi motsasoko. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Anaharere wa Suão Batista jerukbara bo izumu. Anaeze Deus harere nitsasoko kytsa nisiharasusuku. Atahi: — O kytsa ahamysapybyi tsimoewynahaktsa tynamyharasusukta! Tsipiharasusunaha zeka iwatawy kytsa bo meky watu tsimoziknaha, ahamysapybyitsa tsikykaranaha tsimoewy tsihikiknaha — niy. Iwaze Deus ahamysapybyitsa tsikykaranaha humo pahaokzohik. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Sizubarẽtsa Suão Batista bo zumukunaha. Serusarẽhe ezektsa Sudeja ezektsa iwatsa ibo ziknakaranaha. Suão sizubarẽtsa ziknasiharasusuku. Nisiharasusukuze asa kino: — Tapara mysapybyitsa tsikykaranaha. Abaka batu meky watu tsimoziknaha mysapybyi tsikykaranaha anahi tamoewy tsihikik — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Suão kamero hwyk zikziwaskik niy. Irikpidiwy kino kamero hwyk. Masetsa ziknasiboroko. Pete zikzerukuk ziknakara. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Myzubaha bo ziknatsasokoze: — Usta mozumuze. Atahi tsimysapyrẽta, iwatahi myhyrizikwani. Utakta batu. Iwatahi kasikpybyrẽta. Ipyrysuktsa mysibobokzeka kasikpybyrẽta mozik. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Utakta pihik ty zuba kytsa mysiharasusuku. Atakta Deus hyrikoso pipehaka. Mynasikze ahatuk mynapykyryk iwatsahi ihumo meky watu ahamysapyrẽtsa tsimoziknaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Iwaze Sesus Suão bo izumu. Nasare iknykta. Nasare Karireja eze tu. Suão bo zumuze, taharasusu tsihikik iwatahi ibo zumu. Suão buburu Sorodão inarokota eze kytsa nisiharasusuku. Anaeze hi Sesus kino ziharasu. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Pihik ikny inazoze atsoko bijoikpe sakpare iktsa niy. Deus hyrikoso ibo inasik, amytudu hyrity wata ibo inasik. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Iwaze bijoikpe ikny iaksoho ziwaby Deus hi: — Ikia hi katse babata. Ikia humo ka kamypokzitsiarẽta. Ikia humo kakurẽta — niy. Iwa Deus Sesus pe niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Iwaze Deus hyrikoso hi Sesus jerukbara bo zioktyhyryk. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Anaeze estuba byzoje zirahaze. Kuarẽta zuruze anaeze ziknapykyryk. Anaeze sasabyitsa niaha. Satanas hyrikoso sapybara pehatsa Sesus Deus harere bo ka yhỹbyitykta nizihikik. Batu zik. Sesus ipe batu yhỹ niy. Iwaze bijoikpe iknyktsitsa Deus tsumuẽhĩtsitsa Sesus ziperykynaha. Iwa de ");
INSERT INTO rkbNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kytsa Suão Batista tsipa humo sakyriukrẽnikitsa hurukwy bo zioktyhyryknaha. Iwaze Sesus Karireja bo ziksizo Deus harere wasania ty nitsasoko. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Atahi: — Nawa zuruze kytsa Deus tyryktsa moziknahaze mozumu. Abaka kytsa Deus tyryktsa moziknaha. Iwatsahi ahamysapybyri tsimoewynahaktsa! Deus harere bo zuba hyỹ tahaktsa — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Kyze Sesus pihikzotsabyri sak taba Karireja inarokota eze niy. Ana buruk ziknaukuruze petoktsahatsa, ziktsikpaparakanahatsa bo nikozo. Peduru inarokota itsy tihi Ãdere iwahatsa tõhõryk pihik bo zioktsotsokoknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Sesus ispe niy: — Uta kapikta! Tapara tsitsikpaparakanahaze piknutsa ziknasizokonaha. Abaka, uta katuk, mekywatsatu tsimysitsumuẽhĩnaha. Kytsa bo Deus soho tsimytsasonaha. Ahaharere humo kytsa Deus harere bo hyỹ mykaranaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Iwaze atsoko tahatõhõryk zerekbaiknaha. Iapik niukurunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Sesus puẽtsik pãozo niyze mektsa bo tu nikozozo. Tsiaku Suão ahatsa tahazo Sebedeu tuk. Suão, Tsiaku tsy niy. Tsaraha ezektsa tu, tahatõhõryk pykyhytu zizozikiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Atsoko Sesus nisihuahua: — Uta kapikta — niy. Hyỹ niaha. Iwaze tahazo ty ka tsaraha eze, tatsumuẽhĩtsitsa baze zerekeknaha. Sesus tuk niukurunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Kyze Kaparanaũ eze, Sesus Deus wahoro bo nitsuk, Sudeutsa zinymyrykynahatsa wahoro bo nitsuk. Sabado, nawa zuruze Sudeutsa byrykywy Sesus siwahoro anaeze inakypyknahaze nisihyrinymyryky. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Kytsa ziwabykynahaze: — Atakta tsimysapyrẽta hawa mymyhyrinymyryky naha wasani mykara. Ta hi myhyrinymyrykytsa. Moises harere zinymyrykynahatsa batu sihyrinymyryziu — niaha. Sipybyrẽtsa paikpa iktsa nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Iwaze maku anaeze nitsuk. Ihyrikoso sapybara ibo pororo ziknakara. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Sesus bo iktsa niyze ipokso kakaik niy: — Amy skaraba mybo tsimyzumuku, Sesus Nasare ezekta. Mype nabo pãoty tsimy. Ikia mynyhy Deus zapehata tsimysapyrẽta. Ikia mopyk sa — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Sesus: — Aksobyitykta! Nabo pãotykta! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ihyrikoso sapybara humo maku hi nitydydykyk tu kakaik niy, niwakik. Batu ity nyzo. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kytsa sizubarẽtsa ibaze tutsa nipybybaiknaha. — O amy skaraba ihyrinymyrywy ezytyk ja Sesus hyrikoso sapybara pe: “Nabo pãotaha” myze, hyỹ sisopyk — niaha. Iwatsahi kytsa nipybybaiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Iwatahi sizubarẽtsa nanabyitaba Karireja eze Sesus niyhaty ziwabykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Iwaze Sesus wahoro eze ziponaha iwaze Tsiaku, Suão, ahatsa tuk Simaõ Ãdere siwahoro bo nipupunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simaõ wapyry ihumuẽzumu. — O Simaõ wapyry ihumuẽzumu — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Sesus iwanu sapy bo zumuze, itsyhyrype humo paik niy. Itsyhyrype humo tyzikto niyze nizororo. Iwaze ihumuẽzukbyitatsa tu nisidisahawyky. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kyze zunubazoze Sudeu byrywy nepyk iwaze Kaparanaũ ezektsa simyitsapyritsa Sesus bo nasioktyhyryknaha. Kytsa sipiakmyitsa hyrikosotsa simysapybaratsa humo sibo pororo ziknakaranahatsa. Asa kino Sesus bo nasioktyhyryknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kytsa ape baze sizubarẽtsa wahoro peze niriktotohokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Iwaze Sesus meky mekywatu simyitsapyritsa ty nisizororowyky. Sihyrikosotsa sapybaratsa hi nisiksiwyhik. Ispe: — Nabo pãotaha — myze iharere bo hyỹ sisopyk niaha. Hyrikoso sapybara Sesus humo sihyrinymyrẽtsa atahi Deus zipehata zinymyrykynaha iwatahi Sesus ispe niy: — Soso byitaha — niy. Iwatsahi batu harere. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kyze zokorobyitu Sesus inapopoze jerukbara bo niparak. Anaeze Deus bo nipamykysoko. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Iwaze Simaõ tuktsa ziberikinaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Zihobyknahaze ipe niaha: — Kytsa sizubarẽtsa paberikinaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Sesus ispe niy: — Ustsa hudikhudikwy boktsa kytsa! Sihudikhudikwy bytykareze tu. Anabo Deus wasania ty motsaso ana humo hi ikzumu — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Iwaze Karireja buruk niukurunaha. Sesus Sudeutsa wahoro bo nitsuk. Anaeze wasania ty nitsasoko. Sihyrikosotsa sapybaratsa nisiksiwyhik iwa zikzuruku. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Maku inakõrõrõbaikta humo asiba nibibibata zizororowy. Maku nakõrõrõbaikta Sesus bo izumu. Atahi Sesus okeryk taekaratsa humo puruk puruk niy. Sesus humo tispirikporẽta nikara iwatahi puruk puruk niy. Ipe niy: — Ikia tsipitsihikik zeka tsipikzororowy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","42","Iwaze Sesus ihumo tsimypokzitsiarẽta tatsyhyrype ty humo paik niy. Ipe: — Yhỹ ana hi mozihikik pazororowy. Aba pazororowy hỹ — niy. Atsoko iakõrõrõtsa nihokdanaha. Zizororowyhik. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Sesus zipehaka: — Sosobyity. Batu aty tohi bo ziktsaso. Aba ikia Deus wahoro bokta! Ziknapamykysokota bo tsikawatawykta. Niytahi amytudutsa ty ikia petoktsa ty Deus bo nyny tsimy. Iwa taparakta Moises tubabatu ziwatahaka papeu humo atsatu tsimy. Tsimyze kytsa sizubarẽtsa tsikzororo baba sihyrinymyrẽtsa. Ikia azororowy soho batu tyso — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nizororo tahi niparak. Iwata tu Sesus ipe: — Sosobyity — atahi Sesus soho ty nipamykysoko. Nanabyitaba kytsa sizubarẽtsa bo tazõrõrõwy soho nitsasoko. Iwatahi Sesus sihudikhudikwy bo batu zukzo. Jerukbara eze kytsa pokso nitare. Iwatsa tu kytsa sizubarẽtsa ibo niukurunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Kyze byi puẽtsik Sesus Kaparanaũ bo ziksizo. — O Sesus ziksizo — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Iwaze myzubaha ibo nikozorenaha. Wahoro inahareknaha batu iwewehe. Ape baze hokbowy baze, sizubarẽtsa niriktotohokonaha. Deus soho ty sibo nipamykysoko. ");
INSERT INTO rkbNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Iwaze ustsa kytsa izumukunaha. Sapetoktsa sapetoktsa ahatsa izumunaha. Ityryk niakbata hi ibo izebykyryknaha. Batu hawa tohi zikaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kytsa sizubarẽtsa izihyrizabaiknaha. Iwatsahi batu Sesus bo zuk niaha. Iwatsahi wahoro harapu nidokoknaha. Zipeksykiknaha. Zipeksykiknahaze ityryk niakbata hi iwanu bete inaripiknaha. Sesus bo imyitsapyrita inaripiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Iwaze Sesus iharereziuwytsa pe niy: — O kytsa, “Sesus myhumo tsimypokzitsiukrẽta” tsimaha. Iwatahi ikiahatsa humo kakurẽta — niy. Iwaze ityryk niakbata pe: — O katukytsa wata “Kamysapybyita” tsimykara. “Deus harere bo batu yhỹ mykara” tsimy. Iwahatu paokzohik. Asopyksapybyita tu tsimykara paokzohik — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Moises harere zinymyrykynahatsitsa, ibaze tu tsahi iharere humo tahakyrikinaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","— Amo skaraba nitsasoko. Atahi isopyksapybyita mykara Deus zuba: paokzohik mykara — mytsaty nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kytsa iwa mytsaty nikaranaha, Sesus tsihyrinymyrẽta iwaze ispe niy: ");
INSERT INTO rkbNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","— O hawa tuza kytsa “Iwahatu, paokzohik” my zeka tsihokdaharẽna. “Kyiktykta” my zeka, ana kino tsihokdaharẽna. ");
INSERT INTO rkbNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Iwatu utakta wyzik niwatihi my — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Ityryk niakbata pe tihi: O papeha. — Kyiktykta! Awanu ty pohyrykty! Tsiksikta! ");
INSERT INTO rkbNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Iwaze atsoko itarikto. Tawanu ty kokpuhyryk niy. Kytsa nikozokonahatsa nipybybaiknaha: — O Deus ahumo mykurẽtsa. Iwa batu ityny — asa zuba nipamykysonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Iwaze Sesus niparakzo Karireja buruk pihikzotsabyri sak bo zukzo niy. Kytsa sizubarẽtsa zikziberikinaha. Zihobyknaha siwatu ziknasihyrinymyryky. ");
INSERT INTO rkbNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Niukuruze Rewi bo iktsa niy. Rewi Arapeu tse. Atahi siokyrysaro bykyktsitsa sipehakatsa tsyhyryze nikara. Atakta siokyrysarobykwy sapy eze ziknadyhyky, Sesus ipe niy: — Panykta! Katuk! — niy. Yhỹ niy. Niytahi atsoko kyikyk Sesus tuk niukuru. Tanamy zerekbaik. ");
INSERT INTO rkbNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kyze Sesus Rewi wahoro eze tadisahaka. Kytsa siokyrysarobyktsitsa sipehakatsa tsyhyryze tahadisahakanaha. Sesus tuk zinymyrykynahatsa, kytsa simysapybyitsa iwa ahatsa tahadisahakanaha. Tumy zikukunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Pariseutsa asaktsa Moises harere humo sihyrinymyrẽtsa ana bo iktsa niahaze tahakyrikinaha. Siokyrysarobyktsitsa, kytsa simysapybyitsa tuk iwa tahadisahakanaha ana bo hi iktsa niahaze tahakyrikinaha. Sesus tuk zinymyrykynahatsa nisibetsakaknaha: — Amo skaraba mykara. Atakta siokyrysarobykyktsa tuk tadisahaka. Simysapybyitsa tuk tumy mozikuku — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Sesus siharere ziwabyze ispe niy: — Sakurẽtsaktsa batu myzororowytsa bo ba zikumunaha. Simyitsapyritsa zuba mozororowytsa bo pomonaha. Simysapybyitsa simyitsapyritsa watsa niy. Iwaze ikzumu, iwatahi simysapyrẽtsa bo batu zuk iky. Uta simysapybyitsa bo ikzumu — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Kyze estuba okoroze Suão Batista tuk zinymyrykynahatsa haukabyitsa ziknakaranaha. Pariseutsa atsabarẽtsa kino niwatihi haukabyitsa ziknakaranaha. Deus bo mopamykysokonaha. Iwatsahi kytsa Sesus bo zumukunaha. Ipe niaha: — Suão Batista zinymyrykynahatsitsa tuk haukabyitsa ziknakaranaha. Pariseutsa kino niwatihi haukabyitsa ziknakaranaha. Ikia tuk zinymyrykynahatsa batu. Asaktsa tahadisahakanaha. Amy humo sa tahadisahakanaha — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Sesus ispe niy: — Zinymyrykynahatsa katuk hauk tsimykaranaha. Maku tasukzaze tatukytsa tuk tamyikaha maha tumy mytakuku. Hamyikaha maha. ");
INSERT INTO rkbNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Isukzata moparakze asaktsa haukabyitsa mykaranaha. Iwaze utakta kazo bo myziksizoze zinymyrykynahatsa kino niwatihi haukabyitsa mykaranaha. Iwaze Deus bo mopamykysonaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Iwaze panu soho nitsasoko. Tahi: — Ba aty tohi panu ezytyk ty zizyzykyha isuk ibyky myzutsuku iwa myzeka isuk mysykbaik. Panu ibykta tu ezytyk humo mymyibaik — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","— Batu aty tohi duabohotsa tsik ezytyk ty ba siraratsa hwyk ibykta bo ba zisusu. Iwa myzeka duabohotsa tsik ezytyk mynapytoze ibykta tsasuk mytok. Mopokobaik. Duabohotsa tsik tsasuk ibykta bo susu tsimyzeka pimyibaik. Duabohotsa tsik ezytyk tsasuk ezytyk eze tu tsipisusu hỹ — Sesus niy. Iwa Sesus nitsasoko taharere panu ezytyk wata, duabohotsa tsik ezytyk waha nikara. ");
INSERT INTO rkbNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Kyze mybyrywy eze Sesus tuk zinymyrykynahatsa tuk waratok buruk niukurunaha. Niukurunahaze zinymyrykynahatsa tirikotsa nisibykyknaha sihipyrytsa ty tsikyk tsikyk iwaze taharapaspyk tu nisiborokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Iwaze Pariseutsa Sesus pe niaha: — Iktsa tykta! Ikia tuk zinymyrykynahatsa tarabaja mykaranaha. Amo skaraba nawa mykaranaha. Okoroze mybyrywy eze katsaktsa batu tarabaja mysopyk. Ana kino tubabatu Moises harere papeu humo mybyrywy soho humo nimyhyrinymyryky — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Kyze Sesus Pariseutsa pe niy: — Hawa taparakta Dawi niy batu sa ahahyrinymyry Papeu humo Dawi soho ziwataha. Taparakta Dawi itukytsa siaraparẽtsa tuze Deus wahoro bo nipupunahaze. (Taparakta Abiata inarokota Deus wahoro zubata taeze ziknapamykysokonahatsa tuk taparakta.) Dawi nitsukze atsikara ty ziknapamykysokonahatsa Deus bo ky zituha ziknapamykysokonahatsa Deus bo nyny niaha anatyhi wabehyryk niy. Zioko itukytsa niwatihi ziokoknaha. Moises harere tihi: “Ana humo ka atsikara kytsa ba zioknaha. Ziknapamykysokonahatsitsa zuba zikziokoknaha” niy. Iwahatu Dawi ziokok. Itukytsa kino ziokoknaha. Ana papeu humo batu ahahyrinymyry ja niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","28","Deus kytsa nisisukni. Batu mybyrywy humo nisisukni. Kytsa tahabyrykynaha ana humo hi tabyrywy nizukni. Utakta Deus zikpehata ahawata ikyzik. Anahumo hi uta kino mybyrykywy zihitsa ikyzik nawazuruze tabyryky eze zipehaka my hỹ — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Sesus itsyhyrype noikta zizozorowy. Kyze usta nawa zuruze tabyrykywyze Sesus Sudeutsa wahoro bozo niy. Anaeze estuba maku itsyhyrype noikta niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Pariseutsa Sesus bo nikozotoktokonaha. Sesus nizokparakanaha iwatsahi iktsaziu nikaranaha: — O mybyrykywyze ja hawa pizororowy — mytsaty nikaranaha. Sesus soho iharerewabymybarakanaha. Sesus Moises harere bo batu yhỹ nizihikiknaha iwatsahi pykyhytu ibo iktsaziu nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Sesus sisoho humo tsihyrinymyrẽta. Hawa abaktsa mytsaty nikaranaha ana humo kino zinymyryky. Iwaze itsyhyrype noikta pe — Kyiktykta! Pany! Mytazahara eze riktoty — niy. Yhỹ niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Iwaze Pariseutsa pe niy: — Hawa skaraba mybyrykywy eze ahasopyk. Mybyrykywy eze kytsa bo tsipisapybaka zeka iwaze Moises harere bo ka ja yhỹ tsimaha. Kytsa bo tsipimyiwy zeka ja wasani tsimaha. Kytsa bo tsimytsumuẽhĩ zeka ja wasani tsimaha. Maku tsipibeze zeka ja wasani tsimaha. Hawa sa mybyrywy eze ahasopyk — niy. Kytsa siharerebyitsa wa niunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Iwaze Sesus sihumo takyriki. Sioktsiokrẽtsa hi sihumo tisukatsihikrẽta. Itsyhyrype noikta humo batu simypokzitsiu ana humo takyriki. Iwaze itsyhyrype noikta pe: — Atsyhyrype ty kabo nynyty — niy. Maku tatsyhyrype ty nyny niy. Atsoko nizororohik. ");
INSERT INTO rkbNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Iwatsahi Pariseutsa tahakyrikinaha, niunaha. Erodes tuktsa izumubanaha. Niharapepehakanaha: — Hawa skaraba Sesus tabezehik — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Sesus tuk zinymyrykynahatsa tuk pihikzotsabyri Karireja inarokota zitsikzanaha. Kyze kytsa sizubarẽtsa Sesus bo niaha. Karireja ezektsa, Sudeja ezektsa. ");
INSERT INTO rkbNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Serusarẽhe ezektsa. Idumaja ezektsa, Sorodão buburu koiknyktsa, kytsa asahi Sidõ bytykareze tutsa, Tiro bytykareze tutsa iwa myzubaha ezektsa Sesus bo zumukunaha. Tapara hawa Sesus nikara botu ziwabykynaha. Iwatsahi ibo zumukunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Iwaze Sesus tuk zinymyrykynahatsa pe niy: — Kytsa pokso tsaraha bo tsatahaktsa! Iwa zeka mynamyhirizabanaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Tapara Sesus sizubarẽtsa nisizorohikwy iwatsahi simyiziubyitsa Sesus bo nikaranahatsa paikpa niharape petutukunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kytsa asahi hyrikosotsa sapybaratsa sibo ziknakaranaha tsa hi Sesus bo iktsa niahaze iokeryk tahaekaratsa humo puruk puruk niaha. Kazi nikaranaha: — Ikia hi Deus tse babata — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","— Soso byitaha! Ana tyhi batu aty tohi bo tsimytsasonaha — Sesus niy. Iwa nisibetsakik. ");
INSERT INTO rkbNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Kyze Sesus hara bo nidoze kytsa nisiwatawyky. Mysiwatawynahatsa ibo izumukunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","19","Tatuk zinymyrykynahatsa nisiwatawy. Ituk zinymyrykynahatsa. Simaõ pe: — Ikiakta Peduru — niy. Tsiaku Suão Sebedeu hyrytsa ahatsaktsa. Asaktsa nisitsatsikik — Bijo bipyri hyrytsa — maha. Iwaze Ãdere, Piripi, Baratoromeu, Mateus, Tome. Usta Tsiaku Arapeu tse, Tadeu, Simaõ tatyryktsa humo niwatsoroko. Iwaze Sudas usta Iskariotses inarokota atahi Sesus isukyrytsitsa bo zioktyhyrykta iwatsa Sesus nisiwatawy. Nisipeha: — Nohi bo tsimynakozorenahaktsa! Myzubaha bo Deus wasania ty tytsasonahaktsa! Tysizororowynaha! Hyrikosotsa sapybaratsa tysiksiwyhik! — niy. Hyỹ niaha. Sesus nipamykyso, iwa niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Iwaze Sesus wahoro bo zumuzo niy. Iwaze kytsa sizubarẽtsa ibo zumukunaha. Sipokso batu hauk, zinymyrykynahatsa niwatihi batu hauk. ");
INSERT INTO rkbNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Itukytsa isoho ziwabynahaze ibo zumunaha: — O ikia wahoro bo tsipaoktyhyryknaha — niaha. Atakta ityrykmyita wata mytsaty ahabyitsa nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Iwaze Sudeu sopykwy iwatahatsitsa ibo zumunaha. Serusarẽhe ezektsa nitururuknaha. Sizubarẽtsa Sesus ziharerewabykynaha. Asaktsa: — Beresebuhu Sesus tuk mynapykyryk. Iwatahi hyrikosotsa sapybaratsa humo mysipeha, Satanas humo nisiksiwyhik — mybarapetu nikaranaha. Satanas usta inarokota Beresebuhu atakta hyrikosotsa sapybaratsa pehakatsa. ");
INSERT INTO rkbNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Iwaze Sesus tabo nasipeha. Sudeu sopykwy iwatahatsitsa tabo nisihuahuaka. Isoho humo nisihyrinymyryky. — Hawa sa Satanas atatu taiksiwyhik — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","— Ityryktsa myharape ziubyinahaze mopyknaha. Kytsa metutu mymyinaha zeka iwaze mysibabaiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nawatihi estuba zubahatsa myharape ziubyinaha zeka asa zuba mokmyinaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Iwahatu Satanas tatuktsa tu myharape ziubyi zeka myokbabaik. Sisohometutu humo mopyk — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","— Batu aty tohi ipaikta wahoro bo ba ziktsuk iwaze ba inamy ziakse. Ba ziky. Tapara amata ipaikta piakwaraze, iwahoro bo mytsuk inamy piakse. ");
INSERT INTO rkbNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","29","Kaharere tsiwabytoktonaha. Kytsa simysapybyitsa nikaranaha Deus mysiokzohik. Siharere batu imysapy ana hi Deus piokzohik. Sisopyksapybyitsa mysiokzohik. Kytsa Deus hyrikoso soho pisapybyrikinahaze ana humo hi ba ziokzohik. Deus ana humo hi ba zikspiriktsokda. Ana isopyksapybyitsa ty tawahi kytsa tuk mynapykyryk — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iwa ispe niy. Nezeba kytsa ipe niaha: — Ihyrikoso sapybara ty ikia tuk mynapykyryk — niaha. Iwatahi ana humo kino nitsasoko. ");
INSERT INTO rkbNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Kyze Sesus je itukytsa ahatsa ibo zumu tsihikiknaha. Kytsa humo batu ibo zukzuk. Ape baze niriktotohokonaha. Iwatsahi zipehakanaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Kytsa sizubarẽtsa Sesus okeryk nidyhydyhykynaha. Ipe niaha: — Aje atukytsa ahatsa ape baze moriktotohokonaha. Atuk mopamykyso tsihikiknaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Sesus ispe niy: — Atatsa hi kaje. Asaktsa hi katukytsa — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Iwaze kytsa asaktsa harape baze nidyhydyhykynahatsa sibo iktsaziu niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ata hi: — Asaktsa Deus harere bo hyỹ mykaranaha hawa Deus mozihikik sisopyk asa hi katukytsa babatsa. Asiza hi kaje babaza katukytsa babatsa niwatihi — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Iwaze zinymyrykynahatsa ibo ziksizonahaze Sesus pihik sak eze nisihyrinymyrykyzo. Myzubaha pihikzotsabyri eze niriktotohokonaha. Iwatahi myzubaha pokso tsaraha bo takorohyk. Tsaraha sak bete nidyhyky. Kytsa pihik sak eze iharere ziwabykynaha ");
INSERT INTO rkbNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Nisihyrinymyryky. Waratok soho humo nitsasoko nawa humo nisiwatawyky. Hawa kytsa mekywatsa tu Deus harere bo maha, wastuhu iharere bo hyỹ maha, ustsa iharere bo batu yhỹ maha ana humo hi nisihyrinymyryky. ");
INSERT INTO rkbNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Ata hi: — Tsiwabytoktonahaktsa! Kyze maku waratok bo niy. Ata siriktsa nisiparikik. ");
INSERT INTO rkbNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nisiparikikze wastuhu riktsa ske sak bo inatsukunaha. Iwaze piyktsa nisihorozukbaiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Kyze ustsa riktsa nisiparikikze harahare buruk inatsukurunaha. Iwatsahi atsoko zipokonahaze wytyk tsikaeni zuba humo niakbabaiknaha, batu iytyk sapy. ");
INSERT INTO rkbNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Batu siharapyryky iwatsahi niakbabaiknaha. Nitsehebaiknaha. Haramwe humo niakbabaiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kyze ustsa riktsa nisiparikikze inikoso bo inatsukurunaha. Tahapykyknahaze nisiupyksiknaha. Inisahatsa humo, batu tahatypyk. Niakbabaiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ustsaktsa mahani. Ustsa riktsa nisiparikikze jytykziuha bo inatsukurunahaze sisapyrẽtsa. Tsiytyksapyrẽna bo natsukunaha. Niahatsahi taypykyknahaze tahasuknaha nipopokonaha. Wastuhu nisiubaranaha tirĩta riktsa. Ustsa nisiubaranaha sesẽta riktsa. Ustsa nisiubaranaha sẽ riktsa sizubarẽtsa hỹ — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Iwaha soho humo nisihyrinymyryky: — Kaharere tsiwabynaha zeka wabyziutahaktsa kytsa! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kyze kytsa sizubarẽtsa niparaknahaze zinymyrykynahatsa wastuhu wabynahatsa ahatsa ibo zumunaha ipe niaha: — Hawa ha ty aharere ty riktsa soho tsimymywatawy — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Sesus ispe niy: — Deus kaharere ty pahahyrinymyry tsihikik Deus tyryktsa soho pahawatawy tsihikik. Ustsa batu wabyziu. Ikiahatsa kahyrinymyrywy ezytyk bo yhỹ tsimaha iwatsahi Deus tyryktsa tsimoziknaha. Ustsa batu, iwatahi isoho humo nisihyrinymyryky. ");
INSERT INTO rkbNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Isoho humo piwabynahaze hawa ha ty piwatawy batu mytsaty hỹ. Isoho humo mytsatykynaha zeka sisopykysapybyitsa ty mykaranaha pimoewy tsihikiknaha. Sisopyksapybyi humo sisukatsihikrẽtsa tu zeka Deus mysiokzohik hỹ ana hi batu sihumo itsihik — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","— Kasoho humo ahahyrinymyry byizeka. Iwaze hawa usa soho humo sa mytsaty tsimykaranaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","— Kaharere pahawatawyky. Asaktsa kahyrinymyrywy ezytyk bo yhỹ maha zeka Deus tyryktsa moziknaha. Atakta nisiparikiktsa Deus harere mynatsasokonahaktsa watsa. Riktsa Deus harere hyrity watsa niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Wastuhu Deus harere ziwabynahatsa riktsa watsa ske sak bo inatsukurunaha. Deus wasania ty piwabynahaze Satanas sibo mozumuze, Deus harere piakse. Kytsa sispirikpobyitsa tu Satanas Deus harere ziakse piyktsa hyrity watsa iwaze wasani humo batu sispirikpo. ");
INSERT INTO rkbNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ustsa Deus harere piwabykynaha. Asaktsa riktsa watsa harahare buruk inatsukunaha wytyk tsikaeni zuba batu siharapyryky. Tapara wasaniha ziwabykynaha sakurẽtsa niyziknaha. Riktsa jakspe bete tu niapykyryknaha batu jytyksapy eze inatsukurunaha watsa. Asahi tsikaeni zuba pinymyrykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ziwabyziubyinahatsa tu Deus bo tsihokdaharẽna zeka Deus harere bo batu yhỹ my nikaranaha, iharere humo ispiriktsokdanaha. Ustsa kytsa Deus harere humo nisimyijakanaha Deus wasaniha zimoewynaha. Deus humo batu sispirikpo. ");
INSERT INTO rkbNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Ustsa Deus harere piwabykynaha. Asahi riktsa watsa inikoso bo inatsukurunaha iwatsahi niupyksikbaiknaha. Deus harere piwabynahaze tahanamy bo zuba mytsaty mytsaty nikaranaha. Tahanamy tsihikiknaha zuba. Sinamy inisahara watsa iwatsahi siriktsa batu taypykwatsa, wihara batu nijakuk Deus harere humo sakubyri zumunahaze ihumo batu sispirikpo. ");
INSERT INTO rkbNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ustsa Deus harere piwabykynaha hawaha mykaranaha riktsa watsa wytyk tisapyrẽna bo inatsukurunahatsa, ustsa kytsa Deus harere siwabynahatsa watsa piwabyziukunaha. Piwabykynaha iharere bo yhỹ mykaranaha ihumo sispirikporẽtsa moziknaha. Deus harere bo hyỹ nikaranaha. Iwatsahi wihara nijakuk naha wa. Wastuhu nisiubaranaha tirĩta riktsa. Ustsa nisiubaranaha sesẽtsa riktsa. Ustsa nisiubaranaha sẽ riktsa. Sizubarẽtsa hỹ — niy. Deus tuktsa niwatihi iharere bo hyỹ mykaranaha simysapyrẽtsa moziknaha wihara waha simysapyrẽtsa. Iwaze hawa kytsa Sesus hyrinymyrywy ezytyk hawa ja maha iwatahi nisihyrinymyryky. ");
INSERT INTO rkbNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Kyze Sesus tuktsa zinymyrykynahatsa bo nipamykysokozo. Rika soho nitsasoko. Ata hi: — Batu aty tohi pitsi rika ziknapok. Iwaze peryk pukezi zik niy. Batu aty tohi rika wanu pukezi zik niy. Pitsi rika jobaze zik my. Isapy eze tu my. Iwatsahi kytsa inapupunahaze amypubyri. ");
INSERT INTO rkbNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Aba hawa ha jokpitsĩha bykyze kino piwatawy. Aba amy humo batu myhyrinymyry bykyze kino tanymyryky. ");
INSERT INTO rkbNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kaharere tsiwaby tsihikiknaha zeka wabyziutaha! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","— O wabyziutahaktsa kytsa! Hawa ustsa kytsa ahasopyk ana kino Deus ahabo isopyk. Ikiahatsa ustsa kytsa mysisapywyky zeka Deus pahasapywyky. Ikiahatsa ustsa bo tsimysisapybyrikinaha zeka ahasopyk, iwaze Deus kino niwatihi ahabo atsatu isopyk Deus ahahumo iakyri mozik. ");
INSERT INTO rkbNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Atakta pinymyry tsihikik pihyrinymyrytohi. Atakta kaharere bo batu wabytokto tsikaeni zuba pinymyry myspiriktsokdaka, Deus mymyspiriktsokda. ");
INSERT INTO rkbNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Sesus nipamykysokozo: — Deus tyryktsa abazubatsa mozikze maku wata. Atakta tatsuhuk bo siriktsa nisiparikik. ");
INSERT INTO rkbNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Unata zurubakaze siriktsa mozipobanaha. Pibyituhukutu inapopoze siriktsa taypykbakanaha. Hawa siriktsa taypyknaha maku batu ihyrinymyry. ");
INSERT INTO rkbNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ta zuba taypyknaha siriktsa mozipokonaha. Tapara ipa mozipo, iwaze ikoka motaypyk iwaze riktsa ikoka eze mynahareknaha. Sizubarẽtsa niubaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Kyze moakuknahaze niunaha maku penari ty mysizyzyknaha, nikymynahaze atsoko mysizyzyk nahỹ — niy. Iwa Sesus siriktsa soho humo nisihyrinymyry. ");
INSERT INTO rkbNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Sesus nipamykysokozo. Deus tyryktsa abazubatsa humo nisihyrinymyryky: — Hawa kytsa Deus tyryktsa sa. Hawa Deus tyryktsa mypehakatsa zahawatawyky. ");
INSERT INTO rkbNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Rik tsibik taypykze watsa. Rik mostarada wata niy. Wytyk eze ziparikikze mostarada pyripykani riktsa. ");
INSERT INTO rkbNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Kyze rik taypykze hwi puẽtsikbyita mozik, tisarapazubarẽta mozik. Iwaze piyktsa ibete tahasukuknaha isarapatsa watu mykaranaha — niy. Iwa nipamykysoko Deus tyryktsa sizubarẽtsa mozik. Taparaka batu sizuba aibani abazubatsa moziknaha. Hawa mostarada niubara iwatsa Deus tyryktsa mysiubaraka. ");
INSERT INTO rkbNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Iwaze Sesus sisoho sizubarẽtsa kytsa bo nipamykysoko. Iwa nisihyrinymyryky. Sibo nipamykysoko, zinymyrykynahaze iwaze kytsa nisihyrinymyrytohi. Isoho humo zuba nisihyrinymyryky. ");
INSERT INTO rkbNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Bykyzehu atazubaze zinymyrykynahatsa tuk sisoho humo nisiwatawyziu ana hi nitsasoko. Iwa sisoho humo mytsatyziu nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kyze haramwe zunubakaze, Sesus zinymyrykynahatsa pe: — Koikny tynaporenahaktsa kytsa! — niy. Yhỹ niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ustsa nisiksiwyhiknahaze Sesus tsaraha eze nitareta, iwaze zinymyrykynahatsa zikorohyknaha. Nabo amykta taba zitsikzakanaha. Ustsa tsarahatsa kino niwatihi nikurunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Iwaze atsoko zopoktsa inabybyknaha. Pihik ihiridawy waha niukuru tsaraha pihik ty inaharekek, ana humo hi asiba nitaboknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Sesus kino tsapukteze nihoeke. Zurubaka iharek panu bete nihoeke iwatsahi tahapybyspyk tu zituzutuzukunaha. Zinymyrykynahatsa ity zipopohiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Kytsa: — O mypehakatsa batu iktsa ziky tsimymybabakanaha! — niaha. Kyikrikto niyze: — O zopoktsa aksobyitahaktsa! Niwazuba pihik pyktykta! — niy. Zopoktsa atsoko paỹ niaha. Pihik atsoko nitsikyrituhudibyri. ");
INSERT INTO rkbNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Sesus ispe niy: — Amy pokso ahapybyrẽtsa “Sesus batu imypokzitsiuk” tsimykaranaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Tahapybytuk tu nitsasokonaha: — Atakta Sesus aty skaraba! Zopoktsa, pihik, ihumo ziwabykynaha. Aty skaraba Sesus! — nikaranaha. Batu sihyrinymyry. Sesus Deus tse, ihumo sihyrinymyrybyitsa. ");
INSERT INTO rkbNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","2","Iwaze koiknyktsa taba bo Kerasa tyryktsa bo zukzuk niahaze. Sesus byuzo niyze, maku ibo izumu. Hyrikoso sapybara zikzibyituhukunaha tu ibo pororo ziknakaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Iwatahi siytyk baze nitareta. Atazuba zikzuruku. Mytyk ikny tahi ziknakara ana eze hi ziknapykyryk. Batu ipaiktaze kino zizukbatsi karikutsitsitsa humo kino ba ziknazukbatsikinaha ba itsipatsa ty pokzi zikaha ipyrytsa ty iwa ziknakaranaha kino batu karikutsitsitsa ziknasitsawakbakanaha ba aty tohi zipaik. ");
INSERT INTO rkbNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Karikutsitsitsa zipyrytsahãihiknahaze ziknasitsawakbaka sasabyitsaktsa batu sipaik ipaikwy tysukni ahabyitsa. ");
INSERT INTO rkbNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Okoroze unata niwatihi kadi ziknakara. Hara joboni eze siytyk eze kino niwatihi ziknakuru. Haraharetsa humo taharekywyikik. ");
INSERT INTO rkbNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","8","Iwaze ẽrykani Sesus bo nikozoze ibo zumu. Taekaratsa humo iokeryk puruk puruk niy. — O Sesus abazubata tsihyrinymyrẽta — nikara. (Sesus ihyrikoso sapybara ziny tahi zipeha: — O hyrikoso sapybara nabo pãoty! — niy.) Maku hyrikoso sapybara tukta opykani kakaik niy: — Amo Sesus Ikia hi Deus tse. Amo skaraba kabo tsikzumuku Deus zikwy humo awatu tykta! myhumo batu asopyksapyhukta — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Sesus: — Amo skaraba anaro — niy. — O kanaro myzubaha katsa myzubarẽtsa hỹ — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","— O hyrikoso sapybara sapy bo ka isty pehapehabyity — maku nikara. ");
INSERT INTO rkbNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","12","Pazaharezatsa sizubarẽtsa hara sukpe taba bo tahadisahakanaha. — Katsaktsa za pazaharezatsa tuk tsimypykyknaha — hyrikoso sapybara nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Sesus ispe niy: — Pazaharezatsa bo tahaktsa — niy. Iwaze pazaharezatsa bo zumukunaha, asa hi iharatsupetohowy bo nitururukiknaha. Pihik bo niharazukzukbaiknaha sizubarẽtsa dois miutsa niakbabaiknaha. De. ");
INSERT INTO rkbNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Iwaze pazaharezatsa perytsitsa nitururukiknaha, nanabyitaba myzubaha bo nipamykysokonaha. — Sesus hyrikoso sapybara nisiksiwyhik iwatsahi pazaharetsa niakbabaiknaha — nitsasokonaha. Iwatsahi kytsa Sesus bo inakozorenaha: — O hawa skaraba — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ibo izumunaha, maku bo nikozonaha. Astatu. Taparaka hyrikoso sapybara pokso, dyhyhabyita tu, inaukuru zuba. Abaka Sesus baze modyhyky nikara. Taparaka batu isuku. Abaka tasukuk. Wasani mytsaty mykara nizororo. ");
INSERT INTO rkbNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ibo nikozonahaze sipybyrẽtsa. Pazaharezatsa perytsitsa: — Iwaha nitsasokonaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Hyrikoso sapybara soho ty nipamykysobanahaze, kytsa: — O tsiksizokta, Sesus! Ikia pokso mypybyrẽtsa — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Iwaze Sesus tsaraha bo takoroze izororota: — O ikia hapik! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Sesus: — O batu. Awahoro bo tsiksikta! Atukytsa pe tsimy “O, Deus kahumo tsimypokzitsiukrẽta. Abaka ikzororo” tykta! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Hyỹ niy. Ziksizo. Itukytsa Sesus soho ty nipamykysoko. Nanabyitaba hudikhudikwy mytsyhyrytsawa bo Sesus soho ty nipamykysoko. — O abaka ikzororo. Sesus zikzororowy — nikara. Sizubarẽtsa paikpa iktsa nikaranaha. — Amo skaraba! — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Kyze Sesus zinymyrykynahatsa tuk amykta tabakta iziksizonaha. Iwaze nimyrazata eze kytsa sizubarẽtsa ibo izumukunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Iwaze Sairu Sudeu wahoro taparaktsa Sesus bo izumu. — Sesus abazubata — mytsaty nikara. Iwatahi taekaratsa humo puruk puruk nikara ");
INSERT INTO rkbNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Niytahi: — Pany Sesus! Tupakta kawahoro bo! Kaste pomozaka. Aidytykta! Ihumo paik tsimy zeka mozororo. Iwa zeka ba zikumuza — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yhỹ niy. Sairu hapik niparak. Siapik sizubarẽtsa niukurunaha zihyrizabaiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Wytyk tihi siapik niukuru. Ispubyri ahabyitatsa ispu ba ziknapyk. Mytsyhyrytsa wa ziytyk tseheze imyitsapyritatsa ziknapykyryk. ");
INSERT INTO rkbNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Atatsa myzororowytsa bo. Nanabyi zikzikuku zikino batu izororowyhuk iwatatsahi taokyrysaroko zepykba. Imyitsapyritatsa babatatsa. ");
INSERT INTO rkbNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Sesus soho kytsa nisizororowy ziwaby iwaze atatsa tasopyk: — O ikza isuk humo paik my zeka mozororo — mytsaty nikara. Iwaze isukpetaba zuk. Kytsa papatu isuk tsihara humo paik niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Atsoko ispu inapyk nizororo. — O ikzororobaba — mytsaty nikara. ");
INSERT INTO rkbNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Sesus zinymyry Deus zikwy zipo. Iwaze Sesus: — Aty sa kasuk humo paik niy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Zinymyrykynahatsa: — O ikiasta iwewehe baeze tsimypykyryknaha. Amo “Aty sa kasuk humo paik niy” tsiky — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Sesus paikpa iktsa nikara aty sa kasuk humo paik niy atahi ziperyky. ");
INSERT INTO rkbNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Iwaze atatsa izororotatsa ibo zumuzo. Tsipybyrẽtatsa nikara. Nitydydykyktatsa tu ibo zumu iokeryk taekaratsa humo puruk puruk niy. Ihumo tispirikporẽtatsa. Ibo ta humo ky nitsasoko. ");
INSERT INTO rkbNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Sesus ipe niy: — O katukywatatsa. “Sesus pikzororowy” tsiky. Ikia kazikwy humo aspirikpotatsawy azororowy. Akurẽtatsa tsiksi. Awahi tsikzororo baba — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Iwa nitsasokoze, kytsa sibo zumunaha. Kytsa Sairu wahoro ezektsa, sibo harape bo zumukunaha. Asahi: — Aste botu nihyrikosokda Sairu. Kyzekta! Iwa zeka Sesus mytakni! — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Sesus ziwaby tahi Sairu pe niy: — Apyby byihukta! Uta kabo zuba mytsaty tsimy zeka kahumo tsaspirikporẽta. Tupakta! — niy. Iske buruk hyry hyry hyryzo niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Iwaze Sesus tuk zinymyrykynahatsa harakykbyi zuba nisioktyhyryk Peduru, Tsiaku, itsy Suão, iwatsa zuba Sairu wahoro bo zumunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ata wahoro eze kytsa sizubarẽtsa Sairuste pokzi hawa tohi zikahabyispyk nipuziukunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Sesus nitsukze ispe niy: — Hawa hatsa sa tsimopuziukunaha Iste mahani isukmuza byitatsa tu purubakatu — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Iwaze ana hi ziwabynahatsa hazi nikaranaha. Sesus humo sihyrinymyrybyitsa iwatsahi tsaeni bete tu nikaranaha. Sesus ispe niy: — Ape bo tsiponahaktsa! — niy, ape bo kytsa zipoiknaha. Iwaze Sesus tatuktsa, Sairu, Sairu oke, iwa jypykyhyzytyktatsa bo izumunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Sesus jypykyhyzytyktatsa bo izumuze itsyhyrype humo paik niy. Ipe: — Tarita kumi — niy. Siharere piwatawy. — Jypykyhyzytyktatsa pe kyiktyktsa! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","43","Atsoko nahyrizikpo, natarikto, zitabaka iwaze nipybybaiknaha. Atatsa dose mytsyhyrytsa wa ziytyk tsehetatsa. Sesus kytsa pe: — Ahakso byitaha. Atatsa idisahawy ty ibo nynytaha! — niy. Idisahawy ty ibo nyny niaha. Iwa hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Kyze Sesus ziksizo. Nasare eze itaypykyk zinymyrykynahatsa tuk zumu. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nawa zuruze tabyrywy eze Sudeutsa wahoro bo zumubanaha. Anaeze kytsa nisihyrinymyrykyze sipybyrẽtsa nikaranaha. Ihyrinymyrywy ziwabynahaze nipybybaiknaha. Asa hi: — Atakta hawa sa zinymyryky. Hawa myhyrinymyrywy baba sa. Aty sa zispirikpoko. Amy ty kytsa batu zikaha ana ty hi mykara, aty sa zikwy ituk mynapykyryk. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Atahi ja hwitsabikitsa Maria tse. Tsiaku Sose Sudas Simaõ iwatsa moziky ipe sisopyk. Iwa itukytsa maha. Itukykyry mytuk tu niwatihi maha — nikaranaha. Iwaze iharere bo batu yhỹ nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Iwaze Sesus ispe niy: — Nanabyitaba Deus sohokotsa harere kytsa piwabytoktokonaha. Atahi tahudikhudikwy eze tu zeka iututsa pauktsitsa batu iharere ziwabynaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kytsa Sesus humo sispirikpoziubyitsa zikwy batu iwatawyhy. Atahi batu sizuba simyitsapyritsa nisizororowy tatsyhyrypetsa ty sibete tsika nikaraze nisizororowy. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ihumo sispirikpobyitsa tu ana humo hi paikpa mytsaty nikara. Iwaze ustsa myzubahatsa bo niukuru, anabo kytsa nisihyrinymyryky. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Kyze Sesus tuk zinymyrykynahatsa nisipehaka. Iwaze tazikwy ty sibo nyny niy. Iwatsahi kytsa asahi hyrikosotsa sapybaratsa sibo pororo ziknakaranaha nisiksiwyhiknaha. Sesus zikwy humo hi hyrikosotsa sapybaratsa ziknasiksiwyhiknaha. Nanabyitaba nisipehaka. Sipetok kohotsa ty zuba iwa nisipeha. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ispe niy: — Ahazozowy ty zuba wabehyryk taha. Ẽryka bo tsipomonahaze ahaborohobyitsa tutaha! Ahadisahawy byitsa tutaha! Okyrysaro ty kino pok pok byitaha! ");
INSERT INTO rkbNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ahapyrysuktsa ty zuba korobyktaha! Usa ahasuk tyka pok pok byitaha! Estuba zuba tsimaha. Batu petok suk pok pok byitaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","— Hudikhudikwy tsimyzumunaha. Wahoro bo tsimypupunaha zeka anaeze hi tsimypykyryknaha. Asta wahoro eze tu zuba tynapykyryknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Tsipomonahaze tsarytsitsa ahape pany pakuty ahabyi zeka. Asaktsa ahaharere ty waby ahabyizeka meky botu tsimaha. Tsimykurunahaze ahapyrysuktsa ty bokbokyk taha. Wytyk tazy ty mynatõ. Mynatõ zeka sihudikhudikwy ezektsa Deus harere bo batu yhỹ niaha iwatawy — niy. Iwa Deus mysisininiwyky anahi piwatawyky. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Iwatsahi zinymyrykynahatsa Deus wasaniha sizubarẽtsa bo motsasokonaha. Asaktsa: — Ahasopyksapybyitsa ty tsikykaranaha tsimoewynahaktsa kytsa — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Kytsa asahi hyrikosotsa sapybaratsa sibo pororo ziknakaranaha nisisiksiwykynaha. Simyitsapyritsa siharek bete ituta hyrity waha ty ziknasiharasusunahaze ziknasizororowykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kyze sihudikhudikwy pehakatsa myhyrizikwanitsa Erodes inarokota atahi Sesus soho ziwaby. Kytsa sizubarẽtsa Sesus soho ziwabykynaha. Asa zuba nipamykysokonaha: — O atakta Suão Batista inahyrizikpo iwatahi amy ty kytsa zikahabara ty ana ty hi mykara. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ustsa batu: — O atakta Erias taparakta mydiri — nikaranaha. — O batu, taparakta Deus sohotsa ziknakaranaha — ustsa wastuhutsa nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Erodes ana ziwabykyze: — O ata hi ja Suão Batista iky. Uta kino kytsa pe Suão Batista soik buruk hi bokokik iky. Atahi ja inahyrizikpo — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Tapara Erodes pehakata kytsa Suão bo nisipehahik. Asahi itsipa humo sakyriukrẽnikitsa hurukwy bo zioktyhyryknaha. Ana eze karikutsitsiwytsa ty zipawarakanaha. Iwa hỹ. Ana kino isopyk Erodias humo. Tatsa itsy Piripi oke iwatuze atatsa tuk ziakse niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Tapara Suão tihi: — Ikia Deus harere bo batu yhỹ tsimy. Deus harere tihi “Atsy oke ba ziakse.” Ikia atsy oke tsiakse iwatahi Deus harere bo yhỹ ahabyitahi tsiky — ziknakara. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ana humo hi Erodias tsiakyriukarẽtatsa, iwatatsahi Suão zibezekyzyky Erodes ipokso hi batu zik, atahi ihumo tsipybyrẽta. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Erodes Suão soho humo tsihyrinymyrẽta. Atahi tsimysapyrẽta ana humo hi tsihyrinymyrẽta. Iwatahi ihumo tsimyharerewabyrẽta. Iharere humo ziwabyze paikpa mytsaty nikara. Iharere ziwaby tsihikik ziknakara: — Atakta sakyriukrẽnikitsa hurukwy eze ka kytsa ba zibezenaha, iwahi piperyky — mytsaty nikara. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Kyze Erodes myikaha zumuze. Tumy tsihohokrẽna inakymyze iwa Erodes purukwy zumuze imyikaha bo mytsaty nikaranaha. Sizubarẽtsa sakzohotsa bo huahua niy. — Kamyikaha bo tyzumunaha — nikaranaha. Kytsa myhyrizikwanitsitsa sodadutsa pehakatsa, Karireja hudikhudikwy ezektsa asaktsa simyhyrizikwanikitsa iwatsa kytsa sizubarẽtsa imyikaha bo izumunaha. Iwaze Erodes oke Erodias inarokotatsa ana hi ziperyky iwaze hi Suão zibeze tsihikik. Naha atatsa tape aba ikza Suão pibezewyky. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Kyze Erodias ste jypykyhyzytyktatsa tsarawybara bo tu netsuk. Atatsa hi Erodes ykzohotsa okze nikariki. Tisapyrẽna ty nikariki iwatatsa hi kytsa sakurẽtsa nikaranaha. Iwaze Erodes ipe niy: — Amy sa tsimyzihikik. Amy ty kabo tsimyzapyky zeka anatyhi abo nyny my. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Deus kaharere piwaby iwatahi atsatu mykara. Amy kabo tsimyzapyky zeka ana ty hi abo nyny my. Kahudikhudikwy bo tsimyzapyky zeka tsapukte buruk abo nyny my — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Iwaze atatsa zoihik. Taje pe niy: — O kaje amy sa ibo myzapyky — niy. — Suão Batista harek tsimyzapyky hỹ — ije niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Iwaze aidy atatsa ziksizo. Erodes pe niy: — Suão Batista harek ty kabo nyny tsimy hỹ. Aidy iharek ty mypewy eze korok tsimy iwaze kabo tyny — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Sipehakatsa Erodes zisukatsihikbaik. Suão Batista soho ziwabyze tisukatsihikarẽta nikara. Taharere ty ka sakzohotsa bo batu yhỹ niy, ana humo hi batu tyso. Tisikpybyrẽta. Iwaze sodadu pe niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","— Suão Batista harek ty bokokiktykta. Isoik buruk bokokyk ty — niy. Sodadu niparak. Sakyriukrẽnikitsa hurukwy bo netsuk. Anaeze Suão soik ty bokokik niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Iwaze iharek ty mypewy eze niy. Erodias ste bo zibykyryk. Atatsa taje bo iharek ty nyny niy. Iwa Erodes Suão Batista zibeze. Erodias iharek bo iktsa niyze Suão zibeze tsihyrinymyrẽtatsa. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Suão Batista tuk zinymyrykynahatsa ana soho ziwabynahaze izumukunaha. Inury ty zizozikarenaha. Harahare yktaba nitsahoroknaha de. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Kyze siakzohotsa Sesus bo ziksizonaha. Amy ty nisihyrinymyrykynaha ibo nipamykysobaiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kytsa sizubarẽtsa paikpa myzukurunaha zinymyrykynahatsa Sesus ahatsa bo zumukunaha. Iwatsahi sibyrybyitsa tu nikaranaha sidisahabyitsa tu. Iwaze Sesus zinymyrykynahatsa pe niy: — Nabokta jerukbara bo tsimymybyrynaha! — niy. Yhỹ niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Iwaze zinymyrykynahatsa ituk jerukbara bo tsaraha eze kokokorohyk niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ustsa kytsa zuba nisinynaha. Asaktsa: — O Sesus tuk zinymyrykynahatsa nabo mokurunaha. Tsimytururuknahaktsa! Hara taba siharaze nabo tsipomonahaktsa! — niaha. Kytsa sizubarẽtsa niukurunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Iwaze Sesus anabo byuzo niyze kytsa sizubarẽtsa bo iktsa niy. Sihumo tsimypokzitsiarẽta, sispirikpobyitsa tu sihumo tsimypokzitsiukrẽta: — O Deus soho piwaby tsihikiknaha iwatsahi kaharaze nitururuknaha — niy. Iwaze Sesus nisihyrinymyryky iwaze kytsa ziwabytoktonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Zunubakaze zinymyrykynahatsa ibo zumunaha: — O Sesus tykara eze ka batu mydisahawyky. Abaka punubaka hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Kytsa hudikhudikwytsa bo tysipehakta! “Ahadisahawy tyzeskyknahaktsa” tsimy — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Sesus: — O ikiahatsa sidisahawy ty sibo nynytahaktsa! tsimaha — niy. — Hawa skaraba atsikara ty huak tsimaha batu okyrysarotsa dusẽtos namy parata hi batu ziakse. Batu amy tohi ty zikaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Sesus: — Hana wa skaraba mydisahawy iktsatahaktsa! — niy. Kytsa iktsa niahaze: — O atsikara mytsyhyry wa zuba. Piknutsa petok zuba — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Iwaze kytsa sizubarẽtsa pe tsimaha: — Tyk humo dyhy dyhytaha! Parakbaha dyhy dyhytaha! — Sesus niy. Sĩkuẽtatsa, sẽtsa iwa nidyhydyhykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Towahaditsa sikakairẽtsa bete itahadyhydyhynaha. Parakbaha sẽ, sĩkuẽta iwatsa sibete nidyhydyhykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Iwaze Sesus atsikara ty okok niyze, piknutsa ty iwa nasekykzoze bijo bo iktsa niy. Deus pe nikara: — Ikiakta tsamysapyrẽta ikia humo ka mykurẽtsa — niy. Atsikara zitsakze zinymyrykynahatsa bo nyny niy: — O sibo tsipibiaknaha piknutsa petok tsibik zuba tsatu niwatihi sibo nynytahaktsa! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Sibo nyny nyny nynyzo niy. Sesus ziubarawy iwatsahi kytsa sizubarẽtsa tahadisahakanaha. Sibo zibiakakzoze iwaze nitare tu. Bykyze: — O mysorokrẽtsa — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","44","Tahadisahabanahaze atsikara piknutsa ahatsa nitare nahatsa peryktsa bo zipupukunaha. Mytsyhyrytsa ty pỹ ahatsawa nasiharekbanaha. Kytsa sizubarẽtsa sĩko miutsa tahadisahakanaha. Siokeza, tahahyrytsa tuk niwatihi tahadisahakanaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Atsoko Sesus tuk zinymyrykynahatsa Betesaida bo nisipeha. Ispe niy: — Tsaraha eze kokokorohyktaha! Kaharaze pihikzotsabyri koikny tsitsikzanahaktsa! kytsa! — niy. Iwaze Sesus myzubaha siwahoro bo nisipehaka. Nisipehakaze zinymyrykynahatsa koikny ziturikinaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Myzubaha ziksibanahaze, Sesus hara bo nido. Anaeze Deus bo nipamykysoko. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Zunubaze Sesus atazuba hara bo nido. Zinymyrykynahatsa pihik tsikpukteze buruk ziturikinaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Sesus sibo nikozo. Opykani ziturikinaha. Zopoktsa pokso opykani ziturikinaha, iwatsahi ispara izumu. Zokorobyitu sibo niy. Miwa botu kytsa bo pihik tsiksukpe buruk inaukuru harazuk ahabyita pitabaka. Asiba nisiharamu. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Sesus bo nikozonahaze pihik tsiksukpe buruk niukuru sipybyrẽtsa nikaranaha. Tahapybyspyk tu kakaik niaha. Ihyrikoso zuba mytsaty ahabyitsa. Ipokso sipybyrẽtsa. Iwaze atahi: — O ahapunihikuktsa kytsa! Ahapyby byihu ja! Uta hi mykara — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Iwaze Sesus tsaraha bo natakoro. Atsoko zopoktsa inapyknaha niukurunaha. Iwatsahi paikpa mytsaty nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Sesus Deus tse babata humo batu sihyrinymyry. Amy humo kytsa sizubarẽtsa disahawyky ty ziubarawy ana humo hi nisiwatawy zinymyrykynahatsa ihumo batu sispirikpo. Sioktsiokrẽtsa iwatsahi batu siaku. Bykyze zuba Sesus humo sispirikporẽtsa moziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Pihikzotsabyri zitsikzanahaze Kenasere bo zumunaha. Ipupuwy bo nimyra byu niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Tsaraha ikny nizoknahaze kytsa Sesus zinynaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Iwatsahi siwahoro taba paikpa zikzumukunaha. Simyitsapyritsa Sesus bo nisioktyhyryknaha. Asaktsa tahawanu eze tu ibo nisioktyhyknaha. Nanabyitaba niukuruze. ");
INSERT INTO rkbNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kytsa hi: — O Sesus mybo mozumuku — niaha. Ana zikziwabykynahaze simyitsapyritsa Sesus bo ziknasioktykyryknaha. Tsarawybara eze simyitsapyritsa iokeryk ziknasihoekeknaha. Situkytsa Sesus pe niaha: — O asuk tsihara humo paik tsimaha zeka mykurẽtsa — nikaranaha. Yhỹ niy. Iwaze asaktsa Sesus suk tsihara humo paik maha zeka mozororobaiknaha. Nanabyi Sesus zikwy humo simyitsapyritsa sizubarẽtsa nizororobaiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Kyze Pariseutsa iwatahatsitsa kino niwatihi asaktsa Serusarẽhe ezektsa inakypyknaha. Sesus bo izumubanaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Taparaktsa sopykwy ty nisihyrinymyrykynaha. Tapara tahatsyhyrype pikiknaha iwaze tahadisahakanaha. Taha ty tsyhyrype pik byizeka ba ziktahadisahanaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Pariseutsa Sudeutsa ahatsa tahatytsyhyrype pik byizeka ba ziktahadisahanaha, sizotsa iwa nisihyrinymyrykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Hawa ha ty sidisahawy zozokorowy ikny zibykyknahaze nitsapikiknaha tsizubarẽna iwaze zuba tahadisahakanaha. Iwa taparaktsa sopykwy humo nikaranaha. Deus okze ka mysapyrẽtsa mytsaty ahabyitsa nikaranaha. Taparaktsa sopykwy humo yhỹ byizeka Deus ispe: — Ikiahatsa batu ahamysapy — mytsaty ahabyitsa ziknakaranaha. Sipowysuktsa ty morosuk ty karikuktsa ty iwahatsa ty mysiokepiknaha taparaktsa sidiritsa sopykwy humo. ");
INSERT INTO rkbNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Sesus tuk zinymyrykynahatsa tahadisahanahaze ba ziktahatsyhyrype piknaha. Taha ty tsyhyrype pikbyritsa tu tahadisahakanaha. Taparaktsa sopykwy humo yhỹhabyitsa nikaranaha. Iwaze Pariseutsa Moises harere watahatsitsa niwatihi ana bo kino iktsa nikaranahaze ipe niaha: — Amy humo zinymyrykynahatsa taparaktsa mydiritsa sopykwy yhỹhabyitsa nikaranaha. Amy skaraba sitsyhyrytsape pikihikbyitsa tu tahadisahakanaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Iwaze Sesus ispe niy: — Tubabatu Deus ahasoho ziwatahaka. Ikiahatsa zihawatahakanahatsa watsa kytsa bo tysimyiwykynaha. Isaijas Deus sohokotsa tihi: “Asaktsa katsa Deus humo mymypokzitsirẽtsa mybarapetu mykaranaha. Ihumo batu simypokzitsi, iwatsahi nisispihikbatakanahatsa.” ");
INSERT INTO rkbNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","“O Deus ikia zuba wasani tsimykara” nikaranaha kaharere bo batu ma nikaranaha. Sispihikbatakatsa tu “O katsa Deus harere ahabo tsimytsasokonaha” mybarapetu nikaranaha. Tahaharere ty zuba motsasokonaha. Tubabatu Isaijas Deus sohokotsa iwa sisoho ziwatahaka — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Deus harere bo batu ma zikaha. Iharere batu ahawabyhy. Ahazotsa sopykwy ty zuba tsimykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Deus harere bo batu yhỹ. Katsa mysapyrẽtsa mytsaty ahabyitsa tsimykaranaha, ahasopyk zuba tsimyzihikiknaha. Batu ahape tu tsipimyikiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Tubabatu Moises ziknakara: — Ahazotsa tysipokzitsinahaktsa! Ahazotsa, ahajeza kino niwatihi wasani ahasopyk. Aty tazo pisapybyriki zeka tsibezehik. Aty taje pisapybyriki zeka tsibezekta — niy. Iwa tubabatu Moises ziwataha ahazotsa soho. Ikiahatsa hi iharere bo batu yhỹ zikaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ikiahatsa hi: — O kazo kaokyrysaro ty abo nyny mykara eze tu batu zik. Anaokyrysaro ty Deus bo nyny my iwaze ba zatsumuẽhĩ — tsimaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Anahi kytsa bo tsimytsasonaha zeka tsimyikiknaha. Kytsa tahanamy ty tahazotsa bo nyny maha wasani maha. Aha humo batu nyny maha. Iwaze ikiahatsa kytsa tysimyiwykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ikiahatsa Deus harere bo batu ahamyzihik. Ahaharere ty zuba tsimykaranaha. Iwaze Deus harere humo batu ahakparawy. Iharere humo tsipimyikiknaha. Sesus Pariseutsa pe niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Kyze Sesus kytsa sizubarẽtsa pe niyzo: — Kabo tyzumunahaktsa kytsa. Kaharere bo wabytaha! Tsiwabytoktonahaktsa! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","— Amy ty maku hauk my zeka ba ana humo hi isopyksapybyita nikara. Hawa kytsa mytsaty mykara ana humo hi batu imysapy mozik. Hawa motsasoko ana humo hi batu imysapy mozik hawa mynakara ana kino batu imysapybara mozik. ");
INSERT INTO rkbNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Kaharere tsipiwaby tsihikiknaha zeka wabytoktotahaktsa! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Iwaze Sesus myzubaha ikny niparak. Zinymyrykynahatsa tuk iwahoro bo zumunaha. Inapupunahaze ipe niaha: — Amy ty asoho ty tsimymywatawyky, amy ty tsimymyhyrinymyryky — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Sesus: — Ikiahatsa ja niwatihi ikiahatsa sizubarẽtsa watsa, batu wabyziuha tsimaha. Kytsa tahadisahakanahaze wasani mykaranaha. Ana humo hi sakurẽtsa moziknaha. Sidisahawy siwazik eze zuba. Iwaze pikaranahaze hana bo ja — niy. Iwa Sesus nisihyrinymyryky nanabyi mydisahawy wasani my, kytsa bo mektsatu disahawy watsa ty wasani my. ");
INSERT INTO rkbNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Sesus nitsasokozo: — Mydisahawy tisapyrẽna my. Hawa ty kytsa mytsaty mykaranaha ana humo hi batu imysapy my. ");
INSERT INTO rkbNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kytsa wytykyryk ahaza niwatihi hawa sa batu simysapy mytsaty mykaranaha zeka sisopyksapybyitsa tu mykaranaha anahi batu imysapy. Iwaze kytsa ustsaktsa pimyiwy tsihikiknaha. Mekta oke tu piakse tsihikiknaha. Mektatsa barikta tu mozihikiknaha zeka. Kytsa mysiba tsihikiknaha. Kytsa namy piakse tsihikiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Mekta oke bo ihizikikwy. Siharerewabymybarẽtsa. Simyspihikbatanikitsa. Sisopyksapybyitsa tu mykaranaha anahi zimyiwynaha. Sizokdirẽtsa. Ustsa mysimyiwykynaha. Sisakimyijarẽtsa tu, “O katsa zuba mysapyrẽtsa” mybarapetu mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Iwa kytsa mytsaty mykaranaha zeka iwaze batu imysapy moziknaha. Ana kino batu imysapy my. Mydisahawy zuba tisapyrẽna my — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Kyze Sesus niparak. Tiro bo bytykareze tu anabo niukuru. Anaeze wahoro bo nitsuk. Nitare tykareze. Kytsa batu ityny anaezehe nitarespyk. Batu kytsa ityny. ");
INSERT INTO rkbNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Iwaze wytyk Sesus wahoro eze ziwaby. Ana ziwabyze atsoko wahoro bo niparak. Atatsa ste bo hyrikoso sapybara ibo pororo ziknakara. Iwatatsahi aste tsyhyryze Sesus bo niy. Zumuze iokeryk taekaratsa humo puruk puruk niy, ihumo tispirikporẽtatsa nikara iwaze iokeryk taekaratsa humo puruk puruk niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Atatsa Sudeubyitatsa tu Kereko harere nitsasoko. Siropenisia ezektatsa niy. Iwaze atatsa hi Sesus pe niy: — O hyrikoso sapybara ty kaste bo pororo mynakara tsiksiwyhik ky! Nabo pãoty tsimy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Sesus ipe niy: — Batu. Ikia Sudeubyitatsa tapara kahyrytsa Sudeutsa mysitsumuẽhĩ. Bykyze zuba Sudeutsabyitsa mysitsumuẽhĩ. Tapara ahahyrytsa zitadisahanaha bykyze zuba kytsa sidisahawy tsihirik ty tsikuparinitsa bo nyny mynakaranaha. Tapara tsikuparinitsa bo ahadisahawy ty nyny tsimaha zeka batu isapy tsimaha. Isopyksapybyitsa. Ihyrytsa tapara tadisahanaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Atatsa ipe niy: — O myhyrinymyrykytsa wasape tsiky. Tsikuparinitsa zipyryktsa hwi upukezi tu asaktsa itsatsakyhy arehe ty tahadisahakanaha. Itsatsakyha ty tsikuparinitsa tahadisahakanaha. Ikza kino niwatihi piperyky tsipiktsumuẽhĩ tsikuparinitsa zipyryktsa hwi upukezi watsa — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","— O aharere wasani my niy. Ana harere humo kino awahoro boktsa! Hyrikoso sapybara ty aste ekze botu iksiksiwy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Iwaze atatsa tawahoro bo ziksi. Nitsukze iste wanu eze nihoeke. Hyrikoso sapybara botu nisiksiwy tsakurẽtatsa niyzik. ");
INSERT INTO rkbNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Kyze Sesus Tiro ikny niparakze. Sidõ bo nio kyze Dekaporis ziharamu Karireja pihikzotsabyri bo niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Iwaze kytsa iharawita Sesus bo zioktyhyryknaha. Ana humo kino iharerebyita. Kytsa Sesus bo zioktyhyryknaha ipe niaha: — O atsyhyrype ty iharawita harek bete tsikatykta! Iwaze tsipizororowyky — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Iwaze Sesus iharawita zioktyhyryk. Sizubarẽtsa ikny ituk zuba niy. Iwaze Sesus maku ispiuke bo tatsyhyry ty korok niy. Hezok niy. Tasaytsik ty iharawita stiãrik bete tsika niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Iwaze bijoik pe bo iktsa niyze sysy nikara. Ipe niy: — Epapata — iharere nitsasoko. Ana harere ziwatawy — Aspiukitsa saparetaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Iwaze ispiukitsa sapare niaha. Ziwabyky istiãrik zizororobaba tsihareresapyrẽta niyzik. ");
INSERT INTO rkbNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Asaktsa ibo iktsa niahaze ispe niy: — Ana kino kytsa sizubarẽtsa bo batu tyso — niy. Iharere bo batu ma zikaha. Ziknapamykysokonaha hawa iharawita zizororowy naha nanabyitaba ana soho ziknatsasokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Paikpa iktsa nikaranaha. Asa hi: — Amy skaraba nikara tisapyrẽna my — nikaranaha. — Atakta iharawita tu abaka piwabyky. Ata iharerebyita tu abaka taharere piziuku. Hawa skaraba my — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Kyze myzubaha Sesus tuk inakypykzonaha. Batu sidisahawyky iwatsahi siarapa izumu. ");
INSERT INTO rkbNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Iwaze Sesus zinymyrykynahatsa pe niy: — Pany pãotynaha! Uta kytsa abazubatsa humo kamypokzitsiarẽta. Harakykbyihi katuk zurunaha aba sidisahawy nepykba. ");
INSERT INTO rkbNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ispe: “Awahoro bo tsiksinahaktsa!” my zeka ske buruk taharapatsapyrispyk pumuzanaha, mektsaktsa ẽryktsa tu izumukunaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Zinymyrykynahatsa: — Hawa skaraba tsimaha. Batu aty tohi mydisahawy ty kytsa bo nyny zeky. Jerukbara bo batu mydisahawyky. Katsaktsa ba ziksitsumuẽhĩnaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Sesus: — Atsikara ja hana wa skaraba atsikara — niy. — Yhỹ. Nawa usta tsyhyrype wa humo petok ziakyri sete atsikara tsimaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Iwaze Sesus kytsa sizubarẽtsa pe niy: — Wytyk humo dyhy dyhy taha! — niy. Iwaze Sesus atsikara ty okok niyze Deus pe niy: — Ikia tsamysapyrẽta ahumo ka mykurẽtsa — niy. Atsikara zitsaktsakze tatuktsa bo nyny niy: — O sibo nynytaha! — niy. Iwaze zinymyrykynahatsa sizubarẽtsa bo atsikara kytsa bo zibiakaknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Piknutsa batu sizuba niwatihi niaha. Sesus Deus pe niyzo: — O kazo ikia zuba tsamysapyrẽta. Piknutsa zipyryktsa ty mybo nynytykta — niy. Iwaze zinymyrykynahatsa pe niy: — O sizubarẽtsa bo piknutsa zipyryktsa ty nynytaha — niy. Yhỹ niaha. Iwa kytsa sizubarẽtsa bo piknupyryktsa nisibiakaknaha. Kytsa sizubarẽtsa bo nyny nyny nyny nikaranaha. Nisiubarawy. ");
INSERT INTO rkbNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Kyze kytsa sizubarẽtsa: — O mysorokrẽtsa — nikaranaha. Tahadisahabanahaze zinymyrykynahatsa atsikara piknutsa ty itsatsakyhy arehe ty peryktsa bo zipupukurunaha. Pok pok pok nikaranaha. Iwa sete peryktsa inasiharekbanaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Kytsa sizubarẽtsa tahadisahakanaha. Kwatero miutsa ahatsa. Iwaze Sesus nisipeha: — Ahawahoro bo tsiksinahaktsa! — niy. Yhỹ niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Iwaze Sesus tsaraha bo itakorohyk. Zinymyrykynahatsa tuk kokokorohyk. Daramanuta bo niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Iwaze Pariseutsa Sesus bo izumunahaze niharapebetsakaknaha iwaze ipe niaha: — Deus zikwy mybo tsiwatawykta. Atakta bijoikpe iknykta zikwy iwatawy humo tsiny tsihikiknaha iwatsahi Deus zapeha tsinymyrykynaha — niaha. Iwa ziakzobyrikinaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Sesus sihumo tisukatsihikrẽta. Ihumo batu sispirikpo ana humo hi tisukatsihikrẽta. Ispe niy: — Amy humo abaktsa kytsa iwatawywy myziberikinaha. Amy humo utakta Deus zikwy mysiwatawy mozihikiknaha. Kaharere wasape batu amy tohi abaktsa kytsa bo mysiwatawy — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Iwaze Sesus niparak. Tsaraha bo takorozo. Zinymyrykynahatsa tuk pihikzotsabyri koikny nipo. Pariseutsa asa zuba pihikzotsabyri sak niriktotohokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Zinymyrykynahatsa atsikara humo nispiriktsokdanaha. Estuba zuba tatuk zibykyknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Iwaze Sesus ispe niy: — O kytsa pykyhytutaha. Pariseutsa harere humo pykyhytutaha. Erodes harere humo niwatihi pykyhytutaha! Sihyrinymyrywy napyto naha waha anaty hi jokpitsĩhik abahi atsikara tsakyky napyto naha humo nawerekbaik. Iwaze sispirikpobyitsa siharere bo yhỹ mykaranaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Iwaze zinymyrykynahatsa asa zuba nipamykysokonaha: — Anatyhi nitsaso atsikara humo tsikspiriktsokdanaha ja — nikaranaha. Iharere batu sinymyry. ");
INSERT INTO rkbNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Sesus siharere humo tsihyrinymyrẽta. Iwaze atahi: — Amy humo tsimaha ikiahatsa “Katsaktsa atsikara byitsahi iwatahi anapytowy soho mybo nitsaso tsimaha”. Kahumo batu ahaspirikpo. Batu kabo mytsaty tsimaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ikiahatsa ahahyriziktsa katsa tuba, iwatsa tu batu iktsa zikaha. Ikiahatsa ahaspiukikitsa tuba iwatsa tu batu waby zikaha. Hawa ha ty botu ikykara tsikspiriktsokdanaha ja. ");
INSERT INTO rkbNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Atsikara mytsyhyry tsawata zitsaktsakze kytsa sizubarẽtsa sĩko miutsa bo nyny iky, hana wa ja peryktsa bo tsipupukunaha sa atsikara ty jerehe haty tsikaha — niy. — Dose peryktsa tsiknasihareknaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","— Atsikara usta tsyhyry humo petok ziakyri sete zitsaktsakze, kytsa sizubarẽtsa kwatero miutsa bo nyny iky, hana wa ja peryktsa bo tsipupukunaha sa itsatsakyhy jerehe haty tsikaha — niy. — Sete peryktsa tsiknasihareknaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","— Yhỹ iwa atsikara tsizubarẽna niyzik. Ikiahatsa ahamytsatyhybyritsa tu — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Kyze Sesus Betesda ezektsa bo niukuru, zinymyrykynahatsa tuk zumunaha. Kytsa ihyrizikbyrita ibo izioktyhyryknaha. — O Sesus ikia ihyrizikubyita ty tsika tsimy zeka mozororo — niaha. Iwa nizapykykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Iwaze Sesus ihyrizikubyita tsyhyry humo paik niy. Ape baze myzubaha pauk bo zioktyhyryk. Iwaze hezok niy. Tasaytsik ty ihyriziktsa bo tsyktsyk niy. Tatsyhyry ty ihyriziktsa bete tsika niyze: — Hawa sa iktsa tsimykara — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","— Abaka tsikaeni zuba iktsa mykara. Kytsa hwitsa watsa kaokeryk monaukurunahatsa watsa — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Iwaze Sesus tatsyhyry ty ihyriziktsa bete tsikazo niy. Nizororo. Amypubyri niyzik iktsaziu nikara. Nizororobaba hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Sesus ipe: — Awahoro bo tsiksikta! Betesda bo ka erete eretebyijaty — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Kyze Sesus tuk zinymyrykynahatsa tuk nitururuknaha. Sisarija Piripi bo niukurunaha. Piripi sihudikhudikwytsa ezektsa nisipehaka. Niukurunahaze asa zuba ske buruk inapamykysokonaha. Sesus ispe niy: — Aty skaraba uta kahumo kytsa mytsaty mykaranaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Zinymyrykynahatsa ipe niaha: — Wastuhutsa ikia pe Suão Batista nihyrikosokdata ja mykaranaha. Mektsaktsa batu niaha. Ata hi nihyrikosokdata Erias ja — mykaranaha. Ustsaktsa batu. — Ikia taparakta Deus sohokotsa nahyrizikpota ja mykaranaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Sesus ispe niy: — Ikiahatsa ja. Ahaokze ka aty skaraba uta ahahyrizikze ka tsimykaranaha — niy. Peduru tihi: — Ikiakta Kiristu. Ikiakta Deus pehahababata — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","— Ana tyka kytsa bo soso byitaha! — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Iwaze Sesus hawa mohyrikosokda naha soho nitsaso, kytsa pibezenaha soho kino nitsaso. Nisihyrinymyryky: — Tapara utakta Deus zikpehata maku babata ahawata ikyzik. Sinini mykara Sudeutsa tapara taypyknahatsa kaharere bo yhỹhabyitsa ziknakaranaha. Taparaktsa ziknapamykysokonahatsa Deus wahoro kahumo batu siakparawy. Iwatahatsitsa kino niwatihi kaharere bo yhỹhabyitsa ziknakaranaha. Kytsa pikbezenaha. Petok puruze mynahyrizikpo — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Iwa nitsaso kytsa nisihyrinymyryky, iharere amypubyri batu ihokdaha. Iwaze Peduru Sesus zioktyhyryk. Zibetsakak ipe niy: — Iwa katy kaja sosobyity — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Sesus uwok niyze zinymyrynahatsa bo iktsa niyze Peduru pe niy: — Satanas nabo pãotykta — niy. — Ikia Deus harere bo yhỹhabyitahi tsimy, hawa kytsa mytsaty mykaranaha ana bo hi yhỹ tsimykara iwatahi Satanas wata tsimozik — niy, iwa zibetsakik. ");
INSERT INTO rkbNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Iwaze Sesus kytsa sizubarẽtsa bo nisihuahuaka. Zinymyrykynahatsa ahatsa nisihuahuazo. Sibo nipamykysoko. Ispe niy: — Aty katukbabata mozihikik zeka atakta pibyituhukutu hawaha iakparawy zeka ana humo ka piwari. Kaharere bo zuba ma tsimykaranaha. Kytsa iharapatawyhyta bo iktsa mahaze maku pibezenaha sihyrinymyrẽtsa. Pibyituhukutu kawata tsimahaktsa! Tozeka ja ikiahatsa kawa tu sinini tsimykaranaha! Hawa sinini mykara naha humo kawatu sinini tsimykaranaha hỹ. Ikiahatsa kahumo sinini tsimykaranaha zeka ana humo hi tykymynahaktsa kytsa! ");
INSERT INTO rkbNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","36","Aty tapokzitsi zuba zeka tahyrizikararawy pihokda. Tanamy pihokzaba. Aty inamy ty tsizubarẽna piakse zeka mohyrikosokdaze tsizubarẽna mohokda. Ihyrizikararawy niwatihi mohokda. Aty tohi kahumo ispirikpo iwaze kytsa ity pibeze atahi Deus tuk tawahi mynapykyryk. Atahi kahumo tispirikporẽta Deus wasania ty motsasoko atakta mohyrikosokdaze atahi Deus tuk tawahi mynapykyryk. ");
INSERT INTO rkbNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Katsa Deus tuk mywahi tsimynapykyry tsihikiknaha zeka Deus bo batu amy ty ibo nyny zikaha. Deus harere humo zuba yhỹ tsimykaranaha iwaze tawahi ituk mynapykyryk, isapyha ty mybo nyny my. ");
INSERT INTO rkbNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mektsaktsa kytsa simysapybyitsa tu nikaranaha, asaktsa abaktsa kytsa deusbyitsa humo yhỹ mykaranaha. Kahumo sisikpybyrẽtsa. Kaharere humo kino niwatihi sisikpybyrẽtsa. Utakta Deus zikpehata maku wata ikyzik. Deus imysapyrẽnikita izikwy tuk myziksizo. Bijoikpe iknyktsa Deus tsumuẽhĩtsitsa kino niwatihi situk myziksizo. Myziksizoze, aty kahumo tisikpybyrẽta zeka. Uta kino ihumo kasikpybyrẽta. Aty kaharere humo tisikpybyrẽta zeka. Uta kino iharere humo kasikpybyrẽta Asaktsa batu katukytsa byitsawatsa — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Kaharere wasani mykara. Deus hi ityryktsa mynasipehaka. Kytsa abazubaha mynasipeha. Wastuhu ahatuk kytsa ana bo hi iktsa maha. Deus ahapehakatsa mozik ana bo hi iktsa maha. Bykyzehu zuba mohyrikosokdanaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kyze mytsyhyrytsa wa zurunahaze Sesus hara bo jobonita bo kytsa nisioktyhyryk. Peduru Tsiaku Suão iwatsa nisioktyhyryk. Asa zuba, ustsaktsa nitarenaha. Sibaze meky watu itahyrity. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Tisukbarazarẽta niyzik. Katsaktsa ibarazabaharẽta batu myny hỹ. Ibaze kytsa petoktsa natakahanaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Erias, Moises ahatsa, tubabatu nihyrikosokdanahatsa tu, ituk nipamykysokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Iwaze Peduru: — O myhyrinymyrytsa, wastsa wyzik tykara eze harakykbyihi ahaparik tazi. Estuba ikia bo, estuba Moises bo, estuba Erias bo iwa — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Tsipybyrẽta tu amy ty ja nipamykysoko batu inymyryhy. Sipybyrẽtsa tu nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Iwaze bijo satata inasiharasuk. Bijo satata eze nihokdanaha. Deus iaksoho ziwabynaha. Atahi ispe niy: — Atakta katse babata, ihumo ka kamypokzitsiarẽta uta iwatawyta. Mytsasoze tsiwabytoktonahaktsa! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nitsasobaze atsoko Sesus atazuba nitare. Paikpa iktsa nikaranaha. Sesus bo zuba nikozonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Bykyze hara jobonita ekze inasikzonahaze Sesus: — O jabasani tsinynaha ty kaja kytsa bo ka soso byitaha! Uta Deus zikpehata ahawata ikyzik mohyrikosokdaze mynahyrizikpoze ana zuba kytsa bo tsimypamykysonaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Yhỹ niaha. — Amy skaraba inahyrizikpo — mytsaty nikaranaha. Sihyrinymyrybyitsa nikaranaha, iwaze asa zuba nipamykysokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Iwaze ipe niaha: — Amo humo sa Moises harere mymyhyrinymyrykynahatsa hi “Tapara Erias myziksizo”. Amo skaraba iharere mymywatawy — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","— Wasani my. Tapara Erias mozumuze atsatu ezytyk pikymyze. Kytsa Deus humo sispirikporẽtsa mytsaty mykaranaha. Tubabatu utakta Deus zikpehata ahawata ikyzik kasoho hi ziwatahanaha. “Atakta sinini mykara. Ihumo mymyijakanaha, ihumo batu siakparawy. Iharere bo batu yhỹhabyitsa ziknakaranaha”. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Hawa sa ziwatahakanaha Erias soho atsatuty nikaranaha. Erias hyritywata botu izumu. Isukyrytsitsa zimyijakanaha zibezenaha. Amy ty tubabatu ziwatahakanaha atsatu nikaranaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kyze Sesus tuktsa ustsa zinymyrykynahatsa bo zumunahaze kytsa sizubarẽtsa sipauk baze iktsa niaha. Sudeutsa sopykwy humo sihyrinymyrẽtsa zinymyrykynahatsa tuk nahapepehakanaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Kytsa sizubarẽtsa Sesus bo iktsa niahaze sipybyrẽtsa nikaranaha ibo inatururukiknaha. Iwaze ipe: — Tsikzumu — nikaranaha. Yhỹ ikzumu Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","— Hawa hatsa sa zinymyrykynahatsa tuk tsimyharape pehakanaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Estuba maku tihi: — O myhyrinymyrykytsa, katse zioktyhyryk. Hyrikoso sapybara ibo pororo ziknakara iwatahi iharerebyita iharawita niwatihi. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Myzumuze wytyk bo naraha narahaka, isake soroporo, tatsaputy dy nikara itsipa ziboro. Iwaze zinymyrykynahatsa pe iky: — Hyrikoso isapybara katse bo pororo ziknakara ata kino tsiksiwyhiknahaktsa kytsa. Ipe nabo pãoty tsimaha iky. Zinymyrykynahatsa batu zikaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Iwaze Sesus ispe niy: — Ikiahatsa Deus humo batu ahaspirikpo, Deus humo ahaspirikpo byizeka iwatsa tu ahatuk mynapykyryk. Jypykyhyzytykta kabo tyzioktyhyk! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Iwatsahi jypykyhyzytykta Sesus bo zioktyhyryknaha. Hyrikoso sapybara Sesus bo iktsa niyze jypykyhyzytykta wytyk bo zirahawy opykani nitydydyky niy. Jypykyhyzytykta wytyk buruk paikpa niparakak weze weze nikara. Isake soroporo zipoko. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Sesus izo pe niy: — Hawaze sa atse niwa niu — niy: — Jabaseze tu niwa niu — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","— Hyrikoso sapybara pibeze tsihikik. Hyrikoso sapybara humo pihik bo piharazukik izo bo pioktsokik. Iwa pibeze tsihikik — izo niy. — O tymytsumuẽhĩkta! Azikwykyta zeka tymytsumuẽhĩkta! Myhumo amypokzitsiakta! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","— Hawa sa tsimy “azikwykyta zeka”. Yhỹ ikyba. Aty Deus humo ispirikpo zeka kazikwy humo ziky — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Atsoko jypykyhyzytyktazo kakaik niy, Sesus pe niy: — O ahumo kaspirikporẽta tsikaeni zuba. Tsipiktsumuẽhĩ zeka ahumo mospirikpotohi kaspirikporẽta babata mozik — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Kytsa sizubarẽtsa harape baze ziknapykyknahaze Sesus ihyrikoso sapybara pe niy: — O hyrikoso sapybara aharawita aharerebyita kino niwatihi nabo pãoty. Awahi pãoty. Erete eretebyijaty — niy. Iwa ihyrikoso sapybara zipehahik. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Iwaze ihyrikoso sapybara kakaik niy. Jypykyhyzytykta nitydydykyk tu. Iwa niparak. Jypykyhyzytykta nirata hyrity wata niyzuknihikare niy. Iwaze kytsa tihi: — O atakta botu nihyrikosokda — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Sesus jypykyhyzytykta tsyhyrype humo paik niy. Zitsumuẽhĩkĩ ity kyik niy. Tsakurẽta niyzikzo. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Iwaze Sesus wahoro bo paku niy. Asazubaze zinymyrykynahatsa ipe niaha: — Amo skaraba katsa ihyrikoso sapybara ty batu tyiksiwyhik batu zikaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","— Deus bo pamykyso byizeka ihyrikoso sapybara tawata ba ziksiwynaha — Sesus niy. Iwa hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Kyze niukurunahaze, Sesus nisihyrinymyryky. Haneze niy kytsa batu sihyrinymyry anahi ziny tsihikik. Karareu buruk niukurunahaze zinymyrykynahatsa zuba nisihyrinymyryky. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Sesus: — O aibani kasukyrytsitsa pikbezenaha. Pikbezenahaze petok puruze mynahyrizikpo — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Zinymyrykynahatsa asa zuba: — O amy skaraba “mynahyrizikpo” — mytsaty nikaranaha. Zinymyrykynahatsa tahasikpybyspyk tu batu ity peha. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","34","Kyze zinymyrykynahatsa Sesus hapik ske buruk niukurunaha. Asa zuba nipamykysokonaha. Kytsa tihi: — Utakta mypehatsa wata. Ahazubarẽtsa tyziktsumuẽhĩnaha! Usta: “O batu, utazakta! batu, utazakta!” — nikaranaha. Kyze Kaparanaũ bo zumunahaze, Sesus ispe niy: — O kytsa hawa skaraba tsiktsasokonaha. Ske buruk tsikukurunahaze hawaha tsiktsasokonaha — niy. Tahasikpybyspyk. Batu harere. Batu yhỹ. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Iwaze Sesus itadyhyze: — Kapauk baze dyhy dyhytaha! Tsipiwabynaha. Ikiahatsa: “Utakta mypehatsa wata sizubarẽtsa moziktsumuẽhĩnaha” tsikykaranahaze, Deus kino myha batu. Deus tihi: “Aty sa tatukytsa mysitsumuẽhĩekik, atahi mypehatsa wata. Atahi katyryktsa tukta myhyrizikwanita my” niy. Hyỹ nikaranaha. Hawa sizotsa mozihikiknaha siharere humo astsa tu nikaranaha iwa Deus harere bo hyỹ tsimykaranaha zeka iwaze Deus tyryktsa tsimoziknaha. Iwa ahabyi zeka batu Deus tyryktsa tsimoziknaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Iwaze Sesus jabasitatsa tsibik tahatazaha eze tyrikto niy. Ziharapykze sibo ziwatawyky: ");
INSERT INTO rkbNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Sesus: — O jabyitsa humo ahamypokzitsiukrẽtsa zeka, niwaha humo ka kakurẽta. Ikiahatsa kahyrytsa watsa. Jabyitsa humo ahamypokzitsiukrẽtsa zeka kahumo niwatihi ahamypokzitsiukrẽtsa. Iwaze ikiahatsa humo kakurẽta zeka Deus kino niwatihi. Atahi mybarawy bo zikpeha — ispe niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Kyze Suão Sesus bo nipamykysoko: — O myhyrinymyrykytsa maku tsinynaha hyrikoso sapybara nisiksiwyhik azikwy humo. Atakta katsa mytukbyita tu iwatsahize katsa ipe: “Batu tihikta! Ikiakta mytyrykbyita tsimy” — tsikaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Sesus: — O batu. Ahasopyksapybyritsa tsimykaranaha. Aty tohi amy ty kytsa batu zik kahumo my zeka atakta kaokzeka pisapywyky. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kahumo tsakurẽta mozik. Asaktsa myhumo sisakanibyitsa mytukytsa moziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Kaharere wasani hỹ tsiwabytoktokonaha. Aty pihik ty ahabo nyny my zeka ikiahatsa Kiristu tuktsa humo atakta isapyha ty ibo nyny my — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Sesus nisihyrinymyrykyzo. Kytsa jabyitsa bo nisiaknikinaha soho Sesus ispe niy: — Aty harahare ty pisoikaĩhiknaha zeka iwaze pihik maporik bo nipapykik iwaze moharazukik ana humo batu isapy. Atakta jabyitsa kahumo tispirikporẽta tu zeka zimyiwyky ana humo batu imysapy. Atakta imysapybyrẽnikita babata. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Atsyhyrype ahumo isapybyri zeka, atsyhyrype ty iykzykikty. Deus sapy bo tsimytsukze atsyhyrype estuba zuba zeka wasani. Sinini ykarawy bo zeka atsyhyrypetsa petok zeka wasanibara bo tsipasapy. Sinini ykarawy anaeze izo ba zikbe. Anaeze winuputsa tahawahi mynapykyryknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Apyry humo isapybyri zeka apyry ty iykzykikty. Deus sapy bo tsimytsukze apyry estuba zuba zeka wasani. Sinini ykarawy bo zeka apyrytsa petok zeka wasanibara bo tsipasapy. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ahyrizik humo isapybyi zeka ahyrizik ty hyrykokik ty. Deus sapy bo tsimytsukze ahyrizik estuba zuba zeka wasani. Sinini ykarawy bo zeka ahyriziktsa petoktsa zeka wasanibara bo tsipasapy. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Sinini ykarawy eze ka izo ba zikbe. Anaeze winuputsa tahawahi mynapykyryknaha. Sinini mynakaranaha. Anaeze tsizubarẽna batu mysapy, kytsa tawahi mynapykyryknaha. Iwatsahi mysapybaraka tamoewyhik. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Hawa katsa poro siraratsani kykywy iwazeka ba ziktahõrõ anahyrity wa ha Deus mymysininiwy iwaze imysapybaraka tsimoewynaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Poro tisapyrẽna. Poro morỹk byizeka ba zik tsakykyzonaha. Poro iõrỹkbara wytyk humo batu sapy mozik mymaiwy. Poro mydisahawy tsakykyha wasani my. Iwa hyrity wa ha ahamysapyhuktsa kytsa! — niy. Tynaharape pokzitsikinaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Iwaze Sesus niparak. Sudeja bo. Sorodão buburu zitsikza. Iwaze myzubaha ibo inakypykyknaha nisihyrinymyrykyzo. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Pariseutsa zukzuk niaha. Izumunahaze ibo nipamykysokonaha. Asatu niharapepehakanahatsa tu iharere zimyi tsihikiknaha. Ipe niaha: — Hawa sa wasani maku taoke pimoewyhik zeka Moises harere bo ja batu yhỹ ha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Sesus: — Amo taparakta Moises harere botu zahapehaka — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Moises tihi: — Maku taoke pimoewy tsihik zeka tapara papeu atatsa soho piwataha iwaze atatsa pãoty zikaha my. “Ikia hi batu kaokebyitatsa” piwatahaka — niaha. Iwa kytsa siokeza siakparawy byizeka ziknakaranaha. Aokzeka ja wasani nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Sesus ispe niy: — Ikiahatsa Deus harere bo yhỹ ahabyitsa tsikykaranaha. Iwatsa tu Moises ahaharere bo yhỹ niy. Deus harere bo ahawabytoktobyitsa tu tsimykaranaha iwaze Moises ahaharere bo yhỹ niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Tapara Deus mybarawy nizuknize iwaze maku wytyk ahatsa niwatihi nisisukni. Petoktsa nisisukni. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","Iwatsahi kytsa tahazotsa bara botu tahasapynaha tahaokeza tuk zuba tahasapynaha. Isukzata batu ata zuba mozuru harapetok mozurukunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Iwatahi Deus maku ibarikta nizukni atatsa ioke nizukni niwatihi Deus okzeka estuba zubata wata iwatahi ba zikaharapemoewynaha. Iwa zeka batu imysapy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Iwaze Sesus tuk zinymyrykynahatsa wahoro bo pakuzo niaha. Asa tihi: — Amy ty sa nisihyrinymyryky — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Iwaze Sesus ispe niy: — Maku taoke moewyky zeka mektatsa tu piakse zeka batu imysapy my. Taoke humo batu imysapy my. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Iwa wytyk atatsa kino tabarikta moewyky zeka mekta tu piakse zeka. Atatsa imysapybyitatsa. Tabarikta humo batu imysapy — niy. Nawa Sesus sibo nipamykysoko. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Kyze wastuhu sizotsa tahahyrytsa Sesus bo nisioktykyryknaha. — O Sesus myhyrytsa ty paik tsimy zeka sakurẽtsa tsimoziknaha — niaha. Zinymyrykynahatsa sihumo sisakparẽtsa iwatsahi batu ibo zuk. — O nabo tsiksizonahaktsa! — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Sesus ziwabyze takyriki. Sesus: — “O nabo tsiksizonahaktsa!” soso byitaha! Jabyitsa uta kabo tynasioktyhyknahaktsa! Deus tyryktsa jabyitsa watsa. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Jabyitsa kino isapyha ty isty nyny my zeka sakurẽtsa moziknaha: yhỹ sisopyk. Jabyitsa watsa zeka Deus pe: yhỹ tsimaha. Deus pe: yhỹ aha byizeka ityryktsabyitsa tu tsimaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Sesus sihyrytsa nisibykyk, siwatu isty paik niyze. Deus pe: — O kazo sihyrytsa tynasipokzitsikikta — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Kyze Sesus ziokpykyze iwaze niukuru maku tsinamyrẽta ibo izumu. Izumuze Sesus okeryk taekaratsa humo puruk puruk niy. O Sesus tsimysapyrẽta humo ka iwaze puruk puruk niy. Ipe niy: — O myhyrinymyrykytsa ikia hi tsamysapyrẽta. Hawa sa mykara, iwatahi uta mohyrikosokdaze Deus tuk kawahi mynapykyryk — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Sesus: — Amo skaraba ikia kape tsiky “tsimysapyrẽta”. Deus zuba tsimysapyrẽta koikny baktatu tsimysapyrẽta. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Deus harere tsinymyryky. Mektsa okeza ba ziksipyrirynaha. Ba zikahapebezenaha. Usta namy ty hyryk hyryk byitaha. Ba zikspihikbatanaha. Ba zik mybarapetu tsimaha. Azotsa humo awatu ty amypokzitsiuhukta! Deus harere bo yhỹ tsimy zeka iwaze Deus tuk tawahi tsimynapykyryk — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Inamynikita ipe niy: — O myhyrinymyrykytsa jabasize tu aharere humo wasani ziknakara — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Iwaze Sesus ibo iktsaziu niy. Ihumo tsimypokzitsiarẽta. Ipe niyzo: — Ikia aba estubaha ty tsimy. Tsipiksi anamy huak ty okyrysaro ty. Iwaze sinamybyitsa bo okyrysaro ty nynybaik tsimy. Iwaze hi anamy baba ty Deus sapy eze tu tsimy. Anamy baba ty mopykyryk. Bykyze pany! Kapik tynao — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Inamynikita ana ziwabyze iakubyri tisukatsihikrẽta. Tsinamyrẽta hi tanamy pokzi tsiwy tuk batu yhỹ niy iwatahi batu iaku. Sesus ekze niparak tisukatsihikrẽta. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Iwaze Sesus zinymyrykynahatsa bo iktsa niy. Ispe niy: — Sinamyrẽtsa Deus tyryktsa moziknaha tsihokdaharẽna. Tahanamy bo zuba mytsaty mynakaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Zinymyrykynahatsa iharere humo nipybybaiknaha. Sesus nitsasokozo: — O kytsa katukytsa watsa hawa Deus tyryktsa moziknaha tsihokdaharẽna hỹ Deus harere bo yhỹ ahabyitsa iwatsahi ba Deus tyryktsa zikyziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Tsihokdaharẽna siraratsa kamero inarokota mysukwowowy ispioke buruk mytsuk. Tsinamyrẽta Deus tyryk mozik tsihokdaharẽna hỹ batu zik — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ana humo ziwabykynahaze sipybyrẽtsa asa zuba nipamykysokonaha. — Aty skaraba Deus tyryktsa moziknaha — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Sesus sibo iktsaziu niy. Ispe niy: — Kytsa tuka batu zikaha. Deus humo ka batu amy tohi ihokdaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Peduru ipe niy: — Niwazuba! Katsaktsa mybo ka iktsa tykta, mynamy mywahoro eze niwatihi tsizubarẽna tsikzerebaiknaha iwaze ikia tuk tsimymysapynaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Sesus: — Kaharere wasani my. Wabyziutaha! Aty tawahoro perekek zeka katukta mozik, atakta Deus wasaniha humo tispirikporẽta mozik. Atahi abaka sẽ sizubarẽtsa wahoro ty nyny mykara, ana wata aty tatukytsa myserekek zeka, taziky, tatsy, taje, tazo, tahyrytsa tatsuhuk iwa myserekba zeka ustsa itukytsa Deus ibo nyny my. Sẽ itukytsa sizubarẽtsa hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Abaka ustsa ziky, itsy, ije, izo, ihyrytsa, itsuhuk sẽ sizubarẽtsa ty iwa ibo nyny mykara. Ustsa pisapybyriki. Kyze atakta mohyrikosokdaze Deus baze tawahi mynapykyryk. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Sizubarẽtsa tihi: “O katsaktsa myhyrizikwanitsa tsa watsa tsimoziknaha” mybarapetu nikaranaha. Asaktsa siapiktsa zuba moziknaha. Abaka sizubarẽtsa siapiktsa maha asahi sihyrizikwanitsa watsa moziknaha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Kyze Serusarẽhe bo niukurunahaze Sesus siharaze niukuru. Zinymyrykynahatsa ihumo mytsaty nikaranaha. Ustsa kytsa siapik niukurunaha sipybyrẽtsa nikaranaha. Iwaze Sesus tuk zinymyrykynahatsa bo nipamykysokozo, hawa sa ihumo my. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","— Wabyziutaha aba katsa Serusarẽhe bo tsikukurunaha. Uta Deus zikpehata ahawata ikyzik Serusarẽhe bo mokuru. Nakpo zukzuk tsimahaze kytsa taparaktsa Deus wahoro eze ziknapamykysonahatsa, Moises harere ty nisihyrinymyrynahatsa iwatsa kasukyrytsitsa bo pikoktyhyryknaha. Pikspihikbatanaha. “Atakta Deus okzeka batu mysapy mykara, katsa kino niwatihi atakta batu mysapy mytsaty tsimykaranaha” motsasonaha. Bipyritsa bo pikoktyhyryknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Pikuezozokoknaha. Pikikinaha. Pikbezenaha. Iwaze petok puruze mynahyrizikpo. Utakta Deus zikpehata, ahawata ikyzik pikbezenaha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Kyze Tsiaku itsy Suão niwatihi Sesus bo izumunaha. Asa hi Sebedeu hyrytsa niaha. Sesus pe niaha: — O myhyrinymyrykytsa abo tsimyzapykykynaha zeka atsatu mybo yhỹ tsimy — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","— Amy sa tsimyzihikiknaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","— Ikia aparakbaha abazubata tsimozikze katsaktsa abaze dyhy dyhy tsimaha. Estuba apanuryk taba dyhy my. Usta apawazo taba dyhy my — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","— Amy sa tsimyzapykykynaha batu ahahyrinymyry. Tozeka ja sinini tsimaha kawata ja. Pikbezenahaze ikiahatsa ja. Kawata pahabezenaha zeka ana kino ahapunihiku ja. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Yhỹ niaha. Iwaze Sesus ispe niy: — Sinini tsimaha kawata hỹ. Pahabezenaha kawata pikbezenaha hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Aty kabaze dyhy my ba ziktsaso. Aty kapanuryk taba dyhy my. Aty kapawazo taba dyhy my ba ziktsaso. Deus botu nisiwatawy utakta batu — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ustsa zinymyrykynahatsa Tsiaku Suão ahatsa harere ziwabynahaze taokanikinaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Iwatahi Sesus tabo inasipehaze ispe niy: — Bipyritsa pehatsa kytsa sizubarẽtsa mysipehakanaha. Katsa abazubatsa mytsaty ahabyitsa mykaranaha. Kytsa ziknasipehaikiknaha. Ana tyhi ahahyrinymyrẽtsa. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ikiahatsa ahatuk batu. Aty mysipeha tsihikik atahi sizubarẽtsa mysitsumuẽhĩ. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Aty myhyrizikwanita mozihikik ahatuk sizubarẽtsa mysitsumuẽhĩkĩ. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Utakta Deus zikpehata ahawata ikyzik. Mybarawy bo inasikze myzubaha mysitsumuẽhĩ. Myzubaha humo ba katsumuẽhĩhuk kytsa katy ba ziktsumuẽhĩnaha ana bo ka batu zuk. Ikzumuze mybarawy ezektsa sisapyzeky mohyrikosokda iwatsahi asaktsa Deus tuk tahawahi mynapykyryknaha. Kabezewy humo kytsa simysapyrẽtsa moziknaha ana bo hi ikzumu — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Kyze Baratimeu ihyrizikubyita zizororowy. Sesus zinymyrykynahatsa tuk Serikoho bo niukurunaha. Kyze Serikoho zipokonahaze kytsa sizubarẽtsa siapik niukurunaha. Ihyrizikubyrita Baratimeu Timeu tse Serikoho ske sak eze nidyhyky. Ba zikozo batu amy tohi humo ziky. Kytsa ziharamunahaze sakpyri zuba ziwaby. — O kaboja, kaboja! — nikara. Kytsa okyrysaro ty ibo nyny niaha. Siske eze nidyhyky. Kytsa Baratimeu pe: — Sesus Nasare ezekta mozumu — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Iwaze Sesus ibaze Baratimeu kaka niy: — O aidytykta Sesus! Tyziktsumuẽhĩkta! O Sesus ikia mydiri Dawi tse kahumo amypokzitsiukta — kaka niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Kytsa zibetsakaknaha: — O aksobyitykta! — niaha. Tybyi zuba niy: — O tyziktsumuẽhĩkta kahumo amypokzitsiukta, Sesus! — kakazo niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Sesus itarikto: — Pany! Uta kabo tyzioktyhyknaha! — niy. Kytsa ihyrizikubyita zihuahuahiknaha: — O apybybyihukta! Riktotykta! Sesus pahuahuaka — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Atsoko itarikto. Tasuk izezerẽnikita zibokikare. Sesus bo niparak. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Sesus: — Amo skaraba hawa sa my — niy. — O myhyrinymyrykytsa ba zikozo. Kahyriziktsa tysizororowykta! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Sesus: — Ikia kahumo aspirikporẽta. Iwatahi pazororowy — niy. Iwaze nihyriziktsa nisizororowy nikozozo. Sesus hapik niukuru. ");
INSERT INTO rkbNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Kyze Sesus tuk zinymyrykynahatsa Serusarẽhe bo niukurunaha. Betepake Betanija baze na hara jobonikita Oriwereja inarokota baze anaeze Sesus tatuktsa petoktsa nisipeha: ");
INSERT INTO rkbNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","— Nabo pãotaha kytsa. Atsezubaha myharaze tsimypupunahaze pikuza tsibik tsipipiktumunaha. Ata bo hi isoikãihita tsipinynaha, batu aty tohi ibete dyhy. Satsukyktaha! Kabo tyzioktyhyknaha! ");
INSERT INTO rkbNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ustsa kytsa: “Hawa sa tsimykaranaha” maha zeka, “Mypehakatsa mype niy kabo tyzioktyhyknaha” tsimaha! “Bykyze ahabo tasirezo” tsimahakta! — niy. Yhỹ niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Iwaze niukurunahaze, pikuza ske eze zinynaha hokbowy baze zikahanaha. Isoik ihaĩhita bo zisatsukyknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ustsa kytsa sibaze tutsa: — Hawa sa tsimykaranaha. Hawa hatsa sa pikuza tsipisatsukykyknaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","— O mypehakatsa tihi mype niy pikuza tsibik kabo tyzioktyhyknaha. Bykyze ahabo tasirezo — niaha. — Yhỹ. Tsioktyhyryknahaktsa! — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Sesus bo pikuza zioktyhyryknaha. Tahasuk pikuza bete zizozokonaha. Sesus ibete niukuru. ");
INSERT INTO rkbNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Iwaze ustsa kytsa kino niwatihi tahakpyzazawy ske buruk zipaparakanaha. Tsarakzapatsa jerukbara ezektsa ty bokok bokok ky niaha ana humo kino niwatihi ske buruk nisipaparakanaha. Iwa tsimykaranaha Sesus tsimysapyrẽta humo asazuba nipamykysokonaha ");
INSERT INTO rkbNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Sizubarẽtsa Sesus haraze, kytsa iapik kino niwatihi niukurunaha, myzubaha zihuahuakanaha. — Sesus Deus baze niapykyk, mywata niyzik. Deus bazekta tu, katsa mybo izumu. Deus mybarawy bo zipeha. Atakta tsimysapyrẽta. ");
INSERT INTO rkbNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Taparakta Dawi mydiri wata “O Deus ibo zisapywy iwatsahi mykurẽtsa!” Ata humo Deus tyryktsa tsimoziknaha. Atahi wasani mynakara. “O ihumo mykurẽtsa hỹ” — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Iwaze Sesus Serusarẽhe bo niukuru. Deus wahoro zubata bo nitsuk. Paikpa kytsa bo iktsa nikara. Zunubakaze, Betanija zinymyrykynahatsa tuk ziksizonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Sesus estuba zuruze zinymyrykynahatsa tuk Serusarẽhe bo ziksizonaha. Niukurunahaze irapa izumu. ");
INSERT INTO rkbNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ẽrykani umaha bo iktsa niaha. Tisarozubarẽta niy. Iwaze Sesus umaha bo nakpo zuk niyze iharabyita botu zuk niy. Ihara ziberiki. Isaro zuba. Batu iharaka. Aibani zuba tahara. ");
INSERT INTO rkbNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Iwatahi umaha pe niy: — Niwazuba! Aharahokbita ba aty tohi ahara zezukzo — niy. Ana humo hi zinymyrykynahatsa ziwabynaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Kyze Sesus tuk zinymyrykynahatsa Serusarẽhe bo niaha. Deus wahoro zubata isturupeze bo nitsuk. Kytsa asaktsa myraratsa ty ziknasihuakaknaha okyrysaro humo. Ustsaktsa bipyri okyrysaro humo Sudeutsa okyrysaro ty ziknasihuakaknaha. Iwaze Sesus sizubarẽtsa nisiksiwykik. Atsoko nitururuknaha. Asaktsa okyrysaro ty nisihuakaknaha sidisahawyzozokorowy nisitsihipetotokokbaik. Asaktsa amytudutsa nisihuakaknaha sidyhywytsa nisitsihipetotokbaik. ");
INSERT INTO rkbNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Sesus ispe niy: — Batu amy tohi Deus wahoro zubata isturupeze sinamy ba zisikta batu skeke — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Iwaze nisihyrinymyryky. — Deus harere tubabatu ziwataha tihi: “Kawahoro zubata haneze nanabyitabaktsa myzubaha kabo mynapamykysokonaha” ziwataha. Ikiahatsa kawahoro sitsyhyryboarẽtsa wahoro tsimyzapyhuaknaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Taparaktsa ziknapamykysokonahatsa, asaktsa Sudeutsa sopykwy zikziwatahakanahatsitsa kino niwatihi iharere ziwabykynaha. Ana kino ziwabynahaze pibeze tsihikiknaha. Ipokso sipybyrẽtsa. Myzubaha Sesus harere bo yhỹ mykaranaha ihumo sispirikporẽtsa iwatsahi ipokso sipybyrẽtsa. Isukyrytsitsa tu pibeze tsihikiknaha myzubaha pokso tsawyzik batu zikaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Zunubakaze Sesus zinymyrykynahatsa tuk niparakzo. Betanija bo ziksizonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Byri zokorobyitu niukuruzonahaze umaha bo iktsa niaha. Iharatatsa niharaparabaiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nezeba Sesus nipamykysoko ana bo hi Peduru mytsaty nikara iwaze ipe niy: — O myhyrinymyrykytsa iktsa tykta! Umaha ikia tsikykarata niharapara — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Sesus: — Deus humo ahaspirikporẽtsaktsa! ");
INSERT INTO rkbNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Kaharere wasani my. Wabyziutaha! Hara jobonita bo tsipepehanaha zeka “Nabo pãoty buburu zuba bokta”. Nawa tihi my. Ba mytsaty tsimaha “O buburu zuba bo ja, batu yhỹ ja” tsimaha. Ahaharere humo buburu zuba bo my. Deus humo tsimyspirikponaha zeka hawa ha sa tsimyzapykykynaha atsatu ahabo nyny my. ");
INSERT INTO rkbNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Hawa ha ty Deus bo tsimyzapykykynaha zeka ana humo hi Deus ahabo nyny my, iwa tsimaha zeka ihumo tsimyspirikponaha. Nawaze ahabo nyny my hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Deus bo tsimypamykysokonahaze kytsa humo batu ahakyri. Ikia tsipakyriki zeka ustsa simysapybaratsa humo aha bo mahaze ana humo ka tyspiriktsokdakta iwatsa tu tysiokzohik tsimaha. Simysapybyitsa tu nikaranaha tsimysiokzohik zeka myzo bijoikpe ezekta ahamysapybyi humo pahaokzohik. ");
INSERT INTO rkbNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ikiahatsa kytsa simysapybyitsa bo mytsaty tsimykaranaha zeka myzo bijoikpe ezekta kino ahamysapybyi humo ba zikspiriktsokda ba zahaokzohik — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Kyze Serusarẽhe bo niukuruzonaha. Sesus Deus wahoro zubata eze zitabakaze taparaktsa Deus wahoro ziknapamykysokonahatsitsa, Sudeutsa sopykwy zikziwatahakanahatsitsa, taparaktsa Sudeutsa kapitãotsa nisipeha iwatsa ibo zumunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","30","Ipe niaha: — Aty sa ikia pe Deus wahoro zubata kytsa tysiksiwyhik! Katsyhyryze tarabajakta! tsimykara. Aty sa zapeha — niaha. Batu ihumo siakparawy iwatsahi ibo nipamykysokonaha. Iwaze Sesus ispe niy: — Aty sa Suão Batista pe: “Kytsa tysiharasusukta” niy. Aty sa Suão Batista zipeha. Tozeka ja Deus ipe niy. Tozeka ja kytsa ipe niaha. Aty sa kabo tsimytsasokonaha — Sesus niy. — Ana hi kabo tsimytsasonahaze uta kino ahape my. Aty kape: “Tarabajakta iwa tihikta” my — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Iwaze taparaktsa kapitaõtsa asa zuba nipamykysokonaha. — Hawa sa tsimaha Deus ipe niy zeka kytsa tysiharasusukta tsimaha zeka iwaze Sesus mype: “Amy skaraba Suão humo ahaspirikpobyitsa tsimaha” — my. ");
INSERT INTO rkbNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","— Katsa batu tyso “Kytsa ipe tysiharasusukta”. Myzubaha Suão Deus sohokotsa babata humo ka sispirikporẽtsa iwatsahi kytsa pokso batu tyso, kytsa ipe tysiharasukukta batu tyso — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Iwaze ipe niaha: — Suão Batista soho humo batu myhyrinymyry — niaha. Iwaze Sesus ispe niy: — Uta kino ahabo ba ziktsaso aty kape: “Tarabajakta” — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Iwaze Sesus myzubaha bo nipamykysokozo. Waratok humo nikaranahatsitsa soho nitsasoko iwa nisihyrinymyryky. Atahi: — Maku estuba duabohotsa nisiparikik. Nisiparikikze jokarawytsa ty okehyry okehyry niy. Ihoke ziuku anaeze kytsa duabohotsa tsik nisipypyrikiknaha. Iwaze tsihitsa jo bo isparik ziziki anaeze ziperykykta duabohotsa nisisukparaka. Waratok tsihitsa niparakze kytsa pe: “Utakta mu. Nokponi mokuru. Ikiahatsa duabohotsa tysiperynaha! Tsapukte buruk kaperytsa humo duabohotsa ty ahabo nyny my” niy. Yhỹ niaha. Iwaze tsihitsa meky botu itasapy. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kyze duabohotsa nijakuknahaze tsihitsa tatsumuẽhĩtsa pe: “Tupaktsa! Iperytsitsa bo tsimy. Abaka duabohotsa nakymynaha, siperytsitsa mysizyzykyknaha. Iwaze okyrysaro tsapukte bo duabohotsa huak humo kabo tyzibykyk!” niy. Yhỹ niy. Niparak. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Zumuze duabohotsa perytsitsa nizokbatsinaha. Nitsakikinaha. Awani ziksiwyhiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Iwaze duabohotsa tsihitsa usta tsumuẽhĩtsa zipeha. Anabo zumuze zimyijakanaha. Ziharektotokoknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Iwaze ustsa tsumuẽhĩtsa nisipeha. Wastuhu nisikikinaha ziksiwyhiknaha. Ustsa nisibanaha. Hawa tapara tsumuẽhĩtsa sisopyk atsatu ustsa bo niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Iwaze itse babata zuba are niy, ihumo tsimypokzitsiarẽta. Iwatatu tatse sibo zipeha. Tapetu nikara: “O katse humo ka ja ba zikaha” mytsaty nikara. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Iwaze duabohotsa perytsitsa itse zinynahaze asa zuba nipamykysokonaha. Asa tihi: “Atakta duabohotsa tsihitsa tse my. Ata kino izo mohyrikosokdaze izo namy takse. Duabohotsa tsaizekita takse. Tabezehiktsa kytsa! Tsipibezenaha zeka katsa hi duabohotsa tahaksenaha” niaha. Iwa asa zuba nipamykysokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Iwaze tsihitsa tse nizokbatsinaha. Zibezehiknaha. Inury duabohotsa kosobara bo nipapykiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Tsihitsa ziksize hawa my duabohotsa perytsitsa bo my — Sesus niy. — Atahi mozumuze iperytsitsa mysiba. Duabohotsa mektsa botu nyny my. Duabohotsa sukpesapy ty ustsa skezokotsitsa bo nyny my — Sesus nikara. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Tubabatu Deus harere papeu humo botu ziwatahaka. Ana hi tsinymyrykynaha. — Harahare wahoro mozoknikitsitsa batu isapy mytsaty nikaranaha iwatsahi nipapykiknaha, ata hi harahare abazubata niyzik iwatahi wahoro tisapyrẽna niyzik — Deus harere niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","— Ana hi Deus mykara. Iwatsahi katsaktsa: “O tisapyrẽna. Tsipisapywyky tsimaha. Deus mypehatsa ihumo hi tisapyrẽna hỹ tsimaha”. Iwa tubabatu Deus harere papeu humo botu ziwatahaka — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Iwaze sisukyrytsitsa sihyrinymyrẽtsa. Hawa nitsasoko sisoho nipamykysoko ana humo hi sihyrinymyrẽtsa. Iwatsahi itsipa humo ziokty tsihikiknaha. Kytsa pokso sipybyrẽtsa. Iwaze sisukyrytsitsa zerekeknaha ziksinaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kyze asaktsa Sesus sukyrytsitsa Pariseutsa, Erodes tuktsa kino niwatihi kytsa Sesus bo nisipehakanaha. Nizokparakanaha iharere batu isapy mozihikiknaha ana wakysukik Sesus bo zumukunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Zumunahaze asa hi: — O myhyrinymyrykytsa tisapyrena haty zuba nisihyrinymyryky ana humo myhyrinymyrẽtsa. Kytsa pokso batu apyby, kytsa abazubatsa humo ikia batu asikpyby. Kytsa aharere siakparawy byizeka batu asikpyby. Amy bo mytsaty tsimykaranaha tsihyrinymyrẽta hỹ. Deus harere ty zuba tsimysihyrinymyryky. Ahyrinymyrywy baba ty zuba tsimykara. Tozeka ja mypehatsa abazubata Homa Sesa okyrysaro ibo nyny tsimaha. Tozeka ja batu nyny tsimaha. Hawa sa batu myhyrinymyry — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Sesus simysapybyi humo tsihyrinymyrẽta. Iharere batu sapy mozihikiknaha humo tsihyrinymyrẽta. Iwaze ispe niy: — Amo kaharere humo imysapybara tsimyzihikiknaha Okyrysaro ty estuba kabo nynytaha! Okyrysaro wata bo iktsa taha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Okyrysaro wata ty estuba ibo nyny niaha. — Aty naro sa okyrysaro humo ziwatahaka. Aty hyrikoso sa okyrysaro humo ziwatahaka — niy: — Abazubata Sesa hyrikoso okyrysaro humo — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Sesus: — Niwazuba. Abazubata Sesa namy ty ibo tu tysizotahaktsa! Okyrysaro ty abazubata Sesa bo tsisizonaha. Hawa ha Deus mozihikik ana ty zuba Deus bo nyny tahaktsa! Deus hawa ty mozihikik ibo tysizotaha — Sesus niy. Iharere ziwabynahatsa paikpa iktsa nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Kyze wastuhu Sadusitsa Sesus bo zumunaha. Asaktsa tsimyhyrizikosokdanahaze ba ziknahyrizikponaha mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Iwatsahi Sesus pe niaha: — O myhyrinymyrykytsa, tubabatu Moises ziwatahaka. Deus harere myhumo ziwatahaka atahi “Taparakta maku nihyrikosokdaze itsy haramukuka ziakse. Iwaze atatsa tabykyhyze mopurukze kytsa tihi: ‘O izikytse mopuruk’ maha” niy. Iwa Deus harere papeu humo ziwatahaka. Ipezo maha. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Kyze kytsa sete itukytsa nisakba. Taparakta tasukza. Kyze hyrytsa ahabyita tu nihyrikosokda. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kyze itsy haramukuka bo zipytsawy. Itsy kino niwatihi ihyrytsa byita tu nihyrikosokda. Bykyze itsy taziky wanu sapy bo ziaksezoze ata kino ihyrytsa byita tu nihyrikosokda. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Iwa itukytsa nisakba katsyhyrywatsa sete atatsa ziakse. Estuba nihyrikosokdaze usta itsy atatsa zioktyhyryk siwatu atatsa zioktyhyryk. Kytsa hyrytsa ahabyitsa tu niakbakanaha. Iwaze atatsa kino niwatihi nihyrikosokda. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kyze nawa puruze sizubarẽtsa mynahyrizikponahaze aty sa ibarikta babata niaha. Sete itukytsa atatsa ziaksenaha iwatsahi aty sa ibarikta babata — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Iwaze Sesus ispe niy: — Ana humo kino zahaspihikbatakanaha. Deus harere siakbatsa sohowy humo batu ahaspirikpo. Deus zikwy humo batu ahahyrinymyry. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Abaktsa kytsa tahasukzanaha. Wytykyryk mysiaksekenaha. Iwatsa tu mohyrikosokdanahaze mynahyrizikponaha. Inahyrizikponahaze sisukzabyitsa bijoikpe eze tu mynapykyknaha. Ba zikarazonaha. Iwaze bijoikpe iknyktsitsa watsa moziknaha asahi batu tahasukza — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","— Tsimyhyrikosokdanahaze tsinahyrizikponaha ana ty hi tsinymyrykynaha — niy. Tubabatu Moises ziwataha, ana papeu humo ja batu ahahyrinymyry. Mytsatytaha! Moises okyrysaro mokorobaka soho ziwatahaka. Hana eze okyrysaro ikny Deus yksoho ziwaby. Deus tihi: — Utakta Deus my. Taparakta Abarão kahumo tispirikporẽta. Adiri Isake niwatihi kahumo tispirikporẽta. Adiri Sako kahumo tispirikporẽta. Iwa — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Kytsa niakbakanahatsa Deus humo batu sispirikpo. Kytsa asatu zuba ihumo sispirikporẽtsa. Iwatsahi asaktsa tapara niakbakanahatsa aba kino asatu sispitu. Iwatsahi Deus tihi: — Uta hi Deus my asahi kahumo mospirikpokonaha. Iwatsahi kytsa batu myhyrizikpozo mytsaty tsimykaranaha zeka batu wasani tsimaha, tsipimyinaha — ispe niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Kyze estuba siwatahakatsa Sesus bo niy. Hawa isukyryktsitsa pe nitsasoziuku ziwaby. Iwaze Sesus pe niy. Atahi: — Amy ty sa Deus harere aba zubaha iharere. Tisopykzubarẽta sa — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Sesus ipe niy: — Deus harere iwa aba zuba my. Wabytaha Isareu ezektsa! Deus estuba zuba koikny baktatu atahi Deus babata. Ihumo ahaspirikporẽtsa. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Deus harere bo zuba hyỹ tsimykaranaha. Ibo zuba mytsatyziuty. Ihumo ahamypokzitsirẽtsa babatsa. Itsyhyrype ze tarabajaziuba tsimykaranaha. Tsahapaikrẽtsa itsyhyrypeze ahahyriziktsokzawy tsimykaranaha. Hawa Deus mytsaty mynakara tsipinymyrykynaha zuba. Nawa tubabatu Deus harere papeu humo botu ziwatahaka. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Usta harere aba zuba tihi: — Ahatuktsa pauktsitsa tynasipokzitsikinaha, ahumo tsinakaranaha watihi. Iwa tubabatu Moises Deus harere papeu humo ziwatahaka. Anaharere petoktsa abazubatsa maha iwatsahi anaharere bo hyỹ tsimykara — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Iwaze Sudeu ziwatahakata nitsaso: — O myhyrinymyrytsa hawa ty tsimykara wasani my. Deus estuba zuba, koiknybakta tu atahi Deus babata. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Katsa ibo tsimykaranaha tihi. Atahi abazubata my. Ibo zuba mytsatyziu tsimykaranaha tihi. Ihumo mymypokzitsirẽtsa babatsa. Iharere bo zuba hyỹ tsimykaranahaktsa. Mypaikrẽtsa itsyhyrypeze myhyriziktsokzawy tsimykaranaha. Hawa Deus mytsaty mynakara tanymyry zuba. Iwaze mytuktsa pauktsitsa tysipokzitsikinaha my humo tu tsinakaranaha wa tihi. Ana harere aba zuba. Katsa siraratsa nisibanahaze Deus bo isty nyny tsimykaranaha. Wasani my. Siraratsa tsimysikorobanahaze iwaze Deus bo nyny tsimykaranaha. Wasani my. Katsaktsa iharere bo hyỹ tsimykaranaha zeka ana humo hi wasani babatsa tsimykaranaha Deus myhumo tsakurẽta mozik — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Sudeu ziwatahakata nitsasoziuku iwaze Sesus ipe niy: — Ikia Deus tyryktsa tsimozik tsihikik abanury tu tsimozik — niy. Iwatsahi kytsa iharere pokso sisikpybyrẽtsa. Batu — Hawa sa tsimy niahazo — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Iwaze Sesus Deus wahoro zubata eze nisihyrinymyrykyze ispe niy: — Hawa Deus harere hyrinymyrytsa Deus zipehata Dawi tsekokatsa mozik. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tubabatu Dawi Deus hyrikoso humo nitsaso. Deus pehatsa pe: “Kapanuryk taba dyhyty! Bykyzehu utakta Deus asukyrytsitsa apyrytsa pukezi typykyk apokso sipybyrẽtsa” niy. Iwa Dawi Deus hyrikoso humo ziwatahaka. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Tubabatu Dawi hi Kiristu Deus zipehata pe “Kapehatsa” iwatahi Deus zipehata Dawi tsekokatsa hỹ ata kino ipehatsa niwatihi — Sesus niy. Kytsa sizubarẽtsa iharere humo sakurẽtsa niyziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Sesus nisihyrynymyrykyzo. Atahi: — Moises harere hyrinymyrytsitsa humo pykyhytutaha kytsa! Asaktsa tahasuk humo tisapyrẽna ty zuba siakparawy. “Katsa zuba mysapyrẽtsa” mybarapetu nikaranaha. Anasapy kytsa sinamy pihuakaknaha, anaeze kytsa zihobyknahaze sibo nitsasoziukunahaze ana kino siakparawy. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Sudeutsa wahoro eze sidyhydyhywytsa sisapyrẽtsa zuba siakparawy. Tahamyikahanaha zeka isapyha zuba siakparawy. Sisorokrẽtsa. “Katsaktsa wasani tsimykaranaha” mybarapetu nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Asahi maku nihyrikosokdaze haramukuka namy piaksenaha. Okyrysaro piaksenaha. Asahi kytsa okzeka Deus bo mopamykysokonahaze sipapatu haramukukaka namy piaksebanaha. Kytsa okzeka ihyritywaha humo zuba, Deus sihumo tsihyrinymyrẽta. Atahi sinini ykarawy bo mysipehahik anaeze tahawahi mynapykyryknaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Kyze Sesus Deus wahoro zubata isturupeze okyrysarosuk baze nidyhyky. Kytsa okyrysaro suk bo zipopokonaha ana bo hi nikozoko. Sinamyrẽtsa okyrysaro tsizubarẽna ty poktohi nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Iwaze haramukuka bo iktsa niy. Inamybyitatsa tu okyrysaro suk bo korok niy. Atatsa okyrysaro suk bo okyrysaro kaha tihi petok tsibik zuba korok niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","Iwaze Sesus zinymyrykynahatsa pe: — Totsohi bo iktsatahaktsa! Atatsa okyrysaro tsizubarẽna ty nyny niy, iwatatsatu petok tsibik korok niy. Sinamyrẽtsa okyrysaro tsizubarẽna ty nyny niaha iwatsa tu siokyrysaro kino kyhybyri habara ziknakara. Atatsa katsa batu. Inamybyitatsa tu okyrysaro ty tadisahawy huakaty nynybaik niy. Deus okzeka ikahatyhi okyrysaro ty nynybaik niy. Atatsa hi okyrysaro ty nynybaik tsihyrizikporẽtatsa nikara — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kyze Sesus Deus wahoro zubata ekze zinymyrykyta ipe niy: — O myhyrinymyrytsa iktsa tykta. Haraharetsa sisapyrẽtsa sibuzurẽtsa. Deus wahoro zubata ipamabita — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Sesus: — Yhỹ. Haraharetsa bo iktsa ty. Aibatohi haraharetsa ba harape bete zozo zikaha. Haraharetsa mynatõtõbaiknaha, iwaze Deus wahoro zubata nakarakbaik — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Bykyze Sesus nidyhyky. Oriwerejatsa hara eze nidyhyky. Deus wahoro zubata bo inakozo. Iwaze Peduru, Tsiaku, Suão, Ãdere iwatsa ibo nipamykysokonaha. Asazubatsa ibo nipamykysokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","— Hawaze Deus wahoro zubata mynakarakbaik amy ty sa tsimymyhyrinymyry ana hi mybo tsipiwatawy — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Iwaze ispe niy: — Pykyhytutaha! Kytsa pahaspihikbataikiknaha hỹ. Siharere bo ka waby waby byitaha! ");
INSERT INTO rkbNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Sizubarẽtsa mozumunahaze pahaspihikbatanaha “Utakta Kiristu Deus zikpehata maha” mybarapetu mykaranaha. Siharere batu wasani my situka pão pão byitaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Tsiwabykynahaze kytsa nokponi mysibanaha, kytsa bytykara eze kino niwatihi mysibanaha. Ahapybybyihu ja iwa my zeka mybarawy ipykbaratu. ");
INSERT INTO rkbNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nanabyi tabatsa myharape sukyryikiknaha. Nanabyi taba usa koikny mybarawy taba mytydydykyk tu. Kytsa sizubarẽtsa taharapa piyknaha. Batu sidisahawyky iwa myziakbataka mysinininaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","— Pykyhytutaha! Botu ahabo iktsaso. Kytsaharerewabytsitsa bo pahaoktyhyryknaha. Sudeutsa wahoro eze pahamyijakanaha, kapokzi pahakikinaha. Tahapehatsitsa bo pahaoktyhyryknaha. Ikiahatsa siokeze tu kaharere tsimytsasonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Taparaka wasania ty myzubaha bo tsimytsasonaha bykyze zuba mybarawy mopykba. ");
INSERT INTO rkbNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ahatsipa humo pahaoktyhyryknaha. Sipehatsa okeryk pahaoktyhyryknaha zeka ahaharere soho mytsaty mytsaty byitahaktsa! Sipehatsa okeryk tsimytsasonaha zeka Deus pahatsumuẽhĩ. Deus hyrikoso myzapikso izikwy humo tsimytsasonaha iwaze ahahyrinymyrẽtsa hỹ. Ahasukyrytsitsa ahaharere ba ziaksenaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Iwaze atukytsa siharerewabymybarẽtsa tu maku tahatsy ty sisukyrytsitsa bo mysioktyhyryknaha iwa mysibanaha. Sizotsa tahahyrytsa sisukyrytsitsa bo mysioktyhyryknaha iwa mysibanaha. Sihyrytsa kino niwatihi tahazotsa humo tahakyrikinaha sisukyrytsitsa bo mysioktyhyryknaha iwaze mysibanaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ikiahatsa kahumo ahaspirikporẽtsa iwatsahi kytsa ahahumo tahakyrikinaha. Atakta tsipunihikrẽta tu tsimysapyrẽta mozik. Aty sinini mykara zeka iwatahi tsipunihikrẽta mozik atakta tawahi Deus tuk mynapykyryk hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Sesus nisispirikpokozo. — Iktsa tsimahaze isapybyiwy anahi imyrawy namymyikik, ana bo kino iktsa tsimahaze Deus wahoro zubata eze batu zetuba my! (Aty papeu pinymyryky siwabynahatsitsa bo pinymyryziuku!) Hawa myze asaktsa Serusarẽhe eze tu Sudeja hara bo tywaknahaktsa! ");
INSERT INTO rkbNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Aty wahoro bete zeka paku paku byity, ba anamy zebyk. ");
INSERT INTO rkbNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Aty tatsuhuk ezeka awahoro bo ba eretezo asuk humo zikykta! ");
INSERT INTO rkbNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Wytykyryk sihyryzahaza sisukatsihikrẽza mopykyknaha. Sijeza niwatihi tahabykytsa tuk sisukatsihikrẽza mopykyknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Deus bo tsimypamykysonaha: “O myzo nawa puruze batu hyritsik tyziwõ tsimyzapykykynaha.” tsimaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Amakata okoroze sinini tsimykaranaha. Deus mybarawy nizuknize kytsa anawa haty batu sinini niaha. Ba sininizo zikaha. Iwaze zuba nawa sinini tsimykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Deus siwatahawyhytsa pokzi nawa puruze mopykba. Batu mybara bo ka siwatahawyhytsa pokzi. Nawa puruze mopyk byizeka batu aty tohi ispitutsa ba zikapykyryknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","— Aty ahabo motsaso zeka “Iktsa tahaktsa! tabo Deus zipehata Kiristu maha” iharere bo ka ba hỹ tsimaha. Usta ahape my zeka “Nabo Kiristu my” iharere bo ka ba hỹ tsimaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kytsa sizubarẽtsa mozumunaha. Asa tihi: “Utakta Kiristu maha” pahaspihikbatakanaha. Kytsa sizubarẽtsa siharere bo yhỹ mykaranaha. Mymyspihikbataikiknaha zuba. Mektsa tu mozumukunahaze “Katsaktsa Deus sohokotsa maha” mybarapetu mykaranaha. Siwatahawytsa mykaranaha ana humo hi kytsa mysiakmyiwykynaha. Deus watawyhytsitsa mysiakmyiwy tsihikiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Iwatsahi pykyhytutaha! Hawa mykara naha botu ahabo motsasoko iwatsahi ahaspirikpohuja! ");
INSERT INTO rkbNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","— Bykyze sininikarawy mopykze nanabyi iwatawy natakaha. Bijoikpe eze iwatahawy natakaha. Haramwe mybe. Miwa zuba byzoje kino niwatihi myhyrizikubyri. ");
INSERT INTO rkbNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Byrisoiktsa mynatsunaha. Bijoikpe iknyktsa mytydydykyryknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Iwaze uta mynasikze kabo tsimykozonaha. Utahi Deus zikpehata ahawata bijo oktsĩ tuk kabo tsimykozonaha. Mynasikze kamysapyrẽta, kahyrizikporẽta, kazikwyrẽta ana kino kytsa sizubarẽtsa mytsaty mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Iwaze bijoikpe iknyktsitsa Deus tsumuẽhĩtsitsa mysipeha. Siwatawyhytsa bo mysipeha. Nanabyitaba siwatahawyhytsa mynakypyknaha — niy. Iwa Sesus tuk zinymyrykynahatsa bo nipamykysoko. ");
INSERT INTO rkbNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","— Umaha bo iktsa tsimykaranahaze ana soho hawa pahawatawy tsinymyrykynaha. Umaha taypykze tapara isarapatsa ytsik humo tasaropok iwaze moziponaha. Iwaze ikiahatsa: “O hyritsik abaka jokboha” tsimykaranaha. Ahahyrinymyrẽtsa. ");
INSERT INTO rkbNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Iwaha hi sinini tsimykaranahaze utakta mynasik ana humo hi ahahyrinymyrẽtsa hỹ. Wasani my. ");
INSERT INTO rkbNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Kaharere ka wasani hỹ wabytaha! Abaktsa kytsa amy ty motsasoko pinymyrynaha. Kaharere atsatu mykara iwaze zuba mohyrikosokdanaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Bijoikpe mybarawy ahaka mohokda. Kaharere ka ba zikokza. Ba nawa taize ja zikaha ba zikpyk. Kaharere ka tawahi mynapykyk — iwa Sesus tuk zinymyrykynahatsa nisihyrinymyryky. ");
INSERT INTO rkbNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Sesus: — Utakta myziksizoze batu aty tohi nawa taize ja ziky ba sihyrinymyryhy. Batu aty tohi sinini ykarawy bo myze ba ihyrinymyryhy. Bijoikpe iknyktsa Deus tsumuẽhĩtsitsa kino ba sihyrinymyryhy. Uta kino Deus tse babata tu batu kahyrinymyryhy. Kazo zuba tsihyrinymyrẽta. ");
INSERT INTO rkbNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Iwatsahi tsimyziperykynaha! Tykymybanahaktsa! ");
INSERT INTO rkbNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Hana wa okoroze sinini okarawy mozumuze maku wata. Atahi meky botu moparak. Taparaka tatsumuẽhĩtsitsa sihyriziktsokdawy humo mysipehare. Hokbowy perytsitsa nisipeha. Iwaze tawahoro ekze niparak. ");
INSERT INTO rkbNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Iwa tsiperynahaktsa! Zihitsa myziksizo naha humo batu sihyrinymyry. Kyze punubaze ja myziksi, unopokte ja myziksi, nakokze ja myziksi, zokorobyi tu ja myziksi. Batu ahahyrinymyry. ");
INSERT INTO rkbNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Atsoko myziksizo zeka batu ahazika. Iwatsahi tsiperykynahaktsa! ");
INSERT INTO rkbNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Hawa ha ty ahape mykara atsatu sizubarẽtsa pe mykara. Ahazikara byihuja tsiperykynahaktsa! kytsa — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Aba petok puru nahawaze simyikaha asiba inakymy. Simyikaha atsikara ipytowybara ty zikziokoknaha. Simyikaha eze Deus taparaktsa nisitsumuẽhĩ bo mytsaty ziknakaranaha. Iwaze Deus wahoro eze ziknapamykysokonahatsitsa, siwatahatsitsa kino niwatihi Sesus ziberikinaha. Sisukyrytsitsa niaha. Itsipa humo zioktyhyryk tsihikiknaha. Tabezehikta nikaranaha tsahi kytsa papatu asahi Sesus zibeze tsihikiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Asa hi: — Mymyikaha eze tuze ba Sesus zibezenaha. Kytsa pokso mypybyrẽtsa. Tsipibezenaha zeka iwazeka kytsa mymybabanaha. Sizubarẽtsa niakmyinaha — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Sesus Betanija bo zumu. Tapara Simaõ iakõrõrõta zizororowyta wahoro bo nitsuk. Tahadisahakanahaze wytyk inatsuk. Atatsa jokmorẽnikia ty taoporosuk arabastero harahare hi, tsipokzitsarẽna niy. Narado inarokoha tsipokzitsarẽna ty. Atatsa Sesus boze taoporosuk zisoiktsakik iwaze jokmorẽnikia ty iharek bete ziharasusuku. Iwa nikara. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Iwatsahi wastuhu sakzohotsa ihumo tahakyrikinaha. Tahasakparekenaha: — Amy skaraba jokmorẽnikia ty piharasusuku — asa zuba nipamykysonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","— Jokmorẽnikia tsipokzitsiarẽna. Katsaktsa jokmorẽnikia ty tahuak zeka okyrysaro tsizubarẽna humo, 300 denario tsimaha. Iwaze okyrysaro ty sinamybyitsa bo nyny tsimaha zeka wasani tsimaha — nikaranaha. Iwa zibetsakaknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","— Awatu betsak betsak byitaha! — Sesus niy. — Atatsa hiba wasani mykara. Amy humo sa tsipesuka tsihikiknaha nikara kahumo tisapyrẽna niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Sinamybyitsa ahapauk baze mopykyryknaha zeka sibo nyny tsimaha zeka wasani my. Utakta kabo ka ba nyny zikaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Abanurytu pikbezenaha. Mohyrikosokda. Atatsa kanury ziharasusuku iwaze kaytyk bo mokymy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","— Kaharere tsiwabyziunahaktsa! Nanabyitaba Deus wasania ty myzubaha bo motsasokonaha. Hawa atatsa niy ana ty hi nanabyitaba inapamykysokonaha niwatihi iwaze sizubarẽtsa atatsa soho bo mytsaty mykaranaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Kyze Sudas Iskariotses isopyksapybyita tu mykara. Sesus tuk zinymyrykyta iwatatu Deus wahoro eze ziknapamykysonahatsa taparaktsa bo zumu ispe niy: — O Sesus batu ahakparawy. Tsipibeze tsihikiknaha. Uta pahatsumuẽhĩ. Bykyze uta hi ibo pahaoktyhyryk — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Iwaha ziwabynahatsa sakurẽtsa nikaranaha: — O ikia tsimymytsumuẽhĩ zeka okyrysaro ty abo nyny tsimaha — niaha. — Yhỹ. Bykyzehuta! Aba ibo piksizo — niy. — Yhỹ. Tsipiksi za — niaha. Iwaze Sudas mytsaty nikara: — Hawa sa Sesus bo mysioktyhyryk. Yhỹ ja. Bykyzehu — niy. Ziperyky zuba. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Kyze Sudeutsa simyikaha mozumuze zinymyrykynahatsa ipe niaha: — O Sesus hana eze sa mymyikaha tsipikymynaha Hana eze sa ikia tuk karaneru tsani tazobaze tsimymydisahanaha — niaha. Amyikaha bo pororo ziknakaranaha Deus Sudeutsa taparaktsa ziknasitsumuẽhĩkĩnahatsa bo mytsaty ziknakaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Sesus ispe niy: — O nabo tsimykaranaha kytsa. Ikiahatsa petoktsa nabo Serusarẽhe hudikhudikwy bo tsimytururuknaha! Anaeze maku pihik suk pebykykyrykta bo tsimykozonaha. Pihik myzizokota hapikta! Wahoro bo mytsukze, iapik tu paku paku tsimaha! ");
INSERT INTO rkbNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Tsihitsa pe: O myhyrinymyrytsa “Hana eze sa amyikaha eze mydisahawy ty katuktsa tuk hauk tsimaha my” tsimahakta! Iwaze ahape my “Iktsatahaktsa”! ");
INSERT INTO rkbNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Wahoro jobo tsimydokoknaha, pokpedawy bo pykyhytu mydyhydyhywy bo iktsa tsimaha. Mysapy eze inakymy. Anaeze mymyikaha katsa mybo inakymynahaktsa! — niy. Yhỹ niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Iwaze zinymyrykynahatsa petoktsa nitururuknaha. Serusarẽhe bo izumunahaze hawa ty Sesus botu nitsasoko, atsatu niaha. Nawa tahamyikaha zikymynaha karaneru tsani zizobanahaze. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kyze zunubaze Sesus ustsa zinymyrykynahatsa tuk zumukunaha, mytsyhyrytsa watsa tuk izumuku. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","21","Tahadisahakanahaze Sesus ispe niy: — Ahatuk estuba: “O Sesus kaharereziuwybyita my. Abaka batu Sesus tukta my” mykara. Iwatahi kasukyrytsitsa tuk kabo tynasioktyhyk. O bykyze atakta sinini myze zikpuruk byizeka wasani my. Imyspihikbatanikita tu Deus zipehata mywata humo sinini mykara. Ana hi Deus botu ziwataha — niy. Iwaha ziwabynahatsa hi batu siaku: — O aty skaraba. Uta kino batu. Uta kino batu. — nikaranaha. Sihyrinymyrybyitsa tu sibo Sudas soho nitsasoko. Sesus: — Estuba katuk tamihi ty sok mytahi imyspihikbatanikita — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Kyze tahadisahabanahaze Sesus atsikara waha ty okok niy. Deus pe niy: — Ikia humo ka mykurẽtsa — niy. Atsikara zitsatsakak. Sibo zibiakak: — O hauk tahaktsa, naty hauk tsimahaze, kanury soho bo mytsaty tsimaha, “Sesus mysapyzeky nihyrikosokda” tsimaha — niy. Iwa niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Iwaze taoporosuk duabohotsa tsik ty okokzo niy. Deus pe niy: — Ikia humo ka mykurẽtsa — niy. Iwaze sibo nyny niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","— O naka kaspu waha. Tsimyzikukunahaze kaspu soho bo mytsaty tynakaranaha. Kaspu mopuku iwaze Deus ahasoho pe my “Sisopyksapybyitsa humo mysiokzo iwatsahi kaokzeka meky watu moziknaha” Deus mykara. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Uta aba zuba duabohotsa tsik piku. Pikuzoze kazo tuk kytsa tuk asaktsa kaharere bo hyỹ mykaranaha, katyryktsa moziknaha — niy. Iwaze sizubarẽtsa duabohotsa tsik zikukunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kyze unata eze Deus bo nisakibazikiknaha: — O Deus ikia tsamysapyrẽta — nikaranaha. Kyze Deus bo nisakibazibanahaze ape bo ziponaha. Hara jobonita bo Oriwereja inarokota bo niukurunaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Nakpo zukzuk niahaze. Sesus ispe niy: — Utakta aba pikbezenaha. Pikbezenahaze, batu aty tohi katuk mopykyryk. Kasukyrytsitsa pokso tsimywaknaha. Deus harere botu ziwataha “Hozipyrykzatsa irarakata pibezenaha iwaze myraratsa mowakbaiknaha” iwa Deus harere botu kahumo ziwataha. Utakta hozipyrykzatsa irarakata wata. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Mynahyrizikpoze ahaharaze Karireja eze pahapery — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Peduru: — O batu. Ustsa kytsa ja. Utakta batu. Uta kino atuktu mopykyryk. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","31","Sesus: — O Peduru aba unata eze harakykbyi kasoho “Batu Sesus kanyhy” tsimyspihikbata, kokuaro petok nipuze iwa tsimyspihikbata. Iwa ba zabezenaha — niy. — O niwazubakta. Abaze pikbezenaha zeka: “Utakta Sesus tukta” my — niy. Kytsa sizubarẽtsa kino niwatihi nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Kyze Sesus zinymyrykynahatsa tuk hara bo nidoknaha anaeze isaziktsa koso Kesemani inarokoha bo hi nisioktyhyryk. Ispe niy: — Anaeze dyhy dyhytahaktsa! Uta kino Deus bo mopamykyso — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ustsa kytsa dyhy dyhy niahaze, Peduru, Suão, Tsiaku, ahatsahi nisioktyhyryk. Sesus mytsaty nikara: — O bykyze pikbezenaha — nikara. Paikpa mytsaty nikara. Iakubyita niapykyryk. Tisukatsihikrẽta nikara. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Tatuktsa pe niy: — O batu kaku. Pikbezenaha kasukatsihikrẽta mykara. Uta kino Deus bo mopamykysoko. Tykara eze tu tutarenaha. Tsikperynaha ahaõtutsabyihu ja — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Iwaze siharapu bo niparak. Niparakze, wytyk bo okmymy niy, Deus bo nipamykysoko. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Iwaze Deus pe niy: — O kasukyrytsitsa kabo mozumukunaha, kazo. Tsiktsumuẽhĩkta iwaze sinini mykara. Uta tu zeka ba mohyrikosokda tsihikik. Ikia: “Tyhyrikosokdakta!” tsimy zeka, mohyrikosokda — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Iwaze tatuktsa Peduru, Tsiaku Suão ahatsa bo iziksizo. Zurubaiknaha. — O tsikurubaik naha sa Peduru. Katuk batu tsiperyky ja hini hini byitahaktsa! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","— Deus bo typamykysonahaktsa! Deus zikwy humo zuba ikiahatsa ahapunihikrẽtsa tsimoziknaha niy iwatsahi Satanas harere bo batu yhỹ tsimaha. Hawa ha ty wasani tsipitsihikiknaha ikiahatsa batu ahapunihik iwatsahi Deus bo typamykysonahaktsa — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Atsa botu ziksizoze, Deus bo nipamykysokozo: — O “Tyhyrikosokdakta!” tsimy zeka, kazo, utakta mohyrikosokda — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Sibo ziksizoze, zurubaikzonaha. Tahaõtutsaspyk nikaranaha. Sesus: — O tsipuruziukunaha zuba — niy. Batu harere zikaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Bykyze Deus bo nipamykysozoze sibo ziksizo. — O abaze sihi tsikahabyrynaha. Abaka ba zikumunaha. Abaka utakta Deus zikpehata ahawata ikyzik kasukyrytsitsa bo pikoktyhyryknaha niy. Abahi pikbezenaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kyiktykta! Tupaktsa! Abaka imyspihibatanikita mozumuku. Kasukyrytsitsa kabo tynasioktyhyryk. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ana hi nitsasokoze Sudas ibo izumu. Sudas zinymyrykyta tu siharereziubyitsa tuk izumuku. Sesus bo inasioktykyryk. Tanoratsa upepetsa iwatsa tu nasebykyknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Tapara Sudas ispe niy: — O Sesus piwatawyze piharapyrykze ahanyhybyitsa tsipinynaha kytsa. Atahi piharapyryk! Iwaze itsipa humo tsioktyhyryknahaktsa! — niy. Taparaktsa Deus wahoro eze ziknapamykysonahatsa nisipeha Sesus pioktyhyryknaha, Moises harere hyrinymyrytsa, Sudeutsa taparaktsa kino niwatihi nisipehanaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Iwaze Sudas Sesus bo zuk niy. Sudas: — O ikzumukta kahyrinymyrytsa — niy. Iwaze Sesus ziharapyryk. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Kytsa Sesus zioktyhyryknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ipaukbazekta Sesus tukta tasokorotsapu izibok. Maku spi zizykik. Atahi taparakta maku ziknapamykysokota Deus wahoro zubata eze tsumuẽhĩtsa. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Sesus ispe niy: — Amo skaraba tanoratsa ahaupepetsa iwatsa tsiknasebykyknaha. Awatutaha. Utakta katsyhyryboabyita. Batu kakyri. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ahatuk zikzuruku. Ikiahatsa tuk Deus wahoro zubata eze zikzahahyrinymyryky. Iwatsa tu batu katsipa humo katy oktyhyryk. Deus harere botu ziwataha itsyhyryboanikita wata katsipa pikoktyhyryknaha. Aba zuba katsipa humo tsipikoktyhyryknaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Iwaze zinymyrykynahatsa niwakbaiknaha. Tahapybyspyk hi niwakbaiknaha. — Iwa zeka mymybabanaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Itsipa humo zioktyhyryknahaze mykyryburukta Sesus hapik niukuru. Atahi niwakik panu ty irikpidiwyhyta niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Nizokbatsinaharẽta tu niwakik. Tazikpidiwy zuba sibaze zereke. Iwatahi isukbyitatu niwakik. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Kyze Sudas tuktsa taparakta ziknapamykysokonahatsa tuk myhyrizikwanikita wahoro Sesus zioktyhyryknaha. Taparaktsa kapitaõtsa watsa Moises harere hyrinymyrytsitsa kino niwatihi anaeze niapykyryknaha. Sizubarẽtsa inakypyknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peduru tsipybyrẽta hi ẽrykani iapik inaukuru. Taparakta wahoro sturupe eze nitsukze iwarikspyk sodadutsa baze nidyhyky izo baze niakpyzazaka. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Iwaze taparaktsa Deus wahoro ziknapamykysonahatsitsa. Sudeutsa taparaktsa Moises harere hyrinymyrytsitsa ahatsa inakypyknahaze kytsa harere ziwabynaha. Asahi: — O kytsa Sesus soho pisapybyrikinaha iwatsahi pibezenaha — anahi mozihikiknaha. Siharere meky watu nitsasokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Iwaze wastuhu kytsa ispe: — Sesus harere batu wasani — niaha. Ustsa kytsa batu yhỹ niaha. — O batu imysapy — niaha. Isoho nimyspihikbataikik. Mekywatu nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Wastuhu niriktotohokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Asa tihi: — Katsa iharere tsiwabynaha mype niy: “Utakta Deus wahoro zubata anahi kytsa nizukninaha myzipyk bykyze petok puruze usta wahoro mozokni anahi kytsa batu mozokninaha” Sesus niy, anahi tsiwabynaha — mybarapetu nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ana ty hi metutu nitsasokonaha iwatsahi Kajapas: — O mybarapetu mykaranaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nitsasobanahaze, Kajapas sibaze tarikto: — Amo Sesus. Kytsa asoho nitsasokonaha anahi tsiwaby. Hawa sa tsimy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Sesus batu harere. Iwaze Kajapas ipe niyzo: — Hawa sa Sesus. Ikiahi ja Deus zapehata. Ikiahi ja Deus bo tsimymyoktykta. Ikiahi ja Deus tse — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","— Yhỹ. Deus zuba izikwyrẽnikita. Utakta Deus zikpehata ahawata ikyzik. Ibaze tuze mybarawy ezektsa bo zikpeha. Iwaze mybarawy bo mynasik. Aba uta Deus bo mydo. Ibaze tuze bijoikpe eze tu, kabo iktsa tsimaha iwaze mybarawy bo bijo satata tuk mynasikzo — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kajapas ana harere ziwabyze tsiakyriukrẽta niyzik. Iwaze isuk zisykik nawa ziwatawy takyriki. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","— O soso byitaha ba ziktsasonaha! — niy. — “Utakta Deus wata” my. Iharere botu tsiwabynaha hawa sa ity tsimaha — niy. — Tabezehikta! Tabezehikta! — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Iziakbatakanahatsa zehezozokoknaha, zihyrizikwarakanahaze iwaze hi nitsakikinaha. — Aty skaraba zaki — nikaranaha, zimyijakanaha. Isperytsitsa kino niwatihi nitsakikinaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Peduru wahoro peze nidyhyky. Anaeze myhyrizikwanita tsumuẽhĩtsata ziharamuze. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Atatsa Peduru izo bo niakpyzazaka ibo zinytokto, iwaze ipe niy: — O ikia tihi sa Sesus Nasare ezekta tukta tsiky — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","— O batu. Batu kanyhy — nikara. Iharere batu kawabyhy zispihikbata. Iwaze hokbowy baze zumuzoze kokuaro nipo. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Atatsa ibo nikozoze ustsa kytsa pe niy: — O ata tihi kok Sesus tuk zinymyrykyta — niy. Iwa niyzoze: ");
INSERT INTO rkbNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","— O batu — mybarapetu nikara. Bykyze ustsa: — O atatsa nitsasoze wasape hi niaha. Ikia tihiba Sesus tukta ikia kino niwatihi Karireja ezekta — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Peduru tsipybyrẽta nikara: — Batu kanyhy. Aty skaraba Sesus batu itukta Deus kaharere piwabyky iwatahi kaharere wasani byizeka Deus piksininiwyky Sesus batu kanyhy — Peduru nikara. ");
INSERT INTO rkbNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Iwa nitsasokoze kokuaro nipozo. Peduru mytsaty niy. Tapara Sesus kape niy: — O kokuaro ipozoze: Harakykbyri kasoho “Batu Sesus kanyhy” tsimykara — niy. Peduru ana bo hi mytsaty niyze nipuziuku. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kyze zokorobyitu Sudeutsa Deus wahoro eze ziknapamykysonahaktsa, taparaktsa kapitãotsa Moises harere nisihyrinymyrykynahatsitsa iwatsa sizubarẽtsa inakypyknahaze hawa Sesus tabeze nipamykysokonaha iwaze Sesus Piratus bo zioktykyryknaha. Taparaka zipawarakanaha. Iwaze Piratus bo zipehahik. Piratus abazubata iharere awatu zeka Sudeutsa ba zikbezenaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Piratus ipe niy: — O Sesus ikia ja Sudeutsa pehatsa — niy. — Ikia tihi tsiktsaso — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Taparaktsa Deus wahoro zubata eze ziknapamykysokonahatsitsa: — O Piratus Sesus batu imysapy — nikaranaha. Isoho humo zispihikbatakanaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Piratus ipezo niy: — Amo Sesus. Asoho humo zasapybyrikinaha. Tsiwaby sa. Iwa wasani sa — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Batu harere tasoho humo batu harere. Iwatahi Piratus ata zuba tatu mytsaty nikara — O amo skaraba! Batu harere ziky, batu taokani! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Tapara tahamyikaha eze Piratus maku estuba inazukenaha. Maku sizubarẽtsa sakyriukrẽnikitsa hurukwy eze tu. Situkta estuba nizuke. — O aty sa myzuke — nikara. Atakta! Serusarẽhe ezektsa nikaranaha, yhỹ nikara. Iwa simyikaha eze ziknakara. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Serusarẽhe eze kytsa niwatsoronaha iwaze sakyriukrẽtsa nitsahurukiknaha. Estuba sakyriukrẽnikitsa hurukwy eze Bahabas inarokota niy. Kytsa bakatsa niy. Ana humo hi nitsahurukiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Iwaze kytsa sizubarẽtsa Piratus bo zumunaha. — O aty sa tsimyzuke — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Piratus: — O ikiahatsa istsa. Hawa sa tsimyzihikiknaha. Sudeutsa pehatsa za myzuke Sesusta tsimysapyrẽta! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Taparaktsa Sudeutsa tahakyrikinaha sizokdirẽtsa nikaranaha iwatsahi Sesus ibo zioktyhyryknaha ana humo hi Piratus tsihyrinymyrẽta. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","— O batu. Mektatukta! Bahabas zakta! — niaha. Iwa taparaktsa botu kytsa sizubarẽtsa pe niy: — Ikiahatsa tsimaha zeka Bahabas. Bahabas tsimaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Piratus ispe niy: — Sesus ja. Hawa sa Sesus ty my. Atakta Sudeutsa pehatsa — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Myzubaha tihi: — Tabezehikta! Iharapatawyhyta humo tabezehikta! — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Piratus: — Amo humo sa. Amy ty sa imysapybara ty nikara — niy. — Tabezehikta! Tabezehikta! — opykani kazi nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Iwaze Piratus: Yhỹ niy. Nawa myzubaha humo zuba harereziu tsihik mykara iwatahi Bahabas nizukehik. Sesus ta batu. Sodadutsa pe: — O tytsakinahaktsa! Iharapatawyhyta humo tsibezehiknahaktsa! — niy. De. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Kyze sodadutsa Sesus tahawahoro isturupeze bo zioktyhyryknaha. Sodadutsa zumubanahaze Sesus zispihikbatakanaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Isuk tsaririta ty zisuknaha. — O abaka Sudeutsa pehatsa abazubata! tsimy — zimyijakanaha. Inisaha ty zitsorikiknaha. Tubabatu nawa sisopyk. Sipehatsa mekywa tu sitsorik. Sesus ty ka inisaha ty zitsorikiknaha iwaze zimyijakanaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","— O ikia Sudeutsa pehakatsa — zispihikbatakanaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Hwi ty ziharektotokoknaha, zihwezozokoknaha. Tahaekaratsa humo iokeryk puruk puruk nikaranaha, sipehatsa okeryk watsa iwa zisininiwyky. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Zispihikbatabanahaze isuk tsaririta zibokiknaha. Isuk babata ty tysukzonaha. Iwaze ape bo zioktykyryknaha. Iharapatawyhyta humo tabeze nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ske buruk niukurunahaze, Simaõ nasihobyk. Atakta Sireni ezekta tatsuhuk ikny ziksikirita. Ihyrytsa Aresãdere Hupus ahatsa inarokotsa. Iwaze sodadutsa ipe niaha: — O iharapatawyhyta tsebykta! — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Niytahi zebykyk! Iharekpokoso sapy inarokoha bo Sesus zioktyhyryknaha, iharekpokoso Sudeutsa harere kokota maha. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Anabo izumunahaze aty tohi mymyitsapyri hwi ty Sesus bo nyny niy: — Tsõty — niy. Batu niy. Batu tsõ. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Isuk zibokiknahaze ziaksenaha. Sodadutsa harahare zipyryktsa ty nisipaparakanaha aty ja Sesus suk piakse nikaranaha tsahi ziwatawykynaha. Iharapatawyhyta humo zihyrizikiknaha, itsyhyry soikare eze zaza nikaranaha zihyrizikiknaha, ipyrytsa ty kino niwatihi zaza nikaranaha zihyrizikiknaha. Iwaze nepykbanahaze iharapatawyhyta ziriktonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Haramwe nazotoktoze iharapatawyhyta humo zihyrizikiknaha. Zikymynahaze, iharapatawyhyta zitseknahaze ziriktonahaze. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Iharapu bete iwatahaha ty. SUDEUTSA PEHATSA ziwatahakanaha iwa isoho humo hazi nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Kytsa petoktsa sitsyhyryboanikitsa ituk nisibanaha siharapatawyhytsa humo nisibanaha estuba ipanuryk taba usta ipawazo taba ahatsa niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Kytsa nabaze ske buruk niukurunahatsa, zisapybyrikinaha hazi nikaranaha: — O iktsatahaktsa. Taparaka zuba: “Deus wahoro zubata myokarabaka bykyze petok puruze usta pizi tsikykara” abaka tsimyraka — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","— Ikia tsahyrinymyrẽta babata zeka, pany, tynasikta! Ba zikumuzakta — zimyijakanaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","32","Deus wahoro zubata eze ziknapamykysokonahatsa Moises harere nisihyrinymyrykynahatsitsa kino niwatihi nitsasokonaha: — O ustsa kytsa nisitsumuẽhĩkĩ, atahi ba ziktsumuẽhĩ! Iwatatu sa pomoza Deus zipeha zeka “tynasikty”, Sudeutsa pehatsa babata zeka, iharapatawyhyta ekze “tynasikta!” Iwa tsimy zeka: “O Sesus hi Deus zipehata babata” tsimaha — mybarapetu nikaranaha. Asaktsa ituk nihyrikosokdanahatsa asa kino niwatihi zisapybyrikinaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Iwaze tokbaha eze miwa niyzik. Batu haramweke. Sudeja eze miwa niyzik. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Iharakibikia bo zoize inaharamwezo. Iwaze Sesus: — Eri Eri rama sabaktani — ana taharere baba ty huahua niy. Anatyhi myharere. — O Deus amo skaraba uta zuba tsipikarikik — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ustsa kytsa niaha: — Amo sa Erias bo hua mykara — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tohi duabohotsa tsik ipokzitsibara ty itsãrãkbara ty morosuk eze ky ty tsikok niy. Anabo mazori waha ty duabohotsa tsik bo sokyk niy. Zipypyikik. Mazori waha ty hwi humo korokbykyk jobo Sesus sak bo tsyk tsyk nikara. Atakta: — Byriktsa, tozeka ja Erias mozumu, iharapatawyhyta humo piakse. Tsiperynahaktsa! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Iwaze Sesus kakazo niyze zumuza. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Iwaze panu ipamaba ipokpedawy Deus wahoro zubata eze ky nisykbaik. Tsapukte buruk nisyk bijoikny tu niaksykyryk. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Sodadutsa pehakatsa tuk nikozoko iharapatawyhyta okeryk niriktohoko Sesus iwa nihyrikosokdaze atahi: — O atahi Deus tse babata — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Wastuhu wytykyryk nizokparakanaha. Maria Madarena, ustatsa Maria, Sarome, usiza, iwa ẽryk tu nizokparakanaha. Maria hyrytsa Sose Tsiaku jypykyhyzytykta iwatsa niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Asiza hi Karireja ikny ihumo simypokzitsiarẽza nikaranaha. Usiza wytykyryk iapik Serusarẽhe bo zikzumukunaha za kino niwatihi asiza nizokparakanaha: Zitsumuẽhĩekiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Iwaze byiri Sudeutsa nawa zurunahaze tahabyrykywy, nubaze Sose Arimeteja ezekta Piratus bo izumu. Sose taparakta Deus wahoro zubata eze tu niy. Tsimysapyrẽta atahi kytsa Deus harere bo hyỹ mykaranaha ana hi mozihikik. Batu pyby iwaze Piratus pe niy. — O Sesus nury ty kabokta. Uta inury ty iytyk bo mytsahok — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","45","Piratus: — Botu sa pỹ niy — niy. Iwaze sodadutsa pehatsa pe niy: — Sesus sa botu nihyrikosokda — niy. Sodadutsa pehatsa ipe niy: — Yhỹ pỹ — niy. Iwaze Piratus: — Ikia za tsinazipik Sose. Iwaze tsimytsahok — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Sose panu kõpara niy inury inazipikze, panu ty ziakwaraka. Tubabatu harahare yktaba nitsahoknaha, abaka anabo hi nitsahok. Harahare bobyri ihok bo zikorore. Zihokbore. ");
INSERT INTO rkbNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Madarena, ustatsa Maria, ahaza nizokparakanaha. Iytyk zinyrenaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","2","Kyze petok zuruze, sabado nipykze miwa botu Maria Madarena ustatsa Maria, Tsiaku je Sarome, iwahaza iytyk bo niukurunaha. Jokmorẽnikia bykyhy tuk. Niukurunaha zahi inury iokmorẽnikia ty taharasusu nikaranaha. Anahi Sudeutsa sopykwy ty ziknakaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","— O aty sa harahare mytsyhyryze pipetu nikaranaha. Titsakyrikrẽta hỹ. Aty skaraba mytsyhyryze sukyhy my — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Iwaze nitururuknaha anabo zumunahaze iktsa niaha, mektatu botu harahare bobyri zipetuhikare. ");
INSERT INTO rkbNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Iwaze iytyk bo nipupunaha. Anaeze maku bo nikozonaha, atahi nidyhyky. Tisukbarazarẽta. Iwaze ipokso nipybybaiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Maku hi: — Kapokso ahapyby byihujaktsa. Sesus Nasare ezekta atahi kytsa iharapatawyhyta humo zihyrizikiknaha tsipiberikinaha ana hi pinymyry. Atahi inahyrizikpo. Nabo isapy bo iktsataha. Isapy zuba niapykyk. ");
INSERT INTO rkbNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Aidytahaktsa Peduru ustsa zinymyrykynahatsa bo tynakozorẽnahaktsa! ispe tsimaha: “O Sesus inahyrizikpo. Aba tsipinynaha Karireja bo ahaharaze mykara hawa botu ahape niy” tsimaha — bijoikpe iknykta niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Iwaze wytykyryk puke puke niaha. Nitururukuknaha. Sipybyrẽza ziksikirinaha. Nitydydykyknahaza tu paikpa mytsaty nikaranaha. Sipybyrẽza nikaranaha iwazahi kytsa bo batu tyso. ");
INSERT INTO rkbNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sesus domiko eze inahyrizikpo tapara Maria atatsa Makadã ezektatsa bo inatakaha. Tapara Sesus hyrikoso sapybara sete nisiksiwyhikze. Atatsa ihumo nizororobabatatsa. ");
INSERT INTO rkbNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Iwaze atatsa itukytsa bo niy. Ipokzi nipuziukunaha. Atatsa hi: — O myhyrinymyrytsa inahyrizikpo. Ispituzo my. Ikza inyzo — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Itukytsa iharere humo paze! nikaranaha. Inahyrizikpo naha humo ma ahabyitsa nikaranaha. Atatsa mybarapetu ja mykara iwa mytsaty nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kyze Sesus meky watu itahyrity niyzik petoktsa ahatsa bo natakaha. Niukurunahaze amytsĩ eze natakaha. Situk nipamykysoko. ");
INSERT INTO rkbNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Iwatsahi ziksizonaha. Itukytsa bo nipamykysokonaha. Siharere humo kino niwatihi itukytsa ma ahabyitsa nikaranaha. Asaktsa mybarapetu ja mykaranaha iwa mytsaty nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Iwaze zinymyrykynahatsa õse ahatsa bo natakaha. Tahadisahakanahaze sibo natakaha. Ma zikahabyitsa nisibetsakak. Tahaoktsĩnahatsa humo nisibetsakak. Ustsa harere humo inahyrizikpo naha soho batu ma ahabyitsa iwatahi nisibetsakak. ");
INSERT INTO rkbNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Iwaze ispe niy: — Nanabyitaba tynakaranahaktsa! Sihudikhudikwy taba wasania ty abazubatsa bo tytsasonahaktsa! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","— Aty kaharere bo hyỹ my zeka kahumo tispirikporẽta mozik atahi imysapybara ty myzeka Deus piokzohik. Ata kino piharasuhikze iwatawyhyta katukta my, atahi Deus myzo bo pioktyhyryk. Aty kahumo ispirikpobyi zeka imysapybara ty my zeka ba ziokzo, imysapybara ty nikara ituk tawahi mynapykyryk. ");
INSERT INTO rkbNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Asaktsa kahumo sispirikporẽtsa Deus zikwy piwatawynaha. Kahumo hyrikosotsa sapybaratsa tysiksiwyhiknaha. Mektsa harere ty mopamykysokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Pyryhyk ty paik maha zeka ba zikyrikosokdanaha. Tumy tsarawyhyha ty pikunaha zeka ba zikyrikosokdanaha. Simyitsapyritsa tahatsyhyrype ty tsika maha zeka, mysizororowy sakurẽtsa moziknaha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Taharere nitsasobaze jobo bijoikpe bo Deus zioktyhyryk. Tazo tuk ipanuryk taba mynadyhyky niy. ");
INSERT INTO rkbNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Iwaze itukytsa nitururuknaha. Nanabyitaba Deus wasania ty natsasokonaha. Hawa ha ty kytsa batu zikaha ana ty hi Deus zikwy humo nikaranaha. Iwatsahi kytsa siharere bo hyỹ niahaze Sesus humo sispirikporẽtsa niyziknaha. Sipehakatsa hi nisispirikpoko. Deus zikwy humo ziwatawykynaha, Sesus nisitsumuẽhĩkĩ iwatsahi myzubaha siharere bo hyỹ nikaranahaze Sesus humo sispirikporẽtsa niyziknaha. Niwazuba.");
INSERT INTO rkbNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Uta Teopiro bo piwatahaka. Kyze tapara sizubarẽtsa kytsa papeu humo botu ziwatahanaha katsa mybaze hawa tsinynaha ziwatahabanaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Tapara zinynahatsa kino mybo nitsasobanaha Deus harere kino niwatihi nitsasobanaha. Ikia tsahyrinymyrẽta botu wasaniha soho niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Abaka uta kino tubabatu kahyrinymyrẽta. Iwatahi uta kytsa iksipeha: — Hawa skaraba niy — iky. Kabo sizubarẽtsa nitsasobanaha. Iwatahi uta ikia bo pykyhytu piwatahaka. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Iwatatu tsipinymyry wasani tsimy. Kytsa ikia bo botu nitsasokonaha wasani hỹ. Tapara mopamykyso Sakarias soho ioke niwatihi. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Kyze Erodes pehatsa Sudeutsa hudikhudikwy eze tuze Sakarias niy. Deus wahoro zubata eze ziknapamykysokota niy. Abias astsabarẽtsa niy Deus wahoro zubata eze nikara. Abias atsatubarẽtsa tsekokatsa ziknapamykysokonahatsitsa niwatihi. Atatsa ioke Arão tsekokatsa ikny niy. Arão niwatihi Deus wahoro eze ziknapamykysokota. Isabeu inarokotatsa. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Isukzakata zikzuruku harape tuk Deus harere bo hyỹ ziknakaranaha iwatahi Deus isukzakata soho tihi: — Wasani mynakaranaha — niy. Kytsa isukzakata soho humo wasani nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Batu ihyrytsa ka. Iwatatsahi ibykyhy byitatsa zikzuruku. Ihyrytsa ahabyita tu nitsaikbanaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Kyze Sakarias Deus wahoro zubata bo niy. Anaeze Deus tuk tarabaja nikara. Ziknapamykysokota humo tarabaja nikara. Abias astsabarẽtsa tarabaja nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Tapara ustsa ziknapamykysokonahatsitsa ibo nitsasokonaha: — Abaka ikiazakta! Ikia hi Deus wahoro zubata bo tsimytsuk. Tsimytsukze anaeze Deus bo jokmorẽnikia ty tyziwezoko — niaha. Hyỹ niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Deus wahoro zubata bo nitsuk. Jokmorẽnikia ziwezokoze aparakbahatsa isturupeze Deus bo nipamykysokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Niytahi atsoko bijoikpe iknykta Deus tsumuẽhĩtsa ibo inasik. Iwezowy baze jokmorẽnikia niriktohoko. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sakarias ibo nikozoze ihyrinymyrybyita nikara. Iwatahi ipokso nipyby. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Bijoikpe iknykta Deus tsumuẽhĩtsa ipe niy: — Apyby byitykta! Ikia tsikzapykykynaha Deus ziwaby. Aba aoke tabykyhy. Atse mopurukze Suão ty tsipinaro niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ikia atse mopurukze akurẽta tsimozik. Kytsa kino niwatihi atse humo sakurẽtsa moziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Deus okze ka maku myhyrizikwani mozik. Iwatahi duabohotsa tsik ty ka tsõ tsõbyity my, tsõsĩ humo kino niwatihi tsõ tsõ byity. Taje arakokeze tuze Deus ituk mynapykyry. Deus hyrikoso piakse, mopurukze tu Deus hyrikoso ituk mynapykyryk hỹ — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","17","— Atse taypykze Sudeutsa Deus bozo mysioktyhyryk. Atse Erias wata mozuruku. Erias Deus hyrikoso tuk zikzuruku. Atahi Deus zikwy ziwatawy. Deus harere ziwatawyky. Atse niwatihi Deus zikwy piwatawyky. Atahi kytsa Deus zipehata weryk pizozikbawy. Izotsa mytsatyziu maha. Sihyrytsa bo mytsaty maha iwatsatu niharapepehakanaha nakokozonaha atse harere humo mykaranaha. Abaka kytsa Deus harere bo hyỹ maha. Iwaze Deus zipehata mozumuze ityryktsa botu piperykynaha — niy. Iwaze bijoikpe iknykta Sakarias bo itse soho nitsaso. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Niytahi Sakarias ipe niy: — Iwaze sa kaoke tabykyhy tsimy. Hawa sa aharere baba. Utakta ba iktsaikba kaoke kino niwatihi nitsaikba. Iwatatsatu sa tabykyhy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","— Utakta Deus tsumuẽhĩtsa Deus tuk mynapykyryk. Utakta kanaro Kabarieu. Deus zikpehata hi abo iknasik. Iwatahi wasania ty mopamykysoko. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Iwatahi ikia wabyziutykta kaharere bo yhỹ ahabyita hi iwatahi tsimyharerebyri. Atse mopurukze tsipaharerezo. Kaharere ka wasaniha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Kyze aparakbaha Deus isturupeze ziperykynaha. Sakarias Deus wahoro ekze izoik ziperykynaha. Aparakbaha paikpa iktsa nikaranaha. — Amy skaraba atahi Deus wahoro eze tu batu aidy puke ziky — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Izoize niharerebyri. Sakarias Deus wahoro eze tuze itsotospyk waha zinyhik. Mytsotospyk waha ana hi zinymyrynaha. Bijoikpe iknyktsa bo iktsa niy. Myzubaha okze tu niharerebyri iwatahi tatsyhyrypetsa ty zuba pawyk nikara. Taharek ty zuba zikziwatawyky. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Iwaze zuba Sakarias tarabaja Deus wahoro zubata eze zepykze tawahoro bo ziksizo. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Taoke zityrykzuwyze tabykyhy. Estuba tsyhyrywa byzoje zetsuze tawahoro eze tu ziknapykyryk. Isabeu tihi: ");
INSERT INTO rkbNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","— O Deus tsiksapywyky. Kahumo tsimypokzitsiukrẽta. Taparaka kasikpybyrẽtatsa. Kabykyhy byizeka kasikpybyrẽtatsa. Abaka batu. Batu kasikpyby. Iwatatsahi ikbykyhy hỹ. Abaka aparakbaha humo batu kasikpyby. Iwa ikbykyhy tatsatu Deus ziksikpybybyri — Isabeu nikara. Iwatatsahi Sakarias oke tabykyhy. Ibykyhyhuk byitatsa tu tabykyhy niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Kyze usta byzoje eze Deus bijoikpe iknykta Maria bo izipeha. Bijoikpe iknykta Deus tsumuẽhĩtsa Maria bo inatakaha Kabarieu inarokota. Deus zipehata. Deus ipe niy: — Maria pe nawa tykta Kabarieu atatsa Nasare ezektatsa bo — niy. Hyỹ niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","28","— Maria ityrykduwyhybyitatsa tu tabykyhy. Ikia atatsa bo wasania ty tsimy — niy. Iwaze byri puẽtsikze Sose atatsa piakse. Sose Dawi tsekoka niy. Iwaze atatsa bo bijoikpe iknykta inasik. Atahi: — O Deus atuk mynapykyryk — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Tsipybyrẽtatsa iharere pokso nikara. — Hawa ha skaraba — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","— O apyby byityktsa Maria. Deus ahumo papokzitsiki. Ikia tuk mynakara. Aba tsipabykyhy. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Atse mopurukze Sesus ty tsipinaro. Taypykze maku myhyrizikwani mozik. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Aparakbaha isoho humo “Deus tse” maha. Deus tyryktsa tuk mynapykyry ba zikpyk — niy. Deus hi Sesus Sudeutsa pehatsa mozik Dawi wata, ahadiri mypehatsa wata. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Sesus Sako tsekokatsa pehakatsa. Sesus Deus tyryktsa tuk mypehatsa tawahi mynapykyryk. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","35","Maria ipe niy: — Hawa sa katyrykduwyhybyitatsa tu sa pikbykyhy — niy. — O atyrykduwyhybyitatsa tu tsipabykyhy Deus hyrikoso humo tsipabykyhy. Iwatatsahi atyrykduwyhybyitatsa tu tsipabykyhy niy. Iwatsahi kytsa atse soho humo. “Deus tse” maha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","— Wabyty! Ajetsy Isabeu ibykyhyhuk byitatsa tu abaka tabykyhy nitsaikbatatsa tu tabykyhy hỹ. Tapara kytsa tsasowy “batu ibykyhyhuk” nikaranaha. Abaka tabykyhy tatsa estuba tsyhyry wa byzoje zetsuze. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Aba itse mopuruk. Deus tuk batu amy tohi ihokdaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","— O nawa my. Deus pikpehaze hyỹ my. Katyrykduwyhybyitatsa tu katse mopuruk. Ikza hyỹ my — niy. Niytahi bijoikpe iknykta hokda zuba niy. Batu ity nyzo. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Bykyze Maria Isabeu bo harakoso bo atsoko niparak. Isabeu wahoro bo zumu. Ana hi hudikhudikwy Sudejaka. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Sakarias wahoro bo paku niy. Isabeu ziharapyryk. Nipamykysoko. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Atatsa Maria harere ziwabyze ibykyhy iarakokeze tsakurẽta nikara iwatahi kuanare kuanare nikara. Deus hyrikoso Isabeu tuk mynapykyryk. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Iwatatsahi Maria bo opykani nipamykysoko: — Deus pasapywyky. Ikia hi akurẽtatsa tynapykyryk. Awaky wytykyryk tynasiyzikwyky. Abykyhy niwatihi tsakurẽta. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Parakbaha okze tu ikza myhyrizikwanibyitatsa tu my. Hawa tsikytatsa ikia kapehatsa je kabo tsimynakozore. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Aksoho iwabyze atakta kaharakokeze tu kuanare kuanare nikara. Tsakurẽta iwatahi kuanare kuanare nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ikia bijoikpe iknykta Deus tsumuẽhĩtsa harere humo hyỹ tsiky. Iwatatsahi akurẽtatsa. Iwaze Deus harere humo aspirikporẽtatsa akurẽtatsa tsimy — Isabeu niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Niytatsahi Maria Deus bo nipamykysoko: — Ikza tihi: O Deus ikia zuba tsamysapyrẽta. Ikia humo kakurẽtatsa. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Deus bo mykara zeka ipokzi kakurẽtatsa. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Iwatahi kabo mytsaty niy. Nanabyi humo kanamybyitatsa tu sa atsumuẽhĩtsata mozik. Abaka myzubaha kape maha Deus atatsa humo tsimypokzitsiarẽta mykaranaha. Wabyty! Myzubaha eze mopamykysokonaha “Deus ziktsumuẽhĩkĩ” mykaranaha niy. Abaka aparakbaha sitsekokatsa niwatihi kasoho “Deus atatsa humo zisapywyky” mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Deus kino atatsa tsyhyryze tsihokdaharẽna zik niy. Atahi tsizikwyrẽta. Atahi mekywata. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Deus aparakbaha humo tsimypokzitsiarẽta. Iwatsahi sispirikporẽtsa moziknaha. Abaka aparakbaha, sitsekokatsa kino niwatihi Deus sihumo tsimypokzitsiarẽta. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Deus ziwatahaka tsihyrinymyrẽta hiba. Sizubarẽtsa mytsaty maha zeka “uta zuba mypehatsa” sisopykyktsa asahi mysipykik. Iwaze kytsa siharere tsihikbyitsa moziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ispehatsa sihudikhudikwy ezektsa niwatihi mysipykik. Myhyrizikwybyitsa hi myhyrizikwanitsa moziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Siarapanikitsa disahawy ka tsizubarẽna mopykyryknaha. Sinamynikitsaktsa mysinamybyri. Batu amy tohi mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Iwa Deus Sudeutsa mysitsumuẽhĩkĩ. Tatyryktsa mysitsumuẽhĩkĩ. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Tubabatu Deus harere mydiritsa ispirikze niy. Abaka wasani niy. Sibo nitsasoko: “Ikiahatsa humo kamypokzitsiarẽta” niy. Mydiritsa bo Abarão tsekokatsa bo iwa. Deus taharere humo ba zikspiriktsokda Iwa Maria Deus soho humo nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Iwaze byzoje harakykbyihi zitsuze Maria Isabeu tuk niapykyk. Iwaze tawahoro bo ziksizo. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Iwaze Isabeu bykyhy nipuruk. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Itukytsa, iututsa pauktsitsa kino niwatihi sakurẽtsa niapykyryknaha. Isabeu tse humo sakurẽtsa. Ziwabynahaze Deus atatsa humo tsimypokzitsiarẽta, iwatsahi sakurẽtsa niyziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Niahatsahi izumukunaha. Iwatsahi ibykyhy tsibik pipiakzyknaha. Kyze ibykyhy tsibik mytsyhyrytsa asiba nisipykze kytsa izumunaha. Zinaro tsihikiknaha Sakarias ty izo naro ty zinaro tsihikiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ije ispe niy: — Batu zik. Sakarias humo batu inaro tsihik. Inaro babaka Suão — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Iwaze ipe niaha: — Ikiatsaktsa zik anahumo ka batu atukytsa naro kok — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Niahatsahi izo pe niaha. — Askyrywy sa tsipinaro — niaha. Sakarias niharerebyitahi iwaze kytsa ibo tahatsyhyrypetsa ty ziwatawykynaha zuba. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Niytahi Sakarias kino: — Kabo iwatahawy ty nynytynaha — niy. Hyỹ niaha. Iwaze ziwataha — Inaro ka Suão. — Aparakbaha paikpa iktsa nikaranaha sipybyrẽtsa nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Iwazebabatu Sakarias inataharerezo. Tsakurẽta. Iwaze nipamykysokozo. Deus pe niy: — O Deus ikiahi tsamysapyrẽta — niy. Iwa Deus bo nipamykysoko. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Iututsa pauktsitsa iwaha pokso hi sipybyrẽtsa nikaranaha. Nanabyitaba wasaniha Suão soho nitsasokonaha. Harakoso Sudeja eze tuze Suão soho ty nipamykysokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ziwabynahaze mytsaty nikaranaha: — Hawa sa ibykyhy mozik Deus zikwy ituk mynapykyryk — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Iwaze niytahi nipamykysoko. Deus hyrikoso ituk ziknapykyryk. Iwatahi nipamykysoko. Atahi: ");
INSERT INTO rkbNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","— Ikiahatsa Deus bo tsimypamykysokonaha. “Ikia hi tsamysapyrẽta. Ikia zuba wasani tsimykara. Iwaze ikia soho humo myharereziurẽtsa tsimaha” niy. Kyze Isareu tsekokatsa, Sudeutsa Deus humo myspirikporẽtsa. Katsaktsa Deus humo myharereziurẽtsa. Deus tyryktsa tsimoziknaha. Ata kino tatyryktsa bo mymyoktyhyryk — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Deus mymyoktyhyrykta mybo myzipeha. Mymyoktyhyrykta Dawi tsekokatsa iknykta. Dawi mydiri Deus tsumuẽhĩtsa. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Tubabatu Deus simysapyrẽtsa bo nitsasokonaha asahi Deus harere sohokotsa nitsasoko: ");
INSERT INTO rkbNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","— Deus ispirikze iharerebaba mymyoktyhyryk. Iwatahi mysukyrytsitsa ba zik mybanaha. Iwaze kytsa myhumo siakyriukrẽtsa ba zik mybanaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Deus mydiri humo tsimypokzitsiukrẽta. Katsa myhumo niwatihi tsimypokzitsiarẽta. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Tubabatu Deus Abarão bo taharere baba ty niy. Abarão taparakta mydiri niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","“Ikiahatsa pahaoktyhyrykta pipeha” niy. Abaka taharere bo mytsaty niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Mymyoktyhyrykta pipehahik my nikara. Mymyoktyhyrykta pipeha iwatsahi mysapyrẽtsa tsimoziknaha. Mysukyrytsitsa ba zik mybanaha. Mysukyrytsitsa pokso batu mypyby. Niahatsahi tyzibyituhukunahatu Deus tsipitsumuẽhĩnaha. Deus pokso batu mypyby — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","— Ikia kaskyrywy Deus sohokotsa tsimozik. Ikia mymyoktyhyrykta haraze tsimy. Kiristu Deus bo mymyoktyhyryk. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Iwaze mozumuze sizubarẽtsa ahumo mytahazozikymybanaha. Mymyoktyhyrykta humo mokymynaha. Iwaze hi aparakbaha bo mopamykysoko: “Deus sisopyksapybyikitsa nikaranaha iwatsatu mysiokzohik. Deus kino mysioktyhyryk. Iwatsahi Deus soho humo sispirikporẽtsa.” Ikia humo Deus soho aparakbaha sispirikporẽtsa myziknaha niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Iwaze Deus myhumo tsimypokzitsiarẽta. Tsimysapyrẽnikita my. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Abaka atakta mybo bijoikpe iknykta okoro hyritywaka katsa mybo myziharamweke. Haramwe humo iktsa mahatsa watsa mypobyri katsaktsa mymyoktyhyrykta humo myspirikporẽtsa. Taparaka miwa ahaburuk ziknaukurunahaze ky waha. Abaka haramwe waha niyzik. Iwatsahi kytsa mohyrikosokdanahaze batu sipyby. Katsa batu mykyriuk. Katsa mykurẽtsa — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Iwaze Sakarias Deus harere nitsasoko niy. Itse taypykykze Deus harere bo hyỹ mykara. Tsipaikrẽta mozik jerukbara bo niparak. Atazuba zikziuruku. Aiba zuba Deus tyryktsa bo niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Sesus Kiristu purukwy. Deus zipehata mymyoktyhyrykta. Kuirini Sirija ezektsa pehatsa. Aukusto sizubarẽtsa pehatsa niy. Homa ezektsa pehatsa ityryktsa tuk niy. Aukusto tihi: — Ikiahatsa ahazubarẽtsa nabo pãotaha! niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Taparaktsa ahadiritsa hudikhudikwy bo tsiksizonahaktsa! Anaeze aty ahanaro piwataha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Hyỹ niaha. Iwaze kytsa sizubarẽtsa ziksikinaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Sose Nasare ezekta. Nasare Karireja eze tu niy. Iwaze Berẽhe bo zumu. Tubabatu Sose taparaktsa idiritsa Berẽhe eze nipupurukuknaha. Dawi inarokota. Iwatsahi Berẽhe bo zumunaha. Maria ituk zumuku. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Puẽtsikze zuba Sose atatsa piakse. Maria tabykyhytatsa Berẽhe bo zumu. Anabo zumunahaze wahoro inahareknaha. Batu iwewehe. Pikuzatsa parik zuba asa wanu sapy zuba. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Anaeze, Berẽhe eze ibykyhy nipuruk. Ibykyhywyzytykta nipuruk. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nipurukze panu ty ziakwaraka. Pikuzatsa disahawy suk eze tyhoek niy. Iwaze nipurukze Sose taskyrywy zinaroko Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kyze Berẽhe baze tu hozipyrykzatsa perytsitsa. Unata eze hozipyrykzatsa nisiperykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Iwaze unata bijoikpe iknykta Deus tsumuẽhĩtsa sibo natakaha. Deus tsumuẽhĩtsa bo nikozonaha. Sibaze okoro ziky waha niukuru. Sipybyrẽtsa nikaranaha. Bijoikpe iknykta: — Ahapybybyihuktsa Deus hi izikpeha, ahabo wasaniha motsasoko. Tsipiwabynahaze ahakurẽtsa tsimoziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Aba Berẽhe eze Kiristu nipuruk. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ibo tynakozorenaha! Ibykyhy panu eze iakwarahata. Pikuzatsa disahawy suk eze mohoeke. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Iwaze hi ikiahatsa tu tsimyzinyrenaha yhỹ tsimaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Nitsasobaze bijoikpe iknyktsa sizubarẽtsa ibo atsoko inatakahanaha. Deus bo sizubarẽtsa sakurẽtsa nisakibazikiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Asahi Deus bo: — O ikia humo ka mykurẽtsa. Ikia hi tsamysapyrẽta Deus wasani tsimykara. Ikia hi taparata bijoikpe ezekta. Mybarawy ezektsa niwatihi sakurẽtsa mykaranaha. Ikia tynasipokzitsiki iwatsahi sakurẽtsa moziknaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Kyze bijoikpe iknyktsa ziksizonahaze hozipyrykzatsa perytsitsa kino: — Aidyktsa! Berẽhe bo tsimynakozorenaha! Deus katsa mybo nitsaso. Deus tatsumuẽhĩtsa mybo zipehaka. Tsimynakozorenaha! — nikaranaha. Yhỹ niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Iwaze atsoko anabo niukurunaha. Maria Sose ibykyhy iwatsa bo zumunaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ibykyhy pikuzatsa disahawy suk eze nihoeke. Hozipyrykzatsa perytsitsa Berẽhe ezektsa bo nitsasokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Berẽhe ezektsa bo wasania ty nipamykysokonaha. Sakurẽtsa nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Nipybynaha. Maria kino siharere ziwabytatsa tu mytsatyziu nikara. Bykyze hozipyrykzatsa perytsitsa ziksizonaha. Sakurẽtsa nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Deus bo nisakibazikiknaha. Asa kino: — O ikia humo ka mykurẽtsa. Bijoikpe iknytsa humo mykurẽtsa. Jaba Berẽhe eze Kiristu Deus zipehata nipuruk. Nitsasokoze wasani niy — nikaranaha. Bijoikpe iknykta harere ty asta hareretu nikaranaha. Iwa ziksizonaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Kyze estuba mytsyhyrytsa asiba nipykze Sose, Maria tahatse zipiakzyknaha taparaktsa sopykwy ty nikaranaha. Sesus ty zinaronaha. Tapara tu bijoikpe iknykta Deus tsumuẽhĩtsa Maria pe niy: — Bykyze abykyhy mopurukze Sesus ty tsipinaro — niy. Iwa bijoikpe iknykta ipe niy. Iwatsahi Sesus ty zinaronaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","23","Niahatsahi izotsa Serusarẽhe bo Sesus zioktyhyryknaha. Tubabatu Moises Deus harere ziwatahaka Sudeutsa bo: — Kyze estuba byzoje zirahaze makuskyry nipuruk, ikiahatsa ziknapamykysokota bo siraratsa ty nyny tsimaha. Ziknapamykysokota siraratsa ty Deus okze mysiba — niy. Iwaze makuskyry je wasani niyzikzo. Tabykyhy humo tsakurẽtatsa. Iwatsahi Sose Maria iwatsa Serusarẽhe bo tahatse Deus wahoro zubata bo zibykyknaha. Iwatsahi ziknapamykysokota bo zibykyknaha. Deus bo Sesus ziwatawykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Isukzata amytudutsa petoktsa ty ziknapamykysokota bo nyny niaha. Iwaze ziknapamykysokota amytudutsa Deus okze tysiba. Tubabatu Moises Deus harere Sudeutsa bo nitsasoko: — Wytyk tapara makuskyry pepurukze. Deus makuskyry soho motsaso: “Abykyhywyzytykta, atakta metutu kabo nyny tsimy. Katsewata. Kabo metutu abykyhywyzytykta humo” mykara. Iwatsahi Sose Maria ahatsa Sesus ziknapamykysokota bo zibykyknaha. Siraratsa ziknapamykysokota bo nyny niaha. Deus harere humo amytudutsa petoktsa ty nyny niaha. Siraratsa ty nyny niahaze iwatsahi aparakbaha sihyrinymyrẽtsa, Maria wasani mozikzo — niaha. Moises Deus harere Sudeutsa bo nitsasoko: — Ziknapamykysokota bo siraratsa ty nyny tsimaha. Ziknapamykysokota Deus okze siraratsa mysiba. Taparakta bykyhy nipuruk — niy. Iwa Moises Deus harere ziwatahaka. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Aba ikia bo Simeõ soho piwatahaka. Kyze maku Simeõ inarokota. Atahi Serusarẽhe eze ziknapykyk. Tubabatu Deus harere humo nispirikpota. Deus harere bo hyỹ ziknakara. Atahi mymyoktyhyrykta piperyky. Mymyoktyhyrykta Sudeutsa bo myze sakurẽtsa moziknaha. Deus hyrikoso ituk tu hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Tapara Deus hyrikoso Simeõ pe niy. — Deus myzipehata tsipiny. Iwaze Deus myzipehata tsipinyze tu tsimyhyrikosokda — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Iwaze izotsa ibykyhy tsibik tuk Deus wahoro zubata bo inapupunahaze. Deus hyrikoso Simeõ pe: — O ikia Deus wahoro zubata bokta — niy. Ata kino Deus wahoro zubata bo nitsuk. Izotsa Deus wahoro zubata bo Sesus zibykyknaha iwatsahi Deus harere bo hyỹ niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Niytahi Simeõ Sesus ziny. Iwatahi zebykyk. Deus soho humo tsiharereziurẽta. Nitsasoko: ");
INSERT INTO rkbNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","— Abaka kakurẽta. O Deus aharere humo wasani my. Hawa atsumuẽhĩtsa pe tsiky atsatu tsikykara. Uta abaka kakurẽta tu mohyrikosokda. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Abaka zipehata mymyoktyhyrykta iny — niy. Simeõ ibykykhy soho nitsasohozo: ");
INSERT INTO rkbNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","— Atahi kytsa okzetu zipehata zumu. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Atahi haramwe hyrity wata. Hawa haramwe humo kytsa ske buruk mokozonaha. Katsa bipyritsa ahatsa niwatihi Deus ske bo mymyoktyhyrykta humo aparakbaha sihyrinymyrẽtsa. Bipyritsa bo izumu. Deus aparakbaha humo tsimypokzitsiarẽta iwatahi mybo izumu. Iwatahi zipehata bipyritsa bo niwatihi izumu. Atahi haramwe hyrity wata ahatyryktsa Sudeutsa bo zumu. Haramwe wata Sudeutsa bo iwatsahi kytsa okze ka siharereziurẽtsa moziknaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Iypyktsa ije niwatihi paikpa mytsaty nikaranaha. Hawa ha ty Simeõ ibykyhy soho nitsasoko ana humo hi nipybybaiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Niytahi Simeõ Sesus je pe niy: — Wabyty! Deus abykyhy ziny. Sudeutsa sizubarẽtsa ihumo Deus harere bo batu yhỹ zikaha. Ustsa Sudeutsa ihumo Deus harere bo hyỹ zikaha. Sizubarẽtsa ihumo ba siakparawy. Deus atakta abykyhy ziwatawy iwatsahi hawa ha ty kytsa mytsaty mykaranaha ana humo hi tsihyrinymyrẽta. Iwaze kytsa Deus humo sispihikrẽtsa ihumo jokpitsĩhĩbara. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ikia niwatihi ba asukatsihik. Abykyhy taypykze kytsa humo sinini mykara. Ikia kino niwatihi sinini tsimykara. Sinini ty sokorotsapu wata ty paskoik naha sinini tsimy — niy. Iwa Simeõ Maria bo nitsasoko. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Kyze Deus wahoro eze Deus sohokotsata niy. Atatsa Deus wahoro eze ziknapykyryk. Ana inarokotatsa. Panuweu ste. Ase astsabarẽtsa. Nitsaikbatatsa oitẽta kwatero anos. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Tubabatu ibarikta nihyrikosokda. Ata tuk mytsyhyry wa ziytyk tseheze iwaze maku nihyrikosokda iwaze atatsa hi nipytsabyri iwatatsahi Deus wahoro eze ziknapykyryk. Iwatatsahi Deus bo ziknapamykysoko. Atatsa tu ziknatadukutu Deus bo ziknasakibaziki. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Iwaze baba tu izotsa Deus wahoro zubata bo inapupunahaze atatsa kino niwatihi izumu. Iwaze Deus bo nipamykysoko: — O kazo mykurẽtsa, ikia humo kakurẽtatsa. Ikia hi myhumo tsimypokzitsiarẽta — niy. Atatsa Sudeutsa sizubarẽtsa bo nitsasoko. Deus zipehata ziperykynaha. Asahi Deus tyryktsa moziknaha. Asahi Deus zipehata ibo mysioktyhyryk. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Deus wahoro eze zipykbanahaze tahahudikhudikwy bo ziksizonaha. Sose, Maria, Sesus ahatsa, Karireja bo ziksizonaha. Nasare bo zumunaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Iwaze Sesus tsiupyhyritorykrẽta taypykyk. Tsihyrinymyrẽta. Deus tatse humo tsakurẽta nikara. Ihumo iakparawy. Iharereziuwy. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Pororo ziknakara Sose Maria iwa ahatsa Sudeutsa myikaha bo nikozorenaha. Serusarẽhe bo niukurunaha. Simyikaha bo nikozore kozorekenaha. Deus taparaktsa nisitsumuẽhĩkĩ mytsaty ziknakaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Sesus niskyrybyrize Serusarẽhe bo zioktyhyryknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Kyze simyikaha nepykze ziksizonaha. Sesus Serusarẽhe eze nitare. Iypyktsa ije ahatsa tahatse ty batu ityny. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","— O kytsa tuk ja naukuru — niaha. Batu meky watu. Bykyze zunubaze, tahatykytsa bo situktsa kino niwatihi ispe niaha: — O mytse ja Sesus sa ikiahatsa tuk — niaha. Situkytsa kino: — O batu. Katsa batu ityny — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Iwaze itynybyitsa hi Serusarẽhe bo ziksizonaha. Tahatse ziberikinaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Kyze harakykbyihi zurunahaze. Deus wahoro zubata eze ibo zumunaha. Taparaktsa baze nidyhyky. Sihyrinymyrẽnikitsa harere ziwabyky. Situk zinymyryky. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Taparaktsa tihi: — O atakta tsihyrinymyrẽta — nikaranaha. Ije iypyktsa ahatsa nipybynaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ije tihi: — O katse hawa sa tsimykara. Ikia pokzi batu myku. Botua tsikzaberikinaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Sesus tihi: — Amo sa tsimozikberikinaha Utakta kazo wahoro eze iktare. Kazo zikpehata, nawa kasopyk — my. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ipyktsa ije: — Amy skaraba — niaha. Batu sihyrinymyry. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Iwaze Sesus situk Nasare bo ziksizonaha. Zikzibyituhukutu hyỹ ispe nikara. Iwatatsahi ije tatse soho humo mytsatyziu nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Iwaze Sesus zinymyrybaba. Itaypykze tsipaikrẽta niyzik. Deus ihumo tsakurẽta. Aparakbaha niwatihi ihumo siakparawy. ");
INSERT INTO rkbNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Iwaze Deus Suão bo nitsasokoze. Tiberias Sesa Homa pehatsa niapykyryk, Põtsio Piratus Sudeja ezektsa pehatsa, Erodes Karireja ezektsa pehatsa, Piripi Itureja ezektsa pehatsa, Piripi Tarakoita ezektsa pehatsa niwatihi. Atahi Erodes tsy. Iwaze Deus Suão bo nitsaso. Anas Kajapas taparaktsa Deus wahoro eze ziknapamykysokonahatsitsa. Risania Abirene ezektsa pehatsa niy. Iwa. ");
INSERT INTO rkbNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","3","Suão Sakarias tse jerukbara eze Deus ipe niy: — Sizubarẽtsa pihik ty tysiharasusu — niy. Iwatsahi sispirikporẽtsa moziknaha. Ikiahi: — O kytsa ahasopyksapybyri tsimoewybaiknahaktsa Deus harere bo hyỹ tsimahaktsa — tsimykara. Pihik ty pahaharasusu zeka ahaspirikporẽtsa tsimoziknaha. Ikia tsipahaharasusuze kytsa mekywatsatu tsimoziknaha iwatawy. Niytahi Deus ahasopyksapybyritsa ky pahaokzohik. Iwatahi Suão buburu sak bo niukuru. Buburu Sorodão inarokota. Nanabyitaba Deus wasania ty ziknapamykysoko. ");
INSERT INTO rkbNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Taparaka Deus Isaijas bo nitsasoko. Isaijas Deus sohotsa. Deus harere Isaijas ziwatahaka: — “Maku jerukbara buruk hua mykara. Opykani mopamykysoko: ‘Pykyhytuty Deus ske bo tsimy’. Tsipiskezoze buruhuwa tsipiske. ");
INSERT INTO rkbNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Wytyk hoke taharatõtõ. Hara buruk piskezozikiknaha. Iske myiha humo tsihokdaharẽna buruhuwa tsizoziknaha. Batu iske sapy iwaze tiskeziurẽta mozik. Hawa kytsa iske pizozikiknaha nawaha Suão Deus zipehata haraze aparakbaha mysispirikpo iwatsahi kytsa Deus zipehata piperykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Aparakbaha Deus mykaraze iktsa maha. Deus bo ityryktsa mysioktyhyryk” niy. Nawa myske Deus zipehata mozumuku. ");
INSERT INTO rkbNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Kyze myzubaha Suão bo zumukunaha. Aparakbaha mysiharasusukuze. Ispe nikara: — Ikiahatsaktsa pyryhyktsa myrawy watsa — niy. Pyryhyktsa pokso tytururukiknaha. Ikiahatsa niwatihi. Aty sa ahape: — O ahasopyksapybyitsa tu tsikykaranaha iwatsahi Deus iakyriwy pokso tsimytururukiknahaktsa — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Aba ikiahatsa Deus harere bo hyỹ tahaktsa. Kytsa bo batu ahamyi tsihikik tsipiwatawynaha. Aparakbaha tsiwatawynahaktsa. Ikiahatsa mytsaty ahabyitsa tsimykaranaha: — O Abarão taparakta mydiri. Iwatahi Deus myhumo bazik takyri — tsimaha. Batu ba. Ikiahatsa tihi: — Katsa zuba myhyrizikwani — tsimaha. — Ikiahatsa batu ahahyrinymyry. Deus haraharetsa tuk Abarão tsekokatsa mysisukni ziky. ");
INSERT INTO rkbNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ikiahatsa wiharatatsa, aba botu wywyk zizowy. Iharatatsa buruk mysikakarenahaze. Hwi iharasapybyita tu izo bo pioktsokik — nikara. Hawa kytsa hwi isapybyitakta piwenaha nawa aty imysapybyikitsa tu mykara sinini ykarawy bo pipehaka. ");
INSERT INTO rkbNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Iwatsahi parakbaha ipe niaha: — Hawa skaraba tsimaha — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Iwaze ispe niy: — Aty petok suk zeka estuba nynyty isukbyita bo. Aty idisahawykyta zeka disahawybyita bo nynyty — nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Asaktsa ispehatsa tsyhyryze okyrysarobyktsitsa izumunahaze — O tymyharasusukta! — Suão pe nikaranaha: — O myhyrinymyrykytsa! Hawa skaraba tsimaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Suão tihi: — Okyrysaro ahapehakatsa ahape maha atsatu tsipiaksenaha. Ana ty zuba wabehyryk tsimaha! niy. Batu amy tohi tsimaha — nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Sodadutsa niwatihi ipe niaha: — Hawa skaraba katsa kino tsimaha — niaha. Suão tihi: — Batu kytsa okyrysaro ty ka okok okok byitaha ikiahatsaktsa ahapaikrẽtsa humo batu tsiaksenaha. Ahakyriukrẽtsaktsa paik paik byitaha. Sipybyrẽtsa ikiahatsa pokso batu okyrysaro zebyknaha. Batu okyrysaro humo mybarapetu tsimaha. Ahapehatsa okyrysaro ty ahabo nyny my. Anahumo hi ahakurẽtsa tynakaranaha — nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Niytahi aparakbaha batu sihyrinymyry. Suão harere humo. Sihyrinymyrybyitsa tu nikaranaha: — Aty skaraba Suão, Suão Deus zipehata ja. Tozeka ja Kiristu — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Suão aparakbaha pe nikara: — Utakta pihik ty zuba pahaharasusuku. Usta mozumuta. Atahi tsimysapyrẽta myhyrizikwani. Utakta batu. Ipyrysuktsa mysibokik zeka kasikpybyrẽta. Utakta pihik ty zuba aparakbaha mysiharasusuku. Atakta maku hi Kiristu Deus zipehata Deus hyrikoso ahabo mynasik myzipeha. Deus hyrikoso rika wata ahabo mynasik. Hawa miwa rika humo amypubyri nawa Deus hyrikoso humo tsimysapyrẽna ty zuba pahahyrinymyry myspirikporẽtsa tsimoziknaha. Deus hyrikoso mynasikze ikiahatsa tuk mynapykyryk. ");
INSERT INTO rkbNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Kiristu mozumuze maku dua ty wabe mozikta wata. Mektsaktsa ispawaha pipapara. Siriktsa mysizozekeze ispa zipaparakanaha. Anawahi Kiristu aparakbaha metutu my. Izo bo mysisapywy. Asaktsa simysapybyitsaktsa sinini ykarawy bo mysipehahik. Anaeze izo ba zikbe naha byikia bo. Ustsaktsa simysapyrẽtsaktsa ituk tahawahi mynapykyryknaha. Iwa aparakbaha metutu mykara — Suão niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Kyze Suão niukuru, wasania ty aparakbaha bo nipamykysoko. Niukuruze wasania ty kytsa bo nipamykysoko. ");
INSERT INTO rkbNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Iwaze Erodes sipehakatsa Karireja eze zikniapykyryk. Suão tsipa humo tyzioktyhyk. Sakyriukrẽnikitsa hurukwy bo motsahuruk tsihikik. Nezeba Suão Erodes zipehaka. Erodias soho nitsasoko: Suão ipe niy: — Ikia atsy oke tsioktyhyryk batu iktsa zuba ziky. Ikia batu amysapy. Usa amysapybara ty tsikykara — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Erodes zisapybyikik nikara. Aba usta imysapybara ty niy. Suão sakyriukrẽnikitsa hurukwy bo zipehahik niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Kyze Suão aparakbaha nisiharasusubaze Sesus ibo izumu ipe niy: — Tsikarasusukta — niy. Iwaze Suão Sesus hi ziharasusu. Sesus Deus bo nipamykysokoze bijoikpe sakpare niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Deus hyrikoso inasik. Deus hyrikoso amytudu hyrity wata inasik. Amytudu ipapyry bete inazo. Iaksoho bijoikpe iknyky ziwaby: — Ikiakta katse baba tahi. Ikia humo kamypokzitsiarẽta. Ikia humo kakurẽta — niy. Iwa Deus Sesus pe niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Sesus kino taypykze tirĩta anos Deus soho ty sizubarẽtsa nisihyrinymyryky. Iwaze Deus hyriziktsokzawy humo ziakbataze. Aparakbaha nipamykysokonaha: ");
INSERT INTO rkbNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","— O atakta Sose tse ja — nikaranaha. Batu ba Deus tse babata zuba. Sose ta Eri tse niy. Eri ta Matate tse. Matate ta Rewi tse. Rewi ta Meki tse. Meki ta Sanai tse. Sanai ta Sose tse. Sose ta Matatias tse. ");
INSERT INTO rkbNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Matatias ta Amos tse. Amos ta Naũ tse. Naũ ta Esri tse. Esri ta Nakai tse. ");
INSERT INTO rkbNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nakai ta Marate tse. Marate ta Matatias tse. Matatias ta Semei tse. Semei ta Sose tse. Sose ta Soda tse. ");
INSERT INTO rkbNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Soda ta Soana tse. Soana ta Resa tse. Resa ta Sorababeu tse. Sorobabeu ta Sarateu tse. Sarateu ta Neri tse. ");
INSERT INTO rkbNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri ta Mereki tse. Mereki ta Adi tse. Adi ta Kosã tse. Kosã ta Emadã tse. Emadã ta Er tse. ");
INSERT INTO rkbNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er ta Sosue tse. Sosue ta Eriesa tse. Eriesa ta Sorĩ tse. Sorĩ ta Matate tse. Matate ta Rewi tse. ");
INSERT INTO rkbNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Rewi ta Simeõ tse. Simeõ ta Suda tse. Suda ta Sose tse. Sose ta Sona tse. Sona ta Eriakĩ tse. ");
INSERT INTO rkbNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eriakĩ ta Merija tse. Merija ta Mena tse. Mena ta Matata tse. Matata ta Natã tse. Natã ta Dawi tse. ");
INSERT INTO rkbNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dawi ta Sese tse. Sese ta Obede tse. Obede ta Boas tse. Boas ta Saro tse. Saro ta Nasõ tse. ");
INSERT INTO rkbNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasõ ta Aminadabe tse. Aminadabe ta Ami tse. Ami ta Esrõ tse. Esrõ ta Peres tse. Peres ta Suda tse. ");
INSERT INTO rkbNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Suda ta Sako tse. Sako ta Isake tse. Isake ta Abarão tse. Abarão ta Tera tse. Tera ta Nako tse. Nako ta Seruke tse. ");
INSERT INTO rkbNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Seruke ta Rakau tse. Rakau ta Pareke tse. Pareke ta Ebe tse. Ebe ta Sara tse. ");
INSERT INTO rkbNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sara ta Kaina tse. Kaina ta Arapakasade tse. Arapakasade ta Sẽ tse. Sẽ ta Noe tse. Noe ta Rameke tse. ");
INSERT INTO rkbNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Rameke ta Metuserẽ tse. Metuserẽ ta Enoke tse. ");
INSERT INTO rkbNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Enoke ta Sarete tse. Sarete ta Marereu tse. Marereu ta Kaina tse. Kaina ta Enos tse. Enos ta Ses tse. Ses ta Adão tse. Adão ta Deus tse. Iwa niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Sesus tuk Deus hyrikoso ziknapykyryk iwatatu buburu Sorodão inarokota bo ziksizo. Ziksizoze Deus hyrikoso jerukbara bo zioktyhyryk. Anaeze hyrikoso sapybara pehatsa Sesus bo zumuku. Diabo inarokota niy. Sesus bo izumuze atahi Sesus Deus harere bo ka yhỹ yhỹ byitykta ana nizihikik. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Sesus iharere humo batu yhỹ niy. Iwa estuba byzoje zirahaze Sesus hauk ahabyitatu niapykyryk. Byzoje estuba zirahaze irapa izumu. Hauk ahabyitatu zikzurukutahi irapa izumu. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Iwaze Diabo ipe niy: — Ikia Deus tse tihi zeka ta harahare pe. “Atsikara tuziktykta” — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Batu Sesus niy. Tubabatu taparaktsa Deus harere papeu humo ziwatahakanaha: — Kytsa batu mydisahawy humo zuba mozurukunaha. Sizubarẽtsa disahawy hauk maha zeka sispitu zuba mykaranaha. Sizubarẽtsa Deus harere bo hyỹ maha zeka sakurẽtsa moziknaha. Sakurẽtsa — niaha. Iwa taparaktsa ziwatahakanaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Iwaze Diabo Sesus hara joboni tabo zioktyhyryk. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ipe niyzo: — Nanabyi bo iktsa tykta — niy. Atsoko mybarawy tsizubarẽna nizokparaka. Aidy sityryktsa tuze niwatihi natakaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Diabo kino: — Uta anaty abo nynybaik my. Ikia hi sipehakatsa tsimozik. Sityryktsa ikia sopyk abazubata maha. Ikia asoho mynatsasokonaha “Atakta tsimysapyrẽta” mynakaranaha. Aba uta kapitão mybarawy ezekta myzubaha katyryktsa. Aty kakparawy zeka ibo mybarawy ty nyny my. Ikia kaokeryk aekaratsa humo puruk puruk zuba tsimy zeka kabo tsimytsaso zeka, “Ikia tsamysapyrẽta” iwa tsimy zeka mybarawy ty abo nyny my. Anamy mozik — niy. Iwa Diabo Sesus pe nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Sesus: Batu niy. Tubabatu taparaktsa papeu iwatahaha humo. Deus harere ziwatahakanaha tihi: — Deus bo zuba tynapamykysokonaha “Ikia tsamysapyrẽta”. Ata kino zipehakaze ikiahatsa iharere humo zuba hyỹ tsimykaranaha — ziwatahakanaha. Iwa de. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Iwaze Diabo Sesus bo izumuzo. Diabo Serusarẽhe bo Sesus zioktyhyryk. Anaeze Deus wahoro zubata hara bete ziriktohohikare. Joboniha bo zioktyhyryk. Niytahi ipe niy: — Ikia Deus tse tihi zeka nabo wytyk bo tukutyny. Tyk bo tynapurukta! Taparaktsa wataha: ");
INSERT INTO rkbNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","“Bijoikpe iknyktsitsa Deus tsumuẽhĩtsitsa ikia bo mynasipeha. Paperykynaha. Ikia humo simypokzitsiukrẽtsa” niaha. Ziwatahakanahazo. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","“Haraharetsa bete tsimynaraha zeka bijoikpe iknyktsa aty paik maha. Iwatahi ba zikahyrikywy” niaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Sesus: Batu niy. — Tubabatu taparaktsa Deus harere ziwatahakanaha. “Deus ta ba ziakzobyrinaha”. Hawa ha ty ikia tsimyzihikik Deus bo batu tsizipeha. Iwa taparaktsa ziwatahakanaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Iwaze Diabo Sesus bo imysapybyikia ty zipehaka. Sesus iharere humo batu yhỹ niy. Diabo nipamykysobaze zerekekspyk. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Sesus Karireja bo ziksizo. Deus hyrikoso ituk ziknapykyk. Myzubaha paikpa isoho ziknatsasokonaha. Isohowy ziwabybanaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Sesus Deus wahoro eze ziakbataze nisihyrinymyryky. Myzubaha iharere siakparawy. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Kyze Sesus Nasare bo ziksizo. Anaeze itaypyk. Iwaze mybyrykywy eze Sesus Deus wahoro bo pororo ziknakara. Deus wahoro bo nitsuk. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Niytahi ziknapamykysokota perytsa Deus harere ty papeu ty Sesus bo nyny niy. Iwaze kyik niy. Deus harere iwatahaha nitsasoko. Opykani haty nikara, sizubarẽtsa ziwabykynaha. Tubabatu Deus harere Isaijas ziwatahaka. Isaijas Deus sohokotsa Sesus papeu ty zoksapare niy. Niytahi papeu zikaha. Iwatahaha: ");
INSERT INTO rkbNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","— Deus hyrikoso katuk mynapykyryk. Iwatahi uta sinamybyitsa bo zikpeha. Sinamybyitsa bo wasaniha motsasoko. Sihurukuhutsa bo zikpeha. Tysisapare. Sihyrizikubyitsa bo zikpeha. Tysizororowyta! Iwaze mokozozonaha. Sipokzitsiukbyikitsa bo zikpeha. Ahapybywytsitsa bo aidy pãotaha! ");
INSERT INTO rkbNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Uta sizubarẽtsa bo zikpeha. Ispe my “Deus tsimysapyrẽta. Myzubaha mysisapywyky. Sitsyhyryze Deus bo maha”. Iwa papeu humo ziwatahakanaha. Abaka iharere wasani mykara — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Sesus iwatahaha opykani haty nikara. Papeu zihokbohik, iperykytsa bo nynyrezo niy. Iwaze dyhyzo niy. Kytsa Deus wahoro eze nidyhydyhykynahatsa nikozotoktokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Iwaze ispe niy: — Isaijas Deus harere ziwatahaka. Jabasykyri tsiwabykynaha. Abaka iwahi mykara — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Sizubarẽtsa Deus wahoro eze ziwabykynahaze, Sesus humo siharereziurẽtsa. Iharere siakparawy. Ziwabykynahaze ihumo sipybyrẽtsa. Iwatsahi asa zuba nipamykysokonaha: ");
INSERT INTO rkbNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","— Aty skaraba Sose tse ja — nikaranaha. Sesus ispe niy: — Tozeka ja ikiahatsa hi aharere tsimytsasokonaha “O mozororowykytsa ikia arahwiwy tsiku!” Amy ty ikia tsikykara botu tsiwabynaha hỹ. Kaparanaũ eze tuze ikia soho botu tsiwabynaha hỹ. Aba atsatu ahudikhudikwy eze tu tsimy. Ikia ahudikhudikwy eze niwatihikta kabo tsimy — nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Uta ikiahatsa pe: — Hawa motsasoko wasani mykara. Deus sohokotsa tahahudikhudikwy eze tu zeka batu wasani sisopyk. Wasani habyitsa tu kytsa batu siakparawy — niy. Wasani mykarazo. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","— Tubabatu Isareu eze hyritsikbyrize. Hyritsik baratu harakykbyi niytyk tseheze. Sirapa izumu. Iwaze Deus Erias haramukuka bo zipeha. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Atatsa Sarepata eze niapykyryk. Sidõ eze niapykyryk. Atatsa Sudeubyitatsa. Bipyri. Erias Deus sohokotsa atatsa bo zipeha. Haramukukaka sizubarẽza Isareu eze. Deus Erias zipeha haramukuka bipyri bo — Sesus nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","— Tubabatu Eriseu niwatihi Deus sohokotsa Isareu eze tu. Nama takõrõrõtsa ty nibibibakata. Sizubarẽtsa Isareu eze nibibibakanahatsitsa. Eriseu batu isty zororowy. Nama zuba zizororowy. Nama bipyri zuba — Sesus nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ana ziwabykynahaze kytsa Deus wahoro eze tahasakanikinaha. Tahakyrikinaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Inakyikyikbaiknaha, Sesus itsipa humo zioktyhyryknaha. Zikyrikinaha tahahudikhudikwy ekze zioktyhyryknaha. Tahahudikhudikwy hara bete nikaranaha. Hara joboni tabo zioktyhyryknaha. Iharatsupetowy bo tapetohikta nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Batu zikaha. Sesus sitazahara buruk niukuru. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Sesus Kaparanaũ bo niukuru. Kaparanaũ Karireja eze ky. Anaeze Sudeutsa zinymyrykynahatsa wahoro bo nitsuk. Anaeze kytsa nisispirikpoko. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Mybyrykywy eze Deus wahoro eze nisispirikpoko. Paikpa iktsa nikaranaha: — O wasani nikara. Tsihyrinymyrẽta babata — nikaranaha. Sesus humo sispirikporẽtsa. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Anaeze estuba maku ata bo hi hyrikoso sapybara pororo ziknakaranaha. Sesus bo iktsa niyze ibo huahua niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Nipukaraka: — Hawa sa myty tsimy Sesus Nasare ezekta. Amy bo sa tsikzumu. Tsimymyiksiwyhik tsihikik sa. Ikia soho humo kahyrinymyrẽta. Ikia Deus zapehata — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Sesus hyrikoso sapybara zipeha: — Aksobyity! Nabo pãoty — niy. Maku wytyk bo inaraha. Hyrikoso sapybara humo kytsa okze tu inaraha. Batu nabaze taty hyrikywy ahabyita. Sesus harere humo ziponaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Iwatsahi kytsa sizubarẽtsa ibaze tu nikozotoktokozonaha: — O amy skaraba Sesus hyrikoso sapybara pe: “Nabo pãotaha” myze hyỹ sisopyk — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Iwaze nanabyitaba Sesus soho ziwabykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Sesus kyikyk niy. Deus wahoro ekze izoik. Iwaze Simaõ wahoro bo nitsuk. Anaeze Simaõ wapyry niapykyryk. Atatsa ityrykani ihumuẽzumu. Wahoro ezektsa Sesus bo nitsasokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Niytahi Sesus iwanu baze rikto niy. Ityryk ykzo pe niy. Iwaze ityrykani ihumuẽzumu iwatatsa tu mahani. Iwaze atsoko kyik niy, kytsa nisidisahawyky. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Iwaze zunabazoze sizubarẽtsa ituktsa simyitsapyritsa Sesus bo nasioktykynaha. Nanabyi nazukmuwykynahatsa Sesus bo nisioktykynaha. Iwaze simyitsapyritsa tatsyhyrypetsa ty sihumo paik nikaranahaze nisizororowybaik. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Hyrikoso sapybara kino niwatihi nisiksiwyhik. Asa kino kytsa ekze nisiksiwyhikze huahua niaha: — Ikiakta Deus tse hi. Deus pehaha hi — niaha. Iwatahi Sesus hyrikoso sapybara nisibetsakik: — Ahakso byitaha! — niy. Sihyrinymyrytsa Sesus hi Deus tse babata. Sesus Deus pehaha sihyrinymyrẽtsa iwatahi anatyhi — batu tyso — niy. Iwaze Sesus harere humo niaksohobyrinaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Iwaze inakyokze Sesus nio. Atazuba jerukbara bo niukuru. Kytsa sizubarẽtsa Sesus ziberikinaha. Zihobyknahaze ipe niaha: — Amo sa tsipiksikiri, mytuk tutarekta — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Sesus ispe niy: — Batu zik. Aba utakta ustsa hudikhudikwy ezektsa bo Deus harere humo mysispirikpo. Iwatahi ikzumu — niy. Deus soho ty mysispirikpo. Deus tyryktsa moziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Sudeutsa zinymyrykynahatsa wahoro bo anabo wasania ty nipamykysoko. Nanabyitaba ziknapamykysoko. ");
INSERT INTO rkbNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Sesus zitsikpaparaknahatsa bo zumu. Asahi pinymyrynahatsa. Kyze Sesus pihikzotsabyri sak eze niriktohoko. Kenasere pihikzotsabyri inarokota. Myzubaha harape baze tu niriktotohokonaha. Zihyrizabaiknaha. Deus harere ziwabykynaha. Sesus Deus harere humo nisispirikpoko. Sizubarẽtsa ziwabykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Iwaze petoktsa tsarahatsa bo nikozo. Tsarahatsa nimyra eze niapykyknaha. Zitsikpaparakanahatsa botu ziponaha. Niahatsahi tahatõhõryk nitsapikiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Sesus Simaõ tsaraha bo takoro. Ipe niy: — Nabo pihik itsikpukte tohi bo zuk tykta! — niy. Yhỹ niy. Niytahi tsaraha eze dyhy niy. Sizubarẽtsa tsaraha eze tu nisispirikpoko. ");
INSERT INTO rkbNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Iwaze nisispirikpobaze Simaõ pe niy: — Tsaraha ty nabo maporik bo zoktykta! Anabo ahatõhõryk ty tsioktsoktsokzonahaktsa kytsa! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","— O myhyrinymyrykytsa katsa dik botu tsitsikpaparakanaha. Unata batu istyzo. Iwatsatuza ikia harere zehita hyỹ my. Mytõhõryk taoktsotsokokzo — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Iwaze Peduru tuktsa piknutsazokowy pihik bo zioktsotsokzonaha. Piknutsa estuba zubabyitsa nasizokonaha. Tõhõryk piknutsa inahareknaha, piknutsa humo asiba niaktsawakba. ");
INSERT INTO rkbNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Tahatõhõryk asiba zitsawakbanaha tahatuktsa bo huahua niaha. Tahatuktsa usta tsaraha ezektsa bo hua nikaranaha. — Pany. Aidytahaktsa. Nawazekta! Tymytsumuẽhĩnaha — niaha. Izumunahaze tsarahatsa petoktsa piknutsa ty inasihareknaha. Piknutsa tsakyrik ty asiba nitaboknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Anabo Simaõ Peduru nikozoze Sesus okeryk taekaratsa humo puruk puruk niy. Sesus humo ispirikporẽta hi iwatahi taekaratsa humo puruk puruk niy. Ipe niy: — O ikiakta ẽryktohitu ziktotykta. Uta kamysapybyita mykara — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Nipybybaiknaha. Piknutsa bo paikpa iktsa nikaranaha. Iwa kytsa kino niwatihi nipybybaiknaha. Piknutsa bo paikpa iktsa nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Tsiaku, itsy Suão ahatsa Sebedeu hyrytsa piknutsa estuba zubabyitsa humo nipybybaiknaha. Sesus ispe niy: — Ahapyby byihu ja! Tapara zikzitsikpaparakanahaze piknutsa ziknasizokonaha. Abaka ikiahatsa katuk mektsa ty tysitsumuẽhĩnaha. Kytsa bo Deus soho tynatsasokonaha. Ahaharere humo ka sizubarẽtsa Deus harere bo hyỹ maha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Iwaze tahatsaraha ty bybybyuhikare niaha. Tahatõhõryk zerekbaiknaha. Tahanamy kino niwatihi zerekbaiknaha. Iwaze Sesus hapik niukurunaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nakõrõrõbaikta asiba nibibibata tu zizororowy. Kyze Sesus hudikhudikwy eze tuze maku ibo izumu. Nakõrõrõbaikta. Atahi Sesus okeryk wytyk bo inaraha. Sesus humo tispirikporẽta iwatahi inaraha. Wytyk bo hok bohyk ahata inaraha iwaze ipe: — O tsahyrinymyrynikita, tsipitsihikik zeka tsipikzorowy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Sesus ihumo paik niy. Ikia pe — Yhỹ my. Uta pazororowykta — niy. Atsoko iakõrõrõtsa nihokdanaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Iwatahi Sesus ipe niy: — Sasabyitsa bo kaja sosobyity. Aba ikia Deus wahoro ezekta bo tsipawatawy! Hawa taparakta Moises papeu humo ziwatahaka atsatu ikia Deus bo nyny tsimy. Iwaze sizubarẽtsa azororowy piwabynaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Iwatatu Sesus maku pe — Sosobyity. — Nanabyitaba Sesus soho nitsasoko. Iwatsahi kytsa Sesus bo zumunaha ziwabykynaha. Simyitsapyritsa kino niwatihi ziknasizororowyky. ");
INSERT INTO rkbNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Sesus kino jerukbara bo atazuba niparak. Anaeze Deus bo nipamykysoko. ");
INSERT INTO rkbNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Kyze Sesus nisispirikpoko. Sizubarẽtsa ibo zumunaha. Pariseutsa, Moises harere ty nisihyrinymyrykynahatsa iwatsa zumunaha. Karireja iknyktsa, Sudeja iknyktsa, Serusarẽhe iknyktsa sizubarẽtsa iwatsa izumubanaha. Deus zikwy Sesus tuk ziknapykyryk. Iwatahi simyitsapyritsa nisizororowyky. ");
INSERT INTO rkbNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Kyze kytsa ityryk niakbabata zebykyknaha. Iwanu bete tu Sesus bo zebyk tsihikiknaha. Sesus bo ityryk niakbata zihoek tsihikiknaha. Batu dik. ");
INSERT INTO rkbNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Wahoro inahareknaha. Iwatsahi ityryk niakbabata tatuk batu paku niaha. Sizubarẽtsa humo batu paku aha. Iwatsahi wahoro hara bo zidokoronaha. Iziwy zipeksykiknahaze ityryk niakbabata wanu bete inaripiknaha. Sesus okeryk kytsa tazahara bo inaripiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Iwaze Sesus iharereziuwytsitsa pe niy: — O kytsa “Sesus myhumo tsimypokzitsiukrẽta” tsimaha. Iwatahi ikiahatsa humo kakurẽta — niy. Iwaze ityryk niakbabata pe niy: — O ikia tihi “Kasapybyita Deus humo batu yhỹ mykara” tsimy. Iwatatu paokzohik. Amysapybyita tu tsimykara tatu paokzohik inakokozo — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Iwaze Pariseutsa, Moises harere humo zinymyrykynahatsitsa niwatihi mytsatyziu nikaranaha. Sesus harere humo tahakyrikinaha. — Amy skaraba. Hawa sa nitsasoko. Deus zuba mymyokzohik. Ata zuba isapybara ty piokzo mykara — mytsaty nikaranaha. Kytsa iwa mytsaty nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","23","Sesus tsihyrinymyrẽta tu iwaze ispe niy: — O hawa skaraba kytsa. Iwahatu pahaokzohik my zeka tsihokdaharẽna. Batu zikozonaha. Uta kyiktykta my zeka ana humo kino tsihokdaharẽna. Nizororoze kazikwybaba humo ahahyrinymyrẽtsa. Iwatu utakta wyzik niwatihi my — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ityryk niakbabata pe niy: — O uta ape “kyiktykta! Awanu ty pohyrykty! Tsiksikta” — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Atsoko inatarikto. Iwaze tawanu ty kokpuhyryk niy. Tawahoro bo ziksi. Deus bo nisakibaziki: — O ikia humo ka kakurẽta. Ikia hi tsikzororowy — nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Sizubarẽtsa zinynahaze nipybybaiknaha. Deus bo nipamykysokonaha: — O Deus ikia humo ka mykurẽtsa. Niwa ha ty ka katsa batu tyny — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kyze Sesus niparak. Maku pehatsa tsyhyryze siokyrysarobykyktsa bo iktsa niy. Rewi inarokota. Siokyrysarobykwy sapy eze nidyhyky. Iwaze Sesus: — Pany kapikta! — niy. Hyỹ niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Kyikyk niy. Tanamy ka zerekbaik. Iapik niparak. ");
INSERT INTO rkbNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Niytahi Rewi tawahoro eze tamyikahaka. Kytsa siokyrysarobykyktsa sizubarẽtsa, ustsa kino niwatihi, ituk tahadisahakanaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pariseutsa, Moises harere soho humo sihyrinymyrẽtsa kino niwatihi tahakyrikinaha. Asahi zinymyrykynahatsa nisibetsakaknaha: — Hawa skaraba — tsikykaranaha. — Ikiahatsa siokyrysarobykyktsa tuk tsipahadisahakanaha. Ikiahatsa simysapybyitsa tuk tsipahadisahakanaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Iwaze Sesus ispe niy: — Simysapybyitsa simyitsapyritsa watsa. Sakurẽtsaktsa mozororowykytsa bo ba zikumunaha. Simyitsapyritsa zuba mozororowykytsa bo pomonaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Iwatahi ikzumu simysapyrẽtsa bo ka ba. Utakta simysapybyikitsa bo hi ikzumu iwaze simysapybyitsa kahumo simysapyrẽtsa moziknaha. Iwaze imysapybyri pimoewynaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Niahatsahi nipamykysokozonaha: — Suão Batista tuk zinymyrykynahatsa hauk ahabyitsa ziknakaranaha. Iwaze Deus bo ziknapamykysokonaha. Pariseutsa tuk zinymyrykynahatsa kino niwatihi hauk ahabyitsa ziknakaranaha. Ikia tuk zinymyrykynahatsa batu. Asa hi mynatahadisahakanaha mozikukunaha niwatihi. Amy humo sa atuk zinymyrykynahatsa tahadisahakanaha — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Sesus ispe niy: — Maku tasukzaze tatuktsa tuk tamyikaha niy. Tumy mytakuku. Tahadisahakanaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","— Iwaze isukzata myserekze kytsa batu siaku iwaze hauk ahabyitsa mykaranaha. Iwaze utakta kazo bo myziksizoze zinymyrykynahatsa batu siaku iwaze hauk ahabyitsa mykaranaha — niy. Iwaze Sesus Pariseutsa bo nitsasoko, myzuwy soho nitsasoko. ");
INSERT INTO rkbNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Niytahi Sesus nipamykysokozo. Panu soho humo ziwatawyky. Iwa nisihyrinymyryky. Sesus tihi: — Ba aty tohi panu ezytyk ty zizyzyka, isuk ibyky myzutsuku. Iwa my zeka isuk mysykbaik. Panu ibykta tu ezytyk humo mymyibaik — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nipamykysokozo. — Kyze ba aty tohi duabohotsa tsik ezytyk ty siraratsa hwyk ibykta bo pisusu iwa my zeka duabohotsa tsik ezytyk mynapytoze ibykta tsasuk mytok mypokbaik — niy. Duabohotsa tsik tsasuk ibykta bo susu tsimy zeka pimyibaik. ");
INSERT INTO rkbNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Duabohotsa tsik taweba. Duabohotsa tsik ezytyk tsasuk ezytyk eze tu tsipisusu eze ka. ");
INSERT INTO rkbNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Iwaze duabohotsa tsik isuk kino tisapyrẽna maha. Bykyze atahi duabohotsa tsik ezytyk batu iakparawy. Asahi: — O duabohotsa tsik ziperyky jokboha niy — nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sudeutsa byrykywyze zinymyrykynahatsa Sesus tuk waratok buruk niukurunaha. Zinymyrykynahatsa tirikotsa inasibakanaha nisityhyktyhykyknaha iwaze nisiborokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Pariseutsa nipamykysokonaha: — Amy skaraba niwa tsimykaranaha. Nawa zuruze mybyrykywyze katsaktsa batu tarabaja mysopyk — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Sesus ispe niy: — Ikiahatsa batu ahahyrinymyry Dawi soho ziwatahaka. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Taparakta Dawi itukytsa taharapaspykze hawa nikaranaha. Deus wahoro bo nitsuk. Atsikara zibykyknaha. Atsikara Deus bo nyny niy ana hi ziokok. Iwaze itukytsa kino niwatihi ziokoknaha. Atsikara humo Deus wahoro eze ziknapamykysokonahatsa zuba zikziokoknaha. Kytsaktsa batu zikaha. Anaka papeu Dawi soho batu ahahyrinymyry ja — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","— Utakta Deus zikpehata ikiahatsa wata. Uta hi mybyrykywy tsihitsa niwatihi my. Uta zuba mybyrykywy eze pipehaka. Myzubaha kaharere bo yhỹ maha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Kyze Sesus itsyhyrype noikta zizororowy. Usta mybyrykywyze Sesus Deus wahoro bo nitsuk. Anaeze nisispirikpoko. Atsokyka itsyhyrype noikta bo iktsa niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Kytsa taparaktsa zinymyrykynahatsitsa, Pariseutsa kino niwatihi Sesus bo iktsaziu nikaranaha. Ibo nikozotoktokonaha: — O mybyrykywyze hawa pizororowy ja — nikaranaha. Hawa Deus sohokotsa botu ziwatahakanahatsa siharere bo ka Sesus batu yhỹ my nizihikiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Sesus tsihyrinymyrẽta. Hawa taparaktsa mytsaty nikaranaha, Sesus zinymyry. Iwaze Sesus itsyhyrype noikta pe niy: — Kyiktykta! Mytazahara eze riktotykta — niy. Itsyhyrype noikta atsoko kytsa tazahara eze tarikto. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Niytahi Sesus taparaktsa nispehaka: — Utakta ikiahatsa pehatsa. Hawa skaraba mybyrykywy eze ahasopyk. Mybyrykywy wasani ja tsipisapyky zeka, yhỹ tsimaha. Mybyrykywy eze hawa ja tsipisapybyri zeka wasani ja tsimaha. Mybyrykywy eze kytsa hawa ja tsipitsumuẽhĩkĩ zeka, yhỹ tsimaha. Mybyrykywy eze kytsa hawa ja tsipimyiwy zeka wasani ja tsimaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Sesus sizubatsa bo iktsaziu niy. Iwaze itsyhyrype noikta pe niy: — Atsipa ty kabo nynyty! — niy. Maku tatsipa ty nyny niy. Iwaze nizororohik. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Iwatsahi kytsa Sesus humo tahakyrikinaha. Iharere ziwabykynahaze asa zuba nipamykysokonaha: — Hawa sa Sesus ty tsimaha tabezehik sa — nikaranaha. Iwa ihumo tahakyrikinahatsa nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Kyze Sesus hara bo nido. Unata Deus bo nipamykysoko. Inakyokze Sesus tuk zinymyrykynahatsa bo nisiwatawyky. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Zinymyrykynahatsa sizubarẽtsa dose ahatsa bo. Sesus kino nisiwatawyky. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ituk zinymyrykynahatsa: Simaõ ta Peduru ty zinaroko, itsy Ãdere kino niwatihi. Tsiaku, Suão Tsiaku tsy. Piripi, Baratoromeu, ");
INSERT INTO rkbNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateus, Tome, usta Tsiaku Arapeu tse, ");
INSERT INTO rkbNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Tadeu, Simaõ, bipyritsa batu iakparawy Sudas usta Iskariotses inarokota iwatsa, Sesus watawyhytsa. Aibani Sudas Iskariotses Sesus humo isopyksapybyita nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Sesus hara zikarape bo zinymyrykynahatsa tuk nisik. Amytsĩ eze pykpyk niaha. Iwaze sizubarẽtsa Sesus bo izumunaha. Sizubarẽtsa ituk niukurunahatsitsa Sesus bo izumunaha. Sudeja ezektsa, Serusarẽhe ezektsa, Tiro ezektsa, Sidõ ezektsa, iwatsa izumukunaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Nanabyi ezektsa izumukunaha. Sesus harere ziwaby tsihikiknaha. Nizororo tsihikiknaha iwatsahi izumukunaha. Mektsaktsa hyrikosotsa sapybaratsa situktsa izumukunaha asahi Sesus nisiksiwyhik. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Myzubaha Sesus zibyby tsihikiknaha. Iwatsahi Sesus zikwy humo nizororokonaha. Deus harere humo nisizororoko. Sesus zikwy humo nisizororowyky. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Sesus tuk zinymyrykynahatsa bo iktsaziu niy. Sakurẽnikitsa soho nitsasoko ispe niy: — Ahakurẽtsaktsa ikiahatsa batu amy tohi tsimaha. Ahanamybyitsa Deus tyryktsa tsimoziknaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","— Ahakurẽtsaktsa abaka aharaparẽtsa. Bykyze ikiahatsa ahadisahawynikitsa tsimaha — niy. — Ahakurẽtsaktsa ikiahatsa abaka tsimopukarakanaha ahamysapybyri humo tsikykaranaha iwaze hi bykyze hazi tsimykaranaha kawatsa tsimoziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ahakurẽtsaktsa kytsa ikiahatsa humo tahakyrikinahaze ahape: “Nabo pãotaha!” mykaranaha. Katuktsa humo takyrikinaha. Iwaze ikiahatsa Deus tyryktsa tsimoziknaha. Siharerewabymybarẽtsa, ahaharere pisapybyrikinaha zeka ahakurẽtsaktsa! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","— Ahakurẽtsaktsa, kytsa mymysapybyrikinahaze ikiahatsa soho humo ahakurẽtsa tsimoziknaha. Ahayzikrẽtsaktsa! Deus tukze ahanamy tsizubarẽna tsimaha. Tubabatu taparaktsa iwa Deus sohokotsa sisopyk niaha. Deus sohokotsa atsatu sisopyk — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Niytahi Sesus sinamynikitsa bo nipamykysokozo. Sininiwy soho nitsasoko. — O ahawahi sinini tsimynakaranaha. Aba ahanamyrẽtsa. Tapara tu ahayzikrẽtsa tsimykaranaha. Ahanamy mopykze sinini tsimykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","O ahawahi sinini tsimynakaranaha. Abaka ahadisahawyrẽtsa. Ahadisahawy bo zuba mytsaty tsimykaranaha zeka sinini tsimykaranaha. Bykyzehu aharapa zeka tsimopuziukunaha. O ahawahi sinini tsimynakaranaha abaka ahayzikrẽtsa, bykyze ahamysapybyri humo mytsaty tsimykaranahaze ana humo hi sinini tsimynakaranaha. Tsimypukarakanaha. O ahawahi sinini tsimynakaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Sizubarẽtsa nanabyitaba ikiahatsa humo siharereziurẽtsa. Iwaze taparaktsa Deus sohobyitsa tu siharereziurẽtsa. Kytsa “Katsaktsa Deus sohokotsa” mybarapetu ziknakaranaha. Asatu kytsa ziknataharereziu tsihikiknaha. Iwaze sizubarẽtsa ahahumo siharereziurẽtsa pykyhytutaha ikiahatsa siwatsa tsimaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Kaharere tsipiwabykynahatsitsa. Uta ikiahatsa pe my: — Ahasukyrytsitsa tysipokzitsinaha! Ahasukyrytsitsa tysisapywykynaha zeka wasani tsimykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Deus bo tsimypamykysokonahaze: “O Deus kasukyrytsitsa bo wasanitykta. O Deus kasukyrytsitsa humo tysisapywyky”. Iwa ahasukyrytsitsa tsyhyryze Deus bo typamykysokonaha — niy. Niytahi sisukyrytsitsa sopyk nisiwatawy niy. Sesus nisispirikpozo: ");
INSERT INTO rkbNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","— Aty paokpyk zeka usta taba kino niwatihi tsimy. Aty akpyzazawy pibok zeka asuk humo niwatihi nyny taha. Iwa zeka wasani tsimykara. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ba zikakyri aty ape: “ka bo ja” my zeka ibo nyny tsimy. Aty anamy piakse zeka ba kabo tyzisizokta tsimy wasani tsimaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Sizubarẽtsa ahabo wasani maha tsimyzihikiknaha. Iwaze ikiahatsa sibo tsipisapywykynaha atsawatu sisopyk. Atsawatu kytsa bo wasani sisopyk tsimaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ikiahatsa ahatukytsa humo zuba ahamypokzitsiukrẽtsa zeka Deus okze “ahasopyksapybyitsa tsimykaranaha” my. Kytsa simysapybyitsa kino niwatihi. Simysapybyitsa situkytsa humo simypokzitsiukrẽtsa. Kytsa ykparawytsa mysipokzitsikinaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ikiahatsa kytsa humo wasania ty zuba tsimykaranaha zeka asa kino ahawa tu munaha ikiahatsa sisapybyikitsa watsa. Deus okze ka ahamysapybyitsa tsikykaranaha. Iwatsaze kytsa simysapybyitsa kino niwatihi sisopyk. Simysapybyitsa kytsa bo wasania ty zuba, kytsa sibo sisopyk wasani mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ikiahatsa ahanamy ty kytsa bo nynyspyk tsimaha zeka kyze myzisizonaha iwa mytsaty tsimaha. Deus okzeka ahamysapybyitsa tsimaha. Kytsa simysapybyitsa kino niwatihi iwa mykaranaha. Tahanamy ty nyny mykaranaha zeka bykyze sinamy pisizonaha. Iwaze hi sinamy sibo myzisizonaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ahasukyrytsitsa tysipokzitsikinaha! Tysisapywykynahaktsa! Ahanamy ty nynyspyktaha! Iwaze ahanamy ja myzisizo. Ba ahanamy ziperynaha. Iwaze ahanamy baba Deus tuk tsizubarẽna. Deus hyrytsa tsimoziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Deus myzubarẽtsa bo mymysapywyikik. Asa kino iharere humo batu yhỹ mykaranaha, asa bo hi mysisapywyikik, simysapyrẽtsa niwatihi mysisapywyikik. Abazubatsa mysisapywyikik. Ikiahatsa ahamypokzitsiukrẽtsaktsa! Ahazo wata atsawatu tsimypokzitsikinaha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","— O atakta “batu imysapy ba zikaha” iwaze ba ziktsasonaha. Iwa tsimaha zeka ustsa ahasoho kino niwatihi “O atakta batu imysapy” maha. Iwaze batu tyso: “Atakta batu wasani ba zikaha”. Iwa tsimaha zeka ustsa ahasoho kino niwatihi: “Atakta batu wasani” maha. Ikiahatsa kytsa simysapybyri humo tysiokzonaha Deus kino niwatihi ahamysapybyri humo pahaokzo — Sesus nikara. Iwa Sesus nisispirikpoko. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Niytahi ispe niyzo: — Harape bo nynytaha! Iwaze ustsa kytsa kino ahabo nyny maha. Hawa ha ty nyny tsimaha zeka abazuba tsipiaksenaha. Kytsa ahabo nyny mahaze peryk inaharek zektawa. Mytõbaik zekywa. Mysidydyky. Tsizubarẽna ty nyny tsimaha zeka, abazuba tsipiaksenaha. Tsikaeni zuba nyny tsimaha zeka, iwaze tsikaeni zuba ahabo kytsa nyny maha — Sesus nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Sesus nipamykysokozo. Ihyrizikubyrita soho humo nitsasoko. Nisihyrinymyryky: — Harape hyrizikubyritsa tu zeka ba zikarapeoktynaha. Iwa zeka wytyk hoke bo mynaharazuknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","— Pinymyrykyta tsikaeni zuba zinymyryta. Ihyrinymyrytsa abazuba izinymyry. Pinymyryziu zeka tahyrinymyrytsa watu mozik. Tahyrinymyrywy pepykze tahyrinymyrytsa watu mozik. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","— O kytsa amo skaraba ikia aziky hyrizik oke bo hwi upa tsibik bo tsimykozoze. Hwi puho ahyrizik okeze tuze batu zikozo. Ahany byizeka hwi puho ahyrizik okeze tu tsimy. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Hawa tsimaha aziky pe tsimy: “Byri kaziky, uta ahyrizik okebo humo hu my” tsimy — niy. — O ikia myziharawatahanaha ziktawa niy. Batu ahahyrinymyry. Tapara hwi puho ahyrizik eze taty hyrybokty iwaze iktasaziu tsimy iwaze aziky tsipitsumuẽhĩ. Niytahi hwi upa ty aziky hyrizik okeze ky bo hu tsimy — niy. Sesus nikarazo. Iwaze ikia wasani tsimy zeka aziky tsipitsumuẽhĩ. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","— Kyze hwi tisapyrẽta zeka ihara kino niwatihi tisapyrẽta. Wihara sapybyi my zeka hwi batu isapy my. Hwi isapy byizeka wihara kino batu isapy mozik — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","— Ihara bo tsimykozonahaze hwi tsinynaha. Wihara humo hwi tsinynaha. Hwitsa sinyhytsa anahi wihara baba — niaha. — Hwi inikoso eze zeka ba umaha hara zikzibanaha. Kytsa umaha hara ty zykzyk maha, batu duabohoharatsa kino niwatihi bazyk zikaha. Hwi initsa eze zeka batu duabohotsa haratsa ty zykzyk zikaha. Kytsa duabohoharatsa mytsihikiknaha zeka duabohotsa sisakatsa ty zykzyk maha. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Kytsa wihara watsa niy. Aty tisapyrẽna bo mytsaty nikara ana humo hi imysapywyky zuba. Imysapybyita hawa mytsaty nikara ana humo hi imysapybara ty nikara. Hawa mytsaty tsimykaranaha, ana humo kino tsimoziknaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","— Aty ja kape: “O mypehakatsa” my. Iwatsa tu kaharere bo batu ma tsimaha — niy. Ikiahatsa kape mypehakatsa tsimaha zeka iwaze kaharere bo hyỹ tsimaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Aty kabo zumu. Kaharere ziwaby atahi hyỹ nikara. Hawa iwata humo pawatawy. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Atahi maku wata atahi wahoro nizuknize. Harahare eze ziukuru. Ihoke zihiboani ziuku. Iwaze zopoktsa mynabybyknahaze. Hyritsik nawõze. Pihik mynapokze wahoro bo mozumuze baziknatsehepetok. Iwa maha zeka ba ziknazuru. Atakta kaharere ziwabyze iwaze kaharere bo hyỹ nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Atakta kaharere ziwabykyze kaharere bo batu yhỹ ziky. Hawa iwata humo pawatawy. Atahi maku wata wahoro nizuknize tawata. Nimyra eze tu ziukuru. Jokboha zuba jowy batu ioketsehezeze. Iwaze zopoktsa mynabybyknahaze. Hyritsik nawõze. Pihik mynapokze wahoro bo mozumuze. Wahoro myzitsehepetokyk. Natõbaik. Atakta maku kaharere ziwabyta tuze batu yhỹ isopyk. Iwa Sesus tuk zinymyrykynahatsa nisispirikpoko hawa kytsa iharere bo batu yhỹ sisopyk. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Kyze Sesus sizubarẽtsa bo nipamykysobaze niukuru. Kaparanaũ bo zumu. Anaeze sodadu tsumuẽhĩtsa zizororowy. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Kyze maku sẽ sodadutsa nisipeha, atakta sodadu Homa ezekta. Estuba tsumuẽhĩtsa humo tsimypokzitsiukrẽta. Ata hi imyitsapyrita iwatahi asiba nihyrikosokda. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Niytahi taparakta sodadutsa Sesus bo, Sudeutsa taparaktsa ypykyhytsa nisipeha. Ikiahatsa Sesus pe taha: — Panykta! Uta katsumuẽhĩtsa tsizororowykta tsimaha — niy. Hyỹ niaha. Iwa Sesus bo nisipeha. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Niukurunaha. Zumunahaze Sesus bo nizapykykynaha. Sesus pe niaha: — Ikia mytukta! Taparakta sodadutsa bo tynakozore. Iwaze itsumuẽhĩtsa tsipizororowy. Sodadutsa pehatsa Sudeutsa humo tsimypokzitsiukrẽta. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Atahi katsa mytsyhyryze Deus wahoro nizukni. Tsimysapyrẽta humo ikia mytukta! — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Iwatahi Sesus situk niparak. Tykareze tuze taparakta sodadutsa wahoro bo nikaranaha. Sodadutsa pehatsa ituktsa zihobyknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nezeba taparakta sodadutsa ispe niy: — Katuktsa aidyktsa! Sesus bo tsinakozorenaha. Katsyhyryze Sesus pe tsimaha: “O kapehatsa. Ikiahatsa kawahoro bo paku pakubyity, kamysapybyita tu mykara iwatahi ba ziktsuk. Kasikpybyrẽta. Iwatahi batu kabo paku tsimy. Tytsasozubakta! Aharere ty zuba katsumuẽhĩtsa tsipizororowy. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Aharere soho humo kahyrinymyrẽta. Uta niwatihi kapehatsa harere bo hyỹ kasopyk. Sodadutsa kaharere bo hyỹ sisopyk. Mysipehaze: ‘Nabo pãoty!’ Ana humo kino moparak. Usta pe ‘Pany!’ Ana humo kino mozumu. Katsumuẽhĩtsitsa iksipehaka: ‘Nawa tykta!’ Ana humo kino hyỹ maha” Nawa sodadutsa pehatsa tuktsa bo nitsasoko. Ikia kawata tsimy zeka katsumuẽhĩtsa tsipizororowy — niy. Niahatsahi sodadutsa pehatsa tuktsa iharere Sesus bo nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ana Sesus ziwabyze paikpa mytsaty nikara. Sizubarẽtsa bo Sesus nitsasoko: — Wabytaha! Sudeutsa batu kahumo sispirikpo maha. Sodadutsa pehatsa watsa. Atahi kahumo ispirikpota babata Sudeutsa batu — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Kyze ituktsa sodadutsa pehatsa wahoro bo ziksizonaha. Iwaze nipupunahaze nizororota bo nikozonaha. Itsumuẽhĩtsa botu nizororo. Iwa Sesus sodadutsa pehatsa tsumuẽhĩtsa zizororowy. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Iwaze Sesus niukuruzo. Zinymyrykynahatsa ituk niukurunaha. Sizubarẽtsa tuk niukurunaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Sesus Naĩ hudikhudikwy bo zumubahaneze kytsa sizubarẽtsa zihobyknaha. Asahi iytyk bo niukurunaha. Haramukuka tse itaypykze nihyrikosokda. Kytsa iytyk bo zebykyknaha. Ata babata zuba itse. Atatsa zuba kytsa sizubarẽtsa atatsa tuk niukurunaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Kyze Sesus haramukuka zinyze ihumo imypokzitsi izumu. Niytahi atatsa pe: — Asukabyityktsa — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Niytahi ihyrikosokdata bo zumu. Isukpesuk bete zebykyknaha. Iwaze ibyktsitsa ske pokteze pykpyk niaha. Sesus ihyrikosokdata pe niy: — O kyitykta! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Iwaze atsoko ihyrikosokdata kyik tsiharadyhy niy. Atsoko nipamykysokozo. Sesus ije bo zisi. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Kytsa sizubarẽtsa zinynahatsa sipybyrẽtsa niapykyknaha. Iwaze Deus bo nipamykysokonaha: — O Deus ikia hi tsamysapyrẽta. Ikia zuba wasanita — nikaranaha. Asa zuba nipamykysokonaha — Deus sohotsa natakaha mybo izumu. Deus mybo izumu katsa ityryktsa tsimoziknaha — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Nanabyitaba sizubarẽtsa ziwabykynaha. Sesus tahawatu ziwabykynaha. Sudeja ezektsa nawatsatu isoho ziwabykynaha. Haramukuka tse inahyrizikpo naha ziwabykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Suão Batista tuk zinymyrykynahatsa ziwabykynaha. Asa hi Suão bo nitsasokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ziwabyze petoktsa pe niy: — Pany pãotyny. Sesus boktsa! — niy. Niytahi zinymyrykynahatsa petoktsa Sesus bo nisipeha. Ikiahatsa ipe tsimaha: — Ikiahi sa Deus zapehata. Usta za tapery tsimaha — niy. Yhỹ nikaranaha. Iwatsahi Sesus bo nitururuknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ibo zumunahaze ipe niaha: — Suão Batista nimypeha. Iwatsahi tsiknatururuknaha. “Ikiahi sa Deus zapehata. Usta za tapery.” Nezeba Suão mype niy — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Jabasykyri Sesus sizubarẽtsa nisizororowyky. Kytsa hyrikoso sapybara situkoktsa pororo nakaranahatsa nisiksiwyhik. Ustsa sihyrizikubyitsa kino niwatihi nihyrizikzororonaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Sesus: — Suão bo tsiksizonaha! Tsinykynaha, tsiwabykynaha anaty Suão bo tytsasonaha! Sihyrizikubyitsa nihyrizikzororonaha. Siekbyritsa nizororobanaha. Tahakõrõrõtsa humo asiba nibibibanahatsa tu nizororobaiknaha. Siharawitsa tu ziwabykynaha. Niakbakanahatsa inahyrizikpobanaha. Sinamybyitsa Deus wasaniha piwabykynaha. Sakurẽtsa mykaranaha iwa Suão bo tytsasonaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Sesus: — Aty kahumo tispirikporẽta zeka iwatahi tsakurẽta mozik — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Suão Batista nisipehanahatsa petoktsa nitururuknahaze Sesus kytsa sizubarẽtsa bo nipamykysoko. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Suão soho nitsasoko: — Amo skaraba ikiahatsa jerukbara bo tsikukurunaha. Amo sa tsinykynaha, hwi tsibik zopok humo wãkwãk nikara. Batu ba. Suão batu hwi tsibik wabyita niy. Amo tsiny tsihikiknaha. Tisuksapyrẽta ja. Batu, sisuksapyrẽtsa ispehatsa wahoro sihezõje taeze mopykyknaha. Sinamyrẽtsa. Suão inamybyita niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Amo skaraba tsiny tsihikiknaha za Deus harere sohokotsa ja. Suão Deus sohokotsa babata. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Suão soho botu ziwatahakanaha: “Iktsa katsumuẽhĩtsa kaharaze iakzohota. Ske pizozik kahumo pykyhytuty my. Hawa kytsa ske zizozikbanaha siwatsa Suão kytsa nisihyrinymyryky iwa zeka zipehata humo piperykynaha. Sizubarẽtsa Suão harere humo kabo pikymynaha”. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Iwa Suão soho Deus harere ziwatahakanaha — niy. — Kytsa tapara nipupurukbanahatsaktsa myhyrizikwanibyitsa. Suão zuba myhyrizikwanikita niy. Iwatatu aty Deus tyryktsa tuk my, atahi myhyrizikwanikita hỹ. Suão batu — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Aparakbaha okyrysaro bykyktsitsa kino niwatihi ana humo hi ziwabykynahaze: — O Deus wasani tsimykara — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Tapara Suão nisiharasusuku Deus harere bo yhỹ nikaranaha. Pariseutsa sihyrinymyrykytsitsa ahatsa Deus harere bo batu yhỹ niaha. Suão humo siharasusu tsihikbyitsa nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Niytahi Sesus kytsa bo nipamykysokozo: — Kytsa abaktsa sa hawa — Sesus nikara. Uta mysiwatawy niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Asahi jabyitsa watsa. Jabyitsa mowakyrikinaha kõpara ykarawy eze modyhydyhykynaha. Paikpa harape bo hua hua mykaranaha: — Katsaktsa isukzata myikaha bo tsimopamykyzukunaha ikiahatsa ba zikarinaha. Katsaktsa tsikziharawatahakanaha iytyk eze tsikpukarakanaha. Ikiahatsa ba mytuk huehue zikaha niaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Suão Batista izumuze hauk ahabyita niapykyryk. Duabohotsa tsik batu tsõ. Suão soho humo mybarapetu tsikykaranaha: — O ihyrikoso sapybara Suão tuk mynapykyryk tsikykaranaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Utakta Deus zikpehata ahawata ikyzik. Uta ahabo ikzumu. Myzikdisahaikik. Myzikuikik iwa ikykaraze kasoho humo mybarapetu tsikykaranaha: — Iktsa taha! Atakta titsaurẽta tsikaha. Okyrysaro byktsitsa tuk tadisahaka. Ustsa kytsa simysapybyitsa tu nikaranaha iakparawy tsimaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Kytsa: — O katsa zuba myhyrinymyrẽtsa. Wasani my tsimaha — maha. — Batu ba. Batu sihyrinymyry Deusta koikny bakta hyrinymyryhy tu aty hyỹ my zeka wasani mykara — nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Niytahi maku Pariseu Sesus pe niy. — Pany! Pakutyny kawahoro eze tsimymydisahanaha — niy. Yhỹ niy. Sesus Pariseu wahoro bo nitsuk. Iwaze mydisahawyzozowy baze tadyhy. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kyze wytyk imysapybyitatsa Sesus bo inatsuk. Atatsa anaeze zikzurukutatsa. Imysapybara ty zuba ziknakaratatsa kytsa ykparawy. Ana ziwabyze Sesus Pariseu wahoro eze niytatsahi ibo izumu. Iwatatsahi jokmorẽnikia bykyhy tuk netsukuk. Jokmorẽnikia ty taoporosuk eze tsipokzitsarẽna tu zibykyk. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Atatsa Sesus bo zumu. Sesus sukpe baze niriktohoko. Ipyrytsa baze babatu okmymyhãtatsa. Nipuziuku. Tahyritsik tyty zipyrypikik. Taharadi tyty zipyrywikik. Ipyrytsa sukpe ty piok piok nikara. Jokmorẽnikia ty zipyrysusuku. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Pariseu ibo nikozoze mytsaty niy: — O Sesus Deus sohokotsa babata ja. Deus sohokotsa babata zeka wytyk soho humo tsihyrinymyrẽta. Imysapybyitatsa tu ipyrytsa humo paik nikara anahi zinymyryky — mytsaty niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Niytahi Sesus Pariseu pe niy: — O Simaõ ikia tuk mopamykyso tsihikik — niy. — O myhyrinymyrytsa tytsaso — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Sesus: — Kyze makutsa petoktsa tsinamyrẽta okyrysaro ty batu tysirezo. Estuba okyrysaro tsizubarẽna batu isty sirezo. Kĩjẽtos okyrysaro batu isty sirezo. Usta okyrysaro tsikaeni zuba sĩkuẽta zuba batu isty sirezo. Kytsa petoktsa batu okyrysaroko nikaranaha. Tsinamyrẽta bo okyrysaro ty batu nyny zikaha. Kytsa batu amy tohi niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Iwaze tsinamyrẽta tihi: “Uta kaokyrysaro soho humo ikspiritsokda. Okyrysaro ikiahatsa kabo batu tysizo. Kyzekta niwatihi” niy. Iwaze sa aty ihumo iakuta babata mozik — Sesus nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simaõ ipe niy: — Atakta okyrysaro tsizubarẽna zisirezo. Atahi tsinamyrẽta tihi: “Kĩjẽtos okyrysaro ikspiriktsokda” niy. Atahi tsakurẽta atahi kok iakuta babata my — niy. Sesus ipe niy: — Wasani tsikykta — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","46","Iwaze Sesus wytyk bo iktsa niy. Simaõ pe niy. — Atatsa wytyk bo iktsa tykta. Uta awahoro bo iknatsukze ikia pihik ty batu kabo nyny tsiky. Iwatahi pihik ty kapyrypikwy ty batu nyny tsiky. Atatsa hi tahyritsik ty zikpyrypikik. Taharadi ty zikpyrywiki. Ikzumuze ikia batu katy hapyryk aha. Atatsa zuba kapyrytsa ty piok piok nikara. Ikia oreo ty kaharek bo batu nyny tsiky. Atatsa hi jokmorẽnikia ty zikpyryharasusuku. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Wasani nikara. Atatsa hi imysapybyitatsa tu nikara iwatatsa tu Deus ziokzo. Atatsa kahumo tsimypokzitsirẽtatsa iwaze Deus ziokzohik niy. Atatsa kahumo tsimypokzitsiarẽtatsa niyzik — niy. Kytsa tahape: — O mymysapybyitsa tsikykaranaha tsikaeni zuba iwaze Deus myhumo mymyokzo mytsaty ahabyitsa tsimykaranaha. Iwaze Deus maku imysapybyita ty puẽtsik zuba mysiokzo atahi kytsa humo puẽtsik zuba imypokzitsi — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Iwaze Sesus atatsa pe niy: — Amysapybyri humo Deus ziokzohik — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Kytsa nidyhydyhykynahatsa asazubatsa tuk nipamykysokonaha. — Aty skaraba niwa isopykta nikaranaha. Mysapybyitsa tu tsimykaranaha mymyokzo — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Sesus atatsa pe niy: — Ikia kahumo aspirikporẽtatsa. Abaka akurẽtatsa tsimozik. Tsiksi — niy. Iwa Sesus Simaõ bo wytyk soho nitsasoko. Nezeba imysapybara ty zuba ziknakaratatsa Deus ziokzohik, meky watu niyzik. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Aibani Sesus niparak. Sihudikhudikwy taba paikpa zikzumuku. Deus tyryktsa soho nitsasoko. Zinymyrykynahatsa dose ahatsa ituk niukurunaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Wytykyryk kino niwatihi ituk niukurunaha. Ihumo nizororokonahaza. Nezeba hyrikoso sapybara sibo pororo ziknakaranahaze hi, Sesus nisiksiwyhik. Iwazahi wytykyryk Sesus hapik niukurunaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Nawa ahaza niukurunaha: Maria, Soana, Susana sizubarẽza. Ustatsa Maria Madarena inarokotatsa. Atatsa kino Sesus hyrikoso sapybara sete nisiksiwyhik. Soana Kusa oke. Ibarikta Erodes namy perytsa iwa ahaza niukurunaha. Wytykyryk tahanamy ty Sesus bo zinymyrykynahatsa bo kino niwatihi nyny nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nanabyitaba sihudikhudikwytsa sizubarẽtsa Sesus bo inauzuzukbanaha. Myzubaha Sesus bo zumunaha. Iwatahi nisihyrinymyryky. Waratok pariktsa soho humo nipamykysoko: ");
INSERT INTO rkbNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","— Kyze amata riktsa nisiparikikta. Nisipaparikikze mektsaktsa wastuhu ske sak bo siriktsa natsukunaha. Kytsa nisipaparibaiknaha. Piyktsa niwatihi nisihorozukbaiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ustsa riktsa harahareziktsa bo inatsukunahatsa. Iwatsa tu iziponahaze harahareziktsa humo niparabaiknaha. Pihikbyitsahi siharapyryryky niakbabaiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ustsa riktsa inikoso bo inatsukunahatsa. Tahaypykyknahaze tahazozikiknahaze ini humo batu tahatypyk ty niakbabaiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ustsa riktsaktsa mahani. Asaktsa jytykziuha bo inatsukunaha tsahi sisapyrẽtsa taypyknaha tahasukuknaha nipopobanahaze. Sisukbozuarẽtsa niyziknaha Sesus nikara: Kaharere tsipiwaby tsihikiknaha zeka wabytaha — niy. Iwaze Sesus waratok pariktsa soho humo ziwatawyky, ana humo kytsa nisispirikpoko. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Niahatsahi zinymyrykynahatsa Sesus pe niaha. — Amy sa aharere ty mytsyhyryze tsipiwatawyky — niaha. Sesus ispe niy: — Deus ikiahatsa bo kaharere ty piwatawy tsihikik. Kaharere Deus tyryktsa soho pahawatawyky niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ikiahatsa bo pahawatawy tsihikik. Ustsa bo ka batu. Kaharere ziwabykynaha zuba. Hawa ha ty ziwabykynaha batu yhỹ niaha iwatsahi batu sispirikpo. Kaharere ziwabynahaze ana soho humo batu mytsaty niaha. Iwatsahi kaharere bo batu yhỹ zikaha batu sihyrinymyry — Sesus nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","— Kaharere ty pahawatawyky. Riktsa Deus harere hyrity watsa niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Aparakbaha Deus wasania ty piwabykynaha. Asahi riktsa ske sak bo inatsukunahatsa watsa. Deus harere piwabykynaha zuba. Piwabykynahaze Satanas sibo myzumuze, Deus harere pimyiwy. Iwatsahi batu zinymyrynaha. Deus harere humo batu sispirikpo. Deus harere Satanas pimyiwy piyktsa watsa. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ustsa Deus harere piwabykynaha. Asa hi riktsa harahareziktsa bo inatsukunahatsa watsa. Asahi wasania ty piwabynahaze sakurẽtsa. Riktsa siharatatsa zuba byitsa watsa asahi tsikaeni zuba zinymyrykynaha. Ziwabyziubyinahatsa tu Deus harere tsihokdarẽna humo iwaze imysapybyitsa tu mykaranaha iharere humo myspiriktsokdabanaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ustsa Deus harere piwabynaha. Asahi riktsa ini tazahara bo inatsukunahatsa watsa. Deus wasania ty piwabykynaha. Tahanamy bo zuba mytsaty mytsaty nikaranaha. Tahanamy tsihikiknaha. Deus harere humo sakubyrizumu. Asahi wihara watsa ba zikjakuk byitawa. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ustsa Deus harere piwabykynaha. Asahi sisapyrẽtsa. Deus tihi: “Asaktsa wasanikitsa” nikara. Deus harere piwabyziukunaha. Deus wasania ty humo sispirikporẽtsa moziknaha. Deus harere bo hyỹ mykaranaha. Iwatsahi wihara nijakuk naha watsa — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Niytahi Sesus nipamykysokozo. Sesus: — Rika soho humo pahawatawyky — niy. — Ba aty tohi rika napokze peryk pukezi zik ziky. Batu aty tohi rika wanu pukezi zik ziky. Rika isapy eze tu joboni zik my. Iwaze hi mynapupunahaze amypubyri mozik. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Iwaze hi amy jokpitsĩha zeka amypubyri mozik. Aba myhyrinymyrybara humo bykyze kino wasani tsimaha. Ana watawy niyzik. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Wabyziutaha! Pinymyrytohitakta. Aty kahumo mospirikpo zeka mektsa namy ty nyny my. Aty kahumo ispirikpo zeka tsikaeni zuba pinymyryky ana hi mospiriktsokda zuba — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Sesus je itukytsa ahatsa Sesus bo zumu tsihikiknahatsa tu batu ibo zuk niaha. Myzubaha pokso batu zuk niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Iwaze tohi Sesus pe niy: — Aje atukytsa ahatsa izumunaha ape baze moriktotohokonaha. Atuk mopamykyso tsihikiknaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Niytahi Sesus aparakbaha bo nipamykysoko: — Asaktsa Deus harere piwabykynaha, iwaze iharere bo hyỹ mykaranaha. Asahi kaje babaza, katukytsa babatsa maha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Kyze Sesus tsaraha bo takorohyk. Zinymyrykynahatsa tuk kokokorohyk niaha. Sesus: — Koikny! Tsinaporenahaktsa! — niy. Satsukyk niaha. Ziturikinaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","24","Amykta taba zitsikzakanahaze iwaze Sesus kino tsapukteze iotutsa izumuta zurubaka. Iwaze zopoktsa inabybyknaha. Pihik humo tsaraha asiba inaharek. Ihiridawy wa niukuru. Asiba nitaboknaha. Iwatsahi zinymyrykynahatsa Sesus zitudutudukunaha iwaze inapopo ipe niaha: — O mypehakatsa batu iktsa ziky. Tsimymybabakanaha — niaha. Inapopoze kyik niyze: — O zopoktsa niwazuba pyktahaktsa. Pihik pyktykta — niy. Zopoktsa atsoko paỹ niaha. Pihik atsoko nitsykyrituhudibyri. Ihiridawy jakara zikbohota bo mahani itsikpepepe zuba. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Iwatahi Sesus zinymyrykynahatsa pe: — Amy skaraba Deus humo batu ahaspirikpo — niy. Sipybyrẽtsa. Paikpa iktsa nikaranaha. Iwatsahi asa zuba nipamykysokonaha: — Aty skaraba atakta zopoktsa pihik aha ihumo ziwabynaha. Aty skaraba Sesus — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Iwaze amakta taba bybybyu niaha. Amakta taba Kerasa bo zumunaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Sesus byu niyze maku ibo izumu. Hyrikosotsa sapybaratsa ityryk bo pororo ziknakaranaha nipupunaha anaeze ziknapykyryknaha. Iwatahi tubabatu isuk byitatu wahorobara bo tu zikzuruku. Mytyk eze zinapykyryk. Atazuba zikzuruku. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Maku Sesus bo iktsa niyze opykani kakaik niy. Taekaratsa humo iokeryk puruk puruk niy: — Hawa skaraba Sesus, ikia Deus tse. Amy skaraba kabo tsimyzumuku. Sinini ykarawy bo ka myty pehapehabyity — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Iwaze Sesus hyrikoso sapybara nisiksiwyhik. Tapara hyrikoso sapybara maku nizokbatsinaha. Itsipa ziboro. Tsipaikrẽta. Kytsa karikutsitsiwytsa ty zikzipawarakanahaze kino batu. Ziknasitsawakbaka. Zikzipyrytsawarakanahaze kino ziknasitsawakbaikik. Sasabyitsa kino ba ipaikwa sukni ahabyitsa. Hyrikoso sapybara jerukbara bo zioktyhyryknaha. Iwatahi nezeba Sesus hyrikoso sapybara pe: — O nabo pãotaha hyrikoso sapybara! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Sesus: — Amy skaraba anaro — niy. — O kanaro myzubaha iwatatu katsa myzubarẽtsa — niy. Iwaze hyrikoso sapybara sizubarẽtsa maku tuk ziaksenaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Niahatsahi: — O batu ihoketsihirizezebara bo ka myty peha peha byity! Katsaktsa pazaharezatsa bo tsimypupunaha anaeze mynapykyryknaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Iwa nizapykykynaha. Pazaharezatsa sizubarẽtsa hara sukpetara bo tahadisahakanaha — Sibo tsimypupunaha! — niaha. Sesus yhỹ niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Iwaze hyrikoso sapybara pazaharezatsa bo nipupunahaze pazaharezatsa iharatsupetohowy bo nitururukiknaha. Pihik bo niharazukzukbaiknaha. Tahababaiknaha. Batu ibo zukzo niaha. De. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Iwaze pazaharezatsa perytsitsa iktsa niahaze nitururukiknaha. Nanabyitaba myzubaha bo nipamykysokonaha. Sihudikhudikwy bo niwatihi ziknatsasokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Iwatsahi kytsa Sesus bo inakozorenaha. — O hawa skaraba — nikaranaha. Ibo zumunahaze maku bo nikozonaha. Astatu. Taparaka hyrikoso sapybara ituk ziknapykyryknahata dyhyhabyita inaukuru zuba. Abaka Sesus baze nidyhyky. Abaka tasukukta. Taparaka batu isuku. Abaka wasani nizororobaba. Tahabyi niapykyryk. Ibo nikozonahaze sipybyrẽtsa nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Inytsitsa tihi: — Nawa niyta tihi maku nizororota nikara — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Nipamykysobanahaze kytsa tihi: — O tsiksizokta Sesus. Ikia pokso mypybyrẽtsa — nikaranaha. Niparak tsaraha bo takorohyk. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Iwaze izororota Sesus bo zumu: — O uta ikia hapik — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Sesus: — O batu. Awahoro bo tsiksikta! Atukytsa pe tsimy: “O Deus kahumo tsimypokzitsiarẽta. Abaka ikzororo” tykta — niy. Hyỹ niy. Ziksizo. Iwatahi Sesus soho myzubaha bo nitsasoko: — O abaka ikzororo. Sesus zikzororowy — nikara. Iwa hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Kyze Sesus ziksikizoze jakara zikbohota zitsikzakazoze aparakbaha sakurẽtsa. Sesus ziperykynahatsa hi sakurẽtsa. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Maku Sairu inarokota Sesus bo zumu. Kytsa nisipehaka Deus wahoro eze tu niy. Atahi Sesus okeryk taekaratsa humo puruk puruk niy. Sesus humo ispirikpo tahi iwatahi puruk puruk niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ipe niy: — Pany pãotyny Sesus! Tupakta kawahoro bo. Kaste ikatatsahi pomozaka. Asiba zumuza. Aidytykta! — niy. Yhỹ niy. Sizubarẽtsa iapik niukurunaha. Zihyrizabaiknaha. Iwewehebara botu niukurunaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Wytyk kino niwatihi situk niukuru. Atatsa ispubyri ahabyitatsa. Ispu ba ziknapyk. Okyrytsik zikukuze kino batu pyk aha. Zikukuze kino hawa ja zuba nikara. Okyrysaro zipykbaik. Iwatatsahi Sesus bo zuk niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Isuk tsihara humo kytsa papatu paik niy. Iwaze atsoko ispu inapyk. Zizororowy. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Iwaze Sesus pyk niy. Iwaze: — Aty sa kasuk humo paik niy — niy. Batu harere ahabyitsa nikaranaha. Peduru tihi: — O mypehatsa aparakbaha abaze tu tsimyriktotohokonaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Iwatahi Sesus niyzo: — Aty sa kasuk humo paik niy. Deus zikwy kaikze zipo — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Iwaze wytyk ipapatu zinykyze zumuku. Atatsa izororotatsa ibo zumuku. Tsipybyrẽtatsa. Nitydydykyk atatsa tu ibo zumuku. Taekaratsa humo puruk puruk niy. Niytatsahi sizubarẽtsa okze hawa nizororoze nitsasoko. Sesus suk humo paik niyze atsoko nizororobaba. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Sesus iwa atatsa pe niy: — O aspirikporẽtatsa “Sesus pikzororowy” my tsiky. Ikia aharereziutatsawy azororowy. Akurẽtatsa tsikyzik Abaka tsiksiktsa! Tsikzororo baba — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Iwaze nitsasobaze maku sibo zumu. Sairu tsumuehĩtsa ipe niy: — Aste zuba botu nihyrikosokda. Kyzekta! Iwa zeka Sesus mytakni! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Sesus ziwabyta tu Sairu pe niy: — Apyby byihukta! Uta kahumo aspirikporẽta iwatatsa tu mozororo tsakurẽtatsa myzikzo. Tupakta! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Kyze Sesus Peduru, Tsiaku, Suão, Sairu, Sairu oke, iwatsa zuba wahoro bo inapupunaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Anaeze aparakbaha nipuziukunaha. Sesus ispe niy: — Ahasuka byitaha! Hawa hatsa sa tsimopuziukunaha. Iste ba mahani ihyrikosokda zuru zuba — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Iwaze ziwabynahatsa ihumo hazi nikaranaha. Sispirikpobyitsa hi Sesus humo hazi nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Iwaze Sesus Sairu ste nihoekek wanusapy bo zumu. Iwaze itsyhyrype pe humo paik niy. Opykani ipe niy: — Jypykyhyzytyktatsa kyikty! — niy. Iwaze atsoko inahyrizikpo. Inatariktozo. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Sesus: — Atatsa tsidisahawynaha! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Izotsa paikpa iktsa nikaranaha. Ispe niy: — Sosobyijataha. Aste soho ty ka soso byitaha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Kyze Sesus dose zinymyrykynahatsa nisiwatawy. Tazikwy ty sibo nyny niy. Iwatsahi simyitsapyritsa mysizororowynaha. Hyrikoso sapybara mysiksiwyhiknaha. Iwaze Sesus tazikwy ty sibo nyny niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Iwatahi nisipehakaze Deus tyryktsa soho tytsasokonaha simyitsapyritsa tysizororonaha. Nisipehakaze: — Aparakbaha tysizororowykynahaktsa! Hyrikoso sapybara tysiksiwyhiknahaktsa! ");
INSERT INTO rkbNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nanabyitaba tsipomokonaha zeka nanabyi ty ka pu pu byitaha! Azozowy humo kino niwatihi wabe wabe byitaha! Boroho ty pu pu byitaha! Ahadisahawy humo kino niwatihi pok pok byitaha! Okyrysaro ty pok pok byitaha! Ahasuk ty kino pok pok byitaha! Ahahumo ky ty zuba. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Tsipomonahaze wahoro bo tsinapupunahaze anaeze zuba tsimypykyknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Myzubaha bo tsipomonahaze ahahumo yhỹ ahabyi zeka. Meky hudikhudikwy botu tsimytururuknaha. Anabo ahaharere ty waby byizeka mekybotu tykurunaha. Tsimyzonahaze ahapyrysuktsa ty bok boktaha. Wytyk tazy natõze. Myzubaha ezektsa Deus harere bo batu yhỹ niaha piwatawy — niy. Iwa Sesus tuk zinymyrykynahatsa bo nitsasoko. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Niahatsahi zinymyrykynahatsa niukurunaha. Paikpa zikzumukunaha. Nanabyitaba Deus wasania ty ziknapamykysokonaha. Simyitsapyritsa ziknasizororowykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Erodes Karireja ezektsa pehatsa niy. Zinymyrykynahatsa soho ziwabyze batu iaku. Sesus soho ziwabyze batu iaku. Erodes tsipybyrẽta. Kytsa harere humo batu ihyrinymyry. Kytsa wastuhu nikaranaha: — O Suão Batista inahyrizikpo — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ustsa iwa nikaranaha: — O Erias mydiri zumuzo — nikaranaha. Mektsatu kino: — O taparaktsa Deus sohokotsa nahyrizikponaha — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Iwatahi Erodes tapetu niy: — O uta tu Suão Batista sodadutsa pe tsiharekzykiknahakta iky. Aty skaraba maku kytsa soho piwabyky — niy. Niytahi Erodes Sesus ziny tsihikik. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Sakzohotsa Sesus bo ziksizonahaze ibo nitsasobanaha. Zinykynaha ty nipamykysokonaha. Iwatsahi Sesus tuk niukurunaha. Betesaida bo niaha. Asa zuba Sesus jerukbara bo nisioktyhyryk. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Myzubaha ziwabynahaze Sesus tuk zinymyrykynahatsa jerukbara bo niukurunaha. Ana humo kino ziwabynahaze Sesus hapik jerukbara bo nitururuknaha. Sesus sibo nikozoze sihumo tsimypokzitsiarẽta. Deus tyryktsa soho humo nisihyrinymyryky. Simyitsapyritsa nisizororowyba. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Kyze zunubakaze zinymyrykynahatsa ibo zumunaha: — O Sesus tykara eze ka batu mydisahawyky. Jerukbara eze ka batu mydisahawyky. Abaka punubaka kytsa tysipehakta! Ziksinaha — niaha — “Ahadisahawy tyziskyknahaktsa! Anaeze wahoro tsarawybara bo tsipomonaha!” tsimy — niaha. Batu niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Sesus tihi: — O ikiahatsa zakta sidisahawy ty sibo nynytaha! — niy. Iwatsahi: — O batu. Atsikara mytsyhyry wa zuba. Piknutsa petok zuba niaha. Batu sidisahawy ty kõpara zikaha — niaha. Iwa nikaranaha. Sĩko miutsa ahatsahi nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Iwaze Sesus tuk zinymyrykynahatsa pe niy. — Ikiahatsa kytsa pe: “Tyk humo dyhy dyhytahaktsa!” — niy. Yhỹ niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Iwaze metutu tahadyhydyhykynaha! Yhỹ niaha. Sizubarẽtsa itahadyhydyhybanahaze, ");
INSERT INTO rkbNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Sesus atsikara ty okok niy. Piknutsa ty kino petoktsa okok niyze bijo bo iktsa Deus pe niy: — Ikia humo ka mykurẽtsa — niy. Niytahi atsikara zitsakze tatuktsa bo nyny niy. — O sibo nynytahaktsa! — niy. Piknutsa petoktsa sizubarẽtsa niyziknaha sibo nyny niy. Kyze zinymyrykynahatsa myzubaha bo zibiakaknahaze tsizubarẽna niyzikik iwa sizubarẽtsa tahadisahakanaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Itahasuruknaha. Tahadisahabanahaze itsatsakyhy jerehe peryktsa bo zipupukunaha. Dose peryktsa inasihareknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Kyze Sesus atazuba Deus bo nipamykysoko. Zinymyrykynahatsa ibo zumukunaha. Niytahi Sesus zinymyrykynahatsa bo nipamykysoko. Sesus: — Hawa skaraba kahumo maha myzubaha mytsaty mykaranaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Zinymyrykynahatsa ipe niaha: — O wastuhu “O ikia pe Suão Batista mykaranaha”. Ustsaktsa ata hi “Erias” mykaranaha. Mektsatu batu niaha. “Ikia taparakta Deus sohokotsa inahyrizikpota ja” mykaranaha — iwa nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Sesus ispe niy: — Ikiahatsa ja. Aty skaraba uta ahaokze ka — niy. — O Deus pehaha babata — Peduru niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","— Kytsa bo soso byitaha! Utakta Deus zikpehata — Sesus nikara. — Kytsa bo ka ja soso byitaha! ");
INSERT INTO rkbNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Tapara utakta Deus zikpehata iknasikta maku babata ahawatihi sinini my. Sudeutsa taparaktsa kapitãotsa kaharere bo batu yhỹ zikaha. Taparaktsa ziknapamykysokonahatsa Deus wahoro batu kahumo yhỹ mykaranaha. Siwatahakatsitsa kino niwatihi batu kahumo yhỹ mykaranaha. Uta pikbezenaha. Petok puruze mynahyrizikpo — nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Niytahi Sesus aparakbaha bo nipamykysokozo: — Aty katuk babata mozihikik. Atakta pibyituhukutu ta humo tu mospiriktsokda. Pibyituhukutu takparawybara humo kino yhỹ mynakara Deus pokzi mohyrikosokda tawata. Iwa tsikahazozikymybanahaktsa! Hawa sinini mykara atakta niwatihi katuk babata mozik zeka kawata sinini mynakara, iwatsahi tsikahazozikymybanahakta kytsa — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","— Aty tapokzitsihikik zuba zeka Deus okze ka mohokda. Aty ziktapokzitsi byizeka ata kino Deus tuk tawahi mynaopykyryk. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ahanamyrẽtsa zeka tsimyhyrikosokdanahaze ahanamy ka mohokdaba. Ikiahatsa kino niwatihi ahahyrizikarawy mohokda. Kahumo tispirikporẽta ziknakara zeka, katuk tawahi mynapykyryk — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","— Utakta Deus zikpehata. Myziksizoze kazo zikwy katuk mynapykyryk. Deus tisapyrẽta katuk mozumuzo. Bijoikpe iknyktsa Deus tsumuẽhĩtsa katuk mozumunaha. Myziksizoze: “Aty kahumo tisikpybyrẽta zeka uta kino ihumo kasikpybyrẽta. Aty kaharere humo tisikpybyrẽta zeka. Uta kino iharere humo kasikpybyrẽta.” iwa my — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ikiahatsa tazaharaeze tu sihyrikosokda byizetu Deus pehatsa parakbaha moziknaha. Deus tyryktsa mysinynaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Kyze estuba mytsyhyrytsa nisipyk naha sapy bo Sesus Peduru, Tsiaku, Suão ahatsa nisioktyhyryk. Asa zuba hara bijobonita bo nidokoroknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Deus bo nipamykysokoze meky watu tahyrity tisukbarazarẽta tsimoksapyrẽta niyzik. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Kytsa petoktsa ibo inatakahanaha. Erias, Moises ahatsa. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Taparaktsa Deus sohokotsa. Nihyrikosokdanahatsa ituk nipamykysokonaha. Sesus Serusarẽhe eze sinini mykara. Kytsa pibezenaha, mohyrikosokdaze Deus myzihyrizikpowy iwaze Deus bijo bo mydozo iwa Deus mozihikik ana soho ty hi nipamykysokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Peduru tatuktsa tuk tahaõtutsaspyk zurubakanaha. Inapoponahaze Sesus tisapyrẽta bo nikozonaha. Sesus tisapyrẽta niyzik. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kytsa petoktsa ahatsa bo nikozonaha. Iwaze Peduru: — O mypehatsa tykara eze harakykbyihi ahaparik tsipizinaha! Estuba ikia bo, estuba Moises bo, usta Erias bo iwa tsimaha — niy. Ihyrinymyrybyita tu nitsasoko. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nitsasokoze joktsĩ haramwe ziharasu. Bijo satata nasiharak bo. Bijo satata pokso sipybyrẽtsa nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Bijo satata buruk iaksoho ziwabynaha Deus nikara: — Tahi katse, uta iwatawyta. Ihumo kakurẽta. Iharere bo wabyziutaha! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nitsasobaze Sesus zuba nitare. Paikpa iktsa nikaranaha. Batu aty tohi niy. Sesus bo zuba nikozonaha. Zinymyrykynahatsa batu harere. — Iwahahi tsinynaha tyka kytsa bo soso byitaha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kyze hinipỹ are niahaze hara jobonita ekze inasiknahaze sizubarẽtsa Sesus zihobyknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Maku estuba myzubaha tazahara eze hua nikara: — O myhyrinymyrykytsa katse humo tsiktsumuẽhĩkta. Katse tohi zuba. Iktsaziu tsimy. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Hyrikoso sapybara ibo mozumukunahaze opykani ka mynakara niy. Hyrikoso sapybara humo ziknatahyrikywyky. Atsoko itsipa myziboro. Isake saraporo mozipo atsoko mynaraha hyrikoso sapybara pokso, asahi ibo pororo mynakaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Zinymyrykynahatsa pe iky: “Hyrikoso sapybara tysiksiwyhiknahaktsa” iky. Sihyrinymyrybyitsa hi iwatsahi batu katy tsumuẽhĩ — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Sesus ispe niy: — Ikiahatsa batu kahumo ahaspirikpo. Iwatsa tu ahabaze mynapykyryk. Ikiahatsa ahaharere bo zuba hyỹ tsimykaranaha, kaharere bo ka batu yhỹ zikaha — niy. Iwaze Sesus izo pe niy: — Atse tyzioktyhyrykta — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Izumuze atsoko ihyrikoso sapybara inapapykzo. Itsipa ziborozo wytyk bo inaraha. Sesus ihyrikoso sapybara zipehahik: — Nabo pãoty! — niy. Kyze jypykyhyzytykta zizorororwy izo bo zisizo. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Aparakbaha Deus zikwy humo sipybyrẽtsa niyziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Kytsa sizubarẽtsa nisipybybaiknaha Deus zikwy humo sipybyrẽtsa. Kyze Sesus tuk zinymyrykynahatsa pe niy: — Wabyziutaha utakta Deus zikpehata ahawata ikyzik. Kasukyrytsitsa bo pikoktyhyryknaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Iharere tsihokdarẽna. Iwaze zinymyrykynahatsa batu sispirikpo. Iwatsahi amy ty iharere piwatawy batu siwabyziuhu. Sisikpybyrẽtsa. Iwatsatu batu ipe aha. Bykyze zinymyrykynahatsa asa zuba nipamykysokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","— Aty skaraba myhyrizikwanita mytuk mynapykyryk — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Hawa zinymyrykynahatsa mytsaty nikaranaha. Ana humo ka Sesus zinymyryba iwatahi jabastatsa tsibik tahatazaha eze tyrikto niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Sesus ispe niy: — Jabyitsa humo tsinasipokzitsiki zeka niwaha humo ka kakurẽta. Utakta ikiahatsa humo kakurẽta zeka Deus kino niwatihi. Atahi zikpeha. Ituktsa tsimypokzitsiukrẽta atahi myhyrizikwanita mozik. Tsimypokzitsiukrẽta Deus mytsaty my “O atahi myhyrizikwanita kytsa mysitsumuẽhĩ” niy. Atahi katyryktsa tukta Sesus nikara. Aty ahatukze kytsa mysipokzitsiki atahi myhyrizikwanita — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Niytahi Suão Sesus pe niy: — O myhyrinymyrykytsa katsa maku hyrikoso sapybara azikwy humo nisiksiwyhikta tsinynaha niy, iwaze katsa tsispehakanaha: “Kyzekta niwazubakta tsikaha. Ikiakta mytyrykbyita tsikaha” — Suão niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Sesus ispe niy: — O awatutaha. Atahi ahahumo ahabyi zeka iwatahi mytuk moziknaha. Ikiahatsa tysioktyhyryknaha katuktsa moziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kyze Sesus tazo bo piksi naha soho zumukuze iwaze: — O tapara Serusarẽhe bo hi my — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Niytahi kytsa taharaze nisipeha. Iwatsahi niukurunaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Zumunahaze siwanu sapy ziberikinaha Samarija ezektsa batu yhỹ niaha. Sesus Serusarẽhe bo niukuruze iwatsahi kytsa batu yhỹ niaha. Samarija ezektsa, Serusarẽhe ezektsa humo batu siakparawy iwatsahi batu yhỹ niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Suão, Tsiaku iwatsa nikozonahaze ipe niaha: — O izo bijoikpe iknyky tynazipikta iwaze tysiharazohikta — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Sesus uwok niyze nisibetsakik. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kyze usa hudikhudikwy bo niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Iwatsahi mekybotu niukurunaha. Ske buruk niukurunahaze. Estuba maku Sesus pe niy: — Uta kino ikia tuk. Ikia tuk paikpa mynakara — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Sesus ipe niy: — Tsoromamatsaktsa tahahoke eze tu mynapykyryknaha. Piyktsa kino niwatihi tahasuk eze tu mynapykyryknaha. Utakta Deus zikpehata ahawata ikyzik batu kawanu sapyky. Ba haneze tohi zikuru — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Niytahi Sesus usta pe niy: — Pany katukta! — niy. Maku ipe niy: — Byrikta tapara kazo myziytykare — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Sesus tihi: — Nihyrikosokdata ty ka arekekty. Mohyrikosokdaze itukytsa tu piytyknaha. Ikia kino Deus wasania ty ityryktsa soho tytsasoko. Tapara Deus tsyhyryze tarabaja tsimy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Niytahi usta niwatihi niy. — O mypehatsa uta ikia tuk mozihikik. Tapara katukytsa nasipehare “Aba mokuru my” — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Sesus tihi: — Ikia maku wata. Atahi wywyk myzibykze iwaze tasukpe bo iktsa mykara. Paikpa iktsa mykara. Batu tarabaja ziky. Tarabaja ziky byizeka iwa mytakta ba Deus tukta zikyzik. Iwa my zeka ba katukta babata zikyzik — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Bykyze Sesus kytsa sizubarẽtsa nispeha. Setẽta doistsa nisipeha. Petok petokohotsa nisipehaka. Iharere sohowy tuk sihudikhudikwy taba niukurunaha. Iharaze niukurunaha. Deus wasania ty ziknapamykysokonaha. Bykyze Sesus siapik pomo sihudikhudikwy taba my. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Sesus ispe niy: — Katyryktsa mysizozikiknahatsa watsa. Wihara myzibakanaha. Waratok eze idisahawy niobara. Wihara nijakuk. Katsumuẽhĩtsitsa batu sizuba. Iwatsahi waratok tsihitsa pe: “Ikiakta atsumuẽhĩtsitsa wihara bo tysiakzokta!” Zisizoziknaha. Niobaranaha iwatsahi mysizoziknaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","— Aba tsimykurunaha. Uta pahapehaka. Kytsa ahahumo batu siakparawy. Ikiahatsa hozipyrykzatsa watsa. Hozipyrykza parinitsa tazaha eze tawata tsimoziknaha. Parini hozipyrykzatsa myzukbatsi tsihikik naha watsa kytsa pahasukyrykynaha. Kytsa ikiahatsa humo ba hỹ zikaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Iwaze ske buruk okyrysaro suk ty batu wabehyryktaha! Ahanamy ty ka pok pok byitaha! Ahapyrysuk byitsa tu tsimaha! Ske buruk pyk pyk byitaha! Kytsa tsimysihobyknaha zeka, pamykyso pamykyso byitaha! Aidyktsa tsimaha! — nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","— Wahoro bo tsimypupunahaze wahoro ezektsa pe tsimaha: “Deus ikiahatsa humo pahasapywyky” tsimaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","— Anaeze maku tsakurẽta aharere bo yhỹ mykara. Wasani my. Aharere piakse wasani my. Anaeze kytsa zuba simysapybyikitsa maha zeka aharere bo hyỹ ahabyi zeka. Deus ikiahatsa zuba pahasapywykyzo. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Wahoro tsimypupunahaze anaeze tsimypykyknaha. Tahadisahawy ty ahabo nyny mahaze, tsipahadisahanaha. Tahaopowy ty nyny mahaze niwatihi tsipikunaha. Kytsa sitsumuẽhĩtsitsa bo tahadisahawy ty sihyriziktsokzawy humo nyny maha. Iwatsahi kytsa ahadisahawy ty ahabo nyny maha. Ahahyriziktsokzawy humo ahadisahawy ty nyny maha. Mekta wahoro bo ka pão pão byitaha ataeze zuba tupykyknaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","— Sihudikhudikwy bo tsipomonahaze kytsa ahahumo sakurẽtsa mykaranaha. Iwaze tahadisahawy ty nyny maha. Tsipahadisahanaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Anaeze simyiziubyitsa tysizororowynaha. Anaeze sihudikhudikwy ezektsa pe: “O Deus tyryktsa ikiahatsa bo mozumunaha tsimaha” — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","— Sihudikhudikwy bo tsipomonaha zeka kytsa ahahumo batu siaku mykaranaha. Tsiksinaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Tapara siwahoro ezektsa pe tsimaha: “Ahahudikhudikwy eze ky jytyk tazyk mypyrysuktsa humo pyryk my zeka. Wytyk tazy ty ka dydydy aretaha ‘Deus tyryktsa ikiahatsa bo zumu. Ikiahatsa Deus harere bo batu waby tsimaha’ tsimaha” — niy. Wytyk tadydy kino natõze ana humo ziwatawy. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Sesus wasani nikara iwaze ahape: — Kytsa Sodõ ezektsa sisopyksapybyikitsa tu nikaranaha iwatsahi sinini mykaranaha. Nawa puruze Deus sisopyksapybyitsa pe my “O ikiahatsa hi batu ahamysapy” my. Sodõ ezektsa sinini mykaranaha. Ahahudikhudikwy ezektsa abazuba haty sinini tsimykaranaha. Kytsa anaeze sinini mykaranahatsa. Deus harere humo waby ahabyitsa hi sinini mykaranaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","— O Tsoratsĩ inarokoha sihudikhudikwy ezektsa sinini mykaranaha. Kaharere bo batu yhỹ mykaranaha iwatsahi sispirikpobyitsa tu sinini mynakaranaha — niy. — O Beseza inarokoha anaeze hudik mykaranahatsa sinini mykaranaha. Kaharere bo yhỹ ahabyitsa hi sinini mynakaranaha. Anahi kazikwy zinynaha. Atsawatu zeka Tiro hudikhudikwy ezektsa bo mykaranaha. Atsawatu zeka Sodõ hudikhudikwy ezektsa niwatihi tubabatu Deus harere bo hyỹ nikaranaha. Simysapybyitsa nikaranahatsa kino pimoewynaha. Asahi kazikwy zinynaha zeka simysapybyitsa tu nikaranaha pimoewynaha. Iwaze izohyri ty tahapiakwatahakanaha tahasopyk tihi nikaranaha. Kytsa bo ziwatawykynaha simysapybyitsa tu nikaranaha ana hi zimoewybaiknaha. Nawa zuruze Deus simysapybyitsa pe: “O ikiahatsa batu ahamysapy tsimaha” my. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Nawa zuruze kytsa Tiro ezektsa jokboha zuba sinini mykaranaha. Kytsa Sodõ ezektsa niwatihi jokboha zuba sinini mykaranaha. Ikiahatsa hi sininitohi tsimykaranaha niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ikiahatsa Kaparanaũ eze sihudikhudikwytsa. Anaezektsa tihi: “O katsa zuba myhyrinymyrẽtsa” iwatsahi bijo bo ahabyitsa mytsaty tsimykaranaha. Batu ba. Ikiahatsa izo bo pahaoktsoktsokik iwaze sininitohi tsimykaranaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Zinymyrykynahatsa pe nikarazo: — Aty ahaharere piwaby zeka atahi pikwaby. Aty ahaharere ty waby byizeka uta kaharere humo kino niwatihi ba waby zikaha. Aty kaharere bo yhỹ ahabyi zeka atsawatu zikpehata harere bo batu yhỹ ziky — nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Kyze Sesus nisipehakanahatsa sizubarẽtsa setẽta doistsa ziksizonaha. Sakurẽtsa nikaranaha. Sesus bo nipamykysobanaha: — O mypehatsa hyrikoso sapybara myharere humo hyỹ nikaranaha. Ikia naro humo tsiksiakzonahaze tsiksisiwyhiknaha. Azikwy humo zipobaiknaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","— Yhỹ niy. Iwaze hi Satanas bijoikpe ikny wytyk bo inasik inyhik bijo papaizo niaha waha. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Wabytaha! Uta ikiahatsa bo kazikwy ty botu nyny iky. Ikiahatsa pyryhyk bete tsimyzonaha zeka ba zahasisi. Ikiahatsa pikzaha bete tsimyzonaha zeka ba zahahohoro — niy. — Batu amy tohi ahamyiwyky. Ahasukyrytsitsa humo ba zahamyiwynaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","— Ikiahatsa hyrikoso sapybara ahaharere humo yhỹ mykaranaha ana humo kino ahaku byitaha. Ikiahatsa ahakurẽtsa ahanaro bijoikpe eze Deus botu ziwatahaka, ana humo hi ahakurẽtsa tsimykaranaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Kyze Deus hyrikoso humo tsakurẽta. Deus bo nipamykysoko: — O kazo ikia zuba abazubata. Ikia hi bijoikpe ezektsa pehatsa. Ikia hi mybarawy ezektsa pehatsa. Ikia zuba wasani tsinakarata. Iwatahi sihyrinymyrẽtsa bo hawa tsimykara ziokpitsĩ. Batu isty watawy. Sihyrinymyrẽtsa papatu batu isty watawy. Sizubarẽtsa sihyrinymyrybyikitsa hawa tsimykara tsiksiwatawyky. Kytsa jabasitsa watsa hi tsiksiwatawyky. O Deus kazo yhỹ my. Wasani tsimykara. Iwa tsimyzihikik ana humo hi tsimysiwatawyky — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","— O kazo ikia hi anamy ty kabo nyny tsiky. Ba aty tohi taja itse ziky ikatahi zuba. Kazo zuba. Niwatihi ba aty tohi taja kazo ziky ikatahi atse babata zuba zany. Asa kino mysiwatawy tsihikik. Iwa hỹ — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Niytahi Sesus tuk zinymyrykynahatsa asa bo zuba nipamykysokozo. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","— Kytsa ikiahatsa wa pinynaha zeka sakurẽtsa moziknaha. Tubabatu Deus sohokotsa ziny tsihikiknaha hawa Deus mykaranaha batu sinyhy. Ikiahatsa botu tsiknynaha. Ispehatsa kino niwatihi zinytsihikinaha amy ty tsipinykynaha batu sinyhy. Hawa ha ty tsipiwabykynaha, ziwaby tsihikiknaha batu siwabyhy — Sesus nikara. Iwa zinymyrykynahatsa bo nipamykysoko. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Deus harere watahatsa Sesus bo zumu. Sesus zispirikpobyisohoko ata tihi nikara. Iwaze ipe niy: — O myhyrinymyrytsa, hawa skaraba my iwaze mohyrikosokdaze uta Deus bo kawahi mynapykyryk — niy. Iwa nipamykysoko Sesus zispirikpobyisohoko. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Sesus: — Deus harere botu ziwatahaka. Hawa ty skaraba iwatahaha tsinymyryky — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Sesus pe niy: — Botu ziwatahakanaha. Deus humo tsamypokzitsiukrẽta! Deus humo aspirikporẽta zeka iharere bo hyỹ tsimykara. Deus bo mytsatyziu tsimykara. Deus iakparawy. Deus tsyhyryze tarabajaziu tsimykara. Tsapaikrẽta tu itsyhyrypeze ahyriziktsokzawy humo tsimykara. Tsipinymyry zuba hawa Deus mytsaty nikara. Aotutsa pauktsitsa tynasipokzitsiki, ahumo tu tawata tsinakara nahawa tihi. Iwa tsimyzuruku — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Sesus ipe niy: — Wasani tsimy. Nawaze kytsa sisopyk niytahi Deus tawahi mynapykyk — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Deus harere watahatsa mytsaty nikara: — Uta zuba wasani — my. Ta maku ustsa kytsa batu iakparawy. Ta bo zuba mytsaty mykara. — Myzubaha pe batu katukytsa ziky — mytsaty nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Iwatahi Sesus pe nikara: — Amatsa sa kaotutsa pauktsitsa — niy. Sesus zispirikpoko: — Kyze estuba maku Serusarẽhe iknykta ske buruk Serikoho bo inaukuru. Inaukuruze sitsyhyryboarẽnikitsa maku nizukbatsihiknaha. Isuk zibobobaiknaha. Nitsakikinaha. Maku zipypykyknaha iwa asiba zibezenaha. Inamy zebykbaiknaha. Iwaze zerekeknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Iwaze maku Deus wahoro eze ziknapamykysokota Serikoho bo niukuru niwatihi. Ibo nikozoze ziharamu zuba. Tatuky asiba nihyrikosokdata ziharamu. Batu ibo iktsa niy. Usta ske buruk ziharapuwyhik. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Iwaze Deus wahoro eze ziknasitsumuẽhĩkĩta zumu. Usta ituky zumu. Asta buruk tu inaukuru ata kino asiba nihyrikosokdata zinyze ziharamu zuba. Usta ske buruk ziharapuwyhik. Iwaze ske buruk niukuru. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Iwaze usta maku Samarija ezekta inaukuru. Atakta bipyri asiba nihyrikosokdata zinyze ihumo tsimypokzitsiarẽta nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Iwaze asiba nihyrikosokdata bo tadyhy. Ikiwytsa sapy panu ty ziakwaraka. Zihipepeke. Oreo ty ikiwy sapy bo zitsyktsykyk. Ziharasusuku. Duabohotsa tsik ty zipiakurukuk iwa. Iwaze tarara bete zihwikyk. Sisukmotsa wahoro bo zioktyhyryk. Maku asiba nihyrikosokdata humo tsimypokzitsiukrẽta. Sisukmotsa wahoro bo niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Byi zuruze sisukmotsa wahoro tsihitsa petok okyrysaro parata ty ibo nyny niy. Asiba tabezewyta iwahoro eze zereke. Iwaze wahoro tsihitsa pe niy: “Tsipokzitsiki ja. Okyrysaro tsispepyk zeka myziksizoze okyrysaro ty puẽtsik abo nyny my” niy. Iwaze tsihitsa yhỹ niy, okyrysaro ziakse — iwa Sesus nipamykysoko. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Iwatahakatsa pe niy: — Aty sa asiba nihyrikosokdata tukta my. Aty sa iotutsa pauktsitsa — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Iwatahakatsa: — O atahi imypokzitsiukrẽnikita niy. Atahi itukta babata — niy. Sesus: — Yhỹ niy. Ikia tsiksikta. Bipyri wata tsimykara. Samarija ezekta wata tsimykara — niy. Iwa Sesus bipyri soho ty nipamykysoko. Bipyritsa itukbabata niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Kyze niukurunaha. Sesus zinymykyrynahatsa tuk niukurunahaze myzubahabara bo izumunaha. Anaeze Mata wahoro bo nitsuk. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Maria Mata tsy niy. Atatsa hi Sesus harere ziwabyziu. Ipyrytsa baze nidyhyky. Atatsa iharere ziwabytoktoko. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ieky katsa bu nikara. Mydisahawy humo tsihyriziktsokzaharẽtatsa nikara. Iwatatsahi Sesus bo zumu. Ipe niy: — O mypehatsa. Ikia batu iktsa ziky. Katsy ba ziktsumuẽhĩ. Ikza zuba mynakara, ikia katsy pe tsimy: “Aiky tsitsumuẽhĩktsa” tsimy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","42","Sesus atatsa pe niy: — O batu, ikia hi paikpa mytsaty tsimykara, tsahyriziktsokdaharẽtatsa hi. Maria zuba wasani mykara. Tisapyrẽna piwabyky. Hawa pinymyryky ba aty tohi jekze ziakse — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Kyze Sesus Deus bo nipamykysoko. Nepykze zinymyrykyta ipe niy: — O myhyrinymyrytsa katsa tymyhyrinymyry. Hawa Deus bo tsimypamykysokonaha tymyhyrinymyry. Deus bo tsimypamykyso tsihikiknaha. Tymyhyrinymyry Suão wata. Suão tatuktsa nisihyrinymyryky. Hawa Deus bo mopamykysonaha nisihyrinymyryky. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Sesus ispe niy: — Deus bo tsimypamykysonaha zeka nawa tsimaha. “O myzo! Atyryktsa parakbaha abo mytsaty mykaranaha ‘O atahi imysapyrẽnikita batu aty tohi humo asapyzekyhu. Ikia zuba abazubata. Aparakbaha atyryktsa moziknaha. O ikia zuba tsamysapyrẽta’ tsimaha” maha. Mybarawy ezektsa aharere bo hyỹ mahaktsa! ");
INSERT INTO rkbNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Mydisahawy humo tyzibyituhukutu mybo nyny tynakara. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Mysapybyitsa tu tsimykaranahaze iwatsa tu tymyokzo. Katsa kino niwatihi. Kytsa mybo simysapybyitsa mykaranahaze batu mytsaty tsimaha, sihumo tsimyokzonaha. Katsa aharere bo batu ma tsimaha zeka tynamytsumuẽhĩkta iwatsahi isapybara bo ka batu yhỹ tsimaha. Iwa tsimaha. Deus bo ikiahatsa tsimypamykysonahaze iwa tsimaha — Sesus nikara. Niytahi Sesus nisihyrinymyryky. Kyze isukmota soho humo ziwatawyky. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Sesus tihi: — Amo skaraba tsimy. Unopokte ikia atukta bo ja tsimykuru. Ipe tsimy: “O katukta atsikara ty harakykbyi kabo nynytyny. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Aba usta katukta izumu tahi mykara. Isukmota kawahoro bo zumu. Batu amy tohi ty ibo nyny ziky” tsimykara. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Atukta tawahoro eze tu hawa ja kape my: “O batu tsipikykniki. Iwatahi hokbowy zihokbohik. Uta kahyrytsa tuk purubaka. Ba kyik ziky. Ba kadisahawy ty abo nyny ziky” niy. Iwa sa my — Sesus nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","— Iwaze atakta atukta humo batu kyik. Iwata tu kyik my. Pikykniki naha humo kyik my. Ata bo atsikara ty nyny my — niy. Iwa Sesus isukmota soho humo nisihyrinymyryky. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Sesus tihi: — Iwatsahi tsimyzapykykynaha zeka Deus ahabo nyny my. Deus bo tsipiberikinaha zeka tsimozikahanaha. Hokbowy eze huahua tsimaha zeka hokbowy ty zoksapare my. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kytsa Deus bo myzapykykynaha zeka asahi piaksenaha. Kytsa Deus piberikinaha zeka mozikahanaha. Kytsa hokbowy baze huahua mahaze hokbowy zoksapare my. Deus bo tsizapykykynaha zeka, kytsa watsa asahi hokbowy baze huahua maha — nikara. Sesus nipamykysokozo. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","— Aty ahatukze izo zeka iwaze atse ape my zeka “O kazo piknu ty kabokta!” myze, ikia atse bo pyryhyk ty ba nyny ziky. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Atse ape my zeka “O kazo kokuaro kare ty kabokta” myze ikia atse bo pikzaha ty ba nyny ziky. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ikiahatsa ahasapybyitsa tu tsimykaranaha zeka iwatsa tu amy ty tisapyrẽna ty ahyrytsa bo nyny tsimaha. Myzo hi bijoikpe eze tuze atahi imysapyrẽnikita babata. Atahi ikiahatsa bo isapyhanikia ty zuba ahabo nyny mynakara. Deus bo ihyrikoso tsimyzapykykynaha zeka iwaze tahyrikoso ahabo myzapikso iwaze ahatuk mynapykyryk my hỹ — nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Iwa Sesus sibo nitsasoko. Niytahi Sesus ihyrikoso sapybara ziksiwyhik. Maku iharerebyita, ihyrikoso sapybara humo batu harere ziky. Sesus zizororowyze nizororota nitsasoziuku. Kytsa sizubarẽtsa paikpa iktsa nikaranaha siwastuhutsa nitsasokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","— Beresebuhu, Satanas usa naro hyrikoso sapybara pehatsa zikwy humo hi Sesus iharerebyita zizororowy. Satanas humo hyrikoso sapybara nisiksiwyhik. Iwatahi maku zizororowy. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ustsa nimysapykykynaha: — Ikia mytsyhyryze azikwy Deus ikny mybo tsipiwatawyky. — Nimysapykykynahaze Sesus harere zisapybyi tsihikiknaha. Sesus humo sispirikpobyitsa tu iwatsahi iharere zisapybyi tsihikiknaha. Sesus sisoho humo tsihyrinymyrẽta mytsaty nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ana humo hi mysihyrinymyryky. Niytahi Sesus sibo nipamykysoko: — Ikiahatsa kazikwy humo batu ahaspirikpo. “Deus zikwy ty batu ibo nyny niy” tsimaha. Iwa ikiahatsa tsikpamykysokonaha. Deus zikwy ty kabo nyny my hỹ. Satanas kazikwy nyny my zeka hawa piwatahawy. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ityryktsa myharape banaha zeka mopyknaha. Nawaze kytsa metutu mokmyinaha iwaze mysiakbabaiknaha. Niwatihi wahoro ezektsa myharape banaha zeka mopyknaha. Iwaze asahi metutu mokmyinaha. Niwatihi Satanas tuktsa myharape banaha zeka mopyknaha. Myakbabaiknaha. Ikiahatsa tsimyspihikbatakanaha “O tahi hyrikoso sapybara nisiksiwyhik Beresebuhu zikwy humo tsimaha” niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Atuktsa ja. Aty zikwy humo atuktsa hyrikoso sapybara mysiksiwyhiknaha Utakta wasani mynakara. Hyrikoso sapybara mysiksiwyhikze Deus zikwy humo zuba my. Anahi atuktsa piwatawykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Abaka Deus tyryktsa ikiahatsa bo mozumuku ana hi piwatawyky. Kazikwy abazubata. Maku tsipaikrẽta wata. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Maku tsipaikrẽta tsiparakyrẽta tawahoro ty pykyhytu taparakytsa tuk. Sitsyhyryboarẽtsa batu ibo paku zikaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Usta maku ipaikanikita tu zeka iwahoro bo inatsukze taparakytsa humo taspihikik iwatatu batu ipaikik. Iwaze usta hi inamy pebykba. Zepykyk. Inamy pibiakba. Iwaze utakta ipaikanikita wata kazikwy abazubata — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","— Aty batu katuk zeka, atahi kape batu yhỹ my. Aty katy tsumuẽhĩ byizeka atahi kytsa metutu myokmyinaha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Sesus nipamykysokozo: — Hyrikoso isapybara maku ekze poize pitabaka zuba. Ata taty byryhabyita tu pitabaka zuba. Hyrikoso isapybara itseheha bo pitabaka. Tasapy piberiki. Tawanu sapy ty batu tykaha. Iwatahi ihyrikoso sapybara tapetu isopyk: “Kawahoro bo piksizo. Nezeba maku ekze ikoik tabo tu piksizo” niy. Hyrikoso isapybara izoihikze maku tsakurẽta. Hyrikoso isapybara nihokdaze tsakurẽta nikara. Kyze ihyrikoso sapybara maku bo ziksizo. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Zumukuze maku wahoro wata. Wahoro tsiziurẽna. Zizozoko itsytsykyha niy. Ta humo tuk mytsaty niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Tisapyrẽna. Niytahi niparakzo. Ustsa hyrikoso sapybara sete hyrikoso sapybara nisihobyk. Hyrikoso sapybara iwanu sapy bo mynasioktyhyryk. Maku bo mozumunaha. Ituk mynapykyryknaha. Tapara ihyrikoso sapybara estuba ituk maku batu iaku. Abaka hyrikoso sapybara sizubarẽtsa ibo pororo mykaranaha iwatahi tisukatsihikrẽta babata mynapykyryk — Sesus nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Sesus nipamykysokoze atatsa hi myzubaha tazaha eze opykani Sesus okze nipamykyso nawa ipe niy: — Aje tsakurẽtatsa. Atatsahi tabykyhy humo tsakurẽtatsa atatsahi ikia pykyhytu ziknakara. Ikia humo tsakurẽtatsa — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Sesus atatsa pe niy: — O asahi Deus harere piwabyziukunaha. Iwaze iharere bo hyỹ mykaranaha, asahi sakurẽtsa babatsa mynakaranaha — Sesus nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Kytsa sizubarẽtsa harape bo inakypykyknahaze Sesus ispe niy: — Abaktsa kytsa batu simysapy nikaranaha. Kahumo batu sispirikpo. Iwatsahi iwatahawy myziberikinaha. “Deus zipehata mybo tyziwatawykta!” mykaranaha. Batu yhỹ my. Sonas wata mysiwatawy. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Sonas wata pahawatawy — niy. — Tubabatu Sonas Deus zikwy Ninewe ezektsa bo ziwatawy. Tapara Deus Sonas Ninewe ezektsa bo ziakzoze ziwatawy. Iwata utakta Deus zikpehata ahawata ikyzik abaktsa kytsa Deus zikwy piwatawyky. Tapara Deus zikykzo abaktsa kytsa bo piwatawy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Niytahi Sesus nikara. — Uta kahyrinymyrẽta ikzumu, ikiahatsa kahumo batu ahaspirikpo. Kytsa mynahyrizikpobanahaze Deus simysapbyitsa pe my: “O ikiahatsa batu ahamysapy iwatsahi sinini tsimynakaranaha” my. Niytahi atatsa Seba tyryktsa tuk ispehatsata niyzik. Atatsa hi mynahyrizikpoze. Abaktsa kytsa niwatihi aiba tohi mynahyrizikponahaze. Atatsa tihi: “O asahi simysapybyikitsa tu nikaranaha, ana hi piwatawyky. Tubabatu ikza nokponi ikukuru. Soromao ihyrinymyryta babata harere myziwabyre. Tsihyrinymyrẽta harere piwaby tsihikik” — niy. Sesus: — O abaktsa kytsa kaharere bo batu yhỹ maha. Uta abazubata myhyrizikwyta kaharere bo batu yhỹ niaha — nikara. — Kytsa mynahyrizikpobanahaze aiba tohi Deus simysapybyikitsa bo “O ikiahatsa kahumo batu ahamysapy” my. Ahamysapybyitsa tu tsikykaranaha iwatsahi sinini ykarawy bo tsimynakaranaha my — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","— Niytahi Ninewe ezektsa mynahyrizikponahaze asahi abaktsa kytsa pe: “O ikiahatsa batu ahamysapy tsikaha” mykaranaha. Ahamysapybyitsa tu tsikykaranaha tsipiwatawynaha. Iwatsahi Ninewe ezektsa tamysapybara ty nikaranahatsa zimoewyhiknaha. Deus harere ziwabynahaze imysapybara zimoewynaha Sonas harere humo. Deus harere bo hyỹ nikaranaha — niy. — Abaktsa kytsa hi kaharere bo batu yhỹ mykaranaha. Uta myhyrizikwanita babata kaharere bo batu yhỹ zikaha — Sesus nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Sesus rika soho humo nisispirikpoko. — Myhyriziktsa rika watsa — niy. — Ba aty tohi rika mozipokze miha papa ba okpitsĩ ziky. Ba peryk pukezi zik ziky. Rika mozipok zeka jo baze zik my. Aty mynatsukze mypubyi mozikze zinytokto — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","— Myhyriziktsa rika watsa ahanamy bo sihumo iktsa tsimaha. Ahahyriziktsa humo tuzu byizeka ikiahatsa okze mypubyri mozik. Ahahyriziktsa sisapy byizeka ikiahatsa miwa ezektsa watsa. Ba zikozonaha unata ky wa. Maku ihyriziktsa humo tuzu byizeka tsakurẽta mykara maku wata atahi mypubara buruk mokuru. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Iwatsahi pykyhytu tynakaranaha rika mypubara ahatukze ba miwa ziky. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kyze ikiahatsa mypubyi mozik zeka ba miwa ziky. Ikiahatsa atawahi mypubara buruk mokuru tawata. Atawahi zeka rika wata amypubyrizo. Nakyoknahaze kywa — nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Sesus nipamykysobaze Pariseu ziakzoko: — Kawahoro bo tsikadisahakta! — niy. Yhỹ niy. Sesus iwahoro bo nitsuk. Idisahawyzozowy baze nidyhyky. Pariseu Sesus bo nikozotoktoko. Sesus itsyhyrype pikihibyita tu tadisahaka. Iwatahi ibo nikozotoktoko. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Niytahi Sesus ipe niy: — Ikiahatsa Pariseutsa ahamypewytsa ahaokporosuktsa kino niwatihi sisupetaba zuba tsinasipikiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ikiahatsa Pariseutsa mypewytsa watsa. Mypewytsa isupetaba zuba tsibararẽtsa. Joke tabaka nioktsirõrõ. Hawa mytsaty tsimykaranaha batu wasani tsikaha. Simysapybyikitsa tu tsikykaranaha. Ahazokdiharẽtsa. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","O ahatyryksapybyitsa tu tsimaha. Atakta isupetaba tsispeharazyky, zikino ioketaba niwatihi tsimaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","— Ahadisahawy ty sinamybyitsa bo nyny tsimaha. Sihumo ahamypokzitsirẽtsa hi iwatsahi sibo nyny tsimaha. Anahi wasani my. Iwaze Deus ahape my: “O atakta tsimysapyrẽta mozik” — my. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","— O Pariseutsa sinini tsimykaranaha — Sesus nikara. — Ahanamy tsihohokrẽnaha zeka estuba Deus bo nyny tsimaha. Wasani tsimaha. Ikiahatsa ahadisahawykykywy ty Deus bo nyny tsimaha. Kytsa humo batu ahamysakihiky tsimaha. Iwatsahi Deus harere bo batu yhỹ zikaha — niy. — Ahanamy tsihohokrẽna zeka estuba Deus bo nyny tsimaha. Iwa tsimaha zeka wasani tsimykaranaha. Ustsa humo kino niwatihi tsimaha! Ahanamy tsihohokrẽnaha zeka sinamybyitsa bo nynytaha. Sizubarẽtsa humo ahamysakihikrẽtsa. Iwa tsimykaranaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","— O Pariseutsa sinini tsimykaranaha. Batu ahaku tsimoziknaha. Ikiahatsa Deus wahoro eze ahadyhydyhywytsa sisapyrẽtsa zuba ahakparawy tsimaha. Kytsa pahahobyknahaze ahahumo siharereziurẽtsa ana hi ahakparawy. Kytsa mynakaranaha bo zuba mytsaty ahasopyk — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","— O Pariseutsa sinini tsimykaranaha. Ikiahatsaktsa mytyk watsa. Mytyk iokpitsĩha niaha. Kytsa sinymyrybyitsa hi mytyk humo nipaparekenaha iwatsahi batu wasani aha — nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Niytahi estuba Deus harere ihyrinymyrykyta Sesus pe niy: — O myhyrinymyrykytsa iwaze ikia za tsimymysapybyikikta — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yhỹ Sesus niy. — Ikiahatsa niwatihi. Ikiahatsa sinini tsimykaranaha. Kytsa paikpa tysiakzo: “O taparaktsa harere bo pykyhytutaha! tsimahaktsa.” tsimykaranaha. Ikiahatsa taparaktsa harere bo batu yhỹ tsikaha. Ikiahatsa kytsa bo yhỹ ahabyi zeka, Deus ahahumo batu imypokzitsi tsimaha. Ikiahatsa ja. Kytsa taparaktsa harere bo batu zikahaze, ikiahatsa batu isty tsumuẽhĩ. Iwatsahi sinini tsimykaranaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","— Ikiahatsa Deus sohokotsa siytyk sapyrẽtsa tsinazoknikinaha. Asatu taparaktsa ahadiritsa nisibabaiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Iwatsahi tsipiwatawykynaha hawa taparaktsa nikaranaha ikiahatsa yhỹ tsimykaranaha. Ana kino tsipiwatawykynaha Deus tsihyrinymyrẽta. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Iwatahi tubabatu Deus tihi: “Kapehatsitsa, kasohokotsitsa kino niwatihi sizubarẽtsa bo nisipehaka.” Wastuhu nisibakanaha. Mektsaktsa nisisukyrykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Tapara nisibakanaha. Abaktsa kytsa kino Deus sohokotsa mysiba tsihikiknaha. Taparaktsa tuk yhỹ maha. Tapara Abeu tabezewy. Ziharawy Sakarias Deus wahoro eze zibezenaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","52","— O Deus harere sihyrinymyrykytsitsa sinini tsimykaranaha. Ikiahatsa imysapyha tsiokpitsikinaha. Iwatsahi Deus humo batu ahaspirikpo. Ikiahatsa isapyha humo batu ahakparawy iwatsahi ustsa kytsa bo ba nyny zikaha. Iwatsahi asahi ahahumo batu sihyrinymyry. Ikiahatsa humo batu sispirikpo — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Sesus niparakze Pariseutsa, sihyrinymyrykynahatsitsa ahatsa Sesus humo tahakyrikinaha. Iharere ziwabyziukunahaze. O Sesus batu imysapy nipamykyso tsihikiknahaze iwatsa tu batu zikaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Iwatsahi Sesus tsipa humo ziokty tsihikiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Myzubaha Sesus bo inauzuzukbanaha, iwaze niharapebakanahatu. Niytahi Sesus tuk zinymyrykynahatsa pe niy: — Pykyhytutaha! Pariseutsa harere humo pykyhytutaha! Pariseutsa tihi: “katsaktsa zuba wasani tsimaha” iwaze mytsaty ahabyitsa nikaranaha. Batu ba, mybarapetu nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Hawa ha ty kytsa papatu tsimahaze iwaha humo tu kytsa pinymyrynaha. Hawa ha ty tsiksakzikinaha humo tu kytsa pinymyrykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Hawa ha ty ikiahatsa miwa eze tsikpamykysokonaha ana hi kytsa mypubara piwabykynaha. Hawa ha ty awahoro eze tsiktsasokonaha iwahatu ahahudikhudikwy eze opykani mopamykysonaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Sesus nipamykysokozo: — O katukytsa! Ahapyby byihu ja! Kytsa pahabanaha sipokso ahapyby byihu ja! Asaktsa pahabanaha zeka iwaze batu zikaha. Batu amy tohi zikaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ahahyrizikararawy ba ziksibanaha iwaze sipokso batu ahapyby Deus pokso zuba ahapybyrẽtsaktsa! Atahi kytsa mohyrikosokdanahaze sinini ykarawy bo mymypeha ziky. Iwatsahi Deus pokso ahapybyrẽtsa! ");
INSERT INTO rkbNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Kyze nawa mytsyhyry wa piyktsa hana wa skaraba sihuak ty okyrysaro ty nyny maha “O tsikaeni zuba nyny tsimaha”. Deus ta piyk tsibik humo ba zikspiriktsokda. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Deus tsihyrinymyrẽta sihumo tsimypokzitsiarẽta. Iozeka tsipokzitsarẽna. Ikiahatsa ja. Deus hi ahasoho humo tsihyrinymyrẽta atahi ahahumo tsimypokzitsiukrẽta — Sesus nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Sesus ispe niy: — Utakta Deus zikpehata ahawata ikyzik. Ikiahatsa kytsa okze: “Uta Sesus tukta my. Sesus iny” tsimaha. Ikiahatsa tsimytsasokonaha zeka uta niwatihi my. Bijoikpe iknyktsa Deus tsumuẽhĩtsitsa okze uta tihi: “Atakta katukta atahi iny” my. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ikiahatsa kytsa okzeka: “Sesus batu kanyhy tsimaha”. Nawa tsimytsasokonaha zeka uta niwatihi. Bijoikpe iknytsa Deus tsumuẽhĩtsitsa okze: “Atakta batu kanyhy” my. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Aty kasoho humo tsiharerewabymybarẽta zeka imysapybara tu mynakaranaha iwatsa tu Deus mysiokzohik. Aty Deus hyrikoso humo tsiharerewabymybarẽta zeka imysapybara tu mynakaranaha atahi Deus ba zikokzowy my — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","— Kytsa ahatsipa humo pahaokytyhyryknaha zeka ispehatsitsa okeryk tsimytsasonaha, Deus wahoro bo pahaoktyhyryknaha zeka ispehatsitsa okze tsipahabetesanaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Iwatsahi ba paikpa mytsaty zikaha. Iwatahi Deus pahatsumuẽhĩ pahahyrinymyry. Ahaharere Deus hyrikoso humo mytsaty tsimaha iwatsahi atahumo ahahyrinymyrẽtsa iwa pahatsumuẽhĩ — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Maku estuba myzubaha tazahara eze Sesus bo nipamykysoko: — O myhyrinymyrykytsa kaziky pe tykta “Azo nihyrikosokda. Aba azo hyrikyky ty tsapukte buruk atsy bo nynyty tsimy” — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Sesus ipe niy: — Batu aty tohi kape nawaty aha. Ikia hi myharere bo wabyty tsimy, mynamy soho tsimytsasoko — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Wabyziutaha! Ispe niy: — Pykyhytutaha! Ahasorokbyihu ja! Pykyhytutaha ahanamybyihuktsa. Nanabyi humo tsipahanamy tsihikinaha zeka batu Deus tuk zikykpykyknaha. Deus kytsa nisisukni iwatsahi Deus tuk mynapykyryknaha. Kytsa mynamy bo zubabyitsa Deus nisisukni — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Niytahi Sesus nipamykysoko. Tsinamyrẽta soho kytsa bo ziwatawyky ispe niy: — Kyze maku estuba tsinamyrẽta waratok tadisahawy ziubara niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Iwatahi tsinamyrẽta tatuk tuka mytsaty nikara: — Hawa sa my. Hana bo sa kadisahawy pidodo. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Iwatahi kadisahawyzozowy pipaparahik. Iwaze ustsa disahawyzozowy mozukni. Disahawy zozowy zuba puẽtsikbyita mozukni. Iwaze hi kadisahawy pidozik. Kanamy niwatihi wahoro zuba tabo pidodo — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Iwatahi tapetu nikara: — O abaka kakurẽta. Pikbyry pikuikik kakurẽta mozik! Kadisahawy tsizubarẽna ty hauk my. Kanamy kino tsizubarẽna ba zikpykba — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Deus hi tsinamyrẽta pe niy: — O ityrykmyita. Ikia mytsatybyita tu kyze unata tsipomoza. Tsipomozaze ahyrikoso sa hana bo my. Anamy ja. Aty baze sa anamy motare. Nezeba anamy tsidodoko. Aty baze sa anamy mopykyk — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Sesus tihi: — Kytsa ustsa mysisapywykynaha zeka sinamy Deus baze dodo maha. Asaktsa ba tahanamy pidodonaha zeka asahi tsinamyrẽta wata imytsatyhybyita — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Iwaze Sesus sibo mynamy soho nisispirikpoko. Zinymyrykynahatsa pe niy: — Ahanamy bo ka mytsaty mytsaty byitaha. Iwa zeka paikpa mytsaty tsimykaranaha “O amy ty sa tsimymydisahanaha ba zikaha. O amy ty sa mysuk tykorobyk tsimaha ba zikaha.” Ahadisahawyky zeka wasani tsimaha. Ahasukok zeka wasani tsimaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ikiahatsa hi iwatsa tu tsimykzokonaha Deus baze mywahi tsimynapykyryknaha zeka mysapyrẽnikia baba niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Piyktsa bo iktsaziutaha! Piyktsa tahadisahawy ba ziksipariknaha, ba tahadisahawy zizoziknaha ba ziktahatsohoknaha. Wahoro eze batu sidisahawy zozowyky. Deus piyktsa humo tsimypokzitsiarẽta sidisahawy ty sibo nyny isopyk. Piyktsa bo sidisahawy ty nyny mynakara. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Deus ikiahatsa humo tsimypokzitsiarẽta. Amy skaraba ana bo hi mytsaty tsimykaranaha. Mytsatyziu tsimaha zeka ja usta puruze mynakubazo. Batu ba. Mytsaty tsimaha zeka ja ba zikara ");
INSERT INTO rkbNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Iwatsahi ikiahatsa tsikaeni zuba ba zikaha zeka amy skaraba disahawy humo mytsaty tsimykaranaha. Amy skaraba ahasuk humo kino niwatihi mytsaty tsimykaranaha — Sesus nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Sesus ispe niyzo: — Isazik bo iktsataha amytsĩ bo iktsataha. Iktsaziutaha! Isazik taypykze, anatu ba ziktatsazik ba anatu pyryryk pyryryk ziky, anatu zeka tasuk ba ziwowo. Wasani mykaranaha. Tapara Saromao tsinamyrẽta. Inamy tisapyrẽna. Isuk tsiziuwyrẽna ty zuba korobyk ziknakara. Nanabyi sazik ka abazuba tsiziurẽna baba. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Iwaze Deus nanabyi sazik humo tsimypokzitsiarẽta. Abaka okyry saro ispitu byriri ka mohokda. Izo bo mokoroba. Ikiahatsa ja. Deus ikiahatsa humo tsimypokzitsiukrẽta. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Iwaze Deus ahasuk ty ahabo nyny my. Ikiahatsa Deus humo jokboha zuba ahaspirikpo zeka atahi ahanamy ty ahabo nyny my — niy. — Iwatsahi mytsaty mytsaty byitaha. Batu tyso: “Amy ty sa tsimymydisahanaha. Amy sa tsipikunaha” niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kytsa Deus humo batu sispirikpo iwa mytsaty nikaranaha. Deus ahazo tsihyrinymyrẽta. Ahasuk ty ahabo nyny my. Ahazo bijoikpe eze tuze ahasoho humo tsihyrinymyrẽta. Atahi ikiahatsa bo ahadisahawy ty nyny mykara. Ahasuk humo kino niwatihi nyny mykara. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ikiahatsa Deus tyryktsa bo mytsaty tsimykaranaha. Iwa mytsaty tsimykaranaha zeka Deus ahanamy ty nyny my. Deus ikiahatsa bo ahanamy ty nyny mykara — niy. Iwa Sesus sizubarẽtsa namy soho humo nisispirikpoko. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Sesus tihi: — O kahyrytsa ahapyby byihu ja! Ahazo tyryktsa tsimoziknaha zeka ana hi mozihikik. Amy humo ahaku byri zeka nyny my! ");
INSERT INTO rkbNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ikiahatsa ahaokyrysaro ty sinamybyitsa bo nyny tsimaha! Iwatsahi ahanamy baba tsizubarẽna bijoikpe eze. Anaeze ahanamy ba hawa tohi ziky. Ahanamy bijoikpe eze niy. Anaeze sitsyhyryboabyitsa ba zibyknaha. Anaeze ka ahanamy ba wazazatsa ziworonaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ahanamy bijoikpe eze tu zeka, ikiahatsa bijoikpe bo mytsaty tsimykaranaha. Ahanamy bo bijoikpe eze iwaze bijoikpe soho bo mytsaty tsimykaranaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Kyze Sesus myziksizo naha humo kytsa piperykynaha. Nisihyrinymyryky: — Tsikahazozikbanahaktsa kytsa! Ahasuk ty opyk haĩtaha! Rika ty poktaha! ");
INSERT INTO rkbNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Kytsa watsa tahapehakatsa piperykynahaze ky wa. Ispehakatsa mysukzawy bo zumukuta myziksizoze tawata. Kytsa pehakatsa piperykynahaze hokbowy humo tototo maha piwabynahaze atsoko zoksapare niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Inatsukze sitsumuẽhĩtsitsa sakurẽtsa. Sitsumuẽhĩtsitsa ziperykynahatsa hi ispehakatsa ziksize sakurẽtsa. Wasani nikaranaha. Sitsumuẽhĩtsa disahawyzozowy baze dyhy niy. Iwaze atahi tsakurẽta nikara. Ispehakatsa tsakurẽta nikara kytsa taperytsitsa humo. Iwatahi sidisahawy ty sibo nyny my. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Sispihikrẽtsa nikaranaha tozeka ja ispehakatsa unopokte ja mozumu. Tozeka ja iwariknakyrize ja mozumu Sitsumuẽhĩtsa piperykynaha zeka sakurẽtsa mykaranaha — Sesus niy. Sesus: — Aparakbaha katy peryhabyize watu myziksizo. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Kyze wahoro tsihitsa nawa taeze itsyhyryboanikita mynatsuk zeka iwahoro bo ba ziktsuk. Tsihyrinymyrẽta zeka itsyhyryboarẽta iwahoro bo ba ziknatsuk. Aparakbaha ba sihyrinymyry wahoro tsihitsa wata. Uta niwatihi kytsa katy pery ahabyitu myziksizo — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Sesus nikarazo: — Tsipiperynaha. Utakta Deus zikpehata ahawata ikyzik atsoko myziksizoze iwatsahi tsipiperynaha! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Peduru Sesus pe niy: — O mypehatsa, aty bo sa aharere tsipiwatawyky. Katsa mybo zuba sa tsipiwatawyky. Sizubarẽtsa bo tihi sa tsipiwatawyky — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Sesus nipamykysokozo. Sitsumuẽhĩtsa soho ty nipamykysoko. Ipehakatsa tatsumuẽhĩtsa pe niy: — Kawahoro ja typery niy hawa kytsa disahawy ty wasani eze zuba sibo nyny ty ka — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Sitsumuẽhĩtsa imyperyziuta zeka ipehakatsa ihumo tsakurẽta. Ata soho hi nitsasoko. Hawa mykara nisihyrinymyryky. Atahi: — Sitsumuẽhĩtsa pehakatsa harere bo yhỹ mykara zeka tsakurẽta. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Wasani mykara. Ipehatsa namy tsizubarẽna perytsa mozik — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","— Tozeka ja sitsumuẽhĩtsa tapetu isopyk my: “O kapehatsa azymyny batu aidy erete ziky” niy. Iwaze tawa kytsa mysikiki. Sitsumuẽhĩtsiza kino niwatihi mysikiki. Tadisahaikik. Siopuwy pikuikik iwatahi tsiopyryrykrẽta. Atsoko ipehatsa ipapatu iziksi. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Sitsumuẽhĩtsa nispihikbyize. Haramwe hana eze ja batu ihyrinymyry. Ihyrinymyrybyita tu ipehatsa atsoko ziksi. Ipehakatsa sitsumuẽhĩtsa zizukutu niy. Sinini ykarawy bo pipehahik. Kytsa Deus harere bo hyỹhabyi zeka anabo mysipehahik. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Amakta tsumuẽhĩtsa sininiwy my. Tsihyrinymyrẽta tu ipehatsa harere bo “batu yhỹ” niy. Pykyhy izozikbyitu. Atahi Deus namy perytsa wata. Deus ibo iktsa niyze: “O atakta ‘batu imysapy’ ” my. Niytahi sitsumuẽhĩtsa tisikpybyrẽta. Tsihyrinymyrẽta humo tisikpybyrẽta. Sinini tynakara. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Usta tsumuẽhĩtsa tsikaeni zuba sinini tynakara. Ipehatsa harere ihyrinymyrybyita tu, iwatahi tsikaeni zuba sinini tynakara. Iktsataha! ahanamy tsizubarẽna zeka nyny tahaktsa. Deus kytsa bo sinamy nyny niy zeka asahi ustsa bo nyny ahabyi zeka sisikpybyrẽtsa. Iwaze Deus tihi: “Uta ahabo tsizubarẽna ty nyny my iwaze ikiahatsa kytsa bo batu nyny tsimaha, kaokze ikiahatsa batu ahamysapy tsimykaranaha” — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Sesus ispe niyzo: — Utakta mybarawy ezektsa bo ikzumu niy. Ikzumuze izo waha. Izo waratok pipopokoknaha ziktawata iwaze tisapyrẽna mozik. Ikiahatsa ahamysapybyitsa tu tsikykaranaha Deus mysiokzohik. Kytsa pikbezenahaze iwaze simysapybyitsa mykaranahatsa Deus mysiokzohik. Botu mohyrikosokda zeka kakurẽta. Bykyze zuba. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Tapara sinini my. Iwatahi batu kaku. Nawa humo hi mykara — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ikiahatsa mytsaty ahabyitsa tsimykaranaha. — O Sesus mybarawy ezektsa bo izumu iwatsahi kytsa harape wa metutu byinahatsa — iwa mytsaty ahabyitsa tsimykaranaha. Utakta mybarawy ezektsa boze kytsa kahumo meky watu mytsaty mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Iwaze kytsa mytsyhyrytsa wa wahoro eze tuze mopykyryknaha. Harakykbyihi mytsaty maha: — O ta batu wasani — maha. Petoktsahatsa: — O na wasani — maha. Iwaze harakykbyihi petoktsa bo mysimyijakanaha. Petoktsa harakykbyihi bo mysimyijakanaha. Wastuhu — O Sesus tsimysapyrẽta — mykaranaha. Ustsa — O batu ba — mykaranaha. Iwa metutu moziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Sizotsa tahahyrytsa humo batu siakparawy. Sihyrytsa tahazotsa humo batu yhỹ zikaha iwatsahi metutu mopaparahanaha. Sijeza tahahyryza humo batu siakparawy. Sihyryza tahaje za humo batu yhỹ zikaha iwazahi metutu mopaparahanaha. Sipyijeza tahahyrytsa okeza humo batu siakparawy. Sihyrytsa okeza tahapyje humo batu yhỹ zikaha iwazahi metutu mopaparahanaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Sesus kytsa bo nipamykysokozo. — Ẽryk ioktsĩ bo iktsa tsimahaze ikiahatsa atsoko: “O hyritsik kok mynawõ” wasape ahasopyk. Hyritsik mynawõ hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Zopok nabybykykze. Ikiahatsa: “O na haramwe zeka tsizõhanina mozik” wasani ahasopyk. Tsizõhanina mozik hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ahaharawatahatsitsa! Iwatawy bijoikpe eze humo ahahyrinymyrẽtsa. Iwatawy mybarawy eze kino niwatihi ahahyrinymyrẽtsa. Kawatahawy humo ka batu ahahyrinymyry niy. Deus watahawy ahabo nyny my. Kawatawy humo hi ikiahatsa ba ahaspirikpo — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","— Amy skaraba batu wasani tsimykaranaha. Wasani tsimaha zeka aba kahumo ahaspirikpo. Ikiahatsa batu wasani tsimaha zeka maku wata atahi niharapesohometukuta. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Iske buruk tsimokurunahaze kytsawabytsitsa bo sisukmobyi tu harape humo tsimynakokonaha. Iske buruk kokoha byizeka maku itsipa humo pioktyhyryk. Ikia sakyriukanikitsa hurukwy bo tsipahurukwy. ");
INSERT INTO rkbNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Aokyrysaro ty nyny ahabyizeka ba zikzoik. Aokyrysaro ty nynybaik ahabyizeka ba zikzoik. ");
INSERT INTO rkbNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kyze wastuhu kytsa Sesus bo zumukunaha. Piratus soho ty nipamykysokonaha. Piratus sodadutsa nisipehanahatsa wastuhu Karireja ezektsa nisibabakanaha. Kytsa Deus wahoro eze nisibabakaranaha. Deus bo siraratsa ty nyny nikaranahaze kytsa nisibabakanaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Sesus ispe niy: — Ahaokze ka asaktsa simysapybyikitsa tu iwatsahi sinini niaha. Batu ba. ");
INSERT INTO rkbNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Wasani ahape mykara. Ikiahatsa ahamysopyksapybyri ty moewy ahabyizeka tsimyokbabanaha. Karireja ezektsa wa tsimyokbabanaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Deus harere bo yhỹ ahabyi zeka tsimyokbabanaha. Kytsa Siroã eze tu anaeze wahoro zuba kytsa bete inakzuruhukze inasipyk. Ahaokzeka asaktsa simysapybyitsa tu iwatsahi sinini niaha. Batu ba. ");
INSERT INTO rkbNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ikiahatsa ahasopyksapybyri ty moewy ahabyizeka siwa tsimyokbabanaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Sesus nipamykysokozo. Umaha soho humo ziwatawyky. Nipamykysoko simysapybyitsa moewy ahabyizeka hawa my niy. Umaha humo mytsatyziutaha. — Maku estuba umaha waratok eze ziparik. Kyze ihara ziberikize batu iharaka niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Iwatahi waratok perytsa pe niy: “Hwi tsiwehikta! Amy skaraba iharahokbyitatu mopykyk. Tsiwehikta” niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Waratok perytsa ipe niy: “Kapehatsa niwatihikta! Aba hwi mytyktsehezoze piokpyrytete siraratsa tsitsi ty myziokpyry haratõtõ. ");
INSERT INTO rkbNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kyze mytyktsehezoze tahara zeka wasani. Ziktahara byizeka tsikpipehazo zeka uta piwehik” niy — Sesus nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Kyze mybyrykywy eze Sesus Deus wahoro eze nisihyrinymyry. ");
INSERT INTO rkbNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Iwaze wytyk izumu. Tubabatu sinini ziknakara. Hyrikoso isapybara humo batu iaku. Okmymyhuk ahatatsa tu zikzitabaka. ");
INSERT INTO rkbNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Sesus zinyze atatsa pe niy: — Ikia botu tsikzororotsa — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ibete tatsyhyrype ty paik niy. Atsoko buruhuwa niyzikzo. Deus bo nisakibaziki: — O Deus ikiahi kahumo tsamysapyrẽta — nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Taparaktsa Deus wahoro eze. Sesus humo tahakyrikinaha. Sesus mybyrykywy eze wytyk zizororowy. Iwatsahi taparaktsa tahakyrikinaha. Kytsa pe niaha: — Ustsa tsyhyrype humo estuba zuba tarabaja tsimaha! Tarabaja mybyrykywy eze batu imysapy. Katsa mybyrykywy eze batu tarabaja Deus harere humo nikaranaha. Usta nawa zuruze tsimyzumunaha. Mybyrykywy eze ka batu isty zororo ziky — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Sesus ispe niy: — Ahaharawatahatsitsa! Mybyrykywy eze tarabaja tsimaha. Ikiahatsa pikuza buhu kino niwatihi isparik ikny tsipisatsuknaha. Pihik bo tysioktyhyknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Uta hi wasani my mybyrykywy eze atatsa izororowy. Atatsa Abarão tsekoka. Tubabatu Satanas ziporokmyitatsa iwatatsahi ba buruhuwa ziktoziky niy — Sesus nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Sesus nipamykysokoze sisukyrytsitsa hi sisikpybyrẽtsa niyziknaha. Kytsa sizubarẽtsa Sesus humo sakurẽtsa niapykyknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Sesus sizubarẽtsa bo nipamykysokozo. Deus tyryktsa soho humo nisihyrinymyryky. Sesus tihi: — Deus tyryktsa hawa sa maha Pahawatawyky. ");
INSERT INTO rkbNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Hawa rik tsibik taypykze Deus tyryktsa sizubarẽtsa moziknaha. Deus tyryktsa rik tsibik wata. Mostarada rik wata mysiubaraka niy. Taparaka maku waratok eze ziparikik iwaze taypykze hwi puẽtsikbyita mozik. Piyktsa isarapatsa bete tahasukuknaha tahasuk pizozokonaha. Isarapatsa watu tahasukuknaha. Hawa mostarada wata mysiubara Deus tyryktsa mysiubara. ");
INSERT INTO rkbNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Sesus nipamykysokozo: — Deus tyryktsa hawa sa maha. Pahawatawyky. Deus tyryktsa ipytowy hyrity waha. ");
INSERT INTO rkbNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Tapara atatsa ipytowy tsikaeni zuba tiriko mytsakyky pok niy. Napytoze piharazo. Hawa atsikara napyto, nahawa Deus tyryktsa sizubarẽtsa moziknaha. Tapara Deus tyryktsa hudikhudikwy estuba zuba bo maha. Aibani nanabyitaba maha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Sesus Serusarẽhe bo niukuru. Nanabyitaba sihudikhudikwy bo zikzumuku. Anaeze sizubarẽtsa nisihyrinymyryky. Nanabyitaba nisihyrinymyryky. ");
INSERT INTO rkbNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Niytahi amata Sesus pe niy: — O hawa skaraba mypehakatsa sizubabyitsa sa Deus bijoikpe bo mysioktyhyryk — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Sesus ipe niy: — Bijoikpe ka hokbowy wata. Hawa kytsa hokbowy buruk mopupunaha anawahi kytsa bijoikpe bo mopupunaha. Bijoikpe hokbowyta batu jakebyita tu. Iwatsahi sizubarẽtsa mopupu tsihikiknaha. Ba zikpupunaha. Nawa zuruze kytsa ba ziknapupunaha. Bijoikpe ske tsihokdaharẽta. ");
INSERT INTO rkbNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Wahoro tsihitsa kyik niyze zihokbowyhik. Ikiahatsa ape baze tototo tsimykaranaha. Ape baze hua hua tsimykaranaha. “O kapehatsa hokbowy ty zoksoparety” tsimaha. Iwaze ahape my. “O ikiahatsaktsa kanyhybyitsa. Hana iknytsa skaraba” my. Iwaze hi ikiahatsa ipe tsimaha: ");
INSERT INTO rkbNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Katsaktsa ikia tuk ziknamydisahakanahatsa. Ikia tuk zikzikukunahatsa ikia myhudikhudikwy eze katsa tsikmyhyrinymyryky.” tsimaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ispe myzo: “Ikiahatsaktsa kanyhybyitsa. Hana iknyktsa skaraba tsimykaranaha. Ahamysapybyitsa tu tsikykaranaha iwatsahi ba ziknapupunaha. Nabo pãotaha paku paku byitaha” my. ");
INSERT INTO rkbNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Deus tyryktsa tsimysinynaha zeka ahasukatsihikrẽtsa. Tsimypuziukunaha. Abarão, Isake, Sako, Deus sohokotsa iwatsa tsimysinynahaze tahatsaputsa ty dydydy tahakyri humo iwatsahi tsimopuziukunaha. Ikiahatsa hi Deus tyryktsa byitsa tsimaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Kytsa sizubarẽtsa nanabyitaba mozumunahatsa. Deus tyryktsa tazaha eze dyhy dyhy maha. ");
INSERT INTO rkbNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Wabytaha! Aba kytsa ziharawytsa myharazektsa moziknaha. Abaka siapikwaktsa hi Deus tyryktsa moziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Iwazektsahi wastuhu Pariseutsa zumukunaha, Sesus pe niaha: — O nibo tihi tsiksita. Erodes pabezetsihikik — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Sesus ispe niy: — Aidy Erodes tsoromama wakata, ipe tsimaha: “Aba, byiri kino niwatihi hyrikoso sapybara mosiksiwyky. Sizubarẽtsa mysizororowy. Kyze kahyriziktsokzawy pepykze mohyrikosokda. ");
INSERT INTO rkbNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Iwaze harakykbyihi puruze kaske buruk mokuru. Deus sohokotsa Serusarẽhe eze nisibabaiknaha. Uta kino niwatihi Serusarẽhe eze mohyrikosokda.” Iwa Erodes pe tsimaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Sesus tihi: — O Serusarẽhe ezektsa ikiahatsa Deus sohokotsa tsiksibanaha. Deus nispehanahatsitsa haraharetsa ty tsiksibanaha. Hawa ahahumo tsimypokzitsiarẽta kokuaro watatsa. Kokuaro tahyrytsa tasara paik puke bo mysihuruk ezektatsa watatsa. Iwa uta ahahumo kamypokzitsiarẽta. Ikiahatsa kabaze batu yhỹ tsikaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Wabytaha! Uta piksi maku tawahoro perikik tawata. Kytsa wahoro inakarabaik. Deus tihi hudikhudikwy soho nakarakbaik niy. Uta ape my ikiahaka ba ziknyzonaha. Ikiahatsa tsimytsasokonaha zeka, “Atakta Deus zipehata myziksizo tsimaha ihumo mykurẽtsa tsimoziknaha, iharere bo hyỹ tsimaha. Iwaze ihumo mykurẽtsa tsimoziknaha” iwaze tsipiknyzonaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Mybyrykywy eze Sesus Pariseu wahoro bo nitsuk. Taparakta ypykyhyta Sesus ituk tadisahaka. Anaeze kytsa sizubarẽtsa Sesus bo nikozotoktokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Iwaze maku Sesus bo izumu. Tsimyitsapyrẽta. Natsipatsawiwibaik tahi ihyrypyrytsa humo kino niwatihi iwatahi asiba nira. Kytsa Sesus bo nikozotoktokonaha. — Tozeka ja mybyrykywy eze Sesus pizororowy — mytsaty nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Iwatahi Sesus Pariseutsa, Moises harere humo zinymyrykynahatsa kino niwatihi ispe niy: — Hawa skaraba mybyrykywy eze botu ziwatahakanaha. Pizororowy ja tsimykaranaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Iwatsahi batu pykpyk zuba niaha. Batu ibo tyso. Niytahi Sesus maku humo paik niyze zizororowy. Iwaze tsiksita niy. Niytahi izororohota tawahoro bo ziksi. ");
INSERT INTO rkbNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Bykyze Sesus ispe niy: — Ikiahatsa ja. Ikiahatsa tihi: “O mybyrykywy eze tsipizororowynaha zeka batu sapy tsimaha.” Sesus kytsa mysizororowyze batu sapy tsimaha. Mytsatyziu tsimaha. Aty ahatuk hyriziktsokzawy my. Kyze mybyrykywy eze pikuza wytyk hoke bo mynaraha zeka aidy sukyhyporok. Atse wytyk hoke bo mynarahazuk zeka aidy sukyzotaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Iwatsahi Pariseutsa nihareretsihikbyrinaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Kyze Sesus sakzohotsa bo iktsa niyze, asahi sisapyrẽtsa bete zuba itahadyhydyhykynaha. Iwatahi sisoho humo nitsasoko, simyikaha soho humo ziwatawyky. ");
INSERT INTO rkbNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","— Mysukzawy myikaha bo pakzo zeka. Mydyhydyhywytsa tisapyrẽtsa bete ka ba dyhy zikaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Tozeka ja maku myhyrizikwanita mozumu zeka iwaze tamyikahakata ape my: “Kyiktykta! Ikiakta meky botu dyhy tykta!” my. Iwaze isapybyita bete dyhy my. Zihitsa nitsasokoze ikia asikpyby tsipiyk. Ikia pakzo zeka pykyhytuty myhyrizikwybyitsa tuk dyhy ty. ");
INSERT INTO rkbNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Iwaze hi zihitsa ikia pe my: “O ikiakta katsa mytuk tsikadisahata my. Yhỹ” tsimy. Taparaka isapybara bete tu dyhy tsimy. Pakzo zeka pykyhy myhyrizikwybyitsa baze dyhy tsimy. Zihitsa myikaha adyhywy bo mozumu. Iwaze hi: “Katukta, anaeze dyhy tyny” my. Iwaze maku myhyrizikwanita baze dyhy tsimy niy. Nitsasokoze kytsa okzeka ikia aspirikporẽta. Kytsa ahatuk tahadisahakanahaze ahumo sispirikporẽtsa iwatsahi kytsa okzeka wasani tsimy. ");
INSERT INTO rkbNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Iwaze hi aty mytsaty “Utakta myhyrizikwani my zeka” atahi tisikpybyrẽta mozik. Aty tapetu isopyk “O aty utakta myhyrizikwybyita my zeka pykyhy tu isopyk” my. Iwa mytsaty mykara zeka wasani my. Atahi myhyrizikwani mozik — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kyze Sesus zihitsa pe: — Ikia tsipamyikahaze atukytsa, ahaõtutsa pauktsitsa ahaharereziuwytsa sinamynikitsa ka asa ty ka ykzo ykzo byity. Bykyze pakzonaha iwaze situk tsipadisaha. Iwa ikia botu nynyrezo maha. Iwatahi batu isty ykzo. ");
INSERT INTO rkbNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ikia tsipamyikaha zeka sinamybyikitsa ty siekbyritsa ty sihyrizikubyitsa ty iwatsa zuba tynasiakzo. ");
INSERT INTO rkbNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Iwaze hi tsakurẽta. Iwaze asaktsa kytsa ikia batu aty ykzozo. Batu ikia bo ka nyny zikaha. Deus zuba ikia bo nyny my. Iwa puruze simysapyrẽtsa mynahyrizikponahaze Deus ihuak ty abo nyny my. ");
INSERT INTO rkbNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Maku estuba disahawyzozowy baze nidyhyky ana ziwabyze Sesus pe niy. — O Deus tyryktsa aparakbaha sakurẽtsa. Deus tyryktsa tuk tahadisahakanahaze sakurẽtsa. ");
INSERT INTO rkbNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Kyze iwatahi Sesus nipamykysoko. — Kyze estuba maku myikaha zihitsa mozik. Sizubarẽtsa nisiakzoko. ");
INSERT INTO rkbNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Imyikaha inakymyze itsumuẽhĩtsa sakzohotsa bo nisipeha ispe niy: “Pany kamyikaha inakymy” nikara. Yhỹ niy. Iwaze sakzohotsa bo niparak. Kytsa batu zuk. ");
INSERT INTO rkbNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Sakzohotsa batu yhỹ niaha. Tapara estuba itsumuẽhĩtsa pe niy: “O uta zik batu, waratok iakse. Tapara uta katsuhuk bo mynakozore.” niy. Iwatahi ikia zihitsa pe tsimy. “Waratok iakse tahi batu pão my” niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Iwaze usta itsumuẽhĩtsa pe niy: “Uta zik batu, pikuzatsa mytsyhyrytsa wa iksiakse. Aba sibo iktsa my, hawa ja mykaranaha. Iwatahi imyikaha bo ba zikparak” niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Usta ziharawy niwatihi tsumuẽhĩtsa pe niy: “Jaba iksukza iwatahi ba imyikaha bo ba zikumu” niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Iwaze itsumuẽhĩtsa ziksizo. Tamyikahakata bo nitsasobaik. Tamyikahakata ana ziwabykytahi taokaniki. Niytahi tatsumuẽhĩtsa pe niy: “Aidykta! Nanabyitaba sihudikhudikwy taba! Ske buruk tykuru! Sinamybyikitsa siekbyritsa sihyrizikubyitsa pãozikahabyitsa iwahatsa tynasioktyhyryknaha” niy! Hyỹ niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ziksizoze itsarawybara kino anatu niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Kyze zihitsa ipe niyzo: “Nabo pãozotykta! Ske buruktsa bo tsimy. Hỹbyri mykaranahatsa tuktu tynasioktyhyk. Iwaze kawahoro mynahareknaha” niy. Iwaze itsumuẽhĩtsa sihudikhudikwy taba niparakzo. Iwaze tamyikahakata wahoro bo nasioktyhyryk. Abaka mydyhydyhywytsa tsarawykytsa zuba. Batu iwewehe bara eze tu nikara — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","— Uta tapara baba iksiakzonahatsa hi kadisahawy ty batu hauk zikaha — Sesus niy. Iwa kytsa soho asaktsa Deus harere bo batu yhỹ niaha ana humo hi nisiwatawyky. ");
INSERT INTO rkbNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Kyze myzubaha Sesus tuk niukurunaha. Sesus tasukpe bo iktsa nikara. Nipamykysoko. ");
INSERT INTO rkbNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","— Aty katukta babata mozihikik zeka. Kaharere humo zinymyrykyta mozik. Atakta kahumo tsimypokzitsiarẽtakta my. Uta tsipikpokzitsiziu zeka uta kino wasani my. Bykyze zuba itukta, izo, ije, ioke, ihyrytsa itukytsa iwatsa mysipokzitsi. ");
INSERT INTO rkbNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Tapara kahumo pikpokzitsi baba. Bykyze itukytsa zuba. Iwa myzeka katukbabata mozik — niy. Sesus tihi: — Ikiahatsa sinini tsimykaranaha zeka ja ana hi tsipazoziknaha. Maku iharapatawyhyta pebykyrykze mohyrikosokda atawahi tsimaha. Aty maku harapatawyhyta zebykyrykta wata atahi katukta mozik. Atakta iharapatawyhyta puhyryk ahabyizeka ba katukta zikyzik. Katukta babata sinini mykara tsipazoziknaha maku harapatawyhyta zebykyrykta wata my atatu hawaziy — niy. Iwatahi Sesus nipamykysokozo. ");
INSERT INTO rkbNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","— Zihyrinymyrykyta my zeka taparaka mytsatyziu tsimaha. Aty wahoro mozukni zeka tapara mytsatyziu my. Kyze maku wahoro jobonita mozukni tsihikik zeka tapara dyhy my iwaze tatuk zuba mytsatyziu mykara. Kaokyrysaro tsizubarẽna zeka. Iokyrysaro izubabyizeka myziakbata zuba iwazeka ba zikymy. ");
INSERT INTO rkbNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Iwaze kytsa sizubarẽtsa wahoro bo iktsa maha zeka pimyijanaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Asahi: “O atakta ziakbata tatu batu ikymyhuk” nikaranaha. Hawa maku taparaka wahoro soho bo mytsatyziu niy, ikiahatsa niwatihi katuk tsinymyrykynahatsa tsimaha zeka mytsatyziutaha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Sesus nipamykysokozo tasoho humo nisihyrinymyryky. Ispehatsa wata mytsatyziutahaktsa! — Kyze aty sodadutsa pehakatsa des miutsa sodadutsa tuk mowatsoronahaze takyriwytsitsa bo maha. Tapara aparakbyitu mytsatyziuty. Sihyrinymyrykytsa pe my: “Mysukyrytsitsa sodadutsa tozeka ja abazuba” my. Sihyrinymyryrẽtsa pehatsa bo motsasonaha zeka: “O mypehakatsa mysukyrytsitsa sodadutsa wĩte miutsa abazubatsa maha. Iwatsahi katsa ba zikwatsoronaha” maha. ");
INSERT INTO rkbNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Iwaze hi ẽryktsa botu takyriwytsitsa bo kytsa mysipehaka. Ispe niaha: “O pão pão byitahaktsa tsimaha” maha. Ba zikwatsoro — iwa Sesus nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","— Iwa ikiahatsa ahanamy ty arek ahabyizeka ikia batu katukta babata zikyzik. Hawa ispehatsa sodadutsa soho humo mytsatyziu nikaranaha ikiahatsa niwatihi katuk zinymyrykynahatsa tsimaha zeka mytsatyziu tsimaha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","35","— Zinymyrykyta babata poro waha. Poro titsarakrẽna my. Iwa poro waha tsimahaktsa. Poro itsarỹk byizeka batu tykykyzo my. Batu zik. Poro itsarỹk byizeka wytyk tuktu zeka isapybara mozik. Poro itsarỹk byizeka tsipipaparanaha itsarỹk byizeka istsitsi humo batu isapy iwatahi istsitsi ty batu tyharatoto. Tsipipaparabaiknaha zuba. Ikiahatsa kaharere ty wabyziu ahabyizeka poro itsarỹkbara waha tsimoziknaha, ahamysapybyitsa tsimoziknaha. Iwatsahi ikiahatsa kaharere tsipiwabytoktonaha. Pykyhytu tahaktsa! Tsipiwabyziunaha zeka kaharere bo yhỹ tsimaha. Niahatsahi katuk zinymyrykynahatsa babatsa tsimoziknaha — Sesus nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Kyze okyrysaro bykyktsitsa, tahapehatsa tsyhyryze zebykyryknaha. Asahi Sesus bo zumukunaha. Simysapybyitsa nikaranaha niwatihi ibo zumukunaha. Myzubaha Sesus harere ziwaby tsihikiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Pariseutsa kytsa Deus harere nisihyrinymyrykynahatsitsa kino niwatihi Sesus zisapybyrikinaha. — Atakta simysapybyikitsa tuk iakparawy. Kytsa simysapybyikitsa nikaranaha situk tadisahaka — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Sesus ana ziwabytahi kytsa bo nipamykysoko: ");
INSERT INTO rkbNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","— Kyze aty hozipyrykzatsa humo tsiraratsahohokrẽta zeka. Iwaze nubaze taokarawy bo myziksinahaze estuba nikyrybyri iwa nizarata. Iwatahi nizarata pokzi piberiki tisukatsihikrẽta kyzekta ustsa tyka amytsĩ eze nisierekek. Nokponi hozipyrykza arara nizarata piberiki. Ustsa ty ka erekek niy. Tapara nizarata piberi. Hana bo skaraba my. Tyberi beri ibo typiktumuzo niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Myzikahazoze arara hozipyrykza isukyriki buruk korohyk my. Nizarata tu zisihykzo. Nizarata humo tsakurẽta nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Atsoko iwahoro bo piksi. Taotutsa pauktsitsa bo piksizoze ispe my: “Ikiahatsa katuk ahakurẽtsa tykaranaha karara hozipyrykza nizarata tu ikzikahazo” my. Wasani nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Iwaze bijoikpe iknytsitsa sizubarẽtsa sisopyksapybyitsa nikaranaha Deus botu nisiokzohik anahumo hi sakurẽtsa. Maku estuba tapara imysapybyita nikara iwaze Deus harere bo hyỹ nikara. Atakta hozipyrykza nizarata zikahazo tawata. Atahi Deus harere bo hyỹ my zeka bijoikpe iknyktsitsa ihumo sakurẽtsa nikaranaha. Aparakbaha humo sakurẽtsa. Deus imysapybyita tu ziknakarata ziokzohikze bijoikpe iknyktsitsa kino ihumo sakurẽtsa — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Sesus nikarazo sizubarẽtsa bo atsawatu nitsasokozo: — Estuba wytyk mytsozikewy tsizubarẽna niy. Mytsozikewy mytsyhyrytsa waha parata hi. Estuba pihokda zeka iwatatsahi mytsozikewy piberi. ");
INSERT INTO rkbNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Wahoro ke bo piberiki. Tykahabyize rika ty hupok my. Tawaharo pioketsyktsyk. Itsozikewy humo tahi zikwatu piberiki, itsozikewy izikahaze atatsa tatukykyryk pe niy: “O katuk ahakurẽza ky. Katsozikewy nihokdata tu ikzikahazo. Wasani mykara” niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Atatsa tatsozikewy zikaha atatsa tsakurẽtatsa. Maku estuba tapara imysapybyikita ziknakara iwaze Deus harere bo hyỹ mykara zeka bijoikpe iknyktsitsa Deus tsumuẽhĩtsitsa ihumo atatsa watatsa sakurẽtsa. ");
INSERT INTO rkbNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Deus kytsa humo tsimypokzitsiukrẽta niy. Sesus nipamykysokozo. Maku petoktsahatsa ihyrytsa. ");
INSERT INTO rkbNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Iypykziubyitahi: — O kazo mybo anamy ty nynytykta! Kaziky bo, uta kabo tsimy — niy. Hyỹ niy. Tanamy ty sibo nyny niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Byri puẽtsik iypykziubyita tanamy zizozoko. Iwatahi meky botu niukuru. Mektsa botu tasapy. Anaeze isopyksapybyita nikara. Tanamy ziwebaik zuba. ");
INSERT INTO rkbNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kyze nepykbaze ba amy tohi humo ba ziktadisaha, ata kino niwatihi batu idisahawyky. Tarapaspyk. Iwatahi anaeze sihudikhudikwy eze estuba zuba tabo paku niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Atakta: — O nabo pazaharezatsa tysidisahawykta! — niy. Iypykziubyita iarapa zumuze. ");
INSERT INTO rkbNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","— O karaparẽta. Utakta pazaharezatsa disahawy ty pikdisaha tsihikik — niy. Batu. Ba aty tohi ibo nyny ziky. ");
INSERT INTO rkbNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kyze mytsaty nikara. — O nabo kazo baze zuba mydisahawy momoewyky zuba. ");
INSERT INTO rkbNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Kazokta tsidisahawyrẽta. Karapaspyk mohyrikosokdaka. Piksizoze. Kazo pe my: “O kazo utakta kasopyksapykbyita ikykara. Ikiakta ba kape katse tsimy. ");
INSERT INTO rkbNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Atsebyitatu zeka abaze zuba atuktu my. Iwatatu tarabajaziu my” — niy. Iwatahi ziksizo. Tazo zerekek tatu iwatatu ziksizo. ");
INSERT INTO rkbNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Kyze izo ziperyky. Itse zumukuze waratok sak eze tatse bo nikozo, nokponi eze tu izo ibo nikozo. Isukziubyita nikorotso. Iwaze izo ihumo imypokzitsi izumu. Iokeryk niparak tatse zihapyrykyk. ");
INSERT INTO rkbNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Itse: — O utakta kasopyksapybyita ikykara kazo Deus okze kamysapybyita ikykara. Ikia kape ba katse tsimy — niy. Iwaze izo. ");
INSERT INTO rkbNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","— O kytsa aidyktaha katsumuẽhĩtsitsa katse suk ty iziuha ty zuba wabehyrytynaha! Katse humo korobyktaha. Inahatsa ipyrysuktsa humo kino niwatihi wabehyryktyny — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Aidytaha pikuza tsibezenaha. Kamyikaha nakymy. O kakurẽta. Atakta katse asiba nihyrikosokdata tu atatu. ");
INSERT INTO rkbNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Nokponi tasapyta tu kabo ziksizo niy. Yhỹ O mykurẽtsa wahoro ezektsa kino niwatihi nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Kyze usta ziky taparakta ypykyhy waratok ikny ziksita. Berekzetsa suka ziwaby kytsa nikarikinaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Iwaze tazo tsumuẽhĩtsa pe niy: — “O niytahi amy skaraba” niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“O atsy ziksizo. Azo pikuza zibeze tamyikaha bete zibeze. Tsakurẽta. Atsy batu ihyrikosokda ibo ziksizo. Tsakurẽta” niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","30","“O batu imysapy. Utakta ba ziktsuk. Kaokanirẽta” niy. Bykyze sizo izoize ipe niy: “O ikia kino pakutynykta katse. Tsikadisaha” niy. “Batu. O atuk mynapykyryk ta tu. Tsimyzikpehakaze uta hyỹ mynakara. Iwatatu batu katy myikaha. Batu pikuza ty tybeze. Atse anamy ziaksebaikta tu iwaze wytykyryk humo ziwebaik, iwaze anamy zipykta tu sa ziksizoze tumy tsipikuku itsyhyryze pikuza tsibeze” niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","32","Izo ipe niyzo: “O katse ikiakta katuk hi tsimynapykyryk. Uta kanamy atsatu natawihikik. Niwatsa tu abaka mykurẽtsa tsimykaranaha. Tumy takuku. Wasani my. Atsy asiba nihyrikosokda iwatatu atatu. Nizarata wata ziksizo” niy. Aty imysapybara ty nikaratatu zimoewy, Deus humo tispirikporẽta iypykbyita wata. Maku imysapybyita tu my zeka pimoewy Deus bo myziksizo iwaze Deus mysiokzohik. Iypykziubyita wata tazo bo ziksizo — iwa Sesus nisispirikpoko. Deus myzubaha humo tsimypokzitsiukrẽta nisispirikpoko. ");
INSERT INTO rkbNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Kyze Sesus tuk zinymyrykynahatsa pe niyzo. Kytsa Deus harere bo batu yhỹ nikaranaha iwatsa tu sihyrinymyrẽtsa, tahanamy soho humo zuba sihyrinymyrẽtsa. Sisoho nisiwatawyky. — Kyze estuba maku inamyrẽnikita niapykyryk. Itsumuẽhĩtsa inamy ziperyky. Atahi inamyrẽnikita tsyhyryze okyrysaro zikzibykyk, ana hi ihyriziktsokzawy. Iwaze kytsa inamyrẽnikita bo zumukunaha. Ipe niaha: “O atsumuẽhĩtsa ba aokyrysaro bykyktsa hi anamy ziakseke. Atahi anamy piwebaka. Aokyrysaro humo batu wasani zeky, mybarapetu mykara” niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Iwaze maku inamyrẽnikita iperykytsa pe niy: “Hawa skaraba wasape hi sa asoho humo nikaranaha” niy. “Kaokyrysaro ty kabo zozotyny. Ikia kaokyrysaro ty kabo tysirezoty. Ikiakta paiksiwyhik kanamy perytsa ba zikziksizo. Mektatu maku kanamy perytsa mozik” niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Iperytsa tapetu isopyk: “O maku inamyrẽnikita kape niy ‘Nabo pãotykta’ niy. Mektatu maku inamyperytsa mozik. Iwaze uta sa hawa my. Uta wytyk piu naha humo batu kapaik. Kytsa bo okyrysaro humo kamykzasikpybyrẽta. ");
INSERT INTO rkbNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Uta kahyrinymyrẽta. Iwatatu myperybyitatuze kytsa inamyrẽnikita bo okyrysaro pisirezonahaze siharereziuwy mozik. Asa wahoro bo hi mytsuk. Kytsa: ‘O mywahoro bo paku tsimy. Ikia katsa mytuk tynapykyrykspyk’ maha” niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Iwatahi kytsa sizubarẽtsa nisipeha. Kytsa inamyrẽnikita bo okyrysaro zisirezonaha nisipehaka. Iwaze tapãbabakta pe niy. “Hawa sa maku inamyrẽnikita bo okyrysaro ty nynyrezo tsimy” niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“O situtawy tsizubarẽna, tsihohokrẽna” niy. Yhỹ nikara. “Iktsa ty apapeu ty abo nyny my. Anaeze dyhyty! Aidyty! Tsapukte eze zuba apapeu humo tsipiwatahaka. Nawa zuba tysirezo tsimy” niy. Yhỹ niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Kyze iperytsa usta pe niy: “Ikia ja. Hawa sa maku inamyrẽnikita nynyrezo tsimy” niy: “O wanatsitsa sizubarẽtsa tsihohokrẽtsa” niy. Yhỹ nikara. “Iktsa ty apapeu ty abo wabehyrykty. Ikia za tsapukte zuba apapeu humo tsipiwatahaka. Nawa zuba tysirezo tsimy” niy. Iwaze iharereziuwy niyzik. ");
INSERT INTO rkbNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Iwatahi maku inamyrẽnikita tatsumuẽhĩtsa soho bo mytsaty mykara: “O atakta kanamyperytsa tsihyrinymyrẽta babata. Iwatatu imysapy byitatu tsihyrinymyrẽta” — niy. Iwa mytsaty nikara inamyperytsa soho niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Iwaze Sesus tuk zinymyrykynahatsa bo nitsasokozo, okyrysaro soho humo nisispirikpoko. Sesus ispe niy: — Abaktsa kytsa tahanamy bo zuba mytsaty mynakaranaha iwatsahi sihyrinymyrẽtsa. Katyryktsa asahi Deus harere bo hyỹ mykaranaha. Okyrysaro soho humo batu sihyrinymyryziu iwatsahi tsinymyrykynaha — niy. — Kytsa tsyhyryze ahaokyrysaro ty natawihikik. Iwaze tsimyhyrikosokdanahaze ahanamy Deus tuk tsimaha. Bykyze Deus tsipihobyknahaze asa humo ahaokyrysaro tsiwihiknaha ahahumo sakurẽtsa iwatsahi ahabo wasani tynakaranahaktsa. ");
INSERT INTO rkbNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Kyze ikiahatsa ja ahanamy zuba tsikaeni tsimaha zeka situk wasani tsimykaranaha iwaze ikiahatsa ahanamy tsizubarẽna tsimaha zeka situk niwatihi wasani tsimykaranaha. Ikiahatsa ja ahanamy zuba tsikaeni tsimaha zeka situk batu wasani tsimykaranaha. Iwaze ahanamy tsizubarẽna tsimaha zeka niwatihi situk batu wasani tsimykaranaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","— Ikiahatsa namy zuba tsikaeni tsimaha zeka situk mybarapetu tsimykaranaha. Kytsa ahaokyrysaro humo tsimysispihikbatakanaha zeka ba zikspirikponaha. Ikiahatsa ahaspirikpo byizeka Deus isapyrẽnikia ty ba ahabo nyny ziky. ");
INSERT INTO rkbNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ikiahatsa mektsa namy ty pykyhytu ahabyizeka, batu aty tohi ahanamy ty nynyzo ziky. ");
INSERT INTO rkbNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Kyze ba aty tohi petoktsahatsa ipehatsitsa bo ziky myhyriziktsokzawy humo my zeka. Itsumuẽhĩtsa petoktsa hatsa bo ba zikaha. Petoktsa hatsa tsimysitsumuẽhĩnaha zeka estuba hi akparawy mozik. Ustakta akparawybyita mozik. Sitsumuẽhĩtsa mytsaty nikara: “O estuba zuba kakparawy. Ustakta batu kakparawy” Iwa mytsaty nikara. Sesus ispe niy ikiahatsa niwatihi. Deus harere bo hyỹ tsimaha zeka iwaze okyrysaro ty iokboha zuba ahakparawy. Ikiahatsa okyrysaro humo zuba ahakparawy zeka iwaze Deus harere bo batu yhỹ tsimaha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pariseutsa Sesus harere ziwabynahaze iharere okyrysaro soho humo tahakyrikinaha. Asahi okyrysaro siakparawy iwatsahi zimyijakanaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Niytahi Sesus Pariseutsa bo nipamykysokoze ispe niy: — Ikiahatsa kytsa okze tsinakaranaha: “O katsaktsa wasani tsimykaranaha” ahasopyk. Deus ahahumo tsihyrinymyrẽta. Wasanibara humo tsihyrinymyrẽta. Hawa mytsaty tsimykaranaha humo tsihyrinymyrẽta. Kytsa ahasoho bo mytsaty mykaranahaze: “O wasani mykaranaha” mytsaty ahabyitsa nikaranaha. Deus okzeka anaka imysapybara ty tsimykaranaha. Iwa Deus mytsaty nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Taparaktsa Moises harere zahahyrinymyryky Deus harere bo yhỹ nikaranaha. Taparaktsa Deus sohokotsa botu ziwatahakanaha ana humo hi sizubarẽtsa yhỹ nikaranaha. Iwatsa tu ziknapykyryknaha. Niytahi Suão Batista nipuruk. Iwaze Deus wasaniha nitsasoko. Kytsa bo wasaniha nitsaso: “Deus tyryktsa tuk mynapykyk. Taharere ba zimyi” niy. Abaka Deus sohokotsa atsatu mopamykysokonaha. Kytsa sizubarẽtsa Deus tyryktsa moziknaha. Sizubarẽtsa Deus harere ba zimyinaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Sesus nisihyrinymyrykyzo Deus harere soho, Deus harere tawahi mynapykyryk niy. Amy ty taparaktsa, Deus sohokotsitsa botu ziwatahakanaha, ba zikokza. Bijoikpe mopyk naha humo ba ihokdaha wytyk mopyk naha humo kino ba ihokdaha. Deus iwatahaha ba zikokda. Ziwatahaka naha tsikaeni zuba ba zikokda. Mybarawy mopykze kino siwatahaha tawahi mynapykyk. Deus harere mynapykyk. Iwa Sesus nisihyrinymyrykyzoze niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","— Maku tasukza zeka ba mektatsa tu ziakse. Aty taoke pimoewy zeka mektatsa tu piakse zeka Deus okzeka batu imysapy. Iwaze wytyk kino niwatihi. Atatsa kino tabarikta pimoewy zeka mektatu piakse zeka Deus okzeka batu imysapy. Atatsa batu imysapy — Sesus ispe niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Sesus nisispirikpokozo. Abaka kytsa Deus harere bo hyỹ mykaranaha. Aiba ka iharere bo ba yhỹ zikaha. Sesus tihi: — Kyze maku estuba inamyrẽnikita tadisahawy humo zikzibyituhukutu isapyha ty zuba ziknakara. Tasuk ty ka ipokzitsia ty zuba ziknakara. Iwaze hi ziknatamyikahaka. ");
INSERT INTO rkbNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Iwaze usta maku inamybyita. Rasaru inarokota inakõrõrõbaikta. Atahi inamyrẽnikita hokbowy baze ziknadyhyky. ");
INSERT INTO rkbNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Tadisahawy zikziperyky. Inamyrẽnikita tisorekrẽta hi batu ibo nyny ziknakara. Tadisahawy tsihizik humo kino ba nyny ziknakara. Iwaze inamybyikita itsuhuha ty zuba ziknatadisahaka. Tsikuparinitsa iakõrõrõtsa ziknasihierokok. ");
INSERT INTO rkbNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Iwaze Rasaru nihyrikosokda. Bijoikpe iknytsitsa Abarão bo zioktyhyryknaha. Abarão Deus baze mynapykyryk. Anabo bijoikpe iknytsitsa inamybyikita zioktyhyryknaha. Inamyrẽnikita kino niwatihi nihyrikosokda kytsa ziytyknaha. Iwaze inamyrẽnikita hyrizikararawy sinini ykarawy bo tasapy, anaeze sinini mynakara. ");
INSERT INTO rkbNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Inamyrẽnikita kytsa simysapybyikitsa sapy bo zumu. Iwaze nokponi Abarão bo iktsa niy. Rasaru kino ituk niapykyryk. Abaka inamyrẽnikita sinini mynakarata Abarão bo iktsa niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Iwaze Abarão bo huahua niy: “O kazo kahumo amypokzitsiukta! Ikia Rasaru kabo tyzipehakta. Tatsyhyry humo pihik ty sokyk ziyk. Sok my zeka bykyze atahi kastiãrik bo tsikziny itsikwarika ty. Uta izo humo mokorobaka. Sinini mynakara” niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abarão ipe niy: “O batu ba. Ikia mytsatytykta! Ikia aokzetuze anamyrẽta ziknakara. Rasaru inamybyikita niy. Abaka Rasaru tsakurẽta. Ikia batu aku sinini tsimynakara” niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","“Nawahi ihoketsihirizezebara nisihiza my mytazaharaze. Aparakbaha usta taba batu zikaha. Ihoke ba zikskaputabanaha niaha. Aparakbaha katuk ikia bo batu koikny zikaha. Ikiahatsa kino niwatihi mybo ba zikziskaraputabanaha” niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Inamyrẽnikita tihi: “O kazo ikia pe my: ‘Rasaru kazo wahoro bo tsipehakta’ ");
INSERT INTO rkbNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Anaeze uta katukytsa mytsyhyry wa mopykyryknaha. Iwatahi tynasipehare. Iwa tsimyzeka katukytsa sinini ykarawy bo ba zikzumunaha” niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Niytahi Abarão ipe niy: “O Rasaru ba zipeha. Atukytsa Deus harere Moises ziwatahakanaha isohotsitsa kino niwatihi botu ziwatahakanaha nisisupehekenaha. Iwatahaha humo yhỹ maha zeka ba sinini ykarawy bo ba zikumunaha. Ana harere bo hyỹ mykaranaha zeka sinini ykarawy bo ba zikumunaha” niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“O batu ba kazo. Maku nihyrikosokdata iwaze nahyrizikpo sibo mozumu zeka iwaze Deus harere bo hyỹ mykaranaha. Simysapybyitsa nikaranaha pimoewynaha” niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abarão: “Batu ba” niy. “Atukytsa Deus harere bo ma ahabyi zeka. Hawa ha ty Deus sohokotsa ziwatahakanaha bo kino niwatihi ma ahabyizeka. Niahatsahi amata nahyrizikpo zeka Deus harere bo batu yhỹ maha ihumo batu sispirikpo maha.” niy — Sesus nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Kyze Sesus tuk zinymyrykynahatsa bo nipamykysokozo. Kytsa ustsa mysimyiwykynaha ana soho ty hi nipamykysoko. Kytsa simysapybyikitsa nikaranaha iwa nikaranaha. Atakta usta maku pimyiwyze sinini mykara. ");
INSERT INTO rkbNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Sesus: — Atakta harahare ty pisoikaĩhiknaha zeka buburu zuba bo mopapyknaha iwaze moharazuk, ana wa zeka batu sapy. Kytsa kahumo jokboha sispirikpo iwaze amata pimyiwyky iwatahi kahumo ispirikpobyritahi sinini ykarawy bo pipehahik tawahi sinini mynakara — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Sesus nisihyrinymyrykyzo. Ustsa kytsa pahasapybyinaha zeka tysiokzohik: — Pykyhytutaha! Atukytsa simysapybyitsa mykaranaha zeka ikia tsipipeha. Atahi imysapybyita nikara zeka anahumo hi tisukatsihikrẽta zeka tsiokzohik. ");
INSERT INTO rkbNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Niwatihi amata myzisapy byrikizeka ana humo hi batu iaku iwaze tsiokzohikzo. Imysapybyri ty ana nikara naha humo ba mytsaty tsimykara — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Sesus nisihyrinymyryky. Deus humo sispirikporẽtsa. Sesus ykzohotsa ipe niaha. Asahi: — O katsaktsa ikia humo myspirikporẽtsa. Aba katsa puẽtsik tymospirikpo — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Iwaze Sesus ispe niy: — Deus zikwy humo amy tsimyzapykykynahaze Deus ana humo hi hyỹ my. Tsimyzapykykynaha zeka umaha ataharatatsa tysibokbokyknaha iwaze buburu zuba bo piparik. Niytahi hwi zibokyk buburu zuba bo piparik. Ikiahatsa Deus humo tsimyspirikpobabanaha zeka iwatahi hwi zibokyk buburu zuba bo piparik. Ikiahatsa Deus humo ahaspirikporẽtsa mostarada rik wa. Niytahi Deus zikwy humo hwi zibokyk buburu zuba bo piparik — niy. Ahaspirikpo kino mostarada rik wa zeka iwazehi zeka umaha pe tsimaha. Aidy ikia tu hyrykokytyze buburu zuba bo piparik. Iwatahi my zeka hyỹ mykara. ");
INSERT INTO rkbNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Sesus nisihyrinymyryky: — Ikia atsumuẽhĩtsa waratok buruk ja mysiparikik. Hozipyrykzatsa ja mysisuparaka. Waratok ikny ziksize ikia ipe tsimy: “Aidytykta na bete dyhy ty! Tsikadisahakta” tsimy. ");
INSERT INTO rkbNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Iwa ba ziky. Atsumuẽhĩtsa hi papokzitsiki. Ikia ipe: “Asuk ty korokbykty! Kadisahawy ty! Mypewytsa ty wabehyrykty! Uta tapara pikdisaha bykyze ikia kasapy bo tsipadisaha” niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Atsumuẽhĩtsa aharere bo hyỹ my zeka ikia ba ziktsaso. “O tsamysapyrẽta”. Ba ziky. Atsumuẽhĩtsa zuba. ");
INSERT INTO rkbNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ikiahatsa iwata tsimaha. Ikiahatsa Deus harere bo hyỹ tsimaha zeka “kamysapyrẽta ba ziky.” Ikia atsumuẽhĩtsa wata. Tsimytsasokonahaze: “Utakta Deus tsumuẽhĩtsa my iharere bo hyỹ ikykara” tsimaha. Iwa tsimaha — Sesus nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Niytahi Sesus Serusarẽhe bo niukuruze Karireja ziharamu. Samarija buruk ziharamu. ");
INSERT INTO rkbNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Izumuze kytsa mytsyhyrytsa watsa Sesus zihobyknaha. Kytsa tahakõrõrõtsa humo nibibibakanahatsa tu. Ẽryk tu pykpyk niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Sesus bo opykani hua nikaranaha: — O Sesus mypehatsa myhumo amypokzitsiuhukta — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Sibo nikozoze ispe niy: — Nabo tsiksizonahaktsa! Deus wahoro eze ziknapamykysokonahatsa bo tsikahawatawynaha. Ziknapamykysokonahatsitsa pahapiaksukparanaha nawa taha — niy. Yhỹ niaha. Nitururuknaha ske buruk niukurunahaze nizororobaiknaha. Kytsa tahakõrõrõtsa humo asiba nibibibanahatsa tu nizororobaiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Estuba nizororota ziksizo. Atahi Samarija ezekta bipyri niy. Nizororota Sesus bo ziksizo. Nizororota Deus bo nipamykysoko. — O Deus ikia hi tsikzororowy. Iwatahi kakurẽta — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Sesus bo zumuze iokeryk taekaratsa humo puruk puruk niy. — O Sesus ikia hi tsamysapyrẽta — nikara. Atakta maku bipyri, Samarija ezekta. ");
INSERT INTO rkbNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Niytahi Sesus ipe niy: — Mytsyhyrytsa watsa zuba tsikzororonaha. Ustsa sa hana bo nizororonahatsa. Ustsaktsa sa batu eretezo niy. Estuba zuba Deus bo nipamykysoko. O Deus ikia hi tsamysapyrẽta. Ikia tsikzororowy hỹ — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ustsa Deus bo batu pamykyso. ");
INSERT INTO rkbNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Iwaze Sesus ipe niy: — Kyiktykta! Nabokta! Ikia kahumo tsikspirikpotawy azororowybaba — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Kyze Pariseutsa Sesus pe nikaranaha. — Hawaze sa kytsa Deus tyryktsa moziknaha niaha. Nawa puruze Deus tyryktsa mozumunaha — niaha. Sesus ispe niy: — Deus tyryktsa bo ka ba zikozonaha. Kytsa iwatawy piberikinaha zeka ba zikozonaha niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ba aty tohi naeze Deus tyryktsa ziky. Nabo Deus tyryktsa. Wabyziutaha! Abaka kytsa Deus harere bo hyỹ mykaranaha zeka asahi botu Deus tyryktsa moziknaha iwa Deus tyryktsa ahatuk tu my — nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Sesus tuk zinymyrykynahatsa pe niy: — Uta myziksizoze pareparezo mozikta wata my. Bijoikpe eze tu nanabyitaba pareparezo mykaraze tawata iwaha bo myzubatsa kabo iktsa maha. Taparaka sinini mykara. Abaka kytsa kahumo batu sispirikpo — iwa Sesus tuk zinymyrykynahatsa zuba nipamykysoko. Sesus: — Bykyze Deus bo piksizoze ikiahatsa tsipikny tsihikiknaha. Utakta Deus zikpehata ahawata ikyzik. Bykyze tsimytsasokonaha. “O uta Sesus piny tsihikik. Sesus mytazahare zeka tsimysapyrẽta. Uta Sesus pe tyziksizota mykara.” Batu ba, mohokda tsimaha — nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Wastuhu ikiahatsa pe maha: — Nabo iktsataha! Sesus mozumuku. Tabo iktsataha Sesus mozumuku iwa maha zeka tyberi beri byitaha! Kytsa harere bo ka ma ahabyitaha! ");
INSERT INTO rkbNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Myziksizoze tsipiknynaha. Bijoikpe buruk nanabyitaba mypubyri pare parezo waha. Aparakbaha kabo tsimykozonaha. Utakta Deus zikpehata myziksizoze iwahi my — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Sesus: — Tapara sinini mykara. Abaka kytsa kahumo batu sispirikpo. ");
INSERT INTO rkbNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Myziksizoze kytsa Noe okze ziknakaranaha ky watsa. Zikzibyituhukutu ziknatahadisahakanaha, zikzikukunaha aha ziknatahasukzakanaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Iwa my. Iwaze Noe tsaraha puẽtsikbyita bo nitsukze nahawa. Takoroze atsoko hyritsik inawõ. Ustsa kytsa pihik humo tahababaiknaha. Iwatsa sispirikpobyitsa tahababaiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","— Ro okze tu niaha wa tihi niy: Zikzibyituhukutu kytsa ziknatahadisahakanaha, zikzikukunaha, ziknasiparikiknaha, wahoro zikzitsetsikiknaha, sinamy ty nyny ziknakaranaha sinamy ziaksekenaha. Ro Sodõ hudikhudikwy ezektsa iwa ziknakaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Iwaze Ro Sodõ ekze niparakze. Atsoko Deus izo hyritsik waha bijoikpe ikny tu izo inawõkõ. Izohyri tywaha inawõkõ anaezektsa nisibabaik. ");
INSERT INTO rkbNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Iwahi myziksizoze atsawatu my. ");
INSERT INTO rkbNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Uta myziksizoze aty ape baze rikto zeka tanamy bo ba zitsuk. Tanamy ba zebyk. Aty waratok eze mopykyryk zeka ba tawahoro bo baziksizo! ");
INSERT INTO rkbNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ro oke bo mytsatytaha atatsa niparakze tasukpe bo iktsa niytatsa. Nihyrikosokda izo bo niharakoro. ");
INSERT INTO rkbNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Iwaze aty mowak zeka tanamy pihokzaba tahi wasani habo tasapy. Aty Deus humo tispirikporẽta zeka inamy zuba mohokda atahi tawahi Deus tuk mynapykyryk. Wasani mykara. ");
INSERT INTO rkbNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Myziksizoze petoktsa harape tuk atsa bete tu purubakanaha zeka estuba katuk pioktyhyryk. Ustakta perikik. ");
INSERT INTO rkbNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Petokzahaza wanatsitsa mysiwazikinaha zeka estuba katuk pioktyhyryk. Ustatsa katsa perikik. ");
INSERT INTO rkbNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Kytsa petoktsa waratok piwekenaha zeka estuba katuk pioktyhyryk ustakta perikik — niy. Zinymyrykynahatsa ipe niaha: — Hana eze sa iwa tsimy — niaha. Niytahi Sesus harere pinymyrykynaha. Mytsatyziu mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Sesus tihi: — Hawaze nirata zeka urubutsa nakypyknaha. Piborobanaha. Urubutsa Deus bo mytsaty zikahabyitsa sihorotsa zuba nasiborokonaha. Kytsa Deus bo mytsaty zikahabyitsa ihumo sispirikpobyitsa iwatahi babyitatu uta myziksizoze kaharere zuba wasani my — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Sesus haramukuka soho nitsasoko. Zinymyrykynahatsa nisihyrinymyryky. Hawa kytsa Deus bo myzapykykynaha, ibo mopamykysoikiknaha ba pyk zikaha. Iwaha humo zinymyrykynahatsa nisihyrinymyryky. Iwatahi haramukuka soho nitsasoko. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Atahi: — Kytsaharerewabytsa hudikhudikwy eze niy. Ata kino Deus humo batu ipyby. Kytsa humo batu ma isopyk sihumo batu imypokzitsiu. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Anaeze niwatihi haramukuka ziknapykyryk. Atatsa ibo pororo ziknakara. Ibo ziknatsasoikik: “O tsiktsumuẽhĩ ky” nikara. “Kasukyrytsa humo kaharere bo wabyty. Ata kino moziksapybyriki. Kaharere tsipiwaby zeka kasukyrytsa sakyriukrẽnikitsa hurukwy bo tsimytsahurukik” niy. Iwa atatsa nipamykysoikik. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Batu aidy ahabyita ziknakara kytsaharerewabytsa batu yhỹ niy. Bykyze ta humo tu mytsaty niy. “Iwatatu utakta Deus humo batu kapyby. Kytsa humo batu ma kasopyk sihumo batu kamypokzitsiu. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Abaka haramukuka pikykniki. Iwatahi haramukuka pitsumuẽhĩ. Atatsa tasukyrytsa harere soho piwaby. Uta hi atatsa pibetesaka. Iharere ty waby byizeka pikyknizo. Kakubyri mozumu zeka kakidipyk mynaparak” niy — Sesus nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Iwaze Sesus aparakbaha bo nipamykysoko. — Kytsaharerewabytsa harere bo wabytahaktsa! Atakta imysapybyitatu nikara. Iwatatu atatsa zibetesaka. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Deus ta abazuba tsimysapyrẽta. Ikiahatsa ahatuktu zuba: “O Deus ja mymytsumuẽhĩ tsimaha” iwa ba ziktsasonaha. Mymytsumuẽhĩ tsihikik hỹ. Iwatsahi ibo tynapamykysoikiknaha. Unata okoroze ahaeze Deus bo tynapamykysokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Atahi pahatsumuẽhĩ hỹ. Deus tatyryktsa mysitsumuẽhĩ. Atsoko mysitsumuẽhĩ hỹ. Sihumo tsimypokzitsiarẽta. Utakta Deus zikpehata ahawata ikyzik. Myziksizoze kytsa kahumo sispirikporẽtsa moziknaha ana hi mozihikik. Deus bo mynapamykysoikiknaha hi mozihikik. Iwatsahi Deus bo tynapamykysoikiknahaktsa kytsa! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Kyze Sesus nipamykysokozo. Wabytaha simyspihikbatatsa soho humo nisihyrinymyryky. Asaktsa: — “O katsa zuba wasani Deus okze tsimykaranaha” nikaranaha. Ustsa humo ka tahasupewykynaha — niy. Iwatahi Sesus sisoho nitsasoko. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","— Kyze makutsa petoktsa Deus wahoro zubata bo inapupunaha. Iwaze Deus bo nipamykysokonaha. Estuba Pariseu. Usta okyrysaro bykyktsa iwa ahatsa. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Pariseu ata zuba niriktohoko. Atazuba Deus bo nipamykysoko nawa nikara. “O Deus ikia humo ka kakurẽta. Ikia kasoho bo wasani mytsaty tsimy. Ustsa kytsaktsa sinamy siakparawy. Utakta batu. Ustsa kytsaktsa mektsaktsa okeza nasipyrirykyknaha. Utakta batu, niwa kasopykbyita. Utakta tohi okyrysarobykyktsa byitawata mynakara. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Pororo mynakara petok mozurukuze hauk ahabyita mynakara. Ikia bo kanamy ty nyny kasopyk. Kanamy tsapukte buruk iwaze abo nyny kasopyk” niy. Iwa tatuktu zuba nipamykysoko. Atahi imysapybyikita nikara isukatsihikbyita nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Iwaze okyrysaro bykyktsa nokponi tu rikto ahata. Bijoikpe bo iktsa ahabyita tu nikara. Wytyk bo zuba okmymy ahata nikara. Tarok humo zuba baybay nikarata. Iwaze hi Deus bo nipamykysokota iwa nikara: “O Deus kahumo amypokzitsihukta! kamysapybyita tu mykara” nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Niahatsahi makutsa petoktsa tahawahoro bo ziksizonahaze — Sesus nikara. Iwaze Sesus nitsasokozo: — O Pariseu wasanibara ty mykara. Atakta okyrysarobykyktsata ziksi wasani nakarata. Aty: “O utakta wasani” my zeka. Deus ipe: “O atakta batu wasani isopyk.” Aty: “O kamysapybyita tu mykara ana humo hi kasukatsihikrẽta” my zeka Deus ipe my: “O atahi wasani isopykta” my — Sesus nikara. Iwa nisihyrinymyryky. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Kyze mektsaktsa kytsa tahahyrytsa Sesus bo nisioktyhyryknaha. Iwatsahi nisiharekpypyikiknaha. Iwaze zinymyrykynahatsa tahasakparekenaha. Nisibetsakaknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Sesus ana ziwabyze taokaniki iwaze ispe niy: — Kyzehu tahaktsa jabyitsa uta kabo tynasioktyhyryknahaktsa! — niy. Zinymyrykynahatsa pe niy: — Siypyktsa humo ka tsihokdaharẽna jabyitsa humo ka mahani ihokzaha. Iwaze Deus tyryktsa hi jabyitsa watsa maha. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Jabyitsa hi: “Kytsa harere bo ma sisopyk”. Jabyitsa wa tsimaha zeka Deus harere bo: ma tsimaha. Deus bo ma ahabyi zeka ityryktsabyitsa tsimaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Niytahi ispehatsa hudikhudikwy ezektsa tuk tsinamyrẽta Sesus bo zumu. Sesus pe nikara: — O myhyrinymyrykytsa wasani tsimynakarata. Hawa sa mykara iwatahi mohyrikosokdaze uta Deus tuk kawahi mynapykyryk — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Sesus: — Amo skaraba ikia kape wasani tsimynakarata tsiky. Deus zuba wasani mynakara. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Amy ty Deus sohokotsa botu ziwatahakanaha ahyrinymyrẽta. Deus harere tihi nitsasoko: Mektsa okeza ba ziksipyrirynaha. Ba zibezenaha. Usta namy ty hyryk hyryk byitaha. Ba zik spihikbatanaha. Ahazotsa humo awatu taha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","— O mypehatsa jabasize tu Deus harere humo wasani ziknakara ana humo ka botu ikspirikpoba ziknakara — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Sesus ziwabyze nitsasokozo: — Ikia aba estubaha tsimy. Anamy ty sinamybyitsa bo nyny tsimy. Aokyrysaro humo kino niwatihi nynybaik tsimy. Iwaze hi anamy baba Deus sapy eze tu my. Anamy baba ty mynapykyk. Bykyze pany! Kapik tynao — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Atakta ana ziwabyze iaku byri ta. Tsinamyrẽta hi tanamy pokzi tsiwy tuk batu hyỹ niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Sesus tisukatsihikrẽta bo nikozoze atahi zinymyrykynahatsa pe niy: — Iwaha hiba tsihokdaharẽna sinamyrẽtsa Deus tyryktsa moziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Tsihokdaharẽna siraratsa kamero inarokota mysukwowowy ispioke buruk mytsuk. Ihokdahanikia tsinamyrẽta Deus tyryk mozik — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Sizubarẽtsa ana ziwabynahaze asahi nipamykysokonaha. — Hawa hatsa sa Deus tyryktsa moziknaha. Aty skaraba Deus myzioktyhyryk — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Sesus: — Kytsa tuk ka ba zikaha. Deus tuk batu amy tohi ihokzaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Niytahi Peduru Sesus pe niy: — Katsaktsa mywahoro tsikzerebaiknaha. Iwatsahi ikia tuk tsiknamysapynaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yhỹ my. Sesus: — Uta kaharere wasani my. Ahawahoro tsiperekeknaha zeka Deus usa wahoro ty ahabo nyny my. Niwatihi ikiahatsa tatukytsa tsimyserekeknaha zeka, tahyrytsa, tazotsa, tsimyserekbanaha zeka iwa abakta ustsa itukytsa moziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Abakta ustsa tatukytsa, ustsa hyrytsa, ustsa zotsa iwatsa Deus ahabo nyny my. Bykyze ikiahatsa tsimyhyrikosokdanahaze Deus tuk ahawahi tsimynapykyryknaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Sesus tuk zinymyrykynahatsa meky botu nisioktyhyryk. Anaeze ispe niy: — Wabytaha! Serusarẽhe bo tsimykurunaha. Utakta Deus zikpehata ahawata ikyzik. Kytsa hawa ja katy maha. Hawa Deus sohokotsa botu ziwatahakanaha kasoho atsatu maha. Botu ziwatahakanaha abaka mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","33","Bipyritsa bo pikoktyhyryknaha. Pikspihikbatanaha. Piksapybyrinaha. Pikpyriryknaha. Pikezozoknaha. Pikpypyknaha. Iwaze pikbezenaha iwa katy maha. Iwaze petok puruze mynahyrizikpo — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Zinymyrykynahatsa iharere humo sihyrinymyrybyitsa nikaranaha. Iharere tsihokdaharẽna. Hawa ha iharere piwatawyky naha humo batu sihyrinymyry. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Sesus Serikoho bo niukuru. Zumubahanize ihyrizikubyrita ske sak eze nidyhyky. Kytsa ziharamukunahaze ispe nikara: — Uta kabo ja — ziknakara. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Niytahi kytsa sizubarẽtsa ziharamukunaha. Kytsa sizubarẽtsa nisiwabyze ispe nikara: — Amo skaraba — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","— O Sesus Nasare ezekta mozumu — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Niytahi ihyrizikubyrita Sesus bo huahua niy: — Sesus, Dawi tsekoka kahumo amypokzitsiukukta! — niy. Iwa hua nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Iwatsahi kytsa ziharamukunaha tsahi zibetsakaknaha: — O aksobyitykta — niaha. Tybyi zuba nikara. Opykani hua nikara: — Sesus Dawi tsekoka kahumo amypokzitsiuhukta — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Sesus ske pokteze pyk niy. — Pany! Kabo pãotyny kabo tyzioktyhyryknaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Iwaze izumuze Sesus tihi: — Amy skaraba hawa sa abo my — niy. — O kapehatsa ba zikozonaha. Kahyriziktsa tysizororowykta — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Sesus ipe niy: — Uta kahumo tsaspirikporẽtawy iwatahi tsikzororo — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Kyze atsoko ihyrizikubyrita nikozozo. Nihyriziktsa zororo Sesus hapik niukuru. — O Deus ikia humo kakurẽta — nikara. Kytsa niwatihi Deus bo nipamykysokonaha. — O Deus ikia hi tsamysapyrẽta — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Sesus Serikoho bo zumukuze. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Kyze Sakeu Serikoho ezekta okyrysaro bykyktsa. Tsinamyrẽta. Kytsa namy zikziakseke. Imyspihikbatanikita. Tsiokyrysarozubarẽta tu iwatatu batu nyny ziky. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Atakta: — Sesus ziny tsihikik tahi nikara. Iwatahi isoho piwaby — niy. Batu ibo zikozo. Iypykzezebyita hi nikara. Kytsa sizubarẽtsa zihirizabanaha iwatahi Sesus ty batu tyny. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Tsihokdaharẽta. Iwatahi ske buruk siharaze niparak. Hwi ske sak eze tu buruhua tabo nido. — O abahi Sesus tykara tabo mozumu kaopuke buruk harakmo myze ibo mokozo — mytsaty niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Kyze Sesus iopuke buruk izumuzakaze jo bo iktsa niy. Sesus: — O aidytynykta. Tynasikta! Sakeu pe niy. Aba uta awahoro bo mynakozore. Abaze dyhy my — niy. Yhỹ niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Iwaze Sakeu aidy sarapuruk niy. Tsakurẽta iwahoro bo zumunahaze. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ustsa kytsa tihi: — O Sesus tisorekrẽta baze tu modyhyky. Batu imysapy — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Kyze wahoro eze Sesus nipamykysobaze Sakeu kyik niy. Sakeu: — O nezeba kytsa okyrysaro iaksebaik. Iksispihikbataikik Sesus. Abaka mahani kasorok. Kaokyrysaro ty tsapukte buruk pinyny. Siakubyrinikitsa bo nyny my. Sinamybyikitsa bo nyny my — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Sesus: — Iwa wasani. Jaba ikia apokzi ikzumu. Ikia bo iknakara patsumuẽhĩ iky. Mekywatu tsimozik. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ustsa ikia wata sisopyksapybyikitsa tu mykaranaha. Iwatahi mybarawy bo ikzumu. Sisopyksapybyikitsa tu nikaranaha asahi meky watu moziknaha zeka Deus bo mysioktyhyryk — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ziwabynahatsa bo nipamykysokozo. Aba Serusarẽhe zumubahanikinahaze iwatahi Sesus aparakbaha nisihyrinymyryky. Kytsa — Aba ja Deus tyryktsa mozumunaha — mytsaty ahabyitsa nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Iwaze Sesus ispe niy: — Kyze maku myhyrizikwanita nokponi mokuru. Meky botu mokuru. Myzumuze ispehatsa mozik tsihikik niy. Bykyze myziksizoze. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ijobyitu tatsumuẽhĩtsitsa mytsyhyrytsa watsa tuk mopamykysoko. Ispe niy: “Uta ikiahatsa bo ouro ty ahawa tu nyny my. Ouro mytsyhyrytsa waha ty nyny my. Ahawatu nyny nyny my” iwa nyny mykara. Ouro humo tarabaja tsimahaze puẽtsik tsipiaksenaha. Iwataha — niy. Iwa ispe niyze niparak. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Meky botu niukuru. Kyze itukytsa ihumo batu siakparawy. Kytsa sakyriukrẽtsa. Iwatsahi wastuhu kytsa maku myhyrizikwani bo niukurunaha. Iwaze ibo zumunahaze. Kytsa tihi: — O katsaktsa batu ikia humo makparawy. Kyzekta ikia abaka mypehatsa byita tuzik — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Iwatatu maku myhyrizikwani ispehatsa niyzik. Iwaze tahudikhudikwy ziksizoze tatsumuẽhĩtsitsa bo nisihuahua. Iwaze sitsumuẽhĩtsitsa ibo zumunaha ispe niy: — Hawa sa ouro ty tsikykaranaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Tapara estuba zubata tapehatsa pe niy: — O kapehatsa ikia estuba ouro ty kabo nyny tsiky. Ta humo katsyhyrytsa wa iakse — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Myhyrizikwanita tihi: — O katsumuẽhĩtsa tsamysapyrẽta ikia wasani tsikykara. Ouro ty estuba zuba abo nyny ikyta tu abazuba tsisararawy. Iwatahi ikia bo hudikhudikwy mytsyhyrytsa watsa nyny my. Iwaha tyziperyky tsimy. Ikia ispehatsa tsimozik — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Usta tsumuẽhĩtsa ipe niy: — O kapehatsa ikia kabo ouro ty estuba nyny tsiky ta humo mytsyhyry wa iakse — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Iwatahi maku myhyrizikwanita tihi: — Ikia hudikhudikwy mytsyhyry wa tyziperyky. Ikia ispehatsa tsimozik — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Usta tsumuẽhĩtsa ipe niy: — O kapehatsa ouro ty estuba kabo nyny tsikahaty taty abo nynyzo my. Utakta panu eze iakwaraka, jokpitsĩhik. Aba kino estuba zuba my. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ikia pokso kapybyrẽta hi ikykara. Ikia batu amy tsumuẽhĩ tsihikik. Ikia humo hi kytsa sinamybyitsa. Ikia namy tsizubarẽna. Ikia kino nyny nynybyity. Ikia waratok sizonita bo batu ziksiparik. Tsinasizozeke zuba. Kyrizykbyitatu tsinasizozeke zuba. Iwa sitsumuẽhĩtsa nitsasoko — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Iwaze myhyrizikwanita zibetsakak ipe niy: — O batu amysapy. Ikia katsumuẽhĩtsa batu apasara tsihik. Batu imysapy aharere humo zuba piwatawy. Ikia mytsaty tsimy utsa kytsa tysinamybyiwyky. Ikia mytsaty tsimy nyny ahabyitatuze kanamy ziakseke zuba. Ikia mytsaty tsimy kapairikihibara tu pizozeke zuba. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Iwatahi amy skaraba maku okyrysaro perytsa bo ouro ty batu nyny tsiky. Iwazeka abaka ouro puẽtsik zuba tsipiakse niy. Iwa myhyrizikwanita — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Iwaze sinytsitsa pe niy: — Ouro ty estuba zubataty okoktaha! Iwaze maku katsyhyrytsawa ibo nyny tahaktsa — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Sinytsitsa tihi: — O mypehatsa, atakta botu ouro katsyhyrytsawaha niy — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Myhyrizikwanita tihi: — Utakta wasani mykara. Maku tsinamyrẽta tu namy ty abazuba ibo nyny my. Maku inamybyita tsikaeni zuba my zeka piakseba — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Abaka kasukyrytsitsa kabo tynasioktyhyknaha. Kahumo siharerewabymybarẽtsa. Niahatsahi kape niaha: — O ikia batu mykparawy. Ikia mypehatsa byita tuzik niaha. Aba kaokze tu tysibanaha — niy! Iwatsahi sisukyrytsitsa nisibaiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Kyze Sesus Serusarẽhe bo zinymyrykynahatsa haraze niukuru, ");
INSERT INTO rkbNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Bytykara wa sihudikhudikwy zumubahaninahaze Betipake myzubaha bara. Betanija hara jobonikita Oriwereja inarokoha pauk baze niy. Sesus zumuze tatuktsa petoktsa nispeha. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Iwa ispe niy: — Sihudikhudikwy bo pãotaha kytsa! Atsezubaha tsimypupunahaze pikuza tsibik tsipipiktumunaha. Atahi isoikãihikta niy. Ibete dyhyhukbyita niy. Satsukyktaha! Kabo tyzioktyhyknaha! ");
INSERT INTO rkbNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Aty ahape: “Amo maha zeka”. Myhyrinymyrykytsa tihi mype tyoktyhyrykspyk. Niahatsahi tsimykaranaha. Bykyze ahabo tasirezo tsimaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kyze zumunahaze wasani pikuza bo zumunaha. Sesus nikara nahawa tihi ibo zumunaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Zisatsuknahaze zihitsa ispe niy: — Hawa skaraba tsimykaranaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","— O myhyrinymyrykytsa mype kabo tyzioktyhyknahaktsa niaha tsahi tsimykaranaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Sesus bo zioktyhyryknaha, tahasuk pikuza bete zizozokonaha. Iwaze Sesus ibete nido. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Kytsa ske buruk tahakpyzazawy zipaparakanaha. Sesus ykparawytsa tahakpyzazawy zipaparakanaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Oriwereja tsahara inasikze iapiktsa sizubarẽtsa sakurẽtsa. Siaksoho opykrẽtsa inakaranaha: — O Deus tsamysapyrẽta. Sesus zuba awata mynakara — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","— Deus Sesus zipehaka. Deus pauk bazekta tu katsa mybo izumu. Atakta tsimysapyrẽta. Atahi abazubata bijoikpe eze tu niy. Bijoikpe iknyktsitsa ihumo sakurẽtsa — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Pariseutsa sitazahara eze Sesus bo nipamykysokonaha. Ipe niaha: — O myhyrinymyrykytsa zinymyrykynahatsa pe aksobyitahatykta! Siharere ka batu imysapy — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Sesus tihi: — Aparakbaha soso ahabyizeka haraharetsa kaka maha — nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Sesus Serusarẽhe zumubahaneze nipuziuku. Nawa nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","— O Serusarẽhe ezektsa! Tsinymyrykynaha zeka aty ahahumo tsimynakokozo. Awatutaha. Abaka batu ahahyrinymyry. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Bykyze ahasukyrytsitsa mozumunaha. Ahudikhudikwy myzipykbaiknaha. Pahahurukwybaiknaha. Ahudikhudikwy pok taba piukunaha, paikpa piukunaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nanabyitaba ahasukyrytsitsa zuba. Ahawahoro myzipykba. Wahoro ezektsa niwatihi nasipyk. Haraharetsa harape betektsa mynatsubanaha. Ikiahatsa Deus mozumuze pahaoktyhyryk ana humo hi batu ahahyrinymyry. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kyze Sesus Deus wahoro zubata isturupeze bo nitsuk. Anaeze kytsa bo nikozo. Kytsa tahanamy zihuakaknaha. Okyrysaro ty kytsa bo nyny nikaranaha. Iwatahi nisiksiwyky Sesus ispe niy: — Nabo pãotaha! niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Deus harere niy: “Atakta uta kawahoro zubata Deus bo mynapamykyso.” Iwa botu ziwatahakanaha. Ikiahatsa hi kawahoro sitsyhyryboarẽtsa parik wa tsikzoknihiknaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Zibyituhukutu Sesus Deus wahoro zubata isturupeze nisihyrinymyryky. Taparaktsa ziknapamykysokonahatsitsa, Deus harere humo sihyrinymyrytsitsa iwatahatsitsa iwatsa Sesus humo batu siakparawy. ");
INSERT INTO rkbNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Iwatsahi taparaktsa Sesus zibezekyzykynaha. Ustsa kytsa pokso sipybyrẽtsa nikaranaha tsahi batu. Kytsa sizubarẽtsa Sesus ziwabytoktokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Kyze usta okoro eze Sesus Deus wahoro zubata isturupeze kytsa nisihyrinymyryky. Deus wasania ty nitsasoko Deus soho ty kytsa bo nipamykysoko. Iwaze taparaktsa Deus wahoro eze ziknapamykysokonahatsitsa, ziwatahakanahatsitsa, kapitaõtsa iwatsa zumubanaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Sesus bo zumukunahaze. Ipe niaha: — Aty sa ikia pe kytsa tysihyrinymyrykta niy. Aty sa zapeha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ispe niy: — Uta kino ikiahatsa pe my. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Aty sa Suão Batista pe: “Kytsa tysiharasusu” niy. Tozeka ja kytsa ipe niaha. Tozeka ja Deus ipe niy. Aty sa Suão Batista pe: “Kytsa tysiharasusu” — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Taparaktsa asa zuba nipamykysokonaha. — Katsaktsa sa hawa tsimaha. Tsimytsasonaha zeka Deus ipe niy iwatahi Sesus mype: “Amo sa Suão humo batu ahaspirikpo” my. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Tsimytsasonaha zeka kytsa ipe niy. Iwaze kytsa sizubarẽtsa katsa harahareziktsa mybo mynasipaparanaha. Suão hi Deus sohokotsa mytsaty mykaranaha — nikaranaha. Iwa asa zuba nipamykysokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Iwatsahi Sesus pe niaha. — Katsaktsa batu myhyrinymyry aty sa Suão Batista pe: “O kytsa tysiharasusu!” niy — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Sesus: — Uta kino niwatihi. Uta ahabo ba ziktsaso, aty ja kape: “Kytsa tysihyrinymyrykykta!” — niy. Iwa Sesus Pariseutsa bo nipamykysoko. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Kyze Sesus aparakbaha bo nipamykysokozo. Duabohotsa perytsitsa sisopyksapybyitsa soho humo ziwatawyky. Maku estuba duabohotsa nisiparikik. Waratok tsihitsa tsumuẽhĩtsa pe: — Duabohotsa tysiperynahaktsa! — niy. Iwaze nisierekek. Mekybotu niparak. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","11","Iwaze nisizozikiknahaze, usta tatsumuẽhĩtsa duabohotsa mysiperykynahatsa bo zipeha. Hwiharatsa itsapukte buruk piakse. Duabohotsa perytsitsa itsumuẽhĩtsa nitsakikinaha. Batu amy tohi ty ibo nyny niaha. Niytahi sizihitsa mektatu ziakzo. Duabohotsa perytsitsa ata kino niwatihi nitsakikinaha. Sisopyksapybyitsa nikaranaha. Batu amy tohi ty ibo nyny niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Iwatahi zihitsa usta tsumuẽhĩtsa zipeha duabohotsa perytsitsa bo zipehazo. Waratok perytsitsa ata kino nitsakikizonaha. Zisukehekzonaha. Batu amy tohi ty ibo nyny niaha. Zihyrikywykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Duabohotsa zihitsa mytsaty nikara — Hawa sa my. Katse kahumo tsipokzitsiarẽta iwatatu pipeha. Ata humo ka ja ba zikaha — nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Iwaze itse niparak. Kyze duabohotsa perytsitsa zihitsa tse bo nikozonahaze asa zuba nipamykysokonaha: — O duabohotsa zihitsa tse tabezehikta kytsa nikaranaha, iwaze inamy takse. Atakta izo mohyrikosokdaze atahi tazo namy piakse. Atahi duabohotsa mynasitsihitsa mozik, ana pokso iwatsahi tabezehikta kytsa! Iwaze katsa hi duabohotsa tsihitsitsa tsimoziknaha. Iwa asa zuba nipamykysokonaha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","— Itse sibo zumuze waratok ekze ziksiwyhiknaha. Zibezehiknaha. Duabohotsa zihitsa hawa sa waratok perytsitsa humo my ");
INSERT INTO rkbNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Niytahi zihitsa perytsitsa bo mozumuku. Mysibaik. Iwazeka waratok ty mektsa bo tu nyny my. Ustsa perytsitsa bo nyny my — Sesus nikara. Ana ziwabynahaze asahi Sesus pe: — O batu ba — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Iwaze Sesus sibo iktsaziu nikara. Ispe niy: — Deus harere botu ziwatakanaha. “Kytsa wahoro nizoknikinahaze nitsasonaha ‘O ana harahare batu isapy’ iwa maha zeka mopapyknaha.” Ata hi harahare hi abazubata niyzik. Anahi harahare tisapyrẽta humo ustsa harahareziktsa buruhuwa niaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Harahare bete mynarahanaha zeka nisipaparabaik. Atahi harahare kytsa bete mynaraha zeka iwaze wytyk tazy moziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Taparaktsa Deus wahoro eze ziknapamykysokonahatsitsa, ziwatahakanahatsitsa sihyrinymyrẽtsa iwatsa soho humo Sesus nitsasoko. Hawa mykaranaha anahi ziwatawy niaha tsahi itsipa humo zioktyhyrynaha. Batu zik kytsa pokso sipybyrẽtsa. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Iwatsahi kytsa Sesus bo nisipehakanaha. Kytsa — O Sesus myhyrinymyrykytsa! — mybarapetu nikaranaha. Asaktsa siharerewabymybarẽtsa. Kytsa Sesus nizokparakanaha iharere ziwabytoktokonaha. Bykyze isoho humo — “O atakta batu imysapy” maha hi — nizihikiknaha. Iwatsahi ispehatsa bo pioktyhyryknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Iwatsahi siharereziutsa wa niukurunaha nizokparakanaha tu iwatsahi Sesus pe nikaranaha. — O ikia tsahyrinymyrẽta ikia hi kytsa bo tsimypamykysokota wasani tsimykara. Deus harere humo tsinymyry wasani tsimykara. Wasani nisihyrinymyryky. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Kapitão Sesa Homa ezektsa pehakatsa okyrysaro ty ibo nyny tsimaha zeka wasani ja — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Asaktsa simysapybyitsa tu mykaranaha ana humo hi Sesus tsihyrinymyrẽta. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Iwatatu ispe niy: — Pany okyrysaro ty kabo nynytaha! Aty naro sa okyrysaro humo iwatahaha. Aty hyrikoso sa okyrysaro humo ziwatahaka — niy. — Sesa hyrikoso okyrysaro humo niy. Sesa naro iwatahaha okyrysaro humo niwatihi — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Sesus tihi: — Ikiahatsa kapitão namy ty ka ibo nyny taha! Okyrysaro ty kapitão bo tsisizonaha. Deus humo kino niwatihi. Deus namy baba ty ka ibo nyny tahaktsa! Deus namy tsisizonaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Sesus harere pisapybyri naha hi mozihikik naha batu zik. Aparakbaha okzeka Sesus harere batu tymyi. Iwatsahi batu tyso. Sesus harere humo paikpa mytsaty nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Kyze Sadusitsa Sesus bo zumunaha. Asahi kytsa myhyrizikosokdanahaze ba ziknahyrizikponaha mykaranaha. Iwatsahi Sesus bo nipamykysokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","— O myhyrinymyrykytsa Moises mytsyhyryze papeu humo ziwatahakaze: “Taparakta maku ihyrytsa byitatu nihyrikosokdaze itsy haramukuka ziakse! Iwaze atatsa tabykyhyze mopurukze kytsa tihi: ‘O iziky tse nipuruk’ maha. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Nawaze tuk itukytsa sete ahatsa nikaranaha. Taparakta tasukza. Hyrytsa ahabyita tu nihyrikosokda. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Niytahi itsy haramukuka ziakse. Itsy kino niwatihi itybykyhybyitatu nihyrikosokda. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Bykyze ustsa itukytsa kino niwatihi harape wanu sapy zikziaksekenahatsa tu batu sihyrytsa byitsa tu niakbakanaha. Iwaze itukytsa mytsyhyry wa atatsa ziaksenaha, estuba nihyrikosokdaze iwaze itsy ziakse siwatu atatsa zioktyhyryknaha. Iwa niaha. Kytsa sete itukytsa sihyrytsahabyitsa tu niakbakanaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Bykyze atatsa kino niwatihi nihyrikosokda. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Nawa puruze myzubaha mynahyrizikponaha aty sa ibarikta babata” nikaranaha, sete itukytsa ahatsa atatsa ziaksenaha — iwa Sesus bo nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Iwaze Sesus ispe niy: — Abaktsa kytsa tahasukzanaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Iwatsa tu mohyrikosokdanahaze mynahyrizikponaha. Mynahyrizikponahaze ba zik mysukzazonaha. Iwaze Deus tihi: “Ikiahatsa tsimynahyrizikponaha zeka bijoikpe bo tsimaha, ba zik karazonaha ba zik mysukzazonaha.” ");
INSERT INTO rkbNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Iwatsahi bijoikpe iknyktsitsa watsa tsimoziknaha. Deus hyrytsa tsimoziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Tsimyhyrikosokdanaha zeka tsinahyrizikponaha iwatsahi ahahyrinymyrẽtsa niy. Tubabatu Moises niwahi ziwatahaka. Mytsatytaha! Moises okyrysaro mokorobaka soho ziwatahaka. Hana eze okyrysaro ikny Moises Deus yksoho ziwaby Deus tihi: “Utakta Deus my, Abarão kahumo tispirikporẽta. Isake niwatihi ka humo tispirikporẽta. Adiri Sako kahumo tispirikporẽta” iwa. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Kytsa siakbatsa Deus humo batu sispirikpo. Kytsa asatu zuba Deus humo sispirikporẽtsa. Iwatsahi taparaktsa asatu maha. Deus okze ka myzuba asatu — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Estuba iwatahahatsitsa ipe niy: — O myhyrinymyrykytsa ikia tsiktsasoziuku niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Iwatsahi batu amy tohi ziktsasonaha. Sesus harere humo sipybyrẽtsa — nikaranaha. Nihareretsihikbyrinaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Sesus ispe niy: — Amy skaraba kytsa nitsasokonaha Kiristu, Deus zipehata ahawata Dawi tsekokatsa tu nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Deus hyrikoso humo Dawi babata Samo papeu humo ziwatahakaze: “Deus kapehatsa pe: ‘Kapanuryk taba dyhyty ");
INSERT INTO rkbNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Bykyzehu uta Deus asukyrytsitsa ty apyrytsa pukezi tysipykwy apokso sipybyrẽtsa’.” Iwa Samo papeu humo iwatahaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dawi hi Kiristu pe niy “Kapehatsa”. Iwa Dawi pehatsa. Dawi tsekokata atsatu sa. Atsatu hiba — Sesus nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Kytsa sizubarẽtsa Sesus ziwabykynaha iwaze atahi zinymyrykynahatsa pe niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","— Pykyhytutaha! Moises harere humo zinymyrykynahatsitsa humo pykyhytutaha! Asaktsa tahasuk humo isapyha ty zuba siakparawy. “Katsaktsa wasani tsimaha” mytsaty ahabyitsa tu nikaranaha. Kytsa nisihobyknahaze sibo nipamykysoziukunaha. Deus wahoro eze ziknadyhydyhykynahaze tisapyrẽna zuba mynazihikiknaha. Tahamyikaha eze isapyhazuba mynazihikiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Kytsa mohyrikosokdanahaze haramukukaka okyrysaro piaksekenaha. Iwaze aparakbaha okzeka Deus bo mopamykysoikiknaha. Simysapybyikitsa tu nikaranaha iwatahi Deus sinini ykarawy bo mysipehahik. Sihyrinymyrykytsitsa tu sinini tynakaranaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Sesus Deus wahoro zubata isturupeze anaeze kytsa okyrysaro suk bo pokpok nikaranaha. Iwaze hi Sesus sinamynikitsa tahaokyrysaro typok pok nikaranaha ana bo hi Sesus nizoko. ");
INSERT INTO rkbNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Iwaze Sesus haramukuka bo iktsa niy. Atatsa inamybyitatsa tu petok zuba pok niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Sesus tatuktsa pe niy: — Atatsa hi wasani mykara. Okyrysaro ty ikatyhi nynybaik niy. Sinamynikitsaktsa okyrysaro ty nynytohi nikaranaha. Deus okze ka atatsa abazuba nyny niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Sinamynikitsaktsa okyrysaro ty tsizubarẽna zerekeknaha. Atatsa katsa batu. Atatsa inamybyitatsa tu okyrysaro ty tadisahawy huakzetu haty nynybaik niy. Atatsa katsa okyrysaro ty nynybaik niy. Sinamynikitsa Deus okze ka tsikaeni zuba nyny niaha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Kyze kytsa Deus wahoro zubata soho humo nipamykysokonaha: — O haraharetsa taparaka siziurẽtsa niaha. Iktsa taha. Haraharetsa watahawytsa zuba Deus bo nyny niy. Haraharetsa siwatahawy zuba tisapyrẽna — niaha. Nipamykysokonahatsa tu Sesus ispe niy: ");
INSERT INTO rkbNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","— Haraharetsa bo iktsataha. Haraharetsa sisapyrẽtsa bo iktsa taha. Aibatohi haraharetsa ba harape betektsa mynatsubanaha. Mopaparahabaiknaha harahareziktsa natsubanaha. Deus wahoro zubata eze haraharetsa mytõtõbanahaze iwaze mopykba. ");
INSERT INTO rkbNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Zinymyrykynahatsa tihi: — O myhyrinymyrytsa hawaze skaraba Deus wahoro zubata mopykba. Hawaha humo sa mybo tsipiwatawy — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Niytahi Sesus iwatawy soho nitsasoko: — Pykyhytutaha! Kytsa pahaspihikbatakanaha. Kytsa sizubarẽtsa mozumunahaze: “O utakta Kiristu. Aba Deus zipehata kytsa mysioktyhyryk” maha. Pahaspihikbatakanaha zeka situk ka pão pão byitaha! ");
INSERT INTO rkbNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Nanabyi soho tsipiwabynaha zeka kytsa ẽryktsa mowatsoronaha. Kytsa bytykara eze kino niwatihi mowatsoronaha ana hi tsipiwabynaha zeka ahapyby byihu ja! Tapara niahawatihi. Mybarawy pykbara tu. ");
INSERT INTO rkbNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Sasabyitsa myharape banaha. Kytsa sizubarẽtsa mowatsorokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Nanabyitaba wytyk mytydydyky tu morapa humo kino niwatihi. Iwatsahi kytsa sizubarẽtsa tarahapapiyknaha. Kytsa sizubarẽtsa sinini maha. Bijoikpe eze mypybywy natakaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Tapara ana bo zuk ahabyizetu kytsa ikiahatsa ahasukyrytsitsa bo pahaoktyhyryknaha. Ikiahatsa kino sihumo sinini tsimykaranaha. Deus wahoro bo pahaoktyhyryknaha iwaze sakyriukrẽnikitsa hurukwy bo pahahuruknaha. Kahumo pahasukyrykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ispehatsa okze pahasukyrykynaha. Pahasukyrykynahaze ikiahatsa wasaniha soho ty tsimypamykysokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Aba ahahyrinymyrẽtsa. Kytsa ispehakatsa okeryk pahaoktyhyryknahaze ahaharere soho bo batu mytsaty tsimykaranaha. Mytsaty mytsaty byitaha! ");
INSERT INTO rkbNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Uta kino aharere ty ahabo nyny my. Ahahyrinymyrẽtsa tsimoziknaha. Kaharere ikiahatsa bo motsaso. Ahasukyrytsitsa ahaharere humo ba zikaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Iwaze ahazotsa siharereziubyitsa tu ahasukyrytsitsa bo pahaoktyhyryknaha. Ahazikytsa ahatukytsa kino niwatihi siharereziubyitsa tu ahasukyrytsitsa bo pahaoktyhyryknaha. Wastuhu pahabanaha. Atyryktsa tuk pahabanaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ikiahatsa kahumo ahaspirikporẽtsa iwatsahi kytsa ahahumo batu siakparawy. ");
INSERT INTO rkbNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Iwatsatu ahabyri typykyknaha. Deus pahapokzitsiki. Aharadi estuba mohokda zeka tsihyrinymyrẽta. ");
INSERT INTO rkbNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ikiahatsa sinini tsimaha zeka, awahi Deus tuk tynapykyryknaha. Ikiahatsa Deus tuk tsimynaopykyryknaha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Sesus ispe niy: — Kyze sodadutsa Serusarẽhe myziharapyryryknahaze tsimykozonahaze atsoko naktsihyripetoktokba iwazeka ahahyrinymyrẽtsa. Serusarẽhe naktsihyripetoktokba. ");
INSERT INTO rkbNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Iwaze asaktsa Sudeja eze mopykyryk zeka hara bo tywaknaha! Asaktsa tahahudikhudikwy eze mopykyknahatsaktsa aidy pãotaha! Asaktsa jeruk bara eze mopykyryknahatsaktsa sihudikhudikwy bo erete erete byitaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Iwahaty sinini mykaranaha. Deus sohokotsitsa botu ziwatahakanaha atsatu mysisininiwykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Wytykyryk sihyryzahaza sisukatsihikrẽza moziknaha. Sijeza kino niwatihi tahabykytsa tuk sisukatsihikrẽza moziknaha. Nawa puruze kytsa sizubarẽtsa sinini mykaranaha. Deus kytsa sisopyksapybyikitsa humo sinini ty ka niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Sizubarẽtsa sokorotsaputsa ty mysibezenaha. Ustsa meky botu mysioktyhyryknaha. Bipyritsa asaktsa Deus humo batu sispirikpo Serusarẽhe bo mozumunaha. Anaeze tuze Serusarẽhe pisapybyrinaha. Serusarẽhe ezektsa bipyritsa pokso sipybyrẽtsa mykaranaha. Kyze Deus tihi: “O niwazubakta!” my — Sesus nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","— Bijoikpe eze myziwatawy nanabyi piwatawy. Iwatawy haramwe eze byzoje eze byrisoiktsa eze iwahatsa natakaha. Mybarawy ezektsa sinyhybyitsahi iwatsahi sipybyrẽtsa. Iwatawy pokso sipybyrẽtsa. Buburu zuba ykpyri waha humo. Aparakbaha sipybyrẽtsa. ");
INSERT INTO rkbNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Batu siaku sipybyrẽtsa zuba. “Hawa sa my” maha. Bijoikpe ezektsa mytydydykyknahaze mokurunaha. Iwatsahi sipybyrẽtsa babatsa. Kytsa babyitsa tu mynatsunaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Iwaze uta Deus zikpehata ahawata myziksizo iwaze aparakbaha tsipiknynaha. Bijoikpe zatata eze tu mynasik. Iwa uta myziksizoze kasapyrẽta kazikwyrẽta my. ");
INSERT INTO rkbNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Iwa myze ahakurẽtsa tsimoziknaha! Ahapyby byihu ja. Ahapunihikrẽtsa tsimoziknaha. Atsoko uta katyryktsa bo pahaoktyhyryk. ");
INSERT INTO rkbNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Kyze Sesus kytsa bo nipamykysokozo. Myziksizo ana soho humo hi ziwatawyky. Iwa nisihyrinymyryky. ");
INSERT INTO rkbNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","— Umaha bo iktsatahaktsa! Ustsa hwitsa bo iktsatahaktsa! Okyrysaropoktsa myponahaze ikiahatsa ahape tu ahasopyk. “O takarasapyky” tsimaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Iwa ahahyrinymyrẽtsa. Iwa my zeka ahahyrinymyrẽtsa. Iwata iwatawy tsizubarẽna bijoikpe bo tsimykozonahaze ikiahatsa ahape tu ahasopyk. “O abahi zuba Sesus tatyryktsa tuk myziksizo. Atahi abazubata mozik tsimaha”. ");
INSERT INTO rkbNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Wasani tsimykaranaha. Wastuhu abaktsa kytsa anabo hi iktsa maha. Kaharere ty atsatu mykara, bykyzehu zuba mohyrikosokdanaha ");
INSERT INTO rkbNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Bijoikpe mohokda. Mybarawy kino niwatihi mohokda. Kaharere zuba ba zikokza. Kaharerebaba ka tawahi mynapykyk — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Sesus ispe niyzo: — Iktsaziutaha! Ahadisahawy bo mytsaty mytsaty byitaha. Ahamyitsapyri humo mytsaty mytsaty byitaha. Ahamyikaha bo kino mytsaty mytsaty byitaha. Iwaze nawa puruze sizubarẽtsa sinini mykaranahaze anahumo ja ahapyby byihu. ");
INSERT INTO rkbNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Iwa puruze atsoko mozumu. Hawa siraratsa taokarawy bo mynapupunaha sinyhybyitsa tu mynapupunaha ikiahatsa batu siwatsa tsikahasukparanahaktsa iwatsahi nawa puruze mozumuze batu ahapyby. ");
INSERT INTO rkbNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Iwaze ahabyi ahaspihik tsiwabykynaha. Tsipiperykynahaktsa Deus bo tsimypamykysoikiknaha “O Deus ikia tymytsumuẽhĩkta! Kytsa mymysininiwykynaha humo ikia mybo iktsa tsimyze tymytsumuẽhĩ iwatsahi mypunihikrẽtsa tsimoziknaha. Katsa tsimywaknaha iwaze Sesus myziksizoze mypunihikrẽtsa” tsimaha — Sesus nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kyze zikzibyituhukutu Sesus Deus wahoro zubata isturupeze nisihyrinymyryky, zunubakaze hara Oriwereja inarokota bo nidoko. ");
INSERT INTO rkbNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Miwa botu Deus wahoro zubata bozo niy. Kytsa sizubarẽtsa Deus wahoro zubata bo niukurunaha. Sesus natawabyhyk niahatsahi ziwabykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Kyze Sudeutsa myikaha zumubahanikize, anawaha eze Deus taparaktsa nisitsumuẽhĩ mytsaty ziknakaranaha. Atsikara ipytowybara ty pororo ziknakaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Kytsa myikaha inakymyze taparaktsa Deus wahoro eze ziknapamykysokonahatsitsa sihyrinymyrykytsitsa kino niwatihi Sesus ziberikinaha. Iwatsahi zibeze tsihikiknaha. Aparakbaha pokso sipybyrẽtsa. Iwaze sipapatu Sesus zibeze tsihikiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Niytahi Satanas Sudas tuk niapykyryk. Sudas usa naro Iskariotses inarokota. Sudas Sesus tuk zinymyrykyta. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Iwatatu taparaktsa bo niparak. Taparaktsa Deus wahoro eze ziknapamykysonahatsitsa iwaze Deus wahoro perykytsitsa ahatsa bo niparak. Atahi Sesus sukyrytsitsa bo zumu. Iwatahi situk nipamykysoko: — O Sesus batu ahakparawy. Tsipibeze tsihikiknaha. Uta pahatsumuẽhĩ. Bykyze uta hi ibo pahaoktyhyryk — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Iwaze ziwabynahatsitsa sakurẽtsa niapykyryknaha. — O ikia tsimymytsumuẽhĩ zeka okyrysaro ty abo nyny tsimaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","— Yhỹ. Bykyzehuta! Aba ibo piksizo — niy. — Yhỹ. Tsipiksi za — niaha. Kyze Sudas mytsaty nikara. — Hawa sa Sesus bo mysioktyhyryk. Yhỹ ja, bykyzehu — niy. Ziperyky zuba. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Kyze Sudeutsa myikaha inakymy. Nawa puruze atsikara ipytowybara ty ziokikiknaha. Sudeutsa hozipyrykzatsa zipyryktsa ty nisibakanaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Niytahi Sesus Peduru Suão ahatsa nisipeha. Sesus: — Nabo kytsa mydisahawy humo bubutaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","— Hana eze sa mydisahawy humo bubu tsimaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Sesus ispe niy: — Wabytaha! Sihudikhudikwy bo tsipomonahaze maku pihik suk bykyhy tuk tsipihobyknahaze ata hi iapik tu wahoro bo mytsukze paku paku tsimaha ");
INSERT INTO rkbNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Zihitsa pe: “O Sesus hana eze skaraba mymyikaha ty katuktsa tuk hauk tsimaha tsimahaktsa!” ");
INSERT INTO rkbNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ata ahape: “Iktsatahaktsa my”. Wahoro jobo tsimydoknaha. Ipokpedawy bo pykyhytu mydyhywytsa bo iktsa tsimaha. Anaeze hi mymyikaha ty tsimymydisahanaha — niy. Yhỹ niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Iwatsahi petoktsa zinymyrykynahatsa nitururuknaha. Sihudikhudikwy izumunahaze Sesus nikara naha watu niy. Iwaze tahamyikaha zikymynaha. Anaeze hozipyrykza tsibik zizokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Zunubaze Sesus zumu. Zinymyrykynahatsa tuk tahadisahakanaha ");
INSERT INTO rkbNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Sesus ispe niy: — Uta ahatuk pikdisaha tsihikik zetu. Ahahumo kahyrizikbarẽta. Aba sinini my iwatahi ahatuk pikdisaha tsihikik. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Aba na waha ty ikiahatsa tuk ba zikdisahazo. Deus tyryktsa mozumunahaze bykyze zuba pikdisahazo. Bijoikpe eze zuba pikdisahazo — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Iwaze Sesus taopowysuk ty okok niy. Deus pe niy: — Ikia humo ka mykurẽtsa — niy. Iwaze sibo nyny niy: — Paiktahaktsa! Tsõtahaktsa — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","— Uta aba zuba duabohotsa tsik pikuku. Ba zikuzo Deus tyryktsa mozumunahaze zuba pikuzo. Bijoikpe eze tu zuba piku — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Bykyze Sesus atsikara ty okok niy. Deus pe niy: — Ikia humo ka mykurẽtsa — niy. Atsikara zitsatsakara. Iwaze sibo nyny niy: — Hauk tahaktsa! Atsikara kanury my. Anaty hauk tsimaha zeka kanury soho bo mytsaty tsimaha. “Sesus mysapyzeky nihyrikosokda tsimaha” — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Niytahi duabohotsa tsik soho ty nipamykysoko. Zikuze duabohotsa tsik soho nitsasoko. — Anaka kaharere ezytyk. Tsipikunahaze kaspu waha tsipikunaha. Kaspu aparakbaha bo mozipoko ana soho bo mytsaty tsimaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","— Mytazahaeze estuba “O Sesus kaharereziuwybyita. Abaka batu Sesus tukta my” niy. Atahi kasukyrytsitsa bo pikoktyhyryk. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Utakta Deus zikpehata ahawata ikyzik. Tubabatu kytsa botu ziwatahakanaha. Deus harere “Uta mohyrikosokda nikaranaha. Atakta kasukyrytsitsa bo pikoktyhyryk. Atahi sinini mykara” — niy. Tisukatsihikrẽta mozik. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Iwaha ziwabynahatsa hi batu siaku. — O aty skaraba! Utakta batu. Utakta batu — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Iwaze zinymyrykynahatsa asa zuba nipamykysokonaha. Aty sa myhyrizikwani babata nikaranaha. — Utakta mypehakatsa wata ahazubarẽtsa tyziktsumuẽhĩnaha. O batu, utaza. Batu, utazakta! Uta ja — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Iwa nipamykysokonahaze Sesus tihi: — Ispehatsa bipyritsa tuk asahi kytsa nisipehakanaha. Kytsa tarabaja ziknakaranaha. Tadisahawy supesapy humo nisiakzokonaha, iwatsahi nizekezokonaha kytsa sisoho pe mykaranaha. “O asahi myharereziuwytsa maha mybetesatsitsa” mytsaty ahabyitsa tu nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ikiahatsaktsa meky watu. Ikiahatsa kytsa tuk “O ustsa kytsa tysitsumuẽhĩnahaktsa” tsimaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Deus tihi: “Aty myhyrizikwanita atahi ituktsa tsumuẽhĩtsa babata. Atahi mypehatsa wata. Atahi katyryktsa tukta my” niy. Aty sa abazubata tozeka ja tadisakata ustaza sidisahawybykyktsa ja mytsatytaha. Tadisahakata hiba tsimaha. Atahi myhyrizikwanita. Uta hiba ahatazahaeze mydisahawybykyktsa wata — niy. Iwa zinymyrykynahatsa nipamykysokozo. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","— Uta sinini mykaraze. Ikiahatsa katuktu tsinapykyryknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kazo zikwy humo mypehatsa mozik. Niwatihi uta pahany. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Iwatuze ikiahatsa mypehatsa tsimoziknahaze kadisahawy zozowy baze tsipadisahanaha. Iwa Isareu ezektsa harere tsipiwabynaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Kyze Sesus Simaõ Peduru pe niyzo. — Simaõ wabyziutykta! Satanas kape niy: “O uta ikia tuktsa zinymyrykynahatsa mysiakpy zeka ikia yhỹ tsimy. Simaõ Peduru piakpy zeka yhỹ tsimy” niy. Yhỹ ahumo za tsipiakpy — iky. Iwa Satanas botu niy. Hawa hahauktsa karetsawakatsa dua eze siriktsa mysidydykynahaze ky iwaze Satanas pakpy zeka amy ty isapyrẽnikia motare my. Satanas tapetu nikara: — O tozeka ja Simaõ Peduru Sesus humo ispirikpota babata iwatahi piakpy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Iwaze utakta Deus bo atsyhyryze botu ikpamykysoko: — O Deus Simaõ Peduru tsikaeni zuba kahumo ispirikpo tsipitsumuẽhĩ iwatahi atahi kahumo tispirikporẽta babata mozik — niy. Iwaze Sesus Peduru pe niy. — Kahumo tsimyspirikpozoze atukytsa tynasipunihikwyky. Iwaze tysitsumuẽhĩ. Asahi ahumo sispirikporẽtsa moziknaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Peduru ipe niy: — Utakta atukta babata katsipa humo pikoktyhyryknaha zeka yhỹ my. Uta kino atuk tu mohyrikosokda — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","— O Peduru, kyze kokuaro ipobyi tu harakykbyi hi “Batu Sesus kanyhy” tsimy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Iwaze Sesus tuk zinymyrykynahatsa pe niy: — Ahapehaze iky ahaperykbyitsa tu ahaokyrysaro anabyitsatu ahapyrysuktsabyitsa tu, amy humo ahakubyri zika — niy. — Batu amy tohi mykubyri — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Abaka meky watu. Peryk tsibyknaha! Okyrysaro ty wabehyryktaha! Ahasokorotsapu byizeka ahakpyzazawy humo tsipihuaknaha iwaze sokorotsapu tsipiakse. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ziwatahakanahatsitsa ikiahatsa pe my. Tubabatu kasoho ziwatahakanaha. Amy ty botu ziwatahakanaha atsatu kytsa mykaranaha. Ziwatahakanaha: — Deus zipehata isopyksapybyita wata maha — niaha. — Kytsa kasoho humo nawa pahaspihikbatakanaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Iwaze zinymyrykynahatsa ipe: — O mypehatsa sokorotsapu petoktsa — niy. — Niwazuba — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Sesus hara bo niparak. Atsa botu ziknakara. Iwaze Oriwerejatsa hara bo nido. Zinymyrykynahatsa niwatihi ituk niukururunaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Hara bo zumunahaze ispe niy: — Deus bo typamykysonahaktsa! Iwaze kytsa pahasapybyinaha zeka batu tsimaha. Ikiahatsa isapybara humo ba yhỹ tsimaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Iwaze Sesus bytykarawatu tirĩta meteros niapykyryk. Iwaze Sesus taekaratsa humo puruk puruk niy. Deus bo nipamykysoko. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Atahi: — O kazo nawa tsimyzihikik zeka sinini my kasukyrytsitsa pikbezenaha. Uta tu zeka ba kahyrikosokda tsihik. Ikia hi: “Tyhyrikosokdakta” tsimyzeka mohyrikosokda. Ikia harere bo yhỹ my — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Atsoko bijoikpe iknykta Deus tsumuẽhĩtsa ibo inasik zitsumuẽhĩkĩ iwatahi tsipunihikrẽta niyzik. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Sesus Deus bo nipamykysokozo. Tisukatsihikrẽta nikara. Itsizuk ispu hyritywaha zipoko wytyk bo inatsuku. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Deus bo nipamykysobaze nikyikykzo. Zinymyrykynahatsa bo zumuzo. Sibo zumuze sisukatsihikrẽtsa hi zurubakanaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ispe niy: — Amo sa tsipurubakanaha. Kyiktaha! Deus bo typamykysonaha! Iwa ahabyi zeka imysapybara ty tsimykaranaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Sesus nipamykysokoze kytsa sizubarẽtsa zumukunaha. Sudas siharaze zumuku. Atahi zinymyrykynahatsa tukta kytsa haraze inaukuru. Iwaze Sesus kytsa bo piwatawy nikara tahi. Iwaze Sesus bo izikeba ziharapyrykik. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Sesus ipe niy: — Tsipikarapyryk zeka sibo tsipikwatawy. Ikia hi kasukyrytsitsa bo tsipikoktyhyryk. Imyspihikbatanikita tsimy. Utakta Deus zikpehata ahawata ikyzik. Ikia tsipikarapyrykyk nawa kasukyrytsitsa bo tsipikwatawy. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Iwaze zinymyrykynahatsa Sesus sukyrytsitsa bo nikozonahaze ipe niaha: — O mypehakatsa katsa kino sa mykuwytsa natahaboboknaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Niytahi ipaukbazekta zinymyrykyta hi taparaktsa tsumuẽhĩtsa zispizykik. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Sesus ipe niy: — O awatu tykta! — iwaze Sesus ispi ty okokzo niyze atsoko zispizororowy. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kyze Sesus Deus wahoro zubata ziknapamykysokonahatsitsa ispehatsa, Deus wahoro perytsitsa iwatsahatsa pe niy: — Amy skaraba ahaupepetsa, ahakuwytsa iwatsa tsiknasebykyknaha awatutaha. Utakta katsyhyryboabyita. Batu kakyri. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ahatuk zikzibyituhukutu. Deus wahoro zubata eze kytsa iksihyrinymyryky iwatsa tu sa batu katsipa humo katy oktyhyryk. Abaka ikiahatsa hawa tsimyzihikiknaha naha humo tsimykaranaha iwatsahi katsipa humo tsikoktyhyryknaha. Hawa ha ty Satanas hyrikoso sapybara pehatsa zahapeha iwa tsimaha. Ikiahatsa Satanas harere bo yhỹ tsimykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Kytsa Sesus isukyrytsitsa bo zioktyhyryknaha. Deus wahoro zubata eze ziknapamykysokonahatsa tuk myhyrizikwanita wahoro bo zioktyhyryknaha. Peduru ẽrykani tu iapik niukuru. Atazuba niukuru. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Kyze niaha tsahi izo zipoknahaze taparakta wahoro peze nidyhydyhykynaha. Peduru situk nidyhyky. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Estuba itsumuẽhĩtsata ibo nikozo. Izo baze niakpyzazakata iwatatsahi nikozo. Atatsahi: — O ikia hi sa Sesus tukta — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","— O Batu. Batu kanyhy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Bykyze usta ipe niy: — O ikia hi kok Sesus tuk tsinymyrykyta — niy. Iwaze: — O batu ba, batu kanyhy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Bykyze mekta tu ipe niy: — O hawa skaraba ikia hi sa Sesus tukta. Ikia kino sa Karireja ezekta. Ikia hi Sesus tukta — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Peduru ipe niy: — Batu kanyhy. Aty skaraba Sesus — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Iwa nitsasokoze kokuaro nipo. Peduru mytsaty niy. Nezeba Sesus kape niy: — O kokuaro ipobyize ka “Batu Sesus kanyhy” tsimy — niy. Atsoko Sesus Peduru bo nikozo. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Iwaze Peduru niparak. Nipuziuku. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Kytsa Sesus ziperykynahatsa zimyijakaranaha. Nitsakikinaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Zihyrizikwarakanahaze ipe nikaranaha: — Ikia ahyrinymyrẽta zeka aty skaraba zaki — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Asahi Sesus zisapybyrikinaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Miwa botu taparaktsa inakypykyknaha. Ispehaktsa, sihyrinymyrykytsitsa, kapitaõtsa iwatsa inakypykyknaha. Bykyze Sesus taparaktsa bo zioktyhyryknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Iwatsahi ipe nikaranaha: — Ikia hi Deus zapehata zeka mybo tytsasokta — niaha. Sesus hi: ");
INSERT INTO rkbNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","— Uta yhỹ my zeka, ikiahatsa batu kahumo ahaspirikpo. Ikiahatsa kaharere bo batu yhỹ zikaha. Uta hiba Deus zikpehata my. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Abaka Deus tuk modyhyky. Deus zikwyrẽnikita tuk modyhyky — niy. Niahatsahi nipamykysokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","— O ikia hi sa Deus tse — nikaranaha. — Iwa ikiahatsa ziknatsasokonaha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","— Amy skaraba kytsa tsimysiberikinaha iwaze hi Sesus harere soho motsasokonaha. Katsa kino iharere imysapybara ty tsiwabykynaha. Niwazuba — taparaktsa nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Niahatsahi aparakbaha kyikyik niaha. Sesus Piratus bo zioktyhyryknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Piratus bo zumunahaze Sesus amybara humo tu zisohometukunaha. Iwa nikaranaha. — Atakta kytsa bo nipamykysoko. “Homa ezektsa pehatsa bo okyrysaro ty batu nyny tsimaha” zispihikbatakanaha. Atakta “Deus zikpehata mypehatsa mozik” — mybarapetu nikaranaha. Iwa Piratus bo zisohometukunaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Iwatahi Piratus Sesus pe niy: — Ikia hi sa Sudeutsa pehatsa babata — niy. — Yhỹ. Wasani tsiky — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Piratus kytsa sizubarẽtsa bo, taparaktsa Deus wahoro eze ziknapamykysokonahatsitsa kino niwatihi ispe niy: — Atakta wasanita. Tsimysapyrẽta mynakara batu amytohi ty ziky — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Kytsa tahaharere ty harapubetehe nikaranaha. — Atakta batu imysapy — mybarapetu nikaranaha. — Kytsa Sudeja eze Karireja eze kino niwatihi kytsa nisihyrinymyrykyze nisimyiwyky. Aba tykara bo izumu. Kytsa nisimyiwyky iharere humo — nikaranaha. Iwa zisohometukunaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Piratus ana ziwabyze ispe niy: — Hawa skaraba atakta hi sa Karireja ezekta — niy. Yhỹ nikaranaha. Iwatahi Piratus Erodes pehatsa bo zipehahik. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Sesus Karireja ezekta tu Erodes bo zipehahik. Atahi Karireja ezektsa pehatsa. Iwaze Serusarẽhe bo inakozore. Iwatahi Piratus Sesus Erodes bo zipehahik. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","9","Erodes Sesus bo nikozoze tsakurẽta nikara. Nezeba Sesus humo ziwaby iwatahi Sesus ziny tsihikik. Sesus zikwy piny tsihikik. Amy ty kytsa batu zikaha Sesus mykara ana humo hi piny tsihikik. Sesus batu ibo harere. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Taparaktsa Deus wahoro eze ziknapamykysokonahatsitsa tuk iwatahatsitsa kino niwatihi niriktotohokonaha. Asahi zisohometukunaha. Siharerewabymybarẽtsa. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Erodes sodadutsa tuk Sesus zimyijakanaha. Sesus myzisukyrykiknaha. Iwaze isuk tisapyrẽta ty ihumo korokbyk niaha. Iwaze zimyijakanaha. Niahatsahi Piratus bo zisihyrykzonaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Iwaze Erodes Piratus iharereziuwy niyzik. Nezeba sakyriwytsa ziknakaranaha. Abaka siharereziuwytsa niyziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Piratus myhyrizikwanikita, Deus wahoro eze ziknapamykysokonahatsitsa tuk, kytsa Sudeutsa hudikhudikwy pehatsitsa iwatsa inakypykyknaha. Piratus hi: Tynazuzuknahaktsa! ");
INSERT INTO rkbNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Iwaze ispe niy: — Atakta kabo tsizioktyhyryknaha. Ikiahatsa tihi: “O atakta isopyksapybyita” tsikykaranaha. Batu ba. Ikiahatsa okze ituk ikpamykysoko. Utakta batu amy tohi ihumo iky. Atahi batu tymyi. Tsiktsasokonaha batu sapy niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Erodes niwatihi isoho “Batu tymyi” niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Iwatahi katsa mybo zipehahikzo. Atahi batu tabeze my. Uta pipeha hwi ty tytsakikta. Bykyze piksiwyhik — Piratus niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Tubabatu Paskoa myikaha eze Piratus estuba ziknazukekenaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Iwaze Piratus hi: — O Sesus myzuke. Tapara tytsakikta bykyze myzuke — niy. Aparakbaha opykani kadi nikaranaha: — Sesus tabezehikta! Bahabas tyzukehikta — nikaranaha. Kytsa sizubarẽtsa sakyriukrẽnikitsa hurukwy eze tu niapykyryknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Situkta estuba nizukenaha. Sakyriukrẽnikitsa hurukwy eze Bahabas niapykyryk. Kytsa bakatsa. Iwatsahi nitsahuruknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Piratus Sesus nizuke tsihikik iwaze kytsa bo nitsasokozo: — O Sesus myzukehik tsimaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","22","Aparakbaha opykani kadi nikaranaha: — Tabezehikta! Iharapatawyhyta humo tabezehikta — nikaranaha. Iwaze Piratus nitsasokozoze: — Hawa skaraba nikara. Batu amy tohi ihumo. Batu tymyi. Tybeze beze byitaha. Iwatahi uta pipeha tytsakinaha bykyze myzukeze — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Batu ba. Aparakbaha opykani kadi nikaranahazo. Hỹ byri nikaranaha: — Tabezehikta! Tabezehikta! — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Iwaze Piratus hi: Yhỹ niy. Siharereze Bahabas nizuke. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Bahabas kytsa bakatsa nizuke. Maku iharereziubyikita nizuke. Sesus ty zuba sibo nyny niy. Iwaze siharereze tabezewy. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Kyze sodadutsa Sesus zioktyhyryknahaze ske buruk maku zihobyknaha. Simaõ inarokota. Sireni ezekta. Tatsuhuk ikny ziksikirita. Simaõ nizokbatsinaha. Ipe niaha: — O iharapatawyhyta tsebykta — niaha. Niytahi iharapatawyhyta tasukyriki bete ziskik. Sesus hapik niukuru. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Aparakbaha iapik niukurunaha. Wytykyryk kino niwatihi iapik niukurunaha. Kykyry zipokzitsikinaha iwazahi nipukarakanaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Sesus sibo uwok niy ispe niy: — O Serusarẽhe eze kykyry katy pokzi pokzi byitaha. Ikiahaka zuba ahapokzi iwaze ahahyrytsa pokzi tynapukarakanaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Iwatuktu puruze kytsa tihi: “Sakurẽza sibykyhybyiza. Sakurẽza sibykyhyhuk byiza. Sakurẽza tahabykyhytsa ba ziksiwazuknaha.” Kytsa sinini mykaranaha, ana pokso hi mohyrikosokda tsihikiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Iwaze aparakbaha mykaranaha “Hara mybete mynaraha. Harahare katsa mymyokpitsĩ” mykaranaha. Mysinini humo iwa ty mytsaty mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Iktsa tsimaha. Hawa kytsa kahumo mykaranaha. Kamysapyrẽta tuzeka hawa mykaranaha. Ikiahatsa ja, ahasopyksapybyitsa tu tsikykaranaha hawa sa ahahumo mykaranaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Kyze petoktsa kytsa Sesus tuk nisioktyhyryknaha. Kytsa bakatsitsa. Kytsa tahapehatsa harere bo batu yhỹ nikaranaha. Sesus tuk mysibezenaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Zumunahaze isapy bo niaha. Iharekpokoso inarokoha bo izumunahaze Sesus iharapatawyhyta bete zitsyhyrysoikare eze nisihyrizikiknaha. Ipyrytsa ty kino niwatihi zihyrizikiknaha. Nikymynahaze iharapatawyhyta jobo ziriktohiknaha. Ituk kytsa petoktsa siharapatawyhytsa humo nisihyriziknaha. Nataba nataba aha. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Sesus Deus bo nipamykysoko: — O kazo kytsa sihyrinymyrybyitsa kahumo mykaranaha ba ziktsapusare. Sisopyksapybyitsa tu tysiokzohik — niy. Iwa Deus bo nipamykysoko. Niahatsahi Sesus suk zibokiknahaze hi sodadutsa zibiakaknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Kytsa ibo iktsa nikaranaha. Taparaktsa niwatihi zipyrirykyknaha. Asahi: — Ustsa kytsa tsiksitsumuẽhĩkĩ. Aba ikia tu tsikatsumuẽhĩkta! Ikia hi Deus zapehata zeka tynasikta! Ikia hi Kiristu zeka ja — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sodadutsa niwatihi zipyrirykyknaha. Iopukeze duabohotsa tsik ty itsãrãkbara ty ibo nyny nikaranaha. Iwa zimyijakanaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ipe nikaranaha: — Ikia hi Sudeutsa pehatsa babata zeka tynasikta! — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Iharapu bete botu ziwatahakanaha: SUDEUTSA PEHATSAaha iwatahaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Estuba sibakatsa ituk zumuzakaze Sesus zisapybyriki: — Ikia Deus zapehata zeka ikiatu tsikatsumuẽhĩkta iwaze katsa tymytsumuẽhĩ. Ikia zikwy tu zeka tymytsumuẽhĩkta — niy. Iwa zisapybyriki ta nikara. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Usta iharere ziwabyze takyriki. Zibetsakik. — Iwa Sesus pe ka niwazubakta niy ikia sa Deus humo batu apyby katsa hiba ituk tsimykzanaha. Katsa kino sinini tsimykaranahaze wasani. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Mysapybyitsa hi tsimykaranaha. Atakta batu amy tohi byitatu — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Iwaze Sesus pe niy: — O Sesus kabo mytsaty tsimy. Abazubata tsimozikze kabo mytsatytykta — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Sesus ipe niy: — Yhỹ kyzetu. Ikiakta katuk tu bijoikpe bo tsipasapy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kyze tokbaha niyzikze miwa niyzik. Haramwe bawa niyzik unata ky wa nio bykyze iharakibikia eze inaharamwezo. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Panu ipamaba ipokpedawy Deus wahoro zubata eze ky nisykbaik. Tsapukte buruk nisyk. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Iwaze Sesus opykani kaka niy: — O kazo kahyrizikarawy ty abo nyny my — niy. Iwa Deus pe niy. Iwaze zumuza. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Sodadutsa pehakatsa ibaze niriktohokota nikozoze, ta tihi: — O atakta tsimysapyrẽta hi — niy. Iwa Deus bo nipamykysoko. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kyze kytsa sizubarẽtsa: — Hawa ha sa — nikaranaha. Iwatsahi nipuziukunaha. Iwatsahi tahawahoro bo tahasukatuk tu ziksikinaha. Sisukatsihikrẽtsa nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Sesus tuktsa ẽryktsatu nikozokonaha. Wytykyryk Karireja eze kykyry iapik niukurunaha. Asiza kino jẽrykzatu nikozokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Kyze nubaze maku Sose inarokota Piratus bo zumu. Sose Arimeteja ezekta Arimeteja Sudeja eze niy. Kytsaharerewabytsa tsimysapyrẽta. Wasani zuba ziknakara. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Taparaktsa tukta batu yhỹ niy. Mektatu. Ustsa Sesus tabezekta nikaranahaze, Sose batu yhỹ niy. Atakta Deus tyryktsa tukta. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Atahi Piratus bo zumu. Sose hi: — O Piratus Sesus nury ty uta kabokta. Uta iytyk bo mytsahorok — niy. Piratus: Yhỹ niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Niytahi Sesus nury nazipikze, panu ty ziakwaraka. Tubabatu harahare hoke bo anabo hi nitsahorok. Batu aty tohi iytyk ezytyk bo nitsahorok. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Tahabyrykywy harazetu nikymynahaze iwatahi Sose Sesus nury ty atsoko babatu ity hoekare niy. Anaeze tyhoek niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Wytykyryk iapik niukurunahaza. Karireja eze kykyry inaukurunaha. Iytyk haneze nitsahorok naha bo zinykynaha. Harahare yktaba nitsahorok zinykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Bykyze tahawahoro bo ziksizonaha. Jokmorẽnikia ty inury bo susu nikaranaha. Byriri Deus harere humo tahabyrykynaha. Iwaze domiko pomoze zuba jokmorẽnikia ty myziskyknaha. Iwa nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Kyze petok zuruze miwa botu domiko eze wytykyryk niukurunaha. Iytyk bo zumukunaha. Jokmorẽnikia itsakykyha tuk niukurunaha. Kykyryk hi: — Inury bo jokmorẽnikia tsipiokmorẽnaha ky — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Harahare hoke bo iktsa niaha. Harahare puẽtsikbyita ty meky botu zikare niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Iwaze iytyk bo nipupunaha. Anaeze Sesus nury ty batu ityny: — Hana bo sa inury — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Atsoko makutsa petoktsa sibaze natakahanaha. Sisukbarazarẽtsa. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Iwazahi sipokso nipybybaiknaha, wytyk bo ziktsutsu niaha. Tahahikiubobohiknaha. Sipybyrẽza nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Kytsa ispe niaha: — Amo skaraba siakbatsa ytyk botu ispita tsipiberikinaha inahyrizikpo. Batu aty tohi tykarezeka. Hana bo ja. Mytsatytaha! ");
INSERT INTO rkbNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Nezeba Sesus ikiahaka pe niy: “Utakta Deus zikpehata kytsa kasukyrytsitsa bo pikoktyhyryknaha. Iharapatawyhyta humo pikpyryknaha. Myhyrikosokda. Petok puruze mynahyrizikpo” niy — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Niahaza hi Sesus harere bo mytsaty niahaza hi iytyk ekze puke puke niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ziksizonahaze zinymyrykynahatsa bo iytyk tsarywybara soho nitsasokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Niahaza hi Maria Madarena, Soana, ustatsa Maria Tsiaku je, situkza iwaza zinymyrykynahatsa bo nitsasokonaha. Zinymyrykynahatsa wytykyryk harere humo batu ma niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Kytsa mytsaty nikaranaha. Paze! nikaranaha. Wytykyryk harere bo batu ma niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Iwaze Peduru kyik niy. Iytyk bo niparak. Ziktsutsu iktsa niy. Iytyk bo inakozore. Panu zuba zinyhikare. Anaeze tapanu metutu zerekik. Iwatahi tawahoro bo ziksizo. Inury hana bo ja, isapy bo nekpa iwatsahi paikpa mytsaty nikara! ");
INSERT INTO rkbNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Kyze asta okoroze tu Sesus tuktsa petoktsa niukurunaha. Emaus bo niukurunaha. Serusarẽhe ekze niukurunaha. Emaus jokboha botu des kirometeros niy. Emaus bo ziksizonaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Iwatsahi ske buruk inapamykysokonaha. Hawa skaraba nikaranaha. Tahatuk tuka inapamykysokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Iwaze Sesus sibo izumu. Kytsa tahatuk tuka nipamykysokonahaze Sesus situk ske buruk niukuru. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Kytsa petoktsa Sesus batu sinyhy bipyri ja nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Iwaze Sesus ispe niy: — Amo skaraba ske buruk tsimypamykysokonaha — niy. Siakubyitsa tu pykpyk niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Estuba Kereopas inarokota atahi ipe niy: — Ikia sa asukmota Serusarẽhe ezekta sa tsimynakozore zuba niy. Ikia zuba hi “hawa sa niy” batu sa awabyhy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","— Hawa sa niy — Sesus niy. Iwatsahi ibo nitsasokonaha. Ipe niaha: — O Sesus soho niaha. Nasare ezekta. Atahi Deus sohokotsa babata. Tsihyrinymyrẽta. Hawa kytsa zikahabara ty Sesus ziknakara. Kytsa okze amy tohi batu iokdaha nikara. Iharere tisapyrẽna. Deus okze ka zikzisapywyikik. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Taparaktsa Deus wahoro eze ziknapamykysokonahatsitsa, mypehakatsitsa hudikhudikwytsa ezektsa iwatsa bipyritsa bo Sesus zioktyhyryknaha. Iwatsahi asa hi: “Atakta tabezehikta!” nikaranaha. Iwaze isukyrytsitsa harapatawyhyta humo zipyrykiknaha. Iwaze nihyrikosokda. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Katsaktsa Sudeutsa atahi mymybetesakatsa. Iwa mytsaty tsikykaranaha. Abaka harakykbyi hi ziharamu. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Miwa botu wytykyryk iytyk bo inury sapy bo zumunaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Batu ityny niaha. Hana bo ja. Bijoikpe iknyktsa Deus tsumuẽhĩtsa bo nikozonaha. Asahi: “O Sesus ispituzo” nikaranaha. Sipybyrẽza nikaranaha. Iwaze ziksizonaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Kyze katsa ituktsa iytyk bo tsiktururuknaha. Hawa skaraba wytykyryk nitsasokonaha atsatu tsinykynaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Kyze Sesus ispe niy: — Hawa skaraba Deus harere humo batu ahaspirikpo. Hawa ha ty Deus sohokotsa botu ziwatahakanaha humo batu ahaspirikpo. Ikiahatsa batu ahahyrinymyry. Hawa ha ty Deus sohokotsa ziwatahakanaha tsikaeni zuba tsinymyrykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Deus zipehata sinini mykara. Bykyzehu zuba bijoikpe bo modozo — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Niytahi nisihyrinymyryky. Hawa ha ty Deus sohokotsa botu ziwatahakanaha anahi nisihyrinymyryky. Moises harere humo ziakbataze iwaze hawa haty ustsa sohokotsa ziwatahakanaha nisihyrinymyryky. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Zumubahaninahaze Sesus asiba harakmo zuba niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","— O bytykareze tukta katsa mybo pakutynykta niaha. Abaka punubaka miwa moku — niaha. Yhỹ niy. Iwaze nitsuk. Petoktsa baze nitare. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Sesus nidyhyky. Atsikara ty okok niy. Deus bo nipamykysoko: — O myzo ikia tsamysapyrẽta. Ikia hi mydisahawy ty mybo nyny tsimykara — niy. Bykyze atsikara ty zuktsak niyze sibo nyny niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Atsikara zitsatsakarakze atsoko Sesus zinynaha. Iwaze babyita tu hokda zuba niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Iwaze asa zuba nipamykysokonaha. — Katsaktsa batu mytsaty tsikaha. Ske buruk nimyhyrinymyrykyze katsa batu mytsaty tsikaha. Taparaktsa Deus sohokotsa watahaha nimyhyrinymykyze mykurẽtsa tsikykaranaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Niahatsahi Serusarẽhe bo niukuruzonaha. Anabo zukzuk niaha. Zinymyrykynahatsa bo zumunaha. Iwaze inahapekypykbanaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Kytsa sibo nitsasokonaha: — O Sesus inahyrizikpota Simaõ Sesus iny — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Iwaze petoktsa ske buruk hawa sa niaha nitsasokonaha. — Hawa Sesus atsikara zitsatsakarakze tsinynaha — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ana nitsasokonahaze tu Sesus natakaha. Atsoko istazaha eze kaha zuba niy. Ispe niy: — Ahakurẽtsaktsa tsimoziknaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Sipybyrẽtsa nikaranaha. Nipybybaiknaha. Ihyrikoso zuba zinynaha mytsaty ahabyitsa nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Iwatahi Sesus ispe niy: — Amy skaraba tsikpybybaiknaha. Amo skaraba paikpa mytsaty tsimykaranaha. Amo skaraba kahumo batu ahaspirikpo. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Katsyhyrype bo iktsatahaktsa! Kapyrytsa bo kino niwatihi iktsatahaktsa! Uta hiba. Kanury bo bubutaha! “O Sesus babata” tsimaha. Nihyrikosokdata itsanibyita ipoiktsa byita iwa — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nipamykysokoze tatsyhyrype ziwatawyky. Tapyrytsa humo kino niwatihi ziwatawyky iwatsahi sakurẽtsa nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Sesus humo sispirikpohuk byitsahi nipybybaiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Iwaze hi Sesus ispe niy: — Hawa sa ahadisahawy — niy. Iwaze piknu izohota ty ibo nyny niaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Siokze tu piknu ziboroko. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ispe niy: — Utakta ahatuk tuze ziknapamykysoko. Hawaeze Moises botu kasoho ziwatahaka. Hawa ha ty isohokotsa botu ziwatahakanaha ty hi atsatu ty mynakara. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Hawa eze kytsa Samo papeu humo botu kasoho ziwatahakanaha. Aba kino atsatu mynakara. Isohokotsa, kasoho botu ziwatahakanaha aba kino atsatu mynakara — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Niahatsahi nisihyrinymyryky. Iwaze Deus harere papeu humo ky zinymyryziukunaha. Tubabatu papeu humo ziwatahaka: — Deus zipehata mohyrikosokda. Harakykbyihi puruze mynahyrizikpo, ispitu mozikzo. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Iwatahi Deus wasania ty aparakbaha bo tytsasokonahaktsa! Zipehata humo wasania ty tsimypamykysokonahaktsa! Tsipamykysokonahaze aparakbaha bo: “Ahamysapybyri tsimoewynaha awatutaha! Niytahi Deus ahamysapybara humo pahaokzohik” niy. Tapara Serusarẽhe ezektsa bo tsimytsasokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Niahatsahi mektsa tyryktsa bo tsimytsasokonaha. Ikiahatsa pahatsumuẽhĩ. Ikiahatsa kazikwy humo tarabaja tsimaha. Iwaze kytsa bo tsimypamykysonaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Wabyziutahaktsa! Tapara kazo harere kabo nitsasoko. Utakta iharere ahabo iktsasoko. Byi puẽtsik Deus hyrikoso ahabo myzipeha. Iwaze Serusarẽhe eze tsiperynaha. Deus hyrikoso ikiahatsa bo myzipeha. Deus zikwy pahapeha my — niy. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Betanija bo Sesus tuk zinymyrykynahatsa nisioktyhyryk. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Anaeze sitsyhyryze Deus bo nipamykysoko: — O kazo tysipokzitsikikta! — niy. Iwaze jo bo nidoko. Nisereke. Bijoikpe bo nitsuk. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Zinymyrykynahatsa Deus bo nisakibazikiknaha. Iwaze Serusarẽhe bo ziksizonaha. Sakurẽtsa nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Zikzibyituhuku naha tu Deus wahoro zubata isturupeze nikaranaha. Deus bo ziknasakibazikiknaha: — O Deus ikia zuba tsamysapyrẽta — nikaranaha. Iwa Deus bo nisakibazikiknaha. O Teopiro niwa zuba botu iwatahaba De.");
INSERT INTO rkbNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Tapara mybarawy isuknihibyize Sesus Kiristu my. Atahi koikny baktatu Deus. Inaro kino ana zuba — Deus harere baba zuba — hỹ. Tapara bijoikpe wytyk nizukni — Deus harere baba zuba — nikara. Atahi Deus tihi nikara. Deus koikny baktatu nikara. Iwa tapara nikara. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Iwa tapara Deus koikny baktatu. Atahi — Deus harere baba zuba — niwatihi. Deus tuk atatu nikara hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Deus nanabyi nizukni ihumo hi. Nanabyi nizukninaha ituk tu nikara. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Tazikwy humo tsizubarẽna mykara. Tazikwy humo myzubaha myspitu tsimykaranaha. Myzubaha nisihyrinymyryky. Wasaniha ty hi sibo ziwatawyky. Hawa myzubaha amypubyriha bo iktsa mykaranaha iwa Sesus myzubaha nisihyrinymyryky. Sihyrinymyrẽtsa moziknaha. Atahi rika wata niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Rika miwa haeze pok maha zeka amypubyri mozik. Iwaha hi — Deus harere baba zuba — myzubaha bo nisihyrinymyryky iwatsahi ihumo sispirikporẽtsa moziknaha. Iwatsahi wasania ty nimyhyrinymyrykynaha rika ty hopok my tawa. Myzubaha simysopyksapybyitsa nikaranaha. Asahi wasani haty batu ziknakaranaha. Wasaniha ty — Deus harere baba zuba — nisihyrinymyryky, atahi rika ty pok maha tawata. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Aiba Deus maku myzubaha bo zipeha. Suão inarokota niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Deus sohotsa zumuze Sesus mybo ziwatawy. Sesus — Deus harere baba zubata — hỹ niy. Iwaze Sesus amypubyriha hyritywa kytsa bo ziwatawyky iwatsahi kytsa Deus harere bo hyỹ mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Suão byitatu — Deus harere baba zuba. — Isoho tsasohotsazubata nitsasoko. Ata soho hi ziwatawyky. Myzubaha pe nikara: ");
INSERT INTO rkbNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","— Deus harere baba zubata hi mozumuze pahahyrinymyry. Mybarawy bo mynasikze myzubaha Deus harere ty mysihyrinymyry iharere amypubyriha hyritywa my — Suão niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Iwaze mybarawy bo inasik. Myzubaha bo zumu. Tapara mybarawy nizukni. Ata hi izumu. Iwaze mybarawy ezektsa ihumo batu sispirikpo. Tsimysapyrẽta tu mybarawy ezektsa ihumo batu sispirikpo. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Tatukytsa bo izumu. Sudeja ezektsa tatukytsa bo izumu. Asa kino niwatihi ihumo sispirikpo byitsa nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Wastuhu ihumo sispirikporẽtsa. Iwatahi ispe niy: — O ikiahatsa Deus tuktsa tsimoziknaha. Kahumo tsimyspirikponahaze Deus tyryktsa tsimoziknaha. Deus hyrytsa tsimoziknaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Deus hyrytsa niyziknaha. Aparakbaha wytykyryk ikny nipupurukuknaha. Kytsa wytykyryk niwatihi isty tyrykzuwy naha humo nipupurukuknaha. Kytsa aba ziknakaranaha iwatsahi sihyrytsa nipupurukuknaha. Deus hyrytsa meky watu. Deus ispe: — O ikiahatsa kahyrytsa tsimoziknaha. Ikiahatsa Sesus harere bo hyỹ tsimykaranahaze ihumo ahaspirikporẽtsa iwatsahi kahyrytsa tsimoziknaha — my. Iwa Deus tahyrytsa soho motsasoko. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","— Deus harere baba zuba — mywata niyzik. Sesus Kiristu maku babata niyzik. Ata zuba Deus tse. Atahi mybo inasik. Mytuk zikzuruku niy. Kytsa tuk ziknapykyryk. Sesus Kiristu sihumo tsimypokzitsiarẽta ziknakara, nisitsumuẽhĩ tsihikik tsimyzihikrẽta wasania ty nisihyrinymyryky. Deus harere ty nisihyrinymyryky. Isoho tsimaha: — O atahi imysapyrẽnikita ipunihikrẽnikita — tsimaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Suão Batista Sesus soho ziwatawyky iwatahi myzubaha bo hua nikara. Atahi: — O Sesus imysapyrẽnikita. Utakta batu. Atahi tazikwy tsizubarẽna my. Utakta batu. Kazikwy tsikaeni zuba. Uta kapurukbyizetu atakta koikny baktatu mykara. Tawahi koikny baktatu my. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Katsaktsa mysopyksapybyitsa tsimykaranaha. Sesus myzibyituhukutu mymysapywyky. Katsaktsa mysopyksapybyitsa tsimykaranaha atahi myhumo tsimypokzitsiarẽta my, iwatahi myzibyituhukutu mymysapywyky hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Tubabatu Moises Deus harere ziwatahaka. Ana harere humo hyỹ tsimykaranahaze, wasani tsimaha, Moises niy. Sesusta mype niy: — O ikiahatsa humo kamypokzitsiarẽta. Ahasopyksapybyitsa tsikykaranaha iwaha humotu Deus ahahumo tsimypokzitsiukrẽta. Deus harere ty nisihyrinymyryky. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ba aty tohi Deus iny. Ikatahi itse zuba ziny. Ata Deus ihumo tsimypokzitsiarẽta. Atahi mybo inasikze, mytuk zikzuruku iwatahi Deus mybo ziwatawy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Iwaze kytsa Sudeja ezektsa taparaktsa ziknapamykysokonahatsa sistsumuẽhĩtsa iwatsa Suão Batista bo kytsa nisipeha. Aty skaraba ikia Suão Batista pe taha. Iwaze Suão Batista bo zumunahaze asahi: — Aty skaraba ikia. Tozeka ja ikia Deus zapehata. Tozeka ja usta ja. Katsa batu myhyrinymyry — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Iwaze Suão tihi: — O batu. Utakta Deus humo kapehabyita atahi kytsa mymyokhyrykta — niy. Iwa nitsasoko. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Iwaze kytsa ipe niahazo: — Aty skaraba ikia. Ikia hi sa Erias — niaha. — Erias byitatu — niy. — Ikia hi sa Deus sohokotsa — niaha. — Tubabatu Moises nitsaso Deus sohokotsa mozumu. Ikia hi sa isohokotsa — niaha. Batu niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","— Iwaze Suão pe niaha mypetykta aty skaraba ikia. Katsa mybo tytsasokta iwaze taparaktsa bo tsimaha. Hawa ikia soho mytsaty tsimykaranaha. Tsinymyry tsihikiknaha — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Suão tihi: — Utakta jerukbara eze hua mykara niy. Opykani motsasoko. Hawa Isaijas Deus sohokotsa tubabatu ziwatahaka atsatu mynakara. Deus harere tsiwabyziukunahaktsa. Iharere bo hyỹ tynakaranahaktsa kytsa mykara — niy. Iwa Suão niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Kytsa zumukunahatsa Suão pehatsitsa, Pariseutsa maha. Ipe niaha: — Ikia Kiristu byitatu Erias byitatu. Deus sohokotsa byitatu tsiky. Iwatatu sa kytsa pihik ty tsimysiharasusuku — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","27","Suão ispe niy: — Utakta pihik ty kytsa mysiharasusuku. Usta ahatuk mykarata. Aba ikiahatsa batu ahany hỹ. Utakta Deus harere ty pahahyrinymyry. Abahi ata kino niwatihi pahahyrinymyry. Izikwyrẽnikita. Utakta tsikaeni zuba kahyrinymyrytatu. Atahi tsihyrinymyrẽta hỹ utakta batu. Iwaze utakta ihumo kasikpybyrẽta. Ipyryksuktsa mysibokik zeka kasikpybyrẽta mozik utakta iwabyita tu my. Atahi imysapyrẽnikita iwatahi utakta kasikpybyrẽta — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Iwa Suão nitsasoko. Kytsa asahi ibo izumukunaha iwa nitsasoko. Betanija eze nisiharasusuku. Betanija koiknykta sak eze buburu Sorodão inarokoha. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Byi izokorozoze iwaze Suão Sesus bo nikozo jokeryk inaukuru. Iwaze Suão kytsa pe niy: — Iktsaziutahaktsa kytsa. Ta maku bo iktsaziutahaktsa. Atahi Deus izipehata. Ziknapamykysokonahatsa hozipyrykzatsa ziknasibakanaha kytsa sisopyksapybyitsa ziknakaranaha, sisapyzeky hozipyrykzatsa ziknasibakanaha. Iwaze Deus sisopyksapybyitsa nikaranaha nisiokzohik. Nawa ata kino mysapyzeky mohyrikosokda. Mysopyksapybyitsa tsimykaranaha atahi mysapyzeky mohyrikosokda. Hozipyrykzatsa watsa — Suão niy. Sesus soho iwa nitsasoko. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Tapara isoho iktsasoko. Ahape iky: — Atahi izikwyrẽnikita ana hi iwaby niy. Uta batu. Kazikwy tsikaeni zuba. Utakta kapurukbyize atakta niwata tu atahi koikny baktatu. Tawahi mynapykyryk — iky. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","33","— Sesus tsimysapyrẽta izikwy tisapyrẽna. Taparaka batu kahyrinymyry. Aba kahyrinymyrẽta. Tapara Sesus zikwy ty batu tyny. Jatu tu Deus zikpeha: “Myzubaha tysiharasusu” niy ana humo hi zikpeha. Myzubaha pihik eze iksiharasusuku. Deus zikpehaze tihi: “Atahi tsimysapyrẽta izikwy tsizubarẽna tsipiny” niy. Iwa tsipiny. “Utakta kahyrikoso myzipeha. Kahyrikoso mynasik amytudu wata mynasikze maku papyry bete inazok. Ata kino tsimysapyrẽta izikwy tisapyrẽna tsipiny. Atahi pahatsumuẽhĩ. Atahi kahyrikoso pipehaze ahatuk mynapykyry hỹ” niy. Iwa Deus kabo nitsasoko. Zikpehaze iharere bo hyỹ iky — Suão niy. Kyze Suão nitsasokozo. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","— Iwaze jobo iktsa iky. Deus tahyrikoso amytudu wata inasikze iktsa iky. Amytudu Sesus papyry bete inazoze ikozo. Sesus Deus zipehata kahyrinymyrẽta. Iwatahi ahabo: “Sesus Deus tse babata tsimysapyrẽta izikwy tsizubarẽna”. Iwa ikiahatsa bo mykara — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Iwaze Suão Batista Sesus bo nikozozo. Suão zinymyrykynahatsa petoktsa tuk niriktohoko. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Iwaze Sesus ziharamuze. — Iktsaziu tahaktsa — Suão niy. — Atahi Deus zipehata. Hozipyrykzatsa wata myzubaha pibezenaha. Sisopyksapybyitsa sapyzeky mohyrikosokda — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Niahatsahi Suão zinymyrykynahatsa iharere ziwabynahaze zerekiknaha. Sesus hapik niukurunaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Sesus tasukpe bo uwok niyze sibo iktsa niy. Ispe niy: — Amo sa kapik tsinakurunaha. Amy sa tsipiberikinaha — niy. — O myhyrinymyrytsa haneze sa awanu sapy — petoktsa iapik niukurunahatsa nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","— Pany! Katuk tyzinyre — niy. Iwaze Sesus hapik niukurunaha. Iwanu sapy bo zumukunaha. Tyk boze niy. Ibaze nidyhydyhykynaha. Ituk nipamykysokonaha. Ibaze tu zunubaiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ãdere inarokota. Atahi Simaõ tsy niy. Suão ziwabyze Sesus hapik niukuru. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Kyze zokorobyi tu atsoko taziky bo niukuru. Zihobykze ipe niy: — O kaziky Deus zipehata Kiristu tsinynaha. Atahi Deus bo mymyoktyhyrykta my — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Iwaze taziky Sesus bo zioktyhyryk. Izumuze Sesus ibo iktsaziu niy. Ipe niy: — O ikia hi Simaõ Suão tse. Abaka mekytu anaro myzik. Sepas ty pinaroko. Sepas Peduru atsatu maha. Petok inarohota atsatu piwatawyky. Atahi harahare wata — mykara. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Iwaze izokoroze Sesus: — Utakta Karireja bo moparak — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Tapara jubyi tu Piripi ziberiki ipe niy: — Aidykta katuk — niy. Piripi Betesaida ezekta niy. Anaeze Ãdere Simaõ ahatsa zikzurukunaha Betesaida ezektsa niaha. Sesus Piripi zihobykze ipe: — O katukta — niy. Piripi hyỹ niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Kyze Piripi Natanieu iberiki zihobykze. Ipe niy: — O Natanieu katsaktsa Deus zipehata tsinynaha. Tubabatu Moises isoho ziwatahakata. Tapara Deus sohotsitsa niwatihi isoho ziwatahakanahatsa. Abaka tsinynaha. Sesus inarokota. Sosetse. Nasare ezekta — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Niytahi Natanieu ipe niy: — Anahi batu kanyhy niy. Tyzeka ja amy Nasare eze ja tisapyrẽna — niy. — Pany katuk iktsa tsimy! — Piripi niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Iwaze Sesus Natanieu bo nikozo. Izumuze Sesus kytsa pe niy: — Iktsataha. Atahi mozumuku Isareu ezekta. Maku mospihikbatabyikita tsimysapyrẽta — niy. Iwa Sesus Natanieu soho nitsaso. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Iwaze Natanieu Sesus pe niy: — Haneze sa tsikny — niy. — O tapara Piripi zaberiki, uta botu any, ikia umaha pukezi tsikdyhykyze anaeze any — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanieu ipe niy: — O ikia Deus tse babata. Ikia Isareu ezekta tu abazubata tsimy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","— O ikia kahumo tsaspirikporẽta. Tapara umaha pukezi tsikdyhykyze any tawy iwatahi kahumo tsaspirikporẽta. Kazikwy hi abazuba bo iktsa tsimy. ");
INSERT INTO rkbNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Utakta maku babata iknasikta ahawata ikyzik, ikiahatsa bijoikpe zoksapare naha bo iktsa tsimy. Kyze tsipinynaha bijoikpe iknyktsa Deus tsumuẽhĩtsitsa kabo nasik nasikiknaha. Iwaze neduk nedukuknaha. Ana hi tsipinynaha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Kyze petok zuruze Sesus mysukzawy bo niukuru. Mywanu horokwy myikaha Kanaã eze. Kanaã Karireja eze niy. Sesus je imyikaha bo niukuru. Sesus tuk zinymyrykynahatsa kino niwatihi imyikaha bo niukurunaha. Tapara zihitsa ispe niy: — Pany! Kamyikaha bo tynaha — niy. Yhỹ niaha. Iwaze simyikaha bo niaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Kyze duabohotsa tsik zikukunaha. Iwaze duabohotsa tsik nipykze Sesus je tihi tatse pe niy: — Katse duabohotsa tsik nepykba — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","— Kaje amykzo byihuktsa. Abaka Deus zikwy piwatawy zeka batu wasani ziky — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Niytatsahi zihitsa tsumuẽhĩtsa pe niy: — O kytsa katse ahape my zeka hyỹ tsimaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Bytykareze tu pihik suk niapykyryk. Napetok napetok napetok pihik suk niy. Pihik suk morosuk ibuzoinikia zuba tsipomobyitsa. Sudeutsa tapara tahadisahakanaha tahatsyhyrypikiknaha. Bykyze tahatsyhyrypikikzonaha simypewytsa niwatihi nisiokipikiknaha. Siwahoro eze pihiksuk tsizubarẽna. ");
INSERT INTO rkbNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Iwaze Sesus zihitsa tsumuẽhĩtsa pe niy: — Pihik ty susutaha! Pihiksuk tyzihareknahaktsa! — niy. Hyỹ niaha. — Pihik ty zak bo tu tyharektaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Iwaze pihik ty zihitsa bo nyny tsimaha — ispe niy. Hyỹ niaha. Iwaze pihiksuk ty okok maraksu maraksu nikaranahaze iwaze zihitsa bo wabehyryk niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Pihik tu duabohotsa tsik niyzik. Zihitsa ziakpy. Zihitsa batu inyhy. Aty sa pihik duabohotsa tsik nizuknihik anahi batu inyhy. Sitsumuẽhĩtsa zuba zinymyrykynaha. Niytahi zihitsa tasukzakata pe niy: ");
INSERT INTO rkbNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","— Taparaka kytsa bo duabohotsa tsik tisapyrẽna situktsa bo nyny ziknakaranaha. Bykyze tahasoroknahaze zuba duabohotsa tsik isapybara ty situktsa bo nyny ziknakaranaha. Ikiakta batu. Aba zuba ikia duabohotsa tsik tisapyrẽna tsipokzitsarẽna mybo nyny tsiky — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Iwaze Sesus zinymyrynahatsa ihumo sispirikporẽtsa. — O atahi Deus zikwy ziwatawy — nikaranaha. Tapara Deus zikwy Kanaã ezektsa bo ziwatawyky. Kanaã Karireja eze niy. Anaeze hi Deus zikwy Sesus tuk niapykyryk niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Niahatsahi Kaparanaũ hudikhudikwy bo niaha. Sesus, taje, tatukytsa, zinymyrykynahatsa ahatsa Kaparanaũ bo zumukunaha. Anaeze niapykyrykspyknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Kyze Sesus zinymyrykynahatsa tuk Serusarẽhe bo niukuru. Sudeutsa myikaha bo pororo ziknakaranaha. Tubabatu Deus taparaktsa Esito ekze mekybotu nisioktyhyryk ana bo hi mytsaty ziknakaranaha. Myikaha paskoa inarokoha niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Deus wahoro zubata isturupeze bo zumuze nitsuk. Anaeze kytsa sizubarẽtsa bo nikozo. Wastuhutsa pikuzatsa ty, hozipyrykzatsa ty, amytudutsa ty iwatsa ty nisihuakaknaha. Ustsa kytsa okyrysaro humo harape bo zihuakaknaha. Anaeze nidyhydyhykynaha. Kytsa inapupunahaze siokyrysaro ty zihuakzonaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Sihumo Sesus taokaniki. Pikuzatsa hwyk tsaziki ty tsizezerẽna ty wabe niy. Kytsa ipokso zipobaiknaha. Aidy nitururuknaha. Kytsa tahapybyspyk niwakbaiknaha. Hwibihitsa nisitsihipetotokbaik. Okyrysaro tsizubarẽna zitõbaik. ");
INSERT INTO rkbNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Sesus opykani huahua niy: — Ahanamy ty ka wabehyryktaha! Ikiahatsa kazo wahoro zubata eze ahanamy zozowy tsikzukninaha ba zikaha. Niwazubaktsa. Nabo pãotaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Iwaze zinymyrykynahatsa ibo iktsa nikaranahaze mytsaty nikaranaha. Tubabatu Deus harere papeu humo ziwatahaka ana bo hi mytsaty nikaranaha. — O Deus awahoro zubata kytsa ataeze hi simysapybyikitsa mykaranaha. Iwatahi taokaniki — niy. Iharere bo mytsaty nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Iwaze Sudeutsa taparaktsa Sesus pe niaha: — Aty sa ape niy: “Kytsa Deus wahoro zubata eze tysiksiwyhiktsa!” Aty sa anaharere ape niaha. Deus zikwy ty mybo tsiwatawykta! Deus zikwy mybo tsipiwatawy zeka wasani — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Sesus ispe niy: — Ikiahatsa Deus wahoro zubata tsipitsehepetotokbaiknaha zeka usta wahoro mektatu mozoknizo. Mektatu ezytyk mozoknizo. Harakykbyihi puru nahatuk tu pikymy hỹ — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","— Batu ba niaha. Harakykbyihi puru nahatuk tu Deus wahoro zubata mektatu ba zikukni mybarapetu tsimykara — niaha. — Mytukytsa tubabatu tawahoro nizuknikinaha, kuarẽta seis niytyk tseheze zikymynaha. Paze harakykbyihi puru nahatukta zuba mektatu ba zikzuknizo — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Sesus harere humo batu sihyrinymyry. Iharere tsihokdaharẽna. Nitsasokoze wahoro tanury humo ziwatawyky. Inury wahoro wata niy. Mohyrikosokdaze petok puruze mynahyrizikpo mykara. Anahi ziwabykynahatsa batu sihyrinymyry. ");
INSERT INTO rkbNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Sesus nahyrizikpoze anaharere bo mytsaty nikaranaha. Iharere ty zinymyrykynahatsa mytsaty nikaranaha. — Deus harere wasani my, hawa ha ty Sesus nitsasoko inury soho atsatu niy — nikaranaha. Iwaze iharere bo hyỹ nikaranaha ihumo sispirikporẽtsa niyziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Sesus Serusarẽhe eze tuze kytsa sizubarẽtsa ihumo sispirikporẽtsa moziknaha. Paskoa myikaha myze sizubarẽtsa ihumo sispirikporẽtsa moziknaha. Deus zikwy ty ituk iktsa nikaranahaze iwatsahi iharere bo hyỹ nikaranaha ihumo sispirikporẽtsa niyziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Sesus sibo tasoho ty batu watawy sihumo tsimytsatyharẽta nikara. ");
INSERT INTO rkbNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Kytsa mytsaty mykaranaha ana humo hi Sesus tsihyrinymyrẽta. Sesus batu tyso: — Hawa takta sa mytsaty my — my. Iwa batu tyso. Amy ty kytsa mytsaty mykaranaha humo tsihyrinymyrẽta hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","2","Unata eze Nikodemus inarokota Sesus bo zumu. Taparakta Pariseutsa Sudeutsa niy. Atahi unata wahoro hara bo nidoko. Atahi: — O myhyrinymyrytsa! Ikia mopyktsa babata tsihyrinymyrẽta. Deus zikwy ty kytsa bo tsipiwatawyky. Ikia zuba Deus harere bo hyỹ tsimykara iwatahi Deus zikwy ty mybo tsipiwatawyky. Iwaze katsa tsimytsasokonaha Deus ikia zapehaka tsimykaranaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Sesus ipe niy: — Tsiwabytotokta! Hawa haja motsasoko wasani my. Ikia kyripuruzo ahahabyizeka batu Deus tyryk zikyzik. Deus tyryk tsimozik tsihikik zeka tsimypurukzokta — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Iwaze Nikodemus hi: — Hawa sa maku taypykta tu mopurukzo. Taje harakoke bo ba ziktsukzo — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Niytahi Sesus ipezo niy: — Hawa motsasoko wasani my. Maku pihik ikny nipurukze niy. Maku mopurukzoze Deus hyrikoso ituk mynapykyryk iwaze Deus tyryk mozik. Iwa mopurukzo zeka Deus tyryk mozik. ");
INSERT INTO rkbNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Tsikpuruknahaze myje ikny katsa myzotsa hyrytsa zuba tsimaha. Katsa tsimypupurukzonahaze Deus hyrikoso humo iwatsahi katsa Deus tyryk tsimoziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Iwatahi ape my: “Tsimypupurukzonahakta” my. Iwaze ikia batu apyby Deus tyryk tsimozikta iwa abo motsasokoze mytsaty mytsaty byity tsimy. ");
INSERT INTO rkbNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Zopoktsa nabybykyknahaze hana ikny ja batu myhyrinymyry siakpyri zuba piwabynaha. Hana bo mokurunaha batu myhyrinymyry. Ba nabo myku zikaha. Atsawatu hawa Deus tyryk tsimozik batu ahyrinymyry, Deus hyrikoso kino zopoktsa waha nabybykyk my. Hana ikny ja batu myhyrinymyry. Hana bo ja batu myhyrinymyry. Katsa Deus hyrikoso humo ityryk tsimoziknaha iwa ahahyrinymyrẽtsa zuba — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Iwaze Nikodemus ipe niy: — Hawa sa my. Aharere humo batu kahyrinymyry — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Sesus niy: — Ikiakta Isareu ezekta sihyrinymyrykytsa iwatatu sa batu ahyrinymyry. ");
INSERT INTO rkbNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Amy ty inymyryky hi anahi motsasoko. Amy ty botu iwaby anahi zuba motsasoko. Tanyhyhi motsasoko. Ikiahatsa kaharere batu ahakparawy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","— Ikiahatsa Deus tyryktsa tsimoziknaha ana soho hi motsasoko. Anahi motsasokoze kaharere humo batu yhỹ tsimaha. Kaharere bo hyỹ tsimaha zeka hawa Deus tuk ahawahi tsimynapykyknaha anatyhi yhỹ tsimaha — my. — Kaharere Deus tuk ahawahi tsimynapykyryknaha soho anatyhi hyỹ tsimaha. Batu ahahyrinymyry mytsaty my. ");
INSERT INTO rkbNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Uta zuba bijoikpe ikny iknasik. Iwatahi kytsa bo motsasoko. Ziknynaha tahi kytsa bo motsasoko. Utakta Deus zikpehata ahawata ikyzik niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Tubabatu Moises pyryhyk hyrikoso barõse nizukni. Na pyryhyk hyrikoso hwi humo typu niy. Kytsa simyitsapyrẽtsa pyryhyk hyrikoso bo iktsa nikaranahaze nizororokonaha. Atawahi utakta Deus zikpehata kytsa wata ikyzik iwaze kytsa iharapatawyhyta humo pikyriziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Kytsa kaharere bo hyỹ mykaranaha zeka kahumo sispirikporẽtsa maha. Kytsa kahumo mospirikponaha zeka Deus tuk tahawahi mynapykyryknaha. Kahumo sispirikporẽtsa Deus tuk tahawahi mynapyrykyknaha hỹ ");
INSERT INTO rkbNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Yhỹ, Deus mybarawy ezektsa humo tsimypokzitsiarẽta. Nawatsa humo tsimypokzitsiarẽta babata. Iwatahi tatse zipeha. Estuba zuba itse babata. Asaktsa kahumo mospirikponaha zeka Deus tuk mynapykyryknaha, ituk tahawahi mozurukunaha. Deus tuk mynapykyryknaha ba zikykbazonaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Deus tatse izipehaze myhumo iakyri byita. Ba kaeze ẽryk zikahasapynaha. Iwatahi uta mozumuze kazo bo pahaoktyhyryk niy iwaze mybarawy ezektsa humo batu iakyri. ");
INSERT INTO rkbNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Aty Deus tse babata humo ispirikpo zeka Deus bo mymyoktyhyryk. Deus ihumo ba ziktaokani. Aty kaharere bo hyỹ ahabyi zeka atahi Deus bo ba zikmyoktyhyryk Deus ihumo tsiakyriukrẽta. ");
INSERT INTO rkbNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Deus tatse zuba zipeha. Sizubarẽtsa sisopyksapybyitsa tu nikaranaha nisiwatawyky. Wasani mykara nisiwatawyky. Atahi okoroze ky wa. Myzubatsa ihumo batu siakparawy. Sisopyksapybyitsa nikaranaha iwatsahi ihumo batu siakparawy. Asahi miwa ha nizihikiknaha. Iwatsahi batu ihumo sispirikpo. ");
INSERT INTO rkbNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Sizubarẽtsa sisopyksapybyitsa tu nikaranaha ana humo hi kaharere bo batu yhỹ zikaha. Sisikpybyrẽtsa ustsa kytsa humo. Asahi kytsa papatu nikaranaha, asaktsa sibo iktsa mykaranaha zeka sisikpybyrẽtsa. Miwa ezektsa watsa ustsa ba ziksinynaha. Iwa humo hi sisikpybyrẽtsa. ");
INSERT INTO rkbNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ustsa kytsa kaharere bo hyỹ mykaranaha simysapyrẽtsa, kahumo sispirikporẽtsa iwatsahi tisapyrẽna ty mykaranaha. Ihumo wasani mykaranaha ana humo hi kytsa sihyrinymyrẽtsa. Iwororoha ezektsa watsa ustsa mysinynaha batu sisikpyby — niy. Iwa Sesus Nikodemus tuk nipamykysoko. ");
INSERT INTO rkbNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Kyze Sesus tuk zinymyrykynahatsa ituk Sudeja bo niukurunaha. Anaeze niapykyrykspyk naha kytsa nisiharasusuku. ");
INSERT INTO rkbNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Suão Batista niwatahi myzubaha nisiharasusuku. Eno eze. Eno Sarĩ pauk baze niy. Pihik tsizubarẽna eze hi nisiharasusuku. ");
INSERT INTO rkbNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Suão ihurukuhubyizetu myzubaha nisiharasusuku. Aiba tohi zuba kytsa sakyriukanikitsa hurukwy bo nitsahuruknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Suão Batista tuk zinymyrykynahatsa Sudeu zipehakanaha. Asahi: — Aty sa wasanita nikaranaha Suão nisiharasusukuze ja nikaranaha. Sesus nisiharasusukuze ja. Aty sa wasani — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Iwatsahi Suão pe niaha: — O myhyrinymyrytsa! Botua ikia amakta taba buburu tsiky. Mytuk maku nipykyrykspyk. Botua isoho ty mybo tsiktsasoko, Sesus my. Atahi myzubaha nisiharasusuku. Sizubarẽtsa iapik mokurunaha. Ikia hapik ba ziktururuknaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Iwaze Suão ispe niy: — Ana humo hi kakurẽta my. Deus zuba tazikwy ty myzubaha bo nyny my. Asaktsa Deus humo Sesus harere piwabytotokonaha asa bo hi izikwy ty sibo nyny my — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Botua ahabo iktsasoko. — Utakta Kiristu byita atakta Deus zipehata my. Taharaze zuba zikpeha — niy. Iwaze isoho motsasoko. ");
INSERT INTO rkbNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","— Maku tasukzata tsakurẽta my. Itukta kino niwatihi ihumo tsakurẽta. Tasukzata mokozoze itukta ihumo tsakurẽta. Utakta itukta wata my. Myzubaha Sesus tuk mokurunaha, ana bo hi mokozoze kakurẽta. Isukzata tukta wata my. ");
INSERT INTO rkbNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Sesus zinymyrykynahatsitsa sizubarẽtsa. Katuk zinymyrykynahatsa batu sizuba. Wasani my iwatahi kakurẽta — my. Iwa Suão zinymyrykynahatsa pe niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Atahi bijoikpe iknykta tsimysapyrẽta my. Ata zuba tispirikporẽta. Mybarawy ezektsa batu. Aparakbahatsa tsikaeni zuba sihyrinymyryrẽtsa maha. Mybarawy soho eziky ty zuba mopamykysokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Atakta bijoikpe iknykta ihyrinymyrẽnikita hỹ. Ata kino nikozo naha zuba motsasoko. Ziwaby naha zuba motsasoko. Batu sizuba iharere bo hyỹ mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Kytsa iharere bo hyỹ mykaranahaze asahi — Deus tsimysapyrẽta wasape mykara — mykaranaha ");
INSERT INTO rkbNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","35","Deus tihi: — Utakta katse Sesus pipehaka. Ihumo kamypokzitsiarẽta. Kahyrikoso ituk tawahi mynapykyryk. Kahyrikoso hi izikwy kazikwy hi atsatu my. Ata kino wasaniha zuba natsasoko. Kahyrikoso humo zikwy tsizubarẽna — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Iwaze aty Deus tse harere bo hyỹ mykara, atahi meky watu mozik, atahi tawahi Deus tuk mynapykyryk. Aty Deus tse harere bo yhỹ ahabyi zeka, atahi Deus tuk ba zikykpykyryk. Deus ihumo takyri, iharere bo yhỹ ahahabyizeka iwatahi ihumo Deus takyri. Atahi Deus tuk batu tawahi mynapykyk niy, sinini ykarawy bo myzipeha. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Kyze Sesus niukuru Sudeja bo Pariseutsa pokso niparak. Tapara kytsa Pariseutsa pe niaha: — O kytsa Sesus hapik sizubarẽtsa. Atahi kytsa sizubarẽtsa nisiharasusuku. Suão Batista tuk zinymyrynahatsa batu sizuba maha — mybarapetu nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Sesus kytsa batu isty harasusu. Zinymyrykynahatsa zuba kytsa nisiharasusuku naha. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Anahi Sesus ziwabyze Sudeja ikny niparak. Karireja bo ziksizo. Zinymyrykynahatsa ituk niukurunaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","— Samarija bo koiknyktsa kytsa! — Sesus niy. Yhỹ nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Niahatsahi Sikare myzubaha bo zumunaha. Tubabatu taparakta Sako nihyrikosokdaze tahudikhudikwy Sose bo nyny niy itse ziakse. Sose nihyrikosokdaze niwatihi itsekokatsa tahudikhudikwy ziaksenaha. Sikare myzubaha baze tu nihyrikosokdata Sako hudikhudikwy niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","8","Iwaze Sesus pihik zokowy bo izumu. Tapara Sako tykoke nizukninaha. Tokbaha niyzikikze Sesus iakubyrizumu tahi pihik zokowy baze nidyhyky. Zinymyrykynahatsa myzubaha bo niaha. Tahadisahawy bo nitururuknaha. Iwaze wytyk Samarija ezektatsa nabo izumu. Pihik zotsata niparaktatsa Sesus zihobyk iwaze ipe niy: — O kaboktsa pihik ty uta piku — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","— Batu ikiakta Sudeja ezekta hỹ. Ikza Samarija ezektatsa. Iwaze amo sa “Kabo pihik ty maraktyktsa” tsimykara — niy. Sudeutsaktsa ba Samarija ezektsa opowysuk eze ka ba zikunaha iwatatsahi hỹbyi nikara. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Sesus: — O amy tisapyrẽna zuba Deus abo nyny my hỹ. Ana humo hi ja tsahyrinymyrẽtatsa “Kaboktsa pihik ty” botu ape iky — niy. Amy tsa ty hỹ zeka iwatahi Sesus niy. — Ikia batu kabo nyny tsimy. Tsikny zeka ikia kino “kabo ky pihik ty” tsimyze. Yhỹ my. Utakta Deus pihik baba ty abo nyny my. Ana tsipikuze mekywa tu tsimozik. Tsimyhyrikosokdaze tsinahyrizikpoze, Deus baze awahi tsimynapykyryk — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Niytatsahi: — O ikia sa batu apihikzowyky pihik zowy tsiokitsihizezerẽna batu izowyky. Hawa sa pihik ty marak tsimy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","— Tubabatu mydiri nihyrikosokdata Sako tykoke ziuku. Iwatahi pihik atsaeze ky zikzikuku. Ihyrytsa niwatihi pihik zikzikukunaha. Siraratsa kino niwatihi pihik zikzikukunaha. Niytahi pihik hoke itsekokatsa ziaksenaha. Mybo nizapikso. Sako harere kytsa ziwabyziunaha. Maku abazubata niy, pihik zikuku. Hawa skaraba ikia hi ja abazubata — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Niytahi Sesus ipe niy: — Aty na pihik piku zeka tsiarupukrẽtazo. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Uta pihik ty abo nyny maha tsipiku zeka ba iarapuruk zikzumuzo. Pihik mekywaha ty abo nyny my. Hawa pihik pupuputsa watsa pihik batu zepyk pihik ty abo nyny my zeka awahi tsimynapykyk iwatatsahi ba iarapuruk zikzumuzo. Ba ziktsehezo pupuputsa watsa iwaze mekywa tu tsimyzuruku. Tsimyhyrikosokdaze tsimynahyrizikpo iwaze awahi Deus tuk tsimynapykyryk — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ana ziwaby tatsahi: — Ana pihik ty kabo nynyty ky niy. Iwaze ba karapuruk ziyk. Ana pihik ty kabo nyny tsimyzeka pihik ba zikzizozo — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Niytahi: — Abarikta kabo tyzioktyhyktsa! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","— Batu ba. Ikza ba kabarikta ka — niy. — Ikia wasape tsiky niy. Tsiktsasoze “Ikza batu kabarikta ka” wasape tsiky. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ikia kytsa katsyhyrytsa watsa tu tsiksiakse. Abakta abariktabyitatu aktaba haĩ niy. Deus okzeka batu amysapy iwaze kape tsikyze: “Ikza batu kabarikta ka” wasape tsiky — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Iwaze ipe niy: — Ikia Deus sohokotsa babata tsimy. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Katsa tsimypamykysokonaha anaeze hara bete Deus pe “O ikia tsamysapyrẽta” tsimykaranaha. Iwa mydiritsa nihyrikosokdanahatsa nimyhyrinymyrykynaha. Ikiahatsa Sudeutsa tsimypamykysokonaha, nabo Serusarẽhe eze zuba Deus pe. “O ikia tsamysapyrẽta” tsimykaranaha. Aty sa wasani mykara — niy. Iwa atatsa Sesus pe niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Niytahi: — Aibani hara bete Deus bo batu tyso “O Deus myzo ikia zuba tsamysapyrẽta” tsimaha. Serusarẽhe eze Deus bo batu tyso. “O Deus myzo ikia zuba tsamysapyrẽta” tsimaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","— Ikiahatsa Samarija ezektsa tsimaha. Deus soho humo ahahyrinymyry byitsa tu ikiahatsa tihi: “O Deus ikia tsamysapyrẽta” tsimykaranaha. Ikiahatsa batu ihumo ahaspirikpo. Katsaktsa Sudeutsa tu. Ihumo myspirikporẽtsa. Deus Sudeutsa nisinyky. Deus bo mymoktyhykta niyzik. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Kyze abaka ikiahatsa Deus tyryktsa tsimoziknaha. Iharere bo hyỹ tsimykaranaha. Amy motsasoko anaty hi tsimykaranaha. Wasani tsimaha. Iwaze Deus ahahumo tsakurẽta. Iwa tsimyzurukunaha zeka tsakurẽta — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","— Deus inurybyita ihyrikoso zuba my. Batu zinynaha. Kytsa Deus humo sakurẽtsa maha zeka wasani mozurukunaha. Hawa wasani zuba motsasokonaha. “O Deus ikia zuba tsamysapyrẽta mykaranaha” — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Kyze atatsa ipe niy: — Deus myzipehata mywata mybarawy bo mynasik. Kiristu mozumuze ihumo myspirikporẽtsa tsimoziknaha, atahi Deus bo mymyoktyhyryk niy. Ana humo hi kahyrinymyrẽtatsa — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","— Uta hiba Deus zikpehata. Utakta abo mopamykysoko Deus zikpehata my — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Iwaze babatu zinymyrykynahatsa sidisahawy tuk ziksikizonaha. Sesus atatsa tuk iktsa niahaze paikpa mytsaty nikaranaha. Batu tyso niaha — O Sesus amo sa ituk tsikpamykysoko. Hawa sa ituk tsikykara — iwa batu tyso nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Niytatsahi taopowysuk zerekik atsoko myzubaha bo niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Myzubaha ezektsa pe niy: — Pany. Maku bo ky niy. Atahi pihik zowy baze nidyhyky. Hawa ha ty ziknakara naha ty kabo nitsasoko. Kiristu Deus zipehata ja iky. Pany ibo ky — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Yhỹ nikaranaha. Iwatsahi myzubaha ezektsa Sesus bo zumukunaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Iwaze batu sibo zukbyize zinymyrykynahatsa hi: — O myhyrinymyrytsa amy ty hauktykta — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","— O batu ba. Uta kino meky watu kadisahawy. Ahanyhybara — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Zinymyrykynahatsa asa zuba nipamykysokonaha: — Aty kok idisahawy ibo zibykare nikaranaha. Mypapatu kok idisahawy ty ibo nyny niy — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Sesus ispe niy: — Pikdisaha zeka kakurẽta my — niy. — Atsawatu kazo harere bo yhỹ my zeka kakurẽta babata mykara. Kazo zikpehatawy iharere humo yhỹ ikykaraze kakurẽta. Iharere nihawatu my zeka kakurẽta mykara kasoroktawa mokuru. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ikiahatsa hi: “Napetok napetok nawaze byzoje morahaze kyze arostsa moakuknahaze. Mydisahawytsa mokymynahaze arostsa tahazyzyknaha!” tsimaha. Iwa tsimytsasokonaha. Utakta ahape my: “O batu. Abatu nikymy”. Atsawatu mytsaty tsimykaranaha “O kytsa batu sizuba Sesus humo sispirikporẽtsa maha” tsimaha. Ahape my. Iktsa tsimahaktsa! my. Kytsa asahi kaharere bo hyỹ mykaranaha kahumo sispirikporẽtsa sibo iktsa tsimahaktsa! Abatu kahumo sispirikporẽtsa maha. Ba byri hu tsimaha. Arostsa moakuknahaze tsa watsa abatu kytsa kaharere bo hyỹ mykaranaha kahumo sispirikporẽtsa maha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","— Maku siriktsa nisiparikik niy. Mektatu arostsa nisizyzykyk niy. Kytsa petoktsa arostsa humo sakurẽtsa. Atsawatu maku kasoho motsasoko, mektatu kasoho humo mysihyrinymyry iwatsahi kytsa kahumo sispirikporẽtsa, ana humo hi kytsa petoktsahatsa sakurẽtsa. Iwatsahi kytsa kahumo sispirikporẽtsa sakurẽtsa hỹ. Asahi nahyrizikponahaze katuk tahawahi mynapykyryknaha ana humo hi sakurẽtsa hỹ — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","— Estuba maku atazuba mysiparik iwaze maku mektatu mysizozek mykaranaha. Wasani maha. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Atsawatu estuba maku hi kasoho kino motsasoko mekta tu kytsa kahumo mysihyrinymyrykynaha. Iwatsahi kytsa sizubarẽtsa kahumo sispirikporẽtsa. Kaharere tsimytsasokonaha zeka ana humo hi kytsa kaharere bo hyỹ mykaranaha. Kahumo sispirikporẽtsa zeka mekywatsatu moziknaha. Ustsa kytsa botu kasoho nitsasokonaha iwatsahi siharere humo kaharere bo hyỹ mykaranaha iwaze sispirikporẽtsa moziknaha iwatsahi ahakurẽtsa tsimaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Kyze Sikare ezektsa Sesus bo zumukunaha. Ihumo sispirikporẽtsa. Atatsa harere ziwabynahaze Sesus harere bo hyỹ mykaranaha iwatsahi ihumo sispirikporẽtsa moziknaha. Atatsa nitsasokoze: — Hawa ha ty ziknakara naha ty kabo nitsasoko — atatsa harere ziwabynahaze. Iwatsahi Sesus humo sispirikporẽtsa hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Iwaze Samarija ezektsa zumukunahaze ipe niaha: — Pany mywahoro bo paku tyny — nikaranaha. Yhỹ niy. Anaeze situk petok zurure. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Mektsatu ihumo sispirikporẽtsa. Sibo nitsasokoze myzuba ihumo sispirikporẽtsa. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Asakino atatsa pe niaha: — Tapara katsaktsa Sesus bo hyỹ tsimaha ihumo myspirikporẽtsa aharere humo tsikykaranaha. Abaka katsa ihumo myspirikporẽtsa iharere humo. Atahi mybarawy ezektsa mysioktyhykta — nikaranaha. Iwa atatsa bo nipamykysokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Kyze petok zuruze Sesus Karireja bo ziksizo. Samarija ekzekta niparak Karireja bo niukuru. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Tapara Sesus ziknatsasoko — O Deus sohokotsa tahudikhudikwy ezektsa okzeka iharere bo batu waby zikaha. Utsa kytsa iharere bo piwabyziukunaha, tahudikhudikwy ezektsa batu — Sesus niy: ");
INSERT INTO rkbNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Kyze Sesus bo zumuze Karireja ezektsa Sesus humo sakurẽtsa nikaranaha. Asahi Serusarẽhe amyikaha bo niaha. Anaeze Sesus bo nikozonaha. Deus hyrikoso ituk mynapykyryk zinynaha. Deus zikwy ituk zinynaha. Iwatsahi sibo zumukuze sakurẽtsa nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Iwaze Kanaã bo ziksizo. Pihik duabohotsa tsik nizukni nahaeze, Kanaã Karireja eze tu niy. Kyze taparakta Kaparanaũ myzubaha ezekta Kanaã eze tu niy. Atahi: — Katse tsimyitsapyrẽta. Asiba zumuzata atahi Kaparanaũ eze nihoeke, asiba nira — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Iwaze kytsa taparakta pe niaha: — Sesus izumu Sudeja iknykta. Karireja bo. Mybo izumu — niaha. Iwaze taparakta Sesus bo zumuze ipe niy: — O Sesus tupakta kawahoro bo tsimy, katse moraka. Pany katse tyzizororowykta! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Sesus ipe niy: — Kytsa kahumo batu sispirikpo. Tapara Deus zikwy humo piwatawyky. Anabo hi iktsa mykaranahaze iwatsahi kaharere bo hyỹ maha iwaze kahumo sispirikporẽtsa — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","— O pany Sesus! Aidytykta, katse irabyitu — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","— Tsiksizokta! Awahoro bo atse botu nizororo. Tsakurẽta niyzik — Sesus niy. Maku Sesus harere bo hyỹ nikara ihumo tispirikporẽta nikara. Iwatahi tawahoro ziksikizo. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Atazuba tawahoro bo ziksikirize ske pukteze tu itsumuẽhĩtsitsa zihobyknaha. Ipe niaha: — Atse nizororo. Iwatahi tsakurẽta — nikara. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","— Katse sa nizororo haramwe haneze ja — niy. — O jatu tokbaha eze atsoko jokboha niyzik. Abaka iakzobyita mopykyryk baba zizororo niy — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Jatu kino haramwe tokbahaze Sesus tihi: — Atse botu nizororo — niy. Iwa Sesus kape niy. Anabo hi mytsaty nikara. Iwatahi Sesus humo tispirikporẽta niy. Iwahoro ezektsa kino niwatihi Sesus humo sispirikporẽtsa niyziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Iwahatu Sesus Deus zikwy ziwatawyky. Sizubarẽtsa bo Deus zikwy ziwatawykyzo niy. Karireja ezektsa bo Deus zikwy ziwatawy. Sudeja ekze niparakze Deus zikwy petok ziwatawy niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Iwaze Sesus Serusarẽhe bo niukuru. Sudeutsa myikaha bo Serusarẽhe bo zumuku. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","3","Serusarẽhe eze zarape waha eze niy. Zarape Betesda inarokoha Sudeu harere niy. Betesda zarape waha eze Serusarẽhe hokbowytsa baze niy. Hokbowy hozipyrykzatsa ty inapupukunaha inarokota zumubahani. Iwa katsyhyry watsa iwatsa hokbowytsa iwa niaha. Anaeze kytsa sizubarẽtsa ziknakpykyryknaha. Simyitsapyrẽtsa niaha. Sihyrizikubyitsa, siekbyritsa, sityryktsa niakbabatsa, pãozikahabyitsa iwatsa anaeze ziknapykyryknaha. Sizubarẽtsa ziknasisperykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Bijoikpe iknykta Deus tsumuẽhĩtsa pihik wastuhu ziknasikik. Pihik zikziktsik pepepewyky. Pihik zikzitsikpepepewykyze kytsa pihik bo ziknautsotsokoknaha. Aty tapara ziknahazukukze zikzizororowy ky. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Anaeze hi Sesus zumu. Maku bo iktsa niy. Atahi tubabatu tsimyitsapyrẽta sinini ziknakara niy. Tirĩta oito anos niytyk tseheze sinini ziknakara. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Sesus ibo iktsa niy. Tubabatu ziknahoekek ana humo hi tsihyrinymyrẽta. Iwaze ibo iktsa niyze ipe niy: — Ikia skaraba hawa tsimy tsimyzororo tsihikik sa — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","— Yhỹ niy. Myzororo ikykarazetu — niy. — Batu aty tohi katukta ziky. Batu aty tohi zikmokty pihik bo niy. Uta zuba zeka batu pihik bo ziksi. Iwatahi mektsatu katy haraze mykaranaha hỹ pihik bo. Utakta batu. Mektsatu zuba nazororoko naha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Iwaze Sesus ipe niy: — O kyiktykta! Awanu ty kokpuhyktykta. Tsiksikta — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Atsoko itarikto. Tawanu ty kokpuhyryk niy. Niparak niy. Tsakurẽta nikara hỹ. Nawazuruze Sudeutsa byrywy zumuze hỹ nikara. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Iwatsahi Sudeutsa izororowyhyta pe niaha: — Aba katsa Sudeutsa tsimymybyrykynaha niaha. Ikia tarabaja tsimykara. Wasanibara tsimy. Ikia awanu tsipisik, iwatahi tarabaja tsimykara — niaha. Myhyrinymyrywy tihi: — Mybyrywy pumuze batu tarabaja zikaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Iwaze izororowyhyta ispe niy: — Zikzororowyta tihi kape niy: “Awanu ty kokpuhyryktykta tsiksikta” — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Niahatsahi ipe niaha: — Aty skaraba ape. “Awanu ty kokpuhyktykta tsiksikta!” niy — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","— Batu kanyhy. Inaro batu kawabyhy — niy. Kytsa batu ity nyzo. Kytsa sizubarẽtsa anaeze niy. Iwatahi Sesus niparak. Iwatahi maku naro batu iwabyhy. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kyze Sesus izororowyhyta. Deus wahoro zubata eze zihobyk. Ipe niy: — Abaka ikia tsikzororo hỹ awatu ty. Tsimynamysapybyi zeka sinini tsimykara — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Iwaze izororowyhyta Sudeutsa bo ziksizo ispe niy: — Maku Sesus inaro atahi zikzororowy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Iwatsahi Sudeutsa Sesus nizokyrykynaha. Sesus maku zizororowy zuruze tahabyrykynaha ana humo hi tahakyrikinaha. Iwatsahi Sesus zimyijakaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Sesus ispe niy: — Kazo tarabaja mynakara, batu pyk ziky. Uta kino niwatihi tarabaja mynakara — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Iwaze Sudeutsa taparaktsa zibeze tsihikiknaha. Tapara maku zizororowy. Sudeutsa byrykywy eze tuze maku zizororowy. Bykyze nitsaso Deus kazo isopyk niy. Nitsasokoze Deus kazo my, tazikwy Deus zikwy atsatu my nikara. Iwatsahi ihumo tahakyrikinaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Iwaze Sesus taparaktsa pe nitsasokozo: — Hawa motsasoko wasi my. Deus tse babata my. Atazuba batu. Atazuba batu mykara. Hawa Deus mykara naha ty zuba mykara. Hawa Deus motsasoko naha atsatu motsaso. Kazo tsizubarẽna mykara atsatu mykara pisopykzuku — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","— Iwahatu Deus kahumo tsimypokzitsiarẽta. Tatse humo tsimypokzitsiarẽta. Iwatahi hawa mykaraze tatse bo piwatawyky. Utakta ihumo myzisopykzuku. Nawa kasoho mytsaty mykara. Jaba maku ityryk niakbabata izororowy anabo hi iktsa tsikaha. Abahi kazo tsizubarẽna kabo piwatawyky. Kabo piwatawyky zeka pahawatawyky. Ikiahatsa hi: “O tisapyrẽna tsimaha.” Tsimypybynaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","— Kyze Deus siakbatsa mynasihyrizikpobawy. Uta kino niwatihi. Kahumo istsihitsa mysihyrizikpowyzo. Deus tse humo mynasihyrizikpoba. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Deus mybarawy ezektsa bo batu tyso “O ikia wasani tsimykara. Usta pe batu amysapy tsimykara” my. Batu. Uta zuba mybarawy ezektsa pe: “Ikia wasani” mykara. Usta pe: “Ikia batu amysapy” mykara — iwa Deus harere kape niy. — Ikia zuba mybarawy ezektsa soho tsipiwatawyky. Aty ja imysapybyikita tsimytsasoko. Aty tsimysapyrẽta tsimytsasoko — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","— Iwatsahi sizubarẽtsa kasoho humo maha “O ikia Deus tse babata. Aharere tsipiwabynaha. Tsimyharerewabyrẽta tsimy” maha. Asa kino niwatihi Deus harere piwabykynaha. Kaharere bo yhỹ ahabyi zeka kytsa okzeka Deus harere bo niwatihi batu yhỹ maha. Iharere kino batu ziwabykynaha. Atahi zikpehahik iharere siwabyhybyitsa hi batu ma zikaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","— Amy sa motsasoko wasani my. Aty kaharere bo hyỹ mykara zeka meky watu mozik. Tawahi ispituzo Deus tuk mynapykyryk. Atahi zikpehakata humo tispirikporẽta. Iwatahi tawahi ispitu mynapykyryk. Deus batu tyso ipe. “O ikia batu amysapy. Sinini ykarawy bo tsimy” my. Iwa batu tyso, batu sinini ykarawy bo ba zipeha. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Amy wasani motsasoko. Utakta Deus tse. Abaka sizubarẽtsa simysapybyitsa mykaranaha. Asahi kaharere piwabyziukunaha siakbatsa watsa maha. Abahi kaharere bo hyỹ maha zeka meky watu moziknaha. Kahumo sispitu tahawahi Deus tuk mynapykyryknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Deus zuba mynasihyrizikpo. Kazo kape tynasihyrizikpo iwatahi uta kino niwatihi siakbatsa mynasihyrizikpo. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Utakta kytsa wata Deus zikpehata. Deus humo kytsa pe my: “Ikia Deus okzeka wasani” mykara. Ustsa kytsa pe: “Ikia batu amysapy” mykara. Deus harere humo iwa motsasoko. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Batu paikpa mytsaty tsimykaranaha. Bykyze siakbatsa kaksoho piwabynaha. Kaksoho piwabynahaze tahaytyk ekze myzipunaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Asaktsa wasani ziknakaranaha. Nahyrizikpobanahaze tahawahi Deus tuk mynapykyryknaha. Iwaze asaktsa batu simysapy ziknakaranaha nahyrizikponaha kino niwatihi. Simysapybyitsa ziknakaranaha mybara botu tahasapynaha. Tahawahi sinini mynakaranaha. Deus bara botu zitahasapynaha Deus pokso tahawahi mynapykyryknaha. Batu siaku maha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","— Motsasoko nahaka kaharere bara tu my. Tapara kazo harere piwaby iwaze motsaso. Tapara kazo mykara bykyze atsatu mykara iwa mozihikik. Botu zikpehata kabo nitsasoko anahi motsasoko. Iwatahi kytsa pe my: “Ikiahatsa ahamysapyrẽtsa.” Ustsa kytsa pe: “Ikiahatsa batu ahamysapy” mykara. Iwa motsasoze wasani mykara — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","— Utatu kasoho motsaso zeka batu sapy. Iharere batu wasani tsinakaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Iwa batu tyso. Usta kasoho motsasoko. Kazo kasoho motsasokoze iharere kino tisapyrẽna hỹ iharere humo wasani mykara. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Tubabatu ahatuktsa Suão Batista bo tsipehakanaha. Ata kino kasoho nitsasoko. Hawa ha nitsasoko wasape niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Iwa Suão Batista kasoho ahabo nitsasoko. Utakta pahaoktyhyryk my, iwa Suão Batista kasoho nitsasoko. Iharere batu kasoho tsihikik ahabo zuba kasoho nitsasoko — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","— Rika inapokze amypubyri mozik. Iwaze parakbaha mokozonaha. Haneze miwa bo mokozonaha. Suão Batista rika wata nikara. Deus harere nitsasoko. Iwaze Deus okzeka wasani ahahyrinymyrẽtsa. Anahi Suão harere humo ahahyrinymyrẽtsa. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Hawa ha Suão nitsasoko tisapyrẽna nikara. Hawa ha uta motsasoziuku tisapyrẽna hỹ. Uta Deus zikpehata kytsa wata piwatawyky. Iwahatu kytsa kape maha: “O azo mybo zapeha. Deus zikwy tsipiwatawyky” mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Kazo zikpeha kino kasoho motsasoko. Ikiahatsa iharere batu ahawabyhy. Iwaze ihumo batu ahaspirikpo — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","— Kazo mybarawy ezektsa bo zikpeha. Iharere bo tsikaeni zuba yhỹ tsimykaranaha. Kahumo batu ahaspirikpo tsihik iwatsahi iharere bo tsikaeni zuba yhỹ tsimykaranaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","— Deus harere botu ziwatahanaha anaty hi tsipinymyrykynaha. Ana humo ja Deus tuk mywahi tsinapykyryknaha ba zikaha. Deus kasoho motsasoko. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Tsinahyrizikponahaze Deus tuk ahawahi tsimynapykyryknaha. Kahumo ahaspirikporẽtsa. Iwa Deus papeu humo nitsasoko. Ikiahatsa kino kahumo batu ahaspirikpo iwatsahi tsinahyrizikponahaze Deus tuk ba ahawahi tsipahasapynaha. Ikiahatsa kaharere bo batu yhỹ tsimaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Kytsa kasoho zuba motsasokonaha. Kasoho motsasokonaha zeka. “O atakta tsimysapyrẽta my” maha. Mybarapetu sisopyk. Asahi kahumo tsikaeni zuba siakparawy “O atakta tsimysapyrẽta maha” zeka mybarapetu mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ikiahatsa Deus humo batu ahapokzitsi ana humo hi kahyrinymyrẽta — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","— Uta aparakbahatsa bo kazo harere humo my. Zikpeha iharere bo hyỹ ikykara. Ikiahatsa kahumo batu ahaspirikpo. Usta mozumu zeka ipehabyitatu taharere humo zuba mozumu, ikiahatsa iharere bo yhỹ tsimykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Deusta atababata zuba my. Batu ustaka. Ikiahatsa Deus ahape my: “O ahamysapyrẽtsa tsimaha” anahi batu ahatsihik. Kytsa ahasoho motsasokonahaze “O ahamysapyrẽtsa.” Anahi zuba ahakparawy. Iwatsahi kaharere bo batu yhỹ tsimykaranaha kahumo batu ahaspirikpo — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","— Utakta kazo bo myze ikiahatsa soho batu tyso. “O batu simysapy maha” my. Ikiahatsa Moises nihyrikosokdata harere humo tsimyzurukunaha iwaze “O katsa wasani tsinakaranaha” tsimaha. Batu ba. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moises nihyrikosokdata kasoho ziwatahaka. Iwaha hi ikiahatsa iharere bo hyỹ tsinakaranaha zeka kaharere bo niwatihi hyỹ tsimynakaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Iharere ziwatahaka naha bo yhỹ ahabyi zeka kaharere bo kino niwatihi ba hỹ tsimaha — niy. Iwa Sesus Sudeutsa taparaktsa bo nitsasoko. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Kyze Sesus pihik amakta taba zitsikza. Pihikzotsabyri Karireja inarokota niy. Usa inaro Tiberias niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Kytsa sizubarẽtsa iapik niukurunaha. — O Sesus simyitsapyrẽtsa nisizororowyky. Ata bo hi iktsa tsimaha — nikaranaha. Iwatsahi iapik niukurunaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Iwaze Sesus hara bo nido. Zinymyrykynahatsa tuk nidyhydyhykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Paskoa zumukunahatsa hi Sudeutsa myikaha niy. Paskoa inarokoha myikaha bo pororo ziknakaranaha. Hawa Deus taparaktsa nisitsumuẽhĩkĩ anahumo mytsaty ziknakaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Iwaze Sesus aparakbaha inazuzuknahaze sibo iktsa nikara. Ẽryktsa tu izumukunaha niy. Iwaze Sesus Piripi pe niy: — Haneziky ty sa mydisahawy sizubarẽtsa bo nataskyryk. Haneziky ty sa atsikara nataskyryk — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Sesus ta zuba mytsaty nikara. — Utakta mysidisahawy. Hawa Piripi mytsaty mykara ana humo hi pinymyryky. Tozeka ja kahumo tispirikporẽta nikara iwatahi Piripi pe iky. “Haneziky ty sa mydisahawy nataskyryk” — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Iwaze Piripi Sesus pe niy: — Batu kahyrinymyry. Myokyrysaro byizeka ihuak bara ty ba zioknaha. Pibyituhukutu mytyktseheze tarabaja my zeka batu atsikara ba zioknaha. Tarabajaziu mykara zeka ba zikpyk atsikara tsikaeni zuba aparakbaha bo nyny my — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Iwaze Ãdere zinymyrykyta Simaõ Peduru tsy tihi niy: ");
INSERT INTO rkbNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","— O ta zito jabasta mybo izumu. Atahi mytsyhyry wa zuba atsikara, piknutsa petoktsa zuba aha niy. Myzubarẽtsa mydisahawy panytu — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Sesus ispe niy: — Ikiahatsa kytsa pe tsimaha “Tyk bo dyhy dyhy tahaktsa tsimaha” — niy. Nabo towahaditsa tisapyrẽna. Kytsa sizubarẽtsa tadyhydyhynaha, Sĩko miutsa kytsa nidyhydyhykynaha. Wytykyryk sihyrytsa ahatsa niwatihi nidyhydyhykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Iwaze Sesus atsikara ty okok niyze Deus pe niy: — Ikia humo ka mykurẽtsa — niy. Iwaze atsikara ty zinymyrykynahatsa bo nyny niy. Nyny nikaraze tsizubarẽna niyzikzik. Ibiakyrybarawa niukuru. Kytsa sizubarẽtsa bo nyny nynyzo nikaranaha. Piknutsa kino niwatihi kytsa bo nyny nikaraze sibiakyhybyitsa wa niukurunaha. Nyny nikaraze tsizubarẽtsa niyzikiknaha. Iwaze nyny nynyzo niy kytsa sizubarẽtsa bo niy. Kyze kytsa tihi: — O mysorokrẽtsa tsikahasorokbyrynaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Tahadisahabanahaze Sesus tuk zinymyrykynahatsa pe niy: — Itsatsakyha ty jerehe peryk bo tsipupunahaktsa! Tsipupunaha zeka wasani my — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Iwaze itsatsakyhy ty arehe ty peryk bo zipupukunaha. Dose mytsyhyry tsawa peryktsa mysipyk naha wa Sesus atsikara ziubara piknutsa tsizubarẽtsa nisiubara aha. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Iwaze aparakbaha izikwy bo iktsa niahaze asa zuba nipamykysokonaha: — Aty skaraba Sesus. Atahi kok tubabatu tsisperykynaha. Atahi Deus sohokotsa babata — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Iwatsahi Sesus ziokty tsihikiknaha. Ipe maha: — Ikia mypehatsa tsimozik — maha. Sesus hawa mytsaty nikaranaha tsihyrinymyrẽta. Iwatahi atazuba niparak. Hara bo nido niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kyze zunubaze zinymyrykynahatsa pihikzotsabyri bo nisiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Niahatsahi tsaraha sihezõni taeze kokokorohyk niaha. Kaparanaũ bo pihikzotsabyri ziktsikzakanahaze, miwa buruk tu asa zuba niukurunaha. Sesus batu sibo zuk niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ziturikinahatsa tu atsoko zopoktsa inabybyknaha. Pihik zopoktsa humo atsoko ihiridawy waha. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Turi turi turi nikaranaha. Nokponi turi nikaranaha. Sĩko kirometero ziturikinahaze. Kyze atsoko Sesus bo iktsa niaha. Atahi sibo izumuku. Pihik tsiksukpe buruk inaukuru. Harazuk ahabyita inaukuru. Sibo izumubahanikize sipybyrẽtsa nikaranaha. — Aty skaraba — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Kyze Sesus ispe niy: — Ahapyby byihuktsa — niy. Uta hiba Sesus ispe niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Iwatsahi Sesus pokso batu sipyby. Ipe niaha: — Pany! Tsaraha bokta! — niaha. Atsoko tsaraha amykta taba niukurunaha bybybyu niaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Iwaze kytsa sizubarẽtsa asa kino pihik amykta taba nitarenaha Sesus ziberikinaha. Asa zuba nizapykykynaha Sesus sa hana bo. Jatuka tsaraha estuba zuba hỹ niaha. Zinymyrykynahatsa tsaraha eze kokokorohyk niaha. Asa zuba koikny niukurunaha. Sesus situk batu ityny niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Nipamykysokonahaze ustsa tsarahatsa bybybyu niaha. Tsarahatsa Tiberias iknyktsa. Haneze Sesus kytsa nisidisahawyky naha bazebabatu tsarahatsa bybybyu niaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Iwaze Sesus bo batu zuk ituk zinymyrykynahatsa kino batu niaha tsarahatsa tsihitsa kytsa pe niy: — Sesus sa hana bo zinymyrykynahatsa kino hana bo sa — niy. — Pihikzotsabyri botu zitsikzanaha — niaha. — Yhỹ. Tupakta! Katsa kino siapik tatsikza — niaha. Tsarahatsa eze kokokorohyk niaha. Turi turi turi. Kaparanaũ bo bybybyu niaha. Sesus ziberikinaha iwatsahi pihikzotsabyri zitsikzanaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Myzubaha iziberikinaha. Iwaze zihobyknahaze ipe niaha: — O mypehatsa hawa eze sa tsikzumu. Katsa tsikaberikiknaha hỹ — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","— Hawa motsasoko wasani my — Sesus niy. — Ikiahatsa atsikara tsioknahatsawy tsimozikberikinaha. Ana iwatawy naha humo batu ahahyrinymyry — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","— Ahadisahawy bo zuba mytsaty tsinakaranaha hỹ. Ahasorokrẽtsa tsikaha. Usa mydisahawy humo meky watu tsimoziknaha. Ana ty kino hauk tsimaha zeka Deus tyryktsa tsimoziknaha. Tsimyhyrikosokdanaha zeka Deus myzahahyrizikpowyzo iwaze ituk tsimynapykyryknaha. Ahawahi Deus tuk tsinapykyryknaha. Utakta inasikta ahawata ikyzik Deus hi kazo. Atahi: “Kaharere bo hyỹ tsimykara. Iwatahi tadisahawy kino kytsa bo nyny tsimykara” niy. Ikiahatsa kino niwatihi Deus harere bo hyỹ tahaktsa — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Iwaze Sudeutsa ipe niaha: — Hawa skaraba katsa Deus harere bo hyỹ tsimykaranaha hawa skaraba Deus mozihikik — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","31","Deus hi: — Atahi ahabo ipehata humo tyspirikponahaktsa! — niy. — Utakta Deus zikpehata. Kahumo tsimyspirikponaha zeka Deus harere bo hyỹ tsimaha — Sesus niy. Kytsa Sesus pe niaha: — Taparaktsa myzotsa jerukbara eze atsikara waha ty tahadisahakanaha. Deus harere papeu humo ziwatahaka “Moises bo nipamykysokoze atsikara waha kytsa bo inatsuku. Atsikara waha bijoikpe ikny kytsa nisidisahawykynaha” — iwa Moises Deus zikwy sibo ziwatawyky. — Ikia ja. Azikwy ty sa mybo tsipiwatawy tsimykaranaha. Iwaze zuba ahumo myspirikporẽtsa tsimoziknaha — tsimykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","— Hawa utakta motsaso wasani my. Moises atsikara ty zuba kytsa bo nyny nikara. Ana atsikara morapa hwiwy zubaha niy. Kazo hi atsikara babata kytsa bo nyny mykara. Ana atsikara baba humo kytsa meky watu moziknaha. Deus tyryktsa moziknaha atsikara baba humo — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","— Deus atsikara ty mybo nyny my bijoikpe iknyky. Utakta atsikara waha, uta hi bijoikpe iknykta. Uta kino kytsa kahumo meky watu moziknaha niy. Mynahyrizikponaha kahumo tahawahi Deus tuk mynapykyryknaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Kytsa ipe niaha: — Anaty mybo nyny tykta! Ana hi mydisahawy mozik. Mydisahawy ty mybo nyny tynakara — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Sesus niy: — Uta hiba atsikara baba niy. Deus myzubaha bo nyny mykara. Ikiahatsa kaharere bo hyỹ tsimykaranaha. Kahumo tsimyspirikponaha zeka ahakurẽtsa tsimoziknaha iarapa byitawata tsakurẽta. Ikiahatsa kahumo tsimyspirikponaha zeka aharapabyitsa watsa tsimoziknaha. Ahakurẽtsa tsimykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ikiahatsa kaharere bo batu yhỹ tsimaha. Utakta kazikwy iwatawyky anabo hi tsinynaha. Iwa humo kabo batu yhỹ zikaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Aparakbaha kahumo mysispirikpoko ana hi kazo mozihikik. Iwatsahi kahumo sispirikporẽtsa mykaranaha. Aty skaraba kahumo tispirikporẽta atahi batu tyso “O ikia kahumo batu spirikpo, iwahi ba ziktsaso” — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","— Utakta bijoikpe ikny iknasikze Deus harere bo zuba hyỹ mynakara. Hawa sa mozihikik naha humo batu yhỹ iky iwa humo batu zuk. Atahi zikpeha iwatahi iharere bo zuba hyỹ mykara. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Hawa sa Deus mozihikik. Kytsa asahi kahumo mospirikponaha mysipokzitsiki. Iwatsahi kahumo sispirikporẽtsa ba ziksiere. Mybarawy mopykze kahumo sispirikporẽtsa mynahyrizikponahaze Deus tuk tahawahi mynapykyknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Yhỹ kazo harere bo mykara. Aty skaraba katse harere bo hyỹ mykaranaha asahi ituk tahawahi mynapykyryknaha. Mybarawy mopykze kahumo ituk mynahyrizikponaha. Ana kino Deus harere bo my hỹ — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Kyze Sudeutsa asa zuba isoho zisapybyrikinaha. Nitsasokoze: — Uta hiba atsikara waha, uta hiba bijoikpe iknykta nikara — ana humo hi zisapybyrikinaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","— Iwatsahi nikaranaha hawa skaraba. O atahi sa Sesus zuba. Sose tse sa nikaranaha. Ije niwatihi tsinynaha. Hawaha ta sa “Utakta bijoikpe iknykta” nikara. Atahi mybarapetu nikara — nikaranaha. Iwa asa zuba zisapybyrikinaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Iwaze Sesus ispe niy: — Awatutahaktsa ahamysapybyrihuktsa! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Kazo zikwy humo zuba kytsa kahumo sispirikporẽtsa. Ata kino zikpeha iwaze kytsa kahumo mysispirikpoko. Mybarawy mopykze asahi mynasihyrizikpo iwa Deus tuk tahawahi mynapykyryknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Tubabatu Deus sohokotsa iharere papeu humo ziwatahakanaha: — Aparakbaha Deus mysihyrinymyryky — niy. Iharere hi kasoho my. Kytsa kahumo mospirikponaha zeka ana kino Deus kazo ihyrinymyrywy. Ana humo hi mysihyrinymyryky. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Batu aty tohi Deus ityny my. Uta zuba iny atahi zikpeha. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Motsasoko wasani my. Aty skaraba kahumo tispirikporẽta atahi mynahyrizikpoze Deus tuk tawahi mynapykyryk niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Sesus tihi: — Utakta atsikara baba my. Kahumo kytsa meky watu mozurukunaha. Deus tyryktsa moziknaha. Kahumo simysapyrẽtsa moziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Taparaktsa ahazotsa niakbakanahatsa jeruk bara eze atsikara waha ziokoknaha. Iwatsa tu niakbakanaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Aba atsikara baba soho ahabo motsasoko. Ana ty tsimymydisahanaha zeka ba zikumuzanaha ana hi bijoikpe iknykyry. Deus tuk mywahi tsimynapykyryknaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Utakta hi bijoikpe iknykta my. Mybarawy ezektsa bo iknasik. Myzubaha mekywatsatu ziyziknaha iky. Kytsa kahumo sispirikporẽtsa mohyrikosokdanahaze Deus tuk tahawahi mynapykyryknaha. Atsikara ty sibo nyny my ana hi katsani. Katsani ty mybarawy ezektsa bo nyny my. Iwatsahi mynahyrizikponaha asahi Deus tuk tahawahi mynapykyryknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Iwaze Sudeutsa asa zuba nipamykysokonaha. — Hawa skaraba Sesus tatsani ty mybo nyny my. Hawa skaraba inury taboro — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Sesus ispe niy: — Hawa motsasoko wasani mykara. Utakta Deus zikpehata ahawata ikyzik. Ikiahatsa katsani ty hauk ahabyizeka batu Deus tyryktsa zikyziknaha. Batu meky watu zikyziknaha. Ikiahatsa kaspu ty tsõ ahahabyizeka batu Deus tyryktsa zikyziknaha. Batu meky watu zikyziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Aty katsani pihauk zeka Deus tyryk mozik. Mekywatu mozuruku. Aty kaspu piku zeka Deus tyryk mozik. Mekywatu mozuruku. Tsimysapyrẽta mozik. Mybarawy mopykze mynahyrizikpo. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Iwatahi katsani mydisahawy baba my. Kaspu mypowy baba my. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Aty katsani ty tadisaha zeka atahi katuk mynapykyryk. Aty kaspu piku zeka atahi katuk mynapykyryk. Kahyrikoso zikwy situk mozuruku. Uta kino situk niwatihi mozuruku — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","— Kazo humo myspitu tsinakaranaha. Uta zikpehata kazo humo kaspitu. Kazo mozikyrizikpozo my. Atsatu kytsa asahi katsani ty tahadisahakanahaze nasihyrizikpo — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","— Utahi atsikara baba bijoikpe iknykta inasik niy. Tubabatu taparaktsa niakbakanahatsa atsikara waha ty ziknatahadisahakanaha. Atsikara waha bijoikpe ikny inatsukunaha. Aparakbaha atsikara tisapyrẽna ty tahadisahakanaha asahi niakbabaiknaha. Utakta atsikara wata. Uta bijoikpe iknykta iknasik. Kytsa katsani ty tahadisahakanaha zeka Deus tuk tahawahi mynapykyryknaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Iwa Sesus Sudeutsa zinymyrykynahatsa wahoro eze nisihyrinymyryky. Kaparanaũ eze nikara. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Kyze kytsa Sesus tuktsa iharere ziwabykynahaze betsakze nikaranaha. Asa tihi: — O iharere batu mykparawy. Iharere tsihokdaharẽna hỹ. Batu aty tohi yhỹ my — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Upyk harere ahabyitsa tu iwatatu Sesus tsihyrinymyrẽta nikara. Imyspirikpowy soho humo taokanikinaha. Iwaze ispe niy: — Kaharere tsihokdaharẽna niy. Kaharere batu ahakparawy iwatsahi kaharere bo batu ma zikaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","— Utakta iknasikta ahawata ikyzik. Kahumo batu ahaspirikpo iwatahi kaharere tsihokdarẽna. Utakta bijoikpe bo kazo bo piksizoze anabo hi iktsa tsimaha ja kaharere bo yhỹ tsimaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Deus hyrikoso humo aparakbaha meky watu moziknaha. Aparakbaha ihumo Deus tuk siwahi mynapykyryknaha. Kytsa zuba zeka batu Deus tuk mynapykyknaha. Batu zikaha. Iwa zeka kaharere bo hyỹ tsimaha zeka Deus hyrikoso ahatuk my. Iwaze ikiahatsa Deus tuk ahawahi tsimynapykyknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Wastuhu kaharere bo ba hỹ zikaha ana humo hi kahyrinymyrẽta — niy. Iharere iakparawy byitsa soho humo botu zinymyry. Estuba sisukyrytsitsa bo zioktyhyrykta humo kino tsihyrinymyrẽta. Zinymyrykynahatsa nisinaropykykze tsihyrinymyrẽta. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Iwatahi ahape iky. — Tapara kazo yhỹ my iwaze kytsa kahumo sispirikporẽtsa. Asa zuba kazo harere bo hyỹ mahaze asahi kahumo sispirikporẽtsa moziknaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Iwa Sesus tuktsa sizubarẽtsa iharere bo batu yhỹ niaha. Batu iapik pãozo. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Kyze Sesus tuk zinymyrykynahatsa dose tsa pe niy: — Ikiahatsa ja. Ikiahatsa kino sa tsipikarikiknaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Iwaze Simaõ Peduru ipe niy: — Mypehatsa aty hapik sa tsimaha. Ikia humo mekywa tu tsimoziknaha. Hawa tsimyhyrikosokdanahaze Deus tuk mywahi tsimynapykyknaha anahi ikia zuba tsikmyhyrinymyryky. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Iwatsahi aharere humo myspirikporẽtsa. Ikia zuba Deus zahapehata tsimaha. Tsamysapyrẽta — niy. Iwa Simaõ Peduru niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Iwaze Sesus ispe niy: — Utakta dose mytsyhyrytsa hawa zinymyrykynahatsa iksiwatawyhik. Estuba ahatukta Satanas mozik — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Sesus Sudas soho nitsasoko. Sudas Simaõ Iskariotses tse niy. Atahi Sesus sukyrytsitsa bo pioktyhyryk niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Kyze Sesus Karireja bo niukuru. Sudeja bo ka batu pão. Sudeutsa taparaktsa zibeze tsihikiknaha. Iwatahi Sudeja bo batu pão. Karireja eze zuba niapykyryk. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Tapara Sudeutsa myikaha bo pororo ziknakaranaha. Taparaktsa jerukbara eze tahaparik zizikinaha naha bo hi mytsaty ziknakaranaha. Iwaze amyikaha bytykara isiparik bo niapykyryknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Iwaze Sesus tukytsa ipe niaha: — Sudeja bo ikiakta tsiksikta. Anabo tsimyzeka hawa tsimykara atuktsa iktsa maha. Azikwy bo iktsa maha. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Tsipany tsihikik zeka ba okpitsĩkĩ ziky. Atahi izikwy ty sizubarẽtsa bo mysiwatawyky. Iwatahi Sudeja boktsa — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Itukytsa kino ihumo sispirikpobyitsa nikaranaha iwa ipe nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Sesus ispe niy: — Uta aba amyikaha bo ba zikumu. Ikiahatsaktsa myikaha bo zeka wasani my tsimykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Aparakbaha asahi Deus harere bo batu yhỹ zikaha kahumo tahakyrikinaha. Ikiahatsa humo ka batu siakyri. Uta kahumo zuba sakyrirẽtsa nikaranaha. Utakta ispe my: “Ikiahatsa ahamysapybyitsa tsikykaranaha” my iwatsahi kaharere humo tahakyrikinaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ikiahatsaktsa simyikaha boktsa! Utakta ba zikparak. Abaka ba zikumu. Bykyze zuba my — niy. Iwa Sesus tatukytsa pe niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Iwaze itukytsa simyikaha bo niukurunaha. Sesus Karireja eze nitare. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Kyze Sesus niwatihi simyikaha bo niy. Kytsa bo batu tyso. Ity sohabyita tu simyikaha bo niukuru. Kytsa batu sihyrinymyry. Sipapatu niparak. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","13","Sudeutsa taparaktsa simyikaha bo niukurunaha. Asahi myikaha eze Sesus ziberikinaha. Asahi: — Sesus sa hana bo — nikaranaha. Aparakbaha isoho nitsasokonahaze Sudeutsa taparaktsa batu siwaby tsihik. Iwatsahi akbyibatu zuba nipamykysokonaha. Asaktsa: — O tahi tsimysapyrẽta — nikaranaha. Ustsa kytsa: — O batu. Batu imysapy. Atahi kytsa bo nisispihikbataka — mybarapetu nikaranaha. Iwa Sesus soho nitsasokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Iwaze Sesus zumu. Deus wahoro zubata bo nitsuk. Anaeze iziakbata kytsa nisihyrinymyryky. Simyikaha asiba nepykze nisihyrinymyryky. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Taparaktsa Sudeutsa iharere batu siakparawy. Asa kino: — Hawa hãta skaraba Deus papeu humo zinymyryba. Nimyhyrinymyrykynahatsitsa batu tyhyrinymyry iwatatu tsihyrinymyrẽta. Batu wasani my — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Iwaze Sesus ispe niy: — Amy ty pahahyrinymyryky kaharere bara zikpehata harere zuba pinymyryky. Iharere zuba sizubarẽtsa mysihyrinymyryky — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ikiahatsa hi: — O amy ty nisihyrinymyryky iharere zuba ja — tsimykaranaha. Utakta ahape my: — Aty sa Deus harere piwaby tsihikik anahi kaharere baba hi pihyrinymyryky. Atahi kaharere Deus kabo zinyny niy ana humo hi tsihyrinymyrẽta. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Wastuhu kytsa tahaharere ty zuba nisihyrinymyrykynaha. Ustsa kytsa batu. Deus harere humo zuba nisihyrinymyrykynaha. Asahi tahaharere ty zuba nisihyrinymyrykynaha. — Ziwabynahatsa sisoho: — O siharere wasani my, myhyrizikwanitsa moziknaha — nikaranaha. Iwa kytsa sisoho motsasokonahaze anahi mozihikiknaha. Kytsa Deus harere ty zuba nisihyrinymyrykynaha. Aparakbaha hi: — O Deus harere tisapyrẽna — nikaranaha. Ana soho humo hi sakurẽtsa nikaranaha. Anahi Deus harere soho piwaby tsihikiknaha. Asa zuba wasani mykaranaha. Batu mybarapetu mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","— Tubabatu Moises nihyrikosokdata ahadiritsa bo Deus harere ty nisihyrinymyryky. Batu aty tohi iharere bo hyỹ ziknakara. Amy humo sa ikiahatsa tsipikbeze tsihikiknaha — niy. Aparakbaha Deus wahoro zubata eze tu Sesus harere ziwabykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","— O ikia paikpa mytsaty tsimykara. Hyrikoso isapybara atuk my. Aty sa pabezetsihikik — nikaranaha. Iwa kytsa sisukmotsa nikaranaha. Serusarẽhe ezektsa sihyrinymyrẽtsa. Sudeutsa taparaktsa Sesus pibeze tsihikiknaha anahi sihyrinymyrẽtsa. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","— Sudeutsa byrywy eze kazikwy ty pahawatawyky. Kazikwy humo nipybybaiknaha. Kazikwy bo iktsa tsimykaranahaze, “O batu amysapy my. Atahi byrywy eze tarabaja niy” tsimykaranaha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Tubabatu Moises Deus harere ziwatahaka — Ahahyrytsa makuskyrytsa tysipiakzyzyknaha. Siwatahawy mozik atahi Deus tyryk niyzik ziwatawy. Ikiahatsa ahabykyhytsa tabyrywy eze tsinasipiakzyzykyknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Tabyrywy ahaskyrywytsa tysipiakzyzykyknaha Moises harere humo. Iharere bo yhỹ tsimyzihikiknaha iwatsahi tysipiakzyzykyknaha. Uta maku izororo baba mybyrywy eze ana humo hi ja tsikahakyrikinaha. Amo humo ja tahakyrikinaha — niy. — O atahi mybyrywy eze tarabaja my. Maku zizororowyze tarabaja nikara. Batu amysapy tsimy — tsikykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Sizubarẽtsa tsimytsasokonaha: — Atahi batu wasani my mybarapetu tsimykaranaha niy. Hawa tohi mykara batu tyso “O atahi batu imysapy my”. Awatutaha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Serusarẽhe eze wastuhu kytsa nipamykysokonaha: — Atahi sa pibeze tsihikiknaha — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","— Atahi kytsa okze motsasoko. Batu aty tohi ity sohometu. Tozeka ja taparaktsa Sesus humo sispirikporẽtsa. Tozeka ja Sesus Deus zipehata ana humo hi yhỹ mykaranaha — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Iwa wastuhu Serusarẽhe ezektsa nikaranaha. — Deus zipehata mozumuze batu aty tohi hana iknykta ja zikaha. Katsa zuba ihumo myhyrinymyrẽtsa iwatahi batu Deus zipehata my — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Iwaze Sesus sizubarẽtsa Deus wahoro zubata isturupeze nisihyrinymyryky. Opykani haty nisihyrinymyryky: — Ikiahatsa batu ahanyhỹ. Ikiahatsa hana ikny ta ja izumu ba tsimykaranaha. Deus kazo zikpehatawy ikzumu hỹ. Ba ahabyizeka ba zik zumu. Atahi wasani mykara. Ikiahatsa batu ahahyrinyhy. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Uta zuba iny. Ibaze iknapykyry tatu my. Atahi mybarawy bo zikpehatawy — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Iwaze kytsa nizokbatsi tsihikiknaha. Sisukyrytsitsa bo itsipa humo tsioktyhyknaha nikaranaha, batu nabaze ity paik ahabyitsa. Deus — Batu yhỹ. Katse Sesus ba zioktynaha — niy. Iwatsahi itsipa humo batu ity oktyhyryk. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Kytsa sizubarẽtsa ziwabynahaze iharere bo yhỹ nikaranaha ihumo sispirikporẽtsa. Ziwabynahatsa hi: — Deus zipehata zikwy tsipinynaha. Iwatsahi Deus zipehata my mytsaty tsimykaranaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Iwaze Pariseutsa parakbaha Sesus nizikerykynaha. Kytsa sizubarẽtsa Sesus soho nitsasokonahaze iwatsahi zioktyhyryk tsihikiknaha. Pariseutsa parakbaha, Deus wahoro zubata eze ziknapamykysokonahatsa taparaktsa iwatsa asahi Deus wahoro perytsitsa nisipehakanaha. Sesus itsipa humo tyzioktyhyknaha nisipehakanaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Iwaze Sesus niy myzubaha bo: — Utakta ahabaze jokbohatu mopykyrykspyk. Aiba zuba kapehatsa bo piksizo. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Iwaze tsipikberinaha ba zik zikahanaha. Kazo bo piksizoze ba kapiktu zikaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Sudeutsa asa zuba nipamykysokonaha: — Hana bo skaraba mykara katsa ba zik zikahanaha. Tozeka ja ustsa kytsa bo my. Bipyritsa bo ja mykara. Sudeutsa nanabyitaba mynapykyryk Kerekatsitsa baze mynapykyryk. Tozeka ja Kereka ezektsa mysihyrinymyryky — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Tapara mype niy: — Tsipikberikinaha bazik zikaha naha. Piksizoze ba kapiktu zikaha niy. Iharere myhumo tsihokdaharẽna — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Kyze Sesus sizubarẽtsa bo nipamykysokozo. Opykani haty nipamykysoko. Simyikaha nepyksohokoze nisihyrinymyrykyzo. Nawa zuruze ispe niy: — Aty tsiarapukrẽta zeka pihik piku. Aty meky watu mozik tsihikik zeka kabo tyzumukta. Iwaze tsipikuze hi kahumo tispirikporẽta tsimysapyrẽta mozik — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","— Pihik waha ituk mynapykyryk. Pupuputsa wa mykara. Asahi kaharere bo hyỹ mykaranaha kahumo sispirikporẽtsa. Hawa kytsa pihik pikuikiknaha utakta situk mynapykyryk. Iwatsahi mekywa tu moziknaha. Simysapyrẽtsa. Iwa Deus harere papeu humo botu iwatahaha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Sesus iwaze nitsasoko Deus hyrikoso soho ziwatawyky. Deus hyrikoso Sesus tuktsa tuk mynapykyryk. Deus sibo myzipeha tsihikik. Tapara Deus hyrikoso myzipeha iwaze Sesus tuktsa isoho motsasoko. Mybarawy bo mynasik. Tapara Sesus Deus bo piksizoze iwaze hi Deus hyrikoso mybarawy bo atsoko mynasik. Tapara Sesus Deus bozo my. Bykyze Deus hyrikoso mybarawy bo myzipeha niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Kytsa sizubarẽtsa asa zuba Sesus soho humo nipamykysokonaha. Mektsatu nitsasokonaha. Wastuhu kytsa nikaranaha: — Atakta Deus sohokotsa babata, atahi taperyky hỹ — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ustsa nikaranaha: — Atakta Deus zipehata Kiristu my — nikaranaha. Ustsa: — O batu, Deus zipehata Karireja ezekta ja nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Deus harere papeu humo Sesus soho botu iwatahaha nikaranaha. Ziwatahaka: “Deus zipehata Dawi tsekoka my Berẽhe eze mopuruk. Sudeja eze my.” Iwa Deus harere niy — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Iwaze kytsa isoho humo niharapepehakanaha. Mekywatu siharere nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Iwaze Deus wahoro perytsitsa Sesus ziokty tsihikiknaha. Asahi batu itsipa humo ity okty. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Kyze Deus wahoro perytsitsa. Pariseutsa bo ziksizonaha. Zumukunahaze nisipehakanahatsitsa ispe niaha: — Amo sa Sesus ty batu tyoktyhyryk — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Deus wahoro perytsitsa hi: — O batu aty tohi iharere wata my. Iharere tisapyrẽna hỹ. Iwatsahi itsipa humo batu tyoktyhyryk — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Pariseutsa tihi: — Ikiahatsa kino niwatihi. Iharere humo ja zahaspirikpoko — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Sadusitsa aparakbaha taparaktsa ihumo batu sispirikpo. Batu estuba zikino ihumo batu ispirikpo. Pariseutsa niwatihi ihumo batu sispirikpo. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Kytsa sizubarẽtsa Moises harere humo batu sihyrinymyry. Asa zuba ihumo sispirikporẽtsa. Deus ispe niy: — Ikiahatsa batu ahamysapy tsimaha. Sinini ykarawy bo pahapeha my — Pariseutsa niaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Maku Nikodemus ituktsa niapykyryk. Tapara atahi unata Sesus bo nikozore. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Atahi tatuktsa pe niy: — Katsaktsa Sesus harere batu mywabyhy. Iharere ty waby ahahabyizeka ba ibete hỹ zikaha. Batu ziktsasonaha: “Atakta batu imysapy my. Iwatahi sinini ykarawy bo Deus pipeha” niy. Iwa tubabatu nihyrikosokdata Moises mydiritsa nisihyrinymyry — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","53","— O ikia niwatihi hazi nikaranaha. Ikia kino ja Karireja ezekta nikaranaha. Iwa tsimytsasokoze Deus papeu humo ihyrinymyrybyita wata — nikaranaha. Taparaktsa hi: — Deus sohokotsa batu Karireja ikny ta my. Deus papeu humo tsinyziukukta tsimy. Iwatahi atakta Sesus batu Deus sohokotsa my — nikaranaha. Kyze tahawahoro bo ziksibanaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Sesus Oriwerejatsa hara bo niukuru. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Miwa botu Deus wahoro zubata bozo niy. Kytsa sizubarẽtsa Deus wahoro bo niaha. Sesus ziwabykynaha iwatsahi izumukunaha. Kytsa sizubarẽtsa izumunahaze isitazahaeze nidyhyky. Iwaze nisihyrinymyryky. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Iwaze Deus harere watahatsitsa Pariseutsa niwatihi iwatsa Sesus bo zumunaha. Wytyk ibo zioktyhyryknaha. Atatsa ipyitsakatatsa tu sizubarẽtsa ziknasihewabykyryk. Pariseutsa nizokparakanahaze sibo iktsa niaha. Iwatsahi wytyk zioktyhyryknaha. Kytsa sizubarẽtsa tazahaeze atatsa Sesus bo zioktyhyryknaha. Niritohoko. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Iwaze Sesus pe niaha: — O myhyrinymyrykytsa atatsa wytyk usta ibarikta byita tu zipyrirykyknahaze sibo iktsa tsikaha. Iwatsahi atatsa abo tsikzioktyhyryknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Tubabatu nihyrikosokdata Moises myzotsa bo nitsasoko. Papeu humo ziwatahaka. “Wytyk usta maku zikzipyrirykyk zeka atatsa ty ka bohitaha. Haraharetsa ty tsibezenaha” iwa Moises botu myzotsa nisihyrinymyry. Ikia ja, Hawa sa tsimy — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ana hi nitsasokonahaze — Tahaharere tsyhyryzehe nikaranaha iwatsahi nizapykykynaha — mytsaty ahabyitsa nikaranaha. Asa zuba nipamykysokonaha: — O iharere meky watu my. Amy ty Moises botu ziwatahaka batu yhỹ my iwaze batu imysapy my — iwa mytsaty nikaranaha. Iwaze Sesus okmymy hãtatu wytyk bo tatsyhyry tyty tapauk baze ziwatahaka. Atatsa bo ka batu iktsa niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Hawa sa tsimy ipe nikaranaha. Kyze niziktsutsuhuku tatu kyik niy sibo iktsa niy. Ispe niy: — Ikiahatsa baze aty imysapyrẽta zeka atahi harahare tapara mopapyk — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Iwaze wytyk bo okmymyzo niy tatsyhyry ty ziwatahakazo. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Kytsa Sesus harere ziwabynahaze sisikpybyrẽtsa nikaranaha. Iwatahi taparakta maku puke niy. Iwaze estuba estuba zuba zipokonaha. Ziharawyta iypykbyita puke niy. Sizubarẽtsa puke puke niaha. Iharere humo sisikpybyrẽtsa iwatsahi zipobaiknaha. Atatsa zuba Sesus tuk nitare, niriktohoko. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Sesus kyikzo atatsa bo iktsaziu niy. Ipe niy: — O wytyk kytsa sa hana bo. Asahi ape “Ikia batu amysapy” nikaranaha. Asahi haraharetsa ty zabezekyzykynaha. Kytsa sa hana bo — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","— O mypehatsa zipobaiknaha. Aba batu aty tohi kabo “Ikia batu amysapy” mykaranaha — niy. Sesus ipe niy: — Uta kino niwatihi. Abo batu tyso “Ikia batu amysapy my” iwa abo batu tyso. Tsiksiktsa abaka awatu tynakara! — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Kyze Sesus kytsa sizubarẽtsa, Deus wahoro zubata eze nisihyrinymyrykyzo. Ispe niy: — Deus harere ty pahahyrinymyryky Deus harere bo hyỹ tsimykaranaha zeka wasani tsimoziknaha. Asahi kahumo mospirikponaha zeka imysapybara pimoewynaha Deus mysiokzo. Asa kino kahumo tisapyrẽna mynakaranaha, meky watu moziknaha hỹ — nikara. Iwahatyhi ispe niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Kyze Pariseutsa tihi: — O ikia asoho zuba tsimytsasoko. Asoho tsimytsasoko zeka batu amysapy tsipimyiki — mybarapetu nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Sesus ispe niy: — Utakta wasani mykara. Kasoho motsasoko zeka wasani my. Ikiahatsa hana ikny tsikzumunaha humo batu ahahyrinymyry. Hana bo tsimykurunaha humo batu ahahyrinymyry. Utakta kahyrinymyrẽta. Hana ikny ikzumuku naha humo kahyrinymyrẽta. Hana bo moparak naha humo kahyrinymyrẽta. Iwatahi wasani mykara — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","— Kytsa harere ty tsiwabyziu zeka ikiahatsa tihi: “O tahi batu wasani” tsimykaranaha. Iharere tsihokdaharẽna humo iwa tsimykaranaha. Utakta batu ka moso. Iwata humo hi batu tyso kytsa harere zuba. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Motsaso zeka ikahatsa batu ahamysapy kaharere ahasoho ty wasani mykara. Atakta zikpeha atahi astsatu motsasoko. Uta zuba byita tu mykara. Kazo zikpeha katsaktsa harapetok tsimykaranaha ");
INSERT INTO rkbNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Moises taparaka ziwatahakaze. Kytsa petoktsa atsatu motsasonahaze siharere piwabynahatsa siharere soho: “O wasani mykaranaha” maha. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Uta hi kasoho motsasoko. Kazo kino niwatihi. Atahi zikpeha kasoho motsasoko. Kasoho tsimytsasokonaha. Iwa atsatu petoktsa kasoho motsasokonaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Kyze ipe niaha: — Haneze skaraba azo — niaha. — Uta batu ahanyhy tsimykaranaha. Kazo kino niwatihi batu ahanyhỹ. Tsipiknynaha zeka kazo kino niwatihi tsipinynaha. Iwaze katsa tsimymynynaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Anaharere humo kytsa sizubarẽtsa bo nitsasoko. Sesus Deus wahoro zubata eze kytsa sizubarẽtsa okyrysaro suk baze nisihyrinymyryky. Sisukyrytsitsa itsipa humo batu ity oktyhyryk. Deus sibo batu yhỹ niy iwatsahi Sesus tsipa humo batu ity oktyhyryk. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Sesus ispe niyzo: — Uta piksi. Ikiahatsa tsipikberinaha zeka ba zikzikahanaha. Uta pahatsumuẽhĩ tsihikik. Ba zikzikahanaha. Tsimyhyrikosokdanahaze Deus ahasapybyitsa tsimykaranaha ba ziksiokzohik. Ikiahatsa ba kapik pão tsimaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Sudeutsa asa zuba nipamykysokonaha: — Ata mybo nitsasoko “hana bo sa piksi batu iapik pão zikaha” nikara. Tozeka ja atatu tabeze. Tabeze zeka katsa batu iapik pão zikaha — nikaranaha. Iwa asazubatsa tu nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Sesus nikarazo: — Ikiahatsaktsa mybarawy ezektsa. Utakta Deus iknykta ikzumu. Hawa kytsa mytsaty mykaranaha ikiahatsa niwatihi atsatu mytsaty tsimykaranaha. Utakta batu. Kazo mytsaty mykara naha ty zuba mytsaty mykara kazo wata my. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Botu ahabo iktsasoko. Tsimyhyrikosokdanahaze Deus ahamysapybyi ty tsikykaranaha ba zahaokzo. Kahumo ahaspirikpo ahabyizeka tsimyhyrikosokdanaha katuk batu tsimynapykyryknaha. Utakta Deus zikpehata. Kawahi mynapykyryk. Kaharere bo yhỹ ahabyi zeka iwaze tsimyhyrikosokdanahaze ahamysapybyi ty tsikykaranaha ba zahaokzohik — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","— Aty skaraba ikia — niaha. — Uta botu ahabo iktsaso — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","— Ahabo puẽtsik motsaso tsihikik. “Ahaharere hi batu wasani tsimaha” anahi motsaso tsihikik. Atahi zikpeha iharere zuba motsasoko. Iharere wasani my. Batu mybarapetu ziky. Anaty hi zikyrinymyryky atsatu kytsa sizubarẽtsa bo motsaso — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Nitsasokoze zikpehata tazo soho nitsasoko. Sudeutsa ana humo hi batu siwabyziuhu. Iharere sihumo tsihokdaharẽna my. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Utakta kytsa wata Deus zikpehatawy. — Iharapatawyhyta humo tsibezenahaktsa! — tsimykaranaha. Iwa tsipikbezenaha. Bykyze tsipikbezenahaze ikiahatsa tihi: — O ataktsa wasape mykara tawahi mynapykyryk tsimykaranaha. O atakta Deus zipehata tsimykaranaha. Atahi tazo harere zuba aparakbaha nisihyrinymyryky — tsimykaranaha. — Hawa tazo nitsasoko yhỹ niy. Taharere ty ka batu tyso. Tazo harere zuba nitsasoko anahi nisihyrinymyryky — tsimykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Tahi zikpeha katuk mynapykyk. Iharere bo hyỹ kasopyk — atahi kapokzitsikitsa. Ba zikare — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Iwatsahi kytsa sizubarẽtsa iharere bo hyỹ nikaranaha ihumo sispirikporẽtsa nikaranaha. Asahi ziwabykynahatsa ihumo sispirikporẽtsa nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Iwaze Sesus Sudeutsa pe niyzo ihumo sispirikporẽtsa asa bo hi nitsasoko ispe niy: — Kaharere bo hyỹ tsimykaranaha zeka katyryktsa tsimoziknaha. Katuk zinymyrykynahatsa babatsa tsimoziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Amy ty wasani tsipinymyrykynaha, iwatsahi meky watu tsimoziknaha. Taparaka ahapokzitsiukbyitsa tu ahamysapybyitu tsikykaranaha. Abaka mahani ahapehatsa myzahapokzitsiki iwatsahi ahapunihikrẽtsa tsimoziknaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","— O batu aty tohi mypehatsa humo mymypokzitsiubyitsa. Katsaktsa nihyrikosokdata Abarão tsekokatsa tsimaha. Amy humo sa mybo tsimy. “Kytsa mypehatsa humo mymypokzitsiubyitsa” tsimykara. Batu — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Sesus ispe: — Kaharere wasani my. Wabyziutaha! Hawa batu mysapy tsimykaranaha. Ahasopyksapybyitsa tsimykaranaha zeka iwatsahi ahapokzitsiukbyitsa tsikyziknaha. Ahapehatsa Satanas mozik. Iharere bo ma tsikykaranaha iwatsahi ahasopyksapybyitsa tsimykaranaha. Ba hawa tohi zikaha. Iwatsahi ahahumo ahapokzi byitsa niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mypehatsa kytsa nasipokzitsizo. Asahi sipokzitsiuk byitsa itukytsa nymyhyrybyita mykaranaha. Bipyritsa zuba. Tatse batu, atahi mymypokzitsiki. Mypehatsa tse humo mymypokzitsiki. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Utakta Deus tse my. Iwatahi kahumo tsimyspirikpokonahaze Deus tyryktsa tsimoziknaha. Iharere bo zuba hyỹ tsimykaranaha. Tapara Satanas ahapehatsa tserikiknaha, iharere bo ka batu yhỹ tsimaha iwatsahi ahasopyksapybyity tsikykaranaha tsimoewynaha — tsimykaranaha. — Uta ahapehatsa mozik kahumo ahapunihikrẽtsa tsimoziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ikiahatsa nihyrikosokdata Abarão tsekokatsa tsimaha ana humo hi kahyrinymyrẽta. Kaharere bo batu yhỹ tsimykaranaha. Amo sa tsikbeze tsihikiknaha. Iwatsa tu Abarão tsekokatsa tu tsikbeze tsihikiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Kazo zikwatawyky atsatu motsasoko. Ikiahatsaktsa Satanas tyryktsa tsikyziknaha. Atahi ahazo my. Hawa mykara atsatu tsimykaranaha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","40","Kytsa tihi: — O batu, katsaktsa Abarão tsekokatsa. Nihyrikosokdata Abarão mydiri mysopyk — niaha. Sesus ispe niyzo: — Deus harere kabo nitsasoko. Iharere humo zuba zahahyrinymyryky. Ikiahatsa tsikbezekyzykynaha kaharere humo batu ahakparawy niy. Deus harere baba batu ahakparawy. Nihyrikosokdata Abarão Deus harere bo hyỹ ziknakara. Ikiahatsa Abarão tsekokatsa tsimaha zeka iwata Deus harere bo hyỹ tsimaha. Ikiahatsa Satanas wata tsikyziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Hawa nikara atsatu tsimykaranaha — niy. — O katsa batu Satanas watsa tsimaha Deus zuba myzo. Iharere bo zuba hyỹ tsimykaranaha — mybarapetu niaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Sesus: — Deus zikpeha. Uta mybarawy bo iknasik — niy. Deus ahazo my zeka ikiahatsa tihi: — O zipehata tsimysapyrẽta tsimykaranaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","— Kaharere bo batu yhỹ tsimykaranaha. Kaharere bo batu ma zikaha. Iwatsahi batu wabyziu zikaha aha humo kaharere tsihokdaharẽna my niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ikiahatsaktsa Satanas hyrytsa tsikyziknaha. Hawa mykara ikahatsa kino niwatihi tsimykaranaha. Tahi imysapybyita mynakara. Ikiahatsa ahasopyksapybyitsa tsinakaranaha. Hawa mykara yhỹ ahasopyk. Ataharere humo hi kytsa naharapebakanaha. Deus bijoikpe mybarawy nizuknize ata harere humo hi nahapebakanaha. Aba kino niwatihi kytsa nasiakzokotu. Deus harere babata bo batu yhỹ mykara. Batu wasani ziky tsimyspihikbatarẽta. Pispihikbatakaze hawa mozihikik atsatu mykara. Kytsa mymyspihikbatakanahaze ihyrytsa moziknaha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","— Uta wasani motsasoko. Iwatsahi ikiahatsa kahumo batu ahaspirikpo — nikara. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ba amy tohi ziksonaha: — O ikia tsimymysapybyriki — my. — Kaharere wasani ziky iwatsa tu kaharere bo batu yhỹ zikaha tsimykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Deus tyryktsa iharere bo hyỹ mykaranaha. Ikiahatsaktsa Deus tuktsabyitsa tsimaha. Iwatsahi Deus harere bo batu yhỹ tsimynakaranaha — nikara. Iwa Sesus taparaktsa bo nitsasoko. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Sudeutsa Sesus pe niaha: — O ikia hyrikoso sapybara humo tsimytsasoko. Batu amysapy tsimy. Paikpa mytsaty tsimykara. Samarija ezektsa wata batu amysapy tsimy — mybarapetu nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Sesus tihi: — Aharere batu wasani my. Hyrikoso sapybara humo batu tyso. “Kazo zuba wasani mykara”. Ikiahatsa tsiziksohometukunaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Batu katyso “Utakta wasani my.” Deus zuba moziksapywyky “Atakta wasani” mykara. Kytsa kasoho humo piksohometukunahaze Deus tihi: “O ahaharere batu ahamysapy tsimykaranaha” — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","— O kaharere tsiwabytoktonahaktsa. Aty kaharere bo hyỹ mykara zeka atakta kazo tuk tawahi mynapykyryk — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Iwatsahi Sudeutsa ipe niaha: — Abaka tanymyryky hỹ. Ikiahi hyrikoso sapybara humo tsimypamykysoko. Tubabatu taparakta Abarão nihyrikosokda. Deus sohokotsa kino niwatihi nihyrikosokdanaha. Niakbabanaha. Ikia hi motsasoko “Aty kaharere bo hyỹ mykara Deus tuk tawahi mynapykyryk. Siakbatsa ba zikakpykyknaha kaharere humo hyỹ my” tsimy — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","— Tubabatu Abarão mydiri nihyrikosokda. Abarão atatuze nitsasokoze kytsa iharere ziwabyziukunaha. Tubabatu siakbatsa Deus sohokotsitsa nihyrikosokdanaha. Asahi nitsasokonahaze kytsa siharere ziwabyziukunaha. Ikia ja. Tozeka ja tsimytsasokoze kytsa aharere piwabyziukunaha. Aty skaraba tsimy — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Sesus ispe niy: — Utakta kasoho tu motsasoikik zeka “O uta zuba wasani hi mykara” Anahi mykara zeka batu aty tohi kaharere piwabytoktokoro. Kazo kasoho humo moziksapywyky. “O wasani hỹ mykara” — my. Ikiahatsa kazo soho tsimykaranaha zeka — O atakta mypehatsa my tsimykaranaha. Iwa kazo soho tsimykaranaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","— Ikiahatsa hi batu Deus ahanyhy tsimykaranaha. Utazuba iny. Motsasoko zeka “batu kanyhy my” mybarapetu mykara. Ikiahatsa watsa mozik. Utakta iny. Iharere bo hyỹ mykara hỹ — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","— Ahadiri Abarão kasoho humo tsihyrinymyrẽta. Mybarawy bo mynasik ana humo hi tsihyrinymyrẽta ziknakara. Iwatahi kahumo tsakurẽta — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","— O ikiakta batu atsaikba. Sĩkuẽta anos ahabyitatu. Iwatahi ikiakta Abarão batu anyhy. Tubabatu nira iwatahi batu anyhy. Tsimymyspihikbataka — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Sesus ispe my: — Kaharere tsiwabytoktonahaktsa. Taparakta Abarão purukbyitu utakta nawa tatu — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Iwaze kytsa haraharetsa ty nasibyknaha. Iwaze zibeze tsihikiknaha. Sesus sipokso taokpitsĩ. Kytsa sizubarẽtsa papatu izoihik. Batu ity nyzo. Iwaze Deus wahoro zubata isturupeze inawakik. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Maku ihyrizikubyrita zizororowy. Kyze Sesus niukuruze zinymyrykynahatsa tuk maku ihyrizikubyrita bo iktsa niy. Atahi koikny bakta tu ihyrizikubyrita nipuruk. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Zinymyrykynahatsa tihi: — O mypehakatsa amo sa maku ihyrizikubyrita nipuruk niaha. Tozeka ja imysapybara humo nihyrizikubyri. Tozeka ja izotsa simysopyksapybyitsa nikaranaha ana humo hi ja nihyrizikubyri — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Sesus: — O batu izotsa simysopyksapybyitsa nikaranaha ana humo hi nihyrizikubyri. Abaka Deus zikwy piwatawy. Iwatahi ihyrizikubyrita nipurukze my. Deus zikwy humo piwatawyky niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Deus zikpehaka. Abaka Deus pokzi tarabajaziu mynakara. Bykyze Deus pokzi tarabaja mykara batu zik. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Uta mybarawy eze tuze aparakbaha mysihyrinymyryky. Deus harere bo hyỹ mynakara hawa wasani my mozuruku anaty hi mysihyrinymyryky — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Kyze Sesus tasaytsik ty wytyk bo hezok niy. Tsahõrõ ty tysukni iwaze ihyrizikubyita hyriziktsa bo tsahõrõ ty pepetohi niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ipe niy: — Zarape Siroã inarokoha bo tyzakpikykta tsimy — niy. Siroã Sudeja harere zipehata motsaso. Iwaze ihyrizikubyrita zarape bo niparak. Taty hopik hopikby niy. Atsoko nikozo. Nizororobaba. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Iwaze kytsa iotutsa pauktsitsa asa zuba nipamykysokonaha: — Tohi sa ske eze ziknadyhykyta. Batu ty ba iktsa ziky. Kytsa ziknasiakzaikik “O kabo ja kabo ja” ziknakara. “Kadisahawy ty kabo nyny tsimy” nikara. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ata hi sa — Iotutsa pauktsitsa nikaranaha. Ata hiba nikaranaha. Wastuhu nikaranaha: — O batu. Maku ihyritywata hi zuba — niaha. Iwa asa zuba nipamykysokonaha. Iwaze tapara ihyrizikubyrita sibo taso: — Uta hiba kahyrizikubyrita niy. Tapara ske eze ziknadyhyky. Okyrysaro kadisahawy humo niwatihi kytsa bo ziknazapyikik. Uta tihi ba — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","— Hawata skaraba abaka ikia iktsa asopyk — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","— Sesus inarokota kabo izumu. Atahi tsahõrõ ty sukni kahyriziktsa bo tsikaeni zuba tsyk niy. Kape “Siroã zarape bo hopikty!” — niy. Yhỹ iky. Siroã zarape bo ikparak. Ikokpikze atsoko iktsa iky. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","— Haneze sa Sesus — niaha. — Yhỹ ja. Batu kanyhy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Iwaze iotutsa pauktsitsa tapara ihyrizikubyrita Pariseutsa bo zioktyhyryknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Sesus Sudeutsa byrykywy eze ihyrizikubyrita zizororowy. Tsahõrõ sukni ty ihyriziktsa bo pepe niyze tabyrykywy eze zizororowy. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Iwaze Pariseutsa niwatihi ipe niaha: — Hawa ta skaraba abaka iktsa asopyk — niaha. — Atahi tsahõrõ sukni ty kahyriziktsa bo tsikaeniha zuba pepe niy. Uta kino hopik hopikby ikytahi atsoko iktsa iky — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Pariseutsa nikaranaha: — Atakta zizororowy mybyrykywy eze tarabaja nikara. Aty niwa myzeka Deus iknybyita tarabaja humo — wastuhu nikaranaha. Ustsa tihi: — O batu. Hawa skaraba maku imysapybyita nikara Deus zikwy ty ziwatawy — nikaranaha. Iwaze Sesus zisohometukunaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Iwaze ipezo niaha: — Ikia tsikykara. Ahyrizikubyri humo zazororowyhik hawa isoho mytsaty tsimy — nikaranaha: — O atahi Deus sohokotsa my hỹ — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pariseutsa iharere humo batu sispirikpo niaha. Iharere bo batu yhỹ niaha. Iwatsahi kytsa izotsa nasioktyhyryknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Zumunahaze ispe niaha: — Hawa skaraba ahatse hi sa. Atahi sa ihyrizikubyrita nipuruk. Ihyrizikubyrita niy zeka hawa hãta skaraba abaka iktsa mykara — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","— O atakta katse my izo niy. Nipurukze ihyrizikubyrita hỹ niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Abaka iktsa mykara batu kanyhy izo niy. Aty sa zizororowy batu kanyhy. Katse botu taypyk iwatsahi ituk typamykysonaha. Hawa iktsa mykara anahi ituk typamykysonaha — izo niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Iwa izo Pariseutsa pokso nitsasoko. Tapara Pariseutsa tihi: — Aty skaraba Sesus Deus zipehata my zeka atahi Sudeutsa wahoro bo ba ziktsukzo — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Iwatahi izo nitsasoko: — Katse botu taypyk. Hawa abaka iktsa mykara anatyhi ipe tsimaha — nikaranaha. Sudeutsa pokso sipybyrẽtsa nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Kyze Pariseutsa tapara ihyrizikubyrita zioktyhyrykzonaha. Sibo izumuze ipe niaha: — Katsaktsa Deus okze tu tsimaha. Aharere wasania ty mybo tytsaso. Atahi zazororowyta batu imysapy my ana humo hi myhyrinymyrẽtsa — mybarapetu nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","— Atahi zikzororowyta imysapybara ty mynakara zeka batu isoho kawabyhy. Uta taparaka kahyrizikubyrita abaka iktsa mykara hỹ. Ana humo hi zuba kahyrinymyrẽta — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ipezo niaha: — Hawa sa niy. Hawa skaraba ahyriziktsa nisizororowy — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","— Botu iktsaso. Kaharere humo batu ahaspirikpo. Hawa skaraba kaharere tsipiwaby tsihikikzonaha niy. Tozeka ja ikiahatsa kino niwatihi ituktsa tsimoziknaha — niy. Iwa zizororota Pariseutsa pe niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","— Batu ba — nikaranaha. Sisakparẽtsa nikaranaha. Zizororowyta humo tahakyrikinaha: — Ikia hi itukta tsimy. Katsa Moises harere bo zuba hyỹ tsimykaranaha. Katsa Moises tuktsa tsimaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Moises Deus harere nitsasoko ana humo hi myhyrinymyrẽtsa hỹ. Azororowyta ja. Aty harere sa motsasoko. Hana iknykta sa izumu batu myhyrinymyry — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Zizororowyta niy: — Paze. Atahi zikzororowy. Uta kahyrizikubyrita tu zikzororowy. Ikiahatsa hi isoho humo batu ahahyrinymyry. Hana ikny sa izumu batu ahahyrinymyry niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Katsa myhyrinymyrẽtsa. Kytsa simysapybyitsa mykaranaha iwaze Deus bo mopamykysokonahaze batu siwabyhy nikara. Ba ziksitsumuẽhĩ. Asaktsa Deus harere bo hyỹ mykaranaha asahi Deus bo mopamykysokonahaze piwabyziuku. Mysitsumuẽhĩkĩ. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Batu aty tohi ihyrizikubyrita ty “tyzororowy” iwahaty batu tyso. Batu zik nikaranaha. Abaka atahi kahyriziktsa nisizororowy abaka iktsa kasopyk. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Deus harere bo hyỹ habyi zeka kahyriziktsa bazik sizororowy. Deus humo ipeha ahabyizeka kahyriziktsa ba zik isizororowy hỹ — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Kytsa ihumo tahakyrikinaha. Asahi: — Ikia amysapybyi ty tsimykara. Tsikpurukze ahyrizikubyrita amysapybara humo mybarapetu nikaranaha. Ikia tsimyhyrinymyry tsihikik nikaranaha. Nabo pãoty. Sudeutsa wahoro bo ba ziktsukzo — niaha. Tahakyrikinaha zizororowyta humo niaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Kyze Sesus isoho ziwabyze. Kytsa nizukeheknaha Deus wahoro bo ba ziktsuk niaha ana hi ziwaby. Iwaze zihobykze ipe niy: — Ikia Deus zipehata kytsa wata niyzik ihumo aspirikporẽta sa — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","— Aty sa Deus zipehata mywata niyzik. Ikia kabo tsipiwatawy zeka ihumo kaspirikporẽta hỹ my — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","— Aba ibo tsimykozoko. Atakino abo mopamykysoko atsatu Deus zipehata ahawata ikyzik — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Iwaze zizororowyta taekaratsa humo puruk puruk niy. — O kapehatsa abaka ahumo kaspirikporẽta my — niy. Aba motsasoko — Ikia zuba tsamysapyrẽta. Ikia zuba wasani tsimykara — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Sesus tihi: — Mybarawy bo iknasik. Iwaze kahumo kytsa meky watu moziknaha. Asahi katuktsa moziknaha. Deus sisoho “O simysapyrẽtsa maha” my. Ustsa batu. Kahumo batu sispirikpo. Iwaze asahi Deus tihi: “O batu simysapy mykaranaha” my. Wastuhu Deus harere soho “katsa batu myhyrinymyry. Iharere tsinymyry tsihikiknaha”. Asahi katuktsa moziknaha. Ustsa tihi “O katsaktsa Deus harere botu tsinymyrybanaha” mytsaty ahabyitsa nikaranaha. Asahi kahumo batu sispirikpo — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Pariseutsa iharere ziwabykynahaze ipe niaha: — Katsaktsa Deus harere humo myhyrinymyrẽtsa. Iwa tsimytsasokonahaze tahaspihikbatakanaha ja — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Sesus ispe niy: — Tsimytsasokonaha zeka: “O Deus harere batu myhyrinymyry, katsa iharere bo tsinymyry tsihikiknaha” Iwa tsimytsasokonaha zeka Deus okzeka ahamysapyrẽtsa tsimoziknaha hỹ. Ikiahatsa hi: “O Deus harere myhyrinymyrẽtsa.” Iwatsahi Deus okzeka batu ahamysapy tsimaha — niy. Iwa Sesus Pariseutsa bo nitsasoko. ");
INSERT INTO rkbNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Sesus nisihyrinymyryky. Hozipyrykzatsa soho humo nisiwatawyky. Kytsa hozipyrykzatsa hyrity watsa nisiwatawyky. Iwa nisihyrinymyryky: — O kytsa wabyziutaha! — niy. Aty hozipyrykzatsa okarawy hokbowybyita buruk tu mytsuk zeka isoho humo: — O atakta titsyhyryboarẽta. Atahi hozipyrykzatsa mysibykyryk iwatahi inatsuk hokbowybyita buruk tu — tsimykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","— Atahi hozipyrykzatsa okarawy hokbowy buruk tu paku my tahi sitsihitsa babata my — tsimykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","— Hozipyrykzatsa tsihitsa mozumuze hokbowy bazekta. Atahi hokbowy ty zoksapare myraratsa bo mytsuk. Hozipyrykzatsa tsihitsa iaksoho piwabynahaze sakurẽtsa moziknaha iwaze mysinaropykze estuba estuba zuba zipokonaha. Tahanaro piwabykynahaze ape bo mosisakpare. ");
INSERT INTO rkbNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Hozipyrykzatsa sizubarẽtsa ape bo pipokonahaze sitsihitsa siharaze mynaukuru. Hozipyrykzatsa iapik ziknaukurunaha. Iaksoho humo zinymyrynahatsa hi mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Sitsihitsabyitsa tu zeka batu iapik zikaha. Iaksoho humo batu sihyrinymyry iwatsahi iapik batu zikaha. Tahatsihitsabyita yksoho piwabykynaha zeka paikpa mynatururukuknaha. Sipybyrẽtsa moziknaha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Kytsa Sesus harere hozipyrykzatsa soho humo batu sihyrinymyry. Amy piwatawy naha humo tsihokdaharẽna. ");
INSERT INTO rkbNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Iwaze Sesus ispe niyzo: — O kytsa wabyziutaha! Hozipyrykzatsa siokarawy eze tu zeka batu aty tohi ziksiba. Batu aty tohi ziksiakse. Anaeze batu aty tohi ba ziksiboro. Uta katuktsa mysiperyky. Katuktsa hozipyrykzatsa watsa uta hi mysipokzitsiki niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Hozipyrykzatsa tahatsihitsa byitsa yksoho humo batu sihyrinymyry. Katuktsa niwatihi. Asaktsa zispihikbatakanahatsitsa humo batu sispirikpo. Tapara kaharaze izumukunahatsa wasanibara ty nisihyrinymyrykynaha. Iwatsahi batu siwabyziuhu. ");
INSERT INTO rkbNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Utakta hokbowy wata my iburuk mynapupunaha. Zoksapare mahaze tahadisahawy bo mynakaranaha bykyze mynapupuzonaha. Siokarawy eze batu aty tohi ba ziksiba. Asaktsa kahumo sispirikporẽtsa mysipokzitsiki. ");
INSERT INTO rkbNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Sitsyhyryboanikitsa mozumunahaze hozipyrykzatsa humo tahatsyhyryboanaha mysiba tsihikiknaha. Utakta meky watu my. Ikzumuze aparakbaha kahumo sispirikporẽtsa simysapyrẽtsa moziknaha. Sakurẽtsa moziknaha katuk mynapykyryknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Katuktsa mysipokzitsiki hỹ. Hozipyryktsa tsihitsa wata my. Uta katuktsa sapyzeky mohyrikosokda. ");
INSERT INTO rkbNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Aty hozipyrykzatsa tsihitsa tsumuẽhĩtsa atahi okyrysaro soho humo zuba tarabaja mykara. Batu istsihitsa babata byita tu. Sitsumuẽhĩtsa zuba. Parini mozumuze tsipybyrẽta ipokso moparakik. Hozipyryktsa myserekek. Iwaze parini mozumuze hozipyrykzatsa paikpa motururukuknaha. Nanabyitaba motururukuknaha. Parini hozipyrykzatsa mysiboro mykara tahi iwatsahi ipokso sipybyrẽtsa mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Tsumuẽhĩtsa niparakik. Okyrysaro humo tarabaja mykara. Iwaze hozipyrykzatsa batu sipokzitsinymyhy. ");
INSERT INTO rkbNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Utakta hozipyrykzatsa tsihitsa wata my. Kamypokzitsiukrẽta. Kazo humo kahyrinymyrẽta kazo kahumo tsihyrinymyrẽta. Nawatu katuktsa kahumo sihyrinymyrẽtsa. Utakta katuktsa iksinyba. Katuktsa pokzi mohyrikosokda. Estuba katukta pibeze zeka sisapyzeky mohyrikosokda — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","— Nanabyitaba ustsa sizubarẽtsa my. Usa okarawy eze mopykyryknaha. Asahi Deus bo mysioktyhyryk kaharere bo hyỹ mykaranaha. Sizubarẽtsa kaharere bo hyỹ mykaranaha. Utakta sizubarẽtsa kazo bo mysioktyhyryk hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Katuktsa pokzi mohyrikosokda. Mohyrikosokda bykyze mynahyrizikpo. Iwaze kazo kahumo tsimypokzitsiarẽta. Katuktsa pokzi mohyrikosokda kazo kahumo tsimypokzitsiarẽta. ");
INSERT INTO rkbNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Utakta mohyrikosokda ahabyi zeka ba zikbezenaha. Tubabatu kazo tihi: “Tsimyhyrikosokda zeka tsinahyrizikpo”. Iwatahi tsimyhyrikosokda tsihikik yhỹ tsimy. Bykyze tsimynahyrizikpo tsihikikze yhỹ tsimy kazo niy. Iwa — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Sudeutsa iharere soho niharapepehakanaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Wastuhu: — O atakta hyrikoso sapybara ituk napykyryk. Iwatahi paikpa mytsaty nikara. Amy sa tsipiwabykynaha — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ustsa Sudeutsa tihi: — O batu. Maku hyrikoso sapybara ituk mopykyryk zeka ba ziktsaso. Maku hyrikoso sapybara ituk mynapykyryk zeka ihyrizikubyrita bazizororowy batu zik — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Kyze Sudeutsa Sesus bo niaha. Serusarẽhe ezektsa myikaha niaha. Pororo ziknakaranaha, nawa Deus wahoro zubata nizukninahaze mytsaty ziknakaranaha. Hyritsikze imyikaha bo pororo ziknakaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Sesus Deus wahoro zubata zikarazik buruk paikpa nikaranaha. Tubabatu ispehatsa Soromao sapy zinaroko. ");
INSERT INTO rkbNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Anaeze Sudeutsa Sesus pauk baze niriktotohokonahaze ipe niaha: — Ikia hisa Deus zipehata ja Kiristu. Hawaze sa mybo asoho tsipiwatawyky. Ikia Deus zipehata tsimyzeka mybo tytsaso — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Sesus hi: — Botu kasoho iktsaso. Ikiahatsa kaharere humo batu ahaspirikpo. Hawa mykara Deus zikwy humo iwaze utakta Deus zikpehata mykara ana hi piwatawyky. ");
INSERT INTO rkbNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ikiahatsa kaharere humo batu ahaspirikpo. ");
INSERT INTO rkbNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Katuktsa kaharere bo hyỹ mykaranaha. Asahi hozipyrykzatsa watsa mykaranaha. Hawa hozipyrykzatsa tsihitsa hapik mokurunaha. Katuktsa niwatihi kaharere bo hyỹ mykaranaha. Kaksoho piwabynahaze sispirikporẽtsa. Uta kino mysiny. Katuktsa mynamopykyryknaha niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Kahumo simysapyrẽtsa moziknaha. Batu aty tohi ziksiakse. Batu estuba kino ba ziaksenaha. Tahawahi katuk mozurukunaha hỹ, mohyrikosokdanahaze Deus sihumo tsimypokzitsiukrẽta ituk tahawahi mynapykyryknaha ");
INSERT INTO rkbNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Kazo atahi zikpehahik iwatsahi sizubarẽtsa kahumo sispirikporẽtsa. Kazokta abazuba zikwy. Ba aty tohi iekze ziksiokty. Ba aty tohi katuktsa ziksiokty — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","— Kazikwy kazo zikwy kino atsatu my — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Iwa Sesus niyze Sudeutsa haraharetsa ty inasikyknaha iwatsahi ity zibezekyzykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Sesus ispe niy: — Uta kazo zikwy humo tisapyrẽna ty mykara. Amo sa haraharetsa ty tsipikbeze tsihikiknaha. Hawa sa ikykara — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Sudeutsa: — Amy ty isapyha ty tsimyzeka ba zabezenaha. Hawa Deus zikwy tsipiwatawy anahumo hi ba zabezenaha. Aharere batu imysapy mytsaty tsimykaranaha. Ikiakta maku zubata. Maku tuze “Kazikwy kazo zikwy kino atsatu” tsimy. Iwatsahi haraharetsa ty tsipabeze tsihikiknaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","35","Sesus: — Amy ty Moises ziwatahaka wasani niy. Deus harere ziwatahakaze wasani niy. Botu ziwatahaka Deus harere papeu humo “Ikiahatsa deustsa watsa tsimaha” botu ziwatahaka. Iwa kytsa bo asahi sinarohotsa. ");
INSERT INTO rkbNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Deus hi zikpeha. Aparakbaha Deus bo mysioktyhyryk my. Utahi mymyoktyhyrykta. Amy skaraba tsimaha: “O iharere ty Deus okzeka batu imysapy my.” Mytsasokoze “Utakta Deus tse my”. O iharere ty batu imysapy mybarapetu tsimykaranaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","— Utakta Deus zikwy humo watawy abyizeka kahumo batu ahaspirikpo wasani tsimykaranaha. Utakta Deus zikwy piwatawyky iwatsahi batu ahamysapy tsimykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Kaharere humo ahaspirikpo ahabyizeka hawa mykara anahumo hi ahaspirikporẽtsa. Tsimyspirikponaha zeka ikiahatsa: “O Sesus zikwy izo zikwy kino atsatu my” tsimaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Iwatsahi Sudeutsa itsipa humo asiba zioktyhyrykzonaha. Batu zik hawa tohi zikaha Sesus niwakik. ");
INSERT INTO rkbNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Iwaze Sesus buburu Sorodão inarokoha koikny zitsikzazo. Anaeze tapara Suão Batista sizubarẽtsa nisiharasusuku. Anabo hi Sesus niukuru. ");
INSERT INTO rkbNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Sizubarẽtsa ibo zumunaha. Asahi nipamykysokonaha: — O Suão Batista Deus zikwy ty batu mybo tywatawy. Amo ata maku soho botu nitsasoko wasani nikara — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Iwaze kytsa sizubarẽtsa iharere bo hyỹ nikaranaha. Asahi amykta taba buburu Sorodão ezektsa ihumo sispirikporẽtsa niaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Kyze Rasaru tsimyitsapyrẽta. Sinini nikara. Tatukykyryk tuk Betanija eze hudik ziknakaranaha. Maria inarokotatsa, ustatsa Marata inarokotatsa iwaza. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maria katsa Rasarutsy hi iokmorẽnikia tsipokzitsarẽna Sesus zipyryharasusuku. Taharadi ty zipyrywiki. Maria atatsa tihi. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Iwaze wytykyryk maku Sesus bo zipehahiknaha. Sesus bo zumuze ipe niy: — O ikia aharereziuwy tsimyitsapyrẽta — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ana ziwabyze Sesus ipe niy: — Botu kahyrinymyrẽta. Rasaru tsimyitsapyrẽta hiba. Mohyrikosokdaze niakbanahatsa tuk ba zikapykyryk. Deus zikwy humo mynahyrizikpo. Kytsa isoho motsasokonaha. Rasaru “Deus tse zikwy humo inahyrizikpo” mykaranaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Sesus Marata Maria Rasaru iwatsa humo tsimypokzitsiarẽta ziknakara. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Sihumo tsimypokzitsiarẽta tasapy eze inapykyryk iwaze petok zuruze ibo niukuru. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Kyze zinymyrykynahatsa pe niy: — Tupaktsa kytsa! Sudeja boktsa — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","— O mypehatsa Sudeutsa zabeze tsihikiknaha. Botua haraharetsa ty zabeze tsihikiknaha. Iwatatu sa tsipiksikirizo — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","10","— Yhỹ niy. Abaka Deus tarabaja mynakara. Okoroze kytsa haramwe humo amypubyri iktsa mykaranaha. Maku unata pitabakaze mynaraha. Batu iktsa zikaha. Maku okoroze pitabakaze wasani my. Haramwe humo ske buruk iktsa my. Aty Deus tsyhyryze tarabaja my zeka maku okoroze pitabakaze tawata. Bykyze batu zik maku unata pitabakaze tawata. Tupaktsa! Kytsa ba zikbezenaha Deus batu yhỹ mykara. Iwatsahi bazik bezenaha. Tapara Deus hyriziktsokzawy pepykba. Abaka ba zikbezenaha Deus kabete batu hỹ ziky. Aibani zuba pikbezenaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Zinymyrykynahatsa pezo niy: — Myharereziuwy Rasaru purubaka. Abahi mozipopo — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","— O purubaka zeka mozororozo hỹ — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Rasaru botu nihyrikosokda ana humo hi Sesus tsihyrinymyrẽta. Iwatatu — “Rasaru purubaka” niy iwatsahi Rasaru purubaka tu ja — mytsaty nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Iwaze Sesus mypubara ty nitsasoko. Ispe niy: — Rasaru nihyrikosokda — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Iwatatu ibo batu pão. — Aba Deus zikwy pahawatawyky. Kazikwy humo iktsa tsimahaze kahumo ahaspirikporẽtsa tsimoziknaha. Iwatahi kakurẽta. Nihyrikosokdata boktsa kytsa! Tupaktsa — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","— O katsa ituk tsimykurunahaktsa kytsa! Sesus pibezenaha zeka katsa niwatihi ituktu tsimyhyrikosokdanaha — Tome niy. Tome beketsa petok inarohota nikara. Iwaze Sesus tuk zinymyrykynahatsa nihyrikosokdata bo zumukunaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","18","Betanija bo zumunaha. Betanija Serusarẽhe bazebabatu. Harakykbyi kirometero zuba. Nihyrikosokdata sapy bo zumunaha. Kytsa: — O Rasaru nihyrikosokda. Harakykbyihi zuruze Rasaru harahare oke eze ziytyknaha — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Marata itsy Maria niwatihi Rasaru pokzi nipuziukunaha. Sudeutsa kytsa situk Rasaru pokzi nipuziukunaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Iwaze Marata Sesus sukmo soho ziwabyze atatsa ibo niukuru. Sesus zihobyk. Maria wahoro eze tu niapykyryk. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marata Sesus zihobykze ipe niy: — O ikia mytuk tu zeka kaokaha ba zikumuza. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Amy Deus bo tsimyzapykyky atsatu abo nyny my. Ikia Deus bo tsimypamykysoko zeka kaokaha soho amy tsimyzapykyky anahi abo nyny my — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","— Aokaha mynahyrizikpo — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","— Yhỹ niy. Atahi mynahyrizikpo ana humo hi kahyrinymyrẽtatsa. Deus myzo siakbatsa sizubarẽtsa nasihyrizikpoze kaokaha kino niwatihi mynahyrizikpo — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Sesus: — Uta hiba siakbatsa hyrizikpokotsa. Kahumo nahyrizikponaha. Kytsa kahumo sispirikporẽtsa asahi mohyrikosokdanahaze nahyrizikponaha asahi Deus tuk tahawahi mynapykyknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Asahi kahumo sispirikporẽtsa tuze niakbanahatsa tuk ba zikykpykyknaha. Asahi Deus tuk mynapykyryknaha. Kaharere bo sa hyỹ tsimy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","— Yhỹ niy. Ikia hi Deus zapehata mywata tsikyzik. Ikia hi Deus tse babata. Tahi tsipiperykynaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Iwaze Marata nitsasobaze tatsy bo ziksizo. Tatsy bo nisakzihiki tu. Ustsaktsa batu siwabyhy: — O katsy mypehatsa izumu ikia zasapykyky. Ske puk teze tu — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Iwaze Maria ziwabyze Sesus bo niparak. Aidy kyikyk niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Izumubahaneze pyk niy. Marata zihobyk anaeze ibo zumu. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Sudeutsa atatsa hapik niukurunaha. Asahi Rasaru pokzi nipuziukunaha. Atatsa bo iktsa niahaze: — O iytyk bo ja moparakak — mytsaty ahabyitsa nikaranaha. Iwatsahi iapik niukurunaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Atatsa Sesus bo zumu. Ibo iktsa niyze taekaratsa humo puruk puruk niy: — O mypehatsa ikia mytuk zeka kaokaha ba zikumuza — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Maria taokaha pokzi nipuziuku atatsa bo Sesus iktsa niy. Sudeutsa kino ituk nipuziukunaha. Sizubarẽtsa nipupuziukunaha. Sisukatsihikrẽtsa. Sesus sihumo tsimypokzitsiarẽta. Iwatahi sihumo tisukatsihikrẽta niyzik. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","— Iytyk sa hana eze — niy. — O mypehatsa panykta anaeze — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Sesus sipokzi nipu. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Iwatsahi Sudeutsa ihyritsik bo iktsa niahaze: — O Rasaru humo tsimypokzitsiarẽta — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ustsa kytsa: — Tapara ihyrizikubyrita zizororowy. Tozeka ja Rasaru ty iwa my tawata hỹ — nikaranaha. Asa zuba nipamykysokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Iwaze Sesus ihumo tsimypokzitsiarẽta iytyk bo zumu. Tisukatsihikrẽta nikara anaeze harahare hok eze niapykyryk. Sesus Mata Maria Sudeutsa kytsa sizubarẽtsa iwatsa iytyk bo zumukunaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Sesus ispe niy: — Harahare tsispetunahaktsa! — niy. — Mypehatsa ba hawa tohi zikaha! Abaka inury mobibibaka harakykbyihi zuruze anaeze nitsahok. Tsihõhõrẽta — Marata niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","— Uta zuba botu iktsaso ikia kahumo aspirikporẽtatsa zeka Deus zikwy piwatawyky. Ana humo hi ma tsimy — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Iwaze kytsa harahare zipetuhiknaha. Sesus Deus bo nipamykysoko: — O kazo kaharere tsiwabyikik. Iwatahi “Ikia tsamysapyrẽta” mykara. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Kaharere tsiwabyikik. Anahi kahyrinymyrẽta. Kytsa kapauk bazektsa okze abo mopamykysoko. Iwatsahi kahumo sispirikporẽtsa moziknaha. Ikia hi tsikpeha ana humo hi sihyrinymyrẽtsa — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Sesus tazo bo nipamykysobaze opykani huahua niy: — Rasaru pany puketyny — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Rasaru nihyrikosokdata tu atsoko izoihik. Panu ty takwarawytuk tu zizoi. Sesus ispe niy: — Iakwarawy tsipararanahaktsa iwaze pitaba! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Iwaze mektsaktsa Sudeutsa Maria bo inakozorenaha Sesus humo sispirikporẽtsa moziknaha. Asahi Rasaru inahyrizikpo naha zinynaha Sesus humo sispirikporẽtsa. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ustsa kytsa ihumo batu sispirikpo. Asahi Pariseutsa bo nitsasokonaha. Ispe niaha: — O Sesus nihyrikosokdata Rasaru zihyrizikpowy — niaha. Iwa Pariseutsa bo nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Iwaze Pariseutsa, taparaktsa ziknapamykysokonahatsa iwatsa izumubanaha. Asa zuba Sesus soho ty nipamykysokonaha: — Hawa sa Sesus ty tsimaha. Atakta tazikwy myzubaha bo ziwatawyky. Hawa sa Sesus ty tsimaha ");
INSERT INTO rkbNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ata tazikwy piwatawyikik zeka kytsa sizubarẽtsa ihumo sispirikporẽtsa moziknaha. Situktsa moziknaha. Sesus ispehatsa mozik zeka Homa taparakta Sesa sodadutsa mymyoktyhyryk mysipeha Deus wahoro zubata pipaparabanaha. Mytyryktsa mokbabanaha. Myhyrytsa nihyrikosokdata Moises harere ty ba ziksihyrinymyrynaha — iwa asa zuba nipamykysokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Iwaze taparakta ziknapamykysokota Kajapas inarokota ispe niy: — Ikiahatsa batu ahahyrinymyry niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Sesus tsipibezenaha zeka Homa sodadutsa mytyryktsa ba ziksibanaha. Iwatsahi katsa Sesus tsipibezenaha zeka wasani my. Kaharere ahahumo tsihokdaharẽna iwa zeka Homa sodadutsa mytyryktsa ba ziksibanaha — Kajapas niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Deus tapara tihi: — Sesus kytsa sapyzeky mohyrikosokda — niy. Ana hi Kajapas batu hyrinymyry. Nitsasokoze: — Katsa Sesus tsipibezenaha zeka wasani my — niy. Deus harere soho batu ihyrinymyry. Ihyrinymyrybyita tu Deus harere bo yhỹ niy. Hawa mytsaty nikara batu tyso. Sesus Sudeutsa tyryktsa sapyzeky mohyrikosokda Deus botu nitsasoko. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ustsa kytsa bipyritsa sapyzeky kino niwatihi mohyrikosokda. Iwatsahi sizubarẽtsa Deus tyryktsa sakurẽtsa moziknaha. Iharere bo hyỹ mykaranaha. Iwatahi Sesus mohyrikosokda Deus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Iwa zeka Sudeutsa taparaktsa asa zuba nipamykysokonaha: — Hawa sa Sesus tabeze — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Iwatahi Sesus Sudeutsa pokso mekybotu niparak. Eparã bo niy. Eparã jerukbara bo tasapy. Anaeze Sesus tuk zinymyrykynahatsa tuk niapykyryk. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Sudeutsa kytsa sizubarẽtsa Serusarẽhe bo niukurunaha. Sudeutsa myikaha bo Serusarẽhe bo pororo ziknakaranaha. Paskoa mokymyze anaeze Deus taparaktsa nisitsumuẽhĩkĩ ana bo mytsaty ziknakaranaha. Sizubarẽtsa Serusarẽhe bo niukurunaha. Tapara simyikaha kymybyitu tahasopyk tyty nikaranaha. — Katsa meky watu tsimoziknaha zeka Deus okzeka wasani tsimaha — nisisopykyknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","57","Iwaze sizubarẽtsa Sesus ziperykynaha. Asahi Deus wahoro zubata sturupe eze ziberikinaha. Asahi: — Mymyikaha bo ja mozumu — nikaranaha. Asa zuba ziperykynahaze nipamykysokonaha. Pariseutsa, taparaktsa Deus wahoro zubata eze ziknapamykysokonahatsa iwatsa aparakbaha nisipehaka. — Aty Sesus piny zeka mybo tytsaso! — niaha. Iwa nitsasokonaha Sesus tsipa humo ziokty tsihikiknaha hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Kyze Sesus Rasaru bo zumu. Atahi zihyrizikpowyta ibo zumu. Rasaru Betanija ezekta niy. Tapara Sudeutsa myikaha Paskoa inarokoha zumubahanize. Iwaze hi zuba simyikaha nakymy. Iwaze Sesus tuk zinymyrykynahatsa tuk Rasaru bo zumunaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Anaeze Marata sidisahawy humo bu nikara. Rasaru zinymyrykynahatsa tuk tadisahakanaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maria jokmorẽnikia zebykyk niy. Jokmorẽnikia ty tsasuk tisapyrẽna eze narado inarokoha ipokzitsanikia. Atatsa jokmorẽnikia tsizubarẽna ty zibykyryk niy. Iwatatsahi Sesus zipyrytsa harasusuku. Iwaze atatsa taharadi tyty zipyrywiki niy. Iwahoro tsiokmorẽna niypykyryk. Atatsa Sesus humo tsimypokzitsiarẽtatsa iwatatsahi Sesus zipyrytsa harasusuku. Iwa Maria nikara. ");
INSERT INTO rkbNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Sudas Iskariotses Sesus tuk zinymyrykyta tisakparẽta mozik. Atakta Sesus humo tsiharerewabymybarẽta, sisukyrytsitsa bo myzioktyhyrykta. Atahi zibetsakak ipe nikara: ");
INSERT INTO rkbNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","— Amy skaraba jokmorẽnikia ty batu ity huak. Tsipihuak zeka okyrysaro tsizubarẽna tsimaha. Iwaze okyrysaro sinamybyitsa bo nyny tsimaha zeka wasani my — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Sudas Iskariotses zinymyrykynahatsa okyrysaro suk zikziperyky. Ustsa papatu okyrysaro zikziakseke. Tatsyhyryze hi okyrysaro ziakseke ustsa papatu ziknakara. Nitsasokoze — Amy skaraba jokmorẽnikia ty batu ity huak — okyrysaro humo niy. Ata kino okyrysaro ziakse tsihikik. Imypokzitsiukbyita tu okyrysaro ziakse tsihikik. Batu sinamybyitsa bo nyny ziky. ");
INSERT INTO rkbNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","— O awatu betsak betsak byity! — Sesus niy. — Atatsa hi jokmorẽnikia ty zipyryktsa harasusuku. Atatsa hi kaokzeka tsimysapyrẽtatsa jokmorẽnikia ty pikarasusuku my niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Sinamybyitsa bo nyny tsimykaranaha zeka wasani my. Utakta ahatuk batu mopykyryk kabo ka ba nyny zikaha. Jokboha kyritoktok ahatuk mopykyryk. Aba kabo ty nyny tsimaha zeka wasani my — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","18","Kyze Sudeutsa sizubarẽtsa Sesus bo zumunaha. Sesus Betanija eze niapykyrykspyk. Ana ziwabynahaze Sesus Rasaru ahatsa bo niukurunaha sibo inakozorenaha. Atahi Sesus zihyrizikpozota bo inakozorenaha. Sudeutsa sizubarẽtsa taparaktsa Deus wahoro eze ziknapamykysokonahatsa ihumo batu sispirikpo. Rasaru inahyrizikpoze kytsa Sesus humo sispirikporẽtsa. Iwaze taparaktsa Deus wahoro eze ziknapamykysokonahatsa nitsasokonaha: — O Rasaru niwatihi tabezehikta kytsa — nikaranaha. Kyze aparakbaha Sesus bo iktsa nikaranaha. Sesus Rasaru zihyrizikpozoze ziwabykynaha. Hawa ipe niy: — Rasaru pany — niy. Iwaze Rasaru harahare ioke ikny zoihik. Iwaze Sesus Serusarẽhe bo niukuruze pikuza bete tadyhyhyk. Tubabatu Deus harere papeu humo tubabatu ziwatahaka atsatu Sesus nikara. Iwatahi pikuza bete tadyhyhyk. Deus harere papeu humo tihi: — O Serusarẽhe ezektsa ahasukatsihik byihuja! — niy. — Ahapehatsa mozumuze pikuza bete tadyhy — niy. Iwa tubabatu Deus harere papeu humo ziwatahaka. Iwatahi Sesus pikuza bete tadyhyky. Iwa Serusarẽhe bo niy. Kyze kytsa sizubarẽtsa Serusarẽhe bo niukurunaha tahamyikaha bo asahi Sesus bo niaha. Ziwabykynahaze: — O Sesus mozumuku — nikaranaha. Iwaze ibo niukurunaha. — O Sesus tazikwy ty mybo tsipiwatawyky — nikaranaha. Tazikwy ziwatawykyze Rasaru zihyrizikpowy niy. Anahi ziwabykynaha. Iwatsahi Sesus haraze niukurunaha. Iwaze tsarakzapatsa nasibykyknaha ske buruk nisipaparakanaha. Sizubarẽtsa nikaranaha. Sesus ispehatsa wata humo. — Sesus Deus tuk niapykyryk. Mywata niyzik. Deus tukta katsa mybo inasik. Atakta mypehakatsa my, katsa Isareu tsekokatsa ikia hi mypehakatsa. Atakta Deus ihumo mymysapywyky hỹ. “O mykurẽtsa” — nikaranaha. Sesus Serusarẽhe bo niy. Pikuza bete tadyhyhyk iwa Serusarẽhe bo zumuku. Hawa tubabatu Deus harere papeu humo ziwatahaka atsatu Serusarẽhe bo zumu. Wasani niy. Sesus Serusarẽhe bo niyze hawa tubabatu ziwatahaka. Ana humo hi zinymyrykynahatsa batu sihyrinymyry tsihokdaharẽna. Anaharere batu siwabyhy. Aiba zuba mytsaty nikaranaha. Sesus bijoikpe bo nidoze tahapetu sisopyk: — O Sesus Serusarẽhe bo zumuze Deus papeu humo botu ziwatahaka tawata hawa tubabatu ziwatahaka atsatu niyze Serusarẽhe bo zumu — iwa Sesus soho bo mytsaty nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Kyze Pariseutsa asa zuba nipamykysokonaha: — Kytsa sizubarẽtsa ihumo sispirikporẽtsa nikaranaha. Kytsa myharere bo batu yhỹ zikaha. Katsa tsimytsasokonaha zeka “ihumo batu ahaspirikpo” kytsa “ihumo sispirikporẽtsa” — nikaranaha. Asa zuba Pariseutsa nipamykysokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Kyze Kerokotsa Sesus bo mokozorenaha. Asahi ustsa tyryktsa meky ezektsa tu niaha. Asahi Serusarẽhe myikaha bo niukurunaha. Sudeutsa tuk Deus bo nipamykysokonaha: — O ikia zuba tsamysapyrẽta. Deus zuba atahi tsipunihikrẽta bijoikpe eze my tsimaha — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Piripi bo nikaranaha. Atahi Betesaida ezekta. Betesaida Karireja eze ky. Ata bo hi niukurunaha. Ipe niaha: — O Sesus bo tsimynakozore tsihikiknaha — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Iwaze Piripi Ãdere pe niy atahi Peduru tsy ipe niy: — O Kerekotsa Sesus bo mynakozore tsihikiknaha — niy. Kyze Piripi Ãdere ahatsa Sesus pe niaha. Asahi: — O Kerekotsa abo mynakozore tsihikiknaha — mykaranaha. Iwa Sesus bo nitsasokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Sesus ispe niy: — Utakta iknasikta maku babata ahawata ikyzik. Aibani mohyrikosokda. Mohyrikosokdaze kytsa piksohonaha! Atakta tsimysapyrẽta tsizikwyrẽta my — mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","— Wabytoktotaha niy. Katsaktsa tapara riktsa tsimysipariknaha. Tsimysipariknahaze wytyk bo pokpok tsimykaranaha. Estubaze zuba wytyk eze my, ata hi taypykze riktsa tsiriktsazubarẽta mozik. Hawa riktsa mysiubara iwata tabezewy ziwatawyky. (Iwa nitsasokoze tabezewy soho ziwatawyky.) Tapara mohyrikosokda bykyze mynahyrizikpo my. Iwaze kytsa sizubarẽtsa kahumo sispirikporẽtsa. Rik soho iktsasokoze hawa rik mysiubara iwa tabezewy soho ziwatawyky — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","— Aty Deus harere bo yhỹ ahabyizeka mohyrikosokdaze Deus tuk ba zikapykyk. Aty Deus harere bo hyỹ mykara zeka mohyrikosokdaze tawahi Deus tuk mynapykyryk. ");
INSERT INTO rkbNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Aty katukta mozik zeka kaharere bo hyỹ mykara. Kaharere bo zuba hyỹ mykara, katuk tawahi mynapykyryk. Kazo ihumo mykara: O atakta tsimysapyrẽta mykara — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Sesus tihi: — Abaka paikpa mytsaty mykara. Hawa ha ty ja Deus bo mopamykysoko “O kazo kabezetsihikbyita mykara” my. Iwa Deus bo batu tyso. Utakta mybarawy eze sinini mykara naha humo tsimyzihikik zeka yhỹ my. Iwa ibo mopamykysoko — my. ");
INSERT INTO rkbNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Kyze Deus bo mopamykysozo: — O kazo kytsa bo tysisapywyky. Iwatsahi asoho motsasokonaha “O Deus tsamysapyrẽta. Azikwyrẽnikita tu tsimypokzitsiukrẽta” nikaranaha — iwa asoho motsasokonaha. Iwa babatu iaksoho bijoikpe ikny iwaby. Deus tihi: — Botu kasoho ziwatawyky. Aparakbaha botu kahumo piksohokonaha “O Deus tsamysapyrẽta, azikwyrẽnikita tu tsimypokzitsiukrẽta”. Ikia hi myhyrizikwanikita kasoho piwatawykyzo. Kytsa sizubarẽtsa kasoho tihi: “O Deus tsamysapyrẽta, azikwyrẽnikita tu tsimypokzitsiukrẽta” mykaranaha — Deus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Kytsa sizubarẽtsa Sesus baze niriktotohokonaha iaksoho ziwabynahaze. Wastuhu kytsa nikaranaha. — O nitotokoro — nikaranaha. Ustsa kytsa batu. — Bijoikpe iknyktsa Deus tsumuẽhĩtsa ibo nitsaso — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Kyze Sesus ispe niy: — Iaksoho tsiwabynahaze bijoikpe ikny ahatsyhyryze niy. Batu kahumo ka. Ikiahatsa bohi Deus harere tsiwabykynaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Abadisihi Deus kahumo sispirikpobyitsa bo motsaso ispe my: — O ikiahatsa batu ahamysapy tsimykaranaha. Sesus humo tsimyspirikpobyrikinaha zeka batu ahamysapy tsimykaranaha. Ahapehatsa Sesus humo mypunihikbyinaha. Batu aty tohi ityryk zikyzik. Sesus zuba ipunihikanikita my — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","— Sizubarẽtsa kahumo batu siakparawy. Iwatsahi pikbezenaha. Iharapatawyhyta humo pikyriziknaha iwa mohyrikosokda. Iharapatawyhyta pitseknahaze pikbezenaha. Iwa mohyrikosokdaze kytsa nanabyitaba kahumo sispirikporẽtsa moziknaha — nikara. ");
INSERT INTO rkbNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Sesus tasokoze niy iwaze iharapatawyhyta humo pihyrizikiknaha. Hawa mohyrikosokda mysihyrinymyryky niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Sizubarẽtsa ipe niaha: — Tubabatu Deus harere papeu humo Kiristu soho ziwatahaka. Tubabatu nihyrikosokdata Moises ziwatahaka. Kiristu, Deus zipehata ba zihyrikosokda. Tawahi mynapykyryk — niy. — Ikia “Utakta iknasikta maku babata ahawata ikyzik” tsimy. Atahi inasikta maku babata mywata mohyrikosokda bykyze mynahyrizikpo tsimy. Atakta ja Deus zipehata niwatihi atsatu sa — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Sesus ispe niy: — Utakta Deus harere myzubaha bo mysihyrinymyryky. Aba mysihyrinymyryky. Aibani mohyrikosokda iwatsahi kahumo ahaspirikporẽtsa tsimoziknaha. Abaka kahumo ahaspirikporẽtsa zeka wasani my. Kahumo ahaspirikpo ahabyizeka sinini ykarawy bo tsimaha. Kytsa unata eze batu pão maha. Hana bo mykaranaha miwa humo batu sihyrinymyry. Iwa kytsa kahumo batu sispirikpo miwa ezektsa watsa mykaranaha. Asahi sinini ykarawy tahasapy humo hi batu sihyrinymyry. Kytsa miwa haburuk tu mokurunahatsa watsa. ");
INSERT INTO rkbNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Utakta ahatukze kahumo ahaspirikporẽtsaktsa! Iwaze katyryktsa tsimoziknaha. Ahamysapyrẽtsa tsimoziknaha. Mekywatu tsimoziknaha. Kytsa iwororoha buruk pitabakanahaze ana bo hi pinynaha ikiahatsa siwatsa tsimoziknaha — niy. Iwaze nitsasobaze niparak. Kytsa sizubarẽtsa papatu niparak. ");
INSERT INTO rkbNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Kyze Sesus zikwy myzubaha bo ziwatawyky. Asahi ihumo batu sispirikpo. Iwaze iwatawy bo iktsa nikaranahaze ihumo batu sispirikpo. ");
INSERT INTO rkbNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","— Tubabatu Deus sohotsa Isaijas botu ziwatahaka: “O mypehakatsa aharere ty kytsa sizubarẽtsa bo iktsasoko. Kytsa aharere humo batu sispirikpo. Ikia azikwy soho humo batu sihyrinymyry. Ikia azikwy soho sihumo tsihokdaharẽna” niy. Iwa nihyrikosokdata Isaijas kasoho ziwatahaka. Iwaha humo hi kytsa batu kahumo sispirikpo mahaze Isaijas harere wasani my nikaranaha. Isaijas papeu humo ziwatahaka — niy. Asa watsa nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Sudeutsa Sesus humo batu sispirikpo. Hawa Isaijas tubabatu ziwatahaka nikaranaha. Isaijas nihyrikosokdata: ");
INSERT INTO rkbNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","— Deus hawa kytsa mytsaty mykaranaha tsihyrinymyrẽta ihumo paikpa mytsaty mykaranaha. Deus zikwy humo batu sispirikpo. Izikwy bo iktsa nikaranahaze batu ihumo sispirikpo. Deus harere ziwabynahaze batu ihumo sispirikpo. Ihumo sispirikpobyritsa tu simysapybyitsa nikaranaha Deus batu mysiokzo. Simysapybyritsa situk niapykyknaha. Batu ihumo sispirikpo iwatsahi simysapybyitsa nikaranaha Deus ba zisiokzo — niy. Iwa tubabatu Deus sohokotsa Isaijas ziwatahaka. ");
INSERT INTO rkbNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Tubabatu ziwatahaka iwatsa tu Sesus harere ty kytsa batu siwabyhy, ana humo hi tsihyrinymyrẽta. Iwatahi ziwatahakaze Sesus soho ziwatahaka. Aibani zuba aparakbaha ana humo hi sihyrinymyrẽtsa. ");
INSERT INTO rkbNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Sudeutsa taparaktsa sizubarẽtsa ihumo sispirikporẽtsa. Batu tyso: — Katsaktsa Sesus humo myspirikporẽtsa tsimoziknaha. Ana ty hi batu tyso. Pariseutsa pokso sipybyrẽtsa ba ziktsasonaha. Sudeutsa wahoro tozeka ja kytsa ispe nabo pãotaha. Iwaze ba ziknapupunaha ana pokso sipybyrẽtsa iwatsahi batu tyso “Sesus humo myspirikporẽtsa” — mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Pariseutsa harere bo mytsatyziu nikaranaha. Kytsa harere humo zuba sakurẽtsa. Deus humo ka batu. Deus harere humo tsikaeni zuba sihyrinymyrẽtsa nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Sesus sizubarẽtsa opykani nisihuahua: — Kytsa kahumo mynakaranaha zeka kahumo sispirikporẽtsa. Ata humo zikpehaka sispirikporẽtsa niwatihi — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","— Aty pikny zeka kazo kino piny. “O atakta Deus tse” my zeka Deus zikpehaka niwatihi yhỹ my — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","— Uta mybarawy bo ikzumu. Deus harere ty pahahyrinymyry iwatahi ikzumu. Kytsa kahumo sispirikporẽtsa iwatsahi simysapyrẽtsa moziknaha. Kytsa iwororo ha buruk pitabakanahatsa watsa pinynaha siwatsa moziknaha. Hawa wasani mykaranaha sihyrinymyrẽtsa, meky watu moziknaha. Simysapyrẽtsa hi. ");
INSERT INTO rkbNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Aty kaharere piwabykyze iwaze batu yhỹ my. Uta kino batu tyso: “O ikia Deus okzeka batu amysapy tsimy” iwa batu tyso. Utakta mybarawy bo ikzumu kytsa sizubarẽtsa bo my. Sizubarẽtsa simysapybyitsa nikaranaha kahumo meky watu moziknaha zeka Deus bo mysioktyhyk. Iwatahi ikzumu. ");
INSERT INTO rkbNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Asaktsa kahumo batu sispirikpo. Kaharere bo batu yhỹ mykaranaha. Usta ispe: “Ikiahatsa Deus okzeka batu ahamysapy tsimykaranaha” my. Deus aparakbaha mynasihyrizikpoze ispe my: “Ikiahatsa Deus okzeka batu ahamysapy tsimykaranaha”. Utakta ahasoho ty batu tyso. Usta iwa motsasoko. Kytsa kaharere bo batu yhỹ mykaranaha zeka iwa ispe my. ");
INSERT INTO rkbNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Hawa motsasoko kazo harere my. Iharere hi ahabo motsasokoro. Hawa pahahyrinymyryky iharere zuba mykara. Usta harere ty ka batu tyso. Kazo harere zuba motsasoko. ");
INSERT INTO rkbNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Iharere bo hyỹ tsimaha zeka meky watu tsimoziknaha. Ahamysapyrẽtsa tsimoziknaha. Tsimyhyrikosokdanahaze Deus tuk ahawahi tsimynapykyryknaha. Ana humo hi kahyrinymyrẽta. Iwatahi iharere zuba motsasoko — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Byriri Paskoa maha taeze myikaha nakymy. Sesus zinymyrykynahatsa tuk tadisahaka. Sesus sihumo tsimypokzitsiarẽta. Abahi mohyrikosokda naha humo tsihyrinymyrẽta. Tazo bo piksizo ana humo hi tsihyrinymyrẽta. Iwatahi tahadisahakanahaze hawa sihumo tsimypokzitsiarẽta mysiwatawyky. Sihumo tsimypokzitsiarẽta nikara. ");
INSERT INTO rkbNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Zinymyrynahatsa tuk tadisahaka. Sudas Iskariotses Sesus sukyrytsitsa bo pioktyhyryk. Sesus soho sukyrytsitsa bo motsasoko. Sudas Iskariotses Simotse my. Hyrikoso sapybara pehakatsa Satanas humo Sudas Iskariotses Sesus isukyrytsitsa bo pioktyhyryk isopyksapybyita nikara. ");
INSERT INTO rkbNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Sesus ana humo hi tsihyrinymyrẽta nikara. Atahi: — O Deus tazikwy ty kabo nynyty niy. Deus kazo zikpeha. Aba Deus bo piksizo — niy. Ana humo kino Sesus tsihyrinymyrẽta. ");
INSERT INTO rkbNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Kyik niyze takpyzazawy ty zukata niy. Iwaze takwiwy ty okok niy. Tazikuoik humo haĩ niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Iwaze pihik ty mypewy bo zisusuku niy. Maraksu maraksu nikara. Zinymyrykynahatsa nisipyrytsapikik. Tapara zipyrypikik iwaze zipyrywiki. Usta bo zipyrypikik iwaze zipyrywiki. Siwatu nisipyrytsapikik. ");
INSERT INTO rkbNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Iwaze Simaõ Peduru bo zumuze. Peduru: — O hawa sa tsimy tsipikpyrytsapik sa — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","— Yhỹ my. Aba nawa humo papyrytsapikik batu ahyrinymyry. Aibani zuba tsipinymyry amy humo papyrytsapik iwatahi aibani zuba tsipinymyry — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","— O batu ba niy. Ikiakta ba zikpyrytsapik — Peduru niy. Sesus ipe niy: — Aty pyrytsapik ahabyizeka batu katuktsa tsimy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","— Tsipikpyrytsapik zuba taziwazy. Katsyhyrypetsa tuk tu iwaze kaharek tuk tu tsimy hỹ — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","— Tsinamurukunahaze batu ahakpiaktsĩ. Tsahabarazarẽtsa. Deus ahasopyksapybyitsa tu tsikykaranahaze pahaokzohik iokzeka nimuruku tawata tsimoziknaha. Deus botu ahamysapybara ty tsikykaranahaze iwatatu pahaokzo iwatahi inamuruhuknahatsa watsa tsimoziknaha. Estuba zuba ahatuk imysopyksapybyita tu nikara ba ziokzo. Imysopyksapybyita tu nikara tsiaktsiarẽta wata niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Estuba sisukyrytsitsa bo moparak isopyksapybyita mykara ana humo hi tsihyrinymyrẽta iwatahi “Estuba ahatuk imysopyksapybyita tu mykara ba ziokzo” — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Nisipyrytsapikbaze takpyzazawy ty korobykzo niy. Hwibihi mydisahakawy bo zinymyrynahatsa tuk tadyhyzo niy. Ispe niy: — Ahapyrytsa pikbaze ahahumo ka sa tsihokdarẽna niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ikiahatsa kape tsimykaranaha: “Mypehakatsa myhyrinymyrykytsa” tsimykaranaha. Wasani tsimykaranaha. Ahapehakatsa. Ahahyrinymyrytsa my. ");
INSERT INTO rkbNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Iwaze pahatsumuẽhĩkĩ iwatsahi ikiahatsa kino niwatihi ustsa kytsa tysitsumuẽhĩnahaktsa! ");
INSERT INTO rkbNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ikiahatsa kawatu tynakaranahaktsa! Ahapyrytsa pikiknaha wa. Ikiahatsa ustsa tysitsumuẽhĩnahaktsa! Utakta batu tyso: “O uta sipehakatsa my. Iwatahi batu isty tsumuẽhĩ.” Utakta ahatsumuẽhĩkĩ. Ikiahatsa kawatu ahamytsumuẽhĩhuktsa! Tyharape tsumuẽhĩnahaktsa tsimykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Kaharere tsiwabyziukunahaktsa! Sitsumuẽhĩtsa pehatsa wa sukni ahabyita my. Zipehata tohi zipehaka harapewa sukni ahabyita my — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","— Abaka ahahyrinymyrẽtsa tsimaha. Kaharere bo tsimykaranaha zeka ahakurẽtsa tsimoziknaha hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ikiahatsa bo motsasoko. Asahi nisiwatawyhik. Estuba ahatuk kasukyrytsitsa bo pikoktyhyryk. Imyspihikbatanikita iwatsahi pikbezenaha ana humo hi kahyrinymyrẽta. Hawa ha ty Deus papeu humo tubabatu ziwatahaka atsatu my: “Estuba maku katukta isopyksapybyita mykara. Atakta kadisahawy ty katuk hauk my ata hi isopyksapybyita my” niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Byri puẽtsik kytsa pikbezenaha ana kino ahabo motsasoko. Iwaze pikbezenahaze kaharere humo tsimyspirikponaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Kaharere tsiwabyziunahaktsa! Atakta pipehahik ihumo tsikspirikpokoze kahumo tsaspirikporẽta hỹ. Atahi kahumo tsikspirikpoze atakta zikpehahik niwatihi ihumo tispirikporẽta hỹ — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Iwa nitsasoze tisukatsihikrẽta niy. Zinymyrykynahatsa pe mypubaraty niyzik. — Tsiwabyziukunahaktsa! Estuba maku ahatukta kasukyrytsitsa bo pikoktyhyryk. Imyspihikbatanikita — iwa sizubarẽtsa bo nitsasoko. ");
INSERT INTO rkbNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Iwaze ziwabynaha tsahi paikpa mytsaty nikaranaha. Asa zuba nipamykysokonaha: — O aty skaraba. Aty sisukyrytsitsa bo sa pioktyhyryk — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Zinymyrykyta hi Sesus ihumo tsimypokzitsiarẽta. Atakta ibaze tu nidyhyky. ");
INSERT INTO rkbNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Iwaze Simaõ Peduru tatsyhyrype ty pawyk niy, zinymyrykyta pe niy. — “Aty skaraba asukyrytsitsa bo paoktyhyryk” iwa Sesus pe tsimy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Iwaze zinymyrykyta hi Sesus bo okmymy niy. Akbyibatu ipe niy: — Aty skaraba asukyrytsitsa bo paoktyhyryk — niy. Sesus: ");
INSERT INTO rkbNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","— Estuba katuk tamihi ty tumy bo sok my tahi kasukyrytsitsa bo pikoktyhyryk atsatu tsakyhy ty ibo nyny my — niy. Iwaze atsikara ty okok niy. Zitsakze tumy bo sok niy. Iwaze atsikara tsakyhy ty Sudas Iskariotses bo nyny niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","29","Sudas atsikara tsakyhy ziokze Sesus ekze niparak. Satanas harere bo hyỹ niy. Iwatahi hyrikoso sapybara ituk mynapykyryknaha. Sesus ipe niy: — Aidytykta! Hawa tsimyzeka aidytykta — niy. Sudas zinymyrykynahatsa okyrysaro zikziperykyta. Iwaze wastuhu kytsa mytsaty ahabyitsa nikaranaha. — O mydisahawy bo ja — nikaranaha. Ustsa kytsa: — O sinamybyikitsa bo okyrysaro ty nyny my. Ana humo hi Sesus ipe niy: “Aidytykta”. — mytsaty ahabyitsa nikaranaha. Batu aty tohi Sesus harere bo siwabyhy. Sihyrinymyrybyitsa tu Sudas niparak. Amy humo nitsaso — Aidytykta! Hawa tsimyzeka aidytykta — niy. Anahi nitsasoze zinymyrykynahatsa batu sihyrinymyry. Iharere sihumo tsihokdaharẽna. ");
INSERT INTO rkbNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Sudas atsikara tsakyhy ziokare eze zoihik. Zunubaze niparak. ");
INSERT INTO rkbNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Iwaze Sudas niparakze Sesus ispe niy: — Utakta ikzumuta maku babata ahawata ikyzik. Abahi mohyrikosokda. Aba kazo piwatawyky “Ikia azikwyrẽnikita tu tsamypokzitsiukrẽta tsamysapyrẽta awa suknihabyita” mykara. Kytsa sizubarẽtsa kahyrikosokzawy humo Deus bo mosakibazikiknaha. “O Deus azikwyrẽnikita tu tsimypokzitsiukrẽta. Tsamysapyrẽta” mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Mytsasokoze “O Deus azikwyrẽnikita tu tsimypokzitsiukrẽta tsimysapyrẽta”. Deus kino niwatihi kasoho motsasoko “Katse zikwyrẽnikita tu tsimypokzitsiukrẽta tsimysapyrẽta”. Abahi iwa piwatawyky — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","— O kahyrytsa watsa bykyhyze ahatuk zikurubyita tu. Abahi tsikpikberinahaze ba zik zikahanaha. Hana bo my ikahatsa kapik ba zik zikahanaha tsimaha. Iwa botu Sudeutsa bo iktsaso. Atsatu ahabo motsasoko — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Puẽtsik pahahyrinymyryky — Nawa ahahumo kamypokzitsiarẽta ikiahatsa niwatihiktsa. Pahasapywyky ziknakara. Ikiahatsa niwatihiktsa. Ustsa bo tsisapywykynaha tyharape pokzitsikinahaktsa! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","— Tsinaharape pokzitsikinaha zeka kytsa tihi: “O Sesus tyryktsa” mykaranaha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Iwaze Simaõ Peduru ipe niy: — Hana bo sa ikia tsimykuru — niy. — Aba hana bo my ikiakta ba kapik zikykta. Ikiakta pyktohitykta kapik tynao — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Peduru Sesus pe niyzo: — Hawata sa uta batu apik my. Abaka ikia apik my. Hawa ikia apik batu yhỹ tsimykara. Uta kino atuk tu apokzi mohyrikosokda — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","— Paze! kapokzi tsimyhyrikosokda ja niy. Kaharere bo mytsatytykta! Kokuaro ipobyize harakykbyi “Batu Sesus kanyhy” mybarapetu tsimykara — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Sesus tuk zinymyrykynahatsa pe niy. — O mytsaty mytsaty byijataha. Ahasukatsihikbyihu ja tynakaranaha! Ikiahatsa Deus humo ahaspirikporẽtsa. Kahumo kino niwatihi ahaspirikporẽtsaktsa kytsa! ");
INSERT INTO rkbNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Wahoro zuba kazo baze my. Ikiahatsa tsyhyryze wahoro tsizubarẽna. Wahoro ahabyizeka ikiahatsa bo ba ziktsaso. Abaka ahatsyhyryze pahawanusapy. Ba ahabyizeka ahape ziky. ");
INSERT INTO rkbNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Aba piksi. Ahawanu sapy pikymy zeka ahabo myziksizo. Pahaoktyhyryk. Iwaze katuk tsinapykyryknaha. Ahawahi katuk tsinapykyryknaha. Katuk tu tsipahasapynaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ske tsinybanaha. Hana bo mokuru naha bo hi tsinymyrykynaha hỹ — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tome: — Hana bo sa tsimykara katsaktsa batu myhyrinymyry. Asapy sa haneze katsaktsa batu myhyrinymyry. Iwatsahi hawa sa nabo tsimykurunaha ana humo hi batu myhyrinymyry hỹ — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Sesus ispe niy: — Uta hiba ahaske wata buruk kazo sapy bo pahaoktyhyryk. Utakta Deus harere baba ty pahahyrinymyryky kahumo zuba meky watu tsimoziknaha. Ahamysapyrẽtsa kahumo tsimoziknaha. Ikiahatsa kahumo zuba Deus bo tsipomonaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Abaka ikiahatsa botu tsiknynaha hỹ iwatsahi kazo kino niwatihi tsinynaha. Hawa ikykara naha bo iktsa tsikykaranaha zeka anawa hi kazo mykara ahahyrinymyrẽtsa hỹ — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Piripi Sesus pe niy: — Azo ty mybo tsiwatawykta! Azo bo iktsa tsimaha zeka mykurẽtsa tsimaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","— O Piripi tubabatu ahatuk ziknapykyryk. Iwatatu sa batu katyny. Ahatuk tu ziknapykyrykta tu batu katyny niy. Aty pikny zeka ata kino niwatihi kazo ziny. Iwatahi amo humo sa tsimytsasoko. “Azo ty mybo tsiwatawykta! tsimy” — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","— Uta kazo wata anatyhi yhỹ tsimaha katsa harapewatsa tu. Batu kaharere zuba ahawabyhy. Kazo harere kino ahabo motsasoko. Hawa kazo nitsasoko naha hi motsasoko. ");
INSERT INTO rkbNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Uta kazo wata. Harapewatsatu tsimaha. Kaharere bo tsikaeni zuba yhỹ tsimaha zeka iwaze kazikwy humo tsimyspirikpotohinaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","— O wabyziutahaktsa kytsa. Katuktsa kahumo sispirikporẽtsa kawa tu sisopyk. Uta kazo bo piksize izikwy piwatawy. Hawa kytsa bo kazikwy humo iwatawy katuktsa kino niwatihi kazikwy humo kytsa bo piwatawynaha. Kazo bo piksize iwatsahi katuktsa kazikwy tsizubarẽna kytsa bo piwatawykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Kabo tsinapamykysokonaha zeka “Hawa ha ty tsimyzehikiknaha ana hi tsinazapykykynaha” tsimykaranaha. Iwaze hawa ha tsinazapykykynaha anatyhi ahabo nyny mynakara. Kytsa tihi: “O Deus amysapyrẽnikita” mykaranaha. Hawa ha ty tsikzapykykynaha ty ahabo nyny myze kytsa Deus soho “imysapyrẽnikita” — mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ikiahatsa kabo tsimypamykysokonaha zeka: — Hawa ha tsimyzehikiknaha ty zuba tsimykaranaha. Iwaze anahi tsimyzapykykynaha atsatu ahabo nyny mynakara. Tsizubarẽna ty ahabo nyny mynakara — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Sesus tihi: — Ikiahatsa kahumo ahamypokzitsi zeka kaharere bo hyỹ tsinakaranaha — my. ");
INSERT INTO rkbNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Kazo pe my zeka: — O kazo usta tsumuẽhĩtsa katuktsa bo myzipeha. Usta tsumuẽhĩtsa kawata tyzipehakta my. Iwaze ihyrikoso myzipeha. Pahahyrinymyry, tawahi ahatuk mynapykyryk. ");
INSERT INTO rkbNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Kytsa kahumo batu sispirikpo asahi iharere bo batu yhỹ zikaha. Iharere sihumo tsihokdaharẽna. Iharere humo ka batu sihyrinymyry. Ikiahatsaktsa tsahyrinymyrẽtsa. Iharere kino ikiahatsa humo batu ihokzaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","— Bakta kawahi paharekta ziwazy. Ahabo myziksizo. ");
INSERT INTO rkbNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Aba nurũbabatu kytsa kahumo sispirikpobyitsa ba ziknyzonaha. Ikiahatsa iwatsa tu tsipiknyzonaha. Ikiahatsa niwatihi tsimynahyrizikponaha. Iknahyrizikpo naha humo ahamysapyrẽtsa tsimoziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Uta kazo harere bo hyỹ mynakara. Ikiahatsa kaharere bo hyỹ tsinakaranaha. Uta kino niwatihi ikiahatsa tuk yhỹ mykara. Iwa mysopyk tsimykaranaha. Bykyze ana hi tsipinymyrykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Aty kaharere bo hyỹ my zeka atahi kahumo tsimypokzitsiarẽta mykara. Atahi kazo mozipokzitsiki. Uta niwatihi mozipokzitsiki. Kasoho humo pinymyryky. Kasoho humo tsihyrinymyryrẽta mozik — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Sudas Tadeu tihi: — Hawa skaraba mybo zuba asoho tsipiwatawyky Asaktsa ahumo sispirikpo ahabyizeka asoho batu tsipiwatawy. Hawa tsimy — niy. Iwa Sudas nitsaso. Atakta batu Sudas Iskariotses. Usta Sudas Tadeu inarokota. ");
INSERT INTO rkbNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Sesus nitsasokozo: — Asaktsa kahumo simypokzitsirẽtsa kaharere bo hyỹ mykaranaha. Kazo sihumo tsimypokzitsiukrẽta, iwatahi situk mynapykyryk. Kazo situk mynapykyryk. Uta niwatihi katsa situk mywahi tsinapykyryknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Sispirikpobyitsaktsa kaharere bo batu yhỹ zikaha. Kaharere kazo botu nitsasoko ana kino tsipiwabynaha. Kazo zikpeha iharere hi motsasoko. ");
INSERT INTO rkbNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ikiahatsa tuk tihi motsasoko. ");
INSERT INTO rkbNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Kyze kazo hyrikoso ahabo pipehahik. Kaharere humo tahyrikoso ahabo myzipeha. Atahi ahatsumuẽhĩtsa mozik. Pahahyrinymyry. Uta ahahyrinymyryky ana humo hi batu ahaspiriktsokdahu. Kaharere ty pahaspirikpoziuku. Deus hyrikoso tsimysapyrẽta hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Kytsa kahumo batu sispirikpo paikpa mytsaty mykaranaha. Katuktsa batu sispirikpobyitsa watsa. Utakta batu paikpa mytsaty mykara. Iwatahi ikiahatsa kawata mytsaty mytsaty byitaha. Ahakurẽtsa tsimaha. Kahumo ahapyby byihu ja. Kahumo ka ahasukatsihik byihuja. Kahumo tyspirikpokonahaktsa iwatsahi tsahapunihikrẽtsa tsimoziknaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Botu tsiwabykynaha: — Utakta piksi. Bykyze myziksizoze ahatuk mynapykyryk. Anahi motsasokoze tsiwabykynaha. Uta kazo bo. Kaharere bo ma tahaktsa. Kazokta abazubata my. Iwatsahi ahakurẽtsa tsimahaktsa kytsa! Kazo humo ahamypokzitsirẽtsa. Tsipikpokzitsikinaha zeka ahakurẽtsa tsimoziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Aba motsasoko kyze piksi. “Piksi zeka kahumo ahaspirikporẽtsa” — mytsaty mykara. — Aba piksi hawa ahabo iktsasoko, ana humo hi ahaspirikporẽtsa. ");
INSERT INTO rkbNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Aba Satanas harere humo kytsa kahumo batu sispirikpo ispehatsa atahi kabo mozumu. Iwatahi ahabo tsikaeni zuba motsaso. Atahi batu kakzotsabyita. Iharere bo yhỹhabyita ziknakara — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","— Uta kazo harere bo zuba hyỹ mynakara. Kazo humo kamypokzitsiarẽta mykara. Iwatahi iharere bo zuba hyỹ mykara. Kytsa kahumo batu sispirikpo asa bo hi piwatawyky. Utakta Deus harere bo zuba hyỹ mynakara anabo hi mysiwatawyky — niy. — Kyikyitahaktsa. Tupaktsa kytsa! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Kyze Sesus: — Uta hi duaboho taypykze mytahara tawata my. Kazo waratok tsihitsa wata my. Waratok eze duabohozatsa nisiparikik. ");
INSERT INTO rkbNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Katukytsa duabohotsa sakatsa watsa maha. Asahi kazo harere bo batu zikahabyitsa sisakatsa watsa, asaktsa ziktaharanaha ahabyizeka tahasazyzykykwynaha. Ustsaktsa siharahoktsa tsihitsa duaboho taypykze sisupesapy mysisakakare zeka iwatsahi nataharasukbabyinaha. Iwa kazo tihi mykara. Katuktsa iharere bo batu yhỹ mysisakakareke tawata. Kazo katuktsa situk mynapamykysoko iwatsahi simysapybyitsa nikaranaha pimoewynaha iwa mysitsumuẽhĩkĩ. Hawa sibo mykara wasani my ana humo hi simysapyrẽtsa tohi mykaranaha hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kazo ahamysapybyitsa tsikykaranaha botu zahaokzohik. Kaharere bo hyỹ tsimykaranaha zeka ahamysapybara ty botu zahaokzohik. ");
INSERT INTO rkbNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Kaharere bo hyỹ tynakaranahaktsa kytsa! Kaharere bo hyỹ tsimaha zeka uta ahatuk mynapykyryk. Atsa botu mytsaty tsimykaranaha. Mykurẽtsa tsimoziknaha. Duabohotsa sa ypyk ahabyizeka ba ziktaharanaha. Ikiahatsa niwatihi. Kaharere bo yhỹ ahabyi zeka kazo tuk kino niwatihi batu yhỹ tsimaha. Hawa kazo mozihikik batu ahahyrinymyry — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","— Uta duabohotsa sa taypyknahaze mytaharanahaze tawata. Ikiahatsa duabohotsa sa watsa tsimaha. Kaharere bo hyỹ tsimaha zeka Deus okzeka ahamysapyrẽtsa tsimaha. Uta kino niwatihi ahatuk yhỹ mykara. Katsa mykurẽtsa hi. Ikiahatsa kaharere bo batu yhỹ ahabyizeka hawa tsimaha Deus okzeka batu ahamysapy. Hawa tsimaha Deus okzeka mahani tsimaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","— Asaktsa kaharere bo yhỹ ahabyi zeka sipaparahatsa watsa. Waratok tsihitsa siharabyitsa nisizyzykyk izo bo nisiwezohik. Mynaparanahaze izo bo piwezonaha. Ikiahatsa niwatihi katuk tsimynapykyryknaha ahabyizeka ahakubyitsa tsimaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Iwatsahi kaharere bo hyỹ tynakaranahaktsa katuk tsimykaranaha, katuk tsinapykyryknaha zeka amy ty Deus bo tsinazapykykynaha atsatu ahabo nyny my. ");
INSERT INTO rkbNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ikiahatsa kazo harere bo hyỹ tsimykaranaha zeka kytsa kazo pe maha: — O ikia tsamysapyrẽta — mykaranaha. Iharere humo hyỹ tsimykaranaha zeka kytsa ahasoho motsasokonaha: — O asahi Sesus tuktsa maha — mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","— Uta ikiahatsa humo kamypokzitsiarẽta. Kazo wata atahi kahumo tsimypokzitsiukrẽta my. Ahakuhuktsa kytsa! Sesus myhumo tsimypokzitsiukrẽta. Iwatsahi ahakurẽtsa. ");
INSERT INTO rkbNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kazo harere bo hyỹ mynakara. Iwatahi kazo kahumo tsimypokzitsiukrẽta. Iwaha bo hi mytsaty mykara zeka kakurẽta hi. Ikiahatsa kino niwatihi kaharere bo hyỹ tsimykaranaha zeka ahakurẽtsa tsimoziknaha. Sesus katsa myhumo tsimypokzitsiukrẽta. Iwaha bo hi mytsaty tsimykaranaha zeka ahakurẽtsa tsimoziknaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","— Iwa motsasoko iwaze kahumo ahakurẽtsa tsimoziknaha. Uta kakurẽta hỹ. Ikiahatsa tsikaeni zuba ahaku zeka batu myzehikik. Ikiahatsa ahakurẽtsa babatsa tsimoziknaha zeka iwa hi myzehikik. Kawatsa tsimaha. Kakurẽta hi — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ahape mykara: — Tynaharape pokzitsikinaha! Ahakyri byihuja. Uta pahapokzitsiki ikiahatsa kawa tihi tynakaranahaktsa. ");
INSERT INTO rkbNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Aty tatuktsa pokzi mohyrikosokda zeka kytsa mykaranaha: “O atakta itukta humo tsimypokzitsiarẽta”. Myhyrikosokdaze iwa itukta humo tsimypokzitsiukrẽta hiba — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","— Ikiahatsa kaharere bo hyỹ tsimykaranaha zeka ikiahatsa katuktsa babatsa — my. ");
INSERT INTO rkbNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ahasoho ty batu tyso — O asahi katsumuẽhĩtsitsa mykaranaha. Hawa tsihitsa mykara tatsumuẽhĩtsitsa bo batu tyso. Ahahumo meky watu kasopyk. Ikiahatsa kaharereziuwytsa tsimoziknaha. Nawa kazo kabo nitsasoko atsatu ahabo motsasoko. Iharere ahabo botu iktsasoba. ");
INSERT INTO rkbNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ikiahatsa humo ka batu kawatawyhy “O katsaktsa atuktsa tsimoziknaha” tsikaha. — Iwa batu tyso. Uta hi ahawatawyhik. — Asahi katuktsa moziknaha — iky. Iwa motsasoko. — Ustsa bo pahapehahik iwatsahi kahumo sispirikporẽtsa ahaharere humo. Asahi kahumo sispirikporẽtsa hi. Amy ty Deus kazo bo tsinazapykykynaha zeka kaharere humo iwatsa tu ahabo nyny my. ");
INSERT INTO rkbNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ahatuk napykyknahaze tynaharape pokzitsikinaha — iwa mykarazo. ");
INSERT INTO rkbNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Sesus nipamykysokozo: — Kytsa kaharere bo yhỹ ahabyi zeka asahi kahumo tahakyrikinaha iwatsahi ahabo kino niwatihi batu siakparawy. Pahamyijakanaha. Pahasukyrykynaha. Taparaka batu kahumo siakparawy ana bo hi mytsatyziutahaktsa kytsa — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ikiahatsa mekywatsa tu tsimoziknaha. Asahi Deus humo batu siakparawy siwatsa batu tsimykaranaha. Uta hiba ahawatawyhik katyryktsa tsimoziknaha iwatsahi kytsa ahahumo batu simypokzitsiu. Iwatsahi tahakyrikinaha. Pahamyijakanaha. Pahasukyrykynaha. Ikiahatsa siwatsa tsimyzurukunaha zeka ahahumo siakparawy. ");
INSERT INTO rkbNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Kaharere bo wabyziutaha! Ahatuk tu ka tysosobyijataha: — O kapehatsa zisukyrykynaha. Katsaktsa batu. Batu myty myija — mytsaty ahabyitsa tsimykaranaha. — Kytsa kahumo batu sispirikpo zikapikiknaha. Iwatsahi aha humo kino niwatihi pahapikiknaha. Kaharere bo ma ahabyitsa ziknakaranaha ahaharere bo niwatihi batu ma zikaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","— Kapokzi ikiahatsa sinini tsimykaranaha. Kytsa kaharere bo yhỹ ahabyizeka pahasukyrykynaha. Deus zipehata humo batu sispirikpo iwatsahi pahasukyrykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Uta sibo zuk ahabyi zeka Deus okzeka wasani mykaranaha tsawatsa. Deus harere ty sibo tyso ahabyizeka Deus okzeka wasani mykaranaha tsawatsa. Uta ikzumutawy. Kaharere bo batu yhỹ mykaranaha iwatsahi Deus okzeka batu simysapy mykaranaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","— Kytsa kahumo batu siakparawy. Kahumo tahakyrikinaha kazo humo kino niwatihi tahakyrikinaha. Asahi ihumo tahakyrikinaha iwatsahi batu siakparawy. ");
INSERT INTO rkbNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Kazikwy tsizubarẽna bo iwatawyky. Ustsa zikwy tsikaeni zuba. Utakta kazikwy tsizubarẽna. Batu aty tohi zikwykyta. Kazikwy ty tyny ahabyizeka wasani mykaranaha. Kazikwy zinynaha. Zinynahatsa tu kahumo batu sispirikpo. Iwatsahi Deus okzeka batu simysapy mykaranaha. Batu wasani mykaranaha kazo batu siakparawy. Uta kahumo kino niwatihi batu siakparawy mykaranaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Deus papeu humo sisoho botu ziwatahaka: — Batu isty myi. Batu aty tohi humo ykyrisukni. Iwatsa tu kahumo ziknatakyrikinaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Kazo bo piksizoze ipe my: — O kazo ahyrikoso tsipehahikta. Katuktsa bo tsipeha — my. — Iwaze ikiahatsa bo pipeha. Atahi pahatsumuẽhĩkĩ. Hawa wasani atsatu pahahyrinymyryky. Kasoho ty pahahyrinymyryky. ");
INSERT INTO rkbNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ikiahatsa kino niwatihi. Kasoho humo kytsa tysihyrinymyrykynaha. Ikiahatsa katuk tapara tu tsikapykyryknaha. Iwatsahi kasoho humo kytsa ty tysihyrinymyrykynaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Sesus: — Kyze iwa ahabo tsizubarẽna iktsasoko. Bykyze kytsa ahape mykaranaha: “O Sesus harere bo batu yhỹ tsimaha! Ihumo niwazuba tsimahaktsa!” mykaranaha. Iwaze kaharere bo mytsaty tykaranahaktsa. Iwatahi tsizubarẽna ahabo motsasoko. ");
INSERT INTO rkbNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Kytsa ahahumo tahakyrikinaha. Asahi ahape: “Sudeutsa wahoro bo ba zikpupuzonaha” mykaranaha. Pahaba tsihikiknaha. Pahabanahaze iwa mytsaty mykaranaha. “O Deus okzeka wasani tsimykaranaha” mybarapetu mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Zahasukyrykynahaze kazo humo batu sispirikpo. Kahumo niwatihi batu sispirikpo iwatsahi pahasukyrykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Iwatahi ahabo motsaso. Aibani kaharere bo mytsaty tsimykaranaha. Pahasukyrykynaha zeka ahatuk zuba tsimypamykysokonaha “O tapara mypehatsa iksibyize mybo botu nitsaso. Kytsa mymysukyrykynaha anahi botu nitsaso tsimaha” — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Sesus nitsasokoze: — Abaka zikpehata bo piksizo. Batu aty tohi kape ziky hana bo sa tsimy. Iwa batu tyso. ");
INSERT INTO rkbNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Piksizo zeka ana humo hi ahasukatsihikrẽtsa. Iwa motsasoko ahasukatsihikrẽtsa. ");
INSERT INTO rkbNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Hawa tisapyrẽna motsasoko. Erete ahabyizeka Deus hyrikoso ba ziknasik. Ahatsumuẽhĩtsa ba zikzumu. Piksi zeka ahabo myzipeha. Iwatsahi ahakurẽtsaktsa kytsa. Kazo bo piksizo ana humo hi ahakurẽtsa tsimoziknaha — niy. Atsatu tsinakaranaha. Iwatahi taparaka ahape ziknakara. ");
INSERT INTO rkbNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Myzumuze kytsa kaharere humo batu sispirikpo atahi ispe my: — Kytsa kahumo batu sispirikpo Deus okze batu simysapy mykaranaha. Deus zuba kytsa humo nasisapywyky. Ihumo zuba simysapyrẽtsa moziknaha. Kytsa simysopyksapybyitsa nikaranaha humo pisininiwyky iwa Deus hyrikoso mynasikze motsaso. ");
INSERT INTO rkbNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Kytsa kahumo batu sispirikpo iwatsahi Deus okze batu simysapy mykaranaha ziknaharapesapybyrikinaha. Kahumo batu sispirikpo iwatsahi simysapybyitsa mykaranaha. Kaharere bo batu yhỹ zikaha iwatsahi ziknaharape sapybyrikinaha batu simysapy mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Kazo bo piksizoze ba ziknywyzo. Jobo kazo bo myzo ba ziknywyzo. Deus hyrikoso kytsa pe: “Sesus tisopyksapyrẽta wasani isopyk” — mykara. ");
INSERT INTO rkbNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Deus botu nitsaso. Taparakta kytsa Sesus harere bo batu yhỹ niy Satanas inarokota sininiwy mykara. Iwatahi Deus hyrikoso kytsa pe simysapybyitsa nikaranaha asahi Deus mysisininiwyky. ");
INSERT INTO rkbNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ahabo motsaso tsihikik tsizubarẽna my. Abaka ba ziktsasozo. Ahasukatsihikrẽtsa iwatahi ahabo ba ziktsaso. ");
INSERT INTO rkbNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Hawa wasani Deus hyrikoso pahahyrinymyryky. Myzumuze hawa wasani motsasoko. Taharere ka ba ziktsaso. Tapara botu ziwaby ana kino ahabo motsasoko. Hawa aiba tohi mykara ana humo kino pahahyrinymyryky. ");
INSERT INTO rkbNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Pahahyrinymyryze Sesus tisopyksapyrẽta wasani mykara iwa kytsa ihumo motsasokonaha. Wasaniha ty zuba ahabo motsasoko. ");
INSERT INTO rkbNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Kazo mykara naha ty uta kino niwatihi mynakara. — Deus hyrikoso harere ahabo motsasoko — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Sesus nitsasokozo: — Abanurybabatu piksi, kabo ba ziknynaha. Aiba zuba kabo tsipiknyzonaha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Zinymyrykynahatsa asa zuba nikaranaha: — Hawa skaraba mykara. “Abanurybabatu piksi. Kyze kabo ba ziknynaha. Utakta kazo bo my niy.” Hawaha skaraba mybo nitsasoko. Iharere tsihokdaharẽna. ");
INSERT INTO rkbNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Amy humo “aiba zuba tsipiknyzonaha”. Iharere myhumo tsihokdaharẽna — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Sesus amo zinymyrykynahatsa mytsaty nikaranaha ana humo kino tsihyrinymyrẽta. Iwaze ispe niy: — Ahabo motsasokozoze “abanurybabatu piksi. Kabo ba ziknyzonaha. Aiba zuba kabo tsipiknyzonaha hỹ”. Ana hi ja tsimytsasokonaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ikiahatsa bo motsasoziuku: — Mohyrikosokdaze tsimopuziukunaha. Kytsa kahumo batu sispihik asahi batu sisukatsihik ikiahatsa zuba ahasukatsihikrẽtsa tsimoziknaha. Iwaze puẽtsik zuba ikiahatsa tsimysukatsihikbyrinaha. Tsahakurẽtsa tsimoziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Wytyk ibykyhy natapyrize tisukatsihikrẽtatsa. Itsapyri humo tisukatsihikrẽtatsa. Ibykyhy mopurukze myitsapyripykze tsakurẽtatsa. Iwatatsahi tabykyhy humo tsakurẽtatsa iwatatsahi itsapyri humo nispiriktsokda. ");
INSERT INTO rkbNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ikiahatsa atatsa watsa tsimaha. Abaka ahasukatsihikrẽtsa. Utakta piksiki ana humo hi ahasukatsihikrẽtsa. Aiba ahabo myzumuze, ahakurẽtsa tsimozikzonaha. Batu aty tohi isukatsihik. Ahawahi ahakurẽtsa tsimoziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Deus hyrikoso mozumuze pahahyrinymyryky. Iwatsahi kabo batu tyso “katsa mymyhyrinymyry”. Kaharere ba zikokza my. Deus hyrikoso kaharere pahahyrinymyry. Wabyziutaha! Amy ty Deus bo tsimyzapykykynaha zeka kaharere humo, ana ty hi ahabo nyny my. Deus bo tsimyzapykykynaha zeka kaharere humo wasani my ana humo hi ahabo nyny my. ");
INSERT INTO rkbNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Deus bo batu tysapykyk kaharere humo yhỹ tsimaha my. Tyzapykynahaktsa! Hawa ha ty Deus myzehikik ana hi tsimyzapykykynahaze ana ty hi ahabo nyny my. Kazo ahabo nyny my zeka ahakurẽtsa tsimoziknaha. Ahakurẽtsa hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","— Taparaka kaharere tsihokdaharẽna. Iktsasokoze kaharere tsihokdaharẽna. Kaharere iokpitsĩhĩ hawa ziknaukuru. Aibani zuba kazo harere ahabo motsasoze, mahani ihokdaha. Kazo harere motsasokoze batu ihokdaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Mytsasokoze iokpitsĩhibara wa mozik. Kazo bo hawa kaharere bo yhỹ my ana hi tsimyzapykykynaha. Utakta kazo bo batu ahatsyhyryze ba zikzapyky ikiahatsa tu kazo bo tsimyzapykykynaha hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ikiahatsa hi tsimyzapykykynaha. Kazo ahaharere piwaby hỹ. Ikiahatsa humo tsimypokzitsiukrẽta iwatahi pahawaby. Ikiahatsa kahumo ahamypokzitsirẽtsa iwatahi kazo ahahumo tsimypokzitsiukrẽta my. Tsimytsasokonaha zeka “O Deus Sesus tsikzipeha tisapyrẽna” tsimaha. Iwatahi ahahumo tsimypokzitsiukrẽta. ");
INSERT INTO rkbNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Kazo ikny ikzumu. Mybarawy bo iknasik. Mybarawy ezektsa bo ikzumu. Mohyrikosokdaze kazo bo piksizo — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Zinymyrykynahatsa ipe niaha: — Abaka tsiwabyziukunaha. Aharere mahani ihokdaha. Abaka ipitsĩhibara ty tsimytsasoko. ");
INSERT INTO rkbNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ikiahi tsihyrinymyrẽta. Tsizubarẽna humo tsahyrinymyrẽta hỹ. Amy bo mytsaty tsimykaranahaze anahumo hi tsahyrinymyrẽta. Iwatsahi “Hawa tsimykara” batu tyso, amy ty tsinymyrykynaha ana hi mybo tsimytsasoko. Iwatsahi “Deus zipehata babata tsimy” — tsimytsasokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","— Abaka ja kahumo ahaspirikporẽtsa — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","— Aba nanabyitaba tsimopaparahanaha. Kasukyrytsitsa pokso paikpa mytsaty tsimykaranaha. Ahapybyrẽtsa. Kytsa pahabezenaha pokso iwatsahi tsimywakbaiknaha. Ahapybyrẽtsa hỹ. Uta zuba motare. Tsipikarekbanaha zeka uta zuba motare. Iwaze kazo zuba katuk. Kazo zuba ba zikare — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","— Iwa motsasoko iwatsahi mytsaty mytsaty byitahaktsa kytsa kahumo ahaspirikporẽtsa. Kytsa kahumo batu sispirikpo asahi pahasukyrykynaha. Utakta sispirikpobyitsa pehatsa zikwy pepykbaik. Iwatsahi ahapunihikrẽtsa tsimoziknaha — Sesus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Kyze Sesus bijoikpe bo iktsa niy, tazo bo nipamykysoko: — O kazo utakta atse babata my. Nawa ty botu tsiktsasoko kasoho ana hi myzubaha bo iky uta kamysapyrẽnikita kapunihikrẽnikita tsiky ana hi tsiwatawyky. Uta kino niwatihi my. Myzubaha bo iky “O Deus kazo imysapyrẽnikita ipunihikrẽnikita iwa iksiwatawy”. ");
INSERT INTO rkbNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","— O Deus azikwy ty botu kabo nyny tsiky iwatsahi kytsa kahumo sispirikporẽtsa. Iwatsahi kytsa meky watu moziknaha. Kahumo simysapyrẽtsa moziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ikia zuba Deus babata. Utakta atse babata. Ikia tsikpeha. Mybarawy bo tsikpeha. Utakta Sesus Kiristu, mybarawy bo iknasik. Kytsa kaharere bo hyỹ mahaze simysapyrẽtsa moziknaha. Kytsa ahumo mospirikponahaze simysapyrẽtsa moziknaha. Myhumo sispirikporẽtsa. Myhumo simysapyrẽtsa moziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ikia aharere botu kabo tsiktsaso, ana kino myzubaha bo iktsasoko. “Deus imysapyrẽnikita ipunihikrẽnikita” ana kino myzubaha bo iktsasoko. Abaka kahyriziktsokzawy nepykba. ");
INSERT INTO rkbNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","— O kazo tapara ikia tukze bijoikpe iknyktsa atsumuẽhĩtsitsa kasoho ziknatsasokonaha: “O Sesus imysapyrẽnikita ipunihikrẽnikita” ziknakaranaha. Tapara ikia bijoikpe mybarawy aha tsikzukni bijoikpe iknyktsitsa atsumuẽhĩtsitsa kasoho humo. “O atakta imysapyrẽnikita” ziknakaranaha. Abaka abo piksizoze iwa motsasozonaha hỹ — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Iwaze zinymyrynahatsa tsyhyryze tazo bo nipamykysoko: — O kazo ikia wastuhu kytsa tsiksiakzoko. Asahi atyryktsa niyzikiknaha. Ikia kytsa tsiksiakzohikze iwaze ikia humo katyryktsa niyzikiknaha. Azikwy sibo iwatawyky. Aharere bo hyỹ mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Sihyrinymyryrẽtsa mykaranaha. Hawa ha iktsasoko aharere zuba my, ana humo kino sihyrinymyryrẽtsa mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Hawa ha ty botu kabo tsiktsasoko kytsa kahumo sispirikporẽtsa atsatu iktsasoko. Aharere humo wasani mykaranaha. Ikia tsikpeha ana hi zinymyrykynaha. Ikia tsikpeha ana humo hi wasape mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","— O kazo kakzohotsa tsyhyryze abo mopamykysoko. Ustsa kytsa kahumo batu sispirikpo batu tyso. Asahi katyryktsabyitsa tu. Kakzohotsa iksihyrinymyryky sitsyhyryze zuba abo mopamykysoko. ");
INSERT INTO rkbNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Kytsa kahumo sispirikporẽtsa atyryktsa moziknaha. Iwatsahi katyryktsa kino niwatihi moziknaha. Mytyryktsa moziknaha — Sesus niy. — Kaharere humo simysapyrẽtsa niyziknaha. Iwatsahi ustsa kytsa kahumo sispirikpobyitsa pe maha: “O atakta imysapyrẽnikita ipunihikrẽnikita my ityryktsa simysapyrẽtsa humo maha” mykaranaha. Iwa motsasokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","— O kazo ikia zuba wasani tsinakara. Azikwy ty botu kabo nyny tsiky. Iwatahi azikwy hi kazikwy mozik. Abaka abo piksizo. Mybarawy eze ka ba mynapykyryk. Ikia bozo my. Katuktsa mybarawy eze mynapykyryknaha tysipokzitsiki. O kazo tysipokzitsikikta. Uta atukze atsabotu mytsaty tsimykaranaha abaka asa kino niwatihi atsa botu mytsaty mykaranaha kazo — my. ");
INSERT INTO rkbNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","— Uta situk ziknakaraze kytsa kaharere bo hyỹ ziknakaranaha. Uta ziknasipokzitsiki iwatsahi kahumo sispirikporẽtsa. Myzubaha abo mysioktyhyryk. Estuba zuba katuk ba ziokty atakta batu isopyksapy. Atakta batu imysapy nikara iwatahi ba ziokty. Botu apapeu humo ziwatahaka niy. Nawa batu isopyksapy nikara, botu papeu humo ziwatahaka atsatu nikara. ");
INSERT INTO rkbNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Abatu abo piksizo. Zinymyrykynahatsa situk abo mynapamykysoko. Kaharere humo sakurẽtsa moziknaha. Uta kakurẽta asa kino niwatihi kawatsa sakurẽtsa moziknaha. Sakurẽtsa babatsa mysitsihikik! ");
INSERT INTO rkbNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Aharere botu sibo iktsasoko. Kasopyk humo sispirikpobyitsa meky watu sisopyk. Katuktsa niwatihi. Asahi sispirikpobyitsa sopyk humo meky watu mykaranaha. Iwatsahi sispirikpobyitsa katuktsa humo tahakyrikinaha. Mekywatsa humo sispirikpobyitsa tahakyrikinaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","— O kazo “katuktsa mybarawy ekze ka ba ziksiokty” Katuktsa mybarawy ezektsa humo tysipokzitsikikta kazo! Hyrikoso sapybara pehatsa Satanas inarokota katuktsa ipokso sipybyrẽtsa iwatahi tysipokzitsikikta, katuktsa ikia hi tysipokzitsiki. ");
INSERT INTO rkbNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Kasopyk humo ka batu sispirikpobyitsa watsa. Katuktsa kino niwatihi. Nawa katuktsa sopyk humo batu sispirikpobyitsa watsa maha. Mekywatu mykaranaha. Kahumo simysapyrẽtsa moziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Aharerebaba wasani my. Aharere tisapyrẽna. Aharere piwabykynahaze ahumo hyỹ mykaranaha. Ikia harere bo zuba hyỹ mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ikia tsikpeha mybarawy ezektsa bo tsiky. Tsikzipehaze mybarawy ezektsa iksihyrinymyryky iwatahi zikpeha. Uta kino niwatihi, katuktsa zinymyrykynahatsa mysipeha. Ustsa bo mysipeha. Iwaze mysihyrinymyrynaha. Aharere baba myzubaha bo mysihyrinymyrynaha iwatahi mysipehaka. ");
INSERT INTO rkbNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Abaka katuktsa sapyzeky mohyrikosokda. Kytsa pikbezenaha zeka yhỹ my. Katuktsa pokzi yhỹ my. Mohyrikosokdaze abo hyỹ maha niwatihi. Mohyrikosokda humo katuktsa kino niwatihi aharere bo hyỹ mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Zinymyrykynahatsa soho abo motsasoko. Abaka ustsa kytsa zinymyrykynahatsa harere piwabykynahaze kahumo sispirikporẽtsa, sitsyhyryze abo niwatihi mopamykysoko. ");
INSERT INTO rkbNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","O kazo tsimysitsumuẽhĩze sakurẽtsa moziknaha mytsaty mytsaty byijataha iwatsahi atsa botu mytsaty mykaranaha. Mywatsa sisopyk. Mywatsa sisopyk zeka sispirikpobyitsa tihi: — Deus Sesus zipeha — mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Kazo tapara azikwy ty kabo nyny tsiky. Ikia wata uta kino kazikwy katuktsa bo nyny iky. Asahi kahumo sispirikporẽtsa iwaze kazikwy ty sibo nyny iky. Iwaze mywatsa moziknaha, asa zuba sakurẽtsa mykaranaha mywatsa kazo. ");
INSERT INTO rkbNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Utakta situk yhỹ my. Ikia katuk yhỹ tsimy. Iwatsahi sisopyk mywatsa mykaranaha. Mywatsa sisopyk zeka sispirikpobyitsa pe maha: — Deus kino Sesus zipeha — mykaranaha. Hawa Deus Sesus humo tsimypokzitsiarẽta. Deus Sesus tuktsa kino niwatihi tsimypokzitsiarẽta iwa motsasokonaha. Mywatsa sisopyk zeka iwa motsasokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","O kazo ikia nanabyri izuknihibyize ikia zikzipokzitsiki. Tapara mybarawy nizukni kape tsiky: — Kazikwy ty abo nyny my — tsiky. Abaka zinymyrykynahatsa kaharere piwabykynaha: — Kazikwy ty abo nyny my — tsimy. Iwa piwabykynaha mytukze mynapykyryknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","O kazo ikia zuba wasani tsimykara. Tisopyksapyrẽta amysapyrẽnikita iwatahi kamysapyrẽnikita tsimy. Kytsa sispirikpobyitsa tu ikia humo batu sihyrinymyry. Uta zuba any, zinymyrykynahatsa kasoho humo sihyrinymyrẽtsa. Ikia tsikpehahik tahi kahumo sihyrinymyrẽtsa. ");
INSERT INTO rkbNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Botu sibo iktsasoko: — Kazo ikia kahumo tsikpokzitsiki nawa tihi asa bo kino niwatihi tsimy. Asa zuba simypokzitsirẽtsa tyharape pokzitsikinaha. Iwa sisopyk. Katsa mywata ahasopyk uta situk kasopyk mytsaty mytsaty byijataha atsa botu mytsaty mykaranaha — Sesus niy. Iwa Sesus nipamykysoko tsizubarẽna tazo tuk zinymyrykynahatsa tsyhyryze nikara. Iwa. ");
INSERT INTO rkbNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Kyze Sesus tazo bo nipamykysobaze niparak. Zinymyrykynahatsa tuk itsipa tsibik Kederõ inarokota zitsikzakanaha. Ana hwitsa sazik ziparikiknaha ana bo zumukunaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ana hi zinymyrykynahatsa zinynaha. Ana bo hi Sesus zinymyrykynahatsa tuk pororo ziknakara. Sudas kino ziny. Isopyksapybyita isukyrytsitsa mysioktyhyryk. ");
INSERT INTO rkbNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Atakta Sesus bo niy. Kederõ tisaziksapyrẽna ibo niy. Sodadutsa, Deus wahoro perytsitsa kino niwatihi Sudas nisioktyhyryk. Taparaktsa Deus wahoro eze ziknapamykysokonahatsitsa, Pariseutsa niwatihi sodadutsa Sesus bo nisipehakanaha. Sudas isopyksapybyita iwatahi sodadutsa Deus wahoro perytsitsa kino niwatihi ibo nisioktyhyryk. Sodadutsa tahatanoratsa tahabototsa iwa inasibykyknaha. Rika izo tupyriri humo hopok nikaranaha niwatihi zibykyknaha. Sesus bo sizubarẽtsa izumukunaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Sesus hawa mykaranaha botu tsihyrinymyrẽta. Iwatahi kytsa nisihobykze ispe niy: — Aty sa tsipiberikinaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","— Sesus tsipiberikinaha. Nasare ezekta — nikaranaha. — Uta hiba Sesus — niy. Sudas imyspihikbatanikita sisukyrytsitsa tuk niriktohoko. ");
INSERT INTO rkbNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Nitsasokoze — Uta hiba Sesus — niyze sodadutsa. Iharere ziwabynahaze wytyk bo natsubaiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Iwaze Sesus ispezo niy. — Aty sa tsipiberikinaha — niy. — Sesus Nasare ezekta — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","— Batu kawabyhy botu iktsaso uta hiba Sesus — niy. — Tsipikberi tsihikiknaha zeka katuktsa ty ka paik paik byitaha iwaze piksinaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Iwa nitsasoko. Nawa botu nitsaso tazo bo: — Uta iksipokzitsiki asahi kahumo sispirikporẽtsa — niy. Iharere wasani atsatu nikara. Iwaze kytsa Sudas tuktsa tihi — O zinymyrykynahatsa ty ka paik paik byitaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Iwaze Simaõ Peduru tasokorotsapu tsizezerẽta zibokik. Ziknapamykysokota Deus wahoro zubata tsumuẽhĩtsa zispizykik. Ispipyryburuk niy. Marakos inarokota. ");
INSERT INTO rkbNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Iwaze Sesus Peduru pe niy: — Asokorotsapu ty ipesuk bo koroktykta! — niy. — Niwazubakta katy pokzitsi pokzitsi byity. Uta sinini mynakara. Tubabatu Deus papeu humo ziwatahaka iwa sinini mynakara. Iwa Deus kazo botu nitsaso iwa sinini mynakara — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Iwaze kytsa Sudas tuktsa Sesus tsipa humo zioktyhyryknaha. Sodadutsa pehatsaktsa Deus wahoro zubata perytsitsa sizubarẽtsa iwatsa itsipa humo zioktyhyryknaha. Zipawarakanaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Niahatsahi Anas taparakta bo zioktyhyryknaha. Anas Kajapas tsere niy. Kajapas Deus wahoro zubata eze ziknapamykysokonahatsa taparakta my. ");
INSERT INTO rkbNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Atakta botu nitsaso Sudeutsa pe niy. — Estuba zuba tsipibezenaha zeka wasani maha. Iwatsahi mytyryktsa ba zik mymybanaha estuba zubata tsipibezenaha zeka wasani my — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Kyze Simaõ Peduru Sesus hapik niukuru. Usta zinymyrykyta Peduru tuk Sesus hapik niukurunaha. Taparakta ziknapamykysokota ziny. Atahi iwahoro pe zumu Sesus hapik wahoro isturupeze zumu. ");
INSERT INTO rkbNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Peduru batu paku ape baze tu hokbowy baze niriktohoko. Iwaze usta izoizo. Wytyk hokbowy perytsata pe niy: — Katukta tynatsukta! tsimy — niy. Yhỹ niy. — Anaeze paku tsimy — perytsata Peduru pe niy. Iwaze nitsuk. ");
INSERT INTO rkbNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Inatsukze atatsa ipe niy: — O ikia sa niwatihi Sesus tukta — niy. — Batu kanyhy — mybarapetu niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tsiwarikrẽna. Kytsa sodadutsa tsumuẽhĩtsitsa niwatihi izo zipokoknaha. Kytsa izo baze niakpyzazakaranaha. Peduru situk niriktohoko niakpyzazaka. ");
INSERT INTO rkbNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","21","Iwaze taparakta ziknapamykysokonahatsa Sesus bo nipamykysoko: — Hawa sa zinymyrykynahatsa mykaranaha Hawa ha ty sa tsiksihyrinymyryky — niy. Sesus: — Amy humo sa kaspirikpowy soho tsimykara Zikwabykynahatsa sihyrinymyrẽtsa. Uta iksihyrinymyryky iwatsahi ispetaha. Iktsasokoze aparakbaha kaharere ziwabykynaha, anatyhi iksihyrinymyryky. Batu okpitsĩ. Sudeutsa wahoro eze ziknasihyrinymyryky, Deus wahoro zubata eze ziknasihyrinymyryky. Batu amy tohi ty okpitsĩ. Iwahatu kaharere soho zikwabykynahatsitsa bo tsimy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Anas nitsasohoze estuba maku Deus wahoro perytsa ibaze niriktohokota tatsyhyrype ty ziokpykik. Ipe niy: — Iwa taparakta ziknapamykysokonahatsa bo batu tyso. Batu wasani my — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Sesus: — Kaharere ty wasani ahabyizeka kytsa bo tsimytsasoko. Kaharere wasani my zeka amy skaraba tsikokpykik — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Anas Sesus Kajapas bo zioktyhyryknaha. Itsipatsa waraha tatu ibo zioktyhyryknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Iwaze Peduru izo baze niakpyzazaka kytsa baze nidyhykyze wytyk ipe niy: — O ikia niwatihi Sesus tukta sa — niy. — O batu. Batu kanyhy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Iwaze usta Peduru pe niy. Atahi taparakta tsumuẽhĩtsa. Atahi Peduru zispizykikta tsy. Atahi ipe niy: — Uta tisaziksapyrẽna eze ikozo tawata. Sesus tukta sa ikia bo ikozo — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Peduru: — Batu ba. Batu kanyhy. Aty skaraba Sesus — niy. Iwa niyze hi kokuaro nipo. ");
INSERT INTO rkbNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Iwaze Kajapas Sesus tuk nipamykysobaze ispehatsaktsa wahoro bo zioktyhyryknaha. Sipehatsa Piratus inarokota iwahoro bo miwa botu zioktyhyryknaha. Sudeutsa Piratus wahoro bo batu paku zikaha. Mynapupunaha zeka Paskoa eze Sudeutsa ba zik tahadisahanaha. Iwaze hi — Deus okzeka batu simysapy tsimykaranaha — nikaranaha. Maku Sudeutsa byitatu wahoro bo ba zikpupunaha sihumo batu simysapy maha. Paskoa myikaha batu tahadisahanaha mykaranaha. Iwatsahi Piratus wahoro bo ka batu paku zikaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Iwaze Piratus sibo zoihik. Ape baze tu ispe niy: — Amy humo sa Sesus kabo tsikzioktyhyryknaha. Atakta sa batu imysapy tsimykaranaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Yhỹ nikaranaha. — Atahi batu imysapy mytsaty tsimykaranaha. Moises harere bo batu yhỹ niy, iwatahi ikia kino ity tsipibeze tsimykaranaha — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Piratus: — Ikiahatsa zuba isoho tsimytsasokonaha. Hawa Moises harere bo batu yhỹ niy ahahyrinymyrẽtsa iwatsahi isoho tsimytsasokonaha — niy. — Batu. Katsazuba ziky iharapatawyhyta humo ba zibezenaha. Katsaktsa iharapatawyhyta humo ba zihyriziknaha. Batu tybeze. Ikia zuba tsipibeze katsaktsa batu — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Iwa nipamykysokonaha. Sesus botu nitsaso: — Kytsa iharapatawyhyta humo pihyrizik tsihiknaha iwa pikbezenaha — niy. Sudeutsa iharere humo batu sihyrinymyry iwa Piratus bo nipamykysokonaha. Sesus harere atsatu nipamykysokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Iwaze Piratus tawahoro bo pakuzo niy. Kytsa pe niy: — Sesus kabo tyzioktyhyknaha — niy. Zioktyhyryknahaze ipe niy: — Ikia hi ja Sudeutsa pehatsa — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Sesus: — Aharere pe sa tsimykara. Mekta harere pe tu sa tsimykara — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Piratus tihi: — Hawa ha usta mytsaty mykara motsasoko. Utakta Sudeutsa byitatu. Sudeutsa taparaktsa hi ikia kabo zaoktyhyryknaha. Hawa amysapybyita tu tsimykara. Ikia Sudeutsa pehatsa ja hawa tsimy — Piratus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Sesus: — Hawa ikia kytsa tysipeha utakta batu. Hawa apehatsa Sesa inarokota kytsa mysipeha utakta batu. Utakta pipeha zeka ikia wata katyryktsa takyrikinaha, iwaze kasukyrytsitsa mowatsorokonaha iwaze Sudeutsa ba zikoktynaha. Katyryktsaktsa mekywatsa tu maha. Batu Homa tyryktsa byitsawatsa tu — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Piratus: — Ikia hi sa ispehatsa — niy. — Yhỹ uta hi ispehatsa. Mybarawy ezektsa bo wasania ty mysihyrinymyryky. Asahi ana ty hi hyỹ mykaranaha zeka asahi kaharere bo kino niwatihi hyỹ mykaranaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","— Amy sa wasape — Piratus niy. Iwaze nipamykysobaze Piratus tawahoro ikny zoizo. Sudeutsa pe niy: — Atakta batu amy tohi ziky iwatahi ba zibeze — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Tubabatu tahamyikahakanahaze maku estuba myzuke ziknakara iwa sisopyk. Kytsa sizubarẽtsa sakyriukrẽnikitsa hurukwy eze tu mykaranaha. Iwaze ispe niy: — Aty sa myzuke, Sudeutsa pehakatsa Sesus za myzuke — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","— Batu ba — kazi nikaranaha. — Atakta batu myzuke — Opykani kaziu nikaranaha. — Bahabas tyzukekta — nikaranaha. — Bahabas sakyriukrẽnikitsa hurukwy ezektsa tyzukehikta tsimy tawata hỹ — nikaranaha. Bahabas kytsa bakatsa niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Iwaze Piratus sodadutsa pe niy: — Sesus tytsakihiknahaktsa. Sirara hwyk tsarikihi tsizezerẽna ty tytsakinaha — niy. Yhỹ niaha. Isukpetara buruk nitsakikinaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Iwaze sodadutsa inisaha ty zitsorikeknaha. Zikymy nahaze iharek humo pu niaha. Iwa nikaranaha. Ispehatsa mekywa tu sitsorik Sesus zimyijakanaha. Isuk tsahirita ty zuba korobyk ispehatsa hyritywata nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Iwaze ibo ibaba botu ipe niaha: — O Sudeutsa pehatsa ja tsimy — zimyijakanaha. Ziokpypykyknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Iwaze Piratus zoizo. Kytsa pe niy: — Iktsa tahaktsa. Ikiahatsa boktahi myzioktyhyryk. Atakta batu amy tohi nikara batu ziky — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Iwaze Sesus puke niy. Zoize inisaha ty zitsorikiknaha Isuk tsazirita tsizezerẽta niy. Iwa kytsa sizubarẽtsa bo zioktyhyryk. Piratus ispe niy: — Iktsa tahaktsa kytsa! Tahi ihumo batu ahamypokzitsiuk — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ibo iktsa niahaze kazi nikaranaha: — Tabezekta! Iharapatawyhyta humo tabezekta! — nikaranaha. Taparaktsa Deus wahoro eze ziknapamykysokonahatsa, Deus wahoro perytsitsa kino niwatihi opykani kazi nikaranaha. — Tabezehikta tybezehik tsimaha — nikaranaha. Piratus tihi: — Ikiahatsa kino kabo tsikzioktyhyryknaha. Ikiahatsa hi tsipibezenaha. Atakta wasani mytsaty mykara. Iwatahi batu pibeze. Tsimysapyrẽta hi batu pibeze — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","— Katsa tabeze zeka wasani hỹ. Iharere batu imysapy my. “Utakta Deus tse” botu nitsasoko iwatsahi tabeze zeka wasani my. Moises harere humo wasani my — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Nitsasokonahaze: — Atakta Deus tse — Piratus ana ziwabyze iharere pokso tsipybyrẽta. ");
INSERT INTO rkbNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Iwaze tawahoro bo pakuzo niy. Iwaze Piratus Sesus pe niy: — Hana iknykta sa ikia — niy. Sesus batu harere. ");
INSERT INTO rkbNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","— Amo skaraba batu harere ziky — niy. — Hawa motsasoko kytsa kaharere bo hyỹ mykaranaha. Mysipeha zeka kytsa pasukenaha atsipatsa warawy ty satsuk maha niy. Mysipeha zeka “Tabezekta”. Kytsa iharapatawyhyta humo pahyriziknaha iwa pabezenaha. Ana humo hi tsihyrinymyrẽta — Piratus niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Sesus: — Amy ty tsimytsasoko kytsa aharere bo hyỹ mykaranaha. Aharere wasani my. Deus humo kytsa aharere bo hyỹ mykaranaha. Deus abo yhỹ ahabyi zeka aharere bo kytsa batu ma zikaha. Batu kabo tsimy. Tsipikbezenaha zeka Deus okze ka batu amysapy tsimy. Kytsa asahi abo zikoktyhyryknaha Deus okzeka simysapybyitsa babatsa mykaranaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ana ziwabykyze nizuke tsihikik. Sudeutsa taparaktsa kazi nikaranaha. — Sesus tsimyzuke zeka Sesa pehatsa harere bo batu yhỹ tsimy, Sesa pehatsa nanabyitaba zipeha. Aparakbaha motsasokonahaze “Ikia mypehatsa”, Sesa Homa ezektsa pehatsa takyri, iwatahi Sesus tsimyzuke zeka Sesa pehatsa harere humo batu yhỹ. Tsimyzuke zeka Homa pehatsa ikia humo takyri — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Siharere ziwabyze Sesus ape bo zioktyhyrykzo. Myzubaha bo zoizo. Iwaze Piratus kytsa harerewabykywy bo niy anaeze tadyhywy bete nidyhyky. Anaka Kabata Sudeutsa harere inarokoha. ");
INSERT INTO rkbNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Tokbaha niyzikze sesta-peira eze niy. Sudeutsa myikaha nakymysohoze niy. Iwaze Piratus tihi: — Atakta ahapehatsa — niy. Iwa Piratus Sudeutsa pe niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","— Batu, tabezehik nikaranaha. Ihumo tahakyrikinaha “Tabezekta” kazi nikaranaha. Iharapatawyhyta humo tabezekta! — nikaranaha. — Ahapehatsa iharapatawyhyta humo pihyrizikik iwa pibezenaha. Iwa sa tsimyzehikiknaha — niy. — Yhỹ. Katsa mypehatsa estuba zuba. Sesa zuba mypehatsa — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Iwatahi Piratus sodadutsa pe niy — Sesus iharapatawyhyta humo tsipibezenaha — niy. Iwaze zioktyhyrykzonaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Myzubaha pauk baze hara bo zioktyhyryknaha. Hara iharekpokoso inarokota Sudeutsa harere kokokta my. Sesus iharapatawyhyta tasukara bete zibykyryk. Hara bo zumunaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Anabo izumunahaze iharapatawyhyta humo itsyhyry soik eze zihyriziknaha. Ipyrytsa humo niwatihi zihyrizikiknaha iwa niaha. Zikymynahaze iharapatawyhyta zitseknaha. Ituk makutsa petoktsa nisibanaha. Siharapatawyhytsa humo nisibanaha. Nataba natabaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","20","Kyze Piratus usta pe: — Tsiwatahakta! niy. SESUS NASARE EZEKTA SUDEUTSA PEHATSA — niy. Anahi Sudeutsa harere hi ziwatahaka. Kereko harere niwatihi ziwatahaka. Ratĩ harere kino niwatihi ziwatahaka. Ziwatahabaze iharapatawyhyta Sesus harapu bete zihyrizik. Ana parakbaha pinynaha. Iharapatawyhyta Serusarẽhe pauk baze parakbaha iwataha zinykynaha. Siharere ziwatahaka — Sesus Nasare ezekta Sudeutsa pehatsa — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Iwaze taparaktsa Deus wahoro zubata eze ziknapamykysokonahatsa Piratus pe niaha: — “Sudeutsa pehatsa” tsiwatahakanaha batu mykparawy tsimaha. Tsipiwataha zeka. “Atakta botu nitsaso Sudeutsa pehatsa niy” iwa zeka yhỹ tsimaha — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Piratus: — Batu. Hawa botu iwataha nahaka niwatihi — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Kyze sodadutsa Sesus iharapatawyhyta humo zihyrizikbanahaze isuk botu zibokiknahaze ziaksenaha. Jokboha zisysykyryknaha napetok napetok niaha. Estuba isuk tisapyrẽta ana hi sodadutsa nizihikiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Iwatsahi asa zuba nipamykysokonaha: — Na ty ka syk syk byitaha! Haraharezipyryktsa tahapaparanahaktsa kytsa, aty ja isuk piakse tsahi mybo piwatawy — iwa asa zuba nipamykysokonaha. Asahi yhỹ nikaranaha. Iwaze haraharezipyryktsa nisipaparakanahaze estuba zuba isuk tisapyrẽta ziakse. Tubabatu Deus harere papeu humo botu ziwataha: — Kasuk ty metutu nikaranaha. Estuba kasuk ty haraharezipyryktsa mysipaparanaha — niy. Iwa tubabatu ziwatahaka, aba atsatu sodadutsa niaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Iwaze kykyryk iharapatawyhyta pauk baze niriktotohokonaha Sesusje, atatsa taeky tuk. Karapas oke Maria inarokotatsa niwatihi. Maria Madarena niwatihi situk niriktohoko. Sizubarẽza iharapatawyhyta pauk eze niriktotohokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Sesus taje bo iktsa niy. Zinymyrykyta atahi Sesus ihumo tsimypokzitsiarẽta atatsa baze niriktohoko. Iwaze Sesus taje pe niy: — Atahi atse mozik. Atahi taje zipokzitsiki nahawahi papokzitsi hỹ — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Iwaze zinymyrykyta pe niy: — O atatsa aje. Ikia aje baba tatsa wa tsipokzitsi — iwa niy. Sesus nihyrikosokdaze zinymyrykyta Sesusje tawahoro bo zioktyhyryk. Iwahoro eze ziknapykyryk, ije watatsa niyzik. ");
INSERT INTO rkbNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Kyze Sesus tahyriziktsokzawy zepykbaze ana humo hi tsihyrinymyrẽta. Iwaze hawa tubabatu Deus papeu humo isoho ziwatahaka, atsatu nitsasoko: — Karapukrẽta — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Anaeze duabohotsa tsik itsãrãkbara ty morosuk eze ky ty tsikok niy. Kytsa mazori waha ty humo duabohotsa tsik bo tsikuk tsikuk niaha. Iwaze mazori hyritywaha ty hwi humo zitsihibunaha iwaze zidokonaha. Iparikiha sazik ty isope inarokoha. Iwaze jobo Sesus sak bo tsyk tsyk nikara. ");
INSERT INTO rkbNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Iwa duabohotsa tsik itsãrãkbara tu ziku. Iwaze nitsaso. — Aba pomozaka. Kahyriziktsokzawy zipykba. Deus kape nikara naha zipykba. O Deus mohyrikosokdaze wasani my ikia kahumo tsamypokzitsiarẽta — niy. Iwaze taharek ty tyk bo harapusiri niy. Iwa nihyrikosokda. ");
INSERT INTO rkbNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Kyze taparaktsa Sudeutsa Piratus pe niaha: — Kytsa asahi siharapatawyhytsa humo nisihyrizikiknahaze mybyrykywy pomoze ba zik sereknaha siharapatawyhytsa humo mysereknaha zeka batu isapy mytsaty tsimykaranaha. Iwatahi sodadutsa pe tsimy. “Asahi siharapatawyhytsa humo tsikyrizikiknaha tysektsaharakiknaha” iwaze atsoko ziakbanaha. Iwa byiri sabado siharapatawyhytsa humoktsa mahani. Sinurytsa ty mysibykyknaha mybyrykywy sabado sukmobyitu — nikaranaha. Iwa nitsasokonaha sesta-peira eze. Byriri sabado zumuze tabyrykywy Sudeutsa myikahakawy zumu. Iwatsahi asahi siharapatawyhy humoktsa nasispik tsihikiknaha sabado sukmobyitu my. ");
INSERT INTO rkbNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Iwatsahi sodadutsa siharapatawyhy humoktsa bo niukurunaha. Sibo zumunahaze tapara estuba maku zektsaharakiknaha. Usta ty kino niwatihi zektsaharakiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","37","Iwaze Sesus bo zumunahaze. Botu zumuza. — Atakta botu zumuza — asa zuba nipamykysokonaha. Iwatsahi batu tyektsaharak. Tubabatu Sesus soho Deus harere papeu humo ziwatahaka: — Batu typoiktsa harak. Estuba zuba batu typoiktsa harak — niy. Iwa tubabatu ziwatahaka. Hawa ha ty botu ziwatahaka atsatu sodadutsa nikaranaha. Iwaze sodadu tanora ty ipektsa baze ziskoik. Ziskoikze ispu zipoko niy. Pihik tuk tu zipoko niy. Tubabatu Sesus soho Deus harere papeu humo ziwatahaka: — Kytsa iskohokta bo iktsa mykaranaha — niy. Iwa ziwatahaka. Sodadutsa ziskoiknahaze ana soho humo hi batu sihyrinymyry iwatsa tu Deus harere bo hyỹ nikaranaha. Utakta Sesus nihyrikosokdaze ibo iktsa iky. Ana hi pykyhytu iktsasoko. Wasani niy. Ikiahatsa bo nihyrikosokdata soho iktsasoko iwahatu ikiahatsa kino niwatihi ihumo ahaspirikporẽtsa. Ana hi iktsasoko wasani hiba. Kahyrinymyrẽta hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Kyze Sose Arimeteja ezekta Piratus bo zumu. Sose Sesus humo tispirikporẽta zinymyrykyta. Batu tyso. — Utakta Sesus harere bo hyỹ ikykara ihumo kaspirikporẽta — Sudeutsa pokso batu tyso. Tsipybyrẽta. Atahi Sesus zispirikpoko. Atahi Piratus pe niy: — O Sesus nury ty uta kabokta! — niy. — Yhỹ. Inury tynazipikta — niy. Kyze inury inazipikze iytyk bo zibykyknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemus Sose tuk, atahi jokmorẽnikia tsizubarẽna zebykyryk. Tirĩta sĩko kiros jokmorẽnikia zebykyryk. Jokmorẽnikia mira hwi soporo iwaze aroes wihara soporo itsakykyha. Tsokmorẽna. Anahi zibykyknaha. Tubabatu Nikodemus Sesus bo nipamykysoko. Sesus atazuba tabo unata eze inakozoreze. ");
INSERT INTO rkbNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Sesus nury nazipiknahaze panu ty ziakwarakanaha. Inury bo jokmorẽnikia ty ziharasusunaha. Iwa Sudeutsa sopykwy. ");
INSERT INTO rkbNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Sesus iharapatawyhyta humo zihyrizikiknaha eze hwitsa sisaziksapyrẽtsa my. Anaeze iytyk ezytyk niy. Batu aty tohi humo iwihihukbara. ");
INSERT INTO rkbNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Nubaze sesta-peira Sudeutsa tahadisahawy humo nikaranaha sabado sukmobyitu nikaranaha. Sabado eze ka tahabyri nepykyryknaha. Byri ziktahabyrykynaha. Iwaze iytyk ezytyk tykarawa tu anaeze nitsahukarenaha. Sesus iytyk bo zihoekarenaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Kyze zokorobyitu Maria Madarena iytyk bo niukuru. Miwa botu domiko eze atatsa iytyk bo zumuku. Zumuze harahare ihokbowy hana bo ja, sukyhy zikare niy. — O aty sa inury zibykyk — mytsaty nikara. ");
INSERT INTO rkbNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Iwatatsahi atsoko Peduru bo ziksizo. Utakta Sesus zinymyrykyta kahumo tsimypokzitsiarẽta kabo niwatihi ziksizo. Ziksizoze. Atatsa: — Kytsa Sesus nury zibykyryknaha. Hana bo ja. Iytyk batu tsarawyky niy. Hana bo sa zebykyryknaha — niy. Iwa makutsa petoktsa bo nitsasoko. ");
INSERT INTO rkbNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Iwaze Peduru itukta iwa atsoko iytyk bo nitururuknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Petoktsa iytyk bo nitururuknaha. Uta hi Peduru haraze ikpaparakak. Tapara iytyk bo ikumu. ");
INSERT INTO rkbNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ikumuze iytyk bo iktsa iky, okmymy ikyze panu iakwarawy zuba nizozohoko ana bo zuba iktsa iky. Utakta batu paku. ");
INSERT INTO rkbNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Iwaze Simaõ Peduru iytyk bo zumuze. Atsoko iytyk bo zekeba. Panu bo iktsa niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Usa panu bo iktsa niy. Panu nihyrikosokdata iharekwarawy bo iktsa niy. Usa panu ka meky botu niapykyryk. Inury ykwarawy ka bara botu niapykyryk. Inury hana bo ja niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Utakta tapara iytyk bo ikumu. Iwaze uta kino niwatihi iktsuk. Ikozoze: — Inury hana bo ja Sesus inahyrizikpo — atatuke iky. Iwatahi Sesus humo kaspirikporẽta. ");
INSERT INTO rkbNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tubabatu Deus harere papeu humo botu ziwatahaka: — Sesus siakbatsa tukze Deus zihyrizikpowy — niy. Zinymyrykynahatsa anaharere humo tsihokdaharẽna niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Kyze katsa zinymyrykynahatsa bo tsiksizonaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Kyze Maria Madarena iytyk bo niukuruzo. Atatsa iytyk baze nipuziuku. Nipuziukutatsa tu iytyk bo ziktsutsu niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Bijoikpe iknyktsa Deus tsumuẽhĩtsa petoktsa bo iktsa niy. Sisukbarazarẽtsa. Sesus nury sapy eze nidyhydyhykynaha. Estuba iharek sapy taba nidyhyky. Usta ipyrytsa sapy taba nidyhyky. ");
INSERT INTO rkbNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ipe niaha: — Amo skaraba tsimopuziuku — niaha. — Kapehatsa nihyrikosokdata nury zibykyknaha. Hana bo ja zibykyknaha — niy. Iwatatsahi pipokzitsiki. ");
INSERT INTO rkbNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Iwa nitsasokoze tasukpe bo uwok niy. Sesus ibaze niriktohoko. Ibo iktsa niy. Ihyritsik humo inyhybyitawa nio. Sesus batu inyhy. ");
INSERT INTO rkbNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Atahi ipe niy: — Amo skaraba tsimopuziuku. Aty sa tsipiberiki — niy. Atatsa kino isazikperytsa ja niy. Iwatatsahi ipe niy: — O aty sa zibykyk tsibykyryk zeka ikza kabo ky. Ikza mekybotu piytykzo — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","— O Maria — niy. Iwaze zinyziu. — Raboni — niy. Sudeutsa harere ka. — Kapokzitsitsa — piwatawyky. ");
INSERT INTO rkbNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Sesus ipe niy: — Katy paik paik byityktsa! Kazo bo ka batu kado. Katuktsa bo tynakozorektsa! “Sesus jobo modo. Kazo bo modo.” Kazo Deus ikiahatsa kino niwatihi ahazo Deus tihi “Myzo Deus”. Iwa katuktsa bo tsimy — niy. Yhỹ niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Iwaze Maria Madarena niparak. Zinymyrykynahatsa bo zumuze ispe niy: — O Sesus iny. Inahyrizikpo. Abahi jo bo Deus bo modo. Ata hi ipokzitsihi. Katsa kino niwatihi Deus myhumo tsimypokzitsiukrẽta — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Zunubakaze Sesus tatuktsa bo. Domiko eze sibo zumu. Asahi wahoro bo inakypykbanahaze. Tahahokbowy zitsykykiknaha. Sudeutsa taparaktsa pokso sipybyrẽtsa nikaranaha. Iwaze Sesus sibo natakaha ispe niy: — Ahapybybyihuktsa. Ahapunihikuktsa kytsa! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Tapapepe humo ky ziwatawyky. Tapektsa humo ky ziwatawyky. Zinymyrykynahatsa sakurẽtsa nikaranaha. Tahapehakatsa bo nikozonahaze sakurẽtsa niyziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ispezo niy: — Ahapunihikuktsa ahapyby byihu ja kytsa! Tapara kazo mybarawy ezektsa bo zikpeha. Uta kino niwatihi, utakta myzahapehaka. Myzubaha bo kasoho tsimytsasonaha iwatahi myzahapehaka — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Iwaze Sesus sibo huhu nikara. Ispe niy: — Deus hyrikoso ikiahatsa tuk mynapykyryk. ");
INSERT INTO rkbNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Tsimytsasonaha zeka sizubarẽtsa pe: “Ahamysapybyri Deus pahaokzohik” tsimykaranaha. Deus simysapybyri siokzohik. Tsimytsasonaha zeka kytsa pe: “Deus ahamysapybyri batu pahaokzo” tsimykaranaha. Deus simysapybyri ba ziksiokzo. Deus simysapybyitsa tu ba zikspiriktsokda my — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Iwaze zinymyrykyta Tome inarokota niy. Usta inarokota beketsa niy. Atahi Sesus batu inyhy. Sesus zinymyrykynahatsa bo izumuze Tome batu situk dyhy niy. Sesus inahyrizikpoze Tome batu inyhy. ");
INSERT INTO rkbNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Iwatsahi ustsa ipe niy: — O Tome katsaktsa mypehakatsa tsinynaha — niaha. — Batu ma. Ipapepehyrizikwy sapy bo katsyhyry ty kuruk ahabyizeka ba ma ziky. Nataba tanora sapy bo katsyhyry ty kuruk ahabyizeka ba ma ziky — iwa ustsa zinymyrykynahatsa bo Tome nitsaso. ");
INSERT INTO rkbNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Kyze mytsyhyrytsa wa zuruze Sesus tuktsa wahoro bo izumubazonaha. Tome situk niapykyryk. Wahoro tahahokbowy zitsykykiknaha. Atsoko Sesus sibo natakaha. Sesus zinymyrykynahatsa pe: — Ahapunihiktsa kytsa. Ahapybybyihuktsa! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Iwaze Tome pe niy: — Pany! Katsyhyrype bo iktsa tykta. Na katsyhyrype hyrizikwy sapy bo atsyhyry ty kuruktykta. Na kaskowy tanora sapy bo atsyhyry ty kuruktykta. “Sesus nihyrikosokdata ba ziknahyrizikpo” ana ty hi sosobyity tsimy. Kahumo aspirikpokta! — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tome: — Ikia kino kapehatsa tsimy. Ikia humo kaspirikporẽta hỹ. Ikia hi Deus babata — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Sesus ipe niy: — Tsikny taowy kahumo aspirikporẽta. Wasani my. Ustsa kytsa katy nyahabyitsatu kahumo sispirikporẽtsa. Asa hi sakurẽtsa babatsa — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Sesus tazikwy ziwatawyky. Zinymyrykynahatsa izikwy bo iktsa nikaranaha. Izororohotsa bo iktsa nikaranaha. Anasoho ba ziwataha. Papeu humo sisoho ty batu tywataha. ");
INSERT INTO rkbNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Hawa Sesus zikwy zororotsa soho tsikaeni zuba ziwatahaka. Anasoho ziwatahaka iwatahi pahaspirikpoko Sesus Deus tse. Deus Sesus zipehata pahaspirikpoko. Ana humo hi ahaspirikporẽtsa zeka mekywatsa tu tsimoziknaha. Ihumo ahamysapyrẽtsa tsimoziknaha. Ihumo ahaspirikporẽtsa zeka tsimyhyrikosokdanahaze tsinahyrizikponaha. Iwaze Deus tuk ahawahi tsimynapykyryknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Kyze Sesus tuk zinymyrykynahatsa bo inatakahazo. Pihikzotsabyri baze sibo izumu. Pihikzotsabyri Tiberiades inarokoha. Anaeze sete ahatsa ituktsa zitsikpaparakanaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Peduru, Tome, Natanieu, Suão, Tsiaku, ustsa petoktsa iwatsa situk nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Peduru ispe niy: — Pihik pitsikpapara — niy. — Yhỹ! Katsa ikia hapik — niaha. Haramwe zunubakaze kokokorohyk. Turi turi turi niaha. Zitsikpaparakanaha. Batu istyzo. ");
INSERT INTO rkbNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Kyze zokorobyitu Sesus pihik sak eze niriktohoko. Tsaraha bytykarawa tu niy, Sesus pihik sak eze niriktohoko. Zinymyrykynahatsa nikozonahaze: — O aty skaraba. O batu mynyhy — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Iwaze Sesus huahua niy: — Tsiknasizokonaha sa kytsa! — niy. Batu niaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","— Tõhõryk ty nataba tsioktsokzonahaktsa! Abaka tsinasizonaha ty — niy. Iwaze tõhõryk zioktsoknaha. Abaka tõhõryk piknutsa tsakyrik humo, ba zikzizonaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Iwaze uta inymyrykyta Sesus kahumo tsimypokzitsiarẽta Peduru pe iky: — O mypehakatsa Sesus — iky. Peduru ziwabyta takpyzazawy ty korobyk niy. Tahyriziktsokzawy humo awani nikarata iwaze takpyzazawy zikorobykze pihik bo nioktsok. Sesus bo atsoko uruk uruk nikara. ");
INSERT INTO rkbNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ustsaktsa mahani. Tõhõryk zikyrikinaha. Titsakyrikrẽna. Tsaraha imyrazata bytykara wata nowẽta meteros zuba niy. Nakpo bybybyu niaha. Tahatsaraha piknutsa ty nasihareknaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Nakpo tsaraha ekze nizuknahaze izo bo nikozonaha. Sesus izo bete piknutsa nisizoko sizubabyitsa tu. Atsikara niwatihi. ");
INSERT INTO rkbNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Sesus tihi: — O piknutsa ty puẽtsik kabo wabehyryk tynaha — niy. Yhỹ Peduru niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Iwaze Peduru tsaraha bo takoro, piknutsa tõhõryk eze inasikyriki: — O inahareknaha — niy. Piknutsa sizubarẽtsa nasizokonaha. Sẽto sĩkuẽta teres piknutsa sizubarẽtsa nikaranaha. Inahareknahatsa tu tõhõryk batu tuzu. ");
INSERT INTO rkbNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Sesus: — Parany! tyzahadisahanaha kytsa! — niy. Yhỹ niaha. Zinymyrykynahatsa batu — Aty sa — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Mynyhy tihi Sesus atsikara ty sibo nyny niy. Piknutsa ty kino niwatihi. Tahadisahakanaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Abaka Sesus tuk zinymyrykynahatsa bo harakykbyi inahyrizikpota inatakaha. ");
INSERT INTO rkbNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Kyze Sesus Simaõ Peduru pe niy, atahi Suão tse iwaze Sesus ipe niy: — Simaõ ikia sa kahumo tsamypokzitsiarẽta — niy. — Yhỹ. Uta atukta babata my — niy. — Kaharere ty katuktsa tysihyrinymyrykta. Hawa hozipyrykzatsa tsihitsa siraratsa tysipokzitsiki iwa ikia katuktsa humo tynasipokzitsiki. ");
INSERT INTO rkbNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Sesus ipe niyzo: — Simaõ kahumo sa tsamypokzitsiarẽta babata tsimy — niy. — Yhỹ utakta atukta babata my — niy. — Kaharere katukytsa bo tysihyrinymyrykta! Hawa hozipyrykzatsa tsihitsa siraratsa tysipokzitsiki iwa katukytsa humo tysipokzitsi — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Sesus ipe niyzo: — Simaõ ikia sa kahumo tsamypokzitsiarẽta babata tsimy — niy. Iwaze Sesus nitsasokoze — Ikia sa kahumo tsamypokzitsiarẽta — atsa tyty harakykbyi Peduru pe niyze tisukatsihikrẽta niyzik. Peduru: — O kapehakatsa tsahyrinymyrẽta hiza. Ikiakta tsiknyba hỹ. Utakta ahumo kamypokzitsiarẽta. Ana humo hi ahyrinymyrẽta — niy. Sesus: — Kaharere ty za katukytsa tysihyrinymyrykta! Hawa hozipyrykzatsa tsihitsa siraratsa tysipokzitsiki ikia iwa katukytsa humo hi tysipokzitsiki hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Wabyziutykta. Simaõ mykyryburukta zikzurukuze asuk ty korobykyk ziknakaraze paikpa ziknakara hỹ. Ikia tsimytsaikbaze usta atsipatsa mysakwara. Akparawy bara bo paoktyhyryknaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Iwa Peduru pe niy. Peduru mora naha soho nitsasoko. Ipe niy: — Tsimyhyrikosokdaze kytsa sizubarẽtsa motsasokonaha “Deus hi Peduru zipunihikwyky hỹ. Iwatahi mohyrikosokdaze batu ipyby. Deus imysapyrẽta hỹ” mykaranaha — niy. Hawa Peduru mohyrikosokda naha soho botu ibo nitsasoko. Iwaze ipe niyzo: — Kaharere bo hyỹ tsimykta! Kapik tynao — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Kyze Peduru uwok niyze kabo iktsa niy. Utakta zinymyrykyta Sesus kahumo tsimypokzitsiarẽta. Uta Peduru sukpe baze ikziktohoko. Tapara Sesus nihyrikosokda katsa ituk amyikaha eze tuze uta zuba ipe iky: — Aty skaraba asukyrytsitsa bo paoktyhyryk — ikykara. Aba Peduru kabo iktsa niyze ta tihi: ");
INSERT INTO rkbNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","— Hawa sa ipe tsimy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Sesus: — Batu ityso. “Hawa sa ipe tsimy”. “Uta sa Deus harere bo zuba yhỹ my” tsimy. Iwa tsimy hỹ — niy. — Utakta motsasoko zeka “Atakta ba zikyrikosokda, atahi myziksizoze motare”. Wasani my. Ikia kino kaharere bo zuba hyỹ tsimykara. Ustsa soho bo batu paikpa mytsaty tsimykara. Kaharere bo zuba hyỹ tsimykara. Ikia humo wasani tsimyzeka kaharere bo zuba hyỹ tsimykara. ");
INSERT INTO rkbNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Kyze Sesus tuktsa asa zuba nipamykysokonaha: — Atakta ba zikyrikosokda, Sesus myziksizoze ispitu my — nikaranaha. Iwa Sesus batu tyso. — “Atakta ba zikyrikosokda” tapara nitsaso “motsaso zeka atakta ba zikyrikosokda atahi myziksizoze motare” — iwa nitsaso. Batu siwabyziuhu. ");
INSERT INTO rkbNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Zinymyrykyta Sesus kahumo tsimypokzitsiarẽta piwatahaka. Hawa ha ty piwatahaka naha wasani my. Utakta Sesus harere ahabo motsasoko. ");
INSERT INTO rkbNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Sesus tsizubarẽna ty nikara. Iokboha zuba papeu humo ziwataha. Nanabyi soho ziwataha zeka abazuba papeu humo ba zikpyk. Ziwatahaba zeka papeu zikpykba. Niwazuba. Suão.");
INSERT INTO rkbNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teopiro uta papeu humo ikia bo botu iwataha. Anatyhi Sesus kytsa nisihyrinymyryky anatyhi Sesus nikara atsatu ikia bo iwataha. ");
INSERT INTO rkbNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Iwaze Sesus mytuk zikzurukuze ziknakara. Tapara papeu humo iwataha. Tapara Sesus bijoikpe bo nido. Kytsa dose sakzohotsa ituk zinymyrykynahatsa niaha. Sesus sinini nikara. Nihyrikosokda. Inahyrizikpo. Inahyrizikpoze sakzohotsa bo tanywyre. Tapara kytsa zinymyrykynahatsa ituk zikzurukunaha. Sibo hi tanywyre. ");
INSERT INTO rkbNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Sesus nikara atahi sibo tawatawykyzo. Wasape ispitu tahi tawatawyky. Nahyrizikpoze estuba byzoje ziharahaze situk zikzuruku. Sakzohotsa bo Deus tyryktsa soho nitsasoko. Deus mypehakatsa niyzik ana soho hi kytsa bo nitsasoko. Tapara ispe niy: — Kaharere myzubaha bo tytsasonahaktsa! Deus hyrikoso ahabo myzipeha — niy. Kyze bijoikpe bo nido. ");
INSERT INTO rkbNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Sakzohotsa baze tuze Sesus ispe niy: — Serusarẽhe eze tsiperynahaktsa kytsa! Anaeze ahabyri typykyknaha Deus hyrikoso tsiperynaha Deus hyrikoso ahabo myzipeha. Deus botu nitsaso: “Kahyrikoso ahabo myzipeha”. Iwatsahi ikiahatsa Deus hyrikoso tsipiperykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Tapara Suão kytsa pihik ty nisiharasusuku. Iwaze hi Deus hyrikoso ahabo myzipeha. Deus hyrikoso ahatuk mynapykyk. Hawa kytsa pihik ty nisiharasusuku astatu Deus hyrikoso kytsa bo myziakzo niy iwatahi mytuk mynapykyryk. Abanury tu Deus hyrikoso ahabo myzipehahik — Sesus nikara. ");
INSERT INTO rkbNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Sakzohotsa inakypykyknahaze Sesus bo nizapykykynaha: — O mypehakatsa abaka sa aharere humo Isareu ezektsa bipyritsa tysiksiwyhiknaha. Ustsa kytsa tysiksiwyhiknaha — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Sesus ispe niy: — Hawa mykaraze kazo zuba tsihyrinymyrẽta. Hana wa puruze kazo zuba tsihyrinymyrẽta. ");
INSERT INTO rkbNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ikiahatsa hi Deus hyrikoso tuk tsimypykyryknaha. Deus hyrikoso ahabo mynasik. Hawaze mozumuze ahapunihikrẽtsa tsimoziknaha. Kazikwy ahatuk mynapykyryk. Iwatsahi kaharere ty kytsa bo tytsasonaha. Uta ahatuk zikzurukuze kaharere zikziwabykynaha. Anatyhi kytsa bo tytsasonaha! Anatyhi Serusarẽhe ezektsa bo tytsasonaha. Anatyhi Sudeja ezektsa bo tytsasonaha. Anatyhi Samarija ezektsa bo tytsasonaha. Mektsa tyryktsa bo nokponi kaharere tytsasonaha. Iwaze nanabyitaba kaharere paikpa tytsasonaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Sesus harere nipykbaze jobo nido. Bijo satata buruk nitsuk. Kytsa batu ity nyzo. ");
INSERT INTO rkbNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Iwaze kytsa bijoikpe bo iktsaziu nikaranahaze makutsa petoktsa sibo inasiknaha. Bijoikpe iknyktsa Deus tsumuẽhĩtsa sibaze niriktotohokonaha. Sisukbarazarẽtsa. ");
INSERT INTO rkbNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ispe niaha: — O Karireja ezektsa amo skaraba bijoikpe bo tsimykozokonaha. Abaka hana bo ja niy. Aibani zuba atakta jobokta tu myziksizo. Atsawatu do myziksizo — niaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Niahatsahi Serusarẽhe bo ziksizonaha. Hara inarokota Oriwerejatsa ikny nitururuknaha. Serusarẽhe bo niaha. Bytykareze tu estuba kirometero zuba niy. ");
INSERT INTO rkbNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Sesus sakzohotsa Serusarẽhe bo ziksizonahaze kytsa ipokpedawy jo bazeky bo nipupukunaha. Anaeze nitarespyknaha! Asaktsa Peduru, Suão, Tsiaku, Ãdere, Piripi, Tome, Baratoromeu, Mateus, usta Tsiaku Arapeu tse, Simaõ bipyri pehakatsa batu iakparawy, Sudas, Tsiaku tse iwatsa izumubanaha. Jobo ipokpedawy bo nipupunaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Asahi Sesus humo sispirikporẽtsa. Zibyituhukutu Deus bo nipamykysokonaha. Sesus zinymyrykynahatsitsa wytykyryk tuk Maria Sesusje tuk, tatukytsa tuk iwatsa Deus bo nipamykysokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Iwaze Peduru Sesus tuktsa bo nipamykysoko. Sesus tuktsa sizubarẽtsa. Sẽto wĩte niy. Peduru ispe niy: ");
INSERT INTO rkbNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","— O katukytsa, wabytahaktsa! Tapara nihyrikosokdata kadiri Dawi Sudas soho botu ziwataha. Deus hyrikoso humo Dawi Sudas soho ziwatahawy. Tubabatu Samo papeu humo ziwatahaka. Ana hi Dawi botu ziwataha atsatu Sudas nikara — niy. ");
INSERT INTO rkbNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","— Sudas katsa mytuk niukuru. Atahi Sesus sukyrytsitsa ibo inasioktykyryk. Sisukyrytsitsa okyrysaro ty Sudas bo nyny niaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Iwaze Sudas okyrysaro ty itsuhuk zihuak. Anaeze wytyk bo inaraha. Pỹ niy. Inatapewohik. Itsitsihi izoihik niy. Iwatahi atatu tabeze — niy. ");
INSERT INTO rkbNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","— Serusarẽhe ezektsa Sudas soho ziwabynaha. Iwatsahi itsuhuk Akedema zinarokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Siharere piwatawy “Ispusapy eze niapykyryk” niy. Dawi Samo papeu humo botu ziwataha: “Isapy hana bo ja. Batu aty tohi isapy ziakse. Mektatu nazapyzeky” niy. Iwahi Samo papeu humo ziwataha. ");
INSERT INTO rkbNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","— Iwatahi usta katsa tuk mokuru. Tahawatawynahaktsa kytsa! — niy. Iwaze Peduru ispe niy: ");
INSERT INTO rkbNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","— Aty sa katsa mytuk mynaukuru. Aty sa katsa mytuk Suão Sesus ziharasusu nikozo. Aty sa katsa mytuk Deus Sesus bijoikpe bo zioktyhyk nikozo. Atahi Sesus harere katsa mytuk ziwaby. Abaka atahi katsa mytuk Sesus inahyrizikpo mykara. Tsiwatawynahaktsa kytsa! Mytsatyziutahaktsa! Maku wasani mykara. Iwatahi aty sa Sudas sapyzeky piakse — Peduru niy. ");
INSERT INTO rkbNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Iwaze makutsa petoktsa nisioktyhyryknaha. Estuba maku Sose Barasabas inarokota usa naro Sustas. Usta maku zioktyhyryk, Matias inarokota nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Niahatsahi Deus bo nipamykysokonaha. Sesus tuktsa Deus bo nipamykysokonaha. — O myzo ikia hi hawa katsa mytsaty tsimykaranaha humo tsahyrinymyrẽta. Sudas nihyrikosokdaze tahyriziktsokzawy zerekik. Iwaze sinini ykarawy bo niy. ");
INSERT INTO rkbNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Anabo hi tasapy sinini mykara. Aty sa maku petoktsa katsa mytuk ana humo hi tymywatawy. Aty sa Sudas sapyzeky mozik! Mybo tsipiwatawy aty tuza mozik — nikaranaha. Iwa Deus bo nipamykysokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Niahatsahi sinaro harahareziktsa humo ziwatahakanaha, iwaze nisipaparakanahaze Matias ziwatawy. Iwatahi Deus akzohota niyzik. Õse sakzohotsa tuk ziknapykyryknaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Deus hyrikoso myzubaha bo Sesus nisiwatawynahatsa bo izumu. Pẽtekoste bo zumuze Deus hyrikoso izumu. Pẽtekoste zumuze Sesus tuktsa siwatawyhytsitsa inaharapekypykbanaha. Nawa zuruze Pẽtekoste inarokoha Sudeutsa myikaha niy. Iwaze Deus hyrikoso sibo inasik. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Inaharapekypykbanahaze atsoko iakpyri ziwabynaha. Iakpyri bijoikpe ikny inakara. Zopoktsa pyri waha inabyby, opykani inabybykyknaha. Wahoro eze nidyhydyhykynahatsa hi ziwabykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Niahatsahi izo hyrizik waha inasik. Izo waha siwatu izumuku. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Iwatahi Deus hyrikoso sizubarẽtsa bo inasik. Asa kino Deus hyrikoso situk mynapykyryk. Niahatsahi Sesus tuktsa ustsa harere ty nipamykysokonaha. Deus hyrikoso humo ustsa harere ty nipamykysokonaha. Tahaharere baba humo ka batu tyso ustsa harere ty zuba nipamykysokonaha. Iwa Deus hyrikoso humo nitsasokonaha hỹ. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Iwaze kytsa sizubarẽtsa Serusarẽhe bo inakozorenaha. Kytsa ustsa nanabyitabaktsa anabo inakozorenaha. Asahi Sudeutsa kino niwatihi Deus harere bo hyỹ nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ana ziwabynahatsa hi inauzuzukbanaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Simytsatyharẽtsa nikaranaha. Asa zuba nipamykysokonaha: — Wabytaha! Nipamykysokonahatsitsa Karireja ezektsa ja. Asahi taharere baba humo ka batu pamykyso. Asahi katsa myharere ty zuba mopamykysokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Hawa myharere tsiwabykynaha. Myzotsa myharere ty nimyhyrinymyrykynaha. Asahi myharere motsasokonaha nikaranaha — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Wastuhu zuba Patia ezektsa tsimaha. Ustsa Mede ezektsa, Sudeja ezektsa, Kapazosia ezektsa, Põto ezektsa, Asia ezektsa iwatsa tsimaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Ustsa Piria ezektsa, Panipirija ezektsa, Esito ezektsa, Ribija ezektsa, Sirene ezektsa iwatsa tsimaha. Ustsa Homa ezektsa. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ustsa Sudeutsa babatsa. Ustsa batu. Anatyhi Sudeutsa Deus soho nitsasokonaha katsa yhỹ tsimykaranaha. Aba myharere tsiwabynaha kytsa tihi: — “O Deus tsamysapyrẽta azikwy mybo tsipiwatawyky”. Anaty hi myharere baba nitsasokonaha — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Sipybyrẽtsa nikaranaha. Iwatsahi asa zuba nipamykysokonaha. — Amo skaraba — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ustsa nisimyijakanaha: — O tsõsĩ zikukunaha tsahi ja mykaranaha — nikaranaha. Sihyrinymyrybyitsa tu mybarapetu nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Iwaze Peduru Sesus ykzohotsa istazaha eze niriktohoko. Myzubaha bo ziakbataze opykani nipamykysoko. Iwaze niriktohoko: — O katukytsa Sudeja ezektsa tsiwabytoktonaha! Serusarẽhe ezektsa niwatihi wabyziutaha! ");
INSERT INTO rkbNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Kytsa tsõsĩ zikukunahatsa hi mytsaty ahabyitsa tsimykaranaha. Batu ba. Jobetehaneze zuba. Batu hauk iwatsahi tsõsĩ ty batu tsõ niaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Tsipinymyry tsihiknaha hawa ty sa kytsa tahaharere ty nitsasokonaha. Uta ahabo motsaso. Hawa ha ty nihyrikosokdata Soe botu nitsaso. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Tubabatu nihyrikosokdata Soe, Deus sohokotsa nitsasoko. Deus tihi: “Tapara mybarawy mopykze kahyrikoso myzubaha bo myzipeha. Situk mynapykyk. Isteokatsa kaharere motsasokonaha. Mykyryburuktsa mytsotospyk waha pinynaha. Sistsaikbatsa sitsotospykrẽtsa”. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Iwaze kahyrikoso kahyrytsa bo myzipeha, myzubaha bo mynasikze. Ihumo kaharere motsasokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Siwatawytsitsa bijoikpe eze mynakozokonaha. Mybarawy eze kazikwy piwatawyky. Siwatawytsitsa izo ispu zatata iwaha mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Haramwe miwa mozik. Byzoje myspu hyritywa mozik. Iwaze tapara mypehatsa myziksizo. Myziksizoze myzubaha pe: “O asaktsa wasani mykaranaha”. Ustsa pe “O asaktsa batu wasani zikaha” my. Iwa mypehatsa zikwy piwatawy. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Aty Deus bo mopamykysoko: “O Deus tsiktsumuẽhĩkta” my. Yhỹ my. “Atakta kabo myzioktyhyryk. Sinini ykarawy bo ba zapeha my” — nikara. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Peduru nitsasokozo: — O Isareu ezektsa wabytaha! Sesus Nasare ezekta ahatukze zikzuruku. Atahi Deus zikwy humo iwa ziknakara. Siwatawytsitsa iwa ziknakara. Siwatawytsitsa sizubarẽtsa bo iktsa tsikaha. Deus zikwy Sesus tuk tsinynaha. Ana humo hi ahahyrinymyrẽtsa — Iwa Peduru niy. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","— Deus tsihyrizikporẽta tsimysapyrẽta iwatatu kytsa harere bo yhỹ niy. Iwatsahi kytsa simysapybyitsa Sesus zioktyhyryknaha. Deus tapara zinymyry kytsa Sesus zioktyhyryknaha. Ikiahatsa hi ustsa kytsa simysapybyikitsa tsiksipehakanahatsa. Sesus ty tsibezehiknaha. Iharapatawyhyta humo zihyrizikiknaha iwaze tsibezehiknaha. Niytahi nihyrikosokda. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Deus hi zihyrizikpowy. Sesus nihyrikosokdata tu mahani. Nihyrikosokda tahi ba zikyrikosokdazo. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Tubabatu nihyrikosokdata Dawi Sesus soho nitsasoko. Sesus soho ty ispe niy: “Kapehatsa katuk tu kapauk baze atatu mynapykyk. Piktsumuẽhĩkĩ. Iwatahi kytsa pokso batu kapyby. Iwatahi kakurẽta”. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Motsasoko “O Deus ikia hi tsamysapyrẽta” my. “Mohyrikosokdaze Deus humo kaspirikporẽta. Tsipikoktyhyryk katsyhyryze pisapywyky. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Kahyrikoso sakbatsa baze tu batu katy arek. Ikia kanury ba zikbibi. Atse humo iwatahi kanury ba zikbibi ziky. Ikia tsimozikyrizikpowyzo. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Kaspituzo mozikzo ikia tuk mynapykyk. Ikia baze tuze kakurẽta.” Iwa Dawi tapara nitsasoko. Tasoho nitsasoko Sesus kino niwatihi nitsasoko — Peduru niy. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Peduru ispe niyzo: — O katukytsa mysihyrinymyryky, tubabatu mydiri Dawi nihyrikosokda. Iytyk bo nitsahorok. Abaka iytyk bo iktsa tsimaha. Ana bo hi nihyrikosokdata Dawi nitsahoroknaha. Iytyk tykareze tu niy. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Dawi ispituze Deus sohokotsa niy. Tapara Deus Dawi pe niy: “O estuba tsekoka Deus zipehata my. O Kiristu my” niy. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Dawi Deus harere tsekokatsa soho humo tsihyrinymyrẽta. Tapara mykara tsihyrinymyrẽta. Iwatahi nitsasoko: “Deus Kiristu hyrizikararawy siakbatsa tuk batu arek inury ba zikbibi”. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","— Deus Sesus zihyrizikpowy. Atahi ispitu niyzikzo. Ana humo hi ahahyrinymyrẽtsa iwatsahi ana hi tsimytsasokonaha. Deus Sesus bijoikpe bo zidohyrykzo ana bo hi tsimykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Abaka Sesus Deus apanuryk taba mopykyryk. Deus hyrikoso Sesus bo nyny niy. Abaka Sesus Deus hyrikoso mybo zipehahik. Hawa Deus botu nitsaso zipehata hi Deus hyrikoso inasik. Abaka Deus hyrikoso humo ana kino tsinykynaha tsiwabykynaha niwatihi — Peduru niy. — Nihyrikosokdata Dawi ata kino batu tyso. Sesus soho nitsasoko. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Dawi nury bijoikpe bo batu ido. Iwatahi tapara nihyrikosokdata Dawi nitsaso: Deus mypehatsa pe niy. “O kabaze dyhy ty! ");
INSERT INTO rkbNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Bykyze kazikwy humo asukyrytsitsa aharere bo hyỹ mykaranaha niy” — niy. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","— Isareu ezektsa wabyziutahaktsa! — niy sibo nitsasoziuku: — Ikiahatsa hi Sesus iharapatawyhyta humo tsihyrizikiknaha. Tsibezenaha. Atahi Deus zikwy humo mypehakatsa mozik. Deus zikwy humo Kiristu Deus zipehata mozik. Iwa motsaso iwaha humo hi tsipinymyrynahaze wasani tsimykaranaha — Peduru niy. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Iwaze myzubaha Peduru harere humo sisukatsihikrẽtsa. Asa tihi: — O mytukytsa hawa sa tsimaha — nikaranaha. Iwa Peduru ustsa sakzohotsa bo mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Peduru tihi: — Ahasopyksapybyri tsikykaranaha tsimoewynahaktsa! Tsikaharasusunahaktsa! Kytsa pahaharasusukunahaze ikiahatsa tihi: “O Sesus Kiristu tukta myzehikik” tsimaha. Iwa tsimaha zeka Deus ahamysapybyi humo pahaokzohik iwaze hi Deus hyrikoso ahatuk mynapykyk. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ata kino Deus ahabo myzipeha. Tubabatu Deus tihi: “Utakta kahyrikoso ahabo myziakzo tsihikik” niy. Deus ahahyrytsa bo tahyrikoso myziakzo. Mektsa tyryktsa bo myziakzo. Kytsa nokponi asahi Deus mysiakzoko myzubaha bo tahyrikoso myziakzo — Peduru niy. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Iwa Peduru kytsa sizubarẽtsa, Isareu ezektsa bo nitsasoko. Nipamykysoikik. Mysiakzoikik: — O ahamysapyrẽtsa tsimoziknahaktsa! Abaka kytsa simysapybyitsa mykaranaha sinini ykarawy bo mykaranaha. Ikiahatsa sinini ykarawy bo ka pão pãobyitahaktsa — niy. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Iwatsahi sizubarẽtsa Peduru harere bo yhỹ nikaranaha. Nawa zuruze kytsa sizubarẽtsa Peduru harere bo yhỹ nikaranaha. Harakykbyihi miutsa sizubarẽtsa hiba. Sesus tuktsa niyziknaha iwaze kytsa nisiharasusukunaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Sesus tuktsa sakzohotsa tuk zinymyry tsihikiknaha. Ustsa kytsa tuk siharereziuwytsitsa sakurẽtsa nikaranaha. Ustsa Sesus tuktsa siakparawy. Deus bo nipamykysokonaha. Paikpa siwahoro bo tahadisahakanaha. Atsikara zibiakaknahaze: — Sesus mysapyzeky nihyrikosokda — ana bo hi mytsaty ziknakaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Sesus sakzohotsa ihumo sispirikporẽtsa iwatsahi amy ty kytsa ba zikaha anaty hi nikaranaha. Ihumo sakurẽtsa niyziknaha. Iwaze inakypykyryknahaze asahi kytsa bo Deus zikwy ziwatawykynaha. Iwaze sizubarẽtsa paikpa iktsa nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Sesus tuktsa tahanamy ty ustsa bo nyny nikaranaha. Simysakihikrẽtsa. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Tanamy huak humo okyrysaro zebykyknaha bykyze sinamybyitsa bo nyny nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Pibyituhukutu Deus wahoro zubata bo izumubanaha. Tahadisahakanahaze sakurẽtsa nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Deus bo nisakibazikiknaha: — O Deus ikia hi tsimymysapywyky. Tsimymytsumuẽhĩkĩ iwatsahi mykurẽtsa. Ikia zuba tsamysapyrẽta — nikaranaha. Serusarẽhe ezektsa Sesus tuktsa humo siakparawy. Iwatsahi pibyituhukutu Deus humo sizubarẽtsa Sesus tuktsa naubarakanaha. Sesus harere bo hyỹ nikaranaha. Asahi Sesus tuktsa tuk izumubanahaze sakurẽtsa nikaranaha. Iwaha humo hi ziwabykynaha iwatsahi hyỹ nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Kyze iharakibikia bo zoize Peduru Suão ahatsa Deus wahoro zubata bo niy. Sudeutsa Deus bo ziknapamykysoikiknaha iwatsahi Deus wahoro bo nipupunaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Maku iekbyrita zikzibyituhukutu itukytsa Deus wahoro zubata hokbowy bo zikzioktyikiknaha. Hokbowy tisapyrẽta inarokota. Iekbyrita anaeze kytsa bo okyrysaro ziknazapykyky. Kytsa Deus wahoro bo ziknapupukunahaze okyrysaro ziknazapyky. ");
INSERT INTO rkbNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Iekbyrita Peduru, Suão ahatsa bo iktsa niy. Deus wahoro bo inapupunahaze iktsa niy. ");
INSERT INTO rkbNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Iwaze Peduru pe niy: — Okyrysaro ty kabo nynytykta — niy. Peduru ipe niy: — Mybo iktsaziu tykta — niy. ");
INSERT INTO rkbNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Iekbyrita sibo nikozotoktok — O okyrysaro ty ja kabo nyny maha iky — mytsaty nikara. ");
INSERT INTO rkbNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Peduru ipe niy: — Batu kaokyrysaroko — niy. Utakta Deus zikwy humo ape my: — Kyiktykta Sesus humo kyiktykta. Atahi Nasare ezekta humo pãotykta — Peduru niy. ");
INSERT INTO rkbNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Niytahi Peduru iekbyrita tsyhyrype humo paik niy. Tykyik niy. Atsoko ipyrybotoziktsa niaksutsukbaiknaha nizororobaiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Iwatahi paikpa nipupuruku. Niytahi Deus wahoro zubata isturupeze situk zitabakanaha. Iwatahi tsakurẽta nikara paikpa nipupuruku. Nitsasoko — O Deus ikia hi tsamysapyrẽta — nikara. ");
INSERT INTO rkbNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Myzubaha okze nipurukze ibo nikozokonahaze nitsasokonaha — O Deus ikia hi tsamysapyrẽta — nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Asa zuba nipamykysokonaha: — Ata maku iekbyrita hi sa — nikaranaha. — Yhỹ. Atahi Deus wahoro zubata hokbowy eze ziknadyhykyta. Hokbowy isapyrẽnikita inarokota niy. Okyrysaro mybo ziknazapyikik tahi ja — nikaranaha. — Hawa sa niy — nikaranaha. Paikpa iktsa nikaranaha. Iekbyrita zororowy humo nipybybaiknaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Tapara iekbyrita Peduru tuk niapykyk tsihikik. Paikpa nikara. Peduru, Suão taparaka iekbyrita ahatsa nikaranaha. Peduru Suão Deus wahoro zubata zikarazik bo nipupunaha. Kytsa anahi Soromao wahoro inarokota. ");
INSERT INTO rkbNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Peduru zinyze sizubarẽtsa izumubanaha sibo nipamykysoko: — O Isareu ezektsa katukytsa wabyziutaha! Amo skaraba mybo paikpa iktsa tsimykaranaha. Atahi pitabaka mozikwy humo ja mytsaty tsimykaranaha. Atahi pitabaka katsa mysapyrẽtsa humo ja iwa mytsaty tsimykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Batu ba. Nawa ahabo batu hỹ tsikaha. Deus taparaktsa mydiritsa tuk ziknapykyk. Deus taparakta mydiri Abarão tuk niy, Deus taparakta mydiri Isake tuk niy, Deus taparakta mydiri Sako tuk niy, atahi kytsa mytsatytaha my. Sesus myhyrizikwanita niyzik. Ikiahatsa hi sisukyrytsitsa bo itsipa humo tsikzioktyhyryknaha. Piratus sakyriukrẽnikitsa hurukwy ikny nizukekyzyky. ");
INSERT INTO rkbNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ikiahatsa batu ba. Sesus imysapyrẽnikita. Atahi Deus harere bo hyỹ ziknakara. Piratus okzeka ahamyhareresapybyikitsa tsikykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ikiahatsa Bahabas kytsa bakatsa sakyriukrẽnikitsa hurukwy ezetu tsipisuke tsihikiknaha. Atakta mybarawytsa hi tsibezehiknaha. Deus hi zihyrizikpowy. Ispituzoze tsinynaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Iwatahi ikiahatsa bo tsimytsasokonaha. Abaka taparaka iekbyrita tu tsimykozokonaha Deus hi zizororowy. Sesus humo myspirikporẽtsa. Iwatsahi ikiahatsa okze tu zizororowy. ");
INSERT INTO rkbNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Abaka katukytsa ikiahatsa batu ahahyrinymyry. Sesus tsibezehiknahaze Sesus Deus tse humo batu ahahyrinymyry. Taparaktsa kino niwatihi, Sesus Deus tse humo batu sihyrinymyry ");
INSERT INTO rkbNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Tubabatu Deus sohokotsa nitsasokonaha, “Kiristu sinini mykara” nikaranaha. Deus humo iwa nitsasokonaha. Abaka anatyhi atsatu nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ikiahatsa ahamysapybyri tsimoewybanahaktsa! Deus bo tsimypamykysonaha. Iwatahi ahamysapybyitsa tsikykaranaha Deus pahaokzohik. ");
INSERT INTO rkbNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Iwa tsimykaranaha zeka ahakurẽtsa tsimoziknaha. Deus pahahyrizikwyky. Hawa myarapukrẽtsa zeka tsipikukunahaze mykurẽtsazo tsimoziknaha. Deus ahamysapybyitsa tsikykaranaha pahaokzohik zeka ikiahatsa ahakurẽtsa tsimoziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Bykyze Deus Sesus myzipehazo. Deus ziwatawyta ahapehatsa mozik. Aba bijoikpe eze tu mynapykyryk niy. Bykyze Deus Sesus mybarawy bo myzipehazo. Niytahi Deus nanabyi humo piharabokzo. Iwaze Deus harere sohokotsitsa botu nikaranaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Tubabatu nihyrikosokdata Moises hi: — Deus sohokotsa ikiahatsa bo myzipeha. Atahi Deus harere ahabo motsasoko. Kawata zipeha. Nawaze maku sohokotsa myzipeha. Iharere bo wabytaha! Iharere humo hyỹ tsimykaranaha. Iwaze tubabatu nihyrikosokdata Moises nitsasoko — Peduru niy. ");
INSERT INTO rkbNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Tubabatu nihyrikosokdata Moises nitsasoko: — Asahi kaharere bo batu hỹ mykaranaha. Asahi mopyknaha. Batu katyryktsa tuka hudikhudik zikaha iwatsahi mekybotu mytahasapynaha. Deus harere sohokotsitsa sizubarẽtsa astsatu ziknapamykysokonaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Bykyze ustsa Deus sohokotsitsa atsatu ziknapamykysokonaha. Nihyrikosokdata Samue kino niwatihi atsatu ziknapamykysoko. Zinapamykysokonahaze aba kino anatyhi mykaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ikiahatsa taparaktsa Deus harere sohokotsa sitsekokatsa wa. Deus harere taparaktsa bo nitsasokonaha. Taparakta mydiri Abarão niy. Ikiahatsa taparakta Abarão tsekokatsa hi. Iwatahi Deus harere ahabo nitsasoko. Deus tihi: “Aparakbaha itsekokatsa humo pisapywyky” niy. ");
INSERT INTO rkbNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Iwaze Deus tatse Sesus ahabo izipeha. Iwatsahi ahamysapybyi ka tsimoewybanaha. Deus aha humo pisapywytsihikik — Peduru niy. Iwaze Peduru myzubaha bo nipamykysoko. Iwatsahi sizubarẽtsa ana humo hi tahaku ziwabykynaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Peduru myzubaha bo nipamykysokoze ziknapamykysokonahatsitsa sibo zumukunaha. Suão zitsumuẽhĩkĩ iwaze kytsa sibo zumukunaha. Wastuhu ziknapamykysokonahatsitsa, taparaktsa Deus wahoro eze ustsa Sadusitsitsa iwatsa sibo zumukunaha. Peduru Suão ahatsa humo tahakyrikinaha. Siharere batu siakparawy iwatsahi tahakyrikinaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Peduru kytsa nisihyrinymyryky. Sesus inahyrizikpo iwatsahi katsa kino niwatihi tsimyhyrikosokdanahaze tsimonahyrikpozonaha. Iwa Suão Peduru ahatsa nitsasokonaha ana humo hi tahakyrikinaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Sitsipatsa humo nisioktyhyryknaha. Sakyriukrẽnikitsa hurukwy bo nisihurukiknaha. Nubaze anaeze unata eze nisihurukikarenaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Kytsa sizubarẽtsa siharere ziwabykynahaze Sesus harere bo hyỹ nikaranaha. Sizubarẽtsa myobarakanaha. Aba Sesus tuktsa sĩko miutsa niyziknaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Estuba zurunahaze Serusarẽhe ezektsa taparaktsa kapitaõtsa wa tsa sihyrinymyrytsitsa Moises harere soho, iwatsa Serusarẽhe bo izumubanaha kytsawabytsitsa izumubanaha ");
INSERT INTO rkbNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anas niwatihi izumu. Taparakta ziknapamykysokonahatsitsa tuk Kajapas, Aresãdere, Suão ustsa taparakta tukytsa iwatsa izumubanaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Iwaze Peduru Suão ahatsa nasioktyhyknaha. Asa tihi: — Ikiahatsa myokeryk riktotaha! — niaha. Niytahi estuba tihi: — Aty zikwy humo sa iekbyrita tsizororowynaha. Aty sa tazikwy ty ahabo nyny niy iwatahi maku tsizororowy — niy. ");
INSERT INTO rkbNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Niytahi Peduru Deus hyrikoso humo tsiharereziurẽta niyzik iwaze taparaktsa pe niy: — O taparaktsa kapitaõtsa watsa myhudikhudikwy mype. ");
INSERT INTO rkbNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","“Hawa sa iekbyrita tsizororowy” nikaranaha. Tsipinymyry tsihikiknaha ja ");
INSERT INTO rkbNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Mopamykysoko. Sesus zikwy humo izororowy. Nasare ezekta humo izororowy. Ikiahatsa Sesus iharapatawyhyta humo tsihyrizikiknaha. Deus hi zihyrizikpowy. Iwatahi iekbyrita ahabaze niriktohoko. Deus harere botu ziwataha Sesus soho my. ");
INSERT INTO rkbNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","“Harahare batu sapy mytsaty ahabyitsa tsimykaranaha taharahare kino ipamabikia mozik.” Ziwatahakaze Sesus harahare wata niy. Atahi batu imysapy kytsa mytsaty ahabyitsa nikaranaha, atahi myhyrizikwani niyzik. ");
INSERT INTO rkbNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Atahi myzubaha humo mymysapywyky. Atahi zuba Deus bo mymyoktyhyryk. Ustsaktsa batu zikaha. Sesus zuba Deus bo myzubaha mymyoktyhyryk iwaze simysapyrẽtsa moziknaha. Ihumo sizubarẽtsa mysizororowy iwatsahi simysapyrẽtsa moziknaha — niy. ");
INSERT INTO rkbNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Iwa Peduru Sudeutsa taparaktsa bo nitsasoko. Taharere humo batu isikpyby, iwatsahi taparaktsa paikpa iktsa nikaranaha. Taha bo zuba mytsaty nikaranaha: — Amo sa atakta batu isikpyby mybo nipamykysoko. Peduru, Suão ahatsa papeu humo tsikaeni zuba sihyrinymyry. Sinamybyitsa asahi Sesus tuk zikzurukunaha — mytsaty nikaranaha. ");
INSERT INTO rkbNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Taparaka niekbyrita tu sibaze niriktohoko. Iwatsahi tapara