﻿USE sofia;
DROP TABLE IF EXISTS sofia.rift_vpl;
CREATE TABLE rift_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES rift_vpl WRITE;
INSERT INTO rift_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","ⴷⴻⴳ ⵓⵎⴻⵣⵡⴰⵔⵓ ⵉⵅⵍⴻⵇ-ⴷⴷ ⴰⵔⴻⴱⴱⵉ ⵉⵊⴻⵏⵡⴰⵏ ⴷ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","ⵜⵓⵖⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵜⴻⵅⵍⴰ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵡⴰⵔ ⵜⵜ ⵉⵜⵜⵃⵉⴷⵉ ⵃⴻⴷ ⵓ ⵅ ⵡⵓⴷⴻⵎ ⵏ ⵡⴰⵎⴰⵏ ⵉⵀⴻⵡⵍⴻⵏ ⵜⴰⴵⴻⵙⵜ, ⵓ ⴰⵔⵔⵓⵃ ⵏ ⴰⵔⴻⴱⴱⵉ ⵜⵓⵖⴰ ⵉⵜⵜⵔⴰⵃ ⵉⵜⵜⴰⵙ-ⴷⴷ ⵅ ⵡⵓⴷⴻⵎ ⵏ ⵡⴰⵎⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","ⵓⵛⴰ ⵉⵏⵏⴰ ⴰⵔⴻⴱⴱⵉ: “ⴰⴷ ⵜⵉⵍⵉ ⵜⴼⴰⵡⵜ”, ⵓⵛⴰ ⵜⵓⵙⴰ-ⴷⴷ ⵜⴼⴰⵡⵜ! ");
INSERT INTO rift_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","ⵉⵥⵔⴰ ⴰⵔⴻⴱⴱⵉ ⴱⴻⵍⵍⵉ ⵜⴰⴼⴰⵡⵜ ⵜⴻⵚⴱⴻⵃ ⵓⵛⴰ ⵉⴱⴹⴰ ⴰⵔⴻⴱⴱⵉ ⵊⴰⵔ ⵜⴼⴰⵡⵜ ⴷ ⵜⴰⴵⴻⵙⵜ. ");
INSERT INTO rift_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","ⵉⵍⴰⵖⴰ ⴰⵔⴻⴱⴱⵉ ⵜⴰⴼⴰⵡⵜ ‘ⴰⵣⵉⵍ’ ⵓ ‘ⵜⴰⴵⴻⵙⵜ’ ⵉⵍⴰⵖⴰ ⴰⵙ ‘ⴵⵉⵍⴻⵜ’. ⵜⴻⴷⵡⴻⵍ ⴷ ⵜⴰⵎⴻⴷⴷⵉⵜ ⵓ ⵉⴷⵡⴻⵍ ⴷ ⵚⵚⴱⴻⵃ: ⴷ ⴰⵙⵙ ⴰⵎⴻⵣⵡⴰⵔⵓ. ");
INSERT INTO rift_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","ⵓⵛⴰ ⵉⵏⵏⴰ ⴰⵔⴻⴱⴱⵉ: “ⴰⴷ ⵜⵉⵍⵉ ⵉⵛⵜ ⵏ ⵍⵇⵓⴱⴱⴻⵜ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏ ⵡⴰⵎⴰⵏ, ⴰⴷ ⵜⴻⴱⴹⴰ ⴰⵎⴰⵏ ⵅ ⵡⴰⵎⴰⵏ!” ");
INSERT INTO rift_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","ⴰⵔⴻⴱⴱⵉ ⵉⴳⴳⴰ ⵍⵇⵓⴱⴱⴻⵜ ⵏ ⵓⵊⴻⵏⵏⴰ ⵓⵛⴰ ⵉⴱⴹⴰ ⴰⵎⴰⵏ ⵉ ⵉⴵⴰⵏ ⵙⵡⴰⴷⴷⴰⵢ ⵉ ⵍⵇⵓⴱⴱⴻⵜ ⵅ ⵡⴰⵎⴰⵏ ⵉ ⵉⴵⴰⵏ ⵙⴻⵏⵏⴻⵊ ⵉ ⵍⵇⵓⴱⴱⴻⵜ. ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⵜⴻⵎⵙⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","ⵉⵍⴰⵖⴰ ⴰⵔⴻⴱⴱⵉ ⵉ ⵍⵇⵓⴱⴱⴻⵜ ‘ⴰⵊⴻⵏⵏⴰ’. ⵓⵛⴰ ⵜⴻⴷⵡⴻⵍ ⴷ ⵜⴰⵎⴻⴷⴷⵉⵜ ⵓ ⵉⴷⵡⴻⵍ ⴷ ⵚⵚⴱⴻⵃ: ⴷ ⴰⵙⵙ ⵡⵉⵙⵙ ⵜⵏⴰⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","ⵓⵛⴰ ⵉⵏⵏⴰ ⴰⵔⴻⴱⴱⵉ: “ⴰⴷ ⵎⵓⵏⴻⵏ ⵡⴰⵎⴰⵏ ⵉ ⵉⴵⴰⵏ ⵙⵡⴰⴷⴷⴰⵢ ⵉ ⵓⵊⴻⵏⵏⴰ ⵖⴰⵔ ⵉⵊⵊ ⵏ ⵡⴻⵎⵛⴰⵏ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴷⴷ-ⵉⴱⴰⵏ ⵍⴱⴰⵔⵔ!” ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⵜⴻⵎⵙⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","ⵉⵍⴰⵖⴰ ⴰⵔⴻⴱⴱⵉ ⵉ ⵍⴱⴰⵔⵔ ‘ⵜⴰⵎⵎⵓⵔⵜ’ ⵓ ⴰⵎⵓⵏⵉ ⵏ ⵡⴰⵎⴰⵏ ⵉⵍⴰⵖⴰ ⴰⵙ ‘ⵍⴻⴱⵃⵓⵔ’. ⵓⵛⴰ ⵉⵥⵔⴰ ⴰⵔⴻⴱⴱⵉ ⴱⴻⵍⵍⵉ ⵎⴰⵏ ⴰⵢⴰ ⵉⵚⴱⴻⵃ. ");
INSERT INTO rift_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","ⵓⵛⴰ ⵉⵏⵏⴰ ⴰⵔⴻⴱⴱⵉ: “ⴰⴷ ⴷⴷ-ⵜⴻⵙⵙⴻⵖⵎⵉ ⵜⴻⵎⵎⵓⵔⵜ ⴰⵖⴻⵎⵎⵓⵢ ⴰⵣⵉⵣⴰ: ⴰⴼⵙⵓ ⴰⵣⵉⵣⴰ ⵉ ⵉⵣⴰⵔⵔⵄⴻⵏ ⵣⵣⴰⵔⵉⵄⴻⵜ ⴷ ⵜⵛⴻⵊⵊⵓⵔⴰ ⵙ ⴼⵔⵓⵜⴰ ⵉ ⴷⴷ ⵉⵜⵜⵉⵛⴻⵏ ⴼⵔⵓⵜⴰⵜ ⵄⵍⴰⵃⵙⴰⴱ ⵎⴰⵔⴽⴰ ⵏⵙⴻⵏⵜ ⵙ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵙⴻⵏⵜ ⴷⴰⵢⴻⵙ ⵅ ⵡⵓⴷⴻⵎ ⵏ ⵜⴻⵎⵎⵓⵔⵜ!” ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⵜⴻⵎⵙⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","ⵜⴻⵙⵙⴻⵖⵎⵉ-ⴷⴷ ⵜⴻⵎⵎⵓⵔⵜ ⴰⵖⴻⵎⵎⵓⵢ ⴰⵣⵉⵣⴰ: ⴰⴼⵙⵓ ⴰⵣⵉⵣⴰ ⵉ ⵉⵣⴰⵔⵔⵄⴻⵏ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵄⵍⴰⵃⵙⴰⴱ ⵎⴰⵔⴽⴰ ⵏⵏⴻⵙ ⴷ ⵜⵛⴻⵊⵊⵓⵔⴰ ⵉ ⴷⴷ ⵉⵜⵜⵉⵛⴻⵏ ⵍⵖⵉⴵⴻⵜ ⵄⵍⴰⵃⵙⴰⴱ ⵎⴰⵔⴽⴰ ⵏⵙⴻⵏⵜ ⵙ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵙⴻⵏⵜ ⴷⴰⵢⴻⵙ. ⵓⵛⴰ ⵉⵥⵔⴰ ⴰⵔⴻⴱⴱⵉ ⴱⴻⵍⵍⵉ ⵎⴰⵏ ⴰⵢⴰ ⵉⵚⴱⴻⵃ. ");
INSERT INTO rift_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","ⵓⵛⴰ ⵜⴻⴷⵡⴻⵍ ⴷ ⵜⴰⵎⴻⴷⴷⵉⵜ ⵓ ⵉⴷⵡⴻⵍ ⴷ ⵚⵚⴱⴻⵃ: ⴷ ⴰⵙⵙ ⵡⵉⵙⵙ ⵜⵍⴰⵜⴰ. ");
INSERT INTO rift_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","ⵓⵛⴰ ⵉⵏⵏⴰ ⴰⵔⴻⴱⴱⵉ: “ⴰⴷ ⴷⵉⵏ ⵉⵍⵉⵏⵜ ⵜⴼⴰⵡⵉⵏ ⴷⵉ ⵍⵇⵓⴱⴱⴻⵜ ⵏ ⵓⵊⴻⵏⵏⴰ ⵃⵉⵎⴰ ⴰⴷ ⴱⴹⴰⵏⵜ ⵊⴰⵔ ⵡⴰⵙⵙ ⴷ ⴵⵉⵍⴻⵜ, ⴰⴷ ⵉⵍⵉⵏⵜ ⴷ ⵍⵉⵎⴰⵔⴰⵜ, ⴷ ⵡⵓⵙⵙⴰⵏ ⵉⵜⵜⵡⴰⴳⴳⴻⵏ, ⴷ ⵡⵓⵙⵙⴰⵏ, ⴷ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ");
INSERT INTO rift_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ⵓⵛⴰ ⴰⴷ ⵉⵍⵉⵏⵜ ⴷ ⵜⵉⴼⴰⵡⵉⵏ ⴷⵉ ⵍⵇⵓⴱⴱⴻⵜ ⵏ ⵓⵊⴻⵏⵏⴰ ⵃⵉⵎⴰ ⴰⴷ ⵡⵛⴻⵏⵜ ⵜⴰⴼⴰⵡⵜ ⵅ ⵜⴻⵎⵎⵓⵔⵜ!” ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⵜⴻⵎⵙⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","ⵉⴳⴳⴰ ⴰⵔⴻⴱⴱⵉ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵉⴼⴰⵡⵉⵏ ⵎⵖⴰⵔⴻⵏⵜ, ⵜⴰⴼⴰⵡⵜ ⵜⴰⵎⴻⵇⵇⵔⴰⵏⵜ, ⵃⵉⵎⴰ ⴰⴷ ⵜⴻⵃⴽⴻⵎ ⵅ ⵓⵣⵉⵍ, ⵓ ⵜⴰⴼⴰⵡⵜ ⵜⴰⵎⴻⵥⵢⴰⵏⵜ ⵃⵉⵎⴰ ⴰⴷ ⵜⴻⵃⴽⴻⵎ ⵅ ⴵⵉⵍⴻⵜ, ⵓⵛⴰ ⵓⵍⴰ ⴷ ⵉⵜⵔⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","ⵉⵙⵙⴰⵔⵙ ⵉ-ⵜⴻⵏⵜ ⴰⵔⴻⴱⴱⵉ ⴷⵉ ⵍⵇⵓⴱⴱⴻⵜ ⵏ ⵓⵊⴻⵏⵏⴰ ⵃⵉⵎⴰ ⴰⴷ ⵡⵛⴻⵏⵜ ⵜⴰⴼⴰⵡⵜ ⵅ ⵜⴻⵎⵎⵓⵔⵜ ");
INSERT INTO rift_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ⵓ ⵃⵉⵎⴰ ⴰⴷ ⵃⴻⴽⵎⴻⵏⵜ ⵅ ⵡⴰⵙⵙ ⴷ ⴵⵉⵍⴻⵜ ⵓ ⵃⵉⵎⴰ ⴰⴷ ⴱⴹⴰⵏⵜ ⵊⴰⵔ ⵜⴼⴰⵡⵜ ⴷ ⵜⴰⴵⴻⵙⵜ. ⵓⵛⴰ ⵉⵥⵔⴰ ⴰⵔⴻⴱⴱⵉ ⴱⴻⵍⵍⵉ ⵎⴰⵏ ⴰⵢⴰ ⵉⵚⴱⴻⵃ. ");
INSERT INTO rift_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","ⵓⵛⴰ ⵜⴻⴷⵡⴻⵍ ⴷ ⵜⴰⵎⴻⴷⴷⵉⵜ ⵓ ⵉⴷⵡⴻⵍ ⴷ ⵚⵚⴱⴻⵃ: ⴷ ⴰⵙⵙ ⵡⵉⵙⵙ ⴰⵔⴻⴱⵄⴰ. ");
INSERT INTO rift_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","ⵓⵛⴰ ⵉⵏⵏⴰ ⴰⵔⴻⴱⴱⵉ: “ⴰⴷ ⴷⴷ-ⵙⵙⴻⴼⵢⴻⵏ ⵡⴰⵎⴰⵏ ⵙ ⵡⴰⵟⵟⴰⵙ ⵏ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴷⵉ ⵉⴵⴰ ⴱⵓⵃⴱⴻⵍ ⵉⴷⴷⴰⵔⴻⵏ ⵓⵛⴰ ⴰⴷ ⴹⵡⴻⵏ ⵉⵊⴹⴰⴹ ⵙⴻⵏⵏⴻⵊ ⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵖⴰⵔ ⵎⴰⵏⵉ ⵜⴻⴵⴰ ⵍⵇⵓⴱⴱⴻⵜ ⵏ ⵓⵊⴻⵏⵏⴰ!” ");
INSERT INTO rift_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","ⵉⵅⵍⴻⵇ-ⴷⴷ ⴰⵔⴻⴱⴱⵉ ⵉⵎⵓⴷⴷⴰⵔⴻⵏ ⵉⵎⴻⵇⵇⵔⴰⵏⴻⵏ ⴷⵉ ⵍⴻⴱⵃⴰⵔ ⵓ ⵎⴰⵔⵔⴰ ⴱⵓⵃⴱⴻⵍ ⵉⴷⴷⴰⵔⴻⵏ ⵉⵜⵜⴻⵏⵀⴻⵣⵣⴰⵏ, ⵉⵏⵏⵉ ⵣⵉ ⴷⴷ-ⵙⵙⴻⴼⵢⴻⵏ ⵡⴰⵎⴰⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵎⴰⵔⴽⴰ ⵏⵙⴻⵏ ⵓⵛⴰ ⵎⴰⵔⵔⴰ ⵉⵊⴹⴰⴹ ⵙ ⵡⴰⴼⵔⵉⵡⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵎⴰⵔⴽⴰ ⵏⵙⴻⵏ. ⵓⵛⴰ ⵉⵥⵔⴰ ⴰⵔⴻⴱⴱⵉ ⴱⴻⵍⵍⵉ ⵎⴰⵏ ⴰⵢⴰ ⵉⵚⴱⴻⵃ. ");
INSERT INTO rift_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","ⵉⴱⴰⵔⴽ ⵉ-ⵜⴻⵏ ⴰⵔⴻⴱⴱⵉ, ⵉⵏⵏⴰ: “ⵊⵊⴻⵎ-ⴷⴷ ⵍⵖⵉⴵⴻⵜ, ⴽⵜⴰⵔⴻⵎ, ⵄⴻⵎⵎⴰⵔⴻⵎ ⴰⵎⴰⵏ ⵏ ⵍⴻⴱⵃⵓⵔ ⵓⵛⴰ ⴰⴷ ⴽⵜⴰⵔⴻⵏ ⵉⵊⴹⴰⴹ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ.” ");
INSERT INTO rift_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","ⵓⵛⴰ ⵜⴻⴷⵡⴻⵍ ⴷ ⵜⴰⵎⴻⴷⴷⵉⵜ ⵓ ⵉⴷⵡⴻⵍ ⴷ ⵚⵚⴱⴻⵃ: ⴷ ⴰⵙⵙ ⵡⵉⵙⵙ ⵅⴻⵎⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","ⵓⵛⴰ ⵉⵏⵏⴰ ⴰⵔⴻⴱⴱⵉ: “ⴻⵊⵊ ⵜⴻⵎⵎⵓⵔⵜ ⴰⴷ ⵜⴻⵙⵙⵓⴼⴼⴻⵖ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵖⴰⵔⴻⵙ ⴱⵓⵃⴱⴻⵍ ⵉⴷⴷⴰⵔⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵎⴰⵔⴽⴰ ⵏⵏⴻⵙ: ⵍⴻⴱⵀⴰⵢⴻⵎ ⴷ ⵉⵎⵓⴷⴷⴰⵔⴻⵏ ⵏⵏⵉ ⵉⵜⵜⴱⵓⵄⴻⵏ ⴷ ⵍⵎⴰⵍ ⵏ ⵍⴻⵅⵍⴰ ⵄⵍⴰⵃⵙⴰⴱ ⵎⴰⵔⴽⴰ ⵏⵙⴻⵏ!” ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⵜⴻⵎⵙⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","ⵉⴳⴳⴰ ⴰⵔⴻⴱⴱⵉ ⵍⵎⴰⵍ ⵏ ⵍⴻⵅⵍⴰ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵄⵍⴰⵃⵙⴰⴱ ⵎⴰⵔⴽⴰ ⵏⵙⴻⵏ, ⵓ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵄⵍⴰⵃⵙⴰⴱ ⵎⴰⵔⴽⴰ ⵏⵙⴻⵏⵜ ⵓ ⵎⴰⵔⵔⴰ ⵉⵎⵓⴷⴷⴰⵔⴻⵏ ⵏⵏⵉ ⵉⵜⵜⴱⵓⵄⴻⵏ ⵅ ⵡⵓⴷⴻⵎ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵄⵍⴰⵃⵙⴰⴱ ⵎⴰⵔⴽⴰ ⵏⵙⴻⵏ. ⵓⵛⴰ ⵉⵥⵔⴰ ⴰⵔⴻⴱⴱⵉ ⴱⴻⵍⵍⵉ ⵎⴰⵏ ⴰⵢⴰ ⵉⵚⴱⴻⵃ. ");
INSERT INTO rift_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","ⵓⵛⴰ ⵉⵏⵏⴰ ⴰⵔⴻⴱⴱⵉ: “ⴻⵊⵊ ⴰⵏⴻⵖ ⴰⴷ ⵏⴻⴳⴳ ⴰⴷⴰⵎ, ⴱⵏⴰⴷⴻⵎ ⴷⵉ ⵚⵚⵉⴼⴻⵜ ⵏⵏⴻⵖ, ⴷⴻⴳ ⵡⴰⵔⵡⴰⵙ ⵏⵏⴻⵖ, ⵓⵛⴰ ⴰⴷ ⵖⴰⵔⴻⵙ ⵢⵉⵍⵉ ⵊⵊⴻⵀⴷ ⵅ ⵉⵙⴻⵍⵎⴰⵏ ⵏ ⵍⴻⴱⵃⴰⵔ ⵓ ⵅ ⵉⵊⴹⴰⴹ ⵏ ⵓⵊⴻⵏⵏⴰ ⵓ ⵅ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵓ ⵅ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵓ ⵅ ⵎⴰⵔⵔⴰ ⵉⵎⵓⴷⴷⴰⵔⴻⵏ ⵏⵏⵉ ⵉⵜⵜⴱⵓⵄⴻⵏ ⵅ ⵜⴻⵎⵎⵓⵔⵜ!” ");
INSERT INTO rift_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","ⵉⵅⵍⴻⵇ-ⴷⴷ ⴰⵔⴻⴱⴱⵉ ⴰⴷⴰⵎ ⴷⵉ ⵚⵚⵉⴼⴻⵜ ⵏⵏⴻⵙ. ⵉⵅⵍⴻⵇ ⵉ-ⵜ-ⵉ-ⴷⴷ ⴷⵉ ⵚⵚⵉⴼⴻⵜ ⵏ ⴰⵔⴻⴱⴱⵉ, ⵉⵅⵍⴻⵇ ⵉ-ⵜⴻⵏ-ⴷⴷ ⴰⵡⵜⴻⵎ ⴷ ⵜⴻⵡⵜⴻⵎⵜ. ");
INSERT INTO rift_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","ⵉⴱⴰⵔⴽ ⵉ-ⵜⴻⵏ ⴰⵔⴻⴱⴱⵉ ⵓⵛⴰ ⵉⵏⵏⴰ ⴰⵙⴻⵏ ⴰⵔⴻⴱⴱⵉ: “ⵊⵊⴻⵎ-ⴷⴷ ⵍⵖⵉⴵⴻⵜ, ⴽⵜⴰⵔⴻⵎ, ⵄⴻⵎⵎⴰⵔⴻⵎ ⵜⴰⵎⵎⵓⵔⵜ ⵓⵛⴰ ⴰⵔⵔⴻⵎ ⵜⵜ ⵙⴰⴷⵓ ⵓⴼⵓⵙ ⵏⵡⴻⵎ, ⵃⴻⴽⵎⴻⵎ ⵅ ⵉⵙⴻⵍⵎⴰⵏ ⵏ ⵍⴻⴱⵃⴰⵔ ⵓ ⵅ ⵉⵊⴹⴰⴹ ⵏ ⵓⵊⴻⵏⵏⴰ ⵓ ⵅ ⵎⴰⵔⵔⴰ ⵉⵎⵓⴷⴷⴰⵔⴻⵏ ⵏⵏⵉ ⵉⵜⵜⴱⵓⵄⴻⵏ ⵅ ⵜⴻⵎⵎⵓⵔⵜ!” ");
INSERT INTO rift_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","ⵉⵏⵏⴰ ⴰⵔⴻⴱⴱⵉ: “ⵅⵣⴰⵔⴻⵎ, ⴰⴷ ⴰⵡⴻⵎ ⵡⵛⴻⵖ ⵎⴰⵔⵔⴰ ⴰⴼⵙⵓ ⴰⵣⵉⵣⴰ ⵉ ⵉⵣⴰⵔⵔⵄⴻⵏ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵅ ⵎⴰⵔⵔⴰ ⵡⵓⴷⴻⵎ ⵏ ⵜⴻⵎⵎⵓⵔⵜ, ⵓⵍⴰ ⴷ ⵎⴰⵔⵔⴰ ⵜⵉⵛⴻⵊⵊⵓⵔⴰ ⵙ ⵍⵖⵉⴵⴻⵜ ⵏⵏⵉ ⵉⵣⴰⵔⵔⵄⴻⵏ ⵣⵣⴰⵔⵉⵄⴻⵜ. ⵎⴰⵏ ⴰⵢⴰ ⴰⴷ ⴰⵡⴻⵎ ⵢⵉⵍⵉ ⴷ ⵎⴰⵛⵛⴰ.    ");
INSERT INTO rift_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","ⵓ ⵉ ⵎⴰⵔⵔⴰ ⵍⵎⴰⵍ ⵏ ⵍⴻⵅⵍⴰ ⵏ ⵜⴻⵎⵎⵓⵔⵜ, ⵓ ⵉ ⵎⴰⵔⵔⴰ ⵉⵊⴹⴰⴹ ⵏ ⵓⵊⴻⵏⵏⴰ ⵓ ⵉ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⵜⵜⴱⵓⵄⴻⵏ ⵅ ⵜⴻⵎⵎⵓⵔⵜ ⵉ ⴷⵉ ⵉⴵⴰ ⴱⵓⵃⴱⴻⵍ ⵉⴷⴷⴰⵔⴻⵏ, ⴰⴷ ⴰⵙⴻⵏ ⵢⵉⵍⵉ ⵎⴰⵔⵔⴰ ⴰⴼⵙⵓ ⴰⵣⵉⵣⴰ ⴷ ⵎⴰⵛⵛⴰ ⵉ ⵏⵉⵜⵏⵉ.” ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⵜⴻⵎⵙⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","ⵓⵛⴰ ⵉⵥⵔⴰ ⴰⵔⴻⴱⴱⵉ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⴳⴳⴰ, ⵓ ⵅⵣⴰⵔ, ⵜⵓⵖⴰ ⵉⵚⴱⴻⵃ ⴰⵟⵟⴰⵙ. ⵜⴻⴷⵡⴻⵍ ⴷ ⵜⴰⵎⴻⴷⴷⵉⵜ ⵓ ⵉⴷⵡⴻⵍ ⴷ ⵚⵚⴱⴻⵃ: ⴷ ⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⵜⵜⴰ. ");
INSERT INTO rift_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","ⴰⵎⵎⵓ ⵉ ⵜⵜⵡⴰⴽⴻⵎⵎⵍⴻⵏ ⵉⵊⴻⵏⵡⴰⵏ ⴷ ⵜⴻⵎⵎⵓⵔⵜ ⴷ ⵇⴰⵄ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ ⵉⴽⴻⵎⵎⴻⵍ ⴰⵔⴻⴱⴱⵉ ⵍⵅⴻⴷⵎⴻⵜ ⵏⵏⴻⵙ ⵉ ⵉⴳⴳⴰ ⵓⵛⴰ ⵢⴰⵔⴻⵢⵢⴻⵃ ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ ⵣⵉ ⵎⴰⵔⵔⴰ ⵍⵅⴻⴷⵎⴻⵜ ⵏⵏⴻⵙ ⵉ ⵉⴳⴳⴰ. ");
INSERT INTO rift_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","ⵉⴱⴰⵔⴻⴽ ⴰⵔⴻⴱⴱⵉ ⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ ⵓⵛⴰ ⵉⵙⵙⵇⴻⴷⴷⴻⵙ ⵉ-ⵜ, ⵎⵉⵏⵣⵉ ⴷⴰⵢⴻⵙ ⵉ ⵢⴰⵔⴻⵢⵢⴻⵃ ⵣⵉ ⵎⴰⵔⵔⴰ ⵍⵅⴻⴷⵎⴻⵜ ⵏⵏⴻⵙ, ⵍⵅⴻⴷⵎⴻⵜ ⵉ ⴷⴷ-ⵉⵅⵍⴻⵇ ⴰⵔⴻⴱⴱⵉ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⵜ ⵉⴳⴳ ⴰⵎⴻⵏⵏⵉ. ⵉⵏⴰ ⴷ ⵉⵎⴻⵣⵔⵓⵢⴻⵏ ⵏ ⵡⴻⵅⵍⴰⵇ ⵏ ⵓⵊⴻⵏⵏⴰ ⴷ ⵜⴻⵎⵎⵓⵔⵜ ⵍⴰⵎⵉ ⴷⴷ-ⵜⵜⵡⴰⵅⴻⵍⵇⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","ⴷⴻⴳ ⵡⴰⵙⵙ ⵉ ⵉⴳⴳⴰ ⵙⵉⴷⵉ ⴰⵔⴻⴱⴱⵉ ⵜⴰⵎⵎⵓⵔⵜ ⴷ ⵉⵊⴻⵏⵡⴰⵏ ");
INSERT INTO rift_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","- ⵇⴱⴻⵍ ⵜⵓⵖⵉ ⴷⵉⵏ ⵎⴰⵔⵔⴰ ⵛⴱⴰⵔⵇ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵓ ⵇⴱⴻⵍ ⴷⴷ-ⵉⵖⵎⵉ ⵡⴻⴼⵙⵓ ⵏ ⵢⴻⵢⵢⴰⵔ, ⵎⵉⵏⵣⵉ ⵙⵉⴷⵉ ⴰⵔⴻⴱⴱⵉ ⵡⴰⵔ ⵉⵊⵊⵉ ⴰⵏⵥⴰⵔ ⴰⴷ ⵉⵡⵡⴻⵜ ⵄⴰⴷ ⵅ ⵜⴻⵎⵎⵓⵔⵜ - ⵓⵛⴰ ⵡⴰⵔ ⵜⵓⵖⵉ ⴷⵉⵏ ⴰⴷⴰⵎ ⵄⴰⴷ ⵃⵉⵎⴰ ⴰⴷ ⵉⵅⴷⴻⵎ ⵜⴰⵎⵎⵓⵔⵜ, ");
INSERT INTO rift_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","ⵜⴳⴻⵄⵄⴻⴷ-ⴷⴷ ⵜⴰⵢⵢⵓⵜ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ, ⵜⴻⵙⵙⵓ ⵎⴰⵔⵔⴰ ⵓⴷⴻⵎ ⵏ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","ⵓⵛⴰ ⵉⴽⴻⵡⵡⴻⵏ ⵙⵉⴷⵉ ⴰⵔⴻⴱⴱⵉ ⴰⴷⴰⵎ ⵣⵉ ⵜⵄⴻⵊⵊⴰⵊⵜ ⵏ ⵓⵛⴰⵍ ⵓⵛⴰ ⵉⵙⵓⴹ ⵍⴻⵄⵡⵉⵏ ⵏ ⵜⵓⴷⴰⵔⵜ ⴷⴻⴳ ⵡⴻⵏⵣⴰⵔⴻⵏ ⵏⵏⴻⵙ. ⴰⵎⵎⵓ ⵉ ⵉⴷⵡⴻⵍ ⴰⴷⴰⵎ ⴷ ⵉⵊⵊ ⵏ ⵏⵏⴻⴼⵙ ⵉⴷⴷⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","ⵅⴻⵏⵏⵉ ⵉⵥⵥⵓ ⵙⵉⴷⵉ ⴰⵔⴻⴱⴱⵉ ⵊⵊⴻⵏⵏⴻⵜ ⴷⵉ ⵄⴰⴷⵏ, ⵊⵊⵉⵀⴻⵜ ⵏ ⵛⵛⴰⵔⵇ, ⵓⵛⴰ ⵉⵙⵙⴰⵔⵙ ⴷⵉⵏ ⴰⴷⴰⵎ ⵉ ⵉⴳⴳⴰ. ");
INSERT INTO rift_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","ⵓⵛⴰ ⵉⵙⵙⴻⵖⵎⵉ-ⴷⴷ ⵙⵉⴷⵉ ⴰⵔⴻⴱⴱⵉ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⴽⵓⵍ ⵜⴰⵛⴻⵊⵊⴰⵔⵜ, ⵜⴻⵛⵏⴰ ⵉ ⵍⵅⴻⵥⵔⴰⵜ ⵓ ⵜⵎⵉⵥⵉⴷⵜ ⵉ ⵎⴰⵛⵛⴰ, ⵓⵛⴰ ⵉⵙⵙⴻⵖⵎⵉ-ⴷⴷ ⵍⴰ ⴷ ⵜⴰⵛⴻⵊⵊⴰⵔⵜ ⵏ ⵜⵓⴷⴰⵔⵜ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏ ⵊⵊⴻⵏⵏⴻⵜ ⵓⵍⴰ ⴷ ⵜⴰⵛⴻⵊⵊⴰⵔⵜ ⵏ ⵜⵓⵙⵙⵏⴰ ⵏ ⵍⵅⴰⵔ ⴷ ⵍⵖⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","ⵉⴼⴼⴻⵖ-ⴷⴷ ⵉⵊⵊ ⵏ ⵉⵖⵣⴰⵔ ⵣⵉ ⵄⴰⴷⵏ, ⵃⵉⵎⴰ ⴰⴷ ⵉⵙⵙⵓⵡ ⵊⵊⴻⵏⵏⴻⵜ ⵓ ⵙⵙⴻⵏⵏⵉ ⵉⵎⵎⵙⴻⴱⴹⴰ ⵅ ⴰⵔⴻⴱⵄⴰ ⵏ ⵉⵣⴻⴵⵉⴼⴻⵏ ⵉ ⵉⴳⴳⵉⵏ ⵜⵉⵙⴻⴵⵢⴰⵡⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","ⵉⵙⴻⵎ ⵏ ⵢⴻⵖⵣⴰⵔ ⴰⵎⴻⵣⵡⴰⵔⵓ ⴷ ⴼⵉⵛⵓⵏ. ⵏⴻⵜⵜⴰ ⵉ ⵉⵏⵏⴹⴻⵏ ⵉ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵃⴰⵡⵉⵍⴰ ⵎⴰⵏⵉ ⵉⴵⴰ ⵡⵓⵔⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","ⵓⵔⴻⵖ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⵉ ⵉⵚⴱⴻⵃ. ⴰⵇⴰ ⴷⵉⵏ ⴰⵙⴻⵔⵖⴰⵖ ⴰⵛⴻⵎⵍⴰⵍ ⵇⵇⴰⵔⴻⵏ ⴰⵙ ‘ⴱᵉⴷⵓⵍⴰ’, ⴷ ⵡⴻⵥⵔⵓ ⵏ ‘ⵓⵏⵉⴽⵙ’. ");
INSERT INTO rift_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","ⵉⵙⴻⵎ ⵏ ⵉⵖⵣⴰⵔ ⵡⵉⵙⵙ ⵜⵏⴰⵢⴻⵏ ⴷ ⵊⵉⵃⵓⵏ ⵉ ⵜⵓⵖⴰ ⵉⵏⵏⴹⴻⵏ ⵉ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⴽⵓⵛ. ");
INSERT INTO rift_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","ⵉⵙⴻⵎ ⵏ ⵉⵖⵣⴰⵔ ⵡⵉⵙⵙ ⵜⵍⴰⵜⴰ ⴷ ⵃⵉⴷⴷⴰⵇⵉⵍ. ⵏⴻⵜⵜⴰ ⵉⵜⵜⴰⵣⵣⴻⵍ ⵖⴰⵔ ⵛⵛⴰⵔⵇ ⵏ ⴰⵛⵛⵓⵔ. ⵓ ⵉⵖⵣⴰⵔ ⵡⵉⵙⵙ ⴰⵔⴻⴱⵄⴰ ⴷ ⵍⴼⵓⵔⴰⵟ. ");
INSERT INTO rift_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","ⵉⴽⵙⵉ ⵙⵉⴷⵉ ⴰⵔⴻⴱⴱⵉ ⴰⴷⴰⵎ ⵓⵛⴰ ⵉⵙⵙⴰⵔⵙ ⵉ-ⵜ ⴷⵉ ⵊⵊⴻⵏⵏⴻⵜ ⵏ ⵄⴰⴷⵏ, ⵃⵉⵎⴰ ⴰⴷ ⵜⵜ ⵉⵅⴷⴻⵎ ⵓ ⴰⴷ ⵜⵜ ⵉⵃⴹⴰ. ");
INSERT INTO rift_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","ⵙⵉⴷⵉ ⴰⵔⴻⴱⴱⵉ ⵉⵡⴻⵚⵚⴰ ⴰⴷⴰⵎ, ⵉⵏⵏⴰ: “ⵣⵉ ⵎⴰⵔⵔⴰ ⵜⵉⵛⴻⵊⵊⵓⵔⴰ ⵏ ⵊⵊⴻⵏⵏⴻⵜ ⴰⴷ ⵜⴻⵛⵛⴻⴷ ⵎⴰⵛⵛⴰ, ");
INSERT INTO rift_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ⵎⴰⵛⴰ ⵣⵉ ⵜⵛⴻⵊⵊⴰⵔⵜ ⵏ ⵜⵓⵙⵙⵏⴰ ⵏ ⵍⵅⴰⵔ ⴷ ⵍⵖⴰⵔ ⵡⴰⵔ ⵜⵜᵉⵜⵜⴻⴷ ⵛⴰ ⵣⵣⴰⵢⴻⵙ, ⵎⵉⵏⵣⵉ ⴷⴻⴳ ⵡⴰⵙⵙ ⵉ ⵣⵣⴰⵢⴻⵙ ⵖⴰ ⵜⴻⵛⵛⴻⴷ, ⵍⵎⴻⵡⵜ ⵉ ⵖⴰ ⵜⴻⵎⵎⵜⴻⴷ!” ");
INSERT INTO rift_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⴰⵔⴻⴱⴱⵉ: “ⵡⴰⵔ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⵢⵉⵍⵉ ⴰⴷⴰⵎ ⵡⴻⵃⵃⴷⴻⵙ. ⴰⴷ ⴰⵙ ⴳⴳⴻⵖ ⵡⵉ ⵜ ⵖⴰ ⵉⵄⴰⵡⵏⴻⵏ, ⴰⵎ ⵏⴻⵜⵜⴰ ⵇⵉⴱⴰⵍⵜ ⵏⵏⴻⵙ.” ");
INSERT INTO rift_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","ⵜⵓⵖⴰ ⵙⵉⴷⵉ ⴰⵔⴻⴱⴱⵉ ⵉⴳⴳⴰ ⵣⴻⴳ ⵓⵛⴰⵍ ⵎⴰⵔⵔⴰ ⵍⵎⴰⵍ ⵏ ⵍⴻⵅⵍⴰ ⵓ ⵎⴰⵔⵔⴰ ⵉⵊⴹⴰⴹ ⵏ ⵓⵊⴻⵏⵏⴰ, ⵓⵛⴰ ⵉⵏⴷⴻⵀ ⵉ-ⵜⴻⵏ ⵖⴰⵔ ⴰⴷⴰⵎ, ⵃⵉⵎⴰ ⴰⴷ ⵉⵥⴰⵔ ⵎⴰⵎⵎⴻⵛ ⵉ ⵜⴻⵏ ⵖⴰ ⵉⵙⴻⵎⵎⴰ. ⵎⴰⵎⵎⴻⵛ ⵉ ⵖⴰ ⵉⵙⴻⵎⵎⴰ ⴰⴷⴰⵎ ⴽⵓⵍ ⵏⵏⴻⴼⵙ ⵉⴷⴷⴰⵔⴻⵏ ⴷ ⵡⴰ ⴷ ⵉⵙⴻⵎ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","ⵉⴳⴳⴰ ⴰⴷⴰⵎ ⵉⵙⵎⴰⵡⴻⵏ ⵉ ⵎⴰⵔⵔⴰ ⵍⴻⴱⵀⴰⵢⴻⵎ ⴷ ⵢⴻⵊⴹⴰⴹ ⵏ ⵓⵊⴻⵏⵏⴰ ⵓ ⵉ ⵎⴰⵔⵔⴰ ⵍⵎⴰⵍ ⵏ ⵍⴻⵅⵍⴰ, ⵎⴰⵛⴰ ⵉ ⴰⴷⴰⵎ ⵡⴰⵔ ⵢⵓⴼⵉ ⵡⵉ ⵜ ⵖⴰ ⵉⵄⴰⵡⵏⴻⵏ ⴷ ⵡⵉ ⵖⴰ ⵢⵉⵍⵉⵏ ⴰⵎ ⵏⴻⵜⵜⴰ ⵇⵉⴱⴰⵍⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","ⵉⵙⵙⴻⵀⵡⴰ-ⴷⴷ ⵙⵉⴷⵉ ⴰⵔⴻⴱⴱⵉ ⵉⵊⵊ ⵏ ⵢⵉⴹⴻⵚ ⵢⵓⴵⴻⵖ ⵅ ⴰⴷⴰⵎ ⵓⵛⴰ ⵉⵟⵟⴻⵚ. ⵅⴻⵏⵏⵉ ⵉⴽⵙⵉ ⵉⵛⵜⴻⵏ ⵣⵉ ⵜⵖⴻⵣⴷⵉⵙⵉⵏ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⵇⵇⴻⵏ ⴰⵎⵛⴰⵏ ⵢⴰⵔⴻⵣⵎⴻⵏ ⵏⵏⵉ ⵙ ⵡⴻⵢⵙⵓⵎ. ");
INSERT INTO rift_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","ⵢⴰⵔⵔⴰ ⵙⵉⴷⵉ ⴰⵔⴻⴱⴱⵉ ⵜⴰⵖⴻⵣⴷⵉⵙⵜ ⵜⴻⵏⵏⵉ ⵉ ⵉⴽⵙⵉ ⵣⵉ ⴰⴷⴰⵎ ⴷ ⵜⴰⵎⵖⴰⵔⵜ ⵓⵛⴰ ⵢⵉⵡⵢⵉ ⵜⵜ-ⵉ-ⴷⴷ ⵖⴰⵔ ⴰⴷⴰⵎ. ");
INSERT INTO rift_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⴰⴷⴰⵎ: “ⵜⵡⴰⵍⴰ-ⵢⴰ ⵜⴰⵏⵉⵜⴰ ⴰⵇⴰ-ⵜⵜ ⴷ ⵉⵖⴻⵙ ⵣⴻⴳ ⵉⵖⵙⴰⵏ ⵉⵏⵓ ⴷ ⴰⵢⵙⵓⵎ ⵣⴻⴳ ⵡⴻⵢⵙⵓⵎ ⵉⵏⵓ. ⵜⴰⵏⵉⵜⴰ ⴰⴷ ⵜᵉⵜⵜⵡⴰⵙⴻⵎⵎⴰ ‘ⵜⴰⵔⵢⴰⵣⵜ’, ⵉⵅⵙ ⴰⴷ ⵢⵉⵏⵉ ‘ⵜⴰⵎⵖⴰⵔⵜ’, ⵎⵉⵏⵣⵉ ⵏⴻⵜⵜⴰⵜ ⵜᵉⵜⵜⵡⴰⴽⵙⵉ-ⴷⴷ ⵣⴻⴳ ⵡⴻⵔⵢⴰⵣ.” ");
INSERT INTO rift_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","ⵅ ⵓⵢⴰ ⴰⴷ ⵉⵙⵎⴻⵃ ⵡⴻⵔⵢⴰⵣ ⴷⵉ ⴱⴰⴱⴰⵙ ⴷ ⵢⴻⵎⵎⴰⵙ, ⴰⴷ ⵉⵇⵇⴻⵏ ⵖⴰⵔ ⵜⴻⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⵉⵍⵉⵏ ⴷ ⵉⵛⵜ ⵏ ⴷⴷⴰⵜ.    ");
INSERT INTO rift_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","ⵜⵓⵖⴰ-ⵜⴻⵏ ⵙ ⵜⵏⴰⵢⴻⵏ ⵉⴷⵙⴻⵏ ⴷ ⵉⵄⴰⵔⵢⴰⵏⴻⵏ, ⴰⴷⴰⵎ ⴷ ⵜⴻⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ, ⵎⴰⵛⴰ ⵜⵓⵖⴰ ⵡⴰⵔ ⴷⵉⵏ ⵛⴰ ⵏ ⵍⴻⵃⵢⴰ ⵊⴰⵔ ⴰⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","ⵜⵓⵖⴰ ⴰⴼⵉⵖⴰⵔ ⴷ ⴰⵃⵔⴰⵢⵎⵉ ⵅ ⵎⴰⵔⵔⴰ ⵍⵎⴰⵍ ⵏ ⵍⴻⵅⵍⴰ ⵉ ⵉⴳⴳⴰ ⵙⵉⴷⵉ ⴰⵔⴻⴱⴱⵉ. ⵉⵏⵏⴰ ⵉ ⵜⴻⵎⵖⴰⵔⵜ: “ⵎⴰ ⴷ ⵜⵉⴷⴻⵜⵜ ⵉⵏⵏⴰ ⴰⵔⴻⴱⴱⵉ: ‘ⵖⴰⵔⵡⴻⵎ ⵡⴰⵔ ⵜⵜᵉⵜⵜⴻⵎ ⵛⴰ ⵣⵉ ⵎⴰⵔⵔⴰ ⵜⵉⵛⴻⵊⵊⵓⵔⴰ ⵏ ⵊⵊⴻⵏⵏⴻⵜ’?” ");
INSERT INTO rift_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","ⵜⴻⵏⵏⴰ ⵜⴻⵎⵖⴰⵔⵜ ⵉ ⵓⴼⵉⵖⴰⵔ: “ⵣⵉ ⵍⵖⵉⴵⴻⵜ ⵏ ⵜⵛⴻⵊⵊⵓⵔⴰ ⵏ ⵊⵊⴻⵏⵏⴻⵜ ⵏⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵏⴻⵛⵛ, ");
INSERT INTO rift_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ⵎⴰⵛⴰ ⵣⵉ ⵍⵖⵉⴵⴻⵜ ⵏ ⵜⵛⴻⵊⵊⴰⵔⵜ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏ ⵊⵊⴻⵏⵏⴻⵜ, ⵉⵏⵏⴰ ⴰⵔⴻⴱⴱⵉ: ‘ⵡⴰⵔ ⵣⵣⴰⵢⴻⵙ ⵜⵜᵉⵜⵜⴻⵎ, ⵡⴰⵔ ⵜⵜ ⵜⵜⵃⴰⴷⴰⵎ, ⵃⵉⵎⴰ ⵡⴰⵔ ⵜᵉⵜⵜⵎⴻⵜⵜⵉⵎ.’” ");
INSERT INTO rift_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","ⵉⵏⵏⴰ ⵓⴼⵉⵖⴰⵔ ⵉ ⵜⴻⵎⵖⴰⵔⵜ: “ⴽⴻⵏⵏⵉⵡ ⵡⴰⵔ ⵜᵉⵜⵜⵎⴻⵜⵜⵉⵎ ⵛⴰ ⵙ ⵍⵎⴻⵡⵜ ⵇⴰⵄ, ");
INSERT INTO rift_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","ⵎⴰⵛⴰ ⴰⵔⴻⴱⴱⵉ ⵉⵙⵙⴻⵏ ⴱⴻⵍⵍⵉ ⴰⵙⵙ ⵏⵏⵉ ⴷⵉ ⵣⵣⴰⵢⴻⵙ ⵉ ⵖⴰ ⵜⴻⵛⵛⴻⵎ, ⴰⴷ ⴰⵔⵣⵎⴻⵏⵜ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵡⴻⵎ ⵓⵛⴰ ⴰⴷ ⵜⵉⵍⵉⵎ ⴰⵎ ⴰⵔⴻⴱⴱⵉ, ⴰⴷ ⵜⴻⵙⵙⵏⴻⵎ ⵍⵅⴰⵔ ⵣⵉ ⵍⵖⴰⵔ.” ");
INSERT INTO rift_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","ⵜⴻⵥⵔⴰ ⵜⴻⵎⵖⴰⵔⵜ ⴱⴻⵍⵍⵉ ⵜⴰⵛⴻⵊⵊⴰⵔⵜ ⵜⴻⵚⴱⴻⵃ ⵉ ⵎⴰⵛⵛⴰ ⵓⵛⴰ ⵜⴻⵄⵊⴻⴱ ⴰⵙⴻⵏⵜ ⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ, ⴰⵇⴰ ⵜⴰⵛⴻⵊⵊⴰⵔⵜ ⵜⴻⴳⴳⴰ ⴷⴰⵢⴻⵙ ⵎⴻⵥⵔⵉ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵜⴻⴷⵡⴻⵍ ⴷ ⵜⴰⵎⵉⵖⵉⵙⵜ. ⵅⴻⵏⵏⵉ ⵜⴻⴽⵙⵉ ⵣⵉ ⵍⵖⵉⴵⴻⵜ ⵏⵏⴻⵙ, ⵜⴻⵛⵛⴰ ⵓⵛⴰ ⵜⴻⵡⵛⴰ ⵄⴰⵡⴻⴷ ⵉ ⵡⴻⵔⵢⴰⵣ ⵏⵏⴻⵙ ⵉ ⵜⵓⵖⴰ ⴰⴽⵉⴷⴻⵙ, ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵉⵛⵛⴰ. ");
INSERT INTO rift_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","ⵏⵏⴰⵔⵣⵎⴻⵏⵜ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵙⴻⵏ ⵓⵛⴰ ⵓⴼⵉⵏ ⵉⵅⴻⴼ ⵏⵙⴻⵏ ⴷ ⵉⵄⴰⵔⵢⴰⵏⴻⵏ. ⵅⴻⵏⵏⵉ ⵅⴻⵢⵢⴹⴻⵏ ⵜⵉⴼⵔⴰⵢ ⵏ ⵡⴰⵔⵜⵓ, ⵓⵛⴰ ⴳⴳⵉⵏ ⵣⵣⴰⵢⵙⴻⵏⵜ ⵜⵉⴱⴰⵏⵜⵉⵡⵉⵏ ⵉ ⵢⵉⵅⴻⴼ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","ⵅⴻⵏⵏⵉ ⵙⵍⵉⵏ ⵏⵉⵜⵏⵉ ⵜⵎⵉⵊⵊⴰ ⵏ ⵙⵉⴷⵉ ⴰⵔⴻⴱⴱⵉ ⵉⴳⴳⵓⵔ ⴷⵉ ⵊⵊⴻⵏⵏⴻⵜ ⵖⴰⵔ ⵓⵡⴻⵟⵟⵓ ⵏ ⵜⵎⴻⴷⴷⵉⵜ, ⵓⵛⴰ ⵉⴼⴼⴰⵔ ⴰⴷⴰⵎ ⴷ ⵜⴻⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ ⵣⴻⴳ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⴰⵔⴻⴱⴱⵉ ⵊⴰⵔ ⵜⵛⴻⵊⵊⵓⵔⴰ ⵏ ⵊⵊⴻⵏⵏⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","ⵓⵛⴰ ⵉⵍⴰⵖⴰ ⵙⵉⴷⵉ ⴰⵔⴻⴱⴱⵉ ⴰⴷⴰⵎ, ⵉⵏⵏⴰ ⴰⵙ: “ⵎⴰⵏⵉ ⵜⴻⴵⵉⴷ?” ");
INSERT INTO rift_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","ⵏⴻⵜⵜⴰ ⵉⵏⵏⴰ: “ⵙⵍⵉⵖ ⵉ ⵜⵎⵉⵊⵊⴰ ⵏⵏⴻⵛ ⴷⵉ ⵊⵊⴻⵏⵏⴻⵜ ⵓⵛⴰ ⴳⴳⵯⴻⴷⴻⵖ ⵎⵉⵏⵣⵉ ⵏⴻⵛⵛ ⴷ ⴰⵄⴰⵔⵢⴰⵏ, ⵅⴻⵏⵏⵉ ⴼⴼⴰⵔⴻⵖ.” ");
INSERT INTO rift_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","ⵉⵏⵏⴰ ⴰⵙ ⵏⴻⵜⵜⴰ: “ⵡⵉ ⴷ ⴰⵛ ⵉⵏⵏⴰⵏ ⴱⴻⵍⵍⵉ ⵛⴻⴽ ⴷ ⴰⵄⴰⵔⵢⴰⵏ? ⵎⴰ ⵜⴻⵛⵛⵉⴷ ⵣⵉ ⵜⵛⴻⵊⵊⴰⵔⵜ ⵏⵏⵉ ⵅ ⵛⴻⴽ ⵡⴻⵚⵚⵉⵖ ‘ⴰⵇⴰ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵜⴻⵛⵛⴻⴷ?” ");
INSERT INTO rift_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","ⵉⵏⵏⴰ ⴰⴷⴰⵎ: “ⵜⴰⵎⵖⴰⵔⵜ ⵏⵏⵉ ⴷ ⴰⵢⵉ ⵜⴻⵡⵛⵉⴷ, ⵏⴻⵜⵜⴰⵜ ⵜⴻⵡⵛⴰ ⴰⵢⵉ ⵣⵉ ⵜⵛⴻⵊⵊⴰⵔⵜ ⵓⵛⴰ ⵛⵛⵉⵖ.” ");
INSERT INTO rift_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","ⵉⵏⵏⴰ ⴰⵙ ⵙⵉⴷⵉ ⴰⵔⴻⴱⴱⵉ ⵉ ⵜⴻⵎⵖⴰⵔⵜ: “ⵎⴰⵏⴰⵡⵢⴰ ⵉ ⵜⴻⴳⴳⵉⴷ?” ⵜⴻⵏⵏⴰ ⴰⵙ ⵜⴻⵎⵖⴰⵔⵜ: “ⵉⵖⴰⵔⵔⴰ ⴰⵢⵉ ⵓⴼⵉⵖⴰⵔ ⵓⵛⴰ ⵛⵛⵉⵖ.” ");
INSERT INTO rift_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⴰⵔⴻⴱⴱⵉ ⵉ ⵓⴼⵉⵖⴰⵔ: “ⵍⴰⵎⵉ ⵜⴻⴳⴳⵉⴷ ⴰⵢⴰ, ⴰⵇⴰ ⴰⵛ ⴷ ⴰⵎⴻⵏⵄⵓⵍ ⵊⴰⵔ ⵎⴰⵔⵔⴰ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵓ ⵊⴰⵔ ⵎⴰⵔⵔⴰ ⵍⵎⴰⵍ ⵏ ⵍⴻⵅⵍⴰ. ⵅ ⵓⵄⴻⴷⴷⵉⵙ ⵏⵏⴻⵛ ⴰⴷ ⵜⵎⵓⵔⴷⴻⴷ, ⵓⵛⴰ ⴰⴷ ⵜⴻⵛⵛⴻⴷ ⵓⵛⴰⵍ ⵎⴰⵔⵔⴰ ⵓⵙⵙⴰⵏ ⵏ ⵜⵓⴷⴰⵔⵜ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","ⴰⴷ ⴳⴳⴻⵖ ⵍⴻⵄⴷⴰⵡⴰⵜ ⵊⴰⵔ ⴰⵛ ⴷ ⵜⴻⵎⵖⴰⵔⵜ, ⵊⴰⵔ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵛ ⴷ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵙ. ⴷ ⵜⴻⵏⵏⵉ ⵏⵏⴻⵙ ⴰⴷ ⵜⴻⵍⴱⴻⵣ ⴰⵣⴻⴵⵉⴼ ⵏⵏⴻⵛ, ⵓ ⵛⴻⴽ ⴰⴷ ⴰⵙ ⵜⵍⴻⴱⵣⴻⴷ ⴰⵏⵉⵔⵣ ⵏⵏⴻⵙ.” ");
INSERT INTO rift_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","ⵉⵏⵏⴰ ⵉ ⵜⴻⵎⵖⴰⵔⵜ: “ⴰⵟⵟⴰⵙ ⵉ ⵖⴰ ⴰⵔⵏⵉⵖ ⵍⴻⵃⵔⵉⵇ ⴷ ⵍⴻⵡⵊⴻⵄ ⵏ ⵜⴰⵔⵡⴰ ⵏⵏⴻⵎ. ⵙ ⵍⴻⵃⵔⵉⵇ ⴰⴷ ⴷⴷ-ⵜⴰⵔⵡⴻⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ, ⵓⵛⴰ ⵖⴰⵔ ⵡⴻⵔⵢⴰⵣ ⵏⵏⴻⵎ ⴰⴷ ⵜⴻⵎⵎⴻⵥⵔⴻⴷ, ⵎⴰⵛⴰ ⵏⴻⵜⵜⴰ ⴰⴷ ⵅⴰⵎ ⵉⵃⴽⴻⵎ.” ");
INSERT INTO rift_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","ⵓⵛⴰ ⵉⵏⵏⴰ ⵉ ⴰⴷⴰⵎ: “ⵎⵉⵏⵣⵉ ⵜⴻⵙⵍⵉⴷ ⵖⴰⵔ ⵜⵎⵉⵊⵊⴰ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⵏⵏⴻⵛ ⵓ ⵜⴻⵛⵛⵉⴷ ⵣⵉ ⵜⵛⴻⵊⵊⴰⵔⵜ ⵜⴻⵏⵏⵉ ⵅ ⵛⴻⴽ ⵡⴻⵚⵚⵉⵖ: ‘ⴰⵇⴰ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵜⴻⵛⵛⴻⴷ!’, ⴰⴷ ⵜⵉⵍⵉ ⵜⴻⵎⵎⵓⵔⵜ ⴷ ⵏⵏⴻⵄⵍⴻⵜ ⵅ ⵙⵙⵉⴱⴱⴻⵜ ⵏⵏⴻⵛ. ⵙ ⵜⴰⵎⴰⵔⴰ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵜⴻⵛⵛⴻⴷ, ⵎⴰⵔⵔⴰ ⵓⵙⵙⴰⵏ ⵏ ⵜⵓⴷⴰⵔⵜ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","ⵉⵙⴻⵏⵏⴰⵏⴻⵏ ⴷ ⵜⵣⴻⴳⴳⵯⴰⵔⵜ ⵉ ⴷ ⴰⵛ ⴷⴷ ⵖⴰ ⵜⴻⵙⵙⴻⵖⵎⵉ, ⵓⵛⴰ ⴰⴷ ⵜⴻⵛⵛⴻⴷ ⴰⴼⵙⵓ ⵏ ⵢⴻⵢⵢⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","ⵙ ⵜⵉⴷⵉ ⵏ ⵓⵖⴻⵎⴱⵓⴱ ⵏⵏⴻⵛ ⴰⴷ ⵜⴻⵛⵛⴻⴷ ⴰⵖⵔⵓⵎ ⴰⵍ ⴷⴷ ⵖⴰ ⵜⴷⴻⵡⵍⴻⴷ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵉ ⵣⵉ ⵜⴻⵎⵎⴻⴽⵙⵉⴷ, ⵎⵉⵏⵣⵉ ⵛⴻⴽ ⴷ ⴰⵛⴰⵍ ⵓⵛⴰ ⵖⴰⵔ ⵓⵛⴰⵍ ⵉ ⵖⴰ ⴷⴷ-ⵜⴷⴻⵡⵍⴻⴷ.” ");
INSERT INTO rift_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","ⵉⵍⴰⵖⴰ ⴰⴷⴰⵎ ⵉⵙⴻⵎ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ ⵃⴰⵡⵡⴰ ⵎⵉⵏⵣⵉ ⵏⴻⵜⵜⴰⵜ ⴷ ⵢⴻⵎⵎⴰⵙ ⵏ ⵎⴰⵔⵔⴰ ⵉⵏⵏⵉ ⵉⴷⴷⴰⵔⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","ⵉⴳⴳⴰ ⵙⵉⴷⵉ ⴰⵔⴻⴱⴱⵉ ⵉ ⴰⴷⴰⵎ ⴷ ⵜⴻⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ ⴰⵔⵔⵓⴹ ⵙ ⵢⵉⵍⴻⵎ ⵓⵛⴰ ⵢⴰⵔⴹ ⴰⵙⴻⵏ ⵜ. ");
INSERT INTO rift_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⴰⵔⴻⴱⴱⵉ: “ⵅⵣⴰⵔ, ⴰⴷⴰⵎ ⵡⴰ, ⴰⵇⴰ ⵉⴷⵡⴻⵍ ⴰⵎ ⵢⵉⵊⵊⴻⵏ ⵣⵣⴰⵢⵏⴻⵖ, ⵉⵙⵙⴻⵏ ⵍⵅⴰⵔ ⴷ ⵍⵖⴰⵔ. ⵍⴻⵅⵅⵓ, ⴻⵊⵊ ⵉ-ⵜ ⵡⴰⵔ ⵉⵙⵙⵡⴰⵥⵥⴰⴹ ⴰⴼⵓⵙ ⵏⵏⴻⵙ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⴽⵙⵉ ⵣⵉ ⵜⵛⴻⵊⵊⴰⵔⵜ ⵏ ⵜⵓⴷⴰⵔⵜ ⵄⴰⵡⴻⴷ, ⴰⴷ ⵢⴻⵛⵛ ⵓ ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⴷⴷⴰⵔ ⵉ ⵍⴻⴱⴷⴰ.” ");
INSERT INTO rift_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","ⵓⵛⴰ ⵉⵙⵙⵓⴼⴼⵓⵖ ⵉ-ⵜ ⵙⵉⴷⵉ ⴰⵔⴻⴱⴱⵉ ⵣⵉ ⵊⵊⴻⵏⵏⴻⵜ ⵏ ⵄⴰⴷⵏ ⵃⵉⵎⴰ ⴰⴷ ⵉⵅⴷⴻⵎ ⵜⴰⵎⵎⵓⵔⵜ ⵉ ⵣⵉ ⵜⵓⵖⴰ ⵉⵎⵎⴻⴽⵙⵉ. ");
INSERT INTO rift_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","ⵢⵓⵥⵥⴻⵍ ⵅ ⴰⴷⴰⵎ ⵓⵛⴰ ⵉⴳⴳⴰ ⵉⴽⵉⵔⵓⴱⴻⵏ ⵛⵛⴰⵔⵇ ⵉ ⵊⵊⴻⵏⵏⴻⵜ ⵏ ⵄⴰⴷⵏ ⴷ ⵢⵉⵊⵊ ⵏ ⵙⵙⵉⴼ ⵉⵜⵜⴻⵃⴷⵓⴷⵓⵇ, ⵉⵜⵜⴻⵛⴹⵉⴹⵉⵃ ⵙⵙⴰ ⴷ ⵙⵙⴰ ⵉ ⵓⵄⴻⵙⵙⵉ ⵅ ⵡⴻⴱⵔⵉⴷ ⵏ ⵜⵛⴻⵊⵊⴰⵔⵜ ⵏ ⵜⵓⴷⴰⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","ⵉⵙⵙⴻⵏ ⴰⴷⴰⵎ ⵃⴰⵡⵡⴰ, ⵜⴰⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ, ⵓⵛⴰ ⵜⴻⵢⵙⵉ ⵙ ⴷⴷⴻⵢⵙⴻⵜ ⵓⵛⴰ ⵜⵓⵔⵓⵡ-ⴷⴷ ⵇⴰⵢⵉⵏ, ⵜⴻⵏⵏⴰ “ⵊⵊⵉⵖ-ⴷⴷ ⴰⵔⵢⴰⵣ, ⴷ ⵙⵉⴷⵉ!” ");
INSERT INTO rift_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","ⵅⴻⵏⵏⵉ ⵄⴰⵡⴻⴷ ⵜⵓⵔⵓⵡ-ⴷⴷ ⵓⵎⴰⵙ ⵀⴰⴱⵉⵍ. ⵜⵓⵖⴰ ⵀⴰⴱⵉⵍ ⴷ ⴰⵎⴻⴽⵙⴰⵡ ⵏ ⵡⵓⴵⵉ ⵓ ⵇⴰⵢⵉⵏ ⵉⵔⵓⵃ ⵉⵅⴻⴷⴷⴻⵎ ⵜⴰⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","ⵓⵛⴰ ⴰⵡⴰⵔⵏⵉ ⵓⵙⵙⴰⵏ ⵉⵎⵙⴰⵔ ⴱⴻⵍⵍⵉ ⵇⴰⵢⵉⵏ ⵉⵇⴻⴷⴷⴻⵎ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵣⵉ ⵍⵖⵉⴵⴻⵜ ⵏ ⵡⵓⴷⴻⵎ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","ⵉⵇⴻⴷⴷⴻⵎ ⵀⴰⴱⵉⵍ ⵄⴰⵡⴻⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵣⴻⴳ ⵉⵎⴻⵏⵣⴰ ⵏ ⵡⵓⴵⵉ ⵏⵏⴻⵙ, ⵣⴻⴳ ⵉⵏⵏⵉ ⵖⴰⵔ ⵉⴵⴰ ⵜⴰⴷⵓⵏⵜ ⴰⵟⵟⴰⵙ. ⵉⵅⵣⴰⵔ ⵙⵉⴷⵉ ⵖⴰⵔ ⵀⴰⴱⵉⵍ ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ, ");
INSERT INTO rift_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ⵎⴰⵛⴰ ⵖⴰⵔ ⵇⴰⵢⵉⵏ ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵡⴰⵔ ⴷ ⴰⵙ ⵢⴰⵔⵔⵉ ⵛⴰ ⵜⴰⵢⵏⵉⵜ. ⵓⵛⴰ ⵉⵅⴻⵢⵢⴻⵇ ⵇⴰⵢⵉⵏ ⴰⵟⵟⴰⵙ, ⵉⵏⵏⴻⵇⵍⴻⴱ ⴰⵙ ⵓⵖⴻⵎⴱⵓⴱ. ");
INSERT INTO rift_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵇⴰⵢⵉⵏ: “ⵎⴰⵢⴻⵎⵎⵉ ⵜⵅⴻⵢⵢⵇⴻⴷ? ⵎⴰⵢⴻⵎⵎⵉ ⴷ ⴰⵛ ⵉⵏⵏⴻⵇⵍⴻⴱ ⵓⵖⴻⵎⴱⵓⴱ? ");
INSERT INTO rift_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","ⵎⴰⵍⴰ ⵜⴻⴳⴳⵉⴷ ⵎⵍⵉⵃ, ⵎⴰ ⵡⴰⵔ ⴷⵉⵏ ⵉⵜⵜⵉⵍⵉ ⵓⵙⴳⴻⵄⵄⴻⴷ, ⵓ ⵎⴰⵍⴰ ⵡⴰⵔ ⵜⴻⴳⴳⵉⴷ ⵎⵍⵉⵃ, ⴷⴷⴻⵏⴱ ⴰⵇⴰ-ⵜ ⵉⵣⵣⴻⵍ ⵖⴰⵔ ⵜⴻⵡⵡⴰⵔⵜ? ⵎⴻⵥⵔⵉ ⵏⵏⴻⵙ ⵖⴰⵔⴻⴽ, ⵎⴰⵛⴰ ⵉⵜⵜⵅⴻⵚⵚⴰ ⵛⴻⴽ ⴰⴷ ⵅⴰⵙ ⵜⵙⴻⴵⴹⴻⴷ.” ");
INSERT INTO rift_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","ⵉⵙⵙⵉⵡⴻⵍ ⵇⴰⵢⵉⵏ ⴰⴽ-ⴷ ⵀⴰⴱⵉⵍ ⵓⵎⴰⵙ. ⵓⵛⴰ ⵉⵎⵙⴰⵔ ⴰⵎ ⴵⴰⵏ ⵏⵉⵜⵏⵉ ⴷⴻⴳ ⵉⵢⵢⴰⵔ, ⴱⴻⵍⵍⵉ ⵇⴰⵢⵉⵏ ⵉⴽⴽⴰⵔ ⵖⴰⵔ ⵓⵎⴰⵙ ⵀⴰⴱⵉⵍ ⵓⵛⴰ ⵉⵏⵖⴰ ⵉ-ⵜ. ");
INSERT INTO rift_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵇⴰⵢⵉⵏ: “ⵎⴰⵏⵉ ⵉⴵⴰ ⵓⵎⴰⵛ ⵀⴰⴱⵉⵍ?” ⵉⵏⵏⴰ: “ⵡⴰⵔ ⵙⵙⵉⵏⴻⵖ. ⵎⴰ ⵏⴻⵛⵛ ⴷ ⴰⵎⴻⵃⴹⴰⵢ ⵅ ⵓⵎⴰ?” ");
INSERT INTO rift_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","ⵓⵛⴰ ⵉⵏⵏⴰ ⵏⴻⵜⵜⴰ: “ⵎⵉⵏ ⵜⴻⴳⴳⵉⴷ? ⴰⵇⴰ ⵜⵎⵉⵊⵊⴰ ⵏ ⵉⴷⴰⵎⵎⴻⵏ ⵏ ⵓⵎⴰⵛ ⵙⵖⵓⵢⵢⵓⵏ-ⴷⴷ ⵖⴰⵔⵉ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","ⵍⴻⵅⵅⵓ, ⴰⵇⴰ ⵛⴻⴽ ⴷ ⵎⴻⵏⵄⵓⵍ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ, ⵜⴻⵏⵏⵉ ⵢⴰⵔⴻⵣⵎⴻⵏ ⴰⵇⴻⵎⵎⵓⵎ ⵏⵏⴻⵙ, ⵃⵉⵎⴰ ⴰⴷ ⵜⴻⵇⴱⴻⵍ ⵉⴷⴰⵎⵎⴻⵏ ⵏ ⵓⵎⴰⵛ ⵣⴻⴳ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","ⵅⵎⵉ ⵖⴰ ⵜⵅⴻⴷⵎⴻⴷ ⵅ ⵜⴻⵎⵎⵓⵔⵜ, ⵡⴰⵔ ⵜⵜᵉⴷⵉⴽⴽⵯⵉⵍ ⴰⴷ ⴰⵛ ⵜⴻⵡⵛ ⵎⴰⵔⵔⴰ ⵊⵊⴻⵀⴷ ⵏⵏⴻⵙ ⵓⵛⴰ ⵛⴻⴽ ⴰⴷ ⵜⵉⵍⵉⴷ ⴷ ⴰⵎⴻⵏⵏⴻⵊⵔⵓ ⴷ ⴰⵎⴻⵜⵍⵓⵄ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ.” ");
INSERT INTO rift_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵇⴰⵢⵉⵏ ⵉ ⵙⵉⴷⵉ: “ⵍⵄⵉⵇⴰⴱ ⵉⵏⵓ ⵉⵎⵖⴰⵔ ⴰⵟⵟⴰⵙ ⵅ ⵜⵣⴻⵎⵎⴰⵔ ⵉⵏⵓ. ");
INSERT INTO rift_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","ⴰⵇⴰ ⵛⴻⴽ ⴰⵙⵙ-ⴰ ⵜⵓⵥⵥⵍⴻⴷ ⵅⴰⴼⵉ ⵣⴻⴳ ⵓⵖⴻⵎⴱⵓⴱ ⵏ ⵜⴻⵎⵎⵓⵔⵜ-ⴰ ⵓⵛⴰ ⵣⴻⴳ ⵓⵖⴻⵎⴱⵓⴱ ⵏⵏⴻⵛ ⴰⴷ ⵜⵜⵡⴰⴼⴼⴰⵔⴻ. ⴰⴷ ⵉⵍⵉⵖ ⴷ ⴰⵎⴻⵏⵏⴻⵊⵔⵓ ⴷ ⴰⵎⴻⵜⵍⵓⵄ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵓⵛⴰ ⴰⴷ ⵢⵉⵍⵉ ⵎⴰⵔⵔⴰ ⵡⴻⵏⵏⵉ ⴷ ⴰⵢⵉ ⵖⴰ ⵢⴰⴼⴻⵏ ⴰⴷ ⴰⵢⵉ ⵉⵏⴻⵖ.” ");
INSERT INTO rift_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⴰⵙ ⵙⵉⴷⵉ: “ⵙ ⵓⵢⴰ ⵎⴰⵔⵔⴰ ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵉⵏⵖⴻⵏ ⵇⴰⵢⵉⵏ, ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵅⴻⵍⴼⴻⵏ ⵙⴻⴱⵄⴰ ⵏ ⵜⵡⴰⵍⴰⵡⵉⵏ.” ⵓⵛⴰ ⵉⴳⴳⴰ ⵙⵉⴷⵉ ⵍⴻⵄⵍⴰⵎⴻⵜ ⵉ ⵇⴰⵢⵉⵏ ⴱⴻⵍⵍⵉ ⵎⴰⵔⵔⴰ ⵡⴻⵏⵏⵉ ⵜ ⵖⴰ ⵢⴰⴼⴻⵏ ⵡⴰⵔ ⵜ ⵉⵏⴻⵇⵇ. ");
INSERT INTO rift_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","ⵅⴻⵏⵏⵉ ⵉⴼⴼⴻⵖ-ⴷⴷ ⵇⴰⵢⵉⵏ ⵣⴻⴳ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⵓⵛⴰ ⵉⵔⵓⵃ ⵉⵣⴻⴷⴷⴻⵖ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵏⵓⴷ, ⵛⵛⴰⵔⵇ ⵏ ⵄⴰⴷⵏ. ");
INSERT INTO rift_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","ⵉⵙⵙⴻⵏ ⵇⴰⵢⵉⵏ ⵜⴰⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ ⵓⵛⴰ ⵜⴻⵢⵙⵉ ⵙ ⴷⴷⴻⵢⵙⴻⵜ ⵓⵛⴰ ⵜⵓⵔⵓⵡ ⴰⵙ-ⴷⴷ ⵃⴰⵏⵓⵅ. ⵜⵓⵖⴰ ⵇⴰⵢⴻⵏ ⵉⴱⵏⴰ ⵉⵛⵜ ⵏ ⵜⴻⵏⴷⵉⵏⵜ ⵓⵛⴰ ⵉⵍⴰⵖⴰ ⴰⵙ ⵉ ⵜⴻⵏⴷⵉⵏⵜ ⴰⵎ ⵢⵉⵙⴻⵎ ⵏ ⵎⵎⵉⵙ ⵃⴰⵏⵓⵅ. ");
INSERT INTO rift_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","ⵃⴰⵏⵓⵅ ⵉⵊⵊⴰ-ⴷⴷ ⵄⵉⵔⴰⴷ, ⵓ ⵄⵉⵔⴰⴷ ⵉⵊⵊⴰ-ⴷⴷ ⵎⵉⵃⵓⵢⴰ’ⵉⵍ ⵓ ⵎⵉⵃⵓⵢⴰ’ⵉⵍ ⵉⵊⵊⴰ-ⴷⴷ ⵎⴰⵜⵓⵛⴰ’ⵉⵍ ⵓ ⵎⴰⵜⵓⵛⴰ’ⵉⵍ ⵉⵊⵊⴰ-ⴷⴷ ⵍⴰⵎⴰⴽ. ");
INSERT INTO rift_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","ⵉⵎⵍⴻⵛ ⵍⴰⵎⴰⴽ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵎⵖⴰⵔⵉⵏ. ⵉⵛⵜⴻⵏ ⵇⵇⴰⵔⴻⵏ ⴰⵙ ⵄⴰⴷⴰ, ⵜⴻⵏⵏⴻⵖⵏⵉ ⵇⵇⴰⵔⴻⵏ ⴰⵙ ⵚⵉⵍⵍⴰ. ");
INSERT INTO rift_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","ⵜⵓⵔⵓⵡ-ⴷⴷ ⵄⴰⴷⴰ ⵢⴰⴱⴰⵍ. ⵏⴻⵜⵜⴰ ⵉⴷⵡⴻⵍ ⴷ ⴱⴰⴱⴰⵜⵙⴻⵏ ⵉ ⵉⵎⴻⵣⴷⴰⵖ ⵏ ⵉⵇⵉⴹⴰⵏ ⵓ ⵉ ⵉⵎⴻⴽⵙⴰⵡⴻⵏ ⵏ ⵍⴻⴱⵀⴰⵢⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","ⵉⵙⴻⵎ ⵏ ⵓⵎⴰⵙ ⵜⵓⵖⴰ ⴷ ⵢⵓⴱⴰⵍ ⵡⴻⵏⵏⵉ ⵜⵓⵖⴰ ⴷ ⴱⴰⴱⴰⵜⵙⴻⵏ ⵉ ⵎⴰⵔⵔⴰ ⵉⵏⵏⵉ ⵉⵜⵜⵉⵔⴰⵔⴻⵏ ⵍⴳⴰⵎⴱⵔⵉ ⴷ ⵜⴻⵎⵊⴰ. ");
INSERT INTO rift_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","ⵚⵉⵍⵍⴰ ⵜⵓⵔⵓⵡ-ⴷⴷ ⵄⴰⵡⴻⴷ ⵜⵓⴱⴰⵍ-ⵇⴰⵢⵉⵏ, ⴰⵎⵣⵉⵍ ⵏ ⵉⵎⵣⵉⵍⴻⵏ ⵏ ⵎⴰⵔⵔⴰ ⵉⵏⵏⵉ ⵉⵅⴻⴷⴷⵎⴻⵏ ⵙ ⵏⵏⵃⴰⵙ ⴷ ⵡⵓⵣⵣⴰⵍ. ⵓⵍⵜⵎⴰⵙ ⵏ ⵜⵓⴱⴰⵍ-ⵇⴰⵢⵉⵏ ⵜⵓⵖⴰ ⴷ ⵏⴰⵄⵎⴰ. ");
INSERT INTO rift_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","ⵉⵏⵏⴰ ⵍⴰⵎⴰⴽ ⵉ ⵜⴻⵎⵖⴰⵔⵉⵏ ⵏⵏⴻⵙ, ⵄⴰⴷⴰ ⴷ ⵚⵉⵍⵍⴰ: “ⵙⵍⴻⵏⵜ ⵉ ⵜⵎⵉⵊⵊⴰ ⵉⵏⵓ, ⴰ ⵜⵉⵎⵖⴰⵔⵉⵏ ⵏ ⵍⴰⵎⴰⴽ! ⵙⵍⴻⵏⵜ ⵖⴰⵔ ⵎⵉⵏ ⵖⴰ ⵉⵏⵉⵖ. ⴰⵇⴰ ⵏⵖⵉⵖ ⴰⵔⵢⴰⵣ ⵉ ⵓⵢⴻⵣⵣⵉⵎ ⵉⵏⵓ ⴷ ⵓⵃⴻⵏⵊⵉⵔ ⵉ ⵓⵢⴻⴷⴷⵉⵎ ⵉⵏⵓ! ");
INSERT INTO rift_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","ⴰⵇⴰ ⴰⴷ ⵅⴻⵍⴼⴻⵏ ⵣⵉ ⵇⴰⵢⵉⵏ ⵙⴻⴱⵄⴰ ⵏ ⵜⵡⴰⵍⴰⵡⵉⵏ, ⵎⴰⵛⴰ ⵣⵉ ⵍⴰⵎⴰⴽ ⵙⴻⴱⵄⴰ ⵓ-ⵙⴻⴱⵄⵉⵏ ⵏ ⵜⵡⴰⵍⴰⵡⵉⵏ.” ");
INSERT INTO rift_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","ⵢⵓⴷⴻⴼ ⴰⴷⴰⵎ ⵄⴰⵡⴻⴷ ⵅ ⵜⴰⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ ⵓⵛⴰ ⵜⵓⵔⵓⵡ-ⴷⴷ ⵏⴻⵜⵜⴰⵜ ⴰⵃⴻⵏⵊⵉⵔ. ⵜⵍⴰⵖⴰ ⴰⵙ ⵛⵉⵜ, ⵎⵉⵏⵣⵉ ⵜⴻⵏⵏⴰ: “ⴰⵔⴻⴱⴱⵉ ⵉⵡⵛⴰ ⴰⵢⵉ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵖⵏⵉ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏ ⵀⴰⴱⵉⵍ, ⵎⵉⵏⵣⵉ ⵇⴰⵢⵉⵏ ⵉⵏⵖⴰ ⵉ-ⵜ.” ");
INSERT INTO rift_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","ⵓⵍⴰ ⵉ ⵛⵉⵜ ⵉⵜⵜⵡⴰⵅⵍⴻⵇ-ⴷⴷ ⵓⵙⴻⵢⵎⵉ, ⵓⵛⴰ ⵉⴳⴳⴰ ⴰⵙ ⴰⵏⵓⵛ. ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⴱⴷⴰ ⴱⵏⴰⴷⴻⵎ ⵙ ⵓⵍⴰⵖⵉ ⵅ ⵢⵉⵙⴻⵎ ⵏ ⵙⵉⴷⵉ. ⵡⴰ ⴷ ⴰⴷⵍⵉⵙ ⵉⵜⵜⵡⴰⵏⴹⴻⵏ ⵏ ⵉⵎⴻⵣⵔⵓⵢⴻⵏ ⵏ ⵢⵉⵏⵏⵉ ⴷⴷ-ⵉⵜⵜⵡⴰⵅⴻⵍⵇⴻⵏ ⵣⵉ ⴰⴷⴰⵎ. ");
INSERT INTO rift_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","ⴰⵙⵙ ⵎⵉⵏ ⴷⵉ ⵉⴳⴳⴰ ⴰⵔⴻⴱⴱⵉ ⴰⴷⴰⵎ, ⵉⴳⴳⴰ ⵉ-ⵜ ⴷⵉ ⵚⵚⵉⴼⴻⵜ ⵏ ⴰⵔⴻⴱⴱⵉ. ");
INSERT INTO rift_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","ⴰⵡⵜⴻⵎ ⴷ ⵜⴻⵡⵜⴻⵎⵜ ⵉⵅⵍⴻⵇ ⵉ-ⵜⴻⵏ-ⴷⴷ. ⵉⴱⴰⵔⴽ ⵉ-ⵜⴻⵏ ⵓⵛⴰ ⵉⵍⴰⵖⴰ ⴰⵙⴻⵏ ⵙ ⵢⵉⵙⴻⵎ ‘ⴰⴷⴰⵎ’, ⴱⵏⴰⴷⴻⵎ, ⴷⴻⴳ ⵡⴰⵙⵙ ⵉ ⴷⵉ ⵜⴻⵏ ⴷⴷ-ⵉⵅⵍⴻⵇ.    ");
INSERT INTO rift_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⵉⴷⴷⴰⵔ ⴰⴷⴰⵎ ⵎⵢⴰ ⵓ-ⵜⵍⴰⵜⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵉⵊⵊⴰ-ⴷⴷ ⴰⵃⴻⵏⵊⵉⵔ ⴷⴻⴳ ⵡⴰⵔⵡⴰⵙ ⵏⵏⴻⵙ ⵓ ⴷⵉ ⵚⵚⵉⴼⴻⵜ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⵍⴰⵖⴰ ⴰⵙ ⵛⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⴷⴷ-ⵉⵊⵊⴰ ⵛⵉⵜ, ⵉⴷⴷⴰⵔ ⴰⴷⴰⵎ ⵄⴰⴷ ⵜⴻⵎⵏ-ⵎⵢⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵉⵊⵊⴰ-ⴷⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⴷ ⵜⵃⴻⵏⵊⵉⵔⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","ⴰⵎⵎⵓ ⵉ ⵉⴷⴷⴰⵔ ⴰⴷⴰⵎ ⵜⴻⵙⵄⴰ-ⵎⵢⴰ ⵓ-ⵜⵍⴰⵜⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵓⵛⴰ ⵉⵎⵎⵓⵜ. ");
INSERT INTO rift_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⵉⴷⴷⴰⵔ ⵛⵉⵜ ⵎⵢⴰ ⵓ-ⵅⴻⵎⵙⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵉⵊⵊⴰ-ⴷⴷ ⴰⵏⵓⵛ. ");
INSERT INTO rift_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⴷⴷ-ⵉⵊⵊⴰ ⴰⵏⵓⵛ, ⵉⴷⴷⴰⵔ ⵛⵉⵜ ⵄⴰⴷ ⵜⴻⵎⵏ-ⵎⵢⴰ ⵓ-ⵙⴻⴱⵄⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵉⵊⵊⴰ-ⴷⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⴷ ⵜⵃⴻⵏⵊⵉⵔⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","ⴰⵎⵎⵓ ⵉ ⵉⴷⴷⴰⵔ ⵛⵉⵜ ⵜⴻⵙⵄⴰ-ⵎⵢⴰ ⵓ-ⵜⴻⵏⵄⴰⵛ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵓⵛⴰ ⵉⵎⵎⵓⵜ. ");
INSERT INTO rift_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⵉⴷⴷⴰⵔ ⴰⵏⵓⵛ ⵜⴻⵙⵄⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵉⵊⵊⴰ-ⴷⴷ ⵇⵉⵏⴰⵏ.    ");
INSERT INTO rift_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⴷⴷ-ⵉⵊⵊⴰ ⵇⵉⵏⴰⵏ, ⵉⴷⴷⴰⵔ ⴰⵏⵓⵛ ⵄⴰⴷ ⵜⴻⵎⵏ-ⵎⵢⴰ ⵓ-ⵅⴻⵎⵎⴻⵙⵟⴰⵛ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵉⵊⵊⴰ-ⴷⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⴷ ⵜⵃⴻⵏⵊⵉⵔⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","ⴰⵎⵎⵓ ⵉ ⵉⴷⴷⴰⵔ ⴰⵏⵓⵛ ⵜⴻⵙⵄⴰ-ⵎⵢⴰ ⵓ-ⵅⴻⵎⵙⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵓⵛⴰ ⵉⵎⵎⵓⵜ. ");
INSERT INTO rift_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⵉⴷⴷⴰⵔ ⵇⵉⵏⴰⵏ ⵙⴻⴱⵄⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵉⵊⵊⴰ-ⴷⴷ ⵎⴰⵀⴰⵍⴰⵍ-ⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⴷⴷ-ⵉⵊⵊⴰ ⵎⴰⵀⴰⵍⴰⵍ-ⵉⵍ, ⵉⴷⴷⴰⵔ ⵇⵉⵏⴰⵏ ⵄⴰⴷ ⵜⴻⵎⵏ-ⵎⵢⴰ ⵓ-ⵔⴻⴱⵄⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵉⵊⵊⴰ-ⴷⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⴷ ⵜⵃⴻⵏⵊⵉⵔⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","ⴰⵎⵎⵓ ⵉ ⵉⴷⴷⴰⵔ ⵇⵉⵏⴰⵏ ⵜⴻⵙⵄⴰ-ⵎⵢⴰ ⵓ-ⵄⴻⵛⵔⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵓⵛⴰ ⵉⵎⵎⵓⵜ. ");
INSERT INTO rift_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⵉⴷⴷⴰⵔ ⵎⴰⵀⴰⵍⴰⵍ-ⵉⵍ ⵅⴻⵎⵙⴰ ⵓ-ⵙⴻⵜⵜⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵉⵊⵊⴰ-ⴷⴷ ⵢⴰⵔⴰⴷ. ");
INSERT INTO rift_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⴷⴷ-ⵉⵊⵊⴰ ⵢⴰⵔⴰⴷ, ⵉⴷⴷⴰⵔ ⵎⴰⵀⴰⵍⴰⵍ-ⵉⵍ ⵄⴰⴷ ⵜⴻⵎⵏ-ⵎⵢⴰ ⵓ-ⵜⵍⴰⵜⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵉⵊⵊⴰ-ⴷⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⴷ ⵜⵃⴻⵏⵊⵉⵔⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","ⴰⵎⵎⵓ ⵉ ⵉⴷⴷⴰⵔ ⵎⴰⵀⴰⵍⴰⵍ-ⵉⵍ ⵜⴻⵎⵏ-ⵎⵢⴰ ⵓ-ⵅⴻⵎⵙⴰ ⵓ-ⵜⴻⵙⵄⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵓⵛⴰ ⵉⵎⵎⵓⵜ. ");
INSERT INTO rift_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⵉⴷⴷⴰⵔ ⵢⴰⵔⴰⴷ ⵎⵢⴰ ⵓ-ⵜⵏⴰⵢⴻⵏ ⵓ-ⵙⴻⵜⵜⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵉⵊⵊⴰ-ⴷⴷ ⵃⴰⵏⵓⵅ.    ");
INSERT INTO rift_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⴷⴷ-ⵉⵊⵊⴰ ⵃⴰⵏⵓⵅ, ⵉⴷⴷⴰⵔ ⵢⴰⵔⴰⴷ ⵄⴰⴷ ⵜⴻⵎⵏ-ⵎⵢⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵉⵊⵊⴰ-ⴷⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⴷ ⵜⵃⴻⵏⵊⵉⵔⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","ⴰⵎⵎⵓ ⵉ ⵉⴷⴷⴰⵔ ⵢⴰⵔⴰⴷ ⵜⴻⵙⵄⴰ-ⵎⵢⴰ ⵓ-ⵜⵏⴰⵢⴻⵏ ⵓ-ⵙⴻⵜⵜⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵓⵛⴰ ⵉⵎⵎⵓⵜ. ");
INSERT INTO rift_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⵉⴷⴷⴰⵔ ⵃⴰⵏⵓⵅ ⵅⴻⵎⵙⴰ ⵓ-ⵙⴻⵜⵜⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵉⵊⵊⴰ-ⴷⴷ ⵎⴰⵜⵓⵛⴰⵍⴰⵃ.    ");
INSERT INTO rift_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⴷⴷ-ⵉⵊⵊⴰ ⵎⴰⵜⵓⵛⴰⵍⴰⵃ, ⵢⵓⵢⵓⵔ ⵃⴰⵏⵓⵅ ⴰⴽ-ⴷ ⴰⵔⴻⴱⴱⵉ ⵜⴻⵍⵜ-ⵎⵢⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵉⵊⵊⴰ-ⴷⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⴷ ⵜⵃⴻⵏⵊⵉⵔⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","ⴰⵎⵎⵓ ⵉ ⵉⴷⴷⴰⵔ ⵃⴰⵏⵓⵅ ⵜⴻⵍⵜ-ⵎⵢⴰ ⵓ-ⵅⴻⵎⵙⴰ ⵓ-ⵙⴻⵜⵜⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","ⵢⵓⵢⵓⵔ ⵃⴰⵏⵓⵅ ⴰⴽ-ⴷ ⴰⵔⴻⴱⴱⵉ ⵓⵛⴰ ⵡⴰⵔ ⵉⵜⵜⵡⵉⴼ ⵄⴰⴷ ⵎⵉⵏⵣⵉ ⴰⵔⴻⴱⴱⵉ ⵉⴽⵙⵉ ⵉ-ⵜ. ");
INSERT INTO rift_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⵉⴷⴷⴰⵔ ⵎⴰⵜⵓⵛⴰⵍⴰⵃ ⵎⵢⴰ ⵓ-ⵙⴻⴱⵄⴰ ⵓ-ⵜⵎⴰⵏⵢⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵉⵊⵊⴰ-ⴷⴷ ⵍⴰⵎⴰⴽ. ");
INSERT INTO rift_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⴷⴷ-ⵉⵊⵊⴰ ⵍⴰⵎⴰⴽ, ⵉⴷⴷⴰⵔ ⵎⴰⵜⵓⵛⴰⵍⴰⵃ ⵄⴰⴷ ⵙⴻⴱⵄⴰ-ⵎⵢⴰ ⵓ-ⵜⵏⴰⵢⴻⵏ ⵓ-ⵜⵎⴰⵏⵢⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵉⵊⵊⴰ-ⴷⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⴷ ⵜⵃⴻⵏⵊⵉⵔⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","ⴰⵎⵎⵓ ⵉ ⵉⴷⴷⴰⵔ ⵎⴰⵜⵓⵛⴰⵍⴰⵃ ⵜⴻⵙⵄⴰ-ⵎⵢⴰ ⵓ-ⵜⴻⵙⵄⴰ ⵓ-ⵙⴻⵜⵜⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵓⵛⴰ ⵉⵎⵎⵓⵜ. ");
INSERT INTO rift_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⵉⴷⴷⴰⵔ ⵍⴰⵎⴰⴽ ⵎⵢⴰ ⵓ-ⵜⵏⴰⵢⴻⵏ ⵓ-ⵜⵎⴰⵏⵢⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵉⵊⵊⴰ-ⴷⴷ ⵉⵊⵊ ⵏ ⵓⵃⴻⵏⵊⵉⵔ. ");
INSERT INTO rift_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","ⵉⵍⴰⵖⴰ ⵉⵙⴻⵎ ⵏⵏⴻⵙ ⵏⵓⵃ, ⵉⵏⵏⴰ: “ⵡⴰ ⴰⴷ ⴰⵏⴻⵖ ⵉⵙⵙⴼⴻⵡⵡⴻⵊ ⵅ ⵍⵅⴻⴷⵎⴻⵜ ⵏⵏⴻⵖ ⴷ ⵜⴰⵎⴰⵔⴰ ⵏ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵏⴻⵖ, ⵎⵉⵏⵣⵉ ⵙⵉⴷⵉ ⴰⵇⴰ ⵉⵏⵄⴻⵍ ⵜⴰⵎⵎⵓⵔⵜ!” ");
INSERT INTO rift_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⴷⴷ-ⵉⵊⵊⴰ ⵏⵓⵃ, ⵉⴷⴷⴰⵔ ⵍⴰⵎⴰⴽ ⵄⴰⴷ ⵅⴻⵎⵙⴰ-ⵎⵢⴰ ⵓ-ⵅⴻⵎⵙⴰ ⵓ-ⵜⴻⵙⵄⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵉⵊⵊⴰ-ⴷⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⴷ ⵜⵃⴻⵏⵊⵉⵔⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","ⴰⵎⵎⵓ ⵉ ⵉⴷⴷⴰⵔ ⵍⴰⵎⴰⴽ ⵙⴻⴱⵄⴰ-ⵎⵢⴰ ⵓ-ⵙⴻⴱⵄⴰ ⵓ-ⵙⴻⴱⵄⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵓⵛⴰ ⵉⵎⵎⵓⵜ. ");
INSERT INTO rift_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⵉⴷⴷⴰⵔ ⵏⵓⵃ ⵅⴻⵎⵙⴰ-ⵎⵢⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵏⵓⵃ ⵉⵊⵊⴰ-ⴷⴷ ⵛⴰⵎ ⴷ ⵃⴰⵎ ⴷ ⵢⴰⴼⴰⵜ. ");
INSERT INTO rift_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","ⵍⴰⵎⵉ ⴱⴷⴰⵏ ⵉⵡⴷⴰⵏ ⴰⴷ ⴽⵜⴰⵔⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵓⵛⴰ ⵓⵔⵡⴻⵏⵜ ⴰⵙⴻⵏ-ⴷⴷ ⵢⴻⵙⵙⵉⵜⵙⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","ⴰⵇⴰ ⵥⵔⵉⵏ ⴰⵔⵔⴰⵡⴻⵏ ⵏ ⴰⵔⴻⴱⴱⵉ ⴱⴻⵍⵍⵉ ⵢⴻⵙⵙⵉⵙ ⵏ ⴱⵏⴰⴷⴻⵎ ⵛⵏⴰⵏⵜ, ⵓⵛⴰ ⴽⵙⵉⵏ ⵜⵉⵎⵖⴰⵔⵉⵏ ⵉ ⵢⵉⵅⴻⴼ ⵏⵙⴻⵏ ⵣⵉ ⵎⴰⵔⵔⴰ ⵜⵉⵏⵏⵉ ⵉⵅⴹⴰⵔⴻⵏ ⵏⵉⵜⵏⵉ.    ");
INSERT INTO rift_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵙⵉⴷⵉ: “ⵡⴰⵔ ⵉⵜⵜⵖⵉⵎⵉ ⴰⵔⵔⵓⵃ ⵉⵏⵓ ⵍⴻⴱⴷⴰ ⴷⵉ ⴱⵏⴰⴷⴻⵎ, ⴰⵇⴰ-ⵜ ⴷ ⴷⴷⴰⵜ ⵣⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⵓⵡⴻⴷⴷⴰⵔ ⵏⵏⴻⵙ. ⴰⴷ ⵉⵍⵉⵏ ⵡⵓⵙⵙⴰⵏ ⵏ ⵜⵓⴷⴰⵔⵜ ⵏⵏⴻⵙ ⵎⵢⴰ ⵓ-ⵄⵉⵛⵔⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ.” ");
INSERT INTO rift_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","ⴷⴻⴳ ⵡⵓⵙⵙⴰⵏ ⵏⵏⵉ ⵜⵓⵖⴰ ‘ⵉⵏⵉⴼⵉⵍⵉⵎ’, ⵉⵅⵙ ⴰⴷ ⵢⵉⵏⵉ ‘ⵉⵏⵏⵉ ⵉⵡⴹⴰⵏ’, ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵓⵛⴰ ⴰⵡⴰⵔⵏⵉ ⵎⴰⵏ ⴰⵢⴰ ⵄⴰⵡⴻⴷ, ⵓⵎⵉ ⴷⴷ-ⵓⴷⴼⴻⵏ ⴰⵔⵔⴰⵡ ⵏ ⴰⵔⴻⴱⴱⵉ ⵖⴰⵔ ⵢⴻⵙⵙⵉⵙ ⵏ ⵉⵡⴷⴰⵏ ⵓⵛⴰ ⵓⵔⵡⴻⵏⵜ ⴰⵙⴻⵏ-ⴷⴷ. ⵏⵉⵜⵏⵉ ⴷ ‘ⵊⵊⵡⴰⵀⴻⵍ’ ⵏ ⵣⵣⵎⴰⵏ ⵏⵏⵉ, ⴷ ⵉⵔⵢⴰⵣⴻⵏ ⵙ ⵢⵉⵙⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","ⵉⵥⵔⴰ ⵙⵉⴷⵉ ⴱⴻⵍⵍⵉ ⵍⵖⴰⵔ ⵏ ⴱⵏⴰⴷⴻⵎ ⴷ ⴰⵟⵟⴰⵙ ⵅ ⵜⴻⵎⵎⵓⵔⵜ ⵓⵛⴰ ⵎⴰⵔⵔⴰ ⵍⴻⵎⵡⴰⵢⴰⵍ ⵏ ⵓⵅⴰⵔⵔⴻⵚ ⵏ ⵡⵓⵍ ⵏⵏⴻⵙ ⴷ ⴰⵄⴻⴼⴼⴰⵏ ⴽⵓⵍ ⴰⵙⵙ. ");
INSERT INTO rift_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","ⵓⵛⴰ ⵉⵏⴷⴻⵎ ⵙⵉⴷⵉ ⵓⵎⵉ ⵉⴳⴳⴰ ⴱⵏⴰⴷⴻⵎ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵓⵛⴰ ⵉⵇⵇⴻⵙ ⴰⵙ ⵡⵓⵍ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","ⵉⵏⵏⴰ ⵙⵉⴷⵉ: “ⴰⴷ ⵎⵃⵉⵖ ⵅ ⵡⵓⴷⴻⵎ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⴱⵏⴰⴷⴻⵎ ⵉ ⴷⴷ-ⵅⴻⵍⵇⴻⵖ, ⴱⵏⴰⴷⴻⵎ ⴰⴽ-ⴷ ⵍⴻⴱⵀⴰⵢⴻⵎ ⴷ ⵉⵎⵓⴷⴷⴰⵔⴻⵏ ⵉⵜⵜⴱⵓⵄⴻⵏ ⵓⵍⴰ ⴷ ⵉⵊⴹⴰⴹ ⵏ ⵓⵊⴻⵏⵏⴰ, ⵎⵉⵏⵣⵉ ⵏⴻⴷⵎⴻⵖ ⵓⵎⵉ ⵜⴻⵏ ⴳⴳⵉⵖ.” ");
INSERT INTO rift_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","ⵎⴰⵛⴰ ⵏⵓⵃ ⵢⵓⴼⴰ ⴰⵔⴹⴰ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵙⵉⴷⵉ. ⵉⵏⴰ ⴷ ⵉⵎⴻⵣⵔⵓⵢⴻⵏ ⵏ ⵢⵉⵏⵏⵉ ⴷⴷ-ⵉⵜⵜⵡⴰⵅⴻⵍⵇⴻⵏ ⵣⵉ ⵏⵓⵃ. ");
INSERT INTO rift_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","ⵜⵓⵖⴰ ⵏⵓⵃ ⴷ ⴰⵔⵢⴰⵣ ⴷ ⴰⵎⵙⴻⴳⴳⴻⴷ ⵉⴽⵎⴻⵍ ⵊⴰⵔ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵏⵏⵉ ⵉⴷⴷⴰⵔⴻⵏ ⴰⴽⵉⴷⴻⵙ. ⵢⵓⵢⵓⵔ ⵏⵓⵃ ⴰⴽ-ⴷ ⴰⵔⴻⴱⴱⵉ. ");
INSERT INTO rift_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","ⵓⵛⴰ ⵉⵊⵊⴰ-ⴷⴷ ⵏⵓⵃ ⵜⵍⴰⵜⴰ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ: ⵛⴰⵎ ⴷ ⵃⴰⵎ ⴷ ⵢⴰⴼⴰⵜ. ");
INSERT INTO rift_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","ⵜⵓⵖⴰ ⵜⴰⵎⵎⵓⵔⵜ ⴷ ⵉⵛⵜ ⵏ ⵍⵅⴰⵔⴱⴻⵜ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⴰⵔⴻⴱⴱⵉ ⵓ ⵜⵓⵖⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵜⴻⵛⵛⵓⵔ ⵙ ⵍⵄⵓⵏⴼ. ");
INSERT INTO rift_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","ⵉⵅⵣⴰⵔ ⴰⵔⴻⴱⴱⵉ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ, ⵓ ⵅⵣⴰⵔ, ⴰⵇⴰ-ⵜⵜ ⴷ ⵍⵅⴰⵔⴱⴻⵜ, ⵎⴰⵖⴰⵔ ⵎⴰⵔⵔⴰ ⵉⵎⴻⴷⴷⴰⵔⴻⵏ ⵙ ⴰⵔⵔⵉⵎⴻⵜ ⵏ ⵡⴻⵢⵙⵓⵎ ⵜⵓⵖⴰ ⵅⴰⵔⵔⴱⴻⵏ ⴰⴱⵔⵉⴷ ⵏⵙⴻⵏ ⵅ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","ⵉⵏⵏⴰ ⴰⵔⴻⴱⴱⵉ ⵉ ⵏⵓⵃ: “ⴰⵏⴻⴳⴳⴰⵔ ⵏ ⵎⴰⵔⵔⴰ ⵉⵎⴻⴷⴷⴰⵔⴻⵏ ⵙ ⴰⵔⵔⵉⵎⴻⵜ ⵏ ⵡⴻⵢⵙⵓⵎ ⴰⵇⴰ-ⵜ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵉⵏⵓ, ⵎⵉⵏⵣⵉ ⵜⴰⵎⵎⵓⵔⵜ ⵜⴻⵛⵛⵓⵔ ⵙ ⵍⵄⵓⵏⴼ ⵣⵣⴰⵢⵙⴻⵏ. ⴰⵇⴰ ⴰⴷ ⵜⴻⵏ ⵜⴻⵃⵃⵉⵖ ⴰⴽ-ⴷ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","ⴻⴳⴳ ⵉ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵛ ⵉⵊⵊ ⵏ ⵓⵖⴰⵔⵔⴰⴱⵓ ⵙ ⵓⴽⴻⵛⵛⵓⴹ ⵏ ⵓⵎⴻⵔⵣⵉ ⵓⵛⴰ ⴻⴳⴳ ⵉⵅⵅⴰⵎⴻⵏ ⵉ ⵎⴰⵔⵔⴰ ⵍⵎⴰⵍ ⴷⴻⴳ ⵓⵖⴰⵔⵔⴰⴱⵓ. ⵖⴻⴵⴻⴼ ⴰⵖⴰⵔⵔⴰⴱⵓ ⵣⵉ ⴷⴰⵅⴻⵍ ⵓ ⵣⵉ ⴱⴰⵔⵔⴰ ⵙ ⵜⵉⵣⴻⴼⵜ. ");
INSERT INTO rift_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","ⴰⵎⵎⵓ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜ ⵜⴻⴳⴳⴻⴷ: ⵜⵓⵣⵣⴻⴳⴳⴰⵔⵜ ⵏ ⵓⵖⴰⵔⵔⴰⴱⵓ ⴰⴷ ⵜⵉⵍⵉ ⵜⴻⵍⵜ-ⵎⵢⴰ ⵏ ⵉⵖⴰⴵⴻⵏ ⵓ ⵜⵉⵔⵓ ⵏ ⵓⵖⴰⵔⵔⴰⴱⵓ ⴰⴷ ⵜⵉⵍⵉ ⵅⴻⵎⵙⵉⵏ ⵏ ⵉⵖⴰⴵⴻⵏ ⵓ ⵍⵓⵄⵍⴰ ⵏⵏⴻⵙ ⴰⴷ ⵢⵉⵍⵉ ⵜⵍⴰⵜⵉⵏ ⵏ ⵉⵖⴰⴵⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵉⵛⵜ ⵏ ⵜⴱⵓⵔⵊⴻⵜ ⵉ ⵜⴼⴰⵡⵜ ⴷⴻⴳ ⵓⵖⴰⵔⵔⴰⴱⵓ ⵓⵛⴰ ⴰⴷ ⵜⵜ ⵜⴽⴻⵎⵎⵍⴻⴷ ⴰⵏⴻⵛⵜ ⵏ ⵉⵊⵊ ⵏ ⵓⵖⵉⵍ ⵣⵉ ⵙⴻⵏⵏⴻⵊ. ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵜⴰⵡⵡⴰⵔⵜ ⵏ ⵓⵖⴰⵔⵔⴰⴱⵓ ⴷⴻⴳ ⵓⵖⴻⵣⴷⵉⵙ ⵏⵏⴻⵙ. ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵟⵟⴻⴱⵇⴻⵜ ⵏ ⵡⴰⴷⴷⴰⵢ ⴷ ⵟⵟⴻⴱⵇⴻⵜ ⵡⵉⵙⵙ ⵜⵏⴰⵢⴻⵏ ⴷⵉ ⵍⵡⴻⵙⵟ ⴷ ⵟⵟⴻⴱⵇⴻⵜ ⵡⵉⵙⵙ ⵜⵍⴰⵜⴰ ⵙⴻⵏⵏⴻⵊ. ");
INSERT INTO rift_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","ⴰⵇⴰ ⵏⴻⵛⵛ ⴰⴷ ⵙⵙⴻⴽⴽⴻⵖ ⵙⵙⴻⵃⵍⴻⵜ ⵏ ⵡⴰⵎⴰⵏ ⵅ ⵜⴻⵎⵎⵓⵔⵜ, ⵃⵉⵎⴰ ⴰⴷ ⵜⴻⵃⵃⵉⵖ ⵙⴰⴷⵓ ⵓⵊⴻⵏⵏⴰ ⵎⴰⵔⵔⴰ ⵉⵎⴻⴷⴷⴰⵔⴻⵏ ⵙ ⴰⵔⵔⵉⵎⴻⵜ ⵏ ⵡⴻⵢⵙⵓⵎ ⵉ ⴷⵉ ⵉⴵⴰ ⴰⵔⵔⵓⵃ ⵏ ⵜⵓⴷⴰⵔⵜ. ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⴵⴰⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⴰⴷ ⵉⴹⵍⴻⵇ ⵉ ⴱⵓⵃⴱⴻⵍ. ");
INSERT INTO rift_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","ⵎⴰⵛⴰ ⴰⴷ ⵙⵙⴱⴻⴷⴷⴻⵖ ⵍⵄⴰⵀⴷ ⵉⵏⵓ ⴰⴽⵉⴷⴻⴽ ⵓⵛⴰ ⵛⴻⴽ ⴰⴷ ⵜⴰⴷⴼⴻⴷ ⵖⴰⵔ ⵓⵖⴰⵔⵔⴰⴱⵓ, ⵛⴻⴽ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵛ ⴷ ⵜⴻⵎⵖⴰⵔⵜ ⵏⵏⴻⵛ ⴷ ⵜⴻⵎⵖⴰⵔⵉⵏ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵛ ⴰⴽⵉⴷⴻⴽ. ");
INSERT INTO rift_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","ⵓⵛⴰ ⵣⵉ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⴷⴷⴰⵔⴻⵏ, ⵣⵉ ⵎⴰⵔⵔⴰ ⵉⵎⴻⴷⴷⴰⵔⴻⵏ ⵙ ⴰⵔⵔⵉⵎⴻⵜ ⵏ ⵡⴻⵢⵙⵓⵎ ⴰⴷ ⵜⴻⵙⵙⵉⴷⴼⴻⴷ ⵜⵢⵓⵢⴰ ⵖⴰⵔ ⵓⵖⴰⵔⵔⴰⴱⵓ ⵃⵉⵎⴰ ⴰⴷ ⴷⴷⴰⵔⴻⵏ ⴰⴽⵉⴷⴻⴽ: ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⴰⵡⵜⴻⵎ ⴷ ⵜⴻⵡⵜⴻⵎⵜ. ");
INSERT INTO rift_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","ⴰⴷ ⵖⴰⵔⴻⴽ ⴷⴷ-ⵜⴰⵙ ⵜⵢⵓⵢⴰ ⵣⵉ ⵎⴰⵔⵔⴰ, ⵃⵉⵎⴰ ⴰⴷ ⵜⴻⵃⴹⵉⴷ ⵜⵓⴷⴰⵔⵜ ⵏⵙⴻⵏ: ⵣⴻⴳ ⵉⵊⴹⴰⴹ ⵄⵍⴰⵃⵙⴰⴱ ⵎⴰⵔⴽⴰⵜ ⵏⵙⴻⵏ, ⵣⵉ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵄⵍⴰⵃⵙⴰⴱ ⵎⴰⵔⴽⴰⵜ ⵏⵙⴻⵏⵜ ⵓ ⵣⵉ ⵎⴰⵔⵔⴰ ⵉⵎⵓⴷⴷⴰⵔⴻⵏ ⵏⵏⵉ ⵉⵜⵜⴱⵓⵄⴻⵏ ⵅ ⵜⴻⵎⵎⵓⵔⵜ ⵄⵍⴰⵃⵙⴰⴱ ⵎⴰⵔⴽⴰⵜ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","ⵓⵛⴰ ⵛⴻⴽ, ⴽⵙⵉ ⵉ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵛ ⵣⵉ ⵎⴰⵔⵔⴰ ⵎⴰⵛⵛⴰ ⵉ ⵉⵜⵜⵡⴰⵛⵛⴰⵏ ⵓⵛⴰ ⵙⵎⵓⵏ ⵉ-ⵜⵜ ⵖⴰⵔⴻⴽ, ⵃⵉⵎⴰ ⴰⴷ ⴰⵛ ⵢⵉⵍⵉ ⴷ ⵎⴰⵛⵛⴰ ⵓⵛⴰ ⵓⵍⴰ ⵉ ⵏⵉⵜⵏⵉ.” ");
INSERT INTO rift_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","ⵓⵛⴰ ⵉⴳⴳⴰ ⵏⵓⵃ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵎⴰⵔⵔⴰ ⵉ ⵅⴻⴼ ⵜ ⵉⵡⴻⵚⵚⴰ ⴰⵔⴻⴱⴱⵉ, ⴰⵎⵎⵓ ⵉ ⵜ ⵉⴳⴳⴰ. ");
INSERT INTO rift_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵏⵓⵃ: “ⴰⴷⴻⴼ ⵛⴻⴽ ⴷ ⵎⴰⵔⵔⴰ ⵍⴰⴵ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⴻⵛ ⵖⴰⵔ ⵓⵖⴰⵔⵔⴰⴱⵓ, ⵎⵉⵏⵣⵉ ⵥⵔⵉⵖ ⵛⴻⴽ ⴷ ⴰⵎⵙⴻⴳⴳⴻⴷ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵉⵏⵓ ⴷⵉ ⵊⵊⵉⵍ-ⴰ. ");
INSERT INTO rift_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","ⵣⵉ ⵎⴰⵔⵔⴰ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏ ⵍⴻⵃⵍⴰⵍ ⴰⴷ ⵖⴰⵔⴻⴽ ⵜⴻⴽⵙⵉⴷ ⵙⴻⴱⵄⴰ, ⵙⴻⴱⵄⴰ, ⴰⵡⵜⴻⵎ ⴷ ⵜⴻⵡⵜⴻⵎⵜ ⵏⵏⴻⵙ, ⵓ ⵣⵉ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏ ⵍⴻⵃⵔⴰⵎ ⵜⵢⵓⵢⴰ, ⴰⵡⵜⴻⵎ ⴷ ⵜⴻⵡⵜⴻⵎⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","ⵓⵍⴰ ⵣⴻⴳ ⵉⵊⴹⴰⴹ ⵏ ⵓⵊⴻⵏⵏⴰ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜⴻⴽⵙⵉⴷ ⵙⴻⴱⵄⴰ ⵏ ⵜⵉⵢⵓⵢⴰⵡⵉⵏ, ⴰⵡⵜⴻⵎ ⴷ ⵜⴻⵡⵜⴻⵎⵜ, ⵃⵉⵎⴰ ⴰⴷ ⵜⴻⵃⴹⵉⴷ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵙⴻⵏ ⵉ ⵜⵓⴷⴰⵔⵜ ⴷⵉ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ, ");
INSERT INTO rift_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","ⵎⵉⵏⵣⵉ ⵅⵎⵉ ⵖⴰ ⵄⴷⵓⵏ ⵄⴰⴷ ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⵏⴻⵛⵛ ⴰⴷ ⵊⵊⴻⵖ ⴰⵏⵥⴰⵔ ⴰⴷ ⵉⵡⵡⴻⵜ ⵅ ⵜⴻⵎⵎⵓⵔⵜ ⴰⵔⴻⴱⵄⵉⵏ ⵏ ⵡⵓⵙⵙⴰⵏ ⴷ ⴰⵔⴻⴱⵄⵉⵏ ⵏ ⴵⵢⴰⵍⵉ, ⵓⵛⴰ ⴰⴷ ⵜⴻⵃⵃⵉⵖ ⵣⴻⴳ ⵡⵓⴷⴻⵎ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⴵⴰⵏ, ⴷ ⵎⵉⵏ ⴳⴳⵉⵖ ⵏⴻⵛⵛ.” ");
INSERT INTO rift_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","ⵓⵛⴰ ⵉⴳⴳⴰ ⵏⵓⵃ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴽⵓⵍⵛⵉ ⵉ ⵅⴻⴼ ⵜ ⵉⵡⴻⵚⵚⴰ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","ⵜⵓⵖⴰ ⵏⵓⵃ ⴷ ⵎⵎⵉⵙ ⵏ ⵙⴻⵜⵜⴰ-ⵎⵢⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵍⴰⵎⵉ ⴷⴷ-ⵜⵓⵙⴰ ⵙⵙⴻⵃⵍⴻⵜ ⵏ ⵡⴰⵎⴰⵏ ⵅ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","ⵓⵛⴰ ⵢⵓⴷⴻⴼ ⵏⵓⵃ ⵖⴰⵔ ⵓⵖⴰⵔⵔⴰⴱⵓ ⴷⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⵡⴰⵎⴰⵏ ⵏ ⵙⵙⴻⵃⵍⴻⵜ, ⵏⴻⵜⵜⴰ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ ⴷ ⵜⴻⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ ⴷ ⵜⴻⵎⵖⴰⵔⵉⵏ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ ⴰⴽⵉⴷⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","ⵣⵉ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏ ⵍⴻⵃⵍⴰⵍ ⵓ ⵣⵉ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏ ⵍⴻⵃⵔⴰⵎ ⵓ ⵣⴻⴳ ⵉⵊⴹⴰⴹ ⵓ ⵣⵉ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⵜⵜⴱⵓⵄⴻⵏ ⵅ ⵡⵓⴷⴻⵎ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ");
INSERT INTO rift_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","ⵜⵓⴷⴻⴼ ⵜⵢⵓⵢⴰ ⵙ ⵜⵢⵓⵢⴰ ⵖⴰⵔ ⵏⵓⵃ ⵖⴰⵔ ⵓⵖⴰⵔⵔⴰⴱⵓ, ⴰⵡⵜⴻⵎ ⴷ ⵜⴻⵡⵜⴻⵎⵜ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵉⵡⴻⵚⵚⴰ ⴰⵔⴻⴱⴱⵉ ⵉ ⵏⵓⵃ. ");
INSERT INTO rift_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","ⴰⵡⴰⵔⵏⵉ ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⵉⵎⵙⴰⵔ ⴱⴻⵍⵍⵉ ⴰⵎⴰⵏ ⵏ ⵙⵙⴻⵃⵍⴻⵜ ⵓⵙⵉⵏ-ⴷⴷ ⵅ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","ⴷⴻⴳ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵡⵉⵙⵙ ⵙⴻⵜⵜⴰ-ⵎⵢⴰ ⵣⵉ ⵜⵓⴷⴰⵔⵜ ⵏ ⵏⵓⵃ, ⴷⴻⴳ ⵓⵢⵓⵔ ⵡⵉⵙⵙ ⵜⵏⴰⵢⴻⵏ, ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴱⴻⵄⵟⴰⵛ ⵏ ⵓⵢⵓⵔ ⵏⵏⵉ, ⴷⴻⴳ ⵡⴰⵙⵙ-ⴰ ⵏⵏⵉⵜ, ⵜⵓⵖⴰ ⵙⵙⴻⴼⵢⴻⵏ-ⴷⴷ ⵎⴰⵔⵔⴰ ⵍⵄⵓⵏⵚⴰⵔⴰⵜ ⵏ ⵡⴰⵎⴰⵏ ⵉⵀⴻⵡⵍⴻⵏ ⵓⵛⴰ ⵜⵜⵡⴰⵔⴻⵣⵎⴻⵏⵜ ⵜⴱⵓⵔⵊⴰⵜⵉⵏ ⵏ ⵓⵊⴻⵏⵏⴰ. ");
INSERT INTO rift_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","ⵜⵓⵖⴰ ⴰⵏⵥⴰⵔ ⵉⵇⵇⵉⵎ ⵉⵛⵛⴰⵜ ⵙ ⵊⵊⴻⵀⴷ ⵅ ⵜⴻⵎⵎⵓⵔⵜ ⴰⵔⴻⴱⵄⵉⵏ ⵏ ⵡⵓⵙⵙⴰⵏ ⴷ ⴰⵔⴻⴱⵄⵉⵏ ⵏ ⴵⵢⴰⵍⵉ. ");
INSERT INTO rift_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","ⴷⴻⴳ ⵡⴰⵙⵙ ⵏⵏⵉ ⵏⵏⵉⵜ ⵜⵓⵖⴰ ⵏⵓⵃ ⵢⵓⴷⴻⴼ ⵖⴰⵔ ⵓⵖⴰⵔⵔⴰⴱⵓ ⴰⴽ-ⴷ ⵛⴰⵎ ⴷ ⵃⴰⵎ ⴷ ⵢⴰⴼⴰⵜ, ⴰⵢⵜ ⵏ ⵏⵓⵃ, ⵓⵍⴰ ⴰⴽ-ⴷ ⵜⴰⵎⵖⴰⵔⵜ ⵏ ⵏⵓⵃ ⵓ ⴰⴽ-ⴷ ⵜⵍⴰⵜⴰ ⵏ ⵜⴻⵎⵖⴰⵔⵉⵏ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ ⴰⴽⵉⴷⵙⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","ⵏⵉⵜⵏⵉ ⴷ ⵎⴰⵔⵔⴰ ⵎⴰⵔⴽⴰⵜ ⵏ ⵍⵎⴰⵍ ⵏ ⵍⴻⵅⵍⴰ ⴷ ⵎⴰⵔⵔⴰ ⵎⴰⵔⴽⴰⵜ ⵏ ⵍⴻⴱⵀⴰⵢⴻⵎ ⴷ ⵎⴰⵔⵔⴰ ⵎⴰⵔⴽⴰⵜ ⵏ ⵉⵎⵓⴷⴷⴰⵔⴻⵏ ⵏⵏⵉ ⵉⵜⵜⴱⵓⵄⴻⵏ ⵅ ⵜⴻⵎⵎⵓⵔⵜ ⴷ ⵎⴰⵔⵔⴰ ⵎⴰⵔⴽⴰⵜ ⵏ ⵉⵊⴹⴰⴹ, ⵎⴰⵔⵔⴰ ⴰⵊⴹⵉⴹ, ⴷ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵖⴰⵔ ⵉⴵⴰ ⴰⴼⵔⵉⵡⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","ⵣⵉ ⵎⴰⵔⵔⴰ ⵉⵎⴻⴷⴷⴰⵔⴻⵏ ⵙ ⴰⵔⵔⵉⵎⴻⵜ ⵏ ⵡⴻⵢⵙⵓⵎ ⵉ ⴷⵉ ⵉⴵⴰ ⴰⵔⵔⵓⵃ ⵏ ⵜⵓⴷⴰⵔⵜ, ⵜⵓⵙⴰ-ⴷⴷ ⵜⵢⵓⵢⴰ ⵙ ⵜⵢⵓⵢⴰ ⵖⴰⵔ ⵏⵓⵃ ⵖⴰⵔ ⵓⵖⴰⵔⵔⴰⴱⵓ. ");
INSERT INTO rift_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","ⵓ ⵣⵉ ⵎⴰⵔⵔⴰ ⵉⵎⴻⴷⴷⴰⵔⴻⵏ ⵙ ⴰⵔⵔⵉⵎⴻⵜ ⵏ ⵡⴻⵢⵙⵓⵎ ⵉ ⴷⴷ-ⵢⵓⵙⵉⵏ, ⵢⵓⴷⴻⴼ ⵉⵊⵊ ⵏ ⵡⴻⵡⵜⴻⵎ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵜⴻⵎⵜ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜ ⵢⵓⵎⵓⵔ ⴰⵔⴻⴱⴱⵉ, ⵓⵛⴰ ⵉⵇⵇⴻⵏ ⵙⵉⴷⵉ ⵜⴰⵡⵡⴰⵔⵜ ⴰⵡⴰⵔⵏⵉ ⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","ⵜⵓⵖⴰ ⵙⵙⴻⵃⵍⴻⵜ ⵅ ⵜⴻⵎⵎⵓⵔⵜ ⴰⵔⴻⴱⵄⵉⵏ ⵏ ⵡⵓⵙⵙⴰⵏ ⵓⵛⴰ ⴳⴻⵄⵄⴷⴻⵏ ⵡⴰⵎⴰⵏ ⵓⵛⴰ ⵙⵙⴳⴻⵄⵄⴷⴻⵏ ⴰⵖⴰⵔⵔⴰⴱⵓ ⴰⵍⴰⵎⵉ ⵉⴳⴻⵄⵄⴻⴷ ⵙⴻⵏⵏⴻⵊ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","ⴳⴻⵄⵄⴷⴻⵏ ⵡⴰⵎⴰⵏ ⵓⵛⴰ ⵎⵎⴰⵔⴻⵏⵢⴻⵏ-ⴷⴷ ⴰⵟⵟⴰⵙ ⵙⴻⵏⵏⴻⵊ ⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵓⵛⴰ ⵢⵓⵢⵓⵔ ⵓⵖⴰⵔⵔⴰⴱⵓ ⵅ ⵡⵓⴷⴻⵎ ⵏ ⵡⴰⵎⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","ⴳⴻⵄⵄⴷⴻⵏ ⴰⵎⴰⵏ ⴰⵟⵟⴰⵙ ⵙ ⵡⴰⵟⵟⴰⵙ, ⴰⵍⴰⵎⵉ ⵎⴰⵔⵔⴰ ⵉⴷⵓⵔⴰⵔ ⵢⵓⵄⵍⴰⵏ ⵉ ⴷⵉⵏ ⵉⴵⴰⵏ ⵙⴰⴷⵓ ⵎⴰⵔⵔⴰ ⴰⵊⴻⵏⵏⴰ, ⴷⴻⵡⵍⴻⵏ ⴷⵍⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","ⵓⵍⵢⴻⵏ ⵡⴰⵎⴰⵏ ⵅⴻⵎⵎⴻⵙⵟⴰⵛ ⵏ ⵉⵖⴰⴵⴻⵏ ⵙⴻⵏⵏⴻⵊ ⵉ ⵉⴷⵓⵔⴰⵔ ⵓⵛⴰ ⴷⵍⵉⵏ ⵉⴷⵓⵔⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","ⵎⴰⵔⵔⴰ ⵉⵎⴻⴷⴷⴰⵔⴻⵏ ⵙ ⴰⵔⵔⵉⵎⴻⵜ ⵏ ⵡⴻⵢⵙⵓⵎ ⵉ ⵉⵜⵜⴻⵏⵀⴻⵣⵣⴰⵏ ⵅ ⵜⴻⵎⵎⵓⵔⵜ ⵉⴹⵍⴻⵇ ⵉ ⴱⵓⵃⴱⴻⵍ ⵏⵏⴻⵙ, ⵉⵊⴹⴰⴹ ⴷ ⵍⴻⴱⵀⴰⵢⴻⵎ, ⵍⵎⴰⵍ ⵏ ⵍⴻⵅⵍⴰ, ⵎⴰⵔⵔⴰ ⵉⵎⵓⴷⴷⴰⵔⴻⵏ ⵉⵜⵜⴱⵓⵄⴻⵏ, ⵉⵏⵏⵉ ⵉⵜⵜⴱⵓⵄⴻⵏ ⵅ ⵡⵓⴷⴻⵎ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵓⵍⴰ ⴷ ⵎⴰⵔⵔⴰ ⵉⵡⴷⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴷⵉ ⵉⴵⴰ ⵍⴻⵄⵡⵉⵏ ⵏ ⴰⵔⵔⵓⵃ ⵏ ⵜⵓⴷⴰⵔⵜ ⵖⴰⵔⵙⴻⵏ ⴷⴻⴳ ⵡⴻⵏⵣⴰⵔⴻⵏ ⵏⵙⴻⵏ ⵣⵉ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴷⵉⵏ ⵉⴵⴰⵏ ⵅ ⵍⴱⴰⵔⵔ, ⵉⵎⵎⵓⵜ. ");
INSERT INTO rift_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","ⵓⵛⴰ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴷⵉⵏ ⵉⴵⴰⵏ ⵅ ⵡⵓⴷⴻⵎ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵉⵜⵜⵡⴰⵎⵃⴰ, ⵣⵉ ⴱⵏⴰⴷⴻⵎ ⴰⵍ ⵍⵎⴰⵍ ⴷ ⵉⵎⵓⴷⴷⴰⵔⴻⵏ ⵉⵏⵏⵉ ⵉⵜⵜⴱⵓⵄⴻⵏ ⴷ ⵉⵊⴹⴰⴹ ⵏ ⵓⵊⴻⵏⵏⴰ. ⵉⵏⴰ ⵜⵜⵡⴰⵜⴻⵃⵃⴰⵏ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ. ⵏⵓⵃ ⵡⴻⵃⵃⴷⴻⵙ ⵉ ⵉⵇⵇⵉⵎⴻⵏ ⴷ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴽⵉⴷⴻⵙ ⵉ ⵉⴵⴰⵏ ⴷⴻⴳ ⵓⵖⴰⵔⵔⴰⴱⵓ. ");
INSERT INTO rift_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","ⴳⴻⵄⵄⴷⴻⵏ ⵡⴰⵎⴰⵏ ⵅ ⵜⴻⵎⵎⵓⵔⵜ ⵎⵢⴰ ⵓ-ⵅⴻⵎⵙⵉⵏ ⵏ ⵡⵓⵙⵙⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","ⵓⵛⴰ ⵉⵅⴰⵔⵔⴻⵚ ⴰⵔⴻⴱⴱⵉ ⴷⵉ ⵏⵓⵃ ⵓ ⴷⵉ ⵎⴰⵔⵔⴰ ⵍⵎⴰⵍ ⵏ ⵍⴻⵅⵍⴰ ⴷ ⵎⴰⵔⵔⴰ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵉ ⵜⵓⵖⴰ ⴰⴽⵉⴷⴻⵙ ⴷⴻⴳ ⵓⵖⴰⵔⵔⴰⴱⵓ. ⵉⴳⴳⴰ ⴰⵔⴻⴱⴱⵉ ⴰⴷ ⵢⴻⴽⴽ ⵉⵊⵊ ⵏ ⵓⵙⴻⵎⵎⵉⴹ ⵅ ⵜⴻⵎⵎⵓⵔⵜ ⴰⵍⴰⵎⵉ ⴰⵔⵙⴰⵏ ⵡⴰⵎⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","ⴱⴻⵍⵍⵄⴻⵏⵜ ⵍⵄⵓⵏⵚⴰⵔⴰⵜ ⵏ ⵡⴰⵎⴰⵏ ⵉⵀⴻⵡⵍⴻⵏ ⴷ ⵜⴱⵓⵔⵊⴰⵜⵉⵏ ⵏ ⵓⵊⴻⵏⵏⴰ ⵓⵛⴰ ⵉⴱⴻⴷⴷ ⵡⴻⵏⵥⴰⵔ ⵣⴻⴳ ⵓⵊⴻⵏⵏⴰ. ");
INSERT INTO rift_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","ⵓⵛⴰ, ⴰⵎ ⴷⴷ-ⵜⵜⴰⵙⴻⵏ ⵜⵜⵔⴰⵃⴻⵏ, ⴷⴻⵡⵍⴻⵏ-ⴷⴷ ⵡⴰⵎⴰⵏ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ. ⴰⵡⴰⵔⵏⵉ ⵎⵢⴰ ⵓ-ⵅⴻⵎⵙⵉⵏ ⵏ ⵡⵓⵙⵙⴰⵏ ⵏⴻⵇⵚⴻⵏ ⵡⴰⵎⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","ⴷⴻⴳ ⵓⵢⵓⵔ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ, ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴱⴻⵄⵟⴰⵛ ⵏ ⵓⵢⵓⵔ ⵏⵏⵉ, ⵢⴰⵔⵙⴰ ⵓⵖⴰⵔⵔⴰⴱⵓ ⵅ ⵉⴷⵓⵔⴰⵔ ⵏ ⴰⵔⴰⵔⴰⵜ. ");
INSERT INTO rift_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","ⵇⵇⵉⵎⴻⵏ ⵡⴰⵎⴰⵏ ⵏⴻⵇⵇⵚⴻⵏ ⴰⵍ ⴰⵢⵓⵔ ⵡⵉⵙⵙ ⵄⴻⵛⵔⴰ. ⴷⴻⴳ ⵓⵢⵓⵔ ⵡⵉⵙⵙ ⵄⴻⵛⵔⴰ, ⴷⴻⴳ ⵡⴰⵙⵙ ⴰⵎⴻⵣⵡⴰⵔⵓ ⵏ ⵓⵢⵓⵔ, ⴹⵀⴰⵔⴻⵏⵜ-ⵉ-ⴷⴷ ⵜⵇⵉⵛⵛⴰⵜⵉⵏ ⵏ ⵉⴷⵓⵔⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⵄⴷⵓⵏ ⴰⵔⴻⴱⵄⵉⵏ ⵏ ⵡⵓⵙⵙⴰⵏ, ⵢⴰⵔⵣⴻⵎ ⵏⵓⵃ ⵜⴰⴱⵓⵔⵊⴻⵜ ⵏ ⵓⵖⴰⵔⵔⴰⴱⵓ ⵏⵏⵉ ⴷⴰⵢⴻⵙ ⵜⵓⵖⴰ ⵉⴳⴳⴰ, ");
INSERT INTO rift_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ⵓⵛⴰ ⵉⵙⵙⴻⴽⴽ ⴰⴱⴰⵖⴻⵍ. ⵡⴰⵏⵉⵜⴰ ⵉⴼⴼⴻⵖ, ⵉⵇⵇⵉⵎ ⵉⵜⵜⵔⴰⵃ ⵉⵜⵜⴰⵙ-ⴷⴷ ⴰⵍⴰⵎⵉ ⴱⴷⴰⵏ ⵡⴰⵎⴰⵏ ⵜⵜⴰⵥⵖⴻⵏ ⵅ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","ⵅⴻⵏⵏⵉ ⵉⵙⵙⴻⴽⴽ ⵙⵙⴻⵏⵏⵉ ⵜⴰⴷⴱⵉⵔⵜ, ⵃⵉⵎⴰ ⴰⴷ ⵉⵥⴰⵔ, ⵎⴰ ⴰⵎⴰⵏ ⵏⴻⵇⵚⴻⵏ ⵅ ⵡⵓⴷⴻⵎ ⵏ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","ⵎⴰⵛⴰ ⵡⴰⵔ ⵜⵓⴼⵉ ⵜⴻⴷⴱⵉⵔⵜ ⵎⴰⵏⵉ ⵖⴰ ⵜⴻⵙⵙⴰⵔⵙ ⵜⴰⵍⴻⵇⵇⴰ ⵏ ⵓⴹⴰⵔ ⵏⵏⴻⵙ ⵓⵛⴰ ⵜⴻⵄⵇⴻⴱ-ⴷⴷ ⵖⴰⵔⴻⵙ ⵖⴰⵔ ⵓⵖⴰⵔⵔⴰⴱⵓ, ⵎⵉⵏⵣⵉ ⴰⵎⴰⵏ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⵄⴰⴷ ⵅ ⵡⵓⴷⴻⵎ ⵏ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ. ⵉⵙⵙⵡⵉⵥⵥⴻⴹ ⴰⴼⵓⵙ ⵏⵏⴻⵙ, ⵉⵟⵟⴻⴼ ⵉ-ⵜⵜ ⵓⵛⴰ ⵉⵙⵙⵉⴷⴻⴼ ⵉ-ⵜⵜ-ⵉ-ⴷⴷ ⵖⴰⵔⴻⵙ ⴷⴻⴳ ⵓⵖⴰⵔⵔⴰⴱⵓ. ");
INSERT INTO rift_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","ⵉⵔⴰⵊⴰ ⵄⴰⴷ ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⵏⵏⴻⵖⵏⵉ, ⵅⴻⵏⵏⵉ ⵉⵙⵙⴻⴽⴽ ⵜⴰⴷⴱⵉⵔⵜ ⵄⴰⵡⴻⴷ ⵣⴻⴳ ⵓⵖⴰⵔⵔⴰⴱⵓ. ");
INSERT INTO rift_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","ⵓⵛⴰ ⵜⴰⴷⴱⵉⵔⵜ ⵜⴻⵄⵇⴻⴱ-ⴷⴷ ⵖⴰⵔⴻⵙ ⵖⴰⵔ ⵜⵎⴻⴷⴷⵉⵜ, ⵓ ⵅⵣⴰⵔ, ⴰⵇⴰ ⴰⴼⴰⵔ ⵏ ⵣⵣⵉⵜⵓⵏ ⴷⴻⴳ ⵓⵇⴻⵎⵎⵓⵎ ⵏⵏⴻⵙ. ⵅⴻⵏⵏⵉ ⵉⴼⵀⴻⵎ ⵏⵓⵃ ⴱⴻⵍⵍⵉ ⴰⵎⴰⵏ ⵏⴻⵇⵚⴻⵏ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","ⵉⵔⴰⵊⴰ ⵄⴰⴷ ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ, ⵅⴻⵏⵏⵉ ⵉⵙⵙⴻⴽⴽ ⵜⴰⴷⴱⵉⵔⵜ ⵄⴰⵡⴻⴷ ⵓⵛⴰ ⵏⴻⵜⵜⴰⵜ ⵡⴰⵔ ⵖⴰⵔⴻⵙ ⴷⴷ-ⵜⴻⵄⵇⵉⴱ ⵄⴰⴷ. ");
INSERT INTO rift_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","ⴷⴻⴳ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵡⵉⵙⵙ ⵙⴻⵜⵜⴰ-ⵎⵢⴰ ⵓ-ⵡⴰⵃⵉⵜ ⵏ ⵏⵓⵃ, ⴷⴻⴳ ⵓⵢⵓⵔ ⴰⵎⴻⵣⵡⴰⵔⵓ, ⴷⴻⴳ ⵡⴰⵙⵙ ⴰⵎⴻⵣⵡⴰⵔⵓ ⵏ ⵓⵢⵓⵔ ⵏⵏⵉ, ⵓⵥⵖⴻⵏ ⵡⴰⵎⴰⵏ ⵅ ⵜⴻⵎⵎⵓⵔⵜ. ⵉⴽⵙⵉ ⵏⵓⵃ ⵜⴰⵡⵡⴰⵔⵜ ⵏ ⵓⵙⴻⵇⵇⴰⴼ ⵏ ⵓⵖⴰⵔⵔⴰⴱⵓ, ⵉⵅⵣⴰⵔ ⵖⴰⵔ ⴱⴰⵔⵔⴰ, ⵓⵛⴰ ⵅⵣⴰⵔ, ⵓⴷⴻⵎ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⴰⵇⴰ ⵢⵓⵥⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","ⴷⴻⴳ ⵓⵢⵓⵔ ⵡⵉⵙⵙ ⵜⵏⴰⵢⴻⵏ, ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ ⵓ-ⵄⵉⵛⵔⵉⵏ ⵏ ⵓⵢⵓⵔ ⵏⵏⵉ, ⵜⵓⵥⴻⵖ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","ⵅⴻⵏⵏⵉ ⵉⵙⵙⵉⵡⴻⵍ ⴰⵔⴻⴱⴱⵉ ⴰⴽ-ⴷ ⵏⵓⵃ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“ⴼⴼⴻⵖ ⵣⴻⴳ ⵓⵖⴰⵔⵔⴰⴱⵓ, ⵛⴻⴽ ⴷ ⵜⴻⵎⵖⴰⵔⵜ ⵏⵏⴻⵛ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵛ ⴷ ⵜⴻⵎⵖⴰⵔⵉⵏ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵛ ⴰⴽⵉⴷⴻⴽ. ");
INSERT INTO rift_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⴷⴷⴰⵔⴻⵏ ⵉ ⵉⴵⴰⵏ ⴰⴽⵉⴷⴻⴽ, ⵣⵉ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵖⴰⵔⵙⴻⵏ ⴰⵔⵔⵉⵎⴻⵜ ⵏ ⵡⴻⵢⵙⵓⵎ, ⵣⴻⴳ ⵉⵊⴹⴰⴹ, ⵣⵉ ⵍⵎⴰⵍ ⵓ ⵣⵉ ⵎⴰⵔⵔⴰ ⵉⵎⵓⴷⴷⴰⵔⴻⵏ ⵏⵏⵉ ⵉⵜⵜⴱⵓⵄⴻⵏ ⵅ ⵜⴻⵎⵎⵓⵔⵜ, ⴻⵊⵊ ⵉ-ⵜⴻⵏ ⴰⴷ ⴼⴼⵖⴻⵏ ⴰⴽⵉⴷⴻⴽ, ⴻⵊⵊ ⵉ-ⵜⴻⵏ ⴰⴷ ⵎⵟⴰⵔⵔⴰⵛⴻⵏ ⵅ ⵜⴻⵎⵎⵓⵔⵜ, ⴰⴷ ⴰⵔⵔⴻⵏ ⵍⵖⵉⴵⴻⵜ ⵓⵛⴰ ⴰⴷ ⵎⵎⴰⵔⴻⵏⵢⴻⵏ ⵅ ⵜⴻⵎⵎⵓⵔⵜ.” ");
INSERT INTO rift_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","ⵉⴼⴼⴻⵖ ⵏⵓⵃ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ ⴷ ⵜⴻⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ ⴷ ⵜⴻⵎⵖⴰⵔⵉⵏ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ ⴰⴽⵉⴷⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","ⵎⴰⵔⵔⴰ ⵍⵎⴰⵍ ⵏ ⵍⴻⵅⵍⴰ, ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⵜⵜⴱⵓⵄⴻⵏ, ⴷ ⵎⴰⵔⵔⴰ ⵉⵊⴹⴰⴹ, ⴷ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⵜⵜⴻⵏⵀⴻⵣⵣⴰⵏ ⵅ ⵜⴻⵎⵎⵓⵔⵜ ⴼⴼⵖⴻⵏ ⵣⴻⴳ ⵓⵖⴰⵔⵔⴰⴱⵓ ⵄⵍⴰⵃⵚⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","ⵉⴱⵏⴰ ⵏⵓⵃ ⵉⵊⵊ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ⵉ ⵙⵉⴷⵉ ⵓⵛⴰ ⵉⴽⵙⵉ ⵣⵉ ⵎⴰⵔⵔⴰ ⵍⵎⴰⵍ ⵏ ⵍⴻⵃⵍⴰⵍ ⵓ ⵣⵉ ⵎⴰⵔⵔⴰ ⵉⵊⴹⴰⴹ ⵏ ⵍⴻⵃⵍⴰⵍ ⵓⵛⴰ ⵉⵇⴻⴷⴷⴻⵎ ⵜⵉⵖⴰⵔⵚⴰ ⵏ ⵡⴻⵛⵎⴰⴹ ⵅ ⵓⵄⴰⵍⵟⴰⵔ.    ");
INSERT INTO rift_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","ⵓⵛⴰ ⵉⵛⴻⵎⵎ ⵙⵉⴷⵉ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵉⵜⵜⴼⵓⵃⴻⵏ ⵓⵛⴰ ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⴷⴻⴳ ⵡⵓⵍ ⵏⵏⴻⵙ: “ⵡⴰⵔ ⵜⵜⵄⵉⵇⵇⵉⴱⴻⵖ ⵄⴰⴷ ⴰⴷ ⵏⴻⵄⵍⴻⵖ ⵜⴰⵎⵎⵓⵔⵜ ⵅ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⴱⵏⴰⴷⴻⵎ, ⵎⵉⵏⵣⵉ ⵎⵉⵏ ⴷⴷ-ⵉⵜⵜⴻⴼⴼⵖⴻⵏ ⵣⴻⴳ ⵡⵓⵍ ⵏ ⴱⵏⴰⴷⴻⵎ ⴷ ⴰⵄⴻⴼⴼⴰⵏ ⵡⴰⵀⴰ ⵣⵉ ⵜⴻⵎⵥⵉ ⵏⵏⴻⵙ. ⵡⴰⵔ ⵜⵜⵄⵉⵇⵇⵉⴱⴻⵖ ⵄⴰⴷ ⴰⴷ ⵡⵜⴻⵖ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⴷⴷⴰⵔⴻⵏ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴳⴳⵉⵖ. ");
INSERT INTO rift_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","ⵎⴰⵔⵔⴰ ⵓⵙⵙⴰⵏ ⵉ ⵖⴰ ⵜⴻⵇⵇⵉⵎ ⵜⴻⵎⵎⵓⵔⵜ ⵜⴻⴵⴰ, ⴰⴷ ⵜⵉⵍⵉ ⵜⵢⴰⵔⵣⴰ ⴷ ⵜⵎⴻⵢⵔⴰ, ⵜⴻⵚⵎⴻⴹ ⴷ ⵍⴻⵃⵎⵓ, ⴰⵏⴻⴱⴷⵓ ⴷ ⵍⵎⴻⵛⵜⴰ ⵓⵛⴰ ⴰⵙⵙ ⴷ ⴵⵉⵍⴻⵜ ⵡⴰⵔ ⵜⵜⴱⴻⴷⴷⵉⵏ ⵄⴻⵎⵎⴰⵔⵚ.”    ");
INSERT INTO rift_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","ⵅⴻⵏⵏⵉ ⵉⴱⴰⵔⴻⴽ ⴰⵔⴻⴱⴱⵉ ⵏⵓⵃ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⵏⵏⴰ ⴰⵙⴻⵏ: “ⵊⵊⴻⵎ-ⴷⴷ ⵍⵖⵉⴵⴻⵜ, ⵎⴰⵔⴻⵏⵢⴻⵎ ⵓ ⵄⴻⵎⵎⴰⵔⴻⵎ ⵜⴰⵎⵎⵓⵔⵜ! ");
INSERT INTO rift_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","ⵜⵉⴳⴳⵯⵓⴷⵉ ⴷ ⵍⵄⵓⵔⵔⴻⵜ ⵣⵉ ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⵉⵍⵉⵏⵜ ⵅ ⵎⴰⵔⵔⴰ ⵍⵎⴰⵍ ⵏ ⵍⴻⵅⵍⴰ, ⵅ ⵎⴰⵔⵔⴰ ⵉⵊⴹⴰⴹ ⵏ ⵓⵊⴻⵏⵏⴰ ⵓ ⵅ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⵜⵜⴱⵓⵄⴻⵏ ⵅ ⵜⴻⵎⵎⵓⵔⵜ ⵓ ⵅ ⵎⴰⵔⵔⴰ ⵉⵙⴻⵍⵎⴰⵏ ⴷⵉ ⵍⴻⴱⵃⴰⵔ: ⴰⵇⴰ ⵎⵎⴻⵡⵛⴻⵏ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⵜⵜⴱⵓⵄⴻⵏ, ⵎⵉⵏ ⵉⴷⴷⴰⵔⴻⵏ, ⴰⴷ ⴰⵡⴻⵎ ⵢⵉⵍⵉ ⴷ ⵎⴰⵛⵛⴰ. ⵏⴻⵛⵛ ⴰⴷ ⴰⵡⴻⵎ ⵜ ⵡⵛⴻⵖ ⵎⴰⵔⵔⴰ, ⴰⵎ ⴷ ⴰⵡⴻⵎ ⵡⵛⵉⵖ ⴰⴼⵙⵓ ⴰⵣⵉⵣⴰ, ");
INSERT INTO rift_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","ⵎⴰⵛⴰ ⴰⵢⵙⵓⵎ ⴰⴽ-ⴷ ⴱⵓⵃⴱⴻⵍ ⵏⵏⴻⵙ ⵉ ⵉⴵⴰⵏ ⴷ ⵉⴷⴰⵎⵎⴻⵏ ⵏⵏⴻⵙ, ⵡⴰⵔ ⵜⴻⵏ ⵜⵜᵉⵜⵜⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","ⴷ ⵜⵉⴷⴻⵜⵜ ⴰⴷ ⵜⵜⴰⵔⴻⵖ ⵉⴷⴰⵎⵎⴻⵏ ⵏⵡⴻⵎ ⵏ ⵍⴻⵄⵎⵓⵔ ⵏⵡⴻⵎ, ⴰⴷ ⵜⴻⵏ ⵜⵜⴰⵔⴻⵖ ⵣⴻⴳ ⵉⴼⴰⵙⵙⴻⵏ ⵏ ⵎⴰⵔⵔⴰ ⵉⵎⵓⴷⴷⴰⵔⴻⵏ, ⵓⵍⴰ ⵣⴻⴳ ⵉⴼⴰⵙⵙⴻⵏ ⵏ ⴱⵏⴰⴷⴻⵎ, ⵓ ⵣⴻⴳ ⵉⴼⴰⵙⵙⴻⵏ ⵏ ⵓⵎⴰⵙ ⵏ ⴽⵓⵍ ⵉⵊⵊⴻⵏ ⴰⴷ ⵜⵜⴰⵔⴻⵖ ⵍⴻⵄⵎⴰⵔ ⵏ ⴱⵏⴰⴷⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","ⵡⵉ ⵖⴰ ⵉⵙⵙⵉⵣⵣⵍⴻⵏ ⵉⴷⴰⵎⵎⴻⵏ ⵏ ⴱⵏⴰⴷⴻⵎ, ⵉⴷⴰⵎⵎⴻⵏ ⵏⵏⴻⵙ ⴰⴷ ⵜⴻⵏ ⵙⵙⵉⵣⵣⵍⴻⵏ ⵙ ⵓⴼⵓⵙ ⵏ ⴱⵏⴰⴷⴻⵎ, ⵎⵉⵏⵣⵉ ⴰⵔⴻⴱⴱⵉ ⵉⴳⴳⴰ ⴱⵏⴰⴷⴻⵎ ⴷⵉ ⵚⵚⵉⴼⴻⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","ⵓ ⴽⴻⵏⵏⵉⵡ, ⵊⵊⴻⵎ-ⴷⴷ ⵍⵖⵉⴵⴻⵜ, ⴷⴻⵡⵍⴻⵎ ⴷⴻⴳ ⵡⴰⵟⵟⴰⵙ, ⵎⵟⴰⵔⵔⵛⴻⵎ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵓⵛⴰ ⴷⴻⵡⵍⴻⵎ ⴷⴻⴳ ⵡⴰⵟⵟⴰⵙ ⵅⴰⵙ.” ");
INSERT INTO rift_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","ⵓⵛⴰ ⵉⵙⵙⵉⵡⴻⵍ ⴰⵔⴻⴱⴱⵉ ⴰⴽ-ⴷ ⵏⵓⵃ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ ⵏⵏⵉ ⵖⴰⵔⴻⵙ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“ⵏⴻⵛⵛ, ⵅⵣⴰⵔ, ⵏⴻⵛⵛ ⵜⵜⴻⴳⴳⴻⵖ ⵍⵄⴰⵀⴷ ⵉⵏⵓ ⴰⴽⵉⴷⵡⴻⵎ ⵓ ⴰⴽ-ⴷ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵡⴻⵎ ⴰⵡⴰⵔⵏⵉ ⴰⵡⴻⵎ, ");
INSERT INTO rift_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ⵓ ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⴱⵓⵃⴱⴻⵍ ⵉⴷⴷⴰⵔⴻⵏ ⵏⵏⵉ ⵉⴵⴰⵏ ⴰⴽⵉⴷⵡⴻⵎ, ⴰⴽ-ⴷ ⵉⵊⴹⴰⴹ, ⴰⴽ-ⴷ ⵍⵎⴰⵍ ⵓ ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⵍⵎⴰⵍ ⵏ ⵍⴻⵅⵍⴰ ⵅ ⵜⴻⵎⵎⵓⵔⵜ ⵉⵏⵏⵉ ⴰⴽⵉⴷⵡⴻⵎ, ⵡⴰⵀ, ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴷⴷ-ⵉⴼⴼⵖⴻⵏ ⵣⴻⴳ ⵓⵖⴰⵔⵔⴰⴱⵓ ⴰⵍ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⴷⴷⴰⵔⴻⵏ ⵅ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","ⴰⴷ ⴳⴳⴻⵖ ⵍⵄⴰⵀⴷ ⵉⵏⵓ ⴰⴽⵉⴷⵡⴻⵎ, ⴰⵇⴰ ⵎⴰⵔⵔⴰ ⵉⵎⴻⴷⴷⴰⵔⴻⵏ ⵙ ⴰⵔⵔⵉⵎⴻⵜ ⵏ ⵡⴻⵢⵙⵓⵎ ⵡⴰⵔ ⵜⵜⵡⴰⴽⴻⵙⵙⵉⵏ ⵄⴰⴷ ⵙ ⵡⴰⵎⴰⵏ ⵏ ⵙⵙⴻⵃⵍⴻⵜ, ⵓ ⵡⴰⵔ ⴷⵉⵏ ⵜᵉⵜⵜⵉⵍⵉ ⵄⴰⴷ ⵙⵙⴻⵃⵍⴻⵜ ⵉ ⵖⴰ ⵢⴰⵔⴻⴷⴷⴵⴻⵏ ⵜⴰⵎⵎⵓⵔⵜ.” ");
INSERT INTO rift_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⴰⵔⴻⴱⴱⵉ: “ⴷ ⵜⴰ ⴰⴷ ⵜⵉⵍⵉ ⴷ ⵍⴻⵄⵍⴰⵎⴻⵜ ⵏ ⵍⵄⴰⵀⴷ ⵜⴻⵏⵏⵉ ⵉ ⵖⴰ ⴳⴳⴻⵖ ⵊⴰⵔ ⴰⵢⵉ ⴷ ⴽⴻⵏⵏⵉⵡ ⴷ ⵎⴰⵔⵔⴰ ⵍⴻⵄⵎⴰⵔ ⵉⴷⴷⴰⵔⴻⵏ ⴰⴽⵉⴷⵡⴻⵎ, ⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵉ ⵍⴻⴱⴷⴰ: ");
INSERT INTO rift_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","ⴰⴷ ⴳⴳⴻⵖ ⵍⵇⴻⵡⵙ ⵉⵏⵓ ⴷⴻⴳ ⵉⵙⴻⵢⵏⵓⵜⴻⵏ ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵢⵉⵍⵉⵏ ⴷ ⵍⴻⵄⵍⴰⵎⴻⵜ ⵏ ⵍⵄⴰⵀⴷ ⵊⴰⵔ ⴰⵢⵉ ⴷ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","ⵅⵎⵉ ⵖⴰ ⴱⴹⵉⵖ ⵉⵙⴻⵢⵏⵓⵜⴻⵏ ⵅ ⵜⴻⵎⵎⵓⵔⵜ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⵎⵙⴰⵔ ⴱⴻⵍⵍⵉ ⵍⵇⴻⵡⵙ-ⴰ ⴰⴷ ⴷⴷ-ⵉⴹⵀⴰⵔ ⴷⴻⴳ ⵉⵙⴻⵢⵏⵓⵜⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⴷⴰⵔⴻⵖ ⵍⵄⴰⵀⴷ ⵉⵏⵓ ⵊⴰⵔ ⴰⵢⵉ ⴷ ⴽⴻⵏⵏⵉⵡ ⴷ ⵎⴰⵔⵔⴰ ⵍⴻⵄⵎⴰⵔ ⵉⴷⴷⴰⵔⴻⵏ ⵏ ⵎⴰⵔⵔⴰ ⵉⵎⴻⴷⴷⴰⵔⴻⵏ ⵙ ⴰⵔⵔⵉⵎⴻⵜ ⵏ ⵡⴻⵢⵙⵓⵎ. ⵡⴰⵔ ⴷⴷ-ⴷⴷⵉⴽⴽⵯⵉⵍⴻⵏ ⵡⴰⵎⴰⵏ ⴷ ⵙⵙⴻⵃⵍⴻⵜ ⵄⴰⵡⴻⴷ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵙⵙⵖⴰⵔⵇⴻⵏ ⵎⴰⵔⵔⴰ ⵉⵎⴻⴷⴷⴰⵔⴻⵏ ⵙ ⴰⵔⵔⵉⵎⴻⵜ ⵏ ⵡⴻⵢⵙⵓⵎ. ");
INSERT INTO rift_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","ⴰⴷ ⴷⴷ-ⵉⴹⵀⴰⵔ ⵍⵇⴻⵡⵙ ⴷⴻⴳ ⵉⵙⴻⵢⵏⵓⵜⴻⵏ, ⵓⵛⴰ ⵏⴻⵛⵛ ⴰⴷ ⵜ ⵥⴰⵔⴻⵖ ⵃⵉⵎⴰ ⴰⴷ ⵉⴷⴰⵔⴻⵖ ⵍⵄⴰⵀⴷ ⵉ ⵍⴻⴱⴷⴰ ⵊⴰⵔ ⴰⵔⴻⴱⴱⵉ ⴷ ⵎⴰⵔⵔⴰ ⵍⴻⵄⵎⴰⵔ ⵉⴷⴷⴰⵔⴻⵏ ⴷⵉ ⵎⴰⵔⵔⴰ ⵉⵎⴻⴷⴷⴰⵔⴻⵏ ⵙ ⴰⵔⵔⵉⵎⴻⵜ ⵏ ⵡⴻⵢⵙⵓⵎ ⵉ ⵉⴵⴰⵏ ⵅ ⵜⴻⵎⵎⵓⵔⵜ.” ");
INSERT INTO rift_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","ⵓⵛⴰ ⵉⵏⵏⴰ ⴰⵔⴻⴱⴱⵉ ⵉ ⵏⵓⵃ: “ⴷ ⵜⴰ ⴷ ⵍⴻⵄⵍⴰⵎⴻⵜ ⵏ ⵍⵄⴰⵀⴷ ⵉⵏⵓ ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⴳⴳⴻⵖ ⵊⴰⵔ ⴰⵢⵉ ⴷ ⵎⴰⵔⵔⴰ ⵉⵎⴻⴷⴷⴰⵔⴻⵏ ⵙ ⴰⵔⵔⵉⵎⴻⵜ ⵏ ⵡⴻⵢⵙⵓⵎ ⵉ ⵉⴵⴰⵏ ⵅ ⵜⴻⵎⵎⵓⵔⵜ.” ");
INSERT INTO rift_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","ⵜⴰⵔⵡⴰ ⵏ ⵏⵓⵃ ⵉⵏⵏⵉ ⴷⴷ-ⵉⴼⴼⵖⴻⵏ ⵣⴻⴳ ⵓⵖⴰⵔⵔⴰⴱⵓ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵛⴰⵎ ⴷ ⵃⴰⵎ ⴷ ⵢⴰⴼⴰⵜ. ⵃⴰⵎ ⵜⵓⵖⴰ ⴷ ⴱⴰⴱⴰⵙ ⵏ ⴽⴻⵏⵄⴰⵏ.    ");
INSERT INTO rift_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","ⵉⵏⴰ ⴷ ⵜⵍⴰⵜⴰ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵏⵓⵃ. ⵣⵣⴰⵢⵙⴻⵏ ⵜⵜⵡⴰⴱⴻⵣⵣⵄⴻⵏ ⵉⵡⴷⴰⵏ ⴷⵉ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","ⵉⴱⴷⴰ ⵏⵓⵃ ⵉⵅⴻⴷⴷⴻⵎ ⴰⵎ ⵓⴼⴻⴵⴰⵃ, ⵉⵥⵥⵓ ⵜⵉⵣⴰⵢⴰⵔⵉⵏ ⴷⴻⴳ ⵓⵎⴰⵔⵊⴻⵄ ⵏ ⵓⴹⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","ⵓⵎⵉ ⵉⵙⵡⴰ ⴱⵉⵏⵓ, ⵉⵙⵛⴰⵔ ⵓⵛⴰ ⵉⵄⴰⵔⵔⴰ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","ⵉⵥⵔⴰ ⵃⴰⵎ, ⴱⴰⴱⴰⵙ ⵏ ⴽⴻⵏⵄⴰⵏ, ⵜⵓⵄⵄⴰⵔⵢⴻⵏⵜ ⵏ ⴱⴰⴱⴰⵙ ⵓⵛⴰ ⵉⵏⵏⴰ ⵜ ⵉ ⵜⵏⴰⵢⴻⵏ ⵏ ⴰⵢⵜⵎⴰⵙ ⴷⵉ ⴱⴰⵔⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","ⴽⵙⵉⵏ ⵛⴰⵎ ⴷ ⵢⴰⴼⴰⵜ ⵛⴰ ⵏ ⵡⴻⵔⵔⵓⴹ, ⵙⵙⴰⵔⵙⴻⵏ ⵜ ⵅ ⵜⵖⴰⵔⴹⵉⵏ ⵏ ⵜⵏⴰⵢⴻⵏ ⵉⴷⵙⴻⵏ ⵏⵙⴻⵏ ⵓⵛⴰ ⵓⵢⵓⵔⴻⵏ ⵖⴰⵔ ⴹⴻⴼⴼⴰⵔ, ⴷⵍⵉⵏ ⵜⵓⵄⵄⴰⵔⵢⴻⵏⵜ ⵏ ⴱⴰⴱⴰⵜⵙⴻⵏ. ⴰⵔⵔⵉⵏ ⴰⵖⴻⵎⴱⵓⴱ ⵏⵙⴻⵏ ⵖⴰⵔ ⴹⴻⴼⴼⴰⵔ, ⵡⴰⵔ ⵥⵔⵉⵏ ⵛⴰ ⵜⵓⵄⵄⴰⵔⵢⴻⵏⵜ ⵏ ⴱⴰⴱⴰⵜⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","ⵉⴼⴰⵇ-ⴷⴷ ⵏⵓⵃ ⵣⵉ ⵙⵙⴻⴽⵔⴰ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⴷⵡⴻⵍ ⵢⴰⵔⴳⴻⴱ ⵅ ⵎⵉⵏ ⴷ ⴰⵙ ⵉⴳⴳⴰ ⵎⵎⵉⵙ ⴰⵎⴰⵥⵓⵥ. ");
INSERT INTO rift_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","ⵉⵏⵏⴰ: “ⴷ ⴰⵎⴻⵏⵄⵓⵍ ⵉ ⵢⴻⴵⴰ ⴽⴻⵏⵄⴰⵏ! ⴰⴷ ⵢⵉⵍⵉ ⴷ ⴰⵎⵙⴻⵅⵅⴰⵔ ⵇⴰⵄ ⵏ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵉ ⴰⵢⵜⵎⴰⵙ!” ");
INSERT INTO rift_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","ⵓⵛⴰ ⵉⵏⵏⴰ: “ⴰⴷ ⵉⵜⵜⵡⴰⴱⴰⵔⴻⴽ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏ ⵛⴰⵎ. ⴽⴻⵏⵄⴰⵏ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⴰⵎⵙⴻⵅⵅⴰⵔ ⵉ ⵏⵉⵜⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","ⵣⴻⵄⵎⴰ ⴰⴷ ⵉⵡⴻⵙⵙⴻⵄ ⴰⵔⴻⴱⴱⵉ ⵜⴰⵣⴻⴷⴷⵉⵖⵜ ⵉ ⵢⴰⴼⴰⵜ, ⴰⴷ ⵉⵣⴷⴻⵖ ⴷⴻⴳ ⵉⵇⵉⴹⴰⵏ ⵏ ⵛⴰⵎ, ⵓ ⴽⴻⵏⵄⴰⵏ ⴰⴷ ⴰⵙⴻⵏ ⵢⵉⵍⵉ ⴷ ⴰⵎⵙⴻⵅⵅⴰⵔ.” ");
INSERT INTO rift_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","ⴰⵡⴰⵔⵏⵉ ⵙⵙⴻⵃⵍⴻⵜ ⵉⴷⴷⴰⵔ ⵏⵓⵃ ⵄⴰⴷ ⵜⴻⵍⵜ-ⵎⵢⴰ ⵓ-ⵅⴻⵎⵙⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","ⴰⵎⵎⵓ ⵉ ⵉⴷⴷⴰⵔ ⵏⵓⵃ ⵜⴻⵙⵄⴰ-ⵎⵢⴰ ⵓ-ⵅⴻⵎⵙⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵅⴻⵏⵏⵉ ⵉⵎⵎⵓⵜ. ⵉⵏⴰ ⴷ ⵉⵎⴻⵣⵔⵓⵢⴻⵏ ⵏ ⵢⵉⵏⵏⵉ ⴷⴷ-ⵉⵜⵜⵡⴰⵅⴻⵍⵇⴻⵏ ⵣⴻⴳ ⴰⵢⵜ ⵏ ⵏⵓⵃ: ⵛⴰⵎ, ⵃⴰⵎ ⴷ ⵢⴰⴼⴰⵜ. ");
INSERT INTO rift_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","ⵜⵜⵡⴰⵔⵡⴻⵏ ⴰⵙⴻⵏ-ⴷⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⴰⵡⴰⵔⵏⵉ ⵉ ⵙⵙⴻⵃⵍⴻⵜ.   * ");
INSERT INTO rift_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","ⴰⵢⵜ ⵏ ⵢⴰⴼⴰⵜ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵊⵓⵎⴰⵔ, ⵎⴰⵊⵓⵊ, ⵎⴰⴷⴰⵢ, ⵢⴰⵡⴰⵏ, ⵜⵓⴱⴰⵍ, ⵎⴰⵛⵉⴽ ⴷ ⵜⵉⵔⴰⵙ.    ");
INSERT INTO rift_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵊⵓⵎⴰⵔ, ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⴰⵛⴽⴰⵏⴰⵣ, ⵔⵉⴼⴰⵜ ⴷ ⵜⵓⵊⴰⵔⵎⴰ. ");
INSERT INTO rift_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵢⴰⵡⴰⵏ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵍⵉⵛⴰ, ⵜⴰⵔⵛⵉⵛ ⴷ ⵉⴽⵉⵜⵜⵉⵢⵢⴻⵏ ⴷ ⵉⴷⵓⴷⴰⵏⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","ⵣⵣⴰⵢⵙⴻⵏ ⵉ ⵜⵜⵡⴰⴱⴹⴰⵏⵜ ⵜⴻⴳⵣⵉⵔⵉⵏ ⵏ ⵍⴻⴳⵏⵓⵙ ⴷⵉ ⵜⴻⵎⵎⵓⵔⴰ ⵏⵙⴻⵏ, ⴽⵓⵍ ⵉⵊⵊⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵉⵍⴻⵙ ⵏⵏⴻⵙ ⵓⵛⴰ ⵎⴰⵔⵔⴰ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵ ⵏⵙⴻⵏ ⵓ ⴷⵉ ⵍⴻⴳⵏⵓⵙ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","ⴰⵢⵜ ⵏ ⵃⴰⵎ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⴽⵓⵛ, ⵎⵉⵚⵔⴰⵢⵉⵎ, ⴼⵓⵟ ⴷ ⴽⴻⵏⵄⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⴽⵓⵛ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵙⴻⴱⴰ, ⵃⴰⵡⵉⵍⴰ, ⵙⴰⴱⵜⴰ, ⵔⴰⵄⴰⵎⴰ ⴷ ⵙⴰⴱⵜⴰⴽⴰ. ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵔⴰⵄⴰⵎⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵛⴰⴱⴰ ⴷ ⴷⴰⴷⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","ⴽⵓⵛ ⵉⵊⵊⴰ-ⴷⴷ ⵏⵉⵎⵔⵓⴷ. ⵡⴰⵏⵉⵜⴰ ⵉⴱⴷⴰ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵊⵊⵉⵀⴻⵍ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","ⵡⴰ ⵜⵓⵖⴰ ⴷ ⴰⵏⴻⴳⵎⴰⵔ ⴷ ⴰⵎⴻⵇⵇⵔⴰⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ⵅ ⵓⵢⴰ ⵇⵇⴰⵔⴻⵏ: ‘ⴰⵏⴻⴳⵎⴰⵔ ⴰⵎⴻⵇⵇⵔⴰⵏ ⴰⵎ ⵏⵉⵎⵔⵓⴷ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ.’ ");
INSERT INTO rift_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","ⴰⵎⴻⵣⵡⴰⵔ ⵏ ⵜⴳⴻⵍⴷⵉⵜ ⵏⵏⴻⵙ ⵜⵓⵖⴰ ⴰⵜⴻⵏⵜ ⴷ ⵜⵉⵏⴻⴷⴷⴰⵎ ⵏ ⴱⴰⴱⵉⵍ ⴷ ⵉⵔⵉⵅ ⴷ ⴰⴽⴽⴰⴷ ⴷ ⴽⴰⵍⵏⴰ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵛⵉⵏⵄⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⵉ ⴷⴷ-ⵉⴼⴼⴻⵖ ⵖⴰⵔ ⴰⵛⵛⵓⵔ ⵓⵛⴰ ⵉⴱⵏⴰ ⴷⵉⵏ ⵏⵉⵏⵡⴰ, ⵔⵉⵃⵓⴱⵓⵜ-ⵄⵉⵔ ⴷ ⴽⴰⵍⴰⵃ ");
INSERT INTO rift_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ⴷ ⵔⵉⵙⵉⵏ ⵊⴰⵔ ⵏⵉⵏⵡⴰ ⴷ ⴽⴰⵍⴰⵃ, ⵏⴻⵜⵜⴰⵜ ⴷ ⵜⴰⵏⴷⵉⵏⵜ ⵜⴰⵎⴻⵇⵇⵔⴰⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","ⵎⵉⵚⵔⴰⵢⵉⵎ ⵉⵊⵊⴰ-ⴷⴷ ⵉⵍⵓⴷⵉⵢⵢⴻⵏ, ⵉⵄⴰⵏⴰⵎⵉⵢⵢⴻⵏ, ⵉⵍⴰⵀⴰⴱⵉⵢⵢⴻⵏ, ⵉⵏⴰⴼⵜⵓⵃⵉⵢⵢⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ⵉⴼⴰⵜⵔⵓⵙⵉⵢⵢⴻⵏ, ⵉⴽⴰⵙⵍⵓⵃⵉⵢⵢⴻⵏ, ⵉⵏⵏⵉ ⵣⵉ ⴷⴷ-ⵉⵇⵇⴰⵔⵚⴻⵏ ⵉⴼⵉⵍⵉⵙⵟⵉⵏⵉⵢⵢⴻⵏ, ⵓⵍⴰ ⴷ ⵉⴽⴰⴼⵜⵓⵔⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","ⴽⴻⵏⵄⴰⵏ ⵉⵊⵊⴰ-ⴷⴷ ⵚⵉⴷⵓⵏ, ⴰⵎⴻⵏⵣⵓ ⵏⵏⴻⵙ, ⴷ ⵃⵉⵜ ");
INSERT INTO rift_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","ⴷ ⵓⵢⴰⴱⵓⵙⵉ ⴷ ⵓⵎⵓⵔⵉ ⴷ ⵓⵊⵉⵔⵊⴰⵛⵉ ");
INSERT INTO rift_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ⴷ ⵓⵃⵉⵡⵉ ⴷ ⵓⵄⴰⵔⵇⵉ ⴷ ⵓⵙⵉⵏⵉ ");
INSERT INTO rift_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ⴷ ⵓⵔⵡⴰⴷⵉ ⴷ ⵓⵚⴰⵎⴰⵔⵉ ⴷ ⵓⵃⴰⵎⴰⵜⵉ. ⴰⵡⴰⵔⵏⵉ ⴰⵙ ⵎⴱⴻⵣⵣⵄⴻⵏⵜ ⵎⴰⵔⵔⴰ ⵍⴰⴵⴰⵜ ⵏ ⴽⴻⵏⵄⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","ⵜⵓⵖⴰ ⴰⵢⵎⵉⵔ ⵏ ⴰⵢⵜ ⵏ ⴽⴻⵏⵄⴰⵏ ⵣⵉ ⵚⵉⴷⵓⵏ ⵖⴰⵔ ⵅⵉⵔⴰⵔ ⴰⵍ ⵖⴰⵣⵣⴰ ⵓ ⵙⵙⴻⵏⵏⵉ ⵖⴰⵔ ⵙⴰⴷⵓⵎ ⴷ ⵄⴰⵎⵓⵔⵔⴰ ⴷ ⴰⴷⵎⴰ ⴷ ⵚⴰⴱⵓⵢⵉⵎ ⴰⵍ ⵍⴰⵛⴰⵄ. ");
INSERT INTO rift_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","ⵉⵏⴰ ⴷ ⴰⵢⵜ ⵏ ⵃⴰⵎ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵉⵍⵙⴰⵡⴻⵏ ⵏⵙⴻⵏ, ⴷⵉ ⵜⵉⵎⵎⵓⵔⴰ ⵏⵙⴻⵏ ⵓ ⴰⴽ-ⴷ ⵍⴻⴳⵏⵓⵙ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","ⵉ ⵛⴰⵎ, ⵡⴻⵏⵏⵉ ⴷ ⵊⴻⴷⴷ ⵏ ⵎⴰⵔⵔⴰ ⴰⵢⵜ ⵏ ⵄⴰⴱⵉⵔ, ⵓⵎⴰⵙ ⵏ ⵢⴰⴼⴰⵜ, ⴰⵎⴻⵇⵇⵔⴰⵏ, ⵜⵜⵡⴰⵔⵡⴻⵏ ⴰⵙ-ⴷⴷ ⵄⴰⵡⴻⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵛⴰⵎ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵄⵉⵍⴰⵎ, ⴰⵛⵛⵓⵔ, ⴰⵔⴼⴰⴽⵛⴰⴷ, ⵍⵓⴷ ⴷ ⴰⵔⴰⵎ. ");
INSERT INTO rift_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⴰⵔⴰⵎ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵄⵓⵚ ⴷ ⵃⵓⵍ ⴷ ⵊⴰⵜⵉⵔ ⴷ ⵎⴰⵛ. ");
INSERT INTO rift_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","ⴰⵔⴼⴰⴽⵛⴰⴷ ⵉⵊⵊⴰ-ⴷⴷ ⵛⴰⵍⴰⵃ ⵓ ⵛⴰⵍⴰⵃ ⵉⵊⵊⴰ-ⴷⴷ ⵄⴰⴱⵉⵔ. ");
INSERT INTO rift_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","ⵜⵜⵡⴰⵔⵡⴻⵏ-ⴷⴷ ⵉ ⵄⴰⴱⵉⵔ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ. ⵉⵊⵊⴻⵏ ⵇⵇⴰⵔⴻⵏ ⴰⵙ ⴼⴰⵍⴰⵊ, ⵎⵉⵏⵣⵉ ⴷⴻⴳ ⵡⵓⵙⵙⴰⵏ ⵏⵏⴻⵙ ⵜᵉⵜⵜⵡⴰⴼⴻⴵⴻⵇ ⵜⴻⵎⵎⵓⵔⵜ, ⵓ ⵇⵇⴰⵔⴻⵏ ⴰⵙ ⵉ ⵓⵎⴰⵙ ⵢⵓⵇⵟⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","ⵢⵓⵇⵟⴰⵏ ⵉⵊⵊⴰ-ⴷⴷ ⴰⵍⵎⵓⴷⴰⴷ, ⵛⴰⵍⴰⴼ, ⵀⴰⴹⴰⵔⵎⴰⵡⵜ, ⵢⴰⵔⴰⵃ, ");
INSERT INTO rift_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ⵀⴰⴷⵓⵔⴰⵎ, ⵓⵣⴰⵍ, ⴷⵉⵇⵍⴰ, ");
INSERT INTO rift_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ⵄⵓⴱⴰⵍ, ⴰⴱⵉⵎⴰⵢⵉⵍ, ⵛⴰⴱⴰ, ");
INSERT INTO rift_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ⵓⴼⵉⵔ, ⵃⴰⵡⵉⵍⴰ ⴷ ⵢⵓⴱⴰⴱ. ⵎⴰⵔⵔⴰ ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵢⵓⵇⵟⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","ⵜⴰⵎⵎⵓⵔⵜ ⵎⴰⵏⵉ ⵜⵓⵖⴰ ⵣⴻⴷⴷⵖⴻⵏ ⵜⵓⵖⴰ-ⵜⵜ ⵣⵉ ⵎⵉⵛⴰ ⴰⵍ ⵙⴰⴼⴰⵔ, ⴰⴷⵔⴰⵔ ⵏ ⵛⵛⴰⵔⵇ. ");
INSERT INTO rift_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","ⵉⵏⴰ ⴷ ⴰⵢⵜ ⵏ ⵛⴰⵎ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ ⵓ ⵄⵍⴰⵃⵙⴰⴱ ⵉⵍⵙⴰⵡⴻⵏ ⵏⵙⴻⵏ, ⴷⵉ ⵜⴻⵎⵎⵓⵔⴰ ⵏⵙⴻⵏ ⵓ ⴰⴽ-ⴷ ⵍⴻⴳⵏⵓⵙ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","ⵜⵉⵏⴰ ⴷ ⵍⴰⴵⴰⵜ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵏⵓⵃ, ⵄⵍⴰⵃⵙⴰⴱ ⵎⴰⵎⵎⴻⵛ ⴷⴷ-ⵅⴻⵍⵇⴻⵏ, ⴰⴽ-ⴷ ⵍⴻⴳⵏⵓⵙ ⵏⵙⴻⵏ. ⵣⵣⴰⵢⵙⴻⵏ ⵉ ⵣⵉ ⵜⵜⵡⴰⴱⴹⴰⵏ ⵍⴻⴳⵏⵓⵙ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⴰⵡⴰⵔⵏⵉ ⵉ ⵙⵙⴻⵃⵍⴻⵜ. * ");
INSERT INTO rift_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","ⵜⵓⵖⴰ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵙ ⵢⵉⵍⴻⵙ ⴷ ⵉⵊⵊⴻⵏ ⵓ ⵙ ⵍⵀⴰⵔⴷ ⴷ ⵉⵊⵊⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","ⵉⵎⵙⴰⵔ ⵍⴰⵎⵉ ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⵓⵛⴰ ⴼⴼⵖⴻⵏ-ⴷⴷ ⵣⵉ ⵛⵛⴰⵔⵇ, ⵓⴼⵉⵏ ⵉⵊⵊ ⵏ ⵍⴻⵡⴹⴰ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵛⵉⵏⵄⴰⵔ, ⵓⵛⴰ ⵇⵇⵉⵎⴻⵏ ⵣⴻⴷⴷⵖⴻⵏ ⴷⵉⵏⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","ⵏⵉⵜⵏⵉ ⵏⵏⴰⵏ, ⴽⵓⵍ ⵉⵊⵊ ⵉ ⵡⴻⵏⵏⴻⵖⵏⵉ: “ⴰⵔⴰⵃⴻⵎ-ⴷⴷ, ⴰⴷ ⵏⴻⴳⴳ ⵉⵥⵔⴰ ⵣⵉ ⵜⵍⴰⵅⵜ, ⴰⴷ ⵜⴻⵏ ⵏⴻⵙⵙⴻⵃⵎⴰ!” ⴰⵎⵎⵓ ⵉ ⴷ ⴰⵙⴻⵏ ⵜⴻⴷⵡⴻⵍ ⵜⵍⴰⵅⵜ ⴷ ⴰⵥⵔⵓ ⵓ ⴰⵛⴰⵔⵎⵓⴹ ⵉⴷⵡⴻⵍ ⵖⴰⵔⵙⴻⵏ ⴷ ⵜⴰⵔⵔⵉⵙⵜ. ");
INSERT INTO rift_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","ⵅⴰⵙ ⵓⵛⴰ ⵏⵏⴰⵏ: “ⵣⵉⴷ, ⴰⴷ ⵏⴻⴱⵏⴰ ⵉⵛⵜ ⵏ ⵜⴻⵏⴷⵉⵏⵜ ⴷ ⵉⵛⵜ ⵏ ⵚⵚⵓⵎⵄⴻⵜ, ⵜⴰⵇⵉⵛⵛⴰⵜ ⵏⵏⴻⵙ ⴰⴷ ⴷⴷ-ⵜⴰⵡⴻⴹ ⵖⴰⵔ ⵓⵊⴻⵏⵏⴰ, ⵓ ⵊⵊⴻⵎ ⴰⵏⴻⵖ ⴰⴷ ⵏⴻⴳⴳ ⵉⵊⵊ ⵏ ⵢⵉⵙⴻⵎ ⵉ ⵏⴻⵛⵛⵉⵏ, ⵃⵉⵎⴰ ⵡⴰⵔ ⵏᵉⵜⵜⴻⵎⵙⴻⴱⴹⵉ ⵛⴰ ⵅ ⵡⵓⴷⴻⵎ ⵏ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ.” ");
INSERT INTO rift_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","ⵅⴻⵏⵏⵉ ⵉⵀⵡⴰ-ⴷⴷ ⵙⵉⴷⵉ, ⵃⵉⵎⴰ ⴰⴷ ⵉⵥⴰⵔ ⵜⴰⵏⴷⵉⵏⵜ ⴷ ⵚⵚⵓⵎⵄⴻⵜ ⵏⵏⵉ ⴱⵏⴰⵏ ⵜⴰⵔⵡⴰ ⵏ ⴱⵏⴰⴷⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","ⵉⵏⵏⴰ ⵙⵉⴷⵉ: “ⵅⵣⴰⵔ, ⴰⵇⴰ ⴰⵜⴻⵏ ⴷ ⵍⴳⴻⵏⵙ ⴷ ⵉⵊⵊⴻⵏ ⵓ ⵎⴰⵔⵔⴰ ⵉⵏⴰ ⵖⴰⵔⵙⴻⵏ ⵉⵊⵊ ⵏ ⵢⵉⵍⴻⵙ. ⵡⴰ ⴷ ⴱⴻⴷⴷⵓ ⵏ ⵎⵉⵏ ⵖⴰ ⴳⴳⴻⵏ. ⵍⴻⵅⵅⵓ ⵡⴰⵔ ⴷⵉⵏ ⵎⵉⵏ ⵜⴻⵏ ⵉ ⵖⴰ ⵉⵙⵙⴱⴻⴷⴷⴻⵏ ⵅ ⵡⴻⴱⵔⵉⴷ ⵏⵙⴻⵏ ⵏⵏⵉ ⵏⵡⴰⵏ ⴰⴷ ⴳⴳⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","ⴰⵔⴰⵃⴻⵎ-ⴷⴷ, ⴰⴷ ⵏⴻⵀⵡⴰ ⵓⵛⴰ ⴰⴷ ⵏⴻⵙⵙⵅⴰⵔⵡⴻⴹ ⵉⵍⴻⵙ ⵏⵙⴻⵏ, ⵃⵉⵎⴰ ⴽⵓⵍ ⵉⵊⵊⴻⵏ ⵡⴰⵔ ⵉⴼⴻⵀⵀⴻⵎ ⵄⴰⴷ ⵉⵍⴻⵙ ⵏ ⵡⴻⵏⵏⵉ ⵜ ⵢⵓⴷⵙⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","ⴰⵎⵎⵓ ⵉ ⵜⴻⵏ ⵉⵣⵣⵓⵣⴰⵔ ⵙⵉⴷⵉ ⵙⵙⴻⵏⵏⵉ ⵅ ⵡⵓⴷⴻⵎ ⵏ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵓⵛⴰ ⵙⵙⴱⴻⴷⴷⴻⵏ ⵍⴻⴱⵏⵉ ⵏ ⵜⴻⵏⴷⵉⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","ⵅ ⵓⵢⴰ ⵉ ⴷ ⴰⵙ ⵍⴰⵖⴰⵏ ⵉ ⵜⴻⵏⴷⵉⵏⵜ ⵏⵏⵉ ⵙ ⵢⵉⵙⴻⵎ ⵏ ‘ⴱⴰⴱⵉⵍ’, ⵎⵉⵏⵣⵉ ⴷⵉⵏ ⵉⵙⵙⵅⴰⵔⵡⴻⴹ ⵙⵉⴷⵉ ⵉⵍⴻⵙ ⵏ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵓ ⵙⵙⴻⵏⵏⵉ ⵉ ⵜⴻⵏ ⵉⵣⵣⵓⵣⴰⵔ ⵙⵉⴷⵉ ⵅ ⵡⵓⴷⴻⵎ ⵏ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ. ⵉⵏⴰ ⴷ ⵉⵎⴻⵣⵔⵓⵢⴻⵏ ⵏ ⵢⵉⵏⵏⵉ ⴷⴷ-ⵉⵜⵜⵡⴰⵅⴻⵍⵇⴻⵏ ⵣⵉ ⵛⴰⵎ. ");
INSERT INTO rift_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","ⵓⵎⵉ ⵜⵓⵖⴰ ⵖⴰⵔ ⵛⴰⵎ ⵎⵢⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵉⵊⵊⴰ-ⴷⴷ ⴰⵔⴼⴰⴽⵛⴰⴷ, ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⴰⵡⴰⵔⵏⵉ ⵉ ⵙⵙⴻⵃⵍⴻⵜ.    ");
INSERT INTO rift_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⴷⴷ-ⵉⵊⵊⴰ ⴰⵔⴼⴰⴽⵛⴰⴷ, ⵉⴷⴷⴰⵔ ⵛⴰⵎ ⵄⴰⴷ ⵅⴻⵎⵙⴰ-ⵎⵢⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵓⵛⴰ ⵉⵊⵊⴰ-ⴷⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⴷ ⵜⵃⴻⵏⵊⵉⵔⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","ⵉⴷⴷⴰⵔ ⴰⵔⴼⴰⴽⵛⴰⴷ ⵅⴻⵎⵙⴰ ⵓ-ⵜⵍⴰⵜⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵅⴻⵏⵏⵉ ⵉⵊⵊⴰ-ⴷⴷ ⵛⴰⵍⴰⵃ. ");
INSERT INTO rift_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⴷⴷ-ⵉⵊⵊⴰ ⴰⵔⴼⴰⴽⵛⴰⴷ ⵛⴰⵍⴰⵃ, ⵉⴷⴷⴰⵔ ⵄⴰⴷ ⴰⵔⴻⴱⵄⴰ-ⵎⵢⴰ ⵓ-ⵜⵍⴰⵜⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵓⵛⴰ ⵉⵊⵊⴰ-ⴷⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⴷ ⵜⵃⴻⵏⵊⵉⵔⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","ⵉⴷⴷⴰⵔ ⵛⴰⵍⴰⵃ ⵜⵍⴰⵜⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵅⴻⵏⵏⵉ ⵉⵊⵊⴰ-ⴷⴷ ⵄⴰⴱⵉⵔ. ");
INSERT INTO rift_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⴷⴷ-ⵉⵊⵊⴰ ⵛⴰⵍⴰⵃ ⵄⴰⴱⵉⵔ, ⵉⴷⴷⴰⵔ ⵄⴰⴷ ⴰⵔⴻⴱⵄⴰ-ⵎⵢⴰ ⵓ-ⵜⵍⴰⵜⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵓⵛⴰ ⵉⵊⵊⴰ-ⴷⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⴷ ⵜⵃⴻⵏⵊⵉⵔⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","ⵉⴷⴷⴰⵔ ⵄⴰⴱⵉⵔ ⴰⵔⴻⴱⵄⴰ ⵓ-ⵜⵍⴰⵜⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵅⴻⵏⵏⵉ ⵉⵊⵊⴰ-ⴷⴷ ⴼⴰⵍⴰⵊ. ");
INSERT INTO rift_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⴷⴷ-ⵉⵊⵊⴰ ⴼⴰⵍⴰⵊ, ⵉⴷⴷⴰⵔ ⵄⴰⴱⵉⵔ ⵄⴰⴷ ⴰⵔⴻⴱⵄⴰ-ⵎⵢⴰ ⵓ-ⵜⵍⴰⵜⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵓⵛⴰ ⵉⵊⵊⴰ-ⴷⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⴷ ⵜⵃⴻⵏⵊⵉⵔⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","ⵉⴷⴷⴰⵔ ⴼⴰⵍⴰⵊ ⵜⵍⴰⵜⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵅⴻⵏⵏⵉ ⵉⵊⵊⴰ-ⴷⴷ ⵔⴰⵄⵓⵡ.    ");
INSERT INTO rift_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⴷⴷ-ⵉⵊⵊⴰ ⵔⴰⵄⵓⵡ, ⵉⴷⴷⴰⵔ ⴼⴰⵍⴰⵊ ⵄⴰⴷ ⵎⵉⵜⴰⵢⴻⵏ ⵓ-ⵜⴻⵙⵄⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵓⵛⴰ ⵉⵊⵊⴰ-ⴷⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⴷ ⵜⵃⴻⵏⵊⵉⵔⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","ⵉⴷⴷⴰⵔ ⵔⴰⵄⵓⵡ ⵜⵏⴰⵢⴻⵏ ⵓ-ⵜⵍⴰⵜⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵅⴻⵏⵏⵉ ⵉⵊⵊⴰ-ⴷⴷ ⵙⴰⵔⵓⵊ. ");
INSERT INTO rift_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⴷⴷ-ⵉⵊⵊⴰ ⵙⴰⵔⵓⵊ, ⵉⴷⴷⴰⵔ ⵔⴰⵄⵓⵡ ⵄⴰⴷ ⵎⵉⵜⴰⵢⴻⵏ ⵓ-ⵙⴻⴱⵄⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵓⵛⴰ ⵉⵊⵊⴰ-ⴷⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⴷ ⵜⵃⴻⵏⵊⵉⵔⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","ⵉⴷⴷⴰⵔ ⵙⴰⵔⵓⵊ ⵜⵍⴰⵜⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵅⴻⵏⵏⵉ ⵉⵊⵊⴰ-ⴷⴷ ⵏⴰⵃⵓⵔ. ");
INSERT INTO rift_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⴷⴷ-ⵉⵊⵊⴰ ⵏⴰⵃⵓⵔ, ⵉⴷⴷⴰⵔ ⵙⴰⵔⵓⵊ ⵄⴰⴷ ⵎⵉⵜⴰⵢⴻⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵓⵛⴰ ⵉⵊⵊⴰ-ⴷⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⴷ ⵜⵃⴻⵏⵊⵉⵔⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","ⵉⴷⴷⴰⵔ ⵏⴰⵃⵓⵔ ⵜⴻⵙⵄⴰ ⵓ-ⵄⵉⵛⵔⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵅⴻⵏⵏⵉ ⵉⵊⵊⴰ-ⴷⴷ ⵜⴰⵔⴰⵃ. ");
INSERT INTO rift_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⴷⴷ-ⵉⵊⵊⴰ ⵏⴰⵃⵓⵔ ⵜⴰⵔⴰⵃ, ⵉⴷⴷⴰⵔ ⵄⴰⴷ ⵎⵢⴰ ⵓ-ⵜⴻⵙⵄⴰⵟⴰⵛ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵓⵛⴰ ⵉⵊⵊⴰ-ⴷⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⴷ ⵜⵃⴻⵏⵊⵉⵔⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","ⵉⴷⴷⴰⵔ ⵜⴰⵔⴰⵃ ⵙⴻⴱⵄⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵅⴻⵏⵏⵉ ⵉⵊⵊⴰ-ⴷⴷ ⴰⴱⵔⴰⵎ, ⵏⴰⵃⵓⵔ ⴷ ⵀⴰⵔⴰⵏ. ⵉⵏⴰ ⴷ ⵉⵎⴻⵣⵔⵓⵢⴻⵏ ⵏ ⵢⵉⵏⵏⵉ ⴷⴷ-ⵉⵜⵜⵡⴰⵅⴻⵍⵇⴻⵏ ⵣⵉ ⵜⴰⵔⴰⵃ. ");
INSERT INTO rift_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","ⵜⴰⵔⴰⵃ ⵉⵊⵊⴰ-ⴷⴷ ⴰⴱⵔⴰⵎ, ⵏⴰⵃⵓⵔ ⴷ ⵀⴰⵔⴰⵏ, ⵓ ⵀⴰⵔⴰⵏ ⵉⵊⵊⴰ-ⴷⴷ ⵍⵓⵟ. ");
INSERT INTO rift_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","ⵉⵎⵎⵓⵜ ⵀⴰⵔⴰⵏ ⵣⵣⴰⵜ ⵉ ⴱⴰⴱⴰⵙ ⵜⴰⵔⴰⵃ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵎⴰⵏⵉ ⴷⴷ-ⵉⵅⵍⴻⵇ ⵏⴻⵜⵜⴰ, ⴷⵉ ⵓⵔ ⵏ ⵉⴽⴰⵍⴷⴰⵏⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","ⵓⵛⴰ ⴽⵙⵉⵏ ⴰⴱⵔⴰⵎ ⴷ ⵏⴰⵃⵓⵔ ⵉ ⵢⵉⵅⴻⴼ ⵏⵙⴻⵏ ⵜⵉⵎⵖⴰⵔⵉⵏ. ⵉⵙⴻⵎ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⵏ ⴰⴱⵔⴰⵎ ⵜⵓⵖⴰ-ⵜ ⴷ ⵙⴰⵔⴰⵢ ⵓ ⵉⵙⴻⵎ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⵏ ⵏⴰⵃⵓⵔ ⴷ ⵎⵉⵍⴽⴰ, ⵢⴻⴵⵉⵙ ⵏ ⵀⴰⵔⴰⵏ, ⴱⴰⴱⴰⵙ ⵏ ⵎⵉⵍⴽⴰ ⴷ ⵢⵉⵙⴽⴰ. ");
INSERT INTO rift_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","ⵙⴰⵔⴰⵢ ⵜⵓⵖⴰ-ⵜⵜ ⵡⴰⵔ ⴷⴷ-ⵜᵉⵜⵜⵉⵔⵓⵡ, ⵜⵓⵖⴰ ⵡⴰⵔ ⵖⴰⵔⴻⵙ ⴱⵓ ⵓⵃⴻⵏⵊⵉⵔ. ");
INSERT INTO rift_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","ⵓⵛⴰ ⵉⴽⵙⵉ ⵜⴰⵔⴰⵃ ⴰⴱⵔⴰⵎ, ⵎⵎⵉⵙ, ⴷ ⵍⵓⵟ ⵎⵎⵉⵙ ⵏ ⵀⴰⵔⴰⵏ, ⵎⵎⵉⵙ ⵏ ⵎⵎⵉⵙ, ⴷ ⵙⴰⵔⴰⵢ, ⵜⴰⵙⵍⵉⵜ ⵏⵏⴻⵙ, ⵜⴰⵎⵖⴰⵔⵜ ⵏ ⵎⵎⵉⵙ ⴰⴱⵔⴰⵎ, ⵓⵛⴰ ⵏⵉⵜⵏⵉ ⴼⴼⵖⴻⵏ ⵊⵎⵉⵄ ⵣⵉ ⵓⵔ ⵏ ⵉⴽⴰⵍⴷⴰⵏⵉⵢⵢⴻⵏ, ⵃⵉⵎⴰ ⴰⴷ ⵔⴰⵃⴻⵏ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ. ⵉⵡⴹⴻⵏ ⵖⴰⵔ ⵃⴰⵔⴰⵏ ⵓⵛⴰ ⵣⴻⴷⴷⵖⴻⵏ ⴷⵉⵏⵏⵉ.    ");
INSERT INTO rift_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","ⵓⵎⵉ ⵜⴻⴳⴳⴰ ⵜⴰⵔⴰⵃ ⵎⵉⵜⴰⵢⴻⵏ ⵓ-ⵅⴻⵎⵙⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵉⵎⵎⵓⵜ ⵜⴰⵔⴰⵃ ⴷⵉ ⵃⴰⵔⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⴰⴱⵔⴰⵎ: “ⴼⴼⴻⵖ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⴻⵛ, ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵎⴰⵏⵉ ⴷⴷ-ⵜⵅⴻⵍⵇⴻⴷ ⵓ ⵣⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⴱⴰⴱⴰⵛ, ⵔⵓⵃ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵉ ⴷ ⴰⵛ ⵖⴰ ⵙⵙⴻⵛⵏⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","ⴰⴷ ⵣⵣⴰⵢⴻⴽ ⴷⴷ-ⵙⵙⵓⴼⴼⵖⴻⵖ ⵉⵊⵊ ⵏ ⵍⴳⴻⵏⵙ ⵉⵎⵖⴰⵔ, ⴰⴷ ⵛⴻⴽ ⴱⴰⵔⴽⴻⵖ ⵓ ⴰⴷ ⵙⵙⴻⵎⵖⴰⵔⴻⵖ ⵉⵙⴻⵎ ⵏⵏⴻⵛ ⵓⵛⴰ ⵉⵍⵉ ⴷ ⵛⴻⴽ ⵄⴰⵡⴻⴷ ⴷ ⵍⴱⴰⵔⴰⴽⴰ. ");
INSERT INTO rift_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","ⴰⴷ ⴱⴰⵔⴽⴻⵖ ⵡⴻⵏⵏⵉ ⵛⴻⴽ ⵉ ⵖⴰ ⵉⴱⴰⵔⴽⴻⵏ ⴷ ⵡⴻⵏⵏⵉ ⵛⴻⴽ ⵉ ⵖⴰ ⵉⵏⴻⵄⵍⴻⵏ, ⴰⴷ ⵜ ⵏⴻⵄⵍⴻⵖ. ⴷⴰⵢⴻⴽ ⵉ ⵖⴰ ⵜⵜⵡⴰⴱⴰⵔⴽⴻⵏⵜ ⵎⴰⵔⵔⴰ ⵍⴰⴵⴰⵜ ⵏ ⵜⴻⵎⵎⵓⵔⵜ.”   * ");
INSERT INTO rift_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","ⵓⵛⴰ ⵉⵔⵓⵃ ⴰⴱⵔⴰⵎ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵙ ⵉⵏⵏⴰ ⵙⵉⴷⵉ, ⵓⵛⴰ ⵉⵔⵓⵃ ⵍⵓⵜ ⴰⴽⵉⴷⴻⵙ. ⵜⵓⵖⴰ ⴰⴱⵔⴰⵎ ⵖⴰⵔⴻⵙ ⵅⴻⵎⵙⴰ ⵓ-ⵙⴻⴱⵄⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵓⵎⵉ ⴷⴷ-ⵉⴼⴼⴻⵖ ⵣⵉ ⵃⴰⵔⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","ⵓⵛⴰ ⵉⵏⴷⴻⵀ ⴰⴱⵔⴰⵎ ⵙⴰⵔⴰⵢ ⵜⴰⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ, ⴷ ⵍⵓⵟ ⵎⵎⵉⵙ ⵏ ⵓⵎⴰⵙ, ⴷ ⵎⴰⵔⵔⴰ ⴰⴳⵍⴰ ⵉ ⵢⴰⵔⴻⴱⵃⴻⵏ, ⴷ ⵉⵡⴷⴰⵏ ⴷ ⵍⵎⴰⵍ ⵏⵏⵉ ⴷⴷ-ⴽⴻⵙⴱⴻⵏ ⴷⵉ ⵃⴰⵔⴰⵏ. ⴼⴼⵖⴻⵏ ⵣⵉ ⵃⴰⵔⴰⵏ ⵃⵉⵎⴰ ⴰⴷ ⵔⴰⵃⴻⵏ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ ⵓⵛⴰ ⵉⵡⴹⴻⵏ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","ⵉⵥⵡⴰ ⴰⴱⵔⴰⵎ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⵉ ⵖⴰⵔ ⵡⴻⵎⵛⴰⵏ ⵏ ⵛⴰⴽⵉⵎ ⴰⵍ ⵜⴰⵛⴻⵊⵊⴰⵔⵜ ⵏ ⵢⵉⴳⴳ ⵏ ⵎⵓⵔⴰ. ⴷⵉ ⵍⵡⴻⵇⵜ ⵏⵏⵉ ⵜⵓⵖⴰ ⴰⵢⵜ ⵏ ⴽⴻⵏⵄⴰⵏ ⵣⴻⴷⴷⵖⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ.    ");
INSERT INTO rift_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","ⵉⴱⴰⵏ-ⴷⴷ ⵙⵉⴷⵉ ⵉ ⴰⴱⵔⴰⵎ, ⵉⵏⵏⴰ ⴰⵙ: “ⵉ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵛ ⵓⵎⵉ ⵉ ⵖⴰ ⵡⵛⴻⵖ ⵜⴰⵎⵎⵓⵔⵜ-ⴰ.” ⵓⵛⴰ ⵉⴱⵏⴰ ⴷⵉⵏ ⵉⵊⵊ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ⵎⵉⵏ ⵅⴻⴼ ⵉⵙⵙⴰⵔⵙ ⵜⴰⵖⴰⵔⵚⵜ ⵉ ⵙⵉⴷⵉ, ⵡⴻⵏⵏⵉ ⴷ ⴰⵙ ⴷⴷ-ⵉⴱⴰⵏⴻⵏ.    ");
INSERT INTO rift_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","ⵅⴻⵏⵏⵉ ⵉⵄⴷⵓ ⵙⵙⴻⵏⵏⵉ ⵖⴰⵔ ⵉⴷⵓⵔⴰⵔ ⵉ ⵉⴵⴰⵏ ⵅ ⵛⵛⴰⵔⵇ ⵏ ⴱⴰⵢⵜ-ⵉⵍ ⵓⵛⴰ ⵉⵡⵜⴰ ⴷⵉⵏⵏⵉ ⵉⵇⵉⴹⴰⵏ ⵏⵏⴻⵙ, ⵉⵊⵊⴰ ⴱⴰⵢⵜ-ⵉⵍ ⵅ ⵊⵊⵉⵀⴻⵜ ⵏ ⵍⵖⴰⵔⴱ ⵓ ⵄⴰⵢ ⵅ ⵛⵛⴰⵔⵇ. ⴷⵉⵏ ⵉⴱⵏⴰ ⵉⵊⵊ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ⵉ ⵙⵉⴷⵉ ⵓⵛⴰ ⵉⵍⴰⵖⴰ ⵉⵙⴻⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","ⴰⵡⴰⵔⵏⵉ ⵎⴰⵏ ⴰⵢⴰ ⵉⴼⵙⵉ ⴰⴱⵔⴰⵎ ⵉⵇⵉⴹⴰⵏ ⵏⵏⴻⵙ, ⵉⵎⵎⵓⵟⵟⵉ ⵣⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵖⴰⵔ ⵡⴻⵎⵛⴰⵏ, ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵍⵊⴰⵏⵓⴱ. ");
INSERT INTO rift_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","ⵉⴷⵡⴻⵍ ⵍⴰⵥ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵓⵛⴰ ⵉⴽⴻⵎⵎⴻⵍ ⴰⴱⵔⴰⵎ ⵅ ⵡⴻⴱⵔⵉⴷ ⵏⵏⴻⵙ, ⵉⵀⵡⴰ ⵖⴰⵔ ⵎⵉⵚⵔⴰ, ⵃⵉⵎⴰ ⴰⴷ ⵉⵣⴷⴻⵖ ⴷⵉⵏ ⴰⵎ ⵓⴱⴰⵔⵔⴰⵏⵉ, ⵎⵉⵏⵣⵉ ⵜⵓⵖⴰ ⵍⴰⵥ ⵉⵎⵖⴰⵔ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","ⵍⴰⵎⵉ ⴷⴷ-ⵜⵉⵡⴻⴹ ⵍⵡⴻⵇⵜ ⵏⵏⵉ ⵓⵎⵉ ⵉ ⵖⴰ ⵢⵓⴷⴻⴼ ⵖⴰⵔ ⵎⵉⵚⵔⴰ, ⵉⵏⵏⴰ ⵉ ⵙⴰⵔⴰⵢ, ⵜⴰⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ: “ⵅⵣⴰⵔ, ⴰⵇⴰ ⵙⵙⵏⴻⵖ ⴱⴻⵍⵍⵉ ⵛⴻⵎ ⴷ ⵜⴰⵎⵖⴰⵔⵜ ⴷⴰⵢⴻⵙ ⴰⵥⵔⵉ. ");
INSERT INTO rift_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","ⵅⵎⵉ ⵛⴻⵎ ⵉ ⵖⴰ ⵥⴰⵔⴻⵏ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ, ⵣⴻⵎⵎⴰⵔⴻⵏ ⴰⴷ ⵉⵏⵉⵏ: ‘ⵜⴰ ⴷ ⵜⴰⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ!’, ⴰⴷ ⴰⵢⵉ ⵏⵖⴻⵏ ⵓⵛⴰ ⴰⴷ ⵛⴻⵎ ⵊⵊⴻⵏ ⴷⵉ ⵜⵓⴷⴰⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","ⵉⵏⵉ, ⴰⵇⴰ ⵛⴻⵎ ⴷ ⵓⵞⵎⴰ, ⵃⵉⵎⴰ ⴰⴷ ⴰⵢⵉ ⵢⵉⵍⵉ ⵍⵅⵉⵔ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏⵏⴻⵎ ⵓⵛⴰ ⴰⴷ ⵉⵇⵇⵉⵎ ⵍⴻⵄⵎⴰⵔ ⵉⵏⵓ ⵉⴷⴷⴰⵔ ⵉ ⵛⴻⵎ.” ");
INSERT INTO rift_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","ⵉⵎⵙⴰⵔ ⵓⵎⵉ ⵢⵓⴷⴻⴼ ⴰⴱⵔⴰⵎ ⵖⴰⵔ ⵎⵉⵚⵔⴰ, ⵥⵔⵉⵏ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ ⴱⴻⵍⵍⵉ ⵜⴰⵎⵖⴰⵔⵜ ⵜⴻⵚⴱⴻⵃ ⴰⵟⵟⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","ⵓⵍⴰ ⴷ ⵍⵃⵓⴽⴽⴰⵎ ⵏ ⴼⵉⵔⵄⵓⵏ, ⴰⵊⴻⴵⵉⴷ, ⵥⵔⵉⵏ ⵜⵜ ⵓⵛⴰ ⵙⵙⴻⵎⵖⴰⵔⴻⵏ ⵜⵜ ⵖⴰⵔ ⴼⵉⵔⵄⵓⵏ ⵓⵛⴰ ⵉⵡⵢⴻⵏ ⵜⵜ ⵖⴰⵔ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⴼⵉⵔⵄⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","ⵓⵛⴰ ⵉⵎⵚⵓⵔⴻⴼ ⴼⵉⵔⵄⵓⵏ ⵎⵍⵉⵀ ⴰⴽ-ⴷ ⴰⴱⵔⴰⵎ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏⵏⴻⵙ. ⴰⵎⵎⵓ ⵉ ⵉⴽⵙⵉ ⵓⴵⵉ ⴷ ⵉⴼⵓⵏⴰⵙⴻⵏ ⴷ ⵜⴼⵓⵏⴰⵙⵉⵏ ⴷ ⵢⴻⵖⵢⴰⵍ ⴷ ⵉⵙⴻⵎⵖⴰⵏ ⴷ ⵜⵉⵢⵢⴰ ⴷ ⵜⴻⵖⵢⴰⵍ ⴷ ⵉⵍⴻⵖⵎⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","ⵎⴰⵛⴰ ⵙⵉⴷⵉ ⵉⵡⵜⴰ ⴼⵉⵔⵄⵓⵏ ⴷ ⴰⵢⵜⴱⴰⴱ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⴻⵙ ⵙ ⵊⵊⵔⴰⵢⴻⵃ ⵎⵖⴰⵔⴻⵏⵜ ⴷⵉ ⵍⴻⵙⴱⴰⴱ ⵏ ⵙⴰⵔⴰⵢ, ⵜⴰⵎⵖⴰⵔⵜ ⵏ ⴰⴱⵔⴰⵎ. ");
INSERT INTO rift_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","ⵅⴻⵏⵏⵉ ⴼⵉⵔⵄⵓⵏ ⵉⵍⴰⵖⴰ-ⴷⴷ ⵉ ⴰⴱⵔⴰⵎ, ⵉⵏⵏⴰ ⴰⵙ: “ⵎⴰⵏⴰⵡⴰⵢⴰ ⵉ ⴷⴰⵢⵉ ⵜⴻⴳⴳⵉⴷ? ⵎⴰⵖⴰⵔ ⵡⴰⵔ ⴷ ⴰⵢⵉ ⵜⴻⵏⵏⵉⴷ ⴱⴻⵍⵍⵉ ⵏⴻⵜⵜⴰⵜ ⴷ ⵜⴰⵎⵖⴰⵔⵜ ⵏⵏⴻⵛ? ");
INSERT INTO rift_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","ⵎⴰⵢⴻⵎⵎⵉ ⵜⴻⵏⵏⵉⴷ: ‘ⵏⴻⵜⵜⴰⵜ ⴷ ⵓⵞⵎⴰ!’, ⴰⵍⴰⵎⵉ ⵜⵜ ⴳⴳⵉⵖ ⵏⴻⵛⵛ ⴷ ⵜⴰⵎⵖⴰⵔⵜ ⵉ ⵢⵉⵅⴻⴼ ⵉⵏⵓ? ⵍⴻⵅⵅⵓ ⵅⵣⴰⵔ, ⴰⵇⴰ ⴰⵛ ⵜⴰⵎⵖⴰⵔⵜ ⵏⵏⴻⵛ, ⴽⵙⵉ ⵜⵜ, ⵜⴱⴻⵄⵄⴷⴻⴷ!” ");
INSERT INTO rift_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","ⵢⵓⵎⵓⵔ ⴼⵉⵔⵄⵓⵏ ⵉⵔⵢⴰⵣⴻⵏ ⵏⵏⴻⵙ ⵅⴰⵙ ⵓⵛⴰ ⵙⵙⵇⴻⴱⴱⴹⴻⵏ ⵜ ⴰⴽ-ⴷ ⵜⴻⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ ⵓ ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵜⵓⵖⴰ ⵖⴰⵔⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","ⴰⵎⵎⵓ ⵉ ⵢⵓⵢⵓⵔ ⴰⴱⵔⴰⵎ ⵣⵉ ⵎⵉⵚⵔⴰ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵍⵊⴰⵏⵓⴱ ⵏ ⴽⴻⵏⵄⴰⵏ, ⵏⴻⵜⵜⴰ ⴷ ⵜⴻⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ, ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵖⴰⵔⴻⵙ, ⴷ ⵍⵓⵟ ⴰⴽⵉⴷⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","ⴰⴱⵔⴰⵎ ⵜⵓⵖⴰ ⵖⴰⵔⴻⵙ ⴰⵟⵟⴰⵙ ⵏ ⵡⴰⴳⵍⴰ ⴷ ⵍⴻⴱⵀⴰⵢⴻⵎ ⴷ ⵏⵏⵓⵇⴰⵔⵜ ⴷ ⵡⵓⵔⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","ⵓⵛⴰ ⵉⵎⵎⵓⵟⵟⵉ ⵣⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵖⴰⵔ ⵡⴻⵎⵛⴰⵏ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵍⵊⴰⵏⵓⴱ ⵖⴰⵔ ⴱⴰⵢⵜ-ⵉⵍ ⴰⵍ ⴰⵎⵛⴰⵏ ⵎⴰⵏⵉ ⵜⵓⵖⴰ ⵉⴵⴰ ⵓⵇⵉⴹⵓⵏ ⵏⵏⴻⵙ ⵇⴱⴻⵍ, ⵊⴰⵔ ⴱⴰⵢⵜ-ⵉⵍ ⴷ ⵄⴰⵢ, ");
INSERT INTO rift_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","ⴰⵍ ⴰⵎⵛⴰⵏ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ⵉ ⵜⵓⵖⴰ ⵉⴳⴳⴰ ⵇⴱⴻⵍ, ⵎⵉⵏ ⵅⴻⴼ ⵉⵙⵙⴰⵔⵙ ⵜⵉⵖⴰⵔⵚⴰ ⴷ ⵜⴻⵡⵀⵉⴱⵉⵏ, ⵓⵛⴰ ⴷⵉⵏⵏⵉ ⵉⵍⴰⵖⴰ ⴰⴱⵔⴰⵎ ⵉⵙⴻⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","ⵓⵛⴰ ⵍⵓⵟ, ⵡⴻⵏⵏⵉ ⵢⵓⵢⵓⵔⴻⵏ ⴰⴽ-ⴷ ⴰⴱⵔⴰⵎ, ⵜⵓⵖⴰ ⵖⴰⵔⴻⵙ ⵄⴰⵡⴻⴷ ⵓⴵⵉ ⴷ ⵉⴼⵓⵏⴰⵙⴻⵏ ⴷ ⵜⴼⵓⵏⴰⵙⵉⵏ ⴷ ⵉⵇⵉⴹⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","ⵜⴰⵎⵎⵓⵔⵜ ⵡⴰⵔ ⴷ ⴰⵙⴻⵏ ⵜⵉⵔⵉⵡ ⵃⵉⵎⴰ ⴰⴷ ⵇⵇⵉⵎⴻⵏ ⵣⴻⴷⴷⵖⴻⵏ ⵊⵎⵉⵄ, ⵎⵉⵏⵣⵉ ⴰⴳⵍⴰ ⵏⵙⴻⵏ ⵉⵎⵖⴰⵔ ⴰⵟⵟⴰⵙ ⴰⵍ ⵡⴰⵔ ⵣⴻⵎⵎⴰⵔⴻⵏ ⴰⴷ ⴷⵉⵏ ⵣⴻⴷⵖⴻⵏ ⵊⵎⵉⵄ. ");
INSERT INTO rift_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","ⵓⵛⴰ ⵉⵎⵙⴰⵔ ⵓⵎⵛⵓⴱⴱⴻⵛ ⵊⴰⵔ ⵉⵎⴻⴽⵙⴰⵡⴻⵏ ⵏ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏ ⴰⴱⵔⴰⵎ ⴷ ⵉⵎⴻⴽⵙⴰⵡⴻⵏ ⵏ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏ ⵍⵓⵟ. ⵜⵓⵖⴰ ⴰⵢⵜ ⵏ ⴽⴻⵏⵄⴰⵏ ⴷ ⵉⴼⵉⵔⵉⵣⵉⵢⵢⴻⵏ ⵣⴻⴷⴷⵖⴻⵏ ⵍⴻⵅⴷⴻⵏⵏⵉ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ.    ");
INSERT INTO rift_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","ⵉⵏⵏⴰ ⴰⴱⵔⴰⵎ ⵉ ⵍⵓⵟ: “ⵡⴰⵔ ⵉⵜⵜⵉⵍⵉ ⵄⴰⴷ ⵓⵎⵛⵓⴱⴱⴻⵛ ⵊⴰⵔ ⴰⵢⵉ ⴷ ⵛⴻⴽ, ⵊⴰⵔ ⵉⵎⴻⴽⵙⴰⵡⴻⵏ ⵉⵏⵓ ⴷ ⵉⵎⴻⴽⵙⴰⵡⴻⵏ ⵏⵏⴻⵛ, ⵎⵉⵏⵣⵉ ⵏⴻⵛⵛⵉⵏ ⴷ ⵉⵔⵢⴰⵣⴻⵏ ⴰⵡⵎⴰⵜⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","ⵎⴰ ⵡⴰⵔ ⵜⴰⵔⵣⴻⵎ ⵜⴻⵎⵎⵓⵔⵜ ⵣⵣⴰⵜⴻⵛ? ⵜⵜⵣⴰⵡⴳⴻⵖ ⵛⴻⴽ ⴰⴷ ⵅⴰⴼⵉ ⵜⴻⴱⴹⵉⴹ, ⵎⴰ ⵅ ⵓⵣⴻⵍⵎⴰⴹ, ⵏⵉⵖ ⵅ ⵢⴻⴼⵓⵙ! ⵎⴰⵍⴰ ⵛⴻⴽ ⵜⵔⵓⵃⴻⴷ ⵅ ⵢⴻⴼⵓⵙ, ⵏⴻⵛⵛ ⴰⴷ ⵔⴰⵃⴻⵖ ⵅ ⵓⵣⴻⵍⵎⴰⴹ.” ");
INSERT INTO rift_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","ⵉⵙⵙⴳⴻⵄⵄⴻⴷ ⵍⵓⵟ ⵜⴰⵎⵓⵖⵍⵉ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⵥⵔⴰ ⴰⴷⴻⵡⵡⴰⵔ ⵏ ⵢⴻⵖⵣⴰⵔ ⵏ ⵍ’ⵓⵔⴷⵓⵏ ⵜⵓⵖⴰ ⵎⴰⵔⵔⴰ ⵉⵙⵡⴰ. ⵇⴱⴻⵍ ⴰⵔⴻⴷⴷⴻⴵ ⵣⵉ ⵙⵉⴷⵉ ⵜⵓⵖⴰ ⵙⴰⴷⵓⵎ ⴷ ⵄⴰⵎⵓⵔⵔⴰ ⴰⵎ ⵊⵊⴻⵏⵏⴻⵜ ⵏ ⵙⵉⴷⵉ, ⴰⵎ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⵅⵎⵉ ⴷⴷ ⵖⴰ ⵜⴰⵙⴻⴷ ⵖⴰⵔ ⵚⵓⵖⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","ⵓⵛⴰ ⵉⵅⴹⴰⵔ ⵍⵓⵟ ⵉ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵎⴰⵔⵔⴰ ⴰⴷⴻⵡⵡⴰⵔ ⵏ ⵢⴻⵖⵣⴰⵔ ⵏ ⵍ’ⵓⵔⴷⵓⵏ ⵓ ⵉⴼⵙⵉ ⵍⵓⵟ ⵉⵇⵉⴹⴰⵏ ⵏⵏⴻⵙ ⵓⵛⴰ ⵢⵓⵢⵓⵔ ⵖⴰⵔ ⵛⵛⴰⵔⵇ. ⴰⵎⵎⵓ ⵉ ⵎⵎⵙⴻⴱⴹⴰⵏ ⵏⵉⵜⵏⵉ ⵉⵊⵊⴻⵏ ⵅ ⵡⴻⵏⵏⴻⵖⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","ⴰⴱⵔⴰⵎ ⵉⵣⴷⴻⵖ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ, ⵎⴰⵛⴰ ⵍⵓⵟ ⵉⵣⴷⴻⵖ ⴷⵉ ⵜⵏⴻⴷⴷⴰⵎ ⵏ ⵓⴷⴻⵡⵡⴰⵔ ⵏ ⵍ’ⵓⵔⴷⵓⵏ, ⵉⵡⵜⴰ ⵉⵇⵉⴹⴰⵏ ⵏⵏⴻⵙ ⴰⵍ ⵙⴰⴷⵓⵎ. ");
INSERT INTO rift_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","ⵉⵔⵢⴰⵣⴻⵏ ⵏ ⵙⴰⴷⵓⵎ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵄⴻⴼⴼⴰⵏⴻⵏ ⴷ ⵉⵎⴻⴷⵏⴰⴱ ⴰⴽ-ⴷ ⵙⵉⴷⵉ ⴰⵍ ⵟⵟⴰⵔⴼ. ");
INSERT INTO rift_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⵅⴰⵙ ⵉⵎⵎⵙⴻⴱⴹⴰ ⵍⵓⵟ, ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⴰⴱⵔⴰⵎ: “ⵙⴰⵔⵔⴻⵃ ⵍⴻⵅⵅⵓ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵛ, ⵜⴻⵅⵣⴰⵔⴻⴷ ⵣⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵎⴰⵏⵉ ⵜⴻⴵⵉⴷ ⵖⴰⵔ ⵛⵛⴰⵎⴰⵍ, ⵖⴰⵔ ⵍⵊⴰⵏⵓⴱ, ⵖⴰⵔ ⵛⵛⴰⵔⵇ ⵓ ⵖⴰⵔ ⵍⵖⴰⵔⴱ, ");
INSERT INTO rift_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","ⵎⵉⵏⵣⵉ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵉ ⵜᵉⵜⵜⵡⴰⵍⵉⴷ, ⴰⴷ ⴰⵛ ⵜⵜ ⵡⵛⴻⵖ, ⵉ ⵛⴻⴽ ⴷ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵛ ⵉ ⵍⴻⴱⴷⴰ. ");
INSERT INTO rift_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","ⴰⴷ ⴳⴳⴻⵖ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵛ ⴰⵎ ⵜⵄⴻⵊⵊⴰⵊⵜ ⵏ ⵜⴻⵎⵎⵓⵔⵜ, ⵃⵉⵎⴰ, ⵎⴰⵍⴰ ⵉⵣⴻⵎⵎⴰⵔ ⵃⴻⴷ ⴰⴷ ⵉⵃⵙⴻⴱ ⵜⴰⵄⴻⵊⵊⴰⵊⵜ ⵏ ⵜⴻⵎⵎⵓⵔⵜ, ⵓⵍⴰ ⴷ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵛ ⵜⵣⴻⵎⵎⴰⵔ ⵄⴰⵡⴻⴷ ⴰⴷ ⵜᵉⵜⵜⵡⴰⵃⵙⴻⴱ. ");
INSERT INTO rift_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","ⴽⴽⴰⵔ, ⵛⵓⵇ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⴷⵉ ⵜⵓⵣⵣⴻⴳⴳⴰⵔⵜ ⵏⵏⴻⵙ ⴷ ⵜⵉⵔⵓ ⵏⵏⴻⵙ, ⵎⵉⵏⵣⵉ ⵉ ⵛⴻⴽ ⵓⵎⵉ ⵜⵜ ⵉ ⵖⴰ ⵡⵛⴻⵖ.” ");
INSERT INTO rift_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","ⵅⴻⵏⵏⵉ ⵉⴽⴽⴻⵙ ⴰⴱⵔⴰⵎ ⵉⵇⵉⴹⴰⵏ ⵏⵏⴻⵙ ⵓⵛⴰ ⵢⵓⵢⵓⵔ ⴰⴷ ⵉⵣⴷⴻⵖ ⵖⴰⵔ ⵜⵛⴻⵊⵊⵓⵔⴰ ⵏ ⵢⵉⴳⴳ ⵏ ⵎⴰⵎⵔⵉ, ⵉⵏⵏⵉ ⵉⴵⴰⵏ ⴷⵉ ⵃⴰⴱⵔⵓⵏ. ⴷⵉⵏⵏⵉ ⵉⴱⵏⴰ ⵉⵊⵊ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","ⴷⴻⴳ ⵡⵓⵙⵙⴰⵏ ⵏ ⴰⵎⵔⴰⴼⵉⵍ, ⴰⵊⴻⴵⵉⴷ ⵏ ⵛⵉⵏⵄⴰⵔ, ⴷ ⴰⵔⵉⵢⵓⵛ, ⴰⵊⴻⴵⵉⴷ ⵏ ⵉⵍⵍⴰⵙⴰⵔ, ⴷ ⴽⵉⴷⵓⵔⵍⴰⵄⵓⵎⴻⵔ, ⴰⵊⴻⴵⵉⴷ ⵏ ⵄⵉⵍⴰⵎ, ⴷ ⵜⵉⴷⴰⵍ, ⴰⵊⴻⴵⵉⴷ ⵏ ⵍⴻⴳⵏⵓⵙ, ⵉⵎⵙⴰⵔ ⴱⴻⵍⵍⵉ ");
INSERT INTO rift_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ⵉⵏⴰ ⴳⴳⵉⵏ ⵍⴱⴰⵔⵓⴹ ⴰⴽ-ⴷ ⴱⵉⵔⴰ, ⴰⵊⴻⴵⵉⴷ ⵏ ⵙⴰⴷⵓⵎ ⵓ ⴰⴽ-ⴷ ⴱⵉⵔⵛⴰⵄ, ⴰⵊⴻⴵⵉⴷ ⵏ ⵄⴰⵎⵓⵔⵔⴰ, ⵓ ⴰⴽ-ⴷ ⵛⵉⵏⴰⴱ, ⴰⵊⴻⴵⵉⴷ ⵏ ⴰⴷⵎⴰ, ⵓ ⴰⴽ-ⴷ ⵛⵉⵎ’ⵉⴱⴰⵔ, ⴰⵊⴻⴵⵉⴷ ⵏ ⵚⴰⴱⵓⵢⵉⵎ, ⵓ ⴰⴽ-ⴷ ⵓⵊⴻⴵⵉⴷ ⵏ ⴱⵉⵍⴰⵄ, ⵡⴻⵏⵏⵉ ⵉⴵⴰⵏ ⴷ ⵚⵓⵖⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","ⵎⴰⵔⵔⴰ ⵉⵏⴰ ⵎⵓⵏⴻⵏ ⴷⵉ ⵍⴻⵡⴹⴰ ⵏ ⵜⴻⵖⵣⵓⵔⵜ ⵏ ⵙⵉⴷⴷⵉⵎ, ⴰⵇⴰ ⴷ ⵍⴻⴱⵃⴰⵔ ⴰⵎⴻⴵⴰⵃ. ");
INSERT INTO rift_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","ⵜⵓⵖⴰ ⵅⴻⴷⴷⵎⴻⵏ ⵜⴻⵏⵄⴰⵛ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵉ ⴽⵉⴷⵓⵔⵍⴰⵄⵓⵎⵉⵔ, ⵎⴰⵛⴰ ⵖⴰⵔ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵡⵉⵙⵙ ⵜⵍⴻⵟⵟⴰⵛ ⵖⴻⵡⵡⵖⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","ⵓⵛⴰ ⴷⴻⴳ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵡⵉⵙⵙ ⴰⵔⴱⴻⵄⵟⴰⵛ ⵢⵓⵙⴰ-ⴷⴷ ⴽⵉⴷⵓⵔⵍⴰⵄⵓⵎⵉⵔ ⴷ ⵉⵊⴻⴵⵉⴷⴻⵏ ⵉ ⵢⴻⴵⴰⵏ ⴰⴽⵉⴷⴻⵙ ⵓⵛⴰ ⵖⴻⵍⴱⴻⵏ ⵅ ⵉⵔⴰⴼⴰⵡⵉⵢⵢⴻⵏ ⴷⵉ ⴰⵛⵜⵉⵔⵓⵜ-ⵇⴰⵔⵏⴰⵢⵎ, ⵅ ⵉⵣⵓⵣⵉⵢⵢⴻⵏ ⴷⵉ ⵀⴰⵎ, ⵅ ⵉⵎⵉⵜⵉⵢⵢⴻⵏ ⴷⵉ ⵛⴰⵡⴰ-ⵇⴰⵔⵢⴰⵜⴰⵢⵉⵎ    ");
INSERT INTO rift_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ⵓ ⵅ ⵉⵅⵓⵔⵉⵢⵢⴻⵏ ⴷⴻⴳ ⵉⴷⵓⵔⴰⵔ ⵏⵙⴻⵏ ⵏ ⵙⴰⵄⵉⵔ ⴰⵍ ⴼⴰⵔⴰⵏ, ⵡⴻⵏⵏⵉ ⵉⴵⴰⵏ ⵣⵣⴰⵜ ⵉ ⵍⴻⵅⵍⴰ. ");
INSERT INTO rift_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","ⴰⵡⴰⵔⵏⵉ ⴰⵢⴰ ⴷⴻⵡⵍⴻⵏ-ⴷⴷ, ⵓⵙⵉⵏ-ⴷⴷ ⵖⴰⵔ ⵄⴰⵢⵏ-ⵎⵉⵛⴼⴰⵜ, ⵡⴻⵏⵏⵉ ⴷ ⵇⴰⴷⴰⵛ, ⵓⵛⴰ ⵖⴻⵍⴱⴻⵏ ⵅ ⵢⴻⵡⴷⴰⵏ ⵏⵏⵉ ⵉⵣⴻⴷⴷⵖⴻⵏ ⴷⵉ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⴰⵢⵜ ⵏ ⵄⴰⵎⴰⵍⵉⵇ ⵓ ⵄⴰⵡⴻⴷ ⵅ ⵉⵎⵓⵔⵉⵢⵢⴻⵏ ⵉⵏⵏⵉ ⵉⵣⴻⴷⴷⵖⴻⵏ ⴷⵉ ⵀⴰⵚⵚⵓⵏ-ⵜⴰⵎⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","ⵅⴻⵏⵏⵉ ⵉⴼⴼⴻⵖ ⵓⵊⴻⴵⵉⴷ ⵏ ⵙⴰⴷⵓⵎ ⴷ ⵓⵊⴻⴵⵉⴷ ⵏ ⵄⴰⵎⵓⵔⵔⴰ ⴷ ⵓⵊⴻⴵⵉⴷ ⵏ ⴰⴷⵎⴰ ⴷ ⵓⵊⴻⴵⵉⴷ ⵏ ⵚⴰⴱⵓⵢⵉⵎ ⴷ ⵓⵊⴻⴵⵉⴷ ⵏ ⴱⵉⵍⴰⵄ, ⴰⵇⴰ-ⵜⵜ ⴷ ⵚⵓⵖⴰⵔ. ⵔⵓⵃⴻⵏ ⵏⵉⵜⵏⵉ ⵖⴰⵔ ⵍⴻⵡⴹⴰ ⵏ ⵜⴻⵖⵣⵓⵔⵜ ⵏ ⵙⵉⴷⴷⵉⵎ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵎⵎⴻⵏⵖⴻⵏ ");
INSERT INTO rift_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","ⴰⴽ-ⴷ ⴽⵉⴷⵓⵔⵍⴰⵄⵓⵎⵉⵔ, ⴰⵊⴻⴵⵉⴷ ⵏ ⵄⵉⵍⴰⵎ ⴷ ⵜⵉⴷⵄⴰⵍ, ⴰⵊⴻⴵⵉⴷ ⵏ ⵍⴻⴳⵏⵓⵙ, ⴷ ⴰⵎⵔⴰⴼⵉⵍ, ⴰⵊⴻⴵⵉⴷ ⵏ ⵛⵉⵏⵄⴰⵔ, ⴷ ⴰⵔⵢⵓⴽ, ⴰⵊⴻⴵⵉⴷ ⵏ ⵉⵍⵍⴰⵙⴰⵔ: ⴰⵔⴻⴱⵄⴰ ⵏ ⵉⵊⴻⴵⵉⴷⴻⵏ ⴳⴳⵉⵏ ⵍⴱⴰⵔⵓⴹ ⴰⴽ-ⴷ ⵅⴻⵎⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","ⵜⵓⵖⴰ ⵍⴻⵡⴹⴰ ⵏ ⵜⴻⵖⵣⵓⵔⵜ ⵏ ⵙⵉⴷⴷⵉⵎ ⵜⴻⵛⵛⵓⵔ ⵙ ⵡⴰⵏⵓⵜⴻⵏ ⵏ ⵜⵉⵣⴻⴼⵜ. ⵓⵛⴰ ⴰⵔⴻⵡⵍⴻⵏ ⵉⵊⴻⴵⵉⴷⴻⵏ ⵏ ⵙⴰⴷⵓⵎ ⴷ ⵄⴰⵎⵓⵔⵔⴰ ⵓⵛⴰ ⵡⴹⴰⵏ ⴷⴰⵢⵙⴻⵏ, ⵓ ⵉⵏⵏⵉ ⵉⵇⵇⵉⵎⴻⵏ ⴰⵔⴻⵡⵍⴻⵏ ⵖⴰⵔ ⵉⴷⵓⵔⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","ⴽⵙⵉⵏ ⵎⴰⵔⵔⴰ ⴰⴳⵍⴰ ⵏ ⵙⴰⴷⵓⵎ ⴷ ⵄⴰⵎⵓⵔⵔⴰ ⴷ ⵎⴰⵔⵔⴰ ⵎⴰⵛⵛⴰ ⵉ ⵅⴻⵣⵏⴻⵏ ⵓⵛⴰ ⵓⵢⵓⵔⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","ⴽⵙⵉⵏ ⵄⴰⵡⴻⴷ ⵍⵓⵟ, ⵎⵎⵉⵙ ⵏ ⵓⵎⴰⵙ ⵏ ⴰⴱⵔⴰⵎ, ⴷ ⵡⴰⴳⵍⴰ ⵏⵏⴻⵙ ⵓⵛⴰ ⵔⵓⵃⴻⵏ. ⵏⴻⵜⵜⴰ ⵜⵓⵖⴰ ⵉⵣⴻⴷⴷⴻⵖ ⴷⵉ ⵙⴰⴷⵓⵎ. ");
INSERT INTO rift_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","ⵅⴻⵏⵏⵉ ⵢⵓⵙⴰ-ⴷⴷ ⵉⵊⵊⴻⵏ ⵣⴻⴳ ⵉⵏⵏⵉ ⵢⴰⵔⴻⵡⵍⴻⵏ, ⵉⵏⵏⴰ ⵎⴰⵏ ⴰⵢⴰ ⵉ ⴰⴱⵔⴰⵎ, ⴰⵄⵉⴱⵔⴰⵏⵉ, ⵡⴻⵏⵏⵉ ⵜⵓⵖⴰ ⵉⵣⴻⴷⴷⵖⴻⵏ ⵖⴰⵔ ⵜⵛⴻⵊⵊⵓⵔⴰ ⵏ ⵢⵉⴳⴳ ⵏ ⵎⴰⵎⵔⵉ, ⴰⵔⵢⴰⵣ ⴷ ⴰⵎⵓⵔⵉⵢ, ⵓⵎⴰⵙ ⵏ ⴰⵛⴽⵓⵍ ⴷ ⵄⴰⵏⵉⵔ. ⵏⵉⵜⵏⵉ ⴷ ⴰⵔⴼⵉⵇⴻⵏ ⴷⵉ ⵍⵄⴰⵀⴷ ⵏ ⴰⴱⵔⴰⵎ.    ");
INSERT INTO rift_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","ⵍⴰⵎⵉ ⵉⵙⵍⴰ ⴰⴱⵔⴰⵎ ⴱⴻⵍⵍⵉ ⵓⵎⴰⵙ ⵟⵟⴼⴻⵏ ⵜ ⴷ ⴰⵎⴻⵃⴱⵓⵙ, ⵢⵉⵡⵉ ⵉⵔⵢⴰⵣⴻⵏ ⵉⵏⵏⵉ ⵉⴷⴰⵔⵔⴱⴻⵏ ⵉ ⵓⵎⴻⵏⵖⵉ, ⵉⵏⵏⵉ ⴷⴷ-ⵉⵜⵜⵡⴰⵅⴻⵍⵇⴻⵏ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⴻⵙ, ⴷⵉ ⵜⴻⵍⵜ-ⵎⵢⴰ ⵓ-ⵜⵎⴻⵏⵟⴰⵛ, ⵓⵛⴰ ⵉⴹⴼⴰⵔ ⵉ-ⵜⴻⵏ ⴰⵍ ⴷⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","ⵙ ⴵⵉⵔⴻⵜ ⴱⴹⴰⵏ ⵅⴰⵙⴻⵏ ⵏⵉⵜⵏⵉ, ⴳⴳⵉⵏ ⵜⴻⵔⴼⵉⵇⵉⵏ, ⵏⴻⵜⵜⴰ ⴷ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵙ, ⵓⵛⴰ ⵉⵖⵍⴻⴱ ⵅⴰⵙⴻⵏ ⵓⵛⴰ ⵉⴹⴼⴰⵔ ⵉ-ⵜⴻⵏ ⵖⴰⵔ ⵜⴻⵏⴷⵉⵏⵜ ⵏ ⵃⵓⴱⴰ, ⵜⴻⵏⵏⵉ ⵉⴵⴰⵏ ⵅ ⵓⵣⴻⵍⵎⴰⴹ ⵏ ⴷⵉⵎⴰⵛⵇ. ");
INSERT INTO rift_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","ⵢⴰⵔⵔⴰ-ⴷⴷ ⵎⴰⵔⵔⴰ ⴰⴳⵍⴰ ⵓⵍⴰ ⴷ ⵓⵎⴰⵙ ⵍⵓⵟ ⴷ ⵡⴰⴳⵍⴰ ⵏⵏⴻⵙ ⵓⵍⴰ ⴷ ⵜⵉⵎⵖⴰⵔⵉⵏ ⴷ ⵍⴳⴻⵏⵙ. ");
INSERT INTO rift_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","ⵓⵎⵉ ⴷⴷ-ⵉⵄⵇⴻⴱ, ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⵉⵖⵍⴻⴱ ⵏⴻⵜⵜⴰ ⵅ ⴽⵉⴷⵓⵔⵍⴰⵄⵓⵎⵉⵔ ⵓ ⵅ ⵉⵊⴻⴵⵉⴷⴻⵏ ⵏⵏⵉ ⵜⵓⵖⴰ ⴰⴽⵉⴷⴻⵙ, ⵉⴼⴼⴻⵖ ⵓⵊⴻⴵⵉⴷ ⵏ ⵙⴰⴷⵓⵎ ⵃⵉⵎⴰ ⴰⴷ ⵜ ⵉⵍⵇⴰ ⴷⵉ ⵍⴻⵡⴹⴰ ⵏ ⵜⴻⵖⵣⵓⵔⵜ ⵏ ⵛⴰⵡⴰ, ⵜⴻⵏⵏⵉ ⵉⴵⴰⵏ ⴷ ⵜⴰⵖⵣⵓⵔⵜ ⵏ ⵓⵊⴻⴵⵉⴷ. ");
INSERT INTO rift_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","ⵓ ⵎⴰⵍⴽⵉⵚⴰⴷⵉⵇ, ⴰⵊⴻⴵⵉⴷ ⵏ ⵛⴰⵍⵉⵎ, ⵢⵉⵡⵉ-ⴷⴷ ⴰⵖⵔⵓⵎ ⴷ ⴱⵉⵏⵓ. ⵏⴻⵜⵜⴰ ⵜⵓⵖⴰ ⴷ ⴰⴽⴻⵀⵀⴰⵏ ⵏ ⴰⵔⴻⴱⴱⵉ, ⴰⵎⵄⵓⴵⵉ ⵅ ⴽⵓⵍⵛⵉ.    ");
INSERT INTO rift_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","ⵉⴱⴰⵔⴽ ⵉ-ⵜ, ⵉⵏⵏⴰ ⴰⵙ: “ⴰⴷ ⵉⵜⵜⵡⴰⴱⴰⵔⴻⴽ ⴰⴱⵔⴰⵎ ⵣⵉ ⴰⵔⴻⴱⴱⵉ, ⴰⵎⵄⵓⴵⵉ ⵅ ⴽⵓⵍⵛⵉ, ⵡⴻⵏⵏⵉ ⵉⴳⴳⵉⵏ ⵉⵊⴻⵏⵡⴰⵏ ⴷ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","ⴰⴷ ⵉⵜⵜⵡⴰⴱⴰⵔⴻⴽ ⴰⵔⴻⴱⴱⵉ, ⴰⵎⵄⵓⴵⵉ ⵅ ⴽⵓⵍⵛⵉ, ⵡⴻⵏⵏⵉ ⵉⵙⴻⵍⵍⵎⴻⵏ ⵉⵖⵔⵉⵎⴻⵏ ⵏⵏⴻⵛ ⴷⴻⴳ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵏⴻⵛ!” ⵓⵛⴰ ⴰⴱⵔⴰⵎ ⵉⵡⵛⴰ ⴰⵙ ⵍⴻⵄⵛⵓⵔ ⵏ ⵎⴰⵔⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","ⵓⵛⴰ ⵉⵏⵏⴰ ⵓⵊⴻⴵⵉⴷ ⵏ ⵙⴰⴷⵓⵎ ⵉ ⴰⴱⵔⴰⵎ: “ⴻⵡⵛ ⴰⵢⵉ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⴷⴷⴰⵔⴻⵏ, ⵎⴰⵛⴰ ⴽⵙⵉ ⴰⴳⵍⴰ ⵉ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵛ.” ");
INSERT INTO rift_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","ⵎⴰⵛⴰ ⴰⴱⵔⴰⵎ ⵢⴰⵔⵔⴰ-ⴷⴷ ⵅ ⵓⵊⴻⴵⵉⴷ ⵏ ⵙⴰⴷⵓⵎ: “ⴰⵇⴰ ⵙⵙⴳⴻⵄⵄⴷⴻⵖ ⴰⴼⵓⵙ ⵉⵏⵓ ⵖⴰⵔ ⵙⵉⴷⵉ ⴰⵔⴻⴱⴱⵉ, ⴰⵎⵄⵓⴵⵉ ⵅ ⴽⵓⵍⵛⵉ, ⵡⴻⵏⵏⵉ ⵉⴳⴳⵉⵏ ⴰⵊⴻⵏⵏⴰ ⴷ ⵜⴻⵎⵎⵓⵔⵜ, ⵊⵊⵓⴵⴻⵖ ");
INSERT INTO rift_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ⵎⴰⵃⴻⵏⴷ ⵡⴰⵔ ⴽⴻⵙⵙⵉⵖ ⴰⴼⵉⵍⵓ ⵏⵉⵖ ⵜⴰⵃⴻⵣⵣⴻⵎⵜ ⵏ ⵙⴰⵏⴷⴰⵍⵉⵢⴰⵜ ⵓⵍⴰ ⵛⴰ ⵏ ⵍⵃⴰⵊⵊⴻⵜ ⵣⵉ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⴵⴰⵏ ⵏⵏⴻⵛ, ⵃⵉⵎⴰ ⵡⴰⵔ ⵜⴻⵇⵇⴰⵔⴻⴷ: ‘ⵏⴻⵛⵛ ⵙⵙⵜⴻⵊⵊⴰⵔⴻⵖ ⴰⴱⵔⴰⵎ!’ ");
INSERT INTO rift_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","ⵡⴰⵔ ⵖⴰⵔⵉ ⴷⴰⵢⴻⵙ ⴱⵓ ⵜⴰⵙⵖⴰⵔⵜ! ⵎⵖⵉⵔ ⵎⵉⵏ ⵛⵛⵉⵏ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⴷ ⵜⴻⵙⵖⴰⵔⵜ ⵏ ⵉⵔⵢⴰⵣⴻⵏ ⵏⵏⵉ ⴽⵉⴷⵉ ⵉⵔⵓⵃⴻⵏ, ⴰⵏⵉⵔ ⴷ ⵉⵛⴽⵓⵍ ⴷ ⵎⴰⵎⵔⵉ, ⴻⵊⵊ ⵉ-ⵜⴻⵏ ⴰⴷ ⴽⵙⵉⵏ ⵜⴰⵙⵖⴰⵔⵜ ⵏⵙⴻⵏ!” ");
INSERT INTO rift_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","ⴰⵡⴰⵔⵏⵉ ⵎⴰⵏ ⴰⵢⴰ ⵢⵓⵙⴰ-ⴷⴷ ⵡⴰⵡⴰⵍ ⵏ ⵙⵉⴷⵉ ⵖⴰⵔ ⴰⴱⵔⴰⵎ ⴷⴻⴳ ⵉⵊⵊ ⵏ ⵍⴻⵡⵃⵉⵢ. ⵉⵏⵏⴰ ⴰⵙ “ⵡⴰⵔ ⵜⵜⴻⴳⴳⵯⴻⴷ ⵛⴰ, ⴰⴱⵔⴰⵎ, ⵏⴻⵛⵛ ⴷ ⴰⵙⴻⵍⵇⵉ ⵉ ⵛⴻⴽ, ⵍⵎⵓⵏⴻⵜ ⵏⵏⴻⵛ ⵜⴻⵎⵖⴰⵔ ⴰⵟⵟⴰⵙ ⴷ ⵏⴻⵛⵛ.” ");
INSERT INTO rift_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","ⵓⵛⴰ ⵉⵏⵏⴰ ⴰⴱⵔⴰⵎ: “ⵙⵉⴷⵉ ⵉⵏⵓ, ⵙⵉⴷⵉ, ⵎⵉⵏ ⴷ ⴰⵢⵉ ⵖⴰ ⵜⴻⵡⵛⴻⴷ, ⵎⴰⵖⴰⵔ ⵏⴻⵛⵛ ⴰⴷ ⵔⴰⵃⴻⵖ ⴰⵎⵎⵓ ⴱⵍⴰ ⵎⵎⵉ ⵓ ⴰⵍⵉⵄⴰⵣⵉⵔ ⵣⵉ ⴷⵉⵎⴰⵛⵇ ⴰⴷ ⵢⵉⵍⵉ ⴰⵎⴻⵛⵏⴰⵡ ⵎⵎⵉ ⵅ ⵡⴰⴳⵍⴰ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵉⵏⵓ?” ");
INSERT INTO rift_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","ⵉⵏⵏⴰ ⴰⴱⵔⴰⵎ ⵄⴰⵡⴻⴷ: “ⵅⵣⴰⵔ, ⵡⴰⵔ ⴷ ⴰⵢⵉ ⵜⴻⵡⵛⵉⴷ ⵣⵣⴰⵔⵉⵄⴻⵜ, ⵙ ⵓⵢⴻⵏⵏⵉ, ⵡⴻⵏⵏⵉ ⵉⴵⴰⵏ ⴰⵎ ⵎⵎⵉ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵉⵏⵓ, ⴰⴷ ⵢⵉⵍⵉ ⴷ ⴰⵡⵔⵉⵜ ⵉⵏⵓ!” ");
INSERT INTO rift_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","ⵓⵛⴰ ⵅⵣⴰⵔ, ⴰⵡⴰⵍ ⵏ ⵙⵉⴷⵉ ⵢⵓⵙⴰ-ⴷⴷ ⵖⴰⵔⴻⵙ, ⵉⵏⵏⴰ: “ⵡⴰⵔ ⵛⴻⴽ ⵉⵡⴰⵔⵔⴻⵜ ⵛⴰ ⵡⴰ, ⵎⴰⵛⴰ ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵉⴼⴼⵖⴻⵏ ⵣⵣⴰⵢⴻⴽ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⴰⵡⵔⵉⵜ ⵏⵏⴻⵛ.” ");
INSERT INTO rift_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","ⵉⵙⵙⵓⴼⴼⴻⵖ ⵉ-ⵜ ⵖⴰⵔ ⴱⴰⵔⵔⴰ, ⵉⵏⵏⴰ: “ⵅⵣⴰⵔ ⵖⴰⵔ ⵓⵊⴻⵏⵏⴰ, ⵜⵃⴻⵙⴱⴻⴷ ⵉⵜⵔⴰⵏ, ⵎⴰⵍⴰ ⵜⵣⴻⵎⵎⴰⵔⴻⴷ ⴰⴷ ⵜⴻⵏ ⵜⵃⴻⵙⴱⴻⴷ!” ⵓⵛⴰ ⵉⵏⵏⴰ ⴰⵙ: “ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵜⵉⵍⵉ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵛ!” ");
INSERT INTO rift_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵢⵓⵎⴻⵏ ⴷⵉ ⵙⵉⴷⵉ ⵓⵛⴰ ⵉⵃⵙⴻⴱ ⴰⵙ ⵜ-ⵉ-ⴷⴷ ⴷ ⵜⴰⵙⴻⴳⴷⴰ.    ");
INSERT INTO rift_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","ⵉⵏⵏⴰ ⴰⵙ ⵄⴰⵡⴻⴷ: “ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⵡⴻⵏⵏⵉ ⵛⴻⴽ ⴷⴷ-ⵢⵉⵡⵢⴻⵏ ⵣⵉ ⵓⵔ ⵏ ⵉⴽⴰⵍⴷⴰⵏⵉⵢⵢⴻⵏ, ⵃⵉⵎⴰ ⴰⴷ ⴰⵛ ⵡⵛⴻⵖ ⵜⴰⵎⵎⵓⵔⵜ-ⴰ ⴷ ⵍⵡⴰⵔⵜ.” ");
INSERT INTO rift_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","ⵅⴻⵏⵏⵉ ⵏⴻⵜⵜⴰ ⵉⵏⵏⴰ: “ⴰ ⵙⵉⴷⵉ ⵉⵏⵓ, ⵙⵉⴷⵉ, ⵙ ⵎⵉⵏⵣⵉ ⵉ ⵖⴰ ⵙⵙⵏⴻⵖ, ⴱⴻⵍⵍⵉ ⴰⴷ ⵜⵜ ⵡⴰⵔⵜⴻⵖ?” ");
INSERT INTO rift_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","ⵉⵏⵏⴰ ⴰⵙ ⵏⴻⵜⵜⴰ: “ⴰⵡⵉ ⴰⵢⵉ-ⴷⴷ ⵉⵛⵜ ⵏ ⵜⵄⴻⵊⵎⵉⵜ ⵏ ⵜⵍⴰⵜⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⴷ ⵉⵊⵊ ⵏ ⵉⵖⴰⵢⴹ ⵏ ⵜⵍⴰⵜⴰ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⴷ ⵉⵊⵊ ⵏ ⵉⵛⴰⵔⵔⵉ ⵏ ⵜⵍⴰⵜⴰ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵊⵍⵉⵍⵍⴻⵃⵜ ⴷ ⵉⵊⵊ ⵏ ⵡⴻⴷⴱⵉⵔ ⴷ ⴰⵎⴻⵥⵢⴰⵏ.” ");
INSERT INTO rift_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","ⵏⴻⵜⵜⴰ ⵢⵉⵡⵉ-ⴷⴷ ⵖⴰⵔⴻⵙ ⵎⴰⵔⵔⴰ ⵎⴰⵏ ⴰⵢⴰ, ⵉⴱⴹⴰ ⵜⴻⵏ ⵅ ⵡⴻⵣⵢⴻⵏ ⵓ ⵉⴳⴳⴰ ⴽⵓⵍ ⴰⵣⵢⴻⵏ ⵇⵉⴱⴰⵍⵜ ⵉ ⵡⴻⵏⵏⴻⵖⵏⵉ, ⵎⴰⵛⴰ ⵡⴰⵔ ⵉⴱⴹⵉ ⵛⴰ ⵉⵊⴹⴰⴹ. ");
INSERT INTO rift_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","ⵀⵡⴰⵏ-ⴷⴷ ⵉⵊⴹⴰⴹ ⵉⵜⵜⴽⴻⵛⵛⴰⴹⴻⵏ ⵅ ⵉⵎⵓⵔⴹⴰⵙ, ⵎⴰⵛⴰ ⴰⴱⵔⴰⵎ ⵢⵓⵥⵥⴻⵍ ⵅⴰⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","ⵖⴰⵔ ⵓⵖⴻⴵⴰⵢ ⵏ ⵜⴼⵓⵛⵜ, ⵉⵎⵙⴰⵔ ⴰⵇⴰ ⵢⵓⵙⴰ ⴰⵙ-ⴷⴷ ⵉ ⴰⴱⵔⴰⵎ ⵉⵊⵊ ⵏ ⵢⵉⴹⴻⵚ ⵢⵓⴵⴻⵖ, ⵓⵛⴰ ⵅⵣⴰⵔ, ⵜⵉⴳⴳⵯⵓⴷⵉ ⴷ ⵜⴰⴵⴻⵙⵜ ⵉⵃⴻⴷⵇⴻⵏ ⵡⴹⴰⵏ-ⴷⴷ ⵅⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵉ ⴰⴱⵔⴰⵎ: “ⵙⵙⴻⵏ ⵙ ⵜⵉⴷⴻⵜⵜ ⴰⵇⴰ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵛ ⴰⴷ ⵜⵉⵍⵉ ⴷ ⵜⴰⴱⴰⵔⵔⴰⵏⴻⵛⵜ ⴷⴻⴳ ⵉⵛⵜ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵉ ⵡⴰⵔ ⵉⴵⵉⵏ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⴰⵙⴻⵏ ⵅⴻⴷⵎⴻⵏ ⴰⵎ ⵉⵙⴻⵎⵖⴰⵏ ⵓ ⵏⵉⵜⵏⵉ ⴰⴷ ⵅⴰⵙⴻⵏ ⴳⴳⴻⵏ ⴰⵖⵉⵍ ⴰⵔⴻⴱⵄⴰ-ⵎⵢⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","ⵎⴰⵛⴰ ⵍⴳⴻⵏⵙ ⵓⵎⵉ ⵖⴰ ⵅⴻⴷⵎⴻⵏ ⴰⵎ ⵉⵙⴻⵎⵖⴰⵏ, ⴰⴷ ⵅⴰⵙⴻⵏ ⵃⴻⴽⵎⴻⵖ ⵄⴰⵡⴻⴷ, ⵓⵛⴰ ⴰⵡⴰⵔⵏⵉ ⵎⴰⵏ ⴰⵢⴰ ⴰⴷ ⴼⴼⵖⴻⵏ ⵙ ⵡⴰⴳⵍⴰ ⵉⵎⵖⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","ⴰⴷ ⵜᵉⵜⵜⵡⴰⵙⵙⵎⵓⵏⴻⴷ ⵖⴰⵔ ⵍⴻⵊⴷⵓⴷ ⵏⵏⴻⵛ ⵙ ⵍⴻⵀⵏⴰ ⵓⵛⴰ ⴰⴷ ⵛⴻⴽ ⵏⴻⴹⵍⴻⵏ ⴰⵎ ⵓⵎⴻⵛⵛⴰⵢⴱⵓ ⵉⵡⴻⵇⵇⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","ⵊⵊⵉⵍ ⵡⵉⵙⵙ ⴰⵔⴻⴱⵄⴰ ⴰⴷ ⴷⴷ-ⵉⵄⵇⴻⴱ ⴷⴰⵏⵉⵜⴰ, ⵎⵉⵏⵣⵉ ⵍⵇⴻⴷⴷ ⵏ ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ ⵏ ⵉⵎⵓⵔⵉⵢⵢⴻⵏ ⵄⴰⴷ ⵡⴰⵔ ⵉⴽⴻⵎⵎⴻⵍ.” ");
INSERT INTO rift_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","ⵍⴰⵎⵉ ⵜⴻⵖⵍⵉ ⵜⴼⵓⵛⵜ ⵓⵛⴰ ⵜⴻⴷⵡⴻⵍ ⴷ ⵜⴰⴵⴻⵙⵜ, ⵜⵓⵖⴰ ⴷⵉⵏ ⴰⴼⴰⵔⵔⴰⵏ ⵉⴷⴷⴻⵅⵅⵏⴻⵏ ⵓ ⵉⵄⴷⵓ ⵉⵊⵊ ⵏ ⵡⴻⵚⴼⴻⴹ ⵏ ⵜⵎⴻⵙⵙⵉ ⵊⴰⵔ ⵉⵣⴻⵢⵏⴰⵏ ⵏⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","ⴷⴻⴳ ⵡⴰⵙⵙ ⵏⵏⵉ ⵏⵏⵉⵜ ⵉⴳⴳⴰ ⵙⵉⴷⵉ ⵉⵊⵊ ⵏ ⵍⵄⴰⵀⴷ ⴰⴽ-ⴷ ⴰⴱⵔⴰⵎ, ⵉⵏⵏⴰ: “ⵉ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵛ ⵓⵎⵉ ⵡⵛⵉⵖ ⵜⴰⵎⵎⵓⵔⵜ-ⴰ ⵣⴻⴳ ⵉⵖⵣⴰⵔ ⵏ ⵎⵉⵚⵔⴰ ⴰⵍ ⵉⵖⵣⴰⵔ ⴰⵎⴻⵇⵇⵔⴰⵏ, ⵉⵖⵣⴰⵔ ⵏ ⵍⴼⵓⵔⴰⵟ: ");
INSERT INTO rift_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵉⵇⵉⵏⵉⵢⵢⴻⵏ, ⵉⵇⴻⵏⵉⵣⵉⵢⵢⴻⵏ, ⵉⵇⴰⴷⵎⵉⵢⵢⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ⵉⵃⵉⵜⵜⵉⵢⵢⴻⵏ, ⵉⴼⵉⵔⵣⵉⵢⵢⴻⵏ, ⵉⵔⴰⴼⴰⵡⵉⵢⵢⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ⵉⵎⵓⵔⵉⵢⵢⴻⵏ, ⴰⵢⵜ ⵏ ⴽⴻⵏⵄⴰⵏ, ⵉⴳⵉⵔⴳⴰⵛⵉⵢⵢⴻⵏ ⴷ ⵉⵢⵉⴱⵓⵙⵉⵢⵢⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","ⵙⴰⵔⴰⵢ, ⵜⴰⵎⵖⴰⵔⵜ ⵏ ⴰⴱⵔⴰⵎ, ⵡⴰⵔ ⴷ ⴰⵙ ⴷⴷ-ⵜⵉⵔⵓⵡ ⵛⴰ. ⵜⵓⵖⴰ ⵖⴰⵔⴻⵙ ⵉⵛⵜ ⵏ ⵜⴰⵢⵢⴰ ⵣⵉ ⵎⵉⵚⵔⴰ ⵇⵇⴰⵔⴻⵏⵜ ⴰⵙ ⵀⴰⵊⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","ⵜⴻⵏⵏⴰ ⵙⴰⵔⴰⵢ ⵉ ⴰⴱⵔⴰⵎ: “ⴰⵇⴰ ⵜⴻⵥⵔⵉⴷ ⴱⴻⵍⵍⵉ ⵙⵉⴷⵉ ⵉⵟⵟⴻⴼ ⵅⴰⴼⵉ ⵜⴰⵔⵡⴰ. ⴰⴷⴻⴼ ⵅ ⵜⴰⵢⵢⴰ ⵉⵏⵓ, ⴱⴰⵍⴰⴽ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⴽⵙⵉⵖ ⵜⴰⵔⵡⴰ.” ⴰⴱⵔⴰⵎ ⵜⵓⵖⴰ ⵉⵙⵙⵃⴻⵙⵙⴰ ⵖⴰⵔ ⵙⴰⵔⴰⵢ. ");
INSERT INTO rift_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⵉⵣⴷⴻⵖ ⴰⴱⵔⴰⵎ ⵄⴻⵛⵔⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ, ⵜⵉⵡⵉ-ⴷⴷ ⵙⴰⵔⴰⵢ, ⵜⴰⵎⵖⴰⵔⵜ ⵏ ⴰⴱⵔⴰⵎ, ⵜⴰⵢⵢⴰ ⵏⵏⴻⵙ ⵀⴰⵊⴰⵔ, ⵜⴻⵏⵏⵉ ⵣⵉ ⵎⵉⵚⵔⴰ, ⵓⵛⴰ ⵜⴻⵡⵛⴰ ⴰⵙ-ⴷⴷ ⵉ ⴰⴱⵔⴰⵎ, ⴰⵔⵢⴰⵣ ⵏⵏⴻⵙ, ⴷ ⵜⴰⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","ⵢⵓⴷⴻⴼ ⵅ ⵀⴰⵊⴰⵔ ⵓⵛⴰ ⵏⴻⵜⵜⴰⵜ ⵜⴻⴽⵙⵉ ⴷⴷⴻⵢⵙⴻⵜ. ⵓⵎⵉ ⵜⴻⵥⵔⴰ ⴱⴻⵍⵍⵉ ⵜⴻⴽⵙⵉ ⴷⴷⴻⵢⵙⴻⵜ, ⵅⴻⵏⵏⵉ ⵜⴻⴷⵡⴻⵍ ⵍⴰⵍⵍⴰⵙ ⵜᵉⵜⵜⵡⴰⵙⵙⴻⵃⵇⴰⵔ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","ⵜⴻⵏⵏⴰ ⵙⴰⵔⴰⵢ ⵉ ⴰⴱⵔⴰⵎ: “ⵣⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏⵏⴻⵛ ⴳⴳⵉⵏ ⴷⴰⵢⵉ ⵍⵎⵓⵏⴽⴰⵔ. ⵏⴻⵛⵛ ⴳⴳⵉⵖ ⵜⴰⵢⵢⴰ ⵉⵏⵓ ⴷⴻⴳ ⵡⴻⵃⵙⵉⵏ ⵏⵏⴻⵛ. ⵓⵎⵉ ⵜⴻⵥⵔⴰ ⴱⴻⵍⵍⵉ ⵜⴻⴽⵙⵉ ⴷⴷⴻⵢⵙⴻⵜ, ⴷⴻⵡⵍⴻⵖ ⴷ ⵜⴰⵎⴻⵃⴳⵓⵔⴻⵜ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵙ. ⴻⵊⵊ ⴰⴷ ⵉⵃⴽⴻⵎ ⵙⵉⴷⵉ ⵊⴰⵔ ⴰⵢⵉ ⴷ ⵛⴻⴽ!” ");
INSERT INTO rift_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","ⵉⵏⵏⴰ ⴰⴱⵔⴰⵎ ⵉ ⵙⴰⵔⴰⵢ: “ⵅⵣⴰⵔ, ⵜⴰⵢⵢⴰ ⵏⵏⴻⵎ ⴷⴻⴳ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵏⴻⵎ. ⴻⴳⴳ ⵣⵣⴰⵢⴻⵙ ⵎⵉⵏ ⵜᵉⵜⵜⵡⴰⵍⵉⴷ ⵛⴻⵎ ⵎⵍⵉⵃ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵎ.” ⵓⵛⴰ ⵙⴰⵔⴰⵢ ⵜⵇⴻⵎⵎⴻⵄ ⵉ-ⵜⵜ ⵓ ⵅⴻⵏⵏⵉ ⵏⴻⵜⵜⴰⵜ ⵜⴰⵔⵡⴻⵍ ⵣⵣⴰⵢⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","ⵓⵛⴰ ⵍⵎⴰⵍⴰⴽ ⵏ ⵙⵉⴷⵉ ⵉⵍⵇⴰ ⵉ-ⵜⵜ ⵖⴰⵔ ⵜⴰⵍⴰ ⵏ ⵡⴰⵎⴰⵏ ⴷⵉ ⵍⴻⵅⵍⴰ, ⵖⴰⵔ ⵜⴰⵍⴰ ⴷⴻⴳ ⵡⴻⴱⵔⵉⴷ ⵉⵜⵜⴰⵡⵢⴻⵏ ⵖⴰⵔ ⵛⵓⵔ. ");
INSERT INTO rift_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","ⵉⵏⵏⴰ: “ⵀⴰⵊⴰⵔ, ⵜⴰⵢⵢⴰ ⵏ ⵙⴰⵔⴰⵢ, ⵎⴰⵏⵉⵙ ⴷⴷ-ⵜⵓⵙⵉⴷ ⵓ ⵎⴰⵏⵉ ⵖⴰ ⵜⵔⴰⵃⴻⴷ?” ⵏⴻⵜⵜⴰⵜ ⵜⴻⵏⵏⴰ: “ⵜⵜⵔⴰⴽⴽⵡⴰⵍⴻⵖ ⵣⴻⴳ ⵡⵓⴷⴻⵎ ⵏ ⵍⴰⵍⵍⴰ ⵙⴰⵔⴰⵢ!” ");
INSERT INTO rift_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⴰⵙ ⵍⵎⴰⵍⴰⴽ ⵏ ⵙⵉⴷⵉ: “ⴷⵡⴻⵍ ⵖⴰⵔ ⵍⴰⵍⵍⴰⵎ, ⵓⴹⴰⵔ ⵙⴰⴷⵓ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵏⴻⵙ.” ");
INSERT INTO rift_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","ⵉⵏⵏⴰ ⴰⵙ ⵄⴰⵡⴻⴷ ⵍⵎⴰⵍⴰⴽ ⵏ ⵙⵉⴷⵉ: “ⴰⴷ ⴽⴻⵜⵜⴰⵔⴻⵖ ⴰⵟⵟⴰⵙ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵎ, ⴰⵍ ⵡⴰⵔ ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵜᵉⵜⵜⵡⴰⵃⵙⴻⴱ ⵍⴰⵎⵉ ⵉ ⵖⴰ ⵜⵉⵍⵉ ⴷⴻⴳ ⵡⴰⵟⵟⴰⵙ.” ");
INSERT INTO rift_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","ⵉⵏⵏⴰ ⴰⵙ ⵍⵎⴰⵍⴰⴽ ⵏ ⵙⵉⴷⵉ ⵄⴰⵡⴻⴷ: “ⴰⵇⴰ ⵍⴻⵅⵅⵓ, ⵜⴻⴽⵙⵉⴷ ⴷⴷⴻⵢⵙⴻⵜ ⵓⵛⴰ ⴰⴷ ⵜⴰⵔⵡⴻⴷ ⴰⵙⴻⵢⵎⵉ. ⴰⴷ ⴰⵙ ⵜⴻⴳⴳⴻⴷ ⵉⵙⵎⴰⵄⵉⵍ, ⵎⵉⵏⵣⵉ ⵙⵉⴷⵉ ⵉⵙⵍⴰ ⴰⵎ ⴷⵉ ⵍⴻⵎⵃⴰⵢⴻⵏ ⵏⵏⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵉⵊⵊ ⵏ ⴱⵏⴰⴷⴻⵎ ⴰⵎⴻⵛⵏⴰⵡ ⴰⵙⵏⵓⵙ ⵏ ⵍⴻⵅⵍⴰ. ⴰⴼⵓⵙ ⵏⵏⴻⵙ ⴰⴷ ⵢⵉⵍⵉ ⵅ ⵎⴰⵔⵔⴰ, ⵓ ⴰⴼⵓⵙ ⵏ ⵎⴰⵔⵔⴰ ⴰⴷ ⵢⵉⵍⵉ ⵅⴰⵙ. ⴰⴷ ⵉⵣⴷⴻⵖ ⴰⵔⴻⵏⴷⴰⴷ ⵏ ⵎⴰⵔⵔⴰ ⴰⵢⵜⵎⴰⵙ.” ");
INSERT INTO rift_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","ⵓ ⵏⴻⵜⵜⴰⵜ ⵜⵍⴰⵖⴰ ⵅ ⵢⵉⵙⴻⵎ ⵏ ⵙⵉⴷⵉ ⵉ ⵖⴰⵔⴻⵙ-ⴷⴷ ⵉⵙⵙⵉⵡⵍⴻⵏ, ⵜⴻⵏⵏⴰ: “ⵛⴻⴽ ⴷ ⴰⵔⴻⴱⴱⵉ ⵉ ⵉⵜⵜⵡⴰⵍⴰⵏ!”, ⵎⵉⵏⵣⵉ ⵜⴻⵏⵏⴰ: “ⵎⴰ ⵡⴰⵔ ⴷⴰ ⵥⵔⵉⵖ ⵡⴻⵏⵏⵉ ⴷ ⴰⵢⵉ ⵉⵜⵜⵡⴰⵍⴰⵏ?” ");
INSERT INTO rift_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","ⵅ ⵓⵢⴰ ⵙⴻⵎⵎⴰⵏ ⴰⵏⵓ ⵏⵏⵉ: ⴰⵏⵓ ‘ⵍⴰⵃⴰⵢ-ⵔⵓ’ⵉ’. ⵅⵣⴰⵔ, ⴰⵇⴰ-ⵜ ⵊⴰⵔ ⵇⴰⴷⴰⵛ ⴷ ⴱⴰⵔⴰⴷ.    ");
INSERT INTO rift_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","ⵓⵛⴰ ⵜⵓⵔⵓⵡ-ⴷⴷ ⵀⴰⵊⴰⵔ ⵉ ⴰⴱⵔⴰⵎ ⴰⵙⴻⵢⵎⵉ. ⵉⴳⴳⴰ ⴰⵙ ⴰⴱⵔⴰⵎ ⵉⵙⴻⵎ ⵏ ⵎⵎⵉⵙ ⵏⵏⵉ ⵉ ⴷ ⴰⵙ ⴷⴷ-ⵜⵓⵔⵓⵡ ⵀⴰⵊⴰⵔ ‘ⵉⵙⵎⴰⵄⵉⵍ’. ");
INSERT INTO rift_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","ⴰⴱⵔⴰⵎ ⵜⵓⵖⴰ ⵖⴰⵔⴻⵙ ⵙⴻⵜⵜⴰ ⵓ-ⵜⵎⴰⵏⵢⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵓⵎⵉ ⴷⴷ-ⵜⵓⵔⵓⵡ ⵀⴰⵊⴰⵔ ⵉⵙⵎⴰⵄⵉⵍ ⵉ ⴰⴱⵔⴰⵎ. ");
INSERT INTO rift_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","ⵍⴰⵎⵉ ⵜⵓⵖⴰ ⵖⴰⵔⴻⵙ ⵖⴰⵔ ⴰⴱⵔⴰⵎ ⵜⴻⵙⵄⴰ ⵓ-ⵜⴻⵙⵄⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵉⴱⴰⵏ ⴰⵙ-ⴷⴷ ⵙⵉⴷⵉ ⵉ ⴰⴱⵔⴰⵎ, ⵉⵏⵏⴰ ⴰⵙ: “ⵏⴻⵛⵛ ⴷ ⴰⵔⴻⴱⴱⵉ ⴰⵎⵣⴻⵎⵎⴰⵔ ⵅ ⴽⵓⵍⵛⵉ! ⵓⵢⵓⵔ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵉⵏⵓ ⵓⵛⴰ ⵉⵍⵉ ⴷ ⴱⵏⴰⴷⴻⵎ ⵉⴽⴻⵎⵎⵍⴻⵏ!    ");
INSERT INTO rift_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","ⵏⴻⵛⵛ ⴰⴷ ⴳⴳⴻⵖ ⵍⵄⴰⵀⴷ ⵉⵏⵓ ⵊⴰⵔ ⴰⵢⵉ ⴷ ⵛⴻⴽ ⵓⵛⴰ ⴰⴷ ⵛⴻⴽ ⵙⵙⴽⴻⵜⵜⴰⵔⴻⵖ ⵙ ⵢⵉⵊⵊ ⵏ ⵛⵛⴽⴻⵍ ⵉⵎⵖⴰⵔ.” ");
INSERT INTO rift_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","ⵅⴻⵏⵏⵉ ⵉⵡⴹⴰ ⴰⴱⵔⴰⵎ ⵅ ⵓⵖⴻⵎⴱⵓⴱ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⵙⵙⵉⵡⴻⵍ ⴰⵔⴻⴱⴱⵉ ⴰⴽⵉⴷⴻⵙ, ⵉⵏⵏⴰ ⴰⵙ: ");
INSERT INTO rift_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“ⵅⵣⴰⵔ, ⵏⴻⵛⵛ ⴰⴷ ⴳⴳⴻⵖ ⵍⵄⴰⵀⴷ ⵉⵏⵓ ⴰⴽⵉⴷⴻⴽ ⵓⵛⴰ ⵛⴻⴽ ⴰⴷ ⵜⵉⵍⵉⴷ ⴷ ⴱⴰⴱⴰⵜⵙⴻⵏ ⵏ ⵡⴰⵟⵟⴰⵙ ⵏ ⵍⴻⴳⵏⵓⵙ. ");
INSERT INTO rift_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","ⵡⴰⵔ ⵉⵜⵜⵉⵍⵉ ⵉⵙⴻⵎ ⵏⵏⴻⵛ ⵄⴰⴷ ‘ⴰⴱⵔⴰⵎ’ ⵎⴰⵛⴰ ‘ⵉⴱⵔⴰⵀⵉⵎ’, ⵎⵉⵏⵣⵉ ⵏⴻⵛⵛ ⴳⴳⵉⵖ ⵛⴻⴽ ⴷ ⴱⴰⴱⴰⵜⵙⴻⵏ ⵏ ⵡⴰⵟⵟⴰⵙ ⵏ ⵍⴻⴳⵏⵓⵙ. ");
INSERT INTO rift_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","ⵓⵛⴰ ⵏⴻⵛⵛ ⴰⴷ ⵛⴻⴽ ⴰⵔⵔⴻⵖ ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵍⵖⵉⴵⴻⵜ ⴰⵟⵟⴰⵙ ⵙ ⵡⴰⵟⵟⴰⵙ ⵓ ⴰⴷ ⵛⴻⴽ ⴰⵔⵔⴻⵖ ⴷ ⵍⴻⴳⵏⵓⵙ, ⵓⵛⴰ ⵉⵊⴻⴵⵉⴷⴻⵏ ⴰⴷ ⵣⵣⴰⵢⴻⴽ ⴷⴷ-ⴼⴼⵖⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","ⴰⴷ ⴳⴳⴻⵖ ⵍⵄⴰⵀⴷ ⵉⵏⵓ ⵊⴰⵔ ⴰⵢⵉ ⴷ ⵛⴻⴽ ⴷ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵛ ⴰⵡⴰⵔⵏⵉ ⴰⵛ ⴷⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵏⵙⴻⵏ, ⴰⵎ ⵢⵉⵊⵊ ⵏ ⵍⵄⴰⵀⴷ ⵉ ⵍⴻⴱⴷⴰ, ⵃⵉⵎⴰ ⴰⴷ ⵉⵍⵉⵖ ⴷ ⴰⵔⴻⴱⴱⵉ ⵉ ⵛⴻⴽ ⵓ ⵉ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵛ ⴰⵡⴰⵔⵏⵉ ⴰⵛ. ");
INSERT INTO rift_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","ⴰⴷ ⴰⵛ ⵡⵛⴻⵖ, ⵉ ⵛⴻⴽ ⵓ ⵉ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵛ ⴰⵡⴰⵔⵏⵉ ⴰⵛ, ⵜⴰⵎⵎⵓⵔⵜ ⵎⴰⵏⵉ ⵜⵣⴻⴷⴷⵖⴻⴷ ⴰⵎ ⵓⴱⴰⵔⵔⴰⵏⵉ, ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ ⴷ ⴰⴳⵍⴰ ⵉ ⵍⴻⴱⴷⴰ. ⵏⴻⵛⵛ ⴰⴷ ⵉⵍⵉⵖ ⴷ ⴰⵔⴻⴱⴱⵉ ⵉ ⵏⵉⵜⵏⵉ.” ");
INSERT INTO rift_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","ⵉⵏⵏⴰ ⴰⵔⴻⴱⴱⵉ ⵄⴰⵡⴻⴷ ⵉ ⵉⴱⵔⴰⵀⵉⵎ: “ⵛⴻⴽ ⴰⴷ ⵜⴻⵃⴹⵉⴷ ⵍⵄⴰⵀⴷ ⵉⵏⵓ, ⵛⴻⴽ ⴷ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵛ ⴰⵡⴰⵔⵏⵉ ⴰⵛ, ⴷⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","ⴷ ⵡⴰ ⴷ ⵍⵄⴰⵀⴷ ⵉⵏⵓ ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵜⴻⵃⴹⴰⵎ ⵊⴰⵔ ⴰⵢⵉ-ⴷⴷ ⴷ ⴽⴻⵏⵏⵉⵡ ⴷ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵛ ⴰⵡⴰⵔⵏⵉ ⴰⵛ: ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵉⵅⵜⴻⵏ ⵣⵣⴰⵢⵡⴻⵎ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⴵⴰⵏ ⴷ ⴰⵡⵜⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⵜⵅⴻⵜⵏⴻⵎ ⴰⵢⵙⵓⵎ ⵏ ⵍⴻⵄⴷⴰⵍⵢⴻⵜ ⵏⵡⴻⵎ ⵓⵛⴰ ⵎⴰⵏ ⴰⵢⴰ ⴰⴷ ⵜⵉⵍⵉ ⴷ ⵍⴻⵄⵍⴰⵎⴻⵜ ⵏ ⵍⵄⴰⵀⴷ ⵊⴰⵔ ⴰⵢⵉ-ⴷⴷ ⴷ ⴽⴻⵏⵏⵉⵡ. ");
INSERT INTO rift_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","ⵎⵎⵉⵙ ⵏ ⵜⵎⴻⵏⵢⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⴰⴷ ⵉⵅⵜⴻⵏ ⵊⴰⵔ ⴰⵡⴻⵎ, ⵎⴽⵓⵍ ⴰⵡⵜⴻⵎ ⴷⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵏⵡⴻⵎ, ⴰⵎ ⵡⴻⵏⵏⵉ ⴷⴷ-ⵉⵅⴻⵍⵇⴻⵏ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⴻⵛ ⴰⵎ ⵡⴻⵏⵏⵉ ⵉⵜⵜⵡⴰⵙⵖⴻⵏ ⵙ ⵏⵏⵓⵇⴰⵔⵜ ⵣⵉ ⴽⵓⵍ ⴰⴱⴰⵔⵔⴰⵏⵉ ⵓ ⵡⴰⵔ ⵉⴵⵉⵏ ⵣⵉ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","ⴰⵎ ⵡⴻⵏⵏⵉ ⴷⴷ-ⵉⵅⴻⵍⵇⴻⵏ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⴻⵛ, ⴰⵎ ⵡⴻⵏⵏⵉ ⵜⴻⵙⵖⵉⴷ ⵙ ⵏⵏⵓⵇⴰⵔⵜ, ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⵙ ⴰⴷ ⵉⵅⵜⴻⵏ. ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵢⵉⵍⵉ ⵍⵄⴰⵀⴷ ⵉⵏⵓ ⴷⴻⴳ ⵡⴻⵢⵙⵓⵎ ⵏⵡⴻⵎ ⴷ ⵍⵄⴰⵀⴷ ⵉ ⵍⴻⴱⴷⴰ. ");
INSERT INTO rift_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","ⴰⵔⵢⴰⵣ ⵡⴰⵔ ⵉⵅⵜⵉⵏⴻⵏ, ⵡⴻⵏⵏⵉ ⵍⴻⵄⴷⴰⵍⵢⴻⵜ ⵏⵏⴻⵙ ⵡⴰⵔ ⵜⵜ ⵅⵜⵉⵏ, ⴰⵔⵢⴰⵣ ⵏⵏⵉ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜ ⵇⴻⵙⵙⴻⵏ ⵣⵉ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ, ⴰⵇⴰ ⵢⴰⵔⵥⴰ ⵍⵄⴰⵀⴷ ⵉⵏⵓ.” ");
INSERT INTO rift_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","ⵉⵏⵏⴰ ⴰⵔⴻⴱⴱⵉ ⵄⴰⵡⴻⴷ ⵉ ⵉⴱⵔⴰⵀⵉⵎ: “ⵉ ⵙⴰⵔⴰⵢ ⵜⴰⵎⵖⴰⵔⵜ ⵏⵏⴻⵛ ⵡⴰⵔ ⴷ ⴰⵙ ⵜⵍⵉⵖⵉⴷ ⵄⴰⴷ ‘ⵙⴰⵔⴰⵢ’, ⵎⴰⵛⴰ ‘ⵙⴰⵔⴰ’ ⴷ ⵡⴰ ⵉ ⵖⴰ ⵢⵉⵍⵉⵏ ⵉⵙⴻⵎ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","ⵎⵉⵏⵣⵉ ⴰⴷ ⵜⵜ ⴱⴰⵔⴽⴻⵖ ⵓ ⵣⵣⴰⵢⴻⵙ ⴰⴷ ⴰⵛ ⵡⵛⴻⵖ ⵎⵎⵉⵛ. ⵡⴰⵀ, ⴰⴷ ⵜⵜ ⴱⴰⵔⴽⴻⵖ ⵓⵛⴰ ⵏⴻⵜⵜⴰⵜ ⴰⴷ ⵜⴻⴷⵡⴻⵍ ⴷ ⵍⴻⴳⵏⵓⵙ ⵓ ⵉⵊⴻⴵⵉⴷⴻⵏ ⵏ ⵍⴻⴳⵏⵓⵙ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⴷⴷ-ⴼⴼⵖⴻⵏ!” ");
INSERT INTO rift_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","ⵅⴻⵏⵏⵉ ⵉⵡⴹⴰ ⵉⴱⵔⴰⵀⵉⵎ ⵅ ⵓⵖⴻⵎⴱⵓⴱ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⴹⵃⴻⵛ, ⵉⵏⵏⴰ ⴷⴻⴳ ⵡⵓⵍ ⵏⵏⴻⵙ: “ⴰⵔⵢⴰⵣ ⵏ ⵎⵢⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵎⴰ ⴰⴷ ⴰⵙ ⴷⴷ-ⵉⵜⵜⵡⴰⵅⵍⴻⵇ ⵎⵎⵉⵙ? ⵓ ⵙⴰⵔⴰ, ⵜⴻⵏⵏⵉ ⵖⴰⵔ ⵉⴵⴰ ⵜⴻⵙⵄⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵎⴰ ⵄⴰⴷ ⴰⴷ ⴷⴷ-ⵜⴰⵔⵓⵡ?” ");
INSERT INTO rift_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","ⵉⵏⵏⴰ ⵉⴱⵔⴰⵀⵉⵎ ⵉ ⴰⵔⴻⴱⴱⵉ: “ⵎⵍⵉ ⵉⵙⵎⴰⵄⵉⵍ ⵉⴷⴷⴰⵔ ⵇⵉⴱⴰⵍⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏⵏⴻⵛ!” ");
INSERT INTO rift_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","ⵎⴰⵛⴰ ⴰⵔⴻⴱⴱⵉ ⵉⵏⵏⴰ: “ⵍⵍⴰ, ⵄⴰⴷ ⵙⴰⵔⴰ, ⵜⴰⵎⵖⴰⵔⵜ ⵏⵏⴻⵛ, ⴷ ⵜⴻⵏⵏⵉ ⴷ ⴰⵛ ⴷⴷ ⵖⴰ ⵢⴰⵔⵡⴻⵏ ⴰⵙⴻⵢⵎⵉ, ⵓⵛⴰ ⵛⴻⴽ ⴰⴷ ⴰⵙ ⵜⵍⴰⵖⵉⴷ ⵉⵙⵃⴰⵇ. ⵏⴻⵛⵛ ⴰⴷ ⴳⴳⴻⵖ ⵍⵄⴰⵀⴷ ⵉⵏⵓ ⴰⴽⵉⴷⴻⵙ ⴷ ⵍⵄⴰⵀⴷ ⵉ ⵍⴻⴱⴷⴰ, ⵉ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵙ ⴰⵡⴰⵔⵏⵉ ⴰⵙ.   ");
INSERT INTO rift_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","ⵣⵉ ⵊⵊⵉⵀⴻⵜ ⵏ ⵉⵙⵎⴰⵄⵉⵍ, ⴰⵇⴰ ⵙⴻⴵⴻⵖ ⴰⵛ. ⵅⵣⴰⵔ, ⵏⴻⵛⵛ ⴱⴰⵔⴽⴻⵖ ⵜ ⵓⵛⴰ ⴰⴷ ⵜ ⴰⵔⵔⴻⵖ ⵉⵜⵜⴰⵔⵓⵡ ⵍⵖⵉⴵⴻⵜ ⵓ ⴰⴷ ⵜ ⴰⵔⵔⴻⵖ ⴷ ⴰⵟⵟⴰⵙ. ⵜⴻⵏⵄⴰⵛ ⵏ ⵍⵃⵓⴽⴽⴰⵎ ⵉ ⴷⴷ ⵖⴰ ⵢⴻⵊⵊ, ⴰⴷ ⵜ ⴳⴳⴻⵖ ⴷ ⵉⵊⵊ ⵏ ⵍⴳⴻⵏⵙ ⵉⵎⵖⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","ⵎⴰⵛⴰ ⴰⴷ ⴳⴳⴻⵖ ⵍⵄⴰⵀⴷ ⵉⵏⵓ ⴰⴽ-ⴷ ⵉⵙⵃⴰⵇ, ⵡⴻⵏⵏⵉ ⵉ ⴷ ⴰⵛ ⴷⴷ ⵖⴰ ⵜⴰⵔⵓⵡ ⵙⴰⵔⴰ ⴷⵉ ⵍⵡⴻⵇⵜ-ⴰ, ⴷⴻⴳ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵉ ⴷⴷ ⵖⴰ ⵢⴰⵙⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","ⵓⵎⵉ ⵉⴽⴻⵎⵎⴻⵍ ⴰⵡⴰⵍ ⵏⵏⴻⵙ ⴰⴽⵉⴷⴻⵙ, ⵉⴳⴻⵄⵄⴻⴷ ⴰⵔⴻⴱⴱⵉ, ⵉⴳⴳⵯⴻⵊ ⵅ ⵉⴱⵔⴰⵀⵉⵎ. ");
INSERT INTO rift_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","ⵉⴽⵙⵉ ⵉⴱⵔⴰⵀⵉⵎ ⵎⵎⵉⵙ ⵉⵙⵎⴰⵄⵉⵍ ⴷ ⵎⴰⵔⵔⴰ ⵉⵙⴻⵎⵖⴰⵏ ⵉ ⴷⴷ-ⵉⵜⵜⵡⴰⵅⴻⵍⵇⴻⵏ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⴻⵙ ⴷ ⵎⴰⵔⵔⴰ ⵉⵏⵏⵉ ⵉⵎⵎⴻⵙⵖⴻⵏ ⵙ ⵏⵏⵓⵇⴰⵔⵜ, ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⴵⴰⵏ ⴷ ⴰⵡⵜⴻⵎ ⵊⴰⵔ ⴰⵢⵜⴱⴰⴱ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵉⴱⵔⴰⵀⵉⵎ ⵓⵛⴰ ⵉⵅⵜⴻⵏ ⵍⴻⵄⴷⴰⵍⵢⴻⵜ ⵏⵙⴻⵏ ⴷⴻⴳ ⵡⴰⵙⵙ ⵏⵏⵉ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵙ ⵉⵏⵏⴰ ⴰⵔⴻⴱⴱⵉ. ");
INSERT INTO rift_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","ⵜⵓⵖⴰ ⵖⴰⵔ ⵉⴱⵔⴰⵀⵉⵎ ⵜⴻⵙⵄⴰ ⵓ-ⵜⴻⵙⵄⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵓⵎⵉ ⵉⵅⵜⴻⵏ ⴷⴻⴳ ⵡⴻⵢⵙⵓⵎ ⵏ ⵍⴻⵄⴷⴰⵍⵢⴻⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","ⵉⴳⴳⴰ ⵎⵎⵉⵙ ⵉⵙⵎⴰⵄⵉⵍ ⵜⵍⴻⵟⵟⴰⵛ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵓⵎⵉ ⵜ ⵅⴻⵜⵏⴻⵏ ⴷⴻⴳ ⵡⴻⵢⵙⵓⵎ ⵏ ⵍⴻⵄⴷⴰⵍⵢⴻⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","ⵉⵅⵜⴻⵏ ⵉⴱⵔⴰⵀⵉⵎ ⴷ ⵎⵎⵉⵙ ⵉⵙⵎⴰⵄⵉⵍ ⴷⴻⴳ ⵡⴰⵙⵙ ⴷ ⵉⵊⵊⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","ⵅⴻⵜⵏⴻⵏ ⴰⴽⵉⴷⴻⵙ ⵎⴰⵔⵔⴰ ⵉⵔⵢⴰⵣⴻⵏ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⴻⵙ, ⵉⵏⵏⵉ ⴷⴷ-ⵉⵜⵜⵡⴰⵅⴻⵍⵇⴻⵏ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⴻⵙ ⵓⵍⴰ ⴷ ⵉⵏⵏⵉ ⵉⵎⵎⴻⵙⵖⴻⵏ ⵙ ⵏⵏⵓⵇⴰⵔⵜ ⵣⴻⴳ ⵓⴱⴰⵔⵔⴰⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","ⵓⵛⴰ ⵉⴹⵀⴰⵔ ⵙⵉⴷⵉ ⵉ ⵉⴱⵔⴰⵀⵉⵎ ⵖⴰⵔ ⵜⵛⴻⵊⵊⵓⵔⴰ ⵏ ⵢⵉⴳⴳ ⵏ ⵎⴰⵎⵔⵉ ⵓⵎⵉ ⵜⵓⵖⴰ ⵢⴰⵔⴻⵢⵢⴻⵃ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏⵏⴻⵙ ⴷⵉ ⵟⵟⵃⴰ ⵏ ⵓⵣⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","ⵉⵙⵙⴳⴻⵄⵄⴻⴷ ⵜⴰⵎⵓⵖⵍⵉ ⵏⵏⴻⵙ, ⵉⵥⵔⴰ, ⴰⵇⴰ ⴷⵉⵏ ⵜⵍⴰⵜⴰ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ ⵇⵉⴱⴰⵍⵜ ⵏⵏⴻⵙ. ⵓⵎⵉ ⵜⴻⵏ ⵉⵥⵔⴰ, ⵉⴽⴽⴰⵔ ⵉⵜⵜⴰⵣⵣⴻⵍ ⵖⴰⵔⵙⴻⵏ ⵣⵉ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ. ⵓⵛⴰ ⵉⴱⴻⵏⴷⴻⵇ ⵙ ⵓⵖⴻⵎⴱⵓⴱ ⵏⵏⴻⵙ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ,    ");
INSERT INTO rift_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","ⵉⵏⵏⴰ: “ⴰ ⵙⵉⴷⵉ ⵉⵏⵓ, ⵎⴰⵍⴰ ⵍⴻⵅⵅⵓ ⵓⴼⵉⵖ ⴰⵔⴹⴰ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵛ, ⵜⵜⵣⴰⵡⴰⴳⴻⵖ ⵛⴻⴽ, ⵡⴰⵔ ⵄⴻⴷⴷⵓ ⵅ ⵓⵎⵙⴻⵅⵅⴰⵔ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","ⴻⵊⵊ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵉⵏⵓ ⴰⴷ ⴷⴷ-ⴰⵡⵢⴻⵏ ⵛⵡⴰⵢⵜ ⵏ ⵡⴰⵎⴰⵏ ⵓⵛⴰ ⵙⵉⵔⴷⴻⵎ ⵉⴹⴰⵔⴻⵏ ⵏⵡⴻⵎ ⵓⵛⴰ ⵣⵣⵍⴻⵎ ⵛⵡⴰⵢⵜ ⵙⴰⴷⵓ ⵜⵛⴻⵊⵊⴰⵔⵜ-ⴰ. ");
INSERT INTO rift_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","ⴰⴷ ⴷⴷ-ⴰⵡⵢⴻⵖ ⴰⵍⴻⵇⵇⵓⵣ ⵏ ⵡⴻⵖⵔⵓⵎ ⵃⵉⵎⴰ ⴰⴷ ⵜⵜⵡⴰⵏⴻⵄⵛⴻⵏ ⵡⵓⵍⴰⵡⴻⵏ ⵏⵡⴻⵎ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⴻⵄⴷⵓⵎ. ⴰⵇⴰ ⵅ ⵓⵢⴰ ⵉ ⴷⴷ-ⵜⴻⴽⴽⵉⵎ ⵣⵣⴰⵜ ⵉ ⵓⵎⵙⴻⵅⵅⴰⵔ ⵏⵡⴻⵎ!” ⵏⵉⵜⵏⵉ ⵏⵏⴰⵏ: “ⴻⴳⴳ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⴻⵏⵏⵉⴷ.” ");
INSERT INTO rift_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","ⵉⵔⵓⵃ ⵉⴱⵔⴰⵀⵉⵎ ⴷⴻⵖⵢⴰ ⵖⴰⵔ ⵓⵇⵉⴹⵓⵏ ⵖⴰⵔ ⵙⴰⵔⴰ, ⵉⵏⵏⴰ: “ⴷⴻⵖⵢⴰⵜ, ⴽⵙⵉ ⵜⵍⴰⵜⴰ ⵏ ⵍⴻⵇⵢⴰⵙ ⵏ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ, ⴻⴳⴳⵡ ⵉ-ⵜⴻⵏ ⵓⵛⴰ ⴻⴳⴳ ⵣⵣⴰⵢⴻⵙ ⵜⵉⴼⴹⵉⵔⵉⵏ.” ");
INSERT INTO rift_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","ⵅⴰⵙ ⵓⵛⴰ ⵢⵓⵣⵣⴻⵍ ⵉⴱⵔⴰⵀⵉⵎ ⵖⴰⵔ ⵉⴼⵓⵏⴰⵙⴻⵏ ⵓⵛⴰ ⵉⵟⵟⴻⴼ-ⴷⴷ ⵉⵊⵊ ⵏ ⵓⵎⴻⵥⵢⴰⵏ ⵏ ⵓⴼⵓⵏⴰⵙ ⵉⴳⵎⴰ ⴷ ⵍⴻⵎⵍⵉⵃ, ⵉⵡⵛⴰ ⵉ-ⵜ ⵉ ⵓⴱⵍⵉⵖ, ⵓⵛⴰ ⵡⴰ ⵉⵇⴻⴵⴻⵇ, ⵃⵉⵎⴰ ⴰⴷ ⵜ ⵉⵙⵙⴻⵡⵊⴻⴷ. ");
INSERT INTO rift_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","ⵏⴻⵜⵜⴰ ⵉⴽⵙⵉ ⵄⴰⵡⴻⴷ ⴷⴷⵀⴻⵏ ⴷ ⵓⵖⵉ ⴷ ⵓⵎⴻⵥⵢⴰⵏ ⵏ ⵓⴼⵓⵏⴰⵙ ⵏⵏⵉ ⵉⵙⵙⴻⵡⵊⴻⴷ, ⵓⵛⴰ ⵉⵙⵙⴰⵔⵙ ⵉ-ⵜ ⵣⵣⴰⵜⵙⴻⵏ, ⵓ ⵏⴻⵜⵜⴰ ⵜⵓⵖⴰ ⵉⴱⴻⴷⴷ ⵇⵉⴱⴰⵍⵜ ⵏⵙⴻⵏ ⵙⴰⴷⵓ ⵜⵛⴻⵊⵊⴰⵔⵜ, ⵓⵛⴰ ⵛⵛⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","ⵅⴻⵏⵏⵉ ⵏⵏⴰⵏ ⴰⵙ: “ⵎⴰⵏⵉ ⵜⴻⴵⴰ ⵙⴰⵔⴰ ⵜⴰⵎⵖⴰⵔⵜ ⵏⵏⴻⵛ?” ⵢⴰⵔⵔⴰ-ⴷⴷ ⵅⴰⵙⴻⵏ: “ⴰⵇⴰ-ⵜⵜ ⴷⵉⵏ ⴷⴻⴳ ⵓⵇⵉⴹⵓⵏ.” ");
INSERT INTO rift_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵉⵏⵏⴰ: “ⴷ ⵜⵉⴷⴻⵜⵜ ⴰⴷ ⵖⴰⵔⴻⴽ ⴷⴷ-ⴷⴻⵡⵍⴻⵖ ⵖⴰⵔ ⵍⵡⴻⵇⵜ ⵏ ⵜⵓⴷⴰⵔⵜ ⵓ ⵅⵣⴰⵔ, ⴰⴷ ⵖⴰⵔⴻⵙ ⵢⵉⵍⵉ ⵓⵃⴻⵏⵊⵉⵔ ⵖⴰⵔ ⵙⴰⵔⴰ, ⵜⴰⵎⵖⴰⵔⵜ ⵏⵏⴻⵛ.” ⵓ ⵙⴰⵔⴰ ⵜⴻⵙⵍⴰ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏⵏⵉ ⵉⴵⴰⵏ ⴰⵡⴰⵔⵏⵉ ⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","ⵉⴱⵔⴰⵀⵉⵎ ⴷ ⵙⴰⵔⴰ ⵜⵓⵖⴰ ⵡⵙⴰⵔⴻⵏ, ⵓⵢⵓⵔⴻⵏ ⴷⴻⴳ ⵡⵓⵙⵙⴰⵏ, ⵓⵛⴰ ⵙⴰⵔⴰ ⵜⵓⵖⴰ ⵜⴱⴻⴷⴷ ⴰⵙ ⵜⵓⴱⴱⴰⵔⵜ ⵏ ⵜⴻⵎⵖⴰⵔⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","ⵓⵛⴰ ⵜⴻⴹⵃⴻⵛ ⵙⴰⵔⴰ ⴷⴻⴳ ⵡⵓⵍ ⵏⵏⴻⵙ, ⵜⴻⵏⵏⴰ: “ⴰⵡⴰⵔⵏⵉ ⵜⴻⵡⵙⴰⵔ ⵉⵏⵓ, ⵎⴰ ⴰⴷ ⵖⴰⵔⵉ ⵢⵉⵍⵉ ⵍⵅⵉⵔ-ⴰ ⴷ ⵍⴻⵎⵍⵉⵃ ⵇⴰⵄ, ⴰⵎ ⵉⴵⴰ ⵙⵉⴷⵉ ⵉⵏⵓ ⵓⵍⴰ ⴷ ⵏⴻⵜⵜⴰ ⵉⵡⵙⴰⵔ?” ");
INSERT INTO rift_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵉⴱⵔⴰⵀⵉⵎ: “ⵎⴰⵖⴰⵔ ⵜⴻⴹⵃⴻⵛ ⵙⴰⵔⴰ, ⵜⴻⵏⵏⴰ: ‘ⵎⴰ ⵣⴻⵎⵎⴰⵔⴻⵖ ⴰⴷ ⴰⵔⵡⴻⵖ ⴰⵎ ⵡⵙⴰⵔⴻⵖ ⵍⴻⵅⵅⵓ?’ ");
INSERT INTO rift_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","ⵎⴰ ⴰⵇⴰ ⴷⵉⵏ ⵛⴰ ⵏ ⵍⵃⴰⵊⵊⴻⵜ ⵅ ⵙⵉⴷⵉ ⵜⴻⵡⵄⴰⵔ? ⴰⴷ ⵖⴰⵔⴻⴽ ⴷⴷ-ⵄⴻⵇⴱⴻⵖ ⴷⵉ ⵍⵡⴻⵇⵜ ⵉ ⵏⴻⴳⴳⴰ, ⵖⴰⵔ ⵍⵡⴻⵇⵜ ⵏ ⵜⵓⴷⴰⵔⵜ ⵓⵛⴰ ⴰⴷ ⵢⵉⵍⵉ ⵖⴰⵔ ⵙⴰⵔⴰ ⵎⵎⵉⵙ!” ");
INSERT INTO rift_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","ⵙⴰⵔⴰ ⵜⴻⵏⴽⴰⵔ, ⵜⴻⵏⵏⴰ: “ⵡⴰⵔ ⴹⴻⵃⵛⴻⵖ ⵛⴰ!”, ⵎⵉⵏⵣⵉ ⵜⵓⵖⴰ ⵜⴻⴳⴳⵯⴻⴷ. ⵏⴻⵜⵜⴰ ⵉⵏⵏⴰ ⴰⵙ: “ⵍⵍⴰ, ⴰⵇⴰ ⵛⴻⵎ ⵜⴹⴻⵃⵛⴻⴷ!” ");
INSERT INTO rift_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","ⵅⴻⵏⵏⵉ ⴽⴽⴰⵔⴻⵏ ⵉⵔⵢⴰⵣⴻⵏ ⵏⵏⵉ ⵙⵙⴻⵏⵏⵉ, ⵙⴻⵡⴹⴻⵏ ⵖⴰⵔ ⵙⴰⴷⵓⵎ, ⵓⵛⴰ ⵉⵔⵓⵃ ⵉⴱⵔⴰⵀⵉⵎ ⴰⴽⵉⴷⵙⴻⵏ, ⵉⵙⵙⵇⴻⴱⴱⴻⴹ ⵉ-ⵜⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","ⵓⵛⴰ ⵉⵏⵏⴰ ⵙⵉⴷⵉ: “ⵎⴰ ⴰⴷ ⴼⴼⴰⵔⴻⵖ ⵏⴻⵛⵛ ⵅ ⵉⴱⵔⴰⵀⵉⵎ ⵎⵉⵏ ⵉ ⵖⴰ ⴳⴳⴻⵖ? ");
INSERT INTO rift_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","ⴰⴷ ⵢⵉⵍⵉ ⵉⴱⵔⴰⵀⵉⵎ ⵣⴻⵄⵎⴰ ⴷ ⵉⵊⵊ ⵏ ⵍⴳⴻⵏⵙ ⵉⵎⵖⴰⵔ ⵉⵊⵀⴻⴷ, ⴰⵇⴰ ⴰⴷ ⴷⴰⵢⴻⵙ ⵜⵜⵡⴰⴱⴰⵔⴽⴻⵏ ⵎⴰⵔⵔⴰ ⵍⴻⴳⵏⵓⵙ ⵏ ⴷⴷⵓⵏⴻⵛⵜ. ");
INSERT INTO rift_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","ⵎⵉⵏⵣⵉ ⵏⴻⵛⵛ ⵇⵇⵏⴻⵖ ⵉⵅⴻⴼ ⵉⵏⵓ ⴰⴽⵉⴷⴻⵙ, ⵃⵉⵎⴰ ⴰⴷ ⵉⵙⵙⴻⵍⵎⴻⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ ⵓⵍⴰ ⴷ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⴻⵙ ⴰⵡⴰⵔⵏⵉ ⴰⵙ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵃⴹⴰⵏ ⴰⴱⵔⵉⴷ ⵏ ⵙⵉⴷⵉ, ⴰⴷ ⴳⴳⴻⵏ ⵜⴰⵙⴻⴳⴷⴰ ⴷ ⵍⵃⴻⵇⵇ, ⵃⵉⵎⴰ ⵙⵉⴷⵉ ⴰⴷ ⴷⴷ-ⵢⴰⵡⵉ ⵉ ⵉⴱⵔⴰⵀⵉⵎ ⵎⵉⵏ ⵜⵓⵖⴰ ⵅⴰⵙ ⵉⵏⵏⴰ.” ");
INSERT INTO rift_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵙⵉⴷⵉ: “ⵜⵖⵓⵢⵢⵉⵜ ⵏ ⵙⴰⴷⵓⵎ ⴷ ⵄⴰⵎⵓⵔⵔⴰ ⵜⴻⵎⵖⴰⵔ ⴰⵟⵟⴰⵙ ⵓ ⴷⴷⵏⵓⴱ ⵏⵙⴻⵏ ⴷⴻⵇⵍⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","ⴰⴷ ⴷⴷ-ⵀⵡⵉⵖ, ⴰⴷ ⵥⴰⵔⴻⵖ ⵎⴰ ⴳⴳⵉⵏ ⵏⵉⵛⴰⵏ ⴰⵎ ⵜⵖⵓⵢⵢⵉⵜ ⵏⵙⴻⵏ ⵉ ⵖⴰⵔⵉ ⴷⴷ-ⵢⵓⵙⵉⵏ ⵏⵉⵖ ⵍⵍⴰ, ⴰⴷ ⵙⵙⵏⴻⵖ.” ");
INSERT INTO rift_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","ⵅⴻⵏⵏⵉ ⴷⴻⵡⵍⴻⵏ ⵉⵔⵢⴰⵣⴻⵏ ⵙⵙⴻⵏⵏⵉ ⵓⵛⴰ ⵟⵟⴼⴻⵏ ⴰⴱⵔⵉⴷ ⵖⴰⵔ ⵙⴰⴷⵓⵎ. ⵎⴰⵛⴰ ⵉⴱⵔⴰⵀⵉⵎ ⵜⵓⵖⴰ ⵉⵇⵇⵉⵎ ⵄⴰⴷ ⵉⴱⴻⴷⴷ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","ⵓⵛⴰ ⵉⵇⴰⵔⵔⴻⴱ-ⴷⴷ ⵉⴱⵔⴰⵀⵉⵎ, ⵉⵏⵏⴰ: “ⵎⴰ ⵙ ⵜⵉⴷⴻⵜⵜ ⴰⴷ ⵜⴰⵔⴻⴷⴵⴻⴷ ⵄⴰⵡⴻⴷ ⴰⵎⵙⴻⴳⴳⴻⴷ ⴰⴽ-ⴷ ⵓⵄⴻⴼⴼⴰⵏ? ");
INSERT INTO rift_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","ⴰⵇⴰ ⴷⵉⵏⵏⵉ ⴱⴰⵍⴰⴽ ⵅⴻⵎⵙⵉⵏ ⵏ ⵉⵎⵙⴻⴳⴳⴰⴷⴻⵏ ⴷⴰⵅⴻⵍ ⵉ ⵜⴻⵏⴷⵉⵏⵜ. ⵎⴰ ⵙ ⵜⵉⴷⴻⵜⵜ ⴰⴷ ⵜⴻⵏ ⵜⴰⵔⴻⴷⴵⴻⴷ, ⵓ ⵡⴰⵔ ⵜⵙⴻⵎⵎⵃⴻⴷ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏⵏⵉ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏ ⵅⴻⵎⵙⵉⵏ ⵏ ⵉⵎⵙⴻⴳⴳⴰⴷⴻⵏ ⵉ ⴷⴰⵢⴻⵙ ⵉⴵⴰⵏ? ");
INSERT INTO rift_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","ⵉⴳⴳⵯⴻⵊ ⵅⴰⴽ ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⴰⵢⴰ, ⴰⴷ ⵜⴻⵏⵖⴻⴷ ⴰⵎⵙⴻⴳⴳⴻⴷ ⴰⴽ-ⴷ ⵓⵄⴻⴼⴼⴰⵏ, ⵡⴰⵀ, ⵉⴳⴳⵯⴻⵊ ⵅⴰⴽ ⴰⴷ ⵢⵉⵍⵉ ⵓⵎⵙⴻⴳⴳⴻⴷ ⵎⴻⵃⵙⵓⴱ ⴰⵎ ⵓⵄⴻⴼⴼⴰⵏ. ⴰⵇⴰ ⵍⵇⴰⴹⵉ ⵏ ⴷⴷⵓⵏⴻⵛⵜ ⵎⴰ ⵡⴰⵔ ⵉⵜⵜⴻⴳⴳ ⵙ ⵍⵃⴻⵇⵇ?” ");
INSERT INTO rift_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⵏⵏⴰ ⴰⵙ ⵙⵉⴷⵉ: “ⵎⴰⵍⴰ ⵓⴼⵉⵖ ⴷⵉ ⵙⴰⴷⵓⵎ ⵅⴻⵎⵙⵉⵏ ⵏ ⵉⵎⵙⴻⴳⴳⴰⴷⴻⵏ ⴷⴰⵅⴻⵍ ⵉ ⵜⴻⵏⴷⵉⵏⵜ, ⴰⴷ ⵙⴻⵎⵃⴻⵖ ⵉ ⵡⴻⵎⵛⴰⵏ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏⵙⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","ⵉⴱⵔⴰⵀⵉⵎ ⵢⴰⵔⵔⴰ-ⴷⴷ, ⵉⵏⵏⴰ: “ⵅⵣⴰⵔ ⵍⴻⵅⵅⵓ, ⴱⴷⵉⵖ ⵣⴻⵄⵄⵎⴻⵖ ⴰⴷ ⵙⵙⵉⵡⵍⴻⵖ ⴰⴽ-ⴷ ⵙⵉⴷⵉ ⵉⵏⵓ, ⵡⴰⵅⵅⴰ ⵏⴻⵛⵛ ⴷ ⵛⴰⵍ ⴷ ⵢⵉⵖⵖⴻⴹ. ");
INSERT INTO rift_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","ⴰⴷ ⵜⴰⵖ ⵏⴻⵇⵚⴻⵏ ⵣⵉ ⵅⴻⵎⵙⵉⵏ ⵏ ⵉⵎⵙⴻⴳⴳⴰⴷⴻⵏ ⵅⴻⵎⵙⴰ, ⵎⴰ ⴰⴷ ⵜⴰⵔⴻⴷⴵⴻⴷ ⵅ ⵅⴻⵎⵙⴰ ⵏⵏⵉ ⵎⴰⵔⵔⴰ ⵜⴰⵏⴷⵉⵏⵜ?” ⵉⵏⵏⴰ: “ⵡⴰⵔ ⵜⵜ ⵜⵜⴰⵔⴻⴷⴵⴻⵖ ⵎⴰⵍⴰ ⵓⴼⵉⵖ ⴷⵉⵏ ⵅⴻⵎⵙⴰ ⵓ-ⵔⴻⴱⵄⵉⵏ.” ");
INSERT INTO rift_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","ⵢⴰⵔⵏⵉ ⴷⴻⴳ ⵡⴰⵡⴰⵍ ⴰⴽⵉⴷⴻⵙ, ⵉⵏⵏⴰ ⴰⵙ: “ⴰⴷ ⵜⴰⵖ ⴰⴷ ⵢⵉⵍⵉ ⴰⴷ ⵉⵜⵜⵡⴰⴼ ⴷⵉⵏ ⴰⵔⴻⴱⵄⵉⵏ!” ⵢⴰⵔⵔⴰ-ⴷⴷ ⵏⴻⵜⵜⴰ: “ⵡⴰⵔ ⵜⵜ ⵜⵜⴻⴳⴳⴻⵖ ⵛⴰ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏ ⴰⵔⴻⴱⵄⵉⵏ ⵏⵏⵉ.” ");
INSERT INTO rift_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","ⵅⴰⵙ ⵓⵛⴰ ⵉⵏⵏⴰ: “ⵡⴰⵔ ⵜⵜⵅⴻⵢⵢⵉⵇ ⵍⴻⵅⵅⵓ ⵙⵉⴷⵉ ⵉⵏⵓ, ⵅⵎⵉ ⵖⴰ ⵙⵙⵉⵡⵍⴻⵖ ⵄⴰⵡⴻⴷ. ⴰⴷ ⵜⴰⵖ ⴰⴷ ⵢⵉⵍⵉ ⴷⵉⵏ ⵜⵍⴰⵜⵉⵏ!” ⵢⴰⵔⵔⴰ-ⴷⴷ: “ⵡⴰⵔ ⵜⵜ ⵜⵜⴰⵔⴻⴷⴵⴻⵖ ⵎⴰⵍⴰ ⵓⴼⵉⵖ ⴷⵉⵏ ⵜⵍⴰⵜⵉⵏ.” ");
INSERT INTO rift_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","ⵉⵏⵏⴰ ⵄⴰⵡⴻⴷ: “ⵅⵣⴰⵔ ⵍⴻⵅⵅⵓ, ⴱⴷⵉⵖ ⵣⴻⵄⵎⴻⵖ ⴰⴷ ⵙⵙⵉⵡⵍⴻⵖ ⴰⴽ-ⴷ ⵙⵉⴷⵉ ⵉⵏⵓ. ⴰⴷ ⵜⴰⵖ ⴰⴷ ⵢⵉⵍⵉ ⴷⵉⵏ ⵎⵖⵉⵔ ⵄⵉⵛⵔⵉⵏ!” ⵢⴰⵔⵔⴰ-ⴷⴷ: “ⵡⴰⵔ ⵜⵜ ⵜⵜⴰⵔⴻⴷⴵⴻⵖ ⵛⴰ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏ ⵄⵉⵛⵔⵉⵏ ⵏⵏⵉ.” ");
INSERT INTO rift_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ: “ⵡⴰⵔ ⵜⵜⵅⴻⵢⵢⵉⵇ ⵍⴻⵅⵅⵓ ⵙⵉⴷⵉ ⵉⵏⵓ, ⵅⵎⵉ ⵖⴰ ⵙⵙⵉⵡⵍⴻⵖ ⵄⴰⵡⴻⴷ. ⴰⴷ ⵜⴰⵖ ⴰⴷ ⵢⵉⵍⵉ ⴷⵉⵏ ⵎⵖⵉⵔ ⵄⴻⵛⵔⴰ!” ⵢⴰⵔⵔⴰ-ⴷⴷ: “ⵡⴰⵔ ⵜⵜ ⵜⵜⴰⵔⴻⴷⴵⴻⵖ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏ ⵄⴻⵛⵔⴰ ⵏⵏⵉ.” ");
INSERT INTO rift_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","ⵅⴻⵏⵏⵉ ⵉⵔⵓⵃ ⵙⵉⴷⵉ ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⵉⴽⴻⵎⵎⴻⵍ ⴰⵡⴰⵍ ⵏⵏⴻⵙ ⴰⴽ-ⴷ ⵉⴱⵔⴰⵀⵉⵎ ⵓⵛⴰ ⵉⴱⵔⴰⵀⵉⵎ ⵉⴷⵡⴻⵍ-ⴷⴷ ⵖⴰⵔ ⵡⴻⵎⵛⴰⵏ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","ⵓⵛⴰ ⵉⵡⴹⴻⵏⵜ ⵅⴻⵏⵏⵉ ⵜⵏⴰⵢⴻⵏ ⵏ ⵍⵎⴰⵍⴰⴽⴰⵜ ⵏⵏⵉ ⵖⴰⵔ ⵙⴰⴷⵓⵎ ⵙ ⴵⵉⵍⴻⵜ. ⵜⵓⵖⴰ ⵍⵓⵟ ⵉⵇⵇⵉⵎ ⵖⴰⵔ ⵜⴻⵡⵡⴰⵔⵜ ⵏ ⵙⴰⴷⵓⵎ. ⵓⵎⵉ ⵜⴻⵏ ⵉⵥⵔⴰ ⵍⵓⵟ, ⵉⴽⴽⴰⵔ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⴻⵏ ⵉⵍⵇⴰ ⵓⵛⴰ ⵉⴱⴻⵏⴷⴻⵇ ⵙ ⵓⵖⴻⵎⴱⵓⴱ ⵏⵏⴻⵙ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","ⵉⵏⵏⴰ: “ⵅⵣⴰⵔ, ⴰ ⵉⵙⵉⴷⵉⵜⴻⵏ ⵉⵏⵓ, ⵜⵜⵣⴰⵡⴰⴳⴻⵖ ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⴷⴷ-ⵜⴰⵙⴻⵎ ⵖⴰⵔ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵓⵎⵙⴻⵅⵅⴰⵔ ⵏⵡⴻⵎ ⵓⵛⴰ ⴰⴷ ⴷⴰⵢⴻⵙ ⵜⴻⵙⵙⴻⵏⵙⴻⵎ, ⴰⴷ ⵜⴻⵙⵙⵉⵔⴷⴻⵎ ⵉⴹⴰⵔⴻⵏ ⵏⵡⴻⵎ. ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⴼⴰⵇⴻⵎ ⵣⵉⵛ, ⴰⴷ ⵜⴽⴻⵎⵎⵍⴻⵎ ⵅ ⵡⴻⴱⵔⵉⴷ ⵏⵡⴻⵎ.” ⵎⴰⵛⴰ ⵏⵉⵜⵏⵉ ⵏⵏⴰⵏ: “ⵍⵍⴰ, ⴰⵇⴰ ⴷⴻⴳ ⵡⴰⵣⵣⴰⵢ ⴰⴷ ⵏⴻⵇⵇⵉⵎ ⴰⴷ ⵏⴻⵙⵙⴻⵏⵙ.” ");
INSERT INTO rift_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","ⵎⴰⵛⴰ ⵏⴻⵜⵜⴰ ⵉⴽⴻⵍⵍⴻⴼ ⵅⴰⵙⴻⵏ ⴰⵟⵟⴰⵙ ⴰⵍⴰⵎⵉ ⴰⴽⵉⴷⴻⵙ ⵔⵓⵃⴻⵏ, ⵓⴷⴼⴻⵏ ⵖⴰⵔ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⴳⴳⴰ ⴰⵙⴻⵏ ⴰⵎⴻⵏⵙⵉ, ⵉⴳⴳⵯⴰ ⴰⵖⵔⵓⵎ ⴱⵍⴰ ⴰⵏⵜⵓⵏ ⵓⵛⴰ ⵛⵛⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","ⴰⵇⴰ ⵇⴱⴻⵍ ⵉ ⵖⴰ ⵟⵟⵚⴻⵏ, ⵇⴻⵡⵡⴰⵔⴻⵏ ⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵉⵔⵢⴰⵣⴻⵏ ⵏ ⵜⴻⵏⴷⵉⵏⵜ, ⵉⵔⵢⴰⵣⴻⵏ ⵏ ⵙⴰⴷⵓⵎ, ⵣⴻⴳ ⵓⵎⴻⵥⵢⴰⵏ ⴰⵍ ⴰⵡⴻⵙⵙⴰⵔ, ⵎⴰⵔⵔⴰ ⵉⵡⴷⴰⵏ ⵣⵉ ⵎⴰⵔⵔⴰ ⵉⵎⵓⵛⴰⵏ ⵉⵟⵟⵓⵔⴼⴻⵏ ⵏ ⵜⴻⵏⴷⵉⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","ⵏⵉⵜⵏⵉ ⵍⴰⵖⴰⵏ ⵉ ⵍⵓⵟ, ⵏⵏⴰⵏ ⴰⵙ: “ⵎⴰⵏⵉ ⴵⴰⵏ ⵉⵔⵢⴰⵣⴻⵏ ⵉⵏⵏⵉ ⵖⴰⵔⴻⴽ ⴷⴷ-ⵢⵓⵙⵉⵏ ⴵⵉⵔⴻⵜ-ⴰ? ⵙⵓⴼⴼⴻⵖ ⵉ-ⵜⴻⵏ-ⴷⴷ, ⵃⵉⵎⴰ ⴰⴷ ⵜⴻⵏ ⵏⴻⵙⵙⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","ⵉⴼⴼⴻⵖ-ⴷⴷ ⵖⴰⵔⵙⴻⵏ ⵍⵓⵟ, ⵖⴰⵔ ⵜⴻⵡⵡⴰⵔⵜ, ⵓⵛⴰ ⵉⵇⵇⴻⵏ ⵜⴰⵡⵡⴰⵔⵜ ⴰⵡⴰⵔⵏⵉ ⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ⵉⵏⵏⴰ: “ⵜⵜⵣⴰⵡⴳⴻⵖ, ⴰ ⴰⵢⵜⵎⴰ ⵉⵏⵓ, ⵡⴰⵔ ⵜⵜⴻⴳⴳⴻⵎ ⵇⴰⵄ ⵍⵖⴰⵔ! ");
INSERT INTO rift_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","ⵅⵣⴰⵔ, ⵖⴰⵔⵉ ⵜⵏⴰⵢⴻⵏ ⵏ ⵢⴻⵙⵙⵉ, ⵜⵉⵏⵏⵉ ⵄⴰⴷ ⵡⴰⵔ ⵉⵙⵙⵉⵏⴻⵏ ⴰⵔⵢⴰⵣ. ⴻⵊⵊ ⴰⵢⵉ ⴰⴷ ⴰⵡⴻⵎ ⵜⴻⵏⵜ ⵉ-ⴷⴷ-ⵙⵙⵓⴼⴼⵖⴻⵖ ⴱⴰⵔⵔⴰ ⵓⵛⴰ ⴳⴳⴻⵎ ⴷⴰⵢⵙⴻⵏⵜ ⵎⵉⵏ ⵜᵉⵜⵜⵡⴰⵍⴰⵎ ⵎⵍⵉⵃ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵡⴻⵎ. ⵎⵖⵉⵔ ⵉ ⵉⵔⵢⴰⵣⴻⵏ-ⴰ ⵡⴰⵔ ⴷⴰⵢⵙⴻⵏ ⵜⵜⴻⴳⴳⴻⵎ ⵡⴰⵍⵓ, ⴰⵇⴰ ⵅ ⵓⵢⴰ ⴷⴷ-ⵓⵙⵉⵏ ⵏⵉⵜⵏⵉ ⵙⵡⴰⴷⴷⴰⵢ ⵏ ⵜⵉⵍⵉ ⵏ ⵜⵣⴻⵇⵇⴰ ⵉⵏⵓ ⵖⴰⵔ ⵜⵎⴻⵏⵙⵉⵡⵜ.” ");
INSERT INTO rift_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","ⵏⵉⵜⵏⵉ ⵏⵏⴰⵏ: “ⴰⴳⴳⵯⴻⵊ ⴷⵉⵀⴰ!” ⵓⵛⴰ ⵏⵏⴰⵏ ⵄⴰⵡⴻⴷ: “ⴰⵇⴰ ⵡⴰⵏⵉⵜⴰ ⵢⵓⵙⴰ-ⴷⴷ ⴷⴰ ⴷ ⴰⴱⴰⵔⵔⴰⵏⵉ ⵓⵛⴰ ⵉⵅⵙ ⴰⴷ ⵅⴰⵏⴻⵖ ⵉⵃⴽⴻⵎ ⴰⵎ ⵍⵇⴰⴹⵉ! ⵍⴻⵅⵅⵓ ⴰⴷ ⵛⴻⴽ ⵏⴹⴰⵔⵔ ⴽⵜⴰⵔ ⵣⵣⴰⵢⵙⴻⵏ.” ⵓⵛⴰ ⴳⴳⵉⵏ ⴰⵟⵟⴰⵙ ⵏ ⵓⵖⵉⵍ ⵅ ⵡⴻⵔⵢⴰⵣ ⵏⵏⵉ, ⵅ ⵍⵓⵟ, ⵓⵛⴰ ⵇⴰⵔⵔⴱⴻⵏ-ⴷⴷ ⵃⵉⵎⴰ ⴰⴷ ⴰⵔⵥⴻⵏ ⵜⴰⵡⵡⴰⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","ⵎⴰⵛⴰ ⵉⵔⵢⴰⵣⴻⵏ ⵏⵏⵉ ⵙⵙⵡⵉⵥⵥⴹⴻⵏ ⴰⴼⵓⵙ ⵏⵙⴻⵏ, ⵙⵙⵉⴷⴼⴻⵏ ⵍⵓⵟ ⵖⴰⵔ ⵜⴰⴷⴷⴰⵔⵜ ⴰⴽⵉⴷⵙⴻⵏ ⵓⵛⴰ ⴱⴻⵍⵍⵄⴻⵏ ⵜⴰⵡⵡⴰⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","ⵏⵉⵜⵏⵉ ⵡⵜⵉⵏ ⵉⵔⵢⴰⵣⴻⵏ ⵏⵏⵉ ⵜⵓⵖⴰ ⵉⴱⴻⴷⴷⴻⵏ ⵖⴰⵔ ⵜⴻⵡⵡⴰⵔⵜ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵙ ⵜⵓⴷⴷⴰⵔⵖⴻⵞ, ⴰⵎ ⵓⵎⴻⵥⵢⴰⵏ ⴰⵎ ⵓⵎⴻⵇⵇⵔⴰⵏ, ⴰⵍⴰⵎⵉ ⵙⵙⵉⵀⵍⴻⵏ ⵏⵉⵜⵏⵉ ⵉⵅⴻⴼ ⵏⵙⴻⵏ ⴷⵉ ⵜⴰⵔⴻⵣⵣⵓⵜ ⵅ ⵜⴻⵡⵡⴰⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","ⵅⴻⵏⵏⵉ ⵏⵏⴰⵏ ⵉⵔⵢⴰⵣⴻⵏ ⵏⵏⵉ ⵉ ⵍⵓⵟ: “ⵡⵉ ⵖⴰⵔⴻⴽ ⴷⴰ ⵄⴰⴷ? ⵎⴰ ⴰⴹⴻⴳⴳⵯⴰⵍ ⵏⵉⵖ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵉⵖ ⵜⵃⴻⵏⵊⵉⵔⵉⵏ, ⵎⴰⵔⵔⴰ ⵉⵏⵏⵉ ⵖⴰⵔⴻⴽ ⴷⵉ ⵜⴻⵏⴷⵉⵏⵜ, ⴻⵊⵊ ⵉ-ⵜⴻⵏ ⴰⴷ ⴼⴼⵖⴻⵏ ⵣⴻⴳ ⵡⴻⵎⵛⴰⵏ-ⴰ. ");
INSERT INTO rift_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","ⴰⵇⴰ ⴰⴷ ⵏⴰⵔⴻⴷⴷⴻⴵ ⴰⵎⵛⴰⵏ-ⴰ, ⵎⵉⵏⵣⵉ ⵜⵖⵓⵢⵢⵉⵜ ⵏⵏⴻⵙ ⵜⴻⵎⵖⴰⵔ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ, ⵓ ⵙⵉⴷⵉ ⵉⵙⵙⴻⴽⴽ ⴰⵏⴻⵖ-ⴷⴷ, ⵃⵉⵎⴰ ⴰⴷ ⵜⵜ ⵏⴰⵔⴻⴷⴷⴻⴵ.” ");
INSERT INTO rift_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","ⵉⴼⴼⴻⵖ ⵍⵓⵟ ⵓⵛⴰ ⵉⵙⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⵉⴹⴻⴳⴳⵯⴰⵍⴻⵏ ⵏⵏⴻⵙ, ⵉⵏⵏⵉ ⵉⴳⴳⵉⵏ ⴰⴷ ⵎⴻⵍⵛⴻⵏ ⵢⴻⵙⵙⵉⵙ, ⵉⵏⵏⴰ: “ⴽⴽⴰⵔⴻⵎ, ⴼⴼⵖⴻⵎ ⵣⴻⴳ ⵡⴻⵎⵛⴰⵏ-ⴰ, ⵎⵉⵏⵣⵉ ⵙⵉⴷⵉ ⴰⴷ ⵢⴰⵔⴻⴷⴷⴻⴵ ⵜⴰⵏⴷⵉⵏⵜ-ⴰ.” ⵎⴰⵛⴰ ⵉⴱⴰⵏ-ⴷⴷ ⵉⵜⵜⵇⴻⵚⵚⴰⵔ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵉⴹⴻⴳⴳⵯⴰⵍⴻⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","ⵓⵎⵉ ⵉⵚⴱⴻⵃ ⵍⵀⴰⵍ, ⵙⵙⵇⴻⴵⵇⴻⵏⵜ ⵍⵎⴰⵍⴰⴽⴰⵜ ⵍⵓⵟ, ⵏⵏⴰⵏⵜ: “ⴽⴽⴰⵔ, ⵜⴻⴽⵙⵉⴷ ⵜⴰⵎⵖⴰⵔⵜ ⵏⵏⴻⵛ ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵢⴻⵙⵙⵉⵛ, ⵜⵉⵏⵏⵉ ⴰⴽⵉⴷⴻⴽ, ⵃⵉⵎⴰ ⵡⴰⵔ ⵜⵀⴻⵍⵍⵉⴽⴻⴷ ⵛⴰ ⴷⵉ ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ ⵏ ⵜⴻⵏⴷⵉⵏⵜ-ⴰ.” ");
INSERT INTO rift_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","ⵎⴰⵛⴰ ⵏⴻⵜⵜⴰ ⵡⴰⵔ ⵉⵣⵄⵉⵎ. ⵅⴻⵏⵏⵉ ⵟⵟⴼⴻⵏ ⵉⵔⵢⴰⵣⴻⵏ ⵏⵏⵉ ⴰⴼⵓⵙ ⵏⵏⴻⵙ ⴷ ⵓⴼⵓⵙ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ ⴷ ⵉⴼⴰⵙⵙⴻⵏ ⵏ ⵜⵏⴰⵢⴻⵏ ⵏ ⵢⴻⵙⵙⵉⵙ, ⵎⵉⵏⵣⵉ ⵙⵉⴷⵉ ⵜⵓⵖⴰ ⵉⵅⵙ ⴰⴷ ⵅⴰⵙ ⵉⵃⵉⵏⵏ. ⵏⵉⵜⵏⵉ ⵙⵙⵓⴼⴼⵖⴻⵏ ⵜ ⵖⴰⵔ ⴱⴰⵔⵔⴰ, ⵏⴻⴷⵀⴻⵏ ⵜ ⴱⴰⵔⵔⴰ ⵉ ⵜⴻⵏⴷⵉⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","ⴰⵍⴰⵎⵉ ⵜⴻⵏ ⵙⵙⵓⴼⴼⵖⴻⵏ ⴱⴰⵔⵔⴰ, ⵉⵏⵏⴰ ⵏⴻⵜⵜⴰ: “ⵙⴻⵏⵊⴻⵎ ⵉⵅⴻⴼ ⵏⵏⴻⵛ! ⵡⴰⵔ ⵅⴻⵣⵣⴰⵔ ⴰⵡⴰⵔⵏⵉ ⴰⵛ, ⵡⴰⵔ ⵜⵜⴱⴻⴷⴷⵉ ⴷⵉ ⵊⵊⵉⵀⴻⵜ-ⴰ ⴰⵎ ⵜⴻⴽⵎⴻⵍ. ⴰⵔⵡⴻⵍ ⵖⴰⵔ ⵉⴷⵓⵔⴰⵔ, ⵃⵉⵎⴰ ⵡⴰⵔ ⵜᵉⵜⵜⵡⴰⵜⴻⵃⵃⵉⴷ ⵛⴰ.” ");
INSERT INTO rift_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","ⵉⵏⵏⴰ ⴰⵙⴻⵏ ⵍⵓⵟ: “ⵍⵍⴰ, ⵜⵜⵣⴰⵡⴰⴳⴻⵖ, ⴰ ⵙⵉⴷⵉ ⵉⵏⵓ! ");
INSERT INTO rift_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","ⵅⵣⴰⵔ, ⴰⵎⵙⴻⵅⵅⴰⵔ ⵏⵏⴻⵛ ⵢⵓⴼⴰ ⴰⵔⴹⴰ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵛ, ⵡⴰⵀ ⵜⴻⵙⵙⴻⵎⵖⴰⵔⴻⴷ ⵜⴰⵎⴻⵅⵙⵉⵡⵜ ⵏⵏⴻⵛ ⵉⵛⴻⵡⵡⴰⵔⴻⵏ, ⵜⴻⵏⵏⵉ ⴽⵉⴷⵉ ⵜⴻⴳⴳⵉⴷ ⵓⵎⵉ ⴷ ⴰⵢⵉ ⵜⴻⵊⵊⵉⴷ ⴷⴷⴰⵔⴻⵖ. ⵎⴰⵛⴰ ⵡⴰⵔ ⵣⴻⵎⵎⴰⵔⴻⵖ ⴰⴷ ⴰⵔⴻⵡⵍⴻⵖ ⵖⴰⵔ ⵉⴷⵓⵔⴰⵔ ⵇⴱⴻⵍ ⴷ ⴰⵢⵉ ⵖⴰ ⵉⵟⵟⴻⴼ ⵍⵖⴰⵔ ⵓⵛⴰ ⴰⴷ ⵎⵎⵜⴻⵖ! ");
INSERT INTO rift_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","ⵅⵣⴰⵔ ⵍⴻⵅⵅⵓ, ⵜⴰⵏⴷⵉⵏⵜ-ⴰ ⴰⵇⴰ ⵜⵓⴷⴻⵙ-ⴷⴷ ⴰⵟⵟⴰⵙ, ⴰⵇⴰ ⵣⴻⵎⵎⴰⵔⴻⵖ ⴰⴷ ⴷⵉⵏⵏⵉ ⴰⵔⴻⵡⵍⴻⵖ. ⵏⴻⵜⵜⴰⵜ ⴷ ⵜⴰⵎⴻⵄⵏⴰⵏⵓⵛⵜ. ⴻⵊⵊ ⴰⵢⵉ ⴰⴷ ⴰⵔⴻⵡⵍⴻⵖ ⵍⴻⵅⵅⵓ ⴷⵉⵏⵏⵉ. ⵎⴰ ⵡⴰⵔ ⵜⴻⴵⵉ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵏⴷⵉⵏⵜ ⴷ ⵜⴰⵎⴻⵄⵏⴰⵏⵓⵛⵜ? ⵅⴻⵏⵏⵉ ⵣⴻⵎⵎⴰⵔⴻⵖ ⴰⴷ ⵇⵇⵉⵎⴻⵖ ⴷⴷⴰⵔⴻⵖ.” ");
INSERT INTO rift_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","ⵢⴰⵔⵔⴰ-ⴷⴷ ⵅⴰⵙ: “ⵅⵣⴰⵔ, ⵜⵉⵡⴻⴹ ⴰⵢⵉ-ⴷⴷ ⵄⴰⵡⴻⴷ ⵜⵣⴰⵡⴻⴳⵜ ⵏⵏⴻⵛ ⵅ ⵓⵢⴰ, ⵡⴰⵔ ⵜⵜⴰⵔⴻⴷⴷⴵⴻⵖ ⵛⴰ ⵜⴰⵏⴷⵉⵏⵜ ⵎⵉⵏ ⵅⴻⴼ ⵜⴻⵙⵙⵉⵡⵍⴻⴷ. ");
INSERT INTO rift_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","ⵇⴻⴵⴻⵇ, ⴰⵔⵡⴻⵍ ⴷⵉⵏ, ⵎⵉⵏⵣⵉ ⵡⴰⵔ ⵣⴻⵎⵎⴰⵔⴻⵖ ⴰⴷ ⴳⴳⴻⵖ ⵡⴰⵍⵓ ⴰⵍ ⴷⴷ ⵖⴰ ⵜⴰⵡⴹⴻⴷ ⵖⴰⵔ ⴷⵉⵏⵏⵉ.” ⵅ ⵓⵢⴰ ⵙⴻⵎⵎⴰⵏ ⵉⵙⴻⵎ ⵏ ⵜⴻⵏⴷⵉⵏⵜ ⵏⵏⵉ ⵚⵓⵖⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","ⴰⵍⴰⵎⵉ ⵢⵉⵡⴻⴹ ⵍⵓⵟ ⵖⴰⵔ ⵚⵓⵖⴰⵔ, ⵜⴻⵏⵇⴰⵔ-ⴷⴷ ⵜⴼⵓⵛⵜ ⵅ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","ⵉⵊⵊⴰ ⵙⵉⴷⵉ ⴰⴷ ⵉⵡⵡⴻⵜ ⵡⴻⵏⵥⴰⵔ ⵅ ⵙⴰⴷⵓⵎ ⵓ ⵅ ⵄⴰⵎⵓⵔⵔⴰ, ⴷ ⵍⴻⵛⴱⴰⵔⴻⵢⵢⴻⵜ ⴷ ⵜⵎⴻⵙⵙⵉ ⵣⴻⴳ ⵓⵊⴻⵏⵏⴰ ⵣⵉ ⵖⴰⵔ ⵙⵉⴷⵉ.    ");
INSERT INTO rift_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","ⵢⴰⵔⴻⴷⴷⴻⴵ ⵏⴻⵜⵜⴰ ⵜⵉⵏⴻⴷⴷⴰⵎ ⵏⵏⵉ ⴷ ⵎⴰⵔⵔⴰ ⴰⴷⴻⵡⵡⴰⵔ ⵏⵏⵉ, ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⵉⵎⴻⵣⴷⴰⵖ ⵏ ⵜⵏⴻⴷⴷⴰⵎ ⵏⵏⵉ ⵓⵍⴰ ⴷ ⴰⵖⴻⵎⵎⵓⵢ ⵏ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","ⵜⴰⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ, ⵜⴻⵏⵏⵉ ⵜⵓⵢⵓⵔ ⵖⴰⵔ ⴹⴻⴼⴼⴰⵔ ⵏⵏⴻⵙ, ⵜⴻⵅⵣⴰⵔ ⴰⵡⴰⵔⵏⵉ ⴰⵙ ⵓⵛⴰ ⵜⴻⴷⵡⴻⵍ ⴷ ⵉⵊⵊ ⵏ ⵓⵇⴻⵍⵍⵉⵊ ⵏ ⵜⵎⴻⴵⴰⵃⵜ. ");
INSERT INTO rift_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","ⵖⴰⵔ ⵚⵚⴱⴻⵃ ⵣⵉⵛ ⵉⴽⴽⴰⵔ ⵉⴱⵔⴰⵀⵉⵎ, ⵢⵓⵢⵓⵔ ⵖⴰⵔ ⵡⴻⵎⵛⴰⵏ ⵎⴰⵏⵉ ⵜⵓⵖⴰ ⵉⴱⴻⴷⴷ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","ⵉⵙⵡⴻⴹ ⵖⴰⵔ ⵙⴰⴷⵓⵎ ⴷ ⵄⴰⵎⵓⵔⵔⴰ ⵓ ⵖⴰⵔ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵓⴷⴻⵡⵡⴰⵔ ⵏⵏⵉ, ⵓⵛⴰ ⵉⵥⵔⴰ ⴱⴻⵍⵍⵉ ⴷⴷⴻⵅⵅⴰⵏ ⵉⵜⵜⴳⴻⵄⵄⴰⴷ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⴰⵎ ⴷⴷⴻⵅⵅⴰⵏ ⵏ ⵉⵛⵜ ⵏ ⵜⴻⴼⵇⵓⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","ⴰⵍⴰⵎⵉ ⵢⴰⵔⴻⴷⴷⴻⴵ ⴰⵔⴻⴱⴱⵉ ⵜⵉⵏⴻⴷⴷⴰⵎ ⵏ ⵓⴷⴻⵡⵡⴰⵔ ⵏⵏⵉ, ⵉⴼⴻⴽⴽⴰⵔ ⴰⵔⴻⴱⴱⵉ ⴷⵉ ⵉⴱⵔⴰⵀⵉⵎ ⵓⵛⴰ ⵉⵙⵙⴻⴽⴽ ⵍⵓⵟ ⴱⴰⵔⵔⴰ ⵣⵉ ⵍⵡⴻⵙⵟ ⵏ ⵓⵛⴻⵍⵡⴰⵡ, ⵓⵎⵉ ⵉⵇⵍⴻⴱ ⵜⵉⵏⴻⴷⴷⴰⵎ ⵉ ⴷⵉ ⵉⵣⴷⴻⵖ ⵍⵓⵟ. ");
INSERT INTO rift_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","ⵉⴳⴻⵄⵄⴻⴷ ⵍⵓⵟ ⵣⵉ ⵚⵓⵖⴰⵔ ⵓⵛⴰ ⵉⵔⵓⵃ ⵉⵣⴷⴻⵖ ⴰⴽ-ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵢⴻⵙⵙⵉⵙ ⴷⴻⴳ ⵉⴷⵓⵔⴰⵔ, ⵎⵉⵏⵣⵉ ⵉⴳⴳⵯⴻⴷ ⴰⴷ ⵉⵇⵇⵉⵎ ⵉⵣⴻⴷⴷⴻⵖ ⴷⵉ ⵚⵓⵖⴰⵔ. ⵓⵛⴰ ⵉⵣⴷⴻⵖ ⴷⴻⴳ ⵉⴼⵔⵉ ⴰⴽ-ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵢⴻⵙⵙⵉⵙ. ");
INSERT INTO rift_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","ⵜⴻⵏⵏⴰ ⵜⵎⴻⵏⵣⵓⵜ ⵉ ⵜⵎⴰⵥⵓⵥⵜ: “ⴱⴰⴱⴰⵜⵏⴻⵖ ⴷ ⴰⵡⴻⵙⵙⴰⵔ, ⵡⴰⵔ ⵉⵇⵇⵉⵎ ⵓⵄⴻⵣⵔⵉ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⴰⴷ ⵅⴰⵏⴻⵖ ⴷⴷ-ⵢⴰⴷⴻⴼ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⴻⴳⴳⵓⵔ ⴷⵉ ⵎⴰⵔⵔⴰ ⴷⴷⵓⵏⴻⵛⵜ. ");
INSERT INTO rift_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","ⵣⵉⴷ, ⴻⵊⵊ ⴰⵏⴻⵖ ⴰⴷ ⵏⴻⵡⵛ ⴱⵉⵏⵓ ⵉ ⴱⴰⴱⴰⵜⵏⴻⵖ ⴰⴷ ⵉⵙⵙⵓ ⵓⵛⴰ ⴰⴷ ⴽⵉⵙ ⵏⴻⵣⵣⴻⵍ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵏⴻⵡⵛ ⵜⵓⴷⴰⵔⵜ ⵉ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏ ⴱⴰⴱⴰⵜⵏⴻⵖ.” ");
INSERT INTO rift_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","ⴷⵉ ⴵⵉⵍⴻⵜ ⵏⵏⵉ ⵡⵛⵉⵏⵜ ⴱⵉⵏⵓ ⵉ ⴱⴰⴱⴰⵜⵙⴻⵏⵜ, ⵉⵙⵡⴰ. ⵅⴻⵏⵏⵉ ⵜⵓⴷⴻⴼ ⵜⵎⴻⵏⵣⵓⵜ, ⵜᵉⵟⵟⴻⵚ ⴰⴽ-ⴷ ⴱⴰⴱⴰⵙ, ⵎⴰⵛⴰ ⵏⴻⵜⵜⴰ ⵡⴰⵔ ⵢⵓⵛⵉ ⵛⴰ ⴱⴻⵍⵍⵉ ⵜⴻⵣⵣⴻⵍ ⴰⴽⵉⴷⴻⵙ ⵏⵉⵖ ⵜⴻⴽⴽⴰⵔ ⵄⴰⵡⴻⴷ. ");
INSERT INTO rift_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","ⵜⵉⵡⴻⵛⵛⴰ ⵏⵏⴻⵙ ⵜⴻⵏⵏⴰ ⵜⵎⴻⵏⵣⵓⵜ ⵉ ⵜⵎⴰⵥⵓⵥⵜ: “ⴰⵇⴰ ⵏⴻⵛⵛ ⵣⵣⵍⴻⵖ ⴵⵉⵔⴻⵜ ⵉⵄⴷⵓⵏ ⴰⴽ-ⴷ ⴱⴰⴱⴰ, ⴰⴷ ⴰⵙ ⵏⴻⵡⵛ ⴰⴷ ⵉⵙⵙⵓ ⴱⵉⵏⵓ ⵄⴰⵡⴻⴷ ⴵⵉⵔⴻⵜ-ⴰ. ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⴰⴷⴼⴻⴷ ⵛⴻⵎ ⴰⴷ ⴽⵉⴷⴻⵙ ⵜⴻⵣⵣⵍⴻⴷ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴷⴷ-ⵏⴻⵊⵊ ⵊⵊⵉⵍ ⴰⴷ ⵉⵇⵇⵉⵎ ⵉⴷⴷⴰⵔ ⵣⵉ ⵥⵥⴰⵔⵉⵄⴻⵜ ⵏ ⴱⴰⴱⴰⵜⵏⴻⵖ.” ");
INSERT INTO rift_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","ⵡⵛⵉⵏⵜ ⴱⵉⵏⵓ ⵉ ⴱⴰⴱⴰⵜⵙⴻⵏⵜ ⵄⴰⵡⴻⴷ ⴷⵉ ⴵⵉⵔⴻⵜ ⵏⵏⵉ, ⵉⵙⵡⴰ. ⵅⴻⵏⵏⵉ ⵜⴻⴽⴽⴰⵔ ⵜⵎⴰⵥⵓⵥⵜ ⵓⵛⴰ ⵜᵉⵟⵟⴻⵚ ⴰⴽ-ⴷ ⴱⴰⴱⴰⵙ. ⵎⴰⵛⴰ ⵏⴻⵜⵜⴰ ⵡⴰⵔ ⵢⵓⵛⵉ ⵛⴰ ⴱⴻⵍⵍⵉ ⵜⴻⵣⵣⴻⵍ ⴰⴽⵉⴷⴻⵙ ⵏⵉⵖ ⵜⴻⴽⴽⴰⵔ ⵄⴰⵡⴻⴷ. ");
INSERT INTO rift_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","ⴰⵎⵎⵓ ⴽⵙⵉⵏⵜ ⵜⵏⴰⵢⴻⵏ ⵏ ⵢⴻⵙⵙⵉⵙ ⵏ ⵍⵓⵟ ⵙ ⴷⴷⴻⵢⵙⴻⵜ ⵣⵉ ⴱⴰⴱⴰⵜⵙⴻⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","ⵓⵛⴰ ⵜⵓⵔⵓⵡ-ⴷⴷ ⵜⵎⴻⵏⵣⵓⵜ ⴰⵙⴻⵢⵎⵉ, ⵜⵍⴰⵖⴰ ⵉⵙⴻⵎ ⵏⵏⴻⵙ ⵎⵓ’ⴰⴱ. ⵡⴰ ⴷ ⴱⴰⴱⴰⵜⵙⴻⵏⵜ ⵏ ⴰⵢⵜ ⵏ ⵎⵓ’ⴰⴱ ⵖⴰⵔ ⴰⵙⵙ-ⴰ. ");
INSERT INTO rift_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","ⵜⴰⵎⴰⵥⵓⵥⵜ ⵄⴰⵡⴻⴷ ⵜⵓⵔⵓⵡ-ⴷⴷ ⴰⵙⴻⵢⵎⵉ ⵓⵛⴰ ⵜⵍⴰⵖⴰ ⵉⵙⴻⵎ ⵏⵏⴻⵙ ⴱⴻⵏ-ⵄⴰⵎⵎⵉ. ⵏⴻⵜⵜⴰ ⴷ ⴱⴰⴱⴰⵜⵙⴻⵏ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵄⴰⵎⵎⵓⵏ ⵖⴰⵔ ⴰⵙⵙ-ⴰ. ");
INSERT INTO rift_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","ⵙⵙⴻⵏⵏⵉ ⵉⵙⵙⵎⵓⵟⵟⵉⵢ ⵉⴱⵔⴰⵀⵉⵎ ⵉⵇⵉⴹⴰⵏ ⵏⵏⴻⵙ, ⵢⵓⵢⵓⵔ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵍⵊⴰⵏⵓⴱ. ⵉⵣⴷⴻⵖ ⵏⴻⵜⵜⴰ ⵊⴰⵔ ⵇⴰⴷⴰⵛ ⴷ ⵛⵓⵔ ⵓⵛⴰ ⵉⵇⵇⵉⵎ ⴰⵎ ⵓⴱⴰⵔⵔⴰⵏⵉ ⴷⵉ ⵊⵉⵔⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","ⵓⵎⵉ ⵉⵏⵏⴰ ⵉⴱⵔⴰⵀⵉⵎ ⵅ ⵙⴰⵔⴰ ⵜⴰⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ: “ⵏⴻⵜⵜⴰⵜ ⴷ ⵓⵞⵎⴰ ⵉ ⵜⴻⴵⴰ!”, ⵉⵙⵙⴻⴽⴽ ⴰⴱⵉⵎⴰⵍⵉⴽ, ⴰⵊⴻⴵⵉⴷ ⵏ ⵊⵉⵔⴰⵔ, ⵢⵉⵡⵉ ⴰⴽⵉⵙ ⵙⴰⵔⴰ.    ");
INSERT INTO rift_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","ⵎⴰⵛⴰ ⵉⴹⵀⴰⵔ-ⴷⴷ ⴰⵔⴻⴱⴱⵉ ⵉ ⴰⴱⵉⵎⴰⵍⵉⴽ ⴷⵉ ⵜⴰⵔⵊⵉⵜ ⵏ ⴵⵉⵔⴻⵜ, ⵉⵏⵏⴰ ⴰⵙ: “ⴰⵇⴰ ⵍⴻⵅⵅⵓ ⴰⴷ ⵜⴻⵎⵎⵜⴻⴷ ⴷⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⵜⴻⵎⵖⴰⵔⵜ, ⵜⴻⵏⵏⵉ ⴷⴷ-ⵜⵉⵡⵢⴻⴷ ⴰⴽⵉⴷⴻⴽ, ⵎⵉⵏⵣⵉ ⵏⴻⵜⵜⴰⵜ ⵜⴻⵎⵍⴻⵛ ⴰⴽ-ⴷ ⵡⴻⵔⵢⴰⵣ.” ");
INSERT INTO rift_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","ⵎⴰⵛⴰ ⴰⴱⵉⵎⴰⵍⵉⴽ ⵜⵓⵖⴰ ⵡⴰⵔ ⵖⴰⵔⴻⵙ ⴷⴷ-ⵉⵇⴰⵔⵔⴻⴱ, ⵉⵏⵏⴰ: “ⴰ ⵙⵉⴷⵉ ⵉⵏⵓ, ⵎⴰ ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⴰⵡⴹⴻⴷ ⴰⴷ ⵜⴻⵏⵖⴻⴷ ⵉⵊⵊ ⵏ ⵍⴳⴻⵏⵙ ⵉⵙⴻⴳⴳⴷⴻⵏ? ");
INSERT INTO rift_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","ⵎⴰ ⵡⴰⵔ ⴷ ⴰⵢⵉ ⵉⵏⵏⵉ ⵏⴻⵜⵜⴰ: ‘ⵏⴻⵜⵜⴰⵜ ⴷ ⵓⵞⵎⴰ ⵉ ⵜⴻⴵⴰ!’, ⵓ ⵏⴻⵜⵜⴰⵜ ⵙ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵜⴻⵏⵏⴰ ⵄⴰⵡⴻⴷ: ‘ⵏⴻⵜⵜⴰ ⴷ ⵓⵎⴰ ⵉ ⵢⴻⴵⴰ!’ ⵙ ⵜⵉⴷⴻⵜⵜ ⵏ ⵡⵓⵍ ⵓ ⵙ ⵉⴼⴰⵙⵙⴻⵏ ⵉⵣⴷⵉⴳⴻⵏ ⵉ ⴳⴳⵉⵖ ⴰⵢⴰ.” ");
INSERT INTO rift_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","ⵉⵏⵏⴰ ⴰⵙ ⴰⵔⴻⴱⴱⵉ ⴷⵉ ⵜⴰⵔⵊⵉⵜ: “ⵏⴻⵛⵛ ⵙⵙⵏⴻⵖ ⵄⴰⴷ ⴱⴻⵍⵍⵉ ⵜⴻⴳⴳⵉⴷ ⵎⴰⵏ ⴰⵢⴰ ⵙ ⵜⵉⴷⴻⵜⵜ ⵏ ⵡⵓⵍ, ⵅ ⵓⵢⴰ ⵃⴹⵉⵖ ⵛⴻⴽ ⵃⵉⵎⴰ ⵡⴰⵔ ⵅⴰⴼⵉ ⵜⵅⴻⵟⵟⵉⴹ ⵓ ⵡⴰⵔ ⵛⴻⴽ ⵊⵊⵉⵖ ⴰⴷ ⵜⵜ ⵜⵃⴰⴷⵉⴷ. ");
INSERT INTO rift_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","ⵍⴻⵅⵅⵓ, ⴰⵔⵔ ⵜⴰⵎⵖⴰⵔⵜ ⵖⴰⵔ ⵡⴻⵔⵢⴰⵣ ⵏⵏⴻⵙ, ⵎⵉⵏⵣⵉ ⵏⴻⵜⵜⴰ ⴷ ⴰⵏⴰⴱⵉ ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⴰⴷ ⵅⴰⴽ ⵉⵥⵥⴰⴵ, ⵃⵉⵎⴰ ⴰⴷ ⵜⴻⴷⴷⴰⵔⴻⴷ. ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⵡⴰⵔ ⵜⵜ ⵜⴰⵔⵔⵉⴷ ⵛⴰ, ⵙⵙⴻⵏ ⴱⴻⵍⵍⵉ ⴰⵇⴰ ⴰⴷ ⵜⴻⵎⵎⵜⴻⴷ, ⵛⴻⴽ ⴷ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⴵⴰⵏ ⵏⵏⴻⵛ!” ");
INSERT INTO rift_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","ⵉⴽⴽⴰⵔ ⴰⴱⵉⵎⴰⵍⵉⴽ ⵣⵉⵛ ⵖⴰⵔ ⵚⵚⴱⴻⵃ. ⵉⵍⴰⵖⴰ ⵉ ⵎⴰⵔⵔⴰ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵙ, ⵉⵏⵏⴰ ⵎⴰⵔⵔⴰ ⴰⵡⴰⵍⴻⵏ-ⴰ ⴷⴻⴳ ⵉⵎⴻⵣⵣⵓⵖⴻⵏ ⵏⵙⴻⵏ ⵓⵛⴰ ⵉⵔⵢⴰⵣⴻⵏ ⵏⵏⵉ ⴷⴻⵡⵍⴻⵏ ⴳⴳⵯⴻⴷⴻⵏ ⴰⵟⵟⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","ⵅⴻⵏⵏⵉ ⵉⵍⴰⵖⴰ ⴰⴱⵉⵎⴰⵍⵉⴽ ⵅ ⵉⴱⵔⴰⵀⵉⵎ ⵓⵛⴰ ⵉⵏⵏⴰ ⴰⵙ: “ⵎⵉⵏ ⴷ ⴰⵏⴻⵖ ⵜⴻⴳⴳⵉⴷ ⴷ ⵎⵉⵏ ⴷⵉ ⵅⴹⵉⵖ ⴰⴽⵉⴷⴻⴽ ⵓⵎⵉ ⵜⵖⴻⴹⵔⴻⴷ ⵅⴰⴼⵉ ⵓ ⵅ ⵜⴳⴻⵍⴷⵉⵜ ⵉⵏⵓ ⴷⴷⴻⵏⴱ ⴰⵎⴻⵇⵇⵔⴰⵏ? ⵛⴻⴽ ⵜⴻⴳⴳⵉⴷ ⴰⴽⵉⴷⵉ ⵎⵉⵏ ⵡⴰⵔ ⵉⵛⵓⵡⵡⴰⵔⴻⵏ ⴰⴷ ⵜ ⵜⴻⴳⴳⴻⴷ.” ");
INSERT INTO rift_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","ⵓⵛⴰ ⵢⴰⵔⵏⵉ ⵉⵏⵏⴰ ⴰⴱⵉⵎⴰⵍⵉⴽ ⵉ ⵉⴱⵔⴰⵀⵉⵎ: “ⵎⵉⵏ ⵛⴻⴽ ⵢⴻⵊⵊⵉⵏ ⵍⴰⵎⵉ ⵜⴻⴳⴳⵉⴷ ⵎⴰⵏ ⴰⵢⴰ?” ");
INSERT INTO rift_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","ⵉⵏⵏⴰ ⵉⴱⵔⴰⵀⵉⵎ: “ⵎⵉⵏⵣⵉ ⵏⵡⵉⵖ: ‘ⵏⵉⵛⴰⵏ ⵡⴰⵔ ⴷⵉⵏⵏⵉ ⵜⵉⴳⴳⵯⵓⴷⵉ ⵣⵉ ⴰⵔⴻⴱⴱⵉ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ-ⴰ ⵓⵛⴰ ⴰⴷ ⴰⵢⵉ ⵏⵖⴻⵏ ⴷⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⵉⵏⵓ.’ ");
INSERT INTO rift_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","ⵓⵛⴰ ⵙ ⵜⵉⴷⴻⵜⵜ ⵏⴻⵜⵜⴰⵜ ⵄⴰⵡⴻⴷ ⴷ ⵓⵞⵎⴰ. ⵏⴻⵜⵜⴰⵜ ⴷ ⵢⴻⴵⵉⵙ ⵏ ⴱⴰⴱⴰ, ⵎⴰⵛⴰ ⵡⴰⵔ ⵜⴻⴵⵉ ⴷ ⵢⴻⴵⵉⵙ ⵏ ⵢⴻⵎⵎⴰ ⵓⵛⴰ ⵜⴻⴷⵡⴻⵍ ⴷ ⵜⴰⵎⵖⴰⵔⵜ ⵉⵏⵓ. ");
INSERT INTO rift_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","ⵓⵎⵉ ⴷ ⴰⵢⵉ ⵉⵙⵙⴻⵜⵍⴻⵄ ⴰⵔⴻⴱⴱⵉ ⵣⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⴱⴰⴱⴰ, ⵏⵏⵉⵖ ⴰⵙ: ‘ⴰⴷ ⵢⵉⵍⵉ ⵡⴰ ⴷ ⵍⴻⵄⵍⴰⵎⴻⵜ ⵏ ⵜⵎⴻⵅⵙⵉⵡⵜ ⵏⵏⴻⵛ ⵉⵛⴻⵡⵡⴰⵔⴻⵏ ⵉ ⵏⴻⵛⵛ, ⴰⵇⴰ ⴰⴷ ⵜⵉⵏⵉⴷ ⴷⵉ ⵎⴰⵔⵔⴰ ⵉⵎⵓⵛⴰⵏ ⵎⴰⵏⵉ ⵖⴰ ⵏⴰⵡⴻⴹ: ⵏⴻⵜⵜⴰ ⴰⵇⴰ ⴷ ⵓⵎⴰ!’” ");
INSERT INTO rift_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","ⵅⴻⵏⵏⵉ ⵉⴽⵙⵉ ⴰⴱⵉⵎⴰⵍⵉⴽⵉ ⵓⴵⵉ ⴷ ⵉⴼⵓⵏⴰⵙⴻⵏ ⴷ ⵜⴼⵓⵏⴰⵙⵉⵏ ⴷ ⵉⵙⴻⵎⵖⴰⵏ ⴷ ⵜⵉⵢⵢⴰ ⵓⵛⴰ ⵉⵡⵛⴰ ⵉ-ⵜⴻⵏ ⵉ ⵉⴱⵔⴰⵀⵉⵎ ⵓⵛⴰ ⵢⴰⵔⵔ ⴰⵙ ⵙⴰⵔⴰ, ⵜⴰⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","ⵉⵏⵏⴰ ⴰⴱⵉⵎⴰⵍⵉⴽ: “ⵅⵣⴰⵔ, ⵜⴰⵎⵎⵓⵔⵜ ⵉⵏⵓ ⴰⵇⴰ-ⵜⵜ ⵇⵉⴱⴰⵍⵜ ⵏⵏⴻⵛ. ⵣⴷⴻⵖ ⵎⴰⵏⵉ ⵉ ⴷ ⴰⵛ ⴷⴷ-ⵉⴹⵀⴰⵔ ⵎⵍⵉⵃ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵛ.” ");
INSERT INTO rift_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","ⵉ ⵙⴰⵔⴰ ⵉⵏⵏⴰ: “ⵅⵣⴰⵔ, ⵡⵛⵉⵖ ⴰⵍⴻⴼ ⵏ ⵓⵇⵉⵢⵢⴰⵜ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵉ ⵓⵎⴰⵎ. ⴰⵇⴰ ⴰⵜⴻⵏⵜ ⴷ ⴰⵍⴻⵃⵃⴰⴼ ⵅ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵉ ⴽⵓⵍⵛⵉ ⵉⵏⵏⵉ ⴽⵉⴷⴻⵎ ⵉⴵⴰⵏ, ⵡⴰⵀ, ⵉ ⴽⵓⵍⵛⵉ ⵉⴷⵡⴻⵍ ⴰⵎ-ⴷⴷ ⴷ ⵜⵜⵉⵇⴰⵔⵜ.” ");
INSERT INTO rift_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","ⵉⵥⵥⵓⴵ ⵉⴱⵔⴰⵀⵉⵎ ⵉ ⴰⵔⴻⴱⴱⵉ ⵓⵛⴰ ⴰⵔⴻⴱⴱⵉ ⵉⵙⵙⴳⴻⵏⴼⴰ ⴰⴱⵉⵎⴰⵍⵉⴽ ⴷ ⵜⴻⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ ⴷ ⵜⴻⵎⵙⴻⵅⵅⴰⵔⵉⵏ ⵏⵏⴻⵙ ⵓⵛⴰ ⵓⵔⵡⴻⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","ⵎⵉⵏⵣⵉ ⵜⵓⵖⴰ ⵙⵉⴷⵉ ⵉⴱⴻⵍⵍⴻⵄ ⵇⴰⵄ ⵎⴰⵔⵔⴰ ⵍⴻⵎⵍⴰⵡⴰⵜ ⵏ ⵜⴻⵎⵖⴰⵔⵉⵏ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⴰⴱⵉⵎⴰⵍⵉⴽ ⴷⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⵙⴰⵔⴰ, ⵜⴰⵎⵖⴰⵔⵜ ⵏ ⵉⴱⵔⴰⵀⵉⵎ. ");
INSERT INTO rift_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","ⵓⵛⴰ ⵢⴰⵔⵣⴻⴼ ⵙⵉⴷⵉ ⵖⴰⵔ ⵙⴰⵔⴰ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜ ⵉⵏⵏⴰ, ⵓⵛⴰ ⵉⴽⴻⵎⵎⴻⵍ ⵙⵉⴷⵉ ⴰⵡⴰⵍ ⵉ ⵉⵏⵏⴰ ⵉ ⵙⴰⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","ⵜⴻⴽⵙⵉ ⵙⴰⵔⴰ ⵙ ⴷⴷⴻⵢⵙⴻⵜ ⵓⵛⴰ ⵜⵓⵔⵓⵡ-ⴷⴷ ⵉⵊⵊ ⵏ ⵓⵙⴻⵢⵎⵉ ⵉ ⵉⴱⵔⴰⵀⵉⵎ ⵅ ⵜⴻⵡⵙⴰⵔ ⵏⵏⴻⵙ, ⴷⵉ ⵍⵎⵉⵊⴰⵔ ⵏⵏⵉ ⵉ ⴷ ⴰⵙ ⵉⵏⵏⴰ ⴰⵔⴻⴱⴱⵉ. ");
INSERT INTO rift_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","ⵓⵛⴰ ⵉⵍⴰⵖⴰ ⵉⴱⵔⴰⵀⵉⵎ ⵉ ⵎⵎⵉⵙ ⴰⵙⴻⵢⵎⵉ, ⵡⴻⵏⵏⵉ ⴷ ⴰⵙ ⴷⴷ-ⵜⵓⵔⵓⵡ ⵙⴰⵔⴰ, ⵉⵙⵃⴰⵇ. ");
INSERT INTO rift_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","ⵉⴱⵔⴰⵀⵉⵎ ⵉⵅⵜⴻⵏ ⵉ ⵎⵎⵉⵙ ⵉⵙⵃⴰⵇ ⵓⵎⵉ ⵜⵓⵖⴰ ⵖⴰⵔⴻⵙ ⵜⵎⴻⵏⵢⴰ ⵏ ⵡⵓⵙⵙⴰⵏ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵙ ⵢⵓⵎⵓⵔ ⴰⵔⴻⴱⴱⵉ. ");
INSERT INTO rift_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","ⵜⵓⵖⴰ ⵖⴰⵔ ⵉⴱⵔⴰⵀⵉⵎ ⵎⵢⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⴰⵍⴰⵎⵉ ⵖⴰⵔⴻⵙ ⴷⴷ-ⵉⵅⵍⴻⵇ ⵎⵎⵉⵙ ⵉⵙⵃⴰⵇ. ");
INSERT INTO rift_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","ⵜⴻⵏⵏⴰ ⵙⴰⵔⴰ: “ⵉⵙⵙⴻⴹⵃⴻⵛ ⴰⵢⵉ ⴰⵔⴻⴱⴱⵉ ⵓ ⴽⵓⵍ ⵉⵊⵊ ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵉⵙⵍⴰⵏ ⵉ ⵎⴰⵏ ⴰⵢⴰ, ⴰⴷ ⵉⴹⵃⴻⵛ ⵄⴰⵡⴻⴷ ⴰⴽⵉⴷⵉ.” ");
INSERT INTO rift_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","ⵜⴻⵏⵏⴰ ⵄⴰⵡⴻⴷ: “ⵎⴰⵏ ⵡⴻⵏ ⵉⵣⴻⵄⵎⴻⵏ ⴰⴷ ⵢⵉⵏⵉ ⵉ ⵉⴱⵔⴰⵀⵉⵎ, ⴰⵇⴰ ⵙⴰⵔⴰ ⴰⴷ ⵜⴻⵙⵙⵓⵟⵟⴻⴹ ⵉⵙⴻⵢⵎⴰⵏ? ⴰⵇⴰ ⵓⵔⵡⴻⵖ ⴰⵙ-ⴷⴷ ⴰⵃⴻⵏⵊⵉⵔ ⵅ ⵜⴻⵡⵙⴰⵔ ⵏⵏⴻⵙ!” ");
INSERT INTO rift_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","ⵉⴳⵎⴰ ⵓⵙⴻⵢⵎⵉ ⵓⵛⴰ ⵉⵜⵜⵡⴰⴽⴽⴻⵙ ⴰⵙ ⵓⵟⵟⵓⴹ. ⴷⴻⴳ ⵡⴰⵙⵙ ⵉ ⴷ ⴰⵙ ⴽⴽⵙⴻⵏ ⵓⵟⵟⵓⴹ ⵉ ⵉⵙⵃⴰⵇ, ⵉⵙⵙⴻⵡⵊⴻⴷ ⵉⴱⵔⴰⵀⵉⵎ ⵉⵛⵜ ⵏ ⵣⵣⴰⵔⴷⴻⵜ ⵜⴻⵎⵖⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","ⵓⵎⵉ ⵜⴻⵥⵔⴰ ⵙⴰⵔⴰ ⵎⵎⵉⵙ ⵏ ⵜⵎⵉⵚⵔⴻⵛⵜ ⵀⴰⵊⴰⵔ, ⵡⴻⵏⵏⵉ ⴷⴷ-ⵜⵓⵔⵓⵡ ⵀⴰⵊⴰⵔ ⵉ ⵉⴱⵔⴰⵀⵉⵎ, ⵉⵇⴻⵚⵚⴰⵔ ⵅⴰⵙ, ");
INSERT INTO rift_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","ⵜⴻⵏⵏⴰ ⵉ ⵉⴱⵔⴰⵀⵉⵎ: “ⴰⵥⵥⴻⵍ ⵅ ⵜⴰⵢⵢⴰ-ⵢⴰ ⴷ ⵎⵎⵉⵙ, ⵎⵉⵏⵣⵉ ⵎⵎⵉⵙ ⵏ ⵜⴰⵢⵢⴰ-ⵢⴰ ⵡⴰⵔ ⵉⵡⴰⵔⵔⴻⵜ ⵛⴰ ⴰⴽ-ⴷ ⵎⵎⵉ, ⴰⴽ-ⴷ ⵉⵙⵃⴰⵇ.” ");
INSERT INTO rift_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","ⴰⵡⴰⵍ-ⴰ ⵉⴱⴰⵏ-ⴷⴷ ⴷ ⴰⵄⴻⴼⴼⴰⵏ ⴰⵟⵟⴰⵙ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵉⴱⵔⴰⵀⵉⵎ ⴷⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⵎⵎⵉⵙ. ");
INSERT INTO rift_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","ⵎⴰⵛⴰ ⵉⵏⵏⴰ ⴰⵔⴻⴱⴱⵉ ⵉ ⵉⴱⵔⴰⵀⵉⵎ: “ⵡⴰⵔ ⵜⵜⴻⵊⵊⵉ ⴰⵃⴻⵏⵊⵉⵔ ⴷ ⵜⴰⵢⵢⴰ ⵏⵏⴻⵛ ⴰⴷ ⵉⵍⵉⵏ ⴷ ⵜⵉⵙⵉⵏⴻⴼⵜ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵛ. ⵙⴻⵍ ⵖⴰⵔ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉ ⴷ ⴰⵛ ⵖⴰ ⵜⵉⵏⵉ ⵙⴰⵔⴰ, ⵎⵉⵏⵣⵉ ⴷⵉ ⵉⵙⵃⴰⵇ ⴰⴷ ⴰⵛ ⵜⵉⵍⵉ ⵣⵣⴰⵔⵉⵄⴻⵜ.    ");
INSERT INTO rift_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","ⴰⴷ ⴳⴳⴻⵖ ⵄⴰⵡⴻⴷ ⵉⵊⵊ ⵏ ⵍⴳⴻⵏⵙ ⵣⵉ ⵎⵎⵉⵙ ⵏ ⵜⴰⵢⵢⴰ-ⵢⴰ, ⵎⵉⵏⵣⵉ ⵓⵍⴰ ⴷ ⵏⴻⵜⵜⴰ ⴷ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵛ.” ");
INSERT INTO rift_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","ⵅⴻⵏⵏⵉ ⵉⴽⴽⴰⵔ ⵉⴱⵔⴰⵀⵉⵎ ⵣⵉⵛ ⵓⵛⴰ ⵉⴽⵙⵉ ⴰⵖⵔⵓⵎ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵛⵢⴰⵔⵜ ⵏ ⵡⴰⵎⴰⵏ, ⵉⵡⵛⴰ ⵉ-ⵜⴻⵏ ⵉ ⵀⴰⵊⴰⵔ, ⵉⵙⵙⴰⵔⵙ ⴰⵙ ⵜⴻⵏ ⵅ ⵜⴻⵖⵔⵓⴹⵜ. ⵉⵡⵛⴰ ⴰⵙ ⵄⴰⵡⴻⴷ ⴰⵃⴻⵏⵊⵉⵔ ⵓⵛⴰ ⵉⵙⵙⵇⴻⴱⴱⴻⴹ ⵉ-ⵜⵜ. ⵓⵛⴰ ⵏⴻⵜⵜⴰⵜ ⵜⵔⵓⵃ, ⵜⴻⵏⵏⴻⵊⵔⵓ ⴷⵉ ⵍⴻⵅⵍⴰ ⵏ ⴱⵉ’ⵔ-ⵙⴻⴱⵄⴰ. ");
INSERT INTO rift_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","ⵍⴰⵎⵉ ⵏⴻⵇⵚⴻⵏ ⵡⴰⵎⴰⵏ ⵣⵉ ⵜⴻⵛⵢⴰⵔⵜ, ⵜⴻⵏⴹⴰⵔ ⴰⵃⴻⵏⵊⵉⵔ ⵙⴰⴷⵓ ⵉⵊⵊ ⵏ ⵛⴱⴰⵔⵇ, ");
INSERT INTO rift_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","ⵓⵛⴰ ⵜⵔⵓⵃ ⵜⴻⵇⵇⵉⵎ ⵇⵉⴱⴰⵍⵜ ⵏⵏⴻⵙ ⵍⴰⴳⴳⵯⴰⵊ ⵏ ⵜⴻⵛⵜⵉ ⵏ ⵍⵇⴻⵡⵙ, ⵎⵉⵏⵣⵉ ⵜⴻⵏⵏⴰ: “ⵡⴰⵔ ⵣⴻⵎⵎⴰⵔⴻⵖ ⴰⴷ ⵥⴰⵔⴻⵖ ⵎⴻⵍⵎⵉ ⵉ ⵖⴰ ⵉⵎⵎⴻⵜ ⵓⵃⴻⵏⵊⵉⵔ.” ⴰⵎⵎⵓ ⵉ ⵜⴻⵇⵇⵉⵎ ⵇⵉⴱⴰⵍⵜ ⵏⵏⴻⵙ ⵓⵛⴰ ⵜⴻⵙⵙⴳⴻⵄⵄⴻⴷ ⵜⵎⵉⵊⵊⴰ ⵏⵏⴻⵙ, ⵜⴻⵙⵖⵓⵢⵢⵓ. ");
INSERT INTO rift_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","ⵉⵙⵍⴰ ⴰⵔⴻⴱⴱⵉ ⵖⴰⵔ ⵜⵎⵉⵊⵊⴰ ⵏ ⵓⵃⴻⵏⵊⵉⵔ ⵓⵛⴰ ⵍⵎⴰⵍⴰⴽ ⵏ ⴰⵔⴻⴱⴱⵉ ⵉⵍⴰⵖⴰ ⵉ ⵀⴰⵊⴰⵔ ⵣⴻⴳ ⵓⵊⴻⵏⵏⴰ, ⵉⵏⵏⴰ ⴰⵙ: “ⵎⵉⵏ ⵛⴻⵎ ⵢⵓⵖⵉⵏ, ⵀⴰⵊⴰⵔ? ⵡⴰⵔ ⵜⵜⴻⴳⴳⵯⴻⴷ ⵛⴰ, ⵎⵉⵏⵣⵉ ⴰⵔⴻⴱⴱⵉ ⵉⵙⵍⴰ ⵍⵃⴻⵙⵙ ⵏ ⵓⵃⴻⵏⵊⵉⵔ, ⴷⵉⵏ ⵎⴰⵏⵉ ⵉⴵⴰ. ");
INSERT INTO rift_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","ⴽⴽⴰⵔ, ⵙⴳⴻⵄⵄⴻⴷ ⴰⵃⴻⵏⵊⵉⵔ ⵓⵛⴰ ⵟⵟⴻⴼ ⴰⵙ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏⵏⴻⵎ, ⵎⵉⵏⵣⵉ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⴳⴳⴻⵖ ⵉⵊⵊ ⵏ ⵍⴳⴻⵏⵙ ⵉⵎⵖⴰⵔ.” ");
INSERT INTO rift_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","ⵓⵛⴰ ⵢⴰⵔⵣⴻⵎ ⴰⵔⴻⴱⴱⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵙ, ⵜⴻⵥⵔⴰ ⵍⵄⵓⵏⵚⴰⵔ ⵏ ⵡⴰⵎⴰⵏ. ⵜⵔⵓⵃ, ⵜⵄⴻⵎⵎⴰⵔ ⵜⴰⵛⵢⴰⵔⵜ ⵙ ⵡⴰⵎⴰⵏ, ⵜⴻⵡⵛⴰ ⴰⵙ ⵉ ⵓⵃⴻⵏⵊⵉⵔ, ⴰⴷ ⵉⵙⵓ. ");
INSERT INTO rift_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","ⵜⵓⵖⴰ ⴰⵔⴻⴱⴱⵉ ⴰⴽ-ⴷ ⵓⵃⴻⵏⵊⵉⵔ, ⵉⵢⵎⴰ, ⵉⵣⴷⴻⵖ ⴷⵉ ⵍⴻⵅⵍⴰ ⵓ ⵜⵓⵖⴰ-ⵜ ⴷ ⴰⵎⵊⴻⴱⴱⴰⴷ ⵏ ⵍⵇⴻⵡⵙ. ");
INSERT INTO rift_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","ⵜⵓⵖⴰ ⵉⵣⴻⴷⴷⴻⵖ ⴷⵉ ⵍⴻⵅⵍⴰ ⵏ ⴼⴰⵔⴰⵏ ⵓⵛⴰ ⵜⴻⴽⵙⵉ ⴰⵙ-ⴷⴷ ⵢⴻⵎⵎⴰⵙ ⵜⴰⵎⵖⴰⵔⵜ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","ⴷⵉ ⵍⵡⴻⵇⵜ ⵏⵏⵉ ⴷ ⵉⵛⵜ ⵉⵎⵙⴰⵔ, ⴱⴻⵍⵍⵉ ⴰⴱⵉⵎⴰⵍⵉⴽ ⴰⴽ-ⴷ ⴼⵉⴽⵓⵍ, ⴰⴽⵓⵎⴰⵏⴷⴰⵔ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵏⴻⵙ, ⵉⵙⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⵉⴱⵔⴰⵀⵉⵎ, ⵉⵏⵏⴰ: “ⴰⵔⴻⴱⴱⵉ ⴰⵇⴰ-ⵜ ⴰⴽⵉⴷⴻⴽ ⴷⵉ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵜᵉⵜⵜⴻⴳⴳⴻⴷ. ");
INSERT INTO rift_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","ⵍⴻⵅⵅⵓ, ⵊⴰⴵ ⴰⵢⵉ ⵖⴰⵔ ⴰⵔⴻⴱⴱⵉ, ⴰⵇⴰ ⵡⴰⵔ ⵜᵉⵜⵜⵖⴻⵛⵛⵉⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵉⵏⵓ ⵓⵍⴰ ⴷ ⴰⵢⵢⴰⵡⴻⵏ ⵉⵏⵓ! ⵎⴰⵛⴰ ⵙ ⵎⵓⵅⴰⵙ ⵜⴰⵎⴻⵅⵙⵉⵡⵜ ⵉⵛⴻⵡⵡⴰⵔⴻⵏ ⵉ ⴽⵉⴽ ⴳⴳⵉⵖ ⵇⴱⴻⵍ, ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵜⴻⴳⴳⴻⴷ ⵛⴻⴽ ⴰⴽⵉⴷⵉ ⵓ ⴰⴽ-ⴷ ⵜⴻⵎⵎⵓⵔⵜ ⵎⴰⵏⵉ ⵜⴻⵇⵇⵉⵎⴻⴷ ⴰⵎ ⵓⴱⴰⵔⵔⴰⵏⵉ.” ");
INSERT INTO rift_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","ⵉⵏⵏⴰ ⵉⴱⵔⴰⵀⵉⵎ: “ⵏⴻⵛⵛ ⴰⴷ ⵊⵊⴰⴵⴻⵖ!” ");
INSERT INTO rift_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","ⵅⴰⵙ ⵓⵛⴰ ⵉⵄⴻⵢⵢⴻⴱ ⵉⴱⵔⴰⵀⵉⵎ ⴰⴱⵉⵎⴰⵍⵉⴽ ⵅ ⵍⵄⵓⵏⵚⴰⵔ ⵏ ⵡⴰⵎⴰⵏ ⵏⵏⵉ ⵉⵟⵟⴼⴻⵏ ⵣⵣⴰⵢⴻⵙ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏ ⴰⴱⵉⵎⴰⵍⵉⴽ ⵙ ⵓⵖⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⴰⴱⵉⵎⴰⵍⵉⴽ: “ⵏⴻⵛⵛ ⵡⴰⵔ ⵙⵙⵉⵏⴻⵖ ⵡⵉ ⵉⴳⴳⵉⵏ ⵎⴰⵏ ⴰⵢⴰ ⵓ ⵛⴻⴽ ⵡⴰⵔ ⴷ ⴰⵢⵉ ⵜ ⵜⴻⵏⵏⵉⴷ ⵛⴰ ⵇⴱⴻⵍ. ⴰⵇⴰ ⴰⵍ ⵍⴻⵅⵅⵓ ⵉ ⵣⵣⴰⵢⴻⴽ ⵜ ⵙⵍⵉⵖ.” ");
INSERT INTO rift_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","ⵉⴽⵙⵉ ⵉⴱⵔⴰⵀⵉⵎ ⵓⴵⵉ ⴷ ⵉⴼⵓⵏⴰⵙⴻⵏ ⴷ ⵜⴼⵓⵏⴰⵙⵉⵏ ⵓⵛⴰ ⵉⵡⵛⴰ ⴰⵙ ⵜⴻⵏ ⵉ ⴰⴱⵉⵎⴰⵍⵉⴽ ⵓⵛⴰ ⵏⵉⵜⵏⵉ ⵙ ⵜⵏⴰⵢⴻⵏ ⵉⴷⵙⴻⵏ ⴳⴳⵉⵏ ⵉⵊⵊ ⵏ ⵍⵄⴰⵀⴷ ⵊⴰⵔ ⴰⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","ⵎⴰⵛⴰ ⵉⵙⵙⴰⵔⵙ ⵉⴱⵔⴰⵀⵉⵎ ⵙⴻⴱⵄⴰ ⵏ ⵜⵅⴻⵙⵡⵉⵏ ⵣⴻⴳ ⵡⵓⴵⵉ ⵖⴰⵔ ⵓⵖⴻⵣⴷⵉⵙ. ");
INSERT INTO rift_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⴰⴱⵉⵎⴰⵍⵉⴽ ⵉ ⵉⴱⵔⴰⵀⵉⵎ: “ⵎⵉⵏ ⵄⵏⴰⵏⵜ ⵙⴻⴱⵄⴰ ⵏ ⵜⵅⴻⵙⵡⵉⵏ ⵏⵏⵉ ⵜⴻⴳⴳⵉⴷ ⵖⴰⵔ ⵓⵖⴻⵣⴷⵉⵙ?” ");
INSERT INTO rift_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","ⵉⵏⵏⴰ ⵏⴻⵜⵜⴰ: “ⴽⵙⵉ ⵣⴻⵄⵎⴰ ⵙⴻⴱⵄⴰ ⴰⵢⴰ ⵏ ⵜⵅⴻⵙⵡⵉⵏ ⵣⴻⴳ ⵉⴼⴰⵙⵙⴻⵏ ⵉⵏⵓ, ⵃⵉⵎⴰ ⴰⴷ ⵉⵍⵉⵏⵜ ⴷ ⵛⵛⵀⴰⴷⴻⵜ ⴷⵉ ⵟⵟⵡⴻⵄ ⵉⵏⵓ ⴱⴻⵍⵍⵉ ⵏⴻⵛⵛ ⵉ ⵉⵖⵣⵉⵏ ⴰⵏⵓ-ⵢⴰ.” ");
INSERT INTO rift_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","ⵅ ⵓⵢⴰ ⵙⴻⵎⵎⴰⵏ ⴰⵎⵛⴰⵏ ⵏⵏⵉ ⴱⵉ’ⵔ-ⵙⴻⴱⵄⴰ, ⵎⵉⵏⵣⵉ ⵏⵉⵜⵏⵉ ⵙ ⵜⵏⴰⵢⴻⵏ ⵉⴷⵙⴻⵏ ⵜⵓⵖⴰ ⵊⵊⵓⴵⴻⵏ ⴷⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","ⴰⵎⵎⵓ ⵉ ⴳⴳⵉⵏ ⵍⵄⴰⵀⴷ ⴷⵉ ⴱⵉ’ⵔ-ⵙⴻⴱⵄⴰ. ⴰⵡⴰⵔⵏⵉ ⵎⴰⵏ ⴰⵢⴰ ⵉⴽⴽⴰⵔ ⴰⴱⵉⵎⴰⵍⵉⴽ ⴰⴽ-ⴷ ⴼⵉⴽⵓⵍ, ⴰⴽⵓⵎⴰⵏⴷⴰⵔ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵏⴻⵙ, ⵉⵄⵇⴻⴱ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵉⴼⵉⵍⵉⵙⵟⵉⵏⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","ⵉⵥⵥⵓ ⵉⴱⵔⴰⵀⵉⵎ ⵉⵛⵜ ⵏ ⵜⵛⴻⵊⵊⴰⵔⵜ ⵏ ⵜⵎⴰⵔⵉⵙⵜ ⴷⵉ ⴱⵉ’ⵔ-ⵙⴻⴱⵄⴰ ⵓⵛⴰ ⵉⵍⴰⵖⴰ ⴷⵉⵏ ⵉⵙⴻⵎ ⵏ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏ ⵍⴻⴱⴷⴰ.    ");
INSERT INTO rift_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","ⵉⵣⴷⴻⵖ ⵉⴱⵔⴰⵀⵉⵎ ⴰⵎ ⵓⴱⴰⵔⵔⴰⵏⵉ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵉⴼⵉⵍⵉⵙⵟⵉⵏⵉⵢⵢⴻⵏ ⴰⵟⵟⴰⵙ ⵏ ⵡⵓⵙⵙⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","ⴰⵡⴰⵔⵏⵉ ⵎⴰⵏ ⴰⵢⴰ ⵜⴻⵎⵙⴰⵔ, ⴰⵇⴰ ⵉⵊⴰⵔⵔⴻⴱ ⴰⵔⴻⴱⴱⵉ ⵉⴱⵔⴰⵀⵉⵎ, ⵉⵏⵏⴰ ⴰⵙ: “ⵉⴱⵔⴰⵀⵉⵎ!” ⵓⵛⴰ ⵉⵏⵏⴰ ⴰⵙ: “ⵅⵣⴰⵔ, ⵏⴻⵛⵛ ⴰⵇⴰ ⴰⵢⵉ ⴷⴰ!” ");
INSERT INTO rift_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","ⵉⵏⵏⴰ ⴰⵙ ⵏⴻⵜⵜⴰ: “ⴽⵙⵉ ⴰⵢⴻⵏⵏⵉ ⵏ ⵎⵎⵉⵛ, ⵡⴻⵏⵏⵉ ⵜⴻⵅⵙⴻⴷ, ⵉⵙⵃⴰⵇ, ⵓⵛⴰ ⵔⵓⵃ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵓⵔⵉⵢⴰ ⵓⵛⴰ ⵜⵇⴻⴷⴷⵎⴻⴷ ⵜ ⴷⵉⵏ ⴷ ⵜⴰⵖⵔⴰⵚⵜ ⵅ ⵢⵉⵊⵊ ⵏ ⵡⴻⴷⵔⴰⵔ ⵊⴰⵔ ⵉⴷⵓⵔⴰⵔ ⵉ ⴷ ⴰⵛ ⵖⴰ ⵉⵏⵉⵖ.” ");
INSERT INTO rift_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","ⵉⴽⴽⴰⵔ ⵉⴱⵔⴰⵀⵉⵎ ⵣⵉⵛ, ⵉⵃⴻⵣⵣⴻⵎ ⵉ ⵡⴻⵖⵢⵓⵍ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⴽⵙⵉ ⴰⴽⵉⴷⴻⵙ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵙ ⴷ ⵎⵎⵉⵙ ⵉⵙⵃⴰⵇ. ⵉⵇⴻⵙⵙ ⴰⴽⴻⵛⵛⵓⴹ ⵉ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵜⵖⴰⵔⵚⵜ, ⵉⴽⴽⴰⵔ, ⵉⵔⵓⵃ ⴷⴻⴳ ⵡⴻⴱⵔⵉⴷ ⵖⴰⵔ ⵡⴻⵎⵛⴰⵏ ⵉ ⴷ ⴰⵙ ⵉⵏⵏⴰ ⴰⵔⴻⴱⴱⵉ. ");
INSERT INTO rift_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵜⵍⴰⵜⴰ ⵉⵙⵙⴳⴻⵄⵄⴻⴷ ⵉⴱⵔⴰⵀⵉⵎ ⵜⴰⵎⵓⵖⵍⵉ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⵥⵔⴰ ⴰⵎⵛⴰⵏ ⵣⵉ ⵍⴰⴳⴳⵯⴰⵊ. ");
INSERT INTO rift_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","ⵉⵏⵏⴰ ⵉⴱⵔⴰⵀⵉⵎ ⵉ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵙ: “ⵔⴰⵊⴰⵎ ⴷⴰ ⴰⴽ-ⴷ ⵡⴻⵖⵢⵓⵍ, ⵏⴻⵛⵛ ⴷ ⵓⵃⴻⵏⵊⵉⵔ ⴰⴷ ⵏⵔⴰⵃ ⴷⵉⵀⴰ, ⴰⴷ ⵏⴻⵙⵊⴻⴷ. ⴰⵡⴰⵔⵏⵉ ⴰⵙ ⴰⴷ ⵖⴰⵔⵡⴻⵎ ⴷⴷ-ⵏⴻⵄⵇⴻⴱ.” ");
INSERT INTO rift_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","ⵉⴽⵙⵉ ⵉⴱⵔⴰⵀⵉⵎ ⴰⴽⴻⵛⵛⵓⴹ ⵉ ⵡⴻⵛⵎⴰⴹ ⵏ ⵜⵖⴰⵔⵚⵜ, ⵉⵙⵙⴰⵔⵙ ⵉ-ⵜ ⵅ ⵎⵎⵉⵙ ⵉⵙⵃⴰⵇ ⵓ ⵏⴻⵜⵜⴰ ⵙ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵉⴽⵙⵉ ⵙ ⵓⴼⵓⵙ ⵏⵏⴻⵙ ⵜⵉⵎⴻⵙⵙⵉ ⴷ ⵜⵅⴻⴷⵎⴻⵛⵜ, ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⵔⵓⵃⴻⵏ ⵏⵉⵜⵏⵉ ⵙ ⵜⵏⴰⵢⴻⵏ ⵉⴷⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","ⵅⴻⵏⵏⵉ ⵉⵙⵙⵉⵡⴻⵍ ⵉⵙⵃⴰⵇ ⴰⴽ-ⴷ ⵉⴱⵔⴰⵀⵉⵎ ⴱⴰⴱⴰⵙ, ⵉⵏⵏⴰ: “ⴱⴰⴱⴰ ⵉⵏⵓ!” ⵉⵏⵏⴰ ⵏⴻⵜⵜⴰ: “ⵅⵣⴰⵔ, ⵏⴻⵛⵛ ⴰⵇⴰ ⴰⵢⵉ ⴷⴰ, ⵎⵎⵉ!” ⵓⵛⴰ ⵉⵏⵏⴰ ⵏⴻⵜⵜⴰ: “ⵅⵣⴰⵔ, ⴰⵇⴰ ⴷⴰ ⵜⵉⵎⴻⵙⵙⵉ ⴷ ⵓⴽⴻⵛⵛⵓⴹ, ⵎⴰⵛⴰ ⵎⴰⵏⵉ ⵉⴵⴰ ⵉⵣⵎⴰⵔ ⵉ ⵜⵖⴰⵔⵚⵜ?” ");
INSERT INTO rift_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","ⵉⵏⵏⴰ ⵉⴱⵔⴰⵀⵉⵎ: “ⴰⵔⴻⴱⴱⵉ ⵙⵉⵎⴰⵏⵜ ⵏⵏⴻⵙ ⴰⴷ ⵉⵙⵙⴰⵔⵣⴻⵇ ⵙ ⵢⴻⵣⵎⴰⵔ ⵉ ⵜⵖⴰⵔⵚⵜ, ⴰ ⵎⵎⵉ!” ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⵔⵓⵃⴻⵏ ⵙ ⵜⵏⴰⵢⴻⵏ ⵉⴷⵙⴻⵏ ");
INSERT INTO rift_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","ⵓⵛⴰ ⵉⵡⴹⴻⵏ ⵖⴰⵔ ⵡⴻⵎⵛⴰⵏ ⵏⵏⵉ ⵉ ⴷ ⴰⵙ ⵉⵏⵏⴰ ⴰⵔⴻⴱⴱⵉ. ⴷⵉⵏ ⵉ ⵉⴱⵏⴰ ⵉⴱⵔⴰⵀⵉⵎ ⵉⵊⵊ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ⵓⵛⴰ ⵉⵄⴷⴻⵍ ⴰⴽⴻⵛⵛⵓⴹ, ⵉⵛⴰⵔⴼ ⵎⵎⵉⵙ ⵉⵙⵃⴰⵇ ⵓⵛⴰ ⵉⵙⵙⴰⵔⵙ ⵉ-ⵜ ⵅ ⵓⵄⴰⵍⵟⴰⵔ ⵅ ⵉⴽⴻⵛⵡⴰⴹ. ");
INSERT INTO rift_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","ⵅⴰⵙ ⵓⵛⴰ ⵉⵙⵙⵡⵉⵥⵥⴻⴹ ⵉⴱⵔⴰⵀⵉⵎ ⴰⴼⵓⵙ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⴽⵙⵉ-ⴷⴷ ⵜⴰⵅⴻⴷⵎⴻⵛⵜ, ⵃⵉⵎⴰ ⴰⴷ ⵉⵖⴰⵔⵚ ⵉ ⵎⵎⵉⵙ. ");
INSERT INTO rift_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","ⵎⴰⵛⴰ ⵍⵎⴰⵍⴰⴽ ⵏ ⵙⵉⴷⵉ ⵉⵍⴰⵖⴰ ⴰⵙ-ⴷⴷ ⵣⴻⴳ ⵓⵊⴻⵏⵏⴰ, ⵉⵏⵏⴰ ⴰⵙ: “ⵉⴱⵔⴰⵀⵉⵎ, ⵉⴱⵔⴰⵀⵉⵎ!” ⵏⴻⵜⵜⴰ ⵉⵏⵏⴰ: “ⵏⴻⵛⵛ ⴰⵇⴰ ⴰⵢⵉ ⴷⴰ!” ");
INSERT INTO rift_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⴰⵙ: “ⵡⴰⵔ ⵙⵡⵉⵥⵥⵉⴹ ⴰⴼⵓⵙ ⵏⵏⴻⵛ ⵖⴰⵔ ⵓⵃⴻⵏⵊⵉⵔ. ⵡⴰⵔ ⴷ ⵜⵜⴻⴳⴳ ⵛⴰ, ⵎⵉⵏⵣⵉ ⵍⴻⵅⵅⵓ ⴰⵇⴰ ⵙⵙⵏⴻⵖ ⴱⴻⵍⵍⵉ ⵜᵉⵜⵜⴻⴳⴳⵯⴻⴷⴻⴷ ⴰⵔⴻⴱⴱⵉ ⵓ ⵡⴰⵔ ⵅⴰⴼⵉ ⵜⴻⵙⵙⵄⵉⵣⵣⴻⴷ ⴰⵢⴻⵏⵏⵉ ⵏ ⵎⵎⵉⵛ.” ");
INSERT INTO rift_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","ⵉⵙⵙⴳⴻⵄⵄⴻⴷ ⵉⴱⵔⴰⵀⵉⵎ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵙ, ⵓ ⵅⵣⴰⵔ, ⴰⵇⴰ ⴰⵡⴰⵔⵏⵉ ⴰⵙ ⵜⵓⵖⴰ ⵉⵊⵊ ⵏ ⵉⵛⴰⵔⵔⵉ ⵉⵇⵇⴻⵏ ⵖⴰⵔ ⵛⴱⴰⵔⵇ ⵣⴻⴳ ⵡⴰⵛⵛⴰⵡⴻⵏ ⵏⵏⴻⵙ. ⵢⵓⵢⵓⵔ ⵉⴱⵔⴰⵀⵉⵎ ⴷⵉⵏⵏⵉ, ⵉⵟⵟⴻⴼ ⵉⵛⴰⵔⵔⵉ ⵓⵛⴰ ⵉⴳⴳⴰ-ⵉ-ⵜ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏ ⵎⵎⵉⵙ. ");
INSERT INTO rift_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","ⵉⵍⴰⵖⴰ ⵉⴱⵔⴰⵀⵉⵎ ⵉⵙⴻⵎ ⵏ ⵡⴻⵎⵛⴰⵏ ⵏⵏⵉ: “ⵙⵉⴷⵉ ⴰⴷ ⵉⵙⵙⴰⵔⵣⴻⵇ!” ⵙ ⵓⵢⴻⵏⵏⵉ ⵉⵇⵇⴰⵔ ⴱⵏⴰⴷⴻⵎ ⴰⵍ ⴰⵙⵙ-ⴰ: “ⴷⴻⴳ ⵡⴻⴷⵔⴰⵔ ⵏ ⵙⵉⴷⵉ ⴰⴷ ⵢⵉⵍⵉ ⵢⴰⵔⵣⴻⵇ!” ");
INSERT INTO rift_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","ⵉⵍⴰⵖⴰ-ⴷⴷ ⵍⵎⴰⵍⴰⴽ ⵏ ⵙⵉⴷⵉ ⵡⵉⵙⵙ ⵎⴰⵔⵜⴰⵢⴻⵏ ⵣⴻⴳ ⵓⵊⴻⵏⵏⴰ ⵅ ⵉⴱⵔⴰⵀⵉⵎ, ");
INSERT INTO rift_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","ⵉⵏⵏⴰ: “ⵎⵉⵏⵣⵉ ⵜⴻⴳⴳⵉⴷ ⵎⴰⵏ ⴰⵢⴰ ⵓⵛⴰ ⵡⴰⵔ ⵅⴰⴼⵉ ⵜᵉⵟⵟⵉⴼⴻⴷ ⴰⵢⴻⵏⵏⵉ ⵏ ⵎⵎⵉⵛ, ⴰⴷ ⵊⵊⴰⴵⴻⵖ ⵅ ⵙⵉⵎⴰⵏⵜ ⵉⵏⵓ, ⵉⵇⵇⴰⵔ ⵙⵉⴷⵉ, ");
INSERT INTO rift_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ⴰⵇⴰ ⴰⴷ ⵛⴻⴽ ⴱⴰⵔⴽⴻⵖ ⴰⵟⵟⴰⵙ ⵓⵛⴰ ⴰⴷ ⴽⴻⵜⵜⴰⵔⴻⵖ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵛ ⴰⵟⵟⴰⵙ ⴰⵎ ⵢⵉⵜⵔⴰⵏ ⵏ ⵓⵊⴻⵏⵏⴰ ⵓ ⴰⵎ ⵢⵉⵊⴷⵉ ⵅ ⵜⵎⴰ ⵏ ⵍⴻⴱⵃⴰⵔ. ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵛ ⴰⴷ ⵜᵉⵟⵟⴻⴼ ⵜⴰⵡⵡⴰⵔⵜ ⵏ ⵍⵄⴻⴷⵢⴰⵏ ⵏⵏⴻⵙ ⴷ ⵍⵡⴰⵔⵜ ");
INSERT INTO rift_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","ⵓ ⴷⵉ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵛ ⴰⴷ ⵜⵜⵡⴰⴱⴰⵔⴽⴻⵏ ⵎⴰⵔⵔⴰ ⵍⴻⴳⵏⵓⵙ ⵏ ⵜⴻⵎⵎⵓⵔⵜ, ⵎⵉⵏⵣⵉ ⵜⴻⵙⵍⵉⴷ ⵉ ⵜⵎⵉⵊⵊⴰ ⵉⵏⵓ.” ");
INSERT INTO rift_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","ⵅⴻⵏⵏⵉ ⵉⵄⵇⴻⴱ-ⴷⴷ ⵉⴱⵔⴰⵀⵉⵎ ⵖⴰⵔ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵙ. ⵏⵉⵜⵏⵉ ⴽⴽⴰⵔⴻⵏ ⵓⵛⴰ ⵔⵓⵃⴻⵏ ⵊⵎⵉⵄ ⴷⴻⴳ ⵡⴻⴱⵔⵉⴷ ⵖⴰⵔ ⴱⵉ’ⵔ-ⵙⴻⴱⵄⴰ, ⵓⵛⴰ ⵉⴳⴳⴰ ⵉⴱⵔⴰⵀⵉⵎ ⴰⴷ ⵉⵣⴷⴻⵖ ⴷⵉ ⴱⵉ’ⵔ-ⵙⴻⴱⵄⴰ. ");
INSERT INTO rift_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","ⴰⵡⴰⵔⵏⵉ ⵎⴰⵏ ⴰⵢⴰ ⵉⵎⵙⴰⵔ ⴰⵇⴰ ⵅⴻⴱⴱⴰⵔⴻⵏ ⵉⴱⵔⴰⵀⵉⵎ, ⵏⵏⴰⵏ ⴰⵙ: “ⵅⵣⴰⵔ, ⵄⴰⵡⴻⴷ ⵎⵉⵍⴽⴰ ⵜⵓⵔⵓⵡ-ⴷⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵉ ⵏⴰⵃⵓⵔ ⵓⵎⴰⵛ: ");
INSERT INTO rift_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","ⵄⵓⵚ, ⴰⵎⴻⵏⵣⵓ ⵏⵏⴻⵙ, ⴷ ⴱⵓⵣ ⵓⵎⴰⵙ, ⴷ ⵇⴰⵎⵓⵡⵉⵍ ⵡⴻⵏⵏⵉ ⴷ ⴱⴰⴱⴰⵙ ⵏ ⴰⵔⴰⵎ, ");
INSERT INTO rift_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","ⴷ ⴽⴰⵙⴰⴷ ⴷ ⵃⴰⵣⵓ ⴷ ⴼⵉⵍⴷⴰⵛ ⴷ ⵢⵉⴷⵍⴰⴼ ⴷ ⴱⵉⵜⵓⵡⵉⵍ.” ");
INSERT INTO rift_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","ⴱⵉⵜⵓⵡⵉⵍ ⵉⵊⵊⴰ-ⴷⴷ ⵔⵉⴼⵇⴰ. ⵜⵎⴻⵏⵢⴰ ⴰⵢⴰ ⵉ ⴷⴷ-ⵜⵓⵔⵓⵡ ⵎⵉⵍⴽⴰ ⵉ ⵏⴰⵃⵓⵔ, ⵓⵎⴰⵙ ⵏ ⵉⴱⵔⴰⵀⵉⵎ. ");
INSERT INTO rift_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","ⵓ ⵜⴰⵢⵢⴰ ⵏⵏⴻⵙ, ⵜⴻⵏⵏⵉ ⵓⵎⵉ ⵇⵇⴰⵔⴻⵏ ⵔⵉⵄⵓⵎⴰ, ⵜⵓⵔⵓⵡ ⴰⵙ-ⴷⴷ ⵄⴰⵡⴻⴷ ⵟⴰⴱⴰⵃ ⴷ ⵊⴰⵃⴰⵎ ⴷ ⵜⴰⵃⴰⵛ ⴷ ⵎⴰⵄⴽⴰ. ");
INSERT INTO rift_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","ⵜⵓⵖⴰ ⵖⴰⵔ ⵙⴰⵔⴰ ⵎⵢⴰ ⵓ-ⵙⴻⴱⵄⴰ ⵓ-ⵄⵉⵛⵔⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ. ⵎⴰⵏ ⴰⵢⴰ ⴷ ⵍⵎⵉⵊⴰⵍ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵏ ⵜⵓⴷⴰⵔⵜ ⵏ ⵙⴰⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","ⵓⵛⴰ ⵜⴻⵎⵎⵓⵜ ⵙⴰⵔⴰ ⴷⵉ ⵇⴰⵔⵢⴰⵜ-ⴰⵔⴱⴰⵄ, ⵉⵅⵙ ⴰⴷ ⵢⵉⵏⵉ ⵃⴰⴱⵔⵓⵏ, ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ. ⵓⵛⴰ ⵢⵓⴷⴻⴼ-ⴷⴷ ⵉⴱⵔⴰⵀⵉⵎ ⵖⴰⵔ ⵓⵇⵉⴹⵓⵏ, ⵉⵛⴹⴻⵏ ⵅ ⵙⴰⵔⴰ, ⵉⵙⵖⵓⵢ ⵅⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","ⵅⴰⵙ ⵓⵛⴰ ⵉⴽⴽⴰⵔ ⵉⴱⵔⴰⵀⵉⵎ ⵟⵟⴰⵔⴼ ⵉ ⵓⵎⴻⵜⵜⵉⵏ ⵏⵏⴻⵙ, ⵓⵛⴰ ⵉⵙⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⵜⴰⵔⵡⴰ ⵏ ⵃⵉⵜ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“ⵏⴻⵛⵛ ⴷ ⴰⴱⴰⵔⵔⴰⵏⵉ ⴷ ⴰⵎⵄⴻⵣⵣⴻⴱ ⵖⴰⵔ ⴰⵡⴻⵎ. ⵡⵛⴻⵎ ⴰⵢⵉ ⵎⵖⵉⵔ ⴰⵏⴹⴻⵍ ⴷ ⴰⴳⵍⴰ ⵊⴰⵔ ⴰⵡⴻⵎ, ⵃⵉⵎⴰ ⴰⴷ ⵏⴻⴹⵍⴻⵖ ⴰⵎⴻⵜⵜⵉⵏ ⵉⵏⵓ ⵣⵉ ⵣⵣⴰⵜ ⵉⵏⵓ.” ");
INSERT INTO rift_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","ⴰⵔⵔⵉⵏ-ⴷⴷ ⵜⴰⵔⵡⴰ ⵏ ⵃⵉⵜ ⵅ ⵉⴱⵔⴰⵀⵉⵎ, ⵏⵏⴰⵏ ⴰⵙ: ");
INSERT INTO rift_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“ⵙⴻⵍ ⵖⴰⵔⵏⴻⵖ, ⴰ ⵙⵉⴷⵉ ⵉⵏⵓ! ⵛⴻⴽ ⴷ ⵍⵃⴰⴽⴻⵎ ⵏ ⴰⵔⴻⴱⴱⵉ ⵊⴰⵔ ⴰⵏⴻⵖ. ⵏⴹⴻⵍ ⴰⵎⴻⵜⵜⵉⵏ ⵏⵏⴻⵛ ⴷⴻⴳ ⵡⴻⵏⴹⴻⵍ ⵏⵏⴻⵖ ⵉⵚⴻⴱⵃⴻⵏ. ⵓⵍⴰ ⴷ ⵉⵊⵊ ⵣⵣⴰⵢⵏⴻⵖ ⴰⴷ ⵛⴻⴽ ⵉⵟⵟⴻⴼ ⵅ ⵡⴻⵏⴹⴻⵍ ⵏⵏⴻⵙ, ⵃⵉⵎⴰ ⴰⴷ ⴷⴰⵢⴻⵙ ⵜⵏⴻⴹⵍⴻⴷ ⴰⵎⴻⵜⵜⵉⵏ ⵏⵏⴻⵛ.” ");
INSERT INTO rift_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","ⵅⴻⵏⵏⵉ ⵉⴽⴽⴰⵔ ⵉⴱⵔⴰⵀⵉⵎ, ⵉⴱⴻⵏⴷⴻⵇ ⵣⵣⴰⵜ ⵉ ⵍⴳⴻⵏⵙ ⵏ ⵜⴻⵎⵎⵓⵔⵜ, ⵣⵣⴰⵜ ⵉ ⵜⴰⵔⵡⴰ ⵏ ⵃⵉⵜ ");
INSERT INTO rift_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","ⵓⵛⴰ ⵉⵙⵙⵉⵡⴻⵍ ⴰⴽⵉⴷⵙⴻⵏ, ⵉⵏⵏⴰ: “ⵎⴰⵍⴰ ⴽⴻⵏⵏⵉⵡ ⵙ ⴰⵔⵔⴰⵢ ⵏⵡⴻⵎ ⴰⴷ ⵏⴻⴹⵍⴻⵖ ⴰⵎⴻⵜⵜⵉⵏ ⵉⵏⵓ ⵣⵉ ⵣⵣⴰⵜ ⵉⵏⵓ, ⵙⵍⴻⵎ ⵖⴰⵔⵉ ⵓⵛⴰ ⵣⴰⵡⴳⴻⵎ ⴷⵉ ⵟⵟⵡⴻⵄ ⵉⵏⵓ ⵖⴰⵔ ⵄⵉⴼⵔⵓⵏ, ⵎⵎⵉⵙ ⵏ ⵣⵓⵀⴰⵔ, ");
INSERT INTO rift_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴰⵢⵉ ⵉⵡⵛ ⵉⴼⵔⵉ ⵏ ⵎⴰⴽⴼⵉⵍⴰ, ⴷ ⵡⴻⵏⵏⵉ ⵏⵏⴻⵙ, ⵖⴰⵔ ⵟⵟⴰⵔⴼ ⵏ ⵢⴻⵢⵢⴰⵔ ⵏⵏⴻⵙ. ⴻⵊⵊ ⵉ-ⵜ ⴰⴷ ⴰⵢⵉ ⵜ ⵉⵡⵛ ⵙ ⵜⵜⴰⵎⴰⵏ ⵏⵏⴻⵙ ⵉⴽⵎⴻⵍ. ⴰⴷ ⵢⵉⵍⵉ ⴷ ⴰⵏⴹⴻⵍ ⵉⵏⵓ ⵉ ⵖⴰ ⵎⴻⵍⵍⴽⴻⵖ ⵊⴰⵔ ⴰⵡⴻⵎ.” ");
INSERT INTO rift_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","ⵄⵉⴼⵔⵓⵏ ⵜⵓⵖⴰ ⵉⵇⵇⵉⵎ ⵊⴰⵔ ⵜⴰⵔⵡⴰ ⵏ ⵃⵉⵜ ⵓⵛⴰ ⵄⵉⴼⵔⵓⵏ, ⴰⵃⵉⵜⵜⵉ, ⵢⴰⵔⵔⴰ-ⴷⴷ ⵅ ⵉⴱⵔⴰⵀⵉⵎ ⴷⴻⴳ ⵉⵎⴻⵊⵊⴰⵏ ⵏ ⵜⴰⵔⵡⴰ ⵏ ⵃⵉⵜ ⴷ ⵎⴰⵔⵔⴰ ⵉⵏⵏⵉ ⵢⵓⴷⴼⴻⵏ ⵖⴰⵔ ⵜⴻⵡⵡⴰⵔⵜ ⵏ ⵜⴻⵏⴷⵉⵏⵜ ⵏⵏⴻⵙ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“ⵍⵍⴰ, ⴰ ⵙⵉⴷⵉ ⵉⵏⵓ, ⵙⴻⵍ-ⴷⴷ ⵖⴰⵔⵉ! ⵏⴻⵛⵛ ⴰⴷ ⴰⵛ ⵡⵛⴻⵖ ⵉⵢⵢⴰⵔ ⵓⵍⴰ ⴷ ⵉⴼⵔⵉ ⵏⵏⵉ ⴷⴰⵢⴻⵙ ⵉⴵⴰⵏ. ⵣⵣⴰⵜ ⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵜⴰⵔⵡⴰ ⵏ ⵍⴳⴻⵏⵙ ⵉⵏⵓ ⴰⴷ ⴰⵛ ⵜ ⵡⵛⴻⵖ, ⵏⴹⴻⵍ ⴰⵎⴻⵜⵜⵉⵏ ⵏⵏⴻⵛ!” ");
INSERT INTO rift_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","ⵅⴻⵏⵏⵉ ⵉⴱⴻⵏⴷⴻⵇ ⵉⴱⵔⴰⵀⵉⵎ ⵙ ⵓⵖⴻⵎⴱⵓⴱ ⵏⵏⴻⵙ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵣⵣⴰⵜ ⵉ ⵍⴳⴻⵏⵙ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ");
INSERT INTO rift_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ⵓⵛⴰ ⵉⵙⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⵄⵉⴼⵔⵓⵏ ⴷⴻⴳ ⵉⵎⴻⵣⵣⵓⵖⴻⵏ ⵏ ⵍⴳⴻⵏⵙ ⵏ ⵜⴻⵎⵎⵓⵔⵜ, ⵉⵏⵏⴰ: “ⵜⵜⵣⴰⵡⴳⴻⵖ, ⵎⴰⵍⴰ ⵜⴻⵅⵙⴻⴷ, ⵙⴻⵍ-ⴷⴷ ⵖⴰⵔⵉ. ⴰⴷ ⴰⵛ ⵡⵛⴻⵖ ⵏⵏⵓⵇⴰⵔⵜ ⵏ ⵢⴻⵢⵢⴰⵔ, ⵇⴱⴻⵍ ⵉ-ⵜⵜ ⵣⵣⴰⵢⵉ, ⵅⴻⵏⵏⵉ ⴰⴷ ⴷⴰⵢⴻⵙ ⵏⴻⴹⵍⴻⵖ ⴰⵎⴻⵜⵜⵉⵏ ⵉⵏⵓ.” ");
INSERT INTO rift_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","ⵢⴰⵔⵔⴰ-ⴷⴷ ⵄⵉⴼⵔⵓⵏ ⵅ ⵉⴱⵔⴰⵀⵉⵎ, ⵉⵏⵏⴰ ⴰⵙ: ");
INSERT INTO rift_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“ⵙⵉⴷⵉ ⵉⵏⵓ, ⵙⴻⵍ-ⴷⴷ ⵖⴰⵔⵉ! ⵎⵉⵏ ⵉⵅⵙ ⴰⴷ ⵢⵉⵏⵉ ⵉⵢⵢⴰⵔ ⵉⵙⴻⴽⴽⵡⴰⵏ ⴰⵔⴻⴱⵄⴰ-ⵎⵢⴰ ⵛⵉⵇⵍⵓ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵊⴰⵔ ⴰⵢⵉ ⴷ ⵛⴻⴽ? ⵏⴹⴻⵍ ⴰⵎⴻⵜⵜⵉⵏ ⵏⵏⴻⵛ!” ");
INSERT INTO rift_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","ⵉⵙⵍⴰ ⵉⴱⵔⴰⵀⵉⵎ ⵉ ⵄⵉⴼⵔⵓⵏ ⵓⵛⴰ ⵉⵡⵣⴻⵏ ⵉⴱⵔⴰⵀⵉⵎ ⵉ ⵄⵉⴼⵔⵓⵏ ⵜⵎⴻⵏⵢⴰⵜ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵉ ⵅⴻⴼ ⵉⵙⵙⵉⵡⴻⵍ ⴷⴻⴳ ⵉⵎⴻⵣⵣⵓⵖⴻⵏ ⵏ ⵜⴰⵔⵡⴰ ⵏ ⵃⵉⵜ: ⴰⵔⴻⴱⵄⴰ-ⵎⵢⴰ ⵛⵉⵇⵍⵓ ⵏ ⵏⵏⵓⵇⴰⵔⵜ, ⴰⵎ ⵜⵜ ⵏⵏⵓⵎⴻⵏ ⵉⵙⴻⴱⴱⴰⴱⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","ⴰⵎⵎⵓ ⵉ ⵉⴷⵡⴻⵍ ⵢⴻⵢⵢⴰⵔ ⵏ ⵄⵉⴼⵔⵓⵏ, ⵡⴻⵏⵏⵉ ⵉⴵⴰⵏ ⴷⵉ ⵎⴰⴽⴼⵉⵍⴰ ⴰⵔⴻⵏⴷⴰⴷ ⵏ ⵎⴰⵎⵔⵉ, ⵉⵢⵢⴰⵔ ⴷ ⵉⴼⵔⵉ ⵡⴻⵏⵏⵉ ⴷⴰⵢⴻⵙ ⵉⴵⴰⵏ ⴷ ⵎⴰⵔⵔⴰ ⵜⵉⵛⴻⵊⵊⵓⵔⴰ ⵉⵏⵏⵉ ⴷⴻⴳ ⵉⵢⵢⴰⵔ ⵖⴰⵔ ⵉⵢⵎⵉⵔⴻⵏ ⵏⵏⴻⵙ ⵉ ⴷ ⴰⵙ ⴷⴷ-ⵉⵏⵏⴹⴻⵏ,    ");
INSERT INTO rift_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","ⴷ ⴰⴳⵍⴰ ⵏ ⵉⴱⵔⴰⵀⵉⵎ ⵣⵣⴰⵜ ⵉ ⵜⴰⵔⵡⴰ ⵏ ⵃⵉⵜ ⴷ ⵎⴰⵔⵔⴰ ⵉⵏⵏⵉ ⵢⵓⴷⴼⴻⵏ ⵖⴰⵔ ⵜⴻⵡⵡⴰⵔⵜ ⵏ ⵜⴻⵏⴷⵉⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","ⴰⵡⴰⵔⵏⵉ ⴰⵢⴰ ⵉⵏⴹⴻⵍ ⵉⴱⵔⴰⵀⵉⵎ ⵙⴰⵔⴰ, ⵜⴰⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ, ⴷⴻⴳ ⵉⴼⵔⵉ ⵏ ⵢⴻⵢⵢⴰⵔ ⵏ ⵎⴰⴽⴼⵉⵍⴰ ⵇⵉⴱⴰⵍⵜ ⵉ ⵎⴰⵎⵔⵉ, ⵡⴻⵏⵏⵉ ⵉⴵⴰⵏ ⴷ ⵃⴰⴱⵔⵓⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","ⴰⵎⵎⵓ ⵉ ⵉⴷⵡⴻⵍ ⵉⵢⵢⴰⵔ ⴰⴽ-ⴷ ⵢⴻⴼⵔⵉ ⵉ ⴷⴰⵢⴻⵙ ⵉⴵⴰⵏ ⵣⵉ ⵜⴰⵔⵡⴰ ⵏ ⵃⵉⵜ ⵖⴰⵔ ⵉⴱⵔⴰⵀⵉⵎ ⴰⵎ ⵡⴻⵏⴹⴻⵍ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","ⵉⴱⵔⴰⵀⵉⵎ ⵜⵓⵖⴰ ⵉⵡⵙⴰⵔ ⵓ ⵉⵎⵖⴰⵔ ⴷⴻⴳ ⵡⵓⵙⵙⴰⵏ ⵓⵛⴰ ⵙⵉⴷⵉ ⵉⴱⴰⵔⴻⴽ ⵉⴱⵔⴰⵀⵉⵎ ⴷⵉ ⴽⵓⵍⵛⵉ. ");
INSERT INTO rift_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵉⴱⵔⴰⵀⵉⵎ ⵉ ⵓⵎⵙⴻⵅⵅⴰⵔ ⵏⵏⴻⵙ ⴰⵡⴻⵙⵙⴰⵔ ⵏⵏⵉ ⵉⴵⴰⵏ ⵅ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⴻⵙ, ⴰⵡⴽⵉⵍ ⵏ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵖⴰⵔⴻⵙ: “ⴻⴳⴳ ⵍⴻⵅⵅⵓ ⴰⴼⵓⵙ ⵏⵏⴻⵛ ⵙⴰⴷⵓ ⵜⵎⴻⵚⵚⴰⴹⵜ ⵉⵏⵓ, ");
INSERT INTO rift_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ⴰⴷ ⴰⵛ ⵙⵙⵊⵊⴰⴵⴻⵖ ⵙ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏ ⵉⵊⴻⵏⵡⴰⵏ ⴷ ⴰⵔⴻⴱⴱⵉ ⵏ ⵜⴻⵎⵎⵓⵔⵜ, ⴱⴻⵍⵍⵉ ⵡⴰⵔ ⴷⴷ-ⵜᵉⵜⵜⵉⵡⵢⴻⴷ ⵜⴰⵎⵖⴰⵔⵜ ⵉ ⵎⵎⵉ ⵣⵉ ⵜⵃⴻⵏⵊⵉⵔⵉⵏ ⵏ ⴰⵢⵜ ⵏ ⴽⴻⵏⵄⴰⵏ ⵎⴰⵏⵉ ⵣⴻⴷⴷⵖⴻⵖ ⵏⴻⵛⵛ ⵊⴰⵔ ⴰⵙⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","ⵎⴰⵛⴰ ⴰⴷ ⵜⵔⴰⵃⴻⴷ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵉ ⵣⵉ ⴷⴷ-ⵓⵙⵉⵖ, ⵖⴰⵔ ⵔⴰⴵ ⵉⵏⵓ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴷⴷ-ⵜⴰⵡⵢⴻⴷ ⵜⴰⵎⵖⴰⵔⵜ ⵉ ⵎⵎⵉ ⵉⵙⵃⴰⵇ.” ");
INSERT INTO rift_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","ⵉⵏⵏⴰ ⴰⵙ ⵓⵎⵙⴻⵅⵅⴰⵔ: “ⴱⴰⵍⴰⴽ ⵡⴰⵔ ⵜᵉⵜⵜⴻⵅⵙ ⵜⴻⵎⵖⴰⵔⵜ ⴰⴷ ⴰⵢⵉ ⴷⴷ-ⵜⴻⴹⴼⴰⵔ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ-ⴰ. ⵎⴰ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⴰⵔⵔⴻⵖ ⵎⵎⵉⵛ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⵉ ⵎⴰⵏⵉⵙ ⴷⴷ-ⵜⵓⵙⵉⴷ?” ");
INSERT INTO rift_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","ⵉⵏⵏⴰ ⴰⵙ ⵉⴱⵔⴰⵀⵉⵎ: “ⵃⴹⴰⵜ, ⵡⴰⵔ ⴷⴷ-ⵜⵜⴰⵔⵔⵉ ⵛⴰ ⵎⵎⵉ ⴷⵉⵏⵏⵉ! ");
INSERT INTO rift_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏ ⵉⵊⴻⵏⵡⴰⵏ ⵡⴻⵏⵏⵉ ⴷ ⴰⵢⵉ ⵉⵟⵟⴼⴻⵏ ⵣⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⴱⴰⴱⴰ ⵓ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵔⴰⴵ ⵉⵏⵓ, ⵡⴻⵏⵏⵉ ⵖⴰⵔⵉ ⵉⵙⵙⵉⵡⵍⴻⵏ, ⵉⵊⵊⵓⴵ ⴰⵢⵉ ⵓⵎⵉ ⴷ ⴰⵢⵉ ⵉⵏⵏⴰ: ‘ⵉ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵛ ⴰⴷ ⵡⵛⴻⵖ ⵜⴰⵎⵎⵓⵔⵜ-ⴰ!’, ⴷ ⵏⴻⵜⵜⴰ ⵉ ⵖⴰ ⵉⵙⵙⴻⴽⴽⴻⵏ ⵍⵎⴰⵍⴰⴽ ⵏⵏⴻⵙ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏⵏⴻⵛ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⴰⵡⵢⴻⴷ ⵙⵙⴻⵏⵏⵉ ⵜⴰⵎⵖⴰⵔⵜ ⵉ ⵎⵎⵉ. ");
INSERT INTO rift_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","ⵎⴰⵍⴰ ⵜⴰⵎⵖⴰⵔⵜ ⵡⴰⵔ ⵜᵉⵜⵜⴻⵅⵙ ⴰⴷ ⵛⴻⴽ ⴷⴷ-ⵜⴻⴹⴼⴰⵔ, ⴰⴷ ⵜⵉⵍⵉⴷ ⵜⵍⴻⵍⵍⵉⴷ ⵣⵉ ⵜⵊⴰⴵⵉⵜ-ⴰ, ⵎⵖⵉⵔ ⵡⴰⵔ ⴷⴷ-ⵜⵜⴰⵔⵔⵉ ⴷⵉⵏ ⵎⵎⵉ.” ");
INSERT INTO rift_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","ⵉⵙⵙⴰⵔⵙ ⵓⵎⵙⴻⵅⵅⴰⵔ ⴰⴼⵓⵙ ⵏⵏⴻⵙ ⵙⴰⴷⵓ ⵜⵎⴻⵚⵚⴰⴹⵜ ⵏ ⵙⵉⴷⵉⵙ ⵉⴱⵔⴰⵀⵉⵎ ⵉⵊⵊⵓⴵ ⴰⵙ ⵅ ⵎⴰⵏ ⴰⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","ⵉⴽⵙⵉ ⵓⵎⵙⴻⵅⵅⴰⵔ ⵄⴻⵛⵔⴰ ⵏ ⵉⵍⴻⵖⵎⴰⵏ ⵣⴻⴳ ⵉⵍⴻⵖⵎⴰⵏ ⵏ ⵙⵉⴷⵉⵙ, ⵉⵔⵓⵃ. ⵜⵓⵖⴰ ⵖⴰⵔⴻⵙ ⵄⵍⴰⵎ ⴽⵓⵍ ⴰⴳⵍⴰ ⵉⵖⵍⴰⵏ ⵏ ⵙⵉⴷⵉⵙ. ⵉⴽⴽⴰⵔ ⵓⵛⴰ ⵉⵟⵟⴻⴼ ⴰⴱⵔⵉⴷ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴰⵔⴰⵎ-ⵏⴰⵀⵔⴰⵢⵏ, ⴰⵇⴰ-ⵜⵜ ⴷ ⵎⵉⵙⵓⴱⵓⵜⴰⵎⵢⴰ, ⵖⴰⵔ ⵜⴻⵏⴷⵉⵏⵜ ⵏ ⵏⴰⵃⵓⵔ. ");
INSERT INTO rift_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","ⵖⴰⵔ ⵓⵅⴻⵛⵛⵉ ⵏ ⵜⵎⴻⴷⴷⵉⵜ ⵉⵊⵊⴰ ⵉⵍⴻⵖⵎⴰⵏ ⴰⴷ ⵊⵊⵏⴻⵏ ⴱⴰⵔⵔⴰ ⵉ ⵜⴻⵏⴷⵉⵏⵜ ⵣⵣⴰⵜ ⵉ ⵍⵄⵓⵏⵚⴰⵔ ⵏ ⵡⴰⵎⴰⵏ, ⵖⴰⵔ ⵜⵙⴰⵄⵄⴻⵜ ⵉ ⴷⵉ ⴷⴷ-ⴼⴼⵖⴻⵏⵜ ⵜⴻⵎⵖⴰⵔⵉⵏ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴰⵢⵎⴻⵏⵜ ⴰⵎⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ: “ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏ ⵙⵉⴷⵉ ⵉⵏⵓ ⵉⴱⵔⴰⵀⵉⵎ, ⵜⵜⵣⴰⵡⴰⴳⴻⵖ ⵛⴻⴽ ⴰⴷ ⴰⵢⵉ ⵜⵄⴰⵡⵏⴻⴷ ⴰⵙⵙ-ⴰ ⵓⵛⴰ ⵙⵛⴻⵏ ⵜⴰⵎⴻⵅⵙⵉⵡⵜ ⵏⵏⴻⵛ ⵉⵛⴻⵡⵡⴰⵔⴻⵏ ⵉ ⵙⵉⴷⵉ ⵉⵏⵓ ⵉⴱⵔⴰⵀⵉⵎ. ");
INSERT INTO rift_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","ⴰⵇⴰ ⴰⵢⵉ ⵖⴰⵔ ⵍⵄⵓⵏⵚⴰⵔ ⵏ ⵡⴰⵎⴰⵏ ⴷ ⵜⵃⴻⵏⵊⵉⵔⵉⵏ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ ⵏ ⵜⴻⵏⴷⵉⵏⵜ ⴰⴷ ⴷⴷ-ⴼⴼⵖⴻⵏⵜ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴰⵢⵎⴻⵏⵜ ⴰⵎⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","ⴻⵊⵊ ⵜⴰⴱⵍⵉⵖⵜ ⵏⵏⵉ ⵓⵎⵉ ⵖⴰ ⵉⵏⵉⵖ: ‘ⵙⴻⵀⵡⴰ-ⴷⴷ ⴰⵇⴱⵓⵛ ⵏⵏⴻⵎ, ⵎⴰⵍⴰ ⵜⴻⵅⵙⴻⴷ, ⴰⴷ ⵙⵡⴻⵖ!’, ⵓⵛⴰ ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⵉⵏⵉ: ‘ⵙⵓ, ⴰⴷ ⵡⴰⵔⴷⴻⵖ ⵓⵍⴰ ⴷ ⵉⵍⴻⵖⵎⴰⵏ ⵏⵏⴻⵛ!’, ⴰⵇⴰ ⴷ ⵏⴻⵜⵜⴰⵜ ⵉ ⵜⴻⴳⴳⵉⴷ ⵉ ⵓⵎⵙⴻⵅⵅⴰⵔ ⵏⵏⴻⵛ ⵉⵙⵃⴰⵇ, ⵓ ⵙ ⵓⵢⴰ ⴰⴷ ⵙⵙⵏⴻⵖ ⴰⵇⴰ ⵜⴻⵙⵙⴻⵛⵏⴻⴷ ⵜⴰⵎⴻⵅⵙⵉⵡⵜ ⵏⵏⴻⵛ ⵉⵛⴻⵡⵡⴰⵔⴻⵏ ⵉ ⵙⵉⴷⵉ ⵉⵏⵓ.” ");
INSERT INTO rift_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","ⵓⵛⴰ ⵄⴰⴷ ⵇⴱⴻⵍ ⵉ ⵖⴰ ⵉⴽⴻⵎⵎⴻⵔ ⴰⵡⴰⵍ, ⵉⵥⵔⴰ ⵔⵉⴼⵇⴰ, ⵜⴻⵏⵏⵉ ⵉ ⴷⴷ-ⵢⵓⵔⵡⴻⵏ ⵉ ⴱⵉⵜⵓⵡⵉⵍ, ⵎⵎⵉⵙ ⵏ ⵎⵉⵍⴽⴰ, ⵜⴰⵎⵖⴰⵔⵜ ⵏ ⵏⴰⵃⵓⵔ ⵓⵎⴰⵙ ⵏ ⵉⴱⵔⴰⵀⵉⵎ, ⵜⴻⴼⴼⴻⵖ-ⴷⴷ ⵣⵉ ⵜⴻⵏⴷⵉⵏⵜ ⵙ ⵡⴻⵇⴱⵓⵛ ⵏⵏⴻⵙ ⵅ ⵜⴻⵖⵔⵓⴹⵜ. ");
INSERT INTO rift_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","ⵜⴰⴱⵍⵉⵖⵜ ⵜⵓⵖⴰ ⴷⴰⵢⴻⵙ ⴰⵥⵔⵉ ⵉⵎⵖⴰⵔ, ⴷ ⵜⴰⵄⵣⴰⵔⴻⵛⵜ, ⵡⴰⵔ ⵜⵜ ⵉⵙⵙⵉⵏ ⵡⴻⵔⵢⴰⵣ. ⵏⴻⵜⵜⴰⵜ ⵜⴻⵀⵡⴰ-ⴷⴷ ⵖⴰⵔ ⵍⵄⵓⵏⵚⴰⵔ, ⵜⴻⵛⵛⵓⵔ ⴰⵇⴱⵓⵛ ⵏⵏⴻⵙ ⵓⵛⴰ ⵜⴳⴻⵄⵄⴻⴷ ⵄⴰⵡⴻⴷ. ");
INSERT INTO rift_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","ⵢⵓⵣⵣⴻⵍ ⵖⴰⵔⴻⵙ ⵓⵎⵙⴻⵅⵅⴰⵔ ⵏⵏⵉ, ⵉⵏⵏⴰ: “ⵜⵜⵣⴰⵡⴳⴻⵖ ⵛⴻⵎ ⴰⴷ ⴰⵢⵉ ⵜⴻⵡⵛⴻⴷ ⴰⴷ ⵙⵡⴻⵖ ⵛⵡⴰⵢⵜ ⵏ ⵡⴰⵎⴰⵏ ⵣⴻⴳ ⵡⴻⵇⴱⵓⵛ ⵏⵏⴻⵎ!” ");
INSERT INTO rift_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","ⵏⴻⵜⵜⴰⵜ ⵜⴻⵏⵏⴰ: “ⵙⵓ, ⴰ ⵙⵉⴷⵉ ⵉⵏⵓ!” ⵜⵇⴻⴵⴻⵇ ⵜⴻⵙⵙⴻⵀⵡⴰ ⴰⵇⴱⵓⵛ ⵏⵏⴻⵙ ⵅ ⵓⴼⵓⵙ ⵏⵏⴻⵙ, ⵜⴻⵡⵛⴰ ⴰⵙ ⴰⴷ ⵉⵙⵓ. ");
INSERT INTO rift_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","ⵍⴰⵎⵉ ⴷ ⴰⵙ ⵜⴻⵡⵛⴰ ⵉⵙⵡⴰ ⵎⵍⵉⵃ, ⵜⴻⵏⵏⴰ: “ⴰⴷ ⴰⵢⵎⴻⵖ ⴰⵎⴰⵏ ⵄⴰⵡⴻⴷ ⵉ ⵉⵍⴻⵖⵎⴰⵏ ⵏⵏⴻⵛ, ⴰⵍ ⵖⴰⵔⵙⴻⵏ ⵉ ⵖⴰ ⵢⵉⵍⵉ ⵙ ⵣⵣⵢⴰⴷⴰ.” ");
INSERT INTO rift_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","ⵜⵇⴻⴵⴻⵇ ⵜᵉⵙⵙⴻⵅⵡⴰ ⴰⵇⴱⵓⵛ ⴷⵉ ⵜⴰⵔⵢⴰ, ⵜⵓⵣⵣⴻⵍ ⵄⴰⵡⴻⴷ ⵖⴰⵔ ⵍⵄⵓⵏⵚⴰⵔ, ⵃⵉⵎⴰ ⴰⴷ ⵜⴰⵢⴻⵎ ⴰⵎⴰⵏ, ⵓⵛⴰ ⵜⵓⵢⴻⵎ ⴰⵙⴻⵏ-ⴷⴷ ⴰⵎⴰⵏ ⵉ ⵉⵍⴻⵖⵎⴰⵏ ⵏⵏⴻⵙ ⵎⴰⵔⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","ⵡⴰⵅⵅⴰ ⵉⵜⴻⴱⵀⴻⵜ ⴷⴰⵢⴻⵙ ⵡⴻⵔⵢⴰⵣ, ⵉⵙⵇⴰⵔ, ⵃⵉⵎⴰ ⴰⴷ ⵉⵙⵙⴻⵏ ⵎⴰ ⵙⵉⴷⵉ ⵉⵙⵙⴻⵀⵡⴻⵏ ⵅⴰⵙ ⴰⴱⵔⵉⴷ ⵏⵏⴻⵙ ⵏⵉⵖ ⵍⵍⴰ. ");
INSERT INTO rift_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","ⵓⵎⵉ ⵊⵊⵉⵡⵏⴻⵏ ⵉⵍⴻⵖⵎⴰⵏ ⵜⵉⵙⴻⵙⵙⵉ, ⵉⴽⵙⵉ ⵡⴻⵔⵢⴰⵣ ⴷⴻⴳ ⵉⵊⵊ ⵏ ⵓⵎⵓⵔ ⵉⵛⵜ ⵏ ⵜⵅⴰⴷⴻⵏⵜ ⵏ ⵡⵓⵔⴻⵖ, ⵜⴻⵏⵏⵉ ⵉⵡⴻⵣⵏⴻⵏ ⴰⵣⵢⴻⵏ ⵛⵉⵇⵍⵓ, ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵎⴻⵇⵢⴰⵙⵉⵏ ⵉ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵏⴻⵙ, ⵜⵉⵏⵏⵉ ⵉⵡⴻⵣⵏⴻⵏ ⵄⴻⵛⵔⴰ ⵛⵉⵇⵍⵓ ⵏ ⵡⵓⵔⴻⵖ, ");
INSERT INTO rift_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","ⵉⵏⵏⴰ: “ⵉⵏⵉ ⴰⵢⵉ, ⵓⵎⵉ ⵜⴻⴳⴳⵉⴷ ⴷ ⵢⴻⴵⵉⵙ? ⵎⴰ ⴰⵇⴰ ⴷⵉⵏ ⴰⵎⵛⴰⵏ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⴱⴰⴱⴰⵎ ⵎⴰⵏⵉ ⵏⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵏⴻⵙⵙⴻⵏⵙ?” ");
INSERT INTO rift_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","ⵏⴻⵜⵜⴰⵜ ⵜⴻⵏⵏⴰ ⴰⵙ: “ⵏⴻⵛⵛ ⴷ ⵢⴻⴵⵉⵙ ⵏ ⴱⵉⵜⵓⵡⵉⵍ, ⵎⵎⵉⵙ ⵏ ⵎⵉⵍⴽⴰ, ⵡⴻⵏⵏⵉ ⵉ-ⵜⵜ-ⵉ-ⴷⴷ-ⵢⵓⵔⵡⴻⵏ ⵉ ⵏⴰⵃⵓⵔ.” ");
INSERT INTO rift_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","ⵓⵛⴰ ⵜⴰⵔⵏⵉ ⵜⴻⵏⵏⴰ ⴰⵙ: “ⴰⵇⴰ ⵄⴰⵡⴻⴷ ⵖⴰⵔⵏⴻⵖ ⴰⵟⵟⴰⵙ ⵏ ⵓⵍⵓⵎ ⴷ ⵉⵖⴻⴵ, ⵓ ⵖⴰⵔⵏⴻⵖ ⵄⴰⵡⴻⴷ ⴰⵎⵛⴰⵏ ⵉ ⵜⵎⴻⵏⵙⵉⵡⵜ.” ");
INSERT INTO rift_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","ⵓⵛⴰ ⵢⵓⴹⴰⵔ ⵡⴻⵔⵢⴰⵣ ⵓⵛⴰ ⵉⴱⴻⵏⴷⴻⵇ ⵉ ⵙⵉⴷⵉ, ");
INSERT INTO rift_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","ⵉⵏⵏⴰ: “ⴰⴷ ⵉⵜⵜⵡⴰⴱⴰⵔⴻⴽ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏ ⵙⵉⴷⵉ ⵉⵏⵓ ⵉⴱⵔⴰⵀⵉⵎ, ⵡⴻⵏⵏⵉ ⵡⴰⵔ ⵉⴽⴽⵉⵙⴻⵏ ⵜⴰⵎⴻⵅⵙⵉⵡⵜ ⵏⵏⴻⵙ ⵉⵛⴻⵡⵡⴰⵔⴻⵏ ⴷ ⵍⴰⵎⴰⵏ ⵏⵏⴻⵙ ⵣⵉ ⵙⵉⴷⵉ ⵉⵏⵓ. ⵉⵏⴷⴻⵀ ⴰⵢⵉ ⵙⵉⴷⵉ ⴷⴻⴳ ⵡⴻⴱⵔⵉⴷ ⵖⴰⵔ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵡⴰⵡⵎⴰⵜⴻⵏ ⵏ ⵙⵉⴷⵉ ⵉⵏⵓ.” ");
INSERT INTO rift_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","ⵜⵓⵣⵣⴻⵍ ⵜⴻⴱⵍⵉⵖⵜ, ⵜⵄⴰⵡⴻⴷ ⵜⵉⵎⴻⵙⵍⴰⵢⵉⵏ-ⴰ ⵉ ⵢⴻⵎⵎⴰⵙ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","ⵓⵛⴰ ⵔⵉⴼⵇⴰ ⵜⵓⵖⴰ ⵖⴰⵔⴻⵙ ⵓⵎⴰⵙ, ⵇⵇⴰⵔⴻⵏ ⴰⵙ ⵍⴰⴱⴰⵏ, ⵓⵛⴰ ⵍⴰⴱⴰⵏ ⵢⵓⵣⵣⴻⵍ ⵖⴰⵔ ⵡⴻⵔⵢⴰⵣ ⵏⵏⵉ ⵜⵓⵖⴰ ⴷⵉⵏ ⴷⵉ ⴱⴰⵔⵔⴰ ⵖⴰⵔ ⵍⵄⵓⵏⵚⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","ⵜⵓⵖⴰ ⵉⵥⵔⴰ ⵜⴰⵅⴰⴷⴻⵏⵜ ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵎⴻⵇⵢⴰⵙⵉⵏ ⴷⴻⴳ ⵉⴼⴰⵙⵙⴻⵏ ⵏ ⵓⵞⵎⴰⵙ ⵓⵛⴰ ⵉⵙⵍⴰ ⵉ ⵡⴰⵡⴰⵍⴻⵏ ⵉ ⵜⵓⵖⴰ ⵜⴻⵇⵇⴰⵔ ⵓⵞⵎⴰⵙ ⵔⵉⴼⵇⴰ, ⵜⴻⵏⵏⴰ: “ⴰⵎⵎⵓ ⵉ ⴽⵉⴷⵉ ⵉⵙⵙⵉⵡⴻⵍ ⵡⴻⵔⵢⴰⵣ ⵏⵏⵉ.” ⵓⵛⴰ ⵢⵓⵢⵓⵔ ⵖⴰⵔ ⵡⴻⵔⵢⴰⵣ. ⵅⵣⴰⵔ, ⵉⴱⴻⴷⴷ ⴷⵉⵀⴰ ⵣⵣⴰⵜ ⵉ ⵉⵍⴻⵖⵎⴰⵏ, ⵖⴰⵔ ⵍⵄⵓⵏⵚⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","ⵉⵏⵏⴰ: “ⴰⵔⴰⵃ-ⴷⴷ, ⴰ ⵛⴻⴽ ⴷ ⴰⵎⵉⵎⵓⵏ ⵏ ⵙⵉⴷⵉ! ⵎⴰⵢⴻⵎⵎⵉ ⵜⴻⵇⵇⵉⵎⴻⴷ ⴷⵉ ⴱⴰⵔⵔⴰ, ⵏⴻⵛⵛ ⴰⵇⴰ ⵙⵙⵡⴻⵊⴷⴻⵖ ⵜⴰⴷⴷⴰⵔⵜ ⴷ ⵡⴻⵎⵛⴰⵏ ⵉ ⵉⵍⴻⵖⵎⴰⵏ.” ");
INSERT INTO rift_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","ⵉⵔⵓⵃ ⵡⴻⵔⵢⴰⵣ ⴰⴽⵉⴷⴻⵙ ⵖⴰⵔ ⵜⴰⴷⴷⴰⵔⵜ ⵓ ⵏⴻⵜⵜⴰ ⵉⴹⵍⴻⵇ ⵉ ⵉⵙⴻⵖⵡⴰⵏ ⵏ ⵉⵍⴻⵖⵎⴰⵏ. ⵏⴻⵜⵜⴰ ⵉⵡⵛⴰ ⴰⵙⴻⵏ ⵍⵓⵎ ⴷ ⵎⴰⵛⵛⴰ, ⵓⵛⴰ ⵉⴽⵙⵉ ⴰⵎⴰⵏ, ⵃⵉⵎⴰ ⴰⴷ ⵉⵙⵙⵉⵔⴷ ⵉⴹⴰⵔⴻⵏ ⵏⵏⴻⵙ ⵓⵍⴰ ⴷ ⵉⴹⴰⵔⴻⵏ ⵏ ⵉⵔⵢⴰⵣⴻⵏ ⵏⵏⵉ ⴽⵉⴷⴻⵙ ⵉⴵⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","ⵉⵙⵙⴰⵔⵙ ⵣⵣⴰⵜⴻⵙ ⵎⵉⵏ ⵖⴰ ⵢⴻⵛⵛ. ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵉⵏⵏⴰ: “ⵡⴰⵔ ⵜⵜᵉⵜⵜⴻⵖ ⵇⴱⴻⵍ ⵉ ⵖⴰ ⵉⵏⵉⵖ ⵜⴰⴱⵔⴰⵜ ⵉⵏⵓ.” ⵏⴻⵜⵜⴰ ⵉⵏⵏⴰ ⴰⵙ: “ⵙⵉⵡⴻⵍ!” ");
INSERT INTO rift_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ: “ⵏⴻⵛⵛ ⴷ ⴰⵎⵙⴻⵅⵅⴰⵔ ⵏ ⵉⴱⵔⴰⵀⵉⵎ. ");
INSERT INTO rift_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","ⵙⵉⴷⵉ ⵉⴱⴰⵔⴽ ⵙⵉⴷⵉ ⵉⵏⵓ ⴰⵟⵟⴰⵙ ⵙ ⵡⴰⵟⵟⴰⵙ ⵓⵛⴰ ⵛⵛⴰⵏ ⵏⵏⴻⵙ ⵉⵎⵖⴰⵔ ⴰⵟⵟⴰⵙ. ⴰⵇⴰ ⵉⵡⵛⴰ ⴰⵙ ⵓⴵⵉ ⴷ ⵉⴼⵓⵏⴰⵙⴻⵏ ⴷ ⵜⴼⵓⵏⴰⵙⵉⵏ, ⵏⵏⵓⵇⴰⵔⵜ ⴷ ⵡⵓⵔⴻⵖ, ⵉⵙⴻⵎⵖⴰⵏ ⴷ ⵜⵉⵢⵢⴰ, ⵉⵍⴻⵖⵎⴰⵏ ⴷ ⵢⴻⵖⵢⴰⵍ. ");
INSERT INTO rift_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","ⴷ ⵙⴰⵔⴰ, ⵜⴰⵎⵖⴰⵔⵜ ⵏ ⵙⵉⴷⵉ ⵉⵏⵓ, ⵜⵓⵔⵓⵡ-ⴷⴷ ⴰⵃⴻⵏⵊⵉⵔ ⵉ ⵙⵉⴷⵉ ⵉⵏⵓ ⴰⵡⴰⵔⵏⵉ ⵓⵎⵉ ⵜⴻⵡⵙⴰⵔ ⵓ ⵏⴻⵜⵜⴰ ⵉⵡⵛⴰ ⴰⵙ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵖⴰⵔⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","ⵓⵛⴰ ⵙⵉⴷⵉ ⵉⵏⵓ ⵉⵊⵊⴰ ⴰⵢⵉ ⵊⵊⵓⴵⴻⵖ, ⵉⵏⵏⴰ: ‘ⵡⴰⵔ ⴷⴷ-ⵜⵜⴰⵡⵉ ⵜⴰⵎⵖⴰⵔⵜ ⵉ ⵎⵎⵉ ⵣⵉ ⵜⵃⴻⵏⵊⵉⵔⵉⵏ ⵏ ⴰⵢⵜ ⵏ ⴽⴻⵏⵄⴰⵏ ⵉⵏⵏⵉ ⵎⴰⵏⵉ ⵣⴻⴷⵖⴻⵖ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","ⵓⵛⵜ ⵅⴰⴽ ⵎⴰⵍⴰ ⵡⴰⵔ ⵜⵜⵔⵉⵃⴻⴷ ⵖⴰⵔ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⴱⴰⴱⴰ, ⵖⴰⵔ ⵔⴰⴵ ⵉⵏⵓ ⵓⵛⴰ ⴰⴷ ⴷⴷ-ⵜⴰⵡⵢⴻⴷ ⵜⴰⵎⵖⴰⵔⵜ ⵉ ⵎⵎⵉ ⵙⵙⴻⵏⵏⵉ.’ ");
INSERT INTO rift_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","ⵅⴻⵏⵏⵉ ⵏⴻⵛⵛ ⵏⵏⵉⵖ ⵉ ⵙⵉⴷⵉ ⵉⵏⵓ: ‘ⴱⴰⵍⴰⴽ ⵜⴰⵎⵖⴰⵔⵜ ⵡⴰⵔ ⴷ ⴰⵢⵉ ⴷⴷ-ⵜⴹⴻⴼⴼⴰⵔ.’ ");
INSERT INTO rift_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵉⵏⵏⴰ ⴰⵢⵉ: ‘ⵙⵉⴷⵉ ⵉ ⵓⵎⵉ ⵓⵢⵓⵔⴻⵖ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏⵏⴻⵙ, ⴰⵇⴰ ⵏⴻⵜⵜⴰ ⴰⴷ ⴷⴷ-ⵉⵙⵙⴻⴽⴽ ⵍⵎⴰⵍⴰⴽ ⵏⵏⴻⵙ ⴰⴽⵉⴷⴻⴽ ⵓⵛⴰ ⴰⴷ ⵅⴰⴽ ⵉⵙⵙⴻⵀⵡⴻⵏ ⴰⴱⵔⵉⴷ ⵏⵏⴻⵛ ⴰⵍ ⴷⴷ ⵖⴰ ⵜⴰⵡⵢⴻⴷ ⵉ ⵎⵎⵉ ⵉⵛⵜ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⵣⵉ ⵍⴰⴵ ⵉⵏⵓ ⵓ ⵣⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⴱⴰⴱⴰ. ");
INSERT INTO rift_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","ⴰⴷ ⵜⵉⵍⵉⴷ ⵜⴼⴻⴽⴽⴻⴷ ⵣⵉ ⵜⵊⴰⴵⵉⵜ ⵉ ⴷ ⴰⵢⵉ ⵜⴻⵊⵊⵓⴵⴻⴷ, ⵅⵎⵉ ⵖⴰ ⵜⵔⴰⵃⴻⴷ ⵖⴰⵔ ⵍⴰⴵ ⵉⵏⵓ ⵓ ⵏⵉⵜⵏⵉ ⵡⴰⵔ ⴷ ⴰⵛ ⵜⵜ ⵜⵜⵉⵛⴻⵏ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵛⴻⴽ ⵙⵙⵓⴼⴼⵖⴻⵖ ⵣⵉ ⵜⵊⴰⴵⵉⵜ ⵏⵏⴻⵛ ⵉ ⵜⵓⵖⴰ ⵜⴻⵊⵊⵓⴵⴻⴷ.’ ");
INSERT INTO rift_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","ⴰⵙⵙ-ⴰ ⵓⵙⵉⵖ-ⴷⴷ ⵖⴰⵔ ⵍⵄⵓⵏⵚⴰⵔ ⵓⵛⴰ ⵏⵏⵉⵖ: ‘ⴰ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏ ⵙⵉⴷⵉ ⵉⵏⵓ ⵉⴱⵔⴰⵀⵉⵎ, ⵜⵜⵣⴰⵡⴰⴳⴻⵖ ⴰⴷ ⵜᵉⵙⵙⵀⴻⵡⵏⴻⴷ ⵍⴻⵅⵅⵓ ⴰⴱⵔⵉⴷ ⵉ ⴷⵉ ⴳⴳⵓⵔⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","ⴰⵇⴰ ⴰⵢⵉ ⴷⴰ ⵣⵣⴰⵜ ⵉ ⵍⵄⵓⵏⵚⴰⵔ ⵏ ⵡⴰⵎⴰⵏ. ⴻⵊⵊ ⴰⴷ ⵜⵉⵍⵉ ⴰⵎⵎⵓ, ⴰⵇⴰ ⵜⴰⵄⵣⴰⵔⴻⵛⵜ, ⵜⴻⵏⵏⵉ ⴷⴷ ⵖⴰ ⵉⴼⴼⵖⴻⵏ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⴰⵢⴻⵎ ⴰⵎⴰⵏ ⵓ ⵉ ⵜⴻⵏⵏⵉ ⵓⵎⵉ ⵖⴰ ⵉⵏⵉⵖ: ⴻⵡⵛ ⴰⵢⵉ ⴰⴷ ⵙⵡⴻⵖ ⵛⵡⴰⵢⵜ ⵏ ⵡⴰⵎⴰⵏ ⵣⴻⴳ ⵓⵇⴱⵓⵛ ⵏⵏⴻⵎ! ");
INSERT INTO rift_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ⵓⵛⴰ ⵅⴻⵏⵏⵉ ⵏⴻⵜⵜⴰⵜ ⴰⴷ ⴰⵢⵉ ⵜⵉⵏⵉ: ⵙⵓ ⵛⴻⴽ ⵓ ⵏⴻⵛⵛ ⴰⴷ ⴰⵢⵎⴻⵖ ⵄⴰⵡⴻⴷ ⵉ ⵉⵍⴻⵖⵎⴰⵏ ⵏⵏⴻⵛ!, ⴷ ⵜⴰ ⴰⴷ ⵜⵉⵍⵉ ⴷ ⵜⴰⵎⵖⴰⵔⵜ ⵏⵏⵉ ⴷ ⵉⵙⵙⴻⵡⵊⴻⴷ ⵙⵉⴷⵉ ⵉ ⵎⵎⵉⵙ ⵏ ⵙⵉⴷⵉ ⵉⵏⵓ.’ ");
INSERT INTO rift_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","ⵓⵛⴰ ⵇⴱⴻⵍ ⵉ ⵖⴰ ⴽⴻⵎⵎⵍⴻⵖ ⵜⴰⵥⴰⴵⵉⵜ-ⴰ ⴷⴻⴳ ⵡⵓⵍ ⵉⵏⵓ, ⵅⵣⴰⵔ, ⵔⵉⴼⵇⴰ ⵜⴻⴼⴼⴻⵖ-ⴷⴷ ⵙ ⵓⵇⴱⵓⵛ ⵏⵏⴻⵙ ⵅ ⵜⴻⵖⵔⵓⴹⵜ ⵏⵏⴻⵙ, ⵜⴻⵀⵡⴰ ⵖⴰⵔ ⵍⵄⵓⵏⵚⴰⵔ ⵓⵛⴰ ⵜⵓⵢⴻⵎ-ⴷⴷ ⴰⵎⴰⵏ. ⵏⵏⵉⵖ ⴰⵙ: ‘ⵜⵜⵣⴰⵡⴳⴻⵖ ⵛⴻⵎ ⴰⴷ ⴰⵢⵉ ⵜⴻⵡⵛⴻⴷ ⴰⴷ ⵙⵡⴻⵖ!’ ");
INSERT INTO rift_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","ⴷⴻⵖⵢⴰ ⵜⴻⵙⵙⴻⵀⵡⴰ ⴰⵇⴱⵓⵛ ⵏⵏⴻⵙ, ⵜⴻⵏⵏⴰ: ‘ⵙⵓ ⵓ ⵏⴻⵛⵛ ⴰⴷ ⵙⵙⴻⵙⵡⴻⵖ ⵄⴰⵡⴻⴷ ⵉⵍⴻⵖⵎⴰⵏ ⵏⵏⴻⵛ!’ ⵙⵡⵉⵖ ⵓⵛⴰ ⵏⴻⵜⵜⴰⵜ ⵜⴻⵡⵛⴰ ⵄⴰⵡⴻⴷ ⵉ ⵉⵍⴻⵖⵎⴰⵏ ⴰⴷ ⵙⵡⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","ⵙⵙⴻⵇⵙⵉⵖ ⵜⵜ, ⵏⵏⵉⵖ: ‘ⵓⵎⵉ ⵜⴻⴳⴳⵉⴷ ⴷ ⵢⴻⴵⵉⵙ?’ ⵏⴻⵜⵜⴰⵜ ⵜⴰⵔⵔⴰ: ‘ⵏⴻⵛⵛ ⴷ ⵢⴻⴵⵉⵙ ⵏ ⴱⵉⵜⵓⵡⵉⵍ, ⵎⵎⵉⵙ ⵏ ⵏⴰⵃⵓⵔ ⵡⴻⵏⵏⵉ ⴷ ⴰⵙ ⴷⴷ-ⵢⵓⵔⵡⴻⵏ ⵎⵉⵍⴽⴰ.’ ⵅⴻⵏⵏⵉ ⴳⴳⵉⵖ ⴰⵙ ⵜⴰⵅⴰⴷⴻⵏⵜ ⴷⵉ ⵜⵉⵏⵣⴰⵔⵜ ⵏⵏⴻⵙ ⴷ ⵜⵎⴻⵇⵢⴰⵙⵉⵏ ⴷⴻⴳ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","ⵅⴰⵙ ⵓⵛⴰ ⵓⴹⴰⵔⴻⵖ, ⴱⴻⵏⴷⵇⴻⵖ ⵉ ⵙⵉⴷⵉ ⵓⵛⴰ ⴱⴰⵔⴽⴻⵖ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏ ⵙⵉⴷⵉ ⵉⵏⵓ ⵉⴱⵔⴰⵀⵉⵎ, ⵡⴻⵏⵏⵉ ⴷ ⴰⵢⵉ ⵉⵏⴻⴷⵀⴻⵏ ⵏⵉⵛⴰⵏ ⴷⴻⴳ ⵡⴻⴱⵔⵉⴷ, ⵃⵉⵎⴰ ⴰⴷ ⴷⴷ-ⴰⵡⵢⴻⵖ ⵉⴵⵉⵙ ⵏ ⵓⵎⴰⵙ ⵏ ⵙⵉⴷⵉ ⵉⵏⵓ ⴷ ⵜⴻⵎⵖⴰⵔⵜ ⵉ ⵎⵎⵉⵙ. ");
INSERT INTO rift_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","ⵅⴻⵏⵏⵉ ⵍⴻⵅⵅⵓ, ⵎⴰⵍⴰ ⴽⴻⵏⵏⵉⵡ ⵜⴻⵅⵙⴻⵎ ⴰⴷ ⵜⴻⵙⵙⴻⵛⵏⴻⵎ ⵜⴰⵎⴻⵅⵙⵉⵡⵜ ⵉⵛⴻⵡⵡⴰⵔⴻⵏ ⴷ ⵍⴰⵎⴰⵏ ⵉ ⵙⵉⴷⵉ ⵉⵏⵓ, ⵉⵏⵉ ⴰⵢⵉ ⵜ, ⵎⴰⵍⴰ ⵍⵍⴰ, ⵉⵏⵉ ⴰⵢⵉ ⵜ ⵄⴰⵡⴻⴷ, ⵅⴻⵏⵏⵉ ⴰⴷ ⴽⴽⴻⵖ ⵢⴻⴼⵓⵙ ⵏⵉⵖ ⵓⵣⴻⵍⵎⴰⴹ.” ");
INSERT INTO rift_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","ⵅⴻⵏⵏⵉ ⵍⴰⴱⴰⵏ ⴷ ⴱⵉⵜⵓⵡⵉⵍ ⴰⵔⵔⵉⵏ-ⴷⴷ, ⵏⵏⴰⵏ: “ⵣⵉ ⵙⵉⴷⵉ ⵉ ⴷⴷ-ⵉⴼⴼⴻⵖ ⵓⵢⴰ, ⵡⴰⵔ ⵏⵣⴻⵎⵎⴰⵔ ⴰⴷ ⴷⴰⵢⴻⴽ ⵏⵉⵏⵉ ⵍⵖⴰⵔ ⵏⵉⵖ ⵍⵅⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","ⵅⵣⴰⵔ, ⵔⵉⴼⵇⴰ ⵇⵉⴱⴰⵍⵜ ⵏⵏⴻⵛ, ⴽⵙⵉ ⵜⵜ ⵓⵛⴰ ⵜⵔⵓⵃⴻⴷ. ⴰⴷ ⵜⵉⵍⵉ ⵏⴻⵜⵜⴰⵜ ⴷ ⵜⴰⵎⵖⴰⵔⵜ ⵏ ⵎⵎⵉⵙ ⵏ ⵙⵉⴷⵉ ⵏⵏⴻⵛ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵉⵏⵏⴰ ⵙⵉⴷⵉ!” ");
INSERT INTO rift_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","ⵓⵎⵉ ⵉⵙⵍⴰ ⵓⵎⵙⴻⵅⵅⴰⵔ ⵏ ⵉⴱⵔⴰⵀⵉⵎ ⴰⵡⴰⵍⴻⵏ ⵏⵙⴻⵏ, ⵉⴱⴻⵏⴷⴻⵇ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵣⵣⴰⵜ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","ⵓⵛⴰ ⵉⵙⵙⵓⴼⴼⴻⵖ-ⴷⴷ ⵓⵎⵙⴻⵅⵅⴰⵔ ⵍⴻⵇⵛⵓⵄ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⴷ ⵍⴻⵇⵛⵓⵄ ⵏ ⵡⵓⵔⴻⵖ ⴷ ⵡⴰⵔⵔⵓⴹⴻⵏ, ⵉⵡⵛⴰ ⵉ-ⵜⴻⵏ ⵉ ⵔⵉⴼⵇⴰ. ⵄⴰⵡⴻⴷ ⵉⵡⵛⴰ ⵜⵉⵔⵣⵉⴼⵉⵏ ⵉⵖⵍⴰⵏ ⵉ ⵓⵎⴰⵙ ⴷ ⵢⴻⵎⵎⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","ⵛⵛⵉⵏ, ⵙⵡⵉⵏ, ⵏⴻⵜⵜⴰ ⴷ ⵢⴻⵔⵢⴰⵣⴻⵏ ⵉⵏⵏⵉ ⴽⵉⵙ ⴷⴷ-ⵢⵓⵙⵉⵏ. ⵙⵙⴻⵏⵙⴻⵏ ⴷⵉⵏ ⵓⵛⴰ ⴼⴰⵇⴻⵏ ⵖⴰⵔ ⵚⵚⴱⴻⵃ. ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ: “ⵙⴰⵎⵃⴻⵎ ⴰⵢⵉ ⴰⴷ ⵔⴰⵃⴻⵖ ⵍⴻⵅⵅⵓ ⵖⴰⵔ ⵙⵉⴷⵉ ⵉⵏⵓ!” ");
INSERT INTO rift_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","ⴰⵔⵔⵉⵏ-ⴷⴷ ⵓⵎⴰⵙ ⴷ ⵢⴻⵎⵎⴰⵙ: “ⴻⵊⵊ ⵜⴰⴱⵍⵉⵖⵜ ⴰⴽⵉⴷⵏⴻⵖ ⵡⴰⵅⵅⴰ ⵎⵖⵉⵔ ⵄⴻⵛⵔⴰ ⵏ ⵡⵓⵙⵙⴰⵏ, ⴰⵡⴰⵔⵏⵉ ⴰⵙ ⴰⴷ ⵜⵓⵢⵓⵔⴻⴷ.” ");
INSERT INTO rift_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","ⵎⴰⵛⴰ ⵏⴻⵜⵜⴰ ⵉⵏⵏⴰ ⴰⵙⴻⵏ: “ⵡⴰⵔ ⴷⴰⵢⵉ ⵜᵉⵟⵟⵉⴼⴻⵎ ⵄⴰⴷ ⵓⵎⵉ ⵙⵉⴷⵉ ⵉⵙⵙⴻⵀⵡⴻⵏ ⴰⴱⵔⵉⴷ ⵉⵏⵓ! ⵎⵖⵉⵔ ⴻⵊⵊ ⴰⵢⵉ ⴰⴷ ⵔⴰⵃⴻⵖ ⵖⴰⵔ ⵙⵉⴷⵉ ⵉⵏⵓ.” ");
INSERT INTO rift_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","ⵏⵉⵜⵏⵉ ⴰⵔⵔⵉⵏ-ⴷⴷ ⵍⴻⵅⴷⴻⵏⵏⵉ: “ⴻⵊⵊ ⴰⵏⴻⵖ ⴰⴷ ⵏⵍⴰⵖⴰ ⵉ ⵜⴻⴱⵍⵉⵖⵜ, ⴰⴷ ⵏⵙⴻⵍ ⵉ ⵎⵉⵏ ⵖⴰ ⵜⵉⵏⵉ ⵣⴻⴳ ⵓⵇⴻⵎⵎⵓⵎ ⵏⵏⴻⵙ.” ");
INSERT INTO rift_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","ⵍⴰⵖⴰⵏ ⵉ ⵔⵉⴼⵇⴰ ⵓⵛⴰ ⵏⵏⴰⵏ ⴰⵙ: “ⵎⴰ ⴰⴷ ⵜⵔⴰⵃⴻⴷ ⵛⴻⵎ ⴰⴽ-ⴷ ⵡⴻⵔⵢⴰⵣ-ⴰ?” ⵓⵛⴰ ⵏⴻⵜⵜⴰⵜ ⵜⴰⵔⵔⴰ-ⴷⴷ: “ⵡⴰⵀ, ⴰⴷ ⵔⴰⵃⴻⵖ.” ");
INSERT INTO rift_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","ⵅⴻⵏⵏⵉ ⵙⵙⵇⴻⴱⴱⴹⴻⵏ ⵏⵉⵜⵏⵉ ⵔⵉⴼⵇⴰ, ⵓⵞⵎⴰⵜⵙⴻⵏ, ⴰⴽ-ⴷ ⵜⵎⴻⵟⵟⴰⴹⵜ ⵏⵏⴻⵙ, ⵓⵛⴰ ⵙⵙⵇⴻⴱⴱⴹⴻⵏ ⵄⴰⵡⴻⴷ ⴰⵎⵙⴻⵅⵅⴰⵔ ⵏ ⵉⴱⵔⴰⵀⵉⵎ ⴷ ⵉⵔⵢⴰⵣⴻⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","ⵓⵛⴰ ⴱⴰⵔⴽⴻⵏ ⵔⵉⴼⵇⴰ, ⵏⵏⴰⵏ ⴰⵙ: “ⴰ ⵓⵞⵎⴰⵜⵏⴻⵖ, ⴰⴷ ⵜⴰⵡⴹⴻⴷ ⴰⴷ ⵜⴻⵎⵖⴰⵔⴻⴷ ⴷ ⵍⵓⵍⵓⴼ ⵏ ⵄⴻⵛⵔⴰ ⵏ ⵍⵓⵍⵓⴼ ⵓⵛⴰ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵎ ⴰⴷ ⵜᵉⵟⵟⴻⴼ ⵜⴰⵡⵡⴰⵔⵜ ⵏ ⵢⵉⵏⵏⵉ ⵜⵜ ⵉⵛⴰⵔⵔⵀⴻⵏ!” ");
INSERT INTO rift_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","ⵜⴻⴽⴽⴰⵔ ⵔⵉⴼⵇⴰ ⴷ ⵜⴻⵎⵙⴻⵅⵅⴰⵔⵉⵏ ⵏⵏⴻⵙ ⵜⵉⵎⴻⵥⵢⴰⵏⵉⵏ, ⵏⵢⵉⵏⵜ ⵅ ⵉⵍⴻⵖⵎⴰⵏ, ⴹⴼⴰⵔⴻⵏⵜ ⴰⵔⵢⴰⵣ. ⴰⵎⵎⵓ ⵉ ⴷⴷ-ⵢⵉⵡⵉ ⵓⵎⵙⴻⵅⵅⴰⵔ ⵔⵉⴼⵇⴰ ⵓⵛⴰ ⵉⵔⵓⵃ. ");
INSERT INTO rift_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","ⴰⵇⴰ ⵉⴼⴼⴻⵖ-ⴷⴷ ⵉⵙⵃⴰⵇ ⵣⴻⴳ ⵡⴰⵏⵓ ⵏ ⵍⴰⵃⴰⵢ-ⵔⵓ’ⵉ. ⵜⵓⵖⴰ ⵉⵣⴻⴷⴷⴻⵖ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵍⵊⴰⵏⵓⴱ. ");
INSERT INTO rift_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","ⵉⴼⴼⴻⵖ-ⴷⴷ ⵉⵙⵃⴰⵇ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⵥⵥⴰⴵ ⴷⴻⴳ ⵉⵢⵢⴰⵔ. ⵜⵓⵖⴰ-ⵜⵜ ⵖⴰⵔ ⵓⵡⴻⵟⵟⵓ ⵏ ⵜⵎⴻⴷⴷⵉⵜ. ⵏⴻⵜⵜⴰ ⵉⵙⵙⴳⴻⵄⵄⴻⴷ ⵜⴰⵎⵓⵖⵍⵉ ⵏⵏⴻⵙ, ⵉⵇⵛⴻⵄ, ⵓ ⵅⵣⴰⵔ, ⵉⵍⴻⵖⵎⴰⵏ ⵜⵜⵇⴰⵔⵔⴰⴱⴻⵏ-ⴷⴷ! ");
INSERT INTO rift_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","ⵔⵉⴼⵇⴰ ⵄⴰⵡⴻⴷ ⵜⴻⵙⵙⴳⴻⵄⵄⴻⴷ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵙ, ⵜⴻⵥⵔⴰ ⵉⵙⵃⴰⵇ. ⵏⴻⵜⵜⴰⵜ ⵜⴻⵊⵊⴰ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⴰⴷ ⵜⴹⴰⵔ ⴷⴻⵖⵢⴰ ⵅ ⵡⴻⵍⵖⴻⵎ ");
INSERT INTO rift_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ⵓⵛⴰ ⵜⴻⵏⵏⴰ ⵉ ⵓⵎⵙⴻⵅⵅⴰⵔ: “ⵎⵉⵏ ⵉⵄⵏⴰ ⵡⴻⵔⵢⴰⵣ ⵏⵏⵉ ⴷⴷ-ⵢⵓⵙⵉⵏ ⴷⴻⴳ ⵉⵢⵢⴰⵔ ⵖⴰⵔⵏⴻⵖ?” ⵓⵛⴰ ⵉⵏⵏⴰ ⵓⵎⵙⴻⵅⵅⴰⵔ: “ⵡⴰ ⴷ ⵙⵉⴷⵉ ⵉⵏⵓ!” ⵅⴻⵏⵏⵉ ⵜⴻⴽⵙⵉ ⵜⴰⴽⴻⵏⴱⵓⵛⵜ ⵓⵛⴰ ⵜⵍⴻⵃⵃⴻⴼ. ");
INSERT INTO rift_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","ⵓⵛⴰ ⵉⵄⴰⵡⴻⴷ ⵓⵎⵙⴻⵅⵅⴰⵔ ⵉ ⵉⵙⵃⴰⵇ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⴳⴳⴰ. ");
INSERT INTO rift_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","ⵉⴳⴻⵡⵡⴻⴷ ⵉ-ⵜⵜ ⵉⵙⵃⴰⵇ ⵖⴰⵔ ⵓⵇⵉⴹⵓⵏ ⵏ ⵢⴻⵎⵎⴰⵙ ⵙⴰⵔⴰ, ⵢⵉⵡⵉ ⵔⵉⴼⵇⴰ ⵓⵛⴰ ⵏⴻⵜⵜⴰⵜ ⵜⴻⴷⵡⴻⵍ ⴷ ⵜⴰⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ ⵓ ⵏⴻⵜⵜⴰ ⵜⵓⵖⴰ ⵉⵜⵜⴻⵅⵙ ⵉ-ⵜⵜ. ⴰⵎⵎⵓ ⵉ ⵉⴼⴻⵡⵡⴻⵊ ⵉⵙⵃⴰⵇ ⴰⵡⴰⵔⵏⵉ ⵍⵎⴻⵡⵜ ⵏ ⵢⴻⵎⵎⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","ⵉⴽⵙⵉ ⵉⴱⵔⴰⵀⵉⵎ ⵜⴰⵎⵖⴰⵔⵜ ⵏⵏⴻⵖⵏⵉ, ⵇⵇⴰⵔⴻⵏ ⴰⵙ ⵇⴰⵜⵓⵔⴰ.    ");
INSERT INTO rift_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","ⵏⴻⵜⵜⴰ ⵜⵓⵔⵓⵡ ⴰⵙ-ⴷⴷ ⵣⵉⵎⵔⴰⵏ, ⵢⴰⵇⵛⴰⵏ, ⵎⵉⴷⵢⴰⵏ, ⵢⵉⵛⴱⴰⵇ ⴷ ⵛⵓⵃⴰ. ");
INSERT INTO rift_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","ⵢⵓⵇⵛⴰⵏ ⵉⵊⵊⴰ-ⴷⴷ ⵛⴰⴱⴰ ⴷ ⴷⴰⴷⴰⵏ. ⵓⵛⴰ ⴰⵔⵔⴰⵡⴻⵏ ⵏ ⴷⴰⴷⴰⵏ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵛⵛⵓⵔⵉⵢⵢⴻⵏ ⴷ ⵉⵍⵉⵜⵓⵛⵉⵢⵢⴻⵏ ⴷ ⵉⵍⵉⵢⵓⵎⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵎⵉⴷⵢⴰⵏ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵄⵉⵢⴼⴰ, ⵄⵉⴼⴰⵔ, ⵃⴰⵏⵓⵅ, ⴰⴱⵉⴷⴰⵄ ⴷ ⴰⵍⴷⴰⵄⴰ. ⵎⴰⵔⵔⴰ ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵇⴰⵟⵓⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","ⵉⴱⵔⴰⵀⵉⵎ ⵉⵡⵛⴰ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵖⴰⵔⴻⵙ ⵉ ⵉⵙⵃⴰⵇ. ");
INSERT INTO rift_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","ⵎⴰⵛⴰ ⵉ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵜⵉⵢⵢⴰ ⵉ ⵜⵓⵖⴰ ⵖⴰⵔ ⵉⴱⵔⴰⵀⵉⵎ, ⵉⵡⵛⴰ ⴰⵙⴻⵏ ⵉⴱⵔⴰⵀⵉⵎ ⴰⵔⵔⵉⵖⴰⵍⵓⵜ ⵓⵛⴰ, ⴰⵎ ⵜ ⵜⵓⵖⴰ ⵄⴰⴷ ⵉⴷⴷⴰⵔ, ⵉⵙⵙⴻⴽⴽ ⵉ-ⵜⴻⵏ ⵙⵙⴻⵏⵏⵉ ⵖⴰⵔ ⵛⵛⴰⵔⵇ, ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵛⵛⴰⵔⵇ, ⵉⵙⵙⵉⴳⴳⵯⴻⵊ ⵉ-ⵜⴻⵏ ⵅ ⵉⵙⵃⴰⵇ ⵎⵎⵉⵙ. ");
INSERT INTO rift_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","ⵉⴱⵔⴰⵀⵉⵎ ⵜⵓⵖⴰ ⵉⴷⴷⴰⵔ ⵎⵢⴰ ⵓ-ⵅⴻⵎⵙⴰ ⵓ-ⵙⴻⴱⵄⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵡⴰ ⴷ ⵍⵎⵉⵊⴰⵍ ⵏ ⵜⵓⴷⴰⵔⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","ⵉⴹⵍⴻⵇ ⵉⴱⵔⴰⵀⵉⵎ ⵉ ⴱⵓⵃⴱⴻⵍ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⵎⵎⵓⵜ ⴷⵉ ⵛⵛⵉⴱ ⵉⵙⴻⴳⴳⴻⴷ, ⴷⵉ ⵜⴻⵡⵙⴰⵔ ⴷ ⵜⵢⴰⵡⴰⵏⵜ. ⵓⵛⴰ ⵉⵎⵎⴰⵔⵏⵉ ⵖⴰⵔ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","ⵉⵙⵃⴰⵇ ⴷ ⵉⵙⵎⴰⵄⵉⵍ, ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ, ⵏⴻⴹⵍⴻⵏ ⵜ ⴷⴻⴳ ⵉⴼⵔⵉ ⵏ ⵎⴰⴽⴼⵉⵍⴰ ⴷⴻⴳ ⵉⵢⵢⴰⵔ ⵏ ⵄⵉⴼⵔⵓⵏ, ⵎⵎⵉⵙ ⵏ ⵚⵓⵃⴰⵔ, ⴰⵃⵉⵜⵜⵉ, ⵉⵢⵢⴰⵔ ⵉ ⵉⴵⴰⵏ ⵇⵉⴱⴰⵍⵜ ⵉ ⵎⴰⵎⵔⵉ. ");
INSERT INTO rift_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","ⵉⵜⵜⵡⴰⵏⴹⴻⵍ ⵉⴱⵔⴰⵀⵉⵎ ⴷ ⵜⴻⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ ⵙⴰⵔⴰ ⴷⴻⴳ ⵉⵢⵢⴰⵔ ⵏⵏⵉ ⵉⵙⵖⴰ ⵉⴱⵔⴰⵀⵉⵎ ⵣⵉ ⵜⴰⵔⵡⴰ ⵏ ⵃⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","ⴰⵡⴰⵔⵏⵉ ⵉ ⵍⵎⴻⵡⵜ ⵏ ⵉⴱⵔⴰⵀⵉⵎ ⵉⴱⴰⵔⴻⴽ ⴰⵔⴻⴱⴱⵉ ⵎⵎⵉⵙ ⵉⵙⵃⴰⵇ. ⵓⵛⴰ ⵉⵣⴷⴻⵖ ⵉⵙⵃⴰⵇ ⵣⵣⴰⵜ ⵉ ⵡⴰⵏⵓ ⵏ ⵍⴰⵃⴰⵢ-ⵔⵓ’ⵉ. ");
INSERT INTO rift_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","ⵉⵏⴰ ⴷ ⵉⵎⴻⵣⵔⵓⵢⴻⵏ ⵏ ⵢⵉⵏⵏⵉ ⴷⴷ-ⵉⵜⵜⵡⴰⵅⴻⵍⵇⴻⵏ ⵣⵉ ⵉⵙⵎⴰⵄⵉⵍ, ⵎⵎⵉⵙ ⵏ ⵉⴱⵔⴰⵀⵉⵎ, ⵉⵏⵏⵉ ⴷⴷ-ⵜⴻⵊⵊⴰ ⵀⴰⵊⴰⵔ, ⵜⴰⵢⵢⴰ ⵏ ⵙⴰⵔⴰ ⵣⵉ ⵎⵉⵚⵔⴰ, ⵉ ⵉⴱⵔⴰⵀⵉⵎ. ");
INSERT INTO rift_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","ⴷ ⵢⵉⵏⴰ ⴷ ⵉⵙⵎⴰⵡⴻⵏ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵉⵙⵎⴰⵄⵉⵍ, ⵙ ⵉⵙⵎⴰⵡⴻⵏ ⵏⵙⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⴰⵅⵍⴰⵇ ⵏⵙⴻⵏ. ⴰⵎⴻⵏⵣⵓ ⵏ ⵉⵙⵎⴰⵄⵉⵍ ⵜⵓⵖⴰ-ⵜ ⴷ ⵏⴰⴱⴰⵢⵓⵜ, ⵅⴻⵏⵏⵉ ⵇⵉⴷⴰⵔ, ⴰⴷⴱⵉⵢⵉⵍ, ⵎⵉⴱⵙⴰⵎ, ");
INSERT INTO rift_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","ⵎⵉⵙⵎⴰ, ⴷⵓⵎⴰ, ⵎⴰⵙⵙⴰ, ");
INSERT INTO rift_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ⵃⴰⴷⴰⵔ, ⵜⴰⵢⵎⴰ, ⵢⴰⵟⵓⵔ, ⵏⴰⴼⵉⵛ ⴷ ⵇⵉⴷⵎⴰ. ");
INSERT INTO rift_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","ⴷ ⵢⵉⵏⴰ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵉⵙⵎⴰⵄⵉⵍ ⵙ ⵉⵙⵎⴰⵡⴻⵏ ⵏⵙⴻⵏ, ⵙ ⴷⵛⵓⵔⴰⵜ ⵏⵙⴻⵏ ⴷ ⵍⵎⴰⵔⴰⴳⴻⵃ ⵏⵙⴻⵏ: ⵜⴻⵏⵄⴰⵛ ⵏ ⵍⵃⵓⴽⴽⴰⵎ ⵙ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","ⵜⵓⵖⴰ ⵉⴷⴷⴰⵔ ⵉⵙⵎⴰⵄⵉⵍ ⵎⵢⴰ ⵓ-ⵙⴻⴱⵄⴰ ⵓ-ⵜⵍⴰⵜⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ. ⵅⴻⵏⵏⵉ ⵉⴹⵍⴻⵇ ⵉⵙⵎⴰⵄⵉⵍ ⵉ ⴱⵓⵃⴱⴻⵍ ⵏⵏⴻⵙ, ⵉⵎⵎⵓⵜ ⵓⵛⴰ ⵉⵎⵎⴰⵔⵏⵉ ⵖⴰⵔ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","ⵏⵉⵜⵏⵉ ⵣⴻⴷⴷⵖⴻⵏ ⵣⵉ ⵃⴰⵡⵉⵍⴰ ⵖⴰⵔ ⵛⵓⵔ, ⵡⴻⵏⵏⵉ ⵉⴵⴰⵏ ⴰⵔⴻⵏⴷⴰⴷ ⵏ ⵎⵉⵚⵔⴰ, ⴰⵎ ⵜᵉⵟⵟⴼⴻⴷ ⴰⴱⵔⵉⴷ ⵖⴰⵔ ⴰⵛⵛⵓⵔ. ⵏⴻⵜⵜⴰ ⵉⵣⴷⴻⵖ ⴰⵔⴻⵏⴷⴰⴷ ⵏ ⵎⴰⵔⵔⴰ ⴰⵢⵜⵎⴰⵙ. ⵉⵏⴰ ⴷ ⵉⵎⴻⵣⵔⵓⵢⴻⵏ ⵏ ⵢⵉⵏⵏⵉ ⴷⴷ-ⵉⵜⵜⵡⴰⵅⴻⵍⵇⴻⵏ ⵣⵉ ⵉⵙⵃⴰⵇ, ⵎⵎⵉⵙ ⵏ ⵉⴱⵔⴰⵀⵉⵎ. ");
INSERT INTO rift_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","ⵉⴱⵔⴰⵀⵉⵎ ⵉⵊⵊⴰ-ⴷⴷ ⵉⵙⵃⴰⵇ. ");
INSERT INTO rift_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","ⵜⵓⵖⴰ ⵖⴰⵔ ⵉⵙⵃⴰⵇ ⴰⵔⴻⴱⵄⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵓⵎⵉ ⵢⵉⵡⵉ ⵔⵉⴼⵇⴰ ⴷ ⵜⴰⵎⵖⴰⵔⵜ. ⵏⴻⵜⵜⴰⵜ ⴷ ⵢⴻⴵⵉⵙ ⵏ ⴱⵉⵜⵓⵡⵉⵍ, ⴰⵔⴰⵎⵉⵢⵓ ⵣⵉ ⴼⴰⴷⴷⴰⵏ-ⴰⵔⴰⵎ, ⵓⵞⵎⴰⵙ ⵏ ⵍⴰⴱⴰⵏ, ⴰⵔⴰⵎⵉⵢⵓ. ");
INSERT INTO rift_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","ⵉⵃⴻⵛⵛⴻⵎ ⵉⵙⵃⴰⵇ ⵙⵉⴷⵉ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ, ⵜⴻⵏⵏⵉ ⵜⵓⵖⴰ ⵡⴰⵔ ⵉⵜⵜⵉⵔⵡⴻⵏ ⵛⴰ, ⵓⵛⴰ ⵉⵙⵜⴰⵊⴻⴱ ⴰⵙ ⵙⵉⴷⵉ ⵙ ⵜⵥⴰⴵⵉⵜ ⵏⵏⴻⵙ ⵢⵓⴵⵖⴻⵏ, ⴰⵍⴰⵎⵉ ⵜⴻⴽⵙⵉ ⵜⴻⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ, ⵔⵉⴼⵇⴰ, ⴷⴷⴻⵢⵙⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","ⵓⵛⴰ ⵎⵎⴷⴻⵃⵙⴻⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⴷⴻⴳ ⵓⵄⴻⴷⴷⵉⵙ ⵏⵏⴻⵙ. ⵅⴻⵏⵏⵉ ⵜⴻⵏⵏⴰ: “ⵎⴰⵏⴰⵡⵢⴰ ⵄⴰⵡⴻⴷ, ⵎⴰⵢⴻⵎⵎⵉ ⴷ ⴰⵢⵉ ⵉⵜⵜⴻⵎⵙⴰⵔ ⵎⴰⵏ ⴰⵢⴰ?”, ⵓⵛⴰ ⵜⵔⵓⵃ ⴰⴷ ⵜⴻⵙⵙⴻⵇⵙⴰ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","ⵉⵏⵏⴰ ⴰⵙ ⵙⵉⴷⵉ: “ⴰⵇⴰ ⴷⵉⵏ ⵜⵏⴰⵢⴻⵏ ⵏ ⵍⴻⴳⵏⵓⵙ ⴷⵉ ⴷⴷⴻⵢⵙⴻⵜ ⵏⵏⴻⵎ ⵓ ⵜⵏⴰⵢⴻⵏ ⵏ ⵛⵛⵓⵄⵓⴱ ⴰⴷ ⵎⵎⵙⴻⴱⴹⴰⵏ ⵣⵉ ⴷⵡⴰⵅⴻⵍ ⵏⵏⴻⵎ. ⵉⵊⵊ ⵏ ⵛⵛⴻⵄⴱ ⴰⴷ ⵢⵉⵍⵉ ⵉⵊⵀⴻⴷ ⵅ ⵛⵛⴻⵄⴱ ⵏⵏⴻⵖⵏⵉ ⵓ ⵡⴻⵏⵏⵉ ⴷ ⴰⵎⴻⵏⵣⵓ ⴰⴷ ⵉⵅⴷⴻⵎ ⵉ ⵓⵎⴰⵥⵓⵥ.” ");
INSERT INTO rift_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","ⴰⵍⴰⵎⵉ ⴷⴷ-ⵉⵡⴹⴻⵏ ⵡⵓⵙⵙⴰⵏ ⵏⵏⴻⵙ ⴰⴷ ⵜⴰⵔⵓ, ⵅⵣⴰⵔ, ⴰⵇⴰ ⴷⴰ ⴷⴻⴳ ⵓⵄⴻⴷⴷⵉⵙ ⵏⵏⴻⵙ ⴰⵛⵏⵉⵡⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","ⵉⴼⴼⴻⵖ-ⴷⴷ ⵓⵎⴻⵣⵡⴰⵔ. ⵜⵓⵖⴰ-ⵜ ⴷ ⴰⵣⴻⴳⴳⵯⴰⵖ, ⵉⵛⴻⵄⵄⴰⵔ ⵇⴰⵄ ⴰⵎ ⵢⵉⵛⵜ ⵏ ⵜⵀⵉⴹⵓⵔⵜ. ⵙ ⵓⵢⴻⵏⵏⵉ ⴳⴳⵉⵏ ⴰⵙ ⵄⵉⵙⵓ. ");
INSERT INTO rift_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","ⴰⵡⴰⵔⵏⵉ ⴰⵙ ⵉⴼⴼⴻⵖ-ⴷⴷ ⵓⵎⴰⵙ. ⵉⵟⵟⴻⴼ ⴰⴼⵓⵙ ⵏⵏⴻⵙ ⴷⴻⴳ ⵓⵏⵉⵔⵣ ⵏ ⵄⵉⵙⵓ. ⵙ ⵓⵢⴰ ⵙⴻⵎⵎⴰⵏ ⵜ ⵙ ⵢⵉⵙⴻⵎ ⵢⴰⵄⵇⵓⴱ. ⵜⵓⵖⴰ ⵖⴰⵔ ⵉⵙⵃⴰⵇ ⵙⴻⵜⵜⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵖⴰⵔ ⵡⴻⵅⵍⴰⵇ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","ⵍⴰⵎⵉ ⴳⵎⴰⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ, ⵉⴷⵡⴻⵍ ⵄⵉⵙⵓ ⴷ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵉⵙⵙⴻⵏ ⴰⵏⴻⵢⵎⴰⵔ, ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵏ ⴱⴰⵔⵔⴰ, ⵎⴰⵛⴰ ⵢⴰⵄⵇⵓⴱ ⵉⴷⵡⴻⵍ ⴷ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵢⴰⵔⵙⴰ, ⵡⴻⵏⵏⵉ ⵉⵣⴻⴷⴷⵖⴻⵏ ⴷⴻⴳ ⵉⵇⵉⴹⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","ⵉⵙⵃⴰⵇ ⵜⵓⵖⴰ ⵉⵜⵜⴻⵅⵙ ⵄⵉⵙⵓ, ⵎⵉⵏⵣⵉ ⵉⵄⵊⴻⴱ ⴰⵙ ⴰⴷ ⵢⴻⵛⵛ ⴰⵢⵙⵓⵎ ⵏ ⵍⵎⴰⵍ ⵏ ⵍⴻⵅⵍⴰ, ⵓ ⵔⵉⴼⵇⴰ ⵜⵓⵖⴰ ⵜᵉⵜⵜⴻⵅⵙ ⵢⴰⵄⵇⵓⴱ. ");
INSERT INTO rift_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","ⵓⵛⴰ ⵉⵙⵙⵏⴻⵏⵏⵉ ⵢⴰⵄⵇⵓⴱ ⵉⵛⵜ ⵏ ⵎⴰⵛⵛⴰ, ⵓⵎⵉ ⴷⴷ-ⵉⵄⵇⴻⴱ ⵄⵉⵙⵓ ⵣⵉ ⵍⴻⵅⵍⴰ, ⵢⵓⵃⴻⵍ. ");
INSERT INTO rift_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","ⵉⵏⵏⴰ ⵄⵉⵙⵓ ⵉ ⵢⴰⵄⵇⵓⴱ: “ⵜⵜⵣⴰⵡⴳⴻⵖ ⵛⴻⴽ ⴰⴷ ⴰⵢⵉ ⵜⴻⵡⵛⴻⴷ ⴰⴷ ⵛⵛⴻⵖ ⵣⴻⴳ ⵓⵣⴻⴳⴳⵯⴰⵖ, ⴰⵣⴻⴳⴳⵯⴰⵖ ⵏⵏⵉ ⴷⵉⵀⴰ, ⵎⴰⵖⴰⵔ ⴰⵇⴰ ⴼⵏⵉⵖ ⵙ ⵓⴼⴰⴷⵉ.” ⵅ ⵓⵢⴰ ⵇⵇⴰⵔⴻⵏ ⴰⵙ ‘ⵉⴷⵓⵎ’. ");
INSERT INTO rift_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵢⴰⵄⵇⵓⴱ: “ⵣⴻⵏⵣ ⴰⵢⵉ ⴰⵙⵙ-ⴰ ⵍⵃⴻⵇⵇ ⵏⵏⴻⵛ ⵏ ⵓⵎⴻⵏⵣⵓ.” ");
INSERT INTO rift_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","ⵉⵏⵏⴰ ⵄⵉⵙⵓ: “ⵅⵣⴰⵔ, ⴰⵇⴰ ⵏⴻⵛⵛ ⴰⴷ ⵎⵎⵜⴻⵖ, ⵎⵉⵏ ⵖⴰ ⴳⴳⴻⵖ ⵙ ⵍⵃⴻⵇⵇ ⵏ ⵓⵎⴻⵏⵣⵓ?” ");
INSERT INTO rift_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵢⴰⵄⵇⵓⴱ: “ⵊⴰⴵ ⴰⵢⵉ ⵍⴻⵅⵅⵓ!” ⵓⵛⴰ ⵉⵊⵊⵓⴵ ⴰⵙ, ⵉⵣⵣⴻⵏⵣ ⵉ ⵢⴰⵄⵇⵓⴱ ⵍⵃⴻⵇⵇ ⵏ ⵓⵎⴻⵏⵣⵓ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","ⵅⴰⵙ ⵓⵛⴰ ⵉⵡⵛⴰ ⵢⴰⵄⵇⵓⴱ ⵉ ⵄⵉⵙⵓ ⴰⵖⵔⵓⵎ ⴷ ⵓⵎⴻⵛⵍⵉ ⵏ ⵍⴻⵄⴷⴻⵙ, ⵓ ⵄⵉⵙⵓ ⵉⵛⵛⴰ, ⵉⵙⵡⴰ, ⵉⴽⴽⴰⵔ, ⵉⵔⵓⵃ. ⴰⵎⵎⵓ ⵉⵙⵙⴻⵃⵇⴰⵔ ⵄⵉⵙⵓ ⵍⵃⴻⵇⵇ ⵏ ⵓⵎⴻⵏⵣⵓ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","ⵜⵓⵖⴰ ⵉⴵⴰ ⵍⴰⵥ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ, ⵉⵊⵊ ⵏ ⵍⴰⵥ ⵏⵏⴻⵖⵏⵉ ⵅ ⵓⵎⴻⵣⵡⴰⵔ ⵏⵏⵉ ⵜⵓⵖⴰ ⵉⴵⴰⵏ ⴷⴻⴳ ⵡⵓⵙⵙⴰⵏ ⵏ ⵉⴱⵔⴰⵀⵉⵎ. ⵙ ⵓⵢⴰ ⵉⵔⵓⵃ ⵉⵙⵃⴰⵇ ⵖⴰⵔ ⴰⴱⵉⵎⴰⵍⵉⴽ, ⴰⵊⴻⴵⵉⴷ ⵏ ⵉⴼⵉⵍⵉⵙⵟⵉⵏⵉⵢⵢⴻⵏ, ⵖⴰⵔ ⵊⵊⵡⴰⵢⴻⵀ ⵏ ⵊⵉⵔⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","ⴷⵉⵏⵏⵉ ⵉⴱⴰⵏ ⴰⵙ-ⴷⴷ ⵙⵉⴷⵉ, ⵉⵏⵏⴰ: “ⵡⴰⵔ ⵀⴻⴽⴽⵡⵉ ⵛⴰ ⵖⴰⵔ ⵎⵉⵚⵔⴰ. ⵣⴷⴻⵖ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵉ ⴷ ⴰⵛ ⵖⴰ ⵉⵏⵉⵖ. ");
INSERT INTO rift_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","ⵣⴷⴻⵖ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ-ⴰ ⴰⵎ ⵓⴱⴰⵔⵔⴰⵏⵉ ⵓ ⵏⴻⵛⵛ ⴰⴷ ⴽⵉⴽ ⵉⵍⵉⵖ, ⴰⴷ ⵛⴻⴽ ⴱⴰⵔⴽⴻⵖ, ⵎⵉⵏⵣⵉ ⵉ ⵛⴻⴽ ⵓ ⵉ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵛ ⵓⵎⵉ ⵖⴰ ⵡⵛⴻⵖ ⵎⴰⵔⵔⴰ ⵜⵉⵎⵎⵓⵔⴰ-ⵢⴰ ⵓⵛⴰ ⴰⴷ ⴽⴻⵎⵎⵍⴻⵖ ⵜⵊⴰⴵⵉⵜ ⵉ ⵊⵊⵓⴵⴻⵖ ⵉ ⵉⴱⵔⴰⵀⵉⵎ ⴱⴰⴱⴰⵛ. ");
INSERT INTO rift_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","ⴰⴷ ⴽⴻⵜⵜⴰⵔⴻⵖ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵛ ⴰⵎ ⵢⵉⵜⵔⴰⵏ ⵏ ⵓⵊⴻⵏⵏⴰ ⵓⵛⴰ ⴰⴷ ⵡⵛⴻⵖ ⵉ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵛ ⵎⴰⵔⵔⴰ ⵜⵉⵎⵎⵓⵔⴰ-ⵢⴰ. ⵎⴰⵔⵔⴰ ⵍⴻⴳⵏⵓⵙ ⵏ ⴷⴷⵓⵏⴻⵛⵜ ⴰⴷ ⵜⵜⵡⴰⴱⴰⵔⴽⴻⵏ ⴷⵉ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵛ, ");
INSERT INTO rift_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","ⵎⵉⵏⵣⵉ ⵉⵙⵍⴰ ⵉⴱⵔⴰⵀⵉⵎ ⵉ ⵡⴰⵡⴰⵍ ⵉⵏⵓ ⵓⵛⴰ ⵉⵃⴹⴰ ⵎⵉⵏ ⴷ ⴰⵙ ⵡⵛⵉⵖ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⵃⴹⴰ: ⵍⵓⵎⵓⵔⴰⵜ ⵉⵏⵓ, ⵜⵉⵡⴻⵚⵚⴰ ⵉⵏⵓ ⴷ ⵉⵣⴻⵔⴼⴰⵏ ⵉⵏⵓ.” ");
INSERT INTO rift_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","ⴰⵎⵎⵓ ⵉ ⵉⵇⵇⵉⵎ ⵉⵙⵃⴰⵇ ⵉⵣⴻⴷⴷⴻⵖ ⴷⵉ ⵊⵉⵔⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","ⵍⴰⵎⵉ ⵜ ⵙⵙⴻⵇⵙⴰⵏ ⵉⵔⵢⴰⵣⴻⵏ ⵏ ⵡⴻⵎⵛⴰⵏ ⵏⵏⵉ ⵅ ⵜⴻⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ, ⵉⵏⵏⴰ ⴰⵙⴻⵏ: “ⵏⴻⵜⵜⴰⵜ ⴷ ⵓⵞⵎⴰ!”, ⵎⵉⵏⵣⵉ ⵉⴳⴳⵯⴻⴷ ⴰⴷ ⵢⵉⵏⵉ: “ⴷ ⵜⴰⵎⵖⴰⵔⵜ ⵉⵏⵓ!”. ⵎⴰⵖⴰⵔ ⵉⵏⵏⴰ ⴷⴻⴳ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵙ: “ⵎⴰⵍⴰ ⵡⴰⵔ ⵏⵏⵉⵖ ⴰⵎⴻⵏⵏⵉ ⴰⴷ ⴰⵢⵉ ⵏⵖⴻⵏ ⵉⵔⵢⴰⵣⴻⵏ ⵏ ⵡⴻⵎⵛⴰⵏ-ⴰ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏ ⵔⵉⴼⵇⴰ, ⵎⵉⵏⵣⵉ ⴰⵇⴰ ⴷⴰⵢⴻⵙ ⴰⵥⵔⵉ.” ");
INSERT INTO rift_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","ⵍⴰⵎⵉ ⴷⵉⵏ ⵉⵣⴷⴻⵖ ⴰⵟⵟⴰⵙ ⵏ ⵡⵓⵙⵙⴰⵏ, ⵉⵎⵙⴰⵔ ⴱⴻⵍⵍⵉ ⴰⴱⵉⵎⴰⵍⵉⴽ, ⴰⵊⴻⴵⵉⴷ ⵏ ⵉⴼⵉⵍⵉⵙⵟⵉⵏⵉⵢⵢⴻⵏ, ⵉⵅⵣⴰⵔ-ⴷⴷ ⵣⵉ ⵍⴽⴰⵣⵉ, ⵉⵥⵔⴰ ⵉⵙⵃⴰⵇ ⵉⵜⵜⵄⴰⵜⴰⴱ ⵔⵉⴼⵇⴰ, ⵜⴰⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","ⵓⵛⴰ ⵉⵍⴰⵖⴰ ⴰⴱⵉⵎⴰⵍⵉⴽ ⵅ ⵉⵙⵃⴰⵇ, ⵉⵏⵏⴰ ⴰⵙ: “ⵅⵣⴰⵔ, ⵜⴰ ⵙ ⵜⵉⴷⴻⵜⵜ ⴷ ⵜⴰⵎⵖⴰⵔⵜ ⵏⵏⴻⵛ! ⵎⴰⵎⵎⴻⵛ ⵜⴻⴳⴳⵉⴷ ⵜⴻⵏⵏⵉⴷ ⴰⵏⴻⵖ ⴷ ⵓⵍⵜⵎⴰ?” ⵉⵙⵃⴰⵇ ⵉⵏⵏⴰ ⴰⵙ: “ⵙ ⵎⵉⵏⵣⵉ ⵏⵏⵉⵖ ⵉ ⵢⵉⵅⴻⴼ ⵉⵏⵓ: ‘ⴰⵇⴰ ⵜⵉⵍⵉ ⴰⴷ ⴰⵢⵉ ⵏⵖⴻⵏ ⵅ ⵙⵙⵉⴱⴱⴻⵜ ⵏⵏⴻⵙ.’” ");
INSERT INTO rift_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","ⴰⴱⵉⵎⴰⵍⵉⴽ ⵉⵏⵏⴰ: “ⵎⴰⵖⴰⵔ ⴷ ⴰⵏⴻⵖ ⵜⴻⴳⴳⵉⴷ ⴰⵢⴰ? ⵅ ⴷⵔⵓⵙ ⴰⴷ ⵢⵉⵍⵉ ⵉⵟⵟⴻⵚ ⵛⴰ ⵏ ⵉⵊⵊ ⵣⵉ ⵍⴳⴻⵏⵙ ⴰⴽ-ⴷ ⵜⴻⵎⵖⴰⵔⵜ ⵏⵏⴻⵛ ⵓⵛⴰ ⴰⴷ ⵜⵉⵍⵉ ⵜⴻⴳⴳⵉⴷ ⴷⴷⴻⵏⴱ ⵅ ⵢⵉⵍⵉ ⵏⵏⴻⵖ.” ");
INSERT INTO rift_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","ⵢⵓⵎⵓⵔ ⴰⴱⵉⵎⴰⵍⵉⴽ ⵎⴰⵔⵔⴰ ⵍⴳⴻⵏⵙ, ⵉⵏⵏⴰ: “ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵉⵃⴰⴷⴰⵏ ⴰⵔⵢⴰⵣ-ⴰ ⵏⵉⵖ ⵜⴰⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ, ⴰⴷ ⵜ ⵏⵖⴻⵏ ⵏⵉⵛⴰⵏ!” ");
INSERT INTO rift_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","ⵉⵣⴰⵔⵄ ⵉⵙⵃⴰⵇ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⵉ ⵓⵛⴰ ⵉⴽⵙⵉ ⴰⵙⴻⴳⴳⵯⴰⵙ ⵏⵏⵉ ⵎⵢⴰ ⵏ ⵉⵎⵓⵔⴻⵏ ⵏ ⵣⵣⵢⴰⴷⴰ, ⵎⵉⵏⵣⵉ ⵉⴱⴰⵔⴽ ⵉ-ⵜ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","ⵜⴻⵎⵎⴰⵔⵏⵉ ⵛⵛⴻⵏⵄⴻⵜ ⵏ ⵡⴻⵔⵢⴰⵣ ⵏⵏⵉ ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵉⵇⵇⵉⵎ ⵉⵎⴻⵇⵇⴰⵔ, ⴰⵍⴰⵎⵉ ⵜⴻⴷⵡⴻⵍ ⵛⵛⴻⵏⵄⴻⵜ ⵏⵏⴻⵙ ⴷ ⵜⴰⵎⴻⵇⵇⵔⴰⵏⵜ ⴰⵟⵟⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","ⵜⵓⵖⴰ ⵖⴰⵔⴻⵙ ⵓⴵⵉ ⵓ ⵖⴰⵔⴻⵙ ⵄⴰⵡⴻⴷ ⵉⴼⵓⵏⴰⵙⴻⵏ ⴷ ⵜⴼⵓⵏⴰⵙⵉⵏ ⴷ ⵡⴰⵟⵟⴰⵙ ⵏ ⵉⵙⴻⵎⵖⴰⵏ, ⴰⵍⴰⵎⵉ ⵣⵣⴰⵢⴻⵙ ⵓⵙⵎⴻⵏ ⵉⴼⵉⵍⵉⵙⵟⵉⵏⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","ⵎⴰⵔⵔⴰ ⴰⵏⵓⵜⴻⵏ ⵏⵏⵉ ⵖⵣⴰⵏ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⴷⴻⴳ ⵡⵓⵙⵙⴰⵏ ⵏ ⵉⴱⵔⴰⵀⵉⵎ ⴱⴰⴱⴰⵙ, ⵏⴻⵜⵢⴻⵏ ⵜⴻⵏ ⵉⴼⵉⵍⵉⵙⵟⵉⵏⵉⵢⵢⴻⵏ ⵓⵛⴰ ⵛⵛⵓⵔⴻⵏ ⵜⴻⵏ ⵙ ⵓⵛⴰⵍ. ");
INSERT INTO rift_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⴰⴱⵉⵎⴰⵍⵉⴽ ⵉ ⵉⵙⵃⴰⵇ: “ⴱⴻⵄⵄⴻⴷ ⵅⴰⵏⴻⵖ, ⵎⵉⵏⵣⵉ ⵜⴷⴻⵡⵍⴻⴷ ⵜⵊⴻⵀⴷⴻⴷ ⵅⴰⵏⴻⵖ ⵙ ⵡⴰⵟⵟⴰⵙ.” ");
INSERT INTO rift_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","ⵉⵙⵃⴰⵇ ⵉⵔⵓⵃ ⵙⵙⴻⵏⵏⵉ, ⵉⵡⵜⴰ ⵉⵇⵉⴹⴰⵏ ⵏⵏⴻⵙ ⴷⵉ ⵜⴻⵖⵣⵓⵔⵜ ⵏ ⵊⵉⵔⴰⵔ ⵓⵛⴰ ⵉⵣⴷⴻⵖ ⴷⵉⵏⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","ⵓⵛⴰ ⵉⴷⵡⴻⵍ ⵉⵙⵃⴰⵇ ⵉⵖⵣⴰ ⴰⵏⵓⵜⴻⵏ ⵏ ⵡⴰⵎⴰⵏ ⵉⵏⵏⵉ ⵜⵓⵖⴰ ⵖⵣⵉⵏ ⴷⴻⴳ ⵡⵓⵙⵙⴰⵏ ⵏ ⵉⴱⵔⴰⵀⵉⵎ ⴱⴰⴱⴰⵙ, ⵉⵏⵏⵉ ⵏⴻⵜⵢⴻⵏ ⵉⴼⵉⵍⵉⵙⵟⵉⵏⵉⵢⵢⴻⵏ ⴰⵡⴰⵔⵏⵉ ⵉ ⵍⵎⴻⵡⵜ ⵏ ⵉⴱⵔⴰⵀⵉⵎ. ⵉⵙⴻⵎⵎⴰ ⵜⴻⵏ ⵙ ⵉⵙⵎⴰⵡⴻⵏ ⵉⵏⵏⵉ ⴷ ⴰⵙⴻⵏ ⵉⵍⴰⵖⴰ ⴱⴰⴱⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","ⵓⵛⴰ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏ ⵉⵙⵃⴰⵇ ⵖⵣⴰⵏ ⴷⵉ ⵜⴻⵖⵣⵓⵔⵜ ⵏⵏⵉ ⵓⵛⴰ ⵓⴼⵉⵏ ⴷⵉⵏ ⵍⵄⵓⵏⵚⴰⵔ ⵏ ⵡⴰⵎⴰⵏ ⴷⴷⴰⵔⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","ⵅⴻⵏⵏⵉ ⵇⴰⵛⵃⴻⵏ ⵉⵎⴻⴽⵙⴰⵡⴻⵏ ⵏ ⵊⵉⵔⴰⵔ ⴰⴽ-ⴷ ⵉⵎⴻⴽⵙⴰⵡⴻⵏ ⵏ ⵉⵙⵃⴰⵇ, ⵏⵏⴰⵏ: “ⴰⵎⴰⵏ ⵏⵏⴻⵖ!” ⵙ ⵓⵢⴻⵏⵏⵉ ⵍⴰⵖⴰⵏ ⵉⵙⴻⵎ ⵏ ⵍⵄⵓⵏⵚⴰⵔ ⵏⵏⵉ ‘ⵄⵉⵙⵉⵇ’, ⵎⵉⵏⵣⵉ ⵜⵓⵖⴰ ⵜⵜⵇⴰⵛⴰⵃⴻⵏ ⵅⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","ⵅⴻⵏⵏⵉ ⵖⵣⴰⵏ ⵉⵊⵊ ⵏ ⵍⵄⵓⵏⵚⴰⵔ ⵏⵏⴻⵖⵏⵉ ⵓⵛⴰ ⵎⵎⴻⵏⵏⵖⴻⵏ ⵅⴰⵙ ⵄⴰⵡⴻⴷ. ⵙ ⵓⵢⴻⵏⵏⵉ ⴷ ⴰⵙ ⵉⴳⴳⴰ ⵉⵙⴻⵎ ⵏ ‘ⵙⵉⵜⵏⴰ’. ");
INSERT INTO rift_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","ⵓⵛⴰ ⵉⴱⴻⵄⵄⴻⴷ ⵙⵙⴻⵏⵏⵉ, ⵉⵖⵣⴰ ⵉⵊⵊ ⵏ ⵍⵄⵓⵏⵚⴰⵔ ⵏⵏⴻⵖⵏⵉ, ⵡⴰⵔ ⵅⴰⵙ ⵇⵉⵛⵃⴻⵏ ⵛⴰ ⵓⵛⴰ ⴳⴳⵉⵏ ⴰⵙ ⵉⵙⴻⵎ ⵏⵏⴻⵙ ‘ⵔⴰⵃⵓⴱⵓⵜ’, ⵉⵏⵏⴰ: “ⵍⴻⵅⵅⵓ ⵙⵉⴷⵉ ⵉⵡⵛⴰ ⴰⵏⴻⵖ ⵜⵜⴰⵙⵉⵄ ⵓⵛⴰ ⴰⴷ ⵖⴰⵔⵏⴻⵖ ⵜⵉⵍⵉ ⵍⵖⵉⴵⴻⵜ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ.” ");
INSERT INTO rift_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","ⵓⵛⴰ ⵉⴳⴻⵄⵄⴻⴷ ⵙⵙⴻⵏⵏⵉ ⵖⴰⵔ ⴱⵉ’ⵔ-ⵙⴻⴱⵄⴰ. ");
INSERT INTO rift_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","ⵉⴱⴰⵏ ⴰⵙ-ⴷⴷ ⵙⵉⴷⵉ ⴷⵉ ⴵⵉⵔⴻⵜ ⵏⵏⵉ, ⵉⵏⵏⴰ ⴰⵙ: “ⵏⴻⵛⵛ ⴷ ⴰⵔⴻⴱⴱⵉ ⵏ ⵉⴱⵔⴰⵀⵉⵎ ⴱⴰⴱⴰⵛ! ⵡⴰⵔ ⵜⵜⴻⴳⴳⵯⴻⴷ ⵛⴰ, ⴰⵇⴰ ⵏⴻⵛⵛ ⴰⴽⵉⴷⴻⴽ ⵓ ⵏⴻⵛⵛ ⴰⴷ ⵛⴻⴽ ⴱⴰⵔⴽⴻⵖ, ⴰⴷ ⴽⴻⵜⵜⴰⵔⴻⵖ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵛ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏ ⵓⵎⵙⴻⵅⵅⴰⵔ ⵉⵏⵓ ⵉⴱⵔⴰⵀⵉⵎ.” ");
INSERT INTO rift_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","ⵅⴻⵏⵏⵉ ⵉⴱⵏⴰ ⴷⵉⵏ ⵉⵊⵊ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ⵎⵉⵏ ⵅⴻⴼ ⵉⴳⴳⴰ ⵜⴰⵖⴰⵔⵚⵜ, ⵓⵛⴰ ⵉⵍⴰⵖⴰ ⵉⵙⴻⵎ ⵏ ⵙⵉⴷⵉ. ⵉⵡⵜⴰ ⴷⵉⵏ ⴰⵇⵉⴹⵓⵏ ⵏⵏⴻⵙ ⵓⵛⴰ ⵖⵣⵉⵏ ⴷⵉⵏ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏ ⵉⵙⵃⴰⵇ ⵉⵊⵊ ⵏ ⵡⴰⵏⵓ. ");
INSERT INTO rift_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","ⴰⴱⵉⵎⴰⵍⵉⴽ ⵢⵓⵙⴰ-ⴷⴷ ⵖⴰⵔⴻⵙ ⵣⵉ ⵊⵉⵔⴰⵔ, ⴰⴽ-ⴷ ⴰⵃⵓⵣⵣⴰⵜ, ⴰⵎⴻⴷⴷⵓⴽⴽⴻⵍ ⵏⵏⴻⵙ, ⴷ ⴼⵉⴽⵓⵍ, ⴰⴽⵓⵎⴰⵏⴷⴰⵔ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","ⵉⵏⵏⴰ ⴰⵙⴻⵏ ⵉⵙⵃⴰⵇ: “ⵎⴰⵖⴰⵔ ⵖⴰⵔⵉ ⴷⴷ-ⵜⵓⵙⵉⵎ, ⵡⴰⵅⵅⴰ ⴽⴻⵏⵏⵉⵡ ⵜⵛⴰⵔⵔⵀⴻⵎ ⴰⵢⵉ ⵓⵛⴰ ⵜⴻⵙⵙⵓⴼⴼⵖⴻⵎ ⴰⵢⵉ ⵅⴰⵡⴻⵎ?” ");
INSERT INTO rift_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","ⵏⵉⵜⵏⵉ ⵏⵏⴰⵏ: “ⴰⵇⴰ ⵏⴻⵥⵔⴰ ⴱⴻⵍⵍⵉ ⵙⵉⴷⵉ ⴰⴽⵉⴷⴻⴽ. ⵙ ⵓⵢⴰ ⵏⴻⵏⵏⴰ, ⴰⴷ ⴷⵉⵏ ⵜⵉⵍⵉ ⵍⴻⵅⵅⵓ ⵉⵛⵜ ⵏ ⵜⵊⴰⴵⵉⵜ ⵊⴰⵔⴰⵏⴻⵖ, ⵊⴰⵔⴰⵏⴻⵖ ⴷ ⵛⴻⴽ, ⵓⵛⴰ ⴻⵊⵊ ⴰⵏⴻⵖ ⴰⴷ ⴽⵉⴽ ⵏⴻⴳⴳ ⵉⵊⵊ ⵏ ⵍⵄⴰⵀⴷ, ");
INSERT INTO rift_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ⵃⵉⵎⴰ ⵛⴻⴽ ⵡⴰⵔ ⴷ ⴰⵏⴻⵖ ⵜᵉⵜⵜⴻⴳⴳⴻⴷ ⵍⵖⴰⵔ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵓⵍⴰ ⴷ ⵏⴻⵛⵛⵉⵏ ⵡⴰⵔ ⵛⴻⴽ ⵏⵃⵉⴷⵉ ⵛⴰ ⵓⵛⴰ ⴰⵇⴰ ⵏⴻⵎⵚⵓⵔⵔⴻⴼ ⴰⴽⵉⴷⴻⴽ ⵎⵍⵉⵃ ⵓⵛⴰ ⵏⴻⵙⵙⴻⴽⴽ ⵉ ⵛⴻⴽ ⴷⵉ ⵍⴰⵎⴰⵏ. ⴰⵇⴰ ⵛⴻⴽ ⵍⴻⵅⵅⵓ ⴷ ⴰⵎⵉⵎⵓⵏ ⵏ ⵙⵉⴷⵉ!” ");
INSERT INTO rift_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","ⵅⴻⵏⵏⵉ ⵉⴳⴳⴰ ⴰⵙⴻⵏ ⵉⵛⵜ ⵏ ⵣⵣⴰⵔⴷⴻⵜ ⵓⵛⴰ ⵛⵛⵉⵏ, ⵙⵡⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","ⴽⴽⴰⵔⴻⵏ ⵣⵉⵛ ⵓⵛⴰ ⵊⵊⵓⴵⴻⵏ ⵉⵊⵊⴻⵏ ⵉ ⵡⴻⵏⵏⴻⵖⵏⵉ. ⵅⴰⵙ ⵓⵛⴰ ⵉⵙⵙⵇⴻⴱⴱⴻⴹ ⵉ-ⵜⴻⵏ ⵉⵙⵃⴰⵇ ⵓⵛⴰ ⵔⵓⵃⴻⵏ ⵏⵉⵜⵏⵉ ⵣⵉ ⵖⴰⵔⴻⵙ ⴷⵉ ⵍⴻⵀⵏⴰ. ");
INSERT INTO rift_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","ⴷⴻⴳ ⵡⴰⵙⵙ ⵏⵏⵉ ⴷ ⵉⵊⵊ ⵓⵙⵉⵏ-ⴷⴷ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏ ⵉⵙⵃⴰⵇ, ⵅⴻⴱⴱⴰⵔⴻⵏ ⵜ ⵅ ⵡⴰⵏⵓ ⵉ ⵉⵖⵣⴰⵏ ⵓⵛⴰ ⵏⵏⴰⵏ ⴰⵙ: “ⴷ ⴰⵎⴰⵏ ⵉ ⵏⵓⴼⴰ.” ");
INSERT INTO rift_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","ⵉⵙⴻⵎⵎⴰ ⴰⵏⵓ-ⵢⴰ ⵙⴻⴱⵄⴰ. ⵅ ⵓⵢⴰ ⵉ ⵉⴵⴰ ⵢⵉⵙⴻⵎ ⵏ ⵜⴻⵏⴷⵉⵏⵜ ⵏⵏⵉ ⴱⵉ’ⵔ-ⵙⴻⴱⵄⴰ, ⴰⵍ ⴰⵙⵙ-ⴰ. ");
INSERT INTO rift_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","ⵓⵎⵉ ⵜⵓⵖⴰ ⵖⴰⵔ ⵄⵉⵙⵓ ⴰⵔⴻⴱⵄⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵢⵉⵡⵉ ⵢⵓⴷⵉⵜ, ⵢⴻⴵⵉⵙ ⵏ ⴱⵉⵔⵉ, ⴰⵃⵉⵜⵜⵉ, ⴷ ⵜⴰⵎⵖⴰⵔⵜ, ⵓⵍⴰ ⴷ ⴱⴰⵙⵎⴰⵜ, ⵢⴻⴵⵉⵙ ⵏ ⵉⵍⵓⵏ, ⴰⵃⵉⵜⵜⵉ. ");
INSERT INTO rift_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","ⵜⵓⵖⴰ ⴰⵜⴻⵏⵜ ⴷ ⵜⴰⵔⵣⵓⴳⵉ ⵏ ⵡⵓⵍ ⵉ ⵉⵙⵃⴰⵇ ⴷ ⵔⵉⴼⵇⴰ. ");
INSERT INTO rift_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","ⵍⴰⵎⵉ ⵉⴷⵡⴻⵍ ⵉⵙⵃⴰⵇ ⴷ ⴰⵡⴻⵙⵙⴰⵔ ⵓ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵙ ⵄⴻⵎⵛⴻⵏⵜ ⴰⵍⴰⵎⵉ ⵄⵍⴰⵃⴰⵍ ⵡⴰⵔ ⵉⵜⵜⵡⵉⵍⵉ, ⵉⵍⴰⵖⴰ ⵄⵉⵙⵓ, ⵎⵎⵉⵙ ⴰⵎⴻⵏⵣⵓ, ⵉⵏⵏⴰ ⴰⵙ: “ⵎⵎⵉ!” ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵉⵏⵏⴰ ⴰⵙ: “ⴰⵇⴰ ⴰⵢⵉ ⴷⴰ!” ");
INSERT INTO rift_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","ⵓⵛⴰ ⵉⵏⵏⴰ: “ⴰⵇⴰ ⵏⴻⵛⵛ ⵡⵙⴰⵔⴻⵖ, ⵡⴰⵔ ⵙⵙⵉⵏⴻⵖ ⴰⵙⵙ ⵉ ⴷⵉ ⵖⴰ ⵎⵎⵜⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","ⵍⴻⵅⵅⵓ, ⴽⵙⵉ ⵍⴻⵙⵏⴰⵃ ⵏⵏⴻⵛ ⴷ ⵡⴻⵇⵔⴰⴱ ⵏⵏⴻⵛ ⵏ ⴼⵍⵉⵜⵛⴰⵜ ⴷ ⵍⵇⴻⵡⵙ ⵏⵏⴻⵛ, ⵜⴻⴼⴼⵖⴻⴷ ⵖⴰⵔ ⵍⴻⵅⵍⴰ ⵓⵛⴰ ⴳⵎⴰⵔ ⴰⵢⵉ-ⴷⴷ ⵜⴰⵢⵎⴰⵔⵜ ⵉ ⵎⴰⵛⵛⴰ. ");
INSERT INTO rift_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","ⵙⴻⵡⵊⴻⴷ ⴰⵢⵉ-ⴷⴷ ⵉⵛⵜ ⵏ ⵎⴰⵛⵛⴰ ⵉⵛⵏⴰⵏ ⵉ ⴷ ⴰⵢⵉ ⵖⴰ ⵉⵄⴻⵊⴱⴻⵏ ⵓⵛⴰ ⵜⴻⵡⵛⴻⴷ ⴰⵢⵉ ⵜⵜ-ⵉ-ⴷⴷ, ⴰⴷ ⵜⵜ ⵛⵛⴻⵖ, ⵃⵉⵎⴰ ⴰⴷ ⵛⴻⴽ ⴱⴰⵔⴽⴻⵖ ⵇⴱⴻⵍ ⵎⴰ ⴰⴷ ⵎⵎⵜⴻⵖ.” ");
INSERT INTO rift_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","ⵔⵉⴼⵇⴰ ⵜⵓⵖⴰ ⵜⴻⵙⵍⴰ ⵓⵎⵉ ⵉⵙⵙⵉⵡⴻⵍ ⵉⵙⵃⴰⵇ ⴰⴽ-ⴷ ⵎⵎⵉⵙ ⵄⵉⵙⵓ. ⵓⵛⴰ ⵉⵔⵓⵃ ⵄⵉⵙⵓ ⵖⴰⵔ ⵍⴻⵅⵍⴰ ⵃⵉⵎⴰ ⴰⴷ ⵉⵢⵎⴰⵔ ⵜⵉⵎⴻⵢⵔⴰ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⵜ-ⵉ-ⴷⴷ-ⵢⴰⵡⵉ. ");
INSERT INTO rift_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","ⵅⴻⵏⵏⵉ ⵜⴻⵙⵙⵉⵡⴻⵍ ⵔⵉⴼⵇⴰ ⴰⴽ-ⴷ ⵢⴰⵄⵇⵓⴱ ⵎⵎⵉⵙ, ⵜⴻⵏⵏⴰ ⴰⵙ: “ⵅⵣⴰⵔ, ⵏⴻⵛⵛ ⵙⵍⵉⵖ ⴱⴰⴱⴰⵛ ⵉⵙⵙⴰⵡⴰⵍ ⴰⴽ-ⴷ ⵄⵉⵙⵓ ⵓⵎⴰⵛ, ⵉⵏⵏⴰ ⴰⵙ: ");
INSERT INTO rift_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘ⴰⵡⵉ ⴰⵢⵉ-ⴷⴷ ⵉⵛⵜ ⵏ ⵜⴻⵢⵎⴰⵔⵜ ⵓⵛⴰ ⵙⴻⵡⵊⴻⴷ ⴰⵢⵉ ⵉⵛⵜ ⵏ ⵎⴰⵛⵛⴰ ⵍⴻⵎⵍⵉⵃ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⵜ ⵛⵛⴻⵖ, ⵃⵉⵎⴰ ⵏⴻⵛⵛ ⴰⴷ ⴰⵛ ⴱⴰⵔⴽⴻⵖ ⵇⵉⴱⴰⵍⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⵇⴱⴻⵍ ⵉ ⵖⴰ ⵎⵎⵜⴻⵖ.’ ");
INSERT INTO rift_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","ⵍⴻⵅⵅⵓ, ⵎⵎⵉ, ⵙⴻⵍ-ⴷⴷ ⵖⴰⵔⵉ ⵎⵉⵏ ⵣⵉ ⵛⴻⴽ ⵖⴰ ⵓⵎⵓⵔⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","ⵍⵓⵀ ⵖⴰⵔ ⵜⵃⵉⵎⴰⵔⵜ ⵓⵛⴰ ⴰⵡⵉ ⴰⵢⵉ-ⴷⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵖⴰⵢⴹⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⴻⵏ ⵣⴻⴳ ⵉⵖⴰⵢⴹⴻⵏ. ⵏⴻⵛⵛ ⴰⴷ ⵣⵣⴰⵢⵙⴻⵏ ⵙⵙⵡⴻⵊⴷⴻⵖ ⵉⵛⵜ ⵏ ⵎⴰⵛⵛⴰ ⵉⵛⵏⴰⵏ ⵉ ⴱⴰⴱⴰⵛ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵙ ⵉⵜⵜⴰⵄⵊⵉⴱ ");
INSERT INTO rift_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","ⵓ ⵉⵜⵜⵅⴻⵚⵚⴰ ⵛⴻⴽ ⴰⴷ ⵜ ⵜⴰⵡⵢⴻⴷ ⵉ ⴱⴰⴱⴰⵛ, ⴰⴷ ⵢⴻⵛⵛ, ⵃⵉⵎⴰ ⴰⴷ ⵛⴻⴽ ⵉⴱⴰⵔⴻⴽ ⵇⴱⴻⵍ ⵍⵎⴻⵡⵜ ⵏⵏⴻⵙ.” ");
INSERT INTO rift_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵢⴰⵄⵇⵓⴱ ⵉ ⵔⵉⴼⵇⴰ, ⵢⴻⵎⵎⴰⵙ: “ⵅⵣⴰⵔ, ⵄⵉⵙⵓ ⵓⵎⴰ ⴷ ⴰⵔⵢⴰⵣ ⴱⵓ-ⵛⵄⴰⵔ ⵓ ⵏⴻⵛⵛ ⴷ ⴰⵔⵢⴰⵣ ⴷ ⴰⵍⴻⵇⵇⴰⵖ. ");
INSERT INTO rift_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","ⴱⴰⵍⴰⴽ ⴰⴷ ⴰⵢⵉ ⵉⵃⴰⴷⴰ ⴱⴰⴱⴰ ⵓⵛⴰ ⴰⴷ ⵉⵍⵉⵖ ⴰⵎⴻⵛⵏⴰⵡ ⴰⵖⴻⵛⵛⴰⵛ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵙ. ⵅⴻⵏⵏⵉ ⴰⴷ ⴽⵙⵉⵖ ⵉⵛⵜ ⵏ ⵏⵏⴻⵄⵍⴻⵜ ⵅⴰⴼⵉ, ⵡⴰⵔ ⴽⴻⵙⵙⵉⵖ ⵍⴱⴰⵔⴰⴽⴰ.” ");
INSERT INTO rift_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","ⵢⴻⵎⵎⴰⵙ ⵜⴻⵏⵏⴰ ⴰⵙ: “ⵏⵏⴻⵄⵍⴻⵜ ⵏⵏⴻⵛ ⴰⴷ ⵜⵉⵍⵉ ⵅⴰⴼⵉ, ⴰ ⵎⵎⵉ! ⵟⴰⵄ ⵉ ⵡⴰⵡⴰⵍ ⵉⵏⵓ ⵡⴰⵀⴰ, ⴰⵡⵢⵉ ⵜⴻⵏ-ⴷⴷ ⵖⴰⵔⵉ.” ");
INSERT INTO rift_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","ⵅⴻⵏⵏⵉ ⵏⴻⵜⵜⴰ ⵉⵔⵓⵃ, ⵉⴽⵙⵉ ⵜⴻⵏ ⵓⵛⴰ ⵢⵉⵡⵢⵉ ⵜⴻⵏ ⵉ ⵢⴻⵎⵎⴰⵙ. ⵓⵛⴰ ⵢⴻⵎⵎⴰⵙ ⵜⴻⴳⴳⴰ ⵉⵛⵜ ⵏ ⵎⴰⵛⵛⴰ ⵉⵛⵏⴰⵏ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵙ ⵉⵜⵜⴰⵄⵊⵉⴱ ⵉ ⴱⴰⴱⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","ⵜⴻⴽⵙⵉ ⵔⵉⴼⵇⴰ ⴰⵔⵔⵓⴹ ⵉⴼⴻⵛⵛⵃⴻⵏ ⴰⵟⵟⴰⵙ ⵉ ⵜⵓⵖⴰ ⵖⴰⵔⴻⵙ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵣⴻⴳ ⵡⴰⵔⵔⵓⴹ ⵏ ⵄⵉⵙⵓ, ⵎⵎⵉⵙ ⴰⵎⴻⵏⵣⵓ, ⵓⵛⴰ ⵜⴰⵔⴹ ⵉ-ⵜ ⵢⴰⵄⵇⵓⴱ, ⵎⵎⵉⵙ ⴰⵎⴰⵥⵓⵥ. ");
INSERT INTO rift_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","ⵜⴻⴳⴳⴰ ⴰⵙ ⵉⵍⴻⵎ ⵏ ⵉⵖⴰⵢⴹⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⴻⵏ ⵣⴻⴳ ⵉⵖⴰⵢⴹⴻⵏ ⵅ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵏⴻⵙ ⵓ ⵅ ⵢⵉⵔⵉ ⵏⵏⴻⵙ ⴰⵍⴻⵇⵇⴰⵖ. ");
INSERT INTO rift_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","ⵜⴻⵡⵛⴰ ⵎⴰⵛⵛⴰ-ⵢⴰ ⵉⵛⵏⴰⵏ ⴰⴽ-ⴷ ⵡⴻⵖⵔⵓⵎ ⵏⵏⵉ ⵜⴻⵏⴳⴳⵯⴰ ⴷⴻⴳ ⵉⴼⴰⵙⵙⴻⵏ ⵏ ⵎⵎⵉⵙ ⵢⴰⵄⵇⵓⴱ. ");
INSERT INTO rift_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","ⵏⴻⵜⵜⴰ ⵢⵓⵙⴰ-ⴷⴷ ⵖⴰⵔ ⴱⴰⴱⴰⵙ, ⵉⵏⵏⴰ: “ⴰ ⴱⴰⴱⴰ!” ⵏⴻⵜⵜⴰ ⵉⵏⵏⴰ: “ⴰⵇⴰ ⴰⵢⵉ ⴷⴰ! ⵎⵉⵏ ⵜⴻⵄⵏⵉⴷ ⵛⴻⴽ, ⴰ ⵎⵎⵉ?” ");
INSERT INTO rift_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","ⵉⵏⵏⴰ ⵢⴰⵄⵇⵓⴱ ⵉ ⴱⴰⴱⴰⵙ: “ⵏⴻⵛⵛ ⴷ ⵄⵉⵙⵓ, ⴰⵎⴻⵏⵣⵓ ⵏⵏⴻⵛ. ⴳⴳⵉⵖ ⵎⵉⵏ ⴷ ⴰⵢⵉ ⵜⴻⵏⵏⵉⴷ. ⴽⴽⴰⵔ ⵍⴻⵅⵅⵓ, ⵇⵇⵉⵎ, ⴻⵛⵛ ⵣⵉ ⵜⵎⴻⵢⵔⴰ ⵉⵏⵓ, ⵃⵉⵎⴰ ⴰⴷ ⴰⵢⵉ ⵉⴱⴰⵔⴻⴽ ⵍⴻⵄⵎⴰⵔ ⵏⵏⴻⵛ.” ");
INSERT INTO rift_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵉⵙⵃⴰⵇ ⵉ ⵎⵎⵉⵙ: “ⵎⴰⵎⵎⴻⵛ ⵜⴻⴳⴳⵉⴷ ⵜⵓⴼⵉⴷ ⵜⵜ ⴷⴻⵖⵢⴰ, ⴰ ⵎⵎⵉ?” ⵉⵏⵏⴰ: “ⵎⴰⵖⴰⵔ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵛ, ⵉⴳⴳⴰ ⵉ-ⵜⵜ ⴷⴻⴳ ⵡⴻⴱⵔⵉⴷ ⵉⵏⵓ.” ");
INSERT INTO rift_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","ⵉⵙⵃⴰⵇ ⵉⵏⵏⴰ ⵉ ⵢⴰⵄⵇⵓⴱ: “ⵇⴰⵔⵔⴻⴱ-ⴷⴷ ⵍⴻⵅⵅⵓ, ⵃⵉⵎⴰ ⴰⴷ ⵛⴻⴽ ⵃⴰⴷⵉⵖ, ⴰ ⵎⵎⵉ, ⵎⴰ ⵛⴻⴽ ⴷ ⵎⵎⵉ ⵄⵉⵙⵓ ⵏⵉⵖ ⵍⵍⴰ.” ");
INSERT INTO rift_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","ⵍⴰⵎⵉ ⴷⴷ-ⵉⵇⴰⵔⵔⴻⴱ ⵢⴰⵄⵇⵓⴱ ⵖⴰⵔ ⴱⴰⴱⴰⵙ ⵉⵙⵃⴰⵇ, ⵉⵃⴰⴷⴰ ⵜ ⵓⵛⴰ ⵉⵏⵏⴰ: “ⵜⵎⵉⵊⵊⴰ ⴷ ⵜⵎⵉⵊⵊⴰ ⵏ ⵢⴰⵄⵇⵓⴱ, ⵎⴰⵛⴰ ⵉⴼⴰⵙⵙⴻⵏ ⴷ ⵉⴼⴰⵙⵙⴻⵏ ⵏ ⵄⵉⵙⵓ.” ");
INSERT INTO rift_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","ⵏⴻⵜⵜⴰ ⵡⴰⵔ ⵜ ⵉⵄⵇⵉⵍ, ⵎⵉⵏⵣⵉ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵏⴻⵙ ⵜⵓⵖⴰ ⵛⴻⵄⵄⴰⵔⴻⵏ ⴰⵎⴻⵛⵏⴰⵡ ⵉⴼⴰⵙⵙⴻⵏ ⵏ ⵄⵉⵙⵓ ⵓⵛⴰ ⵉⴱⴰⵔⴽ ⵉ-ⵜ. ");
INSERT INTO rift_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","ⵉⵏⵏⴰ: “ⵎⴰ ⴷ ⵛⴻⴽ ⴷ ⵎⵎⵉ ⵄⵉⵙⵓ?” ⵏⴻⵜⵜⴰ ⵉⵏⵏⴰ: “ⴷ ⵏⴻⵛⵛ!” ");
INSERT INTO rift_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ: “ⵙⵇⴰⵔⵔⴻⴱ ⴰⵢⵉ ⵜⵜ-ⵉ-ⴷⴷ ⵣⵣⴰⵜⵉ, ⵃⵉⵎⴰ ⴰⴷ ⵛⵛⴻⵖ ⵣⵉ ⵜⵎⴻⵢⵔⴰ ⵏ ⵎⵎⵉ, ⵃⵉⵎⴰ ⵏⴻⵛⵛ ⴰⴷ ⵛⴻⴽ ⴱⴰⵔⴽⴻⵖ.” ⵉⵙⵙⴰⵔⵙ ⵉ-ⵜⵜ-ⵉ-ⴷⴷ ⵣⵣⴰⵜⴻⵙ ⵓⵛⴰ ⵉⵛⵛⴰ. ⵢⵉⵡⵉ ⴰⵙ-ⴷⴷ ⵄⴰⵡⴻⴷ ⴱⵉⵏⵓ ⵓⵛⴰ ⵉⵙⵡⴰ. ");
INSERT INTO rift_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","ⵉⵏⵏⴰ ⴰⵙ ⴱⴰⴱⴰⵙ ⵉⵙⵃⴰⵇ: “ⵇⴰⵔⵔⴻⴱ-ⴷⴷ ⵖⴰⵔⵉ ⵍⴻⵅⵅⵓ, ⵙⵓⴷⴻⵎ ⴰⵢⵉ, ⴰ ⵎⵎⵉ!” ");
INSERT INTO rift_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","ⵓⵛⴰ ⵉⵇⴰⵔⵔⴻⴱ-ⴷⴷ ⵖⴰⵔⴻⵙ, ⵉⵙⵙⵓⴷⴻⵎ ⵉ-ⵜ. ⵉⵛⴻⵎⵎ ⵉⵙⵃⴰⵇ ⴰⵔⵔⵉⵃⴻⵜ ⵏ ⵡⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⴱⴰⵔⴽ ⵉ-ⵜ, ⵉⵏⵏⴰ: “ⵅⵣⴰⵔ, ⵍⴻⴼⵡⴰⵃⴻⵜ ⵏ ⵎⵎⵉ ⴰⵎ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵏ ⵢⴻⵢⵢⴰⵔ ⵉ ⵉⴱⴰⵔⴻⴽ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","ⴰⴷ ⴰⵛ ⵉⵡⵛ ⴰⵔⴻⴱⴱⵉ ⵣⵉ ⵏⵏⴷⴰ ⵏ ⵓⵊⴻⵏⵏⴰ ⵓ ⵣⵉ ⵍⴻⵢⴷⴰⵎ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵓⵍⴰ ⴷ ⵡⴰⵟⵟⴰⵙ ⵏ ⵉⵎⴻⵏⴷⵉ ⴷ ⴱⵉⵏⵓ ⵏ ⵊⴷⵉⴷ. ");
INSERT INTO rift_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","ⴰⴷ ⴰⵛ ⵅⴻⴷⵎⴻⵏ ⵍⴻⴳⵏⵓⵙ ⵓⵛⴰ ⵛⵛⵓⵄⵓⴱ ⴰⴷ ⴰⵛ ⴱⴻⵏⴷⵇⴻⵏ. ⵃⴽⴻⵎ ⵅ ⴰⵢⵜⵎⴰⵛ ⵓ ⴻⵊⵊ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵢⴻⵎⵎⴰⵛ ⴰⴷ ⴰⵛ ⴱⴻⵏⴷⵇⴻⵏ! ⵉⵏⵏⵉ ⵛⴻⴽ ⵉ ⵖⴰ ⵉⵏⴻⵄⵍⴻⵏ, ⴰⴷ ⵜⵜⵡⴰⵏⴻⵄⵍⴻⵏ, ⵓ ⵉⵏⵏⵉ ⵛⴻⴽ ⵖⴰ ⵉⴱⴰⵔⴽⴻⵏ, ⴰⴷ ⵜⵜⵡⴰⴱⴰⵔⴽⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⵉⴽⴻⵎⵎⴻⵍ ⵉⵙⵃⴰⵇ ⵍⴱⴰⵔⴰⴽⴰ ⵉ ⵢⴰⵄⵇⵓⴱ ⵓⵛⴰ ⴰⵎ ⴷⴷ-ⵉⴼⴼⴻⵖ ⵢⴰⵄⵇⵓⴱ ⵄⴰⴷ ⵅ ⴱⴰⴱⴰⵙ ⵉⵙⵃⴰⵇ, ⵉⵄⵇⴻⴱ-ⴷⴷ ⵄⵉⵙⵓ, ⵓⵎⴰⵙ, ⵣⵉ ⵜⴻⵢⵎⴰⵔⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","ⵉⵙⵙⴻⵡⵊⴻⴷ ⵅⴻⵏⵏⵉ ⵉⵛⵜ ⵏ ⵎⴰⵛⵛⴰ ⵉⵛⵏⴰⵏ ⵓⵛⴰ ⵉⴽⵙⵉ ⵜⵜ ⵖⴰⵔ ⴱⴰⴱⴰⵙ, ⵉⵏⵏⴰ ⴰⵙ: “ⵜⵜⵣⴰⵡⴳⴻⵖ, ⴱⴰⴱⴰ, ⴽⴽⴰⵔ ⵜⴻⵛⵛⴻⴷ ⵣⵉ ⵜⴻⵢⵎⴰⵔⵜ ⵏ ⵎⵎⵉⵛ, ⵃⵉⵎⴰ ⵛⴻⴽ ⴰⴷ ⴰⵢⵉ ⵜⴱⴰⵔⴽⴻⴷ.” ");
INSERT INTO rift_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","ⵉⵏⵏⴰ ⴰⵙ ⵉⵙⵃⴰⵇ, ⴱⴰⴱⴰⵙ: “ⵎⵉⵏ ⵜⴻⵄⵏⵉⴷ ⵛⴻⴽ?” ⵏⴻⵜⵜⴰ ⵉⵏⵏⴰ: “ⵏⴻⵛⵛ ⴷ ⵎⵎⵉⵛ, ⴰⵎⴻⵏⵣⵓ ⵏⵏⴻⵛ, ⵄⵉⵙⵓ.” ");
INSERT INTO rift_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","ⵓⵛⴰ ⵉⵏⵏⴻⵅⵍⴻⵄ ⵉⵙⵃⴰⵇ, ⵉⵏⵏⴰ: “ⵎⵉⵏ ⵉⵄⵏⴰ ⵡⴰⵏⵉⵜⴰ ⵉ ⴷⴷ-ⵢⵓⵙⵉⵏ ⴷⴰ, ⵉⵟⵟⴻⴼ ⵜⴰⵢⵎⴰⵔⵜ ⵓⵛⴰ ⵢⵉⵡⵉ ⴰⵢⵉ ⵜⵜ-ⵉ-ⴷⴷ? ⵛⵛⵉⵖ ⵣⵉ ⵎⴰⵔⵔⴰ ⵎⴰⵏ ⴰⵢⴰ ⵇⴱⴻⵍ ⴷⴷ-ⵜⵓⵙⵉⴷ ⵓⵛⴰ ⵏⴻⵛⵛ ⴱⴰⵔⴽⴻⵖ ⵜ ⵓ ⴰⴷ ⵉⵜⵜⵡⴰⴱⴰⵔⴻⴽ ⵄⴰⵡⴻⴷ.” ");
INSERT INTO rift_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","ⵓⵎⵉ ⵉⵙⵍⴰ ⵄⵉⵙⵓ ⴰⵡⴰⵍⴻⵏ ⵏ ⴱⴰⴱⴰⵙ, ⵉⵙⵖⵓⵢ ⵙ ⵢⵉⵊⵊ ⵏ ⵍⴻⵄⵢⴰⴷ ⵉⵊⵀⴻⴷ ⵢⴰⵔⵣⴻⴳ, ⵉⵏⵏⴰ ⵉ ⴱⴰⴱⴰⵙ: “ⴱⴰⵔⴻⴽ ⴰⵢⵉ ⵓⵍⴰ ⴷ ⵏⴻⵛⵛ, ⴰ ⴱⴰⴱⴰ!” ");
INSERT INTO rift_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","ⵉⵏⵏⴰ: “ⵢⵓⵙⴰ-ⴷⴷ ⵓⵎⴰⵛ ⵙ ⵜⴻⵃⵔⴰⵢⵎⴻⵛⵜ, ⵉⴽⵙⵉ ⵍⴱⴰⵔⴰⴽⴰ ⵏⵏⴻⵛ.” ");
INSERT INTO rift_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ: “ⵎⴰ ⵡⴰⵔ ⵉⴵⵉ ⵉⵙⴻⵎ ⵏⵏⴻⵙ ⵙ ⵍⵃⴻⵇⵇ ⵢⴰⵄⵇⵓⴱ? ⴰⵇⴰ ⵉⵛⵎⴻⵜ ⴰⵢⵉ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵡⴰⵍⴰⵡⵉⵏ. ⵉⴽⵙⵉ ⵍⵃⴻⵇⵇ ⵏ ⵓⵎⴻⵏⵣⵓ ⵉⵏⵓ ⵓⵛⴰ ⴰⵇⴰ ⵍⴻⵅⵅⵓ ⵉⴽⵙⵉ ⵄⴰⵡⴻⴷ ⵍⴱⴰⵔⴰⴽⴰ ⵉⵏⵓ.” ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ: “ⵎⴰ ⵡⴰⵔ ⵖⴰⵔⴻⴽ ⵜⴻⵇⵇⵉⵎ ⵛⴰ ⵏ ⵍⴱⴰⵔⴰⴽⴰ ⵉ ⵏⴻⵛⵛ?” ");
INSERT INTO rift_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","ⵅⴻⵏⵏⵉ ⵢⴰⵔⵔⴰ-ⴷⴷ ⵉⵙⵃⴰⵇ, ⵉⵏⵏⴰ ⵉ ⵄⵉⵙⵓ: “ⵅⵣⴰⵔ, ⵏⴻⵛⵛ ⴳⴳⵉⵖ ⵜ ⴷ ⵍⵃⴰⴽⴻⵎ ⵅⴰⴽ ⵓⵛⴰ ⵡⵛⵉⵖ ⴰⵙ ⴰⵢⵜⵎⴰⵙ ⴷ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ, ⵓⵍⴰ ⵙ ⵉⵎⴻⵏⴷⵉ ⴷ ⴱⵉⵏⵓ ⵏ ⵊⴷⵉⴷ ⵄⴻⵡⵡⵍⴻⵖ ⵜ. ⵎⵉⵏ ⴷⵉⵏ ⵄⴰⴷ, ⴰⴷ ⴰⵛ ⵡⵛⴻⵖ ⵍⴻⵅⵅⵓ, ⴰ ⵎⵎⵉ?” ");
INSERT INTO rift_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","ⵉⵏⵏⴰ ⵄⵉⵙⵓ ⵉ ⴱⴰⴱⴰⵙ: “ⵎⴰ ⵖⴰⵔⴻⴽ ⵎⵖⵉⵔ ⵍⴱⴰⵔⴰⴽⴰ-ⵢⴰ ⵡⴰⵀⴰ, ⴰ ⴱⴰⴱⴰ? ⴱⴰⵔⴻⴽ ⴰⵢⵉ ⵄⴰⵡⴻⴷ, ⵓⵍⴰ ⴷ ⵏⴻⵛⵛ, ⴰ ⴱⴰⴱⴰ!” ⵓⵛⴰ ⵉⵙⵙⴳⴻⵄⵄⴻⴷ ⵄⵉⵙⵓ ⵜⵎⵉⵊⵊⴰ ⵏⵏⴻⵙ, ⵉⵙⵖⵓⵢ. ");
INSERT INTO rift_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","ⵅⴻⵏⵏⵉ ⵢⴰⵔⵔⴰ-ⴷⴷ ⵉⵙⵃⴰⵇ ⵅ ⴱⴰⴱⴰⵙ, ⵉⵏⵏⴰ ⴰⵙ: “ⵅⵣⴰⵔ, ⴰⴷ ⵜⵉⵍⵉ ⵜⵣⴻⴷⴷⵉⵖⵜ ⵏⵏⴻⵛ ⵉⴳⴳⵯⴻⵊⵊⴻⵏ ⵅ ⵍⴻⵢⴷⴰⵎ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵓ ⵅ ⵏⵏⴷⴰ ⵏ ⵓⵊⴻⵏⵏⴰ ⵙⴻⵏⵏⴻⵊ. ");
INSERT INTO rift_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","ⵙ ⵙⵙⵉⴼ ⵏⵏⴻⵛ ⵉ ⵖⴰ ⵜⴻⵇⵇⵉⵎⴻⴷ ⵜⴻⴷⴷⴰⵔⴻⴷ ⵓ ⴰⴷ ⵜⵅⴻⴷⵎⴻⴷ ⵉ ⵓⵎⴰⵛ. ⵎⴰⵛⴰ ⵅⵎⵉ ⵖⴰ ⵜⴻⵇⵇⵉⵎⴻⴷ ⴰⴷ ⵜⴻⵏⵀⴻⵣⵣⴻⴷ, ⴰⴷ ⵉⵎⵙⴰⵔ ⴰⴷ ⵜⴰⵡⴹⴻⴷ ⴰⴷ ⵜⴻⴽⴽⵙⴻⴷ ⵣⴰⵢⵍⵓ ⵏⵏⴻⵙ ⵅ ⵢⵉⵔⵉ ⵏⵏⴻⵛ.” ");
INSERT INTO rift_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","ⵓⵛⴰ ⵉⵛⴰⵔⵀ ⵄⵉⵙⵓ ⵢⴰⵄⵇⵓⴱ ⴷⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⵍⴱⴰⵔⴰⴽⴰ ⵉ ⵣⵉ ⵜ ⵉⴱⴰⵔⴻⴽ ⴱⴰⴱⴰⵙ, ⵓⵛⴰ ⵉⵏⵏⴰ ⵄⵉⵙⵓ ⴷⴻⴳ ⵡⵓⵍ ⵏⵏⴻⵙ: “ⴰⴷ ⴰⵡⴹⴻⵏ ⵡⵓⵙⵙⴰⵏ ⵏ ⵓⵄⴻⵣⵣⵉ ⵏ ⴱⴰⴱⴰ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵏⵖⴻⵖ ⵓⵎⴰ ⵢⴰⵄⵇⵓⴱ.” ");
INSERT INTO rift_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","ⵓⵎⵉ ⵏⵏⴰⵏ ⵉ ⵔⵉⴼⵇⴰ ⴰⵡⴰⵍⴻⵏ ⵏ ⵄⵉⵙⵓ, ⵎⵎⵉⵙ ⴰⵎⴻⵏⵣⵓ, ⵜᵉⵙⵙⴻⴽⴽ ⵉⵊⵊⴻⵏ ⴰⴷ ⵉⵍⴰⵖⴰ ⵉ ⵢⴰⵄⵇⵓⴱ, ⵎⵎⵉⵙ ⴰⵎⴰⵥⵓⵥ, ⵜⴻⵏⵏⴰ ⴰⵙ: “ⵅⵣⴰⵔ, ⵄⵉⵙⵓ ⵓⵎⴰⵛ ⵢⴰⵔⴻⵣⵣⵓ ⵎⴰⵎⵎⴻⵛ ⵣⵣⴰⵢⴻⴽ ⵉ ⵖⴰ ⵉⵅⵍⴻⴼ, ⵏⴻⵜⵜⴰ ⵉⵅⵙ ⴰⴷ ⵛⴻⴽ ⵉⵏⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","ⵍⴻⵅⵅⵓ, ⴰ ⵎⵎⵉ, ⵟⴰⵄ ⵉ ⵡⴰⵡⴰⵍ ⵉⵏⵓ. ⴽⴽⴰⵔ ⵓⵛⴰ ⵜⴰⵔⴻⵡⵍⴻⴷ ⵖⴰⵔ ⵃⴰⵔⴰⵏ ⵖⴰⵔ ⵓⵎⴰ ⵍⴰⴱⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","ⵣⴷⴻⵖ ⴰⴽⵉⴷⴻⵙ ⵛⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⴰⵍ ⵖⴰ ⵢⴰⵔⵙⴰ ⵡⴻⵙⵄⴰⵔ ⵏ ⵓⵎⴰⵛ. ");
INSERT INTO rift_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","ⵅⵎⵉ ⵖⴰ ⵉⵅⵙⵉ ⵓⵅⴻⵢⵢⴻⵇ ⵏ ⵓⵎⴰⵛ ⵓⵛⴰ ⴰⴷ ⵉⵜⵜⵓ ⵎⵉⵏ ⴷ ⴰⵙ ⵜⴻⴳⴳⵉⴷ, ⵏⴻⵛⵛ ⴰⴷ ⵙⵙⴻⴽⴽⴻⵖ ⵉⵊⵊⴻⵏ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵛⴻⴽ ⴷⴷ-ⵢⴰⵡⵉ ⵙⵙⴻⵏⵏⵉ. ⵎⴰⵢⴻⵎⵎⵉ ⵉ ⵣⵣⴰⵢⵡⴻⵎ ⵖⴰ ⵜⵜⵡⴰⵃⴰⵔⵔⵎⴻⵖ ⵙ ⵜⵏⴰⵢⴻⵏ ⵉⴷⵡⴻⵎ ⴷⴻⴳ ⵉⵊⵊ ⵏ ⵡⴰⵙⵙ?” ");
INSERT INTO rift_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","ⵜⴻⵏⵏⴰ ⵔⵉⴼⵇⴰ ⵉ ⵉⵙⵃⴰⵇ: “ⵛⴰⵔⵔⵀⴻⵖ ⵜⵓⴷⴰⵔⵜ ⵉⵏⵓ ⴷⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⵢⴻⵙⵙⵉⵙ ⵏ ⵃⵉⵜ. ⵎⴰⵍⴰ ⵢⴰⵄⵇⵓⴱ ⵢⵉⵡⵉ ⵜⴰⵎⵖⴰⵔⵜ ⵣⵉ ⵜⴻⴱⵍⵉⵖⵉⵏ ⵏ ⵃⵉⵜ, ⴰⵎ ⵜⵏⴰⵢⴻⵏ-ⴰ, ⵣⵉ ⵜⵃⴻⵏⵊⵉⵔⵉⵏ ⵏ ⵜⴻⵎⵎⵓⵔⵜ-ⴰ, ⵎⴰⵏ ⵍⵇⵉⵎⴰ ⵉ ⵖⴰ ⵢⵉⵍⵉⵏ ⵖⴰⵔ ⵜⵓⴷⴰⵔⵜ ⵉⵏⵓ?” ");
INSERT INTO rift_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","ⵉⵍⴰⵖⴰ ⵉⵙⵃⴰⵇ ⵉ ⵢⴰⵄⵇⵓⴱ, ⵉⴱⴰⵔⴻⴽ ⵉ-ⵜ ⵓⵛⴰ ⵉⵙⵙⴻⴽⴽ ⵉ-ⵜ, ⵉⵏⵏⴰ ⴰⵙ: “ⵡⴰⵔ ⵜⵜⴰⵡⵉ ⵜⴰⵎⵖⴰⵔⵜ ⵣⵉ ⵢⴻⵙⵙⵉⵙ ⵏ ⴽⴻⵏⵄⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","ⴽⴽⴰⵔ, ⵔⵓⵃ ⵖⴰⵔ ⴼⴰⴷⴰⵏ-ⴰⵔⴰⵎ, ⵖⴰⵔ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⴱⵉⵜⵓⵡⵉⵍ, ⴱⴰⴱⴰⵙ ⵏ ⵢⴻⵎⵎⴰⵛ, ⵓⵛⴰ ⴰⵡⵉ-ⴷⴷ ⵙⵙⴻⵏⵏⵉ ⵜⴰⵎⵖⴰⵔⵜ ⵉ ⵛⴻⴽ ⵣⴻⴳ ⵢⴻⵙⵙⵉⵙ ⵏ ⵍⴰⴱⴰⵏ, ⵓⵎⴰⵙ ⵏ ⵢⴻⵎⵎⴰⵛ. ");
INSERT INTO rift_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","ⴰⵔⴻⴱⴱⵉ, ⴰⵎⵣⴻⵎⵎⴰⵔ ⵅ ⴽⵓⵍⵛⵉ, ⴰⴷ ⵛⴻⴽ ⵉⴱⴰⵔⴻⴽ ⵓ ⴰⴷ ⴰⵛ ⵉⵡⵛ ⵍⵖⵉⴵⴻⵜ ⵓⵛⴰ ⴰⴷ ⵛⴻⴽ ⵉⴽⴻⵜⵜⴰⵔ ⴰⵍ ⵖⴰ ⵜⴷⴻⵡⵍⴻⴷ ⴷ ⵉⵊⵊ ⵏ ⵡⴻⴳⵔⴰⵡ ⵏ ⵍⴻⴳⵏⵓⵙ. ");
INSERT INTO rift_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","ⵉⵍⵉ ⵏⴻⵜⵜⴰ ⴰⴷ ⴰⵛ ⵉⵡⵛ ⵍⴱⴰⵔⴰⴽⴰ ⵏ ⵉⴱⵔⴰⵀⵉⵎ, ⵉ ⵛⴻⴽ ⵓ ⵉ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵛ ⴰⴽⵉⴷⴻⴽ, ⵃⵉⵎⴰ ⴰⴷ ⵜⵡⴰⵔⵜⴻⴷ ⵜⴰⵎⵎⵓⵔⵜ ⵏⵏⵉ ⴷⵉ ⵜⵣⴻⴷⴷⵖⴻⴷ ⴰⵎ ⵓⴱⴰⵔⵔⴰⵏⵉ, ⵜⴻⵏⵏⵉ ⵉⵡⵛⴰ ⴰⵔⴻⴱⴱⵉ ⵉ ⵉⴱⵔⴰⵀⵉⵎ.” ");
INSERT INTO rift_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","ⵅⴻⵏⵏⵉ ⵉⵙⵙⴻⴽⴽ ⵉⵙⵃⴰⵇ ⵢⴰⵄⵇⵓⴱ. ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵉⵔⵓⵃ ⵖⴰⵔ ⴼⴰⴷⴷⴰⵏ-ⴰⵔⴰⵎ, ⵖⴰⵔ ⵍⴰⴱⴰⵏ, ⵎⵎⵉⵙ ⵏ ⴱⵉⵜⵓⵡⵉⵍ, ⴰⵔⴰⵎⵉⵢⵓ, ⵓⵎⴰⵙ ⵏ ⵔⵉⴼⵇⴰ, ⵢⴻⵎⵎⴰⵙ ⵏ ⵢⴰⵄⵇⵓⴱ ⴷ ⵄⵉⵙⵓ. ");
INSERT INTO rift_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","ⵓⵎⵉ ⵉⵥⵔⴰ ⵄⵉⵙⵓ ⴱⴻⵍⵍⵉ ⵉⵙⵃⴰⵇ ⵉⴱⴰⵔⴻⴽ ⵢⴰⵄⵇⵓⴱ ⵓⵛⴰ ⵉⵙⵙⴻⴽⴽ ⵉ-ⵜ-ⵉ-ⴷⴷ ⵖⴰⵔ ⴼⴰⴷⴷⴰⵏ-ⴰⵔⴰⵎ ⵃⵉⵎⴰ ⴰⴷ ⵢⴰⵡⵉ ⵉ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵜⴰⵎⵖⴰⵔⵜ ⵙⵙⴻⵏⵏⵉ, ⵓ ⵍⴰⵎⵉ ⵜ ⵉⴱⴰⵔⴻⴽ, ⵢⵓⵎⵓⵔ ⵉ-ⵜ, ⵉⵏⵏⴰ ⴰⵙ: “ⵡⴰⵔ ⴽⴻⵙⵙⵉ ⵜⴰⵎⵖⴰⵔⵜ ⵣⴻⴳ ⵢⴻⵙⵙⵉⵙ ⵏ ⴽⴻⵏⵄⴰⵏ!”, ");
INSERT INTO rift_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","ⵓⵛⴰ ⵉⵥⵔⴰ ⵄⴰⵡⴻⴷ ⴱⴻⵍⵍⵉ ⵢⴰⵄⵇⵓⴱ ⵉⵟⴰⵄ ⴱⴰⴱⴰⵙ ⴷ ⵢⴻⵎⵎⴰⵙ, ⵉⵔⵓⵃ ⵖⴰⵔ ⴼⴰⴷⴷⴰⵏ-ⴰⵔⴰⵎ, ");
INSERT INTO rift_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","ⵅⴻⵏⵏⵉ ⵉⵜⵡⴰⵍⴰ ⵄⵉⵙⵓ ⴱⴻⵍⵍⵉ ⵢⴻⵙⵙⵉⵙ ⵏ ⴽⴻⵏⵄⴰⵏ ⴷ ⵜⵉⵄⴻⴼⴼⴰⵏⵉⵏ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⴱⴰⴱⴰⵙ ⵉⵙⵃⴰⵇ. ");
INSERT INTO rift_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","ⵅⴻⵏⵏⵉ ⵉⵔⵓⵃ ⵄⵉⵙⵓ ⵖⴰⵔ ⵉⵙⵎⴰⵄⵉⵍ ⵓⵛⴰ ⵢⵉⵡⵉ ⵎⴰⵃⴰⵍⴰⵜ ⴷ ⵜⴰⵎⵖⴰⵔⵜ ⵉ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵙ, ⵢⴰⵔⵏⵉ ⵜⵜ-ⵉ-ⴷⴷ ⵖⴰⵔ ⵜⴻⵎⵖⴰⵔⵉⵏ ⵏⵏⴻⵖⵏⵉ. ⵏⴻⵜⵜⴰⵜ ⵜⵓⵖⴰ-ⵜⵜ ⴷ ⵢⴻⴵⵉⵙ ⵏ ⵉⵙⵎⴰⵄⵉⵍ, ⵎⵎⵉⵙ ⵏ ⵉⴱⵔⴰⵀⵉⵎ, ⵓⵍⵜⵎⴰⵙ ⵏ ⵏⴰⴱⴰⵢⵓⵜ. ");
INSERT INTO rift_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","ⵓⵛⴰ ⵉⴼⴼⴻⵖ ⵢⴰⵄⵇⵓⴱ ⵣⵉ ⴱⵉ’ⵔ-ⵙⴻⴱⵄⴰ, ⵉⵔⵓⵃ ⵖⴰⵔ ⵃⴰⵔⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","ⵢⵉⵡⴻⴹ ⵖⴰⵔ ⵉⵊⵊ ⵏ ⵡⴻⵎⵛⴰⵏ ⵎⴰⵏⵉ ⵢⴻⵏⵙⴰ, ⵎⵉⵏⵣⵉ ⵜⵓⵖⴰ ⵜⴰⴼⵓⵛⵜ ⵜⴻⵖⵔⵉ. ⵉⴽⵙⵉ ⵣⴻⴳ ⵢⴻⵥⵔⴰ ⵏ ⵡⴻⵎⵛⴰⵏ ⵏⵏⵉ, ⵉⵙⵙⴰⵔⵙ ⵉ-ⵜⴻⵏ ⵙⴰⴷⵓ ⵓⵣⴻⴵⵉⴼ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⵡⴹⴰ ⵉⵟⵟⴻⵚ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","ⵢⵓⵔⵊⴰ, ⴰⵇⴰ ⵉⵊⵊ ⵏ ⴷⴷⵔⵓⵊ ⵉⴱⴻⴷⴷ ⵅ ⵜⴻⵎⵎⵓⵔⵜ ⵓⵛⴰ ⵉⵜⵜⵃⴰⴷⴰ ⵉⵅⴻⴼ ⵏ ⴷⴷⵔⵓⵊ ⴰⵊⴻⵏⵏⴰ, ⵓ ⵅⵣⴰⵔ, ⵍⵎⴰⵍⴰⴽⴰⵜ ⵏ ⴰⵔⴻⴱⴱⵉ ⵜⵜⴰⵍⵢⴻⵏⵜ ⵀⴻⴽⴽⵡⴰⵏⵜ ⵣⵣⴰⵢⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","ⵓ ⵅⵣⴰⵔ, ⵙⵉⴷⵉ ⵉⴱⴻⴷⴷ ⵅⴰⵙ, ⵉⵏⵏⴰ: “ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏ ⴱⴰⴱⴰⵛ ⵉⴱⵔⴰⵀⵉⵎ, ⴷ ⴰⵔⴻⴱⴱⵉ ⵏ ⵉⵙⵃⴰⵇ. ⵜⴰⵎⵎⵓⵔⵜ ⵉ ⵅⴻⴼ ⵜᵉⵟⵟⵚⴻⴷ ⴰⴷ ⴰⵛ ⵜⵜ ⵡⵛⴻⵖ ⵉ ⵛⴻⴽ ⵓ ⵉ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","ⴰⴷ ⵜⵉⵍⵉ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵛ ⴰⵎ ⵓⵛⴰⵍ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵓⵛⴰ ⴰⴷ ⵜⵉⵔⵉⵡⴻⴷ ⵖⴰⵔ ⵍⵖⴰⵔⴱ ⴷ ⵛⵛⴰⵔⵇ, ⵖⴰⵔ ⵛⵛⴰⵎⴰⵍ ⴷ ⵍⵊⴰⵏⵓⴱ. ⴷⴰⵢⴻⴽ ⵓ ⴷⵉ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵛ ⴰⴷ ⵜⵜⵡⴰⴱⴰⵔⴽⴻⵏⵜ ⵎⴰⵔⵔⴰ ⵍⴰⴵⴰⵜ ⵏ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","ⴰⵇⴰ ⴰⵢⵉ ⵏⴻⵛⵛ ⴰⴽⵉⴷⴻⴽ ⵓ ⵏⴻⵛⵛ ⴰⴷ ⵛⴻⴽ ⵃⴹⵉⵖ ⵇⴰⵄ ⵎⴰⵏⵉ ⵉ ⵖⴰ ⵜⵔⴰⵃⴻⴷ, ⴰⴷ ⵛⴻⴽ ⴰⵔⵔⴻⵖ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ-ⴰ, ⵎⵉⵏⵣⵉ ⵏⴻⵛⵛ ⵡⴰⵔ ⵛⴻⴽ ⵜⵜⴻⵊⵊⵉⵖ ⴰⵍ ⵖⴰ ⴽⴻⵎⵎⵍⴻⵖ ⵎⵉⵏ ⴷ ⴰⵛ ⵏⵏⵉⵖ.” ");
INSERT INTO rift_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","ⵍⴰⵎⵉ ⴷⴷ-ⵉⴼⴰⵇ ⵢⴰⵄⵇⵓⴱ ⵣⴻⴳ ⵢⵉⴹⴻⵚ ⵏⵏⴻⵙ, ⵉⵏⵏⴰ: “ⵙ ⵜⵉⴷⴻⵜⵜ, ⵙⵉⴷⵉ ⴰⵇⴰ-ⵜ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ-ⴰ ⵓ ⵏⴻⵛⵛ ⵡⴰⵔ ⵙⵙⵉⵏⴻⵖ!” ");
INSERT INTO rift_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","ⵜⵓⵖⴰ ⵉⴳⴳⵯⴻⴷ ⴰⵟⵟⴰⵙ, ⵉⵏⵏⴰ: “ⵎⴻⵛⵃⴰⵍ ⵉⵙⵙⴰⴳⴳⵯⴰⴷ ⵡⴻⵎⵛⴰⵏ-ⴰ! ⴰⵇⴰ ⵜⴰ ⵎⵖⵉⵔ ⴷ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⴰⵔⴻⴱⴱⵉ ⵓ ⵜⴰⵏⵉⵜⴰ ⴷ ⵜⴰⵡⵡⴰⵔⵜ ⵏ ⵓⵊⴻⵏⵏⴰ!” ");
INSERT INTO rift_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","ⵉⴽⴽⴰⵔ ⵢⴰⵄⵇⵓⴱ ⵓⵛⴰ ⵉⴽⵙⵉ ⴰⵥⵔⵓ ⵏⵏⵉ ⵜⵓⵖⴰ ⵉⵙⵙⴰⵔⵙ ⵙⴰⴷⵓ ⵓⵣⴻⴵⵉⴼ ⵏⵏⴻⵙ, ⵉⴳⴳⴰ ⵉ-ⵜ ⴰⵎ ⵢⵉⵊⵊ ⵏ ⵡⴻⵥⵔⵓ ⵏ ⵍⵉⴷⴰⵔⴻⵜ ⵓⵛⴰ ⵉⴼⴰⵔⵔⴻⵖ ⵣⵣⴻⵛⵜ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏ ⵡⴻⵥⵔⵓ. ");
INSERT INTO rift_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","ⵉⴳⴳⴰ ⴰⵎⵛⴰⵏ ⵏⵏⵉ ⴱⴰⵢⵜ-ⵉⵍ, ⵎⴰⵛⴰ ⵣⴻⴳ ⵓⵎⴻⵣⵡⴰⵔⵓ ⵜⵓⵖⴰ ⵉⵙⴻⵎ ⵏ ⵡⴻⵎⵛⴰⵏ ⵏⵏⵉ ⵍⵓⵣ. ");
INSERT INTO rift_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","ⵓⵛⴰ ⵉⵡⴰⵄⴷ ⵢⴰⵄⵇⵓⴱ, ⵉⵏⵏⴰ: “ⵎⴰⵍⴰ ⴰⵔⴻⴱⴱⵉ ⴰⵇⴰ-ⵜ ⴰⴽⵉⴷⵉ ⵓⵛⴰ ⴰⴷ ⴰⵢⵉ ⵉⵃⴹⴰ ⴷⴻⴳ ⵡⴻⴱⵔⵉⴷ ⵉ ⵖⴰ ⵓⵢⵓⵔⴻⵖ, ⴰⴷ ⴰⵢⵉ ⵉⵡⵛ ⴰⵖⵔⵓⵎ ⵃⵉⵎⴰ ⴰⴷ ⵛⵛⴻⵖ, ⴷ ⵡⴰⵔⵔⵓⴹ ⵃⵉⵎⴰ ⴰⴷ ⴰⵔⴹⴻⵖ ");
INSERT INTO rift_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ⵓ ⵎⴰⵍⴰ ⴷⴻⵡⵍⴻⵖ ⵖⴰⵔ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⴱⴰⴱⴰ ⴷⵉ ⵍⴰⵎⴰⵏ, ⵅⴻⵏⵏⵉ ⵙⵉⴷⵉ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⴰⵔⴻⴱⴱⵉ ⵉ ⵏⴻⵛⵛ. ");
INSERT INTO rift_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","ⵓⵛ ⴰⵥⵔⵓ-ⵢⴰ ⵉ ⴳⴳⵉⵖ ⴷ ⴰⵥⵔⵓ ⵏ ⵍⵉⴷⴰⵔⴻⵜ, ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⴰⵔⴻⴱⴱⵉ ⵓ ⵣⵉ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴷ ⴰⵢⵉ ⵖⴰ ⵜⴻⵡⵛⴻⴷ, ⴰⴷ ⴰⵛ ⵡⵛⴻⵖ ⵍⴻⵄⵛⵓⵔ!” ");
INSERT INTO rift_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","ⵉⴽⵙⵉ ⵢⴰⵄⵇⵓⴱ ⴷⴻⴳ ⵉⴹⴰⵔⴻⵏ ⵏⵏⴻⵙ, ⵉⵔⵓⵃ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴰⵢⵜ ⵏ ⵛⵛⴰⵔⵇ. ");
INSERT INTO rift_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","ⵉⵅⵣⴰⵔ ⵓⵛⴰ ⵉⵥⵔⴰ ⵉⵊⵊ ⵏ ⵡⴰⵏⵓ ⴷⴻⴳ ⵉⵢⵢⴰⵔ ⵓ ⵜⵓⵖⴰ ⴷⵉⵏ ⵜⵍⴰⵜⴰ ⵏ ⵜⵃⵉⵎⵔⵉⵡⵉⵏ ⵏ ⵡⵓⴵⵉ ⵊⵏⵉⵏⵜ ⵣⵣⴰⵜⴻⵙ, ⵎⵉⵏⵣⵉ ⵣⴻⴳ ⵡⴰⵏⵓ ⵏⵏⵉ ⵡⴰⵔⵔⴷⴻⵏ ⵏⵉⵜⵏⵉ ⵜⵉⵃⵉⵎⵔⵉⵡⵉⵏ. ⵜⵓⵖⴰ ⴷⵉⵏ ⵉⵊⵊ ⵏ ⵡⴻⵥⵔⵓ ⵅ ⵓⵇⴻⵎⵎⵓⵎ ⵏ ⵡⴰⵏⵓ. ");
INSERT INTO rift_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","ⵙⵙⵎⵓⵏⴻⵏ ⴷⵉⵏ ⵎⴰⵔⵔⴰ ⵜⵉⵃⵉⵎⵔⵉⵡⵉⵏ. ⵅⴰⵙ ⵓⵛⴰ ⴽⴽⵙⴻⵏ ⴰⵥⵔⵓ ⵅ ⵓⵇⴻⵎⵎⵓⵎ ⵏ ⵡⴰⵏⵓ ⵓⵛⴰ ⵡⴰⵔⴷⴻⵏ ⵓⴵⵉ. ⴰⵡⴰⵔⵏⵉ ⴰⵙ ⴰⵔⵔⵉⵏ ⴰⵥⵔⵓ ⵄⴰⵡⴻⴷ ⵅ ⵓⵇⴻⵎⵎⵓⵎ ⵏ ⵡⴰⵏⵓ. ");
INSERT INTO rift_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","ⵉⵏⵏⴰ ⴰⵙⴻⵏ ⵢⴰⵄⵇⵓⴱ: “ⴰⵢⵜⵎⴰ ⵉⵏⵓ, ⵎⴰⵏⵉⵙ ⴽⴻⵏⵏⵉⵡ?” ⵏⵉⵜⵏⵉ ⴰⵔⵔⵉⵏ-ⴷⴷ: “ⵣⵉ ⵃⴰⵔⴰⵏ ⵉ ⵏⴻⴵⴰ.” ");
INSERT INTO rift_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","ⵏⴻⵜⵜⴰ ⵉⵏⵏⴰ ⴰⵙⴻⵏ: “ⵎⴰ ⵜⴻⵙⵙⵏⴻⵎ ⵍⴰⴱⴰⵏ, ⵎⵎⵉⵙ ⵏ ⵏⴰⵃⵓⵔ?” ⵏⵉⵜⵏⵉ ⴰⵔⵔⵉⵏ-ⴷⴷ: “ⵡⴰⵀ, ⵏⴻⵙⵙⴻⵏ ⵉ-ⵜ.” ");
INSERT INTO rift_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","ⵉⵏⵏⴰ ⴰⵙⴻⵏ ⵏⴻⵜⵜⴰ: “ⵎⴰⵎⵎⴻⵛ ⵉⴵⴰ?” ⴰⵔⵔⵉⵏ-ⴷⴷ: “ⴰⵇⴰ-ⵜ ⵎⵍⵉⵃ, ⴰⵇⴰ ⴷⴰ ⵢⴻⴵⵉⵙ ⵔⴰⵃⵉⵍ ⵜⵓⵙⴰ-ⴷⴷ ⴰⴽ-ⴷ ⵡⵓⴵⵉ.” ");
INSERT INTO rift_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","ⵉⵏⵏⴰ ⴰⵙ: “ⴰⵇⴰ ⴷⴰ ⴰⵣⵉⵍ ⵄⴰⴷ ⵉⵎⵖⴰⵔ, ⵡⴰⵔ ⵢⴻⴵⵉ ⴱⵓ ⵍⵡⴻⵇⵜ ⵃⵉⵎⴰ ⴰⴷ ⵏⴻⵏⴷⴻⵀ ⵍⴻⴱⵀⴰⵢⴻⵎ. ⵡⴰⵔⴷⴻⵎ ⵓⴵⵉ ⵓⵛⴰ ⵔⵓⵃⴻⵎ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⴻⵏ ⵜⴰⵔⴻⵡⵙⴻⵎ.” ");
INSERT INTO rift_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","ⵏⵉⵜⵏⵉ ⴰⵔⵔⵉⵏ-ⴷⴷ: “ⵡⴰⵔ ⵏⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵜ ⵏⴻⴳⴳ ⴰⵍ ⴷⴷ ⵖⴰ ⵎⵓⵏⴻⵏⵜ ⵎⴰⵔⵔⴰ ⵜⵉⵃⵉⵎⵔⵉⵡⵉⵏ. ⵅⴻⵏⵏⵉ ⴰⴷ ⵙⵙⴻⵃⵍⵓⴵⴷⴻⵏ ⴰⵥⵔⵓ ⵅ ⵓⵇⴻⵎⵎⵓⵎ ⵏ ⵡⴰⵏⵓ, ⵃⵉⵎⴰ ⴰⴷ ⵏⵡⴰⵔⴻⴷ ⵓⴵⵉ.” ");
INSERT INTO rift_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","ⵍⴰⵎⵉ ⵜⵓⵖⴰ ⵄⴰⴷ ⵉⵙⵙⴰⵡⴰⵍ ⴰⴽⵉⴷⵙⴻⵏ, ⵜⵓⵙⴰ-ⴷⴷ ⵔⴰⵃⵉⵍ ⵙ ⵡⵓⴵⵉ ⵏ ⴱⴰⴱⴰⵙ, ⵎⵉⵏⵣⵉ ⵏⴻⵜⵜⴰⵜ ⵜⵓⵖⴰ-ⵜⵜ ⴷ ⵜⴰⵎⴻⴽⵙⴰⵡⵜ. ");
INSERT INTO rift_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","ⵍⴰⵎⵉ ⵉⵥⵔⴰ ⵢⴰⵄⵇⵓⴱ ⵔⴰⵃⵉⵍ, ⵢⴻⴵⵉⵙ ⵏ ⵍⴰⴱⴰⵏ, ⵓⵎⴰⵙ ⵏ ⵢⴻⵎⵎⴰⵙ, ⴰⴽ-ⴷ ⵡⵓⴵⵉ ⵏ ⵍⴰⴱⴰⵏ, ⵓⵎⴰⵙ ⵏ ⵢⴻⵎⵎⴰⵙ, ⵉⵅⴻⵛⵛ-ⴷⴷ ⵢⴰⵄⵇⵓⴱ ⵓⵛⴰ ⵉⵙⵙⴻⵃⵍⵓⴵⴻⴷ ⴰⵥⵔⵓ ⵅ ⵓⵇⴻⵎⵎⵓⵎ ⵏ ⵡⴰⵏⵓ, ⵉⵡⴰⵔⴷ ⵓⴵⵉ ⵏ ⵍⴰⴱⴰⵏ, ⵓⵎⴰⵙ ⵏ ⵢⴻⵎⵎⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","ⵉⵙⵙⵓⴷⴻⵎ ⵢⴰⵄⵇⵓⴱ ⵔⴰⵃⵉⵍ, ⵉⵙⵙⴳⴻⵄⵄⴻⴷ ⵜⵎⵉⵊⵊⴰ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⵙⵖⵓⵢ. ");
INSERT INTO rift_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","ⵉⵏⵏⴰ ⵢⴰⵄⵇⵓⴱ ⵉ ⵔⴰⵃⵉⵍ ⴰⵇⴰ ⵏⴻⵜⵜⴰ ⵣⵉ ⵍⴰⴵ ⵏ ⴱⴰⴱⴰⵙ ⵉ ⵉⴵⴰ, ⵓⵍⴰ ⴷ ⵎⵎⵉⵙ ⵏ ⵔⵉⴼⵇⴰ. ⵓⵛⴰ ⵏⴻⵜⵜⴰⵜ ⵜⵓⵣⵣⴻⵍ, ⵜⵅⴻⴱⴱⴰⵔ ⴱⴰⴱⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","ⵓⵎⵉ ⵉⵙⵍⴰ ⵍⴰⴱⴰⵏ ⵍⴻⵅⴱⴰⵔ ⵅ ⵢⴰⵄⵇⵓⴱ, ⵎⵎⵉⵙ ⵏ ⵓⵍⵜⵎⴰⵙ, ⵢⵓⵣⵣⴻⵍ ⴰⴷ ⵜ ⵉⵍⵇⴰ ⵓⵛⴰ ⵉⴷⴰⵔⵔⴻⵄ ⴰⵙ, ⵉⵙⵙⵓⴷⴻⵎ ⵉ-ⵜ, ⵉⵏⴷⴻⵀ ⵉ-ⵜ ⵖⴰⵔ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⴻⵙ. ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵉⵄⴰⵡⴻⴷ ⵎⴰⵔⵔⴰ ⵜⵉⵎⴻⵙⵍⴰⵢⵉⵏ-ⴰ ⵉ ⵍⴰⴱⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","ⵉⵏⵏⴰ ⴰⵙ ⵍⴰⴱⴰⵏ: “ⴷ ⵜⵉⴷⴻⵜⵜ ⵛⴻⴽ ⴷ ⵉⵖⴻⵙ ⵉⵏⵓ ⴷ ⴰⵢⵙⵓⵎ ⵉⵏⵓ ⵉ ⵜⴻⴵⵉⴷ.” ⵓⵛⴰ ⵉⵇⵇⵉⵎ ⵖⴰⵔⴻⵙ ⵍⵇⴻⴷⴷ ⵏ ⵉⵊⵊ ⵏ ⵓⵢⵓⵔ ⵉⴽⵎⴻⵍ. ");
INSERT INTO rift_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵍⴰⴱⴰⵏ ⵉ ⵢⴰⵄⵇⵓⴱ: “ⵓⵎⵉ ⵛⴻⴽ ⴷ ⵓⵎⴰ ⵉ ⵜⴻⴵⵉⴷ, ⵎⴰ ⴰⴷ ⵖⴰⵔⵉ ⵜⵅⴻⴷⵎⴻⴷ ⴱⴰⵟⴻⵍ? ⵉⵏⵉ ⴰⵢⵉ ⵎⵉⵏ ⵉ ⵖⴰ ⵜⵉⵍⵉ ⵍⵎⵓⵏⴻⵜ ⵏⵏⴻⵛ?” ");
INSERT INTO rift_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","ⵍⴰⴱⴰⵏ ⵖⴰⵔⴻⵙ ⵜⵏⴰⵢⴻⵏ ⵏ ⵢⴻⵙⵙⵉⵙ. ⵉⵙⴻⵎ ⵏ ⵜⵎⴻⵏⵣⵓⵜ ⴷ ⵍⵉⵢⴰ ⵓ ⵉⵙⴻⵎ ⵏ ⵜⵎⴰⵥⵓⵥⵜ, ⵔⴰⵃⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵍⵉⵢⴰ ⵜⵓⵖⴰ ⴽⴻⵛⵄⴻⵏⵜ, ⵎⴰⵛⴰ ⵔⴰⵃⵉⵍ ⵜⵓⵖⴰ ⴷⴰⵢⴻⵙ ⴰⵥⵍⵉ ⵏ ⵡⴰⴷⴷⵓⴷ ⵓ ⵏ ⵍⵅⴻⵣⵔⴰⵜ. ");
INSERT INTO rift_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","ⵢⴰⵄⵇⵓⴱ ⵉⵅⵙ ⵔⴰⵃⵉⵍ. ⵉⵏⵏⴰ: “ⵏⴻⵛⵛ ⴰⴷ ⵖⴰⵔⴻⴽ ⵅⴻⴷⵎⴻⵖ ⵙⴻⴱⵄⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵅ ⵔⴰⵃⵉⵍ ⵢⴻⴵⵉⵙ ⵜⵎⴰⵥⵓⵥⵜ.” ");
INSERT INTO rift_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","ⵍⴰⴱⴰⵏ ⵢⴰⵔⵔⴰ-ⴷⴷ: “ⵅⴰⵔ ⴰⴷ ⴰⵛ ⵜⵜ ⵡⵛⴻⵖ ⵉ ⵛⴻⴽ ⵏⵉⵖ ⴰⴷ ⵜⵜ ⵡⵛⴻⵖ ⵉ ⵡⴻⵔⵢⴰⵣ ⵏⵏⴻⵖⵏⵉ. ⵇⵇⵉⵎ ⴰⴽⵉⴷⵉ.” ");
INSERT INTO rift_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","ⴰⵎⵎⵓ ⵉ ⵉⵅⴷⴻⵎ ⵢⴰⵄⵇⵓⴱ ⵅ ⵔⴰⵃⵉⵍ ⵙⴻⴱⵄⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵎⴰⵛⴰ ⴹⵀⴰⵔⴻⵏ ⴰⵙ-ⴷⴷ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵏⵏⵉ ⴰⵎⴻⵛⵏⴰⵡ ⵛⴰ ⵏ ⵡⵓⵙⵙⴰⵏ, ⵎⵉⵏⵣⵉ ⵜⵓⵖⴰ ⵉⵜⵜⴻⵅⵙ ⵉ-ⵜⵜ. ");
INSERT INTO rift_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","ⵉⵏⵏⴰ ⵢⴰⵄⵇⵓⴱ ⵉ ⵍⴰⴱⴰⵏ: “ⴻⵡⵛ ⴰⵢⵉ ⵍⴻⵅⵅⵓ ⵜⴰⵎⵖⴰⵔⵜ ⵉⵏⵓ, ⵎⵉⵏⵣⵉ ⴰⵇⴰ ⴽⴻⵎⵎⵍⴻⵏ ⵡⵓⵙⵙⴰⵏ ⵏ ⵍⵎⵉⵊⴰⵍ ⵉⵏⵓ, ⴰⵍⴰⵎⵉ ⵅⴰⵙ ⵉ ⵖⴰ ⵢⴰⴷⴼⴻⵖ.” ");
INSERT INTO rift_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","ⵅⴻⵏⵏⵉ ⵉⵙⵙⵎⵓⵏ ⵍⴰⴱⴰⵏ ⵎⴰⵔⵔⴰ ⵉⵔⵢⴰⵣⴻⵏ ⵏ ⵡⴻⵎⵛⴰⵏ ⵏⵏⵉ, ⵉⴳⴳⴰ ⵓⵔⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","ⵖⴰⵔ ⵜⵎⴻⴷⴷⵉⵜ ⵉⴽⵙⵉ ⵢⴻⴵⵉⵙ ⵍⵉⵢⴰ ⵓⵛⴰ ⵉⵙⵙⵉⵡⴻⴹ ⵉ-ⵜⵜ ⵖⴰⵔⴻⵙ ⵓⵛⴰ ⵢⵓⴷⴻⴼ ⵅⴰⵙ ⵢⴰⵄⵇⵓⴱ. ");
INSERT INTO rift_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","ⵉⵡⵛⴰ ⵍⴰⴱⴰⵏ ⵜⴰⵢⵢⴰ ⵏⵏⴻⵙ ⵣⵉⵍⴱⴰ ⵉ ⵢⴻⴵⵉⵙ ⵍⵉⵢⴰ ⴷ ⵜⴰⵢⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","ⵜⵉⵡⴻⵛⵛⴰ ⵏⵏⴻⵙ ⵉⵥⵔⴰ ⵢⴰⵄⵇⵓⴱ ⴱⴻⵍⵍⵉ ⴷ ⵍⵉⵢⴰ. ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵉ ⵍⴰⴱⴰⵏ: “ⵎⵉⵏ ⴷ ⴰⵢⵉ ⵜⴻⴳⴳⵉⴷ? ⵎⴰ ⵡⴰⵔ ⴷ ⴰⵛ ⵅⴷⵉⵎⴻⵖ ⵅ ⵔⴰⵃⵉⵍ? ⵎⴰⵖⴰⵔ ⴷ ⴰⵢⵉ ⵜⵛⴻⵎⵜⴻⴷ?” ");
INSERT INTO rift_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","ⵍⴰⴱⴰⵏ ⵉⵏⵏⴰ: “ⵡⴰⵔ ⵉⵜⵜⵉⵍⵉ ⵓⵢⴰ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⴻⵖ ⴰⴷ ⵏⴻⵙⵙⵉⵣⵣⴰⵔ ⵜⴰⵎⴰⵥⵓⵥⵜ ⵅ ⵜⵎⴻⵏⵣⵓⵜ. ");
INSERT INTO rift_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","ⴽⴻⵎⵎⴻⵍ ⵙⵙⵉⵎⴰⵏⴰ-ⵢⴰ ⵏ ⵡⵓⵔⴰⵔ ⵏ ⵜⴰ, ⵅⴻⵏⵏⵉ ⴰⴷ ⴰⵛ ⵏⴻⵡⵛ ⵄⴰⵡⴻⴷ ⵜⵉⵏ ⵅ ⵍⵅⴻⴷⵎⴻⵜ ⵉ ⵖⴰ ⵜⴻⴳⴳⴻⴷ ⵙⵙⴰ ⵜⵙⴰⵡⴻⵏⵜ ⴰⴽⵉⴷⵉ ⵄⴰⴷ ⵙⴻⴱⵄⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵏⵏⴻⵖⵏⵉ.” ");
INSERT INTO rift_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","ⵉⴳⴳⴰ ⵢⴰⵄⵇⵓⴱ ⴰⵎⴻⵏⵏⵉ, ⵉⴽⴻⵎⵎⴻⵍ ⵙⵙⵉⵎⴰⵏⴰ-ⵢⴰ ⵏ ⵡⵓⵔⴰⵔ. ⵅⴻⵏⵏⵉ ⵉⵡⵛⴰ ⴰⵙ ⵢⴻⴵⵉⵙ ⵔⴰⵃⵉⵍ ⴷ ⵜⴰⵎⵖⴰⵔⵜ ");
INSERT INTO rift_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","ⵓⵛⴰ ⵉⵡⵛⴰ ⵍⴰⴱⴰⵏ ⵜⴰⵢⵢⴰ ⵏⵏⴻⵙ ⴱⵉⵍⵀⴰ ⵉ ⵢⴻⴵⵉⵙ ⵔⴰⵃⵉⵍ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⵉⵍⵉ ⴷ ⵜⴰⵢⵢⴰ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","ⵢⵓⴷⴻⴼ ⵢⴰⵄⵇⵓⴱ ⵄⴰⵡⴻⴷ ⵅ ⵔⴰⵃⵉⵍ ⵓⵛⴰ ⵉⵅⵙ ⵔⴰⵃⵉⵍ ⵄⴰⴷ ⴽⵜⴰⵔ ⵅ ⵍⵉⵢⴰ. ⵓⵛⴰ ⵉⵙⴻⵅⵅⴰⵔ ⴰⵙ ⵄⴰⵡⴻⴷ ⵙⴻⴱⵄⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵏⵏⴻⵖⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","ⵓⵎⵉ ⵉⵥⵔⴰ ⵙⵉⴷⵉ ⴱⴻⵍⵍⵉ ⵍⵉⵢⴰ ⵜⵓⵖⴰ ⵜᵉⵜⵜⵡⴰⵙⵙⴻⵃⵇⴰⵔ, ⵢⴰⵔⵣⴻⵎ ⵍⴻⵎⵍⴰⵡⴻⵜ ⵏⵏⴻⵙ, ⵎⴰⵛⴰ ⵔⴰⵃⵉⵍ ⵜⵓⵖⴰ ⵡⴰⵔ ⴷⴷ-ⵜᵉⵜⵜⵉⵔⵓⵡ ⵛⴰ. ");
INSERT INTO rift_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","ⵜⴻⴽⵙⵉ ⵍⵉⵢⴰ ⵙ ⴷⴷⴻⵢⵙⴻⵜ ⵓⵛⴰ ⵜⵓⵔⵓⵡ-ⴷⴷ ⴰⵃⴻⵏⵊⵉⵔ, ⵉⴳⴳⴰ ⴰⵙ ⵔⵓⴱⵉⵏ, ⵎⵉⵏⵣⵉ ⵜⴻⵏⵏⴰ: “ⴰⵇⴰ ⵙⵉⴷⵉ ⵉⵅⵣⴰⵔ ⵖⴰⵔ ⵍⴻⵎⵃⴰⵢⴻⵎ ⵉⵏⵓ. ⵍⴻⵅⵅⵓ ⴰⴷ ⴰⵢⵉ ⵉⵅⵙ ⵡⴻⵔⵢⴰⵣ ⵉⵏⵓ.” ");
INSERT INTO rift_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","ⵜⴻⴽⵙⵉ ⵄⴰⵡⴻⴷ ⵙ ⴷⴷⴻⵢⵙⴻⵜ, ⵜⵓⵔⵓⵡ-ⴷⴷ ⴰⵃⴻⵏⵊⵉⵔ, ⵜⴻⵏⵏⴰ: “ⵓⵎⵉ ⵉⵙⵍⴰ ⵙⵉⴷⵉ ⴱⴻⵍⵍⵉ ⵏⴻⵛⵛ ⵜⵜⵡⴰⵙⵙⴻⵃⵇⴰⵔⴻⵖ, ⵉⵡⵛⴰ ⴰⵢⵉ ⵄⴰⵡⴻⴷ ⵡⴰ.” ⵓⵛⴰ ⵜⴻⴳⴳⴰ ⴰⵙ ⵛⵉⵎⵄⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","ⵜⴻⴽⵙⵉ ⵄⴰⵡⴻⴷ ⵙ ⴷⴷⴻⵢⵙⴻⵜ, ⵜⵓⵔⵓⵡ-ⴷⴷ ⴰⵃⴻⵏⵊⵉⵔ, ⵜⴻⵏⵏⴰ: “ⵍⴻⵅⵅⵓ ⵜⵡⴰⵍⴰ-ⵢⴰ ⴰⴷ ⵉⵎⵓⵏ ⵡⴻⵔⵢⴰⵣ ⵉⵏⵓ ⴰⴽⵉⴷⵉ, ⵎⵉⵏⵣⵉ ⵓⵔⵡⴻⵖ ⴰⵙ-ⴷⴷ ⵜⵍⴰⵜⴰ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ.” ⵅ ⵓⵢⴰ ⵏⴻⵜⵜⴰ ⵉⴳⴳⴰ ⴰⵙ ⵍⴰⵡⵉ. ");
INSERT INTO rift_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","ⵜⴻⴽⵙⵉ ⵜⵡⴰⵍⴰ ⵏⵏⴻⵖⵏⵉ ⵙ ⴷⴷⴻⵢⵙⴻⵜ, ⵜⵓⵔⵓⵡ-ⴷⴷ ⴰⵃⴻⵏⵊⵉⵔ ⵓⵛⴰ ⵜⴻⵏⵏⴰ: “ⵜⵡⴰⵍⴰ-ⵢⴰ ⴰⴷ ⵇⴰⴷⵉⵖ ⵙⵉⴷⵉ.” ⵅ ⵓⵢⴰ ⵜⴻⴳⴳⴰ ⴰⵙ ⵢⴰⵀⵓⴷⴰ. ⴰⵡⴰⵔⵏⵉ ⵎⴰⵏ ⴰⵢⴰ ⵜⴻⵙⵙⴱⴻⴷⴷ ⵜⴰⵔⵡⴰ. ");
INSERT INTO rift_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","ⵓⵎⵉ ⵜⴻⵥⵔⴰ ⵔⴰⵃⵉⵍ ⴱⴻⵍⵍⵉ ⵡⴰⵔ ⴷⴷ-ⵜⵉⵔⵓⵡ ⵉ ⵢⴰⵄⵇⵓⴱ, ⵜⵓⵙⴻⵎ ⵣⴻⴳ ⵓⵍⵜⵎⴰⵙ, ⵜⴻⵏⵏⴰ ⵉ ⵢⴰⵄⵇⵓⴱ: “ⴻⵡⵛ ⴰⵢⵉ ⵜⴰⵔⵡⴰ! ⵎⴰⵍⴰ ⵡⴰⵔ ⵜⴻⵇⴱⵉⵍⴻⴷ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵎⵎⵜⴻⵖ.” ");
INSERT INTO rift_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","ⵉⵅⴻⵢⵢⴻⵇ ⵢⴰⵄⵇⵓⴱ ⵅ ⵔⴰⵃⵉⵍ, ⵉⵏⵏⴰ: “ⵎⴰ ⴰⵇⴰ ⴰⵢⵉ ⵏⴻⵛⵛ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏ ⴰⵔⴻⴱⴱⵉ, ⵡⴻⵏⵏⵉ ⵅⴰⵎ ⵉⵟⵟⴼⴻⵏ ⵍⵖⵉⴵⴻⵜ ⵏ ⵓⵄⴻⴷⴷⵉⵙ ⵏⵏⴻⵎ?” ");
INSERT INTO rift_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","ⵜⴻⵏⵏⴰ: “ⴰⵇⴰ ⴷⴰ ⵜⴰⵢⵢⴰ ⵉⵏⵓ ⴱⵉⵍⵀⴰ. ⴰⴷⴻⴼ ⵅⴰⵙ, ⵃⵉⵎⴰ ⴰⴷ ⴷⴷ-ⵜⴰⵔⵓⵡ ⵅ ⵉⴼⴰⴷⴷⴻⵏ ⵉⵏⵓ ⵎⴰⵃⴻⵏⴷ ⵓⵍⴰ ⴷ ⵏⴻⵛⵛ ⴰⴷ ⵖⴰⵔⵉ ⵜⵉⵍⵉ ⵜⴰⵔⵔⴰⵡⵜ ⵣⵣⴰⵢⴻⵙ.” ");
INSERT INTO rift_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","ⵜⴻⵡⵛⴰ ⴰⵙ ⴱⵉⵍⵀⴰ, ⵜⴰⵢⵢⴰ ⵏⵏⴻⵙ, ⴷ ⵜⴰⵎⵖⴰⵔⵜ ⵓⵛⴰ ⵢⵓⴷⴻⴼ ⵅⴰⵙ ⵢⴰⵄⵇⵓⴱ. ");
INSERT INTO rift_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","ⵜⴻⴽⵙⵉ ⴱⵉⵍⵀⴰ ⵙ ⴷⴷⴻⵢⵙⴻⵜ ⵓⵛⴰ ⵜⵓⵔⵓⵡ-ⴷⴷ ⴰⵃⴻⵏⵊⵉⵔ ⵉ ⵢⴰⵄⵇⵓⴱ. ");
INSERT INTO rift_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","ⵜⴻⵏⵏⴰ ⵔⴰⵃⵉⵍ: “ⵉⵡⵛⴰ ⴰⵢⵉ ⴰⵔⴻⴱⴱⵉ ⵜⴰⵙⵖⴰⵔⵜ ⵓⵛⴰ ⵉⵙⵍⴰ ⵄⴰⵡⴻⴷ ⵖⴰⵔⵉ. ⵉⵡⵛⴰ ⴰⵢⵉ ⵎⵎⵉ.” ⵅ ⵓⵢⴰ ⵜⴻⴳⴳⴰ ⴰⵙ ⴷⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","ⵜⴻⴽⵙⵉ ⴱⵉⵍⵀⴰ, ⵜⴰⵢⵢⴰ ⵏ ⵔⴰⵃⵉⵍ, ⵜⵡⴰⵍⴰ ⵏⵏⴻⵖⵏⵉ ⵙ ⴷⴷⴻⵢⵙⴻⵜ ⵓⵛⴰ ⵜⵓⵔⵓⵡ-ⴷⴷ ⵉ ⵢⴰⵄⵇⵓⴱ ⴰⵃⴻⵏⵊⵉⵔ ⵡⵉⵙⵙ ⵜⵏⴰⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","ⵜⴻⵏⵏⴰ ⵔⴰⵃⵉⵍ: “ⵙ ⵉⵎⴻⵏⵖⴰⵏ ⵏ ⴰⵔⴻⴱⴱⵉ ⵎⴻⵏⵖⴻⵖ ⴰⴽ-ⴷ ⵓⵍⵜⵎⴰ ⵓⵛⴰ ⵖⴻⵍⴱⴻⵖ.” ⵜⴻⴳⴳⴰ ⴰⵙ ⵏⴰⴼⵜⴰⵍⵉ. ");
INSERT INTO rift_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","ⵓⵎⵉ ⵜⴻⵥⵔⴰ ⵍⵉⵢⴰ ⵜⴻⵙⵙⴱⴻⴷⴷ ⵜⴰⵔⵡⴰ, ⵜⴻⴽⵙⵉ ⵣⵉⵍⴱⴰ, ⵜⴰⵢⵢⴰ ⵏⵏⴻⵙ, ⵜⴻⵡⵛⴰ ⵉ-ⵜⵜ ⵉ ⵢⴰⵄⵇⵓⴱ ⴷ ⵜⴰⵎⵖⴰⵔⵜ, ");
INSERT INTO rift_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","ⵓⵛⴰ ⵣⵉⵍⴱⴰ, ⵜⴰⵢⵢⴰ ⵏ ⵍⵉⵢⴰ, ⵜⵓⵔⵓⵡ-ⴷⴷ ⴰⵃⴻⵏⵊⵉⵔ ⵉ ⵢⴰⵄⵇⵓⴱ. ");
INSERT INTO rift_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","ⵜⴻⵏⵏⴰ ⵍⵉⵢⴰ: “ⵎⴰⵏⴰ ⵍⵅⵉⵔ-ⴰ!” ⵓⵛⴰ ⵜⴻⴳⴳⴰ ⴰⵙ ⵊⴰⴷ. ");
INSERT INTO rift_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","ⵓⵛⴰ ⵜⵓⵔⵓⵡ-ⴷⴷ ⵣⵉⵍⴱⴰ, ⵜⴰⵢⵢⴰ ⵏ ⵍⵉⵢⴰ, ⴰⵃⴻⵏⵊⵉⵔ ⵡⵉⵙⵙ ⵜⵏⴰⵢⴻⵏ ⵉ ⵢⴰⵄⵇⵓⴱ. ");
INSERT INTO rift_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","ⵓⵛⴰ ⵜⴻⵏⵏⴰ ⵍⵉⵢⴰ: “ⴰ ⵙⵙⴻⵄⴷ ⵉⵏⵓ!”, ⵎⵉⵏⵣⵉ ⵜⵉⴱⵍⵉⵖⵉⵏ ⴰⴷ ⴰⵢⵉ ⵃⴻⵙⴱⴻⵏⵜ ⴷ ⵙⵙⴻⵄⴷ!” ⵓⵛⴰ ⵜⴻⴳⴳⴰ ⴰⵙ ⴰⵛⵉⵔ. ");
INSERT INTO rift_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","ⴷⴻⴳ ⵡⵓⵙⵙⴰⵏ ⵏ ⵜⵎⴻⵢⵔⴰ ⵏ ⵉⵔⴷⴻⵏ ⵉⴼⴼⴻⵖ ⵔⵓⴱⵉⵏ ⵓⵛⴰ ⵢⵓⴼⴰ ‘ⵜⵉⵜⴻⴼⴼⴰⵃⵉⵏ ⵏ ⵜⴰⵢⵔⵉ’ ⴷⴻⴳ ⵉⵢⵢⴰⵔ ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵢⵉⵡⵢ ⵉ-ⵜⴻⵏⵜ ⵉ ⵍⵉⵢⴰ, ⵢⴻⵎⵎⴰⵙ. ⵅⴻⵏⵏⵉ ⵜⴻⵏⵏⴰ ⵔⴰⵃⵉⵍ ⵉ ⵍⵉⵢⴰ: “ⵜⵜⵣⴰⵡⴳⴻⵖ ⵛⴻⵎ ⴰⴷ ⴰⵢⵉ ⵜⴻⵡⵛⴻⴷ ⵣⵉ ‘ⵜⵜⴻⴼⴼⴰⵃⵉⵏ ⵏ ⵜⴰⵢⵔⵉ’ ⵏ ⵎⵎⵉⵎ.” ");
INSERT INTO rift_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","ⵎⴰⵛⴰ ⵍⵉⵢⴰ ⵜⴻⵏⵏⴰ ⴰⵙ: “ⵎⴰ ⵡⴰⵔ ⵉⴵⵉ ⴷⵔⵓⵙ ⴰⵍⴰⵎⵉ ⵜⵉⵡⵢⴻⴷ ⴰⵔⵢⴰⵣ ⵉⵏⵓ, ⵓⵎⵉ ⵜⴻⵅⵙⴻⴷ ⵄⴰⵡⴻⴷ ⴰⴷ ⴷⴷ-ⵜⴰⵡⵢⴻⴷ ‘ⵜⵉⵜⴻⴼⴼⴰⵃⵉⵏ ⵏ ⵜⴰⵢⵔⵉ’ ⵏ ⵎⵎⵉ?” ⵜⴻⵏⵏⴰ ⵔⴰⵃⵉⵍ: “ⵙ ⵓⵢⴰ ⴰⴷ ⵉⵟⵟⴻⵚ ⴰⴽⵉⴷⴻⵎ ⴵⵉⵍⴻⵜ-ⴰ ⵅ ‘ⵜⵜⴻⴼⴼⴰⵃⵉⵏ ⵏ ⵜⴰⵢⵔⵉ’ ⵏ ⵎⵎⵉⵎ.” ");
INSERT INTO rift_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","ⵓⵎⵉ ⴷⴷ-ⵉⵄⵇⴻⴱ ⵢⴰⵄⵇⵓⴱ ⵣⴻⴳ ⵉⵢⵢⴰⵔ ⵙ ⵜⵎⴻⴷⴷⵉⵜ, ⵜⴻⴼⴼⴻⵖ-ⴷⴷ ⵍⵉⵢⴰ ⵖⴰⵔⴻⵙ ⵜⴻⵏⵏⴰ ⴰⵙ: “ⴰⴷ ⵅⴰⴼⵉ ⵜⴰⴷⴼⴻⴷ, ⵎⵉⵏⵣⵉ ⵏⵉⵛⴰⵏ ⵛⵔⵉⵖ ⵛⴻⴽ ⵙ ‘ⵜⵜⴻⴼⴼⴰⵃⵉⵏ ⵏ ⵜⴰⵢⵔⵉ’ ⵏ ⵎⵎⵉ.” ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⵉⵟⵟⴻⵚ ⴰⴽⵉⴷⴻⵙ ⴵⵉⵔⴻⵜ ⵏⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","ⵉⵙⵍⴰ ⴰⵔⴻⴱⴱⵉ ⵉ ⵍⵉⵢⴰ ⵓⵛⴰ ⵜⴻⴽⵙⵉ ⵙ ⴷⴷⴻⵢⵙⴻⵜ ⵓⵛⴰ ⵜⵓⵔⵓⵡ-ⴷⴷ ⴰⵃⴻⵏⵊⵉⵔ ⵡⵉⵙⵙ ⵅⴻⵎⵙⴰ ⵉ ⵢⴰⵄⵇⵓⴱ. ");
INSERT INTO rift_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","ⵜⴻⵏⵏⴰ ⵍⵉⵢⴰ: “ⴰⵔⴻⴱⴱⵉ ⵉⵡⵛⴰ ⴰⵢⵉ ⵍⵎⵓⵏⴻⵜ ⵉⵏⵓ ⵅ ⵓⵎⵉ ⵡⵛⵉⵖ ⵜⴰⵢⵢⴰ ⵉⵏⵓ ⵉ ⵡⴻⵔⵢⴰⵣ ⵉⵏⵓ!” ⵓⵛⴰ ⵜⴻⴳⴳⴰ ⴰⵙ ⵉⵙⵙⴰⴽⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","ⵜⴻⴽⵙⵉ ⵍⵉⵢⴰ ⵄⴰⵡⴻⴷ ⵙ ⴷⴷⴻⵢⵙⴻⵜ ⵓⵛⴰ ⵜⵓⵔⵓⵡ-ⴷⴷ ⴰⵃⴻⵏⵊⵉⵔ ⵡⵉⵙⵙ ⵙⴻⵜⵜⴰ ⵉ ⵢⴰⵄⵇⵓⴱ. ");
INSERT INTO rift_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","ⵓⵛⴰ ⵜⴻⵏⵏⴰ ⵍⵉⵢⴰ: “ⴰⵔⴻⴱⴱⵉ ⵉⵡⵛⴰ ⴰⵢⵉ ⵉⵛⵜ ⵏ ⵍⴱⴰⵔⴰⴽⴰ ⵜⴻⵛⵏⴰ. ⵍⴻⵅⵅⵓ ⴰⴷ ⴽⵉⴷⵉ ⵉⵣⴷⴻⵖ ⵡⴻⵔⵢⴰⵣ ⵉⵏⵓ, ⵎⵉⵏⵣⵉ ⵓⵔⵡⴻⵖ ⴰⵙ-ⴷⴷ ⵙⴻⵜⵜⴰ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ.” ⵓⵛⴰ ⵜⴻⴳⴳⴰ ⴰⵙ ⵣⴰⴱⵓⵍⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","ⴰⵡⴰⵔⵏⵉ ⴰⵙ ⵜⵓⵔⵓⵡ-ⴷⴷ ⵜⴰⵃⴻⵏⵊⵉⵔⵜ. ⵜⴻⴳⴳⴰ ⴰⵙ ⴷⵉⵏⴰ. ");
INSERT INTO rift_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","ⵅⴻⵏⵏⵉ ⵉⴷⴰⵔ ⴰⵔⴻⴱⴱⵉ ⵔⴰⵃⵉⵍ ⵓⵛⴰ ⵉⵙⵍⴰ ⴰⵙ ⴰⵔⴻⴱⴱⵉ ⵓⵛⴰ ⵢⴰⵔⵣⴻⵎ ⵍⴻⵎⵍⴰⵡⵍⴻⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","ⵜⴻⴽⵙⵉ ⵙ ⴷⴷⴻⵢⵙⴻⵜ ⵓⵛⴰ ⵜⵓⵔⵓⵡ-ⴷⴷ ⴰⵃⴻⵏⵊⵉⵔ, ⵜⴻⵏⵏⴰ: “ⵉⴽⴽⴻⵙ ⴰⵔⴻⴱⴱⵉ ⵍⵃⴻⴳⵔⴰ ⵉⵏⵓ!” ");
INSERT INTO rift_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","ⵓⵛⴰ ⵜⴻⴳⴳⴰ ⴰⵙ ⵢⵓⵙⵓⴼ, ⵜⴻⵏⵏⴰ: “ⴰⴷ ⴰⵢⵉ ⵢⴰⵔⵏⵉ ⵙⵉⴷⵉ ⴰⵃⴻⵏⵊⵉⵔ ⵏⵏⴻⵖⵏⵉ.” ");
INSERT INTO rift_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","ⵍⴰⵎⵉ ⴷⴷ-ⵜⵓⵔⵓⵡ ⵔⴰⵃⵉⵍ ⵢⵓⵙⵓⴼ, ⵉⵏⵏⴰ ⵢⴰⵄⵇⵓⴱ ⵉ ⵍⴰⴱⴰⵏ: “ⵙⴻⴽⴽ ⴰⵢⵉ ⵓⵛⴰ ⴰⴷ ⵔⴰⵃⴻⵖ ⵖⴰⵔ ⴷⵛⴰⵔ ⵉⵏⵓ ⴷ ⵜⴻⵎⵎⵓⵔⵜ ⵉⵏⵓ. ");
INSERT INTO rift_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","ⴻⵡⵛ ⴰⵢⵉ ⵜⵉⵎⵖⴰⵔⵉⵏ ⵉⵏⵓ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵉⵏⵓ ⵎⵉⵏ ⵣⵉ ⵖⴰⵔⴻⴽ ⵅⴻⴷⵎⴻⵖ. ⵅⴻⵏⵏⵉ ⴰⴷ ⴼⴼⵖⴻⵖ. ⴰⵇⴰ ⵛⴻⴽ ⵜⴻⵙⵙⵏⴻⴷ ⵍⵅⴻⴷⵎⴻⵜ ⵉ ⵣⵉ ⵜⵓⵖⴰ ⴷ ⴰⵛ ⵜⵜⵙⴻⵅⵅⴰⵔⴻⵖ.” ");
INSERT INTO rift_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","ⵉⵏⵏⴰ ⴰⵙ ⵍⴰⴱⴰⵏ: “ⵎⵍⵉ ⵓⴼⵉⵖ ⵍⴻⵅⵅⵓ ⴰⵔⴹⴰ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵛ. ⴰⵇⴰ ⵥⵔⵉⵖ ⵙ ⵉⵊⵊ ⵏ ⵍⴻⵄⵊⴻⴱ ⴱⴻⵍⵍⵉ ⵙⵉⴷⵉ ⵉⴱⴰⵔⴻⴽ ⴰⵢⵉ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏⵏⴻⵛ.” ");
INSERT INTO rift_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","ⵢⴰⵔⵏⵉ ⵉⵏⵏⴰ: “ⵉⵏⵉ ⴰⵢⵉ ⵣⴻⵄⵎⴰ ⵎⴰⵏ ⵍⵎⵓⵏⴻⵜ ⵉ ⵜⴻⵅⵙⴻⴷ, ⵓⵛⴰ ⴰⴷ ⴰⵛ ⵜⵜ ⵡⵛⴻⵖ.” ");
INSERT INTO rift_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⴰⵙ: “ⵛⴻⴽ ⵜⴻⵙⵙⵏⴻⴷ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵛ ⵅⴻⴷⵎⴻⵖ ⴷ ⵎⴰⵎⵎⴻⵛ ⵓⵢⵓⵔⴻⵖ ⴰⴽ-ⴷ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏⵏⴻⵛ ⵣⴻⴳ ⵡⴰⵎⵉ ⴽⵉⵛ ⴵⵉⵖ. ");
INSERT INTO rift_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","ⵎⵉⵏⵣⵉ ⴷⵔⵓⵙⵜ ⵉ ⵜⵓⵖⴰ ⵖⴰⵔⴻⴽ ⵍⴻⵅⴷⴻⵏⵏⵉ ⵇⴱⴻⵍ ⵉ ⴷⴷ-ⵓⵙⵉⵖ, ⴰⵇⴰ ⵉⴷⵡⴻⵍ ⴷⴻⴳ ⵡⴰⵟⵟⴰⵙ, ⵓⵛⴰ ⵉⴱⴰⵔⴻⴽ ⵉ ⵛⴻⴽ ⵙⵉⴷⵉ ⴷⴻⴳ ⵉⵚⵓⵔⴰⴼ ⵉⵏⵓ. ⵅⴻⵏⵏⵉ ⵍⴻⵅⵅⵓ, ⵎⴻⵍⵎⵉ ⵣⴻⵎⵎⴰⵔⴻⵖ ⴰⴷ ⵅⴻⴷⵎⴻⵖ ⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵉⵏⵓ?” ");
INSERT INTO rift_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","ⵉⵏⵏⴰ ⴰⵙ: “ⵎⵉⵏ ⴷ ⴰⵛ ⵉ ⵖⴰ ⵡⵛⴻⵖ?” ⵢⴰⵔⵔⴰ-ⴷⴷ ⵢⴰⵄⵇⵓⴱ: “ⵡⴰⵔ ⴷ ⴰⵢⵉ ⵜⵜⵉⵛ ⵡⴰⵍⵓ, ⵎⴰⵛⴰ ⵙⴰⵎⵃ ⴰⵢⵉ ⴰⵢⴰ ⵡⴰⵀⴰ, ⵅⴻⵏⵏⵉ ⴰⴷ ⴷⴷ-ⴷⴻⵡⵍⴻⵖ ⴰⴷ ⴰⵔⴻⵡⵙⴻⵖ ⵓⴵⵉ ⵏⵏⴻⵛ ⵄⴰⵡⴻⴷ ⵓⵛⴰ ⴰⴷ ⵜⴻⵏ ⵃⴹⵉⵖ. ");
INSERT INTO rift_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","ⴰⵙⵙ-ⴰ ⴰⴷ ⵄⴷⵓⵖ ⵅ ⵎⴰⵔⵔⴰ ⵜⴰⵃⵉⵎⴰⵔⵜ ⵏ ⵡⵓⴵⵉ ⵏⵏⴻⵛ. ⴻⴳⴳ ⵛⴻⴽ ⵅ ⵓⵖⴻⵣⴷⵉⵙ ⵣⵣⴰⵢⴻⵙ ⵎⴰⵔⵔⴰ ⵓⴵⵉ ⵉⴱⴻⵇⵇⴹⴻⵏ ⴷ ⵉⵇⴰⵔⵇⴰⵛⴻⵏ, ⵎⴰⵔⵔⴰ ⵓⴵⵉ ⴰⴱⴰⵔⵛⴰⵏ ⵊⴰⵔ ⵉⵃⵓⵍⵉⵢⵢⴻⵏ ⴷ ⵎⵉⵏ ⵉⴵⴰⵏ ⴷ ⴰⵇⴰⵔⵇⴰⵛ ⵏⵉⵖ ⵙ ⵉⴱⴻⵇⵇⵉⴹⴻⵏ ⵊⴰⵔ ⵉⵖⴰⵢⴹⴻⵏ. ⵎⴰⵏ ⴰⵢⴰ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵍⵎⵓⵏⴻⵜ ⵉⵏⵓ. ");
INSERT INTO rift_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","ⵅⵎⵉ ⴷⴷ ⵖⴰ ⵜⴰⵙⴻⴷ ⴷⴻⴳ ⵉⵊⵊ ⵏ ⵡⴰⵙⵙ ⵏ ⵢⵉⵎⴰⵍ ⵎⴰⵃⴻⵏⵙ ⴰⴷ ⵜⵥⴰⵔⴻⴷ ⵍⵎⵓⵏⴻⵜ ⵉⵏⵓ, ⴰⴷ ⵜⴱⴰⵏ ⵜⵙⴻⴳⴷⴰ ⵉⵏⵓ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏⵏⴻⵛ ⴰⵎⵎⵓ ⵏⵉⵛⴰⵏ: ⵎⵉⵏ ⵡⴰⵔ ⵉⴵⵉⵏ ⵉⴱⴻⵇⵇⴻⴹ ⵏⵉⵖ ⵎⵉⵏ ⵡⴰⵔ ⵉⴵⵉⵏ ⵉⵇⵇⴰⵔⵇⴻⵛ ⵊⴰⵔ ⵉⵖⴰⵢⴹⴻⵏ ⴷ ⵎⵉⵏ ⵡⴰⵔ ⵉⴵⵉⵏ ⴷ ⴰⴱⴰⵔⵛⴰⵏ ⵊⴰⵔ ⵉⵃⵓⵍⵉⵢⵢⴻⵏ, ⴰⵇⴰ ⴰⴷ ⵉⵜⵜⵡⴰⵃⵙⴻⴱ ⵉⵜⵜⵡⴰⵛⴰⵔ ⵊⴰⵔ ⵎⵉⵏ ⵉⴵⴰⵏ ⵉⵏⵓ.” ");
INSERT INTO rift_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵍⴰⴱⴰⵏ: “ⵅⵣⴰⵔ, ⴰⵇⴰ ⴰⴷ ⵢⵉⵍⵉ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵉ ⴷ ⴰⵢⵉ ⵜⴻⵏⵏⵉⴷ!” ");
INSERT INTO rift_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","ⴷⴻⴳ ⵡⴰⵙⵙ ⵏⵏⵉ ⵉⴼⴰⵔⵇ ⵉⵡⴻⵜⵎⴰⵏ ⵏ ⵉⵖⴰⵢⴹⴻⵏ ⵉⵛⴰⵔⴹⴻⵏ ⴷ ⵉⵇⴰⵔⵇⴰⵛⴻⵏ ⵓⵍⴰ ⴷ ⵎⴰⵔⵔⴰ ⵜⵉⵖⴰⵢⴹⵜⵉⵏ ⵉⴱⴻⵇⵇⴹⴻⵏ ⴷ ⵉⵇⴰⵔⵇⴰⵛⴻⵏ, ⴷ ⵎⴰⵔⵔⴰ ⵉⵏⵏⵉ ⴷⵉ ⵜⴻⴵⴰ ⵜⴻⵎⵍⴻⵍ, ⵓⵍⴰ ⴷ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⴵⴰⵏ ⴷ ⴰⴱⴰⵔⵛⴰⵏ ⵊⴰⵔ ⵉⵃⵓⵍⵉⵢⵢⴻⵏ, ⵓⵛⴰ ⵉⵙⵙⴰⵔⵙ ⵉ-ⵜⴻⵏ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","ⵅⴻⵏⵏⵉ ⵉⴳⴳⴰ ⵜⵍⴰⵜⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⵏ ⵡⴻⴱⵔⵉⴷ ⵊⴰⵔ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⴷ ⵢⴰⵄⵇⵓⴱ. ⵓⵛⴰ ⵢⴰⵔⵡⴻⵙ ⵢⴰⵄⵇⵓⴱ ⵓⴵⵉ ⵉⵇⵇⵉⵎⴻⵏ ⵏ ⵍⴰⴱⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","ⵅⴻⵏⵏⵉ ⵉⴽⵙⵉ ⵢⴰⵄⵇⵓⴱ ⵜⵉⵙⴻⴹⵡⵉⵏ ⵏ ⵚⵚⴻⴼⵚⴰⴼ ⵓ ⵣⵉ ⵜⵛⴻⵊⵊⴰⵔⵜ ⵏ ⴵⵓⵣ ⵓ ⵣⵉ ⵜⵛⴻⵊⵊⴰⵔⵜ ⵏ ⴷⵓⵍⴱ. ⵏⴻⵜⵜⴰ ⵉⵇⴻⵛⵛⴰⵔ ⵉ-ⵜⴻⵏⵜ ⴷ ⵉⵛⴻⵟⵟⵉⴹⴻⵏ ⴷ ⵉⵛⴻⵎⵍⴰⵍⴻⵏ ⵓⵎⵉ ⵉⵄⴰⵔⵔⴰ ⵅ ⵓⵛⴻⵎⵍⴰⵍ ⵏ ⵜⵙⴻⴹⵡⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","ⵉⵙⵙⴰⵔⵙ ⵜⵉⵙⴻⴹⵡⵉⵏ-ⴰ ⵉⵇⴻⵛⵛⴰⵔⴻⵏ ⵇⵉⴱⴰⵍⵜ ⵉ ⵡⵓⴵⵉ ⴷⵉ ⵜⴰⵔⵢⵉⵡⵉⵏ ⴷ ⵍⴻⵇⵡⴰⵔⴻⴱ ⵎⴰⵏⵉ ⴷⴷ-ⵓⵙⵉⵏ ⵡⵓⴵⵉ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵙⵡⴻⵏⵜ ⵓⵛⴰ ⴷⴻⵡⵍⴻⵏⵜ ⵜⵜⵡⴻⵃⵃⴰⵎⴻⵏⵜ ⵅⵎⵉ ⴷⴷ-ⵜⴰⵙⴻⵏⵜ ⴰⴷ ⵡⴰⵔⴷⴻⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","ⵅⵎⵉ ⵉ ⵖⴰ ⵉⵡⴻⵃⵃⴻⵎ ⵡⵓⴵⵉ ⵖⴰⵔ ⵜⵙⴻⴹⵡⵉⵏ, ⵓⵔⵡⴻⵏⵜ-ⵉ-ⴷⴷ ⵜⵖⴰⵔⵟⵉⵏ ⵎⵉⵏ ⵉⵛⴰⵔⴹⴻⵏ ⴷ ⵎⵉⵏ ⵉⴱⴻⵇⵇⴹⴻⵏ ⴷ ⵎⵉⵏ ⵉⵇⴰⵔⵇⴰⵛⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","ⵅⴻⵏⵏⵉ ⵜⵓⵖⴰ ⵉⴱⴻⵟⵟⴰ ⵢⴰⵄⵇⵓⴱ ⵉⵃⵓⵍⵉⵢⵢⴻⵏ ⵓⵛⴰ ⵢⴰⵔⵔⴰ ⵓⴵⵉ ⵙ ⵓⵣⴻⴵⵉⴼ ⵏⵙⴻⵏ ⵖⴰⵔ ⵎⵉⵏ ⵉⵛⴰⵔⴹⴻⵏ ⴷ ⵎⵉⵏ ⵉⴵⴰⵏ ⴷ ⴰⴱⴰⵔⵛⴰⵏ ⵊⴰⵔ ⵡⵓⴵⵉ ⵏ ⵍⴰⴱⴰⵏ. ⵓⵛⴰ ⵉⴳⴳⴰ ⵜⵉⵃⵉⵎⵔⵉⵡⵉⵏ ⵏⵏⴻⵙ ⵖⴰⵔ ⵓⵖⴻⵣⴷⵉⵙ, ⵡⴰⵔ ⵜⴻⵏⵜ ⵉⴳⴳⵉ ⴰⴽ-ⴷ ⵡⵓⴵⵉ ⵏ ⵍⴰⴱⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","ⴽⵓⵍ ⴰⵎⵓⵍ ⵅⵎⵉ ⵜⵜⵡⴻⵃⵃⴰⵎⴻⵏⵜ ⵜⵉⵏⵏⵉ ⵉⵊⴻⵀⴷⴻⵏ ⵣⴻⴳ ⵡⵓⴵⵉ, ⵉⵜⵜⴻⴳⴳ ⵢⴰⵄⵇⵓⴱ ⵜⵉⵙⴻⴹⵡⵉⵏ ⵇⵉⴱⴰⵍⵜ ⵉ ⵡⵓⴵⵉ ⴷⵉ ⵜⴰⵔⵢⵉⵡⵉⵏ, ⵃⵉⵎⴰ ⴰⴷ ⵡⴻⵃⵃⵎⴻⵏⵜ ⵖⴰⵔ ⵜⵙⴻⴹⵡⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","ⵎⴰⵛⴰ ⵡⴰⵔ ⵜⴻⵏⵜ ⵉⵙⵙⴰⵔⵙ ⵛⴰ ⴰⴽ-ⴷ ⵜⴻⵏⵏⵉ ⵉⴹⴻⵄⴼⴻⵏ ⵊⴰⵔ ⵡⵓⴵⵉ. ⴰⵎⵎⵓ ⵜⵓⵖⴰ ⵜⵉⵏⵏⵉ ⵉⴹⴻⵄⴼⴻⵏ ⵉ ⵍⴰⴱⴰⵏ ⵓ ⵜⵉⵏⵏⵉ ⵉⵊⴻⵀⴷⴻⵏ ⵉ ⵢⴰⵄⵇⵓⴱ. ");
INSERT INTO rift_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","ⵓⵛⴰ ⵉⵎⵖⴰⵔ ⵡⴰⴳⵍⴰ ⵏ ⵡⴻⵔⵢⴰⵣ-ⴰ ⴱⵍⴰ ⵇⴻⵟⵟⵓ. ⵜⵓⵖⴰ ⵖⴰⵔⴻⵙ ⴰⵟⵟⴰⵙ ⵏ ⵡⵓⴵⵉ ⴷ ⵜⵉⵢⵢⴰ ⴷ ⵉⵙⴻⵎⵖⴰⵏ ⴷ ⵉⵍⴻⵖⵎⴰⵏ ⴷ ⵢⴻⵖⵢⴰⵍ. ");
INSERT INTO rift_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","ⵓⵛⴰ ⵉⵙⵍⴰ ⵢⴰⵄⵇⵓⴱ ⴰⵡⴰⵍⴻⵏ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵍⴰⴱⴰⵏ, ⵏⵏⴰⵏ: “ⵢⴰⵄⵇⵓⴱ ⵉⴽⵙⵉ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵜⵓⵖⴰ ⵏ ⴱⴰⴱⴰⵜⵏⴻⵖ ⵓ ⵙ ⵎⵉⵏ ⵜⵓⵖⴰ ⵏ ⴱⴰⴱⴰⵜⵏⴻⵖ ⴰⵇⴰ ⵉⴽⵙⴻⴱ ⵎⴰⵔⵔⴰ ⴰⵄⵓⴵⵉ-ⵢⴰ.” ");
INSERT INTO rift_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","ⵉⵅⵣⴰⵔ ⵢⴰⵄⵇⵓⴱ ⵖⴰⵔ ⵓⵖⴻⵎⴱⵓⴱ ⵏ ⵍⴰⴱⴰⵏ. ⵅⵣⴰⵔ, ⵡⴰⵔ ⴽⵉⴷⴻⵙ ⵉⴵⵉ ⴰⵎ ⵉⴹⴻⵏⵏⴰⴹ ⴷ ⴼⴰⵔⵉⴹⴻⵏⵏⴰⴹ. ");
INSERT INTO rift_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵢⴰⵄⵇⵓⴱ: “ⴷⵡⴻⵍ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵍⴻⵊⴷⵓⴷ ⵏⵏⴻⵛ ⵓ ⵖⴰⵔ ⵍⴰⴵ ⵏⵏⴻⵛ. ⴰⵇⴰ ⵏⴻⵛⵛ ⴰⴷ ⵉⵍⵉⵖ ⴰⴽⵉⴷⴻⴽ.” ");
INSERT INTO rift_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","ⵉⵙⴻⴽⴽ ⵢⴰⵄⵇⵓⴱ ⵓⵛⴰ ⵉⵍⴰⵖⴰ-ⴷⴷ ⵅ ⵔⴰⵃⵉⵍ ⴷ ⵍⵉⵢⴰ ⵖⴰⵔ ⵢⴻⵢⵢⴰⵔ, ⵖⴰⵔ ⵡⵓⴵⵉ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","ⵉⵏⵏⴰ ⴰⵙⴻⵏⵜ: “ⵜⵜⵡⴰⵍⵉⵖ ⴱⴻⵍⵍⵉ ⴰⵖⴻⵎⴱⵓⴱ ⵏ ⴱⴰⴱⴰⵜⴽⴻⵏⵜ ⵡⴰⵔ ⴽⵉⴷⵉ ⵉⴵⵉ ⴰⵎ ⵉⴹⴻⵏⵏⴰⴹ ⴷ ⴼⴰⵔⵉⴹⴻⵏⵏⴰⴹ. ⵎⴰⵛⴰ ⴰⵔⴻⴱⴱⵉ ⵏ ⵍⴻⵊⴷⵓⴷ ⵉⵏⵓ ⴰⵇⴰ-ⵜ ⴰⴽⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","ⴽⴻⵏⵏⵉⵏⵜ ⵜⴻⵙⵙⵏⴻⵏⵜ ⴱⴻⵍⵍⵉ ⴰⵇⴰ ⵅⴻⴷⵎⴻⵖ ⵉ ⴱⴰⴱⴰⵜⴽⴻⵏⵜ ⵙ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵖⴰⵔⵉ ⴷ ⵊⵊⴻⵀⴷ. ");
INSERT INTO rift_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","ⵎⴰⵛⴰ ⴱⴰⴱⴰⵜⴽⴻⵏⵜ ⵉⵖⴻⵛⵛ ⴰⵢⵉ, ⵉⴱⴻⴷⴷⴻⵍ ⵍⵎⵓⵏⴻⵜ ⵉⵏⵓ ⵄⴻⵛⵔⴰ ⵏ ⵜⵡⴰⵍⴰⵡⵉⵏ, ⵎⴰⵛⴰ ⴰⵔⴻⴱⴱⵉ ⵡⴰⵔ ⴷ ⴰⵙ ⵉⵙⴻⵎⵎⴻⵃ ⵃⵉⵎⴰ ⴰⴷ ⴰⵢⵉ ⵉⴳⴳ ⵍⵖⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","ⵎⴰⵍⴰ ⵏⴻⵜⵜⴰ ⵉⵏⵏⴰ: ‘ⵉⴱⴻⵇⵇⵉⴹⴻⵏ ⴰⴷ ⵉⵍⵉⵏ ⴷ ⵍⵎⵓⵏⴻⵜ ⵏⵏⴻⵛ!’, ⵍⴻⵅⴷⴻⵏⵏⵉ ⵎⴰⵔⵔⴰ ⵓⴵⵉ ⵓⵔⵡⴻⵏⵜ-ⵉ-ⴷⴷ ⵓⴵⵉ ⵙ ⵉⴱⴻⵇⵇⵉⴹⴻⵏ, ⵎⴰⵍⴰ ⵉⵏⵏⴰ: ‘ⵉⵏⵏⵉ ⵙ ⵉⵛⴰⵔⵉⴹⴻⵏ ⴰⴷ ⵉⵍⵉⵏ ⴷ ⵍⵎⵓⵏⴻⵜ ⵏⵏⴻⵛ!’, ⵍⴻⵅⴷⴻⵏⵏⵉ ⵎⴰⵔⵔⴰ ⵓⴵⵉ ⵓⵔⵡⴻⵏⵜ-ⵉ-ⴷⴷ ⵓⴵⵉ ⵙ ⵉⵛⴰⵔⵉⴹⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","ⴰⵎⵎⵓ ⵉⴽⴽⴻⵙ ⴰⵔⴻⴱⴱⵉ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏ ⴱⴰⴱⴰⵜⴽⴻⵏⵜ ⵓⵛⴰ ⵉⵡⵛⴰ ⴰⵢⵉ ⵜⴻⵏⵜ ⵉ ⵏⴻⵛⵛ. ");
INSERT INTO rift_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","ⵉⵎⵙⴰⵔ ⵖⴰⵔ ⵍⵡⴻⵇⵜ ⵓⵎⵉ ⵡⴻⵃⵃⵎⴻⵏⵜ ⵓⴵⵉ, ⵙⵙⴳⴻⵄⵄⴷⴻⵖ ⵜⴰⵎⵓⵖⵍⵉ ⵉⵏⵓ ⵓⵛⴰ ⵥⵔⵉⵖ ⴷⵉ ⵜⴰⵔⵊⵉⵜ, ⴰⵇⴰ ⴷⴰ ⵉⵖⴰⵢⴹⴻⵏ ⵏⵏⵉ ⵉⵏⴻⴳⴳⵣⴻⵏ ⵅ ⵡⵓⴵⵉ, ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⵙ ⵉⵛⴰⵔⵉⴹⴻⵏ ⴷ ⵉⴱⴻⵇⵇⵉⴹⴻⵏ ⴷ ⵉⵇⴰⵔⵇⴰⵛⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","ⵉⵏⵏⴰ ⴰⵢⵉ ⵍⵎⴰⵍⴰⴽ ⵏ ⴰⵔⴻⴱⴱⵉ ⴷⵉ ⵜⴰⵔⵊⵉⵜ ‘ⵢⴰⵄⵇⵓⴱ!’ ⵏⴻⵛⵛ ⵏⵏⵉⵖ ‘ⴰⵇⴰ ⴰⵢⵉ ⴷⴰ!’ ");
INSERT INTO rift_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","ⵉⵏⵏⴰ: ‘ⵏⴹⴰⵔ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵛ, ⵅⵣⴰⵔ, ⵎⴰⵔⵔⴰ ⵉⵖⴰⵢⴹⴻⵏ, ⵉⵏⵏⵉ ⵉⵏⴻⴳⴳⵣⴻⵏ ⵅ ⵡⵓⴵⵉ, ⴰⵇⴰ ⴰⵜⴻⵏ ⵙ ⵉⵛⴰⵔⵉⴹⴻⵏ ⴷ ⵉⴱⴻⵇⵇⵉⴹⴻⵏ ⴷ ⵉⵇⴰⵔⵇⴰⵛⴻⵏ, ⵎⵉⵏⵣⵉ ⵏⴻⵛⵛ ⵥⵔⵉⵖ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴷ ⴰⵛ ⵉⵜⵜⴻⴳⴳ ⵍⴰⴱⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","ⵏⴻⵛⵛ ⴷ ⴰⵔⴻⴱⴱⵉ ⵏ ⴱⴰⵢⵜ-ⵉⵍ, ⵎⴰⵏⵉ ⵜⴷⴻⵀⵏⴻⴷ ⴰⵥⵔⵓ ⵏ ⵍⵉⴷⴰⵔⴻⵜ ⵓ ⵎⴰⵏⵉ ⴷ ⴰⵢⵉ ⵜⴻⵡⵛⵉⴷ ⴰⵡⴰⵍ. ⴽⴽⴰⵔ ⵍⴻⵅⵅⵓ, ⴼⴼⴻⵖ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ-ⴰ, ⵄⵇⴻⴱ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵎⴰⵏⵉ ⵜⵅⴻⵍⵇⴻⴷ.’” ");
INSERT INTO rift_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","ⵅⴻⵏⵏⵉ ⴰⵔⵔⵉⵏⵜ-ⵉ-ⴷⴷ ⵔⴰⵃⵉⵍ ⴷ ⵍⵉⵢⴰ, ⵏⵏⴰⵏⵜ ⴰⵙ: “ⵎⴰ ⴷⵉⵏ ⵄⴰⴷ ⵛⴰ ⵏ ⵜⴻⵙⵖⴰⵔⵜ ⵏⵉⵖ ⵉⵛⵜ ⵏ ⵍⵡⴰⵔⵜ ⵉ ⵏⴻⵛⵛⵉⵏ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⴱⴰⴱⴰⵜⵏⴻⵖ? ");
INSERT INTO rift_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","ⵎⴰ ⵡⴰⵔ ⵏⴻⵜⵜⵡⵉⵃⵙⵉⴱ ⴰⵎ ⵜⴱⴰⵔⵔⴰⵏⵉⵢⵢⵉⵏ? ⴰⵇⴰ ⵏⴻⵜⵜⴰ ⵉⵣⵣⴻⵏⵣ ⴰⵏⴻⵖ ⵓ ⵏⴻⵜⵜⴰ ⴰⵇⴰ ⵉⵇⴻⵟⵟⴰ ⵎⴰⵔⵔⴰ ⵏⵏⵓⵇⴰⵔⵜ ⵏⵏⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","ⵎⵉⵏⵣⵉ ⵎⴰⵔⵔⴰ ⴰⴳⵍⴰ ⵏⵏⵉ ⵉⴽⴽⴻⵙ ⴰⵔⴻⴱⴱⵉ ⵉ ⴱⴰⴱⴰⵜⵏⴻⵖ, ⵏⵏⴻⵖ ⵉ ⵉⴵⴰ ⵓ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵖ. ⵍⴻⵅⵅⵓ ⵄⴰⴷ, ⴻⴳⴳ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴷ ⴰⵛ ⵉⵏⵏⴰ ⴰⵔⴻⴱⴱⵉ.” ");
INSERT INTO rift_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","ⵅⴻⵏⵏⵉ ⵉⴽⴽⴰⵔ ⵢⴰⵄⵇⵓⴱ ⵓⵛⴰ ⵉⵙⵙⴳⴻⵄⵄⴻⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ ⴷ ⵜⴻⵎⵖⴰⵔⵉⵏ ⵏⵏⴻⵙ ⵅ ⵉⵍⴻⵖⵎⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","ⵉⴳⴳⴰ ⴷⴻⴳ ⵡⴻⴱⵔⵉⴷ ⵎⴰⵔⵔⴰ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏⵏⴻⵙ ⴷ ⵎⴰⵔⵔⴰ ⴰⴳⵍⴰ ⵏⵏⴻⵙ ⵏⵏⵉ ⴷⴷ-ⵉⴽⵙⴻⴱ, ⴰⵇⴰ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏⵏⵉ ⵉⵟⵟⴻⴼ, ⵉⵏⵏⵉ ⴷⴷ-ⵉⴽⵙⴻⴱ ⴷⵉ ⴼⴰⴷⴰⵏ-ⴰⵔⴰⵎ, ⵃⵉⵎⴰ ⴰⴷ ⴷⴷ-ⵉⵄⵇⴻⴱ ⵖⴰⵔ ⵉⵙⵃⴰⵇ, ⴱⴰⴱⴰⵙ, ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","ⵓⵎⵉ ⵉⵔⵓⵃ ⵍⴰⴱⴰⵏ ⵖⴰⵔ ⵜⵉⵍⵙⴰ ⵏ ⵡⵓⴵⵉ ⵏⵏⴻⵙ, ⵜⵓⵛⴰⵔ ⵔⴰⵃⵉⵍ ⵍⴻⵅⵢⴰⵍⴰⵜ ⵜⵉⵎⴻⵥⵢⴰⵏⵉⵏ ⵏ ⵍ’ⴰⵚⵏⴰⵎ ⵏ ⴱⴰⴱⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","ⵢⴰⵄⵇⵓⴱ ⵉⵅⴷⴻⵄ ⵍⴰⴱⴰⵏ, ⴰⵔⴰⵎⵉⵢⵓ, ⵍⴰⵎⵉ ⵡⴰⵔ ⴷ ⴰⵙ ⵉⵄⵍⵉⵎ ⴰⵇⴰ ⴰⴷ ⵢⴰⵔⵡⴻⵍ. ");
INSERT INTO rift_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","ⵢⴰⵔⵡⴻⵍ ⵙ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵖⴰⵔⴻⵙ. ⵉⴽⴽⴰⵔ, ⵉⵥⵡⴰ ⵉⵖⵣⴰⵔ ⵏ ⵍⴼⵓⵔⴰⵟ ⵓⵛⴰ ⵢⴰⵔⵔⴰ ⴰⵣⴻⴵⵉⴼ ⵏⵏⴻⵙ ⵖⴰⵔ ⵉⴷⵓⵔⴰⵔ ⵏ ⵊⵉⵍⵄⴰⴷ. ");
INSERT INTO rift_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵜⵍⴰⵜⴰ ⵅⴻⴱⴱⴰⵔⴻⵏ ⵍⴰⴱⴰⵏ, ⴰⵇⴰ ⵢⴰⵔⵡⴻⵍ ⵢⴰⵄⵇⵓⴱ. ");
INSERT INTO rift_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","ⵅⴻⵏⵏⵉ ⵢⵉⵡⵉ ⴰⵢⵜⵎⴰⵙ ⴰⴽⵉⴷⴻⵙ, ⵉⵔⵓⵃ ⴰⵡⴰⵔⵏⵉ ⴰⵙ ⵜⵉⵛⵍⵉ ⵏ ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ, ⵉⵅⴻⵛⵛ ⵅⴰⵙ ⴷⴻⴳ ⵉⴷⵓⵔⴰⵔ ⵏ ⵊⵉⵍⵄⴰⴷ. ");
INSERT INTO rift_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","ⵓⵛⴰ ⵢⵓⵙⴰ-ⴷⴷ ⴰⵔⴻⴱⴱⵉ ⵖⴰⵔ ⵍⴰⴱⴰⵏ, ⴰⵔⴰⵎⵉⵢⵓ, ⴷⵉ ⵜⴰⵔⵊⵉⵜ ⴷⵉ ⴵⵉⵔⴻⵜ, ⵉⵏⵏⴰ ⴰⵙ: “ⵖⴰⵔⴻⴽ ⴰⴷ ⵜⴻⵙⵙⵉⵡⵍⴻⴷ ⵙ ⵍⵅⴰⵔ ⵏⵉⵖ ⵙ ⵍⵖⴰⵔ ⴰⴽ-ⴷ ⵢⴰⵄⵇⵓⴱ.” ");
INSERT INTO rift_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","ⵉⵔⴻⵃⵃⴻⴳ ⵅⴻⵏⵏⵉ ⵍⴰⴱⴰⵏ ⵅ ⵢⴰⵄⵇⵓⴱ. ⵢⴰⵄⵇⵓⴱ ⵜⵓⵖⴰ ⵉⵡⵜⴰ ⴰⵇⵉⴹⵓⵏ ⵏⵏⴻⵙ ⴷⴻⴳ ⵉⴷⵓⵔⴰⵔ. ⵍⴰⴱⴰⵏ ⵄⴰⵡⴻⴷ ⵉⵡⵜⴰ ⵉⵇⵉⴹⴰⵏ ⵏⵏⴻⵙ ⴰⴽ-ⴷ ⴰⵢⵜⵎⴰⵙ ⴷⴻⴳ ⵉⴷⵓⵔⴰⵔ ⵏ ⵊⵉⵍⵄⴰⴷ. ");
INSERT INTO rift_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵍⴰⴱⴰⵏ ⵉ ⵢⴰⵄⵇⵓⴱ: “ⵎⵉⵏ ⵜⴻⴳⴳⵉⴷ, ⵜⴻⵥⵡⵉⴷ ⴰⵢⵉ ⵓⵍ ⵓⵛⴰ ⵜⵉⵡⵢⵉⴷ-ⴷⴷ ⵢⴻⵙⵙⵉ ⴰⵎ ⵜⵎⴻⵃⴱⴰⵙ ⵏ ⴳⴰⵔⵔⴰ? ");
INSERT INTO rift_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","ⵎⴰⵢⴻⵎⵎⵉ ⵜⴰⵔⴻⵡⵍⴻⴷ ⵙ ⵜⵏⵓⴼⴼⵔⴰ ⵓ ⵜⵓⵛⴰⵔⴻⴷ ⴰⵢⵉ ⵓ ⵎⴰⵢⴻⵎⵎⵉ ⵡⴰⵔ ⴷ ⴰⵢⵉ ⵜⵅⴻⴱⴱⴰⵔⴻⴷ, ⵃⵉⵎⴰ ⴰⴷ ⵛⴻⴽ ⵙⵙⵇⴻⴱⴱⴹⴻⵖ ⵙ ⵍⴻⴼⵔⴰⵃⴻⵜ, ⵙ ⵍⴻⵖⵏⵓⵊ, ⵙ ⵓⴱⴻⵏⴷⵉⵔ ⵓ ⵙ ⵍⴳⴰⵎⴱⵔⵉ? ");
INSERT INTO rift_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","ⵡⴰⵔ ⴷ ⴰⵢⵉ ⵜⴻⵊⵊⵉⴷ ⴰⴷ ⵙⵙⵓⴷⵎⴻⵖ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵉⵏⵓ ⴷ ⵜⵃⴻⵏⵊⵉⵔⵉⵏ ⵉⵏⵓ. ⵍⴻⵅⵅⵓ ⴷ ⵜⵓⴱⴱⵓⵀⴻⵍⵢⴰ ⵉ ⵜⴻⴳⴳⵉⴷ. ");
INSERT INTO rift_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","ⵖⴰⵔⵉ ⵜⵉⵣⴻⵎⵎⴰⵔ ⴷⴻⴳ ⵉⴼⴰⵙⵙⴻⵏ ⵉⵏⵓ, ⵃⵉⵎⴰ ⴰⴷ ⵛⴻⴽ ⴹⴰⵔⵔⴻⵖ, ⵎⴰⵛⴰ ⴰⵔⴻⴱⴱⵉ ⵏ ⴱⴰⴱⴰⵜⵡⴻⵎ ⵉⵙⵙⵉⵡⴻⵍ ⴰⴽⵉⴷⵉ ⴵⵉⵔⴻⵜ-ⴰ, ⵉⵏⵏⴰ: ‘ⵖⴰⵔⴻⴽ ⴰⴷ ⵜⴻⵙⵙⵉⵡⵍⴻⴷ ⵙ ⵍⵅⴰⵔ ⵏⵉⵖ ⵙ ⵍⵖⴰⵔ ⴰⴽ-ⴷ ⵢⴰⵄⵇⵓⴱ.’ ");
INSERT INTO rift_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","ⵓⵛⴰ ⵍⴻⵅⵅⵓ ⵜⵓⵢⵓⵔⴻⴷ, ⵓⵎⵉ ⵣⴻⵄⵎⴰ ⵜⵡⴻⵃⵃⵛⴻⴷ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⴱⴰⴱⴰⵛ. ⵎⴰⵛⴰ ⵎⴰⵖⴰⵔ ⵉ ⴷ ⴰⵢⵉ ⵜⵓⵛⴰⵔⴻⴷ ⵉⵔⴻⴱⴱⵉⵜⴻⵏ ⵉⵏⵓ?” ");
INSERT INTO rift_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","ⵢⴰⵔⵔⴰ-ⴷⴷ ⵢⴰⵄⵇⵓⴱ, ⵉⵏⵏⴰ ⵉ ⵍⴰⴱⴰⵏ: “ⵎⵉⵏⵣⵉ ⵜⵓⵖⴰ ⴳⴳⵯⴻⴷⴻⵖ, ⵏⵏⵉⵖ ⴰⴽ-ⴷ ⵢⵉⵅⴻⴼ ⵉⵏⵓ ⴰⴷ ⵜⴰⵖ ⴰⴷ ⴰⵢⵉ ⵜⴻⴽⴽⵙⴻⴷ ⵢⴻⵙⵙⵉⵛ ⵙ ⵓⵖⵉⵍ! ");
INSERT INTO rift_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","ⵖⴰⵔ ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵜⴰⴼⴻⴷ ⵍ’ⴰⵚⵏⴰⵎ ⵏⵏⴻⵛ, ⴻⵊⵊ ⵉ-ⵜ ⵡⴰⵔ ⵉⴷⴷⴰⵔ ⵄⴰⴷ! ⵇⵉⴱⴰⵍⵜ ⵉ ⵡⴰⵡⵎⴰⵜⴻⵏ ⵏⵏⴻⵖ ⴰⴷ ⵜⵎⴻⵢⵢⵣⴻⴷ ⵎⵉⵏ ⵉⴵⴰⵏ ⵏⵏⴻⵛ ⵊⴰⵔ ⵎⵉⵏ ⵉⴵⴰⵏ ⵖⴰⵔⵉ ⵓⵛⴰ ⴰⵡⵢⵉ ⵜ ⴰⴽⵉⴷⴻⴽ.” ⵎⴰⵖⴰⵔ ⵢⴰⵄⵇⵓⴱ ⵡⴰⵔ ⵉⵙⵙⵉⵏ ⴱⴻⵍⵍⵉ ⵔⴰⵃⵉⵍ ⵉ ⵜⴻⵏ ⵢⵓⵛⴰⵔⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","ⵓⵛⴰ ⵢⵓⴷⴻⴼ ⵍⴰⴱⴰⵏ ⵖⴰⵔ ⵓⵇⵉⴹⵓⵏ ⵏ ⵢⴰⵄⵇⵓⴱ, ⵖⴰⵔ ⵓⵇⵉⴹⵓⵏ ⵏ ⵍⵉⵢⴰ, ⵖⴰⵔ ⵓⵇⵉⴹⵓⵏ ⵏ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵉⵢⵢⴰ ⵓⵛⴰ ⵡⴰⵔ ⵢⵓⴼⵉ ⵡⴰⵍⵓ. ⵍⴰⵎⵉ ⴷⴷ-ⵉⴼⴼⴻⵖ ⵣⴻⴳ ⵓⵇⵉⴹⵓⵏ ⵏ ⵍⵉⵢⴰ, ⵢⵓⴷⴻⴼ ⵖⴰⵔ ⵓⵇⵉⴹⵓⵏ ⵏ ⵔⴰⵃⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","ⵎⴰⵛⴰ ⵜⴻⴽⵙⵉ ⵔⴰⵃⵉⵍ ⵍⴻⵅⵢⴰⵍⴰⵜ ⵜⵉⵎⴻⵥⵢⴰⵏⵉⵏ ⵏ ⵍ’ⴰⵚⵏⴰⵎ, ⵜⴻⴳⴳⴰ ⵉ-ⵜⴻⵏⵜ ⴷⴻⴳ ⵉⵖⴰⵢⵏⴻⵏ ⵏ ⵡⴻⵍⵖⴻⵎ ⵓⵛⴰ ⵜⴻⵇⵇⵉⵎ ⵅⴰⵙⴻⵏ. ⵢⴰⵔⵣⵓ ⵍⴰⴱⴰⵏ ⴷⴻⴳ ⵓⵇⵉⴹⵓⵏ ⴰⵎ ⵉⴽⵎⴻⵍ, ⵎⴰⵛⴰ ⵡⴰⵔ ⵢⵓⴼⵉ ⵡⴰⵍⵓ. ");
INSERT INTO rift_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","ⵜⴻⵏⵏⴰ ⵉ ⴱⴰⴱⴰⵙ: “ⵡⴰⵔ ⵉⵜⵜⵉⵍⵉ ⴰⵢⴰ ⴷ ⵍⵖⴰⵔ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵙⵉⴷⵉ ⵉⵏⵓ, ⵎⵉⵏⵣⵉ ⵡⴰⵔ ⵣⴻⵎⵎⴰⵔⴻⵖ ⴰⴷ ⴽⴽⴰⵔⴻⵖ ⵇⵉⴱⴰⵍⵜ ⵏⵏⴻⵛ, ⵎⴰⵖⴰⵔ ⴰⵇⴰ ⴰⵢⵉ ⵙ ⵜⵏⴰⵎⵉⵜ ⵏ ⵜⴻⵎⵖⴰⵔⵉⵏ.” ⵓⵛⴰ ⵢⴰⵔⵣⵓ, ⵎⴰⵛⴰ ⵡⴰⵔ ⵢⵓⴼⵉ ⵍⴻⵅⵢⴰⵍⴰⵜ ⵜⵉⵎⴻⵥⵢⴰⵏⵉⵏ ⵏ ⵍ’ⴰⵚⵏⴰⵎ. ");
INSERT INTO rift_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","ⵅⴻⵏⵏⵉ ⵉⵅⴻⵢⵢⴻⵇ ⵢⴰⵄⵇⵓⴱ ⵓⵛⴰ ⵉⵎⵛⵓⴱⴱⴻⵛ ⴰⴽ-ⴷ ⵍⴰⴱⴰⵏ. ⵢⴰⵄⵇⵓⴱ ⵉⵟⵟⴻⴼ ⴷⴻⴳ ⵡⴰⵡⴰⵍ, ⵉⵏⵏⴰ ⵉ ⵍⴰⴱⴰⵏ: “ⵎⴰⵏⵉ ⵉⴵⴰ ⵓⵅⴻⵟⵟⵓ ⵉⵏⵓ? ⵎⴰⵏ ⵡⴻⵏ ⵉⴵⴰⵏ ⴷ ⴷⴷⴻⵏⴱ ⵉⵏⵓ, ⵓⵎⵉ ⴷ ⴰⵢⵉ ⴷⴷ-ⵜⴻⴹⴼⴰⵔⴻⴷ ⵙ ⵣⵣⵄⴰⴼ? ");
INSERT INTO rift_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","ⵛⴻⴽ ⵜⴱⴻⵇⵛⴻⴷ ⵎⴰⵔⵔⴰ ⵍⵇⴻⵛⵛ ⵉⵏⵓ. ⵎⵉⵏ ⵜⵓⴼⵉⴷ ⵣⵉ ⵎⴰⵔⵔⴰ ⵍⴻⵃⵡⴰⵢⴻⵊ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⴻⵛ? ⴻⴳⴳ ⵉ-ⵜ ⴷⴰ ⵣⵣⴰⵜ ⵏ ⵢⴰⵢⵜⵎⴰ ⴷ ⴰⵢⵜⵎⴰⵛ ⵓⵛⴰ ⴻⵊⵊ ⵉ-ⵜⴻⵏ ⴰⴷ ⵃⴻⴽⵎⴻⵏ ⵊⴰⵔ ⴰⵏⴻⵖ ⵙ ⵜⵏⴰⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","ⵄⵉⵛⵔⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵉ ⴽⵉⴽ ⴽⴽⵉⵖ. ⵜⵉⵅⴻⵙⵡⵉⵏ ⵏⵏⴻⵛ ⴷ ⵜⵖⴰⵢⴹⵉⵏ ⵏⵏⴻⵛ ⵄⴻⵎⵎⴰⵔⵚ ⵙⵙⵓⵜⵎⴻⵏⵜ ⵏⵉⵖ ⵄⴻⵎⵎⴰⵔⵚ ⵛⵛⵉⵖ ⵉⵛⴰⵔⵔⵉⵢⴻⵏ ⵏ ⵡⵓⴵⵉ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","ⵡⴰⵔ ⴷ ⴰⵛ ⵉⵡⵢⴻⵖ ⵎⵉⵏ ⵉⵜⵜⵡⴰⵎⴻⵣⵣⵇⴻⵏ, ⵎⴰⵛⴰ ⵅⴻⵟⵚⴻⵖ ⵜ ⵙⵉⵎⴰⵏⵜ ⵉⵏⵓ. ⵎⵉⵏ ⵉⵜⵜⵡⴰⵛⴰⵔⴻⵏ ⵣⵣⴰⵢⵉ ⴷⴻⴳ ⵡⴰⵙⵙ ⵏⵉⵖ ⴷⵉ ⴵⵉⵔⴻⵜ, ⴰⵇⴰ ⵣⴻⴳ ⵉⴼⴰⵙⵙⴻⵏ ⵉⵏⵓ ⵜᵉⵜⵜⴰⵔⴻⴷ ⵜ. ");
INSERT INTO rift_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","ⵙ ⵓⵣⵉⵍ ⵉⵜⵜⴻⵜⵜ ⴰⵢⵉ ⵍⴻⵃⵎⵓ ⵢⵓⵥⵖⴻⵏ ⵜⵉⵍⵎⴻⵛⵜ ⵓ ⵙ ⴵⵉⵔⴻⵜ ⵜⵜⴻⵊⵎⵉⴷⴻⵖ ⵣⵉ ⵙⵇⵉⵄ, ⴰⵍⴰⵎⵉ ⵢⴰⵔⵡⴻⵍ ⵉⴹⴻⵚ ⵣⵉ ⵖⴰⵔⵉ. ");
INSERT INTO rift_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","ⴰⵎⵎⵓ ⵉ ⴷ ⴰⵢⵉ ⵜⵓⵖⴰ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⴻⵛ ⵄⵉⵛⵔⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ. ⵅⴻⴷⵎⴻⵖ ⵖⴰⵔⴻⴽ ⴰⵔⴱⴻⵄⵟⴰⵛ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵅ ⵜⵏⴰⵢⴻⵏ ⵏ ⵢⴻⵙⵙⵉⵛ ⴷ ⵙⴻⵜⵜⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵅ ⵡⵓⴵⵉ ⵓⵛⴰ ⵜⴱⴻⴷⴷⵍⴻⴷ ⵍⵎⵓⵏⴻⵜ ⵉⵏⵓ ⵄⴻⵛⵔⴰ ⵏ ⵜⵡⴰⵍⴰⵡⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","ⵎⴰⵍⴰ ⴰⵔⴻⴱⴱⵉ ⵏ ⴱⴰⴱⴰ, ⴰⵔⴻⴱⴱⵉ ⵏ ⵉⴱⵔⴰⵀⵉⵎ ⴷ ⵜⵉⴳⴳⵯⵓⴷⵉ ⵏ ⵉⵙⵃⴰⵇ, ⵉⵍⵉ ⵡⴰⵔ ⴽⵉⴷⵉ ⵉⴵⵉ, ⴷ ⵚⵚⴻⵃ ⵉⵍⵉ ⴰⴷ ⴰⵢⵉ ⵜⴻⵙⵙⵇⴰⴷⴻⴷ ⵍⴻⵅⵅⵓ ⵙ ⵉⴼⴰⵙⵙⴻⵏ ⵅⵡⴰⵏ! ⵉⵥⵔⴰ ⴰⵔⴻⴱⴱⵉ ⵜⴰⵎⴰⵔⴰ ⴷ ⵜⵓⵎⴰⵔ ⵏ ⵉⴼⴰⵙⵙⴻⵏ ⵉⵏⵓ ⵓⵛⴰ ⵉⴷⴻⵇⵎⴰⵔ ⵉ ⵛⴻⴽ ⴵⵉⵍⴻⵜ ⵏ ⵉⴹⴻⵏⵏⴰⴹ.” ");
INSERT INTO rift_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","ⵢⴰⵔⵔⴰ-ⴷⴷ ⵍⴰⴱⴰⵏ ⵓⵛⴰ ⵉⵏⵏⴰ ⵉ ⵢⴰⵄⵇⵓⴱ: “ⵜⵉⵃⴻⵏⵊⵉⵔⵉⵏ-ⴰ ⴷ ⵢⴻⵙⵙⵉ ⵓ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ-ⴰ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵉⵏⵓ, ⵓ ⵓⴵⵉ-ⵢⴰ ⴷ ⵓⴵⵉ ⵉⵏⵓ, ⵓ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵜᵉⵜⵜⵡⴰⵍⵉⴷ ⴰⵇⴰ ⵉⵏⵓ. ⵎⵉⵏ ⵣⴻⵎⵎⴰⵔⴻⵖ ⵅⴻⵏⵏⵉ ⴰⴷ ⴳⴳⴻⵖ ⵍⴻⵅⵅⵓ ⵙ ⵢⴻⵙⵙⵉ ⵏⵉⵖ ⵙ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵙⴻⵏⵜ ⵏⵏⵉ ⵓⵔⵡⴻⵏⵜ? ");
INSERT INTO rift_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","ⵖⴰⵡⴻⵔ ⵄⴰⴷ ⵍⴻⵅⵅⵓ, ⴰⴷ ⵏⴻⴳⴳ ⵉⵊⵊ ⵏ ⵍⵄⴰⵀⴷ, ⵏⴻⵛⵛ ⴷ ⵛⴻⴽ, ⴰⴷ ⵢⵉⵍⵉ ⵏⴻⵜⵜⴰ ⴷ ⵛⵛⵀⴰⴷⴻⵜ ⵊⴰⵔ ⴰⵢⵉ ⴷ ⵛⴻⴽ!” ");
INSERT INTO rift_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","ⵓⵛⴰ ⵉⴽⵙⵉ ⵢⴰⵄⵇⵓⴱ ⴰⵥⵔⵓ, ⵉⵙⵙⴳⴻⵄⵄⴻⴷ ⵉ-ⵜ ⴰⵎ ⵡⴻⵥⵔⵓ ⵏ ⵍⵉⴷⴰⵔⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","ⵓⵛⴰ ⵉⵏⵏⴰ ⵢⴰⵄⵇⵓⴱ ⵉ ⵢⴰⵢⵜⵎⴰⵙ: “ⵙⵎⵓⵏⴻⵎ ⵉⵥⵔⴰ!” ⴽⵙⵉⵏ ⵉⵥⵔⴰ ⵓⵛⴰ ⴳⴳⵉⵏ ⵜⴰⵄⵓⵔⵔⵉⵛⵜ ⵓⵛⴰ ⵛⵛⵉⵏ ⴷⵉⵏ ⵅ ⵜⵄⵓⵔⵔⵉⵛⵜ ⵏⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","ⵓⵛⴰ ⵉⴳⴳⴰ ⵍⴰⴱⴰⵏ ⵉ ⵓⵄⵓⵔⵔⵉⵛ ⵏ ⵉⵥⵔⴰ ⵏⵏⵉ ‘ⵊⵉⴳⴰⵔ-ⵙⴰⵀⴰⴷⵓⵜⴰ’, ⵎⴰⵛⴰ ⵢⴰⵄⵇⵓⴱ ⵉⴳⴳⴰ ⴰⵙ ‘ⵊⵉⵍⵄⴰⴷ’. ");
INSERT INTO rift_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵍⴰⴱⴰⵏ: “ⵜⴰⵄⵓⵔⵔⵉⵛⵜ-ⴰ ⴰⴷ ⵜⵉⵍⵉ ⴷ ⵛⵛⵀⴰⴷⴻⵜ ⴰⵙⵙ-ⴰ ⵊⴰⵔ ⴰⵢⵉ ⴷ ⵛⴻⴽ!” ⵅ ⵓⵢⴰ ⵜⴻⴳⴳⴰ ⴰⵙ ⵊⵉⵍⵄⴰⴷ ");
INSERT INTO rift_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","ⴷ ⵎⵉⵚⴼⴰ, ⵎⵉⵏⵣⵉ ⵏⴻⵜⵜⴰ ⵉⵏⵏⴰ: “ⵉⵍⵉ ⵙⵉⴷⵉ ⴰⴷ ⵉⵃⴹⴰ ⵊⴰⵔ ⴰⵢⵉ ⴷ ⵛⴻⴽ, ⵅⵎⵉ ⵖⴰ ⵏⵉⵍⵉ ⴰⵎ ⵏᵉⵏⵓⴼⴼⴰⵔ ⵉⵊⵊⴻⵏ ⵣⴻⴳ ⵡⴻⵏⵏⴻⵖⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","ⵎⴰⵍⴰ ⵜⴻⵙⵙⴻⵃⵇⴰⵔⴻⴷ ⵢⴻⵙⵙⵉ ⵏⵉⵖ ⴰⴷ ⵜⵎⴻⵍⵛⴻⴷ ⵜⵉⵎⵖⴰⵔⵉⵏ ⵏⵏⴻⵖⵏⵉ ⵅ ⵢⴻⵙⵙⵉ, ⴰⵎ ⵡⴰⵔ ⴷⵉⵏ ⵉⴵⵉ ⵃⴻⴷ ⴰⴽⵉⴷⵏⴻⵖ ⵃⵉⵎⴰ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⴰⵛⴻⵀⵀⴰⴷ, ⴰⵇⴰ ⴰⵔⴻⴱⴱⵉ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⴰⵛⴻⵀⵀⴰⴷ ⵊⴰⵔ ⴰⵢⵉ ⴷ ⵛⴻⴽ!” ");
INSERT INTO rift_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","ⵉⵏⵏⴰ ⵄⴰⵡⴻⴷ ⵍⴰⴱⴰⵏ ⵉ ⵢⴰⵄⵇⵓⴱ: “ⵅⵣⴰⵔ, ⵜⴰⵄⵓⵔⵔⵉⵛⵜ-ⴰ ⵏ ⵢⴻⵥⵔⴰ, ⵅⵣⴰⵔ, ⴰⵥⵔⵓ ⵏ ⵍⵉⴷⴰⵔⴻⵜ ⵏⵏⵉ ⵙⵙⴱⴻⴷⴷⴻⵖ ⵊⴰⵔ ⴰⵢⵉ ⴷ ⵛⴻⴽ. ");
INSERT INTO rift_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","ⵜⴰⵄⵓⵔⵔⵉⵛⵜ-ⴰ ⵏ ⵢⴻⵥⵔⴰ ⴷ ⵡⴻⵥⵔⵓ-ⵢⴰ ⵏ ⵍⵉⴷⴰⵔⴻⵜ ⴰⴷ ⵛⴻⵀⴷⴻⵏ ⴱⴻⵍⵍⵉ ⵏⴻⵛⵛ ⵡⴰⵔ ⵖⴰⵔⴻⴽ ⴷⴷ-ⵥⴻⴽⴽⵯⵉⵖ ⵛⴰ ⵅ ⵜⵄⵓⵔⵔⵉⵛⵜ-ⴰ ⵓⵛⴰ ⵓⵍⴰ ⴷ ⵛⴻⴽ ⵡⴰⵔ ⵖⴰⵔⵉ ⴷⴷ-ⵜⵥⴻⴽⴽⵯⵡⵉⴷ ⵛⴰ ⵉ ⵍⵖⴰⵔ ⵅ ⵜⵄⵓⵔⵔⵉⵛⵜ-ⴰ ⵓⵍⴰ ⵅ ⵡⴻⵥⵔⵓ-ⵢⴰ ⵏ ⵍⵉⴷⴰⵔⴻⵜ! ");
INSERT INTO rift_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","ⴰⵔⴻⴱⴱⵉ ⵏ ⵉⴱⵔⴰⵀⵉⵎ ⴷ ⴰⵔⴻⴱⴱⵉ ⵏ ⵏⴰⵃⵓⵔ, ⴰⵇⴰ ⴰⵔⴻⴱⴱⵉ ⵏ ⴱⴰⴱⴰⵜⵙⴻⵏ, ⴻⵊⵊ ⵉ-ⵜ ⴰⴷ ⵉⵃⴽⴻⵎ ⵊⴰⵔ ⴰⵏⴻⵖ!” ⵎⴰⵛⴰ ⵢⴰⵄⵇⵓⴱ ⵉⵊⵊⵓⴵ ⵙ ‘ⵜⵉⴳⴳⵯⵓⴷⵉ ⵏ ⵉⵙⵃⴰⵇ ⴱⴰⴱⴰⵙ’. ");
INSERT INTO rift_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","ⵅⴻⵏⵏⵉ ⵉⵖⴰⵔⵚ ⵢⴰⵄⵇⵓⴱ ⵉ ⵢⵉⵛⵜ ⵏ ⵜⵖⴰⵔⵚⵜ ⴷⴻⴳ ⵉⴷⵓⵔⴰⵔ ⵓⵛⴰ ⵉⵍⴰⵖⴰ ⵉ ⵢⴰⵢⵜⵎⴰⵙ ⴰⴷ ⵛⵛⴻⵏ ⴰⵖⵔⵓⵎ. ⵓⵛⴰ ⵛⵛⵉⵏ ⴰⵖⵔⵓⵎ, ⵙⴻⵏⵙⵙⴻⵏ ⴵⵉⵔⴻⵜ ⵏⵏⵉ ⴷⴻⴳ ⵉⴷⵓⵔⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","ⵉⴽⴽⴰⵔ ⵍⴰⴱⴰⵏ ⵖⴰⵔ ⵜⵓⴼⴼⵓⵜ ⵏ ⵚⵚⴱⴻⵃ, ⵉⵙⵙⵓⴷⴻⵎ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ ⴷ ⵢⴻⵙⵙⵉⵙ, ⵉⴱⴰⵔⴽ ⵉ-ⵜⴻⵏ. ⵅⴻⵏⵏⵉ ⵉⵔⵓⵃ ⵍⴰⴱⴰⵏ, ⵉⵄⵇⴻⴱ ⵖⴰⵔ ⵡⴻⵎⵛⴰⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","ⵓⵛⴰ ⵉⵟⵟⴻⴼ ⵢⴰⵄⵇⵓⴱ ⵄⴰⵡⴻⴷ ⴰⴱⵔⵉⴷ ⵏⵏⴻⵙ ⵓⵛⴰ ⵓⵙⵉⵏⵜ-ⵉ-ⴷⴷ ⵍⵎⴰⵍⴰⴽⴰⵜ ⵏ ⴰⵔⴻⴱⴱⵉ, ⵍⵇⴰⵏⵜ ⵜ-ⵉ-ⴷⴷ. ");
INSERT INTO rift_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","ⵉⵏⵏⴰ ⵢⴰⵄⵇⵓⴱ ⵓⵎⵉ ⵜⴻⵏ ⵉⵥⵔⴰ: “ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵏ ⴰⵔⴻⴱⴱⵉ ⴷ ⵡⴰ!”, ⵓⵛⴰ ⵉⵍⴰⵖⴰ ⵉⵙⴻⵎ ⵏ ⵡⴻⵎⵛⴰⵏ ⵏⵏⵉ ⵎⴰⵃⴰⵏⴰⵢⵉⵎ. ");
INSERT INTO rift_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","ⵉⵙⵙⴻⴽⴽ ⵢⴰⵄⵇⵓⴱ ⵉⵔⴻⵇⵇⴰⵙⴻⵏ ⵖⴰⵔ ⵣⵣⴰⵜ, ⵖⴰⵔ ⵄⵉⵙⵓ ⵓⵎⴰⵙ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵙⴰⵄⵉⵔ, ⴰⵇⴰ-ⵜⵜ ⴷ ⵊⵊⵉⵀⴻⵜ ⵏ ⵉⴷⵓⵎ. ");
INSERT INTO rift_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","ⵓⵛⴰ ⵉⵡⴻⵚⵚⴰ ⵉ-ⵜⴻⵏ, ⵉⵏⵏⴰ ⴰⵙⴻⵏ: “ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵜⵉⵏⵉⵎ ⵉ ⵙⵉⴷⵉ ⵉⵏⵓ ⵄⵉⵙⵓ: ‘ⴰⵎⵎⵓ ⵉ ⵉⵇⵇⴰⵔ ⵓⵎⵙⴻⵅⵅⴰⵔ ⵏⵏⴻⵛ ⵢⴰⵄⵇⵓⴱ: ⵜⵓⵖⴰ ⵣⴻⴷⴷⵖⴻⵖ ⴰⴽ-ⴷ ⵍⴰⴱⴰⵏ ⴰⵎ ⵓⴱⴰⵔⵔⴰⵏⵉ ⵓⵛⴰ ⵇⵇⵉⵎⴻⵖ ⴷⵉⵏ ⴰⵍ ⵉ ⵍⴻⵅⵅⵓ. ");
INSERT INTO rift_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","ⵖⴰⵔⵉ ⵉⴼⵓⵏⴰⵙⴻⵏ ⴷ ⵢⴻⵖⵢⴰⵍ ⴷ ⵡⵓⴵⵉ ⴷ ⵉⵙⴻⵎⵖⴰⵏ ⴷ ⵜⵉⵢⵢⴰ ⵓⵛⴰ ⵙⵙⴻⴽⴽⴻⵖ ⵉⵔⴻⵇⵇⴰⵙⴻⵏ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜ ⵉⵏⵉⵖ ⵉ ⵙⵉⴷⵉ ⵉⵏⵓ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴰⴼⴻⵖ ⴰⵔⴹⴰ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵛ.’” ");
INSERT INTO rift_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","ⵉⵔⴻⵇⵇⴰⵙⴻⵏ ⴷⴻⵡⵍⴻⵏ-ⴷⴷ ⵖⴰⵔ ⵢⴰⵄⵇⵓⴱ, ⵏⵏⴰⵏ: “ⵏⵔⵓⵃ ⵖⴰⵔ ⵓⵎⴰⵛ ⵄⵉⵙⵓ, ⵓ ⵏⴻⵜⵜⴰ ⵄⴰⵡⴻⴷ ⵢⵓⵙⴰ-ⴷⴷ ⴰⴷ ⵛⴻⴽ ⵉⵍⵇⴰ ⵓ ⴰⵇⴰ ⴷⵉⵏ ⴰⵔⴻⴱⵄⴰ-ⵎⵢⴰ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ ⴰⴽⵉⴷⴻⵙ.” ");
INSERT INTO rift_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","ⵅⴻⵏⵏⵉ ⵢⴰⵄⵇⵓⴱ ⵜⵓⴷⴻⴼ ⵉ-ⵜ ⵜⵉⴳⴳⵯⵓⴷⵉ ⵜⴻⵎⵖⴰⵔ ⵓⵛⴰ ⵉⵙⵙⵇⴻⵏⴹ ⵉ-ⵜ ⵍⵃⴰⵍ. ⵏⴻⵜⵜⴰ ⵉⴱⴹⴰ ⵉⵡⴷⴰⵏ, ⵉⵏⵏⵉ ⴰⴽⵉⴷⴻⵙ ⴷ ⵡⵓⴵⵉ ⴷ ⵉⴼⵓⵏⴰⵙⴻⵏ ⴷ ⵜⴼⵓⵏⴰⵙⵉⵏ ⴷ ⵉⵍⴻⵖⵎⴰⵏ ⵅ ⵜⵏⴰⵢⴻⵏ ⵏ ⵍⴻⵎⵔⴰⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","ⵉⵏⵏⴰ: “ⵎⴰⵍⴰ ⵢⵓⵙⴰ-ⴷⴷ ⵄⵉⵙⵓ ⵖⴰⵔ ⵉⵊⵊ ⵏ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ, ⴰⴷ ⵅⴰⵙ ⵉⵖⵍⴻⴱ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵢⴰⵔⵡⴻⵍ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵉ ⵉⵇⵇⵉⵎⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","ⵓⵛⴰ ⵉⵏⵏⴰ ⵢⴰⵄⵇⵓⴱ: “ⴰ ⴰⵔⴻⴱⴱⵉ ⵏ ⴱⴰⴱⴰ ⵉⴱⵔⴰⵀⵉⵎ ⴷ ⴰⵔⴻⴱⴱⵉ ⵏ ⴱⴰⴱⴰ ⵉⵙⵃⴰⵇ, ⴰ ⵙⵉⴷⵉ, ⵛⴻⴽ ⵡⴻⵏⵏⵉ ⴷ ⴰⵢⵉ ⵉⵏⵏⴰⵏ: ‘ⴷⵡⴻⵍ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⴻⵛ ⴷ ⵔⴰⴵ ⵏⵏⴻⵛ ⵓⵛⴰ ⵏⴻⵛⵛ ⴰⴷ ⴰⵛ ⴳⴳⴻⵖ ⵎⵉⵏ ⵉⵛⵏⴰⵏ!’ ");
INSERT INTO rift_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","ⴰⵇⴰ ⴰⵢⵉ ⵇⴻⵍⵍ ⵅ ⵎⴰⵔⵔⴰ ⵜⵉⵎⴻⴳⴳⴰ ⵏ ⵜⵎⴻⵅⵙⵉⵡⵜ ⵉⵛⴻⵡⵡⴰⵔⴻⵏ ⴷ ⵎⴰⵔⵔⴰ ⵍⴰⵎⴰⵏ ⵉ ⵜⴻⵙⵙⴻⵛⵏⴻⴷ ⵉ ⵓⵎⵙⴻⵅⵅⴰⵔ ⵏⵏⴻⵛ, ⵎⵉⵏⵣⵉ ⵥⵡⵉⵖ ⵍ’ⵓⵔⴷⵓⵏ ⵙ ⵜⴻⵖⵖⴰⵔⵛⵜ ⵉⵏⵓ ⵍⴰⵎⵉ ⴷⴷ-ⴼⴼⵖⴻⵖ ⵓⵛⴰ ⵍⴻⵅⵅⵓ ⴷⴻⵡⵍⴻⵖ-ⴷⴷ ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵍⴻⵎⵔⴰⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","ⴼⴻⴽⴽ ⴰⵢⵉ ⵍⴻⵅⵅⵓ ⵣⴻⴳ ⵓⴼⵓⵙ ⵏ ⵄⵉⵙⵓ ⵓⵎⴰ, ⵎⵉⵏⵣⵉ ⵜⵜⴻⴳⴳⵯⴻⴷⴻⵖ ⴱⴰⵍⴰⴽ ⴰⴷ ⴷⴷ-ⵢⴰⵙ ⵓⵛⴰ ⴰⴷ ⵉⵏⴻⵖ ⵓⵍⴰ ⴷ ⵜⵉⵢⴻⵎⵎⴰⵜⵉⵏ ⴰⴽ-ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ! ");
INSERT INTO rift_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","ⵓⵛⴰ ⵛⴻⴽ ⵜⴻⵏⵏⵉⴷ: ‘ⵏⴻⵛⵛ ⴰⴷ ⴽⵉⴽ ⴳⴳⴻⵖ ⵎⵍⵉⵃ, ⴰⴷ ⴳⴳⴻⵖ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵛ ⴰⵎ ⵢⵉⵊⴷⵉ ⵏ ⵍⴻⴱⵃⴰⵔ ⵉ ⵡⴰⵔ ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵉⵜⵜⵡⴰⵃⵙⴻⴱ ⵣⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⵓⴱⴰⵔⵔⵓ ⵏⵏⴻⵙ!’” ");
INSERT INTO rift_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","ⵉⵙⵙⴻⵏⵙ ⴷⵉⵏ ⴵⵉⵍⴻⵜ ⵏⵏⵉ ⵓⵛⴰ ⵉⴽⵙⵉ ⵣⵉ ⵎⵉⵏ ⴷⴷ-ⵢⵓⵙⵉⵏ ⴷⴻⴳ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵏⴻⵙ ⴷ ⴰⴳⵍⴰ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜ ⵢⴻⵡⵛ ⴷ ⴰⵔⵔⵉⵖⴰⵍⵓ ⵉ ⵓⵎⴰⵙ ⵄⵉⵙⵓ: ");
INSERT INTO rift_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ⵎⵉⵜⴰⵢⴻⵏ ⵏ ⵜⵖⴰⵢⴹⵉⵏ ⴷ ⵄⵉⵛⵔⵉⵏ ⵏ ⵉⵎⵓⵢⴰⵏ ⴷ ⵎⵉⵜⴰⵢⴻⵏ ⵏ ⵜⵅⴻⵙⵡⵉⵏ ⴷ ⵄⵉⵛⵔⵉⵏ ⵏ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ ");
INSERT INTO rift_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","ⴷ ⵜⵍⴰⵜⵉⵏ ⵏ ⵜⵍⴻⵖⵎⵉⵏ ⵉⵙⵙⵓⵟⵟⵓⴹⴻⵏ ⴰⴽ-ⴷ ⵜⴰⵔⵡⴰ ⵏⵙⴻⵏⵜ, ⴰⵔⴻⴱⵄⵉⵏ ⵏ ⵜⴼⵓⵏⴰⵙⵉⵏ ⵜⵉⵎⴻⵥⵢⴰⵏⵉⵏ, ⵄⴻⵛⵔⴰ ⵏ ⵉⴼⵓⵏⴰⵙⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⴻⵏ ⴷ ⵄⵉⵛⵔⵉⵏ ⵏ ⵜⴻⵖⵢⴰⵍ ⴷ ⵄⴻⵛⵔⴰ ⵏ ⵢⴻⵖⵢⴰⵍ ⵉⵎⴻⵥⵢⴰⵏⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","ⵉⵙⵙⴻⵄⴷⵓ ⵜⴻⵏ ⵖⴰⵔ ⵉⴼⴰⵙⵙⴻⵏ ⵏ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵙ, ⴽⵓⵍ ⵜⴰⵃⵉⵎⴰⵔⵜ ⵡⴻⵃⵃⴷⴻⵙ, ⵓⵛⴰ ⵉⵏⵏⴰ ⵉ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵙ: “ⵄⴷⵓⵎ ⴽⴻⵏⵏⵉⵡ ⵍⴻⵅⵅⵓ ⵣⵣⴰⵜ ⵉⵏⵓ, ⴳⴳⴻⵎ ⵜⵜⴰⵙⵉⵄ ⵊⴰⵔ ⵜⵃⵉⵎⴰⵔⵜ ⴷ ⵜⵃⵉⵎⴰⵔⵜ.” ");
INSERT INTO rift_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","ⵅⴻⵏⵏⵉ ⵢⵓⵎⵓⵔ ⵓⵎⴻⵣⵡⴰⵔ, ⵉⵏⵏⴰ ⴰⵙ: “ⵎⴰⵍⴰ ⵢⵓⵙⴰ-ⴷⴷ ⵄⵉⵙⵓ ⵉ ⵓⵎⵙⴰⴳⴰⵔ ⴰⴽⵉⴷⴻⴽ ⵓⵛⴰ ⵉⵙⵙⴻⵇⵙⴰ ⴰⵛ, ⵉⵏⵏⴰ: ‘ⵡⵉ ⵛⴻⴽ ⵢⵉⵍⴰⵏ ⴷ ⵎⴰⵏⵉ ⵖⴰ ⵜⵔⴰⵃⴻⴷ?’ ⵓ ‘ⵓⵎⵉ ⵜⵉⵏⴰ ⵉ ⵉⴵⴰⵏ ⵣⵣⴰⵜⴻⴽ?’, ");
INSERT INTO rift_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","ⵍⴻⵅⴷⴻⵏⵏⵉ ⴰⴷ ⵜⵉⵏⵉⴷ: ‘ⴷ ⴰⵔⵔⵉⵖⴰⵍⵓ ⵉ ⵢⴻⴵⴰ ⵏ ⵓⵎⵙⴻⵅⵅⴰⵔ ⵏⵏⴻⵛ ⵢⴰⵄⵇⵓⴱ, ⵡⴻⵏⵏⵉ ⴷⴷ-ⵉⵙⵙⴻⴽⴽ ⵉ ⵙⵉⴷⵉ ⵉⵏⵓ ⵄⵉⵙⵓ. ⵅⵣⴰⵔ, ⵏⴻⵜⵜⴰ ⵄⴰⵡⴻⴷ ⵢⵓⵙⴰ-ⴷⴷ ⴰⵡⴰⵔⵏⵉ ⴰⵏⴻⵖ!’” ");
INSERT INTO rift_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","ⵢⵓⵎⵓⵔ ⵄⴰⵡⴻⴷ ⵡⴻⵏⵏⵉ ⵡⵉⵙⵙ ⵜⵏⴰⵢⴻⵏ ⴷ ⵡⵉⵙⵙ ⵜⵍⴰⵜⴰ ⵉⵏⵏⵉ ⵉⴳⴳⵓⵔⴻⵏ ⴰⵡⴰⵔⵏⵉ ⵉ ⵜⵃⵉⵎⵔⵉⵡⵉⵏ, ⵉⵏⵏⴰ: “ⵙⵉⵡⵍⴻⵎ ⴰⵡⴰⵍⴻⵏ-ⴰ ⴷ ⵉⵊⵊⴻⵏ ⴰⴽ-ⴷ ⵄⵉⵙⵓ, ⵅⵎⵉ ⵜ ⵖⴰ ⵜⴻⵍⵇⴰⵎ. ");
INSERT INTO rift_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","ⴽⴻⵏⵏⵉⵡ ⵄⴰⵡⴻⴷ ⴰⴷ ⵜⵉⵏⵉⵎ: ‘ⵅⵣⴰⵔ, ⴰⵎⵙⴻⵅⵅⴰⵔ ⵏⵏⴻⵛ ⵢⴰⵄⵇⵓⴱ ⵢⵓⵙⴰ-ⴷⴷ ⴰⵡⴰⵔⵏⵉ ⴰⵏⴻⵖ!’” ⵎⵉⵏⵣⵉ ⵉⵏⵏⴰ: “ⴰⴷ ⵜ ⵙⵙⴰⵔⴻⵢⵢⵃⴻⵖ ⵙ ⴰⵔⵔⵉⵖⴰⵍⵓ-ⵢⴰ ⵉ ⴷⴷ-ⵢⵓⵙⵉⵏ ⵣⵣⴰⵜ ⵉⵏⵓ. ⵅⴻⵏⵏⵉ ⴰⵡⴰⵔⵏⵉ ⵎⴰⵏ ⴰⵢⴰ ⴰⴷ ⵥⴰⵔⴻⵖ ⴰⵖⴻⵎⴱⵓⴱ ⵏⵏⴻⵙ, ⴱⴰⵍⴰⴽ ⴰⴷ ⵉⵇⴱⴻⵍ ⴰⵖⴻⵎⴱⵓⴱ ⵉⵏⵓ ⵣⵣⴰⵜⴻⵙ.” ");
INSERT INTO rift_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","ⴰⵎⵎⵓ ⵉ ⵉⵙⵙⵉⵣⵣⴰⵔ ⴰⵔⵔⵉⵖⴰⵍⵓ ⵣⵣⴰⵜⴻⵙ ⵖⴰⵔ ⵓⵊⴻⵎⵎⴰⴹ ⴰⵎ ⵉⵙⵙⴻⵏⵙ ⵏⴻⵜⵜⴰ ⴵⵉⵔⴻⵜ ⵏⵏⵉ ⴷⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","ⵉⴽⴽⴰⵔ ⴵⵉⵍⴻⵜ ⵏⵏⵉ ⵓⵛⴰ ⵉⴽⵙⵉ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵎⵖⴰⵔⵉⵏ ⵏⵏⴻⵙ ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵉⵢⵢⴰ ⵏⵏⴻⵙ ⴷ ⵃⵉⵟⴰⵛ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ, ⵉⵥⵡⴰ ⴰⵎⵛⴰⵏ ⵏ ⵓⵥⴻⴽⴽⵡⵓ ⵏ ⵢⴻⵖⵣⴰⵔ ⵏ ⵢⴰⴱⴱⵓⵇ. ");
INSERT INTO rift_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","ⵢⵉⵡⵢⵉ ⵉ-ⵜⴻⵏ ⵓⵛⴰ ⵉⵙⵙⴻⵥⵡⴰ ⵜⴻⵏ ⵉ ⵜⴻⵖⵣⵓⵔⵜ ⵓ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵖⴰⵔⴻⵙ ⵉⵙⵙⴻⵄⴷⵓ ⵜ ⵖⴰⵔ ⵓⵊⴻⵎⵎⴰⴹ. ");
INSERT INTO rift_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","ⵎⴰⵛⴰ ⵉⵇⵇⵉⵎ ⵢⴰⵄⵇⵓⴱ ⵡⴻⵃⵃⴷⴻⵙ ⵓ ⵏⴻⵜⵜⴰ ⵉⵎⵎⵓⵖⵣⴻⵍ ⴰⴽ-ⴷ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⴰⵍⵎⵉ ⴷ ⵜⵓⴼⴼⵓⵜ ⵏ ⵍⴻⴼⵊⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","ⵓⵎⵉ ⵉⵥⵔⴰ ⵡⴰⵏⵉⵜⴰ ⴰⵇⴰ ⵡⴰⵔ ⵅⴰⵙ ⵉⵇⴻⴷⴷ ⵛⴰ, ⵉⵃⴰⴷⴰ ⵜ ⵖⴰⵔ ⵡⴻⵎⵛⴰⵏ ⵏ ⵜⴻⵎⵇⵉⵇⵇⴻⵛⵜ ⵏ ⵜⵎⴻⵚⵚⴰⴹⵜ ⵏⵏⴻⵙ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴷⴷ-ⵜⴻⵏⵅⵓⵅⴻⵔ ⵜⴰⵎⵇⵉⵇⵇⴻⵛⵜ ⵏ ⵜⵎⴻⵚⵚⴰⴹⵜ ⵏ ⵢⴰⵄⵇⵓⴱ ⵓⵎⵉ ⴽⵉⴷⴻⵙ ⵜⵓⵖⴰ ⵉⵜⵜⵎⵓⵖⵣⵓⵍ. ");
INSERT INTO rift_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","ⵉⵏⵏⴰ: “ⴻⵊⵊ ⴰⵢⵉ ⴰⴷ ⵔⴰⵃⴻⵖ, ⴰⵇⴰ ⵉⵚⴱⴻⵃ ⵍⵃⴰⵍ.” ⵎⴰⵛⴰ ⵏⴻⵜⵜⴰ ⵉⵏⵏⴰ: “ⵡⴰⵔ ⵛⴻⴽ ⵜⵜⴻⵊⵊⵉⵖ, ⵎⵖⵉⵔ ⵎⴰⵍⴰ ⵜⴱⴰⵔⴽⴻⴷ ⴰⵢⵉ.” ");
INSERT INTO rift_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵉⵏⵏⴰ ⴰⵙ: “ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵛ ⵇⵇⴰⵔⴻⵏ?” ⵢⴰⵔⵔⴰ-ⴷⴷ ⵅⴰⵙ: “ⵢⴰⵄⵇⵓⴱ.” ");
INSERT INTO rift_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⴰⵙ: “ⵡⴰⵔ ⴷ ⴰⵛ ⵇⵇⴰⵔⴻⵏ ⵄⴰⴷ ⵢⴰⵄⵇⵓⴱ, ⵎⴰⵛⴰ ⵉⵙⵔⴰⵉⵍ, ⵎⵉⵏⵣⵉ ⵜⴻⵎⵎⴻⵏⵖⴻⴷ ⴰⴽ-ⴷ ⴰⵔⴻⴱⴱⵉ ⴷ ⵉⵡⴷⴰⵏ, ⵓⵛⴰ ⵛⴻⴽ ⵜⵖⴻⵍⴱⴻⴷ.”    ");
INSERT INTO rift_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","ⵉⵙⵙⴻⵇⵙⴰ ⵢⴰⵄⵇⵓⴱ ⵅⴻⵏⵏⵉ, ⵉⵏⵏⴰ: “ⵉⵏⵉ ⴰⵢⵉ ⵍⴻⵅⵅⵓ ⵉⵙⴻⵎ ⵏⵏⴻⵛ!” ⵢⴰⵔⵔⴰ-ⴷⴷ ⵅⴰⵙ: “ⵎⴰⵖⴰⵔ ⵜⴻⵙⵙⴻⵇⵙⵉⴷ ⵅ ⵢⵉⵙⴻⵎ ⵉⵏⵓ?” ⵓⵛⴰ ⵉⴱⴰⵔⴽ ⵉ-ⵜ ⴷⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","ⵓⵛⴰ ⵉⵙⴻⵎⵎⴰ ⵢⴰⵄⵇⵓⴱ ⴰⵎⵛⴰⵏ ⵏⵏⵉ ⴼⴰⵏⵓⵡⵉⵍ, ⵉⵏⵏⴰ: “ⵎⵉⵏⵣⵉ ⵥⵔⵉⵖ ⴰⵔⴻⴱⴱⵉ ⴰⵖⴻⵎⴱⵓⴱ ⴷⴻⴳ ⵓⵖⴻⵎⴱⵓⴱ ⵓⵛⴰ ⵉⵏⵊⴻⵎ ⵍⴻⵄⵎⴰⵔ ⵉⵏⵓ.” ");
INSERT INTO rift_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","ⵜⴻⵏⵇⴰⵔ-ⴷⴷ ⵅⴰⵙ ⵜⴼⵓⵛⵜ ⵓⵎⵉ ⵜⵓⵖⴰ ⵉⵄⴷⵓ ⵅ ⴼⴰⵏⵓⵡⵉⵍ, ⵓⵛⴰ ⵢⵓⵢⵓⵔ ⵉⵜⵜⵣⴻⵃⵃⴻⴼ ⵣⵉ ⵜⵎⴻⵚⵚⴰⴹⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN32_33","002_32_33","GEN","32","33","33","ⵅ ⵓⵢⴰ ⵡⴰⵔ ⵜⵜᵉⵜⵜⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴰⵍ ⴰⵙⵙ-ⴰ ⵣⴻⴳ ⵡⴻⵥⵡⴰⵔ ⵉⴳⴷⴰⵔⴻⵏ ⵉ ⵉⵜⵜⴻⴽⴽⴻⵏ ⵅ ⵜⴻⵎⵇⵉⵇⵇⴻⵛⵜ ⵏ ⵜⵎⴻⵚⵚⴰⴹⵜ, ⵎⵉⵏⵣⵉ ⵉⵃⴰⴷⴰ ⵜⴰⵎⴻⵚⵚⴰⴹⵜ ⵏ ⵢⴰⵄⵇⵓⴱ ⵖⴰⵔ ⵎⴰⵏⵉ ⵉⴵⴰ ⵡⴻⵥⵡⴰⵔ ⵉⴳⴷⴰⵔⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","ⵉⵙⵙⴳⴻⵄⵄⴻⴷ ⵢⴰⵄⵇⵓⴱ ⵜⴰⵎⵓⵖⵍⵉ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⵥⵔⴰ ⵄⵉⵙⵓ ⴷ ⴰⵔⴻⴱⵄⴰ-ⵎⵢⴰ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ ⴰⴽⵉⴷⴻⵙ ⵅⴻⵛⵛⴻⵏ-ⴷⴷ. ⵉⴼⴰⵔⵇ ⵢⴰⵄⵇⵓⴱ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵅ ⵍⵉⵢⴰ ⴷ ⵔⴰⵃⵉⵍ ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵉⵢⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","ⵉⴳⴳⴰ ⵜⵉⵢⵢⴰ ⴷ ⵜⴰⵔⵡⴰ ⵏⵙⴻⵏⵜ ⵖⴰⵔ ⵣⵣⴰⵜ, ⴰⵡⴰⵔⵏⵉ ⴰⵙⴻⵏⵜ ⵍⵉⵢⴰ ⴷ ⵜⴰⵔⵡⴰ ⵏⵏⴻⵙ ⵓ ⵔⴰⵃⵉⵍ ⴷ ⵢⵓⵙⵓⴼ ⴷ ⵉⵏⴻⴳⴳⵓⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","ⵓⵎⵉ ⵉⵄⴷⵓ ⵣⵣⴰⵜ ⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵙⴻⵏ, ⵉⴱⴻⵏⴷⴻⵇ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵙⴻⴱⵄⴰ ⵏ ⵜⵡⴰⵍⴰⵡⵉⵏ ⴰⵍⴰⵎⵉ ⴷⴷ-ⵢⵉⵡⴻⴹ ⵖⴰⵔ ⵓⵎⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","ⵄⵉⵙⵓ ⵢⵓⵣⵣⴻⵍ-ⴷⴷ ⵃⵉⵎⴰ ⴰⴷ ⵜ ⵉⵍⵇⴰ, ⵉⴷⴰⵔⵔⴻⵄ ⴰⵙ, ⵉⵏⴳⴻⵣ ⴰⵙ ⵅ ⵢⵉⵔⵉ ⵏⵏⴻⵙ, ⵉⵙⵙⵓⴷⴻⵎ ⵉ-ⵜ ⵓⵛⴰ ⵔⵓⵏ ⵙ ⵜⵏⴰⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","ⵅⴰⵙ ⵓⵛⴰ ⵉⵙⵙⴳⴻⵄⵄⴻⴷ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵙ, ⵉⵥⵔⴰ ⵜⵉⵎⵖⴰⵔⵉⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⵉ ⵓⵛⴰ ⵉⵏⵏⴰ: “ⵎⵉⵏ ⵄⵏⴰⵏ ⵉⵏⴰ ⵉⵏⵏⵉ ⴰⴽⵉⴷⴻⴽ?” ⵏⴻⵜⵜⴰ ⵢⴰⵔⵔⴰ-ⴷⴷ ⵅⴰⵙ: “ⴷ ⵜⴰⵔⵡⴰ ⵏⵏⵉ ⵉⵡⵛⴰ ⴰⵔⴻⴱⴱⵉ ⵣⴻⴳ ⴰⵔⴹⴰ ⵏⵏⴻⵙ ⵉ ⵓⵎⵙⴻⵅⵅⴰⵔ ⵏⵏⴻⵛ.” ");
INSERT INTO rift_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","ⵓⵛⴰ ⵔⴻⵃⵃⴳⴻⵏⵜ-ⵉ-ⴷⴷ ⵜⵉⵢⵢⴰ, ⵏⵉⵜⴻⵏⵜⵉ ⴷ ⵜⴰⵔⵡⴰ ⵏⵙⴻⵏⵜ, ⵓⵛⴰ ⴱⴻⵏⴷⵇⴻⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","ⵜⵔⴻⵃⵃⴻⴳ-ⴷⴷ ⵄⴰⵡⴻⴷ ⵍⵉⵢⴰ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ ⵓⵛⴰ ⴱⴻⵏⴷⵇⴻⵏ. ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⵇⴰⵔⵔⴻⴱ-ⴷⴷ ⵢⵓⵙⵓⴼ ⴷ ⵔⴰⵃⵉⵍ ⵓⵛⴰ ⴱⴻⵏⴷⵇⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","ⵉⵏⵏⴰ ⴰⵙ: “ⵎⵉⵏ ⵜⴻⵅⵙⴻⴷ ⴰⴽ-ⴷ ⵓⴱⴰⵔⵔⵓ-ⵢⴰ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵏⵉ ⵍⵇⵉⵖ?” ⵏⴻⵜⵜⴰ ⵉⵏⵏⴰ: “ⵏⴻⵛⵛ ⵙⵙⴻⴽⴽⴻⵖ ⵜ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴰⴼⴻⵖ ⴰⵔⴹⴰ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵙⵉⴷⵉ ⵉⵏⵓ!” ");
INSERT INTO rift_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","ⵉⵏⵏⴰ ⵄⵉⵙⵓ: “ⴰⵇⴰ ⵖⴰⵔⵉ ⴰⵟⵟⴰⵙ, ⵓⵎⴰ ⵉⵏⵓ! ⴰⴷ ⵢⵉⵍⵉ ⵉ ⵛⴻⴽ ⵎⵉⵏ ⵉⴵⴰⵏ ⵏⵏⴻⵛ!” ");
INSERT INTO rift_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","ⵅⴰⵙ ⵓⵛⴰ ⵉⵏⵏⴰ ⵢⴰⵄⵇⵓⴱ: “ⵍⵍⴰ, ⵜⵜⵣⴰⵡⴰⴳⴻⵖ ⵛⴻⴽ! ⵎⴰⵍⴰ ⵓⴼⵉⵖ ⵍⴻⵅⵅⵓ ⴰⵔⴹⴰ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵛ, ⴽⵙⵉ ⴰⵔⵔⵉⵖⴰⵍⵓ ⵉⵏⵓ ⵣⴻⴳ ⵉⴼⴰⵙⵙⴻⵏ ⵉⵏⵓ, ⵎⴰⵖⴰⵔ ⵥⵔⵉⵖ ⵓⴷⴻⵎ ⵏⵏⴻⵛ ⴰⵅⵎⵉ ⵥⵔⵉⵖ ⵓⴷⴻⵎ ⵏ ⴰⵔⴻⴱⴱⵉ ⵓⵛⴰ ⵜⵇⴻⴱⵍⴻⴷ ⵅⴰⴼⵉ ⵙ ⵍⴻⵎⵍⴰⵃⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","ⵜⵜⵣⴰⵡⴳⴻⵖ ⵛⴻⴽ, ⴽⵙⵉ ⵍⴱⴰⵔⴰⴽⴰ ⵉⵏⵓ ⵉ ⴷ ⴰⵛ ⴷⴷ-ⵉⵡⵢⴻⵖ, ⵎⵉⵏⵣⵉ ⴰⵔⴻⴱⴱⵉ ⵉⵎⵚⵓⵔⵔⵓⴼ ⴰⴽⵉⴷⵉ ⵙ ⴰⵔⴹⴰ ⵓⵛⴰ ⵏⴻⵛⵛ ⵖⴰⵔⵉ ⴽⵓⵍⵛⵉ.” ⵉⴽⴻⵍⵍⴻⴼ ⵉ-ⵜ ⵓⵛⴰ ⵉⴽⵙⵉ ⵜ. ");
INSERT INTO rift_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","ⵏⴻⵜⵜⴰ ⵉⵏⵏⴰ: “ⴻⵊⵊ ⴰⵏⴻⵖ ⴰⴷ ⵏⴻⴼⵙⵉ ⵉⵇⵉⴹⴰⵏ ⵏⵏⴻⵖ, ⴰⴷ ⵏⵔⴰⵃ. ⵏⴻⵛⵛ ⴰⴷ ⵔⴰⵃⴻⵖ ⵣⵣⴰⵜⴻⵛ.” ");
INSERT INTO rift_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","ⵎⴰⵛⴰ ⵏⴻⵜⵜⴰ ⵉⵏⵏⴰ ⴰⵙ: “ⵙⵉⴷⵉ ⵉⵏⵓ ⵉⵙⵙⴻⵏ, ⴰⵇⴰ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ-ⴰ ⴰⵔⴻⵀⴼⴻⵏ ⵓ ⴰⵇⴰ ⵖⴰⵔⵉ ⵓⴵⵉ ⴷ ⵜⴼⵓⵏⴰⵙⵉⵏ ⵓⵔⵡⴻⵏⵜ ⵙⵙⵓⵟⵟⵓⴹⴻⵏⵜ. ⵎⴰⵍⴰ ⴱⵏⴰⴷⴻⵎ ⵉⵣⴻⵢⵢⴰⵔ ⵅⴰⵙⴻⵏⵜ ⴰⵟⵟⴰⵙ, ⵡⴰⵅⵅⴰ ⵎⵖⵉⵔ ⵉ ⵢⵉⵊⵊ ⵏ ⵡⴰⵙⵙ, ⴰⴷ ⵉⵎⵎⴻⵜ ⵡⵓⴵⵉ ⵎⴰⵔⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","ⴰⴷ ⵉⵄⴷⵓ ⵍⴻⵅⵅⵓ ⵙⵉⴷⵉ ⵉⵏⵓ ⵣⵣⴰⵜ ⵉ ⵓⵖⴻⵎⴱⵓⴱ ⵏ ⵓⵎⵙⴻⵅⵅⴰⵔ ⵏⵏⴻⵙ ⵓ ⵏⴻⵛⵛ ⴰⴷ ⴷⴷ-ⴰⵙⴻⵖ ⵛⵡⴰⵢⵜ ⵛⵡⴰⵢⵜ ⴰⴽ-ⴷ ⵉⵚⵓⵔⴰⴼ ⵏ ⵍⴻⴽⵙⵉⴱⴻⵜ ⵉ ⵉⴵⴰⵏ ⵣⵣⴰⵜⵉ ⵓⵍⴰ ⴰⴽ-ⴷ ⵉⵚⵓⵔⴰⴼ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ, ⴰⵍ ⴷⴷ ⵖⴰ ⴰⵡⴹⴻⵖ ⵖⴰⵔ ⵙⵉⴷⵉ ⵉⵏⵓ ⴷⵉ ⵙⴰⵄⵉⵔ.” ");
INSERT INTO rift_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","ⵉⵏⵏⴰ ⵄⵉⵙⵓ: “ⴰⴷ ⵊⵊⴻⵖ ⵍⴻⵅⵅⵓ ⴰⴽⵉⴷⴻⴽ ⵛⴰ ⵏ ⵉⵡⴷⴰⵏ ⵉⵏⵏⵉ ⵉⴵⴰⵏ ⴰⴽⵉⴷⵉ.” ⵎⴰⵛⴰ ⵏⴻⵜⵜⴰ ⵉⵏⵏⴰ: “ⵓⵎⵉ ⴷⴷⴻⴳⴳⴰ? ⴻⵊⵊ ⴰⵢⵉ ⴰⴷ ⴰⴼⴻⵖ ⴰⵔⴹⴰ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵙⵉⴷⵉ ⵉⵏⵓ!” ");
INSERT INTO rift_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","ⵉⵄⵇⴻⴱ-ⴷⴷ ⵄⵉⵙⵓ ⴷⴻⴳ ⵡⴰⵙⵙ ⵏⵏⵉ ⵅ ⵡⴻⴱⵔⵉⴷ ⵖⴰⵔ ⵙⴰⵄⵉⵔ. ");
INSERT INTO rift_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","ⵓⵛⴰ ⵉⴼⵙⵉ ⵢⴰⵄⵇⵓⴱ ⵉⵇⵉⴹⴰⵏ ⵏⵏⴻⵙ, ⵢⵓⵢⵓⵔ ⵖⴰⵔ ⵙⵓⴽⴽⵓⵜ, ⵉⴱⵏⴰ ⴷⵉⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵉ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⴳⴳⴰ ⵉⵄⵓⵛⵛⵓⵜⴻⵏ ⵏ ⵜⵙⴻⵟⵟⴰ ⵉ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏⵏⴻⵙ. ⵅ ⵓⵢⴰ ⵉⵍⴰⵖⴰ ⵉⵙⴻⵎ ⵏ ⵡⴻⵎⵛⴰⵏ ⵏⵏⵉ ⵙⵓⴽⴽⵓⵜ, ⵉⵅⵙ ⴰⴷ ⵢⵉⵏⵉ ‘ⵉⵄⵓⵛⵛⵓⵜⴻⵏ’. ");
INSERT INTO rift_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","ⵓⵎⵉ ⴷⴷ-ⵉⵄⵇⴻⴱ ⵢⴰⵄⵇⵓⴱ ⵣⵉ ⴼⴰⴷⴰⵏ-ⴰⵔⴰⵎ, ⵢⵓⵙⴰ-ⴷⴷ ⵖⴰⵔ ⵛⴰⵍⵉⵎ, ⵉⵛⵜ ⵏ ⵜⴻⵏⴷⵉⵏⵜ ⵏ ⵛⴰⴽⵉⵎ, ⵜⴻⵏⵏⵉ ⵉⴵⴰⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ, ⵓⵛⴰ ⵉⵡⵜⴰ ⵉⵇⵉⴹⴰⵏ ⵏⵏⴻⵙ ⵣⵣⴰⵜ ⵉ ⵜⴻⵏⴷⵉⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","ⵉⵙⵖⴰ ⵟⵟⴰⵔⴼ ⵏ ⵢⴻⵢⵢⴰⵔ ⵎⴰⵏⵉ ⵉⵡⵜⴰ ⵉⵇⵉⴹⴰⵏ ⵏⵏⴻⵙ, ⵣⴻⴳ ⵉⴼⴰⵙⵙⴻⵏ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵃⴰⵎⵓⵔ, ⴱⴰⴱⴰⵙ ⵏ ⵛⴰⴽⵉⵎ, ⵙ ⵎⵢⴰ ⵏ ⵉⵣⵉⵢⵏⴰⵜ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵉⵡⴻⵣⵏⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","ⵉⵙⵙⴳⴻⵄⵄⴻⴷ ⴷⵉⵏ ⵉⵊⵊ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ⵎⵉⵏ ⵅⴻⴼ ⵜⴻⵎⵎⴰⵔⵙ ⵜⵖⴰⵔⵚⵜ ⵓⵛⴰ ⵉⵍⴰⵖⴰ ⴰⵙ: ‘ⴰⵔⴻⴱⴱⵉ ⴷ ⴰⵔⴻⴱⴱⵉ ⵏ ⵉⵙⵔⴰⵉⵍ!’ ");
INSERT INTO rift_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","ⴷⵉⵏⴰ, ⵢⴻⴵⵉⵙ ⵏ ⵍⵉⵢⴰ, ⵜⴻⵏⵏⵉ ⴷⴷ-ⵜⵓⵔⵓⵡ ⵉ ⵢⴰⵄⵇⵓⴱ, ⵜⴻⴼⴼⴻⵖ, ⵃⵉⵎⴰ ⴰⴷ ⵜⴻⵎⵎⴻⵍⵇⴰ ⴰⴽ-ⴷ ⵢⴻⵙⵙⵉⵙ ⵏ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","ⵛⴰⴽⵉⵎ, ⵎⵎⵉⵙ ⵏ ⵃⴰⵎⵓⵔ ⴰⵃⵉⵡⵉ, ⵍⵃⴰⴽⴻⵎ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⵉ, ⵉⵥⵔⴰ ⵉ-ⵜⵜ, ⵉⴽⵙⵉ ⵜⵜ ⵓⵛⴰ ⵉⵟⵟⴻⵚ ⴰⴽⵉⴷⴻⵙ, ⵉⵙⵙⴻⵅⵙⴰⵔ ⵉ-ⵜⵜ. ");
INSERT INTO rift_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","ⵉⵟⵟⴰⵔⴱⴻⵟ ⴷⵉ ⴷⵉⵏⴰ, ⵢⴻⴵⵉⵙ ⵏ ⵢⴰⵄⵇⵓⴱ, ⵓ ⵏⴻⵜⵜⴰ ⵉⵅⵙ ⵜⴰⴱⵍⵉⵖⵜ ⵓⵛⴰ ⵉⵙⵙⵉⵡⴻⵍ ⵖⴰⵔ ⵡⵓⵍ ⵏ ⵜⴻⴱⵍⵉⵖⵜ. ");
INSERT INTO rift_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","ⵉⵙⵙⵉⵡⴻⵍ ⵛⴰⴽⵉⵎ ⵖⴰⵔ ⵃⴰⵎⵓⵔ ⴱⴰⴱⴰⵙ, ⵉⵏⵏⴰ ⴰⵙ: “ⴰⵡⵢⵉ ⴰⵢⵉ-ⴷⴷ ⵜⴰⴱⵍⵉⵖⵜ-ⴰ ⴷ ⵜⴰⵎⵖⴰⵔⵜ.” ");
INSERT INTO rift_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","ⵍⴰⵎⵉ ⵉⵙⵍⴰ ⵢⴰⵄⵇⵓⴱ ⴱⴻⵍⵍⵉ ⵛⴰⴽⵉⵎ ⵉⴹⴻⵢⵢⴻⵄ ⵛⵛⴰⵔⴰⴼ ⵏ ⵢⴻⴵⵉⵙ ⴷⵉⵏⴰ, ⵜⵓⵖⴰ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ ⴰⴽ-ⴷ ⵍⴻⴱⵀⴰⵢⴻⵎ ⴷⴻⴳ ⵉⵢⵢⴰⵔ. ⵉⵙⵙⵓⵙⴻⵎ ⵢⴰⵄⵇⵓⴱ ⴰⵍⴰⵎⵉ ⴷⴷ-ⵄⴻⵇⴱⴻⵏ ⵏⵉⵜⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","ⵉⵔⵓⵃ ⵃⴰⵎⵓⵔ, ⴱⴰⴱⴰⵙ ⵏ ⵛⴰⴽⵉⵎ ⵖⴰⵔ ⵢⴰⵄⵇⵓⴱ, ⵃⵉⵎⴰ ⴰⴷ ⴽⵉⵙ ⵉⵙⵙⵉⵡⴻⵍ. ");
INSERT INTO rift_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","ⵜⴰⵔⵡⴰ ⵏ ⵢⴰⵄⵇⵓⴱ ⴷⴻⵡⵍⴻⵏ-ⴷⴷ ⵣⴻⴳ ⵉⵢⵢⴰⵔ ⵓⵛⴰ ⴰⵔⴻⴳⴳⴱⴻⵏ ⵅ ⵍⴻⵅⴱⴰⵔ. ⵅⴻⵢⵢⵇⴻⵏ ⵅ ⵎⴰⵏ ⴰⵢⴰ ⴷⴻⴳ ⵡⵓⵍ ⵓ ⴼⴼⵓⴳⵎⴻⵏ ⴰⵟⵟⴰⵙ, ⵎⵉⵏⵣⵉ ⵉⴳⴳⴰ ⵍⴻⴼⴹⵉⵃⴻⵜ-ⴰ ⴷⵉ ⵉⵙⵔⴰⵉⵍ ⵓⵎⵉ ⵉⵟⵟⴻⵚ ⴰⴽ-ⴷ ⵢⴻⴵⵉⵙ ⵏ ⵢⴰⵄⵇⵓⴱ. ⵎⴰⵏ ⴰⵢⴰ ⵡⴰⵔ ⵉⵛⵓⵡⵡⴰⵔ ⴰⴷ ⵜ ⵢⴻⴳⴳ. ");
INSERT INTO rift_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","ⵉⵙⵙⵉⵡⴻⵍ ⵃⴰⵎⵓⵔ ⴰⴽⵉⴷⵙⴻⵏ, ⵉⵏⵏⴰ: “ⵍⴻⵄⵎⴰⵔ ⵏ ⵎⵎⵉ ⵛⴰⴽⵉⵎ ⵉⵇⵇⴻⵏ ⵖⴰⵔ ⵢⴻⴵⵉⵜⵡⴻⵎ, ⵜⵜⵣⴰⵡⴰⴳⴻⵖ, ⴰⴷ ⴰⵙ ⵜⵜ ⵜⴻⵡⵛⴻⵎ ⴷ ⵜⴰⵎⵖⴰⵔⵜ, ");
INSERT INTO rift_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","ⵓⵛⴰ ⴰⴷ ⵏⴻⵎⴹⴻⴳⴳⵡⴰⵍ. ⴰⴷ ⴰⵏⴻⵖ ⵜⴻⵡⵛⴻⵎ ⵢⴻⴵⵉⵜⵡⴻⵎ, ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⵜⴻⴽⵙⵉⵎ ⵢⴻⵙⵙⵉⵜⵏⴻⵖ ⵉ ⵢⵉⵅⴻⴼ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","ⵣⴻⴷⵖⴻⵎ ⴰⴽⵉⴷⵏⴻⵖ, ⵎⵉⵏⵣⵉ ⵜⴰⵎⵎⵓⵔⵜ ⴰⵇⴰ-ⵜⵜ ⵣⵣⴰⵜⵡⴻⵎ. ⵣⴻⴷⵖⴻⵎ ⵓ ⵓⵢⵓⵔⴻⵎ ⴷⴰⵢⴻⵙ ⵓⵛⴰ ⵟⵟⴼⴻⵎ ⴷⴰⵢⴻⵙ ⴰⴳⵍⴰ ⵉ ⴽⴻⵏⵏⵉⵡ.” ");
INSERT INTO rift_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","ⵓⵛⴰ ⵉⵏⵏⴰ ⵛⴰⴽⵉⵎ ⵄⴰⵡⴻⴷ ⵉ ⴱⴰⴱⴰⵙ ⴷ ⴰⵢⵜⵎⴰⵙ: “ⴻⵊⵊ ⴰⵢⵉ ⴰⴷ ⴰⴼⴻⵖ ⴰⵔⴹⴰ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵡⴻⵎ ⵓⵛⴰ ⴰⴷ ⵡⵛⴻⵖ ⵎⵉⵏ ⴷ ⴰⵢⵉ ⵖⴰ ⵜⵉⵏⵉⵎ. ");
INSERT INTO rift_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","ⵡⴰⵅⵅⴰ ⴰⴷ ⵜⴻⵙⵙⴹⴻⵇⵍⴻⵎ ⵅⴰⴼⵉ ⵍⴻⵃⵎⴻⵍ ⴰⵟⵟⴰⵙ ⵏ ⵚⵚⴰⴷⴰⵇ ⴷ ⵙⵙⵓⵏⴰⵏ, ⴰⵇⴰ ⵏⴻⵛⵛ ⴰⴷ ⵡⵛⴻⵖ ⵎⴻⵛⵃⴰⵍ ⵎⴰ ⴷ ⴰⵢⵉ ⵖⴰ ⵜⵉⵏⵉⵎ. ⵡⵛⴻⵎ ⴰⵢⵉ ⵎⵖⵉⵔ ⵜⴰⴱⵍⵉⵖⵜ ⴷ ⵜⴰⵎⵖⴰⵔⵜ.” ");
INSERT INTO rift_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","ⴰⵔⵔⵉⵏ-ⴷⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵢⴰⵄⵇⵓⴱ ⵅ ⵛⴰⴽⵉⵎ ⴷ ⵃⴰⵎⵓⵔ, ⴱⴰⴱⴰⵙ, ⵙ ⵉⵛⵜ ⵏ ⵜⴻⵃⵔⴰⵢⵎⴻⵛⵜ, ⵎⵉⵏⵣⵉ ⴰⵇⴰ ⵉⵙⵙⴻⵅⵙⴰⵔ ⴷⵉⵏⴰ, ⵓⵍⵜⵎⴰⵜⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","ⵏⵉⵜⵏⵉ ⵙⵙⵉⵡⵍⴻⵏ, ⵏⵏⴰⵏ ⴰⵙⴻⵏ: “ⵡⴰⵔ ⵏⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵏⴻⴳⴳ ⴰⵎⵎⵓ, ⴰⴷ ⵏⴻⵡⵛ ⵓⵍⵜⵎⴰⵜⵏⴻⵖ ⵉ ⵡⴻⵔⵢⴰⵣ ⵏⵏⵉ ⵄⴰⴷ ⵙ ⵍⴻⵄⴷⴰⵍⵢⴻⵜ. ⴷⴻⴳⴳⴰ ⴷ ⵍⵄⴰⵔ ⵅⴰⵏⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","ⵎⵖⵉⵔ ⵙ ⵓⵎⵜⴰⵡⵉ-ⵢⴰ ⵡⴰⵀⴰ ⴰⴷ ⴽⴻⵏⵏⵉⵡ ⵏⵙⴻⵄⵄⴻⴼ, ⵎⴰⵍⴰ ⵜⴻⴳⴳⵉⵎ ⴰⵎ ⵏⴻⵛⵛⵉⵏ, ⴰⴷ ⵜᵉⵜⵜⵡⴰⵅⴻⵜⵏⴻⵎ ⵎⴰⵔⵔⴰ ⵉⵡⴻⵜⵎⴰⵏ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","ⵅⴻⵏⵏⵉ ⴰⴷ ⴰⵡⴻⵎ ⵏⴻⵡⵛ ⵢⴻⴵⵉⵜⵏⴻⵖ ⵓⵛⴰ ⴰⴷ ⵏⴻⴽⵙⵉ ⵢⴻⵙⵙⵉⵜⵡⴻⵎ, ⴰⴷ ⴽⵉⴷⵡⴻⵏ ⵏⴻⵣⴷⴻⵖ, ⴰⴷ ⵏⵉⵍⵉ ⴷ ⵉⵊⵊ ⵏ ⵍⴳⴻⵏⵙ. ");
INSERT INTO rift_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⵡⴰⵔ ⴷ ⴰⵏⴻⵖ ⵜⴻⵙⵍⵉⵎ ⴷⵉ ⵜⵎⴻⵙⵍⴰⵛⵜ ⵏ ⵡⴻⵅⵜⴰⵏ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵏⴻⴽⵙⵉ ⵢⴻⴵⵉⵜⵏⴻⵖ ⵓⵛⴰ ⴰⴷ ⵏⵓⵢⵓⵔ.” ");
INSERT INTO rift_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","ⴱⴰⵏⴻⵏ ⵡⴰⵡⴰⵍⴻⵏ ⵏⵙⴻⵏ ⵎⵍⵉⵃ ⴷⴻⴳ ⵉⵎⴻⵣⵣⵓⵖⴻⵏ ⵏ ⵃⴰⵎⵓⵔ ⵓ ⴷⴻⴳ ⵉⵎⴻⵊⵊⴰⵏ ⵏ ⵛⴰⴽⵉⵎ, ⵎⵎⵉⵙ ⵏ ⵃⴰⵎⵓⵔ. ");
INSERT INTO rift_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","ⴰⵄⴻⵣⵔⵉ ⵡⴰⵔ ⴷ ⴰⵙ ⵉⵛⵇⵉ ⴰⴷ ⵉⴳⴳ ⵎⴰⵏ ⴰⵢⴰ, ⵎⵉⵏⵣⵉ ⵏⴻⵜⵜⴰ ⵉⵜⵜⴻⵅⵙ ⴰⵟⵟⴰⵙ ⵢⴻⴵⵉⵙ ⵏ ⵢⴰⵄⵇⵓⴱ ⵓ ⵏⴻⵜⵜⴰ ⵜⵓⵖⴰ-ⵜ ⵇⴰⵄ ⵎⵡⴻⵇⵇⴰⵔ ⴷⵉ ⵎⴰⵔⵔⴰ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⴱⴰⴱⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","ⵓⵛⴰ ⵓⵙⵉⵏ-ⴷⴷ ⵃⴰⵎⵓⵔ ⴷ ⵎⵎⵉⵙ ⵛⴰⴽⵉⵎ ⵖⴰⵔ ⵜⴻⵡⵡⴰⵔⵜ ⵏ ⵜⴻⵏⴷⵉⵏⵜ ⵏⵏⴻⵙ, ⵙⵙⵉⵡⵍⴻⵏ ⴰⴽ-ⴷ ⵢⴻⵔⵢⴰⵣⴻⵏ ⵏ ⵜⴻⵏⴷⵉⵏⵜ, ⵏⵏⴰⵏ: ");
INSERT INTO rift_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“ⵉⵔⵢⴰⵣⴻⵏ-ⴰ ⴷ ⵉⵎⵀⵓⴷⵏⴻⵏ ⴰⴽⵉⴷⵏⴻⵖ. ⴻⵊⵊ ⴰⵏⴻⵖ ⴰⴷ ⵜⴻⵏ ⵏⴻⵊⵊ ⴰⴷ ⵣⴻⴷⵖⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ-ⴰ ⵓⵛⴰ ⴰⴷ ⴷⴰⵢⴻⵙ ⵓⵢⵓⵔⴻⵏ. ⵅⵣⴰⵔ, ⵜⴰⵎⵎⵓⵔⵜ ⵜⴻⵡⵙⴻⵄ ⵉ ⵏⵉⵜⵏⵉ ⵖⴰⵔ ⵎⴰⵔⵔⴰ ⵉⵖⴻⵣⴷⵉⵙⴻⵏ ⵏⵏⴻⵙ. ⵏⴻⵛⵛⵉⵏ ⴰⴷ ⵏⴻⴽⵙⵉ ⵢⴻⵙⵙⵉⵜⵙⴻⵏ ⴷ ⵜⵉⵎⵖⴰⵔⵉⵏ, ⴰⴷ ⴰⵙⴻⵏ ⵏⴻⵡⵛ ⵢⴻⵙⵙⵉⵜⵏⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","ⵎⴰⵛⴰ ⵙ ⵓⵎⵜⴰⵡⵉ-ⵢⴰ ⵡⴰⵀⴰ ⴰⴷ ⵙⴻⵄⵄⴼⴻⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ-ⴰ, ⵃⵉⵎⴰ ⴰⴷ ⴽⵉⴷⵏⴻⵖ ⵣⴻⴷⵖⴻⵏ ⵓ ⵃⵉⵎⴰ ⴰⴷ ⴷⴻⵡⵍⴻⵏ ⴷ ⵉⵊⵊ ⵏ ⵍⴳⴻⵏⵙ ⴰⴽⵉⴷⵏⴻⵖ, ⵎⴰⵍⴰ ⵎⴰⵔⵔⴰ ⵉⵔⵢⴰⵣⴻⵏ ⵉ ⵉⴵⴰⵏ ⵊⴰⵔ ⴰⵏⴻⵖ ⴰⴷ ⵜⵜⵡⴰⵅⴻⵜⵏⴻⵏ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⵜⵡⴰⵅⴻⵜⵏⴻⵏ ⵏⵉⵜⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏⵙⴻⵏ ⴷ ⴰⴳⵍⴰ ⵏⵙⴻⵏ ⴷ ⵎⴰⵔⵔⴰ ⵍⵎⴰⵍ ⵏⵙⴻⵏ, ⵎⴰ ⵡⴰⵔ ⵜⵜⵉⵍⵉⵏ ⵏⵏⴻⵖ? ⴻⵊⵊ ⴰⵏⴻⵖ ⴰⴷ ⵜⴻⵏ ⵏⵙⴻⵄⵄⴻⴼ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵣⴻⴷⵖⴻⵏ ⴰⴽⵉⴷⵏⴻⵖ.” ");
INSERT INTO rift_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","ⵎⴰⵔⵔⴰ ⵉⵏⵏⵉ ⴷⴷ-ⵢⵓⵙⵉⵏ ⵖⴰⵔ ⵜⴻⵡⵡⴰⵔⵜ ⵏ ⵜⴻⵏⴷⵉⵏⵜ ⵏⵏⴻⵙ ⵙⵍⵉⵏ ⵉ ⵃⴰⵎⵓⵔ ⴷ ⵎⵎⵉⵙ ⵛⴰⴽⵉⵎ ⵓⵛⴰ ⵎⴰⵔⵔⴰ ⵉⵔⵢⴰⵣⴻⵏ ⵉⵏⵏⵉ ⴷⴷ-ⵢⵓⵙⵉⵏ ⵖⴰⵔ ⵜⴻⵡⵡⴰⵔⵜ ⵏ ⵜⴻⵏⴷⵉⵏⵜ ⵏⵏⴻⵙ, ⵜⵜⵡⴰⵅⴻⵜⵏⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","ⵓⵎⵉ ⵜⵓⵖⴰ ⵄⴰⴷ ⴷⴰⵢⵙⴻⵏ ⵍⴻⵀⵔⵉⵇ ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵜⵍⴰⵜⴰ, ⵜⴻⵎⵙⴰⵔ ⴱⴻⵍⵍⵉ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵢⴰⵄⵇⵓⴱ, ⵛⵉⵎⵄⵓⵏ ⴷ ⵍⴰⵡⵉ, ⴰⵢⵜⵎⴰⵙ ⵏ ⴷⵉⵏⴰ, ⴰⵇⴰ ⴽⵓⵍ ⵉⵊⵊ ⵣⵣⴰⵢⵙⴻⵏ ⵉⴽⵙⵉ ⵙⵙⵉⴼ ⵏⵏⴻⵙ ⵓⵛⴰ ⵔⵓⵃⴻⵏ ⵖⴰⵔ ⵜⴻⵏⴷⵉⵏⵜ ⵎⴰⵏⵉ ⴷ ⴰⵙⴻⵏ ⵉⵜⵜⵖⵉⵍ ⴰⵇⴰ ⴷⴰⵢⴻⵙ ⵍⴰⵎⴰⵏ ⵓⵛⴰ ⵏⵖⵉⵏ ⵎⴰⵔⵔⴰ ⵉⵔⵢⴰⵣⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","ⵏⵖⵉⵏ ⵃⴰⵎⵓⵔ ⴷ ⵎⵎⵉⵙ ⵛⴰⴽⵉⵎ ⵙ ⵍⴻⵇⴹⴻⵄ ⵏ ⵙⵙⵉⴼ ⵓⵛⴰ ⴽⵙⵉⵏ ⴷⵉⵏⴰ ⵣⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵛⴰⴽⵉⵎ, ⴼⴼⵖⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","ⵜⴰⵔⵡⴰ ⵏ ⵢⴰⵄⵇⵓⴱ ⵓⵙⵉⵏ-ⴷⴷ ⵖⴰⵔ ⵢⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵏⵖⴻⵏ ⵓⵛⴰ ⴽⴻⵛⵛⴹⴻⵏ ⵜⴰⵏⴷⵉⵏⵜ, ⵎⵉⵏⵣⵉ ⵏⵉⵜⵏⵉ ⵙⵙⴻⵅⵙⴰⵔⴻⵏ ⵓⵍⵜⵎⴰⵜⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","ⴽⵙⵉⵏ ⵓⴵⵉ ⵏⵙⴻⵏ ⴷ ⵉⴼⵓⵏⴰⵙⴻⵏ ⴷ ⵜⴼⵓⵏⴰⵙⵉⵏ ⵏⵙⴻⵏ ⴷ ⵢⴻⵖⵢⴰⵍ ⵏⵙⴻⵏ ⴷ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵜⵓⵖⴰ ⴷⵉ ⵜⴻⵏⴷⵉⵏⵜ ⵓ ⴷⴻⴳ ⵉⵢⵢⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","ⴽⵙⵉⵏ ⵎⴰⵔⵔⴰ ⴰⴳⵍⴰ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⵡⵢⴻⵏ-ⴷⴷ ⵎⴰⵔⵔⴰ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⴷ ⵜⴻⵎⵖⴰⵔⵉⵏ ⵏⵙⴻⵏ ⴷ ⵉⵎⴻⵃⴱⴰⵙ ⵓⵛⴰ ⵓⵛⴰⵔⴻⵏ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵜⵓⵖⴰ ⴷⵉ ⵜⵓⴷⵔⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵢⴰⵄⵇⵓⴱ ⵉ ⵛⵉⵎⵄⵓⵏ ⴷ ⵍⴰⵡⵉ: “ⴽⴻⵏⵏⵉⵡ ⵜⴻⵙⵙⵉⴷⴼⴻⵎ ⴰⵢⵉ ⴷⴻⴳ ⵉⵎⵅⵓⵎⴱⴰⵔ ⴰⵍⴰⵎⵉ ⴷ ⴰⵢⵉ ⵜⴻⵙⵙⴰⵔⵣⴳⴻⵎ ⵖⴰⵔ ⵉⵎⴻⵣⴷⴰⵖ ⵏ ⵜⴻⵎⵎⵓⵔⵜ-ⴰ, ⵖⴰⵔ ⴰⵢⵜ ⵏ ⴽⴻⵏⵄⴰⵏ ⴷ ⵉⴼⵉⵔⵉⵣⵉⵢⵢⴻⵏ. ⴷ ⵏⴻⵛⵛ ⵖⴰⵔⵉ ⵉⵊⵊ ⵏ ⵡⵓⵔⵓ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ ⵡⴰⵀⴰ. ⵎⴰⵍⴰ ⴰⴷ ⵎⵓⵏⴻⵏ ⵅ ⵓⵣⴻⵍⵎⴰⴹ ⵉⵏⵓ, ⴰⴷ ⴰⵢⵉ ⵇⴻⵥⵥⵔⴻⵏ, ⴰⴷ ⵉⵍⵉⵖ ⴰⵔⴻⵢⵢⵜⴻⵖ, ⵏⴻⵛⵛ ⴷ ⵜⴰⴷⴷⴰⵔⵜ ⵉⵏⵓ.” ");
INSERT INTO rift_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","ⵏⵉⵜⵏⵉ ⵏⵏⴰⵏ: “ⵎⴰ ⵉⵄⴻⴷⴷⴻⵍ ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⵃⵙⴻⴱ ⵓⵍⵜⵎⴰⵜⵏⴻⵖ ⴰⵎⴻⵛⵏⴰⵡ ⵉⵛⵜ ⵏ ⵍⴼⴰⵙⴷⴰ?” ");
INSERT INTO rift_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","ⵓⵛⴰ ⵉⵏⵏⴰ ⴰⵔⴻⴱⴱⵉ ⵉ ⵢⴰⵄⵇⵓⴱ: “ⴽⴽⴰⵔ, ⴳⴻⵄⵄⴻⴷ ⵖⴰⵔ ⴱⴰⵢⵜ-ⵉⵍ ⵓⵛⴰ ⵇⵇⵉⵎ ⴷⵉⵏ. ⴻⴳⴳ ⴷⵉⵏ ⵉⵊⵊ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ⵎⵉⵏ ⵅⴻⴼ ⵉ ⵖⴰ ⵜⴻⵙⵙⴰⵔⵙⴻⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵉ ⴰⵔⴻⴱⴱⵉ, ⵡⴻⵏⵏⵉ ⴷ ⴰⵛ ⴷⴷ-ⵉⴱⴰⵏⴻⵏ ⵓⵎⵉ ⴷⴷ-ⵜⴰⵔⴻⵡⵍⴻⴷ ⵣⴻⴳ ⵓⵖⴻⵎⴱⵓⴱ ⵏ ⵓⵎⴰⵛ ⵄⵉⵙⵓ.” ");
INSERT INTO rift_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵢⴰⵄⵇⵓⴱ ⵉ ⵍⵡⴰⵛⵓⵏ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⴻⵙ ⵓ ⵉ ⵎⴰⵔⵔⴰ ⵉⵏⵏⵉ ⵜⵓⵖⴰ ⴰⴽⵉⴷⴻⵙ: “ⴽⴽⵙⴻⵎ ⵉⵔⴻⴱⴱⵉⵜⴻⵏ ⵉⵖⵔⵉⴱⴻⵏ ⵏⵏⵉ ⵉⴵⴰⵏ ⵊⴰⵔ ⴰⵡⴻⵎ, ⵙⵉⵣⴻⴷⴳⴻⵎ ⵉⵅⴻⴼ ⵏⵡⴻⵎ ⵓⵛⴰ ⴱⴻⴷⴷⵍⴻⵎ ⴰⵔⵔⵓⴹ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","ⴰⴷ ⵏⴻⴽⴽⴰⵔ, ⴰⴷ ⵏⴳⴻⵄⵄⴻⴷ ⵖⴰⵔ ⴱⴰⵢⵜ-ⵉⵍ. ⵏⴻⵛⵛ ⴰⴷ ⴳⴳⴻⵖ ⴷⵉⵏ ⵉⵊⵊ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ⵉ ⴰⵔⴻⴱⴱⵉ ⵏⵏⵉ ⵅⴰⴼⵉ ⴷⴷ-ⵢⴰⵔⵔⵉⵏ ⴷⴻⴳ ⵡⴰⵙⵙ ⵏ ⵍⴻⵃⵚⴰⵔⴻⵜ ⵉⵏⵓ, ⴷ ⵡⴻⵏⵏⵉ ⵜⵓⵖⴰ ⴰⴽⵉⴷⵉ ⴷⴻⴳ ⵡⴻⴱⵔⵉⴷ ⵏⵏⵉ ⵓⵢⵓⵔⴻⵖ.” ");
INSERT INTO rift_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","ⵓⵛⴰ ⵡⵛⵉⵏ ⵉ ⵢⴰⵄⵇⵓⴱ ⵎⴰⵔⵔⴰ ⵉⵔⴻⴱⴱⵉⵜⴻⵏ ⵉⵖⵔⵉⴱⴻⵏ ⵏⵏⵉ ⵜⵓⵖⴰ ⵖⴰⵔⵙⴻⵏ ⵓⵍⴰ ⴷ ⵜⵉⵅⵔⴰⵣⵉⵏ ⴷⴻⴳ ⵉⵎⴻⵣⵣⵓⵖⴻⵏ ⵏⵙⴻⵏ ⵓⵛⴰ ⵉⴼⴼⴰⵔ ⵉ-ⵜⴻⵏ ⵢⴰⵄⵇⵓⴱ ⵙⴰⴷⵓ ⵜⵛⴻⵊⵊⴰⵔⵜ ⵏ ⵢⵉⴳⴳ ⵉ ⵜⵓⵖⴰ ⵣⵣⴰⵜ ⵉ ⵛⴰⴽⵉⵎ. ");
INSERT INTO rift_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","ⵍⴰⵎⵉ ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ, ⵓⵢⵓⵔⴻⵏ ⵙⵙⴻⵏⵏⵉ, ⵜⵓⵖⴰ ⵜⵉⴳⴳⵯⵓⴷⵉ ⵏ ⴰⵔⴻⴱⴱⵉ ⵅ ⵜⵏⴻⴷⴷⴰⵎ ⵏⵏⵉ ⵜⵓⵖⴰ ⴷⵉ ⵊⵊⵡⴰⵢⴻⵀ ⵉ ⴷ ⴰⵙⴻⵏ ⴷⴷ-ⵉⵏⵏⴹⴻⵏ, ⴰⵍⴰⵎⵉ ⵏⵉⵜⵏⵉ ⵡⴰⵔ ⴹⴻⴼⴼⴰⵔⴻⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵢⴰⵄⵇⵓⴱ. ");
INSERT INTO rift_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","ⴰⵎⵎⵓ ⵉ ⵢⵉⵡⴻⴹ ⵢⴰⵄⵇⵓⴱ ⵖⴰⵔ ⵍⵓⵣ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ, ⴰⵇⴰ-ⵜⵜ ⴷ ⴱⴰⵢⵜ-ⵉⵍ, ⵏⴻⵜⵜⴰ ⴷ ⵎⴰⵔⵔⴰ ⵍⴳⴻⵏⵙ ⵉ ⵜⵓⵖⴰ ⴰⴽⵉⴷⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","ⵉⴱⵏⴰ ⴷⵉⵏ ⵉⵊⵊ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ⵓⵛⴰ ⵉⵍⴰⵖⴰ ⵉ ⵡⴻⵎⵛⴰⵏ ⵏⵏⵉ ⵉⵍ-ⴱⴰⵢⵜ-ⵉⵍ, ⵎⵉⵏⵣⵉ ⴷⵉⵏⵏⵉ ⵉ ⴷ ⴰⵙ ⴷⴷ-ⵉⴹⵀⴰⵔ ⴰⵔⴻⴱⴱⵉ, ⵓⵎⵉ ⴷⴷ-ⵢⴰⵔⵡⴻⵍ ⵣⴻⴳ ⵓⵖⴻⵎⴱⵓⴱ ⵏ ⵓⵎⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","ⵜⴻⵎⵎⵓⵜ ⴷⵉⴱⵓⵔⴰ, ⵜⴰⵎⴻⵙⵙⴻⵟⵟⴰⴹⵜ ⵏ ⵔⵉⴼⵇⴰ ⵓⵛⴰ ⵏⴻⴹⵍⴻⵏ ⵜⵜ ⵙⵡⴰⴷⴷⴰⵢ ⵉ ⴱⴰⵢⵜ-ⵉⵍ, ⵙⴰⴷⵓ ⵜⴰⴱⴻⴵⵓⴹⵜ ⵓⵛⴰ ⵉⵍⴰⵖⴰ ⵉⵙⴻⵎ ⵏⵏⴻⵙ ‘ⴰⵍⵍⵓⵏ-ⴱⴰⴽⵓⵜ’, ⴰⵇⴰ-ⵜⵜ ⴷ ‘ⵜⴰⴱⴻⴵⵓⴹⵜ ⵏ ⵉⵎⴻⵟⵟⴰⵡⴻⵏ’. ");
INSERT INTO rift_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","ⵉⴹⵀⴰⵔ ⴰⵙ-ⴷⴷ ⵄⴰⵡⴻⴷ ⴰⵔⴻⴱⴱⵉ ⵉ ⵢⴰⵄⵇⵓⴱ ⵓⵎⵉ ⴷⴷ-ⵉⴷⵡⴻⵍ ⵣⵉ ⴼⴰⴷⴰⵏ-ⴰⵔⴰⵎ ⵓⵛⴰ ⵉⴱⴰⵔⴽ ⵉ-ⵜ. ");
INSERT INTO rift_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","ⵉⵏⵏⴰ ⴰⵙ ⴰⵔⴻⴱⴱⵉ: “ⵉⵙⴻⵎ ⵏⵏⴻⵛ ⴷ ⵢⴰⵄⵇⵓⴱ. ⵣⵉ ⵙⵙⴰ ⴷ ⵜⵙⴰⵡⴻⵏⵜ ⵡⴰⵔ ⵜⵜⴻⴳⴳⴻⵏ ⵄⴰⴷ ⵉⵙⴻⵎ ⵏⵏⴻⵛ ‘ⵢⴰⵄⵇⵓⴱ’, ⵎⴰⵛⴰ ‘ⵉⵙⵔⴰⵉⵍ’, ⴷ ⵡⴰ ⵉ ⵖⴰ ⵢⵉⵍⵉⵏ ⴷ ⵉⵙⴻⵎ ⵏⵏⴻⵛ.” ⵓⵛⴰ ⵉⵙⴻⵎⵎⴰ ⵜ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","ⵉⵏⵏⴰ ⴰⵙ ⴰⵔⴻⴱⴱⵉ: “ⵏⴻⵛⵛ ⴷ ⴰⵔⴻⴱⴱⵉ, ⴰⵎⵣⴻⵎⵎⴰⵔ ⵅ ⴽⵓⵍⵛⵉ! ⴻⴳⴳ ⵍⵖⵉⴵⴻⵜ, ⵎⵎⴰⵔⵏⵉⵢ! ⵣⵣⴰⵢⴻⴽ ⵉ ⵖⴰ ⵉⴼⴼⴻⵖ ⵉⵊⵊ ⵏ ⵍⴳⴻⵏⵙ, ⵡⴰⵀ, ⴷ ⵉⵊⵊ ⵏ ⵡⴻⴳⵔⴰⵡ ⵏ ⵍⴻⴳⵏⵓⵙ ⴰⴷ ⴼⴼⵖⴻⵏ ⵣⵣⴰⵢⴻⴽ ⵓ ⵉⵊⴻⴵⵉⴷⴻⵏ ⴰⴷ ⴼⴼⵖⴻⵏ ⵣⵉ ⵜⴻⵊⵄⵉⵏⵏⴰ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","ⵓⵛⴰ ⵜⴰⵎⵎⵓⵔⵜ-ⴰ ⵉ ⵡⵛⵉⵖ ⵉ ⵉⴱⵔⴰⵀⵉⵎ ⴷ ⵉⵙⵃⴰⵇ, ⵉ ⵛⴻⴽ ⵓⵎⵉ ⵜⵜ ⵉ ⵖⴰ ⵡⵛⴻⵖ ⵓⵛⴰ ⵓⵍⴰ ⵉ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵛ ⴰⵡⴰⵔⵏⵉ ⴰⵛ ⴰⴷ ⵡⵛⴻⵖ ⵜⴰⵎⵎⵓⵔⵜ.” ");
INSERT INTO rift_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","ⵅⴰⵙ ⵓⵛⴰ ⵉⴳⴻⵄⵄⴻⴷ ⴰⵔⴻⴱⴱⵉ ⵙⴻⵏⵏⴻⵊ ⵣⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵎⴰⵏⵉ ⴽⵉⴷⴻⵙ ⵉⵙⵙⵉⵡⴻⵍ. ");
INSERT INTO rift_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","ⵢⴰⵄⵇⵓⴱ ⵉⵙⵙⴳⴻⵄⵄⴻⴷ ⵉⵊⵊ ⵏ ⵡⴻⵥⵔⵓ ⵏ ⵍⵉⴷⴰⵔⴻⵜ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵎⴰⵏⵉ ⴽⵉⵙ ⵉⵙⵙⵉⵡⴻⵍ, ⵉⵊⵊ ⵏ ⵡⴻⵥⵔⵓ ⵏ ⵍⵉⴷⴰⵔⴻⵜ. ⵉⵙⴻⵢⵢⴻⴱ ⵅⴰⵙ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵓⵙⴻⵢⵢⴻⴱ ⵓⵛⴰ ⵉⴼⴰⵔⵔⴻⵖ ⵣⵣⴻⵛⵜ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","ⵉⴳⴳⴰ ⵢⴰⵄⵇⵓⴱ ⵉⵙⴻⵎ ⵏ ⵡⴻⵎⵛⴰⵏ ⵎⴰⵏⵉ ⴽⵉⴷⴻⵙ ⵉⵙⵙⵉⵡⴻⵍ ⴰⵔⴻⴱⴱⵉ ‘ⴱⴰⵢⵜ-ⵉⵍ!’ ");
INSERT INTO rift_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","ⴼⴻⵙⵢⴻⵏ ⵏⵉⵜⵏⵉ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⴱⴰⵢⵜ-ⵉⵍ ⵓⵛⴰ ⵓⵎⵉ ⵜⵓⵖⴰ ⵜⵜⴻⴳⴳⵡⵉⵊⴻⵏ ⵎⵖⵉⵔ ⵛⵡⴰⵢⵜ ⵅ ⵉⴼⵔⴰⵜⴰ, ⵅⴻⵏⵏⵉ ⵜⵓⵔⵓⵡ-ⴷⴷ ⵔⴰⵃⵉⵍ ⵓ ⵜⴻⵄⴷⵓ ⵅⴰⵙ ⵜⴰⵔⵡⴰ ⵜⴻⵇⵙⴻⵃ. ");
INSERT INTO rift_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","ⵉⵎⵙⴰⵔ, ⵓⵎⵉ ⵜⴻⵖⵖⵓⴹⴻⴷ ⴷⵉ ⵜⴰⵔⵡⴰ ⵏⵏⴻⵙ, ⵜⴻⵏⵏⴰ ⴰⵙ ⵍⵇⴰⴱⵍⴰ: “ⵡⴰⵔ ⵜⵜⴻⴳⴳⵯⴻⴷ, ⴰⵇⴰ ⵡⴰ ⵄⴰⵡⴻⴷ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵎⵎⵉⵎ!” ");
INSERT INTO rift_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","ⵍⴰⵎⵉ ⵜⴻⴹⵍⴻⵇ ⵉ ⴱⵓⵃⴱⴻⵍ ⴰⵎ ⵜⴻⵎⵎⵓⵜ ⴷⵉⵏ, ⴰⵇⴰ ⵜⵍⴰⵖⴰ ⴰⵙ ⴱⵉⵏ-ⵓⵏⵉ, ⵉⵙⴻⵎ-ⴰ ⵉⵅⵙ ⴰⴷ ⵢⵉⵏⵉ ‘ⵎⵎⵉⵙ ⵏ ⵍⴻⵃⵔⵉⵇ ⵉⵏⵓ’, ⵎⴰⵛⴰ ⴱⴰⴱⴰⵙ ⵉⵍⴰⵖⴰ ⴰⵙ ⴱⵉⵏⵢⴰⵎⵉⵏ, ⵉⵅⵙ ⴰⴷ ⵢⵉⵏⵉ ‘ⵎⵎⵉⵙ ⵏ ⵣⵣⵀⴰⵔ ⵉⵏⵓ’. ");
INSERT INTO rift_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","ⴰⵎⵎⵓ ⵉ ⵜⴻⵎⵎⵓⵜ ⵔⴰⵃⵉⵍ ⵓⵛⴰ ⵏⴻⴹⵍⴻⵏⵜ ⵜⵜ ⴷⴻⴳ ⵡⴻⴱⵔⵉⴷ ⵖⴰⵔ ⵉⴼⵔⴰⵜⴰ, ⵉⵅⵙ ⴰⴷ ⵢⵉⵏⵉ ⴱⴰⵢⵜ-ⵍⴰⵃⵎ. ");
INSERT INTO rift_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","ⵓⵛⴰ ⵉⴳⴳⴰ ⵢⴰⵄⵇⵓⴱ ⵉⵊⵊ ⵏ ⵡⴻⵥⵔⵓ ⵏ ⵍⵉⴷⴰⵔⴻⵜ ⵅ ⵡⴻⵏⴹⴻⵍ ⵏⵏⴻⵙ. ⴷ ⵡⴰ ⴷ ⴰⵥⵔⵓ ⵏ ⵍⵉⴷⴰⵔⴻⵜ ⵏ ⵔⴰⵃⵉⵍ ⵅ ⵡⴻⵏⴹⴻⵍ ⵏ ⵔⴰⵃⵉⵍ ⴰⵍ ⴰⵙⵙ-ⴰ. ");
INSERT INTO rift_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","ⵅⴰⵙ ⵓⵛⴰ ⵉⴼⵙⵉ ⵉⵙⵔⴰⵉⵍ ⵉⵇⵉⴹⴰⵏ ⵓⵛⴰ ⵉⵡⵜⴰ ⴰⵇⵉⴹⵓⵏ ⵏⵏⴻⵙ ⵅ ⵓⵄⴻⴷⴷⵓ ⵏ ⵎⴰⵊⴷⴰⵍ-ⵄⵉⴷⵔ. ");
INSERT INTO rift_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","ⵓⵎⵉ ⵉⵣⴷⴻⵖ ⵉⵙⵔⴰⵉⵍ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⵉ, ⵉⵎⵙⴰⵔ ⴱⴻⵍⵍⵉ ⵔⵓⴱⵉⵏ ⵉⵔⵓⵃ ⵉⵟⵟⴻⵚ ⴰⴽ-ⴷ ⴱⵉⵍⵀⴰ, ⵜⴰⵢⵢⴰ ⵏ ⴱⴰⴱⴰⵙ, ⵓⵛⴰ ⵢⵉⵡⴻⴹ ⴰⴷ ⵜ ⵉⴼⵀⴻⵎ ⵉⵙⵔⴰⵉⵍ. ⴰⵇⴰ ⵍⴻⵅⵅⵓ ⵉⵡⴹⴻⵏ ⴰⵢⵜ ⵏ ⵢⴰⵄⵇⵓⴱ ⵜⴻⵏⵄⴰⵛ. ");
INSERT INTO rift_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","ⵜⴰⵔⵡⴰ ⵏ ⵍⵉⵢⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ: ⵔⵓⴱⵉⵏ, ⴰⵎⴻⵏⵣⵓ ⵏ ⵢⴰⵄⵇⵓⴱ ⴷ ⵛⵉⵎⵄⵓⵏ ⴷ ⵍⴰⵡⵉ ⴷ ⵢⴰⵀⵓⴷⴰ ⴷ ⵉⵙⵙⴰⴽⴰⵔ ⴷ ⵣⴰⴱⵓⵍⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","ⵜⴰⵔⵡⴰ ⵏ ⵔⴰⵃⵉⵍ ⵜⵓⵖⴰ ⴰⵜⴻⵏ: ⵢⵓⵙⵓⴼ ⴷ ⴱⵉⵏⵢⴰⵎⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","ⵜⴰⵔⵡⴰ ⵏ ⴱⵉⵍⵀⴰ, ⵜⴰⵢⵢⴰ ⵏ ⵔⴰⵃⵉⵍ, ⵜⵓⵖⴰ ⴰⵜⴻⵏ: ⴷⴰⵏ ⴷ ⵏⴰⴼⵜⴰⵍⵉ. ");
INSERT INTO rift_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","ⵜⴰⵔⵡⴰ ⵏ ⵣⵉⵍⴱⴰ, ⵜⴰⵢⵢⴰ ⵏ ⵍⵉⵢⴰ, ⵜⵓⵖⴰ ⴰⵜⴻⵏ: ⵊⴰⴷ ⴷ ⴰⵛⵉⵔ. ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵢⴰⵄⵇⵓⴱ ⵉⵏⵏⵉ ⴷ ⴰⵙ ⴷⴷ-ⵉⵜⵜⵡⴰⵅⴻⵍⵇⴻⵏ ⴷⵉ ⴼⴰⴷⴰⵏ-ⴰⵔⴰⵎ. ");
INSERT INTO rift_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","ⵓⵛⴰ ⵢⵓⵙⴰ-ⴷⴷ ⵢⴰⵄⵇⵓⴱ ⵖⴰⵔ ⴱⴰⴱⴰⵙ ⵉⵙⵃⴰⵇ ⴷⵉ ⵎⴰⵎⵔⵉ, ⴷⵉ ⵜⴻⵏⴷⵉⵏⵜ ⵏ ⴰⵔⴱⴰⵄ, ⵜⴻⵏⵏⵉ ⵉⴵⴰⵏ ⴷ ⵜⴰⵏⴷⵉⵏⵜ ⵏ ⵃⴰⴱⵔⵓⵏ, ⵎⴰⵏⵉ ⵜⵓⵖⴰ ⵉⴱⵔⴰⵀⵉⵎ ⵉⵣⴻⴷⴷⴻⵖ ⴰⵎ ⵓⴱⴰⵔⵔⴰⵏⵉ, ⵓⵛⴰ ⵉⵙⵃⴰⵇ ⴰⵎⴻⵏⵏⵉ ⴰⵡⴰⵔⵏⵉ ⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","ⵉⴷⴷⴰⵔ ⵉⵙⵃⴰⵇ ⵎⵢⴰ ⵓ-ⵜⵎⴰⵏⵢⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","ⵉⴹⵍⴻⵇ ⵉⵙⵃⴰⵇ ⵉ ⴱⵓⵃⴱⴻⵍ, ⵉⵎⵎⵓⵜ ⵓⵛⴰ ⵉⵎⵎⴰⵔⵏⵉ ⵖⴰⵔ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ, ⵉⵡⵙⴰⵔ, ⵉⵊⵊⵉⵡⴻⵏ ⵣⵉ ⵜⵓⴷⴰⵔⵜ, ⵓⵛⴰ ⵄⵉⵙⵓ ⴷ ⵢⴰⵄⵇⵓⴱ, ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ, ⵏⴻⴹⵍⴻⵏ ⵜ. ");
INSERT INTO rift_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","ⵉⵏⴰ ⴷ ⵉⵎⴻⵣⵔⵓⵢⴻⵏ ⵏ ⵢⵉⵏⵏⵉ ⴷⴷ-ⵉⵜⵜⵡⴰⵅⴻⵍⵇⴻⵏ ⵣⵉ ⵄⵉⵙⵓ, ⵡⴻⵏⵏⵉ ⵉⴵⴰⵏ ⴷ ⵉⴷⵓⵎ. ");
INSERT INTO rift_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","ⵄⵉⵙⵓ ⵉⴽⵙⵉ ⵜⵉⵎⵖⴰⵔⵉⵏ ⵏⵏⴻⵙ ⵣⴻⴳ ⵢⴻⵙⵙⵉⵙ ⵏ ⴽⴻⵏⵄⴰⵏ: ⵄⴰⴷⴰ, ⵢⴻⴵⵉⵙ ⵏ ⵉⵍⵓⵏ, ⴰⵃⵉⵜⵜⵉ, ⴷ ⴰⵀⵓⵍⵉⴱⴰⵎⴰ, ⵢⴻⴵⵉⵙ ⵏ ⵄⴰⵏⴰ, ⵢⴻⴵⵉⵙ ⵏ ⵚⴰⴱⵄⵓⵏ, ⴰⵃⵉⵡⵉ, ");
INSERT INTO rift_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ⴷ ⴱⴰⵙⵎⴰⵜ, ⵢⴻⴵⵉⵙ ⵏ ⵉⵙⵎⴰⵄⵉⵍ, ⵓⵍⵜⵎⴰⵙ ⵏ ⵏⴰⴱⴰⵢⵓⵜ. ");
INSERT INTO rift_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","ⵄⴰⴷⴰ ⵜⵓⵔⵓⵡ-ⴷⴷ ⵉⵍⵉⴼⴰⵣ ⵉ ⵄⵉⵙⵓ ⵓⵛⴰ ⴱⴰⵙⵎⴰⵜ ⵜⵓⵔⵓⵡ ⴰⵙ-ⴷⴷ ⵔⴰⵄⵓⵡⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ⴰⵀⵓⵍⵉⴱⴰⵎⴰ ⵜⵓⵔⵓⵡ-ⴷⴷ ⵢⴰⵄⵓⵙ ⴷ ⵢⴰⵄⵍⴰⵎ ⴷ ⵇⵓⵔⴰⵃ. ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵄⵉⵙⵓ, ⵉⵏⵏⵉ ⴷ ⴰⵙ ⴷⴷ-ⵢⵓⵔⵡⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","ⵓⵛⴰ ⵉⴽⵙⵉ ⵄⵉⵙⵓ ⵜⵉⵎⵖⴰⵔⵉⵏ ⵏⵏⴻⵙ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ ⴷ ⵢⴻⵙⵙⵉⵙ ⴷ ⵎⴰⵔⵔⴰ ⴰⵢⵜⴱⴰⴱ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⴻⵙ ⵓⵍⴰ ⴷ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏⵏⴻⵙ ⴷ ⵎⴰⵔⵔⴰ ⵍⵎⴰⵍ ⵏⵏⴻⵙ ⴷ ⵎⴰⵔⵔⴰ ⴰⴳⵍⴰ ⵏⵏⴻⵙ ⵏⵏⵉ ⵜⵓⵖⴰ ⴷⴷ-ⵉⴽⵙⴻⴱ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ ⵓⵛⴰ ⵉⵔⵓⵃ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⴻⵖⵏⵉ ⵉ ⵉⴳⴳⵯⴻⵊⴻⵏ ⵅ ⵓⵖⴻⵎⴱⵓⴱ ⵏ ⵓⵎⴰⵙ ⵢⴰⵄⵇⵓⴱ, ");
INSERT INTO rift_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","ⵎⵉⵏⵣⵉ ⴰⴳⵍⴰ ⵏⵙⴻⵏ ⵜⵓⵖⴰ ⵉⵎⵖⴰⵔ ⴰⵍⴰⵎⵉ ⵡⴰⵔ ⵣⴻⵎⵎⴰⵔⴻⵏ ⴰⴷ ⵣⴻⴷⵖⴻⵏ ⵊⵎⵉⵄ, ⵓⵛⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵎⴰⵏⵉ ⵜⵓⵖⴰ ⵣⴻⴷⴷⵖⴻⵏ ⴰⵎ ⵍⴱⴰⵔⵔⴰⵏⵉ, ⵡⴰⵔ ⵜⵇⴻⴷⴷ ⵉ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","ⵅⴻⵏⵏⵉ ⵉⵣⴷⴻⵖ ⵄⵉⵙⵓ ⴷⴻⴳ ⵉⴷⵓⵔⴰⵔ ⵏ ⵙⴰⵄⵉⵔ. ⵄⵉⵙⵓ, ⵏⴻⵜⵜⴰ ⴷ ⵉⴷⵓⵎ. ");
INSERT INTO rift_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","ⵉⵏⴰ ⴷ ⵉⵎⴻⵣⵔⵓⵢⴻⵏ ⵏ ⵢⵉⵏⵏⵉ ⴷⴷ-ⵉⵜⵜⵡⴰⵅⴻⵍⵇⴻⵏ ⵣⵉ ⵄⵉⵙⵓ, ⴱⴰⴱⴰⵙ ⵏ ⵉⴷⵓⵎ, ⴷⴻⴳ ⵉⴷⵓⵔⴰⵔ ⵏ ⵙⴰⵄⵉⵔ. ");
INSERT INTO rift_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵙⵎⴰⵡⴻⵏ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵄⵉⵙⵓ: ⵉⵍⵉⴼⴰⵣ, ⵎⵎⵉⵙ ⵏ ⵄⴰⴷⴰ ⵜⴻⵏⵏⵉ ⴷ ⵜⴰⵎⵖⴰⵔⵜ ⵏ ⵄⵉⵙⵓ, ⵔⴰⵄⵓⵡⵉⵍ, ⵎⵎⵉⵙ ⵏ ⴱⴰⵙⵎⴰⵜ, ⵜⴻⵏⵏⵉ ⴷ ⵜⴰⵎⵖⴰⵔⵜ ⵏ ⵄⵉⵙⵓ. ");
INSERT INTO rift_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵉⵍⵉⴼⴰⵣ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵜⴰⵢⵎⴰⵏ, ⵓⵎⴰⵔ, ⵚⴰⴼⵓ, ⵊⴰⵄⵜⴰⵎ ⴷ ⵇⴰⵏⴰⵣ. ");
INSERT INTO rift_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","ⵜⵉⵎⵏⴰⵄ ⵜⴻⴷⵡⴻⵍ ⴷ ⵜⴰⵢⵢⴰ ⵏ ⵉⵍⵉⴼⴰⵣ, ⵎⵎⵉⵙ ⵏ ⵄⵉⵙⵓ, ⵓ ⵏⴻⵜⵜⴰⵜ ⵜⵓⵔⵓⵡ-ⴷⴷ ⵄⴰⵎⴰⵍⵉⵇ ⵉ ⵉⵍⵉⴼⴰⵣ. ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵄⴰⴷⴰ, ⵜⴰⵎⵖⴰⵔⵜ ⵏ ⵄⵉⵙⵓ. ");
INSERT INTO rift_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵔⴰⵄⵓⵡⵉⵍ: ⵏⴰⵃⴰⵜ, ⵣⴰⵔⴰⵃ, ⵛⴰⵎⵎⴰ ⴷ ⵎⵉⵣⵣⴰ. ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⴱⴰⵙⵎⴰⵜ, ⵜⴻⵏⵏⵉ ⴷ ⵜⴰⵎⵖⴰⵔⵜ ⵏ ⵄⵉⵙⵓ. ");
INSERT INTO rift_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⴰⵀⵓⵍⵉⴱⴰⵎⴰ, ⵜⴻⵏⵏⵉ ⴷ ⵜⴰⵎⵖⴰⵔⵜ ⵏ ⵄⵉⵙⵓ, ⵢⴻⴵⵉⵙ ⵏ ⵄⴰⵏⴰ, ⵜⴻⵏⵏⵉ ⴷ ⵢⴻⴵⵉⵙ ⵏ ⵣⵉⴱⵢⵓⵏ. ⵏⴻⵜⵜⴰⵜ ⵜⵓⵔⵓⵡ-ⴷⴷ ⵢⴰⵄⵓⵛ, ⵊⴰⵄⵍⴰⵎ ⴷ ⵇⵓⵔⴰⵃ ⵉ ⵄⵉⵙⵓ. ");
INSERT INTO rift_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵎⵖⴰⵔⴻⵏ ⵏ ⵜⵇⴻⴱⴱⴰⵍ ⵏ ⴰⵢⵜ ⵏ ⵄⵉⵙⵓ. ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵉⵍⵉⴼⴰⵣ, ⴰⵎⴻⵏⵣⵓ ⵏ ⵄⵉⵙⵓ: ⴰⵎⵖⴰⵔ ⵜⵉⵎⴰⵏ ⴷ ⵓⵎⵖⴰⵔ ⵓⵎⴰⵔ ⴷ ⵓⵎⵖⴰⵔ ⵚⴰⴼⵓ ⴷ ⵓⵎⵖⴰⵔ ⵇⵉⵏⴰⵣ, ");
INSERT INTO rift_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ⴷ ⵓⵎⵖⴰⵔ ⵇⵓⵔⴰⵃ, ⴷ ⵓⵎⵖⴰⵔ ⴳⴰⵜⴰⵎ, ⴷ ⵓⵎⵖⴰⵔ ⵄⴰⵎⴰⵍⵉⵇ. ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵎⵖⴰⵔⴻⵏ ⵏ ⵉⵍⵉⴼⴰⵣ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵉⴷⵓⵎ, ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵄⴰⴷⴰ. ");
INSERT INTO rift_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵔⴰⵄⵓⵡⵉⵍ, ⵎⵎⵉⵙ ⵏ ⵄⵉⵙⵓ: ⴰⵎⵖⴰⵔ ⵏⴰⵃⴰⵜ ⴷ ⵓⵎⵖⴰⵔ ⵣⴰⵔⴰⵃ ⴷ ⵓⵎⵖⴰⵔ ⵙⴰⵎⵎⴰ ⴷ ⵓⵎⵖⴰⵔ ⵎⵉⵣⵣⴰ. ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵎⵖⴰⵔⴻⵏ ⵏ ⵔⴰⵄⵓⵡⵉⵍ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵉⴷⵓⵎ, ⴷ ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⴱⴰⵙⵎⴰⵜ, ⵜⴰⵎⵖⴰⵔⵜ ⵏ ⵄⵉⵙⵓ. ");
INSERT INTO rift_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⴰⵢⵜ ⵏ ⴰⵀⵓⵍⵉⴱⴰⵎⴰ, ⵜⴰⵎⵖⴰⵔⵜ ⵏ ⵄⵉⵙⵓ: ⴰⵎⵖⴰⵔ ⵢⴰⵄⵓⵛ ⴷ ⵓⵎⵖⴰⵔ ⵢⴰⵄⵍⴰⵎ ⴷ ⵓⵎⵖⴰⵔ ⵇⵓⵔⴰⵃ. ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵎⵖⴰⵔⴻⵏ ⵏ ⴰⵀⵓⵍⵉⴱⴰⵎⴰ, ⵜⴰⵎⵖⴰⵔⵜ ⵏ ⵄⵉⵙⵓ, ⵢⴻⴵⵉⵙ ⵏ ⵄⴰⵏⴰ. ");
INSERT INTO rift_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵄⵉⵙⵓ ⴷ ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵎⵖⴰⵔⴻⵏ ⵏ ⵜⵇⴻⴱⴱⴰⵍ ⵏⵙⴻⵏ, ⵏⵉⵜⵏⵉ ⴷ ⵉⴷⵓⵎ. ");
INSERT INTO rift_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵙⴰⵄⵉⵔ, ⴰⵅⵓⵔⵉ, ⵉⵏⵏⵉ ⴷ ⵉⵎⴻⵣⴷⴰⵖ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⵉ: ⵍⵓⵟⴰⵏ, ⵛⵓⴱⴰⵍ, ⵚⴰⴱⵄⵓⵏ, ⵄⴰⵏⴰ, ");
INSERT INTO rift_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","ⴷⵉⵛⵓⵏ, ⵉⵚⴰⵔ ⴷ ⴷⵉⵛⴰⵏ. ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵎⵖⴰⵔⴻⵏ ⵏ ⵜⵇⴻⴱⴱⴰⵍ ⵏ ⵉⵅⵓⵔⵉⵢⵢⴻⵏ, ⴰⵢⵜ ⵏ ⵙⴰⵄⵉⵔ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵉⴷⵓⵎ. ");
INSERT INTO rift_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵍⵓⵟⴰⵏ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⴰⵅⵓⵔⵉ ⴷ ⵀⴰⵢⵎⴰⵎ ⵓⵛⴰ ⵜⵓⵖⴰ ⵜⵉⵎⵏⴰⵄ ⴷ ⵓⵍⵜⵎⴰⵙ ⵏ ⵍⵓⵟⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵛⵓⴱⴰⵍ: ⵄⴰⵍⵡⴰⵏ, ⵎⴰⵏⴰⵃⴰⵜ, ⵄⵉⴱⴰⵍ, ⵛⴰⴼⵓ ⴷ ⵓⵏⴰⵎ. ");
INSERT INTO rift_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵚⴰⴱⵄⵓⵏ: ⴰⵢⴰ ⴷ ⵄⴰⵏⴰ. ⴷ ⵄⴰⵏⴰ ⵡⴰⵏⵉⵜⴰ ⴷ ⵡⴻⵏⵏⵉ ⴷ ⵢⵓⴼⵉⵏ ⵍⵄⵓⵏⵚⴰⵔⴰⵜ ⵙ ⵡⴰⵎⴰⵏ ⵉⵃⵎⴰⵏ ⴷⵉ ⵍⴻⵅⵍⴰ, ⵓⵎⵉ ⵢⴰⵔⵡⴻⵙ ⵉⵖⵢⴰⵍ ⵏ ⵣⵉⴱⵉⵢⵓⵏ ⴱⴰⴱⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵄⴰⵏⴰ: ⵎⵖⵉⵔ ⴷⵉⵛⵓⵏ, ⴷ ⴰⵀⵓⵍⵉⴱⴰⵎⴰ, ⵢⴻⴵⵉⵙ ⵏ ⵄⴰⵏⴰ. ");
INSERT INTO rift_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⴷⵉⵛⴰⵏ: ⵃⴰⵎⴷⴰⵏ ⴷ ⴰⵀⴱⴰⵏ ⴷ ⵢⵉⵜⵔⴰⵏ ⴷ ⴽⴰⵔⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵉⵚⴰⵔ: ⴱⵉⵍⵀⴰⵏ, ⵣⴰⵄⵡⴰⵏ ⴷ ⵄⴰⵇⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⴷⵉⵛⴰⵏ: ⵄⵓⵚ ⴷ ⴰⵔⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵎⵖⴰⵔⴻⵏ ⵏ ⵜⵇⴻⴱⴱⴰⵍ ⵏ ⵉⵅⵓⵔⵉⵢⵢⴻⵏ: ⴰⵎⵖⴰⵔ ⵍⵓⵟⴰⵏ ⴷ ⵓⵎⵖⴰⵔ ⵛⵓⴱⴰⵍ ⴷ ⵓⵎⵖⴰⵔ ⵚⴰⴱⵄⵓⵏ ⴷ ⵓⵎⵖⴰⵔ ⵄⴰⵏⴰ ");
INSERT INTO rift_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","ⴷ ⵓⵎⵖⴰⵔ ⴷⵉⵛⵓⵏ ⴷ ⵓⵎⵖⴰⵔ ⵉⵚⴰⵔ ⴷ ⵓⵎⵖⴰⵔ ⴷⵉⵛⴰⵏ. ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵎⵖⴰⵔⴻⵏ ⵏ ⵉⵅⵓⵔⵉⵢⵢⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵉⵎⵖⴰⵔⴻⵏ ⵏⵙⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵙⴰⵄⵉⵔ. ");
INSERT INTO rift_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵊⴻⴵⵉⴷⴻⵏ ⵏⵏⵉ ⵉⵃⴻⴽⵎⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵉⴷⵓⵎ ⵇⴱⴻⵍ ⵎⴰ ⴰⴷ ⵉⵃⴽⴻⵎ ⵓⵊⴻⴵⵉⴷ ⵅ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ: ");
INSERT INTO rift_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","ⴱⵉⵍⴰⵄ, ⵎⵎⵉⵙ ⵏ ⴱⴰⵄⵓⵔ, ⵉⵃⴽⴻⵎ ⴷⵉ ⵉⴷⵓⵎ ⵓⵛⴰ ⵉⵙⴻⵎ ⵏ ⵜⴻⵏⴷⵉⵏⵜ ⵏⵏⴻⵙ ⵜⵓⵖⴰ-ⵜ ⴷ ⴷⵉⵏⵀⴰⴱⴰ. ");
INSERT INTO rift_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","ⵉⵎⵎⵓⵜ ⴱⵉⵍⴰⵄ ⵓⵛⴰ ⵢⵓⴱⴰⴱ, ⵎⵎⵉⵙ ⵏ ⵣⴰⵔⴰⵃ ⵣⵉ ⴱⵓⵚⵔⴰ ⵉⴷⵡⴻⵍ ⴷ ⴰⵊⴻⴵⵉⴷ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","ⵢⵓⴱⴰⴱ ⵉⵎⵎⵓⵜ ⵓⵛⴰ ⵃⵓⵛⴰⵎ, ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵉⵜⴰⵢⵎⴰⵏⵉⵢⵢⴻⵏ, ⵉⴷⵡⴻⵍ ⴷ ⴰⵊⴻⴵⵉⴷ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","ⵉⵎⵎⵓⵜ ⵃⵓⵛⴰⵎ ⵓⵛⴰ ⵀⴰⴷⴰⴷ, ⵎⵎⵉⵙ ⵏ ⴱⴰⴷⴰⴷ, ⵡⴻⵏⵏⵉ ⵉⵖⴻⵍⴱⴻⵏ ⵅ ⵎⵉⴷⵢⴰⵏ ⴷⴻⴳ ⵉⵢⵢⴰⵔ ⵏ ⵎⵓ’ⴰⴱ, ⵉⴷⵡⴻⵍ ⴷ ⴰⵊⴻⴵⵉⴷ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏⵏⴻⵙ. ⵉⵙⴻⵎ ⵏ ⵜⴻⵏⴷⵉⵏⵜ ⵏⵏⴻⵙ ⵇⵇⴰⵔⴻⵏ ⴰⵙ ⵄⴰⵡⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","ⵉⵎⵎⵓⵜ ⵀⴰⴷⴰⴷ ⵓⵛⴰ ⵙⴰⵎⵍⴰ ⵣⵉ ⵎⴰⵙⵔⵉⵇⴰ ⵉⴷⵡⴻⵍ ⴷ ⴰⵊⴻⴵⵉⴷ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","ⵉⵎⵎⵓⵜ ⵙⴰⵎⵍⴰ ⵓⵛⴰ ⵛⴰⵡⵓⵍ, ⵣⵉ ⵔⴰⵃⵓⴱⵓⵜ ⵖⴰⵔ ⵢⴻⵖⵣⴰⵔ ⵏ ⵍⴼⵓⵔⴰⵟ, ⵉⴷⵡⴻⵍ ⴷ ⴰⵊⴻⴵⵉⴷ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","ⵉⵎⵎⵓⵜ ⵛⴰⵡⵓⵍ ⵓⵛⴰ ⴱⴰⵄⵍ-ⵃⴰⵏⴰⵏ, ⵎⵎⵉⵙ ⵏ ⵄⴰⴽⴱⵓⵔ, ⵉⴷⵡⴻⵍ ⴷ ⴰⵊⴻⴵⵉⴷ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","ⵉⵎⵎⵓⵜ ⴱⴰⵄⵍ-ⵃⴰⵏⴰⵏ, ⵎⵎⵉⵙ ⵏ ⵄⴰⴽⴱⵓⵔ, ⵓⵛⴰ ⵀⴰⴷⴰⵔ ⵉⴷⵡⴻⵍ ⴷ ⴰⵊⴻⴵⵉⴷ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏⵏⴻⵙ. ⵜⴰⵏⴷⵉⵏⵜ ⵏⵏⴻⵙ ⵇⵇⴰⵔⴻⵏ ⴰⵙ ⴼⴰⵄⵓ ⵓ ⵜⴰⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ ⵇⵇⴰⵔⴻⵏ ⴰⵙ ⵎⴰⵀⵉⵟⴰⴱ’ⵉⵍ, ⵢⴻⴵⵉⵙ ⵏ ⵎⴰⵟⵔⵉⴷ, ⵢⴻⴵⵉⵙ ⵏ ⵎⴰ-ⴷⴰⵀⴰⴱ. ");
INSERT INTO rift_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵙⵎⴰⵡⴻⵏ ⵏ ⵉⵎⵖⴰⵔⴻⵏ ⵏ ⵜⵇⴻⴱⴱⴰⵍ ⵏ ⵄⵉⵙⵓ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ ⴷ ⵉⵎⵓⵛⴰⵏ ⵏⵙⴻⵏ ⴷ ⵉⵙⵎⴰⵡⴻⵏ ⵏⵙⴻⵏ: ⴰⵎⵖⴰⵔ ⵜⵉⵎⵏⴰⵄ ⴷ ⵓⵎⵖⴰⵔ ⵄⴰⵍⵡⴰ ⴷ ⵓⵎⵖⴰⵔ ⵢⴰⵜⵉⵜ ");
INSERT INTO rift_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ⴷ ⵓⵎⵖⴰⵔ ⴰⵀⵓⵍⵉⴱⴰⵎⴰ ⴷ ⵓⵎⵖⴰⵔ ⵉⵍⴰ ⴷ ⵓⵎⵖⴰⵔ ⴼⵉⵏⵓⵏ ");
INSERT INTO rift_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","ⴷ ⵓⵎⵖⴰⵔ ⵇⴰⵏⴰⵣ ⴷ ⵓⵎⵖⴰⵔ ⵜⴰⵢⵎⴰⵏ ⴷ ⵓⵎⵖⴰⵔ ⵎⵉⴱⵚⴰⵔ ");
INSERT INTO rift_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","ⴷ ⵓⵎⵖⴰⵔ ⵎⴰⵊⴷⵉⵢⵉⵍ ⴷ ⵓⵎⵖⴰⵔ ⵄⵉⵔⴰⵎ. ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵎⵖⴰⵔⴻⵏ ⵏ ⵉⴷⵓⵎ ⵄⵍⴰⵃⵙⴰⴱ ⵉⵎⵓⵛⴰⵏ ⵏⵙⴻⵏ, ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵍⵎⴻⵍⴽ ⵏⵙⴻⵏ. ⵡⴰⵏⵉⵜⴰ ⴷ ⵉⴷⵓⵎ, ⵡⴻⵏⵏⵉ ⴷ ⴱⴰⴱⴰⵙ ⵏ ⵉⴷⵓⵎⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN36_44","002_36_44","GEN","36","44","44","ⵓⵛⴰ ⵉⵣⴷⴻⵖ ⵢⴰⵄⵇⵓⴱ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ ⵎⴰⵏⵉ ⵜⵓⵖⴰ ⵉⵣⴻⴷⴷⴻⵖ ⴱⴰⴱⴰⵙ ⴰⵎ ⵓⴱⴰⵔⵔⴰⵏⵉ. ⵉⵏⴰ ⴷ ⵉⵎⴻⵣⵔⵓⵢⴻⵏ ⵏ ⵢⵉⵏⵏⵉ ⴷⴷ-ⵉⵜⵜⵡⴰⵅⴻⵍⵇⴻⵏ ⵣⵉ ⵢⴰⵄⵇⵓⴱ. ");
INSERT INTO rift_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","ⵍⴰⵎⵉ ⵜⵓⵖⴰ ⵖⴰⵔ ⵢⵓⵙⵓⴼ ⵙⴱⴻⵄⵟⴰⵛ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵢⴰⵔⵡⴻⵙ ⵓⴵⵉ ⵏ ⴱⴰⴱⴰⵙ ⴰⴽ-ⴷ ⴰⵢⵜⵎⴰⵙ. ⵜⵓⵖⴰ ⵢⵓⵙⵓⴼ ⴷ ⴰⵎⵙⴻⵅⵅⴰⵔ ⵖⴰⵔ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⴱⵉⵍⵀⴰ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵣⵉⵍⴱⴰ, ⵜⵉⵎⵖⴰⵔⵉⵏ ⵏ ⴱⴰⴱⴰⵙ ⵓⵛⴰ ⵉⵙⵙⵉⵡⴻⴹ ⵢⵓⵙⵓⴼ ⴰⵡⴰⵍⴻⵏ ⵏⵙⴻⵏ ⵉⵄⴻⴼⴼⴰⵏⴻⵏ ⵉ ⴱⴰⴱⴰⵜⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","ⵓⵛⴰ ⵉⵅⵙ ⵉⵙⵔⴰⵉⵍ ⵢⵓⵙⵓⴼ ⵇⴰⵄ ⵅ ⵎⴰⵔⵔⴰ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ, ⵎⵉⵏⵣⵉ ⵜⵓⵖⴰ-ⵜ ⵖⴰⵔⴻⵙ ⴷ ⵎⵎⵉⵙ ⵅ ⵜⴻⵡⵙⴰⵔ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⴳⴳⴰ ⴰⵙ ⴰⵔⵔⵓⴹ ⵙ ⵉⴼⴰⵙⵙⴻⵏ ⴷ ⵉⵣⵉⵔⴰⵔⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","ⵍⴰⵎⵉ ⵥⵔⵉⵏ ⴰⵢⵜⵎⴰⵙ ⴱⴻⵍⵍⵉ ⴱⴰⴱⴰⵙ ⵉⵜⵜⴻⵅⵙ ⵉ-ⵜ ⵇⴰⵄ ⵅⴰⵙⴻⵏ, ⵛⴰⵔⵀⴻⵏ ⵜ ⵓⵛⴰ ⵡⴰⵔ ⵣⴻⵎⵎⴰⵔⴻⵏ ⴰⴽⵉⴷⴻⵙ ⵙⵙⵉⵡⵍⴻⵏ ⵄⴰⴷ ⵙ ⵍⴻⵀⵏⴰ. ");
INSERT INTO rift_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","ⵓⵛⴰ ⵢⵓⵔⵊⴰ ⵢⵓⵙⵓⴼ ⵉⵛⵜ ⵏ ⵜⴰⵔⵊⵉⵜ, ⵉⵄⴰⵡⴷ ⵉ-ⵜⵜ ⵉ ⵢⴰⵢⵜⵎⴰⵙ. ⵙ ⵓⵢⴰ ⵏⵉⵜⵏⵉ ⴷⴻⵡⵍⴻⵏ ⵛⴰⵔⵀⴻⵏ ⵜ ⵄⴰⴷ ⴽⵜⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","ⵉⵏⵏⴰ ⴰⵙⴻⵏ: “ⵙⵍⴻⵎ ⵍⴻⵅⵅⵓ ⵜⴰⵔⵊⵉⵜ-ⴰ ⵏⵏⵉ ⵓⵔⵊⵉⵖ. ");
INSERT INTO rift_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","ⵅⵣⴰⵔ, ⵜⵓⵖⴰ ⵏⴻⵜⵜⵛⴻⴷⴷⴰ ⵜⵉⵇⴻⴱⴱⵉⴹⵉⵏ ⵏ ⵉⵎⴻⵏⴷⵉ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏ ⵢⴻⵢⵢⴰⵔ. ⵓ ⵅⵣⴰⵔ, ⵜⴰⵇⴻⴱⴱⵉⴹⵜ ⵉⵏⵓ ⵜⴱⴻⴷⴷ, ⵜⴻⵇⵇⵉⵎ ⵜⴱⴻⴷⴷ ⵓ ⵜⵉⵇⴻⴱⴱⵉⴹⵉⵏ ⵏⵡⴻⵎ ⵏⵏⵉ ⵜⵓⵖⴰ ⴷ ⴰⵙ ⴷⴷ-ⵉⵏⵏⴹⴻⵏⵜ, ⴱⴻⵏⴷⵇⴻⵏ ⵉ ⵜⵇⴻⴱⴱⵉⴹⵜ ⵉⵏⵓ.” ");
INSERT INTO rift_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","ⴰⵔⵔⵉⵏ-ⴷⴷ ⵅⴰⵙ ⴰⵢⵜⵎⴰⵙ: “ⵎⴰ ⴰⴷ ⵜⵃⴻⴽⵎⴻⴷ ⵣⴻⵄⵎⴰ ⵏⵉⵛⴰⵏ ⵅⴰⵏⴻⵖ ⴰⵎ ⵓⵊⴻⴵⵉⴷ ⵏⵉⵖ ⴰⴷ ⵅⴰⵏⴻⵖ ⵜⵙⴻⴵⴹⴻⴷ ⴷ ⴰⵙⴻⴵⴻⴹ?” ⵓⵛⴰ ⵛⴰⵔⵀⴻⵏ ⵜ ⵄⴰⴷ ⴽⵜⴰⵔ ⴷⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⵜⵉⵔⵊⴰ ⵏⵏⴻⵙ ⴷ ⵡⴰⵡⴰⵍⴻⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","ⵓⵛⴰ ⵢⵓⵔⵊⴰ ⵄⴰⴷ ⵜⴰⵔⵊⵉⵜ ⵏⵏⴻⵖⵏⵉ, ⵉⵄⴰⵡⴷ ⵉ-ⵜⵜ ⵉ ⵢⴰⵢⵜⵎⴰⵙ, ⵉⵏⵏⴰ: “ⵅⵣⴰⵔ, ⴰⵔⵊⵉⵖ ⵄⴰⴷ ⵜⴰⵔⵊⵉⵜ ⵏⵏⴻⵖⵏⵉ. ⵅⵣⴰⵔ ⵜⴰⴼⵓⵛⵜ ⴷ ⵓⵢⵓⵔ ⴷ ⵃⵉⵟⴰⵛ ⵏ ⵉⵜⵔⴰⵏ ⴱⴻⵏⴷⵇⴻⵏ ⴰⵢⵉ.” ");
INSERT INTO rift_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","ⵉⵄⴰⵡⴻⴷ ⵉ-ⵜⵜ ⵉ ⴱⴰⴱⴰⵙ ⴷ ⴰⵢⵜⵎⴰⵙ ⵓⵛⴰ ⵉⵡⴻⴱⴱⴻⵅ ⵉ-ⵜ ⴱⴰⴱⴰⵙ, ⵉⵏⵏⴰ ⴰⵙ: “ⵎⴰⵏⴰ ⵜⴰⵔⵊⵉⵜ-ⴰ ⵉ ⵜⴰⵔⵊⵉⴷ? ⵎⴰ ⴰⴷ ⴷⴷ-ⵏⴰⵙ ⵊⵎⵉⵄ, ⵏⴻⵛⵛ ⴷ ⵢⴻⵎⵎⴰⵛ ⴷ ⴰⵢⵜⵎⴰⵛ, ⴰⴷ ⴰⵛ ⵏⴱⴻⵏⴷⴻⵇ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ?” ");
INSERT INTO rift_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","ⴰⵢⵜⵎⴰⵙ ⵓⵙⵎⴻⵏ ⵣⵣⴰⵢⴻⵙ. ⵎⴰⵛⴰ ⴱⴰⴱⴰⵙ ⵉⵄⵇⴻⵍ ⵅ ⵡⴰⵡⴰⵍⴻⵏ-ⴰ. ");
INSERT INTO rift_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","ⵓⵛⴰ ⵔⵓⵃⴻⵏ ⴰⵢⵜⵎⴰⵙ, ⵃⵉⵎⴰ ⴰⴷ ⴰⵔⴻⵡⵙⴻⵏ ⵓⴵⵉ ⵏ ⴱⴰⴱⴰⵜⵙⴻⵏ ⵖⴰⵔ ⵛⴰⴽⵉⵎ. ");
INSERT INTO rift_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵉⵙⵔⴰⵉⵍ ⵉ ⵢⵓⵙⵓⴼ: “ⵎⴰ ⵡⴰⵔ ⴰⵔⴻⵡⵙⴻⵏ ⴰⵢⵜⵎⴰⵛ ⵓⴵⵉ ⵖⴰⵔ ⵛⴰⴽⵉⵎ? ⵣⵉⴷ, ⴰⴷ ⵛⴻⴽ ⵖⴰⵔⵙⴻⵏ ⵙⵙⴻⴽⴽⴻⵖ.” ⵓⵛⴰ ⵢⴰⵔⵔⴰ-ⴷⴷ ⵅⴰⵙ: “ⴰⵇⴰ ⴰⵢⵉ ⴷⴰ!” ");
INSERT INTO rift_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","ⵓⵛⴰ ⵉⵏⵏⴰ ⴰⵙ: “ⵔⵓⵃ ⵛⴻⴽ, ⵅⵣⴰⵔ ⵎⵓⵅⴰⵙ ⴵⴰⵏ ⴰⵢⵜⵎⴰⵛ ⴷ ⵎⵓⵅⴰⵙ ⴵⴰⵏ ⵡⵓⴵⵉ ⵓⵛⴰ ⴰⵡⵉ ⴰⵢⵉ-ⴷⴷ ⵍⴻⵅⴱⴰⵔ ⵄⴰⵡⴻⴷ.” ⴰⵎⵎⵓ ⵉ-ⵜ ⵉⵙⵙⴻⴽⴽ ⵣⵉ ⵍⴻⵡⴹⴰ ⵏ ⵜⴻⵖⵣⵓⵔⵜ ⵏ ⵃⴰⴱⵔⵓⵏ ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵢⵉⵡⴻⴹ-ⴷⴷ ⵖⴰⵔ ⵛⴰⴽⵉⵎ. ");
INSERT INTO rift_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","ⵢⵓⴼⴰ ⵉ-ⵜ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵓⵎⵉ ⵉⵡⴻⴷⴷⴰⵔ ⴷⴻⴳ ⵉⵢⵢⴰⵔ. ⵉⵙⵙⴻⵇⵙⴰ ⵜ ⵡⴻⵔⵢⴰⵣ, ⵉⵏⵏⴰ: “ⵎⵉⵏ ⵜⴰⵔⴻⵣⵣⵓⴷ?” ");
INSERT INTO rift_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ⵉⵏⵏⴰ: “ⴰⵔⴻⵣⵣⵓⵖ ⵅ ⴰⵢⵜⵎⴰ. ⵜⵜⵣⴰⵡⴳⴻⵖ ⵛⴻⴽ, ⵉⵏⵉ ⴰⵢⵉ ⵎⴰⵏⵉ ⴰⵔⴻⵡⵙⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","ⴰⵔⵢⴰⵣ ⵢⴰⵔⵔⴰ-ⴷⴷ: “ⴰⵇⴰ ⵎⵓⵟⵟⵉⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⵙⵙⴰ, ⵏⴻⵛⵛ ⵙⵍⵉⵖ ⴰⵙⴻⵏ ⵇⵇⴰⵔⴻⵏ: ‘ⴻⵊⵊ ⴰⵏⴻⵖ ⴰⴷ ⵏⵔⴰⵃ ⵖⴰⵔ ⴷⵓⵜⴰⵏ.’” ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⵔⵓⵃ ⵢⵓⵙⵓⴼ ⴰⵡⴰⵔⵏⵉ ⴰⵢⵜⵎⴰⵙ ⵓⵛⴰ ⵢⵓⴼⴰ ⵉ-ⵜⴻⵏ ⴷⵉ ⴷⵓⵜⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","ⵓⵎⵉ ⵜ ⵥⵔⵉⵏ ⵣⵉ ⵍⴰⴳⴳⵯⴰⵊ, ⵇⴱⴻⵍ ⵎⴰ ⴰⴷ ⵖⴰⵔⵙⴻⵏ ⴷⴷ-ⵉⵇⴰⵔⵔⴻⴱ, ⵎⵄⴰⵀⴰⴷⴻⵏ ⴹⵉⴷⴷ ⵏⵏⴻⵙ ⵃⵉⵎⴰ ⴰⴷ ⵜ ⵏⵖⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","ⵏⵏⴰⵏ ⵉⵊⵊ ⵉ ⵡⴻⵏⵏⴻⵖⵏⵉ: “ⵅⵣⴰⵔ, ⵢⵓⵙⴰ-ⴷⴷ ⴱⵓ-ⵜⵉⵔⵊⴰ ⵏⵏⵉ! ");
INSERT INTO rift_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","ⵣⵉⴷ ⵍⴻⵅⵅⵓ, ⴻⵊⵊ ⴰⵏⴻⵖ ⴰⴷ ⵜ ⵏᵉⵏⵏⴻⵖ ⵓⵛⴰ ⴰⴷ ⵜ ⵏⴻⵏⴹⴰⵔ ⴷⴻⴳ ⵡⴰⵏⵓ, ⴰⴷ ⵏⵉⵏⵉ: ‘ⵛⴰ ⵏ ⵍⵡⴻⵃⵛ ⵢⴻⵡⵄⴰⵔ ⵉⵛⵛⴰ ⵉ-ⵜ!’, ⵓⵛⴰ ⵅⴻⵏⵏⵉ ⴰⴷ ⵏⵥⴰⵔ ⵎⵉⵏ ⵖⴰ ⵉⵍⵉⵏⵜ ⵜⵉⵔⵊⴰ ⵏⵏⴻⵙ.” ");
INSERT INTO rift_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","ⵉⵙⵍⴰ ⵔⵓⴱⵉⵏ ⵎⴰⵏ ⴰⵢⴰ ⵓⵛⴰ ⵉⴼⴻⴽⴽ ⵉ-ⵜ ⵣⴻⴳ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵙⴻⵏ, ⵉⵏⵏⴰ: “ⵡⴰⵔ ⵜ ⵏⵏⴻⵇⵇ ⵛⴰ!” ");
INSERT INTO rift_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","ⵉⵏⵏⴰ ⴰⵙⴻⵏ ⵄⴰⵡⴻⴷ ⵔⵓⴱⵉⵏ: “ⵡⴰⵔ ⵙⵉⵣⵣⵉⵍⴻⵎ ⵉⴷⴰⵎⵎⴻⵏ! ⵏⴹⴰⵔⴻⵎ ⵜ ⴷⴻⴳ ⵡⴰⵏⵓ-ⵢⴰ ⴷⴰ ⴷⵉ ⵍⴻⵅⵍⴰ. ⵡⴰⵔ ⵅⴰⵙ ⵜⵜⴻⴳⴳⴻⵎ ⴰⴼⵓⵙ!”. ⵉⵏⵏⴰ ⴰⵎⵎⵓ ⵃⵉⵎⴰ ⴰⴷ ⵜ ⵉⴼⴻⴽⴽ ⵣⴻⴳ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵙⴻⵏ ⵓⵛⴰ ⴰⴷ ⵜ ⵢⴰⵔⵔ ⵖⴰⵔ ⴱⴰⴱⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","ⵓⵛⴰ ⵉⵎⵙⴰⵔ, ⵓⵎⵉ ⴷⴷ-ⵢⵉⵡⴻⴹ ⵢⵓⵙⵓⴼ ⵖⴰⵔ ⴰⵢⵜⵎⴰⵙ, ⴽⴽⵙⴻⵏ ⵏⵉⵜⵏⵉ ⴰⵔⵔⵓⴹ ⵅ ⵢⵓⵙⵓⴼ, ⴰⵔⵔⵓⴹ ⵙ ⵉⴼⴰⵙⵙⴻⵏ ⴷ ⵉⵣⵉⵔⴰⵔⴻⵏ ⵏⵏⵉ ⵅⴰⵙ ⵜⵓⵖⴰ, ");
INSERT INTO rift_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","ⵓⵛⴰ ⵟⵟⴼⴻⵏ ⵜ, ⵏⴹⴰⵔⴻⵏ ⵜ ⴷⴻⴳ ⵡⴰⵏⵓ. ⵎⴰⵛⴰ ⴰⵏⵓ ⵜⵓⵖⴰ ⵉⵅⵡⴰ, ⵡⴰⵔ ⴷⴰⵢⴻⵙ ⵜⵓⵖⵉ ⵛⴰ ⴰⵎⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","ⴰⵡⴰⵔⵏⵉ ⵎⴰⵏ ⴰⵢⴰ ⵇⵇⵉⵎⴻⵏ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵛⵛⴻⵏ ⴰⵖⵔⵓⵎ, ⵓⵛⴰ ⵍⴰⵎⵉ ⵙⵙⴳⴻⵄⵄⴷⴻⵏ ⵏⵉⵜⵏⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵙⴻⵏ, ⵣⵍⵉⵏ ⵉⵊⵊ ⵏ ⵓⴽⴰⵔⴰ$ⴰⵏ ⵏ ⵉⵙⵎⴰⵄⵉⵍⵉⵢⵢⴻⵏ ⵉ ⴷⴷ-ⵢⵓⵙⵉⵏ ⵣⵉ ⵊⵉⵍⵄⴰⴷ. ⵉⵍⴻⵖⵎⴰⵏ ⵏⵙⴻⵏ ⴰⵔⴱⵓⵏ ⵍⴻⵄⵟⵓⵔ ⴷ ⵍⴻⴼⵡⴰⵀ ⵏ ⴱⴰⵍⵙⴰⵎ ⴷ ⵎⵉⵔⵔⵓ, ⴳⴳⵓⵔⴻⵏ ⴰⴷ ⵜ ⴰⵡⵢⴻⵏ ⵖⴰⵔ ⵎⵉⵚⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵢⴰⵀⵓⴷⴰ ⵉ ⵢⴰⵢⵜⵎⴰⵙ: “ⵎⴰⵏ ⵍⴻⴼⴹⴻⵍ ⵎⴰⵍⴰ ⵏⴻⵏⵖⴰ ⵓⵎⴰⵜⵏⴻⵖ ⵓⵛⴰ ⴰⴷ ⵏⴻⴼⴼⴰⵔ ⵉⴷⴰⵎⵎⴻⵏ ⵏⵏⴻⵙ? ");
INSERT INTO rift_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","ⵖⴰⵡⵔⴻⵎ, ⴰⴷ ⵜ ⵏⴻⵣⵣⴻⵏⵣ ⵉ ⵉⵙⵎⴰⵄⵉⵍⵉⵢⵢⴻⵏ, ⵡⴰⵔ ⵉⵜⵜⵉⵍⵉ ⵓⴼⵓⵙ ⵏⵏⴻⵖ ⵅⴰⵙ, ⴰⵇⴰ ⴷ ⵓⵎⴰⵜⵏⴻⵖ ⴷ ⴰⵢⵙⵓⵎ ⵏⵏⴻⵖ.” ⵓⵛⴰ ⵙⵍⵉⵏ ⴰⵢⵜⵎⴰⵙ ⵖⴰⵔⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","ⴰⵎ ⴷⴷ-ⵄⴷⵓⵏ ⵜⵓⵊⵊⴰⵔ ⵏ ⵎⵉⴷⵢⴰⵏ, ⵙⵙⴳⴻⵄⵄⴷⴻⵏ-ⴷⴷ ⵢⵓⵙⵓⴼ ⵣⴻⴳ ⵡⴰⵏⵓ ⵓⵛⴰ ⵣⵣⴻⵏⵣⴻⵏ ⵜ ⵙ ⵄⵉⵛⵔⵉⵏ ⵏ ⵓⵇⵉⵢⵢⴰⵜ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵉ ⵉⵙⵎⴰⵄⵉⵍⵉⵢⵢⴻⵏ, ⵉⵏⵏⵉ ⴷⴷ-ⵢⵉⵡⵢⴻⵏ ⵢⵓⵙⵓⴼ ⵖⴰⵔ ⵎⵉⵚⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","ⵍⴰⵎⵉ ⴷⴷ-ⵉⴷⵡⴻⵍ ⵔⵓⴱⵉⵏ ⵖⴰⵔ ⵡⴰⵏⵓ, ⵡⴰⵔ ⴷⵉⵏ ⵢⵓⴼⵉ ⵢⵓⵙⵓⴼ ⵄⴰⴷ ⴷⴻⴳ ⵡⴰⵏⵓ. ⵅⴻⵏⵏⵉ ⵉⵛⴰⵔⵔⴻⴳ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","ⵉⴷⵡⴻⵍ ⵖⴰⵔ ⴰⵢⵜⵎⴰⵙ ⵓⵛⴰ ⵉⵏⵏⴰ: “ⴰⵃⴻⵏⵊⵉⵔ ⵡⴰⵔ ⴷⵉⵏ ⵉⴵⵉ ⵄⴰⴷ. ⵉ ⵏⴻⵛⵛ, ⵎⴰⵏⵉ ⵖⴰ ⵔⴰⵃⴻⵖ?” ");
INSERT INTO rift_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","ⵅⴻⵏⵏⵉ ⴽⵙⵉⵏ ⴰⵔⵔⵓⴹ ⵏ ⵢⵓⵙⵓⴼ ⵓⵛⴰ ⵖⴰⵔⵚⴻⵏ ⵉ ⵢⵉⵊⵊ ⵏ ⵓⵎⵢⴰⵏ ⵣⴻⴳ ⵉⵖⴰⵢⴹⴻⵏ ⵓⵛⴰ ⵎⴰⵔⵖⴻⵏ ⴰⵔⵔⵓⴹ ⵙ ⵉⴷⴰⵎⵎⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","ⵙⵙⴻⴽⴽⴻⵏ ⵉⵊⵊⴻⵏ ⵙ ⴰⵔⵔⵓⴹ ⴷ ⵍⴻⵎⵍⵉⵃ ⵙ ⵉⴼⴰⵙⵙⴻⵏ ⴷ ⵉⵣⵉⵔⴰⵔⴻⵏ, ⵊⵊⵉⵏ ⵜ ⴰⴷ ⵜ ⵢⴰⵡⵉ ⵖⴰⵔ ⴱⴰⴱⴰⵜⵙⴻⵏ, ⵏⵏⴰⵏ: “ⴷ ⵡⴰ ⵉ ⵏⵓⴼⴰ. ⵅⵣⴰⵔ ⵍⴻⵅⵅⵓ, ⵎⴰ ⵡⴰⵀ ⵏⵉⵖ ⵍⵍⴰ ⴰⵔⵔⵓⴹ ⵏ ⵎⵎⵉⵛ?” ");
INSERT INTO rift_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵉⵄⴻⵇⵍ ⵉ-ⵜ, ⵉⵏⵏⴰ: “ⴰⵔⵔⵓⴹ ⵏ ⵎⵎⵉ ⵉ ⵢⴻⴵⴰ! ⵛⴰ ⵏ ⵍⵡⴻⵃⵛ ⵢⴻⵡⵄⴰⵔ ⵉⵛⵛⴰ ⵉ-ⵜ. ⵢⵓⵙⵓⴼ ⵙ ⵜⵉⴷⴻⵜⵜ ⴱⴻⵜⵜⵇⴻⵏ ⵜ!” ");
INSERT INTO rift_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","ⵉⵛⴰⵔⵔⴻⴳ ⵢⴰⵄⵇⵓⴱ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ ⵓⵛⴰ ⵢⴰⵔⴹ ⵉⵛⵜ ⵏ ⵜⵅⴰⵏⵛⴻⵜ ⵏ ⵡⴻⵛⴹⴰⵏ ⵅ ⵜⴻⵊⵄⵉⵏⵏⴰ ⵏⵏⴻⵙ, ⵉⵛⴹⴻⵏ ⵅ ⵎⵎⵉⵙ ⴰⵟⵟⴰⵙ ⵏ ⵡⵓⵙⵙⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","ⴽⴽⴰⵔⴻⵏ ⵎⴰⵔⵔⴰ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ ⴷ ⵎⴰⵔⵔⴰ ⵜⵉⵃⴻⵏⵊⵉⵔⵉⵏ ⵏⵏⴻⵙ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜ ⵄⴻⵣⵣⴰⵏ, ⵄⴰⴷ ⵏⴻⵜⵜⴰ ⵡⴰⵔ ⵉⵅⵙ ⴰⴷ ⵉⵜⵜⵡⴰⵄⴻⵣⵣⴰ, ⵉⵏⵏⴰ: “ⵍⵍⴰ, ⴰⴷ ⴷⴷ-ⵀⵡⵉⵖ ⵏⵏⵓⵔⵢⴻⵖ ⵖⴰⵔ ⵍⴰⵅⴰⵔⵜ.” ⵓⵛⴰ ⵉⵙⵖⵓⵢ ⵅⴰⵙ ⴱⴰⴱⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","ⵉⵎⵉⴷⵉⵢⴰⵏⵉⵢⵢⴻⵏ ⵣⵣⴻⵏⵣⴻⵏ ⵜ ⴷⵉ ⵎⵉⵚⵔⴰ ⵉ ⴱⵓⵜⵉⴼⴰⵔ, ⴰⵎⵙⴻⵅⵅⴰⵔ ⴰⵎⵛⴻⵏⵏⴻⵄ ⵏ ⴼⵉⵔⵄⵓⵏ, ⵍⵇⴻⴱⵟⴰⵏ ⵏ ⵉⵄⴻⵙⵙⴰⵙⴻⵏ ⵏ ⴰⵔⵔⵉⵎⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","ⴷⵉ ⵍⵡⴻⵇⵜ ⴷ ⵉⵛⵜ ⵉⵀⵡⴰ ⵢⴰⵀⵓⴷⴰ, ⵉⴼⴼⴻⵖ ⵅ ⴰⵢⵜⵎⴰⵙ, ⵓⵛⴰ ⵉⵡⵜⴰ ⵉⵇⵉⴹⴰⵏ ⵏⵏⴻⵙ ⵖⴰⵔ ⵢⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⴷ ⴰⴷⵓⵍⵍⴰⵎⵉⵜⵉ ⵡⴻⵏⵏⵉ ⵓⵎⵉ ⵇⵇⴰⵔⴻⵏ ⵃⵉⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","ⵓⵛⴰ ⵉⵥⵔⴰ ⴷⵉⵏ ⵢⴰⵀⵓⴷⴰ ⵢⴻⴵⵉⵙ ⵏ ⵢⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⴷ ⴰⴽⴻⵏⵄⴰⵏⵉ ⵡⴻⵏⵏⵉ ⵓⵎⵉ ⵇⵇⴰⵔⴻⵏ ⵛⵓⵄⴰ. ⵓⵛⴰ ⵢⴰⵀⵓⴷⴰ ⵢⵉⵡⵉ ⵢⴻⴵⵉⵙ ⵏ ⵛⵓⵄⴰ ⴷ ⵜⴰⵎⵖⴰⵔⵜ, ⵓⵛⴰ ⵢⵓⴷⴻⴼ ⵅⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","ⵏⴻⵜⵜⴰⵜ ⵜⴻⴽⵙⵉ ⵙ ⴷⴷⴻⵢⵙⴻⵜ ⵓⵛⴰ ⵜⵓⵔⵓⵡ-ⴷⴷ ⴰⵃⴻⵏⵊⵉⵔ ⵓⵛⴰ ⵢⴰⵀⵓⴷⴰ ⵉⵍⴰⵖⴰ ⴰⵙ ⵄⵉⵔ. ");
INSERT INTO rift_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","ⵓⵛⴰ ⵜⴻⴽⵙⵉ ⵄⴰⵡⴻⴷ ⵙ ⴷⴷⴻⵢⵙⴻⵜ, ⵜⵓⵔⵓⵡ-ⴷⴷ ⴰⵃⴻⵏⵊⵉⵔ ⵓⵛⴰ ⵜⵍⴰⵖⴰ ⴰⵙ ⵓⵏⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","ⵓⵛⴰ ⵜⵓⵔⵓⵡ-ⴷⴷ ⵄⴰⵡⴻⴷ ⴰⵃⴻⵏⵊⵉⵔ ⵓⵛⴰ ⵜⵍⴰⵖⴰ ⴰⵙ ⵛⴰⵢⵍⴰ. ⵏⴻⵜⵜⴰ ⵜⵓⵖⴰ-ⵜ ⴷⵉ ⴽⴰⵣⵉⴱ ⵓⵎⵉ ⴷ ⴰⵙ ⵜ-ⵉ-ⴷⴷ-ⵜⵓⵔⵓⵡ. ");
INSERT INTO rift_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","ⵢⴰⵀⵓⴷⴰ ⵉⴽⵙⵉ ⵜⴰⵎⵖⴰⵔⵜ ⵉ ⵄⵉⵔ, ⴰⵎⴻⵏⵣⵓ ⵏⵏⴻⵙ. ⵜⴰⵎⵖⴰⵔⵜ-ⴰ ⵇⵇⴰⵔⴻⵏⵜ ⴰⵙ ⵜⴰⵎⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","ⵄⵉⵔ, ⴰⵎⴻⵏⵣⵓ ⵏ ⵢⴰⵀⵓⴷⴰ, ⵜⵓⵖⴰ-ⵜ ⴷ ⴰⵄⴻⴼⴼⴰⵏ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵙⵉⴷⵉ ⵓⵛⴰ ⵉⵏⵖⴰ ⵉ-ⵜ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵢⴰⵀⵓⴷⴰ ⵉ ⵓⵏⴰⵏ: “ⴰⴷⴻⴼ ⵅ ⵜⴻⵎⵖⴰⵔⵜ ⵏ ⵓⵎⴰⵛ, ⵎⵍⴻⵛ ⴰⴽⵉⴷⴻⵙ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏ ⵓⵎⴰⵛ, ⵜⴻⵊⵊⴻⴷ-ⴷⴷ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵉ ⵓⵎⴰⵛ.” ");
INSERT INTO rift_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","ⵎⴰⵛⴰ ⵓⵏⴰⵏ ⵉⵙⵙⴻⵏ ⴱⴻⵍⵍⵉ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵡⴰⵔ ⵜᵉⵜⵜⵉⵍⵉ ⵏⵏⴻⵙ. ⵓⵛⴰ ⴰⵎⵎⵓ ⵉⵎⵙⴰⵔ, ⵓⵎⵉ ⵢⵓⴷⴻⴼ ⵅ ⵜⴻⵎⵖⴰⵔⵜ ⵏ ⵓⵎⴰⵙ, ⵉⵏⵖⴻⵍ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵙ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ, ⵃⵉⵎⴰ ⵡⴰⵔ ⵉⵜⵜⵉⵛ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵉ ⵓⵎⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","ⵎⵉⵏ ⵉⴳⴳⴰ ⵜⵓⵖⴰ ⴷ ⴰⵄⴻⴼⴼⴰⵏ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵙⵉⴷⵉ ⵓⵛⴰ ⵉⵏⵖⴰ ⵉ-ⵜ ⵓⵍⴰ ⴷ ⵏⴻⵜⵜⴰ. ");
INSERT INTO rift_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵢⴰⵀⵓⴷⴰ ⵉ ⵜⴰⵎⴰⵔ, ⵜⴰⵙⵍⵉⵜ ⵏⵏⴻⵙ: “ⵇⵇⵉⵎ ⴰⵎ ⵜⴰⵊⵊⴰⵍⵜ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⴱⴰⴱⴰⵎ, ⴰⵍ ⵖⴰ ⵉⵎⵖⴰⵔ ⵎⵎⵉ ⵛⴰⵢⵍⴰ!”, ⵎⵉⵏⵣⵉ ⵉⵏⵏⴰ: “ⴰⵇⴰ ⵡⴰⵔ ⵉⵜⵜⵎⴻⵜⵜⵉ ⵓⵍⴰ ⴷ ⵡⴰ ⴰⵎ ⵢⴰⵢⵜⵎⴰⵙ.” ⵓⵛⴰ ⵜⵔⵓⵃ ⵜⴰⵎⴰⵔ, ⵜⴻⵣⴷⴻⵖ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⴱⴰⴱⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","ⵄⴷⵓⵏ ⵡⵓⵙⵙⴰⵏ ⴰⵟⵟⴰⵙ, ⵅⴻⵏⵏⵉ ⵜⴻⵎⵎⵓⵜ ⵢⴻⴵⵉⵙ ⵏ ⵛⵓⵄⴰ, ⵜⴰⵎⵖⴰⵔⵜ ⵏ ⵢⴰⵀⵓⴷⴰ. ⵢⴰⵀⵓⴷⴰ ⵢⴰⵔⴻⵣⵣⵓ ⴰⴷ ⵉⵜⵜⵡⴰⵄⴻⵣⵣⴰ ⵓⵛⴰ ⵉⴳⴻⵄⵄⴻⴷ ⵖⴰⵔ ⵜⵃⵉⵎⴰⵔⵜ ⵏ ⵡⵓⴵⵉ ⵏⵏⴻⵙ ⵖⴰⵔ ⵜⵉⵎⵏⴰⵜⴰ, ⵏⴻⵜⵜⴰ ⴷ ⵃⵉⵔⴰ, ⴰⵎⴻⴷⴷⵓⴽⴽⴻⵍ ⵏⵏⴻⵙ ⵣⵉ ⴰⴷⵓⵍⵍⴰⵎ. ");
INSERT INTO rift_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","ⵄⴻⵍⵎⴻⵏ ⵜ ⵉ ⵜⴰⵎⴰⵔ, ⵏⵏⴰⵏ: “ⵅⵣⴰⵔ, ⴰⴹⴻⴳⴳⵯⴰⵍ ⵏⵏⴻⵎ ⵉⴳⴻⵄⵄⴻⴷ ⵖⴰⵔ ⵜⵉⵎⵏⴰⵜⴰ, ⴰⴷ ⵉⵍⵙ ⵓⴵⵉ ⵏⵏⴻⵙ.” ");
INSERT INTO rift_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","ⵅⴻⵏⵏⵉ ⵜⴻⴽⴽⴻⵙ ⵅⴰⵙ ⴰⵔⵔⵓⴹ ⵏ ⵜⴰⵊⵊⴰⵍⵜ, ⵜⵍⴻⵃⵃⴻⴼ ⵙ ⵜⴽⴻⵏⴱⵓⵛⵜ, ⵜⴻⵙⵍⴻⵃⵀⴻⴼ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵣⵣⴰⵢⴻⵙ, ⵓⵛⴰ ⵜⵔⵓⵃ ⴰⴷ ⵜⴻⵇⵇⵉⵎ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵄⴰⵢⵏⴰⵢⵉⵎ, ⵡⴻⵏⵏⵉ ⵉⴵⴰⵏ ⴷⴻⴳ ⵡⴻⴱⵔⵉⴷ ⵖⴰⵔ ⵜⵉⵎⵏⴰⵜⴰ, ⵎⵉⵏⵣⵉ ⵜⴻⵥⵔⴰ ⵛⴰⵢⵍⴰ ⵉⵎⵖⴰⵔ, ⵓ ⵏⴻⵜⵜⴰⵜ ⵜⵓⵖⴰ ⵡⴰⵔ ⴷ ⴰⵙ ⵜⴻⵎⵎⴻⵡⵛ ⴷ ⵜⴰⵎⵖⴰⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","ⵓⵛⴰ ⵉⵥⵔⴰ ⵉ-ⵜⵜ ⵢⴰⵀⵓⴷⴰ, ⵉⵃⴻⵙⴱ ⵉ-ⵜⵜ ⴷ ⵍⴼⴰⵙⴷⴰ, ⵎⵉⵏⵣⵉ ⵜⵓⵖⴰ-ⵜⵜ ⵜⵍⴻⵃⵃⴻⴼ ⵉ ⵓⵖⴻⵎⴱⵓⴱ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","ⵓⵛⴰ ⵉⵎⴻⵢⵢⴻⵍ ⵖⴰⵔⴻⵙ ⵖⴰⵔ ⵡⴻⴱⵔⵉⴷ, ⵉⵏⵏⴰ ⴰⵙ: “ⴻⵊⵊ ⴰⵢⵉ ⴰⴷ ⵅⴰⵎ ⴰⴷⴼⴻⵖ!”, ⵎⵉⵏⵣⵉ ⵏⴻⵜⵜⴰ ⵜⵓⵖⴰ ⵡⴰⵔ ⵉⵙⵙⵉⵏ, ⴱⴻⵍⵍⵉ ⵏⴻⵜⵜⴰⵜ ⴷ ⵜⴰⵙⵍⵉⵜ ⵏⵏⴻⵙ. ⵏⴻⵜⵜⴰⵜ ⵜⴻⵏⵏⴰ: “ⵎⵉⵏ ⴷ ⴰⵢⵉ ⵖⴰ ⵜⴻⵡⵛⴻⴷ, ⵃⵉⵎⴰ ⴰⴷ ⵅⴰⴼⵉ ⵜⴰⴷⴼⴻⴷ?” ");
INSERT INTO rift_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","ⵢⴰⵔⵔⴰ-ⴷⴷ: “ⵏⴻⵛⵛ ⴰⴷ ⴰⵎ-ⴷⴷ ⵙⵙⴻⴽⴽⴻⵖ ⵉⵊⵊ ⵏ ⵉⵖⴰⵢⴹ ⴷ ⴰⵎⴻⵥⵢⴰⵏ ⵣⴻⴳ ⵉⵖⴰⵢⴹⴻⵏ, ⵣⴻⴳ ⵡⵓⴵⵉ.” ⵜⴻⵏⵏⴰ ⴰⵙ: “ⵎⵖⵉⵔ ⴻⵡⵛ ⴰⵢⵉ ⵉⵊⵊ ⵏ ⵡⴰⵔⵀⴰⵏ ⴰⵍ ⴷ ⴰⵢⵉ ⵜ-ⵉ-ⴷⴷ ⵜᵉⵙⵙⴻⴽⴽⴻⴷ.” ");
INSERT INTO rift_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","ⵉⵏⵏⴰ: “ⵎⴰⵏ ⴰⴹⵎⴰⵏ ⵉ ⴷ ⴰⵎ ⵉ ⵖⴰ ⵡⵛⴻⵖ?” ⵏⴻⵜⵜⴰⵜ ⵜⴻⵏⵏⴰ: “ⵜⴰⵅⴰⴷⴻⵏⵜ ⵏⵏⴻⵛ ⵏ ⵓⵛⴻⵎⵎⵉⵄ ⴷ ⵜⵜⴻⵙⴱⵉⵃ ⵏⵏⴻⵛ ⴷ ⵜⴰⵖⵖⴰⵔⵛⵜ ⵉ ⵖⴰⵔⴻⴽ ⴷⴻⴳ ⵓⴼⵓⵙ.” ⵓⵛⴰ ⵉⵡⵛⴰ ⴰⵙ ⵜⴻⵏ, ⵢⵓⴷⴻⴼ ⵅⴰⵙ ⵓⵛⴰ ⵜⴻⴽⵙⵉ ⵣⵣⴰⵢⴻⵙ ⴷⴷⴻⵢⵙⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","ⵓⵛⴰ ⵜⴻⴽⴽⴰⵔ, ⵜⵔⵓⵃ, ⵜⴻⴽⴽⴻⵙ ⵅⴰⵙ ⵜⴰⴽⴻⵏⴱⵓⵛⵜ ⵏⵏⴻⵙ ⵓⵛⴰ ⵜⵢⴰⵔⴹ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ ⵏ ⵜⴰⵊⵊⴰⵍⵜ. ");
INSERT INTO rift_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","ⵓⵛⴰ ⵉⵙⵙⴻⴽⴽ ⵢⴰⵀⵓⴷⴰ ⵉⵖⴰⵢⴹ ⴷ ⴰⵎⴻⵥⵢⴰⵏ ⵣⴻⴳ ⵉⵖⴰⵢⴹⴻⵏ ⵅ ⵓⴼⵓⵙ ⵏ ⵓⵎⴻⴷⴷⵓⴽⴽⴻⵍ ⵏⵏⴻⵙ ⴰⴷⵓⵍⵍⴰⵎⵉ, ⵃⵉⵎⴰ ⴰⴷ ⵉⵟⵟⴻⴼ ⵄⴰⵡⴻⴷ ⴰⴹⵎⴰⵏ ⵣⴻⴳ ⵓⴼⵓⵙ ⵏ ⵜⴻⵎⵖⴰⵔⵜ, ⵎⴰⵛⴰ ⵡⴰⵔ ⵜⵜ ⵢⵓⴼⵉ. ");
INSERT INTO rift_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","ⵉⵙⵙⴻⵇⵙⴰ ⵉⵔⵢⴰⵣⴻⵏ ⵅ ⵡⴻⵎⵛⴰⵏ ⵏⵏⴻⵙ, ⵉⵏⵏⴰ: “ ⵎⴰⵏⵉ ⵜⴻⴵⴰ ⵜⴻⵎⵖⴰⵔⵜ ⵏ ⴼⴰⵔⵇ-ⵛⵛⵖⴻⵍ ⵏⵏⵉ ⵜⵓⵖⴰ ⵉⵇⵇⵉⵎⴻⵏ ⵅ ⵡⴻⴱⵔⵉⴷ ⵖⴰⵔ ⵄⴰⵏⴰⵢⵉⵎ?” ⵏⵉⵜⵏⵉ ⴰⵔⵔⵉⵏ-ⴷⴷ ⵅⴰⵙ: “ⵡⴰⵔ ⴷⴰ ⵜⵓⵖⵉ ⵇⴰⵄ ⵛⴰ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⵏ ⴼⴰⵔⵇ-ⵛⵛⵖⴻⵍ ⵖⴰⵔ ⵣⵣⴰⵡⴻⵛⵜ.” ");
INSERT INTO rift_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","ⵅⴻⵏⵏⵉ ⵉⵄⵇⴻⴱ-ⴷⴷ ⵖⴰⵔ ⵢⴰⵀⵓⴷⴰ, ⵉⵏⵏⴰ: “ⵡⴰⵔ ⵜⵜ ⵓⴼⵉⵖ ⵛⴰ, ⵓⵍⴰ ⴷ ⵉⵔⵢⴰⵣⴻⵏ ⵏ ⵡⴻⵎⵛⴰⵏ ⵏⵏⵉ ⵏⵏⴰⵏ: ‘ⵡⴰⵔ ⴷⴰ ⵜⵓⵖⵉ ⵇⴰⵄ ⵛⴰ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⵏ ⴼⴰⵔⵇ-ⵛⵛⵖⴻⵍ ⵖⴰⵔ ⵣⵣⴰⵡⴻⵛⵜ.’” ");
INSERT INTO rift_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","ⵓⵛⴰ ⵉⵏⵏⴰ ⵢⴰⵀⵓⴷⴰ: “ⴻⵊⵊ ⵉ-ⵜⵜ ⴰⴷ ⵜᵉⵟⵟⴻⴼ ⴰⴹⵎⴰⵏ ⵖⴰⵔⴻⵙ, ⵃⵉⵎⴰ ⵡⴰⵔ ⵏⴻⵜⵜⵉⵍⵉ ⴷ ⵍⵄⴰⵔ. ⵅⵣⴰⵔ, ⵏⴻⵛⵛ ⴰⵇⴰ ⵙⵙⴻⴽⴽⴻⵖ ⵉⵖⴰⵢⴹ-ⴰ ⴷ ⴰⵎⴻⵥⵢⴰⵏ, ⵎⴰⵛⴰ ⵛⴻⴽ ⵡⴰⵔ ⵜⵜ ⵜⵓⴼⵉⴷ.” ");
INSERT INTO rift_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","ⵄⵍⴰⵃⴰⵍ ⴰⵡⴰⵔⵏⵉ ⵜⵍⴰⵜⴰ ⵏ ⵉⵢⵓⵔⴻⵏ ⵜⴻⵎⵙⴰⵔ, ⴰⵇⴰ ⵅⴻⴱⴱⴰⵔⴻⵏ ⵢⴰⵀⵓⴷⴰ, ⵏⵏⴰⵏ: “ⵜⴰⵎⴰⵔ, ⵜⴰⵙⵍⵉⵜ ⵏⵏⴻⵛ, ⴰⵇⴰ ⵜⴻⵙⵙⴻⴼⵙⴻⴷ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵓⵛⴰ ⵍⴻⵅⵅⵓ ⵏⴻⵜⵜⴰⵜ ⴰⵇⴰ-ⵜⵜ ⵙ ⴷⴷⴻⵢⵙⴻⵜ ⵙ ⴼⴰⵔⵇ-ⵛⵛⵖⴻⵍ ⵏⵏⴻⵙ.” ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵢⴰⵀⵓⴷⴰ: “ⵙⵓⴼⴼⵖⴻⵎ ⵜⵜ-ⵉ-ⴷⴷ, ⴰⴷ ⵜⴻⵛⵎⴻⴹ!” ");
INSERT INTO rift_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","ⵓⵎⵉ ⵜⵜ-ⵉ-ⴷⴷ-ⵢⵉⵡⵢⴻⵏ ⵖⴰⵔ ⴱⴰⵔⵔⴰ, ⵜⴻⵙⵙⴻⴽⴽ-ⴷⴷ ⵉⵊⵊⴻⵏ ⵖⴰⵔ ⵓⴹⴻⴳⴳⵯⴰⵍ ⵏⵏⴻⵙ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵢⵉⵏⵉ: “ⵣⴻⴳ ⵡⴻⵔⵢⴰⵣ ⵏ ⵍⴻⵃⵡⴰⵢⴻⵊ-ⴰ, ⴰⵇⴰ ⴽⵙⵉⵖ ⵙ ⴷⴷⴻⵢⵙⴻⵜ.” ⵜⴻⵏⵏⴰ ⵄⴰⴷ: “ⴰⵔⵣⵓ ⵅⴻⵏⵏⵉ ⵡⵉ ⵉⵍⴰⵏ ⵜⴰⵅⴰⴷⴻⵏⵜ-ⴰ ⵏ ⵓⵛⴻⵎⵎⵉⵄ ⴷ ⵜⵜⴻⵙⴱⵉⵃⵉⵏ-ⴰ ⴷ ⵜⴰⵖⵖⴰⵔⵛⵜ-ⴰ.” ");
INSERT INTO rift_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","ⵢⴰⵀⵓⴷⴰ ⵉⵄⴻⵇⵍ ⵉ-ⵜⴻⵏⵜ, ⵉⵏⵏⴰ: “ⴰⵇⴰ-ⵜⵜ ⴷ ⵏⵉⵛⴰⵏ ⵅⴰⴼⵉ, ⵎⵉⵏⵣⵉ ⵡⴰⵔ ⵜⵜ ⵡⵛⵉⵖ ⴷ ⵜⴰⵎⵖⴰⵔⵜ ⵉ ⵛⴰⵢⵍⴰ ⵎⵎⵉ.” ⵡⴰⵔ ⵉⵇⵇⵉⵎ ⵉⵙⵙⴻⵏ ⵉ-ⵜⵜ ⵄⴰⴷ. ");
INSERT INTO rift_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","ⴷⵉ ⵍⵡⴻⵇⵜ ⵓⵎⵉ ⴷⴷ-ⵜⵉⵡⴻⴹ ⴰⴷ ⴷⴷ-ⵜⴰⵔⵓⵡ, ⴰⵇⴰ ⴷⴰ ⴰⵛⵏⵉⵡⴻⵏ ⴷⴻⴳ ⵓⵄⴻⴷⴷⵉⵙ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","ⵉⵎⵙⴰⵔ ⵓⵎⵉ ⴷⴷ-ⵜⵓⵔⵓⵡ, ⵉⵙⵙⵓⴼⴼⴻⵖ-ⴷⴷ ⵉⵊⵊⴻⵏ ⴰⴼⵓⵙ ⵓⵛⴰ ⵜⴻⴽⵙⵉ ⵜ ⵍⵇⴰⴱⵍⴰ ⵓⵛⴰ ⵜⵛⴻⴷⴷ ⵉ-ⵜ ⵖⴰⵔ ⵓⴼⵓⵙ ⵏⵏⴻⵙ ⵙ ⵓⴼⵉⵍⵓ ⴷ ⴰⵣⴻⴳⴳⵯⴰⵖ, ⵜⴻⵏⵏⴰ: “ⵡⴰ ⵉ ⴷⴷ-ⵉⴼⴼⵖⴻⵏ ⴷ ⴰⵎⴻⵣⵡⴰⵔ.” ");
INSERT INTO rift_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","ⵍⴰⵎⵉ ⴷⴷ ⵢⴰⵔⵔⴰ ⴰⴼⵓⵙ ⵏⵏⴻⵙ, ⵉⴱⴰⵏ-ⴷⴷ ⵓⵎⴰⵙ, ⵓⵛⴰ ⵜⴻⵏⵏⴰ: “ⵎⴰⵎⵎⴻⵛ ⵜⴻⴳⴳⵉⴷ ⵜⴰⵣⵣⵉⵜ. ⴰⴷ ⵜⵉⵍⵉⴷ ⴷ ⴱⵓ-ⵉⵜⵜⴰⵔⴻⵥⵥⴰⵏ!” ⵓⵛⴰ ⵙⴻⵎⵎⴰⵏ ⵜ ⴼⴰⵔⵉⵚ.    ");
INSERT INTO rift_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","ⴰⵡⴰⵔⵏⵉ ⵎⴰⵏ ⴰⵢⴰ ⵉⴼⴼⴻⵖ-ⴷⴷ ⵓⵎⴰⵙ, ⵡⴻⵏⵏⵉ ⵖⴰⵔ ⵉⴵⴰ ⵓⴼⵉⵍⵓ ⴰⵣⴻⴳⴳⵯⴰⵖ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⵙⴻⵎⵎⴰ ⵜ ⵣⴰⵔⴰⵃ. ");
INSERT INTO rift_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","ⵏⴻⴷⵀⴻⵏ ⵅⴻⵏⵏⵉ ⵢⵓⵙⵓⴼ ⵖⴰⵔ ⵎⵉⵚⵔⴰ. ⴱⵓⵜⵉⴼⴰⵔ, ⴰⵎⵙⴻⵅⵅⴰⵔ ⴰⵎⵛⴻⵏⵏⴻⵄ ⵏ ⴼⵉⵔⵄⵓⵏ, ⵍⵇⴻⴱⵟⴰⵏ ⵏ ⵉⵄⴻⵙⵙⴰⵙⴻⵏ ⵏ ⴰⵔⵔⵉⵎⴻⵜ, ⵉⵊⵊ ⵏ ⵓⵎⵉⵚⵔⵉ, ⵉⵙⵖⴰ ⵉ-ⵜ ⵣⴻⴳ ⵓⴼⵓⵙ ⵏ ⵉⵙⵎⴰⵄⵉⵍⵉⵢⵢⴻⵏ, ⵉⵏⵏⵉ ⴷⵉⵏ ⵜ ⵢⵉⵡⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","ⵜⵓⵖⴰ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵢⵓⵙⵓⴼ. ⵜⵓⵖⴰ ⵏⴻⵜⵜⴰ ⴷ ⴰⵔⵢⴰⵣ ⵉⴼⵍⴻⵃ ⵓⵛⴰ ⵜⵓⵖⴰ-ⵜ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵙⵉⴷⵉⵙ, ⴰⵎⵉⵚⵔⵉ. ");
INSERT INTO rift_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","ⵉⵥⵔⴰ ⵙⵉⴷⵉⵙ ⴱⴻⵍⵍⵉ ⵙⵉⴷⵉ ⵜⵓⵖⴰ-ⵜ ⴰⴽⵉⴷⴻⵙ ⵓ ⴱⴻⵍⵍⵉ ⵙⵉⴷⵉ ⵉⵙⵙⴻⴽⴽⵡⴰⴹ ⵙ ⵓⴼⵓⵙ ⵏⵏⴻⵙ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵜⵓⵖⴰ ⵉⵜⵜⴻⴳⴳ. ");
INSERT INTO rift_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","ⴰⵎⵎⵓ ⵉ ⵢⵓⴼⴰ ⵢⵓⵙⵓⴼ ⴰⵔⴹⴰ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵙ, ⵉⵙⴻⵅⵅⴰⵔ ⴰⵙ. ⵓⵛⴰ ⵉⴳⴳⴰ ⵉ-ⵜ ⴱⵓⵜⵉⴼⴰⵔ ⴷ ⴰⵎⴻⵃⴹⴰⵢ ⵅ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⴳⴳⴰ ⴰⵙ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏⵏⴻⵙ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵖⴰⵔⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","ⵣⴻⴳ ⵡⴰⵙⵙ ⵎⵉⵏ ⴷⵉ ⵜ ⵉⴳⴳⴰ ⵅ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⴻⵙ ⵓ ⵅ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵖⴰⵔⴻⵙ, ⵉⴱⴰⵔⴽ ⵙⵉⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵓⵎⵉⵚⵔⵉ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏ ⵢⵓⵙⵓⴼ. ⵜⵓⵖⴰ ⵍⴱⴰⵔⴰⴽⴰ ⵏ ⵙⵉⴷⵉ ⵅ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵖⴰⵔⴻⵙ, ⴰⵎ ⴷⴰⵅⴻⵍ ⵏ ⵜⴰⴷⴷⴰⵔⵜ, ⴰⵎ ⴱⴰⵔⵔⴰ ⴷⴻⴳ ⵉⵢⵢⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵖⴰⵔⴻⵙ, ⵉⵊⵊⴰ ⵉ-ⵜ ⴷⴻⴳ ⵉⴼⴰⵙⵙⴻⵏ ⵏ ⵢⵓⵙⵓⴼ, ⴰⵍ ⵡⴰⵔ ⵉⵙⵙⵉⵏ ⵏⴻⵜⵜⴰ ⵛⴰ ⴽⵜⴰⵔ ⵎⵖⵉⵔ ⴰⵖⵔⵓⵎ ⵉ ⵉⵜⵜⴻⵜⵜ. ⵜⵓⵖⴰ ⵢⵓⵙⵓⴼ ⵉⵛⵏⴰ ⴷⴻⴳ ⵡⴰⴷⴷⵓⴷ ⵓ ⵓⴷⴻⵎ ⵏⵏⴻⵙ ⴷⴰⵢⴻⵙ ⴰⵥⵔⵉ. ");
INSERT INTO rift_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","ⵉⵎⵙⴰⵔ ⴰⵡⴰⵔⵏⵉ ⵎⴰⵏ ⴰⵢⴰ, ⴰⵇⴰ ⵜⴰⵎⵖⴰⵔⵜ ⵏ ⵙⵉⴷⵉⵙ ⵜⴻⵏⴹⴰⵔ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵙ ⴷⵉ ⵢⵓⵙⵓⴼ, ⵜⴻⵏⵏⴰ: “ⵣⵉⴷ, ⵟⵟⴻⵚ ⴰⴽⵉⴷⵉ.” ");
INSERT INTO rift_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","ⵎⴰⵛⴰ ⵏⴻⵜⵜⴰ ⵢⵓⴳⵉ, ⵉⵏⵏⴰ ⵉ ⵜⴻⵎⵖⴰⵔⵜ ⵏ ⵙⵉⴷⴻⵙ: “ⵅⵣⴰⵔ, ⵙⵉⴷⵉ ⵉⵏⵓ ⵡⴰⵔ ⵉⵙⵙⵉⵏ ⵎⵉⵏ ⵉⴵⴰⵏ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵍⴰⵎⵉ ⴷⴰ ⴰⴽⵉⴷⴻⵙ ⴵⵉⵖ. ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵖⴰⵔⴻⵙ, ⵉⴳⴳⴰ ⵉ-ⵜ ⴷⴻⴳ ⵓⴼⵓⵙ ⵉⵏⵓ. ");
INSERT INTO rift_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","ⵏⴻⵜⵜⴰ ⵡⴰⵔ ⵉⴵⵉ ⵙⴻⵏⵏⴻⵊ ⵉⵏⵓ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ-ⴰ, ⵡⴰⵔ ⴷ ⴰⵢⵉ ⵉⵟⵟⵉⴼ ⵙ ⵡⴰⵍⵓ ⵎⵖⵉⵔ ⵛⴻⵎ, ⵓⵎⵉ ⵜⴻⴵⵉⴷ ⴷ ⵜⴰⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ. ⵎⴰⵎⵎⴻⵛ ⵉ ⵖⴰ ⴳⴳⴻⵖ ⵍⵊⴰⵔⵉⵎⴰ-ⵢⴰ ⵜⴰⵎⴻⵇⵇⵔⴰⵏⵜ ⴰⵎ ⵜⴰⵏⵉⵜⴰ ⵓⵛⴰ ⴰⴷ ⴳⴳⴻⵖ ⴷⴷⴻⵏⴱ ⴰⴽ-ⴷ ⴰⵔⴻⴱⴱⵉ!” ");
INSERT INTO rift_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","ⵜⵓⵖⴰ ⵜⴻⵙⵙⴰⵡⴰⵍ ⴰⴽ-ⴷ ⵢⵓⵙⵓⴼ ⴽⵓⵍ ⴰⵙⵙ, ⵡⴰⵔ ⵖⴰⵔⴻⵙ ⵉⵜⵜⴻⵙⵍⵉ, ⵃⵉⵎⴰ ⴰⴷ ⵉⵟⵟⴻⵚ ⵟⵟⴰⵔⴼ ⵏⵏⴻⵙ ⵓ ⵃⵉⵎⴰ ⴰⴷ ⴰⴽⵉⴷⴻⵙ ⵢⵉⵍⵉ. ");
INSERT INTO rift_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","ⴷⴻⴳ ⵉⵊⵊ ⵏ ⵡⴰⵙⵙ ⵜⴻⵎⵙⴰⵔ, ⵓⵎⵉ ⴷⴷ-ⵢⵓⴷⴻⴼ ⵖⴰⵔ ⵜⴰⴷⴷⴰⵔⵜ, ⵃⵉⵎⴰ ⴰⴷ ⵉⴳⴳ ⵍⵅⴻⴷⵎⴻⵜ ⵏⵏⴻⵙ, ⵡⴰⵔ ⵜⵓⵖⵉ ⴷⵉⵏ ⵓⵍⴰ ⴷ ⵉⵊⵊ ⵣⴻⴳ ⵢⴻⵔⵢⴰⵣⴻⵏ ⵏ ⵜⴰⴷⴷⴰⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","ⵅⴻⵏⵏⵉ ⵜᵉⵟⵟⴻⴼⴼ ⵉ-ⵜ ⵣⴻⴳ ⵡⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ, ⵜⴻⵏⵏⴰ: “ⴰⵔⴰⵃ-ⴷⴷ ⵣⵣⴻⵍ ⴰⴽⵉⴷⵉ!” ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⵊⵊⴰ ⴰⵙ ⵏⴻⵜⵜⴰ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ ⴷⴻⴳ ⵓⴼⵓⵙ, ⵢⴰⵔⵡⴻⵍ, ⵉⴼⴼⴻⵖ ⴱⴰⵔⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","ⵓⵎⵉ ⵜⴻⵥⵔⴰ ⴱⴻⵍⵍⵉ ⵉⵊⵊⴰ ⴰⵙ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏⵏⴻⵙ, ⵢⴰⵔⵡⴻⵍ ⵖⴰⵔ ⴱⴰⵔⵔⴰ, ");
INSERT INTO rift_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ⵜⵍⴰⵖⴰ ⵉ ⴰⵢⵜⴱⴰⴱ ⵏ ⵜⴰⴷⴷⴰⵔⵜ, ⵜⴻⵏⵏⴰ ⴰⵙⴻⵏ: “ⵅⵣⴰⵔⴻⵎ, ⴰⵇⴰ ⵏⴻⵜⵜⴰ ⵢⵉⵡⵢ ⴰⵏⴻⵖ-ⴷⴷ ⴰⵔⵢⴰⵣ ⴰⵄⵉⴱⵔⴰⵏⵉ, ⵃⵉⵎⴰ ⴰⴷ ⵅⴰⵏⴻⵖ ⵉⴹⵃⴻⵛ. ⵢⵓⵙⴰ-ⴷⴷ ⵖⴰⵔⵉ, ⵃⵉⵎⴰ ⴰⴽⵉⴷⵉ ⵉⵟⵟⴻⵚ ⵓⵛⴰ ⵏⴻⵛⵛ ⵙⵖⵓⵢⴻⵖ ⵙ ⵊⵊⴻⵀⴷ. ");
INSERT INTO rift_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","ⵓⵎⵉ ⵉⵙⵍⴰ ⴱⴻⵍⵍⵉ ⵙⵙⴳⴻⵄⵄⴷⴻⵖ ⵜⵎⵉⵊⵊⴰ ⵉⵏⵓ ⵓⵛⴰ ⵙⵖⵓⵢⴻⵖ, ⵉⵊⵊⴰ ⵖⴰⵔⵉ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ, ⵢⴰⵔⵡⴻⵍ, ⵉⴼⴼⴻⵖ ⴱⴰⵔⵔⴰ.” ");
INSERT INTO rift_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","ⵓⵛⴰ ⵏⴻⵜⵜⴰⵜ ⵜⴻⴳⴳⴰ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ ⵣⵣⴰⵜⴻⵙ, ⴰⵍ ⴷⴷ ⵖⴰ ⵢⴰⵙ ⵙⵉⴷⵉⵙ ⵖⴰⵔ ⵜⴰⴷⴷⴰⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","ⵅⴻⵏⵏⵉ ⵜⴻⵙⵙⵉⵡⴻⵍ ⴰⴽⵉⴷⴻⵙ ⵙ ⵡⴰⵡⴰⵍⴻⵏ ⵏⵏⵉ ⴷ ⵉⵊⵊⴻⵏ, ⵜⴻⵏⵏⴰ: “ⴰⵎⵙⴻⵅⵅⴰⵔ ⴰⵄⵉⴱⵔⴰⵏⵉ ⵡⴻⵏⵏⵉ ⴷⴷ-ⵜⵉⵡⵢⴻⴷ ⵖⴰⵔⵏⴻⵖ, ⵢⵓⵙⴰ-ⴷⴷ ⵖⴰⵔⵉ ⵃⵉⵎⴰ ⴰⴷ ⴰⵢⵉ ⵉⵙⵙⵄⵓⵔⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","ⵓⵎⵉ ⵙⵙⴳⴻⵄⵄⴷⴻⵖ ⵜⵎⵉⵊⵊⴰ ⵉⵏⵓ, ⵙⵖⵓⵢⴻⵖ, ⵉⵊⵊⴰ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ ⵖⴰⵔⵉ ⵓⵛⴰ ⵢⴰⵔⵡⴻⵍ ⴱⴰⵔⵔⴰ.” ");
INSERT INTO rift_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","ⵙⵉⴷⴻⵙ ⵉⵙⵍⴰ ⵉ ⵡⴰⵡⴰⵍⴻⵏ ⵉⵏⵏⵉ ⴷ ⴰⵙ ⵜⴻⵏⵏⴰ ⵜⴻⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ, ⵜⴻⵏⵏⴰ: “ⴰⵎⵎⵓ ⵉ ⴷ ⴰⵢⵉ ⵉⴳⴳⴰ ⵓⵎⵙⴻⵅⵅⴰⵔ ⵏⵏⴻⵛ!”, ⵓⵛⴰ ⵉⵅⴻⵢⵢⴻⵇ ⴰⵟⵟⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","ⵉⵟⵟⴻⴼ ⵉ-ⵜ ⵙⵉⴷⵉ ⵏ ⵢⵓⵙⵓⴼ, ⵉⴳⴳⴰ ⵉ-ⵜ ⴷⵉ ⵍⴻⵃⴱⴻⵙ, ⵎⴰⵏⵉ ⵜⵓⵖⴰ ⵉⵎⴻⵃⴱⴰⵙ ⵏ ⵓⵊⴻⴵⵉⴷ. ⴰⵎⵎⵓ ⵉ ⵉⵇⵇⵉⵎ ⴷⵉ ⵍⴻⵃⴱⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","ⵎⴰⵛⴰ ⵙⵉⴷⵉ ⵜⵓⵖⴰ-ⵜ ⴰⴽ-ⴷ ⵢⵓⵙⵓⴼ ⵓⵛⴰ ⵉⵙⵙⵡⵉⵥⵥⴻⴹ ⵖⴰⵔⴻⵙ ⵙ ⵜⵎⴻⵅⵙⵉⵡⵜ ⵏⵏⴻⵙ ⵉⵛⴻⵡⵡⴰⵔⴻⵏ ⵓⵛⴰ ⵉⵡⵛⴰ ⴰⵙ ⴰⵔⴹⴰ ⵏⵏⴻⵙ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵓⵎⴻⵇⵇⵔⴰⵏ ⵏ ⵍⴻⵃⴱⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","ⵓⵛⴰ ⴰⵎⴻⵇⵇⵔⴰⵏ ⵏ ⵍⴻⵃⴱⴻⵙ ⵢⴰⵔⵔⴰ ⵎⴰⵔⵔⴰ ⵉⵎⴻⵃⴱⴰⵙ ⵏⵏⵉ ⵜⵓⵖⴰ ⴷⵉ ⵍⴻⵃⴱⴻⵙ ⵙⴰⴷⵓ ⵓⴼⵓⵙ ⵏ ⵢⵓⵙⵓⴼ. ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵜⵓⵖⴰ ⵜⵜⴻⴳⴳⴻⵏ ⴷⵉⵏ ⵜⵓⵖⴰ ⵉⵜⵜⴻⴽⴽ ⵅ ⵓⴼⵓⵙ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","ⴰⵎⴻⵇⵇⵔⴰⵏ ⵏ ⵍⴻⵃⴱⴻⵙ ⵡⴰⵔ ⴷ ⴰⵙ ⵉⵇⵇⵉⵎ ⵎⵉⵏ ⵅⴻⴼ ⵖⴰ ⵉⵏⵏⴻⵀⵡⴻⵍ ⵣⵉ ⵎⵉⵏ ⵜⵓⵖⴰ ⵙⴰⴷⵓ ⵓⴼⵓⵙ ⵏⵏⴻⵙ, ⵎⵉⵏⵣⵉ ⵙⵉⴷⵉ ⵜⵓⵖⴰ ⴰⴽ-ⴷ ⵢⵓⵙⵓⴼ. ⵎⵉⵏ ⵎⴰ ⵜⵓⵖⴰ ⵉⵜⵜⴻⴳⴳ ⵏⴻⵜⵜⴰ, ⵙⵉⴷⵉ ⵉⵙⵙⴻⴽⴽⵡⴰⴹ ⵉ-ⵜ. ");
INSERT INTO rift_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","ⵉⵎⵙⴰⵔ ⴰⵡⴰⵔⵏⵉ ⵎⴰⵏ ⴰⵢⴰ ⴱⴻⵍⵍⵉ ⴰⵡⴰⵔⵔⴰⴷ ⵏ ⵓⵊⴻⴵⵉⴷ ⵏ ⵎⵉⵚⵔⴰ ⴷ ⵓⵅⴻⴱⴱⴰⵣ ⴷⴻⵏⵏⴱⴻⵏ ⴹⵉⴷⴷ ⵉ ⵙⵉⴷⵉⵜⵙⴻⵏ, ⴰⵊⴻⴵⵉⴷ ⵏ ⵎⵉⵚⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","ⵉⴼⴼⵓⴳⴻⵎ ⴼⵉⵔⵄⵓⵏ ⵅ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵉⵛⴻⵏⵏⵄⴻⵏ ⵏⵏⴻⵙ, ⵅ ⵓⵎⴻⵇⵇⵔⴰⵏ ⵏ ⵉⵡⴰⵔⵔⴰⴷⴻⵏ ⵓ ⵅ ⵓⵎⴻⵇⵇⵔⴰⵏ ⵏ ⵉⵅⴻⴱⴱⴰⵣⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","ⵉⴳⴳⴰ ⵉ-ⵜⴻⵏ ⴷⴻⴳ ⵓⵃⴻⵟⵟⵓ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵍⵇⴻⴱⵟⴰⵏ ⵏ ⵉⵄⴻⵙⵙⴰⵙⴻⵏ ⵏ ⴰⵔⵔⵉⵎⴻⵜ, ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵜⵄⴻⵙⵙⴰⵙⵜ, ⵎⴰⵏⵉ ⵉⵃⴻⴱⴱⴻⵙ ⵢⵓⵙⵓⴼ. ");
INSERT INTO rift_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","ⵍⵇⴻⴱⵟⴰⵏ ⵏ ⵉⵄⴻⵙⵙⴰⵙⴻⵏ ⵏ ⴰⵔⵔⵉⵎⴻⵜ ⵉⴳⴳⴰ ⵢⵓⵙⵓⴼ ⴷ ⴰⵎⴻⵃⴹⴰⵢ ⵏⵙⴻⵏ, ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵜⵓⵖⴰ ⵉⵜⵜⵙⴻⵅⵅⴰⵔ ⵅⴰⵙⴻⵏ. ⴰⵎⵎⵓ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⵓⵙⵙⴰⵏ ⴷ ⵉⵣⵉⵔⴰⵔⴻⵏ ⴷⵉ ⵍⴻⵃⴱⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","ⵓⵔⵊⵉⵏ ⵜⴰⵔⵊⵉⵜ ⵙ ⵜⵏⴰⵢⴻⵏ ⵉⴷⵙⴻⵏ ⵏⵙⴻⵏ, ⴽⵓⵍ ⵉⵊⵊⴻⵏ ⵣⵣⴰⵢⵙⴻⵏ ⵢⵓⵔⵊⴰ ⴷⵉ ⴵⵉⵍⴻⵜ ⵏⵏⵉ ⵜⴰⵔⵊⵉⵜ ⵏⵏⴻⵙ ⵙ ⵍⵎⴻⵄⵏⴰ ⵏⵏⴻⵙ, ⴰⵎ ⵓⵡⴰⵔⵔⴰⴷ ⴰⵎ ⵓⵅⴻⴱⴱⴰⵣ ⵏ ⵓⵊⴻⴵⵉⴷ ⵏ ⵎⵉⵚⵔⴰ, ⵉⵏⵏⵉ ⵜⵓⵖⴰ ⵉⵜⵜⵡⴰⵃⴻⴱⴱⵙⴻⵏ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵜⵄⴻⵙⵙⴰⵙⵜ. ");
INSERT INTO rift_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","ⵓⵛⴰ ⵢⵓⵙⴰ-ⴷⴷ ⵖⴰⵔⵙⴻⵏ ⵢⵓⵙⵓⴼ ⵅ ⵚⵚⴱⴻⵃ, ⵉⵅⵣⴰⵔ ⴷⴰⵢⵙⴻⵏ ⵓⵛⴰ ⵉⵥⵔⴰ ⵉ-ⵜⴻⵏ ⵜⵜⵇⴻⵍⵍⵇⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⵙⵙⴻⵇⵙⴰ ⵏⴻⵜⵜⴰ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵉⵛⴻⵏⵏⵄⴻⵏ ⵏ ⴼⵉⵔⵄⵓⵏ, ⵉⵏⵏⵉ ⵜⵓⵖⴰ ⴰⴽⵉⴷⴻⵙ ⴷⵉ ⵍⴻⵃⴱⴻⵙ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵙⵉⴷⵉⵙ, ⵉⵏⵏⴰ: “ⵎⴰⵖⴰⵔ ⴱⴰⵔⴻⵛⵏⴻⵏ ⵓⴷⵎⴰⵡⴻⵏ ⵏⵡⴻⵎ ⴰⵙⵙ-ⴰ ⵇⴰⵄ ⴰⵎⵎⵓ?” ");
INSERT INTO rift_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","ⵏⵉⵜⵏⵉ ⵏⵏⴰⵏ: “ⴰⵇⴰ ⵏⵓⵔⵊⴰ ⵜⴰⵔⵊⵉⵜ, ⵡⴰⵔ ⴷⴰ ⵡⵉ ⵜⵜ ⵖⴰ ⵉⴼⴻⴽⴽⴻⵏ.” ⵉⵏⵏⴰ ⴰⵙⴻⵏ ⵢⵓⵙⵓⴼ: “ⵎⴰ ⵡⴰⵔ ⴵⵉⵏ ⵛⴰ ⵉⴼⴻⵙⵙⴰⵔⴻⵏ ⵣⵉ ⴰⵔⴻⴱⴱⵉ? ⵉⵡⴰ, ⵄⴰⵡⴷⴻⵎ ⴰⵢⵉ ⵜⴻⵏⵜ ⵍⴻⵅⵅⵓ!” ");
INSERT INTO rift_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","ⵅⴻⵏⵏⵉ ⵉⵄⴰⵡⴻⴷ ⵓⵎⴻⵇⵇⵔⴰⵏ ⵏ ⵉⵡⴰⵔⵔⴰⴷⴻⵏ ⵜⴰⵔⵊⵉⵜ ⵏⵏⴻⵙ ⵉ ⵢⵓⵙⵓⴼ, ⵉⵏⵏⴰ ⴰⵙ: “ⵏⴻⵛⵛ ⴷⵉ ⵜⴰⵔⵊⵉⵜ ⵉⵏⵓ ⵥⵔⵉⵖ ⵜⴰⵣⴰⵢⴰⵔⵜ ⵣⵣⴰⵜⵉ ⵜⴱⴻⴷⴷ. ");
INSERT INTO rift_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ⵜⴰⵣⴰⵢⴰⵔⵜ ⵏⵏⵉ ⵖⴰⵔⴻⵙ ⵜⵍⴰⵜⴰ ⵏ ⵜⵙⴻⴹⵡⵉⵏ. ⵅⵎⵉ ⵜⴻⵙⵙⴻⵏⴷⵉⵢ, ⵉⵜⵜⴳⴻⵄⵄⴰⴷ ⵏⵏⵓⵡⵡⴰⵔ ⵏⵏⴻⵙ ⵓ ⵖⴰⵔ ⵉⵣⴻⴽⴽⵓⵏⴻⵏ ⵏⵏⴻⵙ ⵉⴱⴰⵏ-ⴷⴷ ⵍⵃⴻⴱⴱ ⵏ ⵓⴹⵉⵍ ⵢⵉⵡⴻⴹ. ");
INSERT INTO rift_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","ⵓⵛⴰ ⵍⴽⴰⵙ ⵏ ⴼⵉⵔⵄⵓⵏ ⵜⵓⵖⴰ-ⵜ ⵖⴰⵔⵉ ⴷⴻⴳ ⵓⴼⵓⵙ ⵉⵏⵓ ⵓⵛⴰ ⴽⵙⵉⵖ ⴰⴹⵉⵍ ⵏⵏⵉ ⵓⵛⴰ ⵄⴻⵙⵙⴰⵔⴻⵖ ⵜ ⴷⵉ ⵍⴽⴰⵙ ⵏ ⴼⵉⵔⵄⵓⵏ ⵓⵛⴰ ⵙⵙⴻⵄⴷⵓⵖ ⵍⴽⴰⵙ ⵖⴰⵔ ⵓⴼⵓⵙ ⵏ ⴼⵉⵔⵄⵓⵏ.” ");
INSERT INTO rift_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","ⵉⵏⵏⴰ ⴰⵙ ⵢⵓⵙⵓⴼ: “ⴷ ⵡⴰ ⴷ ⴰⴼⴻⵙⵙⴰⵔ ⵏⵏⴻⵙ: ⵜⵍⴰⵜⴰ ⵏ ⵜⵉⵙⴻⴹⵡⵉⵏ, ⴰⵇⴰ ⴷ ⵜⵍⴰⵜⴰ ⵏ ⵡⵓⵙⵙⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","ⵄⴰⴷ ⵜⵍⴰⵜⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⵅⴻⵏⵏⵉ ⴰⴷ ⴰⵛ ⵉⵙⵙⴳⴻⵄⵄⴻⴷ ⴼⵉⵔⵄⵓⵏ ⴰⵣⴻⴵⵉⴼ ⵏⵏⴻⵛ ⵓⵛⴰ ⴰⴷ ⵛⴻⴽ ⵢⴰⵔⵔ ⵖⴰⵔ ⵜⵙⴻⵅⵅⴰⵔⵜ ⵏⵏⴻⵛ, ⴰⴷ ⵜⴻⵙⵙⴻⵄⴷⵓⴷ ⵍⴽⴰⵙ ⵉ ⴼⵉⵔⵄⵓⵏ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏⵏⴻⵙ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⵓⵖⴰ ⵜⴰⵙⵖⴰⵔⵜ ⵏⵏⴻⵛ ⵣⵉⵛ ⵍⴰⵎⵉ ⵛⴻⴽ ⵜⵓⵖⴰ ⴷ ⴰⵡⴰⵔⵔⴰⴷ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","ⵎⴰⵛⴰ ⵄⵇⴻⵍ ⵅⴰⴼⵉ ⵅⵎⵉ ⴷ ⴰⵛ ⴷⴷ ⵖⴰ ⵢⴰⵙ ⵍⵅⴰⵔ, ⵜⵜⵣⴰⵡⴰⴳⴻⵖ ⵛⴻⴽ ⴰⴷ ⴽⵉⴷⵉ ⵜⴻⴳⴳⴻⴷ ⵙ ⵜⵎⴻⵅⵙⵉⵡⵜ ⵉⵛⴻⵡⵡⴰⵔⴻⵏ ⵓⵛⴰ ⴻⵊⵊ ⴼⵉⵔⵄⵓⵏ ⴰⴷ ⵅⴰⴼⵉ ⵉⵄⵇⴻⵍ ⵓⵛⴰ ⴼⴻⴽⴽ ⴰⵢⵉ-ⴷⴷ ⵣⵉ ⵜⴰⴷⴷⴰⵔⵜ-ⴰ. ");
INSERT INTO rift_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","ⵎⵉⵏⵣⵉ ⵓⵛⴰⵔⴻⵏ ⴰⵢⵉ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵉⵄⵉⴱⵔⴰⵏⵉⵢⵢⴻⵏ ⵓ ⴷⴰ ⵡⴰⵔ ⴳⴳⵉⵖ ⵅ ⵎⵉⵏ ⵅⴻⴼ ⴷⴰⵢⵉ ⵉ ⵖⴰ ⴳⴳⴻⵏ ⴷⴻⴳ ⵡⴻⵃⴼⵓⵔ ⵏ ⵉⵎⴻⵃⴱⴰⵙ.” ");
INSERT INTO rift_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","ⵍⴰⵎⵉ ⵉⵥⵔⴰ ⵓⵎⴻⵇⵇⵔⴰⵏ ⵏ ⵉⵅⴻⴱⴱⴰⵣⴻⵏ ⴱⴻⵍⵍⵉ ⵉⴼⴻⵙⵙⴰⵔ ⴰⵙ ⵎⵍⵉⵃ, ⵉⵏⵏⴰ ⵉ ⵢⵓⵙⵓⴼ: “ⵓⵍⴰ ⴷ ⵏⴻⵛⵛ ⵥⵔⵉⵖ ⴷⵉ ⵜⴰⵔⵊⵉⵜ ⵉⵏⵓ ⵜⵍⴰⵜⴰ ⵏ ⵜⵙⵓⴵⴰⵜⵉⵏ ⵙ ⵡⴻⵖⵔⵓⵎ ⴷ ⴰⵛⴻⵎⵍⴰⵍ ⵅ ⵓⵣⴻⴵⵉⴼ ⵉⵏⵓ. ");
INSERT INTO rift_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","ⴷⵉ ⵜⵙⵓⴵⴻⵜ ⵏ ⵙⴻⵏⵏⴻⵊ ⵜⵓⵖⴰ ⴷⴰⵢⴻⵙ ⴰⵟⵟⴰⵙ ⵏ ⵎⴰⵛⵛⴰ ⵉ ⴼⵉⵔⵄⵓⵏ ⵉ ⵉⴳⴳⴰ ⵓⵅⴻⴱⴱⴰⵣ ⵓ ⵉⵊⴹⴰⴹ ⵜⵜᵉⵜⵜⴻⵏ ⵣⵉ ⵜⵙⵓⴵⴻⵜ ⵉ ⵉⴵⴰⵏ ⵅ ⵓⵣⴻⴵⵉⴼ ⵉⵏⵓ.” ");
INSERT INTO rift_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","ⵢⴰⵔⵔⴰ-ⴷⴷ ⵅⴰⵙ ⵢⵓⵙⵓⴼ, ⵉⵏⵏⴰ: “ⴷ ⵡⴰ ⴷ ⴰⴼⴻⵙⵙⴰⵔ ⵏⵏⴻⵙ. ⵜⵍⴰⵜⴰ ⵏ ⵜⵙⵓⴵⴰⵜⵉⵏ ⴷ ⵜⵍⴰⵜⴰ ⵏ ⵡⵓⵙⵙⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","ⵄⴰⴷ ⵜⵍⴰⵜⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⵅⴻⵏⵏⵉ ⴰⴷ ⵅⴰⴽ ⵉⵙⵙⴳⴻⵄⵄⴻⴷ ⴼⵉⵔⵄⵓⵏ ⴰⵣⴻⴵⵉⴼ ⵏⵏⴻⵛ ⵊⵎⵉⵄ ⴰⴽⵉⴽ ⵓⵛⴰ ⴰⴷ ⵛⴻⴽ ⵢⴰⵢⴻⵍ ⵅ ⵉⵛⵜ ⵏ ⵜⵛⴻⵊⵊⴰⵔⵜ ⵓ ⵉⵊⴹⴰⴹ ⴰⴷ ⵛⵛⴻⵏ ⴰⵢⵙⵓⵎ ⵏⵏⴻⵛ.” ");
INSERT INTO rift_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵜⵍⴰⵜⴰ, ⴰⵙⵙ ⵏ ⵡⴻⵅⵍⴰⵇ ⵏ ⴼⵉⵔⵄⵓⵏ, ⵉⵎⵙⴰⵔ ⴱⴻⵍⵍⵉ ⵉⵙⵙⴻⵡⵊⴻⴷ ⵉⵛⵜ ⵏ ⵣⵣⴰⵔⴷⴻⵜ ⵉ ⵎⴰⵔⵔⴰ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⵙⵙⴳⴻⵄⵄⴻⴷ ⴰⵣⴻⴵⵉⴼ ⵏ ⵓⵎⴻⵇⵇⵔⴰⵏ ⵏ ⵉⵡⴰⵔⵔⴰⴷⴻⵏ ⵓ ⴰⵣⴻⴵⵉⴼ ⵏ ⵓⵎⴻⵇⵇⵔⴰⵏ ⵏ ⵉⵅⴻⴱⴱⴰⵣⴻⵏ ⵜⵓⵖⴰ-ⵜ ⵊⴰⵔ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵢⴰⵔⵔⴰ ⴰⵎⴻⵇⵇⵔⴰⵏ ⵏ ⵉⵡⴰⵔⵔⴰⴷⴻⵏ ⵖⴰⵔ ⵍⵅⴻⴷⵎⴻⵜ ⵏⵏⴻⵙ ⵏ ⵓⵡⴰⵔⵔⴰⴷ, ⴰⵍⴰⵎⵉ ⵡⴰⵏⵉⵜⴰ ⵉⵡⵛⴰ ⵄⴰⵡⴻⴷ ⴰⵖⴰⵔⵔⴰⴼ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏ ⴼⵉⵔⵄⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","ⵎⴰⵛⴰ ⴰⵎⴻⵇⵇⵔⴰⵏ ⵏ ⵉⵅⴻⴱⴱⴰⵣⴻⵏ ⵢⵓⵢⴻⵍ ⵉ-ⵜ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵙ ⵉⴼⴻⵙⵙⴰⵔ ⵢⵓⵙⵓⴼ. ");
INSERT INTO rift_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","ⵎⴰⵛⴰ ⴰⵎⴻⵇⵇⵔⴰⵏ ⵏ ⵉⵡⴰⵔⵔⴰⴷⴻⵏ ⵡⴰⵔ ⵉⴼⴻⴽⴽⴰⵔ ⵛⴰ ⵄⴰⴷ ⴷⵉ ⵢⵓⵙⵓⴼ, ⵉⵜⵜⵓ ⵜ. ");
INSERT INTO rift_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⵄⴷⵓⵏ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵢⵓⵔⵊⴰ ⴼⵉⵔⵄⵓⵏ ⴰⵇⴰ ⵏⴻⵜⵜⴰ ⵣⴻⵄⵎⴰ ⵉⴱⴻⴷⴷ ⵅ ⵢⴻⵖⵣⴰⵔ ⵏ ⵏⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","ⵅⵣⴰⵔ, ⴳⴻⵄⵄⴷⴻⵏⵜ-ⵉ-ⴷⴷ ⵙⴻⴱⵄⴰ ⵏ ⵜⴼⵓⵏⴰⵙⵉⵏ ⵣⴻⴳ ⵉⵖⵣⴰⵔ, ⵚⴻⴱⵃⴻⵏⵜ ⵉ ⵍⵅⴻⵣⵔⴰⵜ ⵓ ⵄⴻⵎⵎⴰⵔⴻⵏⵜ ⵙ ⵡⴻⵢⵙⵓⵎ, ⵀⴻⴷⴷⴰⵏⵜ ⵊⴰⵔ ⵡⴻⵃⵜⵉⵛ ⵏ ⵓⵖⴰⵏⵉⵎ. ");
INSERT INTO rift_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","ⵓ ⵅⵣⴰⵔ, ⵙⴻⴱⵄⴰ ⵏ ⵜⴼⵓⵏⴰⵙⵉⵏ ⵏⵏⴻⵖⵏⵉ ⴳⴻⵄⵄⴷⴻⵏⵜ-ⵉ-ⴷⴷ ⴰⵡⴰⵔⵏⵉ ⴰⵙⴻⵏⵜ ⵣⴻⴳ ⵉⵖⵣⴰⵔ. ⵏⵉⵜⴻⵏⵜⵉ ⵡⴰⵔ ⵃⵍⵉⵏⵜ ⵉ ⵍⵅⴻⵣⵔⴰⵜ, ⴰⵇⴰ ⴽⴽⵓⵛⵛⴹⴻⵏⵜ ⵓⵛⴰ ⴱⴻⴷⴷⴻⵏⵜ ⵣⵣⴰⵜ ⵉ ⵜⴼⵓⵏⴰⵙⵉⵏ ⵏⵏⴻⵖⵏⵉ ⵖⴰⵔ ⵜⵎⴰ ⵏ ⵉⵖⵣⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","ⵜⵉⴼⵓⵏⴰⵙⵉⵏ ⵉ ⵡⴰⵔ ⵉⵃⵍⵉⵏ ⵉ ⵍⵅⴻⵥⵔⴰⵜ, ⵜⵉⵏⵏⵉ ⵉⴽⵓⵛⵛⴹⴻⵏ, ⵚⴰⵔⴹⴻⵏⵜ ⵙⴻⴱⵄⴰ ⵏ ⵜⴼⵓⵏⴰⵙⵉⵏ ⵉⵚⴻⴱⵃⴻⵏ ⵉ ⵍⵅⴻⵣⵔⴰⵜ, ⵜⵉⵏⵏⵉ ⵉⵚⴻⵃⵃⴻⵏ. ⵓⵛⴰ ⵉⴼⴰⵇ-ⴷⴷ ⴼⵉⵔⵄⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","ⵉⵟⵟⴻⵚ ⵄⴰⵡⴻⴷ ⵓⵛⴰ ⵢⵓⵔⵊⴰ ⵜⵡⴰⵍⴰ ⵏⵏⴻⵖⵏⵉ, ⵓ ⵅⵣⴰⵔ, ⵣⴻⴳ ⵉⵛⵜ ⵏ ⵜⵙⴻⵟⵟⴰ ⴳⴻⵄⵄⴷⴻⵏⵜ ⵙⴻⴱⵄⴰ ⵏ ⵜⵉⴷⵔⵉⵏ ⵛⵛⵓⵔⴻⵏⵜ, ⵛⵏⴰⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","ⵓ ⵅⵣⴰⵔ, ⵖⴻⵎⵢⴻⵏⵜ-ⵉ-ⴷⴷ ⵙⴻⴱⵄⴰ ⵏ ⵜⵉⴷⵔⵉⵏ ⵇⵇⵓⵙⴱⴰⵔⴻⵏ ⴰⵡⴰⵔⵏⵉ ⴰⵙⴻⵏⵜ, ⵉⵙⵙⵛⴻⵎⴹ ⵉ-ⵜⴻⵏⵜ ⵓⵙⴻⵎⵎⵉⴹ ⴰⵛⴰⵔⵇⵉ. ");
INSERT INTO rift_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","ⵙⴻⴱⵄⴰ ⵏ ⵜⵉⴷⵔⵉⵏ ⵇⵇⵓⵙⴱⴰⵔⴻⵏⵜ ⵚⴰⵔⴹⴻⵏⵜ ⵙⴻⴱⵄⴰ ⵏ ⵜⵉⴷⵔⵉⵏ ⵉⵢⵎⴰⵏ ⴷ ⵉⵛⵛⵓⵔⴻⵏ. ⵓⵛⴰ ⵉⴼⴰⵇ-ⴷⴷ ⴼⵉⵔⵄⵓⵏ, ⵓ ⵅⵣⴰⵔ, ⴰⵇⴰ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵔⵊⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","ⵖⴰⵔ ⵚⵚⴱⴻⵃ ⵉⴱⴰⵏ-ⴷⴷ ⴱⴻⵍⵍⵉ ⴱⵓⵃⴱⴻⵍ ⵏⵏⴻⵙ ⵉⵏⵏⴻⵀⵡⴻⵍ ⵓⵛⴰ ⵉⵙⵙⴻⴽⴽ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴷⴷ-ⵍⴰⵖⴰⵏ ⵉ ⵎⴰⵔⵔⴰ ⵜⴰⵔⵡⴰ ⵏ ⵜⵙⴻⵃⵃⴰⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⵓ ⵉ ⵎⴰⵔⵔⴰ ⵉⵎⵉⵖⵉⵙⴻⵏ. ⵉⵄⴰⵡⴷ ⴰⵙⴻⵏ ⴼⵉⵔⵄⵓⵏ ⵜⴰⵔⵊⵉⵜ ⵏⵏⴻⵙ, ⵎⴰⵛⴰ ⵡⴰⵔ ⴷⵉⵏ ⵜⵓⵖⵉ ⵃⴻⴷ ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵜⵜ ⵉⴼⴻⵙⵙⴰⵔ ⵉ ⴼⵉⵔⵄⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","ⵉⵙⵙⵉⵡⴻⵍ ⵓⵎⴻⵇⵇⵔⴰⵏ ⵏ ⵉⵡⴰⵔⵔⴰⴷⴻⵏ ⴰⴽ-ⴷ ⴼⵉⵔⵄⵓⵏ, ⵉⵏⵏⴰ: “ⴷⴻⴳ ⵡⴰⵙⵙ-ⴰ ⴰⴷ ⵜⵜⵡⴰⵙⵄⴻⵇⵍⴻⵖ ⵅ ⴷⴷⵏⵓⴱ ⵉⵏⵓ. ");
INSERT INTO rift_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","ⵓⵎⵉ ⵉⴼⴼⵓⴳⴻⵎ ⴼⵉⵔⵄⵓⵏ ⵅ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵙ, ⵉⴳⴳⴰ ⴰⵢⵉ ⴷⵉ ⵍⴻⵃⴱⴻⵙ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵍⵇⴻⴱⵟⴰⵏ ⵏ ⵉⵄⴻⵙⵙⴰⵙⴻⵏ ⵏ ⴰⵔⵔⵉⵎⴻⵜ, ⴰⵎ ⵏⴻⵛⵛ ⴰⵎ ⵓⵎⴻⵇⵇⵔⴰⵏ ⵏ ⵉⵅⴻⴱⴱⴰⵣⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","ⵏⴻⵛⵛ ⴷ ⵏⴻⵜⵜⴰ ⵏⵓⵔⵊⴰ ⵉⵛⵜ ⵏ ⵜⴰⵔⵊⵉⵜ ⴷⵉ ⴵⵉⵔⴻⵜ ⴷ ⵉⵛⵜ. ⴽⵓⵍ ⵉⵊⵊ ⵣⵣⴰⵢⵏⴻⵖ ⵢⵓⵔⵊⴰ ⵜⴰⵔⵊⵉⵜ ⵏⵏⴻⵙ ⵙ ⵍⵎⴻⵄⵏⴰ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","ⵜⵓⵖⴰ ⴷⵉⵏ ⴰⴽⵉⴷⵏⴻⵖ ⵉⵊⵊ ⵏ ⵓⴱⵍⵉⵖ ⴷ ⴰⵄⵉⴱⵔⴰⵏⵉ. ⵜⵓⵖⴰ-ⵜ ⴷ ⴰⵎⵙⴻⵅⵅⴰⵔ ⵏ ⵍⵇⴻⴱⵟⴰⵏ ⵏ ⵉⵄⴻⵙⵙⴰⵙⴻⵏ ⵏ ⴰⵔⵔⵉⵎⴻⵜ. ⵏⵃⴰⵊⴰ ⴰⵙ ⵜⵉⵔⵊⴰ ⵏⵏⴻⵖ ⵓⵛⴰ ⵉⴼⴻⵙⵙⴰⵔ ⴰⵏⴻⵖ ⵜⴻⵏⵜ. ⵉ ⴽⵓⵍ ⵉⵊⵊ ⵣⵣⴰⵢⵏⴻⵖ ⵉⴼⴻⵙⵙⴰⵔ ⴰⵙ ⵜⴰⵔⵊⵉⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⴻⵏⵜ ⵉⴼⴻⵙⵙⴰⵔ, ⴰⵎⴻⵏⵏⵉ ⵉ ⵉⵎⵙⴰⵔ. ⴰⵇⴰ ⴼⵉⵔⵄⵓⵏ ⵢⴰⵔⵔⴰ ⴰⵢⵉ ⵏⴻⵛⵛ ⵖⴰⵔ ⵍⵅⴻⴷⵎⴻⵜ ⵉⵏⵓ ⵓ ⵡⴻⵏⵏⴻⵖⵏⵉ ⵢⵓⵢⴻⵍ ⵉ-ⵜ.” ");
INSERT INTO rift_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","ⵉⵙⵙⴻⴽⴽ ⴼⵉⵔⵄⵓⵏ ⵃⵉⵎⴰ ⴰⴷ ⴷⴷ-ⵍⴰⵖⴰⵏ ⵅ ⵢⵓⵙⵓⴼ ⵓⵛⴰ ⵙⵙⵓⴼⴼⵖⴻⵏ ⵜ-ⵉ-ⴷⴷ ⴷⴻⵖⵢⴰ ⵣⴻⴳ ⵡⴻⵃⴼⵓⵔ ⵏ ⵉⵎⴻⵃⴱⴰⵙ. ⵉⵃⴻⴼⴼ ⴰⵛⵓⵡⵡⴰⴼ, ⵉⴱⴻⴷⴷⴻⵍ ⴰⵔⵔⵓⴹ ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⵢⵓⴷⴻⴼ ⵖⴰⵔ ⴼⵉⵔⵄⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","ⵉⵏⵏⴰ ⴼⵉⵔⵄⵓⵏ ⵉ ⵢⵓⵙⵓⴼ: “ⵏⴻⵛⵛ ⵓⵔⵊⵉⵖ ⵉⵛⵜ ⵏ ⵜⴰⵔⵊⵉⵜ, ⵡⴰⵔ ⵉⴵⵉ ⵡⵉ ⵜⵜ ⵖⴰ ⵉⴼⴻⵙⵙⴰⵔⴻⵏ. ⵎⴰⵛⴰ ⴰⵇⴰ ⵙⵍⵉⵖ ⵅⴰⴽ ⴱⴻⵍⵍⵉ ⵛⴻⴽ, ⵅⵎⵉ ⵉ ⵖⴰ ⵜⴻⵙⵍⵉⴷ ⵉ ⵜⴰⵔⵊⵉⵜ, ⵜⵣⴻⵎⵎⴰⵔⴻⴷ ⴰⴷ ⵜⵜ ⵜⴼⴻⵙⵙⴰⵔⴻⴷ.” ");
INSERT INTO rift_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","ⵢⴰⵔⵔⴰ-ⴷⴷ ⵢⵓⵙⵓⴼ ⵅ ⴼⵉⵔⵄⵓⵏ, ⵉⵏⵏⴰ: “ⵡⴰⵔ ⵉⴵⵉ ⵛⴰ ⵣⵣⴰⵢⵉ, ⵎⴰⵛⴰ ⴰⵔⴻⴱⴱⵉ ⴰⴷ ⴷⴷ-ⵢⴰⵔⵔ ⵅ ⵎⴰⵎⵎⴻⵛ ⵖⴰ ⵉⴷⵡⴻⵍ ⵓⵎⴻⴷⴷⵓⵔ ⵏ ⴼⵉⵔⵄⵓⵏ.” ");
INSERT INTO rift_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","ⵉⵏⵏⴰ ⴼⵉⵔⵄⵓⵏ ⵉ ⵢⵓⵙⵓⴼ: “ⴷⵉ ⵜⴰⵔⵊⵉⵜ ⵉⵏⵓ ⵥⵔⵉⵖ ⵉⵅⴻⴼ ⵉⵏⵓ ⴱⴻⴷⴷⴻⵖ ⵅ ⵜⵎⴰ ⵏ ⵉⵖⵣⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ⴰⵇⴰ ⴳⴻⵄⵄⴷⴻⵏⵜ-ⵉ-ⴷⴷ ⵙⴻⴱⵄⴰ ⵏ ⵜⴼⵓⵏⴰⵙⵉⵏ ⵣⴻⴳ ⵉⵖⵣⴰⵔ, ⵚⴻⵃⵃⴻⵏⵜ ⵓ ⵚⴻⴱⵃⴻⵏⵜ ⵉ ⵍⵅⴻⵣⵔⴰⵜ, ⵀⴻⴷⴷⴰⵏⵜ ⵊⴰⵔ ⵡⴻⵃⵜⵉⵛ ⵏ ⵓⵖⴰⵏⵉⵎ. ");
INSERT INTO rift_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","ⴰⵡⴰⵔⵏⵉ ⴰⵙⴻⵏⵜ ⵙⴻⴱⵄⴰ ⵏ ⵜⴼⵓⵏⴰⵙⵉⵏ ⵏⵏⴻⵖⵏⵉ ⴳⴻⵄⵄⴷⴻⵏⵜ-ⵉ-ⴷⴷ. ⵜⵓⵖⴰ ⴽⴽⵓⵛⵛⴹⴻⵏⵜ ⵓ ⵡⴰⵔ ⵃⵍⵉⵏⵜ ⴷⴻⴳ ⵡⵓⴷⴻⵎ, ⵓⵥⵖⴻⵏⵜ. ⴰⵎⵎⵓ ⵡⴰⵔ ⵃⵍⵉⵏⵜ, ⵄⴻⵎⵎⴰⵔⵚ ⵡⴰⵔ ⵜⴻⵏⵜ ⵥⵔⵉⵖ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⴰⵎ ⵜⴻⴽⵎⴻⵍ. ");
INSERT INTO rift_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","ⵜⵉⴼⵓⵏⴰⵙⵉⵏ ⵢⵓⵥⵖⴻⵏ, ⵡⴰⵔ ⵉⵃⵍⵉⵏ, ⵙⴰⵔⴹⴻⵏⵜ ⵙⴻⴱⵄⴰ ⵏ ⵜⵢⴻⵏⴷⵓⵣⵉⵏ ⵜⵉⵎⴻⵣⵡⵓⵔⴰ ⵉⵚⴻⵃⵃⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","ⵓⵎⵉ ⵓⴷⴼⴻⵏⵜ ⵜⵉⵏⴰ ⴷⴻⴳ ⵓⵄⴻⴷⴷⵉⵙ ⵏⵙⴻⵏⵜ, ⵄⴰⴷ ⵡⴰⵔ ⵉⵙⵙⵉⵏ ⵃⴻⴷ, ⴱⴻⵍⵍⵉ ⴰⵇⴰ ⵓⴷⴼⴻⵏⵜ ⴷⴻⴳ ⵓⵄⴻⴷⴷⵉⵙ ⵏⵙⴻⵏⵜ, ⴰⵇⴰ ⵇⵇⵉⵎⴻⵏⵜ ⵡⴰⵔ ⵃⵍⵉⵏⵜ ⵉ ⵍⵅⴻⵣⵔⴰⵜ ⴰⵎ ⵇⴱⴻⵍ. ⵅⴻⵏⵏⵉ ⴼⴰⵇⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","ⵄⴰⵡⴻⴷ ⵥⵔⵉⵖ ⴷⵉ ⵜⴰⵔⵊⵉⵜ ⵉⵏⵓ, ⵅⵣⴰⵔ, ⵣⴻⴳ ⵉⵛⵜ ⵏ ⵜⵙⴻⵟⵟⴰ ⴼⴼⵖⴻⵏⵜ-ⵉ-ⴷⴷ ⵙⴻⴱⵄⴰ ⵏ ⵜⵉⴷⵔⵉⵏ ⵛⵛⵓⵔⴻⵏⵜ ⵓ ⵛⵏⴰⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","ⵅⵣⴰⵔ, ⵥⵔⵉⵖ, ⴳⴻⵄⵄⴷⴻⵏⵜ-ⵉ-ⴷⴷ ⵙⴻⴱⵄⴰ ⵏ ⵜⵉⴷⵔⵉⵏ ⵇⵇⵓⵙⴱⴰⵔⴻⵏⵜ, ⵓⵥⵖⴻⵏⵜ, ⵉⵙⵙⵛⴻⵎⴹ ⵉ-ⵜⴻⵏⵜ ⵓⵙⴻⵎⵎⵉⴹ ⴰⵛⴰⵔⵇⵉ. ");
INSERT INTO rift_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","ⵓ ⵙⴻⴱⵄⴰ ⵏ ⵜⵉⴷⵔⵉⵏ ⵢⵓⵥⵖⴻⵏ, ⵚⴰⵔⴹⴻⵏⵜ ⵙⴻⴱⵄⴰ ⵏ ⵜⵉⴷⵔⵉⵏ ⵏⵏⵉ ⵉⵛⵏⴰⵏ. ⵏⵏⵉⵖ ⵜⴰⵔⵊⵉⵜ ⵉ ⵜⴰⵔⵡⴰ ⵏ ⵜⵙⴻⵃⵃⴰⵔⵜ, ⵎⴰⵛⴰ ⵡⴰⵔ ⴷⵉⵏ ⵜⵓⵖⵉ ⵃⴻⴷ ⵉ ⵉⵣⴻⵎⵎⴰⵔⴻⵏ ⴰⴷ ⵉⴼⴻⵙⵙⴰⵔ ⵜⴰⵔⵊⵉⵜ-ⴰ.” ");
INSERT INTO rift_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵢⵓⵙⵓⴼ ⵉ ⴼⵉⵔⵄⵓⵏ: “ⵜⴰⵔⵊⵉⵜ ⵏ ⴼⵉⵔⵄⵓⵏ ⴷ ⵉⵛⵜ. ⴰⵔⴻⴱⴱⵉ ⵉⴱⴻⵢⵢⴻⵏ ⵉ ⴼⵉⵔⵄⵓⵏ ⵎⵉⵏ ⵉ ⵖⴰ ⵢⴻⴳⴳ ⵏⴻⵜⵜⴰ. ");
INSERT INTO rift_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","ⵙⴻⴱⵄⴰ ⵏ ⵜⴼⵓⵏⴰⵙⵉⵏ ⵛⵏⴰⵏⵜ ⴰⵇⴰ ⴰⵜⴻⵏⵜ ⴷ ⵙⴻⴱⵄⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ. ⵓⵛⴰ ⵜⵉⴷⵔⵉⵏ ⵛⵏⴰⵏⵜ ⴰⵇⴰ ⴷ ⵙⴻⴱⵄⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ. ⴷ ⵜⴰⵔⵊⵉⵜ ⴷ ⵉⵛⵜ. ");
INSERT INTO rift_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","ⵙⴻⴱⵄⴰ ⵏ ⵜⴼⵓⵏⴰⵙⵉⵏ ⵓⵥⵖⴻⵏⵜ ⵡⴰⵔ ⵉⵃⵍⵉⵏ ⵜⵉⵏⵏⵉ ⴷⴷ-ⵢⵓⵍⵢⴻⵏ ⴰⵡⴰⵔⵏⵉ ⴰⵙⴻⵏⵜ, ⴰⵇⴰ ⴷ ⵙⴻⴱⵄⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵓ ⵙⴻⴱⵄⴰ ⵏ ⵜⵉⴷⵔⵉⵏ ⵇⵇⵓⵙⴱⴰⵔⴻⵏⵜ, ⵜⵉⵏⵏⵉ ⵉⵙⵙⵛⴻⵎⴹ ⵓⵙⴻⵎⵎⵉⴹ ⴰⵛⴰⵔⵇⵉ, ⴰⵇⴰ ⴰⵜⴻⵏⵜ ⴷ ⵙⴻⴱⵄⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵉ ⴷⵉ ⵖⴰ ⵢⵉⵍⵉ ⵍⴰⵥ. ");
INSERT INTO rift_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","ⴷ ⵡⴰ ⴷ ⴰⵡⴰⵍ ⵉ ⵏⵏⵉⵖ ⵉ ⴼⵉⵔⵄⵓⵏ. ⵎⵉⵏ ⵖⴰ ⵢⴻⴳⴳ ⴰⵔⴻⴱⴱⵉ, ⴰⵇⴰ ⵉⵙⵙⵛⴻⵏ ⵉ-ⵜ ⵉ ⴼⵉⵔⵄⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","ⵅⵣⴰⵔ, ⴷⵉ ⵙⴻⴱⵄⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵉ ⴷⴷ-ⵉⴳⴳⵓⵔⴻⵏ ⴰⴷ ⵜⵉⵍⵉ ⵜⵢⴰⵡⴰⵏⵜ ⵜⴰⵎⴻⵇⵇⵔⴰⵏⵜ ⵅ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","ⴰⵡⴰⵔⵏⵉ ⴰⵙⴻⵏ ⴰⴷ ⴷⴷ-ⴰⵙⴻⵏ ⵙⴻⴱⵄⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵏ ⵍⴰⵥ. ⴷⵉ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⴰⴷ ⵜⵜⵓⵏ ⵎⴰⵔⵔⴰ ⵜⵢⴰⵡⴰⵏⵜ ⵓⵛⴰ ⵍⴰⵥ ⴰⴷ ⵉⵜⴻⵃⵃⴰ ⵜⴰⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","ⵓⵛⴰ ⵜⵢⴰⵡⴰⵏⵜ ⵡⴰⵔ ⵜᵉⵜⵜⵉⵍⵉ ⵜᵉⵜⵜⵡⴰⵙⵙⴻⵏ ⵄⴰⴷ ⵣⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⵍⴰⵥ ⵉ ⵜⵜ-ⵉ-ⴷⴷ-ⵉⴹⴼⴰⵔⴻⵏ, ⵎⴰⵖⴰⵔ ⵍⵃⴰⵍ ⴰⴷ ⵢⵉⵍⵉ ⵉⵇⵙⴻⵃ ⴰⵟⵟⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","ⵄⵍⴰⵃⵙⴰⴱ ⵟⵟⴱⵉⵄⴻⵜ ⵏ ⵜⵏⴰⵢⴻⵏ ⵏ ⵡⵓⴷⵎⴰⵡⴻⵏ ⵏ ⵜⴰⵔⵊⵉⵜ ⵏ ⴼⵉⵔⵄⵓⵏ, ⴰⵇⴰ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵙⴻⵇⵇⴰⵔ, ⴰⵇⴰ ⵎⴰⵏ ⴰⵢⴰ ⵙ ⵎⵉⵏⵣⵉ ⵢⵓⵔⴰ ⵜⵜ ⴰⵔⴻⴱⴱⵉ ⵏⵉⵛⴰⵏ ⵓ ⴰⵔⴻⴱⴱⵉ ⴰⵇⴰ ⴰⴷ ⵜⵜ ⵢⴻⴳⴳ ⴷⴻⵖⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","ⴻⵊⵊ ⴼⵉⵔⵄⵓⵏ ⵍⴻⵅⵅⵓ ⴰⴷ ⵢⴰⵔⵣⵓ ⵅ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵙ ⵍⴻⴼⵀⴰⵎⴻⵜ ⴷ ⵜⵉⵖⵉⵜ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜ ⵉⴳⴳ ⵅ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","ⴻⵊⵊ ⴼⵉⵔⵄⵓⵏ ⴰⴷ ⵉⴳⴳ ⴰⵎⵎⵓ: ⴻⵊⵊ ⵉ-ⵜ ⴰⴷ ⵉⴳⴳ ⵉⵡⴻⵇⵇⴰⴼⴻⵏ ⵅ ⵜⴻⵎⵎⵓⵔⵜ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴽⵙⵉⵏ ⵍⴻⵅⵎⵓⵙ ⵏ ⵍⵖⵉⴵⴻⵜ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⴷⵉ ⵙⴻⴱⵄⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵏ ⵜⵢⴰⵡⴰⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","ⴻⵊⵊ ⵉ-ⵜⴻⵏ ⴰⴷ ⵙⵙⵎⵓⵏⴻⵏ ⵎⴰⵔⵔⴰ ⵍⴻⵄⵡⴻⵍⵜ ⴷⴻⴳ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵉⵚⴻⴱⵃⴻⵏ ⵉ ⴷⴷ ⵖⴰ ⵢⴰⵙⴻⵏ ⵓⵛⴰ ⴰⴷ ⵅⴻⵎⵎⵍⴻⵏ ⵍⵃⴻⴱⴱ ⵏ ⵢⵉⵔⴷⴻⵏ ⵙⴰⴷⵓ ⵓⴼⵓⵙ ⵏ ⴼⵉⵔⵄⵓⵏ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜ ⵅⴻⵎⵎⵍⴻⵏ ⴷ ⵎⴰⵛⵛⴰ ⴷⵉ ⵜⵏⴻⴷⴷⴰⵎ. ");
INSERT INTO rift_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵍⴻⵅⵣⴻⵏ ⵏ ⵎⴰⵛⵛⴰ ⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵉ ⵙⴻⴱⵄⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵏ ⵍⴰⵥ ⵏⵏⵉ ⴷⴷ ⵖⴰ ⵉⵡⴹⴰⵏ ⵅ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ, ⵃⵉⵎⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵡⴰⵔ ⵜᵉⵜⵜⵎⴻⵜⵜⵉ ⵛⴰ ⵙ ⵍⴰⵥ.” ");
INSERT INTO rift_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","ⴰⵡⴰⵍⴻⵏ-ⴰ ⴱⴰⵏⴻⵏ-ⴷⴷ ⴷ ⵍⴻⵎⵍⵉⵃ ⵉ ⴼⵉⵔⵄⵓⵏ ⴷ ⵎⴰⵔⵔⴰ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⴼⵉⵔⵄⵓⵏ ⵉ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵙ: “ⵎⴰ ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵉⵜⵜⵡⴰⴼ ⵛⴰ ⵏ ⵡⴻⵔⵢⴰⵣ ⴰⵎ ⵡⴰ ⵉ ⴷⵉ ⵉⵣⴻⴷⴷⴻⵖ ⴰⵔⵔⵓⵃ ⵏ ⴰⵔⴻⴱⴱⵉ?” ");
INSERT INTO rift_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","ⵓⵛⴰ ⵉⵏⵏⴰ ⴼⵉⵔⵄⵓⵏ ⵉ ⵢⵓⵙⵓⴼ: “ⵓⵎⵉ ⴰⵔⴻⴱⴱⵉ ⵉⵎⵎⴻⵍ ⴰⵛ-ⴷⴷ ⵎⴰⵔⵔⴰ ⴰⵢⴰ, ⵅ ⵓⵢⴰ ⵡⴰⵔ ⴷⵉⵏ ⵢⴻⴵⵉ ⵡⴻⵏⵏⵉ ⵖⴰⵔ ⵜⴻⴵⴰ ⵍⴻⴼⵀⴰⵎⴻⵜ ⴷ ⵜⵉⵖⵉⵜ ⴰⵎ ⵛⴻⴽ. ");
INSERT INTO rift_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","ⵛⴻⴽ ⴰⴷ ⵜⵉⵍⵉⴷ ⵅ ⵜⴰⴷⴷⴰⵔⵜ ⵉⵏⵓ ⵓ ⵉ ⵡⴰⵡⴰⵍ ⵏⵏⴻⵛ ⴰⴷ ⵉⵟⴰⵄ ⵍⴳⴻⵏⵙ ⵉⵏⵓ ⵎⴰⵔⵔⴰ. ⵎⵖⵉⵔ ⵅ ⵍⵄⴰⵔⵛ ⵡⴰⵀⴰ ⴰⴷ ⵉⵍⵉⵖ ⵏⴻⵛⵛ ⴷ ⴰⵎⴻⵇⵇⵔⴰⵏ ⵅⴰⴽ.” ");
INSERT INTO rift_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","ⵢⴰⵔⵏⵉ ⵉⵏⵏⴰ ⴼⵉⵔⵄⵓⵏ ⵉ ⵢⵓⵙⵓⴼ: “ⵅⵣⴰⵔ, ⴳⴳⵉⵖ ⵛⴻⴽ ⵅ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ.” ");
INSERT INTO rift_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","ⵓⵛⴰ ⵉⴽⴽⴻⵙ ⴼⵉⵔⵄⵓⵏ ⵜⴰⵅⴰⴷⴻⵏⵜ ⵏⵏⴻⵙ ⵣⴻⴳ ⵓⴼⵓⵙ ⵏⵏⴻⵙ, ⵉⴳⴳⴰ ⵉ-ⵜⵜ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏ ⵢⵓⵙⵓⴼ ⵓⵛⴰ ⵉⵙⵙⵢⴰⵔⴹ ⴰⵙ ⴰⵔⵔⵓⴹ ⵏ ⵍⴻⵇⵟⴻⵏ ⴰⵣⴷⴰⴷ ⵓⵛⴰ ⵉⴳⴳⴰ ⴰⵙ ⵜⴰⵙⴻⴷⴷⴻⵛⵜ ⵏ ⵡⵓⵔⴻⵖ ⴷⴻⴳ ⵢⵉⵔⵉ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","ⵉⵙⵙⴻⵏⵢⴰ ⵉ-ⵜ ⴷⵉ ⵜⴽⴰⵔⵔⵓⵜ ⵡⵉⵙⵙ ⵜⵏⴰⵢⴻⵏ ⵉ ⵜⵓⵖⴰ ⵖⴰⵔⴻⵙ ⵓⵛⴰ ⵍⴰⵖⴰⵏ ⴰⵎ ⴳⴳⵓⵔⴻⵏ ⵣⵣⴰⵜⴻⵙ: “ⵇⴻⵡⵙ!” ⴰⵎⵎⵓ ⵉ ⵜ ⵉⴳⴳⴰ ⵅ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","ⵉⵏⵏⴰ ⴼⵉⵔⵄⵓⵏ ⵉ ⵢⵓⵙⵓⴼ: “ⵏⴻⵛⵛ ⴷ ⴼⵉⵔⵄⵓⵏ, ⴱⵍⴰ ⵛⴻⴽ ⵓⵍⴰ ⴷ ⵉⵊⵊ ⴰⴷ ⵉⴳⴻⵄⵄⴻⴷ ⴰⴼⵓⵙ ⵏⵏⴻⵙ ⵏⵉⵖ ⴰⴹⴰⵔ ⵏⵏⴻⵙ ⴷⵉ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ.” ");
INSERT INTO rift_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","ⵉⵍⴰⵖⴰ ⴼⵉⵔⵄⵓⵏ ⵉ ⵢⵓⵙⵓⴼ ⵙ ⵢⵉⵙⴻⵎ ⵏ ⵚⴰⴼⵏⴰⵜ-ⴼⴰⵄⵏⵉⵃ ⵓⵛⴰ ⵉⵡⵛⴰ ⴰⵙ ⴰⵙⵏⴰⵜ ⴷ ⵜⴰⵎⵖⴰⵔⵜ, ⵜⴻⵏⵏⵉ ⴷ ⵢⴻⴵⵉⵙ ⵏ ⴼⵓⵜⵉ-ⴼⴰⵔⴰⵄ, ⴰⴽⴻⵀⵀⴰⵏ ⵏ ⵓⵏ. ⵓⵛⴰ ⵉⵊⵓⵍ ⵢⵓⵙⵓⴼ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","ⵜⵓⵖⴰ ⵢⵓⵙⵓⴼ ⴷ ⵎⵎⵉⵙ ⵏ ⵜⵍⴰⵜⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵍⴰⵎⵉ ⵉⴱⴻⴷⴷ ⵏⴻⵜⵜⴰ ⵣⵣⴰⵜ ⵉ ⴼⵉⵔⵄⵓⵏ, ⴰⵊⴻⴵⵉⴷ ⵏ ⵎⵉⵚⵔⴰ, ⵓⵛⴰ ⵉⴼⴼⴻⵖ ⵢⵓⵙⵓⴼ ⵣⵣⴰⵜ ⵉ ⴼⵉⵔⵄⵓⵏ ⵓⵛⴰ ⵉⵊⵓⵍ ⵅ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","ⵓⵛⴰ ⵜⴻⵙⵙⴻⵖⵎⵉ-ⴷⴷ ⵜⴻⵎⵎⵓⵔⵜ ⴷⵉ ⵙⴻⴱⵄⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵙ ⵜⵢⴰⵡⴰⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","ⵉⵙⵙⵎⵓⵏ ⵎⴰⵔⵔⴰ ⵎⴰⵛⵛⴰ ⵏ ⵙⴻⴱⵄⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵏ ⵜⵢⴰⵡⴰⵏⵜ, ⵉⵏⵏⵉ ⵜⵓⵖⴰ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ, ⵓⵛⴰ ⵉⵅⴻⵎⵎⴻⵍ ⵎⴰⵛⵛⴰ ⴷⵉ ⵜⵏⴻⴷⴷⴰⵎ. ⵎⴰⵛⵛⴰ ⵏ ⵉⵢⵢⴰⵔⴻⵏ ⵉ ⴷ ⴰⵙ ⴷⴷ-ⵉⵏⵏⴹⴻⵏ ⵉ ⴽⵓⵍ ⵜⴰⵏⴷⵉⵏⵜ, ⵉⵅⴻⵎⵎⴻⵍ ⵉ-ⵜⵜ ⴷⴰⵢⴻⵙ ⴷⴰⵅⴻⵍ ⴷⵉ ⵜⴻⵏⴷⵉⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","ⵢⵓⵙⵓⴼ ⵉⵅⴻⵎⵎⴻⵍ ⵍⵃⴻⴱⴱ ⵏ ⵉⵔⴷⴻⵏ ⴰⵟⵟⴰⵙ, ⴰⵏⴻⵛⵜ ⵏ ⵉⵊⴷⵉ ⵏ ⵍⴻⴱⵃⴰⵔ, ⴰⵍⴰⵎⵉ ⵡⴰⵔ ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵉⵜⵜⵡⴰⵃⵙⴻⴱ, ⵎⵉⵏⵣⵉ ⵜⵓⵖⴰ-ⵜ ⴱⵍⴰ ⵍⴻⵃⵙⴰⴱ. ");
INSERT INTO rift_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","ⵇⴱⴻⵍ ⵉ ⴷⴷ-ⵢⵓⵙⴰ ⵓⵙⴻⴳⴳⵯⴰⵙ ⴰⵎⴻⵣⵡⴰⵔⵓ ⵏ ⵍⴰⵥ, ⵎⵎⴰⵔⴻⵏⵢⴻⵏ-ⴷⴷ ⵖⴰⵔ ⵢⵓⵙⵓⴼ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ, ⵉⵏⵏⵉ ⴷ ⴰⵙ ⴷⴷ-ⵜⵓⵔⵓⵡ ⴰⵙⵏⴰⵜ, ⵢⴻⴵⵉⵙ ⵏ ⴼⵓⵜⵉ-ⴼⴰⵔⴰⵄ, ⴰⴽⴻⵀⵀⴰⵏ ⵏ ⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","ⵉⵙⴻⵎⵎⴰ ⵢⵓⵙⵓⴼ ⴰⵎⴻⵏⵣⵓ ⵎⴰⵏⴰⵙⵙⴰ, ⵎⵉⵏⵣⵉ ⵉⵏⵏⴰ: “ⴰⵔⴻⴱⴱⵉ ⴰⵇⴰ ⵉⵙⵙⴻⵜⵜⵓ ⴰⵢⵉ ⵎⴰⵔⵔⴰ ⵜⴰⵎⴰⵔⴰ ⵉⵏⵓ ⴷ ⵎⴰⵔⵔⴰ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⴱⴰⴱⴰ.” ");
INSERT INTO rift_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","ⵡⵉⵙⵙ ⵜⵏⴰⵢⴻⵏ ⵉⵙⴻⵎⵎⴰ ⵉ-ⵜ ⵉⴼⵔⴰⵢⵉⵎ, ⵎⵉⵏⵣⵉ ⵉⵏⵏⴰ: “ⴰⵔⴻⴱⴱⵉ ⵉⴳⴳⴰ ⴰⵢⵉ ⵙ ⵍⵖⵉⴵⴻⵜ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵍⴻⵃⵚⴰⵔⴻⵜ ⵉⵏⵓ.” ");
INSERT INTO rift_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","ⵅⴻⵏⵏⵉ ⴽⴻⵎⵎⵍⴻⵏ ⵙⴻⴱⵄⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵏ ⵓⴼⴻⵢⵢⴻⴹ ⵏ ⵍⵖⵉⴵⴻⵜ ⵏⵏⵉ ⵉⴽⴽⵉⵏ ⵅ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ, ");
INSERT INTO rift_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ⵓⵛⴰ ⴱⴷⴰⵏ ⴰⴷ ⴷⴷ-ⴰⵙⴻⵏ ⵙⴻⴱⵄⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵏ ⵍⴰⵥ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵅⴰⵙ ⵉⵙⵙⵉⵡⴻⵍ ⵢⵓⵙⵓⴼ. ⵜⵓⵖⴰ ⵍⴰⵥ ⴷⵉ ⵎⴰⵔⵔⴰ ⵜⵉⵎⵎⵓⵔⴰ, ⵎⴰⵛⴰ ⴷⵉ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⵜⵓⵖⴰ ⴷⴰⵢⴻⵙ ⵄⴰⴷ ⴰⵖⵔⵓⵎ. ");
INSERT INTO rift_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","ⴰⵍⴰⵎⵉ ⵜⵓⵖⴰ ⵍⴰⵥ ⴷⵉ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ, ⵉⵙⵖⵓⵢ ⵍⴳⴻⵏⵙ ⵖⴰⵔ ⴼⵉⵔⵄⵓⵏ ⵅ ⵡⴻⵖⵔⵓⵎ. ⵓⵛⴰ ⵉⵏⵏⴰ ⴼⵉⵔⵄⵓⵏ ⵉ ⵎⴰⵔⵔⴰ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ: “ⵔⵓⵃⴻⵎ ⵖⴰⵔ ⵢⵓⵙⵓⴼ, ⴳⴳⴻⵎ ⵎⵉⵏ ⴷ ⴰⵡⴻⵎ ⵖⴰ ⵢⵉⵏⵉ!” ");
INSERT INTO rift_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","ⵜⵓⵖⴰ ⵍⴰⵥ ⵉⵣⴻⴵⴻⵄ ⵅ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵓⵛⴰ ⵢⴰⵔⵣⴻⵎ ⵢⵓⵙⵓⴼ ⵅ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵜⵓⵖⴰ ⵉⵅⴻⵎⵎⴻⵍ, ⵓⵛⴰ ⵉⵣⵣⴻⵏⵣ ⵉ-ⵜ ⵉ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ, ⵎⵉⵏⵣⵉ ⵜⵓⵖⴰ ⵍⴰⵥ ⵉⴷⵡⴻⵍ ⵉⵎⵖⴰⵔ ⴰⵟⵟⴰⵙ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","ⵣⵉ ⵎⴰⵔⵔⴰ ⵜⵉⵎⵎⵓⵔⴰ ⵓⵙⵉⵏ-ⴷⴷ ⵉⵡⴷⴰⵏ ⵖⴰⵔ ⵎⵉⵚⵔⴰ ⵖⴰⵔ ⵢⵓⵙⵓⴼ ⵃⵉⵎⴰ ⴰⴷ ⵙⵖⴻⵏ, ⵎⵉⵏⵣⵉ ⴷⵉ ⵎⴰⵔⵔⴰ ⵜⵉⵎⵎⵓⵔⴰ ⵜⵓⵖⴰ ⵍⴰⵥ ⵉⵎⵖⴰⵔ ⴰⵟⵟⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","ⵍⴰⵎⵉ ⵉⵥⵔⴰ ⵢⴰⵄⵇⵓⴱ ⴱⴻⵍⵍⵉ ⴰⵇⴰ ⴷⵉⵏ ⵍⵃⴻⴱⴱ ⵏ ⵢⵉⵔⴷⴻⵏ ⴷⵉ ⵎⵉⵚⵔⴰ, ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵉ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ “ⵎⴰⵖⴰⵔ ⵜⴻⵇⵇⵉⵎⴻⵎ ⵜⵅⴻⵣⵣⴰⵔⴻⵎ ⵉⵊⵊⴻⵏ ⴷⴻⴳ ⵡⴻⵏⵏⴻⵖⵏⵉ?” ");
INSERT INTO rift_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","ⵉⵏⵏⴰ: “ⴰⵇⴰ ⵏⴻⵛⵛ ⵙⵍⵉⵖ ⴱⴻⵍⵍⵉ ⴷⵉⵏ ⵉⵎⴻⵏⴷⵉ ⴷⵉ ⵎⵉⵚⵔⴰ. ⵔⵓⵃⴻⵎ ⴷⵉⵏⵏⵉ ⵓⵛⴰ ⵙⵖⴻⵎ ⴰⵏⴻⵖ-ⴷⴷ ⵙⵙⴻⵏⵏⵉ ⵍⵃⴻⴱⴱ, ⵃⵉⵎⴰ ⴰⴷ ⵏⴻⵇⵇⵉⵎ ⵏⴻⴷⴷⴰⵔ ⵓⵛⴰ ⵡⴰⵔ ⵏⴻⵜⵜⵎⴻⵜⵜⵉ ⵛⴰ.” ");
INSERT INTO rift_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","ⵀⵡⴰⵏ ⵄⴻⵛⵔⴰ ⵏ ⵡⴰⵡⵎⴰⵜⴻⵏ ⵏ ⵢⵓⵙⵓⴼ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵔⴰⵃⴻⵏ ⴰⴷ ⵙⵖⴻⵏ ⵉⵎⴻⵏⴷⵉ ⵣⵉ ⵎⵉⵚⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","ⵎⴰⵛⴰ ⵢⴰⵄⵇⵓⴱ ⵡⴰⵔ ⵉⵙⵙⴻⴽⴽ ⴱⵉⵏⵢⴰⵎⵉⵏ, ⵓⵎⴰⵙ ⵏ ⵢⵓⵙⵓⴼ, ⴰⴽ-ⴷ ⴰⵢⵜⵎⴰⵙ, ⵎⵉⵏⵣⵉ ⵉⵏⵏⴰ: “ⵃⵉⵎⴰ ⵡⴰⵔ ⴷ ⴰⵙ ⵉⵜⵜⴻⵎⵙⴰⵔ ⵛⴰ ⵏ ⵍⵃⴰⵊⵊⴻⵜ ⴷ ⵜⴰⵄⴻⴼⴼⴰⵏⵜ.” ");
INSERT INTO rift_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","ⵊⴰⵔ ⵉⵏⵏⵉ ⴷⴷ-ⵢⵓⵙⵉⵏ ⴷⵉⵏⵏⵉ, ⵓⵙⵉⵏ-ⴷⴷ ⵄⴰⵡⴻⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵙⵖⴻⵏ ⵎⴰⵛⵛⴰ, ⵎⵉⵏⵣⵉ ⵜⵓⵖⴰ ⴷⵉⵏ ⵍⴰⵥ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","ⵜⵓⵖⴰ ⵢⵓⵙⵓⴼ ⴷ ⵍⵃⴰⴽⴻⵎ ⵅ ⵜⴻⵎⵎⵓⵔⵜ ⵓⵛⴰ ⵉⵣⵣⴻⵏⵣ ⵉⵎⴻⵏⴷⵉ ⵉ ⵎⴰⵔⵔⴰ ⵍⴳⴻⵏⵙ ⵏ ⵜⴻⵎⵎⵓⵔⵜ. ⵓⵎⵉ ⴷⴷ-ⵉⵡⴹⴻⵏ ⴰⵢⵜⵎⴰⵙ ⵏ ⵢⵓⵙⵓⴼ, ⴱⴻⵏⴷⵇⴻⵏ ⴰⵙ ⵙ ⵓⵖⴻⵎⴱⵓⴱ ⵏⵙⴻⵏ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","ⵓⵎⵉ ⵉⵥⵔⴰ ⵢⵓⵙⵓⴼ ⴰⵢⵜⵎⴰⵙ, ⵉⵄⵇⴻⵍ ⵉ-ⵜⴻⵏ, ⵎⴰⵛⴰ ⵉⴳⴳⴰ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⴰⵅⵎⵉ ⵡⴰⵔ ⵜⴻⵏ ⵉⵙⵙⵉⵏ ⵓⵛⴰ ⵉⵙⵙⵉⵡⴻⵍ ⴰⴽⵉⴷⵙⴻⵏ ⵙ ⵍⴻⵇⵙⴰⵃⴻⵜ, ⵉⵏⵏⴰ ⴰⵙⴻⵏ: “ⵎⴰⵏⵉⵙ ⴷⴷ-ⵜⵓⵙⵉⵎ?” ⵏⵏⴰⵏ: “ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵏⵙⴻⵖ ⵎⴰⵛⵛⴰ.” ");
INSERT INTO rift_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","ⵢⵓⵙⵓⴼ ⵉⵄⴻⵇⵍ ⴰⵢⵜⵎⴰⵙ, ⵎⴰⵛⴰ ⵏⵉⵜⵏⵉ ⵡⴰⵔ ⵜ ⵄⵇⵉⵍⴻⵏ ⵛⴰ. ");
INSERT INTO rift_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","ⵉⴼⴻⴽⴽⴰⵔ ⵢⵓⵙⵓⴼ ⴷⵉ ⵜⵉⵔⵊⴰ ⵏⵏⵉ ⵜⵓⵖⴰ ⵅⴰⵙⴻⵏ ⵢⵓⵔⵊⴰ, ⵉⵏⵏⴰ ⴰⵙⴻⵏ: “ⴽⴻⵏⵏⵉⵡ ⴷ ⵉⴱⴻⵔⴳⴰⴳⴻⵏ ⵉ ⵜⴻⴵⴰⵎ, ⵜⵓⵙⵉⵎ-ⴷⴷ, ⵃⵉⵎⴰ ⴰⴷ ⵜⵥⴰⵔⴻⵎ ⵎⴰⵏⵉ ⵡⴰⵔ ⵜᵉⵜⵜⵡⴰⵃⴹⵉ ⵜⴻⵎⵎⵓⵔⵜ.” ");
INSERT INTO rift_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","ⴰⵔⵔⵉⵏ-ⴷⴷ ⵅⴰⵙ: “ⵍⵍⴰ, ⴰ ⵙⵉⴷⵉ ⵉⵏⵓ, ⵄⴰⴷ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵛ ⵓⵙⵉⵏ-ⴷⴷ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵙⵖⴻⵏ ⵎⴰⵛⵛⴰ. ");
INSERT INTO rift_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","ⵎⴰⵔⵔⴰ ⵏⴻⵛⵛⵉⵏ ⴰⵇⴰ ⴰⵏⴻⵖ ⴷ ⵜⴰⵔⵡⴰ ⵏ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ. ⴰⵇⴰ ⴰⵏⴻⵖ ⴷ ⵉⵔⵢⴰⵣⴻⵏ ⴷ ⵉⵎⵜⵉⵇⵇⴰⵏ, ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵛ ⵡⴰⵔ ⴵⵉⵏ ⵛⴰ ⴷ ⵉⴱⴻⵔⴳⴰⴳⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","ⵏⴻⵜⵜⴰ ⵢⴰⵔⵔⴰ-ⴷⴷ ⵅⴰⵙⴻⵏ: “ⵍⵍⴰ, ⴽⴻⵏⵏⵉⵡ ⵜⵓⵙⵉⵎ-ⴷⴷ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⵥⴰⵔⴻⵎ ⵜⵓⵄⵄⴰⵔⵢⴻⵏⵜ ⵏ ⵜⴻⵎⵎⵓⵔⵜ.” ");
INSERT INTO rift_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","ⵏⵏⴰⵏ ⵏⵉⵜⵏⵉ: “ⵏⴻⵛⵛⵉⵏ ⴷ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵛ, ⴰⵇⴰ ⴰⵏⴻⵖ ⴷⵉ ⵜⴻⵏⵄⴰⵛ ⵏ ⵡⴰⵡⵎⴰⵜⴻⵏ, ⵜⴰⵔⵡⴰ ⵏ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ. ⴰⵇⴰ ⴰⵎⴰⵥⵓⵥ ⴰⵇⴰ-ⵜ ⴰⴽ-ⴷ ⴱⴰⴱⴰⵜⵏⴻⵖ ⵓ ⵡⴻⵏⵏⴻⵖⵏⵉ ⵡⴰⵔ ⵉⴵⵉ ⵄⴰⴷ.” ");
INSERT INTO rift_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","ⵉⵏⵏⴰ ⴰⵙⴻⵏ ⵢⵓⵙⵓⴼ: “ⵎⴰ ⵡⴰⵔ ⴷ ⴰⵡⴻⵎ ⵜ ⵏⵏⵉⵖ ⵓⵎⵉ ⵏⵏⵉⵖ: ‘ⴰⵇⴰ ⴽⴻⵏⵏⵉⵡ ⴷ ⵉⴱⴻⵔⴳⴰⴳⴻⵏ!’ ");
INSERT INTO rift_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","ⵙ ⵓⵢⴰ ⵜᵉⵜⵜⵡⴰⵇⴻⴵⴱⴻⵎ. ⵙ ⵜⵉⴷⴻⵜⵜ ⴰⵎ ⵉⴷⴷⴰⵔ ⴼⵉⵔⵄⵓⵏ, ⴽⴻⵏⵏⵉⵡ ⵡⴰⵔ ⴷⴷ-ⵜⵜⴻⴼⴼⵖⴻⵎ ⵙⵙⴰ, ⵎⵖⵉⵔ ⵅⵎⵉ ⴷⴷ ⵖⴰ ⵢⴰⵙ ⵓⵎⴰⵜⵡⴻⵎ ⴰⵎⴰⵥⵓⵥ ⴷⴰⵏⵉⵜⴰ! ");
INSERT INTO rift_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","ⵙⴻⴽⴽⴻⵎ ⵉⵊⵊ ⵏ ⵣⵣⴰⵢⵡⴻⵎ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴷⴷ-ⵢⴰⵡⵉ ⵓⵎⴰⵜⵡⴻⵎ. ⵅⴻⵏⵏⵉ ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⵜᵉⵜⵜⵡⴰⵃⴻⴱⴱⵙⴻⵎ ⵓⵛⴰ ⴰⵡⴰⵍⴻⵏ ⵏⵡⴻⵎ ⴰⴷ ⵜⵜⵡⴰⵇⴻⴵⴱⴻⵏ, ⵎⴰ ⴷⴰⵢⵡⴻⵎ ⵍⴰⵎⴰⵏ. ⵎⴰⵍⴰ ⵍⵍⴰ, ⵙ ⵜⵉⴷⴻⵜⵜ ⴰⵎ ⵉⴷⴷⴰⵔ ⴼⵉⵔⵄⵓⵏ, ⴰⵇⴰ ⴽⴻⵏⵏⵉⵡ ⴷ ⵉⴱⴻⵔⴳⴰⴳⴻⵏ!” ");
INSERT INTO rift_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","ⵓⵛⴰ ⵉⴳⴳⴰ ⵉ-ⵜⴻⵏ ⵜⵍⴰⵜⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⴷⵉ ⵍⴻⵃⴱⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵜⵍⴰⵜⴰ ⵉⵏⵏⴰ ⴰⵙⴻⵏ ⵢⵓⵙⵓⴼ: “ⴳⴳⴻⵎ ⴰⵢⴰ, ⵃⵉⵎⴰ ⴰⴷ ⵜⴻⵇⵇⵉⵎⴻⵎ ⵜⴻⴷⴷⴰⵔⴻⵎ, ⵏⴻⵛⵛ ⵜⵜⴻⴳⴳⵯⴷⴻⵖ ⴰⵔⴻⴱⴱⵉ. ");
INSERT INTO rift_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","ⵎⴰⵍⴰ ⴽⴻⵏⵏⵉⵡ ⴷ ⵉⵔⵢⴰⵣⴻⵏ ⴷ ⵉⵎⵜⵉⵇⵇⴰⵏ, ⵊⵊⴻⵎ ⵅⴻⵏⵏⵉ ⵉⵊⵊ ⵏ ⵓⵎⴰⵜⵡⴻⵎ ⴰⴷ ⵉⵇⵇⵉⵎ ⵉⵛⴰⵔⴼ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵎⴰⵏⵉ ⵜᵉⵜⵜⵡⴰⵃⴻⴱⴱⵙⴻⵎ ⴽⴻⵏⵏⵉⵡ, ⵅⴻⵏⵏⵉ ⵔⵓⵃⴻⵎ, ⴽⵙⵉⵎ ⵉⵎⴻⵏⴷⵉ ⵉ ⵍⴰⵥ ⵏ ⴰⵢⵜⴱⴰⴱ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","ⴰⵡⵢⴻⵎ-ⴷⴷ ⵅⴻⵏⵏⵉ ⵓⵎⴰⵜⵡⴻⵎ, ⴰⵎⴰⵥⵓⵥ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⵜⵡⴰⵇⴻⴵⴱⴻⵏ ⵡⴰⵡⴰⵍⴻⵏ ⵏⵡⴻⵎ, ⵡⴰⵔ ⵜᵉⵜⵜⵎⴻⵜⵜⵉⵎ ⵛⴰ.” ⵓⵛⴰ ⵏⵉⵜⵏⵉ ⴳⴳⵉⵏ ⴰⵎⴻⵏⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","ⵏⵏⴰⵏ ⵉ ⵡⴰⵢⴰⵡⵢⴰ: “ⵙ ⵜⵉⴷⴻⵜⵜ ⴰⵇⴰ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⵏⴻⵖ ⴰⴷ ⴷⴷ-ⵏⴰⵔⵔ ⴷⴷⴻⵢⵢⴻⵜ ⵏ ⵓⵎⴰⵜⵏⴻⵖ, ⴰⵇⴰ ⵏⴻⵥⵔⴰ ⵍⵃⴻⵚⵔⴰⵏ ⵏ ⵍⴻⵄⵎⴰⵔ ⵏⵏⴻⵙ ⵓⵎⵉ ⴷ ⴰⵏⴻⵖ ⵉⵜⵜⴰⵔ ⴰⵃⵉⵏⵏⵉ, ⵎⴰⵛⴰ ⵡⴰⵔ ⴷ ⴰⵙ ⵏⴻⵙⵍⵉ ⵛⴰ! ⵅ ⵓⵢⴰ ⴷⴷ-ⵢⵓⵙⴰ ⵍⵃⴻⵚⵔⴰⵏ-ⴰ ⵅⴰⵏⴻⵖ.” ");
INSERT INTO rift_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","ⵢⴰⵔⵔⴰ-ⴷⴷ ⵅⴰⵙⴻⵏ ⵔⵓⴱⵉⵏ, ⵉⵏⵏⴰ: “ⵎⴰ ⵡⴰⵔ ⴷ ⴰⵡⴻⵎ ⵜ ⵏⵏⵉⵖ, ⵓⵎⵉ ⵏⵏⵉⵖ: ‘ⵡⴰⵔ ⵅⴻⵟⵟⵉⵎ ⵛⴰ ⴰⴽ-ⴷ ⵓⵃⴻⵏⵊⵉⵔ!’, ⵎⴰⵛⴰ ⴽⴻⵏⵏⵉⵡ ⵡⴰⵔ ⵜⴻⵙⵍⵉⵎ ⵛⴰ. ⵅⵣⴰⵔ, ⵉⴷⴰⵎⵎⴻⵏ ⵏⵏⴻⵙ ⵜⵜⵡⴰⵜⵜⴰⵔⴻⵏ ⵍⴻⵅⵅⵓ!” ");
INSERT INTO rift_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","ⵏⵉⵜⵏⵉ ⵡⴰⵔ ⵙⵙⵉⵏⴻⵏ ⴱⴻⵍⵍⵉ ⵉⴼⵀⴻⵎ ⴰⵙⴻⵏ ⵢⵓⵙⵓⴼ, ⵎⵉⵏⵣⵉ ⵜⵓⵖⴰ ⴰⵜⵓⵔⵊⵎⴰⵏ ⵊⴰⵔ ⴰⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","ⵉⵏⵏⴻⵇⵍⴻⴱ ⵅⴰⵙⴻⵏ ⵓⵛⴰ ⵉⵙⵖⵓⵢ. ⴰⵡⴰⵔⵏⵉ ⴰⵙ ⵉⵏⵏⴻⵇⵍⴻⴱ-ⴷⴷ ⵄⴰⵡⴻⴷ ⵖⴰⵔⵙⴻⵏ, ⵉⵙⵙⵉⵡⴻⵍ ⴰⴽⵉⴷⵙⴻⵏ, ⵉⴽⵙⵉ ⵣⵣⴰⵢⵙⴻⵏ ⵛⵉⵎⵄⵓⵏ ⵓⵛⴰ ⵉⵃⴻⴱⴱⴻⵙ ⵉ-ⵜ ⵣⵣⴰⵜ ⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","ⵢⵓⵎⵓⵔ ⵢⵓⵙⵓⴼ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵛⵛⵓⵔⴻⵏ ⵜⵉⵅⵓⵏⵛⴰⵢ ⵏⵙⴻⵏ ⵙ ⵉⵎⴻⵏⴷⵉ ⵓ ⴰⴷ ⴳⴳⴻⵏ ⵜⵎⴻⵏⵢⴰⵜ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⴷⵉ ⴽⵓⵍ ⵉⵛⵜ ⵏ ⵜⵅⴰⵏⵛⴻⵜ ⵏⵙⴻⵏ ⵓⵛⴰ ⵡⵛⵉⵏ ⴰⵙⴻⵏ ⵎⴰⵛⵛⴰ ⵉ ⵡⴻⴱⵔⵉⴷ. ⵓ ⴰⵎⵎⵓ ⵉ ⴽⵉⴷⵙⴻⵏ ⴳⴳⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","ⵙⵙⴰⵔⴱⵓⵏ ⵉⵎⴻⵏⴷⵉ ⵏⵙⴻⵏ ⵅ ⵢⴻⵖⵢⴰⵍ ⵏⵙⴻⵏ ⵓⵛⴰ ⴼⴼⵖⴻⵏ ⵙⵙⴻⵏⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","ⵓⵎⵉ ⵢⴰⵔⵣⴻⵎ ⵉⵊⵊⴻⵏ ⵣⵣⴰⵢⵙⴻⵏ ⵜⴰⵅⴰⵏⵛⴻⵜ ⵏⵏⴻⵙ, ⵃⵉⵎⴰ ⴰⴷ ⵉⵙⵙⴻⵛⵛ ⴰⵖⵢⵓⵍ ⵏⵏⴻⵙ ⵖⴰⵔ ⵎⴰⵏⵉ ⵖⴰ ⵙⵙⴻⵏⵙⴻⵏ, ⵉⵥⵔⴰ ⵏⵏⵓⵇⴰⵔⵜ ⵏⵏⴻⵙ ⴷⴻⴳ ⴰⵔⵣⴰⵎ ⵏ ⵓⵇⴻⵎⵎⵓⵎ ⵏ ⵜⵅⴰⵏⵛⴻⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","ⵉⵏⵏⴰ ⵉ ⵢⴰⵢⵜⵎⴰⵙ: “ⵏⵏⵓⵇⴰⵔⵜ ⵉⵏⵓ ⵜⴻⴷⵡⴻⵍ ⴰⵢⵉ-ⴷⴷ. ⵅⵣⴰⵔ, ⴰⵇⴰ-ⵜⵜ ⴷⴰ ⴷⵉ ⵜⵅⴰⵏⵛⴻⵜ ⵉⵏⵓ!” ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⴱⴻⴷⴷ ⴰⵙⴻⵏ ⵡⵓⵍ, ⴰⵔⵊⵉⵊⴻⵏ ⵓⵛⴰ ⵏⵏⴰⵏ ⵉ ⵡⴰⵢⴰⵡⵢⴰ: “ⵎⴰⵏⴰⵡⵢⴰ ⵉ ⴷ ⴰⵏⴻⵖ ⵉⵜⵜⴻⴳⴳ ⴰⵔⴻⴱⴱⵉ?” ");
INSERT INTO rift_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","ⵓⵛⴰ ⵔⴻⵃⵃⴳⴻⵏ ⵖⴰⵔ ⴱⴰⴱⴰⵜⵙⴻⵏ ⵢⴰⵄⵇⵓⴱ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ ⵓⵛⴰ ⵄⴰⵡⴷⴻⵏ ⴰⵙ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵅⴰⵙⴻⵏ ⵉⴽⴽⵉⵏ, ⵏⵏⴰⵏ: ");
INSERT INTO rift_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“ⴰⵔⵢⴰⵣ, ⴱⴰⴱ ⵏ ⵜⴻⵎⵎⵓⵔⵜ, ⵉⵙⵙⵉⵡⴻⵍ ⴰⴽⵉⴷⵏⴻⵖ ⵙ ⵍⴻⵇⵙⴰⵃⴻⵜ, ⵉⵃⴻⵙⴱ ⴰⵏⴻⵖ ⴷ ⵉⴱⴻⵔⴳⴰⴳⴻⵏ ⵏ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","ⵎⴰⵛⴰ ⵏⴻⵏⵏⴰ ⴰⵙ: ‘ⵏⴻⵛⵛⵉⵏ ⴷ ⵉⵔⵢⴰⵣⴻⵏ ⴷ ⵉⵎⵜⵉⵇⵇⴰⵏ, ⵄⴻⵎⵎⴰⵔⵚ ⵡⴰⵔ ⵏⴻⴵⵉ ⴷ ⵉⴱⴻⵔⴳⴰⴳⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","ⴰⵇⴰ ⴰⵏⴻⵖ ⴷⵉ ⵜⴻⵏⵄⴰⵛ ⵏ ⵡⴰⵡⵎⴰⵜⴻⵏ, ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⴱⴰⴱⴰⵜⵏⴻⵖ. ⵉⵊⵊⴻⵏ ⵡⴰⵔ ⵉⵇⵇⵉⵎ, ⴰⵎⴰⵥⵓⵥ ⴰⵇⴰ-ⵜ ⴰⵙⵙ-ⴰ ⴰⴽ-ⴷ ⴱⴰⴱⴰⵜⵏⴻⵖ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ.’ ");
INSERT INTO rift_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","ⵓ ⴰⵔⵢⴰⵣ ⵏⵏⵉ, ⴱⴰⴱ ⵏ ⵜⴻⵎⵎⵓⵔⵜ, ⵉⵏⵏⴰ ⴰⵏⴻⵖ: ‘ⵙ ⵓⵢⴰ ⴰⴷ ⵙⵙⵏⴻⵖ, ⵎⴰ ⴰⵇⴰ ⴽⴻⵏⵏⵉⵡ ⴷ ⵉⵎⵜⵉⵇⵇⴰⵏ. ⴰⴷ ⴽⵉⴷⵉ ⵜⴻⵊⵊⴻⵎ ⵉⵊⵊⴻⵏ ⵣⴻⴳ ⴰⵢⵜⵎⴰⵜⵡⴻⵎ ⵓⵛⴰ ⴰⴷ ⵜⴻⴽⵙⵉⵎ ⵎⴰⵛⵛⴰ ⵉ ⵍⴰⵥ ⵏⵏⵉ ⴷⵉⵏ ⵖⴰⵔ ⴰⵢⵜⴱⴰⴱ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵡⴻⵎ, ⵅⴻⵏⵏⵉ ⴼⴼⵖⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","ⴰⵡⵢⴻⵎ-ⴷⴷ ⴷⴰ ⵓⵎⴰⵜⵡⴻⵎ, ⴰⵎⴰⵥⵓⵥ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵙⵙⵏⴻⵖ ⴱⴻⵍⵍⵉ ⵡⴰⵔ ⵜⴻⴵⵉⵎ ⴷ ⵉⴱⴻⵔⴳⴰⴳⴻⵏ, ⵎⴰⵛⴰ ⴷ ⵉⵎⵜⵉⵇⵇⴰⵏ ⵓⵛⴰ ⴰⴷ ⴰⵡⴻⵎ ⴷⴷ-ⴰⵔⵅⵓⵖ ⵉ ⵡⴰⵎⴰⵜⵡⴻⵎ ⵏⵡⴻⵎ ⵓⵛⴰ ⴰⴷ ⵜⵔⴰⵃⴻⵎ ⴰⴷ ⵜⵊⵓⵍⴻⵎ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ.’” ");
INSERT INTO rift_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","ⵓⵎⵉ ⵙⵙⴻⵅⵡⴰⵏ ⵜⵉⵅⵓⵏⵛⴰⵢ ⵏⵙⴻⵏ, ⵃⴻⴽⴽⴰⵔⴻⵏ ⴱⴻⵍⵍⵉ ⴷⵉ ⵜⵅⴰⵏⵛⴻⵜ ⵏ ⴽⵓⵍ ⵉⵊⵊⴻⵏ, ⴰⵇⴰ ⴷⴰⵢⴻⵙ ⵜⴰⵛⵢⴰⵔⵜ ⵙ ⵏⵏⵓⵇⴰⵔⵜ ⵏⵏⴻⵙ. ⵥⵔⵉⵏ ⵏⵉⵜⵏⵉ ⴷ ⴱⴰⴱⴰⵜⵙⴻⵏ ⵜⵉⵛⵢⴰⵔ ⵙ ⵏⵏⵓⵇⴰⵔⵜ ⵏⵙⴻⵏ ⵓⵛⴰ ⵜⵓⴷⴻⴼ ⵉ-ⵜⴻⵏ ⵜⵉⴳⴳⵯⵓⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","ⵉⵏⵏⴰ ⴰⵙⴻⵏ ⴱⴰⴱⴰⵜⵙⴻⵏ ⵢⴰⵄⵇⵓⴱ: “ⴰⵇⴰ ⵜⵃⴰⵔⵔⵎⴻⵎ ⴰⵢⵉ ⵣⴻⴳ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵉⵏⵓ! ⵢⵓⵙⵓⴼ ⵡⴰⵔ ⴷⴷ-ⵉⴹⵀⴰⵔ ⵄⴰⴷ ⵓⵍⴰ ⴷ ⵛⵉⵎⵄⵓⵏ, ⵓⵛⴰ ⵍⴻⵅⵅⵓ ⵜᵉⵜⵜⴻⵅⵙⴻⵎ ⴰⴷ ⵜⵏⴻⴷⵀⴻⵎ ⴱⵉⵏⵢⴰⵎⵉⵏ. ⵎⴰⵔⵔⴰ ⵎⴰⵏ ⴰⵢⴰ ⵉⵜⵜⴻⵎⵙⴰⵔⴻⵏ ⴷⵉ ⵍⴻⵄⴽⴻⵙ ⵉⵏⵓ!” ");
INSERT INTO rift_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","ⵅⴻⵏⵏⵉ ⵉⵙⵙⵉⵡⴻⵍ ⵔⵓⴱⵉⵏ ⵖⴰⵔ ⴱⴰⴱⴰⵙ, ⵉⵏⵏⴰ: “ⴰⴷ ⵜⴻⵏⵖⴻⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵉⵏⵓ, ⵎⴰⵍⴰ ⵡⴰⵔ ⴷ ⴰⵛ ⵜ-ⵉ-ⴷⴷ-ⴰⵔⵔⵉⵖ. ⴻⵡⵛ ⴰⵢⵉ ⵜ ⴷⴻⴳ ⵓⴼⵓⵙ ⵉⵏⵓ, ⵏⴻⵛⵛ ⴰⵇⴰ ⴰⴷ ⴰⵛ ⵜ-ⵉ-ⴷⴷ-ⴰⵔⵔⴻⵖ!” ");
INSERT INTO rift_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","ⵎⴰⵛⴰ ⵏⴻⵜⵜⴰ ⵉⵏⵏⴰ ⴰⵙ: “ⵎⵎⵉ ⵡⴰⵔ ⵉⵜⵜⵔⵉⵃ ⵛⴰ ⴰⴽⵉⴷⵡⴻⵎ, ⵎⵉⵏⵣⵉ ⵓⵎⴰⵙ ⵉⵎⵎⵓⵜ ⵓ ⵏⴻⵜⵜⴰ ⵡⴻⵃⵃⴷⴻⵙ ⵉ ⴷ ⴰⵢⵉ ⵉⵇⵇⵉⵎⴻⵏ. ⵎⴰⵍⴰ ⵉⵍⵇⴻⴼ ⵉ-ⵜ ⵛⴰ ⵏ ⵍⵖⴰⵔ ⴷⴻⴳ ⵡⴻⴱⵔⵉⴷ ⵏⵏⵉ ⵉ ⵖⴰ ⵜⴻⴽⴽⴻⵎ, ⴰⴷ ⵜⴻⵙⵙⴻⵀⵡⴰⵎ ⵛⵛⵉⴱ ⵉⵏⵓ ⵙ ⵡⴻⵛⴹⴰⵏ ⵖⴰⵔ ⵍⴰⵅⴰⵔⵜ.” ");
INSERT INTO rift_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","ⵎⴰⵛⴰ ⵍⴰⵥ ⵜⵓⵖⴰ ⵉⵎⵖⴰⵔ ⴰⵟⵟⴰⵙ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","ⵍⴰⵎⵉ ⴽⴻⵎⵎⵍⴻⵏ ⵛⵛⵉⵏ ⵍⵃⴻⴱⴱ ⵏ ⵢⵉⵔⴷⴻⵏ ⵏⵏⵉ ⴽⵉⴷⵙⴻⵏ ⴷⴷ-ⵉⵡⵢⴻⵏ ⵣⵉ ⵎⵉⵚⵔⴰ, ⵉⵏⵏⴰ ⴰⵙⴻⵏ ⴱⴰⴱⴰⵜⵙⴻⵏ: “ⴷⴻⵡⵍⴻⵎ-ⴷⴷ ⵄⴰⵡⴻⴷ ⵓⵛⴰ ⵙⵖⴻⵎ ⴰⵏⴻⵖ-ⴷⴷ ⵛⵡⴰⵢⵜ ⵏ ⵎⴰⵛⵛⴰ.” ");
INSERT INTO rift_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","ⵅⴻⵏⵏⵉ ⵉⵙⵙⵉⵡⴻⵍ ⵢⴰⵀⵓⴷⴰ, ⵉⵏⵏⴰ: “ⴰⵇⴰ ⴰⵔⵢⴰⵣ ⵏⵏⵉ ⵉⵏⵏⴰ ⴰⵏⴻⵖ ⵙ ⵓⵔⴻⴽⴽⴻⵣ: “ⵡⴰⵔ ⵜⵥⴰⵔⵔⴻⵎ ⵄⴰⴷ ⵓⴷⴻⵎ ⵉⵏⵓ, ⵎⵖⵉⵔ ⵎⴰⵍⴰ ⵜⵉⵡⵢⴻⵎ-ⴷⴷ ⵓⵎⴰⵜⵡⴻⵎ ⴰⴽⵉⴷⵡⴻⵎ.” ");
INSERT INTO rift_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","ⵎⴰⵍⴰ ⵜⴻⵙⵙⴻⴽⴽⴻⴷ ⵓⵎⴰⵜⵏⴻⵖ ⴰⴽⵉⴷⵏⴻⵖ, ⴰⴷ ⵏⵔⴰⵃ ⴷⵉⵏ ⵓⵛⴰ ⴰⴷ ⴰⵛ ⴷⴷ-ⵏⵙⴻⵖ ⵎⴰⵛⵛⴰ, ");
INSERT INTO rift_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⵡⴰⵔ ⵜ ⵜᵉⵙⵙⴻⴽⴽⵉⴷ ⴰⴽⵉⴷⵏⴻⵖ, ⵅⴻⵏⵏⵉ ⵡⴰⵔ ⴷⵉⵏⵏⵉ ⵏⴻⵜⵜⵔⴰⵃ, ⵎⵉⵏⵣⵉ ⴰⵔⵢⴰⵣ ⵏⵏⵉ ⵉⵏⵏⴰ ⴰⵏⴻⵖ: ‘ⵡⴰⵔ ⵜⵥⴰⵔⵔⴻⵎ ⵄⴰⴷ ⵓⴷⴻⵎ ⵉⵏⵓ ⵎⵖⵉⵔ ⵎⴰⵍⴰ ⵢⵓⵙⴰ-ⴷⴷ ⵓⵎⴰⵜⵡⴻⵎ ⴰⴽⵉⴷⵡⴻⵎ.’” ");
INSERT INTO rift_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","ⵉⵏⵏⴰ ⵉⵙⵔⴰⵉⵍ: “ⵎⴰⵖⴰⵔ ⴷ ⴰⵢⵉ ⵜⴻⴳⴳⵉⵎ ⵍⵖⴰⵔ ⵓⵛⴰ ⵜⴻⵏⵏⴰⵎ ⵉ ⵡⴻⵔⵢⴰⵣ ⵏⵏⵉ ⴱⴻⵍⵍⵉ ⴰⵇⴰ ⵖⴰⵔⵡⴻⵎ ⵄⴰⴷ ⵓⵎⴰⵜⵡⴻⵎ ⵏⵏⴻⵖⵏⵉ?” ");
INSERT INTO rift_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","ⵏⵉⵜⵏⵉ ⵏⵏⴰⵏ: “ⴰⵔⵢⴰⵣ ⵏⵏⵉ ⵉⵙⵙⴻⵇⵙⴰ ⵅⴰⵏⴻⵖ ⵏⵉⵛⴰⵏ, ⵓ ⵅ ⵜⴻⵎⵎⵓⵔⵜ ⵎⴰⵏⵉ ⵏⴻⵅⵍⴻⵇ, ⵉⵏⵏⴰ: ‘ⵎⴰ ⵉⴷⴷⴰⵔ ⵄⴰⴷ ⴱⴰⴱⴰⵜⵡⴻⵎ? ⵎⴰ ⵖⴰⵔⵡⴻⵎ ⵛⴰ ⵏ ⵓⵎⴰⵜⵡⴻⵎ ⵏⵏⴻⵖⵏⵉ?’ ⵅⴻⵏⵏⵉ ⵏⵄⴰⵡⴻⴷ ⴰⵙ ⵜ. ⵎⴰ ⵏⵣⴻⵎⵎⴰⵔ ⵣⴻⴳ ⵡⴰⵡⴰⵍⴻⵏ-ⴰ ⴰⴷ ⴷⴷ-ⵏⴻⵊⴱⴻⴷ ⵉⵍⵍⴰ ⴰⴷ ⵏⴻⵙⵙⴻⵏ ⵣⴻⵄⵎⴰ ⴰⴷ ⵢⵉⵏⵉ: ‘ⴰⵡⵢⴻⵎ-ⴷⴷ ⵓⵎⴰⵜⵡⴻⵎ?’” ");
INSERT INTO rift_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","ⵓⵛⴰ ⵉⵏⵏⴰ ⵢⴰⵀⵓⴷⴰ ⵉ ⴱⴰⴱⴰⵙ ⵉⵙⵔⴰⵉⵍ: “ⵙⴻⴽⴽ ⴰⴽⵉⴷⵉ ⴰⵃⴻⵏⵊⵉⵔ ⵓⵛⴰ ⴰⴷ ⵏⴻⴽⴽⴰⵔ ⴰⴷ ⵏⵔⴰⵃ, ⵃⵉⵎⴰ ⴰⴷ ⵏⴻⴷⴷⴰⵔ ⵓ ⵡⴰⵔ ⵏᵉⵜⵜⵎⴻⵜⵜⵉ ⵛⴰ ⵏⴻⵛⵛⵉⵏ ⴷ ⵛⴻⴽ ⴷ ⵜⴰⵔⵡⴰ ⵏⵏⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","ⵏⴻⵛⵛ ⴰⴷ ⴰⵙ ⵉⵍⵉⵖ ⴷ ⴰⴹⵎⴰⵏ ⵓ ⵣⴻⴳ ⵓⴼⵓⵙ ⵉⵏⵓ ⴰⴷ ⵜ ⵜᵉⵜⵜⴰⵔⴻⴷ ⵄⴰⵡⴻⴷ. ⵎⴰⵍⴰ ⵡⴰⵔ ⴷ ⴰⵛ ⵜ-ⵉ-ⴷⴷ-ⴰⵔⵔⵉⵖ, ⴰⴷ ⵜ ⵙⵙⴱⴻⴷⴷⴻⵖ ⵣⵣⴰⵜⴻⴽ, ⴰⴷ ⵢⵉⵍⵉ ⵅⴹⵉⵖ ⴰⴽⵉⴷⴻⴽ ⵉ ⵍⴻⴱⴷⴰ! ");
INSERT INTO rift_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","ⵎⴻⵄⵍⵉⴽ ⵡⴰⵔ ⵏⴻⵇⵇⵉⵎ ⵏⴻⵜⵜⵔⴰⵊⴰ ⴰⵟⵟⴰⵙ, ⵜⵉⵍⵉ ⵍⴻⵅⵅⵓ ⵏⴻⴷⵡⴻⵍ-ⴷⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵡⴰⵍⴰⵡⵉⵏ.” ");
INSERT INTO rift_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","ⵓⵛⴰ ⵢⴰⵔⵔⴰ-ⴷⴷ ⵅⴰⵙⴻⵏ ⵉⵙⵔⴰⵉⵍ, ⴱⴰⴱⴰⵜⵙⴻⵏ: “ⵎⴰⵍⴰ ⴰⵎⵎⵓ ⵉ ⵢⴻⴵⴰ ⵙ ⵜⵉⴷⴻⵜⵜ, ⴳⴳⴻⵎ ⴰⵎⵎⵓ ⵓⵛⴰ ⴽⵙⵉⵎ ⵎⵉⵏ ⵉⵛⵏⴰⵏ ⴰⵟⵟⴰⵙ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⴷⵉ ⵜⵅⵓⵏⵛⴰⵢ ⵏⵡⴻⵎ, ⵀⵡⴰⵎ-ⴷⴷ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜ ⵜⵉⵡⵢⴻⵎ ⴷ ⴰⵔⵔⵉⵖⴰⵍⵓ ⵉ ⵡⴻⵔⵢⴰⵣ ⵏⵏⵉ: ⵛⵡⴰⵢⵜ ⵏ ⴱⴰⵍⵙⴰⵎ ⴷ ⵛⵡⴰⵢⵜ ⵏ ⵜⴰⵎⵎⴻⵏⵜ, ⵍⴻⵄⵟⵓⵔ ⴷ ⵎⵉⵔⵔⵓ ⴷ ⵜⴻⵖⵢⴰⵛⵜ ⵏ ⴱⵉⵙⵜⴰⵛ ⴷ ⴵⵓⵣ. ");
INSERT INTO rift_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","ⴽⵙⵉⵎ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵙⴻⵇⵇⴰⵔ ⵏ ⵜⴻⵏⵄⴰⵛⵉⵏ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⴰⴽⵉⴷⵡⴻⵎ ⵓⵛⴰ ⴰⵔⵔⴻⵎ ⵙ ⵓⴼⵓⵙ ⵏⵡⴻⵎ ⵏⵏⵓⵇⴰⵔⵜ ⵉ ⴷⴷ-ⵉⵄⴻⵇⴱⴻⵏ ⴷⵉ ⵜⵅⵓⵏⵛⴰⵢ ⵏⵡⴻⵎ. ⴰⴷ ⵜⴰⵖ ⵜⵓⵖⴰ ⴷ ⵛⴰ ⵏ ⵍⵖⴰⵍⴰⵟ. ");
INSERT INTO rift_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","ⴰⵡⵢⴻⵎ-ⴷⴷ ⵄⴰⵡⴻⴷ ⵓⵎⴰⵜⵡⴻⵎ ⴰⴽⵉⴷⵡⴻⵎ, ⴽⴽⴰⵔⴻⵎ, ⵄⴻⵇⴱⴻⵎ ⵖⴰⵔ ⵡⴻⵔⵢⴰⵣ ⵏⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","ⵓⵛⴰ ⴰⵇⴰ ⴰⵔⴻⴱⴱⵉ, ⴰⵎⵣⴻⵎⵎⴰⵔ ⵅ ⴽⵓⵍⵛⵉ, ⴰⴷ ⴰⵡⴻⵎ ⵉⵡⵛ ⴰⵔⵔⴻⵃⵎⴻⵜ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵡⴻⵔⵢⴰⵣ ⵏⵏⵉ ⵓⵛⴰ ⴰⴷ ⵢⴰⵔⵅⵓ ⵉ ⵓⵎⴰⵜⵡⴻⵎ ⵏⵏⴻⵖⵏⵉ ⴷ ⴱⵉⵏⵢⴰⵎⵉⵏ. ⵓ ⵎⵉⵏ ⴷ ⴰⵢⵉ ⵉⵇⵇⵉⵎⴻⵏ ⵏⴻⵛⵛ, ⵎⴰⵍⴰ ⵜⵜⵡⴰⵃⴰⵔⵔⵎⴻⵖ ⵣⴻⴳ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵉⵏⵓ, ⴰⵇⴰ ⴰⴷ ⵣⵣⴰⵢⵙⴻⵏ ⵜⵜⵡⴰⵃⴰⵔⵔⵎⴻⵖ!” ");
INSERT INTO rift_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","ⵅⴻⵏⵏⵉ ⵉⵡⵢⴻⵏ ⵉⵔⵢⴰⵣⴻⵏ ⴰⵔⵔⵉⵖⴰⵍⵓ ⵓⵛⴰ ⴽⵙⵉⵏ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏⵙⴻⵏ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵙⴻⵇⵇⴰⵔ ⵏ ⵜⵎⴻⵏⵢⴰⵜ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵓⵍⴰ ⴷ ⴱⵉⵏⵢⴰⵎⵉⵏ ⵓⵛⴰ ⴽⴽⴰⵔⴻⵏ, ⵀⵡⴰⵏ ⵖⴰⵔ ⵎⵉⵚⵔⴰ ⵓⵛⴰ ⴱⴻⴷⴷⴻⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵢⵓⵙⵓⴼ. ");
INSERT INTO rift_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","ⵓⵎⵉ ⵉⵥⵔⴰ ⵢⵓⵙⵓⴼ ⴱⵉⵏⵢⴰⵎⵉⵏ ⴰⴽⵉⴷⵙⴻⵏ, ⵉⵏⵏⴰ ⵉ ⵡⴻⵏⵏⵉ ⵜⵓⵖⴰ ⵅ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⴻⵙ: “ⵙⵉⴷⴻⴼ ⵉⵔⵢⴰⵣⴻⵏ-ⴰ ⵖⴰⵔ ⵜⴰⴷⴷⴰⵔⵜ, ⵜⵖⴰⵔⵚⴻⴷ ⵉ ⵛⴰ ⵎⵉⵏ ⵉⴵⴰⵏ ⵉ ⵜⵖⴰⵔⵚⵜ, ⵙⴻⵡⵊⴻⴷ ⵉ-ⵜⵜ, ⵎⵉⵏⵣⵉ ⵉⵔⵢⴰⵣⴻⵏ-ⴰ ⴰⴷ ⴽⵉⴷⵉ ⵛⵛⴻⵏ ⵖⴰⵔ ⵡⴻⵣⵢⴻⵏ ⵏ ⵡⴰⵙⵙ.” ");
INSERT INTO rift_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","ⵉⴳⴳⴰ ⵡⴻⵔⵢⴰⵣ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵙ ⵉⵏⵏⴰ ⵢⵓⵙⵓⴼ ⵓⵛⴰ ⵢⵉⵡⵉ ⵉⵔⵢⴰⵣⴻⵏ ⵖⴰⵔ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵢⵓⵙⵓⴼ. ");
INSERT INTO rift_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","ⵅⴻⵏⵏⵉ ⴷⴻⵡⵍⴻⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ ⵏⵏⵉ ⴳⴳⵯⴻⴷⴻⵏ ⴰⵟⵟⴰⵙ, ⵓⵎⵉ ⵜⴻⵏ ⵙⵙⵉⴷⴼⴻⵏ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵢⵓⵙⵓⴼ ⵓⵛⴰ ⵏⵉⵜⵏⵉ ⵏⵏⴰⵏ: “ⵅ ⵜⵎⴻⵏⵢⴰⵜ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵉ ⴷ ⴰⵏⴻⵖ ⴷⴷ-ⵉⴷⴻⵡⵍⴻⵏ ⴷⵉ ⵜⵅⵓⵏⵛⴰⵢ ⵏⵏⴻⵖ ⵜⵡⴰⵍⴰ ⵜⴰⵎⴻⵣⵡⴰⵔⵓⵜ ⵉⵡⵢⴻⵏ ⴰⵏⴻⵖ-ⴷⴷ ⴷⴰ ⵃⵉⵎⴰ ⵅⴻⵏⵏⵉ ⵄⴰⵡⴻⴷ ⴰⴷ ⵅⴰⵏⴻⵖ ⵄⴻⴼⵙⴻⵏ ⵓⵛⴰ ⴰⴷ ⵅⴰⵏⴻⵖ ⵄⴻⴷⴷⴰⵏ, ⵅⴻⵏⵏⵉ ⴰⴷ ⴰⵏⴻⵖ ⴽⵙⵉⵏ ⴷ ⵉⵙⴻⵎⵖⴰⵏ ⴰⴽ-ⴷ ⵢⴻⵖⵢⴰⵍ ⵏⵏⴻⵖ.” ");
INSERT INTO rift_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","ⵇⴰⵔⵔⴱⴻⵏ-ⴷⴷ ⵖⴰⵔ ⵡⴻⵔⵢⴰⵣ ⵏⵏⵉ ⵉⴳⴳⴰ ⵢⵓⵙⵓⴼ ⵅ ⵜⴰⴷⴷⴰⵔⵜ ⵓⵛⴰ ⵙⵙⵉⵡⵍⴻⵏ ⴰⴽⵉⴷⴻⵙ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵜⴰⴷⴷⴰⵔⵜ, ");
INSERT INTO rift_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","ⵏⵏⴰⵏ: “ⴰ ⵙⵉⴷⵉ ⵉⵏⵓ, ⵏⴻⵛⵛⵉⵏ ⴰⵇⴰ ⵏⵉⵛⴰⵏ ⵏⴻⵀⵡⴰ-ⴷⴷ ⴷ ⴰⵎⴻⵣⵡⴰⵔ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵏⵙⴻⵖ ⵎⴰⵛⵛⴰ. ");
INSERT INTO rift_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","ⵉⵎⵙⴰⵔ ⵓⵎⵉ ⴷⴷ-ⵏⵉⵡⴻⴹ ⵖⴰⵔ ⵍⴻⵎⵔⴰⵃ ⵓⵛⴰ ⵏⴰⵔⵣⴻⵎ ⵜⵉⵅⵓⵏⵛⴰⵢ ⵏⵏⴻⵖ, ⵏⴻⵥⵔⴰ ⵏⵏⵓⵇⴰⵔⵜ ⵏ ⴽⵓⵍ ⵉⵊⵊ ⵖⴰⵔ ⵡⴻⵔⵣⴰⵎ ⵏ ⵓⵇⴻⵎⵎⵓⵎ ⵏ ⵜⵅⴰⵏⵛⴻⵜ ⵏⵏⴻⵙ, ⵏⵏⵓⵇⴰⵔⵜ ⵏⵏⴻⵖ ⵙ ⵍⵎⵉⵣⴰⵏ ⵏⵏⴻⵙ ⵏⵉⵛⴰⵏ. ⴰⵇⴰ ⵏⴰⵔⵔⴰ ⵉ-ⵜⵜ-ⵉ-ⴷⴷ ⵙ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵏⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","ⵄⴰⵡⴻⴷ ⵏⵉⵡⵉ-ⴷⴷ ⴷⴻⴳ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵏⴻⵖ ⵏⵏⵓⵇⴰⵔⵜ ⵏⵏⴻⵖⵏⵉ, ⵃⵉⵎⴰ ⴰⴷ ⵏⵙⴻⵖ ⵎⴰⵛⵛⴰ. ⵏⴻⵛⵛⵉⵏ ⵡⴰⵔ ⵏⴻⵙⵙⵉⵏ ⵡⵉ ⵉⴳⴳⵉⵏ ⵏⵏⵓⵇⴰⵔⵜ ⴷⵉ ⵜⵅⵓⵏⵛⴰⵢ ⵏⵏⴻⵖ.” ");
INSERT INTO rift_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","ⵢⴰⵔⵔⴰ-ⴷⴷ ⵅⴰⵙⴻⵏ: “ⵙⵍⴰⵎ ⵅⴰⵡⴻⵎ, ⵡⴰⵔ ⵜⵜⴻⴳⴳⵯⴻⴷⴻⵎ ⵛⴰ! ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ ⴷ ⴰⵔⴻⴱⴱⵉ ⵏ ⴱⴰⴱⴰⵜⵡⴻⵎ ⵉⵡⵛⴰ ⴰⵡⴻⵎ ⵉⵛⵜ ⵏ ⵜⵅⴰⴱⴻⵛⵜ ⴷⵉ ⵜⵅⵓⵏⵛⴰⵢ ⵏⵡⴻⵎ. ⴰⵇⴰ ⵏⵏⵓⵇⴰⵔⵜ ⵏⵡⴻⵎ ⵟⵟⴼⴻⵖ ⵜⵜ.” ⵓⵛⴰ ⵉⵙⵙⵓⴼⴼⴻⵖ-ⴷⴷ ⵖⴰⵔⵙⴻⵏ ⵛⵉⵎⵄⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","ⵅⴻⵏⵏⵉ ⵉⵙⵙⵉⴷⴻⴼ ⵡⴻⵔⵢⴰⵣ ⵉⵔⵢⴰⵣⴻⵏ ⵏⵏⵉ ⵖⴰⵔ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵢⵓⵙⵓⴼ, ⵉⵡⵛⴰ ⴰⵙⴻⵏ ⴰⵎⴰⵏ ⵓⵛⴰ ⵙⵉⵔⴷⴻⵏ ⵉⴹⴰⵔⴻⵏ ⵏⵙⴻⵏ. ⵉⵡⵛⴰ ⴰⵙⴻⵏ ⵄⴰⵡⴻⴷ ⵍⴻⵄⵍⴻⴼ ⵉ ⵢⴻⵖⵢⴰⵍ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","ⵓ ⵏⵉⵜⵏⵉ ⵙⵙⵡⴻⵊⴷⴻⵏ ⴰⵔⵔⵉⵖⴰⵍⵓ ⵉ ⵢⵓⵙⵓⴼ, ⵡⴻⵏⵏⵉ ⵉⴳⴳⵓⵔⴻⵏ ⴰⴷ ⴷⴷ-ⵢⴰⵙ ⵖⴰⵔ ⵡⴻⵣⵢⴻⵏ ⵏ ⵡⴰⵙⵙ, ⵎⵉⵏⵣⵉ ⵏⵉⵜⵏⵉ ⵙⵍⵉⵏ ⴰⵇⴰ ⴰⴷ ⵛⵛⴻⵏ ⴷⵉⵏⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","ⵍⴰⵎⵉ ⴷⴷ- ⵢⵓⴷⴻⴼ ⵢⵓⵙⵓⴼ ⵖⴰⵔ ⵜⴰⴷⴷⴰⵔⵜ, ⵡⵛⵉⵏ ⴰⵙ-ⴷⴷ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ ⴰⵔⵔⵉⵖⴰⵍⵓ ⵏⵏⵉ ⴷⴷ-ⵉⵡⵢⴻⵏ ⴰⴽⵉⴷⵙⴻⵏ, ⵓⵛⴰ ⴱⴻⵏⴷⵇⴻⵏ ⴰⵙ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","ⵉⵙⵙⴻⵇⵙⴰ ⵜⴻⵏ ⵅ ⵎⴰⵎⵎⴻⵛ ⴵⴰⵏ ⵓⵛⴰ ⵉⵏⵏⴰ: “ⵎⴰⵎⵎⴻⵛ ⵉⴵⴰ ⴱⴰⴱⴰⵜⵡⴻⵎ ⴰⵡⴻⵙⵙⴰⵔ ⵉ ⵅⴻⴼ ⵜⴻⵙⵙⵉⵡⵍⴻⵎ? ⵎⴰ ⴰⵇⴰ ⵄⴰⴷ ⵉⴷⴷⴰⵔ?” ");
INSERT INTO rift_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","ⵏⵉⵜⵏⵉ ⴰⵔⵔⵉⵏ: “ⵎⵍⵉⵀ ⵉ ⵢⴻⴵⴰ ⵓⵎⵙⴻⵅⵅⴰⵔ ⵏⵏⴻⵛ, ⴱⴰⴱⴰⵜⵏⴻⵖ, ⵏⴻⵜⵜⴰ ⵄⴰⴷ ⵉⴷⴷⴰⵔ.” ⵓⴹⴰⵔⴻⵏ ⵏⵉⵜⵏⵉ ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵉⴱⴻⵏⴷⴻⵇ. ");
INSERT INTO rift_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","ⵍⴰⵎⵉ ⵏⴻⵜⵜⴰ ⵉⵙⵙⴳⴻⵄⵄⴻⴷ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⵥⵔⴰ ⴱⵉⵏⵢⴰⵎⵉⵏ, ⵓⵎⴰⵙ, ⵎⵎⵉⵙ ⵏ ⵢⴻⵎⵎⴰⵙ, ⵉⵏⵏⴰ: “ⵎⴰ ⴷ ⵡⴰ ⴷ ⵓⵎⴰⵜⵡⴻⵎ, ⴰⵎⴰⵥⵓⵥ, ⵎⵉⵏ ⵅⴻⴼ ⴷ ⴰⵢⵉ ⵜⴻⵙⵙⵉⵡⵍⴻⵎ?” ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ: “ⴰⴷ ⵅⴰⴽ ⵉⵃⵉⵏⵏ ⴰⵔⴻⴱⴱⵉ, ⴰ ⵎⵎⵉ!” ");
INSERT INTO rift_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","ⵢⵓⵙⵓⴼ ⵉⴼⴼⴻⵖ ⵅⴻⵏⵏⵉ ⴷⴻⵖⵢⴰ, ⵎⵉⵏⵣⵉ ⵜⴰⵃⵏⵓⵏⴻⵛⵜ ⵏⵏⴻⵙ ⵅ ⵓⵎⴰⵙ ⵜⵓⵖⴰ ⵜⴻⵎⵖⴰⵔ. ⵢⴰⵔⵣⵓ ⵅ ⵎⴰⵏⵉ ⵖⴰ ⵉⵔⵓ ⵓⵛⴰ ⵢⵓⴷⴻⴼ ⵖⴰⵔ ⵉⵊⵊ ⵏ ⵡⴻⵅⵅⴰⵎ ⵓⵛⴰ ⵉⵔⵓ ⴷⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","ⵉⵙⵙⵉⵔⴷ ⵓⴷⴻⵎ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⴼⴼⴻⵖ-ⴷⴷ ⵖⴰⵔ ⴱⴰⵔⵔⴰ, ⵉⵟⵟⴻⴼ ⴷⴻⴳ ⵉⵅⴻⴼ ⵏⵏⴻⵙ, ⵉⵏⵏⴰ: “ⵇⴻⴷⵎⴻⵎ-ⴷⴷ ⵎⴰⵛⵛⴰ.” ");
INSERT INTO rift_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","ⵏⵉⵜⵏⵉ ⵙⵙⵡⴻⵊⴷⴻⵏ ⴰⵙ ⵉ ⵏⴻⵜⵜⴰ ⵡⴻⵃⵃⴷⴻⵙ ⵓ ⵉ ⵏⵉⵜⵏⵉ ⵡⴻⵃⵃⴻⴷⵙⴻⵏ ⵓⵍⴰ ⵉ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ ⵉⵏⵏⵉ ⴰⴽⵉⴷⴻⵙ ⵛⵛⵉⵏ ⵡⴻⵃⵃⴻⴷⵙⴻⵏ, ⵎⵉⵏⵣⵉ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ ⵡⴰⵔ ⵣⴻⵎⵎⴰⵔⴻⵏ ⴰⴷ ⵛⵛⴻⵏ ⴰⵖⵔⵓⵎ ⴰⴽ-ⴷ ⵉⵄⵉⴱⵔⴰⵏⵉⵢⵢⴻⵏ, ⵎⵉⵏⵣⵉ ⴷ ⵎⴰⵏ ⴰⵢⴰ ⴷ ⵊⵊⵄⵉⴼⴻⵛⵜ ⵖⴰⵔ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","ⵓⵛⴰ ⵏⵉⵜⵏⵉ ⵇⵇⵉⵎⴻⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏⵏⴻⵙ: ⴰⵎⴻⵏⵣⵓ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏⵏⴻⵙ ⵄⵍⴰⵃⵙⴰⴱ ⵜⴰⵙⵖⴰⵔⵜ ⵏ ⵜⵎⴻⵏⵣⵓⵜ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⵎⴰⵥⵓⵥ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏⵏⴻⵙ ⵄⵍⴰⵃⵙⴰⴱ ⵜⴻⵎⵥⵉ ⵏⵏⴻⵙ. ⵜⵓⵖⴰ ⵉⵔⵢⴰⵣⴻⵏ ⵜⵜⴱⴻⵀⴰⵜⴻⵏ, ⵅⴻⵣⵣⴰⵔⴻⵏ ⵉⵊⵊⴻⵏ ⴷⴻⴳ ⵡⴻⵏⵏⴻⵖⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵉⵇⴻⴷⴷⴻⵎ ⴰⵙⴻⵏ-ⴷⴷ ⵣⵉ ⵎⵉⵏ ⵜⵓⵖⴰ ⵉⴵⴰⵏ ⵣⵣⴰⵜⴻⵙ, ⵎⴰⵛⴰ ⵜⴰⵙⵖⴰⵔⵜ ⵏ ⴱⵉⵏⵢⴰⵎⵉⵏ ⵜⵓⵖⴰ-ⵜⵜ ⵅⴻⵎⵙⴰ ⵏ ⵜⵙⴻⵇⵇⴰⵔ ⴽⵜⴰⵔ ⵣⵉ ⵜⵙⴻⵇⵇⴰⵔ ⵏ ⵎⴰⵔⵔⴰ ⵉⴷⵙⴻⵏ. ⵓⵛⴰ ⵙⵡⵉⵏ ⵏⵉⵜⵏⵉ, ⵙⵙⴻⵏⵏⵉ ⴷⴻⵡⵍⴻⵏ ⴼⴰⵔⵃⴻⵏ ⴰⴽⵉⴷⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","ⵉⵙⵙⴻⴽⴽ ⵢⵓⵙⵓⴼ ⵖⴰⵔ ⵓⵎⵙⴻⵅⵅⴰⵔ ⵏⵏⵉ ⵜⵓⵖⴰ ⵅ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⴻⵙ, ⵉⵏⵏⴰ ⴰⵙ: “ⵄⴻⵎⵎⴰⵔ ⵜⵉⵅⵓⵏⵛⴰⵢ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ ⵏⵏⵉ ⵙ ⵎⴰⵛⵛⴰ, ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵣⴻⵎⵎⴰⵔⴻⵏ ⴰⴷ ⴽⵙⵉⵏ. ⴻⴳⴳ ⵏⵏⵓⵇⴰⵔⵜ ⵏ ⴽⵓⵍ ⵉⵊⵊ ⴷⴻⴳ ⵡⴰⵔⵣⴰⵎ ⵏ ⵓⵇⴻⵎⵎⵓⵎ ⵏ ⵜⵅⴰⵏⵛⴻⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","ⵙⴰⵔⵙ ⵍⴽⴰⵙ ⵉⵏⵓ, ⵍⴽⴰⵙ ⵏ ⵏⵏⵓⵇⴰⵔⵜ, ⴷⴻⴳ ⵡⴰⵔⵣⴰⵎ ⵏ ⵓⵇⴻⵎⵎⵓⵎ ⵏ ⵜⵅⴰⵏⵛⴻⵜ ⵏ ⵓⵎⴰⵥⵓⵥ ⴰⴽ-ⴷ ⵜⵎⴻⵏⵢⴰⵜ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵏ ⵍⵃⴻⴱⴱ ⵏⵏⴻⵙ ⵏ ⵢⵉⵔⴷⴻⵏ.” ⵓⵛⴰ ⵉⴳⴳⴰ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵙ ⵉⵏⵏⴰ ⵢⵓⵙⵓⴼ. ");
INSERT INTO rift_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","ⵖⴰⵔ ⵚⵚⴱⴻⵃ ⵓⵎⵉ ⴷⴷ-ⵢⴻⴼⴼⵓ ⵍⵀⴰⵍ, ⵊⵊⵉⵏ ⵉⵔⵢⴰⵣⴻⵏ ⴰⴷ ⵓⵢⵓⵔⴻⵏ, ⵏⵉⵜⵏⵉ ⴰⴽ-ⴷ ⵢⴻⵖⵢⴰⵍ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","ⵓⵎⵉ ⴼⴼⵖⴻⵏ ⵏⵉⵜⵏⵉ ⵣⵉ ⵜⴻⵏⴷⵉⵏⵜ, ⵜⵓⵖⴰ ⵄⴰⴷ ⵡⴰⵔ ⴳⴳⵯⵉⵊⴻⵏ ⵛⴰ, ⵉⵏⵏⴰ ⵢⵓⵙⵓⴼ ⵉ ⵡⴻⵏⵏⵉ ⵜⵓⵖⴰ ⵅ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⴻⵙ: “ⴽⴽⴰⵔ, ⴹⴼⴰⵔ ⵉⵔⵢⴰⵣⴻⵏ ⵏⵏⵉ ⵓⵛⴰ, ⵅⵎⵉ ⵅⴰⵙⴻⵏ ⵖⴰ ⵜⴻⵄⴷⵓⴷ, ⵉⵏⵉ ⴰⵙⴻⵏ: ‘ⵎⴰⵖⴰⵔ ⴷⴷ-ⵜⴰⵔⵔⴰⵎ ⵍⵅⴰⵔ ⵙ ⵍⵖⴰⵔ? ");
INSERT INTO rift_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","ⵎⴰ ⵡⴰⵔ ⵉⴵⵉ ⴷ ⵡⴰ ⴷ ⵍⴽⴰⵙ ⵉ ⵣⵉ ⵉⵙⴻⵙⵙ ⵙⵉⴷⵉ ⵉⵏⵓ ⵓ ⵎⴰ ⵡⴰⵔ ⵉⴵⵉ ⵙ ⵡⴰ ⵉ ⵣⵉ ⵖⴰ ⵉⴽⴰⵛⴻⴼ ⵎⵉⵏ ⵖⴰ ⵉⵎⵙⴰⵔⴻⵏ ⵜⵉⵡⴻⵛⵛⴰ? ⴰⵇⴰ ⵜⴻⴳⴳⵉⵎ ⵍⵖⴰⵔ ⵓⵎⵉ ⵜⴻⴳⴳⵉⵎ ⴰⵎⵢⴰ.’” ");
INSERT INTO rift_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","ⴰⵎ ⵜⴻⵏ ⵉⵄⴷⵓ, ⵉⵏⵏⴰ ⴰⵙⴻⵏ ⴰⵡⴰⵍⴻⵏ-ⴰ ⵙⵉⵎⴰⵏⵜ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","ⵏⵉⵜⵏⵉ ⴰⵔⵔⵉⵏ-ⴷⴷ ⵅⴰⵙ: “ⵎⴰⵢⴻⵎⵎⵉ ⵉⵇⵇⴰⵔ ⵙⵉⴷⵉ ⵉⵏⵓ ⴰⵡⴰⵍⴻⵏ-ⴰ? ⵉⴳⴳⵯⴻⵊ ⵅ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵛ ⴰⴷ ⴳⴳⴻⵏ ⵎⴰⵏ ⴰⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","ⵅⵣⴰⵔ, ⵏⵏⵓⵇⴰⵔⵜ ⵉ ⵏⵓⴼⴰ ⴷⴻⴳ ⵡⴰⵔⵣⴰⵎ ⵏ ⵓⵇⴻⵎⵎⵓⵎ ⵏ ⵜⵅⵓⵏⵛⴰⵢ ⵏⵏⴻⵖ, ⴰⵇⴰ ⵏⴰⵔⵔ ⴰⵛ ⵜⵜ-ⵉ-ⴷⴷ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ. ⵎⴰⵎⵎⴻⵛ ⵄⴰⴷ ⵉ ⵖⴰ ⵏⴻⴳⴳ ⴰⴷ ⵏⴰⵛⴰⵔ ⵏⵏⵓⵇⴰⵔⵜ ⵏⵉⵖ ⵓⵔⴻⵖ ⵣⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵙⵉⴷⵉ ⵏⵏⴻⵛ? ");
INSERT INTO rift_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","ⵡⵉ ⵣⴻⴳ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵛ ⵉ ⵖⴰⵔ ⵉ ⵖⴰ ⵉⵜⵜⵡⴰⴼ ⵍⴽⴰⵙ, ⴰⴷ ⵉⵎⵎⴻⵜ, ⵓⵛⴰ ⵏⴻⵛⵛⵉⵏ ⵄⴰⵡⴻⴷ ⴰⴷ ⵏⵉⵍⵉ ⴷ ⵉⵙⴻⵎⵖⴰⵏ ⵏ ⵙⵉⴷⵉ ⵉⵏⵓ!” ");
INSERT INTO rift_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","ⵏⴻⵜⵜⴰ ⵉⵏⵏⴰ: “ⵅⴻⵏⵏⵉ ⵍⴻⵅⵅⵓ ⴰⴷ ⵢⵉⵍⵉ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⴻⵏⵏⴰⵎ ⴽⴻⵏⵏⵉⵡ. ⵡⴻⵏⵏⵉ ⵖⴰⵔ ⵜ ⵖⴰ ⵏⴰⴼ, ⴷ ⵏⴻⵜⵜⴰ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵉⵙⵎⴻⵖ ⵉⵏⵓ, ⵎⴰⵛⴰ ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⵜⵉⵍⵉⵎ ⴷ ⵉⴼⵓⵔⵔⴰ.” ");
INSERT INTO rift_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","ⵓⵛⴰ ⴽⵓⵍ ⵉⵊⵊ ⵣⵣⴰⵢⵙⴻⵏ ⵉⵇⴻⴵⴻⵇ ⴰⴷ ⵉⵙⵙⴰⵔⵙ ⵜⴰⵅⴰⵏⵛⴻⵜ ⵏⵏⴻⵙ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵓⵛⴰ ⴽⵓⵍ ⵉⵊⵊ ⵢⴰⵔⵣⴻⵎ ⵜⴰⵅⴰⵏⵛⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵉⴼⴻⵜⵜⴻⵛ ⵉ-ⵜⴻⵏⵜ, ⵉⴱⴷⴰ ⵣⴻⴳ ⵓⵎⴻⵇⵇⵔⴰⵏ, ⵉⴽⴻⵎⵎⴻⵍ ⵣⴻⴳ ⵓⵎⴻⵥⵢⴰⵏ, ⵓⵛⴰ ⵓⴼⵉⵏ ⵍⴽⴰⵙ ⴷⵉ ⵜⵅⴰⵏⵛⴻⵜ ⵏ ⴱⵉⵏⵢⴰⵎⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","ⵅⴻⵏⵏⵉ ⵛⴰⵔⵔⴳⴻⵏ ⴰⵔⵔⵓⴹ ⵏⵙⴻⵏ, ⵓⵛⴰ ⴽⵓⵍ ⵉⵊⵊ ⵉⵙⵙⴰⵔⴱⵓ ⵄⴰⵡⴻⴷ ⵅ ⵡⴻⵖⵢⵓⵍ ⵏⵏⴻⵙ ⵓⵛⴰ ⵄⴻⵇⴱⴻⵏ ⵏⵉⵜⵏⵉ ⵖⴰⵔ ⵜⴻⵏⴷⵉⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","ⵓⵛⴰ ⵢⵉⵡⴻⴹ ⵢⴰⵀⵓⴷⴰ ⴰⴽ-ⴷ ⴰⵢⵜⵎⴰⵙ ⵖⴰⵔ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵢⵓⵙⵓⴼ, ⵡⴻⵏⵏⵉ ⵜⵓⵖⴰ ⴷⵉⵏ ⵄⴰⴷ, ⵓⵛⴰ ⵡⴹⴰⵏ ⵣⵣⴰⵜⴻⵙ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","ⵉⵏⵏⴰ ⴰⵙⴻⵏ ⵢⵓⵙⵓⴼ: “ⵎⴰⵏⴰ ⵛⵖⴻⵍ-ⴰ ⵉ ⵜⴻⴳⴳⵉⵎ? ⵎⴰ ⵡⴰⵔ ⵜⴻⴼⵀⵉⵎⴻⵎ ⵛⴰ ⴱⴻⵍⵍⵉ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⴰⵎ ⵏⴻⵛⵛ, ⵉⴳⴳⵓⵔ ⴰⴷ ⵅⴰⵙ ⵉⴽⴰⵛⴻⴼ ⵏⵉⵛⴰⵏ?” ");
INSERT INTO rift_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","ⵉⵏⵏⴰ ⵢⴰⵀⵓⴷⴰ: “ⵎⵉⵏ ⵖⴰ ⵏⵉⵏⵉ ⵉ ⵙⵉⴷⵉ ⵉⵏⵓ ⴷ ⵎⴰⵎⵎⴻⵛ ⵉ ⵖⴰ ⵏⴻⵙⵙⵉⵡⴻⵍ ⵏⵉⵖ ⵙ ⵎⵉⵏ ⵣⵉ ⵖⴰ ⵏⵙⴻⴳⴳⴻⴷ ⵉⵅⴻⴼ ⵏⵏⴻⵖ? ⴰⵔⴻⴱⴱⵉ ⵉⵇⴻⴵⴻⴱ ⴷⴷⴻⵏⴱ ⵏ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵛ, ⵅⵣⴰⵔ, ⵏⴻⵛⵛⵉⵏ ⴷ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏ ⵙⵉⴷⵉ ⵉⵏⵓ, ⵏⴻⵛⵛⵉⵏ ⴷ ⵡⵉ ⵖⴰⵔ ⵓⴼⵉⵏ ⵍⴽⴰⵙ.” ");
INSERT INTO rift_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","ⵎⴰⵛⴰ ⵏⴻⵜⵜⴰ ⵢⴰⵔⵔⴰ: “ⵉⴳⴳⵯⴻⵊ ⵅⴰⴼⵉ ⴰⴷ ⴳⴳⴻⵖ ⴰⵢⴰ! ⴰⵔⵢⴰⵣ ⵏⵏⵉ ⵖⴰⵔ ⵓⴼⵉⵏ ⵍⴽⴰⵙ, ⵏⴻⵜⵜⴰ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵉⵙⵎⴻⵖ ⵉⵏⵓ, ⵎⴰⵛⴰ ⴽⴻⵏⵏⵉⵡ ⵔⵓⵃⴻⵎ ⴷⵉ ⵍⴻⵀⵏⴰ ⵖⴰⵔ ⴱⴰⴱⴰⵜⵡⴻⵎ.” ");
INSERT INTO rift_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","ⵅⴻⵏⵏⵉ ⵢⵉⵡⴻⴹ-ⴷⴷ ⵢⴰⵀⵓⴷⴰ ⵖⴰⵔⴻⵙ, ⵉⵏⵏⴰ: “ⴰ ⵙⵉⴷⵉ ⵉⵏⵓ, ⴻⵊⵊ ⴰⴷ ⵉⵙⵙⵉⵡⴻⵍ ⵓⵎⵙⴻⵅⵅⴰⵔ ⵏⵏⴻⵛ ⵉⵊⵊ ⵏ ⵡⴰⵡⴰⵍ ⴷⴻⴳ ⵓⵎⴻⵣⵣⵓⵖ ⵏ ⵙⵉⴷⵉ ⵉⵏⵓ, ⵡⴰⵔ ⵢⴰⵔⴻⵇⵇ ⵓⵅⴻⵢⵢⴻⵇ ⵏⵏⴻⵛ ⵅ ⵓⵎⵙⴻⵅⵅⴰⵔ ⵏⵏⴻⵛ, ⵎⵉⵏⵣⵉ ⴰⵇⴰ ⵛⴻⴽ ⴰⵎ ⴼⵉⵔⵄⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","ⵙⵉⴷⵉ ⵉⵏⵓ ⵉⵙⵙⴻⵇⵙⴰ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵙ, ⵉⵏⵏⴰ: ‘ⵎⴰ ⵖⴰⵔⵡⴻⵎ ⵄⴰⴷ ⴱⴰⴱⴰⵜⵡⴻⵎ ⵏⵉⵖ ⵜⴰⵡⵎⴰⵜ?’ ");
INSERT INTO rift_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","ⵓⵛⴰ ⵏⴻⵛⵛⵉⵏ ⵏⴰⵔⵔⴰ ⵅ ⵙⵉⴷⵉ ⵉⵏⵓ: ‘ⴰⵇⴰ ⵖⴰⵔⵏⴻⵖ ⴱⴰⴱⴰⵜⵏⴻⵖ ⴷ ⴰⵡⴻⵙⵙⴰⵔ ⴷ ⵢⵉⵊⵊ ⵏ ⵓⵃⴻⵏⵊⵉⵔ, ⵡⴻⵏⵏⵉ ⴷ ⴰⵙ ⴷⴷ-ⵉⵜⵜⵡⴰⵅⴻⵍⵇⴻⵏ ⵅ ⵜⴻⵡⵙⴰⵔ ⵏⵏⴻⵙ, ⴷ ⴰⵎⴰⵥⵓⵥ ⵄⴰⴷ. ⵓⵎⴰⵙ ⵉⵎⵎⵓⵜ, ⵏⴻⵜⵜⴰ ⵡⴰⵀⴰ ⵉ ⵉⵇⵇⵉⵎⴻⵏ ⵣⴻⴳ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵢⴻⵎⵎⴰⵙ, ⵓ ⴱⴰⴱⴰⵙ ⵉⵜⵜⴻⵅⵙ ⵉ-ⵜ.’ ");
INSERT INTO rift_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","ⵅⴰⵙ ⵓⵛⴰ ⵜⴻⵏⵏⵉⴷ ⵛⴻⴽ ⵉ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵛ: ‘ⴰⵡⵢⴻⵎ ⵜ-ⵉ-ⴷⴷ ⴷⴰ ⵖⴰⵔⵉ, ⵃⵉⵎⴰ ⴰⴷ ⵜ ⵥⴰⵔⴻⵖ ⵙ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵉⵏⵓ.’ ");
INSERT INTO rift_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","ⵓⵛⴰ ⵏⴻⵛⵛⵉⵏ ⵏⴻⵏⵏⴰ ⵉ ⵙⵉⴷⵉ ⵉⵏⵓ: ‘ⵡⴰⵔ ⵉⵣⴻⵎⵎⴰⵔ ⵓⵃⴻⵏⵊⵉⵔ ⴰⴷ ⵢⴻⵊⵊ ⴱⴰⴱⴰⵙ, ⵎⵉⵏⵣⵉ ⵎⴰⵍⴰ ⵉⵊⵊⴰ ⵉ-ⵜ, ⴱⴰⴱⴰⵙ ⴰⴷ ⵉⵎⵎⴻⵜ.’ ");
INSERT INTO rift_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","ⵅⴻⵏⵏⵉ ⵜⴻⵏⵏⵉⴷ ⵉ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵛ: ‘ⵎⴰⵍⴰ ⵓⵎⴰⵜⵡⴻⵎ ⴰⵎⴰⵥⵓⵥ ⵡⴰⵔ ⴷⴷ-ⵢⵓⵙⵉ ⴰⴽⵉⴷⵡⴻⵎ, ⵡⴰⵔ ⵜⵥⴰⵔⵔⴻⵎ ⵄⴰⴷ ⵓⴷⴻⵎ ⵉⵏⵓ.’ ");
INSERT INTO rift_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","ⵍⴰⵎⵉ ⵏⴳⴻⵄⵄⴻⴷ ⵖⴰⵔ ⴱⴰⴱⴰ, ⴰⵎⵙⴻⵅⵅⴰⵔ ⵏⵏⴻⵛ, ⵏⴻⵙⵙⴻⵄⴷⵓ ⴰⵙ ⴰⵡⴰⵍⴻⵏ ⵏ ⵙⵉⴷⵉ ⵉⵏⵓ. ");
INSERT INTO rift_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","ⵓⵛⴰ ⴱⴰⴱⴰⵜⵏⴻⵖ ⵉⵏⵏⴰ: ‘ⵄⴻⵇⴱⴻⵎ ⵄⴰⵡⴻⴷ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⴻⵙⵖⴻⵎ ⵛⵡⴰⵢⵜ ⵏ ⵎⴰⵛⵛⴰ ⵉ ⵏⴻⵛⵛⵉⵏ.’ ");
INSERT INTO rift_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","ⵅⴻⵏⵏⵉ ⵏⴰⵔⵔⴰ-ⴷⴷ: ‘ⵡⴰⵔ ⵏⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵏⵔⴰⵃ. ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⵓⵎⴰⵜⵏⴻⵖ, ⴰⵎⴰⵥⵓⵥ, ⵉⵔⵓⵃ ⴰⴽⵉⴷⵏⴻⵖ, ⴰⴷ ⵏⵔⴰⵃ, ⵎⵉⵏⵣⵉ ⵡⴰⵔ ⵏⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵏⵥⴰⵔ ⵓⴷⴻⵎ ⵏ ⵡⴻⵔⵢⴰⵣ ⵏⵏⵉ, ⵎⵖⵉⵔ ⵎⴰⵍⴰ ⴰⵇⴰ ⴰⴽⵉⴷⵏⴻⵖ ⵓⵎⴰⵜⵏⴻⵖ ⴰⵎⴰⵥⵓⵥ.’ ");
INSERT INTO rift_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⴰⵏⴻⵖ ⵓⵎⵙⴻⵅⵅⴰⵔ ⵏⵏⴻⵛ, ⴱⴰⴱⴰⵜⵏⴻⵖ: ‘ⴽⴻⵏⵏⵉⵡ ⵜⴻⵙⵙⵏⴻⵎ ⴱⴻⵍⵍⵉ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵉ ⴷ ⴰⵢⵉ ⴷⴷ-ⵜⵓⵔⵓⵡ ⵜⴻⵎⵖⴰⵔⵜ ⵉⵏⵓ. ");
INSERT INTO rift_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","ⵉⴼⴼⴻⵖ ⵉⵊⵊⴻⵏ ⵣⵉ ⵖⴰⵔⵉ ⵓⵛⴰ ⵏⵏⵉⵖ: ⴰⵇⴰ ⵙ ⵜⵉⴷⴻⵜⵜ ⵉⵜⵜⵡⴰⴱⴻⵜⵜⴻⵇ! ⵓ ⴰⵍ ⵍⴻⵅⵅⵓ ⵄⴰⴷ ⵡⴰⵔ ⵜ ⵥⵔⵉⵖ. ");
INSERT INTO rift_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","ⵎⴰⵍⴰ ⵄⴰⵡⴻⴷ ⵜⴻⴽⴽⵙⴻⵎ ⴰⵢⵉ ⵡⴰ ⵓⵛⴰ ⵉⵎⵙⴰⵔ ⵛⴰ ⵏ ⵍⵖⴰⵔ, ⴰⴷ ⵜⴻⵙⵙⴻⵀⵡⴰⵎ ⵛⵛⵉⴱ ⵉⵏⵓ ⵙ ⵡⴻⵛⴹⴰⵏ ⵖⴰⵔ ⵍⴰⵅⴰⵔⵜ!’ ");
INSERT INTO rift_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","ⵍⴻⵅⵅⵓ ⵅⴻⵏⵏⵉ, ⵎⴰⵍⴰ ⵔⵓⵃⴻⵖ ⵏⴻⵛⵛ ⵖⴰⵔ ⵓⵎⵙⴻⵅⵅⴰⵔ ⵏⵏⴻⵛ, ⴱⴰⴱⴰ, ⵓⵛⴰ ⴰⵃⴻⵏⵊⵉⵔ ⵡⴰⵔ ⴽⵉⴷⵉ ⵉⴵⵉ - ⵍⴻⵄⵎⴰⵔ ⵏⵏⴻⵙ ⵉⵍⵚⴻⵇ ⵖⴰⵔ ⵍⴻⵄⵎⴰⵔ ⵏ ⴱⴰⴱⴰⵙ - ");
INSERT INTO rift_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","ⴰⵇⴰ ⴰⴷ ⵉⵎⵎⴻⵜ ⵅⵎⵉ ⵖⴰ ⵉⵥⴰⵔ ⴰⵃⴻⵏⵊⵉⵔ ⵡⴰⵔ ⵉⴵⵉ, ⵓⵛⴰ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵛ ⴰⴷ ⵙⵙⴻⵀⵡⴰⵏ ⵛⵛⵉⴱ ⵏ ⵓⵎⵙⴻⵅⵅⴰⵔ ⵏⵏⴻⵛ, ⴱⴰⴱⴰⵜⵏⴻⵖ, ⵙ ⵡⴻⵛⴹⴰⵏ ⵖⴰⵔ ⵍⴰⵅⴰⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","ⴰⵇⴰ ⵣⴻⵄⵎⴰ ⴰⵎⵙⴻⵅⵅⴰⵔ ⵏⵏⴻⵛ ⴷ ⴰⴹⵎⴰⵏ ⵉ ⵓⵃⴻⵏⵊⵉⵔ-ⴰ ⵖⴰⵔ ⴱⴰⴱⴰ ⵓⵎⵉ ⵉⵏⵏⴰ: ‘ⵎⴰⵍⴰ ⵡⴰⵔ ⴷ ⴰⵛ ⵜ-ⵉ-ⴷⴷ-ⴰⵔⵔⵉⵖ, ⵍⴻⵅⴷⴻⵏⵏⵉ ⵏⴻⵛⵛ ⴰⴷ ⵉⵍⵉⵖ ⴷ ⴰⵎⴻⴷⵏⵓⴱ ⵉ ⴱⴰⴱⴰ ⵉ ⵍⴻⴱⴷⴰ!’ ");
INSERT INTO rift_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","ⵉⵡⴰ ⵍⴻⵅⵅⵓ, ⴻⵊⵊ ⴰⵎⵙⴻⵅⵅⴰⵔ ⵏⵏⴻⵛ ⴰⴷ ⵉⵇⵇⵉⵎ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏ ⵓⵃⴻⵏⵊⵉⵔ-ⴰ ⴰⵎ ⵢⵉⵙⵎⴻⵖ ⵖⴰⵔ ⵙⵉⴷⵉ ⵉⵏⵓ, ⵓⵛⴰ ⴻⵊⵊ ⴰⵃⴻⵏⵊⵉⵔ ⴰⴷ ⵉⵔⴰⵃ ⴰⴽ-ⴷ ⴰⵢⵜⵎⴰⵙ! ");
INSERT INTO rift_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","ⵎⴰⵖⴰⵔ ⵎⴰⵎⵎⴻⵛ ⵖⴰ ⴳⴳⴻⵖ ⴰⴷ ⴳⴻⵄⵄⴷⴻⵖ ⵖⴰⵔ ⴱⴰⴱⴰ, ⴱⵍⴰ ⴰⵃⴻⵏⵊⵉⵔ-ⴰ ⴰⴽⵉⴷⵉ? ⵎⴰⵎⵎⴻⵛ ⵉ ⵖⴰ ⵥⴰⵔⴻⵖ ⵍⴻⵎⵃⴰⵢⴻⵏ ⵉ ⴷⴷ ⵖⴰ ⵉⵡⴹⴰⵏ ⵅ ⴱⴰⴱⴰ?” ");
INSERT INTO rift_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","ⵅⴻⵏⵏⵉ ⵡⴰⵔ ⵉⵣⴻⵎⵎⴰⵔ ⵄⴰⴷ ⵢⵓⵙⵓⴼ ⴰⴷ ⵉⵟⵟⴻⴼ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵣⵣⴰⵜ ⵉ ⵢⵉⵏⵏⵉ ⴰⴽⵉⴷⴻⵙ ⵎⴰⵔⵔⴰ ⵓⵛⴰ ⵉⵍⴰⵖⴰ: “ⵙⵓⴼⴼⵖⴻⵎ ⵎⴰⵔⵔⴰ ⵉⵏⵏⵉ ⴰⴽⵉⴷⵉ ⴷⴰ!” ⵡⴰⵔ ⵉⵇⵇⵉⵎ ⵃⴻⴷ ⴰⴽⵉⴷⴻⵙ ⵍⴰⵎⵉ ⵉⵙⵙⵛⴻⵏ ⵢⵓⵙⵓⴼ ⵉ ⵢⴰⵢⵜⵎⴰⵙ ⵎⵉⵏ ⵉⵄⵏⴰ. ");
INSERT INTO rift_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵢⴰⵔⵅⵓ ⵜⵎⵉⵊⵊⴰ ⵏⵏⴻⵙ ⵙ ⵉⵖⵓⵢⵢⴰⵏ, ⴰⵍⴰⵎⵉ ⴷ ⴰⵙ ⵙⵍⵉⵏ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ, ⵓⵛⴰ ⵓⵍⴰ ⴷ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⴼⵉⵔⵄⵓⵏ ⵜⴻⵙⵍⴰ ⴰⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","ⵉⵏⵏⴰ ⵢⵓⵙⵓⴼ ⵉ ⵢⴰⵢⵜⵎⴰⵙ: “ⵏⴻⵛⵛ ⴷ ⵢⵓⵙⵓⴼ! ⵎⴰ ⵉⴷⴷⴰⵔ ⵄⴰⴷ ⴱⴰⴱⴰ?” ⴰⵢⵜⵎⴰⵙ ⵡⴰⵔ ⵣⴻⵎⵎⴰⵔⴻⵏ ⴰⴷ ⵅⴰⵙ ⴷⴷ-ⴰⵔⵔⴻⵏ, ⵎⵉⵏⵣⵉ ⵜⵓⵖⴰ ⴳⴳⵯⴻⴷⴻⵏ ⵣⵣⴰⵢⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","ⵉⵏⵏⴰ ⵢⵓⵙⵓⴼ ⵉ ⵢⴰⵢⵜⵎⴰⵙ: “ⵇⴰⵔⵔⴱⴻⵎ-ⴷⴷ ⵍⴻⵅⵅⵓ ⵖⴰⵔⵉ!” ⵓⵛⴰ ⵏⵉⵜⵏⵉ ⵇⴰⵔⵔⴱⴻⵏ ⵖⴰⵔⴻⵙ. ⵉⵏⵏⴰ ⵅⴻⵏⵏⵉ: “ⵏⴻⵛⵛ ⴷ ⵢⵓⵙⵓⴼ ⵓⵎⴰⵜⵡⴻⵎ, ⵡⴻⵏⵏⵉ ⵜⴻⵣⵣⴻⵏⵣⴻⵎ ⵉ ⵎⵉⵚⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","ⵍⴻⵅⵅⵓ, ⵡⴰⵔ ⴽⴻⵙⵙⵉⵎ ⵙ ⵡⴻⵎⵏⵓⵙ ⵓ ⵡⴰⵔ ⵜ ⵜⵜⴻⵊⵊⵉⵎ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⴰⵅⴻⵢⵢⴻⵇ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵡⴻⵎ ⵓⵎⵉ ⴷ ⴰⵢⵉ ⵜⴻⵣⵣⴻⵏⵣⴻⵎ ⴷⴰⵏⵉⵜⴰ ⵉ ⵎⵉⵚⵔⴰ, ⴰⵇⴰ ⴰⵔⴻⴱⴱⵉ ⵉⵙⵙⴻⴽⴽ ⴰⵢⵉ-ⴷⴷ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴽⴻⵏⵏⵉⵡ ⵊⵊⴻⵖ ⵜⴻⴷⴷⴰⵔⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","ⴰⵇⴰ ⵍⴻⵅⵅⵓ ⵄⴰⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵏ ⵍⴰⵥ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵓⵛⴰ ⵇⵇⵉⵎ ⵄⴰⴷ ⵅⴻⵎⵙⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵡⴰⵔ ⴷⴰⵢⵙⴻⵏ ⵉⵜⵜⵉⵍⵉ ⵜⵢⴰⵔⵣⴰ ⵏⵉⵖ ⵜⴰⵎⴻⵢⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","ⵎⴰⵛⴰ ⴰⵔⴻⴱⴱⵉ ⵉⵙⵙⴻⴽⴽ ⴰⵢⵉ-ⴷⴷ ⵣⵣⴰⵜⵡⴻⵎ, ⵃⵉⵎⴰ ⴰⴷ ⴰⵡⴻⵎ ⴳⴳⴻⵖ ⵎⵉⵏ ⵉⵇⵇⵉⵎⴻⵏ ⵅ ⵜⴻⵎⵎⵓⵔⵜ ⵓ ⵃⵉⵎⴰ ⴰⴷ ⵃⴹⵉⵖ ⵜⵓⴷⴰⵔⵜ ⵏⵡⴻⵎ ⵉ ⵢⵉⵊⵊ ⵏ ⵓⵙⴻⵏⵊⴻⵎ ⵉⵎⵖⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","ⵅⴻⵏⵏⵉ ⵍⴻⵅⵅⵓ, ⴽⴻⵏⵏⵉⵡ ⵡⴰⵔ ⴷ ⴰⵢⵉ ⴷⴷ-ⵜⴻⵙⵙⴻⴽⴽⴻⵎ ⵛⴰ ⴷⴰ, ⵎⴰⵛⴰ ⴰⵔⴻⴱⴱⵉ ⴷ ⵡⴻⵏⵏⵉ ⴷ ⴰⵢⵉ ⵉⴳⴳⵉⵏ ⴷ ⴱⴰⴱⴰⵙ ⵉ ⴼⵉⵔⵄⵓⵏ ⴷ ⵙⵉⴷⵉ ⵅ ⵎⴰⵔⵔⴰ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⴻⵙ ⴷ ⵍⵃⴰⴽⴻⵎ ⵅ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","ⵇⴻⴵⵇⴻⵎ ⴷⴻⵖⵢⴰ, ⵙⴳⴻⵄⵄⴷⴻⵎ ⵖⴰⵔ ⴱⴰⴱⴰ, ⵉⵏⵉⵎ ⴰⵙ: ‘ⴰⵎⵎⵓ ⵉ ⵉⵇⵇⴰⵔ ⵎⵎⵉⵛ ⵢⵓⵙⵓⴼ: ⴰⵔⴻⴱⴱⵉ ⵉⴳⴳⴰ ⴰⵢⵉ ⴷ ⵙⵉⴷⵉ ⵏ ⵎⴰⵔⵔⴰ ⵎⵉⵚⵔⴰ. ⴰⵔⴰⵃ-ⴷⴷ ⵖⴰⵔⵉ, ⵡⴰⵔ ⵜⵜⴻⵄⴳⵉⵣ. ");
INSERT INTO rift_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","ⴰⴷ ⵜⵣⴻⴷⵖⴻⴷ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵊⵓⵛⴰⵏ, ⴰⴷ ⵜⵉⵍⵉⴷ ⵣⵣⴰⵜⵉ, ⵛⴻⴽ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵛ, ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵛ, ⴷ ⵡⵓⴵⵉ ⴷ ⵉⴼⵓⵏⴰⵙⴻⵏ ⴷ ⵜⴼⵓⵏⴰⵙⵉⵏ ⵓⵍⴰ ⴷ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵖⴰⵔⴻⴽ. ");
INSERT INTO rift_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","ⴰⴷ ⴰⵛ ⴳⴳⴻⵖ ⴰⵔⵣⴻⵇ ⴷⵉⵏ, ⵎⵉⵏⵣⵉ ⴰⴷ ⴷⴷ-ⴰⵙⴻⵏ ⵄⴰⴷ ⵅⴻⵎⵙⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵏ ⵍⴰⵥ, ⵃⵉⵎⴰ ⵡⴰⵔ ⵜᵉⵜⵜⴻⴹⵄⵉⴼⴻⴷ, ⵛⴻⴽ ⵍⵍⴰ, ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⴻⵛ ⵍⵍⴰ, ⵓⵍⴰ ⴷ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵖⴰⵔⴻⴽ ⵍⵍⴰ! ");
INSERT INTO rift_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","ⵅⵣⴰⵔ, ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵡⴻⵎ ⵥⵔⵉⵏⵜ, ⵓⵍⴰ ⴷ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵓⵎⴰ ⴱⵉⵏⵢⴰⵎⵉⵏ, ⴰⵇⴰ ⴷ ⵏⴻⵛⵛ ⵉ ⴽⵉⴷⵡⴻⵎ ⵉⵙⵙⴰⵡⴰⵍⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","ⵄⴻⵍⵎⴻⵎ ⵉ ⴱⴰⴱⴰ ⵅ ⵎⴰⵔⵔⴰ ⴰⵄⵓⴵⵉ ⵉⵏⵓ ⴷⵉ ⵎⵉⵚⵔⴰ ⵓ ⵅ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵜⴻⵥⵔⵉⵎ. ⵇⴻⴵⵇⴻⵎ ⴷⴻⵖⵢⴰ, ⵜⵉⵡⵢⴻⵎ-ⴷⴷ ⴱⴰⴱⴰ ⴷⴰ.” ");
INSERT INTO rift_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","ⵓⵛⴰ ⵉⵏⴳⴻⵣ ⵅ ⵢⵉⵔⵉ ⵏ ⴱⵉⵏⵢⴰⵎⵉⵏ ⵓⵎⴰⵙ, ⵉⵔⵓ, ⵓⵛⴰ ⴱⵉⵏⵢⴰⵎⵉⵏ ⵉⵔⵓ ⵅ ⵢⵉⵔⵉ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","ⵉⵙⵙⵓⴷⴻⵎ ⵎⴰⵔⵔⴰ ⴰⵢⵜⵎⴰⵙ, ⵉⵔⵓ ⵅⴰⵙⴻⵏ. ⴰⵡⴰⵔⵏⵉ ⵎⴰⵏ ⴰⵢⴰ ⵙⵙⵉⵡⵍⴻⵏ ⴰⴽⵉⴷⴻⵙ ⴰⵢⵜⵎⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","ⵍⴰⵎⵉ ⵜⴻⵙⵍⴰ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⴼⵉⵔⵄⵓⵏ ⵍⴻⵅⴱⴰⵔ-ⴰ, ⵏⵏⴰⵏ: “ⴰⵢⵜⵎⴰⵙ ⵏ ⵢⵓⵙⵓⴼ ⵓⵙⵉⵏ-ⴷⴷ!”. ⵜⵓⵖⴰ-ⵜ ⴷ ⵍⴻⵅⴱⴰⵔ ⴰⵚⴻⴱⵃⴰⵏ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⴼⵉⵔⵄⵓⵏ ⴷ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","ⵉⵏⵏⴰ ⴼⵉⵔⵄⵓⵏ ⵉ ⵢⵓⵙⵓⴼ: “ⵉⵏⵉ ⵉ ⴰⵢⵜⵎⴰⵛ: ‘ⴳⴳⴻⵎ ⴰⵢⴰ: ⵙⴰⵔⴱⵓⵎ ⵣⵡⴰⵢⴻⵍ ⵏⵡⴻⵎ ⵓⵛⴰ ⴳⴻⵄⵄⴷⴻⵎ, ⵔⵓⵃⴻⵎ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","ⴽⵙⵉⵎ-ⴷⴷ ⴱⴰⴱⴰⵜⵡⴻⵎ ⴷ ⵔⴰⴵ ⵏⵡⴻⵎ, ⵜⵓⵙⵉⵎ-ⴷⴷ ⵖⴰⵔⵉ. ⴰⵇⴰ ⴰⴷ ⴰⵡⴻⵎ ⵡⵛⴻⵖ ⵍⴻⵎⵍⵉⵃ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⵓⵛⴰ ⴰⴷ ⵜⴻⵛⵛⴻⵎ ⵣⵉ ⵎⵉⵏ ⵉⵛⵏⴰⵏ ⵏ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","ⴰⵇⴰ ⵜⵜⵡⴰⴳⴳⴻⵏⵜ ⵜⵉⵡⴻⵚⵚⴰ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏⵏⴻⴽ. ⴳⴳⴻⵎ ⴰⵢⴰ: ⴽⵙⵉⵎ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⵉⴽⴰⵔⵔⵓⵜⴻⵏ ⵉ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵡⴻⵎ ⵓ ⵉ ⵜⴻⵎⵖⴰⵔⵉⵏ ⵏⵡⴻⵎ, ⴰⵡⵢⴻⵎ-ⴷⴷ ⵣⵣⴰⵢⴻⵙ ⴱⴰⴱⴰⵜⵡⴻⵎ ⵓⵛⴰ ⴰⵙⴻⵎ-ⴷⴷ ⴷⴰ. ");
INSERT INTO rift_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","ⵡⴰⵔ ⵜⵜⴻⵊⵊⵉⵎ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵡⴻⵎ ⴰⴷ ⵙⵙⵃⵉⵙⵙⴼⴻⵏⵜ ⵉ ⵍⵇⴻⵛⵛ ⵏⵡⴻⵎ, ⵎⵉⵏⵣⵉ ⵍⴻⵎⵍⵉⵃ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⴰⴷ ⵢⵉⵍⵉ ⵏⵡⴻⵎ.’” ");
INSERT INTO rift_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⴳⴳⵉⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ⵉⵡⵛⴰ ⴰⵙⴻⵏ ⵢⵓⵙⵓⴼ ⵉⴽⴰⵔⵔⵓⵜⴻⵏ ⵅ ⵍⵓⵎⵓⵔ ⵏ ⴼⵉⵔⵄⵓⵏ ⵓⵛⴰ ⵉⵡⵛⴰ ⴰⵙⴻⵏ ⵄⴰⵡⴻⴷ ⵎⴰⵛⵛⴰ ⵉ ⵡⴻⴱⵔⵉⴷ. ");
INSERT INTO rift_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","ⵉⵡⵛⴰ ⵉ ⴽⵓⵍ ⵉⵊⵊ ⵣⵣⴰⵢⵙⴻⵏ ⵡⴻⵃⵃⴷⴻⵙ ⴰⵔⵔⵓⴹ ⵏ ⵊⴷⵉⴷ, ⵎⴰⵛⴰ ⵉ ⴱⵉⵏⵢⴰⵎⵉⵏ ⵉⵡⵛⴰ ⴰⵙ ⵜⴻⵍⵜ-ⵎⵢⴰ ⵏ ⵓⵇⵉⵢⵢⴰⵜ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⴷ ⵅⴻⵎⵙⴰ ⵏ ⵡⴰⵔⵔⵓⴹ ⴷ ⵊⴷⵉⴷ. ");
INSERT INTO rift_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","ⵓ ⴰⵎⵎⵓ ⵄⴰⵡⴻⴷ ⵉⵙⵙⴻⴽⴽ ⵉ ⴱⴰⴱⴰⵙ ⵄⴻⵛⵔⴰ ⵏ ⵢⴻⵖⵢⴰⵍ ⵛⵛⵓⵔⴻⵏ ⵙ ⵎⵉⵏ ⵉⴼⴰⵔⵣⴻⵏ ⵏ ⵎⵉⵚⵔⴰ ⵓ ⵄⴻⵛⵔⴰ ⵏ ⵜⴻⵖⵢⴰⵍ ⵛⵛⵓⵔⴻⵏⵜ ⵙ ⵉⵎⴻⵏⴷⵉ ⴷ ⵡⴻⵖⵔⵓⵎ ⴷ ⵎⴰⵛⵛⴰ ⵉ ⴱⴰⴱⴰⵙ ⵓⵎⵉ ⵖⴰ ⵢⵉⵍⵉ ⵏⴻⵜⵜⴰ ⴷⴻⴳ ⵡⴻⴱⵔⵉⴷ. ");
INSERT INTO rift_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","ⵉⵇⴻⴱⴱⴻⴹ ⴰⵢⵜⵎⴰⵙ ⵓⵛⴰ ⵔⵓⵃⴻⵏ. ⵉⵏⵏⴰ ⴰⵙⴻⵏ ⵏⴻⵜⵜⴰ: “ⵡⴰⵔ ⵜⵜⵎⴻⵏⵖⵉⵎ ⵛⴰ ⴷⴻⴳ ⵡⴻⴱⵔⵉⴷ.” ");
INSERT INTO rift_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","ⴳⴻⵄⵄⴷⴻⵏ ⵣⵉ ⵎⵉⵚⵔⴰ, ⵉⵡⴹⴻⵏ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ ⵖⴰⵔ ⵢⴰⵄⵇⵓⴱ, ⴱⴰⴱⴰⵜⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","ⵡⵛⵉⵏ ⴰⵙ ⵍⴻⵅⴱⴰⵔ, ⵏⵏⴰⵏ: “ⵢⵓⵙⵓⴼ ⴰⵇⴰ ⵉⴷⴷⴰⵔ ⵄⴰⴷ, ⵡⴰⵀ, ⴰⵇⴰ-ⵜ ⴷ ⵍⵃⴰⴽⴻⵎ ⵏ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ!” ⵅⴻⵏⵏⵉ ⵉⵙⵅⴻⴼ ⵡⵓⵍ ⵏⵏⴻⵙ, ⵎⵉⵏⵣⵉ ⵡⴰⵔ ⵜⴻⵏ ⵢⵓⵎⵉⵏ ⵛⴰ. ");
INSERT INTO rift_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","ⵓⵎⵉ ⴷ ⴰⵙ ⵄⴰⵡⴷⴻⵏ ⵎⴰⵔⵔⴰ ⴰⵡⴰⵍⴻⵏ ⵏ ⵢⵓⵙⵓⴼ ⵉⵏⵏⵉ ⴷ ⴰⵙⴻⵏ ⵉⵏⵏⴰ ⵓ ⵍⴰⵎⵉ ⵉⵥⵔⴰ ⵉⴽⴰⵔⵔⵓⵜⴻⵏ ⵉⵏⵏⵉ ⴷⴷ-ⵉⵙⵙⴻⴽⴽ ⵢⵓⵙⵓⴼ ⵃⵉⵎⴰ ⴰⴷ ⵜ ⴰⵡⵢⴻⵏ, ⵉⵄⵇⴻⴱ-ⴷⴷ ⴱⵓⵃⴱⴻⵍ ⵏ ⴱⴰⴱⴰⵜⵙⴻⵏ ⵢⴰⵄⵇⵓⴱ. ");
INSERT INTO rift_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","ⵓⵛⴰ ⵉⵏⵏⴰ ⵉⵙⵔⴰⵉⵍ: “ⴽⴼⴰ! ⵢⵓⵙⵓⴼ ⵎⵎⵉ ⴰⵇⴰ ⵉⴷⴷⴰⵔ! ⴰⴷ ⵔⴰⵃⴻⵖ ⵓⵛⴰ ⴰⴷ ⵜ ⵥⴰⵔⵖ ⵇⴱⴻⵍ ⵉ ⵖⴰ ⵎⵎⵜⴻⵖ!” ");
INSERT INTO rift_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","ⵉⴼⵙⵉ ⵉⵙⵔⴰⵉⵍ ⵉⵇⵉⴹⴰⵏ ⵏⵏⴻⵙ ⵙⵙⴻⵏⵏⵉ, ⵢⵓⵢⵓⵔ ⵙ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵖⴰⵔⴻⵙ ⵓⵛⴰ ⵢⵉⵡⴻⴹ ⵖⴰⵔ ⴱⵉ’ⵔ-ⵙⴻⴱⵄⴰ. ⵉⵇⴻⴷⴷⴻⵎ ⴷⵉⵏ ⵜⵉⵖⴰⵔⵚⴰ ⵉ ⴰⵔⴻⴱⴱⵉ ⵏ ⴱⴰⴱⴰⵙ ⵉⵙⵃⴰⵇ. ");
INSERT INTO rift_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","ⵓⵛⴰ ⵉⵙⵙⵉⵡⴻⵍ ⴰⵔⴻⴱⴱⵉ ⴰⴽ-ⴷ ⵉⵙⵔⴰⵉⵍ ⴷⵉ ⵉⵡⴻⵃⵃⴰⵏ ⴷⵉ ⴵⵉⵍⴻⵜ, ⵉⵏⵏⴰ: “ⵢⴰⵄⵇⵓⴱ, ⵢⴰⵄⵇⵓⴱ!” ⵓⵛⴰ ⵉⵏⵏⴰ ⵏⴻⵜⵜⴰ: “ⴰⵇⴰ ⴰⵢⵉ ⴷⴰ!” ");
INSERT INTO rift_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ: “ⵏⴻⵛⵛ ⴷ ⴰⵔⴻⴱⴱⵉ, ⴰⵔⴻⴱⴱⵉ ⵏ ⴱⴰⴱⴰⵛ. ⵡⴰⵔ ⵜⵜⴻⴳⴳⵯⴻⴷ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⴻⵀⵡⵉⴷ ⵖⴰⵔ ⵎⵉⵚⵔⴰ, ⵎⵉⵏⵣⵉ ⵏⴻⵛⵛ ⴰⴷ ⵛⴻⴽ ⴳⴳⴻⵖ ⴷⵉⵏ ⴷ ⵉⵊⵊ ⵏ ⵍⴳⴻⵏⵙ ⵉⵎⵖⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","ⴰⴷ ⴽⵉⴷⴻⴽ ⵀⵡⵉⵖ ⵖⴰⵔ ⵎⵉⵚⵔⴰ ⵓⵛⴰ ⵏⴻⵛⵛ ⴰⴷ ⵛⴻⴽ ⵙⵙⴳⴻⵄⵄⴷⴻⵖ ⵄⴰⵡⴻⴷ ⵓ ⵢⵓⵙⵓⴼ ⴰⴷ ⵅⴰⴽ ⵉⵙⵙⴰⵔⵙ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵏⴻⵙ ⵅ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵛ.” ");
INSERT INTO rift_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","ⵉⴽⴽⴰⵔ ⵢⴰⵄⵇⵓⴱ, ⵉⴼⴼⴻⵖ ⵣⵉ ⴱⵉ’ⵔ-ⵙⴻⴱⵄⴰ. ⴽⵙⵉⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴱⴰⴱⴰⵜⵙⴻⵏ ⵢⴰⵄⵇⵓⴱ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵙⴻⵏ ⴷ ⵜⴻⵎⵖⴰⵔⵉⵏ ⵏⵙⴻⵏ ⴷⴻⴳ ⵉⴽⴰⵔⵔⵓⵜⴻⵏ ⵏⵏⵉ ⴷⴷ-ⵉⵙⵙⴻⴽⴽ ⴼⵉⵔⵄⵓⵏ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜ ⵢⴰⵡⵉ. ");
INSERT INTO rift_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","ⴽⵙⵉⵏ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏⵙⴻⵏ ⴷ ⵡⴰⴳⵍⴰ ⵉ ⵢⴰⵔⴻⴱⵃⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ ⵓⵛⴰ ⵉⵡⴹⴻⵏ ⵖⴰⵔ ⵎⵉⵚⵔⴰ, ⵢⴰⵄⵇⵓⴱ ⴷ ⵎⴰⵔⵔⴰ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ ⴰⴽⵉⴷⴻⵙ: ");
INSERT INTO rift_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ ⵊⵎⵉⵄ ⴰⴽⵉⴷⴻⵙ, ⵓⵍⴰ ⴷ ⵢⴻⵙⵙⵉⵙ ⴷ ⵢⴻⵙⵙⵉⵜⵙⴻⵏ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ, ⴰⵇⴰ ⵢⵉⵡⵉ ⴰⴽⵉⴷⴻⵙ ⵎⴰⵔⵔⴰ ⵜⴰⵔⵡⴰ ⵏⵏⴻⵙ ⵖⴰⵔ ⵎⵉⵚⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","ⵉⵏⴰ ⴷ ⵉⵙⵎⴰⵡⴻⵏ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵉⵏⵏⵉ ⵢⵓⴷⴼⴻⵏ ⵖⴰⵔ ⵎⵉⵚⵔⴰ: ⵢⴰⵄⵇⵓⴱ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ. ⴰⵎⴻⵏⵣⵓ ⵏ ⵢⴰⵄⵇⵓⴱ: ⵔⵓⴱⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","ⵜⴰⵔⵡⴰ ⵏ ⵔⵓⴱⵉⵏ: ⵃⴰⵏⵓⴽ ⴷ ⴼⴰⵍⵍⵓ ⴷ ⵃⴰⵚⵔⵓⵏ ⴷ ⴽⴰⵔⵎⵉ. ");
INSERT INTO rift_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","ⵜⴰⵔⵡⴰ ⵏ ⵛⵉⵎⵄⵓⵏ: ⵢⴰⵎⵓⵢⵉⵍ ⴷ ⵢⴰⵎⵉⵏ ⴷ ⵓⵀⴰⴷ ⴷ ⵢⴰⴽⵉⵏ ⴷ ⵚⵓⵃⴰⵔ ⴷ ⵛⴰⵡⵓⵍ, ⵎⵎⵉⵙ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⵜⴰⴽⴻⵏⵄⴰⵏⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","ⵜⴰⵔⵡⴰ ⵏ ⵍⴰⵡⵉ: ⵊⴰⵔⵛⵓⵏ ⴷ ⵇⴰⵀⴰⵜ ⴷ ⵎⴰⵔⴰⵔⵉ. ");
INSERT INTO rift_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","ⵜⴰⵔⵡⴰ ⵏ ⵢⴰⵀⵓⴷⴰ: ⵄⵉⵔ ⴷ ⵓⵏⴰⵏ ⴷ ⵛⴰⵢⵍⴰ ⴷ ⴼⴰⵔⵉⵚ ⴷ ⵣⴰⵔⴰⵃ. ⵎⴰⵛⴰ ⵄⵉⵔ ⴷ ⵓⵏⴰⵏ ⵎⵎⵓⵜⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ. ⵜⴰⵔⵡⴰ ⵏ ⴼⴰⵔⵉⵚ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⵃⴰⵚⵔⵓⵏ ⴷ ⵃⴰⵎⵓⵍ. ");
INSERT INTO rift_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","ⵜⴰⵔⵡⴰ ⵏ ⵉⵙⵙⴰⴽⴰⵔ: ⵜⵓⵍⴰⵄ ⴷ ⴼⴰⵡⵡⴰ ⴷ ⵢⵓⴱ ⴷ ⵛⵉⵎⵔⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","ⵜⴰⵔⵡⴰ ⵏ ⵣⴰⴱⵓⵍⵓⵏ: ⵙⴰⵔⴰⴷ ⴷ ⵉⵍⵓⵏ ⴷ ⵢⴰⵃⵍⵉⵢⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵍⵉⵢⴰ ⵉⵏⵏⵉ ⴷ ⴰⵙ ⴷⴷ-ⵜⵓⵔⵓⵡ ⵉ ⵢⴰⵄⵇⵓⴱ ⴷⵉ ⴼⴰⴷⴰⵏ-ⴰⵔⴰⵎ, ⵓⵛⴰ ⵄⴰⵡⴻⴷ ⵢⴻⴵⵉⵙ ⴷⵉⵏⴰ. ⵎⴰⵔⵔⴰ ⵍⴻⵄⵎⵓⵔ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ ⴷ ⵜⵃⴻⵏⵊⵉⵔⵉⵏ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⵜⵍⴰⵜⴰ ⵓ-ⵜⵍⴰⵜⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","ⵜⴰⵔⵡⴰ ⵏ ⵊⴰⴷ: ⵚⵉⴼⵢⵓⵏ ⴷ ⵃⴰⵊⵊⵉ ⴷ ⵛⵓⵏⵉ ⴷ ⴰⵚⴱⵓⵏ ⴷ ⵄⵉⵔⵉ ⴷ ⴰⵔⵓⴷⵉ ⴷ ⴰⵔⵡⵉⵍⵉ. ");
INSERT INTO rift_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⴰⵛⵉⵔ: ⵢⵉⵎⵏⴰ ⴷ ⵢⵉⵙⵡⵉ ⴷ ⴱⴰⵔⵉⵄⴰ ⴷ ⵓⵍⵜⵎⴰⵜⵙⴻⵏ ⵛⴰⵔⴰⵃ. ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⴱⴰⵔⵉⵄⴰ: ⵃⴰⴱⵉⵔ ⴷ ⵎⴰⵍⴽⵉⵢⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵣⵉⵍⴱⴰ ⵜⴻⵏⵏⵉ ⵉⵡⵛⴰ ⵍⴰⴱⴰⵏ ⵉ ⵢⴻⴵⵉⵙ ⵍⵉⵢⴰ. ⵏⴻⵜⵜⴰⵜ ⵜⵓⵔⵓⵡ-ⴷⴷ ⵉⵏⴰ ⵉ ⵢⴰⵄⵇⵓⴱ, ⵉⵏⴰ ⵙⴻⵟⵟⴰⵛ ⴷ ⴰⵔⵔⵓⵃ. ");
INSERT INTO rift_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","ⵜⴰⵔⵡⴰ ⵏ ⵔⴰⵃⵉⵍ, ⵜⴰⵎⵖⴰⵔⵜ ⵏ ⵢⴰⵄⵇⵓⴱ: ⵢⵓⵙⵓⴼ ⴷ ⴱⵉⵏⵢⴰⵎⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","ⵜⵜⵡⴰⵅⴻⵍⵇⴻⵏ-ⴷⴷ ⵉ ⵢⵓⵙⵓⴼ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⵎⴰⵏⴰⵙⵙⴰ ⴷ ⵉⴼⵔⴰⵢⵉⵎ, ⵉⵏⵏⵉ ⴷ ⴰⵙ ⴷⴷ-ⵜⵓⵔⵓⵡ ⴰⵙⵏⴰⵜ, ⵢⴻⴵⵉⵙ ⵏ ⴼⵓⵟⵉ-ⴼⴰⵔⴰⵄ, ⴰⴽⴻⵀⵀⴰⵏ ⵏ ⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","ⵜⴰⵔⵡⴰ ⵏ ⴱⵉⵏⵢⴰⵎⵉⵏ: ⴱⵉⵍⴰⵄ ⴷ ⴱⴰⴽⵉⵔ ⴷ ⴰⵛⴱⵉⵍ ⴷ ⵊⵉⵔⴰ ⴷ ⵏⴰⵄⵎⴰⵏ ⴷ ⵉⵃⵉ ⴷ ⵔⵓⵛ ⴷ ⵎⵓⴼⴼⵉⵎ ⴷ ⵃⵓⴼⴼⵉⵎ ⴷ ⴰⵔⴷ. ");
INSERT INTO rift_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵔⴰⵃⵉⵍ, ⵉⵏⵏⵉ ⴷⴷ-ⵉⵜⵜⵡⴰⵡⴰⵔⵡⴻⵏ ⵉ ⵢⴰⵄⵇⵓⴱ, ⵎⴰⵔⵔⴰ ⴰⵔⴱⴻⵄⵟⴰⵛ ⴷ ⴰⵔⵔⵓⵃ. ");
INSERT INTO rift_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","ⵜⴰⵔⵡⴰ ⵏ ⴷⴰⵏ: ⵎⵖⵉⵔ ⵃⵓⵛⵉⵎ. ");
INSERT INTO rift_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","ⵜⴰⵔⵡⴰ ⵏ ⵏⴰⴼⵜⴰⵍⵉ: ⵢⴰⵃⴰⵚⵡⵉⵍ ⴷ ⵊⵓⵏⵉ ⴷ ⵢⵉⵚⵔⵓ ⴷ ⵛⵉⵍⵍⵉⵎ. ");
INSERT INTO rift_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⴱⵉⵍⵀⴰ, ⵜⴻⵏⵏⵉ ⵉ ⴷ ⴰⵙ ⵉⵡⵛⴰ ⵍⴰⴱⴰⵏ ⵉ ⵔⴰⵃⵉⵍ ⵢⴻⴵⵉⵙ. ⵜⵓⵔⵓⵡ ⴰⵙ-ⴷⴷ ⵉⵏⴰ ⵉ ⵢⴰⵄⵇⵓⴱ, ⵉⵏⴰ ⵎⴰⵔⵔⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⵙⴻⴱⵄⴰ ⴷ ⴰⵔⵔⵓⵃ. ");
INSERT INTO rift_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","ⵎⴰⵔⵔⴰ ⵍⴻⵄⵎⵓⵔ ⵏⵏⵉ ⴷⴷ-ⵢⵓⵙⵉⵏ ⵖⴰⵔ ⵎⵉⵚⵔⴰ ⴰⴽ-ⴷ ⵢⴰⵄⵇⵓⴱ, ⵉⵏⵏⵉ ⴷⴷ-ⵉⴼⴼⵖⴻⵏ ⵣⴻⴳ ⵓⵖⴻⵣⴷⵉⵙ ⵏⵏⴻⵙ, ⴱⵍⴰ ⵜⵉⵎⵖⴰⵔⵉⵏ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵢⴰⵄⵇⵓⴱ, ⵉⵏⴰ ⵎⴰⵔⵔⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⵙⴻⵜⵜⴰ ⵓ-ⵙⴻⵜⵜⵉⵏ ⵍⴻⵄⵎⵓⵔ. ");
INSERT INTO rift_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","ⵜⴰⵔⵡⴰ ⵏ ⵢⵓⵙⵓⴼ ⵉⵏⵏⵉ ⴷ ⴰⵙ ⴷⴷ-ⵉⵜⵜⵡⴰⵅⴻⵍⵇⴻⵏ ⴷⵉ ⵎⵉⵚⵔⴰ, ⴰⵇⴰ ⵜⵏⴰⵢⴻⵏ ⵏ ⵍⴻⵄⵎⵓⵔ. ⵎⴰⵔⵔⴰ ⵍⴻⵄⵎⵓⵔ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵢⴰⵄⵇⵓⴱ ⵏⵏⵉ ⴷⴷ-ⵢⵓⵙⵉⵏ ⵖⴰⵔ ⵎⵉⵚⵔⴰ, ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⵙⴻⴱⵄⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵉⵙⵙⴻⴽⴽ ⵢⴰⵀⵓⴷⴰ ⵣⵣⴰⵜⴻⵙ ⵖⴰⵔ ⵢⵓⵙⵓⴼ, ⵃⵉⵎⴰ ⴰⴷ ⵉⵙⵙⵛⴻⵏ ⴰⴱⵔⵉⴷ ⵣⵣⴰⵜⴻⵙ ⵖⴰⵔ ⵊⵓⵛⴰⵏ ⵓⵛⴰ ⵉⵡⴹⴻⵏ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵊⵓⵛⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","ⵉⵏⴷⴻⵀ ⵢⵓⵙⵓⴼ ⵄⴰⵡⴻⴷ ⴰⴽⴰⵔⵔⵓ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⴳⴻⵄⵄⴻⴷ ⵖⴰⵔ ⵊⵓⵛⴰⵏ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⵍⵇⴰ ⵉⵙⵔⴰⵉⵍ, ⴱⴰⴱⴰⵙ. ⵓⵎⵉ ⴷ ⴰⵙ ⵉⵎⵎⴻⵍ ⵉⵅⴻⴼ ⵏⵏⴻⵙ, ⵉⵏⴳⴻⵣ ⴰⵙ ⵅ ⵢⵉⵔⵉ, ⵉⵇⵇⵉⵎ ⵉⵜⵜⵔⵓ ⵅ ⵢⵉⵔⵉ ⵏⵏⴻⵙ ⴰⵟⵟⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","ⵉⵏⵏⴰ ⵉⵙⵔⴰⵉⵍ ⵉ ⵢⵓⵙⵓⴼ: “ⵍⴻⵅⵅⵓ ⵣⴻⵎⵎⴰⵔⴻⵖ ⵏⴻⵛⵛ ⴰⴷ ⵎⵎⵜⴻⵖ, ⵍⴻⵅⵅⵓ ⵓⵎⵉ ⵥⵔⵉⵖ ⴰⵖⴻⵎⴱⵓⴱ ⵏⵏⴻⵛ, ⵣⴻⵄⵎⴰ ⴰⵇⴰ ⵄⴰⴷ ⵜⴻⴷⴷⴰⵔⴻⴷ!” ");
INSERT INTO rift_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵢⵓⵙⵓⴼ ⵉ ⵢⴰⵢⵜⵎⴰⵙ ⵓ ⵉ ⴰⵢⵜⴱⴰⴱ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⴱⴰⴱⴰⵙ: “ⴰⴷ ⴳⴻⵄⵄⴷⴻⵖ ⴰⴷ ⵅⴻⴱⴱⴰⵔⴻⵖ ⴼⵉⵔⵄⵓⵏ, ⴰⴷ ⵉⵏⵉⵖ: ‘ⴰⵢⵜⵎⴰ ⴷ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⴱⴰⴱⴰ, ⵉⵏⵏⵉ ⵉⴵⴰⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ, ⴰⵇⴰ ⵓⵙⵉⵏ-ⴷⴷ ⵖⴰⵔⵉ. ");
INSERT INTO rift_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","ⵉⵔⵢⴰⵣⴻⵏ ⴷ ⵉⵎⴻⴽⵙⴰⵡⴻⵏ ⵏ ⵡⵓⴵⵉ, ⵜⵓⵖⴰ ⵛⴻⵖⵍⴻⵏ ⵉⵅⴻⴼ ⵏⵙⴻⵏ ⴰⴽ ⴷ ⵍⴻⴱⵀⴰⵢⴻⵎ. ⴰⵇⴰ ⵉⵡⵢⴻⵏ-ⴷⴷ ⵓⴵⵉ ⵏⵙⴻⵏ ⴷ ⵉⴼⵓⵏⴰⵙⴻⵏ ⴷ ⵜⴼⵓⵏⴰⵙⵉⵏ ⵏⵙⴻⵏ ⴷ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵖⴰⵔⵙⴻⵏ.’ ");
INSERT INTO rift_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","ⵎⴰⵍⴰ ⵉⵎⵙⴰⵔ ⴰⴷ ⴰⵡⴻⵎ ⴷⴷ-ⵉⵍⴰⵖⴰ ⴼⵉⵔⵄⵓⵏ ⵓⵛⴰ ⴰⴷ ⴰⵡⴻⵎ ⵢⵉⵏⵉ: ‘ⵎⵉⵏ ⵜⴻⵄⵏⴰ ⵍⵅⴻⴷⵎⴻⵜ ⵉ ⵜᵉⵜⵜⴻⴳⴳⴻⵎ?’, ");
INSERT INTO rift_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ⴰⴷ ⵜⵉⵏⵉⵎ: ‘ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵛ ⴷ ⵉⵔⵢⴰⵣⴻⵏ ⵉⵏⵏⵉ ⵉⵛⴻⵖⵍⴻⵏ ⴰⴽ-ⴷ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵣⵉ ⵜⴻⵎⵥⵉ ⵏⵙⴻⵏ ⴰⵍ ⵉ ⵍⴻⵅⵅⵓ, ⵏⴻⵛⵛⵉⵏ ⵓⵍⴰ ⴷ ⵍⴻⵊⴷⵓⴷ ⵏⵏⴻⵖ!’, ⵃⵉⵎⴰ ⴰⴷ ⵖⴰⵔⵡⴻⵎ ⵢⵉⵍⵉ ⵜⵜⴻⵙⵔⵉⵃ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⵣⴻⴷⵖⴻⵎ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵊⵓⵛⴰⵏ, ⵎⵉⵏⵣⵉ ⴽⵓⵍ ⴰⵎⴻⴽⵙⴰⵡ ⵏ ⵡⵓⴵⵉ, ⴰⵇⴰ-ⵜ ⴷ ⵊⵊⵄⵉⴼⴻⵛⵜ ⵉ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","ⵍⴰⵎⵉ ⴷⴷ-ⵢⵓⵙⴰ ⵢⵓⵙⵓⴼ, ⵉⵅⴻⴱⴱⴰⵔ ⴼⵉⵔⵄⵓⵏ, ⵉⵏⵏⴰ ⴰⵙ: “ⴱⴰⴱⴰ ⴷ ⴰⵢⵜⵎⴰ ⴷ ⵡⵓⴵⵉ ⵏⵙⴻⵏ ⴷ ⵉⴼⵓⵏⴰⵙⴻⵏ ⴷ ⵜⴼⵓⵏⴰⵙⵉⵏ ⵏⵙⴻⵏ ⴷ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵖⴰⵔⵙⴻⵏ, ⴰⵇⴰ ⵓⵙⵉⵏ-ⴷⴷ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ. ⵅⵣⴰⵔ, ⴰⵇⴰ ⴰⵜⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵊⵓⵛⴰⵏ.” ");
INSERT INTO rift_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","ⵓⵛⴰ ⵣⵉ ⵊⴰⵔ ⵎⴰⵔⵔⴰ ⴰⵢⵜⵎⴰⵙ ⵢⵉⵡⵉ ⵅⴻⵎⵙⴰ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ, ⵉⵇⴻⴷⴷⴻⵎ ⴰⵙ ⵜⴻⵏ ⵉ ⴼⵉⵔⵄⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⴼⵉⵔⵄⵓⵏ ⵉ ⵢⴰⵢⵜⵎⴰⵙ: “ⵎⵉⵏ ⵜⴻⵄⵏⴰ ⵍⵅⴻⴷⵎⴻⵜ ⵉ ⵜᵉⵜⵜⴻⴳⴳⴻⵎ?” ⵏⵉⵜⵏⵉ ⴰⵔⵔⵉⵏ-ⴷⴷ ⵅ ⴼⵉⵔⵄⵓⵏ: “ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵛ ⴷ ⵉⵎⴻⴽⵙⴰⵡⴻⵏ ⵏ ⵡⵓⴵⵉ, ⴰⵎ ⵏⴻⵛⵛⵉⵏ ⴰⵎ ⵍⴻⵊⴷⵓⴷ ⵏⵏⴻⵖ.” ");
INSERT INTO rift_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","ⵏⵏⴰⵏ ⵄⴰⵡⴻⴷ ⵉ ⴼⵉⵔⵄⵓⵏ: “ⵉ ⵜⵣⴻⴷⴷⵉⵖⵜ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ-ⴰ ⴰⵎ ⵉⴱⴰⵔⵔⴰⵏⵉⵢⵢⴻⵏ ⵉ ⴷⴷ-ⵏⵓⵙⴰ, ⵎⵉⵏⵣⵉ ⵡⴰⵔ ⵢⴻⴵⵉ ⵡⴻⴼⵙⵓ ⵉ ⵡⵓⴵⵉ ⵏ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵛ, ⵎⵉⵏⵣⵉ ⵍⴰⵥ ⵉⵇⵙⴻⵃ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ. ⵅⴻⵏⵏⵉ ⵍⴻⵅⵅⵓ, ⵏⴻⵜⵜⵣⴰⵡⴻⴳ ⵉ ⵛⴻⴽ, ⴻⵊⵊ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵛ ⴰⴷ ⵣⴻⴷⵖⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵊⵓⵛⴰⵏ!” ");
INSERT INTO rift_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","ⵓⵛⴰ ⵉⵙⵙⵉⵡⴻⵍ ⴼⵉⵔⵄⵓⵏ ⴰⴽ-ⴷ ⵢⵓⵙⵓⴼ, ⵉⵏⵏⴰ: “ⴱⴰⴱⴰⵛ ⴷ ⴰⵢⵜⵎⴰⵛ ⵓⵙⵉⵏ-ⴷⴷ ⵖⴰⵔⴻⴽ. ");
INSERT INTO rift_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⴰⵇⴰ-ⵜⵜ ⵏⵏⴻⵛ ⵎⴰⵔⵔⴰ. ⴻⵊⵊ ⴱⴰⴱⴰⵛ ⴷ ⴰⵢⵜⵎⴰⵛ ⴰⴷ ⵣⴻⴷⵖⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵉⵚⴻⴱⵃⴻⵏ, ⴻⵊⵊ ⵉ-ⵜⴻⵏ ⴰⴷ ⵣⴻⴷⵖⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵊⵓⵛⴰⵏ ⵓⵛⴰ ⵎⴰⵍⴰ ⵜⵃⴻⴽⴽⴰⵔⴻⴷ ⴱⴻⵍⵍⵉ ⴰⵇⴰ ⵊⴰⵔ ⴰⵙⴻⵏ ⵉⵔⵢⴰⵣⴻⵏ ⵉⵡⴻⵏⴳⵉⵜⴻⵏ, ⴳⴳⴻⵎ ⵜⴻⵏ ⴷ ⵉⵎⴻⵃⴹⴰⵢⴻⵏ ⵅ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵉⵏⵓ.” ");
INSERT INTO rift_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","ⵓⵛⴰ ⵉⵏⴷⴻⵀ ⵢⵓⵙⵓⴼ ⴱⴰⴱⴰⵙ, ⵉⵇⴻⴷⴷⴻⵎ ⵉ-ⵜ ⵉ ⴼⵉⵔⵄⵓⵏ ⵓⵛⴰ ⵢⴰⵄⵇⵓⴱ ⵉⴱⴰⵔⴻⴽ ⴼⵉⵔⵄⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","ⵉⵏⵏⴰ ⴼⵉⵔⵄⵓⵏ ⵉ ⵢⴰⵄⵇⵓⴱ: “ⵎⴻⵛⵀⴰⵍ ⵖⴰⵔⴻⴽ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ?” ");
INSERT INTO rift_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","ⵢⴰⵄⵇⵓⴱ ⵢⴰⵔⵔⴰ-ⴷⴷ ⵅ ⴼⵉⵔⵄⵓⵏ: “ⵎⵢⴰ ⵓ-ⵜⵍⴰⵜⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵉ ⴷⴷⴰⵔⴻⵖ ⴷ ⴰⴱⴰⵔⵔⴰⵏⵉ. ⵓⵙⵙⴰⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵏ ⵜⵓⴷⴰⵔⵜ ⵉⵏⵓ ⵢⵓⵇⵍⵉⵍⴻⵏ ⵓ ⵛⵛⵓⵔⴻⵏ ⵙ ⵍⵖⴰⵔ. ⵡⴰⵔ ⵉⵡⵉⴹⴻⵏ ⵛⴰ ⵡⵓⵙⵙⴰⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵏ ⵜⵓⴷⴰⵔⵜ ⵏ ⵍⴻⵊⴷⵓⴷ ⵉⵏⵓ ⴷⴻⴳ ⵡⵓⵙⵙⴰⵏ ⵏ ⵍⵖⵓⵔⴱⴰ ⵏⵙⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","ⵅⴻⵏⵏⵉ ⵢⴰⵄⵇⵓⴱ ⵉⴱⴰⵔⴽ ⴼⵉⵔⵄⵓⵏ ⵓⵛⴰ ⵉⴼⴼⴻⵖ ⵙⵙⴻⵏⵏⵉ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⴼⵉⵔⵄⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","ⵉⵙⵙⵛⴻⵏ ⵢⵓⵙⵓⴼ ⵜⴰⵣⴻⴷⴷⵉⵖⵜ ⵉ ⴱⴰⴱⴰⵙ ⴷ ⴰⵢⵜⵎⴰⵙ, ⵉⵡⵛⴰ ⴰⵙⴻⵏ ⵜⴰⵙⵖⴰⵔⵜ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ, ⵣⵉ ⵍⴻⵎⵍⵉⵃ ⵏ ⵜⴻⵎⵎⵓⵔⵜ, ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵔⴰⵄⴰⵎⵙⵉⵙ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜ ⵉⵡⴻⵚⵚⴰ ⴼⵉⵔⵄⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","ⵉⵄⴻⵡⵡⴻⵍ ⵢⵓⵙⵓⴼ ⴱⴰⴱⴰⵙ ⴷ ⴰⵢⵜⵎⴰⵙ ⴷ ⵎⴰⵔⵔⴰ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⴱⴰⴱⴰⵙ. ⵉⵄⴻⵡⵡⴻⵍ ⵓⵍⴰ ⴷ ⵎⴰⵛⵛⴰ ⵉ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","ⴰⵖⵔⵓⵎ ⵜⵓⵖⴰ ⵡⴰⵔ ⵉⴵⵉ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵎⴰⵔⵔⴰ, ⵎⵉⵏⵣⵉ ⵍⴰⵥ ⵜⵓⵖⴰ ⵉⵇⵙⴻⵃ ⴰⵟⵟⴰⵙ, ⴰⵍⴰⵎⵉ ⵜⵉⵡⴻⴹ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⴷ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ ⴼⴻⵏⵏⴰⵏⵜ ⵙ ⵍⴰⵥ. ");
INSERT INTO rift_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","ⵅⴻⵏⵏⵉ ⵉⵢⵔⵓ ⵢⵓⵙⵓⴼ ⵎⴰⵔⵔⴰ ⵏⵏⵓⵇⴰⵔⵜ ⵏⵏⵉ ⵉⵜⵜⵡⴰⴼⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⵓ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ ⴷⴻⴳ ⵓⴱⴻⴷⴷⴻⵍ ⵏ ⵉⵎⴻⵏⴷⵉ ⵉ ⵉⵙⵖⵉⵏ. ⵉⴳⴳⴰ ⵢⵓⵙⵓⴼ ⵏⵏⵓⵇⴰⵔⵜ ⵏⵏⵉ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⴼⵉⵔⵄⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","ⵓⵎⵉ ⵜⴻⵇⴹⴰ ⵏⵏⵓⵇⴰⵔⵜ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⴷ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ, ⵓⵙⵉⵏ-ⴷⴷ ⵎⴰⵔⵔⴰ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ ⵖⴰⵔ ⵢⵓⵙⵓⴼ ⵏⵏⴰⵏ: “ⴻⵡⵛ ⴰⵏⴻⵖ ⴰⵖⵔⵓⵎ, ⵎⴰⵖⴰⵔ ⵎⴰⵢⴻⵎⵎⵉ ⵖⴰ ⵏⴻⵎⵎⴻⵜ ⵣⵣⴰⵜⴻⴽ? ⵡⴰⵔ ⴷⵉⵏ ⵄⴰⴷ ⵛⴰ ⵏⵏⵓⵇⴰⵔⵜ.” ");
INSERT INTO rift_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","ⵢⵓⵙⵓⴼ ⵉⵏⵏⴰ: “ⵎⴰⵍⴰ ⵡⴰⵔ ⵖⴰⵔⵡⴻⵎ ⴱⵓ ⵏⵏⵓⵇⴰⵔⵜ ⵄⴰⴷ, ⵡⵛⴻⵎ ⵅⴻⵏⵏⵉ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏⵡⴻⵎ ⵓ ⵏⴻⵛⵛ ⴰⴷ ⴰⵡⴻⵎ ⵡⵛⴻⵖ ⵎⴰⵛⵛⴰ ⴷⴻⴳ ⵓⴱⴻⴷⴷⴻⵍ ⵏ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏⵡⴻⵎ.” ");
INSERT INTO rift_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","ⵏⵉⵜⵏⵉ ⵉⵡⵢⴻⵏ-ⴷⴷ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏⵙⴻⵏ ⵖⴰⵔ ⵢⵓⵙⵓⴼ ⵓⵛⴰ ⵉⵡⵛⴰ ⴰⵙⴻⵏ ⵢⵓⵙⵓⴼ ⴰⵖⵔⵓⵎ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏ ⵉⵢⵙⴰⵏ ⴷ ⵡⵓⴵⵉ ⴷ ⵉⴼⵓⵏⴰⵙⴻⵏ ⴷ ⵜⴼⵓⵏⴰⵙⵉⵏ ⴷ ⵢⴻⵖⵢⴰⵍ ⵏⵙⴻⵏ ⵓⵛⴰ ⵉⵙⵙⴻⵛⵛ ⵉ-ⵜⴻⵏ ⵙ ⵡⴻⵖⵔⵓⵎ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏ ⵎⴰⵔⵔⴰ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏⵙⴻⵏ ⴷⴻⴳ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵏⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","ⵓⵎⵉ ⵉⵄⴷⵓ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵏⵏⵉ, ⵓⵙⵉⵏ-ⴷⴷ ⵖⴰⵔⴻⵙ ⴷⴻⴳ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵡⵉⵙⵙ ⵜⵏⴰⵢⴻⵏ ⵓⵛⴰ ⵏⵏⴰⵏ ⴰⵙ: “ⵡⴰⵔ ⵏᵉⵜⵜⴻⴼⴼⴰⵔ ⵛⴰ ⵅ ⵙⵉⴷⵉ ⵉⵏⵓ ⴱⴻⵍⵍⵉ ⴰⵇⴰ ⵏⵏⵓⵇⴰⵔⵜ ⵏⵏⴻⵖ ⵜⴻⵇⴹⴰ ⵓⵛⴰ ⵍⴻⴱⵀⴰⵢⴻⵎ ⴰⵇⴰ ⴰⵜⴻⵏⵜ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏ ⵙⵉⴷⵉ ⵉⵏⵓ. ⵡⴰⵔ ⵉⵇⵇⵉⵎ ⵡⴰⵍⵓ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⵉⵏⵓ, ⵎⵖⵉⵔ ⴰⵔⵔⵉⵎⴻⵜ ⵏⵏⴻⵖ ⴷ ⵉⵢⵢⴰⵔⴻⵏ ⵏⵏⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","ⵎⴰⵢⴻⵎⵎⵉ ⵖⴰ ⵏⴻⵎⵎⴻⵜ ⵣⵣⴰⵜ ⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵛ, ⵓⵍⴰ ⴷ ⵏⴻⵛⵛⵉⵏ ⵓⵍⴰ ⴷ ⵉⵢⵢⴰⵔⴻⵏ ⵏⵏⴻⵖ? ⵙⴻⵖ ⴰⵏⴻⵖ, ⵜⴻⵙⵖⴻⴷ ⵜⴰⵎⵎⵓⵔⵜ ⵏⵏⴻⵖ ⵉ ⵡⴻⵖⵔⵓⵎ ⵓⵛⴰ ⵏⴻⵛⵛⵉⵏ ⴷ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⴻⵖ ⴰⴷ ⵏⵉⵍⵉ ⴷ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏ ⴼⵉⵔⵄⵓⵏ. ⴻⵡⵛ ⴰⵏⴻⵖ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵃⵉⵎⴰ ⴰⴷ ⵏⴻⴷⴷⴰⵔ ⵡⴰⵔ ⵏⴻⵜⵜⵎⴻⵜⵜⵉ ⵛⴰ ⵓⵛⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵡⴰⵔ ⵜᵉⴷⴷⵉⴽⴽⵡⵉⵍ ⴷ ⴰⵎⴻⵙⵙⵓⵛⵉ!” ");
INSERT INTO rift_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","ⵅⴻⵏⵏⵉ ⵉⵙⵖⴰ ⵢⵓⵙⵓⴼ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⵉ ⴼⵉⵔⵄⵓⵏ, ⵎⵉⵏⵣⵉ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ ⵣⵣⴻⵏⵣⴻⵏ ⵎⴰⵔⵔⴰ ⵉⵢⵢⴰⵔ ⵏⵙⴻⵏ, ⵎⵉⵏⵣⵉ ⵜⵓⵖⴰ ⵍⴰⵥ ⵉⵇⵙⴻⵃ ⵅⴰⵙⴻⵏ. ⵓ ⴰⵎⵎⵓ ⵉ ⵜⴻⴷⵡⴻⵍ ⵜⴻⵎⵎⵓⵔⵜ ⴷ ⴰⴳⵍⴰ ⵏ ⴼⵉⵔⵄⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","ⵓⵛⴰ ⵉⵙⵙⵎⵓⵟⵟⵉⵢ ⵍⴳⴻⵏⵙ ⵣⴻⴳ ⵓⵏⴻⴳⴳⴰⵔⵓ ⵏ ⵡⴻⵢⵎⵉⵔ ⴰⵍ ⴰⵏⴻⴳⴳⴰⵔⵓ ⵏⵏⴻⵖⵏⵉ ⵏ ⵡⴻⵢⵎⵉⵔ ⵏ ⵎⵉⵚⵔⴰ ⵖⴰⵔ ⵜⵏⴻⴷⴷⴰⵎ. ");
INSERT INTO rift_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","ⵎⵖⵉⵔ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵉⴽⴻⵀⵀⴰⵏⴻⵏ ⵡⴰⵔ ⵜⵜ ⵉⵙⵖⵉ ⵛⴰ. ⴰⵇⴰ ⵉⴽⴻⵀⵀⴰⵏⴻⵏ ⵖⴰⵔⵙⴻⵏ ⵉⵛⵜ ⵏ ⵍⵎⵓⵏⴻⵜ ⵣⵉ ⴼⵉⵔⵄⵓⵏ, ⵏⵉⵜⵏⵉ ⵜⵜᵉⵜⵜⴻⵏ ⵜⴰⵙⵖⴰⵔⵜ ⵏⵙⴻⵏ, ⵜⴻⵏⵏⵉ ⵉ ⴷ ⴰⵙⴻⵏ ⵉⵡⵛⴰ ⴼⵉⵔⵄⵓⵏ. ⵅ ⵓⵢⴰ ⵡⴰⵔ ⵣⵣⴻⵏⵣⴻⵏ ⵛⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵢⵓⵙⵓⴼ ⵉ ⵍⴳⴻⵏⵙ: “ⵅⵣⴰⵔ, ⴰⵙⵙ-ⴰ ⵏⴻⵛⵛ ⵙⵖⵉⵖ ⴽⴻⵏⵏⵉⵡ ⵓⵍⴰ ⴷ ⵜⴰⵎⵎⵓⵔⵜ ⵏⵡⴻⵎ ⵉ ⴼⵉⵔⵄⵓⵏ. ⵅⵣⴰⵔⴻⵎ, ⴰⵇⴰ ⴷⴰ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵡⴻⵎ. ⵣⴰⵔⵄⴻⵎ ⵣⵣⴰⵢⴻⵙ ⵜⴰⵎⵎⵓⵔⵜ! ");
INSERT INTO rift_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","ⵣⵉ ⵍⵖⵉⴵⴻⵜ ⴰⴷ ⵜⴻⵡⵛⴻⵎ ⵜⴰⵙⵖⴰⵔⵜ ⵜⴻⵅⵎⵓⵙⴻⵛⵜ ⵉ ⴼⵉⵔⵄⵓⵏ ⵓ ⴰⵔⴻⴱⵄⴰ ⵏ ⵜⵙⴻⵇⵇⴰⵔ ⵉ ⵉⵇⵇⵉⵎⴻⵏ ⴰⴷ ⵉⵍⵉⵏⵜ ⵉ ⵢⵉⵅⴻⴼ ⵏⵡⴻⵎ ⴷ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵉ ⵢⴻⵢⵢⴰⵔ ⵓⵛⴰ ⴰⴷ ⵉⵍⵉⵏⵜ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵣⵣⴰⵢⵙⴻⵏⵜ ⵜⴻⵛⵛⴻⵎ ⴽⴻⵏⵏⵉⵡ ⴰⴽ-ⴷ ⴰⵢⵜⴱⴰⴱ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵡⴻⵎ ⵓ ⵄⴰⵡⴻⴷ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵣⵣⴰⵢⵙⴻⵏⵜ ⵛⵛⴻⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⴻⵏ ⵏⵡⴻⵎ.” ");
INSERT INTO rift_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","ⵏⵉⵜⵏⵉ ⵏⵏⴰⵏ: “ⵛⴻⴽ ⵜⴻⵃⴹⵉⴷ ⵜⵓⴷⴰⵔⵜ ⵏⵏⴻⵖ. ⴻⵊⵊ ⴰⵏⴻⵖ ⴰⴷ ⵏⴰⴼ ⴰⵔⴹⴰ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵙⵉⴷⵉ ⵉⵏⵓ ⵓⵛⴰ ⵏⴻⵛⵛⵉⵏ ⴰⴷ ⵏⵉⵍⵉ ⴷ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵉ ⴼⵉⵔⵄⵓⵏ.” ");
INSERT INTO rift_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","ⵉⴳⴳⴰ ⵢⵓⵙⵓⴼ ⵎⴰⵏ ⴰⵢⴰ ⴷ ⵜⴰⵡⵚⴻⵢⵢⴻⵜ ⵉ ⴷⵉⵏ ⵉⴵⴰⵏ ⴰⵍ ⴰⵙⵙ-ⴰ, ⴱⴻⵍⵍⵉ ⵉⵛⵜ ⵏ ⵜⴻⵙⵖⴰⵔⵜ ⵏ ⵜⴻⵅⵎⵓⵙⴻⵛⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⴰⴷ ⵜⵉⵍⵉ ⵉ ⴼⵉⵔⵄⵓⵏ. ⵎⵖⵉⵔ ⵉⵢⵢⴰⵔⴻⵏ ⵏ ⵉⴽⴻⵀⵀⴰⵏⴻⵏ ⵇⵇⵉⵎⴻⵏ ⴷ ⴰⴳⵍⴰ ⵏⵙⴻⵏ, ⵡⴰⵔ ⴷⴷⵉⴽⴽⵡⵉⵍⴻⵏ ⵛⴰ ⴷ ⴰⴳⵍⴰ ⵏ ⴼⵉⵔⵄⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","ⴰⵎⵎⵓ ⵉ ⵉⵣⴷⴻⵖ ⵉⵙⵔⴰⵉⵍ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ, ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵊⵓⵛⴰⵏ, ⵎⴻⵍⵍⴽⴻⵏ ⴷⴰⵢⴻⵙ ⵓⵛⴰ ⵡⵛⵉⵏ ⵍⵖⵉⴵⴻⵜ ⵓⵛⴰ ⴽⵜⴰⵔⴻⵏ ⵙ ⵢⵉⵊⵊ ⵏ ⵛⵛⴽⴻⵍ ⵉⵎⵖⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","ⵉⴷⴷⴰⵔ ⵢⴰⵄⵇⵓⴱ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⵙⴱⴻⵄⵟⴰⵛ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵓⵛⴰ ⵜⵓⵖⴰ ⵓⵙⵙⴰⵏ ⵏ ⵢⴰⵄⵇⵓⴱ, ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵏ ⵜⵓⴷⴰⵔⵜ ⵏⵏⴻⵙ, ⵎⵢⴰ ⵓ-ⵙⴻⴱⵄⴰ ⵓ-ⵔⴻⴱⵄⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","ⵓⵎⵉ ⴷⴷ-ⵉⵡⴹⴻⵏ ⵡⵓⵙⵙⴰⵏ ⵉ ⵉⵙⵔⴰⵉⵍ ⴰⴷ ⵉⵎⵎⴻⵜ, ⵉⵍⴰⵖⴰ-ⴷⴷ ⵅ ⵢⵓⵙⵓⴼ ⵎⵎⵉⵙ, ⵉⵏⵏⴰ ⴰⵙ: “ⵎⴰⵍⴰ ⵓⴼⵉⵖ ⴰⵔⴹⴰ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵛ, ⵜⵜⵣⴰⵡⴰⴳⴻⵖ ⵛⴻⴽ, ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⴰⴼⵓⵙ ⵏⵏⴻⵛ ⵙⴰⴷⵓ ⵜⵎⴻⵚⵚⴰⴹⵜ ⵉⵏⵓ ⵓⵛⴰ ⴻⴳⴳ ⴰⴽⵉⴷⵉ ⵙ ⵜⵎⴻⵅⵙⵉⵡⵜ ⵉⵛⴻⵡⵡⴰⵔⴻⵏ ⴷ ⵍⴰⵎⴰⵏ ⵓ ⵡⴰⵔ ⴷ ⴰⵢⵉ ⵏⴻⵟⵟⴻⵍ ⵛⴰ ⴷⵉ ⵎⵉⵚⵔⴰ, ");
INSERT INTO rift_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","ⵎⴰⵛⴰ ⵅⵎⵉ ⵖⴰ ⴳⴳⴻⵖ ⴰⴷ ⴰⵔⴻⵢⵢⵃⴻⵖ ⵊⴰⵔ ⵍⴻⵊⴷⵓⴷ ⵉⵏⵓ, ⵅⴻⵏⵏⵉ ⴰⵡⵉ ⴰⵢⵉ ⵣⵉ ⵎⵉⵚⵔⴰ ⵓⵛⴰ ⵏⴹⴻⵍ ⴰⵢⵉ ⴷⴻⴳ ⵡⴻⵏⴹⴻⵍ ⵏⵙⴻⵏ. ⵢⴰⵔⵔⴰ-ⴷⴷ ⵅⴰⵙ: “ⵏⴻⵛⵛ ⴰⴷ ⴳⴳⴻⵖ ⵎⵉⵏ ⵜⴻⵏⵏⵉⴷ!” ");
INSERT INTO rift_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","ⵅⴰⵙ ⵓⵛⴰ ⵉⵏⵏⴰ ⴰⵙ: “ⵊⴰⴵ ⴰⵢⵉ!”, ⵓⵛⴰ ⵉⵊⵊⵓⴵ ⴰⵙ. ⵍⴻⵅⴷⴻⵏⵏⵉ ⵢⵓⴹⴰⵔ ⵉⵙⵔⴰⵉⵍ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏ ⵇⴰⵎⴰ. ");
INSERT INTO rift_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","ⴰⵡⴰⵔⵏⵉ ⵎⴰⵏ ⴰⵢⴰ ⵉⵎⵙⴰⵔ, ⵉⵜⵜⵡⴰⵏⵏⴰ ⵉ ⵢⵓⵙⵓⴼ: “ⵅⵣⴰⵔ, ⴰⵇⴰ ⴱⴰⴱⴰⵛ ⵉⵃⵍⴻⵛ!” ⵅⴻⵏⵏⵉ ⵉⴽⵙⵉ ⴰⴽⵉⴷⴻⵙ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ ⵎⴰⵏⴰⵙⵙⴰ ⴷ ⵉⴼⵔⴰⵢⵉⵎ. ");
INSERT INTO rift_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","ⵅⴻⴱⴱⴰⵔⴻⵏ ⵢⴰⵄⵇⵓⴱ, ⵏⵏⴰⵏ: “ⵅⵣⴰⵔ, ⴰⵇⴰ ⵎⵎⵉⵛ ⵢⵓⵙⵓⴼ ⴰⴷ ⵖⴰⵔⴻⴽ ⴷⴷ-ⵢⴰⵙ!” ⵅⴻⵏⵏⵉ ⵉⴳⴳⴰ ⵉⵙⵔⴰⵉⵍ ⵓⵍ ⴷⴻⴳ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⴽⴽⴰⵔ ⵉⵇⵇⵉⵎ ⵅ ⵇⴰⵎⴰ. ");
INSERT INTO rift_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵢⴰⵄⵇⵓⴱ ⵉ ⵢⵓⵙⵓⴼ: “ⴰⵔⴻⴱⴱⵉ, ⴰⵎⵣⴻⵎⵎⴰⵔ ⵅ ⴽⵓⵍⵛⵉ, ⴰⵇⴰ ⵉⴱⴰⵏ ⴰⵢⵉ-ⴷⴷ ⴷⵉ ⵍⵓⵣ, ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ, ⵓ ⴰⵇⴰ ⵏⴻⵜⵜⴰ ⵉⴱⴰⵔⴽ ⴰⵢⵉ. ");
INSERT INTO rift_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","ⵓ ⴰⵇⴰ ⵏⴻⵜⵜⴰ ⵉⵏⵏⴰ ⴰⵢⵉ: “ⵅⵣⴰⵔ, ⴰⴷ ⵛⴻⴽ ⴰⵔⵔⴻⵖ ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵍⵖⵉⴵⴻⵜ ⵓⵛⴰ ⴰⴷ ⵛⴻⴽ ⴽⴻⵜⵜⴰⵔⴻⵖ, ⴰⴷ ⵛⴻⴽ ⴳⴳⴻⵖ ⴷ ⵉⵊⵊ ⵏ ⵡⴻⴳⵔⴰⵡ ⵏ ⵍⴻⴳⵏⵓⵙ, ⴰⴷ ⴰⵛ ⵡⵛⴻⵖ ⵜⴰⵎⵎⵓⵔⵜ-ⴰ ⴷ ⴰⴳⵍⴰ ⵉ ⵍⴻⴱⴷⴰ ⵓ ⵉ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵛ ⴰⵡⴰⵔⵏⵉ ⴰⵛ. ");
INSERT INTO rift_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","ⵓⵛⴰ ⵍⴻⵅⵅⵓ, ⴰⵇⴰ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵛ, ⵉⴼⵔⴰⵢⵉⵎ ⴷ ⵎⴰⵏⴰⵙⵙⴰ, ⵉⵏⵏⵉ ⴷ ⴰⵛ ⴷⴷ-ⵉⵜⵜⵡⴰⵅⴻⵍⵇⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⵇⴱⴻⵍ ⵉ ⵖⴰⵔⴻⴽ ⴷⴷ-ⵓⵙⵉⵖ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ, ⴰⵇⴰ ⴰⵜⴻⵏ ⵉⵏⵓ, ⴰⵎ ⵔⵓⴱⵉⵏ ⴷ ⵛⵉⵎⵄⵓⵏ ⵉ ⵉⴵⴰⵏ ⵉⵏⵓ. ");
INSERT INTO rift_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","ⵎⴰⵛⴰ ⵉⵏⵏⵉ ⴷ ⴰⵛ ⴷⴷ-ⵉⵜⵜⵡⴰⵅⴻⵍⵇⴻⵏ ⴰⵡⴰⵔⵏⵉ ⴰⵙⴻⵏ, ⴰⴷ ⵉⵍⵉⵏ ⵏⵏⴻⵛ. ⴰⴷ ⵜⵜⵡⴰⵙⴻⵎⵎⴰⵏ ⵅ ⵢⵉⵙⴻⵎ ⵏ ⴰⵢⵜⵎⴰⵜⵙⴻⵏ ⴷⵉ ⵍⵡⴰⵔⵜ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","ⵓⵎⵉ ⴷⴷ-ⵓⵙⵉⵖ ⵣⵉ ⴼⴰⴷⴰⵏ-ⴰⵔⴰⵎ, ⵜⴻⵎⵎⵓⵜ ⵔⴰⵃⵉⵍ ⵣⵣⴰⵜⵉ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ ⴷⴻⴳ ⵡⴻⴱⵔⵉⴷ, ⵍⴰⵎⵉ ⵜⵓⵖⴰ ⵄⴰⴷ ⵡⴰⵔ ⵜⵉⴳⴳⵯⵉⵊ ⵅ ⵉⴼⵔⴰⵜⴰ. ⵏⴻⴹⵍⴻⵖ ⵜⵜ ⴷⵉⵏ ⴷⴻⴳ ⵡⴻⴱⵔⵉⴷ ⵖⴰⵔ ⵉⴼⵔⴰⵜⴰ!”, ⴰⵇⴰ-ⵜⵜ ⴷ ⴱⴰⵢⵜ-ⵍⴰⵃⵎ. ");
INSERT INTO rift_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","ⵉⵥⵔⴰ ⵉⵙⵔⴰⵉⵍ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵢⵓⵙⵓⴼ, ⵉⵏⵏⴰ: “ⵎⵉⵏ ⵄⵏⴰⵏ ⵉⵏⴰ?” ");
INSERT INTO rift_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","ⵢⴰⵔⵔⴰ-ⴷⴷ ⵢⵓⵙⵓⴼ ⵅ ⴱⴰⴱⴰⵙ: “ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵉⵏⵓ ⵉ ⴷ ⴰⵢⵉ ⵉⵡⵛⴰ ⴰⵔⴻⴱⴱⵉ ⴷⴰⵏⵉⵜⴰ.” ⵉⵏⵏⴰ ⴰⵙ: “ⵙⵇⴰⵔⵔⴱⴻⵎ ⵜⴻⵏ-ⴷⴷ ⵖⴰⵔⵉ ⵓⵛⴰ ⴰⴷ ⵜⴻⵏ ⴱⴰⵔⴽⴻⵖ!” ");
INSERT INTO rift_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","ⵜⵓⵖⴰ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵥⵖⴻⵏⵜ ⵙ ⵜⴻⵡⵙⴰⵔ, ⵡⴰⵔ ⵉⵇⵇⵉⵎ ⵉⵜⵜⵡⴰⵍⴰ. ⵉⵙⵙⵇⴰⵔⵔⴻⴱ ⴰⵙ ⵜⴻⵏ-ⴷⴷ, ⵅⴻⵏⵏⵉ ⵉⵙⵙⵓⴷⴻⵎ ⵉ-ⵜⴻⵏ, ⵉⴷⴰⵔⵔⴻⵄ ⴰⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","ⵉⵏⵏⴰ ⵉⵙⵔⴰⵉⵍ ⵉ ⵢⵓⵙⵓⴼ: “ⵡⴰⵔ ⴷ ⴰⵢⵉ ⵉⵜⵜⵖⵉⵍ ⴰⴷ ⵥⴰⵔⴻⵖ ⵄⴰⴷ ⵓⴷⴻⵎ ⵏⵏⴻⵛ. ⵅⵣⴰⵔ, ⴰⵔⴻⴱⴱⵉ ⵉⴳⴳⴰ ⴰⵢⵉ ⴰⴷ ⵥⴰⵔⴻⵖ ⵄⴰⴷ ⵜⴰⵔⵡⴰ ⵏⵏⴻⵛ!” ");
INSERT INTO rift_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","ⵅⴻⵏⵏⵉ ⵉⵙⵙⴹⴰⵔ ⵉ-ⵜⴻⵏ ⵢⵓⵙⵓⴼ ⵅ ⵉⴼⴰⴷⴷⴻⵏ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⴱⴻⵏⴷⴻⵇ ⵙ ⵡⵓⴷⴻⵎ ⵏⵏⴻⵙ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","ⵓⵛⴰ ⵉⴽⵙⵉ ⵉ-ⵜⴻⵏ ⵢⵓⵙⵓⴼ ⵙ ⵜⵏⴰⵢⴻⵏ ⵉⴷⵙⴻⵏ, ⵉⴼⵔⴰⵢⵉⵎ ⵙ ⵓⴼⵓⵙⵉ ⵏⵏⴻⵙ ⴰⵔⴻⵏⴷⴰⴷ ⵏ ⵓⵣⴻⵍⵎⴰⴹ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓ ⵎⴰⵏⴰⵙⵙⴰ ⵙ ⵓⵣⴻⵍⵎⴰⴹ ⵏⵏⴻⵙ ⴰⵔⴻⵏⴷⴰⴷ ⵏ ⵓⴼⵓⵙⵉ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵛⴰ ⵉⵙⵙⵇⴰⵔⵔⴻⴱ ⴰⵙ ⵜⴻⵏ-ⴷⴷ. ");
INSERT INTO rift_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","ⵉⵙⵙⵡⵉⵥⵥⴻⴹ ⵉⵙⵔⴰⵉⵍ ⵢⴻⴼⵓⵙ ⵏⵏⴻⵙ, ⵉⵙⵙⴰⵔⵙ ⵉ-ⵜ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏ ⵉⴼⵔⴰⵢⵉⵎ, ⵡⴰⵅⵅⴰ ⵜⵓⵖⴰ-ⵜ ⴷ ⴰⵎⴰⵥⵓⵥ, ⴷ ⴰⵣⴻⵍⵎⴰⴹ ⵏⵏⴻⵙ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏ ⵎⴰⵏⴰⵙⵙⴰ. ⵉⵙⵙⴰⵔⵙ ⴰⵎⵎⵓ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵏⴻⵙ ⵎⴰⵎⵎⴻⵛ ⵏⵏⴻⵖⵏⵉ ⵏⴻⵄⵎⴰⴷⴰ, ⵡⴰⵅⵅⴰ ⵎⴰⵏⴰⵙⵙⴰ ⵜⵓⵖⴰ-ⵜ ⴷ ⴰⵎⴻⵏⵣⵓ. ");
INSERT INTO rift_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","ⵉⵙⵔⴰⵉⵍ ⵉⴱⴰⵔⴽ ⵢⵓⵙⵓⴼ, ⵉⵏⵏⴰ: “ⴷ ⴰⵔⴻⴱⴱⵉ, ⵡⴻⵏⵏⵉ ⵓⵎⵉ ⵍⴻⵊⴷⵓⴷ ⵉⵏⵓ, ⵉⴱⵔⴰⵀⵉⵎ ⴷ ⵉⵙⵃⴰⵇ, ⵓⵢⵓⵔⴻⵏ ⵣⵣⴰⵜⴻⵙ, ⴰⵔⴻⴱⴱⵉ, ⵡⴻⵏⵏⵉ ⵉⴵⴰⵏ ⴷ ⴰⵎⴻⴽⵙⴰⵡ ⵉⵏⵓ ⵣⴻⴳ ⵡⴰⵎⵉ ⴵⵉⵖ ⴰⵍ ⴰⵙⵙ-ⴰ,    ");
INSERT INTO rift_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","ⵍⵎⴰⵍⴰⴽ ⵏⵏⵉ ⴷ ⴰⵢⵉ ⵉⴼⴷⵉⵏ ⵣⵉ ⵎⴰⵔⵔⴰ ⵜⵓⵄⴻⴼⴼⵏⴰ, ⵉⵍⵉ ⵏⴻⵜⵜⴰ ⴰⴷ ⵉⴱⴰⵔⴽ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ-ⴰ ⵓ ⵉⵍⵉ ⴰⴷ ⵉⵜⵜⵡⴰⵍⴰⵖⴰ ⵉⵙⴻⵎ ⵉⵏⵓ ⴷⴰⵢⵙⴻⵏ ⵓⵍⴰ ⴷ ⵉⵙⴻⵎ ⵏ ⵍⴻⵊⴷⵓⴷ ⵉⵏⵓ, ⵉⴱⵔⴰⵀⵉⵎ ⴷ ⵉⵙⵃⴰⵇ. ⵉⵍⵉ ⴰⴷ ⵎⵎⴰⵔⴻⵏⵢⴻⵏ ⴰⵍ ⵖⴰ ⴷⴻⵡⵍⴻⵏ ⴷ ⵉⵊⵊ ⵏ ⵓⴱⴰⵔⵔⵓ ⴰⵎ ⵉⵙⴻⵍⵎⴰⵏ ⴷⴻⴳ ⵡⴰⵎⴰⵏ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏ ⵜⴻⵎⵎⵓⵔⵜ!”    ");
INSERT INTO rift_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","ⵓⵎⵉ ⵉⵥⵔⴰ ⵢⵓⵙⵓⴼ, ⴱⴻⵍⵍⵉ ⴱⴰⴱⴰⵙ ⵉⴳⴳⴰ ⴰⴼⵓⵙ ⴰⴼⵓⵙⵉ ⵏⵏⴻⵙ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏ ⵉⴼⵔⴰⵢⵉⵎ, ⵜⵓⵖⴰ-ⵜⵜ ⴷ ⵉⵛⵜ ⵏ ⵍⴻⵄⵍⴰⵎⴻⵜ ⵡⴰⵔ ⵜⴻⵃⵃⵍⵉ ⵖⴰⵔⴻⵙ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⵟⵟⴻⴼ ⴰⴼⵓⵙ ⵏ ⴱⴰⴱⴰⵙ, ⵃⵉⵎⴰ ⴰⴷ ⵜ ⵉⴱⴻⴷⴷⴻⵍ ⵣⴻⴳ ⵓⵣⴻⴵⵉⴼ ⵏ ⵉⴼⵔⴰⵢⵉⵎ ⵖⴰⵔ ⵓⵣⴻⴵⵉⴼ ⵏ ⵎⴰⵏⴰⵙⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","ⵉⵏⵏⴰ ⵢⵓⵙⵓⴼ ⵉ ⴱⴰⴱⴰⵙ: “ⵡⴰⵔ ⵜⵜⴻⴳⴳ ⵛⴰ ⴰⵎⵎⵓ, ⴰ ⴱⴰⴱⴰ, ⵎⵉⵏⵣⵉ ⴷ ⵡⴰ ⴷ ⴰⵎⴻⵏⵣⵓ, ⴻⴳⴳ ⴰⴼⵓⵙⵉ ⵏⵏⴻⵛ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏⵏⴻⵙ.” ");
INSERT INTO rift_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","ⵎⴰⵛⴰ ⴱⴰⴱⴰⵙ ⵡⴰⵔ ⵉⵅⵙ ⵛⴰ, ⵉⵏⵏⴰ: “ⵙⵙⵏⴻⵖ, ⴰ ⵎⵎⵉ, ⵙⵙⵏⴻⵖ. ⵄⴰⵡⴻⴷ ⵏⴻⵜⵜⴰ ⴰⴷ ⵉⴷⵡⴻⵍ ⴷ ⵉⵊⵊ ⵏ ⵍⴳⴻⵏⵙ, ⴰⴷ ⵉⵎⵖⴰⵔ ⵄⴰⵡⴻⴷ, ⵎⴰⵛⴰ ⵓⵎⴰⵙ ⴰⵎⴰⵥⵓⵥ ⴰⴷ ⵢⵉⵍⵉ ⴽⵜⴰⵔ ⵣⵣⴰⵢⴻⵙ, ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵙ ⴰⴷ ⵜⴻⴷⵡⴻⵍ ⴷ ⵜⴰⵛⵓⵔⵔⴻⵜ ⵏ ⵍⴻⴳⵏⵓⵙ.” ");
INSERT INTO rift_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⵜⴻⵏ ⵉⴱⴰⵔⴻⴽ ⴷⴻⴳ ⵡⴰⵙⵙ ⵏⵏⵉ, ⵉⵏⵏⴰ: “ⴷⴰⵢⴻⴽ, ⴷⴻⴳ ⵢⵉⵙⴻⵎ ⵏⵏⴻⴽ, ⴰ ⵢⵓⵙⵓⴼ ⴰⴷ ⵉⴱⴰⵔⴻⴽ ⵍⴳⴻⵏⵙ ⵉⵙⵔⴰⵉⵍ, ⴰⴷ ⵉⵏⵉⵏ: ‘ⴰⴷ ⴽⴻⵏⵏⵉⵡ ⵢⴰⵔⵔ ⴰⵔⴻⴱⴱⵉ ⴰⵎ ⵉⴼⵔⴰⵢⵉⵎ ⴷ ⵎⴰⵏⴰⵙⵙⴰ!’” ⵓⵛⴰ ⵢⴰⵔⵔⴰ ⵉⴼⵔⴰⵢⵉⵎ ⴰⴷ ⵉⴱⴻⴷⴷ ⵣⵣⴰⵜ ⵉ ⵎⴰⵏⴰⵙⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","ⴰⵡⴰⵔⵏⵉ ⴰⵙ ⵉⵏⵏⴰ ⵉⵙⵔⴰⵉⵍ ⵉ ⵢⵓⵙⵓⴼ: “ⵅⵣⴰⵔ, ⴰⴷ ⵎⵎⵜⴻⵖ, ⵎⴰⵛⴰ ⴰⵔⴻⴱⴱⵉ ⴰⴷ ⵢⵉⵍⵉ ⴰⴽⵉⴷⵡⴻⵎ, ⴰⴷ ⴽⴻⵏⵏⵉⵡ ⵉⵙⵙⵎⵓⵟⵟⵉⵢ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵍⴻⵊⴷⵓⴷ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","ⴰⵇⴰ ⵡⵛⵉⵖ ⴰⵛ ⵉⵛⵜ ⵏ ⵜⴻⵙⵖⴰⵔⵜ ⵏ ⵉⴷⵓⵔⴰⵔ ⵅ ⵎⵉⵏ ⵡⵛⵉⵖ ⵉ ⵢⴰⵢⵜⵎⴰⵛ, ⵜⴻⵏⵏⵉ ⴽⵙⵉⵖ ⵏⴻⵛⵛ ⵣⴻⴳ ⵉⴼⴰⵙⵙⴻⵏ ⵏ ⵉⵎⵓⵔⵉⵢⵢⴻⵏ ⵙ ⵙⵙⵉⴼ ⴷ ⵍⵇⴻⵡⵙ ⵉⵏⵓ.” ");
INSERT INTO rift_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","ⵉⵍⴰⵖⴰ ⵢⴰⵄⵇⵓⴱ ⵅ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ, ⵉⵏⵏⴰ: “ⵙⵎⵓⵏⴻⵎ-ⴷⴷ ⵉⵅⴻⴼ ⵏⵡⴻⵎ, ⴰⴷ ⴰⵡⴻⵎ ⵉⵏⵉⵖ ⵎⵉⵏ ⴷ ⴰⵡⴻⵎ ⵖⴰ ⵉⵎⵙⴰⵔⴻⵏ ⴷⴻⴳ ⵓⵏⴻⴳⴳⴰⵔ ⵏ ⵡⵓⵙⵙⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","ⵙⵎⵓⵏⴻⵎ-ⴷⴷ ⵉⵅⴻⴼ ⵏⵡⴻⵎ ⵓⵛⴰ ⵙⵍⴻⵎ, ⴰ ⵜⴰⵔⵡⴰ ⵏ ⵢⴰⵄⵇⵓⴱ, ⵙⵍⴻⵎ ⵉ ⵉⵙⵔⴰⵉⵍ, ⴱⴰⴱⴰⵜⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","ⵔⵓⴱⵉⵏ, ⵛⴻⴽ ⴷ ⴰⵎⴻⵏⵣⵓ ⵉⵏⵓ, ⵊⵊⴻⵀⴷ ⵉⵏⵓ, ⴷ ⴰⵎⴻⵣⵡⴰⵔ ⵏ ⵜⴻⵔⵢⴰⵙⵜ ⵉⵏⵓ, ⴰⵇⴰ ⵛⴻⴽ ⴷ ⴰⵎⵙⴻⴹⴼⴰⵔ ⵉⵏⵓ ⴷⵉ ⵍⵓⵄⵍⴰ, ⴷ ⴰⵎⵙⴻⴹⴼⴰⵔ ⵉⵏⵓ ⴷⵉ ⵍⵄⴻⵣⵣ. ");
INSERT INTO rift_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","ⵛⴻⴽ ⴰⵎⴻⵛⵏⴰⵡ ⴰⵎⴰⵏ ⵉⵜⵜⵏⴻⵇⵍⴰⴱⴻⵏ, ⵡⴰⵔ ⴷⴷ ⴰⵢⵉ ⵜⴹⴻⴼⴼⴰⵔⴻⴷ, ⴰⵇⴰ ⵛⴻⴽ ⵜⴳⴻⵄⵄⴷⴻⴷ ⵖⴰⵔ ⵍⴻⵛⵜⵓ ⵏ ⵍⴻⵎⵍⴰⵛ ⵏ ⴱⴰⴱⴰⵛ, ⵍⴻⵅⴷⴻⵏⵏⵉ ⵜⴻⵙⵙⴼⴻⴹⵃⴻⴷ ⵜ, ⴰⵇⴰ ⵖⴰⵔ ⵍⴻⵛⵜⵓ ⵉⵏⵓ ⵉⴳⴻⵄⵄⴻⴷ. ");
INSERT INTO rift_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","ⵛⵉⵎⵄⵓⵏ ⴷ ⵍⴰⵡⵉ ⴷ ⴰⵡⵎⴰⵜⴻⵏ! ⵍⴻⵎⵡⴰⵙ ⵏⵙⴻⵏ ⴷ ⵍⴻⵙⵏⴰⵃ ⵏ ⵍⵄⵓⵏⴼ. ");
INSERT INTO rift_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","ⴷⵉ ⵜⵎⴻⵄⵎⵓⵍⵜ ⵏⵙⴻⵏ ⵡⴰⵔ ⵉⵜⵜⵉⴷⴻⴼ ⵍⴻⵄⵎⴰⵔ ⵉⵏⵓ, ⴷⴻⴳ ⵡⴻⴳⵔⴰⵡ ⵏⵙⴻⵏ ⵡⴰⵔ ⵉⵛⴰⵔⵔⴻⵛ ⵡⵓⵍ ⵉⵏⵓ. ⴰⵇⴰ ⴷⴻⴳ ⵓⵅⴻⵢⵢⴻⵇ ⵏⵙⴻⵏ ⵏⵖⵉⵏ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵓⵛⴰ ⵉⵄⵊⴻⴱ ⴰⵙⴻⵏ ⴰⴷ ⵇⴻⵙⵙⴻⵏ ⵉⵥⴻⵡⵔⴰⵏ ⵏ ⵉⴹⴰⵔⴻⵏ ⵏ ⵓⴼⵓⵏⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","ⴷ ⴰⵎⴻⵏⵄⵓⵍ ⴰⵅⴻⵢⵢⴻⵇ ⵏⵙⴻⵏ, ⵎⵉⵏⵣⵉ ⵡⴰⵏⵉⵜⴰ ⵉⵊⵀⴻⴷ ⴰⵟⵟⴰⵙ, ⵓⵍⴰ ⴷ ⴰⴷⵓⵇⵇⴻⵣ ⵏ ⵓⴼⵓⴳⴻⵎ ⵏⵙⴻⵏ, ⵎⵉⵏⵣⵉ ⵉⵇⵙⴻⵃ. ⵏⴻⵛⵛ ⴰⴷ ⵜⴻⵏ ⴱⴹⵉⵖ ⵅ ⵢⴰⵄⵇⵓⴱ, ⴰⴷ ⵜⴻⵏ ⵙⵙⵓⵢⵓⵙⴻⵖ ⴷⵉ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","ⵢⴰⵀⵓⴷⴰ, ⴰⵢⵜⵎⴰⵛ ⴰⴷ ⵛⴻⴽ ⵙⵙⴻⵎⵖⴰⵔⴻⵏ. ⴰⴼⵓⵙ ⵏⵏⴻⵛ ⴰⴷ ⵢⵉⵍⵉ ⵅ ⵢⵉⵔⵉ ⵏ ⵍⵄⴻⴷⵢⴰⵏ ⵏⵏⴻⵛ ⵓ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⴱⴰⴱⴰⵛ ⴰⴷ ⴰⵛ ⴱⴻⵏⴷⵇⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","ⵢⴰⵀⵓⴷⴰ ⴷ ⵉⵊⵊ ⵏ ⵎⵎⵉⵙ ⵏ ⵡⴰⵢⵔⴰⴷ. ⵣⵉ ⵣⵣⴰⵔⴷⴻⵜ ⵉ ⵜⵓⵍⵢⴻⴷ, ⴰ ⵎⵎⵉ. ⵉⵇⵡⴻⵙ ⴰⵎⴻⵛⵏⴰⵡ ⴰⵢⵔⴰⴷ ⵓ ⴰⵎⴻⵛⵎⴰⵡ ⵜⴰⵢⵔⴰⴷⵜ. ⵡⵉ ⵉⵣⴻⵄⵄⴻⵎⴻⵏ ⴰⴷ ⵜ-ⴷⴷ-ⵉⵙⵙⴼⴰⵇ? ");
INSERT INTO rift_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","ⵜⴰⵖⵖⴰⵔⵛⵜ ⵏ ⵍⵃⴰⴽⴻⵎ ⵡⴰⵔ ⵉⵜⵜⵡⴰⴽⴽⴻⵙ ⵅ ⵢⴰⵀⵓⴷⴰ ⵓⵍⴰ ⴷ ⴰⵣⴻⴵⴰⴹ ⵏ ⵚⵚⵓⵍⵟⴰ ⵣⵉ ⵊⴰⵔ ⵉⴹⴰⵔⴻⵏ ⵏⵏⴻⵙ, ⴰⵍ ⴷⴷ ⵖⴰ ⵢⴰⵙ ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵉⵡⵛⴻⵏ ⴰⵔⵔⴰⵃⴻⵜ ⵓⵛⴰ ⴰⴷ ⴰⵙ ⵟⴰⵄⴻⵏ ⵍⴻⴳⵏⵓⵙ. ");
INSERT INTO rift_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","ⵉⵇⵇⴻⵏ ⵖⴰⵔ ⵜⵣⴰⵢⴰⵔⵜ ⴰⵙⵏⵓⵙ ⵏⵏⴻⵙ ⴷ ⵎⵎⵉⵙ ⵏⵏⴻⵙ ⵏ ⵜⴻⵖⵢⵓⵍⵜ ⵖⴰⵔ ⵜⵣⴰⵢⴰⵔⵜ ⵉⵛⴻⵏⵏⵄⴻⵏ ⴰⵟⵟⴰⵙ, ⵉⵙⵙⵉⵔⴷ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ ⴷⵉ ⴱⵉⵏⵓ ⵓ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ ⴷⴻⴳ ⵉⴷⴰⵎⵎⴻⵏ ⵏ ⵓⴹⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵙ ⴷ ⵜⵉⴱⴰⵔⵛⴰⵏⵉⵏ ⵙ ⴱⵉⵏⵓ ⵓ ⵜⵉⵖⵎⴰⵙ ⵏⵏⴻⵙ ⴷ ⵜⵉⵛⴻⵎⵍⴰⵍⵉⵏ ⵙ ⵓⵖⵉ. ");
INSERT INTO rift_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","ⵣⴰⴱⵓⵍⵓⵏ ⴰⴷ ⵉⵣⴷⴻⵖ ⵖⴰⵔ ⵜⵎⴰ ⵏ ⵍⴻⴱⵃⴰⵔ, ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵍⵎⵓⵢⵢⵉ ⵉ ⵉⵖⴰⵔⵔⵓⴱⴰ. ⴰⵖⴻⵣⴷⵉⵙ ⵏⵏⴻⵙ ⴰⴷ ⵢⴰⵔⴻⵢⵢⴻⵃ ⵅ ⵚⵉⴷⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","ⵉⵙⵙⴰⴽⴰⵔ ⴷ ⵉⵊⵊ ⵏ ⵡⴻⵖⵢⵓⵍ ⵉⵇⵙⴻⵃ, ⵉⵣⵣⴻⵍ ⵊⴰⵔ ⵜⵏⴰⵢⴻⵏ ⵏ ⵍⵎⴻⴷⵡⴰⵜ. ");
INSERT INTO rift_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","ⵓⵎⵉ ⵉⵥⵔⴰ ⴰⵔⵔⴰⵃⴻⵜ ⴷ ⵍⴻⵎⵍⵉⵃ ⵓ ⵜⴰⵎⵎⵓⵔⵜ ⴰⵇⴰ ⵜⴰⵔⴻⵛⵛⴻⵇ, ⵉⵇⵡⴻⵙ, ⵉⴳⴳⴰ ⵜⵉⵖⴰⵔⴹⵉⵏ ⵏⵏⴻⵙ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵢⴰⵔⴱⵓ ⴰⵔⵔⵎⴻⵃ ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⵉⴷⵡⴻⵍ ⵙⴰⴷⵓ ⴰⵣⴰⵢⵍⵓ ⵏ ⵉⵙⵎⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","ⴷⴰⵏ ⴰⴷ ⵉⵃⴽⴻⵎ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ ⴰⵎ ⵢⵉⵛⵜ ⵣⵉ ⵜⵇⴻⴱⴱⴰⵍ ⵏ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","ⴰⴷ ⵢⵉⵍⵉ ⴷⴰⵏ ⴷ ⴰⴼⵉⵖⴰⵔ ⴷⴻⴳ ⵡⴻⴱⵔⵉⴷ, ⵜⴰⵍⴻⴼⵙⴰ ⴷⴻⴳ ⵓⵎⴻⵙⵔⵓⵇ, ⵡⴻⵏⵏⵉ ⵉⵣⴻⵄⵄⴼⴻⵏ ⴷⴻⴳ ⵉⵏⵉⵔⵣⴰⵡⴻⵏ ⵏ ⵓⵢⵉⵙ, ⴰⵍ ⵖⴰ ⵉⵡⴹⴰ ⵡⴻⵏⵏⵉ ⵅⴰⵙ ⵉⵏⵢⵉⵏ ⵖⴰⵔ ⴹⴻⴼⴼⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","ⴰⵙⴻⵏⵊⴻⵎ ⵏⵏⴻⵛ ⵉ ⵜⵜⵔⴰⵊⵉⵖ, ⴰ ⵙⵉⴷⵉ! ");
INSERT INTO rift_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","ⵊⴰⴷ, ⴰⴷ ⵅⴰⵙ ⵃⴻⵊⵎⴻⵏⵜ ⴱⴰⵏⴷⵉⵢⵢⴰⵜ, ⵎⴰⵛⴰ ⴰⴷ ⵅⴰⵙⴻⵏ ⵉⴷⴰⵔⵔⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","ⴰⵛⵉⵔ, ⴰⵖⵔⵓⵎ ⵏⵏⴻⵙ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⴰⵖⵔⵓⵎ ⵉⵙⵎⴻⵏ, ⵏⴻⵜⵜⴰ ⴰⴷ ⵉⵇⴻⴷⴷⴻⵎ ⵎⴰⵛⵛⴰ ⵢⵉⵣⵉⴷⴻⵏ ⵉⴳⴻⵍⵍⴷⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","ⵏⴰⴼⵜⴰⵍⵉ ⴷ ⵉⵛⵜ ⵏ ⵜⵓⴷⴰⴷⵜ ⵉⵜⵜⵡⴰⴹⴻⵍⵇⴻⵏ, ⵉⵙⵙⵓⴼⴼⵓⵖ ⴰⵡⴰⵍⴻⵏ ⵛⵏⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","ⵢⵓⵙⵓⴼ ⴷ ⵎⵎⵉⵙ ⵏ ⵜⵛⴻⵊⵊⴰⵔⵜ ⵉⵜⵜⵉⵛⴻⵏ ⵍⵖⵉⴵⴻⵜ, ⵎⵎⵉⵙ ⵏ ⵜⵛⴻⵊⵊⴰⵔⵜ ⵉⵜⵜⵉⵛⴻⵏ ⵍⵖⵉⴵⴻⵜ ⵖⴰⵔ ⵜⴰⵍⴰ. ⵢⴻⵙⵙⵉⵙ ⴳⴳⵓⵔⴻⵏⵜ ⵅ ⵡⴻⵖⴱⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","ⵏⵉⵜⵏⵉ ⵙⵙⴰⵔⴻⵣⴳⴻⵏ ⵅⴰⵙ ⵜⵓⴷⴰⵔⵜ, ⵏⴻⵢⵢⵛⴻⵏ ⵅⴰⵙ, ⵡⴰⵀ ⵉⵎⵊⴻⴱⴱⴰⴷⴻⵏ ⵏ ⵍⵇⴻⵡⵙ ⴹⴼⴰⵔⴻⵏ ⵜ, ");
INSERT INTO rift_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","ⵎⴰⵛⴰ ⵍⵇⴻⵡⵙ ⵏⵏⴻⵙ ⵉⵇⵇⵉⵎ ⵉⵎⵃⴻⴹ ⵓ ⵉⵖⴰⴵⴻⵏ ⵏ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵏⴻⵙ ⵇⵇⵉⵎⴻⵏ ⴰⵔⵅⵓⵏ ⵙ ⵉⴼⴰⵙⵙⴻⵏ ⵏ ⵓⵎⵣⴻⵎⵎⴰⵔ ⵏ ⵢⴰⵄⵇⵓⴱ - ⵅ ⵓⵢⴰ ⵏⴻⵜⵜⴰ ⴷ ⴰⵎⴻⴽⵙⴰⵡ ⴷ ⵜⴰⵚⴹⴰⵔⵜ ⵏ ⵉⵙⵔⴰⵉⵍ - ");
INSERT INTO rift_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","ⵙ ⴰⵔⴻⴱⴱⵉ ⵏ ⴱⴰⴱⴰⵛ ⵡⴻⵏⵏⵉ ⵛⴻⴽ ⵉ ⵖⴰ ⵉⵄⴰⵡⵏⴻⵏ, ⴰⵎⵣⴻⵎⵎⴰⵔ ⵅ ⴽⵓⵍⵛⵉ, ⵡⴻⵏⵏⵉ ⵛⴻⴽ ⵉ ⵖⴰ ⵉⴱⴰⵔⴽⴻⵏ ⵙ ⵍⴱⴰⵔⴰⴽⴰⵜ ⵏ ⵓⵊⴻⵏⵏⴰ ⵙⴻⵏⵏⴻⵊ, ⵙ ⵍⴱⴰⵔⴰⴽⴰⵜ ⵏ ⵡⴰⵎⴰⵏ ⵉⵀⴻⵡⵍⴻⵏ ⵉ ⴷⵉⵏ ⵉⴵⴰⵏ ⵙⵡⴰⴷⴷⴰⵢ, ⵙ ⵍⴱⴰⵔⴰⴽⴰⵜ ⵏ ⵜⵓⴱⴱⴻⵛⵜ ⴷ ⵍⴻⵎⵍⴰⵡⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","ⵍⴱⴰⵔⴰⴽⴰⵜ ⵏ ⴱⴰⴱⴰⵛ ⴷ ⵜⵉⵎⴻⵇⵇⵔⴰⵏⵉⵏ ⵓⵄⵍⴰⵏⵜ ⵅ ⵍⴱⴰⵔⴰⴽⴰⵜ ⵏ ⵢⵉⵏⵏⵉ ⴷ ⴰⵢⵉ ⴷⴷ-ⵢⴻⵊⵊⵉⵏ ⵓⵛⴰ ⵜⵜⴰⴽⴽⵡⴰⴹⴻⵏⵜ ⵖⴰⵔ ⵜⵇⵉⵛⵛⴰⵜⵉⵏ ⵏ ⵜⴻⵡⵔⵉⵔⵉⵏ ⵏ ⵍⴻⴱⴷⴰ. ⴰⴷ ⵉⵍⵉⵏⵜ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏ ⵢⵓⵙⵓⴼ, ⵅ ⵜⵓⵛⵛⴻⵏⵜ ⵏ ⵓⵛⵓⵡⵡⴰⴼ ⵏ ⵡⴻⵏⵏⵉ ⵢⴰⵔⴻⴱⴱⵓ ⵜⵜⴰⵊ ⵏ ⵡⴻⵄⵣⴰⵔ ⵊⴰⵔ ⴰⵢⵜⵎⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","ⴱⵉⵏⵢⴰⵎⵉⵏ ⴷ ⵉⵊⵊ ⵏ ⵡⵓⵛⵛⴻⵏ ⵉⵜⵜⵎⴻⵣⵣⴰⵇ. ⵖⴰⵔ ⵚⵚⴱⴻⵃ ⴰⴷ ⵉⵙⴰⵔⴹ ⵣⵣⴰⵔⴷⴻⵜ ⵓ ⵙ ⴵⵉⵍⴻⵜ ⵉⴱⴻⵟⵟⴰ ⵜⴰⴽⴻⵛⵛⴰⴹⵜ.” ");
INSERT INTO rift_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","ⵎⴰⵔⵔⴰ ⵉⵏⴰ ⴷ ⵜⴻⵏⵄⴰⵛ ⵏ ⵜⵇⴻⴱⴱⴰⵍ ⵏ ⵉⵙⵔⴰⵉⵍ. ⴷ ⵎⴰⵏ ⴰⵢⴰ ⵎⵉⵏ ⴷ ⴰⵙⴻⵏ ⵉⵏⵏⴰ ⴱⴰⴱⴰⵜⵙⴻⵏ ⵓⵛⴰ ⵉⴱⴰⵔⴽ ⵉ-ⵜⴻⵏ, ⵡⴰⵀ, ⵉⴱⴰⵔⴽ ⵉ-ⵜⴻⵏ, ⴽⵓⵍ ⵉⵊⵊ ⵙ ⵍⴱⴰⵔⴰⴽⴰ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","ⵢⵓⵎⵓⵔ ⵉ-ⵜⴻⵏ, ⵉⵏⵏⴰ ⴰⵙⴻⵏ: “ⴰⴷ ⵎⵎⴰⵔⴻⵏⵢⴻⵖ ⵖⴰⵔ ⵍⴳⴻⵏⵙ ⵉⵏⵓ. ⵏⴻⴹⵍⴻⵎ ⴰⵢⵉ ⴰⴽ-ⴷ ⵍⴻⵊⴷⵓⴷ ⵉⵏⵓ ⴷⴻⴳ ⵉⴼⵔⵉ ⵡⴻⵏⵏⵉ ⵉⴵⴰⵏ ⴷⴻⴳ ⵉⵢⵢⴰⵔ ⵏ ⵉⴼⵔⵓⵏ, ⴰⵃⵉⵜⵜⵉ, ");
INSERT INTO rift_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","ⴷⴻⴳ ⵉⴼⵔⵉ ⵡⴻⵏⵏⵉ ⵉⴵⴰⵏ ⴷⴻⴳ ⵉⵢⵢⴰⵔ ⵏ ⵎⴰⴽⴼⵉⵍⴰ ⵉ ⵉⴵⴰⵏ ⵣⵣⴰⵜ ⵉ ⵎⴰⵎⵔⵉ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ, ⵜⴻⵏⵏⵉ ⵉⵙⵖⴰ ⵉⴱⵔⴰⵀⵉⵎ ⴰⴽ-ⴷ ⵢⴻⵢⵢⴰⵔ ⵣⵉ ⵉⴼⵔⵓⵏ, ⴰⵃⵉⵜⵜⵉ, ⵃⵉⵎⴰ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⴰⵏⴹⴻⵍ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","ⴷⵉⵏⵏⵉ ⵉ ⵏⴻⴹⵍⴻⵏ ⵉⴱⵔⴰⵀⵉⵎ ⴷ ⵙⴰⵔⴰ ⵜⴰⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ. ⴷⵉⵏⵏⵉ ⵉ ⵏⴻⴹⵍⴻⵏ ⵉⵙⵃⴰⵇ ⴷ ⵜⴻⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ ⵔⵉⴼⵇⴰ. ⵓ ⵏⴻⵛⵛ ⵏⴻⴹⵍⴻⵖ ⴷⵉⵏ ⵍⵉⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","ⵉⵢⵢⴰⵔ ⵙ ⵉⴼⵔⵉ ⵉ ⵜⵓⵖⴰ ⴷⴰⵢⴻⵙ ⵉⴵⴰⵏ ⵉⵎⵎⵙⴻⵖ ⵅ ⵜⴰⵔⵡⴰ ⵏ ⵃⵉⵜ.” ");
INSERT INTO rift_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","ⵓⵎⵉ ⵉⴽⴻⵎⵎⴻⵍ ⵢⴰⵄⵇⵓⴱ ⴰⴷ ⵉⵡⴻⵚⵚⴰ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ, ⵉⴽⴻⵎⵎⴻⵛ ⵉⴹⴰⵔⴻⵏ ⵏⵏⴻⵙ ⴷⵉ ⵇⴰⵎⴰ, ⵉⴼⴼⴻⵖ ⵉ-ⵜ ⴱⵓⵃⴱⴻⵍ ⵓⵛⴰ ⵉⵎⵎⴰⵔⵏⵉ ⵖⴰⵔ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","ⵅⴻⵏⵏⵉ ⵉⵏⴳⴻⵣ ⵢⵓⵙⵓⴼ ⵅ ⵓⵖⴻⵎⴱⵓⴱ ⵏ ⴱⴰⴱⴰⵙ, ⵉⵔⵓ ⵅⴰⵙ ⵓⵛⴰ ⵉⵙⵙⵓⴷⴻⵎ ⵉ-ⵜ. ");
INSERT INTO rift_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","ⵢⵓⵎⵓⵔ ⵢⵓⵙⵓⴼ ⵉ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵙ, ⵉⴹⴱⵉⴱⴻⵏ, ⴰⴷ ⵃⴻⵏⵏⴹⴻⵏ ⴱⴰⴱⴰⵙ ⵓⵛⴰ ⵉⴹⴱⵉⴱⴻⵏ ⵃⴻⵏⵏⴹⴻⵏ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","ⴰⵔⴻⴱⵄⵉⵏ ⵏ ⵡⵓⵙⵙⴰⵏ ⵉ ⴷⴰⵢⴻⵙ ⴽⴽⵉⵏ, ⵎⵉⵏⵣⵉ ⵃⴷⴰⵊⴻⵏ ⵓⵙⵙⴰⵏ ⵏⵏⵉ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴽⴻⵎⵎⵍⴻⵏ ⴰⵃⴻⵏⵏⴻⵟ ⵓⵛⴰ ⵔⵓⵏ ⵎⴰⵔⵔⴰ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ ⵙⴻⴱⵄⵉⵏ ⵏ ⵡⵓⵙⵙⴰⵏ ⴷⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","ⵓⵎⵉ ⵄⴷⵓⵏ ⵡⵓⵙⵙⴰⵏ ⵏ ⵍⴻⵄⵣⴰⵜ ⵅⴰⵙ, ⵉⵙⵙⵉⵡⴻⵍ ⵢⵓⵙⵓⴼ ⴰⴽ-ⴷ ⵢⴻⵏⵏⵉ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⴼⵉⵔⵄⵓⵏ, ⵉⵏⵏⴰ: “ⵎⴰⵍⴰ ⵓⴼⵉⵖ ⵍⴻⵅⵅⵓ ⴰⵔⴹⴰ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵡⴻⵎ, ⵜⵜⵣⴰⵡⴰⴳⴻⵖ ⴽⴻⵏⵏⵉⵡ, ⴰⴷ ⵜⴻⵙⵙⵉⵡⵍⴻⵎ ⴷⴻⴳ ⵉⵎⴻⵊⵊⴰⵏ ⵏ ⴼⵉⵔⵄⵓⵏ, ⵉⵏⵉⵎ: ");
INSERT INTO rift_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","“ⴱⴰⴱⴰ ⵉⵏⵓ ⵉⵊⵊⴰ ⴰⵢⵉ ⴰⴷ ⵊⵊⴰⴵⴻⵖ ⵓⵛⴰ ⵉⵏⵏⴰ: ‘ⴰⵇⴰ ⵜⵜⵎⴻⵜⵜⵉⵖ. ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⴰⵢⵉ ⵜⵏⴻⴹⵍⴻⴷ ⴷⴻⴳ ⵡⴻⵏⴹⴻⵍ ⵏⵏⵉ ⵏⴻⵇⵛⴻⵖ ⵉ ⵢⵉⵅⴻⴼ ⵉⵏⵓ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ!’ ⵅⴻⵏⵏⵉ, ⵜⵜⵣⴰⵡⴰⴳⴻⵖ, ⴻⵊⵊ ⴰⵢⵉ ⴰⴷ ⵔⴰⵃⴻⵖ ⵍⴻⵅⵅⵓ ⴰⴷ ⵏⴻⴹⵍⴻⵖ ⴱⴰⴱⴰ ⵓⵛⴰ ⴰⵡⴰⵔⵏⵉ ⵎⴰⵏ ⴰⵢⴰ ⴰⴷ ⴷⴷ-ⵄⴻⵇⴱⴻⵖ.” ");
INSERT INTO rift_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","ⵓⵛⴰ ⵉⵏⵏⴰ ⴼⵉⵔⵄⵓⵏ: “ⵔⵓⵃ, ⵏⴹⴻⵍ ⴱⴰⴱⴰⵛ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵢⴰⵔⵔⴰ ⵛⴻⴽ ⴰⴷ ⴰⵙ ⵜⴻⵊⵊⵓⴵⴻⴷ.” ");
INSERT INTO rift_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","ⵓⵛⴰ ⵉⴳⴻⵄⵄⴻⴷ ⵢⵓⵙⵓⴼ ⵃⵉⵎⴰ ⴰⴷ ⵉⵏⴹⴻⵍ ⴱⴰⴱⴰⵙ ⵓⵛⴰ ⴳⴻⵄⵄⴷⴻⵏ ⵎⴰⵔⵔⴰ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏ ⴼⵉⵔⵄⵓⵏ ⴰⴽⵉⴷⴻⵙ, ⵉⵎⵖⴰⵔⴻⵏ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⴻⵙ ⴷ ⵎⴰⵔⵔⴰ ⵉⵎⵖⴰⵔⴻⵏ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ, ");
INSERT INTO rift_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","ⵓⵍⴰ ⴷ ⵎⴰⵔⵔⴰ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵢⵓⵙⵓⴼ ⴷ ⴰⵢⵜⵎⴰⵙ ⵏⵏⴻⵙ ⴷ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⴱⴰⴱⴰⵙ. ⵎⵖⵉⵔ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⴻⵏ ⵏⵙⴻⵏ ⴷ ⵡⵓⴵⵉ ⵏⵙⴻⵏ ⴷ ⵉⴼⵓⵏⴰⵙⴻⵏ ⴷ ⵜⴼⵓⵏⴰⵙⵉⵏ ⵏⵙⴻⵏ ⵊⵊⵉⵏ ⵜⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵊⵓⵛⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","ⴳⴻⵄⵄⴷⴻⵏ ⴰⴽⵉⴷⴻⵙ ⵉⴽⴰⵔⵔⵓⵜⴻⵏ ⴷ ⵢⵉⵏⵏⵉ ⵉⵏⵢⵉⵏ ⵅ ⵢⴻⵢⵙⴰⵏ ⵓⵛⴰ ⴳⴳⵉⵏ ⵉⵊⵊ ⵏ ⵓⵇⴰⵔⵔⵓ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵉⵎⵖⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","ⵓⵎⵉ ⵉⵡⴹⴻⵏ ⵖⴰⵔ ⵓⵏⴻⴷⵔⴰⵔ ⵏ ⴰⵜⴰⴷ, ⵡⴻⵏⵏⵉ ⵉⴵⴰⵏ ⵅ ⵓⵊⴻⵎⵎⴰⴹ ⵏ ⵍ’ⵓⵔⴷⵓⵏ, ⵙⵙⴳⴻⵄⵄⴷⴻⵏ ⴷⵉⵏ ⵉⵛⵜ ⵏ ⵜⵖⵓⵢⵢⵉⵜ ⵜⴻⵎⵖⴰⵔ, ⵜⴻⵊⵀⴻⴷ ⴰⵟⵟⴰⵙ ⵓⵛⴰ ⵉⴳⴳⴰ ⵢⵓⵙⵓⴼ ⴷⵉⵏ ⵉⵊⵊ ⵏ ⵡⴻⵛⴹⴰⵏ ⵅ ⴱⴰⴱⴰⵙ ⵉ ⵢⵉⵊⵊ ⵏ ⵍⵎⵉⵊⴰⵍ ⵏ ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","ⵥⵔⵉⵏ ⵉⵎⴻⵣⴷⴰⵖ ⵏ ⵜⴻⵎⵎⵓⵔⵜ, ⴰⵢⵜ ⵏ ⴽⴻⵏⵄⴰⵏ, ⴰⵛⴹⴰⵏ ⴷⴻⴳ ⵓⵏⴻⴷⵔⴰⵔ ⵏ ⴰⵜⴰⴷ, ⵏⵏⴰⵏ: “ⵡⴰ ⴷ ⴰⵛⴹⴰⵏ ⵉⵎⵖⴰⵔ ⵏ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ.” ⵅ ⵓⵢⴰ ⵍⴰⵖⴰⵏ ⵉⵙⴻⵎ ⵏⵏⴻⵙ ⴰⴱⴰⵍ-ⵎⵉⵚⵔⴰⵢⵉⵎ, ⵡⴻⵏⵏⵉ ⵉⴵⴰⵏ ⵅ ⵓⵊⴻⵎⵎⴰⴹ ⵏ ⵍ’ⵓⵔⴷⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","ⴳⴳⵉⵏ ⴰⵙ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⴻⵏ ⵉⵡⴻⵚⵚⴰ. ");
INSERT INTO rift_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","ⴰⵔⴱⵓⵏ ⵜ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ, ⵏⴻⴹⵍⴻⵏ ⵜ ⴷⴻⴳ ⵉⴼⵔⵉ ⴷⴻⴳ ⵉⵢⵢⴰⵔ ⵏ ⵎⴰⴽⴼⵉⵍⴰ ⵏⵏⵉ ⵉⵙⵖⴰ ⵉⴱⵔⴰⵀⵉⵎ ⴰⴽ-ⴷ ⵢⴻⵢⵢⴰⵔ ⵣⵉ ⵉⴼⵔⵓⵏ, ⴰⵃⵉⵜⵜⵉ, ⴰⵔⴻⵏⴷⴰⴷ ⵏ ⵎⴰⵎⵔⵉ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⴰⵏⴹⴻⵍ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⵉⵏⴹⴻⵍ ⴱⴰⴱⴰⵙ, ⵉⵄⵇⴻⴱ ⵢⵓⵙⵓⴼ ⵖⴰⵔ ⵎⵉⵚⵔⴰ, ⵏⴻⵜⵜⴰ ⴷ ⵢⴰⵢⵜⵎⴰⵙ ⴷ ⵎⴰⵔⵔⴰ ⵉⵏⵏⵉ ⴰⴽⵉⴷⴻⵙ ⴷⴷ-ⵉⴳⴻⵄⵄⴷⴻⵏ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵏⴻⴹⵍⴻⵏ ⴱⴰⴱⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","ⵓⵎⵉ ⵥⵔⵉⵏ ⴰⵢⵜⵎⴰⵙ ⵏ ⵢⵓⵙⵓⴼ ⴱⴰⴱⴰⵜⵙⴻⵏ ⵉⵎⵎⵓⵜ, ⵏⵏⴰⵏ: “ⵎⴰⵍⴰ ⵉⵛⴰⵔⵀ ⴰⵏⴻⵖ ⵢⵓⵙⵓⴼ, ⴰⴷ ⴰⵏⴻⵖ ⵉⵅⴻⴵⴻⵚ ⵏⵉⵛⴰⵏ ⵎⴰⵔⵔⴰ ⵍⵖⴰⵔ ⵏⵏⵉ ⴷⴰⵢⴻⵙ ⵏⴻⴳⴳⴰ.” ");
INSERT INTO rift_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","ⵙ ⵓⵢⴻⵏⵏⵉ ⵙⵙⴻⴽⴽⴻⵏ ⴰⴷ ⵅⴻⴱⴱⴰⵔⴻⵏ ⵢⵓⵙⵓⴼ ⵙ ⵎⴰⵏ ⴰⵢⴰ, ⵏⵏⴰⵏ: “ⴱⴰⴱⴰⵛ ⵉⵡⴻⵚⵚⴰ ⵇⴱⴻⵍ ⵍⵎⴻⵡⵜ ⵏⵏⴻⵙ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵜⵉⵏⵉⵎ ⵉ ⵢⵓⵙⵓⴼ: ⵜⵜⵣⴰⵡⴳⴻⵖ ⵛⴻⴽ, ⵖⴼⴰⵔ ⵍⴻⵅⵅⵓ ⴰⵅⴻⵟⵟⵓ ⵏ ⴰⵢⵜⵎⴰⵛ ⴷ ⴷⴷⴻⵏⴱ ⵏⵙⴻⵏ ⴷ ⵍⵖⴰⵔ ⵉ ⴷ ⴰⵛ ⴳⴳⵉⵏ. ⵖⴼⴰⵔ ⵍⴻⵅⵅⵓ ⴰⵅⴻⵟⵟⵓ ⵏ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏ ⴰⵔⴻⴱⴱⵉ ⵏ ⴱⴰⴱⴰⵛ!’” ⵓⵛⴰ ⵉⵙⵖⵓⵢ ⵢⵓⵙⵓⴼ ⴰⵎ ⴽⵉⵙ ⵙⵙⵉⵡⵍⴻⵏ ⴰⵎⵎⵓ. ");
INSERT INTO rift_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","ⵅⴻⵏⵏⵉ ⵓⵙⵉⵏ-ⴷⴷ ⵄⴰⵡⴻⴷ ⴰⵢⵜⵎⴰⵙ ⵙ ⵢⵉⵅⴻⴼ ⵏⵙⴻⵏ, ⵡⴹⴰⵏ ⴰⵙ ⵣⵣⴰⵜ ⵉ ⵓⵖⴻⵎⴱⵓⴱ ⵏⵏⴻⵙ, ⵏⵏⴰⵏ: “ⴰⵇⴰ-ⵏⴻⵖ ⴷⴰ ⴷ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵛ!” ");
INSERT INTO rift_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","ⵢⴰⵔⵔⴰ-ⴷⴷ ⵅⴰⵙⴻⵏ ⵢⵓⵙⵓⴼ: “ⵡⴰⵔ ⵜⵜⴻⴳⴳⵯⴷⴻⵎ ⵛⴰ! ⵎⴰ ⴰⵇⴰ ⴰⵢⵉ ⵏⴻⵛⵛ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏ ⴰⵔⴻⴱⴱⵉ? ");
INSERT INTO rift_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","ⵡⴰⵅⵅⴰ ⴽⴻⵏⵏⵉⵡ ⵜⵅⴰⵔⵔⵚⴻⵎ ⴷⴰⵢⵉ ⵙ ⵍⵖⴰⵔ, ⴰⵇⴰ ⴰⵔⴻⴱⴱⵉ ⵉⵏⵡⴰ ⵣⵣⴰⵢⴻⵙ ⵍⵅⴰⵔ, ⵃⵉⵎⴰ ⴰⴷ ⵢⴻⴳⴳ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵉ ⵜⴻⴵⴰ ⴰⵙⵙ-ⴰ, ⴰⴷ ⵢⴻⵊⵊ ⴷⵉ ⵜⵓⴷⴰⵔⵜ ⵉⵊⵊ ⵏ ⵍⴳⴻⵏⵙ ⴷ ⴰⵎⴻⵇⵇⵔⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","ⵍⴻⵅⵅⵓ, ⵡⴰⵔ ⵜⵜⴻⴳⴳⵯⴷⴻⵎ ⵛⴰ! ⵏⴻⵛⵛ ⴰⴷ ⴽⴻⵏⵏⵉⵡ ⵄⴻⵡⵡⵍⴻⵖ, ⴽⴻⵏⵏⵉⵡ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⴻⵏ ⵏⵡⴻⵎ.” ⴰⵎⵎⵓ ⵜⴻⵏ ⵉⵙⵙⴼⴻⵡⵡⴻⵊ ⵓⵛⴰ ⵉⵙⵙⵉⵡⴻⵍ ⴰⴽⵉⴷⵙⴻⵏ ⵖⴰⵔ ⵡⵓⵍⴰⵡⴻⵏ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","ⵜⵓⵖⴰ ⵢⵓⵙⵓⴼ ⵉⵣⴻⴷⴷⴻⵖ ⴷⵉ ⵎⵉⵚⵔⴰ, ⵏⴻⵜⵜⴰ ⴷ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⴱⴰⴱⴰⵙ, ⵓⵛⴰ ⵉⴷⴷⴰⵔ ⵢⵓⵙⵓⴼ ⵎⵢⴰ ⵓ-ⵄⴻⵛⵔⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","ⵉⵥⵔⴰ ⵢⵓⵙⵓⴼ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵉⴼⵔⴰⵢⵉⵎ ⴰⵍ ⵊⵊⵉⵍ ⵡⵉⵙⵙ ⵜⵍⴰⵜⴰ. ⴰⵇⴰ ⵜⵜⵡⴰⵔⵡⴻⵏ-ⴷⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵎⴰⴽⵉⵔ, ⵎⵎⵉⵙ ⵏ ⵎⴰⵏⴰⵙⵙⴰ, ⵄⴰⵡⴻⴷ ⵅ ⵉⴼⴰⴷⴷⴻⵏ ⵏ ⵢⵓⵙⵓⴼ. ");
INSERT INTO rift_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","ⵓⵛⴰ ⵉⵏⵏⴰ ⵢⵓⵙⵓⴼ ⵉ ⵢⴰⵢⵜⵎⴰⵙ: “ⵏⴻⵛⵛ ⴰⴷ ⵎⵎⵜⴻⵖ, ⵎⴰⵛⴰ ⴰⵔⴻⴱⴱⵉ ⴰⴷ ⴽⴻⵏⵏⵉⵡ ⵢⴰⵔⵣⴻⴼ ⵙ ⵜⵉⴷⴻⵜⵜ ⵓⵛⴰ ⴰⴷ ⴽⴻⵏⵏⵉⵡ ⵉⵙⵙⴳⴻⵄⵄⴻⴷ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ-ⴰ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵉ ⵉⵡⴰⵄⴷ ⵙ ⵜⵊⴰⴵⵉⵜ ⵉ ⵉⴱⵔⴰⵀⵉⵎ ⴷ ⵉⵙⵃⴰⵇ ⴷ ⵢⴰⵄⵇⵓⴱ.” ");
INSERT INTO rift_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","ⵅⴰⵙ ⵓⵛⴰ ⵉⵙⵙⵊⵊⵓⴵ ⵢⵓⵙⵓⴼ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵉⵏⵏⴰ: “ⴰⵔⴻⴱⴱⵉ ⴰⴷ ⴽⴻⵏⵏⵉⵡ ⵢⴰⵔⵣⴻⴼ ⵙ ⵜⵉⴷⴻⵜⵜ ⵓⵛⴰ ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⴻⴽⵙⵉⵎ ⵙⵙⴰ ⵉⵖⵙⴰⵏ ⵉⵏⵓ!” ");
INSERT INTO rift_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","ⵉⵎⵎⵓⵜ ⵢⵓⵙⵓⴼ ⵓⵎⵉ ⵜⵓⵖⴰ ⵖⴰⵔⴻⵙ ⵎⵢⴰ ⵓ-ⵄⴻⵛⵔⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ. ⵃⴻⵏⵏⴹⴻⵏ ⵜ ⵓⵛⴰ ⵙⵙⴰⵔⵙⴻⵏ ⵜ ⴷⵉ ⵍⵎⴻⵃⵎⴻⵍ ⵏ ⵓⵎⴻⵜⵜⵉⵏ ⴷⵉ ⵎⵉⵚⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","ⵉⵏⴰ ⴷ ⵉⵙⵎⴰⵡⴻⵏ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵉ ⴷⴷ-ⵢⵉⵡⴹⴻⵏ ⴰⴽ-ⴷ ⵢⴰⵄⵇⵓⴱ ⵖⴰⵔ ⵎⵉⵚⵔⴰ. ⵢⵓⵙⴰ-ⴷⴷ ⴽⵓⵍ ⵉⵊⵊ ⵣⵣⴰⵢⵙⴻⵏ ⴰⴽ-ⴷ ⴰⵢⵜⴱⴰⴱ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⴻⵙ:    ");
INSERT INTO rift_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","ⵔⵓⴱⵉⵏ, ⵛⵉⵎⵄⵓⵏ, ⵍⴰⵡⵉ ⴷ ⵢⴰⵀⵓⴷⴰ, ");
INSERT INTO rift_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ⵉⵙⵙⴰⴽⴰⵔ, ⵣⴰⴱⵓⵍⵓⵏ ⴷ ⴱⵉⵏⵢⴰⵎⵉⵏ, ");
INSERT INTO rift_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","ⴷⴰⵏ ⴷ ⵏⴰⴼⵜⴰⵍⵉ, ⵊⴰⴷ ⴷ ⴰⵛⵉⵔ. ");
INSERT INTO rift_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","ⵎⴰⵔⵔⴰ ⵍⴻⵄⵎⵓⵔ ⵏⵏⵉ ⴷⴷ-ⵉⴼⴼⵖⴻⵏ ⵣⵉ ⵜⵎⴻⵚⵚⴰⴹⵜ ⵏ ⵢⴰⵄⵇⵓⴱ, ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⵙⴻⴱⵄⵉⵏ. ⵢⵓⵙⵓⴼ ⵜⵓⵖⴰ-ⵜ ⴷⵉ ⵎⵉⵚⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","ⵉⵎⵎⵓⵜ ⵢⵓⵙⵓⴼ ⴷ ⵎⴰⵔⵔⴰ ⴰⵢⵜⵎⴰⵙ, ⴷ ⵊⵊⵉⵍ ⵏⵏⵉ ⵎⴰⵔⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","ⵎⵎⴰⵔⴻⵏⵢⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓ ⵊⵊⵉⵏ-ⴷⴷ ⵍⵖⵉⴵⴻⵜ ⴰⵍⴰⵎⵉ ⵣⵣⴰⵢⵙⴻⵏ ⵜⴻⵙⴼⵓⴼⴼⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵓⵛⴰ ⵜⵜⵡⴰⴽⵜⴰⵔⴻⵏ ⵓⵛⴰ ⴷⴻⵡⵍⴻⵏ ⵊⴻⵀⴷⴻⵏ ⴰⵟⵟⴰⵙ, ⵎⵉⵏⵣⵉ ⵜⴻⵛⵛⵓⵔ ⵣⵣⴰⵢⵙⴻⵏ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","ⵉⴼⴼⴻⵖ-ⴷⴷ ⵅⴻⵏⵏⵉ ⵉⵊⵊ ⵏ ⵓⵊⴻⴵⵉⴷ ⴷ ⵊⴷⵉⴷ ⵉⵃⴻⴽⴽⴻⵎ ⵅ ⵎⵉⵚⵔⴰ, ⵡⴻⵏⵏⵉ ⵜⵓⵖⴰ ⵡⴰⵔ ⵉⵙⵙⵉⵏ ⵢⵓⵙⵓⴼ. ");
INSERT INTO rift_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","ⵉⵏⵏⴰ ⵉ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ: “ⵅⵣⴰⵔ, ⵍⴳⴻⵏⵙ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵉⵎⵖⴰⵔ ⵓ ⵉⵊⵀⴻⴷ ⵅⴰⵏⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","ⵍⴻⵅⵅⵓ, ⴰⵇⴰ ⴰⴷ ⵅⴰⵙ ⵏⴻⵃⴽⴻⵎ ⵙ ⵍⴻⵄⵇⴻⵍ, ⵃⵉⵎⴰ ⵡⴰⵔ ⵉⵜⵜⵎⴰⵔⵏⵉ ⵍⴳⴻⵏⵙ ⴽⵜⴰⵔ, ⵓⵛⴰ, ⵎⴰⵍⴰ ⵉⵎⵙⴰⵔ ⵉⴽⴽⴰⵔ ⵛⴰ ⵏ ⵍⴱⴰⵔⵓⴹ, ⴰⴷ ⵉⴷⵡⴻⵍ ⴰⴽ-ⴷ ⵍⵄⴻⴷⵢⴰⵏ ⵏⵏⴻⵖ, ⴰⴷ ⵢⴻⴳⴳ ⵍⵃⴰⵔⴱ ⴰⴽⵉⴷⵏⴻⵖ ⵓⵛⴰ ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⴼⴼⴻⵖ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ.” ");
INSERT INTO rift_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","ⵏⵉⵜⵏⵉ ⴳⴳⵉⵏ ⵅⴰⵙⴻⵏ ⵉⵎⴻⵃⴹⴰⵢⴻⵏ ⵅ ⵡⴰⵔⴱⴰⵔ ⵏ ⵜⴻⵙⵎⵓⵖⵉ, ⵃⵉⵎⴰ ⴰⴷ ⵙⵙⴷⴻⴵⴻⵏ ⵍⴳⴻⵏⵙ ⵙ ⴷⴷⵇⵓⵍⴰⵜ ⵉ ⵅⴰⵙⴻⵏ ⵙⵙⴰⵔⴻⴱⴱⵓⵏ. ⴱⵏⴰⵏ ⵉ ⴼⵉⵔⵄⵓⵏ, ⴰⵊⴻⴵⵉⴷ, ⵜⵉⵏⴻⴷⴷⴰⵎ ⵏ ⵍⴻⵅⵣⴻⵏ: ⴼⵉⵜⵓⵎ ⴷ ⵔⴰⵄⴰⵎⵙⵉⵙ. ");
INSERT INTO rift_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","ⵎⴰⵛⴰ ⵎⴻⵛⵃⴰⵍ ⵎⴰ ⴷⴻⴵⴻⵏ ⵏⵉⵜⵏⵉ ⵍⴳⴻⵏⵙ, ⴰⵎⴻⵏⵏⵉ ⵉ ⵉⴳⵎⴰ ⵓ ⵉⴱⴻⵣⵣⴻⵄ ⵍⴳⴻⵏⵙ, ⴰⵍⴰⵎⵉ ⵉⵡⴹⴻⵏ ⵏⵉⵜⵏⵉ ⴰⴷ ⵛⴰⵔⵀⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴰⵟⵟⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","ⵓⵛⴰ ⴰⵔⵔⵉⵏ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴷ ⵉⵙⴻⵎⵖⴰⵏ ⵙ ⵓⵖⵉⵍ ");
INSERT INTO rift_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","ⵓⵛⴰ ⵙⵙⴰⵔⴻⵣⴳⴻⵏ ⵜⵓⴷⴰⵔⵜ ⵏⵙⴻⵏ ⵙ ⵜⴻⵙⵎⵓⵖⵉ ⵉⵇⴻⵙⵃⴻⵏ ⴷⴻⴳ ⵓⴱⴻⴵⴰⵄ ⴷ ⵍⵍⴰⵊⵓⵔ ⵓⵍⴰ ⴷⵉ ⵎⴰⵔⵔⴰ ⵜⴻⵙⵎⵓⵖⵉ ⴷⴻⴳ ⵉⵢⵢⴰⵔⴻⵏ. ⵎⴰⵔⵔⴰ ⵜⴰⵙⵎⵓⵖⵉ ⵉ ⴳⴳⵉⵏ ⵏⵉⵜⵏⵉ ⴷⵉ ⵍⵡⴻⵙⵜ ⵏⵙⴻⵏ, ⵜⵓⵖⴰ ⵜⵜ ⵙ ⵓⵖⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","ⵉⵙⵙⵉⵡⴻⵍ ⵓⵊⴻⴵⵉⴹ ⵏ ⵎⵉⵚⵔⴰ ⴰⴽ-ⴷ ⵍⵇⴰⴱⵍⴰⵜ ⵜⵉⵄⵉⴱⵔⴰⵏⵉⵢⵢⵉⵏ, ⵉⵛⵜⴻⵏ ⵣⵣⴰⵢⵙⴻⵏⵜ ⵇⵇⴰⵔⴻⵏ ⴰⵙ ⵙⵉⴼⵔⴰ, ⵓ ⵜⴻⵏⵏⴻⵖⵏⵉ ⵇⵇⴰⵔⴻⵏ ⴰⵙ ⴼⵓⵄⴰⵜ. ");
INSERT INTO rift_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","ⵉⵏⵏⴰ: “ⵅⵎⵉ ⵖⴰ ⵜⵄⴰⵡⵏⴻⵏⵜ ⵜⵉⵎⵖⴰⵔⵉⵏ ⵜⵉⵄⵉⴱⵔⴰⵏⵉⵢⵢⵉⵏ ⴰⴷ ⴰⵔⵡⴻⵏⵜ, ⵓⵛⴰ ⴰⴷ ⵜⴻⵅⵣⴰⵔⴻⵏⵜ ⵅⵎⵉ ⵜⵜⵖⵉⵎⴰⵏⵜ ⵅ ⵉⵥⵔⴰ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴰⵔⵡⴻⵏⵜ, ⵉⵜⵜⵅⴻⵚⵚⴰ ⴽⴻⵏⵏⵉⵏⵜ ⴰⴷ ⵏⵖⴻⵏⵜ ⴰⵃⴻⵏⵊⵉⵔ ⵎⴰⵍⴰ ⴷ ⵎⵎⵉⵙ, ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⴷ ⵢⴻⴵⵉⵙ, ⵊⵊⴻⵏⵜ ⵜⵜ ⴰⴷ ⵜⴻⴷⴷⴰⵔ!” ");
INSERT INTO rift_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","ⵎⴰⵛⴰ ⵍⵇⴰⴱⵍⴰⵜ ⵜⵓⵖⴰ ⵜⵜⴻⴳⴳⵯⴻⴷⴻⵏⵜ ⴰⵔⴻⴱⴱⵉ, ⵡⴰⵔ ⴳⴳⵉⵏⵜ ⵎⵓⵅⴰⵙ ⵜⴻⵏⵜ ⵢⵓⵎⵓⵔ ⵓⵊⴻⴵⵉⴷ ⵏ ⵎⵉⵚⵔⴰ, ⵎⴰⵛⴰ ⵃⴹⴰⵏⵜ ⵜⵓⴷⴰⵔⵜ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","ⵅⴻⵏⵏⵉ ⵉⵍⴰⵖⴰ ⵓⵊⴻⴵⵉⴷ ⵏ ⵎⵉⵚⵔⴰ ⵉ ⵍⵇⴰⴱⵍⴰⵜ, ⵉⵏⵏⴰ ⴰⵙⴻⵏⵜ: “ⵎⴰⵖⴰⵔ ⵜⴻⴳⴳⵉⵏⵜ ⴰⵢⴰ, ⴰⵇⴰ ⵜⴻⵃⴹⴰⵏⵜ ⵜⵓⴷⴰⵔⵜ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ?” ");
INSERT INTO rift_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","ⵍⵇⴰⴱⵍⴰⵜ ⴰⵔⵔⵉⵏⵜ ⵅ ⴼⵉⵔⵄⵓⵏ: “ⵜⵉⵄⵉⴱⵔⴰⵏⵉⵢⵢⵉⵏ ⵡⴰⵔ ⴵⵉⵏⵜ ⴰⵎ ⵜⵉⵎⵉⵚⵔⵉⵢⵢⵉⵏ, ⵎⵉⵏⵣⵉ ⵏⵉⵜⴻⵏⵜⵉ ⵊⴻⵀⴷⴻⵏⵜ, ⵜⵜⴰⵔⵡⴻⵏⵜ ⵇⴱⴻⵍ ⵎⴰ ⴰⴷ ⵖⴰⵔⵙⴻⵏⵜ ⴷⴷ-ⵜⴰⵙ ⵍⵇⴰⴱⵍⴰ.” ");
INSERT INTO rift_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","ⵓⵛⴰ ⴰⵔⴻⴱⴱⵉ ⵉⴳⴳⴰ ⵎⵍⵉⵃ ⵉ ⵍⵇⴰⴱⵍⴰⵜ ⵓⵛⴰ ⵉⵎⵎⴰⵔⵏⵉ ⵍⴳⴻⵏⵙ, ⴷⴻⵡⵍⴻⵏ ⵊⴻⵀⴷⴻⵏ ⵙ ⵡⴰⵟⵟⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","ⵎⵉⵏⵣⵉ ⵍⵇⴰⴱⵍⴰⵜ ⴳⴳⵯⴻⴷⴻⵏⵜ ⴰⵔⴻⴱⴱⵉ, ⵉⵎⵙⴰⵔ, ⴰⵇⴰ ⵢⴰⵔⵣⴻⵇ ⵉ-ⵜⴻⵏⵜ-ⵉ-ⴷⴷ ⵙ ⵜⵓⴷⵔⵉⵏ ⴰⴽ-ⴷ ⵍⵡⴰⵛⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵢⵓⵎⵓⵔ ⴼⵉⵔⵄⵓⵏ ⵎⴰⵔⵔⴰ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ, ⵉⵏⵏⴰ: “ⴽⵓⵍ ⴰⵃⴻⵏⵊⵉⵔ ⵉ ⴷⴷ ⵖⴰ ⵉⵅⴻⵍⵇⴻⵏ ⴰⴷ ⵜ ⵜⴻⵏⴹⴰⵔⴻⵎ ⴷⴻⴳ ⵉⵖⵣⴰⵔ ⵓ ⵎⴰⵔⵔⴰ ⵜⴰⵃⴻⵏⵊⵉⵔⵜ ⵉ ⴷⴷ ⵖⴰ ⵉⵅⴻⵍⵇⴻⵏ ⴰⴷ ⵜⵜ ⵜⴻⵊⵊⴻⵎ ⴰⴷ ⵜⴻⴷⴷⴰⵔ.”   * ");
INSERT INTO rift_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","ⵓⵛⴰ ⵉⴼⴼⴻⵖ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵣⵉ ⵔⴰⴵ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵍⴰⵡⵉ, ⵢⵉⵡⵉ ⵉⵛⵜ ⵏ ⵜⵃⴻⵏⵊⵉⵔⵜ ⵏ ⵍⴰⵡⵉ ⴷ ⵜⴰⵎⵖⴰⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","ⵜⴻⴽⵙⵉ ⵜⴻⵎⵖⴰⵔⵜ ⵙ ⴷⴷⴻⵢⵙⴻⵜ ⵓⵛⴰ ⵜⵓⵔⵓⵡ-ⴷⴷ ⴰⵃⴻⵏⵊⵉⵔ. ⵓⵎⵉ ⵜⴻⵥⵔⴰ ⴱⴻⵍⵍⵉ ⵉⵚⴱⴻⵃ ⵓⵃⴻⵏⵊⵉⵔ, ⵜⴻⴼⴼⴰⵔ ⵉ-ⵜ ⵜⵍⴰⵜⴰ ⵏ ⵉⵢⵓⵔⴻⵏ.    ");
INSERT INTO rift_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","ⵓⵎⵉ ⵡⴰⵔ ⵜⴻⵣⵎⴰⵔ ⵄⴰⴷ ⴰⴷ ⵜ ⵜⴻⴼⴼⴰⵔ, ⵜⴻⴽⵙⵉ ⴰⵙ-ⴷⴷ ⵉⵛⵜ ⵏ ⵜⵙⴻⵏⴷⵓⵇⵜ ⵏ ⵓⵖⴰⵏⵉⵎ, ⵜⴻⴱⵔⴰ ⵉ-ⵜⵜ ⵙ ⵓⵛⴰⵔⵎⵓⴹ ⴷ ⵜⵉⵣⴻⴼⵜ ⵓⵛⴰ ⵜⴻⵙⵙⴰⵔⵙ ⴷⴰⵢⴻⵙ ⴰⵃⴻⵏⵊⵉⵔ, ⵜⴻⴳⴳⴰ ⵜⴰⵙⴻⵏⴷⵓⵇⵜ ⵏⵏⵉ ⵊⴰⵔ ⵓⵖⴰⵏⵉⵎ ⵅ ⵜⵎⴰ ⵏ ⵉⵖⵣⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","ⵜⴱⴻⴷⴷ ⵡⵓⵍⵜⵎⴰⵙ ⵖⴰⵔ ⵍⴰⴳⴳⵯⴰⵊ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⵥⴰⵔ ⵎⵉⵏ ⵣⵣⴰⵢⴻⵙ ⵖⴰ ⴳⴳⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","ⵓ ⵅⵣⴰⵔ, ⵜⴻⵀⵡⴰ ⵢⴻⴵⵉⵙ ⵏ ⴼⵉⵔⵄⵓⵏ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⴻⵙⵙⵉⵔⴷ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⴷⴻⴳ ⵉⵖⵣⴰⵔ. ⵜⵓⵖⴰ ⵜⵉⵎⵙⴻⵅⵅⴰⵔⵉⵏ ⵜⵉⴱⵍⵉⵖⵉⵏ ⵏⵏⴻⵙ ⴳⴳⵓⵔⴻⵏⵜ ⵅ ⵜⵎⴰ ⵏ ⵉⵖⵣⴰⵔ. ⵏⴻⵜⵜⴰⵜ ⵜⴻⵥⵔⴰ ⵜⴰⵙⴻⵏⴷⵓⵇⵜ ⴷⴻⴳ ⵓⵖⴰⵏⵉⵎ ⵓⵛⴰ ⵜⴻⵙⵙⴻⴽⴽ ⵜⵉⵙⵎⴻⵖⵜ ⵏⵏⴻⵙ ⵓⵛⴰ ⵜⴻⴽⵙⵉ ⵜⵜ-ⵉ-ⴷⴷ. ");
INSERT INTO rift_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","ⴰⵍⴰⵎⵉ ⵜⵜ ⵜⴰⵔⵣⴻⵎ, ⵜⴻⵥⵔⴰ ⴰⵃⴻⵏⵊⵉⵔ ⵏⵏⵉ, ⵓⵛⴰ ⵅⵣⴰⵔ, ⴰⵃⴻⵏⵊⵉⵔ ⵜⵓⵖⴰ ⵉⵜⵜⵔⵓ. ⵢⵓⴷⴻⴼ ⵉ-ⵜⵜ ⵓⵣⵉⴵⴻⵣ, ⵜⴻⵏⵏⴰ: “ⵡⴰ ⴷ ⵉⵊⵊ ⵣⴻⴳ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵉⵄⵉⴱⵔⴰⵏⵉⵢⵢⴻⵏ!” ");
INSERT INTO rift_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵜⴻⵏⵏⴰ ⵓⵍⵜⵎⴰⵙ ⵉ ⵢⴻⴵⵉⵙ ⵏ ⴼⵉⵔⵄⵓⵏ: “ⵎⴰ ⴰⴷ ⵔⴰⵃⴻⵖ ⴰⴷ ⵍⴰⵖⵉⵖ ⵅ ⵉⵛⵜ ⵏ ⵜⴻⵎⵙⵓⴹⴻⴹⵜ ⵣⵉ ⵜⵄⵉⴱⵔⴰⵏⵉⵢⵢⵉⵏ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴰⵎ ⵜⴻⵙⵙⵓⵟⵟⴻⴹ ⴰⵃⴻⵏⵊⵉⵔ?” ");
INSERT INTO rift_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","ⵜⴻⵏⵏⴰ ⴰⵙ ⵢⴻⴵⵉⵙ ⵏ ⴼⵉⵔⵄⵓⵏ: “ⵔⵓⵃ!” ⵜⵔⵓⵃ ⵜⴻⵄⵣⴰⵔⴻⵛⵜ, ⵜⵍⴰⵖⴰ ⵉ ⵢⴻⵎⵎⴰⵙ ⵏ ⵓⵃⴻⵏⵊⵉⵔ. ");
INSERT INTO rift_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵜⴻⵏⵏⴰ ⴰⵙ ⵢⴻⴵⵉⵙ ⵏ ⴼⵉⵔⵄⵓⵏ: “ⴰⵡⵉ-ⴷⴷ ⴰⵃⴻⵏⵊⵉⵔ-ⴰ, ⵜⴻⵙⵙⵓⵟⵟⴻⴹ ⵉ-ⵜ ⵉ ⵏⴻⵛⵛ ⵓ ⵏⴻⵛⵛ ⴰⴷ ⵛⴻⵎ ⵅⴻⴵⵚⴻⵖ.” ⵜⴻⴽⵙⵉ ⵜⴻⵎⵖⴰⵔⵜ ⴰⵃⴻⵏⵊⵉⵔ ⵓⵛⴰ ⵜⴻⵙⵙⵓⵟⵟⴻⴹ ⵉ-ⵜ. ");
INSERT INTO rift_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","ⵓⵎⵉ ⵉⴳⵎⴰ ⵓⵃⴻⵏⵊⵉⵔ, ⵜⵉⵡⵢⵉ ⵉ-ⵜ ⵖⴰⵔ ⵢⴻⴵⵉⵙ ⵏ ⴼⵉⵔⵄⵓⵏ, ⵉⴷⵡⴻⵍ ⴰⵙ ⴰⵎ ⵎⵎⵉⵙ ⵓⵛⴰ ⵜⴻⴳⴳⴰ ⴰⵙ ⵎⵓⵙⴰ, ⵜⴻⵏⵏⴰ: “ⴰⵇⴰ ⵊⴻⴱⴷⴻⵖ ⵜ-ⵉ-ⴷⴷ ⵣⴻⴳ ⵡⴰⵎⴰⵏ.” ");
INSERT INTO rift_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","ⴷⴻⴳ ⵡⵓⵙⵙⴰⵏ ⵏⵏⵉ ⵉⵎⵙⴰⵔ, ⵓⵎⵉ ⵉⴳⵎⴰ ⵎⵓⵙⴰ, ⴰⵇⴰ ⵉⴼⴼⴻⵖ-ⴷⴷ ⵖⴰⵔ ⴰⵢⵜⵎⴰⵙ, ⵓⵛⴰ ⵉⵥⵔⴰ ⴷⴷⵇⵓⵍⴰⵜ ⵉ ⵅⴰⵙⴻⵏ ⵙⵙⴰⵔⴻⴱⴱⵓⵏ. ⵉⵥⵔⴰ ⵉⵊⵊ ⵏ ⵓⵎⵉⵚⵔⵉ ⵉⵛⵛⴰⵜ ⵉⵊⵊ ⵏ ⵓⵄⵉⴱⵔⴰⵏⵉ, ⵉⵊⵊⴻⵏ ⵣⴻⴳ ⴰⵢⵜⵎⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","ⵉⵅⵣⴰⵔ ⴷⴰ ⴷ ⴷⵉⵀⴰ, ⵉⵥⵔⴰ ⴱⴻⵍⵍⵉ ⵡⴰⵔ ⴷⵉⵏ ⵃⴻⴷ, ⵅⴻⵏⵏⵉ ⵉⵏⵖⴰ ⴰⵎⵉⵚⵔⵉ ⵏⵏⵉ ⵓⵛⴰ ⵉⵙⵙⵏⵓⴼⴼⴰⵔ ⵉ-ⵜ ⴷⴻⴳ ⵉⵊⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","ⵓⵎⵉ ⴷⴷ-ⵉⴼⴼⴻⵖ ⵜⵉⵡⴻⵛⵛⴰ ⵏⵏⴻⵙ, ⵉⵥⵔⴰ ⵜⵏⴰⵢⴻⵏ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ ⵉⵄⵉⴱⵔⴰⵏⵉⵢⵢⴻⵏ ⵜⵜⵎⴻⵏⵖⴰⵏ. ⵉⵏⵏⴰ ⵎⵓⵙⴰ ⵉ ⵓⵄⴻⴼⴼⴰⵏ ⵏⵏⵉ ⵉⵜⵜⵄⴻⴷⴷⴰⵏ: “ⵎⴰⵖⴰⵔ ⵜⴻⵛⵛⴰⵜⴻⴷ ⵊⵊⴰⵔ ⵏⵏⴻⵛ?” ");
INSERT INTO rift_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","ⵉⵏⵏⴰ ⵏⴻⵜⵜⴰ: “ⵡⵉ ⵉ ⵛⴻⴽ ⵉⴳⴳⵉⵏ ⴷ ⵍⵃⴰⴽⴻⵎ ⴷ ⵍⵇⴰⴹⵉ ⵅⴰⵏⴻⵖ? ⵎⴰ ⵛⴻⴽ ⵜⴻⵇⵇⴰⵔⴻⴷ ⴰⵢⴰ ⵓⵎⵉ ⵛⴻⴽ ⵜⴻⵏⵡⵉⴷ ⴰⴷ ⴰⵢⵉ ⵜⴻⵏⵖⴻⴷ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⴻⵏⵖⵉⴷ ⴰⵎⵉⵚⵔⵉ?” ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⴳⴳⵯⴻⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: “ⵙ ⵜⵉⴷⴻⵜⵜ ⵜⴰⵎⴻⵙⵍⴰⵛⵜ ⵜᵉⵜⵜⵡⴰⵙⵙⴻⵏ!” ");
INSERT INTO rift_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","ⵓⵎⵉ ⵉⵙⵍⴰ ⴼⵉⵔⵄⵓⵏ ⵎⴰⵏ ⴰⵢⴰ, ⵢⴰⵔⵣⵓ ⴰⴷ ⵉⵏⴻⵖ ⵎⵓⵙⴰ. ⵎⴰⵛⴰ ⵎⵓⵙⴰ ⵢⴰⵔⵡⴻⵍ ⵣⵉ ⴼⵉⵔⵄⵓⵏ ⵓⵛⴰ ⵉⵣⴷⴻⵖ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⴷⵢⴰⵏ ⵓⵛⴰ ⵉⵇⵇⵉⵎ ⴷⵉⵏ ⵖⴰⵔ ⵉⵊⵊ ⵏ ⵡⴰⵏⵓ. ");
INSERT INTO rift_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","ⴰⴽⴻⵀⵀⴰⵏ ⵏ ⵎⵉⴷⵢⴰⵏ ⵜⵓⵖⴰ ⵖⴰⵔⴻⵙ ⵙⴻⴱⵄⴰ ⵏ ⵢⴻⵙⵙⵉⵙ, ⵜⵉⵏⵏⵉ ⵉ ⴷⴷ-ⵢⵓⵙⵉⵏ ⴰⴷ ⴰⵢⵎⴻⵏⵜ ⴰⵎⴰⵏ ⴷⵉⵏ ⵓⵛⴰ ⵛⵛⵓⵔⴻⵏⵜ ⵙⵙⵡⴰⵔⴻⵊ, ⵃⵉⵎⴰ ⴰⴷ ⵡⴰⵔⴷⴻⵏⵜ ⵓⴵⵉ ⵏ ⴱⴰⴱⴰⵜⵙⴻⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","ⵓⵙⵉⵏ-ⴷⴷ ⵉⵎⴻⴽⵙⴰⵡⴻⵏ ⵓⵛⴰ ⵓⵥⵥⵍⴻⵏ ⵅⴰⵙⴻⵏⵜ. ⵉⴽⴽⴰⵔ ⵎⵓⵙⴰ ⵍⴻⵅⴷⴻⵏⵏⵉ, ⵉⴼⴻⴽⴽ ⵉ-ⵜⴻⵏⵜ, ⵉⵡⴰⵔⴷ ⵓⴵⵉ ⵏⵙⴻⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","ⵓⵎⵉ ⴷⴻⵡⵍⴻⵏⵜ ⵖⴰⵔ ⴱⴰⴱⴰⵜⵙⴻⵏⵜ ⵓⵎⵉ ⵇⵇⴰⵔⴻⵏ ⵔⴰⵄⵓⵢⵉⵍ, ⵉⵏⵏⴰ ⴰⵙⴻⵏⵜ: “ⵎⴰⵢⴻⵎⵎⵉ ⴷⴷ-ⵜⵜⵄⴻⵇⴱⴻⵏⵜ ⴰⵙⵙ-ⴰ ⴷⴻⵖⵢⴰ?” ");
INSERT INTO rift_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","ⵏⵉⵜⴻⵏⵜⵉ ⴰⵔⵔⵉⵏⵜ-ⵉ-ⴷⴷ ⵅⴰⵙ: “ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⴷ ⴰⵎⵉⵚⵔⵉ ⵉⴼⴻⴽⴽ ⴰⵏⴻⵖ ⵣⴻⴳ ⵉⴼⴰⵙⵙⴻⵏ ⵏ ⵉⵎⴻⴽⵙⴰⵡⴻⵏ ⵓⵛⴰ ⵄⴰⵡⴻⴷ ⵢⵓⵢⴻⵎ ⴰⵏⴻⵖ-ⴷⴷ ⴰⵟⵟⴰⵙ ⵏ ⵡⴰⵎⴰⵏ ⵓⵛⴰ ⵉⵡⴰⵔⴷ ⵓⴵⵉ.” ");
INSERT INTO rift_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","ⵉⵏⵏⴰ ⵉ ⵢⴻⵙⵙⵉⵙ: “ⵉ ⵎⴰⵏⵉ ⵢⴻⴵⴰ? ⵎⴰⵢⴻⵎⵎⵉ ⵜⴻⵊⵊⵉⵏⵜ ⴰⵔⵢⴰⵣ ⵏⵏⵉ ⴷⵉⵏ? ⵔⵓⵃⴻⵏⵜ ⵍⴰⵖⴰⵏⵜ-ⵉ-ⴷⴷ ⵅⴰⵙ ⵃⵉⵎⴰ ⴰⴷ ⵉⵛⵛ ⴰⵖⵔⵓⵎ!” ");
INSERT INTO rift_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","ⵓⵛⴰ ⵉⵇⴱⴻⵍ ⵎⵓⵙⴰ ⴰⴷ ⵉⵣⴷⴻⵖ ⴰⴽ-ⴷ ⵡⴻⵔⵢⴰⵣ ⵏⵏⵉ ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵉⵡⵛⴰ ⴰⵙ ⵉ ⵎⵓⵙⴰ ⵢⴻⴵⵉⵙ ⵚⴰⴼⴼⵓⵔⴰ ⴷ ⵜⴰⵎⵖⴰⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","ⵜⴻⵊⵊⴰ ⴰⵙ-ⴷⴷ ⴰⵃⴻⵏⵊⵉⵔ, ⵉⴳⴳⴰ ⴰⵙ ⵊⴰⵔⵛⵓⵎ, ⵎⵉⵏⵣⵉ ⵉⵏⵏⴰ: “ⵏⴻⵛⵛ ⵜⵓⵖⴰ ⴰⵢⵉ ⴷ ⴰⵖⵔⵉⴱ ⴷⴻⴳ ⵉⵛⵜ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⴷ ⵜⴰⵖⵔⵉⴱⵜ ⵅⴰⴼⵉ.”    ");
INSERT INTO rift_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","ⵍⴰⵎⵉ ⵜⴻⵄⴷⵓ ⵡⴰⵟⵟⴰⵙ ⵏ ⵍⵡⴻⵇⵜ, ⵉⵎⵎⵓⵜ ⵓⵊⴻⴵⵉⴷ ⵏ ⵎⵉⵚⵔⴰ ⵓⵛⴰ ⵡⴻⵃⵡⴻⵃⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴷⵉ ⵜⴻⵙⵎⵓⵖⵉ ⵉ ⴷⵉ ⵜⵓⵖⴰ ⴷⴷⴰⵔⴻⵏ, ⵙⵙⵖⵓⵢⴻⵏ ⵓⵛⴰ ⵉⵖⵓⵢⵢⴰⵏ ⵏⵙⴻⵏ ⴳⴻⵄⵄⴷⴻⵏ ⵖⴰⵔ ⴰⵔⴻⴱⴱⵉ ⵣⵉ ⵜⴻⵙⵎⵓⵖⵉ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","ⵓⵛⴰ ⵉⵙⵙⵃⴻⵙⵙ ⴰⵔⴻⴱⴱⵉ ⵉ ⵜⵖⵓⵢⵢⵉⵜ ⵏⵙⴻⵏ ⵓⵛⴰ ⵉⵅⴰⵔⵔⴻⵚ ⴰⵔⴻⴱⴱⵉ ⴷⵉ ⵍⵄⴰⵀⴷ ⵏⵏⴻⵙ ⴰⴽ-ⴷ ⵉⴱⵔⴰⵀⵉⵎ ⵓ ⴰⴽ-ⴷ ⵉⵙⵃⴰⵇ ⵓ ⴰⴽ-ⴷ ⵢⴰⵄⵇⵓⴱ. ");
INSERT INTO rift_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","ⵉⵅⵣⴰⵔ ⴰⵔⴻⴱⴱⵉ ⵖⴰⵔ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵛⴰ ⵢⴰⵔⴳⴻⴱ ⴰⵔⴻⴱⴱⵉ ⵅ ⵍⴻⵖⴱⴻⵏ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","ⵢⴰⵔⵡⴻⵙ ⵎⵓⵙⴰ ⵓⴵⵉ ⵏ ⵢⵉⵜⵔⵓ, ⴰⴹⴻⴳⴳⵯⴰⵍ ⵏⵏⴻⵙ, ⴰⴽⴻⵀⵀⴰⵏ ⵏ ⵎⵉⴷⵢⴰⵏ. ⵉⵏⴷⴻⵀ ⵓⴵⵉ ⴰⵡⴰⵔⵏⵉ ⵉ ⵍⴻⵅⵍⴰ ⵓⵛⴰ ⵢⵉⵡⵉⴹ-ⴷⴷ ⵖⴰⵔ ⵡⴻⴷⵔⴰⵔ ⵏ ⴰⵔⴻⴱⴱⵉ, ⵖⴰⵔ ⵃⵓⵔⵉⴱ. ");
INSERT INTO rift_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","ⵉⴱⴰⵏ ⴰⵙ-ⴷⴷ ⵍⵎⴰⵍⴰⴽ ⵏ ⵙⵉⴷⵉ ⴷⴻⴳ ⵉⵊⵊ ⵏ ⵓⵛⴻⵄⵄⵓⵍ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏ ⵉⵊⵊ ⵏ ⵛⴱⴰⵔⵇ ⴰⴽ-ⴷ ⵉⵙⴻⵏⵏⴰⵏⴻⵏ, ⵓ ⵅⵣⴰⵔ, ⵏⴻⵜⵜⴰ ⵉⵥⵔⴰ ⴱⴻⵍⵍⵉ ⵛⴱⴰⵔⵇ ⴰⴽ-ⴷ ⵉⵙⴻⵏⵏⴰⵏⴻⵏ ⵜⵓⵖⴰ ⵜⴻⴽⴽⴰⵔ ⴷⴰⵢⴻⵙ ⵜⵎⴻⵙⵙⵉ, ⵎⴰⵛⴰ ⵛⴱⴰⵔⵇ ⵡⴰⵔ ⵉⵜⵜⵡⴰⵛⵎⴻⴹ ⵛⴰ. ");
INSERT INTO rift_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","ⵉⵏⵏⴰ ⵎⵓⵙⴰ: “ⴻⵊⵊ ⴰⵢⵉ ⴰⴷ ⵇⴻⵡⵙⴻⵖ ⵛⵡⴰⵢⵜ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵥⴰⵔⴻⵖ ⵜⴰⵎⴻⵥⵔⵉⵡⵜ ⵏⵏⵉ ⵜⴰⵎⴻⵇⵇⵔⴰⵏⵜ, ⵎⴰⵢⴻⵎⵎⵉ ⵛⴱⴰⵔⵇ ⴰⴽ-ⴷ ⵉⵙⴻⵏⵏⴰⵏⴻⵏ ⵡⴰⵔ ⵉⵛⴻⵎⵎⴻⴹ ⵛⴰ.” ");
INSERT INTO rift_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","ⵍⴰⵎⵉ ⵉⵥⵔⴰ ⴰⵔⴻⴱⴱⵉ ⴱⴻⵍⵍⵉ ⵉⵊⵊⴰ ⴰⴱⵔⵉⴷ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⵥⴰⵔ ⵎⴰⵏ ⴰⵢⴰ, ⵉⵍⴰⵖⴰ-ⴷⴷ ⵅⴰⵙ ⴰⵔⴻⴱⴱⵉ ⵣⵉ ⵍⵡⴻⵙⵟ ⵏ ⵛⴱⴰⵔⵇ ⴰⴽ-ⴷ ⵉⵙⴻⵏⵏⴰⵏⴻⵏ, ⵉⵏⵏⴰ: “ⵎⵓⵙⴰ, ⵎⵓⵙⴰ!” ⵏⴻⵜⵜⴰ ⵢⴰⵔⵔⴰ: “ⴰⵇⴰ ⴰⵢⵉ ⴷⴰ!” ");
INSERT INTO rift_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵏⴻⵜⵜⴰ: “ⵡⴰⵔ ⴷⴷ-ⵜⵜⵇⴰⵔⵔⴰⴱ ⵛⴰ ⴷⴰⵏⵉⵜⴰ! ⴽⴽⴻⵙ ⵜⵉⵙⵉⵍⴰ ⵏⵏⴻⵛ ⵣⴻⴳ ⵉⴹⴰⵔⴻⵏ ⵏⵏⴻⵛ, ⵎⵉⵏⵣⵉ ⴰⵎⵛⴰⵏ ⵉ ⵅⴻⴼ ⵜⴱⴻⴷⴷⴻⴷ, ⴰⵇⴰ-ⵜ ⴷ ⵜⴰⵎⵎⵓⵔⵜ ⵜⵇⴻⴷⴷⴻⵙ.” ");
INSERT INTO rift_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","ⵉⵏⵏⴰ ⵄⴰⵡⴻⴷ: “ⵏⴻⵛⵛ ⴷ ⴰⵔⴻⴱⴱⵉ ⵏ ⴱⴰⴱⴰⵛ, ⴰⵔⴻⴱⴱⵉ ⵏ ⵉⴱⵔⴰⵀⵉⵎ, ⴰⵔⴻⴱⴱⵉ ⵏ ⵉⵙⵃⴰⵇ ⴷ ⴰⵔⴻⴱⴱⵉ ⵏ ⵢⴰⵄⵇⵓⴱ.” ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⵙⵙⴷⵓⵔⵉⵢ ⵎⵓⵙⴰ ⴰⵖⴻⵎⴱⵓⴱ ⵏⵏⴻⵙ, ⵎⵉⵏⵣⵉ ⵉⴳⴳⵯⴻⴷ ⴰⴷ ⵉⵙⵡⴻⴹ ⴷⵉ ⴰⵔⴻⴱⴱⵉ. ");
INSERT INTO rift_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","ⵉⵏⵏⴰ ⵙⵉⴷⵉ: “ⴰⵇⴰ ⵥⵔⵉⵖ ⵍⵎⴻⵃⵏⴻⵜ ⵉ ⴷⵉ ⵉⴷⴷⴰⵔ ⵍⴳⴻⵏⵙ ⵉⵏⵓ ⵉ ⵉⴵⴰⵏ ⴷⵉ ⵎⵉⵚⵔⴰ ⵓⵛⴰ ⵙⵍⵉⵖ ⵉⵖⵓⵢⵢⴰⵏ ⵏⵙⴻⵏ ⵣⵣⴰⵜ ⵉ ⵉⵎⵣⴻⵢⵢⴰⵔⴻⵏ ⵏⵙⴻⵏ, ⴰⵇⴰ ⵙⵙⵏⴻⵖ ⵜⴰⵎⴰⵔⴰ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","ⵀⵡⵉⵖ-ⴷⴷ ⵃⵉⵎⴰ ⴰⴷ ⴼⴻⴽⴽⴻⵖ ⵍⴳⴻⵏⵙ ⵣⴻⴳ ⵉⴼⴰⵙⵙⴻⵏ ⵏ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ, ⴰⴷ ⵜ ⵙⵙⵓⴼⴼⵖⴻⵖ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⵉ ⵖⴰⵔ ⵉⵛⵜ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵜⴻⵚⴱⴻⵃ ⴷ ⵜⵎⵉⵔⵉⵡⵜ, ⵖⴰⵔ ⵉⵛⵜ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵉⴼⴻⵢⵢⴹⴻⵏ ⵙ ⵓⵖⵉ ⴷ ⵜⴰⵎⵎⴻⵏⵜ, ⵖⴰⵔ ⵡⴻⵎⵛⴰⵏ ⵏ ⴰⵢⵜ ⵏ ⴽⴻⵏⵄⴰⵏ ⴷ ⵉⵃⵉⵜⵜⵉⵢⵢⴻⵏ ⴷ ⵉⵎⵓⵔⵉⵢⵢⴻⵏ ⴷ ⵉⴼⵉⵔⵉⵣⵉⵢⵢⴻⵏ ⴷ ⵉⵃⵉⵡⵉⵢⵢⴻⵏ ⴷ ⵉⵢⵉⴱⵓⵙⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","ⵅⵣⴰⵔ ⵍⴻⵅⵅⵓ, ⴰⵇⴰ ⵜⵉⵡⴻⴹ-ⴷⴷ ⵖⴰⵔⵉ ⵜⵖⵓⵢⵢⵉⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵛⴰ ⵄⴰⵡⴻⴷ ⵥⵔⵉⵖ ⴷⴷⴻⴵ ⵏⵙⴻⵏ ⵉ ⵣⵉ ⵜⴻⵏ ⴷⴻⴵⴻⵏ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","ⵍⴻⵅⵅⵓ ⵅⴻⵏⵏⵉ, ⵔⵓⵃ, ⵏⴻⵛⵛ ⴰⴷ ⵛⴻⴽ ⵙⵙⴻⴽⴽⴻⵖ ⵖⴰⵔ ⴼⵉⵔⵄⵓⵏ ⵓ ⵛⴻⴽ ⴰⴷ ⵜⵙⵓⴼⴼⵖⴻⴷ ⵍⴳⴻⵏⵙ ⵉⵏⵓ, ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵣⵉ ⵎⵉⵚⵔⴰ.” ");
INSERT INTO rift_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵎⵓⵙⴰ ⵉ ⴰⵔⴻⴱⴱⵉ: “ⵎⵉⵏ ⵄⵏⵉⵖ ⵏⴻⵛⵛ ⴰⵍⴰⵎⵉ ⵖⴰ ⵔⴰⵃⴻⵖ ⵖⴰⵔ ⴼⵉⵔⵄⵓⵏ, ⴰⴷ ⵙⵙⵓⴼⴼⵖⴻⵖ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵣⵉ ⵎⵉⵙⵔⴰ?” ");
INSERT INTO rift_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","ⵏⴻⵜⵜⴰ ⵉⵏⵏⴰ ⴰⵙ: “ⵏⴻⵛⵛ ⴰⴷ ⴽⵉⴽ ⵉⵍⵉⵖ ⵓ ⵜⴰⵏⵉⵜⴰ ⴰⴷ ⴰⵛ ⵜⵉⵍⵉ ⴷ ⵍⴻⵄⵍⴰⵎⴻⵜ, ⴱⴻⵍⵍⵉ ⵏⴻⵛⵛ ⵙⵙⴻⴽⴽⴻⵖ-ⴷⴷ ⵛⴻⴽ: ⵅ ⵎⵉⵏⵏⵉ ⵉ ⵖⴰ ⵜⴻⵙⵙⵓⴼⴼⵖⴻⴷ ⵍⴳⴻⵏⵙ-ⴰ ⵣⵉ ⵎⵉⵚⵔⴰ, ⴰⴷ ⵜⵄⴻⴱⴷⴻⵎ ⴰⵔⴻⴱⴱⵉ ⵅ ⵡⴻⴷⵔⴰⵔ-ⴰ.” ");
INSERT INTO rift_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵎⵓⵙⴰ ⵉ ⴰⵔⴻⴱⴱⵉ: “ⵅⵣⴰⵔ, ⵅⵎⵉ ⴷⴷ ⵖⴰ ⴰⵡⴹⴻⵖ ⵏⴻⵛⵛ ⵖⴰⵔ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⴰⴷ ⴰⵙⴻⵏ ⵉⵏⵉⵖ: ‘ⴰⵔⴻⴱⴱⵉ ⵏ ⵍⴻⵊⴷⵓⴷ ⵏⵡⴻⵎ ⵉⵙⵙⴻⴽⴽ ⴰⵢⵉ-ⴷⴷ ⵖⴰⵔⵡⴻⵎ!’, ⵓⵛⴰ ⵏⵉⵜⵏⵉ ⴰⴷ ⴰⵢⵉ ⵙⵙⴻⵇⵙⴰⵏ: ‘ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵙ ⵇⵇⴰⵔⴻⵏ?’, ⵎⵉⵏ ⴷ ⴰⵙⴻⵏ ⵖⴰ ⵉⵏⵉⵖ ⵅⴻⵏⵏⵉ?” ");
INSERT INTO rift_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","ⵉⵏⵏⴰ ⴰⵔⴻⴱⴱⵉ ⵉ ⵎⵓⵙⴰ: “ⵏⴻⵛⵛ ⴷ ⵏⴻⵛⵛ ⵉ ⴵⵉⵖ”. ⵓⵛⴰ ⵉⵏⵏⴰ ⵄⴰⵡⴻⴷ: “ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵜⵉⵏⵉⴷ ⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ: ⵏⴻⵛⵛ ⴷ ⵏⴻⵛⵛ ⵉ ⴵⵉⵖ! ⴰⵇⴰ ⵏⴻⵜⵜⴰ ⴷ ⵡⴻⵏⵏⵉ ⴷ ⴰⵢⵉ ⴷⴷ-ⵉⵙⵙⴻⴽⴽⴻⵏ ⵖⴰⵔⵡⴻⵎ.” ");
INSERT INTO rift_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","ⵉⵏⵏⴰ ⴰⵔⴻⴱⴱⵉ ⵄⴰⵡⴻⴷ ⵉ ⵎⵓⵙⴰ: “ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵜⵉⵏⵉⴷ ⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ: ‘ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏ ⵍⴻⵊⴷⵓⴷ ⵏⵡⴻⵎ, ⴰⵔⴻⴱⴱⵉ ⵏ ⵉⴱⵔⴰⵀⵉⵎ ⴷ ⴰⵔⴻⴱⴱⵉ ⵏ ⵉⵙⵃⴰⵇ ⴷ ⴰⵔⴻⴱⴱⵉ ⵏ ⵢⴰⵄⵇⵓⴱ, ⵉⵙⵙⴻⴽⴽ ⴰⵢⵉ-ⴷⴷ ⵖⴰⵔⵡⴻⵎ. ⴷ ⵡⴰ ⴷ ⵉⵙⴻⵎ ⵉⵏⵓ ⵉ ⵍⴻⴱⴷⴰ ⵓ ⵢⵉⵙⴻⵎ ⵡⴰⵏⵉⵜⴰ ⴰⴷ ⵢⵉⵍⵉ ⵉ ⵍⵉⴷⴰⵔⴻⵜ ⴷⴰⵢⵉ ⵣⵉ ⵊⵊⵉⵍ ⴰⵍ ⵊⵊⵉⵍ.’ ");
INSERT INTO rift_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","ⵔⵓⵃ, ⵜⴻⵙⵙⵎⵓⵏⴻⴷ ⵉⵎⵖⴰⵔⴻⵏ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵉⵏⵉ ⴰⵙⴻⵏ: ‘ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏ ⵍⴻⵊⴷⵓⴷ ⵏⵡⴻⵎ, ⴰⵔⴻⴱⴱⵉ ⵏ ⵉⴱⵔⴰⵀⵉⵎ ⴷ ⵉⵙⵃⴰⵇ ⴷ ⵢⴰⵄⵇⵓⴱ ⵉⴱⴰⵏ ⴰⵢⵉ-ⴷⴷ, ⵉⵏⵏⴰ: ‘ⴰⵇⴰ ⵅⴰⵡⴻⵎ ⵃⵉⵏⵏⴻⵖ ⵓⵛⴰ ⵥⵔⵉⵖ ⵎⵉⵏ ⵅⴰⵡⴻⵎ ⵙⵙⴻⵄⴷⵓⵏ ⴷⵉ ⵎⵉⵚⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","ⵏⵏⵉⵖ: ⵏⴻⵛⵛ ⴰⴷ ⴽⴻⵏⵏⵉⵡ ⵙⵙⵓⴼⴼⵖⴻⵖ ⵣⵉ ⵍⵎⴻⵃⵏⴻⵜ ⴷⵉ ⵎⵉⵚⵔⴰ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴰⵢⵜ ⵏ ⴽⴻⵏⵄⴰⵏ ⴷ ⵉⵃⵉⵜⵜⵉⵢⵢⴻⵏ ⴷ ⵉⵎⵓⵔⵉⵢⵢⴻⵏ ⴷ ⵉⴼⵉⵔⵉⵣⵉⵢⵢⴻⵏ ⴷ ⵉⵃⵉⵡⵉⵢⵢⴻⵏ ⴷ ⵉⵢⵉⴱⵓⵙⵉⵢⵢⴻⵏ, ⵖⴰⵔ ⵉⵛⵜ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵉⴼⴻⵢⵢⴹⴻⵏ ⵙ ⵓⵖⵉ ⴷ ⵜⴰⵎⵎⴻⵏⵜ.’ ");
INSERT INTO rift_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","ⴰⴷ ⵙⵍⴻⵏ ⵉ ⵜⵎⵉⵊⵊⴰ ⵏⵏⴻⵛ, ⵓⵛⴰ ⴰⴷ ⵜⵔⴰⵃⴻⴷ, ⵛⴻⴽ ⴷ ⵉⵎⵖⴰⵔⴻⵏ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵖⴰⵔ ⵓⵊⴻⴵⵉⴷ ⵏ ⵎⵉⵚⵔⴰ, ⴰⴷ ⴰⵙ ⵜⵉⵏⵉⵎ: ‘ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏ ⵉⵄⵉⴱⵔⴰⵏⵉⵢⵢⴻⵏ, ⵉⵎⵙⴰⴳⴰⵔ ⴰⴽⵉⴷⵏⴻⵖ. ⵅⴻⵏⵏⵉ ⵍⴻⵅⵅⵓ, ⴻⵊⵊ ⴰⵏⴻⵖ ⴰⴷ ⵏⴻⵟⵟⴻⴼ ⴰⴱⵔⵉⴷ ⵜⵉⵛⵍⵉ ⵏ ⵜⵍⴰⵜⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⴷⵉ ⵍⴻⵅⵍⴰ, ⵃⵉⵎⴰ ⴰⴷ ⵏⵇⴻⴷⴷⴻⵎ ⵜⵉⵖⴰⵔⵚⴰ ⵉ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵖ.’ ");
INSERT INTO rift_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","ⵎⴰⵛⴰ ⵏⴻⵛⵛ ⵙⵙⵏⴻⵖ ⴱⴻⵍⵍⵉ ⴰⵊⴻⴵⵉⴷ ⵏ ⵎⵉⵚⵔⴰ ⵡⴰⵔ ⴽⴻⵏⵏⵉⵡ ⵉⵜⵜⴻⵊⵊⵉ ⴰⴷ ⵜⵔⴰⵃⴻⵎ ⵓⵍⴰ ⵙ ⵓⴼⵓⵙ ⵉⵊⴻⵀⴷⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","ⵅⴻⵏⵏⵉ ⴰⴷ ⵙⵙⵡⵉⵥⵥⴹⴻⵖ ⴰⴼⵓⵙ ⵉⵏⵓ, ⴰⴷ ⵡⵜⴻⵖ ⵎⵉⵚⵔⴰ ⵙ ⵎⴰⵔⵔⴰ ⵍⵎⵓⵄⵊⵉⵣⴰⵜ ⵉⵏⵓ ⵉ ⴷⴰⵢⴻⵙ ⵉ ⵖⴰ ⴳⴳⴻⵖ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏⵏⴻⵙ, ⵓⵛⴰ ⴰⵡⴰⵔⵏⵉ ⵉ ⵎⴰⵏ ⴰⵢⴰ, ⵏⴻⵜⵜⴰ ⴰⴷ ⴽⴻⵏⵏⵉⵡ ⵢⴻⵊⵊ ⴰⴷ ⵜⵔⴰⵃⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","ⴰⴷ ⵃⵉⵏⵏⴻⵖ ⵅ ⵍⴳⴻⵏⵙ-ⴰ ⵣⵣⴰⵜ ⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ ⵓⵛⴰ ⴰⴷ ⵉⵎⵙⴰⵔ, ⵅⵎⵉ ⵖⴰ ⵜⵔⴰⵃⴻⵎ, ⵡⴰⵔ ⵜᵉⵜⵜⴻⴼⴼⵖⴻⵎ ⵛⴰ ⵙ ⵉⴼⴰⵙⵙⴻⵏ ⵅⵡⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","ⴰⴷ ⵜᵉⵜⵜⴰⵔ ⴽⵓⵍ ⵜⴰⵎⵖⴰⵔⵜ ⵣⵉ ⵜⴰⵊⵊⴰⵔⵜ ⵏⵏⴻⵙ ⵓ ⵣⵉ ⵜⴱⴰⵔⵔⴰⵏⵉⵜ ⵏⵏⵉ ⴰⴽⵉⴷⴻⵙ ⵉⵣⴻⴷⴷⵖⴻⵏ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ, ⵍⴻⵇⵛⵓⵄ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⴷ ⵡⵓⵔⴻⵖ ⴷ ⵡⴰⵔⵔⵓⴹ, ⵓⵛⴰ ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⵜⴻⵏ ⵜⴻⴳⴳⴻⵎ ⵅ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⴷ ⵜⵃⴻⵏⵊⵉⵔⵉⵏ ⵏⵡⴻⵎ, ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵜⴽⴻⵛⵛⴹⴻⵎ ⵎⵉⵚⵔⴰ.” ");
INSERT INTO rift_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","ⵅⴻⵏⵏⵉ ⵢⴰⵔⵔⴰ-ⴷⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: “ⵅⵣⴰⵔ, ⵏⵉⵜⵏⵉ ⵡⴰⵔ ⴷⴰⵢⵉ ⵜⵜⵉⵎⵏⴻⵏ ⵛⴰ ⵓⵛⴰ ⵡⴰⵔ ⵜⵜⴻⵙⵍⵉⵏ ⵛⴰ ⵉ ⵡⴰⵡⴰⵍ ⵉⵏⵓ, ⵎⵉⵏⵣⵉ ⴰⴷ ⵉⵏⵉⵏ: ‘ⵙⵉⴷⵉ ⵡⴰⵔ ⴷ ⴰⵛ ⴷⴷ-ⵉⴱⴰⵏ ⵛⴰ!’” ");
INSERT INTO rift_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⴰⵙ ⵙⵉⴷⵉ: “ⵎⵉⵏ ⵖⴰⵔⴻⴽ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏⵏⴻⵛ?” ⵓⵛⴰ ⵢⴰⵔⵔⴰ-ⴷⴷ: “ⴷ ⵜⴰⵖⵖⴰⵔⵛⵜ.” ");
INSERT INTO rift_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","ⵉⵏⵏⴰ: “ⵏⴹⴰⵔ ⵉ-ⵜⵜ ⵅ ⵜⴻⵎⵎⵓⵔⵜ!” ⵉⵏⴹⴰⵔ ⵉ-ⵜⵜ ⵅ ⵜⴻⵎⵎⵓⵔⵜ, ⵜⴻⴷⵡⴻⵍ ⴷ ⵉⵊⵊ ⵓⴼⵉⵖⴰⵔ ⵓⵛⴰ ⵢⴰⵔⵡⴻⵍ ⵎⵓⵙⴰ ⵣⵣⴰⵢⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⵙⵡⵉⵥⵥⴻⴹ ⴰⴼⵓⵙ ⵏⵏⴻⵛ, ⵟⵟⴻⴼ ⵉ-ⵜⵜ ⵣⴻⴳ ⵓⵏⴻⵡⵡⴰⵔ ⵏⵏⴻⵙ ...” - ⵓⵛⴰ ⵉⵙⵙⵡⵉⵥⵥⴻⴹ ⵎⵓⵙⴰ ⴰⴼⵓⵙ ⵏⵏⴻⵙ, ⵉⵟⵟⴻⴼ ⵉ-ⵜⵜ ⵓⵛⴰ ⵜⴻⴷⵡⴻⵍ ⵄⴰⵡⴻⴷ ⴷ ⵜⴰⵖⵖⴰⵔⵛⵜ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏⵏⴻⵙ - ");
INSERT INTO rift_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“... ⵃⵉⵎⴰ ⴰⴷ ⴰⵎⵏⴻⵏ ⴱⴻⵍⵍⵉ ⴰⵇⴰ ⵉⴱⴰⵏ ⴰⵛ-ⴷⴷ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏ ⵍⴻⵊⴷⵓⴷ ⵏⵙⴻⵏ, ⴰⵔⴻⴱⴱⵉ ⵏ ⵉⴱⵔⴰⵀⵉⵎ, ⴰⵔⴻⴱⴱⵉ ⵏ ⵉⵙⵃⴰⵇ ⴷ ⴰⵔⴻⴱⴱⵉ ⵏ ⵢⴰⵄⵇⵓⴱ.” ");
INSERT INTO rift_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","ⵉⵏⵏⴰ ⴰⵙ ⵙⵉⴷⵉ ⵄⴰⵡⴻⴷ: “ⵙⵉⴷⴻⴼ ⴰⴼⵓⵙ ⵏⵏⴻⵛ ⴷⴻⴳ ⵡⴻⵃⵙⵉⵏ ⵏⵏⴻⵛ.” ⵓⵛⴰ ⵉⵙⵙⵉⴷⴻⴼ ⴰⴼⵓⵙ ⵏⵏⴻⵙ ⴷⴻⴳ ⵡⴻⵃⵙⵉⵏ ⵓⵛⴰ ⵓⵎⵉ ⵜ-ⵉ-ⴷⴷ-ⵉⴽⴽⴻⵙ, ⵅⵣⴰⵔ, ⴰⴼⵓⵙ ⵏⵏⴻⵙ ⵉⴱⴰⵔⵚ ⴰⵎ ⵡⴻⴷⴼⴻⵍ. ");
INSERT INTO rift_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","ⵓⵛⴰ ⵉⵏⵏⴰ: “ⴰⵔⵔ ⴰⴼⵓⵙ ⵏⵏⴻⵛ ⵄⴰⵡⴻⴷ ⴷⴻⴳ ⵡⴻⵃⵙⵉⵏ!” ⵢⴰⵔⵔⴰ ⴰⴼⵓⵙ ⵏⵏⴻⵙ ⴷⴻⴳ ⵡⴻⵃⵙⵉⵏ ⵓⵛⴰ ⵉⵄⵇⴻⴱ ⵉⵙⵙⵓⴼⴼⴻⵖ ⵉ-ⵜ-ⵉ-ⴷⴷ ⵄⴰⵡⴻⴷ ⵣⴻⴳ ⵡⴻⵃⵙⵉⵏ, ⵓⵛⴰ ⵅⵣⴰⵔ, ⵉⴷⵡⴻⵍ ⵄⴰⵡⴻⴷ ⴰⵎ ⵎⵉⵏ ⵉⵇⵇⵉⵎⴻⵏ ⵏ ⴰⵔⵔⵉⵎⴻⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","“ⵎⴰⵍⴰ ⵡⴰⵔ ⵣⵣⴰⵢⴻⴽ ⵓⵎⵉⵏⴻⵏ ⵛⴰ ⵓ ⵡⴰⵔ ⵖⴰⵔⴻⴽ ⴷⴷ-ⵜⵜⴻⵙⵍⵉⵏ ⵉ ⵎⵉⵏ ⴷ ⴰⵙⴻⵏ ⵉ ⵖⴰ ⵜⵉⵏⵉ ⵍⴻⵄⵍⴰⵎⴻⵜ ⵜⴰⵎⴻⵣⵡⴰⵔⵓⵜ, ⵅⴻⵏⵏⵉ ⴰⴷ ⴰⵎⵏⴻⵏ ⴷⵉ ⵎⵉⵏ ⴷ ⴰⵙⴻⵏ ⵖⴰ ⵜⵉⵏⵉ ⵍⴻⵄⵍⴰⵎⴻⵜ ⵜⴰⵏⴻⴳⴳⴰⵔⵓⵜ. ");
INSERT INTO rift_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","ⵎⴰⵍⴰ ⵏⵉⵜⵏⵉ ⵡⴰⵔ ⵓⵎⵉⵏⴻⵏ ⵛⴰ ⴷⵉ ⵜⵏⴰⵢⴻⵏ ⵏ ⵍⴻⵄⵍⴰⵎⴰⵜ-ⴰ ⵓ ⵡⴰⵔ ⴷ ⴰⵛ ⵙⵍⵉⵏ ⵛⴰ, ⵅⴻⵏⵏⵉ ⴽⵙⵉ ⴰⵎⴰⵏ ⵏ ⵉⵖⵣⴰⵔ ⵓⵛⴰ ⴼⴰⵔⵔⴻⵖ ⵉ-ⵜⴻⵏ ⵅ ⵍⴰⵥⴰⵖ ⵓ ⴰⵎⴰⵏ ⵏⵏⵉ ⵜⴻⴽⵙⵉⴷ ⵣⴻⴳ ⵉⵖⵣⴰⵔ ⴰⴷ ⴷⴻⵡⵍⴻⵏ ⴷ ⵉⴷⴰⵎⵎⴻⵏ ⵅ ⵍⴰⵥⴰⵖ.” ");
INSERT INTO rift_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵎⵓⵙⴰ ⵉ ⵙⵉⴷⵉ: “ⴰ ⵙⵉⴷⵉ ⵉⵏⵓ!, ⵏⴻⵛⵛ ⵡⴰⵔ ⴵⵉⵖ ⵛⴰ ⴷ ⴰⵔⵢⴰⵣ ⵏ ⴱⵓ-ⵜⴰⵡⴰⵍⵉⵏ, ⵉⴹⴻⵏⵏⴰⴹ ⵍⵍⴰ, ⵓⵍⴰ ⴷ ⴼⴰⵔⵉⴹⴻⵏⵏⴰⴹ ⵍⵍⴰ ⵓ ⵣⴻⴳ ⵡⴰⵎⵉ ⵜⴻⴱⴷⵉⴷ ⴰⴷ ⵜⴻⵙⵙⵉⵡⵍⴻⴷ ⴰⴽ-ⴷ ⵓⵎⵙⴻⵅⵅⴰⵔ ⵏⵏⴻⵛ ⵍⵍⴰ, ⵎⵉⵏⵣⵉ ⵏⴻⵛⵛ ⵖⴰⵔⵉ ⴰⵇⴻⵎⵎⵓⵎ ⵉⴷⴻⵇⵍⴻⵏ ⴷ ⵉⵍⴻⵙ ⵉⴷⴻⵇⵍⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","ⵉⵏⵏⴰ ⴰⵙ ⵙⵉⴷⵉ: “ⵡⵉ ⵉⵡⵛⵉⵏ ⴰⵇⴻⵎⵎⵓⵎ ⵉ ⴱⵏⴰⴷⴻⵎ? ⵏⵉⵖ ⵡⵉ ⵉⴳⴳⵉⵏ ⵃⴻⴷ ⴷ ⴰⵣⵉⵢⵏⵓⵏ ⵏⵉⵖ ⴷ ⴰⴷⴻⵀⵛⵓⵔ ⵏⵉⵖ ⴷ ⵡⴻⵏⵏⵉ ⵉⵜⵜⵡⴰⵍⴰⵏ ⵏⵉⵖ ⴷ ⴰⴷⴰⵔⵖⴰⵍ? ⵎⴰ ⵡⴰⵔ ⵉⴵⵉ ⴷ ⵏⴻⵛⵛ, ⵙⵉⴷⵉ? ");
INSERT INTO rift_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","ⵍⴻⵅⵅⵓ, ⵔⵓⵃ ⴷⵉⵏ, ⴰⴷ ⵉⵍⵉⵖ ⴰⴽ-ⴷ ⵓⵇⴻⵎⵎⵓⵎ ⵏⵏⴻⵛ, ⴰⴷ ⴰⵛ ⵙⵙⴻⵛⵏⴻⵖ ⵎⵍⵉⵃ ⵎⵉⵏ ⵖⴰ ⵜⵉⵏⵉⴷ.” ");
INSERT INTO rift_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","ⵎⴰⵛⴰ ⵏⴻⵜⵜⴰ ⵉⵏⵏⴰ: “ⴰ ⵙⵉⴷⵉ ⵉⵏⵓ, ⵙⴻⴽⴽ ⵙ ⵓⴼⵓⵙ ⵏⵏⴻⵛ ⵎⴰⵏ ⵡⴻⵏ ⵉ ⵜⴻⵅⵙⴻⴷ ⴰⴷ ⵜⴻⵙⵙⴻⴽⴽⴻⴷ.” ");
INSERT INTO rift_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⵜⵜⵡⴰⵙⵙⴰⵔⵖ ⵡⴻⵖⴹⴰⴱ ⵏ ⵙⵉⴷⵉ ⵅ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: “ⵎⴰ ⵡⴰⵔ ⵉⴵⵉ ⵀⴰⵔⵓⵏ, ⴰⵍⴰⵡⵉ, ⴷ ⵓⵎⴰⵛ? ⵏⴻⵛⵛ ⵙⵙⵏⴻⵖ, ⴰⵇⴰ ⵏⴻⵜⵜⴰ ⵉⵙⵙⴻⵏ ⴰⴷ ⵉⵙⵙⵉⵡⴻⵍ. ⵅⵣⴰⵔ, ⴰⵇⴰ ⴰⴷ ⴽⵉⵛ ⵉⵎⵙⴰⴳⴰⵔ ⵓ ⵅⵎⵉ ⵛⴻⴽ ⵖⴰ ⵉⵥⴰⵔ, ⴰⴷ ⵉⴼⴰⵔⵃ ⵡⵓⵍ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","ⵓⵛⴰ ⵛⴻⴽ ⴰⴷ ⴽⵉⵙ ⵜⴻⵙⵙⵉⵡⵍⴻⴷ, ⴰⴷ ⴰⵙ ⵜⴻⴳⴳⴻⴷ ⴰⵡⴰⵍⴻⵏ ⴷⴻⴳ ⵓⵇⴻⵎⵎⵓⵎ ⵏⵏⴻⵙ. ⴳⴳⵓⵔ ⴰⴷ ⵉⵍⵉⵖ ⴰⴽ-ⴷ ⵓⵇⴻⵎⵎⵓⵎ ⵏⵏⴻⵛ ⴷ ⵓⵇⴻⵎⵎⵓⵎ ⵏⵏⴻⵙ, ⴰⴷ ⴰⵡⴻⵎ ⵙⵙⵖⴰⵔⴻⵖ ⵎⵉⵏ ⵖⴰ ⵜⵉⵏⵉⵎ. ");
INSERT INTO rift_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","ⵏⴻⵜⵜⴰ ⴰⴷ ⵉⵙⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⵍⴳⴻⵏⵙ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏⵏⴻⵛ. ⴰⴷ ⵉⵎⵙⴰⵔ ⴰⵎⵎⵓ: ⵏⴻⵜⵜⴰ ⴰⴷ ⴰⵛ ⵢⵉⵍⵉ ⴰⵎⴻⵛⵏⴰⵡ ⴰⵇⴻⵎⵎⵓⵎ ⵏⵏⴻⵛ ⵓ ⵛⴻⴽ ⴰⴷ ⵜⵉⵍⵉⴷ ⵉ ⵏⴻⵜⵜⴰ ⴰⵎⴻⵛⵏⴰⵡ ⴰⵔⴻⴱⴱⵉ. ");
INSERT INTO rift_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","ⴰⴷ ⵜⴻⴽⵙⵉⴷ ⵜⴰⵖⵖⴰⵔⵛⵜ-ⴰ ⵉ ⵣⵉ ⵖⴰ ⵜⴻⴳⴳⴻⴷ ⵍⴻⵄⵍⴰⵎⴰⵜ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏⵏⴻⵛ.” ");
INSERT INTO rift_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","ⵉⵔⵓⵃ ⵎⵓⵙⴰ ⵓⵛⴰ ⵉⴷⵡⴻⵍ ⵖⴰⵔ ⵓⴹⴻⴳⴳⵯⴰⵍ ⵏⵏⴻⵙ ⵢⵉⵜⵔⵓ, ⵉⵏⵏⴰ ⴰⵙ: “ⴻⵊⵊ ⴰⵢⵉ ⴰⴷ ⵔⴰⵃⴻⵖ, ⴰⴷ ⵄⴻⵇⴱⴻⵖ ⵖⴰⵔ ⴰⵢⵜⵎⴰ ⵏⵏⵉ ⵉⴵⴰⵏ ⴷⵉ ⵎⵉⵚⵔⴰ, ⵃⵉⵎⴰ ⴰⴷ ⵥⴰⵔⴻⵖ, ⵎⴰ ⵄⴰⴷ ⴷⴷⴰⵔⴻⵏ.” ⵉⵏⵏⴰ ⵢⵉⵜⵔⵓ ⵉ ⵎⵓⵙⴰ: “ⵔⵓⵃ ⴷⵉ ⵍⴻⵀⵏⴰ.” ");
INSERT INTO rift_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵄⴰⵡⴻⴷ ⵉ ⵎⵓⵙⴰ ⴷⵉ ⵎⵉⴷⵢⴰⵏ: “ⵍⵓⵃ, ⵜⴷⴻⵡⵍⴻⴷ ⵖⴰⵔ ⵎⵉⵚⵔⴰ, ⵎⵉⵏⵣⵉ ⴰⵇⴰ ⵎⵎⵓⵜⴻⵏ ⵎⴰⵔⵔⴰ ⵉⵏⵏⵉ ⵜⵓⵖⴰ ⵢⴰⵔⴻⵣⵣⵓⵏ ⵍⵎⴻⵡⵜ ⵏⵏⴻⵛ.” ");
INSERT INTO rift_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","ⵉⴽⵙⵉ ⵎⵓⵙⴰ ⵜⴰⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⵙⵙⴻⵏⵢⴰ ⵉ-ⵜⴻⵏ ⵅ ⵡⴻⵖⵢⵓⵍ, ⵉⴷⵡⴻⵍ-ⴷⴷ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⵓⵛⴰ ⵉⴽⵙⵉ ⵎⵓⵙⴰ ⵜⴰⵖⵖⴰⵔⵛⵜ ⵏ ⴰⵔⴻⴱⴱⵉ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⵅⵎⵉ ⵖⴰ ⵜⵔⴰⵃⴻⴷ, ⴰⴷ ⴷⴷ-ⵜⴷⴻⵡⵍⴻⴷ ⵄⴰⵡⴻⴷ ⵖⴰⵔ ⵎⵉⵚⵔⴰ, ⵅⵣⴰⵔ ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵉ ⴼⵉⵔⵄⵓⵏ ⵎⴰⵔⵔⴰ ⵍⵎⵓⵄⵊⵉⵣⴰⵜ ⵏⵏⵉ ⴷ ⴰⵛ ⴳⴳⵉⵖ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏⵏⴻⵛ. ⵎⴰⵛⴰ ⵏⴻⵛⵛ ⴰⴷ ⵙⵙⵇⴻⵙⵃⴻⵖ ⵓⵍ ⵏⵏⴻⵙ, ⵍⴰⵎⵉ ⵡⴰⵔ ⵉⵅⵙ ⴰⴷ ⵉⴹⵍⴻⵇ ⵉ ⵍⴳⴻⵏⵙ. ");
INSERT INTO rift_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⵉⵏⵉⴷ ⵉ ⴼⵉⵔⵄⵓⵏ: ‘ⴰⵎⵎⵓ ⵉ ⵉⵇⵇⴰⵔ ⵙⵉⴷⵉ: ⵉⵙⵔⴰⵉⵍ ⴷ ⵎⵎⵉ ⴷ ⴰⵎⴻⵏⵣⵓ ⵉⵏⵓ. ");
INSERT INTO rift_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","ⴰⵇⴰ ⵏⵏⵉⵖ ⴰⵛ: ⴻⵊⵊ ⴰⴷ ⵉⴼⴼⴻⵖ ⵎⵎⵉ ⴰⴷ ⴰⵢⵉ ⵉⵄⴱⴻⴷ! ⵎⴰⵛⴰ ⵛⴻⴽ ⵜⵓⴳⵉⴷ ⴰⴷ ⵜ ⵜⴻⵊⵊⴻⴷ. ⵅⵣⴰⵔ, ⵏⴻⵛⵛ ⴰⴷ ⵏⵖⴻⵖ ⵎⵎⵉⵛ, ⴰⵎⴻⵏⵣⵓ ⵏⵏⴻⵛ.’” ");
INSERT INTO rift_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","ⵉⵎⵙⴰⵔ ⴷⴻⴳ ⵡⴻⴱⵔⵉⴷ, ⴷⴻⴳ ⵉⵊⵊ ⵏ ⵡⴻⵎⵛⴰⵏ ⵎⴰⵏⵉ ⵖⴰ ⵙⵙⴻⵏⵙⴻⵏ, ⵉⵎⵎⴻⵍⵇⴰ ⵙⵉⴷⵉ ⴰⴽⵉⴷⴻⵙ ⵓ ⵏⴻⵜⵜⴰ ⵜⵓⵖⴰ ⵉⵅⵙ ⴰⴷ ⵜ ⵉⵏⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵜⴻⴽⵙⵉ ⵚⴰⴼⴼⵓⵔⴰ ⵉⵛⵜ ⵏ ⵜⵅⴻⴷⵎⴻⵛⵜ ⵏ ⵡⴻⵥⵔⵓ, ⵜⴻⵅⵜⴻⵏ ⵍⴻⵄⴷⴰⵍⵢⴻⵜ ⵏ ⵎⵎⵉⵙ ⵓⵛⴰ ⵜⴻⵍⵇⴻⴼ ⴰⵙ ⵉⴹⴰⵔⴻⵏ ⵏⵏⴻⵙ, ⵜⴻⵏⵏⴰ: “ⵙ ⵜⵉⴷⴻⵜⵜ ⵛⴻⴽ ⵜⴻⴵⵉⴷ ⴰⵎ ⵢⵉⵊⵊ ⵏ ⵢⴻⵙⵍⵉ ⵏ ⵉⴷⴰⵎⵎⴻⵏ ⵉ ⵏⴻⵛⵛ” ");
INSERT INTO rift_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","ⵉⵊⵊⴰ ⵉ-ⵜ ⵅⴻⵏⵏⵉ. ⵍⴻⵅⴹⴻⵏⵏⵉ ⵜⴻⵏⵏⴰ: “ⵛⴻⴽ ⴷ ⵉⵙⵍⵉ ⵏ ⵉⴷⴰⵎⵎⴻⵏ ⵉ ⵜⴻⴵⵉⴷ!”, ⴷⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⵉⵅⵜⴰⵏⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵀⴰⵔⵓⵏ: “ⵔⵓⵃ ⴰⴷ ⵜⴻⵍⵇⵉⴷ ⵎⵓⵙⴰ ⴷⵉ ⵍⴻⵅⵍⴰ!” ⵓⵛⴰ ⵉⵔⵓⵃ, ⵉⵎⵙⴰⴳⴰⵔ ⴰⴽⵉⴷⴻⵙ ⵖⴰⵔ ⵡⴻⴷⵔⴰⵔ ⵏ ⴰⵔⴻⴱⴱⵉ, ⵉⵙⵙⵓⴷⴻⵎ ⵉ-ⵜ. ");
INSERT INTO rift_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","ⵉⵅⴻⴱⴱⴰⵔ ⵎⵓⵙⴰ ⵀⴰⵔⵓⵏ ⵅ ⵎⴰⵔⵔⴰ ⴰⵡⴰⵍⴻⵏ ⵉ ⴷ ⴰⵙ ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵡⴻⵏⵏⵉ ⵉ-ⵜ-ⵉ-ⴷⴷ-ⵉⵙⵙⴻⴽⴽⴻⵏ ⵓⵍⴰ ⵅ ⵎⴰⵔⵔⴰ ⵍⴻⵄⵍⴰⵎⴰⵜ ⵉ ⴷ ⴰⵙ ⵢⵓⵎⵓⵔ ⴰⴷ ⵉⴳⴳ. ");
INSERT INTO rift_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","ⵅⴻⵏⵏⵉ ⵉⵔⵓⵃ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ, ⵙⵙⵎⵓⵏⴻⵏ ⵎⴰⵔⵔⴰ ⵉⵎⵖⴰⵔⴻⵏ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ");
INSERT INTO rift_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","ⵓⵛⴰ ⵉⵙⵙⵉⵡⴻⵍ ⵀⴰⵔⵓⵏ ⵙ ⵎⴰⵔⵔⴰ ⴰⵡⴰⵍⴻⵏ ⵉ ⵜⵓⵖⴰ ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ ⵓⵛⴰ ⵉⴳⴳⴰ ⵍⴻⵄⵍⴰⵎⴰⵜ ⵇⵉⴱⴰⵍⵜ ⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵍⴳⴻⵏⵙ. ");
INSERT INTO rift_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","ⵓⵛⴰ ⵢⵓⵎⴻⵏ ⵣⵣⴰⵢⵙⴻⵏ ⵍⴳⴻⵏⵙ, ⵙⵍⵉⵏ ⴱⴻⵍⵍⵉ ⵙⵉⴷⵉ ⵉⵣⵣⵉⴵⴻⵣ ⴰⵙ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵎⵉ ⵉⵥⵔⴰ ⵍⵎⴻⵃⵏⴻⵜ ⵉ ⴷⵉ ⴵⴰⵏ, ⵓⴹⴰⵔⴻⵏ ⵓⵛⴰ ⴱⴻⵏⴷⵇⴻⵏ ⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","ⴰⵡⴰⵔⵏⵉ ⵎⴰⵏ ⴰⵢⴰ ⵢⵓⴷⴻⴼ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ ⵖⴰⵔ ⴼⵉⵔⵄⵓⵏ, ⵏⵏⴰⵏ ⴰⵙ: “ⴰⵎⵎⵓ ⵉ ⵉⵇⵇⴰⵔ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏ ⵉⵙⵔⴰⵉⵍ: ‘ⴻⵊⵊ ⴰⴷ ⵉⵔⴰⵃ ⵍⴳⴻⵏⵙ ⵉⵏⵓ, ⵃⵉⵎⴰ ⴰⴷ ⴰⵢⵉ ⵉⵄⴻⵢⵢⴻⴷ ⴷⵉ ⵍⴻⵅⵍⴰ!’” ");
INSERT INTO rift_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","ⵎⴰⵛⴰ ⴼⵉⵔⵄⵓⵏ ⵉⵏⵏⴰ: “ⵎⵉⵏ ⵉⵄⵏⴰ ⵙⵉⴷⵉ ⵓⵎⵉ ⵖⴰ ⵙⵍⴻⵖ ⵉ ⵡⴰⵡⴰⵍ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⵊⵊⴻⵖ ⵉⵙⵔⴰⵉⵍ ⴰⴷ ⵉⴼⴼⴻⵖ. ⵏⴻⵛⵛ ⵡⴰⵔ ⵙⵙⵉⵏⴻⵖ ⵙⵉⴷⵉ ⵓ ⵡⴰⵔ ⵜⵜⴻⵊⵊⵉⵖ ⴰⴷ ⵉⵔⴰⵃ ⵉⵙⵔⴰⵉⵍ.”    ");
INSERT INTO rift_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","ⵏⵉⵜⵏⵉ ⵏⵏⴰⵏ: “ⴰⵔⴻⴱⴱⵉ ⵏ ⵉⵄⵉⴱⵔⴰⵏⵉⵢⵢⴻⵏ ⵉⵎⵙⴰⴳⴰⵔ ⴰⴽⵉⴷⵏⴻⵖ, ⴻⵊⵊ ⴰⵏⴻⵖ ⵅⴻⵏⵏⵉ ⴰⴷ ⵏⵔⴰⵃ ⵜⵉⵛⵍⵉ ⵏ ⵜⵍⴰⵜⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⴷⵉ ⵍⴻⵅⵍⴰ, ⴰⴷ ⵏⵇⴻⴷⴷⴻⵎ ⵜⴰⵖⴰⵔⵚⵜ ⵉ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵖ, ⵃⵉⵎⴰ ⵡⴰⵔ ⴷ ⴰⵏⴻⵖ ⵉⵍⴻⵇⵇⴻⴼ ⵙ ⵟⵟⴰⵄⵓⵏ ⵏⵉⵖ ⵙ ⵙⵙⵉⴼ.” ");
INSERT INTO rift_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⵏⵏⴰ ⴰⵙⴻⵏ ⵓⵊⴻⴵⵉⴷ ⵏ ⵎⵉⵚⵔⴰ: “ⵎⴰⵢⴻⵎⵎⵉ, ⴰ ⴽⴻⵏⵏⵉⵡ, ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ, ⵜⴻⵙⵙⴱⴻⴷⴷⴻⵎ ⵍⴳⴻⵏⵙ ⵅ ⵍⵅⴻⴷⵎⴻⵜ ⵏⵏⴻⵙ? ⵔⵓⵃⴻⵎ ⴽⴻⵏⵏⵉⵡ, ⴷⴻⵡⵍⴻⵎ ⵖⴰⵔ ⴷⴷⵇⵓⵍⴰⵜ ⵉ ⵅⴰⵡⴻⵎ ⵉⴵⴰⵏ!” ");
INSERT INTO rift_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","ⵉⵏⵏⴰ ⴼⵉⵔⵄⵓⵏ: “ⵅⵣⴰⵔ, ⴰⵇⴰ ⵍⴻⵅⵅⵓ ⵍⴳⴻⵏⵙ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⴷ ⴰⵟⵟⴰⵙ ⵓ ⴽⴻⵏⵏⵉⵡ ⵜⴻⵅⵙⴻⵎ ⴰⴷ ⵜⴻⵏ ⵜⴻⵙⵙⴱⴻⴷⴷⴻⵎ ⵅ ⵡⴰⵔⴱⴰⵔ ⵏ ⴷⴷⵇⵓⵍⴰⵜ ⵉ ⵅⴰⵙⴻⵏ ⵜⵜⵡⴰⴳⴳⴻⵏⵜ.” ");
INSERT INTO rift_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","ⵢⵓⵎⵓⵔ ⴼⵉⵔⵄⵓⵏ ⴷⴻⴳ ⵡⴰⵙⵙ ⵏⵏⵉ ⵉ ⵉⵎⵣⴻⵢⵢⴰⵔⴻⵏ ⵏ ⵍⴳⴻⵏⵙ ⵓ ⵉ ⵉⵡⴻⵇⵇⴰⴼⴻⵏ ⵏⵙⴻⵏ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“ⵣⵉ ⵙⵙⴰ ⴷ ⵜⵙⴰⵡⴻⵏⵜ ⵡⴰⵔ ⵜⵜⵉⵛⴻⵎ ⵄⴰⴷ ⵍⵓⵎ ⵉ ⵍⴳⴻⵏⵙ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⴳⴳⴻⵏ ⵍⵍⴰⵊⵓⵔ ⴰⵎ ⵢⵉⴹⴻⵏⵏⴰⴹ ⴷ ⴼⴰⵔⵉⴹⴻⵏⵏⴰⴹ. ⵊⵊⴻⵎ ⵜⴻⵏ ⴰⴷ ⵔⴰⵃⴻⵏ ⵏⵉⵜⵏⵉ, ⴰⴷ ⵢⵔⵓⵏ ⵍⵓⵎ ⵉ ⵢⵉⵅⴻⴼ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","ⵍⵇⴻⴷⴷ ⵏ ⵍⵍⴰⵊⵓⵔ ⵉ ⴳⴳⵉⵏ ⵉⴹⴻⵏⵏⴰⴹ ⴷ ⴼⴰⵔⵉⴹⴻⵏⵏⴰⴹ ⴰⴷ ⵅⴰⵙⴻⵏ ⵜ ⵜⴻⴳⴳⴻⵎ ⵄⴰⵡⴻⴷ, ⵡⴰⵔ ⵣⵣⴰⵢⴻⵙ ⵜⴻⵙⵙⵏⴻⵇⵇⵉⵙⴻⵎ ⵡⴰⵍⵓ, ⵎⵉⵏⵣⵉ ⵏⵉⵜⵏⵉ ⴷ ⵉⴼⵉⵏⵢⴰⵏⴻⵏ. ⵅ ⵓⵢⴰ ⵙⵖⵓⵢⵢⵓⵏ ⴰⵎⵎⵓ, ⵇⵇⴰⵔⴻⵏ: ‘ⴻⵊⵊ ⴰⵏⴻⵖ ⴰⴷ ⵏⵔⴰⵃ ⴰⴷ ⵏⵇⴻⴷⴷⴻⵎ ⵜⴰⵖⴰⵔⵚⵜ ⵉ ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵖ.’ ");
INSERT INTO rift_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","ⵉⵜⵜⵅⴻⵚⵚⴰ ⵍⵅⴻⴷⵎⴻⵜ ⴰⴷ ⵜⵉⵍⵉ ⵜⴻⴷⵇⴻⵍ ⵅ ⵉⵔⵢⴰⵣⴻⵏ-ⴰ, ⵃⵉⵎⴰ ⴰⴷ ⴷⴰⵢⴻⵙ ⵍⵀⴰⵏ ⴰⵎⵎⵓ ⵓⵛⴰ ⵡⴰⵔ ⵜⵜⵉⵛⴻⵏ ⵄⴰⴷ ⵜⴰⵢⵏⵉⵜ ⵉ ⵡⴰⵡⴰⵍⴻⵏ ⵉⵅⴰⵔⵔⵉⵇⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵔⵓⵃⴻⵏ ⵉⵎⵣⴻⵢⵢⴰⵔⴻⵏ ⵏ ⵍⴳⴻⵏⵙ ⴷ ⵉⵡⴻⵇⵇⴰⴼⴻⵏ ⵏⵙⴻⵏ ⴳⴳⵯⴻⵊⴻⵏ ⵅ ⴼⵉⵔⵄⵓⵏ ⵓⵛⴰ ⵙⵙⵉⵡⵍⴻⵏ ⴰⴽ-ⴷ ⵍⴳⴻⵏⵙ, ⵏⵏⴰⵏ: “ⴰⵎⵎⵓ ⵉ ⵉⵇⵇⴰⵔ ⴼⵉⵔⵄⵓⵏ: ‘ⵏⴻⵛⵛ ⵡⴰⵔ ⴷ ⴰⵡⴻⵎ ⵜⵜⵉⵛⴻⵖ ⵛⴰ ⵄⴰⴷ ⵍⵓⵎ.’ ");
INSERT INTO rift_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","ⵔⵓⵃⴻⵎ ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⵜⵢⴰⵔⵡⴻⵎ ⵍⵓⵎ ⵎⴰⵏⵉ ⵜ ⵖⴰ ⵜⴰⴼⴻⵎ, ⵎⴰⵖⴰⵔ ⵡⴰⵔ ⵅⴰⵡⴻⵎ ⵜᵉⵜⵜⵡⴰⴽⴽⴻⵙ ⵡⴰⵍⵓ ⵣⵉ ⵍⵅⴻⴷⵎⴻⵜ ⵏⵡⴻⵎ.” ");
INSERT INTO rift_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⵎⴱⴻⵣⵣⴻⵄ ⵍⴳⴻⵏⵙ ⵅ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ, ⵃⵉⵎⴰ ⴰⴷ ⵢⵔⵓⵏ ⵉⵖⴻⴵ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏ ⵓⵍⵓⵎ. ");
INSERT INTO rift_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","ⵉⵎⵣⴻⵢⵢⴰⵔⴻⵏ ⵣⵉⵢⵢⴰⵔⴻⵏ ⵅⴰⵙⴻⵏ, ⵏⵏⴰⵏ: “ⴽⴻⵎⵎⵍⴻⵎ ⵍⵅⴻⴷⵎⴻⵜ ⵏⵡⴻⵎ, ⴽⵓⵍ ⴰⵙⵙ ⵎⵉⵏ ⴷⴷ-ⵉⵜⵜⴰⵙⴻⵏ ⵉ ⴽⵓⵍ ⴰⵙⵙ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⵓⵖⴰ ⴷⵉⵏ ⵍⴻⵅⴷⴻⵏⵏⵉ ⵍⵓⵎ.” ");
INSERT INTO rift_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","ⵜⵜⵡⴰⴼⴰⵔⵛⴻⵏ ⵉⵡⴻⵇⵇⴰⴼⴻⵏ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵉⵏⵏⵉ ⵅⴰⵙⴻⵏ ⴳⴳⵉⵏ ⵉⵎⵣⴻⵢⵢⴰⵔⴻⵏ ⵏ ⴼⵉⵔⵄⵓⵏ, ⵏⵏⴰⵏ ⴰⵙⴻⵏ: “ⵎⴰⵢⴻⵎⵎⵉ ⵡⴰⵔ ⵜⴽⴻⵎⵎⵍⴻⵎ ⵜⴰⵙⵖⴰⵔⵜ ⵏⵡⴻⵎ ⵏ ⵍⵍⴰⵊⵓⵔ ⴰⵎ ⵍⴻⴱⴷⴰ, ⵉⴹⴻⵏⵏⴰⴹ ⵍⵍⴰ ⵓ ⵄⴰⵡⴻⴷ ⴰⵙⵙ-ⴰ ⵍⵍⴰ?” ");
INSERT INTO rift_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵓⵙⵉⵏ-ⴷⴷ ⵉⵡⴻⵇⵇⴰⴼⴻⵏ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵙⵖⵓⵢⴻⵏ ⵖⴰⵔ ⴼⵉⵔⵄⵓⵏ, ⵏⵏⴰⵏ: “ⵎⴰⵢⴻⵎⵎⵉ ⵜᵉⵜⵜⴻⴳⴳⴻⴷ ⴰⵎⵎⵓ ⴰⴽ-ⴷ ⵉⵙⴻⵎⵖⴰⵏ ⵏⵏⴻⵛ? ");
INSERT INTO rift_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","ⵡⴰⵔ ⵉⵜⵜⵎⴻⵡⵛⵉ ⴱⵓ ⵓⵍⵓⵎ ⵉ ⵉⵙⴻⵎⵖⴰⵏ ⵏⵏⴻⵛ, ⵡⴰⵅⵅⴰ ⵇⵇⴰⵔⴻⵏ ⴰⵏⴻⵖ: ‘ⴳⴳⴻⵎ ⵍⵍⴰⵊⵓⵔ!’ ⵓ ⵅⵣⴰⵔ, ⴰⵇⴰ ⵉⵙⴻⵎⵖⴰⵏ ⵏⵏⴻⵛ ⵜⵜᵉⵜⵜⴻⵏ ⴰⵄⵎⵓⴷ, ⵡⴰⵅⵅⴰ ⵍⵄⵉⴱ ⴰⵇⴰ-ⵜ ⴷⵉ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵛ!” ");
INSERT INTO rift_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","ⵏⴻⵜⵜⴰ ⵢⴰⵔⵔⴰ-ⴷⴷ: “ⴽⴻⵏⵏⵉⵡ ⴷ ⵉⴼⵉⵏⵢⴰⵏⴻⵏ, ⴷ ⵉⴼⵉⵏⵢⴰⵏⴻⵏ ⴰⵟⵟⴰⵙ. ⵅ ⵓⵢⴰ ⵜⴻⵇⵇⴰⵔⴻⵎ: ‘ⵊⵊⴻⵎ ⴰⵏⴻⵖ ⴰⴷ ⵏⵔⴰⵃ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵏⵇⴻⴷⴷⴻⵎ ⵜⴰⵖⴰⵔⵚⵜ ⵉ ⵙⵉⴷⵉ.’ ");
INSERT INTO rift_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","ⵔⵓⵃⴻⵎ ⵍⴻⵅⵅⵓ ⴰⴷ ⵜⵅⴻⴷⵎⴻⵎ. ⵡⴰⵔ ⴷ ⴰⵡⴻⵎ ⵜⵜⵉⵛⴻⵏ ⵄⴰⴷ ⴰⵍⵓⵎ, ⵡⴰⵅⵅⴰ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⵜⴻⵇⵇⵉⵎⴻⵎ ⵜⵙⴻⴱⴱⵍⴻⵎ ⵍⴻⵄⴱⴰⵔ ⵏ ⵍⵍⴰⵊⵓⵔ!” ");
INSERT INTO rift_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵥⵔⵉⵏ ⵉⵡⴻⵇⵇⴰⴼⴻⵏ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⴰⵇⴰ-ⵜⴻⵏ ⵃⴰⵍⴰ, ⵎⵉⵏⵣⵉ ⵉⵜⵜⵡⴰⵏⵏⴰ: “ⴽⴻⵏⵏⵉⵡ ⵡⴰⵔ ⵙⵙⵏⴻⵇⵚⴻⵎ ⵡⴰⵍⵓ ⵣⵉ ⵍⵍⴰⵊⵓⵔ ⵉ ⴷⴷ-ⵉⵜⵜⴰⵙⴻⵏ ⵉ ⴽⵓⵍ ⴰⵙⵙ.” ");
INSERT INTO rift_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","ⵓⵎⵉ ⴷⴷ-ⴼⴼⵖⴻⵏ ⵅ ⴼⵉⵔⵄⵓⵏ, ⵎⵎⵚⴰⴷⴰⴼⴻⵏ ⴰⴽ-ⴷ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ, ⵉⵏⵏⵉ ⵜⵓⵖⴰ ⴷⵉⵏ ⵉⴱⴻⴷⴷⴻⵏ ⵃⵉⵎⴰ ⴰⴷ ⵜⴻⵏ ⵔⴰⵊⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","ⵏⵏⴰⵏ ⴰⵙⴻⵏ: “ⴷ ⵙⵉⴷⵉ, ⴷ ⵡⴻⵏⵏⵉ ⴽⴻⵏⵏⵉⵡ ⵉⵜⵜⵡⴰⵍⴰⵏ, ⴷ ⵡⴻⵏⵏⵉ ⵅⴰⵡⴻⵎ ⵉ ⵖⴰ ⵉⵃⴻⴽⵎⴻⵏ, ⵎⵉⵏⵣⵉ ⴽⴻⵏⵏⵉⵡ ⴰⵇⴰ ⵜⴻⵙⵙⴰⵔⵣⴳⴻⵎ ⴰⵏⴻⵖ ⵖⴰⵔ ⴼⵉⵔⵄⵓⵏ ⴷ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵙ ⵓⵎⵉ ⴷ ⴰⵙⴻⵏ ⵜⴻⴳⴳⵉⵎ ⵙⵙⵉⴼ ⴷⴻⴳ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵙⴻⵏ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴰⵏⴻⵖ ⵏⵖⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⴷⵡⴻⵍ ⵎⵓⵙⴰ ⵖⴰⵔ ⵙⵉⴷⵉ, ⵉⵏⵏⴰ: “ⴰ ⵙⵉⴷⵉ ⵉⵏⵓ, ⵎⴰⵢⴻⵎⵎⵉ ⵜⴻⴳⴳⴻⴷ ⵍⵖⴰⵔ ⴷⵉ ⵍⴳⴻⵏⵙ-ⴰ, ⵎⴰⵢⴻⵎⵎⵉ ⴷ ⴰⵢⵉ ⵜⴻⵙⵙⵇⴰⴷⴻⴷ ⵅⴻⵏⵏⵉ? ");
INSERT INTO rift_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","ⵣⴻⴳ ⵡⴰⵎⵉ ⵓⴷⴼⴻⵖ ⵖⴰⵔ ⴼⵉⵔⵄⵓⵏ ⵃⵉⵎⴰ ⴰⴷ ⵙⵙⵉⵡⵍⴻⵖ ⵙ ⵢⵉⵙⴻⵎ ⵏⵏⴻⵛ, ⵉⴷⴻⴵ ⴼⵉⵔⵄⵓⵏ ⵍⴳⴻⵏⵙ-ⴰ ⵓ ⵛⴻⴽ ⵇⴰⵄ ⵡⴰⵔ ⵜⴼⴻⴽⴽⵉⴷ ⵛⴰ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵛ.” ");
INSERT INTO rift_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⵍⴻⵅⵅⵓ ⴰⴷ ⵜⵥⴰⵔⴻⴷ ⵎⵉⵏ ⵖⴰ ⴳⴳⴻⵖ ⵉ ⴼⵉⵔⵄⵓⵏ, ⵎⵉⵏⵣⵉ ⵙ ⵓⴼⵓⵙ ⵉⵊⴻⵀⴷⴻⵏ ⴰⴷ ⵜⴻⵏ ⵢⴻⵊⵊ ⴰⴷ ⵔⴰⵃⴻⵏ, ⵡⴰⵀ, ⵙ ⵓⴼⵓⵙ ⵉⵊⴻⵀⴷⴻⵏ ⴰⴷ ⵅⴰⵙⴻⵏ ⵢⴰⵥⵥⴻⵍ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⴻⵙ.” ");
INSERT INTO rift_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","ⵉⵙⵙⵉⵡⴻⵍ ⴰⵔⴻⴱⴱⵉ ⵖⴰⵔ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ ⴰⵙ: “ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ");
INSERT INTO rift_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","ⵏⴻⵛⵛ ⴱⴰⵏⴻⵖ-ⴷⴷ ⵉ ⵉⴱⵔⴰⵀⵉⵎ, ⴷ ⵉⵙⵃⴰⵇ ⴷ ⵢⴰⵄⵇⵓⴱ ⴰⵎ ⴰⵔⴻⴱⴱⵉ, ⴰⵎⵣⴻⵎⵎⴰⵔ ⵅ ⴽⵓⵍⵛⵉ, ⵎⴰⵛⴰ ⵙ ⵢⵉⵙⴻⵎ ⵉⵏⵓ ‘ⵙⵉⴷⵉ’, ⵜⵓⵖⴰ ⵡⴰⵔ ⵖⴰⵔⵙⴻⵏ ⵜⵜⵡⴰⵙⵙⵏⴻⵖ ⵛⴰ. ");
INSERT INTO rift_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","ⵄⴰⵡⴻⴷ ⵙⵙⴳⴻⵄⵄⴷⴻⵖ ⵍⵄⴰⵀⴷ ⵉⵏⵓ ⴰⴽⵉⴷⵙⴻⵏ ⴰⵇⴰ ⴰⴷ ⴰⵙⴻⵏ ⵡⵛⴻⵖ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ, ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵓⵏⴻⵡⵊⵉ ⵏⵙⴻⵏ ⵎⴰⵏⵉ ⵜⴻⵏ ⵜⵓⵖⴰ ⴰⵎ ⵢⵉⴱⴰⵔⵔⴰⵏⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","ⵄⴰⵡⴻⴷ ⵏⴻⵛⵛ ⵙⵍⵉⵖ ⴰⵏⵉⵅⵙⴻⵙ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⴳⴳⴻⵏ ⴷ ⵉⵙⴻⵎⵖⴰⵏ ⵣⴻⴳ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ, ⴰⵇⴰ ⵅⴰⵔⵔⵚⴻⵖ ⴷⵉ ⵍⵄⴰⵀⴷ ⵉⵏⵓ. ");
INSERT INTO rift_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","ⵙ ⵓⵢⴰ ⴰⴷ ⵜⵉⵏⵉⴷ ⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ: ⵏⴻⵛⵛ ⴰⵇⴰ ⴰⵢⵉ ⴷ ⵙⵉⴷⵉ ⵓ ⵏⴻⵛⵛ ⴰⴷ ⴽⴻⵏⵏⵉⵡ ⵙⵙⵓⴼⴼⵖⴻⵖ ⵣⵉ ⵙⴰⴷⵓ ⵣⴰⵢⵍⵓ ⵏ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ. ⵏⴻⵛⵛ ⴰⴷ ⴽⴻⵏⵏⵉⵡ ⴼⴻⴽⴽⴻⵖ ⵣⵉ ⵜⴻⵙⵎⵓⵖⵉ ⵏⵙⴻⵏ, ⴰⴷ ⴽⴻⵏⵏⵉⵡ ⴼⴷⵉⵖ ⵙ ⵓⵖⵉⵍ ⵉⵙⵙⵡⵉⵥⵥⴹⴻⵏ ⴷ ⵍⴻⵃⴽⴰⵎⴰⵜ ⵉⵎⵖⴰⵔⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","ⴰⴷ ⴽⴻⵏⵏⵉⵡ ⵇⴻⴱⵍⴻⵖ ⴷ ⵍⴳⴻⵏⵙ ⵉⵏⵓ ⵓⵛⴰ ⴰⴷ ⴰⵡⴻⵎ ⵉⵍⵉⵖ ⴷ ⴰⵔⴻⴱⴱⵉ ⵓ ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⵜⴻⵙⵙⵏⴻⵎ ⴱⴻⵍⵍⵉ ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ, ⴷ ⵡⴻⵏⵏⵉ ⵜⵓⵖⴰ ⴽⴻⵏⵏⵉⵡ ⵉⵙⵙⵓⴼⴼⵓⵖⴻⵏ ⵣⵉ ⵙⴰⴷⵓ ⵣⴰⵢⵍⵓ ⵏ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","ⴰⴷ ⴽⴻⵏⵏⵉⵡ ⵙⵙⵉⴷⴼⴻⵖ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵎⵉⵅⴻⴼ ⵙⵙⴳⴻⵄⵄⴷⴻⵖ ⴰⴼⵓⵙ ⵉⵏⵓ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⵜ ⵡⵛⴻⵖ ⵉ ⵉⴱⵔⴰⵀⵉⵎ ⴷ ⵉⵙⵃⴰⵇ ⴷ ⵢⴰⵄⵇⵓⴱ ⵓ ⵏⴻⵛⵛ ⴰⴷ ⴰⵡⴻⵎ ⵜⵜ ⵡⵛⴻⵖ ⴷ ⵍⵡⴰⵔⵜ, ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ!” ");
INSERT INTO rift_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","ⴰⵎⵎⵓ ⵉ ⵉⵙⵙⵉⵡⴻⵍ ⵎⵓⵙⴰ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵎⴰⵛⴰ ⵏⵉⵜⵏⵉ ⵡⴰⵔ ⵙⵍⵉⵏ ⵛⴰ ⵖⴰⵔ ⵎⵓⵙⴰ ⵣⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⵍⴻⵃⵚⴰⵔⴻⵜ ⵏ ⵜⵏⴻⴼⵙⴻⵛⵜ ⴷ ⵜⴰⵙⵎⵓⵖⵉ ⵉⵇⴻⵙⵃⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","ⵓⵛⴰ ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“ⴰⴷⴻⴼ ⵖⴰⵔ ⴼⵉⵔⵄⵓⵏ, ⴰⵊⴻⴵⵉⴷ ⵏ ⵎⵉⵚⵔⴰ, ⵜⵉⵏⵉⴷ ⴰⵙ ⴰⴷ ⵉⴹⵍⴻⵇ ⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴼⴼⵖⴻⵏ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⴻⵙ.” ");
INSERT INTO rift_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","ⵎⴰⵛⴰ ⵎⵓⵙⴰ ⵉⵙⵙⵉⵡⴻⵍ ⵣⵣⴰⵜ ⵉ ⵙⵉⴷⵉ, ⵉⵏⵏⴰ: “ⵅⵣⴰⵔ, ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵡⴰⵔ ⵖⴰⵔⵉ ⴷⴷ-ⵙⵍⵉⵏ, ⵎⴰⵎⵎⴻⵛ ⵉ ⴷ ⴰⵢⵉ ⵖⴰ ⵉⵙⴻⵍ ⴼⵉⵔⵄⵓⵏ ⵓ ⵏⴻⵛⵛ ⴰⵇⴰ ⵖⴰⵔⵉ ⵉⵢⴻⵏⵛⵉⵛⴻⵏ ⵡⴰⵔ ⵉⵜⵜⵡⴰⵅⴻⵜⵏⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⵖⴰⵔ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ ⵓⵛⴰ ⵢⵓⵎⵓⵔ ⵉ-ⵜⴻⵏ ⴰⴷ ⵓⵢⵓⵔⴻⵏ ⵖⴰⵔ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴷ ⴼⵉⵔⵄⵓⵏ, ⴰⵊⴻⴵⵉⴷ ⵏ ⵎⵉⵚⵔⴰ, ⵃⵉⵎⴰ ⴰⴷ ⵉⵙⵙⵓⴼⴼⴻⵖ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","ⵉⵏⴰ ⴷ ⵉⵣⴻⴵⵉⴼⴻⵏ ⵅ ⵍⴰⴵⴰⵜ ⵣⵉ ⵜⵓⴷⵔⵉⵏ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵙⴻⵏ. ⴰⵢⵜ ⵏ ⵔⵓⴱⵉⵏ, ⴰⵎⴻⵏⵣⵓ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵏⵉⵜⵏⵉ ⴷ ⵀⴰⵏⵓⴽ ⴷ ⴼⴰⵍⵍⵓ, ⵃⴰⵚⵔⵓⵏ ⴷ ⴽⴰⵔⵎⵉ. ⴷ ⵢⵉⵏⴰ ⴷ ⵍⴰⴵⴰⵜ ⵏ ⵔⵓⴱⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","ⴰⵢⵜ ⵏ ⵛⵉⵎⵄⵓⵏ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵢⴰⵎⵓⵢⵉⵍ ⴷ ⵢⴰⵎⵉⵏ ⴷ ⵓⵀⴰⴷ ⴷ ⵢⴰⴽⵉⵏ ⴷ ⵚⵓⵃⴰⵔ ⴷ ⵛⴰⵡⵓⵍ, ⵎⵎⵉ ⵏ ⵉⵛⵜ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⵜⴰⴽⴻⵏⵄⴰⵏⵉⵜ. ⵉⵏⴰ ⴷ ⵍⴰⴵⴰⵜ ⵏ ⵛⵉⵎⵄⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","ⵉⵏⴰ ⴷ ⵉⵙⵎⴰⵡⴻⵏ ⵏ ⴰⵢⵜ ⵏ ⵍⴰⵡⵉ ⵄⵍⴰⵃⵙⴰⴱ ⴰⵙⴻⵜⵜⴻⴼ ⵏ ⵡⴻⵅⵍⴰⵇ ⵏⵙⴻⵏ: ⵊⴰⵔⵛⵓⵎ ⴷ ⵇⴰⵀⴰⵜ ⴷ ⵎⴰⵔⴰⵔⵉ. ⵜⵓⵖⴰ ⵍⵎⵉⵊⴰⵍ ⵏ ⵜⵓⴷⴰⵔⵜ ⵏ ⵍⴰⵡⵉ ⵎⵢⴰ ⵓ-ⵙⴻⴱⵄⴰ ⵓ-ⵜⵍⴰⵜⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","ⴰⵢⵜ ⵏ ⵊⴰⵔⵛⵓⵎ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵍⵉⴱⵏⴰ ⴷ ⵛⵉⵎⵄⵉ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","ⴰⵢⵜ ⵏ ⵇⴰⵀⴰⵜ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵄⴰⵎⵔⴰⵎ ⴷ ⵢⵉⵚⵀⴰⵔ ⴷ ⵃⴰⴱⵔⵓⵏ ⴷ ⵄⵓⵣⵣⵉⵢⵉⵍ. ⵜⵓⵖⴰ ⵍⵎⵉⵊⴰⵍ ⵏ ⵜⵓⴷⴰⵔⵜ ⵏ ⵇⴰⵀⴰⵜ ⵎⵢⴰ ⵓ-ⵜⵍⴰⵜⴰ ⵓ-ⵜⵍⴰⵜⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","ⴰⵢⵜ ⵏ ⵎⴰⵔⴰⵔⵉ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵎⴰⵃⵍⵉ ⴷ ⵎⵓⵛⵉ. ⵉⵏⴰ ⴷ ⵍⴰⴵⴰⵜ ⵏ ⵍⴰⵡⵉ ⵄⵍⴰⵃⵙⴰⴱ ⴰⵙⴻⵜⵜⴻⴼ ⵏ ⵡⴻⵅⵍⴰⵇ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","ⵓⵛⴰ ⵄⴰⵎⵔⴰⵎ ⵉⴽⵙⵉ ⵢⵓⴽⴰⴱⴰⴷ, ⵄⴻⵏⵜⵉⵙ, ⴷ ⵜⴰⵎⵖⴰⵔⵜ ⵉ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵓ ⵏⴻⵜⵜⴰⵜ ⵜⵓⵔⵓⵡ ⴰⵙ-ⴷⴷ ⵀⴰⵔⵓⵏ ⴷ ⵎⵓⵙⴰ. ⵜⵓⵖⴰ ⵍⵎⵉⵊⴰⵍ ⵏ ⵜⵓⴷⴰⵔⵜ ⵏ ⵄⴰⵎⵔⴰⵎ ⵎⵢⴰ ⵓ-ⵙⴻⴱⵄⴰ ⵓ-ⵜⵍⴰⵜⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","ⴰⵢⵜ ⵏ ⵢⵉⵚⵀⴰⵔ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵇⵓⵔⴰⵃ ⴷ ⵏⴰⴼⴰⵊ ⴷ ⴷⵉⴽⵔⵉ. ");
INSERT INTO rift_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","ⴰⵢⵜ ⵏ ⵄⵓⵣⵣⵉⵢⵉⵍ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵎⵉⵛⴰⵢⵉⵍ ⴷ ⴰⵍⵚⴰⴼⴰⵏ ⴷ ⵙⵉⵜⵔⵉ. ");
INSERT INTO rift_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","ⵓⵛⴰ ⵉⴽⵙⵉ ⵀⴰⵔⵓⵏ ⵉⵍⵉⵛⴰⴱⴰⵄ, ⵢⴻⴵⵉⵙ ⵏ ⵄⴰⵎⵎⵉⵏⴰⴷⴰⴱ, ⵓⵍⵜⵎⴰⵙ ⵏ ⵏⴰⵃⵛⵓⵏ, ⴷ ⵜⴰⵎⵖⴰⵔⵜ ⵉ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵓ ⵏⴻⵜⵜⴰⵜ ⵜⵓⵔⵓⵡ ⴰⵙ-ⴷⴷ ⵏⴰⴷⴰⴱ ⴷ ⴰⴱⵉⵀⵓ ⴷ ⴰⵍⵉⵄⴰⵣⴰⵔ ⴷ ⵉⵜⴰⵎⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","ⴰⵢⵜ ⵏ ⵇⵓⵔⴰⵃ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⴰⵙⵙⵉⵔ ⴷ ⴰⵍⵇⴰⵏⴰ ⴷ ⴰⴱⵉⵢⴰⵙⴰⴼ. ⵉⵏⴰ ⴷ ⵍⴰⴵⴰⵜ ⵏ ⵉⵇⵓⵔⴰⵃⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","ⵓⵛⴰ ⴰⵍⵉⵄⴰⵣⴰⵔ, ⵎⵎⵉⵙ ⵏ ⵀⴰⵔⵓⵏ, ⵉⴽⵙⵉ ⵉⵛⵜⴻⵏ ⵣⴻⴳ ⵢⴻⵙⵙⵉⵙ ⵏ ⴼⵓⵜⵉⵢⵉⵍ ⴷ ⵜⴰⵎⵖⴰⵔⵜ ⵉ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵓⵛⴰ ⵏⴻⵜⵜⴰⵜ ⵜⵓⵔⵓⵡ ⴰⵙ-ⴷⴷ ⴼⵉⵏⴰⵃⴰⵙ. ⵉⵏⴰ ⴷ ⵉⵣⴻⴵⵉⴼⴻⵏ ⵏ ⵜⵓⴷⵔⵉⵏ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","ⴰⵇⴰ ⵡⴰ ⴷ ⵀⴰⵔⵓⵏ ⴷ ⵎⵓⵙⴰ ⵉ ⵓⵎⵉ ⵉⵏⵏⴰ ⵙⵉⴷⵉ: “ⵙⵓⴼⴼⵖⴻⵎ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⴰⵎ ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵏⵉⵜⵏⵉ ⵄⵍⴰⵃⵙⴰⴱ ⵉⵙⴻⴷⴷⵉⵢⵢⴻⵏ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵙⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","ⵉⵏⴰ ⴷ ⵉⵏⵏⵉ ⵉⵙⵙⵉⵡⵍⴻⵏ ⴰⴽ-ⴷ ⴼⵉⵔⵄⵓⵏ, ⴰⵊⴻⴵⵉⴷ ⵏ ⵎⵉⵚⵔⴰ, ⵃⵉⵎⴰ ⴰⴷ ⵙⵙⵓⴼⴼⵖⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵣⵉ ⵎⵉⵚⵔⴰ, ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ, ⵏⵉⵜⵏⵉ ⴷ ⵉⵏⴰ. ");
INSERT INTO rift_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","ⵉⵎⵙⴰⵔ ⴷⴻⴳ ⵡⴰⵙⵙ ⵉ ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ, ");
INSERT INTO rift_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","ⴰⵇⴰ ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: “ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ ⵉ ⴵⵉⵖ! ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴷ ⴰⵛ ⵇⵇⴰⵔⴻⵖ, ⵉⵏⵉ ⵜ ⵉ ⴼⵉⵔⵄⵓⵏ, ⴰⵊⴻⴵⵉⴷ ⵏ ⵎⵉⵚⵔⴰ.” ");
INSERT INTO rift_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵎⵓⵙⴰ ⵣⵣⴰⵜ ⵉ ⵙⵉⴷⵉ: “ⴰⵇⴰ ⵖⴰⵔⵉ ⵏⴻⵛⵛ ⵉⵢⴻⵏⵛⵉⵛⴻⵏ ⵡⴰⵔ ⵉⵜⵜⵡⴰⵅⴻⵜⵏⴻⵏ, ⵎⴰⵎⵎⴻⵛ ⵖⴰ ⵢⴻⴳⴳ ⵅⴻⵏⵏⵉ ⴰⴷ ⵖⴰⵔⵉ ⵉⵙⴻⴵ ⴼⵉⵔⵄⵓⵏ?”    ");
INSERT INTO rift_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⵅⵣⴰⵔ, ⵏⴻⵛⵛ ⴰⵇⴰ ⴳⴳⵉⵖ ⵛⴻⴽ ⴷ ⴰⵔⴻⴱⴱⵉ ⵉ ⴼⵉⵔⵄⵓⵏ ⴷ ⵓⵎⴰⵛ ⵀⴰⵔⵓⵏ ⴰⴷ ⴰⵛ ⵢⵉⵍⵉ ⴷ ⴰⵏⴰⴱⵉ ⵉ ⵛⴻⴽ. ");
INSERT INTO rift_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","ⵛⴻⴽ ⴰⴷ ⵜⵉⵏⵉⴷ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵣⵉ ⵛⴻⴽ ⵖⴰ ⵓⵎⵓⵔⴻⵖ ⵓⵛⴰ ⵀⴰⵔⵓⵏ, ⵓⵎⴰⵛ, ⴰⴷ ⵉⵙⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⴼⵉⵔⵄⵓⵏ, ⵃⵉⵎⴰ ⴰⴷ ⵢⴻⵊⵊ ⴰⴷ ⴼⴼⵖⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","ⵎⴰⵛⴰ ⵏⴻⵛⵛ ⴰⴷ ⵙⵙⵇⴻⵙⵃⴻⵖ ⵓⵍ ⵏ ⴼⵉⵔⵄⵓⵏ ⵓⵛⴰ ⴰⴷ ⴽⴻⵜⵜⴰⵔⴻⵖ ⵍⴻⵄⵍⴰⵎⴰⵜ ⴷ ⵍⵎⵓⵄⵊⵉⵣⴰⵜ ⵉⵏⵓ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","ⵎⴰⵛⴰ ⴼⵉⵔⵄⵓⵏ ⵡⴰⵔ ⵖⴰⵔⵡⴻⵎ-ⴷⴷ ⵉⵙⵙⵃⴻⵙⵙⵉ ⵓ ⵏⴻⵛⵛ ⴰⴷ ⴳⴳⴻⵖ ⴰⴼⵓⵙ ⵉⵏⵓ ⵅ ⵎⵉⵚⵔⴰ ⵓⵛⴰ ⴰⴷ ⵙⵙⵓⴼⴼⵖⴻⵖ ⵍⵄⴻⵙⴽⴰⵔⴰⵜ ⵉⵏⵓ, ⵍⴳⴻⵏⵙ ⵉⵏⵓ, ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⵙ ⵍⴻⵃⴽⴰⵎⴰⵜ ⵉⵎⵖⴰⵔⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","ⵍⴻⵅⴷⴻⵏⵏⵉ ⴰⴷ ⵙⵙⵏⴻⵏ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ ⴱⴻⵍⵍⵉ ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ ⵉ ⴵⵉⵖ ⵅⵎⵉ ⵖⴰ ⵙⵙⵡⵉⵥⵥⴹⴻⵖ ⴰⴼⵓⵙ ⵉⵏⵓ ⵅ ⵎⵉⵚⵔⴰ ⵓⵛⴰ ⴰⴷ ⵙⵙⵓⴼⴼⵖⴻⵖ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵣⵉ ⵍⵡⴻⵙⵟ ⵏⵙⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","ⵓⵛⴰ ⴳⴳⵉⵏ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⴻⵏ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ, ⵡⴰⵀ, ⴰⵎⴻⵏⵏⵉ ⵉ ⴳⴳⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","ⵜⵓⵖⴰ ⵎⵓⵙⴰ ⴷ ⵉⵊⵊ ⵏ ⴱⵏⴰⴷⴻⵎ ⵏ ⵜⵎⴻⵏⵢⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵓ ⵜⵓⵖⴰ ⵀⴰⵔⵓⵏ ⴷ ⵉⵊⵊ ⵏ ⴱⵏⴰⴷⴻⵎ ⵏ ⵜⵍⴰⵜⴰ ⵓ-ⵜⵎⴻⵏⵢⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵍⴰⵎⵉ ⵙⵙⵉⵡⵍⴻⵏ ⴰⴽ-ⴷ ⴼⵉⵔⵄⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","ⵓⵛⴰ ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“ⵎⴰⵍⴰ ⵉⵙⵙⵉⵡⴻⵍ ⴰⴽⵉⴷⵡⴻⵎ ⴼⵉⵔⵄⵓⵏ, ⴰⴷ ⵢⵉⵏⵉ: ‘ⵙⴻⵛⵏⴻⵎ, ⴰⵇⴰ ⴽⴻⵏⵏⵉⵡ ⵜⵣⴻⵎⵎⴰⵔⴻⵎ ⴰⴷ ⵜⴻⴳⴳⴻⵎ ⵉⵛⵜ ⵏ ⵍⵎⵓⵄⵊⵉⵣⴰ!’, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⵉⵏⵉⴷ ⵉ ⵀⴰⵔⵓⵏ: ‘ⵟⵟⴻⴼ ⵜⴰⵖⵖⴰⵔⵛⵜ ⵏⵏⴻⵛ ⵓⵛⴰ ⵏⴹⴰⵔ ⵉ-ⵜⵜ ⵣⵣⴰⵜ ⵉ ⴼⵉⵔⵄⵓⵏ!’, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⴻⴷⵡⴻⵍ ⴷ ⵉⵛⵜ ⵏ ⵍⵀⴰⵢⵛⴻⵜ.” ");
INSERT INTO rift_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","ⵓⴷⴼⴻⵏ ⵅⴻⵏⵏⵉ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ ⵖⴰⵔ ⴼⵉⵔⵄⵓⵏ ⵓⵛⴰ ⴳⴳⵉⵏ ⵎⴰⵎⵎⴻⵛ ⵉ ⴷ ⴰⵙⴻⵏ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ. ⵉⵏⴹⴰⵔ ⵀⴰⵔⵓⵏ ⵜⴰⵖⵖⴰⵔⵛⵜ ⵏⵏⴻⵙ ⵣⵣⴰⵜ ⵉ ⴼⵉⵔⵄⵓⵏ ⴷ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵙ ⵓⵛⴰ ⵜⴻⴷⵡⴻⵍ ⴷ ⵉⵛⵜ ⵏ ⵍⵀⴰⵢⵛⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⵍⴰⵖⴰ-ⴷⴷ ⵄⴰⵡⴻⴷ ⴼⵉⵔⵄⵓⵏ ⵅ ⵉⵎⵉⵖⵉⵙⴻⵏ ⴷ ⵉⵙⴻⵃⵃⴰⵔⴻⵏ, ⵓⵛⴰ ⵜⴰⵔⵡⴰ ⵏ ⵜⵙⴻⵃⵃⴰⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⴳⴳⵉⵏ ⵄⴰⵡⴻⴷ ⴰⵎⴻⵏⵏⵉ ⵙ ⵜⵎⴻⴳⴳⴰ ⵏⵙⴻⵏ ⵏ ⵙⵡⴰⴷⴷⴰⵢ ⵙⵡⴰⴷⴷⴰⵢ ⴷ ⵉⵛⵜ. ");
INSERT INTO rift_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","ⵉⵏⴹⴰⵔ ⴽⵓⵍ ⵉⵊⵊⴻⵏ ⵜⴰⵖⵖⴰⵔⵛⵜ ⵏⵏⴻⵙ ⵓⵛⴰ ⴷⴻⵡⵍⴻⵏⵜ ⵜⵉⵖⵖⴰⵔⵢⴻⵏ ⵏⵏⵉ ⴷ ⵍⵀⴰⵢⵛⴰⵜ. ⵎⴰⵛⴰ ⵜⴰⵖⵖⴰⵔⵛⵜ ⵏ ⵀⴰⵔⵓⵏ ⵜⵙⴰⵔⴹ ⵜⵉⵖⵖⴰⵔⵢⴻⵏ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","ⵓⵍ ⵏ ⴼⵉⵔⵄⵓⵏ ⵉⴷⵡⴻⵍ ⵉⵇⵙⴻⵃ ⵓⵛⴰ ⵡⴰⵔ ⵖⴰⵔⵙⴻⵏ ⵉⵙⵍⵉ ⵛⴰ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⵓⵖⴰ ⵉ ⴷ ⴰⵙⴻⵏ ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵇⴱⴻⵍ. ");
INSERT INTO rift_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⵓⵍ ⵏ ⴼⵉⵔⵄⵓⵏ ⵉⴷⵡⴻⵍ ⵉⵇⵙⴻⵃ. ⵡⴰⵔ ⵉⵅⵙ ⴰⴷ ⵢⴻⵊⵊ ⴰⴷ ⵉⴼⴼⴻⵖ ⵍⴳⴻⵏⵙ. ");
INSERT INTO rift_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","ⵔⵓⵃ ⵜⵉⵡⴻⵛⵛⴰ ⵖⴰⵔ ⵚⵚⴱⴻⵃ ⵖⴰⵔ ⴼⵉⵔⵄⵓⵏ. ⵅⵣⴰⵔ, ⵏⴻⵜⵜⴰ ⴰⴷ ⵉⴼⴼⴻⵖ ⵖⴰⵔ ⵡⴰⵎⴰⵏ. ⵛⴻⴽ ⵔⴰⵊⴰ ⴷⵉⵏ ⵖⴰⵔ ⵜⵎⴰ ⵏ ⵢⵉⵖⵣⴰⵔ ⵓⵛⴰ ⴽⵙⵉ-ⴷⴷ ⵜⴰⵖⵖⴰⵔⵛⵜ ⵏⵏⵉ ⵉⴷⴻⵡⵍⴻⵏ ⴷ ⴰⴼⵉⵖⴰⵔ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","ⴰⴷ ⴰⵙ ⵜⵉⵏⵉⴷ: ‘ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏ ⵉⵄⵉⴱⵔⴰⵏⵉⵢⵢⴻⵏ ⵉⵙⵙⴻⴽⴽ ⴰⵢⵉ-ⴷⴷ ⵖⴰⵔⴻⴽ, ⵉⵏⵏⴰ: ⴻⵊⵊ ⴰⴷ ⵉⵔⴰⵃ ⵍⴳⴻⵏⵙ ⵉⵏⵓ, ⵃⵉⵎⴰ ⴰⴷ ⴰⵢⵉ ⵉⵄⴱⴻⴷ ⴷⵉ ⵍⴻⵅⵍⴰ! ⵅⵣⴰⵔ, ⴰⵍ ⵍⴻⵅⵅⵓ ⵡⴰⵔ ⵜⴻⵅⵙⴻⴷ ⴰⴷ ⵜⵙⴻⴵⴻⴷ. ");
INSERT INTO rift_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","ⴰⵎⵎⵓ ⵉ ⵉⵇⵇⴰⵔ ⵙⵉⴷⵉ: ‘ⵙ ⵎⴰⵏ ⴰⵢⴰ ⴰⴷ ⵜⴻⵙⵙⵏⴻⴷ ⴱⴻⵍⵍⵉ ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ!’ ⵅⵣⴰⵔ, ⵏⴻⵛⵛ ⴰⴷ ⵡⵜⴻⵖ ⴰⵎⴰⵏ ⵉ ⵉⴵⴰⵏ ⴷⴻⴳ ⵉⵖⵣⴰⵔ ⵙ ⵜⴻⵖⵖⴰⵔⵛⵜ ⵉ ⵖⴰⵔⵉ ⴷⴻⴳ ⵓⴼⵓⵙ ⵉⵏⵓ ⵓⵛⴰ ⴰⴷ ⴷⴻⵡⵍⴻⵏ ⴷ ⵉⴷⴰⵎⵎⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","ⵉⵙⴻⵍⵎⴰⵏ ⵉ ⵉⴵⴰⵏ ⴷⴻⴳ ⵉⵖⵣⴰⵔ ⴰⴷ ⵎⵎⵜⴻⵏ ⴰⵍ ⵖⴰ ⵢⵓⵔⵚⵓⴹ ⵉⵖⵣⴰⵔ ⵏ ⵏⵉⵍ, ⴰⴷ ⵄⵉⴼⴼⴻⵏ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ ⴰⴷ ⵙⵡⴻⵏ ⴰⵎⴰⵏ ⵏ ⵉⵖⵣⴰⵔ ⵏ ⵏⵉⵍ.’” ");
INSERT INTO rift_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵄⴰⵡⴻⴷ ⵉ ⵎⵓⵙⴰ: “ⵉⵏⵉ ⵉ ⵀⴰⵔⵓⵏ: ‘ⴽⵙⵉ ⵜⴰⵖⵖⴰⵔⵛⵜ ⵏⵏⴻⵛ, ⵙⵡⵉⵥⵥⴻⴹ ⴰⴼⵓⵙ ⵏⵏⴻⵛ ⵅ ⵡⴰⵎⴰⵏ ⵏ ⵎⵉⵚⵔⴰ, ⵅ ⵉⵖⴻⵣⵔⴰⵏ ⵏⵙⴻⵏ, ⵅ ⵜⵖⴻⵣⵔⴰⵜⵉⵏ ⵏⵙⴻⵏ, ⵅ ⵉⵢⴻⵍⵎⴰⵎⴻⵏ ⵏⵙⴻⵏ ⵅ ⵎⴰⵔⵔⴰ ⵉⵎⵓⵛⴰⵏ ⵎⴰⵏⵉⵙ ⵜⵜⵎⵓⵏⴰⵏ ⵡⴰⵎⴰⵏ ⵓⵛⴰ ⴰⴷ ⴷⴻⵡⵍⴻⵏ ⴷ ⵉⴷⴰⵎⵎⴻⵏ. ⴰⴷ ⴷⴻⵡⵍⴻⵏ ⴷ ⵉⴷⴰⵎⵎⴻⵏ ⵅ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ, ⵓⵍⴰ ⴷⵉ ⵍⴻⵇⵛⵓⵄ ⵏ ⵓⴽⴻⵛⵛⵓⴹ ⴷ ⵡⴻⵥⵔⵓ.’” ");
INSERT INTO rift_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ ⴳⴳⵉⵏ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵉ ⴷ ⴰⵙⴻⵏ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ. ⵉⵙⵙⴳⴻⵄⵄⴻⴷ ⵀⴰⵔⵓⵏ ⵜⴰⵖⵖⴰⵔⵛⵜ, ⵉⵡⵜⴰ ⴰⵎⴰⵏ ⵏⵏⵉ ⵜⵓⵖⴰ ⴷⴻⴳ ⵉⵖⵣⴰⵔ ⵇⵉⴱⴰⵍⵜ ⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⴼⵉⵔⵄⵓⵏ ⴷ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵙ ⵓⵛⴰ ⵎⴰⵔⵔⴰ ⴰⵎⴰⵏ ⵏⵏⵉ ⵜⵓⵖⴰ ⴷⴻⴳ ⵉⵖⵣⴰⵔ ⴷⴻⵡⵍⴻⵏ ⴷ ⵉⴷⴰⵎⵎⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","ⵎⵎⵓⵜⴻⵏ ⵉⵙⴻⵍⵎⴰⵏ ⵉⵏⵏⵉ ⵜⵓⵖⴰ ⴷⴻⴳ ⵉⵖⵣⴰⵔ ⵓⵛⴰ ⵢⵓⵔⵚⵓⴹ ⵢⴻⵖⵣⴰⵔ ⴰⵍⴰⵎⵉ ⴷⴻⵡⵍⴻⵏ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ ⵡⴰⵔ ⵣⴻⵎⵎⴰⵔⴻⵏ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵙⵡⴻⵏ ⴰⵎⴰⵏ ⵓⵛⴰ ⴷⴻⵡⵍⴻⵏ ⵡⴰⵎⴰⵏ ⴷ ⵉⴷⴰⵎⵎⴻⵏ ⴷⵉ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","ⵎⴰⵛⴰ ⵜⴰⵔⵡⴰ ⵏ ⵜⵙⴻⵃⵃⴰⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⴳⴳⵉⵏ ⴰⵎⴻⵏⵏⵉ ⵙ ⵜⵎⴻⴳⴳⴰ ⵏⵙⴻⵏ ⵏ ⵙⵡⴰⴷⴷⴰⵢ ⵙⵡⴰⴷⴷⴰⵢ ⴰⵍⴰⵎⵉ ⵓⵍ ⵏ ⴼⵉⵔⵄⵓⵏ ⵉⴷⵡⴻⵍ ⵉⵇⵙⴻⵃ, ⵓ ⵏⴻⵜⵜⴰ ⵡⴰⵔ ⵖⴰⵔⵙⴻⵏ ⵉⵙⵙⵃⴻⵙⵙ ⵛⴰ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵙⴻⵏ ⵜⵓⵖⴰ ⵉⵏⵏⴰ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","ⵉⵏⵏⴻⵇⵍⴻⴱ ⴼⵉⵔⵄⵓⵏ ⵓⵛⴰ ⵢⵓⴷⴻⴼ ⵖⴰⵔ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⴻⵙ ⵓⵛⴰ ⵡⴰⵔ ⵉⴳⴳⵉ ⵓⵍ ⵏⵏⴻⵙ ⵄⴰⴷ ⴷⵉ ⵎⴰⵏ ⴰⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","ⵎⴰⵔⵔⴰ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ ⵖⵣⴰⵏ ⵅ ⵜⵎⴰ ⵏ ⵉⵖⵣⴰⵔ ⵏ ⵏⵉⵍ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴰⴼⴻⵏ ⴰⵎⴰⵏ ⵏ ⵜⴻⵙⵙⵉⵜ, ⵎⵉⵏⵣⵉ ⵡⴰⵔ ⵣⴻⵎⵎⴰⵔⴻⵏ ⴰⴷ ⵙⵡⴻⵏ ⴰⵎⴰⵏ ⵏ ⵉⵖⵣⴰⵔ ⵏ ⵏⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","ⴰⵎⵎⵓ ⵉ ⵄⴷⵓⵏ ⵙⴻⴱⵄⴰ ⵓⵙⵙⴰⵏ ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⵉⵡⵜⴰ ⵙⵉⴷⵉ ⵉⵖⵣⴰⵔ ⵏ ⵏⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("EX7_26","003_7_26","EXO","7","26","26","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⴰⴷⴻⴼ ⵖⴰⵔ ⴼⵉⵔⵄⵓⵏ, ⵉⵏⵉ ⴰⵙ: ‘ⴰⵎⵎⵓ ⵉ ⵉⵇⵇⴰⵔ ⵙⵉⴷⵉ: ⴻⵊⵊ ⴰⴷ ⵉⴼⴼⴻⵖ ⵍⴳⴻⵏⵙ ⵉⵏⵓ ⵃⵉⵎⴰ ⴰⴷ ⴰⵢⵉ ⵉⵄⴱⴻⴷ. ");
INSERT INTO rift_vpl VALUES ("EX7_27","003_7_27","EXO","7","27","27","ⵎⴰⵍⴰ ⵜⵓⴳⵉⴷ ⴰⴷ ⵜⴻⵏ ⵜⴻⵊⵊⴻⴷ ⴰⴷ ⵔⴰⵃⴻⵏ, ⴰⵇⴰ ⴰⴷ ⵡⵜⴻⵖ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵏⵏⴻⵛ ⵙ ⵉⵇⴰⵔⵇⵔⵉⵡⴻⵏ ");
INSERT INTO rift_vpl VALUES ("EX7_28","003_7_28","EXO","7","28","28","ⵓⵛⴰ ⵉⵖⵣⴰⵔ ⵏ ⵏⵉⵍ ⴰⴷ ⴷⴷ-ⵉⵙⴻⴼⴼⵉⵢ ⵅ ⵉⵇⴰⵔⵇⵔⵉⵡⴻⵏ, ⴰⴷ ⵣⵣⴰⵢⴻⵙ-ⴷⴷ ⴳⴻⵄⵄⴷⴻⵏ, ⴰⴷ ⴰⴷⴼⴻⵏ ⵖⴰⵔ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⴻⵛ ⵓ ⵖⴰⵔ ⵡⴻⵅⵅⴰⵎ ⵏⵏⴻⵛ ⵏ ⵢⵉⴹⴻⵚ, ⴰⴷ ⴷⴷ-ⴰⵙⴻⵏ ⵅ ⵇⴰⵎⴰ ⵏⵏⴻⵛ ⵓⵍⴰ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵛ ⵓ ⵊⴰⵔ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵛ, ⵓ ⵄⴰⴷ ⴷⴻⴳ ⵉⴼⴰⵔⵔⴰⵏⴻⵏ ⵏⵏⴻⵛ ⵓ ⴷⵉ ⵜⴱⴻⵇⵢⵉⵏ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("EX7_29","003_7_29","EXO","7","29","29","ⴰⴷ ⵅⴰⴽ ⴷⴷ-ⴳⴻⵄⵄⴷⴻⵏ ⵉⵇⴰⵔⵇⵔⵉⵡⴻⵏ ⵓⵍⴰ ⵅ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵛ ⵓ ⵅ ⵎⴰⵔⵔⴰ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵛ.’” ");
INSERT INTO rift_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵄⴰⵡⴻⴷ ⵉ ⵎⵓⵙⴰ: “ⵉⵏⵉ ⵉ ⵀⴰⵔⵓⵏ: ‘ⵙⵡⵉⵥⵥⴻⴹ ⴰⴼⵓⵙ ⵏⵏⴻⵛ ⵙ ⵜⴻⵖⵖⴰⵔⵛⵜ ⵏⵏⴻⵛ ⵅ ⵉⵖⴻⵣⵔⴰⵏ, ⵅ ⵜⵖⴻⵣⵔⴰⵜⵉⵏ ⵓⵍⴰ ⵅ ⵉⵢⴻⵍⵎⴰⵎⴻⵏ, ⵙⴳⴻⵄⵄⴻⴷ ⵉⵇⴰⵔⵇⵔⵉⵡⴻⵏ ⵅ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ.’” ");
INSERT INTO rift_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","ⵓⵛⴰ ⵉⵙⵙⵡⵉⵥⵥⴻⴹ ⵀⴰⵔⵓⵏ ⴰⴼⵓⵙ ⵏⵏⴻⵙ ⵅ ⵡⴰⵎⴰⵏ ⵏ ⵎⵉⵚⵔⴰ ⵓⵛⴰ ⴳⴻⵄⵄⴷⴻⵏ-ⴷⴷ ⵉⵇⴰⵔⵇⵔⵉⵡⴻⵏ ⵓⵛⴰ ⴷⵍⵉⵏ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","ⵓⵛⴰ ⵓⵍⴰ ⴷ ⵜⴰⵔⵡⴰ ⵏ ⵜⵙⴻⵃⵃⴰⵔⵜ ⴳⴳⵉⵏ ⴰⵎⴻⵏⵏⵉ ⵙ ⵜⵎⴻⴳⴳⴰ ⵏⵙⴻⵏ ⵏ ⵙⵡⴰⴷⴷⴰⵢ ⵙⵡⴰⴷⴷⴰⵢ ⴷ ⵉⵛⵜ, ⵓⵛⴰ ⵙⵙⴳⴻⵄⵄⴷⴻⵏ-ⴷⴷ ⵄⴰⵡⴻⴷ ⵉⵇⴰⵔⵇⵔⵉⵡⴻⵏ ⵅ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","ⵉⵍⴰⵖⴰ-ⴷⴷ ⴼⵉⵔⵄⵓⵏ ⵅ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ, ⵉⵏⵏⴰ ⴰⵙⴻⵏ: “ⵥⴰⴵⴻⵎ ⵙ ⵍⴰⴵⴰⵖ ⵉ ⵙⵉⴷⵉ ⵃⵉⵎⴰ ⴰⴷ ⵅⴰⴼⵉ ⵉⴽⵙⵉ ⵉⵇⴰⵔⵇⵔⵉⵡⴻⵏ ⵓ ⵅ ⵍⴳⴻⵏⵙ ⵉⵏⵓ, ⵓⵛⴰ ⵅⴻⵏⵏⵉ ⴰⴷ ⵊⵊⴻⵖ ⴰⴷ ⵉⴼⴼⴻⵖ ⵍⴳⴻⵏⵙ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵇⴻⴷⴷⵎⴻⵏ ⵜⵉⵖⴰⵔⵚⴰ ⵉ ⵙⵉⴷⵉ.” ");
INSERT INTO rift_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","ⵉⵏⵏⴰ ⵎⵓⵙⴰ ⵉ ⴼⵉⵔⵄⵓⵏ: “ⵟⵟⴻⴼ ⵅⴰⴼⵉ ⵍⵃⵓⵔⵎⴻⵜ ⵎⴻⵍⵎⵉ ⴷ ⴰⵢⵉ ⵖⴰ ⵜⵉⵏⵉⴷ ⴰⴷ ⵅⴰⴽ ⵥⵥⴰⴵⴻⵖ ⵓ ⵅ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵛ ⵓ ⵅ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵛ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵅⴰⴽ ⵇⴻⴹⵄⴻⵖ ⵉⵇⴰⵔⵇⵔⵉⵡⴻⵏ ⵓ ⵅ ⵜⵓⴷⵔⵉⵏ ⵏⵏⴻⵛ, ⴰⴷ ⵇⵇⵉⵎⴻⵏ ⴷⴻⴳ ⵉⵖⵣⴰⵔ ⵡⴰⵀⴰ.” ");
INSERT INTO rift_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","ⵢⴰⵔⵔⴰ-ⴷⴷ ⵅⴰⵙ: “ⵜⵉⵡⴻⵛⵛⴰ!” ⵉⵏⵏⴰ ⵎⵓⵙⴰ: “ⴰⴷ ⵢⵉⵍⵉ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⴻⵏⵏⵉⴷ ⵃⵉⵎⴰ ⴰⴷ ⵜⴻⵙⵙⵏⴻⴷ ⴱⴻⵍⵍⵉ ⵡⴰⵔ ⴷⵉⵏ ⵉⴵⵉ ⵃⴻⴷ ⴰⵎ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","ⵓⵛⴰ ⵉⵇⴰⵔⵇⵔⵉⵡⴻⵏ ⴰⴷ ⵎⵎⴻⴽⵙⵉⵏ ⵅⴰⴽ ⵓ ⵅ ⵜⵓⴷⵔⵉⵏ ⵏⵏⴻⵛ ⵓⵍⴰ ⵅ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵛ ⵓ ⵅ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵛ, ⴰⴷ ⵇⵇⵉⵎⴻⵏ ⴷⴻⴳ ⵉⵖⵣⴰⵔ ⵡⴰⵀⴰ.” ");
INSERT INTO rift_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⴼⴼⴻⵖ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ ⵅ ⴼⵉⵔⵄⵓⵏ ⵓⵛⴰ ⵉⵍⴰⵖⴰ ⵎⵓⵙⴰ ⵉ ⵙⵉⴷⵉ ⴷⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⵊⵊⵔⵉⵃⴻⵛⵜ ⵏ ⵉⵇⴰⵔⵇⵔⵉⵡⴻⵏ ⵏⵏⵉ ⵜⵓⵖⴰ ⵉⴳⴳⴰ ⵅ ⴼⵉⵔⵄⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","ⵓⵛⴰ ⵉⴳⴳⴰ ⵙⵉⴷⵉ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷⴷ-ⵉⵜⵜⴰⵙ ⴰⴽ-ⴷ ⵡⴰⵡⴰⵍ ⵏ ⵎⵓⵙⴰ ⵓⵛⴰ ⵎⵎⵓⵜⴻⵏ ⵉⵇⴰⵔⵇⵔⵉⵡⴻⵏ ⵓⵛⴰ ⵡⴻⴷⴷⴰⵔⴻⵏ ⵣⵉ ⵜⵓⴷⵔⵉⵏ, ⵣⵉ ⵍⴻⵎⵔⴰⵃⴰⵜ ⵓ ⵣⴻⴳ ⵉⵢⵢⴰⵔⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","ⵓⵛⴰ ⵙⵙⵎⵓⵏⴻⵏ ⵜⴻⵏ ⴷ ⵉⵄⵓⵔⵔⴰⵛ ⵓⵛⴰ ⵜⵓⵔⵚⵓⴹ ⵣⵣⴰⵢⵙⴻⵏ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","ⵍⴰⵎⵉ ⵉⵥⵔⴰ ⴼⵉⵔⵄⵓⵏ ⴱⴻⵍⵍⵉ ⴰⵇⴰ ⴱⵏⴰⴷⴻⵎ ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵢⴰⵔⵔ ⵏⵏⴻⴼⵙ, ⵉⵙⵙⴻⵇⵙⴻⵃ ⵓⵍ ⵏⵏⴻⵙ ⵓⵛⴰ ⵡⴰⵔ ⵖⴰⵔⵙⴻⵏ ⵉⵙⵙⵃⴻⵙⵙ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⵓⵖⴰ ⵉⵏⵏⴰ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⵉⵏⵉ ⵉ ⵀⴰⵔⵓⵏ: ‘ⵙⵡⵉⵥⵥⴻⴹ ⵜⴰⵖⵖⴰⵔⵛⵜ ⵏⵏⴻⵛ, ⵜⴻⵡⵜⴻⴷ ⵣⵣⴰⵢⴻⵙ ⴰⵛⴰⵍ ⵏ ⵜⴻⵎⵎⵓⵔⵜ. ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⴷⵡⴻⵍ ⴷ ⵏⵏⴰⵎⵓⵙ ⵅ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ.’” ");
INSERT INTO rift_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⴳⴳⵉⵏ ⵏⵉⵜⵏⵉ. ⵉⵙⵙⵡⵉⵥⵥⴻⴹ ⵀⴰⵔⵓⵏ ⴰⴼⵓⵙ ⵏⵏⴻⵙ ⵙ ⵜⴻⵖⵖⴰⵔⵛⵜ ⵏⵏⴻⵙ ⵉ ⴷⴰⵢⴻⵙ, ⵉⵡⵜⴰ ⴰⵛⴰⵍ ⵏ ⵜⴻⵎⵎⵓⵔⵜ. ⵓⵛⴰ ⵢⵓⵙⴰ-ⴷⴷ ⵏⵏⴰⵎⵓⵙ ⴰⵎ ⵅ ⵉⵡⴷⴰⵏ ⴰⵎ ⵅ ⵍⵎⴰⵍ. ⵎⴰⵔⵔⴰ ⴰⵛⴰⵍ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵉⴷⵡⴻⵍ ⴷ ⵏⵏⴰⵎⵓⵙ ⴷⵉ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","ⵜⴰⵔⵡⴰ ⵏ ⵜⵙⴻⵃⵃⴰⵔⵜ ⴳⴳⵉⵏ ⵜⵉⵣⴻⵎⵎⴰⵔ ⵏⵙⴻⵏ ⴰⵎⴻⵏⵏⵉ ⵄⴰⵡⴻⴷ ⵙ ⵜⵎⴻⴳⴳⴰ ⵏⵙⴻⵏ ⵏ ⵙⵡⴰⴷⴷⴰⵢ ⵙⵡⴰⴷⴷⴰⵢ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵙⵙⵓⴼⴼⵖⴻⵏ ⵏⵏⴰⵎⵓⵙ, ⵎⴰⵛⴰ ⵡⴰⵔ ⵣⴻⵎⵎⴰⵔⴻⵏ. ⵓⵛⴰ ⵜⵓⵖⴰ ⵏⵏⴰⵎⵓⵙ ⵅ ⵉⵡⴷⴰⵏ ⴷ ⵍⵎⴰⵍ. ");
INSERT INTO rift_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵏⵏⴰⵏ ⵜⴰⵔⵡⴰ ⵏ ⵜⵙⴻⵃⵃⴰⵔⵜ ⵉ ⴼⵉⵔⵄⵓⵏ: “ⵎⴰⵏ ⴰⵢⴰ ⴷ ⴰⴹⴰⴹ ⵏ ⴰⵔⴻⴱⴱⵉ!” ⵎⴰⵛⴰ ⵉⵙⵙⴻⵇⵙⴻⵃ ⵓⵍ ⵏ ⴼⵉⵔⵄⵓⵏ ⵓⵛⴰ ⵡⴰⵔ ⴷⴷ ⵖⴰⵔⵙⴻⵏ ⵉⵙⴻⴵ ⵛⴰ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⵓⵖⴰ ⵉⵏⵏⴰ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","ⵓⵛⴰ ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⵜⵉⵡⴻⵛⵛⴰ ⴽⴽⴰⵔ ⵣⵉⵛ, ⴰⴷ ⵜⴱⴻⴷⴷⴻⴷ ⵣⵣⴰⵜ ⵉ ⴼⵉⵔⵄⵓⵏ. ⵅⵣⴰⵔ, ⵏⴻⵜⵜⴰ ⴰⴷ ⵉⴼⴼⴻⵖ ⵖⴰⵔ ⵜⵎⴰ ⵏ ⵡⴰⵎⴰⵏ, ⴰⴷ ⴰⵙ ⵜⵉⵏⵉⴷ: ‘ⴰⵎⵎⵓ ⵉ ⵉⵇⵇⴰⵔ ⵙⵉⴷⵉ: ⴻⵊⵊ ⴰⴷ ⵉⵔⴰⵃ ⵍⴳⴻⵏⵙ ⵉⵏⵓ, ⵃⵉⵎⴰ ⴰⴷ ⴰⵢⵉ ⵉⵄⴱⴻⴷ! ");
INSERT INTO rift_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","ⵎⵉⵏⵣⵉ ⵎⴰⵍⴰ ⵡⴰⵔ ⵜⴻⵊⵊⵉⴷ ⵍⴳⴻⵏⵙ ⵉⵏⵓ ⴰⴷ ⵉⵔⴰⵃ, ⵅⵣⴰⵔ, ⵏⴻⵛⵛ ⴰⴷ ⵅⴰⴽ ⵙⵙⴻⴽⴽⴻⵖ ⵉⵢⵍⴰⴼⴻⵏ ⵏ ⵉⴱⴻⵄⵄⴰⵛ, ⵅ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵛ, ⵅ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵛ, ⵅ ⵜⵓⴷⵔⵉⵏ ⵏⵏⴻⵛ, ⴰⵍ ⵖⴰ ⵜⵜⵡⴰⵛⵛⵓⵔⴻⵏⵜ ⵜⵓⴷⵔⵉⵏ ⵏ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ ⵙ ⵉⵢⵍⴰⴼⴻⵏ ⵏ ⵉⴱⴻⵄⵄⴰⵛ ⵓⵛⴰ ⴰⵎⴻⵏⵏⵉ ⵓⵍⴰ ⴷ ⵜⴰⵎⵎⵓⵔⵜ ⵎⴰⵏⵉ ⵣⴻⴷⴷⵖⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","ⴷⴻⴳ ⵡⴰⵙⵙ ⵏⵏⵉ ⴰⴷ ⵙⵙⵃⵓⵣⴻⵖ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵊⵓⵛⴰⵏ ⵎⴰⵏⵉ ⵉⵣⴻⴷⴷⴻⵖ ⵍⴳⴻⵏⵙ ⵉⵏⵓ, ⵃⵉⵎⴰ ⵡⴰⵔ ⴷⵉⵏ ⵜⵜⵉⵍⵉⵏ ⵡⴻⵢⵍⴰⴼⴻⵏ ⵏ ⵉⴱⴻⵄⵄⴰⵛ ⵃⵉⵎⴰ ⴰⴷ ⵜⴻⵙⵙⵏⴻⴷ ⴱⴻⵍⵍⵉ ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","ⵓⵛⴰ ⴰⴷ ⴳⴳⴻⵖ ⵉⵊⵊ ⵏ ⵜⵜⴰⵎⴰⵏ ⵏ ⵡⴻⵚⵍⴰⵃ ⵊⴰⵔ ⵍⴳⴻⵏⵙ ⵉⵏⵓ ⴷ ⵡⴻⵏⵏⵉ ⵏⵏⴻⵛ. ⵜⵉⵡⴻⵛⵛⴰ ⴰⴷ ⵜⵉⵍⵉ ⵍⴻⵄⵍⴰⵎⴻⵜ-ⴰ.’” ");
INSERT INTO rift_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⵉⴳⴳⴰ ⵙⵉⴷⵉ. ⵓⵙⵉⵏ-ⴷⴷ ⵉⵢⵍⴰⴼⴻⵏ ⵉⵎⴻⵇⵇⵔⴰⵏⴻⵏ ⵏ ⵉⴱⴻⵄⵄⴰⵛ ⵅ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⴼⵉⵔⵄⵓⵏ, ⵅ ⵜⵓⴷⵔⵉⵏ ⵏ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵙ ⵓ ⵅ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⵓⵛⴰ ⵜᵉⵜⵜⵡⴰⵅⴰⵔⵔⴻⴱ ⵜⴻⵎⵎⵓⵔⵜ ⵙ ⵉⵢⵍⴰⴼⴻⵏ ⵏ ⵉⴱⴻⵄⵄⴰⵛ. ");
INSERT INTO rift_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⵍⴰⵖⴰ ⴼⵉⵔⵄⵓⵏ ⵉ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ, ⵉⵏⵏⴰ ⴰⵙⴻⵏ: “ⵔⵓⵃⴻⵎ, ⵜⵇⴻⴷⴷⵎⴻⵎ ⵜⴰⵖⴰⵔⵚⵜ ⵉ ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ-ⴰ.” ");
INSERT INTO rift_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","ⵉⵏⵏⴰ ⵎⵓⵙⴰ: “ⵡⴰⵔ ⴷⴷ-ⵢⵓⵙⵉ ⴰⴷ ⵏⴻⴳⴳ ⴰⵎⵎⵓ, ⵎⵉⵏⵣⵉ ⴰⴷ ⵏⵇⴻⴷⴷⴻⵎ ⵜⴰⵖⴰⵔⵚⵜ ⵉ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵖ, ⵎⵉⵏ ⵉⴵⴰⵏ ⴷ ⵉⵛⵜ ⵏ ⵊⵊⵄⵉⴼⴻⵛⵜ ⵖⴰⵔ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ. ⵅⵣⴰⵔ, ⵎⴰⵍⴰ ⵏⵇⴻⴷⴷⴻⵎ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵣⵣⴰⵜ ⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ ⵎⵉⵏ ⴷ ⴰⵙⴻⵏ ⵉⵜⵜⵖⵉⵍ ⴷ ⵊⵊⵄⵉⴼⴻⵛⵜ, ⵎⴰ ⵡⴰⵔ ⴷ ⴰⵏⴻⵖ ⵜⴰⵔⴻⵊⵊⵎⴻⵏ ⵛⴰ? ");
INSERT INTO rift_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","ⴻⵊⵊ ⴰⵏⴻⵖ ⴰⴷ ⵏⵔⴰⵃ ⵜⵉⵛⵍⵉ ⵏ ⵜⵍⴰⵜⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⴷⵉ ⵍⴻⵅⵍⴰ, ⵃⵉⵎⴰ ⴰⴷ ⵏⵇⴻⴷⴷⴻⵎ ⵜⴰⵖⴰⵔⵚⵜ ⵉ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵖ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵏⴻⵖ ⵢⵓⵎⵓⵔ ⵏⴻⵜⵜⴰ.” ");
INSERT INTO rift_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⴼⵉⵔⵄⵓⵏ: “ⵏⴻⵛⵛ ⴰⴷ ⴽⴻⵏⵏⵉⵡ ⵊⵊⴻⵖ ⴰⴷ ⵜⵔⴰⵃⴻⵎ ⵓⵛⴰ ⴰⴷ ⵜⵇⴻⴷⴷⵎⴻⵎ ⵜⴰⵖⴰⵔⵚⵜ ⵉ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ, ⴷⵉ ⵍⴻⵅⵍⴰ, ⵎⴰⵛⴰ ⵡⴰⵔ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⵜⵉⴳⴳⵯⵉⵊⴻⵎ ⴰⵟⵟⴰⵙ. ⵥⴰⴵⴻⵎ ⵓⵍⴰ ⵅⴰⴼⵉ.” ");
INSERT INTO rift_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","ⵎⵓⵙⴰ ⵉⵏⵏⴰ: “ⴰⵇⴰ ⴰⴷ ⵅⴰⴽ ⴼⴼⵖⴻⵖ, ⴰⴷ ⵥⵥⴰⴵⴻⵖ ⵉ ⵙⵉⴷⵉ, ⵃⵉⵎⴰ ⴰⴷ ⵉⴽⴽⴻⵙ ⵜⵉⵡⴻⵛⵛⴰ ⵉⵢⵍⴰⴼⴻⵏ ⵏ ⵉⴱⴻⵄⵄⴰⵛ ⵅ ⴼⵉⵔⵄⵓⵏ, ⵅ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵙ ⵓⵍⴰ ⵅ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ. ⵎⴰⵛⴰ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴼⵉⵔⵄⵓⵏ ⵡⴰⵔ ⵉⵅⴻⴷⴷⴻⵄ ⵜⵡⴰⵍⴰ ⵏⵏⴻⵖⵏⵉ, ⵡⴰⵔ ⵉⵜⵜⴻⵊⵊⵉ ⴰⴷ ⵉⵔⴰⵃ ⵍⴳⴻⵏⵙ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⵇⴻⴷⴷⴻⵎ ⵜⴰⵖⴰⵔⵚⵜ ⵉ ⵙⵉⴷⵉ.” ");
INSERT INTO rift_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⴼⴼⴻⵖ ⵎⵓⵙⴰ ⵅ ⴼⵉⵔⵄⵓⵏ ⵓⵛⴰ ⵉⵥⵥⵓⴵ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","ⵉⴳⴳⴰ ⵙⵉⴷⵉ ⵄⵍⴰⵃⵙⴰⴱ ⴰⵡⴰⵍ ⵉ ⵉⵏⵏⴰ ⵎⵓⵙⴰ ⵓⵛⴰ ⵉⴽⴽⴻⵙ ⵉⵢⵍⴰⴼⴻⵏ ⵏ ⵉⴱⴻⵄⵄⴰⵛ ⵅ ⴼⵉⵔⵄⵓⵏ, ⵅ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵙ, ⵓⵍⴰ ⵅ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ. ⵡⴰⵔ ⵉⵇⵇⵉⵎ ⵓⵍⴰ ⴷ ⵉⵊⵊ ⵏ ⵓⴱⴻⵄⵄⵓⵛ. ");
INSERT INTO rift_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","ⵎⴰⵛⴰ ⴼⵉⵔⵄⵓⵏ ⵉⵙⵙⴻⵇⵙⴻⵃ ⵓⵍ ⵏⵏⴻⵙ ⵜⵡⴰⵍⴰ-ⵢⴰ ⵄⴰⵡⴻⴷ, ⵡⴰⵔ ⵉⵊⵊⵉ ⴰⴷ ⵉⵔⴰⵃ ⵍⴳⴻⵏⵙ. ");
INSERT INTO rift_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⴰⴷⴻⴼ ⵖⴰⵔ ⴼⵉⵔⵄⵓⵏ, ⵉⵏⵉ ⴰⵙ: ‘ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏ ⵉⵄⵉⴱⵔⴰⵏⵉⵢⵢⴻⵏ ⵉⵇⵇⴰⵔ ⴰⵎⵎⵓ: ⴻⵊⵊ ⴰⴷ ⵉⵔⴰⵃ ⵍⴳⴻⵏⵙ ⵉⵏⵓ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴰⵢⵉ ⵉⵄⴱⴻⴷ. ");
INSERT INTO rift_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","ⵎⵉⵏⵣⵉ ⵎⴰⵍⴰ ⵜⵓⴳⵉⴷ ⴰⴷ ⵜⴻⵏ ⵜⴻⵊⵊⴻⴷ ⴰⴷ ⵔⴰⵃⴻⵏ ⵓⵛⴰ ⴰⴷ ⵜⴻⵏ ⵜᵉⵟⵟⴼⴻⴷ ⵄⴰⴷ ⴽⵜⴰⵔ, ");
INSERT INTO rift_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ⵅⵣⴰⵔ, ⴰⴼⵓⵙ ⵏ ⵙⵉⴷⵉ ⴰⴷ ⵢⵉⵍⵉ ⵅ ⵍⵎⴰⵍ ⵏⵏⴻⵛ ⵏⵏⵉ ⵉⴵⴰⵏ ⴷⴻⴳ ⵉⵢⵢⴰⵔ, ⵅ ⵉⵢⵙⴰⵏ ⴷ ⵢⴻⵖⵢⴰⵍ ⴷ ⵢⵉⵍⴻⵖⵎⴰⵏ ⴷ ⵉⴼⵓⵏⴰⵙⴻⵏ ⴷ ⵜⴼⵓⵏⴰⵙⵉⵏ ⵓⵍⴰ ⵅ ⵡⵓⴵⵉ ⵙ ⵢⵉⵊⵊ ⵏ ⵟⵟⴰⵄⵓⵏ ⵉⵇⴻⵙⵃⴻⵏ ⴰⵟⵟⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","ⴰⴷ ⵉⴼⴰⵔⵣ ⵙⵉⴷⵉ ⵊⴰⵔ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴷ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ, ⵃⵉⵎⴰ ⵡⴰⵔ ⵉⵜⵜⵎⴻⵜⵜⵉ ⵡⴰⵍⵓ ⵣⵉ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⴵⴰⵏ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ.’” ");
INSERT INTO rift_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","ⵓⵛⴰ ⵉⵏⴻⵢⵢⴻⵛ ⵙⵉⴷⵉ ⵉⵛⵜ ⵏ ⵍⵡⴻⵇⵜ ⵓⵎⵉ ⵉⵏⵏⴰ: “ⵜⵉⵡⴻⵛⵛⴰ ⴰⴷ ⵢⴻⴳⴳ ⵙⵉⴷⵉ ⵎⴰⵏ ⴰⵢⴰ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ.” ");
INSERT INTO rift_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","ⵜⵉⵡⴻⵛⵛⴰ ⵏⵏⴻⵙ ⵉⴳⴳⴰ ⵙⵉⴷⵉ ⴷⴷⴻⵇⵇ ⵏⵏⵉ ⵓⵛⴰ ⵎⵎⵓⵜⴻⵏ ⵎⴰⵔⵔⴰ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏ ⵎⵉⵚⵔⴰ, ⵎⴰⵛⴰ ⵣⵉ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵡⴰⵔ ⵜⴻⵎⵎⵓⵜ ⵓⵍⴰ ⴷ ⵉⵛⵜ ⵣⵣⴰⵢⵙⴻⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","ⵓⵛⴰ ⵉⵙⵙⴻⴽⴽ ⴼⵉⵔⵄⵓⵏ ⵉⵊⵊⴻⵏ, ⵓⵛⴰ ⴰⵇⴰ ⴷⴰ, ⵡⴰⵔ ⵜⴻⵎⵎⵓⵜ ⵓⵍⴰ ⴷ ⵉⵛⵜ ⵣⵉ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ⵎⴰⵛⴰ ⵓⵍ ⵏ ⴼⵉⵔⵄⵓⵏ ⵉⴷⵡⴻⵍ ⵉⵇⵙⴻⵃ ⵓⵛⴰ ⵡⴰⵔ ⵢⴻⵊⵊⵉ ⴰⴷ ⵉⴼⴼⴻⵖ ⵍⴳⴻⵏⵙ. ");
INSERT INTO rift_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ: “ⵄⴻⵎⵎⴰⵔ ⵓⵔⵓ ⵏ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵡⴻⵎ ⵙ ⵉⵖⵖⴻⴹ ⵣⵉ ⵜⴻⴼⵇⵓⵏⵜ ⵓⵛⴰ ⴻⵊⵊ ⵎⵓⵙⴰ ⴰⴷ ⵜ ⵉⵣⵣⵓⵣⴰⵔ ⴷⴻⴳ ⵓⵊⴻⵏⵏⴰ ⵇⵉⴱⴰⵍⵜ ⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⴼⵉⵔⵄⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","ⴰⴷ ⵉⴷⵡⴻⵍ ⵉⵖⵖⴻⴹ ⴷ ⵜⴰⵄⴻⵊⵊⴰⵊⵜ ⵉⴼⵙⵓⵙⴻⵏ ⵅ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⵓⵛⴰ ⵜⴰⵄⴻⵊⵊⴰⵛⵜ ⴰⴷ ⵜⴻⴷⵡⴻⵍ ⴷ ⵜⵉⵃⴻⴱⴱⴰ ⵙ ⵍⴻⵡⵄⵉ ⵅ ⴱⵏⴰⴷⴻⵎ ⵓ ⵅ ⵍⵎⴰⵍ ⴷⵉ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ.” ");
INSERT INTO rift_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","ⵓⵛⴰ ⴽⵙⵉⵏ ⵉⵖⵖⴻⴹ ⵣⵉ ⵜⴻⴼⵇⵓⵏⵜ ⴰⵎ ⵜⵓⵖⴰ ⴱⴻⴷⴷⴻⵏ ⵣⵣⴰⵜ ⵉ ⴼⵉⵔⵄⵓⵏ ⵓⵛⴰ ⵉⵣⵣⵓⵣⴰⵔ ⵉ-ⵜ ⵎⵓⵙⴰ ⴷⴻⴳ ⵓⵊⴻⵏⵏⴰ ⵓⵛⴰ ⵉⴷⵡⴻⵍ ⴷ ⵜⵉⵃⴻⴱⴱⴰ ⵙ ⵍⴻⵡⵄⵉ ⴰⵎ ⴷⴻⴳ ⵉⵡⴷⴰⵏ ⴰⵎ ⴷⵉ ⵍⵎⴰⵍ, ");
INSERT INTO rift_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","ⴰⵍⴰⵎⵉ ⵜⴰⵔⵡⴰ ⵏ ⵜⵙⴻⵃⵃⴰⵔⵜ ⵡⴰⵔ ⵣⴻⵎⵎⴰⵔⴻⵏ ⴰⴷ ⵇⵇⵉⵎⴻⵏ ⴱⴻⴷⴷⴻⵏ ⵣⵣⴰⵜ ⵉ ⵎⵓⵙⴰ ⴷⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⵜⵃⴻⴱⴱⴰ, ⵎⵉⵏⵣⵉ ⵜⵉⵃⴻⴱⴱⴰ ⵃⴻⴽⵎⴻⵏⵜ ⵉⵙⴻⵃⵃⴰⵔⴻⵏ ⴷ ⵎⴰⵔⵔⴰ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","ⵎⴰⵛⴰ ⵙⵉⴷⵉ ⵉⵙⵙⴻⵇⵙⴻⵃ ⵓⵍ ⵏ ⴼⵉⵔⵄⵓⵏ, ⴰⵍⴰⵎⵉ ⵡⴰⵔ ⴷ ⴰⵙⴻⵏ ⵉⵙⴻⴵ ⵛⴰ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⵓⵖⴰ ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⵜⵉⵡⴻⵛⵛⴰ ⴽⴽⴰⵔ ⵣⵉⵛ, ⵜⴱⴻⴷⴷⴻⴷ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⴼⵉⵔⵄⵓⵏ ⵓⵛⴰ ⵉⵏⵉ ⴰⵙ: ‘ⴰⵎⵎⵓ ⵉ ⵉⵇⵇⴰⵔ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏ ⵉⵄⵉⴱⵔⴰⵏⵉⵢⵢⴻⵏ: ⴻⵊⵊ ⴰⴷ ⵉⵔⴰⵃ ⵍⴳⴻⵏⵙ ⵉⵏⵓ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴰⵢⵉ ⵉⵄⴱⴻⴷ. ");
INSERT INTO rift_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","ⵎⵉⵏⵣⵉ ⵜⵡⴰⵍⴰ-ⵢⴰ ⵏⴻⵛⵛ ⴰⴷ ⵛⴻⴽ ⵍⴻⵇⴼⴻⵖ ⴷⴻⴳ ⵡⵓⵍ ⵙ ⵎⴰⵔⵔⴰ ⵊⵊⵔⴰⵢⴻⵃ ⵉⵏⵓ ⵓⵛⴰ ⵓⵍⴰ ⴷ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵛ ⴷ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵛ, ⵃⵉⵎⴰ ⴰⴷ ⵜⴻⵙⵙⵏⴻⴷ ⴱⴻⵍⵍⵉ ⵡⴰⵔ ⵉⴵⵉ ⵃⴻⴷ ⴰⵎ ⵏⴻⵛⵛ ⴷⵉ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","ⵎⵉⵏⵣⵉ ⵄⴰⴷ ⵍⴻⵅⵅⵓ ⵜⵓⵖⴰ ⵣⴻⵎⵎⴰⵔⴻⵖ ⴰⴷ ⵙⵙⵡⵉⵥⵥⴹⴻⵖ ⴰⴼⵓⵙ ⵉⵏⵓ, ⵃⵉⵎⴰ ⴰⴷ ⵛⴻⴽ ⵡⵜⴻⵖ ⵓⵍⴰ ⴷ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵛ ⵙ ⵟⵟⴰⵄⵓⵏ ⵓⵛⴰ ⵜⵓⵖⴰ ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵜᵉⵜⵜⵡⴰⵜⴻⵃⵃⵉⴷ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","ⵎⴰⵛⴰ ⵙ ⵜⵉⴷⴻⵜⵜ ⵏⴻⵛⵛ ⵙⵙⴱⴻⴷⴷⴻⵖ ⵛⴻⴽ ⵃⵉⵎⴰ ⴰⴷ ⴰⵛ ⵙⵙⴻⵛⵏⴻⵖ ⵊⵊⴻⵀⴷ ⵉⵏⵓ ⵓ ⵃⵉⵎⴰ ⴰⴷ ⵉⵜⵜⵡⴰⵛⴻⵏⵏⴻⵄ ⵉⵙⴻⵎ ⵉⵏⵓ ⴷⵉ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","ⵎⴰ ⵜᵉⵜⵜⴻⴳⴳⴻⴷ ⵄⴰⴷ ⵜⵉⵄⵉⵏⴽⵔⵉⴼⵉⵏ ⴹⵉⴷⴷ ⵉ ⵍⴳⴻⵏⵙ ⵉⵏⵓ, ⵃⵉⵎⴰ ⵡⴰⵔ ⵜⴻⵏ ⵜⴻⵊⵊⵉⴷ ⴰⴷ ⵔⴰⵃⴻⵏ? ");
INSERT INTO rift_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","ⵅⵣⴰⵔ, ⵜⵉⵡⴻⵛⵛⴰ ⵖⴰⵔ ⵜⵙⴰⵄⵄⴻⵜ-ⴰ ⵏⴻⵛⵛ ⴰⴷ ⴰⵔⵔⴻⵖ ⵜⴰⴱⵔⵓⵔⵔⵉ ⵉⴷⴷⴻⵇⵍⴻⵏ ⴰⴷ ⵜⴻⵡⵡⴻⵜ, ⵜⴰⴱⵔⵓⵔⵔⵉ ⵉ ⵡⴰⵔ ⵜⵓⵖⵉ ⵄⴻⵎⵎⴰⵔⵚ ⴷⵉ ⵎⵉⵚⵔⴰ ⵣⴻⴳ ⵡⴰⵙⵙ ⵉ ⴷⵉ ⵜᵉⵜⵜⵡⴰⴱⵏⴰ ⴰⵍ ⵉ ⵍⴻⵅⵅⵓ. ");
INSERT INTO rift_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","ⵅⴻⵏⵏⵉ ⵙⴻⴽⴽ ⵍⴻⵅⵅⵓ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⴽ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵙⵙⵉⴷⴼⴻⵏ ⵍⴻⴱⵀⴰⵢⴻⵎ ⴷ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵖⴰⵔⴻⴽ ⴷⴻⴳ ⵉⵢⵢⴰⵔ ⵖⴰⵔ ⴷⴰⵅⴻⵍ. ⴽⵓⵍ ⴱⵏⴰⴷⴻⵎ ⵏⵉⵖ ⴷ ⵍⵎⴰⵍ ⵏⵏⵉ ⵉ ⵖⴰ ⵉⵜⵜⵡⴰⴼⴻⵏ ⴷⴻⴳ ⵉⵢⵢⴰⵔ, ⵡⴰⵔ ⵜ ⵙⵙⵉⴷⴼⴻⵏ ⵖⴰⵔ ⴷⴰⵅⴻⵍ ⵏ ⵜⴰⴷⴷⴰⵔⵜ, ⴰⴷ ⵅⴰⵙ ⴷⴷ-ⵜⴻⵡⴹⴰ ⵜⴻⴱⵔⵓⵔⵔⵉ ⵓⵛⴰ ⵏⵉⵜⵏⵉ ⴰⴷ ⵎⵎⵜⴻⵏ.’” ");
INSERT INTO rift_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","ⵡⴻⵏⵏⵉ ⵉⴳⴳⵯⴻⴷⴻⵏ ⴰⵡⴰⵍ ⵏ ⵙⵉⴷⵉ ⵣⴻⴳ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏ ⴼⵉⵔⵄⵓⵏ, ⵉⵊⵊⴰ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵙⴻⵏ ⴷ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏⵙⴻⵏ ⴰⵔⴻⵡⵍⴻⵏ ⵖⴰⵔ ⴷⴰⵅⴻⵍ ⴷⵉ ⵜⵓⴷⵔⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","ⵎⴰⵛⴰ ⵡⴻⵏⵏⵉ ⵡⴰⵔ ⵉⵜⵜⵉⵇⵇⴻⵏ ⴰⵡⴰⵍ ⵏ ⵙⵉⴷⵉ ⵙ ⵡⵓⵍ ⵏⵏⴻⵙ, ⴰⵇⴰ ⵉⵊⵊⴰ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵙ ⴷ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏⵏⴻⵙ ⴷⴻⴳ ⵉⵢⵢⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⵙⵡⵉⵥⵥⴻⴹ ⴰⴼⵓⵙ ⵏⵏⴻⵛ ⵖⴰⵔ ⵓⵊⴻⵏⵏⴰ ⵓⵛⴰ ⴰⴷ ⵜⵉⵍⵉ ⵜⴻⴱⵔⵓⵔⵔⵉ ⵅ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ, ⵅ ⵉⵡⴷⴰⵏ, ⵅ ⵍⵎⴰⵍ ⵓ ⵅ ⵎⴰⵔⵔⴰ ⴰⴼⵙⵓ ⴷⴻⴳ ⵉⵢⵢⴰⵔⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ.” ");
INSERT INTO rift_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","ⵅⴻⵏⵏⵉ ⵉⵙⵙⵡⵉⵥⵥⴻⴹ ⵎⵓⵙⴰ ⵜⴰⵖⵖⴰⵔⵛⵜ ⵏⵏⴻⵙ ⵖⴰⵔ ⵓⵊⴻⵏⵏⴰ ⵓⵛⴰ ⵙⵉⴷⵉ ⵉⴳⴳⴰ ⴰⵊⵊⴰⵊ ⴷ ⵜⴻⴱⵔⵓⵔⵔⵉ ⵓⵛⴰ ⵜⴻⵙⵙⵡⵉⵥⵥⴻⴹ ⵜⵎⴻⵙⵙⵉ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ. ⴰⵎⵎⵓ ⵉ ⵉⴳⴳⴰ ⵙⵉⴷⵉ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⴻⵡⵡⴻⵜ ⵜⴻⴱⵔⵓⵔⵔⵉ ⵅ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","ⵜⵓⵖⴰ ⴷⵉⵏ ⵜⴰⴱⵔⵓⵔⵔⵉ ⴷ ⵜⵎⴻⵙⵙⵉ ⵉⵅⴻⴵⴹⴻⵏ ⴰⴽ-ⴷ ⵜⴻⴱⵔⵓⵔⵔⵉ. ⵜⵓⵖⴰ ⵜⴻⵊⵀⴻⴷ ⴰⵟⵟⴰⵙ, ⵡⴰⵔ ⵜⵜ ⵜⵓⵖⵉ ⵄⴻⵎⵎⴰⵔⵚ ⴷⵉ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⵣⴻⴳ ⵡⴰⵎⵉ ⵜⵓⵖⴰ ⵜⴻⴷⵡⴻⵍ ⴷ ⵉⵊⵊ ⵏ ⵍⴳⴻⵏⵙ. ");
INSERT INTO rift_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","ⵓⵛⴰ ⵜⴻⵡⵜⴰ ⵜⴻⴱⵔⵓⵔⵔⵉ ⵅ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ, ⵅ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵜⵓⵖⴰ ⴷⴻⴳ ⵉⵢⵢⴰⵔ, ⵅ ⵉⵡⴷⴰⵏ ⴷ ⵍⵎⴰⵍ. ⵜⴻⵡⵜⴰ ⵜⴻⴱⵔⵓⵔⵔⵉ ⵄⴰⵡⴻⴷ ⵅ ⵎⴰⵔⵔⴰ ⴰⴼⵙⵓ ⴷⴻⴳ ⵉⵢⵢⴰⵔ ⵓⵛⴰ ⵜⵜⵡⴰⵔⵥⴻⵏⵜ ⵎⴰⵔⵔⴰ ⵜⵛⴻⵊⵊⵓⵔⴰ ⵏ ⵍⴻⵅⵍⴰ. ");
INSERT INTO rift_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","ⵎⵖⵉⵔ ⴷⵉ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵊⵓⵛⴰⵏ, ⵎⴰⵏⵉ ⴵⴰⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵡⴰⵔ ⵜⴻⵡⵜⵉ ⵜⴻⴱⵔⵓⵔⵔⵉ. ");
INSERT INTO rift_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⵙⵙⴻⴽⴽ ⴼⵉⵔⵄⵓⵏ ⴰⴷ ⵍⴰⵖⴰⵏ ⵉ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ ⵓⵛⴰ ⵉⵏⵏⴰ ⴰⵙⴻⵏ: “ⵏⴻⵛⵛ ⵅⴹⵉⵖ ⵜⵡⴰⵍⴰ-ⵢⴰ. ⵙⵉⴷⵉ, ⴰⵇⴰ-ⵜ ⴷ ⴰⵎⵙⴻⴳⴳⴻⴷ ⵓⵛⴰ ⵏⴻⵛⵛ ⴷ ⵍⴳⴻⵏⵙ ⵉⵏⵓ ⴷ ⵉⵄⴻⴼⴼⴰⵏⴻⵏ! ");
INSERT INTO rift_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","ⵥⴰⴵⴻⵎ ⵙ ⵍⴰⴵⴰⵖ ⵉ ⵙⵉⴷⵉ, ⵎⵉⵏⵣⵉ ⵛⴼⴰ, ⴰⵇⴰ ⴰⵊⵊⴰⵊⴻⵏ ⵏ ⴰⵔⴻⴱⴱⵉ ⴷ ⴰⵟⵟⴰⵙ ⵓⵍⴰ ⴷ ⵜⴰⴱⵔⵓⵔⵔⵉ. ⵏⴻⵛⵛ ⴰⴷ ⴽⴻⵏⵏⵉⵡ ⵊⵊⴻⵖ ⴰⴷ ⵜⵔⴰⵃⴻⵎ, ⵡⴰⵔ ⴽⴻⵏⵏⵉⵡ ⵜⵜᵉⵟⵟⴼⴻⵖ ⵛⴰ ⵄⴰⴷ ⴷⴰⵏⵉⵜⴰ.” ");
INSERT INTO rift_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⴰⵙ ⵎⵓⵙⴰ: “ⵎⴻⵍⵎⵉ ⵖⴰ ⴼⴼⵖⴻⵖ ⵣⵉ ⵜⴻⵏⴷⵉⵏⵜ ⴰⴷ ⵙⵙⵡⵉⵥⵥⴹⴻⵖ ⵉⴼⴰⵙⵙⴻⵏ ⵉⵏⵓ ⵖⴰⵔ ⵙⵉⴷⵉ ⵓⵛⴰ ⴰⴷ ⴱⴻⴷⴷⴻⵏ ⵡⴰⵊⵊⴰⵊⴻⵏ, ⵡⴰⵔ ⵜᵉⵜⵜⵉⵍⵉ ⵄⴰⴷ ⵜⴻⴱⵔⵓⵔⵔⵉ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⴻⵙⵙⵏⴻⴷ ⴱⴻⵍⵍⵉ ⵜⴰⵎⵎⵓⵔⵜ ⴰⵇⴰ-ⵜⵜ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","ⵎⴰⵛⴰ ⵅⴰⴽ ⴷ ⵅ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵛ, ⴰⵇⴰ ⵙⵙⵏⴻⵖ ⵎⴰⵣⴰⵍ ⵡⴰⵔ ⵜⴻⴳⴳⵯⴻⴷⴻⵎ ⵛⴰ ⵣⵉ ⵙⵉⴷⵉ ⴰⵔⴻⴱⴱⵉ.” ");
INSERT INTO rift_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","ⵜⵉⴼⴼⴻⵙⵜ ⴷ ⵉⵎⴻⵏⴷⵉ ⵜⵓⵖⴰ ⵜⵜⵡⴰⵍⴻⵇⴼⴻⵏ, ⵎⵉⵏⵣⵉ ⵉⵎⴻⵏⴷⵉ ⵜⵓⵖⴰ-ⵜ ⵙ ⵜⵉⴷⵔⵉⵏ ⴷ ⵜⵉⴼⴼⴻⵙⵜ ⵜⵏⴻⵡⵡⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","ⵎⴰⵛⴰ ⵉⵔⴷⴻⵏ ⴷ ⴽⴰⵔⵚⴰⵏⴰ ⵡⴰⵔ ⵜⵜⵡⴰⵍⴻⵇⴼⴻⵏ ⵛⴰ, ⵎⵉⵏⵣⵉ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⵡⴰⵔ ⴷⴷ-ⴼⴼⵉⵖⴻⵏ ⵄⴰⴷ. ");
INSERT INTO rift_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","ⵅⴻⵏⵏⵉ ⵢⵓⵢⵓⵔ ⵎⵓⵙⴰ ⵣⵉ ⴼⵉⵔⵄⵓⵏ, ⵉⴼⴼⴻⵖ ⵣⵉ ⵜⴻⵏⴷⵉⵏⵜ ⵓⵛⴰ ⵉⴽⵙⵉ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵏⴻⵙ ⵖⴰⵔ ⵙⵉⴷⵉ. ⵍⴻⵅⴷⴻⵏⵏⵉ ⴱⴻⴷⴷⴻⵏ ⵡⴰⵊⵊⴰⵊⴻⵏ ⴷ ⵜⴻⴱⵔⵓⵔⵔⵉ ⵓⵍⴰ ⴷ ⵉⴱⵓⴷⴰ ⵏ ⵡⴻⵏⵥⴰⵔ ⵅ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","ⵓⵎⵉ ⵉⵥⵔⴰ ⴼⵉⵔⵄⵓⵏ ⴱⴻⵍⵍⵉ ⴰⵏⵥⴰⵔ ⴷ ⵜⴻⴱⵔⵓⵔⵔⵉ ⴷ ⵡⴰⵊⵊⴰⵊⴻⵏ ⴱⴻⴷⴷⴻⵏ, ⵉⵅⴹⴰ ⵄⴰⴷ ⴽⵜⴰⵔ ⵓⵛⴰ ⵉⵙⵙⴻⵇⵙⴻⵃ ⵓⵍ ⵏⵏⴻⵙ, ⵏⴻⵜⵜⴰ ⴷ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","ⵓⵍ ⵏ ⴼⵉⵔⵄⵓⵏ ⵢⴰⵔⵏⵉ ⴷⵉ ⵍⴻⵇⵙⴰⵃⴻⵜ, ⵡⴰⵔ ⵉⵊⵊⵉ ⴰⴷ ⵉⵔⴰⵃ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⵓⵖⴰ ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵙ ⵜⵙⴻⵅⵅⴰⵔⵜ ⵏ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⴰⴷⴻⴼ ⵖⴰⵔ ⴼⵉⵔⵄⵓⵏ, ⵎⵉⵏⵣⵉ ⵏⴻⵛⵛ ⵙⵙⵇⴻⵙⵃⴻⵖ ⵓⵍ ⵏⵏⴻⵙ ⴷ ⵡⵓⵍ ⵏ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵙ, ⵃⵉⵎⴰ ⴰⴷ ⵙⵙⴻⵛⵏⴻⵖ ⵍⴻⵄⵍⴰⵎⴰⵜ ⵉⵏⵓ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⴻⵙ, ");
INSERT INTO rift_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","ⵓ ⵃⵉⵎⴰ ⴰⴷ ⵜⵄⴰⵡⴷⴻⴷ ⴷⴻⴳ ⵉⵎⴻⵣⵣⵓⵖⴻⵏ ⵏ ⵎⵎⵉⵛ ⴷ ⵎⵎⵉⵙ ⵏ ⵎⵎⵉⵛ ⵎⵉⵏ ⴳⴳⵉⵖ ⴰⴽ-ⴷ ⵎⵉⵚⵔⴰ, ⵓ ⴰⴷ ⵜⵄⴰⵡⴷⴻⴷ ⵅ ⵍⴻⵄⵍⴰⵎⴰⵜ ⵉ ⴳⴳⵉⵖ ⵊⴰⵔ ⴰⵙⴻⵏ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⴻⵙⵙⵏⴻⵎ ⴱⴻⵍⵍⵉ ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ.” ");
INSERT INTO rift_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵢⵓⴷⴻⴼ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ ⵖⴰⵔ ⴼⵉⵔⵄⵓⵏ, ⵏⵏⴰⵏ ⴰⵙ: “ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏ ⵉⵄⵉⴱⵔⴰⵏⵉⵢⵢⴻⵏ ⵉⵏⵏⴰ: ‘ⵎⴻⵛⵃⴰⵍ ⵖⴰ ⵜⴻⴽⴽⴻⴷ ⵜⵓⴳⵉⴷ ⴰⴷ ⵜⴻⵀⵡⵉⴷ ⵖⴰⵔ ⵡⵓⴷⴻⵎ ⵉⵏⵓ? ⴻⵊⵊ ⴰⴷ ⵉⵔⴰⵃ ⵍⴳⴻⵏⵙ ⵉⵏⵓ ⵃⵉⵎⴰ ⴰⴷ ⴰⵢⵉ ⵉⵄⴱⴻⴷ. ");
INSERT INTO rift_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","ⵎⵉⵏⵣⵉ ⵎⴰⵍⴰ ⵜⵓⴳⵉⴷ ⴰⴷ ⵜⴻⵊⵊⴻⴷ ⴰⴷ ⵉⵔⴰⵃ ⵍⴳⴻⵏⵙ ⵉⵏⵓ, ⴰⵇⴰ ⴰⴷ ⵙⵙⵉⵡⴹⴻⵖ ⵜⵉⵡⴻⵛⵛⴰ ⵜⵎⵓⵔⵖⵉ ⵅ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","ⴰⴷ ⴷⵍⴻⵏ ⵓⴷⴻⵎ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⴰⵍ ⵡⴰⵔ ⵉⵣⴻⵎⵎⴰⵔ ⵃⴻⴷ ⴰⴷ ⵉⵜⵡⴰⵍⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵄⴰⴷ ⵓⵛⴰ ⴰⴷ ⵛⵛⴻⵏ ⵎⵉⵏ ⵉⵇⵇⵉⵎⴻⵏ ⵉ ⵉⵜⵜⵡⴰⵏⴻⵊⵎⴻⵏ, ⵎⵉⵏ ⴷ ⴰⵡⴻⵎ ⵉⵇⵇⵉⵎⴻⵏ ⵄⴰⴷ ⴰⵡⴰⵔⵏⵉ ⵉ ⵜⴻⴱⵔⵓⵔⵔⵉ. ⴰⴷ ⵜⴻⵛⵛ ⵜⵎⵓⵖⵔⵉ ⵄⴰⵡⴻⴷ ⵎⴰⵔⵔⴰ ⵜⵉⵛⴻⵊⵊⵓⵔⴰ ⵉ ⴷ ⴰⵡⴻⵎ ⴷⴷ-ⵉⵖⴻⵎⵎⵢⴻⵏ ⴷⴻⴳ ⵉⵢⵢⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","ⵓⵛⴰ ⴰⴷ ⵛⵛⵓⵔⴻⵏⵜ ⵜⵓⴷⵔⵉⵏ ⵏⵏⴻⵛ ⴷ ⵜⵓⴷⵔⵉⵏ ⵏ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵛ ⴷ ⵜⵓⴷⵔⵉⵏ ⵏ ⵎⴰⵔⵔⴰ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ. ⴰⵎⵎⵓ ⵡⴰⵔ ⵜⵜ ⵥⵔⵉⵏ ⵄⴻⵎⵎⴰⵔⵚ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵏⴻⵛ ⴷ ⵍⴻⵊⴷⵓⴷ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵏⴻⵛ ⵣⴻⴳ ⵡⴰⵎⵉ ⵜⴻⵏ ⵜⵓⵖⴰ ⵅ ⵜⴻⵎⵎⵓⵔⵜ ⵖⴰⵔ ⵡⴰⵙⵙ-ⴰ.’” ⵓⵛⴰ ⵉⴷⵡⴻⵍ-ⴷⴷ ⵏⴻⵜⵜⴰ, ⵉⵙⵎⴻⵃ ⴷⵉ ⴼⵉⵔⵄⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","ⵏⵏⴰⵏ ⴰⵙ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏ ⴼⵉⵔⵄⵓⵏ: “ⴰⵍ ⵎⴻⵍⵎⵉ ⵉ ⴷ ⴰⵏⴻⵖ ⵖⴰ ⵢⵉⵍⵉ ⵡⴰⵏⵉⵜⴰ ⴷ ⵍⴼⴻⵅ? ⴻⵊⵊ ⴰⴷ ⵔⴰⵃⴻⵏ ⵉⵔⵢⴰⵣⴻⵏ ⵏⵏⵉ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵄⴻⴱⴷⴻⵏ ⵙⵉⴷⵉ ⴰⵔⴻⴱⴱⵉ ⵏⵙⴻⵏ! ⵎⴰ ⵡⴰⵔ ⵜⴻⵙⵙⵉⵏⴻⴷ ⵄⴰⴷ ⴱⴻⵍⵍⵉ ⵎⵉⵚⵔⴰ ⴰⵇⴰ ⵜᵉⵜⵜⵡⴰⵅⴰⵔⵔⴻⴱ?” ");
INSERT INTO rift_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵙⵙⵉⵡⴹⴻⵏ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏ ⴼⵉⵔⵄⵓⵏ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ ⵄⴰⵡⴻⴷ ⵖⴰⵔ ⴼⵉⵔⵄⵓⵏ. ⵏⴻⵜⵜⴰ ⵉⵏⵏⴰ ⴰⵙⴻⵏ: “ⵔⵓⵃⴻⵎ, ⵄⴻⴱⴷⴻⵎ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ! ⵉⵏⵉ ⴰⵢⵉ, ⵎⵉⵏ ⵄⵏⴰⵏ ⵉⵏⵏⵉ ⵉⵅⵙⴻⵏ ⴰⴷ ⵔⴰⵃⴻⵏ?” ");
INSERT INTO rift_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","ⵉⵏⵏⴰ ⵎⵓⵙⴰ: “ⴰⴷ ⵏⵔⴰⵃ ⴰⴽ-ⴷ ⵉⵃⵔⴰⵎⴻⵏ ⵏⵏⴻⵖ ⴷ ⵉⵡⴻⵙⵙⵓⵔⴰ ⵏⵏⴻⵖ, ⵙ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵖ ⴷ ⵜⵃⴻⵏⵊⵉⵔⵉⵏ ⵏⵏⴻⵖ, ⵙ ⵡⵓⴵⵉ ⵏⵏⴻⵖ ⴷ ⵉⴼⵓⵏⴰⵙⴻⵏ ⴷ ⵜⴼⵓⵏⴰⵙⵉⵏ ⵏⵏⴻⵖ, ⵎⵉⵏⵣⵉ ⵖⴰⵔⵏⴻⵖ ⵉⵊⵊ ⵏ ⵍⵄⵉⴷ ⵉ ⵙⵉⴷⵉ.” ");
INSERT INTO rift_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","ⵅⴻⵏⵏⵉ ⵢⴰⵔⵔⴰ-ⴷⴷ ⵅⴰⵙⴻⵏ: “ⵅⴻⵏⵏⵉ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵢⵉⵍⵉ ⵙⵉⴷⵉ ⴰⵟⵟⴰⵚ ⴰⴽⵉⴷⵡⴻⵎ ⵎⴰⵍⴰ ⴰⴷ ⵊⵊⴻⵖ ⴰⴷ ⵜⵔⴰⵃⴻⵎ ⴽⴻⵏⵏⵉⵡ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⴻⵏ ⵏⵡⴻⵎ. ⵅⵣⴰⵔⴻⵎ, ⴰⵇⴰ ⴽⴻⵏⵏⵉⵡ ⵜⴻⵏⵡⵉⵎ ⵍⵖⴰⵔ! ");
INSERT INTO rift_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","ⵡⴰⵔ ⵉⵜⵜⵉⵍⵉ ⴰⵎⴻⵏⵏⵉ. ⵊⵊⴻⵎ ⴰⴷ ⵄⴻⴱⴷⴻⵏ ⵉⵔⵢⴰⵣⴻⵏ ⵉⵊⴻⵀⴷⴻⵏ ⵉ ⵙⵉⴷⵉ, ⵎⵉⵏⵣⵉ ⴷ ⵎⴰⵏ ⴰⵢⴰ ⵉ ⵜᵉⵜⵜⴻⵅⵙⴻⵎ.” ⵓⵛⴰ ⵓⵥⵥⵍⴻⵏ ⵅⴰⵙⴻⵏ ⵣⵉ ⵇⵉⴱⴰⵍⵜ ⵏ ⵡⵓⴷⴻⵎ ⵏ ⴼⵉⵔⵄⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⵙⵡⵉⵥⵥⴻⴹ ⴰⴼⵓⵙ ⵏⵏⴻⵛ ⵅ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ, ⵃⵉⵎⴰ ⵜⴰⵎⵓⵔⵖⵉ ⴰⴷ ⵜⴳⴻⵄⵄⴻⴷ ⵅ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⴻⵛⵛ ⵎⴰⵔⵔⴰ ⴰⴼⵙⵓ ⴰⵣⵉⵣⴰ ⵏ ⵜⴻⵎⵎⵓⵔⵜ, ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⵛⴻⵟⵟⴻⵏ ⵅ ⵜⴻⴱⵔⵓⵔⵔⵉ.” ");
INSERT INTO rift_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","ⵉⵙⵙⵡⵉⵥⵥⴻⴹ ⵎⵓⵙⴰ ⵖⴰⵔ ⵜⴻⵖⵖⴰⵔⵛⵜ ⵏⵏⴻⵙ ⵅ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⵓⵛⴰ ⵉⴳⴳⴰ ⵙⵉⴷⵉ ⴰⴷ ⴷⴷ-ⵉⵙⵓⴹ ⵉⵊⵊ ⵏ ⵓⵙⴻⵎⵎⵉⴹ ⵉ ⴷⴷ-ⵢⵓⵙⵉⵏ ⵣⵉ ⵛⵛⴰⵔⵇ ⵅ ⵜⴻⵎⵎⵓⵔⵜ ⵡⴰⵔ ⵉⵇⴻⵟⵟⵉⵏ ⵎⴰⵔⵔⴰ ⴰⵙⵙ ⵏⵏⵉ ⴷ ⵎⴰⵔⵔⴰ ⴵⵉⵍⴻⵜ ⵏⵏⵉ. ⵖⴰⵔ ⵚⵚⴱⴻⵃ ⵢⵉⵡⵉ-ⴷⴷ ⵓⵙⴻⵎⵎⵉⴹ ⵜⴰⵎⵓⵔⵖⵉ. ");
INSERT INTO rift_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","ⵜⴳⴻⵄⵄⴻⴷ-ⴷⴷ ⵜⵎⵓⵔⵖⵉ ⵅ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ, ⵜⵚⴻⵢⵢⴻⵃ ⵅ ⵎⴰⵔⵔⴰ ⵊⵊⵡⴰⵢⴻⵀ ⵏ ⵎⵉⵚⵔⴰ. ⴰⵇⴰ ⵜⵓⵖⴰ ⵍⵃⴰⵍ ⵢⴻⵡⵄⴰⵔ ⴰⵟⵟⴰⵙ. ⵜⴰⵎⵓⵔⵖⵉ ⴰⵎ ⵜⴰⵏⵉⵜⴰ ⵡⴰⵔ ⵜⵜ ⵜⵓⵖⵉ ⵇⴱⴻⵍ ⵓⵛⴰ ⵡⴰⵔ ⵜᵉⵜⵜⵉⵍⵉ ⵄⴻⵎⵎⴰⵔⵚ ⵣⵉ ⵙⵙⴰ ⵖⴰⵔ ⵣⵣⴰⵜ. ");
INSERT INTO rift_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","ⴰⵇⴰ ⴷⵍⵉⵏⵜ ⵓⴷⴻⵎ ⵏ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⴰⵍⴰⵎⵉ ⵜⴻⵙⵙⵓⵜⴻⵎ ⵜⴻⵎⵎⵓⵔⵜ. ⵏⵉⵜⴻⵏⵜⵉ ⵛⵛⵉⵏⵜ ⵎⴰⵔⵔⴰ ⴰⴼⵙⵓ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⴷ ⵎⴰⵔⵔⴰ ⵍⵖⵉⴵⴻⵜ ⵏ ⵜⵛⴻⵊⵊⵓⵔⴰ ⵉ ⵜⵓⵖⴰ ⵉⵇⵇⵉⵎⴻⵏ ⵣⵉ ⵜⴻⴱⵔⵓⵔⵔⵉ. ⴷⵉ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⵡⴰⵔ ⵉⵇⵇⵉⵎ ⵡⴰⵍⵓ ⵣⵉ ⵎⴰⵔⵔⴰ ⵜⵓⵣⵣⵉⵣⴻⵡⵜ ⴷⵉ ⵜⵛⴻⵊⵊⵓⵔⴰ ⵏⵉⵖ ⴷⴻⴳ ⵡⴻⴼⵙⵓ ⵏ ⵉⵢⵢⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⵍⴰⵖⴰ ⴼⵉⵔⵄⵓⵏ ⴷⴻⵖⵢⴰ ⵉ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ, ⵉⵏⵏⴰ: “ⴰⵇⴰ ⵅⴹⵉⵖ ⴰⴽ-ⴷ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ, ⵓⵍⴰ ⴰⴽⵉⴷⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","ⵜⵜⵣⴰⵡⴳⴻⵖ ⵍⴻⵅⵅⵓ ⴰⴷ ⴰⵢⵉ ⵜⵙⴰⵎⵃⴻⵎ ⵅ ⵓⵅⴻⵟⵟⵓ ⵉⵏⵓ ⵜⵡⴰⵍⴰ-ⵢⴰ. ⵥⴰⴵⴻⵎ ⵙ ⵍⴰⴵⴰⵖ ⵉ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ, ⵃⵉⵎⴰ ⴰⴷ ⵅⴰⴼⵉ ⵉⴽⴽⴻⵙ ⵍⵎⴻⵡⵜ-ⴰ ⵡⴰⵀⴰ.” ");
INSERT INTO rift_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","ⵓⵛⴰ ⵉⴼⴼⴻⵖ ⵅ ⴼⵉⵔⵄⵓⵏ ⵓⵛⴰ ⵉⵥⵥⵓⴵ ⵙ ⵍⴰⴵⴰⵖ ⵖⴰⵔ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","ⵅⴻⵏⵏⵉ ⵉⵊⵊⴰ ⵙⵉⴷⵉ ⴰⴷ ⴷⴷ-ⵉⵄⵇⴻⴱ ⵓⵙⴻⵎⵎⵉⴹ ⵉ ⴷⴷ-ⵢⵓⵙⵉⵏ ⵣⵉ ⵛⵛⴰⵔⵇ ⵖⴰⵔ ⵍⵖⴰⵔⴱ, ⵉⵙⵙⵊⴻⵀⴷ ⵉ-ⵜ ⴰⵟⵟⴰⵙ, ⵓⵛⴰ ⵉⴽⴽⴻⵙ ⵓⵙⴻⵎⵎⵉⴹ ⵜⴰⵎⵓⵔⵖⵉ, ⵉⵏⴹⴰⵔ ⵉ-ⵜⵜ ⴷⵉ ⵍⴻⴱⵃⴰⵔ ⵏ ⵜⴻⵍⴳⴰ. ⵡⴰⵔ ⵜⴻⵇⵇⵉⵎ ⵓⵍⴰ ⴷ ⵉⵛⵜ ⵏ ⵜⵎⵓⵔⵖⵉ ⴷⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵡⴰⵢⴻⵀ ⵏ ⵎⵉⵚⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","ⵎⴰⵛⴰ ⵉⵙⵙⴻⵇⵙⴻⵃ ⵙⵉⴷⵉ ⵓⵍ ⵏ ⴼⵉⵔⵄⵓⵏ ⵓⵎⵉ ⵡⴰⵔ ⵉⵊⵊⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴰⴷ ⵔⴰⵃⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⵙⵡⵉⵥⵥⴻⴹ ⴰⴼⵓⵙ ⵏⵏⴻⵛ ⵖⴰⵔ ⵓⵊⴻⵏⵏⴰ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⵉⵍⵉ ⵜⴰⴵⴻⵙⵜ ⵅ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⴰⵍ ⵖⴰ ⵜⴰⴼⴻⴷ ⵜⵣⴻⵎⵎⴰⵔⴻⴷ ⴰⴷ ⵜⵃⴰⴷⵉⴷ ⵜⴰⴵⴻⵙⵜ.” ");
INSERT INTO rift_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","ⵉⵙⵙⵡⵉⵥⵥⴻⴹ ⵎⵓⵙⴰ ⴰⴼⵓⵙ ⵏⵏⴻⵙ ⵖⴰⵔ ⵓⵊⴻⵏⵏⴰ ⵓⵛⴰ ⵜⴻⵀⵡⴰ-ⴷⴷ ⵜⴰⴵⴻⵙⵜ ⵜⴻⵊⵀⴻⴷ ⵅ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ, ⵜⵍⴰⵜⴰ ⵏ ⵡⵓⵙⵙⴰⵏ.    ");
INSERT INTO rift_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","ⵓⵍⴰ ⴷ ⵉⵊⵊ ⵡⴰⵔ ⵉⵜⵡⵉⵍⵉ ⵡⴻⵏⵏⴻⵖⵏⵉ. ⵓⵍⴰ ⴷ ⵉⵊⵊ ⵡⴰⵔ ⵉⴽⴽⴰⵔ ⵣⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏⵏⴻⵙ ⵜⵍⴰⵜⴰ ⵏ ⵡⵓⵙⵙⴰⵏ. ⵎⴰⵛⴰ ⵎⴰⵔⵔⴰ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵜⵓⵖⴰ ⵖⴰⵔⵙⴻⵏ ⵜⴰⴼⴰⵡⵜ ⴷⴻⴳ ⵉⵎⵓⵛⴰⵏ ⵎⴰⵏⵉ ⵜⵓⵖⴰ ⵣⴻⴷⴷⵖⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⵍⴰⵖⴰ ⴼⵉⵔⵄⵓⵏ ⵉ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: “ⵔⵓⵃⴻⵎ, ⵜⵄⴻⴱⴷⴻⵎ ⵙⵉⴷⵉ! ⵊⵊⴻⵎ ⵡⴰⵀⴰ ⴰⴷ ⵉⵇⵇⵉⵎ ⵡⵓⴵⵉ ⵏⵡⴻⵎ ⴷ ⵉⴼⵓⵏⴰⵙⴻⵏ ⴷ ⵜⴼⵓⵏⴰⵙⵉⵏ ⵏⵡⴻⵎ. ⵎⴰⵛⴰ ⵜⵣⴻⵎⵎⴰⵔⴻⵎ ⴰⴷ ⴷⴷ-ⵜⴰⵡⵢⴻⵎ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⴻⵏ ⴰⴽⵉⴷⵡⴻⵎ.” ");
INSERT INTO rift_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","ⵢⴰⵔⵔⴰ-ⴷⴷ ⵅⴰⵙ ⵎⵓⵙⴰ: “ⵉⵜⵜⵅⴻⵚⵚⴰ ⵛⴻⴽ ⵄⴰⵡⴻⴷ ⴰⴷ ⴰⵏⴻⵖ ⵜⴻⵡⵛⴻⴷ ⴷⴻⴳ ⵓⴼⵓⵙ ⵜⵉⵖⴰⵔⵚⴰ ⵓⵍⴰ ⴷ ⵜⵉⵖⴰⵔⵚⴰ ⵏ ⵡⴻⵛⵎⴰⴹ. ⴰⴷ ⵜⴻⵏⵜ ⵏⴻⵙⵙⴻⵡⵊⴻⴷ ⴷ ⵜⵖⴰⵔⵚⵟ ⵉ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","ⵓⵍⴰ ⴷ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏⵏⴻⵖ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⴽⵉⴷⵏⴻⵖ ⵔⴰⵃⴻⵏⵜ, ⵡⴰⵔ ⵉⵜⵜⵖⵉⵎⵉ ⵓⵍⴰ ⴷ ⵉⵊⵊ ⵏ ⵓⵛⴻⴽⵔⵓⴷ, ⵎⵉⵏⵣⵉ ⵣⵣⴰⵢⵙⴻⵏⵜ ⵉ ⵖⴰ ⵏⴻⴽⵙⵉ, ⵃⵉⵎⴰ ⴰⴷ ⵏⴻⵄⴱⴻⴷ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵖ, ⵎⵉⵏⵣⵉ ⵡⴰⵔ ⵏⴻⵙⵙⵉⵏ ⵙ ⵎⵉⵏⵣⵉ ⵖⴰ ⵏⴻⵄⴱⴻⴷ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵖ, ⴰⵍ ⴷⵉⵏ ⵖⴰ ⵏⴰⵡⴻⴹ.” ");
INSERT INTO rift_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","ⵎⴰⵛⴰ ⵙⵉⴷⵉ ⵉⵙⵙⴻⵇⵙⴻⵃ ⵓⵍ ⵏ ⴼⵉⵔⵄⵓⵏ ⵓⵛⴰ ⵢⵓⴳⵉ ⴰⴷ ⵜⴻⵏ ⵢⴻⵊⵊ ⴰⴷ ⵔⴰⵃⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","ⵉⵏⵏⴰ ⴰⵙ ⴼⵉⵔⵄⵓⵏ: “ⴰⴳⴳⵯⴻⵊ ⵅⴰⴼⵉ! ⵃⴹⴰ, ⵃⵉⵎⴰ ⵡⴰⵔ ⵜⵥⴰⵔⵔⴻⴷ ⵄⴰⴷ ⵓⴷⴻⵎ ⵉⵏⵓ, ⵎⵉⵏⵣⵉ ⴰⵙⵙ ⵉ ⴷⵉ ⵖⴰ ⵜⵥⴰⵔⴻⴷ ⵓⴷⴻⵎ ⵉⵏⵓ, ⴰⴷ ⵜⴻⵎⵎⵜⴻⴷ!” ");
INSERT INTO rift_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","ⵉⵏⵏⴰ ⵎⵓⵙⴰ: “ⴰⴷ ⵢⵉⵍⵉ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵉ ⵜⴻⵏⵏⵉⴷ: ⵡⴰⵔ ⵥⴰⵔⵔⴻⵖ ⵄⴰⴷ ⵓⴷⴻⵎ ⵏⵏⴻⵛ!” ");
INSERT INTO rift_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⴰⴷ ⵍⴻⵇⴼⴻⵖ ⵄⴰⴷ ⵎⵖⵉⵔ ⵙ ⵢⵉⵛⵜⴻⵏ ⵊⵊⵔⵉⵃⴻⵛⵜ ⵅ ⴼⵉⵔⵄⵓⵏ ⴷ ⵎⵉⵚⵔⴰ. ⴰⵡⴰⵔⵏⵉ ⵜⴰ ⴰⴷ ⴽⴻⵏⵏⵉⵡ ⵉⵙⵙⴻⴽⴽ ⵙⵙⴰ. ⵖⴰⵔ ⵓⵏⴻⴳⴳⴰⵔ ⵅⵎⵉ ⴽⴻⵏⵏⵉⵡ ⵖⴰ ⵢⴻⵊⵊ ⴰⴷ ⵜⵔⵓⵃⴻⵎ ⵎⴰⵔⵔⴰ, ⴰⴷ ⵅⴰⵡⴻⵎ ⵢⴰⵥⵥⴻⵍ ⵙⵙⴰ ⵙ ⵜⵉⴷⴻⵜⵜ. ");
INSERT INTO rift_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","ⵙⵉⵡⴻⵍ ⵅⴻⵏⵏⵉ ⴷⴻⴳ ⵉⵎⴻⵣⵣⵓⵖⴻⵏ ⵏ ⵍⴳⴻⵏⵙ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⵜⵜⴰⵔ ⴽⵓⵍ ⴰⵔⵢⴰⵣ ⵣⴻⴳ ⵡⴰⵊⵊⴰⵔ ⵏⵏⴻⵙ ⵓ ⴽⵓⵍ ⵜⴰⵎⵖⴰⵔⵜ ⵣⵉ ⵜⴰⵊⵊⴰⵔⵜ ⵏⵏⴻⵙ ⵍⴻⵇⵛⵓⵄ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⴷ ⵡⵓⵔⴻⵖ.” ");
INSERT INTO rift_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","ⵙⵉⴷⵉ ⵉⵡⵛⴰ ⴰⵙ ⵉ ⵍⴳⴻⵏⵙ ⴰⵔⴹⴰ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ. ⵄⴰⵡⴻⴷ ⵜⵓⵖⴰ ⵎⵓⵙⴰ ⴷ ⵉⵊⵊ ⵡⴻⵔⵢⴰⵣ ⵙ ⵛⵛⴰⵏ ⴰⵎⴻⵇⵇⵔⴰⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵍⴳⴻⵏⵙ ⵓ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏ ⴼⵉⵔⵄⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","ⵉⵏⵏⴰ ⵎⵓⵙⴰ: “ⴰⵎⵎⵓ ⵉ ⵉⵏⵏⴰ ⵙⵉⴷⵉ: ‘ⵖⴰⵔ ⵡⴻⵣⵢⴻⵏ ⵏ ⴵⵉⵍⴻⵜ ⵏⴻⵛⵛ ⴰⴷ ⵄⴷⵓⵖ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏ ⵎⵉⵚⵔⴰ ");
INSERT INTO rift_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","ⵓⵛⴰ ⴰⴷ ⵉⵎⵎⴻⵜ ⴽⵓⵍ ⴰⵎⴻⵏⵣⵓ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ, ⵣⴻⴳ ⵓⵎⴻⵏⵣⵓ ⵏ ⴼⵉⵔⵄⵓⵏ, ⵡⴻⵏⵏⵉ ⵉⵇⵇⵉⵎⴻⵏ ⵅ ⵍⵄⴰⵔⵛ ⵏ ⵜⴳⴻⵍⴷⵉⵜ, ⴰⵍ ⴰⵎⴻⵏⵣⵓ ⵏ ⵜⴰⵢⵢⴰ, ⵜⴻⵏⵏⵉ ⵉⵇⵇⵉⵎⴻⵏ ⴰⵡⴰⵔⵏⵉ ⵉ ⵜⵙⵉⵔⵜ ⵜⵃⴰⵔⵔⵉ ⵉⵎⴻⵏⴷⵉ, ⵓⵍⴰ ⴷ ⴽⵓⵍ ⴰⵎⴻⵏⵣⵓ ⵣⵉ ⵍⴻⴱⵀⴰⵢⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","ⴰⴷ ⴷⵉⵏ ⵜⵉⵍⵉ ⵉⵛⵜ ⵏ ⵜⵖⵓⵢⵢⵉⵜ ⴷ ⵜⴰⵎⴻⵇⵇⵔⴰⵏⵜ ⵅ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⵉ ⵡⴰⵔ ⵜⵓⵖⵉ ⵄⴻⵎⵎⴰⵔⵚ ⵏⵉⵖ ⵄⴻⵎⵎⴰⵔⵚ ⵄⴰⴷ ⴰⴷ ⵜⵉⵍⵉ. ");
INSERT INTO rift_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","ⵎⴰⵛⴰ ⵖⴰⵔ ⵎⴰⵔⵔⴰ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵡⴰⵔ ⵉⵜⵜⵥⵓ ⵓⵍⴰ ⴷ ⵉⵊⵊ ⵏ ⵡⴻⵇⵣⵉⵏ ⵅ ⵉⵡⴷⴰⵏ ⵓⵍⴰ ⵅ ⵍⵎⴰⵍ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⴻⵙⵙⵏⴻⵎ, ⴱⴻⵍⵍⵉ ⵙⵉⴷⵉ ⵉⵜⵜⴻⴳⴳ ⵍⴼⴰⵔⵣ ⵊⴰⵔ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ ⴷ ⵉⵙⵔⴰⵉⵍ.’ ");
INSERT INTO rift_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","ⵅⴻⵏⵏⵉ ⴰⴷ ⵖⴰⵔⵉ ⴷⴷ-ⵀⵡⴰⵏ ⵎⴰⵔⵔⴰ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵛ, ⴰⴷ ⴰⵢⵉ ⴱⴻⵏⴷⵇⴻⵏ, ⴰⴷ ⵉⵏⵉⵏ: ‘ⴼⴼⴻⵖ ⵛⴻⴽ ⴷ ⵎⴰⵔⵔⴰ ⵍⴳⴻⵏⵙ ⵉ ⵛⴻⴽ ⵉⴹⴻⴼⴼⴰⵔⴻⵏ ⴷⴻⴳ ⵉⵚⵓⵔⴰⴼ ⵏⵏⴻⵛ!’ ⴰⵡⴰⵔⵏⵉ ⵎⴰⵏ ⴰⵢⴰ ⵏⴻⵛⵛ ⴰⴷ ⴼⴼⵖⴻⵖ.’” ⵓⵛⴰ ⵉⴼⴼⴻⵖ ⵅ ⴼⵉⵔⵄⵓⵏ, ⵜⴻⴽⴽⴰⵔ ⴷⴰⵢⴻⵙ ⵜⵎⴻⵙⵙⵉ ⵙ ⵓⵅⴻⵢⵢⴻⵇ. ");
INSERT INTO rift_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","ⴰⵇⴰ ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⴼⵉⵔⵄⵓⵏ ⵡⴰⵔ ⴷ ⴰⵡⴻⵎ ⵉⵜⵜⴻⵙⵍⵉ ⵛⴰ, ⵃⵉⵎⴰ ⴰⴷ ⵎⵖⴰⵔⴻⵏⵜ ⵍⴻⵄⵍⴰⵎⴰⵜ ⵉⵏⵓ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ.” ");
INSERT INTO rift_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","ⴰⵇⴰ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ ⴳⴳⵉⵏ ⵎⴰⵔⵔⴰ ⵍⴻⵄⵍⴰⵎⴰⵜ-ⴰ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⴼⵉⵔⵄⵓⵏ, ⵎⴰⵛⴰ ⵙⵉⴷⵉ ⵜⵓⵖⴰ ⵉⵙⵙⴻⵇⵙⴻⵃ ⵓⵍ ⵏ ⴼⵉⵔⵄⵓⵏ ⴰⵍⴰⵎⵉ ⵡⴰⵔ ⵉⵊⵊⵉ ⴰⴷ ⴼⴼⵖⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“ⴰⵢⵓⵔ-ⴰ ⴰⴷ ⴰⵡⴻⵎ ⵢⵉⵍⵉ ⴷ ⴰⵣⴻⴵⵉⴼ ⵏ ⵉⵢⵓⵔⴻⵏ. ⴰⴷ ⴰⵡⴻⵎ ⵢⵉⵍⵉ ⵡⴰ ⵉ ⴽⴻⵏⵏⵉⵡ ⴷ ⴰⵎⴻⵣⵡⴰⵔⵓ ⵏ ⵉⵢⵓⵔⴻⵏ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","ⵙⵉⵡⴻⵍ ⵖⴰⵔ ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵉⵏⵉ: ‘ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵄⴻⵛⵔⴰ ⴰⴷ ⵉⴽⵙⵉ ⴽⵓⵍ ⵉⵊⵊ ⵉ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵉⵊⵊ ⵏ ⵢⴻⵣⵎⴰⵔ ⵅ ⵎⴰⵔⵔⴰ ⵍⴰⴵ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵉ ⴷⴷ-ⵉⵇⵇⴰⵔⵚⴻⵏ ⵣⴻⴳ ⵉⴱⴰⴱⴰⵜⴻⵏ, ⵉⵊⵊ ⵏ ⵢⴻⵣⵎⴰⵔ ⵅ ⵉⵛⵜ ⵏ ⵜⴰⴷⴷⴰⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⵔⴰⴵ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵜⵓⵖⴰ ⵉⵎⵥⵉ ⵉ ⵢⴻⵣⵎⴰⵔ, ⵅⴻⵏⵏⵉ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵉⴽⵙⵉ ⴰⴽ-ⴷ ⵡⴰⵊⵊⴰⵔ ⵏⵏⴻⵙ ⵢⵓⴷⵙⴻⵏ ⵖⴰⵔ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⴻⵙ ⵄⵍⴰⵃⵙⴰⴱ ⵍⵇⴻⴷⴷ ⵏ ⵉⵡⴷⴰⵏ. ⵣⵉ ⵊⵊⵉⵀⴻⵜ ⵏ ⵢⴻⵣⵎⴰⵔ ⴰⴷ ⵜⴻⵡⵜⴻⵎ ⵍⴻⵃⵙⴰⴱ ⵉ ⵎⵉⵏ ⵖⴰ ⵢⴻⵛⵛ ⴽⵓⵍ ⵉⵊⵊⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵉⵣⵎⴰⵔ ⵉⵛⵏⴰⵏ ⵇⴰⵄ, ⴰⵡⵜⴻⵎ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ. ⴰⴷ ⵜ ⵜⴻⴽⵙⵉⵎ ⵣⴻⴳ ⵉⵃⵓⵍⵉⵢⵢⴻⵏ ⵏⵉⵖ ⵣⴻⴳ ⵉⵖⴰⵢⴹⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","ⴰⴷ ⵜ ⵜⵅⴻⵎⵎⵍⴻⵎ ⴰⵍ ⴰⵙⵙ ⴰⵔⴱⴻⵄⵟⴰⵛ ⵣⴻⴳ ⵓⵢⵓⵔ-ⴰ ⵓⵛⴰ ⴰⴷ ⴰⵙ ⵉⵖⴰⵔⵚ ⵎⴰⵔⵔⴰ ⴰⴳⵔⴰⵡ ⵏ ⵜⵎⴻⵙⵎⵓⵏⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵊⴰⵔ ⴱⴻⴷⴷⵓ ⵏ ⵡⴻⵣⵢⴻⵏ ⵏ ⵡⴰⵙⵙ ⴰⵍ ⴷⴷ-ⵜⴻⵡⴹⴰ ⵜⵎⴻⴷⴷⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","ⴰⴷ ⴽⵙⵉⵏ ⵛⴰ ⵣⴻⴳ ⵉⴷⴰⵎⵎⴻⵏ ⵓⵛⴰ ⴰⴷ ⵜ ⴳⴳⴻⵏ ⵅ ⵜⵏⴰⵢⴻⵏ ⵏ ⵍⴻⴹⵔⵓⴼ ⵉ ⵉⴵⴰⵏ ⵖⴰⵔ ⵓⵖⴻⵣⴷⵉⵙ ⵏ ⵜⴻⵡⵡⴰⵔⵜ ⵓ ⵅ ⵜⵏⴻⴱⴷⴰⵜ ⵙⴻⵏⵏⴻⵊ ⵉ ⵜⴻⵡⵡⴰⵔⵜ ⵏ ⵜⵓⴷⵔⵉⵏ ⵎⴰⵏⵉ ⵜ ⵖⴰ ⵛⵛⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","ⴰⴷ ⵛⵛⴻⵏ ⴰⵢⵙⵓⵎ ⴷⵉ ⴵⵉⵍⴻⵜ ⵏⵏⵉ, ⴰⵢⵙⵓⵎ ⵉⵛⴻⵏⵏⴼⴻⵏ ⵖⴰⵔ ⵜⵎⴻⵙⵙⵉ ⴰⴽ-ⴷ ⵡⴻⵖⵔⵓⵎ ⴱⵍⴰ ⴰⵏⵜⵓⵏ. ⴰⴷ ⵜ ⵛⵛⴻⵏ ⵙ ⵍⴻⴱⵣⴰⵔ ⵢⴰⵔⵣⴻⴳ. ");
INSERT INTO rift_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","ⵡⴰⵔ ⵜ ⵜⵜᵉⵜⵜⴻⵎ ⵛⴰ ⴷ ⴰⵣⵉⵣⴰ ⵏⵉⵖ ⵢⴻⵏⵡⴰⵏ ⴷⴻⴳ ⵡⴰⵎⴰⵏ, ⵎⴰⵛⴰ ⵎⵖⵉⵔ ⵎⴰⵍⴰ ⵉⵜⵜⵡⴰⵛⴻⵏⵏⴻⴼ ⴷⵉ ⵜⵎⴻⵙⵙⵉ, ⴰⴽ-ⴷ ⵓⵣⴻⴵⵉⴼ ⵏⵏⴻⵙ ⴷ ⵉⴹⴰⵔⴻⵏ ⵏⵏⴻⵙ ⴷ ⵡⴰⴷⴰⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","ⵡⴰⵔ ⵣⵣⴰⵢⴻⵙ ⵜⵜⴻⵊⵊⵉⵎ ⵡⴰⵍⵓ ⵖⴰⵔ ⵚⵚⴱⴻⵃ, ⵎⴰⵛⴰ ⵎⵉⵏ ⵣⵣⴰⵢⴻⵙ ⵖⴰ ⵉⵇⵇⵉⵎⴻⵏ ⵖⴰⵔ ⵚⵚⴱⴻⵃ, ⵉⵜⵜⵅⴻⵚⵚⴰ ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⵜ ⵜⵛⴻⵎⴹⴻⵎ ⴷⵉ ⵜⵎⴻⵙⵙⵉ. ");
INSERT INTO rift_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","ⴰⵎⵎⵓ ⵉ ⴷ ⴰⵡⴻⵎ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜ ⵜⴻⵛⵛⴻⵎ: ⵜⴰⵊⵄⵉⵏⵏⴰ ⵏⵡⴻⵎ ⴰⴷ ⵜⵉⵍⵉ ⵜⴻⴱⵢⴻⵙ, ⵙⴰⵏⴷⴰⵍⵉⵢⴰⵜ ⵏⵡⴻⵎ ⴷⴻⴳ ⵉⴹⴰⵔⴻⵏ ⵏⵡⴻⵎ ⵓ ⵜⴰⵖⵖⴰⵔⵛⵜ ⵏⵡⴻⵎ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏⵡⴻⵎ ⵓⵛⴰ ⴰⴷ ⵜ ⵜⴻⵛⵛⴻⵎ ⴷⴻⵖⵢⴰ. ⴰⵇⴰ-ⵜ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵓⵙⴻⵄⴷⵓ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","ⵎⵉⵏⵣⵉ ⴷⵉ ⴵⵉⵍⴻⵜ-ⴰ, ⵏⴻⵛⵛ ⴰⴷ ⵄⴷⵓⵖ ⵅ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⵓⵛⴰ ⴰⴷ ⵡⵜⴻⵖ ⴽⵓⵍ ⴰⵎⴻⵏⵣⵓ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ, ⴰⵎⵎⵓ ⴷⴻⴳ ⵉⵡⴷⴰⵏ ⵓⵍⴰ ⴷⵉ ⵍⵎⴰⵍ, ⵓⵛⴰ ⴰⴷ ⵙⵙⵉⵡⴹⴻⵖ ⵍⴻⵃⴽⴰⵎⴰⵜ ⵉⵏⵓ ⵅ ⵎⴰⵔⵔⴰ ⵉⵔⴻⴱⴱⵉⵜⴻⵏ ⵏ ⵎⵉⵚⵔⴰ, ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ! ");
INSERT INTO rift_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","ⵓⵛⴰ ⵉⴷⴰⵎⵎⴻⵏ ⴰⴷ ⴰⵡⴻⵎ ⵉⵍⵉⵏ ⴷ ⵉⵛⵜ ⵏ ⵍⴻⵄⵍⴰⵎⴻⵜ ⵅ ⵜⵓⴷⵔⵉⵏ ⵎⴰⵏⵉ ⵜⵣⴻⴷⴷⵖⴻⵎ ⴽⴻⵏⵏⵉⵡ. ⵎⴰⵍⴰ ⵥⵔⵉⵖ ⵉⴷⴰⵎⵎⴻⵏ, ⴰⴷ ⵅⴰⵡⴻⵎ ⵄⴷⵓⵖ. ⵡⴰⵔ ⵜᵉⵜⵜⵉⵍⵉ ⵊⵊⵔⵉⵃⴻⵛⵜ ⵉⵏⴻⵇⵇⴻⵏ ⵊⴰⵔ ⴰⵡⴻⵎ, ⵅⵎⵉ ⵖⴰ ⵡⵜⴻⵖ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","ⴰⵙⵙ-ⴰ ⴰⴷ ⴰⵡⴻⵎ ⵢⵉⵍⵉ ⴷ ⵉⵊⵊ ⵏ ⵡⴰⵙⵙ ⵉ ⵍⵉⴷⴰⵔⴻⵜ ⵓⵛⴰ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵜⵄⴻⵢⵢⴷⴻⵎ ⵉ ⵙⵉⴷⵉ. ⴰⵇⴰ-ⵜⵜ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵚⴻⵢⵢⴻⵜ ⵉ ⵍⴻⴱⴷⴰ ⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵏⵡⴻⵎ, ⵃⵉⵎⴰ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵜⵄⴻⵢⵢⴷⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⴰⴷ ⵜⴻⵛⵛⴻⵎ ⴰⵖⵔⵓⵎ ⴱⵍⴰ ⴰⵏⵜⵓⵏ. ⵏⵉⵛⴰⵏ ⴷⴻⴳ ⵡⴰⵙⵙ ⴰⵎⴻⵣⵡⴰⵔⵓ ⴰⴷ ⵜⴻⵙⵙⵓⴼⴼⵖⴻⵎ ⴰⵏⵜⵓⵏ ⵣⵉ ⵜⵓⴷⵔⵉⵏ ⵏⵡⴻⵎ, ⵎⵉⵏⵣⵉ ⵎⴰⵏ ⵡⴻⵏ ⵉ ⵖⴰ ⵉⵛⵛⴻⵏ ⵛⴰ ⵙ ⵡⴻⵏⵜⵓⵏ, ⵣⴻⴳ ⵡⴰⵙⵙ ⴰⵎⴻⵣⵡⴰⵔⵓ ⴰⵍ ⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ, ⴱⵏⴰⴷⴻⵎ ⵏⵏⵉ ⴰⴷ ⵉⵜⵜⵡⴰⵇⴻⵙⵙ ⵣⵉ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","ⴷⴻⴳ ⵡⴰⵙⵙ ⴰⵎⴻⵣⵡⴰⵔⵓ ⴰⴷ ⵢⵉⵍⵉ ⵉⵊⵊ ⵏ ⵓⵎⵓⵏⵉ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵓⵛⴰ ⵄⴰⵡⴻⴷ ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ ⴰⴷ ⴷⵉⵏ ⵢⵉⵍⵉ ⵉⵊⵊ ⵏ ⵓⵎⵓⵏⵉ ⵉⵇⴻⴷⴷⵙⴻⵏ. ⵓⵍⴰ ⴷ ⵉⵛⵜ ⵏ ⵍⵅⴻⴷⵎⴻⵜ ⵡⴰⵔ ⵜᵉⵜⵜⵡⴰⴳⴳ ⵛⴰ ⴷⴻⴳ ⵡⵓⵙⵙⴰⵏ ⵏⵏⵉ. ⵎⵖⵉⵔ ⵎⵉⵏ ⵖⴰ ⵢⴻⵛⵛ ⴽⵓⵍ ⵉⵊⵊ, ⴷ ⵎⴰⵏ ⴰⵢⴰ ⵡⴰⵀⴰ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⵣⵣⴰⵢⵡⴻⵎ ⵉⵜⵜⵡⴰⵙⵙⴻⵡⵊⴻⴷ. ");
INSERT INTO rift_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","ⴰⴷ ⵜⴻⵃⴹⴰⵎ ⵍⵄⵉⴷ ⵏ ⵡⴻⵖⵔⵓⵎ ⴱⵍⴰ ⴰⵏⵜⵓⵏ, ⵎⵉⵏⵣⵉ ⴷⴻⴳ ⵡⴰⵙⵙ ⵏⵏⵉ ⴰⵇⴰ ⵙⵙⵓⴼⴼⵖⴻⵖ-ⴷⴷ ⴽⴻⵏⵏⵉⵡ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ. ⴰⴷ ⵜⴻⵃⴹⴰⵎ ⴰⵙⵙ-ⴰ ⴷⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵏⵡⴻⵎ, ⴰⵇⴰ-ⵜⵜ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵚⴻⵢⵢⴻⵜ ⵉ ⵍⴻⴱⴷⴰ. ");
INSERT INTO rift_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","ⴷⴻⴳ ⵓⵢⵓⵔ ⴰⵎⴻⵣⵡⴰⵔⵓ, ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⴰⵔⴱⴻⵄⵟⴰⵛ ⵏ ⵓⵢⵓⵔ, ⴷⵉ ⴵⵉⵍⴻⵜ, ⴰⴷ ⵜⴻⵛⵛⴻⵎ ⴰⵖⵔⵓⵎ ⴱⵍⴰ ⴰⵏⵜⵓⵏ ⴰⵍ ⴵⵉⵍⴻⵜ ⵏ ⵡⴰⵙⵙ ⵡⴰⵃⵉⵜ ⵓ-ⵄⵉⵛⵔⵉⵏ ⵣⴻⴳ ⵓⵢⵓⵔ. ");
INSERT INTO rift_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⵡⴰⵔ ⵉⵜⵜⵡⵉⴼⴼⵉ ⵡⴻⵏⵜⵓⵏ ⴷⵉ ⵜⵓⴷⵔⵉⵏ ⵏⵡⴻⵎ, ⵎⵉⵏⵣⵉ ⵎⴰⵏ ⵡⴻⵏ ⵉ ⵖⴰ ⵉⵛⵛⴻⵏ ⵣⵉ ⵎⵉⵏ ⵉⴵⴰⵏ ⵙ ⵡⴻⵏⵜⵓⵏ, ⵎⴰ ⴷ ⴰⴱⴰⵔⵔⴰⵏⵉ ⵏⵉⵖ ⴷ ⵎⵎⵉⵙ ⵏ ⵜⴻⵎⵎⵓⵔⵜ, ⴱⵏⴰⴷⴻⵎ ⵏⵏⵉ ⴰⴷ ⵉⵜⵜⵡⴰⵇⴻⵙⵙ ⵣⵉ ⵜⵎⴻⵙⵎⵓⵏⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","ⵡⴰⵔ ⵜⵜᵉⵜⵜⴻⵎ ⵡⴰⵍⵓ ⵣⵉ ⵎⵉⵏ ⵉⴵⴰⵏ ⵙ ⵡⴻⵏⵜⵓⵏ. ⴷⵉ ⵎⴰⵔⵔⴰ ⵜⵉⵣⴻⴷⴷⴰⵖ ⵏⵡⴻⵎ ⴰⴷ ⵜⴻⵛⵛⴻⵎ ⴰⵖⵔⵓⵎ ⴱⵍⴰ ⴰⵏⵜⵓⵏ.’” ");
INSERT INTO rift_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","ⵉⵍⴰⵖⴰ ⵎⵓⵙⴰ ⵉ ⵎⴰⵔⵔⴰ ⵉⵎⵖⴰⵔⴻⵏ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵉⵏⵏⴰ ⴰⵙⴻⵏ: “ⵟⵟⴼⴻⵎ, ⴽⵙⵉⵎ ⵉⵊⵊⴻⵏ ⵣⴻⴳ ⵡⵓⴵⵉ ⵉ ⵢⵉⵅⴻⴼ ⵏⵡⴻⵎ, ⵉ ⵍⴰⴵⴰⵜ ⵏⵡⴻⵎ ⵓ ⵖⴰⵔⵚⴻⵎ ⵜ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵓⵙⴻⵄⴷⵓ. ");
INSERT INTO rift_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","ⵟⵟⴼⴻⵎ ⵉⵛⵜ ⵏ ⵜⵇⴻⴱⴱⵉⴹⵜ ⵏ ⵜⵄⴻⵍⴵⴻⵜ, ⵙⵖⴻⴹⵙⴻⵎ ⵜⵜ ⴷⴻⴳ ⵉⴷⴰⵎⵎⴻⵏ ⵏⵏⵉ ⵉⴵⴰⵏ ⴷⵉ ⵟⵟⴻⴱⵚⵉ, ⵖⴻⵎⵙⴻⵏ ⵅⴻⵏⵏⵉ ⵣⴻⴳ ⵉⴷⴰⵎⵎⴻⵏ ⵉ ⵉⴵⴰⵏ ⴷⵉ ⵟⵟⴻⴱⵚⵉ ⵅ ⵜⵏⴻⴱⴷⴰⵜ ⵙⴻⵏⵏⴻⵊ ⵉ ⵜⴻⵡⵡⴰⵔⵜ ⵓ ⵅ ⵜⵏⴰⵢⴻⵏ ⵏ ⵍⴻⴹⵔⵓⴼ ⵖⴰⵔ ⵓⵖⴻⵣⴷⵉⵙ ⵏ ⵜⴻⵡⵡⴰⵔⵜ. ⴰⵍ ⵚⵚⴱⴻⵃ ⵡⴰⵔ ⵉⵜⵜⴻⴼⴼⴻⵖ ⵓⵍⴰ ⴷ ⵉⵊⵊⴻⵏ ⵣⵣⴰⵢⵡⴻⵎ ⵣⵉ ⵜⴻⵡⵡⴰⵔⵜ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","ⵙⵉⴷⵉ ⴰⴷ ⵉⵥⵡⴰ ⵅ ⵜⴻⵎⵎⵓⵔⵜ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⵡⵡⴻⵜ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ, ⵎⴰⵛⴰ ⵅⵎⵉ ⵖⴰ ⵉⵥⴰⵔ ⵉⴷⴰⵎⵎⴻⵏ ⵅ ⵜⵏⴻⴱⴷⴰⵜ ⵏ ⵏⵏⴻⵊ ⵓ ⵅ ⵜⵏⴰⵢⴻⵏ ⵏ ⵍⴻⴹⵔⵓⴼ ⵖⴰⵔ ⵓⵖⴻⵣⴷⵉⵙ ⵏ ⵜⴻⵡⵡⴰⵔⵜ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⵄⴷⵓ ⵙⵉⴷⵉ ⵜⴰⵡⵡⴰⵔⵜ ⵏⵏⵉ, ⵡⴰⵔ ⵉⵜⵜⴻⵊⵊⵉ ⴰⵎⵜⴻⵃⵃⴰⵢ ⴰⴷ ⵢⴰⴷⴻⴼ ⵖⴰⵔ ⵜⵓⴷⵔⵉⵏ ⵏⵡⴻⵎ, ⵃⵉⵎⴰ ⴰⴷ ⵉⵡⵡⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","ⵃⴹⴰⵎ ⴰⵡⴰⵍ-ⴰ ⵉ ⵏⵏⵉⵖ, ⴰⵇⴰ ⴷ ⵜⴻⵡⵚⴻⵢⵢⴻⵜ ⵉ ⵛⴻⴽ ⵓ ⵉ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵛ ⵉ ⵍⴻⴱⴷⴰ. ");
INSERT INTO rift_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","ⴰⴷ ⵢⵉⵍⵉ, ⵅⵎⵉ ⵖⴰ ⵜⴰⴷⴼⴻⵎ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵜⴻⵏⵏⵉ ⴷ ⴰⵡⴻⵎ ⵖⴰ ⵢⴻⵡⵛ ⵙⵉⴷⵉ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵉⵏⵏⴰ ⵏⴻⵜⵜⴰ, ⴰⴷ ⵜⴻⵃⴹⴰⵎ ⴰⵄⴱⴰⴷ-ⴰ ⵏ ⵍⵉⴷⴰⵔⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","ⵓⵛⴰ ⵅ ⵎⵉⵏⵏⵉ ⴷ ⴰⵡⴻⵎ ⵖⴰ ⵉⵏⵉⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵡⴻⵎ: ‘ⵎⵉⵏ ⵉⵅⵙ ⴰⴷ ⵢⵉⵏⵉ ⵡⴻⵄⴱⴰⴷ-ⴰ ⵏ ⵍⵉⴷⴰⵔⴻⵜ ⵉ ⴽⴻⵏⵏⵉⵡ?’, ");
INSERT INTO rift_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⵉⵏⵉⵎ: ‘ⴰⵇⴰ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵓⵙⴻⵄⴷⵓ ⵉ ⵙⵉⴷⵉ ⵡⴻⵏⵏⵉ ⵉⵄⴷⵓⵏ ⵅ ⵜⵓⴷⵔⵉⵏ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴷⵉ ⵎⵉⵚⵔⴰ, ⵓⵎⵉ ⵉⵡⵜⴰ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ ⵓⵛⴰ ⵉⴼⴻⴽⴽ ⵜⵓⴷⵔⵉⵏ ⵏⵏⴻⵖ.’” ⵍⴻⵅⴷⴻⵏⵏⵉ ⵢⵓⴹⴰⵔ ⵍⴳⴻⵏⵙ ⵓⵛⴰ ⴱⴻⵏⴷⵇⴻⵏ ⵏⵉⵜⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","ⵔⵓⵃⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵛⴰ ⴳⴳⵉⵏ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⴻⵏ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ ⵓ ⴰⵎⵎⵓ ⵉ ⵜⵜ ⴳⴳⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","ⵜⵓⵖⴰ ⵖⴰⵔ ⵡⴻⵣⵢⴻⵏ ⵏ ⴵⵉⵍⴻⵜ ⵓⵎⵉ ⵉⵡⵜⴰ ⵙⵉⴷⵉ ⵎⴰⵔⵔⴰ ⵉⵎⴻⵏⵣⴰ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⵙ ⵍⵎⴻⵡⵜ, ⵣⴻⴳ ⵓⵎⴻⵏⵣⵓ ⵏ ⴼⵉⵔⵄⵓⵏ, ⵡⴻⵏⵏⵉ ⵉⵇⵇⵉⵎⴻⵏ ⵅ ⵍⵄⴰⵔⵛ ⵏⵏⴻⵙ, ⴰⵍ ⴰⵎⴻⵏⵣⵓ ⵏ ⵓⵎⴻⵃⴱⵓⵙ ⵉ ⵉⴵⴰⵏ ⴷⵉ ⵍⴻⵃⴱⴻⵙ, ⵓⵍⴰ ⴷ ⵎⴰⵔⵔⴰ ⵉⵎⴻⵏⵣⴰ ⵏ ⵍⴻⴱⵀⴰⵢⴻⵎ.    ");
INSERT INTO rift_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","ⵉⴽⴽⴰⵔ ⴼⵉⵔⵄⵓⵏ ⴷⵉ ⴵⵉⵍⴻⵜ ⵏⵏⵉ, ⵏⴻⵜⵜⴰ ⴷ ⵎⴰⵔⵔⴰ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵙ ⴷ ⵎⴰⵔⵔⴰ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ ⵓⵛⴰ ⵜⵓⵖⴰ ⴷⵉⵏ ⵉⵛⵜ ⵏ ⵜⵖⵓⵢⵢⵉⵜ ⵜⴻⵎⵖⴰⵔ ⵎⵉⵏⵣⵉ ⵡⴰⵔ ⵜⵓⵖⵉ ⵓⵍⴰ ⴷ ⵉⵛⵜ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵎⴰⵏⵉ ⵡⴰⵔ ⵉⴵⵉ ⵓⵎⴻⵜⵜⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","ⵓⵛⴰ ⵉⵍⴰⵖⴰ-ⴷⴷ ⵉ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ ⵙ ⴵⵉⵍⴻⵜ, ⵉⵏⵏⴰ: “ⴽⴽⴰⵔⴻⵎ, ⵜⴻⴼⴼⵖⴻⵎ ⵣⵉ ⵍⵡⴻⵙⵟ ⵏ ⵍⴳⴻⵏⵙ ⵉⵏⵓ, ⴽⴻⵏⵏⵉⵡ ⵊⵎⵉⵄ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵔⵓⵃⴻⵎ, ⵜⵄⴻⴱⴷⴻⵎ ⵙⵉⴷⵉ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⴻⵏⵏⴰⵎ ⴽⴻⵏⵏⵉⵡ. ");
INSERT INTO rift_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","ⴰⵡⵢⴻⵎ ⵓⴵⵉ ⵏⵡⴻⵎ ⴷ ⵉⴼⵓⵏⴰⵙⴻⵏ ⴷ ⵜⴼⵓⵏⴰⵙⵉⵏ ⵏⵡⴻⵎ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⴻⵏⵏⴰⵎ. ⵔⵓⵃⴻⵎ, ⵎⴰⵛⴰ ⵜⵜⵣⴰⵡⴳⴻⵖ ⴽⴻⵏⵏⵉⵡ, ⴱⴰⵔⴽⴻⵎ ⴰⵢⵉ ⵏⴻⵛⵛ ⵄⴰⵡⴻⴷ!” ");
INSERT INTO rift_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","ⵣⴻⵢⵢⴰⵔⴻⵏ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ ⴰⵟⵟⴰⵙ ⵅ ⵍⴳⴻⵏⵙ, ⵎⴰⵃⴻⵏⴷ ⵏⵉⵜⵏⵉ ⴰⴷ ⴼⴼⵖⴻⵏ ⵙ ⵓⵇⴻⴵⴻⵇ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ, ⵎⵉⵏⵣⵉ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ ⵏⵏⴰⵏ: “ⴰⵇⴰ ⵏⴻⵛⵛⵉⵏ ⵎⴰⵔⵔⴰ ⴷ ⵉⵎⴻⵜⵜⴰⵏ!” ");
INSERT INTO rift_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","ⵓⵛⴰ ⵢⵉⵡⵉ ⵍⴳⴻⵏⵙ ⴰⵔⴻⵛⵜⵉ ⵏⵏⴻⵙ ⵇⴱⴻⵍ ⵎⴰ ⵖⴰ ⵉⵏⴹⵓ ⵓⵛⴰ ⵜⵉⴱⴻⵇⵢⵉⵏ ⵏⵏⴹⴻⵏ ⵜⴻⵏⵜ ⵊⴰⵔ ⵡⴰⵔⵔⵓⴹ ⵏⵙⴻⵏ ⵅ ⵟⵖⴰⵔⴹⵉⵏ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴳⴳⵉⵏ ⵄⵍⴰⵃⵙⴰⴱ ⴰⵡⴰⵍ ⵉ ⴷ ⴰⵙⴻⵏ ⵉⵏⵏⴰ ⵎⵓⵙⴰ, ⵜⵜⴰⵔⴻⵏ ⵍⴻⵇⵛⵓⵄ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⴷ ⵡⵓⵔⴻⵖ ⴷ ⵡⴰⵔⵔⵓⴹ ⵣⴻⴳ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","ⵙⵉⴷⵉ ⵉⵡⵛⴰ ⵍⴳⴻⵏⵙ ⴰⵔⴹⴰ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ, ⵡⵛⵉⵏ ⴰⵙⴻⵏ ⵎⵉⵏ ⵜⵜⴰⵔⴻⵏ, ⵓ ⴰⵎⵎⵓ ⵉ ⴽⴻⵛⵛⴹⴻⵏ ⵏⵉⵜⵏⵉ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","ⴼⴻⵙⵢⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⵓⵢⵓⵔⴻⵏ ⵣⵉ ⵔⴰⵄⴰⵎⵙⵉⵙ ⵖⴰⵔ ⵙⵓⴽⴽⵓⵜ, ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⵄⵍⴰⵃⴰⵍ ⴷⵉ ⵙⴻⵜⵜⴰ-ⵎⵢⴰⵜ-ⴰⵍⴻⴼ ⵅ ⵉⴹⴰⵔⴻⵏ, ⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵉⵔⵢⴰⵣⴻⵏ ⵡⴰⵀⴰ, ⴱⵍⴰ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","ⵉⴳⴻⵄⵄⴻⴷ ⴰⴽⵉⴷⵙⴻⵏ ⵉⵊⵊ ⵏ ⵓⴱⴰⵔⵔⵓ ⴷ ⴰⵎⴻⵇⵇⵔⴰⵏ ⵏ ⵄⵍⴰⵎ ⴽⵓⵍ ⵉⵡⴷⴰⵏ, ⵅⴻⵏⵏⵉ ⵄⴰⵡⴻⴷ ⵓⴵⵉ ⴷ ⵉⴼⵓⵏⴰⵙⴻⵏ ⴷ ⵜⴼⵓⵏⴰⵙⵉⵏ, ⴰⵇⴰ-ⵜⵜ ⴷ ⵉⵛⵜ ⵏ ⵜⵃⵉⵎⴰⵔⵜ ⵜⴻⵎⵖⴰⵔ ⴰⵟⵟⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","ⵙ ⵡⴰⵔⴻⵛⵜⵉ ⵉ ⴽⵉⴷⵙⴻⵏ ⴷⴷ-ⵉⵡⵢⴻⵏ ⵣⵉ ⵎⵉⵚⵔⴰ ⴳⴳⵯⵉⵏ ⵜⵉⴼⴹⵉⵔⵉⵏ ⴱⵍⴰ ⴰⵏⵜⵓⵏ, ⵎⵉⵏⵣⵉ ⵜⵓⵖⴰ ⵄⴰⴷ ⵡⴰⵔ ⵉⵙⵎⵉⵎ, ⵎⵉⵏⵣⵉ ⵓⵥⵥⵍⴻⵏ ⵅⴰⵙⴻⵏ-ⴷⴷ ⵣⵉ ⵎⵉⵚⵔⴰ ⵓ ⵡⴰⵔ ⵣⴻⵎⵎⴰⵔⴻⵏ ⴰⴷ ⴱⴻⴷⴷⴻⵏ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴰⵔⴻⵢⵢⵃⴻⵏ ⵓ ⵡⴰⵔ ⵙⵙⵡⴻⵊⴷⴻⵏ ⵎⴰⵛⵛⴰ ⵉ ⵡⴻⴱⵔⵉⴷ ⵉ ⵢⵉⵅⴻⴼ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","ⵜⵓⵖⴰ ⵍⵎⵉⵊⴰⵍ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴷⵉ ⵎⵉⵚⵔⴰ, ⵍⵎⵉⵊⴰⵔ ⵉ ⴷⵉⵏ ⵉⵣⴻⴷⵖⴻⵏ, ⴰⵔⴻⴱⵄⴰ-ⵎⵢⴰ ⵓ-ⵜⵍⴰⵜⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","ⵖⴰⵔ ⵓⵏⴻⴳⴳⴰⵔ ⵏ ⴰⵔⴻⴱⵄⴰ-ⵎⵢⴰ ⵓ-ⵜⵍⴰⵜⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⴷⴻⴳ ⵡⴰⵙⵙ ⵏⵏⵉ ⵙⵉⵎⴰⵏⵜ ⵏⵏⴻⵙ, ⴼⴼⵖⴻⵏ ⵎⴰⵔⵔⴰ ⵍⵄⴻⵙⴽⴰⵔ ⵏ ⵙⵉⴷⵉ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","ⵜⴰⵏⵉⵜⴰ ⴰⵇⴰ-ⵜⵜ ⴷ ⵉⵛⵜ ⵏ ⴵⵉⵔⴻⵜ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜᵉⵜⵜⵡⴰⵃⴹⴰ ⵉ ⵍⴻⵡⵇⴰⵔ ⵉ ⵙⵉⴷⵉ, ⵎⴰⵖⴰⵔ ⵏⴻⵜⵜⴰ ⵉⵏⴷⴻⵀ ⵉ-ⵜⴻⵏ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ. ⴵⵉⵍⴻⵜ-ⴰ ⵜⴰⵏⵉⵜⴰ, ⴰⵇⴰ-ⵜⵜ ⵉ ⵙⵉⴷⵉ. ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜᵉⵜⵜⵡⴰⵃⴷⴰ ⵣⵉ ⵎⴰⵔⵔⴰ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⴷⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ: “ⴷ ⵜⴰ ⴷ ⵜⴰⵡⵚⴻⵢⵢⴻⵜ ⵅ ⵜⵖⴰⵔⵚⵜ ⵏ ⵓⵙⴻⵄⴷⵓ: ⵡⴰⵔ ⵣⵣⴰⵢⴻⵙ ⵉⵜⵜⴻⵜⵜ ⵎⵎⵉⵙ ⵏ ⵓⴱⴰⵔⵔⴰⵏⵉ, ");
INSERT INTO rift_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","ⵎⴰⵛⴰ ⴽⵓⵍ ⵉⵙⵎⴻⵖ ⵉⵎⵎⴻⵙⵖⴻⵏ ⵣⴻⴳ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵙ ⵏⵏⵓⵇⴰⵔⵜ, ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵢⴻⵛⵛ, ⵎⴰⵍⴰ ⵜⵅⴻⵜⵏⴻⴷ ⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","ⴰⵎⵄⴻⵣⵣⴻⴱ ⴷ ⵓⵛⴻⵡⵡⴰⵍ ⵡⴰⵔ ⵣⵣⴰⵢⴻⵙ ⵜⵜᵉⵜⵜⴻⵏ ⵛⴰ. ");
INSERT INTO rift_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","ⴰⴷ ⵉⵜⵜⵡⴰⵛⵛ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ ⴷ ⵉⵛⵜ ⵓ ⵡⴰⵔ ⵉⵜⵜⴻⴼⴼⴻⵖ ⵡⴰⵍⵓ ⵣⴻⴳ ⵡⴻⵢⵙⵓⵎ ⵏⵏⵉ ⵖⴰⵔ ⴱⴰⵔⵔⴰ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵓⵛⴰ ⵡⴰⵔ ⵣⵣⴰⵢⴻⵙ ⵉⵜⵜⴰⵔⴻⵥⵥⵉ ⵓⵍⴰ ⴷ ⵉⵊⵊ ⵏ ⵢⵉⵖⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴰⴷ ⵜⴻⴳⴳ ⴰⵎⴻⵏⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","ⵎⴰⵍⴰ ⵛⴰ ⵏ ⵓⴱⴰⵔⵔⴰⵏⵉ ⵉⵏⵏⴻⵡⵊⴻⵡ-ⴷⴷ ⵖⴰⵔⴻⴽ ⵓⵛⴰ ⵉⵅⵙ ⴰⴷ ⵉⵙⵙⴻⵡⵊⴻⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵓⵙⴻⵄⴷⵓ ⵉ ⵙⵉⴷⵉ, ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵉⵜⵜⵡⴰⵅⵜⴻⵏ ⴽⵓⵍ ⴰⵔⵢⴰⵣ ⵏⵏⵉ ⵖⴰⵔⴻⵙ ⵉⴵⴰⵏ. ⵍⴻⵅⴷⴻⵏⵏⵉ ⴰⴷ ⴷⴷ-ⵉⵇⴰⵔⵔⴻⴱ, ⴰⴷ ⵜⵜ ⵉⵙⵙⴻⵡⵊⴻⴷ, ⵓⵛⴰ ⴰⴷ ⵢⵉⵍⵉ ⴰⵎ ⵡⴻⵏⵏⵉ ⴷⴷ-ⵉⵅⴻⵍⵇⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ. ⵎⴰⵛⴰ ⵓⵍⴰ ⴷ ⵉⵊⵊ ⵣⴻⴳ ⵉⵏⵏⵉ ⵡⴰⵔ ⵉⵅⵜⵉⵏⴻⵏ ⵡⴰⵔ ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵢⴻⵛⵛ. ");
INSERT INTO rift_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","ⴰⴷ ⴷⵉⵏ ⵢⵉⵍⵉ ⵉⵊⵊ ⵏ ⵓⵣⴻⵔⴼ ⵉ ⵡⴻⵏⵏⵉ ⴷⴷ-ⵉⵅⴻⵍⵇⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵓ ⵉ ⵓⴱⴰⵔⵔⴰⵏ ⵉ ⵉⵣⴻⴷⴷⵖⴻⵏ ⵊⴰⵔ ⴰⵡⴻⵎ ⴰⵎ ⵓⴱⴰⵔⵔⴰⵏⵉ.” ");
INSERT INTO rift_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","ⵓⵛⴰ ⵎⴰⵔⵔⴰ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴳⴳⵉⵏ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵙⴻⵏ ⵢⵓⵎⵓⵔ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ, ⴰⵎⵎⵓ ⵉ ⵜⵜ ⴳⴳⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","ⵓⵛⴰ ⵉⵎⵙⴰⵔ ⴷⴻⴳ ⵡⴰⵙⵙ ⵏⵏⵉ ⵙⵉⵎⴰⵏⵜ ⵏⵏⴻⵙ ⵉⵙⵙⵓⴼⴼⵓⵖ ⵙⵉⴷⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⴰⵎ ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵏⵉⵜⵏⵉ ⵄⵍⴰⵃⵙⴰⴱ ⵉⵙⴻⴷⴷⵉⵢⵢⴻⵏ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“ⵙⵇⴻⴷⴷⴻⵙ ⴰⵢⵉ ⴽⵓⵍ ⴰⵎⴻⵏⵣⵓ, ⵡⴻⵏⵏⵉ ⵣⵉ ⵊⴰⵔ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵢⴰⵔⴻⵣⵎⴻⵏ ⵍⴻⵎⵍⴰⵡⴻⵜ ⴷ ⴰⵎⴻⵣⵡⴰⵔⵓ, ⴰⵎ ⵣⴻⴳ ⵉⵡⴷⴰⵏ ⴰⵎ ⵣⵉ ⵍⴻⴱⵀⴰⵢⴻⵎ. ⵏⴻⵜⵜⴰ ⴰⵇⴰ ⵉⵏⵓ.” ");
INSERT INTO rift_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","ⵉⵏⵏⴰ ⵎⵓⵙⴰ ⵉ ⵍⴳⴻⵏⵙ: “ⵉⴷⴰⵔⴻⵎ ⴰⵙⵙ-ⴰ ⵎⵉⵏ ⴷⵉ ⵜⴻⴼⴼⵖⴻⵎ ⵣⵉ ⵎⵉⵚⵔⴰ, ⵣⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵜⴻⵙⵎⵓⵖⵉ, ⵎⵉⵏⵣⵉ ⵙⵉⴷⵉ ⵉⵙⵙⵓⴼⴼⴻⵖ-ⴷⴷ ⴽⴻⵏⵏⵉⵡ ⵣⵣⴰⵢⴻⵙ ⵙ ⵓⴼⵓⵙ ⵉⵊⴻⵀⴷⴻⵏ. ⴷⴻⴳ ⵡⴰⵙⵙ-ⴰ ⵡⴰⵔ ⵜᵉⵜⵜⴻⵜⵜⴻⵎ ⵡⴰⵍⵓ ⵎⵉⵏ ⴷⵉ ⵉⴵⴰ ⵡⴻⵏⵜⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","ⴰⵙⵙ-ⴰ ⴰⴷ ⵜⴻⴼⴼⵖⴻⵎ, ⴷⴻⴳ ⵓⵢⵓⵔ ⵏ ⴰⴱⵉⴱ. ");
INSERT INTO rift_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","ⵎⴰⵍⴰ ⵙⵉⴷⵉ ⵉⵙⵙⵉⴷⴻⴼ ⵉ ⵛⴻⴽ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴰⵢⵜ ⵏ ⴽⴻⵏⵄⴰⵏ ⴷ ⵉⵃⵉⵜⵜⵉⵢⵢⴻⵏ ⴷ ⵉⵎⵓⵔⵉⵢⵢⴻⵏ ⴷ ⵉⵃⵉⵡⵉⵢⵢⴻⵏ ⴷ ⵉⵢⴰⴱⵓⵙⵉⵢⵢⴻⵏ, ⵅ ⵜⴻⵏⵏⵉ ⵉⵊⵊⵓⴵ ⵉ ⵍⴻⵊⴷⵓⴷ ⵏⵡⴻⵎ ⴰⴷ ⴰⵛ ⵜⵜ ⵉⵡⵛ, ⵜⴰⵎⵎⵓⵔⵜ ⵉⴼⴻⵢⵢⴹⴻⵏ ⵙ ⵓⵖⵉ ⴷ ⵜⴰⵎⵎⴻⵏⵜ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⴻⵃⴹⴰⵎ ⴰⵄⴱⴰⴷ-ⴰ ⵏ ⵍⵉⴷⴰⵔⴻⵜ ⴷⴻⴳ ⵓⵢⵓⵔ-ⴰ. ");
INSERT INTO rift_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⴰⴷ ⵜⴻⵛⵛⴻⴷ ⴰⵖⵔⵓⵎ ⴱⵍⴰ ⴰⵏⵜⵓⵏ ⵓⵛⴰ ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ ⴰⴷ ⴷⵉⵏ ⵢⵉⵍⵉ ⵉⵊⵊ ⵏ ⵍⵄⵉⴷ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⴰⴷ ⵉⵜⵜⵡⴰⵛⵛ ⵡⴻⵖⵔⵓⵎ ⴱⵍⴰ ⴰⵏⵜⵓⵏ ⵓⵛⴰ ⵡⴰⵔ ⵖⴰⵔⴻⴽ ⵉⵜⵜⵡⵉⴼⴼⵉ ⵎⵉⵏ ⵉⵅⴻⵎⵎⵔⴻⵏ. ⴷⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵡⴰⵢⴻⵀ ⵏⵏⴻⵛ ⵡⴰⵔ ⵉⵜⵜⵡⵉⴼⵉ ⵡⴻⵏⵜⵓⵏ ⵖⴰⵔⴻⴽ. ");
INSERT INTO rift_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","ⴷⴻⴳ ⵡⴰⵙⵙ ⵏⵏⵉ ⴰⴷ ⵜⵃⴰⵊⵉⴷ ⵉ ⵎⵎⵉⵛ, ⴰⴷ ⴰⵙ ⵜⵉⵏⵉⴷ: ⵎⴰⵏ ⴰⵢⴰ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏ ⵎⵉⵏ ⴷ ⴰⵢⵉ ⵉⴳⴳⴰ ⵙⵉⴷⵉ ⵓⵎⵉ ⴷⴷ-ⴼⴼⵖⴻⵖ ⵣⵉ ⵎⵉⵚⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","ⴰⴷ ⴰⵛ ⵢⵉⵍⵉ ⴰⵎ ⵢⵉⵊⵊ ⵏ ⵓⵛⴻⵢⵢⴰⵔ ⵅ ⵓⴼⵓⵙ ⵏⵏⴻⵛ ⵓ ⵉ ⵍⵉⴷⴰⵔⴻⵜ ⵊⴰⵔ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵛ, ⵎⴰⵃⴻⵏⴷ ⵛⵛⴰⵔⵉⵄⴰ ⵏ ⵙⵉⴷⵉ ⴰⴷ ⵜⵉⵍⵉ ⴷⴻⴳ ⵓⵇⴻⵎⵎⵓⵎ ⵏⵏⴻⵛ, ⵎⵉⵏⵣⵉ ⵙ ⵓⴼⵓⵙ ⵉⵊⴻⵀⴷⴻⵏ ⵉⵙⵙⵓⴼⴼⴻⵖ ⵙⵉⴷⵉ ⵉ ⴽⴻⵏⵏⵉⵡ ⵣⵉ ⵎⵉⵚⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","ⵙ ⵓⵢⴰ ⵉ ⵖⴰ ⵜⴻⵃⴹⵉⴷ ⵜⴰⵡⵙⵉⵢⵢⴻⵜ-ⴰ ⴷⵉ ⵍⵡⴻⵇⵜ ⵏⵏⴻⵙ ⵉ ⴷ ⴰⵙ ⵉⵜⵜⵡⴰⴳⴳⴻⵏ, ⵣⴻⴳ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵖⴰⵔ ⵓⵙⴻⴳⴳⵯⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","ⴰⴷ ⵢⵉⵍⵉ ⵅⵎⵉ ⵛⴻⴽ ⵖⴰ ⵉⵙⵙⵉⴷⴻⴼ ⵙⵉⴷⵉ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴰⵢⵜ ⵏ ⴽⴻⵏⵄⴰⵏ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵉ ⴷ ⴰⵛ ⵉⵊⵊⵓⴵ ⵓⵍⴰ ⵉ ⵍⴻⵊⴷⵓⴷ ⵏⵏⴻⵛ, ⵓⵛⴰ ⵉⵡⵛⴰ ⴰⵛ ⵜⵜ, ");
INSERT INTO rift_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⴻⵙⵙⴻⵄⴷⵓⴷ ⵖⴰⵔ ⵙⵉⴷⵉ ⴽⵓⵍ ⴰⵎⴻⵏⵣⵓ ⵉ ⵢⴰⵔⴻⵣⵎⴻⵏ ⵍⴻⵎⵍⴰⵡⴻⵜ ⴷ ⴰⵎⴻⵣⵡⴰⵔⵓ ⵓⵍⴰ ⴷ ⴽⵓⵍ ⴰⵎⴻⵏⵣⵓ ⵏ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵉ ⵢⴰⵔⴻⵣⵎⴻⵏ ⵍⴻⵎⵍⴰⵡⴻⵜ ⴷ ⴰⵎⴻⵣⵡⴰⵔⵓ: ⵉⵡⴻⵜⵎⴰⵏ ⴰⴷ ⵉⵍⵉⵏ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","ⵎⴰⵛⴰ ⴽⵓⵍ ⴰⵎⴻⵏⵣⵓ ⵉ ⵢⴰⵔⴻⵣⵎⴻⵏ ⵍⴻⵎⵍⴰⵡⵍⴻⵜ ⵏ ⵡⴻⵖⵢⵓⵍ ⴷ ⴰⵎⴻⵣⵡⴰⵔⵓ, ⴰⴷ ⵜ ⵜⴻⴼⴷⵉⴷ ⵙ ⵢⵉⵊⵊ ⵣⴻⴳ ⵡⵓⴵⵉ. ⵎⴰⵍⴰ ⵡⴰⵔ ⵜ ⵜⴻⴼⴷⵉⴷ, ⴰⴷ ⴰⵙ ⵜⴰⵔⵥⴻⴷ ⵉⵔⵉ. ⴽⵓⵍ ⴰⵎⴻⵏⵣⵓ ⵏ ⴱⵏⴰⴷⴻⵎ ⵣⴻⴳ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵛ ⴰⴷ ⵜ ⵜⴻⴼⴷⵉⴷ. ");
INSERT INTO rift_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","ⵓⵛⴰ ⴰⴷ ⵉⵎⵙⴰⵔ, ⵅⵎⵉ ⵛⴻⴽ ⵖⴰ ⵉⵙⵙⴻⵇⵙⴰ ⵎⵎⵉⵛ ⵜⵉⵡⴻⵛⵛⴰ, ⴰⴷ ⵢⵉⵏⵉ: ‘ⵎⴰⵏⴰⵡⵢⴰ?’, ⴰⴷ ⴰⵙ ⵜⵉⵏⵉⴷ: ‘ⴰⵇⴰ ⵉⵙⵙⵓⴼⴼⵓⵖ ⴰⵏⴻⵖ-ⴷⴷ ⵙⵉⴷⵉ ⵣⵉ ⵎⵉⵚⵔⴰ ⵙ ⵓⴼⵓⵙ ⵉⵊⴻⵀⴷⴻⵏ, ⵣⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵜⴻⵙⵎⵓⵖⵉ. ");
INSERT INTO rift_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","ⵍⴰⵎⵉ ⴷ ⴰⵏⴻⵖ ⵉⴱⴻⴷⴷ ⴼⵉⵔⵄⵓⵏ ⴷⴻⴳ ⵡⴻⴱⵔⵉⴷ ⵉ ⵡⵓⴼⴼⵓⵖ ⵏⵏⴻⵖ, ⵉⵎⵙⴰⵔ ⴰⵇⴰ ⵙⵉⴷⵉ ⵉⵏⵖⴰ ⵎⴰⵔⵔⴰ ⵉⵎⴻⵏⵣⴰ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ, ⵣⴻⴳ ⵓⵎⴻⵏⵣⵓ ⵏ ⴱⵏⴰⴷⴻⵎ ⴰⵍ ⴰⵎⴻⵏⵣⵓ ⵏ ⵍⴻⴱⵀⵉⵎⴻⵜ. ⵅ ⵓⵢⴰ ⵇⴻⴷⴷⵎⴻⵖ ⴽⵓⵍ ⴰⵎⴻⵏⵣⵓ ⵉ ⵢⴰⵔⴻⵣⵎⴻⵏ ⵍⴻⵎⵍⴰⵡⴻⵜ ⴷ ⴰⵎⴻⵣⵡⴰⵔⵓ ⴷ ⵜⴰⵖⵔⴰⵚⵜ ⵉ ⵙⵉⴷⵉ, ⵎⴰⵛⴰ ⴽⵓⵍ ⴰⵎⴻⵏⵣⵓ ⵊⴰⵔ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵉⵏⵓ, ⴰⴷ ⵜ ⴼⴷⵉⵖ. ");
INSERT INTO rift_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","ⴰⴷ ⵢⵉⵍⵉ ⴷ ⴰⵛⴻⵢⵢⴰⵔ ⵅ ⵓⴼⵓⵙ ⵏⵏⴻⵛ ⴷ ⵉⵊⵊ ⵏ ⵓⴼⵉⵍⵓ ⵏ ⵓⵙⴻⴳⴳⴻⵎ ⵊⴰⵔ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵛ, ⵎⵉⵏⵣⵉ ⵙⵉⴷⵉ ⴰⵇⴰ ⵉⵙⵙⵓⴼⴼⴻⵖ ⴰⵏⴻⵖ-ⴷⴷ ⵣⵉ ⵎⵉⵚⵔⴰ ⵙ ⵓⴼⵓⵙ ⵉⵊⴻⵀⴷⴻⵏ.’” ");
INSERT INTO rift_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","ⵓⵎⵉ ⵉⵊⵊⴰ ⴼⵉⵔⵄⵓⵏ ⵍⴳⴻⵏⵙ ⴰⴷ ⵉⵔⴰⵃ, ⵡⴰⵔ ⵜⴻⵏ ⵉⵏⴷⵉⵀ ⴰⵔⴻⴱⴱⵉ ⵖⴰⵔ ⵡⴻⴱⵔⵉⴷ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵉⴼⵉⵍⵉⵙⵟⵉⵏⵉⵢⵢⴻⵏ, ⵡⴰⵅⵅⴰ ⵏⴻⵜⵜⴰⵜ ⵜⵓⴷⴻⵙ, ⵎⵉⵏⵣⵉ ⴰⵔⴻⴱⴱⵉ ⵉⵏⵏⴰ: “ⵎⴰⵃⴻⵏⴷ ⵡⴰⵔ ⵉⵜⵜⴻⵏⴷⴻⵎⵎⵉ ⵍⴳⴻⵏⵙ ⵅⵎⵉ ⵖⴰ ⵉⵥⴰⵔ ⵍⴱⴰⵔⵓⴹ ⵓⵛⴰ ⴰⴷ ⴷⴷ-ⵉⴷⵡⴻⵍ ⵖⴰⵔ ⵎⵉⵚⵔⴰ.” ");
INSERT INTO rift_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","ⵉⵏⴷⴻⵀ ⴰⵔⴻⴱⴱⵉ ⵍⴳⴻⵏⵙ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⴽⴽ ⵅ ⵡⴻⴱⵔⵉⴷ ⵏ ⵍⴻⵅⵍⴰ ⵖⴰⵔ ⵍⴻⴱⵃⴰⵔ ⵏ ⵜⴻⵍⴳⴰ. ⵓⵛⴰ ⴳⴻⵄⵄⴷⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵣⵉ ⵎⵉⵚⵔⴰ ⵡⴻⵊⴷⴻⵏ ⵉ ⵓⵎⴻⵏⵖⵉ. ");
INSERT INTO rift_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","ⵉⴽⵙⵉ ⵎⵓⵙⴰ ⴰⴽⵉⴷⴻⵙ ⵉⵖⵙⴰⵏ ⵏ ⵢⵓⵙⵓⴼ, ⵎⵉⵏⵣⵉ ⵏⴻⵜⵜⴰ ⵉⵙⵙⵊⵓⴵ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵙ ⵉⵛⵜ ⵏ ⵜⵥⴰⴵⵉⵜ, ⵉⵏⵏⴰ: “ⵙ ⵜⵉⴷⴻⵜⵜ ⴰⴷ ⵖⴰⵔⵡⴻⵎ ⴷⴷ-ⵢⴰⵔⵣⴻⴼ ⴰⵔⴻⴱⴱⵉ, ⵓⵛⴰ ⴰⴷ ⵜⴻⵙⵙⴳⴻⵄⵄⴷⴻⵎ ⵉⵖⵙⴰⵏ ⵉⵏⵓ ⵙⵙⴰ ⴰⴽⵉⴷⵡⴻⵎ!” ");
INSERT INTO rift_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","ⵓⵛⴰ ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴳⴳⵯⴻⵊⴻⵏ ⵅ ⵙⵓⴽⴽⵓⵜ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⵉⵜⴰⵎ, ⵖⴰⵔ ⵟⵟⴰⵔⴼ ⵏ ⵍⴻⵅⵍⴰ. ");
INSERT INTO rift_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","ⵙⵉⴷⵉ ⵉⵣⵡⴰⵔ ⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵙⴻⵏ ⴷⴻⴳ ⵓⵥⵉⵍ ⴷⴻⴳ ⵉⵊⵊ ⵏ ⵓⵇⴻⵍⵍⵉⵊ ⵏ ⵓⵙⴻⵢⵏⵓ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⴻⵏ ⵉⴳⴻⵡⵡⴻⴷ ⴷⴻⴳ ⵡⴻⴱⵔⵉⴷ, ⵓ ⴷⵉ ⴵⵉⵍⴻⵜ ⴷⴻⴳ ⵉⵊⵊ ⵏ ⵓⵇⴻⵍⵍⵉⵊ ⵏ ⵜⵎⴻⵙⵙⵉ, ⵃⵉⵎⴰ ⴰⴷ ⵖⴰⵔⵙⴻⵏ ⵉⴳⴳ ⵜⴰⴼⴰⵡⵜ, ⵃⵉⵎⴰ ⴰⴷ ⵜⴰⴼ ⵣⴻⵎⵎⴰⵔⴻⵏ ⴰⴷ ⵓⵢⵓⵔⴻⵏ ⴰⵙⵙ ⴷ ⴵⵉⵍⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⴰⵔ ⴷⴷ-ⵉⴽⴽⵉⵙ ⴰⵇⴻⵍⵍⵉⵊ ⵏ ⵓⵙⴻⵢⵏⵓ ⵣⵣⴰⵜ ⵉ ⵓⵖⴻⵎⴱⵓⴱ ⵏ ⵍⴳⴻⵏⵙ ⵓⵍⴰ ⴷⵉ ⴵⵉⵍⴻⵜ ⵡⴰⵔ ⴷⴷ-ⵉⴽⴽⵉⵙ ⴰⵇⴻⵍⵍⵉⵊ ⵏ ⵜⵎⴻⵙⵙⵉ. ");
INSERT INTO rift_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","ⵅⴻⵏⵏⵉ ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“ⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴷⴷ-ⴷⴻⵡⵍⴻⵏ ⵓⵛⴰ ⴰⴷ ⵡⵜⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⵣⵣⴰⵜ ⵉ ⴼⵉ-ⵀⴰⵅⵉⵔⵓⵜ, ⵊⴰⵔ ⵎⵉⴳⴷⵓⵍ ⴷ ⵍⴻⴱⵃⴰⵔ, ⵇⵉⴱⴰⵍⵜ ⵉ ⴱⴰⵄⴰⵍ-ⵚⴰⴼⵓⵏ. ⴰⵔⴻⵏⴷⴰⴷ ⵏⵏⴻⵙ ⴰⴷ ⵜⴻⵡⵜⴻⵎ ⵉⵇⵉⴹⴰⵏ ⵏⵡⴻⵎ ⵅ ⵜⵎⴰ ⵏ ⵍⴻⴱⵃⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","ⵅⴻⵏⵏⵉ ⴰⴷ ⵢⵉⵏⵉ ⴼⵉⵔⵄⵓⵏ ⵅ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ: ‘ⴰⵇⴰ ⵏⵉⵜⵏⵉ ⵡⴻⴷⴷⴰⵔⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ, ⴰⵇⴰ ⵍⴻⵅⵍⴰ ⵉⵃⵚⴰⵔ ⵉ-ⵜⴻⵏ.’ ");
INSERT INTO rift_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","ⵓⵛⴰ ⵏⴻⵛⵛ ⴰⴷ ⵙⵙⵇⴻⵙⵃⴻⵖ ⵓⵍ ⵏ ⴼⵉⵔⵄⵓⵏ, ⵃⵉⵎⴰ ⴰⴷ ⵜⴻⵏ ⵉⴹⴼⴰⵔ ⵓ ⵏⴻⵛⵛ ⴰⴷ ⵜⵜⵡⴰⵙⵙⵄⵓⴵⵉⵖ ⵅ ⴼⵉⵔⵄⵓⵏ ⵓ ⵅ ⵎⴰⵔⵔⴰ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⵙⵙⵏⴻⵏ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ ⴱⴻⵍⵍⵉ ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ.” ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⵜⵜ ⴳⴳⵉⵏ ⵏⵉⵜⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","ⵓⵛⴰ ⵅⴻⴱⴱⴰⵔⴻⵏ ⵉ ⵓⵊⴻⴵⵉⴹ ⵏ ⵎⵉⵚⵔⴰ ⴱⴻⵍⵍⵉ ⵍⴳⴻⵏⵙ ⵢⴰⵔⵡⴻⵍ. ⵅⴻⵏⵏⵉ ⵉⴱⴻⴷⴷⴻⵍ ⵡⵓⵍ ⵏ ⴼⵉⵔⵄⵓⵏ ⴷ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵙ ⵅ ⵍⴳⴻⵏⵙ ⵓⵛⴰ ⵏⵏⴰⵏ: “ⵎⴰⵎⵎⴻⵛ ⵉ ⵏⴻⴳⴳⴰ ⴰⵢⴰ, ⵏⴻⵙⵙⴻⴽⴽ ⵉⵙⵔⴰⵉⵍ ⵣⵉ ⵜⴻⵙⵎⵓⵖⵉ ⵉ ⵉⴳⴳⵉⵏ ⵉ ⵏⴻⵛⵛⵉⵏ?” ");
INSERT INTO rift_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","ⵓⵛⴰ ⵉⵃⴻⵣⵣⴻⵎ ⴼⵉⵔⵄⵓⵏ ⴰⴽⴰⵔⵔⵓ ⵏⵏⴻⵙ, ⵉⴽⵙⵉ ⴰⴽⵉⴷⴻⵙ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","ⵉⴽⵙⵉ ⴰⴽⵉⴷⴻⵙ ⵙⴻⵜⵜⴰ-ⵎⵢⴰ ⵏ ⵉⴽⴰⵔⵔⵓⵜⴻⵏ ⵉⵛⴻⵡⵡⴰⵔⴻⵏ ⴷ ⵎⴰⵔⵔⴰ ⵉⴽⴰⵔⵔⵓⵜⴻⵏ ⵏ ⵎⵉⵚⵔⴰ ⵓⵛⴰ ⵉⴳⴳⴰ ⴰⵛⴻⵡⵡⴰⵔ ⵏ ⵉⵏⴻⵖⵔⴰⴼⴻⵏ ⵣⵉ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵏⴻⵙ ⵅ ⴽⵓⵍ ⵉⵊⵊ ⵣⵣⴰⵢⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","ⴰⵇⴰ ⵉⵙⵙⴻⵇⵙⴻⵃ ⵙⵉⴷⵉ ⵓⵍ ⵏ ⴼⵉⵔⵄⵓⵏ, ⴰⵊⴻⴵⵉⴷ ⵏ ⵎⵉⵚⵔⴰ, ⵓⵛⴰ ⵢⴰⵔⴷⴻⴼ ⵏⴻⵜⵜⴰ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵎⴰⵛⴰ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵜⵓⵖⴰ ⴼⴼⵖⴻⵏ ⵙ ⵢⵉⵊⵊ ⵏ ⵓⴼⵓⵙ ⵉⵜⵜⵡⴰⵙⵙⴳⴻⵄⵄⴷⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","ⴰⵔⴻⴷⴼⴻⵏ ⵜⴻⵏ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ ⵓⵛⴰ ⵉⵡⴹⴻⵏ ⵖⴰⵔⵙⴻⵏ ⵙ ⵎⴰⵔⵔⴰ ⵉⵢⵙⴰⵏ ⴷ ⵉⴽⴰⵔⵔⵓⵜⴻⵏ ⵏ ⴼⵉⵔⵄⵓⵏ ⴷ ⵉⵎⵏⴰⵢⴻⵏ ⵏⵏⴻⵙ ⴷ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵏⴻⵙ, ⵖⴰⵔ ⴼⵉ-ⵀⴰⵅⴰⵔⵓⵜ, ⵖⴰⵔ ⵓⵊⴻⵎⵎⴰⴹ ⵏ ⴱⴰⵄⴰⵍ-ⵚⴰⴼⵓⵏ, ⵎⴰⵏⵉ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⵖⴰⵔ ⵍⴻⴱⵃⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","ⵍⴰⵎⵉ ⵜⴻⵏ ⴷⴷ-ⵢⵓⴷⴻⵙ ⴼⵉⵔⵄⵓⵏ, ⵙⵙⴳⴻⵄⵄⴷⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵜⴰⵎⵓⵖⵍⵉ ⵏⵙⴻⵏ, ⵥⵔⵉⵏ ⴱⴻⵍⵍⵉ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ ⴹⴼⴰⵔⴻⵏ ⵜⴻⵏ-ⴷⴷ ⵓⵛⴰ ⵏⵉⵜⵏⵉ ⴳⴳⵯⴻⴷⴻⵏ ⴰⵟⵟⴰⵙ. ⵅⴻⵏⵏⵉ ⵙⵖⵓⵢⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵖⴰⵔ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","ⵏⵏⴰⵏ ⵉ ⵎⵓⵙⴰ: “ⵎⴰ ⵡⴰⵔ ⴵⵉⵏ ⵄⴰⴷ ⵉⵎⴻⴹⵍⴰⵏ ⴷⵉ ⵎⵉⵚⵔⴰ ⴰⵍ ⴷ ⴰⵏⴻⵖ ⴷⴷ-ⵜⴰⵡⵢⴻⴷ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵏⴻⵎⵎⴻⵜ ⴷⵉ ⵍⴻⵅⵍⴰ-ⵢⴰ? ⵎⴰⵖⴰⵔ ⵜⴻⴳⴳⵉⴷ ⴰⵎⵎⵓ, ⵜⴻⵙⵙⵓⴼⴼⵖⴻⴷ ⴰⵏⴻⵖ-ⴷⴷ ⵣⵉ ⵎⵉⵚⵔⴰ? ");
INSERT INTO rift_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","ⵎⴰ ⵡⴰⵔ ⴽⵉⴷⴻⴽ ⵏⴻⵙⵙⵉⵡⴻⵍ ⵎⴰⵔⵔⴰ ⴰⵡⴰⵍⴻⵏ-ⴰ ⴷⵉ ⵎⵉⵚⵔⴰ, ⵏⴻⵏⵏⴰ: ‘ⴻⵊⵊ ⴰⵏⴻⵖ ⴰⴷ ⵏⴻⵅⴷⴻⵎ ⵉ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ’? ⵅⴰⵔ ⵎⴰⵍⴰ ⵜⵓⵖⴰ ⵏⴻⵇⵇⵉⵎ ⵏⴻⵅⴷⴻⵎ ⵉ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ ⵅ ⵎⴰⵍⴰ ⵏⴻⵎⵎⵓⵜ ⴷⵉ ⵍⴻⵅⵍⴰ.” ");
INSERT INTO rift_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵎⵓⵙⴰ ⵉ ⵍⴳⴻⵏⵙ: “ⵡⴰⵔ ⵜⵜⴻⴳⴳⵯⴻⴷⴻⵎ, ⴱⴻⴷⴷⴻⵎ, ⵜⴻⵅⵣⴰⵔⴻⵎ ⴰⵙⴻⵏⵊⴻⵎ ⵏ ⵙⵉⴷⵉ ⵉ ⴷ ⴰⵡⴻⵎ ⵖⴰ ⵢⴻⵡⵛ ⴰⵙⵙ-ⴰ, ⵎⵉⵏⵣⵉ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ ⵏⵏⵉ ⵜᵉⵜⵜⵡⴰⵍⴰⵎ ⴰⵙⵙ-ⴰ, ⵄⴻⵎⵎⴰⵔⵚ ⴰⴷ ⵜⴻⵏ ⵜⵥⴰⵔⴻⵎ ⵄⴰⴷ ⵉ ⵍⴻⴱⴷⴰ. ");
INSERT INTO rift_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","ⵙⵉⴷⵉ ⴰⴷ ⵅⴰⵡⴻⵎ ⵉⵎⵎⵏⴻⵖ ⵓⵛⴰ ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⵜⵙⴻⵖⴷⴻⵎ ⵡⴰⵀⴰ.” ");
INSERT INTO rift_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⵎⴰⵢⴻⵎⵎⵉ ⵖⴰⵔⵉ ⵜᵉⵜⵜⵍⴰⵖⵉⴷ? ⵉⵏⵉ ⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵃⵉⵎⴰ ⴰⴷ ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","ⵙⴳⴻⵄⵄⴻⴷ ⵜⴰⵖⵖⴰⵔⵛⵜ ⵏⵏⴻⵛ, ⵙⵡⵉⵥⵥⴻⴹ ⴰⴼⵓⵙ ⵏⵏⴻⵛ ⵅ ⵍⴻⴱⵃⴰⵔ ⵓⵛⴰ ⴼⴰⵔⵇ ⵉ-ⵜ, ⵃⵉⵎⴰ ⴰⴷ ⵉⵥⵡⴰ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵅ ⵍⴱⴰⵔⵔ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏ ⵍⴻⴱⵃⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","ⵅⵣⴰⵔ, ⵏⴻⵛⵛ ⴰⴷ ⵙⵙⵇⴻⵙⵃⴻⵖ ⵓⵍ ⵏ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⴻⵏ ⴰⵔⴻⴷⴼⴻⵏ ⴷⵉ ⵍⴻⴱⵃⴰⵔ ⵓ ⵏⴻⵛⵛ ⴰⴷ ⵙⵙⵄⵓⴵⵉⵖ ⵉⵅⴻⴼ ⵉⵏⵓ ⵙ ⴼⵉⵔⵄⵓⵏ ⵓ ⵙ ⵎⴰⵔⵔⴰ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵏⴻⵙ, ⵉⴽⴰⵔⵔⵓⵜⴻⵏ ⵏⵏⴻⵙ ⴷ ⵉⵎⵏⴰⵢⴻⵏ ⵏⵏⴻⵙ ⵏ ⵉⵢⵙⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","ⴰⴷ ⵙⵙⵏⴻⵏ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ ⴱⴻⵍⵍⵉ ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⵅⵎⵉ ⵖⴰ ⵜⵜⵡⴰⵙⵙⵄⵓⴵⵉⵖ ⵙ ⴼⵉⵔⵄⵓⵏ, ⵙ ⵉⴽⴰⵔⵔⵓⵜⴻⵏ ⵏⵏⴻⵙ ⴷ ⵉⵎⵏⴰⵢⴻⵏ ⵏⵏⴻⵙ ⵏ ⵉⵢⵙⴰⵏ.” ");
INSERT INTO rift_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","ⵅⴻⵏⵏⵉ ⵉⵎⵎⵓⵟⵟⵉ ⵍⵎⴰⵍⴰⴽ ⵏ ⴰⵔⴻⴱⴱⵉ ⵏⵏⵉ ⵢⵓⵢⵓⵔⴻⵏ ⵣⵣⴰⵜ ⵉ ⵍⵄⴻⵙⴽⴰⵔ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵛⴰ ⵉⴷⵡⴻⵍ ⵖⴰⵔ ⴹⴻⴼⴼⴰⵔ ⵏⵙⴻⵏ: ⴰⵇⴻⵍⵍⵉⵊ ⵏ ⵓⵙⴻⵢⵏⵓ ⵉⵎⵎⵓⵟⵟⵉ ⵣⵉ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏⵙⴻⵏ ⵓⵛⴰ ⵉⴱⴻⴷⴷ ⵖⴰⵔ ⴹⴻⴼⴼⴰⵔ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","ⵢⵓⴷⴻⴼ ⵓⵇⴻⵍⵍⵉⵊ ⵊⴰⵔ ⵍⵄⴻⵙⴽⴰⵔ ⵏ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ ⴷ ⵍⵄⴻⵙⴽⴰⵔ ⵏ ⵉⵙⵔⴰⵉⵍ. ⵜⵓⵖⴰ ⴰⵙⴻⵢⵏⵓ ⴷ ⵜⴰⴵⴻⵙⵜ ⵖⴰⵔ ⵓⵖⴻⵣⴷⵉⵙ-ⴰ ⵓ ⵉⵙⵙⵉⵖ ⵉ ⵓⵖⴻⵣⴷⵉⵙ ⵏⵏⴻⵖⵏⵉ ⵙ ⴵⵉⵍⴻⵜ ⵓ ⵡⴰⵔ ⴷⴷ-ⵉⵇⴰⵔⵔⴻⴱ ⵉⵊⵊⴻⵏ ⵖⴰⵔ ⵡⴻⵏⵏⴻⵖⵏⵉ ⴵⵉⵍⴻⵜ ⵜⴻⴽⵎⴻⵍ. ");
INSERT INTO rift_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","ⵓⵛⴰ ⵉⵙⵙⵡⵉⵥⵥⴻⴹ ⵎⵓⵙⴰ ⴰⴼⵓⵙ ⵏⵏⴻⵙ ⵅ ⵍⴻⴱⵃⴰⵔ ⵓⵛⴰ ⵉⵄⴰⵔⵏ ⵙⵉⴷⵉ ⵅⴻⵏⵏⵉ ⵍⴻⴱⵃⴰⵔ ⵖⴰⵔ ⵓⵖⴻⵣⴷⵉⵙ ⵙ ⵢⵉⵊⵊ ⵏ ⵓⵙⴻⵎⵎⵉⴹ ⴷ ⴰⵛⴰⵔⵇⵉ ⵉⵊⵀⴻⴷ, ⵎⴰⵔⵔⴰ ⴵⵉⵍⴻⵜ ⵏⵏⵉ, ⵓⵛⴰ ⵢⴰⵔⵔⴰ ⵍⴻⴱⵃⴰⵔ ⴰⴷ ⵉⵊⴻⴼⴼⴻⴼ. ⴰⵎⵎⵓ ⵉ ⵜⵜⵡⴰⵎⵎⵙⴻⴱⴹⴰⵏ ⵡⴰⵎⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","ⵓⵢⵓⵔⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵅ ⵎⵉⵏ ⵢⵓⵥⵖⴻⵏ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏ ⵍⴻⴱⵃⴰⵔ ⵓⵛⴰ ⴰⵎⴰⵏ ⴳⴳⵉⵏ ⴰⵎⴻⵛⵏⴰⵡ ⵍⵃⵉⴹ ⵅ ⵢⴻⴼⵓⵙ ⵏⵙⴻⵏ ⴷ ⵓⵣⴻⵍⵎⴰⴹ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","ⴰⵔⴻⴷⴼⴻⵏ ⵜⴻⵏ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ, ⵔⵓⵃⴻⵏ ⴰⵡⴰⵔⵏⵉ ⴰⵙⴻⵏ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏ ⵍⴻⴱⵃⴰⵔ ⵙ ⵎⴰⵔⵔⴰ ⵉⵢⵙⴰⵏ ⵏ ⴼⵉⵔⵄⵓⵏ ⴷ ⵉⴽⴰⵔⵔⵓⵜⴻⵏ ⵏⵏⴻⵙ ⴷ ⵉⵎⵏⴰⵢⴻⵏ ⵏⵏⴻⵙ ⵏ ⵢⵉⵢⵙⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","ⵍⴰⵎⵉ ⴷ ⵢⴻⴼⴼⵓ ⵍⵃⴰⵍ, ⵉⵎⵙⴰⵔ ⴱⴻⵍⵍⵉ ⵙⵉⴷⵉ ⵉⵚⵡⴻⴹ ⵖⴰⵔ ⵍⵄⴻⵙⴽⴰⵔ ⵏ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ ⵣⴻⴳ ⵓⵇⴻⵍⵍⵉⵊ ⵏ ⵜⵎⴻⵙⵙⵉ ⴷ ⵉⵙⴻⵢⵏⵓⵜⴻⵏ ⵓⵛⴰ ⵉⵙⵙⵅⴰⵔⵡⴻⴹ ⵍⵄⴻⵙⴽⴰⵔ ⵏ ⵎⵉⵚⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","ⵉⵊⵊⴰ ⵜⵉⵊⴰⵔⵔⴰⵔⵉⵏ ⵏ ⵉⴽⴰⵔⵔⵓⵜⴻⵏ ⵏⵙⴻⵏ ⴰⴷ ⴼⴻⵙⵅⴻⵏⵜ, ⴰⵍⴰⵎⵉ ⵉⴷⵡⴻⵍ ⵉⵡⵄⴰⵔ ⵅⴰⵙⴻⵏ ⴰⴷ ⵓⵢⵓⵔⴻⵏ ⵖⴰⵔ ⵣⵣⴰⵜ. ⵍⴻⵅⴷⴻⵏⵏⵉ ⵏⵏⴰⵏ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ, ⴽⵓⵍ ⵉⵊⵊⴻⵏ ⵣⵣⴰⵢⵙⴻⵏ ⵉ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵙ: “ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⵢⵉ ⴰⴷ ⴰⵔⴻⵡⵍⴻⵖ ⵣⵉ ⵣⵣⴰⵜ ⵏ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵎⵉⵏⵣⵉ ⵙⵉⴷⵉ ⵉⵎⵎⵏⴻⵖ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏⵙⴻⵏ ⴹⵉⴷⴷ ⵉ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⵙⵡⵉⵥⵥⴻⴹ ⴰⴼⵓⵙ ⵏⵏⴻⵛ ⵅ ⵍⴻⴱⵃⴰⵔ, ⵃⵉⵎⴰ ⴰⴷ ⴷⴻⵡⵍⴻⵏ ⵡⴰⵎⴰⵏ ⵅ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ, ⵅ ⵉⴽⴰⵔⵔⵓⵜⴻⵏ ⵏⵙⴻⵏ ⵓ ⵅ ⵉⵎⵏⴰⵢⴻⵏ ⵏⵙⴻⵏ ⵏ ⵉⵢⵙⴰⵏ.” ");
INSERT INTO rift_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","ⵅⴻⵏⵏⵉ ⵉⵙⵙⵡⵉⵥⵥⴻⴹ ⵎⵓⵙⴰ ⴰⴼⵓⵙ ⵏⵏⴻⵙ ⵅ ⵍⴻⴱⵃⴰⵔ ⵓ ⵖⴰⵔ ⵍⴻⴼⵊⴰⵔ ⵏ ⵚⵚⴱⴻⵃ ⵉⴷⵡⴻⵍ ⵍⴻⴱⵃⴰⵔ ⵖⴰⵔ ⵎⴰⵏⵉ ⵜ ⵜⵓⵖⴰ ⵇⴱⴻⵍ ⵓⵛⴰ ⴰⵔⴻⵡⵍⴻⵏ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ ⵏⵉⵛⴰⵏ ⴹⵉⴷⴷ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⵖⴹⴻⵍ ⵙⵉⴷⵉ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏ ⵍⴻⴱⵃⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","ⴷⴻⵡⵍⴻⵏ-ⴷⴷ ⵡⴰⵎⴰⵏ ⵓⵛⴰ ⵜⵜⵡⴰⵏⴻⴹⵍⴻⵏ ⵉⴽⴰⵔⵔⵓⵜⴻⵏ ⴷ ⵉⵎⵏⴰⵢⴻⵏ ⵏ ⵉⵢⵙⴰⵏ ⵏ ⵎⴰⵔⵔⴰ ⵍⵄⴻⵙⴽⴰⵔ ⵏ ⴼⵉⵔⵄⵓⵏ ⵉ ⵜⵓⵖⴰ ⵢⵓⴷⴻⴼ ⴰⵡⴰⵔⵏⵉ ⴰⵙⴻⵏ ⵖⴰⵔ ⵍⴻⴱⵃⴰⵔ. ⵡⴰⵔ ⵣⵣⴰⵢⵙⴻⵏ ⵉⵇⵇⵉⵎ ⵓⵍⴰ ⴷ ⵉⵊⵊⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","ⵎⴰⵛⴰ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵢⵓⵔⴻⵏ ⵅ ⵎⵉⵏ ⵢⵓⵥⵖⴻⵏ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏ ⵍⴻⴱⵃⴰⵔ ⵓ ⴰⵎⴰⵏ ⵜⵓⵖⴰ ⴳⴳⵉⵏ ⴰⵎⴻⵛⵏⴰⵡ ⵍⵃⵉⴹ ⵖⴰⵔ ⵢⴻⴼⵓⵙ ⵏⵙⴻⵏ ⴷ ⵓⵣⴻⵍⵎⴰⴹ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","ⴰⵎⵎⵓ ⵉ ⵉⵙⵙⴻⵏⵊⴻⵎ ⵙⵉⴷⵉ ⵉⵙⵔⴰⵉⵍ ⴷⴻⴳ ⵡⴰⵙⵙ ⵏⵏⵉ ⵣⴻⴳ ⵓⴼⵓⵙ ⵏ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ ⵓⵛⴰ ⵉⵙⵔⴰⵉⵍ ⵉⵥⵔⴰ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ ⵉ ⵉⵎⵎⵓⵜⴻⵏ ⵅ ⵜⵎⴰ ⵏ ⵍⴻⴱⵃⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","ⵉⵥⵔⴰ ⵉⵙⵔⴰⵉⵍ ⴰⴼⵓⵙ ⵉⵎⵖⴰⵔⴻⵏ ⵉ ⵉⴳⴳⴰ ⵙⵉⴷⵉ ⴷⴻⴳ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ ⵓⵛⴰ ⵉⴳⴳⵯⴻⴷ ⵍⴳⴻⵏⵙ ⵣⵉ ⵙⵉⴷⵉ, ⵓⵛⴰ ⵓⵎⵏⴻⵏ ⵏⵉⵜⵏⵉ ⴷⵉ ⵙⵉⴷⵉ ⵓ ⴷⵉ ⵎⵓⵙⴰ, ⴰⵎⵙⴻⵅⵅⴰⵔ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⵣⴻⵀⵀⴻⴷ ⵎⵓⵙⴰ ⵊⵎⵉⵄ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵣⵀⵉⴷ-ⴰ ⵉ ⵙⵉⴷⵉ, ⵏⵏⴰⵏ: “ⴰⴷ ⵣⴻⵀⵀⴷⴻⵖ ⵉ ⵙⵉⴷⵉ, ⵎⵉⵏⵣⵉ ⵏⴻⵜⵜⴰ ⵢⵓⵄⵍⴰ ⴷⵉ ⵍⵓⵄⵍⴰ! ⴰⵢⵉⵙ ⴷ ⵡⴻⵏⵏⵉ ⵅⴰⵙ ⵢⴻⵏⵢⵉⵏ ⵉⵏⴹⴰⵔ ⵉ-ⵜⴻⵏ ⴷⵉ ⵍⴻⴱⵃⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","ⵙⵉⴷⵉ ⴷ ⵊⵊⴻⵀⴷ ⵉⵏⵓ ⴷ ⴰⵣⴻⵀⵀⴻⴷ ⵉⵏⵓ. ⵏⴻⵜⵜⴰ ⵉⴷⵡⴻⵍ ⴷ ⴰⵙⴻⵏⵊⴻⵎ ⵉⵏⵓ. ⵡⴰ ⴷ ⴰⵔⴻⴱⴱⵉ ⵉⵏⵓ, ⵏⴻⵛⵛ ⴰⴷ ⵜ ⵙⵙⴻⵎⵖⴰⵔⴻⵖ. ⵏⴻⵜⵜⴰ ⴷ ⴰⵔⴻⴱⴱⵉ ⵏ ⴱⴰⴱⴰ, ⵏⴻⵛⵛ ⴰⴷ ⵜ ⵙⵙⵄⵓⴵⴻⵖ! ");
INSERT INTO rift_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","ⵙⵉⴷⵉ ⴷ ⴰⵔⵢⴰⵣ ⵏ ⵓⵎⴻⵏⵖⵉ, ⵙⵉⴷⵉ ⴷ ⵉⵙⴻⵎ ⵏⵏⴻⵙ! ");
INSERT INTO rift_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","ⵉⴽⴰⵔⵔⵓⵜⴻⵏ ⵏ ⴼⵉⵔⵄⵓⵏ ⴷ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵏⴻⵙ ⵉⵏⴹⴰⵔ ⵉ-ⵜⴻⵏ ⴷⵉ ⵍⴻⴱⵃⴰⵔ ⵓ ⴰⵛⴻⵡⵡⴰⵔ ⵏ ⵉⵏⴻⵖⵔⴰⴼⴻⵏ ⵏⵏⴻⵙ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵖⴰⵔⵇⴻⵏ ⴷⵉ ⵍⴻⴱⵃⴰⵔ ⵏ ⵜⴻⵍⴳⴰ. ");
INSERT INTO rift_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","ⴰⵎⴰⵏ ⵉⵀⴻⵡⵍⴻⵏ ⴷⵍⵉⵏ ⵉ-ⵜⴻⵏ. ⴰⵎⴻⵛⵏⴰⵡ ⴰⵥⵔⵓ, ⵀⵡⴰⵏ ⵖⴰⵔ ⵍⴰⴵⴰⵖ. ");
INSERT INTO rift_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","ⴰ ⵙⵉⴷⵉ, ⴰⴼⵓⵙ ⴰⴼⵓⵙⵉ ⵏⵏⴻⵛ ⵉⵜⵜⵡⴰⵄⴻⵣⵣ ⵙ ⵊⵊⴻⵀⴷ, ⴰⴼⵓⵙ ⴰⴼⵓⵙⵉ ⵏⵏⴻⵛ, ⴰ ⵙⵉⴷⵉ, ⴰⵇⴰ ⵉⵍⴱⴻⵣ ⵍⴻⵄⴷⵓ. ");
INSERT INTO rift_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","ⵙ ⵍⴻⵎⵖⴰⵔⴻⵜ ⵏ ⵓⵄⵓⴵⵉ ⵏⵏⴻⵛ ⵜᵉⵜⴻⵃⵃⵉⴷ ⵉⵏⵏⵉ ⴽⵉⴽ ⵉⵜⵜⴻⵎⵄⴰⵍⴰⵏ. ⵎⴰⵍⴰ ⵜⴻⵙⵙⴻⴽⴽⴻⴷ ⵍⵃⴰⴷⵓⵇ ⵏ ⵡⴻⵖⴹⴰⴱ ⵏⵏⴻⵛ, ⴰⴷ ⵜⴻⵏ ⵢⴻⵛⵛ ⵡⴰⵏⵉⵜⴰ ⴰⵎⴻⵛⵏⴰⵡ ⵉⵖⴻⴵ. ");
INSERT INTO rift_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","ⵙ ⵓⵙⵓⴹⵉ ⵏ ⵡⴻⵏⵣⴰⵔⴻⵏ ⵏⵏⴻⵛ ⵄⵓⵔⵔⵛⴻⵏ ⵡⴰⵎⴰⵏ, ⵜⵜⵡⴰⵙⵙⴱⴻⴷⴷⴻⵏ ⵜⵙⴻⴵⵢⴰ ⴰⵎ ⵡⴻⵖⴱⴰⵔ, ⴰⵎⴰⵏ ⵉⵀⴻⵡⵍⴻⵏ ⵊⴻⵎⴷⴻⵏ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏ ⵍⴻⴱⵃⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","ⵉⵏⵏⴰ ⵍⴻⵄⴷⵓ: ‘ⴰⴷ ⵜⴻⵏ ⴰⵔⴻⴷⴼⴻⵖ, ⴰⴷ ⵜⴻⵏ ⵄⴷⵓⵖ, ⴰⴷ ⴱⴹⵉⵖ ⵍⵎⵓⵔ, ⵍⴻⵄⵎⴰⵔ ⵉⵏⵓ ⴰⴷ ⵣⵣⴰⵢⵙⴻⵏ ⵉⵊⵊⵉⵡⴻⵏ, ⴰⴷ ⴷⴷ-ⵊⴻⴱⴷⴻⵖ ⵙⵙⵉⴼ ⵉⵏⵓ, ⴰⴼⵓⵙ ⵉⵏⵓ ⴰⴷ ⵣⵣⴰⵢⵙⴻⵏ ⵉⴽⴽⴻⵙ ⵍⵡⴰⵔⵜ ⵏⵙⴻⵏ.’ ");
INSERT INTO rift_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","ⵜⵙⵓⴹⴻⴷ ⵙ ⵏⵏⴻⴼⵙ ⵏⵏⴻⵛ ⵓⵛⴰ ⵉⴷⴻⵍ ⵉ-ⵜⴻⵏ ⵍⴻⴱⵃⴰⵔ. ⵏⵉⵜⵏⵉ ⵀⵡⴰⵏ-ⴷⴷ ⴰⵎ ⵍⴻⵅⴼⵉⴼ ⴷⴻⴳ ⵡⴰⵎⴰⵏ ⵉⵎⵖⴰⵔⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","ⴰ ⵙⵉⴷⵉ, ⵎⴰⵏ ⵡⴻⵏ ⵉ ⵉⴵⴰⵏ ⴰⵎ ⵛⴻⴽ ⵊⴰⵔ ⵉⵔⴻⴱⴱⵉⵜⴻⵏ? ⵡⵉ ⵉⴵⴰⵏ ⴰⵎ ⵛⴻⴽ, ⴷ ⵡⴻⵏⵏⵉ ⵉⵜⵜⵡⴰⵙⵙⵄⵓⴵⴻⵏ ⴷⵉ ⵜⵇⴻⴷⴷⴰⵙⵜ, ⴰⵎⵡⴻⵇⵇⴰⵔ ⴷⴻⴳ ⵉⵣⵍⴰⵏ ⵏ ⵓⵚⴻⴱⴱⴻⵃ, ⵎⴰⵏ ⵡⴻⵏ ⵉⵜⵜⴻⴳⴳⴻⵏ ⵍⴻⵄⵊⴰⵢⴻⴱ ⴰⵎ ⵛⴻⴽ? ");
INSERT INTO rift_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","ⵜⴻⵙⵙⵡⵉⵥⵥⴹⴻⴷ ⴰⴼⵓⵙ ⴰⴼⵓⵙⵉ ⵏⵏⴻⵛ, ⵜⵙⴰⵔⴹ ⵉ-ⵜⴻⵏ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","ⵛⴻⴽ ⵜⴳⴻⵡⵡⴷⴻⴷ ⵍⴳⴻⵏⵙ-ⴰ ⵙ ⵜⵎⴻⵅⵙⵉⵡⵜ ⵏⵏⴻⵛ ⵉⵛⵓⵡⵡⴰⵔⴻⵏ, ⴰⵇⴰ ⵜⴻⴼⴷⵉⴷ ⵜ, ⵙ ⵊⵊⴻⵀⴷ ⵏⵏⴻⵛ ⵜⵏⴻⴷⵀⴻⴷ ⵜⴻⵏ ⵖⴰⵔ ⵜⵣⴻⴷⴷⵉⵖⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","ⵍⴻⴳⵏⵓⵙ ⵙⵍⵉⵏ ⵅ ⵓⵢⴰ ⵓⵛⴰ ⴰⵔⵊⵉⵊⴻⵏ. ⵜⴻⵟⵟⴻⴼ ⵜⴻⴳⴳⵯⵓⴷⵉ ⴷⴻⴳ ⵉⵎⴻⵣⴷⴰⵖ ⵏ ⴼⵉⵍⵉⵛⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⵎⴻⵇⵇⵔⴰⵏⴻⵏ ⵏ ⵜⵇⴻⴱⴱⴰⵍ ⵏ ⵉⴷⵓⵎ ⵜⵜⴱⴻⵀⵜⴻⵏ, ⵉⵏⵏⵉ ⵖⴰⵔ ⵜⴻⴵⴰ ⵚⵚⵓⵍⵟⴰ ⴷⵉ ⵎⵓ’ⴰⴱ ⵜⵜⴰⵔⵊⵉⵊⴻⵏ, ⵓ ⵎⴰⵔⵔⴰ ⵉⵎⴻⵣⴷⴰⵖ ⵏ ⴽⴻⵏⵄⴰⵏ ⴰⵇⴰ ⴼⴻⵙⵢⴻⵏ! ");
INSERT INTO rift_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","ⵜⴻⵡⴹⴰ ⵅⴰⵙⴻⵏ ⵍⵄⵓⵔⵔⴻⵜ ⴷ ⵜⵉⴳⴳⵯⵓⴷⵉ. ⵙ ⵍⴻⵎⵖⴰⵔⴻⵜ ⵏ ⵓⵖⵉⵍ ⵏⵏⴻⵛ ⵙⴻⵖⴷⴻⵏ ⴰⵎ ⵡⴻⵥⵔⵓ, ⴰⵍⴰⵎⵉ ⵉⵥⵡⴰ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵛ, ⴰ ⵙⵉⴷⵉ, ⴰⵍⴰⵎⵉ ⵉⵥⵡⴰ ⵍⴳⴻⵏⵙ-ⴰ ⵉ ⵜⴽⴻⵙⴱⴻⴷ ⵉ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","ⵛⴻⴽ ⴰⴷ ⵜⴻⵏ ⵜⵏⴻⴷⵀⴻⴷ ⵓⵛⴰ ⴰⴷ ⵜⴻⵏ ⵜⴻⵥⵥⵓⴷ ⵅ ⵡⴻⴷⵔⴰⵔ ⵏ ⵍⵡⴰⵔⵜ ⵏⵏⴻⵛ, ⴰⵎⵛⴰⵏ ⵉ ⵜⴻⴳⴳⵉⴷ ⴷ ⵜⴰⵣⴻⴷⴷⵉⵖⵜ ⵏⵏⴻⵛ, ⴰ ⵙⵉⴷⵉ, ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵉ ⵉⴳⴳⵉⵏ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵏⴻⵛ, ⴰ ⵙⵉⴷⵉ ⵉⵏⵓ. ");
INSERT INTO rift_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","ⵙⵉⴷⵉ ⴰⴷ ⵉⵃⴽⴻⵎ ⵉ ⵍⴻⴱⴷⴰ ⵇⴰⵄ! ");
INSERT INTO rift_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","ⵎⵉⵏⵣⵉ ⴰⵢⵉⵙ ⵏ ⴼⵉⵔⵄⵓⵏ ⵢⵓⴷⴻⴼ ⵖⴰⵔ ⵍⴻⴱⵃⴰⵔ ⵙ ⵉⴽⴰⵔⵔⵓⵜⴻⵏ ⵏⵏⴻⵙ ⴷ ⵉⵎⵏⴰⵢⴻⵏ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⵇⵍⴻⴱ ⵅⴰⵙⴻⵏ ⵙⵉⴷⵉ ⵄⴰⵡⴻⴷ ⴰⵎⴰⵏ ⵏ ⵍⴻⴱⵃⴰⵔ. ⵎⴰⵛⴰ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵥⵡⴰⵏ ⵅ ⵍⴰⵥⴰⵖ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏ ⵍⴻⴱⵃⴰⵔ.” ");
INSERT INTO rift_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","ⵓ ⵎⴰⵔⵢⴰⵎ, ⵜⴰⵏⴰⴱⵉⵜ, ⵓⵍⵜⵎⴰⵙ ⵏ ⵀⴰⵔⵓⵏ, ⵜⴻⴽⵙⵉ ⴰⴵⵓⵏ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏⵏⴻⵙ ⵓ ⵎⴰⵔⵔⴰ ⵜⵉⵎⴻⵟⵟⴰ ⴼⴼⵖⴻⵏⵜ ⴰⵡⴰⵔⵏⵉ ⴰⵙ ⵙ ⵉⴱⴻⵏⴷⵉⵔⴻⵏ ⴷ ⵛⵛⴹⵉⵃ ⵙ ⵏⵏⵓⴱⵜⴰⵜ. ");
INSERT INTO rift_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","ⵅⴻⵏⵏⵉ ⵜⴰⵔⵔⴰ-ⴷⴷ ⵅⴰⵙⴻⵏ ⵎⴰⵔⵢⴰⵎ ⵙⵏⵏⵓⴱⴻⵜ ⵏⵏⴻⵙ: “ⵖⴻⵏⵏⵊⴻⵎ ⵉ ⵙⵉⴷⵉ, ⵎⵉⵏⵣⵉ ⴰⵇⴰ ⵏⴻⵜⵜⴰ ⵢⵓⵄⵍⴰⵏ ⴰⵟⵟⴰⵙ! ⵉⵏⴹⴰⵔ ⴰⵢⵉⵙ ⴰⴽ-ⴷ ⵡⴻⵏⵏⵉ ⵅⴰⵙ ⵢⴻⵏⵢⵉⵏ ⴷⵉ ⵍⴻⴱⵃⴰⵔ.” ");
INSERT INTO rift_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","ⵅⴻⵏⵏⵉ ⵉⵊⵊⴰ ⵎⵓⵙⴰ ⵍⴳⴻⵏⵙ ⵏ ⵉⵙⵔⴰⵉⵍ ⴰⴷ ⵉⴼⵙⵉ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⵉⵏⵏⵉ ⵉⴵⴰⵏ ⵅ ⵜⵎⴰ ⵏ ⵍⴻⴱⵃⴰⵔ ⵏ ⵜⴻⵍⴳⴰ, ⵓⵛⴰ ⵔⵓⵃⴻⵏ ⴷⵉ ⵍⴻⵅⵍⴰ ⵏ ⵛⵓⵔ, ⵓⵢⵓⵔⴻⵏ ⵜⵍⴰⵜⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⴷⵉ ⵍⴻⵅⵍⴰ ⴱⵍⴰ ⴰⴷ ⴰⴼⴻⵏ ⴰⵎⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","ⵓⵛⴰ ⵉⵡⴹⴻⵏ ⵖⴰⵔ ⵎⴰⵔⴰ, ⵎⴰⵛⴰ ⵡⴰⵔ ⵣⴻⵎⵎⴰⵔⴻⵏ ⴰⴷ ⵙⵡⴻⵏ ⴰⵎⴰⵏ ⵏ ⵎⴰⵔⴰ, ⵎⵉⵏⵣⵉ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵎⴻⵔⵣⴰⴳⴻⵏ. ⵅ ⵓⵢⴰ ⴳⴳⵉⵏ ⴰⵙ ⵉ ⵡⴻⵎⵛⴰⵏ ⵏⵏⵉ ‘ⵎⴰⵔⴰ’. ");
INSERT INTO rift_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","ⵉⵏⵏⴻⴷⵇⴻⵎ ⵍⴳⴻⵏⵙ ⵅ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: “ⵎⵉⵏ ⵖⴰ ⵏⵙⵓ?” ");
INSERT INTO rift_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","ⵏⴻⵜⵜⴰ ⵉⵍⴰⵖⴰ ⵉ ⵙⵉⴷⵉ ⵓⵛⴰ ⵙⵉⴷⵉ ⵉⵎⵎⴻⵍ ⴰⵙ ⵉⵊⵊ ⵏ ⵓⴽⴻⵛⵛⵓⴹ ⵓⵛⴰ ⵉⵏⴹⴰⵔ ⵉ-ⵜ ⴷⴰⵅⴻⵍ ⴷⴻⴳ ⵡⴰⵎⴰⵏ ⵓⵛⴰ ⴷⴻⵡⵍⴻⵏ ⵡⴰⵎⴰⵏ ⴷ ⵉⵎⵉⵥⵉⴷⴻⵏ. ⴷⵉⵏ ⵉ ⴷ ⴰⵙ ⵉⴳⴳⴰ ⵉ ⵍⴳⴻⵏⵙ ⵉⵛⵜ ⵏ ⵜⴻⵡⵚⴻⵢⵢⴻⵜ ⴷ ⵉⵛⵜ ⵏ ⵍⴼⴰⵔⵉⴹⴰ ⵓ ⴷⵉⵏⵏⵉ ⵉ-ⵜⴻⵏ ⵉⵇⴻⴵⴻⴱ. ");
INSERT INTO rift_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","ⵉⵏⵏⴰ: “ⵎⴰⵍⴰ ⵜⴻⵙⵍⵉⴷ ⵎⵍⵉⵃ ⵉ ⵡⴰⵡⴰⵍ ⵏ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵛ, ⵜⴻⴳⴳⵉⴷ ⵎⵉⵏ ⵉⴵⴰⵏ ⵏⵉⵛⴰⵏ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵙ, ⴰⴷ ⵜⴻⵙⵍⴻⴷ ⵉ ⵍⵓⵎⴰⵔⴰⵜ ⵏⵏⴻⵙ, ⴰⴷ ⵜⴻⵃⴹⵉⴷ ⵎⴰⵔⵔⴰ ⵜⵉⵡⴻⵚⵚⴰ ⵏⵏⴻⵙ, ⵅⴻⵏⵏⵉ ⵏⴻⵛⵛ ⵡⴰⵔ ⴷ ⴰⵡⴻⵎ-ⴷⴷ ⵙⵙⴻⴽⴽⵉⵖ ⵍⴻⵀⵍⴰⵛ ⵉ ⴷⴷ-ⵙⵙⴻⴽⴽⴻⵖ ⵅ ⵎⵉⵚⵔⴰ, ⵎⵉⵏⵣⵉ ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⴰⵎⴻⵙⴳⴻⵏⴼⵉ ⵏⵏⴻⵛ!” ");
INSERT INTO rift_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⵡⴹⴻⵏ ⵖⴰⵔ ⵉⵍⵉⵎ, ⵎⴰⵏⵉ ⵜⵓⵖⴰ ⵜⴻⵏⵄⴰⵛ ⵏ ⵍⵄⵓⵏⵚⴰⵔⴰⵜ ⵏ ⵡⴰⵎⴰⵏ, ⴷ ⵙⴻⴱⵄⵉⵏ ⵏ ⵜⵛⴻⵊⵊⵓⵔⴰ ⵏ ⵜⵉⵏⵉ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉⵏⵏⵉ ⵣⵣⴰⵜ ⵉ ⵡⴰⵎⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","ⵓⵛⴰ ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⵓⵢⵓⵔⴻⵏ ⵣⵉ ⵉⵍⵉⵎ, ⵓ ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵜⵉⵡⴻⴹ ⵖⴰⵔ ⵍⴻⵅⵍⴰ ⵏ ⵙⵉⵏ ⵉ ⵉⴵⴰⵏ ⵊⴰⵔ ⵉⵍⵉⵎ ⴷ ⵙⵉⵏⴰ. ⵜⵓⵖⴰ ⵎⴰⵏ ⴰⵢⴰ ⴷⴻⴳ ⵡⴰⵙⵙ ⵅⴻⵎⵎⴻⵙⵟⴰⵛ ⵏ ⵓⵢⵓⵔ ⵡⵉⵙⵙ ⵜⵏⴰⵢⴻⵏ ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⴷⴷ-ⴼⴼⵖⴻⵏ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵜⴻⵏⵏⴻⴷⵇⴻⵎ ⵣⵉ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ ⴷⵉ ⵍⴻⵅⵍⴰ. ");
INSERT INTO rift_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","ⵏⵏⴰⵏ ⴰⵙⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ: “ⵎⵍⵉ ⵏⴻⵎⵎⵓⵜ ⵙ ⵓⴼⵓⵙ ⵏ ⵙⵉⴷⵉ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⵓⵎⵉ ⵜⵓⵖⴰ ⵏⴻⵇⵇⵉⵎ ⵖⴰⵔ ⵟⵟⴱⴰⵚⵉ ⵏ ⵡⴻⵢⵙⵓⵎ, ⵏⴻⵛⵛⴰ ⴰⵖⵔⵓⵎ ⴰⵍⴰⵎⵉ ⵏⴻⵊⵊⵉⵡⴻⵏ! ⵎⵉⵏⵣⵉ ⴽⴻⵏⵏⵉⵡ ⵜⴻⵙⵙⵓⴼⴼⵖⴻⵎ ⴰⵏⴻⵖ-ⴷⴷ ⵖⴰⵔ ⵍⴻⵅⵍⴰ-ⵢⴰ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⴻⵏⵖⴻⵎ ⵎⴰⵔⵔⴰ ⴰⴳⵔⴰⵡ ⴰⵢⴰ ⵙ ⵍⴰⵥ.” ");
INSERT INTO rift_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⵅⵣⴰⵔ, ⴰⴷ ⵊⵊⴻⵖ ⴰⵖⵔⵓⵎ ⴰⴷ ⵅⴰⵡⴻⵎ ⴷⴷ-ⵉⵡⴹⴰ ⵣⴻⴳ ⵓⵊⴻⵏⵏⴰ ⴰⵎ ⵡⴻⵏⵥⴰⵔ. ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⴼⴼⴻⵖ ⵍⴳⴻⵏⵙ, ⴰⴷ ⴽⵙⵉⵏ ⵎⵉⵏ ⵃⴷⴰⵊⴻⵏ ⵉ ⵡⴰⵙⵙ ⴷⴻⴳ ⵡⴰⵙⵙ ⵏⵏⵉ, ⵃⵉⵎⴰ ⴰⴷ ⵜⴻⵏ ⵇⴻⴵⴱⴻⵖ, ⵎⴰ ⴳⴳⵓⵔⴻⵏ ⴷⵉ ⵜⵖⵓⵔⵉ ⵏ ⵛⵛⴰⵔⵉⵄⴰ ⵉⵏⵓ, ⵏⵉⵖ ⵍⵍⴰ. ");
INSERT INTO rift_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","ⴰⴷ ⵢⵉⵍⵉ ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⵜⵜⴰ, ⴰⴷ ⵙⵙⵡⴻⵊⴷⴻⵏ ⵎⵉⵏ ⴷⴷ-ⵉⵡⵢⴻⵏ ⵖⴰⵔ ⴷⴰⵅⴻⵍ. ⵎⴰⵏ ⴰⵢⴰ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵙⴻⵇⵇⴰⵔ ⵅ ⵎⵉⵏ ⵖⴰ ⵙⵙⵎⵓⵏⴻⵏ ⴽⵓⵍ ⴰⵙⵙ.” ");
INSERT INTO rift_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ ⵉ ⵎⴰⵔⵔⴰ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ: “ⵖⴰⵔ ⵓⵄⴻⵛⵛⵉ ⴰⴷ ⵜⴻⵙⵙⵏⴻⵎ ⴱⴻⵍⵍⵉ ⵙⵉⴷⵉ ⵉ ⴽⴻⵏⵏⵉⵡ ⴷⴷ-ⵉⵙⵙⵓⴼⴼⵖⴻⵏ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ, ");
INSERT INTO rift_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","ⵓ ⵖⴰⵔ ⵚⵚⴱⴻⵃ ⴰⴷ ⵜⵥⴰⵔⴻⵎ ⴰⵄⵓⴵⵉ ⵏ ⵙⵉⴷⵉ, ⵎⵉⵏⵣⵉ ⴰⵇⴰ ⵏⴻⵜⵜⴰ ⵉⵙⵍⴰ ⴰⵏⴻⴷⵇⴻⵎ ⵏⵡⴻⵎ ⵅ ⵙⵉⴷⵉ. ⵎⴰ ⵏⴻⵛⵛⵉⵏ, ⵎⵉⵏ ⵏⴻⵄⵏⴰ, ⵃⵉⵎⴰ ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⵅⴰⵏⴻⵖ ⵜⴻⵏⵏⴷⴻⵇⵎⴻⵎ?” ");
INSERT INTO rift_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","ⵉⵏⵏⴰ ⵎⵓⵙⴰ: “ⵍⴰⵎⵉ ⴷ ⴰⵡⴻⵎ ⵉⵡⵛⴰ ⵙⵉⴷⵉ ⴰⵢⵙⵓⵎ ⵉ ⵎⴰⵛⵛⴰ ⴷⴻⴳ ⵓⵄⴻⵛⵛⵉ ⵓ ⴰⵖⵔⵓⵎ ⴷⵉ ⵜⵢⴰⵡⴰⵏⵜ ⴷⵉ ⵚⵚⴱⴻⵃ, ⴰⵇⴰ ⵉⵙⵍⴰ ⵙⵉⴷⵉ ⴰⵏⴻⴷⵇⴻⵎ ⵏⵡⴻⵎ ⵉ ⵣⵉ ⵅⴰⵙ ⵜᵉⵜⵜⵏⴻⴷⵇⴰⵎⴻⵎ. ⵉ ⵏⴻⵛⵛⵉⵏ, ⵎⵉⵏ ⵏⴻⵄⵏⴰ? ⴽⴻⵏⵏⵉⵡ ⵡⴰⵔ ⵅⴰⵏⴻⵖ ⵜᵉⵜⵜⵏⴻⴷⵇⴰⵎⴻⵎ, ⵎⴰⵛⴰ ⵅ ⵙⵉⴷⵉ.” ");
INSERT INTO rift_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","ⵉⵏⵏⴰ ⵎⵓⵙⴰ ⵉ ⵀⴰⵔⵓⵏ: “ⵉⵏⵉ ⵉ ⵜⵎⴻⵙⵎⵓⵏⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵎⴰⵔⵔⴰ: ‘ⵔⴻⵃⵃⴳⴻⵎ-ⴷⴷ ⵖⴰⵔ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ, ⵎⵉⵏⵣⵉ ⴰⵇⴰ ⵉⵙⵍⴰ ⵉ ⵓⵏⴻⴷⵇⴻⵎ ⵏⵡⴻⵎ.’” ");
INSERT INTO rift_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","ⴰⵎ ⵉⵙⵙⵉⵡⴻⵍ ⵀⴰⵔⵓⵏ ⴰⴽ-ⴷ ⵜⵎⴻⵙⵎⵓⵏⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵎⴰⵔⵔⴰ, ⵜⵓⵖⴰ ⵅⴻⵣⵣⴰⵔⴻⵏ ⵖⴰⵔ ⵍⴻⵅⵍⴰ ⵓⵛⴰ ⵅⵣⴰⵔ, ⴰⵄⵓⴵⵉ ⵏ ⵙⵉⴷⵉ ⵉⴹⵀⴰⵔ-ⴷⴷ ⴷⴻⴳ ⵓⵙⴻⵢⵏⵓ. ");
INSERT INTO rift_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“ⵏⴻⵛⵛ ⵙⵍⵉⵖ ⵉ ⵓⵏⴻⴷⵇⴻⵎ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ⵙⵉⵡⴻⵍ ⴰⴽⵉⴷⵙⴻⵏ ⵓⵛⴰ ⵉⵏⵉ: ⵊⴰⵔ ⴱⴻⴷⴷⵓ ⵏ ⵡⴻⵣⵢⴻⵏ ⵏ ⵡⴰⵙⵙ ⴰⵍ ⴷⴷ-ⵜⴻⵡⴹⴰ ⵜⵎⴻⴷⴷⵉⵜ ⴰⴷ ⵜⴻⵛⵛⴻⵎ ⴰⵢⵙⵓⵎ, ⵖⴰⵔ ⵚⵚⴱⴻⵃ ⴰⴷ ⵜⴻⵊⵊⵉⵡⵏⴻⵎ ⵙ ⵡⴻⵖⵔⵓⵎ ⵓⵛⴰ ⴰⴷ ⵜⴻⵙⵙⵏⴻⵎ ⴱⴻⵍⵍⵉ ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ.” ");
INSERT INTO rift_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","ⵖⴰⵔ ⵓⵄⴻⵛⵛⵉ ⵓⵍⵢⴻⵏⵜ ⵉ-ⴷⴷ ⵉⵊⴹⴰⴹ ⵇⵇⴰⵔⴻⵏ ⴰⵙ ‘ⵜⵙⴰⵍⵡⴰ’ ⵓⵛⴰ ⴷⵍⵉⵏⵜ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵓ ⵖⴰⵔ ⵚⵚⴱⴻⵃ ⵜⵓⵖⴰ ⵏⵏⴷⴰ ⵉⵏⵏⴻⴹ-ⴷⴷ ⵉ ⵍⵎⴰⵔⴳⴻⵃ. ");
INSERT INTO rift_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","ⵍⴰⵎⵉ ⴷⴷ-ⵉⴳⴻⵄⵄⴻⴷ ⵏⵏⴷⴰ, ⴰⵇⴰ ⴷⴰ, ⵉⵛⵜ ⵏ ⵍⵃⴰⵊⵊⴻⵜ ⴷ ⵜⴰⵣⴷⴰⵜ ⴰⵎ ⵜⴻⵇⵛⵓⵔⵜ, ⴷ ⵜⴰⵣⴷⴰⵜ ⴰⵎ ⵏⵏⴷⴰ ⵉⴳⴰⵔⵙⴻⵏ, ⵜᵉⵜⵜⵡⴰⴼ ⵅ ⵡⵓⴷⴻⵎ ⵏ ⵍⴻⵅⵍⴰ, ⵅ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","ⵥⵔⵉⵏ ⵜⵜ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵏⵏⴰⵏ ⵉⵊⵊⴻⵏ ⵉ ⵡⴻⵏⵏⴻⵖⵏⵉ: “ⵎⴰⵏⴰⵡⵢⴰ?”, ⵎⵉⵏⵣⵉ ⵡⴰⵔ ⵙⵙⵉⵏⴻⵏ ⵎⵉⵏ ⵉⵄⵏⴰ. ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⵏⵏⴰ ⴰⵙⴻⵏ ⵎⵓⵙⴰ: “ⵡⴰ ⴷ ⴰⵖⵔⵓⵎ ⵏⵏⵉ ⴷ ⴰⵡⴻⵎ ⵉⵡⵛⴰ ⵙⵉⴷⵉ, ⵃⵉⵎⴰ ⴰⴷ ⵜⴻⵛⵛⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","ⵡⴰ ⴷ ⴰⵡⴰⵍ ⵉ ⴷ ⴰⵡⴻⵎ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ: ‘ⴻⵊⵊ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵉⴽⵙⵉ ⴽⵓⵍ ⵉⵊⵊ ⵄⵍⴰⵃⵙⴰⴱ ⵎⵉⵏ ⵉⵃⴷⴰⵊ, ⵍⴻⵇⵢⴰⵙ ⵏ ⵉⵊⵊ ⵏ ⵓⵄⵓⵎⵉⵔ, ⵄⵍⴰⵃⴰⵍ ⵜⵏⴰⵢⴻⵏ ⵍⵉⵜⵔⵓ, ⵉ ⵉⵊⵊⴻⵏ ⴱⵏⴰⴷⴻⵎ. ⴽⵓⵍ ⴰⵔⵢⴰⵣ ⴰⴷ ⵉⴽⵙⵉ ⵄⵍⴰⵃⵙⴰⴱ ⵍⵇⴻⴷⴷ ⵏ ⵉⵡⴷⴰⵏ ⵉ ⵖⴰⵔⴻⵙ ⴷⴻⴳ ⵓⵇⵉⴹⵓⵏ.’” ");
INSERT INTO rift_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⴳⴳⵉⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ⵢⵔⵓⵏ ⵣⵣⴰⵢⴻⵙ, ⵉⵊⵊⴻⵏ ⴰⵟⵟⴰⵙ, ⵡⴻⵏⵏⴻⵖⵏⵉ ⴷⵔⵓⵙ. ");
INSERT INTO rift_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","ⵡⴻⵣⵏⴻⵏ ⴰⵢⴰ ⵙ ⵍⴻⵇⵢⴰⵙ ⵏ ⵓⵄⵓⵎⵉⵔ. ⵡⴻⵏⵏⵉ ⵢⵔⵓⵏ ⴰⵟⵟⴰⵙ ⵡⴰⵔ ⵖⴰⵔⴻⵙ ⵣⵣⵢⴰⴷⴰ ⴷ ⵡⴻⵏⵏⵉ ⵢⵔⵓⵏ ⴷⵔⵓⵙ, ⵡⴰⵔ ⴷ ⴰⵙ ⵉⵜⵜⵅⴻⵚⵚⵉ ⵄⴰⴷ. ⴽⵓⵍ ⵉⵊⵊ ⵉⵢⵔⵓ ⵎⴰⵛⵛⴰ ⵏⵏⴻⵙ ⵄⵍⴰⵃⵙⴰⴱ ⵎⵉⵏ ⵉⵃⴷⴰⵊ. ");
INSERT INTO rift_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","ⵉⵏⵏⴰ ⴰⵙⴻⵏ ⵎⵓⵙⴰ: “ⵓⵍⴰ ⴷ ⵉⵊⵊ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵢⴻⵊⵊ ⴰⵍ ⵚⵚⴱⴻⵃ.” ");
INSERT INTO rift_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","ⵎⴰⵛⴰ ⵏⵉⵜⵏⵉ ⵡⴰⵔ ⵙⵍⵉⵏ ⵛⴰ ⵉ ⵎⵓⵙⴰ ⵓ ⵛⴰ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ ⵅⴻⵎⵎⵍⴻⵏ ⵛⴰ ⵣⵣⴰⵢⴻⵙ ⴰⵍ ⵚⵚⴱⴻⵃ. ⵅⴻⵏⵏⵉ ⵓⴷⴼⴻⵏ ⴷⴰⵢⴻⵙ ⵉⴽⴻⵛⵛⴰⵡⴻⵏ ⵓⵛⴰ ⵉⴱⴷⴰ ⴰⴷ ⵉⴳⴳ ⵛⵛⵓⵎ. ⵓⵛⴰ ⵉⴼⴼⵓⴳⴻⵎ ⵅⴰⵙⴻⵏ ⵎⵓⵙⴰ ⴰⵟⵟⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","ⴽⵓⵍ ⵚⵚⴱⴻⵃ ⵢⵔⵓⵏ ⵜ, ⴽⵓⵍ ⵉⵊⵊ ⵄⵍⴰⵃⵙⴰⴱ ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵉⵛⵛ ⵏⴻⵜⵜⴰ, ⵎⵉⵏⵣⵉ ⵎⴰⵍⴰ ⵜⴻⵃⵎⴰ ⵜⴼⵓⵛⵜ, ⵜⵓⵖⴰ ⵉⵜⵜⴼⴻⵙⵙⵉ. ");
INSERT INTO rift_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⵜⵜⴰ ⵢⵔⵓⵏ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵙⴻⵇⵇⴰⵔ ⵏ ⵡⴻⵖⵔⵓⵎ, ⵍⴻⵇⵢⴰⵙ ⵏ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵄⵓⵎⵉⵔⴻⵏ ⵉ ⴽⵓⵍ ⴰⵣⴻⴵⵉⴼ. ⵓⵛⴰ ⵓⵙⵉⵏ-ⴷⴷ ⵎⴰⵔⵔⴰ ⵍⵃⵓⴽⴽⴰⵎ ⵏ ⵜⵎⴻⵙⵎⵓⵏⵜ ⵓⵛⴰ ⵅⴻⴱⴱⴰⵔⴻⵏ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","ⵏⴻⵜⵜⴰ ⵉⵏⵏⴰ ⴰⵙⴻⵏ: “ⴷ ⵎⴰⵏ ⴰⵢⴰ ⵎⵉⵏ ⵅⴻⴼ ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ: ‘ⵜⵉⵡⴻⵛⵛⴰ ⴷ ⵉⵊⵊ ⵏ ⵡⴰⵙⵙ ⵏ ⴰⵔⵔⴰⵃⴻⵜ, ⵉⵊⵊ ⵏ ⵡⴰⵙⵙ ⵏ ⵙⵙⴻⴱⵜ ⴷ ⴰⵎⵇⴻⴷⴷⴰⵙ ⵉ ⵙⵉⴷⵉ. ⵙⴻⵏⴳⵯⴻⵎ ⵎⵉⵏ ⵜⴻⵅⵙⴻⵎ ⴰⴷ ⵜᵉⵙⵙⴻⵏⴳⵯⴻⵎ, ⵙⵏⴻⵏⵏⴰⵎ ⵎⵉⵏ ⵜⴻⵅⵙⴻⵎ ⴰⴷ ⵜᵉⵙⵙⴻⵏⵏⴰⵎ ⵓⵛⴰ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵖⴰ ⵉⵇⵇⵉⵎⴻⵏ, ⵅⴻⵎⵎⵍⴻⵎ ⵜ ⴰⵍ ⵚⵚⴱⴻⵃ.’” ");
INSERT INTO rift_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","ⵏⵉⵜⵏⵉ ⵅⴻⵎⵎⵍⴻⵏ ⵜ ⴰⵍ ⵚⵚⴱⴻⵃ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⴻⵏ ⵢⵓⵎⵓⵔ ⵎⵓⵙⴰ ⵓⵛⴰ ⵡⴰⵔ ⵢⴰⵔⵚⵓⴹ ⵓ ⵡⴰⵔ ⴷⴰⵢⴻⵙ ⵜⵓⵖⵉ ⵜⴽⴻⵛⵛⴰ. ");
INSERT INTO rift_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵎⵓⵙⴰ: “ⵛⵛⴻⵎ ⴰⵢⴰ ⴰⵙⵙ-ⴰ, ⵎⵉⵏⵣⵉ ⴰⵙⵙ-ⴰ ⴷ ⴰⵙⵙ ⵏ ⵙⵙⴻⴱⵜ ⵏ ⵙⵉⴷⵉ. ⴰⵙⵙ-ⴰ ⵡⴰⵔ ⵜ ⵜᵉⵜⵜⵉⴼⴻⵎ ⴷⴻⴳ ⵉⵢⵢⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","ⵙⴻⵜⵜⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⴰⴷ ⵜⴻⵢⵔⵓⵎ, ⵎⴰⵛⴰ ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ ⴰⵇⴰ ⴷ ⵙⵙⴻⴱⵜ, ⵡⴰⵔ ⵉⵜⵜⵉⵍⵉ ⵡⴰⵍⵓ.” ");
INSERT INTO rift_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ ⵉⵎⵙⴰⵔ ⴱⴻⵍⵍⵉ ⴼⴼⵖⴻⵏ ⵛⴰ ⵣⵉ ⵍⴳⴻⵏⵙ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵢⵔⵓⵏ ⵛⴰ, ⵎⴰⵛⴰ ⵡⴰⵔ ⵓⴼⵉⵏ ⵡⴰⵍⵓ. ");
INSERT INTO rift_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⴰⵍ ⵎⴻⵍⵎⵉ ⵜⵓⴳⵉⵎ ⴰⴷ ⵜⴻⵃⴹⴰⵎ ⵍⵓⵎⵓⵔⴰⵜ ⵉⵏⵓ ⴷ ⵉⵣⴻⵔⴼⴰⵏ ⵉⵏⵓ? ");
INSERT INTO rift_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","ⵅⵣⴰⵔⴻⵎ, ⵎⵉⵏⵣⵉ ⵙⵉⴷⵉ ⵉⵡⵛⴰ ⴰⵡⴻⵎ ⴰⵙⵙ ⵏ ⵙⵙⴻⴱⵜ, ⵅ ⵓⵢⴰ ⵉⵡⵛⴰ ⴰⵡⴻⵎ ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⵜⵜⴰ ⴰⵖⵔⵓⵎ ⵉ ⵜⵏⴰⵢⴻⵏ ⵏ ⵡⵓⵙⵙⴰⵏ. ⴽⵓⵍ ⵉⵊⵊ ⵣⵣⴰⵢⵡⴻⵎ ⴰⴷ ⵉⵇⵇⵉⵎ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏⵏⴻⵙ! ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ ⵡⴰⵔ ⴷⴷ-ⵉⵜⵜⴻⴼⴼⵉⵖ ⵓⵍⴰ ⴷ ⵉⵊⵊ ⵣⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏⵏⴻⵙ!” ");
INSERT INTO rift_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","ⵓⵛⴰ ⵢⴰⵔⴻⵢⵢⴻⵃ ⵍⴳⴻⵏⵙ ⴷⴻⴳ ⵡⴰⵙⵙ ⵏ ⵙⵙⴻⴱⵜ. ");
INSERT INTO rift_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵜⵍⴰⵖⴰ ⴰⵙ ‘ⵎⴰⵏⵏⴰ’. ⵜⵓⵖⴰ-ⵜⵜ ⴷ ⵜⴰⵛⴻⵎⵍⴰⵍⵜ ⴰⵎ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏ ⵍⵇⴻⵚⴱⵓⵔ ⵓⵛⴰ ⴰⵍⴻⴷⴷⵉ ⵏⵏⴻⵙ ⴰⵎⴻⵛⵏⴰⵡ ⵜⵉⴼⴹⵉⵔⵉⵏ ⵏ ⵜⴰⵎⵎⴻⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵎⵓⵙⴰ: “ⴷⴷⴻⴳⴳⴰ ⴷ ⴰⵡⴰⵍ ⵉ ⵣⵉ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ: ‘ⵛⵛⵓⵔⴻⵎ ⵣⵣⴰⵢⴻⵙ ⵍⴻⵇⵢⴰⵙ ⵏ ⵢⵉⵊⵊ ⵏ ⵓⵄⵓⵎⵉⵔ ⵓⵛⴰ ⵅⴻⵎⵎⴻⵍ ⵉ-ⵜ ⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵏⵡⴻⵎ ⵉ ⴷⴷ ⵖⴰ ⵢⴰⵙⴻⵏ, ⵃⵉⵎⴰ ⴰⴷ ⵥⴰⵔⴻⵏ ⴰⵖⵔⵓⵎ ⵎⵉⵏ ⵣⵉ ⴽⴻⵏⵏⵉⵡ ⵙⵙⴻⵛⵛⴻⵖ ⴷⵉ ⵍⴻⵅⵍⴰ, ⵓⵎⵉ ⴽⴻⵏⵏⵉⵡ ⵙⵙⵓⴼⴼⵖⴻⵖ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ.” ");
INSERT INTO rift_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","ⵉⵏⵏⴰ ⵎⵓⵙⴰ ⵉ ⵀⴰⵔⵓⵏ: “ⴽⵙⵉ ⵉⵊⵊ ⵏ ⵓⵣⴻⵏⴱⵉⵍ ⵓⵛⴰ ⵄⴻⵎⵎⴰⵔ ⵉ-ⵜ ⵙ ⵢⵉⵊⵊ ⵏ ⵓⵄⵓⵎⵉⵔ ⵏ ‘ⵎⴰⵏⵏⴰ’ ⵓⵛⴰ ⴻⴳⴳ ⵉ-ⵜ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ, ⵃⵉⵎⴰ ⴰⴷ ⵉⵜⵜⵡⴰⵅⴻⵎⵎⴻⵍ ⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵏⵡⴻⵎ.” ");
INSERT INTO rift_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","ⵓⵛⴰ ⵉⴳⴳⴰ ⵉ-ⵜⵜ ⵀⴰⵔⵓⵏ ⵣⵣⴰⵜ ⵉ ⵛⵛⵀⴰⴷⴻⵜ, ⵃⵉⵎⴰ ⴰⴷ ⵜᵉⵜⵜⵡⴰⵅⴻⵎⵎⴻⵍ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵙ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","ⴰⵎⵎⵓ ⵉ ⵛⵛⵉⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ‘ⵎⴰⵏⵏⴰ’ ⴰⵔⴻⴱⵄⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⴰⵍⴰⵎⵉ ⵉⵡⴹⴻⵏ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵎⴰⵏⵉ ⵖⴰ ⵔⴰⵃⴻⵏ ⴰⴷ ⵣⴻⴷⵖⴻⵏ. ⵛⵛⵉⵏ ⵎⴰⵏⵏⴰ ⴰⵍⴰⵎⵉ ⵉⵡⴹⴻⵏ ⵖⴰⵔ ⵡⴻⵢⵎⵉⵔ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","ⵉⵊⵊ ⵏ ⵓⵄⵓⵎⵉⵔ ⴷ ⵄⴻⵛⵔⴰ ⴷⵉ ⵜⴻⵙⵖⴰⵔⵜ ⵏ ⵉⵊⵊ ⵏ ⵉⴼⴰ. ");
INSERT INTO rift_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","ⵓⵛⴰ ⴼⴻⵙⵢⴻⵏ ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⵓⵢⵓⵔⴻⵏ ⵣⵉ ⵍⴻⵅⵍⴰ ⵏ ⵙⵉⵏ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵙⴻⵏ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⵔⴰⴼⵉⴷⵉⵎ. ⵡⴰⵔ ⴷⵉⵏ ⵜⵓⵖⵉ ⴰⵎⴰⵏ, ⵃⵉⵎⴰ ⴰⴷ ⵉⵙⵙⵓ ⵍⴳⴻⵏⵙ. ");
INSERT INTO rift_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","ⵅⴻⵏⵏⵉ ⵉⵎⵛⵓⴱⴱⴻⵛ ⵍⴳⴻⵏⵙ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵏⵉⵜⵏⵉ ⵏⵏⴰⵏ: “ⴻⵡⵛ ⴰⵏⴻⵖ ⴰⵎⴰⵏ, ⵃⵉⵎⴰ ⴰⴷ ⵏⵙⵓ!” ⵎⵓⵙⴰ ⵉⵏⵏⴰ ⴰⵙⴻⵏ: “ⵎⴰⵢⴻⵎⵎⵉ ⵜᵉⵜⵜⴻⵅⵙⴻⵎ ⴰⴷ ⴽⵉⴷⵉ ⵜⴻⵎⵛⵓⴱⴱⵓⵛⴻⵎ? ⵎⴰⵢⴻⵎⵎⵉ ⵜᵉⵜⵜⵇⴻⴵⴰⴱⴻⵎ ⵙⵉⴷⵉ?” ");
INSERT INTO rift_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","ⵜⵓⵖⴰ ⵍⴳⴻⵏⵙ ⵉⴼⴼⵓⴷ ⴰⵟⵟⴰⵙ ⵖⴰⵔ ⵡⴰⵎⴰⵏ ⵓⵛⴰ ⵏⵏⴷⴻⵇⵎⴻⵏ ⵣⵉ ⵎⵓⵙⴰ, ⵏⵏⴰⵏ: “ⵎⴰⵖⴰⵔ ⴷ ⴰⵏⴻⵖ ⵜⴻⵙⵙⴳⴻⵄⵄⴷⴻⴷ ⵣⵉ ⵎⵉⵚⵔⴰ? ⵎⴰ ⵃⵉⵎⴰ ⴰⴷ ⴰⵢⵉ ⵜⵀⴻⵍⵍⴽⴻⴷ ⵙ ⵓⴼⴰⴷⵉ ⵓⵍⴰ ⴷ ⵜⴰⵔⵡⴰ ⵉⵏⵓ ⴷ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵉⵏⵓ?” ");
INSERT INTO rift_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⵙⵖⵓⵢ ⵎⵓⵙⴰ ⵖⴰⵔ ⵙⵉⴷⵉ, ⵉⵏⵏⴰ: “ⵎⵉⵏ ⵖⴰ ⴳⴳⴻⵖ ⴰⴽ-ⴷ ⵍⴳⴻⵏⵙ-ⴰ? ⵎⵖⵉⵔ ⵛⵡⴰⵢⵜ ⵓⵛⴰ ⴰⴷ ⴰⵢⵉ ⴰⵔⴻⵊⵎⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⴻⴽⴽ ⵣⵣⴰⵜ ⵉ ⵍⴳⴻⵏⵙ ⵓⵛⴰ ⴽⵙⵉ ⴰⴽⵉⴷⴻⴽ ⵛⴰ ⵣⴻⴳ ⵉⵎⵖⴰⵔⴻⵏ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵛⴰ ⴽⵙⵉ ⵄⴰⵡⴻⴷ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏⵏⴻⵛ ⵜⴰⵖⵖⴰⵔⵛⵜ ⵏⵏⵉ ⵣⵉ ⵜⴻⵡⵜⵉⴷ ⵉⵖⵣⴰⵔ ⵓⵛⴰ ⵔⵓⵃ. ");
INSERT INTO rift_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","ⵅⵣⴰⵔ, ⵏⴻⵛⵛ ⴰⴷ ⴱⴻⴷⴷⴻⵖ ⴷⵉⵏ ⵣⵣⴰⵜⴻⴽ ⵅ ⵜⴻⵚⴹⴰⵔⵜ ⵖⴰⵔ ⵃⵓⵔⵉⴱ, ⴰⴷ ⵜⴻⵡⵜⴻⴷ ⵜⴰⵚⴹⴰⵔⵜ, ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⴷⴷ-ⴼⴼⵖⴻⵏ ⵡⴰⵎⴰⵏ ⵓⵛⴰ ⴰⴷ ⵉⵙⵙⵓ ⵍⴳⴻⵏⵙ.” ⵉⴳⴳⴰ ⵎⵓⵙⴰ ⴰⵎⴻⵏⵏⵉ ⵣⵣⴰⵜ ⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵉⵎⵖⴰⵔⴻⵏ ⵏ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","ⵓⵛⴰ ⵉⵍⴰⵖⴰ ⵉⵙⴻⵎ ⵏ ⵡⴻⵎⵛⴰⵏ ⵏⵏⵉ ⵎⴰⵙⵙⴰ ⴷ ⵎⴰⵔⵉⴱⴰ, ⵎⵉⵏⵣⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵎⵎⵛⵓⴱⴱⵛⴻⵏ ⴷⵉⵏ ⵓ ⵎⵉⵏⵣⵉ ⵏⵉⵜⵏⵉ ⵇⴻⴵⴱⴻⵏ ⵙⵉⴷⵉ, ⵏⵏⴰⵏ: “ⵎⴰ ⵙⵉⴷⵉ ⴰⵇⴰ-ⵜ ⵍⴻⵅⵅⵓ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏⵏⴻⵖ ⵏⵉⵖ ⵍⵍⴰ?” ");
INSERT INTO rift_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","ⵅⴻⵏⵏⵉ ⵢⵓⵙⴰ-ⴷⴷ ⵄⴰⵎⴰⵍⵉⵇ ⵓⵛⴰ ⵉⵎⵎⵏⴻⵖ ⴰⴽ-ⴷ ⵉⵙⵔⴰⵉⵍ ⴷⵉ ⵔⴰⴼⵉⴷⵉⵎ. ");
INSERT INTO rift_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","ⵉⵏⵏⴰ ⵎⵓⵙⴰ ⵉ ⵢⴰⵛⵓⵡⴰ: “ⴻⵊⵊ ⴰⵏⴻⵖ ⴰⴷ ⵏⵉⵅⴹⴰⵔ ⵉⵔⵢⴰⵣⴻⵏ ⵓⵛⴰ ⴰⴷ ⵏⴻⴼⴼⴻⵖ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵏⴻⵎⵎⵏⴻⵖ ⴰⴽ-ⴷ ⵄⴰⵎⴰⵍⵉⵇ. ⵜⵉⵡⴻⵛⵛⴰ ⴰⴷ ⴱⴻⴷⴷⴻⵖ ⵙⴻⵏⵏⴻⵊ ⵅ ⵜⵇⵉⵛⵛⴰⵜ ⵏ ⵜⴻⵡⵔⵉⵔⵜ ⵓⵛⴰ ⵜⴰⵖⵖⴰⵔⵛⵜ ⵏ ⴰⵔⴻⴱⴱⵉ ⴰⴷ ⵜⵉⵍⵉ ⴷⴻⴳ ⵓⴼⵓⵙ ⵉⵏⵓ.” ");
INSERT INTO rift_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","ⵉⴳⴳⴰ ⵢⴰⵛⵓⵡⴰ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵙ ⵉⵏⵏⴰ ⵎⵓⵙⴰ, ⵉⵎⵎⵏⴻⵖ ⴰⴽ-ⴷ ⵄⴰⵎⴰⵍⵉⵇ, ⵎⴰⵛⴰ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ ⴷ ⵃⵓⵔ ⵓⵍⵢⴻⵏ ⵖⴰⵔ ⵜⵇⵉⵛⵛⴰⵜ ⵏ ⵜⴻⵡⵔⵉⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","ⵓⵛⴰ ⵉⵎⵙⴰⵔ ⵍⴰⵎⵉ ⵉⵙⵙⴳⴻⵄⵄⴻⴷ ⵎⵓⵙⴰ ⴰⴼⵓⵙ ⵏⵏⴻⵙ, ⵍⴻⵅⴷⴻⵏⵏⵉ ⵜⵓⵖⴰ ⵉⵙⵔⴰⵉⵍ ⵜⵖⴻⴵⴻⴱ, ⵎⴰⵛⴰ ⵅⵎⵉ ⵉⵜⵜⴻⵊⵊⴰ ⴰⴼⵓⵙ ⵏⵏⴻⵙ ⴰⴷ ⵉⵀⵡⴰ, ⵍⴻⵅⴷⴻⵏⵏⵉ ⵖⴻⴵⴱⴻⵏ ⴰⵢⵜ ⵏ ⵄⴰⵎⴰⵍⵉⵇ. ");
INSERT INTO rift_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","ⵉⴼⴰⵙⵙⴻⵏ ⵏ ⵎⵓⵙⴰ ⴷⴻⵡⵍⴻⵏ ⴷⴷⴻⵇⵍⴻⵏ. ⵅⴻⵏⵏⵉ ⴽⵙⵉⵏ ⵉⵊⵊ ⵏ ⵡⴻⵥⵔⵓ ⵓⵛⴰ ⴳⴳⵉⵏ ⵜ ⵙⴰⴷⵓ ⵎⵓⵙⴰ ⵓⵛⴰ ⵉⵇⵇⵉⵎ ⵅⴰⵙ ⵓⵛⴰ ⵀⴰⵔⵓⵏ ⴷ ⵃⵓⵔ ⵙⴻⵏⵏⴷⴻⵏ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵏⴻⵙ, ⵉⵊⵊ ⵣⴻⴳ ⵓⵖⴻⵣⴷⵉⵙ-ⴰ, ⵡⴻⵏⵏⴻⵖⵏⵉ ⵣⴻⴳ ⵓⵖⴻⵣⴷⵉⵙ ⵏⵏⴻⵖⵏⵉ. ⴰⵎⵎⵓ ⵉ ⵉⵇⵇⵉⵎⴻⵏ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵏⴻⵙ ⴳⴻⵄⵄⴷⴻⵏ ⴰⵍⴰⵎⵉ ⵜⴻⵖⵍⵉ ⵜⴼⵓⵛⵜ. ");
INSERT INTO rift_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","ⵓⵛⴰ ⵉⵖⵍⴻⴱ ⵢⴰⵛⵓⵡⴰ ⵅ ⵄⴰⵎⴰⵍⵉⵇ ⴷ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ ⵙ ⵍⴻⵇⴹⴻⵄ ⵏ ⵙⵙⵉⴼ. ");
INSERT INTO rift_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⴰⵔⵉ ⴰⵢⴰ ⴷⴻⴳ ⵉⵊⵊ ⵏ ⵡⴻⴷⵍⵉⵙ ⵉⵜⵜⵡⴰⵏⵏⴹⴻⵏ ⵉ ⵍⵉⴷⴰⵔⴻⵜ ⴷⴰⵢⴻⵙ ⵓⵛⴰ ⴻⴳⴳ ⵉ-ⵜ ⴷⴻⴳ ⵉⵎⴻⵊⵊⴰⵏ ⵏ ⵢⴰⵛⵓⵡⴰ, ⴱⴻⵍⵍⵉ ⴰⵇⴰ ⵏⴻⵛⵛ ⴰⴷ ⵎⵃⵉⵖ ⵇⴰⵄ ⵍⵉⴷⴰⵔⴻⵜ ⴷⵉ ⵄⴰⵎⴰⵍⵉⵇ ⵙⴰⴷⵓ ⵓⵊⴻⵏⵏⴰ.” ");
INSERT INTO rift_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","ⵉⴱⵏⴰ ⵎⵓⵙⴰ ⵉⵊⵊ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ⵓⵛⴰ ⵉⵍⴰⵖⴰ ⴰⵙ ⵙ ⵢⵉⵙⴻⵎ: “ⵙⵉⴷⵉ ⴷ ⵜⴰⵄⴻⴵⴰⵏⵜ ⵉⵏⵓ!” ");
INSERT INTO rift_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","ⵓⵛⴰ ⵉⵏⵏⴰ: “ⴰⴼⵓⵙ ⵜⵓⵖⴰ ⵅ ⵍⵄⴰⵔⵛ ⵏ ⵙⵉⴷⵉ. ⵙⵉⴷⵉ ⴰⴷ ⵢⴻⴳⴳ ⴳⴰⵔⵔⴰ ⵅ ⵄⴰⵎⴰⵍⵉⵇ ⵣⵉ ⵊⵊⵉⵍ ⴰⵍ ⵊⵊⵉⵍ.” ");
INSERT INTO rift_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","ⵉⵙⵍⴰ ⵢⵉⵜⵔⵓⵏ, ⴰⴽⴻⵀⵀⴰⵏ ⵏ ⵎⵉⴷⵢⴰⵏ, ⴰⴹⴻⴳⴳⵯⴰⵍ ⵏ ⵎⵓⵙⴰ, ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⴳⴳⴰ ⴰⵔⴻⴱⴱⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ ⵓ ⴰⴽ-ⴷ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ ⵉⵙⵔⴰⵉⵍ, ⴰⵇⴰ ⵉⵙⵙⵓⴼⴼⴻⵖ-ⴷⴷ ⵙⵉⴷⵉ ⵉⵙⵔⴰⵉⵍ ⵣⵉ ⵎⵉⵚⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","ⵉⵟⵟⴻⴼ ⵢⵉⵜⵔⵓⵏ, ⴰⴹⴻⴳⴳⵯⴰⵍ ⵏ ⵎⵓⵙⴰ, ⵚⴰⴼⴼⵓⵔⴰ, ⵜⴰⵎⵖⴰⵔⵜ ⵏ ⵎⵓⵙⴰ, ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⴷ ⴰⵙ ⵉⵡⵛⴰ ⵜⵉⵔⵣⵉⴼⵉⵏ ⵏⵏⴻⵙ ⵏ ⵜⴻⵙⵍⵉⵜ, ");
INSERT INTO rift_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","ⵓⵍⴰ ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ, ⵉⵊⵊⴻⵏ ⵇⵇⴰⵔⴻⵏ ⴰⵙ ⵊⴰⵔⵛⵓⵎ, ⵎⵉⵏⵣⵉ ⵜⵓⵖⴰ ⵉⵏⵏⴰ: “ⵜⵓⵖⴰ ⴰⵢⵉ ⴷ ⴰⴱⴰⵔⵔⴰⵏⵉ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⴷ ⵜⴰⴱⴰⵔⵔⴰⵏⴻⵛⵜ!”, ");
INSERT INTO rift_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","ⵓ ⵡⴻⵏⵏⴻⵖⵏⵉ ⵇⵇⴰⵔⴻⵏ ⴰⵙ ⴰⵍⵉⵄⴰⵣⵉⵔ, ⵎⵉⵏⵣⵉ ⵜⵓⵖⴰ ⵉⵏⵏⴰ: “ⴰⵔⴻⴱⴱⵉ ⵏ ⴱⴰⴱⴰ ⵉⵄⴰⵡⴻⵏ ⴰⵢⵉ ⵓⵛⴰ ⵉⴼⴻⴽⴽ ⴰⵢⵉ ⵣⵉ ⵙⵙⵉⴼ ⵏ ⴼⵉⵔⵄⵓⵏ.” ");
INSERT INTO rift_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","ⵢⵉⵜⵔⵓⵏ ⴰⴹⴻⴳⴳⵯⴰⵍ ⵏ ⵎⵓⵙⴰ, ⴰⴽ-ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ ⴷ ⵜⵎⴻⵟⵟⵓⵜ ⵏⵏⴻⵙ, ⵉⵡⴹⴻⵏ ⵖⴰⵔ ⵎⵓⵙⴰ ⴷⵉ ⵍⴻⵅⵍⴰ, ⵖⴰⵔ ⵎⴰⵏⵉ ⵉⵡⵜⴰ ⵉⵇⵉⴹⴰⵏ, ⵖⴰⵔ ⵡⴻⴷⵔⴰⵔ ⵏ ⴰⵔⴻⴱⴱⵉ. ");
INSERT INTO rift_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵉⵊⵊⴰ ⴰⴷ ⵉⵏⵉⵏ ⵉ ⵎⵓⵙⴰ: “ⵏⴻⵛⵛ, ⴰⴹⴻⴳⴳⵯⴰⵍ ⵏⵏⴻⵛ ⵢⵉⵜⵔⵓⵏ, ⵓⵙⵉⵖ-ⴷⴷ ⵖⴰⵔⴻⴽ ⵙ ⵜⴻⵎⵖⴰⵔⵜ ⵏⵏⴻⵛ ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ ⴰⴽⵉⴷⴻⵙ.” ");
INSERT INTO rift_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","ⵅⴻⵏⵏⵉ ⵉⴼⴼⴻⵖ ⵎⵓⵙⴰ ⴰⴷ ⵉⵍⵇⴰ ⴰⴹⴻⴳⴳⵯⴰⵍ ⵏⵏⴻⵙ, ⵉⴱⴻⵏⴷⴻⵇ ⵓⵛⴰ ⵉⵙⵙⵓⴷⴻⵎ ⵉ-ⵜ. ⵉⵊⵊⴻⵏ ⵉⵙⵙⴻⵇⵙⴰ ⵡⴻⵏⵏⴻⵖⵏⵉ ⵅ ⵓⵎⴻⴷⴷⵓⵔ ⵏⵏⴻⵙ ⵓⵛⴰ ⵓⴷⴼⴻⵏ ⵖⴰⵔ ⵓⵇⵉⴹⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","ⵎⵓⵙⴰ ⵉⵃⴰⵊⴰ ⵉ ⵓⴹⴻⴳⴳⵯⴰⵍ ⵏⵏⴻⵙ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⴳⴳⴰ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⴼⵉⵔⵄⵓⵏ ⵓ ⴰⴽ-ⴷ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓ ⵅ ⵎⴰⵔⵔⴰ ⵜⴰⵎⴰⵔⴰ ⵏⵏⵉ ⵅⴰⵙⴻⵏ ⵉⴽⴽⵉⵏ ⴷⴻⴳ ⵡⴻⴱⵔⵉⴷ ⴷ ⵎⴰⵎⵎⴻⵛ ⵜⴻⵏ ⵉⴼⴻⴽⴽ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","ⵉⴼⴰⵔⵃ ⵢⵉⵜⵔⵓⵏ ⵣⵉ ⵎⴰⵔⵔⴰ ⵍⵅⵉⵔ ⵏⵏⵉ ⵉⴳⴳⴰ ⵙⵉⴷⵉ ⵉ ⵉⵙⵔⴰⵉⵍ, ⵓⵎⵉ ⵜ ⵉⴼⴻⴽⴽ ⵣⴻⴳ ⵓⴼⵓⵙ ⵏ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","ⵉⵏⵏⴰ ⵢⵉⵜⵔⵓⵏ: “ⴰⴷ ⵉⵜⵜⵡⴰⴱⴰⵔⴻⴽ ⵙⵉⴷⵉ ⴷ ⵡⴻⵏⵏⵉ ⴽⴻⵏⵏⵉⵡ ⵉⴼⴻⴽⴽⴻⵏ ⵣⴻⴳ ⵓⴼⵓⵙ ⵏ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ ⵓ ⵣⴻⴳ ⵓⴼⵓⵙ ⵏ ⴼⵉⵔⵄⵓⵏ, ⴷ ⵡⴻⵏⵏⵉ ⵉⴼⴻⴽⴽⴻⵏ ⵍⴳⴻⵏⵙ ⵣⴻⴳ ⵓⴼⵓⵙ ⵏ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ! ");
INSERT INTO rift_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","ⵍⴻⵅⵅⵓ ⵙⵙⵏⴻⵖ ⴱⴻⵍⵍⵉ ⵙⵉⴷⵉ ⵉⵎⵖⴰⵔ ⴰⵟⵟⴰⵙ ⵅ ⵎⴰⵔⵔⴰ ⵉⵔⴻⴱⴱⵉⵜⴻⵏ, ⴰⵇⴰ ⴷⵉ ⵜⵎⴻⵙⵍⴰⵛⵜ ⵏⵏⵉ ⴷⴻⵙⵙⴰⵔⴻⵏ ⵅⴰⵙⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","ⵅⴻⵏⵏⵉ ⵉⴽⵙⵉ ⵢⵉⵜⵔⵓⵏ, ⴰⴹⴻⴳⴳⵯⴰⵍ ⵏ ⵎⵓⵙⴰ, ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⴷ ⵜⵉⵖⴰⵔⵚⴰ ⵉ ⴰⵔⴻⴱⴱⵉ ⵓⵛⴰ ⵢⵓⵙⴰ-ⴷⴷ ⵀⴰⵔⵓⵏ ⵊⵎⵉⵄ ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⵉⵎⵖⴰⵔⴻⵏ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵢⴻⵛⵛ ⴰⵖⵔⵓⵎ ⵊⵎⵉⵄ ⴰⴽ-ⴷ ⵓⴹⴻⴳⴳⵯⴰⵍ ⵏ ⵎⵓⵙⴰ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⴰⵔⴻⴱⴱⵉ. ");
INSERT INTO rift_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","ⵜⵉⵡⴻⵛⵛⴰ ⵏⵏⴻⵙ ⵜⵓⵖⴰ ⵎⵓⵙⴰ ⵉⵜⵜⵖⵉⵎⴰ ⵅ ⵍⴽⵓⵔⵙⵉ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⵃⴽⴻⵎ ⵍⴳⴻⵏⵙ. ⵜⵓⵖⴰ ⵍⴳⴻⵏⵙ ⵉⴱⴻⴷⴷ ⵣⵣⴰⵜ ⵉ ⵎⵓⵙⴰ ⵣⵉ ⵚⵚⴱⴻⵃ ⵣⵉⵛ ⴰⵍ ⴵⵉⵍⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","ⵉⵥⵔⴰ ⵓⴹⴻⴳⴳⵯⴰⵍ ⵏ ⵎⵓⵙⴰ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵜⵓⵖⴰ ⵉⵜⵜⴻⴳⴳ ⵎⵓⵙⴰ ⵉ ⵍⴳⴻⵏⵙ, ⵉⵏⵏⴰ: “ⵎⴰⵏⴰⵡⴰⵢⴰ ⵉ ⵜⴻⴳⴳⵉⴷ ⵛⴻⴽ ⵉ ⵍⴳⴻⵏⵙ? ⵎⴰⵢⴻⵎⵎⵉ ⵜᵉⵜⵜⵖⵉⵎⵉⴷ ⵛⴻⴽ ⵡⴻⵃⵃⴷⴻⴽ ⵓ ⵎⴰⵔⵔⴰ ⵍⴳⴻⵏⵙ ⵉⴱⴻⴷⴷ ⵣⵣⴰⵜⴻⴽ ⵣⵉ ⵚⵚⴱⴻⵃ ⵣⵉⵛ ⴰⵍ ⴵⵉⵍⴻⵜ?” ");
INSERT INTO rift_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","ⵢⴰⵔⵔⴰ-ⴷⴷ ⵎⵓⵙⴰ ⵅ ⵓⴹⴻⴳⴳⵯⴰⵍ ⵏⵏⴻⵙ: “ⵎⵉⵏⵣⵉ ⵍⴳⴻⵏⵙ ⵉⵜⵜⴰⵙ-ⴷⴷ ⵖⴰⵔⵉ ⵃⵉⵎⴰ ⴰⴷ ⵉⵜⵜⴰⵔ ⵛⵛⵡⴰⵔ ⵏ ⴰⵔⴻⴱⴱⵉ. ");
INSERT INTO rift_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","ⵅ ⵎⵉⵏⵏⵉ ⵖⴰⵔⵙⴻⵏ ⵜᵉⵜⵜⵉⵍⵉ ⵛⴰ ⵏ ⵜⵎⴻⵙⵍⴰⵛⵜ, ⵜⵜⴰⵙⴻⵏ-ⴷⴷ ⵖⴰⵔⵉ ⵙ ⵎⴰⵏ ⴰⵢⴰ ⵓⵛⴰ ⵏⴻⵛⵛ ⴰⴷ ⵛⴰⵔⵔⵄⴻⵖ ⵊⴰⵔ ⵉⵊⵊ ⴷ ⵡⴻⵏⵏⴻⵖⵏⵉ, ⵙⵙⴻⵛⴰⵏⴻⵖ ⴰⵙⴻⵏ ⵜⵉⵡⴻⵚⵚⴰ ⴷ ⵉⵣⴻⵔⴼⴰⵏ ⵏ ⴰⵔⴻⴱⴱⵉ.” ");
INSERT INTO rift_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⵏⵏⴰ ⴰⵙ ⵓⴹⴻⴳⴳⵯⴰⵍ ⵏ ⵎⵓⵙⴰ: “ⵎⵉⵏ ⵜⴻⴳⴳⵉⴷ ⵡⴰⵔ ⵉⴵⵉ ⵛⴰ ⵎⵍⵉⵃ. ");
INSERT INTO rift_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵜⴰⵃⵍⴻⴷ ⴰⵟⵟⴰⵙ, ⵛⴻⴽ ⴷ ⵍⴳⴻⵏⵙ-ⴰ ⵉ ⴽⵉⴽ ⵉⴵⴰⵏ, ⵎⵉⵏⵣⵉ ⵎⴰⵏ ⴰⵢⴰ ⵉⴷⵇⴻⵍ ⵅⴰⴽ ⴰⵟⵟⴰⵙ, ⵡⴰⵔ ⴷ ⴰⵙ ⵜⵣⴻⵎⵎⴰⵔⴻⴷ ⴰⴷ ⵜ ⵜⴻⴳⴳⴻⴷ ⵡⴻⵃⵃⴷⴻⴽ. ");
INSERT INTO rift_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","ⵙⴻⵍ ⵍⴻⵅⵅⵓ ⵉ ⵡⴰⵡⴰⵍ ⵉⵏⵓ, ⵏⴻⵛⵛ ⴰⴷ ⵛⴻⴽ ⵏⴻⵚⵃⴻⵖ ⵓⵛⴰ ⴰⵔⴻⴱⴱⵉ ⴰⴷ ⴽⵉⴽ ⵢⵉⵍⵉ. ⵉⵍⵉ ⵛⴻⴽ ⴷ ⴰⵡⴻⵚⵚⴰⵢ ⵅ ⵍⴳⴻⵏⵙ ⵣⵣⴰⵜ ⵉ ⴰⵔⴻⴱⴱⵉ ⵓⵛⴰ ⵇⴻⴷⴷⴻⵎ ⴷⴷⵄⴰⵡⵉ ⵣⵣⴰⵜ ⵉ ⴰⵔⴻⴱⴱⵉ. ");
INSERT INTO rift_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","ⵙⵛⴻⵏ ⴰⵙⴻⵏ ⵜⵉⵡⴻⵚⵚⴰ ⴷ ⵉⵣⴻⵔⴼⴰⵏ ⵓⵛⴰ ⵙⵛⴻⵏ ⴰⵙⴻⵏ ⴰⴱⵔⵉⴷ ⵉ ⵜⴻⵏ ⵉⵜⵜⵅⴻⵚⵚⴰⵏ ⴰⴷ ⵓⵢⵓⵔⴻⵏ ⵓ ⵍⵅⴻⴷⵎⴻⵜ ⵉ ⴷ ⴰⵙⴻⵏ ⵉⵜⵜⵅⴻⵚⵚⴰⵏ ⴰⴷ ⵜⵜ ⴳⴳⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","ⵄⴰⵡⴻⴷ ⵅⵣⴰⵔ ⵛⴻⴽ, ⴰⴷ ⵜⴰⵔⵣⵓⴷ ⵊⴰⵔ ⵎⴰⵔⵔⴰ ⵍⴳⴻⵏⵙ ⵅ ⵉⵔⵢⴰⵣⴻⵏ ⵉⵣⴻⵄⵄⴰⵎⴻⵏ, ⵉⵏⵏⵉ ⵉⵜⵜⴻⴳⴳⵯⴻⴷⴻⵏ ⴰⵔⴻⴱⴱⵉ, ⵉⵔⵢⴰⵣⴻⵏ ⵉⵚⴷⵉⵇⴻⵏ, ⵉⵏⵏⵉ ⵉⵛⴰⵔⵔⵀⴻⵏ ⵜⴰⵔⴻⵣⵣⵓⵜ ⵅ ⴰⵔⴱⴻⵃ. ⴻⴳⴳ ⵉ-ⵜⴻⵏ ⴷ ⵉⵎⴻⵇⵇⵔⴰⵏⴻⵏ ⵅ ⵡⴰⵍⴻⴼ, ⴷ ⵉⵎⴻⵇⵇⵔⴰⵏⴻⵏ ⵅ ⵎⵢⴰ, ⴷ ⵉⵎⴻⵇⵇⵔⴰⵏⴻⵏ ⵅ ⵅⴻⵎⵙⵉⵏ ⴷ ⵉⵎⴻⵇⵇⵔⴰⵏⴻⵏ ⵅ ⵄⴻⵛⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","ⴻⵊⵊ ⵉ-ⵜⴻⵏ ⴰⴷ ⵛⴰⵔⵔⵄⴻⵏ ⵊⴰⵔ ⵍⴳⴻⵏⵙ ⵍⴻⴱⴷⴰ. ⴻⵊⵊ ⵉ-ⵜⴻⵏ ⴰⴷ ⵇⴻⴷⴷⵎⴻⵏ ⵎⴰⵔⵔⴰ ⴷⴷⵄⴰⵡⵉ ⵉⵡⵄⴰⵔⴻⵏ ⵣⵣⴰⵜⴻⴽ, ⵎⴰⵛⴰ ⵎⴰⵔⵔⴰ ⴷⴷⵄⴰⵡⵉ ⵜⵉⵎⴻⵥⵢⴰⵏⵉⵏ ⴰⴷ ⵅⴰⵙⴻⵏⵜ ⵛⴰⵔⵔⵄⴻⵏ ⵙ ⵢⵉⵅⴻⴼ ⵏⵙⴻⵏ. ⴻⴳⴳ ⵉ-ⵜ ⵜⴻⴼⵙⵓⵙ ⵅ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵛ ⵓⵛⴰ ⴻⵊⵊ ⵉ-ⵜⴻⵏ ⴰⴷ ⵜⵜ ⴰⵔⴱⵓⵏ ⴰⴽⵉⴷⴻⴽ. ");
INSERT INTO rift_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","ⵎⴰⵍⴰ ⵜⴻⴳⴳⵉⴷ ⴰⵢⴰ, ⵓ ⴰⵔⴻⴱⴱⵉ ⵉ ⵛⴻⴽ ⵢⵓⵎⵓⵔⴻⵏ, ⵜⵣⴻⵎⵎⴰⵔⴻⴷ ⴰⴷ ⵜⴻⵇⵇⵉⵎⴻⴷ ⵜⴱⴻⴷⴷⴻⴷ ⵓⵛⴰ ⵎⴰⵔⵔⴰ ⵍⴳⴻⵏⵙ ⴰⵢⴰ ⴰⴷ ⵢⴰⵡⴻⴹ ⵄⴰⵡⴻⴷ ⴷⵉ ⵍⴻⵀⵏⴰ ⵖⴰⵔ ⵡⴻⵎⵛⴰⵏ ⵉ ⴷ ⴰⵙⴻⵏ ⵉⵜⵜⵡⴰⴳⴳ.” ");
INSERT INTO rift_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","ⵉⵙⵍⴰ ⵎⵓⵙⴰ ⵖⴰⵔ ⵡⴰⵡⴰⵍ ⵏ ⵓⴹⴻⴳⴳⵯⴰⵍ ⵏⵏⴻⵙ, ⵉⴳⴳⴰ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴷ ⴰⵙ ⵉⵏⵏⴰ. ");
INSERT INTO rift_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","ⵉⵅⴹⴰⵔ ⵎⵓⵙⴰ ⵉⵔⵢⴰⵣⴻⵏ ⵉⵣⴻⵄⵄⴰⵎⴻⵏ ⵣⵉ ⵎⴰⵔⵔⴰ ⵉⵙⵔⴰⵉⵍ ⵓⵛⴰ ⵉⴳⴳⴰ ⵉ-ⵜⴻⵏ ⴷ ⵉⵣⴻⴵⵉⴼⴻⵏ ⵅ ⵍⴳⴻⵏⵙ: ⵉⵎⴻⵇⵇⵔⴰⵏⴻⵏ ⵅ ⵡⴰⵍⴻⴼ, ⵉⵎⴻⵇⵇⵔⴰⵏⴻⵏ ⵅ ⵎⵢⴰ, ⵉⵎⴻⵇⵇⵔⴰⵏⴻⵏ ⵅ ⵅⴻⵎⵙⵉⵏ ⴷ ⵉⵎⴻⵇⵇⵔⴰⵏⴻⵏ ⵅ ⵄⴻⵛⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","ⵓⵛⴰ ⵏⵉⵜⵏⵉ ⵜⵓⵖⴰ ⵜⵜⵛⴰⵔⵔⵄⴻⵏ ⵍⴳⴻⵏⵙ ⵍⴻⴱⴷⴰ ⵓⵛⴰ ⴷⴷⵄⴰⵡⵉ ⵉⵡⵄⴰⵔⴻⵏ ⵇⴻⴷⵎⴻⵏ ⵜⴻⵏⵜ ⵖⴰⵔ ⵎⵓⵙⴰ, ⵎⴰⵛⴰ ⵎⴰⵔⵔⴰ ⴷⴷⵄⴰⵡⵉ ⵜⵉⵎⴻⵥⵢⴰⵏⵉⵏ ⵛⴰⵔⵔⵄⴻⵏ ⵜⴻⵏⵜ ⵙ ⵢⵉⵅⴻⴼ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","ⵉⵇⴻⴱⴱⴻⴹ ⵎⵓⵙⴰ ⴰⴹⴻⴳⴳⵯⴰⵍ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⵄⵇⴻⴱ ⵏⴻⵜⵜⴰ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","ⴷⴻⴳ ⵓⵢⵓⵔ ⵡⵉⵙⵙ ⵜⵍⴰⵜⴰ ⴰⵡⴰⵔⵏⵉ ⵉ ⵡⵓⴼⴼⵓⵖ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ, ⴷⴻⴳ ⵡⴰⵙⵙ ⵏⵏⵉ ⵏⵏⵉⵜ, ⵉⵡⴹⴻⵏ-ⴷⴷ ⵖⴰⵔ ⵍⴻⵅⵍⴰ ⵏ ⵙⵉⵏⴰ. ");
INSERT INTO rift_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","ⴰⵇⴰ ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⵓⵢⵓⵔⴻⵏ ⵣⵉ ⵔⴰⴼⵉⴷⵉⵎ ⵓⵛⴰ ⵉⵡⴹⴻⵏ ⵖⴰⵔ ⵍⴻⵅⵍⴰ ⵏ ⵙⵉⵏⴰ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⵍⴻⵅⵍⴰ. ⵉⵡⵜⴰ ⵉⵙⵔⴰⵉⵍ ⵉⵇⵉⴹⴰⵏ ⵏⵏⴻⵙ ⵇⵉⴱⴰⵍⵜ ⵉ ⵡⴻⴷⵔⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","ⵢⵓⵍⵉ ⵎⵓⵙⴰ ⵖⴰⵔ ⴰⵔⴻⴱⴱⵉ ⵓⵛⴰ ⵉⵍⴰⵖⴰ ⴰⵙ-ⴷⴷ ⵙⵉⴷⵉ ⵣⴻⴳ ⵡⴻⴷⵔⴰⵔ, ⵉⵏⵏⴰ ⴰⵙ: “ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵜⴻⵙⵙⵉⵡⵍⴻⴷ ⴰⴽ-ⴷ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵢⴰⵄⵇⵓⴱ ⵓ ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵜⵉⵏⵉⴷ ⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ: ");
INSERT INTO rift_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘ⴽⴻⵏⵏⵉⵡ ⵜⴻⵥⵔⵉⵎ ⵎⵉⵏ ⴳⴳⵉⵖ ⴰⴽ-ⴷ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ ⵓ ⵎⴰⵎⵎⴻⵛ ⴽⴻⵏⵏⵉⵡ ⴽⵙⵉⵖ ⵅ ⵡⴰⴼⵔⵉⵡⴻⵏ ⵏ ⵓⴳⵉⴷⴻⵔ ⵓⵛⴰ ⵉⵡⵢⴻⵖ-ⴷⴷ ⴽⴻⵏⵏⵉⵡ ⵖⴰⵔⵉ.    ");
INSERT INTO rift_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","ⵅⴻⵏⵏⵉ ⵍⴻⵅⵅⵓ, ⵎⴰⵍⴰ ⵜⴻⵙⵍⵉⵎ ⵎⵍⵉⵃ ⵖⴰⵔ ⵡⴰⵡⴰⵍ ⵉⵏⵓ ⵓ ⴰⴷ ⵜⴻⵃⴹⴰⵎ ⵍⵄⴰⵀⴷ ⵉⵏⵓ, ⴰⴷ ⵖⴰⵔⵉ ⵜⵉⵍⵉⵎ ⴽⴻⵏⵏⵉⵡ ⵜⵉⵖⵍⴰⵎ ⵅ ⵎⴰⵔⵔⴰ ⵍⴻⴳⵏⵓⵙ, ⵎⵉⵏⵣⵉ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⴰⵇⴰ-ⵜⵜ ⵉⵏⵓ. ");
INSERT INTO rift_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⴰⵢⵉ ⵜⵉⵍⵉⵎ ⴷ ⵉⵛⵜ ⵏ ⵜⴳⴻⵍⴷⵉⵜ ⵏ ⵉⴽⴻⵀⵀⴰⵏⴻⵏ ⴷ ⵉⵊⵊ ⵏ ⵍⴳⴻⵏⵙ ⴰⵎⵇⴻⴷⴷⴰⵙ.’ ⵉⵏⴰ ⴷ ⴰⵡⴰⵍⴻⵏ ⵏⵏⵉ ⴷ ⴰⵛ ⵉⵜⵜⵅⴻⵚⵚⴰⵏ ⴰⴷ ⵜⴻⵏ ⵜⵉⵏⵉⴷ ⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ.” ");
INSERT INTO rift_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","ⵉⵀⵡⴰ-ⴷⴷ ⵎⵓⵙⴰ ⵓⵛⴰ ⵉⵍⴰⵖⴰ-ⴷⴷ ⵅ ⵉⵎⵖⴰⵔⴻⵏ ⵏ ⵍⴳⴻⵏⵙ ⵓⵛⴰ ⵉⴱⴰⵔⵔⴻⵃ ⴰⵙⴻⵏ ⵎⴰⵔⵔⴰ ⴰⵡⴰⵍⴻⵏ-ⴰ ⵉ ⴷ ⴰⵙ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","ⵓⵛⴰ ⵢⴰⵔⵔⴰ-ⴷⴷ ⵎⴰⵔⵔⴰ ⵍⴳⴻⵏⵙ, ⵏⵏⴰⵏ: “ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ, ⴰⴷ ⵜ ⵏⴻⴳⴳ!” ⵓⵛⴰ ⵉⵙⵙⵉⵡⴻⴹ ⵎⵓⵙⴰ ⴰⵡⴰⵍⴻⵏ ⵏ ⵍⴳⴻⵏⵙ ⵄⴰⵡⴻⴷ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⵅⵣⴰⵔ, ⵏⴻⵛⵛ ⴰⴷ ⵖⴰⵔⴻⴽ ⴷⴷ-ⴰⵙⴻⵖ ⴷⴻⴳ ⵉⵊⵊ ⵏ ⵓⵙⴻⵢⵏⵓ ⴷ ⴰⴱⴰⵔⵛⴰⵏ, ⵃⵉⵎⴰ ⴰⴷ ⵉⵙⴻⵍ ⵍⴳⴻⵏⵙ ⵅⵎⵉ ⵏⴻⵛⵛ ⴽⵉⴽ ⵖⴰ ⵙⵙⵉⵡⵍⴻⵖ ⵓⵛⴰ ⵄⴰⵡⴻⴷ ⴰⴷ ⵣⵣⴰⵢⴻⴽ ⴰⵎⵏⴻⵏ ⵉ ⵍⴻⴱⴷⴰ.” ⵎⵉⵏⵣⵉ ⵎⵓⵙⴰ ⵉⵅⴻⴱⴱⴰⵔ ⴰⵡⴰⵍⴻⵏ ⵏ ⵙⵉⴷⵉ ⵉ ⵍⴳⴻⵏⵙ. ");
INSERT INTO rift_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","ⵙⵉⴷⵉ ⵉⵏⵏⴰ ⵉ ⵎⵓⵙⴰ: “ⵔⵓⵃ ⵖⴰⵔ ⵍⴳⴻⵏⵙ ⵓⵛⴰ ⵙⵇⴻⴷⴷⴻⵙ ⵉ-ⵜⴻⵏ ⴰⵙⵙ-ⴰ ⴷ ⵜⵉⵡⴻⵛⵛⴰ, ⴻⵊⵊ ⵉ-ⵜⴻⵏ ⴰⴷ ⵙⵙⵉⵔⴷⴻⵏ ⴰⵔⵔⵓⴹ ⵏⵙⴻⵏ ");
INSERT INTO rift_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","ⵓⵛⴰ ⴰⴷ ⵉⵍⵉⵏ ⵡⴻⵊⴷⴻⵏ ⵉ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵜⵍⴰⵜⴰ, ⵎⵉⵏⵣⵉ ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵜⵍⴰⵜⴰ ⴰⴷ ⴷⴷ-ⵉⵀⵡⴰ ⵙⵉⴷⵉ ⵖⴰⵔ ⵡⴻⴷⵔⴰⵔ ⵏ ⵙⵉⵏⴰ ⵣⵣⴰⵜ ⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵎⴰⵔⵔⴰ ⵍⴳⴻⵏⵙ. ");
INSERT INTO rift_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","ⴻⴳⴳ ⵉⵢⵎⵉⵔⴻⵏ ⵉ ⵍⴳⴻⵏⵙ ⴷⴻⴳ ⵡⴻⵏⵏⴻⴹ ⵏ ⵡⴻⴷⵔⴰⵔ, ⵉⵏⵉ: ‘ⵖⴰⵔⵡⴻⵎ, ⵡⴰⵔ ⵜⵉⵍⵢⴻⵎ ⵖⴰⵔ ⵡⴻⴷⵔⴰⵔ ⵏⵉⵖ ⴰⴷ ⵜⵃⴰⴷⴰⵎ ⵟⵟⴰⵔⴼ ⵏⵏⴻⵙ. ⵎⴰⵏ ⵡⴻⵏ ⵉ ⵖⴰ ⵉⵃⴰⴷⴰⵏ ⴰⴷⵔⴰⵔ, ⴰⴷ ⵉⵜⵜⵡⴰⵏⴻⵖ ⵏⵉⵛⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","ⵡⴰⵔ ⵜ ⵉⵜⵜⵃⵉⴷⵉ ⵃⴻⴷ ⵙ ⵓⴼⵓⵙ, ⵎⵉⵏⵣⵉ ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⵜⵜⵡⴰⵔⵊⴻⵎ ⵏⵉⵖ ⴰⴷ ⵉⵜⵜⵡⴰⵡⵡⴻⵜ ⵏⵉⵛⴰⵏ ⵙ ⴼⵍⵉⵜⵛⴰⵜ ⵎⵉⵏ ⵎⴰ ⵉⵄⵏⴰ, ⵍⴻⴱⵀⵉⵎⴻⵜ ⵏⵉⵖ ⴷ ⴱⵏⴰⴷⴻⵎ, ⵡⴰⵔ ⵉⵜⵜⵖⵉⵎⵉ ⵉⴷⴷⴰⵔ. ⵎⴰⵍⴰ ⴰⴷ ⴷⵉⵏ ⵢⵉⵍⵉ ⵉⵊⵊ ⵏ ⵓⵙⵓⴹⵉ ⴷⴻⴳ ⵓⵢⵉⵛⵛ ⵏ ⵓⵙⵍⵉⵡⵍⴻⵡ ⴷ ⴰⵣⵉⵔⴰⵔ, ⵣⴻⵎⵎⴰⵔⴻⵏ ⵏⵉⵜⵏⵉ ⴰⴷ ⴰⵍⵢⴻⵏ ⴰⴷⵔⴰⵔ.’” ");
INSERT INTO rift_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","ⵅⴻⵏⵏⵉ ⵉⵀⵡⴰ-ⴷⴷ ⵎⵓⵙⴰ ⵣⴻⴳ ⵡⴻⴷⵔⴰⵔ ⵖⴰⵔ ⵍⴳⴻⵏⵙ, ⵉⵙⵙⵇⴻⴷⴷⴻⵙ ⵍⴳⴻⵏⵙ ⵓⵛⴰ ⵙⵙⵉⵔⴷⴻⵏ ⴰⵔⵔⵓⴹ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","ⵉⵏⵏⴰ ⵉ ⵍⴳⴻⵏⵙ: “ⵉⵍⵉⵎ ⵜⵜⵡⴻⵊⴷⴻⵎ ⵉ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵜⵍⴰⵜⴰ, ⵡⴰⵔ ⴷⴷ-ⵜⵜⵇⴰⵔⵔⴰⴱⴻⵎ ⵖⴰⵔ ⵜⴻⵎⵖⴰⵔⵜ.” ");
INSERT INTO rift_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","ⴷⵉ ⵚⵚⴱⴻⵃ ⵏ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵜⵍⴰⵜⴰ ⵓⵙⵉⵏ-ⴷⴷ ⵡⴰⵊⵊⴰⵊⴻⵏ ⴷ ⵡⴰⵙⵙⴰⵎⴻⵏ. ⴰⵇⴰ ⵢⴰⵔⵙⴰ ⵉⵊⵊ ⵏ ⵓⵙⴻⵢⵏⵓ ⵉⴷⴷⴻⵇⵍⴻⵏ ⵅ ⵡⴻⴷⵔⴰⵔ ⵓ ⵍⵃⴻⵙⵙ ⵏ ⵓⵙⵓⴹⵉ ⴷⴻⴳ ⵓⵢⵉⵛⵛ ⵏ ⵉⵛⴰⵔⵔⵉ ⵉⴷⵡⴻⵍ ⵉⵊⵀⴻⴷ ⴰⵟⵟⴰⵙ. ⵎⴰⵔⵔⴰ ⵍⴳⴻⵏⵙ ⴷⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵢⴰⵔⵊⵉⵊ. ");
INSERT INTO rift_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","ⵎⵓⵙⴰ ⵉⵏⴷⴻⵀ ⵍⴳⴻⵏⵙ ⵣⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⵍⵇⴰ ⴰⵔⴻⴱⴱⵉ ⵓⵛⴰ ⴱⴻⴷⴷⴻⵏ ⵏⵉⵜⵏⵉ ⵙⵡⴰⴷⴷⴰⵢ ⵉ ⵡⴻⴷⵔⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","ⵎⴰⵔⵔⴰ ⴰⴷⵔⴰⵔ ⵏ ⵙⵉⵏⴰ ⵉⴷⴷⴻⵅⵅⴻⵏ, ⵎⵉⵏⵣⵉ ⵙⵉⴷⵉ ⵜⵓⵖⴰ ⵉⵀⵡⴰ-ⴷⴷ ⵅⴰⵙ ⴷⵉ ⵜⵎⴻⵙⵙⵉ. ⴷⴷⴻⵅⵅⴰⵏ ⵏⵏⴻⵙ ⵢⵓⵍⵉ-ⴷⴷ ⴰⵎ ⴷⴷⴻⵅⵅⴰⵏ ⵏ ⵓⴼⴰⵔⵔⴰⵏ ⵓⵛⴰ ⵎⴰⵔⵔⴰ ⴰⴷⵔⴰⵔ ⵉⵏⵀⴻⵣⵣ ⴰⵟⵟⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","ⴰⵎ ⵉⴷⵡⴻⵍ ⵓⵙⵓⴹⵉ ⴷⴻⴳ ⵓⵢⵉⵛⵛ ⵏ ⵉⵛⴰⵔⵔⵉ ⵉⵊⵀⴻⴷ ⴰⵟⵟⴰⵙ, ⵉⵙⵙⵉⵡⴻⵍ ⵎⵓⵙⴰ ⵓⵛⴰ ⵢⴰⵔⵔⴰ-ⴷⴷ ⵅⴰⵙ ⴰⵔⴻⴱⴱⵉ ⵙ ⵢⵉⵊⵊ ⵏ ⵍⵃⴻⵙⵙ ⵉⵊⵀⴻⴷ. ");
INSERT INTO rift_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","ⵓⵛⴰ ⵉⵀⵡⴰ-ⴷⴷ ⵙⵉⴷⵉ ⵅ ⵡⴻⴷⵔⴰⵔ ⵏ ⵙⵉⵏⴰ, ⵅ ⵜⵇⵉⵛⵛⴻⵜ ⵏ ⵡⴻⴷⵔⴰⵔ, ⵓⵛⴰ ⵉⵍⴰⵖⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ ⵖⴰⵔ ⵜⵇⵉⵛⵛⴻⵜ ⵏ ⵡⴻⴷⵔⴰⵔ. ⵅⴻⵏⵏⵉ ⵉⴳⴻⵄⵄⴻⴷ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⵀⵡⴰ-ⴷⴷ, ⵄⵍⴻⵎ ⵉ ⵍⴳⴻⵏⵙ, ⵎⴰⵃⴻⵏⴷ ⵡⴰⵔ ⵜⵜⵛⵓⵇⵉⵏ ⴷⵉ ⵙⵉⴷⵉ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜ ⵥⴰⵔⴻⵏ ⵓⵛⴰ ⵅⴻⵏⵏⵉ ⴱⴰⵍⴰⴽ ⴰⴷ ⵜⵜⵡⴰⵀⴻⵍⵍⴽⴻⵏ ⴰⵟⵟⴰⵙ ⵣⵣⴰⵢⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","ⴻⵊⵊ ⵄⴰⵡⴻⴷ ⵉⴽⴻⵀⵀⴰⵏⴻⵏ, ⵉⵏⵏⵉ ⵉ ⴷⴷ ⵖⴰ ⵉⵇⴰⵔⵔⴱⴻⵏ ⵖⴰⵔ ⵙⵉⴷⵉ, ⴰⴷ ⵙⵙⵇⴻⴷⴷⵙⴻⵏ ⵉⵅⴻⴼ ⵏⵙⴻⵏ, ⵃⵉⵎⴰ ⵙⵉⴷⵉ ⵡⴰⵔ ⵅⴰⵙⴻⵏ ⵉⵙⴻⵄⵄⴰⵔ ⵛⴰ.” ");
INSERT INTO rift_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","ⵉⵏⵏⴰ ⵎⵓⵙⴰ ⵉ ⵙⵉⴷⵉ: “ⵍⴳⴻⵏⵙ ⵡⴰⵔ ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵉⴳⴻⵄⵄⴻⴷ ⴰⴷⵔⴰⵔ ⵏ ⵙⵉⵏⴰ, ⵎⵉⵏⵣⵉ ⵛⴻⴽ ⵜⵄⴻⵍⵎⴻⴷ ⴰⵏⴻⵖ ⵜⴻⵏⵏⵉⴷ: ‘ⴻⴳⴳ ⵉⵢⵎⵉⵔⴻⵏ ⵅ ⵡⴻⴷⵔⴰⵔ ⵓⵛⴰ ⵙⵇⴻⴷⴷⴻⵙ ⵉ-ⵜ.’” ");
INSERT INTO rift_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","ⵉⵏⵏⴰ ⴰⵙ ⵙⵉⴷⵉ: “ⵔⵓⵃ, ⵀⵡⴰ! ⴰⴷ ⵜⴳⴻⵄⵄⴷⴻⴷ ⵛⴻⴽ ⴷ ⵀⴰⵔⵓⵏ ⴰⴽⵉⴷⴻⴽ, ⵎⴰⵛⴰ ⵉⴽⴻⵀⵀⴰⵏⴻⵏ ⴷ ⵍⴳⴻⵏⵙ ⵡⴰⵔ ⵣⴻⵎⵎⴰⵔⴻⵏ ⴰⴷ ⵛⵓⵇⴻⵏ, ⵃⵉⵎⴰ ⴰⴷ ⴳⴻⵄⵄⴷⴻⵏ ⵖⴰⵔ ⵙⵉⴷⵉ, ⵃⵉⵎⴰ ⵏⴻⵜⵜⴰ ⵡⴰⵔ ⵅⴰⵙⴻⵏ ⵉⵙⴻⵄⵄⴰⵔ ⵛⴰ.” ");
INSERT INTO rift_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⵀⵡⴰ-ⴷⴷ ⵎⵓⵙⴰ ⵖⴰⵔ ⵍⴳⴻⵏⵙ ⵓⵛⴰ ⵉⵏⵏⴰ ⴰⵙⴻⵏ ⵎⴰⵔⵔⴰ ⴰⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⴰⵔⴻⴱⴱⵉ ⵎⴰⵔⵔⴰ ⴰⵡⴰⵍⴻⵏ-ⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵛ, ⵡⴻⵏⵏⵉ ⵛⴻⴽ ⴷⴷ-ⵉⵙⵙⵓⴼⴼⵖⴻⵏ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ, ⵣⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵜⴻⵙⵎⵓⵖⵉ. ");
INSERT INTO rift_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","ⵡⴰⵔ ⵖⴰⵔⴻⴽ ⵜⵜⵉⵍⵉⵏ ⵉⵔⴻⴱⴱⵉⵜⴻⵏ ⵏⵏⴻⵖⵏⵉ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵉⵏⵓ. ");
INSERT INTO rift_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","ⵡⴰⵔ ⵜⵜⴻⴳⴳ ⵉ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵛ ⵍⴻⵅⵢⴰⵍ ⵉⵏⴻⵇⵛⴻⵏ ⵏⵉⵖ ⵛⴰ ⵏ ⵍⵃⴰⵊⵊⴻⵜ ⵜⴰⵔⵡⴻⵙ ⴷⵉ ⵎⵉⵏ ⵉⴵⴰⵏ ⵙⴻⵏⵏⴻⵊ ⴷⴻⴳ ⵓⵊⴻⵏⵏⴰ ⵏⵉⵖ ⴷⵉ ⵛⴰ ⴷⴰ ⵙⵡⴰⴷⴷⴰⵢ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵉⵖ ⴷⵉ ⵛⴰ ⴷⴻⴳ ⵡⴰⵎⴰⵏ ⵉ ⵉⴵⴰⵏ ⵙⴰⴷⵓ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","ⵡⴰⵔ ⴷ ⴰⵙⴻⵏ ⵜⵜⴱⴻⵏⴷⵉⵇ ⵓⵍⴰ ⴰⴷ ⵅⴰⵙⴻⵏ ⵜⵙⴻⵅⵅⴰⵔⴻⴷ, ⵎⵉⵏⵣⵉ ⵏⴻⵛⵛ, ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵛ, ⴷ ⵉⵊⵊ ⵏ ⴰⵔⴻⴱⴱⵉ ⵉⵜⵜⴰⵙⵎⴻⵏ, ⵡⴻⵏⵏⵉ ⴷⴷ-ⵢⴰⵔⴻⵣⴼⴻⵏ ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⴷⵉ ⵜⴰⵔⵡⴰ ⴰⵍ ⵊⵊⵉⵍ ⵡⵉⵙⵙ ⵜⵍⴰⵜⴰ ⴷ ⵡⵉⵙⵙ ⴰⵔⴻⴱⵄⴰ ⵏ ⵢⵉⵏⵏⵉ ⴷ ⴰⵢⵉ ⵉⵛⴰⵔⵔⵀⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","ⴷ ⵡⴻⵏⵏⵉ ⵉⵙⵙⵛⴰⵏⴻⵏ ⵜⴰⵎⴻⵅⵙⵉⵡⵜ ⵏⵏⴻⵙ ⵉⵛⴻⵡⵡⴰⵔⴻⵏ ⵉ ⵍⵓⵍⵓⴼ ⵏ ⵢⵉⵏⵏⵉ ⴷ ⴰⵢⵉ ⵉⵜⵜⴻⵅⵙⴻⵏ ⵓ ⵃⴻⵟⵟⴰⵏ ⵍⵓⵎⵓⵔⴰⵜ ⵉⵏⵓ. ");
INSERT INTO rift_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","ⵡⴰⵔ ⵏⴻⵟⵟⴻⵇ ⵙ ⵢⵉⵙⴻⵎ ⵏ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵛ, ⴷⵉ ⵍⴱⴰⵟⴻⵍ, ⵎⵉⵏⵣⵉ ⵡⴰⵔ ⵉⵜⵜⴱⴰⵔⵔⵉ ⵙⵉⴷⵉ ⵉ ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵉⵏⴻⵟⵇⴻⵏ ⵙ ⵢⵉⵙⴻⵎ ⵏⵏⴻⵙ ⴷⵉ ⵍⴱⴰⵟⴻⵍ. ");
INSERT INTO rift_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","ⵉⴷⴰⵔ ⴰⵙⵙ ⵏ ⵙⵙⴻⴱⵜ, ⵃⵉⵎⴰ ⴰⴷ ⵜ ⵜⴻⵙⵙⵇⴻⴷⴷⵙⴻⴷ. ");
INSERT INTO rift_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","ⵙⴻⵜⵜⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⵉ ⵖⴰ ⵜⵅⴻⴷⵎⴻⴷ, ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵎⴰⵔⵔⴰ ⵍⵅⴻⴷⵎⴻⵜ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","ⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ ⴷ ⵡⴰⵙⵙ ⵏ ⵙⵙⴻⴱⵜ ⵏ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵛ. ⵡⴰⵔ ⴷⴰⵢⴻⵙ ⵜⵜⴻⴳⴳ ⵓⵍⴰ ⴷ ⵉⵛⵜ ⵏ ⵍⵅⴻⴷⵎⴻⵜ, ⵛⴻⴽ ⵍⵍⴰ, ⵓⵍⴰ ⴷ ⵎⵎⵉⵛ ⵍⵍⴰ, ⴷ ⵢⴻⴵⵉⵛ ⵍⵍⴰ, ⴷ ⵉⵙⵎⴻⵖ ⵏⵏⴻⵛ ⵍⵍⴰ, ⴷ ⵜⴰⵢⵢⴰ ⵏⵏⴻⵛ ⵍⵍⴰ, ⴷ ⵍⴻⴱⵀⵉⵎⴻⵜ ⵏⵏⴻⵛ ⵍⵍⴰ, ⵓⵍⴰ ⴷ ⴰⴱⴰⵔⵔⴰⵏⵉ ⵏⵏⵉ ⴰⴽⵉⴷⴻⴽ ⵉⴵⴰⵏ ⴷⴰⵅⴻⵍ ⵉ ⵜⴻⵡⵡⵓⵔⴰ ⵏⵏⴻⵛ ⵍⵍⴰ. ");
INSERT INTO rift_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","ⵎⵉⵏⵣⵉ ⴷⵉ ⵙⴻⵜⵜⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⵉⴳⴳⴰ ⵙⵉⴷⵉ ⵉⵊⴻⵏⵡⴰⵏ ⴷ ⵜⴻⵎⵎⵓⵔⵜ, ⵍⴻⴱⵃⴰⵔ ⴷ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴷⴰⵢⴻⵙ ⵓⵛⴰ ⵢⴰⵔⴻⵢⵢⴻⵃ ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ. ⵅ ⵓⵢⴰ ⵉⴱⴰⵔⴻⴽ ⵙⵉⴷⵉ ⴰⵙⵙ ⵏ ⵙⵙⴻⴱⵜ ⵓⵛⴰ ⵉⵙⵙⵇⴻⴷⴷⴻⵙ ⵉ-ⵜ. ");
INSERT INTO rift_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","ⵡⴻⵇⵇⴰⵔ ⴱⴰⴱⴰⵛ ⴷ ⵢⴻⵎⵎⴰⵛ, ⵎⴰⵃⴻⵏⴷ ⵓⵙⵙⴰⵏ ⵏ ⵜⵓⴷⴰⵔⵜ ⵏⵏⴻⵛ ⵣⴻⵎⵎⴰⵔⴻⵏ ⴰⴷ ⵣⵣⵓⴳⴳⴰⵔⵜⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵉ ⴷ ⴰⵛ ⵖⴰ ⵢⴻⵡⵛ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","ⵡⴰⵔ ⵏⴻⵇⵇ. ");
INSERT INTO rift_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","ⵡⴰⵔ ⵣⴻⵏⵏⴰ. ");
INSERT INTO rift_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","ⵡⴰⵔ ⵜⵜⴰⵛⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","ⵡⴰⵔ ⵛⴻⵀⵀⴻⴷ ⵙ ⵥⵓⵔ ⴹⵉⴷⴷ ⵉ ⵊⵊⴰⵔ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","ⵡⴰⵔ ⵎⴻⵥⵔⵉ ⴷⵉ ⵛⴰ, ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵊⵊⴰⵔ ⵏⵏⴻⵛ ⵡⴰⵔ ⴷⴰⵢⴻⵙ ⵎⴻⵥⵔⵉ. ⵡⴰⵔ ⵎⴻⵥⵔⵉ ⴷⵉ ⵜⴰⵎⵖⴰⵔⵜ ⵏ ⵊⵊⴰⵔ ⵏⵏⴻⵛ, ⵏⵉⵖ ⴷⴻⴳ ⵢⵉⵙⵎⴻⵖ ⵏⵏⴻⵙ, ⵏⵉⵖ ⴷⵉ ⵜⴰⵢⵢⴰ ⵏⵏⴻⵙ, ⵏⵉⵖ ⴷⴻⴳ ⵓⴼⵓⵏⴰⵙ ⵏⵏⴻⵙ, ⵏⵉⵖ ⴷⴻⴳ ⵡⴻⵖⵢⵓⵍ ⵏⵏⴻⵙ ⵓⵍⴰ ⴷⴻⴳ ⵉⵛⵜ ⵏ ⵍⵃⴰⵊⵊⴻⵜ ⵉ ⵉⴵⴰⵏ ⵏ ⵊⵊⴰⵔ ⵏⵏⴻⵛ.” ");
INSERT INTO rift_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","ⵎⴰⵔⵔⴰ ⵍⴳⴻⵏⵙ ⵉⵥⵔⴰ ⵓ ⵉⵙⵍⴰ ⵉ ⵡⴰⵊⵊⴰⵊⴻⵏ ⴷ ⵡⴰⵙⵙⴰⵎⴻⵏ ⴷ ⴷⴷⵔⵉⵣ ⵏ ⵓⵙⵓⴹⵉ ⴷⴻⴳ ⵓⵢⵉⵛⵛ ⵏ ⵉⵛⴰⵔⵔⵉ ⴷ ⵡⴻⴷⵔⴰⵔ ⵉⴷⴷⵓⵅⵅⵓⵏⴻⵏ. ⵓⵎⵉ ⵉⵥⵔⴰ ⵍⴳⴻⵏⵙ ⵎⴰⵏ ⴰⵢⴰ, ⵅⴻⵏⵏⵉ ⴰⵔⵊⵉⵊⴻⵏ ⵓⵛⴰ ⴱⴻⵄⵄⴷⴻⵏ ⵏⵉⵜⵏⵉ ⵖⴰⵔ ⵍⴰⴳⴳⵯⴰⵊ. ");
INSERT INTO rift_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","ⵏⵏⴰⵏ ⵉ ⵎⵓⵙⴰ: “ⵙⵉⵡⴻⵍ ⵛⴻⴽ ⴰⴽⵉⴷⵏⴻⵖ ⵓⵛⴰ ⴰⴷ ⵏⵙⴻⵍ. ⵎⴰⵛⴰ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⵔⴻⴱⴱⵉ ⵡⴰⵔ ⴽⵉⴷⵏⴻⵖ ⵉⵙⵙⵉⵡⵉⵍ, ⵃⵉⵎⴰ ⵡⴰⵔ ⵏⴻⵜⵜⵎⴻⵜⵜⵉ!” ");
INSERT INTO rift_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","ⵉⵏⵏⴰ ⵎⵓⵙⴰ ⵉ ⵍⴳⴻⵏⵙ: “ⵡⴰⵔ ⵜⴻⴳⴳⵯⴻⴷⴻⵎ ⵛⴰ, ⴰⵇⴰ ⵢⵓⵙⴰ-ⴷⴷ ⴰⵔⴻⴱⴱⵉ, ⵃⵉⵎⴰ ⴰⴷ ⴽⴻⵏⵏⵉⵡ ⵉⵇⴻⴵⴻⴱ ⵓ ⵃⵉⵎⴰ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵜⴻⴳⴳⵯⴻⴷⴻⵎ ⵎⴰⵃⴻⵏⴷ ⵡⴰⵔ ⵜⵅⴻⵟⵟⵉⵎ ⵛⴰ.” ");
INSERT INTO rift_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","ⵉⴱⴻⴷⴷ ⵍⴳⴻⵏⵙ ⵣⵉ ⵍⴰⴳⴳⵯⴰⵊ, ⵎⴰⵛⴰ ⵎⵓⵙⴰ ⵉⵇⴰⵔⵔⴻⴱ-ⴷⴷ ⵖⴰⵔ ⵓⵙⴻⵢⵏⵓ ⵉⴱⴱⵓⵎⴱⵙⴻⵏ ⵎⴰⵏⵉ ⵜⵓⵖⴰ ⴰⵔⴻⴱⴱⵉ. ");
INSERT INTO rift_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⴰⵎⵎⵓ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜⵉⵏⵉⴷ ⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ: ‘ⴽⴻⵏⵏⵉⵡ ⵜⴻⵥⵔⵉⵎ ⴱⴻⵍⵍⵉ ⵙⵙⵉⵡⵍⴻⵖ-ⴷⴷ ⴰⴽⵉⴷⵡⴻⵎ ⵣⴻⴳ ⵓⵊⴻⵏⵏⴰ. ");
INSERT INTO rift_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","ⵡⴰⵔ ⴽⵉⴷⵉ ⵜⵜⴻⴳⴳⴻⵎ ⵉⵔⴻⴱⴱⵉⵜⴻⵏ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵓ ⵡⴰⵔ ⵜⵜⴻⴳⴳⴻⵎ ⵉⵔⴻⴱⴱⵉⵜⴻⵏ ⵏ ⵡⵓⵔⴻⵖ ⵉ ⵢⵉⵅⴻⴼ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","ⴻⴳⴳ ⴰⵢⵉ ⵉⵊⵊ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ⵙ ⵓⵛⴰⵍ, ⵇⴻⴷⴷⴻⵎ ⵅⴰⵙ ⵜⵉⵖⴰⵔⵚⴰ ⵏⵏⴻⵛ ⵏ ⵡⴻⵛⵎⴰⴹ ⴷ ⵜⵉⵖⴰⵔⵚⴰ ⵏⵏⴻⵛ ⵏ ⵍⴻⵀⵏⴰ, ⵓⴵⵉ ⵏⵏⴻⵛ ⴷ ⵉⴼⵓⵏⴰⵙⴻⵏ ⴷ ⵜⴼⵓⵏⴰⵙⵉⵏ ⵏⵏⴻⵛ. ⴷⵉ ⴽⵓⵍ ⴰⵎⵛⴰⵏ ⵎⴰⵏⵉ ⵖⴰ ⴳⴳⴻⵖ ⵍⵉⴷⴰⵔⴻⵜ ⵏ ⵢⵉⵙⴻⵎ ⵉⵏⵓ, ⴰⴷ ⵖⴰⵔⴻⴽ ⴷⴷ-ⴰⵙⴻⵖ ⵓⵛⴰ ⴰⴷ ⴰⵛ ⴱⴰⵔⴽⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","ⵎⴰⵍⴰ ⵜⴻⴳⴳⵉⴷ ⴰⵢⵉ ⵉⵊⵊ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ⵏ ⵉⵥⵔⴰ, ⵡⴰⵔ ⵜ ⵜⴱⴻⵏⵏⵉⴷ ⵙ ⵜⵚⵓⴹⴰⵔ ⵉⵜⵜⵡⴰⵙⵙⵓⵢⴷⴰⵏ, ⵎⵉⵏⵣⵉ ⵎⴰⵍⴰ ⵜⴻⴷⴷⵣⴻⴷ ⵙ ⵓⵍⴻⵢⵣⵉⵎ ⵏⵏⴻⵛ, ⵉⵍⵉ ⴰⴷ ⵜ ⵜⴻⵙⵙⵄⵉⴵⵜⴻⴷ. ");
INSERT INTO rift_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","ⵡⴰⵔ ⵜⵜⴳⵉⵄⵄⵉⴷ ⵖⴰⵔ ⵓⵄⴰⵍⵟⴰⵔ ⵉⵏⵓ ⵙ ⵢⵉⵊⵊ ⵏ ⴷⴷⵔⵓⵊ, ⵃⵉⵎⴰ ⵡⴰⵔ ⵉⵜⵜⴱⵉⵏ ⵓⵙⴻⴹⵃⵉ ⵏⵏⴻⵛ.” ");
INSERT INTO rift_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“ⵜⵉⵏⴰ ⵉ ⵉⴵⴰⵏ ⴷ ⵍⴼⴰⵔⴰⵢⵉⴹ ⵏⵏⵉ ⴷ ⴰⵙⴻⵏ ⵖⴰ ⵜⴻⵙⵙⵉⵡⴹⴻⴷ. ");
INSERT INTO rift_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","ⵎⴰⵍⴰ ⵜⴻⵙⵖⵉⴷ ⵉⵙⵎⴻⵖ ⴷ ⴰⵄⵉⴱⵔⴰⵏⵉ, ⵅⴻⵏⵏⵉ ⵏⴻⵜⵜⴰ ⴰⴷ ⴰⵛ ⵉⵙⴻⵅⵅⴰⵔ ⵙⴻⵜⵜⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵎⴰⵛⴰ ⴷⴻⴳ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ ⴰⴷ ⵉⴼⴼⴻⵖ ⴷ ⴰⵃⵓⵔⵔⵉ ⴱⴰⵟⴻⵍ. ");
INSERT INTO rift_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","ⵎⴰⵍⴰ ⵢⵓⴷⴻⴼ ⵡⴻⵃⵃⴷⴻⵙ, ⵡⴻⵃⵃⴷⴻⵙ ⵉ ⵖⴰ ⵉⴼⴼⴻⵖ, ⵎⴰⵍⴰ ⵖⴰⵔⴻⵙ ⵜⴰⵎⵖⴰⵔⵜ, ⴰⴷ ⵉⴼⴼⴻⵖ ⵏⴻⵜⵜⴰ ⴷ ⵜⴻⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","ⵎⴰⵍⴰ ⵙⵉⴷⵉⵙ ⵉⵡⵛⴰ ⴰⵙ ⵜⴰⵎⵖⴰⵔⵜ ⵓⵛⴰ ⵏⴻⵜⵜⴰⵜ ⵜⴻⵊⵊⴰ ⴰⵙ-ⴷⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⴷ ⵜⵃⴻⵏⵊⵉⵔⵉⵏ, ⵅⴻⵏⵏⵉ ⵜⴰⵎⵖⴰⵔⵜ ⴷ ⵜⴰⵔⵡⴰ ⵏⵏⴻⵙ ⴰⴷ ⵉⵍⵉⵏ ⵏ ⵙⵉⴷⵉⵙ, ⵓ ⵅⴻⵏⵏⵉ ⵏⴻⵜⵜⴰ ⴰⴷ ⵉⴼⴼⴻⵖ ⵙ ⵉⵎⴰⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⵉⵙⵎⴻⵖ ⵉⵏⵏⴰ ⵏⵉⵛⴰⵏ: ‘ⵏⴻⵛⵛ ⵅⵙⴻⵖ ⵙⵉⴷⵉ ⵉⵏⵓ ⴷ ⵜⴻⵎⵖⴰⵔⵜ ⵉⵏⵓ ⴷ ⵜⴰⵔⵡⴰ ⵉⵏⵓ, ⵡⴰⵔ ⵅⵙⴻⵖ ⴰⴷ ⴼⴼⵖⴻⵖ ⴷ ⴰⵃⵓⵔⵔⵉ!’, ");
INSERT INTO rift_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵙⵉⴷⵉⵙ ⴰⴷ ⵜ ⵉⵙⵙⴱⴻⴷⴷ ⵣⵣⴰⵜ ⵉ ⴰⵔⴻⴱⴱⵉ. ⴰⴷ ⵜ ⵢⴰⵡⵉ ⵖⴰⵔ ⵜⴻⵡⵡⴰⵔⵜ ⵏⵉⵖ ⵖⴰⵔ ⵜⴻⴼⵍⴰⵡⵜ ⵖⴰⵔ ⵓⵖⴻⵣⴷⵉⵙ ⵏ ⵜⴻⵡⵡⴰⵔⵜ ⵓⵛⴰ ⵙⵉⴷⵉⵙ ⴰⴷ ⴰⵙ ⵉⵙⵙⵏⵓⵇⵇⴻⴱ ⴰⵎⴻⵊⵊⵓⵏ ⵏⵏⴻⵙ ⵙ ⵢⵉⵛⵜ ⵏ ⵜⵙⵉⵏⴻⴼⵜ ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⴰⴷ ⴰⵙ ⵉⵙⴻⵅⵅⴰⵔ ⵉ ⵍⴻⴱⴷⴰ. ");
INSERT INTO rift_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","ⵎⴰⵍⴰ ⵉⵣⵣⴻⵏⵣ ⵃⴻⴷ ⵢⴻⴵⵉⵙ ⴷ ⵜⴰⵢⵢⴰ, ⵡⴰⵔ ⵉⵜⵜⴻⴼⴼⵉⵖ ⴰⵎ ⵎⵓⵅⴰⵙ ⵜⵜⴻⴼⴼⵖⴻⵏ ⵉⵙⴻⵎⵖⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","ⵎⴰⵍⴰ ⵡⴰⵔ ⵜⴻⵄⵊⵉⴱ ⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵙⵉⴷⵉⵙ ⵓ ⵏⴻⵜⵜⴰ ⵜⵓⵖⴰ ⵉⵅⴹⴻⴱ ⵉ-ⵜⵜ, ⴰⴷ ⵜⵜ ⵢⴻⵊⵊ ⴰⴷ ⵜᵉⵜⵜⵡⴰⴼⴷⵉ. ⵡⴰⵔ ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵜⵜ ⵉⵣⵣⴻⵏⵣ ⵉ ⵢⵉⵊⵊ ⵏ ⵍⴳⴻⵏⵙ ⵏ ⴱⴰⵔⵔⴰ ⵎⵉⵏⵣⵉ ⵏⴻⵜⵜⴰ ⵉⵖⴷⴰⵔ ⵣⵣⴰⵢⴻⵙ ⵙ ⵎⵉⵏ ⵉⴳⴳⴰ. ");
INSERT INTO rift_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","ⵎⴰⵍⴰ ⵉⵅⴹⴻⴱ ⵉ-ⵜⵜ ⵉ ⵎⵎⵉⵙ, ⴰⴷ ⴽⵉⴷⴻⵙ ⵢⴻⴳⴳ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴼⴰⵔⵉⴹⴰ ⵣⵉ ⵊⵊⵀⴻⵜ ⵏ ⵢⴻⴵⵉⵙ. ");
INSERT INTO rift_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","ⵎⴰⵍⴰ ⵉⴽⵙⵉ ⵜⴰⵎⵖⴰⵔⵜ ⵏⵏⴻⵖⵏⵉ ⵉ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵙ, ⵡⴰⵔ ⵉⵏⴻⵇⵇⴻⵚ ⵍⵄⵓⵍⵜ ⵏ ⵡⴻⵢⵙⵓⵎ ⵏⵏⴻⵙ, ⵏⵉⵖ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ, ⵏⵉⵖ ⵍⵄⴰⵛⴰⵔⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","ⵎⴰⵍⴰ ⵏⴻⵜⵜⴰ ⵡⴰⵔ ⴷ ⴰⵙ ⵉⴳⴳⵉ ⵜⵍⴰⵜⴰ-ⵢⴰ, ⵅⴻⵏⵏⵉ ⵏⴻⵜⵜⴰⵜ ⴰⴷ ⵜⴻⴼⴼⴻⵖ ⴱⴰⵟⴻⵍ, ⴱⵍⴰ ⵍⴻⵅⵔⴰⵚ.” ");
INSERT INTO rift_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵉⵡⵜⴻⵏ ⵃⴻⴷ ⴰⵍ ⵖⴰ ⵉⵎⵎⴻⵜ, ⴰⴷ ⵜ ⵏⵖⴻⵏ ⵏⵉⵛⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","ⵎⴰⵍⴰ ⵡⴰⵔ ⵜ ⵉⴳⴳⵉ ⵏⴻⵄⵎⴰⴷⴰ, ⵎⴰⵛⴰ ⴰⵔⴻⴱⴱⵉ ⵉⴳⴳⴰ ⴰⵙ-ⴷⴷ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏⵏⴻⵙ, ⵍⴻⵅⴷⴻⵏⵏⵉ ⵏⴻⵛⵛ ⴰⴷ ⴰⵛ ⵙⵙⴻⵛⵏⴻⵖ ⴰⵎⵛⴰⵏ ⵎⴰⵏⵉ ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵢⴰⵔⵡⴻⵍ. ");
INSERT INTO rift_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⵢⵓⴼⴼ ⵃⴻⴷ ⵅ ⵡⴰⵊⵊⴰⵔ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⵏⵖⴰ ⵉ-ⵜ ⵙ ⵍⴻⵖⴷⴰⵔⴻⵜ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜ ⵜⴻⴽⵙⵉⴷ ⵖⴰⵔ ⵓⵄⴰⵍⵟⴰⵔ ⵉⵏⵓ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜ ⵏⵖⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","ⵡⴻⵏⵏⵉ ⵉⵡⵜⵉⵏ ⴱⴰⴱⴰⵙ ⵏⵉⵖ ⵢⴻⵎⵎⴰⵙ, ⴰⴷ ⵉⵜⵜⵡⴰⵏⴻⵖ ⵏⵉⵛⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","ⵡⴻⵏⵏⵉ ⵢⵓⵛⴰⵔⴻⵏ ⴱⵏⴰⴷⴻⵎ ⵓⵛⴰ ⵉⵣⵣⴻⵏⵣ ⵉ-ⵜ, ⵏⵉⵖ ⵉⵜⵜⵡⴰⴼ ⵄⴰⴷ ⵖⴰⵔⴻⵙ, ⴰⴷ ⵉⵜⵜⵡⴰⵏⴻⵖ ⵏⵉⵛⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵉⵏⴻⵄⵍⴻⵏ ⴱⴰⴱⴰⵙ ⵏⵉⵖ ⵢⴻⵎⵎⴰⵙ, ⴰⴷ ⵉⵜⵜⵡⴰⵏⴻⵖ ⵏⵉⵛⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","ⵎⴰⵍⴰ ⵉⵔⵢⴰⵣⴻⵏ ⵎⵎⵛⵓⴱⴱⵛⴻⵏ ⵓⵛⴰ ⵉⵊⵊⴻⵏ ⵉⵡⵜⴰ ⵡⴻⵏⵏⴻⵖⵏⵉ ⵙ ⵡⴻⵥⵔⵓ ⵏⵉⵖ ⵙ ⵍⴱⵓⵏⵉⵢⵢⴻⵜ, ⵓⵛⴰ ⵡⴰⵏⵉⵜⴰ ⵡⴰⵔ ⵉⵎⵎⵓⵜ, ⵎⴰⵛⴰ ⵉⵡⴹⴰ ⴷⵉ ⵜⴰⵙⵙⵓⵜ, ");
INSERT INTO rift_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","ⵅⴻⵏⵏⵉ, ⵎⴰⵍⴰ ⵡⴰⵏⵉⵜⴰ ⵉⴽⴽⴰⵔ ⵄⴰⵡⴻⴷ ⵓⵛⴰ ⵢⵓⵢⵓⵔ ⵖⴰⵔ ⴱⴰⵔⵔⴰ ⵅ ⵜⴻⵖⵖⴰⵔⵛⵜ, ⴰⴷ ⵢⵉⵍⵉ ⵡⴻⵏⵏⵉ ⵜ ⵉⵡⵜⵉⵏ ⴷ ⴰⵎⴻⵣⴷⴰⴳ. ⴰⴷ ⴰⵙ ⵉⵅⴻⴵⴻⵚ ⵎⵖⵉⵔ ⵎⵉⵏ ⵢⴰⵔⴻⵢⵢⴻⵃ ⵓⵛⴰ ⴰⴷ ⵜ ⵢⴻⵊⵊ ⴰⴷ ⵉⴳⴳⴻⵏⴼⴰ ⵎⵍⵉⵃ. ");
INSERT INTO rift_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","ⵎⴰⵍⴰ ⵉⵡⵜⴰ ⵃⴻⴷ ⵉⵙⵎⴻⵖ ⵏⵏⴻⵙ ⵏⵉⵖ ⵜⴰⵢⵢⴰ ⵏⵏⴻⵙ ⵙ ⵡⴻⵄⵎⵓⴷ ⵓⵛⴰ ⵉⵎⵎⵓⵜ ⵙⴰⴷⵓ ⵓⴼⵓⵙ ⵏⵏⴻⵙ, ⵅⴻⵏⵏⵉ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⴰⵙ ⵢⴰⵖ ⵅ ⵜⴻⵙⵖⴰⵔⵜ ⵏⵏⴻⵙ ⵏⵉⵛⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⵉⵇⵇⵉⵎ ⵉⴱⴻⴷⴷ ⵉⵊⵊ ⵏⵉⵖ ⵜⵏⴰⵢⴻⵏ ⵏ ⵡⵓⵙⵙⴰⵏ, ⵡⴰⵔ ⴷ ⴰⵙ ⵢⵓⵖⵉ ⵜⴰⵙⵖⴰⵔⵜ, ⵎⵉⵏⵣⵉ ⵏⴻⵜⵜⴰ ⴷ ⵜⴰⵎⴻⵏⵢⴰⵜ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵏⵏⴻⵙ ⵉ ⵢⴻⴵⴰ. ");
INSERT INTO rift_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","ⵎⴰⵍⴰ ⵉⵔⵢⴰⵣⴻⵏ ⵎⵎⴻⵏⵖⴻⵏ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵛⵜ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⵙ ⴷⴷⴻⵢⵙⴻⵜ ⵓⵛⴰ ⵉⵡⴹⴰ ⴰⵙ-ⴷⴷ ⵓⵄⴻⴷⴷⵉⵙ ⵏⵏⴻⵙ, ⵎⴰⵛⴰ ⵡⴰⵔ ⵉⴵⵉ ⵛⴰ ⴷ ⴰⵢⴻⵣⵣⵉⵎ, ⵅⴻⵏⵏⵉ ⵏⴻⵜⵜⴰ ⴰⴷ ⵉⵅⴻⴵⴻⵚ ⵏⵉⵛⴰⵏ ⵉⵊⵊ ⵏ ⵎⵓⵍⵜⴰ ⵄⵍⴰⵃⵙⴰⴱ ⵎⵉⵏ ⴷ ⴰⵙ ⵖⴰ ⵉⵜⵜⴰⵔ ⵡⴻⵔⵢⴰⵣ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⵓⵛⴰ ⴰⴷ ⵜⵜ ⵉⵡⵛ ⵉ ⵍⵇⵓⴹⴰⵜ. ");
INSERT INTO rift_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","ⵎⴰⵍⴰ ⵉⵎⵙⴰⵔ ⵛⴰ ⵏ ⵓⵢⴻⵣⵣⵉⵎ ⴷ ⴰⵄⴻⴼⴼⴰⵏ, ⵍⴻⵅⴷⴻⵏⵏⵉ ⴰⴷ ⵜⴻⵡⵛⴻⴷ ⵜⵓⴷⴰⵔⵜ ⵙ ⵜⵓⴷⴰⵔⵜ, ");
INSERT INTO rift_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","ⵜⵉⵟⵟ ⵙ ⵜⵉⵟⵟ, ⵜⵉⵖⵎⴻⵙⵜ ⵙ ⵜⴻⵖⵎⴻⵙⵜ, ⴰⴼⵓⵙ ⵙ ⵓⴼⵓⵙ, ⴰⴹⴰⵔ ⵙ ⵓⴹⴰⵔ, ");
INSERT INTO rift_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","ⴰⵛⵎⴰⴹ ⵙ ⵡⴻⵛⵎⴰⴹ, ⴰⵢⴻⵣⵣⵉⵎ ⵙ ⵓⵢⴻⵣⵣⵉⵎ, ⵜⵉⵛⵜⵉ ⵙ ⵜⴻⵛⵜⵉ. ");
INSERT INTO rift_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","ⵎⴰⵍⴰ ⵉⵍⵇⴻⴼ ⵃⴻⴷ ⵜⵉⵟⵟ ⵏ ⵉⵙⵎⴻⵖ ⵏⵏⴻⵙ ⵏⵉⵖ ⵜⵉⵟⵟ ⵏ ⵜⴰⵢⵢⴰ ⵏⵏⴻⵙ, ⵉⴹⴻⵢⵢⴻⵄ ⵉ-ⵜⵜ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜ ⵢⴻⵊⵊ ⴰⴷ ⵢⵓⵢⵓⵔ ⴰⵎⴻⵏⵏⵉ ⵣⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⵜⵉⵟⵟ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","ⵎⴰⵍⴰ ⵙ ⵜⴻⵛⵜⵉ ⵉⵜⵜⴻⴽⴽⴻⵙ ⵜⵉⵖⵎⴻⵙⵜ ⵏ ⵉⵙⵎⴻⵖ ⵏⵏⴻⵙ, ⵏⵉⵖ ⵜⵉⵖⵎⴻⵙⵜ ⵏ ⵜⴰⵢⵢⴰ ⵏⵏⴻⵙ, ⵅⴻⵏⵏⵉ ⴰⴷ ⴰⵙ ⵢⴻⵊⵊ ⴰⴷ ⵢⵓⵢⵓⵔ ⴰⵎⴻⵏⵏⵉ ⵣⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⵜⴻⵖⵎⴻⵙⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","ⵎⴰⵍⴰ ⴰⴼⵓⵏⴰⵙ ⵉⴱⴰⵔⵔⴻⵣ ⴰⵔⵢⴰⵣ ⵏⵉⵖ ⵜⴰⵎⵖⴰⵔⵜ, ⵓ ⵡⴰⵏⵉⵜⴰ ⵉⵎⵎⵓⵜ, ⵅⴻⵏⵏⵉ ⴰⴷ ⴰⵔⵊⵎⴻⵏ ⴰⴼⵓⵏⴰⵙ ⵓ ⴰⵢⵙⵓⵎ ⵏⵏⴻⵙ ⵡⴰⵔ ⵣⵣⴰⵢⴻⵙ ⵜⵜᵉⵜⵜⴻⵏ. ⴱⴰⴱ ⵏ ⵓⴼⵓⵏⴰⵙ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⴰⴼⵓⵔⵔⵉ. ");
INSERT INTO rift_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⴰⴼⵓⵏⴰⵙ ⵜⵓⵖⴰ ⴷ ⴰⴱⴰⵔⵔⴻⵣ ⵉⴹⴻⵏⵏⴰⴹ ⴷ ⴼⴰⵔⵉⴹⴻⵏⵏⴰⴹ ⵓⵛⴰ ⴱⴰⴱ ⵏⵏⴻⵙ ⵜⵓⵖⴰ ⵉⵙⵙⴻⵏ ⵓⵛⴰ ⵡⴰⵔ ⵜ ⵉⵃⴹⵉ ⵓⵛⴰ ⵉⵏⵖⴰ ⴰⵔⵢⴰⵣ ⵏⵉⵖ ⵜⴰⵎⵖⴰⵔⵜ, ⵅⴻⵏⵏⵉ ⴰⴷ ⴰⵔⵊⵎⴻⵏ ⴰⴼⵓⵏⴰⵙ ⵓⵛⴰ ⵄⴰⵡⴻⴷ ⴰⴷ ⵏⵖⴻⵏ ⴱⴰⴱ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","ⵎⴰⵍⴰ ⴳⴳⵉⵏ ⵅⴰⵙ ⴷⴷⴻⵢⵢⴻⵜ, ⵍⴻⵅⴷⴻⵏⵏⵉ ⴰⴷ ⵉⵡⵛ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵅⴰⵙ ⴳⴳⵉⵏ ⴷ ⵜⵜⴰⵎⴰⵏ ⵏ ⵓⴼⴻⴽⴽⵉ ⵉ ⵜⵓⴷⴰⵔⵜ ⵏⵏⴻⵙ, ");
INSERT INTO rift_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","ⵏⵉⵖ ⵎⴰⵍⴰ ⴰⴼⵓⵏⴰⵙ ⵉⴱⴰⵔⵔⴻⵣ ⴰⵃⴻⵏⵊⵉⵔ ⵏⵉⵖ ⵜⴰⵃⴻⵏⵊⵉⵔⵜ. ⴰⴷ ⴰⵙ ⴳⴳⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴼⴰⵔⵉⴹⴰ-ⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","ⵎⴰⵍⴰ ⴰⴼⵓⵏⴰⵙ ⵉⴱⴰⵔⵔⴻⵣ ⵉⵙⵎⴻⵖ ⵏⵉⵖ ⵜⴰⵢⵢⴰ, ⴰⴷ ⵡⵛⴻⵏ ⵜⵍⴰⵜⵉⵏ ⵛⵉⵇⵍⵓ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵉ ⵙⵉⴷⵉⵙ, ⵓⵛⴰ ⴰⴼⵓⵏⴰⵙ ⴰⴷ ⵜ ⴰⵔⵊⵎⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","ⵎⴰⵍⴰ ⵢⴰⵔⵣⴻⵎ ⵃⴻⴷ ⴰⵏⵓ ⵏⵉⵖ ⵎⴰⵍⴰ ⵉⵖⵣⴰ ⵃⴻⴷ ⴰⵏⵓ ⵓⵛⴰ ⵡⴰⵔ ⵜ ⵉⴷⵍⵉ, ⵓⵛⴰ ⵉⵡⴹⴰ ⴷⴰⵢⴻⵙ ⵓⴼⵓⵏⴰⵙ ⵏⵉⵖ ⴰⵖⵢⵓⵍ, ");
INSERT INTO rift_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ⵅⴻⵏⵏⵉ ⴱⴰⴱ ⵏ ⵡⴰⵏⵓ ⴰⴷ ⵉⵅⴻⴵⴻⵚ. ⴰⴷ ⵢⴰⵔⵔ ⵏⵏⵓⵇⴰⵔⵜ ⵉ ⴱⴰⴱ ⵏⵏⴻⵙ ⵓⵛⴰ ⵍⴻⴱⵀⵉⵎⴻⵜ ⵉⵎⵎⵓⵜⴻⵏ ⴰⴷ ⵜⵉⵍⵉ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","ⵎⴰⵍⴰ ⴰⴼⵓⵏⴰⵙ ⵉⵢⵣⴻⵎ ⴰⴼⵓⵏⴰⵙ ⵏ ⵡⴰⵊⵊⴰⵔ ⵏⵏⴻⵙ ⴰⵍⴰⵎⵉ ⵉⵎⵎⵓⵜ, ⵍⴻⵅⴷⴻⵏⵏⵉ ⴰⴷ ⵣⵣⴻⵏⵣⴻⵏ ⴰⴼⵓⵏⴰⵙ ⵉⴷⴷⴰⵔⴻⵏ, ⴰⴷ ⴱⴹⴰⵏ ⵜⴰⵎⴻⵏⵢⴰⵜ-ⴰ ⵊⴰⵔ ⴰⵙⴻⵏ ⵓⵛⴰ ⴰⴷ ⴱⴹⴰⵏ ⵄⴰⵡⴻⴷ ⴰⴼⵓⵏⴰⵙ ⴰⵎⴻⵜⵜⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⵉⵙⵙⴻⵏ ⴱⴻⵍⵍⵉ ⴰⴼⵓⵏⴰⵙ ⵉⴱⴰⵔⵔⴻⵣ ⵉⴹⴻⵏⵏⴰⴹ ⴷ ⴼⴰⵔⵉⴹⴻⵏⵏⴰⴹ, ⵓⵛⴰ ⴱⴰⴱ ⵏⵏⴻⵙ ⵡⴰⵔ ⵜ ⵉⵃⴹⵉ, ⴰⴷ ⵉⵅⴻⴵⴻⵚ ⴰⴼⵓⵏⴰⵙ ⵙ ⵓⴼⵓⵏⴰⵙ ⵓⵛⴰ ⴰⴼⵓⵏⴰⵙ ⴰⵎⴻⵜⵜⵉⵏ ⴰⴷ ⵢⵉⵍⵉ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX21_37","003_21_37","EXO","21","37","37","ⵎⴰⵍⴰ ⵢⵓⵛⴰⵔ ⵃⴻⴷ ⴰⴼⵓⵏⴰⵙ ⵏⵉⵖ ⵉⵊⵊⴻⵏ ⵣⴻⴳ ⵡⵓⴵⵉ ⵓⵛⴰ ⵉⵖⴰⵔⵚ ⴰⵙ ⵏⵉⵖ ⵉⵣⵣⴻⵏⵣ ⵉ-ⵜ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⵅⴻⴵⴻⵚ ⵅⴻⵎⵙⴰ ⵏ ⵉⴼⵓⵏⴰⵙⴻⵏ ⵅ ⵢⵉⵊⵊ ⵏ ⵓⴼⵓⵏⴰⵙ ⵓ ⴰⵔⴻⴱⵄⴰ ⵏ ⵡⵓⴵⵉ ⵅ ⵢⵉⵊⵊⴻⵏ ⵏ ⵡⵓⴵⵉ.” ");
INSERT INTO rift_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“ⵎⴰⵍⴰ ⵉⵜⵜⵡⴰⴼ ⵓⵛⴻⴼⴼⴰⵔ ⵄⴰⴷ ⴰⵎ ⵉⵜⵜⴰⵛⴰⵔ, ⵓⵛⴰ ⵉⵡⵜⴰ ⵉ-ⵜ ⵓⵛⴰ ⵉⵎⵎⵓⵜ, ⵡⴰⵔ ⵜⵜⵉⵍⵉⵏ ⵉⴷⴰⵎⵎⴻⵏ ⵅ ⵡⴻⵏⵏⵉ ⵜ ⵢⵓⴼⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","ⵎⴰⵍⴰ ⵜⴻⵏⵇⴰⵔ-ⴷⴷ ⵅⴰⵙ ⵜⴼⵓⵛⵜ, ⴰⴷ ⵅⴰⵙ ⵉⵍⵉⵏ ⵉⴷⴰⵎⵎⴻⵏ ⴷⵉ ⵙⵙⵉⴱⴱⴻⵜ-ⴰ. ⴰⴷ ⴰⵙ ⵉⵅⴻⴵⴻⵚ ⵓⵛⴻⴼⴼⴰⵔ ⵎⴰⵔⵔⴰ. ⵎⴰⵍⴰ ⵡⴰⵔ ⵖⴰⵔⴻⵙ ⵛⴰ, ⴰⴷ ⵉⵎⵎⴻⵏⵣ ⴷⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⵜⵓⵛⵛⴻⴼⴼⵔⴰ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","ⵎⴰⵍⴰ ⵜᵉⵜⵜⵡⴰⴼ ⵜⵓⵛⵛⴻⴼⴼⴰⵔⵜ ⵜⴻⴷⴷⴰⵔ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏⵏⴻⵙ, ⵎⴰ ⴷ ⴰⴼⵓⵏⴰⵙ ⵉ ⵜⵜ ⵜⵓⵖⴰ ⵏⵉⵖ ⴷ ⴰⵖⵢⵓⵍ ⵏⵉⵖ ⴷ ⵉⵊⵊⴻⵏ ⵣⴻⴳ ⵡⵓⴵⵉ, ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⵙ ⴰⴷ ⵉⵅⴻⴵⴻⵚ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵙⴻⵇⵇⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","ⵎⴰⵍⴰ ⵉⵊⵊⴰ ⵃⴻⴷ ⴰⴷ ⵀⴻⴷⴷⴰⵏ ⵍⵎⴰⵍ ⵉⵢⵢⴰⵔ ⵏⵉⵖ ⴰⵎⴰⵔⵊⴻⵄ ⵏ ⵓⴹⵉⵍ ⵓⵛⴰ ⵢⴰⵔⵡⴻⵙ ⴷⴰⵢⴻⵙ ⵜⴰⵃⵉⵎⴰⵔⵜ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⴰⵙⴻⵏ ⵉⴹⵍⴻⵇ ⴰⵍⴰⵎⵉ ⴰⴷ ⵀⴻⴷⴷⴰⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵡⴻⵏⵏⴻⵖⵏⵉ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⵜ ⵉⵅⴻⴵⴻⵚ ⵣⵉ ⵍⴻⵎⵅⴻⵢⵢⴻⵔ ⵏ ⵢⴻⵢⵢⴰⵔ ⵏⵏⴻⵙ ⵓ ⵣⵉ ⵍⴻⵎⵅⴻⵢⵢⴻⵔ ⵏ ⵓⵎⴰⵔⵊⴻⵄ ⵏ ⵓⴹⵉⵍ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","ⵎⴰⵍⴰ ⵜⴻⴼⴼⴻⵖ-ⴷⴷ ⵜⵎⴻⵙⵙⵉ ⵓⵛⴰ ⵜⴻⵍⵇⴻⴼ ⴰⵙⴻⵏⵏⴰⵏ ⵓⵛⴰ ⵜⴻⵛⵛⴰ ⵜⵉⵇⴻⴱⴱⵉⴹⵉⵏ ⵏ ⵉⵎⴻⵏⴷⵉ ⵏⵉⵖ ⵉⵎⴻⵏⴷⵉ ⵉⴱⴻⴷⴷⴻⵏ ⵏⵉⵖ ⵉⵢⵢⴰⵔ, ⵅⴻⵏⵏⵉ ⵡⴻⵏⵏⵉ ⵉⵇⵇⴷⴻⵏ ⵜⵉⵎⴻⵙⵙⵉ ⴰⴷ ⵉⵅⴻⴵⴻⵚ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⵜⵜⵡⴰⵛⴻⵎⴹⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","ⵎⴰⵍⴰ ⵉⵃⴹⴰ ⵃⴻⴷ ⵉ ⵡⴰⵊⵊⴰⵔ ⵏⵏⴻⵙ ⵏⵏⵓⵇⴰⵔⵜ ⵏⵉⵖ ⵍⴻⵇⵛⵓⵄ ⵓ ⵎⴰⵏ ⴰⵢⴰ ⵉⵜⵜⵡⴰⵛⴰⵔ ⴰⵙ ⵣⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵡⴻⵔⵢⴰⵣ ⵏⵏⵉ, ⵅⴻⵏⵏⵉ ⴰⵛⴻⴼⴼⴰⵔ, ⵎⴰⵍⴰ ⵓⴼⵉⵏ ⵜ, ⴰⴷ ⵉⵅⴻⴵⴻⵚ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵙⴻⵇⵇⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","ⵎⴰⵍⴰ ⵡⴰⵔ ⵉⵜⵜⵡⵉⴼ ⵓⵛⴻⴼⴼⴰⵔ, ⵍⴻⵅⴷⴻⵏⵏⵉ ⴰⴷ ⵙⵙⵇⴰⵔⵔⴱⴻⵏ ⴱⴰⴱ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵖⴰⵔ ⴰⵔⴻⴱⴱⵉ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵙⵙⵏⴻⵏ ⵎⴰ ⵡⴰⵔ ⵉⵙⵙⵡⵉⵥⵥⴻⴹ ⵓⴼⵓⵙ ⵏⵏⴻⵙ ⵖⴰⵔ ⵡⴰⴳⵍⴰ ⵏ ⵡⴰⵊⵊⴰⵔ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","ⴽⵓⵍ ⴰⵄⴻⴷⴷⵉ ⵣⵉ ⵊⵊⵉⵀⴻⵜ ⵏ ⵓⴼⵓⵏⴰⵙ ⵏⵉⵖ ⵏ ⵡⴻⵖⵢⵓⵍ ⵏⵉⵖ ⵏ ⵉⵊⵊ ⵣⴻⴳ ⵡⵓⴵⵉ ⵏⵉⵖ ⵏ ⵡⴰⵔⵔⵓⴹ ⵏⵉⵖ ⵏ ⵎⵉⵏ ⵉⵡⴻⴷⴷⴰⵔⴻⵏ ⵉ ⵣⵣⴰⵢⴻⵙ ⵉⵏⵏⴰ ⵃⴻⴷ: ‘ⴰⵇⴰ-ⵜ ⴷ ⵡⴰ!’, ⴰⴷ ⴷⴷ-ⵜⴰⵙ ⵜⵎⴻⵙⵍⴰⵛⵜ ⵉ ⵉⴵⴰⵏ ⵊⴰⵔ ⴰⵙⴻⵏ ⵙ ⵜⵏⴰⵢⴻⵏ ⵣⵣⴰⵜ ⵉ ⵍⵇⵓⴹⴰⵜ ⵓⵛⴰ ⵡⴻⵏⵏⵉ ⴰⴷ ⵅⴰⵙ ⵃⴻⴽⵎⴻⵏ ⵍⵇⵓⴹⴰⵜ ⴰⴷ ⵉⵅⴻⴵⴻⵚ ⵉ ⵡⴰⵊⵊⴰⵔ ⵏⵏⴻⵙ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵙⴻⵇⵇⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","ⵎⴰⵍⴰ ⵉⵡⵛⴰ ⵃⴻⴷ ⵉ ⵡⴰⵊⵊⴰⵔ ⵏⵏⴻⵙ ⴰⵖⵢⵓⵍ ⵏⵉⵖ ⴰⴼⵓⵏⴰⵙ ⵏⵉⵖ ⵉⵊⵊ ⵏ ⵣⴻⴳ ⵡⵓⴵⵉ, ⵏⵉⵖ ⵎⴰⵎⵎⴻⵛ ⵎⴰ ⵜⴻⴳⴳⴰ ⵍⴻⴱⵀⵉⵎⴻⵜ, ⵃⵉⵎⴰ ⴰⴷ ⵜ ⵉⵃⴹⴰ ⵓⵛⴰ ⵉⵎⵎⵓⵜ ⵏⵉⵖ ⵢⴰⵔⵔⴻⵥ ⵏⵉⵖ ⵓⵛⴰⵔⴻⵏ ⵜ, ⴰⵎ ⵡⴰⵔ ⵉⵥⵔⵉ ⵃⴻⴷ, ");
INSERT INTO rift_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⵉⵍⵉ ⵜⵊⴰⴵⵉⵜ ⵖⴰⵔ ⵙⵉⴷⵉ ⵊⴰⵔ ⴰⵙⴻⵏ ⵙ ⵜⵏⴰⵢⴻⵏ ⴱⴻⵍⵍⵉ ⵡⴰⵔ ⵉⵙⵙⵡⵉⵥⵥⴻⴹ ⴰⴼⵓⵙ ⵏⵏⴻⵙ ⵖⴰⵔ ⵡⴰⴳⵍⴰ ⵏ ⵡⴰⵊⵊⴰⵔ ⵏⵏⴻⵙ. ⴱⴰⴱ ⵏⵏⴻⵙ ⴰⴷ ⵉⵇⴱⴻⵍ ⵜⴰⵊⴰⴵⵉⵜ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⵜⴰⴼ ⴱⵍⴰ ⵎⴰ ⴰⴷ ⵜ ⵉⵜⵜⵅⴻⴵⴻⵚ ⵡⴻⵏⵏⴻⵖⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⵉⵜⵜⵡⴰⵛⴰⵔ ⵏⵉⵛⴰⵏ ⵣⵣⴰⵢⴻⵙ, ⴷⵉ ⵍⵃⴰⵍⴰ-ⵢⴰ ⴰⴷ ⵉⵅⴻⴵⴻⵚ ⵉ ⴱⴰⴱ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","ⵎⴰⵍⴰ ⵉⴱⴰⵏ ⴰⵇⴰ ⵉⵜⵜⵡⴰⵎⴻⵣⵣⴻⵇ ⵏⵉⵛⴰⵏ, ⴰⴷ ⵜ ⵢⴰⵡⵉ ⴷ ⴱⵓⵔⵀⴰⵏ ⵓⵛⴰ ⵡⴰⵔ ⵉⵜⵜⵅⴻⴵⵉⵚ ⵎⵉⵏ ⵉⵜⵜⵡⴰⵎⴻⵣⵣⵇⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","ⵎⴰⵍⴰ ⵢⴰⵔⴹⴻⵍ ⵃⴻⴷ ⵛⴰ ⵅ ⵡⴰⵊⵊⴰⵔ ⵏⵏⴻⵙ ⵓⵛⴰ ⵜⴰⵔⵔⴻⵥ ⵏⵉⵖ ⵜⴻⵎⵎⵓⵜ ⴷⵉ ⵍⵖⴰⵢⴻⴱ ⵏ ⴱⴰⴱ ⵏⵏⴻⵙ, ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⵙ ⴰⴷ ⵜⵜ ⵉⵅⴻⴵⴻⵚ ⵎⴰⵔⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⴱⴰⴱ ⵏⵏⴻⵙ ⵜⵓⵖⴰ ⵉⵃⴹⴰⵔ, ⵡⴰⵔ ⵜⵜ ⵉⵜⵜⵅⵉⴵⴰⵚ. ⵎⴰⵍⴰ ⵜⵓⵖⴰ ⵉⵛⵔⴰ ⵜⵜ ⵅⴰⵙ, ⴰⴷ ⴷⴷ-ⵢⴰⵙ ⵅ ⵍⴻⵅⵍⴰⵚ ⵏⵏⴻⵙ.” ");
INSERT INTO rift_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","“ⵓⵛⴰ ⵎⴰⵍⴰ ⵉⵎⵎⴰⵔⴹⴻⵏ ⵃⴻⴷ ⵅ ⵛⴰ ⵏ ⵜⴻⵄⵣⴰⵍⴻⵛⵜ, ⵜⵓⵖⴰ ⵡⴰⵔ ⵜⵜ ⵉⵅⴹⵉⴱ ⵃⴻⴷ ⵄⴰⴷ, ⵓⵛⴰ ⵉⵟⵟⴻⵚ ⴰⴽⵉⴷⴻⵙ, ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⵙ ⴰⴷ ⴰⵙ ⵉⵡⵛ ⵚⵚⴰⴷⴰⵇ ⵉⵎⵓⵏ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⵜ ⵢⴰⵡⵉ ⴷ ⵜⴰⵎⵖⴰⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","ⵎⴰⵍⴰ ⴱⴰⴱⴰⵙ ⵡⴰⵔ ⵉⵅⵙ ⴰⴷ ⴰⵙ ⵜⵜ ⵉⵡⵛ, ⴰⴷ ⴰⵙ ⵉⵡⵣⴻⵏ ⵄⴰⴷ ⵚⵚⴰⴷⴰⵇ ⵏ ⵜⴻⵄⵣⵓⵔⴰⵢ ⵙ ⵏⵏⵓⵇⴰⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","ⵡⴰⵔ ⵜⵜⴻⵊⵊⵉ ⵜⴰⵙⴻⵃⵃⴰⵔⵜ ⴰⴷ ⵜⴻⴷⴷⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","ⵎⴰⵏ ⵡⴻⵏ ⵉ ⵖⴰ ⵉⵟⵟⵚⴻⵏ ⴰⴽ-ⴷ ⵉⵊⵊ ⵏ ⵍⵎⴰⵍ, ⴰⴷ ⵜ ⵏⵖⴻⵏ ⵏⵉⵛⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵉⵡⴻⵀⵀⴱⴻⵏ ⵛⴰ ⵏ ⵜⵖⴰⵔⵚⵜ ⵉ ⵉⵔⴻⴱⴱⵉⵜⴻⵏ, ⵡⴰⵔ ⵉⴵⵉ ⵎⵖⵉⵔ ⵉ ⵙⵉⴷⵉ ⵡⴰⵀⴰ, ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵉⵜⵜⵡⴰⵃⴰⵔⵔⴻⵎ ⵉ ⵓⵜⴻⵃⵃⵉ. ");
INSERT INTO rift_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","ⵡⴰⵔ ⴷⴷⴻⴵⴻⵎ ⴰⴱⴰⵔⵔⴰⵏⵉ ⵓ ⵡⴰⵔ ⵅⴰⵙ ⵜⵜⵣⴻⵢⵢⴰⵔⴻⵎ, ⵎⵉⵏⵣⵉ ⵜⵓⵖⴰ ⵓⵍⴰ ⴷ ⴽⴻⵏⵏⵉⵡ ⴷ ⵉⴱⴰⵔⵔⴰⵏⵉⵢⵢⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","ⵡⴰⵔ ⵜⵜⴷⴻⴵⵉ ⵛⴰ ⵉⵛⵜ ⵏ ⵜⴰⵊⵊⴰⵍⵜ ⵏⵉⵖ ⵉⵊⵊ ⵏ ⵓⵢⵓⵊⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","ⵎⴰⵍⴰ ⵜⵉⵡⴹⴻⴷ ⴰⴷ ⵜ ⵜⴻⵙⵙⴻⵃⵇⴰⵔⴻⴷ ⴰⵟⵟⴰⵙ ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵉⵙⵖⵓⵢ-ⴷⴷ ⵖⴰⵔⵉ, ⴰⵇⴰ ⵏⴻⵛⵛ ⵙ ⵓⵖⵉⵍ ⴰⴷ ⵙⵍⴻⵖ ⵉ ⵜⵖⵓⵢⵢⵉⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","ⴰⴷ ⵢⴰⵔⴻⵖ ⵡⴻⵖⴹⴰⴱ ⵉⵏⵓ ⵓⵛⴰ ⵏⴻⵛⵛ ⴰⴷ ⴽⴻⵏⵏⵉⵡ ⵏⵖⴻⵖ ⵙ ⵙⵙⵉⴼ, ⵜⵉⵎⴻⵟⵟⴰ ⵏⵡⴻⵎ ⴰⴷ ⴷⴻⵡⵍⴻⵏⵜ ⴷ ⵜⵉⵊⵊⴰⵍ ⴷ ⵜⴰⵔⵔⴰⵡⵜ ⵏⵡⴻⵎ ⴷ ⵉⵢⵓⵊⵉⵍⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","ⵎⴰⵍⴰ ⵜⴰⵔⴻⴹⵍⴻⴷ ⵏⵏⵓⵇⴰⵔⵜ ⵉ ⵍⴳⴻⵏⵙ ⵉⵏⵓ, ⵉ ⵓⵎⴻⵣⵍⵓⴹ ⵉ ⴷⵉⵏ ⵖⴰⵔⴻⴽ, ⵅⴻⵏⵏⵉ ⵡⴰⵔ ⴽⵉⴷⴻⵙ ⵜⵜⴻⴳⴳⴻⴷ ⴰⵎ ⵉⵜⵜⴻⴳⴳ ⴱⴰⴱ ⵏ ⵓⵎⴰⵔⵡⴰⵙ: ⵡⴰⵔ ⵅⴰⵙ ⵜⵜⴻⴳⴳ ⵛⴰ ⴰⵔⵔⵉⴱⴰ. ");
INSERT INTO rift_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","ⵎⴰⵍⴰ ⵜⴻⴽⵙⵉⴷ ⴰⵔⵔⵓⴹ ⵏ ⵡⴰⵊⵊⴰⵔ ⵏⵏⴻⵛ ⴷ ⴰⴹⵎⴰⵏ, ⴰⵔⵔ ⴰⵙ ⵜ ⵇⴱⴻⵍ ⵎⴰ ⴰⴷ ⵜⴻⵖⵍⵉ ⵜⴼⵓⵛⵜ. ");
INSERT INTO rift_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","ⵎⵉⵏⵣⵉ ⵡⴰⵔ ⵖⴰⵔⴻⵙ ⵎⵖⵉⵔ ⴰⵍⴻⵃⵃⴰⴼ ⵡⴰⵏⵉⵜⴰ, ⴰⵇⴰ-ⵜ ⴷ ⴰⵔⵔⵓⴹ ⵅ ⵜⴻⵍⵎⴻⵛⵜ ⵏⵏⴻⵙ. ⵎⵉⵏ ⴷⵉ ⵖⴰ ⵉⵟⵟⴻⵚ ⵅⴻⵏⵏⵉ? ⵅⵎⵉ ⵖⴰⵔⵉ ⴷⴷ ⵖⴰ ⵉⵙⵖⵓⵢ, ⵍⴻⵅⴷⴻⵏⵏⵉ ⴰⴷ ⴰⵙ ⵙⵍⴻⵖ, ⵎⵉⵏⵣⵉ ⵏⴻⵛⵛ ⴰⵇⴰ ⴷ ⴰⵃⵏⵉⵏ! ");
INSERT INTO rift_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","ⵡⴰⵔ ⵜⵜⵛⴻⵇⵇⵉⴼ ⴷⵉ ⴰⵔⴻⴱⴱⵉ ⵓ ⵡⴰⵔ ⵜⵜⴻⴽⴽⵯⴰⵔ ⵍⵃⴰⴽⴻⵎ ⵏ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","ⵡⴰⵔ ⵙⵄⴻⵟⵟⴰⵍⴰ ⵜⴰⵛⵛⵓⵔⴻⵜ ⵏ ⵜⵎⴻⵢⵔⴰ ⵏⵏⴻⵛ ⵏⵉⵖ ⴰⵃⵍⴰⵢ ⵏ ⵜⴻⵢⵙⴰⵔⵜ ⵏⵏⴻⵛ. ⴰⴷ ⴰⵢⵉ ⵜⴻⵡⵛⴻⴷ ⵓⵍⴰ ⴷ ⴰⵎⴻⵏⵣⵓ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵜⴻⴳⴳⴻⴷ ⵄⴰⵡⴻⴷ ⵙ ⵉⴼⵓⵏⴰⵙⴻⵏ ⵏⵏⴻⵛ ⴷ ⵡⵓⴵⵉ ⵏⵏⴻⵛ. ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⴰⴷ ⵉⵍⵉⵏ ⴰⴽ-ⴷ ⵢⴻⵎⵎⴰⵜⵙⴻⵏ ⵓⵛⴰ ⵖⴰⵔ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵜⵎⴻⵏⵢⴰ ⴰⴷ ⴰⵢⵉ ⵜⴻⵏ ⵜⴻⵡⵛⴻⴷ. ");
INSERT INTO rift_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","ⴰⴷ ⴰⵢⵉ ⵜⵉⵍⵉⵎ ⴷ ⵉⵎⵇⴻⴷⴷⴰⵙⴻⵏ ⵓ ⵡⴰⵔ ⵜⵜᵉⵜⵜⴻⵎ ⴰⵢⵙⵓⵎ ⵉ ⵉⵜⵜⵡⴰⵎⴻⵣⵣⵇⴻⵏ ⴷⵉ ⵍⴻⵅⵍⴰ. ⴰⴷ ⵜ ⵜⴻⵏⴹⴰⵔⴻⵎ ⵉ ⵢⵉⵟⴰⵏ.”    ");
INSERT INTO rift_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“ⵡⴰⵔ ⵙⵙⵓⴼⴼⵓⵖ ⵍⴻⵅⴱⴰⵔ ⵉⵙⵙⵅⴰⵔⵔⵉⵇⴻⵏ. ⵡⴰⵔ ⵜⵜⵉⵛ ⴰⴼⵓⵙ ⵏⵏⴻⵛ ⵉ ⵓⵄⴻⴼⴼⴰⵏ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⵉⵍⵉⴷ ⴷ ⴰⵛⴻⵀⵀⴰⴷ ⵏ ⴷⴷⴻⴵ. ");
INSERT INTO rift_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","ⵡⴰⵔ ⴰⵔⴻⴷⴷⴻⴼ ⴰⵣⵢⴻⵏ ⴰⵎⴻⵇⵇⵔⴰⵏ ⴷⵉ ⵍⵖⴰⵔ ⵓ ⵡⴰⵔ ⴷⴷ-ⵜⵜⴰⵔⵔⵉ ⴷⵉ ⴷⴷⴻⵄⵡⴻⵜ ⴰⵍ ⵖⴰ ⵜⵎⴻⵢⵢⵍⴻⴷ ⵜⴻⴳⴳⵯⴻⵊⴻⴷ ⵅ ⵍⵃⴻⵇⵇ ⴰⵡⴰⵔⵏⵉ ⵉ ⵡⴰⵟⵟⴰⵙ, ⴰⴷ ⵜⴼⴰⵔⵖⴻⴷ ⵍⵃⴻⵇⵇ. ");
INSERT INTO rift_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","ⴷⵉ ⴷⴷⴻⵄⵡⴻⵜ ⵏⵏⴻⵙ ⵡⴰⵔ ⵜⵜⵔⵉⵃ ⵛⴰ ⴰⴽ-ⴷ ⵍⵎⴻⵙⴽⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","ⵎⴰⵍⴰ ⵜⴻⵍⵇⵉⴷ ⴰⴼⵓⵏⴰⵙ ⵏⵉⵖ ⴰⵖⵢⵓⵍ ⵉⵡⴻⴷⴷⴰⵔ ⵏ ⵍⴻⵄⴷⵓ ⵏⵏⴻⵛ, ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⴰⵙ ⵜ ⵜⴰⵔⵔⴻⴷ ⵏⵉⵛⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","ⵎⴰⵍⴰ ⵜⴻⵥⵔⵉⴷ ⴰⵖⵢⵓⵍ ⵏ ⵡⴻⵏⵏⵉ ⵜⵛⴰⵔⵔⵀⴻⴷ ⵉⵡⴹⴰ ⵙ ⴷⴷⵇⴻⵍ ⵏⵏⴻⵙ, ⵉⵜⵜⵅⴻⵚⵚⴰ ⵛⴻⴽ ⴰⴷ ⵜⴻⵃⴹⵉⴷ ⵉⵅⴻⴼ ⵏⵏⴻⵛ ⴰⴷ ⵜⴻⵊⵊⴻⴷ ⵜⴰⵎⴻⵙⵍⴰⵛⵜ ⵉ ⵏⴻⵜⵜⴰ ⵡⴰⵀⴰ, ⵎⴰⵛⴰ ⵛⴻⴽ ⴷ ⵏⴻⵜⵜⴰ ⵊⵎⵉⵄ ⴰⴷ ⵜⴼⴻⴽⴽⴻⵎ ⴰⵖⵢⵓⵍ ⵇⴰⵄ. ");
INSERT INTO rift_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","ⵡⴰⵔ ⵙⴼⴰⵔⵔⴰⵖ ⵜⴰⵙⵖⴰⵔⵜ ⵏ ⵓⵎⴻⵣⵍⵓⴹ ⵉ ⴷⵉⵏ ⵖⴰⵔⴻⴽ ⴷⵉ ⴷⴷⴻⵄⵡⴻⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","ⴱⴻⵄⵄⴻⴷ ⵅ ⵜⵎⴻⵙⵍⴰⵛⵜ ⵉⵖⴻⵛⵛⴻⵏ. ⵡⴰⵔ ⵏⴻⵇⵇ ⴰⴼⵓⵔⵔⵉ ⵏⵉⵖ ⴰⵎⵙⴻⴳⴳⴻⴷ, ⵎⵉⵏⵣⵉ ⵏⴻⵛⵛ ⵡⴰⵔ ⵜⵜⴱⴰⵔⵔⵉⵖ ⴰⵄⴻⴼⴼⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","ⵡⴰⵔ ⴽⴻⵙⵙⵉ ⵜⴰⵔⵣⴻⴼⵜ, ⵎⵉⵏⵣⵉ ⵜⴰⵔⵣⴻⴼⵜ ⵜⴻⵙⵙⴷⴰⵔⵖⴰⵍ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵢⴰⵔⴻⵣⵎⴻⵏ ⵓ ⵜⴻⵙⵙⴼⴰⵔⵔⴰⵖ ⴰⵡⴰⵍⴻⵏ ⵏ ⵉⵎⵙⴻⴳⴳⴷⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","ⵡⴰⵔ ⵜⵣⴻⵢⵢⴰⵔⴻⵎ ⵅ ⵓⴱⴰⵔⵔⴰⵏⵉ. ⴰⵇⴰ ⴽⴻⵏⵏⵉⵡ ⵜⴻⵙⵙⵏⴻⵎ ⵏⵏⴻⴼⵙ ⵏ ⵓⴱⴰⵔⵔⴰⵏⵉ, ⵎⵉⵏⵣⵉ ⵜⵓⵖⴰ ⴽⴻⵏⵏⵉⵡ ⴷ ⵉⴱⴰⵔⵔⴰⵏⵉⵢⵢⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","ⵙⴻⵜⵜⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⴰⴷ ⵜⵣⴰⵔⵄⴻⴷ ⵜⴰⵎⵎⵓⵔⵜ ⵏⵏⴻⵛ ⵓⵛⴰ ⴰⴷ ⵜⴻⵙⵙⵎⵓⵏⴻⴷ ⵍⵖⵉⴵⴻⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","ⴷⴻⴳ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ ⴰⴷ ⵜⵜ ⵜⴻⵊⵊⴻⴷ ⴰⴷ ⵜⴰⵔⴻⵢⵢⵃⴻⴷ ⵓⵛⴰ ⴰⴷ ⴰⵙ ⵜⴰⵔⵅⵓⴷ, ⵃⵉⵎⴰ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵛⵛⴻⵏ ⵉⵎⴻⵣⵍⴰⴹ ⵏ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵛ. ⵓⵛⴰ ⵎⵉⵏ ⵖⴰ ⵊⵊⴻⵏ ⵏⵉⵜⵏⵉ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵛⵛⴻⵏ ⵍⵎⴰⵍ ⵏ ⵍⴻⵅⵍⴰ. ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵜⴻⴳⴳⴻⴷ ⵄⴰⵡⴻⴷ ⵙ ⵓⵎⴰⵔⵊⴻⵄ ⵏ ⵓⴹⵉⵍ ⵏⵏⴻⵛ ⴷ ⵣⵣⵉⵜⵓⵏ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","ⴷⵉ ⵙⴻⵜⵜⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵍⵅⴻⴷⵎⴻⵜ ⵏⵏⴻⵛ ⵓ ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ ⴰⴷ ⵜⴰⵔⴻⵢⵢⵃⴻⴷ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵢⴰⵔⴻⵢⵢⴻⵃ ⵓⴼⵓⵏⴰⵙ ⵏⵏⴻⵛ ⴷ ⵡⴻⵖⵢⵓⵍ ⵏⵏⴻⵛ ⵓ ⴰⴷ ⵢⴰⵔⵔ ⵏⵏⴻⴼⵙ ⵎⵎⵉⵙ ⵏ ⵜⴰⵢⵢⴰ ⵏⵏⴻⵛ ⴷ ⵓⴱⴰⵔⵔⴰⵏⵉ.” ");
INSERT INTO rift_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","ⴷⵉ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴷ ⴰⵡⴻⵎ ⵏⵏⵉⵖ, ⵃⴹⴰⵎ ⵜ. ⵡⴰⵔ ⵜⵜⵉⴷⴰⵔⴻⵎ ⵉⵙⴻⵎ ⵏ ⵉⵔⴻⴱⴱⵉⵜⴻⵏ ⵏⵏⴻⵖⵏⵉ. ⵡⴰⵔ ⵜⵜⴻⵙⵍⴰⵏ ⵉⵙⴻⵎ ⵏⵏⴻⵙ ⵣⴻⴳ ⵓⵇⴻⵎⵎⵓⵎ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","ⵜⵍⴰⵜⴰ ⵏ ⵜⵡⴰⵍⴰⵡⵉⵏ ⴷⴻⴳ ⵓⵙⴻⴳⴳⵯⴰⵙ ⴰⴷ ⴰⵢⵉ ⵜⵄⴻⵢⵢⴷⴻⵎ ⵉⵊⵊ ⵏ ⵍⵄⵉⴷ. ");
INSERT INTO rift_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","ⵍⵄⵉⴷ ⵏ ⵡⴻⵖⵔⵓⵎ ⴱⵍⴰ ⴰⵏⵜⵓⵏ ⴰⴷ ⵜ ⵜⴻⵃⴹⴰⵎ. ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⴰⴷ ⵜⴻⵛⵛⴻⴷ ⴰⵖⵔⵓⵎ ⴱⵍⴰ ⴰⵏⵜⵓⵏ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴽⴻⵏⵏⵉⵡ ⵓⵎⵓⵔⴻⵖ ⵏⴻⵛⵛ, ⴷⵉ ⵍⵡⴻⵇⵜ ⵉⵜⵜⵡⴰⴳⴳⴻⵏ ⴷⴻⴳ ⵓⵢⵓⵔ ⴰⴱⵉⴱ, ⵎⵉⵏⵣⵉ ⴷⴰⵢⴻⵙ ⵉ ⴷⴷ-ⵜⴻⴼⴼⵖⴻⴷ ⵣⵉ ⵎⵉⵚⵔⴰ. ⵡⴰⵔ ⴷⴷ-ⵜⵜⵓⵙⵉⵎ ⵙ ⵉⴼⴰⵙⵙⴻⵏ ⵅⵡⴰⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵉⵏⵓ. ");
INSERT INTO rift_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","ⵃⴹⴰⵎ ⵄⴰⵡⴻⴷ ⵍⵄⵉⴷ ⵏ ⵜⵎⴻⵢⵔⴰ, ⵍⵄⵉⴷ ⵏ ⵜⵎⴻⵏⵣⵓⵜ ⵏ ⵍⵅⴻⴷⵎⴻⵜ ⵏⵏⴻⵛ ⵉ ⵜⵣⴰⵔⵄⴻⴷ ⴷⴻⴳ ⵉⵢⵢⴰⵔ, ⵓ ⵍⵄⵉⴷ ⵏ ⵓⵙⵎⵓⵏⵉ ⵏ ⵚⵚⴰⴱⴻⵜ ⴷⴻⴳ ⵓⵏⴻⴳⴳⴰⵔ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ, ⵅⵎⵉ ⵖⴰ ⵜⴻⵙⵙⵎⵓⵏⴻⴷ ⵍⵖⵉⴵⴻⵜ ⵏ ⵍⵅⴻⴷⵎⴻⵜ ⵏⵏⴻⵛ ⵣⴻⴳ ⵉⵢⵢⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","ⵜⵍⴰⵜⴰ ⵏ ⵜⵡⴰⵍⴰⵡⵉⵏ ⴷⴻⴳ ⵓⵙⴻⴳⴳⵯⴰⵙ ⴰⴷ ⴹⵀⴰⵔⴻⵏ ⵎⴰⵔⵔⴰ ⵉⵔⵢⴰⵣⴻⵏ ⵏ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵛ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ, ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","ⵡⴰⵔ ⵜⵜⵇⴻⴷⴷⴰⵎ ⵉⴷⴰⵎⵎⴻⵏ ⵏ ⵜⵖⴰⵔⵚⵜ ⵉⵏⵓ ⴰⴽ-ⴷ ⵎⵉⵏ ⵉⵅⴻⵎⵎⴰⵔⴻⵏ, ⵓ ⵜⴰⴷⵓⵏⵜ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵍⵄⵉⴷ ⵉⵏⵓ ⵡⴰⵔ ⵜⵜⵏⵓⵙⵉ ⴵⵉⵍⴻⵜ ⵜⴻⴽⵎⴻⵍ ⴰⵍ ⵚⵚⴱⴻⵃ. ");
INSERT INTO rift_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","ⵜⴰⵎⴻⵣⵡⴰⵔⵓⵜ ⵏ ⵜⵎⴻⵏⵣⵓⵜ ⵣⴻⴳ ⵡⵓⴷⴻⵎ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⴻⵛ ⴰⴷ ⵜⵜ ⵜⴰⵡⵢⴻⴷ ⵖⴰⵔ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵛ. ⵡⴰⵔ ⵙⵏⴻⵏⵏⵉ ⵉⵖⴰⵢⴹ ⴷ ⴰⵎⴻⵥⵢⴰⵏ ⵙ ⵓⵖⵉ ⵏ ⵢⴻⵎⵎⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","ⵅⵣⴰⵔ, ⴰⴷ ⵙⵙⴻⴽⴽⴻⵖ ⵉⵊⵊ ⵏ ⵍⵎⴰⵍⴰⴽ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏⵏⴻⵛ, ⵃⵉⵎⴰ ⴰⴷ ⵛⴻⴽ ⵉⵃⴹⴰ ⴷⴻⴳ ⵡⴻⴱⵔⵉⴷ ⵓⵛⴰ ⴰⴷ ⵛⴻⴽ ⵢⴰⵡⵉ ⵖⴰⵔ ⵡⴻⵎⵛⴰⵏ ⵏⵏⵉ ⵙⵙⵡⴻⵊⴷⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","ⵃⴹⴰ ⴰⵔⴻⵏⴷⴰⴷ ⵉ ⵡⵓⴷⴻⵎ ⵏⵏⴻⵙ ⵓⵛⴰ ⵙⴻⵍ ⵉ ⵡⴰⵡⴰⵍ ⵏⵏⴻⵙ, ⵡⴰⵔ ⵅⴰⵙ ⵙⵙⴰⵔⵣⵉⴳ ⵛⴰ ⵍⴻⵄⵎⴰⵔ, ⵎⵉⵏⵣⵉ ⵏⴻⵜⵜⴰ ⵡⴰⵔ ⵉⵜⵜⴻⴽⴽⴻⵙ ⵉⵄⴻⴷⴷⵉⵢⴻⵏ ⵏⵡⴻⵎ, ⵎⵉⵏⵣⵉ ⵉⵙⴻⵎ ⵉⵏⵓ ⴰⵇⴰ-ⵜ ⴷⴰⵢⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⵙ ⵜⵉⴷⴻⵜⵜ ⴰⴷ ⵜⴻⵙⵍⴻⴷ ⵉ ⵡⴰⵡⴰⵍ ⵏⵏⴻⵙ, ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴷ ⴰⵛ ⵖⴰ ⵉⵏⵉⵖ, ⴰⴷ ⵉⵍⵉⵖ ⴷ ⵍⴻⵄⴷⵓ ⵉ ⵍⵄⴻⴷⵢⴰⵏ ⵏⵏⴻⵛ ⵓⵛⴰ ⴰⴷ ⵃⵚⴰⵔⴻⵖ ⵉⵏⵏⵉ ⵛⴻⴽ ⵉⵃⴻⵚⵚⴰⵔⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","ⵎⵉⵏⵣⵉ ⵍⵎⴰⵍⴰⴽ ⵉⵏⵓ ⴰⴷ ⵢⵉⵍⵉ ⵣⵣⴰⵜⴻⴽ, ⴰⴷ ⵛⴻⴽ ⵙⵙⵉⴷⴼⴻⵖ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵉⵎⵓⵔⵉⵢⵢⴻⵏ ⴷ ⵉⵃⵉⵜⵜⵉⵢⵢⴻⵏ ⴷ ⵉⴼⵉⵔⵉⵣⵉⵢⵢⴻⵏ ⴷ ⴰⵢⵜ ⵏ ⴽⴻⵏⵄⴰⵏ ⴷ ⵉⵃⵉⵡⵉⵢⵢⴻⵏ ⴷ ⵉⵢⴰⴱⵓⵙⵉⵢⵢⴻⵏ, ⵓ ⵏⴻⵛⵛ ⴰⴷ ⵜⴻⵏ ⵜⴻⵃⵃⵉⵖ. ");
INSERT INTO rift_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","ⵡⴰⵔ ⵜⵜⴱⴻⵏⴷⵉⵇ ⵉ ⵉⵔⴻⴱⴱⵉⵜⴻⵏ ⵏⵙⴻⵏ ⵏⵉⵖ ⴰⴷ ⵜⴻⵏ ⵜⵄⴻⴱⴷⴻⴷ ⵏⵉⵖ ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⴰⵎ ⵜⵜⴻⴳⴳⴻⵏ ⵏⵉⵜⵏⵉ, ⵎⴰⵛⴰ ⴰⴷ ⵜⴻⵏ ⵜᵉⵜⴻⵃⵃⵉⴷ ⵇⴰⵄ ⵓⵛⴰ ⴰⴷ ⵜⴰⵔⵥⴻⴷ ⵎⴰⵔⵔⴰ ⵉⵎⴰⵢⴹⵓⵜⴻⵏ ⵏⵙⴻⵏ ⵉⵇⴻⴷⴷⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","ⴰⴷ ⵜⵄⴻⴱⴷⴻⵎ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ, ⵓ ⵏⴻⵜⵜⴰ ⴰⴷ ⵉⴱⴰⵔⴻⴽ ⴰⵖⵔⵓⵎ ⵏⵏⴻⵛ ⴷ ⵡⴰⵎⴰⵏ ⵏⵏⴻⵛ. ⵏⴻⵛⵛ ⴰⴷ ⴽⴽⵙⴻⵖ ⵍⴻⵀⵍⴰⵛⴰⵜ ⵣⵉ ⵍⵡⴻⵙⵟ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","ⵡⴰⵔ ⵜⵜⵉⵍⵉ ⵜⴻⵎⵖⴰⵔⵜ ⵏⵏⵉ ⵓⵎⵉ ⵉⵡⴹⴰ ⵓⵄⴻⴷⴷⵉⵙ ⵏⵉⵖ ⵡⴰⵔ ⵉⵜⵜⵉⵔⵡⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⴻⵛ. ⵏⴻⵛⵛ ⴰⴷ ⴽⴻⵎⵎⵍⴻⵖ ⵍⵇⴻⴷⴷ ⵏ ⵡⵓⵙⵙⴰⵏ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","ⴰⴷ ⵙⵙⴻⴽⴽⴻⵖ ⴰⵏⴻⵅⵍⵉⵄ ⵣⵣⴰⵜ ⵉ ⵓⵖⴻⵎⴱⵓⴱ ⵏⵏⴻⵛ, ⴰⴷ ⵙⵙⵅⴰⵔⴻⵡⴹⴻⵖ ⵎⴰⵔⵔⴰ ⵍⴳⴻⵏⵙ ⵉ ⵖⴰ ⵜⴰⴼⴻⴷ ⴷⴻⴳ ⵡⴻⴱⵔⵉⴷ ⵏⵏⴻⵛ ⵓⵛⴰ ⴰⴷ ⴰⵔⵔⴻⵖ ⵎⴰⵔⵔⴰ ⵍⵄⴻⴷⵢⴰⵏ ⵏⵏⴻⵛ ⴰⴷ ⵅⴰⴽ ⴰⵔⴻⵡⵍⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","ⵏⴻⵛⵛ ⴰⴷ ⵙⵙⴻⴽⴽⴻⵖ ⵉⵔⴻⵣⵣⴰⵏ ⵣⵣⴰⵜ ⵉ ⵓⵖⴻⵎⴱⵓⴱ ⵏⵏⴻⵛ, ⵉⵏⵏⵉ ⵖⴰ ⵢⴰⵥⵥⵍⴻⵏ ⵅ ⵉⵃⵉⵡⵉⵢⵢⴻⵏ ⴷ ⴰⵢⵜ ⵏ ⴽⴻⵏⵄⴰⵏ ⴷ ⵉⵃⵉⵜⵜⵉⵢⵢⴻⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","ⵡⴰⵔ ⵅⴰⵙⴻⵏ ⵜⵜⴰⵥⵥⵍⴻⵖ ⵣⵉ ⵣⵣⴰⵜ ⵏⵡⴻⵎ ⴷⴻⴳ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ, ⵎⴰⵃⴻⵏⴷ ⵡⴰⵔ ⵜᵉⵜⵜⵖⵉⵎⵉ ⵜⴻⵎⵎⵓⵔⵜ ⴷ ⵍⴻⵅⵍⴰ ⵓ ⵍⵎⴰⵍ ⵏ ⵍⴻⵅⵍⴰ ⵡⴰⵔ ⵅⴰⴽ ⵜⵜⵎⴰⵔⵏⵉⵏ ⴰⵟⵟⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","ⵙ ⵛⵡⴰⵢ ⵛⵡⴰⵢ ⴰⴷ ⵅⴰⵙⴻⵏ ⴰⵥⵥⵍⴻⵖ ⵣⵉ ⵣⵣⴰⵜ ⵏⴻⵛⵛ, ⴰⵍ ⵖⴰ ⵜⴻⵎⵎⴰⵔⴻⵏⵢⴻⴷ ⴷⴻⴳ ⵡⴰⵟⵟⴰⵙ ⵓⵛⴰ ⴰⴷ ⵜⵣⴻⵎⵎⴰⵔⴻⴷ ⴰⴷ ⵜⴻⴽⵙⵉⴷ ⵜⴰⵎⵎⵓⵔⵜ ⴷ ⵍⵡⴰⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","ⵏⴻⵛⵛ ⴰⴷ ⴳⴳⴻⵖ ⵉⵢⵎⵉⵔⴻⵏ ⵣⵉ ⵍⴻⴱⵃⴰⵔ ⵏ ⵜⴻⵍⴳⴰ ⴰⵍ ⵍⴻⴱⵃⴰⵔ ⵏ ⵉⴼⵉⵍⵉⵙⵟⵉⵏⵉⵢⵢⴻⵏ ⵓ ⵣⵉ ⵍⴻⵅⵍⴰ ⴰⵍ ⵉⵖⵣⴰⵔ ⵏ ⵍⴼⵓⵔⴰⵟ, ⵎⵉⵏⵣⵉ ⴰⴷ ⴰⵔⵔⴻⵖ ⵉⵎⴻⵣⴷⴰⵖ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏⵏⴻⵛ ⵓⵛⴰ ⴰⴷ ⵛⴻⴽ ⴰⵔⵔⴻⵖ ⴰⴷ ⵅⴰⵙⴻⵏ ⵜⴰⵥⵥⵍⴻⴷ ⵣⵉ ⵣⵣⴰⵜ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","ⵡⴰⵔ ⴽⵉⴷⵙⴻⵏ ⵜⵜⴻⴳⴳ ⵍⵄⴰⵀⴷ ⵏⵉⵖ ⴰⴽ-ⴷ ⵉⵔⴻⴱⴱⵉⵜⴻⵏ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","ⵡⴰⵔ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⵣⴻⴷⵖⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⴻⵛ, ⵃⵉⵎⴰ ⵡⴰⵔ ⵛⴻⴽ ⵜⵜⴰⵔⵔⵉⵏ ⴰⴷ ⴰⴽⵉⴷⵉ ⵜⴻⵅⴹⵉⴷ. ⵎⴰⵍⴰ ⵜⵄⴻⴱⴷⴻⴷ ⵉ ⵉⵔⴻⴱⴱⵉⵜⴻⵏ ⵏⵙⴻⵏ, ⴰⴷ ⴰⵛ ⵢⵉⵍⵉ ⵎⴰⵏ ⴰⵢⴰ ⴷ ⵍⴼⴻⵅ ⵉ ⵛⴻⴽ.” ");
INSERT INTO rift_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","ⵓⵛⴰ ⵉⵏⵏⴰ ⵏⴻⵜⵜⴰ ⵉ ⵎⵓⵙⴰ: “ⴳⴻⵄⵄⴻⴷ ⵖⴰⵔ ⵙⵉⴷⵉ, ⵛⴻⴽ ⴷ ⵀⴰⵔⵓⵏ ⴷ ⵏⴰⴷⴰⴱ ⴷ ⴰⴱⵉⵀⵓ, ⴷ ⵙⴻⴱⵄⵉⵏ ⵏ ⵉⵎⵖⴰⵔⴻⵏ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵓⵛⴰ ⴱⴻⵏⴷⵇⴻⵎ ⵣⵉ ⵍⴰⴳⴳⵯⴰⵊ. ");
INSERT INTO rift_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","ⵎⵓⵙⴰ ⵡⴻⵃⵃⴷⴻⵙ ⴰⴷ ⴷⴷ-ⵉⵇⴰⵔⵔⴻⴱ ⵖⴰⵔ ⵙⵉⴷⵉ, ⵎⴰⵛⴰ ⵡⴰⵔ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⵇⴰⵔⵔⴱⴻⵏ ⵏⵉⵜⵏⵉ. ⵓⵍⴰ ⴷ ⵍⴳⴻⵏⵙ ⵡⴰⵔ ⴽⵉⴷⴻⵙ ⵉⵜⵜⴳⵉⵄⵄⵉⴷ ⵛⴰ.” ");
INSERT INTO rift_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","ⵎⵓⵙⴰ ⵉⵄⵇⴻⴱ-ⴷⴷ ⵓⵛⴰ ⵉⵅⴻⴱⴱⴰⵔ ⵍⴳⴻⵏⵙ ⵅ ⵎⴰⵔⵔⴰ ⴰⵡⴰⵍⴻⵏ ⵏ ⵙⵉⴷⵉ ⵓ ⵅ ⵎⴰⵔⵔⴰ ⵍⴼⴰⵔⴰⵢⵉⴹ. ⵎⴰⵔⵔⴰ ⵍⴳⴻⵏⵙ ⵢⴰⵔⵔⴰ-ⴷⴷ ⵙ ⵢⵉⵊⵊ ⵏ ⵡⴰⵡⴰⵍ, ⵏⵏⴰⵏ: “ⵎⴰⵔⵔⴰ ⴰⵡⴰⵍⴻⵏ ⵉ ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⴰⴷ ⵣⵣⴰⵢⵙⴻⵏ ⵏⴻⴳⴳ.”    ");
INSERT INTO rift_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","ⵎⵓⵙⴰ ⵢⵓⵔⴰ ⵎⴰⵔⵔⴰ ⴰⵡⴰⵍⴻⵏ ⵏ ⵙⵉⴷⵉ. ⵖⴰⵔ ⵚⵚⴱⴻⵃ ⵣⵉⵛ ⵉⴽⴽⴰⵔ ⵓⵛⴰ ⵉⴱⵏⴰ ⵉⵊⵊ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ⵖⴰⵔ ⵉⴹⴰⵔⴻⵏ ⵏ ⵡⴻⴷⵔⴰⵔ ⵓⵛⴰ ⵉⴳⴳⴰ ⵜⴻⵏⵄⴰⵛ ⵏ ⵉⵎⴰⵢⴹⵓⵜⴻⵏ ⵏ ⵡⴻⵥⵔⵓ, ⵄⵍⴰⵃⵙⴰⴱ ⵍⵇⴻⴷⴷ ⵏ ⵜⴻⵏⵄⴰⵛ ⵏ ⵜⵇⴻⴱⴱⴰⵍ ⵏ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","ⵉⵙⵙⴻⴽⴽ ⵉⵃⵓⴷⵔⵉⵢⵢⴻⵏ ⵣⴻⴳ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵉⵏⵏⵉ ⵉⵙⵙⴱⴻⵅⵅⴰⵔⴻⵏ ⵜⵉⵖⴰⵔⵚⵉ ⵏ ⵡⴻⵛⵎⴰⴹ ⵓ ⵇⴻⴷⴷⵎⴻⵏ ⵜⵉⵖⴰⵔⵚⵉ ⵏ ⵍⴻⵀⵏⴰ ⵣⴻⴳ ⵉⴼⵓⵏⴰⵙⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⴻⵏ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","ⵉⴽⵙⵉ ⵎⵓⵙⴰ ⴰⵣⵢⴻⵏ ⵏ ⵉⴷⴰⵎⵎⴻⵏ, ⵉⴳⴳⴰ ⵉ-ⵜ ⴷⵉ ⵟⵟⴱⴰⵚⵉ ⵓⵛⴰ ⴰⵣⵢⴻⵏ ⵏⵏⴻⵖⵏⵉ ⵏ ⵉⴷⴰⵎⵎⴻⵏ ⵉⵣⴻⴵⴻⵄ ⵉ-ⵜⴻⵏ ⵅ ⵓⵄⴰⵍⵟⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","ⵉⴽⵙⵉ ⴰⴷⵍⵉⵙ ⵉⵜⵜⵡⴰⵏⵏⴹⴻⵏ ⵏ ⵍⵄⴰⵀⴷ, ⵉⵖⵔⴰ ⵉ-ⵜ ⵅ ⵉⵎⴻⵣⵣⵓⵖⴻⵏ ⵏ ⵍⴳⴻⵏⵙ ⵓⵛⴰ ⵏⵉⵜⵏⵉ ⵏⵏⴰⵏ: “ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴷ ⴰⵏⴻⵖ ⵉⵏⵏⴰ ⵙⵉⴷⵉ, ⴰⴷ ⵜ ⵏⴻⴳⴳ, ⴰⴷ ⵜ ⵏⵟⴰⵄ.” ");
INSERT INTO rift_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","ⵉⴽⵙⵉ ⵎⵓⵙⴰ ⵉⴷⴰⵎⵎⴻⵏ, ⵉⵔⵓⵛⵛ ⵉ-ⵜⴻⵏ ⵅ ⵍⴳⴻⵏⵙ, ⵉⵏⵏⴰ: “ⵅⵣⴰⵔ, ⵉⵏⴰ ⴷ ⵉⴷⴰⵎⵎⴻⵏ ⵏ ⵍⵄⴰⵀⴷ ⵏⵏⵉ ⵉⴳⴳⴰ ⵙⵉⴷⵉ ⴰⴽⵉⴷⵡⴻⵎ ⵅ ⵎⴰⵔⵔⴰ ⴰⵡⴰⵍⴻⵏ-ⴰ.” ");
INSERT INTO rift_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","ⵉⴳⴻⵄⵄⴻⴷ ⵎⵓⵙⴰ ⴰⴽ-ⴷ ⵀⴰⵔⵓⵏ ⴷ ⵏⴰⴷⴰⴱ ⴷ ⴰⴱⵉⵀⵓ ⴷ ⵙⴻⴱⵄⵉⵏ ⵏ ⵉⵎⵖⴰⵔⴻⵏ ⵏ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","ⵥⵔⵉⵏ ⴰⵔⴻⴱⴱⵉ ⵏ ⵉⵙⵔⴰⵉⵍ. ⵜⵓⵖⴰ ⵙⴰⴷⵓ ⵉⴹⴰⵔⴻⵏ ⵏⵏⴻⵙ ⴰⵎ ⵜⵉⵙⵉ ⵏ ⵣⵣⴻⵍⵍⵉⵊ ⵉ ⵉⵜⵜⵡⴰⴳⴳⴻⵏ ⵏ ⵚⴰⴼⴼⵉⵔ ⴰⵣⵉⵣⴰ, ⵉⵚⴼⴰ ⴰⵎ ⵓⵊⴻⵏⵏⴰ ⵙⵉⵎⴰⵏⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","ⵡⴰⵔ ⵉⵙⵙⵡⵉⵥⵥⴻⴹ ⴰⴼⵓⵙ ⵏⵏⴻⵙ ⵅ ⵉⵎⵛⴻⵏⵏⵄⴻⵏ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵛⴰ ⵏⵉⵜⵏⵉ ⵅⵣⴰⵔⴻⵏ ⵖⴰⵔ ⴰⵔⴻⴱⴱⵉ, ⵛⵛⵉⵏ, ⵙⵡⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⴳⴻⵄⵄⴻⴷ-ⴷⴷ ⵖⴰⵔⵉ ⵖⴰⵔ ⵡⴻⴷⵔⴰⵔ ⵓⵛⴰ ⵇⵇⵉⵎ ⴷⵉⵏ ⵓⵛⴰ ⵏⴻⵛⵛ ⴰⴷ ⴰⵛ ⵡⵛⴻⵖ ⵜⵉⵍⵡⵉⵃⵉⵏ ⵏ ⵡⴻⵥⵔⵓ, ⵛⵛⴰⵔⵉⵄⴰ ⴷ ⵍⵓⵎⴰⵔⴰⵜ ⵜⵉⵏⵏⵉ ⵓⵔⵉⵖ ⵅ ⵜⴻⵍⵡⵉⵃⵉⵏ, ⵃⵉⵎⴰ ⴰⴷ ⴰⵙⴻⵏ ⵜⴻⵏⵜ ⵜⴻⵙⵙⵍⴻⵎⴷⴻⴷ.” ");
INSERT INTO rift_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","ⵉⴽⴽⴰⵔ ⵎⵓⵙⴰ ⴰⴽ-ⴷ ⵢⴰⵛⵓⵡⴰ, ⴰⵎⵙⴻⵅⵅⴰⵔ ⵏⵏⴻⵙ, ⵓⵛⴰ ⵉⴳⴻⵄⵄⴻⴷ ⵎⵓⵙⴰ ⵖⴰⵔ ⵡⴻⴷⵔⴰⵔ ⵏ ⴰⵔⴻⴱⴱⵉ. ");
INSERT INTO rift_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","ⵉⵏⵏⴰ ⵉ ⵉⵎⵖⴰⵔⴻⵏ: “ⵔⴰⵊⴰⵎ ⴰⵏⴻⵖ ⴷⴰⵏⵉⵜⴰ ⴰⵍ ⴷⴷ ⵖⴰⵔⵡⴻⵎ ⵉ ⵖⴰ ⵏⴻⴷⵡⴻⵍ. ⵅⵣⴰⵔ, ⵀⴰⵔⵓⵏ ⴷ ⵃⵓⵔ ⴰⴽⵉⴷⵡⴻⵎ. ⵎⴰⵍⴰ ⴷⵉⵏ ⵃⴻⴷ ⵖⴰⵔⴻⵙ ⴷⴷⵄⴰⵡⵉ, ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⵙ ⴰⴷ ⵖⴰⵔⵙⴻⵏ ⵉⵔⴰⵃ.” ");
INSERT INTO rift_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","ⵅⴻⵏⵏⵉ ⵉⴳⴻⵄⵄⴻⴷ ⵎⵓⵙⴰ ⵖⴰⵔ ⵡⴻⴷⵔⴰⵔ, ⵓⵛⴰ ⵉⵊⵊ ⵏ ⵓⵙⴻⵢⵏⵓ ⵉⴷⵍⴰ ⴰⴷⵔⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","ⴰⵄⵓⴵⵉ ⵏ ⵙⵉⴷⵉ ⵜⵓⵖⴰ ⵉⵣⴻⴷⴷⴻⵖ ⴷⴻⴳ ⵡⴻⴷⵔⴰⵔ ⵏ ⵙⵉⵏⴰ ⵓ ⴰⵙⴻⵢⵏⵓ ⵉⴷⵍⴰ ⵉ-ⵜ ⵙⴻⵜⵜⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⵓⵛⴰ ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ ⵉⵍⴰⵖⴰ-ⴷⴷ ⵏⴻⵜⵜⴰ ⵅ ⵎⵓⵙⴰ ⵣⵉ ⵍⵡⴻⵙⵟ ⵏ ⵓⵙⴻⵢⵏⵓ. ");
INSERT INTO rift_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","ⴰⵙⵛⴰⵏ ⵏ ⵓⵄⵓⴵⵉ ⵏ ⵙⵉⴷⵉ ⵜⵓⵖⴰ-ⵜ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴰⵎ ⵜⵎⴻⵙⵙⵉ ⵉⵜⵜⴻⵜⵜⴻⵏ ⵅ ⵜⵇⵉⵛⵛⴰⵜ ⵏ ⵡⴻⴷⵔⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","ⵢⵓⴷⴻⴼ ⵎⵓⵙⴰ ⵖⴰⵔ ⵍⵡⴻⵙⵟ ⵏ ⵓⵙⴻⵢⵏⵓ ⵓⵛⴰ ⵉⴳⴻⵄⵄⴻⴷ ⴰⴷⵔⴰⵔ. ⵜⵓⵖⴰ ⵎⵓⵙⴰ ⵉⵇⵇⵉⵎ ⴰⵔⴻⴱⵄⵉⵏ ⵏ ⵡⵓⵙⵙⴰⵏ ⴷ ⴰⵔⴻⴱⵄⵉⵏ ⵏ ⴵⵢⴰⵍⵉ ⴷⴻⴳ ⵡⴻⴷⵔⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“ⵉⵏⵉ ⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴰⴷ ⴰⵢⵉ ⴷⴷ-ⵙⵙⴳⴰⵄⵄⴷⴻⵏ ⵜⴰⵡⵀⵉⴱⵜ. ⵣⵉ ⴽⵓⵍ ⴰⵔⵢⴰⵣ ⵏⵏⵉ ⴷ ⴰⵙ ⵉⵄⴰⵔⵔⴻⵏ ⵡⵓⵍ ⵏⵏⴻⵙ, ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵜⴻⴽⵙⵉⵎ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵓⵙⴳⴰⵄⵄⴻⴷ ⵉ ⵏⴻⵛⵛ. ");
INSERT INTO rift_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","ⵜⴰ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵓⵙⴳⴻⵄⵄⴻⴷ, ⵜⴻⵏⵏⵉ ⵉ ⵖⴰ ⵜⴻⴽⵙⵉⴷ ⵣⵣⴰⵢⵙⴻⵏ: ⵓⵔⴻⵖ ⴷ ⵏⵏⵓⵇⴰⵔⵜ ⴷ ⵏⵏⵃⴰⵙ, ");
INSERT INTO rift_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","ⴷ ⵓⴼⵉⵍⵓ ⴰⴷⴻⵃⵎⵉ ⴷ ⵓⵔⵊⵓⵡⴰⵏⵉ ⴷ ⵓⵣⴻⴳⴳⵯⴰⵖ ⵉⵃⴻⴷⵇⴻⵏ ⴷ ⵍⴻⵇⵟⴻⵏ ⴰⵣⴷⴰⴷ ⴷ ⵛⵛⵄⴰⵔ ⵏ ⵉⵖⴰⵢⴹⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ⴷ ⵉⵍⵎⴰⵡⴻⵏ ⵉⵣⴻⴳⴳⵯⴰⵖⴻⵏ ⵏ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ, ⴷ ⵉⵍⵎⴰⵡⴻⵏ ⵏ ⴷⴷⴻⵏⴼⵉⵍⴰⵜ, ⴷ ⵓⴽⴻⵛⵛⵓⴹ ⵏ ⵜⵛⴻⵊⵊⴰⵔⵜ ⵏ ⵓⴽⴰⵙⵉⵢⴰ, ");
INSERT INTO rift_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","ⵣⵣⴻⵛⵜ ⵉ ⵜⴼⴰⵡⵜ ⵏ ⵍⵇⴻⵏⴷⵉⵍ, ⵍⴻⵄⵟⵓⵔ ⵉ ⵣⵣⴻⵛⵜ ⵏ ⵡⴻⴷⵀⴰⵏ ⵓ ⵉ ⵍⴻⴱⵅⵓⵔ ⵉⵜⵜⴼⵓⵃⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ⵉⵥⵔⴰ ⵏ ⵓⵏⵉⴽⵙ ⴷ ⵉⵥⵔⴰ ⵉⵖⵍⴰⵏ ⵏⵏⴻⵖⵏⵉ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⴻⵏ ⴳⴳⴻⵏ ⵅ ⵓⴱⴰⵍⵟⵓ ⵓ ⵅ ⵜⴰⵊⵎⴻⵛⵜ. ");
INSERT INTO rift_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","ⴰⴷ ⴰⵢⵉ ⴳⴳⴻⵏ ⵉⵛⵜ ⵏ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ, ⵃⵉⵎⴰ ⴰⴷ ⵣⴻⴷⵖⴻⵖ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","ⴰⴷ ⵜ ⵜⴻⴳⴳⴻⴷ ⴰⵎ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴷ ⴰⵛ ⵖⴰ ⵙⵙⴻⵛⵏⴻⵖ, ⵄⵍⴰⵃⵙⴰⴱ ⴰⵎⴻⴷⵢⴰ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ ⵓ ⵄⵍⴰⵃⵙⴰⴱ ⴰⵎⴻⴷⵢⴰ ⵏ ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ ⵉ ⴷⴰⵢⴻⵙ ⵉⴵⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","ⴰⴷ ⴳⴳⴻⵏ ⵄⴰⵡⴻⴷ ⵉⵛⵜ ⵏ ⵜⵜⴰⴱⵓⵜ ⵏ ⵓⴽⴻⵛⵛⵓⴹ ⵏ ⵜⵛⴻⵊⵊⴰⵔⵜ ⵏ ⵓⴽⴰⵙⵉⵢⴰ. ⴰⴷ ⵜⵉⵍⵉ ⵜⵓⵣⵣⴻⴳⴳⴰⵔⵜ ⵏⵏⴻⵙ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵖⴰⴵⴻⵏ ⴷ ⵡⴻⵣⵢⴻⵏ ⵓ ⵜⵉⵔⵓ ⵏⵏⴻⵙ ⵉⵊⵊ ⵏ ⵓⵖⵉⵍ ⴷ ⵡⴻⵣⵢⴻⵏ ⵓ ⵍⵓⵄⵍⴰ ⵏⵏⴻⵙ ⵉⵊⵊ ⵏ ⵓⵖⵉⵍ ⴷ ⵡⴻⵣⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","ⴰⴷ ⵜ ⵜⵜⵛⴻⵍⵍⴻⴷ ⵙ ⵡⵓⵔⴻⵖ ⵉⵚⴼⴰⵏ, ⵣⵉ ⴷⴰⵅⴻⵍ ⵓ ⵣⵉ ⴱⴰⵔⵔⴰ ⴰⴷ ⵜⵜ ⵜⵛⴻⵍⵍⴻⴷ, ⵓⵛⴰ ⵖⴰⵔ ⵙⴻⵏⵏⴻⵊ ⴰⴷ ⴰⵙ ⵜⴻⵏⵏⴹⴻⴷ ⵉⵊⵊ ⵏ ⵣⵣⵡⴰⵇ ⵏ ⵡⵓⵔⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","ⴰⴷ ⴰⵙ ⵜⴻⵙⵙⴼⴻⵙⵢⴻⴷ ⴰⵔⴻⴱⵄⴰ ⵏ ⵜⴻⵅⵔⴰⵣⵉⵏ ⵏ ⵡⵓⵔⴻⵖ. ⴰⴷ ⵜⴻⵏⵜ ⵜⵛⴻⴷⴷⴻⴷ ⵖⴰⵔ ⴰⵔⴻⴱⵄⴰ ⵏ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵏⵏⴻⵙ. ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵅⵔⴰⵣⵉⵏ ⴰⴷ ⵉⵍⵉⵏⵜ ⵖⴰⵔ ⵢⵉⵊⵊ ⵏ ⵓⵖⴻⵣⴷⵉⵙ ⵓ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵅⵔⴰⵣⵉⵏ ⵉ ⵓⵖⴻⵣⴷⵉⵙ ⵏⵏⴻⵖⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵉⵄⵓⵎⴰⴷ ⵉ ⵜⵔⴻⴱⴱⵓⵜ ⵣⴻⴳ ⵓⴽⴻⵛⵛⵓⴹ ⵏ ⵜⵛⴻⵊⵊⴰⵔⵜ ⵏ ⵓⴽⴰⵙⵉⵢⴰ ⵓⵛⴰ ⴰⴷ ⵜⴻⵏ ⵜⴻⴷⵍⴻⴷ ⵙ ⵡⵓⵔⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","ⵙⵉⴷⴼⴻⵎ ⵉⵄⵓⵎⴰⴷ ⴷⵉ ⵜⴻⵅⵔⴰⵣⵉⵏ ⵏⵏⵉ ⵉⴵⴰⵏ ⵖⴰⵔ ⵉⵖⴻⵣⴷⵉⵙⴻⵏ ⵏ ⵜⵜⴰⴱⵓⵜ, ⵃⵉⵎⴰ ⴰⴷ ⵣⵣⴰⵢⵙⴻⵏ ⴰⵔⴱⵓⵏ ⵜⵜⴰⴱⵓⵜ. ");
INSERT INTO rift_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","ⵉⵄⵓⵎⴰⴷ ⴰⴷ ⵉⵍⵉⵏ ⴷⵉ ⵜⴻⵅⵔⴰⵣⵉⵏ ⵏ ⵜⵜⴰⴱⵓⵜ, ⵡⴰⵔ ⵣⵣⴰⵢⵙⴻⵏⵜ ⵜⴻⵏ ⵜⵜⴻⴽⴽⵙⴻⵏ ⵛⴰ. ");
INSERT INTO rift_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","ⴰⴷ ⵜⴻⵙⵙⴰⵔⵙⴻⴷ ⵛⵛⵀⴰⴷⴻⵜ, ⵜⴻⵏⵏⵉ ⵉ ⴷ ⴰⵛ ⵖⴰ ⵡⵛⴻⵖ, ⴷⵉ ⵜⵜⴰⴱⵓⵜ. ");
INSERT INTO rift_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵄⴰⵡⴻⴷ ⵉⵛⵜ ⵏ ⵜⵇⴻⴱⴱⴰⵔⵜ ⵏ ⵡⴻⵚⵍⴰⵃ ⵏ ⵡⵓⵔⴻⵖ ⵉⵚⴼⴰⵏ ⵙ ⵢⵉⵛⵜ ⵏ ⵜⵓⵣⵣⴻⴳⴳⴰⵔⵜ ⵏ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵖⴰⴵⴻⵏ ⴷ ⵡⴻⵣⵢⴻⵏ ⵓ ⵙ ⵉⵛⵜ ⵏ ⵜⵉⵔⵓ ⵏ ⵉⵊⵊ ⵏ ⵓⵖⵉⵍ ⴷ ⵡⴻⵣⵢⴻⵏ.    ");
INSERT INTO rift_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵄⴰⵡⴻⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⴽⵉⵔⵓⴱⴻⵏ ⵏ ⵡⵓⵔⴻⵖ ⵉⵄⴷⴻⵍ ⵙ ⵡⴻⴼⴹⵉⵙ, ⴰⵍⴰⵎⵉ ⵉ ⵖⴰ ⴼⴼⵖⴻⵏ ⵉⴽⵉⵔⵓⴱⴻⵏ ⵣⵉ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵅⴼⴰⵡⴻⵏ ⵏ ⵜⵇⴻⴱⴱⴰⵔⵜ ⵏ ⵡⴻⵚⵍⴰⵃ.    ");
INSERT INTO rift_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵉⵊⵊ ⵏ ⵓⴽⵉⵔⵓⴱ ⵖⴰⵔ ⵉⵊⵊ ⵏ ⵢⵉⵅⴻⴼ ⵓ ⵉⵊⵊ ⵏ ⵓⴽⵉⵔⵓⴱ ⵏⵏⴻⵖⵏⵉ ⵖⴰⵔ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵖⵏⵉ. ⴰⴷ ⵜⴻⴳⴳⴻⵎ ⵉⴽⵉⵔⵓⴱⴻⵏ ⵣⵉ ⵜⵇⴻⴱⴱⴰⵔⵜ ⵏ ⵡⴻⵚⵍⴰⵃ ⵖⴰⵔ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵅⴼⴰⵡⴻⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","ⴰⴷ ⴱⴻⵣⵣⵄⴻⵏ ⵉⴽⵉⵔⵓⴱⴻⵏ ⴰⴼⵔⵉⵡⴻⵏ ⵏⵙⴻⵏ ⵙⴻⵏⵏⴻⵊ ⵏⵙⴻⵏ ⵓⵛⴰ ⴰⴷ ⴷⵍⴻⵏ ⵜⴰⵇⴻⴱⴱⴰⵔⵜ ⵏ ⵡⴻⵚⵍⴰⵃ ⵙ ⵡⴰⴼⵔⵉⵡⴻⵏ ⵏⵙⴻⵏ. ⵓⴷⵎⴰⵡⴻⵏ ⵏⵙⴻⵏ ⴰⴷ ⵉⵍⵉⵏ ⵉⵊⵊ ⵇⵉⴱⴰⵍⵜ ⵉ ⵡⴻⵏⵏⴻⵖⵏⵉ ⵓⵛⴰ ⴰⴷ ⵥⴰⵔⴻⵏ ⵓⴷⵎⴰⵡⴻⵏ ⵏ ⵉⴽⵉⵔⵓⴱⴻⵏ ⵖⴰⵔ ⵜⵇⴻⴱⴱⴰⵔⵜ ⵏ ⵡⴻⵚⵍⴰⵃ. ");
INSERT INTO rift_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵜⴰⵇⴻⴱⴱⴰⵔⵜ ⵏ ⵡⴻⵚⵍⴰⵃ ⵅ ⵜⵜⴰⴱⵓⵜ ⵓⵛⴰ ⴰⴷ ⵜⴻⵙⵙⴰⵔⵙⴻⴷ ⵛⵛⵀⴰⴷⴻⵜ ⵉ ⴷ ⴰⵛ ⵖⴰ ⵡⵛⴻⵖ ⴷⵉ ⵜⵜⴰⴱⵓⵜ. ");
INSERT INTO rift_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","ⴷⵉⵏⵏⵉ ⵉ ⴽⵉⵛ ⵖⴰ ⵎⵎⴻⵍⵇⵉⵖ ⵓⵛⴰ ⴰⴷ ⴽⵉⴽ ⵙⵙⵉⵡⵍⴻⵖ ⵣⵉ ⵙⴻⵏⵏⴻⵊ ⵉ ⵜⵇⴻⴱⴱⴰⵔⵜ ⵏ ⵡⴻⵚⵍⴰⵃ, ⵣⵉ ⵊⴰⵔ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⴽⵉⵔⵓⴱⴻⵏ ⵏⵏⵉ ⵉⴵⴰⵏ ⵙⴻⵏⵏⴻⵊ ⵉ ⵜⵜⴰⴱⵓⵜ ⵏ ⵛⵛⵀⴰⴷⴻⵜ, ⵅ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴷ ⴰⵛ ⵖⴰ ⵓⵎⵓⵔⴻⵖ ⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵉⵛⵜ ⵏ ⵜⵣⴻⵡⴹⴰ ⵏ ⵓⴽⴻⵛⵛⵓⴹ ⵏ ⵜⵛⴻⵊⵊⴰⵔⵜ ⵏ ⵓⴽⴰⵙⵉⵢⴰ, ⴰⴷ ⵖⴰⵔⴻⵙ ⵜⵉⵍⵉ ⵉⵛⵜ ⵏ ⵜⵓⵣⵣⴻⴳⴳⴰⵔⵜ ⵏ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵖⴰⴵⴻⵏ ⴷ ⵉⵛⵜ ⵏ ⵜⵉⵔⵓ ⵏ ⵉⵊⵊⴻⵏ ⵓⵖⵉⵍ ⴷ ⵉⵊⵊ ⵏ ⵍⵓⵄⵍⴰ ⵏ ⵉⵊⵊⴻⵏ ⵓⵖⵉⵍ ⴷ ⵡⴻⵣⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","ⴰⴷ ⵜⵜ ⵜⴻⴷⵍⴻⴷ ⵙ ⵡⵓⵔⴻⵖ ⵉⵚⴼⴰⵏ ⵓⵛⴰ ⴰⴷ ⴰⵙ ⵜⴻⴳⴳⴻⴷ ⵖⴰⵔ ⵜⵎⴰ ⵏⵏⴻⵙ ⵉⵊⵊ ⵣⵣⵡⴰⵇ ⵏ ⵡⵓⵔⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵉⵛⵜ ⵏ ⵜⵎⴰ ⵉ ⴷ ⴰⵙ ⴷⴷ-ⵉⵏⵏⴹⴻⵏ ⵏ ⵉⵊⵊⴻⵏ ⵛⴱⴰⵔ ⵏ ⵓⴼⵓⵙ ⵓ ⵖⴰⵔ ⵜⵎⴰ ⵉ ⴷ ⴰⵙ ⴷⴷ-ⵉⵏⵏⴹⴻⵏ ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵉⵊⵊ ⵏ ⵣⵣⵡⴰⵇ ⵏ ⵡⵓⵔⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⴰⵔⴻⴱⵄⴰ ⵏ ⵜⴻⵅⵔⴰⵣⵉⵏ ⵏ ⵡⵓⵔⴻⵖ ⵓⵛⴰ ⴰⴷ ⵜⴻⵏⵜ ⵜⵛⴻⴷⴷⴻⴷ ⵖⴰⵔ ⴰⵔⴻⴱⵄⴰ ⵏ ⵜⵖⴻⵎⵎⵓⵔⴰ ⵏⵏⵉ ⵉⴵⴰⵏ ⵖⴰⵔ ⴰⵔⴻⴱⵄⴰ ⵏ ⵉⴹⴰⵔⴻⵏ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","ⵜⵉⵅⵔⴰⵣⵉⵏ ⴰⴷ ⵉⵍⵉⵏⵜ ⵓⴷⵙⴻⵏⵜ ⵉ ⵜⵎⴰ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴷⴰⵢⵙⴻⵏⵜ ⵜⵜⵡⴰⵟⵟⴼⴻⵏ ⵉⵄⵓⵎⴰⴷ ⵉ ⵜⴰⵔⴻⴱⴱⵓⵜ ⵏ ⵜⵣⴻⵡⴹⴰ. ");
INSERT INTO rift_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵉⵄⵓⵎⴰⴷ ⵉ ⵜⴰⵔⴻⴱⴱⵓⵜ ⵣⴻⴳ ⵓⴽⴻⵛⵛⵓⴹ ⵏ ⵜⵛⴻⵊⵊⴰⵔⵜ ⵏ ⵓⴽⴰⵙⵉⵢⴰ, ⴰⴷ ⵜⴻⵏ ⵜⵖⴻⴵⴼⴻⴷ ⵙ ⵡⵓⵔⴻⵖ ⵓⵛⴰ ⴰⴷ ⵣⵣⴰⵢⵙⴻⵏ ⴰⵔⴱⵓⵏ ⵜⴰⵣⴻⵡⴹⴰ. ");
INSERT INTO rift_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵄⴰⵡⴻⴷ ⵟⵟⴱⴰⵚⵉ ⵏⵏⴻⵙ ⴷ ⵜⵖⴻⵏⵊⴰⵢⵉⵏ ⵏⵏⴻⵙ ⴷ ⵉⵖⴰⵔⵔⴰⴼⴻⵏ ⵏⵏⴻⵙ ⴷ ⵍⴽⵉⵙⴰⵏ ⵏⵏⴻⵙ ⵉ ⵣⵉ ⵖⴰ ⴼⴰⵔⵔⵖⴻⵏ. ⴰⴷ ⵜⴻⵏ ⵜⴻⴳⴳⴻⴷ ⵙ ⵡⵓⵔⴻⵖ ⵉⵚⴼⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","ⵅ ⵜⵣⴻⵡⴹⴰ ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⴰⵖⵔⵓⵎ ⵏ ⵡⴻⵙⵛⴰⵏ ⵍⴻⴱⴷⴰ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵉⵏⵓ. ");
INSERT INTO rift_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵍⵇⴻⵏⴷⵉⵍ ⵙ ⵡⵓⵔⴻⵖ ⵉⵚⴼⴰⵏ. ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵍⵇⴻⵏⴷⵉⵍ ⵙ ⵡⴻⴼⴹⵉⵙ ⵏ ⵡⴻⵎⵣⵉⵍ. ⴰⴼⵓⴷ ⴰⴽ-ⴷ ⵓⴹⴰⵔ ⵏⵏⴻⵙ ⴷ ⵉⵖⴰⴵⴻⵏ ⵏⵏⴻⵙ ⵓⵍⴰ ⴷ ⵍⴽⵉⵙⴰⵏ ⵏⵏⴻⵙ ⴷ ⵜⵄⴻⴱⴱⵓⵣⵉⵏ ⵏⵏⴻⵙ ⵉ ⴷⴷ-ⵉⵜⵜⴰⵙⴻⵏ ⴰⴽ-ⴷ ⵏⵏⵓⵡⵡⴰⵔⴰⵜ ⵏⵏⴻⵙ ⴰⴷ ⵉⵍⵉⵏ ⴷ ⴰⵖⴻⵣⴷⵉⵙ ⴷ ⵉⵊⵊ. ");
INSERT INTO rift_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","ⵙⴻⵜⵜⴰ ⵏ ⵉⵖⴰⴵⴻⵏ ⴰⴷ ⴷⴷ-ⴼⴼⵖⴻⵏ ⵣⴻⴳ ⵉⵖⴻⵣⴷⵉⵙⴻⵏ ⵏⵏⴻⵙ, ⵜⵍⴰⵜⴰ ⵏ ⵉⵖⴰⴵⴻⵏ ⵣⴻⴳ ⵉⵊⵊ ⵏ ⵓⵖⴻⵣⴷⵉⵙ ⵏ ⵍⵇⴻⵏⴷⵉⵍ ⴷ ⵜⵍⴰⵜⴰ ⵏ ⵉⵖⴰⴵⴻⵏ ⵣⴻⴳ ⵓⵖⴻⵣⴷⵉⵙ ⵏⵏⴻⵖⵏⵉ ⵏ ⵍⵇⴻⵏⴷⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","ⵜⵍⴰⵜⴰ ⵏ ⵍⴽⵉⵙⴰⵏ ⴰⴷ ⵉⵍⵉⵏ ⴷⴻⴳ ⵉⵊⵊ ⵏ ⵓⵖⵉⵍ ⴷⵉ ⴼⵓⵔⵎⴰ ⵏ ⵏⵏⵓⵡⵡⴰⵔⴰⵜ ⵏ ⴵⴻⵡⵣ ⴰⴽ-ⴷ ⵜⵄⴻⴱⴱⵓⵣⵜ ⴷ ⵏⵏⴻⵡⵡⴰⵛ, ⵓⵛⴰ ⵄⴰⵡⴻⴷ ⵖⴰⵔ ⵓⵖⵉⵍ ⵏⵏⴻⵖⵏⵉ ⵜⵍⴰⵜⴰ ⵏ ⵍⴽⵉⵙⴰⵏ ⴷⵉ ⴼⵓⵔⵎⴰ ⵏ ⵏⵏⵓⵡⵡⴰⵔⴰⵜ ⵏ ⴵⴻⵡⵣ ⴰⴽ-ⴷ ⵜⵄⴻⴱⴱⵓⵣⵜ ⴷ ⵏⵏⴻⵡⵡⴰⵛ. ⴰⵎⵎⵓ ⵉ ⵖⴰ ⴳⴳⴻⵏ ⵎⴰⵔⵔⴰ ⵙⴻⵜⵜⴰ ⵏ ⵉⵖⴰⴵⴻⵏ ⵏⵏⵉ ⴷⴷ-ⵉⴼⴼⵖⴻⵏ ⵣⵉ ⵍⵇⴻⵏⴷⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","ⵖⴰⵔ ⵍⵇⴻⵏⴷⵉⵍ ⵙⵉⵎⴰⵏⵜ ⵏⵏⴻⵙ ⴰⴷ ⴷⵉⵏ ⵉⵍⵉⵏ ⴰⵔⴻⴱⵄⴰ ⵏ ⵍⴽⵉⵙⴰⵏ ⴷⵉ ⴼⵓⵔⵎⴰ ⵏ ⵏⵏⵓⵡⵡⴰⵔⴰⵜ ⵏ ⴵⴻⵡⵣ, ⴰⴽ-ⴷ ⵜⵄⴻⴱⴱⵓⵣⵉⵏ ⵏⵙⴻⵏ ⵉ ⴷⴷ-ⵉⵜⵜⴰⵙⴻⵏ ⴰⴽ-ⴷ ⵏⵏⵓⵡⵡⴰⵔⴰⵜ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","ⴰⴷ ⴷⵉⵏ ⵜⵉⵍⵉ ⵉⵛⵜ ⵏ ⵜⵄⴻⴱⴱⵓⵣⵜ ⵙⴰⴷⵓ ⵜⵢⵓⵢⴰ ⵏ ⵉⵖⴰⴵⴻⵏ ⵉ ⵣⵣⴰⵢⴻⵙ ⴷⴷ-ⵉⴼⴼⵖⴻⵏ ⵓ ⵉⵛⵜ ⵏ ⵜⵄⴻⴱⴱⵓⵣⵜ ⵙⴰⴷⵓ ⵜⵢⵓⵢⴰ ⵏ ⵉⵖⴰⴵⴻⵏ ⵉ ⵣⵣⴰⵢⴻⵙ ⴷⴷ-ⵉⴼⴼⵖⴻⵏ ⴰⵡⴰⵔⵏⵉ ⴰⵙ, ⵓ ⵄⴰⵡⴻⴷ ⵉⵛⵜ ⵏ ⵜⵄⴻⴱⴱⵓⵣⵜ ⵙⴰⴷⵓ ⵜⵢⵓⵢⴰ ⵏ ⵉⵖⴰⴵⴻⵏ ⵉ ⵣⵣⴰⵢⴻⵙ ⴷⴷ-ⵉⴼⴼⵖⴻⵏ ⴰⵡⴰⵔⵏⵉ ⴰⵙ. ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵢⵉⵍⵉ ⵉ ⵙⴻⵜⵜⴰ ⵏ ⵉⵖⴰⴵⴻⵏ ⵉ ⴷⴷ-ⵉⴼⴼⵖⴻⵏ ⵣⵉ ⵍⵇⴻⵏⴷⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","ⵜⵉⵄⴻⴱⴱⵓⵣⵉⵏ ⵏⵙⴻⵏ ⴷ ⵉⵖⴰⴵⴻⵏ ⵏⵙⴻⵏ ⴰⴷ ⵣⵣⴰⵢⴻⵙ-ⴷⴷ ⴼⴼⵖⴻⵏ ⵓⵛⴰ ⵎⴰⵔⵔⴰ ⴰⵢⴰ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵉⵛⵜ ⵏ ⵍⵇⴻⵛⵄⴻⵜ ⵜᵉⵜⵜⵡⴰⵄⴷⴻⵍ ⵙ ⵡⴻⴼⴹⵉⵙ ⵏ ⵡⴻⵎⵣⵉⵍ ⵙ ⵡⵓⵔⴻⵖ ⵉⵚⴼⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵙⴻⵜⵜⴰ ⵏ ⵍⴻⴼⵏⴰⵔⴰⵜ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⵙⵙⴰⵔⵙⴻⵏ ⵍⴻⴼⵏⴰⵔⴰⵜ ⵏⵏⴻⵙ ⵅ ⵍⵇⴻⵏⴷⵉⵍ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵡⵛⴻⵏⵜ ⵜⴼⴰⵡⵜ ⵖⴰⵔ ⵟⵟⴰⵔⴼ ⵏ ⵓⵊⴻⵎⵎⴰⴹ. ");
INSERT INTO rift_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","ⵜⵉⵊⴻⵇⵇⴰⴹⵉⵏ ⵏ ⵜⴻⴼⵜⵉⵍⵜ ⵏⵏⴻⵙ ⴷ ⵜⵎⴻⵊⵎⴰⵔⵉⵏ ⵏⵏⴻⵙ ⴰⴷ ⵉⵍⵉⵏⵜ ⵙ ⵡⵓⵔⴻⵖ ⵉⵚⴼⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","ⴰⴷ ⵉⵜⵜⵡⴰⴳⴳ ⵍⵇⴻⵏⴷⵉⵍ ⵣⴻⴳ ⵉⵛⵜ ⵏ ⵜⴰⵍⵉⵏⵜ ⵏ ⵡⵓⵔⴻⵖ ⵉⵚⴼⴰⵏ ⵙ ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ-ⴰ ⴰⴽⵉⴷⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","ⵓⵛⴰ ⵅⵣⴰⵔ, ⴰⴷ ⵜ ⵜⴻⴳⴳⴻⴷ ⴰⵎ ⵓⵎⴻⴷⵢⴰ ⵏⵏⴻⵙ, ⵡⴻⵏⵏⵉ ⵉ ⴷ ⴰⵛ ⵉⵜⵜⵡⴰⵎⵍⴻⵏ ⴷⴻⴳ ⵡⴻⴷⵔⴰⵔ.”   * ");
INSERT INTO rift_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵜⴰⵣⴻⴷⴷⵉⵖⵜ ⵙ ⵄⴻⵛⵔⴰ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵉⵏ ⵙ ⵍⴻⵇⵟⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵎⵓⴷⴻⵏ ⵓ ⵙ ⵓⴼⵉⵍⵓ ⴰⴷⴻⵃⵎⵉ ⴷ ⵓⵔⵊⵓⵡⴰⵏⵉ ⴷ ⵓⵣⴻⴳⴳⵯⴰⵖ ⵉⵃⴻⴷⵇⴻⵏ, ⴰⴽ-ⴷ ⵉⴽⵉⵔⵓⴱⴻⵏ. ⴰⴷ ⵜⴻⵏ ⵜⴻⴳⴳⴻⴷ ⴰⵎ ⵍⵅⴻⴷⵎⴻⵜ ⵏ ⵓⴼⴻⵏⵏⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","ⵜⵓⵣⵣⴻⴳⴳⴰⵔⵜ ⵏ ⵢⵉⵛⵜ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵜ ⴰⴷ ⵜⵉⵍⵉ ⵜⵎⴻⵏⵢⴰ ⵓ-ⵄⵉⵛⵔⵉⵏ ⵏ ⵉⵖⴰⴵⴻⵏ ⵓ ⵜⵉⵔⵓ ⵏ ⵢⵉⵛⵜ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵜ ⴰⵔⴻⴱⵄⴰ ⵏ ⵉⵖⴰⴵⴻⵏ. ⵎⴰⵔⵔⴰ ⵜⵉⵊⴰⵔⵜⵉⵍⵉⵏ ⴰⴷ ⵖⴰⵔⵙⴻⵏⵜ ⵢⵉⵍⵉ ⵍⴻⵄⴱⴰⵔ ⴷ ⵉⵊⵊ. ");
INSERT INTO rift_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","ⵅⴻⵎⵙⴰ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵉⵏ ⴰⴷ ⵜⴻⵏⵜ ⵙⵙⵎⵓⵏⴻⵏ ⵉⵛⵜ ⴰⴽ-ⴷ ⵜⴻⵏⵏⴻⵖⵏⵉ ⵓ ⵄⴰⵡⴻⴷ ⵅⴻⵎⵙⴰ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵉⵏ ⴰⴷ ⵜⴻⵏⵜ ⵙⵙⵎⵓⵏⴻⵏ ⵉⵛⵜ ⴰⴽ-ⴷ ⵜⴻⵏⵏⴻⵖⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","ⵖⴰⵔ ⵜⵎⴰ ⵏ ⵢⵉⵛⵜ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵜ ⵖⴰⵔ ⵟⵟⴰⵔⴼ ⵎⴰⵏⵉ ⵜⵜ ⵖⴰ ⵙⵙⵎⵓⵏⴻⵏ, ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵜⵉⵙⴰⵔⴰⵡⵉⵏ ⵜⵉⴷⴻⵃⵎⴰⵏⵉⵏ. ⴰⵎⵎⵓ ⵉ ⵜⴻⵏⵜ ⵖⴰ ⵜⴻⴳⴳⴻⴷ ⵄⴰⵡⴻⴷ ⵖⴰⵔ ⵜⵎⴰ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵜ ⵏⵏⴻⵖⵏⵉ ⵖⴰⵔ ⵟⵟⴰⵔⴼ ⵉ ⵖⴰⵔ ⵉⴵⴰ ⵓⵙⴻⵍⵇⵉ ⵏⵏⴻⵖⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","ⵅⴻⵎⵙⵉⵏ ⵏ ⵜⵙⴰⵔⴰⵡⵉⵏ ⵉ ⵖⴰ ⵜⴻⴳⴳⴻⴷ ⴷⴻⴳ ⵉⵛⵜ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵜ ⵓ ⵅⴻⵎⵙⵉⵏ ⵏ ⵜⵙⴰⵔⴰⵡⵉⵏ ⵖⴰⵔ ⵟⵟⴰⵔⴼ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵜ ⵏⵏⵉ ⵖⴰⵔ ⵉⴵⴰ ⵓⵙⴻⵍⵇⵉ ⵏⵏⴻⵖⵏⵉ, ⵎⴰⵃⴻⵏⴷ ⵜⵉⵙⴰⵔⴰⵡⵉⵏ ⴰⴷ ⵎⵎⴻⵍⵇⴰⵏⵜ ⵉⵛⵜ ⴰⴽ-ⴷ ⵜⴻⵏⵏⴻⵖⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵄⴰⵡⴻⴷ ⵅⴻⵎⵙⵉⵏ ⵏ ⵜⵙⴻⵏⵏⴰⵔⵉⵏ ⵏ ⵡⵓⵔⴻⵖ ⵓⵛⴰ ⴰⴷ ⵜⴻⵙⵙⵎⵓⵏⴻⴷ ⵜⵉⵊⴰⵔⵜⵉⵍⵉⵏ ⵉⵛⵜ ⴰⴽ-ⴷ ⵜⴻⵏⵏⴻⵖⵏⵉ ⵙ ⵜⵙⴻⵏⵏⴰⵔⵉⵏ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⴻⴷⵡⴻⵍ ⴷ ⵉⵛⵜ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ. ");
INSERT INTO rift_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵄⴰⵡⴻⴷ ⵜⵉⵊⴰⵍⵜⵉⵍⵉⵏ ⵙ ⵛⵛⵄⴰⵔ ⵏ ⵉⵖⴰⵢⴹⴻⵏ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⵍⵉⵏⵜ ⴷ ⵉⵊⵊ ⵏ ⵓⵇⵉⴹⵓⵏ ⵅ ⵜⵣⴻⴷⴷⵉⵖⵜ. ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵃⵉⵟⴰⵛ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","ⵜⵓⵣⵣⴻⴳⴳⴰⵔⵜ ⵏ ⵉⵛⵜ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵜ ⴰⴷ ⵜⵉⵍⵉ ⵜⵍⴰⵜⵉⵏ ⵏ ⵉⵖⴰⴵⴻⵏ ⵓ ⵜⵉⵔⵓ ⵏ ⵉⵛⵜ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵜ ⴰⴷ ⵜⵉⵍⵉ ⴰⵔⴻⴱⵄⴰ ⵏ ⵉⵖⴰⴵⴻⵏ. ⵃⵉⵟⵄⴰⵛ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵉⵏ ⴰⴷ ⵖⴰⵔⵙⴻⵏⵜ ⵢⵉⵍⵉ ⵍⴻⵄⴱⴰⵔ ⴷ ⵉⵊⵊ. ");
INSERT INTO rift_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","ⴰⴷ ⵜⴻⵙⵙⵎⵓⵏⴻⴷ ⵅⴻⵎⵙⴰ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵉⵏ ⵡⴻⵃⵃⴻⴷⵙⴻⵏⵜ ⴷ ⵙⴻⵜⵜⴰ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵉⵏ ⵄⴰⵡⴻⴷ ⵡⴻⵃⵃⴻⴷⵙⴻⵏⵜ. ⵜⴰⵊⴰⵔⵜⵉⵍⵜ ⵡⵉⵙⵙ ⵙⴻⵜⵜⴰ ⴰⴷ ⵜⵜ ⵜⴹⴻⴼⵚⴻⴷ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵓⵇⵉⴹⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵅⴻⵎⵙⵉⵏ ⵏ ⵜⵙⴰⵔⴰⵡⵉⵏ ⵖⴰⵔ ⵜⵎⴰ ⵏ ⵢⵉⵛⵜ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵜ ⵖⴰⵔ ⵟⵟⴰⵔⴼ ⵖⴰⵔ ⵓⵙⴻⵍⵇⵉ, ⵓⵛⴰ ⵅⴻⵎⵙⵉⵏ ⵏ ⵜⵙⴰⵔⴰⵡⵉⵏ ⵅ ⵜⵎⴰ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵜ ⵖⴰⵔ ⵓⵙⴻⵍⵇⵉ ⵏⵏⴻⵖⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵅⴻⵎⵙⵉⵏ ⵏ ⵜⵙⴻⵏⵏⴰⵔⵉⵏ ⵏ ⵏⵏⵃⴰⵙ ⵓⵛⴰ ⴰⴷ ⵜⴻⵏⵜ ⵜⴻⵙⵙⵉⴷⴼⴻⴷ ⴷⵉ ⵜⵙⴰⵔⴰⵡⵉⵏ ⵓⵛⴰ ⴰⴷ ⵜⴻⵙⵙⵎⵓⵏⴻⴷ ⴰⵇⵉⴹⵓⵏ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵉⵊⵊⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","ⵎⵉⵏ ⵉⵛⴻⵟⵟⴻⵏ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵉⵏ ⵏ ⵓⵇⵉⴹⵓⵏ, ⴰⵣⵢⴻⵏ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵜ ⵏⵏⵉ ⵉⵛⴻⵟⵟⴻⵏ ⴰⴷ ⵢⴰⵢⴻⵍ ⵖⴰⵔ ⴹⴻⴼⴼⴰⵔ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ. ");
INSERT INTO rift_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","ⵣⵉ ⵎⵉⵏ ⵉⵛⴻⵟⵟⴻⵏ ⴷⵉ ⵜⵓⵣⵣⴻⴳⴳⴰⵔⵜ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵉⵏ, ⵉⵊⵊ ⵏ ⵓⵖⵉⵍ ⴰⴷ ⵢⴰⵢⴻⵍ ⵖⴰⵔ ⵢⵉⵊⵊ ⵏ ⵟⵟⴰⵔⴼ ⴷ ⵉⵊⵊ ⵏ ⵓⵖⵉⵍ ⵖⴰⵔ ⵟⵟⴰⵔⴼ ⵏⵏⴻⵖⵏⵉ, ⵖⴰⵔ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵖⴻⵣⴷⵉⵙⴻⵏ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴰⵙ ⵉⵍⴻⵃⵃⴻⴼ ⵉ ⵢⵉⵊⵊ ⵏ ⵓⵖⴻⵣⴷⵉⵙ ⵓ ⵉ ⵓⵖⴻⵣⴷⵉⵙ ⵏⵏⴻⵖⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵉ ⵓⵇⵉⴹⵓⵏ ⵄⴰⵡⴻⴷ ⵉⵛⵜ ⵏ ⵜⵙⴻⵇⵇⴰⴼⵜ ⵏ ⵉⵍⵎⴰⵡⴻⵏ ⵉⵣⴻⴳⴳⵯⴰⵖⴻⵏ ⵏ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ ⵓ ⵙⴻⵏⵏⴻⵊ ⵉ ⵎⴰⵏ ⴰⵢⴰ ⵉⵛⵜ ⵏ ⵜⵙⴻⵇⵇⴰⴼⵜ ⵏ ⵉⵍⵎⴰⵡⴻⵏ ⵏ ⴷⴷⴻⵏⴼⵉⵍⴰⵜ. ");
INSERT INTO rift_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵉ ⵜⵣⴻⴷⴷⵉⵖⵜ ⵜⵉⴼⴻⵍⵡⵉⵏ ⵏ ⵓⴽⴻⵛⵛⵓⴹ ⵏ ⵜⵛⴻⵊⵊⴰⵔⵜ ⵏ ⵓⴽⴰⵙⵉⵢⴰ ⵏⵏⵉ ⵉⴱⴻⴷⴷⴻⵏ ⵏⵉⵛⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","ⵍⴻⵄⴱⴰⵔ ⵏ ⵜⵓⵣⵣⴻⴳⴳⴰⵔⵜ ⵏ ⵉⵛⵜ ⵏ ⵜⴻⴼⵍⴰⵡⵜ ⴷⴰⵢⴻⵙ ⵄⴻⵛⵔⴰ ⵏ ⵉⵖⴰⴵⴻⵏ ⵓ ⵍⴻⵄⴱⴰⵔ ⵏ ⵜⵉⵔⵓ ⵏ ⵉⵛⵜ ⵏ ⵜⴻⴼⵍⴰⵡⵜ ⴷⴰⵢⴻⵙ ⵉⵊⵊ ⵏ ⵓⵖⵉⵍ ⴷ ⵡⴻⵣⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","ⵉ ⴽⵓⵍ ⵜⴰⴼⵍⴰⵡⵜ ⴰⴷ ⵖⴰⵔⴻⵙ ⵉⵍⵉⵏ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⴹⴰⵔⴻⵏ, ⵉⵏⵏⵉ ⵉⵙⵙⵎⴻⵍⵇⴰⵏ ⵜⵡⴻⵍⵜⵎⴰⵜⵉⵏ ⵉⵛⵜ ⴰⴽ-ⴷ ⵜⴻⵏⵏⴻⵖⵏⵉⵜ, ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵜⴻⴳⴳⴻⴷ ⵉ ⵎⴰⵔⵔⴰ ⵜⵉⴼⴻⵍⵡⵉⵏ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ. ");
INSERT INTO rift_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵉ ⵜⵣⴻⴷⴷⵉⵖⵜ ⵜⵉⴼⴻⵍⵡⵉⵏ, ⵄⵉⵛⵔⵉⵏ ⵏ ⵜⴼⴻⵍⵡⵉⵏ ⵖⴰⵔ ⵊⵊⵉⵀⴻⵜ ⵏ ⵍⵊⴰⵏⵓⴱ, ⵖⴰⵔ ⵢⴻⴼⵓⵙ. ");
INSERT INTO rift_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⴰⵔⴻⴱⵄⵉⵏ ⵏ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⴻⵏⵜ ⵙⵙⴰⵔⵙⴻⵏ ⵙⴰⴷⵓ ⵄⵉⵛⵔⵉⵏ ⵏ ⵜⴼⴻⵍⵡⵉⵏ, ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵙⴰⴷⵓ ⵉⵛⵜ ⵏ ⵜⴻⴼⵍⴰⵡⵜ ⵉ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⴹⴰⵔⴻⵏ ⵏⵏⴻⵙ, ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵙⴰⴷⵓ ⵜⴰⴼⵍⴰⵡⵜ ⵏⵏⴻⵖⵏⵉ ⵉ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⴹⴰⵔⴻⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","ⵄⴰⵡⴻⴷ ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵄⵉⵛⵔⵉⵏ ⵏ ⵜⴼⴻⵍⵡⵉⵏ ⵉ ⵓⵖⴻⵣⴷⵉⵙ ⵏⵏⴻⵖⵏⵉ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ, ⵖⴰⵔ ⵊⵊⵉⵀⴻⵜ ⵏ ⵛⵛⴰⵎⴰⵍ, ");
INSERT INTO rift_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","ⵙ ⴰⵔⴻⴱⵄⵉⵏ ⵏ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵏⵙⴻⵏ ⵏ ⵏⵏⵓⵇⴰⵔⵜ: ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵉ ⴽⵓⵍ ⵜⴰⴼⵍⴰⵡⵜ ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵙⴰⴷⵓ ⵜⴰⴼⵍⴰⵡⵜ ⵏⵏⴻⵖⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","ⵓ ⵖⴰⵔ ⵓⵖⴻⵣⴷⵉⵙ ⵏ ⵍⵖⴰⵔⴱ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ ⴰⴷ ⴰⵙ ⵜⴻⴳⴳⴻⴷ ⵙⴻⵜⵜⴰ ⵏ ⵜⴼⴻⵍⵡⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴼⴻⵍⵡⵉⵏ ⵉ ⵜⵖⴻⵎⵎⵓⵔⴰ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ ⵉ ⵉⴵⴰⵏ ⵖⴰⵔ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵖⴻⵣⴷⵉⵙⴻⵏ ⵏ ⴹⴻⴼⴼⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","ⵣⵉ ⵙⵡⴰⴷⴷⴰⵢ ⴰⴷ ⵉⵍⵉⵏⵜ ⵚⵇⴻⵏⵜ ⴰⵎ ⵡⴰⵛⵏⵉⵡⴻⵏ ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵉⵍⵉⵏⵜ ⵏⵉⵛⴰⵏ ⴷ ⵉⵛⵜⴻⵏ ⴰⵍ ⵖⴰ ⴰⵡⴹⴻⵏⵜ ⵙⴻⵏⵏⴻⵊ ⴷⴻⴳ ⵉⵛⵜ ⵏ ⵜⴻⵅⵔⴰⵣⵜ. ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵢⵉⵍⵉ ⵉ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴼⴻⵍⵡⵉⵏ ⵖⴰⵔ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵖⴻⵎⵎⵓⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","ⴰⴷ ⴷⵉⵏ ⵉⵍⵉⵏⵜ ⵜⵎⴻⵏⵢⴰ ⵏ ⵜⴼⴻⵍⵡⵉⵏ ⴰⴽ-ⴷ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵏⵙⴻⵏⵜ ⵏ ⵏⵏⵓⵇⴰⵔⵜ. ⵅⴻⵏⵏⵉ ⵙⴻⵟⵟⴰⵛ ⵏ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ, ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵙⴰⴷⵓ ⵉⵛⵜ ⵏ ⵜⴻⴼⵍⴰⵡⵜ ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵙⴰⴷⵓ ⵜⴰⴼⵍⴰⵡⵜ ⵏⵏⴻⵖⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵜⵉⵃⴻⵏⵢⴰ ⵏ ⵓⵄⴰⵔⵔⴻⴹ ⵣⴻⴳ ⵓⴽⴻⵛⵛⵓⴹ ⵏ ⵜⵛⴻⵊⵊⴰⵔⵜ ⵏ ⵓⴽⴰⵙⵉⵢⴰ, ⵉⵏⵏⵉ ⵖⴰ ⵉⵄⴷⵓⵏ ⵅ ⵜⴼⴻⵍⵡⵉⵏ, ⵅⴻⵎⵙⴰ ⵉ ⵜⴼⴻⵍⵡⵉⵏ ⵏ ⵉⵊⵊ ⵏ ⵓⵖⴻⵣⴷⵉⵙ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ ");
INSERT INTO rift_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","ⵓ ⵅⴻⵎⵙⴰ ⵏ ⵜⵃⴻⵏⵢⴰ ⵏ ⵓⵄⴰⵔⵔⴻⴹ ⵉ ⵜⴼⴻⵍⵡⵉⵏ ⵖⴰⵔ ⵓⵖⴻⵣⴷⵉⵙ ⵏⵏⴻⵖⵏⵉ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ ⵓ ⵅⴻⵎⵙⴰ ⵏ ⵜⵃⴻⵏⵢⴰ ⵏ ⵓⵄⴰⵔⵔⴻⴹ ⵉ ⵜⴼⴻⵍⵡⵉⵏ ⵏ ⵓⵖⴻⵣⴷⵉⵙ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ ⵖⴰⵔ ⵓⵖⴻⵣⴷⵉⵙ ⵏ ⵍⵖⴰⵔⴱ ⵖⴰⵔ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵖⴻⵣⴷⵉⵙⴻⵏ ⵏ ⴹⴻⴼⴼⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","ⵜⴰⵃⵏⴰⵛⵜ ⵏ ⵓⵄⴰⵔⵔⴻⴹ ⴷⵉ ⵍⵡⴻⵙⵟ ⴰⴷ ⵜⴻⵄⴷⵓ ⵅ ⵜⴼⴻⵍⵡⵉⵏ ⴷⵉ ⵍⵡⴻⵙⵟ, ⵣⴻⴳ ⵉⵊⵊ ⵏ ⵢⵉⵅⴻⴼ ⵖⴰⵔ ⵡⴻⵏⵏⴻⵖⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","ⴰⴷ ⵜⵖⴻⴵⴼⴻⴷ ⵜⵉⴼⴻⵍⵡⵉⵏ ⵙ ⵡⵓⵔⴻⵖ ⵓⵛⴰ ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵜⵉⵅⵔⴰⵣⵉⵏ ⵏⵙⴻⵏ ⵏ ⵡⵓⵔⴻⵖ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴷⴰⵢⵙⴻⵏⵜ ⵙⵙⵉⴷⴼⴻⵏ ⵜⵉⵃⴻⵏⵢⴰ ⵏ ⵓⵄⴰⵔⵔⴻⴹ. ⴰⴷ ⵜⴻⴷⵍⴻⴷ ⵄⴰⵡⴻⴷ ⵜⵉⵃⴻⵏⵢⴰ ⵏ ⵓⵄⴰⵔⵔⴻⴹ ⵙ ⵡⵓⵔⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","ⴰⴷ ⵜⴻⵙⵙⴳⴻⵄⵄⴷⴻⴷ ⵜⴰⵣⴻⴷⴷⵉⵖⵜ ⵄⵍⴰⵃⵙⴰⴱ ⴰⵎⴻⴷⵢⴰ ⵏ ⵍⴻⴱⵏⵉ ⵏⵏⵉ ⴷ ⴰⵛ ⵉⵜⵜⵡⴰⵎⵍⴻⵏ ⵅ ⵡⴻⴷⵔⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","ⴰⴷ ⵜⴻⴳⴳⴻⴹ ⵉⵊⵊ ⵏ ⵓⵍⴻⵃⵃⴰⴼ ⵙ ⵓⴼⵉⵍⵓ ⴰⴷⴻⵃⵎⵉ ⴷ ⵓⵔⵊⵓⵡⴰⵏⵉ ⴷ ⵓⵣⴻⴳⴳⵯⴰⵖ ⵉⵃⴻⴷⵇⴻⵏ ⵓ ⵙ ⵍⴻⵇⵟⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵎⵓⴷⴻⵏ, ⴰⴷ ⵜ ⴳⴳⴻⵏ ⴰⵎ ⵍⵅⴻⴷⵎⴻⵜ ⵏ ⵓⴼⴻⵏⵏⴰⵏ, ⵓⵛⴰ ⵉⴽⵉⵔⵓⴱⴻⵏ ⴰⴷ ⵅⴰⵙ ⵉⵍⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","ⴰⴷ ⵜ ⵜⴰⵢⵍⴻⴷ ⵅ ⴰⵔⴻⴱⵄⴰ ⵏ ⵉⴱⵉⵍⴰⵔⴻⵏ ⵏ ⵓⴽⴻⵛⵛⵓⴹ ⵏ ⵜⵛⴻⵊⵊⴰⵔⵜ ⵏ ⵓⴽⴰⵙⵉⵢⴰ ⵉ ⵉⴷⵍⵉⵏ ⵙ ⵡⵓⵔⴻⵖ. ⵜⵉⵙⴻⵏⵏⴰⵔⵉⵏ ⵏⵙⴻⵏ ⴰⴷ ⵉⵍⵉⵏⵜ ⵏ ⵡⵓⵔⴻⵖ ⵓⵛⴰ ⵉⴱⵉⵍⴰⵔⴻⵏ ⵏⵏⵉ ⴰⴷ ⴱⴻⴷⴷⴻⵏ ⵅ ⴰⵔⴻⴱⵄⴰ ⵏ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵏ ⵏⵏⵓⵇⴰⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","ⴰⴷ ⵜⴰⵢⵍⴻⴷ ⴰⵍⴻⵃⵃⴰⴼ ⵖⴰⵔ ⵡⴰⴷⴷⴰⵢ ⵏ ⵜⵙⴻⵏⵏⴰⵔⵉⵏ ⵓⵛⴰ ⴰⴷ ⵜⴻⵙⵙⵉⴷⴼⴻⴷ ⵜⵜⴰⴱⵓⵜ ⵏ ⵛⵛⵀⴰⴷⴻⵜ ⴷⴰⵅⴻⵍ ⵉ ⵓⵍⴻⵃⵃⴰⴼ ⵓⵛⴰ ⴰⵍⴻⵃⵃⴰⴼ ⴰⴷ ⵉⴱⴹⴰ ⵊⴰⵔ ⵓⵇⴻⴷⴷⴰⵙ ⴷ ⵡⴻⵇⴷⴰⵙ ⵅ ⵓⵇⴻⴷⴷⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","ⴰⴷ ⵜⴻⵙⵙⴰⵔⵙⴻⴷ ⵜⴰⵇⴻⴱⴱⴰⵔⵜ ⵏ ⵡⴻⵚⵍⴰⵃ ⵅ ⵜⵜⴰⴱⵓⵜ ⵏ ⵛⵛⵀⴰⴷⴻⵜ ⴷⴻⴳ ⵡⴻⵇⴷⴰⵙ ⵅ ⵓⵇⴻⴷⴷⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵜⴰⵣⴻⵡⴹⴰ ⴱⴰⵔⵔⴰ ⵉ ⵓⵍⴻⵃⵃⴰⴼ ⵓⵛⴰ ⴰⴷ ⵜⴻⵙⵙⴰⵔⵙⴻⴷ ⵍⵇⴻⵏⴷⵉⵍ ⵇⵉⴱⴰⵍⵜ ⵉ ⵜⵣⴻⵡⴹⴰ ⵖⴰⵔ ⵓⵖⴻⵣⴷⵉⵙ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ ⵖⴰⵔ ⵊⵊⵉⵀⴻⵜ ⵏ ⵍⵊⴰⵏⵓⴱ ⵓ ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵜⴰⵣⴻⵡⴹⴰ ⵖⴰⵔ ⵓⵖⴻⵣⴷⵉⵙ ⵖⴰⵔ ⵊⵊⵉⵀⴻⵜ ⵏ ⵛⵛⴰⵎⴰⵍ. ");
INSERT INTO rift_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⴰⵔⵡⴰⵇ ⵙ ⵓⴼⵉⵍⵓ ⴰⴷⴻⵃⵎⵉ ⴷ ⵓⵔⵊⵓⵡⴰⵏⵉ ⴷ ⵓⵣⴻⴳⴳⵯⴰⵖ ⵉⵃⴻⴷⵇⴻⵏ ⵓ ⵙ ⵍⴻⵇⵟⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵎⵓⴷⴻⵏ ⵉ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ, ⴰⵎ ⵉⵊⵊ ⵏ ⵓⵎⵓⴷⵉ ⵏ ⵓⵅⴻⵢⵢⴰⴹ. ");
INSERT INTO rift_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","ⵓⵛⴰ ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵉ ⴰⵔⵡⴰⵇ ⵅⴻⵎⵙⴰ ⵏ ⵉⴱⵉⵍⴰⵔⴻⵏ ⵏ ⵓⴽⴻⵛⵛⵓⴹ ⵏ ⵜⵛⴻⵊⵊⴰⵔⵜ ⵏ ⵓⴽⴰⵙⵉⵢⴰ ⵓⵛⴰ ⴰⴷ ⵜⴻⵏ ⵜⵛⴻⵍⵍⴻⴷ ⵙ ⵡⵓⵔⴻⵖ. ⵜⵉⵙⴻⵏⵏⴰⵔⵉⵏ ⵏⵙⴻⵏ ⴰⴷ ⵉⵍⵉⵏⵜ ⵏ ⵡⵓⵔⴻⵖ ⵓ ⵉ ⵉⴱⵉⵍⴰⵔⴻⵏ ⵏⵏⵉ ⴰⴷ ⴰⵙⴻⵏ ⵜⴼⴻⵙⵢⴻⴷ ⵅⴻⵎⵙⴰ ⵏ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵏ ⵏⵏⵃⴰⵙ.” * ");
INSERT INTO rift_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⴰⵄⴰⵍⵟⴰⵔ ⵏ ⵓⴽⴻⵛⵛⵓⴹ ⵏ ⵓⴽⴰⵙⵉⵢⴰ ⵏ ⵅⴻⵎⵙⴰ ⵏ ⵉⵖⴰⴵⴻⵏ ⴷⵉ ⵜⵓⵣⵣⴻⴳⴳⴰⵔⵜ ⴷ ⵅⴻⵎⵙⴰ ⵏ ⵉⵖⴰⴵⴻⵏ ⴷⵉ ⵜⵉⵔⵓ. ⴰⴷ ⵢⵉⵍⵉ ⵙ ⴰⵔⴻⴱⵄⴰ ⵏ ⵜⵖⴻⵎⵎⵓⵔⴰ ⵓ ⵍⵓⵄⵍⴰ ⵏⵏⴻⵙ ⴰⴷ ⵢⵉⵍⵉ ⵜⵍⴰⵜⴰ ⵏ ⵉⵖⴰⴵⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","ⵖⴰⵔ ⴰⵔⴻⴱⵄⴰ ⵏ ⵜⵖⴻⵎⵎⵓⵔⴰ ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⴰⵛⵛⴰⵡⴻⵏ ⵏⵏⴻⵙ. ⴰⵛⵛⴰⵡⴻⵏ ⵏⵏⴻⵙ ⴰⴷ ⴷⴻⵡⵍⴻⵏ ⴷ ⵉⵊⵊⴻⵏ ⴰⴽⵉⴷⴻⵙ ⵓⵛⴰ ⴰⴷ ⵜ ⵜⵍⴻⵃⵃⴼⴻⴷ ⵙ ⵏⵏⵃⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵜⵉⵢⴷⵓⵔⵉⵏ ⵏⵏⴻⵙ, ⵃⵉⵎⴰ ⴰⴷ ⴷⴰⵢⵙⴻⵏⵜ ⵜⴻⵏⴹⴰⵔⴻⴷ ⵉⵖⵖⴻⴹ ⵏ ⵎⵉⵏ ⵉⵇⵇⵉⵎⴻⵏ ⵏ ⵜⴰⴷⵓⵏⵜ ⵏⵏⴻⵙ ⵉⵜⵜⵡⴰⵛⴻⵎⴹⴻⵏ ⵓⵛⴰ ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵄⴰⵡⴻⴷ ⵉⵖⴻⵏⵊⴰⵢⴻⵏ ⵏⵏⴻⵙ ⴷ ⵟⵟⴰⵡⵢⴰⵜ ⵏⵏⴻⵙ ⵉ ⵓⵔⵓⵛⵛⵉ ⴷ ⴼⵓⵔⵛⴰⵢⴰⵜ ⵏⵏⴻⵙ ⴷ ⵜⵎⴻⵊⵎⴰⵔⵉⵏ ⵏⵏⴻⵙ. ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ ⵏⵏⴻⵙ ⵙ ⵏⵏⵃⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵉⵛⵜ ⵏ ⵜⵔⴰⵛⵛⴰ, ⵉⵛⵜ ⵏ ⵓⵎⵓⴷⵉ ⵏ ⵏⵏⵃⴰⵙ, ⵓⵛⴰ ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⴰⵔⴻⴱⵄⴰ ⵏ ⵜⴻⵅⵔⴰⵣⵉⵏ ⵏ ⵏⵏⵃⴰⵙ ⵉ ⵓⵎⵓⴷⵉ ⵏⵏⵉ, ⵖⴰⵔ ⴰⵔⴻⴱⵄⴰ ⵏ ⵜⵖⴻⵎⵎⵓⵔⴰ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","ⴰⴷ ⵜ ⵜⵣⴻⵢⵢⴰⵔⴻⴷ ⵙⴰⴷⵓ ⵉ ⵜⵎⴰ ⵏ ⵓⵄⴰⵍⵟⴰⵔ, ⵙⵡⴰⴷⴷⴰⵢ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵢⵉⵍⵉ ⵓⵎⵓⴷⵉ ⵏ ⵏⵏⵃⴰⵙ ⵏⵏⵉ ⵖⴰⵔ ⵡⴻⵣⵢⴻⵏ ⵏ ⵓⵄⴰⵍⵟⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵉⵄⵓⵎⴰⴷ ⵉ ⵜⴰⵔⴻⴱⴱⵓⵜ ⵉ ⵓⵄⴰⵍⵟⴰⵔ, ⵉⵄⵓⵎⴰⴷ ⵏ ⵓⴽⴻⵛⵛⵓⴹ ⵏ ⵓⴽⴰⵙⵉⵢⴰ ⵓⵛⴰ ⴰⴷ ⵜⴻⵏ ⵜⵍⴻⵃⵃⴼⴻⴷ ⵙ ⵏⵏⵃⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","ⵉⵄⵓⵎⴰⴷ ⵏⵏⴻⵙ ⴰⴷ ⵜⵜⵡⴰⵙⵙⵉⴷⴼⴻⵏ ⴷⵉ ⵜⴻⵅⵔⴰⵣⵉⵏ. ⴰⴷ ⵉⵍⵉⵏ ⵉⵄⵓⵎⴰⴷ ⵉ ⵜⴰⵔⴻⴱⴱⵓⵜ ⵖⴰⵔ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵖⴻⵣⴷⵉⵙⴻⵏ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ⵅⵎⵉ ⵜ ⵖⴰ ⴰⵔⴱⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵉⵊⵊ ⵏ ⵍⵅⴰⵡⵉ ⵖⴰⵔ ⴷⴰⵅⴻⵍ ⵏ ⵜⴼⴻⵍⵡⵉⵏ. ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵉ ⴷ ⴰⵛ ⵉⵎⵍⴰ ⵅ ⵡⴻⴷⵔⴰⵔ, ⴰⵎⵎⵓ ⵉ ⵜ ⵖⴰ ⴳⴳⴻⵏ ⵏⵉⵜⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵍⴻⵎⵔⴰⵃ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ. ⵖⴰⵔ ⵊⵊⵉⵀⴻⵜ ⵏ ⵍⵊⴰⵏⵓⴱ, ⵖⴰⵔ ⵢⴻⴼⵓⵙ, ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵍⵉⵣⴰⵔⴰⵜ ⵙ ⵍⴻⵇⵟⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵎⵓⴷⴻⵏ, ⴽⵓⵍ ⵉⵛⵜ ⵣⵣⴰⵢⵙⴻⵏⵜ ⵏ ⵎⵢⴰ ⵏ ⵉⵖⴰⴵⴻⵏ ⴷⵉ ⵜⵓⵣⵣⴻⴳⴳⴰⵔⵜ ⵉ ⵢⵉⵊⵊ ⵏ ⵓⵖⴻⵣⴷⵉⵙ. ");
INSERT INTO rift_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","ⵄⵉⵛⵔⵉⵏ ⵏ ⵉⴱⵉⵍⴰⵔⴻⵏ ⵏⵏⴻⵙ ⴷ ⵄⵉⵛⵔⵉⵏ ⵏ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵏⵏⴻⵙ ⴰⴷ ⵉⵍⵉⵏ ⵏ ⵏⵏⵃⴰⵙ. ⵜⵉⵙⴻⵏⵏⴰⵔⵉⵏ ⵏ ⵉⴱⵉⵍⴰⵔⴻⵏ ⴷ ⵉⵇⴻⴹⴱⴰⵏ ⵏⵙⴻⵏ ⵉ ⵓⵙⴻⵍⵇⵉ ⴰⴷ ⵉⵍⵉⵏ ⵏ ⵏⵏⵓⵇⴰⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","ⴰⵎⵎⵓ ⵖⴰⵔ ⵊⵊⵉⵀⴻⵜ ⵏ ⵛⵛⴰⵎⴰⵍ, ⴷⵉ ⵜⵓⵣⵣⴻⴳⴳⴰⵔⵜ, ⴰⴷ ⴷⵉⵏ ⵉⵍⵉⵏⵜ ⵍⵉⵣⴰⵔⴰⵜ ⵏ ⵎⵢⴰ ⵉⵖⴰⴵⴻⵏ. ⴰⴷ ⵉⵍⵉⵏ ⵄⵉⵛⵔⵉⵏ ⵏ ⵉⴱⵉⵍⴰⵔⴻⵏ ⵏⵙⴻⵏⵜ ⴷ ⵄⵉⵛⵔⵉⵏ ⵏ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵏⵙⴻⵏ ⵏ ⵏⵏⵃⴰⵙ. ⵜⵉⵙⴻⵏⵏⴰⵔⵉⵏ ⵏ ⵉⴱⵉⵍⴰⵔⴻⵏ ⴷ ⵉⵇⴻⴹⴱⴰⵏ ⵏⵙⴻⵏ ⵉ ⵓⵙⴻⵍⵇⵉ ⴰⴷ ⵉⵍⵉⵏ ⵏ ⵏⵏⵓⵇⴰⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","ⴷⵉ ⵜⵉⵔⵓ ⵏ ⵍⴻⵎⵔⴰⵀ, ⵖⴰⵔ ⵓⵖⴻⵣⴷⵉⵙ ⵏ ⵍⵖⴰⵔⴱ, ⴰⴷ ⴷⵉⵏ ⵉⵍⵉⵏⵜ ⵍⵉⵣⴰⵔⴰⵜ ⵏ ⵅⴻⵎⵙⵉⵏ ⵏ ⵉⵖⴰⴵⴻⵏ ⴷⵉ ⵜⵓⵣⵣⴻⴳⴳⴰⵔⵜ ⴰⴽ-ⴷ ⵄⴻⵛⵔⴰ ⵏ ⵉⴱⵉⵍⴰⵔⴻⵏ ⵏⵙⴻⵏⵜ ⴷ ⵄⴻⵛⵔⴰ ⵏ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","ⵜⵉⵔⵓ ⵏ ⵍⴻⵎⵔⴰⵃ ⵖⴰⵔ ⵓⵖⴻⵣⴷⵉⵙ ⵏ ⵛⵛⴰⵔⵇ, ⵣⵉ ⵎⴰⵏⵉⵙ ⴷⴷ-ⵜⵏⴻⵇⵇⴰⵔ ⵜⴼⵓⵛⵜ, ⴰⴷ ⵜⵉⵍⵉ ⵅⴻⵎⵙⵉⵏ ⵉⵖⴰⴵⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","ⵍⵉⵣⴰⵔⴰⵜ ⵖⴰⵔ ⵢⵉⵊⵊ ⵏ ⵓⵖⴻⵣⴷⵉⵙ ⵏ ⵣⵣⴰⵜ ⴰⴷ ⵉⵍⵉⵏⵜ ⵅⴻⵎⵎⴻⵙⵟⴰⵛ ⵏ ⵉⵖⴰⴵⴻⵏ ⴷⵉ ⵜⵓⵣⵣⴻⴳⴳⴰⵔⵜ, ⴰⴽ-ⴷ ⵜⵍⴰⵜⴰ ⵏ ⵉⴱⵉⵍⴰⵔⴻⵏ ⵏⵙⴻⵏⵜ ⴷ ⵜⵍⴰⵜⴰ ⵏ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","ⵖⴰⵔ ⵓⵖⴻⵣⴷⵉⵙ ⵏ ⵣⵣⴰⵜ ⵏⵏⴻⵖⵏⵉ ⴰⴷ ⴷⵉⵏ ⵉⵍⵉⵏⵜ ⵄⴰⵡⴻⴷ ⵍⵉⵣⴰⵔⴰⵜ ⵏ ⵅⴻⵎⵎⴻⵙⵟⴰⵛ ⵏ ⵉⵖⴰⴵⴻⵏ ⴷⵉ ⵜⵓⵣⵣⴻⴳⴳⴰⵔⵜ ⴰⴽ-ⴷ ⵜⵍⴰⵜⴰ ⵏ ⵉⴱⵉⵍⴰⵔⴻⵏ ⵏⵙⴻⵏⵜ ⴷ ⵜⵍⴰⵜⴰ ⵏ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵍⴻⵎⵔⴰⵃ ⴰⴷ ⴷⵉⵏ ⵢⵉⵍⵉ ⵉⵊⵊ ⵏ ⴰⵔⵡⴰⵇ ⵏ ⵄⵉⵛⵔⵉⵏ ⵏ ⵉⵖⴰⴵⴻⵏ, ⴳⴳⵉⵏ ⵜ ⵙ ⵓⴼⵉⵍⵓ ⴰⴷⴻⵃⵎⵉ ⴷ ⵓⵔⵊⵓⵡⴰⵏⵉ ⴷ ⵓⵣⴻⴳⴳⵯⴰⵖ ⵉⵃⴻⴷⵇⴻⵏ ⵓ ⵙ ⵍⴻⵇⵟⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵎⵓⴷⴻⵏ, ⵉⵊⵊ ⵏ ⵓⵎⵓⴷⵉ ⵏ ⵓⵅⴻⵢⵢⴰⴹ, ⴰⴽ-ⴷ ⴰⵔⴻⴱⵄⴰ ⵏ ⵉⴱⵉⵍⴰⵔⴻⵏ ⵏⵏⴻⵙ ⴷ ⴰⵔⴻⴱⵄⴰ ⵏ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","ⵎⴰⵔⵔⴰ ⵉⴱⵉⵍⴰⵔⴻⵏ ⵉ ⴷ ⴰⵙ ⴷⴷ-ⵉⵏⵏⴹⴻⵏ ⵉ ⵍⴻⵎⵔⴰⵃ ⴰⴷ ⵉⵍⵉⵏ ⵙ ⵉⵇⴻⴹⴱⴰⵏ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵉ ⵓⵙⴻⵍⵇⵉ ⵓⵛⴰ ⵜⵉⵙⴻⵏⵏⴰⵔⵉⵏ ⵏⵙⴻⵏ ⴰⴷ ⵉⵍⵉⵏⵜ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⴷ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵏⵙⴻⵏ ⵏ ⵏⵏⵃⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","ⵜⵓⵣⵣⴻⴳⴳⴰⵔⵜ ⵏ ⵍⴻⵎⵔⴰⵃ ⴰⴷ ⵜⵉⵍⵉ ⵎⵢⴰ ⵏ ⵉⵖⴰⴵⴻⵏ ⵓ ⵜⵉⵔⵓ ⴰⴷ ⵜⵉⵍⵉ ⵅⴻⵎⵙⵉⵏ ⵏ ⵉⵖⴰⴵⴻⵏ ⴷ ⵅⴻⵎⵙⵉⵏ ⵄⴰⵡⴻⴷ ⵓⵛⴰ ⵍⵓⵄⵍⴰ ⴰⴷ ⵢⵉⵍⵉ ⵅⴻⵎⵙⴰ ⵏ ⵉⵖⴰⴵⴻⵏ, ⵎⴰⵔⵔⴰ ⵙ ⵍⴻⵇⵟⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵎⵓⴷⴻⵏ ⵓⵛⴰ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵏⵙⴻⵏ ⴰⴷ ⵉⵍⵉⵏⵜ ⵏ ⵏⵏⵃⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ ⵉ ⵉⴵⴰⵏ ⵉ ⵎⴰⵔⵔⴰ ⵜⴰⵙⴻⵅⵅⴰⵔⵜ ⵏⵏⴻⵙ ⵓⵍⴰ ⴷ ⵎⴰⵔⵔⴰ ⵍⴻⵡⵜⴰⴷ ⵏⵏⴻⵙ ⴷ ⵎⴰⵔⵔⴰ ⵍⴻⵡⵜⴰⴷ ⵏ ⵍⴻⵎⵔⴰⵃ ⴰⴷ ⵉⵍⵉⵏ ⵏ ⵏⵏⵃⴰⵙ. * ");
INSERT INTO rift_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","ⴰⴷ ⵜⵓⵎⵓⵔⴻⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵃⵉⵎⴰ ⴰⴷ ⴰⵛ ⴷⴷ-ⴰⵡⵢⴻⵏ ⵣⵣⴻⵛⵜ ⵜⴻⵚⴼⴰ ⵜⴻⴷⴷⴻⵣ ⵣⵉ ⵣⵣⵉⵜⵓⵏ ⵉ ⵜⴼⴰⵡⵜ, ⵃⵉⵎⴰ ⴰⴷ ⵜⴰⵔⴻⵖ ⵜⴼⴰⵡⵜ ⵍⴻⴱⴷⴰ. ");
INSERT INTO rift_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⴰⴷ ⵃⴹⴰⵏ ⵎⴰⵏ ⴰⵢⴰ ⵣⵉ ⴵⵉⵍⴻⵜ ⴰⵍ ⵚⵚⴱⴻⵃ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⴷⴻⴳ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⵣⵣⴰⵜ ⵉ ⵓⵍⴻⵃⵃⴰⴼ ⵉ ⵉⴵⴰⵏ ⵣⵣⴰⵜ ⵉ ⵛⵛⵀⴰⴷⴻⵜ. ⴷ ⵎⴰⵏ ⴰⵢⴰ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵚⴻⵢⵢⴻⵜ ⵉ ⵍⴻⴱⴷⴰ ⵏⵏⵉ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜᵉⵜⵜⵡⴰⵃⴹⴰ ⵣⵉ ⵊⵊⵉⵀⴻⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴷⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵏⵙⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“ⵓⵛⴰ ⵛⴻⴽ ⴰⴷ ⵖⴰⵔⴻⴽ ⴷⴷ-ⵜⴻⵙⵙⵇⴰⵔⵔⴱⴻⴷ ⵀⴰⵔⵓⵏ, ⵓⵎⴰⵛ, ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⴰⴽⵉⴷⴻⵙ ⵣⵉ ⵍⵡⴻⵙⵟ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵃⵉⵎⴰ ⴰⴷ ⴰⵢⵉ ⵄⴻⴱⴷⴻⵏ ⴰⵎ ⵢⵉⴽⴻⵀⵀⴰⵏⴻⵏ, ⵀⴰⵔⵓⵏ, ⵏⴰⴷⴰⴱ, ⴰⴱⵉⵀⵓ, ⴰⵍⵉⵄⴰⵣⴰⵔ ⴷ ⵉⵜⴰⵎⴰⵔ, ⵣⴻⴳ ⵡⴰⵔⵔⴰⵡ ⵏ ⵀⴰⵔⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⴰⵔⵔⵓⴹ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵉ ⵀⴰⵔⵓⵏ, ⵓⵎⴰⵛ, ⴰⴷ ⴰⵙ ⵢⵉⵍⵉ ⵉ ⵓⵄⵓⴵⵉ ⴷ ⵜⴻⵍⵡⵉⵣⵜ. ");
INSERT INTO rift_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","ⴰⴷ ⵜⴻⵙⵙⵉⵡⵍⴻⴷ ⵖⴰⵔ ⵎⴰⵔⵔⴰ ⵉⵏⵏⵉ ⵉⴵⴰⵏ ⴷ ⵉⵎⵉⵖⵉⵙⴻⵏ ⵏ ⵡⵓⵍ, ⵉⵏⵏⵉ ⵛⵛⵓⵔⴻⵖ ⵙ ⴰⵔⵔⵓⵃ ⵏ ⵜⵉⵖⵉⵜ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴳⴳⴻⵏ ⴰⵔⵔⵓⴹ ⵉ ⵀⴰⵔⵓⵏ, ⵃⵉⵎⴰ ⴰⴷ ⴰⵙ ⵙⵙⵇⴻⴷⴷⵙⴻⵏ ⴷ ⴰⴽⴻⵀⵀⴰⵏ ⵉ ⵏⴻⵛⵛ. ");
INSERT INTO rift_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","ⵉⵏⴰ ⴷ ⴰⵔⵔⵓⴹ ⵉ ⵖⴰ ⴳⴳⴻⵏ: ⵉⵛⵜ ⵏ ⵜⴻⵊⵎⴻⵛⵜ ⴷ ⵉⵊⵊ ⵏ ⵓⴱⴰⵍⵟⵓ ⴷ ⵉⵊⵊ ⵏ ⵓⵙⴻⵍⵀⴰⵎ ⴷ ⵉⵛⵜ ⵜⵛⴰⵎⵉⵔ ⵉⵎⵓⴷⴻⵏ ⴰⵎ ⵉⵊⵊ ⵏ ⵓⵔⴻⵇⵇⴰⵎ ⵏ ⵓⴼⴻⵏⵏⴰⵏ, ⴷ ⵉⵛⵜ ⵏ ⴰⵔⴻⵥⵥⴻⵜ ⴷ ⵉⵛⵜ ⵏ ⵜⵃⴻⵣⵣⴰⵎⵜ. ⴰⴷ ⴳⴳⴻⵏ ⴰⵔⵔⵓⴹ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵉ ⵀⴰⵔⵓⵏ, ⵓⵎⴰⵛ, ⵓ ⵉ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ, ⵃⵉⵎⴰ ⴰⴷ ⴰⵢⵉ ⵙⴻⵅⵅⴰⵔⴻⵏ ⴰⵎ ⵓⴽⴻⵀⵀⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","ⵏⵉⵜⵏⵉ ⴰⴷ ⴽⵙⵉⵏ ⵉⴼⵉⵍⴰⵏ ⵏ ⵡⵓⵔⴻⵖ ⴷ ⴰⴼⵉⵍⵓ ⴰⴷⴻⵃⵎⵉ ⴷ ⵓⵔⵊⵓⵡⴰⵏⵉ ⴷ ⵓⵣⴻⴳⴳⵯⴰⵖ ⵉⵃⴻⴷⵇⴻⵏ ⴷ ⵍⴻⵇⵟⴻⵏ ⴰⵣⴷⴰⴷ, ");
INSERT INTO rift_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","ⵓⵛⴰ ⴰⴷ ⴳⴳⴻⵏ ⴰⴱⴰⵍⵟⵓ ⵙ ⵉⴼⵉⵍⴰⵏ ⵏ ⵡⵓⵔⴻⵖ ⵓ ⵙ ⵓⴼⵉⵍⵓ ⴰⴷⴻⵃⵎⵉ ⴷ ⵓⵔⵊⵓⵡⴰⵏⵉ ⴷ ⵓⵣⴻⴳⴳⵯⴰⵖ ⵉⵃⴻⴷⵇⴻⵏ ⵓ ⵙ ⵍⴻⵇⵟⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵎⵓⴷⴻⵏ, ⴰⴷ ⵢⵉⵍⵉ ⴰⵎ ⵍⵅⴻⴷⵎⴻⵜ ⵏ ⵓⴼⴻⵏⵏⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","ⴰⴷ ⵖⴰⵔⴻⵙ ⵢⵉⵍⵉ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵖⴰⵔⴹⵉⵏ ⵉⵎⵎⵙⴻⵍⵙⴰⵇⴻⵏ ⵖⴰⵔ ⵜⵏⴰⵢⴻⵏ ⵏ ⵟⵟⵔⵓⴼⴰ ⵏⵏⴻⵙ ⵉ ⵣⵉ ⵖⴰ ⵉⵜⵜⵡⴰⵙⵙⵎⵓⵏ ⵓⴱⴰⵍⵟⵓ. ");
INSERT INTO rift_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","ⵜⴰⵃⴻⵣⵣⴰⵎⵜ ⵉⵣⴻⵡⵡⵇⴻⵏ, ⵡⴻⵏⵏⵉ ⵉⴵⴰⵏ ⵅ ⵓⴱⴰⵍⵟⵓ ⵏⵏⴻⵙ ⵏ ⵓⴽⴻⵀⵀⴰⵏ, ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵜᵉⵜⵜⵡⴰⴳⴳ ⴷ ⵉⵛⵜⴻⵏ ⴰⴽⵉⴷⴻⵙ, ⵙ ⵉⴼⵉⵍⴰⵏ ⵏ ⵡⵓⵔⴻⵖ ⵓ ⵙ ⵓⴼⵉⵍⵓ ⴰⴷⴻⵃⵎⵉ ⴷ ⵓⵔⵊⵓⵡⴰⵏⵉ ⴷ ⵓⵣⴻⴳⴳⵯⴰⵖ ⵉⵃⴻⴷⵇⴻⵏ ⵓ ⵙ ⵍⴻⵇⵟⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵎⵓⴷⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","ⴰⴷ ⵜⴻⴽⵙⵉⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵥⵔⴰ ⵏ ⵓⵏⵉⴽⵙ ⵓⵛⴰ ⴰⴷ ⵅⴰⵙⴻⵏ ⵜⵏⴻⵇⵛⴻⴷ ⵉⵙⵎⴰⵡⴻⵏ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","ⵙⴻⵜⵜⴰ ⵏ ⵉⵙⵎⴰⵡⴻⵏ ⵅ ⵢⵉⵊⵊ ⵏ ⵡⴻⵥⵔⵓ ⴷ ⵙⴻⵜⵜⴰ ⵏ ⵉⵙⵎⴰⵡⴻⵏ ⵏⵏⴻⵖⵏⵉ ⵅ ⵡⴻⵥⵔⵓ ⵏⵏⴻⵖⵏⵉ ⵄⵍⴰⵃⵙⴰⴱ ⴰⵙⴻⵜⵜⴻⴼ ⵏ ⵡⴻⵅⵍⴰⵇ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","ⴷ ⵎⴰⵏ ⴰⵢⴰ ⴷ ⵉⵛⵜ ⵏ ⵚⵚⴻⵏⵄⴻⵜ ⵏ ⵓⵏⴻⵇⵇⴰⵛ ⵏ ⵡⴻⵥⵔⵓ ⵉⵖⵍⴰⵏ. ⴰⵎ ⵉⵛⵜ ⵏ ⵜⵅⴰⴷⴻⵏⵜ ⵏ ⵓⵛⴻⵎⵎⵉⵄ, ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵜⵜⵡⴰⵏⴻⵇⵛⴻⵏ ⵜⵏⴰⵢⴻⵏ ⵏ ⵢⴻⵥⵔⴰ ⵙ ⵉⵙⵎⴰⵡⴻⵏ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ⴰⴷ ⴰⵙⴻⵏ ⵜⴻⴳⴳⴻⴷ ⵜⵉⵛⵓⵢⴰⵔ ⵏ ⵡⵓⵔⴻⵖ ⵉ ⴷ ⴰⵙ ⴷⴷ-ⵉⵏⵏⴹⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵉⵥⵔⴰ ⵏⵏⵉ ⵅ ⵜⵖⴰⵔⴹⵉⵏ ⵏ ⵓⴱⴰⵍⵟⵓ, ⴰⵇⴰ ⴰⵜⴻⵏ ⴷ ⵉⵥⵔⴰ ⵏ ⵍⵉⴷⴰⵔⴻⵜ ⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ⵀⴰⵔⵓⵏ ⴰⴷ ⵢⴰⵔⴱⵓ ⵉⵙⵎⴰⵡⴻⵏ ⵏⵙⴻⵏ ⵉ ⵍⵉⴷⴰⵔⴻⵜ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⵅ ⵜⵏⴰⵢⴻⵏ ⵜⵖⴰⵔⴹⵉⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵜⵉⵛⵓⵢⴰⵔ ⵏ ⵡⵓⵔⴻⵖ ");
INSERT INTO rift_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","ⵓⵛⴰ ⵄⴰⵡⴻⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵙⵙⵏⴰⵙⴻⵍ ⵏ ⵡⵓⵔⴻⵖ ⵉⵚⴼⴰⵏ. ⴰⴷ ⵜⴻⵏ ⵜⴻⴳⴳⴻⴷ ⴰⵎⴻⵛⵏⴰⵡ ⵉⴼⵉⵍⴰⵏ, ⴰⵎⴻⵛⵏⴰⵡ ⵉⵛⵜ ⵏ ⵍⵅⴻⴷⵎⴻⵜ ⵏ ⵓⵎⵓⴷⵉ. ⴰⴷ ⵜⵛⴻⴷⴷⴻⴷ ⵙⵙⵏⴰⵙⴻⵍ ⵉⵎⵓⴷⴻⵏ ⵖⴰⵔ ⵜⵛⵓⵢⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵜⴰⵊⵎⴻⵛⵜ ⵉ ⵍⴻⵃⴽⴰⵎ. ⴰⴷ ⵜⵜ ⵜⴻⴳⴳⴻⴷ ⴰⵎ ⵍⵅⴻⴷⵎⴻⵜ ⵏ ⵓⴼⴻⵏⵏⴰⵏ, ⴰⵎ ⵓⴱⴰⵍⵟⵓ ⵏ ⵓⴽⴻⵀⵀⴰⵏ. ⴰⴷ ⵜⵜ ⵜⴻⴳⴳⴻⴷ ⵙ ⵉⴼⵉⵍⴰⵏ ⵏ ⵡⵓⵔⴻⵖ ⵓ ⵙ ⵓⴼⵉⵍⵓ ⴰⴷⴻⵃⵎⵉ ⴷ ⵓⵔⵊⵓⵡⴰⵏⵉ ⴷ ⵓⵣⴻⴳⴳⵯⴰⵖ ⵉⵃⴻⴷⵇⴻⵏ ⵓ ⵙ ⵍⴻⵇⵟⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵎⵓⴷⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","ⵜⴰⵊⵎⴻⵛⵜ ⴰⴷ ⵜⵉⵍⵉ ⵙ ⴰⵔⴻⴱⵄⴰ ⵏ ⵜⵖⴻⵎⵎⵓⵔⴰ, ⵜᵉⵜⵜⵡⴰⴹⴼⴻⵚ. ⵜⵓⵣⵣⴻⴳⴳⴰⵔⵜ ⵏⵏⴻⵙ ⴰⴷ ⵜⵉⵍⵉ ⴷ ⵉⵊⵊ ⵏ ⵡⴻⵣⵢⴻⵏ ⵏ ⵓⵖⵉⵍ, ⵓ ⵜⵉⵔⵓ ⵏⵏⴻⵙ ⴷ ⵉⵊⵊ ⵏ ⵡⴻⵣⵢⴻⵏ ⵏ ⵓⵖⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","ⴰⴷ ⵅⴰⵙ ⵜⴻⴳⴳⴻⴷ ⵉⵥⵔⴰ, ⴰⵔⴻⴱⵄⴰ ⵏ ⵍⴻⵚⴼⵓⴼ ⵏ ⵉⵥⵔⴰ. ⵉⵊⵊ ⵏ ⵚⵚⴻⴼ ⴰⴷ ⵢⵉⵍⵉ ⵙ ⵢⵉⵊⵊ ⵏ ⵍⴻⵄⵇⵉⵇ ⴷ ⴰⵣⴻⴳⴳⵡⴰⵖ ⴷ ⵉⵛⵜ ⵏ ⵜⵢⴰⵇⵓⵜ ⴷ ⵉⵛⵜ ⵏ ⵙⵎⴰⵔⴰⵅⵜ. ⵡⴰ ⴷ ⵚⵚⴻⴼ ⴰⵎⴻⵣⵡⴰⵔⵓ. ");
INSERT INTO rift_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","ⵚⵚⴻⴼ ⵡⵉⵙⵙ ⵜⵏⴰⵢⴻⵏ ⴰⴷ ⵢⵉⵍⵉ ⵙ ⵢⵉⵊⵊ ⵏ ⴽⴰⵔⴱⵓⵏⴽⴻⵍ ⴷ ⵢⵉⵊⵊ ⵏ ⵚⴰⴼⴼⵉⵔ ⴰⵣⵉⵣⴰ ⴷ ⵢⵉⵊⵊ ⵏ ⴷⵉⴰⵎⴰⵏⵜⵉ. ");
INSERT INTO rift_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","ⵚⵚⴻⴼ ⵡⵉⵙⵙ ⵜⵍⴰⵜⴰ ⴰⴷ ⵢⵉⵍⵉ ⵙ ⵢⵉⵊⵊ ⵏ ⵡⴻⵥⵔⵓ ⵏ ⵢⴰⵙⵉⵏⵜⵓ ⴷ ⵢⵉⵊⵊ ⵏ ⴰⵅⴰⵜ ⴷ ⵢⵉⵊⵊ ⵏ ⵓⵎⴰⵜⵉⵙⵜ. ");
INSERT INTO rift_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","ⵓ ⵚⵚⴻⴼ ⵡⵉⵙⵙ ⴰⵔⴻⴱⵄⴰ ⴰⴷ ⵢⵉⵍⵉ ⵙ ⵢⵉⵛⵜ ⵏ ⵜⴻⵅⵔⵉⵙⵓⵍⵉⵜ ⴷ ⵢⵉⵊⵊ ⵏ ⵓⵏⵉⴽⵙ ⴷ ⵢⵉⵊⵊ ⵏ ⵢⴰⵙⴱⵉⵙ. ⵉⵏⴰ ⴰⴷ ⵜⵜⵡⴰⵟⵟⴼⴻⵏ ⴷⴻⴳ ⵡⵓⵔⴻⵖ ⴷⵉ ⵜⵛⵓⵢⴰⵔ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","ⵉⵥⵔⴰ ⴰⴷ ⵅⴰⵙⴻⵏ ⵉⵍⵉⵏ ⵉⵙⵎⴰⵡⴻⵏ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵜⴻⵏⵄⴰⵛ ⵏ ⵢⴻⵥⵔⴰ ⵄⵍⴰⵃⵙⴰⴱ ⵉⵙⵎⴰⵡⴻⵏ ⵏⵙⴻⵏ, ⵙ ⵉⵏⴻⵇⵇⴰⵛⴻⵏ ⵏ ⵜⵅⴰⴷⴻⵏⵜ ⵏ ⵓⵛⴻⵎⵎⵉⵄ, ⴽⵓⵍ ⴰⵏⴻⵇⵇⵉⵛ ⵄⵍⴰⵃⵙⴰⴱ ⵉⵙⴻⵎ ⵏⵏⴻⵙ ⵉ ⴷ ⴰⵙ ⴷⴷ-ⵢⵓⵙⵉⵏ. ⴰⵇⴰ ⴰⵜⴻⵏ ⵉ ⵜⴻⵏⵄⴰⵛ ⵏ ⵜⵇⴻⴱⴱⴰⵍ. ");
INSERT INTO rift_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵙⵙⵏⴰⵙⴻⵍ ⵅ ⵜⴻⵊⵎⴻⵛⵜ, ⵉⴼⵉⵍⴰⵏ ⵉⵎⵓⴷⴻⵏ ⵏ ⵡⵓⵔⴻⵖ ⵉⵚⴼⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵅⵔⴰⵣⵉⵏ ⵏ ⵡⵓⵔⴻⵖ ⵖⴰⵔ ⵜⴻⵊⵎⴻⵛⵜ ⵓⵛⴰ ⴰⴷ ⵜⵛⴻⴷⴷⴻⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵅⵔⴰⵣⵉⵏ ⵏⵏⵉ ⵖⴰⵔ ⵜⵏⴰⵢⴻⵏ ⵏ ⵟⵟⵔⵓⴼⴰ ⵏ ⵜⴻⵊⵎⴻⵛⵜ. ");
INSERT INTO rift_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","ⴰⴷ ⵜⵛⴻⴷⴷⴻⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵙⵙⵏⴰⵙⴻⵍ ⵏ ⵡⵓⵔⴻⵖ ⵉⵎⵓⴷⴻⵏ ⵖⴰⵔ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵅⵔⴰⵣⵉⵏ ⵖⴰⵔ ⵍⴻⴹⵔⵓⴼ ⵏ ⵜⴻⵊⵎⴻⵛⵜ. ");
INSERT INTO rift_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","ⴰⴷ ⵜⵛⴻⴷⴷⴻⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵅⴼⴰⵡⴻⵏ ⵏ ⵜⵏⴰⵢⴻⵏ ⵏ ⵙⵙⵏⴰⵙⴻⵍ ⵉⵎⵓⴷⴻⵏ ⵖⴰⵔ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵛⵓⵢⴰⵔ ⵓⵛⴰ ⴰⴷ ⵜⴻⵏⵜ ⵜⵛⴻⴷⴷⴻⴷ ⵖⴰⵔ ⵜⵖⴰⵔⴹⵉⵏ ⵉ ⵉⴵⴰⵏ ⵖⴰⵔ ⵓⵖⴻⵣⴷⵉⵙ ⵏ ⵣⵣⴰⵜ ⵏ ⵓⴱⴰⵍⵟⵓ ⵏ ⵓⴽⴻⵀⵀⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵄⴰⵡⴻⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵅⵔⴰⵣⵉⵏ ⵏ ⵡⵓⵔⴻⵖ ⵓⵛⴰ ⴰⴷ ⵜⴻⵏⵜ ⵜⴻⴳⴳⴻⴷ ⵖⴰⵔ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵅⴼⴰⵡⴻⵏ ⵏ ⵜⴻⵊⵎⴻⵛⵜ ⵖⴰⵔ ⵙⵡⴰⴷⴷⴰⵢ, ⵅ ⵜⵎⴰ ⵏⵙⴻⵏ ⵏⵏⵉ ⵉⴵⴰⵏ ⵖⴰⵔ ⵓⴱⴰⵍⵟⵓ, ⵖⴰⵔ ⴷⴰⵅⴻⵍ. ");
INSERT INTO rift_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵅⵔⴰⵣⵉⵏ ⵏ ⵡⵓⵔⴻⵖ, ⵜⵉⵏⵏⵉ ⵉ ⵖⴰ ⵜⵛⴻⴷⵏⴻⴷ ⵅ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵖⴰⵔⴹⵉⵏ ⵏ ⵓⴱⴰⵍⵟⵓ ⵏ ⵓⴽⴻⵀⵀⴰⵏ, ⵙⵡⴰⴷⴷⴰⵢ, ⵖⴰⵔ ⵣⵣⴰⵜ, ⵇⵉⴱⴰⵍⵜ ⵉ ⵓⵙⴻⵍⵇⵉ ⵏⵏⴻⵙ ⵖⴰⵔ ⵙⴻⵏⵏⴻⵊ ⵉ ⵜⵃⴻⵣⵣⴰⵎⵜ ⵉⵣⴻⵡⵡⵇⴻⵏ ⵏ ⵓⴱⴰⵍⵟⵓ. ");
INSERT INTO rift_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","ⴰⴷ ⵜⴻⵙⵙⵎⵓⵏⴻⴷ ⵜⴰⵊⵎⴻⵛⵜ ⵙ ⵜⴻⵅⵔⴰⵣⵉⵏ ⵏⵏⴻⵙ ⵖⴰⵔ ⵜⴻⵅⵔⴰⵣⵉⵏ ⵏ ⵓⴱⴰⵍⵟⵓ ⴰⴽ-ⴷ ⵉⵊⵊ ⵏ ⵓⴼⵉⵍⵓ ⵉⵎⵓⴷⴻⵏ ⴰⴷⴻⵃⵎⵉ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⵉⵍⵉ ⵜⴻⵊⵎⴻⵛⵜ ⵙⴻⵏⵏⴻⵊ ⵉ ⵜⵃⴻⵣⵣⴰⵎⵜ ⵉⵣⴻⵡⵡⵇⴻⵏ ⵏ ⵓⴱⴰⵍⵟⵓ ⵓⵛⴰ ⵡⴰⵔ ⵜᵉⵜⵜⴱⴻⵟⵟⵉ ⵜⴻⵊⵎⴻⵛⵜ ⵅ ⵓⴱⴰⵍⵟⵓ. ");
INSERT INTO rift_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵢⴰⵡⵉ ⵀⴰⵔⵓⵏ ⵉⵙⵎⴰⵡⴻⵏ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴷⵉ ⵜⴻⵊⵎⴻⵛⵜ ⵏ ⵍⴻⵃⴽⴰⵎ ⵅ ⵡⵓⵍ ⵏⵏⴻⵙ ⵅ ⵎⵉⵏⵏⵉ ⵉ ⵖⴰ ⵢⴰⴷⴻⴼ ⵖⴰⵔ ⵓⵇⴻⴷⴷⴰⵙ, ⴰⵍⴰⵎⵉ ⵉ ⵖⴰ ⵇⵇⵉⵎⴻⵏ ⵉ ⵍⵉⴷⴰⵔⴻⵜ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⵉ ⵍⴻⴱⴷⴰ. ");
INSERT INTO rift_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","ⴰⴷ ⵜⴻⵙⵙⴰⵔⵙⴻⴷ ⵉⵥⵔⴰ ⵏ ‘ⵓⵔⵉⵎ’ ⴷ ‘ⵜⵓⵎⵎⵉⵎ’ ⴷⵉ ⵜⴻⵊⵎⴻⵛⵜ ⵏ ⵍⴻⵃⴽⴰⵎ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⵍⵉⵏ ⵅ ⵡⵓⵍ ⵏ ⵀⴰⵔⵓⵏ ⵅ ⵎⵉⵏⵏⵉ ⵉ ⵖⴰ ⵢⴰⴷⴻⴼ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵢⴰⵔⴱⵓ ⵀⴰⵔⵓⵏ ⵍⴻⴱⴷⴰ ⵍⴻⵃⴽⴰⵎ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵅ ⵡⵓⵍ ⵏⵏⴻⵙ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⴰⵙⴻⵍⵀⴰⵎ ⵏ ⵓⴱⴰⵍⵟⵓ ⵏ ⵓⴽⴻⵀⵀⴰⵏ ⵎⴰⵔⵔⴰ ⵣⴻⴳ ⵓⴼⵉⵍⵓ ⴰⴷⴻⵃⵎⵉ. ");
INSERT INTO rift_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","ⴰⴷ ⵢⵉⵍⵉ ⵡⴰⵔⵣⴰⵎ ⵉ ⵓⵣⴻⴵⵉⴼ ⵏⵏⴻⵙ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏⵏⴻⵙ. ⵖⴰⵔ ⵜⵎⴰ ⵏ ⵡⴰⵔⵣⴰⵎ ⴰⴷ ⴷⵉⵏ ⵜⵉⵍⵉ ⵉⵛⵜ ⵏ ⵜⵎⴰ ⵉⵎⵓⴷⴻⵏ, ⵜⴻⵏⵏⵉ ⵉ ⵖⴰ ⵢⵉⵍⵉⵏ ⴰⵎ ⵡⴰⵔⵣⴰⵎ ⵉ ⵢⵉⵔⵉ ⴷⴻⴳ ⵉⵊⵊ ⵏ ⵡⴰⵔⵔⵓⴹ ⵏ ⵡⵓⵣⵣⴰⵍ ⵏ ⵓⵄⴻⵙⴽⴰⵔⵉ, ⵡⴰⵔ ⵜᵉⵜⵜⵛⴰⵔⵔⵉⴳ. ");
INSERT INTO rift_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","ⵖⴰⵔ ⵜⵎⵓⵡⵡⴰ ⵏⵏⴻⵙ ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵜⵉⵔⴻⵎⵎⴰⵏⵉⵏ ⵏ ⵉⴼⵉⵍⴰⵏ ⴰⴷⴻⵃⵎⵉ ⴷ ⵓⵔⵊⵓⵡⴰⵏⵉ ⴷ ⵓⵣⴻⴳⴳⵯⴰⵖ ⵉⵃⴻⴷⵇⴻⵏ, ⵖⴰⵔ ⵜⵎⵓⵡⵡⴰ ⵏⵏⴻⵙ ⵉ ⴷ ⴰⵙ ⴷⴷ-ⵉⵏⵏⴹⴻⵏ, ⵓ ⵊⴰⵔ ⴰⵙⴻⵏⵜ ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵏⵏⵡⴰⵇⴻⵙ ⵏ ⵡⵓⵔⴻⵖ ⵉ ⴷ ⴰⵙ ⴷⴷ-ⵉⵏⵏⴹⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","ⵉⵊⵊ ⴰⵡⴰⵔⵏⵉ ⵉ ⵡⴻⵏⵏⴻⵖⵏⵉ, ⵉⵊⵊ ⵏ ⵏⵏⴰⵇⵓⵙ ⵏ ⵡⵓⵔⴻⵖ ⴷ ⵉⵛⵜ ⵏ ⵜⵔⴻⵎⵎⴰⵏⵜ, ⵓⵛⴰ ⵄⴰⵡⴻⴷ ⵉⵊⵊ ⴰⵡⴰⵔⵏⵉ ⵉ ⵡⴻⵏⵏⴻⵖⵏⵉ, ⵉⵊⵊ ⵏ ⵏⵏⴰⵇⵓⵙ ⵏ ⵡⵓⵔⴻⵖ ⴷ ⵉⵛⵜ ⵏ ⵜⵔⴻⵎⵎⴰⵏⵜ, ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵉⵍⵉⵏ ⵖⴰⵔ ⵜⵎⵓⵡⵡⴰ ⵏ ⵓⵙⴻⵍⵀⴰⵎ ⵓ ⴷⴻⴳ ⵡⴻⵏⵏⴻⴹ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","ⵀⴰⵔⵓⵏ ⴰⴷ ⵜ ⵢⴰⵔⴹ ⵅⵎⵉ ⵉⵜⵜⵙⵙⴻⵅⵅⴰⵔ ⵏⴻⵜⵜⴰ, ⴰⵍⴰⵎⵉ ⵉ ⵖⴰ ⵉⵜⵜⵡⴰⵙⴻⵍ ⴷⴷⵔⵉⵣ ⵏⵏⴻⵙ ⵅ ⵎⵉⵏⵏⵉ ⵉ ⵖⴰ ⵢⴰⴷⴻⴼ ⵖⴰⵔ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⵓ ⵅⵎⵉ ⵖⴰ ⵉⴼⴼⴻⵖ ⵄⴰⵡⴻⴷ, ⵃⵉⵎⴰ ⵡⴰⵔ ⵉⵜⵜⵎⴻⵜⵜⵉ. ");
INSERT INTO rift_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵉⵛⵜ ⵏ ⵜⴻⵍⵡⵉⵃⵜ ⵙ ⵏⵏⵓⵡⵡⴰⵔ ⵏ ⵡⵓⵔⴻⵖ ⵉⵚⴼⴰⵏ ⵓⵛⴰ ⴰⴷ ⵅⴰⵙ ⵜⵏⴻⵇⵛⴻⴷ ⴰⵡⴰⵍⴻⵏ-ⴰ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵏⴻⵇⵇⵛⴻⵏ ⵜⴰⵅⴰⴷⴻⵏⵜ ⵏ ⵓⵛⴻⵎⵎⵉⵄ: “ⴰⵎⵇⴻⴷⴷⴰⵙ ⵉ ⵙⵉⴷⵉ.” ");
INSERT INTO rift_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","ⴰⴷ ⵜⵜ ⵜⵛⴻⴷⴷⴻⴷ ⵖⴰⵔ ⵢⵉⵊⵊ ⵏ ⵓⴼⵉⵍⵓ ⴰⴷⴻⵃⵎⵉ ⵅ ⴰⵔⴻⵥⵥⴻⵜ. ⴰⴷ ⵜⵉⵍⵉ ⵜⴻⵍⵡⵉⵃⵜ ⵖⴰⵔ ⵣⵣⴰⵜ ⵏ ⵓⵔⴻⵥⵥⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","ⴰⴷ ⵜⵉⵍⵉ ⵜⴻⵍⵡⵉⵃⵜ ⵅ ⵜⴻⵏⵢⴰⵔⵜ ⵏ ⵀⴰⵔⵓⵏ, ⵃⵉⵎⴰ ⵀⴰⵔⵓⵏ ⴰⴷ ⵢⴰⵔⴱⵓ ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ ⵉ ⵉⴵⴰⵏ ⴷⵉ ⵜⵎⴻⵙⵍⴰⵢⵉⵏ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵏⵏⵉ ⵉ ⵖⴰ ⵙⵙⵇⴻⴷⴷⵙⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⵜⵉⵡⵀⵉⴱⵉⵏ ⵏ ⵜⵎⴻⵙⵍⴰⵢⵉⵏ ⵏⵙⴻⵏ ⵉⵇⴻⴷⴷⵙⴻⵏ. ⴰⴷ ⵜⵉⵍⵉ ⵍⴻⴱⴷⴰ ⵅ ⵜⴻⵏⵢⴰⵔⵜ ⵏⵏⴻⵙ, ⵃⵉⵎⴰ ⴰⴷ ⵉⵍⵉⵏⵜ ⵜⵎⴻⵙⵍⴰⵢⵉⵏ ⵏⵏⵉ ⴰⵔⴹⴰⵏⵜ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵜⵛⴰⵎⵉⵔ ⵙ ⵍⴻⵇⵟⴻⵏ ⴰⵣⴷⴰⴷ. ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⴰⵔⴻⵥⵥⴻⵜ ⵄⴰⵡⴻⴷ ⵙ ⵍⴻⵇⵟⴻⵏ ⴰⵣⴷⴰⴷ. ⵜⴰⵃⴻⵣⵣⴰⵎⵜ ⴰⴷ ⵜⵜ ⵜⴻⴳⴳⴻⴷ ⴰⵎ ⵉⵊⵊ ⵏ ⵓⵎⵓⴷⵉ ⵏ ⵓⵅⴻⵢⵢⴰⴹ.”* ");
INSERT INTO rift_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“ⵉ ⵡⴰⵔⵔⴰⵡ ⵏ ⵀⴰⵔⵓⵏ ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵜⵛⴰⵎⵉⵔ ⵓ ⴰⴷ ⴰⵙⴻⵏ ⵜⴻⴳⴳⴻⴷ ⵜⵉⵃⴻⵣⵣⴰⵎⵉⵏ ⵓ ⴰⴷ ⴰⵙⴻⵏ ⵜⴻⴳⴳⴻⴷ ⵜⵉⵛⵓⵛⵛⴰⵢ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴰⵙⴻⵏ ⵉⵍⵉⵏ ⵉ ⵓⵄⵓⴵⵉ ⴷ ⵜⴻⵍⵡⵉⵣⵜ. ");
INSERT INTO rift_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","ⴰⴷ ⵜⴻⵙⵙⵢⴰⵔⴹⴻⴷ ⵀⴰⵔⵓⵏ, ⵓⵎⴰⵛ, ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⵉ ⴽⵉⴷⴻⵙ ⵉⴵⴰⵏ, ⵓⵛⴰ ⵛⴻⴽ ⴰⴷ ⵜⴻⵏ ⵜⴷⴻⵀⵏⴻⴷ, ⴰⴷ ⵜⴻⵏ ⵜⵍⴻⵇⵇⵎⴻⴷ ⵓ ⴰⴷ ⵜⴻⵏ ⵜⴻⵙⵙⵇⴻⴷⴷⵙⴻⴷ, ⵃⵉⵎⴰ ⴰⴷ ⴰⵢⵉ ⵅⴻⴷⵎⴻⵏ ⴰⵎ ⵢⵉⴽⴻⵀⵀⴰⵏⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","ⴻⴳⴳ ⴰⵙⴻⵏ ⵙⵙⵔⴰⵡⴻⵍ ⵏ ⵍⴻⵇⵟⴻⵏ, ⵃⵉⵎⴰ ⴰⴷ ⴷⵍⴻⵏ ⴰⵢⵙⵓⵎ ⵏ ⵓⵙⴻⴹⵃⵉ ⵏⵙⴻⵏ. ⴰⴷ ⵉⵍⵉⵏ ⵣⵉ ⵜⴻⵊⵄⵉⵏⵏⴰ ⵓⵛⴰ ⴰⴷ ⴰⵡⴹⴻⵏ ⵖⴰⵔ ⵉⴼⴰⴷⴷⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","ⵙⵙⵍⴰⵡⴻⵍ ⵏⵏⵉ ⴰⴷ ⵉⵍⵉⵏ ⵅ ⴰⵔⵔⵉⵎⴻⵜ ⵏ ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⵅⵎⵉ ⵖⴰ ⵢⴰⴷⴼⴻⵏ ⵖⴰⵔ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⵏⵉⵖ ⵅⵎⵉ ⴷⴷ ⵖⴰ ⵇⴰⵔⵔⴱⴻⵏ ⵖⴰⵔ ⵓⵄⴰⵍⵟⴰⵔ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵙⴻⵅⵅⴰⵔⴻⵏ ⴷⵉ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ, ⵃⵉⵎⴰ ⵡⴰⵔ ⴷⴷ-ⵜⵜⵉⵡⵢⴻⵏ ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ ⵓⵛⴰ ⴰⴷ ⵎⵎⵜⴻⵏ. ⵜⴰ ⴰⴷ ⵜⵉⵍⵉ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵚⴻⵢⵢⴻⵜ ⵉ ⵍⴻⴱⴷⴰ ⵉ ⵏⴻⵜⵜⴰ ⵓ ⵉ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵙ ⴰⵡⴰⵔⵏⵉ ⴰⵙ.” ");
INSERT INTO rift_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“ⴷ ⵎⴰⵏ ⴰⵢⴰ ⵉ ⴷ ⴰⵙⴻⵏ ⵖⴰ ⵜⴻⴳⴳⴻⴷ, ⵃⵉⵎⴰ ⴰⴷ ⵜⴻⵏ ⵜⴻⵙⵙⵇⴻⴷⴷⵙⴻⴷ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴰⵢⵉ ⵉⵍⵉⵏ ⴷ ⵉⴽⴻⵀⵀⴰⵏⴻⵏ. ⴽⵙⵉ ⵉⵊⵊ ⵏ ⵓⴼⵓⵏⴰⵙ - ⴰⵎⴻⵥⵢⴰⵏ ⵏ ⵓⴼⵓⵏⴰⵙ - ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵡⴰⵛⵔⴰⵔⴻⵏ ⵉⵛⵏⴰⵏ ⵇⴰⵄ, ");
INSERT INTO rift_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","ⵓ ⵄⴰⵡⴻⴷ ⴰⵖⵔⵓⵎ ⴱⵍⴰ ⴰⵏⵜⵓⵏ ⴷ ⵍⴻⵎⵙⴻⵎⵏⴰⵜ ⴱⵍⴰ ⴰⵏⵜⵓⵏ ⵉⵅⴻⴵⴹⴻⵏ ⵙ ⵣⵣⴻⵛⵜ ⴷ ⵜⴻⵍⴼⴰⴼ ⴱⵍⴰ ⴰⵏⵜⵓⵏ ⵜⵜⵡⴰⴷⴻⵀⵏⴻⵏⵜ ⵙ ⵣⵣⴻⵛⵜ, ⵜⵉⵏⵏⵉ ⵉ ⵖⴰ ⵜⴻⴳⴳⴻⴷ ⵎⴰⵔⵔⴰ ⵙ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⵏ ⵢⵉⵔⴷⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","ⴰⴷ ⵜⴻⵏⵜ ⵜⴻⴳⴳⴻⴷ ⴷⴻⴳ ⵉⵛⵜ ⵏ ⵜⵙⵓⴵⴻⵜ ⵓⵛⴰ ⴰⴷ ⵜⴻⵏⵜ ⵜⴰⵡⵢⴻⴷ ⴷⵉ ⵜⵙⵓⴵⴻⵜ ⵊⵎⵉⵄ ⴰⴽ-ⴷ ⵓⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","ⴰⴷ ⴷⴷ-ⵜⴻⵙⵙⵇⴰⵔⵔⴱⴻⴷ ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⵓⵛⴰ ⴰⴷ ⵜⴻⵏ ⵜⴻⵙⵙⵉⵔⴷⴻⴷ ⵙ ⵡⴰⵎⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","ⴰⴷ ⵜⴻⴽⵙⵉⴷ ⴰⵔⵔⵓⴹ, ⴰⴷ ⵜⵢⴰⵔⴹⴻⴷ ⵀⴰⵔⵓⵏ ⵜⵛⴰⵎⵉⵔ ⴷ ⵓⵙⴻⵍⵃⴰⵎ ⵉ ⵓⴱⴰⵍⵟⵓ ⴷ ⵓⴱⴰⵍⵟⵓ ⵙⵉⵎⴰⵏⵜ ⵏⵏⴻⵙ ⴷ ⵜⴻⵊⵎⴻⵛⵜ ⵓⵛⴰ ⴰⴷ ⴰⵙ ⵜⴱⴻⵢⵙⴻⴷ ⵙ ⵜⵃⴻⵣⵣⴰⵎⵜ ⵉⵣⴻⵡⵡⵇⴻⵏ ⵏ ⵓⴱⴰⵍⵟⵓ. ");
INSERT INTO rift_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","ⴰⴷ ⵜⴻⵙⵙⴰⵔⵙⴻⴷ ⴰⵔⴻⵥⵥⴻⵜ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏⵏⴻⵙ ⵓ ⵅ ⴰⵔⴻⵥⵥⴻⵜ ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵜⵜⴰⵊ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵏ ⵡⴻⵄⵣⴰⵍ. ");
INSERT INTO rift_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","ⴰⴷ ⵜⴻⴽⵙⵉⴷ ⵣⵣⴻⵛⵜ ⵉ ⵡⴻⴷⵀⴰⵏ ⵓⵛⴰ ⴰⴷ ⵜⵜ ⵜⵣⴻⴵⵄⴻⴷ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⵜ ⵜⴷⴻⵀⵏⴻⴷ. ");
INSERT INTO rift_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⴰⵡⵢⴻⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ, ⴰⴷ ⴰⵙⴻⵏ ⵜⵢⴰⵔⴹⴻⴷ ⵜⵛⴰⵎⵉⵔⴰⵜ. ");
INSERT INTO rift_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","ⴰⴷ ⴰⵙⴻⵏ ⵜⴱⴻⵢⵙⴻⴷ ⵙ ⵜⵃⴻⵣⵣⴰⵎⵜ, ⵉ ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ, ⵓⵛⴰ ⴰⴷ ⴰⵙⴻⵏ ⵜⴰⵔⴻⴽⴽⴱⴻⴷ ⵜⵉⵛⵓⵛⵛⴰⵢ. ⴰⴷ ⵖⴰⵔⵙⴻⵏ ⵜⵉⵍⵉ ⵜⵓⴽⴻⵀⵀⴰⵏⵜ ⵄⵍⴰⵃⵙⴰⴱ ⵉⵛⵜ ⵏ ⵜⴻⵡⵚⴻⵢⵢⴻⵜ ⵉ ⵍⴻⴱⴷⴰ. ⴰⴷ ⵜⴰⵍⴻⵇⵇⵎⴻⴷ ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⴰⵡⵢⴻⴷ ⴰⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ ⵣⵣⴰⵜ ⵉ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⵓ ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⴰⴷ ⵙⵙⴰⵔⵙⴻⵏ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵙⴻⵏ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏ ⵓⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","ⴰⴷ ⵜⵖⴰⵔⵚⴻⴷ ⵉ ⵓⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ, ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⴻⴽⵙⵉⴷ ⵉⴷⴰⵎⵎⴻⵏ ⵏ ⵓⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ ⵓⵛⴰ ⴰⴷ ⵜⴻⵏ ⵜⴻⴳⴳⴻⴷ ⵙ ⵓⴹⴰⴹ ⵏⵏⴻⵛ ⵅ ⵡⴰⵛⵛⴰⵡⴻⵏ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ⵓⵛⴰ ⴰⴷ ⵜⵣⴻⴵⵄⴻⴷ ⵎⴰⵔⵔⴰ ⵉⴷⴰⵎⵎⴻⵏ ⵉⵇⵇⵉⵎⴻⵏ ⵖⴰⵔ ⵉⴹⴰⵔⴻⵏ ⵏ ⵓⵄⴰⵍⵟⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","ⴰⴷ ⵜⴻⴽⵙⵉⴷ ⵄⴰⵡⴻⴷ ⵎⴰⵔⵔⴰ ⵜⴰⴷⵓⵏⵜ ⵏⵏⵉ ⵉⴷⵍⵉⵏ ⴰⴷⴰⵏ ⴷ ⵎⵉⵏ ⵢⵓⵢⵍⴻⵏ ⵖⴰⵔ ⵜⵙⴰ, ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵉⵥⵥⴰⵍ ⴰⴽ-ⴷ ⵜⴰⴷⵓⵏⵜ ⵉ ⵅⴰⵙⴻⵏⵜ ⵉⴵⴰⵏ ⵓⵛⴰ ⴰⴷ ⵜⴻⵙⵙⴱⴻⵅⵅⴰⵔⴻⴷ ⴰⵢⴰ ⵅ ⵓⵄⴰⵍⵟⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","ⵎⴰⵛⴰ ⴰⵢⵙⵓⵎ ⵏ ⵓⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ ⴷ ⵢⵉⵍⴻⵎ ⵏⵏⴻⵙ ⴷ ⵓⵎⴻⵙⵙⴰⵍ ⵏⵏⴻⵙ ⴰⴷ ⵜⴻⵏ ⵜⴻⵙⵙⵛⴻⵎⴹⴻⴷ ⵙ ⵜⵎⴻⵙⵙⵉ ⴱⴰⵔⵔⴰ ⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ, ⴰⵇⴰ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ. ");
INSERT INTO rift_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⴻⴽⵙⵉⴷ ⵉⵊⵊ ⵏ ⵓⵛⴰⵔⵔⵉ ⵓⵛⴰ ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⴰⴷ ⵙⵙⴰⵔⵙⴻⵏ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵙⴻⵏ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏ ⵉⵛⴰⵔⵔⵉ. ");
INSERT INTO rift_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","ⴰⴷ ⵜⵖⴰⵔⵚⴻⴷ ⵉ ⵉⵛⴰⵔⵔⵉ ⵓⵛⴰ ⴰⴷ ⵜⴻⴽⵙⵉⴷ ⵉⴷⴰⵎⵎⴻⵏ ⵏⵏⴻⵙ, ⴰⴷ ⵜⴻⵏ ⵜⵣⴻⴵⵄⴻⴷ ⵅ ⵓⵄⴰⵍⵟⴰⵔ ⵣⵉ ⵎⴰⵔⵔⴰ ⵉⵖⴻⵣⴷⵉⵙⴻⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","ⴰⴷ ⵜⴻⴱⴹⵉⴷ ⵉⵛⴰⵔⵔⵉ ⴷ ⵉⵛⴻⴵⵉⵇⴻⵏ, ⴰⴷ ⵜⴻⵙⵙⵉⵔⴷⴻⴷ ⴰⴷⴰⵏ ⵏⵏⴻⵙ ⴷ ⵉⵛⴻⴽⵔⴰⴷ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⵜⴻⵏ ⵜⴻⴳⴳⴻⴷ ⵅ ⵉⵛⴻⴵⵉⵇⴻⵏ ⵏⵏⴻⵙ ⵓ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","ⴰⴷ ⵜⴻⵙⵙⵉⵖⴻⴷ ⵉ ⵉⵛⴰⵔⵔⵉ ⴰⵎ ⵉⴽⵎⴻⵍ ⵅ ⵓⵄⴰⵍⵟⴰⵔ, ⴰⵇⴰ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵉ ⵙⵉⴷⵉ, ⵉⵛⵜ ⵏ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵉⵜⵜⴼⵓⵃⴻⵏ, ⴰⵇⴰ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⴻⴽⵙⵉⴷ ⵉⵛⴰⵔⵔⵉ ⵏⵏⴻⵖⵏⵉ ⵓⵛⴰ ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⴰⴷ ⵙⵙⴰⵔⵙⴻⵏ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵙⴻⵏ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏ ⵉⵛⴰⵔⵔⵉ. ");
INSERT INTO rift_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","ⴰⴷ ⵜⵖⴰⵔⵚⴻⴷ ⵉ ⵉⵛⴰⵔⵔⵉ ⵓⵛⴰ ⴰⴷ ⵜⴻⴽⵙⵉⴷ ⵣⴻⴳ ⵉⴷⴰⵎⵎⴻⵏ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵎⴰⵏ ⴰⵢⴰ ⵅ ⵉⵖⴻⵙ ⵏ ⵓⵎⴻⵣⵣⵓⵖ ⴰⴼⵓⵙⵉ ⵏ ⵀⴰⵔⵓⵏ ⵓ ⵅ ⵉⵖⴻⵙ ⵏ ⵓⵎⴻⵣⵣⵓⵖ ⴰⴼⵓⵙⵉ ⵏ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⵓ ⵄⴰⵡⴻⴷ ⵅ ⵓⴹⴰⴹ ⵏ ⵢⵉⵎⴻⵣ ⵏ ⵓⴼⵓⵙ ⵏⵙⴻⵏ ⴰⴼⵓⵙⵉ ⵓ ⵅ ⵓⴹⴰⴹ ⵏ ⵢⵉⵎⴻⵣ ⵏ ⵓⴹⴰⵔ ⵏⵙⴻⵏ ⴰⴼⵓⵙⵉ ⵓⵛⴰ ⴰⴷ ⵜⵣⴻⴵⵄⴻⴷ ⵉⴹⴰⵎⵎⴻⵏ ⵉⵇⵇⵉⵎⴻⵏ ⵅ ⵓⵄⴰⵍⵟⴰⵔ ⵣⵉ ⴽⵓⵍ ⵊⵊⵉⵀⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⴻⴽⵙⵉⴷ ⵣⴻⴳ ⵉⴷⴰⵎⵎⴻⵏ ⵏⵏⵉ ⵉⴵⴰⵏ ⵅ ⵓⵄⴰⵍⵟⴰⵔ ⵓ ⵣⵉ ⵣⵣⴻⵛⵜ ⵉ ⵡⴻⴷⵀⴰⵏ ⵓⵛⴰ ⴰⴷ ⵣⵣⴰⵢⵙⴻⵏ ⵜⵔⵓⵛⵛⴻⴷ ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⵜⵔⵓⵛⵛⴻⴷ ⵄⴰⵡⴻⴷ ⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⴷ ⴰⵔⵔⵓⴹ ⵏ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⴰⴽⵉⴷⴻⵙ, ⵃⵉⵎⴰ ⴰⴷ ⵢⵉⵍⵉ ⵉⵜⵜⵡⴰⵇⴻⴷⴷⴻⵙ, ⵏⴻⵜⵜⴰ ⴷ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ, ⵓⵍⴰ ⴷ ⵜⴰⵔⵡⴰ ⵏⵏⴻⵙ ⴷ ⴰⵔⵔⵓⴹ ⵏ ⵜⴰⵔⵡⴰ ⵏⵏⴻⵙ ⴰⴽⵉⴷⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","ⴰⴷ ⵜⴻⴽⵙⵉⴷ ⵜⴰⴷⵓⵏⵜ ⵏ ⵉⵛⴰⵔⵔⵉ ⵍⴰ ⴷ ⵜⴰⴷⵓⵏⵜ ⵖⴰⵔ ⵓⵏⴻⵡⵡⴰⵔ ⵍⴰ ⵜⴰⴷⵓⵏⵜ ⵏⵏⵉ ⵉⴷⵍⵉⵏ ⴰⴷⴰⵏ, ⵓⵍⴰ ⵎⵉⵏ ⵢⵓⵢⵍⴻⵏ ⵖⴰⵔ ⵜⵙⴰ ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵉⵥⵥⴰⵍ ⵙ ⵜⴰⴷⵓⵏⵜ ⵉ ⵅⴰⵙⴻⵏⵜ ⵉⴵⴰⵏ ⴷ ⴰⵛⴻⴽⵔⵓⴷ ⴰⴼⵓⵙⵉ, ⵎⵉⵏⵣⵉ ⵡⴰ ⴷ ⵉⵛⴰⵔⵔⵉ ⵉ ⵓⴷⴻⵛⵛⴻⵏ ⵏ ⵉⴽⴻⵀⵀⴰⵏⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","ⴽⵙⵉ ⵄⴰⵡⴻⴷ ⵉⵛⵜ ⵏ ⵜⴻⵛⵏⵉⴼⵜ ⵏ ⵡⴻⵖⵔⵓⵎ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵎⵙⴻⵎⵎⴻⵏⵜ ⵏ ⵡⴻⵖⵔⵓⵎ ⵉⵜⵜⵡⴰⵙⵙⵡⴻⵊⴷⴻⵏ ⵙ ⵣⵣⴻⵛⵜ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵍⴼⴻⴼⵜ ⵣⵉ ⵜⵙⵓⴵⴻⵜ ⵏ ⵡⴻⵖⵔⵓⵎ ⴱⵍⴰ ⴰⵏⵜⵓⵏ ⵉ ⵉⴵⴰⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","ⵙⴰⵔⵙ ⵎⴰⵏ ⴰⵢⴰ ⵎⴰⵔⵔⴰ ⵅ ⵉⴼⴰⵙⵙⴻⵏ ⵏ ⵀⴰⵔⵓⵏ ⵓ ⵅ ⵉⴼⴰⵙⵙⴻⵏ ⵏ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⵜⴻⵏ ⵜⴻⵙⵙⴻⵏⵀⴻⵣⵣⴻⴷ ⵣⵉ ⵙⵙⴰ ⵖⴰⵔ ⴷⴰ ⴰⵎ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵡⴻⵏⵀⴻⵣⵣⵉ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","ⴰⵡⴰⵔⵏⵉ ⴰⵙ ⴰⴷ ⵜⵜ ⵜⴻⴽⵙⵉⴷ ⵣⴻⴳ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵙⴻⵏ ⵓⵛⴰ ⴰⴷ ⵜⵜ ⵜⴻⵙⵙⴱⴻⵅⵅⴰⵔⴻⴷ ⵅ ⵓⵄⴰⵍⵟⴰⵔ, ⵅ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ, ⴰⴷ ⵜⵉⵍⵉ ⴷ ⵉⵛⵜ ⵏ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵉⵜⵜⴼⵓⵃⴻⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ⴰⵇⴰ-ⵜⵜ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","ⴰⴷ ⵜⴻⴽⵙⵉⴷ ⵉⴷⵎⴰⵔⴻⵏ ⵏ ⵉⵛⴰⵔⵔⵉ ⵉ ⵓⴷⴻⵛⵛⴻⵏ ⵏ ⵀⴰⵔⵓⵏ ⵓⵛⴰ ⴰⴷ ⵜⴻⵏ ⵜᵉⵙⵙⴻⵏⵀⴻⵣⵣⴻⴷ ⵣⵉ ⵙⵙⴰ ⵖⴰⵔ ⴷⴰ ⴰⵎ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵡⴻⵏⵀⴻⵣⵣⵉ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ⵜⴰⵏⵉⵜⴰ ⴰⴷ ⵜⵉⵍⵉ ⴷ ⵜⴰⵙⵖⴰⵔⵜ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","ⴰⴷ ⵜⴻⵙⵙⵇⴻⴷⴷⵙⴻⴷ ⵉⴷⵎⴰⵔⴻⵏ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵡⴻⵏⵀⴻⵣⵣⵉ ⵉ ⵉⵜⵜⵡⴰⵏⵀⴻⵣⵣⴻⵏ ⵣⵉ ⵙⵙⴰ ⵖⴰⵔ ⴷⴰ, ⵓⵍⴰ ⴷ ⵓⵛⴻⴽⵔⵓⴷ ⵉ ⵉⵜⵜⵡⴰⵏⵀⴻⵣⵣⴻⵏ ⵣⵉ ⵙⵙⴰ ⵖⴰⵔ ⴷⴰ ⴷ ⵡⴻⵏⵏⵉ ⵉⵜⵜⵡⴰⵙⵙⴳⴻⵄⵄⴷⴻⵏ. ⴰⵇⴰ-ⵜⴻⵏ ⵣⴻⴳ ⵉⵛⴰⵔⵔⵉ ⵏ ⵓⴷⴻⵛⵛⴻⵏ, ⴰⵎ ⵣⴻⴳ ⵡⴻⵏⵏⵉ ⵉ ⵢⴻⴵⴰⵏ ⵉ ⵀⴰⵔⵓⵏ ⴰⵎ ⵣⴻⴳ ⵡⴻⵏⵏⵉ ⵉ ⵢⴻⴵⴰⵏ ⵉ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","ⴰⵢⴰ ⴰⴷ ⵢⵉⵍⵉ ⵉ ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵚⴻⵢⵢⴻⵜ ⵉ ⵍⴻⴱⴷⴰ ⵣⵉ ⵊⵊⵉⵀⴻⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵎⵉⵏⵣⵉ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵓⵙⴳⴻⵄⵄⴻⴷ ⵉ ⵜⴻⴵⴰ. ⴰⴷ ⵜⵉⵍⵉ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵉ ⵖⴰ ⵙⵙⴳⴻⵄⵄⴷⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵣⵉ ⵜⵖⴰⵔⵚⴰ ⵏⵙⴻⵏ ⵏ ⵍⴻⵀⵏⴰ. ⴰⵇⴰ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵙⴻⵏ ⵏ ⵓⵙⴳⴻⵄⵄⴻⴷ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","ⴰⵔⵔⵓⴹ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵏ ⵀⴰⵔⵓⵏ ⴰⴷ ⵢⵉⵍⵉ ⵉ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⴰⵡⴰⵔⵏⵉ ⴰⵙ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⴻⵏ ⴷⴻⵀⵏⴻⵏ ⵓ ⴰⴷ ⵜⴻⵏ ⴰⵍⴻⵇⵎⴻⵏ ⴷⴰⵢⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","ⵎⴰⵏ ⵡⴻⵏ ⵣⴻⴳ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ ⵉ ⵖⴰ ⵢⵉⵍⵉⵏ ⴷ ⴰⴽⴻⵀⵀⴰⵏ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⵢⴰⴷⴻⴼ ⵖⴰⵔ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⵙⴻⵅⵅⴰⵔ ⴷⵉ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ, ⴰⴷ ⵜ ⵢⴰⵔⴹ ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","ⴰⴷ ⵜⴻⴽⵙⵉⴷ ⵉⵛⴰⵔⵔⵉ ⵉ ⵓⴷⴻⵛⵛⴻⵏ ⵓⵛⴰ ⴰⴷ ⵜᵉⵙⵙⴻⵏⴳⵡⴻⴷ ⴰⵢⵙⵓⵎ ⵏⵏⴻⵙ ⴷⴻⴳ ⵉⵊⵊ ⵏ ⵡⴻⵎⵛⴰⵏ ⵉⵇⴻⴷⴷⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⴰⴷ ⵛⵛⴻⵏ ⴰⵢⵙⵓⵎ ⵏ ⵉⵛⴰⵔⵔⵉ ⴷ ⵡⴻⵖⵔⵓⵎ ⵉ ⵉⴵⴰⵏ ⴷⵉ ⵜⵙⵓⴵⴻⵜ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","ⴰⴷ ⵛⵛⴻⵏ ⵣⵉ ⵎⵉⵏ ⵣⵉ ⵉⵜⵜⵡⴰⴳⴳ ⵡⴻⵙⵍⴰⵃ, ⵃⵉⵎⴰ ⴰⴷ ⵜⴻⵏ ⵍⴻⵇⵇⵎⴻⵏ ⵓ ⴰⴷ ⵜⴻⵏ ⵙⵙⵇⴻⴷⴷⵙⴻⵏ. ⵎⴰⵛⴰ ⵉⵊⵊ ⵏ ⵓⴱⴰⵔⵔⴰⵏⵉ ⵡⴰⵔ ⵣⵣⴰⵢⴻⵙ ⵉⵜⵜⴻⵜⵜ, ⵎⵉⵏⵣⵉ ⴰⵇⴰ ⴷ ⵉⵛⵜ ⵏ ⵍⵃⴰⵊⵊⴻⵜ ⴷ ⵜⴰⵎⵇⴻⴷⴷⴻⵙⵜ. ");
INSERT INTO rift_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","ⵎⴰⵍⴰ ⵉⵛⴻⵟⵟ ⵛⴰ ⵣⴻⴳ ⵡⴻⵢⵙⵓⵎ ⵏ ⵜⵖⴰⵔⵚⴰ ⵉ ⵓⴷⴻⵛⵛⴻⵏ ⵏⵉⵖ ⵣⴻⴳ ⵡⴻⵖⵔⵓⵎ ⴰⵍ ⵚⵚⴱⴻⵃ, ⴰⴷ ⵜⴻⵙⵙⵛⴻⵎⴹⴻⴷ ⵎⵉⵏ ⵉⵛⴻⵟⵟⴻⵏ ⴷⵉ ⵜⵎⴻⵙⵙⵉ. ⵉⵜⵜⵅⴻⵚⵚⴰ ⵡⴰⵔ ⵜ ⵉⵜⵜⴻⵜⵜ ⵃⴻⴷ, ⵎⵉⵏⵣⵉ ⴷ ⵉⵛⵜ ⵏ ⵍⵃⴰⵊⵊⴻⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵉ ⵢⴻⴵⴰ. ");
INSERT INTO rift_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵜⴻⴳⴳⴻⴷ ⴰⴽ-ⴷ ⵀⴰⵔⵓⵏ ⵓ ⴰⴽ-ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ, ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵄⵍⴰⵃⵙⴰⴱ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴷ ⴰⵛ ⵡⴻⵚⵚⵉⵖ. ⴰⴷ ⵜⴻⵏ ⵜⴰⵍⴻⵇⵇⵎⴻⴷ ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","ⴽⵓⵍ ⴰⵙⵙ ⴰⴷ ⵜⴻⵙⵙⵡⴻⵊⴷⴻⴷ ⴰⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⵉ ⵡⴻⵚⵍⴰⵃ ⵓⵛⴰ ⴰⴷ ⵜⴻⴽⴽⵙⴻⴷ ⴷⴷⴻⵏⴱ ⵅ ⵓⵄⴰⵍⵟⴰⵔ ⵓⵎⵉ ⵅⴰⵙ ⵖⴰ ⵜⴻⵙⵙⵉⵡⴹⴻⴷ ⴰⵚⵍⴰⵃ, ⵓⵛⴰ ⵅⴻⵏⵏⵉ ⴰⴷ ⵜ ⵜⴷⴻⵀⵏⴻⴷ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜ ⵜⴻⵙⵙⵇⴻⴷⴷⵙⴻⴷ. ");
INSERT INTO rift_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⴰⵚⵍⴰⵃ ⵅ ⵓⵄⴰⵍⵟⴰⵔ ⵓⵛⴰ ⴰⴷ ⵜ ⵜⴻⵙⵙⵇⴻⴷⴷⵙⴻⴷ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⴰⵎⵇⴻⴷⴷⴰⵙ ⵇⴰⵄ. ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵉⵃⴰⴷⴰⵏ ⴰⵄⴰⵍⵟⴰⵔ, ⴰⴷ ⵢⵉⵍⵉ ⴷ ⴰⵎⵇⴻⴷⴷⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","ⴷ ⵎⴰⵏ ⴰⵢⴰ ⵉ ⵖⴰ ⵜⴻⵙⵙⵡⴻⵊⴷⴻⴷ ⵅ ⵓⵄⴰⵍⵟⴰⵔ: ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵣⵎⴰⵔⴻⵏ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ, ⴽⵓⵍ ⴰⵙⵙ ⵍⴻⴱⴷⴰ. ");
INSERT INTO rift_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","ⴰⴷ ⵜⴻⵙⵙⵡⴻⵊⴷⴻⴷ ⵉⵊⵊ ⵏ ⵢⴻⵣⵎⴰⵔ ⴷⵉ ⵚⵚⴱⴻⵃ ⵓ ⵉⵣⵎⴰⵔ ⵏⵏⴻⵖⵏⵉ ⴰⴷ ⵜ ⵜⴻⵙⵙⵡⴻⵊⴷⴻⴷ ⵊⴰⵔ ⴱⴻⴷⴷⵓ ⵏ ⵡⴻⵣⵢⴻⵏ ⵏ ⵡⴰⵙⵙ ⴰⵍ ⴷⴷ-ⵜⴻⵡⴹⴰ ⵜⵎⴻⴷⴷⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","ⵉ ⵢⵉⵊⵊ ⵏ ⵢⴻⵣⵎⴰⵔ ⴰⴷ ⵜⴻⴽⵙⵉⴷ ⵄⴻⵛⵔⴰ ⴷⵉ ⵜⴻⵙⵖⴰⵔⵜ ⵏ ⵉⵊⵊ ⵏ ⵉⴼⴰ ⵏ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵅⴻⴵⴹⴻⵏ ⵙ ⵣⵣⴻⵛⵜ ⴷⴷⵣⴻⵏ ⵜⵜ-ⵉ-ⴷⴷ ⵣⵉ ⵣⵣⵉⵜⵓⵏ, ⵓ ⴰⵔⴻⴱⵄⴰ ⴷⵉ ⵜⴻⵙⵖⴰⵔⵜ ⵏ ⵉⵊⵊ ⵏ ⵓⵀⵉⵏⵓ ⵏ ⴱⵉⵏⵓ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵓⵙⴻⵢⵢⴻⴱ. ");
INSERT INTO rift_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","ⴰⴷ ⵜⵖⴰⵔⵚⴻⴷ ⵉ ⵢⴻⵣⵎⴰⵔ ⵏⵏⴻⵖⵏⵉ ⵊⴰⵔ ⴱⴻⴷⴷⵓ ⵏ ⵡⴻⵣⵢⴻⵏ ⵏ ⵡⴰⵙⵙ ⴰⵍ ⴷⴷ-ⵜⴻⵡⴹⴰ ⵜⵎⴻⴷⴷⵉⵜ. ⴰⴷ ⵖⴰⵔⴻⵙ ⵜⴰⵔⵏⵉⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⴻⵏⵏⵉ ⵏ ⵚⵚⴱⴻⵃ ⵓ ⵄⴰⵡⴻⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵏ ⵓⵙⴻⵢⵢⴻⴱ. ⴰⵇⴰ ⴷ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵉⵜⵜⴼⵓⵃⴻⵏ. ⴰⵇⴰ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","ⴰⴷ ⵜⵉⵍⵉ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵍⴻⴱⴷⴰ ⴷⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵏⵡⴻⵎ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ, ⵎⴰⵏⵉ ⵖⴰ ⵙⵙⵎⵓⵏⴻⵖ ⴰⴽⵉⴷⵡⴻⵎ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴽⵉⴷⴻⴽ ⵙⵙⵉⵡⵍⴻⵖ ⴷⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","ⴰⴷ ⵎⵎⵙⴰⴳⴰⵔⴻⵖ ⴷⵉⵏ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵓ ⴰⵇⵉⴹⵓⵏ ⴰⴷ ⵉⵜⵜⵡⴰⵇⴻⴷⴷⴻⵙ ⵙ ⵓⵄⵓⴵⵉ ⵉⵏⵓ. ");
INSERT INTO rift_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","ⴰⴷ ⵙⵙⵇⴻⴷⴷⵙⴻⵖ ⴰⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⴷ ⵓⵄⴰⵍⵟⴰⵔ. ⴰⴷ ⵙⵙⵇⴻⴷⴷⵙⴻⵖ ⵄⴰⵡⴻⴷ ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ, ⵃⵉⵎⴰ ⴰⴷ ⴰⵢⵉ ⵉⵍⵉⵏ ⴷ ⵉⴽⴻⵀⵀⴰⵏⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","ⴰⴷ ⵣⴻⴷⵖⴻⵖ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⴰⴷ ⴰⵙⴻⵏ ⵉⵍⵉⵖ ⴷ ⴰⵔⴻⴱⴱⵉ ");
INSERT INTO rift_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","ⵓⵛⴰ ⴰⴷ ⵙⵙⵏⴻⵏ ⴱⴻⵍⵍⵉ ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵙⴻⵏ, ⵡⴻⵏⵏⵉ ⵜⴻⵏ ⵉⵙⵙⵓⴼⴼⵖⴻⵏ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵣⴻⴷⵖⴻⵖ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏⵙⴻⵏ. ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵙⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵄⴰⵡⴻⴷ ⴰⵄⴰⵍⵟⴰⵔ ⵏ ⵍⴻⴱⵅⵓⵔ. ⴰⴷ ⵜ ⵜⴻⴳⴳⴻⴷ ⵣⴻⴳ ⵓⴽⴻⵛⵛⵓⴹ ⵏ ⵜⵛⴻⵊⵊⴰⵔⵜ ⵏ ⵓⴽⴰⵙⵉⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","ⵜⵓⵣⵣⴻⴳⴳⴰⵔⵜ ⴰⴷ ⵜⵉⵍⵉ ⴷ ⵉⵊⵊⴻⵏ ⵓⵖⵉⵍ, ⵓ ⵜⵉⵔⵓ ⵄⴰⵡⴻⴷ ⴷ ⵉⵊⵊⴻⵏ ⵓⵖⵉⵍ. ⴰⴷ ⵢⵉⵍⵉ ⵓⵄⴰⵍⵟⴰⵔ ⵙ ⴰⵔⴻⴱⵄⴰ ⵏ ⵜⵖⴻⵎⵎⵓⵔⴰ. ⵍⵓⵄⵍⴰ ⵏⵏⴻⵙ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵖⴰⴵⴻⵏ ⵓ ⴰⵛⵛⴰⵡⴻⵏ ⵏⵏⴻⵙ ⴰⴷ ⵉⵍⵉⵏ ⴷ ⵉⵊⵊⴻⵏ ⴰⴽⵉⴷⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","ⴰⴷ ⵜ ⵜⵖⴻⴵⴼⴻⴷ ⵙ ⵡⵓⵔⴻⵖ ⵉⵚⴼⴰⵏ, ⵓⴷⴻⵎ ⵏⵏⴻⵙ ⵏ ⵙⴻⵏⵏⴻⵊ ⴷ ⵉⵖⴻⵣⴷⵉⵙⴻⵏ ⵏⵏⴻⵙ ⵉ ⴷ ⴰⵙ ⴷⴷ-ⵉⵏⵏⴹⴻⵏ ⴷ ⵡⴰⵛⵛⴰⵡⴻⵏ ⵏⵏⴻⵙ. ⴰⴷ ⴰⵙ ⵜⴻⴳⴳⴻⴷ ⵉⵊⵊ ⵏ ⵣⵣⵡⴰⵇ ⵏ ⵡⵓⵔⴻⵖ ⵉ ⴷ ⴰⵙ ⴷⴷ-ⵉⵏⵏⴹⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","ⴰⴷ ⴰⵙ ⵜⴻⴳⴳⴻⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵅⵔⴰⵣⵉⵏ ⵏ ⵡⵓⵔⴻⵖ ⵙⴰⴷⵓ ⵣⵣⵡⴰⵇ ⵏⵏⴻⵙ. ⴰⴷ ⵜⴻⵏⵜ ⵜⴻⴳⴳⴻⴷ ⵖⴰⵔ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵖⴻⵣⴷⵉⵙⴻⵏ ⵏⵏⴻⵙ, ⵖⴰⵔ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵖⴻⵎⵎⴰⵔ ⵏⵏⴻⵙ. ⴰⴷ ⵉⵍⵉⵏⵜ ⵉ ⵉⵄⵓⵎⴰⴷ, ⵃⵉⵎⴰ ⴰⴷ ⵣⵣⴰⵢⵙⴻⵏ ⴰⵔⴱⵓⵏ ⴰⵄⴰⵍⵟⴰⵔ ⵏ ⵍⴻⴱⵅⵓⵔ. ");
INSERT INTO rift_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵄⵓⵎⴰⴷ ⵉ ⵜⴰⵔⴻⴱⴱⵓⵜ ⵣⴻⴳ ⵓⴽⴻⵛⵛⵓⴹ ⵏ ⵓⴽⴰⵙⵉⵢⴰ ⵓⵛⴰ ⴰⴷ ⵜⴻⵏ ⵜⵖⴻⴵⴼⴻⴷ ⵙ ⵡⵓⵔⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","ⴰⴷ ⵜ ⵜⴻⵙⵙⴰⵔⵙⴻⴷ ⵣⵣⴰⵜ ⵉ ⵓⵍⴻⵃⵃⴰⴼ ⵉ ⵉⴵⴰⵏ ⵣⵣⴰⵜ ⵉ ⵜⵜⴰⴱⵓⵜ ⵏ ⵛⵛⵀⴰⴷⴻⵜ, ⵣⵣⴰⵜ ⵉ ⵜⵇⴻⴱⴱⴰⵔⵜ ⵏ ⵡⴻⵚⵍⴰⵃ ⵜⴻⵏⵏⵉ ⵉⴵⴰⵏ ⵅ ⵛⵛⵀⴰⴷⴻⵜ, ⵎⴰⵏⵉ ⴽⵉⴽ ⵉ ⵖⴰ ⵎⵎⵙⴰⴳⴰⵔⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","ⴰⴷ ⵉⵙⵙⴱⴻⵅⵅⴰⵔ ⵀⴰⵔⵓⵏ ⵍⴻⴱⵅⵓⵔ ⵉⵜⵜⴼⵓⵃⴻⵏ ⴽⵓⵍ ⵚⵚⴱⴻⵃ. ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⵉⵄⴷⴻⵍ ⵜⵉⴼⵜⵉⵍⵉⵏ, ⴰⴷ ⵉⵙⵙⴱⴻⵅⵅⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","ⵎⴻⵍⵎⵉ ⵉ ⵖⴰ ⵉⵙⵙⵉⵔⴻⵖ ⵀⴰⵔⵓⵏ ⵜⵉⴼⵜⵉⵍⵉⵏ ⵊⴰⵔ ⴱⴻⴷⴷⵓ ⵏ ⵡⴻⵣⵢⴻⵏ ⵏ ⵡⴰⵙⵙ ⴰⵍ ⴷⴷ-ⵜⴻⵡⴹⴰ ⵜⵎⴻⴷⴷⵉⵜ, ⴰⴷ ⵢⴻⵊⵊ ⵍⴻⴱⵅⵓⵔ ⴰⴷ ⵉⴱⴻⵅⵅⴰⵔ. ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵉⵊⵊ ⵏ ⵍⴻⴱⵅⵓⵔ ⵉ ⵍⴻⴱⴷⴰ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","ⴽⴻⵏⵏⵉⵡ ⵡⴰⵔ ⵅⴰⵙ ⵜⴻⵙⵙⴳⴻⵄⵄⴷⴻⵎ ⵛⴰ ⵍⴻⴱⵅⵓⵔ ⴷ ⴰⵖⵔⵉⴱ, ⵏⵉⵖ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵏⵉⵖ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵓ ⵡⴰⵔ ⵅⴰⵙ ⵜⵜⵣⴻⴵⴰⵄⴻⵎ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵓⵙⴻⵢⵢⴻⴱ. ");
INSERT INTO rift_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","ⵀⴰⵔⵓⵏ ⴰⴷ ⵉⴳⴳ ⴰⵚⵍⴰⵃ ⵅ ⵡⴰⵛⵛⴰⵡⴻⵏ ⵏⵏⴻⵙ ⵉⵛⵜ ⵏ ⵜⵡⴰⵍⴰ ⴷⴻⴳ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵙ ⵉⴷⴰⵎⵎⴻⵏ ⵏ ⵜⵖⴰⵔⵚⴰ ⵏ ⴷⴷⴻⵏⴱ ⵉ ⵡⴻⵚⵍⴰⵃ. ⴰⴷ ⵜ ⵉⵙⵙⴻⵚⵍⴻⵃ ⵉⵛⵜ ⵏ ⵜⵡⴰⵍⴰ ⴷⴻⴳ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵏⵡⴻⵎ. ⴰⵇⴰ-ⵜ ⴷ ⴰⵎⵇⴻⴷⴷⴰⵙ ⵇⴰⵄ ⵉ ⵙⵉⴷⵉ.” ");
INSERT INTO rift_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“ⵅⵎⵉ ⵖⴰ ⵜⴻⴽⵙⵉⴷ ⵍⵇⴻⴷⴷ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵍⵇⴻⴷⴷ ⵏ ⵢⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ, ⵅⴻⵏⵏⵉ ⵏⵉⵜⵏⵉ ⴰⴷ ⵡⵛⴻⵏ, ⴽⵓⵍ ⵉⵊⵊ ⵉ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵙ, ⵜⵜⴰⵎⴰⵏ ⵏ ⵡⴻⵚⵍⴰⵃ ⵉ ⵙⵉⴷⵉ ⵖⴰⵔ ⵓⵙⴻⴷⴷⵉ ⵏⵙⴻⵏ, ⵃⵉⵎⴰ ⵡⴰⵔ ⵜᵉⵜⵜⵉⵍⵉ ⵊⵊⵔⵉⵃⴻⵛⵜ ⵊⴰⵔ ⴰⵙⴻⵏ ⵅ ⵎⵉⵏⵏⵉ ⵜⴻⵏ ⵖⴰ ⵜⵃⴻⵙⴱⴻⴷ. ");
INSERT INTO rift_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","ⴷ ⵎⴰⵏ ⴰⵢⴰ ⵉ ⵖⴰ ⵡⵛⴻⵏ ⵏⵉⵜⵏⵉ, ⴽⵓⵍ ⵉⵊⵊ ⵣⴻⴳ ⵉⵏⵏⵉ ⵖⴰ ⵉⵥⵡⴰⵏ ⵖⴰⵔ ⵢⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ: ⴰⵣⵢⴻⵏ ⵛⵉⵇⵍⵓ ⵄⵍⴰⵃⵙⴰⴱ ⵛⵉⵇⵍⵓ ⵏ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ - ⵛⵉⵇⵍⵓ-ⵢⴰ ⴷ ⵄⵉⵛⵔⵉⵏ ⵊⵉⵔⴰ - ⴰⵣⵢⴻⵏ ⵛⵉⵇⵍⵓ-ⵢⴰ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵓⵙⴳⴻⵄⵄⴻⴷ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","ⴽⵓⵍ ⵉⵊⵊ ⵣⴻⴳ ⵉⵏⵏⵉ ⵖⴰ ⵉⵥⵡⴰⵏ ⵖⴰⵔ ⵢⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ, ⵣⵉ ⵄⵉⵛⵔⵉⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵙⴻⵏⵏⴻⵊ, ⴰⴷ ⵉⵙⵙⴳⴻⵄⵄⴻⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","ⴱⵓ-ⵡⴰⴳⵍⴰ ⵡⴰⵔ ⵉⵜⵜⵉⵛ ⴽⵜⴰⵔ ⵓ ⴰⵎⴻⵣⵍⵓⴹ ⵡⴰⵔ ⵉⵙⵙⴻⵏⵇⵉⵙ ⵣⴻⴳ ⵡⴻⵣⵢⴻⵏ ⵛⵉⵇⵍⵓ, ⵅⵎⵉ ⵖⴰ ⵜⴻⵙⵙⴳⴻⵄⵄⴷⴻⵎ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵙⵉⴷⵉ ⵉ ⵡⴻⵚⵍⴰⵃ ⵏ ⵍⴻⵄⵎⵓⵔ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","ⴰⴷ ⵜⴻⴽⵙⵉⴷ ⵏⵏⵓⵇⴰⵔⵜ ⵉ ⵡⴻⵚⵍⴰⵃ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵛⴰ ⴰⴷ ⵜⵜ ⵜⴼⴰⵔⵣⴻⴷ ⵉ ⵜⵙⴻⵅⵅⴰⵔⵜ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ⴰⴷ ⵜⵉⵍⵉ ⴷ ⵍⵉⴷⴰⵔⴻⵜ ⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⵉ ⵡⴻⵚⵍⴰⵃ ⵏ ⵍⴻⵄⵎⵓⵔ ⵏⵡⴻⵎ.” ");
INSERT INTO rift_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵄⴰⵡⴻⴷ ⵜⴱⴰⵏⵢⵓⵜ ⵏ ⵏⵏⵃⴰⵙ ⵉ ⵓⵙⵉⵔⴷ, ⴰⴽ-ⴷ ⵓⴹⴰⵔ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵏⵏⴻⵙ ⵉ ⵅ ⵜⵜ ⵖⴰ ⵙⵙⴰⵔⵙⴻⵏ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵙⵙⵉⵔⴷⴻⵏ ⵉⵅⴻⴼ ⵏⵙⴻⵏ. ⴰⴷ ⵜⵜ ⵜⴻⵙⵙⴰⵔⵙⴻⴷ ⵊⴰⵔ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⴷ ⵓⵄⴰⵍⵟⴰⵔ ⵓⵛⴰ ⴰⴷ ⴷⴰⵢⴻⵙ ⵜⴻⴳⴳⴻⴷ ⴰⵎⴰⵏ, ");
INSERT INTO rift_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","ⵎⴰⵃⴻⵏⴷ ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵙⵙⵉⵔⴷⴻⵏ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵙⴻⵏ ⴷ ⵉⴹⴰⵔⴻⵏ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","ⵅⵎⵉ ⵖⴰ ⵢⴰⴷⴼⴻⵏ ⵖⴰⵔ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⴰⴷ ⵙⵙⵉⵔⴷⴻⵏ ⵙ ⵡⴰⵎⴰⵏ ⵃⵉⵎⴰ ⵡⴰⵔ ⵜⵜⵎⴻⵜⵜⵉⵏ ⵛⴰ, ⵓⵍⴰ ⵅⵎⵉ ⴷⴷ ⵖⴰ ⵇⴰⵔⵔⴱⴻⵏ ⵖⴰⵔ ⵓⵄⴰⵍⵟⴰⵔ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵙⴻⵅⵅⴰⵔⴻⵏ ⵅⵎⵉ ⵖⴰ ⵙⵙⴱⴻⵅⵅⴰⵔⴻⵏ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","ⵅⴻⵏⵏⵉ ⴰⴷ ⵙⵙⵉⵔⴷⴻⵏ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵙⴻⵏ ⴷ ⵉⴹⴰⵔⴻⵏ ⵏⵙⴻⵏ ⵃⵉⵎⴰ ⵡⴰⵔ ⵜⵜⵎⴻⵜⵜⵉⵏ ⵛⴰ. ⵎⴰⵏ ⴰⵢⴰ ⴰⴷ ⴰⵙⴻⵏ ⵢⵉⵍⵉ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵚⴻⵢⵢⴻⵜ ⵉ ⵍⴻⴱⴷⴰ, ⵉ ⵏⴻⵜⵜⴰ ⵓ ⵉ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵙ, ⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵏⵙⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“ⵛⴻⴽ, ⴽⵙⵉ ⵍⴻⵅⵅⵓ ⵖⴰⵔⴻⴽ ⵍⴻⵄⵟⵓⵔ ⵉⵛⵏⴰⵏ ⴰⵟⵟⴰⵙ: ⵅⴻⵎⵙ-ⵎⵢⴰ ⵛⵉⵇⵍⵓ ⵏ ⵎⵉⵔⵔⵓ ⵢⵓⵣⵣⵍⴻⵏ ⴰⴽ-ⴷ ⵍⵇⴻⴷⴷ ⵏ ⵡⴻⵣⵢⴻⵏ ⵏ ⵎⴰⵏⴰⵡⴻⵏⵏⵉ, ⴰⵇⴰ-ⵜ ⴷ ⵎⵉⵜⴰⵢⴻⵏ ⵓ-ⵅⴻⵎⵙⵉⵏ ⵛⵉⵇⵍⵓ ⵣⵉ ⵍⵇⴰⵔⴼⴰ ⵉⵜⵜⴼⵓⵃⴻⵏ ⵓ ⵎⵉⵜⴰⵢⴻⵏ ⵓ-ⵅⴻⵎⵙⵉⵏ ⵛⵉⵇⵍⵓ ⵣⴻⴳ ⵓⵖⴰⵏⵉⵎ ⵓⵃⴻⵎⵎⵓⵎ ⵉⵜⵜⴼⵓⵃⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","ⵅⴻⵎⵙⴰ-ⵎⵢⴰ ⵛⵉⵇⵍⵓ ⵏ ⵇⴰⵙⵙⵉⵢⴰ ⵉⵡⴻⵣⵣⵏⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵛⵉⵇⵍⵓ ⵏ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ, ⴷ ⵉⵊⵊ ⵏ ⵓⵀⵉⵏⵓ ⵏ ⵣⵣⴻⵛⵜ ⵏ ⵣⵣⵉⵜⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","ⴻⴳⴳ ⵣⵣⴰⵢⵙⴻⵏ ⵉⵛⵜ ⵏ ⵣⵣⴻⵛⵜ ⵜⴰⵎⵇⴻⴷⴷⴰⵙⵜ ⵉ ⵡⴻⴷⵀⴰⵏ, ⵉⵊⵊ ⵏ ⵍⴻⵄⵟⵓⵔ ⵉⵅⴻⴵⴹⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵚⵚⴻⵏⵄⴻⵜ ⵏ ⵓⵄⴻⵟⵟⴰⵔ. ⴰⵢⴰ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵉⵛⵜ ⵏ ⵣⵣⴻⵛⵜ ⵜⴰⵎⵇⴻⴷⴷⴻⵙⵜ ⵉ ⵡⴻⴷⵀⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","ⵙ ⵎⴰⵏ ⴰⵢⴰ ⴰⴷ ⵜⴷⴻⵀⵏⴻⴷ ⴰⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ⵜⵜⴰⴱⵓⵜ ⵏ ⵛⵛⵀⴰⴷⴻⵜ, ");
INSERT INTO rift_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","ⵜⴰⵣⴻⵡⴹⴰ ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ ⵏⵏⴻⵙ ⴷ ⵍⵇⴻⵏⴷⵉⵍ ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ ⵏⵏⴻⵙ ⴷ ⵓⵄⴰⵍⵟⴰⵔ ⵏ ⵍⴻⴱⵅⵓⵔ, ");
INSERT INTO rift_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","ⴷ ⵓⵄⴰⵍⵟⴰⵔ ⵏ ⵡⴻⵛⵎⴰⴹ ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ ⵏⵏⴻⵙ ⴷ ⵜⴱⴰⵏⵢⵓⵜ ⴰⴽ-ⴷ ⵓⴹⴰⵔ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","ⴰⴷ ⵜⴻⵙⵙⵇⴻⴷⴷⵙⴻⴷ ⵎⴰⵔⵔⴰ ⴰⵢⴰ, ⵃⵉⵎⴰ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⴰⵎⵇⴻⴷⴷⴰⵙ ⵇⴰⵄ. ⵎⴰⵔⵔⴰ ⵡⵉ ⵖⴰ ⵉⵃⴰⴷⴰⵏ ⵣⵉ ⵎⴰⵏ ⴰⵢⴰ, ⴰⴷ ⵉⵜⵜⵡⴰⵇⴻⴷⴷⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","ⴰⴷ ⵜⴷⴻⵀⵏⴻⴷ ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⵜⴻⵏ ⵜⴻⵙⵙⵇⴻⴷⴷⵙⴻⴷ, ⵃⵉⵎⴰ ⴰⴷ ⴰⵢⵉ ⵉⵍⵉⵏ ⴷ ⵉⴽⴻⵀⵀⴰⵏⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","ⴰⴷ ⵜⴻⵙⵙⵉⵡⵍⴻⴷ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵛⴰ ⴰⴷ ⵜⵉⵏⵉⴷ: ‘ⵜⴰ ⴰⴷ ⵜⵉⵍⵉ ⴷ ⵉⵛⵜ ⵏ ⵣⵣⴻⵛⵜ ⵜⴰⵎⵇⴻⴷⴷⴰⵙⵜ ⵉ ⵡⴻⴷⵀⴰⵏ ⵉ ⵏⴻⵛⵛ ⴷⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","ⵡⴰⵔ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⵜⵜ ⴼⴰⵔⵔⵖⴻⵏ ⵅ ⴰⵔⵔⵉⵎⴻⵜ ⵏ ⴱⵏⴰⴷⴻⵎ, ⵓ ⵎⴰⵎⵎⴻⵛ ⵜⴻⴵⴰ ⵡⴰⵔ ⵣⵣⴰⵢⴻⵙ ⵜⵜⴻⴳⴳⴻⵎ ⵓⵍⵜⵎⴰⵙ. ⵜⴰⵎⵇⴻⴷⴷⴰⵙⵜ ⵉ ⵜⴻⴵⴰ ⵓⵛⴰ ⴰⴷ ⵜⵉⵍⵉ ⴷ ⵜⴰⵎⵇⴻⴷⴷⴰⵙⵜ ⵉ ⴽⴻⵏⵏⵉⵡ. ");
INSERT INTO rift_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵉⵙⵙⵡⴻⵊⴷⴻⵏ ⵙ ⵍⴻⴱⵣⴰⵔ ⵉⵛⵜ ⵏ ⵣⵣⴻⵛⵜ ⵏ ⵡⴻⴷⵀⴰⵏ ⴰⵎ ⵜⴰⵏⵉⵜⴰ ⵓⵛⴰ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵜⵎⴻⵙⵃⴻⴷ ⵅ ⵢⵉⵊⵊ ⵏ ⵓⴱⴰⵔⵔⴰⵏⵉ, ⴰⴷ ⵉⵜⵜⵡⴰⵇⴻⵙⵙ ⵣⵉ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ.’” ");
INSERT INTO rift_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⴽⵙⵉ ⵉ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵛ ⵍⴻⴱⵣⴰⵔ ⵉⵜⵜⴼⵓⵃⴻⵏ: ⵜⵓⴷⴷⵉⵎⵉⵏ ⵏ ⵓⵙⴻⵔⵖⴰⵖ ⴷ ⵡⴻⵇⵛⵓⵔ ⵏ ⵜⵛⴻⵊⵊⴰⵔⵜ ⵏ ⵍⵇⴰⵔⴼⴰ ⴷ ⵖⴰⵍⴱⴰ, ⵍⴻⴱⵣⴰⵔ ⵉⵜⵜⴼⵓⵃⴻⵏ ⴷ ⵊⵊⴰⵡⵉ ⵉⵚⴼⴰⵏ. ⴰⴷ ⵢⵉⵍⵉ ⵍⵇⴻⴷⴷ ⵏⵏⴻⵙ ⴰⵎ ⵍⵇⴻⴷⴷ ⵏ ⵡⴻⵏⵏⴻⵖⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","ⴻⴳⴳ ⵣⵣⴰⵢⴻⵙ ⵉⵊⵊ ⵏ ⵍⴻⵄⵟⵓⵔ, ⵉⵊⵊ ⵏ ⵓⵅⴻⴵⴻⴹ ⴰⵎ ⵜⴻⵏⵏⵉ ⵉⴳⴳⴰ ⵓⵄⴻⵟⵟⴰⵔ: ⵉⵜⵜⵡⴰⵎⴻⴵⴻⴷ, ⵉⵚⴼⴰ, ⵉⵇⴻⴷⴷⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","ⵃⵔⵉ-ⴷⴷ ⵣⵣⴰⵢⴻⵙ ⵜⴰⵏⴻⵖⴷⴰ ⵜⴰⵣⴷⴰⴷⵜ ⵓⵛⴰ ⵙⴰⵔⵙ ⵛⴰ ⵣⵣⴰⵢⴻⵙ ⵣⵣⴰⵜ ⵉ ⵛⵛⵀⴰⴷⴻⵜ ⴷⴻⴳ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⵎⴰⵏⵉ ⴰⴽⵉⴷⴻⴽ ⵖⴰ ⵎⵙⴰⴳⴰⵔⴻⵖ. ⴰⴷ ⴰⵡⴻⵎ ⵜⵉⵍⵉ ⴷ ⵜⴰⵎⵇⴻⴷⴷⴰⵙⵜ ⵇⴰⵄ. ");
INSERT INTO rift_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","ⵍⴻⵄⵜⵓⵔ ⵏⵏⵉ ⵉ ⵖⴰ ⵜⴻⴳⴳⴻⴷ, ⵡⴰⵔ ⵜ ⵜⵜⴻⴳⴳⴻⵎ ⵙ ⵓⵅⴻⴵⴻⴹ ⴷ ⵉⵊⵊⴻⵏ ⴰⴽⵉⴷⴻⵙ ⵉ ⵢⵉⵅⴻⴼ ⵏⵡⴻⵎ. ⴰⴷ ⵢⵉⵍⵉ ⴷ ⴰⵎⵇⴻⴷⴷⴰⵙ ⵉ ⵛⴻⴽ, ⴰⴷ ⵢⵉⵍⵉ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","ⵡⴻⵏⵏⵉ ⵉ ⵉⴳⴳⵉⵏ ⵛⴰ ⴰⵎ ⵡⴰⵏⵉⵜⴰ ⵓⵛⴰ ⴰⴷ ⵜ ⵉⵛⴻⵎⵎ, ⴰⴷ ⵉⵜⵜⵡⴰⵇⴻⵙⵙ ⵣⵉ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ.” ");
INSERT INTO rift_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“ⵅⵣⴰⵔ, ⵏⴻⵛⵛ ⵍⴰⵖⵉⵖ-ⴷⴷ ⵅ ⴱⴰⵚⴰⵍⵉⵢⵉⵍ, ⵎⵎⵉⵙ ⵏ ⵓⵔⵉ, ⵎⵎⵉⵙ ⵏ ⵃⵓⵔ, ⵣⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⵢⴰⵀⵓⴷⴰ ⵙ ⵢⵉⵙⴻⵎ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","ⵛⵛⵓⵔⴻⵖ ⵜ ⵙ ⴰⵔⵔⵓⵃ ⵏ ⴰⵔⴻⴱⴱⵉ, ⵙ ⵜⵉⵖⵉⵜ, ⵙ ⵍⴻⵄⵇⴻⵍ, ⵙ ⵜⵓⵙⵙⵏⴰ ⵓ ⵙ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⵜⵜⵅⴻⵚⵚⴰⵏ ⵏ ⵜⵣⴻⵎⵎⴰⵔ ⵏ ⵚⵚⵏⴰⵢⴻⵄ, ");
INSERT INTO rift_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","ⵃⵉⵎⴰ ⴰⴷ ⵉⵅⴻⵎⵎⴻⵎ ⵉⵔⴻⵇⵇⴰⵎⴻⵏ ⵙ ⵍⴼⴻⵏⵏ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⴻⵏ ⵜⵜⴻⴳⴳⴻⵏ ⵙ ⵡⵓⵔⴻⵖ ⴷ ⵏⵏⵓⵇⴰⵔⵜ ⴷ ⵏⵏⵃⴰⵙ, ");
INSERT INTO rift_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","ⵓ ⵃⵉⵎⴰ ⴰⴷ ⵏⴻⵇⵛⴻⵏ ⵉⵥⵔⴰ ⵉⵖⵍⴰⵏ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⴻⵏ ⴳⴳⴻⵏ ⴷⵉ ⵜⵛⵓⵢⴰⵔ ⵏⵙⴻⵏ, ⵓ ⵃⵉⵎⴰ ⴰⴷ ⵏⴻⵇⵛⴻⵏ ⴰⴽⴻⵛⵛⵓⴹ, ⵃⵉⵎⴰ ⴰⵎⵎⵓ ⵉ ⵖⴰ ⴳⴳⴻⵏ ⵎⴰⵔⵔⴰ ⵍⵅⴻⴷⵎⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","ⴰⵇⴰ ⵏⴻⵛⵛ ⴳⴳⵉⵖ ⴰⴽⵉⴷⴻⵙ ⴰⵀⵓⵍⵉⵢⴰⴱ, ⵎⵎⵉⵙ ⵏ ⴰⵅⵉⵙⴰⵎⴰⴽ, ⵣⵉ ⵍⴰⴵ ⵏ ⴷⴰⵏ. ⴷⴻⴳ ⵡⵓⵍ ⵏ ⵎⴰⵔⵔⴰ ⵉⵏⵏⵉ ⵖⴰⵔ ⵉⴵⴰ ⵡⵓⵍ ⴷ ⴰⵎⵉⵖⵉⵙ, ⴳⴳⵉⵖ ⵜⵉⵖⵉⵜ. ⵏⵉⵜⵏⵉ ⴰⴷ ⴳⴳⴻⵏ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵅⴻⴼ ⵡⴻⵚⵚⵉⵖ: ");
INSERT INTO rift_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","ⴰⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ⵜⵜⴰⴱⵓⵜ ⵏ ⵛⵛⵀⴰⴷⴻⵜ, ⵜⴰⵇⴻⴱⴱⴰⵔⵜ ⵏ ⵡⴻⵚⵍⴰⵃ ⵏⵏⵉ ⵅⴰⵙ ⵉⴵⴰⵏ, ⵓ ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ ⵏ ⵓⵇⵉⴹⵓⵏ: ");
INSERT INTO rift_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ⵜⴰⵣⴻⵡⴹⴰ ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ ⵏⵏⴻⵙ, ⴷ ⵍⵇⴻⵏⴷⵉⵍ ⵉⵚⴼⴰⵏ ⵙ ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ ⵏⵏⴻⵙ ⴷ ⵓⵄⴰⵍⵟⴰⵔ ⵏ ⵍⴻⴱⵅⵓⵔ, ");
INSERT INTO rift_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","ⴰⵄⴰⵍⵟⴰⵔ ⵏ ⵡⴻⵛⵎⴰⴹ ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ ⵏⵏⴻⵙ ⴷ ⵜⴱⴰⵏⵢⵓⵜ ⵙ ⵓⴹⴰⵔ ⵏⵏⴻⵙ, ");
INSERT INTO rift_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","ⴰⵔⵔⵓⴹ ⵏ ⵜⵙⴻⵅⵅⴰⵔⵜ ⴷ ⵡⴰⵔⵔⵓⴹ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵏ ⵀⴰⵔⵓⵏ, ⴰⴽⴻⵀⵀⴰⵏ, ⴷ ⵡⴰⵔⵔⵓⴹ ⵏ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵙⴻⵅⵅⴰⵔⴻⵏ ⴰⵎ ⵓⴽⴻⵀⵀⴰⵏ, ");
INSERT INTO rift_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","ⴷ ⵣⵣⴻⵛⵜ ⵉ ⵡⴻⴷⵀⴰⵏ, ⴷ ⵍⴻⴱⵅⵓⵔ ⵉⵜⵜⴼⵓⵃⴻⵏ ⵉ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ. ⵄⵍⴰⵃⵙⴰⴱ ⵎⴰⵔⵔⴰ ⵎⵉⵏⵣⵉ ⵛⴻⴽ ⵓⵎⵓⵔⴻⵖ ⴰⴷ ⴳⴳⴻⵏ ⵎⴰⵔⵔⴰ ⴰⵢⴰ.” ");
INSERT INTO rift_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“ⵛⴻⴽ, ⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵉⵏⵉ: ‘ⴰⴷ ⵜⴻⵃⴹⴰⵎ ⵓⵙⵙⴰⵏ ⵏ ⵙⵙⴻⴱⵜ ⵉⵏⵓ, ⵎⵉⵏⵣⵉ ⵙⵙⴻⴱⵜ ⴷ ⵍⴻⵄⵍⴰⵎⴻⵜ ⵊⴰⵔ ⴰⵢⵉ ⴷ ⴽⴻⵏⵏⵉⵡ, ⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵏⵡⴻⵎ, ⵃⵉⵎⴰ ⴰⴷ ⵜⴻⵙⵙⵏⴻⵎ ⴱⴻⵍⵍⵉ ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⵡⴻⵏⵏⵉ ⴽⴻⵏⵏⵉⵡ ⵉⵙⵙⵇⴻⴷⴷⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","ⵃⴹⴰⵎ ⴰⵙⵙ ⵏ ⵙⵙⴻⴱⵜ, ⵎⵉⵏⵣⵉ ⵉⵇⴻⴷⴷⴻⵙ ⵉ ⵉⴵⴰ ⵉ ⴽⴻⵏⵏⵉⵡ! ⵡⴻⵏⵏⵉ ⵜ ⵖⴰ ⵉⵙⵙⴼⴻⵙⴷⴻⵏ, ⴰⴷ ⵜ ⵏⵖⴻⵏ ⵏⵉⵛⴰⵏ, ⵎⵉⵏⵣⵉ ⵎⴰⵏ ⵡⴻⵏ ⵉ ⴷⴰⵢⴻⵙ ⵖⴰ ⵉⴳⴳⴻⵏ ⵛⴰ ⵏ ⵍⵅⴻⴷⵎⴻⵜ, ⴰⴷ ⵉⵜⵜⵡⴰⵇⴹⴻⵄ ⵣⵉ ⵍⵡⴻⵙⵟ ⵏ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ.    ");
INSERT INTO rift_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","ⵙⴻⵜⵜⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵍⵅⴻⴷⵎⴻⵜ ⵓⵛⴰ ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵙⵙⴻⴱⵜ, ⴰⵔⵔⴰⵃⴻⵜ ⵜⵎⵓⵏ, ⵜⵇⴻⴷⴷⴻⵙ ⵉ ⵜⴻⴵⴰ ⵉ ⵙⵉⴷⵉ! ⴽⵓⵍ ⵉⵊⵊ, ⵡⴻⵏⵏⵉ ⵉⴳⴳⵉⵏ ⵛⴰ ⵏ ⵍⵅⴻⴷⵎⴻⵜ ⴷⴻⴳ ⵡⴰⵙⵙ ⵏ ⵙⵙⴻⴱⵜ, ⴰⴷ ⵜ ⵏⵖⴻⵏ ⵏⵉⵛⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴰⴷ ⵃⴹⴰⵏ ⴰⵙⵙ ⵏ ⵙⵙⴻⴱⵜ, ⴰⴷ ⵃⴹⴰⵏ ⵙⵙⴻⴱⵜ ⴷⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵏⵙⴻⵏ ⴰⵎ ⵉⵊⵊ ⵏ ⵍⵄⴰⵀⴷ ⵉ ⵍⴻⴱⴷⴰ. ");
INSERT INTO rift_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","ⴰⴷ ⵜⵉⵍⵉ ⴷ ⵉⵛⵜ ⵏ ⵍⴻⵄⵍⴰⵎⴻⵜ ⵊⴰⵔ ⴰⵢⵉ ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵎⵉⵏⵣⵉ ⴷⵉ ⵙⴻⵜⵜⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⵉⴳⴳⴰ ⵙⵉⴷⵉ ⴰⵊⴻⵏⵏⴰ ⴷ ⵜⴻⵎⵎⵓⵔⵜ ⵓ ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ ⵢⴰⵔⴻⵢⵢⴻⵃ, ⵢⴰⵔⵔⴰ ⵏⵏⴻⴼⵙ.” ");
INSERT INTO rift_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","ⵍⴰⵎⵉ ⵉⴽⴻⵎⵎⴻⵍ ⵙⵉⴷⵉ ⴰⵡⴰⵍ ⵉ ⴽⵉⴷⴻⵙ ⵉⵙⵙⵉⵡⵍⴻⵏ ⵅ ⵡⴻⴷⵔⴰⵔ ⵏ ⵙⵉⵏⴰ, ⵉⵡⵛⴰ ⵉ ⵎⵓⵙⴰ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵍⵡⵉⵃⵉⵏ ⵏ ⵛⵛⵀⴰⴷⴻⵜ. ⵜⵓⵖⴰ ⵜⵉⵍⵡⵉⵃⵉⵏ ⵏⵏⵉ ⵣⴻⴳ ⵡⴻⵥⵔⵓ, ⵜⵜⵡⴰⵔⵉⵏⵜ ⵙ ⵓⴹⴰⴹ ⵏ ⴰⵔⴻⴱⴱⵉ. ");
INSERT INTO rift_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","ⵍⴰⵎⵉ ⵉⵥⵔⴰ ⵍⴳⴻⵏⵙ ⴱⴻⵍⵍⵉ ⵎⵓⵙⴰ ⵉⵄⴻⵟⵟⴰⵍ, ⵡⴰⵔ ⴷⴷ-ⵉⵀⵡⵉ ⵄⴰⴷ ⵣⴻⴳ ⵡⴻⴷⵔⴰⵔ, ⵉⵏⵏⴻⵢⵔⵓ-ⴷⴷ ⵍⴳⴻⵏⵙ ⵖⴰⵔ ⵀⴰⵔⵓⵏ, ⵏⵏⴰⵏ ⴰⵙ: “ⴽⴽⴰⵔ, ⴻⴳⴳ ⴰⵏⴻⵖ ⵉⵔⴻⴱⴱⵉⵜⴻⵏ, ⵉⵏⵏⵉ ⵉ ⵖⴰ ⵢⵓⵢⵓⵔⴻⵏ ⵣⵣⴰⵜⵏⴻⵖ, ⵎⵉⵏⵣⵉ ⵎⵓⵙⴰ ⴰⵢⴰ, ⴰⵔⵢⴰⵣ ⵏⵏⵉ ⴷ ⴰⵏⴻⵖ ⴷⴷ-ⵉⵙⵙⵓⴼⴼⵖⴻⵏ ⵣⵉ ⵎⵉⵚⵔⴰ, ⵡⴰⵔ ⵏⴻⵙⵙⵉⵏ ⵎⵉⵏ ⵜ ⵢⵓⵖⵉⵏ.” ");
INSERT INTO rift_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","ⵀⴰⵔⵓⵏ ⵉⵏⵏⴰ ⴰⵙⴻⵏ: “ⵇⴻⵍⵄⴻⵎ ⵜⵉⵅⵔⴰⵣⵉⵏ ⵏ ⵡⵓⵔⴻⵖ ⵏⵏⵉ ⵉⴵⴰⵏ ⴷⴻⴳ ⵉⵎⴻⵊⵊⴰⵏ ⵏ ⵜⴻⵎⵖⴰⵔⵉⵏ ⵏⵡⴻⵎ ⵓ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵡⴻⵎ ⵓⵍⴰ ⵏ ⵢⴻⵙⵙⵉⵜⵡⴻⵎ, ⴰⵡⵢⴻⵎ ⵜⴻⵏⵜ-ⵉ-ⴷⴷ ⵖⴰⵔⵉ.” ");
INSERT INTO rift_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","ⵉⴽⴽⴻⵙ ⵎⴰⵔⵔⴰ ⵍⴳⴻⵏⵙ ⵜⵉⵅⵔⴰⵣⵉⵏ ⵏ ⵡⵓⵔⴻⵖ ⵏⵏⵉ ⵉⴵⴰⵏ ⴷⴻⴳ ⵉⵎⴻⵊⵊⴰⵏ ⵏⵙⴻⵏ ⵓⵛⴰ ⵉⵡⵢⴻⵏ ⴰⵙ ⵜⴻⵏⵜ-ⵉ-ⴷⴷ ⵖⴰⵔ ⵀⴰⵔⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","ⵏⴻⵜⵜⴰ ⵉⴽⵙⵉ ⵜⴻⵏⵜ ⵣⴻⴳ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵙⴻⵏ ⵓⵛⴰ ⵉⵛⴻⴽⴽⴻⵍ ⵉ-ⵜⴻⵏⵜ ⵙ ⵉⵎⴻⵢⴷⵉ, ⵉⴳⴳⴰ ⵣⵣⴰⵢⵙⴻⵏⵜ ⵉⵊⵊ ⵏ ⵓⵄⴻⵊⵎⵉ ⵏ ⵓⴼⴻⵙⵙⵉ. ⵍⴻⵅⴷⴻⵏⵏⵉ ⵏⵏⴰⵏ: “ⴰ ⵉⵙⵔⴰⵉⵍ, ⵡⴰ ⴷ ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵛ, ⵡⴻⵏⵏⵉ ⵛⴻⴽ ⴷⴷ-ⵉⵙⵙⵓⴼⴼⵖⴻⵏ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ.” ");
INSERT INTO rift_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","ⵍⴰⵎⵉ ⵉⵥⵔⴰ ⵀⴰⵔⵓⵏ ⴰⵢⴰ, ⵉⴱⵏⴰ ⵉⵊⵊ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ⵣⵣⴰⵜ ⵉ ⵓⵄⴻⵊⵎⵉ ⵓⵛⴰ ⵉⵍⴰⵖⴰ ⵀⴰⵔⵓⵏ, ⵉⵏⵏⴰ: “ⵜⵉⵡⴻⵛⵛⴰ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵍⵄⵉⴷ ⵉ ⵙⵉⴷⵉ.” ");
INSERT INTO rift_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","ⵜⵉⵡⴻⵛⵛⴰ ⵏⵏⴻⵙ ⴽⴽⴰⵔⴻⵏ ⵣⵉⵛ ⵓⵛⴰ ⵙⵙⴱⴻⵅⵅⴰⵔⴻⵏ ⵜⵉⵖⴰⵔⵚⴰ ⵏ ⵡⴻⵛⵎⴰⴹ ⵓⵛⴰ ⵇⴻⴷⴷⵎⴻⵏ ⴰⴽⵉⴷⵙⴻⵏⵜ ⵄⴰⵡⴻⴷ ⵜⵉⵖⴰⵔⵚⴰ ⵏ ⵍⴻⵀⵏⴰ. ⵅⴻⵏⵏⵉ ⵉⵇⵇⵉⵎ ⵍⴳⴻⵏⵙ, ⵉⵛⵛⴰ, ⵉⵙⵡⴰ, ⵉⴽⴽⴰⵔ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵢⴻⴳⴳ ⵍⴻⴼⵔⴰⵢⴻⵊ. ");
INSERT INTO rift_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","ⵅⴰⵙ ⵓⵛⴰ ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ: “ⵓⵢⵓⵔ, ⵀⵡⴰ, ⵎⵉⵏⵣⵉ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵛ, ⵡⴻⵏⵏⵉ ⴷⴷ-ⵜⴻⵙⵙⵓⴼⴼⵖⴻⴷ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ, ⴰⵇⴰ ⵉⴳⴳⴰ ⵎⵉⵏ ⵡⴰⵔ ⵉⵃⵍⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","ⴰⵇⴰ ⴼⴼⵖⴻⵏ ⴷⴻⵖⵢⴰ ⵅ ⵡⴻⴱⵔⵉⴷ ⵏⵏⵉ ⵅ ⵜⴻⵏ ⵡⴻⵚⵚⵉⵖ. ⴳⴳⵉⵏ ⵉⵊⵊ ⵏ ⵓⵄⴻⵊⵎⵉ ⵏ ⵓⴼⴻⵙⵙⵉ ⵉ ⵢⵉⵅⴻⴼ ⵏⵙⴻⵏ ⵓⵛⴰ ⴱⴻⵏⴷⵇⴻⵏ ⴰⵙ, ⵇⴻⴷⴷⵎⴻⵏ ⴰⵙ ⵜⵉⵖⴰⵔⵚⴰ ⵓⵛⴰ ⵏⵏⴰⵏ: ‘ⴰ ⵉⵙⵔⴰⵉⵍ, ⵡⴰⵏⵉⵜⴰ ⴷ ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵛ, ⵡⴻⵏⵏⵉ ⵛⴻⴽ ⴷⴷ-ⵉⵙⵙⵓⴼⴼⵖⴻⵏ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ.’” ");
INSERT INTO rift_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⵏⴻⵛⵛ ⵥⵔⵉⵖ ⵍⴳⴻⵏⵙ-ⴰ, ⵅⵣⴰⵔ, ⴰⵇⴰ-ⵜ ⴷ ⵉⵊⵊ ⵏ ⵍⴳⴻⵏⵙ ⵉⵇⵙⴻⵃ! ");
INSERT INTO rift_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","ⵍⴻⵅⵅⵓ ⴻⵊⵊ ⴰⵢⵉ ⴰⴷ ⵔⴰⵃⴻⵖ, ⴰⴷ ⴰⵔⴻⵖ ⴰⵖⴹⴰⴱ ⵉⵏⵓ ⵅⴰⵙⴻⵏ ⵓⵛⴰ ⴰⴷ ⵜⴻⵏ ⵜⴻⵃⵃⵉⵖ, ⵓ ⵏⴻⵛⵛ ⴰⴷ ⵛⴻⴽ ⴰⵔⵔⴻⵖ ⴷ ⵉⵊⵊ ⵏ ⵍⴳⴻⵏⵙ ⵉⵎⵖⴰⵔ.” ");
INSERT INTO rift_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","ⵎⴰⵛⴰ ⵎⵓⵙⴰ ⵉⵣⴰⵡⴳ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵙ, ⵉⵏⵏⴰ: “ⴰ ⵙⵉⴷⵉ, ⵎⴰⵢⴻⵎⵎⵉ ⵖⴰ ⵢⴰⵔⴻⵖ ⵡⴻⵖⴹⴰⴱ ⵏⵏⴻⵛ ⵅ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵛ, ⵡⴻⵏⵏⵉ ⴷⴷ-ⵜⴻⵙⵙⵓⴼⴼⵖⴻⴷ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⵙ ⵢⵉⵊⵊ ⵏ ⵊⵊⴻⵀⴷ ⵉⵎⵖⴰⵔ ⵓ ⵙ ⵓⴼⵓⵙ ⵉⵊⴻⵀⴷⴻⵏ? ");
INSERT INTO rift_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","ⵎⴰⵢⴻⵎⵎⵉ ⵙⵙⴰⵡⴰⵍⴻⵏ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ ⵊⴰⵔ ⴰⵙⴻⵏ, ⵇⵇⴰⵔⴻⵏ: ‘ⵏⴻⵜⵜⴰ ⵉⵙⵙⵓⴼⴼⴻⵖ ⵉ-ⵜⴻⵏ ⵙ ⵏⵏⴻⵢⵢⴻⵜ ⵜⴰⵄⴻⴼⴼⴰⵏⵜ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⴻⵏ ⵉⵏⴻⵖ ⵅ ⵉⴷⵓⵔⴰⵔ ⵓ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⴻⵏ ⵉⵜⴻⵃⵃⴰ ⵣⴻⴳ ⵡⵓⴷⴻⵎ ⵏ ⵜⴻⵎⵎⵓⵔⵜ?’ ⴷⵡⴻⵍ ⵅ ⵍⵃⴰⴷⵓⵇ ⵏ ⵡⴻⵖⴹⴰⴱ ⵏⵏⴻⵛ ⵓⵛⴰ ⵏⴷⴻⵎ ⵅ ⵜⵓⵄⴻⴼⴼⵏⴰ ⵉ ⵜⴻⵅⵙⴻⴷ ⴰⴷ ⵜⴰⵔⵔⴻⴷ ⵅ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","ⴼⴻⴽⴽⴰⵔ ⴷⵉ ⵉⴱⵔⴰⵀⵉⵎ ⴷ ⵉⵙⵃⴰⵇ ⴷ ⵉⵙⵔⴰⵉⵍ, ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵛ, ⵉⵏⵏⵉ ⵓⵎⵉ ⵜⴻⵊⵊⵓⴵⴻⴷ ⵙ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵛ ⵓ ⵜⴻⵙⵙⵉⵡⵍⴻⴷ ⴰⴽⵉⴷⵙⴻⵏ: ‘ⵏⴻⵛⵛ ⴰⴷ ⴰⵔⵏⵉⵖ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵡⴻⵎ ⴰⵎ ⵢⵉⵜⵔⴰⵏ ⵏ ⵓⵊⴻⵏⵏⴰ ⵓⵛⴰ ⴰⴷ ⵡⵛⴻⵖ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ-ⴰ ⵉ ⵅⴻⴼ ⵙⵙⵉⵡⵍⴻⵖ ⵉ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵛ ⵓⵛⴰ ⵏⵉⵜⵏⵉ ⴰⴷ ⵜⵜ ⵟⵟⴼⴻⵏ ⴷ ⵉⵛⵜ ⵏ ⵍⵡⴰⵔⵜ ⵉ ⵍⴻⴱⴷⴰ.” ");
INSERT INTO rift_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","ⵅⴻⵏⵏⵉ ⵉⵏⴷⴻⵎ ⵙⵉⴷⵉ ⵅ ⵜⵓⵄⴻⴼⴼⵏⴰ ⵉ ⵜⵓⵖⴰ ⵉⵏⵏⴰ ⴰⴷ ⵜⵜ ⵢⴻⴳⴳ ⵅ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","ⵓⵛⴰ ⵉⴷⵡⴻⵍ-ⴷⴷ ⵎⵓⵙⴰ, ⵉⵀⵡⴰ-ⴷⴷ ⵣⴻⴳ ⵡⴻⴷⵔⴰⵔ ⵙ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵍⵡⵉⵃⵉⵏ ⵏ ⵛⵛⵀⴰⴷⴻⵜ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏⵏⴻⵙ. ⵜⵉⵍⵡⵉⵃⵉⵏ-ⴰ ⵜⵜⵡⴰⵔⵉⵏⵜ ⵅ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵖⴻⵣⴷⵉⵙⴻⵏ ⵏⵙⴻⵏⵜ: ⵜⵜⵡⴰⵔⵉⵏⵜ ⵅ ⵢⵉⵊⵊ ⵏ ⵓⵖⴻⵣⴷⵉⵙ ⵓ ⵅ ⵓⵖⴻⵣⴷⵉⵙ ⵏⵏⴻⵖⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","ⵜⵉⵍⵡⵉⵃⵉⵏ ⵜⵓⵖⴰ ⴰⵜⴻⵏⵜ ⴷ ⵍⵅⴻⴷⵎⴻⵜ ⵏ ⴰⵔⴻⴱⴱⵉ ⵓⵛⴰ ⵜⵉⵔⴰ ⵏⵏⵉ ⵉⵏⴻⵇⵛⴻⵏ ⴷⵉ ⵜⴻⵍⵡⵉⵃⵉⵏ ⴷ ⵜⵉⵔⴰ ⵏ ⴰⵔⴻⴱⴱⵉ. ");
INSERT INTO rift_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","ⵉⵙⵍⴰ ⵢⴰⵛⵓⵡⴰ ⵉ ⵍⵃⴻⵙⵙ ⵏ ⵍⴳⴻⵏⵙ ⵉⵙⵖⵓⵢⵢⵓ ⵓⵛⴰ ⵉⵏⵏⴰ ⵉ ⵎⵓⵙⴰ: “ⴰⵇⴰ ⴷⴰ, ⵍⵃⴻⵙⵙ ⵏ ⵓⵎⴻⵏⵖⵉ ⴷⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ.” ");
INSERT INTO rift_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","ⵎⴰⵛⴰ ⵏⴻⵜⵜⴰ ⵉⵏⵏⴰ: “ⵡⴰⵔ ⵉⴵⵉ ⴷ ⵍⵃⴻⵙⵙ ⵏ ⵓⵙⵍⴻⵡⵍⵉⵡ ⵖⴰⵔ ⵍⴻⵖⵍⴻⴱ ⵏⵉⵖ ⴷ ⵍⵃⴻⵙⵙ ⵏ ⵓⵙⵖⵓⵢⵢⵉ ⵖⴰⵔ ⵜⵅⴻⵙⵙⴰⵔⵜ, ⵎⴰⵛⴰ ⵎⵉⵏ ⵜⵜⴻⵙⵍⵉⵖ ⴷ ⵍⵃⴻⵙⵙ ⵏ ⵉⵖⵓⵢⵢⴰⵏ ⵡⴰⵔ ⵉⵃⵍⵉⵏ.” ");
INSERT INTO rift_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","ⵓⵛⴰ ⵉⵎⵙⴰⵔ, ⴰⵎ ⴷⴷ-ⵉⵔⴻⵃⵃⴻⴳ ⵖⴰⵔ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵓⵛⴰ ⵉⵥⵔⴰ ⴰⵄⴻⵊⵎⵉ ⴷ ⵛⵛⴹⵉⵃ ⵙ ⵏⵏⵓⴱⵜⴰⵜ, ⵢⴰⵔⵖⴰ ⵡⴻⵖⴹⴰⴱ ⵏ ⵎⵓⵙⴰ ⵓⵛⴰ ⵉⵏⴹⴰⵔ ⵜⵉⵍⵡⵉⵃⵉⵏ ⵣⴻⴳ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵏⴻⵙ, ⵢⴰⵔⵥⴰ ⵉ-ⵜⴻⵏⵜ ⵖⴰⵔ ⵉⴹⴰⵔⴻⵏ ⵏ ⵡⴻⴷⵔⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","ⵉⵟⵟⴻⴼ ⵓⵄⴻⵊⵎⵉ ⵏⵏⵉ ⴳⴳⵉⵏ, ⵉⵙⵙⵛⴻⵎⴹ ⵉ-ⵜ ⴷⵉ ⵜⵎⴻⵙⵙⵉ, ⴰⵍⴰⵎⵉ ⵉⴷⵡⴻⵍ ⴷ ⵉⵖⵖⴻⴹ ⵓⵛⴰ ⵉⵣⵣⵓⵣⴰⵔ ⵉ-ⵜ ⵅ ⵡⵓⴷⴻⵎ ⵏ ⵡⴰⵎⴰⵏ ⵓⵛⴰ ⵢⴰⵔⵔⴰ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴰⴷ ⵜ ⵙⵡⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","ⵉⵏⵏⴰ ⵎⵓⵙⴰ ⵉ ⵀⴰⵔⵓⵏ: “ⵎⵉⵏ ⵣⵣⴰⵢⴻⴽ ⵉⴳⴳⴰ ⵍⴳⴻⵏⵙ-ⴰ ⴰⵍⴰⵎⵉ ⴷ ⴰⵙ ⴷⴷ-ⵜⵉⵡⵢⴻⴷ ⵉⵊⵊ ⵏ ⴷⴷⴻⵏⴱ ⴷ ⴰⵎⴻⵇⵇⵔⴰⵏ ⴰⵟⵟⴰⵙ?” ");
INSERT INTO rift_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","ⵀⴰⵔⵓⵏ ⵉⵏⵏⴰ: “ⵡⴰⵔ ⵢⴰⵔⴻⵇⵇ ⵡⴻⵖⴹⴰⴱ ⵏ ⵙⵉⴷⵉ ⵉⵏⵓ! ⵛⴻⴽ ⵜⴻⵙⵙⵏⴻⴷ ⵍⴳⴻⵏⵙ-ⴰ, ⴰⵇⴰ-ⵜ ⴷⵉ ⵍⵖⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","ⵏⵏⴰⵏ ⴰⵢⵉ: ‘ⴻⴳⴳ ⴰⵏⴻⵖ ⵉⵔⴻⴱⴱⵉⵜⴻⵏ ⵏⵏⵉ ⵖⴰ ⵢⵓⵢⵓⵔⴻⵏ ⵣⵣⴰⵜ ⵉ ⵓⵖⴻⵎⴱⵓⴱ ⵏⵏⴻⵖ, ⵎⵉⵏⵣⵉ ⵎⵓⵙⴰ ⵡⴰⵏⵉⵜⴰ, ⴰⵔⵢⴰⵣ ⵡⴻⵏⵏⵉ ⴷ ⴰⵏⴻⵖ ⴷⴷ-ⵉⵙⵙⵓⴼⴼⵖⴻⵏ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ, ⵡⴰⵔ ⵏⴻⵙⵙⵉⵏ ⵎⵉⵏ ⵜ ⵢⵓⵖⵉⵏ.’ ");
INSERT INTO rift_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","ⵅⴻⵏⵏⵉ ⵏⵏⵉⵖ ⴰⵙⴻⵏ: ‘ⵡⵉ ⵖⴰⵔ ⵉⴵⴰ ⵓⵔⴻⵖ, ⴰⴷ ⵜ-ⵉ-ⴷⴷ-ⵉⴽⴽⴻⵙ, ⵓⵛⴰ ⴰⴷ ⴰⵢⵉ ⵜ ⵢⴻⵡⵛ!’ ⵓⵛⴰ ⵏⴹⴰⵔⴻⵖ ⵜ ⴷⵉ ⵜⵎⴻⵙⵙⵉ ⵓⵛⴰ ⵉⴼⴼⴻⵖ-ⴷⴷ ⵓⵄⴻⵊⵎⵉ-ⵢⴰ.” ");
INSERT INTO rift_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","ⵓⵎⵉ ⵉⵥⵔⴰ ⵎⵓⵙⴰ, ⴰⵇⴰ ⵍⴳⴻⵏⵙ ⵉⴷⵡⴻⵍ ⴷ ⵉⵎⴼⴻⵍⵍⴻⵙ, ⵎⵉⵏⵣⵉ ⵀⴰⵔⵓⵏ ⵉⵊⵊⴰ ⴰⴼⴻⵍⵍⴻⵙ ⵏⵙⴻⵏ ⴰⴷ ⵉⴷⵡⴻⵍ ⴷ ⵜⴰⴹⴻⵃⵃⴰⵛⵜ ⵊⴰⵔ ⵍⵄⴻⴷⵢⴰⵏ ⵏⵙⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","ⵉⴱⴻⴷⴷ ⵎⵓⵙⴰ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵍⵎⴰⵔⴳⴻⵃ, ⵉⵏⵏⴰ: “ⵎⴰⵏ ⵡⴻⵏ ⵉ ⵉⴵⴰⵏ ⵉ ⵙⵉⴷⵉ, ⴰⵙ-ⴷⴷ ⴷⴰ ⵖⴰⵔⵉ!” ⵓⵛⴰ ⵎⵓⵏⴻⵏ-ⴷⴷ ⵖⴰⵔⴻⵙ ⵎⴰⵔⵔⴰ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵍⴰⵡⵉ. ");
INSERT INTO rift_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","ⵉⵏⵏⴰ ⴰⵙⴻⵏ: “ⴰⵎⵎⵓ ⵉ ⵉⵇⵇⴰⵔ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏ ⵉⵙⵔⴰⵉⵍ! ⵙⴰⵔⵙⴻⵎ ⴽⵓⵍ ⵉⵊⵊ ⵙⵙⵉⴼ ⵏⵏⴻⵙ ⵅ ⵜⵎⴻⵚⵚⴰⴹⵜ ⵏⵏⴻⵙ, ⵄⴷⵓⵎ ⵓⵛⴰ ⵄⴻⵇⴱⴻⵎ ⵅ ⵍⵎⴰⵔⴳⴻⵃ ⵣⴻⴳ ⵡⴰⴷⴰⴼ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏⵏⴻⵖⵏⵉ ⵓⵛⴰ ⴰⴷ ⵉⵏⴻⵖ ⴽⵓⵍ ⵉⵊⵊ ⵓⵎⴰⵙ ⴷ ⴽⵓⵍ ⵉⵊⵊ ⵓⵎⴻⴷⴷⵓⴽⴽⴻⵍ ⵏⵏⴻⵙ ⴷ ⴽⵓⵍ ⵉⵊⵊ ⵊⵊⴰⵔ ⵏⵏⴻⵙ!” ");
INSERT INTO rift_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","ⵜⴰⵔⵡⴰ ⵏ ⵍⴰⵡⵉ ⴳⴳⵉⵏ ⵄⵍⴰⵃⵙⴰⴱ ⴰⵡⴰⵍ ⵏ ⵎⵓⵙⴰ. ⴷⴻⴳ ⵡⴰⵙⵙ ⵏⵏⵉ ⵡⴹⴰⵏ ⵄⵍⴰⵃⴰⵍ ⵜⴻⵍⵜ-ⴰⵍⴰⴼ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ ⵏ ⵍⴳⴻⵏⵙ. ");
INSERT INTO rift_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","ⵎⵓⵙⴰ ⵉⵏⵏⴰ: “ⴽⵙⵉⵎ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵡⴻⵎ ⴰⵙⵙ-ⴰ ⵖⴰⵔ ⵙⵉⴷⵉ, ⴽⵓⵍ ⵉⵊⵊ ⵅ ⵎⵎⵉⵙ ⵓ ⵅ ⵓⵎⴰⵙ. ⵎⴻⵄⵍⵉⴽ ⵓⴼⵉⵖ ⵏⴻⵜⵜⴰ ⴰⴷ ⵉⴱⴰⵔⴻⴽ ⵉ ⴽⴻⵏⵏⵉⵡ ⴰⵎⵎⵓ ⴰⵙⵙ-ⴰ!” ");
INSERT INTO rift_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","ⵜⵉⵡⴻⵛⵛⴰ ⵏⵏⴻⵙ ⵉⵏⵏⴰ ⵎⵓⵙⴰ ⵉ ⵍⴳⴻⵏⵙ: “ⴽⴻⵏⵏⵉⵡ ⵜⴻⴳⴳⵉⵎ ⵉⵊⵊ ⵏ ⴷⴷⴻⵏⴱ ⵉⵎⵖⴰⵔ. ⵄⴰⴷ ⵏⴻⵛⵛ ⴰⴷ ⴰⵍⵢⴻⵖ ⵍⴻⵅⵅⵓ ⵖⴰⵔ ⵙⵉⴷⵉ, ⴱⴰⵍⴰⴽ ⴰⴷ ⵓⴼⵉⵖ ⴰⵚⵍⴰⵃ ⵅ ⴷⴷⴻⵏⴱ ⵏⵡⴻⵎ.” ");
INSERT INTO rift_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","ⵉⴷⵡⴻⵍ-ⴷⴷ ⵎⵓⵙⴰ ⵖⴰⵔ ⵙⵉⴷⵉ ⵓⵛⴰ ⵉⵏⵏⴰ ⴰⵙ: “ⵡⴰⵢⵢⴰⵡ, ⵍⴳⴻⵏⵙ-ⴰ ⵉⴳⴳⴰ ⵉⵊⵊ ⵏ ⴷⴷⴻⵏⴱ ⵉⵎⵖⴰⵔ, ⵎⵉⵏⵣⵉ ⴳⴳⵉⵏ ⵉⵊⵊ ⵏ ⴰⵔⴻⴱⴱⵉ ⵏ ⵡⵓⵔⴻⵖ ⵉ ⵢⵉⵅⴻⴼ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","ⵍⴻⵅⵅⵓ, ⵖⴼⴰⵔ ⴰⵙⴻⵏ ⵉ ⴷⴷⴻⵏⴱ ⵏⵙⴻⵏ! ⵏⵉⵖ ⵎⵃⴰ ⴰⵢⵉ ⵣⴻⴳ ⵡⴻⴷⵍⵉⵙ ⵏⵏⴻⵛ ⵉⵜⵜⵡⴰⵏⵏⴹⴻⵏ ⵏⵏⵉ ⵜⵓⵔⵉⴷ.” ");
INSERT INTO rift_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⵡⴻⵏⵏⵉ ⵅⴰⴼⵉ ⵉⵅⴹⴰⵏ, ⴷ ⵡⴰ ⵉ ⵖⴰ ⵎⵃⵉⵖ ⵣⴻⴳ ⵡⴻⴷⵍⵉⵙ ⵉⵏⵓ ⵉⵜⵜⵡⴰⵏⵏⴹⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","ⵔⵓⵃ ⵍⴻⵅⵅⵓ, ⴰⵡⵉ ⵍⴳⴻⵏⵙ-ⴰ ⵖⴰⵔ ⵎⴰⵏⵉ ⴷ ⴰⵛ ⵏⵏⵉⵖ. ⴰⵇⴰ ⵍⵎⴰⵍⴰⴽ ⵉⵏⵓ ⴰⴷ ⵉⵔⴰⵃ ⵣⵣⴰⵜ ⵏⵏⴻⵛ! ⴷⴻⴳ ⵡⴰⵙⵙ ⵏ ⵓⵅⴻⴵⴻⵚ ⵉⵏⵓ ⴰⴷ ⴰⵙⴻⵏ ⵅⴻⴵⵚⴻⵖ ⴷⴷⵏⵓⴱ ⵏⵙⴻⵏ!” ");
INSERT INTO rift_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","ⴰⵎⵎⵓ ⵉ ⵉⵡⵜⴰ ⵙⵉⴷⵉ ⵍⴳⴻⵏⵙ, ⵎⵉⵏⵣⵉ ⴳⴳⵉⵏ ⴰⵄⴻⵊⵎⵉ ⵏⵏⵉ ⵉⴳⴳⴰ ⵀⴰⵔⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ: “ⵔⵓⵃ, ⴳⴻⵄⵄⴻⴷ ⵙⵙⴰ, ⵛⴻⴽ ⴷ ⵍⴳⴻⵏⵙ ⵏⵏⵉ ⴷⴷ-ⵜⴻⵙⵙⵓⴼⴼⵖⴻⴷ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ, ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⵉ ⵅ ⵊⵊⵓⴵⴻⵖ ⵉ ⵉⴱⵔⴰⵀⵉⵎ ⴷ ⵉⵙⵃⴰⵇ ⴷ ⵢⴰⵄⵇⵓⴱ, ⵏⵏⵉⵖ: ‘ⵉ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵛ ⴰⴷ ⵜⵜ ⵡⵛⴻⵖ!’ ");
INSERT INTO rift_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","ⵏⴻⵛⵛ ⴰⴷ ⵙⵙⴻⴽⴽⴻⵖ ⵣⵣⴰⵜ ⵉ ⵓⵖⴻⵎⴱⵓⴱ ⵏⵏⴻⵛ ⵍⵎⴰⵍⴰⴽ, ⵓⵛⴰ ⴰⴷ ⴰⵥⵥⵍⴻⵖ ⵅ ⴰⵢⵜ ⵏ ⴽⴻⵏⵄⴰⵏ ⴷ ⵉⵎⵓⵔⵉⵢⵢⴻⵏ ⴷ ⵉⵃⵉⵜⵜⵉⵢⵢⴻⵏ ⴷ ⵉⴼⵉⵔⵉⵣⵉⵢⵢⴻⵏ ⴷ ⵉⵃⵉⵡⵉⵢⵢⴻⵏ ⴷ ⵉⵢⵉⴱⵓⵙⵉⵢⵢⴻⵏ ");
INSERT INTO rift_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","ⴷⴻⴳ ⵡⴻⴱⵔⵉⴷ ⵏⵡⴻⵎ ⵖⴰⵔ ⵉⵛⵜ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵉⴼⴻⵢⵢⴹⴻⵏ ⵙ ⵓⵖⵉ ⴷ ⵜⴰⵎⵎⴻⵏⵜ. ⵏⴻⵛⵛ ⵙ ⵉⵎⴰⵏⵜ ⵉⵏⵓ ⵡⴰⵔ ⵜⵜⴳⵉⵄⵄⵉⴷⴻⵖ ⴰⴽⵉⴷⵡⴻⵎ, ⵃⵉⵎⴰ ⵡⴰⵔ ⴽⴻⵏⵏⵉⵡ ⵜᵉⵜⵜⴻⵃⵃⵉⵖ ⴷⴻⴳ ⵡⴻⴱⵔⵉⴷ, ⵎⵉⵏⵣⵉ ⴽⴻⵏⵏⵉⵡ ⴷ ⵉⵊⵊ ⵏ ⵍⴳⴻⵏⵙ ⵉⵇⵙⴻⵃ.” ");
INSERT INTO rift_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","ⵓⵎⵉ ⵉⵙⵍⴰ ⵍⴳⴻⵏⵙ ⴰⵡⴰⵍ-ⴰ ⴰⵄⴻⴼⴼⴰⵏ, ⵛⴻⴹⵏⴻⵏ ⵓⵛⴰ ⵓⵍⴰ ⴷ ⵉⵊⵊ ⵉⴳⴳⴰ ⵄⴰⴷ ⵍⴻⵀⵣⵓⵟ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","ⴰⵇⴰ ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⵉⵏⵉ ⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ: ‘ⴽⴻⵏⵏⵉⵡ ⴷ ⵉⵊⵊ ⵏ ⵍⴳⴻⵏⵙ ⵉⵇⵙⴻⵃ. ⵎⴰⵍⴰ ⴳⴻⵄⵄⴷⴻⵖ ⵊⴰⵔ ⴰⵡⴻⵎ ⵎⵖⵉⵔ ⵉⵊⵊ ⵏ ⵡⴻⵔⵎⴰⵛ, ⴰⴷ ⴽⴻⵏⵏⵉⵡ ⵜⴻⵃⵃⵉⵖ. ⵅⴻⵏⵏⵉ ⵍⴻⵅⵅⵓ ⴽⴽⵙⴻⵎ ⵍⴻⵀⵣⵓⵟ ⵏⵡⴻⵎ, ⴰⵇⴰ ⵏⴻⵛⵛ ⴰⴷ ⵙⵙⵏⴻⵖ ⵎⵉⵏ ⴷ ⴰⵛ ⵖⴰ ⴳⴳⴻⵖ.’” ");
INSERT INTO rift_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","ⴽⴽⵙⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵍⴻⵀⵣⵓⵟ ⵏⵙⴻⵏ ⵣⴻⴳ ⵡⴻⴷⵔⴰⵔ ⵏ ⵀⵓⵔⵉⴱ. ");
INSERT INTO rift_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","ⵉⴽⵙⵉ ⵎⵓⵙⴰ ⴰⵇⵉⴹⵓⵏ ⵓⵛⴰ ⵉⵡⵜⴰ ⴰⵇⵉⴹⵓⵏ ⴱⴰⵔⵔⴰ ⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ, ⵉⴳⴳⵯⴻⵊ ⴰⵟⵟⴰⵙ ⵅ ⵍⵎⴰⵔⴳⴻⵃ, ⵓⵛⴰ ⵉⵍⴰⵖⴰ ⴰⵙ ‘ⴰⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ’. ⴽⵓⵍ ⵉⵊⵊ ⵡⴻⵏⵏⵉ ⵜⵓⵖⴰ ⵢⴰⵔⴻⵣⵣⵓⵏ ⵙⵉⴷⵉ, ⵉⴼⴼⴻⵖ ⵖⴰⵔ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ⵡⴻⵏⵏⵉ ⵉⴵⴰⵏ ⴱⴰⵔⵔⴰ ⵉ ⵍⵎⴰⵔⴳⴻⵃ. ");
INSERT INTO rift_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","ⵓⵎⵉ ⵉⴼⴼⴻⵖ ⵎⵓⵙⴰ ⵖⴰⵔ ⵓⵇⵉⴹⵓⵏ, ⵉⴽⴽⴰⵔ ⵎⴰⵔⵔⴰ ⵍⴳⴻⵏⵙ, ⴱⴻⴷⴷⴻⵏ ⴱⴰⵔⵔⴰ, ⴽⵓⵍ ⵉⵊⵊ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏⵏⴻⵙ, ⵓⵛⴰ ⵏⵉⵜⵏⵉ ⵅⵣⴰⵔⴻⵏ ⵖⴰⵔⴻⵙ ⴰⵎ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵙⴻⵏ ⴹⴻⴼⴼⴰⵔⴻⵏ ⵎⵓⵙⴰ ⴰⵍⴰⵎⵉ ⵢⵓⴷⴻⴼ ⵖⴰⵔ ⵓⵇⵉⴹⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","ⵓⵎⵉ ⵢⵓⴷⴻⴼ ⵎⵓⵙⴰ ⵖⴰⵔ ⵓⵇⵉⴹⵓⵏ, ⴰⵇⴰ ⴰⵇⴻⵍⵍⵉⵊ ⵏ ⵓⵙⴻⵢⵏⵓ ⵉⵀⵡⴰ, ⵉⴱⴻⴷⴷ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵉⵙⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","ⵓⵛⴰ ⵎⴰⵔⵔⴰ ⵍⴳⴻⵏⵙ ⵉⵥⵔⴰ ⴰⵇⴻⵍⵍⵉⵊ ⵏ ⵓⵙⴻⵢⵏⵓ ⵉⴱⴻⴷⴷ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ, ⵅⴻⵏⵏⵉ ⵉⴽⴽⴰⵔ ⵎⴰⵔⵔⴰ ⵍⴳⴻⵏⵙ ⵓⵛⴰ ⵉⴱⴻⵏⴷⴻⵇ ⴽⵓⵍ ⵉⵊⵊ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ ⴰⵖⴻⵎⴱⵓⴱ ⴷⴻⴳ ⵓⵖⴻⵎⴱⵓⴱ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵉⵙⵙⵉⵡⴻⵍ ⴱⵏⴰⴷⴻⵎ ⴰⴽ-ⴷ ⵓⵎⴻⴷⴷⵓⴽⴽⴻⵍ ⵏⵏⴻⵙ. ⵅⴻⵏⵏⵉ ⵉⵄⵇⴻⴱ-ⴷⴷ ⵖⴰⵔ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ, ⵎⴰⵛⴰ ⴰⵎⵙⴻⵅⵅⴰⵔ ⵏⵏⴻⵙ ⵢⴰⵛⵓⵡⴰ, ⵎⵎⵉⵙ ⵏ ⵏⵓⵏ, ⵡⴻⵏⵏⵉ ⵄⴰⴷ ⴷ ⴰⵃⵓⴷⵔⵉ, ⵄⴻⵎⵎⴰⵔⵚ ⵡⴰⵔ ⵉⴱⴻⵄⵄⴻⴷ ⵅ ⵍⵡⴻⵙⵟ ⵏ ⵓⵇⵉⴹⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","ⵉⵏⵏⴰ ⵎⵓⵙⴰ ⵉ ⵙⵉⴷⵉ: “ⵅⵣⴰⵔ, ⵛⴻⴽ ⵜⴻⵏⵏⵉⴷ ⴰⵢⵉ: ‘ⵏⴷⴻⵀ ⵍⴳⴻⵏⵙ-ⴰ!’, ⵎⴰⵛⴰ ⵛⴻⴽ ⵡⴰⵔ ⴷ ⴰⵢⵉ ⵜⴻⵙⵙⴻⵛⵏⴻⴷ ⵡⵉ ⴽⵉⴷⵉ ⵉ ⵖⴰ ⵜⴻⵙⵙⴻⴽⴽⴻⴷ. ⵛⴻⴽ ⵜⴻⵏⵏⵉⴷ: ‘ⵏⴻⵛⵛ ⵙⵙⵏⴻⵖ ⵛⴻⴽ ⵙ ⵢⵉⵙⴻⵎ ⵏⵏⴻⵛ!’ ⵓⵍⴰ: ‘ⵜⵓⴼⵉⴷ ⴰⵔⴹⴰ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵉⵏⵓ!’ ");
INSERT INTO rift_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","ⵍⴻⵅⵅⵓ ⵅⴻⵏⵏⵉ, ⵎⴰⵍⴰ ⵓⴼⵉⵖ ⴰⵔⴹⴰ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵛ, ⵣⴰⵡⴳⴻⵖ ⵛⴻⴽ ⴰⴷ ⴰⵢⵉ ⵜⴻⵙⵙⴻⵛⵏⴻⴷ ⴰⴱⵔⵉⴷ ⵏⵏⴻⵛ, ⵃⵉⵎⴰ ⴰⴷ ⵛⴻⴽ ⵙⵙⵏⴻⵖ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴰⴼⴻⵖ ⴰⵔⴹⴰ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵛ. ⵅⵣⴰⵔ, ⵛⵛⴻⵄⴱ-ⴰ ⴷ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵛ!” ");
INSERT INTO rift_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","ⵉⵏⵏⴰ: “ⵍⵎⴰⵍⴰⴽ ⵏ ⵡⵓⴷⴻⵎ ⵉⵏⵓ ⴰⴷ ⵢⵓⵢⵓⵔ ⴰⴽⵉⴷⴻⴽ ⵓ ⵏⴻⵛⵛ ⴰⴷ ⵛⴻⴽ ⵙⵙⴰⵔⴻⵢⵢⵃⴻⵖ.” ");
INSERT INTO rift_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","ⵅⴻⵏⵏⵉ ⵢⴰⵔⵔⴰ-ⴷⴷ ⵅⴰⵙ: “ⵎⴰⵍⴰ ⵓⴷⴻⵎ ⵏⵏⴻⵛ ⵡⴰⵔ ⴽⵉⴷⵏⴻⵖ ⵉⵜⵜⵔⵉⵃ, ⵡⴰⵔ ⵜⵜⴻⵊⵊⵉ ⵅⴻⵏⵏⵉ ⴰⴷ ⵏⴳⴻⵄⵄⴻⴷ ⵙⵙⴰ! ");
INSERT INTO rift_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","ⵎⴰⵎⵎⴻⵛ ⵖⴰ ⵙⵙⵏⴻⵏ ⴱⴻⵍⵍⵉ ⴰⵇⴰ ⵓⴼⵉⵖ ⴰⵔⴹⴰ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵛ, ⵏⴻⵛⵛ ⴷ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵛ? ⵎⴰ ⵡⴰⵔ ⵉⴵⵉ ⵎⵉⵏⵣⵉ ⵛⴻⴽ ⵜⵔⵓⵃⴻⴷ ⴰⴽⵉⴷⵏⴻⵖ, ⴰⵇⴰ ⵏⴻⵛⵛⵉⵏ, ⵏⴻⵛⵛ ⴷ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵛ, ⵏⴼⴰⵔⵔⴻⵣ ⵅ ⴽⵓⵍ ⵍⴳⴻⵏⵙ ⵉ ⵉⴵⴰⵏ ⵅ ⵡⵓⴷⴻⵎ ⵏ ⵜⴻⵎⵎⵓⵔⵜ?” ");
INSERT INTO rift_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⵄⴰⵡⴻⴷ ⴰⴷ ⴳⴳⴻⵖ ⴰⵡⴰⵍ-ⴰ ⵉ ⵜⴻⵏⵏⵉⴷ ⵓⵎⵉ ⵜⵓⴼⵉⴷ ⴰⵔⴹⴰ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵉⵏⵓ ⵓⵛⴰ ⵙⵙⵏⴻⵖ ⵛⴻⴽ ⵙ ⵢⵉⵙⴻⵎ ⵏⵏⴻⵛ.” ");
INSERT INTO rift_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","ⵅⴰⵙ ⵓⵛⴰ ⵉⵏⵏⴰ ⵎⵓⵙⴰ: “ⵣⴰⵡⴳⴻⵖ ⵛⴻⴽ, ⵙⵛⴻⵏ ⴰⵢⵉ ⴰⵄⵓⴵⵉ ⵏⵏⴻⵛ!” ");
INSERT INTO rift_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","ⵉⵏⵏⴰ: “ⵏⴻⵛⵛ ⴰⴷ ⵙⵙⴻⵄⴷⵓⵖ ⵎⴰⵔⵔⴰ ⵜⵛⵓⵏⵉ ⵉⵏⵓ ⵣⵣⴰⵜⴻⴽ ⵓⵛⴰ ⴰⴷ ⵄⴻⵢⵢⴷⴻⵖ ⵉⵙⴻⵎ ⵏ ⵙⵉⴷⵉ ⵣⵣⴰⵜ ⵉ ⵓⵖⴻⵎⴱⵓⴱ ⵏⵏⴻⵛ ⵓⵛⴰ ⴰⴷ ⵃⵉⵏⵏⴻⵖ ⵅ ⵡⵉ ⵖⴰ ⵃⵉⵏⵏⴻⵖ, ⴰⴷ ⴰⵔⴻⵃⵎⴻⵖ ⵅ ⵡⵉ ⵖⴰ ⴰⵔⴻⵃⵎⴻⵖ.” ");
INSERT INTO rift_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","ⵉⵏⵏⴰ ⵄⴰⵡⴻⴷ: “ⵛⴻⴽ ⵡⴰⵔ ⵜⵣⴻⵎⵎⴰⵔⴻⴷ ⴰⴷ ⵜⵥⴰⵔⴻⴷ ⵓⴷⴻⵎ ⵉⵏⵓ, ⵎⵉⵏⵣⵉ ⵡⴰⵔ ⴷ ⴰⵢⵉ ⵉⵥⴰⵔⵔ ⴱⵏⴰⴷⴻⵎ ⵓⵛⴰ ⴰⴷ ⵉⵇⵇⵉⵎ ⵉⴷⴷⴰⵔ.” ");
INSERT INTO rift_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","ⵅⴰⵙ ⵓⵛⴰ ⵉⵏⵏⴰ ⵙⵉⴷⵉ: “ⵅⵣⴰⵔ, ⵣⵣⴰⵜ ⵉⵏⵓ ⴰⵎⵛⴰⵏ ⵎⴰⵏⵉ ⵖⴰ ⵜⴱⴻⴷⴷⴻⴷ ⵅ ⵜⴻⵚⴹⴰⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","ⵅⵎⵉ ⵖⴰ ⵉⵄⴷⵓ ⵓⵄⵓⴵⵉ ⵉⵏⵓ, ⴰⴷ ⵛⴻⴽ ⴳⴳⴻⵖ ⴷⴻⴳ ⵉⵊⵊ ⵏ ⵓⴼⴻⴵⵉⵇ ⵏ ⵜⴻⵚⴹⴰⵔⵜ ⵓⵛⴰ ⴰⴷ ⵛⴻⴽ ⴷⵍⴻⵖ ⵙ ⵜⵍⴻⵇⵇⴰ ⵏ ⵓⴼⵓⵙ ⵉⵏⵓ ⴰⵍ ⴷⴷ-ⵥⵡⵉⵖ. ");
INSERT INTO rift_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","ⵓ ⵅⵎⵉ ⵖⴰ ⴽⴽⵙⴻⵖ ⴰⴼⵓⵙ ⵉⵏⵓ, ⵅⴻⵏⵏⵉ ⴰⴷ ⴰⵢⵉ ⵜⵥⴰⵔⴻⴷ ⵣⵉ ⴹⴻⴼⴼⴰⵔ, ⵎⴰⵛⴰ ⵡⴰⵔ ⵜⵥⴰⵔⵔⴻⴷ ⵓⴷⴻⵎ ⵉⵏⵓ!” ");
INSERT INTO rift_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","ⵙⵉⴷⵉ ⵉⵏⵏⴰ ⵉ ⵎⵓⵙⴰ: “ⵇⴻⵙⵙ ⵉ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵛ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵍⵡⵉⵃⵉⵏ ⵏ ⵡⴻⵥⵔⵓ ⴰⵎ ⵜⵎⴻⵣⵡⵓⵔⴰ, ⵓⵛⴰ ⵏⴻⵛⵛ ⴰⴷ ⴰⵔⵉⵖ ⵅ ⵜⴻⵍⵡⵉⵃⵉⵏ ⵏⵏⵉ ⴰⵡⴰⵍⴻⵏ ⴷ ⵉⵊⵊⴻⵏ ⵉ ⵜⵓⵖⴰ ⴷⵉ ⵜⴻⵍⵡⵉⵃⵉⵏ ⵜⵉⵎⴻⵣⵡⵓⵔⴰ ⵉ ⵜⴰⵔⵥⵉⴷ. ");
INSERT INTO rift_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","ⵙⴻⵡⵊⴻⴷ ⵉ ⵚⵚⴱⴻⵃ ⵓⵛⴰ ⴳⴻⵄⵄⴻⴷ ⴷⵉ ⵚⵚⴱⴻⵃ ⵖⴰⵔ ⵡⴻⴷⵔⴰⵔ ⵏ ⵙⵉⵏⴰ ⵓⵛⴰ ⴱⴻⴷⴷ ⴷⵉⵏ ⵣⵣⴰⵜⵉ ⵅ ⵜⵇⵉⵛⵛⴻⵜ ⵏ ⵡⴻⴷⵔⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","ⵡⴰⵔ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⵉⴳⴻⵄⵄⴻⴷ ⵓⵍⴰ ⴷ ⵉⵊⵊ ⵏ ⴱⵏⴰⴷⴻⵎ ⴰⴽⵉⴷⴻⴽ, ⵏⵉⵖ ⴰⴷ ⵉⴱⴰⵏ ⵃⴻⴷ ⴷⴻⴳ ⵡⴻⴷⵔⴰⵔ ⴰⵎ ⵉⴽⵎⴻⵍ. ⵓⵍⴰ ⴷ ⵓⴵⵉ ⴷ ⵉⴼⵓⵏⴰⵙⴻⵏ ⴷ ⵜⴼⵓⵏⴰⵙⵉⵏ ⵡⴰⵔ ⵣⴻⵎⵎⴰⵔⴻⵏ ⴰⴷ ⴰⵔⴻⵡⵙⴻⵏ ⵟⵟⴰⵔⴼ ⵉ ⵡⴻⴷⵔⴰⵔ.”    ");
INSERT INTO rift_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","ⵅⴻⵏⵏⵉ ⵉⵇⴻⵙⵙ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵍⵡⵉⵃⵉⵏ ⵏ ⵡⴻⵥⵔⵓ ⴰⵎ ⵜⵎⴻⵣⵡⵓⵔⴰ, ⵓⵛⴰ ⵉⴽⴽⴰⵔ ⵎⵓⵙⴰ ⴷⵉ ⵚⵚⴱⴻⵃ ⵣⵉⵛ ⵓⵛⴰ ⵉⴳⴻⵄⵄⴻⴷ ⵖⴰⵔ ⵡⴻⴷⵔⴰⵔ ⵏ ⵙⵉⵏⴰ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜ ⵉⵡⴻⵚⵚⴰ ⵙⵉⴷⵉ ⵓⵛⴰ ⵢⵉⵡⵉ ⴰⴽⵉⵙ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏⵏⴻⵙ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵍⵡⵉⵃⵉⵏ ⵏ ⵡⴻⵥⵔⵓ. ");
INSERT INTO rift_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","ⵉⵀⵡⴰ-ⴷⴷ ⵙⵉⴷⵉ ⴷⴻⴳ ⵓⵙⴻⵢⵏⵓ, ⵉⴱⴻⴷⴷ ⴰⴽⵉⴷⴻⵙ ⴷⵉⵏ ⵓⵛⴰ ⵉⵍⴰⵖⴰ ⵙ ⵢⵉⵙⴻⵎ ⵏ ‘ⵙⵉⴷⵉ’. ");
INSERT INTO rift_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","ⵉⵥⵡⴰ ⵙⵉⴷⵉ ⵣⵣⴰⵜ ⵉ ⵓⵖⴻⵎⴱⵓⴱ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⵄⴻⵢⵢⴻⴷ: “ⵙⵉⴷⵉ, ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ, ⴷ ⵡⴻⵏⵏⵉ ⵉⵛⵛⵓⵔⴻⵏ ⵙ ⴰⵔⵔⴻⵃⵎⴻⵜ ⴷ ⵜⴻⵃⵏⵓⵏⴻⵛⵜ, ⵖⴰⵔⴻⵙ ⵜⵜⴰⵙⵉⵄ ⵏ ⵍⵅⴰⴹⴰⵔ, ⴷⴰⵢⴻⵙ ⴰⵟⵟⴰⵙ ⵏ ⵜⵎⴻⵅⵙⵉⵡⵜ ⵉⵛⴻⵡⵡⴰⵔⴻⵏ ⴷ ⵍⴰⵎⴰⵏ, ");
INSERT INTO rift_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","ⴷ ⵡⴻⵏⵏⵉ ⵉⵃⴻⵟⵟⴰⵏ ⵜⴰⵎⴻⵅⵙⵉⵡⵜ ⵏⵏⴻⵙ ⵉⵛⴻⵡⵡⴰⵔⴻⵏ ⵉ ⵍⵓⵍⵓⴼ, ⴷ ⵡⴻⵏⵏⵉ ⵉⵖⴻⴼⴼⴰⵔⴻⵏ ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ ⴷ ⵅⴻⵟⵟⵓ ⴷ ⴷⴷⵏⵓⴱ, ⴷ ⵡⴻⵏⵏⵉ ⵡⴰⵔ ⵉⵜⵜⴱⴰⵔⵔⵉⵏ ⵡⴻⵏⵏⵉ ⵉⵜⵜⴻⴳⴳⴻⵏ ⴷⴷⴻⵏⴱ, ⴷ ⵡⴻⵏⵏⵉ ⴷⴷ-ⵢⴰⵔⴻⵣⴼⴻⵏ ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⴷⴻⴳ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵓ ⴷⴻⴳ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵙⴻⵏ ⴰⵍ ⵊⵊⵉⵍ ⵡⵉⵙⵙ ⵜⵍⴰⵜⴰ ⴷ ⵡⵉⵙⵙ ⴰⵔⴻⴱⵄⴰ.” ");
INSERT INTO rift_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","ⵎⵓⵙⴰ ⵢⵓⴹⴰⵔ ⵙ ⵡⵓⴷⴻⵎ ⵏⵏⴻⵙ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵓⵛⴰ ⵉⴱⴻⵏⴷⴻⵇ. ");
INSERT INTO rift_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","ⵉⵏⵏⴰ: “ⴰ ⵙⵉⴷⵉ ⵉⵏⵓ, ⵎⴰⵍⴰ ⵓⴼⵉⵖ ⵅⴻⵏⵏⵉ ⴰⵔⴹⴰ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵛ, ⴰⴷ ⵢⵓⵢⵓⵔ ⵅⴻⵏⵏⵉ ⵙⵉⴷⵉ ⵉⵏⵓ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏⵏⴻⵖ, ⵎⵉⵏⵣⵉ ⵍⴳⴻⵏⵙ ⵉⵇⵙⴻⵃ. ⵖⴼⴰⵔ ⴰⵏⴻⵖ ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ ⵏⵏⴻⵖ ⵓ ⵇⴱⴻⵍ ⴰⵏⴻⵖ ⴷ ⵍⵡⴰⵔⵜ ⵏⵏⴻⵛ!” ");
INSERT INTO rift_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","ⵏⴻⵜⵜⴰ ⵉⵏⵏⴰ: “ⵅⵣⴰⵔ, ⵏⴻⵛⵛ ⴰⴷ ⴳⴳⴻⵖ ⵍⵄⴰⵀⴷ. ⵣⵣⴰⵜ ⵉ ⵎⴰⵔⵔⴰ ⵍⴳⴻⵏⵙ ⵏⵏⴻⴽ, ⴰⴷ ⴳⴳⴻⵖ ⵍⴻⵄⵊⴰⵢⴻⴱ ⵡⴰⵔ ⵉⵜⵜⵡⴰⴳⴳⴻⵏ ⵛⴰ ⴷⵉ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵓ ⵊⴰⵔ ⵎⴰⵔⵔⴰ ⵍⴻⴳⵏⵓⵙ, ⴰⵍⴰⵎⵉ ⵎⴰⵔⵔⴰ ⵍⴳⴻⵏⵙ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏⵏⴻⵙ ⵉ ⵣⵉ ⵜⴻⴵⵉⴷ, ⴰⴷ ⵉⵥⴰⵔ ⵎⵉⵏ ⵉⴳⴳⴰ ⵙⵉⴷⵉ, ⵎⵉⵏⵣⵉ ⵎⵉⵏ ⵖⴰ ⴳⴳⴻⵖ ⴰⴽⵉⴷⴻⴽ ⴰⴷ ⵉⵙⵙⴻⴳⴳⵯⴻⴷ ⴰⵟⵟⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","ⵃⴹⴰ ⵎⵉⵏ ⵅ ⵛⴻⴽ ⵡⴻⵚⵚⵉⵖ ⴰⵙⵙ-ⴰ! ⵅⵣⴰⵔ, ⴰⴷ ⴰⵥⵥⵍⴻⵖ ⵣⵣⴰⵜ ⵉ ⵓⵖⴻⵎⴱⵓⴱ ⵏⵏⴻⵛ ⵅ ⵉⵎⵓⵔⵉⵢⵢⴻⵏ ⴷ ⴰⵢⵜ ⵏ ⴽⴻⵏⵄⴰⵏ ⴷ ⵉⵃⵉⵜⵜⵉⵢⵢⴻⵏ ⴷ ⵉⴼⵉⵔⵉⵣⵉⵢⵢⴻⵏ ⴷ ⵉⵃⵉⵡⵉⵢⵢⴻⵏ ⴷ ⵉⵢⵉⴱⵓⵙⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","ⵖⴰⵔⴻⴽ ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵍⵄⴰⵀⴷ ⴰⴽ-ⴷ ⵓⵎⴻⵣⴷⵓⵖ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵎⴰⵏⵉ ⵖⴰ ⵜⴰⴷⴼⴻⴷ, ⵃⵉⵎⴰ ⵏⴻⵜⵜⴰ ⵡⴰⵔ ⴷ ⴰⵛ ⵉⵜⵜⵉⵍⵉ ⴷ ⵍⴼⴻⵅ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⵡⴻⵎ ⴰⴷ ⵜⵖⴻⴹⵍⴻⵎ ⵉⵄⴰⵍⵟⴰⵔⴻⵏ ⵏⵙⴻⵏ ⵓ ⴰⴷ ⵜⴰⵔⵥⴰⵎ ⵉⵎⴰⵢⴹⵓⵜⴻⵏ ⵏⵙⴻⵏ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵓ ⴰⴷ ⵜⵀⴻⴷⵎⴻⵎ ⵜⵉⵔⴻⴱⴱⵉⵏ ⵏⵙⴻⵏ ⵏ ⵛⵡⴰⵔⵜⵉ. ");
INSERT INTO rift_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","ⵡⴰⵔ ⵜⵜⴱⴻⵏⴷⵉⵇ ⵉ ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵖⵏⵉ, ⵎⵉⵏⵣⵉ ⵙⵉⴷⵉ, ⵡⴻⵏⵏⵉ ⵓⵎⵉ ⵇⵇⴰⵔⴻⵏ ‘ⴰⵏⴻⵙⵙⴰⵎ’, ⴰⵇⴰ-ⵜ ⴷ ⵉⵊⵊ ⵏ ⴰⵔⴻⴱⴱⵉ ⵉⵜⵜⴰⵙⵎⴻⵏ.    ");
INSERT INTO rift_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","ⵖⴰⵔⴻⴽ ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵍⵄⴰⵀⴷ ⴰⴽ-ⴷ ⵉⵎⴻⵣⴷⴰⵖ ⵏ ⵜⴻⵎⵎⵓⵔⵜ, ⵓⵛⴰ ⵅⴻⵏⵏⵉ ⴰⴷ ⵙⵙⴼⴻⵙⴷⴻⵏ ⵏⵉⵜⵏⵉ ⵉⵅⴻⴼ ⵏⵙⴻⵏ ⵓⵎⵉ ⵖⴰ ⴷⴻⵡⵍⴻⵏ ⴰⵡⴰⵔⵏⵉ ⵉ ⵉⵔⴻⴱⴱⵉⵜⴻⵏ ⵏⵙⴻⵏ, ⴰⴷ ⵇⴻⴷⴷⵎⴻⵏ ⵜⵉⵖⴰⵔⵚⴰ ⵉ ⵉⵔⴻⴱⴱⵉⵜⴻⵏ ⵏⵙⴻⵏ, ⵓⵛⴰ ⴰⴷ ⵛⴻⴽ ⵄⴰⵔⴹⴻⵏ ⵉ ⵎⴰⵛⵛⴰ ⵏ ⵜⵖⴰⵔⵚⴰ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","ⴰⴷ ⵜⴻⴽⵙⵉⴷ ⵜⵉⵃⴻⵏⵊⵉⵔⵉⵏ ⵏⵙⴻⵏ ⴷ ⵜⵉⵎⵖⴰⵔⵉⵏ ⵉ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵛ, ⵎⴰⵛⴰ ⴰⴷ ⵙⵙⴼⴻⵙⴷⴻⵏⵜ ⵜⵃⴻⵏⵊⵉⵔⵉⵏ ⵏⵙⴻⵏ ⵉⵅⴻⴼ ⵏⵙⴻⵏⵜ ⵓⵎⵉ ⵖⴰ ⴷⴻⵡⵍⴻⵏ ⴰⵡⴰⵔⵏⵉ ⵉ ⵉⵔⴻⴱⴱⵉⵜⴻⵏ ⵏⵙⴻⵏⵜ ⵓⵛⴰ ⴰⴷ ⴰⵔⵔⴻⵏⵜ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵛ ⴰⴷ ⴷⴻⵡⵍⴻⵏ ⴰⵡⴰⵔⵏⵉ ⵉ ⵉⵔⴻⴱⴱⵉⵜⴻⵏ ⵏⵙⴻⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","ⵡⴰⵔ ⵜⵜⴻⴳⴳ ⵉ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵛ ⵉⵔⴻⴱⴱⵉⵜⵜⴻⵏ ⵏ ⵓⴼⴻⵙⵙⴰⵢ. ");
INSERT INTO rift_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","ⴰⴷ ⵜⴻⵃⴹⵉⴹ ⵍⵄⵉⴷ ⵏ ⵡⴻⵖⵔⵓⵎ ⴱⵍⴰ ⴰⵏⵜⵓⵏ: ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⴰⴷ ⵜⴻⵛⵛⴻⴷ ⴰⵖⵔⵓⵎ ⴱⵍⴰ ⴰⵏⵜⵓⵏ, ⴷⵉ ⵍⵡⴻⵇⵜ ⵉⵜⵜⵡⴰⴳⴳⴻⵏ ⴷⴻⴳ ⵓⵢⵓⵔ ⴰⴱⵉⴱ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵛⴻⴽ ⵡⴻⵚⵚⵉⵖ, ⵎⵉⵏⵣⵉ ⴷⴻⴳ ⵓⵢⵓⵔ ⴰⴱⵉⴱ ⵉ ⴷⴷ-ⵜⴻⴼⴼⵖⴻⴷ ⵣⵉ ⵎⵉⵚⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵢⴰⵔⴻⵣⵣⵎⴻⵏ ⵍⴻⵎⵍⴰⵡⴻⵜ ⴷ ⴰⵎⴻⵣⵡⴰⵔⵓ ⵉⵏⵓ, ⵎⴰⵔⵔⴰ ⵉⵡⴻⵜⵎⴰⵏ ⵏ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏⵏⴻⵛ ⵉ ⵖⴰ ⵢⴰⵔⵣⵣⵎⴻⵏ ⵍⴻⵎⵍⴰⵡⴻⵜ ⴷ ⴰⵎⴻⵣⵡⴰⵔⵓ, ⴰⵎ ⵡⴻⵏⵏⵉ ⵏ ⵓⴼⵓⵏⴰⵙ, ⴰⵎ ⵡⴻⵏⵏⵉ ⵏ ⵡⵓⴵⵉ. ");
INSERT INTO rift_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","ⵎⴰⵍⴰ ⴰⵎⴻⵏⵣⵓ ⵏ ⵡⴻⵖⵢⵓⵍ ⵢⴰⵔⵣⴻⵎ ⵍⴻⵎⵍⴰⵡⵔⴰⵜ ⴷ ⴰⵎⴻⵣⵡⴰⵔⵓ, ⴰⴷ ⵜ ⵜⴻⴼⴷⵉⴷ ⵙ ⵢⵉⵊⵊ ⵣⴻⴳ ⵡⵓⴵⵉ. ⵎⴰⵍⴰ ⵡⴰⵔ ⵜ ⵜⴻⴼⴷⵉⴷ, ⴰⴷ ⴰⵙ ⵜⴰⵔⵥⴻⴷ ⵉⵔⵉ. ⴰⴷ ⵜⴻⴼⴷⵉⴷ ⵎⴰⵔⵔⴰ ⵉⵎⴻⵏⵣⴰ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵛ. ⵡⴰⵔ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⴹⵀⴰⵔⴻⵏ ⵙ ⵉⴼⴰⵙⵙⴻⵏ ⵅⵡⴰⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵉⵏⵓ. ");
INSERT INTO rift_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","ⵙⴻⵜⵜⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⴰⴷ ⵜⵅⴻⴷⵎⴻⴷ, ⵎⴰⵛⴰ ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ ⴰⴷ ⵜⴰⵔⴻⵢⵢⵃⴻⴷ. ⵓⵍⴰ ⴷⵉ ⵍⵡⴻⵇⵜ ⵏ ⵜⵢⴰⵔⵣⴰ ⴷ ⵜⵎⴻⵢⵔⴰ ⴰⴷ ⵜⴰⵔⴻⵢⵢⵃⴻⴷ. ");
INSERT INTO rift_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵍⵄⵉⴷ ⵏ ⵙⵉⵎⴰⵏⴰⵜ, ⴰⵇⴰ-ⵜ ⴷ ⵍⵄⵉⴷ ⵏ ⵜⵎⴻⵏⵣⵓⵜ ⵏ ⵜⵎⴻⵢⵔⴰ ⵏ ⵢⵉⵔⴷⴻⵏ, ⵓⵍⴰ ⴷ ⵍⵄⵉⴷ ⵏ ⵓⵙⵎⵓⵏⵉ ⵖⴰⵔ ⵓⵏⴻⴳⴳⴰⵔ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","ⴽⵓⵍ ⴰⵔⵢⴰⵣ ⴰⴷ ⴷⴷ-ⵉⴱⴰⵏ ⵜⵍⴰⵜⴰ ⵏ ⵜⵡⴰⵍⴰⵡⵉⵏ ⴷⴻⴳ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ, ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏ ⵉⵙⵔⴰⵉⵍ, ");
INSERT INTO rift_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","ⵎⵉⵏⵣⵉ ⵣⵣⴰⵜ ⵉ ⵓⵖⴻⵎⴱⵓⴱ ⵏⵏⴻⵛ ⴰⴷ ⴽⴽⵙⴻⵖ ⵜⴰⵙⵖⴰⵔⵜ ⵏ ⵍⵡⴰⵔⵜ ⵅ ⵍⴻⴳⵏⵓⵙ ⵓⵛⴰ ⴰⴷ ⵙⵙⵡⴻⵙⵄⴻⵖ ⵉⵢⵎⵉⵔⴻⵏ ⵏⵏⴻⵛ ⵓⵛⴰ ⵓⵍⴰ ⴷ ⵉⵊⵊⴻⵏ ⴰⴷ ⵉⵎⵎⴻⵥⵔⵉ ⴰⴷ ⵢⴰⵛⴰⵔ ⵜⴰⵎⵎⵓⵔⵜ ⵏⵏⴻⵛ, ⵅⵎⵉ ⵖⴰ ⵜⴳⴻⵄⵄⴷⴻⴷ ⵜⵍⴰⵜⴰ ⵏ ⵜⵡⴰⵍⴰⵡⵉⵏ ⴷⴻⴳ ⵓⵙⴻⴳⴳⵯⴰⵙ, ⵃⵉⵎⴰ ⴰⴷ ⵜⴱⴰⵏⴻⴷ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","ⵡⴰⵔ ⵜⵜⵇⴻⴷⴷⴻⵎ ⵉⴷⴰⵎⵎⴻⵏ ⵏ ⵜⵖⴰⵔⵚⵜ ⵉⵏⵓ ⴰⴽ-ⴷ ⵎⵉⵏ ⵉⵅⴻⵎⵎⴰⵔⴻⵏ. ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵍⵄⵉⴷ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵓⵙⴻⵄⴷⵓ ⵡⴰⵔ ⵜⵜⵏⵓⵙⵉ ⴵⵉⵍⴻⵜ ⴰⵍ ⵚⵚⴱⴻⵃ. ");
INSERT INTO rift_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","ⵜⴰⵎⴻⵣⵡⴰⵔⵓⵜ ⵏ ⵜⵎⴻⵏⵣⵓⵜ ⵏ ⵡⵓⴷⴻⵎ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⴻⵛ ⴰⴷ ⵜⵜ-ⵉ-ⴷⴷ-ⵜⴰⵡⵢⴻⴷ ⵖⴰⵔ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵛ. ⵡⴰⵔ ⵙⵏⴻⵏⵏⵉ ⵉⵖⴰⵢⴹ ⴷ ⴰⵎⴻⵥⵢⴰⵏ ⵙ ⵓⵖⵉ ⵏ ⵢⴻⵎⵎⴰⵙ.” ");
INSERT INTO rift_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⴰⵔⵉ ⴰⵡⴰⵍⴻⵏ-ⴰ ⵉ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵛ, ⵎⵉⵏⵣⵉ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵇⵇⴰⵔⴻⵏ ⵡⴰⵡⴰⵍⴻⵏ-ⴰ, ⴰⵇⴰ ⴳⴳⵉⵖ ⵍⵄⴰⵀⴷ ⴰⴽⵉⴷⴻⴽ ⵓ ⴰⴽ-ⴷ ⵉⵙⵔⴰⵉⵍ.” ");
INSERT INTO rift_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","ⵓⵛⴰ ⵎⵓⵙⴰ ⵜⵓⵖⴰ ⴷⵉⵏ ⴰⴽ-ⴷ ⵙⵉⴷⵉ ⴰⵔⴻⴱⵄⵉⵏ ⵏ ⵡⵓⵙⵙⴰⵏ ⴷ ⴰⵔⴻⴱⵄⵉⵏ ⵏ ⴵⵢⴰⵍⵉ. ⵡⴰⵔ ⵉⵛⵛⵉ ⴰⵖⵔⵓⵎ ⵏⵉⵖ ⵉⵙⵡⴰ ⴰⵎⴰⵏ. ⵓⵛⴰ ⵢⵓⵔⴰ ⴷⵉ ⵜⴻⵍⵡⵉⵃⵉⵏ ⴰⵡⴰⵍⴻⵏ ⵏ ⵍⵄⴰⵀⴷ, ⵄⴻⵛⵔⴰ ⵏ ⵡⴰⵡⴰⵍⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","ⵍⴰⵎⵉ ⴷⴷ-ⵉⵀⵡⴰ ⵎⵓⵙⴰ ⵣⴻⴳ ⵡⴻⴷⵔⴰⵔ ⵏ ⵙⵉⵏⴰ, ⴰⵎ ⵜⵓⵖⴰ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵍⵡⵉⵃⵉⵏ ⵏ ⵛⵛⵀⴰⴷⴻⵜ ⴷⴻⴳ ⵉⴼⴰⵙⵙⴻⵏ ⵏ ⵎⵓⵙⴰ ⴰⵎ ⴷⴷ-ⵉⵀⵡⴰ ⵣⴻⴳ ⵡⴻⴷⵔⴰⵔ, ⵉⵎⵙⴰⵔ ⴰⵇⴰ ⵡⴰⵔ ⵉⵙⵙⵉⵏ ⵎⵓⵙⴰ ⴱⴻⵍⵍⵉ ⵜⵉⵍⵎⴻⵛⵜ ⵏ ⵓⵖⴻⵎⴱⵓⴱ ⵏⵏⴻⵙ ⵜⴰⵔⴻⵇⵇ ⵎⵉⵏⵣⵉ ⵜⵓⵖⴰ ⴰⴽⵉⴷⴻⵙ ⵉⵙⵙⴰⵡⴰⵍ. ");
INSERT INTO rift_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","ⵀⴰⵔⵓⵏ ⴷ ⵎⴰⵔⵔⴰ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵚⴻⵡⴹⴻⵏ ⵖⴰⵔ ⵎⵓⵙⴰ, ⵓ ⵅⵣⴰⵔ, ⵜⵉⵍⵎⴻⵛⵜ ⵏ ⵡⵓⴷⴻⵎ ⵏⵏⴻⵙ ⵜⵓⵖⴰ ⵜⴰⵔⴻⵇⵇ, ⴳⴳⵯⴻⴷⴻⵏ ⴰⴷ ⵖⴰⵔⴻⵙ ⴷⴷ-ⵇⴰⵔⵔⴱⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","ⵉⵍⴰⵖⴰ-ⴷⴷ ⵅⴰⵙⴻⵏ ⵎⵓⵙⴰ ⵓⵛⴰ ⵉⴷⵡⴻⵍ-ⴷⴷ ⵀⴰⵔⵓⵏ ⴷ ⵎⴰⵔⵔⴰ ⵍⵃⵓⴽⴽⴰⵎ ⵏ ⵜⵎⴻⵙⵎⵓⵏⵜ ⵖⴰⵔⴻⵙ ⵓⵛⴰ ⵉⵙⵙⵉⵡⴻⵍ ⵎⵓⵙⴰ ⴰⴽⵉⴷⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","ⴰⵡⴰⵔⵏⵉ ⴰⵙ ⵇⴰⵔⵔⴱⴻⵏ-ⴷⴷ ⵎⴰⵔⵔⴰ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵢⵓⵎⵓⵔ ⵉ-ⵜⴻⵏ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵅⴻⴼ ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽⵉⴷⴻⵙ ⴷⴻⴳ ⵡⴻⴷⵔⴰⵔ ⵏ ⵙⵉⵏⴰ. ");
INSERT INTO rift_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","ⵍⴰⵎⵉ ⵉⴽⴻⵎⵎⴻⵍ ⵎⵓⵙⴰ ⴰⵡⴰⵍ ⵏⵏⴻⵙ ⴰⴽⵉⴷⵙⴻⵏ, ⵉⴳⴳⴰ ⴰⵍⴻⵃⵃⴰⴼ ⵅ ⵡⵓⴷⴻⵎ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","ⵅⵎⵉ ⵉ ⵖⴰ ⵢⵉⵍⵉ ⵎⵓⵙⴰ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⵃⵉⵎⴰ ⴰⴷ ⴽⵉⴷⴻⵙ ⵉⵙⵙⵉⵡⴻⵍ, ⵉⴽⴽⴻⵙ ⴰⵍⴻⵃⵃⴰⴼ, ⴰⵍ ⴷⴷ-ⵉⴼⴼⴻⵖ ⵄⴰⵡⴻⴷ. ⵓ ⵍⴰⵎⵉ ⴷⴷ-ⵉⴼⴼⴻⵖ ⵖⴰⵔ ⴱⴰⵔⵔⴰ, ⵉⵙⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵎⵉⵏ ⴷ ⴰⵙ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","ⵓⵛⴰ ⵥⵔⵉⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴰⵖⴻⵎⴱⵓⴱ ⵏ ⵎⵓⵙⴰ, ⴰⵇⴰ ⵜⵉⵍⵎⴻⵛⵜ ⵏ ⵡⵓⴷⴻⵎ ⵏⵏⴻⵙ ⵜⴰⵔⴻⵇⵇ, ⵅⴻⵏⵏⵉ ⵢⴰⵔⵔⴰ ⵎⵓⵙⴰ ⴰⵍⴻⵃⵃⴰⴼ ⵅ ⵡⵓⴷⴻⵎ ⵏⵏⴻⵙ, ⴰⵍ ⴷⴷ-ⵢⵓⴷⴻⴼ ⵄⴰⵡⴻⴷ, ⵃⵉⵎⴰ ⴰⴽⵉⴷⴻⵙ ⵉⵙⵙⵉⵡⴻⵍ. ");
INSERT INTO rift_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","ⵎⵓⵙⴰ ⵉⵙⵙⵎⵓⵏ ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵛⴰ ⵉⵏⵏⴰ ⴰⵙⴻⵏ: “ⵉⵏⴰ ⴷ ⴰⵡⴰⵍⴻⵏ ⵏⵏⵉ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ, ⵃⵉⵎⴰ ⴰⴷ ⵜⴻⵏ ⵜⴻⴳⴳⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","ⵙⴻⵜⵜⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵍⵅⴻⴷⵎⴻⵜ ⵓ ⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ ⴰⴷ ⴰⵡⴻⵎ ⵢⵉⵍⵉ ⵉⵇⴻⴷⴷⴻⵙ, ⴰⵇⴰ ⴷ ⵙⵙⴻⴱⵜ, ⴰⵔⵔⴰⵃⴻⵜ ⵜⵎⵓⵏ ⵉ ⵙⵉⴷⵉ. ⴽⵓⵍ ⵉⵊⵊ, ⵡⴻⵏⵏⵉ ⴷⴰⵢⴻⵙ ⵉⴳⴳⵉⵏ ⵛⴰ ⵏ ⵍⵅⴻⴷⵎⴻⵜ, ⴰⴷ ⵉⵜⵜⵡⴰⵏⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","ⵡⴰⵔ ⵜⴻⵙⵙⵔⵓⵖⵉⵎ ⴽⴻⵏⵏⵉⵡ ⵜⵉⵎⴻⵙⵙⵉ ⴷⵉ ⵎⴰⵔⵔⴰ ⵜⵉⵣⴻⴷⴷⵉⵖⵉⵏ ⵏⵡⴻⵎ ⴷⴻⴳ ⵡⴰⵙⵙ ⵏ ⵙⵙⴻⴱⵜ.” ");
INSERT INTO rift_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","ⵉⵙⵙⵉⵡⴻⵍ ⵎⵓⵙⴰ ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵉⵏⵏⴰ: “ⴷ ⵡⴰ ⴷ ⵎⵉⵏ ⵉⵡⴻⵚⵚⴰ ⵙⵉⴷⵉ, ⵓⵎⵉ ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","‘ⴽⵙⵉⵎ ⵣⵉ ⵎⵉⵏ ⵖⴰⵔⵡⴻⵎ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵓⵙⴳⴻⵄⵄⴻⴷ ⵉ ⵙⵉⴷⵉ. ⴽⵓⵍ ⵉⵊⵊ, ⵡⴻⵏⵏⵉ ⵓⵎⵉ ⵢⴻⵏⵏⵓⵔⵣⴻⵎ ⵡⵓⵍ ⵏⵏⴻⵙ, ⴰⴷ ⵜⵜ ⵢⴰⵡⵉ, ⴰⵇⴰ-ⵜⵜ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵓⵙⴳⴻⵄⵄⴻⴷ ⵉ ⵙⵉⴷⵉ: ⵓⵔⴻⵖ ⴷ ⵏⵏⵓⵇⴰⵔⵜ ⴷ ⵏⵏⵃⴰⵙ, ");
INSERT INTO rift_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ⴰⴼⵉⵍⵓ ⴰⴷⴻⵃⵎⵉ ⴷ ⵓⵔⵊⵓⵡⴰⵏⵉ ⴷ ⵓⵣⴻⴳⴳⵯⴰⵖ ⵉⵃⴻⴷⵇⴻⵏ ⴷ ⵍⴻⵇⵟⴻⵏ ⴰⵣⴷⴰⴷ ⴷ ⵛⵛⵄⴰⵔ ⵏ ⵉⵖⴰⵢⴹⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ⵉⵍⵎⴰⵡⴻⵏ ⵉⵣⴻⴳⴳⵯⴰⵖⴻⵏ ⵏ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ ⴷ ⵉⵍⵎⴰⵡⴻⵏ ⵏ ⴷⴷⴻⵏⴼⵉⵍⴰⵜ ⴷ ⵓⴽⴻⵛⵛⵓⴹ ⵏ ⵓⴽⴰⵙⵉⵢⴰ, ");
INSERT INTO rift_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","ⵣⵣⴻⵛⵜ ⵉ ⵜⴼⴰⵡⵜ, ⵍⴻⵄⵟⵓⵔ ⵉ ⵣⵣⴻⵛⵜ ⵏ ⵡⴻⴷⵀⴰⵏ ⵓ ⵉ ⵍⴻⴱⵅⵓⵔ ⵉⵜⵜⴼⵓⵃⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ⵉⵥⵔⴰ ⵏ ⵓⵏⵉⴽⵙ ⴷ ⵉⵥⵔⴰ ⵉⵖⵍⴰⵏ ⵏⵏⴻⵖⵏⵉ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⴻⵏ ⴳⴳⴻⵏ ⵅ ⵓⴱⴰⵍⵟⵓ ⵓ ⵅ ⵜⴻⵊⵎⴻⵛⵜ. ");
INSERT INTO rift_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","ⵎⴰⵔⵔⴰ ⵉⵏⵏⵉ ⵉⴵⴰⵏ ⵊⴰⵔ ⴰⵡⴻⵎ ⵙ ⵡⵓⵍ ⴷ ⴰⵎⵉⵖⵉⵙ, ⴰⴷ ⴷⴷ-ⴰⵙⴻⵏ ⴰⴷ ⴳⴳⴻⵏ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ: ");
INSERT INTO rift_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","ⵜⴰⵣⴻⴷⴷⵉⵖⵜ, ⴰⵇⵉⴹⵓⵏ ⵏⵏⴻⵙ ⴷ ⵜⵙⴻⵇⵇⴰⴼⵜ ⵏⵏⴻⵙ ⴷ ⵜⵙⴻⵏⵏⴰⵔⵉⵏ ⵏⵏⴻⵙ ⴷ ⵜⴼⴻⵍⵡⵉⵏ ⵏⵏⴻⵙ ⴷ ⵜⵃⴻⵏⵢⴰ ⵏⵏⴻⵙ ⵏ ⵓⵄⴰⵔⵔⴻⴹ ⴷ ⵉⴱⵉⵍⴰⵔⴻⵏ ⵏⵏⴻⵙ ⴷ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵏⵏⴻⵙ, ");
INSERT INTO rift_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","ⴷ ⵜⵜⴰⴱⵓⵜ ⴰⴽ-ⴷ ⵉⵄⵓⵎⴰⴷ ⵏⵏⴻⵙ ⵉ ⵜⴰⵔⴻⴱⴱⵓⵜ ⴷ ⵜⵇⴻⴱⴱⴰⵔⵜ ⵏ ⵡⴻⵚⵍⴰⵃ ⴷ ⵓⵍⴻⵃⵃⴰⴼ ⵉ ⴷⴷⵓⵔⵉ, ");
INSERT INTO rift_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","ⴷ ⵜⵣⴻⵡⴹⴰ ⴰⴽ-ⴷ ⵉⵄⵓⵎⴰⴷ ⵏⵏⴻⵙ ⵉ ⵜⴰⵔⴻⴱⴱⵓⵜ ⴷ ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ ⵏⵏⴻⵙ ⴷ ⵡⴻⵖⵔⵓⵎ ⵏ ⵡⴻⵙⵛⴰⵏ, ");
INSERT INTO rift_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","ⴷ ⵍⵇⴻⵏⴷⵉⵍ ⵉ ⵜⴼⴰⵡⵜ ⴷ ⵍⴻⵇⵛⵓⵄ ⵏⵏⴻⵙ ⴷ ⵜⴻⴼⵜⵉⵍⵉⵏ ⵏⵏⴻⵙ ⴷ ⵣⵣⴻⵛⵜ ⵉ ⵜⴼⴰⵡⵜ ");
INSERT INTO rift_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ⴷ ⵓⵄⴰⵍⵟⴰⵔ ⵏ ⵍⴻⴱⵅⵓⵔ ⴰⴽ-ⴷ ⵉⵄⵓⵎⴰⴷ ⵏⵏⴻⵙ ⵉ ⵜⴰⵔⴻⴱⴱⵓⵜ ⴷ ⵣⵣⴻⵛⵜ ⵉ ⵡⴻⴷⵀⴰⵏ ⴷ ⵍⴻⴱⵅⵓⵔ ⵉⵜⵜⴼⵓⵃⴻⵏ ⴷ ⴰⵔⵡⴰⵇ ⵏ ⵡⴰⴷⴰⴼ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ, ");
INSERT INTO rift_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ⴷ ⵓⵄⴰⵍⵟⴰⵔ ⵏ ⵡⴻⵛⵎⴰⴹ ⴷ ⵜⵔⴰⵛⵛⴰ ⵏⵏⴻⵙ ⵏ ⵏⵏⵃⴰⵙ ⴷ ⵉⵄⵓⵎⴰⴷ ⵏⵏⴻⵙ ⵉ ⵜⴰⵔⴻⴱⴱⵓⵜ ⴷ ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ ⵏⵏⴻⵙ ⴷ ⵜⴱⴰⵏⵢⵓⵜ ⵙ ⵓⴹⴰⵔ ⵏⵏⴻⵙ, ");
INSERT INTO rift_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","ⴷ ⵍⵉⵣⴰⵔⴰⵜ ⵏ ⵍⴻⵎⵔⴰⵃ, ⵉⴱⵉⵍⴰⵔⴻⵏ ⵏⵏⴻⵙ ⴰⴽ-ⴷ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵏⵙⴻⵏ ⴷ ⴰⵔⵡⴰⵇ ⵉ ⵡⴰⴷⴰⴼ ⵏ ⵍⴻⵎⵔⴰⵃ, ");
INSERT INTO rift_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","ⴷ ⵍⴻⵡⵜⴰⴷ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ ⴷ ⵍⴻⵡⵜⴰⴷ ⵏ ⵍⴻⵎⵔⴰⵃ ⴷ ⵉⴼⵉⵍⴰⵏ ⵏⵙⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","ⴰⵔⵔⵓⴹ ⵉ ⵍⵅⴻⴷⵎⴻⵜ ⴷⴻⴳ ⵓⵇⴻⴷⴷⴰⵙ, ⴰⵔⵔⵓⴹ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵏ ⵓⴽⴻⵀⵀⴰⵏ ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⵓⴹ ⵏ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵅⴻⴷⵎⴻⵏ ⴰⵎ ⵢⵉⴽⴻⵀⵀⴰⵏⴻⵏ.’” ");
INSERT INTO rift_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","ⵅⴻⵏⵏⵉ ⴼⴼⵖⴻⵏ ⵏⵉⵜⵏⵉ, ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⴳⴳⵯⴻⵊⴻⵏ ⵣⵉ ⵣⵣⴰⵜ ⵏ ⵓⵖⴻⵎⴱⵓⴱ ⵏ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","ⵅⴻⵏⵏⵉ ⵢⵓⵙⴰ-ⴷⴷ ⴽⵓⵍ ⵉⵊⵊ, ⵡⴻⵏⵏⵉ ⵓⵎⵉ ⵉⵏⵀⴻⵣⵣ ⵡⵓⵍ ⵏⵏⴻⵙ, ⵓ ⵎⴰⵔⵔⴰ ⵡⴻⵏⵏⵉ ⵓⵎⵉ ⵉⵏⵏⵓⵔⵣⴻⵎ ⴱⵓⵃⴱⴻⵍ ⵏⵏⴻⵙ, ⵓⵛⴰ ⵉⵡⵢⴻⵏ-ⴷⴷ ⵏⵉⵜⵏⵉ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵓⵙⴳⴻⵄⵄⴻⴷ, ⵜⴻⵏⵏⵉ ⵙⵙⴳⴻⵄⵄⴷⴻⵏ ⵏⵉⵜⵏⵉ ⵖⴰⵔ ⵙⵉⴷⵉ, ⴷ ⵜⴻⵏⵏⵉ ⵉ ⵖⴰ ⵢⵉⵍⵉⵏ ⵉ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⵓ ⵉ ⵜⵙⴻⵅⵅⴰⵔⵜ ⵉ ⴷⴰⵢⴻⵙ ⵓ ⵉ ⵡⴰⵔⵔⵓⴹ ⵉⵇⴻⴷⴷⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","ⴰⵎⵎⵓ ⴷⴷ-ⵓⵙⵉⵏ ⵉⵔⵢⴰⵣⴻⵏ ⵊⵎⵉⵄ ⴰⴽ-ⴷ ⵜⴻⵎⵖⴰⵔⵉⵏ, ⵎⴰⵔⵔⴰ ⵉⵏⵏⵉ ⵓⵎⵉ ⵉⵏⵏⵓⵔⵣⴻⵎ ⵡⵓⵍ ⵏⵙⴻⵏ ⵓⵛⴰ ⵉⵡⵢⴻⵏ-ⴷⴷ ⵜⵉⵎⴻⵙⵙⴰⴽⵉⵏ ⴷ ⵜⴻⵅⵔⴰⵣⵉⵏ ⵏ ⵓⵎⴻⵣⵣⵓⵖ ⴷ ⵜⵉⵏⵣⴰⵔ ⴷ ⵜⵅⵓⴷⴰⵏ ⵏ ⵓⵛⴻⵎⵎⵉⵄ ⴷ ⵜⵙⴻⴷⴷⵉⵢⵉⵏ ⵙ ⵡⴻⴷⵎⴰⵎ ⵏ ⵡⵓⵔⴻⵖ ⴷ ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ ⵏ ⵡⵓⵔⴻⵖ, ⵡⴰⵀ, ⴽⵓⵍ ⵉⵊⵊⴻⵏ ⵢⵉⵡⵉ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵡⴻⵏⵀⴻⵣⵣⵉ ⵏ ⵡⵓⵔⴻⵖ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","ⵎⴰⵔⵔⴰ ⵡⵉ ⵖⴰⵔ ⵉⵜⵜⵡⴰⴼ ⴰⴼⵉⵍⵓ ⴰⴷⴻⵃⵎⵉ ⴷ ⵓⵔⵊⵓⵡⴰⵏⵉ ⴷ ⵓⵣⴻⴳⴳⵯⴰⵖ ⵉⵃⴻⴷⵇⴻⵏ ⵏⵉⵖ ⵍⴻⵇⵟⴻⵏ ⴰⵣⴷⴰⴷ ⵏⵉⵖ ⵛⵛⵄⴰⵔ ⵏ ⵉⵖⴰⵢⴹⴻⵏ ⵏⵉⵖ ⵉⵍⵎⴰⵡⴻⵏ ⵉⵣⴻⴳⴳⵯⴰⵖⴻⵏ ⵏ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ ⵏⵉⵖ ⵉⵍⵎⴰⵡⴻⵏ ⵏ ⴷⴷⴻⵏⴼⵉⵍⴰⵜ, ⵉⵡⵢⴻⵏ-ⴷⴷ ⵎⴰⵏ ⴰⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","ⵎⴰⵔⵔⴰ ⵡⵉ ⵉⵙⵙⴳⴻⵄⵄⴷⴻⵏ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵏⵉⵖ ⵏ ⵏⵏⵃⴰⵙ, ⵉⵡⵢⴻⵏ ⵜⴰⵡⵀⵉⴱⵜ-ⴰ ⵏ ⵓⵙⴳⴻⵄⵄⴻⴷ ⵖⴰⵔ ⵙⵉⴷⵉ, ⴷ ⵎⴰⵔⵔⴰ ⵡⵉ ⵖⴰⵔ ⵉⵜⵜⵡⴰⴼ ⵓⴽⴻⵛⵛⵓⴹ ⵏ ⵓⴽⴰⵙⵉⵢⴰ ⵉ ⵎⴰⵔⵔⴰ ⵍⵅⴻⴷⵎⴻⵜ ⵏ ⵜⵙⴻⵅⵅⴰⵔⵜ, ⵉⵡⵢⴻⵏ ⵎⴰⵏ ⴰⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","ⵎⴰⵔⵔⴰ ⵜⵉⵎⵖⴰⵔⵉⵏ ⵙ ⵡⵓⵍ ⴰⵎⵉⵖⵉⵙ ⵜⵜⵇⴰⵔⴹⵛⴻⵏⵜ ⵙ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵙⴻⵏⵜ ⵓⵛⴰ ⵏⵉⵜⴻⵏⵜⵉ ⵉⵡⵢⴻⵏⵜ-ⵉ-ⴷⴷ ⵎⵉⵏ ⵇⴰⵔⴻⴹⵛⴻⵏⵜ: ⴰⴼⵉⵍⵓ ⴰⴷⴻⵃⵎⵉ ⴷ ⵓⵔⵊⵓⵡⴰⵏⵉ ⴷ ⵓⵣⴻⴳⴳⵯⴰⵖ ⵉⵃⴻⴷⵇⴻⵏ ⴷ ⵍⴻⵇⵟⴻⵏ ⴰⵣⴷⴰⴷ.    ");
INSERT INTO rift_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","ⵎⴰⵔⵔⴰ ⵜⵉⵎⵖⴰⵔⵉⵏ ⵏⵏⵉ ⵓⵎⵉ ⵉⵏⵀⴻⵣⵣ ⵡⵓⵍ ⵏⵙⴻⵏⵜ ⵙ ⵜⵉⵖⵉⵜ, ⵇⴰⵔⴻⴹⵛⴻⵏⵜ ⵛⵛⵄⴰⵔ ⵏ ⵉⵖⴰⵢⴹⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","ⵍⵃⵓⴽⴽⴰⵎ ⵉⵡⵢⴻⵏ-ⴷⴷ ⵉⵥⵔⴰ ⵏ ⵓⵏⵉⴽⵙ ⴷ ⵉⵥⵔⴰ ⵉⵖⵍⴰⵏ ⵏⵏⴻⵖⵏⵉ, ⵃⵉⵎⴰ ⴰⴷ ⵜⴻⵏ ⴳⴳⴻⵏ ⵅ ⵓⴱⴰⵍⵟⵓ ⵓ ⵅ ⵜⴻⵊⵎⴻⵛⵜ, ");
INSERT INTO rift_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","ⵍⴻⵄⵟⵓⵔ ⴷ ⵣⵣⴻⵛⵜ ⵉ ⵜⴼⴰⵡⵜ ⴷ ⵣⵣⴻⵛⵜ ⵉ ⵡⴻⴷⵀⴰⵏ ⵓ ⵉ ⵍⴻⴱⵅⵓⵔ ⵉⵜⵜⴼⵓⵃⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵡⵛⵉⵏ ⵙ ⵍⵅⴰⴹⴰⵔ ⵉ ⵙⵉⴷⵉ, ⵎⴰⵔⵔⴰ ⵉⵔⵢⴰⵣⴻⵏ ⴷ ⵜⴻⵎⵖⴰⵔⵉⵏ, ⵉⵏⵏⵉ ⵓⵎⵉ ⵉⵏⵀⴻⵣⵣ ⵡⵓⵍ ⵏⵙⴻⵏ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵡⵛⴻⵏ ⵙ ⵍⵅⴰⴹⴰⵔ ⵉ ⵎⴰⵔⵔⴰ ⵍⵅⴻⴷⵎⴻⵜ ⵏⵏⵉ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ, ⵃⵉⵎⴰ ⴰⴷ ⵜᵉⵜⵜⵡⴰⴳⴳ ⵙ ⵜⵙⴻⵅⵅⴰⵔⵜ ⵏ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵎⵓⵙⴰ ⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ: “ⵅⵣⴰⵔⴻⵎ, ⵙⵉⴷⵉ ⵉⵍⴰⵖⴰ-ⴷⴷ ⵉ ⴱⴰⵚⴰⵍⵉⵢⵉⵍ, ⵎⵎⵉⵙ ⵏ ⵓⵔⵉ, ⵎⵎⵉⵙ ⵏ ⵃⵓⵔ, ⵣⵉ ⵍⴰⴵ ⵏ ⵢⴰⵀⵓⴷⴰ, ⵙ ⵢⵉⵙⴻⵎ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","ⵉⵛⵛⵓⵔ ⵉ-ⵜ ⴰⵔⵔⵓⵃ ⵏ ⴰⵔⴻⴱⴱⵉ ⵙ ⵜⵉⵖⵉⵜ ⴷ ⵍⴻⵄⵇⴻⵍ ⴷ ⵜⵓⵙⵙⵏⴰ ⵓ ⵙ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⵜⵜⵅⴻⵚⵚⴰⵏ ⵏ ⵜⵣⴻⵎⵎⴰⵔ ⵏ ⵚⵚⵏⴰⵢⴻⵄ ");
INSERT INTO rift_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","ⵉ ⵓⵅⴻⵎⵎⴻⵎ ⵏ ⵄⵍⴰⵎ ⴽⵓⵍ ⵉⵔⴻⵇⵇⴰⵎⴻⵏ, ⵃⵉⵎⴰ ⴰⴷ ⵜⴻⵏ ⵢⴻⴳⴳ ⵙ ⵡⵓⵔⴻⵖ ⴷ ⵏⵏⵓⵇⴰⵔⵜ ⴷ ⵏⵏⵃⴰⵙ, ");
INSERT INTO rift_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","ⵓ ⵉ ⵓⵏⴻⵇⵇⴰⵛ ⵏ ⵉⵥⵔⴰ ⵉⵖⵍⴰⵏ ⴷ ⵓⵙⴰⵔⵙⵉ ⵏⵙⴻⵏ, ⵓ ⵉ ⵓⵏⴻⵇⵇⴰⵛ ⵏ ⵓⴽⴻⵛⵛⵓⴹ ⵓ ⵃⵉⵎⴰ ⴰⴷ ⵉⴳⴳ ⵎⴰⵔⵔⴰ ⵉⵔⴻⵇⵇⴰⵎⴻⵏ ⵙ ⵍⴼⴻⵏⵏ. ");
INSERT INTO rift_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","ⵉⴳⴳⴰ ⴰⵔⴻⴱⴱⵉ ⴷⴻⴳ ⵡⵓⵍ ⵏⵏⴻⵙ ⵜⴰⵡⴻⵏⴳⵉⵜ ⵉ ⵓⵙⴻⵍⵎⴻⴷ, ⴷⴻⴳ ⵡⵓⵍ ⵏⵏⴻⵙ ⵓ ⴷⴻⴳ ⵡⵓⵍ ⵏ ⴰⵀⵓⵍⵉⵢⴰⴱ, ⵎⵎⵉⵙ ⵏ ⴰⵅⵉⵙⴰⵎⴰⴽ, ⵣⵉ ⵍⴰⴵ ⵏ ⴷⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","ⵉⵛⵛⵓⵔ ⵉ-ⵜⴻⵏ ⵙ ⵜⵉⵖⵉⵜ ⵏ ⵡⵓⵍ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴳⴳⴻⵏ ⵎⴰⵔⵔⴰ ⵍⵅⴻⴷⵎⴻⵜ: ⵍⵅⴻⴷⵎⴻⵜ ⵏ ⵜⴰⵏⴻⵇⵇⴰⵛⵜ ⴷ ⵡⴰⵔⵛⴰⵎ ⴷ ⵓⵎⵓⴷⵉ ⵙ ⵓⴼⵉⵍⵓ ⴰⴷⴻⵃⵎⵉ ⴷ ⵓⵔⵊⵓⵡⴰⵏⵉ ⴷ ⵓⵣⴻⴳⴳⵯⴰⵖ ⵉⵃⴻⴷⵇⴻⵏ ⴷ ⵍⴻⵇⵟⴻⵏ ⴰⵣⴷⴰⴷ ⵓⵍⴰ ⴷ ⵍⵅⴻⴷⵎⴻⵜ ⵏ ⵓⵅⴻⵢⵢⴰⴹ.” ⵏⵉⵜⵏⵉ ⴳⴳⵉⵏ ⴽⵓⵍ ⵍⵅⴻⴷⵎⴻⵜ ⵓ ⵜⵜⵙⴰⵇⴰⵔⴻⵏ ⴰⵔⵛⴰⵎⴻⵏ ⵙ ⵍⴼⴻⵏⵏ. ");
INSERT INTO rift_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","ⴱⴰⵚⴰⵍⵉⵢⵉⵍ ⴷ ⴰⵀⵓⵍⵉⵢⴰⴱ ⴷ ⴽⵓⵍ ⴰⵔⵢⴰⵣ ⵙ ⵡⵓⵍ ⴰⵎⵉⵖⵉⵙ ⵉ ⵓⵎⵉ ⵉⵡⵛⴰ ⵙⵉⴷⵉ ⵜⵉⵖⵉⵜ ⴷ ⵍⴻⵄⵇⴻⵍ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵙⵙⵏⴻⵏ ⵎⴰⵎⵎⴻⵛ ⵖⴰ ⴳⴳⴻⵏ ⵎⴰⵔⵔⴰ ⵍⵅⴻⴷⵎⴻⵜ ⵉ ⵜⵙⴻⵅⵅⴰⵔⵜ ⵏ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ, ⴳⴳⵉⵏ ⵎⴰⵔⵔⴰ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⴻⵏ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","ⵎⵓⵙⴰ ⵉⵍⴰⵖⴰ-ⴷⴷ ⵉ ⴱⴰⵚⴰⵍⵉⵢⵉⵍ ⴷ ⴰⵀⵓⵍⵉⵢⴰⴱ ⴷ ⴽⵓⵍ ⴰⵔⵢⴰⵣ ⵙ ⵡⵓⵍ ⴰⵎⵉⵖⵉⵙ, ⵓⵎⵉ ⵉⴳⴳⴰ ⵙⵉⴷⵉ ⵜⵉⵖⵉⵜ ⴷⴻⴳ ⵡⵓⵍ ⵏⵏⴻⵙ, ⵓⵍⴰ ⵎⴰⵔⵔⴰ ⵡⴻⵏⵏⵉ ⵓⵎⵉ ⵉⵏⵀⴻⵣⵣ ⵡⵓⵍ ⵏⵏⴻⵙ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴷⴷ-ⵢⴰⵙ ⵖⴰⵔ ⵍⵅⴻⴷⵎⴻⵜ ⵓⵛⴰ ⴰⴷ ⵜⵜ ⵉⴳⴳ. ");
INSERT INTO rift_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","ⵏⵉⵜⵏⵉ ⴽⵙⵉⵏ ⵣⵉ ⵣⵣⴰⵜ ⵏ ⵡⵓⴷⴻⵎ ⵏ ⵎⵓⵙⴰ ⵎⴰⵔⵔⴰ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⵉ ⵙⵙⴳⴻⵄⵄⴷⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵉ ⵍⵅⴻⴷⵎⴻⵜ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏⵉ ⵜⵙⴻⵅⵅⴰⵔⵜ ⵏ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴳⴳⴻⵏ ⵍⵅⴻⴷⵎⴻⵜ ⵏⵏⵉ. ⵓⵛⴰ ⴰⵇⴰ ⵄⴰⴷ ⴳⴳⵉⵏ ⴰⴷ ⴰⵙ ⴷⴷ-ⴰⵡⵢⴻⵏ ⴽⵓⵍ ⵚⵚⴱⴻⵃ ⵜⵉⵡⵀⵉⴱⵉⵏ ⵙ ⵍⵅⴰⴹⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","ⵅⴻⵏⵏⵉ ⵓⵙⵉⵏ-ⴷⴷ ⵎⴰⵔⵔⴰ ⵉⵔⵢⴰⵣⴻⵏ ⵉⵎⵉⵖⵉⵙⴻⵏ, ⵉⵏⵏⵉ ⵜⵓⵖⴰ ⵉⵛⴻⵖⵍⴻⵏ ⵅ ⵎⴰⵔⵔⴰ ⵍⵅⴻⴷⵎⴻⵜ ⵏ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ, ⵉⵊⵊ ⵉⵊⵊ ⴷⴻⵡⵍⴻⵏ-ⴷⴷ ⵣⵉ ⵍⵅⴻⴷⵎⴻⵜ ⵏⵏⵉ ⴳⴳⵉⵏ ⵏⵉⵜⵏⵉ, ");
INSERT INTO rift_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","ⵓⵛⴰ ⵙⵙⵉⵡⵍⴻⵏ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵏⵏⴰⵏ: “ⵍⴳⴻⵏⵙ ⵢⵉⵡⵉ-ⴷⴷ ⴽⵜⴰⵔ ⵣⵉ ⵎⵉⵏ ⵉⵜⵜⵅⴻⵚⵚⴰⵏ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏ ⵍⵅⴻⴷⵎⴻⵜ ⵏⵏⵉ ⵉ ⴷ ⴰⵏⴻⵖ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ, ⵃⵉⵎⴰ ⴰⴷ ⵜⵜ ⵏⴻⴳⴳ.” ");
INSERT INTO rift_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","ⵅⴰⵙ ⵓⵛⴰ ⵢⵓⵎⵓⵔ ⵎⵓⵙⴰ, ⵃⵉⵎⴰ ⴰⴷ ⴱⴰⵔⵔⵃⴻⵏ ⴷⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ, ⴰⴷ ⵉⵏⵉⵏ: “ⵡⴰⵔ ⵜⵜⴻⵊⵊⵉ ⴰⵔⵢⴰⵣ ⵏⵉⵖ ⵜⴰⵎⵖⴰⵔⵜ ⵄⴰⴷ ⴰⴷ ⵢⴻⴳⴳ ⵛⴰ ⵏ ⵍⵅⴻⴷⵎⴻⵜ ⵏⵏⵉ ⵉ ⵖⴰ ⵉⵙⵙⴳⴻⵄⵄⴻⴷ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵉ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ!” ⴰⵎⵎⵓ ⵉ ⵉⵙⵙⴱⴻⴷⴷ ⵎⵓⵙⴰ ⵍⴳⴻⵏⵙ ⴰⴷ ⵢⴰⵡⵉ ⵄⴰⴷ ⴽⵜⴰⵔ, ");
INSERT INTO rift_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","ⵎⵉⵏⵣⵉ ⵛⴼⴰ ⵜⵉⵎⴻⵙⵍⴰⵢⵉⵏ ⵏⵏⵉ ⴷ ⵉⵡⵢⴻⵏ ⵉ ⵎⴰⵔⵔⴰ ⵍⵅⴻⴷⵎⴻⵜ ⵉ ⵖⴰ ⴳⴳⴻⵏ, ⴰⵇⴰ ⵜⵛⴻⵟⵟ ⵄⴰⴷ ⴽⵜⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","ⵊⴰⵔ ⵢⵉⵏⵏⵉ ⵖⴰⵔ ⵜⵓⵖⴰ ⵍⵅⴻⴷⵎⴻⵜ, ⴰⵇⴰ ⵎⴰⵔⵔⴰ ⵉⵎⵉⵖⵉⵙⴻⵏ ⵏ ⵡⵓⵍ ⴳⴳⵉⵏ ⵜⴰⵣⴻⴷⴷⵉⵖⵜ ⵣⵉ ⵄⴻⵛⵔⴰ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵉⵏ ⵏ ⵍⴻⵇⵟⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵎⵓⴷⴻⵏ ⵓ ⵙ ⵓⴼⵉⵍⵓ ⴰⴷⴻⵃⵎⵉ ⴷ ⵓⵔⵊⵓⵡⴰⵏⵉ ⴷ ⵓⵣⴻⴳⴳⵯⴰⵖ ⵉⵃⴻⴷⵇⴻⵏ ⴰⴽ-ⴷ ⵉⴽⵉⵔⵓⴱⴻⵏ ⵏⵏⵉ ⵅⴰⵙⴻⵏⵜ ⵉⴳⴳⴰ ⴰⵎ ⵢⵉⵊⵊ ⵏ ⵡⴰⵔⵛⴰⵎ ⵏ ⵓⴼⴻⵏⵏⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","ⵜⵓⵣⵣⴻⴳⴳⴰⵔⵜ ⵏ ⵉⵛⵜ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵜ ⵜⵓⵖⴰ-ⵜⵜ ⵜⵎⴻⵏⵢⴰ ⵓ-ⵄⴻⵛⵔⵉⵏ ⵏ ⵉⵖⴰⴵⴻⵏ ⵓ ⵜⵉⵔⵓ ⵏ ⵉⵛⵜ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵜ ⵜⵓⵖⴰ-ⵜ ⴰⵔⴻⴱⵄⴰ ⵏ ⵉⵖⴰⴵⴻⵏ ⵓ ⵎⴰⵔⵔⴰ ⵜⵉⵊⴰⵔⵜⵉⵍⵉⵏ ⵖⴰⵔⵙⴻⵏⵜ ⴷ ⵍⴻⵄⴱⴰⵔ ⴷ ⵉⵊⵊ. ");
INSERT INTO rift_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","ⵉⵙⵙⵎⵓⵏ ⵅⴻⵎⵙⴰ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵉⵏ ⵉⵛⵜ ⴰⴽ-ⴷ ⵜⴻⵏⵏⴻⵖⵏⵉ ⵓⵛⴰ ⵅⴻⵎⵙⴰ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵉⵏ ⵉⵙⵙⵎⵓⵏ ⵉ-ⵜⴻⵏⵜ ⵄⴰⵡⴻⴷ ⵉⵛⵜ ⴰⴽ-ⴷ ⵜⴻⵏⵏⴻⵖⵏⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","ⵅⴻⵏⵏⵉ ⵉⴳⴳⴰ ⵜⵉⵙⴰⵔⴰⵡⵉⵏ ⵉⴷⴻⵃⵎⴰⵏⵉⵢⵢⴻⵏ ⴷⵉ ⵜⵎⴰ ⵏ ⵢⵉⵛⵜ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵜ ⵖⴰⵔ ⵟⵟⴰⵔⴼ ⵖⴰⵔ ⵓⵙⴻⵍⵇⵉ ⵓⵛⴰ ⴰⵎⴻⵏⵏⵉ ⵉ ⵜⴻⵏⵜ ⵉⴳⴳⴰ ⵄⴰⵡⴻⴷ ⴷⵉ ⵜⵎⴰ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵜ ⵏⵏⴻⵖⵏⵉ ⵖⴰⵔ ⵟⵟⴰⵔⴼ, ⵖⴰⵔ ⵎⴰⵏⵉ ⵉⴵⴰ ⵓⵙⴻⵍⵇⵉ ⵏⵏⴻⵖⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","ⵉⴳⴳⴰ ⵅⴻⵎⵙⵉⵏ ⵏ ⵜⵙⴰⵔⴰⵡⵉⵏ ⵅ ⵜⵎⴰ ⵏ ⵢⵉⵛⵜ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵜ ⴷ ⵅⴻⵎⵙⵉⵏ ⵏ ⵜⵙⴰⵔⴰⵡⵉⵏ ⵖⴰⵔ ⵟⵟⴰⵔⴼ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵜ ⵏⵏⴻⵖⵏⵉ ⵖⴰⵔ ⵓⵙⴻⵍⵇⵉ ⵏⵏⴻⵖⵏⵉ. ⵜⵉⵙⴰⵔⴰⵡⵉⵏ ⵟⵟⴼⴻⵏⵜ ⵏⵉⵛⴰⵏ ⵉⵛⵜ ⴷⵉ ⵜⴻⵏⵏⴻⵖⵏⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","ⵉⴳⴳⴰ ⵄⴰⵡⴻⴷ ⵅⴻⵎⵙⵉⵏ ⵏ ⵜⵙⴻⵏⵏⴰⵔⵉⵏ ⵏ ⵡⵓⵔⴻⵖ ⵓⵛⴰ ⵉⵙⵙⵎⵓⵏ ⵜⵉⵊⴰⵔⵜⵉⵍⵉⵏ ⵉⵛⵜ ⵉ ⵜⴻⵏⵏⴻⵖⵏⵉ ⵙ ⵜⵙⴻⵏⵏⴰⵔⵉⵏ ⵓⵛⴰ ⴰⵎⵎⵓ ⵜⴻⴷⵡⴻⵍ ⵜⵣⴻⴷⴷⵉⵖⵜ ⴷ ⵉⵛⵜ. ");
INSERT INTO rift_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","ⵉⴳⴳⴰ ⵄⴰⵡⴻⴷ ⵜⵉⵊⴰⵍⵜⵉⵍⵉⵏ ⵏ ⵛⵛⵄⴰⵔ ⵏ ⵉⵖⴰⵢⴹⴻⵏ, ⴰⴷ ⵉⵍⵉⵏⵜ ⴷ ⴰⵇⵉⴹⵓⵏ ⵅ ⵜⵣⴻⴷⴷⵉⵖⵜ. ⵉⴳⴳⴰ ⵃⵉⵟⴰⵛ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","ⵜⵓⵣⵣⴻⴳⴳⴰⵔⵜ ⵏ ⵉⵛⵜ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵜ ⵜⵓⵖⴰ-ⵜⵜ ⵜⵍⴰⵜⵉⵏ ⵏ ⵉⵖⴰⴵⴻⵏ ⵓ ⵜⵉⵔⵓ ⵏ ⵉⵛⵜ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵜ ⴷ ⴰⵔⴻⴱⵄⴰ ⵏ ⵉⵖⴰⴵⴻⵏ. ⵃⵉⵟⵄⴰⵛ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵉⵏ ⵖⴰⵔⵙⴻⵏⵜ ⵍⴻⵄⴱⴰⵔ ⴷ ⵉⵊⵊ. ");
INSERT INTO rift_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","ⵏⴻⵜⵜⴰ ⵉⵙⵙⵎⵓⵏ ⵅⴻⵎⵙⴰ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵉⵏ ⵡⴻⵃⵃⴻⴷⵙⴻⵏⵜ ⵓ ⵄⴰⵡⴻⴷ ⵙⴻⵜⵜⴰ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵉⵏ ⵡⴻⵃⵃⴻⴷⵙⴻⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","ⵉⴳⴳⴰ ⵅⴻⵎⵙⵉⵏ ⵏ ⵜⵙⴰⵔⴰⵡⵉⵏ ⵅ ⵜⵎⴰ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵜ ⵜⴰⵏⴻⴳⴳⴰⵔⵓⵜ ⵖⴰⵔ ⵟⵟⴰⵔⴼ ⵏ ⵓⵙⴻⵍⵇⵉ ⴰⴽ-ⴷ ⵜⴻⵏⵏⴻⵖⵏⵉ ⵓⵛⴰ ⵉⴳⴳⴰ ⵄⴰⵡⴻⴷ ⵅⴻⵎⵙⵉⵏ ⵏ ⵜⵙⴰⵔⴰⵡⵉⵏ ⵅ ⵜⵎⴰ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵜ ⵖⴰⵔ ⵟⵟⴰⵔⴼ ⵏ ⵓⵙⴻⵍⵇⵉ ⵏⵏⴻⵖⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","ⵉⴳⴳⴰ ⵄⴰⵡⴻⴷ ⵅⴻⵎⵙⵉⵏ ⵏ ⵜⵙⴻⵏⵏⴰⵔⵉⵏ ⵏ ⵏⵏⵃⴰⵙ, ⵃⵉⵎⴰ ⴰⴷ ⵉⵙⵙⵎⵓⵏ ⴰⵇⵉⴹⵓⵏ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜ ⵢⴰⵔⵔ ⴷ ⵉⵊⵊⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","ⵉⴳⴳⴰ ⵄⴰⵡⴻⴷ ⵉⵛⵜ ⵏ ⵜⵙⴻⵇⵇⴰⴼⵜ ⵏ ⵉⵍⵎⴰⵡⴻⵏ ⵉⵣⴻⴳⴳⵯⴰⵖⴻⵏ ⵏ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ ⵉ ⵓⵇⵉⴹⵓⵏ ⵓⵛⴰ ⵙⴻⵏⵏⴻⵊ ⵉ ⵎⴰⵏ ⴰⵢⴰ ⵉⵛⵜ ⵏ ⵜⵙⴻⵇⵇⴰⴼⵜ ⵏ ⵉⵍⵎⴰⵡⴻⵏ ⵏ ⴷⴷⴻⵏⴼⵉⵍⴰⵜ. ");
INSERT INTO rift_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","ⵉⴳⴳⴰ ⵜⵉⴼⴻⵍⵡⵉⵏ ⵉ ⵜⵣⴻⴷⴷⵉⵖⵜ ⵙ ⵓⴽⴻⵛⵛⵓⴹ ⵏ ⵓⴽⴰⵙⵉⵢⴰ ⵏⵏⵉ ⵉⴱⴻⴷⴷⴻⵏ ⵏⵉⵛⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","ⵜⵓⵣⵣⴻⴳⴳⴰⵔⵜ ⵏ ⵉⵛⵜ ⵏ ⵜⴻⴼⵍⴰⵡⵜ ⵜⵓⵖⴰ-ⵜⵜ ⵄⴻⵛⵔⴰ ⵏ ⵉⵖⴰⴵⴻⵏ ⵓ ⵜⵉⵔⵓ ⵏ ⵢⵉⵛⵜ ⵏ ⵜⴻⴼⵍⴰⵡⵜ ⴷ ⵉⵊⵊ ⵏ ⵓⵖⵉⵍ ⴷ ⵡⴻⵣⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","ⴽⵓⵍ ⵜⴰⴼⵍⴻⵡⵜ ⵖⴰⵔⴻⵙ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⴹⴰⵔⴻⵏ, ⵉⵏⵏⵉ ⵉⵙⵙⵎⴻⵍⵇⴰⵏ ⵉⵛⵜ ⴰⴽ-ⴷ ⵜⴻⵏⵏⴻⵖⵏⵉⵜ ⴰⵎ ⵜⵡⴻⵍⵜⵎⴰⵜⵉⵏ ⴰⵎⵎⵓ ⵉ ⵉⴳⴳⴰ ⵙ ⵎⴰⵔⵔⴰ ⵜⵉⴼⴻⵍⵡⵉⵏ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ. ");
INSERT INTO rift_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","ⵉⴳⴳⴰ ⵜⵉⴼⴻⵍⵡⵉⵏ ⵉ ⵜⵣⴻⴷⴷⵉⵖⵜ, ⵄⵉⵛⵔⵉⵏ ⵏ ⵜⴼⴻⵍⵡⵉⵏ ⵖⴰⵔ ⵊⵊⵉⵀⴻⵜ ⵏ ⵍⵊⴰⵏⵓⴱ, ⵖⴰⵔ ⵢⴻⴼⵓⵙ. ");
INSERT INTO rift_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","ⵉⴳⴳⴰ ⵄⴰⵡⴻⴷ ⴰⵔⴻⴱⵄⵉⵏ ⵏ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵙⴰⴷⵓ ⵄⵉⵛⵔⵉⵏ ⵏ ⵜⴼⴻⵍⵡⵉⵏ, ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵙⴰⴷⵓ ⵉⵛⵜ ⵏ ⵜⴻⴼⵍⴰⵡⵜ ⵉ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⴹⴰⵔⴻⵏ ⵏⵏⴻⵙ, ⵓⵍⴰ ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵙⴰⴷⵓ ⵜⴰⴼⵍⴰⵡⵜ ⵏⵏⴻⵖⵏⵉ ⵉ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⴹⴰⵔⴻⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","ⵉⴳⴳⴰ ⵄⴰⵡⴻⴷ ⵄⵉⵛⵔⵉⵏ ⵏ ⵜⴼⴻⵍⵡⵉⵏ ⵉ ⵓⵖⴻⵣⴷⵉⵙ ⵏⵏⴻⵖⵏⵉ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ, ⵖⴰⵔ ⵓⵖⴻⵣⴷⵉⵙ ⵏ ⵛⵛⴰⵎⴰⵍ, ");
INSERT INTO rift_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ⵙ ⴰⵔⴻⴱⵄⵉⵏ ⵏ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵏⵏⴻⵙ ⵏ ⵏⵏⵓⵇⴰⵔⵜ: ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵙⴰⴷⵓ ⵉⵛⵜ ⵏ ⵜⴻⴼⵍⴰⵡⵜ ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵙⴰⴷⵓ ⵜⴰⴼⵍⴰⵡⵜ ⵏⵏⴻⵖⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","ⵉ ⵉⵖⴻⵣⴷⵉⵙⴻⵏ ⵏ ⴹⴻⴼⴼⴰⵔ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ, ⵖⴰⵔ ⵓⵖⴻⵣⴷⵉⵙ ⵏ ⵍⵖⴰⵔⴱ, ⵉⴳⴳⴰ ⵙⴻⵜⵜⴰ ⵏ ⵜⴼⴻⵍⵡⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","ⵉⴳⴳⴰ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴼⴻⵍⵡⵉⵏ ⴷ ⵜⵉⴼⴻⵍⵡⵉⵏ ⵉ ⵜⵖⴻⵎⵎⵓⵔⴰ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ ⵖⴰⵔ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵖⴻⵣⴷⵉⵙⴻⵏ ⵖⴰⵔ ⴹⴻⴼⴼⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","ⵣⵉ ⵙⵡⴰⴷⴷⴰⵢ ⵜⵓⵖⴰ ⵍⴻⵚⵇⴻⵏⵜ ⴰⵎ ⵡⴰⵛⵏⵉⵡⴻⵏ ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⵜⴻⵏⵜ ⵜⵓⵖⴰ ⴷ ⵉⵛⵜⴻⵏ ⴰⵍ ⴷⴷ-ⴰⵡⴹⴻⵏⵜ ⵙⴻⵏⵏⴻⵊ ⴷⴻⴳ ⵉⵛⵜ ⵏ ⵜⴻⵅⵔⴰⵣⵜ. ⴰⵎⵎⵓ ⵉ ⵉⴳⴳⴰ ⵙ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴼⴻⵍⵡⵉⵏ ⵉ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵖⴻⵎⵎⵓⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","ⴰⵎⵎⵓ ⵉ ⴷⵉⵏ ⵜⵓⵖⴰ ⵜⵎⴻⵏⵢⴰ ⵏ ⵜⴼⴻⵍⵡⵉⵏ ⵙ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵏⵙⴻⵏⵜ ⵏ ⵏⵏⵓⵇⴰⵔⵜ, ⴰⵇⴰ ⴰⵜⴻⵏⵜ ⴷ ⵙⴻⵟⵟⴰⵛ ⵏ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ, ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵙⴰⴷⵓ ⴽⵓⵍ ⵜⴰⴼⵍⴻⵡⵜ. ");
INSERT INTO rift_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","ⵉⴳⴳⴰ ⵄⴰⵡⴻⴷ ⵜⵉⵃⴻⵏⵢⴰ ⵏ ⵓⵄⴰⵔⵔⴻⴹ ⵣⴻⴳ ⵓⴽⴻⵛⵛⵓⴹ ⵏ ⵓⴽⴰⵙⵉⵢⴰ, ⵅⴻⵎⵙⴰ ⵏ ⵜⴼⴻⵍⵡⵉⵏ ⵖⴰⵔ ⵉⵊⵊ ⵏ ⵓⵖⴻⵣⴷⵉⵙ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ, ");
INSERT INTO rift_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","ⵓ ⵅⴻⵎⵙⴰ ⵏ ⵜⵃⴻⵏⵢⴰ ⵏ ⵓⵄⴰⵔⵔⴻⴹ ⵉ ⵜⴼⴻⵍⵡⵉⵏ ⵖⴰⵔ ⵓⵖⴻⵣⴷⵉⵙ ⵏⵏⴻⵖⵏⵉ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ ⴷ ⵅⴻⵎⵙⴰ ⵏ ⵜⵃⴻⵏⵢⴰ ⵏ ⵓⵄⴰⵔⵔⴻⴹ ⵉ ⵜⴼⴻⵍⵡⵉⵏ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ ⵖⴰⵔ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵖⴻⵎⵎⵓⵔⴰ ⵏ ⴹⴻⴼⴼⴰⵔ ⵖⴰⵔ ⵍⵖⴰⵔⴱ. ");
INSERT INTO rift_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","ⵜⴰⵃⵏⴰⵛⵜ ⵏ ⵓⵄⴰⵔⵔⴻⴹ ⴷⵉ ⵍⵡⴻⵙⵟ ⵉⴳⴳⴰ ⵉ-ⵜⵜ ⴰⴷ ⵜⴻⵥⵡⴰ ⵣⵉ ⵍⵡⴻⵙⵟ ⵏ ⵜⴼⴻⵍⵡⵉⵏ ⵣⴻⴳ ⵉⵅⴻⴼ ⴰⵍ ⵡⴻⵏⵏⴻⵖⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","ⵉⵖⴻⴵⴻⴼ ⵜⵉⴼⴻⵍⵡⵉⵏ ⵙ ⵡⵓⵔⴻⵖ ⵓⵛⴰ ⵉⴳⴳⴰ ⵜⵉⵅⵔⴰⵣⵉⵏ ⵏⵙⴻⵏⵜ ⵏ ⵡⵓⵔⴻⵖ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴷⴰⵢⵙⴻⵏⵜ ⵙⵙⵉⴷⴼⴻⵏ ⵜⵉⵃⴻⵏⵢⴰ ⵏ ⵓⵄⴰⵔⵔⴻⴹ ⵓⵛⴰ ⵓⵍⴰ ⴷ ⵜⵉⵃⴻⵏⵢⴰ ⵏ ⵓⵄⴰⵔⵔⴻⴹ ⵉⵛⴻⵍⵍⴻⵍ ⵉ-ⵜⴻⵏⵜ ⵙ ⵡⵓⵔⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","ⵉⴳⴳⴰ ⵉⵊⵊ ⵏ ⵓⵍⴻⵃⵃⴰⴼ ⵙ ⵓⴼⵉⵍⵓ ⴰⴷⴻⵃⵎⵉ ⴷ ⵓⵔⵊⵓⵡⴰⵏⵉ ⴷ ⵓⵣⴻⴳⴳⵯⴰⵖ ⵉⵃⴻⴷⵇⴻⵏ ⵓ ⵙ ⵍⴻⵇⵟⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵎⵓⴷⴻⵏ, ⵉⴳⴳⴰ ⵉ-ⵜ ⴷ ⵉⵊⵊ ⵏ ⵡⴰⵔⵛⴰⵎ ⵏ ⵓⴼⴻⵏⵏⴰⵏ ⴰⴽ-ⴷ ⵉⴽⵉⵔⵓⴱⴻⵏ ⵅⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","ⵉⴳⴳⴰ ⴰⵙ ⴰⵔⴻⴱⵄⴰ ⵏ ⵉⴱⵉⵍⴰⵔⴻⵏ ⵏ ⵓⴽⴻⵛⵛⵓⴹ ⵏ ⵓⴽⴰⵙⵉⵢⴰ ⵓⵛⴰ ⵉⵖⴻⴵⴻⴼ ⵉ-ⵜⴻⵏ ⵙ ⵡⵓⵔⴻⵖ. ⵜⵉⵙⴻⵏⵏⴰⵔⵉⵏ ⵏⵙⴻⵏ ⵜⵓⵖⴰ ⴰⵜⴻⵏⵜ ⵏ ⵡⵓⵔⴻⵖ. ⵉⵙⵙⴻⴼⵙⵉ ⵉ ⵉⴱⵉⵍⴰⵔⴻⵏ ⴰⵔⴻⴱⵄⴰ ⵏ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵏⵙⴻⵏⵜ ⵏ ⵏⵏⵓⵇⴰⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","ⵉⴳⴳⴰ ⵉⵊⵊ ⵏ ⴰⵔⵡⴰⵇ ⵉ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵙ ⵓⴼⵉⵍⵓ ⴰⴷⴻⵃⵎⵉ ⴷ ⵓⵔⵊⵓⵡⴰⵏⵉ ⴷ ⵓⵣⴻⴳⴳⵯⴰⵖ ⵉⵃⴻⴷⵇⴻⵏ ⵓ ⵙ ⵍⴻⵇⵟⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵎⵓⴷⴻⵏ, ⵉⴳⴳⴰ ⵉ-ⵜ ⴷ ⵉⵊⵊ ⵏ ⵓⵎⵓⴷⵉ ⵏ ⵓⵅⴻⵢⵢⴰⴹ, ");
INSERT INTO rift_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","ⵙ ⵅⴻⵎⵙⴰ ⵏ ⵉⴱⵉⵍⴰⵔⴻⵏ ⵏⵏⴻⵙ ⴷ ⵜⵙⴻⵏⵏⴰⵔⵉⵏ ⵏⵏⴻⵙ. ⵉⵖⴻⴵⴻⴼ ⵜⵉⵣⴻⴵⵉⴼⵉⵏ ⵏⵙⴻⵏ ⴷ ⵉⵇⴻⴹⴱⴰⵏ ⵏⵙⴻⵏ ⵉ ⵓⵙⴻⵍⵇⵉ ⵙ ⵡⵓⵔⴻⵖ. ⵜⵉⵢⴰⵔⵙⴰⵡⵉⵏ ⵏⵙⴻⵏ ⵜⵓⵖⴰ ⴰⵜⴻⵏⵜ ⵏ ⵏⵏⵃⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","ⵉⴳⴳⴰ ⴱⴰⵚⴰⵍⵉⵢⵉⵍ ⵜⵜⴰⴱⵓⵜ ⵏ ⵓⴽⴻⵛⵛⵓⴹ ⵏ ⵜⵛⴻⵊⵊⴰⵔⵜ ⵏ ⵓⴽⴰⵙⵉⵢⴰ. ⵜⵓⵣⵣⴻⴳⴳⴰⵔⵜ ⵏⵏⴻⵙ ⵜⵓⵖⴰ-ⵜⵜ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵖⴰⴵⴻⵏ ⴷ ⵡⴻⵣⵢⴻⵏ ⵓ ⵜⵉⵔⵓ ⵏⵏⴻⵙ ⵉⵊⵊ ⵏ ⵓⵖⵉⵍ ⴷ ⵡⴻⵣⵢⴻⵏ ⵓⵛⴰ ⵍⵓⵄⵍⴰ ⵏⵏⴻⵙ ⵉⵊⵊ ⵏ ⵓⵖⵉⵍ ⴷ ⵡⴻⵣⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","ⵉⵖⴻⴵⴻⴼ ⵉ-ⵜ ⵣⵉ ⴷⴰⵅⴻⵍ ⴷ ⴱⴰⵔⵔⴰ ⵙ ⵡⵓⵔⴻⵖ ⵉⵚⴼⴰⵏ ⵓⵛⴰ ⵉⴳⴳⴰ ⴰⵙ ⵉⵊⵊ ⵏ ⵣⵣⵡⴰⵇ ⵏ ⵡⵓⵔⴻⵖ ⵉ ⴷ ⴰⵙ ⴷⴷ-ⵉⵏⵏⴹⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","ⵉⵙⵙⴻⴼⵙⵉ ⴰⵙ ⴰⵔⴻⴱⵄⴰ ⵏ ⵜⴻⵅⵔⴰⵣⵉⵏ ⵉ ⴰⵔⴻⴱⵄⴰ ⵏ ⵜⵖⴻⵎⵎⵓⵔⴰ ⵏⵏⴻⵙ: ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵅⵔⴰⵣⵉⵏ ⵖⴰⵔ ⵢⵉⵊⵊ ⵏ ⵓⵖⴻⵣⴷⵉⵙ ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵅⵔⴰⵣⵉⵏ ⵖⴰⵔ ⵓⵖⴻⵣⴷⵉⵙ ⵏⵏⴻⵖⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","ⵉⴳⴳⴰ ⵉⵄⵓⵎⴰⴷ ⵉ ⵜⴰⵔⴻⴱⴱⵓⵜ ⵣⴻⴳ ⵓⴽⴻⵛⵛⵓⴹ ⵏ ⵓⴽⴰⵙⵉⵢⴰ ⵓⵛⴰ ⵉⵖⴻⴵⴻⴼ ⵉ-ⵜⴻⵏ ⵙ ⵡⵓⵔⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","ⵉⴳⴳⴰ ⵉⵄⵓⵎⴰⴷ ⵉ ⵜⴰⵔⴻⴱⴱⵓⵜ ⴷⵉ ⵜⴻⵅⵔⴰⵣⵉⵏ ⵖⴰⵔ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵖⴻⵣⴷⵉⵙⴻⵏ ⵏ ⵜⵜⴰⴱⵓⵜ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵣⵣⴰⵢⵙⴻⵏ ⴰⵔⴱⵓⵏ ⵜⵜⴰⴱⵓⵜ. ");
INSERT INTO rift_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","ⵉⴳⴳⴰ ⵜⴰⵇⴻⴱⴱⴰⵔⵜ ⵏ ⵡⴻⵚⵍⴰⵃ ⵏ ⵡⵓⵔⴻⵖ ⵉⵚⴼⴰⵏ ⵙ ⵜⵓⵣⵣⴻⴳⴳⴰⵔⵜ ⵏⵏⴻⵙ ⵏ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵖⴰⴵⴻⵏ ⴷ ⵡⴻⵣⵢⴻⵏ ⵓ ⵜⵉⵔⵓ ⵏⵏⴻⵙ ⵏ ⵉⵊⵊ ⵏ ⵓⵖⵉⵍ ⴷ ⵡⴻⵣⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","ⵉⴳⴳⴰ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⴽⵉⵔⵓⴱⴻⵏ ⵏ ⵡⵓⵔⴻⵖ. ⵉⵄⴷⴻⵍ ⵉ-ⵜⴻⵏ ⴰⵎ ⵍⵅⴻⴷⵎⴻⵜ ⵏ ⵡⴻⵎⵣⵉⵍ ⵉ ⴷⴷ-ⵉⵜⵜⴻⴼⴼⵖⴻⵏ ⵣⵉ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵅⴼⴰⵡⴻⵏ ⵏ ⵜⵇⴻⴱⴱⴰⵔⵜ ⵏ ⵡⴻⵚⵍⴰⵃ. ");
INSERT INTO rift_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","ⵉⵊⵊ ⵏ ⵓⴽⵉⵔⵓⴱ ⵉⴼⴼⴻⵖ ⵣⴻⴳ ⵉⵊⵊ ⵏ ⵉⵅⴻⴼ ⵖⴰⵔ ⵓⵖⴻⵣⴷⵉⵙ-ⴰ ⵓ ⴰⴽⵉⵔⵓⴱ ⵏⵏⴻⵖⵏⵉ ⵣⴻⴳ ⵉⵅⴻⴼ ⵏⵏⴻⵖⵏⵉ ⵖⴰⵔ ⵓⵖⴻⵣⴷⵉⵙ ⵏⵏⴻⵖⵏⵉ. ⵉⴳⴳⴰ ⵉⴽⵉⵔⵓⴱⴻⵏ ⵣⵉ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵅⴼⴰⵡⴻⵏ ⵏ ⵜⵇⴻⴱⴱⴰⵔⵜ ⵏ ⵡⴻⵚⵍⴰⵃ. ");
INSERT INTO rift_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","ⵉⴽⵉⵔⵓⴱⴻⵏ ⵙⵙⵡⵉⵥⵥⴹⴻⵏ ⴰⴼⵔⵉⵡⴻⵏ ⵏⵙⴻⵏ ⵙⴻⵏⵏⴻⵊ ⵓⵛⴰ ⵙ ⵡⴰⴼⵔⵉⵡⴻⵏ ⵏⵙⴻⵏ ⴷⵍⵉⵏ ⵜⴰⵇⴻⴱⴱⴰⵔⵜ ⵏ ⵡⴻⵚⵍⴰⵃ. ⵉⵖⴻⵎⴱⴰⴱ ⵏⵙⴻⵏ ⵜⵓⵖⴰ ⵉⵊⵊⴻⵏ ⵇⵉⴱⴰⵍⵜ ⵉ ⵡⴻⵏⵏⴻⵖⵏⵉ ⵓⵛⴰ ⴷⵉ ⵍⵡⴻⵇⵜ ⴷ ⵉⵛⵜⴻⵏ ⵜⵓⵖⴰ ⵉⵖⴻⵎⴱⴰⴱ ⵏ ⵉⴽⵉⵔⵓⴱⴻⵏ ⵖⴰⵔ ⵜⵇⴻⴱⴱⴰⵔⵜ ⵏ ⵡⴻⵚⵍⴰⵃ. ");
INSERT INTO rift_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","ⵉⴳⴳⴰ ⵜⴰⵣⴻⵡⴹⴰ ⵏ ⵓⴽⴻⵛⵛⵓⴹ ⵏ ⵜⵛⴻⵊⵊⴰⵔⵜ ⵏ ⵓⴽⴰⵙⵉⵢⴰ. ⵜⵓⵖⴰ ⵜⵓⵣⵣⴻⴳⴳⴰⵔⵜ ⵏⵏⴻⵙ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵖⴰⴵⴻⵏ ⵓ ⵜⵉⵔⵓ ⵏⵏⴻⵙ ⵉⵊⵊ ⵏ ⵓⵖⵉⵍ ⴷ ⵍⵓⵄⵍⴰ ⵏⵏⴻⵙ ⵉⵊⵊ ⵏ ⵓⵖⵉⵍ ⴷ ⵡⴻⵣⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","ⵉⵖⴻⴵⴻⴼ ⵉ-ⵜⵜ ⵙ ⵡⵓⵔⴻⵖ ⵉⵚⴼⴰⵏ ⵓⵛⴰ ⵉⴳⴳⴰ ⴰⵙ ⵉⵊⵊ ⵏ ⵣⵣⵡⴰⵇ ⵏ ⵡⵓⵔⴻⵖ ⵉ ⴷ ⴰⵙ ⴷⴷ-ⵉⵏⵏⴹⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","ⵉⴳⴳⴰ ⵄⴰⵡⴻⴷ ⵉⵛⵜ ⵏ ⵜⵎⴰ ⵉ ⴷ ⴰⵙ ⴷⴷ-ⵉⵏⵏⴹⴻⵏ ⵏ ⵉⵊⵊ ⵏ ⵛⴱⴰⵔ ⵏ ⵓⴼⵓⵙ ⵓⵛⴰ ⵉⴳⴳⴰ ⵉⵊⵊ ⵏ ⵣⵣⵡⴰⵇ ⵏ ⵡⵓⵔⴻⵖ ⵖⴰⵔ ⵜⵎⴻⵡⵡⴰ ⵏⵏⴻⵙ ⵉ ⴷ ⴰⵙ ⴷⴷ-ⵉⵏⵏⴹⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","ⵉⵙⵙⴻⴼⵙⵉ ⴰⵙ ⴰⵔⴻⴱⵄⴰ ⵏ ⵜⴻⵅⵔⴰⵣⵉⵏ ⵏ ⵡⵓⵔⴻⵖ ⵓⵛⴰ ⵉⴳⴳⴰ ⵜⵉⵅⵔⴰⵣⵉⵏ ⵖⴰⵔ ⴰⵔⴻⴱⵄⴰ ⵏ ⵜⵖⴻⵎⵎⵓⵔⴰ ⵏⵏⵉ ⵉⴵⴰⵏ ⵖⴰⵔ ⴰⵔⴻⴱⵄⴰ ⵏ ⵉⴹⴰⵔⴻⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","ⵜⵓⵖⴰ ⵜⵉⵅⵔⴰⵣⵉⵏ ⵣⵣⴰⵜ ⵏ ⵜⵎⴰ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴷⴰⵢⵙⴻⵏⵜ ⵙⵙⵉⴷⴼⴻⵏ ⵉⵄⵓⵎⴰⴷ ⵉ ⵜⴰⵔⴻⴱⴱⵓⵜ, ⵃⵉⵎⴰ ⴰⴷ ⵣⵣⴰⵢⵙⴻⵏ ⴰⵔⴱⵓⵏ ⵜⴰⵣⴻⵡⴹⴰ. ");
INSERT INTO rift_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","ⵉⴳⴳⴰ ⵉⵄⵓⵎⴰⴷ ⵉ ⵜⴰⵔⴻⴱⴱⵓⵜ ⵣⴻⴳ ⵓⴽⴻⵛⵛⵓⴹ ⵏ ⵓⴽⴰⵙⵉⵢⴰ ⵓⵛⴰ ⵉⵖⴻⴵⴻⴼ ⵉ-ⵜⴻⵏ ⵙ ⵡⵓⵔⴻⵖ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵣⵣⴰⵢⵙⴻⵏ ⴰⵔⴱⵓⵏ ⵜⴰⵣⴻⵡⴹⴰ. ");
INSERT INTO rift_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","ⵉⴳⴳⴰ ⵍⴻⵇⵛⵓⵄ ⵉ ⵖⴰ ⵢⵉⵍⵉⵏ ⵅ ⵜⵣⴻⵡⴹⴰ ⵙ ⵡⵓⵔⴻⵖ ⵉⵚⴼⴰⵏ: ⵟⵟⴱⴰⵚⵉ ⵏⵏⴻⵙ ⴷ ⵜⵖⴻⵏⵊⴰⵢⵉⵏ ⵏⵏⴻⵙ ⴷ ⵍⴽⵉⵙⴰⵏ ⵏⵏⴻⵙ ⴷ ⵉⵖⴰⵔⵔⴰⴼⴻⵏ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵣⵣⴰⵢⵙⴻⵏ ⴽⴻⴱⴱⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","ⵉⴳⴳⴰ ⵍⵇⴻⵏⴷⵉⵍ ⵏ ⵡⵓⵔⴻⵖ ⵉⵚⴼⴰⵏ. ⵉⵄⴷⴻⵍ ⵍⵇⴻⵏⴷⵉⵍ ⵙ ⵡⴻⴼⴹⵉⵙ ⵏ ⵡⴻⵎⵣⵉⵍ: ⴰⴼⵓⴷ ⵅ ⵓⴹⴰⵔ ⵏⵏⴻⵙ ⴷ ⵉⵖⴰⴵⴻⵏ ⵏⵏⴻⵙ ⴷ ⵍⴽⵉⵙⴰⵏ ⵏⵏⴻⵙ ⴷ ⵜⵄⴻⴱⴱⵓⵣⵉⵏ ⵏⵏⴻⵙ ⵉ ⴷⴷ-ⵉⵜⵜⴰⵙⴻⵏ ⴰⴽ-ⴷ ⵏⵏⵓⵡⴰⵔⴰⵜ ⵏⵏⴻⵙ, ⴰⵇⴰ-ⵜⴻⵏ ⵎⴰⵔⵔⴰ ⵜⵓⵖⴰ ⵣⵣⴰⵢⴻⵙ ⴷⴷ-ⵉⵜⵜⴻⴼⴼⵖⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","ⵣⴻⴳ ⵉⵖⴻⵣⴷⵉⵙⴻⵏ ⵏⵏⴻⵙ ⴼⴼⵖⴻⵏ-ⴷⴷ ⵙⴻⵜⵜⴰ ⵏ ⵉⵖⴰⴵⴻⵏ, ⵜⵍⴰⵜⴰ ⵏ ⵉⵖⴰⴵⴻⵏ ⵏ ⵍⵇⴻⵏⴷⵉⵍ ⵣⴻⴳ ⵉⵊⵊ ⵏ ⵓⵖⴻⵣⴷⵉⵙ ⴷ ⵜⵍⴰⵜⴰ ⵏ ⵉⵖⴰⴵⴻⵏ ⵏ ⵍⵇⴻⵏⴷⵉⵍ ⵣⴻⴳ ⵓⵖⴻⵣⴷⵉⵙ ⵏⵏⴻⵖⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","ⵖⴰⵔ ⵉⵊⵊ ⵏ ⵓⵖⵉⵍ ⵜⵓⵖⴰ ⴷⵉⵏ ⵜⵍⴰⵜⴰ ⵏ ⵍⴽⵉⵙⴰⵏ ⴰⵎ ⵏⵏⴻⵡⵡⴰⵛ ⵏ ⴵⴻⵡⵣ ⵙ ⵜⵄⴻⴱⴱⵓⵣⵜ ⴷ ⵏⵏⴻⵡⵡⴰⵛ ⵓⵛⴰ ⵅ ⵓⵖⵉⵍ ⵏⵏⴻⵖⵏⵉ ⵄⴰⵡⴻⴷ ⵜⵍⴰⵜⴰ ⵏ ⵍⴽⵉⵙⴰⵏ ⴰⵎ ⵏⵏⴻⵡⵡⴰⵛ ⵏ ⴵⴻⵡⵣ ⵙ ⵉⵛⵜ ⵏ ⵜⵄⴻⴱⴱⵓⵣⵜ ⵉ ⴷⴷ-ⵉⵜⵜⴰⵙⴻⵏ ⴰⴽ-ⴷ ⵉⵊⵊ ⵏ ⵏⵏⴻⵡⵡⴰⵛ. ⴰⵎⵎⵓ ⵉ ⵢⴻⴵⴰⵏ ⵎⴰⵔⵔⴰ ⵙⴻⵜⵜⴰ ⵏ ⵉⵖⴰⴵⴻⵏ ⵏⵏⵉ ⴷⴷ-ⵉⵜⵜⴻⴼⴼⵖⴻⵏ ⵣⵉ ⵍⵇⴻⵏⴷⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","ⵖⴰⵔ ⵍⵇⴻⵏⴷⵉⵍ ⵙⵉⵎⴰⵏⵜ ⵏⵏⴻⵙ ⵜⵓⵖⴰ ⴷⵉⵏ ⴰⵔⴻⴱⵄⴰ ⵏ ⵍⴽⵉⵙⴰⵏ ⴰⵎ ⵏⵏⵓⵡⴰⵔⴰⵜ ⵏ ⴵⴻⵡⵣ ⴰⴽ-ⴷ ⵜⵄⴻⴱⴱⵓⵣⵉⵏ ⵏⵙⴻⵏ ⵉ ⴷⴷ-ⵉⵜⵜⴰⵙⴻⵏ ⴰⴽ-ⴷ ⵏⵏⵓⵡⴰⵔⴰⵜ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","ⵙⴰⴷⵓ ⵜⵢⵓⵢⴰ ⵏ ⵉⵖⴰⴵⴻⵏ ⵉ ⵣⵣⴰⵢⴻⵙ ⴷⴷ-ⵉⴼⴼⵖⴻⵏ ⴷ ⴰⵎⴻⵣⵡⴰⵔⵓ ⴰⵇⴰ ⴷⵉⵏ ⵉⵛⵜ ⵏ ⵜⵄⴻⴱⴱⵓⵣⵜ ⵓⵛⴰ ⴰⵎⴻⵏⵏⵉ ⵉ ⴷⵉⵏ ⵉⵛⵜ ⵏ ⵜⵄⴻⴱⴱⵓⵣⵜ ⵙⴰⴷⵓ ⵜⵢⵓⵢⴰ ⵏ ⵉⵖⴰⴵⴻⵏ ⵉ ⵣⵣⴰⵢⴻⵙ ⴷⴷ-ⵉⴼⴼⵖⴻⵏ ⴰⵡⴰⵔⵏⵉ ⴰⵙ ⵓⵛⴰ ⵄⴰⵡⴻⴷ ⴷⵉⵏ ⵉⵛⵜ ⵏ ⵜⵄⴻⴱⴱⵓⵣⵜ ⵙⴰⴷⵓ ⵜⵢⵓⵢⴰ ⵏ ⵉⵖⴰⴵⴻⵏ ⵉ ⵣⵣⴰⵢⴻⵙ ⴷⴷ-ⵉⴼⴼⵖⴻⵏ ⴷ ⴰⵏⴻⴳⴳⴰⵔⵓ. ⵎⴰⵏ ⴰⵢⴰ ⵉⴵⴰ ⴰⵎⴻⵏⵏⵉ ⵉ ⵙⴻⵜⵜⴰ ⵏ ⵉⵖⴰⴵⴻⵏ ⵉ ⵣⵣⴰⵢⴻⵙ ⴷⴷ-ⵉⴼⴼⵖⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","ⵜⵓⵖⴰ ⵜⵉⵄⴻⴱⴱⵓⵣⵉⵏ ⵏⵙⴻⵏ ⴷ ⵉⵖⴰⴵⴻⵏ ⵏⵙⴻⵏ ⴼⴼⵖⴻⵏ-ⴷⴷ ⵣⵣⴰⵢⴻⵙ. ⵎⴰⵔⵔⴰ ⴰⵢⴰ ⵜⵓⵖⴰ ⴷ ⵉⵛⵜ ⵏ ⵍⵅⴻⴷⵎⴻⵜ ⵏ ⵡⴻⵎⵣⵉⵍ ⵙ ⵡⵓⵔⴻⵖ ⵉⵚⴼⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","ⵉⴳⴳⴰ ⵙⴻⵜⵜⴰ ⵏ ⵍⴻⴼⵏⴰⵔⴰⵜ ⵏⵏⴻⵙ ⴰⴽ-ⴷ ⵜⵊⴻⵇⵇⴰⴹⵉⵏ ⵏ ⵜⴻⴼⵜⵉⵍⵜ ⵏⵏⴻⵙ ⴷ ⵜⵎⴻⵊⵎⴰⵔⵉⵏ ⵏⵏⴻⵙ, ⵎⴰⵔⵔⴰ ⵙ ⵡⵓⵔⴻⵖ ⵉⵚⴼⴰⵏ.    ");
INSERT INTO rift_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","ⵉⴳⴳⴰ ⵍⵇⴻⵏⴷⵉⵍ ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ ⵏⵏⴻⵙ ⵣⴻⴳ ⵉⵛⵜ ⵏ ⵜⴰⵍⵉⵏⵜ ⵏ ⵡⵓⵔⴻⵖ ⵉⵚⴼⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","ⵉⴳⴳⴰ ⴰⵄⴰⵍⵟⴰⵔ ⵏ ⵍⴻⴱⵅⵓⵔ ⵣⴻⴳ ⵓⴽⴻⵛⵛⵓⴹ ⵏ ⵜⵛⴻⵊⵊⴰⵔⵜ ⵏ ⵓⴽⴰⵙⵉⵢⴰ ⵙ ⵜⵓⵣⵣⴻⴳⴳⴰⵔⵜ ⵏⵏⴻⵙ ⵏ ⵉⵊⵊ ⵓⵖⵉⵍ ⵓ ⵜⵉⵔⵓ ⵏⵏⴻⵙ ⵏ ⵉⵊⵊ ⵏ ⵓⵖⵉⵍ. ⵜⵓⵖⴰ-ⵜ ⵙ ⴰⵔⴻⴱⵄⴰ ⵏ ⵜⵖⴻⵎⵎⵓⵔⴰ. ⵍⵓⵄⵍⴰ ⵏⵏⴻⵙ ⵜⵓⵖⴰ-ⵜ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵖⴰⴵⴻⵏ. ⵣⵣⴰⵢⴻⵙ ⵜⵓⵖⴰ ⴰⵛⵛⴰⵡⴻⵏ ⵏⵏⴻⵙ ⴷ ⵉⵊⵊ ⴰⴽⵉⴷⴻⵙ.    ");
INSERT INTO rift_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","ⵉⵖⴻⴵⴻⴼ ⵉ-ⵜ ⵙ ⵡⵓⵔⴻⵖ ⵉⵚⴼⴰⵏ, ⵓⴷⴻⵎ ⵏⵏⴻⵙ ⵏ ⵙⴻⵏⵏⴻⵊ ⴷ ⵉⵖⴻⵣⴷⵉⵙⴻⵏ ⵏⵏⴻⵙ ⵉ ⴷ ⴰⵙ ⴷⴷ-ⵉⵏⵏⴹⴻⵏ ⵓ ⵄⴰⵡⴻⴷ ⴰⵛⵛⴰⵡⴻⵏ ⵏⵏⴻⵙ. ⵉⴳⴳⴰ ⴰⵙ ⵉⵊⵊ ⵏ ⵣⵣⵡⴰⵇ ⵏ ⵡⵓⵔⴻⵖ ⵉ ⴷ ⴰⵙ ⴷⴷ-ⵉⵏⵏⴹⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","ⵉⴳⴳⴰ ⴰⵙ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵅⵔⴰⵣⵉⵏ ⵏ ⵡⵓⵔⴻⵖ ⵙⴰⴷⵓ ⵣⵣⵡⴰⵇ ⵏⵏⴻⵙ ⵉ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵖⴻⵎⵎⵓⵔⴰ ⵏⵏⴻⵙ, ⵖⴰⵔ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵖⴻⵣⴷⵉⵙⴻⵏ ⵏⵏⴻⵙ, ⵃⵉⵎⴰ ⴰⴷ ⴷⴰⵢⵙⴻⵏⵜ ⵙⵙⵉⴷⴼⴻⵏ ⵉⵄⵓⵎⴰⴷ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵣⵣⴰⵢⵙⴻⵏ ⴰⵔⴱⵓⵏ ⴰⵄⴰⵍⵟⴰⵔ ⵏ ⵍⴻⴱⵅⵓⵔ. ");
INSERT INTO rift_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","ⵉⴳⴳⴰ ⵉⵄⵓⵎⴰⴷ ⵉ ⵜⴰⵔⴻⴱⴱⵓⵜ ⵣⴻⴳ ⵓⴽⴻⵛⵛⵓⴹ ⵏ ⵓⴽⴰⵙⵉⵢⴰ ⵓⵛⴰ ⵉⵖⴻⴵⴻⴼ ⵉ-ⵜⴻⵏ ⵙ ⵡⵓⵔⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","ⵉⴳⴳⴰ ⵄⴰⵡⴻⴷ ⵣⵣⴻⵛⵜ ⵜⴰⵎⵇⴻⴷⴷⴻⵙⵜ ⵉ ⵡⴻⴷⵀⴰⵏ ⴷ ⵍⴻⴱⵅⵓⵔ ⵉⵚⴼⴰⵏ ⵉⵜⵜⴼⵓⵃⴻⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵚⵚⴻⵏⵄⴻⵜ ⵏ ⵓⵄⴻⵟⵟⴰⵍ. ");
INSERT INTO rift_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","ⵉⴳⴳⴰ ⴰⵄⴰⵍⵟⴰⵔ ⵏ ⵡⴻⵛⵎⴰⴹ ⵙ ⵓⴽⴻⵛⵛⵓⴹ ⵏ ⵓⴽⴰⵙⵉⵢⴰ. ⵜⵓⵣⵣⴻⴳⴳⴰⵔⵜ ⵏⵏⴻⵙ ⵜⵓⵖⴰ-ⵜⵜ ⵅⴻⵎⵙⴰ ⵏ ⵉⵖⴰⴵⴻⵏ ⵓ ⵜⵉⵔⵓ ⵏⵏⴻⵙ ⵅⴻⵎⵙⴰ ⵏ ⵉⵖⴰⴵⴻⵏ, ⵜⵓⵖⴰ-ⵜ ⵙ ⴰⵔⴻⴱⵄⴰ ⵏ ⵜⵖⴻⵎⵎⵓⵔⴰ, ⵓ ⵍⵓⵄⵍⴰ ⵏⵏⴻⵙ ⵜⵓⵖⴰ-ⵜ ⵜⵍⴰⵜⴰ ⵏ ⵉⵖⴰⴵⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","ⵖⴰⵔ ⴰⵔⴻⴱⵄⴰ ⵏ ⵜⵖⴻⵎⵎⵓⵔⴰ ⵉⴳⴳⴰ ⴰⵛⵛⴰⵡⴻⵏ ⵏⵏⴻⵙ. ⴰⵛⵛⴰⵡⴻⵏ ⵏⵏⴻⵙ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵊⵊⴻⵏ ⴰⴽⵉⴷⴻⵙ. ⵉⵖⴻⴵⴻⴼ ⵉ-ⵜ ⵙ ⵏⵏⵃⴰⵙ.    ");
INSERT INTO rift_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","ⵉⴳⴳⴰ ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ ⵉ ⵓⵄⴰⵍⵟⴰⵔ: ⵜⵉⵢⴷⵓⵔⵉⵏ ⴷ ⵉⵖⴻⵏⵊⴰⵢⴻⵏ ⴷ ⵟⵟⴰⵡⵢⴰⵜ ⵉ ⵓⵔⵓⵛⵛⵉ ⴷ ⴼⵓⵔⵛⴰⵢⴰⵜ ⴷ ⵜⵎⴻⵊⵎⴰⵔⵉⵏ, ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ-ⴰ ⵉⴳⴳⴰ ⵉ-ⵜⴻⵏ ⵙ ⵏⵏⵃⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","ⵉⴳⴳⴰ ⵉⵛⵜ ⵏ ⵜⵔⴰⵛⵛⴰ ⵉ ⵓⵄⴰⵍⵟⴰⵔ, ⵉⵊⵊ ⵏ ⵓⵎⵓⴷⵉ ⵏ ⵏⵏⵃⴰⵙ ⵙⴰⴷⵓ ⵜⵎⴰ ⵏⵏⴻⵙ, ⵙⵡⴰⴷⴷⴰⵢ ⵖⴰⵔ ⵡⴻⵣⵢⴻⵏ ⵏ ⵓⵄⴰⵍⵟⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","ⵉⵙⵙⴻⴼⵙⵉ ⴰⵔⴻⴱⵄⴰ ⵏ ⵜⴻⵅⵔⴰⵣⵉⵏ ⵉ ⴰⵔⴻⴱⵄⴰ ⵏ ⵉⵅⴼⴰⵡⴻⵏ ⵏ ⵜⵔⴰⵛⵛⴰ ⵏ ⵏⵏⵃⴰⵙ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴷⴰⵢⵙⴻⵏⵜ ⵙⵙⵉⴷⴼⴻⵏ ⵉⵄⵓⵎⴰⴷ ⵉ ⵜⴰⵔⴻⴱⴱⵓⵜ. ");
INSERT INTO rift_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","ⵉⴳⴳⴰ ⵉⵄⵓⵎⴰⴷ ⵉ ⵜⴰⵔⴻⴱⴱⵓⵜ ⵣⴻⴳ ⵓⴽⴻⵛⵛⵓⴹ ⵏ ⵓⴽⴰⵙⵉⵢⴰ ⵓⵛⴰ ⵉⵖⴻⴵⴻⴼ ⵉ-ⵜⴻⵏ ⵙ ⵏⵏⵃⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","ⵉⴳⴳⴰ ⵉⵄⵓⵎⴰⴷ ⵉ ⵜⴰⵔⴻⴱⴱⵓⵜ ⴷⵉ ⵜⴻⵅⵔⴰⵣⵉⵏ ⵖⴰⵔ ⵉⵖⴻⵣⴷⵉⵙⴻⵏ ⵏ ⵓⵄⴰⵍⵟⴰⵔ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵣⵣⴰⵢⵙⴻⵏ ⵜ ⴰⵔⴱⵓⵏ. ⵉⴳⴳⴰ ⵉ-ⵜ ⵙ ⵜⴼⴻⵍⵡⵉⵏ ⴰⴽ-ⴷ ⵍⵅⴰⵡⵉ ⴷⵉ ⴷⴰⵅⴻⵍ ⵏⵙⴻⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","ⵉⴳⴳⴰ ⵜⴰⴱⴰⵏⵢⵓⵜ ⵏ ⵏⵏⵃⴰⵙ ⵙ ⵓⴹⴰⵔ ⵏⵏⴻⵙ ⵏ ⵏⵏⵃⴰⵙ ⵣⵉ ⵜⵉⵙⵉⵜⵉⵏ ⵏ ⵜⴻⵔⴱⵉⵄⵉⵏ ⵏ ⵜⴻⵎⵖⴰⵔⵉⵏ ⵏⵏⵉ ⵅⴻⴷⵎⴻⵏⵜ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","ⵉⴳⴳⴰ ⵍⴻⵎⵔⴰⵃ. ⵖⴰⵔ ⵊⵊⵉⵀⴻⵜ ⵏ ⵍⵊⴰⵏⵓⴱ, ⵖⴰⵔ ⵢⴻⴼⵓⵙ, ⵜⵓⵖⴰ ⵜⵓⵣⵣⴻⴳⴳⴰⵔⵜ ⵏ ⵍⵉⵣⴰⵔⴰⵜ ⵏ ⵍⴻⵎⵔⴰⵃ ⵎⵢⴰ ⵏ ⵉⵖⴰⴵⴻⵏ ⵏ ⵍⴻⵇⵟⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵎⵓⴷⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","ⵄⵉⵛⵔⵉⵏ ⵏ ⵉⴱⵉⵍⴰⵔⴻⵏ ⵏⵏⴻⵙ ⴷ ⵄⵉⵛⵔⵉⵏ ⵏ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵏⵙⴻⵏ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⵏ ⵏⵏⵃⴰⵙ. ⵜⵉⵙⴻⵏⵏⴰⵔⵉⵏ ⵏ ⵉⴱⵉⵍⴰⵔⴻⵏ ⴷ ⵉⵇⴻⴹⴱⴰⵏ ⵏⵙⴻⵏ ⵉ ⵓⵙⴻⵍⵇⵉ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⵏ ⵏⵏⵓⵇⴰⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","ⵖⴰⵔ ⵓⵖⴻⵣⴷⵉⵙ ⵏ ⵛⵛⴰⵎⴰⵍ ⵜⵓⵖⴰ ⴷⵉⵏ ⵍⵉⵣⴰⵔⴰⵜ ⵙ ⵉⵛⵜ ⵏ ⵜⵓⵣⵣⴻⴳⴳⴰⵔⵜ ⵏ ⵎⵢⴰ ⵏ ⵉⵖⴰⴵⴻⵏ ⴰⴽ-ⴷ ⵄⵉⵛⵔⵉⵏ ⵏ ⵉⴱⵉⵍⴰⵔⴻⵏ ⵏⵙⴻⵏⵜ ⵓ ⴰⴽ-ⴷ ⵄⵉⵛⵔⵉⵏ ⵏ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵏⵙⴻⵏ ⵏ ⵏⵏⵃⴰⵙ. ⵜⵉⵙⴻⵏⵏⴰⵔⵉⵏ ⵏ ⵉⴱⵉⵍⴰⵔⴻⵏ ⴷ ⵉⵇⴻⴹⴱⴰⵏ ⵏⵙⴻⵏ ⵉ ⵓⵙⴻⵍⵇⵉ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⵏ ⵏⵏⵓⵇⴰⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","ⵖⴰⵔ ⵓⵖⴻⵣⴷⵉⵙ ⵏ ⵍⵖⴰⵔⴱ ⵜⵓⵖⴰ ⴷⵉⵏ ⵍⵉⵣⴰⵔⴰⵜ ⵏ ⵅⴻⵎⵙⵉⵏ ⵏ ⵉⵖⴰⴵⴻⵏ ⴰⴽ-ⴷ ⵄⴻⵛⵔⴰ ⵏ ⵉⴱⵉⵍⴰⵔⴻⵏ ⵏⵙⴻⵏⵜ ⴷ ⵄⴻⵛⵔⴰ ⵏ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵏⵙⴻⵏ. ⵜⵉⵙⴻⵏⵏⴰⵔⵉⵏ ⵏ ⵉⴱⵉⵍⴰⵔⴻⵏ ⴷ ⵉⵇⴻⴹⴱⴰⵏ ⵏⵙⴻⵏ ⵉ ⵓⵙⴻⵍⵇⵉ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⵏ ⵏⵏⵓⵇⴰⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","ⵖⴰⵔ ⵓⵖⴻⵣⴷⵉⵙ ⵏ ⵛⵛⴰⵔⵇ, ⵖⴰⵔ ⵊⵊⵉⵀⴻⵜ ⵏ ⵡⴻⵏⵇⴰⵔ ⵏ ⵜⴼⵓⵛⵜ, ⵜⵓⵖⴰ ⴷⵉⵏ ⵍⵉⵣⴰⵔⴰⵜ ⵏ ⵅⴻⵎⵙⵉⵏ ⵏ ⵉⵖⴰⴵⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","ⵜⵓⵖⴰ ⵍⵉⵣⴰⵔⴰⵜ ⵖⴰⵔ ⵉⵊⵊ ⵏ ⵓⵖⴻⵣⴷⵉⵙ ⵏ ⵣⵣⴰⵜ ⵅⴻⵎⵎⴻⵙⵟⴰⵛ ⵏ ⵉⵖⴰⴵⴻⵏ ⴷⵉ ⵜⵓⵣⵣⴻⴳⴳⴰⵔⵜ ⴰⴽ-ⴷ ⵜⵍⴰⵜⴰ ⵏ ⵉⴱⵉⵍⴰⵔⴻⵏ ⵏⵙⴻⵏⵜ ⴷ ⵜⵍⴰⵜⴰ ⵏ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","ⵖⴰⵔ ⵓⵖⴻⵣⴷⵉⵙ ⵏ ⵣⵣⴰⵜ ⵏⵏⴻⵖⵏⵉ ⵏ ⵡⴰⴷⴰⴼ ⵏ ⵍⴻⵎⵔⴰⵃ, ⵖⴰⵔ ⵓⵖⴻⵣⴷⵉⵙ-ⴰ ⴷ ⵓⵖⴻⵣⴷⵉⵙ ⵏⵏⵉ, ⵜⵓⵖⴰ ⵍⵉⵣⴰⵔⴰⵜ ⴷⴰⵢⵙⴻⵏⵜ ⵅⴻⵎⵎⴻⵙⵟⴰⵛ ⵏ ⵉⵖⴰⴵⴻⵏ ⴷⵉ ⵜⵓⵣⵣⴻⴳⴳⴰⵔⵜ, ⴰⴽ-ⴷ ⵜⵍⴰⵜⴰ ⵏ ⵉⴱⵉⵍⴰⵔⴻⵏ ⵏⵙⴻⵏⵜ ⴷ ⵜⵍⴰⵜⴰ ⵏ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","ⵎⴰⵔⵔⴰ ⵍⵉⵣⴰⵔⴰⵜ ⵏⵏⵉ ⴷ ⴰⵙ ⴷⴷ-ⵉⵏⵏⴹⴻⵏ ⵉ ⵍⴻⵎⵔⴰⵃ ⵜⵓⵖⴰ ⴰⵜⴻⵏⵜ ⵏ ⵍⴻⵇⵟⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵎⵓⴷⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","ⵜⵉⵢⴰⵔⵙⴰⵡⵉⵏ ⵏ ⵉⴱⵉⵍⴰⵔⴻⵏ ⵜⵓⵖⴰ ⴰⵜⴻⵏⵜ ⵏ ⵏⵏⵃⴰⵙ ⴷ ⵜⵙⴻⵏⵏⴰⵔⵉⵏ ⵏ ⵉⴱⵉⵍⴰⵔⴻⵏ ⴷ ⵉⵇⴻⴹⴱⴰⵏ ⵏⵙⴻⵏ ⵉ ⵓⵙⴻⵍⵇⵉ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⵙ ⵏⵏⵓⵇⴰⵔⵜ ⵓⵛⴰ ⵜⴰⴽⵓⵔⵙⵉⵜ ⵅ ⵜⵣⴻⴵⵉⴼⵉⵏ ⵏⵙⴻⵏ ⵜⵓⵖⴰ-ⵜⵜ ⵣⵉ ⵏⵏⵓⵇⴰⵔⵜ ⴷ ⵎⴰⵔⵔⴰ ⵉⴱⵉⵍⴰⵔⴻⵏ ⵏ ⵍⴻⵎⵔⴰⵃ ⵜⵓⵖⴰ ⵖⴰⵔⵙⴻⵏ ⵉⵇⴻⴹⴱⴰⵏ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵉ ⵓⵙⴻⵍⵇⵉ. ");
INSERT INTO rift_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","ⴰⵔⵡⴰⵇ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵍⴻⵎⵔⴰⵃ ⴳⴳⵉⵏ ⵜ ⴷ ⵉⵊⵊ ⵏ ⵓⵎⵓⴷⵉ ⵏ ⵓⵅⴻⵢⵢⴰⴹ ⵙ ⵓⴼⵉⵍⵓ ⴰⴷⴻⵃⵎⵉ ⴷ ⵓⵔⵊⵓⵡⴰⵏⵉ ⴷ ⵓⵣⴻⴳⴳⵯⴰⵖ ⵉⵃⴻⴷⵇⴻⵏ ⵓ ⵙ ⵍⴻⵇⵟⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵎⵓⴷⴻⵏ. ⵜⵓⵣⵣⴻⴳⴳⴰⵔⵜ ⵏⵏⴻⵙ ⵜⵓⵖⴰ ⵄⵉⵛⵔⵉⵏ ⵏ ⵉⵖⴰⴵⴻⵏ ⵓ ⵍⵓⵄⵍⴰ ⵅ ⵎⴰⵔⵔⴰ ⵜⵉⵔⵓ ⵏ ⵍⴻⵎⵔⴰⵃ ⵅⴻⵎⵙⴰ ⵏ ⵉⵖⴰⴵⴻⵏ, ⴰⵎ ⵍⵉⵣⴰⵔⴰⵜ ⵏ ⵍⴻⵎⵔⴰⵃ. ");
INSERT INTO rift_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","ⴰⵔⴻⴱⵄⴰ ⵏ ⵉⴱⵉⵍⴰⵔⴻⵏ ⴷ ⴰⵔⴻⴱⵄⴰ ⵏ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵏⵙⴻⵏ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⵙ ⵏⵏⵃⴰⵙ ⴷ ⵜⵙⴻⵏⵏⴰⵔⵉⵏ ⵏⵙⴻⵏ ⵙ ⵏⵏⵓⵇⴰⵔⵜ ⵓⵛⴰ ⵜⴰⴽⵓⵔⵙⵉⵜ ⵅ ⵜⵣⴻⴵⵉⴼⵉⵏ ⵏⵙⴻⵏ ⵓⵍⴰ ⴷ ⵉⵇⴻⴹⴱⴰⵏ ⵏⵙⴻⵏ ⵉ ⵓⵙⴻⵍⵇⵉ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⵙ ⵏⵏⵓⵇⴰⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","ⵎⴰⵔⵔⴰ ⵍⴻⵡⵜⴰⴷ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ ⴷ ⵍⴻⵎⵔⴰⵃ ⵉ ⴷ ⴰⵙ ⴷⴷ-ⵉⵏⵏⴹⴻⵏ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⵙ ⵏⵏⵃⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","ⵎⴰⵏ ⴰⵢⴰ ⴷ ⵎⵉⵏ ⵙⵙⵓⴼⴼⵖⴻⵏ ⵏⵉⵜⵏⵉ ⵉ ⵜⵣⴻⴷⴷⵉⵖⵜ, ⵜⴰⵣⴻⴷⴷⵉⵖⵜ ⵏ ⵛⵛⵀⴰⴷⴻⵜ, ⵓⵛⴰ ⵣⴻⵎⵎⴻⵏ ⵜ ⵙ ⵍⵓⵎⵓⵔ ⵏ ⵎⵓⵙⴰ ⵙ ⵜⵙⴻⵅⵅⴰⵔⵜ ⵏ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ, ⵙ ⵓⴼⵓⵙ ⵏ ⵉⵜⴰⵎⴰⵔ, ⵎⵎⵉⵙ ⵏ ⵀⴰⵔⵓⵏ, ⴰⴽⴻⵀⵀⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","ⴱⴰⵚⴰⵍⵉⵢⵉⵍ ⵎⵎⵉⵙ ⵏ ⵓⵔⵉ, ⵎⵎⵉⵙ ⵏ ⵃⵓⵔ, ⵣⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⵢⴰⵀⵓⴷⴰ, ⵉⴳⴳⴰ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴷ ⴰⵙ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","ⵜⵓⵖⴰ ⴰⴽⵉⴷⴻⵙ ⴰⵀⵓⵍⵉⵢⴰⴱ, ⵎⵎⵉⵙ ⵏ ⴰⵅⵉⵙⴰⵎⴰⴽ, ⵣⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⴷⴰⵏ. ⵜⵓⵖⴰ-ⵜ ⴷ ⴰⵏⴻⵇⵇⴰⵛ ⴷ ⴱⵓ-ⵚⵚⴻⵏⵄⴻⵜ, ⴰⵅⴻⵢⵢⴰⴹ ⵏ ⵓⴼⵉⵍⵓ ⴰⴷⴻⵃⵎⵉ ⴷ ⵓⵔⵊⵓⵡⴰⵏⵉ ⴷ ⵓⵣⴻⴳⴳⵯⴰⵖ ⵉⵃⴻⴷⵇⴻⵏ ⴷ ⵍⴻⵇⵟⴻⵏ ⴰⵣⴷⴰⴷ. ");
INSERT INTO rift_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","ⵎⴰⵔⵔⴰ ⵓⵔⴻⵖ ⵉ ⵙⵙⵅⴻⴷⵎⴻⵏ ⵏⵉⵜⵏⵉ ⵉ ⵍⵅⴻⴷⵎⴻⵜ ⵖⴰⵔ ⵎⴰⵔⵔⴰ ⵍⵅⴻⴷⵎⴻⵜ ⵉ ⵉⴳⴳⵉⵏ ⴷⵉ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ, ⵉⵅⵙ ⴰⴷ ⵢⵉⵏⵉ ⵓⵔⴻⵖ ⵏ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵏ ⵡⴻⵏⵀⴻⵣⵣⵉ, ⵜⵓⵖⴰ: ⵜⴻⵙⵄⴰ ⵓ-ⵄⵉⵛⵔⵉⵏ ⵜⴰⵍⵉⵏⵜ ⵓ ⵙⴻⴱⵄⴰ-ⵎⵢⴰ ⵓ-ⵜⵍⴰⵜⵉⵏ ⵛⵉⵇⵍⵓ ⵄⵍⴰⵃⵙⴰⴱ ⵛⵉⵇⵍⵓ ⵉⵇⴻⴷⴷⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","ⵏⵏⵓⵇⴰⵔⵜ ⵏ ⵢⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵏ ⵜⵎⴻⵙⵎⵓⵏⵜ ⵜⵓⵖⴰ-ⵜⵜ ⵎⵢⴰ ⵜⴰⵍⵉⵏⵜ ⴷ ⴰⵍⴻⴼ ⵓ-ⵙⴻⴱⵄⴰ-ⵎⵢⴰ ⵓ-ⵅⴻⵎⵙⴰ ⵓ-ⵙⴻⴱⵄⵉⵏ ⵛⵉⵇⵍⵓ, ⵄⵍⴰⵃⵙⴰⴱ ⵛⵉⵇⵍⵓ ⵉⵇⴻⴷⴷⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","ⵉⵊⵊ ⵏ ⵡⴻⵣⵢⴻⵏ ⵉ ⵢⵉⵊⵊ ⵏ ⴱⵏⴰⴷⴻⵎ, ⴰⵇⴰ-ⵜ ⴷ ⴰⵣⵢⴻⵏ ⵛⵉⵇⵍⵓ ⵄⵍⴰⵃⵙⴰⴱ ⵎⵉⵏ ⴷⴷ-ⵉⵜⵜⴰⵡⵉ ⵛⵉⵇⵍⵓ ⵉⵇⴻⴷⴷⵙⴻⵏ, ⵣⵉ ⵎⴰⵔⵔⴰ ⵡⵉ ⵉⵄⴷⵓⵏ ⵖⴰⵔ ⵢⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵣⵉ ⵄⵉⵛⵔⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵙⴻⵏⵏⴻⵊ, ⴷ ⵎⴰⵏ ⴰⵢⴰ ⵉ ⵙⴻⵜⵜⴰ-ⵎⵢⴰ ⵓ-ⵜⴻⵍⵜ-ⴰⵍⴰⴼ ⵓ-ⵅⴻⵎⵙⴰ-ⵎⵢⴰ ⵓ-ⵅⴻⵎⵙⵉⵏ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","ⵎⵢⴰ ⵜⴰⵍⵉⵏⵜ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵏⵏⵉ ⵜⵓⵖⴰ ⴰⵜⴻⵏⵜ ⵃⵉⵎⴰ ⴰⴷ ⵣⵣⴰⵢⵙⴻⵏⵜ ⵙⵙⴼⴻⵙⵢⴻⵏ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵏ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ ⴷ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵏ ⵓⵍⴻⵃⵃⴰⴼ: ⵎⵢⴰ ⵏ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵣⵉ ⵎⵢⴰ ⵜⴰⵍⵉⵏⵜ, ⵉⵅⵙ ⴰⴷ ⵢⵉⵏⵉ ⵉⵛⵜ ⵏ ⵜⴰⵍⵉⵏⵜ ⵉ ⵢⵉⵛⵜ ⵏ ⵜⵢⴰⵔⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","ⵣⴻⴳ ⵡⴰⵍⴻⴼ ⵓ-ⵙⴻⴱⵄⴰ-ⵎⵢⴰ ⵓ-ⵅⴻⵎⵙⴰ ⵓ-ⵙⴻⴱⵄⵉⵏ ⵛⵉⵇⵍⵓ ⵉⴳⴳⴰ ⵜⵉⵙⴻⵏⵏⴰⵔⵉⵏ ⵉ ⵉⴱⵉⵍⴰⵔⴻⵏ. ⵉⵖⴻⴵⴻⴼ ⵜⵉⵣⴻⴵⵉⴼⵉⵏ ⵏⵙⴻⵏ ⵓⵛⴰ ⵉⵛⴻⴷⴷ ⵖⴰⵔⵙⴻⵏ ⵉⵇⴻⴹⴱⴰⵏ ⵉ ⵓⵙⴻⵍⵇⵉ. ");
INSERT INTO rift_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","ⵏⵏⵃⴰⵙ ⵏ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵏ ⵡⴻⵏⵀⴻⵣⵣⵉ ⵜⵓⵖⴰ-ⵜ ⵙⴻⴱⵄⵉⵏ ⵜⴰⵍⵉⵏⵜ ⴷ ⴰⵍⴼⴰⵢⴻⵏ ⵓ-ⴰⵔⴻⴱⵄⴰ-ⵎⵢⴰ ⵛⵉⵇⵍⵓ. ");
INSERT INTO rift_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","ⵙ ⵎⴰⵏ ⴰⵢⴰ ⵉⴳⴳⴰ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵉ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⴷ ⵓⵄⴰⵍⵟⴰⵔ ⵏ ⵏⵏⵃⴰⵙ ⴷ ⵜⵔⴰⵛⵛⴰ ⵏⵏⴻⵙ ⵏ ⵏⵏⵃⴰⵙ ⴷ ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ");
INSERT INTO rift_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ⴷ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵏ ⵉⴱⵉⵍⴰⵔⴻⵏ ⵏ ⵍⴻⵎⵔⴰⵃ ⵉ ⴷ ⴰⵙ ⴷⴷ-ⵉⵏⵏⴹⴻⵏ ⴷ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵏ ⵡⴰⴷⴰⴼ ⵏ ⵍⴻⵎⵔⴰⵃ ⴷ ⵎⴰⵔⵔⴰ ⵍⴻⵡⵜⴰⴷ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ ⴷ ⵎⴰⵔⵔⴰ ⵍⴻⵡⵜⴰⴷ ⵏ ⵉⴱⵉⵍⴰⵔⴻⵏ ⵉ ⴷ ⴰⵙ ⴷⴷ-ⵉⵏⵏⴹⴻⵏ ⵉ ⵍⴻⵎⵔⴰⵃ. ");
INSERT INTO rift_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","ⴳⴳⵉⵏ ⵄⴰⵡⴻⴷ ⴰⵔⵔⵓⴹ ⵉ ⵜⵙⴻⵅⵅⴰⵔⵜ ⵙ ⵓⴼⵉⵍⵉ ⴰⴷⴻⵃⵎⵉ ⴷ ⵓⵔⵊⵓⵡⴰⵏⵉ ⴷ ⵓⵣⴻⴳⴳⵯⴰⵖ ⵉⵃⴻⴷⵇⴻⵏ, ⵃⵉⵎⴰ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵙⴻⵅⵅⴰⵔⴻⵏ ⵉⴽⴻⵀⵀⴰⵏⴻⵏ ⴷⵉ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ. ⵄⴰⵡⴻⴷ ⴳⴳⵉⵏ ⴰⵔⵔⵓⴹ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵉ ⵀⴰⵔⵓⵏ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵙ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","ⵉⴳⴳⴰ ⴰⴱⴰⵍⵟⵓ ⵏ ⵓⴽⴻⵀⵀⴰⵏ ⵙ ⵉⴼⵉⵍⴰⵏ ⵏ ⵡⵓⵔⴻⵖ ⵓ ⵙ ⵓⴼⵉⵍⵓ ⴰⴷⴻⵃⵎⵉ ⴷ ⵓⵔⵊⵓⵡⴰⵏⵉ ⴷ ⵓⵣⴻⴳⴳⵯⴰⵖ ⵉⵃⴻⴷⵇⴻⵏ ⵓ ⵙ ⵍⴻⵇⵟⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵎⵓⴷⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","ⵏⵉⵜⵏⵉ ⴱⴻⵣⵣⵄⴻⵏ ⵜⵉⵍⵡⵉⵃⵉⵏ ⵏ ⵡⵓⵔⴻⵖ ⵓⵛⴰ ⵇⴻⵙⵙⴻⵏ ⵣⵣⴰⵢⵙⴻⵏⵜ ⵉⴼⵉⵍⴰⵏ, ⵃⵉⵎⴰ ⴰⴷ ⵜⴻⵏ ⵅⴻⵢⵢⴹⴻⵏ ⵊⴰⵔ ⵓⴼⵉⵍⵓ ⴰⴷⴻⵃⵎⵉ ⴷ ⵓⵔⵊⵓⵡⴰⵏⵉ ⴷ ⵓⵣⴻⴳⴳⵯⴰⵖ ⵉⵃⴻⴷⵇⴻⵏ ⵓ ⵊⴰⵔ ⵍⴻⵇⵟⴻⵏ ⴰⵣⴷⴰⴷ, ⴷ ⵎⴰⵏ ⴰⵢⴰ ⵜⵓⵖⴰ ⴷ ⵉⵛⵜ ⵏ ⵍⵅⴻⴷⵎⴻⵜ ⴰⵎ ⵜⵜ ⵉⵜⵜⴻⴳⴳ ⵓⴼⴻⵏⵏⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","ⴳⴳⵉⵏ ⴰⵙ ⵜⵉⵖⴰⵔⴹⵉⵏ ⵉⵎⵙⴻⵍⵙⴰⵇⴻⵏ ⵓⵛⴰ ⵙⵙⵎⵓⵏⴻⵏ ⴰⴱⴰⵍⵟⵓ ⵖⴰⵔ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵅⴼⴰⵡⴻⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","ⵜⴰⵃⴻⵣⵣⴰⵎⵜ ⵉⵣⴻⵡⵡⵇⴻⵏ ⵉ ⵜⵓⵖⴰ ⵖⴰⵔ ⵓⴱⴰⵍⵟⵓ ⵏⵏⴻⵙ, ⵜⵓⵖⴰ ⵜⴻⵍⵙⴻⵇ ⴷⴰⵢⴻⵙ, ⵜⴻⴷⵡⴻⵍ ⴷ ⵉⵛⵜ ⴰⴽⵉⴷⴻⵙ. ⵜᵉⵜⵜⵡⴰⴳⴳ ⵜⵃⴻⵣⵣⴰⵎⵜ ⵙ ⵡⴻⴱⵔⵉⴷ ⴷ ⵉⵊⵊⴻⵏ ⴰⴽ-ⴷ ⵓⴱⴰⵍⵟⵓ ⵙ ⵉⴼⵉⵍⴰⵏ ⵏ ⵡⵓⵔⴻⵖ ⵓ ⵙ ⵓⴼⵉⵍⵓ ⴰⴷⴻⵃⵎⵉ ⴷ ⵓⵔⵊⵓⵡⴰⵏⵉ ⴷ ⵓⵣⴻⴳⴳⵯⴰⵖ ⵉⵃⴻⴷⵇⴻⵏ ⵓ ⵙ ⵍⴻⵇⵟⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵎⵓⴷⴻⵏ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","ⵏⵉⵜⵏⵉ ⴳⴳⵉⵏ ⵄⴰⵡⴻⴷ ⵉⵥⵔⴰ ⵏ ⵓⵏⵉⴽⵙ, ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵟⵟⴼⴻⵏ ⴷⵉ ⵜⵛⵓⵢⴰⵔ ⵏ ⵡⵓⵔⴻⵖ, ⵏⴻⵇⵛⴻⵏ ⵜⴻⵏ ⴰⵎ ⵢⵉⵊⵊ ⵏ ⵡⴻⵏⵇⴰⵛ ⵏ ⵜⵅⴰⴷⴻⵏⵜ ⵏ ⵓⵛⴻⵎⵎⵉⵄ ⵙ ⵉⵙⵎⴰⵡⴻⵏ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","ⵉⴳⴳⴰ ⵉ-ⵜⴻⵏ ⵅ ⵜⵖⴰⵔⴹⵉⵏ ⵏ ⵓⴱⴰⵍⵟⵓ, ⴰⵎ ⵉⵥⵔⴰ ⵏ ⵍⵉⴷⴰⵔⴻⵜ ⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","ⵉⴳⴳⴰ ⵜⴰⵊⵎⴻⵛⵜ, ⵉⵛⵜ ⵏ ⵍⵅⴻⴷⵎⴻⵜ ⴰⵎ ⵜⵜ ⵉⵜⵜⴻⴳⴳ ⵓⴼⴻⵏⵏⴰⵏ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵉⴳⴳⴰ ⴰⴱⴰⵍⵟⵓ, ⵙ ⵉⴼⵉⵍⴰⵏ ⵏ ⵡⵓⵔⴻⵖ ⵓ ⵙ ⵓⴼⵉⵍⵓ ⴰⴷⴻⵃⵎⵉ ⴷ ⵓⵔⵊⵓⵡⴰⵏⵉ ⴷ ⵓⵣⴻⴳⴳⵯⴰⵖ ⵉⵃⴻⴷⵇⴻⵏ ⵓ ⵙ ⵍⴻⵇⵟⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵎⵓⴷⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","ⵜⵓⵖⴰ-ⵜⵜ ⵙ ⴰⵔⴻⴱⵄⴰ ⵏ ⵜⵖⴻⵎⵎⵓⵔⴰ. ⴹⴻⴼⵙⴻⵏ ⵜⴰⵊⵎⴻⵛⵜ. ⵜⵓⵖⴰ ⵜⵓⵣⵣⴻⴳⴳⴰⵔⵜ ⵏⵏⴻⵙ ⴷ ⵉⵊⵊ ⵏ ⵡⴻⵣⵢⴻⵏ ⵏ ⵓⵖⵉⵍ ⵓⵛⴰ ⵓⵍⴰ ⴷ ⵜⵉⵔⵓ ⵏⵏⴻⵙ ⴷ ⵉⵊⵊ ⵏ ⵡⴻⵣⵢⴻⵏ ⵏ ⵓⵖⵉⵍ. ⵜⵓⵖⴰ ⵉⴹⴼⴻⵙ ⵅ ⵜⵏⴰⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","ⵙⴻⵜⵜⴼⴻⵏ ⴷⴰⵢⴻⵙ ⴰⵔⴻⴱⵄⴰ ⵏ ⵍⴻⵚⴼⵓⴼ ⵏ ⵢⴻⵥⵔⴰ: ⵉⵊⵊ ⵏ ⵚⵚⴻⴼ ⵙ ⵢⵉⵊⵊ ⵏ ⵍⴻⵄⵇⵉⵇ ⴷ ⴰⵣⴻⴳⴳⵡⴰⵖ ⴷ ⵉⵛⵜ ⵏ ⵜⵢⴰⵇⵓⵜ ⴷ ⵢⵉⵛⵜ ⵏ ⵙⵎⴰⵔⴰⵅⵜ. ⴷ ⵡⴰ ⴷ ⵚⵚⴻⴼ ⴰⵎⴻⵣⵡⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","ⵚⵚⴻⴼ ⵡⵉⵙⵙ ⵜⵏⴰⵢⴻⵏ ⵙ ⵢⵉⵊⵊ ⵏ ⴽⴰⵔⴱⵓⵏⴽⴻⵍ ⴷ ⵢⵉⵊⵊ ⵏ ⵚⴰⴼⴼⵉⵔ ⴰⵣⵉⵣⴰ ⴷ ⵢⵉⵊⵊ ⵏ ⴷⵉⴰⵎⴰⵏⵜⵉ. ");
INSERT INTO rift_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","ⵚⵚⴻⴼ ⵡⵉⵙⵙ ⵜⵍⴰⵜⴰ ⵙ ⵢⵉⵊⵊ ⵏ ⵡⴻⵥⵔⵓ ⵏ ⵢⴰⵙⵉⵏⵜⵓ ⴷ ⵢⵉⵊⵊ ⵏ ⴰⵅⴰⵜ ⴷ ⵢⵉⵊⵊ ⵓⵎⴰⵜⵉⵙⵜ. ");
INSERT INTO rift_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","ⵚⵚⴻⴼ ⵡⵉⵙⵙ ⴰⵔⴻⴱⵄⴰ ⵙ ⵢⵉⵛⵜ ⵏ ⵜⴻⵅⵔⵉⵙⵓⵍⵉⵜ ⴷ ⵢⵉⵊⵊ ⵏ ⵓⵏⵉⴽⵙ ⴷ ⵢⵉⵊⵊ ⵏ ⵢⴰⵙⴱⵉⵙ. ⵜⵓⵖⴰ ⵜⵜⵡⴰⵟⵟⴼⴻⵏ ⴷⵉ ⵜⵛⵓⵢⴰⵔ ⵏⵙⴻⵏ ⵏ ⵡⵓⵔⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","ⵉⵥⵔⴰ ⵜⵓⵖⴰ ⵅⴰⵙⴻⵏ ⵉⵙⵎⴰⵡⴻⵏ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵜⴻⵏⵄⴰⵛ ⵏ ⵢⴻⵥⵔⴰ ⵄⵍⴰⵃⵙⴰⴱ ⵉⵙⵎⴰⵡⴻⵏ ⵏⵙⴻⵏ, ⵙ ⵉⵏⴻⵇⵇⴰⵛⴻⵏ ⵏ ⵉⵊⵊ ⵏ ⵓⵛⴻⵎⵎⵉⵄ, ⴽⵓⵍ ⴰⵏⴻⵇⵇⴰⵛ ⴰⴽ-ⴷ ⵢⵉⵙⴻⵎ ⵏⵏⴻⵙ ⵉ ⴷ ⴰⵙ ⴷⴷ-ⵢⵓⵙⵉⵏ. ⴰⵇⴰ ⴰⵜⴻⵏ ⵉ ⵜⴻⵏⵄⴰⵛ ⵏ ⵜⵇⴻⴱⴱⴰⵍ. ");
INSERT INTO rift_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","ⵖⴰⵔ ⵉⵅⴼⴰⵡⴻⵏ ⵏ ⵜⴻⵊⵎⴻⵛⵜ ⴳⴳⵉⵏ ⵜⵉⵙⴻⴷⴷⵢⵉⵏ ⵙ ⵡⵓⵔⴻⵖ ⵉⵚⴼⴰⵏ, ⵜⵉⵏⵏⵉ ⵉⵎⵓⴷⴻⵏ ⴰⵎ ⵢⵉⵊⵊ ⵏ ⵓⴼⵉⵍⵓ. ");
INSERT INTO rift_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","ⴳⴳⵉⵏ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵛⵓⵢⴰⵔ ⵏ ⵡⵓⵔⴻⵖ ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵅⵔⴰⵣⵉⵏ ⵏ ⵡⵓⵔⴻⵖ ⵓⵛⴰ ⵛⴻⴷⴷⴻⵏ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵅⵔⴰⵣⵉⵏ ⵖⴰⵔ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵅⴼⴰⵡⴻⵏ ⵏ ⵜⴻⵊⵎⴻⵛⵜ. ");
INSERT INTO rift_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","ⵛⴻⴷⴷⴻⵏ ⵜⵏⴰⵢⴻⵏ ⵏ ⵙⵙⵏⴰⵙⴻⵍ ⵉⵎⵓⴷⴻⵏ ⵏ ⵡⵓⵔⴻⵖ ⵖⴰⵔ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵅⵔⴰⵣⵉⵏ ⵖⴰⵔ ⵉⵅⴼⴰⵡⴻⵏ ⵏ ⵜⴻⵊⵎⴻⵛⵜ. ");
INSERT INTO rift_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵅⴼⴰⵡⴻⵏ ⵏⵏⴻⵖⵏⵉ ⵏ ⵜⵏⴰⵢⴻⵏ ⵏ ⵙⵙⵏⴰⵙⴻⵍ ⵉⵎⵓⴷⴻⵏ, ⵛⴻⴷⴷⴻⵏ ⵜⴻⵏ ⵖⴰⵔ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵛⵓⵢⴰⵔ ⵓⵛⴰ ⵡⵛⵉⵏ ⵜⴻⵏ ⵅ ⵟⵖⴰⵔⴹⵉⵏ ⵏ ⵓⴱⴰⵍⵟⵓ, ⴷⴻⴳ ⵡⵓⴷⴻⵎ ⵏ ⵣⵣⴰⵜ. ");
INSERT INTO rift_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","ⴳⴳⵉⵏ ⵄⴰⵡⴻⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵅⵔⴰⵣⵉⵏ ⵏ ⵡⵓⵔⴻⵖ, ⵛⴻⴷⴷⴻⵏ ⵜⴻⵏⵜ ⵖⴰⵔ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵅⴼⴰⵡⴻⵏ ⵏⵏⴻⵖⵏⵉ ⵏ ⵜⴻⵊⵎⴻⵛⵜ, ⴷⵉ ⵜⵎⴰ ⵏⵏⴻⵙ ⵏⵏⵉ ⵇⵉⴱⴰⵍⵜ ⵉ ⵓⴱⴰⵍⵟⵓ, ⵖⴰⵔ ⴷⴰⵅⴻⵍ. ");
INSERT INTO rift_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","ⴳⴳⵉⵏ ⵄⴰⵡⴻⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵅⵔⴰⵣⵉⵏ ⵏ ⵡⵓⵔⴻⵖ, ⵛⴻⴷⴷⴻⵏ ⵜⴻⵏⵜ ⵅ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵖⴰⵔⴹⵉⵏ ⵏ ⵓⴱⴰⵍⵟⵓ ⵏ ⵓⴽⴻⵀⵀⴰⵏ, ⵙⵡⴰⴷⴷⴰⵢ, ⵖⴰⵔ ⵣⵣⴰⵜ, ⵇⵉⴱⴰⵍⵜ ⵉ ⵓⵙⴻⵍⵇⵉ ⵏⵏⴻⵙ ⵖⴰⵔ ⵙⴻⵏⵏⴻⵊ ⵉ ⵜⵃⴻⵣⵣⴰⵎⵜ ⵉⵣⴻⵡⵡⵇⴻⵏ ⵏ ⵓⴱⴰⵍⵟⵓ. ");
INSERT INTO rift_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","ⵓⵛⴰ ⵛⴻⴷⴷⴻⵏ ⵜⴰⵊⵎⴻⵛⵜ ⵙ ⵜⴻⵅⵔⴰⵣⵉⵏ ⵏⵏⴻⵙ ⵖⴰⵔ ⵜⴻⵅⵔⴰⵣⵉⵏ ⵏ ⵓⴱⴰⵍⵟⵓ ⵏ ⵓⴽⴻⵀⵀⴰⵏ ⴰⴽ-ⴷ ⵉⵊⵊ ⵏ ⵓⴼⵉⵍⵓ ⴰⴷⴻⵃⵎⵉ ⴰⵍⴰⵎⵉ ⵉⴷⵡⴻⵍ ⵙⴻⵏⵏⴻⵊ ⵉ ⵜⵃⴻⵣⵣⴰⵎⵜ ⵉⵣⴻⵡⵡⵇⴻⵏ ⵏ ⵓⴱⴰⵍⵟⵓ, ⵓⵛⴰ ⵅⴻⵏⵏⵉ ⵡⴰⵔ ⵜⴱⴻⵟⵟⵉ ⵜⴻⵊⵎⴻⵛⵜ ⵅ ⵓⴱⴰⵍⵟⵓ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","ⵉⴳⴳⴰ ⵄⴰⵡⴻⴷ ⴰⵙⴻⵍⵀⴰⵎ ⵏ ⵓⴱⴰⵍⵟⵓ ⵏ ⵓⴽⴻⵀⵀⴰⵏ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜ ⵉⵜⵜⴻⴳⴳ ⵓⵅⴻⵢⵢⴰⴹ, ⵜⵓⵖⴰ-ⵜ ⴷ ⴰⴷⴻⵃⵎⵉ ⵎⴰⵔⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","ⴰⵔⵣⴰⵎ ⵏ ⵓⵙⴻⵍⵀⴰⵎ ⵜⵓⵖⴰ-ⵜ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏⵏⴻⵙ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴳⴳⵉⵏ ⴰⵔⵣⴰⵎ ⵏ ⵢⵉⵔⵉ ⵏ ⵡⴰⵔⵔⵓⴹ ⵏ ⵡⵓⵣⵣⴰⵍ ⵏ ⵓⵄⴻⵙⴽⴰⵔⵉ. ⴷⴻⴳ ⵡⴻⵏⵏⴻⴹ ⵏ ⵡⴰⵔⵣⴰⵎ ⵜⵓⵖⴰ ⴷⵉⵏ ⵉⵛⵜ ⵏ ⵜⵎⴰ, ⵃⵉⵎⴰ ⵡⴰⵔ ⵉⵜⵜⵛⴰⵔⵔⵉⴳ. ");
INSERT INTO rift_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","ⵖⴰⵔ ⵜⵎⵓⵡⵡⴰ ⵏ ⵡⴰⴷⴷⴰⵢ ⵏ ⵓⵙⴻⵍⵀⴰⵎ ⴳⴳⵉⵏ ⵜⵉⵔⴻⵎⵎⴰⵏⵉⵏ ⵙ ⵓⴼⵉⵍⵓ ⴰⴷⴻⵃⵎⵉ ⴷ ⵓⵔⵊⵓⵡⴰⵏⵉ ⴷ ⵓⵣⴻⴳⴳⵯⴰⵖ ⵉⵃⴻⴷⵇⴻⵏ ⵣⴻⴳ ⵉⴼⵉⵍⴰⵏ ⵉⵎⵓⴷⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","ⴳⴳⵉⵏ ⵄⴰⵡⴻⴷ ⵏⵏⵡⴰⵇⴻⵙ ⵏ ⵡⵓⵔⴻⵖ ⵉⵚⴼⴰⵏ ⵓⵛⴰ ⵙⵙⴰⵔⵙⴻⵏ ⵏⵏⵡⴰⵇⴻⵙ ⵏⵏⵉ ⵊⴰⵔ ⵜⵔⴻⵎⵎⴰⵏⵉⵏ ⵖⴰⵔ ⵜⵎⵓⵡⵡⴰ ⵏ ⵡⴰⴷⴷⴰⵢ ⵏ ⵓⵙⴻⵍⵀⴰⵎ, ⴷⴻⴳ ⵡⴻⵏⵏⴻⴹ ⵊⴰⵔ ⵜⵔⴻⵎⵎⴰⵏⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","ⵉⵊⵊ ⵏ ⵏⵏⴰⵇⵓⵙ ⴷ ⵉⵛⵜ ⵏ ⵜⵔⴻⵎⵎⴰⵏⵜ, ⵅⴻⵏⵏⵉ ⵄⴰⵡⴻⴷ ⵉⵊⵊ ⵏ ⵏⵏⴰⵇⵓⵙ ⴷ ⵉⵛⵜ ⵏ ⵜⵔⴻⵎⵎⴰⵏⵜ ⵖⴰⵔ ⵜⵎⵓⵡⵡⴰ ⵏ ⵡⴰⴷⴷⴰⵢ ⵏ ⵓⵙⴻⵍⵀⴰⵎ ⴷⴻⴳ ⵡⴻⵏⵏⴻⴹ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴷⴰⵢⴻⵙ ⴳⴳⴻⵏ ⵜⴰⵙⴻⵅⵅⴰⵔⵜ ⵏⵙⴻⵏ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","ⴳⴳⵉⵏ ⵜⵛⴰⵎⵉⵔ ⵉ ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⵙ ⵍⴻⵇⵟⴻⵏ ⴰⵣⴷⴰⴷ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜ ⵉⵜⵜⴻⴳⴳ ⵓⵅⴻⵢⵢⴰⴹ, ");
INSERT INTO rift_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","ⴰⵔⴻⵥⵥⴻⵜ ⵏ ⵍⴻⵇⵟⴻⵏ ⴰⵣⴷⴰⴷ ⴷ ⵜⵛⵓⵛⵛⴰⵢ ⵉⵣⴻⵡⵡⵇⴻⵏ ⵏ ⵍⴻⵇⵟⴻⵏ ⴰⵣⴷⴰⴷ ⴷ ⵙⵙⵔⴰⵡⴻⵍ ⵏ ⵍⴻⵇⵟⴻⵏ ⵙ ⵍⴻⵇⵟⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵎⵓⴷⴻⵏ ");
INSERT INTO rift_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","ⵓ ⵜⵓⵖⴰ ⵜⴰⵃⴻⵣⵣⴰⵎⵜ ⵏ ⵍⴻⵇⵟⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵎⵓⴷⴻⵏ ⵓ ⵏ ⵓⴼⵉⵍⵓ ⴰⴷⴻⵃⵎⵉ ⴷ ⵓⵔⵊⵓⵡⴰⵏⵉ ⴷ ⵓⵣⴻⴳⴳⵯⴰⵖ ⵉⵃⴻⴷⵇⴻⵏ, ⴰⵇⴰ-ⵜⵜ ⴷ ⵉⵊⵊ ⵏ ⵓⵎⵓⴷⵉ ⵏ ⵓⵅⴻⵢⵢⴰⴹ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","ⴳⴳⵉⵏ ⵜⴰⵍⵡⵉⵃⵜ ⵙ ⵏⵏⵓⵡⴰⵔ ⵏ ⵜⵜⴰⵊ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵏ ⵡⴻⵄⵣⴰⵍ ⵙ ⵡⵓⵔⴻⵖ ⵉⵚⴼⴰⵏ ⵓⵛⴰ ⵏⴻⵇⵛⴻⵏ ⴷⴰⵢⴻⵙ ⵜⵉⵔⴰ-ⵢⴰ: “ⴰⵎⵇⴻⴷⴷⴰⵙ ⵉ ⵙⵉⴷⵉ!”, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵏⴻⵇⵛⴻⵏ ⵜⴰⵅⴰⴷⴻⵏⵜ ⵏ ⵓⵛⴻⵎⵎⵉⵄ. ");
INSERT INTO rift_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","ⵓⵛⴰ ⵛⴻⴷⴷⴻⵏ ⴰⵙ ⵉⵊⵊ ⵏ ⵓⴼⵉⵍⵓ ⵉⵎⵓⴷⴻⵏ ⴰⴷⴻⵃⵎⵉ, ⵃⵉⵎⴰ ⴰⴷ ⵜⵜ ⴰⵢⵍⴻⵏ ⵙⴻⵏⵏⴻⵊ ⵉ ⴰⵔⴻⵥⵥⴻⵜ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","ⴰⵎⵎⵓ ⵉ ⵜⴽⴻⵎⵎⴻⵍ ⵎⴰⵔⵔⴰ ⵍⵅⴻⴷⵎⴻⵜ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ, ⴰⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴰⵇⴰ ⴳⴳⵉⵏ ⵜⵜ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ, ⴰⵎⵎⵓ ⵉ ⵜⵜ ⴳⴳⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","ⴽⵙⵉⵏ ⵜⴰⵣⴻⴷⴷⵉⵖⵜ ⵖⴰⵔ ⵎⵓⵙⴰ, ⴰⵇⵉⴹⵓⵏ ⴷ ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ ⵏⵏⴻⵙ ⴷ ⵜⵙⴻⵏⵏⴰⵔⵉⵏ ⵏⵏⴻⵙ ⴷ ⵜⴼⴻⵍⵡⵉⵏ ⵏⵏⴻⵙ ⴷ ⵜⵃⴻⵏⵢⴰ ⵏⵏⴻⵙ ⵏ ⵓⵄⴰⵔⵔⴻⴹ ⴷ ⵉⴱⵉⵍⴰⵔⴻⵏ ⵏⵏⴻⵙ ⴷ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵏⵏⴻⵙ ");
INSERT INTO rift_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ⴷ ⵜⵙⴻⵇⵇⴰⴼⵜ ⵏ ⵉⵍⵎⴰⵡⴻⵏ ⵉⵣⴻⴳⴳⵯⴰⵖⴻⵏ ⵏ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ ⴷ ⵜⵙⴻⵇⵇⴰⴼⵜ ⵏ ⵉⵍⵎⴰⵡⴻⵏ ⵏ ⴷⴷⴻⵏⴼⵉⵍⴰⵜ ⴷ ⵓⵍⴻⵃⵃⴰⴼ ⵉ ⴷⴷⵓⵔⵉ, ");
INSERT INTO rift_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","ⵜⵜⴰⴱⵓⵜ ⵏ ⵛⵛⵀⴰⴷⴻⵜ ⴷ ⵉⵄⵓⵎⴰⴷ ⵏⵏⴻⵙ ⵉ ⵜⴰⵔⴻⴱⴱⵓⵜ ⴷ ⵜⵇⴻⴱⴱⴰⵔⵜ ⵏ ⵡⴻⵚⵍⴰⵃ ");
INSERT INTO rift_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","ⴷ ⵜⴰⵣⴻⵡⴹⴰ ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ ⵏⵏⴻⵙ ⴷ ⵡⴻⵖⵔⵓⵎ ⵏ ⵡⴻⵙⵛⴰⵏ ");
INSERT INTO rift_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","ⴷ ⵍⵇⴻⵏⴷⵉⵍ ⵏ ⵡⵓⵔⴻⵖ ⵉⵚⴼⴰⵏ ⴷ ⵍⴻⴼⵏⴰⵔⴰⵜ ⵏⵏⴻⵙ - ⵍⴻⴼⵏⴰⵔⴰⵜ ⵏⵏⵉ ⵜⵓⵖⴰ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜⵜⵡⴰⵙⵙⵡⴻⵊⴷⴻⵏⵜ, ⴷ ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ ⵏⵏⴻⵙ ⴷ ⵣⵣⴻⵛⵜ ⵉ ⵜⴼⴰⵡⵜ - ");
INSERT INTO rift_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","ⴷ ⵓⵄⴰⵍⵟⴰⵔ ⵏ ⵡⵓⵔⴻⵖ ⴷ ⵣⵣⴻⵛⵜ ⵉ ⵡⴻⴷⵀⴰⵏ ⴷ ⵍⴻⴱⵅⵓⵔ ⵉⵜⵜⴼⵓⵃⴻⵏ ⴷ ⴰⵔⵡⴰⵇ ⵉ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ");
INSERT INTO rift_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ⴷ ⵓⵄⴰⵍⵟⴰⵔ ⵏ ⵏⵏⵃⴰⵙ ⵙ ⵜⵔⴰⵛⵛⴰ ⵏ ⵏⵏⵃⴰⵙ ⴷ ⵉⵄⵓⵎⴰⴷ ⵏⵏⴻⵙ ⵉ ⵜⴰⵔⴻⴱⴱⵓⵜ ⴷ ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ ⵏⵏⴻⵙ ⴷ ⵜⴱⴰⵏⵢⵓⵜ ⴰⴽ-ⴷ ⵓⴹⴰⵔ ⵏⵏⴻⵙ ");
INSERT INTO rift_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ⴷ ⵍⵉⵣⴰⵔⴰⵜ ⵏ ⵍⴻⵎⵔⴰⵃ ⴰⴽ-ⴷ ⵉⴱⵉⵍⴰⵔⴻⵏ ⵏⵙⴻⵏⵜ ⴷ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵏⵙⴻⵏ, ⵓⵍⴰ ⴷ ⴰⵔⵡⴰⵇ ⵏ ⵡⴰⴷⴰⴼ ⵏ ⵍⴻⵎⵔⴰⵃ ⴷ ⵉⴼⵉⵍⴰⵏ ⵏⵏⴻⵙ ⴷ ⵍⴻⵡⵜⴰⴷ ⵏⵏⴻⵙ ⴷ ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ ⵉ ⵜⵙⴻⵅⵅⴰⵔⵜ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ, ⵉ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ");
INSERT INTO rift_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","ⵓⵍⴰ ⴷ ⴰⵔⵔⵓⴹ ⵉ ⵜⵙⴻⵅⵅⴰⵔⵜ, ⵃⵉⵎⴰ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵙⴻⵅⵅⴰⵔⴻⵏ ⵉⴽⴻⵀⵀⴰⵏⴻⵏ ⴷⵉ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ, ⴰⵔⵔⵓⴹ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵉ ⵓⴽⴻⵀⵀⴰⵏ ⵀⴰⵔⵓⵏ ⴷ ⴰⵔⵔⵓⴹ ⵉ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ, ⵃⵉⵎⴰ ⴰⴷ ⵙⴻⵅⵅⴰⵔⴻⵏ ⴷ ⵉⴽⴻⵀⵀⴰⵏⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","ⴳⴳⵉⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵎⴰⵔⵔⴰ ⵍⵅⴻⴷⵎⴻⵜ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵎⴰⵔⵔⴰ ⵉ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","ⵉⵅⵣⴰⵔ ⵎⵓⵙⴰ ⵖⴰⵔ ⵎⴰⵔⵔⴰ ⵍⵅⴻⴷⵎⴻⵜ ⵓⵛⴰ ⵉⵥⵔⴰ ⴱⴻⵍⵍⵉ ⵜᵉⵜⵜⵡⴰⴳⴳ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ, ⵡⴰⵀ, ⴰⵎⵎⵓ ⵉ-ⵜⵜ ⴳⴳⵉⵏ. ⵓⵛⴰ ⵉⴱⴰⵔⴽ ⵉ-ⵜⴻⵏ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“ⴷⴻⴳ ⵡⴰⵙⵙ ⴰⵎⴻⵣⵡⴰⵔⵓ ⵏ ⵓⵢⵓⵔ ⴰⵎⴻⵣⵡⴰⵔⵓ ⴰⴷ ⵜⴻⵙⵙⴳⴻⵄⵄⴷⴻⴷ ⵜⴰⵣⴻⴷⴷⵉⵖⵜ, ⴰⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","ⴰⴷ ⴷⴰⵢⴻⵙ ⵜⴻⴳⴳⴻⴷ ⵜⵜⴰⴱⵓⵜ ⵏ ⵛⵛⵀⴰⴷⴻⵜ ⵓⵛⴰ ⴰⴷ ⵜⴻⴷⵍⴻⴷ ⵜⵜⴰⴱⵓⵜ ⵙ ⵓⵍⴻⵃⵃⴰⴼ. ");
INSERT INTO rift_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","ⴰⴷ ⵜⴻⵙⵙⵉⴷⴼⴻⴷ ⵜⴰⵣⴻⵡⴹⴰ ⵓⵛⴰ ⴰⴷ ⵜⵜ ⵜⵙⴻⵜⵜⴼⴻⴷ ⴰⵙⴻⵜⵜⴻⴼ ⵏⵏⴻⵙ. ⴰⴷ ⵜⴻⵙⵙⵉⴷⴼⴻⴷ ⵍⵇⴻⵏⴷⵉⵍ ⵓⵛⴰ ⴰⴷ ⵜⴻⵙⵙⵉⵖⴻⴷ ⵍⴻⴼⵏⴰⵔⴰⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","ⴰⴷ ⵜⴻⵙⵙⴰⵔⵙⴻⴷ ⴰⵄⴰⵍⵟⴰⵔ ⵏ ⵡⵓⵔⴻⵖ ⵉ ⵍⴻⴱⵅⵓⵔ ⵣⵣⴰⵜ ⵉ ⵜⵜⴰⴱⵓⵜ ⵏ ⵛⵛⵀⴰⴷⴻⵜ ⵓⵛⴰ ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⴰⵔⵡⴰⵇ ⵏ ⵡⴰⴷⴰⴼ ⵣⵣⴰⵜ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ. ");
INSERT INTO rift_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","ⴰⴷ ⵜⴻⵙⵙⴰⵔⵙⴻⴷ ⴰⵄⴰⵍⵟⴰⵔ ⵏ ⵡⴻⵛⵎⴰⴹ ⵣⵣⴰⵜ ⵉ ⵡⴰⴷⴰⴼ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ, ⴰⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","ⴰⴷ ⵜⴻⵙⵙⴰⵔⵙⴻⴷ ⵜⴰⴱⴰⵏⵢⵓⵜ ⵊⴰⵔ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⴷ ⵓⵄⴰⵍⵟⴰⵔ ⵓⵛⴰ ⴰⴷ ⴷⴰⵢⴻⵙ ⵜⴻⴳⴳⴻⴷ ⴰⵎⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","ⴰⴷ ⵜⴻⵙⵙⴱⴻⴷⴷⴻⴷ ⵍⴻⵎⵔⴰⵃ ⵖⴰⵔ ⵎⴰⵔⵔⴰ ⵉⵖⴻⵣⴷⵉⵙⴻⵏ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⵜⴰⵢⵍⴻⴷ ⴰⵔⵡⴰⵇ ⵏ ⵡⴰⴷⴰⴼ ⵏ ⵍⴻⵎⵔⴰⵃ. ");
INSERT INTO rift_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","ⴰⴷ ⵜⴻⴽⵙⵉⴷ ⵣⵣⴻⵛⵜ ⵉ ⵡⴻⴷⵀⴰⵏ ⵓⵛⴰ ⴰⴷ ⵜⴷⴻⵀⵏⴻⴷ ⵜⴰⵣⴻⴷⴷⵉⵖⵜ ⴷ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴷⴰⵢⴻⵙ ⵉⴵⴰⵏ. ⴰⴷ ⵜⵜ ⵜⴻⵙⵙⵇⴻⴷⴷⵙⴻⴷ ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ ⵏⵏⴻⵙ. ⴰⴷ ⵜⵉⵍⵉ ⵏⴻⵜⵜⴰⵜ ⴷ ⵜⴰⵎⵇⴻⴷⴷⴰⵙⵜ. ");
INSERT INTO rift_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","ⴰⴷ ⵜⴷⴻⵀⵏⴻⴷ ⴰⵄⴰⵍⵟⴰⵔ ⵏ ⵡⴻⵛⵎⴰⴹ ⵙ ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ ⵏⵏⴻⵙ. ⴰⴷ ⵜⴻⵙⵙⵇⴻⴷⴷⵙⴻⴷ ⴰⵄⴰⵍⵟⴰⵔ. ⴰⵄⴰⵍⵟⴰⵔ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⴰⵎⵇⴻⴷⴷⴰⵙ ⵇⴰⵄ. ");
INSERT INTO rift_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","ⴰⴷ ⵜⴷⴻⵀⵏⴻⴷ ⵜⴰⴱⴰⵏⵢⵓⵜ ⴷ ⵓⴹⴰⵔ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⵜⵜ ⵜⴻⵙⵙⵇⴻⴷⴷⵙⴻⴷ. ");
INSERT INTO rift_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","ⴰⴷ ⴷⴷ-ⵜⴻⵙⵙⵇⴰⵔⵔⴱⴻⴷ ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⵓⵛⴰ ⴰⴷ ⵜⴻⵏ ⵜⴻⵙⵙⵉⵔⴷⴻⴷ ⵙ ⵡⴰⵎⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","ⴰⴷ ⵜⴻⵙⵙⵢⴰⵔⴹⴻⴷ ⵉ ⵀⴰⵔⵓⵏ ⴰⵔⵔⵓⴹ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵓⵛⴰ ⴰⴷ ⵜ ⵜⴷⴻⵀⵏⴻⴷ ⵓⵛⴰ ⴰⴷ ⵜ ⵜⴻⵙⵙⵇⴻⴷⴷⵙⴻⴷ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴰⵢⵉ ⵢⵉⵍⵉ ⴷ ⴰⴽⴻⵀⵀⴰⵏ ⵉ ⵏⴻⵛⵛ. ");
INSERT INTO rift_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","ⵅⴻⵏⵏⵉ ⴰⴷ ⴷⴷ-ⵜⴻⵙⵙⵇⴰⵔⵔⴱⴻⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⴰⵙⴻⵏ ⵜⵢⴰⵔⴹⴻⴷ ⵜⵛⴰⵎⵉⵔⴰⵜ. ");
INSERT INTO rift_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","ⴰⴷ ⵜⴻⵏ ⵜⴷⴻⵀⵏⴻⴷ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⴷⴻⵀⵏⴻⴷ ⴱⴰⴱⴰⵜⵙⴻⵏ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴰⵢⵉ ⵙⴻⵅⵅⴰⵔⴻⵏ ⴰⵎ ⵢⵉⴽⴻⵀⵀⴰⵏⴻⵏ. ⴰⴷ ⵢⵉⵍⵉ ⵡⴻⴷⵀⴰⵏ ⵏⵙⴻⵏ ⵉ ⵏⵉⵜⵏⵉ ⴷ ⵉⵛⵜ ⵏ ⵜⵓⴽⴻⵀⵀⴰⵏⵜ ⵉ ⵍⴻⴱⴷⴰ ⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵏⵙⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","ⵉⴳⴳⴰ ⵎⵓⵙⴰ ⵎⴰⵔⵔⴰ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ, ⵡⴰⵀ, ⴰⵎⵎⵓ ⵉ ⵜ ⵉⴳⴳⴰ. ");
INSERT INTO rift_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","ⵉⵎⵙⴰⵔ ⴷⴻⴳ ⵓⵢⵓⵔ ⴰⵎⴻⵣⵡⴰⵔⵓ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵡⵉⵙⵙ ⵜⵏⴰⵢⴻⵏ, ⴷⴻⴳ ⵡⴰⵙⵙ ⴰⵎⴻⵣⵡⴰⵔⵓ ⵏ ⵓⵢⵓⵔ, ⴰⵇⴰ ⵙⵙⴳⴻⵄⵄⴷⴻⵏ ⵜⴰⵣⴻⴷⴷⵉⵖⵜ. ");
INSERT INTO rift_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","ⵎⵓⵙⴰ ⵉⵙⵙⴳⴻⵄⵄⴻⴷ ⵜⴰⵣⴻⴷⴷⵉⵖⵜ, ⵉⵙⵙⴰⵔⵙ ⵜⵉⵢⴰⵔⵙⴰⵡⵉⵏ ⵏⵏⴻⵙ, ⵉⴳⴳⴰ ⴷⴰⵢⵙⴻⵏⵜ ⵜⵉⴼⴻⵍⵡⵉⵏ, ⵉⴳⴳⴰ ⵅⴰⵙⴻⵏⵜ ⵜⵉⵃⴻⵏⵢⴰ ⵏ ⵓⵄⴰⵔⵔⴻⴹ ⵜⵉⵏⵏⵉ ⵅⴰⵙⴻⵏⵜ ⵉⵥⵡⴰⵏ, ⵓⵛⴰ ⵉⵙⵙⴱⴻⴷⴷ ⵉⴱⵉⵍⴰⵔⴻⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","ⵉⴱⴻⵣⵣⴻⵄ ⴰⵇⵉⴹⵓⵏ ⵅ ⵜⵣⴻⴷⴷⵉⵖⵜ ⵓⵛⴰ ⵉⵙⵙⴰⵔⵙ ⵅⴰⵙ ⵜⴰⵙⴻⵇⵇⴰⴼⵜ ⵏ ⵓⵇⵉⴹⵓⵏ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","ⵉⴽⵙⵉ ⵛⵛⵀⴰⴷⴻⵜ ⵓⵛⴰ ⵉⵙⵙⴰⵔⵙ ⵉ-ⵜⵜ ⴷⴰⵅⴻⵍ ⴷⵉ ⵜⵜⴰⴱⵓⵜ ⵓⵛⴰ ⵉⵛⴻⴷⴷ ⵉⵄⵓⵎⴰⴷ ⵉ ⵜⴰⵔⴻⴱⴱⵓⵜ ⵖⴰⵔ ⵜⵜⴰⴱⵓⵜ ⵓⵛⴰ ⵉⵙⵙⴰⵔⵙ ⵜⴰⵇⴻⴱⴱⴰⵔⵜ ⵏ ⵡⴻⵚⵍⴰⵃ ⵅ ⵜⵜⴰⴱⵓⵜ. ");
INSERT INTO rift_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","ⵉⵙⵙⵉⴷⴻⴼ ⵜⵜⴰⴱⵓⵜ ⴷⵉ ⵜⵣⴻⴷⴷⵉⵖⵜ ⵓⵛⴰ ⵢⵓⵢⴻⵍ ⴰⵍⴻⵃⵃⴰⴼ ⴰⵎ ⴷⴷⵓⵔⵉ ⵓⵛⴰ ⵉⵙⵙⴷⵓⵔⵉⵢ ⵜⵜⴰⴱⵓⵜ ⵏ ⵛⵛⵀⴰⴷⴻⵜ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","ⵉⵙⵙⴰⵔⵙ ⵜⴰⵣⴻⵡⴹⴰ ⴷⴻⴳ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ⵖⴰⵔ ⵓⵖⴻⵣⴷⵉⵙ ⵏ ⵛⵛⴰⵎⴰⵍ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ, ⵖⴰⵔ ⴱⴰⵔⵔⴰ ⵏ ⵓⵍⴻⵃⵃⴰⴼ. ");
INSERT INTO rift_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","ⵉⵙⴻⵜⵜⴻⴼ ⵅⴰⵙ ⴰⵖⵔⵓⵎ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","ⵉⵙⵙⴰⵔⵙ ⵍⵇⴻⵏⴷⵉⵍ ⴷⴻⴳ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ⵏⵉⵛⴰⵏ ⴷⴻⴳ ⵓⵔⴻⵏⴷⴰⴷ ⵏ ⵜⵣⴻⵡⴹⴰ, ⵖⴰⵔ ⵊⵊⵉⵀⴻⵜ ⵏ ⵍⵊⴰⵏⵓⴱ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ. ");
INSERT INTO rift_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","ⵉⵙⵙⴰⵔⵙ ⵅⴰⵙ ⵜⵉⴼⵜⵉⵍⵉⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","ⵉⵡⵛⴰ ⴰⵎⵛⴰⵏ ⵉ ⵓⵄⴰⵍⵟⴰⵔ ⵏ ⵡⵓⵔⴻⵖ ⴷⴻⴳ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⵣⵣⴰⵜ ⵉ ⵓⵍⴻⵃⵃⴰⴼ. ");
INSERT INTO rift_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","ⵉⵙⵙⴱⴻⵅⵅⴰⵔ ⵅⴰⵙ ⵍⴻⴱⵅⵓⵔ ⵉⵜⵜⴼⵓⵃⴻⵏ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","ⵢⵓⵢⴻⵍ ⴰⵔⵡⴰⵇ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ. ");
INSERT INTO rift_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","ⵉⵡⵛⴰ ⴰⵎⵛⴰⵏ ⵉ ⵓⵄⴰⵍⵟⴰⵔ ⵏ ⵡⴻⵛⵎⴰⴹ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ, ⴰⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ⵉⵙⵙⴱⴻⵅⵅⴰⵔ ⵅⴰⵙ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","ⵉⵙⵙⴰⵔⵙ ⵜⴰⴱⴰⵏⵢⵓⵜ ⵊⴰⵔ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⴷ ⵓⵄⴰⵍⵟⴰⵔ. ⵉⴳⴳⴰ ⴷⴰⵢⴻⵙ ⴰⵎⴰⵏ ⵉ ⵓⵙⵉⵔⴷ. ");
INSERT INTO rift_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⵙⵙⵉⵔⴷⴻⵏ ⵣⵣⴰⵢⴻⵙ ⵉⴼⴰⵙⵙⴻⵏ ⴷ ⵉⴹⴰⵔⴻⵏ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","ⵍⴰⵎⵉ ⵜⵓⵖⴰ ⵜⵜⴰⴷⴼⴻⵏ ⵖⴰⵔ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⵓ ⵍⴰⵎⵉ ⴷⴷ-ⵜⵜⵇⴰⵔⵔⴰⴱⴻⵏ ⵖⴰⵔ ⵓⵄⴰⵍⵟⴰⵔ, ⵙⵙⵉⵔⴷⴻⵏ ⵉⵅⴻⴼ ⵏⵙⴻⵏ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","ⵖⴰⵔ ⵎⴰⵔⵔⴰ ⵉⵖⴻⵣⴷⵉⵙⴻⵏ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ ⴷ ⵓⵄⴰⵍⵟⴰⵔ ⵉⵜⵜⵡⴰⴳⴳ ⴰⵙ-ⴷⴷ ⵍⴻⵎⵔⴰⵃ ⵓⵛⴰ ⵢⵓⵢⴻⵍ ⵏⴻⵜⵜⴰ ⴰⵔⵡⴰⵇ ⵏ ⵡⴰⴷⴰⴼ ⵏ ⵍⴻⵎⵔⴰⵃ. ⴰⵎⵎⵓ ⵉ ⵉⴽⴻⵎⵎⴻⵍ ⵎⵓⵙⴰ ⵍⵅⴻⴷⵎⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","ⵅⴻⵏⵏⵉ ⵉⴷⵍⴰ ⵓⵙⴻⵢⵏⵓ ⴰⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⵓⵛⴰ ⴰⵄⵓⴵⵉ ⵏ ⵙⵉⴷⵉ ⵉⵛⵛⵓⵔ ⵜⴰⵣⴻⴷⴷⵉⵖⵜ. ");
INSERT INTO rift_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","ⵡⴰⵔ ⵉⵣⴻⵎⵎⴰⵔ ⵎⵓⵙⴰ ⴰⴷ ⵢⴰⴷⴻⴼ ⵖⴰⵔ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ⵎⵉⵏⵣⵉ ⴰⵙⴻⵢⵏⵓ ⵢⴰⵔⵙⴰ ⵅⴰⵙ ⵓ ⴰⵄⵓⴵⵉ ⵏ ⵙⵉⴷⵉ ⵉⵛⵛⵓⵔ ⵜⴰⵣⴻⴷⴷⵉⵖⵜ. ");
INSERT INTO rift_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","ⵍⴰⵎⵉ ⴷⴷ-ⵉⴳⴻⵄⵄⴻⴷ ⵓⵙⴻⵢⵏⵓ ⵣⵉ ⵙⴻⵏⵏⴻⵊ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ, ⴼⴻⵙⵢⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⵓⵛⴰ ⴰⵎⵎⵓ ⵎⵓⵟⵟⵢⴻⵏ ⵣⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵖⴰⵔ ⵡⴻⵎⵛⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","ⵎⴰⵍⴰ ⵡⴰⵔ ⴷⴷ-ⵉⴳⴻⵄⵄⴻⴷ ⵓⵙⴻⵢⵏⵓ, ⵡⴰⵔ ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴰⵍ ⴰⵙⵙ ⵉ ⴷⵉ ⵜⵓⵖⴰ ⵉⵜⵜⴳⴻⵄⵄⴻⴷ. ");
INSERT INTO rift_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","ⵎⵉⵏⵣⵉ ⴰⵙⴻⵢⵏⵓ ⵏ ⵙⵉⴷⵉ ⵜⵓⵖⴰ ⵢⴰⵔⵙⴰ ⵅ ⵜⵣⴻⴷⴷⵉⵖⵜ ⵙ ⵓⵣⵉⵍ ⵓⵛⴰ ⴷⵉ ⴵⵉⵍⴻⵜ ⵜⵓⵖⴰ ⵜⵉⵎⴻⵙⵙⵉ ⵣⵣⴰⵜ ⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵎⴰⵔⵔⴰ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴷⴻⴳ ⵉⵎⵓⵟⵟⵓⵢⴻⵏ ⵏⵙⴻⵏ ⵣⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵖⴰⵔ ⵡⴻⵎⵛⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","ⵉⵍⴰⵖⴰ ⵉ ⵎⵓⵙⴰ ⵓⵛⴰ ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽⵉⴷⴻⵙ ⵣⴻⴳ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“ⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵛⴰ ⵉⵏⵉ ⴰⵙⴻⵏ: ‘ⵎⴰⵍⴰ ⵉⵙⵙⵇⴰⵔⵔⴻⴱ ⵉⵊⵊ ⵏ ⴱⵏⴰⴷⴻⵎ ⵣⵣⴰⵢⵡⴻⵎ ⵜⴰⵡⵀⵉⴱⵜ ⵉ ⵙⵉⴷⵉ, ⵅⴻⵏⵏⵉ ⴰⴷ ⴷⴷ-ⵜⴻⵙⵙⵇⴰⵔⵔⴱⴻⵎ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵡⴻⵎ ⵣⵉ ⵍⴻⴱⵀⴰⵢⴻⵎ, ⵣⴻⴳ ⵉⴼⵓⵏⴰⵙⴻⵏ ⴷ ⵜⴼⵓⵏⴰⵙⵉⵏ ⵏⵉⵖ ⵣⴻⴳ ⵡⵓⴵⵉ. ");
INSERT INTO rift_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","ⵎⴰⵍⴰ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵣⴻⴳ ⵉⴼⵓⵏⴰⵙⴻⵏ ⴷ ⵜⴼⵓⵏⴰⵙⵉⵏ, ⵅⴻⵏⵏⵉ ⴰⴷ ⴷⴷ-ⵉⵙⵙⵇⴰⵔⵔⴻⴱ ⵉⵊⵊ ⵏ ⵓⵡⵜⴻⵎ ⵉⵛⵏⴰⵏ ⵇⴰⵄ. ⴰⴷ ⵜ ⵢⵉⵡⵉ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵢⴰⴼ ⴰⵔⴹⴰ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","ⴰⴷ ⵢⴻⴳⴳ ⴰⴼⵓⵙ ⵏⵏⴻⵙ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵜᵉⵜⵜⵡⴰⵇⴱⴻⵍ ⵜⵖⴰⵔⵚⵜ ⵙ ⴰⵔⴹⴰ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏⵏⴻⵙ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵢⵉⵍⵉ ⵉ ⵡⴻⵚⵍⴰⵃ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","ⴰⴷ ⵉⵖⴰⵔⵚ ⵉ ⵓⵎⴻⵥⵢⴰⵏ ⵏ ⵓⴼⵓⵏⴰⵙ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⵓⵛⴰ ⴰⵔⵔⴰⵡ ⵏ ⵀⴰⵔⵓⵏ, ⵉⴽⴻⵀⵀⴰⵏⴻⵏ, ⴰⴷ ⴷⴷ-ⵉⵡⵢⴻⵏ ⵉⴷⴰⵎⵎⴻⵏ, ⴰⴷ ⵣⴻⴵⵄⴻⵏ ⵉⴷⴰⵎⵎⴻⵏ ⵖⴰⵔ ⵎⴰⵔⵔⴰ ⵉⵖⴻⵣⴷⵉⵙⴻⵏ ⵅ ⵓⵄⴰⵍⵟⴰⵔ ⵏⵏⵉ ⵉⴵⴰⵏ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","ⴰⴷ ⵉⴽⴽⴻⵙ ⵜⵉⵍⵎⴻⵛⵜ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵓⵛⴰ ⴰⴷ ⵉⴱⴹⴰ ⴰⴼⵓⵏⴰⵙ ⴷ ⵉⵛⴻⴵⵉⵇⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","ⴰⵔⵔⴰⵡ ⵏ ⴰⴽⴻⵀⵀⴰⵏ ⵀⴰⵔⵓⵏ ⴰⴷ ⵙⵙⴰⵔⵖⴻⵏ ⵜⵉⵎⴻⵙⵙⵉ ⵅ ⵓⵄⴰⵍⵟⴰⵔ ⵓⵛⴰ ⴰⴷ ⵙⴻⵜⵜⴼⴻⵏ ⴰⴽⴻⵛⵛⵓⴹ ⵅ ⵜⵎⴻⵙⵙⵉ. ");
INSERT INTO rift_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","ⴰⵔⵔⴰⵡ ⵏ ⵀⴰⵔⵓⵏ, ⵉⴽⴻⵀⵀⴰⵏⴻⵏ, ⴰⴷ ⵙⴻⵜⵜⴼⴻⵏ ⵉⵛⴻⴵⵉⵇⴻⵏ ⴷ ⵓⵣⴻⴵⵉⴼ ⴷ ⵜⴰⴷⵓⵏⵜ ⵅ ⵓⴽⴻⵛⵛⵓⴹ ⵏⵏⵉ ⵉⴵⴰⵏ ⵅ ⵜⵎⴻⵙⵙⵉ ⵉ ⵉⴵⴰⵏ ⵅ ⵓⵄⴰⵍⵟⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","ⵏⴻⵜⵜⴰ ⴰⴷ ⵉⵙⵙⵉⵔⴷ ⴰⴷⴰⵏ ⵏⵏⴻⵙ ⴷ ⵉⴹⴰⵔⴻⵏ ⵏⵏⴻⵙ ⵙ ⵡⴰⵎⴰⵏ. ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵉⵙⵙⴱⴻⵅⵅⴰⵔ ⵎⴰⵏ ⴰⵢⴰ ⵎⴰⵔⵔⴰ ⵅ ⵓⵄⴰⵍⵟⴰⵔ, ⴰⵇⴰ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ, ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ, ⴷ ⵉⵛⵜ ⵏ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵉⵜⵜⴼⵓⵃⴻⵏ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","ⵎⴰⵍⴰ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵣⴻⴳ ⵡⵓⴵⵉ, ⵣⴻⴳ ⵉⵃⵓⵍⵉⵢⵢⴻⵏ ⵏⵉⵖ ⵣⴻⴳ ⵉⵖⴰⵢⴹⴻⵏ, ⵅⴻⵏⵏⵉ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⴷⴷ-ⵉⵙⵙⵇⴰⵔⵔⴻⴱ ⴰⵡⵜⴻⵎ ⵉⵛⵏⴰⵏ ⵇⴰⵄ. ");
INSERT INTO rift_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","ⴰⴷ ⴰⵙ ⵉⵖⴰⵔⵚ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⵖⴰⵔ ⵓⵖⴻⵣⴷⵉⵙ ⵏ ⵛⵛⴰⵎⴰⵍ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ⵓⵛⴰ ⴰⵔⵔⴰⵡ ⵏ ⵀⴰⵔⵓⵏ, ⵉⴽⴻⵀⵀⴰⵏⴻⵏ, ⴰⴷ ⵣⴻⴵⵄⴻⵏ ⵉⴷⴰⵎⵎⴻⵏ ⵏⵏⴻⵙ ⵅ ⵓⵄⴰⵍⵟⴰⵔ ⵖⴰⵔ ⵎⴰⵔⵔⴰ ⵉⵖⴻⵣⴷⵉⵙⴻⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","ⴰⴷ ⵜ ⵉⴱⴹⴰ ⴷ ⵉⵛⴻⴵⵉⵇⴻⵏ, ⴰⴽ-ⴷ ⴰⵣⴻⴵⵉⴼ ⵏⵏⴻⵙ ⴷ ⵜⴰⴷⵓⵏⵜ ⵏⵏⴻⵙ, ⵓⵛⴰ ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵜⴻⵏ ⵉⵙⴻⵜⵜⴻⴼ ⵅ ⵓⴽⴻⵛⵛⵓⴹ ⵏⵏⵉ ⵉⴵⴰⵏ ⵅ ⵜⵎⴻⵙⵙⵉ ⵉ ⵉⴵⴰⵏ ⵅ ⵓⵄⴰⵍⵟⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","ⴰⴷ ⵉⵙⵙⵉⵔⴷ ⴰⴷⴰⵏ ⵏⵏⴻⵙ ⴷ ⵉⵛⴻⴽⵔⴰⴷⴻⵏ ⵏⵏⴻⵙ ⵙ ⵡⴰⵎⴰⵏ. ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵢⴰⵡⵉ ⵎⴰⵏ ⴰⵢⴰ ⵎⴰⵔⵔⴰ ⵓ ⴰⴷ ⵜ ⵉⵙⵙⴱⴻⵅⵅⴰⵔ ⵅ ⵓⵄⴰⵍⵟⴰⵔ. ⴰⵇⴰ ⴷ ⵉⵛⵜ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ, ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ, ⵉⵛⵜ ⵏ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵉⵜⵜⴼⵓⵃⴻⵏ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","ⵎⴰⵍⴰ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵣⴻⴳ ⵉⵊⴹⴰⴹ ⵉ ⵙⵉⴷⵉ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵢⴰⵡⵉ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵣⵉ ⵜⴻⵊⵍⵉⵍⵍⵉⵃⵉⵏ ⵏⵉⵖ ⵣⴻⴳ ⵉⴷⴱⵉⵔⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵜ ⵢⴰⵡⵉ ⵖⴰⵔ ⵓⵄⴰⵍⵟⴰⵔ, ⴰⴷ ⴰⵙ ⵉⴽⴽⴻⵙ ⴰⵣⴻⴵⵉⴼ ⵓⵛⴰ ⴰⴷ ⵜ ⵉⵙⵙⴱⴻⵅⵅⴰⵔ ⵅ ⵓⵄⴰⵍⵟⴰⵔ. ⴰⴷ ⵉⵥⴻⵎⵎ ⵉⴷⴰⵎⵎⴻⵏ ⵏⵏⴻⵙ ⵅ ⵓⵖⴻⵣⴷⵉⵙ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ");
INSERT INTO rift_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","ⵓⵛⴰ ⴰⴷ ⴰⵙ ⵉⴽⴽⴻⵙ ⴰⵙⴻⵢⵔⵓ ⴰⴽ-ⴷ ⵎⵉⵏ ⴷⴰⵢⴻⵙ ⵉⵇⵇⵉⵎⴻⵏ ⵓ ⴰⴷ ⵉⵏⴹⴰⵔ ⴰⵢⴰ ⵣⵣⴰⵜ ⵉ ⵓⵄⴰⵍⵟⴰⵔ ⵖⴰⵔ ⵓⵖⴻⵣⴷⵉⵙ ⵏ ⵛⵛⴰⵔⵇ ⵅ ⵡⴻⵎⵛⴰⵏ ⵏ ⵉⵖⵖⴻⴹ ⵏ ⵎⵉⵏ ⵉⵇⵇⵉⵎⴻⵏ ⵏ ⵜⴰⴷⵓⵏⵜ ");
INSERT INTO rift_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","ⴰⴷ ⵜ ⵉⵛⴰⵔⵔⴻⴳ ⵖⴰⵔ ⵡⴻⴼⵔⵉⵡⴻⵏ, ⵎⴰⵛⴰ ⵡⴰⵔ ⵜ ⵉⴱⴻⵟⵟⵉ ⵛⴰ ⵇⴰⵄ, ⵓⵛⴰ ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵜ ⵉⵙⵙⴱⴻⵅⵅⴰⵔ ⵅ ⵓⵄⴰⵍⵟⴰⵔ, ⵅ ⵓⴽⴻⵛⵛⵓⴹ ⵏⵏⵉ ⵉⴵⴰⵏ ⵅ ⵜⵎⴻⵙⵙⵉ. ⴰⵇⴰ ⴷ ⵉⵛⵜ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ, ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ, ⴷ ⵉⵛⵜ ⵏ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵉⵜⵜⴼⵓⵃⴻⵏ ⵉ ⵙⵉⴷⵉ.’” ");
INSERT INTO rift_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“ⵎⴰⵍⴰ ⵉⵇⴻⴷⴷⴻⵎ ⵃⴻⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵖⴰⵔ ⵙⵉⴷⵉ, ⴰⴷ ⵜⵉⵍⵉ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵏ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⵓⵛⴰ ⴰⴷ ⵅⴰⵙ ⵉⵙⴻⵢⵢⴻⴱ ⵣⵣⴻⵛⵜ ⵓⵛⴰ ⴰⴷ ⵅⴰⵙ ⵉⵙⵙⴰⵔⵙ ⵊⵊⴰⵡⵉ. ");
INSERT INTO rift_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","ⴰⴷ ⵜⵜ ⵢⴰⵡⵉ ⵖⴰⵔ ⵡⴰⵔⵔⴰⵡ ⵏ ⵀⴰⵔⵓⵏ, ⵉⴽⴻⵀⵀⴰⵏⴻⵏ, ⵓⵛⴰ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵉⴽⵙⵉ ⵓⴽⴻⵀⵀⴰⵏ ⵉⵊⵊ ⵏ ⵡⵓⵔⵓ ⵉⵛⵛⵓⵔ ⵣⴻⴳ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⵏⵏⵉ ⵓ ⵣⵉ ⵣⵣⴻⵛⵜ ⵏⵏⵉ ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⵊⵊⴰⵡⵉ, ⵓⵛⴰ ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵉⵙⵙⴱⴻⵅⵅⴰⵔ ⴰⵢⴰ ⵅ ⵓⵄⴰⵍⵟⴰⵔ ⵉ ⵍⵉⴷⴰⵔⴻⵜ ⵉ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵏⵉ, ⴰⵇⴰ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ ⴷ ⵉⵛⵜ ⵏ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵉⵜⵜⴼⵓⵃⴻⵏ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","ⵎⵉⵏ ⵉⵇⵇⵉⵎⴻⵏ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⴰⴷ ⵢⵉⵍⵉ ⵉ ⵀⴰⵔⵓⵏ ⵓ ⵉ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ. ⴰⵇⴰ ⴷ ⴰⵎⵇⴻⴷⴷⴰⵙ ⵇⴰⵄ ⵣⵉ ⵎⴰⵔⵔⴰ ⵜⵉⵡⵀⵉⴱⵉⵏ ⵏ ⵜⵎⴻⵙⵙⵉ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","ⵎⴰⵍⴰ ⵜⵇⴻⴷⴷⵎⴻⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵉ ⵉⴵⴰⵏ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⴷⴰⵔⵃⴻⵏ ⵜⵜ ⴷⵉ ⵜⴻⴼⵇⵓⵏⵜ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⵉⵍⵉ ⴷ ⵍⴻⵎⵙⴻⵎⵏⴰⵜ ⴱⵍⴰ ⴰⵏⵜⵓⵏ, ⵉⵅⴻⴵⴹⴻⵏ ⵙ ⵣⵣⴻⵛⵜ, ⵓⵍⴰ ⴷ ⵜⵉⵍⴼⴰⴼ ⴱⵍⴰ ⴰⵏⵜⵓⵏ ⵜⵜⵡⴰⴷⴻⵀⵏⴻⵏⵜ ⵙ ⵣⵣⴻⵛⵜ, ⵎⴰⵔⵔⴰ ⵣⴻⴳ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ. ");
INSERT INTO rift_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","ⵎⴰⵍⴰ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵛ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⴳⴳⵯⵉⵏ ⵜⵜ ⵅ ⵡⴻⵅⴷⵉⵎ, ⴰⴷ ⵜⵉⵍⵉ ⵏ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵅⴻⴵⴹⴻⵏ ⵙ ⵣⵣⴻⵛⵜ, ⵡⴰⵔⴷⴰⵢⴻⵙ ⴱⵓ ⵡⴻⵏⵜⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","ⴰⴷ ⵜⴻⵏ ⵜⴰⵔⵥⴻⴷ ⴷ ⵉⴼⴻⵜⵡⵉⵜⴻⵏ ⵓⵛⴰ ⴰⴷ ⵅⴰⵙ ⵜⵙⴻⵢⵢⴱⴻⴷ ⵣⵣⴻⵛⵜ. ⴰⵇⴰ-ⵜⵜ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","ⵎⴰⵍⴰ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵛ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⴳⴳⵯⵉⵏ ⵜⵜ ⴷⵉ ⵟⵟⴰⵊⵊⵉⵏ, ⴰⴷ ⵜⵉⵍⵉ ⵜⴻⵡⵊⴻⴷ ⵙ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⴰⴽ-ⴷ ⵣⵣⴻⵛⵜ. ");
INSERT INTO rift_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵉ ⵣⵣⴰⵢⵙⴻⵏ ⵉⵡⴻⵊⴷⴻⵏ, ⴰⴷ ⵜⵜ ⵜⴰⵡⵢⴻⴷ ⵖⴰⵔ ⵙⵉⴷⵉ. ⴱⵏⴰⴷⴻⵎ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⴷⴷ-ⵉⵇⴰⵔⵔⴻⴱ ⵖⴰⵔ ⵓⴽⴻⵀⵀⴰⵏ ⵓⵛⴰ ⵡⴰⵏⵉⵜⴰ ⴰⴷ ⵜⵜ ⵢⴰⵡⵉ ⵖⴰⵔ ⵓⵄⴰⵍⵟⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","ⴰⴷ ⵉⴽⵙⵉ ⵓⴽⴻⵀⵀⴰⵏ ⵣⵉ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵉⵛⵜ ⵏ ⵍⵉⴷⴰⵔⴻⵜ ⵓⵛⴰ ⴰⴷ ⵜⵜ ⵉⵙⵙⴱⴻⵅⵅⴰⵔ ⵅ ⵓⵄⴰⵍⵟⴰⵔ, ⴰⵇⴰ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ, ⴷ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵉⵜⵜⴼⵓⵃⴻⵏ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","ⵎⵉⵏ ⵉⵇⵇⵉⵎⴻⵏ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⴰⴷ ⵢⵉⵍⵉ ⵉ ⵀⴰⵔⵓⵏ ⵓ ⵉ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ. ⴰⵇⴰ-ⵜ ⴷ ⴰⵎⵇⴻⴷⴷⴰⵙ ⵇⴰⵄ ⵣⵉ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵏ ⵜⵎⴻⵙⵙⵉ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","ⵡⴰⵔ ⵉⵄⴻⴷⴷⴻⵍ ⵉ ⵓⵍⴰ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵉ ⵖⴰ ⵜⵇⴻⴷⴷⵎⴻⵎ ⵉ ⵙⵉⴷⵉ ⴰⴷ ⵜⵉⵍⵉ ⵜⴻⵡⵊⴻⴷ ⵙ ⵡⴻⵏⵜⵓⵏ. ⵎⴰⵖⴰⵔ ⵣⵉ ⵎⵉⵏ ⵎⴰ ⵏ ⵡⴻⵏⵜⵓⵏ ⴷ ⵣⵉ ⵎⵉⵏ ⵎⴰ ⵜⴰⵎⵎⴻⵏⵜ ⵡⴰⵔ ⵣⵣⴰⵢⴻⵙ ⵜⴻⵙⵙⴱⴻⵅⵅⴰⵔⴰⵎ ⵛⴰ ⵓⵍⴰ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","ⴰⴷ ⵜⵉⵡⵢⴻⵎ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵓⵙⵓⴼⴼⴻⵖ ⴰⵎⴻⵣⵡⴰⵔⵓ ⵏ ⵚⵚⴰⴱⴻⵜ ⵖⴰⵔ ⵙⵉⴷⵉ, ⵎⴰⵛⴰ ⵏⵉⵜⵏⵉ ⵡⴰⵔ ⵣⴻⵎⵎⴰⵔⴻⵏ ⴰⴷ ⵙⵙⴱⴻⵅⵅⴰⵔⴻⵏ ⵜⴰⵡⵀⵉⴱⵜ-ⴰ ⵅ ⵓⵄⴰⵍⵟⴰⵔ ⴰⵎ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵉⵜⵜⴼⵓⵃⴻⵏ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","ⴽⵓⵍ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵏⵏⴻⵛ ⴰⴷ ⵜⵉⵍⵉ ⵜⵎⴻⴵⵃⴻⴷ ⵙ ⵜⵎⴻⴵⴰⵃⵟ. ⵜⴰⵎⴻⴵⴰⵃⵜ ⵏ ⵍⵄⴰⵀⴷ ⵏ ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵛ ⵡⴰⵔ ⵜⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵜⴻⵏⵇⴻⵚ ⵖⴰⵔ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵏⵏⴻⵛ. ⴰⴷ ⵜⵇⴻⴷⴷⵎⴻⴷ ⵜⴰⵎⴻⴵⴰⵃⵜ ⵖⴰⵔ ⴽⵓⵍ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","ⵎⴰⵍⴰ ⵜⵉⵡⵢⴻⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵏ ⵜⵎⴻⵏⵣⵓⵜ, ⴰⴷ ⵜⵉⵡⵢⴻⴷ ⵜⵉⴷⵔⵉⵏ ⵢⵉⵡⴹⴻⵏ, ⵜⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⴼⴰⵔⴻⵏ ⵅ ⵜⵎⴻⵙⵙⵉ, ⴰⴽ-ⴷ ⵍⵃⴻⴱⴱ ⴰⵣⵉⵣⴰ ⵉⴱⴰⵔⵢⴻⵏ ⴰⵎ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵣⵉ ⵜⵎⴻⵏⵣⵓⵜ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","ⴰⴷ ⵅⴰⵙ ⵜⵙⴻⵢⵢⴱⴻⴷ ⵣⵣⴻⵛⵜ ⵓ ⴰⴷ ⵅⴰⵙ ⵜⴻⵙⵙⴰⵔⵙⴻⴷ ⵊⵊⴰⵡⵉ, ⴰⵇⴰ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⵙⵙⴱⴻⵅⵅⴰⵔ ⵓⴽⴻⵀⵀⴰⵏ ⵉⵊⵊ ⵏ ⵡⴻⵣⵢⴻⵏ ⵣⵉ ⵍⵃⴻⴱⴱ ⵉⴱⴰⵔⵢⴻⵏ ⵓ ⵣⵉ ⵣⵣⴻⵛⵜ ⵏⵏⴻⵙ ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⵊⵊⴰⵡⵉ ⵏⵏⴻⵙ ⵉ ⵅⴰⵙ ⵉⴵⴰⵏ ⴰⵎ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵉⴷⴰⵔⴻⵜ ⴷⵉ ⵎⴰⵏ ⴰⵢⴰ. ⴰⵇⴰ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ ⵉ ⵙⵉⴷⵉ.” ");
INSERT INTO rift_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ⵎⴰⵍⴰ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵍⴻⵀⵏⴰ, ⵉⵜⵜⵅⴻⵚⵚⴰ, ⵎⴰⵍⴰ ⵅⴻⵏⵏⵉ ⵉⵙⵙⵇⴰⵔⵔⴻⴱ-ⴷⴷ ⴰⵎⵓⴷⴷⴰⵔ, ⴰⴷ ⵢⵉⵍⵉ ⴷ ⴰⵡⵜⴻⵎ ⵏⵉⵖ ⴷ ⵜⴰⵡⵜⴻⵎⵜ ⵏ ⵉⴼⵓⵏⴰⵙⴻⵏ ⴷ ⵜⴼⵓⵏⴰⵙⵉⵏ, ⴰⴷ ⴷⴷ-ⵉⵙⵙⵇⴰⵔⵔⴻⴱ ⵉⵊⵊ ⵏ ⵓⵎⵓⴷⴷⴰⵔ ⵉⵛⵏⴰⵏ ⵇⴰⵄ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","ⴰⴷ ⵉⵙⵙⴰⵔⵙ ⴰⴼⵓⵙ ⵏⵏⴻⵙ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⴰⵙ ⵉⵖⴰⵔⵚ ⵇⵉⴱⴰⵍⵜ ⵉ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⵓⵛⴰ ⴰⵔⵔⴰⵡ ⵏ ⵀⴰⵔⵓⵏ, ⵉⴽⴻⵀⵀⴰⵏⴻⵏ, ⴰⴷ ⵣⴻⴵⵄⴻⵏ ⵉⴷⴰⵎⵎⴻⵏ ⵏⵏⴻⵙ ⵅ ⵓⵄⴰⵍⵟⴰⵔ ⵖⴰⵔ ⵎⴰⵔⵔⴰ ⵉⵖⴻⵣⴷⵉⵙⴻⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","ⵣⵉ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⴻⵀⵏⴰ ⴰⴷ ⵉⵇⴻⴷⴷⴻⵎ ⵉⵛⵜ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ ⵉ ⵙⵉⴷⵉ, ⵉⵅⵙ ⴰⴷ ⵢⵉⵏⵉ ⵜⴰⴷⵓⵏⵜ ⵉ ⵉⴷⵍⵉⵏ ⴰⴷⴰⵏ ⴷ ⵎⴰⵔⵔⴰ ⵜⴰⴷⵓⵏⵜ ⵉ ⵉⴵⴰⵏ ⵅ ⵡⴰⴷⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","ⴰⴷ ⵉⴽⴽⴻⵙ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵉⵥⵥⴰⵍ ⴰⴽ-ⴷ ⵜⴰⴷⵓⵏⵜ ⵉ ⵅⴰⵙⴻⵏⵜ ⵉⴵⴰⵏ ⵖⴰⵔ ⵜⴻⵊⵄⵉⵏⵏⴰ ⵓⵍⴰ ⴷ ⵎⵉⵏ ⵢⵓⵢⵍⴻⵏ ⵖⴰⵔ ⵜⵙⴰ ⵓ ⵢⴰⵔⵙⴰ ⵅ ⵜⵉⵥⵥⴰⵍ. ");
INSERT INTO rift_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","ⴰⵔⵔⴰⵡ ⵏ ⵀⴰⵔⵓⵏ ⴰⴷ ⵙⵙⴱⴻⵅⵅⴰⵔⴻⵏ ⴰⵢⴰ ⵅ ⵓⵄⴰⵍⵟⴰⵔ ⵅ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵉ ⵉⴵⴰⵏ ⵅ ⵓⴽⴻⵛⵛⵓⴹ ⵉ ⴷⵉⵏ ⵉⴵⴰⵏ ⵅ ⵜⵎⴻⵙⵙⵉ. ⴰⵇⴰ-ⵜ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ, ⴷ ⵉⵛⵜ ⵏ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵉⵜⵜⴼⵓⵃⴻⵏ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","ⵎⴰⵍⴰ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵍⴻⵀⵏⴰ ⵉ ⵙⵉⴷⵉ, ⴰⵡⵜⴻⵎ ⵏⵉⵖ ⴷ ⵜⴰⵡⵜⴻⵎⵜ ⵏ ⵡⵓⴵⵉ, ⵅⴻⵏⵏⵉ ⴰⴷ ⴷⴷ-ⵉⵙⵙⵇⴰⵔⵔⴻⴱ ⵉⵊⵊ ⵏ ⵓⵎⵓⴷⴰⵔ ⵉⵛⵏⴰⵏ ⵇⴰⵄ. ");
INSERT INTO rift_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","ⵎⴰⵍⴰ ⴷ ⵓⵃⵓⵍⵉ ⵉ ⴷⴷ-ⵉⵙⵙⵇⴰⵔⵔⴻⴱ ⴷ ⵜⴰⵖⴰⵔⵚⵜ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜ-ⵉ-ⴷⴷ ⵉⵙⵙⵇⴰⵔⵔⴻⴱ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","ⵏⴻⵜⵜⴰ ⴰⴷ ⵉⵙⵙⴰⵔⵙ ⴰⴼⵓⵙ ⵏⵏⴻⵙ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⴰⵙ ⵉⵖⴰⵔⵚ ⵣⵣⴰⵜ ⵉ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ⵓⵛⴰ ⴰⵔⵔⴰⵡ ⵏ ⵀⴰⵔⵓⵏ ⴰⴷ ⵣⴻⴵⵄⴻⵏ ⵉⴷⴰⵎⵎⴻⵏ ⵏⵏⴻⵙ ⵅ ⵓⵄⴰⵍⵟⴰⵔ ⵖⴰⵔ ⵎⴰⵔⵔⴰ ⵉⵖⴻⵣⴷⵉⵙⴻⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","ⴰⴷ ⵉⵇⴻⴷⴷⴻⵎ ⵜⴰⴷⵓⵏⵜ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵍⴻⵀⵏⴰ ⴰⵎ ⵢⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ ⵉ ⵙⵉⴷⵉ: ⵎⴰⵔⵔⴰ ⵜⴰⵏⴻⵡⵡⴰⵔⵜ ⵏ ⵜⴰⴷⵓⵏⵜ ⵏⵏⵉ ⵢⵓⴷⵙⴻⵏ ⴰⴱⴻⵄⵚⵓⵚ ⴰⴷ ⵜⵜ ⵉⴽⴽⴻⵙ, ⵓⵍⴰ ⴷ ⵜⴰⴷⵓⵏⵜ ⵉ ⵉⴷⵍⵉⵏ ⴰⴷⴰⵏ ⴷ ⵎⴰⵔⵔⴰ ⵜⴰⴷⵓⵏⵜ ⵉ ⵉⴵⴰⵏ ⵅ ⵡⴰⴷⴰⵏ ");
INSERT INTO rift_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","ⵓⵛⴰ ⴰⴷ ⵉⴽⴽⴻⵙ ⵓⵍⴰ ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵉⵥⵥⴰⵍ ⴰⴽ-ⴷ ⵜⴰⴷⵓⵏⵜ ⵉ ⵅⴰⵙⴻⵏⵜ ⵉⴵⴰⵏ ⵖⴰⵔ ⵜⴻⵊⵄⵉⵏⵏⴰ ⴷ ⵎⵉⵏ ⵢⵓⵢⵍⴻⵏ ⵖⴰⵔ ⵜⵙⴰ ⵓ ⵢⴰⵔⵙⴰ ⵅ ⵜⵉⵥⵥⴰⵍ. ");
INSERT INTO rift_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵉⵙⵙⴱⴻⵅⵅⴰⵔ ⴰⵢⴰ ⵅ ⵓⵄⴰⵍⵟⴰⵔ. ⴰⵇⴰ ⴷ ⵎⴰⵛⵛⴰ, ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","ⵎⴰⵍⴰ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⴷ ⵉⵖⴰⵢⴹ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜ-ⵉ-ⴷⴷ-ⵉⵙⵙⵇⴰⵔⵔⴻⴱ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","ⴰⴷ ⵉⵙⵙⴰⵔⵙ ⴰⴼⵓⵙ ⵏⵏⴻⵙ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⴰⵙ ⵉⵖⴰⵔⵚ ⵣⵣⴰⵜ ⵉ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ⵓⵛⴰ ⴰⵔⵔⴰⵡ ⵏ ⵀⴰⵔⵓⵏ ⴰⴷ ⵣⴻⴵⵄⴻⵏ ⵛⵡⴰⵢⵜ ⵏ ⵉⴷⴰⵎⵎⴻⵏ ⵏⵏⴻⵙ ⵅ ⵓⵄⴰⵍⵟⴰⵔ ⵖⴰⵔ ⵎⴰⵔⵔⴰ ⵉⵖⴻⵣⴷⵉⵙⴻⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵉⵇⴻⴷⴷⴻⵎ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ, ⵉⵅⵙ ⴰⴷ ⵢⵉⵏⵉ ⵜⴰⴷⵓⵏⵜ ⵉ ⵉⴷⵍⵉⵏ ⴰⴷⴰⵏ, ⵓ ⵎⴰⵔⵔⴰ ⵜⴰⴷⵓⵏⵜ ⵉ ⵉⴵⴰⵏ ⵅ ⵡⴰⴷⴰⵏ, ⴰⵎ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ ⵉ ⵙⵉⴷⵉ ");
INSERT INTO rift_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","ⵓⵛⴰ ⴰⴷ ⵉⴽⴽⴻⵙ ⵓⵍⴰ ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵉⵥⵥⴰⵍ ⴰⴽ-ⴷ ⵜⴰⴷⵓⵏⵜ ⵉ ⵅⴰⵙⴻⵏⵜ ⵉⴵⴰⵏ ⵖⴰⵔ ⵜⴻⵊⵄⵉⵏⵏⴰ ⵓⵍⴰ ⴷ ⵎⵉⵏ ⵢⵓⵢⵍⴻⵏ ⵖⴰⵔ ⵜⵙⴰ ⵓ ⵢⴰⵔⵙⴰ ⵅ ⵜⵉⵥⵥⴰⵍ. ");
INSERT INTO rift_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵉⵙⵙⴱⴻⵅⵅⴰⵔ ⴰⵢⴰ ⵅ ⵓⵄⴰⵍⵟⴰⵔ, ⴰⵇⴰ ⴷ ⵎⴰⵛⵛⴰ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ ⵙ ⵉⵛⵜ ⵏ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵉⵜⵜⴼⵓⵃⴻⵏ. ⵎⴰⵔⵔⴰ ⵜⴰⴷⵓⵏⵜ ⴰⴷ ⵜⵉⵍⵉ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","ⵜⴰ ⴷ ⵜⴰⵡⵚⴻⵢⵢⴻⵜ ⵉ ⵍⴻⴱⴷⴰ ⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵏⵡⴻⵎ, ⵎⴰⵏⵉ ⵎⴰ ⵉ ⵖⴰ ⵜⵣⴻⴷⵖⴻⵎ: ⵎⴰⵔⵔⴰ ⵜⴰⴷⵓⵏⵜ ⴷ ⵎⴰⵔⵔⴰ ⵉⴷⴰⵎⵎⴻⵏ ⵡⴰⵔ ⵜⴻⵏ ⵜⵜᵉⵜⵜⴻⵎ.” ");
INSERT INTO rift_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“ⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵉⵏⵉ: ‘ⵎⴰⵍⴰ ⵛⴰ ⵏ ⵢⵉⵊⵊⴻⵏ ⵉⵅⴹⴰ ⴰⵎ ⵉⵡⴻⴷⴷⴰⵔ ⵅ ⵎⴰⵔⵔⴰ ⵜⵉⵡⴻⵚⵚⴰ ⵏ ⵙⵉⴷⵉ, ⵎⵉⵏ ⵡⴰⵔ ⵉⵜⵜⵅⴻⵚⵚⵉ ⴰⴷ ⵉⵜⵜⵡⴰⴳⴳ, ⵓ ⵏⴻⵜⵜⴰ ⵉⵅⴹⴰ ⴷⴻⴳ ⵉⵛⵜ ⵣⵣⴰⵢⵙⴻⵏⵜ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⵉⵍⵉ ⵜⵎⴻⵙⵍⴰⵛⵜ ⴰⵎⵎⵓ: ");
INSERT INTO rift_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","ⵎⴰⵍⴰ ⴰⴽⴻⵀⵀⴰⵏ ⴰⵎⴻⴷⵀⵓⵏ ⵉⵅⴹⴰ, ⴰⵍⴰⵎⵉ ⵉⴷⵡⴻⵍ ⵍⴳⴻⵏⵙ ⵉⵅⴹⴰ, ⴰⴷ ⴷⴷ-ⵉⵙⵙⵇⴰⵔⵔⴻⴱ ⵉⵊⵊ ⵏ ⵓⴼⵓⵏⴰⵙ. - ⴰⵎⴻⵥⵢⴰⵏ ⵉⵛⵏⴰⵏ ⵇⴰⵄ ⵏ ⵉⵛⵜ ⵏ ⵜⴼⵓⵏⴰⵙⵜ - ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⵉ ⵙⵉⴷⵉ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏ ⴷⴷⴻⵏⴱ ⵏⵏⴻⵙ ⵉ ⵉⴳⴳⴰ. ");
INSERT INTO rift_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","ⴰⴷ ⵢⴰⵡⵉ ⴰⴼⵓⵏⴰⵙ ⵏⵏⵉ ⴰⵎⴻⵥⵢⴰⵏ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ, ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⴰⴷ ⵉⵙⵙⴰⵔⵙ ⴰⴼⵓⵙ ⵏⵏⴻⵙ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏ ⵓⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ ⵓⵛⴰ ⴰⴷ ⴰⵙ ⵉⵖⴰⵔⵚ ⵉ ⵓⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","ⵅⴻⵏⵏⵉ ⴰⴽⴻⵀⵀⴰⵏ ⴰⵎⴻⴷⵀⵓⵏ ⴰⴷ ⵉⴽⵙⵉ ⵛⴰ ⵣⴻⴳ ⵉⴷⴰⵎⵎⴻⵏ ⵏ ⵓⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ ⵓⵛⴰ ⴰⴷ ⵜ ⵢⴰⵡⵉ ⵖⴰⵔ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","ⴰⴷ ⵉⵙⵙⵓⴼ ⵓⴽⴻⵀⵀⴰⵏ ⴰⴹⴰⴹ ⵏⵏⴻⵙ ⴷⴻⴳ ⵉⴷⴰⵎⵎⴻⵏ ⵓⵛⴰ ⴰⴷ ⵉⵔⵓⵛⵛ ⵛⴰ ⵣⴻⴳ ⵉⴷⴰⵎⵎⴻⵏ ⵏⵏⵉ ⵙⴻⴱⵄⴰ ⵏ ⵜⵡⴰⵍⴰⵡⵉⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ, ⵣⵣⴰⵜ ⵉ ⵓⵍⴻⵃⵃⴰⴼ ⵏ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","ⴰⴷ ⵉⴳⴳ ⵓⴽⴻⵀⵀⴰⵏ ⵛⵡⴰⵢⵜ ⵏ ⵉⴷⴰⵎⵎⴻⵏ ⵅ ⵡⴰⵛⵛⴰⵡⴻⵏ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ⵉ ⵍⴻⴱⵅⵓⵔ ⵉⵜⵜⴼⵓⵃⴻⵏ ⵉ ⴷⵉⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⴷⴻⴳ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ⵏⴻⵜⵜⴰ ⴰⴷ ⵉⴼⴰⵔⵔⴻⵖ ⵎⴰⵔⵔⴰ ⵉⴷⴰⵎⵎⴻⵏ ⵉ ⵉⵇⵇⵉⵎⴻⵏ ⵏ ⵓⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ ⵖⴰⵔ ⵓⴹⴰⵔ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ⵏ ⵡⴻⵛⵎⴰⴹ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ.    ");
INSERT INTO rift_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","ⴰⴷ ⵉⴽⴽⴻⵙ ⵎⴰⵔⵔⴰ ⵜⴰⴷⵓⵏⵜ ⵏ ⵓⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ ⵏ ⵜⵖⴰⵔⵚⵜ: ⵜⴰⴷⵓⵏⵜ ⵉ ⵉⴷⵍⵉⵏ ⴰⴷⴰⵏ ⴷ ⵎⴰⵔⵔⴰ ⵜⴰⴷⵓⵏⵜ ⵉ ⵉⴵⴰⵏ ⵅ ⵡⴰⴷⴰⵏ    ");
INSERT INTO rift_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ⵓⵛⴰ ⴰⴷ ⵉⴽⴽⴻⵙ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵉⵥⵥⴰⵍ ⴰⴽ-ⴷ ⵜⴰⴷⵓⵏⵜ ⵉ ⵅⴰⵙⴻⵏⵜ ⵉⴵⴰⵏ ⵖⴰⵔ ⵜⴻⵊⵄⵉⵏⵏⴰ ⵓⵍⴰ ⴷ ⵎⵉⵏ ⵢⵓⵢⵍⴻⵏ ⵖⴰⵔ ⵜⵙⴰ ⵓ ⵢⴰⵔⵙⴰ ⵅ ⵜⵉⵥⵥⴰⵍ, ");
INSERT INTO rift_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵉⴽⴽⴻⵙ ⵎⴰⵏ ⴰⵢⴰ ⵅ ⵓⴼⵓⵏⴰⵙ ⵏ ⵜⵖⴰⵔⵚⵉ ⵏ ⵍⴻⵀⵏⴰ, ⵓⵛⴰ ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵉⵙⵙⴱⴻⵅⵅⴰⵔ ⴰⵢⴰ ⵅ ⵓⵄⴰⵍⵟⴰⵔ ⵏ ⵡⴻⵛⵎⴰⴹ. ");
INSERT INTO rift_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","ⵉⵍⴻⵎ ⵏ ⵓⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ ⴷ ⵎⴰⵔⵔⴰ ⴰⵢⵙⵓⵎ ⵏⵏⴻⵙ ⴰⴽ-ⴷ ⵓⵣⴻⴵⵉⴼ ⴷ ⵉⵛⴻⴽⵔⴰⴷ ⵏⵏⴻⵙ ⴷ ⵡⴰⴷⴰⵏ ⵏⵏⴻⵙ ⴷ ⵓⵎⴻⵙⵙⴰⵍ ⵏⵏⴻⵙ ⵉ ⴷⴰⵢⴻⵙ, ");
INSERT INTO rift_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","ⴰⵇⴰ ⵎⴰⵔⵔⴰ ⴰⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ ⴰⴷ ⵜ ⵉⵙⵙⵓⴼⴼⴻⵖ ⴱⴰⵔⵔⴰ ⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵖⴰⵔ ⵉⵊⵊ ⵏ ⵡⴻⵎⵛⴰⵏ ⵉⵚⴼⴰ ⵎⴰⵏⵉ ⵜⵜⴻⴳⴳⴻⵏ ⵉⵖⵖⴻⴹ ⵉ ⵉⵇⵇⵉⵎⴻⵏ ⵏ ⵜⴰⴷⵓⵏⵜ ⵓⵛⴰ ⴰⴷ ⵜ ⵉⵙⵙⴻⵛⵎⴻⴹ ⵙ ⵜⵎⴻⵙⵙⵉ ⵅ ⵓⴽⴻⵛⵛⵓⴹ. ⴰⴷ ⵜ ⵛⴻⵎⴹⴻⵏ ⵎⴰⵏⵉ ⵣⴻⴵⵄⴻⵏ ⵉⵖⵖⴻⴹ. ");
INSERT INTO rift_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","ⵎⴰⵍⴰ ⵜⴻⴼⴼⴻⵖ ⵜⵎⴻⵙⵎⵓⵏⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵎⴰⵔⵔⴰ ⵣⴻⴳ ⵡⴻⴱⵔⵉⴷ ⵓⵛⴰ ⵜⴻⴼⴼⴰⵔ ⵜⵎⴻⵙⵍⴰⵛⵜ ⵅ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵡⴻⴳⵔⴰⵡ ⵏ ⵍⴳⴻⵏⵙ, ⵓⵛⴰ ⵏⵉⵜⵏⵉ ⴳⴳⵉⵏ ⵉⵛⵜ ⵏ ⵍⵃⴰⵊⵊⴻⵜ ⵏⵏⵉ ⵉⴼⴼⵖⴻⵏ ⵅ ⵎⴰⵔⵔⴰ ⵜⵉⵡⴻⵚⵚⴰ ⵏ ⵙⵉⴷⵉ, ⵣⵉ ⵊⵊⵉⵀⴻⵜ ⵏ ⵎⵉⵏ ⵡⴰⵔ ⵉⵜⵜⵅⴻⵚⵚⵉ ⴰⴷ ⵢⴻⴳⴳ, ⵓⵛⴰ ⵉⴷⵡⴻⵍ ⴷⴰⵢⵙⴻⵏ ⵓⵎⴰⵔⵡⴰⵙ, ");
INSERT INTO rift_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","ⵓⵛⴰ ⵉⴱⴰⵏ-ⴷⴷ ⴷⴷⴻⵏⴱ ⵉ ⵣⵉ ⵉⴼⴼⵖⴻⵏ ⵅ ⵡⴻⴱⵔⵉⴷ ⵏ ⵍⵓⵎⵓⵔⴰⵜ, ⵅⴻⵏⵏⵉ ⴰⴷ ⴷⴷ-ⵉⵙⵙⵇⴰⵔⵔⴻⴱ ⵡⴻⴳⵔⴰⵡ ⵏ ⵍⴳⴻⵏⵙ ⵉⵊⵊ ⵏ ⵓⴼⵓⵏⴰⵙ - ⴰⵎⴻⵥⵢⴰⵏ ⵏ ⵜⴼⵓⵏⴰⵙⵜ - ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵉ ⴷⴷⴻⵏⴱ, ⵓⵛⴰ ⴰⴷ ⵜ ⴰⵡⵢⴻⵏ ⵣⵣⴰⵜ ⵉ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","ⵉⵎⵖⴰⵔⴻⵏ ⵏ ⵜⵎⴻⵙⵎⵓⵏⵜ ⴰⴷ ⵙⵙⴰⵔⵙⴻⵏ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵙⴻⵏ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏ ⵓⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⴰⴷ ⴰⵙ ⵉⵖⴰⵔⵚ ⵉ ⵓⴼⵓⵏⴰⵙ ⵏⵏⵉ ⴰⵎⴻⵥⵢⴰⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","ⴰⴽⴻⵀⵀⴰⵏ ⴰⵎⴻⴷⵀⵓⵏ ⴰⴷ ⵢⴰⵡⵉ ⵛⵡⴰⵢⵜ ⵣⴻⴳ ⵉⴷⴰⵎⵎⴻⵏ ⵏ ⵓⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ ⵖⴰⵔ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ");
INSERT INTO rift_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","ⵓⵛⴰ ⴰⴷ ⵉⵙⵙⵓⴼ ⵓⴽⴻⵀⵀⴰⵏ ⴰⴹⴰⴹ ⵏⵏⴻⵙ ⴷⴻⴳ ⵉⴷⴰⵎⵎⴻⵏ ⵓⵛⴰ ⴰⴷ ⵉⵔⵓⵛⵛ ⵙ ⵉⴷⴰⵎⵎⴻⵏ ⵏⵏⵉ ⵙⴻⴱⵄⴰ ⵏ ⵜⵡⴰⵍⴰⵡⵉⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ, ⵣⵣⴰⵜ ⵉ ⵓⵍⴻⵃⵃⴰⴼ. ");
INSERT INTO rift_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","ⵏⴻⵜⵜⴰ ⴰⴷ ⵉⴳⴳ ⵛⵡⴰⵢⵜ ⵣⴻⴳ ⵉⴷⴰⵎⵎⴻⵏ ⵏⵏⵉ ⵅ ⵡⴰⵛⵛⴰⵡⴻⵏ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ⵏⵏⵉ ⵉⴵⴰⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⴷⴻⴳ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⴼⴰⵔⵔⴻⵖ ⵎⴰⵔⵔⴰ ⵉⴷⴰⵎⵎⴻⵏ ⵉⵛⴻⵟⵟⴻⵏ ⵖⴰⵔ ⵓⴹⴰⵔ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ⵏ ⵡⴻⵛⵎⴰⴷ ⵉ ⴷⵉⵏ ⵣⵣⴰⵜ ⵉ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","ⴰⴷ ⵅⴰⵙ ⵉⴽⴽⴻⵙ ⵎⴰⵔⵔⴰ ⵜⴰⴷⵓⵏⵜ ⵓⵛⴰ ⴰⴷ ⵜⵜ ⵉⵙⵙⴱⴻⵅⵅⴰⵔ ⵅ ⵓⵄⴰⵍⵟⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","ⵓⵛⴰ ⴰⴷ ⵉⴳⴳ ⵙ ⵓⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵉⴳⴳⴰ ⵙ ⵓⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ, ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵢⴻⴳⴳ. ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵅⴰⵙⴻⵏ ⵉⴳⴳ ⴰⵚⵍⴰⵃ ⵓⵛⴰ ⴰⴷ ⴰⵙⴻⵏ ⵉⵜⵜⵡⴰⵖⴼⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⵙⵙⵓⴼⴼⴻⵖ ⴰⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ ⴱⴰⵔⵔⴰ ⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵓⵛⴰ ⴰⴷ ⵜ ⵉⵙⵙⴻⵛⵎⴻⴹ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵉⵙⵙⴻⵛⵎⴻⴹ ⴰⴼⵓⵏⴰⵙ ⴰⵎⴻⵣⵡⴰⵔⵓ. ⴰⵇⴰ-ⵜⵜ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⵏ ⵡⴻⴳⵔⴰⵡ ⵏ ⵍⴳⴻⵏⵙ. ");
INSERT INTO rift_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","ⵎⴰⵍⴰ ⵉⵊⵊ ⵏ ⵍⵃⴰⴽⴻⵎ ⵉⵅⴹⴰ, ⵓⵛⴰ ⵙ ⵓⵡⴻⴷⴷⴰⵔ ⵉⴳⴳⴰ ⵉⵛⵜ ⵏ ⵍⵃⴰⵊⵊⴻⵜ ⵏⵏⵉ ⵉⵜⵜⴻⴼⴼⵖⴻⵏ ⵅ ⵡⴻⴱⵔⵉⴷ ⵏ ⵎⴰⵔⵔⴰ ⵜⵉⵡⴻⵚⵚⴰ ⵏ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵙ, ⵉ ⵡⴰⵔ ⵉⵜⵜⵛⵓⵡⵡⴰⵔⴻⵏ ⴰⴷ ⵉⵜⵜⵡⴰⴳⴳ, ⵓⵛⴰ ⵉⴷⵡⴻⵍ ⴷⴰⵢⴻⵙ ⵓⵎⴰⵔⵡⴰⵙ, ");
INSERT INTO rift_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","ⵏⵉⵖ ⵎⴰⵍⴰ ⵉⵜⵜⵡⴰⵙⵙⴰⵔⴳⴻⴱ ⴰⵙ ⵓⵅⴻⵟⵟⵓ ⵏⵏⴻⵙ ⵉ ⵉⴳⴳⴰ ⴹⵉⴷⴷ ⵉ ⵍⵓⵎⵓⵔ, ⴰⴷ ⵜⵉⵍⵉ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ, ⵜⴻⵏⵏⵉ ⵉ ⵖⴰ ⵉⵇⴻⴷⴷⴻⵎ, ⴷ ⵉⵊⵊ ⵏ ⵓⵎⵢⴰⵏ ⵣⴻⴳ ⵉⵖⴰⵢⴹⴻⵏ, ⵉⵊⵊ ⵏ ⵡⴻⵡⵜⴻⵎ ⵉⵛⵏⴰⵏ ⵇⴰⵄ. ");
INSERT INTO rift_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","ⴰⴷ ⵉⵙⵙⴰⵔⵙ ⴰⴼⵓⵙ ⵏⵏⴻⵙ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏ ⵓⵎⵢⴰⵏ ⵓⵛⴰ ⴰⴷ ⴰⵙ ⵉⵖⴰⵔⵚ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵎⴰⵏⵉ ⵖⴰⵔⵚⴻⵏ ⵉ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ⴰⵇⴰ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ. ");
INSERT INTO rift_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⴽⵙⵉ ⵓⴽⴻⵀⵀⴰⵏ ⵙ ⵓⴹⴰⴹ ⵏⵏⴻⵙ ⵛⵡⴰⵢⵜ ⵣⴻⴳ ⵉⴷⴰⵎⵎⴻⵏ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⵓⵛⴰ ⴰⴷ ⵜⴻⵏ ⵉⴳⴳ ⵅ ⵡⴰⵛⵛⴰⵡⴻⵏ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ⵏ ⵡⴻⵛⵎⴰⴹ ⵓⵛⴰ ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⴼⴰⵔⵔⴻⵖ ⵉⴷⴰⵎⵎⴻⵏ ⵉⵛⴻⵟⵟⴻⵏ ⵖⴰⵔ ⵓⴹⴰⵔ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ⵏ ⵡⴻⵛⵎⴰⴹ. ");
INSERT INTO rift_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","ⴰⴷ ⵉⵙⵙⴱⴻⵅⵅⴰⵔ ⵎⴰⵔⵔⴰ ⵜⴰⴷⵓⵏⵜ ⵏⵏⴻⵙ ⵅ ⵓⵄⴰⵍⵟⴰⵔ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵙ ⵉⴳⴳⴰ ⵉ ⵜⴰⴷⵓⵏⵜ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵍⴻⵀⵏⴰ. ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵅⴰⵙ ⵉⴳⴳ ⴰⵚⵍⴰⵃ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏ ⴷⴷⴻⵏⴱ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⴰⵙ ⵉⵜⵜⵡⴰⵖⴼⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","ⵎⴰⵍⴰ ⵉⵊⵊⴻⵏ ⴱⵏⴰⴷⴻⵎ ⵣⵉ ⵍⴳⴻⵏⵙ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵉⵅⴹⴰ ⵙ ⵓⵡⴻⴷⴷⴰⵔ ⴰⵎ ⵉⴳⴳⴰ ⵎⵖⵉⵔ ⵉⵛⵜ ⵏ ⵍⵃⴰⵊⵊⴻⵜ ⵏⵏⵉ ⵉⵜⵜⴻⴼⴼⵖⴻⵏ ⵅ ⵉⵛⵜⴻⵏ ⵏ ⵜⵡⴻⵚⵚⴰ ⵏ ⵙⵉⴷⵉ, ⵎⵉⵏ ⵡⴰⵔ ⵉⵜⵜⵛⵓⵡⵡⴰⵔ ⴰⴷ ⵉⵜⵜⵡⴰⴳⴳ, ⵓⵛⴰ ⵉⴷⵡⴻⵍ ⴷⴰⵢⴻⵙ ⵓⵎⴰⵔⵡⴰⵙ, ");
INSERT INTO rift_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","ⵏⵉⵖ ⵉⵜⵜⵡⴰⵙⵙⴰⵔⴳⴻⴱ ⴰⵙ ⵓⵅⴻⵟⵟⵓ ⵏⵏⴻⵙ ⵉ ⵉⴳⴳⴰ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⵉⵍⵉ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵏⵏⵉ ⵉ ⵖⴰ ⵉⵇⴻⴷⴷⴻⵎ ⴷ ⵉⵛⵜ ⵏ ⵜⵖⴰⵢⴹⴻⵜ, ⵉⵛⵜ ⵏ ⵜⴻⵡⵜⴻⵎⵜ ⵉⵛⵏⴰⵏ ⵇⴰⵄ, ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵅ ⴷⴷⴻⵏⴱ ⵉ ⵉⴳⴳⴰ. ");
INSERT INTO rift_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","ⴰⴷ ⵉⵙⵙⴰⵔⵙ ⴰⴼⵓⵙ ⵏⵏⴻⵙ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⵓⵛⴰ ⴰⴷ ⴰⵙ ⵉⵖⴰⵔⵚ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ. ");
INSERT INTO rift_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⴽⵙⵉ ⵓⴽⴻⵀⵀⴰⵏ ⵙ ⵓⴹⴰⴹ ⵏⵏⴻⵙ ⵛⵡⴰⵢⵜ ⵣⴻⴳ ⵉⴷⴰⵎⵎⴻⵏ ⵓⵛⴰ ⴰⴷ ⵜ ⵉⴳⴳ ⵖⴰⵔ ⵡⴰⵛⵛⴰⵡⴻⵏ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵓⵛⴰ ⴰⴷ ⵉⴼⴰⵔⵔⴻⵖ ⵎⴰⵔⵔⴰ ⵉⴷⴰⵎⵎⴻⵏ ⵉⵛⴻⵟⵟⴻⵏ ⵖⴰⵔ ⵓⴹⴰⵔ ⵏ ⵓⵄⴰⵍⵟⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","ⴰⴷ ⵅⴰⵙ ⵉⴽⴽⴻⵙ ⵎⴰⵔⵔⴰ ⵜⴰⴷⵓⵏⵜ ⵏⵏⴻⵙ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴽⴽⵙⴻⵏ ⵜⴰⴷⵓⵏⵜ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵍⴻⵀⵏⴰ ⵓⵛⴰ ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵜⵜ ⵉⵙⵙⴱⴻⵅⵅⴰⵔ ⵅ ⵓⵄⴰⵍⵟⴰⵔ, ⴰⴷ ⵜⵉⵍⵉ ⴷ ⵉⵛⵜ ⵏ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵉⵜⵜⴼⵓⵃⴻⵏ ⵉ ⵙⵉⴷⵉ. ⵓⵛⴰ ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵅⴰⵙ ⵉⴳⴳ ⴰⵚⵍⴰⵃ ⵓⵛⴰ ⴰⴷ ⴰⵙ ⵉⵜⵜⵡⴰⵖⴼⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","ⵎⴰⵍⴰ ⵉⵇⴻⴷⴷⴻⵎ ⵉⵊⵊ ⵏ ⵉⵣⵎⴰⵔ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⵇⴻⴷⴷⴻⵎ ⵉⵛⵜ ⵏ ⵜⴰⵡⵜⴻⵎⵜ ⵉⵛⵏⴰⵏ ⵇⴰⵄ. ");
INSERT INTO rift_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","ⴰⴷ ⵉⵙⵙⴰⵔⵙ ⴰⴼⵓⵙ ⵏⵏⴻⵙ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⵓⵛⴰ ⴰⴷ ⴰⵙ ⵉⵖⴰⵔⵚ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵎⴰⵏⵉ ⵖⴰⵔⵚⴻⵏ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ. ");
INSERT INTO rift_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⴽⵙⵉ ⵓⴽⴻⵀⵀⴰⵏ ⵙ ⵓⴹⴰⴹ ⵏⵏⴻⵙ ⵛⵡⴰⵢⵜ ⵣⴻⴳ ⵉⴷⴰⵎⵎⴻⵏ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⵓⵛⴰ ⴰⴷ ⵜ ⵉⴳⴳ ⵅ ⵡⴰⵛⵛⴰⵡⴻⵏ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ⵏ ⵡⴻⵛⵎⴰⴹ ⵓⵛⴰ ⴰⴷ ⵉⴼⴰⵔⵔⴻⵖ ⵎⴰⵔⵔⴰ ⵉⴷⴰⵎⵎⴻⵏ ⵏⵏⴻⵙ ⵉⵛⴻⵟⵟⴻⵏ ⵖⴰⵔ ⵓⴹⴰⵔ ⵏ ⵓⵄⴰⵍⵟⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","ⴰⴷ ⵅⴰⵙ ⵉⴽⴽⴻⵙ ⵎⴰⵔⵔⴰ ⵜⴰⴷⵓⵏⵜ ⵏⵏⴻⵙ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵉⴽⴽⴻⵙ ⵜⴰⴷⵓⵏⵜ ⵏ ⵓⵃⵓⵍⵉ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵍⴻⵀⵏⴰ, ⵓⵛⴰ ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵜⵜ ⵉⵙⵙⴱⴻⵅⵅⴰⵔ ⵅ ⵓⵄⴰⵍⵟⴰⵔ, ⵅ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵏ ⵜⵎⴻⵙⵙⵉ ⵉ ⵙⵉⴷⵉ ⵓⵛⴰ ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵅⴰⵙ ⵉⴳⴳ ⴰⵚⵍⴰⵃ ⵅ ⴷⴷⴻⵏⴱ ⵉ ⵉⴳⴳⴰ, ⵓⵛⴰ ⴰⴷ ⴰⵙ ⵉⵜⵜⵡⴰⵖⴼⴰⵔ.’” ");
INSERT INTO rift_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“ⵎⴰⵍⴰ ⵉⵅⴹⴰ ⵃⴻⴷ ⵓⵎⵉ ⵉⵙⵍⴰ ⴰⵀⴻⵊⵊⵉ ⵏ ⵉⵛⵜ ⵏ ⵏⵏⴻⵄⵍⴻⵜ ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⴷ ⴰⵛⴻⵀⵀⴰⴷ ⵅⴰⵙ, ⵏⵉⵖ ⵉⵥⵔⴰ ⵉ-ⵜ ⵏⵉⵖ ⵉⵙⵙⴻⵏ ⵉ-ⵜ: ⵎⴰⵍⴰ ⵡⴰⵔ ⵅⴰⵙ ⵉⵇⵇⴰⵔ ⵡⴰⵍⵓ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵢⴰⵔⴱⵓ ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","ⵏⵉⵖ ⵎⴰⵍⴰ ⵉⵃⴰⴷⴰ ⵃⴻⴷ ⵎⵉⵏ ⵎⴰ ⵣⵉ ⵜⵎⴻⵙⵍⴰⵛⵜ ⵉⵅⴻⵎⵊⴻⵏ, ⵍⵅⴻⵛⴱⴻⵜ ⵏ ⵍⵎⴰⵍ ⵉⵅⵎⴻⵊ, ⵏⵉⵖ ⵍⵅⴻⵛⴱⴻⵜ ⵏ ⵍⴻⴱⵀⵉⵎⴻⵜ ⵉⵅⴻⵎⵊⴻⵏ, ⵏⵉⵖ ⵍⵅⴻⵛⴱⴻⵜ ⵏ ⵓⵎⵓⴷⴷⴰⵔ ⵉⵅⵎⴻⵊ ⵉⵜⵜⴱⵓⵄⴻⵏ, ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵡⴰⵔ ⵉⵙⵙⵉⵏ ⴰⵢⴰ, ⴰⵇⴰ ⵉⵅⵎⴻⵊ ⵓ ⴷⴰⵢⴻⵙ ⴰⵎⴰⵔⵡⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","ⵏⵉⵖ ⵎⴰⵍⴰ ⵉⵃⴰⴷⴰ ⵛⴰ ⵏ ⵍⴻⵅⵎⴻⵊ ⵏ ⴱⵏⴰⴷⴻⵎ, ⵎⵉⵏ ⵎⴰ ⵣⵉ ⵍⴻⵅⵎⴻⵊ ⵏⵏⴻⵙ ⵉ ⵣⵉ ⵉⴷⵡⴻⵍ ⵏⴻⵜⵜⴰ ⵉⵅⵎⴻⵊ, ⵎⴰⵍⴰ ⵜⴻⵏⵏⵓⴼⴼⴰⵔ ⵅⴰⵙ ⵓⵛⴰ ⵉⵙⵙⴻⵏ ⵉⵜ ⴰⵡⴰⵔⵏⵉ ⴰⵙ, ⴰⵇⴰ ⴷⴰⵢⴻⵙ ⴰⵎⴰⵔⵡⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","ⵏⵉⵖ ⵎⴰⵍⴰ ⵉⵥⵥⵓⴵ ⵃⴻⴷ ⵙ ⵜⵛⴰⵔⴼⴰⵢⴻⵃ ⵏⵏⴻⵙ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⴳⴳ ⵍⵖⴰⵔ ⵏⵉⵖ ⴰⴷ ⵉⴳⴳ ⵍⵅⴰⵔ, ⵏⵉⵖ ⵎⵉⵏ ⵎⴰ ⵉⵣⴻⵎⵎⴰⵔ ⴱⵏⴰⴷⴻⵎ ⴰⴷ ⵉⵏⵟⴻⵇ ⴰⵎⴻⵏⵏⵉ ⵡⴰⵀⴰ ⵙ ⵉⵛⵜ ⵏ ⵜⵊⴰⴵⵉⵜ, ⴰⵎ ⵡⴰⵔ ⵜⵜ ⵉⵙⵙⵉⵏ, ⵎⴰⵛⴰ ⵉⵙⵙⴻⵏ ⵉ-ⵜ ⴰⵡⴰⵔⵏⵉ ⵎⴰⵏ ⴰⵢⴰ, ⴰⵇⴰ ⴷⴰⵢⴻⵙ ⴰⵎⴰⵔⵡⴰⵙ ⴷⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⵉⵛⵜ ⵣⵉ ⵜⵎⴻⵙⵍⴰⵢⵉⵏ-ⴰ. ");
INSERT INTO rift_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⵎⵙⴰⵔ, ⵎⴰⵍⴰ ⴷⴰⵢⴻⵙ ⴰⵎⴰⵔⵡⴰⵙ ⴷⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⵉⵛⵜⴻⵏ ⵣⵉ ⵜⵎⴻⵙⵍⴰⵢⵉⵏ-ⴰ, ⴰⴷ ⵉⵏⵄⴻⵎ ⵅ ⵎⵉⵏ ⵜⵓⵖⴰ ⵉⵅⴹⴰ. ");
INSERT INTO rift_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","ⵅ ⴷⴷⴻⵏⴱ ⵉ ⵉⴳⴳⴰ, ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⵙ ⴰⴷ ⵉⵇⴻⴷⴷⴻⵎ ⵉⵛⵜ ⵏ ⵜⴻⵡⵜⴻⵎⵜ ⵏ ⵡⵓⴵⵉ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵓⵎⴰⵔⵡⴰⵙ, ⵉⵛⵜ ⵏ ⵜⴻⵅⵙⵉ ⵏⵉⵖ ⵉⵛⵜ ⵏ ⵜⵖⴰⵢⴹⴻⵜ, ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⵉ ⵙⵉⴷⵉ, ⵓⵛⴰ ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵅⴰⵙ ⵉⴳⴳ ⴰⵚⵍⴰⵃ ⴷⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⴷⴷⴻⵏⴱ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⴰⴼⵓⵙ ⵏⵏⴻⵙ ⵡⴰⵔ ⵖⴰⵔⴻⵙ ⵎⵉⵏ ⵉⵇⴻⴷⴷⴻⵏ ⵉ ⵢⵉⵊⵊ ⵣⴻⴳ ⵡⵓⴵⵉ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵢⴰⵡⵉ ⵉ ⵙⵉⴷⵉ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵓⵎⴰⵔⵡⴰⵙ ⵅ ⴷⴷⴻⵏⴱ ⵉ ⵉⴳⴳⴰ, ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵊⵍⵉⵍⵍⵉⵃⵉⵏ ⵏⵉⵖ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⴷⴱⵉⵔⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⴻⵏ, ⵉⵊⵊⴻⵏ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⵓ ⵉⵊⵊⴻⵏ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ. ");
INSERT INTO rift_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","ⴰⴷ ⵜⴻⵏ ⵢⴰⵡⵉ ⵖⴰⵔ ⵓⴽⴻⵀⵀⴰⵏ, ⵡⴻⵏⵏⵉ ⴷⴷ ⵖⴰ ⵢⴰⵡⵢⴻⵏ ⴷ ⴰⵎⴻⵣⵡⴰⵔⵓ ⵜⴰⵊⵍⵉⵍⵍⵉⵃⵜ ⵏⵉⵖ ⴰⴹⴱⵉⵔ ⵉ ⵉⴵⴰⵏ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⵓⵛⴰ ⴰⴷ ⵉⴽⴽⴻⵙ ⴰⵣⴻⴵⵉⴼ ⵏⵏⴻⵙ ⵣⵉ ⵛⵡⴰⵢⵜ ⴰⵡⴰⵔⵏⵉ ⵢⵉⵔⵉ ⵏⵏⴻⵙ, ⵎⴰⵛⴰ ⵡⴰⵔ ⵜ ⵉⴱⴻⵟⵟⵉ ⵎⴰⵔⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","ⴰⴷ ⵉⵔⵓⵛⵛ ⵛⵡⴰⵢⵜ ⵏ ⵉⴷⴰⵎⵎⴻⵏ ⵖⴰⵔ ⵓⵖⴻⵣⴷⵉⵙ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ⵓⵛⴰ ⵎⵉⵏ ⵉⵛⴻⵟⵟⴻⵏ ⵣⴻⴳ ⵉⴷⴰⵎⵎⴻⵏ, ⴰⴷ ⵜ ⵉⵥⴻⵎⵎ ⵖⴰⵔ ⵓⴹⴰⵔ ⵏ ⵓⵄⴰⵍⵟⴰⵔ. ⴰⵇⴰ-ⵜⵜ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ. ");
INSERT INTO rift_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","ⴰⴷ ⵉⵙⵙⴻⵡⵊⴻⴷ ⴰⵎⴻⴷⴷⴰⵔ ⵏⵏⴻⵖⵏⵉ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴼⴰⵔⵉⴹⴰ ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⵅⴰⵙ ⵉ ⵖⴰ ⵢⴻⴳⴳ ⵓⴽⴻⵀⵀⴰⵏ ⴰⵚⵍⴰⵃ ⵅ ⴷⴷⴻⵏⴱ ⵏⵏⴻⵙ ⵉ ⵉⴳⴳⴰ ⵓⵛⴰ ⴰⴷ ⴰⵙ ⵉⵜⵜⵡⴰⵖⴼⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","ⵎⴰⵍⴰ ⴰⴼⵓⵙ ⵏⵏⴻⵙ ⵡⴰⵔ ⵖⴰⵔⴻⵙ ⵎⵉⵏ ⵉⵇⴻⴷⴷⴻⵏ ⵉ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵊⵍⵉⵍⵍⵉⵃⵉⵏ ⵏⵉⵖ ⵉ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⴷⴱⵉⵔⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⴻⵏ, ⵅⴻⵏⵏⵉ ⵡⴻⵏⵏⵉ ⵉⵅⴹⴰⵏ, ⴰⴷ ⵢⴰⵡⵉ ⴰⵎ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵜⴰⵄⵛⴰⵔⵜ ⵏ ⵉⵊⵊ ⵏ ⵉⴼⴰ ⵏ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⴷⴷⴻⵏⴱ. ⵡⴰⵔ ⵅⴰⵙ ⵉⵜⵜⴻⴳⴳ ⵣⵣⴻⵛⵜ ⵓⵍⴰ ⵡⴰⵔ ⵅⴰⵙ ⵉⵙⵙⵔⵓⵙⵉ ⵊⵊⴰⵡⵉ, ⵎⵉⵏⵣⵉ ⴰⵇⴰ-ⵜⵜ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ. ");
INSERT INTO rift_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","ⴰⴷ ⵜⵜ ⵢⴰⵡⵉ ⵖⴰⵔ ⵓⴽⴻⵀⵀⴰⵏ ⵓⵛⴰ ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵉⴽⵙⵉ ⵉⵊⵊ ⵏ ⵡⵓⵔⵓ ⵉⵛⵛⵓⵔ ⵓⵛⴰ ⴰⴷ ⵉⵙⵙⴱⴻⵅⵅⴰⵔ ⴰⵢⴰ ⴰⵎ ⵍⵉⴷⴰⵔⴻⵜ ⴷⴰⵢⴻⵙ ⵅ ⵓⵄⴰⵍⵟⴰⵔ, ⵅ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵏ ⵜⵎⴻⵙⵙⵉ ⵉ ⵙⵉⴷⵉ. ⴰⵇⴰ-ⵜⵜ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ. ");
INSERT INTO rift_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","ⴰⵎⵎⵓ ⵉ ⵅⴰⵙ ⵖⴰ ⵢⴻⴳⴳ ⵓⴽⴻⵀⵀⴰⵏ ⴰⵚⵍⴰⵃ ⵅ ⴷⴷⴻⵏⴱ ⵏⵏⴻⵙ ⵏⵏⵉ ⵉⴳⴳⴰ ⵣⵉ ⵊⵊⵉⵀⴻⵜ ⵏ ⵉⵛⵜⴻⵏ ⵣⵉ ⵜⵎⴻⵙⵍⴰⵢⵉⵏ-ⴰ ⵓⵛⴰ ⴰⴷ ⴰⵙ ⵉⵜⵜⵡⴰⵖⴼⴰⵔ. ⵎⵉⵏ ⵉⵛⴻⵟⵟⴻⵏ ⴰⴷ ⵢⵉⵍⵉ ⵉ ⵉⴽⴻⵀⵀⴰⵏⴻⵏ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵉ ⵢⴻⴵⴰⵏ ⴰⴽ-ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ.” ");
INSERT INTO rift_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“ⵎⴰⵍⴰ ⵉⴳⴳⴰ ⵃⴻⴷ ⵙ ⵍⴻⵖⴷⴰⵔ ⵓⵛⴰ ⵉⵅⴹⴰ ⵙ ⵓⵡⴻⴷⴷⴰⵔ ⴷⵉ ⵜⵎⴻⵙⵍⴰⵢⵉⵏ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵏ ⵙⵉⴷⵉ, ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵢⴰⵡⵉ ⵉⵛⴰⵔⵔⵉ ⵉⵛⵏⴰⵏ ⵇⴰⵄ ⵣⴻⴳ ⵡⵓⴵⵉ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵓⵎⴰⵔⵡⴰⵙ ⵉ ⵙⵉⴷⵉ. ⴰⴷ ⵜⵉⵍⵉ ⵍⵇⵉⵎⴻⵜ ⵏⵏⴻⵙ ⵄⵍⴰⵃⵙⴰⴱ ⵍⵇⵉⵎⴻⵜ ⵉ ⵜⵇⴻⴷⴷⴰⵔⴻⴷ ⵛⴻⴽ ⴷⴻⴳ ⵉⵛⵉⵇⵍⵓⵜⴻⵏ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵄⵍⴰⵃⵙⴰⴱ ⵛⵉⵇⵍⵓ ⵏ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ. ⴰⵇⴰ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵓⵎⴰⵔⵡⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","ⵣⵉ ⵜⵎⴻⵙⵍⴰⵢⵉⵏ ⵉⵇⴻⴷⴷⵙⴻⵏ ⴰⴷ ⵢⴰⵔⵔ ⴷⵉ ⵎⵉⵏ ⴷⵉ ⵉⵅⴹⴰ ⵇⴱⴻⵍ, ⵓⵛⴰ ⴰⴷ ⴷⴰⵢⴻⵙ ⵢⴰⵔⵏⵉ ⵍⴻⵅⵎⵓⵙ. ⵓⵛⴰ ⴰⴷ ⵉⵡⵛ ⵎⴰⵏ ⴰⵢⴰ ⵉ ⵓⴽⴻⵀⵀⴰⵏ ⵓⵛⴰ ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵜ ⵉⵙⵙⴻⵚⵍⴻⵃ ⵙ ⵉⵛⴰⵔⵔⵉ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵓⵎⴰⵔⵡⴰⵙ ⵓⵛⴰ ⴰⴷ ⴰⵙ ⵉⵜⵜⵡⴰⵖⴼⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","ⵎⴰⵍⴰ ⵉⵅⴹⴰ ⵃⴻⴷ ⵓⵛⴰ ⵉⴳⴳⴰ ⵉⵛⵜ ⵏ ⵜⵎⴻⵙⵍⴰⵛⵜ ⵉ ⵡⴰⵔ ⵜᵉⵜⵜⵛⵓⵡⵡⴰⵔ ⴰⴷ ⵜᵉⵜⵜⵡⴰⴳⴳ, ⴰⵎ ⴷⴷ-ⵉⴼⴼⴻⵖ ⴷⴻⴳ ⵉⵛⵜ ⵏ ⵜⵎⴻⵙⵍⴰⵛⵜ ⵣⵉ ⵜⵡⴻⵚⵚⴰ ⵏ ⵙⵉⴷⵉ, ⵓⵛⴰ ⵜⵓⵖⴰ ⵜⵏⵓⴼⴼⴰⵔ ⵅⴰⵙ, ⴰⴷ ⴷⴰⵢⴻⵙ ⵢⵉⵍⵉ ⵓⵎⴰⵔⵡⴰⵙ ⵓⵛⴰ ⴰⴷ ⵢⴰⵔⴱⵓ ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","ⴰⴷ ⵢⴰⵡⵉ ⵉⵊⵊ ⵏ ⵉⵛⴰⵔⵔⵉ ⵉⵛⵏⴰⵏ ⵇⴰⵄ ⵣⴻⴳ ⵡⵓⴵⵉ ⵖⴰⵔ ⵓⴽⴻⵀⵀⴰⵏ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵓⵎⴰⵔⵡⴰⵙ, ⴰⴷ ⵜⵉⵍⵉ ⵍⵇⵉⵎⴻⵜ ⵏⵏⴻⵙ ⵄⵍⴰⵃⵙⴰⴱ ⵍⵇⵉⵎⴻⵜ ⵉ ⵜⵇⴻⴷⴷⴰⵔⴻⴷ ⵛⴻⴽ ⵓⵛⴰ ⴰⴷ ⵜ ⵉⵙⵙⴻⵚⵍⴻⵃ ⵓⴽⴻⵀⵀⴰⵏ ⵅ ⵓⵡⴻⴷⴷⴰⵔ ⵏⵏⴻⵙ ⵉ ⴷⵉ ⵉⵡⴻⴷⴷⴰⵔ ⴰⵎ ⵡⴰⵔ ⵜ ⵉⵙⵙⵉⵏ ⵓⵛⴰ ⴰⴷ ⴰⵙ ⵉⵜⵜⵡⴰⵖⴼⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","ⴰⵇⴰ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵓⵎⴰⵔⵡⴰⵙ. ⵙ ⵜⵉⴷⴻⵜⵜ ⵜⵓⵖⴰ ⴷⴰⵢⴻⵙ ⴰⵎⴰⵔⵡⴰⵙ ⵣⵣⴰⵜ ⵉ ⵙⵉⴷⵉ.” ");
INSERT INTO rift_vpl VALUES ("LV5_20","004_5_20","LEV","5","20","20","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("LV5_21","004_5_21","LEV","5","21","21","“ⵎⴰⵍⴰ ⵉⵅⴹⴰ ⵃⴻⴷ ⵓⵛⴰ ⵉⵖⴷⴰⵔ ⵙⵉⴷⵉ ⴰⵎ ⵉⵙⵙⵅⴰⵔⵔⵉⵇ ⵅ ⵊⵊⴰⵔ ⵏⵏⴻⵙ ⵅ ⵎⵉⵏ ⴷ ⴰⵙ ⵉⵎⵎⴻⵡⵛⴻⵏ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜ ⵉⵃⴹⴰ, ⵏⵉⵖ ⵅ ⵎⵉⵏ ⵉⵊⵊⴰ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏⵏⴻⵙ, ⵏⵉⵖ ⵅ ⵎⵉⵏ ⵅⴰⵙ ⵢⵓⵛⴰⵔⴻⵏ, ⵏⵉⵖ ⵅ ⵛⴰ ⵏ ⵓⴱⴻⵄⵄⴻⵊ ⵉ ⵉⴳⴳⴰ ⵉ ⵊⵊⴰⵔ ⵏⵏⴻⵙ, ");
INSERT INTO rift_vpl VALUES ("LV5_22","004_5_22","LEV","5","22","22","ⵏⵉⵖ ⴰⵎ ⵉⵙⵙⵅⴰⵔⵔⵉⵇ ⵅ ⵛⴰ ⵎⵉⵏ ⵉⵡⴻⴷⴷⴰⵔⴻⵏ ⵉ ⵛⴰ ⵏ ⵢⵉⵊⵊⴻⵏ ⵓ ⵉⵜⵜⵡⴰⴼ ⵣⵣⴰⵢⴻⵙ ⵓⵛⴰ ⵅⴻⵏⵏⵉ ⵏⴻⵜⵜⴰ ⵉⵊⵊⵓⴵ ⵥⵓⵔ, ⵡⴰⵀ, ⴰⵎ ⵉⵙⵙⵅⴰⵔⵔⵉⵇ ⵏⴻⵜⵜⴰ ⵅ ⵉⵛⵜⴻⵏ ⵣⵉ ⵎⴰⵔⵔⴰ ⵜⵉⵎⴻⵙⵍⴰⵢⵉⵏ ⵏⵏⵉ ⵉⵜⵜⴻⴳⴳ ⴱⵏⴰⴷⴻⵎ ⴰⵍⴰⵎⵉ ⵉⵅⴻⵟⵟⴰ ⵙ ⵎⴰⵏ ⴰⵢⴰ, ");
INSERT INTO rift_vpl VALUES ("LV5_23","004_5_23","LEV","5","23","23","ⵅⴻⵏⵏⵉ ⵉⵜⵜⵅⴻⵚⵚⴰ, ⵓⵎⵉ ⵉⵅⴹⴰ ⵓⵛⴰ ⵉⴷⵡⴻⵍ ⴷⴰⵢⴻⵙ ⵓⵎⴰⵔⵡⴰⵙ, ⴰⵇⴰ ⵏⴻⵜⵜⴰ ⴰⴷ ⴷⴷ-ⵢⴰⵔⵔ ⵜⵓⵛⴻⴼⴼⴰⵔⵜ ⵏⵏⵉ ⵢⵓⵛⴰⵔ, ⵏⵉⵖ ⵎⵉⵏ ⵉⵜⵜⵡⴰⴽⴽⵙⴻⵏ ⵏⵏⵉ ⵉⴽⵙⵉ ⵏⴻⵜⵜⴰ ⵙ ⵓⵖⵉⵍ, ⵏⵉⵖ ⵎⵉⵏ ⵜⵓⵖⴰ ⵉⵃⴹⴰ ⵏⵏⵉ ⴷ ⴰⵙ ⵉⵎⵎⴻⵡⵛⴻⵏ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⵜ ⵉⵃⴹⴰ, ⵏⵉⵖ ⵎⵉⵏ ⵉⵡⴻⴷⴷⴰⵔⴻⵏ ⵏⵏⵉ ⵢⵓⴼⴰ. ");
INSERT INTO rift_vpl VALUES ("LV5_24","004_5_24","LEV","5","24","24","ⵓⵛⴰ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵅⴻⴼ ⵉⵊⵊⵓⴵ ⵥⵓⵔ, ⴰⴷ ⴷⴷ-ⵢⴰⵔⵔ ⵍⵇⵉⵎⴻⵜ ⵏⵏⴻⵙ ⵜⵎⵓⵏ ⵓⵛⴰ ⴰⴷ ⵢⴰⵔⵏⵉ ⵍⴻⵅⵎⵓⵙ. ⵏⴻⵜⵜⴰ ⴰⴷ ⵜ ⵉⵡⵛ ⵉ ⵡⴻⵏⵏⵉ ⵓⵎⵉ ⴷⴷ-ⵜⵓⵙⴰ ⴷⴻⴳ ⵡⴰⵙⵙ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏⵏⴻⵙ ⵏ ⵓⵎⴰⵔⵡⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("LV5_25","004_5_25","LEV","5","25","25","ⵏⴻⵜⵜⴰ ⴰⴷ ⵢⴰⵡⵉ ⵜⴰⵖⴰⵔⵚⵜ ⵏⵏⴻⵙ ⵏ ⵓⵎⴰⵔⵡⴰⵙ ⵖⴰⵔ ⵙⵉⴷⵉ, ⵉⵊⵊ ⵏ ⵉⵛⴰⵔⵔⵉ ⵉⵛⵏⴰⵏ ⵇⴰⵄ ⵣⴻⴳ ⵡⵓⴵⵉ, ⵡⴻⵏⵏⵉ ⵍⵇⵉⵎⴻⵜ ⵏⵏⴻⵙ ⴰⴷ ⵜⵉⵍⵉ ⵄⵍⴰⵃⵙⴰⴱ ⵍⵇⵉⵎⴻⵜ ⵉ ⵜⵇⴻⴷⴷⴰⵔⴻⴷ ⵛⴻⴽ, ⴰⴷ ⵜⵉⵍⵉ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵓⵎⴰⵔⵡⴰⵙ, ⵓⵛⴰ ⴰⴷ ⵜ ⵢⴰⵡⵉ ⵖⴰⵔ ⵓⴽⴻⵀⵀⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("LV5_26","004_5_26","LEV","5","26","26","ⵅⴻⵏⵏⵉ ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵅⴰⵙ ⵉⴳⴳ ⴰⵙⵍⴰⵃ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⵓⵛⴰ ⴰⴷ ⴰⵙ ⵉⵜⵜⵡⴰⵖⴼⴰⵔ ⵅ ⵎⵉⵏ ⵉⴳⴳⴰ, ⵎⴰⵍⴰ ⵉⴷⵡⴻⵍ ⴷⴰⵢⴻⵙ ⴰⵎⴰⵔⵡⴰⵙ ⵙ ⵉⵛⵜ ⵏ ⵜⵎⴻⵙⵍⴰⵛⵜ ⵣⵉ ⵎⴰⵔⵔⴰ ⵜⵉⵎⴻⵙⵍⴰⵢⵉⵏ-ⴰ.” ");
INSERT INTO rift_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“ⵓⵎⵓⵔ ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ, ⵉⵏⵉ ⴰⵙⴻⵏ: ‘ⵡⴰ ⴷ ⴰⵣⴻⵔⴼ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ. ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵅ ⵓⴽⴻⵛⵛⵓⴹ ⵅ ⵓⵄⴰⵍⵟⴰⵔ ⴰⴷ ⵜⴻⵇⵇⵉⵎ ⵜⴰⵔⴻⵇⵇ ⴵⵉⵍⴻⵜ ⵜⴻⴽⵎⴻⵍ ⴰⵍ ⵚⵚⴱⴻⵃ ⵓ ⵉⵜⵜⵅⴻⵚⵚⴰ ⵜⵉⵎⴻⵙⵙⵉ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ⴰⴷ ⵜⴻⵇⵇⵉⵎ ⴰⴷ ⵜⴻⵛⵎⴻⴹ ⴷⴰⵢⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵢⴰⵔⴹ ⴰⵙⴻⵍⵀⴰⵎ ⵏⵏⴻⵙ ⵏ ⵍⴻⵇⵟⴻⵏ, ⴰⴷ ⵉⴱⵢⴻⵙ ⵙⵙⴰⵔⵡⴰⵍ ⵏⵏⴻⵙ ⵏ ⵍⴻⵇⵟⴻⵏ ⵅ ⴰⵔⵔⵉⵎⴻⵜ ⵏⵏⴻⵙ, ⵓⵛⴰ ⴰⴷ ⵉⴽⵙⵉ ⵉⵖⵖⴻⴹ ⵏ ⵎⵉⵏ ⵉⵇⵇⵉⵎⴻⵏ ⵏ ⵜⴰⴷⵓⵏⵜ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ, ⵜⴻⵏⵏⵉ ⵜⴻⵛⵛⴰ ⵜⵎⴻⵙⵙⵉ, ⵓⵛⴰ ⴰⴷ ⵜ ⵉⵙⵙⴰⵔⵙ ⵣⵣⴰⵜ ⵉ ⵓⵄⴰⵍⵟⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⴽⴽⴻⵙ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⵢⴰⵔⴹ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵖⵏⵉ, ⴰⴷ ⵢⴰⵡⵉ ⵉⵖⵖⴻⴹ ⵏ ⵎⵉⵏ ⵉⵇⵇⵉⵎⴻⵏ ⵏ ⵜⴰⴷⵓⵏⵜ ⴱⴰⵔⵔⴰ ⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵖⴰⵔ ⵢⵉⵊⵊ ⵏ ⵡⴻⵎⵛⴰⵏ ⵉⵚⴼⴰ. ");
INSERT INTO rift_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜⴻⵇⵇⵉⵎ ⵜⵎⴻⵙⵙⵉ ⵜⴰⵔⴻⵇⵇ ⵅ ⵓⵄⴰⵍⵟⴰⵔ, ⵉⵜⵜⵅⴻⵚⵚⴰ ⵡⴰⵔ ⵜⵅⴻⵙⵙⵉ ⵛⴰ. ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵅⴰⵙ ⵉⵙⵙⴰⵔⵖ ⴰⴽⴻⵛⵛⵓⴹ ⴽⵓⵍ ⵚⵚⴱⴻⵃ ⵓⵛⴰ ⴰⴷ ⵅⴰⵙ ⵉⵙⴻⵜⵜⴻⴼ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵓⵛⴰ ⴰⴷ ⵅⴰⵙ ⵉⵙⵙⴱⴻⵅⵅⴰⵔ ⵜⴰⴷⵓⵏⵜ ⵏ ⵜⵖⴰⵔⵚⴰ ⵏ ⵍⴻⵀⵏⴰ. ");
INSERT INTO rift_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","ⵜⵉⵎⴻⵙⵙⵉ ⵅ ⵓⵄⴰⵍⵟⴰⵔ ⴰⴷ ⵜⴻⵇⵇⵉⵎ ⵜⴰⵔⴻⵇⵇ ⵍⴻⴱⴷⴰ, ⵡⴰⵔ ⵜⵅⴻⵙⵙⵉ.’” ");
INSERT INTO rift_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","“ⵡⴰ ⴷ ⴰⵣⴻⵔⴼ ⵉ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ. ⴰⵔⵔⴰⵡ ⵏ ⵀⴰⵔⵓⵏ ⴰⴷ ⵜⵜ ⴰⵡⵢⴻⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⵣⵣⴰⵜ ⵉ ⵓⵄⴰⵍⵟⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","ⵏⴻⵜⵜⴰ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵉⴽⵙⵉ ⵉⵊⵊ ⵏ ⵡⵓⵔⵓ ⵣⴻⴳ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⴰⴽ-ⴷ ⵛⴰ ⵏ ⵣⵣⴻⵛⵜ ⵏⵏⴻⵙ ⴷ ⵎⴰⵔⵔⴰ ⵊⵊⴰⵡⵉ ⵉ ⵉⴵⴰⵏ ⵅ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ. ⴰⴷ ⵉⵙⵙⴱⴻⵅⵅⴰⵔ ⴰⵢⴰ ⵅ ⵓⵄⴰⵍⵟⴰⵔ. ⴰⵇⴰ ⴷ ⵉⵛⵜ ⵏ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵉⵜⵜⴼⵓⵃⴻⵏ, ⵉⵛⵜ ⵏ ⵍⵉⴷⴰⵔⴻⵜ ⴷⴰⵢⴻⵙ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⴰⴷ ⵛⵛⴻⵏ ⵎⵉⵏ ⵣⵣⴰⵢⴻⵙ ⵉⵛⴻⵟⵟⴻⵏ. ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜ ⵛⵛⴻⵏ ⴱⵍⴰ ⴰⵏⵜⵓⵏ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⴰⵎⵇⴻⴷⴷⴰⵙ. ⴰⴷ ⵜ ⵛⵛⴻⵏ ⴷⵉ ⵍⴻⵎⵔⴰⵃ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","ⵡⴰⵔ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⵜ ⴳⴳⵯⴻⵏ ⵙ ⵡⴻⵏⵜⵓⵏ. ⵜⴰ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏⵙⴻⵏ ⵏⵏⵉ ⵡⵛⵉⵖ ⵏⴻⵛⵛ ⵣⵉ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵉⵏⵓ ⵏ ⵜⵎⴻⵙⵙⵉ. ⴰⵇⴰ-ⵜⵜ ⴷ ⵜⴰⵎⵇⴻⴷⴷⴰⵙⵜ ⵇⴰⵄ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⴷ ⵜⵖⴰⵔⵚⵜ ⵏ ⵓⵎⴰⵔⵡⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","ⵎⴰⵔⵔⴰ ⵉⵡⴻⵜⵎⴰⵏ ⵊⴰⵔ ⵡⴰⵔⵔⴰⵡ ⵏ ⵀⴰⵔⵓⵏ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵛⵛⴻⵏ. ⴰⵇⴰ-ⵜⵜ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵚⴻⵢⵢⴻⵜ ⵉ ⵍⴻⴱⴷⴰ ⵅ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵏ ⵜⵎⴻⵙⵙⵉ ⵏ ⵙⵉⴷⵉ ⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵏⵡⴻⵎ. ⵎⴰⵔⵔⴰ ⵡⵉ ⵜⵜ ⵖⴰ ⵉⵃⴰⴷⴰⵏ, ⴰⴷ ⵉⵜⵜⵡⴰⵇⴻⴷⴷⴻⵙ.” ");
INSERT INTO rift_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","“ⵜⴰ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⵉ ⵣⵉ ⴷⴷ ⵖⴰ ⵇⴰⵔⵔⴱⴻⵏ ⵖⴰⵔ ⵙⵉⴷⵉ ⴷⴻⴳ ⵡⴰⵙⵙ ⵎⵉⵏ ⴷⵉ ⵉ ⵖⴰ ⵉⵜⵜⵡⴰⴷⵀⴻⵏ ⵀⴰⵔⵓⵏ: ⵜⴰⵄⵛⴰⵔⵜ ⵏ ⵉⵊⵊ ⵏ ⵉⴼⴰ ⵏ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⴰⵎ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵉ ⵍⴻⴱⴷⴰ, ⴰⵣⵢⴻⵏ ⵏⵏⴻⵙ ⴷⵉ ⵚⵚⴱⴻⵃ ⴷ ⵡⴻⵣⵢⴻⵏ ⵏⵏⴻⵙ ⵏⵏⴻⵖⵏⵉ ⵖⴰⵔ ⵓⵄⴻⵛⵛⵉ. ");
INSERT INTO rift_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","ⴷⴻⴳ ⵉⵊⵊ ⵏ ⵓⵅⴷⵉⵎ ⴰⴷ ⵜⴻⵙⵙⴻⵡⵊⴻⴷ ⴰⵢⴰ ⵙ ⵣⵣⴻⵛⵜ ⵏ ⵣⵣⵉⵜⵓⵏ ⵓⵛⴰ ⴰⴷ ⵜ ⵜⴰⵡⵢⴻⴷ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⴰⵡⴰⵔⵏⵉ ⵜ ⵜⵅⴻⴵⴹⴻⴷ. ⴰⴷ ⵜⵇⴻⴷⴷⵎⴻⴷ ⵉⵍⴻⵇⵇⵡⴰⵣ ⵜⵜⵡⴰⵔⵥⴰⵏ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⴰⵎ ⵉⵛⵜ ⵏ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵉⵜⵜⴼⵓⵃⴻⵏ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","ⴰⴽⴻⵀⵀⴰⵏ ⵏⵏⵉ ⵖⴰ ⴷⴻⵀⵏⴻⵏ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏⵏⴻⵙ ⵣⴻⴳ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ, ⴰⴷ ⵜⵜ ⵉⵙⵙⴻⵡⵊⴻⴷ. ⴰⵇⴰ-ⵜⵜ ⴷ ⵜⴰⵡⵚⴻⵢⵢⴻⵜ ⵉ ⵍⴻⴱⴷⴰ. ⵜⴰⵡⵀⵉⴱⵜ-ⴰ ⴰⴷ ⵜᵉⵜⵜⵡⴰⴱⴻⵅⵅⴰⵔ ⵉ ⵙⵉⴷⵉ ⵎⴰⵔⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","ⵎⴰⵔⵔⴰ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵏ ⵓⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵜⵉⵍⵉ ⵜⴻⴽⵎⴻⵍ. ⵡⴰⵔ ⵣⵣⴰⵢⴻⵙ ⵜⵜᵉⵜⵜⴻⵏ ⵛⴰ.” ");
INSERT INTO rift_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","“ⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ, ⵉⵏⵉ ⴰⵙⴻⵏ: ‘ⵡⴰ ⴷ ⴰⵣⴻⵔⴼ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ: ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵎⴰⵏⵉ ⵜᵉⵜⵜⵡⴰⵖⴰⵔⵚ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ, ⴰⴷ ⵜᵉⵜⵜⵡⴰⵖⴰⵔⵚ ⵄⴰⵡⴻⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ⴰⵇⴰ-ⵜⵜ ⴷ ⵜⴰⵎⵇⴻⴷⴷⴰⵙⵜ ⵇⴰⵄ. ");
INSERT INTO rift_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","ⴰⴽⴻⵀⵀⴰⵏ ⵏⵏⵉ ⵜⵜ ⵖⴰ ⵉⵇⴻⴷⴷⵎⴻⵏ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵢⴻⵛⵛ. ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜᵉⵜⵜⵡⴰⵛⵛ ⴷⴻⴳ ⵉⵊⵊ ⵏ ⵡⴻⵎⵛⴰⵏ ⴰⵎⵇⴻⴷⴷⴰⵙ ⴷⵉ ⵍⴻⵎⵔⴰⵃ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","ⵎⴰⵔⵔⴰ ⵡⵉ ⵖⴰ ⵉⵃⴰⴷⴰⵏ ⴰⵢⵙⵓⵎ ⵏⵏⴻⵙ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵉⵜⵜⵡⴰⵇⴻⴷⴷⴻⵙ. ⵎⴰⵍⴰ ⵉⵏⴳⴻⵣ ⵛⵡⴰⵢⵜ ⵣⴻⴳ ⵉⴷⴰⵎⵎⴻⵏ ⵅ ⵢⵉⵊⵊ ⵏ ⵡⴰⵔⵔⵓⴹ, ⵅⴻⵏⵏⵉ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜⴻⵙⵙⵉⵔⴷⴻⴷ ⵎⵉⵏ ⵅⴰⵙ ⵉⴱⴻⵇⵇⴹⴻⵏ ⴷⴻⴳ ⵉⵊⵊ ⵏ ⵡⴻⵎⵛⴰⵏ ⴰⵎⵇⴻⴷⴷⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","ⵓⵛⴰ ⵍⵇⴻⵛⵄⴻⵜ ⵏ ⵜⵍⴰⵅⵜ ⵉ ⴷⵉ ⵜⵜ ⵙⵙⵏⴻⵏⵏⴰⵏ, ⴰⴷ ⵜᵉⵜⵜⵡⴰⵔⵥ, ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⵙⵙⴻⵏⵡⴻⵏ ⵜⵜ ⴷⴻⴳ ⵉⵛⵜ ⵏ ⵍⵇⴻⵛⵄⴻⵜ ⵏ ⵏⵏⵃⴰⵙ, ⵅⴻⵏⵏⵉ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵃⴻⴽⴽⴻⵏ ⵓ ⴰⴷ ⵙⵙⵍⵉⵍⴻⵏ ⵍⵇⴻⵛⵄⴻⵜ ⵙ ⵡⴰⵎⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","ⵎⴰⵔⵔⴰ ⵡⵉ ⵉⴵⴰⵏ ⴷ ⴰⵡⵜⴻⵎ ⵊⴰⵔ ⵉⴽⴻⵀⵀⴰⵏⴻⵏ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵢⴻⵛⵛ. ⴰⵇⴰ-ⵜⵜ ⴷ ⵜⴰⵎⵇⴻⴷⴷⴰⵙⵜ ⵇⴰⵄ. ");
INSERT INTO rift_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","ⵎⴰⵛⴰ ⵓⵍⴰ ⴷ ⵉⵛⵜ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⵉ ⵣⵉ ⵜⵜⵡⴰⵇⴻⴷⴷⵎⴻⵏ ⵉⴷⴰⵎⵎⴻⵏ ⵏⵏⴻⵙ ⴷⴻⴳ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⵍⵉⵏ ⵉ ⵡⴻⵚⵍⴰⵃ ⴷⵉ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ, ⵡⴰⵔ ⵣⵣⴰⵢⴻⵙ ⵉⵜⵜⵡⴰⵛⵛ ⵛⴰ. ⴰⴷ ⵜᵉⵜⵜⵡⴰⵛⵎⴻⴹ ⵙ ⵜⵎⴻⵙⵙⵉ.’” ");
INSERT INTO rift_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“ⵡⴰ ⴷ ⴰⵣⴻⵔⴼ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵓⵎⵡⴰⵔⵡⴰⵙ. ⴰⵇⴰ ⴷ ⵜⴰⵎⵇⴻⴷⴷⴰⵙⵜ ⵇⴰⵄ. ");
INSERT INTO rift_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵎⴰⵏⵉ ⵖⴰⵔⵔⵚⴻⵏ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ, ⴰⴷ ⵖⴰⵔⵚⴻⵏ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵓⵎⴰⵔⵡⴰⵙ. ⴰⴷ ⵉⵣⴻⴵⴻⵄ ⵉⴷⴰⵎⵎⴻⵏ ⵏⵏⴻⵙ ⵅ ⵓⵄⴰⵍⵟⴰⵔ ⵖⴰⵔ ⵎⴰⵔⵔⴰ ⵉⵖⴻⵣⴷⵉⵙⴻⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","ⴰⴷ ⵢⴰⵡⵉ ⵎⴰⵔⵔⴰ ⵜⴰⴷⵓⵏⵜ ⵏⵏⴻⵙ: ⴰⵏⴻⵡⵡⴰⵔ ⵏ ⵜⴰⴷⵓⵏⵜ ⴷ ⵜⴰⴷⵓⵏⵜ ⵏⵏⵉ ⵉⴷⵍⵉⵏ ⴰⴷⴰⵏ, ");
INSERT INTO rift_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ⵓⵛⴰ ⴰⴷ ⵉⴽⴽⴻⵙ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵉⵥⵥⴰⵍ ⴰⴽ-ⴷ ⵜⴰⴷⵓⵏⵜ ⵉ ⵅⴰⵙⴻⵏⵜ ⵉⴵⴰⵏ ⵖⴰⵔ ⵜⴻⵊⵄⵉⵏⵏⴰ, ⵓⵍⴰ ⴷ ⵎⵉⵏ ⵢⵓⵢⵍⴻⵏ ⵖⴰⵔ ⵜⵙⴰ ⵓⵛⴰ ⵢⴰⵔⵙⴰ ⵅ ⵜⵉⵥⵥⴰⵍ, ");
INSERT INTO rift_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","ⵓⵛⴰ ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵉⵙⵙⴱⴻⵅⵅⴰⵔ ⴰⵢⴰ ⵅ ⵓⵄⴰⵍⵟⴰⵔ ⴰⵎ ⵢⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ ⵉ ⵙⵉⴷⵉ. ⴰⵇⴰ-ⵜⵜ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵓⵎⴰⵔⵡⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","ⵎⴰⵔⵔⴰ ⴰⵡⵜⴻⵎ ⵊⴰⵔ ⵉⴽⴻⵀⵀⴰⵏⴻⵏ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵢⴻⵛⵛ. ⴰⴷ ⵉⵜⵜⵡⴰⵛⵛ ⴷⴻⴳ ⵉⵊⵊ ⵏ ⵡⴻⵎⵛⴰⵏ ⴰⵎⵇⴻⴷⴷⴰⵙ, ⴰⵇⴰ-ⵜⵜ ⴷ ⵜⴰⵎⵇⴻⴷⴷⴰⵙⵜ ⵇⴰⵄ. ");
INSERT INTO rift_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","ⴰⴷ ⵢⵉⵍⵉ ⵉⵊⵊ ⵏ ⵓⵣⴻⵔⴼ ⴰⵎ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⴰⵎ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵓⵎⵡⴰⵔⵡⴰⵙ. ⴰⴷ ⵢⵉⵍⵉ ⵡⴻⵢⵙⵓⵎ ⵏ ⵜⵖⴰⵔⵚⵜ ⵉ ⵓⴽⴻⵀⵀⴰⵏ, ⵡⴻⵏⵏⵉ ⵜⵓⵖⴰ ⵣⵣⴰⵢⴻⵙ ⵉⴳⴳ ⴰⵚⵍⴰⵃ ⵅ ⵛⴰ ⵏ ⵢⵉⵊⵊⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","ⴰⴽⴻⵀⵀⴰⵏ ⵏⵏⵉ ⵉ ⵖⴰ ⵉⵇⴻⴷⴷⵎⴻⵏ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵏ ⵛⴰ ⵏ ⵉⵊⵊⴻⵏ, ⵉ ⵓⴽⴻⵀⵀⴰⵏ ⵏⵏⵉ ⴰⴷ ⵜⵉⵍⵉ ⵜⴻⵍⵎⴻⵛⵜ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵜⵎⴻⵙⵙⵉ ⵏⵏⵉ ⴷⴷ-ⵉⵇⴻⴷⴷⴻⵎ, ⵜⵉⵍⵎⴻⵛⵜ ⴰⴷ ⵜⵉⵍⵉ ⵉ ⵏⴻⵜⵜⴰ. ");
INSERT INTO rift_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","ⴽⵓⵍ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵏⵏⵉ ⴹⴰⵔⵔⵃⴻⵏ ⵏⵉⵜⵏⵉ ⴷⵉ ⵜⴻⴼⵇⵓⵏⵜ ⵓⵍⴰ ⴷ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⵜⵜⵡⴰⵙⵙⵡⴻⵊⴷⴻⵏ ⴷⵉ ⵟⵟⴰⵊⵊⵉⵏ ⵏⵉⵖ ⴷⴻⴳ ⵡⴻⵅⴷⵉⵎ, ⴷ ⵎⴰⵏ ⴰⵢⴰ ⴰⴷ ⵢⵉⵍⵉ ⵉ ⵓⴽⴻⵀⵀⴰⵏ ⵏⵏⵉ ⵜ ⵉⵇⴻⴷⴷⵎⴻⵏ, ⴰⴷ ⵢⵉⵍⵉ ⵉ ⵏⴻⵜⵜⴰ. ");
INSERT INTO rift_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","ⴽⵓⵍ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵉ ⵉⵜⵜⵡⴰⵅⴻⴵⴹⴻⵏ ⵙ ⵣⵣⴻⵛⵜ ⵏ ⵣⵣⵉⵜⵓⵏ ⵏⵉⵖ ⵢⵓⵥⵖⴻⵏ, ⴰⴷ ⵜⵉⵍⵉ ⵉ ⵎⴰⵔⵔⴰ ⴰⵔⵔⴰⵡ ⵏ ⵀⴰⵔⵓⵏ, ⴰⵎ ⵉ ⵢⵉⵊⵊ ⴰⵎ ⵉ ⵡⴻⵏⵏⴻⵖⵏⵉ.” ");
INSERT INTO rift_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“ⵡⴰ ⴷ ⴰⵣⴻⵔⴼ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵍⴻⵀⵏⴰ ⵜⴻⵏⵏⵉ ⵉ ⵖⴰ ⵉⵇⴻⴷⴷⴻⵎ ⴱⵏⴰⴷⴻⵎ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","ⵎⴰⵍⴰ ⴰⴷ ⵜⵜ ⵉⵇⴻⴷⴷⴻⵎ ⵉ ⵓⵇⴰⴷⵉ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⵇⴻⴷⴷⴻⵎ ⴰⴽ-ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵓⵇⴰⴷⵉ ⵓⵍⴰ ⴷ ⵍⴻⵎⵙⴻⵎⵏⴰⵜ ⴱⵍⴰ ⴰⵏⵜⵓⵏ ⵉⵅⴻⴵⴹⴻⵏ ⵙ ⵣⵣⴻⵛⵜ ⴷ ⵜⴻⵍⴼⴰⴼ ⴱⵍⴰ ⴰⵏⵜⵓⵏ ⵜⵜⵡⴰⴷⴻⵀⵏⴻⵏⵜ ⵙ ⵣⵣⴻⵛⵜ ⴷ ⵍⴻⵎⵙⴻⵎⵏⴰⵜ ⵏ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⵜⵜⵡⴰⵅⴻⴵⴹⴻⵏⵜ ⵙ ⵣⵣⴻⵛⵜ. ");
INSERT INTO rift_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","ⴰⴷ ⵉⵇⴻⴷⴷⴻⵎ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⴰⴽ-ⴷ ⵍⴻⵎⵙⴻⵎⵏⴰⵜ ⵏ ⵡⴻⵖⵔⵓⵎ ⵙ ⵡⴻⵏⵜⵓⵏ, ⵊⵎⵉⵄ ⴰⴽ-ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵓⵇⴰⴷⵉ, ⵜⴻⵏⵏⵉ ⵉⴵⴰⵏ ⵣⵉ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵏⵏⴻⵙ ⵏ ⵍⴻⵀⵏⴰ. ");
INSERT INTO rift_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","ⵣⵉ ⴽⵓⵍ ⴷⴷⴰⵔⴱ ⵏ ⵜⴰⵡⵀⵉⴱⵜ ⴰⴷ ⵉⵇⴻⴷⴷⴻⵎ ⵉⵛⵜⴻⵏ ⵣⵣⴰⵢⴻⵙ ⴰⵎ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵓⵙⴳⴻⵄⵄⴻⴷ ⵉ ⵙⵉⴷⵉ. ⴰⴷ ⵜⵉⵍⵉ ⵉ ⵓⴽⴻⵀⵀⴰⵏ ⵏⵏⵉ ⵉ ⵖⴰ ⵉⵣⴻⴵⵄⴻⵏ ⵉⴷⴰⵎⵎⴻⵏ ⵏ ⵜⵖⴰⵔⵚⴰ ⵏ ⵍⴻⵀⵏⴰ ⵅ ⵓⵄⴰⵍⵟⴰⵔ ⵖⴰⵔ ⵎⴰⵔⵔⴰ ⵉⵖⴻⵣⴷⵉⵙⴻⵏ ⵏⵏⴻⵙ, ⴰⴷ ⵜⵉⵍⵉ ⵉ ⵏⴻⵜⵜⴰ. ");
INSERT INTO rift_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","ⴰⵢⵙⵓⵎ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵓⵇⴰⴷⵉ, ⵜⴻⵏⵏⵉ ⵉⴵⴰⵏ ⵣⵉ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵏⵏⴻⵙ ⵏ ⵍⴻⵀⵏⴰ, ⴰⴷ ⵉⵜⵜⵡⴰⵛⵛ ⴷⴻⴳ ⵡⴰⵙⵙ ⵉ ⴷⵉ ⵖⴰ ⵉⵇⴻⴷⴷⴻⵎ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ. ⵡⴰⵔ ⵉⵜⵜⴻⵊⵊⵉ ⵣⵣⴰⵢⴻⵙ ⵡⴰⵍⵓ ⴰⵍ ⵚⵚⴱⴻⵃ. ");
INSERT INTO rift_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","ⵎⴰⵍⴰ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵜⵓⵙⴰ-ⴷⴷ ⴰⴽ-ⴷ ⵉⵊⵊ ⵏ ⵍⵡⴰⵄⴷ ⵏⵉⵖ ⵜⴻⴵⴰ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵙ ⵍⵅⴰⴹⴰⵔ, ⴰⴷ ⵜᵉⵜⵜⵡⴰⵛⵛ ⴷⴻⴳ ⵡⴰⵙⵙ ⵉ ⴷⵉ ⵉ ⵖⴰ ⵉⵇⴻⴷⴷⴻⵎ ⵜⴰⵖⴰⵔⵚⵜ ⵏⵏⴻⵙ ⵓⵛⴰ ⵎⵉⵏ ⵣⵣⴰⵢⴻⵙ ⵉⵛⴻⵟⵟⴻⵏ ⴰⴷ ⵉⵜⵜⵡⴰⵛⵛ ⴷⴻⴳ ⵡⴰⵙⵙ ⵉ-ⵜ-ⵉ-ⴷⴷ-ⵉⴹⴼⴰⵔⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","ⵎⵉⵏ ⵉⵛⴻⵟⵟⴻⵏ ⵄⴰⴷ ⵣⴻⴳ ⵡⴻⵢⵙⵓⵎ ⵏ ⵜⵖⴰⵔⵚⵜ ⴰⴷ ⵉⵜⵜⵡⴰⵛⵎⴻⴹ ⵙ ⵜⵎⴻⵙⵙⵉ ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵜⵍⴰⵜⴰ. ");
INSERT INTO rift_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","ⵎⴰⵍⴰ ⵉⵜⵜⵡⴰⵛⵛ ⵄⴰⴷ ⵣⴻⴳ ⵡⴻⵢⵙⵓⵎ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏⵏⴻⵙ ⵏ ⵍⴻⵀⵏⴰ ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵜⵍⴰⵜⴰ, ⵅⴻⵏⵏⵉ ⵡⴻⵏⵏⵉ ⵜⵜ ⵉⵇⴻⴷⴷⵎⴻⵏ ⵡⴰⵔ ⵉⵜⵜⵉⵍⵉ ⵉ ⴰⵔⴹⴰ ⵏ ⵙⵉⴷⵉ ⵓ ⵜⴰⵖⴰⵔⵚⵜ ⵏⵏⴻⵙ ⵡⴰⵔ ⴷ ⴰⵙ ⵜᵉⵜⵜⵡⵉⵃⵙⵉⴱ ⵛⴰ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵍⴻⵀⵏⴰ. ⴰⴷ ⵜⵉⵍⵉ ⴷ ⵉⵛⵜ ⵏ ⵊⵊⵄⵉⴼⴻⵛⵜ ⵓⵛⴰ ⵡⴻⵏⵏⵉ ⵣⵣⴰⵢⴻⵙ ⵖⴰ ⵉⵛⵛⴻⵏ ⴰⴷ ⵢⴰⵔⴱⵓ ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","ⴰⵢⵙⵓⵎ ⵏⵏⵉ ⵉⵃⴰⴷⴰⵏ ⵛⴰ ⵏ ⵜⵎⴻⵙⵍⴰⵛⵜ ⵉⵅⴻⵎⵊⴻⵏ, ⵡⴰⵔ ⵣⵣⴰⵢⴻⵙ ⵜⵜᵉⵜⵜⴻⵎ. ⴰⴷ ⵜ ⵙⵙⵛⴻⵎⴹⴻⵏ ⵙ ⵜⵎⴻⵙⵙⵉ. ⵣⵉ ⵎⵉⵏ ⵉⵛⴻⵟⵟⴻⵏ ⵏ ⵡⴻⵢⵙⵓⵎ, ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵢⴻⵛⵛ ⵎⴰⵔⵔⴰ ⵡⴻⵏⵏⵉ ⵉⵣⴻⴷⴳⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","ⴷ ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵉⵛⵛⴻⵏ ⵣⴻⴳ ⵡⴻⵢⵙⵓⵎ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵍⴻⵀⵏⴰ, ⵜⴻⵏⵏⵉ ⵉⴵⴰⵏ ⵉ ⵙⵉⴷⵉ, ⴰⵎ ⵅⴰⵙ ⵢⴰⵔⵙⴰ ⵍⴻⵅⵎⴻⵊ ⵏⵏⴻⵙ, ⵍⴻⵄⵎⴰⵔ ⵏⵏⵉ ⴰⴷ ⵉⵜⵜⵡⴰⵇⴻⵙⵙ ⵣⵉ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","ⵎⴰⵍⴰ ⵉⵃⴰⴷⴰ ⵃⴻⴷ ⵛⴰ ⵏ ⵜⵎⴻⵙⵍⴰⵛⵜ ⵉⵅⵎⴻⵊ, ⴰⵎⴻⵛⵏⴰⵡ ⵍⴻⵅⵎⴻⵊ ⵏ ⴱⵏⴰⴷⴻⵎ ⵏⵉⵖ ⵍⴻⵅⵎⴻⵊ ⵏ ⵢⵉⵛⵜ ⵏ ⵍⴻⴱⵀⵉⵎⴻⵜ ⵉⵅⴻⵎⵊⴻⵏ ⵏⵉⵖ ⵛⴰ ⵏ ⵜⵎⴻⵙⵍⴰⵛⵜ ⵉ ⵉⴵⴰⵏ ⴷ ⵏⵏⵄⵉ ⵏ ⵍⴻⵅⵎⴻⵊ, ⵓⵛⴰ ⵅⴻⵏⵏⵉ ⴰⴷ ⵢⴻⵛⵛ ⵣⴻⴳ ⵡⴻⵢⵙⵓⵎ ⵏ ⵜⵖⴰⵔⵚⵉⵏ ⵏ ⵍⴻⵀⵏⴰ ⵉ ⵙⵉⴷⵉ, ⵍⴻⵄⵎⴰⵔ ⵏⵏⵉ ⴰⴷ ⵉⵜⵜⵡⴰⵇⴻⵙⵙ ⵣⵉ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ.” ");
INSERT INTO rift_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“ⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵉⵏⵉ: ‘ⴽⴻⵏⵏⵉⵡ ⵡⴰⵔ ⵜⵜᵉⵜⵜⴻⵎ ⵛⴰ ⵇⴰⵄ ⵜⴰⴷⵓⵏⵜ ⵏ ⵓⴼⵓⵏⴰⵙ ⵏⵉⵖ ⵏ ⵉⵣⵎⴰⵔ ⵏⵉⵖ ⵏ ⵉⵖⴰⵢⴹ. ");
INSERT INTO rift_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","ⵜⴰⴷⵓⵏⵜ ⵏ ⵉⵛⵜ ⵏ ⵍⵅⴻⵛⴱⴻⵜ ⴷ ⵜⴰⴷⵓⵏⵜ ⵏ ⵉⵊⵊ ⵏ ⵓⵎⵓⴷⴷⴰⵔ ⵎⴻⵣⵣⵇⴻⵏ ⵜ, ⵜⵄⴻⴷⴷⴻⵍ ⴰⴷ ⵜᵉⵜⵜⵡⴰⴳⴳ ⵉ ⵎⴰⵎⵎⴻⵛ ⵎⴰ ⵜⴻⴳⴳⴰ ⵍⵅⴻⴷⵎⴻⵜ, ⵎⴰⵛⴰ ⴽⴻⵏⵏⵉⵡ ⵡⴰⵔ ⵣⵣⴰⵢⴻⵙ ⵜⵜᵉⵜⵜⴻⵎ ⵡⴰⵍⵓ. ");
INSERT INTO rift_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","ⵎⴰⵏ ⵡⴻⵏ ⵉ ⵖⴰ ⵉⵛⵛⴻⵏ ⵜⴰⴷⵓⵏⵜ ⵏ ⵢⵉⵛⵜ ⵏ ⵍⴻⴱⵀⵉⵎⴻⵜ ⵉ ⵣⵉ ⴷⴷ ⵖⴰ ⵙⵙⵇⴰⵔⵔⴱⴻⵏ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ ⵉ ⵙⵉⴷⵉ, ⵍⴻⵄⵎⴰⵔ ⵏⵏⵉ ⵣⵣⴰⵢⴻⵙ ⵉ ⵖⴰ ⵉⵛⵛⴻⵏ, ⴰⴷ ⵉⵜⵜⵡⴰⵇⴻⵙⵙ ⵣⵉ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","ⴷⵉ ⵎⴰⵔⵔⴰ ⵜⵉⵣⴻⴷⴷⵉⵖⵉⵏ ⵏⵡⴻⵎ ⵡⴰⵔ ⵜⵜᵉⵜⵜⴻⵎ ⵓⵍⴰ ⴷ ⵛⴰ ⵣⴻⴳ ⵉⴷⴰⵎⵎⴻⵏ, ⴰⵎ ⵣⴻⴳ ⵉⵊⴹⴰⴹ ⴰⵎ ⵣⵉ ⵍⴻⴱⵀⴰⵢⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","ⴽⵓⵍ ⵉⵊⵊ ⵏ ⵍⴻⵄⵎⴰⵔ ⵏⵏⵉ ⵉ ⵖⴰ ⵉⵛⵛⴻⵏ ⵎⵖⵉⵔ ⵛⴰ ⵣⴻⴳ ⵉⴷⴰⵎⵎⴻⵏ, ⵍⴻⵄⵎⴰⵔ ⵏⵏⵉ ⴰⴷ ⵉⵜⵜⵡⴰⵇⴻⵙⵙ ⵣⵉ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ.’” ");
INSERT INTO rift_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“ⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵉⵏⵉ: ‘ⵡⵉ ⵉ ⴷⴷ ⵖⴰ ⵉⵙⵙⵇⴰⵔⵔⴱⴻⵏ ⵜⵖⴰⵔⵚⵜ ⵏⵏⴻⵙ ⵏ ⵍⴻⵀⵏⴰ ⵉ ⵙⵉⴷⵉ, ⴰⴷ ⵉⵇⴻⴷⴷⴻⵎ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵉ ⵙⵉⴷⵉ ⵣⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵍⴻⵀⵏⴰ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","ⵙ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵏⴻⵙ ⴰⴷ ⵢⴰⵡⵉ ⵜⵉⵡⵀⵉⴱⵉⵏ ⵏ ⵜⵎⴻⵙⵙⵉ ⵣⵣⴰⵜ ⵉ ⵙⵉⴷⵉ. ⵜⴰⴷⵓⵏⵜ ⵉ ⵉⴵⴰⵏ ⵅ ⵉⴷⵎⴰⵔⴻⵏ ⴰⴷ ⵜⵜ ⵢⴰⵡⵉ ⴰⴽ-ⴷ ⵉⴷⵎⴰⵔⴻⵏ ⵏⵏⵉ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⵜ ⵉⵙⵙⴻⵏⵀⴻⵣⵣ ⵣⵉ ⵙⵙⴰ ⵖⴰⵔ ⴷⴰ ⴰⵎ ⵢⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵡⴻⵏⵀⴻⵣⵣⵉ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵉⵙⵙⴱⴻⵅⵅⴰⵔ ⵜⴰⴷⵓⵏⵜ ⵅ ⵓⵄⴰⵍⵟⴰⵔ, ⵎⴰⵛⴰ ⵉⴷⵎⴰⵔⴻⵏ ⴰⴷ ⵉⵍⵉⵏ ⵉ ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","ⵣⵉ ⵜⵖⴰⵔⵚⴰ ⵏⵡⴻⵎ ⵏ ⵍⴻⵀⵏⴰ ⴰⴷ ⵜⵇⴻⴷⴷⵎⴻⵎ ⵉ ⵓⴽⴻⵀⵀⴰⵏ ⵄⴰⵡⴻⴷ ⴰⵛⴻⴽⵔⵓⴷ ⴰⴼⵓⵙⵉ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵓⵙⴳⴻⵄⵄⴻⴷ. ");
INSERT INTO rift_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","ⴰⵛⴻⴽⵔⵓⴷ ⴰⴼⵓⵙⵉ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵜⴰⵙⵖⴰⵔⵜ ⵏ ⵡⴻⵏⵏⵉ ⵣⴻⴳ ⵡⴰⵔⵔⴰⵡ ⵏ ⵀⴰⵔⵓⵏ ⵉ ⵖⴰ ⵉⵇⴻⴷⴷⵎⴻⵏ ⵉⴷⴰⵎⵎⴻⵏ ⵏ ⵜⵖⴰⵔⵚⵉ ⵏ ⵍⴻⵀⵏⴰ ⴷ ⵜⴰⴷⵓⵏⵜ ⵏⵙⴻⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","ⵎⵉⵏⵣⵉ ⵏⴻⵛⵛ ⴽⵙⵉⵖ ⵉⴷⵎⴰⵔⴻⵏ ⵏ ⵡⴻⵏⵀⴻⵣⵣⵉ ⴷ ⵓⵛⴻⴽⵔⵓⴷ ⵉ ⴷⴷ-ⵉⵜⵜⵡⴰⵙⵙⴳⴻⵄⵄⴷⴻⵏ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵣⵉ ⵜⵖⴰⵔⵚⵉ ⵏ ⵍⴻⵀⵏⴰ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓ ⵡⵛⵉⵖ ⵜⴻⵏ ⵉ ⵓⴽⴻⵀⵀⴰⵏ ⵀⴰⵔⵓⵏ ⵓ ⵉ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⴰⵎ ⵢⵉⵛⵜ ⵏ ⵍⴼⴰⵔⵉⴹⴰ ⵉ ⵍⴻⴱⴷⴰ, ⵣⵉ ⵊⵊⵉⵀⴻⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","ⵜⴰ ⴷ ⵜⴰⵙⵖⴰⵔⵜ ⵉⵜⵜⵡⴰⵙⵙⴷⴻⵀⵏⴻⵏ ⵏ ⵀⴰⵔⵓⵏ ⴷ ⵜⴻⵙⵖⴰⵔⵜ ⵉⵜⵜⵡⴰⵙⵙⴷⴻⵀⵏⴻⵏ ⵏ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⵣⵉ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵏ ⵜⵎⴻⵙⵙⵉ ⵏ ⵙⵉⴷⵉ ⴷⴻⴳ ⵡⴰⵙⵙ ⵉ ⵜⴻⵏ ⴷⴷ-ⵉⵙⵙⵇⴰⵔⵔⴻⴱ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⵍⵉⵏ ⴷ ⵉⴽⴻⵀⵀⴰⵏⴻⵏ ⵉ ⵙⵉⴷⵉ, ");
INSERT INTO rift_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","ⵜⴰⵙⵖⴰⵔⵜ ⵏⵏⵉ ⵉⵡⵛⴰ ⵙⵉⴷⵉ ⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴷⴻⴳ ⵡⴰⵙⵙ ⵉ ⵜⴻⵏ ⵉⴷⵀⴻⵏ. ⴰⵇⴰ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵚⴻⵢⵢⴻⵜ ⵉ ⵍⴻⴱⴷⴰ ⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵏⵙⴻⵏ.’” ");
INSERT INTO rift_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","ⵡⴰ ⴷ ⴰⵣⴻⵔⴼ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⴷ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⴷ ⵜⵖⴰⵔⵚⵜ ⵏ ⵓⵎⴰⵔⵡⴰⵙ ⴷ ⵜⵖⴰⵔⵚⴰ ⵉ ⵓⴷⴻⵛⵛⴻⵏ ⴷ ⵜⵖⴰⵔⵚⴰ ⵏ ⵍⴻⵀⵏⴰ, ");
INSERT INTO rift_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","ⴰⵣⴻⵔⴼ ⵉ ⵉⵡⴻⵚⵚⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ ⴷⴻⴳ ⵡⴻⴷⵔⴰⵔ ⵏ ⵙⵉⵏⴰ, ⴰⵙⵙ ⵎⵉⵏ ⴷⵉ ⵉⵡⴻⵚⵚⴰ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴰⴷ ⵇⴻⴷⴷⵎⴻⵏ ⵜⵉⵡⵀⵉⴱⵉⵏ ⵏⵙⴻⵏ ⵉ ⵙⵉⴷⵉ ⴷⵉ ⵍⴻⵅⵍⴰ ⵏ ⵙⵉⵏⴰ. ");
INSERT INTO rift_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“ⴽⵙⵉ ⵀⴰⵔⵓⵏ ⵊⵎⵉⵄ ⴰⴽ-ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⴷ ⵡⴰⵔⵔⵓⴹ ⴷ ⵣⵣⴻⵛⵜ ⵉ ⵡⴻⴷⵀⴰⵏ ⴷ ⵓⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ ⴷ ⵜⵙⵓⴵⴻⵜ ⵙ ⵡⴻⵖⵔⵓⵎ ⴱⵍⴰ ⴰⵏⵜⵓⵏ, ");
INSERT INTO rift_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","ⵓ ⵍⴰⵖⴰ ⵉ ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ.” ");
INSERT INTO rift_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","ⵉⴳⴳⴰ ⵎⵓⵙⴰ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵙ ⵉⵡⴻⵚⵚⴰ ⵙⵉⴷⵉ ⵓⵛⴰ ⵜⵎⵓⵏ ⵜⵎⴻⵙⵎⵓⵏⵜ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","ⵉⵏⵏⴰ ⵎⵓⵙⴰ ⵉ ⵜⵎⴻⵙⵎⵓⵏⵜ: “ⵡⴰ ⴷ ⵎⵉⵏ ⵉⵡⴻⵚⵚⴰ ⵙⵉⴷⵉ ⴰⴷ ⵉⵜⵜⵡⴰⴳⴳ.” ");
INSERT INTO rift_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","ⵎⵓⵙⴰ ⵉⵙⵙⵇⴰⵔⵔⴻⴱ-ⴷⴷ ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⵙⵙⵉⵔⴷ ⵉ-ⵜⴻⵏ ⵙ ⵡⴰⵎⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","ⵉⵙⵙⴰⵔⵙ ⵅⴰⵙ ⵜⵛⴰⵎⵉⵔ, ⵉⴱⵢⴻⵙ ⴰⵙ ⵙ ⵜⵃⴻⵣⵣⴰⵎⵜ, ⵉⵙⵙⵢⴰⵔⴹ ⴰⵙ ⴰⵙⴻⵍⵀⴰⵎ. ⵉⴳⴳⴰ ⵅⴰⵙ ⴰⴱⴰⵍⵟⵓ ⵓⵛⴰ ⵉⴱⵢⴻⵙ ⴰⵙ ⵙ ⵜⵃⴻⵣⵣⴰⵎⵜ ⵉⵣⴻⵡⵡⵇⴻⵏ ⵏ ⵓⴱⴰⵍⵟⵓ ⵓⵛⴰ ⵉⵇⵇⴻⵏ ⴰⵙ ⵣⵣⴰⵢⴻⵙ ⴰⴱⴰⵍⵜⵓ. ");
INSERT INTO rift_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","ⵉⵙⵙⴻⵎⵜⴻⵏ ⵅⴰⵙ ⵜⴰⵊⵎⴻⵛⵜ ⵓⵛⴰ ⵉⴳⴳⴰ ⵉⵥⵔⴰ ⵏ ‘ⵓⵔⵉⵎ’ ⴷ ‘ⵜⵓⵎⵉⵎ’ ⴷⵉ ⵜⴰⵊⵎⴻⵛⵜ. ");
INSERT INTO rift_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","ⵉⴳⴳⴰ ⴰⵔⴻⵥⵥⴻⵜ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏⵏⴻⵙ ⵓⵛⴰ ⵖⴰⵔ ⵣⵣⴰⵜ ⵅ ⴰⵔⴻⵥⵥⴻⵜ ⵉⴳⴳⴰ ⵜⴰⵍⵡⵉⵃⵜ ⵙ ⵏⵏⵓⵡⵡⴰⵔ ⵏ ⵡⵓⵔⴻⵖ ⵏ ⵜⵜⴰⵊ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵏ ⵡⴻⵄⵣⴰⵍ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","ⵅⴻⵏⵏⵉ ⵉⴽⵙⵉ ⵎⵓⵙⴰ ⵣⵣⴻⵛⵜ ⵉ ⵡⴻⴷⵀⴰⵏ ⵓⵛⴰ ⵉⴷⵀⴻⵏ ⵜⴰⵣⴻⴷⴷⵉⵖⵜ ⴷ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴷⴰⵢⴻⵙ ⵉⴵⴰⵏ ⵓⵛⴰ ⵉⵙⵙⵇⴻⴷⴷⴻⵙ ⵎⴰⵔⵔⴰ ⴰⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","ⵉⵔⵓⵛⵛ ⵣⵣⴰⵢⴻⵙ ⵅ ⵓⵄⴰⵍⵟⴰⵔ ⵙⴻⴱⵄⴰ ⵏ ⵜⵡⴰⵍⴰⵡⵉⵏ ⵓⵛⴰ ⵉⴷⵀⴻⵏ ⵄⴰⵡⴻⴷ ⴰⵄⴰⵍⵟⴰⵔ ⴷ ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ ⵏⵏⴻⵙ ⵓⵍⴰ ⴷ ⵜⴰⴱⴰⵏⵢⵓⵜ ⴰⴽ-ⴷ ⵓⴹⴰⵔ ⵏⵏⴻⵙ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⴻⵏ ⵉⵙⵙⵇⴻⴷⴷⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","ⵉⵙⴻⵢⵢⴻⴱ ⵣⵣⴻⵛⵜ ⵉ ⵡⴻⴷⵀⴰⵏ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏ ⵀⴰⵔⵓⵏ ⵓⵛⴰ ⵉⴷⵀⴻⵏ ⵉ-ⵜ, ⵃⵉⵎⴰ ⴰⴷ ⵜ ⵉⵙⵙⵇⴻⴷⴷⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","ⵉⵙⵙⵇⴰⵔⵔⴻⴱ-ⴷⴷ ⵎⵓⵙⴰ ⴰⵔⵔⴰⵡ ⵏ ⵀⴰⵔⵓⵏ ⵓⵛⴰ ⵢⴰⵔⴹ ⴰⵙⴻⵏ ⵜⵛⴰⵎⵉⵔⴰⵜ ⵓⵛⴰ ⵉⴱⵢⴻⵙ ⴰⵙⴻⵏ ⵙ ⵜⵃⴻⵣⵣⴰⵎⵉⵏ ⵓⵛⴰ ⵉⵏⵏⴻⴹ ⴰⵙⴻⵏ ⵜⵉⵛⵓⵛⵛⴰⵢ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","ⵉⵙⵙⵇⴰⵔⵔⴻⴱ-ⴷⴷ ⴰⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⵓⵛⴰ ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⵙⵙⴰⵔⵙⴻⵏ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵙⴻⵏ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏ ⵓⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ. ");
INSERT INTO rift_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","ⵉⵖⴰⵔⵚ ⴰⵙ ⵓⵛⴰ ⵉⴽⵙⵉ ⵎⵓⵙⴰ ⵉⴷⴰⵎⵎⴻⵏ ⵓⵛⴰ ⵉⴳⴳⴰ ⵛⵡⴰⵢⵜ ⵣⵣⴰⵢⵙⴻⵏ ⵙ ⵓⴹⴰⴹ ⵏⵏⴻⵙ ⵅ ⵡⴰⵛⵛⴰⵡⴻⵏ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ⵉ ⵉⴵⴰⵏ ⵖⴰⵔ ⵎⴰⵔⵔⴰ ⵉⵖⴻⵣⴷⵉⵙⴻⵏ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⵉⵙⵙⵉⵣⴷⴻⴳ ⴰⵄⴰⵍⵟⴰⵔ. ⵅⴻⵏⵏⵉ ⵉⵙⴻⵢⵢⴻⴱ ⵉⴷⴰⵎⵎⴻⵏ ⵖⴰⵔ ⵓⴹⴰⵔ ⵏ ⵓⵄⴰⵍⵟⴰⵔ. ⴰⵎⵎⵓ ⵉ ⵉⵙⵙⵇⴻⴷⴷⴻⵙ ⵉ-ⵜ ⵉ ⵡⴻⵚⵍⴰⵃ ⵅⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","ⵉⴽⵙⵉ ⵎⴰⵔⵔⴰ ⵜⴰⴷⵓⵏⵜ ⵏⵏⵉ ⵉⴵⴰⵏ ⵅ ⵡⴰⴷⴰⵏ ⴷ ⵎⵉⵏ ⵢⵓⵢⵍⴻⵏ ⵖⴰⵔ ⵜⵙⴰ ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵉⵥⵥⴰⵍ ⴷ ⵜⴰⴷⵓⵏⵜ ⵏⵙⴻⵏⵜ ⵓⵛⴰ ⵎⵓⵙⴰ ⵉⵙⵙⴱⴻⵅⵅⴰⵔ ⴰⵢⴰ ⵅ ⵓⵄⴰⵍⵟⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","ⵎⴰⵛⴰ ⴰⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ ⴷ ⵢⵉⵍⴻⵎ ⵏⵏⴻⵙ ⴷ ⵡⴻⵢⵙⵓⵎ ⵏⵏⴻⵙ ⴷ ⴰⵎⴻⵙⵙⴰⵍ ⵏⵏⴻⵙ, ⵉⵙⵙⴰⵔⵖ ⵉ-ⵜⴻⵏ ⴱⴰⵔⵔⴰ ⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","ⵉⵙⵙⵇⴰⵔⵔⴻⴱ-ⴷⴷ ⵎⵓⵙⴰ ⵉⵛⴰⵔⵔⵉ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵓⵛⴰ ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⵙⵙⴰⵔⵙⴻⵏ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵙⴻⵏ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏ ⵉⵛⴰⵔⵔⵉ. ");
INSERT INTO rift_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","ⵉⵖⴰⵔⵚ ⵉ ⵉⵛⴰⵔⵔⵉ ⵓⵛⴰ ⵉⵣⴻⴵⴻⵄ ⵎⵓⵙⴰ ⵉⴷⴰⵎⵎⴻⵏ ⵅ ⵓⵄⴰⵍⵟⴰⵔ ⵖⴰⵔ ⵎⴰⵔⵔⴰ ⵉⵖⴻⵣⴷⵉⵙⴻⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","ⵉⴱⴹⴰ ⵉⵛⴰⵔⵔⵉ ⴷ ⵉⵛⴻⴵⵉⵇⴻⵏ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⵙⵙⴱⴻⵅⵅⴰⵔ ⵎⵓⵙⴰ ⴰⵣⴻⴵⵉⴼ ⴷ ⵉⵛⴻⴵⵉⵇⴻⵏ ⴷ ⵜⴰⴷⵓⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","ⵉⵙⵙⵉⵔⴷ ⴰⴷⴰⵏ ⴷ ⵉⴹⴰⵔⴻⵏ ⵙ ⵡⴰⵎⴰⵏ ⵓⵛⴰ ⵉⵙⵙⴱⴻⵅⵅⴰⵔ ⵎⵓⵙⴰ ⵎⴰⵔⵔⴰ ⵉⵛⴰⵔⵔⵉ ⵅ ⵓⵄⴰⵍⵟⴰⵔ, ⴰⵇⴰ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵙ ⵢⵉⵛⵜ ⵏ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵉⵜⵜⴼⵓⵃⴻⵏ, ⴰⵇⴰ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ ⵉ ⵙⵉⴷⵉ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","ⵉⵙⵙⵇⴰⵔⵔⴻⴱ-ⴷⴷ ⵅⴻⵏⵏⵉ ⵉⵛⴰⵔⵔⵉ ⵏⵏⴻⵖⵏⵉ, ⵉⵛⴰⵔⵔⵉ ⵉ ⵓⴷⴻⵛⵛⴻⵏ, ⵓⵛⴰ ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⵙⵙⴰⵔⵙⴻⵏ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵙⴻⵏ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏ ⵉⵛⴰⵔⵔⵉ. ");
INSERT INTO rift_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","ⵓⵛⴰ ⵉⵖⴰⵔⵚ ⴰⵙ ⵓⵛⴰ ⵉⴽⵙⵉ ⵎⵓⵙⴰ ⵛⵡⴰⵢⵜ ⵣⴻⴳ ⵉⴷⴰⵎⵎⴻⵏ ⵓⵛⴰ ⵉⴳⴳⴰ ⵉ-ⵜⴻⵏ ⵅ ⵉⵖⴻⵙ ⵏ ⵓⵎⴻⵣⵣⵓⵖ ⴰⴼⵓⵙⵉ ⵏ ⵀⴰⵔⵓⵏ ⵓ ⵅ ⵓⴹⴰⴹ ⵏ ⵢⵉⵎⴻⵣ ⵏ ⵓⴼⵓⵙ ⵏⵏⴻⵙ ⴰⴼⵓⵙⵉ ⵓ ⵅ ⵓⴹⴰⴹ ⵏ ⵢⵉⵎⴻⵣ ⵏ ⵓⴹⴰⵔ ⵏⵏⴻⵙ ⴰⴼⵓⵙⵉ. ");
INSERT INTO rift_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","ⵉⵙⵙⵇⴰⵔⵔⴻⴱ-ⴷⴷ ⵄⴰⵡⴻⴷ ⴰⵔⵔⴰⵡ ⵏ ⵀⴰⵔⵓⵏ ⵓⵛⴰ ⵉⴳⴳⴰ ⵎⵓⵙⴰ ⵛⵡⴰⵢⵜ ⵣⴻⴳ ⵉⴷⴰⵎⵎⴻⵏ ⵅ ⵉⵖⴻⵙ ⵏ ⵓⵎⴻⵣⵣⵓⵖ ⵏⵙⴻⵏ ⴰⴼⵓⵙⵉ ⵓ ⵅ ⵓⴹⴰⴹ ⵏ ⵢⵉⵎⴻⵣ ⵏ ⵓⴼⵓⵙ ⵏⵙⴻⵏ ⴰⴼⵓⵙⵉ ⵓ ⵅ ⵓⴹⴰⴹ ⵏ ⵢⵉⵎⴻⵣ ⵏ ⵓⴹⴰⵔ ⵏⵙⴻⵏ ⴰⴼⵓⵙⵉ ⵓⵛⴰ ⵉⵣⴻⴵⴻⵄ ⵎⵓⵙⴰ ⵉⴷⴰⵎⵎⴻⵏ ⵉⵇⵇⵉⵎⴻⵏ ⵅ ⵓⵄⴰⵍⵟⴰⵔ ⵖⴰⵔ ⵎⴰⵔⵔⴰ ⵉⵖⴻⵣⴷⵉⵙⴻⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","ⵉⴽⵙⵉ ⵜⴰⴷⵓⵏⵜ ⴷ ⵓⵏⴻⵡⵡⴰⵔ ⵙ ⵜⴰⴷⵓⵏⵜ ⴷ ⵎⴰⵔⵔⴰ ⵜⴰⴷⵓⵏⵜ ⵜⴻⵏⵏⵉ ⵉⴵⴰⵏ ⵅ ⵡⴰⴷⴰⵏ ⴷ ⵎⵉⵏ ⵢⵓⵢⵍⴻⵏ ⵖⴰⵔ ⵜⵙⴰ ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵉⵥⵥⴰⵍ ⴰⴽ-ⴷ ⵜⴰⴷⵓⵏⵜ ⵏⵙⴻⵏⵜ ⵓⵍⴰ ⴷ ⴰⵛⴻⴽⵔⵓⴷ ⴰⴼⵓⵙⵉ. ");
INSERT INTO rift_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","ⵣⵉ ⵜⵙⵓⴵⴻⵜ ⵙ ⵡⴻⵖⵔⵓⵎ ⴱⵍⴰ ⴰⵏⵜⵓⵏ, ⵜⴻⵏⵏⵉ ⵜⵓⵖⴰ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ, ⵉⴽⵙⵉ ⵉⵊⵊ ⵏ ⵍⴻⵎⵙⴻⵎⵎⴻⵎ ⴱⵍⴰ ⴰⵏⵜⵓⵏ ⴷ ⵢⵉⵛⵜ ⵏ ⵜⴻⵎⵙⴻⵎⵎⴻⵎⵜ ⵉⵙⵙⵡⴻⵊⴷⴻⵏ ⵙ ⵣⵣⴻⵛⵜ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵍⴼⴻⴼⵜ ⵓⵛⴰ ⵉⵙⵙⴰⵔⵙ ⵉ-ⵜⴻⵏ ⵅ ⵜⴰⴷⵓⵏⵜ ⵓ ⵅ ⵓⵛⴻⴽⵔⵓⴷ ⴰⴼⵓⵙⵉ. ");
INSERT INTO rift_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","ⵉⴳⴳⴰ ⵎⴰⵔⵔⴰ ⵎⴰⵏ ⴰⵢⴰ ⴷⴻⴳ ⵉⴼⴰⵙⵙⴻⵏ ⵏ ⵀⴰⵔⵓⵏ ⵓ ⴷⴻⴳ ⵉⴼⴰⵙⵙⴻⵏ ⵏ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⵙⵙⴻⵏⵀⴻⵣⵣ ⴰⵢⴰ ⴰⵎ ⵢⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵡⴻⵏⵀⴻⵣⵣⵉ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","ⴰⵡⴰⵔⵏⵉ ⴰⵙ ⵉⴽⵙⵉ ⵜⴻⵏ ⵎⵓⵙⴰ ⵄⴰⵡⴻⴷ ⵣⴻⴳ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵙⴻⵏ ⵓⵛⴰ ⵉⵙⵙⴱⴻⵅⵅⴰⵔ ⵉ-ⵜⴻⵏ ⵅ ⵓⵄⴰⵍⵟⴰⵔ, ⵅ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ. ⴰⵇⴰ ⴷ ⵜⵉⵖⴰⵔⵚⴰ ⵉ ⵓⴷⴻⵛⵛⴻⵏ ⵙ ⵢⵉⵛⵜ ⵏ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵉⵜⵜⴼⵓⵃⴻⵏ, ⴰⵇⴰ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","ⵉⴽⵙⵉ ⵎⵓⵙⴰ ⵉⴷⵎⴰⵔⴻⵏ ⵓⵛⴰ ⵉⵙⵙⴻⵏⵀⴻⵣⵣ ⵉ-ⵜⴻⵏ ⴰⵎ ⵢⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵡⴻⵏⵀⴻⵣⵣⵉ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ⵎⴰⵏ ⴰⵢⴰ ⴷ ⵜⴰⵙⵖⴰⵔⵜ ⵏ ⵓⵛⴰⵔⵔⵉ ⵉ ⵓⴷⴻⵛⵛⴻⵏ, ⵜⴻⵏⵏⵉ ⵉⴵⴰⵏ ⵉ ⵎⵓⵙⴰ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","ⵉⴽⵙⵉ ⵎⵓⵙⴰ ⵛⵡⴰⵢⵜ ⵏ ⵣⵣⴻⵛⵜ ⵉ ⵡⴻⴷⵀⴰⵏ ⵓ ⵏ ⵉⴷⴰⵎⵎⴻⵏ ⵉ ⵉⴵⴰⵏ ⵅ ⵓⵄⴰⵍⵟⴰⵔ ⵓⵛⴰ ⵉⵔⵓⵛⵛ ⵎⴰⵏ ⴰⵢⴰ ⵅ ⵀⴰⵔⵓⵏ ⵓ ⵅ ⵡⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ, ⵅ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⵓ ⵅ ⵡⴰⵔⵔⵓⴹ ⵏ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ, ⵉⵏⵏⵉ ⴰⴽⵉⴷⴻⵙ ⵉⴵⴰⵏ. ⴰⵎⵎⵓ ⵉ ⵉⵙⵙⵇⴻⴷⴷⴻⵙ ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⴷ ⵡⴰⵔⵔⵓⴹ ⵏ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⴰⴽⵉⴷⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","ⵉⵏⵏⴰ ⵎⵓⵙⴰ ⵉ ⵀⴰⵔⵓⵏ ⵓ ⵉ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ: “ⵙⴻⵏⵡⴻⵎ ⴰⵢⵙⵓⵎ ⵏⵏⵉ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⵓⵛⴰ ⵜⴻⵛⵛⴻⵎ ⵜ ⴷⵉⵏⵏⵉ ⵙ ⵡⴻⵖⵔⵓⵎ ⵏⵏⵉ ⵉⴵⴰⵏ ⴷⵉ ⵜⵙⵓⴵⴻⵜ ⵏ ⵜⵖⴰⵔⵚⴰ ⵉ ⵓⴷⴻⵛⵛⴻⵏ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵡⴻⵚⵚⵉⵖ ⵏⴻⵛⵛ, ⵏⵏⵉⵖ: ‘ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⴰⴷ ⵜ ⵛⵛⴻⵏ.’ ");
INSERT INTO rift_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","ⵎⵉⵏ ⵉⵛⴻⵟⵟⴻⵏ ⵏ ⵡⴻⵢⵙⵓⵎ ⴷ ⵡⴻⵖⵔⵓⵎ, ⴰⴷ ⵜ ⵜⴻⵙⵙⵛⴻⵎⴹⴻⵏ ⵙ ⵜⵎⴻⵙⵙⵉ. ");
INSERT INTO rift_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","ⵣⴻⴳ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⵡⴰⵔ ⵣⵣⴰⵢⴻⵙ ⴷⴷ-ⵜᵉⵜⵜⴻⴼⴼⵖⴻⵎ ⵛⴰ ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ, ⴰⵍ ⴰⵙⵙ ⵎⵉⵏ ⴷⵉ ⵉ ⵖⴰ ⴽⴻⵎⵎⵍⴻⵏ ⵡⵓⵙⵙⴰⵏ ⵏ ⵓⵍⴻⵇⵇⴻⵎ ⵏⵡⴻⵎ, ⵎⵉⵏⵣⵉ ⵏⴻⵜⵜⴰ ⴰⴷ ⴽⴻⵏⵏⵉⵡ ⵢⴰⵍⴻⵇⵇⴻⵎ ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵉⴳⴳⴰ ⵎⴰⵔⵔⴰ ⴷⴻⴳ ⵡⴰⵙⵙ-ⴰ, ⴰⵎⵎⵓ ⵉ ⵉⵡⴻⵚⵚⴰ ⵙⵉⴷⵉ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵅⴰⵡⴻⵎ ⵉⴳⴳ ⴰⵚⵍⴰⵃ. ");
INSERT INTO rift_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","ⴰⴷ ⵜⴻⵇⵇⵉⵎⴻⵎ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ⴰⵙⵙ ⴷ ⴵⵉⵍⴻⵜ, ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⵓⵛⴰ ⴰⴷ ⵜᵉⵟⵟⴼⴻⵎ ⴰⵃⴻⵟⵟⵓ ⵉ ⵙⵉⴷⵉ, ⵃⵉⵎⴰ ⵡⴰⵔ ⵜᵉⵜⵜⵎⴻⵜⵜⵉⵎ ⵛⴰ, ⵎⵉⵏⵣⵉ ⴰⵎⵎⵓ ⵉ ⵜ ⵜⵜⵡⴻⵚⵚⵉⵖ ⵏⴻⵛⵛ.” ");
INSERT INTO rift_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⴳⴳⵉⵏ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴷ ⴰⵙⴻⵏ ⵉⵡⴻⵚⵚⴰ ⵙⵉⴷⵉ ⵙ ⵜⵙⴻⵅⵅⴰⵔⵜ ⵏ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵜⵎⴻⵏⵢⴰ ⵉⵎⵙⴰⵔ, ⴰⵇⴰ ⵎⵓⵙⴰ ⵉⵍⴰⵖⴰ ⵉ ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⴷ ⵉⵎⵖⴰⵔⴻⵏ ⵏ ⵉⵙⵔⴰⵉⵍ ");
INSERT INTO rift_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","ⵓⵛⴰ ⵉⵏⵏⴰ ⵉ ⵀⴰⵔⵓⵏ: “ⴽⵙⵉ ⵖⴰⵔⴻⴽ ⵉⵊⵊ ⵏ ⵓⵄⴻⵊⵎⵉ, ⴰⵎⴻⵥⵢⴰⵏ ⵏ ⵓⴼⵓⵏⴰⵙ, ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ, ⵓⵍⴰ ⴷ ⵉⵊⵊ ⵏ ⵉⵛⴰⵔⵔⵉ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ, ⴰⵇⴰ ⴰⴷ ⵉⵍⵉⵏ ⵛⵏⴰⵏ ⵇⴰⵄ, ⵓⵛⴰ ⴻⵊⵊ ⵉ-ⵜⴻⵏ ⴰⴷ ⴷⴷ-ⵇⴰⵔⵔⴱⴻⵏ ⵖⴰⵔ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ.    ");
INSERT INTO rift_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","ⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵛⴰ ⵉⵏⵉ: “ⴽⵙⵉⵎ ⵉⵊⵊ ⵏ ⵓⵎⵢⴰⵏ ⵣⴻⴳ ⵉⵖⴰⵢⴹⴻⵏ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⵓ ⴽⵙⵉ ⵉⵊⵊ ⵏ ⵓⵄⴻⵊⵎⵉ ⴷ ⵉⵊⵊ ⵏ ⵢⴻⵣⵎⴰⵔ, ⴰⵇⴰ ⴰⴷ ⵉⵍⵉⵏ ⵉⵎⵓⴷⴷⴰⵔⴻⵏ ⵛⵏⴰⵏ ⵇⴰⵄ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ, ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ, ");
INSERT INTO rift_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","ⵓⵛⴰ ⴽⵙⵉ ⵄⴰⵡⴻⴷ ⵉⵊⵊ ⵏ ⵓⴼⵓⵏⴰⵙ ⴷ ⵉⵊⵊ ⵏ ⵓⵛⴰⵔⵔⵉ ⴰⵎ ⵜⵖⴰⵔⵚⴰ ⵏ ⵍⴻⵀⵏⴰ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⴻⵏ ⵇⴻⴷⴷⵎⴻⵏ ⴷ ⴷⴷⴱⵉⵃⴻⵜ ⵉ ⵙⵉⴷⵉ, ⵓⵍⴰ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵉⵅⴻⴵⴹⴻⵏ ⵙ ⵣⵣⴻⵛⵜ, ⵎⵉⵏⵣⵉ ⴰⵙⵙ-ⴰ ⴰⴷ ⴰⵡⴻⵎ ⴷⴷ-ⵉⴱⴰⵏ ⵙⵉⴷⵉ.” ");
INSERT INTO rift_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","ⵅⴻⵏⵏⵉ ⴰⵡⵢⴻⵏ ⵎⵉⵏ ⵅⴻⴼ ⵉⵡⴻⵚⵚⴰ ⵎⵓⵙⴰ ⵖⴰⵔ ⵣⵣⴰⵜ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⵓⵛⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⵜⵇⴰⵔⵔⴻⴱ-ⴷⴷ ⵓⵛⴰ ⴱⴻⴷⴷⴻⵏ ⵏⵉⵜⵏⵉ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","ⵓⵛⴰ ⵎⵓⵙⴰ ⵉⵏⵏⴰ: “ⴷ ⵎⴰⵏ ⴰⵢⴰ ⵎⵉⵏ ⵅⴻⴼ ⵉⵡⴻⵚⵚⴰ ⵙⵉⴷⵉ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜ ⵜⴻⴳⴳⴻⵎ. ⵓⵛⴰ ⵅⴻⵏⵏⵉ ⴰⴷ ⴰⵡⴻⵎ ⴷⴷ-ⵉⴱⴰⵏ ⵓⵄⵓⴵⵉ ⵏ ⵙⵉⴷⵉ.” ");
INSERT INTO rift_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","ⵉⵏⵏⴰ ⵎⵓⵙⴰ ⵉ ⵀⴰⵔⵓⵏ: “ⵇⴰⵔⵔⴻⴱ-ⴷⴷ ⵖⴰⵔ ⵓⵄⴰⵍⵟⴰⵔ ⵓⵛⴰ ⵙⴻⵡⵊⴻⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏⵏⴻⵛ ⵏ ⴷⴷⴻⵏⴱ ⴷ ⵜⵖⴰⵔⵚⵜ ⵏⵏⴻⵛ ⵏ ⵡⴻⵛⵎⴰⴹ ⵓⵛⴰ ⴻⴳⴳ ⴰⵚⵍⴰⵃ ⵅ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵛ ⵓ ⵅ ⵍⴳⴻⵏⵙ. ⵙⴻⵡⵊⴻⴷ ⵄⴰⵡⴻⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵍⴳⴻⵏⵙ ⵓⵛⴰ ⴻⴳⴳ ⵅⴰⵙⴻⵏ ⴰⵚⵍⴰⵃ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜ ⵉⵡⴻⵚⵚⴰ ⵙⵉⴷⵉ.” ");
INSERT INTO rift_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","ⵅⴻⵏⵏⵉ ⵉⵇⴰⵔⵔⴻⴱ-ⴷⴷ ⵀⴰⵔⵓⵏ ⵖⴰⵔ ⵓⵄⴰⵍⵟⴰⵔ ⵓⵛⴰ ⵉⵖⴰⵔⵚ ⵉ ⵓⵄⴻⵊⵎⵉ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⵉ ⵉⴵⴰⵏ ⵉ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","ⴰⵔⵔⴰⵡ ⵏ ⵀⴰⵔⵓⵏ ⵉⵡⵢⴻⵏ ⴰⵙ-ⴷⴷ ⵉⴷⴰⵎⵎⴻⵏ ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵉⵙⵙⵓⴼ ⴰⴹⴰⴹ ⵏⵏⴻⵙ ⴷⴻⴳ ⵉⴷⴰⵎⵎⴻⵏ ⵓⵛⴰ ⵉⴳⴳⴰ ⵉ-ⵜⴻⵏ ⵅ ⵡⴰⵛⵛⴰⵡⴻⵏ ⵏ ⵓⵄⴰⵍⵟⴰⵔ. ⵎⵉⵏ ⵉⵛⴻⵟⵟⴻⵏ ⵏ ⵉⴷⴰⵎⵎⴻⵏ ⵉⵙⴻⵢⵢⴻⴱ ⵉ-ⵜⴻⵏ ⵖⴰⵔ ⵓⴹⴰⵔ ⵏ ⵓⵄⴰⵍⵟⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","ⵉⵙⵙⴱⴻⵅⵅⴰⵔ ⵜⴰⴷⵓⵏⵜ ⴷ ⵜⵉⵥⵥⴰⵍ ⴷ ⵎⵉⵏ ⵢⵓⵢⵍⴻⵏ ⵖⴰⵔ ⵜⵙⴰ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⵅ ⵓⵄⴰⵍⵟⴰⵔ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","ⵉⵙⵙⴻⵛⵎⴻⴹ ⴰⵢⵙⵓⵎ ⴷ ⵢⵉⵍⴻⵎ ⵙ ⵜⵎⴻⵙⵙⵉ ⴱⴰⵔⵔⴰ ⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","ⵉⵖⴰⵔⵚ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵓⵛⴰ ⴰⵔⵔⴰⵡ ⵏ ⵀⴰⵔⵓⵏ ⵇⴻⴷⴷⵎⴻⵏ ⴰⵙ ⵉⴷⴰⵎⵎⴻⵏ ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵉⵣⴻⴵⴻⵄ ⵉ-ⵜⴻⵏ ⵅ ⵓⵄⴰⵍⵟⴰⵔ ⵖⴰⵔ ⵎⴰⵔⵔⴰ ⵉⵖⴻⵣⴷⵉⵙⴻⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","ⵅⴻⵏⵏⵉ ⵇⴻⴷⴷⵎⴻⵏ ⴰⵙ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵉ ⵜⵜⵡⴰⴱⴹⴰⵏ ⴷ ⵉⵛⴻⴵⵉⵇⴻⵏ, ⵓⵍⴰ ⴷ ⴰⵣⴻⴵⵉⴼ, ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵉⵙⵙⴱⴻⵅⵅⴰⵔ ⵉ-ⵜⵜ ⵅ ⵓⵄⴰⵍⵟⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","ⵉⵙⵙⵉⵔⴷ ⴰⴷⴰⵏ ⴷ ⵉⴹⴰⵔⴻⵏ ⵓⵛⴰ ⵉⵙⵙⴱⴻⵅⵅⴰⵔ ⵉ-ⵜⴻⵏ ⵅ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵉ ⵉⴵⴰⵏ ⵅ ⵓⵄⴰⵍⵟⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","ⴰⵡⴰⵔⵏⵉ ⴰⵙ ⵉⵙⵙⵇⴰⵔⵔⴻⴱ-ⴷⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵍⴳⴻⵏⵙ. ⵏⴻⵜⵜⴰ ⵉⴽⵙⵉ ⴰⵎⵢⴰⵏ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⵉ ⵍⴳⴻⵏⵙ ⵓⵛⴰ ⵉⵖⴰⵔⵚ ⴰⵙ ⵓⵛⴰ ⵉⵙⵙⴻⵡⵊⴻⴷ ⵉ-ⵜ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵉⵙⵙⴻⵡⵊⴻⴷ ⵉⵛⴰⵔⵔⵉ ⴰⵎⴻⵣⵡⴰⵔⵓ. ");
INSERT INTO rift_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","ⵉⵙⵙⵇⴰⵔⵔⴻⴱ-ⴷⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵓⵛⴰ ⵉⵙⵙⴻⵡⵊⴻⴷ ⵉ-ⵜⵜ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴼⴰⵔⵉⴹⴰ. ");
INSERT INTO rift_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","ⵉⵇⴻⴷⴷⴻⵎ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵓⵛⴰ ⵉⴽⵙⵉ ⵣⵣⴰⵢⴻⵙ ⵉⵊⵊ ⵏ ⵡⵓⵔⵓ ⵉⵛⵛⵓⵔ ⵓⵛⴰ ⵉⵙⵙⴱⴻⵅⵅⴰⵔ ⴰⵢⴰ ⵅ ⵓⵄⴰⵍⵟⴰⵔ, ⵣⵣⴰⵜ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵏ ⵚⵚⴱⴻⵃ. ");
INSERT INTO rift_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","ⵉⵖⴰⵔⵚ ⵄⴰⵡⴻⴷ ⵉ ⵓⴼⵓⵏⴰⵙ ⵓ ⵉ ⵢⵉⵛⴰⵔⵔⵉ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵍⴻⵀⵏⴰ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏ ⵍⴳⴻⵏⵙ, ⵓⵛⴰ ⴰⵔⵔⴰⵡ ⵏ ⵀⴰⵔⵓⵏ ⵇⴻⴷⴷⵎⴻⵏ ⴰⵙ ⵉⴷⴰⵎⵎⴻⵏ ⵓⵛⴰ ⵉⵣⴻⴵⴻⵄ ⵉ-ⵜⴻⵏ ⵅ ⵓⵄⴰⵍⵟⴰⵔ ⵖⴰⵔ ⵎⴰⵔⵔⴰ ⵉⵖⴻⵣⴷⵉⵙⴻⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","ⵅ ⵜⴰⴷⵓⵏⵜ ⵏ ⵓⴼⵓⵏⴰⵙ ⵓ ⵏ ⵉⵛⴰⵔⵔⵉ: ⴰⵏⴻⵡⵡⴰⵔ ⵙ ⵜⴰⴷⵓⵏⵜ ⵏⵏⴻⵙ ⴷ ⵎⵉⵏ ⵉⴷⵍⵉⵏ ⴰⴹⴰⵏ ⴷ ⵜⵉⵥⵥⴰⵍ ⴷ ⵎⵉⵏ ⵢⵓⵢⵍⴻⵏ ⵖⴰⵔ ⵜⵙⴰ, ");
INSERT INTO rift_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","ⴰⵇⴰ ⵙⵙⴰⵔⵙⴻⵏ ⵜⴰⴷⵓⵏⵜ ⵏⵏⵉ ⵅ ⵉⴷⵎⴰⵔⴻⵏ ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵉⵙⵙⴱⴻⵅⵅⴰⵔ ⵜⴰⴷⵓⵏⵜ ⵅ ⵓⵄⴰⵍⵟⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","ⵎⴰⵛⴰ ⵉⴷⵎⴰⵔⴻⵏ ⴷ ⵓⵛⴻⴽⵔⵓⴷ ⴰⴼⵓⵙⵉ ⵉⵙⵙⴻⵏⵀⴻⵣⵣ ⵉ-ⵜⴻⵏ ⵀⴰⵔⵓⵏ ⴰⵎⴻⵛⵏⴰⵡ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵡⴻⵏⵀⴻⵣⵣⵉ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜ ⵉⵡⴻⵚⵚⴰ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","ⵅⴻⵏⵏⵉ ⵉⵙⵙⴳⴻⵄⵄⴻⴷ ⵀⴰⵔⵓⵏ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵏⴻⵙ ⵖⴰⵔ ⵍⴳⴻⵏⵙ ⵓⵛⴰ ⵉⴱⴰⵔⴻⴽ ⵉ-ⵜⴻⵏ ⵓⵛⴰ ⵉⵀⵡⴰ ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⵉⵇⴻⴷⴷⴻⵎ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⴷ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⴷ ⵜⵖⴰⵔⵚⵜ ⵏ ⵍⴻⵀⵏⴰ. ");
INSERT INTO rift_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","ⵓⵛⴰ ⵢⵓⴷⴻⴼ ⵎⵓⵙⴰ ⴰⴽ-ⴷ ⵀⴰⵔⵓⵏ ⵖⴰⵔ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⵓⵛⴰ ⵏⵉⵜⵏⵉ ⴼⴼⵖⴻⵏ ⵣⵣⴰⵢⴻⵙ ⵄⴰⵡⴻⴷ ⵓⵛⴰ ⴱⴰⵔⴽⴻⵏ ⵍⴳⴻⵏⵙ ⵓⵛⴰ ⵉⴱⴰⵏ ⵓⵄⵓⴵⵉ ⵏ ⵙⵉⴷⵉ ⵉ ⵎⴰⵔⵔⴰ ⵍⴳⴻⵏⵙ ");
INSERT INTO rift_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","ⵓⵛⴰ ⵜⴻⴼⴼⴻⵖ-ⴷⴷ ⵜⵎⴻⵙⵙⵉ ⵣⵉ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ, ⵜⴻⵛⵛⴰ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵅ ⵓⵄⴰⵍⵟⴰⵔ ⵓⵍⴰ ⴷ ⵜⴰⴷⵓⵏⵜ. ⵓⵎⵉ ⵉⵥⵔⴰ ⵍⴳⴻⵏⵙ ⵎⴰⵏ ⴰⵢⴰ, ⵙⵍⵉⵡⴻⵍⵡⴻⵏ ⵓⵛⴰ ⵡⴹⴰⵏ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵅ ⵓⵖⴻⵎⴱⵓⴱ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","ⵏⴰⴷⴰⴱ ⴷ ⴰⴱⵉⵀⵓ, ⴰⵔⵔⴰⵡ ⵏ ⵀⴰⵔⵓⵏ, ⴽⵙⵉⵏ ⴽⵓⵍ ⵉⵊⵊ ⵍⵎⴻⵊⵎⴰⵔ ⵏⵏⴻⵙ ⵓⵛⴰ ⴳⴳⵉⵏ ⴷⴰⵢⴻⵙ ⵍⴻⴱⵅⵓⵔ ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⵢⵉⵡⵢⴻⵏ ⵏⵉⵜⵏⵉ ⵜⵉⵎⴻⵙⵙⵉ ⵜⴻⵖⵔⵉⴱ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ, ⵎⵉⵏ ⵡⴰⵔ ⴷ ⴰⵙⴻⵏ ⵉⵡⴻⵚⵚⴰ ⵏⴻⵜⵜⴰ. ");
INSERT INTO rift_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","ⵜⴻⴼⴼⴻⵖ-ⴷⴷ ⵜⵎⴻⵙⵙⵉ ⵣⵉ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ, ⵜⴻⵛⵛ ⵉ-ⵜⴻⵏ ⵓⵛⴰ ⵎⵎⵓⵜⴻⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","ⵉⵏⵏⴰ ⵎⵓⵙⴰ ⵉ ⵀⴰⵔⵓⵏ: “ⴷ ⵎⴰⵏ ⴰⵢⴰ ⵅ ⵎⵉⵏ ⵅⴻⴼ ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⵓⵎⵉ ⵉⵏⵏⴰ: ‘ⵙ ⵢⵉⵏⵏⵉ ⵉ ⵖⴰⵔⵉ ⴷⴷ ⵖⴰ ⵉⵇⴰⵔⵔⴱⴻⵏ ⴰⴷ ⵜⵜⵡⴰⵇⴻⴷⴷⵙⴻⵖ ⵓⵛⴰ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵎⴰⵔⵔⴰ ⵍⴳⴻⵏⵙ ⴰⴷ ⵜⵜⵡⴰⵙⵙⵄⵓⴵⴻⵖ.’” ⵓⵛⴰ ⵉⵙⵇⴰⵔ ⵀⴰⵔⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","ⵉⵍⴰⵖⴰ ⵎⵓⵙⴰ ⵉ ⵎⵉⵛⴰⵢⵉⵍ ⴷ ⵉ ⵉⵍⵚⴰⴼⴰⵏ, ⴰⵔⵔⴰⵡ ⵏ ⵄⵓⵣⵣⵉⵢⵉⵍ, ⵄⴻⵎⵎⵉⵙ ⵏ ⵀⴰⵔⵓⵏ, ⵓⵛⴰ ⵉⵏⵏⴰ ⴰⵙⴻⵏ: “ⵇⴰⵔⵔⴱⴻⵎ-ⴷⴷ, ⵜⴰⵔⴱⵓⵎ ⴰⵢⵜⵎⴰⵜⵡⴻⵎ ⵣⵉ ⵇⵉⴱⴰⵍⵜ ⵏ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ, ⴰⵡⵢⵉ ⵜⴻⵏ ⴱⴰⵔⵔⴰ ⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ.” ");
INSERT INTO rift_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","ⵇⴰⵔⵔⴱⴻⵏ-ⴷⴷ ⵏⵉⵜⵏⵉ ⵓⵛⴰ ⴰⵔⴱⵓⵏ ⵜⴻⵏ ⴷⵉ ⵜⵛⴰⵎⵉⵔⴰⵜ ⵏⵙⴻⵏ ⴱⴰⵔⵔⴰ ⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜ ⵉⵏⵏⴰ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵎⵓⵙⴰ ⵉ ⵀⴰⵔⵓⵏ ⵓ ⵉ ⴰⵍⵉⵄⴰⵣⴰⵔ ⴷ ⵉⵜⴰⵎⴰⵔ, ⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ: “ⵡⴰⵔ ⴹⴻⴵⵇⴻⵎ ⵉ ⵓⵛⵓⵡⵡⴰⴼ ⵅ ⵉⵣⴻⴵⵉⴼⴻⵏ ⵏⵡⴻⵎ ⵏⵉⵖ ⵜⵜⵛⴰⵔⵔⴳⴻⵎ ⴰⵔⵔⵓⴹ ⵏⵡⴻⵎ ⵉ ⵡⴻⵛⴹⴰⵏ, ⵃⵉⵎⴰ ⵡⴰⵔ ⵜᵉⵜⵜⵎⴻⵜⵜⵉⵎ ⵓⵛⴰ ⴰⴷ ⵢⵉⵍⵉ ⵓⴷⵓⵇⵇⴻⵣ ⵏ ⵡⴻⵖⴹⴰⴱ ⵅ ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ. ⵎⴰⵛⴰ ⴰⵢⵜⵎⴰⵜⵡⴻⵎ, ⵎⴰⵔⵔⴰ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⴰⴷ ⵔⵓⵏ ⵅ ⵜⵎⴻⵙⵙⵉ-ⵢⴰ, ⵜⴻⵏⵏⵉ ⵉⵙⵙⴻⵛⵎⴻⴹ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","ⵡⴰⵔ ⴷⴷ-ⵜⵜⴻⴼⴼⵖⴻⵎ ⵛⴰ ⵣⵉ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ⵃⵉⵎⴰ ⵡⴰⵔ ⵜᵉⵜⵜⵎⴻⵜⵜⵉⵎ ⵛⴰ, ⵎⵉⵏⵣⵉ ⵣⵣⴻⵛⵜ ⵏ ⵡⴻⴷⵀⴰⵏ ⵏ ⵙⵉⴷⵉ ⴰⵇⴰ ⵜⵜ ⵅⴰⵡⴻⵎ.” ⵓⵛⴰ ⵏⵉⵜⵏⵉ ⵟⵟⴰⵄⴻⵏ ⵉ ⵡⴰⵡⴰⵍ ⵏ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵀⴰⵔⵓⵏ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“ⵡⴰⵔ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⵜⵙⴻⵙⵙⴻⴷ ⴱⵉⵏⵓ ⵏⵉⵖ ⵛⵛⵔⴰⴱ ⵉⵊⴻⵀⴷⴻⵏ ⵅⵎⵉ ⵖⴰ ⵜⴰⴷⴼⴻⵎ ⵖⴰⵔ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ⵛⴻⴽ ⵍⵍⴰ ⵓⵍⴰ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵛ ⵏⵏⵉ ⴰⴽⵉⴷⴻⴽ ⵍⵍⴰ, ⵃⵉⵎⴰ ⵡⴰⵔ ⵜᵉⵜⵜⵎⴻⵜⵜⵉⵎ ⵛⴰ. ⴰⵇⴰ-ⵜⵜ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵚⴻⵢⵢⴻⵜ ⵉ ⵍⴻⴱⴷⴰ ⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵏⵡⴻⵎ, ");
INSERT INTO rift_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","ⵃⵉⵎⴰ ⴰⴷ ⴰⴼ ⵜⵣⴻⵎⵎⴰⵔⴻⵎ ⴰⴷ ⵜⴼⴰⵔⵣⴻⵎ ⵊⴰⵔ ⵎⵉⵏ ⵉⴵⴰⵏ ⵉⵇⴻⴷⴷⵙⴻⵏ ⴷ ⵎⵉⵏ ⵡⴰⵔ ⵉⴵⵉⵏ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵓ ⵊⴰⵔ ⵎⵉⵏ ⵉⵚⴼⴰⵏ ⴷ ⵎⵉⵏ ⵡⴰⵔ ⵉⵚⴼⵉⵏ, ");
INSERT INTO rift_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","ⵓ ⵃⵉⵎⴰ ⴰⴷ ⵜⴻⵙⵙⵍⴻⵎⴷⴻⵎ ⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵎⴰⵔⵔⴰ ⵜⵉⵡⴻⵚⵚⴰ ⵏⵏⵉ ⵖⴰⵔⵙⴻⵏ ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⵙ ⵜⵙⴻⵅⵅⴰⵔⵜ ⵏ ⵎⵓⵙⴰ.” ");
INSERT INTO rift_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","ⵓⵛⴰ ⵉⵙⵙⵉⵡⴻⵍ ⵎⵓⵙⴰ ⴰⴽ-ⴷ ⵀⴰⵔⵓⵏ ⵓ ⴰⴽ-ⴷ ⴰⵍⵉⵄⴰⵣⴰⵔ ⴷ ⵉⵜⴰⵎⴰⵔ, ⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⵉⵇⵇⵉⵎⴻⵏ: “ⴽⵙⵉⵎ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵏⵏⵉ ⵉⵛⴻⵟⵟⴻⵏ ⵣⵉ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵏ ⵜⵎⴻⵙⵙⵉ ⵉ ⵙⵉⴷⵉ ⵓⵛⴰ ⵛⵛⴻⵎ ⵜⵜ ⴱⵍⴰ ⴰⵏⵜⵓⵏ ⵣⵣⴰⵜ ⵉ ⵓⵄⴰⵍⵟⴰⵔ, ⵎⵉⵏⵣⵉ ⴰⵇⴰ-ⵜⵜ ⴷ ⵜⴰⵎⵇⴻⴷⴷⴰⵙⵜ ⵇⴰⵄ. ");
INSERT INTO rift_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","ⴰⴷ ⵜⵜ ⵜⴻⵛⵛⴻⵎ ⴷⴻⴳ ⵉⵊⵊ ⵏ ⵡⴻⵎⵛⴰⵎ ⵉⵇⴻⴷⴷⵙⴻⵏ, ⵎⵉⵏⵣⵉ ⵜⴰ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵉ ⵛⴻⴽ ⵓ ⵉ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵛ ⵣⵉ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵏ ⵜⵎⴻⵙⵙⵉ ⵏ ⵙⵉⴷⵉ, ⵎⵉⵏⵣⵉ ⴰⵎⵎⵓ ⵉ ⴷ ⴰⵢⵉ ⵉⵜⵜⵡⴰⵡⴻⵚⵚⴰ. ");
INSERT INTO rift_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","ⴷⴻⴳ ⵉⵊⵊ ⵏ ⵡⴻⵎⵛⴰⵏ ⵉⵚⴼⴰ ⴰⴷ ⵜⴻⵛⵛⴻⵎ ⵄⴰⵡⴻⴷ ⵉⴷⵎⴰⵔⴻⵏ ⵏ ⵡⴻⵏⵀⴻⵣⵣⵉ ⴷ ⵓⵛⴻⴽⵔⵓⴷ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵉ ⴷⴷ-ⵉⵜⵜⵡⴰⵙⵙⴳⴻⵄⵄⴷⴻⵏ, ⵛⴻⴽ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵛ ⴷ ⵜⵃⴻⵏⵊⵉⵔⵉⵏ ⵏⵏⴻⵛ ⴰⴽⵉⴷⴻⴽ, ⵎⵉⵏⵣⵉ ⴷ ⵎⴰⵏ ⴰⵢⴰ ⴷ ⵜⴰⵙⵖⴰⵔⵜ ⵏⵏⴻⵛ ⴷ ⵜⴰⵙⵖⴰⵔⵜ ⵏ ⵜⴰⵔⵡⴰ ⵏⵏⴻⵛ ⵣⵉ ⵜⵖⴰⵔⵚⴰ ⵏ ⵍⴻⵀⵏⴰ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","ⴰⴷ ⴰⵡⵢⴻⵏ ⴰⵛⴻⴽⵔⵓⴷ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵉ ⴷⴷ-ⵉⵜⵜⵡⴰⵙⵙⴳⴻⵄⵄⴷⴻⵏ ⵓⵍⴰ ⴷ ⵉⴷⵎⴰⵔⴻⵏ ⵏ ⵡⴻⵏⵀⴻⵣⵣⵉ ⴰⴽ-ⴷ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵏ ⵜⵎⴻⵙⵙⵉ ⵏ ⵜⴰⴷⵓⵏⵜ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⴻⵏ ⵙⵙⴻⵏⵀⴻⵣⵣⴻⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⴰⵎ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵡⴻⵏⵀⴻⵣⵣⵉ. ⴰⵇⴰ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵚⴻⵢⵢⴻⵜ ⵉ ⵍⴻⴱⴷⴰ ⵉ ⵛⴻⴽ ⵓ ⵉ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵛ ⴰⴽⵉⴷⴻⴽ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜ ⵉⵡⴻⵚⵚⴰ ⵙⵉⴷⵉ.” ");
INSERT INTO rift_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","ⵓⵛⴰ ⵎⵓⵙⴰ ⵢⴰⵔⵣⵓ ⵙ ⵛⴹⴰⵔⴻⵜ ⵅ ⵓⵎⵢⴰⵏ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ, ⵎⴰⵛⴰ ⵅⵣⴰⵔ, ⵉⵛⴻⵎⴹ. ⵅⴻⵏⵏⵉ ⵉⴼⴼⵓⴳⴻⵎ ⵅ ⴰⵍⵉⵄⴰⵣⴰⵔ ⴷ ⵉⵜⴰⵎⴰⵔ, ⴰⵔⵔⴰⵡ ⵉⵇⵇⵉⵎⴻⵏ ⵏ ⵀⴰⵔⵓⵏ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“ⵎⴰⵢⴻⵎⵎⵉ ⵡⴰⵔ ⵜⴻⵛⵛⵉⵎ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵉⵇⴻⴷⴷⵙⴻⵏ? ⵎⵉⵏⵣⵉ ⴰⵇⴰ-ⵜⵜ ⴷ ⵜⴰⵎⵇⴻⴷⴷⴰⵙⵜ ⵇⴰⵄ ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵉⵡⵛⴰ ⴰⵡⴻⵎ ⵜⵜ-ⵉ-ⴷⴷ ⵃⵉⵎⴰ ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⵜⴰⵔⴱⵓⵎ ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ ⵏ ⵜⵎⴻⵙⵎⵓⵏⵜ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵅⴰⵙⴻⵏ ⵜⴻⴳⴳⴻⵎ ⴰⵚⵍⴰⵃ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","ⵅⵣⴰⵔⴻⵎ, ⵃⴷⴰⵎ ⵡⴰⵔ ⵙⵙⵉⴷⴼⴻⵏ ⵡⴰⵍⵓ ⵣⴻⴳ ⵉⴷⴰⵎⵎⴻⵏ ⴷⴰⵅⴻⵍ ⵉ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ. ⵜⵓⵖⴰ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⵜⵜ ⵜⴻⵛⵛⴻⵎ ⴷⵉ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵡⴻⵎ ⵡⴻⵚⵚⵉⵖ ⵏⴻⵛⵛ.” ");
INSERT INTO rift_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","ⵅⴻⵏⵏⵉ ⵉⵙⵙⵉⵡⴻⵍ ⵀⴰⵔⵓⵏ ⴰⴽ-ⴷ ⵎⵓⵙⴰ: “ⵅⵣⴰⵔ, ⴰⵙⵙ-ⴰ ⴰⵇⴰ ⵇⴻⴷⴷⵎⴻⵏ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⴷ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ⵎⴰⵍⴰ ⵏⴻⵛⵛ, ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⵅⴰⴼⵉ ⴽⴽⴻⵏⵜ ⵜⵎⴻⵙⵍⴰⵢⵉⵏ-ⴰ, ⴰⵇⴰ ⵛⵛⵉⵖ ⵣⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⴰⵙⵙ-ⴰ, ⵎⴰ ⵅⴻⵏⵏⵉ ⵎⴰⵏ ⴰⵢⴰ ⵉⵛⵏⴰ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵙⵉⴷⵉ?” ");
INSERT INTO rift_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","ⵓⵎⵉ ⵉⵙⵍⴰ ⵎⵓⵙⴰ ⴰⵢⴰ, ⵉⴱⴰⵏ ⴰⵙ-ⴷⴷ ⵎⴰⵏ ⴰⵢⴰ ⴷ ⵍⴻⵎⵍⵉⵃ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ, ⵉⵏⵏⴰ ⴰⵙⴻⵏ: ");
INSERT INTO rift_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“ⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵛⴰ ⵉⵏⵉⵎ: ‘ⵉⵏⴰ ⴰⵇⴰ ⴰⵜⴻⵏ ⴷ ⵍⵎⴰⵍ, ⵉⵏⵏⵉ ⵓⵎⵉ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⵜⴻⵛⵛⴻⵎ ⵣⵉ ⵊⴰⵔ ⵎⴰⵔⵔⴰ ⵍⵎⴰⵍ ⵏⵏⵉ ⴷⵉⵏ ⵅ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⵜⴻⵛⵛⴻⵎ ⵣⵉ ⵎⴰⵔⵔⴰ ⵍⵎⴰⵍ ⵉ ⵖⴰⵔ ⵜⴻⴵⴰ ⵜⴻⵛⴹⴻⵛⵜ ⵉⵎⵎⵙⴻⴱⴹⴰⵏ, ⴰⵇⴰ ⴼⴰⵔⵇⴰ ⵏ ⵜⴻⵛⴹⴻⵛⵜ ⵉⵎⵙⵙⴻⴱⴹⴰⵏ ⵇⴰⵄ, ⵓ ⵙⴻⵏⵏⴻⵊ ⵉ ⵎⴰⵏ ⴰⵢⴰ ⵜⵜⴰⵔⵔⴰⵏ ⵉⴼⴻⵥ. ");
INSERT INTO rift_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","ⵎⴰⵛⴰ ⵣⴻⴳ ⵉⵏⵏⵉ ⵉⵜⵜⴰⵔⵔⴰⵏ ⵉⴼⴻⵥ ⴷ ⵢⵉⵏⵏⵉ ⵖⴰⵔ ⵜⴻⴵⴰ ⵜⴻⵛⴹⴻⵛⵜ ⵉⵎⵎⵙⴻⴱⴹⴰⵏ, ⵡⴰⵔ ⵜⵜᵉⵜⵜⴻⵎ ⵉⵏⴰ: ⴰⵍⵖⴻⵎ, ⵎⵉⵏⵣⵉ ⵉⵜⵜⴻⴼⴼⴻⵥ, ⵎⴰⵛⴰ ⵡⴰⵔ ⵖⴰⵔⴻⵙ ⴱⵓ ⵜⴻⵛⴹⴻⵛⵜ ⵉⵎⵎⵙⴻⴱⴹⴰⵏ, ⵙ ⵓⵢⴻⵏⵏⵉ ⴰⵇⴰ ⵉⵅⵎⴻⵊ ⵉ ⴽⴻⵏⵏⵉⵡ, ");
INSERT INTO rift_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","ⴰⴽⴰⵡⴽⴰ ⵏ ⵜⴻⵚⴹⴰⵔⵜ, ⵎⵉⵏⵣⵉ ⵉⵜⵜⴰⵔⵔⴰ ⵉⴼⴻⵥ, ⵎⴰⵛⴰ ⵜⴰⵛⴹⴻⵛⵜ ⵡⴰⵔ ⵜⴻⵎⵎⵙⴻⴱⴹⵉ, ⵓ ⵙ ⵓⵢⴻⵏⵏⵉ ⴰⵇⴰ ⵉⵅⵎⴻⵊ ⵉ ⴽⴻⵏⵏⵉⵡ, ");
INSERT INTO rift_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","ⴰⵎⴻⵏⵏⵉ ⴰⵢⴰⵔⵣⵉⵣ, ⵎⵉⵏⵣⵉ ⵉⵜⵜⴰⵔⵔⴰ ⵉⴼⴻⵥ, ⵎⴰⵛⴰ ⵡⴰⵔ ⵖⴰⵔⴻⵙ ⵜⴰⵛⴹⴻⵛⵜ ⵉⵎⵎⵙⴻⴱⴹⴰⵏ, ⵙ ⵓⵢⴻⵏⵏⵉ ⴰⵇⴰ ⵉⵅⵎⴻⵊ ⵉ ⴽⴻⵏⵏⵉⵡ, ");
INSERT INTO rift_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","ⵄⴰⵡⴻⴹ ⵉⵍⴻⴼ, ⵎⵉⵏⵣⵉ ⵖⴰⵔⴻⵙ ⵜⴰⵛⴹⴻⵛⵜ ⵉⵎⵎⵙⴻⴱⴹⴰⵏ ⵓⵛⴰ ⴰⵇⴰ ⴼⴰⵔⵇⴰ ⵏ ⵜⴻⵛⴹⴻⵛⵜ ⵉⵎⵎⵙⴻⴱⴹⴰⵏ ⵇⴰⵄ, ⵎⴰⵛⴰ ⵡⴰⵔ ⵉⵜⵜⴰⵔⵔⵉ ⵉⴼⴻⵥ, ⵙ ⵓⵢⴻⵏⵏⵉ ⴰⵇⴰ ⵉⵅⵎⴻⵊ ⵉ ⴽⴻⵏⵏⵉⵡ. ");
INSERT INTO rift_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","ⵣⴻⴳ ⵡⴻⵢⵙⵓⵎ ⵏⵙⴻⵏ ⵡⴰⵔ ⵣⵣⴰⵢⴻⵙ ⵜⵜᵉⵜⵜⴻⵎ ⵏⵉⵖ ⴰⴷ ⵜⵃⴰⴷⴰⵎ ⵍⵅⴻⵛⴱⴰⵜ ⵏⵙⴻⵏ, ⴰⵇⴰ ⵅⴻⵎⵊⴻⵏ ⵉ ⴽⴻⵏⵏⵉⵡ.’” ");
INSERT INTO rift_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“ⵉⵏⴰ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⵜⴻⵏ ⵜⴻⵛⵛⴻⵎ ⵣⵉ ⵊⴰⵔ ⵎⴰⵔⵔⴰ ⵉⵎⵓⴷⴷⴰⵔⴻⵏ ⵏⵏⵉ ⵉⴷⴷⴰⵔⴻⵏ ⴷⴻⴳ ⵡⴰⵎⴰⵏ: ⵎⴰⵔⵔⴰ ⵡⵉ ⵖⴰⵔ ⵉⴵⴰ ⵡⴰⴼⵔⵉⵡⴻⵏ ⴷ ⵜⴻⵇⵛⵓⵔⵜ ⴷⴻⴳ ⵡⴰⵎⴰⵏ ⵓ ⴷⵉ ⵍⴻⴱⵃⵓⵔ ⵓ ⴷⵉ ⵜⵖⴻⵣⵔⴰⵜⵉⵏ, ⵉⵏⴰ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⵜⴻⵏ ⵜⴻⵛⵛⴻⵎ, ");
INSERT INTO rift_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","ⵎⴰⵛⴰ ⵎⴰⵔⵔⴰ ⵡⵉ ⵡⴰⵔ ⵖⴰⵔ ⵢⴻⴵⵉ ⵉⴼⵔⵉⵡⴻⵏ ⵏⵉⵖ ⵜⴰⵇⵛⵓⵔⵜ ⴷⵉ ⵍⴻⴱⵃⵓⵔ ⵓ ⴷⵉ ⵜⵖⴻⵣⵔⴰⵜⵉⵏ, ⵣⵉ ⵊⴰⵔ ⵎⴰⵔⵔⴰ ⵉ ⵣⵉ ⵙⵙⴻⴼⴼⵢⴻⵏ ⴰⵎⴰⵏ ⵓⵍⴰ ⵣⵉ ⵊⴰⵔ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⴷⴷⴰⵔⴻⵏ ⴷⴻⴳ ⵡⴰⵎⴰⵏ, ⴰⴷ ⴰⵡⴻⵎ ⵢⵉⵍⵉ ⴷ ⵏⵏⵄⵉ. ");
INSERT INTO rift_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","ⵡⴰⵀ ⴰⴷ ⴰⵡⴻⵎ ⵢⵉⵍⵉ ⴷ ⵏⵏⵄⵉ. ⵡⴰⵔ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⵜⴻⵛⵛⴻⵎ ⵣⴻⴳ ⵡⴻⵢⵙⵓⵎ ⵏⵙⴻⵏ ⵓ ⵍⵅⴻⵛⴱⴰⵜ ⵏⵙⴻⵏ ⴰⴷ ⵖⴰⵔⵡⴻⵎ ⵉⵍⵉⵏⵜ ⴷ ⵏⵏⵄⵉ. ");
INSERT INTO rift_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⴵⴰⵏ ⴷⴻⴳ ⵡⴰⵎⴰⵏ ⴱⵍⴰ ⵉⴼⵔⵉⵡⴻⵏ ⴷ ⵜⴻⵇⵛⵓⵔⵜ, ⴰⴷ ⵖⴰⵔⵡⴻⵎ ⵢⵉⵍⵉ ⴷ ⵏⵏⵄⵉ.” ");
INSERT INTO rift_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“ⵣⴻⴳ ⵉⵊⴹⴰⴹ ⴰⴷ ⵖⴰⵔⵡⴻⵎ ⵉⵍⵉⵏ ⵉⵏⴰ ⴷ ⵏⵏⵄⵉ, ⵡⴰⵔ ⵣⵣⴰⵢⵙⴻⵏ ⵜⵜᵉⵜⵜⴻⵎ ⵛⴰ, ⴰⵇⴰ ⴰⵜⴻⵏ ⴷ ⵏⵏⵄⵉ: ⴰⴳⵉⴷⴻⵔ, ⵉⵙⵖⵉ, ⴰⴳⵉⴷⴻⵔ ⵏ ⵍⴻⴱⵃⴰⵔ, ");
INSERT INTO rift_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","ⴰⵛⴻⴼⴼⴰⵔ ⵉⵟⵟⴰⵡⴻⵏ ⵙ ⵜⴰⵣⵍⴰ, ⴰⵎⴻⵙⵙⵖⵓⵢ ⴰⵎⵓⵇⴹⵉⵄ ⵏ ⵜⵉⵟⵟⴰⵡⵉⵏ ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⵎⴰⵔⴽⴰⵜ ⵏⵏⴻⵙ, ");
INSERT INTO rift_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","ⵎⴰⵔⵔⴰ ⵎⴰⵔⴽⴰⵜ ⵏ ⵓⴱⴰⵖⴻⵍ, ");
INSERT INTO rift_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","ⵢⴻⴵⵉⵙ ⵏ ⵜⵖⵓⵢⵢⵉⵜ, ⴰⵄⴻⵏⵏⴰⴼ, ⴰⵊⴹⵉⴹ ⵏ ⵍⴻⴱⵃⴰⵔ, ⵍⴱⴰⵣ ⴰⴽ-ⴷ ⵎⴰⵔⴽⴰⵜ ⵏⵏⴻⵙ, ");
INSERT INTO rift_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","ⴰⵃⴻⵎⵎⴰⵍ ⵏ ⵍⴽⴰⵙ, ⴱⵓ-ⵜⵛⴰⵔⴰⵔⵔⵓⵜ, ⴱⵓ-ⵓⵙⵓⴹⵉ ⵏ ⵍⵎⴻⵡⵜ, ");
INSERT INTO rift_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","ⴱⵓ-ⵢⵓⵏⵜⴰⵃ, ⴱⵓ-ⵓⵄⵓⵇⵇⵉ, ⴱⵓ-ⵓⵃⴰⵡⴰⵔ, ");
INSERT INTO rift_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","ⴰⴱⴻⵍⵍⴰⵔⵊ, ⴱⵓ-ⵓⵙⵓⴹⵉ ⵉⵄⴻⴼⴼⵏⴻⵏ ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⵎⴰⵔⴽⴰⵜ ⵏⵏⴻⵙ, ⴷⵓⵏⴷⵓⵏ ⴷ ⵍⵡⴻⴹⵡⴰⴹ.” ");
INSERT INTO rift_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“ⵎⴰⵔⵔⴰ ⵡⵉ ⵖⴰⵔ ⵉⴵⴰ ⴰⴼⵔⵉⵡⴻⵏ ⵉ ⵉⵜⵜⴱⵓⵄⴻⵏ ⵓ ⵉⴳⴳⵓⵔⴻⵏ ⵅ ⴰⵔⴻⴱⵄⴰ ⵏ ⵉⴹⴰⵔⴻⵏ, ⴰⴷ ⵖⴰⵔⵡⴻⵎ ⵢⵉⵍⵉ ⴷ ⵏⵏⵄⵉ. ");
INSERT INTO rift_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","ⵎⴰⵛⴰ ⵣⵉ ⵎⴰⵔⵔⴰ ⵉⵏⵏⵉ ⵉⵜⵜⴱⵓⵄⴻⵏ ⴰⵎ ⵖⴰⵔⵙⴻⵏ ⴰⴼⵔⵉⵡⴻⵏ ⵓ ⴳⴳⵓⵔⴻⵏ ⵅ ⴰⵔⴻⴱⵄⴰ ⵏ ⵉⴹⴰⵔⴻⵏ, ⵉⵄⴻⴷⴷⴻⵍ ⵉ ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⵜⴻⵛⵛⴻⵎ ⵉⵏⵏⵉ ⵖⴰⵔ ⵉⴵⴰ ⵉⴹⴰⵔⴻⵏ ⵉ ⵡⴻⵏⴳⴰⵣ ⵙⴻⵏⵏⴻⵊ ⵉ ⵉⴹⴰⵔⴻⵏ ⵏⵙⴻⵏ ⵉ ⵜⴻⵛⵍⵉ, ⵃⵉⵎⴰ ⴰⴷ ⵣⵣⴰⵢⵙⴻⵏ ⵏⴻⴳⵣⴻⵏ ⵅ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","ⵉⵏⴰ ⵜⵣⴻⵎⵎⴰⵔⴻⵎ ⴰⴷ ⵣⵣⴰⵢⵙⴻⵏ ⵜⴻⵛⵛⴻⵎ: ⵜⴰⵎⵓⵔⵖⵉ ⵏ ⵡⴻⵢⵍⴰⴼ ⴰⴽ-ⴷ ⵎⴰⵔⴽⴰⵜ ⵏⵏⴻⵙ, ⵜⴰⵎⵓⵖⵔⵉ ⵏ ⵜⴻⵚⴹⴰⵔⵜ ⴰⴽ-ⴷ ⵎⴰⵔⴽⴰⵜ ⵏⵏⴻⵙ, ⵜⴰⵎⵓⵖⵔⵉ ⵉⵏⴻⴳⴳⵣⴻⵏ ⴰⴽ-ⴷ ⵎⴰⵔⴽⴰⵜ ⵏⵏⴻⵙ ⴷ ⵜⴰⵎⵓⵖⵔⵉ ⵉⵍⴻⵃⵃⴼⴻⵏ ⴰⴽ-ⴷ ⵎⴰⵔⴽⴰⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","ⵎⴰⵔⵔⴰ ⵡⵉ ⵖⴰⵔ ⵉⴵⴰ ⴰⴼⵔⵉⵡⴻⵏ ⵉ ⵉⵜⵜⴱⵓⵄⴻⵏ ⵓ ⵖⴰⵔⴻⵙ ⴰⵔⴻⴱⵄⴰ ⵏ ⵉⴹⴰⵔⴻⵏ, ⴰⴷ ⵖⴰⵔⵡⴻⵎ ⵢⵉⵍⵉ ⴷ ⵏⵏⵄⵉ.” ");
INSERT INTO rift_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“ⵙ ⵉⵎⵓⴷⴷⴰⵔⴻⵏ-ⴰ ⵉ ⵖⴰ ⵜᵉⵜⵜⵡⴰⵅⴻⵎⵊⴻⵎ. ⵎⴰⵔⵔⴰ ⵡⵉ ⵖⴰ ⵉⵃⴰⴷⴰⵏ ⵍⵅⴻⵛⴱⴰⵜ ⵏⵙⴻⵏ, ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ⴰⵍ ⵜⴰⵎⴻⴷⴷⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","ⵎⴰⵏⵡⴻⵏ ⵢⵉⵡⵢⴻⵏ ⵛⴰ ⵣⵉ ⵍⵅⴻⵛⴱⴰⵜ ⵏⵙⴻⵏ, ⴰⴷ ⵉⵙⵙⵉⵔⴷ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ⴰⵍ ⵜⴰⵎⴻⴷⴷⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","ⵎⴰⵔⵔⴰ ⵍⴻⴱⵀⴰⵢⴻⵎ, ⵉⵏⵏⵉ ⵖⴰⵔ ⵜⴻⴵⴰ ⵜⴻⵛⴹⴻⵛⵜ ⵉⵎⵎⵙⴻⴱⴹⴰⵏ ⵉ ⵣⵉ ⴼⴰⵔⵇⴰ ⵏ ⵜⴻⵛⴹⴻⵛⵜ ⵡⴰⵔ ⵜⴼⴰⵔⵇ ⵇⴰⵄ, ⵓⵍⴰ ⵡⴰⵔ ⵜⵜⴰⵔⵔⴰⵏ ⵉⴼⴻⵥ, ⴰⴷ ⵖⴰⵔⵡⴻⵎ ⵉⵍⵉⵏ ⵅⴻⵎⵊⴻⵏ. ⵎⴰⵔⵔⴰ ⵡⵉ ⵜⴻⵏ ⵉ ⵖⴰ ⵉⵃⴰⴷⴰⵏ, ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ. ");
INSERT INTO rift_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","ⴽⵓⵍ ⴰⵎⵓⴷⴷⴰⵔ ⵊⴰⵔ ⵉⵎⵓⴷⴷⴰⵔⴻⵏ ⵉ ⵉⴳⴳⵓⵔⴻⵏ ⵅ ⴰⵔⴻⴱⵄⴰ ⵏ ⵜⵍⴻⵇⵇⴰ ⵏ ⵉⴹⴰⵔⴻⵏ ⵏⵙⴻⵏ, ⴰⴷ ⵖⴰⵔⵡⴻⵎ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ. ⵎⴰⵔⵔⴰ ⵡⵉ ⵖⴰ ⵉⵃⴰⴷⴰⵏ ⵍⵅⴻⵛⴱⴰⵜ ⵏⵙⴻⵏ, ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ⴰⵍ ⵜⴰⵎⴻⴷⴷⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","ⵡⵉ ⵢⵉⵡⵢⴻⵏ ⵛⴰ ⵏ ⵍⵅⴻⵛⴱⴰⵜ ⵏⵙⴻⵏ, ⴰⴷ ⵉⵙⵙⵉⵔⴷ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ⴰⵍ ⵜⵎⴻⴷⴷⵉⵜ. ⴰⴷ ⴰⵡⴻⵎ ⵉⵍⵉⵏ ⵅⴻⵎⵊⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“ⵣⵉ ⵊⴰⵔ ⵉⵎⵓⴷⴷⴰⵔⴻⵏ ⵉⵜⵜⴱⵓⵄⴻⵏ, ⵉⵏⵏⵉ ⵉⵜⵜⴱⵓⵄⴻⵏ ⵅ ⵜⴻⵎⵎⵓⵔⵜ, ⴷ ⵉⵏⴰ ⴰⴷ ⵅⴰⵡⴻⵎ ⵉⵍⵉⵏ ⵅⴻⵎⵊⴻⵏ ⵉ ⴽⴻⵏⵏⵉⵡ: ⴰⵊⴰⵔⴱⵓⵄ, ⴰⵖⴻⵔⴷⴰ, ⵉⵛⴼⴰⵔ ⴰⴽ-ⴷ ⵎⴰⵔⴽⴰⵜ ⵏⵏⴻⵙ, ");
INSERT INTO rift_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","ⵉⵇⵇⵍⵉ, ⵜⴰⴽⵏⴰⴽⴰⵔⵜ, ⴰⵣⴻⵔⵎⵓⵎⵎⵓⵢ, ⴰⵃⴷⵉⴹ ⴷ ⵜⴰⵜⴰ. ");
INSERT INTO rift_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","ⵉⵏⴰ ⴰⴷ ⵖⴰⵔⵡⴻⵎ ⵉⵍⵉⵏ ⵅⴻⵎⵊⴻⵏ ⵣⵉ ⵊⴰⵔ ⵎⴰⵔⵔⴰ ⵉⵎⵓⴷⴷⴰⵔⴻⵏ ⵏⵏⵉ ⵉⵜⵜⴱⵓⵄⴻⵏ ⵅ ⵜⴻⵎⵎⵓⵔⵜ. ⵎⴰⵔⵔⴰ ⵡⵉ ⵜⴻⵏ ⵉ ⵖⴰ ⵉⵃⴰⴷⴰⵏ ⴰⵡⴰⵔⵏⵉ ⵍⵎⴻⵡⵜ ⵏⵙⴻⵏ, ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ⴰⵍ ⵜⴰⵎⴻⴷⴷⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵅⴻⴼ ⵉⵡⴹⴰ ⵛⴰ ⵣⵉ ⵍⵅⴻⵛⴱⴰⵜ ⵏⵙⴻⵏ ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ, ⵏⵉⵖ ⵉⵛⵜ ⵏ ⵍⵇⴻⵛⵄⴻⵜ ⵏ ⵜⴻⴼⵍⴰⵡⵜ, ⵏⵉⵖ ⴰⵔⵔⵓⴹ, ⵏⵉⵖ ⵜⵉⵍⵎⴻⵛⵜ, ⵏⵉⵖ ⵜⴰⵅⴰⵏⵛⴻⵜ, ⵏⵉⵖ ⵎⵉⵏ ⵎⴰ ⵍⵇⴻⵛⵄⴻⵜ ⵉ ⵅⴻⴼ ⵉⵡⴹⴰ ⵛⴰ ⵣⵣⴰⵢⵙⴻⵏⵜ, ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵉⵜⵜⵡⴰⵙⵙⴰⵔⵙ ⴷⴻⴳ ⵡⴰⵎⴰⵏ, ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ⴰⵍ ⵜⴰⵎⴻⴷⴷⵉⵜ ⵓ ⴰⵡⴰⵔⵏⵉ ⴰⵢⴰ ⴰⴷ ⵢⵉⵍⵉ ⵉⵣⴷⵉⴳ. ");
INSERT INTO rift_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","ⵎⴰⵔⵔⴰ ⵍⵇⴻⵛⵄⴻⵜ ⵏ ⵜⵍⴰⵅⵜ, ⵜⴻⵏⵏⵉ ⵓⵎⵉ ⴷⵉ ⵉⵡⴹⴰ ⵛⵡⴰⵢⵜ ⵣⵣⴰⵢⴻⵙ, ⴰⵇⴰ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴷⴰⵢⴻⵙ ⵉⴵⴰⵏ ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ⵓⵛⴰ ⵉⵜⵜⵅⴻⵚⵚⴰ ⵉ ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⵜⴰⵔⵥⴻⵎ ⵟⵟⴻⴱⵚⵉ. ");
INSERT INTO rift_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","ⵎⴰⵔⵔⴰ ⵎⴰⵛⵛⴰ ⵏⵏⵉ ⵜⵜⵏⵓⵎⴰⵏ ⵉⵡⴷⴰⵏ ⴰⴷ ⵛⵛⴻⵏ, ⵜⴻⵏⵏⵉ ⵅ ⵡⴹⴰⵏ ⵡⴰⵎⴰⵏ ⵏⵏⵉ, ⴰⴷ ⵜⵉⵍⵉ ⵜⴻⵅⵎⴻⵊ, ⵓ ⵎⴰⵔⵔⴰ ⵜⵉⵙⵙⵉⵜ ⵏⵏⵉ ⵜⵜⵏⵓⵎⴰⵏ ⵉⵡⴷⴰⵏ ⴰⴷ ⵙⵡⴻⵏ, ⵎⴰⵎⵎⴻⵛ ⵎⴰ ⵜⴻⴳⴳⴰ ⵍⵇⴻⵛⵄⴻⵜ ⵉ ⴷⵉ ⵜⴻⴵⴰ ⵎⴰⵛⵛⴰ ⵏⵉⵖ ⵜⵉⵙⵙⵉⵜ, ⴰⴷ ⵜⵉⵍⵉ ⵜⴻⵅⵎⴻⵊ. ");
INSERT INTO rift_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵅⴻⴼ ⵉⵡⴹⴰ ⵛⴰ ⵏ ⵍⵅⴻⵛⴱⴰⵜ ⵏⵙⴻⵏ, ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ. ⴰⴼⴰⵔⵏⵓ ⴷ ⵜⵣⴻⵡⴹⴰ ⴰⴷ ⵜⵜⵡⴰⵔⵥⴻⵏ, ⴰⵇⴰ ⵅⴻⵎⵊⴻⵏ ⵓⵛⴰ ⴰⴷ ⵖⴰⵔⵡⴻⵎ ⵉⵍⵉⵏ ⵅⴻⵎⵊⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","ⵎⴰⵛⴰ ⵍⵄⵓⵏⵚⴰⵔ ⵏⵉⵖ ⴷ ⴰⵏⵓ ⵎⴰⵏⵉ ⵖⴰⵔ ⵙⵙⵉⵣⵣⵍⴻⵏ ⴰⵎⴰⵏ, ⴰⴷ ⵢⵉⵍⵉ ⵉⵣⴷⴻⴳ. ⵎⴰⵛⴰ ⵡⵉ ⵖⴰ ⵉⵃⴰⴷⴰⵏ ⵍⵅⴻⵛⴱⴰⵜ ⵏⵙⴻⵏ, ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ. ");
INSERT INTO rift_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","ⵓⵛⴰ ⵎⴰⵍⴰ ⵉⵡⴹⴰ ⵛⴰ ⵣⵉ ⵍⵅⴻⵛⴱⴰⵜ ⵏⵙⴻⵏ ⵅ ⵛⴰ ⵏ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵉ ⵓⵣⴰⵔⵄ, ⵜⴻⵏⵏⵉ ⵉⵜⵜⵅⴻⵚⵚⴰ ⵄⴰⴷ ⴰⴷ ⵣⴰⵔⵄⴻⵏ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⵉⵍⵉ ⵜⵉⵣⴷⴻⴳ. ");
INSERT INTO rift_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⵙⴻⵢⵢⴱⴻⵏ ⴰⵎⴰⵏ ⵅ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵓⵛⴰ ⵉⵡⴹⴰ ⵅⴰⵙ ⵛⴰ ⵣⵉ ⵍⵅⴻⵛⴱⴰⵜ ⵏⵙⴻⵏ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵖⴰⵔⵡⴻⵎ ⵜⵉⵍⵉ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⵉ ⵜⴻⵅⵎⴻⵊ. ");
INSERT INTO rift_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","ⵓⵛⴰ ⵎⴰⵍⴰ ⵉⵎⵎⵓⵜ ⵉⵊⵊ ⵣⵉ ⵊⴰⵔ ⵍⵎⴰⵍ ⵏⵏⵉ ⵜⴻⵛⵛⵉⵎ, ⵅⴻⵏⵏⵉ ⵡⵉ ⵖⴰ ⵉⵃⴰⴹⴰⵏ ⵍⵅⴻⵛⴱⴻⵜ ⵏⵏⴻⵙ, ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ⴰⵍ ⵜⴰⵎⴻⴷⴷⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","ⵡⴻⵏⵏⵉ ⵉⵛⵛⴻⵏ ⵣⵉ ⵍⵅⴻⵛⴱⴻⵜ ⵏⵏⴻⵙ, ⴰⴷ ⵉⵙⵙⵉⵔⴷ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ⴰⵍ ⵜⴰⵎⴻⴷⴷⵉⵜ. ⵡⴻⵏⵏⵉ ⵢⴰⵔⴱⵓⵏ ⵛⴰ ⵣⵉ ⵍⵅⴻⵛⴱⴻⵜ ⵏⵏⴻⵙ, ⴰⴷ ⵉⵙⵙⵉⵔⴷ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ⴰⵍ ⵜⴰⵎⴻⴷⴷⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","ⴽⵓⵍ ⴰⵎⵓⴷⴷⴰⵔ ⵉⵜⵜⴱⵓⵄⴻⵏ ⵅ ⵜⴻⵎⵎⵓⵔⵜ, ⴰⵇⴰ-ⵜ ⴷ ⵏⵏⵄⵉ. ⵡⴰⵔ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⵉⵜⵜⵡⴰⵛⵛ. ");
INSERT INTO rift_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","ⵣⵉ ⵊⴰⵔ ⵎⴰⵔⵔⴰ ⵉⵎⵓⴷⴷⴰⵔⴻⵏ ⵉⵜⵜⴱⵓⵄⴻⵏ, ⵉⵏⵏⵉ ⵉⵜⵜⴱⵓⵄⴻⵏ ⵅ ⵡⵓⴷⴻⵎ ⵏ ⵜⴻⵎⵎⵓⵔⵜ, ⵡⴰⵔ ⵜⵜᵉⵜⵜⴻⵎ ⵛⴰ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⴳⴳⵓⵔⴻⵏ ⵅ ⵓⵄⴻⴷⴷⵉⵙ ⵏⵉⵖ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⴳⴳⵓⵔⴻⵏ ⵅ ⴰⵔⴻⴱⵄⴰ ⵏ ⵉⴹⴰⵔⴻⵏ ⴰⵍ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⴳⴳⵓⵔⴻⵏ ⵅ ⵡⴰⵟⵟⴰⵙ ⵏ ⵉⴹⴰⵔⴻⵏ, ⵎⵉⵏⵣⵉ ⴰⵇⴰ ⴰⵜⴻⵏ ⴷ ⵏⵏⵄⵉ. ");
INSERT INTO rift_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","ⵡⴰⵔ ⵜⵜⴻⴳⴳⴻⵎ ⵏⵏⵄⵉ ⵉ ⵍⴻⵄⵎⵓⵔ ⵏⵡⴻⵎ ⵙ ⵎⴰⵔⵔⴰ ⵉⵎⵓⴷⴷⴰⵔⴻⵏ ⵉⵜⵜⴱⵓⵄⴻⵏ ⵏⵏⵉ ⴷⵉⵏ ⵉⵜⵜⴱⵓⵄⴻⵏ ⵅ ⵡⵓⴷⴻⵎ ⵏ ⵜⴻⵎⵎⵓⵔⵜ, ⵡⴰⵔ ⵣⵣⴰⵢⴻⵙ ⵙⵙⵅⴻⵎⵎⴰⵊⴻⵎ ⵉⵅⴻⴼ ⵏⵡⴻⵎ ⴰⵍⴰⵎⵉ ⴰⴷ ⵣⵣⴰⵢⵙⴻⵏ ⵜⵅⴻⵎⵊⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","ⵎⵉⵏⵣⵉ ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ. ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⵜⴻⵙⵙⵇⴻⴷⵙⴻⵎ ⵉⵅⴻⴼ ⵏⵡⴻⵎ ⵓⵛⴰ ⴰⴷ ⵜⵉⵍⵉⵎ ⴷ ⵉⵎⵇⴻⴷⴷⴰⵙⴻⵏ, ⵎⵉⵏⵣⵉ ⵏⴻⵛⵛ ⴰⵇⴰ ⴷ ⴰⵎⵇⴻⴷⴷⴰⵙ. ⵡⴰⵔ ⵙⵙⵅⴻⵎⵎⴰⵊⴻⵎ ⵍⴻⵄⵎⵓⵔ ⵏⵡⴻⵎ ⵙ ⵎⴰⵔⵔⴰ ⵉⵎⵎⵓⴷⴰⵔⴻⵏ ⵉⵜⵜⴱⵓⵄⴻⵏ, ⵉⵏⵏⵉ ⵉⵜⵜⴱⵓⵄⴻⵏ ⵅ ⵡⵓⴷⴻⵎ ⵏ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","ⵎⵉⵏⵣⵉ ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⵡⴻⵏⵏⵉ ⴽⴻⵏⵏⵉⵡ ⴷⴷ-ⵉⵙⵙⴳⴻⵄⵄⴷⴻⵏ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ, ⵃⵉⵎⴰ ⴰⴷ ⵉⵍⵉⵖ ⴷ ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ. ⵉⵍⵉⵎ ⴷ ⵉⵎⵇⴻⴷⴷⴰⵙⴻⵏ, ⵎⴰⵖⴰⵔ ⴰⵇⴰ ⵏⴻⵛⵛ ⴷ ⴰⵎⵇⴻⴷⴷⴰⵙ.” ");
INSERT INTO rift_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","ⵡⴰ ⴷ ⴰⵣⴻⵔⴼ ⵅ ⵍⵎⴰⵍ, ⵅ ⵉⵊⴹⴰⴹ ⵓ ⵅ ⵎⴰⵔⵔⴰ ⵉⵎⵓⴷⴷⴰⵔⴻⵏ ⵏⵏⵉ ⵣⵣⴰⵢⵙⴻⵏ ⵉⵙⵙⴻⴼⵢⴻⵏ ⵡⴰⵎⴰⵏ ⵓⵛⴰ ⵅ ⵎⴰⵔⵔⴰ ⵉⵎⵓⴷⴷⴰⵔⴻⵏ ⵏⵏⵉ ⵉⵜⵜⴱⵓⵄⴻⵏ ⵅ ⵜⴻⵎⵎⵓⵔⵜ, ");
INSERT INTO rift_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","ⵃⵉⵎⴰ ⴰⴷ ⵉⵜⵜⵡⴰⴳⴳ ⵍⴼⴰⵔⵇ ⵊⴰⵔ ⵎⵉⵏ ⵉⵅⴻⵎⵊⴻⵏ ⴷ ⵎⵉⵏ ⵉⵣⴷⵉⴳⴻⵏ ⵓ ⵊⴰⵔ ⵉⵎⵓⴷⴷⴰⵔⴻⵏ ⵉⵏⵏⵉ ⵉⵄⴻⴷⴷⵍⴻⵏ ⵉ ⵎⴰⵛⵛⴰ ⴷ ⵉⵎⵓⴷⴷⴰⵔⴻⵏ ⵉⵏⵏⵉ ⵡⴰⵔ ⵉⵄⴻⴷⴷⵍⴻⵏ ⵉ ⵎⴰⵛⵛⴰ. ");
INSERT INTO rift_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“ⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵉⵏⵉ: ‘ⵎⴰⵍⴰ ⵜⴻⴽⵙⵉ ⵉⵛⵜ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⴷⴷⴻⵢⵙⴻⵜ ⵓⵛⴰ ⵜⵓⵔⵓⵡ-ⴷⴷ ⴰⵃⴻⵏⵊⵉⵔ, ⴰⴷ ⵜⵉⵍⵉ ⵜⴻⵅⵎⴻⵊ ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ. ⴰⴷ ⵜⵉⵍⵉ ⵜⴻⵅⵎⴻⵊ ⴰⵎ ⴷⴻⴳ ⵡⵓⵙⵙⴰⵏ ⵏ ⵡⴻⵄⵣⴰⵍ ⵅⵎⵉ ⵅⴰⵙ ⵉⴷⴰⵎⵎⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵜⵎⴻⵏⵢⴰ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵉⵜⵜⵡⴰⵅⵜⴻⵏ ⴰⵢⵙⵓⵎ ⵏ ⵍⴻⵄⴷⴰⵍⵢⴻⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","ⴰⵡⴰⵔⵏⵉ ⵎⴰⵏ ⴰⵢⴰ ⴰⴷ ⵜⴻⵇⵇⵉⵎ ⵜⵍⴰⵜⴰ ⵓ-ⵜⵍⴰⵜⵉⵏ ⵏ ⵡⵓⵙⵙⴰⵏ ⴷⴻⴳ ⵉⴷⴰⵎⵎⴻⵏ ⵏ ⵓⵙⵉⵣⴷⴻⴳ ⵏⵏⴻⵙ. ⵡⴰⵔ ⵜᵉⵜⵜⵃⵉⴷⵉ ⵡⴰⵍⵓ ⵣⵉ ⵎⵉⵏ ⵉⴵⴰⵏ ⵉⵇⴻⴷⴷⴻⵙ ⵓ ⵡⴰⵔ ⵜᵉⵜⵜⵔⴰⵃ ⵖⴰⵔ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ ⴰⵍ ⵖⴰ ⴽⴻⵎⵎⵍⴻⵏ ⵡⵓⵙⵙⴰⵏ ⵏ ⵓⵙⵉⵣⴷⴻⴳ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","ⵎⴰⵍⴰ ⵜⵓⵔⵓⵡ ⴷ ⵜⴰⵃⴻⵏⵊⵉⵔⵜ, ⴰⴷ ⵜⵉⵍⵉ ⵜⴻⵅⵎⴻⵊ ⵜⵏⴰⵢⴻⵏ ⵏ ⵙⵙⵉⵎⴰⵏⴰⵜ, ⴰⵎ ⴷⴻⴳ ⵡⵓⵙⵙⴰⵏ ⵏ ⵡⴻⵄⵣⴰⵍ ⵏⵏⴻⵙ. ⴰⵡⴰⵔⵏⵉ ⵎⴰⵏ ⴰⵢⴰ ⴰⴷ ⵜⴻⵇⵇⵉⵎ ⵙⴻⵜⵜⴰ ⵓ-ⵙⴻⵜⵜⵉⵏ ⵏ ⵡⵓⵙⵙⴰⵏ ⴷⴻⴳ ⵉⴷⴰⵎⵎⴻⵏ ⵏ ⵓⵙⵉⵣⴷⴻⴳ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","ⵅⵎⵉ ⵖⴰ ⴽⴻⵎⵎⵍⴻⵏ ⵡⵓⵙⵙⴰⵏ ⵏ ⵓⵙⵉⵣⴷⴻⴳ ⵏ ⵎⵎⵉⵙ ⵏⵉⵖ ⵏ ⵢⴻⴵⵉⵙ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⴰⵡⵉ ⵉⵊⵊ ⵏ ⵉⵣⵎⴰⵔ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵏⵉⵖ ⵉⵊⵊ ⵏ ⵡⴻⴷⴱⵉⵔ ⴷ ⴰⵎⴻⵥⵢⴰⵏ ⵏⵉⵖ ⵉⵛⵜ ⵏ ⵜⴻⵊⵍⵉⵍⵍⵉⵃⵜ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⵖⴰⵔ ⵓⴽⴻⵀⵀⴰⵏ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","ⴷ ⵏⴻⵜⵜⴰ ⴰⴷ ⵢⴰⵡⵉ ⵎⴰⵏ ⴰⵢⴰ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⵓⵛⴰ ⴰⴷ ⵅⴰⵙ ⵉⴳⴳ ⴰⵚⵍⴰⵃ. ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⵉⵍⵉ ⵜⵉⵣⴷⴻⴳ ⵣⵉ ⵍⵄⵓⵏⵚⴰⵔ ⵏ ⵉⴷⴰⵎⵎⴻⵏ ⵏⵏⴻⵙ. ⵡⴰ ⴷ ⴰⵣⴻⵔⴼ ⵉ ⵜⴻⵏⵏⵉ ⵉ ⵖⴰ ⵢⴰⵔⵡⴻⵏ ⵉⵊⵊ ⵏ ⵎⵎⵉⵙ ⵏⵉⵖ ⵉⵛⵜ ⵏ ⵢⴻⴵⵉⵙ. ");
INSERT INTO rift_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","ⵎⴰⵍⴰ ⵡⴰⵔ ⵜⵉⵡⵉⴹ ⴰⴷ ⵜⴰⵡⵉ ⵉⵊⵊ ⵣⴻⴳ ⵡⵓⴵⵉ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜᵉⵟⵟⴻⴼ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵊⵍⵉⵍⵍⵉⵃⵉⵏ ⵏⵉⵖ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⴷⴱⵉⵔⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⴻⵏ, ⵉⵊⵊ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵓ ⵉⵊⵊ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ, ⵓⵛⴰ ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵅⴰⵙ ⵉⴳⴳ ⴰⵚⵍⴰⵃ. ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⵉⵍⵉ ⵜⵉⵣⴷⴻⴳ.’” ");
INSERT INTO rift_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“ⵎⴰⵍⴰ ⵉⵊⵊ ⵏ ⴱⵏⴰⴷⴻⵎ ⵖⴰⵔⴻⵙ ⴷⵉ ⵜⴻⵍⵎⴻⵛⵜ ⵏ ⴰⵔⵔⵉⵎⴻⵜ ⵏⵏⴻⵙ ⴰⵄⴻⴱⴱⵓⵣ ⵏⵉⵖ ⵉⵛⵜ ⵏ ⵜⵃⴻⴱⴱⵓⵛⵜ ⵏⵉⵖ ⵉⵊⵊ ⵏ ⵡⴻⵏⴳⴰⵣ ⵉⵛⵛⴻⵎⵍⴻⵍ, ⵓⵛⴰ ⵡⴰⵏⵉⵜⴰ ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵉⴷⵡⴻⵍ ⴷ ⵓⴹⵓⵏ ⵏ ⵍⴱⴰⵔⵚ ⴷⵉ ⵜⴻⵍⵎⴻⵛⵜ ⵏ ⴰⵔⵔⵉⵎⴻⵜ ⵏⵏⴻⵙ, ⴰⴷ ⵜ ⴰⵡⵢⴻⵏ ⵖⴰⵔ ⵀⴰⵔⵓⵏ, ⴰⴽⴻⵀⵀⴰⵏ, ⵏⵉⵖ ⵖⴰⵔ ⵢⵉⵊⵊⴻⵏ ⵣⴻⴳ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ, ⵖⴰⵔ ⵉⴽⴻⵀⵀⴰⵏⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵉⵅⵣⴰⵔ ⵖⴰⵔ ⵡⵓⴹⵓⵏ ⴷⵉ ⵜⴻⵍⵎⴻⵛⵜ ⵏ ⴰⵔⵔⵉⵎⴻⵜ ⵏⵏⴻⵙ ⵓⵛⴰ ⵎⴰⵍⴰ ⵉⵥⵔⴰ ⴰⵇⴰ ⵉⵥⵓⵟⵟⴰⵏ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏ ⵡⵓⴹⵓⵏ ⴷⴻⵡⵍⴻⵏ ⴷ ⵉⵛⴻⵎⵍⴰⵍⴻⵏ ⵓⵛⴰ ⵉⴱⴰⵏ ⵡⵓⴹⵓⵏ ⵄⴰⴷ ⵢⵓⴵⴻⵖ ⵅ ⵜⴻⵍⵎⴻⵛⵜ ⵏ ⴰⵔⵔⵉⵎⴻⵜ ⵏⵏⴻⵙ, ⴰⵇⴰ ⵅⴻⵏⵏⵉ ⴷ ⵓⴹⵓⵏ ⵏ ⵍⴱⴰⵔⵚ. ⵅⵎⵉ ⵜ ⵖⴰ ⵉⵥⴰⵔ ⵓⴽⴻⵀⵀⴰⵏ, ⴰⴷ ⵜ ⵉⴱⴰⵔⵔⴻⵃ ⴷ ⴰⵎⴻⵅⵎⵓⵊ. ");
INSERT INTO rift_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⴰⵏⴳⴰⵣ ⵉⵛⵛⴻⵎⵍⴻⵍ ⴷⵉ ⵜⴻⵍⵎⴻⵛⵜ ⵏ ⴰⵔⵔⵉⵎⴻⵜ ⵏⵏⴻⵙ ⴷ ⴰⵛⴻⵎⵍⴰⵍ ⵓ ⵡⴰⵔ ⵢⵓⴵⵉⵖ ⵅ ⵜⴻⵍⵎⴻⵛⵜ ⵓ ⵉⵥⴻⵟⵟⴰⵏ ⵡⴰⵔ ⴷⵡⵉⵍⴻⵏ ⴷ ⵉⵛⴻⵎⵍⴰⵍⴻⵏ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⴱⴻⵍⵍⴻⵄ ⵓⴽⴻⵀⵀⴰⵏ ⵅ ⵡⴻⵏⵏⵉ ⴷⵉ ⵉⴵⴰ ⵓⴹⵓⵏ ⵏⵏⵉ ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","ⵎⴰⵍⴰ ⵉⵥⵔⴰ ⵉ-ⵜ ⵓⴽⴻⵀⵀⴰⵏ ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ ⵓⵛⴰ ⵉⵥⵔⴰ ⴰⵇⴰ ⵓⴹⵓⵏ ⴰⵎⴻⵏⵏⵉ ⵉⵇⵇⵉⵎ, ⵡⴰⵔ ⵉⵎⵖⵉⵔ ⵡⵓⴹⵓⵏ ⴷⵉ ⵜⴻⵍⵎⴻⵛⵜ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜ ⵉⴱⴻⵍⵍⴻⵄ ⵓⴽⴻⵀⵀⴰⵏ ⵄⴰⵡⴻⴷ ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⵏⵏⴻⵖⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ ⴰⴷ ⵜ ⵉⵥⴰⵔ ⵓⴽⴻⵀⵀⴰⵏ ⵄⴰⵡⴻⴷ ⵓⵛⴰ ⵎⴰⵍⴰ ⵉⴱⴰⵏ ⴰⵇⴰ ⵓⴹⵓⵏ ⵢⴰⵔⵙⴰ ⵓⵛⴰ ⵡⴰⵔ ⵉⵎⵖⵉⵔ ⵄⴰⴷ ⴽⵜⴰⵔ ⵅ ⵜⴻⵍⵎⴻⵛⵜ, ⵅⴻⵏⵏⵉ ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵜ ⵉⴱⴰⵔⵔⴻⵃ ⴷ ⴰⵎⴻⵣⴷⴰⴳ. ⵜⵓⵖⴰ-ⵜⵜ ⴷ ⵉⵛⵜ ⵏ ⵜⴼⵓⵔⵉⵢ. ⴰⴷ ⵉⵙⵙⵉⵔⴷ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⵢⵉⵍⵉ ⵉⵣⴷⵉⴳ. ");
INSERT INTO rift_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⵉⵎⵖⴰⵔ ⵡⵓⴹⵓⵏ ⴰⵟⵟⴰⵙ ⵅ ⵜⴻⵍⵎⴻⵛⵜ ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⵜ ⵉⵥⵔⴰ ⵓⴽⴻⵀⵀⴰⵏ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏ ⵓⵙⵉⵣⴷⴻⴳ ⵏⵏⴻⵙ, ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵉⵙⵙⵛⴻⵏ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵉ ⵓⴽⴻⵀⵀⴰⵏ ⵜⵡⴰⵍⴰ ⵏⵏⴻⵖⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","ⵎⴰⵍⴰ ⵉⵥⵔⴰ ⵓⴽⴻⵀⵀⴰⵏ, ⴰⵇⴰ ⵍⴻⵀⵍⴰⵛ ⵉⵎⵖⴰⵔ ⵅ ⵜⴻⵍⵎⴻⵛⵜ, ⴰⴷ ⵜ ⵉⴱⴰⵔⵔⴻⵃ ⴷ ⴰⵎⴻⵅⵎⵓⵊ. ⴰⵇⴰ-ⵜ ⴷ ⵍⴻⵀⵍⴰⵛ ⵏ ⵍⴱⴰⵔⵚ ⵉ ⵉⴵⴰ. ");
INSERT INTO rift_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","ⵅⵎⵉ ⵓⴹⵓⵏ ⵏ ⵍⴱⴰⵔⵚ ⴰⵇⴰ-ⵜ ⴷⴻⴳ ⵉⵊⵊ ⵏ ⴱⵏⴰⴷⴻⵎ, ⴰⴷ ⵜ ⴰⵡⵢⴻⵏ ⵖⴰⵔ ⵓⴽⴻⵀⵀⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","ⵎⴰⵍⴰ ⵉⵥⵔⴰ ⵓⴽⴻⵀⵀⴰⵏ, ⴰⵇⴰ ⵉⴱⴰⵏ ⵉⵊⵊ ⵏ ⵓⵄⴻⴱⴱⵓⵣ ⴷ ⴰⵛⴻⵎⵍⴰⵍ ⴷⵉ ⵜⴻⵍⵎⴻⵛⵜ, ⵓ ⵉⵥⴻⵟⵟⴰⵏ ⴷⴻⵡⵍⴻⵏ ⴷ ⵉⵛⴻⵎⵍⴰⵍⴻⵏ ⵓ ⵉⴱⴰⵏ-ⴷⴷ ⵡⴻⵢⵙⵓⵎ ⵉⴷⴷⴰⵔ ⴷⴻⴳ ⵓⵄⴻⴱⴱⵓⵣ, ");
INSERT INTO rift_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","ⴰⵇⴰ-ⵜ ⴷ ⵍⴱⴰⵔⵙ ⴰⵇⴷⵉⵎ ⴷⵉ ⵜⴻⵍⵎⴻⵛⵜ ⵏ ⴰⵔⵔⵉⵎⴻⵜ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵉⴱⴰⵔⵔⴻⵃ ⴷ ⴰⵎⴻⵅⵎⵓⵊ. ⵡⴰⵔ ⵅⴰⵙ ⵉⵜⵜⴱⴻⵍⵍⵉⵄ ⵛⴰ, ⵎⵉⵏⵣⵉ ⵏⴻⵜⵜⴰ ⴰⵇⴰ ⵉⵅⵎⴻⵊ. ");
INSERT INTO rift_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","ⵎⴰⵍⴰ ⵢⵓⵢⵓⵔ ⵍⴱⴰⵔⵚ ⵅ ⵜⵉⵍⵎⴻⵛⵜ ⵎⴰⵔⵔⴰ ⵓⵛⴰ ⵉⴷⵍⴰ ⵍⴱⴰⵔⵚ ⵎⴰⵔⵔⴰ ⵜⵉⵍⵎⴻⵛⵜ ⵏ ⵡⴻⵏⵏⵉ ⵖⴰⵔ ⵉⴵⴰ ⵓⴹⵓⵏ ⵣⴻⴳ ⵓⵣⴻⴵⵉⴼ ⵏⵏⴻⵙ ⴰⵍ ⵉⴹⴰⵔⴻⵏ ⵏⵏⴻⵙ, ⴰⵍ ⵎⴰⵏⵉ ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵉⵥⴰⵔ ⵓⴽⴻⵀⵀⴰⵏ ⵙ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵙ, ");
INSERT INTO rift_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","ⵓⵛⴰ ⵉⵥⵔⴰ ⵉ-ⵜ ⵓⴽⴻⵀⵀⴰⵏ, ⵉⵥⵔⴰ ⵍⴱⴰⵔⵙ ⵉⴷⵍⴰ ⵎⴰⵔⵔⴰ ⴰⵔⵔⵉⵎⴻⵜ ⵏⵏⴻⵙ, ⵅⴻⵏⵏⵉ ⵏⴻⵜⵜⴰ ⴰⴷ ⵉⴱⴰⵔⵔⴻⵃ ⴷ ⴰⵎⴻⵣⴷⴰⴳ ⵉ ⵡⴻⵏⵏⵉ ⴷⵉ ⵉⴵⴰ ⵡⵓⴹⵓⵏ. ⵜⵉⵍⵎⴻⵛⵜ ⴰⵇⴰ-ⵜⵜ ⴷ ⵜⴰⵛⴻⵎⵍⴰⵍⵜ ⵇⴰⵄ. ⵏⴻⵜⵜⴰ ⴰⵇⴰ ⵉⵣⴷⵉⴳ. ");
INSERT INTO rift_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","ⵎⴰⵛⴰ ⴷⴻⴳ ⵡⴰⵙⵙ ⵎⴰⵏⵉ ⴷⴰⵢⴻⵙ ⵉ ⵖⴰ ⴷⴷ-ⵉⴱⴰⵏ ⵡⴻⵢⵙⵓⵎ ⵉⴷⴷⴰⵔ, ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ. ");
INSERT INTO rift_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","ⵎⴰⵍⴰ ⵉⵥⵔⴰ ⵓⴽⴻⵀⵀⴰⵏ ⴰⵢⵙⵓⵎ ⵏⵏⵉ ⵉⴷⴷⴰⵔ, ⴰⴷ ⵜ ⵉⴱⴰⵔⵔⴻⵃ ⴷ ⴰⵎⴻⵅⵎⵓⵊ. ⴰⵢⵙⵓⵎ ⵉⴷⴷⴰⵔⴻⵏ ⵉⵅⵎⴻⵊ, ⴰⵇⴰ-ⵜ ⴷ ⵍⴻⵀⵍⴰⵛ ⵏ ⵍⴱⴰⵔⵚ. ");
INSERT INTO rift_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⵉⴱⴻⴷⴷⴻⵍ ⵡⴻⵢⵙⵓⵎ ⵉⴷⴷⴰⵔⴻⵏ ⵓ ⵉⴷⵡⴻⵍ ⴷ ⴰⵛⴻⵎⵍⴰⵍ, ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⵙ ⴰⴷ ⴷⴷ-ⵢⴰⵙ ⵖⴰⵔ ⵓⴽⴻⵀⵀⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","ⵎⴰⵍⴰ ⵉⵥⵔⴰ ⵉ-ⵜ ⵓⴽⴻⵀⵀⴰⵏ ⵓⵛⴰ ⴰⵇⴰ ⴰⵎⵛⴰⵏ ⵏ ⵓⴹⵓⵏ ⵉⴷⵡⴻⵍ ⴷ ⴰⵛⴻⵎⵍⴰⵍ, ⴰⴷ ⵉⴱⴰⵔⵔⴻⵃ ⵓⴽⴻⵀⵀⴰⵏ ⵡⴻⵏⵏⵉ ⴷⵉ ⵉⴵⴰ ⵍⴻⵀⵍⴰⵛ ⴷ ⴰⵎⴻⵣⴷⴰⴳ. ⵏⴻⵜⵜⴰ ⴰⵇⴰ ⵉⵣⴷⵉⴳ. ");
INSERT INTO rift_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","ⵎⴰⵍⴰ ⴷⵉⵏ ⵅ ⵜⴻⵍⵎⴻⵛⵜ ⵏ ⵡⴻⵢⵙⵓⵎ ⵉⵛⵜ ⵏ ⵜⵃⴻⴱⴱⵓⵛⵜ ⵓ ⵜᵉⵜⵜⵡⴰⵙⵙⴳⴻⵏⴼⴰ ⵜⴰⵏⵉⵜⴰ, ");
INSERT INTO rift_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","ⵎⴰⵛⴰ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏ ⵜⵃⴻⴱⴱⵓⵛⵜ ⵉⴷⵡⴻⵍ ⴷ ⵉⵊⵊ ⵏ ⵓⵄⴻⴱⴱⵓⵣ ⵉⵎⵍⴻⵍ ⵏⵉⵖ ⴷ ⵉⵊⵊ ⵏ ⵡⴻⵏⴳⴰⵣ ⵉⵛⵛⴻⵎⵍⴻⵍ, ⴰⵛⴻⵎⵍⴰⵍ ⵉⵔⵓⵃ ⵖⴰⵔ ⵜⴻⵣⵡⴻⵖ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⵥⴰⵔ ⵓⴽⴻⵀⵀⴰⵏ ⵎⴰⵏ ⴰⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","ⵅⵎⵉ ⵖⴰⵔⴻⵙ ⵉ ⵖⴰ ⵉⵅⵣⴰⵔ ⵓⴽⴻⵀⵀⴰⵏ ⵓⵛⴰ ⵉⵥⵔⴰ ⴰⵇⴰ-ⵜ ⵙⴰⴷⵓ ⵜⴻⵍⵎⴻⵛⵜ ⵓⵛⴰ ⵉⵥⴻⵟⵟⴰⵏ ⵏⵏⴻⵙ ⴷ ⵉⵛⴻⵎⵍⴰⵍⴻⵏ, ⵅⴻⵏⵏⵉ ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵜ ⵉⴱⴰⵔⵔⴻⵃ ⴷ ⴰⵎⴻⵅⵎⵓⵊ, ⴰⵇⴰ-ⵜ ⴷ ⵓⴹⵓⵏ ⵏ ⵍⴱⴰⵔⵚ ⵡⴻⵏⵏⵉ ⵢⵓⵢⵓⵔⴻⵏ ⵙ ⵜⵃⴻⴱⴱⵓⵛⵜ. ");
INSERT INTO rift_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⵉⵥⵔⴰ ⵉ-ⵜ ⵓⴽⴻⵀⵀⴰⵏ ⵓⵛⴰ ⵡⴰⵔ ⴷⴰⵢⴻⵙ ⵢⵓⴼⵉ ⵓⵍⴰ ⴷ ⵉⵊⵊ ⵏ ⵓⵥⴻⵟⵟⵓ ⴷ ⴰⵛⴻⵎⵍⴰⵍ ⵓⵛⴰ ⵡⴰⵔ ⵉⴷⵡⵉⵍ ⵢⵓⴵⴻⵖ ⵅ ⵜⴻⵍⵎⴻⵛⵜ, ⵎⴰⵛⴰ ⵉⴷⵡⴻⵍ ⵢⴰⵔⵙⴰ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵅⴰⵙ ⵉⴱⴻⵍⵍⴻⵄ ⵓⴽⴻⵀⵀⴰⵏ ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","ⵎⴰⵍⴰ ⵜⵓⵢⵓⵔ ⵅ ⵜⴻⵍⵎⴻⵛⵜ ⵎⴰⵔⵔⴰ, ⵅⴻⵏⵏⵉ ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵜ ⵉⴱⴰⵔⵔⴻⵃ ⴷ ⴰⵎⴻⵅⵎⵓⵊ. ⴰⵇⴰ-ⵜ ⴷ ⵓⴹⵓⵏ ⵏ ⵍⴱⴰⵔⵚ. ");
INSERT INTO rift_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⴰⵏⴳⴰⵣ ⵉⵛⵛⴻⵎⵍⴻⵍ ⵏ ⵜⴻⵍⵎⴻⵛⵜ ⵉⵇⵇⵉⵎ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏⵏⴻⵙ, ⵡⴰⵔ ⵉⵎⵖⵉⵔ ⵛⴰ, ⴰⵇⴰ-ⵜ ⴷ ⵛⵛⴰⵎⴻⵜ ⵏ ⵜⵃⴻⴱⴱⵓⵛⵜ ⵓⵛⴰ ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵜ ⵉⴱⴰⵔⵔⴻⵃ ⴷ ⴰⵎⴻⵣⴷⴰⴳ. ");
INSERT INTO rift_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","ⵏⵉⵖ ⵎⴰⵍⴰ ⵉⴷⵡⴻⵍ ⴷⵉ ⵜⴻⵍⵎⴻⵛⵜ ⵏ ⴰⵔⵔⵉⵎⴻⵜ ⵉⵊⵊ ⵏ ⵓⵢⴻⵣⵣⵉⵎ ⵏ ⵡⴻⵛⵎⴰⴹ ⵓⵛⴰ ⴰⵢⵙⵓⵎ ⵉⴷⴷⴰⵔⴻⵏ ⵏ ⵓⵢⴻⵣⵣⵉⵎ ⵏ ⵡⴻⵛⵎⴰⴹ ⵉⴷⵡⴻⵍ ⴷ ⵉⵊⵊ ⵏ ⵡⴻⵏⴳⴰⵣ ⵉⵛⵛⴻⵎⵍⴻⵍ, ⴰⵛⴻⵎⵍⴰⵍ ⵉⵔⵓⵃ ⵖⴰⵔ ⵜⴻⵣⵡⴻⵖ ⵏⵉⵖ ⴷ ⴰⵛⴻⵎⵍⴰⵍ, ");
INSERT INTO rift_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","ⵓⵛⴰ ⵉⵥⵔⴰ ⵓⴽⴻⵀⵀⴰⵏ ⵎⴰⵏ ⴰⵢⴰ, ⵓⵛⴰ ⵅⵣⴰⵔ, ⵉⵥⴻⵟⵟⴰⵏ ⵉ ⵉⴵⴰⵏ ⴷⴻⴳ ⵡⴻⵏⴳⴰⵣ ⵉⵛⵛⴻⵎⵍⴻⵍ ⴰⵇⴰ ⴷⴻⵡⵍⴻⵏ ⴷ ⵉⵛⴻⵎⵍⴰⵍⴻⵏ, ⵓⵛⴰ ⵉⴱⴰⵏ ⴰⵇⴰ ⴰⵎⵛⴰⵏ ⵏ ⵡⴻⵏⴳⴰⵣ ⵢⵓⴵⴻⵖ ⴷⵉ ⵜⴻⵍⵎⴻⵛⵜ, ⴰⵇⴰ-ⵜ ⴷ ⵍⴱⴰⵔⵚ ⵏⵏⵉ ⴷⴷ-ⵉⴼⴼⵖⴻⵏ ⵣⴻⴳ ⵓⵢⴻⵣⵣⵉⵎ ⵏ ⵡⴻⵛⵎⴰⴹ. ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵜ ⵉⴱⴰⵔⵔⴻⵃ ⴷ ⴰⵎⴻⵅⵎⵓⵊ. ⴰⵇⴰ-ⵜ ⴷ ⵓⴹⵓⵏ ⵏ ⵍⴱⴰⵔⵚ. ");
INSERT INTO rift_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⴰⴽⴻⵀⵀⴰⵏ ⵉⵥⵔⴰ ⵎⴰⵏ ⴰⵢⴰ ⵓⵛⴰ ⵡⴰⵔ ⵉⵜⵜⵡⵉⵍⵉ ⵉⵥⴻⵟⵟⴰⵏ ⵉⵛⴻⵎⵍⴰⵍⴻⵏ ⴷⴻⴳ ⵡⴻⵏⴳⴰⵣ ⵉⵛⵛⴻⵎⵍⴻⵍ ⵓⵛⴰ ⵉⵥⵔⴰ ⴰⵏⴳⴰⵣ ⵡⴰⵔ ⵢⵓⴵⵉⵖ ⵅ ⵜⴻⵍⵎⴻⵛⵜ ⵓⵛⴰ ⵢⴰⵔⵙⴰ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵅⴰⵙ ⵉⴱⴻⵍⵍⴻⵄ ⵓⴽⴻⵀⵀⴰⵏ ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ ⴰⴷ ⵜ ⵉⵥⴰⵔ ⵓⴽⴻⵀⵀⴰⵏ ⵓⵛⴰ ⵎⴰⵍⴰ ⵉⵎⵖⴰⵔ ⵡⴻⵏⴳⴰⵣ ⴽⵜⴰⵔ ⵅ ⵜⴻⵍⵎⴻⵛⵜ, ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵜ ⵉⴱⴰⵔⵔⴻⵃ ⴷ ⴰⵎⴻⵅⵎⵓⵊ. ⴰⵇⴰ-ⵜ ⴷ ⵓⴹⵓⵏ ⵏ ⵍⴱⴰⵔⵚ. ");
INSERT INTO rift_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⴰⵏⴳⴰⵣ ⵉⵛⵛⴻⵎⵍⴻⵍ ⵉⵇⵇⵉⵎ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏⵏⴻⵙ, ⵡⴰⵔ ⵉⵎⵖⵉⵔ ⵅ ⵜⴻⵍⵎⴻⵛⵜ ⵓⵛⴰ ⵢⴰⵔⵙⴰ, ⴰⵇⴰ-ⵜ ⴷ ⴰⵄⴻⴱⴱⵓⵣ ⵏ ⵡⴻⵛⵎⴰⴹ. ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵜ ⵉⴱⴰⵔⵔⴻⵃ ⴷ ⴰⵎⴻⵣⴷⴰⴳ, ⵎⵉⵏⵣⵉ ⴰⵇⴰ-ⵜⵜ ⴷ ⵛⵛⴰⵎⴻⵜ ⵏ ⵡⴻⵛⵎⴰⴹ. ");
INSERT INTO rift_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","ⵎⴰⵍⴰ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵏⵉⵖ ⵉⵛⵜ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⴷⴰⵢⴻⵙ ⵓⴹⵓⵏ ⴷⴻⴳ ⵓⵣⴻⴵⵉⴼ ⵏⵉⵖ ⴷⵉ ⵜⵎⴰⵔⵜ, ");
INSERT INTO rift_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","ⵓⵛⴰ ⵉⵅⵣⴰⵔ ⵓⴽⴻⵀⵀⴰⵏ ⵖⴰⵔ ⵓⴹⵓⵏ, ⵓ ⵅⵣⴰⵔ, ⴰⵇⴰ ⵉⵜⵜⴱⴰⵏ ⵢⵓⴵⴻⵖ ⴷⵉ ⵜⴻⵍⵎⴻⵛⵜ ⵓⵛⴰ ⴷⴰⵢⴻⵙ ⵉⵥⴻⵟⵟⴰⵏ ⵉⵡⴰⵔⵖⴻⵏ ⴷ ⵉⵣⴷⴰⴷⴻⵏ, ⵅⴻⵏⵏⵉ ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵜ ⵉⴱⴰⵔⵔⴻⵃ ⴷ ⴰⵎⴻⵅⵎⵓⵊ. ⴰⵇⴰ-ⵜⵜ ⴷ ⵜⴼⵓⵔⵉ ⵏ ⵢⵉⵍⴻⵎ, ⴰⵇⴰ-ⵜ ⴷ ⵍⴱⴰⵔⵚ ⵏ ⵓⵣⴻⴵⵉⴼ ⵏⵉⵖ ⵏ ⵜⵎⴰⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⵉⵥⵔⴰ ⵓⴽⴻⵀⵀⴰⵏ ⵓⴹⵓⵏ ⵏ ⵜⴼⵓⵔⵉ ⵏ ⵢⵉⵍⴻⵎ, ⵉⵥⵔⴰ ⴰⵇⴰ ⵡⴰⵔ ⵢⵓⴵⵉⵖ ⴷⵉ ⵜⴻⵍⵎⴻⵛⵜ ⵓⵛⴰ ⵡⴰⵔ ⴷⴰⵢⴻⵙ ⵉⵥⴻⵟⵟⴰⵏ ⵉⴱⴰⵔⵛⴰⵏⴻⵏ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵅⴰⵙ ⵉⴱⴻⵍⵍⴻⵄ ⵓⴽⴻⵀⵀⴰⵏ ⵅ ⵡⴻⵏⵏⵉ ⴷⵉ ⵉⴵⴰ ⵡⵓⴹⵓⵏ ⵏ ⵜⴼⵓⵔⵉ ⵏ ⵢⵉⵍⴻⵎ ⵉ ⵢⵉⵊⵊ ⵏ ⵍⵎⵉⵊⴰⵍ ⵏ ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","ⴰⴷ ⵉⵥⴰⵔ ⵓⴽⴻⵀⵀⴰⵏ ⵓⴹⵓⵏ ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ ⵓⵛⴰ ⵎⴰⵍⴰ ⵉⵥⵔⴰ, ⴰⵇⴰ ⵜⴼⵓⵔⵉ ⵏ ⵢⵉⵍⴻⵎ ⵡⴰⵔ ⵜⴻⵎⵖⵉⵔ, ⵡⴰⵔ ⴷⴰⵢⴻⵙ ⵢⵓⴼⵉ ⵉⵥⴻⵟⵟⴰⵏ ⵉⵡⴰⵔⵖⴻⵏ ⵓⵛⴰ ⵜⴼⵓⵔⵉ ⵏ ⵢⵉⵍⴻⵎ ⵡⴰⵔ ⵜⵓⴵⵉⵖ ⵅ ⵜⴻⵍⵎⴻⵛⵜ, ");
INSERT INTO rift_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","ⵅⴻⵏⵏⵉ ⵏⴻⵜⵜⴰ ⴰⴷ ⵉⵃⴻⴼⴼ ⵉ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵙ, ⵎⴰⵛⴰ ⴰⵎⵛⴰⵏ ⵏ ⵜⴼⵓⵔⵉ ⵏ ⵢⵉⵍⴻⵎ ⵡⴰⵔ ⵜ ⵉⵜⵜⵃⴻⴼⴼⵉ ⵛⴰ ⵓⵛⴰ ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵉⴱⴻⵍⵍⴻⵄ ⵅ ⵡⴻⵏⵏⵉ ⴷⵉ ⵉⴵⴰ ⵜⴼⵓⵔⵉ ⵏ ⵢⵉⵍⴻⵎ ⵄⴰⴷ ⵉⵛⵜ ⵏ ⵜⵡⴰⵍⴰ ⵏⵏⴻⵖⵏⵉ ⵉ ⵢⵉⵊⵊ ⵏ ⵍⵎⵉⵊⴰⵍ ⵏ ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ ⴰⴷ ⵉⵥⴰⵔ ⵓⴽⴻⵀⵀⴰⵏ ⴰⵎⵛⴰⵏ ⵏ ⵜⴼⵓⵔⵉ ⵏ ⵢⵉⵍⴻⵎ. ⵎⴰⵍⴰ ⵉⵥⵔⴰ ⴰⵇⴰ ⵜⴼⵓⵔⵉ ⵏ ⵢⵉⵍⴻⵎ ⵡⴰⵔ ⵜⴻⵎⵖⵉⵔ ⵛⴰ, ⵡⴰⵔ ⵜⵓⴵⵉⵖ ⵅ ⵜⴻⵍⵎⴻⵛⵜ, ⵅⴻⵏⵏⵉ ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵜ ⵉⴱⴰⵔⵔⴻⵀ ⴷ ⴰⵎⴻⵣⴷⴰⴳ. ⴰⴷ ⵉⵙⵙⵉⵔⴷ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⵢⵉⵍⵉ ⵉⵣⴷⵉⴳ. ");
INSERT INTO rift_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⵜⴼⵓⵔⵉ ⵏ ⵢⵉⵍⴻⵎ ⵜⴻⵎⵖⴰⵔ ⴰⵟⵟⴰⵙ ⵅ ⵜⴻⵍⵎⴻⵛⵜ ⴰⵡⴰⵔⵏⵉ ⵉ ⵓⵙⵉⵣⴷⴻⴳ ⵏⵏⴻⵙ, ");
INSERT INTO rift_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","ⵓⵛⴰ ⵉⵥⵔⴰ ⵉ-ⵜ ⵓⴽⴻⵀⵀⴰⵏ ⵓⵛⴰ ⵉⵥⵔⴰ ⵜⴼⵓⵔⵉ ⵏ ⵢⵉⵍⴻⵎ ⵜⴻⵎⵖⴰⵔ ⵅ ⵜⴻⵍⵎⴻⵛⵜ, ⵅⴻⵏⵏⵉ ⵡⴰⵔ ⵢⴰⵔⴻⵣⵣⵓ ⵓⴽⴻⵀⵀⴰⵏ ⵅ ⵉⵥⴻⵟⵟⴰⵏ ⵉⵡⴰⵔⵖⴻⵏ ⵄⴰⴷ, ⵏⴻⵜⵜⴰ ⴰⵇⴰ ⵉⵅⵎⴻⵊ. ");
INSERT INTO rift_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⵜⴼⵓⵔⵉ ⵏ ⵢⵉⵍⴻⵎ ⴰⵇⴰ ⵜⴱⴰⵏ-ⴷⴷ ⵜⴱⴻⴷⴷ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵙ, ⵓⵛⴰ ⴼⴼⵖⴻⵏ-ⴷⴷ ⵣⵣⴰⵢⴻⵙ ⵉⵥⴻⵟⵟⴰⵏ ⵉⴱⴰⵔⵛⴰⵏⴻⵏ, ⵅⴻⵏⵏⵉ ⴰⵇⴰ ⵜᵉⴳⴳⴻⵏⴼⴰ ⵜⴼⵓⵔⵉ ⵏ ⵢⵉⵍⴻⵎ ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⴰⵇⴰ ⵉⵣⴷⴻⴳ. ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵜ ⵉⴱⴰⵔⵔⴻⵃ ⴷ ⴰⵎⴻⵣⴷⴰⴳ. ");
INSERT INTO rift_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","ⵎⴰⵍⴰ ⴱⴰⵏⴻⵏ-ⴷⴷ ⵉⵎⵓⵛⴰⵏ ⵛⵛⴻⵎⵍⴻⵍⴻⵏ, ⵉⵛⵛⴻⵎⵍⴻⵍⴻⵏ ⴷ ⵉⵛⴻⵎⵍⴰⵍⴻⵏ, ⴷⵉ ⵜⴻⵍⵎⴻⵛⵜ ⵏ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵏⵉⵖ ⵏ ⵉⵛⵜ ⵏ ⵜⴻⵎⵖⴰⵔⵜ, ");
INSERT INTO rift_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","ⵓⵛⴰ ⵉⵥⵔⴰ ⵓⴽⴻⵀⵀⴰⵏ ⵎⴰⵏ ⴰⵢⴰ ⵓⵛⴰ ⵉⵥⵔⴰ ⴰⵇⴰ ⴷⵉ ⵜⴻⵍⵎⴻⵛⵜ ⵏ ⴰⵔⵔⵉⵎⴻⵜ ⴱⴰⵏⴻⵏ-ⴷⴷ ⵉⵎⵓⵛⴰⵏ ⴰⵔⵙⴰⵏ, ⵉⵛⴻⵎⵍⴰⵍⴻⵏ, ⵅⴻⵏⵏⵉ ⴰⵇⴰ-ⵜⵜ ⴷ ⵉⵛⵜ ⵏ ⵜⴼⵓⵔⵉ ⵏ ⵜⴻⵍⵎⴻⵛⵜ, ⵏⴻⵜⵜⴰ ⴰⵇⴰ ⵉⵣⴷⴻⴳ. ");
INSERT INTO rift_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","ⵎⴰⵍⴰ ⵉⵡⴹⴰ ⵓⵛⵓⵡⵡⴰⴼ ⵏ ⵓⵣⴻⴵⵉⴼ ⵏ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ, ⴰⵇⴰ ⴷ ⴰⵇⴻⵛⵛⴰⵔ, ⵅⴻⵏⵏⵉ ⵏⴻⵜⵜⴰ ⴰⵇⴰ ⵉⵣⴷⵉⴳ. ");
INSERT INTO rift_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","ⵎⴰⵍⴰ ⵜⴰⵏⵢⴰⵔⵜ ⵏ ⵛⴰ ⵏ ⵢⵉⵊⵊ ⴰⴷ ⵜⴻⴷⵡⴻⵍ ⵜⴰⵍⴻⵇⵇⴰⵖⵜ, ⴰⵇⴰ ⵜⴰⵏⵢⴰⵔⵜ ⵏⵏⴻⵙ ⵜⵇⴻⵛⵛⴰⵔ ⵡⴰⵀⴰ, ⵏⴻⵜⵜⴰ ⴰⵇⴰ ⵉⵣⴷⵉⴳ. ");
INSERT INTO rift_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⴷⵉⵏ ⵉⵊⵊ ⵏ ⵓⴹⵓⵏ ⵉⵎⵍⴻⵍ ⵉⵔⵓⵃ ⵖⴰⵔ ⵜⴻⵣⵡⴻⵖ ⵅ ⵓⵣⴻⴵⵉⴼ ⴰⵇⴻⵛⵛⴰⵔ ⵏⵉⵖ ⵅ ⵜⴻⵏⵢⴰⵔⵜ ⵜⴰⵇⴻⵛⵛⴰⵔⵜ, ⴰⵇⴰ-ⵜ ⴷ ⵍⴱⴰⵔⵚ ⵏⵏⵉ ⴷⴷ-ⵉⴼⴼⵖⴻⵏ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏⵏⴻⵙ ⴰⵇⴻⵛⵛⴰⵔ ⵏⵉⵖ ⵅ ⵜⴻⵏⵢⴰⵔⵜ ⵏⵏⴻⵙ ⵜⴰⵇⴻⵛⵛⴰⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","ⵎⴰⵍⴰ ⵉⵥⵔⴰ ⵉ-ⵜ ⵓⴽⴻⵀⵀⴰⵏ ⵓⵛⴰ ⵉⵥⵔⴰ ⴰⵇⴰ ⴰⵄⴻⴱⴱⵓⵣ ⵏ ⵡⵓⴹⵓⵏ ⵉⵎⵍⴻⵍ, ⵉⵔⵓⵃ ⵖⴰⵔ ⵜⴻⵣⵡⴻⵖ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏⵏⴻⵙ ⴰⵇⴻⵛⵛⴰⵔ ⵏⵉⵖ ⵅ ⵜⴻⵏⵢⴰⵔⵜ ⵏⵏⴻⵙ ⵜⴰⵇⴻⵛⵛⴰⵔⵜ, ⵉⴱⴰⵏ-ⴷⴷ ⴰⵎ ⵍⴱⴰⵔⵚ ⵏ ⵜⴻⵍⵎⴻⵛⵜ ⵏ ⴰⵔⵔⵉⵎⴻⵜ, ");
INSERT INTO rift_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ⵅⴻⵏⵏⵉ ⴰⵇⴰ ⴰⵔⵢⴰⵣ ⴷ ⴱⵓ-ⵍⴱⴰⵔⵚ ⵉ ⵉⴵⴰ, ⵏⴻⵜⵜⴰ ⴰⵇⴰ ⵉⵅⵎⴻⵊ. ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵜ ⵉⴱⴰⵔⵔⴻⵃ ⴷ ⴰⵎⴻⵅⵎⵓⵊ, ⵓⴹⵓⵏ ⴰⵇⴰ-ⵜ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏⵏⴻⵙ.” ");
INSERT INTO rift_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵉⵜⵜⵡⴰⵛⴰⵔⵔⴻⴳ ⵡⴰⵔⵔⵓⴹ ⵏ ⴱⵓ-ⵍⴱⴰⵔⵚ ⵉ ⴷⵉ ⵉⴵⴰ ⵡⵓⴹⵓⵏ ⵓⵛⴰ ⴰⴷ ⵉⴹⵍⴻⵇ ⵉ ⵓⵛⵓⵡⵡⴰⴼ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏⵏⴻⵙ, ⴰⴷ ⵉⵍⴻⵃⵃⴻⴼ ⴰⵛⵍⴰⵖⴻⵎ ⵖⴰⵔ ⵓⵢⴻⵏⵛⵉⵛ, ⴰⴷ ⵉⵍⴰⵖⴰ: ‘ⴰⵎⴻⵅⵎⵓⵊ! ⴰⵎⴻⵅⵎⵓⵊ!’ ");
INSERT INTO rift_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","ⵎⴰⵔⵔⴰ ⵓⵙⵙⴰⵏ ⵉ ⴷⴰⵢⴻⵙ ⵉ ⵖⴰ ⵢⵉⵍⵉ ⵡⵓⴹⵓⵏ, ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ. ⵏⴻⵜⵜⴰ ⴷ ⴰⵎⴻⵅⵎⵓⵊ. ⵏⴻⵜⵜⴰ ⴰⴷ ⵉⵣⴷⴻⵖ ⵡⴻⵃⵃⴷⴻⵙ ⵓⵛⴰ ⵜⵣⴻⴷⴷⵉⵖⵜ ⵏⵏⴻⵙ ⴰⴷ ⵜⵉⵍⵉ ⴱⴰⵔⵔⴰ ⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ.” ");
INSERT INTO rift_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“ⵎⴰⵍⴰ ⵓⴹⵓⵏ ⵏ ⵍⴱⴰⵔⵚ ⴷⴻⴳ ⵉⵊⵊ ⵏ ⵡⴰⵔⵔⵓⴹ, ⴷⴻⴳ ⵉⵊⵊ ⵏ ⵡⴰⵔⵔⵓⴹ ⵏ ⵜⴰⴹⵓⴼⵜ ⵏⵉⵖ ⴷⴻⴳ ⵉⵊⵊ ⵏ ⵡⴰⵔⵔⵓⴹ ⵏ ⵍⴻⵇⵟⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ⵏⵉⵖ ⴷⴻⴳ ⵡⴻⵛⴹⴰⴹ ⵉⵅⴻⵢⵢⴹⴻⵏ ⵏⵉⵖ ⴷⴻⴳ ⵓⴼⵉⵍⵓ ⵉⵎⵎⵓⴷⴻⵏ, ⵏⵉⵖ ⵏ ⵍⴻⵇⵟⴻⵏ ⵏⵉⵖ ⵏ ⵜⴰⴹⵓⴼⵜ, ⵏⵉⵖ ⵖⴰⵔ ⵢⵉⵍⴻⵎ, ⵏⵉⵖ ⵖⴰⵔ ⵎⴰⵎⵎⴻⵛ ⵎⴰ ⵍⵇⴻⵛⵄⴻⵜ ⵏ ⵢⵉⵍⴻⵎ, ");
INSERT INTO rift_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","ⵓ ⵜⵉⵛⵜⵉ ⵉⵜⵜⵡⴰⵡⵜⴻⵏ ⴷⴻⴳ ⵡⴰⵔⵔⵓⴹ ⵏⵉⵖ ⴷⴻⴳ ⵢⵉⵍⴻⵎ, ⵏⵉⵖ ⵖⴰⵔ ⵡⴻⵛⴹⴰⴹ ⵉⵅⴻⵢⵢⴹⴻⵏ ⵏⵉⵖ ⵖⴰⵔ ⵓⴼⵉⵍⵓ ⵉⵎⵎⵓⴷⴻⵏ, ⵏⵉⵖ ⴷⵉ ⵎⴰⵎⵎⴻⵛ ⵎⴰ ⵏ ⵍⵇⴻⵛⵄⴻⵜ ⵏⵏⵉ ⵜⵜⴻⴳⴳⴻⵏ ⵙ ⵢⵉⵍⴻⵎ, ⵜⴻⵣⵣⵉⵣⵓ ⵏⵉⵖ ⵜⴻⵣⵡⴻⵖ, ⴰⵇⴰ-ⵜ ⴷ ⵓⴹⵓⵏ ⵏ ⵍⴱⴰⵔⵚ. ⴰⴷ ⵉⵜⵜⵡⴰⵙⵙⵛⴻⵏ ⴰⵢⴰ ⵉ ⵓⴽⴻⵀⵀⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵉⵅⵣⴰⵔ ⵖⴰⵔ ⵡⴻⵎⵛⴰⵏ ⵏ ⵓⴹⵓⵏ ⵓⵛⴰ ⵎⵉⵏ ⵉⴹⵏⴻⵏ ⴰⴷ ⵜ ⵉⴱⴻⵍⵍⴻⵄ ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ ⴰⴷ ⵉⵅⵣⴰⵔ ⵖⴰⵔ ⵡⵓⴹⵓⵏ. ⵎⴰⵍⴰ ⵉⵎⵖⴰⵔ ⵓⴹⵓⵏ ⴷⴻⴳ ⵡⴰⵔⵔⵓⴹ, ⵏⵉⵖ ⵖⴰⵔ ⵡⴻⵛⴹⴰⴹ ⵉⵅⴻⵢⵢⴹⴻⵏ ⵏⵉⵖ ⵖⴰⵔ ⵓⴼⵉⵍⵓ ⵉⵎⵎⵓⴷⴻⵏ, ⵏⵉⵖ ⴷⴻⴳ ⵢⵉⵍⴻⵎ ⵏ ⵎⴰⵎⵎⴻⵛ ⵎⴰ ⵍⵇⴻⵛⵄⴻⵜ ⵏⵏⵉ ⵜⵜⴻⴳⴳⴻⵏ ⵙ ⵢⵉⵍⴻⵎ, ⴰⵇⴰ ⵓⴹⵓⵏ ⴷ ⵍⴱⴰⵔⵙ ⵉⵇⴻⵙⵃⴻⵏ ⵉ ⵢⴻⴵⴰ, ⴰⵇⴰ ⵉⵅⵎⴻⵊ. ");
INSERT INTO rift_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","ⴰⴷ ⵉⵙⵙⴻⵛⵎⴻⴹ ⴰⵔⵔⵓⴹ ⵏⵉⵖ ⴰⴼⵉⵍⵓ ⴷ ⴰⵣⵉⵔⴰⵔ ⵏⵉⵖ ⴰⴼⵉⵍⵓ ⵉⵎⵎⵓⴷⴻⵏ, ⵏⵉⵖ ⵏ ⵜⴰⴹⵓⴼⵜ ⵏⵉⵖ ⵏ ⵍⴻⵇⵟⴻⵏ ⵉ ⵉⴵⴰ, ⵏⵉⵖ ⵎⴰⵎⵎⴻⵛ ⵎⴰ ⵍⵇⴻⵛⵄⴻⵜ ⵏⵏⵉ ⵜⵜⴻⴳⴳⴻⵏ ⵙ ⵢⵉⵍⴻⵎ ⵉ ⴷⴰⵢⴻⵙ ⵜⵓⵖⴰ ⵓⴹⵓⵏ, ⵎⵉⵏⵣⵉ ⴰⵇⴰ-ⵜ ⴷ ⵍⴱⴰⵔⵚ ⵉⵇⴻⵙⵃⴻⵏ. ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵉⵜⵜⵡⴰⵙⵙⴻⵛⵎⴻⴹ ⵙ ⵜⵎⴻⵙⵙⵉ. ");
INSERT INTO rift_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⵉⵥⵔⴰ ⵓⴽⴻⵀⵀⴰⵏ ⵎⴰⵏ ⴰⵢⴰ ⵓⵛⴰ ⴰⵇⴰ ⵓⴹⵓⵏ ⵡⴰⵔ ⵉⵎⵖⵉⵔ ⵛⴰ ⴷⴻⴳ ⵡⴰⵔⵔⵓⴹ, ⵏⵉⵖ ⴷⴻⴳ ⵡⴻⵛⴹⴰⴹ ⵉⵅⴻⵢⵢⴹⴻⵏ ⵏⵉⵖ ⴷⴻⴳ ⵓⴼⵉⵍⵓ ⵉⵎⵎⵓⴷⴻⵏ, ⵏⵉⵖ ⴷⵉ ⵎⴰⵎⵎⴻⵛ ⵎⴰ ⵍⵇⴻⵛⵄⴻⵜ ⵏⵏⵉ ⵜⵜⴻⴳⴳⴻⵏ ⵙ ⵢⵉⵍⴻⵎ, ");
INSERT INTO rift_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","ⵅⴻⵏⵏⵉ ⴰⴷ ⵢⵓⵎⵓⵔ ⵓⴽⴻⵀⵀⴰⵏ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵙⵙⵉⵔⴷⴻⵏ ⵎⵉⵏ ⴷⵉ ⵢⴻⴵⴰ ⵡⵓⴹⵓⵏ, ⵓⵛⴰ ⴰⵡⴰⵔⵏⵉ ⵉ ⵎⴰⵏ ⴰⵢⴰ ⴰⴷ ⵅⴰⵙ ⵉⴱⴻⵍⵍⴻⵄ ⵜⵡⴰⵍⴰ ⵏⵏⴻⵖⵏⵉ ⵍⵇⴻⴷⴷ ⵏ ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","ⵎⴰⵍⴰ ⵉⵥⵔⴰ ⵓⴽⴻⵀⵀⴰⵏ ⵓⴹⵓⵏ ⴰⵡⴰⵔⵏⵉ ⵉ ⵓⵙⵉⵔⴷ, ⵓⵛⴰ ⵉⵥⵔⴰ ⵓⴹⵓⵏ ⵡⴰⵔ ⵉⴱⴻⴷⴷⵉⵍ ⵛⴰ ⵓⵛⴰ ⵓⴹⵓⵏ ⵡⴰⵔ ⵉⵎⵖⵉⵔ, ⴰⵇⴰ ⴰⵔⵔⵓⴹ ⵏⵏⵉ ⵉⵅⵎⴻⵊ. ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜ ⵜⴻⵙⵙⴻⵛⵎⴻⴹⴻⴷ ⵙ ⵜⵎⴻⵙⵙⵉ. ⴰⵇⴰ ⵓⴹⵓⵏ ⵉⴷⵡⴻⵍ ⵢⵓⴵⴻⵖ ⵉⵜⵜᵉⵜⵜ ⵖⴰⵔ ⴹⴻⴼⴼⴰⵔ ⵏⵉⵖ ⵖⴰⵔ ⵣⵣⴰⵜ. ");
INSERT INTO rift_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⵉⵥⵔⴰ ⵓⴽⴻⵀⵀⴰⵏ ⵎⴰⵏ ⴰⵢⴰ ⵓⵛⴰ ⵉⵥⵔⴰ ⴱⴻⵍⵍⵉ ⵓⴹⵓⵏ ⵢⴰⵔⵙⴰ ⴰⵡⴰⵔⵏⵉ ⵉ ⵓⵙⵉⵔⴷ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜ ⵉⵇⴻⵙⵙ ⵣⴻⴳ ⵡⴰⵔⵔⵓⴹ, ⵏⵉⵖ ⵣⴻⴳ ⵢⵉⵍⴻⵎ, ⵏⵉⵖ ⵣⴻⴳ ⵡⴻⵛⴹⴰⴹ ⵉⵅⴻⵢⵢⴹⴻⵏ ⵏⵉⵖ ⵣⴻⴳ ⵓⴼⵉⵍⵓ ⵉⵎⵎⵓⴷⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⵉⴱⴰⵏ ⵡⵓⴹⵓⵏ ⵜⵡⴰⵍⴰ ⵏⵏⴻⵖⵏⵉ ⴷⴻⴳ ⵡⴰⵔⵔⵓⴹ, ⵏⵉⵖ ⵖⴰⵔ ⵡⴻⵛⴹⴰⴹ ⵉⵅⴻⵢⵢⴹⴻⵏ ⵏⵉⵖ ⵖⴰⵔ ⵓⴼⵉⵍⵓ ⵉⵎⵎⵓⴷⴻⵏ, ⵏⵉⵖ ⴷⵉ ⵎⴰⵎⵎⴻⵛ ⵎⴰ ⵍⵇⴻⵛⵄⴻⵜ ⵏⵏⵉ ⵜⵜⴻⴳⴳⴻⵏ ⵙ ⵢⵉⵍⴻⵎ, ⴰⵇⴰ ⵉⴷⴷⵓⵇⵇⴻⵣ ⵍⴱⴰⵔⵚ. ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜⴻⵙⵙⴻⵛⵎⴻⴹ ⵙ ⵜⵎⴻⵙⵙⵉ ⵎⵉⵏ ⴷⴰⵢⴻⵙ ⵉ ⵉⴵⴰⵏ ⵓⴹⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","ⴰⵔⵔⵓⴹ, ⵏⵉⵖ ⴰⴼⵉⵍⵓ ⴷ ⴰⵣⵉⵔⴰⵔ ⵏⵉⵖ ⴰⴼⵉⵍⵓ ⵉⵎⵎⵓⴷⴻⵏ ⵏⵉⵖ ⵎⴰⵎⵎⴻⵛ ⵎⴰ ⵍⵇⴻⵛⵄⴻⵜ ⵏⵏⵉ ⵜⵜⴻⴳⴳⴻⵏ ⵙ ⵢⵉⵍⴻⵎ, ⵡⴻⵏⵏⵉ ⵜⴻⵙⵙⵉⵔⴷⴻⴷ ⵓⵛⴰ ⵉⵔⵓⵃ ⵅⴰⵙ ⵡⵓⴹⵓⵏ, ⴰⴷ ⵜ ⵜⴻⵙⵙⵉⵔⴷⴻⴷ ⵜⵡⴰⵍⴰ ⵏⵏⴻⵖⵏⵉ ⵓⵛⴰ ⵅⴻⵏⵏⵉ ⴰⴷ ⵢⵉⵍⵉ ⵉⵣⴷⵉⴳ.” ");
INSERT INTO rift_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","ⵡⴰ ⴷ ⴰⵣⴻⵔⴼ ⵏ ⵡⵓⴹⵓⵏ ⵏ ⵍⴱⴰⵔⵚ ⵏ ⵡⴰⵔⵔⵓⴹ ⵏ ⵜⴰⴹⵓⴼⵜ ⵏⵉⵖ ⵏ ⵍⴻⵇⵟⴻⵏ, ⵏⵉⵖ ⵏ ⵡⴻⵛⴹⴰⴹ ⵉⵅⴻⵢⵢⴹⴻⵏ ⵏⵉⵖ ⵏ ⵓⴼⵉⵍⵓ ⵉⵎⵎⵓⴷⴻⵏ, ⵏⵉⵖ ⵏ ⵎⴰⵎⵎⴻⵛ ⵎⴰ ⵍⵇⴻⵛⵄⴻⵜ ⵏⵏⵉ ⵜⵜⴻⴳⴳⴻⵏ ⵙ ⵢⵉⵍⴻⵎ, ⵎⴰⵃⴻⵏⴷ ⵅⴻⵏⵏⵉ ⴰⴷ ⴱⴰⵔⵔⵃⴻⵏ ⵙ ⵜⴻⵣⴷⴻⴳ ⵏⵏⴻⵙ ⵏⵉⵖ ⵙ ⵍⴻⵅⵎⴻⵊ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“ⵡⴰ ⴷ ⴰⵣⴻⵔⴼ ⵏ ⴱⵓ-ⵍⴱⴰⵔⵚ ⵉ ⵡⴰⵙⵙ ⵏ ⵓⵙⵉⵣⴷⴻⴳ ⵏⵏⴻⵙ. ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜ ⵏⴻⴷⵀⴻⵏ ⵖⴰⵔ ⵓⴽⴻⵀⵀⴰⵏ, ");
INSERT INTO rift_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","ⵓⵛⴰ ⴰⴷ ⵉⴼⴼⴻⵖ ⵓⴽⴻⵀⵀⴰⵏ ⵖⴰⵔ ⴱⴰⵔⵔⴰ ⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ. ⵅⵎⵉ ⵖⴰⵔⴻⵙ ⵉ ⵖⴰ ⵉⵅⵣⴰⵔ ⵓⴽⴻⵀⵀⴰⵏ ⵓⵛⴰ ⵉⵥⵔⴰ ⴰⵇⴰ ⵉⴳⴳⴻⵏⴼⴰ ⵡⵓⴹⵓⵏ ⵏ ⵍⴱⴰⵔⵚ ⵏ ⴱⵓ-ⵍⴱⴰⵔⵚ, ");
INSERT INTO rift_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","ⴰⴷ ⵢⵓⵎⵓⵔ ⵓⴽⴻⵀⵀⴰⵏ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴽⵙⵉⵏ ⵉ ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵉⵜⵜⵡⴰⵙⵙⵉⵣⴻⴷⴳⴻⵏ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵊⴹⴰⴹ ⵉⴷⴷⴰⵔⴻⵏ ⵉⵣⴷⵉⴳⴻⵏ, ⵓⵍⴰ ⴷ ⴰⴽⴻⵛⵛⵓⴹ ⵏ ⵜⵛⴻⵊⵊⴰⵔⵜ ⵏ ⵜⴻⵏⴳⴻⵍⵜ, ⴷ ⵓⵣⴻⴳⴳⵯⴰⵖ ⵉⵃⴻⴷⵇⴻⵏ, ⴷ ⵜⵄⴻⵍⴵⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","ⴰⴷ ⵢⵓⵎⵓⵔ ⵓⴽⴻⵀⵀⴰⵏ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵖⴰⵔⵚⴻⵏ ⵉ ⵢⵉⵊⵊ ⵏ ⵡⴻⵊⴹⵉⴹ ⴷⴻⴳ ⵉⵛⵜ ⵏ ⵍⵇⴻⵛⵄⴻⵜ ⵏ ⵜⵍⴰⵅⵜ, ⵙⴻⵏⵏⴻⵊ ⵉ ⵡⴰⵎⴰⵏ ⵉⵜⵜⴰⵣⵣⵍⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⴽⵙⵉ ⴰⵊⴹⵉⴹ ⵉⴷⴷⴰⵔⴻⵏ ⴷ ⵓⴽⴻⵛⵛⵓⴹ ⵏ ⵜⵛⴻⵊⵊⴰⵔⵜ ⵏ ⵜⴻⵏⴳⴻⵍⵜ ⴷ ⵓⵣⴻⴳⴳⵯⴰⵖ ⵉⵃⴻⴷⵇⴻⵏ ⴷ ⵜⵄⴻⵍⴵⴻⵜ ⵓⵛⴰ ⴰⴷ ⵜⴻⵏ ⵉⵙⵙⵓⴼ ⴰⴽ-ⴷ ⵡⴻⵊⴹⵉⴹ ⵉⴷⴷⴰⵔⴻⵏ ⴷⴻⴳ ⵉⴷⴰⵎⵎⴻⵏ ⵏ ⵡⴻⵊⴹⵉⴹ ⵉ ⵉⵜⵜⵡⴰⵖⴰⵔⵚⴻⵏ ⵙⴻⵏⵏⴻⵊ ⵉ ⵡⴰⵎⴰⵏ ⵉⵜⵜⴰⵣⵣⵍⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","ⴰⴷ ⵉⵔⵓⵛⵛ ⵙⴻⴱⵄⴰ ⵏ ⵜⵡⴰⵍⴰⵡⵉⵏ ⵅ ⵡⴻⵏⵏⵉ ⵉⵜⵜⵡⴰⵙⵙⵉⵣⴻⴷⴳⴻⵏ ⵣⵉ ⵍⴱⴰⵔⵚ. ⵅⴻⵏⵏⵉ ⴰⴷ ⵜ ⵉⴱⴰⵔⵔⴻⵃ ⴷ ⴰⵎⴻⵣⴷⴰⴳ ⵓⵛⴰ ⴰⴷ ⵢⴰⵔⵅⵓ ⵉ ⵡⴻⵊⴹⵉⴹ ⵉⴷⴷⴰⵔⴻⵏ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⴹⴻⵡ ⵙⴻⵏⵏⴻⵊ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵢⴻⵢⵢⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","ⵓⵛⴰ ⵡⴻⵏⵏⵉ ⵉⵜⵜⵡⴰⵙⵙⵉⵣⴻⴷⴳⴻⵏ ⴰⴷ ⵉⵚⴻⴱⴱⴻⵏ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⵉⵃⴻⴼⴼ ⵎⴰⵔⵔⴰ ⴰⵛⵓⵡⵡⴰⴼ ⵏⵏⴻⵙ, ⴰⴷ ⵉⵙⵙⵉⵔⴷ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵙ ⵡⴰⵎⴰⵏ. ⵅⴻⵏⵏⵉ ⴰⴷ ⵢⵉⵍⵉ ⵉⵣⴷⴻⴳ. ⴰⵡⴰⵔⵏⵉ ⴰⵙ ⴰⴷ ⵢⴰⴷⴻⴼ ⵖⴰⵔ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵓⵛⴰ ⴰⴷ ⵉⵣⴷⴻⵖ ⴱⴰⵔⵔⴰ ⵉ ⵓⵇⵉⴹⵓⵏ ⵏⵏⴻⵙ ⵄⴰⴷ ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ ⴰⴷ ⵉⵃⴻⴼⴼ ⵎⴰⵔⵔⴰ ⴰⵛⵓⵡⵡⴰⴼ ⵏ ⵓⵣⴻⴵⵉⴼ ⵏⵏⴻⵙ ⴷ ⵜⵎⴰⵔⵜ ⵏⵏⴻⵙ ⴷ ⵜⴻⵎⵎⵉⵡⵉⵏ ⵏ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵙ, ⵡⴰⵀ, ⴰⴷ ⵉⵃⴻⴼⴼ ⵎⴰⵔⵔⴰ ⴰⵛⵓⵡⵡⴰⴼ ⵏⵏⴻⵙ, ⴰⴷ ⵉⵚⴻⴱⴱⴻⵏ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⵉⵙⵙⵉⵔⴷ ⴰⵔⵔⵉⵎⴻⵜ ⵏⵏⴻⵙ ⵙ ⵡⴰⵎⴰⵏ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵢⵉⵍⵉ ⵉⵣⴷⴻⴳ. ");
INSERT INTO rift_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵜⵎⴻⵏⵢⴰ ⴰⴷ ⵉⴽⵙⵉ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵣⵎⴰⵔⴻⵏ ⴽⴻⵎⵎⵍⴻⵏ ⴷ ⵉⵛⵜⴻⵏ ⵜⴻⵅⵙⵉ ⵉⵛⵏⴰⵏ ⵇⴰⵄ ⵏ ⵉⵊⵊⴻⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ ⴰⴽ-ⴷ ⵜⵍⴰⵜⴰ ⵣⵉ ⵄⴻⵛⵔⴰ ⵏ ⵉⵊⵊⴻⵏ ⵉⴼⴰ ⵏ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⴰⵎ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵉⵅⴻⴵⴹⴻⵏ ⵙ ⵣⵣⴻⵛⵜ, ⵓ ⵄⴰⵡⴻⴷ ⵉⵊⵊⴻⵏ ⵓⵍⵓⵅ ⵏ ⵣⵣⴻⵛⵜ. ");
INSERT INTO rift_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","ⴰⴽⴻⵀⵀⴰⵏ, ⵡⴻⵏⵏⵉ ⵜ ⵉⵙⵙⵉⵣⴻⴷⴳⴻⵏ, ⴰⴷ ⵢⴰⵔⵔ ⴰⵔⵢⴰⵣ ⵏⵏⵉ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵉⵜⵜⵡⴰⵙⵙⵉⵣⴷⴻⴳ, ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⴰⵢⴰ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","ⴰⴷ ⵉⴽⵙⵉ ⵓⴽⴻⵀⵀⴰⵏ ⵉⵣⵎⴰⵔ ⵏⵏⵉ ⵓⵛⴰ ⴰⴷ ⵜ-ⵉ-ⴷⴷ-ⵉⵙⵙⵇⴰⵔⵔⴻⴱ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⵓⵎⴰⵔⵡⴰⵙ ⴰⴽ-ⴷ ⵓⵍⵓⵅ ⵏ ⵣⵣⴻⵛⵜ, ⵓⵛⴰ ⴰⴷ ⵜ ⵉⵙⵙⴻⵏⵀⴻⵣⵣ ⴰⵎ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵡⴻⵏⵀⴻⵣⵣⵉ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⵖⴰⵔⵚ ⵉ ⵢⴻⵣⵎⴰⵔ ⵏⵏⵉ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵎⴰⵏⵉ ⵖⴰⵔⵔⵚⴻⵏ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⴷ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ, ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⴰⵎⵇⴻⴷⴷⴰⵙ. ⵎⵉⵏⵣⵉ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵓⵎⴰⵔⵡⴰⵙ, ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ, ⵉ ⵓⴽⴻⵀⵀⴰⵏ ⵉ ⵜⴻⴵⴰ, ⴰⵇⴰ-ⵜⵜ ⴷ ⵜⴰⵎⵇⴻⴷⴷⴰⵙⵜ ⵇⴰⵄ. ");
INSERT INTO rift_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","ⴰⴷ ⵉⴽⵙⵉ ⵓⴽⴻⵀⵀⴰⵏ ⵛⵡⴰⵢⵜ ⵣⴻⴳ ⵉⴷⴰⵎⵎⴻⵏ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵓⵎⴰⵔⵡⴰⵙ ⵓⵛⴰ ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵜⴻⵏ ⵉⴳⴳ ⵅ ⵉⵖⴻⵙ ⵏ ⵓⵎⴻⵣⵣⵓⵖ ⴰⴼⵓⵙⵉ ⵏ ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵉⵜⵜⵡⴰⵙⵙⵉⵣⴻⴷⴳⴻⵏ ⵓⵍⴰ ⵅ ⵢⵉⵎⴻⵣ ⵏ ⵓⴼⵓⵙ ⵏⵏⴻⵙ ⴰⴼⵓⵙⵉ ⵓ ⵅ ⵢⵉⵎⴻⵣ ⵏ ⵓⴹⴰⵔ ⵏⵏⴻⵙ ⴰⴼⵓⵙⵉ. ");
INSERT INTO rift_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","ⴰⵎⴻⵏⵏⵉ ⵉ ⵖⴰ ⵉⴽⵙⵉ ⵓⴽⴻⵀⵀⴰⵏ ⵛⴰ ⵣⴻⴳ ⵓⵍⵓⵅ ⵏ ⵣⵣⴻⵛⵜ ⵓⵛⴰ ⴰⴷ ⵜⵜ ⵉⵏⵖⴻⵍ ⵅ ⵜⵍⴻⵇⵇⴰ ⵏ ⵓⴼⵓⵙ ⵏⵏⴻⵙ ⴰⵣⴻⵍⵎⴰⴹ. ");
INSERT INTO rift_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","ⴰⴷ ⵉⵙⵙⵓⴼ ⵓⴽⴻⵀⵀⴰⵏ ⴰⴹⴰⴹ ⵏⵏⴻⵙ ⴰⴼⵓⵙⵉ ⵙ ⵣⵣⴻⵛⵜ ⵏⵏⵉ ⵖⴰⵔⴻⵙ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏⵏⴻⵙ ⴰⵣⴻⵍⵎⴰⴹ ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵉⵔⵓⵛⵛ ⵙ ⵓⴹⴰⴹ ⵏⵏⴻⵙ ⵛⵡⴰⵢⵜ ⵣⵉ ⵣⵣⴻⵛⵜ ⵙⴻⴱⵄⴰ ⵏ ⵜⵡⴰⵍⴰⵡⵉⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","ⵓⵛⴰ ⵎⵉⵏ ⵉⵇⵇⵉⵎⴻⵏ ⵣⵉ ⵣⵣⴻⵛⵜ ⵏⵏⵉ ⵖⴰⵔⴻⵙ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏⵏⴻⵙ, ⴰⴷ ⵜⵜ ⵉⴳⴳ ⵓⴽⴻⵀⵀⴰⵏ ⵅ ⵉⵖⴻⵙ ⵏ ⵓⵎⴻⵣⵣⵓⵖ ⴰⴼⵓⵙⵉ ⵏ ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵉⵜⵜⵡⴰⵙⵙⵉⵣⴻⴷⴳⴻⵏ, ⵓⵍⴰ ⵅ ⵢⵉⵎⴻⵣ ⵏ ⵓⴼⵓⵙ ⵏⵏⴻⵙ ⴰⴼⵓⵙⵉ ⵓ ⵅ ⵢⵉⵎⴻⵣ ⵏ ⵓⴹⴰⵔ ⵏⵏⴻⵙ ⴰⴼⵓⵙⵉ, ⵜⵉⵡⴰ ⵏ ⵉⴷⴰⵎⵎⴻⵏ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵓⵎⴰⵔⵡⴰⵙ ⵉ ⵅⴰⵙⴻⵏ ⵉⴳⴳⴰ ⵇⴱⴻⵍ. ");
INSERT INTO rift_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","ⵎⵉⵏ ⵉⵇⵇⵉⵎⴻⵏ ⵏ ⵣⵣⴻⵛⵜ ⵏⵏⵉ ⵉⴵⴰⵏ ⵖⴰⵔ ⵓⴽⴻⵀⵀⴰⵏ ⴷⵉ ⵜⵍⴻⵇⵇⴰ ⵏ ⵓⴼⵓⵙ ⵏⵏⴻⵙ, ⴰⴷ ⵜ ⵉⵏⵖⴻⵍ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏ ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵉⵜⵜⵡⴰⵙⵙⵉⵣⴻⴷⴳⴻⵏ ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⵜ ⵖⴰ ⵉⵙⵙⴻⵚⵍⴻⵃ ⵓⴽⴻⵀⵀⴰⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","ⴰⴷ ⵉⵙⵙⴻⵡⵊⴻⴷ ⵓⴽⴻⵀⵀⴰⵏ ⵅⴻⵏⵏⵉ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⵓⵛⴰ ⴰⴷ ⵉⵙⵙⴻⵚⵍⴻⵃ ⵡⴻⵏⵏⵉ ⵉⵜⵜⵡⴰⵙⵙⵉⵣⴻⴷⴳⴻⵏ ⵣⵉ ⵍⴻⵅⵎⴻⵊ ⵏⵏⴻⵙ. ⴰⵡⴰⵔⵏⵉ ⴰⵙ ⴰⴷ ⵉⵖⴰⵔⵚ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ. ");
INSERT INTO rift_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","ⴰⴷ ⵉⵙⵙⴱⴻⵅⵅⴰⵔ ⵓⴽⴻⵀⵀⴰⵏ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵅ ⵓⵄⴰⵍⵟⴰⵔ. ⴰⵎⵎⵓ ⵉ ⵜ ⵖⴰ ⵉⵙⵙⴻⵚⵍⴻⵃ ⵓⴽⴻⵀⵀⴰⵏ ⵓⵛⴰ ⴰⴷ ⵢⵉⵍⵉ ⵉⵣⴷⴻⴳ. ");
INSERT INTO rift_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","ⵎⴰⵍⴰ ⵏⴻⵜⵜⴰ ⵉⵥⵍⴻⴹ ⵓⵛⴰ ⴰⴼⵓⵙ ⵏⵏⴻⵙ ⵡⴰⵔ ⵜ ⵉⵙⵙⵉⵡⴻⴹ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⴽⵙⵉ ⵉⵊⵊ ⵏ ⵢⵉⵣⵎⴰⵔ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⵓⵎⴰⵔⵡⴰⵙ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵅⴰⵙ ⵉⴳⴳ ⴰⵚⵍⴰⵃ ⴰⵎ ⵉⴳⴳⴰ ⵉⵣⵎⴰⵔ ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵡⴻⵏⵀⴻⵣⵣⵉ. ⴰⴷ ⵉⴽⵙⵉ ⵍⴰ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵄⵛⴰⵔⵜ ⵏ ⵉⵊⵊ ⵏ ⵉⴼⴰ ⵏ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵅⴻⴵⴹⴻⵏ ⵙ ⵣⵣⴻⵛⵜ ⴰⵎ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ, ⵓⵍⴰ ⴷ ⵉⵊⵊ ⵏ ⵓⵍⵓⵅ ⵏ ⵣⵣⴻⵛⵜ ");
INSERT INTO rift_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵊⵍⵉⵍⵍⵉⵃⵉⵏ ⵏⵉⵖ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⴷⴱⵉⵔⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⵉⵏ, ⴰⵏⴻⵛⵜ ⵉⵣⴻⵎⵎⴰⵔ ⵓⴼⵓⵙ ⵏⵏⴻⵙ ⴰⴷ ⵉⵙⵙⵉⵡⴻⴹ. ⵉⵛⵜ ⴰⴷ ⵜⵉⵍⵉ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⵓ ⵜⴻⵏⵏⴻⵖⵏⵉ ⴰⴷ ⵜⵉⵍⵉ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ. ");
INSERT INTO rift_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵜⵎⴻⵏⵢⴰ ⴰⴷ ⵜⴻⵏ ⵢⴰⵡⵉ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏ ⵓⵙⵉⵣⴷⴻⴳ ⵏⵏⴻⵙ ⵖⴰⵔ ⵓⴽⴻⵀⵀⴰⵏ, ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","ⴰⴷ ⵉⴽⵙⵉ ⵓⴽⴻⵀⵀⴰⵏ ⵉⵣⵎⴰⵔ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵓⵎⴰⵔⵡⴰⵙ ⴷ ⵓⵍⵓⵅ ⵏⵏⵉ ⵏ ⵣⵣⴻⵛⵜ ⵓⵛⴰ ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵜⴻⵏ ⵉⵙⵙⴻⵏⵀⴻⵣⵣ ⴰⵎ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵡⴻⵏⵀⴻⵣⵣⵉ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⵖⴰⵔⵚ ⵉ ⵉⵣⵎⴰⵔ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵓⵎⴰⵔⵡⴰⵙ ⵓⵛⴰ ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵉⴽⵙⵉ ⵛⵡⴰⵢⵜ ⵣⴻⴳ ⵉⴷⴰⵎⵎⴻⵏ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵓⵎⴰⵔⵡⴰⵙ, ⴰⴷ ⵜⴻⵏ ⵢⴰⵔⵔ ⵅ ⵉⵖⴻⵙ ⵏ ⵓⵎⴻⵣⵣⵓⵖ ⴰⴼⵓⵙⵉ ⵏ ⵡⴻⵏⵏⵉ ⵉⵜⵜⵡⴰⵙⵙⵉⵣⴻⴷⴳⴻⵏ ⵓⵍⴰ ⵅ ⵢⵉⵎⴻⵣ ⵏ ⵓⴼⵓⵙ ⵏⵏⴻⵙ ⴰⴼⵓⵙⵉ ⵓ ⵅ ⵢⵉⵎⴻⵣ ⵏ ⵓⴹⴰⵔ ⵏⵏⴻⵙ ⴰⴼⵓⵙⵉ. ");
INSERT INTO rift_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","ⴰⴷ ⵉⴼⴰⵔⵔⴻⵖ ⵓⴽⴻⵀⵀⴰⵏ ⵛⴰ ⵏ ⵣⵣⴻⵛⵜ ⵅ ⵜⵍⴻⵇⵇⴰ ⵏ ⵓⴼⵓⵙ ⴰⵥⴻⵍⵎⴰⴹ ⵏ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","ⵙ ⵓⴹⴰⴹ ⵏⵏⴻⵙ ⴰⴼⵓⵙⵉ ⴰⴷ ⵉⵔⵓⵛⵛ ⵓⴽⴻⵀⵀⴰⵏ ⵙ ⵣⵣⴻⵛⵜ ⵏⵏⵉ ⵖⴰⵔⴻⵙ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏⵏⴻⵙ ⴰⵥⴻⵍⵎⴰⴹ ⵙⴻⴱⵄⴰ ⵏ ⵜⵡⴰⵍⴰⵡⵉⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵉⴳⴳ ⵛⵡⴰⵢⵜ ⵣⵉ ⵣⵣⴻⵛⵜ ⵏⵏⵉ ⵖⴰⵔⴻⵙ ⵉⴵⴰⵏ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏⵏⴻⵙ ⵅ ⵉⵖⴻⵙ ⵏ ⵓⵎⴻⵣⵣⵓⵖ ⴰⴼⵓⵙⵉ ⵏ ⵡⴻⵏⵏⵉ ⵉⵜⵜⵡⴰⵙⵙⵉⵣⴻⴷⴳⴻⵏ ⵓⵍⴰ ⵅ ⵢⵉⵎⴻⵣ ⵏ ⵓⴼⵓⵙ ⵏⵏⴻⵙ ⴰⴼⵓⵙⵉ ⵓ ⵅ ⵢⵉⵎⴻⵣ ⵏ ⵓⴹⴰⵔ ⵏⵏⴻⵙ ⴰⴼⵓⵙⵉ, ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏⵏⵉⵜ ⵎⴰⵏⵉ ⵜⵜⵡⴰⴳⴳⴻⵏ ⵉⴷⴰⵎⵎⴻⵏ ⵏ ⵜⵖⴰⵔⵚⵟ ⵏ ⵓⵎⴰⵔⵡⴰⵙ ⵇⴱⴻⵍ. ");
INSERT INTO rift_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","ⵎⵉⵏ ⵉⵇⵇⵉⵎⴻⵏ ⵣⵉ ⵣⵣⴻⵛⵜ ⵏⵏⵉ ⵖⴰⵔ ⵓⴽⴻⵀⵀⴰⵏ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏⵏⴻⵙ, ⴰⴷ ⵜ ⵉⴳⴳ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏ ⵡⴻⵏⵏⵉ ⵉⵜⵜⵡⴰⵙⵙⵉⵣⴻⴷⴳⴻⵏ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵅⴰⵙ ⵉⴳⴳ ⴰⵚⵍⴰⵃ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⵙⵙⴻⵡⵊⴻⴷ ⵉⵊⵊ ⵣⵉ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵊⵍⵉⵍⵍⵉⵃⵉⵏ ⵏⵉⵖ ⵣⴻⴳ ⵉⴷⴱⵉⵔⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⴻⵏ, ⴰⵏⴻⵛⵜ ⵓⵎⵉ ⵉⵣⴻⵎⵎⴰⵔ ⵓⴼⵓⵙ ⵏⵏⴻⵙ ⴰⴷ ⵉⵙⵙⵉⵡⴻⴹ. ");
INSERT INTO rift_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","ⵣⵉ ⵎⵉⵏ ⴷ ⴰⵙ ⵖⴰ ⵉⵙⵙⵉⵡⴻⴹ ⵓⴼⵓⵙ ⵏⵏⴻⵙ, ⴰⴷ ⵢⵉⵍⵉ ⵉⵊⵊ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⵓ ⵡⴻⵏⵏⴻⵖⵏⵉ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ, ⵙⴻⵏⵏⴻⵊ ⵉ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ. ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵉⴳⴳ ⴰⵚⵍⴰⵃ ⵅ ⵡⴻⵏⵏⵉ ⵉⵜⵜⵡⴰⵙⵙⵉⵣⴻⴷⴳⴻⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","ⵡⴰ ⴷ ⴰⵣⴻⵔⴼ ⵉ ⵡⴻⵏⵏⵉ ⴷⵉ ⵉⴵⴰ ⵡⵓⴹⵓⵏ ⵏ ⵍⴱⴰⵔⵚ ⵓⵛⴰ ⴰⴼⵓⵙ ⵏⵏⴻⵙ ⵡⴰⵔ ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵉⵙⵙⵉⵡⴻⴹ ⵉ ⵓⵙⵉⵣⴷⴻⴳ ⵏⵏⴻⵙ.” ");
INSERT INTO rift_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“ⵅⵎⵉ ⵖⴰ ⵜⴰⴷⴼⴻⵎ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ, ⵜⴻⵏⵏⵉ ⴷ ⴰⵡⴻⵎ ⵖⴰ ⵡⵛⴻⵖ ⴷ ⴰⴳⵍⴰ, ⵓⵛⴰ ⵎⴰⵍⴰ ⴳⴳⵉⵖ ⵏⴻⵛⵛ ⵓⴹⵓⵏ ⵏ ⵍⴱⴰⵔⵚ ⵅ ⵛⴰ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⵉ ⵖⴰⵔⵡⴻⵎ ⴷ ⴰⴳⵍⴰ, ");
INSERT INTO rift_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ⴰⴷ ⴷⴷ-ⵢⴰⵙ ⵅⴻⵏⵏⵉ ⵡⴻⵏⵏⵉ ⵖⴰⵔ ⵜⴻⴵⴰ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⵉ, ⴰⴷ ⵉⵅⴻⴱⴱⴰⵔ ⴰⴽⴻⵀⵀⴰⵏ, ⴰⴷ ⵢⵉⵏⵉ: ‘ⵉⵜⵜⵖⵉⵍ ⴰⵢⵉ-ⴷⴷ ⴰⵅⵎⵉ ⴷⵉⵏ ⵛⴰ ⵏ ⵡⵓⴹⵓⵏ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ.’ ");
INSERT INTO rift_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","ⵅⴻⵏⵏⵉ ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵉⵙⵙⴻⴽⴽ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵙⵙⴻⵅⵡⴰⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵇⴱⴻⵍ ⵉ ⴷⴷ ⵖⴰ ⵢⴰⵙ ⵓⴽⴻⵀⵀⴰⵏ ⵙ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵙ, ⵃⵉⵎⴰ ⴰⴷ ⵉⵅⴻⵎⵎ ⵓⴹⵓⵏ, ⵃⵉⵎⴰ ⵡⴰⵔ ⵉⵜⵜⵡⴰⵙⵙⴻⵅⵎⵉⵊ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⴵⴰⵏ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ. ⴰⵡⴰⵔⵏⵉ ⴰⵙ ⴰⴷ ⴷⴷ-ⵢⴰⵙ ⵓⴽⴻⵀⵀⴰⵏ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⵅⴻⵎⵎⴻⵎ ⵜⴰⴷⴷⴰⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","ⵎⴰⵍⴰ ⵉⵅⵣⴰⵔ ⵖⴰⵔ ⵓⴹⵓⵏ ⵓⵛⴰ ⵉⵥⵔⴰ ⴰⵇⴰ ⵓⴹⵓⵏ ⵏ ⵍⴻⵃⵢⵓⴹ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⴱⴰⵏⴻⵏ-ⴷⴷ ⴷⴰⵢⴻⵙ ⵉⵃⵓⴼⴰⵔ ⵣⵣⵉⵣⵡⴻⵏ ⵏⵉⵖ ⵣⴻⵡⵖⴻⵏ, ⵓⴵⵖⴻⵏ ⵅ ⵡⵓⴷⴻⵎ ⵏ ⵍⵃⵉⴹ, ");
INSERT INTO rift_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⴼⴼⴻⵖ ⵓⴽⴻⵀⵀⴰⵏ ⵣⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⵉ ⵣⵉ ⵡⴰⴷⴰⴼ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵓⵛⴰ ⴰⴷ ⵉⵇⵇⴻⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ ⴰⴷ ⴷⴷ-ⵉⴷⵡⴻⵍ ⵓⴽⴻⵀⵀⴰⵏ ⵓⵛⴰ ⵎⴰⵍⴰ ⵉⵥⵔⴰ ⴰⵇⴰ ⵓⴹⵓⵏ ⵉⴱⴻⵣⵣⴻⵄ ⵅ ⵍⴻⵃⵢⵓⴹ ⵏ ⵜⴰⴷⴷⴰⵔⵜ, ");
INSERT INTO rift_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⵡⴻⵚⵚⴰ ⵓⴽⴻⵀⵀⴰⵏ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴽⴽⵙⴻⵏ ⵉⵥⵔⴰ ⵎⴰⵏⵉ ⵉⵍⵙⴻⵇ ⵡⵓⴹⵓⵏ ⵓ ⴰⴷ ⵜⴻⵏ ⵏⴹⴰⵔⴻⵏ ⴷⴻⴳ ⵉⵊⵊ ⵏ ⵡⴻⵎⵛⴰⵏ ⵉⵅⴻⵎⵊⴻⵏ ⴱⴰⵔⵔⴰ ⵉ ⵜⴻⵏⴷⵉⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","ⴰⴷ ⵢⴻⵊⵊ ⴰⴷ ⵇⴻⵛⵛⴰⵔⴻⵏ ⴷⴰⵅⴻⵍ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵖⴰⵔ ⵎⴰⵔⵔⴰ ⵉⵖⴻⵣⴷⵉⵙⴻⵏ ⵏⵏⴻⵙ, ⵓⵛⴰ ⴰⴷ ⵣⴻⴵⵄⴻⵏ ⴰⴱⴻⴵⴰⵄ ⵉ ⵇⴻⵛⵛⴰⵔⴻⵏ ⴱⴰⵔⵔⴰ ⵉ ⵜⴻⵏⴷⵉⵏⵜ ⴷⴻⴳ ⵉⵊⵊ ⵏ ⵡⴻⵎⵛⴰⵏ ⴷ ⴰⵎⴻⵅⵎⵓⵊ. ");
INSERT INTO rift_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","ⵅⴻⵏⵏⵉ ⴰⴷ ⴽⵙⵉⵏ ⵉⵥⵔⴰ ⵏⵏⴻⵖⵏⵉ, ⴰⴷ ⵜⴻⵏ ⴳⴳⴻⵏ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏ ⵉⵥⵔⴰ ⵏⵏⵉ ⵉⵀⴻⵍⵛⴻⵏ ⵓⵛⴰ ⴰⴷ ⴽⵙⵉⵏ ⴰⴱⴻⴵⴰⵄ ⵏⵏⴻⵖⵏⵉ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵃⴻⵏⵏⵛⴻⵏ ⵜⴰⴷⴷⴰⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","ⵎⴰⵍⴰ ⵓⴹⵓⵏ ⵉⴷⵡⴻⵍ-ⴷⴷ ⵓⵛⴰ ⵉⵙⵙⴼⵓⴼⴼⵉ ⵄⴰⵡⴻⴷ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⴽⴽⵙⴻⵏ ⵉⵥⵔⴰ ⵓ ⵇⴻⵛⵛⴰⵔⴻⵏ ⵜⴰⴷⴷⴰⵔⵜ ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⵜⵜ ⵃⴻⵏⵏⵛⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","ⵅⴻⵏⵏⵉ ⴰⴷ ⴷⴷ-ⵢⴰⵙ ⵓⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵜⵜ ⵉⵇⴻⴵⴻⴱ. ⵎⴰⵍⴰ ⵉⵥⵔⴰ, ⴰⵇⴰ ⵓⴹⵓⵏ ⵉⴱⴻⵣⵣⴻⵄ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ, ⵅⴻⵏⵏⵉ ⴰⵇⴰ ⴷⵉⵏ ⵉⵊⵊ ⵏ ⵍⴱⴰⵔⵚ ⵉⵇⴻⵙⵃⴻⵏ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ. ⴰⵇⴰ-ⵜⵜ ⵜⴻⵅⵎⴻⵊ. ");
INSERT INTO rift_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","ⴰⴷ ⵀⴻⴷⵎⴻⵏ ⵜⴰⴷⴷⴰⵔⵜ, ⵉⵥⵔⴰ ⵏⵏⴻⵙ ⴷ ⵜⵃⴻⵏⵢⴰ ⵏⵏⴻⵙ ⴷ ⵎⴰⵔⵔⴰ ⵜⴰⵔⵔⵉⵙⵜ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵓⵛⴰ ⴰⴷ ⵙⵙⵉⴳⴳⵯⴻⵊⴻⵏ ⴰⵢⴰ ⴱⴰⵔⵔⴰ ⵉ ⵜⴻⵏⴷⵉⵏⵜ ⵖⴰⵔ ⵉⵊⵊ ⵏ ⵡⴻⵎⵛⴰⵏ ⴷ ⴰⵎⴻⵅⵎⵓⵊ. ");
INSERT INTO rift_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","ⵡⵉ ⵖⴰ ⵢⴰⴷⴼⴻⵏ ⵖⴰⵔ ⵜⴰⴷⴷⴰⵔⵜ ⴷⴻⴳ ⵉⵊⵊ ⵏ ⵡⴰⵙⵙ ⵣⴻⴳ ⵡⵓⵙⵙⴰⵏ ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⴱⴻⵍⵍⵄⴻⵏ ⵜⴰⴷⴷⴰⵔⵜ, ⵏⴻⵜⵜⴰ ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ⴰⵍ ⵜⴰⵎⴻⴷⴷⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","ⵡⵉ ⵖⴰ ⵉⵟⵟⵚⴻⵏ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ, ⴰⴷ ⵉⵚⴻⴱⴱⴻⵏ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ ⵓ ⵡⵉ ⵖⴰ ⵉⵛⵛⴻⵏ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ, ⴰⴷ ⵉⵙⵙⵉⵔⴷ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","ⵎⴰⵍⴰ ⵢⵓⴷⴻⴼ ⵓⴽⴻⵀⵀⴰⵏ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⵜ ⵉⵇⴻⴵⴻⴱ ⵓⵛⴰ ⵉⵥⵔⴰ ⴰⵇⴰ ⵓⴹⵓⵏ ⵡⴰⵔ ⵉⵎⵖⵉⵔ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ, ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⵃⴻⵏⵏⵛⴻⵏ ⵜⴰⴷⴷⴰⵔⵜ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⴱⴰⵔⵔⴻⵃ ⵓⴽⴻⵀⵀⴰⵏ ⴱⴻⵍⵍⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵜⴻⵣⴷⴻⴳ, ⵎⵉⵏⵣⵉ ⵓⴹⵓⵏ ⵉⵜⵜⵡⴰⵙⵙⴳⴻⵏⴼⴰ. ");
INSERT INTO rift_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","ⴰⴷ ⵉⴽⵙⵉ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵊⴹⴰⴹ ⴷ ⵓⴽⴻⵛⵛⵓⴹ ⵏ ⵜⵛⴻⵊⵊⴰⵔⵜ ⵏ ⵜⴻⵏⴳⴻⵍⵜ ⴷ ⵓⵣⴻⴳⴳⵯⴰⵖ ⵉⵃⴻⴷⵇⴻⵏ ⴷ ⵜⵄⴻⵍⴵⴻⵜ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵣⵣⴰⵢⵙⴻⵏ ⵉⴽⴽⴻⵙ ⴷⴷⴻⵏⴱ ⵅ ⵜⴰⴷⴷⴰⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","ⴰⴷ ⵉⵖⴰⵔⵚ ⵉ ⵢⵉⵊⵊ ⵏ ⵡⴻⵊⴹⵉⴹ ⴷⴻⴳ ⵉⵛⵜ ⵏ ⵍⵇⴻⵛⵄⴻⵜ ⵏ ⵜⵍⴰⵅⵜ, ⵙⴻⵏⵏⴻⵊ ⵉ ⵡⴰⵎⴰⵏ ⵉⴷⴷⴰⵔⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","ⴰⴷ ⵉⴽⵙⵉ ⴰⴽⴻⵛⵛⵓⴹ ⵏ ⵜⵛⴻⵊⵊⴰⵔⵜ ⵏ ⵜⴻⵏⴳⴻⵍⵜ ⴷ ⵜⵄⴻⵍⴵⴻⵜ ⴷ ⵓⵣⴻⴳⴳⵯⴰⵖ ⵉⵃⴻⴷⵇⴻⵏ ⵓⵍⴰ ⴷ ⴰⵊⴹⵉⴹ ⵉⴷⴷⴰⵔⴻⵏ ⵓⵛⴰ ⴰⴷ ⵉⵙⵙⵓⴼ ⵎⴰⵔⵔⴰ ⴰⵢⴰ ⴷⴻⴳ ⵉⴷⴰⵎⵎⴻⵏ ⵏ ⵡⴻⵊⴹⵉⴹ ⵉⵜⵜⵡⴰⵖⴰⵔⵚⴻⵏ ⵓ ⴷⴻⴳ ⵡⴰⵎⴰⵏ ⵉⴷⴷⴰⵔⴻⵏ ⵓⵛⴰ ⴰⴷ ⵉⵔⵓⵛⵛ ⵜⴰⴷⴷⴰⵔⵜ ⵙⴻⴱⵄⴰ ⵏ ⵜⵡⴰⵍⴰⵡⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵉⴽⴽⴻⵙ ⴷⴷⴻⵏⴱ ⵅ ⵜⴰⴷⴷⴰⵔⵜ ⵙ ⵉⴷⴰⵎⵎⴻⵏ ⵏ ⵡⴻⵊⴹⵉⴹ, ⵙ ⵡⴰⵎⴰⵏ ⵉⴷⴷⴰⵔⴻⵏ ⴷ ⵡⴻⵊⴹⵉⴹ ⵉⴷⴷⴰⵔⴻⵏ ⴷ ⵓⴽⴻⵛⵛⵓⴹ ⵏ ⵜⵛⴻⵊⵊⴰⵔⵜ ⵏ ⵜⴻⵏⴳⴻⵍⵜ ⴷ ⵜⵄⴻⵍⴵⴻⵜ ⴷ ⵓⵣⴻⴳⴳⵯⴰⵖ ⵉⵃⴻⴷⵇⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","ⴰⴷ ⵢⴻⵊⵊ ⴰⵊⴹⵉⴹ ⵉⴷⴷⴰⵔⴻⵏ ⴰⴷ ⵉⴹⵡⴰ ⴱⴰⵔⵔⴰ ⵉ ⵜⴻⵏⴷⵉⵏⵜ ⵙⴻⵏⵏⴻⵊ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵢⴻⵢⵢⴰⵔ. ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵉⴳⴳ ⴰⵚⵍⴰⵃ ⵅ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⵉ ⵓⵛⴰ ⴰⴷ ⵜⵉⵍⵉ ⵜⵉⵣⴷⵉⴳ.” ");
INSERT INTO rift_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","“ⵡⴰ ⴷ ⴰⵣⴻⵔⴼ ⵅ ⵎⴰⵔⵔⴰ ⵍⴻⵀⵍⴰⵛⴰⵜ ⵏ ⵍⴱⴰⵔⵚ ⵓ ⵅ ⵜⴼⵓⵔⵉ ⵏ ⵢⵉⵍⴻⵎ, ");
INSERT INTO rift_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","ⵅ ⵍⴱⴰⵔⵚ ⵏ ⴰⵔⵔⵓⴹ ⵓ ⵏ ⵜⴰⴷⴷⴰⵔⵜ, ");
INSERT INTO rift_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","ⵅ ⵉⵊⵊ ⵏ ⵓⵄⴻⴱⴱⵓⵣ, ⵅ ⵉⵛⵜ ⵏ ⵜⵃⴻⴱⴱⵓⵛⵜ ⵓ ⵅ ⵉⵊⵊ ⵏ ⵡⴻⵏⴳⴰⵣ ⵉⵛⵛⴻⵎⵍⴻⵍ ⵏ ⵜⴻⵍⵎⴻⵛⵜ. ");
INSERT INTO rift_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","ⴰⵣⴻⵔⴼ-ⴰ ⴰⵇⴰ ⵉ ⵜⵖⵓⵔⵉ ⴷⴻⴳ ⵡⴰⵙⵙ ⵉ ⴷⵉ ⵖⴰ ⵢⵉⵍⵉ ⵃⴻⴷ ⵉⵅⵎⴻⵊ ⵏⵉⵖ ⴷⴻⴳ ⵡⴰⵙⵙ ⵉ ⴷⵉ ⵖⴰ ⵢⵉⵍⵉ ⵃⴻⴷ ⵉⵣⴷⴻⴳ. ⵡⴰ ⴷ ⴰⵣⴻⵔⴼ ⵏ ⵍⴱⴰⵔⵚ.” ");
INSERT INTO rift_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“ⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵉⵏⵉⵎ ⴰⵙⴻⵏ: ‘ⵎⴰⵍⴰ ⴰⵔⵢⴰⵣ ⵖⴰⵔⴻⵙ ⵉⵊⵊ ⵏ ⵓⵙⴻⵢⵢⴻⵍ ⵣⵉ ⴰⵔⵔⵉⵎⴻⵜ ⵏⵏⴻⵙ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ⵣⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⵓⵙⴻⵢⵢⴻⵍ. ");
INSERT INTO rift_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","ⵡⴰ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵍⴻⵅⵎⴻⵊ ⵏⵏⴻⵙ ⵣⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⵓⵙⴻⵢⵢⴻⵍ ⵏⵏⴻⵙ: ⵎⴰⵍⴰ ⴰⵔⵔⵉⵎⴻⵜ ⵏⵏⴻⵙ ⵜᵉⵜⵜⴻⵊⵊⴰ ⴰⵙⴻⵢⵢⴻⵍ ⵏⵏⴻⵙ ⵏⵉⵖ ⴰⵔⵔⵉⵎⴻⵜ ⵏⵏⴻⵙ ⵜⴻⵙⵙⴱⴻⴷⴷⴰ ⴰⵙⴻⵢⵢⴻⵍ ⵏⵏⴻⵙ, ⴰⵇⴰ-ⵜ ⴷ ⵍⴻⵅⵎⴻⵊ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","ⴽⵓⵍ ⵇⴰⵎⴰ ⵎⵉⵏ ⵅⴻⴼ ⵖⴰ ⵉⵟⵟⴻⵚ ⵡⴻⵏⵏⵉ ⴷⵉ ⵉⴵⴰ ⵓⵙⴻⵢⵢⴻⵍ, ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ⵓ ⴽⵓⵍ ⵍⵇⴻⵛⵄⴻⵜ ⵉ ⵅⴻⴼ ⵖⴰ ⵉⵇⵇⵉⵎ, ⴰⴷ ⵜⵉⵍⵉ ⵜⴻⵅⵎⴻⵊ. ");
INSERT INTO rift_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","ⵎⴰⵔⵔⴰ ⵡⵉ ⵖⴰ ⵉⵃⴰⴷⴰⵏ ⵇⴰⵎⴰ ⵏⵏⴻⵙ, ⴰⴷ ⵉⵚⴻⴱⴱⴻⵏ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ, ⴰⴷ ⵉⵙⵙⵉⵔⴷ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵄⴰⵡⴻⴷ ⵙ ⵡⴰⵎⴰⵏ ⵓⵛⴰ ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ⴰⵍ ⵜⴰⵎⴻⴷⴷⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵉⵇⵇⵉⵎⴻⵏ ⵅ ⵛⴰ ⵅ ⵎⵉⵏ ⵅⴻⴼ ⵜⵓⵖⴰ ⵉⵇⵇⵉⵎ ⵡⴻⵏⵏⵉ ⴷⵉ ⵉⴵⴰ ⵓⵙⴻⵢⵢⴻⵍ, ⴰⴷ ⵉⵚⴻⴱⴱⴻⵏ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ, ⴰⴷ ⵉⵙⵙⵉⵔⴷ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵄⴰⵡⴻⴷ ⵙ ⵡⴰⵎⴰⵏ ⵓⵛⴰ ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ⴰⵍ ⵜⴰⵎⴻⴷⴷⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵉⵃⴰⴷⴰⵏ ⴰⵔⵔⵉⵎⴻⵜ ⵏ ⵡⴻⵏⵏⵉ ⴷⵉ ⵉⴵⴰ ⵓⵙⴻⵢⵢⴻⵍ, ⴰⴷ ⵉⵚⴻⴱⴱⴻⵏ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵙⵉⵎⴰⵏⵜ ⵏⵏⴻⵙ ⴰⴷ ⵉⵙⵙⵉⵔⴷ ⵙ ⵡⴰⵎⴰⵏ, ⵓⵛⴰ ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ⴰⵍ ⵜⴰⵎⴻⴷⴷⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","ⵎⴰⵍⴰ ⵡⵉ ⴷⵉ ⵉⴵⴰ ⵓⵙⴻⵢⵢⴻⵍ ⵉⵙⵙⵓⵙⴻⴼ ⵅ ⵉⵊⵊ ⵏ ⵓⵎⴻⵣⴷⴰⴳ, ⴰⵇⴰ ⵡⴰ ⴰⴷ ⵉⵚⴻⴱⴱⴻⵏ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ, ⴰⴷ ⵉⵙⵙⵉⵔⴷ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵙ ⵡⴰⵎⴰⵏ ⵓⵛⴰ ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ⴰⵍ ⵜⴰⵎⴻⴷⴷⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","ⴽⵓⵍ ⵜⵔⵉⵛⵜ ⵎⵉⵏ ⵅⴻⴼ ⵉⵇⵇⵉⵎ ⵡⴻⵏⵏⵉ ⴷⵉ ⵉⴵⴰ ⵓⵙⴻⵢⵢⴻⵍ, ⴰⴷ ⵜⵉⵍⵉ ⵜⴻⵅⵎⴻⵊ. ");
INSERT INTO rift_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","ⵎⴰⵔⵔⴰ ⵡⵉ ⵖⴰ ⵉⵃⴰⴷⴰⵏ ⵎⴰⵎⵎⴻⵛ ⵎⴰ ⵍⵇⴻⵛⵄⴻⵜ ⵏⵏⵉ ⵉⴵⴰⵏ ⵙⴰⴷⵓ ⵏⵏⴻⵙ, ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ⴰⵍ ⵜⴰⵎⴻⴷⴷⵉⵜ ⵓⵛⴰ ⵡⵉ ⵜⵜ ⵖⴰ ⵉⴽⵙⵉⵏ, ⴰⴷ ⵉⵚⴻⴱⴱⴻⵏ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ, ⴰⴷ ⵉⵙⵙⵉⵔⴷ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵙ ⵡⴰⵎⴰⵏ ⵓⵛⴰ ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ⴰⵍ ⵜⴰⵎⴻⴷⴷⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","ⵎⴰⵔⵔⴰ ⵡⵉ ⵖⴰ ⵉⵜⵜⵡⴰⵃⴰⴷⴰⵏ ⵣⴻⴳ ⵡⴻⵏⵏⵉ ⴷⵉ ⵉⴵⴰ ⵓⵙⴻⵢⵢⴻⵍ ⴱⵍⴰ ⵎⴰ ⴰⴷ ⵉⵙⵙⵉⵔⴷ ⵡⴰ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵏⴻⵙ ⴰⵎⴻⵣⵡⴰⵔⵓ, ⴰⴷ ⵉⵚⴻⴱⴱⴻⵏ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ, ⴰⴷ ⵉⵙⵙⵉⵔⴷ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵙ ⵡⴰⵎⴰⵏ ⵓⵛⴰ ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ⴰⵍ ⵜⴰⵎⴻⴷⴷⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","ⵟⵟⴻⴱⵚⵉ ⵏ ⵜⵍⴰⵅⵜ ⵏⵏⵉ ⵉⵃⴰⴷⴰ ⵡⴻⵏⵏⵉ ⴷⵉ ⵉⴵⴰ ⵓⵙⴻⵢⵢⴻⵍ, ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵉⵜⵜⵡⴰⵔⵥ, ⵎⴰⵛⴰ ⵎⴰⵔⵔⴰ ⵍⵇⴻⵛⵄⴻⵜ ⵏ ⵜⴻⴼⵍⴰⵡⵜ ⴰⴷ ⵜⵜ ⵙⵉⵔⴷⴻⵏ ⵙ ⵡⴰⵎⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","ⵅⵎⵉ ⵡⴻⵏⵏⵉ ⴷⵉ ⵉⴵⴰ ⵓⵙⴻⵢⵢⴻⵍ ⴰⴷ ⵉⵜⵜⵡⴰⵙⵙⵉⵣⴷⴻⴳ ⵣⴻⴳ ⵓⵙⴻⵢⵢⴻⵍ ⵏⵏⴻⵙ, ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⵙ ⵙⵉⵎⴰⵏⵜ ⵏⵏⴻⵙ ⴰⴷ ⵉⵃⵙⴻⴱ ⵉ ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ. ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⵚⴻⴱⴱⴻⵏ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ, ⴰⴷ ⵉⵙⵙⵉⵔⴷ ⴰⵔⵔⵉⵎⴻⵜ ⵏⵏⴻⵙ ⵙ ⵡⴰⵎⴰⵏ ⵉⴷⴷⴰⵔⴻⵏ ⵓⵛⴰ ⴰⴷ ⵢⵉⵍⵉ ⵉⵣⴷⵉⴳ. ");
INSERT INTO rift_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵜⵎⴻⵏⵢⴰ ⴰⴷ ⵉⴽⵙⵉ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵊⵍⵉⵍⵍⵉⵃⵉⵏ ⵏⵉⵖ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⴷⴱⵉⵔⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⴻⵏ ⵓⵛⴰ ⴰⴷ ⴷⴷ-ⵢⴰⵙ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⵓⵛⴰ ⴰⴷ ⵜⴻⵏ ⵉⵡⵛ ⵉ ⵓⴽⴻⵀⵀⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵉⵙⵙⴻⵡⵊⴻⴷ ⵉⵛⵜ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⴷ ⵉⵛⵜ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ. ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵅⴰⵙ ⵉⴳⴳ ⴰⵚⵍⴰⵃ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⵅ ⵓⵙⴻⵢⵢⴻⵍ ⵏⵏⴻⵙ.’” ");
INSERT INTO rift_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“ⵎⴰⵍⴰ ⵉⴼⴼⴻⵖ-ⴷⴷ ⵓⵙⴻⵢⵢⴻⵍ ⵏ ⵡⴰⴵⵓ ⵣⴻⴳ ⵡⴻⵔⵢⴰⵣ, ⴰⴷ ⵉⵙⵙⵉⵔⴷ ⴰⵔⵔⵉⵎⴻⵜ ⵏⵏⴻⵙ ⵎⴰⵔⵔⴰ ⵙ ⵡⴰⵎⴰⵏ ⵓⵛⴰ ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ⴰⵍ ⵜⴰⵎⴻⴷⴷⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","ⴽⵓⵍ ⴰⵔⵔⵓⴹ ⴷ ⴽⵓⵍ ⵉⵍⴻⵎ ⵉ ⵅⴻⴼ ⵉⴵⴰ ⵓⵙⴻⵢⵢⴻⵍ ⵏ ⵡⴰⴵⵓ, ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜ ⵙⵉⵔⴷⴻⵏ ⵙ ⵡⴰⵎⴰⵏ ⵓⵛⴰ ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ⴰⵍ ⵜⴰⵎⴻⴷⴷⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","ⵎⴰⵍⴰ ⵉⵟⵟⴻⵚ ⵢⵉⵊⵊ ⵡⴻⵔⵢⴰⵣ ⴰⴽ-ⴷ ⵜⴻⵎⵖⴰⵔⵜ ⵓⵛⴰ ⵉⵏⴹⴰⵔ ⴷⴰⵢⴻⵙ ⵏⴻⵜⵜⴰ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵙⵙⵉⵔⴷⴻⵏ ⵙ ⵜⵏⴰⵢⴻⵏ ⵉⴷⵙⴻⵏ ⵙ ⵡⴰⵎⴰⵏ ⵓⵛⴰ ⴰⴷ ⵉⵍⵉⵏ ⵅⴻⵎⵊⴻⵏ ⴰⵍ ⵜⴰⵎⴻⴷⴷⵉⵜ.” ");
INSERT INTO rift_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“ⵎⴰⵍⴰ ⵜⴰⵎⵖⴰⵔⵜ ⵜⵓⵖⴰ-ⵜⵜ ⵜⵙⴻⵢⵢⴻⵍ, ⴰⵇⴰ ⵅⴰⵙ ⵉⴷⴰⵎⵎⴻⵏ ⴷⵉ ⴰⵔⵔⵉⵎⴻⵜ ⵏⵏⴻⵙ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⴻⵄⵣⴻⵍ ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ. ⵎⴰⵔⵔⴰ ⵡⵉ ⵜⵜ ⵖⴰ ⵉⵃⴰⴷⴰⵏ ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ⴰⵍ ⵜⴰⵎⴻⴷⴷⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵅⴻⴼ ⵜⵓⵖⴰ ⵜᵉⵟⵟⴻⵚ ⴷⴻⴳ ⵡⴻⵄⵣⴰⵍ ⵏⵏⴻⵙ, ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ⵓⵛⴰ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵅⴻⴼ ⵜⵓⵖⴰ ⵜⴻⵇⵇⵉⵎ, ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ. ");
INSERT INTO rift_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","ⵎⴰⵔⵔⴰ ⵡⵉ ⵖⴰ ⵉⵃⴰⴷⴰⵏ ⵇⴰⵎⴰ ⵏⵏⴻⵙ, ⴰⴷ ⵉⵙⵙⵉⵔⴷ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ, ⴰⴷ ⵉⵙⵙⵉⵔⴷ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵙ ⵡⴰⵎⴰⵏ ⵓⵛⴰ ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ⴰⵍ ⵜⴰⵎⴻⴷⴷⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","ⵎⴰⵔⵔⴰ ⵡⵉ ⵖⴰ ⵉⵃⴰⴷⴰⵏ ⵛⴰ ⵏ ⵍⵇⴻⵛⵄⴻⵜ ⵎⵉⵏ ⵅⴻⴼ ⵜⵓⵖⴰ ⵜᵉⵜⵜⵖⵉⵎⴰ, ⴰⴷ ⵉⵚⴻⴱⴱⴻⵏ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ, ⴰⴷ ⵉⵙⵙⵉⵔⴷ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵙ ⵡⴰⵎⴰⵏ ⵓⵛⴰ ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ⴰⵍ ⵜⴰⵎⴻⴷⴷⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","ⵏⵉⵖ ⵎⴰⵍⴰ ⵉⵇⵇⵉⵎ ⵅ ⵇⴰⵎⴰ ⵏⵉⵖ ⵅ ⵍⵇⴻⵛⵄⴻⵜ ⵉ ⵅⴻⴼ ⵜⵓⵖⴰ ⵜⴻⵇⵇⵉⵎ ⵏⴻⵜⵜⴰⵜ, ⵓⵎⵉ ⵉⵃⴰⴷⴰ ⴰⵢⴰ ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ⴰⵍ ⵜⴰⵎⴻⴷⴷⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","ⵎⴰⵍⴰ ⵉⵟⵟⴻⵚ ⴰⴽⵉⴷⴻⵙ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵓⵛⴰ ⵢⵓⵙⴰ-ⴷⴷ ⵅⴰⵙ ⵡⴻⵄⵣⴰⵍ ⵏⵏⴻⵙ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ. ⴽⵓⵍ ⵇⴰⵎⴰ ⵉ ⵅ ⵜⵓⵖⴰ ⵉⵟⵟⴻⵚ, ⴰⴷ ⵜⵉⵍⵉ ⵜⴻⵅⵎⴻⵊ. ");
INSERT INTO rift_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","ⵎⴰⵍⴰ ⵓⵙⵉⵏ-ⴷⴷ ⵉⴷⴰⵎⵎⴻⵏ ⵅ ⵉⵛⵜ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⴰⵟⵟⴰⵙ ⵏ ⵡⵓⵙⵙⴰⵏ ⴱⴰⵔⵔⴰ ⵉ ⵍⵎⵉⵊⴰⵍ ⵏ ⵡⴻⵄⵣⴰⵍ ⵏⵏⴻⵙ ⵏⵉⵖ ⵎⴰⵍⴰ ⵜⵓⵖⴰ ⴰⵙⴻⵢⵢⴻⵍ ⴽⵜⴰⵔ ⵅ ⵍⵎⵉⵊⴰⵍ ⵏ ⵡⴻⵄⵣⴰⵍ ⵏⵏⴻⵙ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⵉⵍⵉ ⵜⴻⵅⵎⴻⵊ ⵎⴰⵔⵔⴰ ⵓⵙⵙⴰⵏ ⵏ ⵓⵙⴻⵢⵢⴻⵍ ⵉ ⴷⴷ-ⵢⵓⵙⵉⵏ ⴰⴽ-ⴷ ⵍⴻⵅⵎⴻⵊ ⵏⵏⴻⵙ, ⴰⵎ ⴷⴻⴳ ⵡⵓⵙⵙⴰⵏ ⵏ ⵡⴻⵄⵣⴰⵍ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","ⴽⵓⵍ ⵇⴰⵎⴰ ⵎⵉⵏ ⵅⴻⴼ ⵜᵉⵟⵟⴻⵚ ⵎⴰⵔⵔⴰ ⵓⵙⵙⴰⵏ ⵏ ⵓⵙⴻⵢⵢⴻⵍ ⵏⵏⴻⵙ, ⴰⴷ ⴰⵙ ⵜⵉⵍⵉ ⴰⵎ ⵇⴰⵎⴰ ⵏ ⵡⴻⵄⵣⴰⵍ ⵏⵏⴻⵙ ⵓ ⵎⴰⵔⵔⴰ ⵍⵇⴻⵛⵄⴻⵜ ⵎⵉⵏ ⵅⴻⴼ ⵜⴻⵇⵇⵉⵎ, ⴰⴷ ⵜⵉⵍⵉ ⵜⴻⵅⵎⴻⵊ ⴰⵎⴻⵛⵏⴰⵡ ⵍⴻⵅⵎⴻⵊ ⵏ ⵡⴻⵄⵣⴰⵍ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","ⵎⴰⵔⵔⴰ ⵡⵉ ⵖⴰ ⵉⵃⴰⴷⴰⵏ ⵜⵉⵎⴻⵙⵍⴰⵢⵉⵏ ⵏⵏⵉ, ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ. ⴰⴷ ⵉⵚⴻⴱⴱⴻⵏ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⵉⵙⵙⵉⵔⴷ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵙ ⵡⴰⵎⴰⵏ ⵓⵛⴰ ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ⴰⵍ ⵜⴰⵎⴻⴷⴷⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","ⵎⴰⵍⴰ ⵜᵉⵜⵜⵡⴰⵙⵙⵉⵣⴷⴻⴳ ⵣⴻⴳ ⵓⵙⴻⵢⵢⴻⵍ ⵏⵏⴻⵙ, ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜⴻⵃⵙⴻⴱ ⵉ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ, ⴰⵡⴰⵔⵏⵉ ⴰⵙ ⴰⴷ ⵜⵉⵍⵉ ⵜⴻⵣⴷⴻⴳ. ");
INSERT INTO rift_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵜⵎⴻⵏⵢⴰ ⴰⴷ ⵜⴻⴽⵙⵉ ⵉ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵊⵍⵉⵍⵍⵉⵃⵉⵏ ⵏⵉⵖ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⴷⴱⵉⵔⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⴻⵏ ⵓⵛⴰ ⴰⴷ ⵜⴻⵏ ⵜⴰⵡⵉ ⵖⴰⵔ ⵓⴽⴻⵀⵀⴰⵏ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵉⵙⵙⴻⵡⵊⴻⴷ ⵉⵛⵜ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⴷ ⵉⵛⵜ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵓⵛⴰ ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵅⴰⵙ ⵉⴳⴳ ⴰⵚⵍⴰⵃ ⴷⵉ ⵜⵎⴻⵙⵍⴰⵛⵜ ⵏ ⵓⵙⴻⵢⵢⴻⵍ ⵏ ⵍⴻⵅⵎⴻⵊ ⵏⵏⴻⵙ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵜⵄⴻⵣⵍⴻⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵅ ⵍⴻⵅⵎⴻⵊ ⵏⵙⴻⵏ, ⵃⵉⵎⴰ ⵡⴰⵔ ⵜⵜᵉⵎⴻⵜⵜⵉⵏ ⴷⵉ ⵍⴻⵅⵎⴻⵊ ⵏⵙⴻⵏ, ⵓⵎⵉ ⵙⵙⵅⴻⵎⵎⴰⵊⴻⵏ ⵜⴰⵣⴻⴷⴷⵉⵖⵜ ⵉⵏⵓ ⵏⵏⵉ ⵉⴵⴰⵏ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏⵙⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","ⵡⴰ ⴷ ⴰⵣⴻⵔⴼ ⵉ ⵡⴻⵏⵏⵉ ⵖⴰⵔ ⵉⴵⴰ ⵓⵙⴻⵢⵢⴻⵍ ⵓ ⵉ ⵡⴻⵏⵏⵉ ⵣⵉ ⵖⴰ ⵉⴼⴼⴻⵖ ⵡⴰⴵⵓ ⵏⵏⴻⵙ ⵓⵛⴰ ⵅⴻⵏⵏⵉ ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ");
INSERT INTO rift_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ⵓ ⵄⴰⵡⴻⴷ ⵉ ⵜⴻⵏⵏⵉ ⵎⵉⵏ ⵅⴻⴼ ⵉⴵⴰ ⵉⴷⴰⵎⵎⴻⵏ ⵓⵛⴰ ⵅⴻⵏⵏⵉ ⵜⴻⵄⵣⴻⵍ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵓ ⵄⴰⵡⴻⴷ ⵉ ⵡⵉ ⴷⵉ ⵜⵓⵖⴰ ⴰⵙⴻⵢⵢⴻⵍ, ⵉ ⵡⴻⵔⵢⴰⵣ ⵓⵍⴰ ⵉ ⵜⴻⵎⵖⴰⵔⵜ, ⵓ ⵄⴰⵡⴻⴷ ⵉ ⵡⴻⵔⵢⴰⵣ ⵉ ⵜⵓⵖⴰ ⵉⵟⵟⵚⴻⵏ ⴰⴽ-ⴷ ⵜⴻⵏⵏⵉ ⵉⴵⴰⵏ ⵜⴻⵅⵎⴻⵊ. ");
INSERT INTO rift_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ ⴰⵡⴰⵔⵏⵉ ⵉ ⵍⵎⴻⵡⵜ ⵏ ⵜⵏⴰⵢⴻⵏ ⵏ ⵡⴰⵔⵔⴰⵡ ⵏ ⵀⴰⵔⵓⵏ, ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⴷⴷ-ⵇⴰⵔⵔⴱⴻⵏ ⵏⵉⵜⵏⵉ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⵓⵛⴰ ⵎⵎⵓⵜⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","ⵙⵉⴷⵉ ⵉⵏⵏⴰ ⵉ ⵎⵓⵙⴰ: “ⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⵀⴰⵔⵓⵏ, ⵓⵎⴰⵛ, ⵃⵉⵎⴰ ⵡⴰⵔ ⵉⵜⵜⵉⴷⴻⴼ ⵍⴻⴱⴷⴰ ⵖⴰⵔ ⵓⵇⴻⴷⴷⴰⵙ ⴷⴰⵅⴻⵍ ⵉ ⵓⵍⴻⵃⵃⴰⴼ ⵣⵣⴰⵜ ⵉ ⵜⵇⴻⴱⴱⴰⵔⵜ ⵏ ⵡⴻⵚⵍⴰⵃ ⵏⵏⵉ ⵉⴵⴰⵏ ⵅ ⵜⵜⴰⴱⵓⵜ, ⵃⵉⵎⴰ ⵡⴰⵔ ⵉⵜⵜⵎⴻⵜⵜⵉ ⵛⴰ, ⵎⵉⵏⵣⵉ ⵏⴻⵛⵛ ⵜⵜⴱⴰⵏⴻⵖ-ⴷⴷ ⴷⴻⴳ ⵉⵊⵊ ⵏ ⵓⵙⴻⵢⵏⵓ ⵙⴻⵏⵏⴻⵊ ⵉ ⵜⵇⴻⴱⴱⴰⵔⵜ ⵏ ⵡⴻⵚⵍⴰⵃ. ");
INSERT INTO rift_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","ⵙ ⵓⵢⴰ ⴰⴷ ⵢⴰⴷⴻⴼ ⵀⴰⵔⵓⵏ ⵖⴰⵔ ⵓⵇⴻⴷⴷⴰⵙ: ⵙ ⵉⵊⵊ ⵏ ⵓⴼⵓⵏⴰⵙ, ⴰⵎⴻⵥⵢⴰⵏ ⵏ ⵜⴼⵓⵏⴰⵙⵜ, ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ, ⵓ ⵙ ⵢⵉⵊⵊ ⵏ ⵉⵛⴰⵔⵔⵉ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ. ");
INSERT INTO rift_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","ⴰⴷ ⵢⴰⵔⴹ ⵜⵛⴰⵎⵉⵔ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵏ ⵍⴻⵇⵟⴻⵏ ⵓⵛⴰ ⵙⵙⴰⵔⵡⴰⵍ ⵏ ⵍⴻⵇⵟⴻⵏ ⴰⴷ ⵢⵉⵍⵉ ⵅ ⴰⵔⵔⵉⵎⴻⵜ ⵏⵏⴻⵙ. ⴰⴷ ⵉⴱⵢⴻⵙ ⵜⴰⵃⴻⵣⵣⴰⵎⵜ ⵏ ⵍⴻⵇⵟⴻⵏ ⵓⵛⴰ ⴰⴷ ⵢⴰⵔⴻⴽⴽⴻⴱ ⴰⵔⴻⵥⵥⴻⵜ ⵏ ⵍⴻⵇⵟⴻⵏ. ⴰⵇⴰ ⵎⴰⵏ ⴰⵢⴰ ⴷ ⴰⵔⵔⵓⴹ ⵉⵇⴻⴷⴷⵙⴻⵏ. ⵎⴰⵍⴰ ⴰⴷ ⵜⴻⵏ ⵢⴰⵔⴹ, ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⵙ ⴰⴷ ⵉⵙⵙⵉⵔⴷ ⴰⵔⵔⵉⵎⴻⵜ ⵏⵏⴻⵙ ⵙ ⵡⴰⵎⴰⵏ ⴷ ⴰⵎⴻⵣⵡⴰⵔⵓ. ");
INSERT INTO rift_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","ⴰⴷ ⵉⴽⵙⵉ ⵣⵉ ⵜⵎⴻⵙⵎⵓⵏⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵎⵢⴰⵏⴻⵏ ⵣⴻⴳ ⵉⵖⴰⵢⴹⴻⵏ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⴷ ⵉⵊⵊ ⵏ ⵉⵛⴰⵔⵔⵉ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ. ");
INSERT INTO rift_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","ⴰⴷ ⴷⴷ-ⵉⵙⵙⵇⴰⵔⵔⴻⴱ ⵀⴰⵔⵓⵏ ⴰⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ, ⵡⴻⵏⵏⵉ ⵉⴵⴰⵏ ⵉ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵙ, ⵓⵛⴰ ⴰⴷ ⵉⴳⴳ ⴰⵚⵍⴰⵃ ⵉ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵓ ⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⴻⵙ.    ");
INSERT INTO rift_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","ⴰⴷ ⵉⴽⵙⵉ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵎⵢⴰⵏⴻⵏ ⵓⵛⴰ ⴰⴷ ⵜⴻⵏ ⵉⴳⴳ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","ⴰⴷ ⵉⵏⴹⴰⵔ ⵀⴰⵔⵓⵏ ⵜⴰⵇⴻⴷⴷⵓⵃⵜ ⵅ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵎⵢⴰⵏⴻⵏ: ⵉⵛⵜ ⵏ ⵜⵇⴻⴷⴷⵓⵃⵜ ⵅ ⵙⵉⴷⵉ ⵓ ⵉⵛⵜ ⵏ ⵜⵇⴻⴷⴷⵓⵃⵜ ⵅ ⵉⵖⴰⵢⴹ ⵉⵏⵏⵓⴼⵙⵍⴻⵏ, ⵇⵇⴰⵔⴻⵏ ⴰⵙ ‘ⵄⴰⵣⴰⵣⵉⵍ’. ");
INSERT INTO rift_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","ⴰⴷ ⴷⴷ-ⵉⵙⵙⵇⴰⵔⵔⴻⴱ ⵀⴰⵔⵓⵏ ⴰⵎⵢⴰⵏ ⵏⵏⵉ ⵅ ⴷⴷ-ⵜⴻⵡⴹⴰ ⵜⴰⵇⴻⴷⴷⵓⵃⵜ ⵉ ⵙⵉⴷⵉ ⵓⵛⴰ ⴰⴷ ⵜ ⵉⵙⵙⴻⵡⵊⴻⴷ ⴷ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ. ");
INSERT INTO rift_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","ⴰⵎⵢⴰⵏ ⵉ ⵅ ⴷⴷ-ⵜⴻⵡⴹⴰ ⵜⴰⵇⴻⴷⴷⵓⵃⵜ ⵏ ⵉⵖⴰⵢⴹ ⵉⵏⵏⵓⴼⵙⵍⴻⵏ, ⴰⴷ ⵜ ⵉⴳⴳ ⵉⴷⴷⴰⵔ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵉⴳⴳ ⴰⵚⵍⴰⵃ ⵓⵛⴰ ⵅⴻⵏⵏⵉ ⴰⴷ ⵜ ⵉⵙⵙⴻⴽⴽ ⴰⵎ ⵢⵉⵖⴰⵢⴹ ⵉⵏⵏⵓⴼⵙⵍⴻⵏ ⵖⴰⵔ ⵍⴻⵅⵍⴰ. ");
INSERT INTO rift_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","ⴰⴷ ⴷⴷ-ⵉⵙⵙⵇⴰⵔⵔⴻⴱ ⵀⴰⵔⵓⵏ ⴰⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ, ⵡⴻⵏⵏⵉ ⵜⵓⵖⴰ ⵉ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵙ, ⵓⵛⴰ ⴰⴷ ⵉⴳⴳ ⴰⵚⵍⴰⵃ ⵉ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵓ ⵉ ⴰⵢⵜⴱⴰⴱ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⵉⵖⴰⵔⵚ ⵉ ⵓⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ, ⵡⴻⵏⵏⵉ ⵉⴵⴰⵏ ⵉ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","ⴰⴷ ⵉⴽⵙⵉ ⵄⴰⵡⴻⴷ ⵉⵊⵊ ⵏ ⵍⵎⴻⵊⵎⴰⵔ ⵉⵛⵛⵓⵔ ⵙ ⵍⴻⴼⵃⴻⵎ ⵉⵜⵜⴻⵃⴷⵓⴷⵓⵇⴻⵏ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⵓⵛⴰ ⴰⴷ ⵉⵛⵛⵓⵔ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵏⴻⵙ ⵙ ⵍⴻⴱⵅⵓⵔ ⴰⵣⴷⴰⴷ ⵉⵜⵜⴼⵓⵃⴻⵏ, ⵓⵛⴰ ⴰⴷ ⵢⴰⵡⵉ ⵎⴰⵔⵔⴰ ⴰⵢⴰ ⴷⴰⵅⴻⵍ ⵉ ⵓⵍⴻⵃⵃⴰⴼ. ");
INSERT INTO rift_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","ⴰⴷ ⵉⴳⴳ ⵍⴻⴱⵅⵓⵔ ⵅ ⵜⵎⴻⵙⵙⵉ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ, ⵃⵉⵎⴰ ⴰⵙⴻⵢⵏⵓ ⵏ ⵍⴻⴼⵡⴰⵔ ⵏ ⵍⴻⴱⵅⵓⵔ ⴰⴷ ⵉⴷⴻⵍ ⵜⴰⵇⴻⴱⴱⴰⵔⵜ ⵏ ⵡⴻⵚⵍⴰⵃ ⵉ ⵉⴵⴰⵏ ⵅ ⵛⵛⵀⴰⴷⴻⵜ, ⵓⵛⴰ ⵡⴰⵔ ⵉⵜⵜⵎⴻⵜⵜⵉ ⵛⴰ. ");
INSERT INTO rift_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","ⴰⴷ ⵉⴽⵙⵉ ⵛⵡⴰⵢⵜ ⵣⴻⴳ ⵉⴷⴰⵎⵎⴻⵏ ⵏ ⵓⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ ⵓⵛⴰ ⴰⴷ ⵜⴻⵏ ⵉⵔⵓⵛⵛ ⵙ ⵓⴹⴰⴹ ⵏⵏⴻⵙ ⵅ ⵡⵓⴷⴻⵎ ⵏ ⵜⵇⴻⴱⴱⴰⵔⵜ ⵏ ⵡⴻⵚⵍⴰⵃ ⵖⴰⵔ ⵓⵖⴻⵣⴷⵉⵙ ⵏ ⵛⵛⴰⵔⵇ ⵓⵛⴰ ⵄⴰⵡⴻⴷ ⴰⴷ ⵉⵔⵓⵛⵛ ⵛⵡⴰⵢⵜ ⵣⴻⴳ ⵉⴷⴰⵎⵎⴻⵏ ⵙⴻⴱⵄⴰ ⵏ ⵜⵡⴰⵍⴰⵡⵉⵏ ⵙ ⵓⴹⴰⴹ ⵏⵏⴻⵙ ⵣⵣⴰⵜ ⵉ ⵜⵇⴻⴱⴱⴰⵔⵜ ⵏ ⵡⴻⵚⵍⴰⵃ. ");
INSERT INTO rift_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⵖⴰⵔⵚ ⵉ ⵓⵎⵢⴰⵏ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ, ⵡⴻⵏⵏⵉ ⵉⴵⴰⵏ ⵉ ⵍⴳⴻⵏⵙ ⵓⵛⴰ ⴰⴷ ⵢⴰⵡⵉ ⵉⴷⴰⵎⵎⴻⵏ ⵖⴰⵔ ⴷⴰⵅⴻⵍ ⵉ ⵓⵍⴻⵃⵃⴰⴼ ⵓⵛⴰ ⴰⴷ ⵉⴳⴳ ⵙ ⵉⴷⴰⵎⵎⴻⵏ ⵏⵏⴻⵙ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵉⴳⴳⴰ ⵙ ⵉⴷⴰⵎⵎⴻⵏ ⵏ ⵓⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ: ⴰⴷ ⵜⴻⵏ ⵉⵔⵓⵛⵛ ⵅ ⵜⵇⴻⴱⴱⴰⵔⵜ ⵏ ⵡⴻⵚⵍⴰⵃ ⵓ ⵣⵣⴰⵜ ⵉ ⵜⵇⴻⴱⴱⴰⵔⵜ ⵏ ⵡⴻⵚⵍⴰⵃ. ");
INSERT INTO rift_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","ⴰⵎⵎⵓ ⵉ ⵉ ⵖⴰ ⵉⴳⴳ ⴰⵚⵍⴰⵃ ⵅ ⵓⵇⴻⴷⴷⴰⵙ ⵉ ⵍⵃⴰⵊⵊⴰⵜ ⵉⵅⴻⵎⵊⴻⵏ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓ ⵉ ⵉⵅⴻⵟⵟⴰⵏ ⵏⵙⴻⵏ ⵉ ⴷⴷ-ⵉⵜⵜⴰⵙⴻⵏ ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⴷⴷⵏⵓⴱ ⵏⵙⴻⵏ. ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵢⴻⴳⴳ ⴷⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ⵡⴻⵏⵏⵉ ⵉⴵⴰⵏ ⴰⴽⵉⴷⵙⴻⵏ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏ ⵎⴰⵔⵔⴰ ⵜⵉⵎⴻⵙⵍⴰⵢⵉⵏ ⵉⵅⴻⵎⵊⴻⵏ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","ⵓⵍⴰ ⴷ ⵉⵊⵊ ⵏ ⴱⵏⴰⴷⴻⵎ ⴰⴷ ⵢⵉⵍⵉ ⵄⴰⴷ ⴷⴻⴳ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⵣⴻⴳ ⵡⴰⵎⵉ ⵉ ⵖⴰ ⵢⴰⴷⴻⴼ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⴳⴳ ⴰⵚⵍⴰⵃ ⴷⴻⴳ ⵓⵇⴻⴷⴷⴰⵙ ⴰⵍ ⵖⴰ ⵉⴼⴼⴻⵖ ⵄⴰⵡⴻⴷ. ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵉⴳⴳ ⴰⵚⵍⴰⵃ ⵉ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵓ ⵉ ⵎⴰⵔⵔⴰ ⴰⴳⵔⴰⵡ ⵏ ⵍⴳⴻⵏⵙ ⵏ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","ⴰⴷ ⵉⴼⴼⴻⵖ ⴰⵍ ⵓⵄⴰⵍⵟⴰⵔ ⵉ ⵉⴵⴰⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⵓⵛⴰ ⴰⴷ ⵉⴳⴳ ⴰⵙⵍⴰⵃ ⵅ ⵓⵄⴰⵍⵟⴰⵔ. ⴰⴷ ⵉⴽⵙⵉ ⵛⵡⴰⵢⵜ ⵣⴻⴳ ⵉⴷⴰⵎⵎⴻⵏ ⵏ ⵓⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ ⵓ ⵛⵡⴰⵢⵜ ⵣⴻⴳ ⵉⴷⴰⵎⵎⴻⵏ ⵏ ⵓⵎⵢⴰⵏ ⵓⵛⴰ ⴰⴷ ⵉⵙⵙⴰⵔⵙ ⴰⵢⴰ ⵅ ⵡⴰⵛⵛⴰⵡⴻⵏ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ⴷⴻⴳ ⵡⴻⵏⵏⴻⴹ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","ⵙⴻⴱⵄⴰ ⵏ ⵜⵡⴰⵍⴰⵡⵉⵏ ⴰⴷ ⵅⴰⵙ ⵉⵔⵓⵛⵛ ⵙ ⵓⴹⴰⴹ ⵏⵏⴻⵙ ⵛⵡⴰⵢⵜ ⵣⴻⴳ ⵉⴷⴰⵎⵎⴻⵏ ⵓⵛⴰ ⴰⴷ ⵜ ⵉⵙⵙⵉⵣⴷⴻⴳ ⵓ ⴰⴷ ⵜ ⵉⵙⵙⵇⴻⴷⴷⴻⵙ ⵣⵉ ⵍⴻⵅⵎⴻⵊ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⵉⴽⴻⵎⵎⴻⵍ ⴰⵚⵍⴰⵃ ⵏ ⵓⵇⴻⴷⴷⴰⵙ ⴷ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⴷ ⵓⵄⴰⵍⵟⴰⵔ, ⴰⴷ ⴷⴷ-ⵉⵙⵙⵇⴰⵔⵔⴻⴱ ⵅⴻⵏⵏⵉ ⴰⵎⵢⴰⵏ ⵉⴷⴷⴰⵔⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","ⴰⴷ ⵉⵙⵙⴰⵔⵙ ⵀⴰⵔⵓⵏ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵏⴻⵙ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏ ⵓⵎⵢⴰⵏ ⵉⴷⴷⴰⵔⴻⵏ ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵉⵏⵄⴻⵎ ⵀⴰⵔⵓⵏ ⵙⴻⵏⵏⴻⵊ ⵉ ⵓⵣⴻⴵⵉⴼ ⵏ ⵓⵎⵢⴰⵏ ⵅ ⵎⴰⵔⵔⴰ ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴷ ⵎⴰⵔⵔⴰ ⵉⵅⴻⵟⵟⴰⵏ ⵏⵙⴻⵏ ⵉ ⴷⴷ-ⵢⵓⵙⵉⵏ ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⴷⴷⵏⵓⴱ ⵏⵙⴻⵏ ⵓⵛⴰ ⴰⴷ ⵜⴻⵏ ⵉⵙⵙⴰⵔⵙ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏ ⵓⵎⵢⴰⵏ ⵓⵛⴰ ⴰⴷ ⵜ ⵉⵙⵙⴻⴽⴽ ⵖⴰⵔ ⵍⴻⵅⵍⴰ ⵙ ⵓⴼⵓⵙ ⵏ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵡⴻⵏⵏⵉ ⵉⵙⵙⵡⴻⵊⴷⴻⵏ ⵉ ⴷⴷⴻⴳⴳⴰ. ");
INSERT INTO rift_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","ⵓⵛⴰ ⵉⵖⴰⵢⴹ ⴰⴷ ⵢⴰⵡⵉ ⴰⴽ-ⴷ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵎⴰⵔⵔⴰ ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ ⵏⵙⴻⵏ ⵖⴰⵔ ⵉⵛⵜ ⵏ ⵊⵊⵉⵀⴻⵜ ⵜⴻⵅⵍⴰ. ⵏⴻⵜⵜⴰ ⴰⴷ ⵉⵙⵙⴻⴽⴽ ⴰⵎⵢⴰⵏ ⵖⴰⵔ ⵍⴻⵅⵍⴰ. ");
INSERT INTO rift_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","ⵅⴻⵏⵏⵉ ⴰⴷ ⵢⴰⴷⴻⴼ ⵀⴰⵔⵓⵏ ⵖⴰⵔ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⵓⵛⴰ ⴰⴷ ⵉⴽⴽⴻⵙ ⴰⵔⵔⵓⴹ ⵏ ⵍⴻⵇⵟⴻⵏ ⵏⵏⵉ ⵢⴰⵔⴹ, ⵓⵎⵉ ⵢⵓⴷⴻⴼ ⵖⴰⵔ ⵓⵇⴻⴷⴷⴰⵙ ⵓⵛⴰ ⴰⴷ ⵜ ⵢⴻⵊⵊ ⴷⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","ⴰⴷ ⵉⵙⵙⵉⵔⴷ ⴰⵔⵔⵉⵎⴻⵜ ⵏⵏⴻⵙ ⵙ ⵡⴰⵎⴰⵏ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⴰⵎⵇⴻⴷⴷⴰⵙ ⵓⵛⴰ ⴰⴷ ⵢⴰⵔⴹ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ. ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⴼⴼⴻⵖ, ⴰⴷ ⵉⵙⵙⴻⵡⵊⴻⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵏⵏⴻⵙ ⴷ ⵜⵖⴰⵔⵚⵜ ⵏ ⵍⴳⴻⵏⵙ ⵓⵛⴰ ⴰⴷ ⵉⴳⴳ ⴰⵚⵍⴰⵃ ⵉ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵓ ⵉ ⵍⴳⴻⵏⵙ. ");
INSERT INTO rift_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","ⴰⴷ ⵉⵙⵙⴱⴻⵅⵅⴰⵔ ⵜⴰⴷⵓⵏⵜ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⵅ ⵓⵄⴰⵍⵟⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","ⵡⵉ ⴷⴷ-ⵉⵙⴻⴽⴽⴻⵏ ⴰⵎⵢⴰⵏ ⴰⵎ ⵓⵎⵢⴰⵏ ⵉⵏⵏⵓⴼⵙⵍⴻⵏ, ⴰⴷ ⵉⵚⴻⴱⴱⴻⵏ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ, ⴰⴷ ⵉⵙⵙⵉⵔⴷ ⴰⵔⵔⵉⵎⴻⵜ ⵏⵏⴻⵙ ⵙ ⵡⴰⵎⴰⵏ. ⴰⵡⴰⵔⵏⵉ ⴰⵙ ⴰⴷ ⵢⴰⴷⴻⴼ ⵖⴰⵔ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","ⴰⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⴷ ⵓⵎⵢⴰⵏ ⵏ ⵟⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⵉ ⵣⵉ ⵜⵜⵡⴰⵙⵙⵉⴷⴼⴻⵏ ⵉⴷⴰⵎⵎⴻⵏ ⵏⵙⴻⵏ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵣⵣⴰⵢⵙⴻⵏ ⵉⵜⵜⵡⴰⴳⴳ ⴰⵚⵍⴰⵃ ⴷⴻⴳ ⵓⵇⴻⴷⴷⴰⵙ, ⴰⴷ ⵜⴻⵏ ⵙⵙⵓⴼⴼⵖⴻⵏ ⴱⴰⵔⵔⴰ ⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵓⵛⴰ ⴰⴷ ⵣⵣⴰⵢⵙⴻⵏ ⵙⵙⵛⴻⵎⴹⴻⵏ ⵉⵍⵎⴰⵡⴻⵏ ⵏⵙⴻⵏ ⴷ ⵡⴻⵢⵙⵓⵎ ⵏⵙⴻⵏ ⴷ ⵓⵎⴻⵙⵙⴰⵍ ⵏⵙⴻⵏ ⵙ ⵜⵎⴻⵙⵙⵉ. ");
INSERT INTO rift_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","ⵡⵉ ⵜⴻⵏ ⵖⴰ ⵉⵙⵙⵛⴻⵎⴹⴻⵏ, ⴰⴷ ⵉⵚⴻⴱⴱⴻⵏ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ, ⴰⴷ ⵉⵙⵙⵉⵔⴷ ⴰⵔⵔⵉⵎⴻⵜ ⵏⵏⴻⵙ ⵙ ⵡⴰⵎⴰⵏ. ⴰⵡⴰⵔⵏⵉ ⴰⵙ ⴰⴷ ⵢⴰⴷⴻⴼ ⵖⴰⵔ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","ⵜⴰ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵚⴻⵢⵢⴻⵜ ⵉ ⵍⴻⴱⴷⴰ ⵉ ⴽⴻⵏⵏⵉⵡ. ⴷⴻⴳ ⵓⵢⵓⵔ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ, ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵄⴻⵛⵔⴰ ⵏ ⵓⵢⵓⵔ, ⴰⴷ ⵜⴻⵙⵙⵡⴰⴹⵄⴻⵎ ⵉⵅⴻⴼ ⵏⵡⴻⵎ ⵓⵛⴰ ⵡⴰⵔ ⵜⵜⴻⴳⴳⴻⵎ ⵓⵍⴰ ⴷ ⵉⵛⵜ ⵏ ⵍⵅⴻⴷⵎⴻⵜ, ⵏⵉⵖ ⵡⴻⵏⵏⵉ ⴷⴷ-ⵉⵅⴻⵍⵇⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵉⵖ ⵓⴱⴰⵔⵔⴰⵏⵉ ⵏⵏⵉ ⵉⵣⴻⴷⴷⵖⴻⵏ ⴷⵉ ⵍⵡⴻⵙⵜ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","ⵎⵉⵏⵣⵉ ⴷⴻⴳ ⵡⴰⵙⵙ ⵏⵏⵉ ⴰⴷ ⵉⵜⵜⵡⴰⴳⴳ ⵡⴻⵚⵍⴰⵃ ⵉ ⴽⴻⵏⵏⵉⵡ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜᵉⵜⵜⵡⴰⵙⵙⵉⵣⴻⴷⴳⴻⵎ. ⴽⴻⵏⵏⵉⵡ ⵎⴰⵔⵔⴰ ⴰⴷ ⵜᵉⵜⵜⵡⴰⵙⵙⵉⵣⴻⴷⴳⴻⵎ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","ⴰⵙⵙ ⵏⵏⵉ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵉⵊⵊ ⵡⴰⵙⵙ ⵏ ⵙⵙⴻⴱⵜ, ⴰⵔⵔⴰⵃⴻⵜ ⵜⵎⵓⵏ ⵉ ⴽⴻⵏⵏⵉⵡ. ⴰⴷ ⵜⴻⵙⵙⵡⴰⴹⵄⴻⵎ ⵉⵅⴻⴼ ⵏⵡⴻⵎ, ⴰⵇⴰ-ⵜⵜ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵚⴻⵢⵢⴻⵜ ⵉ ⵍⴻⴱⴷⴰ. ");
INSERT INTO rift_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","ⴰⴽⴻⵀⵀⴰⵏ, ⵡⴻⵏⵏⵉ ⴷⴻⵀⵏⴻⵏ ⵓ ⵍⴻⵇⵇⵎⴻⵏ ⵏⵉⵜⵏⵉ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏ ⴱⴰⴱⴰⵙ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⴰⴽⴻⵀⵀⴰⵏ, ⴰⴷ ⵉⴳⴳ ⴰⵚⵍⴰⵃ ⵓⵛⴰ ⴰⴷ ⵢⴰⵔⴹ ⴰⵔⵔⵓⴹ ⵏ ⵍⴻⵇⵟⴻⵏ, ⴰⵔⵔⵓⴹ ⵉⵇⴻⴷⴷⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","ⴰⴷ ⵉⴳⴳ ⴰⵚⵍⴰⵃ ⵅ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵓ ⵅ ⵜⵇⵉⴹⵓⵏⵜ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⵓ ⵅ ⵓⵄⴰⵍⵟⴰⵔ. ⴰⴷ ⵉⴳⴳ ⴰⵚⵍⴰⵃ ⵄⴰⵡⴻⴷ ⵅ ⵎⴰⵔⵔⴰ ⵉⴽⴻⵀⵀⴰⵏⴻⵏ ⵓ ⵅ ⵎⴰⵔⵔⴰ ⵍⴳⴻⵏⵙ ⵏ ⵡⴻⴳⵔⴰⵡ. ");
INSERT INTO rift_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","ⵜⴰ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵚⴻⵢⵢⴻⵜ ⵉ ⵍⴻⴱⴷⴰ ⵉ ⴽⴻⵏⵏⵉⵡ, ⵃⵉⵎⴰ ⴰⴷ ⵉⵜⵜⵡⴰⴳⴳ ⵡⴻⵚⵍⴰⵃ ⵅ ⵎⴰⵔⵔⴰ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵉ ⵎⴰⵔⵔⴰ ⴷⴷⵏⵓⴱ ⵏⵙⴻⵏ, ⵉⵛⵜ ⵏ ⵜⵡⴰⵍⴰ ⴷⴻⴳ ⵓⵙⴻⴳⴳⵯⴰⵙ.” ⵓⵛⴰ ⵉⴳⴳⴰ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵉⵡⴻⵚⵚⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“ⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⵓ ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵉⵏⵉ ⴰⵙⴻⵏ: ‘ⵡⴰ ⴷ ⴰⵡⴰⵍ ⵉ ⵉⵡⴻⵚⵚⴰ ⵙⵉⴷⵉ, ⵉⵇⵇⴰⵔ: ");
INSERT INTO rift_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","ⴽⵓⵍ ⴰⵔⵢⴰⵣ ⵣⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵡⴻⵏⵏⵉ ⵉⵖⴰⵔⵚⴻⵏ ⵉ ⵓⴼⵓⵏⴰⵙ ⵏⵉⵖ ⵉ ⵢⴻⵣⵎⴰⵔ ⵏⵉⵖ ⵉ ⵉⵖⴰⵢⴹ ⴷⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏⵉⵖ ⵡⴻⵏⵏⵉ ⵜ ⵉⵖⴰⵔⵚⴻⵏ ⴱⴰⵔⵔⴰ ⵉ ⵍⵎⴰⵔⴳⴻⵃ, ");
INSERT INTO rift_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","ⵎⴰⵛⴰ ⵡⴰⵔ ⵜ ⵢⵉⵡⵉ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜ-ⵉ-ⴷⴷ-ⵉⵙⵙⵇⴰⵔⵔⴻⴱ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵖⴰⵔ ⵙⵉⴷⵉ ⵣⵣⴰⵜ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ ⵏ ⵙⵉⴷⵉ, ⴰⴷ ⴰⵙ ⴷⴷ-ⵉⵜⵜⵡⴰⵃⵙⴻⴱ ⵉⴷⴰⵎⵎⴻⵏ ⵏⵏⵉ. ⵏⴻⵜⵜⴰ ⵉⵙⵙⵉⵣⵣⴻⵍ ⵉⴷⴰⵎⵎⴻⵏ, ⵙ ⵓⵢⴻⵏⵏⵉ ⴰⴷ ⵉⵜⵜⵡⴰⵇⴻⵙ ⵡⴻⵔⵢⴰⵣ ⵏⵏⵉ ⵣⵉ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ, ");
INSERT INTO rift_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","ⵎⴰⵃⴻⵏⴷ, ⵅⵎⵉ ⵖⴰ ⵇⴻⴷⴷⵎⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵜⵉⵖⴰⵔⵚⴰ ⵏⵙⴻⵏ, ⵜⵉⵏⵏⵉ ⵏⵏⵓⵎⴻⵏ ⵖⴰⵔⵔⵚⴻⵏ ⴱⴰⵔⵔⴰ ⴷⴻⴳ ⵉⵢⵢⴰⵔ, ⵏⵉⵜⵏⵉ ⴰⴷ ⵜⴻⵏⵜ ⴰⵡⵢⴻⵏ ⵖⴰⵔ ⵙⵉⴷⵉ, ⵖⴰⵔ ⵓⴽⴻⵀⵀⴰⵏ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⴻⵏⵜ ⵇⴻⴷⴷⵎⴻⵏ ⴷⵉⵏ ⴰⵎ ⵜⵖⴰⵔⵚⴰ ⵏ ⵍⴻⵀⵏⴰ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵉⵣⴻⴵⴻⵄ ⵉⴷⴰⵎⵎⴻⵏ ⵅ ⵓⵄⴰⵍⵟⴰⵔ ⵏ ⵙⵉⴷⵉ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⵓ ⵏⴻⵜⵜⴰ ⴰⴷ ⵉⵙⵙⴱⴻⵅⵅⴰⵔ ⵜⴰⴷⵓⵏⵜ ⴰⵎ ⵢⵉⵛⵜ ⵏ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵉⵜⵜⴼⵓⵃⴻⵏ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","ⵡⴰⵔ ⵜⵜⵇⴻⴷⴷⴰⵎⴻⵏ ⵄⴰⴷ ⵜⵉⵖⴰⵔⵚⴰ ⵏⵙⴻⵏ ⵉ ⵉⵎⵓⵢⴰⵏ ⵉⵊⴻⵏⵏⵉⵏ, ⵉⵏⵏⵉ ⴹⴻⴼⴼⴰⵔⴻⵏ ⵏⵉⵜⵏⵉ ⴰⵎ ⴰⵢⵜ ⵏ ⴼⴰⵔⵇ-ⵛⵛⵖⴻⵍ. ⵜⴰ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵚⴻⵢⵢⴻⵜ ⵉ ⵍⴻⴱⴷⴰ ⵉ ⵏⵉⵜⵏⵉ ⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵏⵙⴻⵏ.’ ");
INSERT INTO rift_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","ⴰⴷ ⴰⵙⴻⵏ ⵜⵉⵏⵉⴷ ⵄⴰⵡⴻⴷ: ‘ⴽⵓⵍ ⴰⵔⵢⴰⵣ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓ ⵏ ⵉⴱⴰⵔⵔⴰⵏⵉⵢⵢⴻⵏ, ⵉⵏⵏⵉ ⵉⴵⴰⵏ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏⵙⴻⵏ, ⵡⴻⵏⵏⵉ ⵉⵅⵙⴻⵏ ⴰⴷ ⵉⵙⵙⴱⴻⵅⵅⴰⵔ ⵉⵛⵜ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵏⵉⵖ ⵛⴰ ⵏ ⵟⴰⵖⴰⵔⵚⵜ ⵉ ⵖⴰⵔⴻⵙ, ");
INSERT INTO rift_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","ⵎⴰⵛⴰ ⵡⴰⵔ ⵜⵜ-ⵉ-ⴷⴷ-ⵢⵉⵡⵉ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ⵃⵉⵎⴰ ⴰⴷ ⵜⵜ ⵉⵙⵙⴻⵡⵊⴻⴷ ⵉ ⵙⵉⴷⵉ, ⴰⵔⵢⴰⵣ ⵏⵏⵉ ⴰⴷ ⵉⵜⵜⵡⴰⵇⴻⵙⵙ ⵣⵉ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ.’” ");
INSERT INTO rift_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“ⴽⵓⵍ ⵉⵊⵊ ⵣⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵏⵉⵖ ⵣⴻⴳ ⵉⴱⴰⵔⵔⴰⵏⵉⵢⵢⴻⵏ, ⵉⵏⵏⵉ ⵉⵣⴻⴷⴷⵖⴻⵏ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏⵙⴻⵏ, ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵉⵛⵛⴻⵏ ⵉⴷⴰⵎⵎⴻⵏ ⵎⴰⵎⵎⴻⵛ ⵎⴰ ⴳⴳⵉⵏ, ⵏⴻⵛⵛ ⴰⴷ ⵇⴻⵍⴱⴻⵖ ⵓⴷⴻⵎ ⵉⵏⵓ ⵅ ⵍⴻⵄⵎⴰⵔ ⵏⵏⵉ ⵉⵛⵛⴻⵏ ⵉⴷⴰⵎⵎⴻⵏ ⵏⵏⵉ, ⵓⵛⴰ ⴰⴷ ⵜ ⵇⴻⴹⵄⴻⵖ ⵣⵉ ⵍⵡⴻⵙⵟ ⵏ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","ⵎⵉⵏⵣⵉ ⵍⴻⵄⵎⴰⵔ ⵏ ⴰⵔⵔⵉⵎⴻⵜ ⴷⴻⴳ ⵉⴷⴰⵎⵎⴻⵏ ⵓⵛⴰ ⵏⴻⵛⵛ ⵡⵛⵉⵖ ⴰⵡⴻⵎ ⵉⴷⴰⵎⵎⴻⵏ ⵅ ⵓⵄⴰⵍⵟⴰⵔ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵣⵣⴰⵢⵙⴻⵏ ⵉⵜⵜⵡⴰⴳⴳ ⵡⴻⵚⵍⴰⵃ ⵉ ⵍⴻⵄⵎⵓⵔ ⵏⵡⴻⵎ, ⵎⵉⵏⵣⵉ ⵉⴷⴰⵎⵎⴻⵏ ⴷ ⵉⵏⴰ ⵉ ⵖⴰ ⵉⵡⵢⴻⵏ ⴰⵚⵍⴰⵃ ⵉ ⵍⴻⵄⵎⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","ⵅ ⵓⵢⴰ ⴰⵇⴰ ⵏⵏⵉⵖ ⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ: ⵓⵍⴰ ⴷ ⵉⵊⵊ ⵣⵣⴰⵢⵡⴻⵎ ⵡⴰⵔ ⵉⵜⵜⴻⵜⵜ ⵣⴻⴳ ⵉⴷⴰⵎⵎⴻⵏ, ⵓⵍⴰ ⴷ ⴰⴱⴰⵔⵔⴰⵏⵉ ⵉ ⵉⵣⴻⴷⴷⵖⴻⵏ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏⵡⴻⵎ ⵡⴰⵔ ⵉⵜⵜⴻⵜⵜ ⵉⴷⴰⵎⵎⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","ⴽⵓⵍ ⵉⵊⵊ ⵣⴻⴳ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓ ⵣⴻⴳ ⵉⴱⴰⵔⵔⴰⵏⵉⵢⵢⴻⵏ ⵉ ⵉⵣⴻⴷⴷⵖⴻⵏ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏⵡⴻⵎ, ⵡⴻⵏⵏⵉ ⵉⵢⵎⴰⵔⴻⵏ ⵉⵊⵊ ⵏ ⵓⵎⵓⴷⴷⴰⵔ ⵏⵉⵖ ⵉⵊⵊ ⵏ ⵡⴻⵊⴹⵉⴹ ⵏⵏⵉ ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵉⵜⵜⵡⴰⵛⵛ, ⴰⴷ ⵉⵙⵙⵉⵣⵣⴻⵍ ⵉⴷⴰⵎⵎⴻⵏ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⵜⴻⵏ ⵉⵙⵙⴷⵓⵔⵉⵢ ⵙ ⵓⵛⴰⵍ. ");
INSERT INTO rift_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","ⵎⵉⵏⵣⵉ ⵍⴻⵄⵎⴰⵔ ⵏ ⴽⵓⵍ ⴰⵢⵙⵓⵎ ⴷ ⵉⴷⴰⵎⵎⴻⵏ ⵏⵏⴻⵙ, ⴰⵇⴰ ⴰⵜⴻⵏ ⴷ ⵉⵊⵊⴻⵏ ⴰⴽ-ⴷ ⵍⴻⵄⵎⴰⵔ ⵏⵏⴻⵙ. ⵙ ⵓⵢⴻⵏⵏⵉ ⵏⵏⵉⵖ ⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ: ‘ⵡⴰⵔ ⵜⵜᵉⵜⵜⴻⵎ ⵣⴻⴳ ⵉⴷⴰⵎⵎⴻⵏ ⵏ ⵎⴰⵎⵎⴻⵛ ⵎⴰ ⵉⴳⴳⴰ ⵡⴻⵢⵙⵓⵎ!’, ⵎⵉⵏⵣⵉ ⵍⴻⵄⵎⴰⵔ ⵏ ⵎⴰⵔⵔⴰ ⴰⵢⵙⵓⵎ ⴷ ⵉⴷⴰⵎⵎⴻⵏ ⵏⵏⴻⵙ. ⵡⴻⵏⵏⵉ ⵣⵣⴰⵢⵙⴻⵏ ⵖⴰ ⵉⵛⵛⴻⵏ, ⴰⴷ ⵉⵜⵜⵡⴰⵇⴻⵙⵙ ⵣⵉ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","ⵎⴰⵔⵔⴰ ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵉⵛⵛⴻⵏ ⵣⴻⴳ ⵉⵛⵜ ⵏ ⵍⵅⴻⵛⴱⴻⵜ ⵏⵉⵖ ⵣⴻⴳ ⵉⵊⵊ ⵏ ⵓⵎⵓⴷⴷⴰⵔ ⵉⵎⴻⵣⵣⵇⴻⵏ, ⵎⴰ ⵏⴻⵜⵜⴰ ⵣⵉ ⵜⴰⵔⵡⴰ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵉⵖ ⵏⴻⵜⵜⴰ ⴷ ⵉⵊⵊ ⵏ ⵓⴱⴰⵔⵔⴰⵏⵉ, ⴰⴷ ⵉⵚⴻⴱⴱⴻⵏ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⵉⵙⵙⵉⵔⴷ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵙ ⵡⴰⵎⴰⵏ ⵓⵛⴰ ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ⴰⵍ ⵜⴰⵎⴻⴷⴷⵉⵜ. ⴰⵡⴰⵔⵏⵉ ⴰⵢⴰ ⴰⴷ ⵢⵉⵍⵉ ⵉⵣⴷⴻⴳ. ");
INSERT INTO rift_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","ⵎⴰⵍⴰ ⵡⴰⵔ ⵉⵙⵙⵉⵔⴷ ⴰⵔⵔⵓⴹ ⵓ ⵡⴰⵔ ⵉⵙⵙⵉⵔⴷ ⴰⵔⵔⵉⵎⴻⵜ ⵏⵏⴻⵙ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵢⴰⵔⴱⵓ ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ ⵏⵏⴻⵙ.” ");
INSERT INTO rift_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“ⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵛⴰ ⵉⵏⵉ ⴰⵙⴻⵏ: ‘ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ! ");
INSERT INTO rift_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","ⵡⴰⵔ ⵜⵜⴻⴳⴳⴻⵎ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⵜⴻⴳⴳⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⵎⴰⵏⵉ ⵜⵓⵖⴰ ⵜⵣⴻⴷⴷⵖⴻⵎ ⴽⴻⵏⵏⵉⵡ, ⵓ ⵡⴰⵔ ⵜᵉⵜⵜⴻⴳⴳⴻⵎ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⵜⴻⴳⴳⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ ⵎⴰⵏⵉ ⴽⴻⵏⵏⵉⵡ ⵖⴰ ⵏⴻⴷⵀⴻⵖ, ⵓ ⵡⴰⵔ ⵜᵉⵜⵜⴻⴳⴳⴻⵎ ⵄⵍⴰⵃⵙⴰⴱ ⵜⵉⵡⴻⵚⵚⴰ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","ⴰⴷ ⵜⴻⴳⴳⴻⵎ ⵍⴼⴰⵔⴰⵢⵉⴹ ⵉⵏⵓ ⵓⵛⴰ ⴰⴷ ⵜⴻⵃⴹⴰⵎ ⵜⵉⵡⴻⵚⵚⴰ ⵉⵏⵓ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴷⴰⵢⵙⴻⵏ ⵜⵓⵢⵓⵔⴻⵎ: ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ! ");
INSERT INTO rift_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","ⴰⴷ ⵜⴻⵃⴹⴰⵎ ⵜⵉⵡⴻⵚⵚⴰ ⵉⵏⵓ ⴷ ⵍⴼⴰⵔⴰⵢⵉⴹ ⵉⵏⵓ: ⴱⵏⴰⴷⴻⵎ ⵏⵏⵉ ⵜⴻⵏⵜ ⵉⵜⵜⴻⴳⴳⴻⵏ, ⴰⴷ ⵣⵣⴰⵢⵙⴻⵏⵜ ⵉⴷⴷⴰⵔ, ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ! ");
INSERT INTO rift_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","ⵓⵍⴰ ⴷ ⵉⵊⵊ ⴰⴷ ⴷⴷ-ⵉⵇⴰⵔⵔⴻⴱ ⵖⴰⵔ ⵛⴰ ⵏ ⵢⵉⵊⵊⴻⵏ ⵣⵉ ⵔⴰⴵ ⵏⵏⴻⵙ, ⵃⵉⵎⴰ ⴰⴷ ⵉⵙⵙⵄⴰⵔⵔⴰ ⵍⵄⴰⵔ ⵏⵏⴻⵙ: ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","ⵡⴰⵔ ⵜⵜⴻⵙⵙⵄⴰⵔⵔⵉ ⵛⴰ ⵍⵄⴰⵔ ⵏ ⴱⴰⴱⴰⵛ ⴷ ⵍⵄⴰⵔ ⵏ ⵢⴻⵎⵎⴰⵛ. ⴰⵇⴰ-ⵜⵜ ⴷ ⵢⴻⵎⵎⴰⵛ, ⵡⴰⵔ ⵜⵜⴻⵙⵙⵄⴰⵔⵔⵉ ⵛⴰ ⵍⵄⴰⵔ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","ⵍⵄⴰⵔ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⵏ ⴱⴰⴱⴰⵛ ⵡⴰⵔ ⵜ ⵜⵜⴻⵙⵙⵄⴰⵔⵔⵉ ⵛⴰ. ⴰⵇⴰ-ⵜ ⴷ ⵍⵄⴰⵔ ⵏ ⴱⴰⴱⴰⵛ. ");
INSERT INTO rift_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","ⵅ ⵍⵄⴰⵔ ⵏ ⵓⵍⵜⵎⴰⵛ, ⵢⴻⴵⵉⵙ ⵏ ⴱⴰⴱⴰⵛ ⵏⵉⵖ ⵢⴻⴵⵉⵙ ⵏ ⵢⴻⵎⵎⴰⵛ, ⵏⵉⵖ ⵏⴻⵜⵜⴰⵜ ⵜᵉⵜⵜⵡⴰⵅⵍⴻⵇ-ⴷⴷ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵉⵖ ⴱⴰⵔⵔⴰ ⵉ ⵜⴰⴷⴷⴰⵔⵜ, ⴰⵇⴰ ⵍⵄⴰⵔ ⵏⵏⴻⵙ ⵡⴰⵔ ⵜ ⵜⴻⵙⵙⵄⴰⵔⵔⵉ ⵛⴰ. ");
INSERT INTO rift_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","ⵅ ⵍⵄⴰⵔ ⵏ ⵢⴻⴵⵉⵙ ⵏ ⵎⵎⵉⵛ ⵏⵉⵖ ⵏ ⵢⴻⴵⵉⵙ ⵏ ⵢⴻⴵⵉⵛ, ⵡⴰⵔ ⵜⵜⴻⵙⵙⵄⴰⵔⵔⵉ ⵛⴰ ⵍⵄⴰⵔ ⵏⵙⴻⵏ ⵎⵉⵏⵣⵉ ⴰⵇⴰ ⴷ ⵍⵄⴰⵔ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","ⵡⴰⵔ ⵜⵜⴻⵙⵙⵄⴰⵔⵔⵉ ⵛⴰ ⵍⵄⴰⵔ ⵏ ⵢⴻⴵⵉⵙ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⵏ ⴱⴰⴱⴰⵛ, ⵜⴻⵏⵏⵉ ⴷⴷ-ⵉⵜⵜⵡⴰⵅⴻⵍⵇⴻⵏ ⵉ ⴱⴰⴱⴰⵛ. ⴰⵇⴰ-ⵜⵜ ⴷ ⵓⵍⵜⵎⴰⵛ. ");
INSERT INTO rift_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","ⵡⴰⵔ ⵜⵜⴻⵙⵙⵄⴰⵔⵔⵉ ⵛⴰ ⵍⵄⴰⵔ ⵏ ⵓⵍⵜⵎⴰⵙ ⵏ ⴱⴰⴱⴰⵛ. ⴰⵇⴰ-ⵜⵜ ⴷ ⵔⴰⴵ ⵏ ⴱⴰⴱⴰⵛ. ");
INSERT INTO rift_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","ⵡⴰⵔ ⵜⵜⴻⵙⵙⵄⴰⵔⵔⵉ ⵛⴰ ⵍⵄⴰⵔ ⵏ ⵓⵍⵜⵎⴰⵙ ⵏ ⵢⴻⵎⵎⴰⵛ, ⵎⵉⵏⵣⵉ ⵏⴻⵜⵜⴰⵜ ⴷ ⵔⴰⴵ ⵏ ⵢⴻⵎⵎⴰⵛ. ");
INSERT INTO rift_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","ⵡⴰⵔ ⵜⵜⴻⵙⵙⵄⴰⵔⵔⵉ ⵛⴰ ⵍⵄⴰⵔ ⵏ ⵓⵎⴰⵙ ⵏ ⴱⴰⴱⴰⵛ ⵓ ⵡⴰⵔ ⴷⴷ-ⵜⵜⵇⴰⵔⵔⴰⴱⴻⴷ ⵖⴰⵔ ⵜⴻⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ, ⴰⵇⴰ-ⵜⵜ ⴷ ⵄⴻⵏⵜⵉⵛ. ");
INSERT INTO rift_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","ⵡⴰⵔ ⵜⵜⴻⵙⵙⵄⴰⵔⵔⵉ ⵛⴰ ⵍⵄⴰⵔ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⵏ ⵎⵎⵉⵛ, ⴰⵇⴰ-ⵜⵜ ⴷ ⵜⴰⵎⵖⴰⵔⵜ ⵏ ⵎⵎⵉⵛ. ⵡⴰⵔ ⵜⵜⴻⵙⵙⵄⴰⵔⵔⵉ ⵛⴰ ⵍⵄⴰⵔ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","ⵡⴰⵔ ⵜⵜⴻⵙⵙⵄⴰⵔⵔⵉ ⵛⴰ ⵍⵄⴰⵔ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⵏ ⵓⵎⴰⵛ, ⴰⵇⴰ-ⵜ ⴷ ⵍⵄⴰⵔ ⵏ ⵓⵎⴰⵛ. ");
INSERT INTO rift_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","ⵡⴰⵔ ⵜⴻⵙⵙⵄⴰⵔⵔⵉ ⵛⴰ ⵍⵄⴰⵔ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⴷ ⵢⴻⴵⵉⵙ. ⵡⴰⵔ ⴷⴷ-ⵜⵜⴰⵡⵉ ⵛⴰ ⵢⴻⴵⵉⵙ ⵏ ⵎⵎⵉⵙ ⵏⵉⵖ ⵢⴻⴵⵉⵙ ⵏ ⵢⴻⴵⵉⵙ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⴻⵙⵙⵄⴰⵔⵔⵉⴷ ⵍⵄⴰⵔ ⵏⵏⴻⵙ. ⴰⵇⴰ ⴰⵜⴻⵏⵜ ⴷ ⵔⴰⴵ ⵏⵏⴻⵛ, ⴰⵇⴰ-ⵜⵜ ⴷ ⵉⵛⵜ ⵏ ⵜⵎⴻⵄⵎⵓⵍⵜ ⵉⴼⴻⵙⴷⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","ⵡⴰⵔ ⴷⴷ-ⵜⵜⴰⵡⵉ ⵜⴰⵎⵖⴰⵔⵜ ⴷ ⵜⴰⵛⵏⴰ ⴰⴽ-ⴷ ⵓⵍⵜⵎⴰⵙ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⵜ ⵜⵖⴻⵏⵏⴻⴷ ⴰⵎⵎⵓ, ⵅⵎⵉ ⵖⴰ ⵜⴻⵙⵙⵄⴰⵔⵔⵉⴷ ⵍⵄⴰⵔ ⵏⵏⴻⵙ ⴰⵎ ⵄⴰⴷ ⵜⴻⴷⴷⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","ⵡⴰⵔ ⴷⴷ-ⵜⵜⵇⴰⵔⵔⴰⴱ ⵛⴰ ⵖⴰⵔ ⵉⵛⵜ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⵅⵎⵉ ⵖⴰ ⵜⴻⵄⵣⴻⵍ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵣⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⵍⴻⵅⵎⴻⵊ ⵏⵏⴻⵙ ⵃⵉⵎⴰ ⴰⴷ ⵜⴻⵙⵙⵄⴰⵔⵔⵉⴷ ⵍⵄⴰⵔ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","ⵡⴰⵔ ⵜⵜᵉⵟⵟⴻⵚ ⴰⴽ-ⴷ ⵜⴻⵎⵖⴰⵔⵜ ⵏ ⵊⵊⴰⵔ ⵏⵏⴻⵛ, ⵎⴰⵖⴰⵔ ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵜⴼⴻⵙⴷⴻⴷ ⵉⵅⴻⴼ ⵏⵏⴻⵛ ⵣⵣⴰⵢⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","ⵡⴰⵔ ⵜⵜⴻⵊⵊⵉ ⴰⵔⵔⴰⵡ ⵏⵏⴻⵛ ⴰⴷ ⵥⵡⴰⵏ ⵖⴰⵔ ⵎⵓⵍⴰⴽ, ⵡⴰⵔ ⵙⵙⴻⵅⵙⴰⵔⴰ ⵉⵙⴻⵎ ⵏ ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵛ, ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ! ");
INSERT INTO rift_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","ⵡⴰⵔ ⵜⵜᵉⵟⵟⴻⵚ ⵛⴰ ⴰⴽ-ⴷ ⵛⴰ ⵏ ⵡⴻⵔⵢⴰⵣ ⴰⵎ ⵜᵉⵟⵟⴻⵚⴻⴷ ⴰⴽ-ⴷ ⵜⴻⵎⵖⴰⵔⵜ. ⴰⵇⴰ-ⵜⵜ ⴷ ⵊⵊⵄⵉⴼⴻⵛⵜ. ");
INSERT INTO rift_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","ⵡⴰⵔ ⴼⴻⵙⵙⴻⴷ ⵛⴰ ⵉⵅⴻⴼ ⵏⵏⴻⵛ ⴰⴽ-ⴷ ⵛⴰ ⵏ ⵍⴻⴱⵀⵉⵎⴻⵜ ⴰⵎ ⵜⴼⴻⵃⵃⵍⴻⴷ ⵉⵅⴻⴼ ⵏⵏⴻⵛ ⴰⴽⵉⴷⴻⵙ, ⵓ ⵜⴰⵎⵖⴰⵔⵜ ⵡⴰⵔ ⵜᵉⵜⵜⴱⴻⴷⴷⵉ ⵣⵣⴰⵜ ⵉ ⵍⴻⴱⵀⵉⵎⴻⵜ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⴼⴻⵙⴷⴻⴷ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵣⵣⴰⵢⴻⵙ. ⴰⵇⴰ ⴷ ⵉⵊⵊ ⵏ ⵓⵅⴻⴵⴻⴹ ⵉⴼⴻⵙⴷⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","ⵡⴰⵔ ⴼⴻⵙⵙⴷⴻⵎ ⵛⴰ ⵉⵅⴻⴼ ⵏⵡⴻⵎ ⵙ ⵎⴰⵔⵔⴰ ⵜⵉⵎⴻⵙⵍⴰⵢⵉⵏ-ⴰ, ⵎⵉⵏⵣⵉ ⵍⴻⴳⵏⵓⵙ ⵏⵏⵉ ⵉ ⵖⴰ ⵙⵙⵓⴼⴼⵖⴻⵖ ⵣⵣⴰⵜ ⵉ ⵓⵖⴻⵎⴱⵓⴱ ⵏⵡⴻⵎ, ⵜⵓⵖⴰ ⴼⴻⵙⵙⴷⴻⵏ ⵉⵅⴻⴼ ⵏⵙⴻⵏ ⵙ ⵎⴰⵔⵔⴰ ⵜⵉⵎⴻⵙⵍⴰⵢⵉⵏ-ⴰ. ");
INSERT INTO rift_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","ⵙ ⵓⵢⴻⵏⵏⵉ ⵜⴻⴷⵡⴻⵍ ⵜⴻⵎⵎⵓⵔⵜ ⵜⴻⴼⵙⴻⴷ ⵓⵛⴰ ⵏⴻⵛⵛ ⴰⴷ ⴰⵙ ⵅⴻⴵⵚⴻⵖ ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ ⵏⵏⴻⵙ, ⵓⵛⴰ ⴰⴷ ⵜⵄⵓⵇⵇ ⵜⴻⵎⵎⵓⵔⵜ ⵉⵎⴻⵣⴷⴰⵖ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","ⵎⴰⵛⴰ ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⵜⴻⵃⴹⴰⵎ ⵜⵉⵡⴻⵚⵚⴰ ⴷ ⵍⴼⴰⵔⴰⵢⵉⴹ ⵉⵏⵓ, ⵡⴰⵔ ⵜⵜⴻⴳⴳⴻⵎ ⵓⵍⴰ ⴷ ⵉⵛⵜ ⵏ ⵍⵃⴰⵊⵊⴻⵜ ⵣⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵄⴰⵢⴻⴼ-ⴰ, ⵏⵉⵖ ⵡⴻⵏⵏⵉ ⵣⵉ ⵜⴰⵔⵡⴰ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵓⵍⴰ ⴷ ⴰⴱⴰⵔⵔⴰⵏⵉ ⵏⵏⵉ ⵉⵣⴻⴷⴷⵖⴻⵏ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","ⵎⵉⵏⵣⵉ ⵉⵔⵢⴰⵣⴻⵏ ⵏ ⵜⴻⵎⵎⵓⵔⵜ, ⵉⵏⵏⵉ ⵜⵓⵖⴰ ⵇⴱⴻⵍ ⵏⵡⴻⵎ, ⴰⵇⴰ ⴳⴳⵉⵏ ⵎⴰⵔⵔⴰ ⵊⵊⵄⴰⵢⴻⴼ-ⴰ ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⵜⴻⴷⵡⴻⵍ ⵜⴻⵎⵎⵓⵔⵜ ⵜⴻⴼⵙⴻⴷ. ");
INSERT INTO rift_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","ⵡⴰⵔ ⵜⵜⴻⵊⵊⵉ ⵜⴰⵎⵎⵓⵔⵜ ⴰⴷ ⴽⴻⵏⵏⵉⵡ ⵜⵄⵓⵇⵇ ⵓⵎⵉ ⵜⵜ ⵜⴼⴻⵙⵙⴷⴻⵎ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⵄⵓⵇⵇ ⵜⴻⵎⵎⵓⵔⵜ ⵍⴳⴻⵏⵙ ⵏⵏⵉ ⵜⵓⵖⴰ ⴷⵉⵏ ⵇⴱⴻⵍ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","ⵎⵉⵏⵣⵉ ⵎⴰⵔⵔⴰ ⵉⵏⵏⵉ ⵉⴳⴳⵉⵏ ⵛⴰ ⵣⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵄⴰⵢⴻⴼ-ⴰ, ⴰⵇⴰ ⵍⴻⵄⵎⵓⵔ ⵉ ⵖⴰ ⵉⴳⴳⵉⵏ ⴰⵎⵎⵓ, ⴰⴷ ⵜⵜⵡⴰⵇⴻⴹⵄⴻⵏ ⵣⵉ ⵍⴳⴻⵏⵙ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","ⴰⴷ ⵜⴻⵃⴹⴰⵎ ⵎⵉⵏ ⴷ ⴰⵡⴻⵎ ⵓⵎⵓⵔⴻⵖ, ⵎⴰⵃⴻⵏⴷ ⵡⴰⵔ ⵜⴹⴻⴼⴼⴰⵔⴻⵎ ⵜⵉⵡⴻⵚⵚⴰ ⵢⵓⵔⵚⵓⴹⴻⵏ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⵜ ⴳⴳⵉⵏ ⵍⴻⴳⵏⵓⵙ ⵇⴱⴻⵍ ⵏⵡⴻⵎ. ⵡⴰⵔ ⵣⵣⴰⵢⵙⴻⵏⵜ ⵜⴼⴻⵙⵙⴷⴻⵎ ⵉⵅⴻⴼ ⵏⵡⴻⵎ, ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ!’” ");
INSERT INTO rift_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⵖⴰⵔ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“ⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵛⴰ ⵉⵏⵉ ⴰⵙⴻⵏ: ‘ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜⵉⵍⵉⵎ ⴷ ⵉⵎⵇⴻⴷⴷⴰⵙⴻⵏ, ⵎⵉⵏⵣⵉ ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ, ⴰⵇⴰ ⴰⵢⵉ ⴷ ⴰⵎⵇⴻⴷⴷⴰⵙ! ");
INSERT INTO rift_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","ⴽⵓⵍ ⵉⵊⵊ ⴰⴷ ⵉⵡⴻⵇⵇⴰⵔ ⵢⴻⵎⵎⴰⵙ ⴷ ⴱⴰⴱⴰⵙ ⵓⵛⴰ ⵓⵙⵙⴰⵏ ⵉⵏⵓ ⵏ ⵙⵙⴻⴱⵜ ⴰⴷ ⵜⴻⵏ ⵜⴻⵃⴹⴰⵎ, ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ! ");
INSERT INTO rift_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","ⵡⴰⵔ ⴷⴷⵉⴽⴽⵯⵉⵍⴻⵎ ⵖⴰⵔ ⵍ’ⴰⵚⵏⴰⵎ ⵓ ⵡⴰⵔ ⵜⵜⴻⴳⴳⴻⵎ ⵉ ⵢⵉⵅⴻⴼ ⵏⵡⴻⵎ ⵍⴻⵅⵢⴰⵍⴰⵜ ⵉⴼⴻⵙⵢⴻⵏ ⴷ ⵉⵔⴻⴱⴱⵉⵜⴻⵏ. ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ! ");
INSERT INTO rift_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","ⵅⵎⵉ ⵖⴰ ⵜⵇⴻⴷⴷⵎⴻⵏ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵍⴻⵀⵏⴰ ⵉ ⵙⵉⴷⵉ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⵜ ⵜⵇⴻⴷⴷⵎⴻⵎ ⵙ ⵉⵊⵊ ⵏ ⵡⴻⴱⵔⵉⴷ ⵉ ⵣⵉ ⵖⴰ ⵜᵉⵜⵜⵡⴰⵇⴻⴱⵍⴻⵎ ⵙ ⴰⵔⴹⴰ. ");
INSERT INTO rift_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜᵉⵜⵜⵡⴰⵛⵛ ⴷⴻⴳ ⵡⴰⵙⵙ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏⵡⴻⵎ ⵓⵍⴰ ⴷⵉ ⵜⵉⵡⴻⵛⵛⴰ ⴰⵡⴰⵔⵏⵉ ⴰⵙ. ⵎⵉⵏ ⵉⵇⵇⵉⵎⴻⵏ ⴰⵍ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵜⵍⴰⵜⴰ ⴰⴷ ⵉⵜⵜⵡⴰⵙⵙⴻⵛⵎⴻⴹ ⵙ ⵜⵎⴻⵙⵙⵉ. ");
INSERT INTO rift_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","ⵎⴰⵍⴰ ⵜᵉⵜⵜⵡⴰⵛⵛ ⵄⴰⴷ ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵜⵍⴰⵜⴰ, ⴰⴷ ⵜⵉⵍⵉ ⴷ ⵊⵊⵄⵉⴼⴻⵛⵜ, ⵡⴰⵔ ⵜᵉⵜⵜⵡⴰⵇⴻⴱⴱⴻⵍ ⵙ ⴰⵔⴹⴰ. ");
INSERT INTO rift_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","ⵡⵉ ⵣⵣⴰⵢⴻⵙ ⵖⴰ ⵉⵛⵛⴻⵏ ⴰⴷ ⵢⴰⵔⴱⵓ ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ ⵏⵏⴻⵙ, ⵎⵉⵏⵣⵉ ⵉⵙⵙⴻⵅⵙⴰⵔⴰ ⵎⵉⵏ ⵉⴵⴰⵏ ⴷ ⴰⵎⵇⴻⴷⴷⴰⵙ ⵏ ⵙⵉⴷⵉ ⵓⵛⴰ ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⵜⵜⵡⴰⵇⴻⵙⵙ ⴱⵏⴰⴷⴻⵎ ⵏⵏⵉ ⵣⵉ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","ⵎⴰⵍⴰ ⵜⴻⵎⵊⴰⵔⴻⵎ ⵚⵚⴰⴱⴻⵜ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵡⴻⵎ, ⵡⴰⵔ ⵎⴻⵊⵊⴰⵔ ⵛⴻⴽ ⵉⵢⵢⴰⵔ ⵏⵏⴻⵛ ⴰⵍ ⴰⵖⴻⵣⴷⵉⵙ ⴰⵏⴻⴳⴳⴰⵔ ⵏⵉⵖ ⴰⴷ ⵜⵊⴻⵎⵄⴻⴷ ⵎⵉⵏ ⵉⵇⵇⵉⵎⴻⵏ ⴰⵡⴰⵔⵏⵉ ⵜⴰⵎⴻⵢⵔⴰ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","ⵡⴰⵔ ⵍⴻⵇⵇⴻⴹ ⵓⴹⵉⵍ ⵏ ⵓⵎⴰⵔⵊⴻⵄ ⵏⵏⴻⵛ ⴽⵓⵍⵛⵉ, ⵡⴰⵔ ⵃⵔⵓⵡ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴷⵉⵏ ⵉⵇⵇⵉⵎⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⴷⴻⴳ ⵓⵎⴰⵔⵊⴻⵄ ⵏⵏⴻⵛ ⵏ ⵓⴹⵉⵍ. ⴰⴷ ⵜⴻⵊⵊⴻⴷ ⴰⵢⴰ ⵉ ⵓⵎⴻⵣⵍⵓⴹ ⵓ ⵉ ⵓⴱⴰⵔⵔⴰⵏⵉ, ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ! ");
INSERT INTO rift_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","ⵡⴰⵔ ⵜⵜⴰⵛⴰⵔ ⵓ ⵡⴰⵔ ⵙⵙⵅⴰⵔⵔⵉⵇ, ⵓⵍⴰ ⴷ ⵉⵊⵊ ⴰⴷ ⵉⵛⵎⴻⵜ ⵊⵊⴰⵔ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","ⵡⴰⵔ ⵜⵜⵊⴰⴵⴰⵎ ⵥⵓⵔ ⵙ ⵢⵉⵙⴻⵎ ⵉⵏⵓ. ⵡⴰⵔ ⵙⵙⴻⵅⵙⴰⵔⴰ ⵉⵙⴻⵎ ⵏ ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵛ. ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","ⵡⴰⵔ ⵙⵙⵃⵉⵙⵙⵉⴼ ⵊⵊⴰⵔ ⵏⵏⴻⵛ ⵏⵉⵖ ⴰⴷ ⵜ ⵜⴰⵛⴰⵔⴻⴷ. ⵡⴰⵔ ⵜⵜᵉⵟⵟⴻⴼ ⵍⵎⵓⵏⴻⵜ ⵏ ⵉⵛⴻⵡⵡⴰⵍⴻⵏ ⵣⵉ ⴵⵉⵍⴻⵜ ⴰⵍ ⵜⵉⵡⴻⵛⵛⴰ.    ");
INSERT INTO rift_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","ⵡⴰⵔ ⵜⵜⴻⴽⴽⵯⴰⵔ ⴰⴷⴻⵀⵛⵓⵔ ⵓ ⵡⴰⵔ ⵜⵜⴻⴳⴳ ⵛⴰ ⵎⵉⵏ ⴷⵉ ⵖⴰ ⵉⵏⵇⴰⵔⴻⴹ ⵓⴷⴰⵔⵖⴰⵍ, ⵎⴰⵛⴰ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜⴻⴳⴳⵯⴻⴷⴻⴷ ⴰⵔⴻⴱⴱⵉ, ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ! ");
INSERT INTO rift_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","ⵖⴰⵔ ⵡⴻⵃⴽⴰⵎ ⵡⴰⵔ ⵜⵜⵖⴻⵛⵛⵉⵎ. ⵡⴰⵔ ⵙⵄⵉⵣⵣⵉ ⴰⵎⴻⵣⵍⵓⴹ ⵓ ⵡⴰⵔ ⵙⵄⴻⴷⴷⵓ ⵖⴰⵔ ⴱⵓ-ⵜⵅⵓⴱⴰ. ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜⵃⴻⴽⵎⴻⴷ ⵅ ⵊⵊⴰⵔ ⵏⵏⴻⵛ ⵙ ⵓⵙⴻⴳⴳⴻⴷ. ");
INSERT INTO rift_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","ⵡⴰⵔ ⴳⴳⵓⵔ ⵊⴰⵔ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵛ ⵙ ⵓⵏⴻⵎⵎⴻⵎ, ⵡⴰⵔ ⵜⵜⴱⴻⴷⴷⵉ ⵅ ⵉⴷⴰⵎⵎⴻⵏ ⵏ ⵊⵊⴰⵔ ⵏⵏⴻⵛ, ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ! ");
INSERT INTO rift_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","ⵡⴰⵔ ⵛⴰⵔⵔⴻⵀ ⵓⵎⴰⵛ ⴷⴻⴳ ⵡⵓⵍ ⵏⵏⴻⵛ. ⴰⴷ ⵜⵄⴻⵍⵎⴻⴷ ⴰⵄⵍⴰⵎ ⵉ ⵊⵊⴰⵔ ⵏⵏⴻⵛ ⵓ ⵡⴰⵔ ⵜⴽⴻⵙⵙⵉⴷ ⴷⴷⴻⵏⴱ ⵅⴰⴽ ⵣⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","ⵡⴰⵔ ⵜⵜⴻⵏⵜⵉⵇⵉⵎ ⵏⵉⵖ ⴰⴷ ⵜⵅⴻⵎⵎⵍⴻⴷ ⴰⵏⵜⴰⵇⴻⵎ ⵅ ⵜⴰⵔⵡⴰ ⵏ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵛ. ⴰⴷ ⵜⴻⵅⵙⴻⴷ ⵊⵊⴰⵔ ⵏⵏⴻⵛ ⴰⵎⴻⵛⵏⴰⵡ ⵉⵅⴻⴼ ⵏⵏⴻⵛ, ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","ⴰⴷ ⵜⴻⵃⴹⴰⵎ ⵜⵉⵡⴻⵚⵚⴰ ⵉⵏⵓ. ⵡⴰⵔ ⵜⵜⵍⴻⵇⵇⴰⵎ ⵛⴰ ⵍⴻⴱⵀⵉⵎⴻⵜ ⵏⵏⴻⵛ ⴰⴽ-ⴷ ⵉⵊⵊ ⵏ ⵎⴰⵔⴽⴰ ⵏⵏⴻⵖⵏⵉ. ⵡⴰⵔ ⵣⴰⵔⵔⴻⵄ ⵜⵏⴰⵢⴻⵏ ⵏ ⵎⴰⵔⴽⴰⵜ ⵏ ⵣⵣⴰⵔⵉⵄⴻⵜ ⴷⴻⴳ ⵉⵢⵢⴰⵔ ⵏⵏⴻⵛ ⵓ ⵡⴰⵔ ⵢⴰⵔⵔⴻⴹ ⴰⵔⵔⵓⴹ ⵉⵜⵜⵡⴰⴳⴳⴻⵏ ⵙ ⵜⵏⴰⵢⴻⵏ ⵏ ⵎⴰⵔⴽⴰⵜ ⵏ ⵓⴽⴻⵜⵜⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","ⵎⴰⵍⴰ ⴰⵔⵢⴰⵣ ⵉⵟⵟⴻⵚ ⴰⴽ-ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵎⵖⴰⵔⵜ, ⵉⵛⵜ ⵏ ⵜⴰⵢⵢⴰ ⵉⵅⴹⴻⴱ ⵉ-ⵜⵜ ⵢⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵏⵏⴻⵖⵏⵉ, ⵎⴰⵛⴰ ⵡⴰⵔ ⵉⵜⵜⵡⴰⵅⴻⴵⴻⵚ ⵄⴰⴷ ⵜⵜⴰⵎⴰⵏ ⵏⵏⴻⵙ ⵏ ⵓⴼⴻⴽⴽⵉ ⵏⵉⵖ ⵜⴻⵎⵎⴻⵡⵛ ⴰⵙ ⵜⵍⴻⵍⵍⵉ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵢⵉⵍⵉ ⵍⴻⵃⵙⴰⴱ, ⵎⴰⵛⴰ ⵡⴰⵔ ⵜⵜⵡⴰⵏⴻⵇⵇⴻⵏ ⵛⴰ, ⵎⵉⵏⵣⵉ ⵏⴻⵜⵜⴰⵜ ⵜⵓⵖⴰ ⵄⴰⴷ ⵡⴰⵔ ⵜᵉⵜⵜⵡⴰⵃⴰⵔ ⵛⴰ. ");
INSERT INTO rift_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","ⵏⴻⵜⵜⴰ ⴰⴷ ⵢⴰⵡⵉ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵓⵎⴰⵔⵡⴰⵙ ⵏⵏⴻⵙ ⵉ ⵙⵉⴷⵉ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ⵉⵊⵊ ⵏ ⵉⵛⴰⵔⵔⵉ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⵓⵎⴰⵔⵡⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵅⴰⵙ ⵉⴳⴳ ⴰⵚⵍⴰⵃ ⵙ ⵉⵛⴰⵔⵔⵉ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵓⵎⴰⵔⵡⴰⵙ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⵉ ⴷⴷⴻⵏⴱ ⵏⵏⴻⵙ ⵉ ⵉⴳⴳⴰ ⵓⵛⴰ ⴷⴷⴻⵏⴱ ⵏⵏⴻⵙ ⵉ ⵉⴳⴳⴰ ⴰⴷ ⴰⵙ ⵉⵜⵜⵡⴰⵖⴼⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","ⵅⵎⵉ ⵖⴰ ⵜⴰⵡⴹⴻⵎ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵓⵛⴰ ⵜⴻⵥⵥⵓⵎ ⵄⵍⴰⵎ ⴽⵓⵍ ⵜⵉⵛⴻⵊⵊⵓⵔⴰ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵣⵣⴰⵢⵙⴻⵏⵜ ⵜⴻⵛⵛⴻⵎ, ⵅⴻⵏⵏⵉ ⵡⴰⵔ ⵜⵅⴻⵜⵜⵏⴻⵎ ‘ⵍⴻⵄⴷⴰⵍⵢⴻⵜ ⵏⵏⴻⵙ’, ⵜⴻⵏⵏⵉ ⴷ ⵍⵖⵉⴵⴻⵜ ⵏⵏⴻⵙ. ⵜⵍⴰⵜⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵡⴰⵔ ⵜⴻⵏⵜ ⵜⵅⴻⵜⵜⵏⴻⵎ, ⵡⴰⵔ ⵣⵣⴰⵢⵙⴻⵏⵜ ⵜⵜⴻⵜⵜⴻⵎ ⵛⴰ. ");
INSERT INTO rift_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","ⴷⴻⴳ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵡⵉⵙⵙ ⴰⵔⴻⴱⵄⴰ ⴰⴷ ⵜⵉⵍⵉ ⵎⴰⵔⵔⴰ ⵍⵖⵉⴵⴻⵜ ⵏⵏⴻⵙ ⵜⵇⴻⴷⴷⴻⵙ, ⵉ ⵓⵙⴻⵎⵖⴰⵔ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","ⴷⴻⴳ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵡⵉⵙⵙ ⵅⴻⵎⵙⴰ ⴰⴷ ⵜⴻⵛⵛⴻⵎ ⵍⵖⵉⴵⴻⵜ ⵏⵏⴻⵙ ⵓⵛⴰ ⵚⵚⴰⴱⴻⵜ ⵏⵏⴻⵙ ⴰⴷ ⵜⵜ ⵜⴻⵡⵛⴻⵎ ⵉ ⵢⵉⵅⴻⴼ ⵏⵡⴻⵎ. ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ! ");
INSERT INTO rift_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","ⵡⴰⵔ ⵜⵜⴻⵜⵜⴻⵎ ⵛⴰ ⴰⴽ-ⴷ ⵉⴷⴰⵎⵎⴻⵏ. ⵡⴰⵔ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⵜⴳⴻⵣⵣⵏⴻⵎ ⵏⵉⵖ ⴰⴷ ⵜⵛⴻⵖⵍⴻⵎ ⵉⵅⴻⴼ ⵏⵡⴻⵎ ⵙ ⵜⴱⴻⵣⴳⵉⵡⵜ. ");
INSERT INTO rift_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","ⵡⴰⵔ ⵜⵜⵃⴻⴼⴼⵉⵎ ⴰⵛⵓⵡⵡⴰⴼ ⵏ ⵓⵣⴻⴵⵉⴼ ⵏⵡⴻⵎ ⴷⴻⴳ ⵡⴻⵏⵏⴻⴹ ⵏⵏⴻⵙ ⵓ ⵡⴰⵔ ⵜⵜⴹⴻⵢⵢⵉⵄⴻⵎ ⵛⴰ ⵜⵎⴰ ⵏ ⵜⵎⴰⵔⵜ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","ⵡⴰⵔ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⵜⵛⴰⵔⴹⴻⵎ ⴰⵔⵔⵉⵎⴻⵜ ⵏⵡⴻⵎ ⵣⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⵢⵉⵊⵊ ⵏ ⵓⵎⴻⵜⵜⵉⵏ ⵏⵉⵖ ⴰⴷ ⵜⴰⵔⴻⵛⵎⴻⵎ ⵜⵉⴳⴳⴰⵣ ⴷⵉ ⴰⵔⵔⵉⵎⴻⵜ ⵏⵡⴻⵎ. ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ! ");
INSERT INTO rift_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","ⵡⴰⵔ ⵙⴷⴻⴵⵉ ⵢⴻⴵⵉⵛ, ⴰⴷ ⵜⵜ ⵜⴰⵔⵔⴻⴷ ⴷ ⵜⴰⵎⵖⴰⵔⵜ ⵏ ⴼⴰⵔⵇ-ⵛⵛⵖⴻⵍ, ⵃⵉⵎⴰ ⵡⴰⵔ ⵜⵡⴻⵟⵟⵉ ⵜⴻⵎⵎⵓⵔⵜ ⴷⵉ ⴼⴰⵔⵇ-ⵛⵛⵖⴻⵍ ⵓⵛⴰ ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⴻⵛⵛⵓⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵙ ⵍⴻⴼⴹⵉⵃⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","ⴰⴷ ⵜⴻⵃⴹⴰⵎ ⵓⵙⵙⴰⵏ ⵉⵏⵓ ⵏ ⵙⵙⴻⴱⵜ ⵓⵛⴰ ⴰⴷ ⵜⵡⴻⵇⵇⴰⵔⴻⵎ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵏⵓ ⵉⵇⴻⴷⴷⵙⴻⵏ. ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ! ");
INSERT INTO rift_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","ⵡⴰⵔ ⵜⵜⴷⵉⴽⴽⵡⵉⵍⴻⵎ ⵖⴰⵔ ⵢⵉⵏⵏⵉ ⵉⵙⵙⴰⵡⴰⵍⴰⵏ ⴰⴽ-ⴷ ⵉⵎⴻⵜⵜⴰⵏ ⵓ ⵖⴰⵔ ⵉⴳⴻⵣⵣⴰⵏⴻⵏ, ⵡⴰⵔ ⵖⴰⵔⵙⴻⵏ ⴰⵔⴻⵣⵣⴼⴻⵎ, ⵃⵉⵎⴰ ⴰⴷ ⵣⵣⴰⵢⵙⴻⵏ ⵜᵉⵜⵜⵡⴰⵅⴻⵎⵊⴻⵎ. ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ! ");
INSERT INTO rift_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","ⴰⴷ ⵜⴻⴽⴽⴰⵔⴻⴷ ⵉ ⵡⴻⵏⵏⵉ ⵖⴰⵔ ⵉⴵⴰ ⵓⵛⵓⵡⵡⴰⴼ ⵉⵛⴰⴱ ⵓⵛⴰ ⴰⴷ ⵜⵡⴻⵇⵇⴰⵔⴻⴷ ⵓⴷⴻⵎ ⵏ ⵉⵡⴻⵙⵙⵓⵔⴰ ⵓⵛⴰ ⴰⴷ ⵜⴻⴳⴳⵯⴻⴷⴻⴷ ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵛ. ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ! ");
INSERT INTO rift_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","ⵅⵎⵉ ⴽⵉⴷⴻⴽ ⵖⴰ ⵉⵣⴷⴻⵖ ⵉⵊⵊ ⵏ ⵓⴱⴰⵔⵔⴰⵏⵉ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵡⴻⵎ, ⵡⴰⵔ ⵜ ⵜⵜⴹⴻⴵⵎⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","ⴰⴱⴰⵔⵔⴰⵏⵉ, ⵡⴻⵏⵏⵉ ⵖⴰⵔⵡⴻⵎ ⵉⵣⴻⴷⴷⵖⴻⵏ, ⴰⴷ ⴰⵡⴻⵎ ⵢⵉⵍⵉ ⴰⵎ ⵢⵉⵊⵊⴻⵏ ⵣⵉ ⵜⴰⵔⵡⴰ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵡⴻⵎ. ⴰⴷ ⵜ ⵜⴻⵅⵙⴻⴷ ⴰⵎ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵛ, ⵎⵉⵏⵣⵉ ⵜⵓⵖⴰ ⴽⴻⵏⵏⵉⵡ ⴷ ⵉⴱⴰⵔⵔⴰⵏⵉⵢⵢⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ. ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ! ");
INSERT INTO rift_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","ⵅⵎⵉ ⵖⴰ ⵜⵉⵍⵉⵎ ⵖⴰⵔ ⵡⴻⵃⴽⴰⵎ ⵡⴰⵔ ⵜⵜⵖⴻⵛⵛⴻⵎ ⵛⴰ ⵙ ⵍⴻⵄⴱⴰⵔ ⵏ ⵜⵓⵣⵣⴻⴳⴳⴰⵔⵜ ⵏⵉⵖ ⵏ ⴷⴷⵇⴻⵍ ⵏⵉⵖ ⵙ ⵍⴻⵄⴱⴰⵔ ⵏ ⵎⵉⵏ ⴷⴰⵢⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","ⴰⴷ ⵖⴰⵔⵡⴻⵎ ⵢⵉⵍⵉ ⴷ ⵉⵊⵊ ⵏ ⵍⵎⵉⵣⴰⵏ ⵏⵉⵛⴰⵏ ⴷ ⵉⵥⵔⴰ ⵏ ⵍⵎⵉⵣⴰⵏ ⵏⵉⵛⴰⵏ ⵓⵍⴰ ⴷ ⵉⵊⵊ ⵏ ⵉⴼⴰ ⵏⵉⵛⴰⵏ ⴷ ⵉⵊⵊ ⵏ ⵓⵀⵉⵏⵓ ⵏⵉⵛⴰⵏ, ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ, ⵡⴻⵏⵏⵉ ⴽⴻⵏⵏⵉⵡ ⴷⴷ-ⵉⵙⵙⵓⴼⴼⵖⴻⵏ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","ⴰⴷ ⵜⴻⵃⴹⴰⵎ ⵎⴰⵔⵔⴰ ⵜⵉⵡⴻⵚⵚⴰ ⴷ ⵍⵓⵎⵓⵔ ⵉⵏⵓ ⵓⵛⴰ ⴰⴷ ⵜⴻⵏ ⵜⴻⴳⴳⴻⵎ. ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ!’” ");
INSERT INTO rift_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“ⴰⴷ ⵜⵉⵏⵉⴷ ⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ: ‘ⴽⵓⵍ ⵉⵊⵊⴻⵏ ⵣⴻⴳ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵏⵉⵖ ⵣⴻⴳ ⵉⴱⴰⵔⵔⴰⵏⵉⵢⵢⴻⵏ, ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵉⵡⵛⵉⵏ ⵣⴻⴳ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ ⵉ ⵎⵓⵍⴰⴽ, ⴰⴷ ⵉⵜⵜⵡⴰⵏⴻⵖ ⵏⵉⵛⴰⵏ. ⵍⴳⴻⵏⵙ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⴰⴷ ⵜ ⵢⴰⵔⵊⴻⵎ.    ");
INSERT INTO rift_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","ⵏⴻⵛⵛ ⴰⴷ ⵇⴻⵍⴱⴻⵖ ⵓⴷⴻⵎ ⵉⵏⵓ ⵅ ⵡⴻⵔⵢⴰⵣ ⵏⵏⵉ ⵓⵛⴰ ⴰⴷ ⵜ ⵇⴻⴹⵄⴻⵖ ⵣⵉ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ, ⵎⵉⵏⵣⵉ ⵏⴻⵜⵜⴰ ⴰⵇⴰ ⵉⵡⵛⴰ ⵣⵉ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵙ ⵉ ⵎⵓⵍⴰⴽ. ⵙ ⵓⵢⴻⵏⵏⵉ ⵜⵓⵖⴰ ⵉⵙⵙⴻⵅⵎⴻⵊ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵏⵓ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵓⵛⴰ ⵉⵙⵙⴻⵅⵙⴰⵔ ⵉⵙⴻⵎ ⴰⵎⵇⴻⴷⴷⴰⵙ ⵉⵏⵓ. ");
INSERT INTO rift_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","ⵎⴰⵍⴰ ⵜⴰⵔⵡⴰ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵇⵇⵏⴻⵏ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵙⴻⵏ ⵅ ⵡⴻⵔⵢⴰⵣ ⵏⵏⵉ, ⵅⵎⵉ ⵖⴰ ⵉⵡⵛ ⵏⴻⵜⵜⴰ ⵣⵉ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵙ ⵉ ⵎⵓⵍⴰⴽ, ⵓⵛⴰ ⵏⵉⵜⵏⵉ ⵡⴰⵔ ⵜ ⵏⴻⵇⵇⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ⵅⴻⵏⵏⵉ ⵏⴻⵛⵛ ⴰⴷ ⵇⴻⵍⴱⴻⵖ ⵓⴷⴻⵎ ⵉⵏⵓ ⵅ ⵡⴻⵔⵢⴰⵣ ⵏⵏⵉ ⵓ ⵅ ⵍⴰⴵ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⵜ ⵇⴻⴹⵄⴻⵖ ⵣⵉ ⵊⴰⵔ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ, ⵏⴻⵜⵜⴰ ⴷ ⵎⴰⵔⵔⴰ ⵉⵏⵏⵉ ⵉⵙⵙⴻⴼⵙⴰⴷⴻⵏ ⵉⵅⴻⴼ ⵏⵙⴻⵏ ⴰⵎ ⴷⴷⴻⴽⴽⵡⴰⵍⴻⵏ ⴰⵡⴰⵔⵏⵉ ⴰⵙ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵙⵙⴼⴻⵙⴷⴻⵏ ⵉⵅⴻⴼ ⵏⵙⴻⵏ ⴰⴽ-ⴷ ⵎⵓⵍⴰⴽ.’” ");
INSERT INTO rift_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“ⴱⵏⴰⴷⴻⵎ ⵏⵏⵉ ⵉ ⵖⴰ ⵉⵇⴻⵍⴱⴻⵏ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵖⴰⵔ ⵢⵉⵏⵏⵉ ⵉⵙⵙⴰⵡⴰⵍⴰⵏ ⴰⴽ-ⴷ ⵉⵎⴻⵜⵜⴰⵏ ⴷ ⵉⴳⴻⵣⵣⴰⵏⴻⵏ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴷⴻⵡⵍⴻⵏ ⴰⵡⴰⵔⵏⵉ ⴰⵙⴻⵏ ⴰⵎ ⵙⵙⴼⴻⵙⴷⴻⵏ ⵉⵅⴻⴼ ⵏⵙⴻⵏ, ⵏⴻⵛⵛ ⴰⴷ ⵇⴻⵍⴱⴻⵖ ⵓⴷⴻⵎ ⵉⵏⵓ ⵅ ⴱⵏⴰⴷⴻⵎ ⵏⵏⵉ ⵓⵛⴰ ⴰⴷ ⵜ ⵇⴻⴹⵄⴻⵖ ⵣⵉ ⵊⴰⵔ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ.”   ");
INSERT INTO rift_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“ⵙⵇⴻⴷⴷⵙⴻⵎ ⵉⵅⴻⴼ ⵏⵡⴻⵎ, ⵉⵍⵉⵎ ⴷ ⵉⵎⵇⴻⴷⴷⴰⵙⴻⵏ, ⵎⵉⵏⵣⵉ ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ! ");
INSERT INTO rift_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","ⵃⴹⴰⵎ ⵜⵉⵡⴻⵚⵚⴰ ⵉⵏⵓ ⵓⵛⴰ ⴳⴳⴻⵎ ⵣⵣⴰⵢⵙⴻⵏⵜ. ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⵡⴻⵏⵏⵉ ⴽⴻⵏⵏⵉⵡ ⵉⵙⵙⵇⴻⴷⴷⵙⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“ⵎⴰⵖⴰⵔ ⴽⵓⵍ ⴰⵔⵢⴰⵣ ⵏⵏⵉ ⵉ ⵖⴰ ⵉⵏⴻⵄⵍⴻⵏ ⵅ ⴱⴰⴱⴰⵙ ⵏⵉⵖ ⵅ ⵢⴻⵎⵎⴰⵙ, ⴰⴷ ⵉⵜⵜⵡⴰⵏⴻⵖ ⵏⵉⵛⴰⵏ. ⵉⵏⵄⴻⵍ ⵅ ⴱⴰⴱⴰⵙ ⵏⵉⵖ ⵅ ⵢⴻⵎⵎⴰⵙ, ⵉⴷⴰⵎⵎⴻⵏ ⵏⵏⴻⵙ ⴰⵇⴰ ⴰⵜⴻⵏ ⵅⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","ⵎⴰⵍⴰ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵉⵣⵏⴰ ⴰⴽ-ⴷ ⵜⴻⵎⵖⴰⵔⵜ ⵏ ⵡⴻⵔⵢⴰⵣ ⵏⵏⴻⵖⵏⵉ, ⵅⴻⵏⵏⵉ ⵡⴻⵏⵏⵉ ⵜⵓⵖⴰ ⵉⵣⴻⵏⵏⴰⵏ ⴰⴽ-ⴷ ⵜⴻⵎⵖⴰⵔⵜ ⵏ ⵊⵊⴰⵔ ⵏⵏⴻⵙ ⴰⴷ ⵉⵜⵜⵡⴰⵏⴻⵖ ⵏⵉⵛⴰⵏ, ⵡⴻⵏⵏⵉ ⵉⵣⵏⴰⵏ ⴷ ⵜⴻⵏⵏⵉ ⵉⵣⵏⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","ⵎⴰⵍⴰ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ, ⴰⵎ ⵉⵟⵟⴻⵚ ⴰⴽ-ⴷ ⵜⴻⵎⵖⴰⵔⵜ ⵏ ⴱⴰⴱⴰⵙ, ⴰⵇⴰ ⵉⵙⵙⵄⵓⵔⵔⵉ ⵍⵄⴰⵔ ⵏ ⴱⴰⴱⴰⵙ, ⵅⴻⵏⵏⵉ ⵏⵉⵜⵏⵉ ⵙ ⵜⵏⴰⵢⴻⵏ ⴰⴷ ⵜⵜⵡⴰⵏⵖⴻⵏ ⵏⵉⵛⴰⵏ. ⵉⴷⴰⵎⵎⴻⵏ ⵏⵙⴻⵏ ⴰⵇⴰ ⴰⵜⴻⵏ ⵅⴰⵙⴻⵏ.    ");
INSERT INTO rift_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","ⵎⴰⵍⴰ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵉⵟⵟⴻⵚ ⴰⴽ-ⴷ ⵜⴻⵎⵖⴰⵔⵜ ⵏ ⵎⵎⵉⵙ, ⵅⴻⵏⵏⵉ ⵏⵉⵜⵏⵉ ⵙ ⵜⵏⴰⵢⴻⵏ ⴰⴷ ⵜⵜⵡⴰⵏⵖⴻⵏ ⵏⵉⵛⴰⵏ. ⴰⵇⴰ ⴳⴳⵉⵏ ⵉⵊⵊ ⵏ ⵓⵅⴻⴵⴻⴹ ⵉⴼⴻⵙⴷⴻⵏ. ⵉⴷⴰⵎⵎⴻⵏ ⵏⵙⴻⵏ ⴰⵇⴰ ⴰⵜⴻⵏ ⵅⴰⵙⴻⵏ.    ");
INSERT INTO rift_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","ⵎⴰⵍⴰ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵉⵟⵟⴻⵚ ⴰⴽ-ⴷ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵏⵏⴻⵖⵏⵉ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵉⵜⵜⴻⵟⵟⴻⵚ ⵡⴻⵔⵢⴰⵣ ⴰⴽ-ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵎⵖⴰⵔⵜ, ⵅⴻⵏⵏⵉ ⴰⵇⴰ ⵏⵉⵜⵏⵉ ⵙ ⵜⵏⴰⵢⴻⵏ ⵉⴷⵙⴻⵏ ⴳⴳⵉⵏ ⵉⵛⵜ ⵏ ⵍⴻⴼⴹⵉⵃⴻⵜ ⵜⴻⵎⵖⴰⵔ. ⴰⴷ ⵜⵜⵡⴰⵏⵖⴻⵏ ⵏⵉⵛⴰⵏ. ⵉⴷⴰⵎⵎⴻⵏ ⵏⵙⴻⵏ ⴰⵇⴰ ⴰⵜⴻⵏ ⵅⴰⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","ⵎⴰⵍⴰ ⵉⵎⴻⵍⵛ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵛⴰ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⵓⵍⴰ ⴷ ⵢⴻⵎⵎⴰⵙ, ⴰⵇⴰ-ⵜⵜ ⴷ ⵍⴻⴼⴹⵉⵃⴻⵜ. ⴰⴷ ⵜ ⵙⵙⵛⴻⵎⴹⴻⵏ ⵙ ⵜⵎⴻⵙⵙⵉ, ⵏⴻⵜⵜⴰ ⴷ ⵏⵉⵜⴻⵏⵜⵉ ⵙ ⵜⵏⴰⵢⴻⵏ, ⵃⵉⵎⴰ ⵅⴻⵏⵏⵉ ⵡⴰⵔ ⵜᵉⵜⵜⵉⵍⵉ ⵄⴰⴷ ⴷ ⵍⴻⴼⴹⵉⵃⴻⵜ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","ⵎⴰⵍⴰ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵉⵚⵚⵓⵔ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⴰⴽ-ⴷ ⵉⵛⵜ ⵏ ⵍⴻⴱⵀⵉⵎⴻⵜ, ⵅⴻⵏⵏⵉ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵉⵜⵜⵡⴰⵏⴻⵖ ⵏⵉⵛⴰⵏ. ⵉⵜⵜⵅⴻⵚⵚⴰ ⵄⴰⵡⴻⴷ ⴰⴷ ⵜⴻⵏⵖⴻⵎ ⵍⴻⴱⵀⵉⵎⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","ⵎⴰⵍⴰ ⵛⴰ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⵜⵇⴰⵔⵔⴻⴱ-ⴷⴷ ⵖⴰⵔ ⵛⴰ ⵏ ⵍⴻⴱⵀⵉⵎⴻⵜ ⵎⴰⵎⵎⴻⵛ ⵎⴰ ⵜⴻⴳⴳⴰ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴽⵉⴷⴻⵙ ⵜⴼⴻⵃⵃⴻⵍ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⴻⵏⵖⴻⴷ ⵜⴰⵎⵖⴰⵔⵜ ⴷ ⵍⴻⴱⵀⵉⵎⴻⵜ. ⴰⴷ ⵜⵜⵡⴰⵏⵖⴻⵏ ⵏⵉⵛⴰⵏ. ⵉⴷⴰⵎⵎⴻⵏ ⵏⵙⴻⵏ ⴰⵇⴰ ⴰⵜⴻⵏ ⵅⴰⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","ⵎⴰⵍⴰ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵉⵟⵟⴻⴼ ⵓⵍⵜⵎⴰⵙ, ⵢⴻⴵⵉⵙ ⵏ ⴱⴰⴱⴰⵙ ⵏⵉⵖ ⵢⴻⴵⵉⵙ ⵏ ⵢⴻⵎⵎⴰⵙ, ⵓⵛⴰ ⵉⵥⵔⴰ ⵍⵄⴰⵔ ⵏⵏⴻⵙ ⵓⵛⴰ ⵏⴻⵜⵜⴰⵜ ⵜⴻⵥⵔⴰ ⵍⵄⴰⵔ ⵏⵏⴻⵙ, ⴰⵇⴰ-ⵜⵜ ⴷ ⵍⴻⴼⴹⵉⵃⴻⵜ. ⴰⴷ ⵜⵜⵡⴰⵏⵖⴻⵏ ⵙ ⵜⵏⴰⵢⴻⵏ ⵣⵣⴰⵜ ⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵜⴰⵔⵡⴰ ⵏ ⵍⴳⴻⵏⵙ ⵏⵙⴻⵏ. ⴰⵇⴰ ⵉⵙⵙⵄⵓⵔⵔⵉ ⵍⵄⴰⵔ ⵏ ⵓⵍⵜⵎⴰⵙ, ⴰⴷ ⵢⴰⵔⴱⵓ ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","ⵎⴰⵍⴰ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵉⵟⵟⴻⵚ ⴰⴽ-ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⵜⴻⵏⵏⵉ ⵅ ⵉⴵⴰ ⵉⴷⴰⵎⵎⴻⵏ ⵓⵛⴰ ⴰⵇⴰ ⵉⵙⵙⵄⵓⵔⵔⵉ ⵍⵄⴰⵔ ⵏⵏⴻⵙ, ⵉⵙⵙⵄⵓⵔⵔⵉ ⴰⵏⵓ ⵏ ⵉⴷⴰⵎⵎⴻⵏ ⵏⵏⴻⵙ, ⵓⵛⴰ ⵏⴻⵜⵜⴰⵜ ⵙⵉⵎⴰⵏⵜ ⵏⵏⴻⵙ ⵜⴻⵙⵙⵄⵓⵔⵔⵉ ⴰⵏⵓ ⵏ ⵉⴷⴰⵎⵎⴻⵏ ⵏⵏⴻⵙ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⵜⵡⴰⵇⴻⴹⵄⴻⵏ ⵙ ⵜⵏⴰⵢⴻⵏ ⵣⵉ ⵍⵡⴻⵙⵟ ⵏ ⵍⴳⴻⵏⵙ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","ⵡⴰⵔ ⵙⵄⴰⵔⵔⵉ ⵛⴰ ⵓⵍⵜⵎⴰⵙ ⵏ ⵢⴻⵎⵎⴰⵛ ⵏⵉⵖ ⵓⵍⵜⵎⴰⵙ ⵏ ⴱⴰⴱⴰⵛ, ⵎⵉⵏⵣⵉ ⵅⴻⵏⵏⵉ ⵉⵙⵙⴼⴻⵟⵟⴰⵃ ⴱⵏⴰⴷⴻⵎ ⵍⵄⴰⵔ ⵏ ⵔⴰⴵ ⵏⵏⴻⵙ. ⵏⵉⵜⵏⵉ ⴰⴷ ⴰⵔⴱⵓⵏ ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","ⵎⴰⵍⴰ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ, ⵡⴻⵏⵏⵉ ⵉⵜⵜᵉⵟⵟⵚⴻⵏ ⴰⴽ-ⴷ ⵄⴻⵏⵜⵉⵙ, ⴰⵇⴰ ⵉⵙⵙⵄⵓⵔⵔⵉ ⵍⵄⴰⵔ ⵏ ⵄⴻⵎⵎⵉⵙ, ⴰⴷ ⴰⵔⴱⵓⵏ ⵏⵉⵜⵏⵉ ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ ⵏⵙⴻⵏ. ⴰⴷ ⵎⵎⵜⴻⵏ ⴱⵍⴰ ⵜⴰⵔⵡⴰ.    ");
INSERT INTO rift_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","ⵎⴰⵍⴰ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵢⵉⵡⵉ ⵜⴰⵎⵖⴰⵔⵜ ⵏ ⵓⵎⴰⵙ, ⴰⵇⴰ ⵎⴰⵏ ⴰⵢⴰ ⴷ ⴰⵄⴻⴷⴷⵉ ⵅ ⵡⴻⵄⵣⴰⵍ ⵏ ⵜⴻⵎⵖⴰⵔⵜ. ⴰⵇⴰ ⵉⵙⵙⵄⵓⵔⵔⵉ ⵍⵄⴰⵔ ⵏ ⵓⵎⴰⵙ. ⴰⴷ ⵉⵍⵉⵏ ⴱⵍⴰ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ.’” ");
INSERT INTO rift_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“ⵃⴹⴰⵎ ⵎⴰⵔⵔⴰ ⵜⵉⵡⴻⵚⵚⴰ ⵉⵏⵓ ⴷ ⵎⴰⵔⵔⴰ ⵍⴼⴰⵔⴰⵢⵉⴹ ⵉⵏⵓ ⵓⵛⴰ ⴳⴳⴻⵎ ⵜⴻⵏⵜ, ⵎⴰⵃⴻⵏⴷ ⵡⴰⵔ ⴽⴻⵏⵏⵉⵡ ⵜᵉⵜⵜⵄⵓⵇⵇⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵎⴰⵏⵉ ⴽⴻⵏⵏⵉⵡ ⵉ ⵖⴰ ⵏⴻⴷⵀⴻⵖ, ⵃⵉⵎⴰ ⴰⴷ ⴷⴰⵢⴻⵙ ⵜⵣⴻⴷⵖⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","ⵡⴰⵔ ⴳⴳⵓⵔⴻⵎ ⵅ ⵜⴻⴱⵔⵉⴷⵜ ⵏ ⵜⵡⴻⵚⵚⴰ ⵏ ⵍⴳⴻⵏⵙ ⵏⵏⵉ ⵖⴰ ⵙⵙⵓⴼⴼⵖⴻⵖ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏⵡⴻⵎ, ⵎⵉⵏⵣⵉ ⵏⵉⵜⵏⵉ ⴳⴳⵉⵏ ⵎⴰⵔⵔⴰ ⵜⵉⵎⴻⵙⵍⴰⵢⵉⵏ-ⴰ ⵓ ⵙ ⵓⵢⴰ ⵛⴰⵔⵔⵀⴻⵖ ⵜⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","ⵏⴻⵛⵛ ⵏⵏⵉⵖ ⴰⵡⴻⵎ: ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⵜⵡⴰⵔⵜⴻⵎ ⵜⴰⵎⵎⵓⵔⵜ ⵏⵙⴻⵏ ⵓⵛⴰ ⴰⴷ ⴰⵡⴻⵎ ⵜⵜ-ⵉ-ⴷⴷ ⵡⵛⴻⵖ ⴷ ⵍⵡⴰⵔⵜ, ⵉⵛⵜ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵉⴼⴻⵢⵢⴹⴻⵏ ⵙ ⵓⵖⵉ ⴷ ⵜⴰⵎⵎⴻⵏⵜ. ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ, ⵡⴻⵏⵏⵉ ⴽⴻⵏⵏⵉⵡ ⵉⴼⴰⵔⵣⴻⵏ ⵣⵉ ⵊⴰⵔ ⵍⴻⴳⵏⵓⵙ. ");
INSERT INTO rift_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","ⵅ ⵓⵢⴰ ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⵜⵎⴻⵢⵢⵣⴻⵎ ⵊⴰⵔ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏ ⵍⴻⵃⵍⴰⵍ ⴷ ⵢⵉⵏⵏⵉ ⵉⵅⴻⵎⵊⴻⵏ ⵓ ⵊⴰⵔ ⵉⵊⴹⴰⴹ ⵉⵅⴻⵎⵊⴻⵏ ⴷ ⵢⵉⵏⵏⵉ ⵏ ⵍⴻⵃⵍⴰⵍ. ⵡⴰⵔ ⵙⵙⴻⵅⵙⴰⵔⴰⵎ ⵍⴻⵄⵎⵓⵍ ⵏⵡⴻⵎ ⴰⴽ-ⴷ ⵛⴰ ⵏ ⵍⴻⴱⵀⵉⵎⴻⵜ ⵏⵉⵖ ⴰⴽ-ⴷ ⵛⴰ ⵏ ⵡⴻⵊⴹⵉⴹ ⵏⵉⵖ ⴰⴽ-ⴷ ⵛⴰ ⵣⵉ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⵜⵜⴱⵓⵄⴻⵏ ⵅ ⵜⴻⵎⵎⵓⵔⵜ, ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴷ ⴰⵡⴻⵎ ⵃⴰⵔⵔⵎⴻⵖ, ⵃⵉⵎⴰ ⴰⴷ ⵜ ⵜⵃⴻⵙⴱⴻⵎ ⴷ ⵍⴻⵅⵎⴻⵊ.” ");
INSERT INTO rift_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","“ⴰⵇⴰ ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⴰⵢⵉ ⵜⵉⵍⵉⵎ ⴷ ⵉⵎⵇⴻⴷⴷⴰⵙⴻⵏ, ⵎⵉⵏⵣⵉ ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ ⴷ ⴰⵎⵇⴻⴷⴷⴰⵙ ⵓⵛⴰ ⵏⴻⵛⵛ ⴼⴰⵔⵣⴻⵖ ⴽⴻⵏⵏⵉⵡ ⵣⵉ ⵍⴻⴳⵏⵓⵙ, ⵃⵉⵎⴰ ⴰⴷ ⵜⵉⵍⵉⵎ ⵉⵏⵓ. ");
INSERT INTO rift_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","ⵎⴰⵍⴰ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵏⵉⵖ ⵉⵛⵜ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⵖⴰⵔⴻⵙ ⴱⵓⵃⴱⴻⵍ ⵏ ⵓⵄⴻⵣⵣⴻⵎ ⵏ ⵉⵎⴻⵜⵜⴰⵏ ⵏⵉⵖ ⵏ ⵜⴳⴻⵣⵣⴰⵏⵜ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⵜⵡⴰⵏⵖⴻⵏ ⵏⵉⵛⴰⵏ. ⴰⴷ ⵜⴻⵏ ⴰⵔⴻⵊⵎⴻⵏ. ⵉⴷⴰⵎⵎⴻⵏ ⵏⵙⴻⵏ ⴰⵇⴰ ⴰⵜⴻⵏ ⵅⴰⵙⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⵉⴽⴻⵀⵀⴰⵏⴻⵏ, ⴰⵔⵔⴰⵡ ⵏ ⵀⴰⵔⵓⵏ, ⵓⵛⴰ ⵉⵏⵉ ⴰⵙⴻⵏ: ‘ⵡⴰⵔ ⵉⵄⴻⴷⴷⴻⵍ ⵉ ⵓⵍⴰ ⴷ ⵉⵊⵊ ⵣⵣⴰⵢⵡⴻⵎ ⴰⴷ ⵉⵙⵙⴻⵅⵎⴻⵊ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵙ ⵉⵊⵊ ⵏ ⵓⵎⴻⵜⵜⵉⵏ ⵊⴰⵔ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","ⵎⵖⵉⵔ ⵙ ⵔⴰⴵ ⵏⵏⴻⵙ ⵢⵓⴷⵙⴻⵏ, ⵙ ⵢⴻⵎⵎⴰⵙ ⵏⵉⵖ ⵙ ⴱⴰⴱⴰⵙ ⵏⵉⵖ ⵙ ⵎⵎⵉⵙ ⵏⵉⵖ ⵙ ⵢⴻⴵⵉⵙ ⵏⵉⵖ ⵙ ⵓⵎⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ⵓⵍⴰ ⵙ ⵓⵍⵜⵎⴰⵙ ⵏⵏⵉ ⴷ ⵜⴰⵄⵣⴰⵔⵛⵜ, ⵜⴻⵏⵏⵉ ⴷ ⵍⴰⴵ ⵏⵏⴻⵙ ⵢⵓⴷⵙⴻⵏ ⵓ ⵡⴰⵔ ⵖⴰⵔⴻⵙ ⵜⵓⵖⵉ ⵡⴻⵔⵢⴰⵣ, ⴰⵇⴰ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵉⵙⵙⴻⵅⵎⴻⵊ ⵉⵅⴻⴼ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","ⴱⴰⴱ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵡⴰⵔ ⵉⵙⵙⵅⴻⵎⵎⴰⵊ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵊⴰⵔ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ. ⵙ ⵓⵢⴰ ⵉⵜⵜⵡⴰⴼ ⵉⵙⵙⴻⵅⵙⴰⵔ ⵉⵅⴻⴼ ⵏⵏⴻⵙ.” ");
INSERT INTO rift_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“ⵡⴰⵔ ⵜⵜⴻⴳⴳⴻⵏ ⵛⴰ ⵏ ⵡⴻⵎⵛⴰⵏ ⵉⵇⵓⵛⵛⴰⵔ ⵅ ⵉⵣⴻⴵⵉⴼ ⵏⵙⴻⵏ, ⵓ ⵡⴰⵔ ⵜⵜⵃⴻⴼⴼⵉⵏ ⵟⵟⴰⵔⴼ ⵏ ⵜⵎⴰⵔⵜ ⵏⵙⴻⵏ ⵓ ⵡⴰⵔ ⵛⴰⵔⵔⴹⴻⵏ ⴰⵛⴰⵔⵔⴻⴹ ⴷⴻⴳ ⵡⴻⵢⵙⵓⵎ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","ⴰⴷ ⵉⵍⵉⵏ ⴷ ⵉⵎⵇⴻⴷⴷⴰⵙⴻⵏ ⵉ ⴰⵔⴻⴱⴱⵉ ⵏⵙⴻⵏ ⵓⵛⴰ ⵡⴰⵔ ⴼⴻⵟⵟⵃⴻⵏ ⵉⵙⴻⵎ ⵏ ⴰⵔⴻⴱⴱⵉ ⵏⵙⴻⵏ, ⵎⵉⵏⵣⵉ ⴰⵇⴰ ⴷ ⵏⵉⵜⵏⵉ ⵉ ⵉⵜⵜⴰⵡⵢⴻⵏ ⵜⵉⵡⵀⵉⴱⵉⵏ ⵏ ⵜⵎⴻⵙⵙⵉ ⵖⴰⵔ ⴰⵔⴻⴱⴱⵉ, ⵜⵉⵏⵏⵉ ⴷ ⵎⴰⵛⵛⴰ ⵏ ⴰⵔⴻⴱⴱⵉ ⵏⵙⴻⵏ. ⵙ ⵓⵢⴰ ⴰⴷ ⵉⵍⵉⵏ ⴷ ⵉⵎⵇⴻⴷⴷⴰⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","ⵡⴰⵔ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⴰⵡⵢⴻⵏ ⵜⴰⵎⵖⴰⵔⵜ ⵏⵏⵉ ⵉⴵⴰⵏ ⴷ ⵍⴼⴰⵙⴷⴰ ⵏⵉⵖ ⵉⵛⵜⴻⵏ ⵜᵉⵜⵜⵡⴰⵖⵚⴻⴱ. ⵓⵍⴰ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⵏⵏⵉ ⵉⵜⵜⵡⴰⴵⴼⴻⵏ ⵣⴻⴳ ⵡⴻⵔⵢⴰⵣ ⵏⵏⴻⵙ, ⵡⴰⵔ ⵜⵜ ⵜⵜⵉⵡⵢⴻⵏ, ⵎⵉⵏⵣⵉ ⴰⴽⴻⵀⵀⴰⵏ ⴷ ⴰⵎⵇⴻⴷⴷⴰⵙ ⵉ ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","ⴰⴷ ⵜ ⵜⵃⴻⵙⴱⴻⴷ ⴷ ⴰⵎⵇⴻⴷⴷⴰⵙ, ⵎⵉⵏⵣⵉ ⵏⴻⵜⵜⴰ ⵉⵜⵜⴰⵡⵉ ⵎⴰⵛⵛⴰ ⵏ ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵛ. ⴰⴷ ⵢⵉⵍⵉ ⴷ ⴰⵎⵇⴻⴷⴷⴰⵙ ⵉ ⵛⴻⴽ, ⵎⵉⵏⵣⵉ ⵏⴻⵛⵛ ⴷ ⴰⵎⵇⴻⴷⴷⴰⵙ, ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ ⵡⴻⵏⵏⵉ ⴽⴻⵏⵏⵉⵡ ⵉⵙⵙⵇⴻⴷⴷⵙⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“ⵎⴰⵍⴰ ⵢⴻⴵⵉⵙ ⵏ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵏⵏⵉ ⵉⴵⴰⵏ ⴷ ⴰⴽⴻⵀⵀⴰⵏ ⵜⴻⵙⵙⴻⴼⴹⴻⵃ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵙ ⴼⴰⵔⵇ-ⵛⵛⵖⴻⵍ ⵏⵏⴻⵙ, ⵅⴻⵏⵏⵉ ⴰⵇⴰ ⵜⴻⵙⵙⴻⴼⴹⴻⵃ ⴱⴰⴱⴰⵙ ⵓⵛⴰ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⵙ ⴰⴷ ⵜᵉⵜⵜⵡⴰⵙⵙⴻⵛⵎⴻⴹ ⵙ ⵜⵎⴻⵙⵙⵉ.” ");
INSERT INTO rift_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“ⴰⵔⵔⴰⵢⵙ ⵏ ⵉⴽⴻⵀⵀⴰⵏⴻⵏ ⵊⴰⵔ ⴰⵢⵜⵎⴰⵙ, ⵡⴻⵏⵏⵉ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏⵏⴻⵙ ⵜᵉⵜⵜⵡⴰⴼⴰⵔⵔⴻⵖ ⵣⵣⴻⵛⵜ ⵏ ⵡⴻⴷⵀⴰⵏ ⵓ ⵡⴻⵏⵏⵉ ⵉⵜⵜⵡⴰⵍⴻⵇⵇⵎⴻⵏ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵢⴰⵔⴹ ⴰⵔⵔⵓⴹ ⵏ ⵓⴽⴻⵀⵀⴰⵏ, ⵏⴻⵜⵜⴰ ⵡⴰⵔ ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵉⴹⵍⴻⵇ ⵉ ⵓⵛⵓⵡⵡⴰⴼ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏⵏⴻⵙ ⵏⵉⵖ ⴰⴷ ⵉⵛⴰⵔⵔⴻⴳ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","ⵡⴰⵔ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⴷⴷ-ⵉⵇⴰⵔⵔⴻⴱ ⵖⴰⵔ ⵉⵊⵊ ⵏ ⵓⵎⴻⵜⵜⵉⵏ, ⵄⴰⴷ ⵙ ⴱⴰⴱⴰⵙ ⴷ ⵢⴻⵎⵎⴰⵙ ⵡⴰⵔ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⵉⵙⵙⴻⵅⵎⴻⵊ ⵉⵅⴻⴼ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","ⵡⴰⵔ ⵉⵜⵜⴻⴼⴼⴻⵖ ⵣⵉ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ, ⵃⵉⵎⴰ ⵡⴰⵔ ⵉⵙⵙⴻⵅⵙⴰⵔⴰ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵏ ⴰⵔⴻⴱⴱⵉ, ⵎⵉⵏⵣⵉ ⵜⵜⴰⵊ ⵏ ⵡⴻⵄⵣⴰⵍ ⵏ ⵣⵣⴻⵛⵜ ⵏ ⵡⴻⴷⵀⴰⵏ ⵏ ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵙ ⴰⵇⴰ-ⵜ ⵅⴰⵙ. ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ! ");
INSERT INTO rift_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","ⴰⴷ ⵢⴰⵡⵉ ⵉⵛⵜ ⵏ ⵜⴻⵄⵣⴰⵔⴻⵛⵜ ⴷ ⵜⴰⵎⵖⴰⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","ⵡⴰⵔ ⵉⵜⵜⵉⵡⵉ ⵜⴰⵊⵊⴰⵍⵜ ⵏⵉⵖ ⵜⴰⵏⴻⴵⴰⴼⵜ ⵏⵉⵖ ⵜⴻⵏⵏⵉ ⵉⵜⵜⵡⴰⵖⴻⵚⴱⴻⵏ ⴷ ⵜⴰⵎⵖⴰⵔⵜ, ⵎⴰⵛⴰ ⴰⴷ ⵢⴰⵡⵉ ⵉⵛⵜ ⵏ ⵜⴻⵄⵣⴰⵔⴻⵛⵜ ⵣⵉ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ ⴷ ⵜⴰⵎⵖⴰⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","ⵡⴰⵔ ⵉⵙⵙⴻⵅⵙⴰⵔⴰ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵙ ⵊⴰⵔ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ, ⵎⵉⵏⵣⵉ ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⵡⴻⵏⵏⵉ ⵜ ⵉⵙⵙⵇⴻⴷⴷⵙⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“ⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⵀⴰⵔⵓⵏ, ⵉⵏⵉ: ‘ⵓⵍⴰ ⴷ ⵉⵊⵊ ⵣⵉ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵛ ⴷⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵏⵙⴻⵏ ⵉ ⴷⵉ ⵉⴵⴰ ⵛⴰ ⵏ ⵓⵏⴻⵄⴹⴰⴱ, ⴰⴷ ⴷⴷ-ⵉⵇⴰⵔⵔⴻⴱ, ⵃⵉⵎⴰ ⴰⴷ ⵢⴰⵡⵉ ⵎⴰⵛⵛⴰ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","ⵎⵉⵏⵣⵉ ⵓⵍⴰ ⴷ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵡⴰⵔ ⴷⴷ-ⵉⵜⵜⵇⴰⵔⵔⵉⴱ ⵛⴰ ⵙ ⵢⵉⵊⵊ ⵏ ⵍⵄⵉⴱ, ⵎⴰ ⴷ ⴰⴷⴰⵔⵖⴰⵍ ⵉ ⵉⴵⴰ ⵏⵉⵖ ⴷ ⴰⵇⵉⴷⴰⵔ ⵏⵉⵖ ⵙ ⵛⴰ ⵡⴰⵔ ⵉⵃⵍⵉ ⵏⵉⵖ ⵖⴰⵔⴻⵙ ⵚⵚⵉⴼⴻⵜ ⵜⴼⴰⵔⵖ ");
INSERT INTO rift_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ⵏⵉⵖ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵢⴰⵔⵥ ⴰⵙ ⵓⴹⴰⵔ ⵏⵉⵖ ⴰⴼⵓⵙ ");
INSERT INTO rift_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ⵏⵉⵖ ⴱⵓ-ⵜⴻⵄⵔⵓⵔⵜ ⵏⵉⵖ ⵃⴻⴷ ⵢⴰⵍⵡⴻⵙ ⴷⵉ ⵛⴰ ⵏ ⵢⵉⵊⵊ ⵏ ⵜⵜⴻⵊⵊⴰⵍ ⵏⵉⵖ ⵙ ⵉⵛⵜ ⵏ ⵜⵉⵟⵟ ⵜⵓⴼⴼ ⵏⵉⵖ ⵙ ⵊⴷⴰⵎ ⵏⵉⵖ ⵙ ⵉⵛⵜ ⵏ ⵛⵛⴰⵎⴻⵜ ⵜⴻⵅⵙⴰⵔ ⵏⵉⵖ ⵙ ⵉⵇⴻⴵⴰⵍⴻⵏ ⵉⴷⴳⴻⴷⴳⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","ⵡⴰⵔ ⵉⵄⴻⴷⴷⴻⵍ ⵉ ⵓⵍⴰ ⴷ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵣⵉ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏ ⵓⴽⴻⵀⵀⴰⵏ ⵀⴰⵔⵓⵏ, ⵡⴻⵏⵏⵉ ⴷⵉ ⵉⴵⴰ ⵛⴰ ⵏ ⵍⵄⵉⴱ, ⴰⴷ ⵉⵔⴻⵃⵃⴻⴳ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⵇⴻⴷⴷⴻⵎ ⵜⵉⵡⵀⵉⴱⵉⵏ ⵏ ⵜⵎⴻⵙⵙⵉ ⵏ ⵙⵉⴷⵉ. ⴰⵇⴰ ⴷⴰⵢⴻⵙ ⴰⵏⴻⵄⴹⴰⴱ, ⵡⴰⵔ ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵉⴼⴼⴻⵖ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⵇⴻⴷⴷⴻⵎ ⵎⴰⵛⵛⴰ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","ⵣⵉ ⵎⴰⵛⵛⴰ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵙ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵢⴻⵛⵛ, ⴰⵎ ⵣⵉ ⵎⵉⵏ ⵉⴵⴰⵏ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵇⴰⵄ ⴰⵎ ⵣⵉ ⵎⵉⵏ ⵉⵇⴻⴷⴷⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","ⵎⴰⵛⴰ ⵡⴰⵔ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⴷⴷ-ⵉⵇⴰⵔⵔⴻⴱ ⵖⴰⵔ ⵓⵍⴻⵃⵃⴰⴼ ⵓⵍⴰ ⵖⴰⵔ ⵓⵄⴰⵍⵟⴰⵔ, ⵎⵉⵏⵣⵉ ⴷⴰⵢⴻⵙ ⵉⵛⵜ ⵏ ⵓⵏⴻⵄⴹⴰⴱ, ⵃⵉⵎⴰ ⵡⴰⵔ ⵉⵙⵙⴻⵅⵙⴰⵔⴰ ⵜⵉⵣⴰⵡⵉⵢⵢⵉⵏ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵉⵏⵓ, ⵎⵉⵏⵣⵉ ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ ⵡⴻⵏⵏⵉ ⵜⴻⵏ ⵉⵙⵙⵇⴻⴷⴷⵙⴻⵏ.’” ");
INSERT INTO rift_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","ⴰⵎⵎⵓ ⵉ ⵉⵙⵙⵉⵡⴻⵍ ⵎⵓⵙⴰ ⴰⴽ-ⴷ ⵀⴰⵔⵓⵏ ⵓ ⴰⴽ-ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⵓ ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“ⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⵀⴰⵔⵓⵏ ⵓ ⴰⴽ-ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ, ⵎⴰⵃⴻⵏⴷ, ⵎⴰⵍⴰ ⵉⵜⵜⵅⴻⵚⵚⴰ, ⵡⴰⵔ ⵜⵜⴰⴽⴽⵡⴰⴹⴻⵏ ⵖⴰⵔ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵜⵉⵏⵏⵉ ⴷ ⴰⵢⵉ ⵙⵙⵇⴻⴷⴷⵙⴻⵏ, ⵃⵉⵎⴰ ⵡⴰⵔ ⵙⵙⴻⵅⵙⴰⵔⴰⵏ ⵉⵙⴻⵎ ⴰⵎⵇⴻⴷⴷⴰⵙ ⵉⵏⵓ. ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ! ");
INSERT INTO rift_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","ⵉⵏⵉ ⴰⵙⴻⵏ: ‘ⵎⴰⵔⵔⴰ ⴰⵔⵢⴰⵣ ⵣⵉ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵡⴻⵎ ⴷⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵏⵡⴻⵎ, ⵡⴻⵏⵏⵉ ⴷⴷ ⵖⴰ ⵉⵇⴰⵔⵔⴱⴻⵏ ⵖⴰⵔ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵉⵇⴻⴷⴷⵙⴻⵏ, ⵜⵉⵏⵏⵉ ⵙⵙⵇⴻⴷⴷⵙⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵉ ⵙⵉⴷⵉ, ⴰⵎ ⵉⵅⵎⴻⵊ ⵏⴻⵜⵜⴰ, ⴰⵇⴰ ⴰⴷ ⵉⵜⵜⵡⴰⵇⴻⵙⵙ ⵍⴻⵄⵎⴰⵔ ⵏⵏⵉ ⵣⵉ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵉⵏⵓ. ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","ⵓⵍⴰ ⴷ ⵉⵊⵊⴻⵏ ⵣⵉ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏ ⵀⴰⵔⵓⵏ ⵏⵏⵉ ⴷⵉ ⵉⴵⴰ ⵍⴱⴰⵔⵚ ⵏⵉⵖ ⵡⴻⵏⵏⵉ ⵖⴰⵔ ⵉⴵⴰ ⵓⵙⴻⵢⵢⴻⵍ, ⵡⴰⵔ ⵉⵜⵜⴻⵜⵜ ⵣⵉ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵉⵇⴻⴷⴷⵙⴻⵏ ⴰⵍ ⵖⴰ ⵢⵉⵍⵉ ⵉⵣⴷⵉⴳ. ⵡⴻⵏⵏⵉ ⵉⵃⴰⴷⴰⵏ ⵛⴰ ⵣⵉ ⵎⵉⵏ ⵉⵜⵜⵡⴰⵙⵙⵅⴻⵎⵊⴻⵏ ⵙ ⵉⵊⵊ ⵏ ⵓⵎⴻⵜⵜⵉⵏ ⵏⵉⵖ ⵙ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵏⵏⵉ ⵜⵓⵖⴰ ⵙ ⵓⵙⴻⵢⵢⴻⵍ ⵏ ⵡⴰⴵⵓ, ");
INSERT INTO rift_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","ⵏⵉⵖ ⵙ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵏⵏⵉ ⵉⵃⴰⴷⴰⵏ ⵛⴰ ⵎⵉⵏ ⵉⵜⵜⴱⵓⵄⴻⵏ ⵉ ⵣⵉ ⵉⴷⵡⴻⵍ ⵉⵅⵎⴻⵊ, ⵏⵉⵖ ⵉⵃⴰⴷⴰ ⵉⵊⵊ ⵏ ⴱⵏⴰⴷⴻⵎ ⵉ ⵣⵉ ⵉⴷⵡⴻⵍ ⵉⵅⵎⴻⵊ ⵙ ⵎⴰⵎⵎⴻⵛ ⵎⴰ ⵜⴻⴳⴳⴰ ⵜⴻⵅⵎⵓⵊⵉ ⵏⵏⴻⵙ, ");
INSERT INTO rift_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","ⵍⴻⵄⵎⴰⵔ ⵏⵏⵉ ⵉⵃⴰⴷⴰⵏ ⵜⵎⴻⵙⵍⴰⵛⵜ ⵏⵉⵖ ⴱⵏⴰⴷⴻⵎ ⵏⵏⵉ ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ⴰⵍ ⵜⴰⵎⴻⴷⴷⵉⵜ, ⵡⴰⵔ ⵉⵜⵜⴻⵜⵜ ⵣⵉ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵉⵇⴻⴷⴷⵙⴻⵏ, ⵎⵖⵉⵔ ⴰⵡⴰⵔⵏⵉ ⵉ ⵖⴰ ⵉⵙⵙⵉⵔⴷ ⴰⵔⵔⵉⵎⴻⵜ ⵏⵏⴻⵙ ⵙ ⵡⴰⵎⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","ⵅⵎⵉ ⴷⴷ ⵖⴰ ⵜⴻⵖⵍⵉ ⵜⴼⵓⵛⵜ, ⴰⴷ ⵢⵉⵍⵉ ⵉⵣⴷⵉⴳ. ⴰⵡⴰⵔⵏⵉ ⴰⵢⴰ ⴰⴷ ⵢⴻⵛⵛ ⵣⵉ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵉⵇⴻⴷⴷⵙⴻⵏ, ⵎⵉⵏⵣⵉ ⴰⵇⴰ ⴰⵜⴻⵏⵜ ⴷ ⵎⴰⵛⵛⴰ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","ⵡⴰⵔ ⵉⵜⵜⴻⵜⵜ ⵣⴻⴳ ⵉⵛⵜ ⵏ ⵍⵅⴻⵛⴱⴻⵜ ⵏⵉⵖ ⵣⴻⴳ ⵉⵊⵊ ⵏ ⵓⵎⵓⴷⴷⴰⵔ ⵉⵎⴻⵣⵣⵇⴻⵏ, ⵎⵉⵏⵣⵉ ⵣⵣⴰⵢⴻⵙ ⵉ ⵖⴰ ⵉⵙⵙⴻⵅⵎⴻⵊ ⵉⵅⴻⴼ ⵏⵏⴻⵙ, ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ! ");
INSERT INTO rift_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","ⴰⴷ ⵃⴹⴰⵏ ⵎⵉⵏ ⵅⴻⴼ ⵜⴻⵏ ⵡⴻⵚⵚⵉⵖ, ⵃⵉⵎⴰ ⵡⴰⵔ ⵙⵙⴰⵔⴻⴱⴱⵓⵏ ⵅ ⵢⵉⵅⴻⴼ ⵏⵙⴻⵏ ⴷⴷⴻⵏⴱ ⵓ ⵅⴻⵏⵏⵉ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵎⵎⵜⴻⵏ, ⵅⵎⵉ ⵖⴰ ⵙⵙⵄⵉⴵⵜⴻⵏ ⴰⵢⴰ. ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ ⵡⴻⵏⵏⵉ ⵜⴻⵏ ⵉⵙⵙⵇⴻⴷⴷⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","ⵓⵍⴰ ⴷ ⵉⵊⵊ ⵏ ⵓⴱⴰⵔⵔⴰⵏⵉ ⵡⴰⵔ ⵉⵜⵜⴻⵜⵜ ⵣⵉ ⵜⴻⵡⵀⵉⴱⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ. ⴰⵎⵄⴻⵣⵣⴻⴱ ⵉ ⵉⵣⴻⴷⴷⵖⴻⵏ ⵊⴰⵔ ⵉⴽⴻⵀⵀⴰⵏⴻⵏ ⵓⵍⴰ ⴷ ⴰⵛⴻⵡⵡⴰⵍ ⵡⴰⵔ ⵜⵜᵉⵜⵜⴻⵏ ⵣⵉ ⵜⴻⵡⵀⵉⴱⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⴰⴽⴻⵀⵀⴰⵏ ⵉⵙⵖⴰ ⵉⵊⵊ ⵏ ⴱⵏⴰⴷⴻⵎ ⵙ ⵏⵏⵓⵇⴰⵔⵜ ⵏⵏⴻⵙ, ⴰⵇⴰ ⵉⵄⴻⴷⴷⴻⵍ ⵉ ⵡⴰ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵢⴻⵛⵛ ⵣⵉ ⵎⴰⵛⵛⴰ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ, ⵓⵍⴰ ⵉ ⵢⵉⵏⵏⵉ ⴷⴷ-ⵉⵜⵜⵡⴰⵅⴻⵍⵇⴻⵏ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","ⵎⴰⵍⴰ ⵢⴻⴵⵉⵙ ⵏ ⵓⴽⴻⵀⵀⴰⵏ ⵜⴻⴷⵡⴻⵍ ⴷ ⵜⴰⵎⵖⴰⵔⵜ ⵏ ⵉⵊⵊ ⵏ ⵓⴱⴰⵔⵔⴰⵏⵉ, ⵡⴰⵔ ⵜᵉⵜⵜⴻⵜⵜ ⵛⴰ ⵣⵉ ⵜⴻⵡⵀⵉⴱⵜ ⵉ ⴷⴷ-ⵉⵜⵜⵡⴰⵙⵙⴳⴻⵄⵄⴷⴻⵏ ⵣⵉ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵉⵇⴻⴷⴷⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⵢⴻⴵⵉⵙ ⵏ ⵓⴽⴻⵀⵀⴰⵏ ⴰⵇⴰ-ⵜⵜ ⴷ ⵜⴰⵊⵊⴰⵍⵜ ⵏⵉⵖ ⵜᵉⵜⵜⵡⴰⴵⴻⴼ ⵣⴻⴳ ⵡⴻⵔⵢⴰⵣ ⵏⵏⴻⵙ ⵓⵛⴰ ⵡⴰⵔ ⵖⴰⵔⴻⵙ ⴰⵃⴻⵏⵊⵉⵔ ⵓⵛⴰ ⵜⴻⴷⵡⴻⵍ-ⴷⴷ ⵖⴰⵔ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⴱⴰⴱⴰⵙ, ⴰⵎ ⴷⵉ ⵜⴻⵎⵥⵉ ⵏⵏⴻⵙ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⴻⵛⵛ ⵣⵉ ⵎⴰⵛⵛⴰ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⴱⴰⴱⴰⵙ, ⵎⴰⵛⴰ ⵓⵍⴰ ⴷ ⵉⵊⵊ ⵏ ⵓⴱⴰⵔⵔⴰⵏⵉ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵢⴻⵛⵛ. ");
INSERT INTO rift_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","ⵎⴰⵍⴰ ⵛⴰ ⵏ ⵢⵉⵊⵊⴻⵏ ⵉⵛⵛⴰ ⵣⵉ ⵜⴻⵡⵀⵉⴱⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵙ ⵓⵡⴻⴷⴷⴰⵔ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵖⴰⵔⴻⵙ ⵢⴰⵔⵏⵉ ⵜⴰⵙⵖⴰⵔⵜ ⵏ ⵜⴻⵅⵎⵓⵙⴻⵛⵜ ⵓⵛⴰ ⴰⴷ ⵢⴰⵔⵔ ⵜⴰⵡⵀⵉⴱⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵖⴰⵔ ⵓⴽⴻⵀⵀⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","ⵡⴰⵔ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⵙⵙⴻⵅⵙⴰⵔⴻⵏ ⵜⵉⵡⵀⵉⴱⵉⵏ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵜⵉⵏⵏⵉ ⵙⵙⴳⴻⵄⵄⴷⴻⵏ ⵏⵉⵜⵏⵉ ⵖⴰⵔ ⵙⵉⴷⵉ, ");
INSERT INTO rift_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","ⴰⵍⴰⵎⵉ ⵉ ⵖⴰ ⵙⵙⴰⵔⴱⵓⵏ ⴰⵎⴰⵔⵡⴰⵙ ⵏ ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ ⵅ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵢⵉⵍ, ⵓⵎⵉ ⵖⴰ ⵛⵛⴻⵏ ⵏⵉⵜⵏⵉ ⵣⵉ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵏⵙⴻⵏ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵉ ⴷ ⵢⴰⵡⵢⴻⵏ ⵏⵉⵜⵏⵉ ⵙ ⵢⵉⵅⴻⴼ ⵏⵙⴻⵏ, ⵎⵉⵏⵣⵉ ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⵡⴻⵏⵏⵉ ⵜⴻⵏ ⵉⵙⵙⵇⴻⴷⴷⵙⴻⵏ.’” ");
INSERT INTO rift_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“ⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⵓ ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵛⴰ ⵉⵏⵉ ⴰⵙⴻⵏ: ‘ⴷ ⵎⴰⵏ ⴰⵢⴰ ⵉⴳⴳⵓⵔ ⵉ ⴽⵓⵍ ⵉⵊⵊⴻⵏ ⵣⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓ ⵉ ⵉⴱⴰⵔⵔⴰⵏⵉⵢⵢⴻⵏ ⴷⵉ ⵉⵙⵔⴰⵉⵍ, ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵢⵉⵡⵢⴻⵏ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵜⴻⵏⵏⵉ ⴷⴷ-ⵢⵓⵙⵉⵏ ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⵍⴻⵡⵄⵓⴷ ⵏⵙⴻⵏ ⴷ ⵎⴰⵔⵔⴰ ⵜⵉⵡⵀⵉⴱⵉⵏ ⵏⵙⴻⵏ ⵏⵏⵉ ⵡⵛⵉⵏ ⵙ ⵍⵅⴰⴹⴰⵔ, ⵜⴻⵏⵏⵉ ⵇⴻⴷⴷⵎⴻⵏ ⵏⵉⵜⵏⵉ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴽⴻⵏⵏⵉⵡ ⵢⴰⵔⵔ ⴰⴷ ⵜⵉⵍⵉⵎ ⵜᵉⵜⵜⵡⴰⵇⴻⴱⴱⵍⴻⵎ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜⵉⵍⵉ ⵜⴻⵡⵀⵉⴱⵜ ⴷ ⵉⵊⵊ ⵏ ⵡⴻⵡⵜⴻⵎ ⵉⵛⵏⴰⵏ ⵇⴰⵄ ⵣⴻⴳ ⵉⴼⵓⵏⴰⵙⴻⵏ ⵏⵉⵖ ⵣⴻⴳ ⵉⵣⵎⴰⵔⴻⵏ ⵏⵉⵖ ⵣⴻⴳ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","ⵡⴰⵔ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⵜⵇⴻⴷⴷⵎⴻⵎ ⵛⴰ ⵏ ⵍⵎⴰⵍ ⴷⴰⵢⴻⵙ ⴰⵏⴻⵄⴹⴰⴱ, ⵎⵉⵏⵣⵉ ⴰⵢⴰ ⵡⴰⵔ ⴽⴻⵏⵏⵉⵡ ⴷⴷ-ⵉⵜⵜⴰⵔⵔⵉ ⴰⴷ ⴷⴰⵢⵡⴻⵎ ⵉⵜⵜⵡⴰⴼ ⴰⵔⴹⴰ. ");
INSERT INTO rift_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","ⵎⴰⵍⴰ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵉⵇⴻⴷⴷⴻⵎ ⵉⵛⵜ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵍⴻⵀⵏⴰ ⵖⴰⵔ ⵙⵉⴷⵉ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⴽⴻⵎⵎⴻⵍ ⵉⵊⵊ ⵏ ⵍⵡⴰⵄⴷ ⵏⵉⵖ ⴰⵎ ⵢⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵙ ⵍⵅⴰⴹⴰⵔ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⵉⵍⵉ ⵜⴰⵖⴰⵔⵚⵜ ⴷ ⵉⵊⵊ ⵏ ⵓⵎⵓⴷⴷⴰⵔ ⵉⵛⵏⴰⵏ ⵇⴰⵄ ⵣⵉ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏⵉⵖ ⵣⴻⴳ ⵡⵓⴵⵉ, ⵃⵉⵎⴰ ⴰⴷ ⴷⴰⵢⴻⵙ ⵉⵜⵜⵡⴰⴼ ⴰⵔⴹⴰ. ⵡⴰⵔ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⴷⴰⵢⴻⵙ ⵢⵉⵍⵉ ⵓⵍⴰ ⴷ ⵉⵊⵊ ⵏ ⵍⵄⵉⴱ. ");
INSERT INTO rift_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","ⵎⵉⵏ ⵉⴵⴰⵏ ⴷ ⴰⴷⴰⵔⵖⴰⵍ ⵏⵉⵖ ⵎⵉⵏ ⵉⵜⵜⵡⴰⵔⵥⴻⵏ ⵏⵉⵖ ⵎⵉⵏ ⴷⵉ ⵉⴵⴰⵏ ⵉⵊⵊ ⵏ ⵓⵢⴻⵣⵣⵉⵎ ⵢⴰⵔⴻⵣⵎⴻⵏ ⵏⵉⵖ ⵎⵉⵏ ⴷⵉ ⴵⴰⵏⵜ ⵜⴼⵉⴹⵍⵉⵡⵉⵏ ⵏⵉⵖ ⵊⴷⴰⵎ ⵏⵉⵖ ⵛⵛⴰⵎⴻⵜ ⵜⴻⵅⵙⴰⵔ ⵡⴰⵔ ⵜ-ⵉ-ⴷⴷ-ⵜⴻⵙⵙⵇⴰⵔⵔⴰⴱⴻⵎ ⵛⴰ ⵖⴰⵔ ⵙⵉⴷⵉ ⵓⵛⴰ ⵡⴰⵔ ⵣⵣⴰⵢⴻⵙ ⵜⵜⵉⵡⵢⴻⵎ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ ⵉ ⵙⵉⴷⵉ ⵅ ⵓⵄⴰⵍⵟⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","ⵎⴰⵛⴰ ⵉⵊⵊ ⵏ ⵓⴼⵓⵏⴰⵙ ⵏⵉⵖ ⵉⵊⵊⴻⵏ ⵣⴻⴳ ⵡⵓⴵⵉ ⵉ ⵉⵇⴻⴱⵃⴻⵏ ⵣⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⵜⵓⵣⵣⴻⴳⴳⴰⵔⵜ ⵏⵉⵖ ⵜⵓⵇⵓⴹⴻⴹⵜ ⴰⵟⵟⴰⵙ, ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⵜ-ⵉ-ⴷⴷ-ⵜⴻⵙⵙⵡⴻⵊⴷⴻⴷ ⴰⵎ ⵢⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵙ ⵍⵅⴰⴹⴰⵔ, ⵎⴰⵛⴰ ⵡⴰⵔ ⴷⴰⵢⴻⵙ ⵉⵜⵜⵡⴰⴼ ⴰⵔⴹⴰ ⵉ ⵢⵉⵊⵊ ⵏ ⵍⵡⴰⵄⴷ. ");
INSERT INTO rift_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","ⵎⵉⵏ ⵉⴷⴳⴻⴷⴷⴳⴻⵏ, ⵎⵉⵏ ⵉⵍⴻⴱⵣⴻⵏ, ⵎⵉⵏ ⵉⵎⴻⵣⵣⵇⴻⵏ, ⵎⵉⵏ ⵉⵜⵜⵡⴰⵇⴻⵙⵙⴻⵏ ⵡⴰⵔ ⵜ ⵜⵜⵉⵡⵢⴻⵎ ⵖⴰⵔ ⵙⵉⴷⵉ, ⵡⴰⵔ ⵜⵜⴻⴳⴳⴻⵎ ⴰⵢⴰ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","ⵣⴻⴳ ⵓⴼⵓⵙ ⵏ ⵎⵎⵉⵙ ⵏ ⵓⴱⴰⵔⵔⴰⵏⵉ ⵡⴰⵔ ⵜⵜⵇⴻⴷⴷⴰⵎⴻⵎ ⵛⴰ ⵣⵉ ⵎⴰⵔⵔⴰ ⵎⴰⵏ ⴰⵢⴰ ⵓⵍⴰ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⴷ ⵎⴰⵛⵛⴰ ⵉ ⴰⵔⴻⴱⴱⵉ, ⵎⵉⵏⵣⵉ ⴷⴰⵢⴻⵙ ⵍⵖⴻⵛⵛ ⵏⵙⴻⵏ ⵓⵍⴰ ⴷ ⵏⵏⴻⵇⵚⴰⵏ ⵏⵏⴻⵙ, ⵎⴰⵏ ⴰⵢⴰ ⵡⴰⵔ ⵉⵜⵜⵡⴰⵇⴻⴱⴱⵉⵍ ⵛⴰ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏⵡⴻⵎ.’” ");
INSERT INTO rift_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“ⵅⵎⵉ ⴷⴷ-ⵉⵅⴻⴵⴻⵇ ⵓⴼⵓⵏⴰⵙ ⵏⵉⵖ ⵉⵣⵎⴰⵔ ⵏⵉⵖ ⵉⵖⴰⵢⴹ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵢⵉⵍⵉ ⵙⴰⴷⵓ ⵃⴻⵟⵟⵓ ⵏ ⵢⴻⵎⵎⴰⵙ ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ. ⵣⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵜⵎⴻⵏⵢⴰ ⵓ ⴰⵡⴰⵔⵏⵉ ⴰⵙ ⴰⴷ ⵉⵚⵍⴻⵃ ⵉ ⵢⴰⵔⴹⴰ ⴰⵎ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","ⵡⴰⵔ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⵜⵖⴰⵔⵚⴻⴷ ⵉ ⵓⴼⵓⵏⴰⵙ ⵏⵉⵖ ⵉ ⵢⵉⵊⵊⴻⵏ ⵣⴻⴳ ⵡⵓⴵⵉ ⴰⴽ-ⴷ ⵎⵎⵉⵙ ⴷⴻⴳ ⵡⴰⵙⵙ ⴷ ⵉⵊⵊ. ");
INSERT INTO rift_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","ⵅ ⵎⵉⵏⵏⵉ ⵜⴻⵅⵙⴻⵎ ⴰⴷ ⵜⵇⴻⴷⴷⵎⴻⵎ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵓⵇⴰⴷⵉ ⵉ ⵙⵉⴷⵉ, ⵇⴻⴷⴷⴻⵎ ⵅⴻⵏⵏⵉ ⵎⵉⵏ ⵉⵚⴻⵍⵃⴻⵏ ⵉ ⵢⴰⵔⴹⴰ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","ⴰⴷ ⵜᵉⵜⵜⵡⴰⵛⵛ ⴷⴻⴳ ⵡⴰⵙⵙ ⵏⵏⵉ ⵏⵏⵉⵜ. ⵡⴰⵔ ⵣⵣⴰⵢⴻⵙ ⵜⵜⴻⵊⵊⵉⵎ ⵛⴰ ⴰⵍ ⵚⵚⴱⴻⵃ. ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ! ");
INSERT INTO rift_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","ⴰⴷ ⵜⴻⵃⴹⴰⵎ ⵜⵉⵡⴻⵚⵚⴰ ⵉⵏⵓ ⵓⵛⴰ ⴰⴷ ⵣⵣⴰⵢⵙⴻⵏⵜ ⵜⴻⴳⴳⴻⵎ. ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ! ");
INSERT INTO rift_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","ⵡⴰⵔ ⵙⵙⴻⵅⵙⴰⵔⴰⵎ ⵉⵙⴻⵎ ⵉⵏⵓ ⵉⵇⴻⴷⴷⵙⴻⵏ, ⵃⵉⵎⴰ ⵏⴻⵛⵛ ⴰⴷ ⵜⵜⵡⴰⵇⴻⴷⴷⵙⴻⵖ ⴷⵉ ⵍⵡⴻⵙⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⵡⴻⵏⵏⵉ ⴽⴻⵏⵏⵉⵡ ⵉⵙⵙⵇⴻⴷⴷⵙⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","ⴷ ⵡⴻⵏⵏⵉ ⴽⴻⵏⵏⵉⵡ ⴷⴷ-ⵉⵙⵙⵓⴼⴼⵖⴻⵏ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ, ⵃⵉⵎⴰ ⴰⴷ ⵉⵍⵉⵖ ⴷ ⴰⵔⴻⴱⴱⵉ ⵉ ⴽⴻⵏⵏⵉⵡ. ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ!’” ");
INSERT INTO rift_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“ⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵛⴰ ⵉⵏⵉ ⴰⵙⴻⵏ: ‘ⵍⴻⵄⵢⵓⴷⴰⵜ ⵉⵜⵜⵡⴰⴳⴳⴻⵏ ⵏ ⵙⵉⴷⵉ, ⵉⵏⵏⵉ ⵅ ⵖⴰ ⵜⴱⴰⵔⵔⵃⴻⵎ, ⴰⴷ ⵉⵍⵉⵏ ⴷ ⵉⵎⵓⵏⵉⵜⴻⵏ ⵉⵇⴻⴷⴷⵙⴻⵏ, ⴰⵇⴰ ⴰⵜⴻⵏⵜ ⴷ ⵍⴻⵄⵢⵓⴷⴰⵜ ⵉⵏⵓ ⵉⵜⵜⵡⴰⴳⴳⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","ⵙⴻⵜⵜⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⴰⴷ ⵜⵅⴻⴷⵎⴻⵎ, ⵎⴰⵛⴰ ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵙⵙⴻⴱⵜ, ⴰⵔⵔⴰⵃⴻⵜ ⵉⵎⵓⵏ, ⵉⵊⵊ ⵏ ⵓⵎⵓⵏⵉ ⵉⵇⴻⴷⴷⵙⴻⵏ. ⵉⵜⵜⵅⴻⵚⵚⴰ ⵡⴰⵔ ⴷⴰⵢⴻⵙ ⵜⵅⴻⴷⴷⵎⴻⵎ. ⴰⵇⴰ ⴷ ⵙⵙⴻⴱⵜ ⵉ ⵙⵉⴷⵉ ⴷⵉ ⵎⴰⵔⵔⴰ ⵜⵉⵣⴻⴷⴷⵉⵖⵉⵏ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","ⴰⵇⴰ ⴷ ⵉⵏⴰ ⴷ ⵍⴻⵄⵢⵓⴷⴰⵜ ⵉⵜⵜⵡⴰⴳⴳⴻⵏ ⵏ ⵙⵉⴷⵉ, ⵉⵎⵓⵏⵉⵜⴻⵏ ⵉⵇⴻⴷⴷⵙⴻⵏ, ⵉⵏⵏⵉ ⵉ ⵖⴰ ⵜⴱⴰⵔⵔⵃⴻⵎ ⴷⴻⴳ ⵡⵓⵙⵙⴰⵏ ⵏⵙⴻⵏ ⵉⵜⵜⵡⴰⴳⴳⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","ⴷⴻⴳ ⵓⵢⵓⵔ ⴰⵎⴻⵣⵡⴰⵔⵓ, ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⴰⵔⴱⴻⵄⵟⴰⵛ ⵏ ⵓⵢⵓⵔ, ⵊⴰⵔ ⴱⴻⴷⴷⵓ ⵏ ⵡⴻⵣⵢⴻⵏ ⵏ ⵡⴰⵙⵙ ⴰⵍ ⴷⴷ-ⵜⴻⵡⴹⴰ ⵜⵎⴻⴷⴷⵉⵜ, ⴰⴷ ⵜⵉⵍⵉ ⴷ ⵜⵖⴰⵔⵚⵜ ⵏ ⵓⵙⴻⵄⴷⵓ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵅⴻⵎⵎⴻⵙⵟⴰⵛ ⵏ ⵓⵢⵓⵔ ⵏⵏⵉⵜ, ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵍⵄⵉⴷ ⵏ ⵡⴻⵖⵔⵓⵎ ⴱⵍⴰ ⴰⵏⵜⵓⵏ ⵉ ⵙⵉⴷⵉ. ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⴰⴷ ⵜⴻⵛⵛⴻⵎ ⴰⵖⵔⵓⵎ ⴱⵍⴰ ⴰⵏⵜⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","ⴰⵙⵙ ⴰⵎⴻⵣⵡⴰⵔ ⴰⴷ ⵜⴻⴳⴳⴻⵎ ⵉⵊⵊ ⵏ ⵓⵎⵓⵏⵉ ⵉⵇⴻⴷⴷⵙⴻⵏ. ⵡⴰⵔ ⵜⵜⴻⴳⴳⴻⵎ ⵓⵍⴰ ⴷ ⵉⵛⵜ ⵏ ⵍⵅⴻⴷⵎⴻⵜ ⵉ ⵉⵜⵜⵅⴻⵚⵚⴰⵏ ⴰⴷ ⵜᵉⵜⵜⵡⴰⴳⴳ. ");
INSERT INTO rift_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⴽⴻⵎⵎⵍⴻⵏ ⴰⴷ ⵜⴰⵡⵢⴻⵎ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ ⵉ ⵙⵉⴷⵉ ⵓⵛⴰ ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ ⴰⴷ ⴷⵉⵏ ⵢⵉⵍⵉ ⵉⵊⵊ ⵏ ⵓⵎⵓⵏⵉ ⵉⵇⴻⴷⴷⵙⴻⵏ. ⵡⴰⵔ ⵜⵜⴻⴳⴳⴻⵎ ⵓⵍⴰ ⴷ ⵉⵛⵜ ⵏ ⵍⵅⴻⴷⵎⴻⵜ ⵉ ⵉⵜⵜⵅⴻⵚⵚⴰⵏ ⴰⴷ ⵜᵉⵜⵜⵡⴰⴳⴳ.’” ");
INSERT INTO rift_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“ⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵉⵏⵉ ⴰⵙⴻⵏ: ‘ⵎⴰⵍⴰ ⵜⵉⵡⴹⴻⵎ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⵉ ⴷ ⴰⵡⴻⵎ ⵖⴰ ⵡⵛⴻⵖ ⵓⵛⴰ ⴰⴷ ⵜⴻⵎⵊⴰⵔⴻⵎ ⵚⵚⴰⴱⴻⵜ ⵏⵏⴻⵙ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⴰⵡⵢⴻⵎ ⵉⵛⵜ ⵏ ⵜⵇⴻⴱⴱⵉⴹⵜ ⵣⵉ ⵜⵎⴻⵣⵡⴰⵔⵓⵜ ⵏ ⵚⵚⴰⴱⴻⵜ ⵏⵡⴻⵎ ⵖⴰⵔ ⵓⴽⴻⵀⵀⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⴰⴷ ⵉⵙⵙⴻⵏⵀⴻⵣⵣ ⵜⴰⵇⴻⴱⴱⵉⴹⵜ ⵏⵏⵉ ⵣⵉ ⵙⵙⴰ ⵖⴰⵔ ⴷⴰ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜᵉⵜⵜⵡⴰⵇⴻⴱⵍⴻⵎ ⵙ ⴰⵔⴹⴰ. ⴷⵉ ⵜⵓⴼⴼⵓⵜ ⴰⵡⴰⵔⵏⵉ ⵙⵙⴻⴱⵜ ⴰⴷ ⵜⵜ ⵉⵙⵙⴻⵏⵀⴻⵣⵣ ⵓⴽⴻⵀⵀⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","ⴷⴻⴳ ⵡⴰⵙⵙ ⵎⵉⵏ ⴷⵉ ⵉ ⵖⴰ ⵜⴻⵏⵀⴻⵣⵣⴻⵎ ⵜⴰⵇⴻⴱⴱⵉⴹⵜ, ⴰⴷ ⵜⴻⵙⵙⵡⴻⵊⴷⴻⵎ ⵄⴰⵡⴻⴷ ⵉⵊⵊ ⵏ ⵉⵣⵎⴰⵔ ⵉⵛⵏⴰⵏ ⵇⴰⵄ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ ⴰⵎ ⵢⵉⵛⵜ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","ⴰⴷ ⵜⵉⵍⵉ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵣⵉ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵄⵛⵓⵔⴰⵢ ⵏ ⵉⵊⵊ ⵏ ⵉⴼⴰ ⵏ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵅⴻⴵⴹⴻⵏ ⵙ ⵣⵣⴻⵛⵜ, ⴰⵇⴰ-ⵜⵜ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ ⵙ ⵉⵛⵜ ⵏ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵉⵜⵜⴼⵓⵃⴻⵏ ⵉ ⵙⵉⴷⵉ, ⵓ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵏ ⵓⵙⴻⵢⵢⴻⴱ ⴰⴷ ⵜⵉⵍⵉ ⴷ ⴱⵉⵏⵓ, ⵉⵊⵊ ⵏ ⴰⵔⴱⴻⵄ ⵣⴻⴳ ⵉⵊⵊ ⵏ ⵓⵀⵉⵏⵓ. ");
INSERT INTO rift_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","ⵡⴰⵔ ⵜⵜᵉⵜⵜⴻⵎ ⴰⵖⵔⵓⵎ ⵓⵍⴰ ⴷ ⵜⵉⴷⵔⵉⵏ ⵢⵓⵔⴼⴻⵏ ⵏⵉⵖ ⵜⵉⵣⵉⵣⴰⵡⵉⵏ ⴰⵍ ⴰⵙⵙ ⵎⵉⵏ ⴷⵉ ⴷⴷ-ⵜⵉⵡⵢⴻⵎ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵡⴻⵎ ⵖⴰⵔ ⴰⵔⴻⴱⴱⵉ. ⴰⵇⴰ-ⵜⵜ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵚⴻⵢⵢⴻⵜ ⵉ ⵍⴻⴱⴷⴰ ⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵏⵡⴻⵎ ⵎⴰⵏⵉ ⵎⴰ ⵜⵣⴻⴷⴷⵖⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","ⴰⵡⴰⵔⵏⵉ ⴰⵙ ⴰⴷ ⵜⵃⴻⵙⴱⴻⵎ ⵙ ⵍⵎⴻⵇⵍⵓⴱ ⵉ ⵢⵉⵅⴻⴼ ⵏⵡⴻⵎ ⵣⵉ ⵚⵚⴱⴻⵃ ⴰⵡⴰⵔⵏⵉ ⵉ ⵙⵙⴻⴱⵜ, ⵣⴻⴳ ⵡⴰⵙⵙ ⵎⵉⵏ ⴷⵉ ⴷⴷ-ⵜⵉⵡⵢⴻⵎ ⵜⴰⵇⴻⴱⴱⵉⴹⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵡⴻⵏⵀⴻⵣⵣⵉ: ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵉⵍⵉⵏ ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⵏ ⵙⵙⴻⴱⵜ ⴽⴻⵎⵎⵍⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","ⴰⴷ ⵜⵃⴻⵙⵙⴱⴻⵎ ⵅⴻⵎⵙⵉⵏ ⵏ ⵡⵓⵙⵙⴰⵏ ⴰⵍ ⵜⵓⴼⴼⵓⵜ ⵏ ⵙⵙⴻⴱⵜ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ. ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⴰⵡⵢⴻⵎ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵏ ⵊⴷⵉⴷ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","ⴰⴷ ⴷⴷ-ⵜⴰⵡⵢⴻⵎ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵛⵏⵉⴼⵉⵏ ⵏ ⵡⴻⵖⵔⵓⵎ ⵉ ⵡⴻⵏⵀⴻⵣⵣⵉ ⵣⴻⴳ ⵉⵎⵓⵛⴰⵏ ⵎⴰⵏⵉ ⵜⵣⴻⴷⴷⵖⴻⵎ. ⴰⴷ ⵉⵍⵉⵏⵜ ⵣⵉ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵄⵛⵓⵔⴰⵢ ⵏ ⵢⵉⵊⵊ ⵏ ⵉⴼⴰ ⵏ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ, ⴳⴳⵡⵉⵏⵜ ⵙ ⵡⴻⵏⵜⵓⵏ. ⴰⵇⴰ ⴰⵜⴻⵏⵜ ⴷ ⵜⵉⵎⴻⵏⵣⴰ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⴷⴷ-ⵜⴻⵙⵙⵇⴰⵔⵔⴱⴻⵎ ⴰⴽ-ⴷ ⵡⴻⵖⵔⵓⵎ ⵄⴰⵡⴻⴷ ⵙⴻⴱⵄⴰ ⵏ ⵉⵣⵎⴰⵔⴻⵏ ⵛⵏⴰⵏ ⵇⴰⵄ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ ⴷ ⵉⵊⵊ ⵏ ⵓⴼⵓⵏⴰⵙ - ⴰⵎⴻⵥⵢⴰⵏ ⵏ ⵜⴼⵓⵏⴰⵙⵜ - ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ. ⴰⴷ ⵉⵍⵉⵏ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵉ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵙⴻⵏ ⵏ ⵍⵖⵉⴵⴻⵜ ⴷ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵏⵙⴻⵏ ⵏ ⵓⵙⴻⵢⵢⴻⴱ, ⴰⵇⴰ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ ⵙ ⵉⵛⵜ ⵏ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵉⵜⵜⴼⵓⵃⴻⵏ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","ⴰⴷ ⵜⴻⵙⵙⵡⴻⵊⴷⴻⵎ ⵄⴰⵡⴻⴷ ⵉⵊⵊ ⵏ ⵓⵎⵢⴰⵏ ⵣⴻⴳ ⵉⵖⴰⵢⴹⴻⵏ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⵓ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵣⵎⴰⵔⴻⵏ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ ⴷ ⵜⵖⴰⵔⵚⵜ ⵏ ⵍⴻⵀⵏⴰ. ");
INSERT INTO rift_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","ⴰⴷ ⵜⴻⵏ ⵉⵙⵙⴻⵏⵀⴻⵣⵣ ⵓⴽⴻⵀⵀⴰⵏ ⴰⴽ-ⴷ ⵡⴻⵖⵔⵓⵎ ⵏ ⵜⴰⵎⴻⵏⵣⵓⵜ ⵣⵉ ⵙⵙⴰ ⵖⴰⵔ ⴷⴰ ⴰⵎ ⵢⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵡⴻⵏⵀⴻⵣⵣⵉ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ, ⵓⵍⴰ ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵣⵎⴰⵔⴻⵏ. ⴰⴷ ⵉⵍⵉⵏ ⵇⴻⴷⴷⵙⴻⵏ ⵉ ⵙⵉⴷⵉ, ⵉ ⵓⴽⴻⵀⵀⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","ⴷⴻⴳ ⵡⴰⵙⵙ ⵏⵏⵉⵜ ⴰⴷ ⵜⴱⴰⵔⵔⵃⴻⵎ ⵉ ⵢⵉⵊⵊ ⵏ ⵓⵎⵓⵏⵉ ⵉⵇⴻⴷⴷⵙⴻⵏ. ⵡⴰⵔ ⵜⵜⴻⴳⴳⴻⵎ ⵓⵍⴰ ⴷ ⵉⵛⵜ ⵏ ⵍⵅⴻⴷⵎⴻⵜ ⵉ ⵉⵜⵜⵅⴻⵚⵚⴰⵏ ⴰⴷ ⵜᵉⵜⵜⵡⴰⴳⴳ. ⴰⵇⴰ-ⵜⵜ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵚⴻⵢⵢⴻⵜ ⵉ ⵍⴻⴱⴷⴰ ⵎⴰⵏⵉ ⵎⴰ ⵉ ⵖⴰ ⵜⵣⴻⴷⵖⴻⵎ ⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","ⵅⵎⵉ ⵖⴰ ⵜⴻⵎⵊⴰⵔⴻⵎ ⵍⵖⵉⴵⴻⵜ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵡⴻⵎ, ⵡⴰⵔ ⵎⴻⵊⵊⴰⵔ ⴰⵍ ⴰⵏⴻⴳⴳⴰⵔ ⵏ ⵟⵟⴰⵔⴼ ⵏ ⵢⴻⵢⵢⴰⵔ ⵏⵏⴻⵛ, ⵓ ⵎⵉⵏ ⵉⵇⵇⵉⵎⴻⵏ ⵏ ⵍⵖⵉⴵⴻⵜ ⵏⵏⴻⵛ ⵡⴰⵔ ⵜ ⵜⴽⴻⵙⵙⴻⴷ ⵛⴰ. ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜⴻⵊⵊⴻⵎ ⵛⵡⴰⵢⵜ ⵉ ⵓⵎⴻⵣⵍⵓⴹ ⵓ ⵉ ⵓⴱⴰⵔⵔⴰⵏⵉ. ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ!’” ");
INSERT INTO rift_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“ⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵉⵏⵉ ⴰⵙⴻⵏ: ‘ⴷⴻⴳ ⵓⵢⵓⵔ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ, ⴷⴻⴳ ⵡⴰⵙⵙ ⴰⵎⴻⵣⵡⴰⵔⵓ ⵏ ⵓⵢⵓⵔ, ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵙⵙⴻⴱⵜ ⵉ ⴽⴻⵏⵏⵉⵡ, ⵉⵊⵊ ⵏ ⵡⴰⵙⵙ ⵏ ⵍⵉⴷⴰⵔⴻⵜ ⴰⴽ-ⴷ ⵓⵙⵓⴹⵉ ⵙ ⵡⴻⵙⵔⵓⴷⴷⴻⵃ ⴷⴻⴳ ⵓⵢⵉⵛⵛ ⵏ ⵉⵛⴰⵔⵔⵉ, ⵉⵊⵊ ⵏ ⵓⵎⵓⵏⵉ ⵉⵇⴻⴷⴷⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","ⵡⴰⵔ ⵜⵜⴻⴳⴳⴻⵎ ⵓⵍⴰ ⴷ ⵉⵛⵜ ⵏ ⵍⵅⴻⴷⵎⴻⵜ ⵉ ⵉⵜⵜⵅⴻⵚⵚⴰⵏ ⴰⴷ ⵜᵉⵜⵜⵡⴰⴳⴳ. ⴰⴷ ⴷⴷ-ⵜⴻⵙⵇⴰⵔⵔⴱⴻⵎ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ ⵉ ⵙⵉⴷⵉ.’” ");
INSERT INTO rift_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵄⴻⵛⵔⴰ ⵏ ⵓⵢⵓⵔ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⴰⵙⵙ ⵏ ⵡⴻⵚⵍⴰⵃ. ⴰⴷ ⵜⴻⴳⴳⴻⵎ ⵉⵊⵊ ⵏ ⵓⵎⵓⵏⵉ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵉ ⴽⴻⵏⵏⵉⵡ. ⴰⴷ ⵜⴻⵙⵙⵡⴰⴹⵄⴻⵎ ⵉⵅⴻⴼ ⵏⵡⴻⵎ ⵓⵛⴰ ⴰⴷ ⵜⵇⴻⴷⴷⵎⴻⵎ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","ⵡⴰⵔ ⵜⵜⴻⴳⴳⴻⵎ ⵓⵍⴰ ⴷ ⵉⵛⵜ ⵏ ⵍⵅⴻⴷⵎⴻⵜ ⴷⴻⴳ ⵡⴰⵙⵙ ⵏⵏⵉ ⵏⵏⵉⵜ, ⵎⵉⵏⵣⵉ ⴰⵇⴰ-ⵜ ⴷ ⴰⵙⵙ ⵏ ⵡⴻⵚⵍⴰⵃ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⵜⵜⵡⴰⴳⴳ ⵡⴻⵚⵍⴰⵃ ⵉ ⴽⴻⵏⵏⵉⵡ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","ⵎⵉⵏⵣⵉ ⵎⴰⵔⵔⴰ ⴱⵏⴰⴷⴻⵎ ⵏⵏⵉ ⵡⴰⵔ ⵉⵙⵙⵡⴰⴹⵄⴻⵏ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⴷⴻⴳ ⵡⴰⵙⵙ ⵏⵏⵉ ⵏⵏⵉⵜ, ⴰⴷ ⵉⵜⵜⵡⴰⵇⴻⵙⵙ ⵣⵉ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","ⴽⵓⵍ ⴱⵏⴰⴷⴻⵎ ⵏⵏⵉ ⵉ ⵖⴰ ⵉⴳⴳⵉⵏ ⵛⴰ ⵏ ⵍⵅⴻⴷⵎⴻⵜ ⴷⴻⴳ ⵡⴰⵙⵙ ⵏⵏⵉ ⵏⵏⵉⵜ, ⵏⴻⵛⵛ ⴰⴷ ⵜⴻⵃⵃⵉⵖ ⴱⵏⴰⴷⴻⵎ ⵏⵏⵉ ⵣⵉ ⵍⵡⴻⵙⵟ ⵏ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","ⵡⴰⵔ ⵜⵜⴻⴳⴳⴻⵎ ⵓⵍⴰ ⴷ ⵉⵛⵜ ⵏ ⵍⵅⴻⴷⵎⴻⵜ. ⴰⵇⴰ-ⵜⵜ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵚⴻⵢⵢⴻⵜ ⵉ ⵍⴻⴱⴷⴰ ⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵏⵡⴻⵎ ⵎⴰⵏⵉ ⵎⴰ ⵉ ⵖⴰ ⵜⵣⴻⴷⵖⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵉⵊⵊ ⵏ ⵙⵙⴻⴱⵜ ⵏ ⴰⵔⵔⴰⵃⴻⵜ ⵜⵎⵓⵏ ⵉ ⴽⴻⵏⵏⵉⵡ. ⴰⴷ ⵉⵍⵉⵏ ⵍⴻⵄⵎⵓⵔ ⵏⵡⴻⵎ ⵃⵚⴰⵔⴻⵏ. ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵜⴻⵙⵄⴰ ⵏ ⵓⵢⵓⵔ, ⴷⵉ ⴵⵉⵍⴻⵜ, ⵣⴻⴳ ⵓⵄⴻⵛⵛⵉ ⵖⴰⵔ ⵓⵄⴻⵛⵛⵉ ⵏⵏⴻⵖⵏⵉ ⴰⴷ ⵜⴻⵃⴹⴰⵎ ⴰⵔⵔⴰⵃⴻⵜ ⵏⵡⴻⵎ ⵏ ⵙⵙⴻⴱⵜ.” ");
INSERT INTO rift_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“ⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵛⴰ ⵉⵏⵉ: ‘ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵅⴻⵎⵎⴻⵙⵟⴰⵛ ⵏ ⵓⵢⵓⵔ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵍⵄⵉⴷ ⵏ ⵉⵄⵓⵛⵛⵓⵜⴻⵏ ⵉ ⵙⵉⴷⵉ, ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","ⴷⴻⴳ ⵡⴰⵙⵙ ⴰⵎⴻⵣⵡⴰⵔⵓ ⴰⴷ ⵢⵉⵍⵉ ⵢⵉⵊⵊ ⵏ ⵓⵎⵓⵏⵉ ⵉⵇⴻⴷⴷⵙⴻⵏ. ⵡⴰⵔ ⵜⵜⴻⴳⴳⴻⵎ ⵓⵍⴰ ⴷ ⵉⵛⵜ ⵏ ⵍⵅⴻⴷⵎⴻⵜ ⵉ ⵉⵜⵜⵅⴻⵚⵚⴰⵏ ⴰⴷ ⵜᵉⵜⵜⵡⴰⴳⴳ. ");
INSERT INTO rift_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⴰⴷ ⵜⵇⴻⴷⴷⵎⴻⵎ ⵜⵉⵡⵀⵉⴱⵉⵏ ⵏ ⵜⵎⴻⵙⵙⵉ ⵖⴰⵔ ⵙⵉⴷⵉ. ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵜⵎⴻⵏⵢⴰ ⴰⴷ ⴷⵉⵏ ⵢⵉⵍⵉ ⵢⵉⵊⵊ ⵏ ⵓⵎⵓⵏⵉ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵓⵛⴰ ⴰⴷ ⵜⴰⵡⵢⴻⵎ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ ⵉ ⵙⵉⴷⵉ. ⴰⵇⴰ ⴷ ⵉⵊⵊ ⵏ ⵓⵎⵓⵏⵉ ⵉⴼⴰⵔⵣⴻⵏ ⴷ ⴰⵎⵇⴻⴷⴷⴻⵙ, ⵡⴰⵔ ⵜⵜⴻⴳⴳⴻⵎ ⵓⵍⴰ ⴷ ⵉⵛⵜ ⵏ ⵍⵅⴻⴷⵎⴻⵜ ⵉ ⵉⵜⵜⵅⴻⵚⵚⴰⵏ ⴰⴷ ⵜᵉⵜⵜⵡⴰⴳⴳ. ");
INSERT INTO rift_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","ⵜⵉⵏⴰ ⴷ ⵍⴻⵄⵢⵓⴷⴰⵜ ⵉⵜⵜⵡⴰⴳⴳⴻⵏ ⵏ ⵙⵉⴷⵉ, ⵜⵉⵏⵏⵉ ⵣⵉ ⵖⴰ ⵜⴱⴰⵔⵔⵃⴻⵎ ⴷ ⵉⵎⵓⵏⵉⵜⴻⵏ ⵉⵇⴻⴷⴷⵙⴻⵏ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⵇⴻⴷⴷⵎⴻⵎ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ ⵖⴰⵔ ⵙⵉⴷⵉ, ⵉⵛⵜ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ, ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵉ ⵜⵖⴰⵔⵚⵜ ⴷ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵏ ⵓⵙⴻⵢⵢⴻⴱ, ⴽⵓⵍ ⴰⵙⵙ ⵎⵉⵏ ⵉⵜⵜⵡⴰⴳⴳⴻⵏ ⵉ ⵡⴰⵙⵙ ⵏⵏⵉ, ");
INSERT INTO rift_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","ⴱⴰⵔⵔⴰ ⵉ ⵜⵖⴰⵔⵚⴰ ⵏⵡⴻⵎ ⵏ ⵡⵓⵙⵙⴰⵏ ⵏ ⵙⵙⴻⴱⵜ ⵏ ⵙⵉⴷⵉ ⴷ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵏⵡⴻⵎ ⵏ ⵍⵡⵓⵄⵓⴷ ⵏⵡⴻⵎ ⴷ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵏⵡⴻⵎ ⵙ ⵍⵅⴰⴹⴰⵔ, ⵉⵏⵏⵉ ⵜᵉⵜⵜⵏⵓⵎⴻⵎ ⴰⴷ ⵜⴻⵏⵜ ⵜⴻⵡⵛⴻⵎ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","ⵎⴰⵛⴰ ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵅⴻⵎⵎⴻⵙⵟⴰⵛ ⵏ ⵓⵢⵓⵔ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ, ⵅⵎⵉ ⵖⴰ ⵜⴻⵙⵙⵎⵓⵏⴻⵎ ⵍⵖⵉⴵⴻⵜ ⵏ ⵜⴻⵎⵎⵓⵔⵜ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⵄⴻⵢⵢⴷⴻⵎ ⵍⵄⵉⴷ ⵏ ⵙⵉⴷⵉ, ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ. ⴷⴻⴳ ⵡⴰⵙⵙ ⴰⵎⴻⵣⵡⴰⵔⵓ ⴰⴷ ⵢⵉⵍⵉ ⵢⵉⵊⵊ ⵏ ⵡⴰⵙⵙ ⵏ ⵙⵙⴻⴱⵜ ⵓⵍⴰ ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵜⵎⴻⵏⵢⴰ ⴰⴷ ⴷⵉⵏ ⵢⵉⵍⵉ ⵢⵉⵊⵊ ⵏ ⵡⴰⵙⵙ ⵏ ⵙⵙⴻⴱⵜ. ");
INSERT INTO rift_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","ⴷⴻⴳ ⵡⴰⵙⵙ ⴰⵎⴻⵣⵡⴰⵔⵓ ⴰⴷ ⵜⴻⴽⵙⵉⵎ ⵍⵖⵉⴵⴻⵜ ⵏ ⵜⵛⴻⵊⵊⵓⵔⴰ ⵉⵛⴻⵡⵡⴰⵔⴻⵏ: ⵜⵉⵙⴻⴹⵡⵉⵏ ⵏ ⵜⵉⵏⵉ ⴷ ⵜⵉⵙⴻⴹⵡⵉⵏ ⵏ ⵜⵛⴻⵊⵊⵓⵔⴰ ⵙ ⵜⴻⴼⵔⴰⵢ ⴰⵟⵟⴰⵙ ⴷ ⵜⵙⴻⴹⵡⵉⵏ ⵏ ⵜⵛⴻⵊⵊⴰⵔⵜ ⵏ ⵜⵏⴻⵎⵍⴰⵍⵜ ⵏ ⵜⵖⴻⵣⵔⴰⵜⵉⵏ. ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⴰⴷ ⵜⴼⴰⵔⵃⴻⵎ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","ⴰⴷ ⵜⵄⴻⵢⵢⴷⴻⵎ ⵍⵄⵉⴷ ⵏ ⵉⵄⵓⵛⵛⵓⵜⴻⵏ ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⴷⴻⴳ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵉ ⵙⵉⴷⵉ. ⴰⵇⴰ-ⵜⵜ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵚⴻⵢⵢⴻⵜ ⵉ ⵍⴻⴱⴷⴰ ⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵏⵡⴻⵎ. ⴰⴷ ⵜ ⵜⵄⴻⵢⵢⴷⴻⵎ ⴷⴻⴳ ⵓⵢⵓⵔ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ. ");
INSERT INTO rift_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","ⴰⴷ ⵜⵣⴻⴷⵖⴻⵎ ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⴷⴻⴳ ⵉⵄⵓⵛⵛⵓⵜⴻⵏ. ⵎⴰⵔⵔⴰ ⵉⵏⵏⵉ ⴷⴷ-ⵉⵜⵜⵡⴰⵅⴻⵍⵇⴻⵏ ⴷⵉ ⵉⵙⵔⴰⵉⵍ ⴰⴷ ⵣⴻⴷⵖⴻⵏ ⴷⴻⴳ ⵉⵄⵓⵛⵛⵓⵜⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","ⵃⵉⵎⴰ ⴰⴷ ⵙⵙⵏⴻⵏ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵏⵡⴻⵎ, ⴱⴻⵍⵍⵉ ⵏⴻⵛⵛ ⴳⴳⵉⵖ ⴰⴷ ⵣⴻⴷⵖⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴷⴻⴳ ⵉⵄⵓⵛⵛⵓⵜⴻⵏ, ⵓⵎⵉ ⵜⴻⵏ ⵙⵙⵓⴼⴼⵖⴻⵖ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ. ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ!’” ");
INSERT INTO rift_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","ⴰⵎⵎⵓ ⵉ ⵉⵙⵙⵉⵡⴻⵍ ⵎⵓⵙⴰ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵅ ⵍⴻⵄⵢⵓⴷⴰⵜ ⵉⵜⵜⵡⴰⴳⴳⴻⵏ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“ⵓⵎⵓⵔ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴰⵛ ⴷⴷ-ⴰⵡⵢⴻⵏ ⵉ ⵜⴼⴰⵡⵜ ⵣⵣⴻⵛⵜ ⵉⵚⴼⴰⵏ ⵜⵜⵡⴰⴷⴷⵣⴻⵏ ⵜⵜ-ⵉ-ⴷⴷ ⵣⵉ ⵣⵣⵉⵜⵓⵏ, ⵃⵉⵎⴰ ⴰⴷ ⵜⴻⵊⵊⴻⵎ ⵜⴰⴼⴰⵡⵜ ⵜⴰⵔⴻⵇⵇ ⵍⴻⴱⴷⴰ. ");
INSERT INTO rift_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","ⵀⴰⵔⵓⵏ ⴰⴷ ⵜⵜ ⵉⵙⴻⵜⵜⴻⴼ ⵍⴻⴱⴷⴰ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⵣⵉ ⴵⵉⵍⴻⵜ ⴰⵍ ⵚⵚⴱⴻⵃ ⵣⵣⴰⵜ ⵏ ⵓⵍⴻⵃⵃⴰⴼ ⵏ ⵛⵛⵀⴰⴷⴻⵜ ⴷⴻⴳ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ⴰⵇⴰ-ⵜⵜ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵚⴻⵢⵢⴻⵜ ⵉ ⵍⴻⴱⴷⴰ ⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⵙ ⴰⴷ ⵉⵙⴻⵜⵜⴻⴼ ⵍⴻⴱⴷⴰ ⵜⵉⴼⵜⵉⵍⵉⵏ ⵏ ⵜⴼⴰⵡⵉⵏ ⵉ ⵉⴵⴰⵏ ⵅ ⵍⵇⴻⵏⴷⵉⵍ ⵉⵣⴷⵉⴳⴻⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","ⴰⴷ ⵜⴻⴽⵙⵉⴷ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⵓⵛⴰ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵜᵉⵙⵙⴻⵏⴳⴳⵯⴻⴷ ⵜⴻⵏⵄⴰⵛ ⵏ ⵍⴻⵎⵙⴻⵎⵏⴰⵜ. ⵉⵛⵜ ⵏ ⵜⴻⵎⵙⴻⵎⵎⴻⵎⵜ ⴰⴷ ⵜⵉⵍⵉ ⵣⵉ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵄⵛⵓⵔⵉⵏ ⵏ ⵢⵉⵊⵊ ⵏ ⵉⴼⴰ ⵏ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ. ");
INSERT INTO rift_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","ⴰⴷ ⵜⴻⵏⵜ ⵜⴻⴳⴳⴻⴷ ⴷⵉ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵙⴻⵜⵜⵉⴼⴻⵏ, ⵙⴻⵜⵜⴰ ⴷⴻⴳ ⵉⵊⵊ ⵏ ⵓⵙⴻⵜⵜⵉⴼ ⵅ ⵜⵣⴻⵡⴹⴰ ⵉⵣⴷⵉⴳⴻⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵅ ⴽⵓⵍ ⴰⵙⴻⵜⵜⵉⴼ ⵊⵊⴰⵡⵉ ⵉⵚⴼⴰⵏ ⵏⵏⵉ ⵖⴰ ⵢⵉⵍⵉ ⵉ ⵍⵉⴷⴰⵔⴻⵜ ⴰⴽ-ⴷ ⵡⴻⵖⵔⵓⵎ. ⴰⵇⴰ-ⵜⵜ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","ⴷⵉ ⴽⵓⵍ ⴰⵙⵙ ⵏ ⵙⵙⴻⴱⵜ ⴰⴷ ⵉⵙⴻⵜⵜⴻⴼ ⴰⵢⴰ ⵍⴻⴱⴷⴰ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ⴰⵇⴰ-ⵜ ⴷ ⵉⵊⵊ ⵏ ⵍⵄⴰⵀⴷ ⵉ ⵍⴻⴱⴷⴰ. ");
INSERT INTO rift_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","ⴰⴷ ⵢⵉⵍⵉ ⵡⴻⵖⵔⵓⵎ ⵉ ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ, ⵉⵏⵏⵉ ⵜ ⵖⴰ ⵉⵛⵛⴻⵏ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⴰⵎⵇⴻⴷⴷⴰⵙ, ⵎⵉⵏⵣⵉ ⵉ ⵏⴻⵜⵜⴰ ⵉ ⵉⴵⴰ ⵓⵢⴰ ⴷ ⴰⵎⵇⴻⴷⴷⴰⵙ ⵇⴰⵄ ⵣⵉ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵏ ⵜⵎⴻⵙⵙⵉ ⵏ ⵙⵉⴷⵉ. ⴰⵇⴰ-ⵜⵜ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵚⴻⵢⵢⴻⵜ ⵉ ⵍⴻⴱⴷⴰ.” ");
INSERT INTO rift_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","ⵎⵎⵉⵙ ⵏ ⵉⵛⵜ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⵜⵉⵙⵔⴰ’ⵉⵍⴻⵛⵜ ⵜⴻⴼⴼⴻⵖ ⵖⴰⵔ ⴱⴰⵔⵔⴰ. ⵏⴻⵜⵜⴰ ⵜⵓⵖⴰ-ⵜ ⴷ ⵎⵎⵉⵙ ⵏ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⴷ ⴰⵎⵉⵚⵔⵉ ⵉⵣⴻⴷⴷⵖⴻⵏ ⵊⴰⵔ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ⵎⵎⵉⵙ ⵏ ⵜⴻⵎⵖⴰⵔⵜ-ⴰ ⵜⵉⵙⵔⴰ’ⵉⵍⴻⵛⵜ ⵓ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵉⵙⵔⴰⵢⵉⵍⵉ ⵎⵎⴻⵏⵖⴻⵏ ⴰⴽ-ⴷ ⵡⴰⵢⴰⵡⵢⴰ ⴷⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","ⵎⵎⵉⵙ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⵜⵉⵙⵔⴰ’ⵉⵍⴻⵛⵜ ⵉⵛⴻⵇⵇⴻⴼ ⴷⴻⴳ ⵢⵉⵙⴻⵎ ⵓⵛⴰ ⵉⴽⴽⵯⴰⵔ. ⵅⴻⵏⵏⵉ ⵉⵡⵢⴻⵏ ⵜ ⵖⴰⵔ ⵎⵓⵙⴰ. ⵢⴻⵎⵎⴰⵙ, ⵇⵇⴰⵔⴻⵏ ⴰⵙ ⵛⵉⵍⵓⵎⵉⵢⴰ, ⵢⴻⴵⵉⵙ ⵏ ⴷⵉⴱⵔⵉ, ⵣⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⴷⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","ⴳⴳⵉⵏ ⴰⴷ ⵅⴰⵙ ⵃⴹⴰⵏ ⴰⵍⴰⵎⵉ ⴷ ⴰⵙⴻⵏ ⵉ ⵖⴰ ⵉⵎⵎⴻⵍ ⵎⵉⵏ ⵉ ⵖⴰ ⴳⴳⴻⵏ ⵣⴻⴳ ⵓⵇⴻⵎⵎⵓⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","ⵓⵛⴰ ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“ⵙⵓⴼⴼⴻⵖ ⵡⴻⵏⵏⵉ ⵉⵏⴻⵄⵍⴻⵏ ⴱⴰⵔⵔⴰ ⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵓⵛⴰ ⴻⵊⵊ ⵎⴰⵔⵔⴰ ⵉⵏⵏⵉ ⴷ ⴰⵙ ⵉⵙⵍⵉⵏ ⴰⴷ ⵙⵙⴰⵔⵙⴻⵏ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵙⴻⵏ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏⵏⴻⵙ. ⵅⴻⵏⵏⵉ ⴰⴷ ⵜ ⵜⴰⵔⵊⴻⵎ ⵜⵎⴻⵙⵎⵓⵏⵜ ⴰⵎ ⵜⴻⴽⵎⴻⵍ. ");
INSERT INTO rift_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","ⴰⴷ ⵜⴻⵙⵙⵉⵡⵍⴻⴷ ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵛⴰ ⴰⴷ ⴰⵙⴻⵏ ⵜⵉⵏⵉⴷ: ‘ⴽⵓⵍ ⴰⵔⵢⴰⵣ ⵉ ⵖⴰ ⵉⵏⴻⵄⵍⴻⵏ ⴰⵔⴻⴱⴱⵉ, ⴰⴷ ⵢⴰⵔⴱⵓ ⴷⴷⴻⵏⴱ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","ⵡⴻⵏⵏⵉ ⵉⵜⵜⵛⴻⵇⵇⴰⴼⴻⵏ ⴷⴻⴳ ⵢⵉⵙⴻⵎ ⵏ ⵙⵉⴷⵉ, ⴰⴷ ⵉⵜⵜⵡⴰⵏⴻⵖ ⵏⵉⵛⴰⵏ!’ ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⴰⴷ ⵜ ⵜⴰⵔⵊⴻⵎ. ⴰⴷ ⵉⵜⵜⵡⴰⵏⴻⵖ ⵓⴱⴰⵔⵔⴰⵏⵉ ⵓⵍⴰ ⴷ ⵡⴻⵏⵏⵉ ⴷⴷ-ⵉⵜⵜⵡⴰⵅⴻⵍⵇⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵎⴰⵍⴰ ⵉⵜⵜⵛⴻⵇⵇⴻⴼ ⴷⴻⴳ ⵢⵉⵙⴻⵎ.” ");
INSERT INTO rift_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“ⵎⴰⵍⴰ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵉⵏⵖⴰ ⵍⴻⵄⵎⴰⵔ ⵏ ⵛⴰ ⵏ ⴱⵏⴰⴷⴻⵎ ⵏⵏⴻⵖⵏⵉ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⵜⵜⵡⴰⵏⴻⵖ ⵏⵉⵛⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","ⵎⴰⵛⴰ ⵡⴻⵏⵏⵉ ⵉⵏⵖⵉⵏ ⵍⴻⵄⵎⴰⵔ ⵏ ⵉⵛⵜ ⵏ ⵍⴻⴱⵀⵉⵎⴻⵜ, ⴰⴷ ⵢⴰⵔⵔ ⵍⴻⵄⵎⴰⵔ ⵙ ⵍⴻⵄⵎⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","ⵎⴰⵍⴰ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵉⵙⵙⵢⵉⵣⴻⵎ ⵊⵊⴰⵔ ⵏⵏⴻⵙ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⴳⴳⴻⵏ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵉⴳⴳⴰ ⵏⴻⵜⵜⴰ: ");
INSERT INTO rift_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","ⵜⴰⵔⴻⵥⵥⵉⵜ ⵙ ⵜⴰⵔⴻⵥⵥⵉⵜ, ⵜⵉⵟⵟ ⵙ ⵜⵉⵟⵟ, ⵜⵉⵖⵎⴻⵙⵜ ⵙ ⵜⴻⵖⵎⴻⵙⵜ. ⴰⵏⴻⵛⵜ ⵉⵙⵙⵢⵉⵣⵣⴻⵎ ⵏⴻⵜⵜⴰ ⵉⵊⵊ ⵏ ⴱⵏⴰⴷⴻⵎ, ⴰⵎⵎⵓ ⵉ ⴷ ⴰⵙ ⵖⴰ ⴳⴳⴻⵏ ⵄⴰⵡⴻⴷ. ");
INSERT INTO rift_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","ⵡⴻⵏⵏⵉ ⵉⵏⵖⵉⵏ ⵉⵛⵜ ⵏ ⵍⴻⴱⵀⵉⵎⴻⵜ, ⴰⴷ ⵜⵜ ⵢⴰⵔⵔ, ⵓ ⵡⴻⵏⵏⵉ ⵉⵏⵖⵉⵏ ⵉⵊⵊ ⵏ ⴱⵏⴰⴷⴻⵎ, ⴰⴷ ⵉⵜⵜⵡⴰⵏⴻⵖ ⵙⵉⵎⴰⵏⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","ⴰⴷ ⵖⴰⵔⵡⴻⵎ ⵢⵉⵍⵉ ⴷ ⵉⵊⵊ ⵏ ⵓⵣⴻⵔⴼ ⵉ ⵓⴱⴰⵔⵔⴰⵏⵉ ⴰⵎ ⵉ ⵡⴻⵏⵏⵉ ⴷⴷ-ⵉⵅⴻⵍⵇⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ, ⵎⵉⵏⵣⵉ ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ!” ");
INSERT INTO rift_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵎⵓⵙⴰ ⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴰⴷ ⵙⵙⵓⴼⴼⵖⴻⵏ ⵡⴻⵏⵏⵉ ⵜⵓⵖⴰ ⵉⵏⴻⵄⵄⵍⴻⵏ ⴱⴰⵔⵔⴰ ⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ, ⵃⵉⵎⴰ ⴰⴷ ⵜ ⴰⵔⴻⵊⵎⴻⵏ. ⵓⵛⴰ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴳⴳⵉⵏ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵙ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ ⵅ ⵡⴻⴷⵔⴰⵔ ⵏ ⵙⵉⵏⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“ⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵛⴰ ⵉⵏⵉ ⴰⵙⴻⵏ: ‘ⵅⵎⵉ ⵖⴰ ⵜⴰⵡⴹⴻⵎ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⵉ ⴷ ⴰⵡⴻⵎ ⵖⴰ ⵡⵛⴻⵖ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⴰⵔⴻⵢⵢⴻⵃ ⵜⴻⵎⵎⵓⵔⵜ, ⵉⵊⵊ ⵏ ⵡⴰⵔⴻⵢⵢⴻⵃ ⵏ ⵙⵙⴻⴱⵜ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","ⵙⴻⵜⵜⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⴰⴷ ⵜⵣⴰⵔⵄⴻⴷ ⵉⵢⵢⴰⵔ ⵏⵏⴻⵛ ⵓⵛⴰ ⵙⴻⵜⵜⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⴰⴷ ⵜⴻⵣⴱⴰⵔⴻⴷ ⵜⵉⵣⴰⵢⴰⵔⵉⵏ ⵏ ⵓⵎⴰⵔⵊⴻⵄ ⵏⵏⴻⵛ ⵓⵛⴰ ⴰⴷ ⵜⴻⵙⵙⵎⵓⵏⴻⴷ ⵍⵖⵉⴵⴻⵜ ⵏⵏⴻⵙ, ");
INSERT INTO rift_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","ⵎⴰⵛⴰ ⴷⴻⴳ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ ⴰⴷ ⵜⵉⵍⵉ ⵉⵛⵜ ⵏ ⴰⵔⵔⴰⵃⴻⵜ ⵏ ⵙⵙⴻⴱⵜ ⵉ ⵜⴻⵎⵎⵓⵔⵜ, ⵉⵊⵊ ⵏ ⵙⵙⴻⴱⵜ ⵉ ⵙⵉⴷⵉ. ⵡⴰⵔ ⵜⵣⴰⵔⵔⵄⴻⴷ ⵛⴰ ⵉⵢⵢⴰⵔ ⵏⵏⴻⵛ ⵓ ⵡⴰⵔ ⵜⵣⴻⴱⴱⴰⵔⴻⴷ ⵛⴰ ⵜⵉⵣⴰⵢⴰⵔⵉⵏ ⵏ ⵓⵎⴰⵔⵊⴻⵄ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","ⵎⵉⵏ ⴷⴷ-ⵉⵖⴻⵎⵎⵢⴻⵏ ⴰⵎⴻⵏⵏⵉ ⵡⴰⵀⴰ, ⵡⴰⵔ ⵜ ⵎⴻⵊⵊⴰⵔⴻⵎ ⵓ ⴰⴹⵉⵍ ⵡⴰⵔ ⵜ ⵣⴻⴱⴱⴰⵔⴻⵎ ⵣⵉ ⵜⵣⴰⵢⴰⵔⵜ ⵏⵏⴻⵛ ⵉ ⵡⴰⵔ ⵉⵜⵜⵡⵉⵃⵉⴷⵉⵏ. ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵏ ⵙⵙⴻⴱⵜ ⵉ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","ⵚⵚⴰⴱⴻⵜ ⵏ ⴰⵔⵔⴰⵃⴻⵜ ⵏ ⵙⵙⴻⴱⵜ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⴻⵛ ⴰⴷ ⴰⵡⴻⵎ ⵜⵉⵍⵉ ⴷ ⵎⴰⵛⵛⴰ, ⵉ ⵛⴻⴽ, ⵉ ⵢⵉⵙⵎⴻⵖ ⵏⵏⴻⵛ, ⵉ ⵜⴰⵢⵢⴰ ⵏⵏⴻⵛ, ⵉ ⵓⵛⴻⵡⵡⴰⵍ ⵏⵏⴻⵛ ⵓⵍⴰ ⵉ ⵓⵎⵄⴻⵣⵣⴻⴱ ⵏⵏⴻⵛ, ⵉⵏⵏⵉ ⴰⴽⵉⴷⴻⴽ ⵉⵣⴻⴷⴷⵖⴻⵏ ⴰⵎ ⵢⵉⴱⴰⵔⵔⴰⵏⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","ⵚⵚⴰⴱⴻⵜ ⵏⵏⴻⵙ ⵎⴰⵔⵔⴰ ⴰⴷ ⵜⵉⵍⵉ ⴷ ⵎⴰⵛⵛⴰ ⵉ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵓ ⵉ ⵍⵎⴰⵍ ⵏⵏⵉ ⵉⴵⴰⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⴻⵛ.’” ");
INSERT INTO rift_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“ⴰⴷ ⵜⵃⴻⵙⵙⴱⴻⵎ ⴽⴻⵏⵏⵉⵡ ⵄⴰⵡⴻⴷ ⵙⴻⴱⵄⴰ ⵏ ⵙⵙⵉⵎⴰⵏⴰⵜ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵙⴻⴱⵄⴰ ⵡⵡⴻⵜ ⵉ-ⵜⵜ ⴷⵉ ⵙⴻⴱⵄⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴰⵡⴹⴻⵏ ⵡⵓⵙⵙⴰⵏ ⵏ ⵙⴻⴱⵄⴰ ⵏ ⵙⵉⵎⴰⵏⴰⵜ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵎⵓⵏⴻⵏ ⵖⴰⵔ ⵜⴻⵙⵄⴰ ⵓ-ⵔⴻⴱⵄⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","ⵅⴻⵏⵏⵉ ⴷⴻⴳ ⵓⵢⵓⵔ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ, ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵄⴻⵛⵔⴰ ⵏ ⵓⵢⵓⵔ, ⴰⴷ ⵜⴻⵊⵊⴻⴷ ⴰⵙⵓⴹⵉ ⴷⴻⴳ ⵓⵢⵉⵛⵛ ⵏ ⵉⵛⴰⵔⵔⵉ ⴰⴷ ⵉⵜⵜⴻⴽⴽ ⵅ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵡⴻⵎ ⵙ ⵡⴻⵙⵔⵓⴷⴷⴻⵃ. ⴷⴻⴳ ⵡⴰⵙⵙ ⵏ ⵡⴻⵚⵍⴰⵃ ⴰⴷ ⵜⴻⵊⵊⴻⵎ ⴰⴷ ⵉⵜⵜⴻⴽⴽ ⵓⵙⵓⴹⵉ ⴷⴻⴳ ⵓⵢⵉⵛⵛ ⵏ ⵉⵛⴰⵔⵔⵉ ⵅ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","ⴰⴷ ⵜⴻⵙⵙⵇⴻⴷⴷⵙⴻⵎ ⴰⵙⴻⴳⴳⵯⴰⵙ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵡⵉⵙⵙ ⵅⴻⵎⵙⵉⵏ. ⴰⴷ ⵜⴱⴰⵔⵔⵃⴻⵎ ⵙ ⵜⵍⴻⵍⵍⵉ ⵉ ⵎⴰⵔⵔⴰ ⵉⵎⴻⵣⴷⴰⵖ ⴷⵉ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ. ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵏ ⵓⵙⵍⵉⵡⵍⴻⵡ ⵉ ⴽⴻⵏⵏⵉⵡ ⵓⵛⴰ ⴰⴷ ⴷⴷ-ⵉⵄⵇⴻⴱ ⴽⵓⵍ ⴰⵔⵢⴰⵣ ⵖⴰⵔ ⵡⴰⴳⵍⴰ ⵏⵏⴻⵙ ⵓ ⵖⴰⵔ ⵔⴰⴵ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","ⴰⵙⴻⴳⴳⵯⴰⵙ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵡⵉⵙⵙ ⵅⴻⵎⵙⵉⵏ ⴰⴷ ⴰⵡⴻⵎ ⵢⵉⵍⵉ ⴷ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵏ ⵓⵙⵍⵉⵡⵍⴻⵡ. ⵡⴰⵔ ⵜⵣⴰⵔⵔⵄⴻⵎ ⵓ ⵡⴰⵔ ⵜⵎⴻⵊⵊⴰⵔⴻⵎ ⵎⵉⵏ ⴷⴷ-ⵉⵖⴻⵎⵎⵢⴻⵏ ⴰⵎⴻⵏⵏⵉ ⵡⴰⵀⴰ, ⵓ ⵡⴰⵔ ⵜⵣⴻⴱⴱⴰⵔⴻⵎ ⵛⴰ ⵣⵉ ⵜⵣⴰⵢⴰⵔⵜ ⵡⴰⵔ ⵉⵜⵜⵡⵉⵃⵉⴷⵉⵏ, ");
INSERT INTO rift_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","ⵎⵉⵏⵣⵉ ⴰⵇⴰ ⴷ ⴰⵙⴻⴳⴳⵯⴰⵙ ⵏ ⵓⵙⵍⵉⵡⵍⴻⵡ! ⴰⵇⴰ ⵜⵣⴻⵎⵎⴰⵔⴻⵎ ⴰⴷ ⵜⴻⵛⵛⴻⵎ ⵍⵖⵉⴵⴻⵜ ⵏ ⵢⴻⵢⵢⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","ⴷⴻⴳ ⵓⵙⴻⴳⴳⵯⴰⵙ-ⴰ ⵏ ⵓⵙⵍⵉⵡⵍⴻⵡ ⴰⴷ ⴷⴷ-ⵉⵄⵇⴻⴱ ⴽⵓⵍ ⵉⵊⵊⴻⵏ ⵖⴰⵔ ⵡⴰⴳⵍⴰ ⵏⵏⴻⵙ.” ");
INSERT INTO rift_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“ⵎⴻⵍⵎⵉ ⵛⴻⴽ ⵖⴰ ⵜⴻⵣⵣⴻⵏⵣⴻⴷ ⵛⴰ ⵉ ⵊⵊⴰⵔ ⵏⵏⴻⵛ ⵏⵉⵖ ⵎⴰⵍⴰ ⵜⴻⵙⵖⵉⴷ ⵛⴰ ⵣⴻⴳ ⵓⴼⵓⵙ ⵏ ⵊⵊⴰⵔ ⵏⵏⴻⵛ, ⵡⴰⵔ ⵉⵄⴻⴷⴷⴻⵍ ⵓⵍⴰ ⴷ ⵉⵊⵊⴻⵏ ⴰⴷ ⵉⵖⴻⴱⴱⴻⵏ ⵡⴻⵏⵏⴻⵖⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","ⵄⵍⴰⵃⵙⴰⴱ ⵍⵇⴻⴷⴷ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵣⴻⴳ ⵡⴰⵎⵉ ⵉⴵⴰ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵏ ⵓⵙⵍⵉⵡⵍⴻⵡ ⴰⴷ ⵜⴻⵙⵖⴻⴷ ⵜⴰⵎⵎⵓⵔⵜ ⵣⵉ ⵊⵊⴰⵔ ⵏⵏⴻⵛ ⵓ ⵄⵍⴰⵃⵙⴰⴱ ⵍⵇⴻⴷⴷ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵏ ⵚⵚⴰⴱⴻⵜ ⴰⴷ ⴽⵉⴽ ⵢⴻⴳⴳ ⵜⴰⵎⴻⵏⵣⵉⵡⵜ. ");
INSERT INTO rift_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","ⵎⴰ ⴰⵇⴰ ⴷⵉⵏⵏⵉ ⵄⴰⴷ ⴰⵟⵟⴰⵙ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵖⴰⵔ ⵣⵣⴰⵜ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⴰⵔⵏⵉⴷ ⴷⵉ ⵜⵜⴰⵎⴰⵏ ⵏ ⵜⵎⴻⵙⵖⵉⵡⵜ ⵏⵏⴻⵙ ⵓ ⵎⴰⵍⴰ ⴰⵇⴰ ⴷⵉⵏⵏⵉ ⵄⴰⴷ ⴷⵔⵓⵙ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵖⴰⵔ ⵣⵣⴰⵜ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⴻⵙⵙⵏⴻⵇⵚⴻⵎ ⴷⵉ ⵜⵜⴰⵎⴰⵏ ⵏ ⵜⵎⴻⵙⵖⵉⵡⵜ ⵏⵏⴻⵙ, ⵎⵉⵏⵣⵉ ⵏⴻⵜⵜⴰ ⴰⴷ ⴰⵛ ⵜⵜ ⵉⵣⵣⴻⵏⵣ ⵄⵍⴰⵃⵙⴰⴱ ⵍⵇⴻⴷⴷ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵏ ⵚⵚⴰⴱⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","ⵡⴰⵔ ⵉⵜⵜⵖⴻⴱⴱⵉ ⵃⴻⴷ ⵊⵊⴰⵔ ⵏⵏⴻⵙ. ⴳⴳⵯⴻⴷ ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵛ, ⵎⵉⵏⵣⵉ ⴰⵇⴰ ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ!” ");
INSERT INTO rift_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“ⴹⴼⴰⵔⴻⵎ ⵜⵉⵡⴻⵚⵚⴰ ⵉⵏⵓ, ⵃⴹⴰⵎ ⵍⴼⴰⵔⴰⵢⵉⴹ ⵉⵏⵓ ⵓⵛⴰ ⴳⴳⴻⵎ ⵣⵣⴰⵢⵙⴻⵏⵜ, ⴰⴷ ⵜⵣⴻⴷⵖⴻⵎ ⵅⴻⵏⵏⵉ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⴷⵉ ⵍⴰⵎⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","ⵜⴰⵎⵎⵓⵔⵜ ⴰⴷ ⵜⴻⵡⵛ ⵍⵖⵉⴵⴻⵜ ⵏⵏⴻⵙ ⵓ ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵜⴻⵛⵛⴻⵎ ⴰⵍ ⵖⴰ ⵜⴻⵊⵊⵉⵡⵏⴻⵎ ⵓⵛⴰ ⴰⴷ ⴷⵉⵏ ⵜⵣⴻⴷⵖⴻⵎ ⴷⵉ ⵍⴰⵎⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","ⵓⵛⴰ ⵎⴰⵍⴰ ⵜⴻⵏⵏⵉⵎ: ‘ⵎⵉⵏ ⵖⴰ ⵏⴻⵛⵛ ⴷⴻⴳ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ? ⵅⵣⴰⵔ, ⵡⴰⵔ ⵏⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵏⵣⴰⵔⵔⴻⵄ ⵓ ⵡⴰⵔ ⵏⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵏⴻⵙⵙⵎⵓⵏⵉ ⵚⵚⴰⴱⴻⵜ ⵏⵏⴻⵖ!’, ");
INSERT INTO rift_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","ⵅⴻⵏⵏⵉ ⴷⴻⴳ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵡⵉⵙⵙ ⵙⴻⵜⵜⴰ ⵏⴻⵛⵛ ⴰⴷ ⴰⵡⴻⵎ ⴷⴷ-ⵙⵙⴻⴽⴽⴻⵖ ⵍⴱⴰⵔⴰⴽⴰ ⵉⵏⵓ ⵃⵉⵎⴰ ⵜⴰⵎⵎⵓⵔⵜ ⴰⴷ ⵜⴻⵡⵛ ⵔⵖⵉⴵⴻⵜ ⵉ ⵜⵍⴰⵜⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","ⴷⴻⴳ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵡⵉⵙⵙ ⵜⵎⴻⵏⵢⴰ ⴰⴷ ⵜⵣⴰⵔⵄⴻⵎ ⵄⴰⵡⴻⴷ. ⵓⵛⴰ ⴰⴷ ⵜⴻⵛⵛⴻⵎ ⵣⵉ ⵚⵚⴰⴱⴻⵜ ⵜⴰⵇⴷⵉⵎⵜ ⴰⵍ ⴰⵙⴻⴳⴳⵯⴰⵙ ⵡⵉⵙⵙ ⵜⴻⵙⵄⴰ. ⴰⵍ ⵉ ⵖⴰ ⵜⵉⵍⵉ ⵚⵚⴰⴱⴻⵜ ⵏⵏⴻⵙ ⵏ ⵊⴷⵉⴷ, ⴰⴷ ⵜⴻⵛⵛⴻⵎ ⵄⴰⴷ ⵣⵉ ⵚⵚⴰⴱⴻⵜ ⵜⴰⵇⴷⵉⵎⵜ.” ");
INSERT INTO rift_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“ⵜⴰⵎⵎⵓⵔⵜ ⵡⴰⵔ ⵜᵉⵜⵜⵎⴻⵏⵣⵉ ⵉ ⵍⴻⴱⴷⴰ, ⵎⵉⵏⵣⵉ ⵜⴰⵎⵎⵓⵔⵜ ⴰⵇⴰ-ⵜⵜ ⵉⵏⵓ ⵓⵛⴰ ⴽⴻⵏⵏⵉⵡ ⵅⴻⵏⵏⵉ ⴷ ⵉⴱⴰⵔⵔⴰⵏⵉⵢⵢⴻⵏ ⴷ ⵉⵎⴻⵄⵣⴰⴱ ⵖⴰⵔⵉ. ");
INSERT INTO rift_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","ⵙ ⵓⵢⴰ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⵜⴻⵡⵛⴻⵎ ⵜⵜⴻⵙⵔⵉⵃ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⴼⴷⵉ ⵜⴰⵎⵎⵓⵔⵜ ⴷⵉ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵉ ⵖⴰⵔⵡⴻⵎ ⵉⴵⴰⵏ ⴷ ⵡⴰⴳⵍⴰ. ");
INSERT INTO rift_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","ⵎⴰⵍⴰ ⵓⵎⴰⵛ ⵉⵥⵍⴻⴹ ⵓⵛⴰ ⵉⵣⵣⴻⵏⵣ ⵛⴰ ⵣⴻⴳ ⵡⴰⴳⵍⴰ ⵏⵏⴻⵙ, ⴰⴷ ⴷⴷ-ⵢⴰⵙ ⵓⵎⴻⴼⴷⵉ ⵏⵏⴻⵙ, ⵍⴰⴵ ⵏⵏⴻⵙ ⵢⵓⴷⵙⴻⵏ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⴼⴷⵉ ⵎⵉⵏ ⵉⵣⵣⴻⵏⵣ ⵓⵎⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","ⵎⴰⵍⴰ ⴰⵔⵢⴰⵣ ⵡⴰⵔ ⵖⴰⵔⴻⵙ ⴱⵓ ⵓⵎⴻⴼⴷⵉ, ⵎⴰⵛⴰ ⴰⴼⵓⵙ ⵏⵏⴻⵙ ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵢⴰⴼ ⵎⵉⵏ ⵉⵛⴼⴰⵏ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜ ⵉⴼⴷⵉ, ");
INSERT INTO rift_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⵃⵙⴻⴱ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵣⴻⴳ ⵡⴰⵎⵉ ⵜᵉⵜⵜⵡⴰⵎⵎⴻⵏⵣ ⵜⴻⵎⵎⵓⵔⵜ ⵓⵛⴰ ⴰⴷ ⵉⵅⴻⴵⴻⵚ ⵎⵉⵏ ⵉⵇⵇⵉⵎⴻⵏ ⵉ ⵡⴻⵔⵢⴰⵣ ⵓⵎⵉ ⵜⵜ ⵉⵣⵣⴻⵏⵣ ⵓⵛⴰ ⴰⴷ ⵜⵜ-ⵉ-ⴷⴷ-ⵢⴰⵔⵔ ⵖⴰⵔ ⵡⴰⴳⵍⴰ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","ⵎⴰⵍⴰ ⴰⴼⵓⵙ ⵏⵏⴻⵙ ⵡⴰⵔ ⵢⵓⴼⵉ ⵍⵇⴻⴷⴷ, ⵃⵉⵎⴰ ⴰⴷ ⴰⵙ ⴷⴷ-ⵢⴰⵔⵔ ⵎⵉⵏ ⵜⵓⵖⴰ ⵉⵣⵣⴻⵏⵣ, ⵅⴻⵏⵏⵉ ⵎⵉⵏ ⵜⵓⵖⴰ ⵉⵣⵣⴻⵏⵣ ⴰⴷ ⵉⵇⵇⵉⵎ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏ ⵡⴻⵏⵏⵉ ⵜ ⵉⵙⵖⵉⵏ ⴰⵍ ⴰⵙⴻⴳⴳⵯⴰⵙ ⵏ ⵓⵙⵍⵉⵡⵍⴻⵡ. ⵎⴰⵛⴰ ⴷⴻⴳ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵏ ⵓⵙⵍⵉⵡⵍⴻⵡ ⴰⴷ ⵉⵜⵜⵡⴰⴼⴻⴽⴽ ⵎⴰⵏ ⴰⵢⴰ ⵓⵛⴰ ⴰⴷ ⵜ-ⵉ-ⴷⴷ-ⵢⴰⵔⵔ ⵖⴰⵔ ⵡⴰⴳⵍⴰ ⵏⵏⴻⵙ.” ");
INSERT INTO rift_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“ⵎⴰⵍⴰ ⵛⴰ ⵏ ⵢⵉⵊⵊⴻⵏ ⵉⵣⵣⴻⵏⵣ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⴻⵙ ⴷⴻⴳ ⵉⵛⵜ ⵏ ⵜⴻⵏⴷⵉⵏⵜ ⵓⵎⵉ ⴷⴷ-ⵏⵏⴹⴻⵏ ⵙ ⵡⴻⵖⴱⴰⵔ ⵅⴻⵏⵏⵉ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⵢⵉⵍⵉ ⵓⴼⴻⴽⴽⵉ ⵏⵏⴻⵙ ⴰⵍ ⴷ ⵉⵄⴷⵓ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ ⴰⵎ ⵉⴽⵎⴻⵍ ⵣⵉ ⵜⵎⴻⵏⵣⵉⵡⵜ ⵏⵏⴻⵙ. ⵎⴰⵔⵔⴰ ⵓⵙⵙⴰⵏ ⵏⵏⵉ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⵜⵜ ⵉⴼⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⵡⴰⵔ ⵜᵉⵜⵜⵡⴰⴼⴷⵉ ⴷⵉ ⵍⵎⵉⵊⴰⵍ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ, ⵅⴻⵏⵏⵉ ⵜⴰⴷⴷⴰⵔⵜ ⴷⵉ ⵜⴻⵏⴷⵉⵏⵜ ⵏⵏⵉ ⴷⴷ-ⵉⵏⵏⴹⴻⵏ ⵙ ⵡⴻⵖⴱⴰⵔ, ⴰⴷ ⵜⵉⵍⵉ ⵍⴻⴱⴷⴰ ⵉ ⵡⴻⵏⵏⵉ ⵜⵜ ⵉⵙⵖⵉⵏ, ⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵏⵏⴻⵙ. ⵡⴰⵔ ⵜᵉⵜⵜⵡⴰⴼⴻⴽⴽ ⴷⴻⴳ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵏ ⵓⵙⵍⵉⵡⵍⴻⵡ. ");
INSERT INTO rift_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","ⵎⴰⵛⴰ ⵜⵓⴷⵔⵉⵏ ⵏⵏⵉ ⵏ ⵍⴻⴷⵛⵓⵔ ⵉ ⵓⵎⵉ ⵡⴰⵔ ⴷⴷ-ⵉⵏⵏⵉⴹ ⵍⴻⵖⴱⴰⵔ ⴰⴷ ⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏⵜ ⴰⵎ ⵢⵉⵊⵊ ⵏ ⵢⴻⵢⵢⴰⵔ ⵏ ⵜⴻⵎⵎⵓⵔⵜ. ⴷⴰⵏⵉⵜⴰ ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵢⵉⵍⵉ ⵍⵃⴻⵇⵇ ⵏ ⵓⴼⴻⴽⴽⵉ ⵓⵛⴰ ⴰⴷ ⵉⵜⵜⵡⴰⴼⴻⴽⴽ ⵢⴻⵢⵢⴰⵔ ⴷⴻⴳ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵏ ⵓⵙⵍⵉⵡⵍⴻⵡ. ");
INSERT INTO rift_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","ⵅ ⵜⵏⴻⴷⴷⴰⵎ ⵏ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ, ⵜⵓⴷⵔⵉⵏ ⴷⵉ ⵜⵏⴻⴷⴷⴰⵎ ⵏ ⵡⴰⴳⵍⴰ ⵏⵙⴻⵏ, ⴰⵇⴰ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⵖⴰⵔⵙⴻⵏ ⵍⵃⴻⵇⵇ ⵉ ⵍⴻⴱⴷⴰ ⵃⵉⵎⴰ ⴰⴷ ⵜⴻⵏⵜ ⴼⴷⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","ⵎⴰⵍⴰ ⵛⴰ ⵏ ⵢⵉⵊⵊⴻⵏ ⵉⴼⴷⴰ ⵉ-ⵜⵜ ⵣⴻⴳ ⵓⴼⵓⵙ ⵏ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜᵉⵜⵜⵡⴰⴼⴻⴽⴽ ⵜⴰⴷⴷⴰⵔⵜ ⵉ ⵉⵎⵎⴻⵏⵣⴻⵏ ⵉ ⵉⵊⵊⴻⵏ ⵉ ⵡⴰⵔ ⵉⴵⵉⵏ ⵣⴻⴳ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ, ⵜⴻⵏⵏⵉ ⵉⴵⴰⵏ ⴷⵉ ⵜⴻⵏⴷⵉⵏⵜ ⵏ ⵡⴰⴳⵍⴰ ⵏⵏⴻⵙ, ⴷⴻⴳ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵏ ⵓⵙⵍⵉⵡⵍⴻⵡ, ⵎⵉⵏⵣⵉ ⵜⵓⴷⵔⵉⵏ ⵏ ⵜⵏⴻⴷⴷⴰⵎ ⵏ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⴰⵇⴰ ⴰⵜⴻⵏⵜ ⴷ ⴰⴳⵍⴰ ⵏⵙⴻⵏ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","ⵉⵢⵢⴰⵔ ⵏⵏⵉ ⵉⵇⵇⵏⴻⵏ ⵖⴰⵔ ⵜⵏⴻⴷⴷⴰⵎ, ⵡⴰⵔ ⵉⵜⵜⵎⴻⵏⵣⵉ, ⵎⵉⵏⵣⵉ ⴰⵇⴰ-ⵜ ⴷ ⴰⴳⵍⴰ ⵏⵙⴻⵏ ⵉ ⵍⴻⴱⴷⴰ.” ");
INSERT INTO rift_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“ⵎⴰⵍⴰ ⵓⵎⴰⵛ ⵉⵥⵍⴻⴹ ⵓⵛⴰ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵏⴻⵙ ⴱⴷⴰⵏ ⴰⴷ ⴰⵔⵊⵉⵊⴻⵏ ⴷⵉⵏ ⵖⴰⵔⴻⴽ, ⵅⴻⵏⵏⵉ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜ-ⵉ-ⴷⴷ-ⵜⵙⴻⵏⵏⴷⴻⴷ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⴱⴻⴷⴷ, ⵓⵍⴰ ⴷ ⴰⴱⴰⵔⵔⴰⵏⵉ ⵏⵉⵖ ⴷ ⴰⵎⵄⴻⵣⵣⴻⴱ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⵇⵇⵉⵎ ⴰⴷ ⵖⴰⵔⴻⴽ ⵉⴷⴷⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","ⵡⴰⵔ ⵣⵣⴰⵢⴻⵙ ⵜⴽⴻⵙⵙⵉⴷ ⴰⵔⵔⵉⴱⴰ ⵓⵍⴰ ⴷ ⴰⵔⴱⴻⵃ, ⵎⴰⵛⴰ ⴰⴷ ⵜⴻⴳⴳⵯⴷⴻⴷ ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵛ, ⵃⵉⵎⴰ ⵓⵎⴰⵛ ⵉ ⴷⵉⵏ ⵖⴰⵔⴻⴽ ⴰⴷ ⵉⵇⵇⵉⵎ ⵉⴷⴷⴰⵔ.    ");
INSERT INTO rift_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","ⵡⴰⵔ ⴷ ⴰⵙ ⵜⵜⵉⵛ ⵜⵎⴻⵏⵢⴰⵜ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵙ ⴰⵔⵔⵉⴱⴰ ⵓ ⵡⴰⵔ ⴷ ⴰⵙ ⵜⵜⵉⵛ ⵎⴰⵛⵛⴰ ⵙ ⵡⴰⵔⴱⴻⵃ. ");
INSERT INTO rift_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","ⴰⵇⴰ ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ, ⵡⴻⵏⵏⵉ ⴽⴻⵏⵏⵉⵡ ⴷⴷ-ⵉⵙⵙⵓⴼⴼⵖⴻⵏ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ, ⵃⵉⵎⴰ ⴰⴷ ⴰⵡⴻⵎ ⵡⵛⴻⵖ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ ⵓ ⵃⵉⵎⴰ ⴰⴷ ⵉⵍⵉⵖ ⴷ ⴰⵔⴻⴱⴱⵉ ⵉ ⴽⴻⵏⵏⵉⵡ.” ");
INSERT INTO rift_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“ⵎⴰⵍⴰ ⵓⵎⴰⵛ ⵉⵥⵍⴻⴹ ⴰⵎ ⴽⵉⴽ ⵉⴵⴰ ⵓⵛⴰ ⵉⵎⵎⴻⵏⵣ ⴰⵛ ⵉ ⵛⴻⴽ, ⵡⴰⵔ ⵜ ⵜᵉⵜⵜⴰⵔⵔⵉⴷ ⴰⴷ ⵉⵅⴷⴻⵎ ⴰⵎ ⵢⵉⵙⵎⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","ⴰⴷ ⴽⵉⴽ ⵉⵣⴷⴻⵖ ⴰⵎⴻⵛⵏⴰⵡ ⴰⵛⴻⵡⵡⴰⵍ, ⴰⵎⴻⵛⵏⴰⵡ ⵉⵊⵊ ⵏ ⵓⵎⵄⴻⵣⵣⴻⴱ, ⵓⵛⴰ ⴰⴷ ⵖⴰⵔⴻⴽ ⵉⵅⴷⴻⵎ ⴰⵍ ⴰⵙⴻⴳⴳⵯⴰⵙ ⵏ ⵓⵙⵍⵉⵡⵍⴻⵡ. ");
INSERT INTO rift_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","ⵅⴻⵏⵏⵉ ⴰⴷ ⵅⴰⴽ ⵉⴼⴼⴻⵖ, ⵏⴻⵜⵜⴰ ⵙⵉⵎⴰⵏⵜ ⵏⵏⴻⵙ ⴰⴽ-ⴷ ⵜⴰⵔⵡⴰ ⵏⵏⴻⵙ, ⵓⵛⴰ ⴰⴷ ⵉⴷⵡⴻⵍ ⵖⴰⵔ ⵍⴰⴵ ⵏⵏⴻⵙ ⵓ ⴰⴷ ⵉⴷⵡⴻⵍ ⵖⴰⵔ ⵡⴰⴳⵍⴰ ⵏ ⵍⴻⵊⴷⵓⴷ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","ⵎⵉⵏⵣⵉ ⴰⵇⴰ ⴰⵜⴻⵏ ⴷ ⵉⵎⵙⴻⵅⴰⵔⵔⴻⵏ ⵉⵏⵓ ⵉⵏⵏⵉ ⵙⵙⵓⴼⴼⵖⴻⵖ ⵏⴻⵛⵛ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ. ⵡⴰⵔ ⵜⵜⵎⴻⵏⵣⵉⵏ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵉⵜⵜⵎⴻⵏⵣⴰ ⵉⵊⵊ ⵏ ⵉⵙⵎⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","ⵡⴰⵔ ⵅⴰⵙ ⵜⵜⵚⴻⴵⴻⴹ ⵙ ⵍⴻⵇⵙⴰⵃⴻⵜ, ⵎⴰⵛⴰ ⴰⴷ ⵜⴻⴳⴳⵯⴷⴻⴷ ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","ⵅ ⵉⵙⵎⴻⵖ ⵏⵏⴻⵛ ⵏⵉⵖ ⵅ ⵜⴰⵢⵢⴰ ⵏⵏⴻⵛ, ⵉⵏⵏⵉ ⵖⴰⵔⴻⴽ ⵖⴰ ⵢⵉⵍⵉⵏ, ⴰⴷ ⵉⵍⵉⵏ ⵣⵉ ⵍⴻⴳⵏⵓⵙ ⵉ ⴷ ⴰⵛ ⴷⴷ-ⵉⵏⵏⴹⴻⵏ. ⵣⵣⴰⵢⵙⴻⵏ ⴰⴷ ⵜⴻⵙⵖⴻⴷ ⵉⵙⴻⵎⵖⴰⵏ ⴷ ⵜⴻⵢⵢⴰⵡⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","ⵜⵣⴻⵎⵎⴰⵔⴻⵎ ⴰⴷ ⵜⴻⵏ ⵜⴻⵙⵖⴻⵎ ⵣⴻⴳ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵉⵎⴻⵄⵣⴰⴱ ⵏⵏⵉ ⵉⵣⴻⴷⴷⵖⴻⵏ ⵊⴰⵔ ⴰⵡⴻⵎ ⴰⵎ ⵢⵉⴱⴰⵔⵔⴰⵏⵉⵢⵢⴻⵏ ⵓ ⵣⵉ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ, ⵉⵏⵏⵉ ⴰⴽⵉⴷⵡⴻⵎ ⵉⴵⴰⵏ, ⵉⵏⵏⵉ ⵜⴻⵏ ⴷⴷ-ⵉⵊⵊⵉⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵡⴻⵎ. ⵏⵉⵜⵏⵉ ⴰⴷ ⴷⴻⵡⵍⴻⵏ ⴷ ⴰⴳⵍⴰ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","ⵓⵛⴰ ⴰⴷ ⵜⴻⵏ ⵜⴻⵊⵊⴻⴷ ⴷ ⵍⵡⴰⵔⵜ ⵉ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵡⴻⵎ ⴰⵡⴰⵔⵏⵉ ⴰⵡⴻⵎ. ⵜⵣⴻⵎⵎⴰⵔⴻⵎ ⴰⴷ ⵜⴻⵏ ⵜⴰⵔⵔⴻⵎ ⴰⴷ ⴰⵡⴻⵎ ⵙⴻⵅⵅⴰⵔⴻⵏ ⵍⴻⴱⴷⴰ, ⵎⴰⵛⴰ ⵅ ⴰⵢⵜⵎⴰⵜⵡⴻⵎ, ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵡⴰⵔ ⵜⵜⵚⴻⵍⵍⵟⴻⵎ ⴽⵓⵍ ⵉⵊⵊ ⵅ ⵡⴻⵏⵏⴻⵖⵏⵉ ⵙ ⵍⴻⵇⵙⴰⵃⴻⵜ.” ");
INSERT INTO rift_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“ⵎⴰⵍⴰ ⵢⵉⵡⴻⴹ ⵓⴼⵓⵙ ⵏ ⵉⵊⵊ ⵏ ⵓⴱⴰⵔⵔⴰⵏⵉ ⵏⵉⵖ ⵏ ⵉⵊⵊ ⵏ ⵓⵎⵄⴻⵣⵣⴻⴱ ⵉ ⵉⵣⴻⴷⴷⵖⴻⵏ ⵊⴰⵔ ⴰⵡⴻⵎ, ⵓⵛⴰ ⵓⵎⴰⵛ ⵉ ⵖⴰⵔⴻⵙ ⵉⵣⴻⴷⴷⵖⴻⵏ ⵉⴷⵡⴻⵍ ⵉⵥⵍⴻⴹ ⵓⵛⴰ ⴰⴷ ⵉⵣⵣⴻⵏⵣ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵉ ⵓⴱⴰⵔⵔⴰⵏⵉ ⵏⵏⵉ ⵉⵣⴻⴷⴷⵖⴻⵏ ⵖⴰⵔⴻⴽ ⵏⵉⵖ ⵉ ⵢⵉⵊⵊⴻⵏ ⵣⵉ ⵊⵊⴰⴷⵉⵔⴰ ⵏ ⵍⴰⴵ ⵏ ⵓⴱⴰⵔⵔⴰⵏⵉ ⵏⵏⵉ, ");
INSERT INTO rift_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","ⵅⴻⵏⵏⵉ ⵉⵄⴻⴷⴷⴻⵍ, ⴰⵡⴰⵔⵏⵉ ⵎⴰ ⵉⵣⵣⴻⵏⵣ ⵉⵅⴻⴼ ⵏⵏⴻⵙ, ⴰⴷ ⵉⵜⵜⵡⴰⴼⴷⵉ. ⵉⵊⵊⴻⵏ ⵣⴻⴳ ⴰⵢⵜⵎⴰⵙ ⴰⴷ ⵜ ⵉⴼⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","ⵉⵄⴻⴷⴷⴻⵍ ⵉ ⵄⴻⵎⵎⵉⵙ ⵏⵉⵖ ⵉ ⵎⵎⵉⵙ ⵏ ⵄⴻⵎⵎⵉⵙ ⴰⴷ ⵜ ⵉⴼⴷⵉ ⵏⵉⵖ ⵉⵊⵊⴻⵏ ⵣⵉ ⵔⴰⴵ ⵏⵏⴻⵙ ⵉ-ⵜ-ⵉ-ⴷⴷ-ⵢⵓⴷⵙⴻⵏ, ⵣⵉ ⵍⵡⴰⵛⵓⵏ ⵏⵏⴻⵙ, ⴰⴷ ⵜ ⵉⴼⴷⵉ, ⵏⵉⵖ ⵎⴰⵍⴰ ⵖⴰⵔⴻⵙ ⵙ ⵎⵉⵏ ⵣⵉ, ⵅⴻⵏⵏⵉ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⵉⴼⴷⵉ ⵉⵅⴻⴼ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","ⴰⴷ ⵉⴳⴳ ⵍⴻⵃⵙⴰⴱ ⴰⴽ-ⴷ ⵡⴻⵏⵏⵉ ⵜ ⵉⵙⵖⵉⵏ ⵣⴻⴳ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵎⵉⵏ ⴷⵉ ⵉⵣⵣⴻⵏⵣ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⴰⵍ ⴰⵙⴻⴳⴳⵯⴰⵙ ⵏ ⵓⵙⵍⵉⵡⵍⴻⵡ ⵓ ⵜⵜⴰⵎⴰⵏ ⵏ ⵜⵎⴻⵏⵣⵉⵡⵜ ⵙ ⵏⵏⵓⵇⴰⵔⵜ ⴰⴷ ⵢⵉⵍⵉ ⵄⵍⴰⵃⵙⴰⴱ ⵍⵇⴻⴷⴷ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵉⵏⵏⵉ ⵉ ⵖⴰ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⴰⵎ ⵡⵓⵙⵙⴰⵏ ⵏ ⵉⵊⵊ ⵏ ⵓⵛⴻⵡⵡⴰⵍ ⵉⵅⴻⴷⴷⵎⴻⵏ ⴰⴽⵉⴷⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","ⵎⴰⵍⴰ ⴰⵇⴰ ⴷⵉⵏ ⵄⴰⴷ ⴰⵟⵟⴰⵙ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵖⴰⵔ ⵣⵣⴰⵜ, ⴰⴷ ⵉⵅⴻⴵⴻⵚ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⵜⵜⵡⴰⴼⴷⵉ ⴰⵏⴻⵛⵜ ⵏ ⵜⴻⵙⵖⴰⵔⵜ ⵏ ⵜⵜⴰⵎⴰⵏ ⵙ ⵜⵎⴻⵏⵢⴰⵜ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵉ ⵣⵉ ⵉⵜⵜⵡⴰⵙⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","ⵎⴰⵍⴰ ⵄⴰⴷ ⴷⵔⵓⵙ ⵉ ⵉⵇⵇⵉⵎⴻⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⴰⵍ ⴰⵙⴻⴳⴳⵯⴰⵙ ⵏ ⵓⵙⵍⵉⵡⵍⴻⵡ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⴳⴳ ⵉ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵉⵊⵊ ⵏ ⵍⴻⵃⵙⴰⴱ ⵓⵛⴰ ⴰⴷ ⵉⵅⴻⴵⴻⵚ ⵜⵜⴰⵎⴰⵏ ⵏ ⵓⴼⴻⴽⴽⵉ ⵏⵏⴻⵙ ⵄⵍⴰⵃⵙⴰⴱ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵉ ⴷⵉⵏ ⵉⵇⵇⵉⵎⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","ⴰⵎ ⵢⵉⵊⵊ ⵏ ⵓⵛⴻⵡⵡⴰⵍ ⴰⴷ ⵖⴰⵔⴻⵙ ⵉⵇⵇⵉⵎ ⵣⴻⴳ ⵓⵙⴻⴳⴳⵯⴰⵙ ⴰⵍ ⴰⵙⴻⴳⴳⵯⴰⵙ. ⵡⴰⵔ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⵅⴰⵙ ⵚⴻⵍⵍⵟⴻⵏ ⵙ ⵍⴻⵇⵙⴰⵃⴻⵜ ⵣⵣⴰⵜ ⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","ⵎⴰⵍⴰ ⵡⴰⵔ ⵉⵜⵜⵡⴰⴼⴷⵉ ⵙ ⵎⴰⵔⵔⴰ ⴰⵢⴰ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⴼⴻⴽⴽ ⴷⴻⴳ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵏ ⵓⵙⵍⵉⵡⵍⴻⵡ, ⵏⴻⵜⵜⴰ ⴷ ⵜⴰⵔⵡⴰ ⵏⵏⴻⵙ ⴰⴽⵉⴷⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","ⵎⵉⵏⵣⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴰⵇⴰ ⴰⵜⴻⵏ ⴷ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵉⵏⵓ, ⵉⵏⵏⵉ ⵙⵙⵓⴼⴼⵖⴻⵖ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ. ⴰⵇⴰ ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ.” ");
INSERT INTO rift_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“ⵡⴰⵔ ⵜⵜⴻⴳⴳⴻⵎ ⵉ ⵢⵉⵅⴻⴼ ⵏⵡⴻⵎ ⵍ’ⴰⵚⵏⴰⵎ, ⵡⴰⵔ ⵙⴱⴻⴷⴷⴰⵎ ⵍⴻⵅⵢⴰⵍ ⵉⵏⴻⵇⵛⴻⵏ ⵓⵍⴰ ⴷ ⵓⵎⴰⵢⴹⵓ ⵉⵇⴻⴷⴷⵙⴻⵏ, ⵡⴰⵔ ⵙⵙⵔⵓⵙⴰⵎ ⵍⴻⵅⵢⴰⵍ ⵏ ⵡⴻⵥⵔⵓ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵡⴻⵎ, ⵃⵉⵎⴰ ⴰⴷ ⴰⵙ ⵜⴱⴻⵏⴷⵇⴻⵎ, ⵎⵉⵏⵣⵉ ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ! ");
INSERT INTO rift_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","ⴰⴷ ⵜⴻⵃⴹⴰⵎ ⵓⵙⵙⴰⵏ ⵏ ⵙⵙⴻⴱⵜ ⵉⵏⵓ ⵓⵛⴰ ⴰⴷ ⴰⵡⴻⵎ ⵉⵇⴰⵔⵔ ⵉⵊⵊ ⵏ ⵓⵡⴻⵇⵇⴰⵔ ⵢⵓⴵⵖⴻⵏ ⵉ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵏⵓ ⵉⵇⴻⴷⴷⵙⴻⵏ, ⴰⵇⴰ ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ!” ");
INSERT INTO rift_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“ⵎⴰⵍⴰ ⴰⴷ ⵜⵓⵢⵓⵔⴻⵎ ⴷⵉ ⵜⵡⴻⵚⵚⴰ ⵉⵏⵓ ⵓⵛⴰ ⴰⴷ ⵜᵉⵟⵟⴼⴻⵎ ⴷⵉ ⵜⵡⴻⵚⵚⴰ ⵉⵏⵓ ⵓⵛⴰ ⴰⴷ ⵣⵣⴰⵢⵙⴻⵏⵜ ⵜⴻⴳⴳⴻⵎ, ");
INSERT INTO rift_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","ⵅⴻⵏⵏⵉ ⵏⴻⵛⵛ ⴰⴷ ⴰⵡⴻⵎ ⵡⵛⴻⵖ ⴰⵏⵥⴰⵔ ⴷⵉ ⵍⵡⴻⵇⵜ ⵏⵏⴻⵙ, ⵓⵛⴰ ⵜⴰⵎⵎⵓⵔⵜ ⴰⴷ ⴷⴷ-ⵜⴰⵡⵉ ⵚⵚⴰⴱⴻⵜ ⵏⵏⴻⵙ, ⵓⵛⴰ ⵜⵉⵛⴻⵊⵊⵓⵔⴰ ⵏ ⵢⴻⵢⵢⴰⵔ ⴰⴷ ⵡⵛⴻⵏⵜ ⵍⵖⵉⴵⴻⵜ ⵏⵙⴻⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","ⴰⴷ ⵢⵉⵍⵉ ⵓⵙⴰⵔⵡⴻⵜ ⴰⵍ ⴰⵍⵇⴰⴹ ⵏ ⵓⴹⵉⵍ ⵓⵛⴰ ⴰⵍⵇⴰⴹ ⵏ ⵓⴹⵉⵍ ⴰⴷ ⵢⵉⵍⵉ ⴰⵍ ⵍⵡⴻⵇⵜ ⵏ ⵓⵣⴰⵔⵔⴻⵄ ⵓⵛⴰ ⴰⴷ ⵜⴻⵛⵛⴻⵎ ⴰⵍ ⵖⴰ ⵜⴻⵊⵊⵉⵡⵏⴻⵎ ⵓⵛⴰ ⴰⴷ ⵜⵣⴻⴷⵖⴻⵎ ⴷⵉ ⵍⴰⵎⴰⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","ⵏⴻⵛⵛ ⴰⴷ ⴳⴳⴻⵖ ⵍⴻⵀⵏⴰ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ. ⵎⴰⵍⴰ ⵜᵉⵟⵟⵚⴻⵎ, ⵡⴰⵔ ⵉⵜⵜⵉⵍⵉ ⵡⵉ ⴽⴻⵏⵏⵉⵡ ⵉ ⵖⴰ ⵉⵙⵙⵉⴳⴳⵯⴷⴻⵏ. ⵏⴻⵛⵛ ⴰⴷ ⵎⵃⵉⵖ ⵍⴻⵡⵃⵓⵛ ⵉⵡⵄⴰⵔⴻⵏ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵓⵛⴰ ⵙⵙⵉⴼ ⵡⴰⵔ ⴷⴷ-ⵉⵥⴻⴽⴽⵯⵉ ⵅ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","ⴰⴷ ⵜⴻⴹⴼⴰⵔⴻⵎ ⵍⵄⴻⴷⵢⴰⵏ ⵏⵡⴻⵎ ⵓⵛⴰ ⵏⵉⵜⵏⵉ ⴰⴷ ⵡⴹⴰⵏ ⵙ ⵙⵙⵉⴼ ⵏⵡⴻⵎ ⵣⵣⴰⵜ ⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","ⵅⴻⵎⵙⴰ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ ⵣⵣⴰⵢⵡⴻⵎ ⴰⴷ ⴹⴼⴰⵔⴻⵏ ⵎⵢⴰ ⵓⵛⴰ ⵎⵢⴰ ⵣⵣⴰⵢⵡⴻⵎ ⴰⴷ ⴹⴼⴰⵔⴻⵏ ⵄⴻⵛⵔⴰ-ⴰⵍⴰⴼ ⵓⵛⴰ ⵍⵄⴻⴷⵢⴰⵏ ⵏⵡⴻⵎ ⴰⴷ ⵡⴹⴰⵏ ⵙ ⵍⴻⵇⴹⴻⵄ ⵏ ⵙⵙⵉⴼ ⵣⵣⴰⵜ ⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵡⴻⵎ.    ");
INSERT INTO rift_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","ⵎⵉⵏⵣⵉ ⵏⴻⵛⵛ ⴰⴷ ⵖⴰⵔⵡⴻⵎ ⴷⴷ-ⴷⴻⵡⵍⴻⵖ ⵓⵛⴰ ⴰⴷ ⴰⵡⴻⵎ ⴷⴷ-ⵊⵊⴻⵖ ⵍⵖⵉⴵⴻⵜ ⵓⵛⴰ ⴰⴷ ⴽⴻⵏⵏⵉⵡ ⴰⵔⵏⵉⵖ ⵓⵛⴰ ⴰⴷ ⵙⵙⵎⴻⵜⵏⴻⵖ ⵍⵄⴰⵀⴷ ⵉⵏⵓ ⴰⴽⵉⴷⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","ⴰⵎ ⵉ ⵖⴰ ⵜⴻⵛⵛⴻⵎ ⵄⴰⴷ ⵣⵉ ⵣⵣⴰⴷ ⵏⵏⵉ ⵜⵅⴻⵣⵏⴻⵎ, ⴰⴷ ⵜⴻⴽⴽⵙⴻⵎ ⴷⴻⵖⵢⴰ ⵣⵣⴰⴷ ⴰⵇⴷⵉⵎ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⴻⵊⵊⴻⵎ ⴰⵎⵛⴰⵏ ⵉ ⵊⴷⵉⴷ. ");
INSERT INTO rift_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","ⵏⴻⵛⵛ ⴰⴷ ⴳⴳⴻⵖ ⵜⴰⵣⴻⴷⴷⵉⵖⵜ ⵉⵏⵓ ⴷⵉ ⵍⵡⴻⵙⵜ ⵏⵡⴻⵎ ⵓⵛⴰ ⵍⴻⵄⵎⴰⵔ ⵉⵏⵓ ⵡⴰⵔ ⵣⵣⴰⵢⵡⴻⵎ ⵉⵜⵜⵄⵉⴼⴼⵉ ⵛⴰ ⵄⴰⴷ. ");
INSERT INTO rift_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","ⴰⴷ ⵓⵢⵓⵔⴻⵖ ⵊⴰⵔ ⴰⵡⴻⵎ, ⵏⴻⵛⵛ ⴰⴷ ⵉⵍⵉⵖ ⴷ ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ ⵓⵛⴰ ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⴰⵢⵉ ⵜⵉⵍⵉⵎ ⴷ ⵍⴳⴻⵏⵙ ⵉⵏⵓ. ");
INSERT INTO rift_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ, ⵡⴻⵏⵏⵉ ⴽⴻⵏⵏⵉⵡ ⴷⴷ-ⵉⵙⵙⵓⴼⴼⵖⴻⵏ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ, ⵃⵉⵎⴰ ⵡⴰⵔ ⵜᵉⵜⵜⵉⵍⵉⵎ ⵄⴰⴷ ⴷ ⵉⵙⴻⵎⵖⴰⵏ ⵏⵙⴻⵏ. ⵏⴻⵛⵛ ⴰⵔⵥⵉⵖ ⵉⵎⵇⴻⴵⴰⴹⴻⵏ ⵏ ⵓⵣⴰⵢⵍⵓ ⵏⵡⴻⵎ ⵓⵛⴰ ⵏⴻⴷⵀⴻⵖ ⴽⴻⵏⵏⵉⵡ ⵙ ⵡⵓⴷⴻⵎ ⵢⵓⵍⵉ.” ");
INSERT INTO rift_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⵡⴰⵔ ⴷ ⴰⵢⵉ ⵜⴻⵙⵍⵉⵎ ⵏⵉⵖ ⵡⴰⵔ ⵜᵉⵜⵜⴻⴳⴳⵉⵎ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵣⵉ ⴽⴻⵏⵏⵉⵡ ⵡⴻⵚⵚⵉⵖ, ");
INSERT INTO rift_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ⵓⵛⴰ ⵎⴰⵍⴰ ⵜⴻⵙⵙⴻⵃⵇⴰⵔⴻⵎ ⵜⵉⵡⴻⵚⵚⴰ ⵉⵏⵓ ⵓ ⵍⴻⵄⵎⴰⵔ ⵏⵡⴻⵎ ⴰⴷ ⵉⵄⵉⴼⴼ ⵣⵉ ⵍⴼⴰⵔⴰⵢⵉⴹ ⵉⵏⵓ, ⴰⵍ ⵖⴰ ⵜⴰⵡⴹⴻⵎ ⵡⴰⵔ ⵜᵉⵜⵜⴻⴳⴳⴻⵎ ⵄⴰⴷ ⵎⴰⵔⵔⴰ ⵜⵉⵡⴻⵚⵚⴰ ⵉⵏⵓ, ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵜⴰⵔⵥⴻⵎ ⵍⵄⴰⵀⴷ ⵉⵏⵓ, ");
INSERT INTO rift_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","ⵅⴻⵏⵏⵉ ⵏⴻⵛⵛ ⴰⴷ ⴰⵡⴻⵎ ⴳⴳⴻⵖ ⴰⵢⴰ: ⴰⴷ ⵅⴰⵡⴻⵎ ⴷⴷ-ⵙⵙⴻⵀⵡⵉⵖ ⴰⵔⵊⴻⴼ ⴷ ⴱⵓ-ⴷⴻⴵⵉⵙ ⴷ ⵜⵎⴻⵙⵙⵉ ⵏ ⴰⵔⵡⴰⵃ ⵏⵏⵉ ⵉ ⵖⴰ ⵉⵜⴻⵃⵃⴰⵏ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵓⵛⴰ ⴰⴷ ⵄⴻⴷⴷⴱⴻⵏ ⵍⴻⵄⵎⴰⵔ. ⴰⴷ ⵜⵣⴰⵔⵄⴻⵎ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵡⴻⵎ ⴱⴰⵟⴻⵍ, ⵎⵉⵏⵣⵉ ⵍⵄⴻⴷⵢⴰⵏ ⵏⵡⴻⵎ ⴰⴷ ⵜⵜ ⵛⵛⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","ⴰⴷ ⴳⴳⴻⵖ ⵓⴷⴻⵎ ⵉⵏⵓ ⴹⵉⴷⴷ ⵏⵡⴻⵎ ⴰⵍⴰⵎⵉ ⵉ ⵖⴰ ⵜⵜⵡⴰⵙⵙⴻⵅⵙⴰⵔⴻⵎ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵍⵄⴻⴷⵢⴰⵏ ⵏⵡⴻⵎ ⵓⵛⴰ ⵉⵏⵏⵉ ⴽⴻⵏⵏⵉⵡ ⵉⵛⴰⵔⵔⵀⴻⵏ ⴰⴷ ⵅⴰⵡⴻⵎ ⵚⴻⵍⵍⵟⴻⵏ ⵓⵛⴰ ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⵜⴰⵔⴻⵡⵍⴻⵎ ⴱⵍⴰ ⴰⴷ ⵢⵉⵍⵉ ⵡⵉ ⴽⴻⵏⵏⵉⵡ ⵉⵔⴰⵔⴰⵏ.” ");
INSERT INTO rift_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“ⵓ ⵎⴰⵍⴰ ⴰⵡⴰⵔⵏⵉ ⵎⴰⵏ ⴰⵢⴰ ⵄⴰⴷ ⵡⴰⵔ ⵖⴰⵔⵉ ⵜⴻⵙⵍⵉⵎ, ⵏⴻⵛⵛ ⴰⴷ ⵖⴰⵔⴻⵙ ⴰⵔⵏⵉⵖ ⵙⴻⴱⵄⴰ ⵏ ⵜⵡⴰⵍⴰⵡⵉⵏ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴽⴻⵏⵏⵉⵡ ⵡⴻⴱⴱⵅⴻⵖ ⵅ ⴷⴷⵏⵓⴱ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","ⵏⴻⵛⵛ ⴰⴷ ⴰⵔⵥⴻⵖ ⴰⵄⴻⴼⴼⴰⵔ ⵏ ⵊⵊⴻⵀⴷ ⵏⵡⴻⵎ, ⵏⴻⵛⵛ ⴰⴷ ⴰⵔⵔⴻⵖ ⴰⵊⴻⵏⵏⴰ ⵏⵡⴻⵎ ⴰⵎ ⵡⵓⵣⵣⴰⵍ ⴷ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵡⴻⵎ ⴰⵎ ⵏⵏⵃⴰⵚ. ");
INSERT INTO rift_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","ⴰⴷ ⵜⴹⴻⵢⵢⵄⴻⵎ ⵊⵊⴻⵀⴷ ⵏⵡⴻⵎ ⴱⴰⵟⴻⵍ, ⵎⵉⵏⵣⵉ ⵜⴰⵎⵎⵓⵔⵜ ⵏⵡⴻⵎ ⵡⴰⵔ ⵜᵉⵜⵜⵉⵛ ⵚⵚⴰⴱⴻⵜ ⵏⵏⴻⵙ ⵓ ⵜⵉⵛⴻⵊⵊⵓⵔⴰ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵡⴰⵔ ⵜⵜⵉⵛⴻⵏⵜ ⵍⵖⵉⴵⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","ⵎⴰⵍⴰ ⵜⴻⵎⵄⴰⵍⴰⵎ ⴽⵉⴷⵉ ⵓⵛⴰ ⵡⴰⵔ ⵜᵉⵜⵜⴻⵅⵙⴻⵎ ⴰⴷ ⴰⵢⵉ ⵜⴻⵙⵍⵉⵎ, ⵅⴻⵏⵏⵉ ⵏⴻⵛⵛ ⴰⴷ ⵅⴰⵡⴻⵎ ⴷⴷ-ⵙⵙⴻⵀⵡⵉⵖ ⵄⴰⴷ ⵙⴻⴱⵄⴰ ⵏ ⵊⵊⵔⴰⵢⴻⵃ ⴰⵏⴻⵛⵜ ⵏ ⴷⴷⵏⵓⴱ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","ⴰⴷ ⵖⴰⵔⵡⴻⵎ ⴷⴷ-ⵙⵙⴻⴽⴽⴻⵖ ⵍⴻⵡⵃⵓⵛ ⵏ ⵍⴻⵅⵍⴰ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴰⵡⴻⵎ ⵅⴻⴹⴼⴻⵏ ⵜⴰⵔⵡⴰ ⵏⵡⴻⵎ, ⴰⴷ ⵙⵙⵀⴻⵍⵍⴽⴻⵏ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏⵡⴻⵎ, ⵓⵛⴰ ⴰⴷ ⵙⵙⵏⴻⵇⵚⴻⵏ ⵍⵄⴰⴷⴰⴷ ⵏⵡⴻⵎ, ⴰⵍⴰⵎⵉ ⵉⴱⵔⵉⴷⴻⵏ ⵏⵡⴻⵎ ⴰⴷ ⴷⴻⵡⵍⴻⵏ ⴷ ⴷⴷⵎⴰⵏⵉ.” ");
INSERT INTO rift_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“ⵎⴰⵍⴰ ⵙ ⵎⴰⵏ ⴰⵢⴰ ⴽⴻⵏⵏⵉⵡ ⵡⴰⵔ ⵖⴰⵔⵉ ⴷⴷ-ⵜⵜⴻⵙⵍⵉⵎ, ⵎⴰⵛⴰ ⵜⴻⵇⵇⵉⵎⴻⵎ ⵜᵉⵜⵜⴻⵎⵄⴰⵍⴰⵎ ⴰⴽⵉⴷⵉ, ");
INSERT INTO rift_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","ⵅⴻⵏⵏⵉ ⵓⵍⴰ ⴷ ⵏⴻⵛⵛ ⴰⴷ ⵇⵇⵉⵎⴻⵖ ⵜⵜⴻⵎⵄⴰⵍⴰⵖ ⴰⴽⵉⴷⵡⴻⵎ ⵓⵛⴰ ⴰⴷ ⵅⴰⵡⴻⵎ ⴷⴷ-ⵙⵙⴻⵀⵡⵉⵖ ⵄⴰⴷ ⵙⴻⴱⵄⴰ ⵏ ⵊⵊⵔⴰⵢⴻⵃ ⵅ ⴷⴷⵏⵓⴱ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","ⴰⴷ ⵅⴰⵡⴻⵎ ⵙⵙⴻⴽⴽⴻⵖ ⵉⵊⵊ ⵏ ⵙⵙⵉⴼ ⵏⵏⵉ ⵉ ⵖⴰ ⵉⵙⵙⴻⴽⴽⴰⵔⴻⵏ ⴰⵏⵜⴰⵇⴻⵎ ⵏ ⵍⵄⴰⵀⴷ ⵉⵏⵓ ⴰⵍ ⵖⴰ ⵜᵉⵜⵜⵡⴰⵙⵙⵎⵓⵏⴻⵎ ⴷⵉ ⵜⵏⴻⴷⴷⴰⵎ ⵏⵡⴻⵎ. ⵅⴻⵏⵏⵉ ⵏⴻⵛⵛ ⴰⴷ ⵙⵙⴻⴽⴽⴻⵖ ⵟⵟⴰⵄⵓⵏ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏⵡⴻⵎ ⵓⵛⴰ ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⵜᵉⵜⵜⵡⴰⵙⴻⵍⵍⵎⴻⵎ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏ ⵍⴻⵄⴷⵓ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","ⵅⵎⵉ ⵖⴰ ⴰⵔⵥⴻⵖ ⵍⴻⵄⵡⴻⵍⵜ ⵏ ⵡⴻⵖⵔⵓⵎ ⵏⵡⴻⵎ, ⵅⴻⵏⵏⵉ ⵄⴻⵛⵔⴰ ⵏ ⵜⴻⵎⵖⴰⵔⵉⵏ ⴰⴷ ⵙⵙⴻⵏⴳⴳⵯⴻⵏⵜ ⴰⵖⵔⵓⵎ ⵏⵡⴻⵎ ⴷⵉ ⵜⴻⴼⵇⵓⵏⵜ ⴷ ⵉⵛⵜ, ⵓⵛⴰ ⴰⵡⴰⵔⵏⵉ ⵉ ⵖⴰ ⵡⴻⵣⵏⴻⵏⵜ ⴰⵖⵔⵓⵎ ⴰⴷ ⵜ ⵉ-ⴷⴷ-ⴰⵔⵔⴻⵏⵜ ⵓⵛⴰ ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⵜ ⵜⴻⵛⵛⴻⵎ, ⵎⴰⵛⴰ ⵡⴰⵔ ⵜᵉⵜⵜⵊⵉⵡⵉⵏⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","ⵎⴰⵍⴰ ⵄⴰⴷ ⵙ ⵎⴰⵏ ⴰⵢⴰ ⵡⴰⵔ ⵖⴰⵔⵉ ⴷⴷ-ⵜᵉⵜⵜⴻⵙⵍⵉⵎ, ⵎⴰⵛⴰ ⴰⴷ ⵜⴻⵇⵇⵉⵎⴻⵎ ⴰⴷ ⵜⴻⵎⵄⴰⵍⴰⵎ ⴰⴽⵉⴷⵉ, ");
INSERT INTO rift_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","ⵅⴻⵏⵏⵉ ⵏⴻⵛⵛ ⴰⴷ ⵅⴰⵡⴻⵎ ⵙⵄⴰⵔⴻⵖ ⵓ ⴰⴷ ⴽⴻⵏⵏⵉⵡ ⴰⵔⴻⴱⴱⵉⵖ, ⵡⴰⵀ ⵙⴻⴱⵄⴰ ⵏ ⵉⵎⵓⵔⴻⵏ ⵏⴻⵛⵛ ⴰⴷ ⴽⴻⵏⵏⵉⵡ ⴰⵔⴻⴱⴱⵉⵖ ⴷⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⴷⴷⵏⵓⴱ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","ⴰⴷ ⵜⴻⵛⵛⴻⵎ ⴰⵢⵙⵓⵎ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵡⴻⵎ ⵓⵍⴰ ⴷ ⴰⵢⵙⵓⵎ ⵏ ⵜⵃⴻⵏⵊⵉⵔⵉⵏ ⵏⵡⴻⵎ ⴰⴷ ⵜ ⵜⴻⵛⵛⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","ⴰⴷ ⴰⵔⴻⴷⴷⴵⴻⵖ ⵍⴻⴳⵄⵓⴷⵉ ⵎⴰⵏⵉ ⵜᵉⵜⵜⵡⴻⵀⵀⴰⴱⴻⵎ ⴷⴷⴱⴰⵢⴻⵃ ⵏⵡⴻⵎ, ⴰⴷ ⵏⴹⴰⵔⴻⵖ ⵉⴱⵉⵍⴰⵔⴻⵏ ⵏⵡⴻⵎ ⵏ ⴰⵔⴻⴱⴱⵉ ⵏ ⵜⴼⵓⵛⵜ, ⴰⴷ ⴰⵔⵔⴻⵖ ⵍⵅⴻⵛⴱⴰⵜ ⵏⵡⴻⵎ ⵅ ⵍⵅⴻⵛⴱⴰⵜ ⵏ ⵉⵎⴻⵢⴹⴰ ⵏ ⵍ’ⴰⵚⵏⴰⵎ ⵏⵡⴻⵎ ⵓⵛⴰ ⵍⴻⵄⵎⴰⵔ ⵉⵏⵓ ⴰⴷ ⵣⵣⴰⵢⵡⴻⵎ ⵉⵄⵉⴼⴼ. ");
INSERT INTO rift_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","ⴰⴷ ⴰⵔⵔⴻⵖ ⵜⵉⵏⴻⴷⴷⴰⵎ ⵏⵡⴻⵎ ⴷ ⵍⵅⴰⵔⴱⴻⵜ ⵓⵛⴰ ⴰⴷ ⴰⵔⴻⴷⴷⴵⴻⵖ ⵜⵉⵣⴰⵡⵉⵢⵢⵉⵏ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵏⵡⴻⵎ ⵓⵛⴰ ⵡⴰⵔ ⵜⵜⴻⵅⵙⴻⵖ ⴰⴷ ⵛⴻⵎⵎⴻⵖ ⵄⴰⴷ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵉⵜⵜⴼⵓⵃⴻⵏ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","ⵡⴰⵀ, ⵏⴻⵛⵛ ⴰⴷ ⴰⵔⴻⴷⴷⴵⴻⵖ ⵜⴰⵎⵎⵓⵔⵜ ⵓⵛⴰ ⵍⵄⴻⴷⵢⴰⵏ ⵏⵡⴻⵎ, ⵉⵏⵏⵉ ⴷⴰⵢⴻⵙ ⵉⵣⴻⴷⴷⵖⴻⵏ, ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵏⵏⵅⴻⵍⵄⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","“ⴰⴷ ⴽⴻⵏⵏⵉⵡ ⵣⵓⵣⵣⴰⵔⴻⵖ ⵊⴰⵔ ⵍⴻⴳⵏⵓⵙ ⵓⵛⴰ ⴰⴷ ⴽⵙⴻⵖ ⵙⵙⵉⴼ ⴰⵡⴰⵔⵏⵉ ⴰⵡⴻⵎ ⵓⵛⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵏⵡⴻⵎ ⴰⴷ ⵜⴻⴷⵡⴻⵍ ⴷ ⵍⴻⵅⵍⴰ ⵓⵛⴰ ⵜⵉⵏⴻⴷⴷⴰⵎ ⵏⵡⴻⵎ ⴰⴷ ⵉⵍⵉⵏⵜ ⴷ ⵍⵅⴰⵔⴱⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","ⵅⴻⵏⵏⵉ ⵜⴰⵎⵎⵓⵔⵜ ⴰⴷ ⵅⴰⵙ ⴰⵔⴹⴰⵏ ⵡⵓⵙⵙⴰⵏ ⵏ ⵙⵙⴻⴱⵜ ⵏⵏⴻⵙ, ⵎⴰⵔⵔⴰ ⵓⵙⵙⴰⵏ ⵏ ⵡⴰⵔⴻⴷⴷⴻⴵ ⵏ ⵜⴻⵎⵎⵓⵔⵜ, ⵓⵎⵉ ⵉ ⵖⴰ ⵜⵉⵍⵉⵎ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵍⵄⴻⴷⵢⴰⵏ ⵏⵡⴻⵎ. ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⴰⵔⴻⵢⵢⴻⵃ ⵜⴻⵎⵎⵓⵔⵜ ⵓ ⴰⴷ ⵜⴻⴳⴳ ⵜⵛⵓⵏⵉ ⵅ ⵡⵓⵙⵙⴰⵏ ⵏ ⵙⵙⴻⴱⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","ⵎⴰⵍⴰ ⵓⵙⵙⴰⵏ ⵏ ⵡⴰⵔⴻⴷⴷⴻⴵ ⴰⴷ ⵖⴰⵔⴻⵙ ⵢⵉⵍⵉ ⵡⴰⵔⴻⵢⵢⴻⵃ, ⵎⵉⵏⵣⵉ ⵜⴰⵎⵎⵓⵔⵜ ⵡⴰⵔ ⵜⴰⵔⴻⵢⵢⵉⵃ ⵛⴰ ⴷⴻⴳ ⵡⵓⵙⵙⴰⵏ ⵏ ⵙⵙⴻⴱⵜ ⵏⵡⴻⵎ ⵍⴰⵎⵉ ⵜⵓⵖⴰ ⴽⴻⵏⵏⵉⵡ ⵜⵣⴻⴷⴷⵖⴻⵎ ⴷⵉⵏⵏⵉ.” ");
INSERT INTO rift_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“ⴰⴷ ⴳⴳⴻⵖ ⵜⵉⴳⴳⵯⵓⴷⵉ ⴷⴻⴳ ⵡⵓⵍⴰⵡⴻⵏ ⵏ ⵢⵉⵏⵏⵉ ⵣⵣⴰⵢⵡⴻⵎ ⵉ ⵖⴰ ⵉⵇⵇⵉⵎⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⴰ ⵏ ⵍⵄⴻⴷⵢⴰⵏ ⵏⵙⴻⵏ, ⴰⵍⴰⵎⵉ ⵍⵃⴻⵙⵙ ⵏ ⵉⵛⵜ ⵏ ⵜⴼⴰⵔⴻⵛⵜ ⵉ ⵢⵉⵡⵉ ⵓⵙⴻⵎⵎⵉⴹ ⴰⴷ ⵅⴰⵙⴻⵏ ⵢⴰⵥⵥⴻⵍ ⵓ ⴰⴷ ⵜⴻⵏ ⵢⴰⵔⵔ ⴰⴷ ⴰⵔⴻⵡⵍⴻⵏ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵉⵜⵜⴰⵔⴻⴽⴽⵡⴰⵍ ⴱⵏⴰⴷⴻⵎ ⵣⵉ ⵙⵙⵉⴼ. ⵏⵉⵜⵏⵉ ⴰⴷ ⵡⴹⴰⵏ, ⵡⴰⵅⵅⴰ ⵡⴰⵔ ⵅⴰⵙⴻⵏ ⵉⵜⵜⵉⵥⵥⴻⵍ ⵃⴻⴷ. ");
INSERT INTO rift_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","ⴰⴷ ⵏⵇⴰⵔⴹⴻⵏ ⵉⵊⵊⴻⵏ ⴷⴻⴳ ⵡⴻⵏⵏⴻⵖⵏⵉ ⴰⵎ ⵅⵎⵉ ⵥⵔⵉⵏ ⵍⴻⵇⴷⴻⵄ ⵏ ⵢⵉⵊⵊ ⵏ ⵙⵙⵉⴼ, ⵡⴰⵅⵅⴰ ⵡⴰⵔ ⵅⴰⵡⴻⵎ ⵉⵜⵜⵉⵥⵥⴻⵍ ⵃⴻⴷ. ⴽⴻⵏⵏⵉⵡ ⵡⴰⵔ ⵜⵣⴻⵎⵎⴰⵔⴻⵏ ⴰⴷ ⵜⴻⵇⵇⵉⵎⴻⵎ ⵜⴱⴻⴷⴷⴻⵎ ⵣⵣⴰⵜ ⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵍⵄⴻⴷⵢⴰⵏ ⵏⵡⴻⵎ, ");
INSERT INTO rift_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","ⵎⴰⵛⴰ ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⵜᵉⵜⵜⵡⴰⵀⴻⵍⵍⴽⴻⵎ ⵊⴰⵔ ⵍⴻⴳⵏⵓⵙ ⵓⵛⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵍⵄⴻⴷⵢⴰⵏ ⵏⵡⴻⵎ ⴰⴷ ⴽⴻⵏⵏⵉⵡ ⵜⴻⵛⵛ.” ");
INSERT INTO rift_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","“ⵉⵏⵏⵉ ⵣⵣⴰⵢⵡⴻⵎ ⵉ ⵖⴰ ⵉⵇⵇⵉⵎⴻⵏ ⴰⴷ ⵉⵙⵍⴰⵡⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⴰ ⵏ ⵍⵄⴻⴷⵢⴰⵏ ⵏⵡⴻⵎ ⴷⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ ⵏⵙⴻⵏ. ⵓⵍⴰ ⴷⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ ⵏ ⵍⴻⵊⴷⵓⴷ ⵏⵙⴻⵏ ⴰⴷ ⵙⵍⴰⵡⴻⵏ ⵏⵉⵜⵏⵉ ⵊⵎⵉⵄ ⴰⴽⵉⴷⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⵏⴻⵄⵎⴻⵏ ⵅ ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ ⵏⵙⴻⵏ ⴷ ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵙⴻⵏ ⵣⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⵍⴻⵖⴷⴰⵔ ⵏⵙⴻⵏ ⵉ ⵣⵉ ⴷ ⴰⵢⵉ ⵖⴷⴰⵔⴻⵏ ⵓⵛⴰ ⵄⴰⵡⴻⴷ ⵎⵎⵄⴰⵍⴰⵏ ⴰⴽⵉⴷⵉ ");
INSERT INTO rift_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","- ⵓⵛⴰ ⵅⴻⵏⵏⵉ ⵓⵍⴰ ⴷ ⵏⴻⵛⵛ ⵎⵎⵄⴰⵍⵉⵖ ⴰⴽⵉⴷⵙⴻⵏ ⵓ ⵉⵡⵢⴻⵖ ⵜⴻⵏ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵍⵄⴻⴷⵢⴰⵏ ⵏⵙⴻⵏ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⴰⵖ ⵓⵍ ⵏⵙⴻⵏ ⵡⴰⵔ ⵉⵅⵜⵉⵏⴻⵏ ⴰⴷ ⵢⴰⴹⴰⵔ ⵓⵛⴰ ⴰⴷ ⵇⴻⴱⵍⴻⵏ ⵍⴻⵅⵍⴰⵚ ⵉ ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ ⵏⵙⴻⵏ - ");
INSERT INTO rift_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","ⵅⴻⵏⵏⵉ ⵏⴻⵛⵛ ⴰⴷ ⵅⴰⵔⵔⵚⴻⵖ ⵄⴰⵡⴻⴷ ⴷⵉ ⵍⵄⴰⵀⴷ ⵉⵏⵓ ⴰⴽ-ⴷ ⵢⴰⵄⵇⵓⴱ ⵓⵛⴰ ⵄⴰⵡⴻⴷ ⴷⵉ ⵍⵄⴰⵀⴷ ⵉⵏⵓ ⴰⴽ-ⴷ ⵉⵙⵃⴰⵇ ⵓⵛⴰ ⴰⴷ ⵅⴰⵔⵔⵚⴻⵖ ⴷⵉ ⵍⵄⴰⵀⴷ ⵉⵏⵓ ⴰⴽ-ⴷ ⵉⴱⵔⴰⵀⵉⵎ ⵓⵛⴰ ⴰⴷ ⵅⴰⵔⵔⵚⴻⵖ ⵄⴰⵡⴻⴷ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","ⵜⴰⵎⵎⵓⵔⵜ ⴰⴷ ⵜᵉⵜⵜⵡⴰⵊⵊ ⵣⵣⴰⵢⵙⴻⵏ ⵓⵛⴰ ⴰⴷ ⵅⴰⵙ ⴰⵔⴹⴰⵏ ⵡⵓⵙⵙⴰⵏ ⵏ ⵙⵙⴻⴱⵜ ⵏⵏⴻⵙ ⵓⵎⵉ ⵖⴰ ⵜⴻⵇⵇⵉⵎ ⴷ ⵉⵛⵜ ⵏ ⵍⵅⴰⵔⴱⴻⵜ ⵅⵎⵉ ⵡⴰⵔ ⴷⴰⵢⴻⵙ ⵣⴻⴷⴷⵖⴻⵏ ⵄⴰⴷ, ⵓⵛⴰ ⵏⵉⵜⵏⵉ ⴰⴷ ⵍⴻⵎⴷⴻⵏ ⴰⴷ ⵇⴻⴱⵍⴻⵏ ⵍⵄⵉⵇⴰⴱ ⵏ ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ ⵏⵙⴻⵏ, ⵎⵉⵏⵣⵉ ⵏⴹⴰⵔⴻⵏ ⵍⴼⴰⵔⴰⵢⵉⴹ ⵉⵏⵓ ⵓ ⵎⵉⵏⵣⵉ ⵍⴻⵄⵎⴰⵔ ⵏⵙⴻⵏ ⵉⵄⵉⴼⴼ ⵣⵉ ⵜⵡⴻⵚⵚⴰ ⵉⵏⵓ.” ");
INSERT INTO rift_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","“ⵙⴻⵏⵏⴻⵊ ⵉ ⵓⵢⴰ, ⴰⵇⴰ ⴷ ⵎⴰⵏ ⴰⵢⴰ: ⵎⴰⵍⴰ ⴰⵇⴰ ⴰⵜⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵍⴻⵄⴷⵢⴰⵏ ⵏⵙⴻⵏ, ⵏⴻⵛⵛ ⵡⴰⵔ ⵜⴻⵏ ⵏⴻⵟⵟⴰⵔⴻⵖ ⵛⴰ ⵓ ⵡⴰⵔ ⵜⴻⵏ ⵜⵜⵄⵉⴼⴼⵉⵖ ⴰⵍ ⵜⴻⵏ ⵖⴰ ⵜⴻⵃⵃⵉⵖ ⵓ ⴰⴷ ⵎⵃⵉⵖ ⵍⵄⴰⵀⴷ ⵉⵏⵓ ⴰⴽⵉⴷⵙⴻⵏ ⵎⵉⵏⵣⵉ ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵙⴻⵏ! ");
INSERT INTO rift_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","ⵎⴰⵛⴰ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏⵙⴻⵏ ⴰⴷ ⵄⴻⵇⵍⴻⵖ ⵅ ⵍⵄⴰⵀⴷ ⵉⵏⵓ ⴰⴽ-ⴷ ⵉⵎⴻⵣⵡⵓⵔⴰ, ⵉⵏⵏⵉ ⵏⴻⴷⵀⴻⵖ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⵣⵣⴰⵜ ⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵍⴻⴳⵏⵓⵙ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⵍⵉⵖ ⴷ ⴰⵔⴻⴱⴱⵉ ⵉ ⵏⵉⵜⵏⵉ, ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ!” ");
INSERT INTO rift_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","ⵜⵉⵏⴰ ⴷ ⵜⵉⵡⴻⵚⵚⴰ ⴷ ⵍⴼⴰⵔⴰⵢⵉⴹ ⴷ ⵉⵣⴻⵔⴼⴰⵏ ⵏⵏⵉ ⵉⴳⴳⴰ ⵙⵉⴷⵉ ⵊⴰⵔ ⴰⵙ ⴷ ⵊⴰⵔ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴷⴻⴳ ⵡⴻⴷⵔⴰⵔ ⵏ ⵙⵉⵏⴰ ⵙ ⵜⵙⴻⵅⵅⴰⵔⵜ ⵏ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“ⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵛⴰ ⵉⵏⵉ ⴰⵙⴻⵏ, ⴰⵇⴰ ⵎⴰⵍⴰ ⵉⵅⵙ ⵃⴻⴷ ⴰⴷ ⵉⴳⴳ ⵉⵊⵊ ⵏ ⵍⵡⴰⵄⴷ ⵉ ⴰⵔⴻⴱⴱⵉ, ⴰⴷ ⵢⵉⵍⵉ ⵜⵜⴰⵎⴰⵏ ⵏ ⵓⴼⴻⴽⴽⵉ ⵏ ⵍⴻⵄⵎⵓⵔ ⵉⵜⵜⵡⴰⵙⵙⵇⴻⴷⴷⵙⴻⵏ ⵉ ⵙⵉⴷⵉ ⵄⵍⴰⵃⵙⴰⴱ ⵍⵇⵉⵎⴻⵜ ⵉ ⵜⵇⴻⴷⴷⴰⵔⴻⴷ ⵛⴻⴽ. ");
INSERT INTO rift_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","ⵎⴰⵍⴰ ⵍⵇⵉⵎⴻⵜ ⵉ ⵜⵇⴻⴷⴷⴰⵔⴻⴷ ⵛⴻⴽ ⴰⵇⴰ ⴷ ⵍⵇⴻⴷⴷ ⵏ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵣⵉ ⵄⵉⵛⵔⵉⵏ ⴰⵍ ⵙⴻⵜⵜⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⵉⵍⵉ ⵍⵇⵉⵎⴻⵜ ⵉ ⵜⵇⴻⴷⴷⴰⵔⴻⴷ ⵅⴻⵎⵙⵉⵏ ⵛⵉⵇⵍⵓ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵄⵍⴰⵃⵙⴰⴱ ⵛⵉⵇⵍⵓ ⵏ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","ⵎⴰⵍⴰ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵎⵖⴰⵔⵜ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⵉⵍⵉ ⵍⵇⵉⵎⴻⵜ ⵉ ⵜⵇⴻⴷⴷⴰⵔⴻⴷ ⵜⵍⴰⵜⵉⵏ ⵛⵉⵇⵍⵓ.” ");
INSERT INTO rift_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","“ⵓⵛⴰ ⵎⴰⵍⴰ ⴷ ⵉⵊⵊ ⵏ ⵓⴱⵍⵉⵖ ⵣⵉ ⵅⴻⵎⵙⴰ ⴰⵍ ⵄⵉⵛⵔⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⵉⵍⵉ ⵍⵇⵉⵎⴻⵜ ⵉ ⵜⵇⴻⴷⴷⴰⵔⴻⴷ ⵉ ⵢⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵄⵉⵛⵔⵉⵏ ⵛⵉⵇⵍⵓ ⵓ ⵉ ⵢⵉⵛⵜ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⵄⴻⵛⵔⴰ ⵛⵉⵇⵍⵓ.” ");
INSERT INTO rift_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","“ⵎⴰⵍⴰ ⴷ ⵉⵊⵊ ⵏ ⵓⵃⴻⵏⵊⵉⵔ ⵣⴻⴳ ⵢⵉⵊⵊ ⵏ ⵓⵢⵓⵔ ⴰⵍ ⵅⴻⵎⵙⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⵉⵍⵉ ⵍⵇⵉⵎⴻⵜ ⵉ ⵜⵇⴻⴷⴷⴰⵔⴻⴷ ⵉ ⵢⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵅⴻⵎⵙⴰ ⵛⵉⵇⵍⵓ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵓ ⵉ ⵢⵉⵛⵜ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⵜⵍⴰⵜⴰ ⵛⵉⵇⵍⵓ ⵏ ⵏⵏⵓⵇⴰⵔⵜ.” ");
INSERT INTO rift_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","“ⵎⴰⵍⴰ ⴷ ⵉⵊⵊ ⵏ ⵎⵎⵉⵙ ⵏ ⴱⵏⴰⴷⴻⵎ ⵣⵉ ⵙⴻⵜⵜⵉⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵏⵉⵖ ⵙⴻⵏⵏⴻⵊ, ⵅⴻⵏⵏⵉ, ⵎⴰⵍⴰ ⵏⴻⵜⵜⴰ ⴷ ⴰⵔⵢⴰⵣ, ⴰⴷ ⵜⵉⵍⵉ ⵍⵇⵉⵎⴻⵜ ⵉ ⵜⵇⴻⴷⴷⴰⵔⴻⴷ ⵅⴻⵎⵎⴻⵙⵟⴰⵛ ⵛⵉⵇⵍⵓ ⵓ ⵎⴰⵍⴰ ⴷ ⵜⴰⵎⵖⴰⵔⵜ ⴰⴷ ⵜⵉⵍⵉ ⵍⵇⵉⵎⴻⵜ ⵉ ⵜⵇⴻⴷⴷⴰⵔⴻⴷ ⵄⴻⵛⵔⴰ ⵏ ⵛⵉⵇⵍⵓ.” ");
INSERT INTO rift_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","“ⵎⴰⵍⴰ ⵜⵓⵖⴰ ⵉⵥⵍⴻⴹ ⴰⵟⵟⴰⵙ ⵓ ⵡⴰⵔ ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵉⵡⵛ ⵍⵇⵉⵎⴻⵜ ⵉ ⵜⵇⴻⴷⴷⴰⵔⴻⴷ ⵛⴻⴽ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜ ⵙⵙⴱⴻⴷⴷⴻⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵓⴽⴻⵀⵀⴰⵏ ⵓⵛⴰ ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⵇⴻⴷⴷⴰⵔ ⵓⴽⴻⵀⵀⴰⵏ ⵍⵇⵉⵎⴻⵜ ⵏⵏⴻⵙ. ⴰⴷ ⵜ ⵉⵇⴻⴷⴷⴰⵔ ⵓⴽⴻⵀⵀⴰⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵎⵉⵏ ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵉⵙⵙⵎⵓⵏ ⵓⴼⵓⵙ ⵏ ⵡⴻⵏⵏⵉ ⵉⵡⵛⵉⵏ ⴰⵡⴰⵍ, ⴰⵎⵎⵓ ⵉ ⵜ ⵖⴰ ⵉⵇⴻⴷⴷⴰⵔ ⵓⴽⴻⵀⵀⴰⵏ.” ");
INSERT INTO rift_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“ⵎⴰⵍⴰ ⴷ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵉ ⵣⵉ ⵖⴰ ⵇⴻⴷⴷⵎⴻⵏ ⵜⴰⵡⵀⵉⴱⵜ ⵉ ⵙⵉⴷⵉ, ⵅⴻⵏⵏⵉ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵣⵣⴰⵢⵙⴻⵏ ⵖⴰ ⵉⵡⵛ ⵏⴻⵜⵜⴰ ⵉ ⵙⵉⴷⵉ, ⴰⴷ ⵢⵉⵍⵉ ⵉⵇⴻⴷⴷⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","ⵡⴰⵔ ⵉⵜⵜⴱⴻⴷⴷⵉⵍ ⵓ ⵡⴰⵔ ⵉⵅⴻⴵⴻⴼ ⴰⵎⵓⴷⴷⴰⵔ ⵉⵛⵏⴰⵏ ⵅ ⵡⴻⵏⵏⵉ ⵉⵇⴻⴱⵃⴻⵏ ⵏⵉⵖ ⴰⵎⵓⴷⴷⴰⵔ ⵉⵇⴻⴱⵃⴻⵏ ⵅ ⵡⴻⵏⵏⵉ ⵉⵛⵏⴰⵏ. ⵎⴰⵍⴰ ⵉⴱⴻⴷⴷⴻⵍ ⵄⴰⴷ ⵉⵛⵜ ⵏ ⵍⴻⴱⵀⵉⵎⴻⵜ ⵙ ⵉⵛⵜ ⵏ ⵍⴻⴱⵀⵉⵎⴻⵜ ⵏⵏⴻⵖⵏⵉ, ⵅⴻⵏⵏⵉ ⵜⴰ ⴷ ⵜⴻⵏⵏⵉ ⵉ ⵅ ⵜⵜ ⵉⴱⴻⴷⴷⴻⵍ ⴰⴷ ⵉⵍⵉⵏⵜ ⵇⴻⴷⴷⵙⴻⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","ⵎⴰⵍⴰ ⵜⴻⴵⴰ ⴷ ⵉⵛⵜ ⵏ ⵍⴻⴱⵀⵉⵎⴻⵜ ⵜⴻⵅⵎⴻⵊ, ⵡⴰⵔ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⵜⵜ ⵇⴻⴷⴷⵎⴻⵏ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵉ ⵙⵉⴷⵉ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵢⴰⵔⵔ ⵍⴻⴱⵀⵉⵎⴻⵜ ⵏⵏⵉ ⴰⴷ ⵜⴱⴻⴷⴷ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵓⴽⴻⵀⵀⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵉⵇⴻⴷⴷⴰⵔ ⵍⵇⵉⵎⴻⵜ ⵏⵏⴻⵙ ⵊⴰⵔ ⵎⵉⵏ ⵉⵛⵏⴰⵏ ⴷ ⵎⵉⵏ ⵡⴰⵔ ⵉⵃⵍⵉⵏ. ⵓⵛⴰ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵉ ⵜⵜ ⵖⴰ ⵜⵇⴻⴷⴷⴰⵔⴻⴷ ⵛⴻⴽ, ⴰⵎ ⵓⴽⴻⵀⵀⴰⵏ, ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵜⵉⵍⵉ. ");
INSERT INTO rift_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","ⵎⴰⵍⴰ ⵏⴻⵜⵜⴰ ⵉⵅⵙ ⵄⴰⴷ ⴰⴷ ⵜⵜ ⵉⴼⴷⵉ, ⴰⴷ ⵅⴰⵙ ⵢⴰⵔⵏⵉ ⵉⵛⵜ ⵏ ⵜⴻⵙⵖⴰⵔⵜ ⵏ ⵜⴻⵅⵎⵓⵙⴻⵛⵜ ⵏ ⵍⵇⵉⵎⴻⵜ ⵉ ⵜⵇⴻⴷⴷⴰⵔⴻⴷ ⵛⴻⴽ.” ");
INSERT INTO rift_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“ⵎⴰⵍⴰ ⵛⴰ ⵏ ⵢⵉⵊⵊⴻⵏ ⵉⵙⵙⵇⴻⴷⴷⴻⵙ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⴻⵙ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⵉⵍⵉ ⵜⵇⴻⴷⴷⴻⵙ ⵉ ⵙⵉⴷⵉ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⵇⴻⴷⴷⴰⵔ ⵓⴽⴻⵀⵀⴰⵏ ⵍⵇⵉⵎⴻⵜ ⵏⵏⴻⵙ ⵊⴰⵔ ⵎⵉⵏ ⵉⵛⵏⴰⵏ ⴷ ⵎⵉⵏ ⵉⵇⴻⴱⵃⴻⵏ. ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵉⵇⴻⴷⴷⴰⵔ ⵓⴽⴻⵀⵀⴰⵏ ⵍⵇⵉⵎⴻⵜ ⵏⵏⴻⵙ, ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵜⵉⵍⵉ. ");
INSERT INTO rift_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","ⵎⴰⵍⴰ ⵡⴻⵏⵏⵉ ⵜⵜ ⵉⵙⵙⵇⴻⴷⴷⵙⴻⵏ ⵉⵅⵙ ⴰⴷ ⵉⴼⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⴻⵙ, ⵅⴻⵏⵏⵉ ⵏⴻⵜⵜⴰ ⴰⴷ ⵅⴰⵙ ⵢⴰⵔⵏⵉ ⵉⵛⵜ ⵏ ⵜⴻⵙⵖⴰⵔⵜ ⵏ ⵜⴻⵅⵎⵓⵙⴻⵛⵜ ⵏ ⵍⵇⵉⵎⴻⵜ ⵉⵜⵜⵡⴰⴳⴳⴻⵏ ⵙ ⵏⵏⵓⵇⴰⵔⵜ ⵓⵛⴰ ⴰⴷ ⵜⵉⵍⵉ ⵏⵏⴻⵙ ⵄⴰⵡⴻⴷ.” ");
INSERT INTO rift_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“ⵎⴰⵍⴰ ⵛⴰ ⵏ ⵢⵉⵊⵊⴻⵏ ⵉⵙⵙⵇⴻⴷⴷⴻⵙ ⵉ ⵙⵉⴷⵉ ⵛⴰ ⵏ ⵜⴻⵙⵖⴰⵔⵜ ⵏ ⵢⴻⵢⵢⴰⵔ ⵏⵏⵉ ⵖⴰⵔⴻⵙ ⵉⴵⴰⵏ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⵇⴻⴷⴷⴰⵔⴻⴷ ⵍⵇⵉⵎⴻⵜ ⵏⵏⴻⵙ ⵄⵍⴰⵃⵙⴰⴱ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵙ. ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏ ⵉⵊⵊ ⵏ ⵓⵃⵓⵎⵉⵔ ⵏ ⵉⵎⴻⵏⴷⵉ ⴰⴷ ⴰⵙ ⴳⴳⴻⵏ ⵅⴻⵎⵙⵉⵏ ⵛⵉⵇⵍⵓ. ");
INSERT INTO rift_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","ⵎⴰⵍⴰ ⵜⵓⵖⴰ ⵉⵙⵙⵇⴻⴷⴷⴻⵙ ⵉⵢⵢⴰⵔ ⵏⵏⴻⵙ ⵣⴻⴳ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵏ ⵓⵙⵍⵉⵡⵍⴻⵡ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⴻⴷⵡⴻⵍ ⵍⵇⵉⵎⴻⵜ ⵏ ⵢⴻⵢⵢⴰⵔ ⵜⴱⴻⴷⴷ ⵄⵍⴰⵃⵙⴰⴱ ⵍⵇⵉⵎⴻⵜ ⵉ ⵜⵇⴻⴷⴷⴰⵔⴻⴷ. ");
INSERT INTO rift_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","ⵎⴰⵍⴰ ⵜⵓⵖⴰ ⵉⵙⵙⵇⴻⴷⴷⴻⵙ ⵉⵢⵢⴰⵔ ⵏⵏⴻⵙ ⴰⵡⴰⵔⵏⵉ ⵉ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵏ ⵓⵙⵍⵉⵡⵍⴻⵡ, ⵅⴻⵏⵏⵉ ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⴰⵙ ⵉⵀⵚⴻⴱ ⵍⵇⵉⵎⴻⵜ ⵙ ⵏⵏⵓⵇⴰⵔⵜ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵉⵇⵇⵉⵎⴻⵏ ⴰⵍ ⴰⵙⴻⴳⴳⵯⴰⵙ ⵏ ⵓⵙⵍⵉⵡⵍⴻⵡ ⵉ ⴷⴷ ⵖⴰ ⵢⴰⵙⴻⵏ ⵓ ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⵉⵍⵉ ⵍⵇⵉⵎⴻⵜ ⵇⴻⵍⵍ ⵅ ⵍⵇⵉⵎⴻⵜ ⵜⵎⵓⵏ ⵉ ⵜⵓⵖⴰ ⵜⵇⴻⴷⴷⴰⵔⴻⴷ ⵛⴻⴽ. ");
INSERT INTO rift_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","ⵎⴰⵍⴰ ⵡⴻⵏⵏⵉ ⵉⵙⵙⵇⴻⴷⴷⵙⴻⵏ ⵉⵢⵢⴰⵔ, ⵉⵅⵙ ⴰⴷ ⵜ ⵉⴼⴷⵉ ⵏⵉⵛⴰⵏ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵢⴰⵔⵏⵉ ⵉⵛⵜ ⵏ ⵜⴻⵙⵖⴰⵔⵜ ⵏ ⵜⴻⵅⵎⵓⵙⴻⵛⵜ ⴷⵉ ⵏⵏⵓⵇⴰⵔⵜ ⵅ ⵍⵇⵉⵎⴻⵜ ⵉ ⵜⵇⴻⴷⴷⴰⵔⴻⴷ ⵛⴻⴽ ⵓⵛⴰ ⵅⴻⵏⵏⵉ ⴰⴷ ⴰⵙ ⵢⵉⵍⵉ ⵄⴰⵡⴻⴷ.” ");
INSERT INTO rift_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","“ⵎⴰⵍⴰ ⵡⴰⵔ ⵉⵅⵙ ⴰⴷ ⵉⴼⴷⵉ ⵉⵢⵢⴰⵔ ⵏⵏⵉ ⵏⵉⵖ ⵎⴰⵍⴰ ⵉⵣⵣⴻⵏⵣ ⵉⵢⵢⴰⵔ ⵉ ⵢⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵏⵏⴻⵖⵏⵉ, ⵅⴻⵏⵏⵉ ⵡⴰⵔ ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵉⵜⵜⵡⴰⴼⴷⵉ ⵄⴰⴷ ⵢⴻⵢⵢⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⴷⴷ-ⵉⴼⴼⴻⵖ ⴷⴻⴳ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵏ ⵓⵙⵍⵉⵡⵍⴻⵡ, ⴰⴷ ⵢⵉⵍⵉ ⵉⵢⵢⴰⵔ ⵉⵇⴻⴷⴷⴻⵙ ⵉ ⵙⵉⴷⵉ ⴰⵎ ⵢⵉⵊⵊ ⵏ ⵢⴻⵢⵢⴰⵔ ⵉⵜⵜⵡⴰⵃⴰⵔⵔⵎⴻⵏ ⵇⴰⵄ. ⴰⴷ ⵢⵉⵍⵉ ⴷ ⴰⴳⵍⴰ ⵏ ⵓⴽⴻⵀⵀⴰⵏ.” ");
INSERT INTO rift_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“ⵎⴰⵍⴰ ⵛⴰ ⵏ ⵢⵉⵊⵊⴻⵏ ⵉⵙⵙⵇⴻⴷⴷⴻⵙ ⵉⵊⵊ ⵏ ⵢⴻⵢⵢⴰⵔ ⵏⵏⵉ ⵉⵙⵖⴰ ⵉ ⵙⵉⴷⵉ, ⵎⴰⵛⴰ ⵡⴰⵔ ⵉⴵⵉ ⵢⴻⵢⵢⴰⵔ ⵏ ⵡⴰⴳⵍⴰ ⵏⵏⴻⵙ, ");
INSERT INTO rift_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","ⵅⴻⵏⵏⵉ ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⴰⵙ ⵉⵃⵙⴻⴱ ⵜⵜⴰⵎⴰⵏ ⵏ ⵍⵇⵉⵎⴻⵜ ⵉ ⵜⵇⴻⴷⴷⴰⵔⴻⴷ ⵛⴻⴽ ⴰⵍ ⴰⵙⴻⴳⴳⵯⴰⵙ ⵏ ⵓⵙⵍⵉⵡⵍⴻⵡ ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⴰⴷ ⵉⵅⴻⴵⴻⵚ ⵍⵇⵉⵎⴻⵜ ⵉ ⵜⵇⴻⴷⴷⴰⵔⴻⴷ ⴷⴻⴳ ⵡⴰⵙⵙ ⵏⵏⵉ ⴷ ⵉⵊⵊ ⴰⵎ ⵉⵛⵜ ⵏ ⵜⵎⴻⵙⵍⴰⵛⵜ ⵜⵇⴻⴷⴷⴻⵙ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","ⴷⴻⴳ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵏ ⵓⵙⵍⵉⵡⵍⴻⵡ ⴰⴷ ⴷⴷ-ⵉⵄⵇⴻⴱ ⵢⴻⵢⵢⴰⵔ ⵄⴰⵡⴻⴷ ⵉ ⵡⴻⵏⵏⵉ ⵅ ⵜ ⵉⵙⵖⴰ, ⵉ ⵡⴻⵏⵏⵉ ⵜⵓⵖⴰ ⵖⴰⵔ ⵜⴻⴵⴰ ⵜⴻⵎⵎⵓⵔⵜ ⴷ ⴰⴳⵍⴰ. ");
INSERT INTO rift_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","ⴰⵇⴻⴷⴷⴰⵔ ⴰⴷ ⵢⵉⵍⵉ ⵄⵍⴰⵃⵙⴰⴱ ⵛⵉⵇⵍⵓ ⵏ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ. ⴰⴷ ⵢⵉⵍⵉ ⵛⵉⵇⵍⵓ ⵄⵉⵛⵔⵉⵏ ⵊⵉⵔⴰ.” ");
INSERT INTO rift_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“ⵎⴰⵛⴰ ⴰⵎⴻⵏⵣⵓ, ⵡⴻⵏⵏⵉ ⵉⴼⴰⵔⵣⴻⵏ ⵉ ⵙⵉⴷⵉ ⵣⵉ ⵍⴻⴱⵀⴰⵢⴻⵎ ⴰⵎ ⵓⵎⴻⵏⵣⵓ, ⵡⴰⵔ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⵜ ⵉⵙⵙⵇⴻⴷⴷⴻⵙ ⵓⵍⴰ ⴷ ⵉⵊⵊⴻⵏ, ⵏⵉⵖ ⴷ ⴰⴼⵓⵏⴰⵙ ⵉ ⵉⴵⴰ ⵏⵉⵖ ⴷ ⵉⵊⵊⴻⵏ ⵣⴻⴳ ⵡⵓⴵⵉ, ⴰⵇⴰ-ⵜ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⵜⵓⵖⴰ-ⵜ ⵣⴻⴳ ⵉⵛⵜ ⵏ ⵍⴻⴱⵀⵉⵎⴻⵜ ⵉⵅⴻⵎⵊⴻⵏ, ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵜⵜ ⵉⴼⴷⵉ ⵄⵍⴰⵃⵚⴰⴱ ⵍⵇⵉⵎⴻⵜ ⵉ ⵜⵇⴻⴷⴷⴰⵔⴻⴷ ⵛⴻⴽ ⵓⵛⴰ ⴰⴷ ⵅⴰⵙ ⵢⴰⵔⵏⵉ ⵉⵛⵜ ⵏ ⵜⴻⵙⵖⴰⵔⵜ ⵏ ⵜⴻⵅⵎⵓⵙⴻⵛⵜ. ⵎⴰⵍⴰ ⵡⴰⵔ ⵜᵉⵜⵜⵡⴰⴼⴻⴷⴷⵉ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⴻⵎⵎⴻⵏⵣ ⵄⵍⴰⵃⵙⴰⴱ ⵍⵇⴻⴷⴷ ⵉ ⵜⵇⴻⴷⴷⴰⵔⴻⴷ ⵛⴻⴽ.” ");
INSERT INTO rift_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“ⵎⴰⵛⴰ ⵓⵍⴰ ⴷ ⵉⵛⵜ ⵏ ⵍⵃⴰⵊⵊⴻⵜ ⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴰⵔⵔⵎⴻⵏ ⵣⴻⴳ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵉ ⵙⵉⴷⵉ ⵣⵉ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵖⴰⵔⴻⵙ ⵉⴵⴰⵏ ⵏ ⵉⵡⴷⴰⵏ ⴷ ⵍⴻⴱⵀⴰⵢⴻⵎ ⴷ ⵉⵢⵢⴰⵔⴻⵏ, ⵡⴰⵔ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⵜⴻⵎⵎⴻⵏⵣ ⵏⵉⵖ ⴰⴷ ⵜᵉⵜⵜⵡⴰⴼⴷⵉ. ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⵜⵜⵡⴰⵃⴰⵔⵔⵎⴻⵏ, ⴰⴷ ⵢⵉⵍⵉ ⴷ ⴰⵎⵇⴻⴷⴷⴰⵙ ⵇⴰⵄ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⵜⵜⵡⴰⵃⴰⵔⵔⵎⴻⵏ ⵇⴰⵄ ⵉ ⵓⵜⴻⵃⵃⵉ, ⵎⵉⵏ ⵉⵜⵜⵡⴰⵃⴰⵔⵔⵎⴻⵏ ⵣⴻⴳ ⵉⵡⴷⴰⵏ, ⵡⴰⵔ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⵉⵜⵜⵡⴰⴼⴷⵉ, ⵎⴰⵛⴰ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵉⵜⵜⵡⴰⵏⴻⵖ ⵏⵉⵛⴰⵏ.” ");
INSERT INTO rift_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“ⵎⴰⵔⵔⴰ ⵜⵉⵄⵛⵓⵔⴰⵢ ⵏ ⵜⴻⵎⵎⵓⵔⵜ, ⵣⵉ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵓ ⵣⵉ ⵍⵖⵉⴵⴻⵜ ⵏ ⵜⵛⴻⵊⵊⵓⵔⴰ, ⴰⴷ ⵉⵍⵉⵏⵜ ⵉ ⵙⵉⴷⵉ, ⴰⵇⴰ ⴰⵜⴻⵏⵜ ⵇⴻⴷⴷⵙⴻⵏⵜ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","ⵎⴰⵍⴰ ⵛⴰ ⵏ ⵢⵉⵊⵊⴻⵏ ⵉⵅⵙ ⴰⴷ ⵉⴼⴷⵉ ⵛⴰ ⵣⵉ ⵍⴻⵄⵛⵓⵔ ⵏⵏⴻⵙ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵅⴰⵙ ⵢⴰⵔⵏⵉ ⵉⵛⵜ ⵏ ⵜⴻⵙⵖⴰⵔⵜ ⴷⵉ ⵅⴻⵎⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","ⵅ ⵎⴰⵔⵔⴰ ⵜⵉⵄⵛⵓⵔⴰⵢ ⵣⴻⴳ ⵉⴼⵓⵏⴰⵙⴻⵏ ⴷ ⵜⴼⵓⵏⴰⵙⵉⵏ ⴷ ⵡⵓⴵⵉ, ⵣⵉ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⴽⴽⵉⵏ ⵙⴰⴷⵓ ⵓⵣⴻⴵⴰⴹ ⵏ ⵓⵎⴻⴽⵙⴰⵡ, ⴰⴷ ⵢⵉⵍⵉ ⵓⵎⵓⴷⴷⴰⵔ ⵡⵉⵙⵙ ⵄⴻⵛⵔⴰ ⵉⵇⴻⴷⴷⴻⵙ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","ⵡⴰⵔ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⵢⴰⵔⵣⵓ ⵎⴰⵎⵎⴻⵛ ⵜⴻⵛⵏⴰ ⵏⵉⵖ ⵎⴰⵎⵎⴻⵛ ⵡⴰⵔ ⵜⴻⵃⵍⵉ ⵉ ⵜⴻⴵⴰ, ⵓⵍⴰ ⵡⴰⵔ ⵜ ⵉⵜⵜⴱⴻⴷⴷⵉⵍ ⵛⴰ, ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⵉⴱⴻⴷⴷⴻⵍ ⵉ-ⵜ, ⵅⴻⵏⵏⵉ ⴰⵎⵓⴷⴷⴰⵔ ⵏⵏⵉ ⴷ ⵡⴻⵏⵏⵉ ⵣⵉ ⵜ ⵉ ⵖⴰ ⵉⴱⴻⴷⴷⴻⵍ ⴰⴷ ⵉⵍⵉⵏ ⵇⴻⴷⴷⵙⴻⵏ. ⵡⴰⵔ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⵉⵜⵜⵡⴰⴼⴷⵉ.” ");
INSERT INTO rift_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","ⴰⵇⴰ ⵜⵉⵏⴰ ⴷ ⵜⵉⵡⴻⵚⵚⴰ ⵏⵏⵉ ⵉ ⵣⵉ ⵉⵡⴻⵚⵚⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ ⵓ ⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴷⴻⴳ ⵡⴻⴷⵔⴰⵔ ⵏ ⵙⵉⵏⴰ. ");
INSERT INTO rift_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ ⴷⵉ ⵍⴻⵅⵍⴰ ⵏ ⵙⵉⵏⴰ, ⴷⴻⴳ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ⴷⴻⴳ ⵡⴰⵙⵙ ⴰⵎⴻⵣⵡⴰⵔⵓ ⵏ ⵓⵢⵓⵔ ⵡⵉⵙⵙ ⵜⵏⴰⵢⴻⵏ, ⴷⴻⴳ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵡⵉⵙⵙ ⵜⵏⴰⵢⴻⵏ ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⴷⴷ-ⴼⴼⵖⴻⵏ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“ⴽⵙⵉⵎ ⵍⵇⴻⴷⴷ ⵏ ⵉⵙⵎⴰⵡⴻⵏ ⵏ ⵎⴰⵔⵔⴰ ⵉⵔⵢⴰⵣⴻⵏ ⵏ ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⴰⵣⴻⴵⵉⴼ ⴰⵣⴻⴵⵉⴼ, ⴰⵎ ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵏⵉⵜⵏⵉ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵜⵓⴷⵔⵉⵏ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","ⵉⵜⵜⵅⴻⵚⵚⴰ ⵛⴻⴽ ⴷ ⵀⴰⵔⵓⵏ ⴰⴷ ⵜⵃⴻⵙⴱⴻⵎ ⴽⵓⵍ ⵉⵊⵊ ⴷⵉ ⵉⵙⵔⴰⵉⵍ ⵣⵉ ⵄⵉⵛⵔⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵙⴻⵏⵏⴻⵊ, ⵎⴰⵔⵔⴰ ⵉⵏⵏⵉ ⴷⴷ-ⵉⴼⴼⵖⴻⵏ ⴰⴽ-ⴷ ⵍⵄⴻⵙⴽⴰⵔ, ⵄⵍⴰⵃⵙⴰⴱ ⵜⵉⵔⴱⵉⵄⵉⵏ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","ⴰⴷ ⴰⵡⴻⵎ ⵉⵡⵛ ⴰⴼⵓⵙ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵣⵉ ⴽⵓⵍ ⵜⴰⵇⴱⵉⵍⵜ, ⴰⵔⵢⴰⵣ ⵉ ⵉⴵⴰⵏ ⴷ ⴰⵣⴻⴵⵉⴼ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⴱⴰⴱⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","ⴰⵇⴰ ⴷ ⵉⵏⴰ ⴷ ⵉⵙⵎⴰⵡⴻⵏ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ ⵏⵏⵉ ⴷ ⴰⵡⴻⵎ ⵖⴰ ⵉⵡⵛⴻⵏ ⴰⴼⵓⵙ: ⵉ ⵔⵓⴱⵉⵏ, ⵉⵍⵉⵚⵓⵔ ⵎⵎⵉⵙ ⵏ ⵛⴰⴷⴰⵢⵓⵔ, ");
INSERT INTO rift_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","ⵉ ⵛⵉⵎⵄⵓⵏ, ⵛⴰⵍⵓⵎⵉⵢⵉⵍ, ⵎⵎⵉⵙ ⵏ ⵚⵓⵔⵉⵢⵛⴰⴷⴷⴰⵢ, ");
INSERT INTO rift_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","ⵉ ⵢⴰⵀⵓⴷⴰ, ⵏⴰⵃⵛⵓⵏ, ⵎⵎⵉⵙ ⵏ ⵄⴰⵎⵎⵉⵏⴰⴷⴰⴱ, ");
INSERT INTO rift_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","ⵉ ⵉⵙⵙⴰⴽⴰⵔ, ⵏⴰⵜⴰⵏⴰⵢⵉⵍ, ⵎⵎⵉⵙ ⵏ ⵚⵓⵖⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","ⵉ ⵣⴰⴱⵓⵍⵓⵏ, ⵉⵍⵉⵢⴰⴱ, ⵎⵎⵉⵙ ⵏ ⵃⵉⵍⵓⵏ, ");
INSERT INTO rift_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","ⵉ ⴰⵢⵜ ⵏ ⵢⵓⵙⵓⴼ: ⵉ ⵉⴼⵔⴰⵢⵉⵎ, ⵉⵍⵉⵛⴰⵎⴰⵄ, ⵎⵎⵉⵙ ⵏ ⴰⵎⵎⵉⵀⵓⴷ, ⵉ ⵎⴰⵏⴰⵙⵙⴰ, ⵊⴰⵎⵍⵉⵢⵉⵍ, ⵎⵎⵉⵙ ⵏ ⴼⴰⴷⴰⵀⵚⵓⵔ, ");
INSERT INTO rift_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","ⵉ ⴱⵉⵏⵢⴰⵎⵉⵏ, ⴰⴱⵉⴷⴰⵏ ⵎⵎⵉⵙ ⵏ ⵊⵉⴷⵄⵓⵏⵉ, ");
INSERT INTO rift_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","ⵉ ⴷⴰⵏ, ⴰⵅⵉⵄⴰⵣⴰⵔ, ⵎⵎⵉⵙ ⵏ ⵄⴰⵎⵎⵉⵛⴰⴷⴷⴰⵢ, ");
INSERT INTO rift_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","ⵉ ⴰⵛⵉⵔ, ⴼⴰⵊⵄⵉⵢⵉⵍ, ⵎⵎⵉⵙ ⵏ ⵄⵓⴽⵔⴰⵏ, ");
INSERT INTO rift_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","ⵉ ⵊⴰⴷ, ⵉⵍⵉⵢⴰⵙⴰⴼ, ⵎⵎⵉⵙ ⵏ ⴷⴰⵄⵓⵢⵉⵍ, ");
INSERT INTO rift_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","ⵉ ⵏⴰⴼⵜⴰⵍⵉ, ⴰⵅⵉⵔⴰⵄ, ⵎⵎⵉⵙ ⵏ ⵄⵉⵏⴰⵏ.” ");
INSERT INTO rift_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","ⵉⵏⴰ ⵜⵓⵖⴰ ⴷ ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵍⴰⵖⴰⵏ ⵣⵉ ⵜⵎⴻⵙⵎⵓⵏⵜ, ⵏⵉⵜⵏⵉ ⴷ ⵍⵃⵓⴽⴽⴰⵎ ⵏ ⵜⵇⴻⴱⴱⴰⵍ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵙⴻⵏ, ⵉⵣⴻⴵⵉⴼⴻⵏ ⵅ ⵍⵓⵍⵓⴼ ⵏ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","ⴽⵙⵉⵏ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ ⵉⵔⵢⴰⵣⴻⵏ ⵏⵏⵉ ⵜⵓⵖⴰ ⵉⵜⵜⵡⴰⵔⴻⵛⵎⴻⵏ ⵙ ⵉⵙⵎⴰⵡⴻⵏ ⵏⵙⴻⵏ ");
INSERT INTO rift_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","ⵓⵛⴰ ⵙⵙⵎⵓⵏⴻⵏ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⵎⴰⵔⵔⴰ ⴷⴻⴳ ⵡⴰⵙⵙ ⴰⵎⴻⵣⵡⴰⵔⵓ ⵏ ⵓⵢⵓⵔ ⵡⵉⵙⵙ ⵜⵏⴰⵢⴻⵏ ⵓⵛⴰ ⵏⵉⵜⵏⵉ ⵅⴻⴱⴱⴰⵔⴻⵏ ⵊⵊⴷⵉⵔⴰ ⵏⵙⴻⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵜⵓⴷⵔⵉⵏ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵙⴻⵏ, ⴰⵎ ⵜⵜⵡⴰⵣⴻⵎⵎⴻⵎⴻⵏ ⵉⵙⵎⴰⵡⴻⵏ ⵏ ⵢⵉⵏⵏⵉ ⵖⴰⵔ ⵉⴵⴰ ⵄⵉⵛⵔⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵙⴻⵏⵏⴻⵊ, ⴰⵣⴻⴵⵉⴼ ⴰⵣⴻⴵⵉⴼ. ");
INSERT INTO rift_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵙ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ, ⴰⵇⴰ ⵉⵃⵙⴻⴱ ⵉ-ⵜⴻⵏ ⴷⵉ ⵍⴻⵅⵍⴰ ⵏ ⵙⵉⵏⴰ. ");
INSERT INTO rift_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","ⴰⵢⵜ ⵏ ⵔⵓⴱⵉⵏ, ⴰⵎⴻⵏⵣⵓ ⵏ ⵉⵙⵔⴰⵉⵍ: ⵜⴰⵔⵡⴰ ⵏⵙⴻⵏ - ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵜⵓⴷⵔⵉⵏ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵙⴻⵏ - ⵉⵏⵏⵉ ⵣⵣⴰⵢⴻⵙ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵉⵙⵎⴰⵡⴻⵏ ⵏⵙⴻⵏ ⴰⵣⴻⴵⵉⴼ ⴰⵣⴻⴵⵉⴼ, ⴽⵓⵍ ⴰⵔⵢⴰⵣ ⵣⵉ ⵄⵉⵛⵔⵉⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵙⴻⵏⵏⴻⵊ, ⵎⴰⵔⵔⴰ ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵉⴼⴼⵖⴻⵏ ⴰⴽ-ⴷ ⵍⵄⴻⵙⴽⴰⵔ, ");
INSERT INTO rift_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","ⵡⴰⵀ, ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⴰⵎⵎⵓ ⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⵔⵓⴱⵉⵏ, ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⵙⴻⵜⵜⴰ ⵓ-ⵔⴻⴱⵄⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⵅⴻⵎⵙⴰ ⵎⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","ⴰⵢⵜ ⵏ ⵛⵉⵎⵄⵓⵏ: ⵜⴰⵔⵡⴰ ⵏⵙⴻⵏ - ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵜⵓⴷⵔⵉⵏ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵙⴻⵏ - ⵉⵏⵏⵉ ⵣⵣⴰⵢⴻⵙ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵍⵄⴰⴷⴰⴷ ⵏ ⵉⵙⵎⴰⵡⴻⵏ ⵏⵙⴻⵏ, ⴰⵣⴻⴵⵉⴼ ⴰⵣⴻⴵⵉⴼ, ⴽⵓⵍ ⴰⵔⵢⴰⵣ ⵣⵉ ⵄⵉⵛⵔⵉⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵙⴻⵏⵏⴻⵊ, ⵎⴰⵔⵔⴰ ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵉⴼⴼⵖⴻⵏ ⴰⴽ-ⴷ ⵍⵄⴻⵙⴽⴰⵔ, ");
INSERT INTO rift_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","ⵡⴰⵀ, ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⴰⵎⵎⵓ ⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⵛⵉⵎⵄⵓⵏ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⵜⴻⵙⵄⴰ ⵓ-ⵅⴻⵎⵙⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⵜⴻⵍⵜ-ⵎⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","ⴰⵢⵜ ⵏ ⵊⴰⴷ: ⵜⴰⵔⵡⴰ ⵏⵙⴻⵏ - ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵜⵓⴷⵔⵉⵏ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵙⴻⵏ - ⵉⵏⵏⵉ ⵣⵣⴰⵢⴻⵙ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵉⵙⵎⴰⵡⴻⵏ ⵏ ⵎⴰⵔⵔⴰ ⵉⵔⵢⴰⵣⴻⵏ ⵣⵉ ⵄⵉⵛⵔⵉⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵙⴻⵏⵏⴻⵊ, ⵎⴰⵔⵔⴰ ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵉⴼⴼⵖⴻⵏ ⴰⴽ-ⴷ ⵍⵄⴻⵙⴽⴰⵔ, ");
INSERT INTO rift_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","ⵡⴰⵀ, ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⴰⵎⵎⵓ ⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⵊⴰⴷ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⵅⴻⵎⵙⴰ ⵓ-ⵔⴻⴱⵄⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⵙⴻⵜⵜⴰ-ⵎⵢⴰ ⵓ-ⵅⴻⵎⵙⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","ⴰⵢⵜ ⵏ ⵢⴰⵀⵓⴷⴰ: ⵜⴰⵔⵡⴰ ⵏⵙⴻⵏ - ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵜⵓⴷⵔⵉⵏ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵙⴻⵏ - ⵉⵏⵏⵉ ⵣⵣⴰⵢⴻⵙ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵉⵙⵎⴰⵡⴻⵏ ⵏ ⵎⴰⵔⵔⴰ ⵉⵔⵢⴰⵣⴻⵏ ⵣⵉ ⵄⵉⵛⵔⵉⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵙⴻⵏⵏⴻⵊ, ⴽⵓⵍ ⵉⵊⵊⴻⵏ ⵉ ⴷⴷ-ⵉⵜⵜⴻⴼⴼⵖⴻⵏ ⴰⴽ-ⴷ ⵍⵄⴻⵙⴽⴰⵔ, ");
INSERT INTO rift_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","ⵡⴰⵀ, ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⴰⵎⵎⵓ ⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⵢⴰⵀⵓⴷⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⴰⵔⴻⴱⵄⴰ ⵓ-ⵙⴻⴱⵄⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⵙⴻⵜⵜⴰ-ⵎⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","ⴰⵢⵜ ⵏ ⵉⵙⵙⴰⴽⴰⵔ: ⵜⴰⵔⵡⴰ ⵏⵙⴻⵏ - ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵜⵓⴷⵔⵉⵏ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵙⴻⵏ - ⵉⵏⵏⵉ ⵣⵣⴰⵢⴻⵙ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵄⵍⴰⵃⵚⴰⴱ ⵉⵙⵎⴰⵡⴻⵏ ⵏ ⵎⴰⵔⵔⴰ ⵉⵔⵢⴰⵣⴻⵏ ⵣⵉ ⵄⵉⵛⵔⵉⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵙⴻⵏⵏⴻⵊ, ⵎⴰⵔⵔⴰ ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵉⴼⴼⵖⴻⵏ ⴰⴽ-ⴷ ⵍⵄⴻⵙⴽⴰⵔ, ");
INSERT INTO rift_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","ⵡⴰⵀ, ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⴰⵎⵎⵓ ⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⵉⵙⵙⴰⴽⴰⵔ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⴰⵔⴻⴱⵄⴰ ⵓ-ⵅⴻⵎⵙⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⴰⵔⴻⴱⵄⴰ-ⵎⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","ⴰⵢⵜ ⵏ ⵣⴰⴱⵓⵍⵓⵏ: ⵜⴰⵔⵡⴰ ⵏⵙⴻⵏ - ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵜⵓⴷⵔⵉⵏ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵙⴻⵏ - ⵉⵏⵏⵉ ⵣⵣⴰⵢⴻⵙ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵉⵙⵎⴰⵡⴻⵏ ⵏ ⵎⴰⵔⵔⴰ ⵉⵔⵢⴰⵣⴻⵏ ⵣⵉ ⵄⵉⵛⵔⵉⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵙⴻⵏⵏⴻⵊ, ⵎⴰⵔⵔⴰ ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵉⴼⴼⵖⴻⵏ ⴰⴽ-ⴷ ⵍⵄⴻⵙⴽⴰⵔ, ");
INSERT INTO rift_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","ⵡⴰⵀ, ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⴰⵎⵎⵓ ⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⵣⴰⴱⵓⵍⵓⵏ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⵙⴻⴱⵄⴰ ⵓ-ⵅⴻⵎⵙⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⴰⵔⴻⴱⵄⴰ-ⵎⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","ⴰⵢⵜ ⵏ ⵢⵓⵙⵓⴼ: ⴰⵢⵜ ⵏ ⵉⴼⵔⴰⵢⵉⵎ: ⵜⴰⵔⵡⴰ ⵏⵙⴻⵏ - ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵜⵓⴷⵔⵉⵏ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵙⴻⵏ, ⵉⵏⵏⵉ ⵣⵣⴰⵢⴻⵙ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵉⵙⵎⴰⵡⴻⵏ ⵏ ⵎⴰⵔⵔⴰ ⵉⵔⵢⴰⵣⴻⵏ ⵣⵉ ⵄⵉⵛⵔⵉⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵙⴻⵏⵏⴻⵊ, ⵎⴰⵔⵔⴰ ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵉⴼⴼⵖⴻⵏ ⴰⴽ-ⴷ ⵍⵄⴻⵙⴽⴰⵔ, ");
INSERT INTO rift_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","ⵡⴰⵀ, ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⴰⵎⵎⵓ ⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⵉⴼⵔⴰⵢⵉⵎ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⴰⵔⴻⴱⵄⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⵅⴻⵎⵙⴰ-ⵎⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","ⴰⵢⵜ ⵏ ⵎⴰⵏⴰⵙⵙⴰ: ⵜⴰⵔⵡⴰ ⵏⵙⴻⵏ - ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵜⵓⴷⵔⵉⵏ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵙⴻⵏ, ⵉⵏⵏⵉ ⵣⵣⴰⵢⴻⵙ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵉⵙⵎⴰⵡⴻⵏ ⵏ ⵎⴰⵔⵔⴰ ⵉⵔⵢⴰⵣⴻⵏ ⵣⵉ ⵄⵉⵛⵔⵉⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵙⴻⵏⵏⴻⵊ, ⵎⴰⵔⵔⴰ ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵉⴼⴼⵖⴻⵏ ⴰⴽ-ⴷ ⵍⵄⴻⵙⴽⴰⵔ, ");
INSERT INTO rift_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","ⵡⴰⵀ, ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⴰⵎⵎⵓ ⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⵎⴰⵏⴰⵙⵙⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⵜⵏⴰⵢⴻⵏ ⵓ-ⵜⵍⴰⵜⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⵎⵉⵜⴰⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","ⴰⵢⵜ ⵏ ⴱⵉⵏⵢⴰⵎⵉⵏ: ⵜⴰⵔⵡⴰ ⵏⵙⴻⵏ - ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵜⵓⴷⵔⵉⵏ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵙⴻⵏ, ⵉⵏⵏⵉ ⵣⵣⴰⵢⴻⵙ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵉⵙⵎⴰⵡⴻⵏ ⵏ ⵎⴰⵔⵔⴰ ⵉⵔⵢⴰⵣⴻⵏ ⵣⵉ ⵄⵉⵛⵔⵉⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵙⴻⵏⵏⴻⵊ, ⵎⴰⵔⵔⴰ ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵉⴼⴼⵖⴻⵏ ⴰⴽ-ⴷ ⵍⵄⴻⵙⴽⴰⵔ, ");
INSERT INTO rift_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","ⵡⴰⵀ, ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⴰⵎⵎⵓ ⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⴱⵉⵏⵢⴰⵎⵉⵏ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⵅⴻⵎⵙⴰ ⵓ-ⵜⵍⴰⵜⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⴰⵔⴻⴱⵄⴰ-ⵎⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","ⴰⵢⵜ ⵏ ⴷⴰⵏ: ⵜⴰⵔⵡⴰ ⵏⵙⴻⵏ - ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵜⵓⴷⵔⵉⵏ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵙⴻⵏ, ⵉⵏⵏⵉ ⵣⵣⴰⵢⴻⵙ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵉⵙⵎⴰⵡⴻⵏ ⵏ ⵎⴰⵔⵔⴰ ⵉⵔⵢⴰⵣⴻⵏ ⵣⵉ ⵄⵉⵛⵔⵉⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵙⴻⵏⵏⴻⵊ, ⵎⴰⵔⵔⴰ ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵉⴼⴼⵖⴻⵏ ⴰⴽ-ⴷ ⵍⵄⴻⵙⴽⴰⵔ, ");
INSERT INTO rift_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","ⵡⴰⵀ, ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⴰⵎⵎⵓ ⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⴷⴰⵏ ⵜⵓⵖⴰ ⵜⴻⵏ ⴷⵉ ⵜⵏⴰⵢⴻⵏ ⵓ-ⵙⴻⵜⵜⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⵙⴻⴱⵄⴰ-ⵎⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","ⴰⵢⵜ ⵏ ⴰⵛⵉⵔ: ⵜⴰⵔⵡⴰ ⵏⵙⴻⵏ - ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵜⵓⴷⵔⵉⵏ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵙⴻⵏ, ⵉⵏⵏⵉ ⵣⵣⴰⵢⴻⵙ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵉⵙⵎⴰⵡⴻⵏ ⵏ ⵎⴰⵔⵔⴰ ⵉⵔⵢⴰⵣⴻⵏ ⵣⵉ ⵄⵉⵛⵔⵉⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵙⴻⵏⵏⴻⵊ, ⵎⴰⵔⵔⴰ ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵉⴼⴼⵖⴻⵏ ⴰⴽ-ⴷ ⵍⵄⴻⵙⴽⴰⵔ, ");
INSERT INTO rift_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","ⵡⴰⵀ, ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⴰⵎⵎⵓ ⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⴰⵛⵉⵔ ⵜⵓⵖⴰ ⵜⴻⵏ ⴷⵉ ⵡⴰⵃⵉⵜ ⵓ-ⵔⴻⴱⵄⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⵅⴻⵎⵙⴰ-ⵎⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","ⴰⵢⵜ ⵏ ⵏⴰⴼⵜⴰⵍⵉ: ⵜⴰⵔⵡⴰ ⵏⵙⴻⵏ - ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵜⵓⴷⵔⵉⵏ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵙⴻⵏ, ⵉⵏⵏⵉ ⵣⵣⴰⵢⴻⵙ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵉⵙⵎⴰⵡⴻⵏ ⵏ ⵎⴰⵔⵔⴰ ⵉⵔⵢⴰⵣⴻⵏ ⵣⵉ ⵄⵉⵛⵔⵉⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵙⴻⵏⵏⴻⵊ, ⵎⴰⵔⵔⴰ ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵉⴼⴼⵖⴻⵏ ⴰⴽ-ⴷ ⵍⵄⴻⵙⴽⴰⵔ, ");
INSERT INTO rift_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","ⵡⴰⵀ, ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⴰⵎⵎⵓ ⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⵏⴰⴼⵜⴰⵍⵉ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⵜⵍⴰⵜⴰ ⵓ-ⵅⴻⵎⵙⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⴰⵔⴻⴱⵄⴰ-ⵎⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","ⵉⵏⴰ ⴷ ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ, ⵉⵏⵏⵉ ⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵙ ⵓⴼⵓⵙ ⵏ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ ⴷ ⵍⵃⵓⴽⴽⴰⵎ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵜⴻⵏⵄⴰⵛ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ, ⵉⵊⵊⴻⵏ ⵡⴻⵔⵢⴰⵣ ⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⴱⴰⴱⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","ⵎⴰⵔⵔⴰ ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵣⴻⴳ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ - ⴰⵎ ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵏⵉⵜⵏⵉ ⵄⵍⴰⵃⵙⴰⴱ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵙⴻⵏ - ⵎⴰⵔⵔⴰ ⵉⵏⵏⵉ ⵖⴰⵔ ⵉⴵⴰ ⵄⵉⵛⵔⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵙⴻⵏⵏⴻⵊ, ⴽⵓⵍ ⵉⵊⵊ ⵡⴻⵏⵏⵉ ⴷⴷ-ⵉⵜⵜⴻⴼⴼⵖⴻⵏ ⴰⴽ-ⴷ ⵍⵄⴻⵙⴽⴰⵔ, ");
INSERT INTO rift_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","ⵡⴰⵀ, ⵎⴰⵔⵔⴰ ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⵙⴻⵜⵜⴰ-ⵎⵢⴰ ⵓ-ⵟⴻⵍⵜ-ⴰⵍⴰⴼ ⵓ-ⵅⴻⵎⵙⴰ-ⵎⵢⴰ ⵓ-ⵅⴻⵎⵙⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⵡⴰⵔ ⵛⴰⵔⵛⴻⵏ ⵛⴰ ⵊⴰⵔ ⴰⵙⴻⵏ ⴷⵉ ⵍⴻⵃⵙⴰⴱ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵙⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","ⵎⵉⵏⵣⵉ ⵙⵉⴷⵉ ⵜⵓⵖⴰ ⵉⵙⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“ⵎⵖⵉⵔ ⵜⴰⵇⴱⵉⵍⵜ ⵏ ⵍⴰⵡⵉ ⵡⴰⵔ ⵜⵜ ⵜⵜᵉⵃⵙⴻⴱ ⵛⴰ ⵓ ⵡⴰⵔ ⵜⵜ ⵣⴻⵎⵎⵉ ⵛⴰ ⴰⵣⴻⴵⵉⴼ ⴰⵣⴻⴵⵉⴼ ⵊⴰⵔ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","ⵎⴰⵛⴰ ⵉⵜⵜⵅⴻⵚⵚⴰ ⵛⴻⴽ ⵙ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵛ, ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⵅ ⵜⵣⴻⴷⴷⵉⵖⵜ ⵏ ⵛⵛⵀⴰⴷⴻⵜ ⵓ ⵅ ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ ⵏⵏⴻⵙ ⵓ ⵅ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴷ ⴰⵙ ⴷⴷ-ⵢⵓⵙⵉⵏ. ⵏⵉⵜⵏⵉ ⴰⴷ ⴰⵔⴱⵓⵏ ⵜⴰⵣⴻⴷⴷⵉⵖⵜ ⴰⴽ-ⴷ ⵍⴻⵇⵛⵓⵄ ⵏⵏⴻⵙ ⵎⴰⵔⵔⴰ, ⵓⵛⴰ ⴰⴷ ⴷⴰⵢⴻⵙ ⵙⴻⵅⵅⴰⵔⴻⵏ. ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵡⵜⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⵎⵉⵏ ⴷⴷ-ⵉⵏⵏⴹⴻⵏ ⵉ ⵜⵣⴻⴷⴷⵉⵖⵜ. ");
INSERT INTO rift_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","ⵎⴰⵍⴰ ⴰⴷ ⵜᵉⵜⵜⵡⴰⴼⵙⵉ ⵜⵣⴻⴷⴷⵉⵖⵜ, ⴰⴷ ⵜⵜ ⵀⴻⴷⵎⴻⵏ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⵓⵛⴰ ⵎⴰⵍⴰ ⵜⵉⵡⴻⴹ ⵜⵣⴻⴷⴷⵉⵖⵜ ⵖⴰⵔ ⵍⵎⴰⵔⴳⴻⵀ ⴰⵏⴻⴹⴼⴰⵔ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⵜ ⵙⵙⴱⴻⴷⴷⴻⵏ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⵄⴰⵡⴻⴷ. ⵎⴰⵍⴰ ⴷⴷ-ⵉⵇⴰⵔⵔⴻⴱ ⵛⴰ ⵏ ⵓⴱⴰⵔⵔⴰⵏⵉ, ⵅⴻⵏⵏⵉ ⵏⴻⵜⵜⴰ ⴰⴷ ⵉⵜⵜⵡⴰⵏⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴰⴷ ⵡⵜⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏ ⵍⵎⴰⵔⴳⴻⵃ ⵏⵙⴻⵏ, ⴽⵓⵍ ⵉⵊⵊ ⵖⴰⵔ ⵜⵄⴻⴵⴰⵏⵜ ⵏⵏⴻⵙ, ⴰⵎ ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵏⵉⵜⵏⵉ ⵄⵍⴰⵃⵙⴰⴱ ⵜⵉⵔⴱⵉⵄⵉⵏ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⴰⴷ ⵡⵜⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⵖⴰⵔ ⴽⵓⵍ ⵊⵊⵉⵀⴻⵜ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ ⵏ ⵛⵛⵀⴰⴷⴻⵜ, ⵃⵉⵎⴰ ⵡⴰⵔ ⵉⵜⵜⵉⵍⵉ ⵓⴷⵓⵇⵇⴻⵣ ⵏ ⵡⴻⵖⴹⴰⴱ ⵅ ⵜⵎⴻⵙⵎⵓⵏⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ⵉⵜⵜⵅⴻⵚⵚⴰ ⵉ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⴰⴷ ⵃⴹⴰⵏ ⵅ ⵜⵣⴻⴷⴷⵉⵖⵜ ⵏ ⵛⵛⵀⴰⴷⴻⵜ.” ");
INSERT INTO rift_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","ⵓⵛⴰ ⴳⴳⵉⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵙ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ, ⵡⴰⵀ, ⴰⵎⵎⵓ ⵉ-ⵜ ⴳⴳⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴰⴷ ⵡⵜⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴽⵓⵍ ⵉⵊⵊ ⵖⴰⵔ ⵜⵄⴻⴵⴰⵏⵜ ⵏⵏⴻⵙ, ⵖⴰⵔ ⵍⴻⵄⵍⴰⵎⴰⵜ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵙⴻⵏ. ⴰⴷ ⵡⵜⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⵛⵡⴰⵢⵜ ⵖⴰⵔ ⵍⴰⴳⴳⵯⴰⵊ ⵖⴰⵔ ⵎⴰⵔⵔⴰ ⵉⵖⴻⵣⴷⵉⵙⴻⵏ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ.” ");
INSERT INTO rift_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","ⵉⵏⵏⵉ ⵉⴵⴰⵏ ⵙⴰⴷⵓ ⵏ ⵜⵄⴻⴵⴰⵏⵜ ⵏ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵏ ⵢⴰⵀⵓⴷⴰ ⴰⴷ ⵡⵜⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴰⵎ ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵏⵉⵜⵏⵉ ⵄⵍⴰⵃⵙⴰⴱ ⵜⵉⵔⴱⵉⵄⵉⵏ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵙⴻⵏ ⵖⴰⵔ ⵛⵛⴰⵔⵇ, ⵖⴰⵔ ⵎⴰⵏⵉⵙ ⴷⴷ-ⵜⵏⴻⵇⵇⴰⵔ ⵜⴼⵓⵛⵜ. ⵏⴰⵃⵛⵓⵏ, ⵎⵎⵉⵙ ⵏ ⵄⴰⵎⵎⵉⵏⴰⴷⴰⴱ, ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵍⵃⴰⴽⴻⵎ ⵏ ⴰⵢⵜ ⵏ ⵢⴰⵀⵓⴷⴰ. ");
INSERT INTO rift_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵉ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵏⴻⵙ, ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⴰⵔⴻⴱⵄⴰ ⵓ-ⵙⴻⴱⵄⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⵙⴻⵜⵜⴰ-ⵎⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","ⵣⵣⴰⵜⴻⵙ ⴰⴷ ⵜⴻⵡⵡⴻⵜ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⵉⵙⵙⴰⴽⴰⵔ ⵉⵇⵉⴹⴰⵏ ⵏⵏⴻⵙ. ⵏⴰⵜⴰⵏⴰⵢⵉⵍ, ⵎⵎⵉⵙ ⵏ ⵚⵓⵖⴰⵔ, ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵍⵃⴰⴽⴻⵎ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵙⴰⴽⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵉ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵏⴻⵙ, ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⴰⵔⴻⴱⵄⴰ ⵓ-ⵅⴻⵎⵙⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⴰⵔⴻⴱⵄⴰ-ⵎⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","ⵅⴻⵏⵏⵉ ⵜⴰⵇⴱⵉⵍⵜ ⵏ ⵣⴰⴱⵓⵍⵓⵏ. ⵉⵍⵉⵢⴰⴱ, ⵎⵎⵉⵙ ⵏ ⵀⵉⵍⵓⵏ, ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵍⵃⴰⴽⴻⵎ ⵏ ⴰⵢⵜ ⵏ ⵣⴰⴱⵓⵍⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵉ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵏⴻⵙ, ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⵙⴻⴱⵄⴰ ⵓ-ⵅⴻⵎⵙⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⴰⵔⴻⴱⵄⴰ-ⵎⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵏ ⵢⴰⵀⵓⴷⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⵎⴰⵔⵔⴰ ⵊⵎⵉⵄ ⴷⵉ ⵎⵢⴰ ⵓ-ⵙⴻⵜⵜⴰ ⵓ-ⵜⵎⴰⵏⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⴰⵔⴻⴱⵄⴰ-ⵎⵢⴰ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ, ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵜⵉⵔⴱⵉⵄⵉⵏ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵙⴻⵏ. ⵏⵉⵜⵏⵉ ⴰⴷ ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴰⵎⴻⵣⵡⴰⵔⵓ. ");
INSERT INTO rift_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","ⵖⴰⵔ ⵍⵊⴰⵏⵓⴱ ⴰⴷ ⵜⵉⵍⵉ ⵜⵄⴻⴵⴰⵏⵜ ⵏ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵏ ⵔⵓⴱⵉⵏ. ⵏⵉⵜⵏⵉ ⴰⴷ ⵉⵍⵉⵏ ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵜⵉⵔⴱⵉⵄⵉⵏ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵙⴻⵏ. ⵉⵍⵉⵚⵓⵔ, ⵎⵎⵉⵙ ⵏ ⵛⴰⴷⴰⵢⵢⵓⵔ, ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵍⵃⴰⴽⴻⵎ ⵏ ⴰⵢⵜ ⵏ ⵔⵓⴱⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵉ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵏⴻⵙ, ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⵙⴻⵜⵜⴰ ⵓ-ⵔⴻⴱⵄⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⵅⴻⵎⵙⴰ-ⵎⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","ⵣⵣⴰⵜⴻⵙ ⴰⴷ ⵜⴻⵡⵡⴻⵜ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⵛⵉⵎⵄⵓⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵏⴻⵙ. ⵛⴰⵍⵓⵎⵉⵢⵉⵍ, ⵎⵎⵉⵙ ⵏ ⵚⵓⵔⵉⵢⵛⴰⴷⴷⴰⵢ, ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵍⵃⴰⴽⴻⵎ ⵏ ⴰⵢⵜ ⵏ ⵛⵉⵎⵄⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵉ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵏⴻⵙ, ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⵜⴻⵙⵄⴰ ⵓ-ⵅⴻⵎⵙⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⵜⴻⵍⵜ-ⵎⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","ⵅⴻⵏⵏⵉ ⵜⴰⵇⴱⵉⵍⵜ ⵏ ⵊⴰⴷ. ⵉⵍⵢⴰⵙⴰⴼ, ⵎⵎⵉⵙ ⵏ ⵔⴰⵄⵓⵢⵉⵍ, ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵍⵃⴰⴽⴻⵎ ⵏ ⴰⵢⵜ ⵏ ⵊⴰⴷ. ");
INSERT INTO rift_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵉ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵏⴻⵙ, ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⵅⴻⵎⵙⴰ ⵓ-ⵔⴻⴱⵄⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⵙⴻⵜⵜⴰ-ⵎⵢⴰ ⵓ-ⵅⴻⵎⵙⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵏ ⵔⵓⴱⵉⵏ, ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⵎⴰⵔⵔⴰ ⴷⵉ ⵎⵢⴰ ⵓ-ⵡⴰⵃⵉⵜ ⵓ-ⵅⴻⵎⵙⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⴰⵔⴻⴱⵄⴰ-ⵎⵢⴰ ⵓ-ⵅⴻⵎⵙⵉⵏ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ, ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵜⵉⵔⴱⵉⵄⵉⵏ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵙⴻⵏ. ⵏⵉⵜⵏⵉ ⴰⴷ ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⵡⵉⵙⵙ ⵜⵏⴰⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⵜⵜⵡⴰⴼⵙⵉ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⴰⴽ-ⴷ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ, ⴷⵉ ⵍⵡⴻⵙⵟ ⵏ ⵎⴰⵔⵔⴰ ⵍⵄⴻⵙⴽⴰⵔ. ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵖⴰ ⵡⵜⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴰⵎⵎⵓ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵎⵎⵓⵟⵟⵉⵢⴻⵏ ⵄⴰⵡⴻⴷ, ⴽⵓⵍ ⵉⵊⵊ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏⵏⴻⵙ, ⴰⵎ ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵏⵉⵜⵏⵉ ⵄⵍⴰⵃⵙⴰⴱ ⵜⵉⵄⴻⴵⴰⵏⵉⵏ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","ⵖⴰⵔ ⵍⵖⴰⵔⴱ ⴰⴷ ⵜⵉⵍⵉ ⵜⵄⴻⴵⴰⵏⵜ ⵏ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵏ ⵉⴼⵔⴰⵢⵉⵎ. ⵏⵉⵜⵏⵉ ⴰⴷ ⵉⵍⵉⵏ ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵜⵉⵔⴱⵉⵄⵉⵏ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵙⴻⵏ. ⵉⵍⵉⵛⴰⵎⴰⵄ, ⵎⵎⵉⵙ ⵏ ⵄⴰⵎⵎⵉⵀⵓⴷ, ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵍⵃⴰⴽⴻⵎ ⵏ ⴰⵢⵜ ⵏ ⵉⴼⵔⴰⵢⵉⵎ. ");
INSERT INTO rift_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵉ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵏⴻⵙ, ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⴰⵔⴻⴱⵄⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⵅⴻⵎⵙⴰ-ⵎⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","ⵣⵣⴰⵜⴻⵙ ⴰⴷ ⵜⵉⵍⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⵎⴰⵏⴰⵙⵙⴰ. ⵊⴰⵎⵍⵉⵢⵉⵍ, ⵎⵎⵉⵙ ⵏ ⴼⴰⴷⴰⵀⵚⵓⵔ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵍⵃⴰⴽⴻⵎ ⵏ ⴰⵢⵜ ⵏ ⵎⴰⵏⴰⵙⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵉ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵏⴻⵙ, ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⵜⵏⴰⵢⴻⵏ ⵓ-ⵜⵍⴰⵜⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⵎⵉⵜⴰⵢⵏ. ");
INSERT INTO rift_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","ⵅⴻⵏⵏⵉ ⵜⴰⵇⴱⵉⵍⵜ ⵏ ⴱⵉⵏⵢⴰⵎⵉⵏ. ⴰⴱⵉⴷⴰⵏ, ⵎⵎⵉⵙ ⵏ ⵊⵉⴷⵄⵓⵏⵉ, ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵍⵃⴽⴰⵎ ⵏ ⴰⵢⵜ ⵏ ⴱⵉⵏⵢⴰⵎⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵉ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵏⴻⵙ, ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⵅⴻⵎⵙⴰ ⵓ-ⵟⵍⴰⵜⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⴰⵔⴻⴱⵄⴰ-ⵎⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵏ ⵉⴼⵔⴰⵢⵉⵎ, ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⵎⵢⴰ ⵓ-ⵜⵎⴻⵏⵢⴰ-ⴰⵍⴻⴼ ⵓ-ⵎⵢⴰ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ, ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵜⵉⵔⴱⵉⵄⵉⵏ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵙⴻⵏ. ⵏⵉⵜⵏⵉ ⴰⴷ ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⵡⵉⵙⵙ ⵜⵍⴰⵜⴰ. ");
INSERT INTO rift_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","ⵖⴰⵔ ⵛⵛⵎⴰⵍ ⴰⴷ ⵜⵉⵍⵉ ⵜⵄⴻⴵⴰⵏⵜ ⵏ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵏ ⴷⴰⵏ. ⵏⵉⵜⵏⵉ ⴰⴷ ⵉⵍⵉⵏ ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵜⵉⵔⴱⵉⵄⵉⵏ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵙⴻⵏ. ⴰⵅⵉⵄⴰⵣⴰⵔ, ⵎⵎⵉⵙ ⵏ ⵄⴰⵎⵎⵉⵛⴰⴷⴷⴰⵢ, ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵍⵃⴰⴽⴻⵎ ⵏ ⴰⵢⵜ ⵏ ⴷⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵉ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵏⴻⵙ, ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⵜⵏⴰⵢⴻⵏ ⵓ-ⵙⴻⵜⵜⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⵙⴻⴱⵄⴰ-ⵎⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","ⵣⵣⴰⵜⴻⵙ ⴰⴷ ⵜⴻⵡⵡⴻⵜ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⴰⵛⵉⵔ ⵉⵇⵉⴹⴰⵏ ⵏⵏⴻⵙ. ⴼⴰⵊⵄⵉⵢⵉⵍ, ⵎⵎⵉⵙ ⵏ ⵄⵓⴽⵔⴰⵏ, ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵍⵃⴰⴽⴻⵎ ⵏ ⴰⵢⵜ ⵏ ⴰⵛⵉⵔ. ");
INSERT INTO rift_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵉ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵏⴻⵙ, ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⵡⴰⵃⵉⵜ ⵓ-ⵔⴻⴱⵄⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⵅⴻⵎⵙⴰ-ⵎⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","ⵅⴻⵏⵏⵉ ⵜⴰⵇⴱⵉⵍⵜ ⵏ ⵏⴰⴼⵜⴰⵍⵉ. ⴰⵅⵉⵔⴰⵄ, ⵎⵎⵉⵙ ⵏ ⵄⵉⵏⴰⵏ, ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵍⵃⴰⴽⴻⵎ ⵏ ⴰⵢⵜ ⵏ ⵏⴰⴼⵜⴰⵍⵉ. ");
INSERT INTO rift_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵉ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵏⴻⵙ, ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⵜⵍⴰⵜⴰ ⵓ-ⵅⴻⵎⵙⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⴰⵔⴻⴱⵄⴰ-ⵎⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵏ ⴷⴰⵏ, ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⵎⵢⴰ ⵓ-ⵙⴻⴱⵄⴰ ⵓ-ⵅⴻⵎⵙⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⵙⴻⵜⵜⴰ-ⵎⵢⴰ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ. ⵏⵉⵜⵏⵉ ⴰⴷ ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷ ⴰⵏⴻⴳⴳⴰⵔⵓ, ⴰⵎ ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵏⵉⵜⵏⵉ ⵄⵍⴰⵃⵙⴰⴱ ⵜⵉⵄⴻⴵⴰⵏⵉⵏ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","ⵉⵏⴰ ⴷ ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⴰⵎ ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵏⵉⵜⵏⵉ ⵄⵍⴰⵃⵙⴰⴱ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵙⴻⵏ. ⵎⴰⵔⵔⴰ ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⴷⵉ ⵍⴻⵎⵔⴰⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ, ⴰⵎ ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵏⵉⵜⵏⵉ ⵄⵍⴰⵃⵙⴰⴱ ⵜⵉⵔⴱⵉⵄⵉⵏ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵙⴻⵏ, ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⵙⴻⵜⵜⴰ-ⵎⵢⴰ ⵓ-ⵜⴻⵍⵜ-ⴰⵍⴰⴼ ⵓ-ⵅⴻⵎⵙⴰ-ⵎⵢⴰ ⵓ-ⵅⴻⵎⵙⵉⵏ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⵊⴰⵔ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵡⴰⵔ ⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵛⴰ, ⵏⵉⵛⴰⵏ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵙ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","ⵓⵛⴰ ⴳⴳⵉⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴷ ⴰⵙ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⵙ ⵓⵙⴻⵜⵜⴻⴼ ⵖⴰⵔ ⵜⵄⴻⴵⴰⵏⵉⵏ ⵏⵙⴻⵏ, ⴰⵎⵎⵓ ⵉ ⵖⴰ ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⵄⴰⵡⴻⴷ, ⴽⵓⵍ ⵉⵊⵊⴻⵏ ⵉⵜⵜⵡⴰⵙⴻⵜⵜⴻⴼ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵏⴻⵙ, ⵖⴰⵔ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","ⴰⵇⴰ ⵉⵏⴰ ⴷ ⵜⴰⵔⵡⴰ ⵏ ⵀⴰⵔⵓⵏ ⴷ ⵎⵓⵙⴰ ⴷⴻⴳ ⵡⵓⵙⵙⴰⵏ ⵏⵏⵉ ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ ⵅ ⵡⴻⴷⵔⴰⵔ ⵏ ⵙⵉⵏⴰ. ");
INSERT INTO rift_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","ⴰⵇⴰ ⵉⵏⴰ ⴷ ⵉⵙⵎⴰⵡⴻⵏ ⵏ ⵡⴰⵔⵔⴰⵡ ⵏ ⵀⴰⵔⵓⵏ: ⵏⴰⴷⴰⴱ ⴷ ⴰⵎⴻⵏⵣⵓ, ⵅⴻⵏⵏⵉ ⴰⴱⵉⵀⵓ, ⴰⵍⵉⵄⴰⵣⴰⵔ ⴷ ⵉⵜⴰⵎⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","ⴰⵇⴰ ⵉⵏⴰ ⴷ ⵉⵙⵎⴰⵡⴻⵏ ⵏ ⵡⴰⵔⵔⴰⵡ ⵏ ⵀⴰⵔⵓⵏ, ⵉⴽⴻⵀⵀⴰⵏⴻⵏ ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⴷⴻⵀⵏⴻⵏ ⵓ ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵍⴻⵇⵇⵎⴻⵏ ⴰⵎ ⵢⵉⴽⴻⵀⵀⴰⵏⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","ⵎⴰⵛⴰ ⵏⴰⴷⴰⴱ ⴷ ⴰⴱⵉⵀⵓ ⵎⵎⵓⵜⴻⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ, ⵓⵎⵉ ⵇⴻⴷⴷⵎⴻⵏ ⵜⵉⵎⴻⵙⵙⵉ ⵜⴰⵍⵖⵉⴱⵜ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⴷⵉ ⵍⴻⵅⵍⴰ ⵏ ⵙⵉⵏⴰ. ⵡⴰⵔ ⵜⵓⵖⵉ ⵖⴰⵔⵙⴻⵏ ⴰⵔⵔⴰⵡ. ⵙ ⵓⵢⴰ ⵜⵓⵖⴰ ⴰⵍⵉⵄⴰⵣⴰⵔ ⴷ ⵉⵜⴰⵎⴰⵔ ⵙⴻⵅⵅⴰⵔⴻⵏ ⴰⵎ ⵓⴽⴻⵀⵀⴰⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⴱⴰⴱⴰⵜⵙⴻⵏ ⵀⴰⵔⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“ⵙⵇⴰⵔⵔⴻⴱ-ⴷⴷ ⵜⴰⵇⴱⵉⵍⵜ ⵏ ⵍⴰⵡⵉ ⵓⵛⴰ ⴻⴳⴳ ⵉ-ⵜⴻⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵓⴽⴻⵀⵀⴰⵏ ⵀⴰⵔⵓⵏ, ⵃⵉⵎⴰ ⴰⴷ ⵅⴰⵙ ⵙⴻⵅⵅⴰⵔⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","ⴻⵊⵊ ⵉ-ⵜⴻⵏ ⴰⴷ ⵍⵀⴰⵏ ⵜⴰⵙⴻⵅⵅⴰⵔⵜ ⵏⵏⴻⵙ ⴷ ⵜⵙⴻⵅⵅⴰⵔⵜ ⵏ ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⵣⵣⴰⵜ ⵉ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴽⴻⵎⵎⵍⴻⵏ ⵍⵅⴻⴷⵎⴻⵜ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ. ");
INSERT INTO rift_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","ⴰⴷ ⵃⴹⴰⵏ ⵅ ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⵓⵛⴰ ⴰⴷ ⵟⵟⴼⴻⵏ ⴰⵃⴻⵟⵟⵓ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵙⴻⵅⵅⴰⵔⴻⵏ ⴷⵉ ⵜⵙⴻⵅⵅⴰⵔⵜ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ. ");
INSERT INTO rift_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","ⵛⴻⴽ ⴰⴷ ⵜⴻⵡⵛⴻⴷ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⵉ ⵀⴰⵔⵓⵏ ⵓ ⵉ ⵡⴰⵔⵔⴰⵡⴻⵏ ⵏⵏⴻⵙ. ⴰⵇⴰ ⴷ ⵢⵉⵏⴰ ⵉ ⴷ ⴰⵙ ⵉⵎⵎⴻⵡⵛⴻⵏ ⵉ ⵏⴻⵜⵜⴰ ⵡⴰⵀⴰ ⵣⴻⴳ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","ⴰⴷ ⵜⵍⴻⵇⵇⵎⴻⴷ ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵃⴹⴰⵏ ⵅ ⵜⵓⴽⴻⵀⵀⴰⵏⵜ. ⴰⴱⴰⵔⵔⴰⵏⵉ ⵏⵏⵉ ⵉ ⴷⴷ ⵖⴰ ⵉⵇⴰⵔⵔⴱⴻⵏ ⴰⴷ ⵉⵜⵜⵡⴰⵏⴻⵖ.” ");
INSERT INTO rift_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“ⵅⵣⴰⵔ, ⵏⴻⵛⵛ ⴽⵙⵉⵖ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⵣⵉ ⵍⵡⴻⵙⵟ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏ ⵉⵎⴻⵏⵣⴰ, ⵎⴰⵔⵔⴰ ⵉⵏⵏⵉ ⵢⴰⵔⴻⵣⵎⴻⵏ ⵍⴻⵎⵍⴰⵡⴻⵜ ⴷ ⴰⵎⴻⵣⵡⴰⵔⵓ ⵊⴰⵔ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⴰⴷ ⵉⵍⵉⵏ ⵉⵏⵓ, ");
INSERT INTO rift_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","ⵎⵉⵏⵣⵉ ⴽⵓⵍ ⴰⵎⴻⵏⵣⵓ ⴰⵇⴰ ⵉⵏⵓ. ⴷⴻⴳ ⵡⴰⵙⵙ ⵎⵉⵏ ⴷⵉ ⵡⵜⵉⵖ ⵎⴰⵔⵔⴰ ⵉⵎⴻⵏⵣⴰ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ, ⴰⵇⴰ ⵙⵙⵇⴻⴷⴷⵙⴻⵖ ⵉ ⵢⵉⵅⴻⴼ ⵉⵏⵓ ⵎⴰⵔⵔⴰ ⵉⵎⴻⵏⵣⴰ ⴷⵉ ⵉⵙⵔⴰⵉⵍ, ⵣⵉ ⴱⵏⴰⴷⴻⵎ ⴰⵍ ⵍⵎⴰⵍ. ⵏⵉⵜⵏⵉ ⴰⴷ ⵉⵍⵉⵏ ⵉⵏⵓ, ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ!” ");
INSERT INTO rift_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ ⴷⵉ ⵍⴻⵅⵍⴰ ⵏ ⵙⵉⵏⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“ⵃⵙⴻⴱ ⴰⵢⵜ ⵏ ⵍⴰⵡⵉ, ⴰⵎ ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵏⵉⵜⵏⵉ ⵄⵍⴰⵃⵙⴰⴱ ⵜⵓⴷⵔⵉⵏ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵙⴻⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ. ⵎⴰⵔⵔⴰ ⵉⵡⴻⵜⵎⴰⵏ ⵏⵏⵉ ⵉⴵⴰⵏ ⴷ ⵉⵊⵊ ⵏ ⵓⵢⵓⵔ ⵙⴻⵏⵏⴻⵊ, ⴰⴷ ⵜⴻⵏ ⵜⴻⵃⵙⴻⴱ.” ");
INSERT INTO rift_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","ⵓⵛⴰ ⵎⵓⵙⴰ ⵉⵃⵙⴻⴱ ⵉ-ⵜⴻⵏ ⵅ ⵍⵓⵎⵓⵔ ⵏ ⵙⵉⴷⵉ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵙ ⵉⵡⴻⵚⵚⴰ. ");
INSERT INTO rift_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","ⵜⵓⵖⴰ ⵉⵏⴰ ⴷ ⴰⵢⵜ ⵏ ⵍⴰⵡⵉ ⴰⴽ-ⴷ ⵉⵙⵎⴰⵡⴻⵏ ⵏⵙⴻⵏ: ⵊⴰⵔⵛⵓⵏ, ⴷ ⵇⴰⵀⴰⵜ ⴷ ⵎⴰⵔⴰⵔⵉ. ");
INSERT INTO rift_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","ⵜⵓⵖⴰ ⵉⵏⴰ ⴷ ⵉⵙⵎⴰⵡⴻⵏ ⵏ ⴰⵢⵜ ⵏ ⵊⴰⵔⵛⵓⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ: ⵍⵉⴱⵏⵉ ⴷ ⵛⵉⵎⵄⵉ. ");
INSERT INTO rift_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","ⴰⵢⵜ ⵏ ⵇⴰⵀⴰⵜ, ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ: ⵄⴰⵎⵔⴰⵎ ⴷ ⵢⵉⵚⵀⴰⵔ ⴷ ⵃⴰⴱⵔⵓⵏ ⴷ ⵄⵓⵣⵣⵉⵢⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","ⴰⵢⵜ ⵏ ⵎⴰⵔⴰⵔⵉ, ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ: ⵎⴰⵃⵍⵉ ⴷ ⵎⵓⵛⵉ. ⵜⵓⵖⴰ ⵉⵏⴰ ⴷ ⵍⴰⴵⴰⵜ ⵏ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ, ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵜⵓⴷⵔⵉⵏ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","ⵖⴰⵔ ⵊⴰⵔⵛⵓⵏ ⵜⵓⵖⴰ ⵜⴻⴵⴰ ⵍⴰⴵ ⵏ ⵉⵍⵉⴱⵏⵉⵢⵢⴻⵏ ⴷ ⵍⴰⴵ ⵏ ⵉⵛⵉⵎⵄⵉⵢⵢⴻⵏ. ⵜⵓⵖⴰ ⵜⵉⵏⴰ ⴷ ⵍⴰⴵⴰⵜ ⵏ ⵉⵊⴰⵔⵛⵓⵏⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","ⵍⵇⴻⴷⴷ ⵏ ⵢⵉⵏⵏⵉ ⵣⵣⴰⵢⵙⴻⵏ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ, ⵏ ⵎⴰⵔⵔⴰ ⵉⵡⴻⵜⵎⴰⵏ ⵣⴻⴳ ⵉⵊⵊ ⵏ ⵓⵢⵓⵔ ⵙⴻⵏⵏⴻⵊ, ⴰⵇⴰ ⵍⵇⴻⴷⴷ ⵏⵏⵉ ⵏ ⵢⵉⵏⵏⵉ ⵣⵣⴰⵢⵙⴻⵏ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵜⵓⵖⴰ ⴷⵉ ⵙⴻⴱⵄⴰ-ⴰⵍⴰⴼ ⵓ-ⵅⴻⵎⵙⴰ-ⵎⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","ⵡⵜⵉⵏⵜ ⵍⴰⴵⴰⵜ ⵏ ⵉⵊⴰⵔⵛⵓⵏⵉⵢⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⵖⴰⵔ ⴹⴻⴼⴼⴰⵔ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ, ⵖⴰⵔ ⵍⵖⴰⵔⴱ. ");
INSERT INTO rift_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","ⵜⵓⵖⴰ ⵉⵍⵢⴰⵙⴰⴼ, ⵎⵎⵉⵙ ⵏ ⵍⴰⵢⵉⵍ, ⴷ ⵍⵃⴰⴽⴻⵎ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⴱⴰⴱⴰⵜⵙⴻⵏ ⵏ ⵉⵊⴰⵔⵛⵓⵏⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","ⵣⵉ ⵊⵊⵉⵀⴻⵜ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⵃⴹⴰⵏ ⴰⵢⵜ ⵏ ⵊⴰⵔⵛⵓⵏ ⵅ ⵜⵣⴻⴷⴷⵉⵖⵜ, ⵅ ⵓⵇⵉⴹⵓⵏ ⴰⴽ-ⴷ ⵜⵙⴻⵇⵇⴰⴼⵉⵏ ⵏⵏⴻⵙ, ⵅ ⵡⴰⵔⵡⴰⵇ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ");
INSERT INTO rift_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","ⵅ ⵍⵉⵣⴰⵔⴰⵜ ⵏ ⵍⴻⵎⵔⴰⵃ ⴷ ⵡⴰⵔⵡⴰⵇ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵍⴻⵎⵔⴰⵃ ⵉ ⵣⵉ ⵜᵉⵜⵜⵡⴰⵏⵏⴻⴹ ⵜⵣⴻⴷⴷⵉⵖⵜ ⴷ ⵓⵄⴰⵍⵟⴰⵔ, ⵓ ⵅ ⵉⴼⵉⵍⴰⵏ ⵏⵏⴻⵙ, ⵓⵍⴰ ⵅ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴷⴷ-ⵉⵜⵜⴰⵙⴻⵏ ⴰⴽ-ⴷ ⵜⵙⴻⵅⵅⴰⵔⵜ ⵏⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","ⵣⵉ ⵇⴰⵀⴰⵜ ⵜⵓⵖⴰ ⵉⵇⵇⴰⵔⵚ-ⴷⴷ ⵍⴰⴵ ⵏ ⵉⵄⴰⵎⵔⴰⵎⵉⵢⵢⴻⵏ ⴷ ⵍⴰⴵ ⵏ ⵉⵚⵀⴰⵔⵉⵢⵢⴻⵏ ⴷ ⵍⴰⴵ ⵏ ⵉⵃⵉⴱⵔⵓⵏⵉⵢⵢⴻⵏ ⴷ ⵍⴰⴵ ⵏ ⵉⵄⴰⵣⵉⵢⵉⵍⵉⵢⵢⴻⵏ. ⵜⵓⵖⴰ ⵜⵉⵏⴰ ⴷ ⵍⴰⴵⴰⵜ ⵏ ⵉⵇⴰⵀⴰⵜⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","ⵜⵓⵖⴰ ⵍⵇⴻⴷⴷ ⵏ ⵎⴰⵔⵔⴰ ⵉⵡⴻⵜⵎⴰⵏ ⵣⴻⴳ ⵉⵊⵊ ⵏ ⵓⵢⵓⵔ ⵙⴻⵏⵏⴻⵊ ⵜⴻⵎⵏ-ⴰⵍⴰⴼ ⵓ-ⵙⴻⵜⵜⴰ-ⵎⵢⴰ. ⵏⵉⵜⵏⵉ ⵃⴹⴰⵏ ⵅ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","ⵡⵜⵉⵏⵜ ⵍⴰⴵⴰⵜ ⵏ ⴰⵢⵜ ⵏ ⵇⴰⵀⴰⵜ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⵖⴰⵔ ⵓⵖⴻⵣⴷⵉⵙ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ, ⵖⴰⵔ ⵍⵊⴰⵏⵓⴱ. ");
INSERT INTO rift_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","ⵉⵍⵉⵚⴰⴼⴰⵏ, ⵎⵎⵉⵙ ⵏ ⵄⵓⵣⵣⵉⵢⵉⵍ, ⵜⵓⵖⴰ ⴷ ⵍⵃⴰⴽⴻⵎ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⴱⴰⴱⴰⵜⵙⴻⵏ ⵏ ⵍⴰⴵⴰⵜ ⵏ ⵉⵇⵓⵀⴰⵜⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","ⵏⵉⵜⵏⵉ ⵜⵓⵖⴰ ⵃⴻⵟⵟⴰⵏ ⵅ ⵜⵜⴰⴱⵓⵜ ⴷ ⵜⵣⴻⵡⴹⴰ ⴷ ⵍⵇⴻⵏⴷⵉⵍ ⴷ ⵉⵄⴰⵍⵟⴰⵔⴻⵏ ⵓ ⵅ ⵍⴻⵇⵛⵓⵄ ⵏ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵉ ⵙⵙⵅⴻⴷⵎⴻⵏ ⵓ ⵅ ⵓⵍⴻⵃⵃⴰⴼ, ⵡⴰⵀ, ⵅ ⵎⴰⵔⵔⴰ ⵉ ⴷⴷ-ⵉⵜⵜⴰⵙⴻⵏ ⴰⴽ-ⴷ ⵜⵙⴻⵅⵅⴰⵔⵜ ⵏⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","ⵜⵓⵖⴰ ⴰⵍⵉⵄⴰⵣⴰⵔ, ⵎⵎⵉⵙ ⵏ ⵓⴽⴻⵀⵀⴰⵏ ⵀⴰⵔⵓⵏ, ⴷ ⵍⵃⴰⴽⴻⵎ ⴰⵎⴻⵣⵡⴰⵔⵓ ⵇⴰⵄ ⵅ ⵎⴰⵔⵔⴰ ⵍⵃⵓⴽⴽⴰⵎ ⵏ ⵍⴰⵡⵉ. ⵏⴻⵜⵜⴰ ⵉⵟⵟⴻⴼ ⴰⵛⴱⴰⵔ ⵅ ⵢⵉⵏⵏⵉ ⵜⵓⵖⴰ ⵉⵃⴻⵟⵟⴰⵏ ⵅ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","ⵣⵉ ⵎⴰⵔⴰⵔⵉ ⵜⵓⵖⴰ ⵉⵇⵇⴰⵔⵚ ⵍⴰⴵ ⵏ ⵉⵎⴰⵃⵍⵉⵢⵢⴻⵏ ⴷ ⵍⴰⴵ ⵏ ⵉⵎⵓⵛⵉⵢⵢⴻⵏ. ⵜⵓⵖⴰ ⵜⵉⵏⴰ ⴷ ⵍⴰⴵⴰⵜ ⵏ ⵎⴰⵔⴰⵔⵉ. ");
INSERT INTO rift_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","ⵜⵓⵖⴰ ⵍⵇⴻⴷⴷ ⵏ ⵢⵉⵏⵏⵉ ⵣⵣⴰⵢⵙⴻⵏ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ, ⵏ ⵎⴰⵔⵔⴰ ⵉⵡⴻⵜⵎⴰⵏ ⵣⴻⴳ ⵉⵊⵊ ⵏ ⵓⵢⵓⵔ ⵙⴻⵏⵏⴻⵊ, ⴷⵉ ⵙⴻⵜⵜⴰ-ⴰⵍⴰⴼ ⵓ-ⵎⵉⵜⴰⵢⵏ. ");
INSERT INTO rift_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","ⵜⵓⵖⴰ ⵙⵓⵔⵉⵢⵉⵍ, ⵎⵎⵉⵙ ⵏ ⴰⴱⵉⵅⴰⵢⵉⵍ, ⴷ ⵍⵃⴰⴽⴻⵎ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⴱⴰⴱⴰⵜⵙⴻⵏ ⵏ ⵍⴰⴵⴰⵜ ⵏ ⵎⴰⵔⴰⵔⵉ. ⵏⵉⵜⵏⵉ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⵖⴰⵔ ⵓⵖⴻⵣⴷⵉⵙ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ, ⵖⴰⵔ ⵛⵛⴰⵎⴰⵍ. ");
INSERT INTO rift_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","ⴰⵢⵜ ⵏ ⵎⴰⵔⴰⵔⵉ ⵜⵓⵖⴰ ⵜᵉⵟⵟⴼⴻⵏ ⴰⵛⴱⴰⵔ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵡⵛⴻⵏ ⵜⴰⵢⵏⵉⵜ ⵉ ⵎⴰⵔⵔⴰ ⵜⵉⴼⴻⵍⵡⵉⵏ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ, ⵉ ⵜⵃⴻⵏⵢⴰ ⵏ ⵓⵄⴰⵔⵔⴻⴹ, ⵉ ⵉⴱⵉⵍⴰⵔⴻⵏ ⵏⵏⴻⵙ, ⵉ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵏⵏⴻⵙ ⵓ ⵉ ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ ⵏⵏⴻⵙ, ⵡⴰⵀ. ⵉ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴷⴷ-ⵉⵜⵜⴰⵙⴻⵏ ⴰⴽ-ⴷ ⵜⵙⴻⵅⵅⴰⵔⵜ ⵏⵏⵉ, ");
INSERT INTO rift_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","ⵓⵍⴰ ⵉ ⵉⴱⵉⵍⴰⵔⴻⵏ ⵏⵏⵉ ⴷⴷ-ⵉⵏⵏⴹⴻⵏ ⵉ ⵍⴻⵎⵔⴰⵃ ⴰⴽ-ⴷ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵏⵙⴻⵏ ⴷ ⵍⴻⵡⵜⴰⴷ ⵏⵙⴻⵏ ⴷ ⵉⴼⵉⵍⴰⵏ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ ⴰⴽ-ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ, ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ⵖⴰⵔ ⵛⵛⴰⵔⵇ ⵎⴰⵏⵉⵙ ⴷⴷ-ⵜⵏⴻⵇⵇⴰⵔ ⵜⴼⵓⵛⵜ. ⵏⵉⵜⵏⵉ ⵃⴹⴰⵏ ⵅ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ⴰⴱⴰⵔⵔⴰⵏⵉ ⵏⵏⵉ ⴷⴷ-ⵉⵇⴰⵔⵔⴱⴻⵏ, ⵜⵓⵖⴰ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵉⵜⵜⵡⴰⵏⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","ⵎⴰⵔⵔⴰ ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵏ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ, ⵉⵏⵏⵉ ⵉⵃⵙⴻⴱ ⵎⵓⵙⴰ ⴰⴽ-ⴷ ⵀⴰⵔⵓⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵍⵓⵎⵓⵔ ⵏ ⵙⵉⴷⵉ, ⴰⵎ ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵏⵉⵜⵏⵉ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ, ⵎⴰⵔⵔⴰ ⵉⵡⴻⵜⵎⴰⵏ ⵣⴻⴳ ⵉⵊⵊ ⵏ ⵓⵢⵓⵔ ⵙⴻⵏⵏⴻⵊ, ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⵜⵏⴰⵢⴻⵏ ⵓ-ⵄⵉⵛⵔⵉⵏ-ⴰⵍⴻⴼ. ");
INSERT INTO rift_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⵃⵙⴻⴱ ⵎⴰⵔⵔⴰ ⵉⵎⴻⵏⵣⴰ ⵏ ⵉⵡⴻⵜⵎⴰⵏ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵣⴻⴳ ⵉⵊⵊ ⵏ ⵓⵢⵓⵔ ⵙⴻⵏⵏⴻⵊ, ⵓⵛⴰ ⴽⵙⵉ ⵍⵇⴻⴷⴷ ⵏ ⵉⵙⵎⴰⵡⴻⵏ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","ⴰⴷ ⵜⴻⴽⵙⵉⴷ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⵉ ⵏⴻⵛⵛ - ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ! - ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏ ⵎⴰⵔⵔⴰ ⵉⵎⴻⵏⵣⴰ ⵊⴰⵔ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵍⴰ ⴷ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏ ⵎⴰⵔⵔⴰ ⵉⵎⴻⵏⵣⴰ ⵊⴰⵔ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ.” ");
INSERT INTO rift_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","ⵓⵛⴰ ⵉⵃⵙⴻⴱ ⵎⵓⵙⴰ ⵎⴰⵔⵔⴰ ⵉⵎⴻⵏⵣⴰ ⵊⴰⵔ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵙ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","ⵍⵇⴻⴷⴷ ⵏ ⵉⵙⵎⴰⵡⴻⵏ ⵏ ⵎⴰⵔⵔⴰ ⵉⵎⴻⵏⵣⴰ ⵉⵡⴻⵜⵎⴰⵏ ⵏ ⵉⵊⵊ ⵏ ⵓⵢⵓⵔ ⵙⴻⵏⵏⴻⵊ, ⵏ ⵢⵉⵏⵏⵉ ⵣⵣⴰⵢⵙⴻⵏ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ, ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⵜⵏⴰⵢⴻⵏ ⵓ-ⵄⵉⵛⵔⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⵎⵉⵜⴰⵢⵏ ⵓ-ⵜⵍⴰⵜⴰ ⵓ-ⵙⴻⴱⵄⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“ⴽⵙⵉ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏ ⵎⴰⵔⵔⴰ ⵉⵎⴻⵏⵣⴰ ⵊⴰⵔ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵍⴰ ⴷ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏⵙⴻⵏ, ⵎⵉⵏⵣⵉ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⴰⴷ ⵉⵍⵉⵏ ⵉⵏⵓ. ⴰⵇⴰ ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","ⵣⵉ ⵊⵊⵉⵀⴻⵜ ⵏ ⵎⵉⵜⴰⵢⴻⵏ ⵓ-ⵜⵍⴰⵜⴰ ⵓ-ⵙⴻⴱⵄⵉⵏ, ⵉⵏⵏⵉ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜⵜⵡⴰⴼⴷⵉⵏ, ⵎⴰⵖⴰⵔ ⵏⵉⵜⵏⵉ ⵇⵇⵉⵎⴻⵏ ⵙⴻⵏⵏⴻⵊ ⵉ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⵏ ⵉⵎⴻⵏⵣⴰ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ");
INSERT INTO rift_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜⴻⴽⵙⵉⴷ ⵅⴻⵎⵙⴰ ⵛⵉⵇⵍⵓ ⵉ ⴽⵓⵍ ⵉⵊⵊ ⵏ ⵓⵣⴻⴵⵉⴼ. ⴰⴷ ⵜ ⵜⴻⴽⵙⵉⴷ ⴰⵏⴻⵛⵜ ⵏ ⵛⵉⵇⵍⵓ ⵏ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ. ⵛⵉⵇⵍⵓ ⵡⴰⵏⵉⵜⴰ ⴰⵇⴰ ⴷⴰⵢⴻⵙ ⵄⵉⵛⵔⵉⵏ ⵊⵉⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","ⴰⴷ ⵜⴻⵡⵛⴻⴷ ⵏⵏⵓⵇⴰⵔⵜ ⵏⵏⵉ ⵉ ⵀⴰⵔⵓⵏ ⵓ ⵉ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ, ⴰⵇⴰ-ⵜⵜ ⵉ ⵜⵜⴰⵎⴰⵏ ⵏ ⵓⴼⴻⴽⴽⵉ ⵏ ⵢⵉⵏⵏⵉ ⵉⵇⵇⵉⵎⴻⵏ ⵙⴻⵏⵏⴻⵊ ⵉ ⵍⵇⴻⴷⴷ ⵏ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","ⵅⴻⵏⵏⵉ ⵉⴽⵙⵉ ⵎⵓⵙⴰ ⵏⵏⵓⵇⴰⵔⵜ ⵏ ⵜⵜⴰⵎⴰⵏ ⵏ ⵓⴼⴻⴽⴽⵉ ⵏ ⵢⵉⵏⵏⵉ ⵉⵇⵇⵉⵎⴻⵏ ⵙⴻⵏⵏⴻⵊ ⵏ ⵢⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⴼⴷⵉⵏ ⵙ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","ⵓⵛⴰ ⵉⵟⵟⴻⴼ ⵏⵏⵓⵇⴰⵔⵜ ⵏⵏⵉ ⵣⴻⴳ ⵉⵎⴻⵏⵣⴰ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ: ⴰⵍⴻⴼ ⵓ-ⵜⴻⵍⵜ-ⵎⵢⴰ ⵓ-ⵅⴻⵎⵙⴰ ⵓ-ⵙⴻⵜⵜⵉⵏ ⵛⵉⵇⵍⵓ, ⵄⵍⴰⵃⵙⴰⴱ ⵛⵉⵇⵍⵓ ⵏ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","ⵓ ⵎⵓⵙⴰ ⵉⵡⵛⴰ ⵏⵏⵓⵇⴰⵔⵜ ⵏ ⵢⵉⵏⵏⵉ ⵉⵡⵛⵉⵏ ⵜⵜⴰⵎⴰⵏ ⵏ ⵓⴼⴻⴽⴽⵉ ⵉ ⵀⴰⵔⵓⵏ ⵓ ⵉ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ, ⵄⵍⴰⵃⵙⴰⴱ ⴰⵡⴰⵍ ⵏ ⵓⵇⴻⵎⵎⵓⵎ ⵏ ⵙⵉⴷⵉ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵙ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“ⵃⵙⴻⴱ ⴰⵢⵜ ⵏ ⵇⴰⵀⴰⵜ ⴰⵣⴻⴵⵉⴼ ⴰⵣⴻⴵⵉⴼ ⵊⴰⵔ ⴰⵢⵜ ⵏ ⵍⴰⵡⵉ, ⴰⵎ ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵏⵉⵜⵏⵉ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵜⵓⴷⵔⵉⵏ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵙⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","ⵣⵉ ⵜⵍⴰⵜⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵙⴻⵏⵏⴻⵊ ⴰⵍ ⵅⴻⵎⵙⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵎⴰⵔⵔⴰ ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵢⴰⴷⴼⴻⵏ ⵖⴰⵔ ⵍⵄⴻⵙⴽⴰⵔ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵢⴻⴳⴳ ⵍⵅⴻⴷⵎⴻⵜ ⴷⴻⴳ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","ⴷ ⵜⴰ ⵉ ⵖⴰ ⵢⵉⵍⵉⵏ ⴷ ⵜⴰⵙⴻⵅⵅⴰⵔⵜ ⵏ ⴰⵢⵜ ⵏ ⵇⴰⵀⴰⵜ ⴷⴻⴳ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ: ⴰⵃⴻⵟⵟⵓ ⵅ ⵡⴻⵇⴷⴰⵙ ⵅ ⵓⵇⴻⴷⴷⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","ⵅⵎⵉ ⴷⴷ ⵖⴰ ⴼⴻⵙⵢⴻⵏ ⵍⵎⴰⵔⴳⴻⵃ, ⴰⴷ ⴷⴷ-ⵢⴰⵙ ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⴽⴽⵙⴻⵏ ⴰⵍⴻⵃⵃⴰⴼ ⵉ ⵉⴵⴰⵏ ⵉ ⴷⴷⵓⵔⵉ ⵓⵛⴰ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵙⵙⴷⵓⵔⵢⴻⵏ ⵜⵜⴰⴱⵓⵜ ⵏ ⵛⵛⵀⴰⴷⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵅⴰⵙ ⴳⴳⴻⵏ ⵉⵊⵊ ⵏ ⴷⴷⵓⵔⵉ ⵏ ⵉⵍⵎⴰⵡⴻⵏ ⵏ ⴷⴷⴻⵏⴼⵉⵍⴰⵜ ⵓⵛⴰ ⴰⴷ ⵅⴰⵙ ⴱⴻⵣⵣⵄⴻⵏ ⵉⵊⵊ ⵏ ⴷⴷⵓⵔⵉ ⵎⴰⵔⵔⴰ ⴷ ⴰⴷⴻⵃⵎⵉ ⵓⵛⴰ ⴰⴷ ⴰⵙ ⴳⴳⴻⵏ ⵉⵄⵓⵎⴰⴷ ⵏⵏⴻⵙ ⵉ ⵜⴰⵔⴻⴱⴱⵓⵜ. ");
INSERT INTO rift_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","ⴰⴷ ⴱⴻⵣⵣⵄⴻⵏ ⵉⵛⵜ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵟ ⵜⴰⴷⴻⵃⵎⵉⵜ ⵅ ⵜⵣⴻⵡⴹⴰ ⵉ ⵡⴻⵖⵔⵓⵎ ⵏ ⵡⴻⵙⵛⴰⵏ ⵓⵛⴰ ⴰⴷ ⵅⴰⵙ ⴳⴳⴻⵏ ⵟⵟⴱⴰⵚⵉ, ⵜⵉⵖⴻⵏⵊⴰⵢⵉⵏ ⴷ ⵍⴽⵉⵙⴰⵏ ⴷ ⵉⵖⴰⵔⵔⴰⴼⴻⵏ ⵙ ⵉⵏⵏⵉ ⵉ ⵖⴰ ⴽⴻⴱⴱⴻⵏ. ⵓⵛⴰ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵅⴰⵙ ⵢⵉⵍⵉ ⵡⴻⵖⵔⵓⵎ ⵏ ⵍⴻⴱⴷⴰ. ");
INSERT INTO rift_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","ⴰⵡⴰⵔⵏⵉ ⵓⵢⴰ ⴰⴷ ⵅⴰⵙ ⴱⴻⵣⵣⵄⴻⵏ ⵉⵊⵊ ⵏ ⴷⴷⵓⵔⵉ ⴰⵣⴻⴳⴳⵯⴰⵖ ⵉⵃⴻⴷⵇⴻⵏ ⵓⵛⴰ ⴰⴷ ⵜⵜ ⴷⵍⴻⵏ ⵄⴰⵡⴻⴷ ⵙ ⵉⵊⵊ ⵏ ⴷⴷⵓⵔⵉ ⵏ ⵉⵍⵎⴰⵡⴻⵏ ⵏ ⴷⴷⴻⵏⴼⵉⵍⴰⵜ ⵓⵛⴰ ⴰⴷ ⴰⵙ ⴳⴳⴻⵏ ⵉⵄⵓⵎⴰⴷ ⵏⵏⴻⵙ ⵉ ⵜⴰⵔⴻⴱⴱⵓⵜ. ");
INSERT INTO rift_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","ⵅⴻⵏⵏⵉ ⴰⴷ ⴽⵙⵉⵏ ⵉⵛⵜ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵜ ⵜⴰⴷⴻⵃⵎⴰⵏⵉⵜ ⵓⵛⴰ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⴷⵍⴻⵏ ⵍⵇⴻⵏⴷⵉⵍ ⵉ ⵜⴼⴰⵡⵜ ⵓⵍⴰ ⴷ ⵍⴻⴼⵏⴰⵔⴰⵜ ⵏⵏⴻⵙ ⴷ ⵜⵊⴻⵇⵇⴰⴹⵉⵏ ⵏ ⵜⴻⴼⵜⵉⵍⵜ ⵏⵏⴻⵙ ⴷ ⵜⵎⴻⵊⵎⴰⵔⵉⵏ ⵏⵏⴻⵙ ⴷ ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ ⵏⵏⴻⵙ ⵉ ⵣⵣⴻⵛⵜ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏ ⵜⵙⴻⵅⵅⴰⵔⵜ ⵉ ⵍⵇⴻⵏⴷⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","ⴰⴷ ⴳⴳⴻⵏ ⵍⵇⴻⵏⴷⵉⵍ-ⴰ ⴷ ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ ⵏⵏⴻⵙ ⴷⴻⴳ ⵉⵊⵊ ⵏ ⴷⴷⵓⵔⵉ ⵏ ⵉⵍⵎⴰⵡⴻⵏ ⵏ ⴷⴷⴻⵏⴼⵉⵍⴰⵜ ⵓⵛⴰ ⴰⴷ ⵜ ⵙⵙⴰⵔⵙⴻⵏ ⵅ ⴵⵓⵃ ⵏ ⵜⴽⴻⵙⵙⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","ⴰⴷ ⴱⴻⵣⵣⵄⴻⵏ ⵉⵊⵊ ⵏ ⴷⴷⵓⵔⵉ ⴰⴷⴻⵃⵎⴰⵏⵉ ⵅ ⵓⵄⴰⵍⵟⴰⵔ ⵏ ⵍⴻⴱⵅⵓⵔ ⵓⵛⴰ ⴰⴷ ⵜ ⴷⵍⴻⵏ ⵄⴰⵡⴻⴷ ⵙ ⵢⵉⵊⵊ ⵏ ⴷⴷⵓⵔⵉ ⵏ ⵉⵍⵎⴰⵡⴻⵏ ⵏ ⴷⴷⴻⵏⴼⵉⵍⴰⵜ ⵓⵛⴰ ⴰⴷ ⴰⵙ ⴳⴳⴻⵏ ⵉⵄⵓⵎⴰⴷ ⵏⵏⴻⵙ ⵉ ⵜⴰⵔⴻⴱⴱⵓⵜ. ");
INSERT INTO rift_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","ⵓⵛⴰ ⴰⴷ ⴽⵙⵉⵏ ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ ⵉ ⵜⵙⴻⵅⵅⴰⵔⵜ ⵉ ⵙⵙⵅⴻⴷⴷⵎⴻⵏ ⴷⵉ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵓⵛⴰ ⴰⴷ ⵜⴻⵏ ⴳⴳⴻⵏ ⴷⴻⴳ ⵉⵊⵊ ⵏ ⴷⴷⵓⵔⵉ ⴰⴷⴻⵃⵎⴰⵏⵉ ⵓⵛⴰ ⴰⴷ ⵜ ⴷⵍⴻⵏ ⵙ ⵢⵉⵊⵊ ⵏ ⴷⴷⵓⵔⵉ ⵏ ⵉⵍⵎⴰⵡⴻⵏ ⵏ ⴷⴷⴻⵏⴼⵉⵍⴰⵜ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵙⵙⴰⵔⵙⴻⵏ ⴰⵢⴰ ⵅ ⴵⵓⵃ ⵏ ⵜⴽⴻⵙⵙⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","ⴰⴷ ⴽⴽⵙⴻⵏ ⵎⵉⵏ ⵉⵇⵇⵉⵎⴻⵏ ⵏ ⵜⴰⴷⵓⵏⵜ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ⵓⵛⴰ ⴰⴷ ⵅⴰⵙ ⴱⴻⵣⵣⵄⴻⵏ ⵉⵛⵜ ⵏ ⵜⵊⴰⵔⵜⵉⵍⵜ ⵜⴰⵔⵊⵓⵡⴰⵏⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","ⴰⴷ ⵅⴰⵙ ⵙⵙⴰⵔⵙⴻⵏ ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ ⵉ ⵙⵙⵅⴻⴷⵎⴻⵏ ⵉ ⵜⵙⴻⵅⵅⴰⵔⵜ: ⵜⵉⵎⴻⵊⵎⴰⵔⵉⵏ, ⴼⵓⵔⵛⴰⵢⴰⵜ, ⵉⵖⴻⵏⵊⴰⵢⴻⵏ, ⵟⵟⴰⵡⵢⴰⵜ ⵉ ⵓⵔⵓⵛⵛⵉ ⴷ ⵎⴰⵔⵔⴰ ⴷⴷⵓⵣⴰⵏ ⵏ ⵓⵄⴰⵍⵟⴰⵔ. ⵜⵉⵡⵡⴰ ⵏⵏⴻⵙ ⴰⴷ ⴱⴻⵣⵣⵄⴻⵏ ⵉⵊⵊ ⵏ ⴷⴷⵓⵔⵉ ⵏ ⵉⵍⵎⴰⵡⴻⵏ ⵏ ⴷⴷⴻⵏⴼⵉⵍⴰⵜ ⵓⵛⴰ ⴰⴷ ⴰⵙ ⴳⴳⴻⵏ ⵉⵄⵓⵎⴰⴷ ⵏⵏⴻⵙ ⵉ ⵜⴰⵔⴻⴱⴱⵓⵜ. ");
INSERT INTO rift_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","ⵅⵎⵉ ⵖⴰ ⵉⴽⴻⵎⵎⴻⵍ ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⴷⴷⵓⵔⵉ ⵏ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ ⴷ ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ ⵏ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵅⵎⵉ ⵖⴰ ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ, ⵅⴻⵏⵏⵉ ⴰⴷ ⴷⴷ-ⴰⵙⴻⵏ ⵡⴰⵔⵔⴰⵡ ⵏ ⵇⵓⵀⴰⵜ ⵃⵉⵎⴰ ⴰⴷ ⴰⵔⴱⵓⵏ ⵎⴰⵔⵔⴰ, ⵎⴰⵛⴰ ⵉⵜⵜⵅⴻⵚⵚⴰ ⵡⴰⵔ ⵜⵜⵃⵉⴷⵉⵏ ⵎⵉⵏ ⵉⴵⴰⵏ ⵉⵇⴻⴷⴷⵙⴻⵏ, ⵎⵉⵏⵣⵉ ⵎⴰⵍⴰ ⵍⵍⴰ ⴰⴷ ⵎⵎⵜⴻⵏ. ⵎⴰⵏ ⴰⵢⴰ ⴷ ⵎⵉⵏ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⴰⵔⴱⵓⵏ ⵡⴰⵔⵔⴰⵡ ⵏ ⵇⴰⵀⴰⵜ ⴷⵉ ⵜⵎⴻⵙⵍⴰⵛⵜ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","ⴰⵍⵉⵄⴰⵣⴰⵔ, ⵎⵎⵉⵙ ⵏ ⵓⴽⴻⵀⵀⴰⵏ ⵀⴰⵔⵓⵏ, ⴰⴷ ⵉⵟⵟⴻⴼ ⴰⵛⴱⴰⵔ ⵅ ⵣⵣⴻⵛⵜ ⵉ ⵜⴼⴰⵡⵜ ⴷ ⵍⴻⴱⵅⵓⵔ ⵉⵜⵜⴼⵓⵃⴻⵏ ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵏ ⵍⴻⴱⴷⴰ ⴷ ⵣⵣⴻⵛⵜ ⵉ ⵡⴻⴷⵀⴰⵏ, ⵡⴰⵀ, ⵀⴰⵔⵓⵏ ⴰⴷ ⵉⵟⵟⴻⴼ ⴰⵛⴱⴰⵔ ⵅ ⵜⵣⴻⴷⴷⵉⵖⵜ ⵎⴰⵔⵔⴰ ⵓ ⵅ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴷⴰⵢⴻⵙ, ⵍⴰ ⵅ ⵎⵉⵏ ⵉⴵⴰⵏ ⴷⵉ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵓⵍⴰ ⵅ ⵍⴻⵇⵛⵓⵄ ⵏⵏⴻⵙ.” ");
INSERT INTO rift_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“ⵖⴰⵔⵡⴻⵎ ⴰⴷ ⵜⵇⴻⴹⵄⴻⵎ ⵜⴰⵇⴱⵉⵍⵜ ⵏ ⵍⴰⴵⴰⵜ ⵏ ⵉⵇⴰⵀⴰⵜⵉⵢⵢⴻⵏ ⵣⵉ ⵍⵡⴻⵙⵟ ⵏ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","ⴳⴳⴻⵎ ⴽⵉⵙⴻⵏ ⴰⵎⵎⵓ ⵃⵉⵎⴰ ⴰⴷ ⴷⴷⴰⵔⴻⵏ, ⵡⴰⵔ ⵜⵜⵎⴻⵜⵜⵉⵏ ⵅⵎⵉ ⴷⴷ ⵖⴰ ⵇⴰⵔⵔⴱⴻⵏ ⵖⴰⵔ ⵡⴻⵇⴷⴰⵙ ⵅ ⵓⵇⴻⴷⴷⴰⵙ: ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⵙ ⵉ ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⴰⴷ ⴷⴷ-ⴰⴷⴼⴻⵏ ⵓⵛⴰ ⴰⴷ ⴳⴳⴻⵏ ⴽⵓⵍ ⴰⵔⵢⴰⵣ ⴷⵉ ⵍⵅⴻⴷⵎⴻⵜ ⵏⵏⴻⵙ ⵓ ⴷⵉ ⴷⴷⵇⴻⵍ ⵉ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵢⴰⵔⴱⵓ. ");
INSERT INTO rift_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","ⵡⴰⵔ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⴰⴷⴼⴻⵏ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵥⴰⵔⴻⵏ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ, ⵎⵖⵉⵔ ⵉ ⵢⵉⵛⵜ ⵏ ⵡⴻⵔⵎⴰⵛ ⵏ ⵡⴰⴱⵍⵉⵡⴻⵏ ⵡⴰⵀⴰ, ⵎⴰⵖⴰⵔ ⵅⴻⵏⵏⵉ ⴰⴷ ⵎⵎⵜⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“ⵃⵙⴻⴱ ⵄⴰⵡⴻⴷ ⴰⵢⵜ ⵏ ⵊⴰⵔⵛⵓⵏ ⴰⵣⴻⴵⵉⴼ ⴰⵣⴻⴵⵉⴼ, ⴰⵎ ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵏⵉⵜⵏⵉ ⵄⵍⴰⵃⵙⴰⴱ ⵜⵓⴷⵔⵉⵏ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵙⴻⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","ⴰⴷ ⵜⴻⵏ ⵜⵃⴻⵙⴱⴻⴷ ⵣⵉ ⵜⵍⴰⵜⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵙⴻⵏⵏⴻⵊ, ⴰⵍ ⵅⴻⵎⵙⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⴽⵓⵍ ⵉⵊⵊ ⵉ ⵖⴰ ⵢⴰⴷⴼⴻⵏ ⵖⴰⵔ ⵍⵄⴻⵙⴽⴰⵔ ⵃⵉⵎⴰ ⴰⴷ ⵢⴻⴳⴳ ⵜⴰⵙⴻⵅⵅⴰⵔⵜ ⴷⴻⴳ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","ⴷ ⵜⴰ ⴷ ⵜⴰⵙⴻⵅⵅⴰⵔⵜ ⵏ ⵍⴰⴵⴰⵜ ⵏ ⵊⴰⵔⵛⵓⵏ ⴷⵉ ⵜⵎⴻⵙⵍⴰⵛⵜ ⵏ ⵜⵙⴻⵅⵅⴰⵔⵜ ⴷ ⵜⴰⵔⴻⴱⴱⵓⵜ. ");
INSERT INTO rift_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","ⴰⴷ ⴰⵔⴱⵓⵏ ⵜⵉⵊⴰⵔⵜⵉⵍⵉⵏ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ ⴷ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ: ⵜⴰⵙⴻⵇⵇⴰⴼⵜ ⵏⵏⴻⵙ ⴷ ⵜⵙⴻⵇⵇⴰⴼⵜ ⵏⵏⴻⵙ ⵏ ⵉⵍⵎⴰⵡⴻⵏ ⵏ ⴷⴷⴻⵏⴼⵉⵍⴰⵜ ⵏⵏⵉ ⵉ ⵖⴰ ⵢⵉⵍⵉⵏ ⵜⵉⵡⵡⴰ ⵏⵏⴻⵙ, ⴷ ⵡⴰⵔⵡⴰⵇ ⵏ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ");
INSERT INTO rift_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","ⴷ ⵍⵉⵣⴰⵔⴰⵜ ⵏ ⵍⴻⵎⵔⴰⵃ ⴷ ⴰⵔⵡⴰⵇ ⵉ ⵜⴻⵡⵡⴰⵔⵜ ⵏ ⵡⴰⴷⴰⴼ ⵖⴰⵔ ⵍⴻⵎⵔⴰⵃ ⵉ ⴷⴷ-ⵉⵏⵏⴹⴻⵏ ⵉ ⵜⵣⴻⴷⴷⵉⵖⵜ ⴷ ⵓⵄⴰⵍⵟⴰⵔ ⴷ ⵎⴰⵔⵔⴰ ⵉⴼⵉⵍⴰⵏ ⵏⵙⴻⵏ ⴷ ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ ⵉ ⴷⴷ-ⵉⵜⵜⴰⵙⴻⵏ ⴰⴽ-ⴷ ⵜⵙⴻⵅⵅⴰⵔⵜ ⵏⵙⴻⵏ ⵓ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴷ ⴰⵙ ⵚⴻⵏⵏⵄⴻⵏ, ⴷ ⵎⴰⵏ ⴰⵢⴰ ⴰⴷ ⵜⵉⵍⵉ ⵍⵅⴻⴷⵎⴻⵜ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","ⵎⴰⵔⵔⴰ ⵍⵅⴻⴷⵎⴻⵜ ⵏ ⴰⵢⵜ ⵏ ⵊⴰⵔⵛⵓⵏ ⴷⵉ ⵜⵎⴻⵙⵍⴰⵛⵜ ⵏ ⵎⴰⵔⵔⴰ ⵜⴰⵔⴻⴱⴱⵓⵜ ⴷ ⵎⴰⵔⵔⴰ ⵜⴰⵙⴻⵅⵅⴰⵔⵜ ⵏⵙⴻⵏ, ⴰⴷ ⵜⵉⵍⵉ ⵄⵍⴰⵃⵙⴰⴱ ⵍⵓⵎⵓⵔ ⵏ ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ. ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⵡⴻⵎ ⴰⴷ ⵜⴻⵏ ⵜⴻⵙⵙⴻⵛⵏⴻⵎ ⵙ ⵓⵃⴻⵟⵟⵓ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⴰⵔⴱⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","ⵜⴰ ⴷ ⵜⴰⵙⴻⵅⵅⴰⵔⵜ ⵏ ⵍⴰⴵⴰⵜ ⵏ ⴰⵢⵜ ⵏ ⵊⴰⵔⵛⵓⵏ ⴷⴻⴳ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ⵏⵉⵜⵏⵉ ⴰⴷ ⴽⵙⵉⵏ ⴰⵎⵏⵓⵙ ⵉ ⵓⵢⴰ ⵙⴰⴷⵓ ⵓⴼⵓⵙ ⵏ ⵉⵜⴰⵎⴰⵔ, ⵎⵎⵉⵙ ⵏ ⵀⴰⵔⵓⵏ, ⴰⴽⴻⵀⵀⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","ⴰⴷ ⵜⵃⴻⵙⴱⴻⴷ ⴰⵢⵜ ⵏ ⵎⴰⵔⴰⵔⵉ, ⴰⵎ ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵏⵉⵜⵏⵉ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵜⵓⴷⵔⵉⵏ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","ⴰⴷ ⵜⴻⵏ ⵜⵃⴻⵙⴱⴻⴷ ⵣⵉ ⵜⵍⴰⵜⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵙⴻⵏⵏⴻⵊ, ⴰⵍ ⵅⴻⵎⵙⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵎⴰⵔⵔⴰ ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵢⴰⴷⴼⴻⵏ ⵖⴰⵔ ⵍⵄⴻⵙⴽⴰⵔ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⵙⴻⵅⵅⴰⵔ ⴷⵉ ⵜⵙⴻⵅⵅⴰⵔⵜ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","ⴷ ⵜⴰ ⴷ ⵜⴰⵙⵖⴰⵔⵜ ⵏⵙⴻⵏ ⴷⵉ ⵜⵔⴻⴱⴱⵓⵜ ⵖⴰⵔ ⵎⴰⵔⵔⴰ ⵜⴰⵙⴻⵅⵅⴰⵔⵜ ⵏⵙⴻⵏ ⴷⴻⴳ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ: ⵜⵉⴼⴻⵍⵡⵉⵏ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ ⴷ ⵜⵃⴻⵏⵢⴰ ⵏ ⵓⵄⴰⵔⵔⴻⴹ ⴷ ⵉⴱⵉⵍⴰⵔⴻⵏ ⵏⵏⴻⵙ ⴷ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵏⵏⴻⵙ, ");
INSERT INTO rift_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","ⴷ ⵉⴱⵉⵍⴰⵔⴻⵏ ⵏ ⵍⴻⵎⵔⴰⵃ ⵉ ⴷ ⴰⵙ ⴷⴷ-ⵉⵏⵏⴹⴻⵏ ⴰⴽ-ⴷ ⵜⵢⴰⵔⵙⴰⵡⵉⵏ ⵏⵙⴻⵏ ⴷ ⵍⴻⵡⵜⴰⴷ ⵏⵙⴻⵏ ⴷ ⵉⵙⴻⵖⵡⴰⵏ ⵏⵙⴻⵏ, ⴰⵇⴰ ⴷ ⵜⴰ ⴷ ⵜⴰⵙⵖⴰⵔⵜ ⵏⵙⴻⵏ ⴷⵉ ⵜⵔⴻⴱⴱⵓⵜ ⵏ ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ ⵏⵙⴻⵏ ⵓ ⴷⵉ ⵎⴰⵔⵔⴰ ⵜⴰⵙⴻⵅⵅⴰⵔⵜ ⵉ ⴷⴷ-ⵉⵜⵜⴰⵙⴻⵏ ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⵎⴰⵏ ⴰⵢⴰ. ⵍⴻⵇⵛⵓⵄ ⵉ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜⴻⵏ ⴰⵔⴱⵓⵏ, ⵉⵜⵜⵅⴻⵚⵚⴰ ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⵜⴻⵏ ⵜⵣⴻⵎⵎⴻⴷ ⵙ ⵉⵙⵎⴰⵡⴻⵏ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","ⴷ ⵜⴰ ⴷ ⵜⴰⵙⴻⵅⵅⴰⵔⵜ ⵏ ⵍⴰⴵⴰⵜ ⵏ ⴰⵢⵜ ⵏ ⵎⴰⵔⴰⵔⵉ ⵖⴰⵔ ⵎⴰⵔⵔⴰ ⵜⴰⵙⴻⵅⵅⴰⵔⵜ ⵏⵙⴻⵏ ⴷⴻⴳ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⵙⴰⴷⵓ ⵓⴼⵓⵙ ⵏ ⵉⵜⴰⵎⴰⵔ, ⵎⵎⵉⵙ ⵏ ⵀⴰⵔⵓⵏ, ⴰⴽⴻⵀⵀⴰⵏ.” ");
INSERT INTO rift_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ ⴷ ⵍⵃⵓⴽⴽⴰⵎ ⵏ ⵜⵎⴻⵙⵎⵓⵏⵜ ⵃⴻⵙⴱⴻⵏ ⴰⵢⵜ ⵏ ⵇⴰⵀⴰⵜ, ⴰⵎ ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵏⵉⵜⵏⵉ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ ⵓ ⵄⵍⴰⵃⵙⴰⴱ ⵜⵓⴷⵔⵉⵏ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵙⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","ⵣⴻⴳ ⵡⴻⵏⵏⵉ ⵖⴰⵔ ⵉⴵⴰ ⵜⵍⴰⵜⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵙⴻⵏⵏⴻⵊ, ⴰⵍ ⵡⴻⵏⵏⵉ ⵖⴰⵔ ⵉⴵⴰ ⵅⴻⵎⵙⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⴽⵓⵍ ⵉⵊⵊ ⵉ ⵖⴰ ⵢⴰⴷⴼⴻⵏ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⵙⴻⵅⵅⴰⵔ ⴷⴻⴳ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","ⵉⵏⵏⵉ ⵣⵣⴰⵢⵙⴻⵏ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ, ⴰⵎ ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵏⵉⵜⵏⵉ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ, ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⴰⵍⴼⴰⵢⴻⵏ ⵓ-ⵙⴻⴱⵄⴰ-ⵎⵢⴰ ⵓ-ⵅⴻⵎⵙⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","ⵉⵏⴰ ⴷ ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵣⵉ ⵍⴰⴵⴰⵜ ⵏ ⵉⵇⴰⵀⴰⵜⵉⵢⵢⴻⵏ, ⵎⴰⵔⵔⴰ ⵡⵉ ⵉⵜⵜⵙⴻⵅⵅⴰⵔⴻⵏ ⴷⴻⴳ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ⵉⵏⵏⵉ ⵃⴻⵙⴱⴻⵏ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ ⵅ ⵍⵓⵎⵓⵔ ⵏ ⵙⵉⴷⵉ ⵙⴰⴷⵓ ⵓⴼⵓⵙ ⵏ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵣⴻⴳ ⴰⵢⵜ ⵏ ⵊⴰⵔⵛⵓⵏ, ⴰⵎ ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵏⵉⵜⵏⵉ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ ⵓ ⵄⵍⴰⵃⵙⴰⴱ ⵜⵓⴷⵔⵉⵏ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵙⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","ⵣⴻⴳ ⵡⴻⵏⵏⵉ ⵖⴰⵔ ⵉⴵⴰ ⵜⵍⴰⵜⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵙⴻⵏⵏⴻⵊ, ⴰⵍ ⵡⴻⵏⵏⵉ ⵖⴰⵔ ⵉⴵⴰ ⵅⴻⵎⵙⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⴽⵓⵍ ⵉⵊⵊ ⵉ ⵖⴰ ⵢⴰⴷⴼⴻⵏ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⵙⴻⵅⵅⴰⵔ ⴷⴻⴳ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ");
INSERT INTO rift_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","ⴰⵇⴰ ⵉⵏⵏⵉ ⵣⵣⴰⵢⵙⴻⵏ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ, ⴰⵎ ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵏⵉⵜⵏⵉ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵜⵓⴷⵔⵉⵏ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵙⴻⵏ, ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⴰⵍⴼⴰⵢⴻⵏ ⵓ-ⵙⴻⵜⵜⴰ-ⵎⵢⴰ ⵓ-ⵜⵍⴰⵜⵉⵏ, ");
INSERT INTO rift_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","ⵉⵏⴰ ⴷ ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵏ ⵍⴰⴵⴰⵜ ⵏ ⴰⵢⵜ ⵏ ⵊⴰⵔⵛⵓⵏ, ⵎⴰⵔⵔⴰ ⵡⵉ ⵉⵜⵜⵙⴻⵅⵅⴰⵔⴻⵏ ⴷⴻⴳ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ⵉⵏⵏⵉ ⵃⴻⵙⴱⴻⵏ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ ⵅ ⵍⵓⵎⵓⵔ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","ⵉⵏⴰ ⴷ ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵏ ⵍⴰⴵⴰⵜ ⵏ ⴰⵢⵜ ⵏ ⵎⴰⵔⴰⵔⵉ, ⴰⵎ ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵏⵉⵜⵏⵉ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵜⵓⴷⵔⵉⵏ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵙⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","ⵣⴻⴳ ⵡⴻⵏⵏⵉ ⵖⴰⵔ ⵉⴵⴰ ⵜⵍⴰⵜⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵙⴻⵏⵏⴻⵊ, ⴰⵍ ⵡⴻⵏⵏⵉ ⵖⴰⵔ ⵉⴵⴰ ⵅⴻⵎⵙⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⴽⵓⵍ ⵉⵊⵊ ⵉ ⵖⴰ ⵢⴰⴷⴼⴻⵏ ⴷⵉ ⵍⵄⴻⵙⴽⴰⵔ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⵙⴻⵅⵅⴰⵔ ⴷⴻⴳ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ");
INSERT INTO rift_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","ⴰⵇⴰ ⵉⵏⵏⵉ ⵣⵣⴰⵢⵙⴻⵏ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ, ⴰⵎ ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵏⵉⵜⵏⵉ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ, ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⵜⴻⵍⵜ-ⴰⵍⴰⴼ ⵓ-ⵎⵉⵜⴰⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","ⵉⵏⴰ ⴷ ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵏ ⵍⴰⴵⴰⵜ ⵏ ⵎⴰⵔⴰⵔⵉ, ⵉⵏⵏⵉ ⵃⴻⵙⴱⴻⵏ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ ⵅ ⵍⵓⵎⵓⵔ ⵏ ⵙⵉⴷⵉ ⵙⴰⴷⵓ ⵓⴼⵓⵙ ⵏ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","ⵎⴰⵔⵔⴰ ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ, ⵉⵏⵏⵉ ⵃⴻⵙⴱⴻⵏ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ ⴷ ⵍⵃⵓⴽⴽⴰⵎ ⵏ ⵉⵙⵔⴰⵉⵍ ⵣⴻⴳ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ, ⴰⵎ ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵏⵉⵜⵏⵉ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ ⵓ ⵄⵍⴰⵃⵙⴰⴱ ⵜⵓⴷⵔⵉⵏ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵙⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","ⵣⴻⴳ ⵡⴻⵏⵏⵉ ⵖⴰⵔ ⵉⴵⴰ ⵜⵍⴰⵜⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵙⴻⵏⵏⴻⵊ ⴰⵍ ⵡⴻⵏⵏⵉ ⵖⴰⵔ ⵉⴵⴰ ⵅⴻⵎⵙⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⵎⴰⵔⵔⴰ ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵢⴰⴷⴼⴻⵏ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⴳⴳ ⵍⵅⴻⴷⵎⴻⵜ ⵏ ⵜⵙⴻⵅⵅⴰⵔⵜ ⵓ ⵍⵅⴻⴷⵎⴻⵜ ⵏ ⵜⵔⴻⴱⴱⵓⵜ ⵏ ⴷⴷⵇⵓⵍⴰⵜ ⴷⴻⴳ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ");
INSERT INTO rift_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","ⴰⵇⴰ ⵉⵏⵏⵉ ⵣⵣⴰⵢⵙⴻⵏ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⵜⴻⵎⵏ-ⴰⵍⴰⴼ ⵓ-ⵅⴻⵎⵙⴰ-ⵎⵢⴰ ⵓ-ⵜⵎⴰⵏⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","ⵏⵉⵜⵏⵉ ⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵅ ⵍⵓⵎⵓⵔ ⵏ ⵙⵉⴷⵉ ⵙⴰⴷⵓ ⵓⴼⵓⵙ ⵏ ⵎⵓⵙⴰ, ⴽⵓⵍ ⴰⵔⵢⴰⵣ ⵉⵜⵜⵡⴰⵍⴻⵇⵇⴻⵎ ⴷⵉ ⵜⵙⴻⵅⵅⴰⵔⵜ ⵏⵏⴻⵙ ⵓ ⵅ ⴷⴷⵇⴻⵍ ⵏⵏⴻⵙ. ⵏⵉⵜⵏⵉ ⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵣⵣⴰⵢⴻⵙ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵙ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“ⵓⵎⵓⵔ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴰⴷ ⵙⵙⵓⴼⴼⵖⴻⵏ ⵎⴰⵔⵔⴰ ⴰⵢⵜ ⵏ ⵍⴱⴰⵔⵚ ⵣⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ, ⵓⵍⴰ ⴷ ⵎⴰⵔⵔⴰ ⵉⵏⵏⵉ ⵖⴰⵔ ⵉⴵⴰ ⵓⵙⴻⵢⵢⴻⵍ ⴷ ⵎⴰⵔⵔⴰ ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵙⵙⵅⴻⵎⵊⴻⵏ ⵣⴻⴳ ⵉⵛⵜ ⵏ ⵍⵅⴻⵛⴱⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","ⴰⴷ ⵜⴻⵏ ⵜⴻⵙⵙⵓⴼⴼⵖⴻⵎ, ⴰⵎ ⵢⴻⵔⵢⴰⵣⴻⵏ ⴰⵎ ⵜⴻⵎⵖⴰⵔⵉⵏ. ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⵜⴻⵏ ⵜⴻⵙⵙⵓⴼⴼⵖⴻⵎ ⴱⴰⵔⵔⴰ ⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵃⵉⵎⴰ ⵡⴰⵔ ⵙⵙⵅⴻⵎⵎⴰⵊⴻⵏ ⵍⴻⵎⵔⴰⴳⴻⵃ ⵏⵙⴻⵏ ⵎⴰⵏⵉ ⵣⴻⴷⴷⵖⴻⵖ ⵏⴻⵛⵛ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏⵙⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","ⵓⵛⴰ ⴳⴳⵉⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴰⵎⵎⵓ. ⵏⵉⵜⵏⵉ ⵙⵙⵓⴼⴼⵖⴻⵏ ⵜⴻⵏ ⴱⴰⵔⵔⴰ ⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ. ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴳⴳⵉⵏ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵉ ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“ⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ: ‘ⵎⴰⵍⴰ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵏⵉⵖ ⵉⵛⵜ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⵉ ⵉⴳⴳⵉⵏ ⵛⴰ ⵏ ⴷⴷⴻⵏⴱ ⵏ ⴱⵏⴰⴷⴻⵎ ⵉ ⵣⵉ ⵉⵖⴷⴰⵔ ⴷⵉ ⵙⵉⴷⵉ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵢⵉⵍⵉ ⵍⴻⵄⵎⴰⵔ ⵏⵏⵉ ⴷ ⴱⵓ-ⵓⵎⴰⵔⵡⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","ⴰⴷ ⵏⴻⵄⵎⴻⵏ ⵅ ⴷⴷⴻⵏⴱ ⵏⵙⴻⵏ ⵉ ⴳⴳⵉⵏ. ⵏⴻⵜⵜⴰ ⴰⴷ ⵉⵅⴻⴵⴻⵚ ⴰⵎⴰⵔⵡⴰⵙ ⵏⵏⴻⵙ ⵎⴰⵔⵔⴰ ⵓ ⴰⴷ ⴰⵙ ⵢⴰⵔⵏⵉ ⵉⵛⵜ ⵏ ⵜⴻⵙⵖⴰⵔⵜ ⵜⴻⵅⵎⵓⵙⴻⵛⵜ ⵓⵛⴰ ⴰⴷ ⵉⵡⵛ ⴰⵢⴰ ⵉ ⵡⴻⵏⵏⵉ ⵉⴷⴻⵡⵍⴻⵏ ⵉⵜⵜⵓⵔⵙ ⴰⵙ ⵏⴻⵜⵜⴰ. ");
INSERT INTO rift_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⵡⴰⵔ ⴷⵉⵏ ⵉⴵⵉ ⵓⵎⴻⴼⴷⵉ ⵉ ⵡⴻⵔⵢⴰⵣ ⵏⵏⵉ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴰⵙ ⵉⵅⴻⴵⴻⵚ ⴰⵎⴰⵔⵡⴰⵙ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵢⵉⵍⵉ ⵓⵎⴰⵔⵡⴰⵙ, ⵉ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵉⵅⴻⴵⴻⵚ ⵉ ⵙⵉⴷⵉ, ⵉ ⵓⴽⴻⵀⵀⴰⵏ, ⴰⴽ-ⴷ ⴷ ⵉⵛⴰⵔⵔⵉ ⵏ ⵡⴻⵚⵍⴰⵃ ⵉ ⵣⵣⴰⵢⴻⵙ ⵜ ⵖⴰ ⵉⵙⵙⴻⵚⵍⴻⵃ.    ");
INSERT INTO rift_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","ⴽⵓⵍ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⵉ ⵙⵙⴳⴻⵄⵄⴷⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵏ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵏⵏⵉ ⴷⴷ-ⵉⵜⵜⴰⵡⵢⴻⵏ ⵖⴰⵔ ⵓⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵜⵉⵍⵉ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","ⵎⴰⵔⵔⴰ ⵜⵉⵡⵀⵉⴱⵉⵏ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵏ ⵛⴰ ⵏ ⵡⴻⵔⵢⴰⵣ ⴰⴷ ⵉⵍⵉⵏⵜ ⵉ ⵏⴻⵜⵜⴰ, ⵎⵉⵏ ⵎⴰ ⵉ ⵖⴰ ⵉⵡⵛ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵉ ⵓⴽⴻⵀⵀⴰⵏ, ⴷ ⵎⴰⵏ ⴰⵢⴰ ⴰⴷ ⵢⵉⵍⵉ ⵉ ⵏⴻⵜⵜⴰ.’” ");
INSERT INTO rift_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“ⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵛⴰ ⵉⵏⵉ ⴰⵙⴻⵏ: ‘ⵎⴰⵍⴰ ⵜⴰⵎⵖⴰⵔⵜ ⵏ ⵛⴰ ⵏ ⵡⴻⵔⵢⴰⵣ ⵜⴻⴼⴼⴻⵖ ⵓ ⵜⴻⵖⴷⴰⵔ ⵉ-ⵜ, ");
INSERT INTO rift_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","ⵓ ⵛⴰ ⵏ ⵡⴻⵔⵢⴰⵣ ⵉⵙⵙⴻⵏ ⵉ-ⵜⵜ, ⵓⵛⴰ ⵎⴰⵏ ⴰⵢⴰ ⵉⵏⵏⵓⴼⴰⵔⴻⵏ ⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵡⴻⵔⵢⴰⵣ ⵏⵏⴻⵙ ⵓ ⵏⴻⵜⵜⴰⵜ ⵜⴻⵙⵙⵏⵓⴼⴼⴰⵔ ⵉ-ⵜ ⵓⵛⴰ ⴰⵎⵎⵓ ⵜⴻⵙⵙⴻⵅⵎⴻⵊ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵓ ⵡⴰⵔ ⴷⵉⵏ ⵡⵉ ⵅⴰⵙ ⵖⴰ ⵉⵛⴻⵀⴷⴻⵏ ⵓ ⵏⴻⵜⵜⴰⵜ ⵄⴻⵎⵎⴰⵔⵚ ⵡⴰⵔ ⵜᵉⵜⵜⵡⴰⵟⵟⴻⴼ, ");
INSERT INTO rift_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","ⵓⵛⴰ ⵅⴻⵏⵏⵉ ⵢⵓⵙⴰ-ⴷⴷ ⵅⴰⵙ ⴱⵓⵃⴱⴻⵍ ⵏ ⵜⵓⵙⵎⵉ ⵓⵛⴰ ⵢⵓⵙⴻⵎ ⵅ ⵜⴻⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ ⵓⵎⵉ ⵏⴻⵜⵜⴰⵜ ⵜᵉⵜⵜⵡⴰⵙⵙⴻⵅⵎⴻⵊ, ⵏⵉⵖ ⵢⵓⵙⴰ-ⴷⴷ ⵅⴰⵙ ⴱⵓⵃⴱⴻⵍ ⵏ ⵜⵓⵙⵎⵉ ⵓⵛⴰ ⵢⵓⵙⴻⵎ ⵅ ⵜⴻⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ ⵓⵎⵉ ⵏⴻⵜⵜⴰⵜ ⵡⴰⵔ ⵜᵉⵜⵜⵡⴰⵙⵙⴻⵅⵎⵉⵊ ⵛⴰ, ");
INSERT INTO rift_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","ⵅⴻⵏⵏⵉ ⴰⵔⵢⴰⵣ ⴰⴷ ⵢⴰⵡⵉ ⵜⴰⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ ⵖⴰⵔ ⵓⴽⴻⵀⵀⴰⵏ ⵓⵛⴰ ⴰⴷ ⵢⴰⵡⵉ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵉ ⵏⴻⵜⵜⴰⵜ, ⴰⵇⴰ-ⵜⵜ ⴷ ⵜⴰⵄⵛⴰⵔⵜ ⵏ ⵉⵊⵊ ⵏ ⵉⴼⴰ ⵏ ⵡⴰⵔⴻⵏ ⵏ ⵉⵎⴻⵏⴷⵉ. ⵡⴰⵔ ⵅⴰⵙ ⵉⴼⴰⵔⵔⴻⵖ ⵣⵣⴻⵛⵜ ⵏⵉⵖ ⴰⴷ ⵅⴰⵙ ⵉⵙⵙⴰⵔⵙ ⵊⵊⴰⵡⵉ, ⵎⵉⵏⵣⵉ ⴰⵇⴰ-ⵜⵜ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⴷⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⵜⵓⵙⵎⵉ, ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵉ ⵍⵉⴷⴰⵔⴻⵜ, ⵜⴻⵏⵏⵉ ⴷⴷ ⵖⴰ ⵢⴰⵡⵢⴻⵏ ⴰⵅⴰⵔⵔⴻⵚ ⴷⵉ ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","ⴰⴷ ⵜⵜ-ⵉ-ⴷⴷ-ⵉⵙⵙⵇⴰⵔⵔⴻⴱ ⵓⴽⴻⵀⵀⴰⵏ ⵓⵛⴰ ⴰⴷ ⵜⵜ ⵉⵙⵙⴰⵔⵙ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","ⴰⴷ ⵉⴽⵙⵉ ⵓⴽⴻⵀⵀⴰⵏ ⴰⵎⴰⵏ ⵉⵇⴻⴷⴷⵙⴻⵏ ⴷⴻⴳ ⵉⵛⵜ ⵏ ⵍⵇⴻⵛⵄⴻⵜ ⵏ ⵜⵍⴰⵅⵜ ⵓⵛⴰ ⴰⴷ ⵉⴽⵙⵉ ⵛⴰ ⵣⴻⴳ ⵓⵛⴰⵍ ⵉ ⵉⴵⴰⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ, ⴰⴷ ⵢⴻⴳⴳ ⴰⵢⴰ ⴷⴻⴳ ⵡⴰⵎⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⴳⴳ ⵓⴽⴻⵀⵀⴰⵏ ⵜⴰⵎⵖⴰⵔⵜ ⵏⵏⵉ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ, ⴰⴷ ⵉⴼⴻⴽⴽ ⴰⵛⵓⵡⵡⴰⴼ ⵏ ⵓⵣⴻⴵⵉⴼ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⵓⵛⴰ ⴰⴷ ⵉⴳⴳ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵉ ⵍⵉⴷⴰⵔⴻⵜ ⴷⴻⴳ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵏⴻⵙ, ⴰⵇⴰ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵏ ⵜⵓⵙⵎⵉ. ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵉⵟⵟⴻⴼ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏⵏⴻⵙ ⴰⵎⴰⵏ ⵉⵎⴻⵔⵣⴰⴳⴻⵏ ⵏⵏⵉ ⴷⴷ-ⵉⵜⵜⴰⵡⵢⴻⵏ ⵏⵏⴻⵄⵍⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵜⵜ ⵢⴻⵊⵊ ⴰⴷ ⵜⴻⵊⵊⴰⴵ ⵓⵛⴰ ⴰⴷ ⵢⵉⵏⵉ ⵉ ⵜⴻⵎⵖⴰⵔⵜ: ⵎⴰⵍⴰ ⵡⴰⵔ ⴽⵉⵎ ⵉⵟⵟⵉⵚ ⵃⴻⴷ ⵓ ⵡⴰⵔ ⵜⴻⵡⴹⵉⴷ ⵣⴻⴳ ⵡⴻⵔⵢⴰⵣ ⵏⵏⴻⵎ ⴷⵉ ⵜⴻⵅⵎⵓⵊⵉ, ⴰⵇⴰ ⴰⴷ ⵜⵉⵍⵉⴷ ⵜᵉⵜⵜⵡⴰⵚⴼⵉⴷ ⵣⴻⴳ ⵡⴰⵎⴰⵏ-ⴰ ⵉⵎⴻⵔⵣⴰⴳⴻⵏ ⵉⵏⵏⵉ ⴷⴷ-ⵉⵜⵜⴰⵡⵢⴻⵏ ⵏⵏⴻⵄⵍⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","ⵎⴰⵛⴰ ⵓⵛⵜ ⵅⴰⵎ, ⵎⴰⵍⴰ ⵜⴻⵡⴹⵉⴷ ⵣⴻⴳ ⵡⴻⵔⵢⴰⵣ ⵏⵏⴻⵎ ⵓⵛⴰ ⵜᵉⵜⵜⵡⴰⵙⵙⵅⴻⵎⵊⴻⴷ ⵓⵛⴰ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵎⵖⵉⵔ ⴰⵔⵢⴰⵣ ⵏⵏⴻⵎ ⵉⵟⵟⴻⵚ ⴰⴽⵉⵎ! ");
INSERT INTO rift_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","ⵅⴻⵏⵏⵉ ⴰⴷ ⵢⴻⵊⵊ ⵓⴽⴻⵀⵀⴰⵏ ⵜⴰⵎⵖⴰⵔⵜ ⴰⴷ ⵜⴻⵊⵊⴰⴵ ⵜⴰⵊⴰⴵⵉⵜ ⵏ ⵏⵏⴻⵄⵍⴻⵜ. ⴰⴷ ⵢⵉⵏⵉ ⵓⴽⴻⵀⵀⴰⵏ ⵉ ⵜⴻⵎⵖⴰⵔⵜ: ⵙⵉⴷⵉ ⴰⴷ ⵛⴻⵎ ⵢⴰⵔⵔ ⴷ ⵉⵊⵊ ⵏ ⵓⵎⴻⴷⵢⴰ ⵏ ⵏⵏⴻⵄⵍⴻⵜ-ⴰ ⴷ ⵜⵊⴰⴵⵉⵜ-ⴰ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵎ, ⵅⵎⵉ ⵖⴰ ⵢⴻⵊⵊ ⵙⵉⴷⵉ ⴰⴷ ⵉⵡⴹⴰ ⵓⵎⴻⵚⵚⴰⴹ ⵏⵏⴻⵎ ⵓⵛⴰ ⴰⴷ ⵢⴰⵔⵔ ⴰⵄⴻⴷⴷⵉⵙ ⵏⵏⴻⵎ ⵢⵓⴼⴼ, ");
INSERT INTO rift_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","ⵓⵛⴰ ⴰⵎⴰⵏ-ⴰ ⵉ ⴷⴷ-ⵉⵜⵜⴰⵡⵢⴻⵏ ⵏⵏⴻⵄⵍⴻⵜ ⴰⴷ ⴰⴷⴼⴻⵏ ⵖⴰⵔ ⵡⴰⴷⴰⵏ ⵏⵏⴻⵎ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵙⵙⵓⴼⴼⴻⵏ ⴰⵄⴻⴷⴷⵉⵙ ⵏⵏⴻⵎ ⵓⵛⴰ ⴰⴷ ⵙⵙⵖⴻⴹⵍⴻⵏ ⴰⵎⴻⵚⵚⴰⴹ ⵏⵏⴻⵎ! ⵓⵛⴰ ⴰⴷ ⵜⵉⵏⵉ ⵜⴻⵎⵖⴰⵔⵜ: ⴰⵎⵉⵏ ⴰⵎⵉⵏ! ");
INSERT INTO rift_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","ⴰⴷ ⵢⴰⵔⵉ ⵓⴽⴻⵀⵀⴰⵏ ⵏⵏⵄⴰⵍⵉ-ⵢⴰ ⵅ ⵉⵛⵜ ⵏ ⵜⴻⵡⵔⵉⵇⵜ ⵉⵜⵜⵡⴰⵏⵏⴹⴻⵏ ⵓⵛⴰ ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⴻⵏⵜ ⵉⵎⵃⴰ ⴷⴻⴳ ⵡⴰⵎⴰⵏ ⵉⵎⴻⵔⵣⴰⴳⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","ⴰⴷ ⵉⵡⵛ ⴰⵎⴰⵏ ⵉⵎⴻⵔⵣⴰⴳⴻⵏ ⵉ ⴷⴷ-ⵉⵜⵜⴰⵡⵢⴻⵏ ⵏⵏⴻⵄⵍⴻⵜ ⵉ ⵜⴻⵎⵖⴰⵔⵜ ⵓ ⵏⴻⵜⵜⴰⵜ ⴰⴷ ⵜⵙⵓ ⴰⵍⴰⵎⵉ ⴰⵎⴰⵏ ⵉ ⴷⴷ-ⵉⵜⵜⴰⵡⵢⴻⵏ ⵏⵏⴻⵄⵍⴻⵜ ⴰⴷ ⴷⴰⵢⴻⵙ ⴰⴷⴼⴻⵏ ⴷⴰⵅⴻⵍ ⵓⵛⴰ ⴰⴷ ⴷⴻⵡⵍⴻⵏ ⴷ ⵉⵎⴻⵔⵣⴰⴳⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵉⴽⵙⵉ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵏ ⵜⵓⵙⵎⵉ ⵣⴻⴳ ⵓⴼⵓⵙ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⵓⵛⴰ ⴰⴷ ⵉⵙⵙⴻⵏⵀⴻⵣⵣ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⵓⵛⴰ ⴰⴷ ⵜⵜ-ⵉ-ⴷⴷ ⵉⵙⵙⵇⴰⵔⵔⴻⴱ ⵖⴰⵔ ⵓⵄⴰⵍⵟⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","ⴰⴷ ⵉⴽⵙⵉ ⵓⴽⴻⵀⵀⴰⵏ ⵉⵊⵊ ⵏ ⵡⵓⵔⵓ ⵣⵉ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ, ⴰⵇⴰ-ⵜⵜ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵍⵉⴷⴰⵔⴻⵜ, ⵓⵛⴰ ⴰⴷ ⵉⵙⵙⴱⴻⵅⵅⴰⵔ ⴰⵢⴰ ⵅ ⵓⵄⴰⵍⵟⴰⵔ ⵓⵛⴰ ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⵡⵛ ⴰⵎⴰⵏ ⵉ ⵜⴻⵎⵖⴰⵔⵜ ⴰⴷ ⵜⵙⵓ. ");
INSERT INTO rift_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","ⵎⴰⵍⴰ ⵉⵡⵛⴰ ⴰⵙ ⴰⵎⴰⵏ ⴰⴷ ⵜⵙⵓ, ⵅⴻⵏⵏⵉ, ⵎⴰⵍⴰ ⵜᵉⵜⵜⵡⴰⵙⵙⴻⵅⵎⴻⵊ ⵓⵛⴰ ⵏⴻⵜⵜⴰⵜ ⵜⴻⵖⴷⴰⵔ ⴰⵔⵢⴰⵣ ⵏⵏⴻⵙ, ⴰⵎⴰⵏ ⵉ ⴷⴷ-ⵉⵜⵜⴰⵡⵢⴻⵏ ⵏⵏⴻⵄⵍⴻⵜ ⴰⴷ ⴷⴰⵢⴻⵙ ⴷⴻⵡⵍⴻⵏ ⴷ ⵉⵎⴻⵔⵣⴰⴳⴻⵏ ⵓⵛⴰ ⴰⵄⴻⴷⴷⵉⵙ ⵏⵏⴻⵙ ⴰⴷ ⵢⵓⴼⴼ ⵓⵛⴰ ⴰⵎⴻⵚⵚⴰⴹ ⵏⵏⴻⵙ ⴰⴷ ⵉⵜⵜⵡⴰⵖⴹⴻⵍ ⵓ ⵜⴰⵎⵖⴰⵔⵜ ⴰⴷ ⵜⴻⴷⵡⴻⵍ ⴷ ⵏⵏⴻⵄⵍⴻⵜ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⵡⴰⵔ ⵜⴻⵅⵎⵉⵊ ⵛⴰ ⵜⴻⵎⵖⴰⵔⵜ, ⵎⴰⵛⴰ ⵜⴻⵣⴷⴻⴳ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⵉⵍⵉ ⵡⴰⵔ ⵅⴰⵙ ⵛⴰ, ⴰⴷ ⵜⵉⵍⵉ ⵜᵉⵜⵜⴰⵔⵓ.’” ");
INSERT INTO rift_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","ⵡⴰ ⴷ ⴰⵣⴻⵔⴼ ⵣⵉ ⵊⵊⵉⵀⴻⵜ ⵏ ⵜⵓⵙⵎⵉ, ⵅⵎⵉ ⵜⴻⵡⴹⴰ ⵉⵛⵜ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⵣⴻⴳ ⵡⴻⵔⵢⴰⵣ ⵏⵏⴻⵙ ⵓⵛⴰ ⵜᵉⵜⵜⵡⴰⵙⵙⴻⵅⵎⴻⵊ ");
INSERT INTO rift_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ⵏⵉⵖ ⵅⵎⵉ ⴷⴷ ⵢⵓⵙⴰ ⴱⵓⵃⴱⴻⵍ ⵏ ⵜⵓⵙⵎⵉ ⵅ ⵡⴻⵔⵢⴰⵣ ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵢⵓⵙⴻⵎ ⵅ ⵜⴻⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ. ⵅⴻⵏⵏⵉ ⴰⴷ ⵢⴰⵔⵔⴰ ⵜⴰⵎⵖⴰⵔⵜ ⴰⴷ ⵜⴱⴻⴷⴷ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⵓ ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⴰⵙ ⵉⴽⴻⵎⵎⴻⵍ ⵎⴰⵔⵔⴰ ⴰⵣⴻⵔⴼ-ⴰ ⵡⴰ. ");
INSERT INTO rift_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","ⴰⵔⵢⴰⵣ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⴰⵎⴻⵣⴷⴰⴳ ⵣⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ, ⵜⴰⵎⵖⴰⵔⵜ-ⴰ ⴰⴷ ⵜⴰⵔⴱⵓ ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“ⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵛⴰ ⵉⵏⵉ ⴰⵙⴻⵏ: ‘ⵎⴰⵍⴰ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵏⵉⵖ ⵉⵛⵜ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⵉ ⵉⵡⴻⵊⴷⴻⵏ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⵡⵛ ⴰⵡⴰⵍ ⵏ ⵜⵜⴰⵊ ⵏ ⵓⵛⵓⵡⵡⴰⴼ ⵏ ⵍⵡⴰⵄⴷ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⵄⵣⴻⵍ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵙ ⵜⵜⴰⵊ ⵏⵏⵉ ⵉ ⵙⵉⴷⵉ, ");
INSERT INTO rift_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⴳⴳⵯⴻⵊ ⵅ ⴱⵉⵏⵓ ⴷ ⵛⵛⵔⴰⴱ. ⵡⴰⵔ ⵉⵙⴻⵙⵙ ⵍⵅⴻⴵ ⵣⵉ ⴱⵉⵏⵓ ⵏⵉⵖ ⵍⵅⴻⴵ ⵣⵉ ⵛⵛⵔⴰⴱ ⵓ ⵡⴰⵔ ⵉⵙⴻⵙⵙ ⴰⵎⴰⵏ ⵏ ⵓⴹⵉⵍ, ⵓ ⵡⴰⵔ ⵉⵜⵜⴻⵜⵜ ⵣⴻⴳ ⵓⴹⵉⵍ ⴰⵣⴻⵢⵣⴰ ⵏⵉⵖ ⵣⴻⴳ ⵓⴹⵉⵍ ⵢⵓⵥⵖⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","ⵎⴰⵔⵔⴰ ⵓⵙⵙⴰⵏ ⵏ ⵜⵜⴰⵊ ⵏⵏⴻⵙ ⵏ ⵡⴻⵄⵣⴰⵍ ⵡⴰⵔ ⵉⵜⵜⴻⵜⵜ ⵛⴰ ⵎⵉⵏ ⴷⴷ-ⵉⴼⴼⵖⴻⵏ ⵣⵉ ⵜⵣⴰⵢⴰⵔⵜ, ⵣⴻⴳ ⵓⵄⴻⵇⵇⴰ ⵏⵏⴻⵙ ⴰⵍ ⵜⴰⵇⵛⵓⵔⵜ ⵏⵏⴻⵙ.’” ");
INSERT INTO rift_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“ⵎⴰⵔⵔⴰ ⵓⵙⵙⴰⵏ ⵏ ⵡⴰⵡⴰⵍ ⵉ ⴷⴷ ⵜⵜⴰⵙⴻⵏ ⴰⴽ-ⴷ ⵜⵜⴰⵊ ⵏⵏⴻⵙ ⵏ ⵡⴻⵄⵣⴰⵍ ⵡⴰⵔ ⵉⵜⵜⴻⴽⴽ ⵍⵎⵓⵙ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏⵏⴻⵙ ⴰⵍ ⵖⴰ ⴽⴻⵎⵎⵍⴻⵏ ⵡⵓⵙⵙⴰⵏ ⵏⵏⵉ ⵉⵄⵣⴻⵍ ⵉ ⵙⵉⴷⵉ ⵓⵛⴰ ⴰⴷ ⵢⵉⵍⵉ ⵉⵇⴻⴷⴷⴻⵙ ⵓⵛⴰ ⴰⴷ ⵢⴻⵊⵊ ⵉⵄⴻⵢⵢⴰⵛⴻⵏ ⵏ ⵓⵛⵓⵡⵡⴰⴼ ⵏ ⵓⵣⴻⴵⵉⴼ ⵏⵏⴻⵙ ⴰⴷ ⵎⵖⴰⵔⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","ⵎⴰⵔⵔⴰ ⵓⵙⵙⴰⵏ ⵉ ⵉⵙⵙⵃⵓⵣⵣ ⵉ ⵙⵉⴷⵉ, ⵡⴰⵔ ⴷⴷ-ⵉⵜⵜⵇⴰⵔⵔⵉⴱ ⵛⴰ ⵖⴰⵔ ⵍⴻⵄⵎⴰⵔ ⵏ ⵉⵊⵊ ⵏ ⵓⵎⴻⵜⵜⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","ⵡⴰⵔ ⵉⵙⵙⵅⴻⵎⵎⵉⵊ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵅ ⴱⴰⴱⴰⵙ ⵏⵉⵖ ⵅ ⵢⴻⵎⵎⴰⵙ ⵏⵉⵖ ⵅ ⵓⵎⴰⵙ ⵏⵉⵖ ⵅ ⵓⵍⵜⵎⴰⵙ ⵎⴰⵍⴰ ⴳⴳⵓⵔⴻⵏ ⴰⴷ ⵎⵎⵜⴻⵏ, ⵎⵉⵏⵣⵉ ⵜⵜⴰⵊ ⵏ ⵡⴻⵄⵣⴰⵍ ⵏ ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵙ ⴰⵇⴰ-ⵜⵜ ⵅ ⵓⵣⴻⴵⵉⴼ ⵏⵏⴻⵙ.” ");
INSERT INTO rift_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","“ⵎⴰⵔⵔⴰ ⵓⵙⵙⴰⵏ ⵏ ⵜⵜⴰⵊ ⵏⵏⴻⵙ ⵏ ⵡⴻⵄⵣⴰⵍ ⴰⴷ ⵢⵉⵍⵉ ⵉⵇⴻⴷⴷⴻⵙ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","ⵎⴰⵍⴰ ⵡⴻⵏⵏⵉ ⵉⵜⵜⵎⴻⵜⵜⴰⵏ ⴰⴷ ⵉⵎⵎⴻⵜ ⴷⴻⵖⵢⴰ ⴷⴻⴳ ⵡⴻⵔⵎⴰⵛ ⵏ ⵡⴰⴱⵍⵉⵡⴻⵏ ⵓⵛⴰ ⵉⵙⵙⴻⵅⵎⴻⵊ ⴰⵣⴻⴵⵉⴼ ⵏⵏⴻⵙ ⵙ ⵜⵜⴰⵊ ⵏⵏⴻⵙ ⵏ ⵡⴻⵄⵣⴰⵍ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⵃⴻⴼⴼ ⴰⵣⴻⴵⵉⴼ ⵏⵏⴻⵙ ⴷⴻⴳ ⵡⴰⵙⵙ ⵏ ⵓⵙⵉⵣⴷⴻⴳ ⵏⵏⴻⵙ. ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜ ⵉⵃⴻⴼⴼ. ");
INSERT INTO rift_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵜⵎⴻⵏⵢⴰ ⴰⴷ ⵢⴰⵡⵉ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵊⵍⵉⵍⵍⵉⵃⵉⵏ ⵏⵉⵖ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⴹⴱⵉⵔⴻⵏ ⵖⴰⵔ ⵓⴽⴻⵀⵀⴰⵏ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵉⵙⵙⴻⵡⵊⴻⴷ ⵉⵛⵜ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⴷ ⵉⵛⵜ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵓⵛⴰ ⴰⴷ ⵜ ⵉⵙⵙⴻⵚⵍⴻⵃ, ⵎⵉⵏⵣⵉ ⵏⴻⵜⵜⴰ ⴰⵇⴰ ⵉⵅⴹⴰ ⴷⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⵓⵎⴻⵜⵜⵉⵏ. ⵏⴻⵜⵜⴰ ⴰⴷ ⵉⵙⵙⵇⴻⴷⴷⴻⵙ ⴰⵣⴻⴵⵉⴼ ⵏⵏⴻⵙ ⵄⴰⵡⴻⴷ ⴷⴻⴳ ⵡⴰⵙⵙ ⵏⵏⵉ ");
INSERT INTO rift_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","ⵓⵛⴰ ⵜⵡⴰⵍⴰ ⵏⵏⴻⵖⵏⵉ ⴰⴷ ⵉⵏⴻⵢⵢⴻⵛ ⵏⴻⵜⵜⴰ ⵓⵙⵙⴰⵏ ⵏ ⵜⵜⴰⵊ ⵏⵏⴻⵙ ⵏ ⵡⴻⵄⵣⴰⵍ ⵉ ⵙⵉⴷⵉ ⵓⵛⴰ ⴰⴷ ⵉⵇⴻⴷⴷⴻⵎ ⵉⵊⵊ ⵏ ⵉⵣⵎⴰⵔ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵓⵎⴰⵔⵡⴰⵙ. ⵓⵙⵙⴰⵏ ⵉⵄⴷⵓⵏ ⴰⴷ ⵉⵍⵉⵏ ⵡⴹⴰⵏ ⵎⵉⵏⵣⵉ ⴰⵇⴰ ⵜᵉⵜⵜⵡⴰⵙⵙⴻⵅⵎⴻⵊ ⵜⵜⴰⵊ ⵏⵏⴻⵙ ⵏ ⵡⴻⵄⵣⴰⵍ.” ");
INSERT INTO rift_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“ⵡⴰ ⴷ ⴰⵣⴻⵔⴼ ⵏ ⵡⴻⵏⵏⵉ ⵢⴰⵔⴻⴱⴱⵓⵏ ⵜⵜⴰⵊ ⵏ ⵡⴻⵄⵣⴰⵍ: ⴷⴻⴳ ⵡⴰⵙⵙ ⵎⵉⵏ ⴷⵉ ⵜⵜⵡⴰⴽⴻⵎⵎⵍⴻⵏ ⵡⵓⵙⵙⴰⵏ ⵏ ⵜⵜⴰⵊ ⵏⵏⴻⵙ ⵏ ⵡⴻⵄⵣⴰⵍ, ⴰⴷ ⵜ ⴰⵡⵢⴻⵏ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","ⵅⴻⵏⵏⵉ ⴰⴷ ⴷⴷ-ⵉⵙⵙⵇⴰⵔⵔⴻⴱ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵖⴰⵔ ⵙⵉⴷⵉ, ⵉⵊⵊ ⵏ ⵉⵣⵎⴰⵔ ⵉⵛⵏⴰⵏ ⵇⴰⵄ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵅⵙⵉ ⵉⵛⵏⴰⵏ ⵇⴰⵄ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⴷ ⵉⵊⵊ ⵏ ⵉⵛⴰⵔⵔⵉ ⵉⵛⵏⴰⵏ ⵇⴰⵄ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⵍⴻⵀⵏⴰ ");
INSERT INTO rift_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","ⴷ ⵉⵛⵜ ⵏ ⵜⵙⵓⴵⴻⵜ ⴰⴽ-ⴷ ⵡⴻⵖⵔⵓⵎ ⴱⵍⴰ ⴰⵏⵜⵓⵏ ⴷ ⵍⴻⵎⵙⴻⵎⵏⴰⵜ ⵏ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵅⴻⴵⴹⴻⵏ ⵙ ⵣⵣⴻⵛⵜ ⴷ ⵜⴻⵍⴼⴰⴼ ⵏ ⵡⴻⵖⵔⵓⵎ ⴱⵍⴰ ⴰⵏⵜⵓⵏ ⵜⵜⵡⴰⴷⴻⵀⵏⴻⵏⵜ ⵙ ⵣⵣⴻⵛⵜ ⵓⵍⴰ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵏ ⵍⵖⵉⴵⴻⵜ ⴷ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵏⵏⴻⵙ ⵏ ⵓⵙⴻⵢⵢⴻⴱ.” ");
INSERT INTO rift_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵢⴰⵡⵉ ⵎⴰⵏ ⴰⵢⴰ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⵓⵛⴰ ⴰⴷ ⵉⵙⵙⴻⵡⵊⴻⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏⵏⴻⵙ ⵏ ⴷⴷⴻⵏⴱ ⴷ ⵜⵖⴰⵔⵚⵜ ⵏⵏⴻⵙ ⵏ ⵡⴻⵛⵎⴰⴹ. ");
INSERT INTO rift_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","ⴰⴷ ⵉⵙⵙⴻⵡⵊⴻⴷ ⵉⵛⴰⵔⵔⵉ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⵍⴻⵀⵏⴰ ⵉ ⵙⵉⴷⵉ ⵓⵍⴰ ⴷ ⵜⴰⵙⵓⴵⴻⵜ ⴰⴽ-ⴷ ⵜⴻⵛⵏⵉⴼⵉⵏ ⴱⵍⴰ ⴰⵏⵜⵓⵏ ⵓⵛⴰ ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵉⵙⵙⴻⵡⵊⴻⴷ ⵄⴰⵡⴻⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵏⵏⴻⵙ ⴷ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵏ ⵓⵙⴻⵢⵢⴻⴱ ⵏⵏⴻⵙ.” ");
INSERT INTO rift_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“ⵅⴻⵏⵏⵉ ⵡⴻⵏⵏⵉ ⵢⴰⵔⴻⴱⴱⵓⵏ ⵜⵜⴰⵊ ⵏ ⵡⴻⵄⵣⴰⵍ ⴰⴷ ⵉⵃⴻⴼⴼ ⴰⵣⴻⴵⵉⴼ ⵏ ⵜⵜⴰⵊ ⵏⵏⴻⵙ ⵏ ⵡⴻⵄⵣⴰⵍ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⵓⵛⴰ ⴰⴷ ⵉⴽⵙⵉ ⴰⵛⵓⵡⵡⴰⴼ ⵏ ⵓⵣⴻⴵⵉⴼ ⵏ ⵜⵜⴰⵊ ⵏⵏⴻⵙ ⵏ ⵡⴻⵄⵣⴰⵍ ⵓⵛⴰ ⴰⴷ ⵢⴻⴳⴳ ⴰⵢⴰ ⵅ ⵜⵎⴻⵙⵙⵉ ⵉ ⵉⴵⴰⵏ ⵙⴰⴷⵓ ⵜⵖⴰⵔⵚⵜ ⵏ ⵍⴻⵀⵏⴰ. ");
INSERT INTO rift_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⴽⵙⵉ ⵓⴽⴻⵀⵀⴰⵏ ⵜⴰⵎⴻⵚⵚⴰⴹⵜ ⵏ ⵣⵣⴰⵜ ⵢⴻⵏⴳⴳⵯⴰⵏ ⵏ ⵉⵛⴰⵔⵔⵉ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵎⵙⴻⵎⵎⴻⵏⵜ ⴱⵍⴰ ⴰⵏⵜⵓⵏ ⵣⵉ ⵜⵙⵓⴵⴻⵜ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵍⴼⴻⴼⵜ ⴱⵍⴰ ⴰⵏⵜⵓⵏ ⵓⵛⴰ ⴰⴷ ⵜⴻⵏⵜ ⵉⵙⵙⴰⵔⵙ ⵅ ⵉⴼⴰⵙⵙⴻⵏ ⵏ ⵡⴻⵏⵏⵉ ⵢⴰⵔⴻⴱⴱⵓⵏ ⵜⵜⴰⵊ ⵏ ⵡⴻⵄⵣⴰⵍ ⴰⵡⴰⵔⵏⵉ ⵎⴰ ⵉⵃⴻⴼⴼ ⵜⵜⴰⵊ ⵏⵏⴻⵙ ⵏ ⵡⴻⵄⵣⴰⵍ. ");
INSERT INTO rift_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵜⴻⵏⵜ ⵉⵙⵙⴻⵏⵀⴻⵣⵣ ⵣⵉ ⵙⵙⴰ ⵖⴰⵔ ⴷⴰ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ⴰⵇⴰ-ⵜⵜ ⴷ ⵉⵛⵜ ⵏ ⵜⵎⴻⵙⵍⴰⵛⵜ ⵜⴰⵎⵇⴻⴷⴷⴰⵙⵜ ⵉ ⵓⴽⴻⵀⵀⴰⵏ, ⴰⴽ-ⴷ ⵉⴷⵎⴰⵔⴻⵏ ⵏ ⵡⴻⵏⵀⴻⵣⵣⵉ ⵓ ⴰⴽ-ⴷ ⵓⵛⴻⴽⵔⵓⴷ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵉⵜⵜⵡⴰⵙⵙⴳⴻⵄⵄⴷⴻⵏ. ⴰⵡⴰⵔⵏⵉ ⴰⵢⴰ ⵉⵄⴻⴷⴷⴻⵍ ⵉ ⵡⴻⵏⵏⵉ ⵢⴰⵔⴻⴱⴱⵓⵏ ⵜⵜⴰⵊ ⵏ ⵡⴻⵄⵣⴰⵍ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⵙⵓ ⴱⵉⵏⵓ.” ");
INSERT INTO rift_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“ⵡⴰ ⴷ ⴰⵣⴻⵔⴼ ⵏ ⵡⴻⵏⵏⵉ ⵢⴰⵔⴻⴱⴱⵓⵏ ⵜⵜⴰⵊ ⵏ ⵡⴻⵄⵣⴰⵍ, ⵡⴻⵏⵏⵉ ⵜⵓⵖⴰ ⵉⵡⴰⵄⴷⴻⵏ ⵉ ⵙⵉⴷⵉ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⴷⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⵜⵜⴰⵊ ⵏ ⵡⴻⵄⵣⴰⵍ ⵏⵏⴻⵙ, ⴱⴰⵔⵔⴰ ⵎⵉⵏ ⵉⵣⴻⵎⵎⴰⵔ ⵓⴼⵓⵙ ⵏⵏⴻⵙ ⵄⴰⴷ ⴰⴷ ⵉⵙⵙⵉⵡⴻⴹ. ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⵙ ⴰⴷ ⵢⴻⴳⴳ ⵄⵍⴰⵃⵙⴰⴱ ⴰⵡⴰⵍ ⵉ ⵉⵡⵛⵉⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⴰⵣⴻⵔⴼ ⵏ ⵜⵜⴰⵊ ⵏ ⵡⴻⵄⵣⴰⵍ ⵏⵏⴻⵙ.” ");
INSERT INTO rift_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“ⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⵀⴰⵔⵓⵏ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⵏⵉ: ‘ⴰⵎⵎⵓ ⴰⴷ ⵜⴱⴰⵔⴽⴻⵎ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵛⴰ ⴰⴷ ⴰⵙⴻⵏ ⵜⵉⵏⵉⵎ: ");
INSERT INTO rift_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","ⵙⵉⴷⵉ ⴰⴷ ⴰⵛ ⵉⴱⴰⵔⴻⴽ ⵓⵛⴰ ⴰⴷ ⵛⴻⴽ ⵉⵃⴹⴰ! ");
INSERT INTO rift_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","ⵙⵉⴷⵉ ⴰⴷ ⵢⴰⵔⵔ ⵓⴷⴻⵎ ⵏⵏⴻⵙ ⴰⴷ ⵅⴰⴽ ⵢⴻⴳⴳ ⵜⴼⴰⵡⵜ ⵓⵛⴰ ⴰⴷ ⵅⴰⴽ ⵉⵃⵉⵏⵏ. ");
INSERT INTO rift_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","ⵙⵉⴷⵉ ⴰⴷ ⵖⴰⵔⴻⴽ ⴷⴷ-ⵉⵏⵏⴻⵇⵍⴻⴱ ⵓⴷⴻⵎ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⴰⵛ ⵉⵡⵛ ⵍⴻⵀⵏⴰ!’ ");
INSERT INTO rift_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","ⴰⴷ ⵙⵙⵉⵡⴹⴻⵏ ⵉⵙⴻⵎ ⵉⵏⵓ ⵅ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓ ⵏⴻⵛⵛ ⴰⴷ ⵜⴻⵏ ⴱⴰⵔⴽⴻⵖ.’” ");
INSERT INTO rift_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","ⵉⵎⵙⴰⵔ ⴷⴻⴳ ⵡⴰⵙⵙ ⵎⵉⵏ ⴷⵉ ⵉⴽⴻⵎⵎⴻⵍ ⵎⵓⵙⴰ ⴰⵙⴱⴻⴷⴷⵉ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ, ⵉⴷⵀⴻⵏ ⵓ ⵉⵙⵙⵇⴻⴷⴷⴻⵙ ⵉ-ⵜⵜ ⴰⴽ-ⴷ ⵍⴻⵇⵛⵓⵄ ⵏⵏⴻⵙ ⵓⵍⴰ ⴷ ⵎⴰⵔⵔⴰ ⴰⵄⴰⵍⵟⴰⵔ ⴰⴽ-ⴷ ⵍⴻⵇⵛⵓⵄ ⵏⵏⴻⵙ. ⴰⵇⴰ ⵉⴷⵀⴻⵏ ⵉ-ⵜⴻⵏ ⵓⵛⴰ ⵉⵙⵙⵇⴻⴷⴷⴻⵙ ⵉ-ⵜⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","ⵅⴻⵏⵏⵉ ⵇⴰⵔⵔⴱⴻⵏ-ⴷⴷ ⵍⵃⵓⴽⴽⴰⵎ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵉⵣⴻⴵⵉⴼⴻⵏ ⵏ ⵜⵓⴷⵔⵉⵏ ⵏ ⵍⴻⵊⴷⵓⴷ ⵏⵙⴻⵏ. ⵏⵉⵜⵏⵉ ⴷ ⵍⵃⵓⴽⴽⴰⵎ ⵏ ⵜⵇⴻⴱⴱⴰⵍ, ⵏⵉⵜⵏⵉ ⵜⵓⵖⴰ ⵅ ⵢⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","ⵏⵉⵜⵏⵉ ⵉⵡⵢⴻⵏ-ⴷⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵙⴻⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ: ⵙⴻⵜⵜⴰ ⵏ ⵉⴽⴰⵔⵔⵓⵜⴻⵏ ⴰⴽ-ⴷ ⵜⵙⴻⵇⵇⵉⴼⵜ ⴷ ⵜⴻⵏⵄⴰⵛ ⵏ ⵉⴼⵓⵏⴰⵙⴻⵏ, ⴰⵇⴰ ⴷ ⵉⵊⵊ ⵏ ⵓⴽⴰⵔⵔⵓ ⵉ ⵜⵏⴰⵢⴻⵏ ⵏ ⵍⵃⵓⴽⴽⴰⵎ ⴷ ⵉⵊⵊ ⵏ ⵓⴼⵓⵏⴰⵙ ⵉ ⴽⵓⵍ ⵉⵊⵊ ⵏ ⵍⵃⴰⴽⴻⵎ ⵓⵛⴰ ⵉⵡⵢⴻⵏ ⵜⴻⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ. ");
INSERT INTO rift_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“ⴽⵙⵉ ⴰⵢⴰ ⵣⵣⴰⵢⵙⴻⵏ, ⵃⵉⵎⴰ ⴰⴷ ⵉⵍⵉⵏ ⵉ ⵍⵅⴻⴷⵎⴻⵜ ⵏ ⵜⵙⴻⵅⵅⴰⵔⵜ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜⴻⵏ ⵜⴻⵡⵛⴻⴷ ⵉ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ, ⵉ ⴽⵓⵍ ⴰⵔⵢⴰⵣ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷⴷ-ⵉⵜⵜⴰⵙ ⴰⴽ-ⴷ ⵜⵙⴻⵅⵅⴰⵔⵜ ⵏⵏⴻⵙ.” ");
INSERT INTO rift_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","ⵓⵛⴰ ⵎⵓⵙⴰ ⵉⵟⵟⴻⴼ ⵉⴽⴰⵔⵔⵓⵜⴻⵏ ⴷ ⵉⴼⵓⵏⴰⵙⴻⵏ ⵓⵛⴰ ⵉⵡⵛⴰ ⵉ-ⵜⴻⵏ ⵉ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⴽⴰⵔⵔⵓⵜⴻⵏ ⴷ ⴰⵔⴻⴱⵄⴰ ⵏ ⵉⴼⵓⵏⴰⵙⴻⵏ ⵉ ⵉⵡⵛⴰ ⵉ ⴰⵢⵜ ⵏ ⵊⴰⵔⵛⵓⵏ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷⴷ-ⵉⵜⵜⴰⵙ ⴰⴽ-ⴷ ⵜⵙⴻⵅⵅⴰⵔⵜ ⵏⵙⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","ⵓ ⵉ ⴰⵢⵜ ⵏ ⵎⴰⵔⴰⵔⵉ ⵉⵡⵛⴰ ⴰⵙⴻⵏ ⴰⵔⴻⴱⵄⴰ ⵏ ⵉⴽⴰⵔⵔⵓⵜⴻⵏ ⴷ ⵜⵎⴻⵏⵢⴰ ⵏ ⵉⴼⵓⵏⴰⵙⴻⵏ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷⴷ-ⵉⵜⵜⴰⵙ ⴰⴽ-ⴷ ⵜⵙⴻⵅⵅⴰⵔⵜ ⵏⵙⴻⵏ ⵙⴰⴷⵓ ⵓⴼⵓⵙ ⵏ ⵉⵜⴰⵎⴰⵔ, ⵎⵎⵉⵙ ⵏ ⵓⴽⴻⵀⵀⴰⵏ ⵀⴰⵔⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","ⵉ ⴰⵢⵜ ⵏ ⵇⴰⵀⴰⵜ ⵡⴰⵔ ⴷ ⴰⵙⴻⵏ ⵉⵡⵛⵉ ⵡⴰⵍⵓ, ⵎⵉⵏⵣⵉ ⵜⵓⵖⴰ ⵅⴰⵙⴻⵏ ⵜⴰⵙⴻⵅⵅⴰⵔⵜ ⵏ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ, ⵏⵉⵜⵏⵉ ⴰⵔⴱⵓⵏ ⵣⵣⴰⵡⴻⵛⵜ ⵅ ⵜⵖⴰⵔⵡⴰⴹ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","ⵅⴻⵏⵏⵉ ⵇⴰⵔⵔⴱⴻⵏ-ⴷⴷ ⵍⵃⵓⴽⴽⴰⵎ ⴰⴽ-ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵉ ⵓⴷⴻⵛⵛⴻⵏ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ⴷⴻⴳ ⵡⴰⵙⵙ ⵎⵉⵏ ⴷⵉ ⵉⵜⵜⵡⴰⴷⵀⴻⵏ ⵓⵄⴰⵍⵟⴰⵔ. ⵉⵡⵢⴻⵏ ⵍⵃⵓⴽⴽⴰⵎ ⵜⵉⵡⵀⵉⴱⵉⵏ ⵏⵙⴻⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵓⵄⴰⵍⵟⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⵉⵊⵊ ⵏ ⵍⵃⴰⴽⴻⵎ ⴷⴻⴳ ⵉⵊⵊ ⵏ ⵡⴰⵙⵙ, ⵅⴻⵏⵏⵉ ⵄⴰⵡⴻⴷ ⵉⵊⵊ ⵏ ⵍⵃⴰⴽⴻⵎ ⴷⴻⴳ ⵡⴰⵙⵙ ⴰⵡⴰⵔⵏⵉ ⴰⵙ, ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵇⴻⴷⴷⵎⴻⵏ ⵏⵉⵜⵏⵉ ⵜⵉⵡⵀⵉⴱⵉⵏ ⵏⵙⴻⵏ ⵉ ⵓⴷⴻⵛⵛⴻⵏ ⵏ ⵓⵄⴰⵍⵟⴰⵔ.” ");
INSERT INTO rift_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","ⴷⴻⴳ ⵡⴰⵙⵙ ⴰⵎⴻⵣⵡⴰⵔⵓ ⵉⵇⴻⴷⴷⴻⵎ ⵏⴰⵃⵛⵓⵏ, ⵎⵎⵉⵙ ⵏ ⵄⴰⵎⵎⵉⵏⴰⴷⴰⴱ, ⵣⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⵢⴰⵀⵓⴷⴰ, ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","ⵜⵓⵖⴰ-ⵜⵜ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ: ⵉⵊⵊⴻⵏ ⵟⵟⴻⴱⵚⵉ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵏ ⵎⵢⴰ ⵓ-ⵜⵍⴰⵜⵉⵏ ⵛⵉⵇⵍⵓ ⵏ ⴷⴷⵇⴻⵍ, ⴷ ⵉⵛⵜⴻⵏ ⵟⵟⴰⵡⵢⴰ ⵉ ⵓⵔⵓⵛⵛⵉ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵏ ⵙⴻⴱⵄⵉⵏ ⵛⵉⵇⵍⵓ, ⵄⵍⴰⵃⵙⴰⴱ ⵛⵉⵇⵍⵓ ⵏ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ. ⵜⵓⵖⴰ-ⵜⴻⵏ ⵙ ⵜⵏⴰⵢⴻⵏ ⵛⵛⵓⵔⴻⵏ ⵙ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵅⴻⴵⴹⴻⵏ ⵙ ⵣⵣⴻⵛⵜ ⴰⵎ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","ⵅⴻⵏⵏⵉ ⵉⵛⵜ ⵏ ⵜⵖⴻⵏⵊⴰⵛⵜ ⵏ ⵡⵓⵔⴻⵖ ⵏ ⵄⴻⵛⵔⴰ ⵛⵉⵇⵍⵓ ⵜⴻⵛⵛⵓⵔ ⵙ ⵍⴻⴱⵅⵓⵔ, ");
INSERT INTO rift_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","ⵉⵊⵊ ⵏ ⵓⴼⵓⵏⴰⵙ - ⴰⵎⴻⵥⵢⴰⵏ ⵏ ⵜⴼⵓⵏⴰⵙⵜ - ⵉⵊⵊ ⵏ ⵉⵛⴰⵔⵔⵉ, ⵉⵊⵊ ⵏ ⵉⵣⵎⴰⵔ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ, ");
INSERT INTO rift_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","ⵉⵊⵊ ⵏ ⵓⵎⵢⴰⵏ ⵣⴻⴳ ⵉⵖⴰⵢⴹⴻⵏ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ");
INSERT INTO rift_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","ⵓ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵍⴻⵀⵏⴰ: ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⴼⵓⵏⴰⵙⴻⵏ ⴷ ⵅⴻⵎⵙⴰ ⵏ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ ⴷ ⵅⴻⵎⵙⴰ ⵏ ⵉⵖⴰⵢⴹⴻⵏ ⴷ ⵅⴻⵎⵙⴰ ⵏ ⵉⵣⵎⴰⵔⴻⵏ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ. ⴰⵇⴰ ⵜⴰ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵏⴰⵃⵛⵓⵏ, ⵎⵎⵉⵙ ⵏ ⵄⴰⵎⵎⵉⵏⴰⴷⴰⴱ. ");
INSERT INTO rift_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵜⵏⴰⵢⴻⵏ ⵉⵇⴻⴷⴷⴻⵎ ⵏⴰⵜⴰⵏⴰⵢⵉⵍ, ⵎⵎⵉⵙ ⵏ ⵚⵓⵖⴰⵔ, ⵡⴻⵏⵏⵉ ⴷ ⵍⵃⴰⴽⴻⵎ ⵏ ⵉⵙⵙⴰⴽⴰⵔ, ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","ⵜⵓⵖⴰ-ⵜⵜ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ: ⵉⵊⵊⴻⵏ ⵟⵟⴻⴱⵚⵉ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵏ ⵎⵢⴰ ⵓ-ⵜⵍⴰⵜⵉⵏ ⵛⵉⵇⵍⵓ ⵏ ⴷⴷⵇⴻⵍ, ⴷ ⵉⵛⵜⴻⵏ ⵟⵟⴰⵡⵢⴰ ⵉ ⵓⵔⵓⵛⵛⵉ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵏ ⵙⴻⴱⵄⵉⵏ ⵛⵉⵇⵍⵓ, ⵄⵍⴰⵃⵙⴰⴱ ⵛⵉⵇⵍⵓ ⵏ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ. ⵜⵓⵖⴰ-ⵜⴻⵏ ⵙ ⵜⵏⴰⵢⴻⵏ ⵛⵛⵓⵔⴻⵏ ⵙ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵅⴻⴵⴹⴻⵏ ⵙ ⵣⵣⴻⵛⵜ ⴰⵎ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","ⵅⴻⵏⵏⵉ ⵉⵛⵜ ⵏ ⵜⵖⴻⵏⵊⴰⵛⵜ ⵏ ⵡⵓⵔⴻⵖ ⵏ ⵄⴻⵛⵔⴰ ⵛⵉⵇⵍⵓ ⵜⴻⵛⵛⵓⵔ ⵙ ⵍⴻⴱⵅⵓⵔ, ");
INSERT INTO rift_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","ⵉⵊⵊ ⵏ ⵓⴼⵓⵏⴰⵙ - ⴰⵎⴻⵥⵢⴰⵏ ⵏ ⵜⴼⵓⵏⴰⵙⵜ - ⵉⵊⵊ ⵏ ⵉⵛⴰⵔⵔⵉ ⴷ ⵉⵊⵊ ⵏ ⵉⵣⵎⴰⵔ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ, ");
INSERT INTO rift_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","ⵉⵊⵊ ⵏ ⵓⵎⵢⴰⵏ ⵣⴻⴳ ⵉⵖⴰⵢⴹⴻⵏ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ");
INSERT INTO rift_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","ⵓ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵍⴻⵀⵏⴰ: ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⴼⵓⵏⴰⵙⴻⵏ, ⵅⴻⵎⵙⴰ ⵏ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ, ⵅⴻⵎⵙⴰ ⵏ ⵉⵖⴰⵢⴹⴻⵏ ⴷ ⵅⴻⵎⵙⴰ ⵏ ⵉⵣⵎⴰⵔⴻⵏ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ. ⴰⵇⴰ ⵜⴰ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵏⴰⵜⴰⵏⴰⵢⵉⵍ, ⵎⵎⵉⵙ ⵏ ⵚⵓⵖⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵜⵍⴰⵜⴰ ⵉⵇⴻⴷⴷⴻⵎ ⵍⵃⴰⴽⴻⵎ ⵏ ⴰⵢⵜ ⵏ ⵣⴰⴱⵓⵍⵓⵏ, ⵉⵍⵉⵢⴰⴱ, ⵎⵎⵉⵙ ⵏ ⵃⵉⵍⵓⵏ, ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","ⵜⵓⵖⴰ-ⵜⵜ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ: ⵉⵊⵊⴻⵏ ⵟⵟⴻⴱⵚⵉ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵏ ⵎⵢⴰ ⵓ-ⵜⵍⴰⵜⵉⵏ ⵛⵉⵇⵍⵓ ⵏ ⴷⴷⵇⴻⵍ, ⴷ ⵉⵛⵜⴻⵏ ⵟⵟⴰⵡⵢⴰ ⵉ ⵓⵔⵓⵛⵛⵉ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵏ ⵙⴻⴱⵄⵉⵏ ⵛⵉⵇⵍⵓ, ⵄⵍⴰⵃⵙⴰⴱ ⵛⵉⵇⵍⵓ ⵏ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ. ⵜⵓⵖⴰ-ⵜⴻⵏ ⵙ ⵜⵏⴰⵢⴻⵏ ⵛⵛⵓⵔⴻⵏ ⵙ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵅⴻⴵⴹⴻⵏ ⵙ ⵣⵣⴻⵛⵜ ⴰⵎ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","ⵅⴻⵏⵏⵉ ⵉⵛⵜ ⵏ ⵜⵖⴻⵏⵊⴰⵛⵜ ⵏ ⵡⵓⵔⴻⵖ ⵏ ⵄⴻⵛⵔⴰ ⵛⵉⵇⵍⵓ ⵜⴻⵛⵛⵓⵔ ⵙ ⵍⴻⴱⵅⵓⵔ, ");
INSERT INTO rift_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","ⵉⵊⵊ ⵏ ⵓⴼⵓⵏⴰⵙ - ⴰⵎⴻⵥⵢⴰⵏ ⵏ ⵜⴼⵓⵏⴰⵙⵜ - ⵉⵊⵊ ⵏ ⵉⵛⴰⵔⵔⵉ ⴷ ⵉⵊⵊ ⵏ ⵉⵣⵎⴰⵔ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ, ");
INSERT INTO rift_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","ⵉⵊⵊ ⵏ ⵓⵎⵢⴰⵏ ⵣⴻⴳ ⵉⵖⴰⵢⴹⴻⵏ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ");
INSERT INTO rift_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","ⵓ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵍⴻⵀⵏⴰ: ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⴼⵓⵏⴰⵙⴻⵏ, ⵅⴻⵎⵙⴰ ⵏ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ, ⵅⴻⵎⵙⴰ ⵏ ⵉⵖⴰⵢⴹⴻⵏ ⴷ ⵅⴻⵎⵙⴰ ⵏ ⵉⵣⵎⴰⵔⴻⵏ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ. ⴰⵇⴰ ⵜⴰ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵉⵍⵉⵢⴰⴱ, ⵎⵎⵉⵙ ⵏ ⵃⵉⵍⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⴰⵔⴻⴱⵄⴰ ⵉⵇⴻⴷⴷⴻⵎ ⵍⵃⴰⴽⴻⵎ ⵏ ⴰⵢⵜ ⵏ ⵔⵓⴱⵉⵏ, ⴰⵍⵉⵚⵓⵔ, ⵎⵎⵉⵙ ⵏ ⵛⴰⴷⴰⵢⵢⵓⵔ, ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","ⵜⵓⵖⴰ-ⵜⵜ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ: ⵉⵊⵊⴻⵏ ⵟⵟⴻⴱⵚⵉ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵏ ⵎⵢⴰ ⵓ-ⵜⵍⴰⵜⵉⵏ ⵛⵉⵇⵍⵓ ⵏ ⴷⴷⵇⴻⵍ, ⴷ ⵉⵛⵜⴻⵏ ⵟⵟⴰⵡⵢⴰ ⵉ ⵓⵔⵓⵛⵛⵉ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵏ ⵙⴻⴱⵄⵉⵏ ⵛⵉⵇⵍⵓ, ⵄⵍⴰⵃⵙⴰⴱ ⵛⵉⵇⵍⵓ ⵏ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ. ⵜⵓⵖⴰ-ⵜⴻⵏ ⵙ ⵜⵏⴰⵢⴻⵏ ⵛⵛⵓⵔⴻⵏ ⵙ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵅⴻⴵⴹⴻⵏ ⵙ ⵣⵣⴻⵛⵜ ⴰⵎ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","ⵅⴻⵏⵏⵉ ⵉⵛⵜ ⵏ ⵜⵖⴻⵏⵊⴰⵛⵜ ⵏ ⵡⵓⵔⴻⵖ ⵏ ⵄⴻⵛⵔⴰ ⵛⵉⵇⵍⵓ ⵜⴻⵛⵛⵓⵔ ⵙ ⵍⴻⴱⵅⵓⵔ, ");
INSERT INTO rift_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","ⵉⵊⵊ ⵏ ⵓⴼⵓⵏⴰⵙ - ⴰⵎⴻⵥⵢⴰⵏ ⵏ ⵜⴼⵓⵏⴰⵙⵜ - ⵉⵊⵊ ⵏ ⵉⵛⴰⵔⵔⵉ ⴷ ⵉⵊⵊ ⵏ ⵉⵣⵎⴰⵔ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ, ");
INSERT INTO rift_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","ⵉⵊⵊ ⵏ ⵓⵎⵢⴰⵏ ⵣⴻⴳ ⵉⵖⴰⵢⴹⴻⵏ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ");
INSERT INTO rift_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","ⵓ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵍⴻⵀⵏⴰ: ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⴼⵓⵏⴰⵙⴻⵏ, ⵅⴻⵎⵙⴰ ⵏ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ, ⵅⴻⵎⵙⴰ ⵏ ⵉⵖⴰⵢⴹⴻⵏ ⴷ ⵅⴻⵎⵙⴰ ⵏ ⵉⵣⵎⴰⵔⴻⵏ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ. ⴰⵇⴰ ⵜⴰ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⴰⵍⵉⵚⵓⵔ, ⵎⵎⵉⵙ ⵏ ⵛⴰⴷⴰⵢⵢⵓⵔ. ");
INSERT INTO rift_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵅⴻⵎⵙⴰ ⵉⵇⴻⴷⴷⴻⵎ ⵍⵃⴰⴽⴻⵎ ⵏ ⴰⵢⵜ ⵏ ⵛⵉⵎⵄⵓⵏ, ⵛⴰⵍⵓⵎⵉⵢⵉⵍ, ⵎⵎⵉⵙ ⵏ ⵚⵓⵔⵉⵛⴰⴷⴷⴰⵢ, ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","ⵜⵓⵖⴰ-ⵜⵜ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ: ⵉⵊⵊⴻⵏ ⵟⵟⴻⴱⵚⵉ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵏ ⵎⵢⴰ ⵓ-ⵜⵍⴰⵜⵉⵏ ⵛⵉⵇⵍⵓ ⵏ ⴷⴷⵇⴻⵍ, ⴷ ⵉⵛⵜⴻⵏ ⵟⵟⴰⵡⵢⴰ ⵉ ⵓⵔⵓⵛⵛⵉ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵏ ⵙⴻⴱⵄⵉⵏ ⵛⵉⵇⵍⵓ, ⵄⵍⴰⵃⵙⴰⴱ ⵛⵉⵇⵍⵓ ⵏ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ. ⵜⵓⵖⴰ-ⵜⴻⵏ ⵙ ⵜⵏⴰⵢⴻⵏ ⵛⵛⵓⵔⴻⵏ ⵙ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵅⴻⴵⴹⴻⵏ ⵙ ⵣⵣⴻⵛⵜ ⴰⵎ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","ⵅⴻⵏⵏⵉ ⵉⵛⵜ ⵏ ⵜⵖⴻⵏⵊⴰⵛⵜ ⵏ ⵡⵓⵔⴻⵖ ⵏ ⵄⴻⵛⵔⴰ ⵛⵉⵇⵍⵓ ⵜⴻⵛⵛⵓⵔ ⵙ ⵍⴻⴱⵅⵓⵔ, ");
INSERT INTO rift_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","ⵉⵊⵊ ⵏ ⵓⴼⵓⵏⴰⵙ - ⴰⵎⴻⵥⵢⴰⵏ ⵏ ⵜⴼⵓⵏⴰⵙⵜ - ⵉⵊⵊ ⵏ ⵉⵛⴰⵔⵔⵉ ⴷ ⵉⵊⵊ ⵏ ⵉⵣⵎⴰⵔ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ, ");
INSERT INTO rift_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","ⵉⵊⵊ ⵏ ⵓⵎⵢⴰⵏ ⵣⴻⴳ ⵉⵖⴰⵢⴹⴻⵏ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ");
INSERT INTO rift_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","ⵓ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵍⴻⵀⵏⴰ: ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⴼⵓⵏⴰⵙⴻⵏ, ⵅⴻⵎⵙⴰ ⵏ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ, ⵅⴻⵎⵙⴰ ⵏ ⵉⵖⴰⵢⴹⴻⵏ ⴷ ⵅⴻⵎⵙⴰ ⵏ ⵉⵣⵎⴰⵔⴻⵏ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ. ⴰⵇⴰ ⵜⴰ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵛⴰⵍⵓⵎⵉⵢⵉⵍ, ⵎⵎⵉⵙ ⵏ ⵚⵓⵔⵉⵛⴰⴷⴷⴰⵢ. ");
INSERT INTO rift_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⵜⵜⴰ ⵉⵇⴻⴷⴷⴻⵎ ⵍⵃⴰⴽⴻⵎ ⵏ ⴰⵢⵜ ⵏ ⵊⴰⴷ, ⴰⵍⵉⵢⴰⵙⴰⴼ, ⵎⵎⵉⵙ ⵏ ⴷⴰⵄⵓⵢⵉⵍ, ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","ⵜⵓⵖⴰ-ⵜⵜ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ: ⵉⵊⵊⴻⵏ ⵟⵟⴻⴱⵚⵉ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵏ ⵎⵢⴰ ⵓ-ⵜⵍⴰⵜⵉⵏ ⵛⵉⵇⵍⵓ ⵏ ⴷⴷⵇⴻⵍ, ⴷ ⵉⵛⵜⴻⵏ ⵟⵟⴰⵡⵢⴰ ⵉ ⵓⵔⵓⵛⵛⵉ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵏ ⵙⴻⴱⵄⵉⵏ ⵛⵉⵇⵍⵓ, ⵄⵍⴰⵃⵙⴰⴱ ⵛⵉⵇⵍⵓ ⵏ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ. ⵜⵓⵖⴰ-ⵜⴻⵏ ⵙ ⵜⵏⴰⵢⴻⵏ ⵛⵛⵓⵔⴻⵏ ⵙ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵅⴻⴵⴹⴻⵏ ⵙ ⵣⵣⴻⵛⵜ ⴰⵎ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","ⵅⴻⵏⵏⵉ ⵉⵛⵜ ⵏ ⵜⵖⴻⵏⵊⴰⵛⵜ ⵏ ⵡⵓⵔⴻⵖ ⵏ ⵄⴻⵛⵔⴰ ⵛⵉⵇⵍⵓ ⵜⴻⵛⵛⵓⵔ ⵙ ⵍⴻⴱⵅⵓⵔ, ");
INSERT INTO rift_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","ⵉⵊⵊ ⵏ ⵓⴼⵓⵏⴰⵙ - ⴰⵎⴻⵥⵢⴰⵏ ⵏ ⵜⴼⵓⵏⴰⵙⵜ - ⵉⵊⵊ ⵏ ⵉⵛⴰⵔⵔⵉ ⴷ ⵉⵊⵊ ⵏ ⵉⵣⵎⴰⵔ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ, ");
INSERT INTO rift_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","ⵉⵊⵊ ⵏ ⵓⵎⵢⴰⵏ ⵣⴻⴳ ⵉⵖⴰⵢⴹⴻⵏ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ");
INSERT INTO rift_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","ⵓ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵍⴻⵀⵏⴰ: ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⴼⵓⵏⴰⵙⴻⵏ, ⵅⴻⵎⵙⴰ ⵏ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ, ⵅⴻⵎⵙⴰ ⵏ ⵉⵖⴰⵢⴹⴻⵏ ⴷ ⵅⴻⵎⵙⴰ ⵏ ⵉⵣⵎⴰⵔⴻⵏ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ. ⴰⵇⴰ ⵜⴰ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⴰⵍⵉⵢⴰⵙⴰⴼ, ⵎⵎⵉⵙ ⵏ ⴷⴰⵄⵓⵢⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ ⵉⵇⴻⴷⴷⴻⵎ ⵍⵃⴰⴽⴻⵎ ⵏ ⴰⵢⵜ ⵏ ⵉⴼⵔⴰⵢⵉⵎ, ⵉⵍⵉⵛⴰⵎⴰⵄ, ⵎⵎⵉⵙ ⵏ ⵄⴰⵎⵎⵉⵀⵓⴷ, ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","ⵜⵓⵖⴰ-ⵜⵜ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ: ⵉⵊⵊⴻⵏ ⵟⵟⴻⴱⵚⵉ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵏ ⵎⵢⴰ ⵓ-ⵜⵍⴰⵜⵉⵏ ⵛⵉⵇⵍⵓ ⵏ ⴷⴷⵇⴻⵍ, ⴷ ⵉⵛⵜⴻⵏ ⵟⵟⴰⵡⵢⴰ ⵉ ⵓⵔⵓⵛⵛⵉ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵏ ⵙⴻⴱⵄⵉⵏ ⵛⵉⵇⵍⵓ, ⵄⵍⴰⵃⵙⴰⴱ ⵛⵉⵇⵍⵓ ⵏ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ. ⵜⵓⵖⴰ-ⵜⴻⵏ ⵙ ⵜⵏⴰⵢⴻⵏ ⵛⵛⵓⵔⴻⵏ ⵙ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵅⴻⴵⴹⴻⵏ ⵙ ⵣⵣⴻⵛⵜ ⴰⵎ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","ⵅⴻⵏⵏⵉ ⵉⵛⵜ ⵏ ⵜⵖⴻⵏⵊⴰⵛⵜ ⵏ ⵡⵓⵔⴻⵖ ⵏ ⵄⴻⵛⵔⴰ ⵛⵉⵇⵍⵓ ⵜⴻⵛⵛⵓⵔ ⵙ ⵍⴻⴱⵅⵓⵔ, ");
INSERT INTO rift_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","ⵉⵊⵊ ⵏ ⵓⴼⵓⵏⴰⵙ - ⴰⵎⴻⵥⵢⴰⵏ ⵏ ⵜⴼⵓⵏⴰⵙⵜ - ⵉⵊⵊ ⵏ ⵉⵛⴰⵔⵔⵉ ⴷ ⵉⵊⵊ ⵏ ⵉⵣⵎⴰⵔ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ, ");
INSERT INTO rift_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","ⵉⵊⵊ ⵏ ⵓⵎⵢⴰⵏ ⵣⴻⴳ ⵉⵖⴰⵢⴹⴻⵏ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ");
INSERT INTO rift_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","ⵓ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵍⴻⵀⵏⴰ: ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⴼⵓⵏⴰⵙⴻⵏ, ⵅⴻⵎⵙⴰ ⵏ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ, ⵅⴻⵎⵙⴰ ⵏ ⵉⵖⴰⵢⴹⴻⵏ ⴷ ⵅⴻⵎⵙⴰ ⵏ ⵉⵣⵎⴰⵔⴻⵏ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ. ⴰⵇⴰ ⵜⴰ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵉⵍⵉⵛⴰⵎⴰⵄ, ⵎⵎⵉⵙ ⵏ ⵄⴰⵎⵎⵉⵀⵓⴷ. ");
INSERT INTO rift_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵜⵎⴻⵏⵢⴰ ⵉⵇⴻⴷⴷⴻⵎ ⵍⵃⴰⴽⴻⵎ ⵏ ⴰⵢⵜ ⵏ ⵎⴰⵏⴰⵙⵙⴰ, ⵊⴰⵎⴰⵍⵉⵢⵉⵍ, ⵎⵎⵉⵙ ⵏ ⴼⴰⴷⴰⵀⵚⵓⵔ, ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","ⵜⵓⵖⴰ-ⵜⵜ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ: ⵉⵊⵊⴻⵏ ⵟⵟⴻⴱⵚⵉ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵏ ⵎⵢⴰ ⵓ-ⵜⵍⴰⵜⵉⵏ ⵛⵉⵇⵍⵓ ⵏ ⴷⴷⵇⴻⵍ, ⴷ ⵉⵛⵜⴻⵏ ⵟⵟⴰⵡⵢⴰ ⵉ ⵓⵔⵓⵛⵛⵉ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵏ ⵙⴻⴱⵄⵉⵏ ⵛⵉⵇⵍⵓ, ⵄⵍⴰⵃⵙⴰⴱ ⵛⵉⵇⵍⵓ ⵏ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ. ⵜⵓⵖⴰ-ⵜⴻⵏ ⵙ ⵜⵏⴰⵢⴻⵏ ⵛⵛⵓⵔⴻⵏ ⵙ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵅⴻⴵⴹⴻⵏ ⵙ ⵣⵣⴻⵛⵜ ⴰⵎ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","ⵅⴻⵏⵏⵉ ⵉⵛⵜ ⵏ ⵜⵖⴻⵏⵊⴰⵛⵜ ⵏ ⵡⵓⵔⴻⵖ ⵏ ⵄⴻⵛⵔⴰ ⵛⵉⵇⵍⵓ ⵜⴻⵛⵛⵓⵔ ⵙ ⵍⴻⴱⵅⵓⵔ, ");
INSERT INTO rift_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","ⵉⵊⵊ ⵏ ⵓⴼⵓⵏⴰⵙ - ⴰⵎⴻⵥⵢⴰⵏ ⵏ ⵜⴼⵓⵏⴰⵙⵜ - ⵉⵊⵊ ⵏ ⵉⵛⴰⵔⵔⵉ ⴷ ⵉⵊⵊ ⵏ ⵉⵣⵎⴰⵔ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ, ");
INSERT INTO rift_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","ⵉⵊⵊ ⵏ ⵓⵎⵢⴰⵏ ⵣⴻⴳ ⵉⵖⴰⵢⴹⴻⵏ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ");
INSERT INTO rift_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","ⵓ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵍⴻⵀⵏⴰ: ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⴼⵓⵏⴰⵙⴻⵏ, ⵅⴻⵎⵙⴰ ⵏ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ, ⵅⴻⵎⵙⴰ ⵏ ⵉⵖⴰⵢⴹⴻⵏ ⴷ ⵅⴻⵎⵙⴰ ⵏ ⵉⵣⵎⴰⵔⴻⵏ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ. ⴰⵇⴰ ⵜⴰ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵊⴰⵎⴰⵍⵉⵢⵉⵍ, ⵎⵎⵉⵙ ⵏ ⴼⴰⴷⴰⵀⵚⵓⵔ. ");
INSERT INTO rift_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵜⴻⵙⵄⴰ ⵉⵇⴻⴷⴷⴻⵎ ⵍⵃⴰⴽⴻⵎ ⵏ ⴰⵢⵜ ⵏ ⴱⵉⵏⵢⴰⵎⵉⵏ, ⴰⴱⵉⴷⴰⵏ, ⵎⵎⵉⵙ ⵏ ⵊⵉⴷⵄⵓⵏⵉ, ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","ⵜⵓⵖⴰ-ⵜⵜ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ: ⵉⵊⵊⴻⵏ ⵟⵟⴻⴱⵚⵉ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵏ ⵎⵢⴰ ⵓ-ⵜⵍⴰⵜⵉⵏ ⵛⵉⵇⵍⵓ ⵏ ⴷⴷⵇⴻⵍ, ⴷ ⵉⵛⵜⴻⵏ ⵟⵟⴰⵡⵢⴰ ⵉ ⵓⵔⵓⵛⵛⵉ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵏ ⵙⴻⴱⵄⵉⵏ ⵛⵉⵇⵍⵓ, ⵄⵍⴰⵃⵙⴰⴱ ⵛⵉⵇⵍⵓ ⵏ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ. ⵜⵓⵖⴰ-ⵜⴻⵏ ⵙ ⵜⵏⴰⵢⴻⵏ ⵛⵛⵓⵔⴻⵏ ⵙ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵅⴻⴵⴹⴻⵏ ⵙ ⵣⵣⴻⵛⵜ ⴰⵎ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","ⵅⴻⵏⵏⵉ ⵉⵛⵜ ⵏ ⵜⵖⴻⵏⵊⴰⵛⵜ ⵏ ⵡⵓⵔⴻⵖ ⵏ ⵄⴻⵛⵔⴰ ⵛⵉⵇⵍⵓ ⵜⴻⵛⵛⵓⵔ ⵙ ⵍⴻⴱⵅⵓⵔ, ");
INSERT INTO rift_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","ⵉⵊⵊ ⵏ ⵓⴼⵓⵏⴰⵙ - ⴰⵎⴻⵥⵢⴰⵏ ⵏ ⵜⴼⵓⵏⴰⵙⵜ - ⵉⵊⵊ ⵏ ⵉⵛⴰⵔⵔⵉ ⴷ ⵉⵊⵊ ⵏ ⵉⵣⵎⴰⵔ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ, ");
INSERT INTO rift_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","ⵉⵊⵊ ⵏ ⵓⵎⵢⴰⵏ ⵣⴻⴳ ⵉⵖⴰⵢⴹⴻⵏ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ");
INSERT INTO rift_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","ⵓ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵍⴻⵀⵏⴰ: ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⴼⵓⵏⴰⵙⴻⵏ, ⵅⴻⵎⵙⴰ ⵏ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ, ⵅⴻⵎⵙⴰ ⵏ ⵉⵖⴰⵢⴹⴻⵏ ⴷ ⵅⴻⵎⵙⴰ ⵏ ⵉⵣⵎⴰⵔⴻⵏ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ. ⴰⵇⴰ ⵜⴰ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⴰⴱⵉⴷⴰⵏ, ⵎⵎⵉⵙ ⵏ ⵊⵉⴷⵄⵓⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵄⴻⵛⵔⴰ ⵉⵇⴻⴷⴷⴻⵎ ⵍⵃⴰⴽⴻⵎ ⵏ ⴰⵢⵜ ⵏ ⴷⴰⵏ, ⴰⵅⵉⵄⴰⵣⴰⵔ, ⵎⵎⵉⵙ ⵏ ⵄⴰⵎⵉⵛⴰⴷⴷⴰⵢ, ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","ⵜⵓⵖⴰ-ⵜⵜ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ: ⵉⵊⵊⴻⵏ ⵟⵟⴻⴱⵚⵉ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵏ ⵎⵢⴰ ⵓ-ⵜⵍⴰⵜⵉⵏ ⵛⵉⵇⵍⵓ ⵏ ⴷⴷⵇⴻⵍ, ⴷ ⵉⵛⵜⴻⵏ ⵟⵟⴰⵡⵢⴰ ⵉ ⵓⵔⵓⵛⵛⵉ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵏ ⵙⴻⴱⵄⵉⵏ ⵛⵉⵇⵍⵓ, ⵄⵍⴰⵃⵙⴰⴱ ⵛⵉⵇⵍⵓ ⵏ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ. ⵜⵓⵖⴰ-ⵜⴻⵏ ⵙ ⵜⵏⴰⵢⴻⵏ ⵛⵛⵓⵔⴻⵏ ⵙ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵅⴻⴵⴹⴻⵏ ⵙ ⵣⵣⴻⵛⵜ ⴰⵎ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","ⵅⴻⵏⵏⵉ ⵉⵛⵜ ⵏ ⵜⵖⴻⵏⵊⴰⵛⵜ ⵏ ⵡⵓⵔⴻⵖ ⵏ ⵄⴻⵛⵔⴰ ⵛⵉⵇⵍⵓ ⵜⴻⵛⵛⵓⵔ ⵙ ⵍⴻⴱⵅⵓⵔ, ");
INSERT INTO rift_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","ⵉⵊⵊ ⵏ ⵓⴼⵓⵏⴰⵙ - ⴰⵎⴻⵥⵢⴰⵏ ⵏ ⵜⴼⵓⵏⴰⵙⵜ - ⵉⵊⵊ ⵏ ⵉⵛⴰⵔⵔⵉ ⴷ ⵉⵊⵊ ⵏ ⵉⵣⵎⴰⵔ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ, ");
INSERT INTO rift_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","ⵉⵊⵊ ⵏ ⵓⵎⵢⴰⵏ ⵣⴻⴳ ⵉⵖⴰⵢⴹⴻⵏ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ");
INSERT INTO rift_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","ⵓ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵍⴻⵀⵏⴰ: ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⴼⵓⵏⴰⵙⴻⵏ, ⵅⴻⵎⵙⴰ ⵏ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ, ⵅⴻⵎⵙⴰ ⵏ ⵉⵖⴰⵢⴹⴻⵏ ⴷ ⵅⴻⵎⵙⴰ ⵏ ⵉⵣⵎⴰⵔⴻⵏ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ. ⴰⵇⴰ ⵜⴰ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⴰⵅⵉⵄⴰⵣⴰⵔ, ⵎⵎⵉⵙ ⵏ ⵄⴰⵎⵉⵛⴰⴷⴷⴰⵢ. ");
INSERT INTO rift_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵃⵉⵟⴰⵛ ⵉⵇⴻⴷⴷⴻⵎ ⵍⵃⴰⴽⴻⵎ ⵏ ⴰⵢⵜ ⵏ ⴰⵛⵉⵔ, ⴼⴰⵊⵄⵉⵢⵉⵍ, ⵎⵎⵉⵙ ⵏ ⵄⵓⴽⵔⴰⵏ, ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","ⵜⵓⵖⴰ-ⵜⵜ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ: ⵉⵊⵊⴻⵏ ⵟⵟⴻⴱⵚⵉ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵏ ⵎⵢⴰ ⵓ-ⵜⵍⴰⵜⵉⵏ ⵛⵉⵇⵍⵓ ⵏ ⴷⴷⵇⴻⵍ, ⴷ ⵉⵛⵜⴻⵏ ⵟⵟⴰⵡⵢⴰ ⵉ ⵓⵔⵓⵛⵛⵉ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵏ ⵙⴻⴱⵄⵉⵏ ⵛⵉⵇⵍⵓ, ⵄⵍⴰⵃⵙⴰⴱ ⵛⵉⵇⵍⵓ ⵏ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ. ⵜⵓⵖⴰ-ⵜⴻⵏ ⵙ ⵜⵏⴰⵢⴻⵏ ⵛⵛⵓⵔⴻⵏ ⵙ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵅⴻⴵⴹⴻⵏ ⵙ ⵣⵣⴻⵛⵜ ⴰⵎ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","ⵅⴻⵏⵏⵉ ⵉⵛⵜ ⵏ ⵜⵖⴻⵏⵊⴰⵛⵜ ⵏ ⵡⵓⵔⴻⵖ ⵏ ⵄⴻⵛⵔⴰ ⵛⵉⵇⵍⵓ ⵜⴻⵛⵛⵓⵔ ⵙ ⵍⴻⴱⵅⵓⵔ, ");
INSERT INTO rift_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","ⵉⵊⵊ ⵏ ⵓⴼⵓⵏⴰⵙ - ⴰⵎⴻⵥⵢⴰⵏ ⵏ ⵜⴼⵓⵏⴰⵙⵜ - ⵉⵊⵊ ⵏ ⵉⵛⴰⵔⵔⵉ ⴷ ⵉⵊⵊ ⵏ ⵉⵣⵎⴰⵔ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ, ");
INSERT INTO rift_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","ⵉⵊⵊ ⵏ ⵓⵎⵢⴰⵏ ⵣⴻⴳ ⵉⵖⴰⵢⴹⴻⵏ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ");
INSERT INTO rift_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","ⵓ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵍⴻⵀⵏⴰ: ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⴼⵓⵏⴰⵙⴻⵏ, ⵅⴻⵎⵙⴰ ⵏ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ, ⵅⴻⵎⵙⴰ ⵏ ⵉⵖⴰⵢⴹⴻⵏ ⴷ ⵅⴻⵎⵙⴰ ⵏ ⵉⵣⵎⴰⵔⴻⵏ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ. ⴰⵇⴰ ⵜⴰ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⴼⴰⵊⵄⵉⵢⵉⵍ, ⵎⵎⵉⵙ ⵏ ⵄⵓⴽⵔⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵜⴻⵏⵄⴰⵛ ⵉⵇⴻⴷⴷⴻⵎ ⵍⵃⴰⴽⴻⵎ ⵏ ⴰⵢⵜ ⵏ ⵏⴰⴼⵜⴰⵍⵉ, ⴰⵅⵉⵔⴰⵄ, ⵎⵎⵉⵙ ⵏ ⵄⵉⵢⵏⴰⵏ, ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","ⵜⵓⵖⴰ-ⵜⵜ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ: ⵉⵊⵊⴻⵏ ⵟⵟⴻⴱⵚⵉ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵏ ⵎⵢⴰ ⵓ-ⵜⵍⴰⵜⵉⵏ ⵛⵉⵇⵍⵓ ⵏ ⴷⴷⵇⴻⵍ, ⴷ ⵉⵛⵜⴻⵏ ⵟⵟⴰⵡⵢⴰ ⵉ ⵓⵔⵓⵛⵛⵉ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵏ ⵙⴻⴱⵄⵉⵏ ⵛⵉⵇⵍⵓ, ⵄⵍⴰⵃⵙⴰⴱ ⵛⵉⵇⵍⵓ ⵏ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ. ⵜⵓⵖⴰ-ⵜⴻⵏ ⵙ ⵜⵏⴰⵢⴻⵏ ⵛⵛⵓⵔⴻⵏ ⵙ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵅⴻⴵⴹⴻⵏ ⵙ ⵣⵣⴻⵛⵜ ⴰⵎ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","ⵅⴻⵏⵏⵉ ⵉⵛⵜ ⵏ ⵜⵖⴻⵏⵊⴰⵛⵜ ⵏ ⵡⵓⵔⴻⵖ ⵏ ⵄⴻⵛⵔⴰ ⵛⵉⵇⵍⵓ ⵜⴻⵛⵛⵓⵔ ⵙ ⵍⴻⴱⵅⵓⵔ, ");
INSERT INTO rift_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","ⵉⵊⵊ ⵏ ⵓⴼⵓⵏⴰⵙ - ⴰⵎⴻⵥⵢⴰⵏ ⵏ ⵜⴼⵓⵏⴰⵙⵜ - ⵉⵊⵊ ⵏ ⵉⵛⴰⵔⵔⵉ ⴷ ⵉⵊⵊ ⵏ ⵉⵣⵎⴰⵔ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ, ");
INSERT INTO rift_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","ⵉⵊⵊ ⵏ ⵓⵎⵢⴰⵏ ⵣⴻⴳ ⵉⵖⴰⵢⴹⴻⵏ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ");
INSERT INTO rift_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","ⵓ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵍⴻⵀⵏⴰ: ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⴼⵓⵏⴰⵙⴻⵏ, ⵅⴻⵎⵙⴰ ⵏ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ, ⵅⴻⵎⵙⴰ ⵏ ⵉⵖⴰⵢⴹⴻⵏ ⴷ ⵅⴻⵎⵙⴰ ⵏ ⵉⵣⵎⴰⵔⴻⵏ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ. ⴰⵇⴰ ⵜⴰ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⴰⵅⵉⵔⴰⵄ, ⵎⵎⵉⵙ ⵏ ⵄⵉⵢⵏⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","ⵜⵓⵖⴰ ⵜⴰ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵉ ⵓⴷⴻⵛⵛⴻⵏ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ⵣⵉ ⵍⵃⵓⴽⴽⴰⵎ ⵏ ⵉⵙⵔⴰⵉⵍ ⴷⴻⴳ ⵡⴰⵙⵙ ⵏⵏⵉ ⴷⵉ ⵉⵜⵜⵡⴰⴷⵀⴻⵏ ⵓⵄⴰⵍⵟⴰⵔ: ⵜⴻⵏⵄⴰⵛ ⵏ ⵟⵟⴱⴰⵚⵉ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⴷ ⵜⴻⵏⵄⴰⵛ ⵏ ⵟⵟⴰⵡⵢⴰⵜ ⵉ ⵓⵔⵓⵛⵛⵉ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⴷ ⵜⴻⵏⵄⴰⵛ ⵏ ⵜⵖⴻⵏⵊⴰⵢⵉⵏ ⵏ ⵡⵓⵔⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","ⵉⵊⵊⴻⵏ ⵟⵟⴻⴱⵚⵉ ⵏ ⵏⵏⵓⵇⴰⵔⵜ ⵉⵡⵣⴻⵏ ⵎⵢⴰ ⵓ-ⵜⵍⴰⵜⵉⵏ ⵛⵉⵇⵍⵓ ⴷ ⵉⵛⵜⴻⵏ ⵟⵟⴰⵡⵢⴰ ⵉ ⵓⵔⵓⵛⵛⵉ ⵉⵡⵣⴻⵏ ⵙⴻⴱⵄⵉⵏ ⵛⵉⵇⵍⵓ. ⵎⴰⵔⵔⴰ ⵏⵏⵓⵇⴰⵔⵜ ⵏ ⵍⴻⵇⵛⵓⵄ ⵏⵏⵉ ⵜⴻⵡⵣⴻⵏ ⴰⵍⴼⴰⵢⴻⵏ ⵓ-ⴰⵔⴻⴱⵄⴰ-ⵎⵢⴰ ⵛⵉⵇⵍⵓ ⵄⵍⴰⵃⵙⴰⴱ ⵛⵉⵇⵍⵓ ⵏ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","ⵜⴻⵏⵄⴰⵛ ⵏ ⵜⵖⴻⵏⵊⴰⵢⵉⵏ ⵏ ⵡⵓⵔⴻⵖ ⵛⵛⵓⵔⴻⵏⵜ ⵙ ⵍⴻⴱⵅⵓⵔ. ⴽⵓⵍ ⵜⴰⵖⴻⵏⵊⴰⵢⵜ ⵜⴻⵡⵣⴻⵏ ⵄⴻⵛⵔⴰ ⵛⵉⵇⵍⵓ, ⵄⵍⴰⵃⵙⴰⴱ ⵛⵉⵇⵍⵓ ⵏ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ. ⵎⴰⵔⵔⴰ ⵓⵔⴻⵖ ⵏ ⵜⵖⴻⵏⵊⴰⵢⵉⵏ ⵉⵡⵣⴻⵏ ⵎⵢⴰ ⵓ-ⵄⵉⵛⵔⵉⵏ ⵛⵉⵇⵍⵓ. ");
INSERT INTO rift_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","ⵎⴰⵔⵔⴰ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⴰⵇⴰ ⴷⴰⵢⵙⴻⵏⵜ ⵜⴻⵏⵄⴰⵛ ⵏ ⵉⴼⵓⵏⴰⵙⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⴻⵏ, ⵜⴻⵏⵄⴰⵛ ⵏ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ, ⵜⴻⵏⵄⴰⵛ ⵏ ⵉⵣⵎⴰⵔⴻⵏ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ ⴰⴽ-ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵏⵙⴻⵏ, ⵓ ⵜⴻⵏⵄⴰⵛ ⵉⵎⵢⴰⵏⴻⵏ ⵣⴻⴳ ⵉⵖⴰⵢⴹⴻⵏ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ. ");
INSERT INTO rift_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","ⵎⴰⵔⵔⴰ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵍⴻⵀⵏⴰ ⴰⵇⴰ ⴷⴰⵢⵙⴻⵏⵜ ⴰⵔⴻⴱⵄⴰ ⵓ-ⵄⵉⵛⵔⵉⵏ ⵏ ⵉⴼⵓⵏⴰⵙⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⴻⵏ, ⵙⴻⵜⵜⵉⵏ ⵏ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ ⴷ ⵙⴻⵜⵜⵉⵏ ⵏ ⵉⵖⴰⵢⴹⴻⵏ ⴷ ⵙⴻⵜⵜⵉⵏ ⵏ ⵉⵣⵎⴰⵔⴻⵏ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ. ⵎⴰⵏ ⴰⵢⴰ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵉ ⵓⴷⴻⵛⵛⴻⵏ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ⴰⵡⴰⵔⵏⵉ ⵉⵜⵜⵡⴰⴷⵀⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","ⵓⵎⵉ ⵢⵓⴷⴻⴼ ⵎⵓⵙⴰ ⵖⴰⵔ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ⵃⵉⵎⴰ ⴰⴷ ⴽⵉⴷⴻⵙ ⵉⵙⵙⵉⵡⴻⵍ, ⵉⵙⵍⴰ ⵜⵎⵉⵊⵊⴰ ⵜⴻⵙⵙⵉⵡⴻⵍ ⴰⴽⵉⴷⴻⵙ ⵣⵉ ⵙⴻⵏⵏⴻⵊ ⵏ ⵜⵇⴻⴱⴱⴰⵔⵜ ⵏ ⵡⴻⵚⵍⴰⵃ ⵉ ⵉⴵⴰⵏ ⵅ ⵜⵜⴰⴱⵓⵜ ⵏ ⵛⵛⵀⴰⴷⴻⵜ, ⵣⵉ ⵊⴰⵔ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⴽⵉⵔⵓⴱⴻⵏ. ⴰⵎⵎⵓ ⵉ ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽⵉⴷⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“ⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⵀⴰⵔⵓⵏ, ⵉⵏⵉ ⴰⵙ: ‘ⵅⵎⵉ ⵖⴰ ⵜⴻⵙⵙⴰⵔⵙⴻⴷ ⵜⵉⴼⴰⵡⵉⵏ ⵅ ⵍⵇⴻⵏⴷⵉⵍ, ⵉⵜⵜⵅⴻⵚⵚⴰ ⵙⴻⴱⵄⴰ ⵏ ⵜⴼⴰⵡⵉⵏ ⴰⴷ ⵡⵛⴻⵏⵜ ⵜⴰⴼⴰⵡⵜ ⵖⴰⵔ ⵣⵣⴰⵜ ⵏ ⵍⵇⴻⵏⴷⵉⵍ.’” ");
INSERT INTO rift_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⵉⴳⴳⴰ ⵀⴰⵔⵓⵏ. ⵉⵙⵙⴰⵔⵙ ⵜⵉⴼⴰⵡⵉⵏ ⵏⵏⴻⵙ ⵖⴰⵔ ⵣⵣⴰⵜ ⵏ ⵍⵇⴻⵏⴷⵉⵍ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵙ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","ⵜⵓⵖⴰ ⵍⵇⴻⵏⴷⵉⵍ ⴷ ⵉⵛⵜ ⵏ ⵚⵚⴻⵏⵄⴻⵜ ⵏ ⵡⵓⵔⴻⵖ ⵢⴻⵄⴷⴻⵍ ⵙ ⵡⴻⴼⴹⵉⵙ. ⵣⴻⴳ ⵓⴼⵓⴹ ⵅ ⵓⴹⴰⵔ ⵏⵏⴻⵙ ⴰⵍ ⵏⵏⵓⵡⵡⴰⵔⴰⵜ ⵏⵏⴻⵙ ⵜⵓⵖⴰ ⵉⵜⵜⵡⴰⴳⴳ ⵙ ⵡⴻⴼⴹⵉⵙ. ⵄⵍⴰⵃⵙⴰⴱ ⴰⵎⴻⴷⵢⴰ ⵉ ⴷ ⴰⵙ ⵉⵙⵛⵛⴻⵏ ⵙⵉⴷⵉ, ⴰⵎⵎⵓ ⵉ ⵉⵚⴻⵏⵏⴻⵄ ⵍⵇⴻⵏⴷⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“ⴽⵙⵉ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⵣⵉ ⵊⴰⵔ ⵍⵡⴻⵙⵟ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵛⴰ ⵙⵉⵣⴷⴻⴳ ⵉ-ⵜⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","ⴰⵎⵎⵓ ⵉ ⴷ ⴰⵙⴻⵏ ⵖⴰ ⵜⴻⴳⴳⴻⴷ ⵃⵉⵎⴰ ⴰⴷ ⵜⴻⵏ ⵜⴻⵙⵙⵉⵣⴻⴷⴳⴻⴷ: ⵔⵓⵛⵛ ⵉ-ⵜⴻⵏ ⵙ ⵡⴰⵎⴰⵏ ⵏ ⵓⵙⵉⵣⴷⴻⴳ. ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⵙⴻⵏ ⴰⴷ ⵃⴻⴼⴼⴻⵏ ⵎⴰⵔⵔⴰ ⴰⵔⵔⵉⵎⴻⵜ ⵏⵙⴻⵏ ⵓⵛⴰ ⴰⴷ ⵙⵙⵉⵔⴷⴻⵏ ⴰⵔⵔⵓⴹ ⵏⵙⴻⵏ ⵓⵛⴰ ⴰⴷ ⵙⵙⵉⵣⴷⴻⴳⴻⵏ ⵉⵅⴻⴼ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","ⵅⴻⵏⵏⵉ ⴰⴷ ⴽⵙⵉⵏ ⵉⵊⵊ ⵏ ⵓⴼⵓⵏⴰⵙ, ⴰⵎⴻⵥⵢⴰⵏ ⵏ ⵜⴼⵓⵏⴰⵙⵜ, ⴰⴽ-ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵏⵏⴻⵙ ⵏ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵅⴻⴵⴹⴻⵏ ⵙ ⵣⵣⴻⵛⵜ ⵓ ⵄⴰⵡⴻⴷ ⵉⵊⵊ ⵏ ⵓⴼⵓⵏⴰⵙ ⵡⵉⵙⵙ ⵜⵏⴰⵢⴻⵏ, ⴰⵎⴻⵥⵢⴰⵏ ⵏ ⵜⴼⵓⵏⴰⵙⵜ, ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ. ");
INSERT INTO rift_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","ⴰⴷ ⵜⴰⵡⵢⴻⴷ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⵣⵣⴰⵜ ⵉ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⵓⵛⴰ ⴰⴷ ⵜⴻⵙⵙⵎⵓⵏⴻⴷ ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","ⴰⴷ ⴷⴷ-ⵜⴻⵙⵙⵇⴰⵔⵔⴱⴻⴷ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⵓⵛⴰ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴰⴷ ⵙⵙⴰⵔⵙⴻⵏ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵙⴻⵏ ⵅ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","ⴰⴷ ⵢⴻⵊⵊ ⵀⴰⵔⵓⵏ ⴰⴷ ⵀⴻⵣⵣⴻⵏ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⵣⵉ ⵙⵙⴰ ⵖⴰⵔ ⴷⴰ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⴰⵎ ⵢⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵡⴻⵏⵀⴻⵣⵣⵉ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ⵏⵉⵜⵏⵉ ⴰⴷ ⴷⴻⵡⵍⴻⵏ ⵜⵜⵙⴻⵅⵅⴰⵔⴻⵏ ⴷⵉ ⵜⵙⴻⵅⵅⴰⵔⵜ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⴰⴷ ⵙⵙⴰⵔⵙⴻⵏ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵙⴻⵏ ⵅ ⵉⵣⴻⴵⵉⴼⴻⵏ ⵏ ⵉⴼⵓⵏⴰⵙⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⴻⵏ ⵓⵛⴰ ⴰⴷ ⵜⴻⵙⵙⵡⴻⵊⴷⴻⴷ ⵉⵊⵊ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⴷ ⵢⵉⵊⵊ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵉ ⵙⵉⴷⵉ, ⵃⵉⵎⴰ ⴰⴷ ⵣⵣⴰⵢⵙⴻⵏ ⵉⵜⵜⵡⴰⴳⴳ ⵡⴻⵚⵍⴰⵃ ⵉ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⴰⴷ ⴱⴻⴷⴷⴻⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵀⴰⵔⵓⵏ ⵓ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⵜⴻⵏ ⵜⴰⵔⵔⴻⴷ ⴰⴷ ⵀⴻⵣⵣⴻⵏ ⵣⵉ ⵙⵙⴰ ⵖⴰⵔ ⴷⴰ ⴰⵎ ⵢⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵡⴻⵏⵀⴻⵣⵣⵉ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵜⵃⵓⵣⵣⴻⴷ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⵣⵉ ⵍⵡⴻⵙⵟ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵃⵉⵎⴰ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⴰⴷ ⵉⵍⵉⵏ ⵉⵏⵓ. ");
INSERT INTO rift_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","ⴰⵡⴰⵔⵏⵉ ⵎⴰⵏ ⴰⵢⴰ ⴰⴷ ⴷⴷ-ⴰⵙⴻⵏ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⵃⵉⵎⴰ ⴰⴷ ⵙⴻⵅⵅⴰⵔⴻⵏ ⴷⴻⴳ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ⴰⴷ ⵜⴻⵏ ⵜⴻⵙⵙⵉⵣⴻⴷⴳⴻⴷ ⵓⵛⴰ ⴰⴷ ⵜⴻⵏ ⵜⴰⵔⵔⴻⴷ ⴰⴷ ⵀⴻⵣⵣⴻⵏ ⵣⵉ ⵙⵙⴰ ⵖⴰⵔ ⴷⴰ ⴰⵎ ⵢⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵡⴻⵏⵀⴻⵣⵣⵉ, ");
INSERT INTO rift_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","ⵎⵉⵏⵣⵉ ⵏⵉⵜⵏⵉ ⵜⵜⵡⴰⵎⵎⴻⵡⵛⴻⵏ ⴰⵢⵉ ⵏⵉⵛⴰⵏ ⵣⵉ ⵍⵡⴻⵙⵟ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵓⵛⴰ ⵏⴻⵛⵛ ⴽⵙⵉⵖ ⵜⴻⵏ ⵉ ⵢⵉⵅⴻⴼ ⵉⵏⵓ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵢⴰⵔⴻⵣⵎⴻⵏ ⵍⴻⵎⵍⴰⵡⴻⵜ ⴷ ⴰⵎⴻⵣⵡⴰⵔⵓ, ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏ ⵓⵎⴻⵏⵣⵓ ⵏ ⵎⴰⵔⵔⴰ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","ⵎⵉⵏⵣⵉ ⵎⴰⵔⵔⴰ ⴰⵎⴻⵏⵣⵓ ⵊⴰⵔ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴰⵇⴰ-ⵜ ⵉⵏⵓ, ⵣⴻⴳ ⵉⵡⴷⴰⵏ, ⴰⵎⵎⵓ ⵣⵉ ⵍⵎⴰⵍ, ⵣⴻⴳ ⵡⴰⵙⵙ ⵉ ⴷⵉ ⵏⵖⵉⵖ ⵏⴻⵛⵛ ⵎⴰⵔⵔⴰ ⵉⵎⴻⵏⵣⴰ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ, ⵙⵙⵇⴻⴷⴷⵙⴻⵖ ⵜⴻⵏ ⵉ ⵏⴻⵛⵛ. ");
INSERT INTO rift_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","ⵏⴻⵛⵛ ⴽⵙⵉⵖ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵏ ⵎⴰⵔⵔⴰ ⵉⵎⴻⵏⵣⴰ ⵊⴰⵔ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","ⵏⴻⵛⵛ ⵡⵛⵉⵖ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⵉ ⵀⴰⵔⵓⵏ ⵓ ⵉ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⴰⵎ ⵢⵉⵊⵊ ⵏ ⵓⵔⵉⵖⴰⵍⵓ ⵣⵉ ⵍⵡⴻⵙⵟ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴳⴳⴻⵏ ⵜⴰⵙⴻⵅⵅⴰⵔⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴷⴻⴳ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⵓ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⵜⵜⵡⴰⴳⴳ ⵡⴻⵚⵍⴰⵃ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵃⵉⵎⴰ ⵡⴰⵔ ⵜᵉⵜⵜⵉⵍⵉ ⵊⵊⵔⵉⵃⴻⵛⵜ ⵅ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵅⵎⵉ ⴷⴷ ⵖⴰ ⵇⴰⵔⵔⴱⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵖⴰⵔ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ ⴷ ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴳⴳⵉⵏ ⴰⴽ-ⴷ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴷ ⴰⵙ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ ⵣⵉ ⵊⵊⵉⵀⴻⵜ ⵏ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ, ⴰⵎⵎⵓ ⵉ ⴳⴳⵉⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴰⴽⵉⴷⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⵙⵙⵉⵣⴷⵉⴳⴻⵏ ⵉⵅⴻⴼ ⵏⵙⴻⵏ ⵣⵉ ⴷⴷⴻⵏⴱ ⵏⵙⴻⵏ ⵓⵛⴰ ⵚⴻⴱⴱⵏⴻⵏ ⴰⵔⵔⵓⴹ ⵏⵙⴻⵏ ⵓⵛⴰ ⵀⴰⵔⵓⵏ ⵢⴰⵔⵔⴰ ⵉ-ⵜⴻⵏ ⴰⴷ ⵏⵀⴻⵣⵣⴻⵏ ⵣⵉ ⵙⵙⴰ ⵖⴰⵔ ⴷⴰ ⴰⵎ ⵢⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵡⴻⵏⵀⴻⵣⵣⵉ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⵓⵛⴰ ⵀⴰⵔⵓⵏ ⵉⵙⵙⴻⵚⵍⴻⵃ ⵉ-ⵜⴻⵏ ⵉ ⵓⵙⵉⵣⴷⴻⴳ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","ⴰⵡⴰⵔⵏⵉ ⵎⴰⵏ ⴰⵢⴰ ⵓⵙⵉⵏ-ⴷⴷ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⵃⵉⵎⴰ ⴰⴷ ⵙⴻⵅⵅⴰⵔⴻⵏ ⴷⴻⴳ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵀⴰⵔⵓⵏ ⵓ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵙ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵙ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ ⵣⵉ ⵊⵊⵉⵀⴻⵜ ⵏ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ, ⴰⵎⵎⵓ ⵉ ⴽⵉⴷⵙⴻⵏ ⴳⴳⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“ⵜⴰ ⵣⵉ ⵊⵊⵉⵀⴻⵜ ⵏ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ: ⴰⵇⴰ ⵉⵜⵜⵅⴻⵚⵚⴰ ⵉ ⴽⵓⵍ ⵎⵎⵉⵙ ⵏ ⵅⴻⵎⵙⴰ ⵓ-ⵄⵉⵛⵔⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵙⴻⵏⵏⴻⵊ ⴰⴷ ⴷⴷ-ⵢⴰⵙ, ⵃⵉⵎⴰ ⴰⴷ ⵉⵙⴻⵅⵅⴰⵔ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏ ⵜⵙⴻⵅⵅⴰⵔⵜ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ");
INSERT INTO rift_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","ⵓ ⵅⵎⵉ ⵉ ⵖⴰ ⵢⵉⵡⴻⴹ ⵖⴰⵔ ⵅⴻⵎⵙⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⴰⴷ ⵉⴼⴼⴻⵖ ⵣⵉ ⵍⵄⴻⵙⴽⴰⵔ ⵏ ⵜⵙⴻⵅⵅⴰⵔⵜ ⵓ ⵡⴰⵔ ⵉⵇⵇⵉⵎ ⵉⵜⵜⵙⴻⵅⵅⴰⵔ ⵄⴰⴷ ⴽⵜⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","ⴰⴷ ⵉⵡⵛ ⴰⴼⵓⵙ ⵉ ⵢⴰⵢⵜⵎⴰⵙ ⴷⴻⴳ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⵃⵉⵎⴰ ⴰⴷ ⵅⴰⵙ ⵃⴹⴰⵏ, ⵎⴰⵛⴰ ⵏⴻⵜⵜⴰ ⵙ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵡⴰⵔ ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵉⵙⴻⵅⵅⴰⵔ. ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵜⴻⴳⴳⴻⴷ ⴰⴽ-ⴷ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⵣⵉ ⵊⵊⵉⵀⴻⵜ ⵏ ⵓⵃⴻⵟⵟⵓ ⵉ ⵅⴰⵙⴻⵏ ⵉⵜⵜⵡⴰⴳⴳⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ ⴷⵉ ⵍⴻⵅⵍⴰ ⵏ ⵙⵉⵏⴰ ⴷⴻⴳ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵡⵉⵙⵙ ⵜⵏⴰⵢⴻⵏ ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⴷⴷ-ⴼⴼⵖⴻⵏ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ, ⴷⴻⴳ ⵓⵢⵓⵔ ⴰⵎⴻⵣⵡⴰⵔⵓ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“ⵊⵊⴻⵎ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴰⴷ ⵙⵙⵡⴻⵊⴷⴻⵏ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵓⵙⴻⵄⴷⵓ ⴷⵉ ⵍⵡⴻⵇⵜ ⵏⵏⴻⵙ ⵉⵜⵜⵡⴰⴳⴳⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⴰⵔⴱⴻⵄⵟⴰⵛ ⵏ ⵓⵢⵓⵔ-ⴰ, ⵊⴰⵔ ⴱⴻⴷⴷⵓ ⵏ ⵡⴻⵣⵢⴻⵏ ⵏ ⵡⴰⵙⵙ ⴰⵍ ⴷⴷ-ⵜⴻⵡⴹⴰ ⵜⵎⴻⴷⴷⵉⵜ, ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜⵜ ⵜⴻⵙⵙⵡⴻⵊⴷⴻⵎ ⴷⵉ ⵍⵡⴻⵇⵜ ⵏⵏⴻⵙ ⵉⵜⵜⵡⴰⴳⴳⴻⵏ. ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜⵜ ⵜⴻⵙⵙⵡⴻⵊⴷⴻⵎ ⵄⵍⴰⵃⵙⴰⴱ ⵎⴰⵔⵔⴰ ⵜⵉⵡⴻⵚⵚⴰ ⴷ ⵍⴼⴰⵔⴰⵢⵉⴹ ⵏⵏⴻⵙ.” ");
INSERT INTO rift_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","ⵉⵙⵙⵉⵡⴻⵍ ⵎⵓⵙⴰ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵉⵏⵏⴰ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⵙⴻⵏ ⴰⴷ ⵙⵙⵡⴻⵊⴷⴻⵏ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵓⵙⴻⵄⴷⵓ. ");
INSERT INTO rift_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","ⵓⵛⴰ ⵏⵉⵜⵏⵉ ⵙⵙⵡⴻⵊⴷⴻⵏ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵓⵙⴻⵄⴷⵓ ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⴰⵔⴱⴻⵄⵟⴰⵛ ⵏ ⵓⵢⵓⵔ ⴰⵎⴻⵣⵡⴰⵔⵓ ⴷⵉ ⵍⴻⵅⵍⴰ ⵏ ⵙⵉⵏⴰ, ⵊⴰⵔ ⴱⴻⴷⴷⵓ ⵏ ⵡⴻⵣⵢⴻⵏ ⵏ ⵡⴰⵙⵙ ⴰⵍ ⴷⴷ-ⵜⴻⵡⴹⴰ ⵜⵎⴻⴷⴷⵉⵜ, ⵄⵍⴰⵃⵙⴰⴱ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴷ ⴰⵙ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ, ⴰⵎⵎⵓ ⵉ ⵜⵜ ⵙⵙⵡⴻⵊⴷⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","ⵛⴰ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ ⵜⵜⵡⴰⵙⵙⵅⴻⵎⵊⴻⵏ ⵙ ⵍⵅⴻⵛⴱⴻⵜ ⵏ ⵉⵊⵊ ⵏ ⴱⵏⴰⴷⴻⵎ ⵉⵎⵎⵓⵜⴻⵏ ⵓⵛⴰ ⵡⴰⵔ ⵣⴻⵎⵎⴰⵔⴻⵏ ⴰⴷ ⵙⵙⵡⴻⵊⴷⴻⵏ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵓⵙⴻⵄⴷⵓ. ⵅ ⵓⵢⴰ ⵇⴰⵔⵔⴱⴻⵏ-ⴷⴷ ⵏⵉⵜⵏⵉ ⴷⴻⴳ ⵡⴰⵙⵙ ⵏⵏⵉ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵎⵓⵙⴰ ⵓ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵀⴰⵔⵓⵏ ");
INSERT INTO rift_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","ⵓⵛⴰ ⵏⵏⴰⵏ ⴰⵙ ⵢⴻⵔⵢⴰⵣⴻⵏ ⵏⵏⵉ: “ⵏⴻⵛⵛⵉⵏ ⵏⴻⵅⵎⴻⵊ ⵙ ⵍⵅⴻⵛⴱⴻⵜ ⵏ ⵉⵊⵊ ⵏ ⴱⵏⴰⴷⴻⵎ ⵉⵎⵎⵓⵜⴻⵏ. ⵎⴰⵢⴻⵎⵎⵉ ⵉ ⵏⴻⵜⵜⵡⴰⵙⵙⴱⴻⴷⴷ ⴰⵍⴰⵎⵉ ⵡⴰⵔ ⵏⵣⴻⵎⵎⴰⵔ ⴰⴷ ⴷⴷ-ⵏⴻⵙⵙⵇⴰⵔⵔⴻⴱ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵙⵉⴷⵉ ⴷⴻⴳ ⵡⴰⵙⵙ ⵏⵏⴻⵙ ⵉⵜⵜⵡⴰⴳⴳⴻⵏ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ?” ");
INSERT INTO rift_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","ⵎⵓⵙⴰ ⵉⵏⵏⴰ ⴰⵙⴻⵏ: “ⵇⵇⵉⵎⴻⵎ ⵜⴱⴻⴷⴷⴻⵎ, ⵃⵉⵎⴰ ⴰⴷ ⵙⵍⴻⵖ ⵎⵉⵏ ⴷ ⴰⵡⴻⵎ ⵖⴰ ⵉⵡⴻⵚⵚⴰ ⵙⵉⴷⵉ.” ");
INSERT INTO rift_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“ⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵛⴰ ⵉⵏⵉ: ‘ⵎⴰⵍⴰ ⵃⴻⴷ ⵣⵣⴰⵢⵡⴻⵎ ⵏⵉⵖ ⵣⵉ ⵊⵊⵉⵍⴰⵜ ⵏⵡⴻⵎ ⵉ ⴷⴷ ⵖⴰ ⵢⴰⵙⴻⵏ ⵉⵜⵜⵡⴰⵙⵙⴻⵅⵎⴻⵊ ⵣⵉ ⵍⵅⴻⵛⴱⴻⵜ ⵏ ⵢⵉⵊⵊ ⵏ ⵓⵎⴻⵜⵜⵉⵏ, ⵏⵉⵖ ⵏⴻⵜⵜⴰ ⴷⴻⴳ ⵡⴻⴱⵔⵉⴷ ⴷ ⴰⵣⵉⵔⴰⵔ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⵙⵙⴻⵡⵊⴻⴷ ⵄⴰⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵓⵙⴻⵄⴷⵓ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","ⴷⴻⴳ ⵓⵢⵓⵔ ⵡⵉⵙⵙ ⵜⵏⴰⵢⴻⵏ, ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⴰⵔⴱⴻⵄⵟⴰⵛ, ⵊⴰⵔ ⴱⴻⴷⴷⵓ ⵏ ⵡⴻⵣⵢⴻⵏ ⵏ ⵡⴰⵙⵙ ⴰⵍ ⴷⴷ-ⵜⴻⵡⴹⴰ ⵜⵎⴻⴷⴷⵉⵜ, ⴰⴷ ⵜⵜ ⵙⵙⵡⴻⵊⴷⴻⵏ. ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⵜ ⵛⵛⴻⵏ ⴰⴽ-ⴷ ⵡⴻⵖⵔⵓⵎ ⴱⵍⴰ ⴰⵏⵜⵓⵏ ⵓ ⴰⴽ-ⴷ ⵍⴻⴱⵣⴰⵔ ⵢⴰⵔⴻⵣⴳⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","ⵡⴰⵔ ⵜⵜⴻⵊⵊⵉⵏ ⵣⵣⴰⵢⴻⵙ ⵡⴰⵍⵓ ⴰⵍ ⵚⵚⴱⴻⵃ ⵓⵛⴰ ⵡⴰⵔ ⵣⵣⴰⵢⴻⵙ ⵜⵜⴰⵔⴻⵥⵥⴰⵏ ⵉⵖⴻⵙ. ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜⵜ ⵙⵙⵡⴻⵊⴷⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵎⴰⵔⵔⴰ ⵜⵉⵡⴻⵚⵚⴰ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵓⵙⴻⵄⴷⵓ.’” ");
INSERT INTO rift_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","“ⵎⴰⵍⴰ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⴷ ⴰⵎⴻⵣⴷⴰⴳ ⵉ ⵡⴰⵔ ⵉⴵⵉⵏ ⴷⴻⴳ ⵡⴻⴱⵔⵉⴷ, ⴰⴷ ⵢⴻⵊⵊ ⴰⴷ ⵉⵙⵙⴻⵡⵊⴻⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵓⵙⴻⵄⴷⵓ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⵜⵜⵡⴰⵇⴻⵙⵙ ⵍⴻⵄⵎⴰⵔ ⵏⵏⵉ ⵣⵉ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ, ⵎⵉⵏⵣⵉ ⵏⴻⵜⵜⴰ ⵡⴰⵔ ⴷⴷ-ⵉⵙⵙⵇⴰⵔⵔⴻⴱ ⵛⴰ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵙⵉⴷⵉ ⴷⵉ ⵍⵡⴻⵇⵜ ⵏⵏⴻⵙ ⵉⵜⵜⵡⴰⴳⴳⴻⵏ. ⴰⵔⵢⴰⵣ ⵏⵏⵉ ⴰⴷ ⵢⴰⵔⴱⵓ ⴷⴷⴻⵏⴱ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","ⵎⴰⵍⴰ ⵉⵣⴷⴻⵖ ⴰⴽⵉⴷⵡⴻⵎ ⵉⵊⵊ ⵏ ⵓⴱⴰⵔⵔⴰⵏⵉ, ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵉⵙⵙⵡⴻⵊⴷⴻⵏ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵓⵙⴻⵄⴷⵓ ⵏ ⵙⵉⴷⵉ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⵙⵙⴻⵡⵊⴻⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵓⵙⴻⵄⴷⵓ ⵄⵍⴰⵃⵙⴰⴱ ⵜⴰⵡⵚⴻⵢⵢⴻⵜ ⵏ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵓⵙⴻⵄⴷⵓ ⵓ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴼⴰⵔⴰⵢⵉⴹ ⵏⵏⴻⵙ. ⴰⴷ ⴷⵉⵏ ⵜⵉⵍⵉ ⵉⵛⵜ ⵏ ⵜⴻⵡⵚⴻⵢⵢⴻⵜ ⵉ ⴽⴻⵏⵏⵉⵡ, ⵉ ⵓⴱⴰⵔⵔⴰⵏⵉ ⴰⵎⵎⵓ ⵉ ⵡⴻⵏⵏⵉ ⴷⴷ-ⵉⵅⴻⵍⵇⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ.” ");
INSERT INTO rift_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","ⴷⴻⴳ ⵡⴰⵙⵙ ⵎⵉⵏ ⴷⵉ ⵜᵉⵜⵜⵡⴰⵙⵙⴳⴻⵄⵄⴻⴷ ⵜⵣⴻⴷⴷⵉⵖⵜ, ⵉⴷⵍⴰ ⵓⵙⴻⵢⵏⵓ ⵜⴰⵣⴻⴷⴷⵉⵖⵜ ⴰⴽ-ⴷ ⵓⵇⵉⴹⵓⵏ ⵏ ⵛⵛⵀⴰⴷⴻⵜ ⵓ ⴷⵉ ⴵⵉⵍⴻⵜ ⵉⴹⵀⴰⵔ-ⴷⴷ ⵅ ⵜⵣⴻⴷⴷⵉⵖⵜ ⴰⵎ ⵜⵎⴻⵙⵙⵉ ⴰⵍ ⵚⵚⴱⴻⵃ. ");
INSERT INTO rift_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","ⴰⵎⵎⵓ ⵉ ⵜⵓⵖⴰ ⵍⴻⴱⴷⴰ, ⴰⵙⴻⵢⵏⵓ ⵉⴷⵍⴰ ⵉ-ⵜⵜ ⵓ ⴷⵉ ⴵⵉⵍⴻⵜ ⵉⴹⵀⴰⵔ-ⴷⴷ ⴰⵎ ⵜⵎⴻⵙⵙⵉ. ");
INSERT INTO rift_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","ⵍⴰⵎⵉ ⴷⴷ-ⵉⴳⴻⵄⵄⴻⴷ ⵓⵙⴻⵢⵏⵓ ⵣⵉ ⵙⴻⵏⵏⴻⵊ ⵏ ⵓⵇⵉⴹⵓⵏ, ⵅⴻⵏⵏⵉ ⴰⵡⴰⵔⵏⵉ ⴰⵢⴰ ⴼⴻⵙⵢⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⵓ ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵎⴰⵏⵉ ⵜⵓⵖⴰ ⴷⴷ-ⵉⴱⴻⴷⴷ ⵓⵙⴻⵢⵏⵓ, ⴷⵉⵏ ⵉ ⵡⵜⵉⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","ⴼⴻⵙⵢⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵍⵓⵎⵓⵔ ⵏ ⵙⵉⴷⵉ ⵓⵛⴰ ⵅ ⵍⵓⵎⵓⵔ ⵏ ⵙⵉⴷⵉ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ. ⵎⴰⵔⵔⴰ ⵓⵙⵙⴰⵏ ⵜⵓⵖⴰ ⴰⵙⴻⵢⵏⵓ ⵉⵇⵇⵉⵎ ⵙⴻⵏⵏⴻⵊ ⵉ ⵜⵣⴻⴷⴷⵉⵖⵜ, ⵇⵇⵉⵎⴻⵏ ⵏⵉⵜⵏⵉ ⵣⴻⴷⴷⵖⴻⵏ ⴷⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","ⵍⴰⵎⵉ ⴷⴷ-ⵉⴱⴻⴷⴷ ⵓⵙⴻⵢⵏⵓ ⴰⵟⵟⴰⵙ ⵏ ⵡⵓⵙⵙⴰⵏ ⵙⴻⵏⵏⴻⵊ ⵉ ⵜⵣⴻⴷⴷⵉⵖⵜ, ⵃⴹⴰⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵜⴰⵙⴻⵅⵅⴰⵔⵜ ⵏ ⵙⵉⴷⵉ ⵓⵛⴰ ⵡⴰⵔ ⴼⴻⵙⵢⴻⵏ ⵛⴰ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","ⵓⵎⵉ ⵉⵇⵇⵉⵎ ⵓⵙⴻⵢⵏⵓ ⵛⵡⴰⵢⵜ ⵏ ⵡⵓⵙⵙⴰⵏ ⵙⴻⵏⵏⴻⵊ ⵉ ⵜⵣⴻⴷⴷⵉⵖⵜ, ⵅⴻⵏⵏⵉ ⵡⵜⵉⵏ ⵏⵉⵜⵏⵉ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵍⵓⵎⵓⵔ ⵏ ⵙⵉⴷⵉ ⵓ ⵅ ⵍⵓⵎⵓⵔ ⵏ ⵙⵉⴷⵉ ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⵄⴰⵡⴻⴷ. ");
INSERT INTO rift_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","ⵎⴰⵍⴰ ⵉⵎⵙⴰⵔ ⴱⴻⵍⵍⵉ ⴰⵙⴻⵢⵏⵓ ⵉⴱⴻⴷⴷ ⴷⵉⵏ ⵣⵉ ⴵⵉⵍⴻⵜ ⴰⵍ ⵚⵚⴱⴻⵃ ⵓⵛⴰ ⵉⴳⴻⵄⵄⴻⴷ ⵓⵙⴻⵢⵏⵓ ⴷⵉ ⵚⵚⴱⴻⵃ, ⵅⴻⵏⵏⵉ ⴼⴻⵙⵢⴻⵏ ⵏⵉⵜⵏⵉ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ. ⵎⴰ ⴷⴻⴳ ⵡⴰⵙⵙ ⵉ ⵉⴵⴰ ⵏⵉⵖ ⴷⵉ ⴵⵉⵍⴻⵜ, ⵅⵎⵉ ⴷⴷ-ⵉⴳⴻⵄⵄⴻⴷ ⵓⵙⴻⵢⵏⵓ, ⴼⴻⵙⵢⴻⵏ ⵏⵉⵜⵏⵉ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","ⵓⵛⴰ ⵎⴰⵍⴰ ⵉⵇⵇⵉⵎ ⵓⵙⴻⵢⵏⵓ ⵉⴱⴻⴷⴷ ⵙⴻⵏⵏⴻⵊ ⵉ ⵜⵣⴻⴷⴷⵉⵖⵜ ⵜⵏⴰⵢⴻⵏ ⵏ ⵡⵓⵙⵙⴰⵏ, ⵏⵉⵖ ⵉⵊⵊ ⵏ ⵓⵢⵓⵔ, ⵏⵉⵖ ⴰⵟⵟⴰⵙ ⵏ ⵡⵓⵙⵙⴰⵏ, ⴰⵍⴰⵎⵉ ⵅⴰⵙ ⵖⴰ ⵢⴰⵔⵙⴰ, ⵅⴻⵏⵏⵉ ⵇⵇⵉⵎⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵜⵜⵅⴻⵢⵢⵎⴻⵏ ⴷⵉⵏⵏⵉ, ⵡⴰⵔ ⴼⴻⵙⵢⴻⵏ ⵛⴰ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ. ⵎⴰⵍⴰ ⵉⴳⴻⵄⵄⴻⴷ ⵓⵙⴻⵢⵏⵓ, ⵅⴻⵏⵏⵉ ⴼⴻⵙⵢⴻⵏ ⵏⵉⵜⵏⵉ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","ⵅ ⵍⵓⵎⵓⵔ ⵏ ⵙⵉⴷⵉ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⵓ ⵅ ⵍⵓⵎⵓⵔ ⵏ ⵙⵉⴷⵉ ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ. ⴰⵇⴰ ⵃⴹⴰⵏ ⵎⵉⵏ ⴷ ⴰⵙⴻⵏ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ, ⵅ ⵍⵓⵎⵓⵔ ⵏ ⵙⵉⴷⵉ, ⵙ ⵜⵙⴻⵅⵅⴰⵔⵜ ⵏ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“ⴻⴳⴳ ⵉ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵛ ⵜⵏⴰⵢⴻⵏ ⵏ ⵍⴻⴱⵡⴰⵇ ⵉⵣⵉⵔⴰⵔⴻⵏ ⵏ ⵏⵏⵓⵇⴰⵔⵜ, ⵙ ⵢⵉⵊⵊ ⵏ ⵓⵎⴰⵔⵙⵓ ⵙ ⵡⴻⴼⴹⵉⵙ ⴰⴷ ⵜⴻⵏ ⵜⴻⴳⴳⴻⴷ ⵓⵛⴰ ⴰⴷ ⵉⵍⵉⵏ ⵉ ⵓⴱⴰⵔⵔⴻⵃ ⵏ ⵜⵎⴻⵙⵎⵓⵏⵜ ⵓ ⵉ ⵓⵙⵎⵓⵟⵟⵉ ⵏ ⵍⴻⵎⵔⴰⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","ⵅⵎⵉ ⴷⴰⵢⵙⴻⵏ ⵖⴰ ⵙⵓⴹⴻⵏ, ⴰⴷ ⵖⴰⵔⴻⴽ ⵜⵎⵓⵏ ⵜⵎⴻⵙⵎⵓⵏⵜ ⵎⴰⵔⵔⴰ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","ⵅⵎⵉ ⵖⴰ ⵙⵓⴹⴻⵏ ⴷⴻⴳ ⵉⵊⵊ ⵣⵉ ⵜⵏⴰⵢⴻⵏ ⵏⵏⵉ, ⵅⴻⵏⵏⵉ ⵎⵖⵉⵔ ⵍⵃⵓⴽⴽⴰⵎ, ⵉⵣⴻⴵⵉⴼⴻⵏ ⵅ ⵍⵓⵍⵓⴼ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵉ ⵅⴰⴽ ⴷⴷ ⵖⴰ ⵉⵎⵓⵏⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","ⵅⵎⵉ ⵖⴰ ⵜⵙⵓⴹⴻⵎ ⵙ ⵡⴻⵙⵔⵓⴷⴷⴻⵃ ⴷⵉ ⵍⴱⵓⵇ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵎⵎⵓⵟⵟⵉⵢⴻⵏⵜ ⵍⴻⵎⵔⴰⴳⴻⵃ ⵏⵏⵉ ⵉⵎⵎⴰⵔⵙⴻⵏ ⵖⴰⵔ ⵛⵛⴰⵔⵇ. ");
INSERT INTO rift_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","ⵅⵎⵉ ⵖⴰ ⵜⵙⵓⴹⴻⵎ ⵙ ⵡⴻⵙⵔⵓⴷⴷⴻⵃ ⴷⵉ ⵍⴱⵓⵇ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵡⴰⵍⴰⵡⵉⵏ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵎⵎⵓⵟⵟⵉⵢⴻⵏⵜ ⵍⴻⵎⵔⴰⴳⴻⵃ ⵏⵏⵉ ⵉⵎⵎⴰⵔⵙⴻⵏ ⵖⴰⵔ ⵓⵖⴻⵣⴷⵉⵙ ⵏ ⵍⵊⴰⵏⵓⴱ. ⴰⴷ ⵙⵓⴹⴻⵏ ⵙ ⵡⴻⵙⵔⵓⴷⴷⴻⵃ ⵓⵎⵉ ⵖⴰ ⵎⵓⵟⵟⵉⵢⴻⵏ ⵣⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵖⴰⵔ ⵡⴻⵎⵛⴰⵏ ⵏⵏⴻⵖⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","ⵉ ⵜⵎⴻⵙⵎⵓⵏⵜ ⵏ ⵡⴻⴳⵔⴰⵡ ⵏ ⵍⴳⴻⵏⵙ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜⵙⵓⴹⴻⵎ ⴷⵉ ⵍⴻⴱⵡⴰⵇ, ⵎⴰⵛⴰ ⴱⵍⴰ ⴰⵙⵔⵓⴷⴷⴻⵃ. ");
INSERT INTO rift_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","ⴰⴷ ⵙⵓⴹⴻⵏ ⵡⴰⵔⵔⴰⵡ ⵏ ⵀⴰⵔⵓⵏ, ⵉⴽⴻⵀⵀⴰⵏⴻⵏ, ⴷⵉ ⵍⴻⴱⵡⴰⵇ. ⴰⴷ ⵜⵉⵍⵉ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵚⴻⵢⵢⴻⵜ ⵉ ⵍⴻⴱⴷⴰ ⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵏⵡⴻⵎ.” ");
INSERT INTO rift_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","“ⵅⵎⵉ ⴷⴷ ⵖⴰ ⵜⴻⴼⴼⵖⴻⵎ ⵖⴰⵔ ⴳⴰⵔⵔⴰ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵡⴻⵎ, ⵃⵉⵎⴰ ⴰⴷ ⵜⵎⴻⵏⵖⴻⵎ ⴰⴽ-ⴷ ⵡⴻⵖⵔⵉⵎ ⵏⵏⵉ ⴽⴻⵏⵏⵉⵡ ⴷⴷ-ⵉⵀⴻⴽⴽⵡⴻⵍⴻⵏ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⵙⵓⴹⴻⵎ ⵙ ⵡⴻⵙⵔⵓⴷⴷⴻⵃ ⴷⵉ ⵍⴻⴱⵡⴰⵇ ⵓⵛⴰ ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⵜᵉⵜⵜⵡⴰⵜⵉⴷⴰⵔⴻⵎ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ, ⵓⵛⴰ ⴰⴷ ⵜⵏⴻⵊⵎⴻⵎ ⵣⵉ ⵍⵄⴻⴷⵢⴰⵏ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","ⴰⵎⵎⵓ ⴷⵉ ⴽⵓⵍ ⵉⵊⵊ ⵏ ⵡⴰⵙⵙ ⵏ ⵍⴻⴼⵔⴰⵃⴻⵜ ⵓ ⴷⵉ ⵍⴻⵄⵢⵓⴷⴰⵜ ⵉⵜⵜⵡⴰⴳⴳⴻⵏ ⵓ ⴷⴻⴳ ⵓⵎⴻⵣⵡⴰⵔⵓ ⵏ ⵉⵢⵓⵔⴻⵏ ⵏⵡⴻⵎ ⴰⴷ ⵜⵙⵓⴹⴻⵎ ⴷⵉ ⵍⴻⴱⵡⴰⵇ ⵅⵎⵉ ⵖⴰ ⵜⴰⵡⵢⴻⵎ ⵜⵉⵖⴰⵔⵚⴰ ⵏ ⵡⴻⵛⵎⴰⴹ ⵏⵡⴻⵎ ⴷ ⵜⵖⴰⵔⵚⴰ ⵏ ⵓⵇⴰⴷⵉ ⵏⵡⴻⵎ ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵉⵍⵉⵏⵜ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏⵡⴻⵎ ⵉ ⵍⵉⴷⴰⵔⴻⵜ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⴰⵔⴻⴱⴱⵉ, ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ.” ");
INSERT INTO rift_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","ⵉⵎⵙⴰⵔ ⴷⴻⴳ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵡⵉⵙⵙ ⵜⵏⴰⵢⴻⵏ, ⴷⴻⴳ ⵓⵢⵓⵔ ⵡⵉⵙⵙ ⵜⵏⴰⵢⴻⵏ, ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵄⵉⵛⵔⵉⵏ ⵏ ⵓⵢⵓⵔ, ⴰⵇⴰ ⵉⵜⵜⵡⴰⵙⵙⴳⴻⵄⵄⴻⴷ ⵓⵙⴻⵢⵏⵓ ⵣⵉ ⵙⴻⵏⵏⴻⵊ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ ⵏ ⵛⵛⵀⴰⴷⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","ⵓⵛⴰ ⴼⴻⵙⵢⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⵎⵎⵓⵟⵟⵉⵢⴻⵏ ⵣⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵖⴰⵔ ⵡⴻⵎⵛⴰⵏ ⵣⵉ ⵍⴻⵅⵍⴰ ⵏ ⵙⵉⵏⴰ ⵓⵛⴰ ⵉⴱⴻⴷⴷ-ⴷⴷ ⵓⵙⴻⵢⵏⵓ ⴷⵉ ⵍⴻⵅⵍⴰ ⵏ ⴼⴰⵔⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","ⴰⵎⵎⵓ ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⵜⵡⴰⵍⴰ ⵜⴰⵎⴻⵣⵡⴰⵔⵓⵜ, ⵅ ⵍⵓⵎⵓⵔ ⵏ ⵙⵉⴷⵉ, ⵅ ⵓⴼⵓⵙ ⵏ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","ⴷ ⴰⵎⴻⵣⵡⴰⵔⵓ ⵜᵉⵜⵜⵡⴰⴽⴽⴻⵙ ⵜⵄⴻⴵⴰⵏⵜ ⵏ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵏ ⴰⵢⵜ ⵏ ⵢⴰⵀⵓⴷⴰ, ⵓⵢⵓⵔⴻⵏ ⴰⵎ ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵜⵉⵔⴱⵉⵄⵉⵏ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵙⴻⵏ. ⵏⴰⵃⵛⵓⵏ, ⵎⵎⵉⵙ ⵏ ⵄⴰⵎⵎⵉⵏⴰⴷⴰⴱ, ⵜⵓⵖⴰ ⴷ ⴰⵣⴻⴵⵉⴼ ⵅ ⵍⵄⴻⵙⴽⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","ⵏⴰⵜⴰⵏⴰⵢⵉⵍ, ⵎⵎⵉⵙ ⵏ ⵚⵓⵖⴰⵔ, ⵜⵓⵖⴰ ⴷ ⴰⵣⴻⴵⵉⴼ ⵅ ⵍⵄⴻⵙⴽⴰⵔ ⵏ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵙⴰⴽⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","ⵉⵍⵉⵢⴰⴱ, ⵎⵎⵉⵙ ⵏ ⵃⵉⵍⵓⵏ, ⵜⵓⵖⴰ ⴷ ⴰⵣⴻⴵⵉⴼ ⵅ ⵍⵄⴻⵙⴽⴰⵔ ⵏ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⴰⵢⵜ ⵏ ⵣⵉⴱⵓⵍⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","ⴰⵡⴰⵔⵏⵉ ⵎⴰⵏ ⴰⵢⴰ ⵀⴻⴷⵎⴻⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ ⵓⵛⴰ ⴼⴻⵙⵢⴻⵏ ⴰⵢⵜ ⵏ ⵊⴰⵔⵛⵓⵏ ⴷ ⴰⵢⵜ ⵏ ⵎⴰⵔⴰⵔⵉ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⵓⵛⴰ ⴰⵔⴱⵓⵏ ⵜⴰⵣⴻⴷⴷⵉⵖⵜ. ");
INSERT INTO rift_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","ⵅⴻⵏⵏⵉ ⵜᵉⵜⵜⵡⴰⴽⴽⴻⵙ ⵜⵄⴻⴵⴰⵏⵜ ⵏ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵏ ⵔⵓⴱⵉⵏ ⵓⵢⵓⵔⴻⵏ, ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵜⵉⵔⴱⵉⵄⵉⵏ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵙⴻⵏ. ⵉⵍⵉⵚⵓⵔ, ⵎⵎⵉⵙ ⵏ ⵛⴰⴷⴰⵢⵓⵔ, ⵜⵓⵖⴰ ⴷ ⴰⵣⴻⴵⵉⴼ ⵅ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","ⵛⴰⵍⵓⵎⵉⵢⵉⵍ, ⵎⵎⵉⵙ ⵏ ⵚⵓⵔⵉⵛⴰⴷⴷⴰⵢ, ⵜⵓⵖⴰ ⴷ ⴰⵣⴻⴵⵉⴼ ⵅ ⵍⵄⴻⵙⴽⴰⵔ ⵏ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⴰⵢⵜ ⵏ ⵛⵉⵎⵄⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","ⵉⵍⵢⴰⵙⴰⴼ, ⵎⵎⵉⵙ ⵏ ⴷⴰⵄⵓⵢⵉⵍ, ⵜⵓⵖⴰ ⴷ ⴰⵣⴻⴵⵉⴼ ⵅ ⵍⵄⴻⵙⴽⴰⵔ ⵏ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⴰⵢⵜ ⵏ ⵊⴰⴷ. ");
INSERT INTO rift_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","ⵅⴻⵏⵏⵉ ⴼⴻⵙⵢⴻⵏ ⴰⵢⵜ ⵏ ⵇⴰⵀⴰⵜ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴰⵔⴱⵓⵏ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ. ⵓⵛⴰ ⴰⵢⵜ ⵏ ⵊⴰⵔⵛⵓⵏ ⴷ ⴰⵢⵜ ⵏ ⵎⴰⵔⴰⵔⵉ ⴱⵏⴰⵏ ⵜⴰⵣⴻⴷⴷⵉⵖⵜ ⵇⴱⴻⵍ ⵜⵡⴰⵙⵉⵜ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","ⴰⵡⴰⵔⵏⵉ ⴰⵙ ⵜᵉⵜⵜⵡⴰⴽⴽⴻⵙ ⵜⵄⴻⴵⴰⵏⵜ ⵏ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵏ ⴰⵢⵜ ⵏ ⵉⴼⵔⴰⵢⵉⵎ, ⵓⵢⵓⵔⴻⵏ, ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵜⵉⵔⴱⵉⵄⵉⵏ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵙⴻⵏ. ⵉⵍⵉⵛⴰⵎⴰⵄ, ⵎⵎⵉⵙ ⵏ ⵄⴰⵎⵎⵉⵀⵓⴷ, ⵜⵓⵖⴰ ⴷ ⴰⵣⴻⴵⵉⴼ ⵅ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","ⵊⴰⵎⴰⵍⵉⵢⵉⵍ, ⵎⵎⵉⵙ ⵏ ⴼⴰⴷⴰⵀⵚⵓⵔ, ⵜⵓⵖⴰ ⴷ ⴰⵣⴻⴵⵉⴼ ⵅ ⵍⵄⴻⵙⴽⴰⵔ ⵏ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⴰⵢⵜ ⵏ ⵎⴰⵏⴰⵙⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","ⴰⴱⵉⴷⵓⵏ, ⵎⵎⵉⵙ ⵏ ⵊⵉⴷⵄⵓⵏⵉ, ⵜⵓⵖⴰ ⴷ ⴰⵣⴻⴵⵉⴼ ⵅ ⵍⵄⴻⵙⴽⴰⵔ ⵏ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⴰⵢⵜ ⵏ ⴱⵉⵏⵢⴰⵎⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","ⵅⴻⵏⵏⵉ ⵜᵉⵜⵜⵡⴰⴽⴽⴻⵙ ⵜⵄⴻⴵⴰⵏⵜ ⵏ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵏ ⴰⵢⵜ ⵏ ⴷⴰⵏ, ⴰⵎ ⵓⵖⴻⵣⴷⵉⵙ ⵓⵏⴻⴳⴳⴰⵔ ⵏ ⵎⴰⵔⵔⴰ ⵍⴻⵎⵔⴰⴳⴻⵃ, ⵓⵛⴰ ⵓⵢⵓⵔⴻⵏ, ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵜⵉⵔⴱⵉⵄⵉⵏ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵙⴻⵏ. ⴰⵅⵉⵄⴰⵣⴰⵔ, ⵎⵎⵉⵙ ⵏ ⵄⴰⵎⵎⵉⵛⴰⴷⴷⴰⵢ, ⵜⵓⵖⴰ ⴷ ⴰⵣⴻⴵⵉⴼ ⵅ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","ⴼⴰⵊⵄⵉⵢⵉⵍ, ⵎⵎⵉⵙ ⵏ ⵄⵓⴽⵔⴰⵏ, ⵜⵓⵖⴰ ⴷ ⴰⵣⴻⴵⵉⴼ ⵅ ⵍⵄⴻⵙⴽⴰⵔ ⵏ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⴰⵢⵜ ⵏ ⴰⵛⵉⵔ. ");
INSERT INTO rift_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","ⴰⵅⵉⵔⴰⵄ, ⵎⵎⵉⵙ ⵏ ⵄⵉⵏⴰⵏ, ⵜⵓⵖⴰ ⴷ ⴰⵣⴻⴵⵉⴼ ⵅ ⵍⵄⴻⵙⴽⴰⵔ ⵏ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⴰⵢⵜ ⵏ ⵣⵉⴱⵓⵍⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","ⴰⵎⵎⵓ ⵉ ⵙⵙⵎⵓⵟⵟⵉⵢⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⵣⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵖⴰⵔ ⵡⴻⵎⵛⴰⵏ, ⴰⵎ ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵏⵉⵜⵏⵉ ⵄⵍⴰⵃⵙⴰⴱ ⵍⵄⴻⵙⴽⴰⵔⴰⵜ ⵏⵙⴻⵏ, ⴰⵎⵎⵓ ⵉ ⴼⴻⵙⵢⴻⵏ ⵏⵉⵜⵏⵉ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","ⵉⵏⵏⴰ ⵎⵓⵙⴰ ⵉ ⵃⵓⴱⴰⴱ, ⵎⵎⵉⵙ ⵏ ⵔⴰⵄⵓⵢⵉⵍ, ⴰⵎⵉⴷⵢⴰⵏⵉ, ⴰⴹⴻⴳⴳⵯⴰⵍ ⵏ ⵎⵓⵙⴰ: “ⵏⴻⵛⵛⵉⵏ ⴰⴷ ⵏⴻⵎⵎⵓⵟⵟⵉ ⵖⴰⵔ ⵡⴻⵎⵛⴰⵏ ⵉ ⴷ ⴰⵏⴻⵖ ⵉⵏⵏⴰ ⵙⵉⴷⵉ: ‘ⵏⴻⵛⵛ ⴰⴷ ⴰⵡⴻⵎ ⵜ-ⵉ-ⴷⴷ ⵡⵛⴻⵖ!’ ⴰⵙ-ⴷⴷ ⴰⴽⵉⴷⵏⴻⵖ, ⴰⴷ ⴰⵛ ⵏⴻⴳⴳ ⵜⵛⵓⵏⵉ, ⵎⵉⵏⵣⵉ ⵙⵉⴷⵉ ⵉⵙⵙⵉⵡⴻⵍ ⵅ ⵉⵙⵔⴰⵉⵍ ⵙ ⵍⵅⵉⵔ.” ");
INSERT INTO rift_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","ⵏⴻⵜⵜⴰ ⵉⵏⵏⴰ ⴰⵙ: “ⵏⴻⵛⵛ ⵡⴰⵔ ⵜⵜⵔⵉⵃⴻⵖ, ⵎⴰⵖⴰⵔ ⴰⴷ ⵓⵢⵓⵔⴻⵖ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵉⵏⵓ ⵓ ⵖⴰⵔ ⵍⴰⴵ ⵉⵏⵓ.” ");
INSERT INTO rift_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵉⵏⵏⴰ ⴰⵙ: “ⵜⵜⵣⴰⵡⴳⴻⵖ ⵛⴻⴽ, ⵡⴰⵔ ⴷ ⴰⵏⴻⵖ ⵜⵜⴻⵊⵊⵉ, ⵎⵉⵏⵣⵉ ⵛⴻⴽ ⵜⴻⵙⵙⵏⴻⴷ ⵎⴰⵎⵎⴻⵛ ⵉⵛⵓⵡⵡⴰⵔ ⴰⴷ ⵏⴻⵡⵡⴻⵜ ⵉⵇⵉⴹⴰⵏ ⵏⵏⴻⵖ. ⵛⴻⴽ ⴰⵇⴰ ⵜⴷⴻⵡⵍⴻⴷ ⴰⵏⴻⵖ - ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵏⴻⵇⵇⴰⵔ - ⴰⵎ ⵜⵉⵟⵟⴰⵡⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","ⵅⵎⵉ ⵖⴰ ⵜⵔⴰⵃⴻⴷ ⴰⴽⵉⴷⵏⴻⵖ ⵓⵛⴰ ⴰⴷ ⴰⵏⴻⵖ ⴷⴷ-ⵢⴰⵙ ⵍⵅⵉⵔ ⵉ ⴷⴰⵢⵏⴻⵖ ⵖⴰ ⵉⴳⴳ ⵙⵉⴷⵉ, ⴰⵇⴰ ⵏⴻⵛⵛⵉⵏ ⴰⴷ ⴰⵛ ⵏⴻⴳⴳ ⵜⵛⵓⵏⵉ ⵄⴰⵡⴻⴷ.” ");
INSERT INTO rift_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","ⵓⵛⴰ ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⵓⵢⵓⵔⴻⵏ ⵣⴻⴳ ⵡⴻⴷⵔⴰⵔ ⵏ ⵙⵉⴷⵉ ⵜⵉⵛⵍⵉ ⵏ ⵜⵍⴰⵜⴰ ⵏ ⵡⵓⵙⵙⴰⵏ. ⵜⵜⴰⴱⵓⵜ ⵏ ⵍⵄⴰⵀⴷ ⵜⵓⵢⵓⵔ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏⵙⴻⵏ ⵜⵉⵛⵍⵉ ⵏ ⵜⵍⴰⵜⴰ ⵏ ⵡⵓⵙⵙⴰⵏ, ⵃⵉⵎⴰ ⴰⴷ ⵢⴰⵔⵣⵓ ⵅ ⵉⵊⵊ ⵏ ⵡⴻⵎⵛⴰⵏ ⵉ ⴰⵔⵔⴰⵃⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","ⴷⴻⴳ ⵓⵣⵉⵍ ⵜⵓⵖⴰ ⴰⵙⴻⵢⵏⵓ ⵏ ⵙⵉⴷⵉ ⵙⴻⵏⵏⴻⵊ ⵏⵙⴻⵏ ⵓⵎⵉ ⴽⴽⵙⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⵣⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","ⵍⴰⵎⵉ ⵜᵉⵜⵜⵡⴰⵙⵙⵎⵓⵟⵟⵉ ⵜⵜⴰⴱⵓⵜ, ⵜⴻⵎⵙⴰⵔ ⵍⴻⴱⴷⴰ ⴱⴻⵍⵍⵉ ⵎⵓⵙⴰ ⵉⵏⵏⴰ: “ⴽⴽⴰⵔ, ⴰ ⵙⵉⴷⵉ, ⴻⵊⵊ ⵍⴻⵄⴷⵢⴰⵏ ⵏⵏⴻⵛ ⴰⴷ ⵎⵎⵣⴻⴵⴰⵄⴻⵏ ⵓ ⵉⵏⵏⵉ ⴽⴻⵏⵏⵉⵡ ⵉⵛⴰⵔⵔⵀⴻⵏ ⴰⴷ ⴰⵔⴻⵡⵍⴻⵏ ⵣⴻⴳ ⵡⵓⴷⴻⵎ ⵏⵏⴻⵛ!” ");
INSERT INTO rift_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","ⵖⴰⵔ ⵓⴱⴻⴷⴷⵉ ⵏ ⵜⵜⴰⴱⵓⵜ, ⵉⵏⵏⴰ: “ⴷⵡⴻⵍ-ⴷⴷ, ⴰ ⵙⵉⴷⵉ, ⵖⴰⵔ ⵄⴻⵛⵔⴰ ⵏ ⵍⵓⵍⵓⴼ ⵏ ⵍⵓⵍⵓⴼ ⵏ ⵉⵙⵔⴰⵉⵍ!” ");
INSERT INTO rift_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","ⵉⵎⵙⴰⵔ ⵓⵎⵉ ⵉⴷⵡⴻⵍ ⵍⴳⴻⵏⵙ ⴰⵎ ⵢⵉⵊⵊ ⵏ ⵓⴱⴰⵔⵔⵓ ⵉⵜⵜⵛⴻⵜⵛⴰⵏ, ⵜⵓⵖⴰ ⵎⴰⵏ ⴰⵢⴰ ⴷ ⵍⴻⵃⵔⵉⵇ ⵉ ⵉⵎⴻⵣⵣⵓⵖⴻⵏ ⵏ ⵙⵉⴷⵉ. ⵍⴰⵎⵉ ⵉⵙⵍⴰ ⵙⵉⴷⵉ ⴰⵢⴰ, ⵢⴰⵔⵖⴰ ⵡⴻⵖⴹⴰⴱ ⵏⵏⴻⵙ ⵓ ⵜⵉⵎⴻⵙⵙⵉ ⵏ ⵙⵉⴷⵉ ⵜⴰⵔⵖⴰ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏⵙⴻⵏ ⵓⵛⴰ ⵜⴻⵛⵛⴰ ⵍⴻⴹⵔⵓⴼ ⵏ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","ⵅⴻⵏⵏⵉ ⵉⵍⴰⵖⴰ-ⴷⴷ ⵍⴳⴻⵏⵙ ⵅ ⵎⵓⵙⴰ ⵓⵛⴰ ⵎⵓⵙⴰ ⵉⵥⵥⵓⴵ ⵉ ⵙⵉⴷⵉ ⵓⵛⴰ ⵜⴻⵅⵙⵉ ⵜⵎⴻⵙⵙⵉ. ");
INSERT INTO rift_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","ⵓⵛⴰ ⵉⵍⴰⵖⴰ ⴰⵙ ⵉ ⵡⴻⵎⵛⴰⵏ ⵏⵏⵉ ‘ⵜⴰⴱⵄⵉⵔⴰ’, ⵎⵉⵏⵣⵉ ⵜⵉⵎⴻⵙⵙⵉ ⵏ ⵙⵉⴷⵉ ⵜⵓⵖⴰ ⵜⴰⵔⵖⴰ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","ⴰⴱⴰⵔⵔⵓ ⵉⵎⵅⴻⴵⴰⴹⴻⵏ ⵏ ⵉⴱⴰⵔⵔⴰⵏⵉⵢⵢⴻⵏ ⵏⵏⵉ ⵉⴵⴰⵏ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏⵙⴻⵏ, ⴷⴻⵡⵍⴻⵏ ⵛⵓⵔⵔⴻⵏ ⵙ ⵓⵎⴻⵥⵔⵉ ⵓ ⴱⴷⴰⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵄⴰⵡⴻⴷ ⴰⴷ ⵛⴻⵜⵜⵛⴰⵏ, ⵏⵏⴰⵏ: “ⵡⵉ ⴷ ⴰⵏⴻⵖ ⵖⴰ ⵉⵡⵛⵉⵏ ⴰⵢⵙⵓⵎ? ");
INSERT INTO rift_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","ⵏⵄⴻⵇⵇⴻⵍ ⵄⴰⴷ ⵅ ⵉⵙⴻⵍⵎⴰⵏ ⵏⵏⵉ ⵏⴻⵛⵛⴰ ⴷⵉ ⵎⵉⵚⵔⴰ ⴱⴰⵟⴻⵍ ⵓ ⵅ ⵍⴻⵅⵢⴰⵔ ⴷ ⴷⴷⴻⵍⵍⴰⵄ ⴷ ⵍⴻⴱⵚⴻⵍ ⵢⵓⵥⵖⴻⵏ ⴷ ⵍⴻⴱⵚⴻⵍ ⴷ ⵜⵉⵛⵛⴰⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","ⵍⴻⵅⵅⵓ ⵍⴻⵄⵎⵓⵔ ⵏⵏⴻⵖ ⵓⵥⵖⴻⵏ ⵓⵛⴰ ⵡⴰⵔ ⴷⵉⵏ ⵡⴰⵍⵓ ⵎⵖⵉⵔ ‘ⵎⴰⵏⵏⴰ’-ⵢⴰ ⵣⵣⴰⵜ ⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵖ!” ");
INSERT INTO rift_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","ⵜⵓⵖⴰ ‘ⵎⴰⵏⵏⴰ’ ⵉⵜⵜⴻⵎⵛⴰⴱⴻⵀ ⴷⵉ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏ ⵍⵇⴻⵚⴱⵓⵔ ⵓⵛⴰ ⵛⵛⵓⴼ ⵏⵏⴻⵙ ⴰⵎⴻⵛⵏⴰⵡ ⵛⵛⵓⴼ ⵏ ⵓⵙⴻⵔⵖⴰⵖ ⴰⵛⴻⵎⵍⴰⵍ ⵇⵇⴰⵔⴻⵏ ⴰⵙ ‘ⴱᵉⴷⵓⵍⴰ’. ");
INSERT INTO rift_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","ⵍⴳⴻⵏⵙ ⵉⴼⴼⴻⵖ, ⵉⵎⵎⵙⴻⴱⴹⴰ ⵓⵛⴰ ⵢⵔⵓⵏ ⵜⵜ ⵓⵛⴰ ⵃⴰⵔⵢⴻⵏ ⵜⵜ ⵙⴰⴷⵓ ⵜⵙⵉⵔⵜ ⵏⵉⵖ ⴷⴷⵣⴻⵏ ⵜⵜ ⵙ ⵡⴻⵣⴷⵓⵣ ⵓⵛⴰ ⵅⴻⵏⵏⵉ ⵙⵙⴻⵏⴳⴳⵯⴻⵏ ⵜⵜ ⴷⵉ ⴰⵔⵡⴰ ⵓⵛⴰ ⴳⴳⵉⵏ ⵣⵣⴰⵢⴻⵙ ⵜⵉⴼⴹⵉⵔⵉⵏ. ⵜⵓⵖⴰ ⴰⵍⴻⴷⴷⵉ ⵏⵏⴻⵙ ⴰⵎ ⵎⵉⵏ ⵉⵏⴳⴳⵯⴰⵏ ⵙ ⵣⵣⴻⵛⵜ. ");
INSERT INTO rift_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","ⵅⵎⵉ ⴷⴷ-ⵉⵀⴻⴽⴽⵡⴰ ⵏⵏⴷⴰ ⵅ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ, ⵅⴻⵏⵏⵉ ⵜⵀⴻⴽⴽⵯⴰ-ⴷⴷ ⵅⴰⵙ ‘ⵎⴰⵏⵏⴰ’ ⵄⴰⵡⴻⴷ. ");
INSERT INTO rift_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","ⵓⵛⴰ ⵉⵙⵍⴰ ⵎⵓⵙⴰ ⴰⵇⴰ ⵍⴳⴻⵏⵙ ⵉⵙⵖⵓⵢ, ⵍⴰⴵ ⴰⵡⴰⵔⵏⵉ ⵉⵏⵏⴻⵖⵏⵉ, ⴽⵓⵍ ⵉⵊⵊ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏⵏⴻⵙ. ⵢⴰⵔⵖⴰ ⵡⴻⵖⴹⴰⴱ ⵏ ⵙⵉⴷⵉ ⴰⵟⵟⴰⵙ, ⵓⵛⴰ ⵜⵓⵖⴰ ⵎⴰⵏ ⴰⵢⴰ ⵓⵍⴰ ⴷ ⵜⵓⵄⴻⴼⴼⵏⴰ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","ⵉⵏⵏⴰ ⵎⵓⵙⴰ ⵉ ⵙⵉⴷⵉ: “ⵎⴰⵢⴻⵎⵎⵉ ⵜⴻⴳⴳⵉⴷ ⵍⵖⴰⵔ ⴷⴻⴳ ⵓⵎⵙⴻⵅⵅⴰⵔ ⵏⵏⴻⵛ ⵓ ⵎⴰⵢⴻⵎⵎⵉ ⵡⴰⵔ ⵓⴼⵉⵖ ⵍⵅⴰⴹⴰⵔ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵛ, ⵓⵎⵉ ⵅⴰⴼⵉ ⴷⴷ-ⵜⴻⵙⵙⴰⵔⵙⴻⴷ ⴷⴷⵇⴻⵍ ⵏ ⵎⴰⵔⵔⴰ ⵍⴳⴻⵏⵙ-ⴰ? ");
INSERT INTO rift_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","ⵎⴰ ⵏⴻⵛⵛ ⴷⴻⵢⵙⴻⵖ ⴱⴰⵍⴰⴽ ⵙ ⵎⴰⵔⵔⴰ ⵍⴳⴻⵏⵙ-ⴰ? ⵏⵉⵖ ⵏⴻⵛⵛ ⵉ-ⵜ-ⵉ-ⴷⴷ ⵢⵓⵔⵡⴻⵏ, ⵎⴰⵃⴻⵏⴷ ⵜⵣⴻⵎⵎⴰⵔⴻⴷ ⴰⴷ ⴰⵢⵉ ⵜⵉⵏⵉⴷ: ‘ⴰⵡⵢⵉ ⵜ ⴷⴻⴳ ⵡⴻⵛⵢⵓⵏ ⵏⵏⴻⵛ!’, ⴰⵎ ⵡⴻⵏⵏⵉ ⵉⵙⵙⵓⵟⵟⵓⴹⴻⵏ ⵢⴰⵔⴻⴱⴱⵓ ⴰⵙⴻⵢⵎⵉ, ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵎⵉⵏ ⵅⴻⴼ ⵜⴻⵊⵊⵓⴵⴻⴷ ⵛⴻⴽ ⵉ ⵍⴻⵊⴷⵓⴷ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","ⵣⵉ ⵎⴰⵏⵉⵙ ⴷ ⴰⵙⴻⵏ-ⴷⴷ ⵖⴰ ⵢⴰⵡⵢⴻⵖ ⴰⵢⵙⵓⵎ ⵉ ⵖⴰ ⵡⵛⴻⵖ ⴷ ⵎⴰⵛⵛⴰ ⵉ ⵎⴰⵔⵔⴰ ⵍⴳⴻⵏⵙ-ⴰ? ⵎⵉⵏⵣⵉ ⵏⵉⵜⵏⵉ ⵙⵖⵓⵢⵢⵓⵏ-ⴷⴷ ⵖⴰⵔⵉ, ⵇⵇⴰⵔⴻⵏ: ‘ⴻⵡⵛ ⴰⵏⴻⵖ ⴰⵢⵙⵓⵎ ⵉ ⵖⴰ ⵏⴻⵛⵛ!’ ");
INSERT INTO rift_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","ⵏⴻⵛⵛ ⵡⴻⵃⵃⴷⵉ ⵡⴰⵔ ⵣⴻⵎⵎⴰⵔⴻⵖ ⴰⴷ ⴰⵔⴱⵓⵖ ⵍⴳⴻⵏⵙ-ⴰ ⵎⴰⵔⵔⴰ, ⴰⵇⴰ ⵎⴰⵏ ⴰⵢⴰ ⵉⴷⵇⴻⵍ ⵅⴰⴼⵉ ⴰⵟⵟⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","ⵎⴰⵍⴰ ⴷⴰⵢⵉ ⵜⴻⴳⴳⵉⴷ ⴰⵎⵎⵓ, ⵏⴻⵛⵛ ⵜⵜⵣⴰⵡⴰⴳⴻⵖ ⴰⴷ ⴰⵢⵉ ⵜⴻⵏⵖⴻⴷ ⵃⵙⴻⵏ, ⵎⴰⵍⴰ ⵓⴼⵉⵖ ⴰⵔⴹⴰ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵛ, ⵅⴻⵏⵏⵉ ⵏⴻⵛⵛ ⵡⴰⵔ ⵥⴰⵔⵔⴻⵖ ⵍⴻⵖⴱⴻⵏ ⵉⵏⵓ ⵄⴰⴷ ⴽⵜⴰⵔ!” ");
INSERT INTO rift_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⵙⵎⵓⵏ ⴰⵢⵉ-ⴷⴷ ⵙⴻⴱⵄⵉⵏ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ ⵣⴻⴳ ⵉⵎⵖⴰⵔⴻⵏ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵉⵏⵏⵉ ⵜⴻⵙⵙⵏⴻⴷ ⵛⴻⴽ ⴷ ⵉⵎⵖⴰⵔⴻⵏ ⵏ ⵍⴳⴻⵏⵙ ⵓ ⴷ ⵉⵎⴻⵃⴹⴰⵢⴻⵏ. ⴰⵡⵢⵉ ⵜⴻⵏ-ⴷⴷ ⵖⴰⵔ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⵓⵛⴰ ⴻⵊⵊ ⵉⵜⴻⵏ ⴰⴷ ⴷⵉⵏ ⴱⴻⴷⴷⴻⵏ ⵣⵣⴰⵜⴻⴽ. ");
INSERT INTO rift_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","ⵅⴻⵏⵏⵉ ⵏⴻⵛⵛ ⴰⴷ ⵀⵡⵉⵖ ⵓⵛⴰ ⴰⴷ ⴽⵉⴽ ⵙⵙⵉⵡⵍⴻⵖ. ⴰⴷ ⴽⵙⵉⵖ ⵣⵉ ⴰⵔⵔⵓⵃ ⵉ ⵅⴰⴽ ⵉⴵⴰⵏ ⵓⵛⴰ ⴰⴷ ⵅⴰⵙⴻⵏ ⵜ ⵙⵙⴰⵔⵙⴻⵖ. ⴰⵎⵎⵓ ⵉ ⴽⵉⴽ ⵖⴰ ⴰⵔⴱⵓⵏ ⴷⴷⵇⴻⵍ ⵏ ⵍⴳⴻⵏⵙ-ⴰ, ⵎⴰⵃⴻⵏⴷ ⵡⴰⵔ ⵜ ⵜⴰⵔⴻⴱⴱⵓⴷ ⵛⴰ ⵡⴻⵃⵃⴷⴻⴽ. ");
INSERT INTO rift_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","ⴰⴷ ⵜⵉⵏⵉⴷ ⵉ ⵍⴳⴻⵏⵙ: ‘ⵙⵇⴻⴷⴷⵙⴻⵎ ⵉⵅⴻⴼ ⵏⵡⴻⵎ ⵉ ⵜⵉⵡⴻⵛⵛⴰ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⴻⵛⵛⴻⵎ ⴰⵢⵙⵓⵎ, ⵎⵉⵏⵣⵉ ⴰⵇⴰ ⵜⵔⵓⵎ ⴷⴻⴳ ⵉⵎⴻⵣⵣⵓⵖⴻⵏ ⵏ ⵙⵉⴷⵉ, ⵜⴻⵏⵏⴰⵎ: ⵡⵉ ⴷ ⴰⵏⴻⵖ ⵖⴰ ⵉⵡⵛⴻⵏ ⴰⴷ ⵏⴻⵛⵛ ⴰⵢⵙⵓⵎ? ⵜⵓⵖⴰ-ⵏⴻⵖ ⵎⵍⵉⵃ ⴷⵉ ⵎⵉⵚⵔⴰ! ⵙ ⵓⵢⴰ ⵉ ⴷ ⴰⵡⴻⵎ ⵖⴰ ⵉⵡⵛ ⵙⵉⴷⵉ ⴰⵢⵙⵓⵎ ⴰⴷ ⵜⴻⵛⵛⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","ⵡⴰⵔ ⵜ ⵜᵉⵜⵜⴻⵜⵜⴻⵎ ⵉⵊⵊ ⵏ ⵡⴰⵙⵙ ⵡⴰⵀⴰ ⵓⵍⴰ ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵡⵓⵙⵙⴰⵏ, ⵏⵉⵖ ⵅⴻⵎⵙⴰ ⵏ ⵡⵓⵙⵙⴰⵏ, ⵏⵉⵖ ⵄⴻⵛⵔⴰ ⵏ ⵡⵓⵙⵙⴰⵏ, ⵏⵉⵖ ⵄⵉⵛⵔⵉⵏ ⵏ ⵡⵓⵙⵙⴰⵏ, ");
INSERT INTO rift_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","ⵎⴰⵛⴰ ⵎⴰⵔⵔⴰ ⵓⵙⵙⴰⵏ ⵏ ⵓⵢⵓⵔ ⴰⵍ ⴷ ⴰⵡⴻⵎ ⴷⴷ-ⵉⴼⴼⴻⵖ ⵣⴻⴳ ⵡⴻⵏⵣⴰⵔⴻⵏ ⵏⵡⴻⵎ ⵓⵛⴰ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵜⵄⵉⴼⴼⴻⵎ, ⵓⵎⵉ ⵜⴻⵏⴹⴰⵔⴻⵎ ⵙⵉⴷⵉ ⵡⴻⵏⵏⵉ ⵉⴵⴰⵏ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏⵡⴻⵎ, ⵓⵛⴰ ⵜⵔⵓⵎ ⵣⵣⴰⵜ ⵉ ⵓⵖⴻⵎⴱⵓⴱ ⵏⵏⴻⵙ, ⵜⴻⵏⵏⴰⵎ: ⵎⴰⵢⴻⵎⵎⵉ ⵄⴰⴷ ⴷⴷ-ⵏⴻⴼⴼⴻⵖ ⵣⵉ ⵎⵉⵚⵔⴰ?’” ");
INSERT INTO rift_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","ⵓⵛⴰ ⵎⵓⵙⴰ ⵉⵏⵏⴰ: “ⵍⴳⴻⵏⵙ-ⵢⴰ, ⴷⵉ ⵍⵡⴻⵙⵟ ⵏⵙⴻⵏ ⵉ ⴵⵉⵖ, ⴰⵇⴰ-ⵜ ⴷⵉ ⵙⴻⵜⵜⴰ-ⴰⵍⴰⴼ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ ⵅ ⵉⴹⴰⵔⴻⵏ ⵓⵛⴰ ⵛⴻⴽ ⵜⴻⵇⵇⴰⵔⴻⴷ: ‘ⴰⴷ ⴰⵙⴻⵏ ⵡⵛⴻⵖ ⴰⵢⵙⵓⵎ ⵓⵛⴰ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵛⵛⴻⵏ ⵉⵊⵊ ⵏ ⵓⵢⵓⵔ ⴰⵎⴻⵏ ⵉⴽⵎⴻⵍ!’ ");
INSERT INTO rift_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","ⵎⴰⵍⴰ ⵖⴰⵔⵚⴻⵏ ⴰⵙⴻⵏ ⵉ ⵎⴰⵔⵔⴰ ⵡⵓⴵⵉ ⴷ ⵉⴼⵓⵏⴰⵙⴻⵏ, ⵎⴰ ⴰⴷ ⵢⵉⵍⵉ ⵛⴼⴰ ⴰⵙⴻⵏ? ⵏⵉⵖ ⵎⴰⵍⴰ ⵙⵙⵎⵓⵏⴻⵏ ⴰⵙⴻⵏ ⵎⴰⵔⵔⴰ ⵉⵙⴻⵍⵎⴰⵏ ⵏ ⵍⴻⴱⵃⴰⵔ, ⵎⴰ ⴰⴷ ⵢⵉⵍⵉ ⵛⴼⴰ ⴰⵙⴻⵏ?” ");
INSERT INTO rift_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⵎⴰ ⵅⴻⵏⵏⵉ ⵢⴻⴱⵔⵉ ⵓⴼⵓⵙ ⵏ ⵙⵉⴷⵉ? ⵍⴻⵅⵅⵓ ⵅⴻⵏⵏⵉ, ⴰⴷ ⵜⵥⴰⵔⴻⴷ ⵎⴰ ⴰⴷ ⵉⵇⴼⴻⵍ ⴰⵡⴰⵍ ⵏⵏⴻⵙ ⵏⵉⵖ ⵍⵍⴰ!” ");
INSERT INTO rift_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","ⵉⴼⴼⴻⵖ-ⴷⴷ ⵎⵓⵙⴰ ⵓⵛⴰ ⵉⵏⵏⴰ ⴰⵡⴰⵍⴻⵏ ⵏ ⵙⵉⴷⵉ ⵉ ⵍⴳⴻⵏⵙ ⵓⵛⴰ ⵉⵙⵙⵎⵓⵏ ⵙⴻⴱⵄⵉⵏ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ ⵣⴻⴳ ⵉⵎⵖⴰⵔⴻⵏ ⵏ ⵍⴳⴻⵏⵙ ⵓⵛⴰ ⵉⵙⵙⴱⴻⴷⴷ ⵉ-ⵜⴻⵏ ⴰⵎ ⴷⴷ-ⵏⵏⴹⴻⵏ ⵉ ⵓⵇⵉⴹⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","ⵅⴻⵏⵏⵉ ⵉⵀⵡⴰ-ⴷⴷ ⵙⵉⴷⵉ ⴷⴻⴳ ⵓⵙⴻⵢⵏⵓ ⵓⵛⴰ ⵉⵙⵙⵉⵡⴻⵍ ⴰⴽⵉⴷⴻⵙ ⵓⵛⴰ ⵉⴽⵙⵉ ⵣⵉ ⴰⵔⵔⵓⵃ ⵏⵏⵉ ⵜⵓⵖⴰ ⵅⴰⵙ ⵓⵛⴰ ⵉⵙⵙⴰⵔⵙ ⵉ-ⵜ ⵅ ⵙⴻⴱⵄⵉⵏ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ, ⵅ ⵉⵎⵖⴰⵔⴻⵏ. ⵓⵛⴰ ⵉⵎⵙⴰⵔ, ⵓⵎⵉ ⵜⵓⵖⴰ ⵅⴰⵙⴻⵏ ⴰⵔⵔⵓⵃ, ⴱⴷⴰⵏ ⴰⴷ ⵏⴻⴱⴱⴰⵏ, ⵎⴰⵛⴰ ⴰⵡⴰⵔⵏⵉ ⵉ ⵓⵢⴰ ⵡⴰⵔ ⵉⵇⵇⵉⵎ ⵄⴰⴷ. ");
INSERT INTO rift_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","ⵓⵛⴰ ⵇⵇⵉⵎⴻⵏ ⵜⵏⴰⵢⴻⵏ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ ⴷⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ, ⵉⵊⵊⴻⵏ ⵇⵇⴰⵔⴻⵏ ⴰⵙ ⵉⵍⴷⴰⴷ ⵓ ⵡⴻⵏⵏⴻⵖⵏⵉ ⵇⵇⴰⵔⴻⵏ ⴰⵙ ⵎⵉⴷⴰⴷ ⵓⵛⴰ ⴰⵔⵔⵓⵃ ⵏ ⵙⵉⴷⵉ ⵜⵓⵖⴰ-ⵜ ⵅⴰⵙⴻⵏ, ⵎⵉⵏⵣⵉ ⵏⵉⵜⵏⵉ ⴰⵇⴰ ⴰⵜⴻⵏ ⵣⴻⴳ ⵉⵏⵏⵉ ⵢⵓⵔⴰⵏ, ⵎⴰⵛⴰ ⵡⴰⵔ ⴷⴷ-ⴼⴼⵉⵖⴻⵏ ⵖⴰⵔ ⵓⵇⵉⴹⵓⵏ ⵓⵛⴰ ⵜⵓⵖⴰ ⵜⵜⵏⴻⴱⴱⴰⵏ ⴷⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","ⵢⵓⵣⵣⴻⵍ-ⴷⴷ ⵉⵊⵊ ⵏ ⵓⵃⴻⵏⵊⵉⵔ ⵓⵛⴰ ⵉⵅⴻⴱⴱⴰⵔ ⵎⴰⵏ ⴰⵢⴰ ⵉ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: “ⵉⵍⴷⴰⴷ ⴷ ⵎⵉⴷⴰⴷ ⵜⵜⵏⴻⴱⴱⴰⵏ ⴷⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ.” ");
INSERT INTO rift_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","ⵢⴰⵔⵔⴰ-ⴷⴷ ⵢⴰⵛⵓⵡⴰ, ⵎⵎⵉⵙ ⵏ ⵏⵓⵏ, ⵉⵊⵊⴻⵏ ⵣⴻⴳ ⵉⴱⵍⵉⵖⴻⵏ ⵉⵜⵜⴼⴰⵔⵣⴻⵏ, ⵉⵏⵏⴰ: “ⵙⵉⴷⵉ ⵉⵏⵓ, ⵎⵓⵙⴰ, ⵃⴰⵔⵔⴻⵎ ⵉ-ⵜⴻⵏ!” ");
INSERT INTO rift_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","ⵉⵏⵏⴰ ⴰⵙ ⵎⵓⵙⴰ: “ⵎⴰ ⵛⴻⴽ ⵜⴻⵛⴹⴰⵔⴻⴷ ⴷⵉ ⵟⵟⵡⴻⵄ ⵉⵏⵓ? ⵎⵍⵉ ⵎⴰⵔⵔⴰ ⵍⴳⴻⵏⵙ ⵏ ⵙⵉⴷⵉ ⵜⵓⵖⴰ-ⵜ ⵎⴰⵔⵔⴰ ⴷ ⵉⵏⴰⴱⵉⵢⵢⴻⵏ, ⵉⵍⵉ ⵉⴳⴳⴰ ⵅⴰⵙⴻⵏ ⵙⵉⴷⵉ ⴰⵔⵔⵓⵃ ⵏⵏⴻⵙ!” ");
INSERT INTO rift_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","ⵉⴷⵡⴻⵍ-ⴷⴷ ⵎⵓⵙⴰ ⵖⴰⵔ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ, ⵏⴻⵜⵜⴰ ⴷ ⵉⵎⵖⴰⵔⴻⵏ ⵏ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","ⵅⴻⵏⵏⵉ ⵢⵓⵙⴰ-ⴷⴷ ⵉⵊⵊ ⵏ ⵓⵙⴻⵎⵎⵉⴹ, ⵉⵙⵙⴻⴽⴽⴰⵔ ⵉ-ⵜ ⵙⵉⴷⵉ, ⵉⵏⴷⴻⵀ-ⴷⴷ ⵉⵊⴹⴰⴹ ⵇⵇⴰⵔⴻⵏ ⴰⵙ ‘ⵜⵙⴰⵍⵡⴰ’ ⵣⵉ ⵍⴻⴱⵃⴰⵔ ⵓⵛⴰ ⵉⵏⴹⴰⵔ ⵉ-ⵜⴻⵏⵜ ⵅ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ, ⵜⵉⵛⵍⵉ ⵏ ⵡⴻⴱⵔⵉⴷ ⵏ ⵉⵊⵊ ⵏ ⵡⴰⵙⵙ ⵖⴰⵔ ⵉⵊⵊ ⵏ ⵜⵎⴰ ⴷ ⵜⵉⵛⵍⵉ ⵏ ⵡⴻⴱⵔⵉⴷ ⵖⴰⵔ ⵜⵎⴰ ⵏⵏⴻⵖⵏⵉ, ⴷⴻⴳ ⵡⴻⵏⵏⴻⴹ ⵏ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ, ⴰⵍ ⵄⵍⴰⵢⴻⵏ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵖⴰⴵⴻⵏ ⵅ ⵡⵓⴷⴻⵎ ⵏ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","ⵉⴽⴽⴰⵔ ⵍⴳⴻⵏⵙ ⵓⵛⴰ ⴰⵙⵙ ⵏⵏⵉ ⵉⴽⵎⴻⵍ ⴷ ⴵⵉⵍⴻⵜ ⵏⵏⵉ ⵜⴻⴽⵎⴻⵍ ⴷ ⵎⴰⵔⵔⴰ ⴰⵙⵙ ⵉ ⵜ-ⵉ-ⴷⴷ ⵉⴹⴼⴰⵔⴻⵏ ⵢⵔⵓⵏ ⵏⵉⵜⵏⵉ ⵉⵊⴹⴰⴹ ⵇⵇⴰⵔⴻⵏ ⴰⵙ ‘ⵜⵙⴰⵍⵡⴰ’. ⵡⴻⵏⵏⵉ ⵖⴰⵔⴻⵙ ⴷⵔⵓⵙ, ⵉⴽⵙⵉ ⵄⴻⵛⵔⴰ ⵉⵃⵓⵎⵉⵔⴻⵏ. ⴱⴻⵣⵣⵄⴻⵏ ⵜⴻⵏⵜ ⵇⵉⴱⴰⵍⵜ ⵏⵙⴻⵏ ⵅ ⵜⵉⵔⵓ ⵉ ⵉⵏⵏⴹⴻⵏ ⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","ⵎⵉⵏⵜⵔⴰ ⴰⵢⵙⵓⵎ ⵄⴰⴷ ⵊⴰⵔ ⵜⴻⵖⵎⴰⵙ ⵏⵙⴻⵏ, ⵇⴱⴻⵍ ⵎⴰ ⴰⴷ ⵜ ⴼⴼⵥⴻⵏ, ⵢⴰⵔⵖⴰ ⵡⴻⵖⴹⴰⴱ ⵏ ⵙⵉⴷⵉ ⵅ ⵍⴳⴻⵏⵙ ⵓⵛⴰ ⵙⵉⴷⵉ ⵉⵡⵜⴰ ⵍⴳⴻⵏⵙ ⵙ ⵉⵛⵜ ⵏ ⵜⴻⵛⵜⵉ ⵜⴻⵎⵖⴰⵔ ⴰⵟⵟⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","ⵉⵙⴻⵎⵎⴰ ⵎⵓⵙⴰ ⴰⵎⵛⴰⵏ ⵏⵏⵉ ‘ⵇⴰⴱⴰⵔⵓⵜ-ⵀⴰⵜⴰ’ⴰⵡⴰⵜ’, ⵎⵉⵏⵣⵉ ⴷⵉⵏⵏⵉ ⵉ ⵏⴻⴹⵍⴻⵏ ⵍⴳⴻⵏⵙ ⵉ ⵜⵓⵖⴰ ⵉⵎⵎⴻⵥⵔⴻⵏ ⴰⵎⵎⵓ. ");
INSERT INTO rift_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","ⵣⵉ ⵇⴰⴱⴰⵔⵓⵜ-ⵀⴰⵜⴰ’ⴰⵡⴰⵜ ⵉⴼⵙⵉ ⵍⴳⴻⵏⵙ ⵉⵇⵉⴹⴰⵏ ⵏⵏⴻⵙ, ⵓⵢⵓⵔⴻⵏ ⵖⴰⵔ ⵃⴰⴹⴰⵢⵔⵓⵜ ⵓⵛⴰ ⵇⵇⵉⵎⴻⵏ ⴷⵉ ⵃⴰⴹⴰⵢⵔⵓⵜ. ");
INSERT INTO rift_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","ⵜⴻⵙⵙⵉⵡⴻⵍ ⵎⴰⵔⵢⴰⵎ ⴰⴽ-ⴷ ⵀⴰⵔⵓⵏ ⵅ ⵎⵓⵙⴰ ⴷⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⵜⴰⴽⵓⵛⵉⵜ ⵏⵏⵉ ⵜⵓⵖⴰ ⴷⴷ-ⵢⵉⵡⵉ, ⵎⵉⵏⵣⵉ ⵏⴻⵜⵜⴰ ⵢⵉⵡⵉ-ⴷⴷ ⵉⵛⵜ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⵜⴰⴽⵓⵛⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","ⵓⵛⴰ ⵏⵏⴰⵏ: “ⵎⴰ ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⵣⵉ ⵎⵓⵙⴰ ⵡⴰⵀⴰ? ⵎⴰ ⵡⴰⵔ ⵣⵣⴰⵢⵏⴻⵖ ⵉⵙⵙⵉⵡⴻⵍ ⵄⴰⵡⴻⴷ?” ⵓⵛⴰ ⵉⵙⵍⴰ ⵙⵉⴷⵉ ⵎⴰⵏ ⴰⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","ⵜⵓⵖⴰ ⵎⵓⵙⴰ ⴷ ⴰⵔⵢⴰⵣ ⴰⵎⵡⴰⴹⴻⵄ ⴰⵟⵟⴰⵙ, ⴽⵜⴰⵔ ⵣⵉ ⵎⴰⵔⵔⴰ ⵉⵡⴷⴰⵏ ⵉ ⵉⴷⴷⴰⵔⴻⵏ ⵅ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","ⴷⴻⵖⵢⴰ ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ ⴷ ⵎⴰⵔⵢⴰⵎ: “ⴼⴼⵖⴻⵎ ⴽⴻⵏⵏⵉⵡ ⵙ ⵜⵍⴰⵜⴰ, ⵓⵢⵓⵔⴻⵎ ⵖⴰⵔ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ!” ⵓⵛⴰ ⴼⴼⵖⴻⵏ-ⴷⴷ ⵙ ⵜⵍⴰⵜⴰ. ");
INSERT INTO rift_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","ⵅⴻⵏⵏⵉ ⵉⵀⵡⴰ-ⴷⴷ ⵙⵉⴷⵉ ⴷⴻⴳ ⵓⵇⴻⵍⵍⵉⵊ ⵏ ⵓⵙⴻⵢⵏⵓ ⵓⵛⴰ ⵉⴱⴻⴷⴷ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ, ⵉⵍⴰⵖⴰ ⵉ ⵀⴰⵔⵓⵏ ⴷ ⵎⴰⵔⵢⴰⵎ. ⴼⴼⵖⴻⵏ-ⴷⴷ ⵏⵉⵜⵏⵉ ⵙ ⵜⵏⴰⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","ⵓⵛⴰ ⵉⵏⵏⴰ ⴰⵙⴻⵏ ⵏⴻⵜⵜⴰ: “ⵙⵍⴻⵎ ⵅⴻⵏⵏⵉ ⵉ ⵡⴰⵡⴰⵍⴻⵏ ⵉⵏⵓ! ⵎⴰⵍⴰ ⴷⵉⵏ ⵊⴰⵔ ⴰⵡⴻⵎ ⵉⵊⵊ ⵏ ⵓⵏⴰⴱⵉ, ⴰⴷ ⴰⵙ ⵙⵙⴻⵛⵏⴻⵖ ⵉⵅⴻⴼ ⵉⵏⵓ, ⵏⴻⵛⵛ, ⵙⵉⴷⵉ, ⵙ ⵉⵊ ⵏ ⵍⴻⵡⵃⵉⵢ ⵓⵛⴰ ⴰⴷ ⴽⵉⵙ ⵙⵙⵉⵡⵍⴻⵖ ⵙ ⵉⵛⵜ ⵏ ⵜⴰⵔⵊⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","ⵎⴰⵛⴰ ⵡⴰⵔ ⵜⵜⴻⴳⴳⴻⵖ ⴰⵎⴻⵏⵏⵉ ⵙ ⵓⵎⵙⴻⵅⵅⴰⵔ ⵉⵏⵓ ⵎⵓⵙⴰ, ⴰⵇⴰ ⵏⴻⵜⵜⴰ ⴷ ⴰⵎⵜⵉⵇⵇⵉ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵉⵏⵓ ⵜⴻⴽⵎⴻⵍ. ");
INSERT INTO rift_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","ⵏⴻⵛⵛ ⵙⵙⵉⵡⵍⴻⵖ ⴰⴽⵉⴷⴻⵙ ⵣⴻⴳ ⵓⵇⴻⵎⵎⵓⵎ ⵖⴰⵔ ⵓⵇⴻⵎⵎⵓⵎ, ⵡⴰⵔ ⵉⴵⵉ ⵙ ⵍⴻⵎⵄⴰⵏⵉ ⵉⵏⵏⵓⴼⴰⵔⴻⵏ. ⴰⵇⴰ ⵉⵥⵔⴰ ⴰⴷⴷⵓⴷ ⵏ ⵙⵉⴷⵉ. ⵎⴰⵢⴻⵎⵎⵉ ⵡⴰⵔ ⵜⴻⴳⴳⵯⵉⴷⴻⵎ ⵣⴻⴳ ⵓⵎⵙⴻⵅⵅⴰⵔ ⵉⵏⵓ ⵓ ⵎⴰⵢⴻⵎⵎⵉ ⵉ ⵜⴻⵙⵙⵉⵡⵍⴻⵎ ⴰⵎⵎⵓ ⵅ ⵎⵓⵙⴰ?” ");
INSERT INTO rift_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","ⵅⴻⵏⵏⵉ ⵢⴰⵔⵖⴰ ⵅⴰⵙⴻⵏ ⵡⴻⵖⴹⴰⴱ ⵏ ⵙⵉⴷⵉ ⵓⵛⴰ ⵉⵔⵓⵃ. ");
INSERT INTO rift_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","ⵓⵛⴰ ⴰⵙⴻⵢⵏⵓ ⵉⴼⴼⴻⵖ ⵅ ⵓⵇⵉⴹⵓⵏ, ⵓⵛⴰ ⵅⵣⴰⵔ, ⵎⴰⵔⵢⴰⵎ ⴷⴰⵢⴻⵙ ⵍⴻⵀⵍⴰⵛ ⵏ ⵍⴱⴰⵔⵚ, ⴰⵇⴰ-ⵜⵜ ⴷ ⵜⴰⵛⴻⵎⵍⴰⵍⵜ ⴰⵎ ⵡⴻⴷⴼⴻⵍ. ⵓⵛⴰ ⵀⴰⵔⵓⵏ ⵉⵏⵏⴻⵇⵍⴻⴱ-ⴷⴷ ⵖⴰⵔ ⵎⴰⵔⵢⴰⵎ, ⵓ ⵅⵣⴰⵔ, ⴰⵇⴰ ⵏⴻⵜⵜⴰⵜ ⴷⴰⵢⴻⵙ ⵍⴱⴰⵔⵚ. ");
INSERT INTO rift_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","ⵓⵛⴰ ⵉⵏⵏⴰ ⵀⴰⵔⵓⵏ ⵉ ⵎⵓⵙⴰ: “ⴰ, ⵙⵉⴷⵉ ⵉⵏⵓ, ⵡⴰⵔ ⵅⴰⵏⴻⵖ ⵙⵔⵓⵙⵙⵉ ⴷⴷⴻⵏⴱ ⵉ ⵏⴻⴳⴳⴰ ⵙ ⵜⴻⴼⵖⵓⵔⵉ ⵓⵎⵉ ⴷⴰⵢⴻⵙ ⵏⴻⵅⴹⴰ! ");
INSERT INTO rift_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","ⵡⴰⵔ ⵜⵜ ⵜⵜⴻⵊⵊⵉ ⴰⴷ ⵜⴻⴷⵡⴻⵍ ⴰⵎ ⵓⵎⴻⵜⵜⵉⵏ ⵉ ⵣⵉ ⵉⵜⵜⵡⴰⵛⵛ ⵡⴻⵣⵢⴻⵏ ⵏ ⴰⵔⵔⵉⵎⴻⵜ ⵏⵏⴻⵙ ⴰⵎ ⴷⴷ-ⵜⴻⴼⴼⴻⵖ ⵣⵉ ⵍⴻⵎⵍⴰⵡⴻⵜ ⵏ ⵢⴻⵎⵎⴰⵙ.” ");
INSERT INTO rift_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","ⵉⵍⴰⵖⴰ ⵎⵓⵙⴰ ⵉ ⵙⵉⴷⵉ, ⵉⵏⵏⴰ: “ⴰ ⴰⵔⴻⴱⴱⵉ, ⵜⵜⵣⴰⵡⴰⴳⴻⵖ ⴰⴷ ⵜⵜ ⵜⴻⵙⵙⴳⴻⵏⴼⵉⴷ!” ");
INSERT INTO rift_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⵎⴰ ⵎⴰⵍⴰ ⴱⴰⴱⴰⵙ ⴰⵇⴰ ⵉⵏⵅⴰⵔ ⴷⴻⴳ ⵡⵓⴷⴻⵎ ⵏⵏⴻⵙ, ⵎⴰ ⵡⴰⵔ ⵜᵉⵙⴻⴹⵃⵉ ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ? ⴻⵊⵊ ⵉ-ⵜⵜ ⴰⴷ ⵜᵉⵜⵜⵡⴰⵙⵙⵓⴼⴼⴻⵖ ⵣⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⵓⵛⴰ ⴰⵡⴰⵔⵏⵉ ⴰⵙ ⴰⴷ ⵜᵉⵜⵜⵡⴰⵇⴱⴻⵍ ⵄⴰⵡⴻⴷ.” ");
INSERT INTO rift_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","ⵜᵉⵜⵜⵡⴰⵙⵙⵓⴼⴼⴻⵖ ⵎⴰⵔⵢⴰⵎ ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⴱⴰⵔⵔⴰ ⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵓⵛⴰ ⵍⴳⴻⵏⵙ ⵡⴰⵔ ⵉⴽⴽⵉⵙ ⵉⵇⵉⴹⴰⵏ ⵏⵏⴻⵙ ⴰⵍⴰⵎⵉ ⵜᵉⵜⵜⵡⴰⵇⴱⴻⵍ ⵎⴰⵔⵢⴰⵎ ⵄⴰⵡⴻⴷ. ");
INSERT INTO rift_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","ⴰⵡⴰⵔⵏⵉ ⵎⴰⵏ ⴰⵢⴰ ⵉⴼⵙⵉ ⵍⴳⴻⵏⵙ ⵉⵇⵉⴹⴰⵏ ⵏⵏⴻⵙ, ⵢⵓⵢⵓⵔ ⵣⵉ ⵃⴰⴹⴰⵢⵔⵓⵜ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⵍⴻⵅⵍⴰ ⵏ ⴼⴰⵔⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“ⵙⴻⴽⴽ ⵉⵔⵢⴰⵣⴻⵏ ⵣⵣⴰⵜⴻⴽ ⵃⵉⵎⴰ ⴰⴷ ⴱⴻⵔⴳⴰⴳⴻⵏ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ, ⵜⴻⵏⵏⵉ ⵉ ⵖⴰ ⵡⵛⴻⵖ ⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ⵉ ⴽⵓⵍ ⵜⴰⵇⴱⵉⵍⵜ ⵏ ⵍⴻⵊⴷⵓⴷ ⴰⴷ ⵜⴻⵙⵙⴻⴽⴽⴻⵎ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ, ⴽⵓⵍ ⵉⵊⵊ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵍⵃⴰⴽⴻⵎ ⵊⴰⵔ ⴰⵙⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","ⵎⵓⵙⴰ ⵉⵙⵙⴻⴽⴽ ⵉ-ⵜⴻⵏ ⵣⵉ ⵍⴻⵅⵍⴰ ⵏ ⴼⴰⵔⴰⵏ, ⵅ ⵍⵓⵎⵓⵔ ⵏ ⵙⵉⴷⵉ. ⵜⵓⵖⴰ ⵎⴰⵔⵔⴰ ⵉⵔⵢⴰⵣⴻⵏ ⵏⵏⵉ ⴷ ⵉⵣⴻⴵⵉⴼⴻⵏ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","ⴰⵇⴰ ⴷ ⵉⵏⴰ ⴷ ⵉⵙⵎⴰⵡⴻⵏ ⵏⵙⴻⵏ: ⵣⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⵔⵓⴱⵉⵏ, ⵛⴰⵎⵎⵓⵄ, ⵎⵎⵉⵙ ⵏ ⵣⴰⴽⴽⵓⵔ, ");
INSERT INTO rift_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","ⵣⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⵛⵉⵎⵄⵓⵏ, ⵛⴰⴼⴰⵜ, ⵎⵎⵉⵙ ⵏ ⴰⵅⵓⵔⵉ, ");
INSERT INTO rift_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","ⵣⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⵢⴰⵀⵓⴷⴰ, ⴽⴰⵍⵉⴱ, ⵎⵎⵉⵙ ⵏ ⵢⴰⴼⵓⵏⵏⵉ, ");
INSERT INTO rift_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","ⵣⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⵉⵙⵙⴰⴽⴰⵔ, ⵢⵉⵊⵄⴰⵍ, ⵎⵎⵉⵙ ⵏ ⵢⵓⵙⵓⴼ, ");
INSERT INTO rift_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","ⵣⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⵉⴼⵔⴰⵢⵉⵎ, ⵀⵓⵛⴰⵄ, ⵎⵎⵉⵙ ⵏ ⵏⵓⵏ, ");
INSERT INTO rift_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","ⵣⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⴱⵉⵏⵢⴰⵎⵉⵏ, ⴼⴰⵍⵟⵉ, ⵎⵎⵉⵙ ⵏ ⵔⴰⴼⵓ, ");
INSERT INTO rift_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","ⵣⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⵣⴰⴱⵓⵍⵓⵏ, ⵊⴰⴷⴷⵉⵢⵉⵍ, ⵎⵎⵉⵙ ⵏ ⵙⵓⴷⵉ, ");
INSERT INTO rift_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","ⵣⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⵢⵓⵙⵓⴼ, ⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⵎⴰⵏⴰⵙⵙⴰ, ⵊⴰⴷⴷⵉ, ⵎⵎⵉⵙ ⵏ ⵙⵓⵙⵉ, ");
INSERT INTO rift_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","ⵣⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⴷⴰⵏ, ⵄⴰⵎⵎⵉⵢⵉⵍ, ⵎⵎⵉⵙ ⵏ ⵊⴰⵎⴰⵍⵍⵉ, ");
INSERT INTO rift_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","ⵣⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⴰⵛⵉⵔ, ⵙⴰⵜⵓⵔ, ⵎⵎⵉⵙ ⵏ ⵎⵉⵅⴰⵢⵉⵍ, ");
INSERT INTO rift_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","ⵣⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⵏⴰⴼⵜⴰⵍⵉ, ⵏⴰⵃⴱⵉ, ⵎⵎⵉⵙ ⵏ ⵡⴰⴼⵙⵉ, ");
INSERT INTO rift_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","ⵣⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⵊⴰⴷ, ⵊⴰ’ⵓⵢⵉⵍ, ⵎⵎⵉⵙ ⵏ ⵎⴰⴽⵉ. ");
INSERT INTO rift_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","ⴰⵇⴰ ⵉⵏⴰ ⴷ ⵉⵙⵎⴰⵡⴻⵏ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ ⵏⵏⵉ ⵉⵙⵙⴻⴽⴽ ⵎⵓⵙⴰ ⵃⵉⵎⴰ ⴰⴷ ⴱⴻⵔⴳⴰⴳⴻⵏ ⵜⴰⵎⵎⵓⵔⵜ ⵓⵛⴰ ⵎⵓⵙⴰ ⵉⵍⴰⵖⴰ ⵉ ⵀⵓⵛⵉⵄⴰ, ⵎⵎⵉⵙ ⵏ ⵏⵓⵏ, ⵙ ⵢⵉⵙⴻⵎ ⵏ ⵢⴰⵛⵓⵡⴰ. ");
INSERT INTO rift_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","ⵉⵙⵙⴻⴽⴽ ⵉ-ⵜⴻⵏ ⵎⵓⵙⴰ ⵃⵉⵎⴰ ⴰⴷ ⴱⴻⵔⴳⴰⴳⴻⵏ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ, ⵉⵏⵏⴰ ⴰⵙⴻⵏ: “ⴰⵍⵢⴻⵎ ⵙⵙⵉⵀⴰ ⴰⵍ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵍⵊⴰⵏⵓⴱ ⵓⵛⴰ ⴰⵍⵢⴻⵎ ⵅⴻⵏⵏⵉ ⵖⴰⵔ ⵉⴷⵓⵔⴰⵔ, ");
INSERT INTO rift_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","ⵓⵛⴰ ⵅⵣⴰⵔⴻⵎ ⵎⴰⵎⵎⴻⵛ ⵜⴻⴵⴰ ⵜⴻⵎⵎⵓⵔⵜ ⴷ ⵍⴳⴻⵏⵙ ⵉ ⴷⴰⵢⴻⵙ ⵉⵣⴻⴷⴷⵖⴻⵏ, ⵎⴰ ⵉⵊⵀⴻⴷ ⵏⵉⵖ ⵉⴹⵄⴻⴼ ⵉ ⵢⴻⴵⴰ, ⵎⴰ ⴰⵇⴰ ⴷⵉⵏ ⴷⵔⵓⵙ ⵏⵉⵖ ⴰⵟⵟⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","ⵅⵣⴰⵔⴻⵎ ⵄⴰⵡⴻⴷ ⵎⴰⵎⵎⴻⵛ ⵜⴻⴵⴰ ⵜⴻⵎⵎⵓⵔⵜ ⵉ ⴷⵉ ⵉⵣⴻⴷⴷⴻⵖ ⵍⴳⴻⵏⵙ, ⵎⴰ ⵜⴰⵎⵎⵓⵔⵜ ⴷ ⵜⴰⵚⴻⴱⵃⴰⵏⵜ ⵏⵉⵖ ⴷ ⵜⴰⵄⴻⴼⴼⴰⵏⵜ ⵉ ⵜⴻⴵⴰ, ⵓ ⵎⴰⵎⵎⴻⵛ ⴵⴰⵏⵜ ⵜⵏⴻⴷⴷⴰⵎ ⵉ ⴷⵉ ⵉⵣⴻⴷⴷⴻⵖ ⵍⴳⴻⵏⵙ, ⵎⴰ ⵣⴻⴷⴷⵖⴻⵏ ⴷⵉ ⵍⴻⵎⵔⴰⴳⴻⵃ ⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵉⵖ ⴷⵉ ⵜⵏⴻⴷⴷⴰⵎ ⵉⴼⴰⵔⵢⴻⵏ ⵙ ⵉⵖⴻⴱⵍⴰⵡⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","ⵓ ⵄⴰⵡⴻⴷ ⵎⴰⵎⵎⴻⵛ ⵜⴻⴵⴰ ⵜⴻⵎⵎⵓⵔⵜ, ⵎⴰ ⵜⴻⵙⵙⵖⴻⵎⵎⵉ ⵏⵉⵖ ⵜⵓⵥⴻⵖ, ⵎⴰ ⴰⵇⴰ ⴷⵉⵏ ⵜⵉⵛⴻⵊⵊⵓⵔⴰ ⵏⵉⵖ ⵍⵍⴰ. ⴳⴳⴻⵎ ⵜⴰⵔⵢⴰⵙⵜ ⵓⵛⴰ ⴽⵙⵉⵎ ⵛⴰ ⵣⵉ ⵍⵖⵉⴵⴻⵜ ⵏ ⵜⴻⵎⵎⵓⵔⵜ. ⵓⵙⵙⴰⵏ ⵏⵏⵉ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵓⵙⵙⴰⵏ ⵏ ⵜⵎⴻⵏⵣⵓⵜ ⵏ ⵓⴹⵉⵍ.” ");
INSERT INTO rift_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","ⵓⵛⴰ ⵏⵉⵜⵏⵉ ⴳⴻⵄⵄⴷⴻⵏ ⵓⵛⴰ ⴱⴻⵔⴳⴰⴳⴻⵏ ⵜⴰⵎⵎⵓⵔⵜ ⵣⵉ ⵍⴻⵅⵍⴰ ⵏ ⵚⵉⵏ ⴰⵍ ⵔⴰⵃⵓⴱ, ⵎⴰⵏⵉ ⵖⴰ ⵜⵉⵡⴹⴻⴷ ⵖⴰⵔ ⵃⴰⵎⴰⵜ. ");
INSERT INTO rift_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","ⴳⴻⵄⵄⴷⴻⵏ ⵄⴰⴷ ⴽⵜⴰⵔ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵍⵊⴰⵏⵓⴱ ⵓⵛⴰ ⵉⵡⴹⴻⵏ ⵖⴰⵔ ⵃⴰⴱⵔⵓⵏ. ⴷⵉⵏⵏⵉ ⵉ ⵜⵓⵖⴰ ⴰⵅⵉⵎⴰⵏ, ⵛⵉⵛⴰⵢ ⴷ ⵜⴰⵍⵎⴰⵢ, ⵏⵉⵜⵏⵉ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵄⴰⵏⴰⵇ. ⵃⴰⴱⵔⵓⵏ ⵜⵓⵖⴰ ⵜᵉⵜⵜⵡⴰⴱⵏⴰ ⵙⴻⴱⵄⴰ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵇⴱⴻⵍ ⵚⵓⵄⴰⵏ ⴷⵉ ⵎⵉⵚⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","ⵅⴻⵏⵏⵉ ⵉⵡⴹⴻⵏ ⴰⵍ ⵜⴰⵖⵣⵓⵔⵜ ⵏ ⴰⵛⴽⵓⵍ ⵓⵛⴰ ⵙⵙⴻⵏⵏⵉ ⴽⴽⵙⴻⵏ ⵉⵛⵜ ⵏ ⵜⴻⵣⵔⴻⵎⵜ ⵙ ⵢⵉⵊⵊ ⵏ ⵓⵣⴻⴽⴽⵓⵏ ⵏ ⵓⴹⵉⵍ ⵡⴻⵏⵏⵉ ⴷⴷ-ⵉⵡⵢⴻⵏ ⵙ ⵜⵏⴰⵢⴻⵏ ⵙ ⵢⵉⵊⵊ ⵏ ⵓⵣⴻⴵⴰⴹ ⵏ ⵜⵔⴻⴱⴱⵓⵜ. ⴽⴽⵙⴻⵏ ⵄⴰⵡⴻⴷ ⵣⴻⴳ ⴰⵔⴻⵎⵎⴰⵎ ⵓ ⵣⵉ ⵜⴰⵣⴰⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","ⵇⵇⴰⵔⴻⵏ ⴰⵙ ⵉ ⵡⴻⵎⵛⴰⵏ ⵏⵏⵉ ⵜⴰⵖⵣⵓⵔⵜ ⵏ ⵉⵛⴽⵓⵍ, ⵉⵙⴻⵎ ⵡⴰⵏⵉⵜⴰ ⵉⵅⵙ ⴰⴷ ⵢⵉⵏⵉ ‘ⵜⴰⵖⵣⵓⵔⵜ ⵏ ⵓⵣⴻⴽⴽⵓⵏ’, ⴷⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⵓⵣⴻⴽⴽⵓⵏ ⵏ ⵓⴹⵉⵍ ⵏⵏⵉ ⵇⴻⵙⵙⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴷⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","ⵓⵎⵉ ⴽⴻⵎⵎⵍⴻⵏ ⴰⵔⴻⴱⵄⵉⵏ ⵏ ⵡⵓⵙⵙⴰⵏ, ⴷⴻⵡⵍⴻⵏ-ⴷⴷ ⵣⴻⴳ ⵓⴱⴻⵔⴳⴰⴳ ⵏ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","ⵄⴻⵇⴱⴻⵏ ⵏⵉⵜⵏⵉ ⵓⵛⴰ ⵓⵙⵉⵏ-ⴷⴷ ⵖⴰⵔ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ ⵓ ⵖⴰⵔ ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴷⵉ ⵍⴻⵅⵍⴰ ⵏ ⴼⴰⵔⴰⵏ, ⵖⴰⵔ ⵇⴰⴷⴰⵛ, ⵓⵛⴰ ⵡⵛⵉⵏ ⵍⴻⵅⴱⴰⵔ ⵉ ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⵓⵛⴰ ⵙⵙⴻⵛⵏⴻⵏ ⴰⵙⴻⵏ ⵍⵖⵉⴵⴻⵜ ⵏ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","ⵃⴰⵊⴰⵏ ⴰⵙ, ⵏⵏⴰⵏ: “ⴰⵇⴰ ⵏⵓⴷⴻⴼ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⵉ ⵎⴰⵏⵉ ⴷ ⴰⵏⴻⵖ ⵜⴻⵙⵙⴻⴽⴽⴻⴷ. ⵙ ⵜⵉⴷⴻⵜⵜ ⵜⴼⴻⵢⵢⴻⴹ ⵙ ⵓⵖⵉ ⴷ ⵜⴰⵎⵎⴻⵏⵜ ⵓ ⵜⴰⵏⵉⵜⴰ ⴷ ⵍⵖⵉⴵⴻⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","ⵎⴰⵛⴰ ⵍⴳⴻⵏⵙ, ⵡⴻⵏⵏⵉ ⵉⵣⴻⴷⴷⵖⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ, ⵉⵊⵀⴻⴷ ⵓ ⵜⵉⵏⴻⴷⴷⴰⵎ ⵖⴰⵔⵙⴻⵏⵜ ⵉⵖⴻⴱⵔⴰⵡⴻⵏ ⵎⵖⴰⵔⴻⵏⵜ ⴰⵟⵟⴰⵙ, ⵓ ⵏⴻⵥⵔⴰ ⵄⴰⵡⴻⴷ ⴰⵔⵔⴰⵡⴻⵏ ⵏ ⵄⴰⵏⴰⵇ. ");
INSERT INTO rift_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","ⴰⵢⵜ ⵏ ⵄⴰⵎⴰⵍⵉⵇ ⵣⴻⴷⴷⵖⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵍⵊⴰⵏⵓⴱ, ⵓ ⵉⵃⵉⵜⵜⵉⵢⵢⴻⵏ ⴷ ⵉⵢⴰⴱⵓⵙⵉⵢⵢⴻⵏ ⴷ ⵉⵎⵓⵔⵉⵢⵢⴻⵏ ⵣⴻⴷⴷⵖⴻⵏ ⴷⴻⴳ ⵉⴷⵓⵔⴰⵔ ⵓ ⴰⵢⵜ ⵏ ⴽⴻⵏⵄⴰⵏ ⵣⴻⴷⴷⵖⴻⵏ ⵖⴰⵔ ⵍⴻⴱⵃⴰⵔ ⵓ ⵅ ⵜⵎⴰ ⵏ ⵍ’ⵓⵔⴷⵓⵏ.” ");
INSERT INTO rift_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","ⵅⴻⵏⵏⵉ ⵉⵙⵙⴻⵙⵇⴰⵔ ⴽⴰⵍⵉⴱ ⵍⴳⴻⵏⵙ ⵣⵣⴰⵜ ⵉ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: “ⴻⵊⵊ ⴰⵏⴻⵖ ⴰⴷ ⵏⴳⴻⵄⵄⴻⴷ ⵙ ⵊⵊⴻⵀⴷ ⵓⵛⴰ ⴰⴷ ⵜⵜ ⵏⴻⵟⵟⴻⴼ ⴷ ⵍⵡⴰⵔⵜ, ⵎⵉⵏⵣⵉ ⵏⵣⴻⵎⵎⴰⵔ ⴰⵙ ⵏⴻⵛⵛⵉⵏ!” ");
INSERT INTO rift_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","ⵎⴰⵛⴰ ⵉⵔⵢⴰⵣⴻⵏ ⵏⵏⵉ ⴳⴻⵄⵄⴷⴻⵏ ⴰⴽⵉⴷⴻⵙ, ⵏⵏⴰⵏ: “ⵡⴰⵔ ⵏⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵏⴳⴻⵄⵄⴻⴷ ⴹⵉⴷⴷ ⵉ ⵍⴳⴻⵏⵙ ⵏⵏⵉ, ⵎⵉⵏⵣⵉ ⴰⵇⴰ ⵉⵊⵀⴻⴷ ⵅⴰⵏⴻⵖ ⴰⵟⵟⴰⵙ.” ");
INSERT INTO rift_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","ⴰⵎⵎⵓ ⵉ ⴷⴷ-ⵉⵡⵢⴻⵏ ⵉⵊⵊ ⵏ ⵍⴻⵅⴱⴰⵔ ⵡⴰⵔ ⵉⵃⵍⵉⵏ ⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵅ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⵉ ⵅ ⵜⵓⵖⴰ ⵜⵜⴱⴻⵔⴳⴰⴳⴻⵏ, ⵏⵏⴰⵏ: “ⵜⴰⵎⵎⵓⵔⵜ ⵅ ⵎⴰⵏⵉⵙ ⵏⴻⴽⴽⴰ ⵃⵉⵎⴰ ⴰⴷ ⵜⵜ ⵏⴱⴻⵔⴳⴻⴳ, ⴰⵇⴰ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵜⵙⴰⵔⵔⴻⴹ ⵉⵎⴻⵣⴷⴰⵖ ⵏⵏⴻⵙ ⵓⵛⴰ ⵎⴰⵔⵔⴰ ⵉⵡⴷⴰⵏ ⵏⵏⵉ ⵏⴻⵥⵔⴰ, ⴰⵇⴰ ⴰⵜⴻⵏ ⴷ ⵉⵔⵢⴰⵣⴻⵏ ⵏ ⵡⴰⴷⴷⴰⴷ ⵉⵎⵖⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","ⴰⵇⴰ ⵏⴻⵥⵔⴰ ⴷⵉⵏ ‘ⵏⵉⴼⵉⵍⵉⵎ’, ⵉⵅⵙ ⴰⴷ ⵢⵉⵏⵉ ‘ⵊⵊⵡⴰⵀⴻⵍ ⵉⵡⴹⴰⵏ’, ⴰⵢⵜ ⵏ ⵄⴰⵏⴰⵇ, ⴰⵔⵔⴰⵙⴰ ⵏ ⵊⵊⵡⴰⵀⴻⵍ ⵉⵡⴹⴰⵏ. ⵜⵓⵖⴰ ⵏⴻⵛⵛⵉⵏ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵖ ⴰⵎⴻⵛⵏⴰⵡ ⵜⴰⵎⵓⵔⵖⵉ ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⴷⴷ ⴰⵙⴻⵏ ⵏⴻⵜⵜⴱⴰⵏ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵙⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⵜⴻⴱⴷⴰ ⵜⴻⵙⵖⵓⵢⵢⵓ ⵙ ⵊⵊⴻⵀⴷ ⵓⵛⴰ ⵍⴳⴻⵏⵙ ⵉⵔⵓ ⵎⴰⵔⵔⴰ ⴵⵉⵍⴻⵜ ⵏⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","ⵎⴰⵔⵔⴰ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵜⵓⵖⴰ ⵜⵜⵏⴻⴷⵇⴰⵎⴻⵏ ⴹⵉⴷⴷ ⵉ ⵎⵓⵙⴰ ⵓ ⴹⵉⴷⴷ ⵉ ⵀⴰⵔⵓⵏ ⵓⵛⴰ ⵜⴻⵏⵏⴰ ⴰⵙ ⵎⴰⵔⵔⴰ ⵜⵎⴻⵙⵎⵓⵏⵜ: “ⵎⴻⵄⵍⵉⴽ ⵇⴰⵄ ⵏⴻⵎⵎⵓⵜ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ!” ⵏⵉⵖ: “ⵎⴻⵄⵍⵉⴽ ⵇⴰⵄ ⵏⴻⵎⵎⵓⵜ ⴷⵉ ⵍⴻⵅⵍⴰ-ⵢⴰ!” ");
INSERT INTO rift_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","“ⵎⴰⵢⴻⵎⵎⵉ ⴷ ⴰⵏⴻⵖ ⴷⴷ-ⵢⵉⵡⵉ ⵙⵉⴷⵉ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ-ⴰ ⵃⵉⵎⴰ ⴰⴷ ⵏⴻⵡⴹⴰ ⵙ ⵙⵙⵉⴼ ⵓ ⵅⴻⵏⵏⵉ ⴰⴷ ⴷⴻⵡⵍⴻⵏⵜ ⵜⴻⵎⵖⴰⵔⵉⵏ ⵏⵏⴻⵖ ⴷ ⵜⴰⵔⵡⴰ ⵏⵏⴻⵖ ⴷ ⵜⴰⴽⴻⵛⵛⴰⴹⵜ? ⵎⴰ ⵡⴰⵔ ⵢⴻⴵⵉ ⵃⵙⴻⵏ ⵣⴻⵄⵎⴰ ⴰⴷ ⵏⴻⵄⵇⴻⴱ ⵖⴰⵔ ⵎⵉⵚⵔⴰ?” ");
INSERT INTO rift_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","ⵓⵛⴰ ⵏⵏⴰⵏ ⵉⵊⵊ ⵉ ⵡⴻⵏⵏⴻⵖⵏⵉ: “ⴻⵊⵊ ⴰⵏⴻⵖ ⴰⴷ ⵏⴻⴳⴳ ⵉⵊⵊ ⴷ ⴰⵣⴻⴵⵉⴼ ⵅⴰⵏⴻⵖ ⵓⵛⴰ ⴰⴷ ⵏⴻⵄⵇⴻⴱ ⵖⴰⵔ ⵎⵉⵚⵔⴰ!” ");
INSERT INTO rift_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","ⵍⴻⵅⴷⴻⵏⵏⵉ ⵡⴹⴰⵏ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ ⵅ ⵓⵖⴻⵎⴱⵓⴱ ⵏⵙⴻⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵎⴰⵔⵔⴰ ⴰⴳⵔⴰⵡ ⵏ ⵜⵎⴻⵙⵎⵓⵏⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","ⵢⴰⵛⵓⵡⴰ, ⵎⵎⵉⵙ ⵏ ⵏⵓⵏ, ⴷ ⴽⴰⵍⵉⴱ, ⵎⵎⵉⵙ ⵏ ⵢⴰⴼⵓⵏⵏⵉ, ⵉⵏⵏⵉ ⵜⵓⵖⴰ ⵣⴻⴳ ⵉⵏⵏⵉ ⵜⵓⵖⴰ ⵉⵜⵜⴱⴻⵔⴳⴰⴳⴻⵏ ⵅ ⵜⴻⵎⵎⵓⵔⵜ, ⵛⴰⵔⵔⴳⴻⵏ ⴰⵔⵔⵓⴹ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","ⵏⵉⵜⵏⵉ ⵙⵙⵉⵡⵍⴻⵏ ⵖⴰⵔ ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵏⵏⴰⵏ: “ⵜⴰⵎⵎⵓⵔⵜ ⵏⵏⵉ ⵅ ⵏⴻⴽⴽⴰ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⵜ ⵏⴱⴻⵔⴳⴻⴳ, ⴰⵇⴰ-ⵜⵜ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵎⵍⵉⵃ ⴰⵟⵟⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","ⵎⴰⵍⴰ ⵙⵉⴷⵉ ⵉⵙⵙⴼⴰⵔⵏⴻⵏ ⵖⴰⵔⵏⴻⵖ, ⵏⴻⵜⵜⴰ ⴰⴷ ⴰⵏⴻⵖ ⴷⴷ-ⵢⴰⵡⵉ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ-ⴰ ⵓⵛⴰ ⴰⴷ ⴰⵏⴻⵖ ⵜⵜ ⵉⵡⵛ, ⵉⵛⵜ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵉⴼⴻⵢⵢⴹⴻⵏ ⵙ ⵓⵖⵉ ⴷ ⵜⴰⵎⵎⴻⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","ⵎⴰⵛⴰ ⵡⴰⵔ ⵜⵜⵉⵍⵉⵎ ⴷ ⵉⵎⵖⴻⵡⵡⵖⴻⵏ ⴹⵉⴷⴷ ⵉ ⵙⵉⴷⵉ ⵓⵛⴰ ⵡⴰⵔ ⵜⵜⴻⴳⴳⵯⴻⴷⴻⵎ ⵛⴰ ⵣⵉ ⵍⴳⴻⵏⵙ ⵏ ⵜⴻⵎⵎⵓⵔⵜ-ⴰ, ⵎⵉⵏⵣⵉ ⴰⵇⴰ ⴰⵜⴻⵏ ⴷ ⴰⵖⵔⵓⵎ ⵏⵏⴻⵖ. ⵜⵉⵍⵉ ⵏⵙⴻⵏ ⵜⴻⴼⴼⴻⵖ-ⴷⴷ ⵙⴻⵏⵏⴻⵊ ⵏⵙⴻⵏ, ⴰⵇⴰ ⵙⵉⴷⵉ ⴰⴽⵉⴷⵏⴻⵖ, ⵡⴰⵔ ⵣⵣⴰⵢⵙⴻⵏ ⵜⵜⴻⴳⴳⵯⴷⴻⵎ ⵛⴰ!” ");
INSERT INTO rift_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","ⵎⴰⵛⴰ ⵍⴰⵎⵉ ⵜⴻⵙⵙⵉⵡⴻⵍ ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⴱⴻⵍⵍⵉ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜⴻⵏ ⴰⵔⴻⵊⵎⴻⵏ, ⵉⴱⴰⵏ-ⴷⴷ ⵓⵄⵓⴵⵉ ⵏ ⵙⵉⴷⵉ ⴷⴻⴳ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⵣⵣⴰⵜ ⵉ ⵎⴰⵔⵔⴰ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⴰⵍ ⵎⴻⵍⵎⵉ ⴷ ⴰⵢⵉ ⵖⴰ ⵉⵙⵄⴰⵔ ⵍⴳⴻⵏⵙ-ⴰ? ⴰⵍ ⵎⴻⵍⵎⵉ ⵡⴰⵔ ⴷ ⴰⵢⵉ ⵜⵜⵉⵎⵏⴻⵏ ⵙ ⵎⴰⵔⵔⴰ ⵍⴻⵄⵍⴰⵎⴰⵜ ⵏⵏⵉ ⴳⴳⵉⵖ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏⵙⴻⵏ? ");
INSERT INTO rift_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","ⵏⴻⵛⵛ ⴰⴷ ⵜⴻⵏ ⵡⵜⴻⵖ ⵙ ⵟⵟⴰⵄⵓⵏ ⵓⵛⴰ ⴰⴷ ⵅⴰⵙⴻⵏ ⴽⴽⵙⴻⵖ ⵍⵡⴰⵔⵜ ⵓⵛⴰ ⴰⴷ ⵛⴻⴽ ⴳⴳⴻⵖ ⴷ ⵉⵊⵊ ⵏ ⵍⴳⴻⵏⵙ ⴷ ⴰⵎⴻⵇⵇⵔⴰⵏ, ⵉⵊⵀⴻⴷ ⵅⴰⵙⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","ⵉⵏⵏⴰ ⵎⵓⵙⴰ ⵉ ⵙⵉⴷⵉ: “ⴰⴷ ⵙⵍⴻⵏ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ ⵎⴰⵏ ⴰⵢⴰ, ⵎⵉⵏⵣⵉ ⵛⴻⴽ ⵜⴻⵙⵙⵓⴼⴼⵖⴻⴷ ⵍⴳⴻⵏⵙ-ⴰ ⵙ ⵊⵊⴻⵀⴷ ⵏⵏⴻⵛ ⵣⵉ ⵍⵡⴻⵙⵟ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","ⵓⵛⴰ ⴰⴷ ⵜ ⵉⵏⵉⵏ ⵉ ⵉⵎⴻⵣⴷⴰⵖ ⵏ ⵜⴻⵎⵎⵓⵔⵜ-ⴰ, ⵉⵏⵏⵉ ⵉⵙⵍⵉⵏ ⴱⴻⵍⵍⵉ ⵛⴻⴽ, ⴰ ⵙⵉⴷⵉ, ⴷⵉ ⵍⵡⴻⵙⵟ ⵏ ⵍⴳⴻⵏⵙ-ⴰ, ⴱⴻⵍⵍⵉ ⵛⴻⴽ, ⴰ ⵙⵉⴷⵉ, ⵜⴱⴰⵏⴻⴷ-ⴷⴷ ⴰⵎⴻⵛⵏⴰⵡ ⵓⴷⴻⵎ ⴷⴻⴳ ⵡⵓⴷⴻⵎ, ⴱⴻⵍⵍⵉ ⴰⵙⴻⵢⵏⵓ ⵏⵏⴻⵛ ⵉⵜⵜⴱⴻⴷⴷⴰ ⵙⴻⵏⵏⴻⵊ ⵏⵙⴻⵏ ⵓ ⴱⴻⵍⵍⵉ ⵛⴻⴽ ⵜⴻⴳⴳⵓⵔⴻⴷ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏⵙⴻⵏ ⴷⴻⴳ ⵉⵊⵊ ⵏ ⵓⵇⴻⵍⵍⵉⵊ ⵏ ⵓⵙⴻⵢⵏⵓ ⵙ ⵓⵣⵉⵍ ⵓⵛⴰ ⵙ ⴵⵉⵍⴻⵜ ⴷⴻⴳ ⵉⵊⵊ ⵏ ⵓⵇⴻⵍⵍⵉⵊ ⵏ ⵜⵎⴻⵙⵙⵉ.    ");
INSERT INTO rift_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","ⵎⴰⵍⴰ ⵜⴻⵏⵖⵉⴷ ⵍⴳⴻⵏⵙ-ⴰ ⴰⵎ ⵢⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ, ⵅⴻⵏⵏⵉ ⵍⴻⴳⵏⵓⵙ ⵏⵏⵉ ⵉⵙⵍⵉⵏ ⵅ ⵓⵙⴻⵎⵖⴰⵔ ⵏⵏⴻⵛ ⴰⴷ ⵙⵙⵉⵡⵍⴻⵏ ⴰⴷ ⵉⵏⵉⵏ: ");
INSERT INTO rift_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘ⵎⵉⵏⵣⵉ ⵙⵉⴷⵉ ⵡⴰⵔ ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵉⵙⵙⵉⴷⴻⴼ ⵍⴳⴻⵏⵙ-ⴰ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⵉ ⵅ ⵉⵊⵊⵓⴵ ⴰⴷ ⴰⵙⴻⵏ ⵜⵜ ⵉⵡⵛ, ⴰⵇⴰ ⵙ ⵓⵢⴻⵏⵏⵉ ⴷ ⴰⵙⴻⵏ ⵉⵖⴰⵔⵚ ⴷⵉ ⵍⴻⵅⵍⴰ!’ ");
INSERT INTO rift_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","ⵍⴻⵅⵅⵓ ⵅⴻⵏⵏⵉ, ⴻⵊⵊ ⴰⴷ ⵢⵉⵍⵉ ⵊⵊⴻⵀⴷ ⵏ ⵙⵉⴷⵉ ⵉⵏⵓ ⵉⵎⵖⴰⵔ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⵓⵖⴰ ⵜⴻⵙⵙⵉⵡⵍⴻⴷ, ⵜⴻⵏⵏⵉⴷ: ");
INSERT INTO rift_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘ⵙⵉⴷⵉ ⵖⴰⵔⴻⵙ ⵜⵜⴰⵙⵉⵄ ⵏ ⵍⵅⴰⴹⴰⵔ ⵓⵍⴰ ⴷ ⴰⵟⵟⴰⵙ ⵏ ⵜⵎⴻⵅⵙⵉⵡⵜ ⵉⵛⴻⵡⵡⴰⵔⴻⵏ. ⴰⵇⴰ ⵢⴰⵔⴻⴱⴱⵓ ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ ⴷ ⵓⵅⴻⵟⵟⵓ ⵏⵏⴻⵖ ⵓ ⵏⴻⵜⵜⴰ ⵡⴰⵔ ⵉⵜⵜⴱⴰⵔⵔⵉ ⵡⴻⵏⵏⵉ ⵉⵜⵜⴻⴳⴳⴻⵏ ⴷⴷⴻⵏⴱ ⵓ ⵉⵙⵙⴻⵄⵄⴷⵓ ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵖⴰⵔ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ ⴰⵍ ⵊⵊⵉⵍ ⵡⵉⵙⵙ ⵜⵍⴰⵜⴰ ⴷ ⵊⵊⵉⵍ ⵡⵉⵙⵙ ⴰⵔⴻⴱⵄⴰ.’ ");
INSERT INTO rift_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","ⵖⴼⴰⵔ ⵉ ⵍⴳⴻⵏⵙ-ⴰ ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ ⵏⵏⴻⵙ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴻⵎⵖⴰⵔⴻⵜ ⵏ ⵜⵎⴻⵅⵙⵉⵡⵜ ⵏⵏⴻⵛ ⵉⵛⴻⵡⵡⴰⵔⴻⵏ ⵓ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⵀⴻⵎⵍⴻⴷ ⴰⴽ-ⴷ ⵍⴳⴻⵏⵙ-ⴰ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⴰⵍ ⴷⴰⵏⵉⵜⴰ!” ");
INSERT INTO rift_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","ⵉⵏⵏⴰ ⵙⵉⴷⵉ: “ⵏⴻⵛⵛ ⵖⴼⴰⵔⴻⵖ ⴰⵙⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⴰⵡⴰⵍ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","ⵙ ⵜⵉⴷⴻⵜⵜ ⴰⵎ ⴷⴷⴰⵔⴻⵖ ⵏⴻⵛⵛ, ⴰⵇⴰ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⴰⴷ ⵜᵉⵜⵜⵡⴰⵛⵛⵓⵔ ⵙ ⵓⵄⵓⴵⵉ ⵏ ⵙⵉⴷⵉ! ");
INSERT INTO rift_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","ⵎⵉⵏⵣⵉ ⵎⴰⵔⵔⴰ ⵉⵔⵢⴰⵣⴻⵏ ⵏⵏⵉ ⵉⵥⵔⵉⵏ ⴰⵄⵓⴵⵉ ⵉⵏⵓ ⴷ ⵍⴻⵄⵍⴰⵎⴰⵜ ⵉⵏⵓ ⵉ ⴳⴳⵉⵖ ⴷⵉ ⵎⵉⵚⵔⴰ ⵓ ⴷⵉ ⵍⴻⵅⵍⴰ, ⴷ ⵢⵉⵏⵏⵉ ⴷ ⴰⵢⵉ ⵉⵇⴻⴵⴱⴻⵏ ⴷⵉ ⵍⴻⵅⵍⴰ ⵄⴰⴷ ⵄⴻⵛⵔⴰ ⵏ ⵜⵡⴰⵍⴰⵡⵉⵏ ⵓ ⵡⴰⵔ ⵙⵍⵉⵏ ⵉ ⵜⵎⵉⵊⵊⴰ ⵉⵏⵓ, ");
INSERT INTO rift_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","ⵡⴰⵔ ⵥⴰⵔⵔⴻⵏ ⵜⴰⵎⵎⵓⵔⵜ ⵏⵏⵉ ⵅ ⵊⵊⵓⴵⴻⵖ ⵉ ⵍⴻⵊⴷⵓⴷ ⵏⵙⴻⵏ ⴰⴷ ⴰⵙⴻⵏ ⵜⵜ ⵡⵛⴻⵖ, ⵡⴰⵀ, ⵎⴰⵔⵔⴰ ⵉⵏⵏⵉ ⴷ ⴰⵢⵉ ⵉⵙⵙⴷⴷⵓⵇⵇⵣⴻⵏ ⴰⵎⵎⵓ, ⵡⴰⵔ ⵜⵜ ⵥⴰⵔⵔⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","ⵎⴰⵛⴰ ⴰⴷ ⵙⵙⵉⵡⴹⴻⵖ ⴰⵎⵙⴻⵅⵅⴰⵔ ⵉⵏⵓ ⴽⴰⵍⵉⴱ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵎⴰⵏⵉ ⵜⵓⵖⴰ ⵢⵓⴷⴻⴼ ⵇⴱⴻⵍ ⵓⵛⴰ ⴰⴷ ⵜⵜ ⵡⴰⵔⵜⴻⵏ ⵜⴰⵔⵡⴰ ⵏⵏⴻⵙ, ⵎⵉⵏⵣⵉ ⵜⵓⵖⴰ ⴰⴽⵉⴷⴻⵙ ⵉⵊⵊ ⵏ ⴰⵔⵔⵓⵃ ⵏⵏⴻⵖⵏⵉ ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵉⴹⴼⴰⵔ ⴰⵢⵉ ⵏⵉⵛⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","ⴰⵇⴰ ⴰⵢⵜ ⵏ ⵄⴰⵎⴰⵍⵉⵇ ⴷ ⴰⵢⵜ ⵏ ⴽⴻⵏⵄⴰⵏ ⵣⴻⴷⴷⵖⴻⵏ ⴷⵉ ⵍⴻⵡⴹⴰ ⵏ ⵜⴻⵖⵣⵓⵔⵜ. ⴰⴷ ⴷⴷ-ⵜⴷⴻⵡⵍⴻⵎ ⵜⵉⵡⴻⵛⵛⴰ ⵓⵛⴰ ⴰⴷ ⵜⴻⴽⴽⵙⴻⵎ ⵉⵇⵉⴹⴰⵏ ⵏⵡⴻⵎ ⵙⵙⴰ, ⴼⴼⵖⴻⵎ ⵖⴰⵔ ⵍⴻⵅⵍⴰ, ⵓⵢⵓⵔⴻⵎ ⴷⴻⴳ ⵡⴻⴱⵔⵉⴷ ⵖⴰⵔ ⵍⴻⴱⵃⴰⵔ ⵏ ⵜⴻⵍⴳⴰ.” ");
INSERT INTO rift_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“ⴰⵍ ⵎⴻⵍⵎⵉ ⵖⴰ ⵜⴻⵇⵇⵉⵎ ⵜⵎⴻⵙⵎⵓⵏⵜ-ⴰ ⵜⴰⵄⴻⴼⴼⴰⵏⵜ ⵜᵉⵜⵜⵏⴻⴷⵇⴰⵎ ⵅⴰⴼⵉ? ⴰⵏⴻⴷⵇⴻⵎ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵉ ⵣⵉ ⵅⴰⴼⵉ ⵜⵜⵏⴻⴷⵇⴰⵎⴻⵏ, ⴰⵇⴰ ⵙⵍⵉⵖ ⵜ. ");
INSERT INTO rift_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","ⵉⵏⵉ ⴰⵙⴻⵏ: ‘ⵙ ⵜⵉⴷⴻⵜⵜ ⴰⵎ ⴷⴷⴰⵔⴻⵖ ⵏⴻⵛⵛ, ⵉⵇⵇⴰⵔ ⵙⵉⴷⵉ, ⵎⴰⵍⴰ ⵡⴰⵔ ⴷ ⴰⵡⴻⵎ ⵜⵜⴻⴳⴳⴻⵖ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵡⴻⵎ ⵙⵍⵉⵖ ⵙ ⵉⵎⴻⵣⵣⵓⵖⴻⵏ ⵉⵏⵓ ⵎⵉⵏ ⵜⴻⵏⵏⴰⵎ ⴽⴻⵏⵏⵉⵡ. ");
INSERT INTO rift_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","ⵍⵅⴻⵛⴱⴰⵜ ⵏⵡⴻⵎ ⴰⴷ ⵡⴹⴰⵏⵜ ⴷⵉ ⵍⴻⵅⵍⴰ-ⵢⴰ, ⵍⵅⴻⵛⴱⴰⵜ ⵏ ⵎⴰⵔⵔⴰ ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵏ ⵍⴳⴻⵏⵙ, ⵎⴰⵔⵔⴰ ⵍⵇⴻⴷⴷ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵡⴻⵎ ⵣⵉ ⵄⵉⵛⵍⵉⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵙⴻⵏⵏⴻⵊ ⵉ ⵜⵓⵖⴰ ⵅⴰⴼⵉ ⵉⵜⵜⵏⴻⴷⵇⴰⵎⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","ⴽⴻⵏⵏⵉⵡ ⵡⴰⵔ ⵜᵉⵜⵜⵉⴷⴼⴻⵎ ⵛⴰ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵎⵉⵏ ⵅⴻⴼ ⵙⵙⴳⴻⵄⵄⴷⴻⵖ ⴰⴼⵓⵙ ⵉⵏⵓ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵊⵊⴰⴵⴻⵖ ⴰⴷ ⴽⴻⵏⵏⵉⵡ ⴳⴳⴻⵖ ⴰⴷ ⴷⴰⵢⴻⵙ ⵜⵣⴻⴷⵖⴻⵎ, ⵎⵖⵉⵔ ⴽⴰⵍⵉⴱ, ⵎⵎⵉⵙ ⵏ ⵢⴰⴼⵓⵏⵏⵉ, ⴷ ⵢⴰⵛⵓⵡⴰ, ⵎⵎⵉⵙ ⵏ ⵏⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","ⵜⴰⵔⵡⴰ ⵏⵡⴻⵎ ⵉ ⵅⴻⴼ ⵜⴻⵏⵏⴰⵎ: ‘ⴰⴷ ⵜⵜⵡⴰⴽⴻⵛⵛⴹⴻⵏ!’, ⵏⴻⵛⵛ ⴰⴷ ⵜⴻⵏ ⵙⵙⵉⴷⴼⴻⵖ ⴷⴰⵢⴻⵙ ⵓⵛⴰ ⵏⵉⵜⵏⵉ ⴰⴷ ⵙⵙⵏⴻⵏ ⵜⴰⵎⵎⵓⵔⵜ ⵏⵏⵉ ⵜⴻⵏⴹⴰⵔⴻⵎ ⴽⴻⵏⵏⵉⵡ ⴰⵎⵎⵓ ⵙ ⵓⵙⴻⵃⵇⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","ⵎⴰⵛⴰ ⵍⵅⴻⵛⴱⴰⵜ ⵏⵡⴻⵎ, ⵡⴰⵀ, ⴽⴻⵏⵏⵉⵡ ⵙⵉⵎⴰⵏⵜ ⵏⵡⴻⵎ, ⴰⴷ ⵜⴻⵡⴹⴰⵎ ⴷⵉ ⵍⴻⵅⵍⴰ-ⵢⴰ, ");
INSERT INTO rift_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","ⵓⵛⴰ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵡⴻⵎ ⴰⴷ ⵜⴻⵍⵍⵄⴻⵏ ⴷⵉ ⵍⴻⵅⵍⴰ-ⵢⴰ ⵍⵎⵉⵊⴰⵍ ⵏ ⴰⵔⴻⴱⵄⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵓⵛⴰ ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⴽⵉⵡⴻⵎ ⵜⴰⵔⴱⵓⵎ ⴼⴰⵔⵇ-ⵛⵛⵖⴻⵍ ⵏⵡⴻⵎ ⴰⵍ ⵖⴰ ⴼⵏⴰⵏⵜ ⵍⵅⴻⵛⴱⴰⵜ ⵏⵡⴻⵎ ⴷⵉ ⵍⴻⵅⵍⴰ. ");
INSERT INTO rift_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","ⴰⵏⴻⵛⵜ ⵉ ⵍⵇⴻⴷⴷ ⵏ ⵡⵓⵙⵙⴰⵏ ⵉ ⵜⵓⵖⴰ ⵜᵉⵜⵜⴱⴻⵔⴳⴰⴳⴻⵎ ⵜⴰⵎⵎⵓⵔⵜ, ⵉⵇⵇⴰⵔ ⴰⵔⴻⴱⵄⵉⵏ ⵏ ⵡⵓⵙⵙⴰⵏ - ⴰⵇⴰ ⵉⵊⵊ ⵏ ⵡⴰⵙⵙ ⴷ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ - ⴰⴷ ⵜⴰⵔⴱⵓⵎ ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ ⵏⵡⴻⵎ, ⵍⵎⵉⵊⴰⵍ ⵏ ⴰⵔⴻⴱⵄⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ. ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⵜⴻⵙⵙⵏⴻⵎ ⴰⵇⴰ ⵏⴻⵛⵛ ⴱⴻⵄⵄⴷⴻⵖ ⵅⴰⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ ⵙⵙⵉⵡⵍⴻⵖ: ⵎⴰⵍⴰ ⵡⴰⵔ ⵜⵜⴻⴳⴳⴻⵖ ⴰⵎⵎⵓ ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ-ⴰ ⵜⴰⵄⴻⴼⴼⴰⵏⵜ ⵜⴻⵏⵏⵉ ⵉⴽⴽⵙⴻⵏ ⴰⵡⴰⵍ ⵅⴰⴼⵉ: ⴰⴷ ⵎⵎⵜⴻⵏ ⴷⵉ ⵍⴻⵅⵍⴰ-ⵢⴰ, ⴰⴷ ⵎⵎⵜⴻⵏ ⴷⵉⵏ!” ");
INSERT INTO rift_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","ⵉⵔⵢⴰⵣⴻⵏ ⵏⵏⵉ ⵉⵙⵙⴻⴽⴽ ⵎⵓⵙⴰ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴱⴻⵔⴳⴰⴳⴻⵏ ⵜⴰⵎⵎⵓⵔⵜ, ⵍⴰⵎⵉ ⴷⴷ-ⴷⴻⵡⵍⴻⵏ, ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⴰⵎ ⵜⴻⴽⵎⴻⵍ ⵜⴻⴷⵡⴻⵍ ⴹⵉⴷⴷ ⵏⵏⴻⵙ ⵓⵎⵉ ⵏⵉⵜⵏⵉ ⵙⵙⵉⵡⵍⴻⵏ ⵙ ⵍⵖⴰⵔ ⵅ ⵜⴰⵎⵎⵓⵔⵜ, ");
INSERT INTO rift_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","ⴰⵇⴰ ⵉⵔⵢⴰⵣⴻⵏ ⵏⵏⵉ ⵉⴱⴻⵀⴷⵍⴻⵏ ⵜⴰⵎⵎⵓⵔⵜ, ⵎⵎⵓⵜⴻⵏ ⵙ ⵉⵛⵜ ⵏ ⵊⵊⵔⵉⵃⴻⵛⵜ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","ⵎⴰⵛⴰ ⵢⴰⵛⵓⵡⴰ, ⵎⵎⵉⵙ ⵏ ⵏⵓⵏ, ⴷ ⴽⴰⵍⵉⴱ, ⵎⵎⵉⵙ ⵏ ⵢⴰⴼⵓⵏⵏⵉ, ⵇⵇⵉⵎⴻⵏ ⴷⴷⴰⵔⴻⵏ ⵊⴰⵔ ⵉⵔⵢⴰⵣⴻⵏ ⵏⵏⵉ ⵉⵔⵓⵃⴻⵏ ⴰⴷ ⴱⴻⵔⴳⴰⴳⴻⵏ ⵜⴰⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","ⵉⵙⵙⵉⵡⴻⵍ ⵎⵓⵙⴰ ⴰⵡⴰⵍⴻⵏ-ⴰ ⵖⴰⵔ ⵎⴰⵔⵔⴰ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ⵉⵃⵣⴻⵏ ⵅⴻⵏⵏⵉ ⵍⴳⴻⵏⵙ ⴰⵟⵟⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","ⵓⵛⴰ ⵏⵉⵜⵏⵉ ⴽⴽⴰⵔⴻⵏ ⵣⵉⵛ ⵓⵛⴰ ⵓⵍⵢⴻⵏ ⴰⵍ ⵜⴰⵇⵉⵛⵛⴰⵜ ⵏ ⵡⴻⴷⵔⴰⵔ, ⵏⵏⴰⵏ: “ⴰⵇⴰ-ⵏⴻⵖ ⴷⴰ ⵓⵛⴰ ⴰⴷ ⵏⴳⴻⵄⵄⴻⴷ ⵖⴰⵔ ⵡⴻⵎⵛⴰⵏ ⵎⵉⵏ ⵅⴻⴼ ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ, ⵎⵉⵏⵣⵉ ⵏⴻⵛⵛⵉⵏ ⴰⵇⴰ ⵏⴻⵅⴹⴰ!” ");
INSERT INTO rift_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","ⵎⴰⵛⴰ ⵎⵓⵙⴰ ⵉⵏⵏⴰ: “ⵎⴰⵢⴻⵎⵎⵉ ⵜᵉⵜⵜⵄⴻⴷⴷⴰⵎ ⴰⵎⵎⵓ ⵍⵓⵎⵓⵔ ⵏ ⵙⵉⴷⵉ? ⵎⴰⵏ ⴰⵢⴰ ⵡⴰⵔ ⵉⵄⴻⴷⴷⵓ! ");
INSERT INTO rift_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","ⵡⴰⵔ ⵜⵜⴳⴻⵄⵄⵉⴷⴻⵎ ⵛⴰ ⵎⵉⵏⵣⵉ ⵙⵉⴷⵉ ⵡⴰⵔ ⵉⵜⵜⵉⵍⵉ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏⵡⴻⵎ. ⵡⴰⵔ ⵜⵜⴻⵊⵊⵉⵎ ⵉⵅⴻⴼ ⵏⵡⴻⵎ ⴰⴷ ⵜⴻⵅⵙⴰⵔⴻⵎ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵍⵄⴻⴷⵢⴰⵏ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","ⵎⵉⵏⵣⵉ ⴰⵢⵜ ⵏ ⵄⴰⵎⴰⵍⵉⵇ ⴷ ⴰⵢⵜ ⵏ ⴽⴻⵏⵄⴰⵏ ⴰⵇⴰ ⴰⵜⴻⵏ ⴷⵉⵏ ⵣⵣⴰⵜ ⵏⵡⴻⵎ ⵓⵛⴰ ⴰⴷ ⵜⴻⵡⴹⴰⵎ ⴽⴻⵏⵏⵉⵡ ⵙ ⵙⵙⵉⴼ ⵎⵉⵏⵣⵉ ⴽⴻⵏⵏⵉⵡ ⵜⵉⴳⴳⵯⴻⵊⴻⵎ ⵅ ⵙⵉⴷⵉ. ⵙ ⵓⵢⴰ ⵙⵉⴷⵉ ⵡⴰⵔ ⴽⵉⵡⴻⵎ ⵉⵜⵜⵉⵍⵉ.” ");
INSERT INTO rift_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","ⵎⴰⵛⴰ ⵏⵉⵜⵏⵉ ⵜⵓⵖⴰ ⵜⵜⵓⴼⴼⴻⵏ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴷⴷ-ⴰⵍⵢⴻⵏ ⴰⵍ ⵜⴰⵇⵉⵛⵛⴰⵜ ⵏ ⵡⴻⴷⵔⴰⵔ. ⵎⴰⵛⴰ ⵜⵜⴰⴱⵓⵜ ⵏ ⵍⵄⴰⵀⴷ ⵏ ⵙⵉⴷⵉ ⴷ ⵎⵓⵙⴰ ⵡⴰⵔ ⴼⴼⵉⵖⴻⵏ ⵣⵉ ⵍⵡⴻⵙⵟ ⵏ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","ⵅⴻⵏⵏⵉ ⵀⵡⴰⵏ-ⴷⴷ ⴰⵢⵜ ⵏ ⵄⴰⵎⴰⵍⵉⵇ ⴷ ⴰⵢⵜ ⵏ ⴽⴻⵏⵄⴰⵏ ⵏⵏⵉ ⵜⵓⵖⴰ ⵉⵣⴻⴷⴷⵖⴻⵏ ⴷⴻⴳ ⵡⴻⴷⵔⴰⵔ ⵏⵏⵉ ⵓⵛⴰ ⴰⵔⴻⵏⵢⴻⵏ ⵜⴻⵏ ⵓ ⵍⴻⴱⵣⴻⵏ ⵜⴻⵏ ⴰⵍ ⵃⵓⵔⵎⴰ. ");
INSERT INTO rift_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“ⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵉⵏⵉ ⴰⵙⴻⵏ: ‘ⵅⵎⵉ ⵖⴰ ⵜⴰⴷⴼⴻⵎ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵎⴰⵏⵉ ⵖⴰ ⵜⵣⴻⴷⴷⵖⴻⵎ, ⵜⴰⵎⵎⵓⵔⵜ ⵏⵏⵉ ⴷ ⴰⵡⴻⵎ ⵖⴰ ⵡⵛⴻⵖ, ");
INSERT INTO rift_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","ⵓⵛⴰ ⴰⴷ ⵜⴻⵙⵙⵡⴻⵊⴷⴻⵎ ⴷⵉⵏ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ ⵉ ⵙⵉⴷⵉ, ⵉⵛⵜ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵏⵉⵖ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵉ ⵜⵖⴰⵔⵚⵜ ⵉ ⵓⴽⴻⵎⵎⴻⵍ ⵏ ⵉⵊⵊ ⵏ ⵍⵡⴰⵄⴷ ⵏⵉⵖ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵙ ⵍⵅⴰⴹⴰⵔ ⵏⵉⵖ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵉ ⵍⴻⵄⵢⵓⴷⴰⵜ ⵏⵡⴻⵎ ⵉⵜⵜⵡⴰⴳⴳⴻⵏ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⵉⵍⵉ ⴷ ⵉⵛⵜ ⵏ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵉⵜⵜⴼⵓⵃⴻⵏ ⵉ ⵙⵉⴷⵉ, ⵣⵉ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏⵉⵖ ⵣⴻⴳ ⵡⵓⴵⵉ, ");
INSERT INTO rift_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","ⵅⴻⵏⵏⵉ ⵡⴻⵏⵏⵉ ⴷⴷ ⵖⴰ ⵉⵇⴻⴷⴷⵎⴻⵏ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵉ ⵙⵉⴷⵉ, ⴰⴷ ⵢⴰⵡⵉ ⵄⴰⵡⴻⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵣⴻⴳ ⵉⵛⵜ ⵏ ⵜⴻⵄⵛⴰⵔⵜ ⵏ ⵢⵉⵊⵊ ⵏ ⵉⴼⴰ ⵏ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵅⴻⴵⴹⴻⵏ ⵙ ⵢⵉⵊⵊ ⵏ ⴰⵔⴱⴻⵄ ⵏ ⵉⵊⵊ ⵏ ⵓⵀⵉⵏⵓ ⵏ ⵣⵣⴻⵛⵜ. ");
INSERT INTO rift_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","ⴰⴷ ⵜⴻⵙⵙⵡⴻⵊⴷⴻⴷ ⴰⴽ-ⴷ ⵎⴰⵏ ⴰⵢⴰ ⵉⵊⵊ ⵏ ⴰⵔⴱⴻⵄ ⵏ ⵉⵊⵊ ⵏ ⵓⵀⵉⵏⵓ ⵏ ⴱⵉⵏⵓ ⴰⵎ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵓⵙⴻⵢⵢⴻⴱ ⵉ ⴽⵓⵍ ⵉⵊⵊ ⵏ ⵉⵣⵎⴰⵔ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⵉⵍⵉ ⵅ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵏⵉⵖ ⵅ ⵜⴻⵡⵀⵉⴱⵜ ⵉ ⵜⵖⴰⵔⵚⵜ, ");
INSERT INTO rift_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","ⵏⵉⵖ, ⵎⴰⵍⴰ ⴰⴷ ⵜⵉⵍⵉ ⵉ ⵢⵉⵊⵊ ⵏ ⵉⵛⴰⵔⵔⵉ, ⵅⴻⵏⵏⵉ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜⴻⵙⵙⵡⴻⵊⴷⴻⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵣⵉ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵄⵛⵓⵔⴰⵢ ⵏ ⵉⵊⵊ ⵏ ⵉⴼⴰ ⵏ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵅⴻⴵⴹⴻⵏ ⵙ ⵉⵛⵜ ⵏ ⵜⵜⵓⵍⵓⵜ ⵏ ⵉⵊⵊ ⵏ ⵓⵀⵉⵏⵓ ⵏ ⵣⵣⴻⵛⵜ, ");
INSERT INTO rift_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","ⵓⵛⴰ ⴰⴷ ⵜⵇⴻⴷⴷⵎⴻⴷ ⵄⴰⵡⴻⴷ ⵉⵛⵜ ⵏ ⵜⵜⵓⵍⵓⵜ ⵏ ⵉⵊⵊ ⵏ ⵓⵀⵉⵏⵓ ⵏ ⴱⵉⵏⵓ ⴰⵎ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵓⵙⴻⵢⵢⴻⴱ, ⴰⵎ ⵢⵉⵛⵜ ⵏ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵉⵜⵜⴼⵓⵃⴻⵏ ⵉ ⵙⵉⴷⵉ.’” ");
INSERT INTO rift_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“ⵅⵎⵉ ⵖⴰ ⵜⴻⵙⵙⵡⴻⵊⴷⴻⴷ ⴰⵎⴻⵥⵢⴰⵏ ⵏ ⵓⴼⵓⵏⴰⵙ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵏⵉⵖ ⴰⵎ ⵜⴻⵡⵀⵉⴱⵜ ⵉ ⵜⵖⴰⵔⵚⵜ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵢⵉⵍⵉ ⵉ ⵓⴽⴻⵎⵎⴻⵍ ⵏ ⵉⵊⵊ ⵏ ⵍⵡⴰⵄⴷ ⵏⵉⵖ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⵍⴻⵀⵏⴰ ⵉ ⵙⵉⴷⵉ, ");
INSERT INTO rift_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","ⵅⴻⵏⵏⵉ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜⵇⴻⴷⴷⵎⴻⴷ ⴰⴽ-ⴷ ⵓⵎⴻⵥⵢⴰⵏ ⵏ ⵓⴼⵓⵏⴰⵙ ⵄⴰⵡⴻⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵏ ⵜⵍⴰⵜⴰ ⵏ ⵜⴻⵄⵛⵓⵔⴰⵢ ⵏ ⵉⵊⵊ ⵏ ⵉⴼⴰ ⵏ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵅⴻⴵⴹⴻⵏ ⴷⴻⴳ ⵡⴻⵣⵢⴻⵏ ⵏ ⵓⵀⵉⵏⵓ ⵏ ⵣⵣⴻⵛⵜ, ");
INSERT INTO rift_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","ⵓⵛⴰ ⵉⵜⵜⵅⴻⵚⵚⴰ ⵄⴰⵡⴻⴷ ⴰⴷ ⴷⴷ-ⵜⴰⵡⵢⴻⴷ ⴰⵣⵢⴻⵏ ⵏ ⵓⵀⵉⵏⵓ ⵏ ⴱⵉⵏⵓ ⴰⵎ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵓⵙⴻⵢⵢⴻⴱ, ⴰⵎ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ, ⵉⵛⵜ ⵏ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵉⵜⵜⴼⵓⵃⴻⵏ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","ⴰⵎⵎⵓ ⵉ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⴳⴳⴻⵏ ⵉ ⴽⵓⵍ ⴰⴼⵓⵏⴰⵙ, ⵏⵉⵖ ⵉ ⴽⵓⵍ ⵉⵛⴰⵔⵔⵉ, ⵏⵉⵖ ⵉ ⴽⵓⵍ ⵉⵊⵊ ⵣⴻⴳ ⵡⵓⴵⵉ, ⵣⴻⴳ ⵉⵃⵓⵍⵉⵢⵢⴻⵏ ⵏⵉⵖ ⵣⴻⴳ ⵉⵖⴰⵢⴹⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","ⵄⵍⴰⵃⵙⴰⴱ ⵍⵇⴻⴷⴷ ⵏ ⵉⵎⵓⴷⴷⴰⵔⴻⵏ ⵉ ⵜⵖⴰⵔⵚⵜ ⵉ ⵖⴰ ⵜⴻⵙⵙⵡⴻⵊⴷⴻⵎ, ⴰⴷ ⵜⴻⴳⴳⴻⵎ ⴰⵎⵎⵓ ⵉ ⴽⵓⵍ ⵉⵊⵊ ⵏ ⵓⵎⵓⴷⴷⴰⵔ, ⵄⵍⴰⵃⵙⴰⴱ ⵍⵇⴻⴷⴷ ⵉⴽⴻⵎⵎⵍⴻⵏ ⵏ ⵉⵎⵓⴷⴷⴰⵔⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","ⵎⴰⵔⵔⴰ ⵉⵏⵏⵉ ⴷⴷ-ⵉⵜⵜⵡⴰⵅⴻⵍⵇⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⴰⴷ ⴳⴳⴻⵏ ⵜⵉⵎⴻⵙⵍⴰⵢⵉⵏ-ⴰ ⴰⵎⵎⵓ, ⵅⵎⵉ ⴷⴷ ⵖⴰ ⵇⴻⴷⴷⵎⴻⵏ ⵏⵉⵜⵏⵉ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ, ⵉⵛⵜ ⵏ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵉⵜⵜⴼⵓⵃⴻⵏ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","ⵅⵎⵉ ⵖⴰ ⵜⴰⴼⴻⴷ ⵊⴰⵔ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵏⵡⴻⵎ ⵉⵊⵊ ⵏ ⵓⴱⴰⵔⵔⴰⵏⵉ ⵉ ⵉⵇⵇⵉⵎⴻⵏ ⴰⴽⵉⴷⵡⴻⵎ, ⵏⵉⵖ ⵉⵊⵊⴻⵏ ⵡⴻⵏⵏⵉ ⵉⵣⴻⴷⴷⵖⴻⵏ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏⵡⴻⵎ, ⴰⵇⴰ ⵏⴻⵜⵜⴰ ⴰⴷ ⵉⵙⵙⴻⵡⵊⴻⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ, ⵉⵛⵜ ⵏ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵉⵜⵜⴼⵓⵃⴻⵏ ⵉ ⵙⵉⴷⵉ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⵜ ⵉⴳⴳ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⵜ ⵜᵉⵜⵜⴻⴳⴳⴻⵎ ⴽⴻⵏⵏⵉⵡ.” ");
INSERT INTO rift_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","ⴰⵢ, ⴰⴳⵔⴰⵡ ⵏ ⵍⴳⴻⵏⵙ, ⴰⴷ ⴷⵉⵏ ⵜⵉⵍⵉ ⵉⵛⵜ ⵏ ⵜⴻⵡⵚⴻⵢⵢⴻⵜ, ⵉⵛⵜ ⵏ ⵜⴻⵡⵚⴻⵢⵢⴻⵜ ⵉ ⵍⴻⴱⴷⴰ ⵉ ⴽⴻⵏⵏⵉⵡ ⵓ ⵉ ⵓⴱⴰⵔⵔⴰⵏⵉ ⵏⵏⵉ ⴰⴽⵉⴷⵡⴻⵎ ⵉⵇⵇⵉⵎⴻⵏ ⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵏⵡⴻⵎ. ⴰⴷ ⵢⵉⵍⵉ ⵓⴱⴰⵔⵔⴰⵏⵉ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⴻⴵⴰⵎ ⴽⴻⵏⵏⵉⵡ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","ⴰⴷ ⵢⵉⵍⵉ ⵉⵊⵊ ⵏ ⵓⵣⴻⵔⴼ ⴷ ⵉⵛⵜ ⵏ ⵍⴼⴰⵔⵉⴹⴰ ⵉ ⴽⴻⵏⵏⵉⵡ ⵓ ⵉ ⵓⴱⴰⵔⵔⴰⵏⵉ ⵏⵏⵉ ⴰⴽⵉⴷⵡⴻⵎ ⵉⵇⵇⵉⵎⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“ⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵛⴰ ⵉⵏⵉ ⴰⵙⴻⵏ: ‘ⵅⵎⵉ ⵖⴰ ⵜⴰⴷⴼⴻⵎ ⵖⴰⵔ ⵜⴰⵎⵎⵓⵔⵜ ⵎⴰⵏⵉ ⴽⴻⵏⵏⵉⵡ ⵖⴰ ⵢⴰⵡⵢⴻⵖ, ");
INSERT INTO rift_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⵎⵙⴰⵔ, ⵓⵎⵉ ⵖⴰ ⵜⴻⵛⵛⴻⵎ ⴰⵖⵔⵓⵎ ⵣⵉ ⵍⵖⵉⴵⴻⵜ ⵏ ⵜⴻⵎⵎⵓⵔⵜ, ⴰⵇⴰ ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⵜⴻⵙⵙⴳⴻⵄⵄⴷⴻⵎ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵓⵙⴳⴻⵄⵄⴻⴷ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","ⵣⵉ ⵜⵎⴻⵣⵡⴰⵔⵓⵜ ⵏ ⵡⴰⵔⴻⵛⵜⵉ ⵏⵡⴻⵎ ⴰⴷ ⵜⴻⵙⵙⴳⴻⵄⵄⴷⴻⵎ ⵉⵛⵜ ⵏ ⵜⴻⵎⵙⴻⵎⵎⴻⵏⵜ ⴰⵎ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵓⵙⴳⴻⵄⵄⴻⴷ. ⴰⴷ ⵜⵜ ⵜⴻⵙⵙⴳⴻⵄⵄⴷⴻⵎ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⴻⵙⵙⴳⴻⵄⵄⴷⴻⵎ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵓⵙⴳⴻⵄⵄⴻⴷ ⵏ ⵓⵏⴻⴷⵔⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","ⵣⵉ ⵜⵎⴻⵣⵡⴰⵔⵓⵜ ⵏ ⵡⴰⵔⴻⵛⵜⵉ ⵏⵡⴻⵎ ⴰⴷ ⵜⵇⴻⴷⴷⵎⴻⵎ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵓⵙⴳⴻⵄⵄⴻⴷ ⵉ ⵙⵉⴷⵉ ⴷⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵏⵡⴻⵎ.’” ");
INSERT INTO rift_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“ⵎⴰⵍⴰ ⵜⵡⴻⴷⴷⴰⵔⴻⵎ ⵓ ⵡⴰⵔ ⵜᵉⵜⵜⴻⴳⴳⴻⵎ ⵎⴰⵔⵔⴰ ⵍⵓⵎⵓⵔⴰⵜ-ⴰ ⵉ ⵜⵓⵖⴰ ⵉⵙⵙⴰⵡⴰⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ ");
INSERT INTO rift_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","- ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴷ ⴰⵡⴻⵎ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵙ ⵜⵙⴻⵅⵅⴰⵔⵜ ⵏ ⵎⵓⵙⴰ ⵣⴻⴳ ⵡⴰⵙⵙ ⵎⵉⵏ ⵣⵉ ⵜ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ, ⵙⵙⴻⵏⵏⵉ ⴷ ⵜⵙⴰⵡⴻⵏⵜ, ⴷⵉ ⵎⴰⵔⵔⴰ ⵔⴻⵊⵢⵓⵍ ⵏⵡⴻⵎ - ");
INSERT INTO rift_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⵎⵙⴰⵔ, ⵎⴰⵍⴰ ⵉⵜⵜⵡⴰⴳⴳ ⵙ ⵓⵡⴻⴷⴷⴰⵔ ⴱⴰⵔⵔⴰ ⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵜⵎⴻⵙⵎⵓⵏⵜ, ⴰⵇⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⵎⴰⵔⵔⴰ ⴰⴷ ⵜⴻⵙⵙⴻⵡⵊⴻⴷ ⵉⵊⵊ ⵏ ⵓⴼⵓⵏⴰⵙ, ⴰⵎⴻⵥⵢⴰⵏ ⵏ ⵜⴼⵓⵏⴰⵙⵜ, ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ, ⴰⵎ ⵉⵛⵜ ⵏ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵉⵜⵜⴼⵓⵃⴻⵏ ⵉ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵏ ⵍⵖⵉⴵⴻⵜ ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵏ ⵓⵙⴻⵢⵢⴻⴱ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴼⴰⵔⵉⴹⴰ ⵓ ⴰⴽ-ⴷ ⵢⵉⵊⵊ ⵏ ⵓⵎⵢⴰⵏ ⵣⴻⴳ ⵉⵖⴰⵢⴹⴻⵏ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ. ");
INSERT INTO rift_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⴳⴳ ⵓⴽⴻⵀⵀⴰⵏ ⴰⵙⵍⴰⵃ ⵉ ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵛⴰ ⴰⴷ ⴰⵙⴻⵏ ⵉⵜⵜⵡⴰⵖⴼⴰⵔ, ⵎⵉⵏⵣⵉ ⵎⴰⵏ ⴰⵢⴰ ⵉⵎⵙⴰⵔ ⵣⴻⴳ ⵓⵡⴻⴷⴷⴰⵔ, ⵓⵛⴰ ⵏⵉⵜⵏⵉ ⵇⴻⴷⴷⵎⴻⵏ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵙⴻⵏ, ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ ⵉ ⵙⵉⴷⵉ, ⵓⵍⴰ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏⵙⴻⵏ ⵏ ⴷⴷⴻⵏⴱ, ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴰⴷ ⵜᵉⵜⵜⵡⴰⵖⴼⴰⵔ, ⵓⵍⴰ ⴷ ⴰⴱⴰⵔⵔⴰⵏⵉ ⵏⵏⵉ ⵉⵣⴻⴷⴷⵖⴻⵏ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏⵡⴻⵎ, ⵅ ⵓⵎⵉ ⵉⵎⵙⴰⵔ ⴰⵎ ⵉⵡⴻⴷⴷⴰⵔ ⵎⴰⵔⵔⴰ ⵍⴳⴻⵏⵙ.” ");
INSERT INTO rift_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“ⵎⴰⵍⴰ ⵉⵊⵊⴻⵏ ⴱⵏⴰⴷⴻⵎ ⵉⵅⴹⴰ ⴰⵎ ⵏⴻⵜⵜⴰ ⵉⵡⴻⴷⴷⴰⵔ, ⵅⴻⵏⵏⵉ ⴰⴷ ⴷⴷ-ⵉⵙⵙⵇⴰⵔⵔⴻⴱ ⵉⵛⵜ ⵏ ⵜⵖⴰⵢⴹⴻⵜ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ.    ");
INSERT INTO rift_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵉⴳⴳ ⴰⵚⵍⴰⵃ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⵅ ⴱⵏⴰⴷⴻⵎ ⵏⵏⵉ ⵜⵓⵖⴰ ⵉⵡⴻⴷⴷⴰⵔ, ⴰⵎ ⵜⵓⵖⴰ ⵉⵅⴹⴰ ⵙ ⵓⵡⴻⴷⴷⴰⵔ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ, ⴰⵎ ⵅⴰⵙ ⵉ ⵖⴰ ⵢⴻⴳⴳ ⴰⵙⵍⴰⵃ ⵓⵛⴰ ⵅⴻⵏⵏⵉ ⴰⴷ ⴰⵙ ⵉⵜⵜⵡⴰⵖⴼⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","ⴰⴷ ⴷⵉⵏ ⵢⵉⵍⵉ ⵉⵊⵊ ⵏ ⵓⵣⴻⵔⴼ ⵉ ⵡⴻⵏⵏⵉ ⵉⴳⴳⵉⵏ ⵛⴰ ⵙ ⵓⵡⴻⴷⴷⴰⵔ, ⵉ ⵡⴻⵏⵏⵉ ⴷⴷ-ⵉⵅⴻⵍⵇⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵓⵍⴰ ⵉ ⵓⴱⴰⵔⵔⴰⵏⵉ ⵏⵏⵉ ⵉⵣⴻⴷⴷⵖⴻⵏ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏⵡⴻⵎ.” ");
INSERT INTO rift_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“ⵎⴰⵛⴰ ⴱⵏⴰⴷⴻⵎ ⵏⵏⵉ ⵉⴳⴳⵉⵏ ⵛⴰ ⵙ ⵓⴼⵓⵙ ⵉⴳⴻⵄⵄⴷⴻⵏ, ⵎⴰ ⵏⴻⵜⵜⴰ ⵉⵜⵜⵡⴰⵅⵍⴻⵇ-ⴷⴷ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵉⵖ ⵏⴻⵜⵜⴰ ⴷ ⴰⴱⴰⵔⵔⴰⵏⵉ, ⴰⵇⴰ ⵏⴻⵜⵜⴰ ⵉⵛⴻⵇⵇⴻⴼ ⴷⵉ ⵙⵉⴷⵉ ⵓⵛⴰ ⴱⵏⴰⴷⴻⵎ ⵏⵏⵉ ⴰⴷ ⵉⵜⵜⵡⴰⵇⴻⵙⵙ ⵣⵉ ⵍⵡⴻⵙⵟ ⵏ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ, ");
INSERT INTO rift_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","ⵓⵎⵉ ⵉⵙⵙⴻⵃⵇⴰⵔ ⴰⵡⴰⵍ ⵏ ⵙⵉⴷⵉ ⵓ ⵢⴰⵔⵥⴰ ⵍⵓⵎⵓⵔ ⵏⵏⴻⵙ. ⴱⵏⴰⴷⴻⵎ ⵏⵏⵉ ⴰⴷ ⵉⵜⵜⵡⴰⵇⴻⵙⵙ ⵇⴰⵄ ⵣⵉ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ, ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ ⵏⵏⴻⵙ ⴰⴷ ⵜⵉⵍⵉ ⵅⴰⵙ.” ");
INSERT INTO rift_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","ⵍⴰⵎⵉ ⵜⵓⵖⴰ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴷⵉ ⵍⴻⵅⵍⴰ, ⵓⴼⵉⵏ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵉⵜⵜⵃⴰⵔⵡⴰⵛ ⴰⴽⴻⵛⵛⵓⴹ ⴷⴻⴳ ⵡⴰⵙⵙ ⵏ ⵙⵙⴻⴱⵜ. ");
INSERT INTO rift_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","ⵉⵏⵏⵉ ⵜ ⵢⵓⴼⵉⵏ ⴰⵎ ⵜⵓⵖⴰ ⵉⵜⵜⵃⴰⵔⵡⴰⵛ ⴰⴽⴻⵛⵛⵓⴹ, ⵉⵡⵢⴻⵏ ⵜ ⵖⴰⵔ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ ⴷ ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","ⴳⴳⵉⵏ ⵜ ⴷⵉ ⵜⵃⴻⵟⵟⵓⵜ, ⵎⵉⵏⵣⵉ ⵜⵓⵖⴰ ⵡⴰⵔ ⴷⴷ-ⵉⴱⵉⵏ ⵎⵉⵏ ⵣⵣⴰⵢⴻⵙ ⵖⴰ ⴳⴳⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⴰⵔⵢⴰⵣ ⵏⵏⵉ ⴰⴷ ⵉⵜⵜⵡⴰⵏⴻⵖ ⵏⵉⵛⴰⵏ. ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⴰⴷ ⵜ ⵜⴰⵔⵊⴻⵎ ⴱⴰⵔⵔⴰ ⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ.” ");
INSERT INTO rift_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","ⵅⴻⵏⵏⵉ ⵜⴻⵙⵙⵓⴼⴼⴻⵖ ⵉ-ⵜ ⵎⴰⵔⵔⴰ ⵜⵎⴻⵙⵎⵓⵏⵜ ⴱⴰⵔⵔⴰ ⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵓⵛⴰ ⵏⵉⵜⵏⵉ ⴰⵔⴻⵊⵎⴻⵏ ⵜ ⴰⵍⴰⵎⵉ ⵉⵎⵎⵓⵜ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“ⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵛⴰ ⵉⵏⵉ ⴰⵙⴻⵏ, ⴰⴷ ⴳⴳⴻⵏ ⵉ ⵢⵉⵅⴻⴼ ⵏⵙⴻⵏ ⵜⵉⵛⴰⵔⵛⵉⴼⴰ ⵖⴰⵔ ⵜⵖⴻⵎⵎⵓⵔⴰ ⵏ ⵡⴰⵔⵔⵓⴹ ⵏⵙⴻⵏ ⴷⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵏⵙⴻⵏ ⵓⵛⴰ ⴰⴷ ⴳⴳⴻⵏ ⵉⵊⵊ ⵏ ⵓⴼⵉⵍⵓ ⴷ ⴰⴷⴻⵃⵎⵉ ⵖⴰⵔ ⵜⵛⴰⵔⵛⵉⴼⴰ, ⵜⵉⵏⵏⵉ ⵖⴰⵔ ⵜⵖⴻⵎⵎⵓⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","ⴰⴷ ⵢⵉⵍⵉ ⵓⴼⵉⵍⵓ ⵖⴰⵔ ⵜⵛⴰⵔⵛⵉⴼⵜ, ⵃⵉⵎⴰ ⴰⴷ ⵜⵡⴰⵍⴰⵎ ⴰⴼⵉⵍⵓ ⵏⵏⵉ ⵓⵛⴰ ⴰⴷ ⵜⵉⴷⴰⵔⴻⵎ ⴷⵉ ⵎⴰⵔⵔⴰ ⵍⵓⵎⵓⵔⴰⵜ ⵏ ⵙⵉⴷⵉ ⵓⵛⴰ ⴰⴷ ⵜⴻⵏⵜ ⵜⴻⴳⴳⴻⵎ ⵓ ⵡⴰⵔ ⵜⴹⴻⴼⴼⴰⵔⴻⵎ ⵛⵛⴻⵀⵡⴰⵜ ⵏ ⵡⵓⵍⴰⵡⴻⵏ ⵏⵡⴻⵎ ⴷ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵡⴻⵎ, ⵉⵏⵏⵉ ⴰⵡⴰⵔⵏⵉ ⴰⵙⴻⵏⵜ ⵜⴻⵏⵏⵓⵎⴻⵎ ⴰⴷ ⵜⴻⵙⵙⴻⴼⵙⴻⴷⴻⵎ ⵉⵅⴻⴼ ⵏⵡⴻⵎ, ");
INSERT INTO rift_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","ⵓ ⵃⵉⵎⴰ ⴰⴷ ⵜⵅⴰⵔⵔⵚⴻⵎ ⴷⵉ ⵍⵓⵎⵓⵔⴰⵜ ⵉⵏⵓ, ⴰⴷ ⵣⵣⴰⵢⵙⴻⵏⵜ ⵜⴻⴳⴳⴻⵎ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⵉⵍⵉⵎ ⵜᵉⵜⵜⵡⴰⵇⴻⴷⴷⵙⴻⵎ ⵣⵣⴰⵜ ⵉ ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ ⵡⴻⵏⵏⵉ ⴽⴻⵏⵏⵉⵡ ⴷⴷ-ⵉⵙⵙⵓⴼⴼⵖⴻⵏ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⵃⵉⵎⴰ ⴰⴷ ⵉⵍⵉⵖ ⴷ ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ. ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ!” ");
INSERT INTO rift_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","ⵇⵓⵔⴰⵃ, ⵎⵎⵉⵙ ⵏ ⵢⵉⵚⵀⴰⵔ, ⵎⵎⵉⵙ ⵏ ⵇⴰⵀⴰⵜ, ⵎⵎⵉⵙ ⵏ ⵍⴰⵡⵉ, ⴰⴽ-ⴷ ⴷⴰⵜⴰⵏ ⴷ ⴰⴱⵉⵔⴰⵎ, ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵉⵍⵉⵢⴰⴱ, ⴷ ⵓⵏ, ⵎⵎⵉⵙ ⵏ ⴼⴰⵍⴰⵜ, ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵔⵓⴱⵉⵏ, ⵉⵡⵢⴻⵏ ⵉⵔⵢⴰⵣⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","ⵓⵛⴰ ⴽⴽⴰⵔⴻⵏ ⴹⵉⴷⴷ ⵉ ⵎⵓⵙⴰ, ⵊⵎⵉⵄ ⴰⴽ-ⴷ ⵉⵔⵢⴰⵣⴻⵏ ⵏⵏⴻⵖⵏⵉ ⵣⴻⴳ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵎⵉⵜⴰⵢⴻⵏ ⵓ-ⵅⴻⵎⵙⵉⵏ ⵏ ⵍⵃⵓⴽⴽⴰⵎ ⵏ ⵜⵎⴻⵙⵎⵓⵏⵜ, ⴰⵇⴰ ⴰⵜⴻⵏ ⵣⴻⴳ ⵉⵏⵏⵉ ⴷⴷ-ⵉⵜⵜⵡⴰⵍⴰⵖⴰⵏ ⵖⴰⵔ ⵓⵎⵓⵏⵉ, ⵉⵔⵢⴰⵣⴻⵏ ⵙ ⵛⵛⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","ⵏⵉⵜⵏⵉ ⵎⵓⵏⴻⵏ ⴹⵉⴷⴷ ⵉ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ, ⵏⵏⴰⵏ ⴰⵙⴻⵏ: “ⵛⴼⴰ ⴰⵡⴻⵎ ⴽⴻⵏⵏⵉⵡ! ⵎⵉⵏⵣⵉ ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ, ⵡⴰⵀ, ⵎⴰⵔⵔⴰ ⵏⵉⵜⵏⵉ ⴷ ⵉⵎⵇⴻⴷⴷⴰⵙⴻⵏ ⵓⵛⴰ ⵙⵉⴷⵉ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏⵙⴻⵏ. ⵎⴰⵢⴻⵎⵎⵉ ⵜⴻⵙⵙⵓⵄⵍⴰⵎ ⵉⵅⴻⴼ ⵏⵡⴻⵎ ⵙⴻⵏⵏⴻⵊ ⵉ ⵡⴻⴳⵔⴰⵡ ⵏ ⵍⴳⴻⵏⵙ ⵏ ⵙⵉⴷⵉ?” ");
INSERT INTO rift_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","ⵓⵎⵉ ⵉⵙⵍⴰ ⵎⵓⵙⴰ ⵉ ⵎⴰⵏ ⴰⵢⴰ, ⵉⵡⴹⴰ ⵅ ⵡⵓⴷⴻⵎ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","ⵓⵛⴰ ⵉⵙⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⵇⵓⵔⴰⵃ ⴷ ⵎⴰⵔⵔⴰ ⴰⴱⴰⵔⵔⵓ ⵏⵏⴻⵙ, ⵉⵏⵏⴰ: “ⵜⵉⵡⴻⵛⵛⴰ ⴰⴷ ⵉⵙⵙⵛⴻⵏ ⵙⵉⴷⵉ ⵡⴻⵏⵏⵉ ⵉⴵⴰⵏ ⵏⵏⴻⵙ ⴷ ⵡⴻⵏⵏⵉ ⵉⴵⴰⵏ ⴷ ⴰⵎⵇⴻⴷⴷⴰⵙ ⴷ ⵡⴻⵏⵏⵉ ⵉ ⵖⴰⵔⴻⵙ ⴷⴷ ⵖⴰ ⵉⵙⵙⵇⴰⵔⵔⴻⴱ. ⵡⴻⵏⵏⵉ ⵉⴼⴰⵔⵣ ⵏⴻⵜⵜⴰ, ⴷ ⵡⴻⵏⵏⵉ ⵉ ⴷⴷ ⵖⴰ ⵉⵙⵙⵇⴰⵔⵔⴻⴱ ⵏⴻⵜⵜⴰ ⵖⴰⵔⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","ⴳⴳⴻⵎ ⴰⵢⴰ! ⴻⵊⵊ ⵇⵓⵔⴰⵃ ⴷ ⵎⴰⵔⵔⴰ ⴰⴱⴰⵔⵔⵓ ⵏⵏⴻⵙ ⴰⴷ ⴰⵡⵢⴻⵏ ⵜⵉⵎⴻⵊⵎⴰⵔⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","ⵜⵉⵡⴻⵛⵛⴰ ⴳⴳⴻⵎ ⵅⴰⵙⴻⵏⵜ ⵍⴻⴼⵃⴻⵎ ⵉ ⵜⵎⴻⵙⵙⵉ, ⵙⴰⵔⵙⴻⵎ ⵅⴰⵙ ⵍⴻⴱⵅⵓⵔ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⵎⵙⴰⵔ ⴱⴻⵍⵍⵉ ⴰⵔⵢⴰⵣ ⵏⵏⵉ ⵉⵅⴹⴰⵔ ⵙⵉⴷⵉ, ⴰⴷ ⵢⵉⵍⵉ ⴷ ⴰⵎⵇⴻⴷⴷⴰⵙ. ⴰⵇⴰ ⵜⵔⵓⵃⴻⵎ ⵜⵉⴳⴳⵯⵉⵊⴻⵎ, ⴰⵢⵜ ⵏ ⵍⴰⵡⵉ!” ");
INSERT INTO rift_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","ⵉⵏⵏⴰ ⵎⵓⵙⴰ ⵉ ⵇⵓⵔⴰⵃ: “ⵙⵍⴻⵎ ⵍⴻⵅⵅⵓ, ⵜⵜⵣⴰⵡⴰⴳⴻⵖ, ⴽⴻⵏⵏⵉⵡ, ⴰⵢⵜ ⵏ ⵍⴰⵡⵉ! ");
INSERT INTO rift_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","ⵎⴰ ⵡⴰⵔ ⵅⴰⵡⴻⵎ ⵉⵛⴼⵉ ⵓⵎⵉ ⴽⴻⵏⵏⵉⵡ ⵉⵙⵙⴼⴰⵔⵣ ⴰⵔⴻⴱⴱⵉ ⵏ ⵉⵙⵔⴰⵉⵍ ⵅ ⵜⵎⴻⵙⵎⵓⵏⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴽⴻⵏⵏⵉⵡ ⵖⴰⵔⴻⵙ ⴷⴷ-ⵉⵙⵙⵇⴰⵔⵔⴻⴱ, ⵃⵉⵎⴰ ⴰⴷ ⵜⵙⴻⵅⵅⴰⵔⴻⵎ ⴷⵉ ⵜⵣⴻⴷⴷⵉⵖⵜ ⵏ ⵙⵉⴷⵉ ⵓⵛⴰ ⵃⵉⵎⴰ ⴰⴷ ⵜⴱⴻⴷⴷⴻⵎ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵜⵎⴻⵙⵎⵓⵏⵜ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⴻⵏ ⵜⵙⴻⵅⵅⴰⵔⴻⵎ? ");
INSERT INTO rift_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","ⵏⴻⵜⵜⴰ ⵉⵙⵙⵇⴰⵔⵔⴻⴱ ⵉ ⵛⴻⴽ-ⴷⴷ ⵖⴰⵔⴻⵙ, ⵛⴻⴽ ⴷ ⵎⴰⵔⵔⴰ ⴰⵢⵜⵎⴰⵛ, ⴰⵢⵜ ⵏ ⵍⴰⵡⵉ, ⵊⵎⵉⵄ ⴰⴽⵉⴷⴻⴽ. ⵎⴰ ⵜⴰⵔⴻⵣⵣⵓⵎ ⵍⴻⵅⵅⵓ ⵄⴰⵡⴻⴷ ⵜⵓⴽⴻⵀⵀⴰⵏⵜ? ");
INSERT INTO rift_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","ⵙ ⵓⵢⴰ, ⵛⴻⴽ ⴷ ⵎⴰⵔⵔⴰ ⴰⴱⴰⵔⵔⵓ ⵏⵏⴻⵛ, ⴰⵇⴰ ⴽⴻⵏⵏⵉⵡ ⵜⵎⵓⵏⴻⵎ ⴹⵉⴷⴷ ⵏ ⵙⵉⴷⵉ, ⵎⵉⵏⵣⵉ ⵎⵉⵏ ⵉⵄⵏⴰ ⵀⴰⵔⵓⵏ, ⵎⵉⵏ ⵉⵄⵏⴰ ⵃⵉⵎⴰ ⴰⴷ ⵅⴰⵙ ⵜⴻⵏⵏⴻⴷⵇⴻⵎ?” ");
INSERT INTO rift_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","ⵓⵛⴰ ⵉⵙⵙⴻⴽⴽ ⵎⵓⵙⴰ ⴰⴷ ⵍⴰⵖⴰⵏ ⵅ ⴷⴰⵜⴰⵏ ⴷ ⴰⴱⵉⵔⴰⵎ, ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵉⵍⵉⵢⴰⴱ, ⵎⴰⵛⴰ ⵏⵉⵜⵏⵉ ⵏⵏⴰⵏ: “ⵡⴰⵔ ⴷⴷ-ⵏⴻⵜⵜⵉⵙ ⵛⴰ!” ");
INSERT INTO rift_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","ⵎⴰ ⵡⴰⵔ ⵉⴵⵉ ⵉⵛⴼⴰ ⴰⵡⴻⵎ ⵓⵎⵉ ⴷ ⴰⵏⴻⵖ ⴷⴷ-ⵜⵙⵙⵓⴼⴼⵖⴻⵎ ⵣⴻⴳ ⵉⵛⵜ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵉⴼⴻⵢⵢⴹⴻⵏ ⵙ ⵓⵖⵉ ⴷ ⵜⴰⵎⵎⴻⵏⵜ, ⵃⵉⵎⴰ ⴰⴷ ⴰⵏⴻⵖ ⵜⴻⵙⵙⵀⴻⵍⵍⴻⴽⴻⴷ ⴷⵉ ⵍⴻⵅⵍⴰ ⵓⵛⴰ ⵅⴻⵏⵏⵉ ⵄⴰⵡⴻⴷ ⵜⴻⴳⴳⴻⴷ ⵉⵅⴻⴼ ⵏⵏⴻⵛ ⴷ ⵍⵃⴰⴽⴻⵎ ⵅⴰⵏⴻⵖ? ");
INSERT INTO rift_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","ⵓⵍⴰ ⴷ ⵛⴻⴽ ⵡⴰⵔ ⴷ ⴰⵏⴻⵖ ⴷⴷ-ⵜⴻⵙⵙⵉⴷⴼⴻⴷ ⵛⴰ ⴷⴻⴳ ⵉⵛⵜ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵉⴼⴻⵢⵢⴹⴻⵏ ⵙ ⵓⵖⵉ ⴷ ⵜⴰⵎⵎⴻⵏⵜ, ⵓ ⵡⴰⵔ ⴷ ⴰⵏⴻⵖ ⵜⴻⵡⵛⵉⴷ ⵉⵢⵢⴰⵔⴻⵏ ⴷ ⵉⵎⴰⵔⵊⴰⵄⴻⵏ ⵏ ⵓⴹⵉⵍ ⴷ ⵍⵡⴰⵔⵜ. ⵎⴰ ⵉⵜⵜⵖⵉⵍ ⴰⵛ ⵜⵣⴻⵎⵎⴰⵔⴻⴷ ⴰⴷ ⵜⴻⵙⵙⴷⴰⵖⵍⴻⴷ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ-ⴰ? ⵏⴻⵛⵛⵉⵏ ⵡⴰⵔ ⴷⴷ-ⵏⴻⵜⵜⵉⵙ ⵛⴰ!” ");
INSERT INTO rift_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","ⵅⴻⵏⵏⵉ ⵉⵜⵜⵡⴰⵙⵙⴰⵔⵖ ⵓⴼⵓⴳⴻⵎ ⵏ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ ⵉ ⵙⵉⴷⵉ: “ⵡⴰⵔ ⵅⴻⵣⵣⴰⵔ ⵖⴰⵔ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵙⴻⵏ! ⵏⴻⵛⵛ ⵡⴰⵔ ⵣⵣⴰⵢⵙⴻⵏ ⴽⴻⵙⵙⵉⵖ ⵇⴰⵄ ⵉⵊⵊ ⵏ ⵓⵖⵢⵓⵍ ⵓⵛⴰ ⵡⴰⵔ ⴳⴳⵉⵖ ⵍⵖⴰⵔ ⵓⵍⴰ ⵉ ⵢⵉⵊⵊ ⵣⵣⴰⵢⵙⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","ⵉⵏⵏⴰ ⵎⵓⵙⴰ ⵉ ⵇⵓⵔⴰⵃ: “ⵛⴻⴽ ⴷ ⵎⴰⵔⵔⴰ ⴰⴱⴰⵔⵔⵓ ⵏⵏⴻⵛ, ⴰⵙⴻⵎ-ⴷⴷ ⵜⵉⵡⴻⵛⵛⴰ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ, ⵛⴻⴽ ⴷ ⵏⵉⵜⵏⵉ, ⴷ ⵀⴰⵔⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","ⴽⵙⵉⵎ ⴽⵓⵍ ⵉⵊⵊ ⵣⵣⴰⵢⵡⴻⵎ ⵉⵊⵊ ⵏ ⵍⵎⴻⵊⵎⴰⵔ, ⴳⴳⴻⵎ ⴷⴰⵢⴻⵙ ⵍⴻⴱⵅⵓⵔ ⵓⵛⴰ ⵇⴰⵔⵔⴱⴻⵎ-ⴷⴷ ⴰⴽⵉⴷⴻⵙ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ⴽⵓⵍ ⴰⵔⵢⴰⵣ ⴰⴽ-ⴷ ⵍⵎⴻⵊⵎⴰⵔ ⵏⵏⴻⵙ, ⵎⵉⵜⴰⵢⴻⵏ ⵓ-ⵅⴻⵎⵙⵉⵏ ⵏ ⵜⵎⴻⵊⵎⴰⵔⵉⵏ, ⵓⵛⴰ ⵄⴰⵡⴻⴷ ⵛⴻⴽ ⴷ ⵀⴰⵔⵓⵏ, ⴽⵓⵍ ⵉⵊⵊ ⴰⴽ-ⴷ ⵍⵎⴻⵊⵎⴰⵔ ⵏⵏⴻⵙ.” ");
INSERT INTO rift_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","ⵉⴽⵙⵉ ⴽⵓⵍ ⵉⵊⵊ ⵍⵎⴻⵊⵎⴰⵔ ⵏⵏⴻⵙ ⵓⵛⴰ ⴳⴳⵉⵏ ⴷⴰⵢⴻⵙ ⵜⵉⵎⴻⵙⵙⵉ ⵓ ⵙⵙⴰⵔⵙⴻⵏ ⵅⴰⵙ ⵍⴻⴱⵅⵓⵔ ⵓⵛⴰ ⵓⵢⵓⵔⴻⵏ ⴰⴷ ⴱⴻⴷⴷⴻⵏ ⵣⵣⴰⵜ ⵉ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ⵓⵍⴰ ⴷ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","ⵇⵓⵔⴰⵃ ⵉⵖⴻⵡⵡⴻⵖ ⵅⴰⵙⴻⵏ ⵎⴰⵔⵔⴰ ⴰⴱⴰⵔⵔⵓ ⵏⵏⴻⵙ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ⵍⴻⵅⴷⴻⵏⵏⵉ ⵉⴱⴰⵏ-ⴷⴷ ⵓⵄⵓⴵⵉ ⵏ ⵙⵉⴷⵉ ⵖⴰⵔ ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“ⵃⴻⵢⴷⴻⵎ ⵉⵅⴻⴼ ⵏⵡⴻⵎ ⵣⴻⴳ ⵓⴱⴰⵔⵔⵓ-ⵢⴰ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⴻⵏ ⵀⴻⵍⵍⴽⴻⵖ ⴷⴻⴳ ⵡⴻⵔⵎⴰⵛ ⵏ ⵡⴰⴱⵍⵉⵡⴻⵏ!” ");
INSERT INTO rift_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","ⵎⴰⵛⴰ ⵏⵉⵜⵏⵉ ⵡⴹⴰⵏ ⵅ ⵡⵓⴷⴻⵎ ⵏⵙⴻⵏ, ⵏⵏⴰⵏ: “ⴰ ⴰⵔⴻⴱⴱⵉ, ⴰⵔⴻⴱⴱⵉ ⵏ ⵎⴰⵔⵔⴰ ⴱⵓⵃⴱⴻⵍⴰⵜ ⵏ ⵎⴰⵔⵔⴰ ⴷⴷⴰⵜ! ⵎⴰⵍⴰ ⵉⵅⴹⴰ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ, ⵎⴰ ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⴻⴳⴳⴻⴷ ⴰⵖⴹⴰⴱ ⵏⵏⴻⵛ ⴰⴷ ⵉⴷⴷⵓⵇⵇⴻⵣ ⵅ ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ?” ");
INSERT INTO rift_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“ⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⵜⵎⴻⵙⵎⵓⵏⵜ, ⵉⵏⵉ: ‘ⴱⴻⵄⵄⴷⴻⵎ ⵅ ⵜⵣⴻⴷⴷⵉⵖⵜ ⵏ ⵇⵓⵔⴰⵃ ⴷ ⴷⴰⵜⴰⵏ ⴷ ⴰⴱⵉⵔⴰⵎ ⴷ ⵎⵉⵏ ⴷ ⴰⵙ ⴷⴷ-ⵉⵏⵏⴹⴻⵏ.’” ");
INSERT INTO rift_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","ⵅⴻⵏⵏⵉ ⵎⵓⵙⴰ ⵉⴽⴽⴰⵔ ⵓⵛⴰ ⵉⵔⵓⵃ ⵖⴰⵔ ⴷⴰⵜⴰⵏ ⴷ ⴰⴱⵉⵔⴰⵎ ⵓⵛⴰ ⵓⵢⵓⵔⴻⵏ ⵉⵎⵖⴰⵔⴻⵏ ⵏ ⵉⵙⵔⴰⵉⵍ ⴰⵡⴰⵔⵏⵉ ⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","ⵓⵛⴰ ⵉⵙⵙⵉⵡⴻⵍ ⵏⴻⵜⵜⴰ ⴰⴽ-ⴷ ⵜⵎⴻⵙⵎⵓⵏⵜ, ⵉⵏⵏⴰ: “ⵜⵜⵣⴰⵡⴳⴻⵖ, ⴱⴻⵄⵄⴷⴻⵎ ⵅ ⵉⵇⵉⴹⴰⵏ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ-ⴰ ⵉⵇⴻⵊⵃⴻⵏ ⵓ ⵡⴰⵔ ⵜⵜⵃⴰⴷⴰⵎ ⵓⵍⴰ ⴷ ⵉⵛⵜ ⵏ ⵍⵃⴰⵊⵊⴻⵜ ⵏ ⵎⵉⵏ ⵉⴵⴰⵏ ⵏⵙⴻⵏ, ⵃⵉⵎⴰ ⴽⴻⵏⵏⵉⵡ ⵡⴰⵔ ⵜᵉⵜⵜⵡⴰⵀⴻⵍⵍⵉⴽⴻⵎ ⵛⴰ ⵙ ⴷⴷⵏⵓⴱ ⵏⵙⴻⵏ!” ");
INSERT INTO rift_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","ⴽⴽⴰⵔⴻⵏ ⵏⵉⵜⵏⵉ ⵓⵛⴰ ⴱⴻⵄⵄⴷⴻⵏ ⵅ ⵉⵇⵉⴹⴰⵏ ⵏ ⵇⵓⵔⴰⵃ ⴷ ⴷⴰⵜⴰⵏ ⴷ ⴰⴱⵉⵔⴰⵎ ⴷ ⵎⵉⵏ ⴷ ⴰⵙ ⴷⴷ-ⵉⵏⵏⴹⴻⵏ. ⴷⴰⵜⴰⵏ ⴷ ⴰⴱⵉⵔⴰⵎ ⴼⴼⵖⴻⵏ-ⴷⴷ, ⴱⴻⴷⴷⴻⵏ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴰⴽ-ⴷ ⵜⴻⵎⵖⴰⵔⵉⵏ ⵏⵙⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵙⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵙⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵎⵓⵙⴰ: “ⵙ ⵎⴰⵏ ⴰⵢⴰ ⵉ ⵖⴰ ⵜⴻⵙⵙⵏⴻⵎ ⴱⴻⵍⵍⵉ ⵙⵉⴷⵉ ⵉⵙⵙⴻⴽⴽ ⴰⵢⵉ-ⴷⴷ, ⵃⵉⵎⴰ ⴰⴷ ⴳⴳⴻⵖ ⵎⴰⵔⵔⴰ ⵜⵉⵎⴻⴳⴳⴰ-ⵢⴰ, ⵎⵉⵏⵣⵉ ⵡⴰⵔ ⴷⴷ-ⴼⴼⵉⵖⴻⵏⵜ ⵛⴰ ⵣⴻⴳ ⵡⵓⵍ ⵉⵏⵓ. ");
INSERT INTO rift_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","ⵎⴰⵍⴰ ⵉⵏⴰ ⴰⴷ ⵎⵎⵜⴻⵏ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵎⵎⵓⵜⴻⵏ ⵉⵡⴷⴰⵏ ⵎⴰⵔⵔⴰ ⵓ ⴰⴷ ⵜⴻⵏ ⵉⵍⵇⴻⴼ ⵎⵉⵏ ⵉⵍⴻⵇⴼⴻⵏ ⵎⴰⵔⵔⴰ ⵉⵡⴷⴰⵏ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⴰⴼ ⵙⵉⴷⵉ ⵡⴰⵔ ⴷ ⴰⵢⵉ ⴷⴷ-ⵉⵙⵙⴻⴽⴽ. ");
INSERT INTO rift_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⵙⵉⴷⵉ ⵉⵅⵍⴻⵇ-ⴷⴷ ⵛⴰ ⵏ ⵍⵃⴰⵊⵊⴻⵜ ⴷ ⵜⴰⵎⴰⵢⵏⵓⵜ ⵇⴰⵄ ⵓⵛⴰ ⵜⴰⵎⵎⵓⵔⵜ ⴰⴷ ⵜⴰⵔⵣⴻⵎ ⴰⵇⴻⵎⵎⵓⵎ ⵏⵏⴻⵙ, ⴰⴷ ⵜⴻⵏ ⵜⵙⴰⵔⴹ ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⴵⴰⵏ ⵏⵙⴻⵏ ⵓⵛⴰ ⴰⴷ ⵀⵡⴰⵏ ⴷⴷⴰⵔⴻⵏ ⴷⵉ ⵍⴰⵅⴰⵔⵜ, ⵅⴻⵏⵏⵉ ⵉ ⵖⴰ ⵜⴻⵙⵙⵏⴻⵎ ⴱⴻⵍⵍⵉ ⵉⵔⵢⴰⵣⴻⵏ-ⴰ ⴰⵇⴰ ⵙⵙⴷⵓⵇⵇⵣⴻⵏ ⵙⵉⴷⵉ.” ");
INSERT INTO rift_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","ⵓⵛⴰ ⵉⵎⵙⴰⵔ, ⵓⵎⵉ ⵉⴽⴻⵎⵎⴻⵍ ⴰⵡⴰⵍⴻⵏ-ⴰ, ⵜⴼⴻⴵⴻⵇ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⵉ ⵙⵡⴰⴷⴷⴰⵢ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","ⵜⴰⵔⵣⴻⵎ ⵜⴻⵎⵎⵓⵔⵜ ⴰⵇⴻⵎⵎⵓⵎ ⵏⵏⴻⵙ ⵓⵛⴰ ⵜⵙⴰⵔⴹ ⵉ-ⵜⴻⵏ ⴰⴽ-ⴷ ⴰⵢⵜⴱⴰⴱ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵙⴻⵏ ⵓ ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⵉⵡⴷⴰⵏ ⵏ ⵇⵓⵔⴰⵃ ⴷ ⵎⴰⵔⵔⴰ ⴰⴳⵍⴰ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","ⵀⵡⴰⵏ-ⴷⴷ ⴷⴷⴰⵔⴻⵏ ⴷⵉ ⵍⴰⵅⴰⵔⵜ ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⴵⴰⵏ ⵏⵙⴻⵏ ⵓⵛⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵜⴻⵙⵙⴷⵓⵔⵉⵢ ⵉ-ⵜⴻⵏ ⵓ ⵜⵜⵡⴰⵜⴻⵃⵃⴰⵏ ⵣⵉ ⵍⵡⴻⵙⵟ ⵏ ⵡⴻⴳⵔⴰⵡ ⵏ ⵍⴳⴻⵏⵙ. ");
INSERT INTO rift_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","ⵎⴰⵔⵔⴰ ⵉⵙⵔⴰⵉⵍ, ⵉⵏⵏⵉ ⵜⵓⵖⴰ ⴷⴷ-ⵉⵏⵏⴹⴻⵏ, ⴰⵔⴻⵡⵍⴻⵏ ⵓⵎⵉ ⵙⵍⵉⵏ ⵉ ⵜⵖⵓⵢⵢⵉⵜ ⵏⵙⴻⵏ, ⵎⵉⵏⵣⵉ ⵏⵏⴰⵏ: “ⵏⵉⵖ ⴰⴷ ⵜⴰⴼ ⵓⵍⴰ ⴷ ⵏⴻⵛⵛⵉⵏ ⴰⴷ ⴰⵏⴻⵖ ⵜⵚⴰⵔⴹ ⵜⴻⵎⵎⵓⵔⵜ.” ");
INSERT INTO rift_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","ⵓⵛⴰ ⵜⴻⴼⴼⴻⵖ-ⴷⴷ ⵜⵎⴻⵙⵙⵉ ⵣⵉ ⵙⵉⴷⵉ, ⵜⴻⵛⵛⴰ ⵎⵉⵜⴰⵢⴻⵏ ⵓ-ⵅⴻⵎⵙⵉⵏ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ ⵏⵏⵉ ⴷⴷ-ⵢⵉⵡⵢⴻⵏ ⵍⴻⴱⵅⵓⵔ. ");
INSERT INTO rift_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“ⵉⵏⵉ ⵉ ⴰⵍⵉⵄⴰⵣⴰⵔ, ⵎⵎⵉⵙ ⵏ ⵓⴽⴻⵀⵀⴰⵏ ⵀⴰⵔⵓⵏ, ⴱⴻⵍⵍⵉ ⴰⴷ ⵉⴽⵙⵉ ⵜⵉⵎⴻⵊⵎⴰⵔⵉⵏ ⵣⴻⴳ ⵓⵃⴰⴷⵓⵇ ⵏ ⵜⵎⴻⵙⵙⵉ ⵓⵛⴰ ⴰⴷ ⵉⵙⵙⵓⵢⴻⵙ ⵎⵉⵏ ⵉⵇⵇⵉⵎⴻⵏ ⵏ ⵜⵎⴻⵙⵙⵉ ⴷⵉ ⵍⴰⴳⴳⵯⴰⵊ, ⵎⵉⵏⵣⵉ ⴰⵇⴰ ⵜⵉⵎⴻⵊⵎⴰⵔⵉⵏ ⵏⵏⵉ, ⵇⴻⴷⴷⵙⴻⵏⵜ ⵉ ⴵⴰⵏⵜ! ");
INSERT INTO rift_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","ⵊⵊⴻⵎ ⵜⴻⵏ ⴰⴷ ⴳⴳⴻⵏ ⵣⵉ ⵜⵎⴻⵊⵎⴰⵔⵉⵏ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ-ⴰ, ⵉⵏⵏⵉ ⵜⵓⵖⴰ ⵉⵅⴻⵟⵟⴰⵏ ⴹⵉⴷⴷ ⵉ ⵍⴻⵄⵎⵓⵔ ⵏⵙⴻⵏ, ⵜⵉⵍⵡⵉⵃⵉⵏ ⴷ ⵜⵉⵣⵉⵔⴰⵔⵉⵏ ⵉ ⴷⴷⵓⵔⵉ ⵉ ⵓⵄⴰⵍⵟⴰⵔ, ⵎⵉⵏⵣⵉ ⵉⵡⵢⴻⵏ ⵜⴻⵏⵜ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ, ⵙ ⵓⵢⴰ ⵜⵜⵡⴰⵇⴻⴷⴷⵙⴻⵏⵜ ⵜⵉⵏⴰ. ⴰⴷ ⵉⵍⵉⵏⵜ ⴷ ⵉⵊⵊ ⵏ ⵓⵛⴻⵢⵢⴰⵔ ⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ.” ");
INSERT INTO rift_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","ⵅⴻⵏⵏⵉ ⵉⴽⵙⵉ ⵓⴽⴻⵀⵀⴰⵏ ⴰⵍⵉⵄⴰⵣⴰⵔ ⵜⵉⵎⴻⵊⵎⴰⵔⵉⵏ ⵏ ⵏⵏⵃⴰⵙ ⵏⵏⵉ ⴷⴷ-ⵉⵡⵢⴻⵏ ⵢⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵛⴻⵎⴹⴻⵏ ⵉ ⵜⴻⵡⵀⵉⴱⵜ, ⵓⵛⴰ ⵜⴽⴻⵜⴽⴻⵏ ⵜⴻⵏⵜ ⵃⵉⵎⴰ ⴰⴷ ⵣⵣⴰⵢⵙⴻⵏⵜ ⴷⵍⴻⵏⵜ ⴰⵄⴰⵍⵟⴰⵔ ");
INSERT INTO rift_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","ⵉ ⵍⵉⴷⴰⵔⴻⵜ ⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵃⵉⵎⴰ ⵓⵍⴰ ⴷ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵡⴰⵔ ⵉⴵⵉⵏ ⵣⵉ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏ ⵀⴰⵔⵓⵏ, ⵡⴰⵔ ⴷⴷ-ⵉⵜⵜⵇⴰⵔⵔⵉⴱ ⵛⴰ ⴱⵍⴰ ⵜⵜⴻⵙⵔⵉⵃ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ, ⵃⵉⵎⴰ ⴰⴷ ⵉⵙⵙⴱⴻⵅⵅⴰⵔ ⵍⴻⴱⵅⵓⵔ, ⵎⴰⵃⴻⵏⴷ ⵡⴰⵔ ⴷ ⴰⵙ ⵉⵍⵇⴻⴼ ⵎⵉⵏ ⵉⵍⴻⵇⴼⴻⵏ ⵇⵓⵔⴰⵃ ⴷ ⵓⴱⴰⵔⵔⵓ ⵏⵏⴻⵙ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⵓⵖⴰ ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⵙ ⵓⵇⴻⵎⵎⵓⵎ ⵏ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","ⵜⵉⵡⴻⵛⵛⴰ ⵏⵏⴻⵙ ⵜⵓⵖⴰ ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵜᵉⵜⵜⵏⴻⴷⵇⴰⵎ ⴹⵉⴷⴷ ⵉ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ, ⵏⵏⴰⵏ: “ⴽⴻⵏⵏⵉⵡ ⵜⴻⵏⵖⵉⵎ ⵍⴳⴻⵏⵙ ⵏ ⵙⵉⴷⵉ!” ");
INSERT INTO rift_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","ⵓⵛⴰ ⵓⵎⵉ ⵜⵎⵓⵏ ⵜⵎⴻⵙⵎⵓⵏⵜ ⴹⵉⴷⴷ ⵉ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ ⵓⵛⴰ ⴱⴷⴰⵏ ⵏⵉⵜⵏⵉ ⴳⴳⵓⵔⴻⵏ ⵖⴰⵔ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ⵅⵣⴰⵔ, ⴰⵇⴰ ⴷⵉⵏ ⴰⵙⴻⵢⵏⵓ ⵏⵏⵉ ⵜ ⵉⴷⵍⵉⵏ ⵓⵛⴰ ⵉⴱⴰⵏ-ⴷⴷ ⵓⵄⵓⴵⵉ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","ⵢⵓⵙⴰ-ⴷⴷ ⵎⵓⵙⴰ ⴰⴽ-ⴷ ⵀⴰⵔⵓⵏ, ⴱⴻⴷⴷⴻⵏ ⵣⵣⴰⵜ ⵉ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","“ⴽⴽⴰⵔⴻⵎ, ⴰⴳⴳⵯⴻⵊⴻⵎ ⵣⵉ ⵍⵡⴻⵙⵟ ⵏ ⵜⵎⴻⵙⵎⵓⵏⵜ ⵓ ⵏⴻⵛⵛ ⴰⴷ ⵜⴻⵏ ⵎⵃⵉⵖ ⴷⴻⴳ ⵉⵊⵊ ⵏ ⵡⴻⵔⵎⴰⵛ ⵏ ⵡⴰⴱⵍⵉⵡⴻⵏ!” ⵅⴻⵏⵏⵉ ⵡⴹⴰⵏ ⵅ ⵡⵓⴷⴻⵎ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","ⵉⵏⵏⴰ ⵎⵓⵙⴰ ⵉ ⵀⴰⵔⵓⵏ: “ⴽⵙⵉ ⴷⴻⵖⵢⴰ ⵉⵊⵊ ⵏ ⵍⵎⴻⵊⵎⴰⵔ, ⴻⴳⴳ ⵅⴰⵙ ⵜⵉⵎⴻⵙⵙⵉ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ⵓⵛⴰ ⵙⴰⵔⵙ ⵅⴰⵙ ⵍⴻⴱⵅⵓⵔ. ⴰⵣⵣⴻⵍ ⵖⴰⵔ ⵜⵎⴻⵙⵎⵓⵏⵜ ⵓⵛⴰ ⴻⴳⴳ ⴰⵚⵍⴰⵃ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏⵙⴻⵏ, ⵎⵉⵏⵣⵉ ⵉⴼⴼⴻⵖ-ⴷⴷ ⵓⴷⵓⵇⵇⴻⵣ ⵏ ⵡⴻⵖⴹⴰⴱ ⵣⵉ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ⴰⵇⴰ ⴷⴰ ⵊⵊⵔⵉⵃⴻⵛⵜ ⴰⵎ ⵜⴻⴱⴷⴰ ⵄⴰⴷ.” ");
INSERT INTO rift_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","ⵉⴽⵙⵉ ⵀⴰⵔⵓⵏ ⵍⵎⴻⵊⵎⴰⵔ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵉⵏⵏⴰ ⵎⵓⵙⴰ, ⵓⵛⴰ ⵢⵓⵣⵣⴻⵍ ⵖⴰⵔ ⵍⵡⴻⵙⵟ ⵏ ⵡⴻⴳⵔⴰⵡ ⵏ ⵍⴳⴻⵏⵙ, ⵓⵛⴰ ⵅⵣⴰⵔ, ⵊⵊⵔⵉⵃⴻⵛⵜ ⵜⵓⵖⴰ ⴰⵎ ⵜⴻⴱⴷⴰ ⵄⴰⴷ ⵊⴰⵔ ⵍⴳⴻⵏⵙ, ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵉⵙⵙⴰⵔⵙ ⴷⴰⵢⴻⵙ ⵍⴻⴱⵅⵓⵔ ⵓⵛⴰ ⵉⴳⴳⴰ ⴰⵚⵍⴰⵃ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏ ⵍⴳⴻⵏⵙ. ");
INSERT INTO rift_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","ⵜⵓⵖⴰ ⵉⴱⴻⴷⴷ ⵊⴰⵔ ⵉⵎⴻⵜⵜⴰⵏ ⴷ ⵉⵎⵓⴷⴷⴰⵔⴻⵏ ⵓⵛⴰ ⵜᵉⵜⵜⵡⴰⵙⵙⴱⴻⴷⴷ ⵊⵊⵔⵉⵃⴻⵛⵜ. ");
INSERT INTO rift_vpl VALUES ("NU17_14","005_17_14","NUM","17","14","14","ⵡⵉ ⵉⵎⵎⵓⵜⴻⵏ ⵣⵉ ⵊⵊⵔⵉⵃⴻⵛⵜ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⴰⵔⴱⴻⵄⵟⴰⵛ-ⴰⵍⴻⴼ ⵓ-ⵙⴻⴱⵄⴰ-ⵎⵢⴰ, ⴱⵍⴰ ⵉⵏⵏⵉ ⵉⵎⵎⵓⵜⴻⵏ ⴷⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⵇⵓⵔⴰⵃ. ");
INSERT INTO rift_vpl VALUES ("NU17_15","005_17_15","NUM","17","15","15","ⵉⴷⵡⴻⵍ ⵀⴰⵔⵓⵏ ⵖⴰⵔ ⵎⵓⵙⴰ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ⴰⵇⴰ ⵜᵉⵜⵜⵡⴰⵙⵙⴱⴻⴷⴷ ⵊⵊⵔⵉⵃⴻⵛⵜ. ");
INSERT INTO rift_vpl VALUES ("NU17_16","005_17_16","NUM","17","16","16","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU17_17","005_17_17","NUM","17","17","17","“ⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵛⴰ ⴽⵙⵉ ⵣⵣⴰⵢⵙⴻⵏ ⵉⵛⵜ ⵏ ⵜⴻⵖⵖⴰⵔⵛⵜ ⵉ ⴽⵓⵍ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵙⴻⵏ, ⵣⵉ ⵎⴰⵔⵔⴰ ⵍⵃⵓⴽⴽⴰⵎ ⵏⵙⴻⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵍⵄⴰⴷⴰⴷ ⵏ ⵜⵓⴷⵔⵉⵏ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵙⴻⵏ, ⵜⴻⵏⵄⴰⵛ ⵏ ⵜᵉⵖⵖⴰⵔⵢⴻⵏ. ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜⴰⵔⵉⴷ ⵉⵙⴻⵎ ⵏ ⴽⵓⵍ ⵉⵊⵊ ⵣⵣⴰⵢⵙⴻⵏ ⵅ ⵜⴻⵖⵖⴰⵔⵛⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU17_18","005_17_18","NUM","17","18","18","ⴰⴷ ⵜⴰⵔⵉⴷ ⵉⵙⴻⵎ ⵏ ⵀⴰⵔⵓⵏ ⵅ ⵜⴻⵖⵖⴰⵔⵛⵜ ⵏ ⵍⴰⵡⵉ, ⵎⵉⵏⵣⵉ ⴰⴷ ⴷⵉⵏ ⵜⵉⵍⵉ ⵉⵛⵜ ⵏ ⵜⴻⵖⵖⴰⵔⵛⵜ ⵉ ⵢⵉⵊⵊ ⵏ ⵓⵣⴻⴵⵉⴼ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵍⴻⵊⴷⵓⴷ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU17_19","005_17_19","NUM","17","19","19","ⴰⴷ ⵜⴻⵏⵜ ⵜⴻⴳⴳⴻⴷ ⴷⴻⴳ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ⵣⵣⴰⵜ ⵉ ⵛⵛⵀⴰⴷⴻⵜ, ⵎⴰⵏⵉ ⴽⵉⴷⵡⴻⵎ ⵖⴰ ⵎⵙⴰⴳⴰⵔⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("NU17_20","005_17_20","NUM","17","20","20","ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⵎⵙⴰⵔ, ⴰⵇⴰ ⴰⴷ ⵜⵏⵓⵡⵡⴰⵔ ⵜⴻⵖⵖⴰⵔⵛⵜ ⵏ ⵡⴻⵔⵢⴰⵣ ⵏⵏⵉ ⵉⵅⴹⴰⵔⴻⵖ ⵏⴻⵛⵛ ⵓⵛⴰ ⴰⴷ ⵙⵙⴱⴻⴷⴷⴻⵖ ⴰⵏⴻⴷⵇⴻⵎ ⴹⵉⴷⴷ ⵉⵏⵓ ⵉ ⵣⵉ ⵅⴰⵡⴻⵎ ⵏⵏⴷⴻⵇⵎⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ.” ");
INSERT INTO rift_vpl VALUES ("NU17_21","005_17_21","NUM","17","21","21","ⵉⵙⵙⵉⵡⴻⵍ ⵎⵓⵙⴰ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵓⵛⴰ ⵎⴰⵔⵔⴰ ⵍⵃⵓⴽⴽⴰⵎ ⵏⵙⴻⵏ ⵡⵛⵉⵏ ⵉⵛⵜ ⵏ ⵜⴻⵖⵖⴰⵔⵛⵜ ⵉ ⵎⴽⵓⵍ ⵉⵊⵊ ⵏ ⵍⵃⴰⴽⴻⵎ, ⵄⵍⴰⵃⵙⴰⴱ ⵍⵇⴻⴷⴷ ⵏ ⵜⵓⴷⵔⵉⵏ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵙⴻⵏ, ⵜⴻⵏⵄⴰⵛ ⵏ ⵜⴻⵖⵖⴰⵔⵢⴻⵏ. ⵓⵛⴰ ⵜⴰⵖⵖⴰⵔⵛⵜ ⵏ ⵀⴰⵔⵓⵏ ⵜⵓⵖⴰ-ⵜ ⵊⴰⵔ ⵜᵉⵖⵖⴰⵔⵢⴻⵏ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU17_22","005_17_22","NUM","17","22","22","ⵎⵓⵙⴰ ⵉⵙⵙⴰⵔⵙ ⵜⵉⵖⵖⴰⵔⵢⴻⵏ ⵏⵏⵉ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⴷⴻⴳ ⵓⵇⵉⴹⵓⵏ ⵏ ⵛⵛⵀⴰⴷⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("NU17_23","005_17_23","NUM","17","23","23","ⵜⵉⵡⴻⵛⵛⴰ ⵏⵏⴻⵙ ⵢⵓⴷⴻⴼ ⵎⵓⵙⴰ ⵖⴰⵔ ⵓⵇⵉⴹⵓⵏ ⵏ ⵛⵛⵀⴰⴷⴻⵜ, ⵓⵛⴰ ⵅⵣⴰⵔ, ⵜⴰⵖⵖⴰⵔⵛⵜ ⵏ ⵀⴰⵔⵓⵏ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵍⴰⵡⵉ ⵜⵓⵖⴰ ⵜⴻⴳⴳⴰ ⵜⴰⵛⵍⴰⵍⵜ ⵓⵛⴰ ⵜⴰⵄⴻⴱⴱⵓⵣⵜ ⵜⴻⵙⵙⵓⴼⴼⴻⵖ-ⴷⴷ ⵓⵛⴰ ⵏⵏⵓⵡⵡⴰⵔ ⵏⵏⴻⵙ ⵢⴰⵔⵣⴻⵎ ⵓⵛⴰ ⵢⵉⵡⵉ-ⴷⴷ ⴵⵓⵣ ⵢⵉⵡⴹⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU17_24","005_17_24","NUM","17","24","24","ⵅⴻⵏⵏⵉ ⵉⵙⵙⵓⴼⴼⴻⵖ ⵎⵓⵙⴰ ⵎⴰⵔⵔⴰ ⵜⵉⵖⵖⴰⵔⵢⴻⵏ ⵣⵉ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⵖⴰⵔ ⵎⴰⵔⵔⴰ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ⵥⵔⵉⵏ ⴰⵢⴰ ⵓⵛⴰ ⵟⵟⴼⴻⵏ ⴽⵓⵍ ⵉⵊⵊ ⵜⴰⵖⵖⴰⵔⵛⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU17_25","005_17_25","NUM","17","25","25","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⴰⵔⵔ ⵜⴰⵖⵖⴰⵔⵛⵜ ⵏ ⵀⴰⵔⵓⵏ ⵣⵣⴰⵜ ⵉ ⵛⵛⵀⴰⴷⴻⵜ, ⴰⴷ ⵜⵜ ⵜⴻⵃⴹⵉⴷ ⴰⵎ ⵢⵉⵊⵊ ⵏ ⵓⵛⴻⵢⵢⴰⵔ ⴹⵉⴷⴷ ⵉ ⵢⵉⵏⵏⵉ ⵉⵖⴻⵡⵡⵖⴻⵏ. ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵜⴻⵙⵙⴱⴻⴷⴷⴻⴷ ⴰⵏⴻⴷⵇⴻⵎ ⵏⵙⴻⵏ ⴹⵉⴷⴷ ⵉⵏⵓ ⵎⴰⵃⴻⵏⴷ ⵏⵉⵜⵏⵉ ⵡⴰⵔ ⵜⵜⵎⴻⵜⵜⵉⵏ ⵛⴰ.” ");
INSERT INTO rift_vpl VALUES ("NU17_26","005_17_26","NUM","17","26","26","ⵓⵛⴰ ⵉⴳⴳⴰ ⵎⵓⵙⴰ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵙ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ, ⴰⵎⵎⵓ ⵉ ⵉⴳⴳⴰ ⵏⴻⵜⵜⴰ. ");
INSERT INTO rift_vpl VALUES ("NU17_27","005_17_27","NUM","17","27","27","ⵅⴻⵏⵏⵉ ⵙⵙⵉⵡⵍⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵏⵏⴰⵏ: “ⵅⵣⴰⵔ, ⴰⴷ ⵣⵣⴰⵢⵏⴻⵖ ⵉⴼⴼⴻⵖ ⴱⵓⵃⴱⴻⵍ, ⴰⴷ ⵏⴻⵜⵜⵡⴰⵀⴻⵍⵍⴻⴽ, ⴰⴷ ⵏⴻⵜⵜⵡⴰⵀⴻⵍⵍⴻⴽ ⵎⴰⵔⵔⴰ ⵏⴻⵛⵛⵉⵏ! ");
INSERT INTO rift_vpl VALUES ("NU17_28","005_17_28","NUM","17","28","28","ⵎⴰⵏ ⵡⴻⵏ ⵎⴰ ⵉ ⴷⴷ ⵖⴰ ⵉⵇⴰⵔⵔⴱⴻⵏ ⵖⴰⵔ ⵓⵇⵉⴹⵓⵏ ⵏ ⵙⵉⴷⵉ, ⴰⴷ ⵉⵎⵎⴻⵜ. ⵎⴰ ⴰⴷ ⵏⴻⵜⵜⵡⴰⵜⴻⵃⵃⴰ ⴰⵍ ⵣⵣⴰⵢⵏⴻⵖ ⵉⴼⴼⴻⵖ ⴱⵓⵃⴱⴻⵍ?” ");
INSERT INTO rift_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵀⴰⵔⵓⵏ: “ⵛⴻⴽ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵛ ⴷ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⴱⴰⴱⴰⵛ ⴰⴽⵉⴷⴻⴽ, ⴰⴷ ⵜⴰⵔⴱⵓⵎ ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ ⵏ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵏⵡⴻⵎ. ⵛⴻⴽ ⴷ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵛ ⴰⴽⵉⴷⴻⴽ ⴰⴷ ⴰⵔⴱⵓⵏ ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ ⵏ ⵜⵓⴽⴻⵀⵀⴰⵏⵜ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","ⴰⴷ ⴷⴷ-ⵜⵉⵡⵢⴻⴷ ⴰⴽⵉⴷⴻⴽ ⵓⵍⴰ ⴷ ⴰⵢⵜⵎⴰⵛ, ⵜⴰⵇⴱⵉⵍⵜ ⵏ ⵍⴰⵡⵉ, ⵜⴰⵇⴱⵉⵍⵜ ⵏ ⴱⴰⴱⴰⵛ. ⵏⵉⵜⵏⵉ ⴰⴷ ⴷⴷ-ⵎⵎⴰⵔⴻⵏⵢⴻⵏ ⵖⴰⵔⴻⴽ, ⴰⴷ ⴰⵛ ⵙⴻⵅⵅⴰⵔⴻⵏ, ⵎⴰⵛⴰ ⵛⴻⴽ, ⵊⵎⵉⵄ ⴰⴽ-ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵛ, ⴰⴷ ⵜⵙⴻⵅⵅⴰⵔⴻⴷ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵛⵛⵀⴰⴷⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","ⴰⴷ ⵟⵟⴼⴻⵏ ⴰⵛⴱⴰⵔ ⵏⵏⴻⵛ ⵓⵛⴰ ⴰⴷ ⵃⴹⴰⵏ ⵅ ⵎⴰⵔⵔⴰ ⴰⵇⵉⴹⵓⵏ, ⵎⴰⵛⴰ ⵡⴰⵔ ⵣⴻⵎⵎⴰⵔⴻⵏ ⴰⴷ ⴷⴷ-ⵇⴰⵔⵔⴱⴻⵏ ⵖⴰⵔ ⵍⴻⵇⵛⵓⵄ ⵏ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵓ ⵖⴰⵔ ⵓⵄⴰⵍⵟⴰⵔ ⵃⵉⵎⴰ ⵡⴰⵔ ⵜⵜᵉⵜⵜⵎⴻⵜⵜⵉⵏ, ⵡⴰⵔ ⵉⴵⵉ ⵍⴰ ⴷ ⵏⵉⵜⵏⵉ ⵓⵍⴰ ⴷ ⴽⴻⵏⵏⵉⵡ. ");
INSERT INTO rift_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⵙⴻⵏ ⴰⴷ ⵎⵎⴰⵔⴻⵏⵢⴻⵏ ⵖⴰⵔⴻⴽ ⵓⵛⴰ ⴰⴷ ⵟⵟⴼⴻⵏ ⴰⵛⴱⴰⵔ ⵅ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⵓ ⵅ ⵎⴰⵔⵔⴰ ⵜⴰⵙⴻⵅⵅⴰⵔⵜ ⵏ ⵓⵇⵉⴹⵓⵏ. ⵡⴻⵏⵏⵉ ⵡⴰⵔ ⵖⴰⵔ ⵉⴵⵉ ⵜⵜⴻⵙⵔⵉⵃ ⵡⴰⵔ ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵖⴰⵔⵡⴻⵎ ⴷⴷ-ⵉⵇⴰⵔⵔⴻⴱ. ");
INSERT INTO rift_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","ⴰⴷ ⵜᵉⵟⵟⴼⴻⵎ ⴰⵛⴱⴰⵔ ⵅ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵓⵍⴰ ⵅ ⵓⵄⴰⵍⵟⴰⵔ, ⵃⵉⵎⴰ ⵡⴰⵔ ⴷⴷ-ⵉⵜⵜⵉⵙ ⵄⴰⴷ ⵓⴷⵓⵇⵇⴻⵣ ⵏ ⵡⴻⵖⴹⴰⴱ ⵅ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","ⵏⴻⵛⵛ, ⴰⵇⴰ ⴷⴰ ⵏⴻⵛⵛ, ⴽⵙⵉⵖ ⴰⵡⵎⴰⵜⴻⵏ ⵏⵡⴻⵎ, ⵉⵍⴰⵡⵉⵢⵢⴻⵏ, ⵣⵉ ⵊⴰⵔ ⵍⵡⴻⵙⵟ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ⴰⵇⴰ ⵏⵉⵜⵏⵉ ⴰⵎ ⵢⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵉ ⴽⴻⵏⵏⵉⵡ ⵜⴻⵏⵏⵉ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜⵡⴻⵀⵀⴱⴻⵎ ⵉ ⵙⵉⴷⵉ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵉⵜⵏⵉ ⴷⴻⴳ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","ⵎⴰⵛⴰ ⵛⴻⴽ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵛ ⴰⴽⵉⴷⴻⴽ ⴰⴷ ⵜᵉⵟⵟⴼⴻⵎ ⵜⵓⴽⴻⵀⵀⴰⵏⵜ ⵏⵡⴻⵎ ⴷⵉ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⵇⵇⵏⴻⵏ ⴰⴽ-ⴷ ⵓⵄⴰⵍⵟⴰⵔ ⴷ ⵎⵉⵏ ⵉⴵⴰⵏ ⴷⴰⵅⴻⵍ ⵉ ⵓⵍⴻⵃⵃⴰⴼ ⵓⵛⴰ ⴰⵎⵎⵓ ⴰⴷ ⵜⵙⴻⵅⵅⴰⵔⴻⵎ ⴽⴻⵏⵏⵉⵡ. ⵏⴻⵛⵛ ⴰⴷ ⴰⵡⴻⵎ ⵡⵛⴻⵖ ⵜⵓⴽⴻⵀⵀⴰⵏⵜ ⴷ ⵜⵙⴻⵅⵅⴰⵔⵜ ⴰⵎ ⵢⵉⵛⵜ ⵏ ⵜⴻⵔⵣⴻⴼⵜ. ⴰⴱⴰⵔⵔⴰⵏⵉ ⵏⵏⵉ ⴷⴷ ⵖⴰ ⵉⵇⴰⵔⵔⴱⴻⵏ, ⴰⴷ ⵉⵜⵜⵡⴰⵏⴻⵖ.” ");
INSERT INTO rift_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵀⴰⵔⵓⵏ: “ⵏⴻⵛⵛ, ⵅⵣⴰⵔ, ⴰⵇⴰ ⴷ ⵏⴻⵛⵛ ⵉ ⴷ ⴰⵛ ⵉⵡⵛⵉⵏ ⴰⵃⴻⵟⵟⵓ ⵅ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵏ ⵓⵙⴳⴻⵄⵄⴻⴷ ⵉ ⵇⴻⴷⴷⵎⴻⵏ ⵏⵉⵜⵏⵉ ⵉ ⵏⴻⵛⵛ. ⵏⴻⵛⵛ ⵡⵛⵉⵖ ⵜⴻⵏⵜ ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⵜⵉⵡⵀⵉⴱⵉⵏ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴰⵎ ⵜⴻⵙⵖⴰⵔⵜ ⵉ ⵅ ⵉⵜⵜⵡⴰⴳⴳ ⵡⴻⴷⵀⴰⵏ, ⵉ ⵛⴻⴽ ⵓ ⵉ ⵡⴰⵔⵔⴰⵡ ⵏⵏⴻⵛ, ⴰⵎ ⵢⵉⵛⵜ ⵏ ⵜⴻⵡⵚⴻⵢⵢⴻⵜ ⵉ ⵍⴻⴱⴷⴰ. ");
INSERT INTO rift_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","ⵣⵉ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵉⵇⴻⴷⴷⵙⴻⵏ ⴰⴷ ⵉⵍⵉⵏⵜ ⵉⵣⵉⵢⵏⴰⵜ ⵉ ⵡⴰⵔ ⵢⵓⴷⵉⴼⴻⵏ ⵖⴰⵔ ⵜⵎⴻⵙⵙⵉ ⵉ ⵛⴻⴽ: ⵎⴰⵔⵔⴰ ⵜⵉⵡⵀⵉⴱⵉⵏ ⵏⵙⴻⵏ ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⵜⵉⵡⵀⵉⴱⵉⵏ ⵏⵙⴻⵏ ⵏ ⵍⵖⵉⴵⴻⵜ, ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⵜⵉⵖⴰⵔⵚⴰ ⵏⵙⴻⵏ ⵏ ⴷⴷⴻⵏⴱ ⵓ ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⵜⵉⵖⴰⵔⵚⴰ ⵏⵙⴻⵏ ⵏ ⵓⵎⴰⵔⵡⴰⵙ ⵏⵏⵉ ⴷ ⴰⵢⵉ ⴷⴷ ⵖⴰ ⵢⴰⵔⵔⴻⵏ ⴰⵎ ⵜⴻⵅⵔⵉⵚⵜ. ⵎⴰⵏ ⴰⵢⴰ ⵎⴰⵔⵔⴰ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⴰⵎⵇⴻⴷⴷⴰⵙ ⵇⴰⵄ ⵉ ⵛⴻⴽ ⵓ ⵉ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","ⴰⴷ ⵜⴻⵛⵛⴻⴷ ⴰⵢⴰ ⴷⴻⴳ ⵉⵊⵊ ⵏ ⵡⴻⵎⵛⴰⵏ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵇⴰⵄ. ⴽⵓⵍ ⴰⵡⵜⴻⵎ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵢⴻⵛⵛ. ⴰⵢⴰ ⴰⴷ ⵢⵉⵍⵉ ⴷ ⴰⵎⵇⴻⴷⴷⴰⵙ ⵉ ⴽⴻⵏⵏⵉⵡ.” ");
INSERT INTO rift_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“ⵄⴰⵡⴻⴷ ⴷ ⵎⴰⵏ ⴰⵢⴰ ⴰⴷ ⵢⵉⵍⵉ ⵉ ⵛⴻⴽ: ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵓⵙⴳⴻⵄⵄⴻⴷ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵙⴻⵏ ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⵜⵉⵡⵀⵉⴱⵉⵏ ⵏ ⵡⴻⵏⵀⴻⵣⵣⵉ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ⵡⵛⵉⵖ ⵜⴻⵏⵜ ⵉ ⵛⴻⴽ ⵓ ⵉ ⵡⴰⵔⵔⴰⵡⴻⵏ ⵏⵏⴻⵛ ⴷ ⵜⴰⵔⵔⴰⵡⵉⵏ ⵏⵏⴻⵛ ⵏⵏⵉ ⴽⵉⴷⴻⴽ ⵉⴵⴰⵏ. ⴰⵇⴰ-ⵜⵜ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵚⴻⵢⵢⴻⵜ ⵉ ⵍⴻⴱⴷⴰ. ⴽⵓⵍ ⵉⵊⵊⴻⵏ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⴻⵛ ⵏⵏⵉ ⵉⴵⴰⵏ ⴷ ⴰⵎⴻⵣⴷⴰⴳ, ⴰⴷ ⵣⵣⴰⵢⵙⴻⵏⵜ ⵢⴻⵛⵛ.” ");
INSERT INTO rift_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“ⵎⵉⵏ ⵉⴵⴰⵏ ⵍⴻⵎⵅⴻⵢⵢⴰⵔ ⵏ ⵣⵣⴻⵛⵜ ⴷ ⵎⵉⵏ ⵉⴵⴰⵏ ⵍⴻⵎⵅⴻⵢⵢⴰⵔ ⵏ ⴱⵉⵏⵓ ⵏ ⵊⴷⵉⴷ ⵓ ⵣⴻⴳ ⵉⵔⴷⴻⵏ, ⴰⵇⴰ ⴷ ⵜⴰⵎⴻⵣⵡⴰⵔⵓⵜ ⵉ ⵣⵣⴰⵢⵙⴻⵏ ⴰⴷ ⵡⵛⴻⵏ ⵉ ⵙⵉⴷⵉ, ⴰⵇⴰ ⵡⵛⵉⵖ ⴰⵛ ⵜⵜ. ");
INSERT INTO rift_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","ⵜⴰⵎⴻⵏⵣⵓⵜ ⵏ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⴵⴰⵏ ⵅ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵙⴻⵏ, ⵏⵏⵉ ⴷⴷ ⵖⴰ ⵢⴰⵡⵢⴻⵏ ⵖⴰⵔ ⵙⵉⴷⵉ, ⴰⵇⴰ ⵎⴰⵔⵔⴰ ⵎⴰⵏ ⴰⵢⴰ ⴰⴷ ⵢⵉⵍⵉ ⵉ ⵛⴻⴽ. ⴽⵓⵍ ⵉⵊⵊⴻⵏ ⵡⴻⵏⵏⵉ ⵉⴵⴰⵏ ⴷ ⴰⵎⴻⵣⴷⴰⴳ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⴻⵛ, ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵢⴻⵛⵛ.” ");
INSERT INTO rift_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⵜⵜⵡⴰⵃⴰⵔⵔⵎⴻⵏ ⴷⵉ ⵉⵙⵔⴰⵉⵍ, ⴰⴷ ⵢⵉⵍⵉ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵢⴰⵔⴻⵣⵎⴻⵏ ⵍⴻⵎⵍⴰⵡⴰⵜ ⴷ ⴰⵎⴻⵣⵡⴰⵔⵓ ⵊⴰⵔ ⵎⴰⵔⵔⴰ ⴰⵢⵙⵓⵎ ⵉ ⵖⴰ ⵇⴻⴷⴷⵎⴻⵏ ⵉ ⵙⵉⴷⵉ, ⵣⵉ ⴱⵏⴰⴷⴻⵎ ⵏⵉⵖ ⵣⵉ ⵍⴻⴱⵀⵉⵎⴻⵜ, ⴰⴷ ⵢⵉⵍⵉ ⵏⵏⴻⵛ. ⵎⴰⵛⴰ ⴰⴷ ⵜⴻⴼⴷⵉⴷ ⵇⴰⵄ ⴰⵎⴻⵏⵣⵓ ⵏ ⵉⵡⴷⴰⵏ ⵓⵛⴰ ⵉⵜⵜⵅⴻⵚⵚⴰ ⵄⴰⵡⴻⴷ ⴰⴷ ⵜⴻⴼⴷⵉⴷ ⴰⵎⴻⵏⵣⵓ ⵏ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵉⵅⴻⵎⵊⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","ⵡⵉ ⵣⵣⴰⵢⵙⴻⵏ ⵖⴰ ⵜⵜⵡⴰⴼⴷⵉⵏ ⵏⵉⵜⵏⵉ, ⴰⴷ ⵜⵜⵡⴰⴼⴷⵉⵏ ⴷ ⵎⵎⵉⵙ ⵏ ⵉⵊⵊ ⵏ ⵓⵢⵓⵔ ⵄⵍⴰⵃⵙⴰⴱ ⵍⵇⵉⵎⴻⵜ ⵉ ⵜⵇⴻⴷⴷⴰⵔⴻⴷ ⵛⴻⴽ ⴷⵉ ⵏⵏⵓⵇⴰⵔⵜ, ⵅⴻⵎⵙⴰ ⵛⵉⵇⵍⵓ ⵄⵍⴰⵃⵙⴰⴱ ⵛⵉⵇⵍⵓ ⵏ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ, ⵡⴻⵏⵏⵉ ⵉⴵⴰⵏ ⵄⵉⵛⵔⵉⵏ ⵊⵉⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","ⵎⴰⵛⴰ ⴰⵎⴻⵏⵣⵓ ⵏ ⵓⴼⵓⵏⴰⵙ ⴷ ⵓⵎⴻⵏⵣⵓ ⵏ ⵓⵃⵓⵍⵉ ⴷ ⵓⵎⴻⵏⵣⵓ ⵏ ⵉⵖⴰⵢⴹ, ⵡⴰⵔ ⵜ ⵜⴼⴻⴷⴷⵉⵎ ⵛⴰ. ⴰⵇⴰ ⴰⵜⴻⵏ ⵇⴻⴷⴷⵙⴻⵏ ⵉ ⴵⴰⵏ. ⴰⴷ ⵜⵣⴻⴵⵄⴻⴷ ⵉⴷⴰⵎⵎⴻⵏ ⵏⵙⴻⵏ ⵅ ⵓⵄⴰⵍⵟⴰⵔ ⵓ ⵜⴰⴷⵓⵏⵜ ⵏⵙⴻⵏ ⴰⴷ ⵜⵜ ⵜⴻⵙⵙⴱⴻⵅⵅⴰⵔⴻⴷ ⴰⵎ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ, ⴰⵎ ⵢⵉⵛⵜ ⵏ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵉⵜⵜⴼⵓⵃⴻⵏ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","ⴰⵢⵙⵓⵎ ⵏⵏⴻⵙ ⴰⴷ ⵢⵉⵍⵉ ⵏⵏⴻⵛ, ⴰⵎ ⵢⵉⴷⵎⴰⵔⴻⵏ ⵏ ⵡⴻⵏⵀⴻⵣⵣⵉ ⴰⵎ ⵓⵛⴻⴽⵔⵓⴷ ⴰⴼⵓⵙⵉ ⴰⴷ ⵉⵍⵉⵏ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","ⵎⴰⵔⵔⴰ ⵜⵉⵡⵀⵉⴱⵉⵏ ⵏ ⵓⵙⴳⴻⵄⵄⴻⴷ ⵣⵉ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵏⵏⵉ ⵖⴰ ⵙⵙⴳⴻⵄⵄⴷⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵉ ⵙⵉⴷⵉ, ⵡⵛⵉⵖ ⵜⴻⵏⵜ ⵉ ⵛⴻⴽ ⵓ ⵉ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵛ ⴷ ⵜⵃⴻⵏⵊⵉⵔⵉⵏ ⵏⵏⴻⵛ ⵉⵏⵏⵉ ⴰⴽⵉⴷⴻⴽ ⵉⴵⴰⵏ. ⴰⵇⴰ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵚⴻⵢⵢⴻⵜ ⵉ ⵍⴻⴱⴷⴰ, ⴰⴷ ⵢⵉⵍⵉ ⴷ ⵉⵊⵊ ⵏ ⵍⵄⴰⵀⴷ ⵙ ⵍⴻⵎⵍⴰⵃⴻⵜ ⵉ ⵍⴻⴱⴷⴰ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ, ⵉ ⵛⴻⴽ ⵓ ⵉ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵛ ⵏⵏⵉ ⴰⴽⵉⴷⴻⴽ ⵉⴵⴰⵏ.” ");
INSERT INTO rift_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵀⴰⵔⵓⵏ: “ⵡⴰⵔ ⵜᵉⵜⵜᵉⵟⵟⴼⴻⴷ ⵍⵡⴰⵔⵜ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵙⴻⵏ ⵓ ⵡⴰⵔ ⵖⴰⵔⴻⴽ ⵜᵉⵜⵜⵉⵍⵉ ⴱⵓ ⵜⴻⵙⵖⴰⵔⵜ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏⵙⴻⵏ. ⵏⴻⵛⵛ ⴷ ⵜⴰⵙⵖⴰⵔⵜ ⵏⵏⴻⵛ ⴷ ⵍⵡⴰⵔⵜ ⵏⵏⴻⵛ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","ⵅⵣⴰⵔ, ⵏⴻⵛⵛ ⵡⵛⵉⵖ ⵉ ⴰⵢⵜ ⵏ ⵍⴰⵡⵉ ⵎⴰⵔⵔⴰ ⵍⴻⵄⵛⵓⵔ ⴷⵉ ⵉⵙⵔⴰⵉⵍ ⴷ ⵍⵡⴰⵔⵜ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏ ⵜⵙⴻⵅⵅⴰⵔⵜ ⵏⵏⵉ ⴳⴳⵉⵏ ⵏⵉⵜⵏⵉ, ⵜⴰⵙⴻⵅⵅⴰⵔⵜ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵡⴰⵔ ⴷⴷ-ⵜⵜⵇⴰⵔⵔⵉⴱⴻⵏ ⵄⴰⴷ ⵖⴰⵔ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ⵃⵉⵎⴰ ⵡⴰⵔ ⴷⴷ-ⵜⵜⵉⵡⵢⴻⵏ ⴰⵎⵎⵓ ⴷⴷⴻⵏⴱ ⵅ ⵢⵉⵅⴻⴼ ⵏⵙⴻⵏ ⵓⵛⴰ ⴰⴷ ⵎⵎⵜⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","ⵎⴰⵛⴰ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⴰⴷ ⵙⴻⵅⵅⴰⵔⴻⵏ ⴷⵉ ⵜⵙⴻⵅⵅⴰⵔⵜ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⵓⵛⴰ ⴰⴷ ⴰⵔⴱⵓⵏ ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ ⵏⵙⴻⵏ. ⴰⵇⴰ-ⵜⵜ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵚⴻⵢⵢⴻⵜ ⵉ ⵍⴻⴱⴷⴰ ⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵏⵡⴻⵎ, ⴰⵇⴰ ⵏⵉⵜⵏⵉ ⵡⴰⵔ ⵜⵜᵉⵟⵟⴼⴻⵏ ⵍⵡⴰⵔⵜ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ");
INSERT INTO rift_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","ⵎⵉⵏⵣⵉ ⵍⴻⵄⵛⵓⵔ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵏⵏⵉ ⵙⵙⴳⴻⵄⵄⴷⴻⵏ ⵏⵉⵜⵏⵉ ⵉ ⵙⵉⴷⵉ ⴰⵎ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵓⵙⴳⴻⵄⵄⴻⴷ, ⵡⵛⵉⵖ ⵜⴻⵏ ⵉ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ. ⵅ ⵓⵢⴰ ⵏⵏⵉⵖ ⴰⵙⴻⵏ: ⵡⴰⵔ ⵡⴰⵔⵔⵜⴻⵏ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ!” ");
INSERT INTO rift_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵜⴻⵙⵙⵉⵡⵍⴻⴷ ⴰⴽ-ⴷ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⵓⵛⴰ ⴰⴷ ⴰⵙⴻⵏ ⵜⵉⵏⵉⴷ: ‘ⵅⵎⵉ ⵜⴻⴽⵙⵉⵎ ⵍⴻⵄⵛⵓⵔ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵏⵏⵉ ⵡⵛⵉⵖ ⴽⴻⵏⵏⵉⵡ ⴷ ⵍⵡⴰⵔⵜ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵣⵣⴰⵢⵙⴻⵏ ⵜⴻⵙⵙⴳⴻⵄⵄⴷⴻⵎ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵓⵙⴳⴻⵄⵄⴻⴷ ⵉ ⵙⵉⴷⵉ, ⵍⴻⵄⵛⵓⵔ ⵣⵉ ⵍⴻⵄⵛⵓⵔ. ");
INSERT INTO rift_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","ⴰⴷ ⴰⵡⴻⵎ ⴷⴷ-ⵜᵉⵜⵜⵡⴰⵃⵙⴻⴱ ⴰⵎ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵓⵙⴳⴻⵄⵄⴻⴷ, ⴰⵎ ⵢⵉⵔⴷⴻⵏ ⵏ ⵓⵏⴻⴷⵔⴰⵔ ⵓ ⴰⵎ ⵜⴻⵛⵛⵓⵔⴻⵜ ⵏ ⵜⵙⵉⵔⵜ ⵏ ⵓⴹⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","ⴰⵎⵎⵓ ⵉ ⴷ ⴰⵡⴻⵎ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜⴻⵙⵙⴳⴻⵄⵄⴷⴻⵎ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵓⵙⴳⴻⵄⵄⴻⴷ ⵉ ⵙⵉⴷⵉ ⵣⵉ ⵎⴰⵔⵔⴰ ⵍⴻⵄⵛⵓⵔ ⵏⵡⴻⵎ ⵏⵏⵉ ⵖⴰ ⵜⴻⴽⵙⵉⵎ ⵣⴻⴳ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜⴻⵡⵛⴻⵎ ⵜⴰⵡⵀⵉⴱⵜ, ⵜⴻⵏⵏⵉ ⵜⴻⵙⵙⴳⴻⵄⵄⴷⴻⵎ ⵣⵣⴰⵢⵙⴻⵏ ⵉ ⵙⵉⴷⵉ, ⵖⴰⵔ ⵓⴽⴻⵀⵀⴰⵏ ⵀⴰⵔⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","ⵣⵉ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴷ ⴰⵡⴻⵎ ⵖⴰ ⵡⵛⴻⵏ, ⴰⴷ ⵜⴻⵙⵙⴳⴻⵄⵄⴷⴻⵎ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵓⵙⴳⴻⵄⵄⴻⴷ ⵜⵎⵓⵏ ⵉ ⵙⵉⴷⵉ, ⵣⵉ ⵍⴻⵎⵅⴻⵢⵢⴰⵔ ⵏⵏⴻⵙ, ⵜⴰⵙⵖⴰⵔⵜ ⵏⵏⴻⵙ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵣⵣⴰⵢⴻⵙ.’ ");
INSERT INTO rift_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","ⵓⵛⴰ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⵛ ⴰⴷ ⴰⵙⴻⵏ ⵜⵉⵏⵉⵎ: ‘ⵎⴰⵍⴰ ⵜⴻⴽⵙⵉⵎ ⵣⵣⴰⵢⴻⵙ ⵍⴻⵎⵅⴻⵢⵢⴰⵔ ⵏⵏⴻⵙ, ⴰⵇⴰ ⴰⵢⴰ ⴰⴷ ⴷⴷ-ⵉⵜⵜⵡⴰⵃⵙⴻⴱ ⴷ ⵍⵖⵉⴵⴻⵜ ⵏ ⵓⵏⴻⴷⵔⴰⵔ ⴷ ⵍⵖⵉⴵⴻⵜ ⵏ ⵜⵙⵉⵔⵜ ⵏ ⵓⴹⵉⵍ ⵉ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","ⴰⴷ ⵜⴻⵛⵛⴻⵎ ⴰⵢⴰ ⴷⵉ ⴽⵓⵍ ⴰⵎⵛⴰⵏ, ⴽⴻⵏⵏⵉⵡ ⴷ ⴰⵢⵜⴱⴰⴱ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵡⴻⵎ, ⵎⵉⵏⵣⵉ ⵜⴰ ⴷ ⵍⵎⵓⵏⴻⵜ ⵉ ⵜⵙⴻⵅⵅⴰⵔⵜ ⵏⵡⴻⵎ ⴷⴻⴳ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","ⵎⴰⵍⴰ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵜⴻⴽⵙⵉⵎ ⵎⵉⵏ ⵉⴵⴰⵏ ⵃⵙⴻⵏ, ⵅⴻⵏⵏⵉ ⵡⴰⵔ ⵅⴰⵡⴻⵎ ⵜⴰⵔⴻⴱⴱⵓⵎ ⴷⴷⴻⵏⴱ. ⵡⴰⵔ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⵜⴼⴻⵙⴷⴻⵎ ⵜⵉⵡⵀⵉⴱⵉⵏ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵃⵉⵎⴰ ⵡⴰⵔ ⵜᵉⵜⵜⵎⴻⵜⵜⵉⵎ ⵛⴰ.’” ");
INSERT INTO rift_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“ⵜⴰ ⴷ ⵜⴰⵡⵚⴻⵢⵢⴻⵜ ⵏ ⵛⵛⴰⵔⵉⵄⴰ ⵏⵏⵉ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ, ⵓⵎⵉ ⵉⵏⵏⴰ: ‘ⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴰⴷ ⴰⵛ ⴷⴷ-ⴰⵡⵢⴻⵏ ⵉⵛⵜ ⵏ ⵜⴼⵓⵏⴰⵙⵜ ⵜⴰⵣⴻⴳⴳⵯⴰⵖⵜ, ⵜⴻⵏⵏⵉ ⵉⵛⵏⴰⵏ ⵓ ⵜⴻⵏⵏⵉ ⵡⴰⵔ ⴷⵉ ⵉⴵⵉ ⵓⵏⴻⵄⴹⴰⴱ ⵓⵛⴰ ⵡⴰⵔ ⵅⴰⵙ ⵙⵙⴰⵔⵙⴻⵏ ⵄⴰⴷ ⴰⵣⴰⵢⵍⵓ. ");
INSERT INTO rift_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","ⴰⴷ ⵜⵜ ⵜⴻⵡⵛⴻⵎ ⵉ ⵓⴽⴻⵀⵀⴰⵏ ⴰⵍⵉⵄⴰⵣⴰⵔ ⵓ ⵏⴻⵜⵜⴰ ⴰⴷ ⵜⵜ ⵉⵙⵙⵓⴼⴼⴻⵖ ⴱⴰⵔⵔⴰ ⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵓ ⴰⴷ ⴰⵙ ⵖⴰⵔⵚⴻⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","ⴰⴽⴻⵀⵀⴰⵏ ⴰⵍⵉⵄⴰⵣⴰⵔ ⴰⴷ ⵉⴽⵙⵉ ⵛⵡⴰⵢⵜ ⵏ ⵉⴷⴰⵎⵎⴻⵏ ⵏⵏⴻⵙ ⵙ ⵓⴹⴰⴹ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⵉⵔⵓⵛⵛ ⵙⴻⴱⵄⴰ ⵏ ⵜⵡⴰⵍⴰⵡⵉⵏ ⵛⵡⴰⵢⵜ ⵣⴻⴳ ⵉⴷⴰⵎⵎⴻⵏ ⵏⵏⴻⵙ ⵊⵊⵉⵀⴻⵜ ⵏ ⵡⵓⴷⴻⵎ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","ⴰⴷ ⵙⵙⵛⴻⵎⴹⴻⵏ ⵜⴰⴼⵓⵏⴰⵙⵜ ⵣⵣⴰⵜ ⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵙ. ⵜⵉⵍⵎⴻⵛⵜ ⵏⵏⴻⵙ, ⴰⵢⵙⵓⵎ ⵏⵏⴻⵙ ⴷ ⵉⴷⴰⵎⵎⴻⵏ ⵏⵏⴻⵙ ⴰⴷ ⵜⴻⵏ ⵙⵙⵛⴻⵎⴹⴻⵏ ⵊⵎⵉⵄ ⴰⴽ-ⴷ ⵓⵎⴻⵙⵙⴰⵍ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","ⴰⴷ ⵉⴽⵙⵉ ⵓⴽⴻⵀⵀⴰⵏ ⴰⴽⴻⵛⵛⵓⴹ ⵏ ⵜⵛⴻⵊⵊⴰⵔⵜ ⵏ ⵜⴻⵏⴳⴻⵍⵜ ⴷ ⵜⵄⴻⵍⴵⴻⵜ ⴷ ⵓⵣⴻⴳⴳⵯⴰⵖ ⵉⵃⴻⴷⵇⴻⵏ ⵓⵛⴰ ⴰⴷ ⵉⵏⴹⴰⵔ ⴰⵢⴰ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏ ⵜⵎⴻⵙⵙⵉ ⵉ ⴷⵉ ⵜᵉⵜⵜⵡⴰⵛⵎⴻⴹ ⵜⴼⵓⵏⴰⵙⵜ. ");
INSERT INTO rift_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⵚⴻⴱⴱⴻⵏ ⵓⴽⴻⵀⵀⴰⵏ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ, ⴰⴷ ⵉⵙⵙⵉⵔⴷ ⴰⵔⵔⵉⵎⴻⵜ ⵏⵏⴻⵙ ⴷⴻⴳ ⵡⴰⵎⴰⵏ, ⵓⵛⴰ ⴰⵡⴰⵔⵏⵉ ⴰⵙ ⴰⴷ ⵢⴰⴷⴻⴼ ⵖⴰⵔ ⵍⵎⴰⵔⴳⴻⵃ. ⴰⴽⴻⵀⵀⴰⵏ ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ⴰⵍ ⵜⴰⵎⴻⴷⴷⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","ⴷ ⵡⴻⵏⵏⵉ ⵜⵜ ⵉⵙⵙⵛⴻⵎⴹⴻⵏ, ⴰⴷ ⵉⵚⴻⴱⴱⴻⵏ ⵄⴰⵡⴻⴷ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ ⴷⴻⴳ ⵡⴰⵎⴰⵏ ⵓⵛⴰ ⴰⴷ ⵉⵙⵙⵉⵔⴷ ⴰⵔⵔⵉⵎⴻⵜ ⵏⵏⴻⵙ ⵙ ⵡⴰⵎⴰⵏ. ⵏⴻⵜⵜⴰ ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ⴰⵍ ⵜⴰⵎⴻⴷⴷⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","ⴰⵔⵢⴰⵣ ⴰⵎⴻⵣⴷⴰⴳ ⴰⴷ ⵉⵢⵔⵓ ⵉⵖⵖⴻⴹ ⵏ ⵜⴼⵓⵏⴰⵙⵜ ⵓⵛⴰ ⴰⴷ ⵜⴻⵏ ⵉⴳⴳ ⴱⴰⵔⵔⴰ ⵉ ⵍⵎⴰⵔⴳⴻⵃ ⴷⴻⴳ ⵉⵊⵊ ⵏ ⵡⴻⵎⵛⴰⵏ ⵉⵣⴷⵉⴳ. ⴰⵇⴰ ⵅ ⵜⵎⴻⵙⵎⵓⵏⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⴻⵃⴹⴰ ⵅ ⵡⴰⵎⴰⵏ ⵏ ⵡⴻⵄⵣⴰⵍ, ⴰⵇⴰ ⴰⵜⴻⵏ ⵉ ⵓⵙⵉⵣⴷⴻⴳ ⵏ ⴷⴷⴻⵏⴱ. ");
INSERT INTO rift_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","ⵡⴻⵏⵏⵉ ⵉⵢⵔⵓⵏ ⵉⵖⵖⴻⴹ ⵏ ⵜⴼⵓⵏⴰⵙⵜ ⴰⴷ ⵉⵚⴻⴱⴱⴻⵏ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ⴰⵍ ⵜⴰⵎⴻⴷⴷⵉⵜ. ⴰⵇⴰ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵚⴻⵢⵢⴻⵜ ⵉ ⵍⴻⴱⴷⴰ ⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓ ⵉ ⵓⴱⴰⵔⵔⴰⵏⵉ ⵏⵏⵉ ⵉⵣⴻⴷⴷⵖⴻⵏ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏⵙⴻⵏ.’” ");
INSERT INTO rift_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“ⵡⵉ ⵖⴰ ⵉⵃⴰⴷⴰⵏ ⵛⴰ ⵏ ⵓⵎⴻⵜⵜⵉⵏ, ⵎⴰⵎⵎⴻⵛ ⵎⴰ ⵜⴻⴳⴳⴰ ⵛⴰ ⵏ ⵍⵅⴻⵛⴱⴻⵜ ⵏ ⴱⵏⴰⴷⴻⵎ, ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵜⵍⴰⵜⴰ ⴰⴷ ⵉⴽⴽⴻⵙ ⴷⴷⴻⵏⴱ ⵅ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵙ ⵡⴰⵎⴰⵏ ⵏ ⵡⴻⵄⵣⴰⵍ. ⵅⴻⵏⵏⵉ ⴰⴷ ⵢⵉⵍⵉ ⵉⵣⴷⵉⴳ ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ. ⵎⴰⵍⴰ ⵡⴰⵔ ⵉⴽⴽⵉⵙ ⴷⴷⴻⵏⴱ ⵅ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵙ ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵜⵍⴰⵜⴰ, ⵡⴰⵔ ⵉⵜⵜⵉⵍⵉ ⵉⵣⴷⵉⴳ ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ. ");
INSERT INTO rift_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","ⵎⴰⵔⵔⴰ ⵡⵉ ⵉⵃⴰⴷⴰⵏ ⵉⵊⵊ ⵏ ⵓⵎⴻⵜⵜⵉⵏ, ⵍⴻⵄⵎⴰⵔ ⵏ ⵉⵊⵊ ⵏ ⴱⵏⴰⴷⴻⵎ ⵉⵎⵎⵓⵜ, ⵓⵛⴰ ⵡⴰⵔ ⵉⴽⴽⵉⵙ ⴷⴷⴻⵏⴱ ⵅ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵙ, ⴰⵇⴰ ⵉⵙⵙⴻⵅⵎⴻⵊ ⵜⴰⵣⴻⴷⴷⵉⵖⵜ ⵏ ⵙⵉⴷⵉ. ⵍⴻⵄⵎⴰⵔ ⵏⵏⵉ ⴰⴷ ⵉⵜⵜⵡⴰⵇⴻⵙⵙ ⵣⵉ ⵉⵙⵔⴰⵉⵍ. ⵎⵉⵏⵣⵉ ⵡⴰⵔ ⵅⴰⵙ ⵣⵣⵓⵣⴰⵔⴻⵏ ⵛⴰ ⴰⵎⴰⵏ ⵏ ⵡⴻⵄⵣⴰⵍ, ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ. ⵍⴻⵅⵎⴻⵊ ⵏⵏⴻⵙ ⴰⵇⴰ-ⵜ ⵅⴰⵙ ⵄⴰⴷ.” ");
INSERT INTO rift_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“ⵡⴰ ⴷ ⴰⵣⴻⵔⴼ ⵅ ⵉⵊⵊ ⵏ ⴱⵏⴰⴷⴻⵎ ⵏⵏⵉ ⵉⵎⵎⵓⵜⴻⵏ ⴷⴻⴳ ⵉⵊⵊ ⵏ ⵓⵇⵉⴹⵓⵏ. ⵎⴰⵔⵔⴰ ⵡⵉ ⵖⴰ ⵢⴰⴷⴼⴻⵏ ⵖⴰⵔ ⵓⵇⵉⴹⵓⵏ ⵏⵏⵉ ⵓ ⵎⴰⵔⵔⴰ ⵡⵉ ⵖⴰ ⵉⵇⵇⵉⵎⴻⵏ ⴷⴻⴳ ⵓⵇⵉⴹⵓⵏ ⵏⵏⵉ, ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","ⵄⴰⵡⴻⴷ ⴽⵓⵍ ⵍⵇⴻⵛⵄⴻⵜ ⵢⴰⵔⴻⵣⵎⴻⵏ, ⵡⴰⵔ ⵅⴰⵙ ⵜⴰⵇⴻⴱⴱⴰⵔⵜ ⵜⴻⵇⵇⴻⵏ ⵙ ⵜⴻⵙⵖⵓⵏⵜ, ⴰⴷ ⵜⵉⵍⵉ ⵜⴻⵅⵎⴻⵊ, ");
INSERT INTO rift_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","ⵎⴰⵔⵔⴰ ⵡⵉ ⵉⵃⴰⴷⴰⵏ ⵃⴻⴷ ⵉⵜⵜⵡⴰⵙⵙⵏⵓⵇⵇⴱⴻⵏ ⵙ ⵙⵙⵉⴼ ⴷⴻⴳ ⵉⵢⵢⴰⵔ, ⵏⵉⵖ ⵛⴰ ⵏ ⵓⵎⴻⵜⵜⵉⵏ ⵏⵉⵖ ⵉⵖⵙⴰⵏ ⵏ ⵉⵊⵊ ⵏ ⴱⵏⴰⴷⴻⵎ, ⵏⵉⵖ ⵉⵊⵊ ⵏ ⵡⴻⵏⴹⴻⵍ, ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","ⵉ ⵢⵉⵊⵊ ⵏ ⵓⵎⴻⵅⵎⵓⵊ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⴽⵙⵉⵏ ⵛⵡⴰⵢⵜ ⵏ ⵉⵖⵖⴻⴹ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⵉⵛⴻⵎⴹⴻⵏ ⵓⵛⴰ ⴰⴷ ⵅⴰⵙ ⵙⵙⴼⴰⵔⵔⵖⴻⵏ ⴰⵎⴰⵏ ⵉⴷⴷⴰⵔⴻⵏ ⴷⴻⴳ ⵉⵛⵜ ⵏ ⵍⵇⴻⵛⵄⴻⵜ. ");
INSERT INTO rift_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⴷ ⴰⵎⴻⵣⴷⴰⴳ ⴰⴷ ⵉⴽⵙⵉ ⵜⵄⴻⵍⴵⴻⵜ, ⴰⴷ ⵜⵜ ⵉⵙⵙⵓⴼ ⴷⴻⴳ ⵡⴰⵎⴰⵏ ⵓⵛⴰ ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⵜ ⵉⵔⵓⵛⵛ ⵅ ⵓⵇⵉⴹⵓⵏ ⵓ ⵅ ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ ⵓ ⵅ ⵍⴻⵄⵎⵓⵔ ⵏⵏⵉ ⵜⵓⵖⴰ ⴷⵉⵏ ⵉⴵⴰⵏ, ⵓⵛⴰ ⴰⵎⵎⵓ ⵄⴰⵡⴻⴷ ⵅ ⵡⵉ ⵉⵃⴰⴷⴰⵏ ⵉⵖⵙⴰⵏ ⵏⵉⵖ ⵛⴰ ⵏ ⵢⵉⵊⵊⴻⵏ ⵏⵏⵉ ⵉⵜⵜⵡⴰⵙⵙⵏⵓⵇⵇⴱⴻⵏ ⵏⵉⵖ ⵛⴰ ⵏ ⵓⵎⴻⵜⵜⵉⵏ ⵏⵉⵖ ⵛⴰ ⵏ ⵡⴻⵏⴹⴻⵍ. ");
INSERT INTO rift_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","ⴰⵎⴻⵣⴷⴰⴳ ⴰⴷ ⵉⵔⵓⵛⵛ ⵅ ⵓⵎⴻⵅⵎⵓⵊ ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵜⵍⴰⵜⴰ ⵓ ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ ⴰⴷ ⵅⴰⵙ ⵉⵔⵓⵛⵛ ⵓ ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ ⴰⴷ ⵅⴰⵙ ⵉⴽⴽⴻⵙ ⴷⴷⴻⵏⴱ. ⴰⴷ ⵉⵚⴻⴱⴱⴻⵏ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ ⴰⴷ ⵉⵙⵙⵉⵔⴷ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵙ ⵡⴰⵎⴰⵏ ⵓⵛⴰ ⴰⴷ ⵢⵉⵍⵉ ⵉⵣⴷⴻⴳ ⴰⵍ ⵜⴰⵎⴻⴷⴷⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","ⴰⵔⵢⴰⵣ ⵉⵅⴻⵎⵊⴻⵏ ⵉ ⵡⴰⵔ ⵉⵜⵜⴻⵊⵊⵉⵏ ⴰⴷ ⵉⴽⴽⴻⵙ ⴷⴷⴻⵏⴱ ⵅ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵙ, ⵍⴻⵄⵎⴰⵔ ⵏⵏⵉ ⴰⴷ ⵉⵜⵜⵡⴰⵇⴻⵙⵙ ⵣⵉ ⵍⵡⴻⵙⵟ ⵏ ⵡⴻⴳⵔⴰⵡ ⵏ ⵍⴳⴻⵏⵙ, ⵎⵉⵏⵣⵉ ⴰⵇⴰ ⵉⵙⵙⴻⵅⵎⴻⵊ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵏ ⵙⵉⴷⵉ. ⵡⴰⵔ ⵅⴰⵙ ⵔⵓⵛⵛⴻⵏ ⴰⵎⴰⵏ ⵏ ⵡⴻⵄⵣⴰⵍ, ⴰⵇⴰ ⵉⵅⵎⴻⵊ. ");
INSERT INTO rift_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","ⵜⴰ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵚⴻⵢⵢⴻⵜ ⵉ ⵍⴻⴱⴷⴰ ⵉ ⵏⵉⵜⵏⵉ. ⵡⴻⵏⵏⵉ ⵉⵔⵓⵛⵛⴻⵏ ⴰⵎⴰⵏ ⵏ ⵡⴻⵄⵣⴰⵍ ⴰⴷ ⵉⵚⴻⴱⴱⴻⵏ ⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ ⵓ ⵡⵉ ⵖⴰ ⵉⵃⴰⴷⴰⵏ ⴰⵎⴰⵏ ⵏ ⵡⴻⵄⵣⴰⵍ, ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ⴰⵍ ⵜⴰⵎⴻⴷⴷⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⵜⵜⵡⴰⵃⴰⴷⴰⵏ ⵣⴻⴳ ⵓⵎⴻⵅⵎⵓⵊ, ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ, ⵓⵛⴰ ⴱⵏⴰⴷⴻⵎ ⵏⵏⵉ ⵉ ⵖⴰ ⵉⵃⴰⴷⴰⵏ ⴰⵢⴰ, ⴰⴷ ⵢⵉⵍⵉ ⵉⵅⵎⴻⵊ ⴰⵍ ⵜⴰⵎⴻⴷⴷⵉⵜ.” ");
INSERT INTO rift_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","ⴷⴻⴳ ⵓⵢⵓⵔ ⴰⵎⴻⵣⵡⴰⵔⵓ ⵜⵉⵡⴻⴹ ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵖⴰⵔ ⵍⴻⵅⵍⴰ ⵏ ⵚⵉⵏ. ⵍⴳⴻⵏⵙ ⵉⵇⵇⵉⵎ ⴷⵉ ⵇⴰⴷⴰⵛ. ⴷⵉⵏ ⵉ ⵜⴻⵎⵎⵓⵜ ⵎⴰⵔⵢⴰⵎ ⵓⵛⴰ ⵏⴻⴹⵍⴻⵏ ⵜⵜ ⴷⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","ⵡⴰⵔ ⵜⵓⵖⵉ ⴷⵉⵏ ⵛⴰ ⴰⵎⴰⵏ ⵉ ⵜⵎⴻⵙⵎⵓⵏⵜ. ⵅⴻⵏⵏⵉ ⵎⵓⵏⴻⵏ ⴹⵉⴷⴷ ⵉ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","ⵜⵓⵖⴰ ⵍⴳⴻⵏⵙ ⵉⵎⵛⵓⴱⴱⴻⵛ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵏⵏⴰⵏ: “ⵎⵍⵉ ⵜⵓⵖⴰ ⵣⵣⴰⵢⵏⴻⵖ ⵉⴼⴼⴻⵖ ⴱⵓⵃⴱⴻⵍ ⵓⵎⵉ ⵜⵓⵖⴰ ⵉⴼⴼⴻⵖ ⴱⵓⵃⴱⴻⵍ ⵣⴻⴳ ⴰⵢⵜⵎⴰⵜⵏⴻⵖ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ! ");
INSERT INTO rift_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","ⵎⴰⵢⴻⵎⵎⵉ ⵜⴻⵙⵙⵉⴷⴼⴻⵎ ⵡⴻⴳⵔⴰⵡ ⵏ ⵍⴳⴻⵏⵙ ⵏ ⵙⵉⴷⵉ ⴷⵉ ⵍⴻⵅⵍⴰ-ⵢⴰ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵎⵎⵜⴻⵏ ⴷⵉⵏ, ⵏⴻⵛⵛⵉⵏ ⴷ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏⵏⴻⵖ? ");
INSERT INTO rift_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","ⵓ ⵎⴰⵢⴻⵎⵎⵉ ⴷ ⴰⵏⴻⵖ ⴷⴷ-ⵜⴻⵙⵙⵉⵍⵢⴻⵎ ⵣⵉ ⵎⵉⵚⵔⴰ ⵃⵉⵎⴰ ⴰⴷ ⴰⵏⴻⵖ ⵜⴻⵙⵙⵉⵡⴹⴻⵎ ⵖⴰⵔ ⵡⴻⵎⵛⴰⵏ-ⴰ ⴰⵄⴻⴼⴼⴰⵏ? ⴷⴻⴳ ⵡⴻⵎⵛⴰⵏ-ⴰ ⵡⴰⵔ ⴷⵉⵏ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵉⵖ ⵜⴰⵣⴰⵔⵜ ⵏⵉⵖ ⵜⵣⴰⵢⴰⵔⵜ ⵏⵉⵖ ⴰⵔⴻⵎⵎⴰⵎ ⵓ ⵡⴰⵔ ⴷⵉⵏ ⵄⴰⴷ ⴰⵎⴰⵏ ⵃⵉⵎⴰ ⴰⴷ ⵏⵙⵓ.” ");
INSERT INTO rift_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","ⵅⴻⵏⵏⵉ ⵢⵉⵡⴻⴹ ⵎⵓⵙⴰ ⴰⴽ-ⴷ ⵀⴰⵔⵓⵏ ⵣⵉ ⵣⵣⴰⵜ ⵏ ⵡⵓⴷⴻⵎ ⵏ ⵡⴻⴳⵔⴰⵡ ⵏ ⵍⴳⴻⵏⵙ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ ⵓⵛⴰ ⵡⴹⴰⵏ ⵅ ⵡⵓⴷⵎⴰⵡⴻⵏ ⵏⵙⴻⵏ ⵓⵛⴰ ⵉⴱⴰⵏ ⴰⵙⴻⵏ-ⴷⴷ ⵓⵄⵓⴵⵉ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“ⴽⵙⵉ ⵜⴰⵖⵖⴰⵔⵛⵜ ⵓⵛⴰ ⵙⵎⵓⵏ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ, ⵛⴻⴽ ⴷ ⵀⴰⵔⵓⵏ, ⵓⵎⴰⵛ. ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜⴻⵙⵙⵉⵡⵍⴻⵎ ⴰⴽ-ⴷ ⵜⴻⵚⴹⴰⵔⵜ ⵣⵣⴰⵜ ⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵙⴻⵏ ⵓⵛⴰ ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⴻⵡⵛ ⴰⵎⴰⵏ ⵏⵏⴻⵙ. ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵜⴻⵙⵙⵓⴼⴼⵖⴻⵎ ⴰⵎⴰⵏ ⵉ ⵏⵉⵜⵏⵉ ⵣⵉ ⵜⴻⵚⴹⴰⵔⵜ ⵓⵛⴰ ⴰⴷ ⵜᵉⵙⵙⴻⵙⵙⵓⴷ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⴷ ⵍⴻⴱⵀⴰⵢⴻⵎ.” ");
INSERT INTO rift_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","ⵅⴻⵏⵏⵉ ⵉⴽⵙⵉ ⵎⵓⵙⴰ ⵜⴰⵖⵖⴰⵔⵛⵜ ⵣⵉ ⵣⵣⴰⵜ ⵏ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵙ ⵢⵓⵎⵓⵔ ⵏⴻⵜⵜⴰ, ");
INSERT INTO rift_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","ⵓⵛⴰ ⵉⵙⵙⵎⵓⵏ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ ⴰⴳⵔⴰⵡ ⵏ ⵍⴳⴻⵏⵙ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵜⴻⵚⴹⴰⵔⵜ. ⵏⴻⵜⵜⴰ ⵉⵏⵏⴰ ⴰⵙⴻⵏ: “ⵙⵍⴻⵎ ⵍⴻⵅⵅⵓ, ⴰ ⴽⴻⵏⵏⵉⵡ ⵉⵏⵏⵉ ⵉⵖⴻⵡⵡⵖⴻⵏ, ⵎⴰ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⵏⴻⵖ ⴰⴷ ⴷⴷ-ⵏⴻⵙⵙⵓⴼⴼⴻⵖ ⴰⵎⴰⵏ ⵣⵉ ⵜⴻⵚⴹⴰⵔⵜ-ⴰ?” ");
INSERT INTO rift_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","ⵓⵛⴰ ⵉⵙⵙⴳⴻⵄⵄⴻⴷ ⵎⵓⵙⴰ ⴰⴼⵓⵙ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⵡⵜⴰ ⵜⴰⵚⴹⴰⵔⵜ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵡⴰⵍⴰⵡⵉⵏ ⵙ ⵜⴰⵖⵖⴰⵔⵛⵜ ⵏⵏⴻⵙ ⵓⵛⴰ ⴼⴼⵖⴻⵏ-ⴷⴷ ⵣⵣⴰⵢⴻⵙ ⴰⵟⵟⴰⵙ ⵏ ⵡⴰⵎⴰⵏ ⵓⵛⴰ ⵜⴻⵙⵡⴰ ⵜⵎⴻⵙⵎⵓⵏⵜ ⴷ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ: “ⵎⵉⵏⵣⵉ ⴽⴻⵏⵏⵉⵡ ⵡⴰⵔ ⴷ ⴰⵢⵉ ⵜᵉⵜⵜⴻⵛⵍⴻⵎ ⵣⵣⴰⵜ ⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴰⵍⴰⵎⵉ ⴷ ⴰⵢⵉ ⵜⵡⴻⵇⵇⴰⵔⴻⵎ ⵙ ⵓⵡⴻⵇⵇⴰⵔ ⵉⵇⴻⴷⴷⵙⴻⵏ, ⵙ ⵓⵢⴰ ⵡⴰⵔ ⵜⴻⵙⵙⵉⴷⵉⴼⴻⵎ ⴰⴳⵔⴰⵡ-ⴰ ⵏ ⵍⴳⴻⵏⵙ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⵉ ⴷ ⴰⵙⴻⵏ ⵡⵛⵉⵖ.” ");
INSERT INTO rift_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","ⵉⵏⴰ ⴰⵇⴰ ⴷ ⴰⵎⴰⵏ ⵏ ⵎⴰⵔⵉⴱⴰ ⵎⵉⵏ ⵅⴻⴼ ⴰⵔⴻⵣⵣⵓⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴰⴷ ⵎⵛⵓⴱⴱⵛⴻⵏ ⴰⴽ-ⴷ ⵙⵉⴷⵉ ⵓ ⵎⴰⵏⵉ ⵏⴻⵜⵜⴰ ⵉⴱⴰⵏ-ⴷⴷ ⴷ ⴰⵎⵇⴻⴷⴷⴻⵙ ⵊⴰⵔ ⴰⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","ⵉⵙⵙⴻⴽⴽ ⵎⵓⵙⴰ ⵉⵔⴻⵇⵇⴰⵙⴻⵏ ⵣⵉ ⵇⴰⴷⴰⵛ ⵖⴰⵔ ⵓⵊⴻⴵⵉⴷ ⵏ ⵉⴷⵓⵎ, ⵏⵏⴰⵏ: “ⴰⵎⵎⵓ ⵉ ⵉⵇⵇⴰⵔ ⵉⵙⵔⴰⵉⵍ, ⵓⵎⴰⵛ: ‘ⵛⴻⴽ ⵜⴻⵙⵙⵏⴻⴷ ⵎⴰⵔⵔⴰ ⵜⴰⵎⴰⵔⴰ ⵏⵏⵉ ⵅⴰⵏⴻⵖ ⵉⴽⴽⵉⵏ, ");
INSERT INTO rift_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","ⴰⵇⴰ ⵍⴻⵊⴷⵓⴷ ⵏⵏⴻⵖ ⵀⵡⴰⵏ-ⴷⴷ ⵖⴰⵔ ⵎⵉⵚⵔⴰ ⵓ ⵜⵓⵖⴰ ⵏⵣⴻⴷⴷⴻⵖ ⴰⵟⵟⴰⵙ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⴷⵉ ⵎⵉⵚⵔⴰ ⵓ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ ⴳⴳⵉⵏ ⴷⴰⵢⵏⴻⵖ ⵓ ⴷⵉ ⵍⴻⵊⴷⵓⴷ ⵏⵏⴻⵖ ⴰⵟⵟⴰⵙ ⵏ ⵍⵖⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","ⵏⵍⴰⵖⴰ ⵅ ⵙⵉⴷⵉ ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵉⵙⵍⴰ ⵜⵎⵉⵊⵊⴰ ⵏⵏⴻⵖ ⵓⵛⴰ ⵉⵙⵙⴻⴽⴽ-ⴷⴷ ⵍⵎⴰⵍⴰⴽ ⵓⵛⴰ ⵉⵙⵙⵓⴼⴼⴻⵖ ⴰⵏⴻⵖ-ⴷⴷ ⵣⵉ ⵎⵉⵚⵔⴰ. ⵅⵣⴰⵔ, ⴰⵇⴰ ⴰⵏⴻⵖ ⴷⵉ ⵇⴰⴷⴰⵛ, ⵉⵛⵜ ⵏ ⵜⴻⵏⴷⵉⵏⵜ ⵖⴰⵔ ⵟⵟⴰⵔⴼ ⵏ ⵊⵊⵉⵀⴻⵜ ⵏⵏⴻⵛ. ");
INSERT INTO rift_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","ⴻⵊⵊ ⴰⵏⴻⵖ, ⵎⴰⵍⴰ ⵜⴻⵅⵙⴻⴷ, ⴰⴷ ⵏⴻⵥⵡⴰ ⵅ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⴻⵛ. ⵡⴰⵔ ⵏⵥⴻⴽⴽⵡⵉ ⵅ ⵉⵢⵢⴰⵔⴻⵏ ⵏⵉⵖ ⵅ ⵉⵎⴰⵔⵊⴰⵄⴻⵏ ⵏⵏⴻⵛ ⵏ ⵓⴹⵉⵍ ⵓ ⵡⴰⵔ ⵏᵉⵙⴻⵙⵙ ⴰⵎⴰⵏ ⵣⴻⴳ ⵡⴰⵏⵓⵜⴻⵏ. ⵅ ⵡⴻⴱⵔⵉⴷ ⵉⴳⴻⵍⵍⴷⴻⵏ ⴰⴷ ⵏⴻⵄⴷⵓ ⴱⵍⴰ ⵎⴰ ⴰⴷ ⵏⵃⴻⵢⵢⴻⴷ ⵖⴰⵔ ⵢⴻⴼⵓⵙ ⵓⵍⴰ ⵖⴰⵔ ⵓⵣⴻⵍⵎⴰⴹ, ⴰⵍ ⵖⴰ ⵏⴻⵄⴷⵓ ⵄⴰⵡⴻⴷ ⵉⵢⵎⵉⵔⴻⵏ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⴻⵛ.’” ");
INSERT INTO rift_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","ⵉⵏⵏⴰ ⴰⵙ ⵉⴷⵓⵎ: “ⵡⴰⵔ ⵜⵜⵥⴻⴽⴽⵯⵉⴷ ⵅⴰⴼⵉ, ⵏⵉⵖ ⴰⴽ ⴽⵉⵛ ⵎⵎⵙⴰⴳⴰⵔⴻⵖ ⵙ ⵙⵙⵉⴼ ⴱⴰⵍⴰⴽ!” ");
INSERT INTO rift_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","ⵅⴻⵏⵏⵉ ⵏⵏⴰⵏ ⴰⵙ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ: “ⴰⴷ ⵏⴻⴹⴼⴰⵔ ⴰⴱⵔⵉⴷ ⴰⵎⴻⵇⵇⵔⴰⵏ ⵓ ⵎⴰⵍⴰ ⴰⴷ ⵙⵡⴻⵖ ⴰⵎⴰⵏ ⵏⵏⴻⵛ, ⵏⴻⵛⵛ ⴷ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵉⵏⵓ, ⴰⴷ ⵜⴻⵏ ⵅⴻⴵⵚⴻⵖ. ⴰⴷ ⵥⵡⵉⵖ ⵜⴰⵎⵎⵓⵔⵜ ⵅ ⵉⴹⴰⵔⴻⵏ ⴷ ⵡⴻⵏⵏⵉ ⵏⴻⵜⵜⴰ ⵡⴰⵀⴰ.” ");
INSERT INTO rift_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","ⵎⴰⵛⴰ ⵏⴻⵜⵜⴰ ⵉⵏⵏⴰ: “ⵡⴰⵔ ⵅⴰⵙ ⵜⵥⴻⴽⴽⵯⵉⴷ!” ⵓⵛⴰ ⵉⴼⴼⴻⵖ ⵉⴷⵓⵎ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴽⵉⵙ ⵉⵎⵙⴰⴳⴰⵔ ⵙ ⵢⵉⵊⵊ ⵏ ⵓⴱⴰⵔⵔⵓ ⴷ ⴰⵎⴻⵇⵇⵔⴰⵏ ⴷ ⵓⴼⵓⵙ ⵉⵊⴻⵀⴷⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","ⴰⵎⵎⵓ ⵢⵓⴳⵉ ⵉⴷⵓⵎ ⴰⴷ ⵉⵡⵛ ⵜⵜⴻⵙⵔⵉⵃ ⵉ ⵉⵙⵔⴰⵉⵍ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⵥⵡⴰ ⴰⵢⵎⵉⵔ ⵏⵏⴻⵙ. ⵙ ⵓⵢⴻⵏⵏⵉ ⵉ ⵉⵊⵊⴰ ⵉⵙⵔⴰⵉⵍ ⴰⴱⵔⵉⴷ ⴷⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⵇⴰⴷⴰⵛ, ⵓⵛⴰ ⵅⴻⵏⵏⵉ ⵉⵡⴹⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵖⴰⵔ ⵡⴻⴷⵔⴰⵔ ⵏ ⵀⵓⵔ, ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⵎⴰⵔⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ ⵖⴰⵔ ⵡⴻⴷⵔⴰⵔ ⵏ ⵀⵓⵔ, ⵖⴰⵔ ⵡⴻⵢⵎⵉⵔ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵉⴷⵓⵎ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“ⴰⴷ ⵉⵎⵎⴰⵔⵏⵉ ⵀⴰⵔⵓⵏ ⵖⴰⵔ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ, ⵎⵉⵏⵣⵉ ⵡⴰⵔ ⵉⵜⵜⵉⴷⴻⴼ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⵉ ⵡⵛⵉⵖ ⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵎⵉⵏⵣⵉ ⴽⴻⵏⵏⵉⵡ ⵜⵖⴻⵏⵏⴰⵏⴻⵎ ⵅ ⵍⵓⵎⵓⵔ ⵉⵏⵓ ⵖⴰⵔ ⵡⴰⵎⴰⵏ ⵏ ⵎⴰⵔⵉⴱⴰ. ");
INSERT INTO rift_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","ⴽⵙⵉ ⵀⴰⵔⵓⵏ ⴷ ⴰⵍⵉⵄⴰⵣⴰⵔ, ⵎⵎⵉⵙ, ⵓⵛⴰ ⴰⵔⵔ ⵉ-ⵜⴻⵏ ⴰⴷ ⴳⴻⵄⵄⴷⴻⵏ ⵅ ⵡⴻⴷⵔⴰⵔ ⵏ ⵀⵓⵔ. ");
INSERT INTO rift_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","ⵄⴰⵔⵔⴰ ⵀⴰⵔⵓⵏ ⵣⴻⴳ ⵡⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ ⵓⵛⴰ ⵙⵢⴰⵔⴹ ⵉ-ⵜ ⵉ ⴰⵍⵉⵄⴰⵣⴰⵔ, ⵎⵎⵉⵙ. ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⵜⵜⵡⴰⴽⵙⵉ ⵀⴰⵔⵓⵏ ⵓⵛⴰ ⴰⴷ ⵉⵎⵎⴻⵜ ⴷⵉⵏ.” ");
INSERT INTO rift_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","ⵎⵓⵙⴰ ⵉⴳⴳⴰ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵙ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ. ⵓⵍⵢⴻⵏ ⴰⴷⵔⴰⵔ ⵏ ⵀⵓⵔ ⵣⵣⴰⵜ ⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","ⵎⵓⵙⴰ ⵉⵄⴰⵔⵔⴰ ⵀⴰⵔⵓⵏ ⵣⴻⴳ ⵡⴰⵔⵔⵓⴹ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⵙⵙⵢⴰⵔⴹ ⵉ-ⵜ ⵉ ⴰⵍⵉⵄⴰⵣⴰⵔ, ⵎⵎⵉⵙ. ⵓⵛⴰ ⵉⵎⵎⵓⵜ ⵀⴰⵔⵓⵏ ⴷⵉⵏ ⵅ ⵜⵇⵉⵛⵛⴰⵜ ⵏ ⵡⴻⴷⵔⴰⵔ. ⵅⴻⵏⵏⵉ ⵉⵀⵡⴰ-ⴷⴷ ⵎⵓⵙⴰ ⵣⴻⴳ ⵡⴻⴷⵔⴰⵔ ⴰⴽ-ⴷ ⴰⵍⵉⵄⴰⵣⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⵜⴻⵥⵔⴰ ⴱⴻⵍⵍⵉ ⵀⴰⵔⵓⵏ ⵉⴹⵍⴻⵇ ⵉ ⴱⵓⵃⴱⴻⵍ ⵏⵏⴻⵙ ⵓⵛⴰ ⵔⵓⵏ ⵜⵍⴰⵜⵉⵏ ⵏ ⵡⵓⵙⵙⴰⵏ ⴷⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⵀⴰⵔⵓⵏ, ⵎⴰⵔⵔⴰ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","ⵓⵎⵉ ⵉⵙⵍⴰ ⴰⴽⴻⵏⵄⴰⵏⵉ, ⴰⵊⴻⴵⵉⴷ ⵏ ⵄⴰⵔⴰⴷ ⵏⵏⵉ ⵉⵣⴻⴷⴷⵖⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵍⵊⴰⵏⵓⴱ, ⴱⴻⵍⵍⵉ ⵢⵓⵙⴰ-ⴷⴷ ⵉⵙⵔⴰⵉⵍ ⵅ ⵡⴻⴱⵔⵉⴷ ⵏ ⵉⴱⴻⵔⴳⴰⴳⴻⵏ, ⵉⵎⵎⵏⴻⵖ ⴹⵉⴷⴷ ⵉ ⵉⵙⵔⴰⵉⵍ ⵓⵛⴰ ⵉⵟⵟⴻⴼ ⵛⴰ ⵣⵣⴰⵢⵙⴻⵏ ⴷ ⵉⵎⴻⵃⴱⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","ⵅⴻⵏⵏⵉ ⵉⵡⵛⴰ ⵉⵙⵔⴰⵉⵍ ⵉⵊⵊ ⵏ ⵡⴰⵡⴰⵍ ⵉ ⵙⵉⴷⵉ ⵓⵛⴰ ⵉⵏⵏⴰ: “ⵎⴰⵍⴰ ⴷ ⵜⵉⴷⴻⵜⵜ ⵜⵄⴰⵔⵔⵏⴻⴷ ⵍⴳⴻⵏⵙ-ⴰ ⴷⴻⴳ ⵓⴼⵓⵙ ⵉⵏⵓ, ⵏⴻⵛⵛ ⴰⴷ ⵃⴰⵔⵔⵎⴻⵖ ⵜⵉⵏⴻⴷⴷⴰⵎ ⵏⵙⴻⵏ ⵉ ⵓⵜⴻⵃⵃⵉ.” ");
INSERT INTO rift_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","ⵙⵉⴷⵉ ⵉⵙⵜⴰⵊⴻⴱ ⵉ ⵉⵙⵔⴰⵉⵍ ⵓⵛⴰ ⵉⵙⴻⵍⵍⴻⵎ ⴰⵙ ⴰⵢⵜ ⵏ ⴽⴻⵏⵄⴰⵏ ⵓⵛⴰ ⵏⵉⵜⵏⵉ ⵃⴰⵔⵔⵎⴻⵏ ⵉ-ⵜⴻⵏ ⵉ ⵓⵜⴻⵃⵃⵉ ⵓⵍⴰ ⴷ ⵎⴰⵔⵔⴰ ⵜⵉⵏⴻⴷⴷⴰⵎ ⵏⵙⴻⵏ ⵓⵛⴰ ⵉⵍⴰⵖⴰ ⴰⵎⵛⴰⵏ ⵏⵏⵉ ⵙ ⵢⵉⵙⴻⵎ ⵏ ⵃⵓⵔⵎⴰ. ");
INSERT INTO rift_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","ⵅⴻⵏⵏⵉ ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⵣⴻⴳ ⵡⴻⴷⵔⴰⵔ ⵏ ⵀⵓⵔ, ⵔⵓⵃⴻⵏ ⵅ ⵡⴻⴱⵔⵉⴷ ⵖⴰⵔ ⵍⴻⴱⵃⴰⵔ ⵏ ⵜⴻⵍⴳⴰ ⵓⵛⴰ ⵙ ⵎⴰⵏ ⴰⵢⴰ ⵜⵓⵖⴰ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵏⵏⴹⴻⵏ ⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵉⴷⵓⵎ. ⵓⵛⴰ ⵍⴳⴻⵏⵙ ⵡⴰⵔ ⵉⵚⴱⵉⵔ ⴷⴻⴳ ⵡⴻⴱⵔⵉⴷ. ");
INSERT INTO rift_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","ⴰⵇⴰ ⵉⵇⴰⵛⴻⵃ ⵍⴳⴻⵏⵙ ⴹⵉⴷⴷ ⵉ ⴰⵔⴻⴱⴱⵉ ⴷ ⵎⵓⵙⴰ: “ⵎⴰⵢⴻⵎⵎⵉ ⴷ ⴰⵏⴻⵖ ⴷⴷ-ⵜⴻⵙⵙⵓⴼⴼⵖⴻⵎ ⵣⵉ ⵎⵉⵚⵔⴰ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵏⴻⵎⵎⴻⵜ ⴷⵉ ⵍⴻⵅⵍⴰ-ⵢⴰ? ⵡⴰⵔ ⴷⴰ ⵉⴵⵉ ⵡⴻⵖⵔⵓⵎ ⵓⵍⴰ ⴷ ⴰⵎⴰⵏ. ⵍⴻⵄⵎⴰⵔ ⵏⵏⴻⵖ ⵉⵄⵉⴼⴼ ⵣⴻⴳ ⵡⴻⵖⵔⵓⵎ-ⴰ ⵉ ⵡⴰⵔ ⵉⵙⴻⴽⴽⵡⵉⵏ!” ");
INSERT INTO rift_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","ⵅⴻⵏⵏⵉ ⵉⴹⵍⴻⵇ ⵙⵉⴷⵉ ⵉⴼⵉⵖⵔⴰⵏ ⵢⴰⵔⴻⵇⵇⴻⵏ ⵊⴰⵔ ⵍⴳⴻⵏⵙ, ⵉⵏⵏⵉ ⵉⵣⴻⵄⴼⴻⵏ ⵍⴳⴻⵏⵙ ⵓⵛⴰ ⵉⵎⵎⵓⵜ ⵡⴰⵟⵟⴰⵙ ⵏ ⵍⴳⴻⵏⵙ ⵏ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","ⵢⵓⵙⴰ-ⴷⴷ ⵍⴳⴻⵏⵙ ⵖⴰⵔ ⵎⵓⵙⴰ, ⵏⵏⴰⵏ: “ⴰⵇⴰ ⵏⴻⵅⴹⴰ, ⵎⵉⵏⵣⵉ ⵏⵇⴰⵛⴻⵃ ⴰⴽ-ⴷ ⵙⵉⴷⵉ ⵓ ⴰⴽⵉⴷⴻⴽ. ⵥⴰⴵ ⵉ ⵙⵉⴷⵉ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵅⴰⵏⴻⵖ ⵉⴽⴽⴻⵙ ⵉⴼⵉⵖⵔⴰⵏ-ⴰ.” ⵅⴻⵏⵏⵉ ⵉⵥⵓⴵ ⵎⵓⵙⴰ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏ ⵍⴳⴻⵏⵙ. ");
INSERT INTO rift_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⴻⴳⴳ ⵉⵊⵊ ⵏ ⵓⴼⵉⵖⴰⵔ ⵢⴰⵔⴻⵇⵇⴻⵏ ⵓⵛⴰ ⵙⴰⵔⵙ ⵉ-ⵜ ⵅ ⵉⵛⵜ ⵏ ⵜⴻⵃⵏⴰⵛⵜ ⵓⵛⴰ ⵎⴰⵏ ⵡⴻⵏ ⵎⴰ ⵉⵜⵜⵡⴰⵣⴻⵄⴼⴻⵏ ⵓ ⴰⴷ ⵖⴰⵔⴻⵙ ⵉⵅⵣⴰⵔ, ⴰⴷ ⵉⴷⴷⴰⵔ.” ");
INSERT INTO rift_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","ⵓⵛⴰ ⵉⴳⴳⴰ ⵎⵓⵙⴰ ⵉⵊⵊ ⵏ ⵓⴼⵉⵖⴰⵔ ⵏ ⵏⵏⵃⴰⵙ ⵓⵛⴰ ⵉⵙⵙⴰⵔⵙ ⵉ-ⵜ ⵅ ⵜⴻⵃⵏⴰⵛⵜ ⵓⵛⴰ ⵅⵎⵉ ⵉⵣⴻⵄⵄⴻⴼ ⵛⴰ ⵏ ⵓⴼⵉⵖⴰⵔ ⵛⴰ ⵏ ⵢⵉⵊⵊⴻⵏ, ⵓⵛⴰ ⵡⴰⵏⵉⵜⴰ ⵉⵅⴻⵣⵣⴰⵔ ⵖⴰⵔ ⵓⴼⵉⵖⴰⵔ ⵏ ⵏⵏⵃⴰⵙ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⵇⵇⵉⵎ ⵉⴷⴷⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","ⵅⴻⵏⵏⵉ ⴼⴻⵙⵢⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⵓⴱⵓⵜ. ");
INSERT INTO rift_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","ⵅⴻⵏⵏⵉ ⴽⴽⵙⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⵣⵉ ⵓⴱⵓⵜ, ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⵖⴰⵔ ⴰⵔⵡⵉⵏⴰⵜ ⵏ ⵄⴰⴱⴰⵔⵉⵎ ⴷⵉ ⵍⴻⵅⵍⴰ ⵉ ⵉⴵⴰⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵎⵓ’ⴰⴱ ⵎⴰⵏⵉⵙ ⴷⴷ-ⵜⵏⴻⵇⵇⴰⵔ ⵜⴼⵓⵛⵜ. ");
INSERT INTO rift_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","ⵙⵙⴻⵏⵏⵉ ⴽⴽⵙⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⵜⴻⵖⵣⵓⵔⵜ ⵏ ⵣⴰⵔⴰⴷ. ");
INSERT INTO rift_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","ⵙⵙⴻⵏⵏⵉ ⴽⴽⵙⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⵅ ⵓⵊⴻⵎⵎⴰⴹ ⵏ ⵢⴻⵖⵣⴰⵔ ⵏ ⴰⵔⵏⵓⵏ, ⵡⴻⵏⵏⵉ ⵉⵙⵙⵉⵣⵍⴻⵏ ⴷⵉ ⵍⴻⵅⵍⴰ, ⵉⴼⴼⴻⵖ ⵣⵉ ⵊⵊⵉⵀⴻⵜ ⵏ ⵡⴻⵢⵎⵉⵔ ⵏ ⵉⵎⵓⵔⵉⵢⵢⴻⵏ, ⵎⵉⵏⵣⵉ ⴰⵇⴰ ⴰⵔⵏⵓⵏ ⴷ ⴰⵢⵎⵉⵔ ⴰⴽ-ⴷ ⵎⵓ’ⴰⴱ, ⵊⴰⵔ ⵎⵓ’ⴰⴱ ⴷ ⵉⵎⵓⵔⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","ⵅ ⵓⵢⴰ ⵇⵇⴰⵔⴻⵏ ⴷⴻⴳ ⵡⴻⴷⵍⵉⵙ ⵉⵜⵜⵡⴰⵏⵏⴹⴻⵏ ⵏ ⴳⴰⵔⵔⴰⵜ ⵏ ⵙⵉⴷⵉ: “ⵡⴰⵀⵉⴱ ⴷⵉ ⵙⵓⴼⴰ ⴷ ⵜⵖⴻⵣⵔⴰⵜⵉⵏ ⵏ ⴰⵔⵏⵓⵏ, ");
INSERT INTO rift_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","ⵓ ⵜⵉⵖⴻⵣⵔⴰⵜⵉⵏ ⵉ ⴷⴷ-ⵉⵀⴻⴽⴽⵡⴰⵏ, ⴰⵍⴰⵎⵉ ⵎⴻⵢⵢⵍⴻⵏⵜ ⵖⴰⵔ ⵜⵣⴻⴷⴷⵉⵖⵜ ⵏ ⵄⴰⵔ, ⴷ ⵜⴻⵏⵏⵉ ⵉⵙⴻⵏⵏⴷⴻⵏ ⵅ ⵡⴻⵢⵎⵉⵔ ⵏ ⵎⵓ’ⴰⴱ.” ");
INSERT INTO rift_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","ⵙⵙⴻⵏⵏⵉ ⵔⵓⵃⴻⵏ ⵖⴰⵔ ⴱⵉ’ⵔ, ‘ⴰⵏⵓ’. ⵡⴰ ⴰⵇⴰ ⴷ ⴰⵏⵓ ⵎⵉⵏ ⵅⴻⴼ ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⵙⵎⵓⵏ ⵍⴳⴻⵏⵙ, ⵅⴻⵏⵏⵉ ⴰⴷ ⴰⵙⴻⵏ ⵡⵛⴻⵖ ⴰⵎⴰⵏ.” ");
INSERT INTO rift_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","ⵅⴻⵏⵏⵉ ⵉⵖⴻⵏⵏⴻⵊ ⵉⵙⵔⴰⵉⵍ ⵉⵣⵍⵉ-ⵢⴰ: “ⵏⴳⴻⵣ, ⴰ ⴰⵏⵓ!” ⴰⵔⵔⵉⵎ-ⴷⴷ ⵅⴰⵙ ⵙ ⵉⵊⵊ ⵏ ⵉⵣⵍⵉ: ");
INSERT INTO rift_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","“ⵛⴻⴽ ⴰⵏⵓ, ⵡⴻⵏⵏⵉ ⵖⵣⵉⵏ ⵍⵃⵓⴽⴽⴰⵎ, ⵡⴻⵏⵏⵉ ⵉⵏⴻⵇⵛⴻⵏ ⵜⴰⵔⵡⴰ ⵏ ⵜⴰⵚⵉⵍⴻⵜ ⵏ ⵍⴳⴻⵏⵙ ⴰⴽ-ⴷ ⵓⵎⴳⴻⵡⵡⴰⴷ ⵏⵙⴻⵏ ⵙ ⵉⵣⴻⴵⴰⴹⴻⵏ ⵏⵙⴻⵏ ⵏ ⵍⴻⵃⴽⴰⵎⴻⵜ.” ⵣⵉ ⵍⴻⵅⵍⴰ ⵔⵓⵃⴻⵏ ⵖⴰⵔ ⵎⴰⵜⵜⴰⵏⴰ, ");
INSERT INTO rift_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","ⵓⵛⴰ ⵣⵉ ⵎⴰⵜⵜⴰⵏⴰ ⵖⴰⵔ ⵏⴰⵃⵍⵉⵢⵉⵍ, ⵣⵉ ⵏⴰⵃⵍⵉⵢⵉⵍ ⵖⴰⵔ ⴱⴰⵎⵓⵜ, ");
INSERT INTO rift_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","ⵓⵛⴰ ⵣⵉ ⴱⴰⵎⵓⵜ ⵖⴰⵔ ⵜⴻⵖⵣⵓⵔⵜ ⵏⵏⵉ ⵉⴵⴰⵏ ⴷⴻⴳ ⵉⵢⵢⴰⵔ ⵏ ⵎⵓ’ⴰⴱ, ⵅ ⵜⵇⵉⵛⵛⴰⵜ ⵏ ⴼⵉⵙⵊⴰ ⵏⵏⵉ ⵉⵜⵜⵙⵉⵊⵊⴰⵏ ⵖⴰⵔ ⵜⵏⴻⵣⵔⵓⴼⵜ. ");
INSERT INTO rift_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","ⵅⴻⵏⵏⵉ ⵉⵙⵙⴻⴽⴽ ⵉⵙⵔⴰⵉⵍ ⵉⵔⴻⵇⵇⴰⵙⴻⵏ ⵖⴰⵔ ⵙⵉⵃⵓⵏ, ⴰⵊⴻⴵⵉⴷ ⵏ ⵉⵎⵓⵔⵉⵢⵢⴻⵏ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“ⴻⵊⵊ ⴰⵢⵉ ⴰⴷ ⵛⵓⵇⴻⵖ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⴻⵛ. ⵡⴰⵔ ⵏⴻⵜⵜⵎⴻⵢⵢⵉⵍ ⵛⴰ ⵖⴰⵔ ⵉⵢⵢⴰⵔⴻⵏ ⵏⵉⵖ ⵖⴰⵔ ⵉⵎⴰⵔⵊⴰⵄⴻⵏ ⵏⵏⴻⵛ ⵏ ⵓⴹⵉⵍ ⵓ ⵡⴰⵔ ⵏⵙⴻⵙⵙ ⴰⵎⴰⵏ ⵣⴻⴳ ⵡⴰⵏⵓⵜⴻⵏ. ⴰⴷ ⵏⴻⵄⴷⵓ ⵅ ⵡⴻⴱⵔⵉⴷ ⵉⴳⴻⵍⵍⴷⴻⵏ, ⴰⵍ ⵖⴰ ⵏⴻⵄⴷⵓ ⵅ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⴻⵛ.” ");
INSERT INTO rift_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","ⵎⴰⵛⴰ ⵙⵉⵃⵓⵏ ⵡⴰⵔ ⵢⴻⵊⵊⵉ ⴰⴷ ⵉⵥⵡⴰ ⵉⵙⵔⴰⵉⵍ ⵅ ⵊⵊⵡⴰⵢⴻⵀ ⵏⵏⴻⵙ. ⵉⵙⵙⵎⵓⵏ ⵙⵉⵃⵓⵏ ⵎⴰⵔⵔⴰ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⴼⴼⴻⵖ, ⵃⵉⵎⴰ ⴰⴷ ⵉⵎⵙⴰⴳⴰⵔ ⴰⴽ-ⴷ ⵉⵙⵔⴰⵉⵍ, ⵖⴰⵔ ⵍⴻⵅⵍⴰ, ⵓⵛⴰ ⵢⵓⵙⴰ-ⴷⴷ ⴷⵉ ⵢⴰⵀⴰⵚ ⵓⵛⴰ ⵉⵎⵎⵏⴻⵖ ⴰⴽ-ⴷ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","ⵓⵛⴰ ⵉⵙⵔⴰⵉⵍ ⵉⵡⵜⴰ ⵉ-ⵜ ⵙ ⵍⴻⵇⴹⴻⵄ ⵏ ⵙⵙⵉⴼ ⵓⵛⴰ ⵉⴽⵙⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⴻⵙ ⴷ ⵍⵡⴰⵔⵜ, ⵣⵉ ⴰⵔⵏⵓⵏ ⴰⵍ ⵢⴰⴱⴱⵓⵇ, ⴰⵍ ⴰⵢⵜ ⵏ ⵄⴰⵎⵎⵓⵏ, ⵎⵉⵏⵣⵉ ⵊⵊⵉⵀⴻⵜ ⵏ ⴰⵢⵜ ⵏ ⵄⴰⵎⵎⵓⵏ ⴰⵇⴰ-ⵜ ⴷ ⵉⵊⵊ ⵏ ⵍⴱⵓⵔⵊ ⵉⵊⴻⵀⴷⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","ⵉⴽⵙⵉ ⵉⵙⵔⴰⵉⵍ ⵎⴰⵔⵔⴰ ⵜⵉⵏⴻⴷⴷⴰⵎ-ⴰ ⵓⵛⴰ ⵉⵣⴷⴻⵖ ⵉⵙⵔⴰⵉⵍ ⴷⵉ ⵎⴰⵔⵔⴰ ⵜⵉⵏⴻⴷⴷⴰⵎ ⵏ ⵉⵎⵓⵔⵉⵢⵢⴻⵏ, ⴷⵉ ⵃⴰⵛⴱⵓⵏ ⵓ ⴷⵉ ⵎⴰⵔⵔⴰ ⵜⵏⴻⴷⴷⴰⵎ ⵉ ⵖⴰⵔⴻⵙ ⴷⴷ-ⵉⵇⵇⵏⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","ⵎⵉⵏⵣⵉ ⵃⴰⵛⴱⵓⵏ ⵜⵓⵖⴰ ⴷ ⵜⴰⵏⴷⵉⵏⵜ ⵏ ⵙⵉⵃⵓⵏ, ⴰⵊⴻⴵⵉⴷ ⵏ ⵉⵎⵓⵔⵉⵢⵢⴻⵏ, ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵜⵓⵖⴰ ⵉⵎⵎⵏⴻⵖ ⴰⴽ-ⴷ ⵓⵊⴻⴵⵉⴷ ⵉ ⴷ ⴰⵙ ⴷⴷ-ⵉⵣⵡⴰⵔⴻⵏ ⵏ ⵎⵓ’ⴰⴱ ⵓⵛⴰ ⵉⴽⵙⵉ ⵣⵣⴰⵢⴻⵙ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵎⵓⵔⵜ ⵏⵏⴻⵙ ⴰⵍ ⴰⵔⵏⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","ⵅ ⵓⵢⴰ ⵇⵇⴰⵔⴻⵏ ⵉⵏⵏⵉ ⵉⵙⵙⴰⵡⴰⵍⴻⵏ ⵙ ⵡⴰⵡⴰⵍⴻⵏ ⵉⵡⴻⵣⵏⴻⵏ: “ⴰⵙⴻⵎ-ⴷⴷ ⵖⴰⵔ ⵃⴰⵛⴱⵓⵏ, ⴰⴷ ⵜᵉⵜⵜⵡⴰⴱⵏⴰ ⵓ ⴰⴷ ⵜᵉⵜⵜⵡⴰⵄⴷⴻⵍ ⵜⴻⵏⴷⵉⵏⵜ ⵏ ⵙⵉⵃⵓⵏ! ");
INSERT INTO rift_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","ⵎⵉⵏⵣⵉ ⵜⴻⴼⴼⴻⵖ-ⴷⴷ ⵜⵎⴻⵙⵙⵉ ⵣⵉ ⵃⴰⵛⴱⵓⵏ ⴷ ⵉⵊⵊ ⵏ ⵓⵄⴻⵛⵛⴰⵍ ⵣⵉ ⵜⴻⵏⴷⵉⵏⵜ ⵏ ⵙⵉⵃⵓⵏ, ⴰⵛⴻⵄⵄⴰⵍ ⵏⵏⵉ ⵉⵛⵛⴰ ⵄⴰⵔ ⵏ ⴰⵢⵜ ⵏ ⵎⵓ’ⴰⴱ ⵍⵃⵓⴽⴽⴰⵎ ⵏ ⵍⵓⵄⵍⴰⵜ ⵏ ⴰⵔⵏⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","ⵓⵛⵜ ⵅⴰⴽ, ⵎⵓ’ⴰⴱ! ⴰⵇⴰ ⵉⵜⵜⵡⴰⵀⴻⵍⵍⴻⴽ ⵍⴳⴻⵏⵙ ⵏ ⴽⴰⵎⵓⵛ. ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ ⵉ ⵜⵓⵖⴰ ⵢⴰⵔⴻⵡⵍⴻⵏ ⴷ ⵜⵃⴻⵏⵊⵉⵔⵉⵏ ⵏⵏⴻⵙ, ⴰⵇⴰ ⵉⵙⴻⵍⵍⴻⵎ ⵉ-ⵜⴻⵏ ⴷ ⵉⵎⴻⵃⴱⴰⵙ ⵉ ⵙⵉⵃⵓⵏ, ⴰⵊⴻⴵⵉⴷ ⵏ ⵉⵎⵓⵔⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","ⴰⵇⴰ ⵏⴻⵡⵡⴻⵜ ⵉ-ⵜⴻⵏ ⵙ ⴼⵍⵉⵜⵛⴰⵜ. ⵃⴰⵛⴱⵓⵏ ⵉⵜⵜⵡⴰⵀⴻⵍⵍⴻⴽ ⴰⵍ ⴷⵉⴱⵓⵏ. ⵏⴰⵔⴻⴷⴷⴻⴵ ⵉ-ⵜⴻⵏ ⴰⵍ ⵏⵓⴼⴰⵃ ⵜⴻⵏⵏⵉ ⵉⴵⴰⵏ ⴰⵍ ⵎⵉⴷⴰⴱⴰ.” ");
INSERT INTO rift_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","ⴰⵎⵎⵓ ⵉ ⵉⴷⵡⴻⵍ ⵉⵙⵔⴰⵉⵍ ⴰⴷ ⵉⵣⴷⴻⵖ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵉⵎⵓⵔⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","ⵓⵛⴰ ⵉⵙⵙⴻⴽⴽ ⵎⵓⵙⴰ ⵉⴱⴻⵔⴳⴰⴳⴻⵏ ⵖⴰⵔ ⵢⴰⵄⵣⵉⵔ ⵓⵛⴰ ⴽⵙⵉⵏ ⵜⵉⵏⴻⴷⴷⴰⵎ ⵉ ⵖⴰⵔⴻⵙ ⴷⴷ-ⵉⵇⵇⵏⴻⵏ ⵓⵛⴰ ⴽⴽⵙⴻⵏ ⵜⴰⵙⵖⴰⵔⵜ ⵏ ⵉⵎⵓⵔⵉⵢⵢⴻⵎ ⵏⵏⵉ ⵜⵓⵖⴰ ⴷⵉⵏ ⵉⵣⴻⴷⴷⵖⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","ⵅⴻⵏⵏⵉ ⵎⴻⵢⵢⵍⴻⵏ ⵣⴻⴳ ⵡⴻⴱⵔⵉⴷ ⵏⵙⴻⵏ, ⵓⵍⵢⴻⵏ ⴰⴱⵔⵉⴷ ⵖⴰⵔ ⴱⴰⵛⴰⵏ. ⵅⴻⵏⵏⵉ ⵉⴼⴼⴻⵖ-ⴷⴷ ⵄⵓⵊ, ⴰⵊⴻⴵⵉⴷ ⵏ ⴱⴰⵛⴰⵏ, ⵏⴻⵜⵜⴰ ⴷ ⵎⴰⵔⵔⴰ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴽⵉⴷⵙⴻⵏ ⵉⵎⵙⴰⴳⴰⵔ ⵉ ⵓⵎⴻⵏⵖⵉ ⴷⵉ ⵉⴷⵔⴰⵄⵉ. ");
INSERT INTO rift_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⵡⴰⵔ ⵣⵣⴰⵢⴻⵙ ⵜⵜⴻⴳⴳⵯⴻⴷ ⵛⴰ, ⵎⵉⵏⵣⵉ ⵏⴻⵛⵛ ⴳⴳⵉⵖ ⵜ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏⵏⴻⵛ, ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ ⴷ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵜⴻⴳⴳⴻⴷ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⴻⴳⴳⵉⴷ ⵣⵉ ⵙⵉⵃⵓⵏ ⴰⵊⴻⴵⵉⴷ ⵏ ⵉⵎⵓⵔⵉⵢⵢⴻⵏ, ⵡⴻⵏⵏⵉ ⵜⵓⵖⴰ ⵉⵣⴻⴷⴷⵖⴻⵏ ⴷⵉ ⵃⴰⵛⴱⵓⵏ.” ");
INSERT INTO rift_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","ⵓⵛⴰ ⴰⵔⴻⴷⴷⴵⴻⵏ ⵜ, ⵏⴻⵜⵜⴰ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ ⴷ ⵎⴰⵔⵔⴰ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ, ⴰⵍ ⵎⴰⵏⵉ ⵡⴰⵔ ⵉⵇⵇⵉⵎ ⵓⵍⴰ ⴷ ⵉⵊⵊ ⵏ ⵓⵎⴰⵍⵡⴰⵔ ⵣⵣⴰⵢⴻⵙ ⵓⵛⴰ ⴽⵙⵉⵏ ⵜⴰⵎⵎⵓⵔⵜ ⵏⵏⴻⵙ ⴷ ⵍⵡⴰⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","ⵅⴻⵏⵏⵉ ⴼⴻⵙⵢⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⵍⴻⵡⴹⴰⵜ ⵏ ⵎⵓ’ⴰⴱ, ⴰⵔⴻⵏⴷⴰⴷ ⵏ ⴰⵔⵉⵃⴰ ⵏⵏⵉ ⵉⴵⴰⵏ ⵅ ⵓⵊⴻⵎⵎⴰⴹ ⵏ ⵍ’ⵓⵔⴷⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","ⵓⵛⴰ ⵉⵥⵔⴰ ⴱⴰⵍⴰⵇ, ⵎⵎⵉⵙ ⵏ ⵚⵉⴼⴼⵓⵔ, ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⴳⴳⴰ ⵉⵙⵔⴰⵉⵍ ⴷⴻⴳ ⵉⵎⵓⵔⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","ⵎⵓ’ⴰⴱ ⵜⵓⵖⴰ ⵉⵜⵜⴻⴳⴳⵯⴻⴷ ⴰⵟⵟⴰⵙ ⵣⵉ ⵍⴳⴻⵏⵙ-ⴰ, ⵎⵉⵏⵣⵉ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⴻⴳ ⵡⴰⵟⵟⴰⵙ. ⵎⵓ’ⴰⴱ ⵜⵓⵖⴰ ⵉⵜⵜⵏⴻⵅⵍⴰⵄ ⵣⴻⴳ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵎⵓ’ⴰⴱ ⵉ ⵉⵎⵖⴰⵔⴻⵏ ⵏ ⵎⵉⴷⵢⴰⵏ: “ⵍⴻⵅⵅⵓ ⵍⵖⴰⵛⵉ-ⵢⴰ ⴰⴷ ⵉⵍⵙⴻⵃ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴷ ⴰⵏⴻⵖ-ⴷⴷ ⵉⵏⵏⴹⴻⵏ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵉⵍⴻⵙⵙⴻⵃ ⵓⴼⵓⵏⴰⵙ ⵜⴰⵣⵉⵢⵣⴰⵡⵜ ⵏ ⵢⴻⵢⵢⴰⵔ.” ⵜⵓⵖⴰ ⴱⴰⵍⴰⵇ, ⵎⵎⵉⵙ ⵏ ⵚⵉⴼⴼⵓⵔ, ⴰⵊⴻⴵⵉⴷ ⵏ ⵎⵓ’ⴰⴱ. ");
INSERT INTO rift_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","ⵉⵙⵙⴻⴽⴽ ⵉⵔⴻⵇⵇⴰⵙⴻⵏ ⵖⴰⵔ ⴱⴰⵍⵄⴰⵎ, ⵎⵎⵉⵙ ⵏ ⴱⴰⵄⵓⵔ, ⵖⴰⵔ ⵜⴻⵏⴷⵉⵏⵜ ⵏ ⴼⴰⵜⵓⵔ ⵖⴰⵔ ⵢⴻⵖⵣⴰⵔ ⵏ ⵍⴼⵓⵔⴰⵟ, ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴰⵢⵜ ⵏ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴰⵙ ⴷⴷ-ⵍⴰⵖⴰⵏ ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵉⵏⵏⴰ: “ⵅⵣⴰⵔ, ⵉⴼⴼⴻⵖ-ⴷⴷ ⵉⵊⵊ ⵏ ⵍⴳⴻⵏⵙ ⵣⵉ ⵎⵉⵚⵔⴰ ⵓⵛⴰ ⵅⵣⴰⵔ, ⴰⵇⴰ ⵉⴷⵍⴰ ⵓⴷⴻⵎ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵓⵛⴰ ⴰⵇⴰ ⵏⵉⵜⵏⵉ ⵣⴻⴷⴷⵖⴻⵏ ⵏⵉⵛⴰⵏ ⴰⵔⴻⵏⴷⴰⴷ ⵉⵏⵓ. ");
INSERT INTO rift_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","ⴰⵙ-ⴷⴷ ⵍⴻⵅⵅⵓ, ⵏⵄⴻⵍ ⵍⴳⴻⵏⵙ ⴷⵉ ⵟⵟⵡⴻⵄ ⵉⵏⵓ, ⵎⵉⵏⵣⵉ ⴰⵇⴰ ⵉⵊⵀⴻⴷ ⵅⴰⴼⵉ. ⴰⴷ ⵜⴰⵖ ⵏⴻⵛⵛ ⵣⴻⵎⵎⴰⵔⴻⵖ ⴰⴷ ⵜ ⵖⴻⵍⴱⴻⵖ ⵏⵉⵖ ⴰⴷ ⵜ ⵙⵙⵓⴼⴼⵖⴻⵖ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ, ⵎⵉⵏⵣⵉ ⵏⴻⵛⵛ ⵙⵙⵏⴻⵖ ⴱⴻⵍⵍⵉ ⵡⵉ ⵖⴰ ⵜⴱⴰⵔⴽⴻⴷ ⵛⴻⴽ, ⴰⴷ ⵉⵜⵜⵡⴰⴱⴰⵔⴻⴽ ⵓ ⵡⵉ ⵖⴰ ⵜⵏⴻⵄⵍⴻⴷ, ⴰⴷ ⵉⵜⵜⵡⴰⵏⵄⴻⵍ.” ");
INSERT INTO rift_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","ⵅⴻⵏⵏⵉ ⵔⵓⵃⴻⵏ ⵉⵎⵖⴰⵔⴻⵏ ⵏ ⵎⵓ’ⴰⴱ ⴷ ⵉⵎⵖⴰⵔⴻⵏ ⵏ ⵎⵉⴷⵢⴰⵏ ⴰⴽ-ⴷ ⵍⵎⵓⵏⴻⵜ ⵏ ⵓⵄⴻⵣⵣⴻⵎ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏⵙⴻⵏ, ⵉⵡⴹⴻⵏ ⵖⴰⵔ ⴱⴰⵍⵄⴰⵎ ⵓⵛⴰ ⵙⵙⵉⵡⵍⴻⵏ ⴰⴽⵉⴷⴻⵙ ⵙ ⵡⴰⵡⴰⵍⴻⵏ ⵏ ⴱⴰⵍⴰⴽ. ");
INSERT INTO rift_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","ⵏⴻⵜⵜⴰ ⵉⵏⵏⴰ ⴰⵙⴻⵏ: “ⵙⴻⵏⵙⴻⵎ ⴷⴰ ⴵⵉⵍⴻⵜ-ⴰ, ⵅⴻⵏⵏⵉ ⵏⴻⵛⵛ ⴰⴷ ⵅⴰⵡⴻⵎ ⴷⴷ-ⴰⵔⵔⴻⵖ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵖⴰⵔⵉ ⵖⴰ ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ.” ⵅⴻⵏⵏⵉ ⵇⵇⵉⵎⴻⵏ ⵍⵃⵓⴽⴽⴰⵎ ⵏ ⵎⵓ’ⴰⴱ ⵖⴰⵔ ⴱⴰⵍⵄⴰⵎ. ");
INSERT INTO rift_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","ⵢⵓⵙⴰ-ⴷⴷ ⴰⵔⴻⴱⴱⵉ ⵖⴰⵔ ⴱⴰⵍⵄⴰⵎ, ⵉⵏⵏⴰ: “ⵎⵉⵏ ⵄⵏⴰⵏ ⵉⵔⵢⴰⵣⴻⵏ ⵏⵏⵉ ⵉⴵⴰⵏ ⴰⴽⵉⴷⴻⴽ?” ");
INSERT INTO rift_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","ⵉⵏⵏⴰ ⴱⴰⵍⵄⴰⵎ ⵉ ⴰⵔⴻⴱⴱⵉ: “ⴱⴰⵍⴰⴽ, ⵎⵎⵉⵙ ⵏ ⵚⵉⴼⴼⵓⵔ, ⴰⵊⴻⴵⵉⴷ ⵏ ⵎⵓ’ⴰⴱ, ⵉⵙⵙⴻⴽⴽ ⵉ-ⵜⴻⵏ-ⴷⴷ ⵖⴰⵔⵉ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘ⵅⵣⴰⵔ, ⵉⵊⵊ ⵏ ⵍⴳⴻⵏⵙ ⵉⴼⴼⴻⵖ-ⴷⴷ ⵣⵉ ⵎⵉⵚⵔⴰ ⵓ ⴰⵇⴰ ⵉⴷⵍⴰ ⵓⴷⴻⵎ ⵏ ⵜⴻⵎⵎⵓⵔⵜ. ⴰⵙ-ⴷⴷ, ⵏⵄⴻⵍ ⵉ-ⵜ ⴷⵉ ⵟⵟⵡⴻⵄ ⵉⵏⵓ. ⴰⴷ ⵜⴰⵖ ⵣⴻⵎⵎⴰⵔⴻⵖ ⵅⴻⵏⵏⵉ ⴰⴷ ⴽⵉⵙⴻⵏ ⵎⴻⵏⵖⴻⵖ ⵏⵉⵖ ⴰⴷ ⵜⴻⵏ ⵙⵙⵓⴼⴼⵖⴻⵖ.’” ");
INSERT INTO rift_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","ⵉⵏⵏⴰ ⴰⵔⴻⴱⴱⵉ ⵉ ⴱⴰⵍⵄⴰⵎ: “ⵡⴰⵔ ⵜⵜⵔⵉⵃ ⴽⵉⵙⴻⵏ ⵏⵉⵖ ⴰⴷ ⵜⵏⴻⵄⵍⴻⴷ ⵍⴳⴻⵏⵙ ⵏⵏⵉ, ⵎⵉⵏⵣⵉ ⵍⴳⴻⵏⵙ ⴰⵇⴰ ⵉⵜⵜⵡⴰⴱⴰⵔⴻⴽ.” ");
INSERT INTO rift_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","ⵅⴻⵏⵏⵉ ⵉⴽⴽⴰⵔ ⴱⴰⵍⵄⴰⵎ ⴷⵉ ⵚⵚⴱⴻⵃ ⵓⵛⴰ ⵉⵏⵏⴰ ⵉ ⵍⵃⵓⴽⴽⴰⵎ ⵏ ⴱⴰⵍⴰⴽ: “ⴷⴻⵡⵍⴻⵎ-ⴷⴷ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵡⴻⵎ, ⵎⵉⵏⵣⵉ ⵙⵉⴷⵉ ⵡⴰⵔ ⴷ ⴰⵢⵉ ⵉⵙⵎⵉⵃ ⵃⵉⵎⴰ ⴰⴷ ⵔⴰⵃⴻⵖ ⴰⴽⵉⴷⵡⴻⵎ.” ");
INSERT INTO rift_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","ⵅⴻⵏⵏⵉ ⴽⴽⴰⵔⴻⵏ ⵍⵃⵓⴽⴽⴰⵎ ⵏ ⵎⵓ’ⴰⴱ ⵓⵛⴰ ⴷⴻⵡⵍⴻⵏ-ⴷⴷ ⵖⴰⵔ ⴱⴰⵍⴰⴽ ⵓⵛⴰ ⵏⵏⴰⵏ: “ⴱⴰⵍⵄⴰⵎ ⵢⵓⴳⵉ ⴰⴷ ⴷⴷ-ⵢⴰⵙ ⴰⴽⵉⴷⵏⴻⵖ.” ");
INSERT INTO rift_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","ⵉⵙⵙⴻⴽⴽ ⴱⴰⵍⴰⴽ ⵄⴰⵡⴻⴷ ⵍⵃⵓⴽⴽⴰⵎ, ⵄⴰⴷ ⴽⵜⴰⵔ ⵓ ⵄⴰⴷ ⵡⴻⵏⵏⵉ ⵉⵛⴻⵏⵏⵄⴻⵏ ⴽⵜⴰⵔ ⵅ ⵢⵉⵏⴰ ⵉⵎⴻⵣⵡⵓⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","ⵓⵙⵉⵏ-ⴷⴷ ⵖⴰⵔ ⴱⴰⵍⵄⴰⵎ, ⵏⵏⴰⵏ: “ⴰⵎⵎⵓ ⵉ ⵉⵇⵇⴰⵔ ⴱⴰⵍⴰⴽ, ⵎⵎⵉⵙ ⵏ ⵚⵉⴼⴼⵓⵔ: ‘ⵜⵜⵣⴰⵡⴳⴻⵖ ⵛⴻⴽ, ⵡⴰⵔ ⵜⵜⴻⵊⵊⵉ ⵉⵅⴻⴼ ⵏⵏⴻⵛ ⵎⴰⵃⴻⵏⴷ ⵡⴰⵔ ⵖⴰⵔⵉ ⴷⴷ-ⵜⵜⴰⵙⴻⴷ, ");
INSERT INTO rift_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","ⵎⵉⵏⵣⵉ ⴰⴷ ⵛⴻⴽ ⴽⴰⵔⵔⵎⴻⵖ ⵙ ⵡⴰⵟⵟⴰⵙ ⵓⵛⴰ ⴰⴷ ⴳⴳⴻⵖ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴷ ⴰⵢⵉ ⵖⴰ ⵜⵉⵏⵉⴷ. ⵜⵜⵣⴰⵡⴳⴻⵖ ⵛⴻⴽ, ⴰⵙ-ⴷⴷ ⵓⵛⴰ ⵏⵄⴻⵍ ⵍⴳⴻⵏⵙ-ⴰ ⴷⵉ ⵟⵟⵡⴻⵄ ⵉⵏⵓ!” ");
INSERT INTO rift_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","ⵢⴰⵔⵔⴰ-ⴷⴷ ⴱⴰⵍⵄⴰⵎ ⵓⵛⴰ ⵉⵏⵏⴰ ⵉ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏ ⴱⴰⵍⴰⴽ: “ⵡⴰⵅⵅⴰ ⴱⴰⵍⴰⴽ ⴰⴷ ⴰⵢⵉ ⵉⵡⵛ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⴻⵙ ⵜⴻⵛⵛⵓⵔ ⵙ ⵏⵏⵓⵇⴰⵔⵜ ⴷ ⵡⵓⵔⴻⵖ, ⵄⴰⴷ ⵡⴰⵔ ⵣⵎⵉⵔⴻⵖ ⴰⴷ ⴼⴼⵖⴻⵖ ⵅ ⵍⵓⵎⵓⵔ ⵏ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵉⵏⵓ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴳⴳⴻⵖ ⵛⴰ ⵏ ⵍⵃⴰⵊⵊⴻⵜ ⴷ ⵜⴰⵎⴻⵥⵢⴰⵏⵜ ⵏⵉⵖ ⵛⴰ ⵏ ⵍⵃⴰⵊⵊⴻⵜ ⴷ ⵜⴰⵎⴻⵇⵇⵔⴰⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","ⵅⴻⵏⵏⵉ ⵍⴻⵅⵅⵓ, ⵜⵜⵣⴰⵡⴰⴳⴻⵖ ⴽⴻⵏⵏⵉⵡ, ⵇⵇⵉⵎⴻⵎ ⴷⴰⵏⵉⵜⴰ ⴵⵉⵍⴻⵜ-ⴰ ⵃⵉⵎⴰ ⴰⴷ ⵙⵙⵏⴻⵖ ⵎⵉⵏ ⴷ ⴰⵢⵉ ⵖⴰ ⵢⵉⵏⵉ ⵙⵉⴷⵉ ⵄⴰⴷ ⴽⵜⴰⵔ.” ");
INSERT INTO rift_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","ⴷⵉ ⴵⵉⵍⴻⵜ ⵢⵓⵙⴰ-ⴷⴷ ⴰⵔⴻⴱⴱⵉ ⵖⴰⵔ ⴱⴰⵍⵄⴰⵎ, ⵉⵏⵏⴰ ⴰⵙ: “ⵎⴰⵍⴰ ⴷⴻⵡⵍⴻⵏ-ⴷⴷ ⵢⴻⵔⵢⴰⵣⴻⵏ ⵏⵏⵉ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴰⵛ ⴷⴷ-ⵍⴰⵖⴰⵏ, ⴽⴽⴰⵔ ⵅⴻⵏⵏⵉ ⵓⵛⴰ ⵔⵓⵃ ⴰⴽⵉⴷⵙⴻⵏ. ⵎⴰⵛⴰ ⵡⴰⵔ ⵜⵜⴻⴳⴳ ⵎⵖⵉⵔ ⵎⵉⵏ ⴷ ⴰⵛ ⵖⴰ ⵉⵏⵉⵖ.” ");
INSERT INTO rift_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","ⵉⴽⴽⴰⵔ ⴱⴰⵍⵄⴰⵎ ⵖⴰⵔ ⵚⵚⴱⴻⵃ ⵓⵛⴰ ⵉⵃⴻⵣⵣⴻⵎ ⵉ ⵜⴻⵖⵢⵓⵍⵜ ⵏⵏⴻⵙ ⵓⵛⴰ ⵢⵓⵢⵓⵔ ⴰⴽ-ⴷ ⵍⵃⵓⴽⴽⴰⵎ ⵏ ⵎⵓ’ⴰⴱ. ");
INSERT INTO rift_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","ⵅⴻⵏⵏⵉ ⵢⴰⵔⵖⴰ ⵡⴻⵖⴹⴰⴱ ⵏ ⴰⵔⴻⴱⴱⵉ, ⵎⵉⵏⵣⵉ ⵏⴻⵜⵜⴰ ⵉⵔⵓⵃ ⵓⵛⴰ ⵍⵎⴰⵍⴰⴽ ⵏ ⵙⵉⴷⵉ ⵉⴱⴻⴷⴷ ⴷⴻⴳ ⵡⴻⴱⵔⵉⴷ ⴰⵎ ⵛⵛⵉⵟⴰⵏ ⴹⵉⴷⴷ ⵏⵏⴻⵙ. ⵏⴻⵜⵜⴰ ⵉⵏⵢⴰ ⵅ ⵜⴻⵖⵢⵓⵍⵜ ⵏⵏⴻⵙ ⵓⵛⴰ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴰⴽⵉⴷⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","ⵓⵛⴰ ⵜⴰⵖⵢⵓⵍⵜ ⵜⴻⵥⵔⴰ ⵍⵎⴰⵍⴰⴽ ⵏ ⵙⵉⴷⵉ ⵉⴱⴻⴷⴷ ⴷⴻⴳ ⵡⴻⴱⵔⵉⴷ ⵙ ⵙⵙⵉⴼ ⵏⵏⴻⵙ ⵉⵜⵜⵡⴰⵊⴻⴱⴷⴻⵏ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏⵏⴻⵙ. ⵙ ⵓⵢⴻⵏⵏⵉ ⵜⴻⵍⵃⴻⵎ ⵜⴻⵖⵢⵓⵍⵜ ⵣⴻⴳ ⵡⴻⴱⵔⵉⴷ ⵓⵛⴰ ⵜⵓⵢⵓⵔ ⴷⴻⴳ ⵉⵢⵢⴰⵔ. ⵅⴻⵏⵏⵉ ⵉⵡⵜⴰ ⴱⴰⵍⵄⴰⵎ ⵜⴰⵖⵢⵓⵍⵜ ⵃⵉⵎⴰ ⴰⴷ ⵜⵜ ⵢⴰⵔⵔ ⵖⴰⵔ ⵡⴻⴱⵔⵉⴷ. ");
INSERT INTO rift_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","ⵎⴰⵛⴰ ⵍⵎⴰⵍⴰⴽ ⵏ ⵙⵉⴷⵉ ⵉⴱⴻⴷⴷ ⴷⴻⴳ ⵉⵛⵜ ⵏ ⵜⴻⴱⵔⵉⴷⵜ ⵜⴻⵃⵚⴰⵔ ⵊⴰⵔ ⵉⵎⴰⵔⵊⴰⵄⴻⵏ ⵏ ⵓⴹⵉⵍ ⵙ ⵢⵉⵊⵊ ⵏ ⵡⴻⵖⴱⴰⵔ ⵖⴰⵔ ⵟⵟⴰⵔⴼ ⴷ ⵉⵊⵊ ⵏ ⵡⴻⵖⴱⴰⵔ ⵖⴰⵔ ⵟⵟⴰⵔⴼ ⵏⵏⴻⵖⵏⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","ⵓⵎⵉ ⵜⴻⵥⵔⴰ ⵜⴻⵖⵢⵓⵍⵜ ⵍⵎⴰⵍⴰⴽ ⵏ ⵙⵉⴷⵉ, ⵜⴻⵍⵚⴻⵇ ⵖⴰⵔ ⵡⴻⵖⴱⴰⵔ ⵓⵛⴰ ⵉⵜⵜⵡⴰⵃⵚⴰⵔ ⵓⴹⴰⵔ ⵏ ⴱⴰⵍⵄⴰⵎ ⴰⴽ-ⴷ ⵡⴻⵖⴱⴰⵔ ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵉⵇⵇⵉⵎ ⵉⵛⵛⴰⵜ ⵉ-ⵜⵜ. ");
INSERT INTO rift_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","ⵓⵛⴰ ⵉⵔⵓⵃ ⵍⵎⴰⵍⴰⴽ ⵏ ⵙⵉⴷⵉ ⵖⴰⵔ ⵣⵣⴰⵜ ⵓⵛⴰ ⵉⴱⴻⴷⴷ ⴷⴻⴳ ⵉⵊⵊ ⵏ ⵡⴻⵎⵛⴰⵏ ⵉⵃⵚⴰⵔ ⴰⵟⵟⴰⵙ ⴰⵍ ⵎⴰⵏⵉ ⵡⴰⵔ ⵉⵜⵜⵡⵉⴼ ⵜⵜⴰⵙⵉⵄ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⵃⴻⵢⵢⴻⴷ ⵖⴰⵔ ⵢⴻⴼⵓⵙ ⵓⵍⴰ ⵖⴰⵔ ⵓⵣⴻⵍⵎⴰⴹ. ");
INSERT INTO rift_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","ⵓⵎⵉ ⵜⴻⵥⵔⴰ ⵜⴻⵖⵢⵓⵍⵜ ⵍⵎⴰⵍⴰⴽ ⵏ ⵙⵉⴷⵉ, ⵜⴱⴰⵔⵛ ⵙⴰⴷⵓ ⴱⴰⵍⵄⴰⵎ ⵓⵛⴰ ⴱⴰⵍⵄⴰⵎ ⵉⵅⴻⵢⵢⴻⵇ ⴰⵟⵟⴰⵙ ⵓⵛⴰ ⵉⴼⴰⵔⵛ ⵜⴰⵖⵢⵓⵍⵜ ⵙ ⵢⵉⵊⵊ ⵏ ⵓⴽⴻⵛⵛⵓⴹ. ");
INSERT INTO rift_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","ⵅⴻⵏⵏⵉ ⵢⴰⵔⵣⴻⵎ ⵙⵉⴷⵉ ⴰⵇⴻⵎⵎⵓⵎ ⵏ ⵜⴻⵖⵢⵓⵍⵜ ⵓⵛⴰ ⵜⴻⵏⵏⴰ ⵉ ⴱⴰⵍⵄⴰⵎ: “ⵎⵉⵏ ⴷ ⴰⵛ ⴳⴳⵉⵖ ⵓⵎⵉ ⴷ ⴰⵢⵉ ⵜⴼⴰⵔⵛⴻⴷ ⵍⴻⵅⵅⵓ ⵄⴰⴷ ⵜⵍⴰⵜⴰ ⵏ ⵉⵎⵓⵔⴻⵏ?” ");
INSERT INTO rift_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⴱⴰⵍⵄⴰⵎ ⵉ ⵜⴻⵖⵢⵓⵍⵜ: “ⵎⵉⵏⵣⵉ ⵛⴻⵎ ⵜⴱⵓⵚⴰⵔⴻⴷ ⵅⴰⴼⵉ. ⵎⵍⵉ ⵖⴰⵔⵉ ⵙⵙⵉⴼ ⴷⴻⴳ ⵓⴼⵓⵙ ⵉⵏⵓ, ⴰⴷ ⵜⵉⵍⵉ ⵅⴻⵏⵏⵉ ⵏⵖⵉⵖ ⵛⴻⵎ!” ");
INSERT INTO rift_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","ⵜⴻⵏⵏⴰ ⵜⴻⵖⵢⵓⵍⵜ ⵉ ⴱⴰⵍⵄⴰⵎ: “ⵎⴰ ⵡⴰⵔ ⴵⵉⵖ ⵏⴻⵛⵛ ⵜⴰⵖⵢⵓⵍⵜ ⵏⵏⴻⵛ ⵉ ⵅⴻⴼ ⵜⴻⵏⵢⵉⴷ ⵣⴻⴳ ⵡⴰⵎⵉ ⵏⴻⵛⵛ ⵖⴰⵔⴻⴽ ⴵⵉⵖ ⴰⵍ ⴰⵙⵙ-ⴰ? ⵎⴰ ⴰⵇⴰ ⵏⴻⵛⵛ ⵏⵏⵓⵎⴻⵖ ⵜⵜⴻⴳⴳⴻⵖ ⴰⴽ ⴽⵉⴽ ⴰⵎⵎⵓ?” ⵓⵛⴰ ⵢⴰⵔⵔⴰ-ⴷⴷ ⵅⴰⵙ: “ⵍⵍⴰ!” ");
INSERT INTO rift_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","ⵅⴻⵏⵏⵉ ⵢⴰⵔⵣⴻⵎ ⵙⵉⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⴱⴰⵍⵄⴰⵎ ⴰⵍⴰⵎⵉ ⵉⵥⵔⴰ ⵍⵎⴰⵍⴰⴽ ⵏ ⵙⵉⴷⵉ ⵉⴱⴻⴷⴷ ⴷⴻⴳ ⵡⴻⴱⵔⵉⴷ ⵙ ⵙⵙⵉⴼ ⵏⵏⴻⵙ ⵉⵜⵜⵡⴰⵊⴻⴱⴷⴻⵏ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏⵏⴻⵙ. ⵅⴻⵏⵏⵉ ⵢⵓⴹⴰⵔ ⴱⴰⵍⵄⴰⵎ, ⵉⴱⴻⵏⴷⴻⵇ ⵙ ⵓⵖⴻⵎⴱⵓⴱ ⵏⵏⴻⵙ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","ⵉⵏⵏⴰ ⴰⵙ ⵍⵎⴰⵍⴰⴽ ⵏ ⵙⵉⴷⵉ: “ⵎⴰⵢⴻⵎⵎⵉ ⵜⴻⵡⵜⵉⴷ ⵜⴰⵖⵢⵓⵍⵜ ⵏⵏⴻⵛ ⵜⵍⴰⵜⴰ ⵏ ⵉⵎⵓⵔⴻⵏ? ⵅⵣⴰⵔ, ⴰⵇⴰ ⵏⴻⵛⵛ ⴼⴼⵖⴻⵖ-ⴷⴷ ⴰⵎ ⵉⵊⵊ ⵏ ⵡⴻⵖⵔⵉⵎ, ⵎⵉⵏⵣⵉ ⴰⴱⵔⵉⴷ-ⴰ ⵉⵜⵜⴹⴰⵔⵔⴰ ⴰⵢⵉ ⵏⴻⵛⵛ ⵏⵉⵛⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","ⵜⴻⵥⵔⴰ ⴰⵢⵉ ⵜⴻⵖⵢⵓⵍⵜ ⵓⵛⴰ ⵜⴻⵍⵃⴻⵎ ⵅⴻⵏⵏⵉ ⵣⵉ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵉⵏⵓ ⵜⵍⴰⵜⴰ ⵏ ⵉⵎⵓⵔⴻⵏ. ⵎⴰⵍⴰ ⵡⴰⵔ ⵜⴻⵍⵃⵉⵎ ⵣⵉ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵉⵏⵓ, ⵅⴻⵏⵏⵉ ⵏⴻⵛⵛ ⴰⴷ ⵢⵉⵍⵉ ⴰⵇⴰ ⵍⴻⵅⵅⵓ ⵏⵖⵉⵖ ⵛⴻⴽ ⵓ ⵏⴻⵜⵜⴰⵜ ⴰⴷ ⵜⵜ ⵊⵊⴻⵖ ⴰⴷ ⵜⴻⴷⴷⴰⵔ.” ");
INSERT INTO rift_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⴱⴰⵍⵄⴰⵎ ⵉ ⵍⵎⴰⵍⴰⴽ ⵏ ⵙⵉⴷⵉ: “ⴰⵇⴰ ⵏⴻⵛⵛ ⵅⴹⵉⵖ, ⵎⵉⵏⵣⵉ ⵡⴰⵔ ⵙⵙⵉⵏⴻⵖ ⴱⴻⵍⵍⵉ ⵛⴻⴽ ⵜⴱⴻⴷⴷⴻⴷ ⵣⵣⴰⵜⵉ ⴷⴻⴳ ⵡⴻⴱⵔⵉⴷ. ⵄⴰⴷ ⵍⴻⵅⵅⵓ, ⵎⴰⵍⴰ ⴰⵢⴰ ⴷ ⵍⵄⵉⴱ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵛ, ⵏⴻⵛⵛ ⴰⴷ ⴷⴷ-ⴷⴻⵡⵍⴻⵖ.” ");
INSERT INTO rift_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","ⵉⵏⵏⴰ ⵍⵎⴰⵍⴰⴽ ⵏ ⵙⵉⴷⵉ ⵉ ⴱⴰⵍⵄⴰⵎ: “ⵔⵓⵃ ⴰⴽ-ⴷ ⵉⵡⴷⴰⵏ-ⴰ, ⵎⴰⵛⴰ ⵙⵉⵡⴻⵍ ⵡⴰⵀⴰ ⵎⵉⵏ ⴷ ⴰⵛ ⵖⴰ ⵉⵏⵉⵖ ⵏⴻⵛⵛ.” ⴰⵎⵎⵓ ⵉⵔⵓⵃ ⴱⴰⵍⵄⴰⵎ ⴰⴽ-ⴷ ⵍⵃⵓⴽⴽⴰⵎ ⵏ ⴱⴰⵍⴰⴽ. ");
INSERT INTO rift_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","ⵓⵎⵉ ⴱⴰⵍⴰⴽ ⵉⵙⵍⴰ, ⴰⵇⴰ ⴱⴰⵍⵄⴰⵎ ⵢⵓⵙⴰ-ⴷⴷ, ⵉⵔⵓⵃ ⵃⵉⵎⴰ ⴰⴷ ⵜ ⵉⵎⵎⴻⵍⵇⴰ ⵖⴰⵔ ⵜⴰⵏⴷⵉⵏⵜ ⵏ ⵎⵓ’ⴰⴱ ⵉ ⵉⴵⴰⵏ ⵖⴰⵔ ⵊⵊⵉⵀⴻⵜ ⵏ ⵡⴻⵢⵎⵉⵔ ⵏ ⴰⵔⵏⵓⵏ, ⵖⴰⵔ ⵟⵟⴰⵔⴼ ⵏ ⵊⵊⵉⵀⴻⵜ ⵏ ⵡⴻⵢⵎⵉⵔ. ");
INSERT INTO rift_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","ⵓⵛⴰ ⴱⴰⵍⴰⴽ ⵉⵏⵏⴰ ⵉ ⴱⴰⵍⵄⴰⵎ: “ⵎⴰ ⵡⴰⵔ ⵙⵙⴻⴽⴽⴻⵖ ⵏⴻⵛⵛ ⵉⵡⴷⴰⵏ ⴰⴷ ⴰⵛ ⴷⴷ-ⵍⴰⵖⴰⵏ? ⵎⴰⵢⴻⵎⵎⵉ ⵡⴰⵔ ⵖⴰⵔⵉ ⴷⴷ-ⵜⵓⵙⵉⴷ? ⵎⴰ ⵡⴰⵔ ⵣⴻⵎⵎⴰⵔⴻⵖ ⵏⴻⵛⵛ ⴰⴷ ⵛⴻⴽ ⴽⴰⵔⵎⴻⵖ?” ");
INSERT INTO rift_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","ⵅⴻⵏⵏⵉ ⵢⴰⵔⵔⴰ-ⴷⴷ ⴱⴰⵍⵄⴰⵎ ⵅ ⴱⴰⵍⴰⴽ: “ⵅⵣⴰⵔ, ⵏⴻⵛⵛ ⵓⵙⵉⵖ-ⴷⴷ ⵖⴰⵔⴻⴽ, ⵎⴰⵛⴰ ⵎⴰ ⵣⴻⵎⵎⴰⵔⴻⵖ ⵏⴻⵛⵛ ⵍⴻⵅⵅⵓ ⴰⴷ ⵙⵙⵉⵡⵍⴻⵖ ⵅ ⵛⴰ? ⴰⵡⴰⵍ ⵏⵏⵉ ⵉ ⵖⴰ ⵢⴻⴳⴳ ⵙⵉⴷⵉ ⴷⴻⴳ ⵓⵇⴻⵎⵎⵓⵎ ⵉⵏⵓ, ⴰⴷ ⵜ ⵉⵏⵉⵖ.” ");
INSERT INTO rift_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","ⵓⵛⴰ ⵉⵔⵓⵃ ⴱⴰⵍⵄⴰⵎ ⴰⴽ-ⴷ ⴱⴰⵍⴰⴽ ⵓⵛⴰ ⵓⵙⵉⵏ-ⴷⴷ ⵖⴰⵔ ⵇⴰⵔⵢⴰⵜ-ⵃⴰⵚⵓⵜ. ");
INSERT INTO rift_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","ⵅⴻⵏⵏⵉ ⵉⵖⴰⵔⵚ ⴱⴰⵍⴰⴽ ⵉ ⵉⴼⵓⵏⴰⵙⴻⵏ ⴷ ⵡⵓⴵⵉ, ⵉⵙⵙⴻⴽⴽ ⵣⵣⴰⵢⵙⴻⵏ ⵖⴰⵔ ⴱⴰⵍⵄⴰⵎ ⵓ ⵖⴰⵔ ⵍⵃⵓⴽⴽⴰⵎ ⵏⵏⵉ ⵜⵓⵖⴰ ⴰⴽⵉⴷⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","ⵖⴰⵔ ⵚⵚⴱⴻⵃ ⵉⵎⵙⴰⵔ ⴱⴻⵍⵍⵉ ⴱⴰⵍⴰⴽ ⵢⵉⵡⵉ ⴰⴽⵉⵙ ⴱⴰⵍⵄⴰⵎ ⵓⵛⴰ ⵉⵙⵙⵉⵍⵉ ⵉ-ⵜ ⵅ ⵍⵓⵄⵍⴰⵜ ⵏ ⴱⴰⵄⵍ ⵎⴰⵏⵉ ⵜⵓⵖⴰ ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵉⵥⴰⵔ ⵍⴳⴻⵏⵙ ⴰⵍ ⵟⵟⴰⵔⴼ ⵉⴳⴳⵯⴻⵊⴻⵏ ⵇⴰⵄ. ");
INSERT INTO rift_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⴱⴰⵍⵄⴰⵎ ⵉ ⴱⴰⵍⴰⴽ: “ⴱⵏⴰ ⵙⴻⴱⵄⴰ ⵏ ⵉⵄⴰⵍⵟⴰⵔⴻⵏ ⴷⴰⵏⵉⵜⴰ ⵉ ⵏⴻⵛⵛ ⵓⵛⴰ ⵙⴻⵡⵊⴻⴷ ⴰⵢⵉ ⵙⴻⴱⵄⴰ ⵏ ⵉⴼⵓⵏⴰⵙⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⴻⵏ ⴷ ⵙⴻⴱⵄⴰ ⵏ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","ⴱⴰⵍⴰⴽ ⵉⴳⴳⴰ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵙ ⵉⵏⵏⴰ ⴱⴰⵍⵄⴰⵎ ⵓⵛⴰ ⴱⴰⵍⴰⴽ ⴷ ⴱⴰⵍⵄⴰⵎ ⵇⴻⴷⴷⵎⴻⵏ ⵉⵊⵊ ⵏ ⵓⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ ⴷ ⵉⵊⵊ ⵏ ⵉⵛⴰⵔⵔⵉ ⵅ ⴽⵓⵍ ⵉⵊⵊ ⵏ ⵓⵄⴰⵍⵟⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","ⵅⴻⵏⵏⵉ ⴱⴰⵍⵄⴰⵎ ⵉⵏⵏⴰ ⵉ ⴱⴰⵍⴰⴽ: “ⴱⴻⴷⴷ ⴷⵉⵏ ⵣⵣⴰⵜ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵏⵏⴻⵛ, ⵅⴻⵏⵏⵉ ⵏⴻⵛⵛ ⴰⴷ ⵔⴰⵃⴻⵖ. ⴰⴷ ⵜⴰⵖ ⴰⴷ ⴽⵉⴷⵉ ⵉⵎⵙⴰⴳⴰⵔ ⵙⵉⴷⵉ ⵓⵛⴰ ⵎⴰⵎⵎⴻⵛ ⵎⴰ ⵉⴳⴳⴰ ⵡⴰⵡⴰⵍ ⵏⵏⵉ ⴷ ⴰⵢⵉ ⵖⴰ ⵉⵙⵙⵛⴻⵏ, ⵏⴻⵛⵛ ⴰⴷ ⴰⵛ ⵜ-ⵉ-ⴷⴷ-ⵙⵙⴰⵔⴳⴱⴻⵖ.” ⵅⴻⵏⵏⵉ ⵉⵔⵓⵃ ⴱⴰⵍⵄⴰⵎ ⵖⴰⵔ ⵜⵇⵉⵛⵛⴰⵜ ⴷ ⵜⴰⵇⴻⵛⵛⴰⵔⵜ ⵏ ⵡⴻⴷⵔⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","ⵓ ⵉⵎⵎⴻⵍⵇⴰ ⴰⵔⴻⴱⴱⵉ ⴰⴽ-ⴷ ⴱⴰⵍⵄⴰⵎ ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵉⵏⵏⴰ ⴰⵙ: “ⴰⵇⴰ ⵙⵙⵡⴻⵊⴷⴻⵖ ⵙⴻⴱⵄⴰ ⵏ ⵉⵄⴰⵍⵟⴰⵔⴻⵏ ⵓⵛⴰ ⵇⴻⴷⴷⵎⴻⵖ ⵉⵊⵊ ⵏ ⵓⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ ⴷ ⵉⵊⵊ ⵏ ⵉⵛⴰⵔⵔⵉ ⵅ ⴽⵓⵍ ⵉⵊⵊ ⵏ ⵓⵄⴰⵍⵟⴰⵔ.” ");
INSERT INTO rift_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","ⵅⴻⵏⵏⵉ ⵉⴳⴳⴰ ⵙⵉⴷⵉ ⵉⵊⵊ ⵏ ⵡⴰⵡⴰⵍ ⴷⴻⴳ ⵓⵇⴻⵎⵎⵓⵎ ⵏ ⴱⴰⵍⵄⴰⵎ ⵓⵛⴰ ⵉⵏⵏⴰ: “ⴷⵡⴻⵍ ⵖⴰⵔ ⴱⴰⵍⴰⴽ ⵓⵛⴰ ⵙⵉⵡⴻⵍ ⴰⴽⵉⴷⴻⵙ ⴰⵎⵎⵓ.” ");
INSERT INTO rift_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","ⵓⵛⴰ ⵓⵎⵉ ⵖⴰⵔⴻⵙ-ⴷⴷ ⵉⴷⵡⴻⵍ, ⵅⵣⴰⵔ, ⵉⴱⴻⴷⴷ ⵣⵣⴰⵜ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵏⵏⴻⵙ, ⵊⵎⵉⵄ ⴰⴽ-ⴷ ⵎⴰⵔⵔⴰ ⵍⵃⵓⴽⴽⴰⵎ ⵏ ⵎⵓ’ⴰⴱ. ");
INSERT INTO rift_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","ⵅⴻⵏⵏⵉ ⵉⴱⴷⴰ ⵉⵇⵇⴰⵔ ⴰⵡⴰⵍ ⵏⵏⴻⵙ ⵉⵡⴻⵣⵏⴻⵏ, ⵉⵏⵏⴰ: “ⵣⵉ ⴰⵔⴰⵎ ⵉⵏⴷⴻⵀ ⴰⵢⵉ-ⴷⴷ ⴱⴰⵍⴰⴽ, ⴰⵊⴻⴵⵉⴷ ⵏ ⵎⵓ’ⴰⴱ, ⵣⴻⴳ ⵉⴷⵓⵔⴰⵔ ⵏ ⵛⵛⴰⵔⵇ, ⵉⵏⵏⴰ: ‘ⴰⵙ-ⴷⴷ, ⵏⵄⴻⵍ ⴰⵢⵉ ⵢⴰⵄⵇⵓⴱ, ⴰⵙ-ⴷⴷ, ⵣⴰⵡⴰⵔ ⵉⵙⵔⴰⵉⵍ!’ ");
INSERT INTO rift_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","ⵎⴰⵛⴰ ⵎⴰⵎⵎⴻⵛ ⵖⴰ ⵏⴻⵄⵍⴻⵖ, ⵡⴻⵏⵏⵉ ⵡⴰⵔ ⵉⵜⵜⵡⴰⵏⴻⵄⵍⴻⵏ ⵣⵉ ⴰⵔⴻⴱⴱⵉ, ⵓ ⵎⴰⵎⵎⴻⵛ ⵖⴰ ⵣⴰⵡⴰⵔⴻⵖ ⵡⴻⵏⵏⵉ ⵡⴰⵔ ⵉⵣⴰⵡⴰⵔ ⵙⵉⴷⵉ? ");
INSERT INTO rift_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","ⵎⵉⵏⵣⵉ ⵣⵉ ⵜⵇⵉⵛⵛⴰⵜ ⵏ ⵜⵚⵓⴹⴰⵔ ⵜⵡⴰⵍⵉⵖ ⵜ, ⵓⵛⴰ ⵣⵉ ⵜⵉⵡⵔⵉⵔⵉⵏ ⵅⴻⵣⵣⴰⵔⴻⵖ ⴷⴰⵢⴻⵙ. ⴰⵇⴰ ⵡⴰ ⴷ ⵉⵊⵊ ⵏ ⵍⴳⴻⵏⵙ ⵉⵣⴻⴷⴷⵖⴻⵏ ⵡⴻⵃⵃⴷⴻⵙ ⵓ ⵡⴰⵔ ⵉⵃⴻⵙⵙⴻⴱ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵊⴰⵔ ⵍⴻⴳⵏⵓⵙ. ");
INSERT INTO rift_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","ⵡⵉ ⵖⴰ ⵉⵃⴻⵙⴱⴻⵏ ⴰⵛⴰⵍ ⵏ ⵢⴰⵄⵇⵓⴱ ⵏⵉⵖ ⵡⵉ ⵉ ⵖⴰ ⵉⵃⴻⵙⴱⴻⵏ ⵍⵇⴻⴷⴷ ⵏ ⵉⵊⵊ ⵏ ⴰⵔⴱⴻⵄ ⵣⵉ ⵉⵙⵔⴰⵉⵍ? ⴻⵊⵊ ⴰⴷ ⵉⵎⵎⴻⵜ ⵍⴻⵄⵎⴰⵔ ⵉⵏⵓ ⵍⵎⴻⵡⵜ ⵏ ⵉⵎⵙⴻⴳⴳⴰⴷⴻⵏ ⵓ ⴻⵊⵊ ⵄⴰⵡⴻⴷ ⴰⴷ ⵢⵉⵍⵉ ⵓⵏⴻⴳⴳⴰⵔ ⵏ ⵜⵓⴷⴰⵔⵜ ⵉⵏⵓ ⴰⴷ ⵉⵎⵇⵓⴷⴷⴰ ⴰⴽⵉⴷⴻⵙ!” ");
INSERT INTO rift_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⴱⴰⵍⴰⴽ ⵉ ⴱⴰⵍⵄⴰⵎ: “ⵎⵉⵏ ⴷ ⴰⵢⵉ ⵜⴻⴳⴳⵉⴷ? ⵏⴻⵛⵛ ⵉⵡⵢⴻⵖ ⵛⴻⴽ ⵃⵉⵎⴰ ⴰⴷ ⵜⵏⴻⵄⵍⴻⴷ ⵍⵄⴻⴷⵢⴰⵏ ⵉⵏⵓ, ⵎⴰⵛⴰ ⵅⵣⴰⵔ, ⴰⵇⴰ ⵏⵉⵛⴰⵏ ⵜⴱⴰⵔⴽⴻⴷ ⵉ-ⵜⴻⵏ!” ");
INSERT INTO rift_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","ⵏⴻⵜⵜⴰ ⵢⴰⵔⵔⴰ-ⴷⴷ, ⵉⵏⵏⴰ: “ⵎⴰ ⵡⴰⵔ ⵉⵜⵜⵅⴻⵚⵚⵉ ⴰⴷ ⵃⴹⵉⵖ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵙⵙⵉⵡⵍⴻⵖ ⵎⵉⵏ ⵉⴳⴳⴰ ⵙⵉⴷⵉ ⴷⴻⴳ ⵓⵇⴻⵎⵎⵓⵎ ⵉⵏⵓ?” ");
INSERT INTO rift_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⴱⴰⵍⴰⴽ: “ⵜⵜⵣⴰⵡⴳⴻⵖ ⵛⴻⴽ ⴰⴷ ⴷⴷ-ⵜⴰⵙⴻⴷ ⴰⴽⵉⴷⵉ ⵖⴰⵔ ⵉⵊⵊ ⵏ ⵡⴻⵎⵛⴰⵏ ⵏⵏⴻⵖⵏⵉ ⵣⵉ ⵎⴰⵏⵉⵙ ⵖⴰ ⵜⵥⴰⵔⴻⴷ ⵍⴳⴻⵏⵙ ⵄⴰⵡⴻⴷ. ⴰⴷ ⵜⵥⴰⵔⴻⴷ ⵟⵟⵔⵓⴼⴰ ⵏⵏⴻⵙ ⵡⴰⵀⴰ, ⵡⴰⵔ ⵜ ⵜⵥⴰⵔⵔⴻⴷ ⵎⴰⵔⵔⴰ. ⵙⵙⴻⵏⵏⵉ ⴰⴷ ⵜ ⵜⵏⴻⵄⵍⴻⴷ ⴷⵉ ⵟⵟⵡⴻⵄ ⵉⵏⵓ!” ");
INSERT INTO rift_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","ⵓⵛⴰ ⵢⵉⵡⵢⵉ ⵉ-ⵜ ⵖⴰⵔ ⵍⴻⵡⴹⴰ ⵏ ⵚⵓⴼⵉⵎ ⵅ ⵜⵇⵉⵛⵛⴰⵜ ⵏ ⴼⵉⵙⵊⴰ ⵓⵛⴰ ⵉⴱⵏⴰ ⴷⵉⵏ ⵙⴻⴱⵄⴰ ⵏ ⵉⵄⴰⵍⵟⴰⵔⴻⵏ ⵓⵛⴰ ⵅ ⴽⵓⵍ ⵉⵊⵊ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ⵉⵇⴻⴷⴷⴻⵎ ⵉⵊⵊ ⵏ ⵓⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ ⴷ ⵉⵊⵊ ⵏ ⵉⵛⴰⵔⵔⵉ. ");
INSERT INTO rift_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","ⵏⴻⵜⵜⴰ ⵉⵏⵏⴰ ⵉ ⴱⴰⵍⴰⴽ: “ⵎⴰⵍⴰ ⵛⴻⴽ ⴰⴷ ⵜⴱⴻⴷⴷⴻⴷ ⴷⴰ ⵣⵣⴰⵜ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏⵏⴻⵛ ⵏ ⵡⴻⵛⵎⴰⴹ, ⵅⴻⵏⵏⵉ ⵏⴻⵛⵛ ⴰⴷ ⴽⵉⵙ ⵎⵎⵙⴰⴳⴰⵔⴻⵖ ⴷⵉⵏ.” ");
INSERT INTO rift_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","ⵓⵛⴰ ⵉⵎⵙⴰⴳⴰⵔ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⴱⴰⵍⵄⴰⵎ ⵓⵛⴰ ⵉⴳⴳⴰ ⵉⵊⵊ ⵏ ⵡⴰⵡⴰⵍ ⴷⴻⴳ ⵓⵇⴻⵎⵎⵓⵎ ⵏⵏⴻⵙ, ⵉⵏⵏⴰ: “ⴷⵡⴻⵍ ⵖⴰⵔ ⴱⴰⵍⴰⴽ ⵓⵛⴰ ⵉⵏⵉ ⴰⵙ ⴰⵎⵎⵓ.” ");
INSERT INTO rift_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵢⵓⵙⴰ-ⴷⴷ ⵖⴰⵔⴻⵙ, ⵓ ⵅⵣⴰⵔ, ⵏⴻⵜⵜⴰ ⵜⵓⵖⴰ ⵉⴱⴻⴷⴷ ⵣⵣⴰⵜ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵏⵏⴻⵙ ⵓⵛⴰ ⵍⵃⵓⴽⴽⴰⵎ ⵏ ⵎⵓ’ⴰⴱ ⴱⴻⴷⴷⴻⵏ ⵣⵣⴰⵜⴻⵙ. ⵉⵏⵏⴰ ⴰⵙ ⴱⴰⵍⴰⴽ: “ⵎⵉⵏ ⵉⵏⵏⴰ ⵙⵉⴷⵉ?” ");
INSERT INTO rift_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","ⵅⴻⵏⵏⵉ ⵉⴱⴷⴰ ⵏⴻⵜⵜⴰ ⴰⵡⴰⵍ ⵏⵏⴻⵙ ⵉⵡⴻⵣⵏⴻⵏ, ⵉⵏⵏⴰ: “ⴽⴽⴰⵔ, ⴱⴰⵍⴰⴽ, ⵙⵃⴻⵙⵙ! ⵙⴻⵍ ⵖⴰⵔⵉ, ⵛⴻⴽ, ⵎⵎⵉⵙ ⵏ ⵚⵉⴼⴼⵓⵔ! ");
INSERT INTO rift_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","ⴰⵔⴻⴱⴱⵉ ⵡⴰⵔ ⵉⴵⵉ ⴷ ⵎⵎⵉⵙ ⵏ ⴱⵏⴰⴷⴻⵎ, ⵎⴰⵃⴻⵏⴷ ⵣⴻⵄⵎⴰ ⴰⴷ ⵉⵙⵙⵅⴰⵔⵔⵉⵇ, ⵏⵉⵖ ⴷ ⵎⵎⵉⵙ ⵏ ⴱⵏⴰⴷⴻⵎ ⵎⴰⵃⴻⵏⴷ ⵣⴻⵄⵎⴰ ⴰⴷ ⵜ ⵉⵍⵇⴻⴼ ⵡⴻⵏⴷⴰⵎ. ⵎⴰ ⴰⴷ ⵢⵉⵏⵉ ⵓⵛⴰ ⵡⴰⵔ ⵜⵜ ⵉⵜⵜⴻⴳⴳ, ⵏⵉⵖ ⴰⴷ ⵉⵙⵙⵉⵡⴻⵍ ⵓⵛⴰ ⵡⴰⵔ ⵜⵜ ⵉⵜⵜⴽⴻⵎⵎⵉⵍ? ");
INSERT INTO rift_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","ⵅⵣⴰⵔ, ⴰⵇⴰ ⵟⵟⴼⴻⵖ ⵍⵓⵎⵓⵔ ⵃⵉⵎⴰ ⴰⴷ ⴱⴰⵔⴽⴻⵖ. ⵓⵎⵉ ⵉⴱⴰⵔⴻⴽ ⵏⴻⵜⵜⴰ, ⵏⴻⵛⵛ ⵡⴰⵔ ⵣⴻⵎⵎⴰⵔⴻⵖ ⴰⴷ ⴷⴷ-ⴰⵔⵔⴻⵖ ⴰⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","ⵡⴰⵔ ⵉⵜⵜⵡⵉⵍⵉ ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ ⵏ ⵢⴰⵄⵇⵓⴱ ⵓ ⵍⴻⵖⴱⴻⵏ ⵏ ⵉⵙⵔⴰⵉⵍ ⵡⴰⵔ ⵜ ⵉⵥⴰⵔ. ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵙ, ⴰⵇⴰ-ⵜ ⴰⴽⵉⴷⴻⵙ ⵓⵛⴰ ⴰⵙⵓⴹⵉ ⵙ ⵡⴻⵙⵔⵓⴷⴷⴻⵃ ⴷⵉ ⵍⴱⵓⵇ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏ ⵓⵊⴻⴵⵉⴷ ⴰⵇⴰ-ⵜ ⴷⴰⵢⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","ⴰⵔⴻⴱⴱⵉ ⵉⵙⵙⵓⴼⴼⴻⵖ ⵉ-ⵜⴻⵏ-ⴷⴷ ⵣⵉ ⵎⵉⵚⵔⴰ. ⵏⴻⵜⵜⴰ ⵉ ⵏⵉⵜⵏⵉ ⴰⵎ ⵡⴰⵛⵛⴰⵡⴻⵏ ⵉⵣⵉⵔⴰⵔⴻⵏ ⵏ ⵉⵖⴰⵢⴹ ⵏ ⵍⴻⵅⵍⴰ. ");
INSERT INTO rift_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","ⴰⵇⴰ ⵣⴻⵄⵎⴰ ⵡⴰⵔ ⴷⵉⵏ ⴰⵄⴻⵣⵣⴻⵎ ⴷⵉ ⵢⴰⵄⵇⵓⴱ ⵓ ⵡⴰⵔ ⴷⵉⵏ ⵜⴰⴳⴻⵣⵣⴰⵏⵜ ⴷⵉ ⵉⵙⵔⴰⵉⵍ. ⵜⴰ ⴷ ⵍⵡⴻⵇⵜ ⵉ ⴷⵉ ⵜᵉⵜⵜⵡⴰⵏⵏⴰ ⵅ ⵢⴰⵄⵇⵓⴱ ⴷ ⵉⵙⵔⴰⵉⵍ: ‘ⴰⵇⴰ ⵅⵣⴰⵔ, ⵎⵉⵏ ⵉⴳⴳⴰ ⴰⵔⴻⴱⴱⵉ!’ ");
INSERT INTO rift_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","ⴰⵇⴰ ⴷⴰ, ⵍⴳⴻⵏⵙ ⴰⴷ ⵉⴽⴽⴰⵔ ⴰⵎ ⵜⴻⵢⵔⴰⴷⵜ ⵓ ⴰⴷ ⴷⴷ-ⵉⴳⴻⵄⵄⴻⴷ ⴰⵎ ⵡⴻⵢⵔⴰⴷ. ⵡⴰⵔ ⵉⵙⵙⴻⵣⵣⴻⵍ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⴰⵍ ⵖⴰ ⵢⴻⵛⵛ ⵜⴰⵢⵎⴰⵔⵜ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⴷ ⵉⵙⵙⵓ ⵉⴷⴰⵎⵎⴻⵏ ⵏ ⵎⵉⵏ ⵉⵎⴻⵣⵣⴻⵇ.” ");
INSERT INTO rift_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⴱⴰⵍⴰⴽ ⵉ ⴱⴰⵍⵄⴰⵎ: “ⵎⴰⵍⴰ ⵅⴻⵏⵏⵉ ⵡⴰⵔ ⵜⴻⵅⵙⴻⴷ ⵇⴰⵄ ⴰⴷ ⵜ ⵜⵏⴻⵄⵍⴻⴷ, ⵡⴰⵔ ⵜ ⵜⵜⴱⴰⵔⴰⴽ ⵛⴰ ⵄⴰⵡⴻⴷ.” ");
INSERT INTO rift_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","ⴱⴰⵍⵄⴰⵎ ⵢⴰⵔⵔⴰ-ⴷⴷ, ⵉⵏⵏⴰ ⵉ ⴱⴰⵍⴰⴽ: “ⵎⴰ ⵡⴰⵔ ⴷ ⴰⵛ ⵏⵏⵉⵖ: ‘ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴷ ⴰⵢⵉ ⵖⴰ ⵢⵉⵏⵉ ⵙⵉⴷⵉ, ⴰⴷ ⵜ ⴳⴳⴻⵖ?’” ");
INSERT INTO rift_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⴱⴰⵍⴰⴽ ⵉ ⴱⴰⵍⵄⴰⵎ: “ⵜⵜⵣⴰⵡⴳⴻⵖ ⵛⴻⴽ ⴰⴷ ⴷⴷ-ⵜⴰⵙⴻⴷ, ⴰⴷ ⵛⴻⴽ ⴰⵡⵢⴻⵖ ⵖⴰⵔ ⵉⵊⵊ ⵏ ⵡⴻⵎⵛⴰⵏ ⵏⵏⴻⵖⵏⵉ. ⴰⴷ ⵜⴰⵖ ⴰⴷ ⵢⵉⵍⵉ ⵏⵉⵛⴰⵏ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⴰⵔⴻⴱⴱⵉ ⵎⴰⵍⴰ ⴰⴷ ⵜ ⵜⵏⴻⵄⵍⴻⴷ ⵙⵙⴻⵏⵏⵉ ⴷⵉ ⵟⵟⵡⴻⵄ ⵉⵏⵓ.” ");
INSERT INTO rift_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","ⵓⵛⴰ ⴱⴰⵍⴰⴽ ⵉⵏⴷⴻⵀ ⴱⴰⵍⵄⴰⵎ ⵖⴰⵔ ⵜⵇⵉⵛⵛⴰⵜ ⵏ ⴼⴰⵖⵓⵔ ⵏⵏⵉ ⵉⵅⴻⵣⵣⴰⵔⴻⵏ ⵖⴰⵔ ⵜⵏⴻⵣⵔⵓⴼⵜ. ");
INSERT INTO rift_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⴱⴰⵍⵄⴰⵎ ⵉ ⴱⴰⵍⴰⴽ: “ⴱⵏⴰ ⴷⴰⵏⵉⵜⴰ ⵙⴻⴱⵄⴰ ⵏ ⵉⵄⴰⵍⵟⴰⵔⴻⵏ ⵓⵛⴰ ⵙⴻⵡⵊⴻⴷ ⴰⵢⵉ ⴷⴰⵏⵉⵜⴰ ⵙⴻⴱⵄⴰ ⵏ ⵉⴼⵓⵏⴰⵙⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⴻⵏ ⴷ ⵙⴻⴱⵄⴰ ⵏ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","ⴱⴰⵍⴰⴽ ⵉⴳⴳⴰ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵙ ⵉⵏⵏⴰ ⴱⴰⵍⵄⴰⵎ ⵓⵛⴰ ⵅ ⴽⵓⵍ ⵉⵊⵊ ⵏ ⵓⵄⴰⵍⵟⴰⵔ ⵉⵇⴻⴷⴷⴻⵎ ⴷⵉⵏ ⵉⵊⵊ ⵏ ⵓⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ ⴷ ⵉⵊⵊ ⵏ ⵉⵛⴰⵔⵔⵉ. ");
INSERT INTO rift_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","ⵉⵥⵔⴰ ⴱⴰⵍⵄⴰⵎ ⴱⴻⵍⵍⵉ ⴰⵇⴰ ⵢⴰⵔⴹⴰ ⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵙⵉⴷⵉ ⵓⵎⵉ ⵉⴱⴰⵔⴻⴽ ⵉⵙⵔⴰⵉⵍ ⵓⵛⴰ ⵅⴻⵏⵏⵉ ⵡⴰⵔ ⵢⴰⵔⴻⵣⵣⵓ, ⴰⵎ ⵓⵎⵓⵔ ⴰⵎⴻⵣⵡⴰⵔⵓ ⴷ ⵓⵎⵓⵔ ⵡⵉⵙⵙ ⵜⵏⴰⵢⴻⵏ, ⵃⵉⵎⴰ ⴰⴷ ⵉⵄⴻⵣⵣⴻⵎ ⵙ ⵉⴼⵉⵖⵔⴰⵏ, ⵎⴰⵛⴰ ⵢⴰⵔⵔⴰ ⵓⴷⴻⵎ ⵏⵏⴻⵙ ⵖⴰⵔ ⵍⴻⵅⵍⴰ. ");
INSERT INTO rift_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","ⵓⵎⵉ ⵉⵙⵙⴳⴻⵄⵄⴻⴷ ⵜⴰⵎⵓⵖⵍⵉ ⵏⵏⴻⵙ, ⵉⵥⵔⴰ ⵉⵙⵔⴰⵉⵍ ⵉⵣⴷⴻⵖ ⴷⵉⵏ, ⵜᵉⵜⵜⵡⴰⵙⴻⵜⵜⴻⴼ ⵄⵍⴰⵃⵙⴰⴱ ⵜⵉⵇⴻⴱⴱⴰⵍ ⵏⵏⴻⵙ, ⵅⴻⵏⵏⵉ ⵢⵓⵙⴰ-ⴷⴷ ⴰⵔⵔⵓⵃ ⵏ ⴰⵔⴻⴱⴱⵉ ⵅⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","ⵉⴱⴷⴰ ⵏⴻⵜⵜⴰ ⴰⵡⴰⵍ ⵏⵏⴻⵙ ⵉⵡⴻⵣⵏⴻⵏ, ⵉⵏⵏⴰ: “ⴰⵡⴰⵍ ⵏ ⴱⴰⵍⵄⴰⵎ, ⵎⵎⵉⵙ ⵏ ⴱⴰⵄⵓⵔ, ⴰⵡⴰⵍ ⵏ ⵡⴻⵔⵢⴰⵣ ⵉⵊⴻⵀⴷⴻⵏ, ⵡⴻⵏⵏⵉ ⵓⵎⵉ ⵜⴻⵇⵇⴻⵏ ⵜⵉⵟⵟ, ");
INSERT INTO rift_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","ⵉⵊⵊ ⵏ ⵡⴰⵡⴰⵍ ⵏ ⵡⴻⵏⵏⵉ ⵉⵙⵍⵉⵏ ⴰⵡⴰⵍⴻⵏ ⵏ ⴰⵔⴻⴱⴱⵉ, ⴷ ⵡⴻⵏⵏⵉ ⵉⵅⴻⵣⵣⴰⵔⴻⵏ ⵍⴻⵡⵃⵉⵢ ⵏ ⵓⵎⵣⴻⵎⵎⴰⵔ ⵅ ⴽⵓⵍⵛⵉ, ⴰⵎ ⴷⴷ-ⵉⵡⴹⴰ ⵙ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵢⴰⵔⴻⵣⵎⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","ⴰ ⵢⴰⵄⵇⵓⴱ, ⵎⴻⵛⵃⴰⵍ ⵚⴻⴱⵃⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵏⴻⵛ, ⴷ ⵜⵣⴻⴷⴷⵉⵖⵉⵏ ⵏⵏⴻⵛ, ⴰ ⵉⵙⵔⴰⵉⵍ!, ");
INSERT INTO rift_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","ⴰⵇⴰ ⵙⵙⵡⵉⵥⵥⴰⴹⴻⵏ ⴰⵎⴻⵛⵏⴰⵡ ⵜⵉⵖⵣⵓⵔⵉⵏ, ⴰⵎⴻⵛⵏⴰⵡ ⴰⵖⴻⵎⵎⵓⵢ ⵉⵛⴻⵡⵡⴰⵔⴻⵏ ⴰⴽ-ⴷ ⵢⴻⵖⵣⴰⵔ, ⴰⵎⴻⵛⵏⴰⵡ ⴰⵛⴼⵉⵍ ⵏⵏⵉ ⵉⵥⵥⵓ ⵙⵉⴷⵉ, ⴰⵎⴻⵛⵏⴰⵡ ⵜⵉⵛⴻⵊⵊⵓⵔⴰ ⵏ ⵜⴻⵏⴳⴻⵍⵜ ⵣⵣⴰⵜ ⵉ ⵡⴰⵎⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","ⵣⴻⴳ ⵉⴱⵓⵇⴰⵍⴻⵏ ⵏⵏⴻⵙ ⴰⴷ ⵙⵙⵉⵣⵣⵍⴻⵏ ⵡⴰⵎⴰⵏ ⵓⵛⴰ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵙ ⴰⴷ ⵜⵉⵍⵉ ⴷⵉ ⵜⵓⴼⴼⴻⵜ. ⴰⵊⴻⴵⵉⴷ ⵏⵏⴻⵙ ⴰⴷ ⵉⵜⵜⵡⴰⵙⵙⴳⴻⵄⵄⴻⴷ ⵅ ⴰⵊⴰⵊ ⵓ ⵜⴰⴳⴻⵍⴷⵉⵜ ⵏⵏⴻⵙ ⴰⴷ ⵜᵉⵜⵜⵡⴰⵙⵙⵓⵄⵍⴰ. ");
INSERT INTO rift_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","ⴰⵔⴻⴱⴱⵉ ⵉⵙⵙⵓⴼⴼⴻⵖ ⵉ-ⵜ-ⵉ-ⴷⴷ ⵣⵉ ⵎⵉⵚⵔⴰ. ⵊⵊⴻⵀⴷ ⵏⵏⴻⵙ ⴰⵎ ⵡⴰⵛⵛⴰⵡⴻⵏ ⵉⵣⵉⵔⴰⵔⴻⵏ ⵏ ⵉⵖⴰⵢⴹ ⵏ ⵍⴻⵅⵍⴰ. ⴰⴷ ⵢⴻⵛⵛ ⵍⴻⴳⵏⵓⵙ, ⵉⵖⵔⵉⵎⴻⵏ ⵏⵏⴻⵙ, ⴰⴷ ⵉⵍⴱⴻⵣ ⵉⵖⵓⵙⵙⴰⵏ ⵏⵙⴻⵏ ⵓⵛⴰ ⴰⴷ ⵜⴻⵏ ⵉⵙⵙⵏⵓⵇⵇⴻⴱ ⵙ ⴼⵍⵉⵜⵛⴰⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","ⴰⵇⴰ ⵉⵖⵏⴻⵙ, ⵉⵙⵙⴻⵣⵣⴻⵍ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⴰⵎ ⵡⴻⵢⵔⴰⴷ, ⴰⵎ ⵜⴻⵢⵔⴰⴷⵜ. ⵡⵉ ⵜ ⵉ ⴷⴷ ⵖⴰ ⵉⵙⵙⴻⴽⴽⴰⵔⴻⵏ? ⵡⴻⵏⵏⵉ ⵛⴻⴽ ⵉⵜⵜⴱⴰⵔⴽⴻⵏ, ⴰⴷ ⵉⵜⵜⵡⴰⴱⴰⵔⴻⴽ ⵓ ⵡⴻⵏⵏⵉ ⵛⴻⴽ ⵉⵏⴻⵄⵄⵍⴻⵏ, ⴰⴷ ⵢⵉⵍⵉ ⵉⵜⵜⵡⴰⵏⵄⴻⵍ!’” ");
INSERT INTO rift_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","ⵅⴻⵏⵏⵉ ⵢⴰⵔⵖⴰ ⵓⵅⴻⵢⵢⴻⵇ ⵏ ⴱⴰⵍⴰⴽ ⵅ ⴱⴰⵍⵄⴰⵎ. ⵉⵡⵜⴰ ⵏⴻⵜⵜⴰ ⴷⴻⴳ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵏⴻⵙ ⵓⵛⴰ ⴱⴰⵍⴰⴽ ⵉⵏⵏⴰ ⵉ ⴱⴰⵍⵄⴰⵎ: “ⴰⵇⴰ ⵍⴰⵖⵉⵖ-ⴷⴷ ⵛⴻⴽ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⵏⴻⵄⵍⴻⴷ ⵍⵄⴻⴷⵢⴰⵏ ⵉⵏⵓ, ⵎⴰⵛⴰ ⵅⵣⴰⵔ, ⴰⵇⴰ ⵜⴱⴰⵔⴽⴻⴷ ⵉ-ⵜⴻⵏ ⵄⴰⴷ ⵏⵉⵛⴰⵏ ⵜⵍⴰⵜⴰ ⵏ ⵉⵎⵓⵔⴻⵏ! ");
INSERT INTO rift_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","ⵅⴻⵏⵏⵉ ⵍⴻⵅⵅⵓ, ⴰⵔⵡⴻⵍ ⵖⴰⵔ ⵡⴻⵎⵛⴰⵏ ⵎⴰⵏⵉ ⵜⵣⴻⴷⴷⵖⴻⴷ! ⵏⴻⵛⵛ ⵏⵏⵉⵖ ⴰⵛ ⵜ, ⴰⴷ ⵛⴻⴽ ⵛⴻⵏⵄⴻⵖ ⴰⵟⵟⴰⵙ, ⵎⴰⵛⴰ ⵅⵣⴰⵔ, ⵙⵉⴷⵉ ⵉⵎⵏⴻⵄ ⵅⴰⴽ ⵛⵛⴻⵏⵄⴻⵜ ⵏⵏⵉ!” ");
INSERT INTO rift_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⴱⴰⵍⵄⴰⵎ ⵉ ⴱⴰⵍⴰⴽ: “ⵎⴰ ⵡⴰⵔ ⵙⵙⵉⵡⵍⴻⵖ ⴰⴽ-ⴷ ⵉⵔⴻⵇⵇⴰⵙⴻⵏ ⵏⵏⵉ ⴷ ⴰⵢⵉ ⴷⴷ-ⵜᵉⵙⵙⴻⴽⴽⴻⴷ ⵓⵛⴰ ⵏⵏⵉⵖ: ");
INSERT INTO rift_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘ⵡⴰⵅⵅⴰ ⴱⴰⵍⴰⴽ ⴰⴷ ⴰⵢⵉ ⵉⵡⵛ ⵜⴰⴷⴷⴰⵔⵜ ⵏⵏⴻⵙ ⵜⴻⵛⵛⵓⵔ ⵙ ⵏⵏⵓⵇⴰⵔⵜ ⴷ ⵡⵓⵔⴻⵖ, ⵅⴻⵏⵏⵉ ⵏⴻⵛⵛ ⵄⴰⴷ ⵡⴰⵔ ⵣⵎⵉⵔⴻⵖ ⴰⴷ ⵄⴻⴷⴷⵉⵖ ⵅ ⵍⵓⵎⵓⵔ ⵏ ⵙⵉⴷⵉ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴳⴳⴻⵖ ⵛⴰ ⵏ ⵍⵃⴰⵊⵊⴻⵜ ⵏ ⵍⵅⴰⵔ ⵏⵉⵖ ⵏ ⵍⵖⴰⵔ ⵉ ⴷⴷ-ⵉⵜⵜⴻⴼⴼⵖⴻⵏ ⵣⴻⴳ ⵡⵓⵍ ⵉⵏⵓ. ⵎⵉⵏ ⵖⴰ ⵢⵉⵏⵉ ⵙⵉⴷⵉ, ⴰⴷ ⵜ ⵉⵏⵉⵖ.’ ");
INSERT INTO rift_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","ⵍⴻⵅⵅⵓ ⵅⴻⵏⵏⵉ, ⵅⵣⴰⵔ, ⵏⴻⵛⵛ ⴰⴷ ⴷⴷ-ⴷⴻⵡⵍⴻⵖ ⵖⴰⵔ ⵍⴳⴻⵏⵙ ⵉⵏⵓ. ⴰⵙ-ⴷⴷ, ⵏⴻⵛⵛ ⴰⴷ ⵛⴻⴽ ⵙⵙⴰⵔⴻⴳⴱⴻⵖ ⵅ ⵍⴻⴼⵀⴰⵎⴻⵜ ⵓⵛⴰ ⴰⴷ ⴰⵛ ⵉⵏⵉⵖ ⵎⵉⵏ ⴷ ⴰⵛ ⵖⴰ ⵢⴻⴳⴳ ⵍⴳⴻⵏⵙ-ⴰ ⴷⴻⴳ ⵓⵏⴻⴳⴳⴰⵔ ⵏ ⵡⵓⵙⵙⴰⵏ.” ");
INSERT INTO rift_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","ⵅⴻⵏⵏⵉ ⵉⴱⴷⴰ ⵏⴻⵜⵜⴰ ⴰⵡⴰⵍ ⵉⵡⴻⵣⵏⴻⵏ ⵏⵏⴻⵙ, ⵉⵏⵏⴰ: “ⴰⵡⴰⵍ ⵏ ⴱⴰⵍⵄⴰⵎ, ⵎⵎⵉⵙ ⵏ ⴱⴰⵄⵓⵔ, ⴰⵡⴰⵍ ⵏ ⵡⴻⵔⵢⴰⵣ ⵉⵊⴻⵀⴷⴻⵏ, ⵡⴻⵏⵏⵉ ⵓⵎⵉ ⵜⴻⵇⵇⴻⵏ ⵜⵉⵟⵟ! ");
INSERT INTO rift_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","ⵜⴰⵡⴰⵍⵜ ⵏ ⵡⴻⵏⵏⵉ ⵉⵙⵍⵉⵏ ⴰⵡⴰⵍⴻⵏ ⵏ ⴰⵔⴻⴱⴱⵉ, ⴷ ⵡⴻⵏⵏⵉ ⵉⵙⵙⵏⴻⵏ ⵣⵉ ⵜⵓⵙⵙⵏⴰ ⵏ ⵡⴻⵏⵏⵉ ⴷ ⴰⵎⵄⵓⴵⵉ ⵅ ⴽⵓⵍⵛⵉ, ⴷ ⵡⴻⵏⵏⵉ ⵉⵅⴻⵣⵣⴰⵔⴻⵏ ⵍⴻⵡⵃⵉⵢ ⵏ ⵓⵎⵣⴻⵎⵎⴰⵔ ⵅ ⴽⵓⵍⵛⵉ, ⴰⵎ ⴷⴷ-ⵉⵡⴹⴰ ⵙ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵢⴰⵔⴻⵣⵎⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","ⴰⴷ ⵜ ⵥⴰⵔⵖ, ⵡⴰⵔ ⵉⴵⵉ ⵍⴻⵅⵅⵓ, ⴰⴷ ⵜ ⵜⵡⴰⵍⵉⵖ, ⵎⴰⵛⴰ ⵡⴰⵔ ⵉⴵⵉ ⵣⵉ ⵍⴰⴷⴰⵙⴻⵜ. ⴰⴷ ⴷⴷ-ⵉⴼⴼⴻⵖ ⵉⵜⵔⵉ ⵣⵉ ⵢⴰⵄⵇⵓⴱ ⵓⵛⴰ ⴰⴷ ⵜⴻⴽⴽⴰⵔ ⵓⵣⴻⴵⴰⴹ ⵏ ⵍⵃⴰⴽⴻⵎ ⵣⵉ ⵉⵙⵔⴰⵉⵍ, ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵉⵍⴻⴱⵣⴻⵏ ⵍⵃⴻⵏⴽⴰⵜ ⵏ ⵓⵣⴻⴵⵉⴼ ⵏ ⵎⵓ’ⴰⴱ ⵓⵛⴰ ⴰⴷ ⵉⵍⴱⴻⵣ ⵎⴰⵔⵔⴰ ⵜⴰⵔⵡⴰ ⵏ ⵙⵙⴷⴻⵄ ");
INSERT INTO rift_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","ⵓⵛⴰ ⴰⴷ ⵉⵜⵜⵡⴰⵟⵟⴻⴼ ⵉⴷⵓⵎ ⴷ ⵍⵡⴰⵔⵜ ⵓ ⵙⴰⵄⵉⵔ, ⵡⴻⵏⵏⵉ ⴷ ⵍⴻⵄⴷⵓ ⵏⵏⴻⵙ, ⴰⴷ ⵜ ⵟⵟⴼⴻⵏ ⴷ ⵍⵡⴰⵔⵜ ⵄⴰⵡⴻⴷ, ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵢⴻⴳⴳ ⵉⵙⵔⴰⵉⵍ ⵙ ⵜⴰⵔⵢⴰⵙⵜ. ");
INSERT INTO rift_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","ⵓ ⵡⴻⵏⵏⵉ ⵉ ⴷⴷ ⵖⴰ ⵉⴼⴼⵖⴻⵏ ⵣⵉ ⵢⴰⵄⵇⵓⴱ ⴰⴷ ⵉⵃⴽⴻⵎ ⵓ ⵏⴻⵜⵜⴰ ⴰⴷ ⵉⵙⵙⵀⴻⵍⵍⴻⴽ ⵡⴻⵏⵏⵉ ⵢⴰⵔⴻⵡⵍⴻⵏ ⵣⵉ ⵜⴻⵏⴷⵉⵏⵜ.” ");
INSERT INTO rift_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","ⵓⵎⵉ ⵏⴻⵜⵜⴰ ⵉⵥⵔⴰ ⵄⴰⵎⴰⵍⵉⵇ, ⵉⴱⴷⴰ ⴰⵡⴰⵍ ⵉⵡⴻⵣⵏⴻⵏ ⵏⵏⴻⵙ, ⵉⵏⵏⴰ: “ⵄⴰⵎⴰⵍⵉⵇ ⴷ ⴰⵎⴻⵣⵡⴰⵔⵓ ⵏ ⵍⴻⴳⵏⵓⵙ, ⵎⴰⵛⴰ ⴰⵏⴻⴳⴳⴰⵔⵓ ⵏⵏⴻⵙ ⴰⴷ ⵉⴷⵡⴻⵍ ⴷ ⴰⵀⴻⵍⵍⴻⴽ!” ");
INSERT INTO rift_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","ⵍⴰⵎⵉ ⵉⵥⵔⴰ ⵉⵇⵉⵏⵉⵢⵢⴻⵏ, ⵉⴱⴷⴰ ⵏⴻⵜⵜⴰ ⴰⵡⴰⵍ ⵉⵡⴻⵣⵏⴻⵏ ⵏⵏⴻⵙ, ⵉⵏⵏⴰ: “ⵜⴰⵣⴻⴷⴷⵉⵖⵜ ⵏⵏⴻⵛ ⵜⴻⵎⵜⴻⵏ ⵓⵛⴰ ⵜⴻⴳⴳⵉⴷ ⵍⵄⵓⵛⵛ ⵏⵏⴻⵛ ⴷⵉ ⵜⴻⵚⴹⴰⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","ⵄⴰⴷ ⵇⴰⵢⵉⵏ ⴰⴷ ⵉⵜⵜⵡⴰⵙⵙⴻⵛⵎⴻⴹ. ⴰⵍ ⵎⴻⵍⵎⵉ ⵉⵣⴻⵎⵎⴰⵔ ⴰⵛⵛⵓⵔ ⴰⴷ ⴰⵛ ⴷⴷ-ⵢⴰⵡⵉ ⴷ ⴰⵎⴻⵃⴱⵓⵙ?” ");
INSERT INTO rift_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","ⵓⵛⴰ ⵉⴱⴷⴰ ⵏⴻⵜⵜⴰ ⴰⵡⴰⵍ ⵉⵡⴻⵣⵏⴻⵏ ⵏⵏⴻⵙ, ⵉⵏⵏⴰ: “ⴰⵢ, ⵡⵉ ⵖⴰ ⵉⵇⵇⵉⵎⴻⵏ ⵉⴷⴷⴰⵔⴻⵏ ⵅⵎⵉ ⵅⴰⵙ ⵉ ⵖⴰ ⵉⵙⵙⴰⵔⵙ ⴰⵔⴻⴱⴱⵉ ⵎⴰⵏ ⴰⵢⴰ? ");
INSERT INTO rift_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","ⵉⵖⴰⵔⵔⵓⴱⴰ ⵣⵉ ⵊⵊⵡⴰⵢⴻⵀ ⵏ ⴽⵉⵜⵜⵉⵎ ⴰⴷ ⵖⴻⵣⵣⴰⵏ ⴰⵛⵛⵓⵔ ⵓⵛⴰ ⴰⴷ ⵖⴻⵣⵣⴰⵏ ⵄⴰⵡⴻⴷ ⵄⴰⴱⵉⵔ ⵓ ⵏⴻⵜⵜⴰ ⴰⴷ ⵉⵜⵜⵡⴰⵜⴻⵃⵃⴰ.” ");
INSERT INTO rift_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","ⵉⴽⴽⴰⵔ ⴱⴰⵍⵄⴰⵎ, ⵢⵓⵢⵓⵔ ⵓⵛⴰ ⵉⴷⵡⴻⵍ ⵖⴰⵔ ⵡⴻⵎⵛⴰⵏ ⵏⵏⴻⵙ ⵏ ⵜⵣⴻⴷⴷⵉⵖⵜ. ⵓⵍⴰ ⴷ ⴱⴰⵍⴰⴽ ⵉⵟⵟⴻⴼ ⴰⴱⵔⵉⴷ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","ⵉⵣⴷⴻⵖ ⵉⵙⵔⴰⵉⵍ ⴷⵉ ⵛⵉⵟⵟⵉⵎ ⵓⵛⴰ ⵉⴱⴷⴰ ⵍⴳⴻⵏⵙ ⴰⴷ ⵉⵙⵙⴻⴼⵙⴻⴷ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⴰⴽ-ⴷ ⵢⴻⵙⵙⵉⵙ ⵏ ⵎⵓ’ⴰⴱ. ");
INSERT INTO rift_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","ⵄⴰⵔⴹⴻⵏ-ⴷⴷ ⵍⴳⴻⵏⵙ ⵖⴰⵔ ⵜⵖⴰⵔⵚⵉ ⵏ ⵉⵔⴻⴱⴱⵉⵜⴻⵏ ⵏⵙⴻⵏⵜ ⵓⵛⴰ ⵍⴳⴻⵏⵙ ⵉⵛⵛⴰ ⵣⵣⴰⵢⵙⴻⵏⵜ, ⵓⵛⴰ ⵏⵉⵜⵏⵉ ⴱⴻⵏⴷⵇⴻⵏ ⵉ ⵉⵔⴻⴱⴱⵉⵜⴻⵏ ⵏⵙⴻⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","ⴰⵎⵎⵓ ⵉⵎⵓⵏ ⵍⴳⴻⵏⵙ ⴰⴽ-ⴷ ⴱⴰⵄⵍ-ⴼⴰⵖⵓⵔ ⵓⵛⴰ ⵢⴰⵔⵖⴰ ⵡⴻⵖⴹⴰⴱ ⵏ ⵙⵉⴷⵉ ⵅ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⴽⵙⵉ ⵎⴰⵔⵔⴰ ⵉⵔⵢⴰⵣⴻⵏ ⵏⵏⵉ ⵉⴵⴰⵏ ⴷ ⵉⵣⴻⴵⵉⴼⴻⵏ ⵏ ⵍⴳⴻⵏⵙ ⵓⵛⴰ ⴰⵢⴻⵍ ⵉ-ⵜⴻⵏ ⵣⵣⴰⵜ ⵉ ⵙⵉⴷⵉ ⴷⵉ ⵜⴼⵓⵛⵜ ⵉⵃⴰⵔⵔⴻⵏ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⴳⴳⵯⴻⵊ ⵍⵃⴰⴷⵓⵇ ⵏ ⵡⴻⵖⴹⴰⴱ ⵏ ⵙⵉⴷⵉ ⵅ ⵉⵙⵔⴰⵉⵍ.” ");
INSERT INTO rift_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵎⵓⵙⴰ ⵉ ⵍⵇⵓⴹⴰⵜ ⵏ ⵉⵙⵔⴰⵉⵍ: “ⴻⵊⵊ ⴽⵓⵍ ⵉⵊⵊ ⴰⴷ ⵉⵏⴻⵖ ⵉⵏⵏⵉ ⵣⵉ ⵊⴰⵔ ⵢⴻⵔⵢⴰⵣⴻⵏ ⵏⵏⴻⵙ ⵉ ⵉⵎⵓⵏⴻⵏ ⴰⴽ-ⴷ ⴱⴰⵄⵍ-ⴼⴰⵖⵓⵔ!” ");
INSERT INTO rift_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","ⵓⵛⴰ ⵅⵣⴰⵔ, ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵣⴻⴳ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵢⵓⵙⴰ-ⴷⴷ ⵓⵛⴰ ⵏⴻⵜⵜⴰ ⵢⵉⵡⵉ-ⴷⴷ ⵉⵛⵜ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⵜⵎⵉⴷⵉⵢⴰⵏⴻⵛⵜ ⵖⴰⵔ ⴰⵢⵜⵎⴰⵙ ⵣⵣⴰⵜ ⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵎⵓⵙⴰ ⵓ ⵣⵣⴰⵜ ⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⴰⵎ ⵜⵜⵔⵓⵏ ⵏⵉⵜⵏⵉ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","ⵉⵥⵔⴰ ⵉ-ⵜ ⴼⵉⵏⴰⵃⴰⵙ, ⵎⵎⵉⵙ ⵏ ⴰⵍⵉⵄⴰⵣⴰⵔ, ⵎⵎⵉⵙ ⵏ ⵀⴰⵔⵓⵏ. ⵏⴻⵜⵜⴰ ⵉⴽⴽⴰⵔ ⵣⵉ ⵍⵡⴻⵙⵟ ⵏ ⵜⵎⴻⵙⵎⵓⵏⵜ, ⵉⴽⵙⵉ ⵉⵊⵊ ⵏ ⵓⵃⵔⵉⵛ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏⵏⴻⵙ ");
INSERT INTO rift_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","ⵓⵛⴰ ⵉⵔⵓⵃ ⴰⵡⴰⵔⵏⵉ ⵉ ⵡⴻⵔⵢⴰⵣ ⵣⵉ ⵉⵙⵔⴰⵉⵍ ⵖⴰⵔ ⵓⵇⵉⴹⵓⵏ ⵙ ⵍⵇⵓⴱⴱⴻⵜ ⵓⵛⴰ ⵉⵙⵙⵏⵓⵇⵇⴻⴱ ⵉ-ⵜⴻⵏ ⵙ ⵜⵏⴰⵢⴻⵏ, ⴰⵎ ⵡⴻⵔⵢⴰⵣ ⵏⵏⵉ ⵣⵉ ⵉⵙⵔⴰⵉⵍ, ⴰⵎ ⵜⴻⵎⵖⴰⵔⵜ ⵙ ⵓⵄⴻⴷⴷⵉⵙ ⵏⵏⴻⵙ. ⵅⴻⵏⵏⵉ ⵜⴱⴻⴷⴷ ⵊⵊⵔⵉⵃⴻⵛⵜ ⵅ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","ⵓⵛⴰ ⵎⵎⵓⵜⴻⵏ ⴷⵉ ⵊⵊⵔⵉⵃⴻⵛⵜ ⴰⵔⴻⴱⵄⴰ ⵓ-ⵄⵉⵛⵔⵉⵏ-ⴰⵍⴻⴼ ⵏ ⵉⵡⴷⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“ⴼⵉⵏⴻⵃⴰⵙ, ⵎⵎⵉⵙ ⵏ ⴰⵍⵉⵄⴰⵣⴰⵔ, ⵎⵎⵉⵙ ⵏ ⵀⴰⵔⵓⵏ, ⴰⴽⴻⵀⵀⴰⵏ, ⵉⵙⵙⴻⴳⴳⵡⴻⵊ ⴰⵙⵄⴰⵔ ⵉⵏⵓ ⵅ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵎⵉⵏⵣⵉ ⵏⴻⵜⵜⴰ ⵜⵓⵖⴰ ⵉⵎⵃⴻⴹ ⴰⵟⵟⴰⵙ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏⵙⴻⵏ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏ ⵜⵓⵙⵎⵉ ⵉⵏⵓ ⵉⵇⴻⴷⴷⵙⴻⵏ, ⴰⵍⴰⵎⵉ ⵏⴻⵛⵛ ⵡⴰⵔ ⵀⴷⵉⵊⴻⵖ ⵄⴰⴷ ⴰⴷ ⵜⴻⵃⵃⵉⵖ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴷⵉ ⵍⵡⴻⵇⵜ ⵏ ⵜⵓⵙⵎⵉ ⵉⵏⵓ ⵉⵇⴻⴷⴷⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","ⵙ ⵓⵢⴰ ⵉⵏⵉ: ‘ⵅⵥⴰⵔ, ⵏⴻⵛⵛ ⴰⴷ ⴰⵙ ⵡⵛⴻⵖ ⵍⵄⴰⵀⴷ ⵉⵏⵓ ⵏ ⵍⴻⵀⵏⴰ. ");
INSERT INTO rift_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","ⵉ ⵏⴻⵜⵜⴰ ⵓ ⵉ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵏⴻⵙ ⴰⵡⴰⵔⵏⵉ ⴰⵙ ⴰⴷ ⵖⴰⵔⵙⴻⵏ ⵢⵉⵍⵉ ⵍⵄⴰⵀⴷ ⵏ ⵜⵓⴽⴻⵀⵀⴰⵏⵜ ⵉ ⵍⴻⴱⴷⴰ, ⵎⵉⵏⵣⵉ ⵏⴻⵜⵜⴰ ⵜⵓⵖⴰ ⵉⵎⵃⴻⴹ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏ ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⴳⴳⴰ ⴰⵚⵍⴰⵃ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ.’” ");
INSERT INTO rift_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","ⵉⵙⴻⵎ ⵏ ⵡⴻⵔⵢⴰⵣ ⵏ ⵉⵙⵔⴰⵉⵍ ⵏⵏⵉ ⵉⵏⵖⴰ ⴼⵉⵏⴻⵃⴰⵙ, ⵉ ⵜⵓⵖⴰ ⵉⵜⵜⵡⴰⵏⴻⵖ ⵊⵎⵉⵄ ⴰⴽ-ⴷ ⵜⴻⵎⵖⴰⵔⵜ ⵜⴰⵎⵉⴷⵢⴰⵏⴻⵛⵜ, ⵜⵓⵖⴰ-ⵜ ⴷ ⵣⵉⵎⵔⵉ, ⵎⵎⵉⵙ ⵏ ⵙⴰⵍⵓ, ⵉⵊⵊ ⵏ ⵍⵃⴰⴽⴻⵎ ⵅ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⴱⴰⴱⴰⵜⵙⴻⵏ, ⵅ ⵉⵛⵉⵎⵄⵓⵏⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","ⵉⵙⴻⵎ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⵜⴰⵎⵉⴷⵢⴰⵏⵉⵛⵜ ⵉ ⵜⵓⵖⴰ ⵉⵜⵜⵡⴰⵏⵖⴻⵏ ⵜⵓⵖⴰ-ⵜⵜ ⴽⵓⵣⴱⵉ, ⵢⴻⴵⵉⵙ ⵏ ⵚⵓⵔ, ⵡⴻⵏⵏⵉ ⴷ ⵉⵊⵊ ⵏ ⵓⵣⴻⴵⵉⴼ ⵅ ⵜⵇⴻⴱⴱⴰⵍⵜ ⵏ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵉⵊⵊ ⵏ ⵜⴱⴰⴱⴰⵜ ⵏ ⵉⵎⵉⴷⵢⴰⵏⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“ⵃⵚⴰⵔⴻⵎ ⵅ ⵉⵎⵉⴷⵢⴰⵏⵉⵢⵢⴻⵏ ⵓⵛⴰ ⵖⴻⵍⵍⴱⴻⵎ ⵅⴰⵙⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","ⵎⵉⵏⵣⵉ ⵏⵉⵜⵏⵉ ⵃⵚⴰⵔⴻⵏ ⴽⴻⵏⵏⵉⵡ ⵙ ⵜⴻⵃⵔⴰⵢⵎⴻⵛⵜ ⵏⵙⴻⵏ ⵙ ⵎⵉⵏⵣⵉ ⴽⴻⵏⵏⵉⵡ ⵣⴻⵍⵖⴻⵏ ⵣⵉ ⵊⵊⵉⵀⴻⵜ ⵏ ⴼⴰⵖⵓⵔ ⴷ ⴽⵓⵣⴱⵉ, ⵢⴻⴵⵉⵙ ⵏ ⵍⵃⴰⴽⴻⵎ ⵏ ⵎⵉⴷⵢⴰⵏ, ⵓⵍⵜⵎⴰⵜⵙⴻⵏ, ⵜⴻⵏⵏⵉ ⵉⵜⵜⵡⴰⵏⵖⴻⵏ ⴷⴻⴳ ⵡⴰⵙⵙ ⵏ ⵊⵊⵔⵉⵃⴻⵛⵜ ⴷⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⴼⴰⵖⵓⵔ.” ");
INSERT INTO rift_vpl VALUES ("NU25_19","005_25_19","NUM","25","19","19","ⵓⵛⴰ ⴰⵡⴰⵔⵏⵉ ⵉ ⵊⵊⵔⵉⵃⴻⵛⵜ ⵉⵎⵙⴰⵔ ⵎⵉⵏ ⴷⴷ-ⵉⴳⴳⵓⵔⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ ⴷ ⴰⵍⵉⵄⴰⵣⴰⵔ, ⵎⵎⵉⵙ ⵏ ⵀⴰⵔⵓⵏ, ⴰⴽⴻⵀⵀⴰⵏ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“ⵃⴻⵙⴱⴻⵎ ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⴰⵣⴻⴵⵉⴼ ⴰⵣⴻⴵⵉⴼ, ⵣⵉ ⵄⵉⵛⵍⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵙⴻⵏⵏⴻⵊ, ⴰⵎ ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵏⵉⵜⵏⵉ ⵄⵍⴰⵃⵙⴰⴱ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵙⴻⵏ, ⵎⴰⵔⵔⴰ ⵡⴻⵏⵏⵉ ⴷⴷ-ⵉⵜⵜⴻⴼⴼⵖⴻⵏ ⴷⵉ ⵉⵙⵔⴰⵉⵍ ⴰⴽ-ⴷ ⵍⵄⴻⵙⴽⴰⵔ.” ");
INSERT INTO rift_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","ⵎⵓⵙⴰ ⴷ ⴰⵍⵉⵄⴰⵣⴰⵔ, ⴰⴽⴻⵀⵀⴰⵏ, ⵙⵙⵉⵡⵍⴻⵏ ⴰⴽⵉⴷⵙⴻⵏ ⴷⵉ ⵍⴻⵡⴹⴰⵜ ⵏ ⵎⵓ’ⴰⴱ, ⵖⴰⵔ ⵍ’ⵓⵔⴷⵓⵏ ⴰⵔⴻⵏⴷⴰⴷ ⵏ ⴰⵔⵉⵃⴰ ⵓⵛⴰ ⵏⵏⴰⵏ: ");
INSERT INTO rift_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“ⵣⵉ ⵄⵉⵛⵍⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵙⴻⵏⵏⴻⵊ!” ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ. ⵉⵏⴰ ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵏⵏⵉ ⵜⵓⵖⴰ ⴷⴷ-ⵉⴼⴼⵖⴻⵏ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ: ");
INSERT INTO rift_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","ⵔⵓⴱⵉⵏ ⵜⵓⵖⴰ ⴷ ⴰⵎⴻⵏⵣⵓ ⵏ ⵉⵙⵔⴰⵉⵍ. ⴰⵇⴰ ⵉⵏⴰ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵔⵓⴱⵉⵏ: ⵣⵉ ⵃⴰⵏⵓⴽ ⵍⴰⴵ ⵏ ⵉⵃⴰⵏⵓⴽⵉⵢⵢⴻⵏ, ⵣⵉ ⴼⴰⵍⵍⵓ ⵍⴰⴵ ⵏ ⵉⴼⴰⵍⵍⵓⵡⵉⵢⵢⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","ⵣⵉ ⵃⴰⵚⵔⵓⵏ ⵍⴰⴵ ⵏ ⵉⵃⴰⵚⵔⵓⵏⵉⵢⵢⴻⵏ, ⵣⵉ ⴽⴰⵔⵎⵉ ⵍⴰⴵ ⵏ ⵉⴽⴰⵔⵎⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","ⵜⵉⵏⴰ ⵜⵓⵖⴰ ⴷ ⵍⴰⴵⴰⵜ ⵏ ⵉⵔⵓⴱⵉⵏⵉⵢⵢⴻⵏ ⵓⵛⴰ ⵉⵏⵏⵉ ⵣⵣⴰⵢⵙⴻⵏ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⵜⵍⴰⵜⴰ ⵓ-ⵔⴻⴱⵄⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⵙⴻⴱⵄⴰ-ⵎⵢⴰ ⵓ-ⵜⵍⴰⵜⵉⵏ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","ⵜⴰⵔⵡⴰ ⵏ ⴼⴰⵍⵍⵓ ⵜⵓⵖⴰ ⴰⵜⴻⵏ: ⵎⵖⵉⵔ ⵉⵍⵉⵢⴰⴱ. ");
INSERT INTO rift_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","ⵜⵓⵖⴰ ⴰⵔⵔⴰⵡ ⵏ ⵉⵍⵉⵢⴰⴱ: ⵏⵉⵎⵓⵢⵉⵍ, ⴷⴰⵜⴰⵏ ⴷ ⴰⴱⵉⵔⴰⵎ. ⵉⵏⴰ, ⴷⴰⵜⴰⵏ ⴷ ⴰⴱⵉⵔⴰⵎ, ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵎⵍⴰⵖⴰⵏ ⵏ ⵜⵎⴻⵙⵎⵓⵏⵜ ⵉⵏⵏⵉ ⵉⵖⴻⵡⵡⵖⴻⵏ ⴹⵉⴷⴷ ⵉ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ, ⵊⵎⵉⵄ ⴰⴽ-ⴷ ⵓⴱⴰⵔⵔⵓ ⵏ ⵇⵓⵔⴰⵃ, ⵓⵎⵉ ⵖⴻⵡⵡⵖⴻⵏ ⴹⵉⴷⴷ ⵉ ⵙⵉⴷⵉ.    ");
INSERT INTO rift_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","ⵜⴰⵎⵎⵓⵔⵜ ⵜⴰⵔⵣⴻⵎ ⴰⵇⴻⵎⵎⵓⵎ ⵏⵏⴻⵙ ⵓⵛⴰ ⵜⵙⴰⵔⴹ ⵉ-ⵜⴻⵏ, ⵊⵎⵉⵄ ⴰⴽ-ⴷ ⵇⵓⵔⴰⵃ, ⵍⴰⵎⵉ ⵉⵎⵎⵓⵜ ⵓⴱⴰⵔⵔⵓ ⵏⵏⵉ ⵓⵎⵉ ⵜⵉⵎⴻⵙⵙⵉ ⵜⴻⵛⵛⴰ ⵎⵉⵜⴰⵢⴻⵏ ⵓ-ⵅⴻⵎⵙⵉⵏ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ. ⴷⴻⵡⵍⴻⵏ ⵏⵉⵜⵏⵉ ⴷ ⵉⵊⵊ ⵏ ⵡⴻⵄⵍⴰⵎ ⵉⵙⵙⵉⴳⴳⵡⵉⴷⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","ⵎⴰⵛⴰ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵇⵓⵔⴰⵃ ⵡⴰⵔ ⵎⵎⵓⵜⴻⵏ ⵛⴰ. ");
INSERT INTO rift_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","ⵉⵏⴰ ⵜⵓⵖⴰ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵛⵉⵎⵄⵓⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ: ⵣⵉ ⵏⵉⵎⵓⵢⵉⵍ ⵉⵇⵇⴰⵔⵚ ⵍⴰⴵ ⵏ ⵉⵏⵉⵎⵓⵢⵉⵍⵉⵢⵢⴻⵏ, ⵣⵉ ⵢⴰⵎⵉⵏ ⵍⴰⴵ ⵏ ⵉⵢⴰⵎⵉⵏⵉⵢⵢⴻⵏ, ⵣⵉ ⵢⴰⴽⵉⵏ ⵍⴰⴵ ⵏ ⵉⵢⴰⴽⵉⵏⵉⵢⵢⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","ⵣⵉ ⵣⴰⵔⴰⵃ ⵍⴰⴵ ⵏ ⵉⵣⴰⵔⴰⵃⵉⵢⵢⴻⵏ, ⵣⵉ ⵛⴰⵡⵓⵍ ⵍⴰⴵ ⵏ ⵉⵛⴰⵡⵓⵍⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","ⵜⵉⵏⴰ ⵜⵓⵖⴰ ⴷ ⵍⴰⴵⴰⵜ ⵏ ⵉⵛⵉⵎⵄⵓⵏⵉⵢⵢⴻⵏ: ⵜⵏⴰⵢⴻⵏ ⵓ-ⵄⵉⵛⵔⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⵎⵉⵜⴰⵢⵏ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","ⵉⵏⴰ ⵜⵓⵖⴰ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵊⴰⴷ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ: ⵣⵉ ⵚⵉⴼⵓⵏ ⵉⵇⵇⴰⵔⵚ ⵍⴰⴵ ⵏ ⵉⵚⵉⴼⵓⵏⵉⵢⵢⴻⵏ, ⵣⵉ ⵃⴰⵊⵊⵉ ⵍⴰⴵ ⵏ ⵉⵃⴰⵊⵊⵉⵡⵉⵢⵢⴻⵏ, ⵣⵉ ⵛⵓⵏⵉ ⵍⴰⴵ ⵏ ⵉⵛⵓⵏⵉⵢⵢⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ⵣⵉ ⵓⵣⵏⵉ ⵍⴰⴵ ⵏ ⵉⵢⵓⵣⵏⵉⵢⵢⴻⵏ, ⵣⵉ ⵄⵉⵔⵉ ⵍⴰⴵ ⵏ ⵉⵄⵉⵔⵉⵢⵢⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","ⵣⵉ ⴰⵔⵓⴷ ⵍⴰⴵ ⵏ ⵉⵔⵓⴷⵉⵢⵢⴻⵏ, ⵣⵉ ⴰⵔⵉⵢⵉⵍⵉ ⵍⴰⴵ ⵏ ⵉⵔⵉⵢⵉⵍⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","ⵜⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏⵜ ⴷ ⵍⴰⴵⴰⵜ ⵏ ⵊⴰⴷ ⵓⵛⴰ ⵉⵏⵏⵉ ⵣⵣⴰⵢⵙⴻⵏ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⴰⵔⴻⴱⵄⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⵅⴻⵎⵙⴰ-ⵎⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","ⴰⵢⵜ ⵏ ⵢⴰⵀⵓⴷⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵄⵉⵔ ⴷ ⵓⵏⴰⵏ. ⵎⴰⵛⴰ ⵎⵎⵓⵜⴻⵏ ⵄⵉⵔ ⴷ ⵓⵏⴰⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵢⴰⵀⵓⴷⴰ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ: ⵣⵉ ⵛⴰⵢⵍⴰ ⵉⵇⵇⴰⵔⵚ ⵍⴰⴵ ⵏ ⵉⵛⵉⵍⴰⵢⵢⴻⵏ, ⵣⵉ ⴼⴰⵔⵉⵚ ⵍⴰⴵ ⵏ ⵉⴼⴰⵔⴰⵚⵉⵢⵢⴻⵏ, ⵣⵉ ⵣⴰⵔⴰⵃ ⵍⴰⴵ ⵏ ⵉⵣⴰⵔⴰⵃⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⴼⴰⵔⵉⵚ: ⵣⵉ ⵃⴰⵚⵔⵓⵏ ⵉⵇⵇⴰⵔⵚ ⵍⴰⴵ ⵏ ⵉⵃⴰⵚⵔⵓⵏⵉⵢⵢⴻⵏ, ⵣⵉ ⵃⴰⵎⵓⵍ ⵍⴰⴵ ⵏ ⵉⵃⴰⵎⵓⵍⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","ⵜⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏⵜ ⴷ ⵍⴰⴵⴰⵜ ⵏ ⵢⴰⵀⵓⴷⴰ ⵓⵛⴰ ⵉⵏⵏⵉ ⵣⵣⴰⵢⵙⴻⵏ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⵙⴻⵜⵜⴰ ⵓ-ⵙⴻⴱⵄⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⵅⴻⵎⵙⴰ-ⵎⵢⴰ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵉⵙⵙⴰⴽⴰⵔ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ: ⵣⵉ ⵜⵓⵍⴰⵄ ⵉⵇⵇⴰⵔⵚ ⵍⴰⴵ ⵏ ⵉⵜⵓⵍⴰⵄⵉⵢⵢⴻⵏ, ⵣⵉ ⴱⵓⵡⴰ ⵍⴰⴵ ⵏ ⵉⴱⵓⵡⴰⵏⵉⵢⵢⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","ⵣⵉ ⵢⴰⵛⵓⴱ ⵍⴰⴵ ⵏ ⵉⵢⴰⵛⵓⴱⵉⵢⵢⴻⵏ, ⵣⵉ ⵛⵉⵎⵔⵓⵏ ⵍⴰⴵ ⵏ ⵉⵛⵉⵎⵔⵓⵏⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","ⵜⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏⵜ ⴷ ⵍⴰⴵⴰⵜ ⵏ ⵉⵙⵙⴰⴽⴰⵔ ⵓⵛⴰ ⵉⵏⵏⵉ ⵣⵣⴰⵢⵙⴻⵏ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⴰⵔⴻⴱⵄⴰ ⵓ-ⵙⴻⵜⵜⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⵜⴻⵍⵜ-ⵎⵢⴰ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵣⴰⴱⵓⵍⵓⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ: ⵣⵉ ⵙⴰⵔⵉⴷ ⵉⵇⵇⴰⵔⵚ ⵍⴰⴵ ⵏ ⵉⵙⴰⵔⵉⴷⵉⵢⵢⴻⵏ, ⵣⵉ ⵉⵍⵓⵏ ⵍⴰⴵ ⵏ ⵉⵍⵓⵏⵉⵢⵢⴻⵏ, ⵣⵉ ⵢⴰⵃⵍⵉⵢⵉⵍ ⵍⴰⴵ ⵏ ⵉⵢⴰⵃⵍⵉⵢⵉⵍⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","ⵜⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏⵜ ⴷ ⵍⴰⴵⴰⵜ ⵏ ⵉⵣⴰⴱⵓⵍⵓⵏⵉⵢⵢⴻⵏ ⵓⵛⴰ ⵉⵏⵏⵉ ⵣⵣⴰⵢⵙⴻⵏ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⵙⴻⵜⵜⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⵅⴻⵎⵙⴰ-ⵎⵢⴰ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵢⵓⵙⵓⴼ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ: ⵎⴰⵏⴰⵙⵙⴰ ⴷ ⵉⴼⵔⴰⵢⵉⵎ. ");
INSERT INTO rift_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵎⴰⵏⴰⵙⵙⴰ: ⵣⵉ ⵎⴰⴽⵉⵔ ⵉⵇⵇⴰⵔⵚ ⵍⴰⴵ ⵏ ⵉⵎⴰⴽⵉⵔⵉⵢⵢⴻⵏ. ⵎⴰⴽⵉⵔ ⵢⴻⵊⵊ-ⴷⴷ ⵊⵉⵍⵄⴰⴷ. ⵣⵉ ⵊⵉⵍⵄⴰⴷ ⵉⵇⵇⴰⵔⵚ ⵍⴰⴵ ⵏ ⵉⵊⵉⵍⵄⴰⴷⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵊⵉⵍⵄⴰⴷ: ⵣⵉ ⵉⵄⴰⵣⴰⵔ ⵉⵇⵇⴰⵔⵚ ⵍⴰⴵ ⵏ ⵉⵄⴰⵣⴰⵔⵉⵢⵢⴻⵏ, ⵣⵉ ⵃⴰⵍⴰⵇ ⵍⴰⴵ ⵏ ⵉⵃⴰⵍⴰⵇⵉⵢⵢⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","ⵣⵉ ⴰⵙⵔⵉⵢⵉⵍ ⵍⴰⴵ ⵏ ⵉⵙⵔⵉⵢⵉⵍⵉⵢⵢⴻⵏ, ⵣⵉ ⵛⴰⴽⴰⵎ ⵍⴰⴵ ⵏ ⵉⵛⴰⴽⴰⵎⵉⵢⵢⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","ⵣⵉ ⵛⵉⵎⵉⴷⴰⵄ ⵍⴰⴵ ⵏ ⵉⵛⵉⵎⴷⴰⵄⵉⵢⵢⴻⵏ, ⵣⵉ ⵃⴰⴼⴰⵔ ⵍⴰⴵ ⵏ ⵉⵃⴰⴼⴰⵔⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","ⵚⴰⵍⵓⴼⵃⴰⴷ, ⵎⵎⵉⵙ ⵏ ⵃⴰⴼⴰⵔ, ⵡⴰⵔ ⵜⵓⵖⵉ ⵖⴰⵔⴻⵙ ⵛⴰ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ, ⵎⵖⵉⵔ ⵜⵉⵃⴻⵏⵊⵉⵔⵉⵏ. ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵙⵎⴰⵡⴻⵏ ⵏ ⵢⴻⵙⵙⵉⵙ ⵏ ⵚⴰⵍⵓⴼⵃⴰⴷ: ⵎⴰⵃⵍⴰ, ⵏⵓⵄⴰ, ⵃⵓⵊⵍⴰ, ⵎⵉⵍⴽⴰ ⴷ ⵜⵉⵔⵚⴰ. ");
INSERT INTO rift_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","ⵜⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏⵜ ⴷ ⵍⴰⴵⴰⵜ ⵏ ⵎⴰⵏⴰⵙⵙⴰ ⵓⵛⴰ ⵉⵏⵏⵉ ⵣⵣⴰⵢⵙⴻⵏ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⵜⵏⴰⵢⴻⵏ ⵓ-ⵅⴻⵎⵙⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⵙⴻⴱⵄⴰ-ⵎⵢⴰ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵉⴼⵔⴰⵢⵉⵎ, ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ: ⵣⵉ ⵛⵓⵜⴰⵍⴰⵃ ⵉⵇⵇⴰⵔⵚ ⵍⴰⴵ ⵏ ⵉⵛⵓⵜⴰⵍⴰⵃⵉⵢⵢⴻⵏ, ⵣⵉ ⴱⴰⴽⴰⵔ ⵍⴰⴵ ⵏ ⵉⴱⴰⴽⴰⵔⵉⵢⵢⴻⵏ, ⵣⵉ ⵜⴰⵃⴰⵏ ⵍⴰⴵ ⵏ ⵉⵜⴰⵃⴰⵏⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵛⵓⵜⴰⵍⴰⵃ: ⵣⵉ ⵄⵉⵔⴰⵏ ⵍⴰⴵ ⵏ ⵉⵄⵉⵔⴰⵏⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","ⵜⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏⵜ ⴷ ⵍⴰⴵⴰⵜ ⵏ ⵡⴰⵔⵔⴰⵡⴻⵏ ⵏ ⵉⴼⵔⴰⵢⵉⵎ ⵓⵛⴰ ⵉⵏⵏⵉ ⵣⵣⴰⵢⵙⴻⵏ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⵜⵏⴰⵢⴻⵏ ⵓ-ⵜⵍⴰⵜⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⵅⴻⵎⵙⴰ-ⵎⵢⴰ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ. ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⴰⵔⵔⴰⵡⴻⵏ ⵏ ⵢⵓⵙⵓⴼ, ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⴱⵉⵏⵢⴰⵎⵉⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ: ⵣⵉ ⴱⵉⵍⴰⵄ ⵉⵇⵇⴰⵔⵚ ⵍⴰⴵ ⵏ ⵉⴱⵉⵍⴰⵄⵉⵢⵢⴻⵏ, ⵣⵉ ⴰⵛⴱⵉⵍ ⵍⴰⴵ ⵏ ⵉⵛⴱⵉⵍⵉⵢⵢⴻⵏ, ⵣⵉ ⴰⵃⵉⵔⴰⵎ ⵍⴰⴵ ⵏ ⵉⵃⵉⵔⴰⵎⵉⵢⵢⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","ⵣⵉ ⵛⴰⴼⵓⴼⴰⵎ ⵍⴰⴵ ⵏ ⵉⵛⴰⴼⵓⴼⴰⵎⵉⵢⵢⴻⵏ, ⵣⵉ ⵃⵓⴼⴰⵎ ⵍⴰⴵ ⵏ ⵉⵃⵓⴼⴰⵎⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⴱⴰⵍⴰⵄ: ⴰⵔⴷ ⴷ ⵏⵓⵄⵎⴰⵏ. ⵣⵉ ⴰⵔⴷ ⵉⵇⵇⴰⵔⵚ ⵍⴰⴵ ⵏ ⵉⵔⴷⵉⵢⵢⴻⵏ, ⵣⵉ ⵏⵓⵄⵎⴰⵏ ⵍⴰⴵ ⵏ ⵉⵏⵓⵄⵎⴰⵏⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⴱⵉⵏⵢⴰⵎⵉⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ ⵓⵛⴰ ⵉⵏⵏⵉ ⵣⵣⴰⵢⵙⴻⵏ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⵅⴻⵎⵙⴰ ⵓ-ⵔⴻⴱⵄⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⵙⴻⵜⵜⴰ-ⵎⵢⴰ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⴷⴰⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ: ⵣⵉ ⵛⵓⵃⴰⵎ ⵉⵇⵇⴰⵔⵚ ⵍⴰⴵ ⵏ ⵉⵛⵓⵃⴰⵎⵉⵢⵢⴻⵏ. ⵜⵉⵏⴰ ⵜⵓⵖⴰ ⴷ ⵍⴰⴵⴰⵜ ⵏ ⴷⴰⵏ, ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏⵜ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","ⵎⴰⵔⵔⴰ ⵍⴰⴵⴰⵜ ⵏ ⵉⵛⵓⵃⴰⵎⵉⵢⵢⴻⵏ, ⴰⵇⴰ ⵉⵏⵏⵉ ⵣⵣⴰⵢⵙⴻⵏ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⴰⵔⴻⴱⵄⴰ ⵓ-ⵙⴻⵜⵜⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⴰⵔⴻⴱⵄⴰ-ⵎⵢⴰ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⴰⵛⵉⵔ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ: ⵣⵉ ⵢⵉⵎⵏⴰ ⵉⵇⵇⴰⵔⵚ ⵍⴰⴵ ⵏ ⵉⵢⵉⵎⵏⵉⵢⵢⴻⵏ, ⵣⵉ ⵢⵉⵛⵡⵉ ⵍⴰⴵ ⵏ ⵉⵢⵉⵛⵡⵉⵢⵢⴻⵏ, ⵣⵉ ⴱⴻⵔⵉⵄⴰ ⵍⴰⴵ ⵏ ⵉⴱⴰⵔⵉⵄⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⴱⴻⵔⵉⵄⴰ: ⵣⵉ ⵃⴰⴱⵉⵔ ⵉⵇⵇⴰⵔⵚ ⵍⴰⴵ ⵏ ⵉⵃⴰⴱⵉⵔⵉⵢⵢⴻⵏ, ⵣⵉ ⵎⴰⵍⴽⵉⵢⵉⵍ ⵍⴰⴵ ⵏ ⵉⵎⴰⵍⴽⵉⵢⵉⵍⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","ⵉⵙⴻⵎ ⵏ ⵢⴻⴵⵉⵙ ⵏ ⴰⵛⵉⵔ ⵜⵓⵖⴰ-ⵜⵜ ⴷ ⵙⴰⵔⴰⵃ. ");
INSERT INTO rift_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⴰⵛⵉⵔ ⵓⵛⴰ ⵉⵏⵏⵉ ⵣⵣⴰⵢⵙⴻⵏ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⵜⵍⴰⵜⴰ ⵓ-ⵅⴻⵎⵙⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⴰⵔⴻⴱⵄⴰ-ⵎⵢⴰ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵏⴰⴼⵜⴰⵍⵉ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ: ⵣⵉ ⵢⴰⵃⴰⵙⵢⵉⵍ ⵉⵇⵇⴰⵔⵚ ⵍⴰⴵ ⵏ ⵉⵢⴰⵃⴰⵙⵍⵉⵢⵢⴻⵏ, ⵣⵉ ⵊⵓⵏⵉ ⵍⴰⴵ ⵏ ⵉⵊⵓⵏⵉⵢⵢⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","ⵣⵉ ⵢⴰⵚⵉⵔ ⵍⴰⴵ ⵏ ⵉⵢⴰⵚⵉⵔⵉⵢⵢⴻⵏ, ⵣⵉ ⵛⵉⵍⵍⵉⵎ ⵍⴰⴵ ⵏ ⵉⵛⵉⵍⵍⵉⵎⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","ⵜⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏⵜ ⴷ ⵍⴰⴵⴰⵜ ⵏ ⵏⴰⴼⵜⴰⵍⵉ, ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ ⵓⵛⴰ ⵉⵏⵏⵉ ⵣⵣⴰⵢⵙⴻⵏ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⵅⴻⵎⵙⴰ ⵓ-ⵔⴻⴱⵄⵉⵏ ⴰⵍⴰⴼ ⵓ-ⴰⵔⴻⴱⵄⴰ-ⵎⵢⴰ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","ⵉⵏⴰ ⴷ ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵣⴻⴳ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ: ⵙⴻⵜⵜⴰ-ⵎⵢⴰ ⵓ-ⵡⴰⵃⵉⵜ-ⴰⵍⴻⴼ ⵓ-ⵙⴻⴱⵄⴰ-ⵎⵢⴰ ⵓ-ⵜⵍⴰⵜⵉⵏ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“ⵊⴰⵔ ⵉⵏⴰ ⴰⴷ ⵜᵉⵜⵜⵡⴰⴱⴹⴰ ⵜⴻⵎⵎⵓⵔⵜ ⴷ ⵍⵡⴰⵔⵜ, ⵄⵍⴰⵃⵙⴰⴱ ⵍⵇⴻⴷⴷ ⵏ ⵉⵙⵎⴰⵡⴻⵏ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","ⵉ ⵡⴻⵏⵏⵉ ⵓⵎⵉ ⵖⴰⵔ ⵉⴵⴰ ⴰⵟⵟⴰⵙ ⵏ ⵉⵡⴷⴰⵏ, ⴰⴷ ⵜⴻⵡⵛⴻⴷ ⴽⵜⴰⵔ ⴷ ⵍⵡⴰⵔⵜ ⵓⵛⴰ ⵉ ⵡⴻⵏⵏⵉ ⵓⵎⵉ ⵖⴰⵔ ⵉⴵⴰ ⴷⵔⵓⵙ ⵏ ⵉⵡⴷⴰⵏ, ⴰⴷ ⵜⴻⵡⵛⴻⴷ ⵇⴻⵍⵍ ⴷ ⵍⵡⴰⵔⵜ. ⴽⵓⵍ ⵉⵊⵊⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⴰⴷ ⴰⵙ ⵜⴻⵎⵎⴻⵡⵛ ⵜⴰⵙⵖⴰⵔⵜ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","ⵜⴰⵎⵎⵓⵔⵜ ⴰⴷ ⵜᵉⵜⵜⵡⴰⴱⴹⴰ ⵙ ⵜⵇⴻⴷⴷⵓⵃⵜ. ⵏⵉⵜⵏⵉ ⴰⴷ ⵡⴰⵔⵜⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵉⵙⵎⴰⵡⴻⵏ ⵏ ⵜⵇⴻⴱⴱⴰⵍ ⵏ ⵍⴻⵊⴷⵓⴷ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","ⴰⴷ ⵜᵉⵜⵜⵡⴰⴱⴹⴰ ⵜⴻⵙⵖⴰⵔⵜ ⵏ ⴽⵓⵍ ⵉⵊⵊ ⵙ ⵜⵇⴻⴷⴷⵓⵃⵜ ⵊⴰⵔ ⵉⵏⵏⵉ ⵉⴵⴰⵏ ⵙ ⵡⴰⵟⵟⴰⵙ ⴷ ⵉⵏⵏⵉ ⵉⴵⴰⵏ ⴷⵔⵓⵙ.” ");
INSERT INTO rift_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵣⵉ ⵍⴰⵡⵉ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴰⴵⴰⵜ ⵏⵙⴻⵏ: ⵣⵉ ⵊⴰⵔⵛⵓⵏ ⵍⴰⴵ ⵏ ⵉⵊⴰⵔⵛⵓⵏⵉⵢⵢⴻⵏ, ⵣⵉ ⵇⴰⵀⴰⵜ ⵍⴰⴵ ⵏ ⵉⵇⴰⵀⴰⵜⵉⵢⵢⴻⵏ, ⵣⵉ ⵎⴰⵔⴰⵔⵉ ⵍⴰⴵ ⵏ ⵉⵎⴰⵔⴰⵔⵉⵢⵢⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","ⵜⵓⵖⴰ ⵜⵉⵏⴰ ⴷ ⵍⴰⴵⴰⵜ ⵏ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ: ⵍⴰⴵ ⵏ ⵉⵍⵉⴱⵏⵉⵢⵢⴻⵏ, ⵍⴰⴵ ⵏ ⵉⵃⵉⴱⵔⵓⵏⵉⵢⵢⴻⵏ, ⵍⴰⴵ ⵏ ⵉⵎⴰⵀⵍⵉⵢⵢⴻⵏ, ⵍⴰⴵ ⵏ ⵉⵎⵓⵛⵉⵢⵢⴻⵏ, ⵍⴰⴵ ⵏ ⵉⵇⵓⵔⴰⵃⵉⵢⵢⴻⵏ. ⵓⵛⴰ ⵇⴰⵀⴰⵜ ⵢⴻⵊⵊ-ⴷⴷ ⵄⴰⵎⵔⴰⵎ. ");
INSERT INTO rift_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","ⵜⴰⵎⵖⴰⵔⵜ ⵏ ⵄⴰⵎⵔⴰⵎ ⵇⵇⴰⵔⴻⵏⵜ ⴰⵙ ⵊⵓⴽⴰⴱⴰⴷ, ⵢⴻⴵⵉⵙ ⵏ ⵍⴰⵡⵉ, ⵜⴻⵏⵏⵉ ⴷⴷ-ⵉⵜⵜⵡⴰⵔⵡⴻⵏ ⵉ ⵍⴰⵡⵉ ⴷⵉ ⵎⵉⵚⵔⴰ. ⴷ ⵏⴻⵜⵜⴰⵜ ⵜⵓⵔⵓⵡ-ⴷⴷ ⵀⴰⵔⵓⵏ ⴷ ⵎⵓⵙⴰ ⴷ ⵎⴰⵔⵢⴰⵎ, ⵓⵍⵜⵎⴰⵜⵙⴻⵏ, ⵉ ⵄⴰⵎⵔⴰⵎ. ");
INSERT INTO rift_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","ⵉ ⵀⴰⵔⵓⵏ ⵜⵜⵡⴰⵔⵡⴻⵏ ⴰⵙ-ⴷⴷ ⵏⴰⴷⴰⴱ ⴷ ⴰⴱⵉⵀⵓ, ⴰⵍⵉⵄⴰⵣⴰⵔ ⴷ ⵉⵜⴰⵎⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","ⵎⴰⵛⴰ ⵏⴰⴷⴰⴱ ⴷ ⴰⴱⵉⵀⵓ ⵎⵎⵓⵜⴻⵏ, ⵓⵎⵉ ⴷⴷ-ⵉⵡⵢⴻⵏ ⵜⵉⵎⴻⵙⵙⵉ ⵜⴰⵖⵔⵉⴱⵜ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","ⵉⵏⵏⵉ ⵣⵣⴰⵢⵙⴻⵏ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ, ⵣⴻⴳ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ, ⵎⴰⵔⵔⴰ ⵉⵡⴻⵜⵎⴰⵏ ⵏ ⵉⵊⵊ ⵏ ⵓⵢⵓⵔ ⵙⴻⵏⵏⴻⵊ, ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷⵉ ⵜⵍⴰⵜⴰ ⵓ-ⵄⵉⵛⵔⵉⵏ-ⴰⵍⴻⴼ. ⵉⵏⴰ ⵎⴰⵛⴰ ⵡⴰⵔ ⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵛⴰ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵎⵉⵏⵣⵉ ⵡⴰⵔ ⴷ ⴰⵙⴻⵏ ⵜⴻⵎⵎⴻⵡⵛ ⵜⴻⵙⵖⴰⵔⵜ ⴷ ⵍⵡⴰⵔⵜ ⵊⴰⵔ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","ⵉⵏⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏ ⴷ ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵙ ⵓⴼⵓⵙ ⵏ ⵎⵓⵙⴰ ⴷ ⴰⵍⵉⵄⴰⵣⴰⵔ, ⴰⴽⴻⵀⵀⴰⵏ. ⵏⵉⵜⵏⵉ ⵃⴻⵙⴱⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴷⵉ ⵍⴻⵡⴹⴰⵜ ⵏ ⵎⵓ’ⴰⴱ, ⵖⴰⵔ ⵍ’ⵓⵔⴷⵓⵏ ⴰⵔⴻⵏⴷⴰⴷ ⵏ ⴰⵔⵉⵃⴰ. ");
INSERT INTO rift_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","ⵡⴰⵔ ⵜⵓⵖⵉ ⵊⴰⵔ ⴰⵙⴻⵏ ⵓⵍⴰ ⴷ ⵉⵊⵊ ⵣⴻⴳ ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵃⴻⵙⴱⴻⵏ ⵏ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ, ⴰⴽⴻⵀⵀⴰⵏ, ⵓⵎⵉ ⵃⴻⵙⴱⴻⵏ ⵏⵉⵜⵏⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴷⵉ ⵍⴻⵅⵍⴰ ⵏ ⵙⵉⵏⴰ. ");
INSERT INTO rift_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","ⵎⵉⵏⵣⵉ ⵅⴰⵙⴻⵏ ⵜⵓⵖⴰ ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⴰⴷ ⵎⵎⵜⴻⵏ ⵙ ⵜⵉⴷⴻⵜⵜ ⴷⵉ ⵍⴻⵅⵍⴰ. ⵡⴰⵔ ⵣⵣⴰⵢⵙⴻⵏ ⵉⵇⵇⵉⵎ ⵓⵍⴰ ⴷ ⵉⵊⵊ, ⵎⵖⵉⵔ ⴽⴰⵍⵉⴱ, ⵎⵎⵉⵙ ⵏ ⵢⴰⴼⵓⵏⵏⵉ, ⴷ ⵢⴰⵛⵓⵡⴰ, ⵎⵎⵉⵙ ⵏ ⵏⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","ⵅⴻⵏⵏⵉ ⵓⵙⵉⵏⵜ-ⵉ-ⴷⴷ ⵢⴻⵙⵙⵉⵙ ⵏ ⵚⴰⵍⵓⴼⵃⴰⴷ, ⵎⵎⵉⵙ ⵏ ⵃⴰⴼⴰⵔ, ⵎⵎⵉⵙ ⵏ ⵊⵉⵍⵄⴰⴷ, ⵎⵎⵉⵙ ⵏ ⵎⴰⴽⵉⵔ, ⵎⵎⵉⵙ ⵏ ⵎⴰⵏⴰⵙⵙⴰ, ⵉⵏⵏⵉ ⵉⴵⴰⵏ ⵏ ⵍⴰⴵⴰⵜ ⵏ ⵎⴰⵏⴰⵙⵙⴰ, ⵎⵎⵉⵙ ⵏ ⵢⵓⵙⵓⴼ. ⵉⵏⴰ ⴷ ⵉⵙⵎⴰⵡⴻⵏ ⵏ ⵢⴻⵙⵙⵉⵙ: ⵎⴰⵃⵍⴰ, ⵏⵓⵄⴰ, ⵃⵓⵊⵍⴰ, ⵎⵉⵍⴽⴰ ⴷ ⵜⵉⵔⵚⴰ. ");
INSERT INTO rift_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","ⵜⵓⵖⴰ ⴱⴻⴷⴷⴻⵏⵜ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵎⵓⵙⴰ ⵓ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⴰⵍⵉⵄⴰⵣⴰⵔ, ⴰⴽⴻⵀⵀⴰⵏ, ⵓ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵍⵃⵓⴽⴽⴰⵎ ⵓ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⵖⴰⵔ ⵡⴰⴷⴰⴼ ⵏ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ⵏⵏⴰⵏⵜ: ");
INSERT INTO rift_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“ⴱⴰⴱⴰⵜⵏⴻⵖ ⵉⵎⵎⵓⵜ ⴷⵉ ⵍⴻⵅⵍⴰ ⵓ ⵡⴰⵔ ⵜ ⵜⵓⵖⵉ ⵊⴰⵔ ⵓⴱⴰⵔⵔⵓ ⵏ ⵢⵉⵏⵏⵉ ⵉⵎⵓⵏⴻⵏ ⴹⵉⴷⴷ ⵉ ⵙⵉⴷⵉ, ⴷⴻⴳ ⵓⴱⴰⵔⵔⵓ ⵏ ⵇⵓⵔⴰⵃ ⵡⴰⵔ ⴷⵉⵏ ⵜ ⵜⵓⵖⵉ ⵏⴻⵜⵜⴰ, ⵎⵉⵏⵣⵉ ⵉⵎⵎⵓⵜ ⴷⵉ ⴷⴷⵏⵓⴱ ⵏⵏⴻⵙ ⵓ ⵡⴰⵔ ⵖⴰⵔⴻⵙ ⵜⵓⵖⵉ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ.    ");
INSERT INTO rift_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","ⵎⴰⵢⴻⵎⵎⵉ ⵖⴰ ⵉⴽⴽⴻⵙ ⵉⵙⴻⵎ ⵏ ⴱⴰⴱⴰⵜⵏⴻⵖ ⵣⵉ ⵊⴰⵔ ⵍⴰⴵ ⵏⵏⴻⵙ, ⵎⴰ ⵎⵉⵏⵣⵉ ⵡⴰⵔ ⵖⴰⵔⴻⵙ ⵜⵓⵖⵉ ⴱⵓ ⵓⵃⴻⵏⵊⵉⵔ? ⴻⵡⵛ ⴰⵏⴻⵖ ⴰⴳⵍⴰ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏ ⴰⵢⵜⵎⴰⵙ ⵏ ⴱⴰⴱⴰⵜⵏⴻⵖ.” ");
INSERT INTO rift_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","ⵎⵓⵙⴰ ⵢⵉⵡⵉ ⴷⴷⴻⵄⵡⴰ ⵏⵙⴻⵏⵜ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“ⴰⵇⴰ ⴰⵢⴰ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜ ⵏⵏⴰⵏⵜ ⵢⴻⵙⵙⵉⵙ ⵏ ⵚⴰⵍⵓⴼⵃⴰⴷ. ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⴰⵙⴻⵏⵜ ⵜⴻⵡⵛⴻⴷ ⵜⴰⵙⵖⴰⵔⵜ ⵏ ⵍⵡⴰⵔⵜ ⴷⵉ  ⵍⵡⴻⵙⵜ ⵏ ⴰⵢⵜⵎⴰⵙ ⵏ ⴱⴰⴱⴰⵜⵙⴻⵏ ⵓⵛⴰ ⴰⴷ ⵅⴰⵙⴻⵏⵜ ⵜⴻⵙⵙⴻⵄⴷⵓⴷ ⵍⵡⴰⵔⵜ ⵏ ⴱⴰⴱⴰⵜⵙⴻⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","ⵓⵛⴰ ⴰⴷ ⵜⴻⵙⵙⵉⵡⵍⴻⴷ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⴰⴷ ⵜⵉⵏⵉⴷ: ‘ⵎⴰⵍⴰ ⵛⴰ ⵏ ⵢⵉⵊⵊⴻⵏ ⵉⵎⵎⵓⵜ ⴱⵍⴰ ⵎⵎⵉⵙ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⴻⵙⵙⴻⵄⴷⵓⵎ ⵍⵡⴰⵔⵜ ⵏⵏⴻⵙ ⵖⴰⵔ ⵢⴻⴵⵉⵙ, ");
INSERT INTO rift_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","ⵓ ⵎⴰⵍⴰ ⵡⴰⵔ ⵖⴰⵔⴻⵙ ⵢⴻⴵⵉⵙ, ⴰⴷ ⵜⴻⵡⵛⴻⵎ ⵍⵡⴰⵔⵜ ⵏⵏⴻⵙ ⵉ ⵢⴰⵢⵜⵎⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","ⵎⴰⵍⴰ ⵡⴰⵔ ⵖⴰⵔⴻⵙ ⴰⵢⵜⵎⴰⵙ ⵄⴰⵡⴻⴷ, ⴰⴷ ⵜⴻⵡⵛⴻⵎ ⵍⵡⴰⵔⵜ ⵏⵏⴻⵙ ⵉ ⵢⴰⵢⵜⵎⴰⵙ ⵏ ⴱⴰⴱⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","ⵎⴰⵍⴰ ⴱⴰⴱⴰⵙ ⵡⴰⵔ ⵖⴰⵔⴻⵙ ⴰⵢⵜⵎⴰⵙ ⵄⴰⵡⴻⴷ, ⴰⴷ ⵜⴻⵡⵛⴻⵎ ⵍⵡⴰⵔⵜ ⵏⵏⴻⵙ ⵉ ⵔⴰⴵ ⵏⵏⴻⵙ, ⵉ ⵡⴻⵏⵏⵉ ⵉ ⴷ ⴰⵙ ⴷⴷ-ⵢⵓⴷⵙⴻⵏ ⵣⵉ ⵍⴰⴵ ⵏⵏⴻⵙ, ⵃⵉⵎⴰ ⴰⴷ ⵜⵜ ⵉⵡⴰⵔⵜ ⵏⴻⵜⵜⴰ.’ ⵎⴰⵏ ⴰⵢⴰ ⴰⴷ ⵜⵉⵍⵉ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵚⴻⵢⵢⴻⵜ ⵏ ⵓⵣⴻⵔⴼ ⵉ ⵍⴻⴱⴷⴰ ⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ.” ");
INSERT INTO rift_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⴳⴻⵄⵄⴻⴷ-ⴷⴷ ⴰⴷⵔⴰⵔ-ⴰ ⴰⴱⴰⵔⵉⵎ ⵓⵛⴰ ⵅⵣⴰⵔ ⵜⴰⵎⵎⵓⵔⵜ ⵏⵏⵉ ⵡⵛⵉⵖ ⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","ⵅⵎⵉ ⵜⵜ ⵖⴰ ⵜⵥⴰⵔⴻⴷ, ⴰⴷ ⵜᵉⵎⵎⴰⵔⵏⵉⴷ ⵖⴰⵔ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵛ, ⵓⵍⴰ ⴷ ⵛⴻⴽ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵓⵍⴰ ⴷ ⵓⵎⴰⵛ ⵀⴰⵔⵓⵏ ⵉⵎⵎⴰⵔⵏⵉ ⵖⴰⵔ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵙ, ");
INSERT INTO rift_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","ⵎⵉⵏⵣⵉ ⴽⴻⵏⵏⵉⵡ ⵜⵖⴻⵡⵡⵖⴻⵎ ⵣⵣⴰⵜ ⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵙⴻⵏ ⴹⵉⴷⴷ ⵉ ⵍⵓⵎⵓⵔ ⵉⵏⵓ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴰⵢⵉ ⵜⴻⵙⵙⵇⴻⴷⴷⵙⴻⵎ ⴷⵉ ⵍⴻⵅⵍⴰ ⵏ ⵚⵉⵏ, ⵍⴰⵎⵉ ⴷⵉⵏ ⵜⵓⵖⴰ ⴰⵎⵛⵓⴱⴱⴻⵛ ⴷⵉ ⵜⵎⴻⵙⵎⵓⵏⵜ. ⴰⵇⴰ ⴷ ⵉⵏⴰ ⴷ ⴰⵎⴰⵏ ⵏ ⵎⴰⵔⵉⴱⴰ, ⵖⴰⵔ ⵇⴰⴷⴰⵛ ⴷⵉ ⵍⴻⵅⵍⴰ ⵏ ⵚⵉⵏ.” ");
INSERT INTO rift_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","ⵉⵙⵙⵉⵡⴻⵍ ⵎⵓⵙⴰ ⴰⴽ-ⴷ ⵙⵉⴷⵉ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“ⴰⴷ ⵉⴳⴳ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏ ⴱⵓⵃⴱⴻⵍⴰⵜ ⵏ ⵎⴰⵔⵔⴰ ⴷⴷⴰⵜ, ⴰⵃⴻⵟⵟⵓ ⵅ ⵜⵎⴻⵙⵎⵓⵏⵜ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ, ");
INSERT INTO rift_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","ⵃⵉⵎⴰ ⵏⴻⵜⵜⴰ ⴰⴷ ⵉⴼⴼⴻⵖ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏⵙⴻⵏ ⵓⵛⴰ ⴰⴷ ⵢⴰⴷⴻⴼ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏⵙⴻⵏ ⵓⵛⴰ ⴰⴷ ⵜⴻⵏ ⵉⵏⴷⴻⵀ ⵖⴰⵔ ⴱⴰⵔⵔⴰ, ⴰⴷ ⵜⴻⵏ ⵉⵙⵙⵉⴷⴻⴼ ⵖⴰⵔ ⴷⴰⵅⴻⵍ, ⵎⴰⵃⴻⵏⴷ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⵏ ⵙⵉⴷⵉ ⵡⴰⵔ ⵜᵉⵜⵜⵉⵍⵉ ⴰⵎ ⵡⵓⴵⵉ ⴱⵍⴰ ⴰⵎⴻⴽⵙⴰⵡ.”    ");
INSERT INTO rift_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: “ⴽⵙⵉ ⵢⴰⵛⵓⵡⴰ, ⵎⵎⵉⵙ ⵏ ⵏⵓⵏ, ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵉ ⴷⵉ ⵉⴵⴰ ⴰⵔⵔⵓⵃ, ⵓⵛⴰ ⵙⴰⵔⵙ ⵅⴰⵙ ⴰⴼⵓⵙ ⵏⵏⴻⵛ ");
INSERT INTO rift_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","ⵓⵛⴰ ⴰⴷ ⵜ ⵜⴻⴳⴳⴻⴷ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵓⴽⴻⵀⵀⴰⵏ ⴰⵍⵉⵄⴰⵣⴰⵔ ⵓ ⵣⵣⴰⵜ ⵉ ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ, ⴰⴷ ⴰⵙ ⵜⴻⵡⵛⴻⴷ ⵍⵓⵎⵓⵔ ⵣⵣⴰⵜ ⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","ⴻⵡⵛ ⴰⵙ ⵛⴰ ⵣⴻⴳ ⵓⵡⴻⵇⵇⴰⵔ ⵏⵏⴻⵛ ⵃⵉⵎⴰ ⴰⴷ ⴰⵙ ⵜⵙⴻⵍ ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","ⵏⴻⵜⵜⴰ ⴰⴷ ⵉⴱⴻⴷⴷ ⵣⵣⴰⵜ ⵉ ⵓⴽⴻⵀⵀⴰⵏ ⴰⵍⵉⵄⴰⵣⴰⵔ, ⵡⴻⵏⵏⵉ ⵉ ⵖⴰ ⵉⵛⴰⵡⴰⵔ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴻⵃⴽⴰⵎ ⵏ ⵓⵔⵉⵎ. ⵅ ⵍⵓⵎⵓⵔ ⵏⵏⴻⵙ ⴰⴷ ⴷⴷ-ⴼⴼⵖⴻⵏ ⵖⴰⵔ ⴱⴰⵔⵔⴰ ⵓ ⵅ ⵍⵓⵎⵓⵔ ⵏⵏⴻⵙ ⴰⴷ ⴰⴷⴼⴻⵏ ⵖⴰⵔ ⴷⴰⵅⴻⵍ, ⵏⴻⵜⵜⴰ ⴷ ⵎⴰⵔⵔⴰ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵍⴰ ⴷ ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ.” ");
INSERT INTO rift_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","ⵓⵛⴰ ⵎⵓⵙⴰ ⵉⴳⴳⴰ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵙ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ. ⵢⵉⵡⵉ ⵢⴰⵛⵓⵡⴰ ⵓⵛⴰ ⵉⵙⵙⴱⴻⴷⴷ ⵉ-ⵜ ⵣⵣⴰⵜ ⵉ ⵓⴽⴻⵀⵀⴰⵏ ⴰⵍⵉⵄⴰⵣⴰⵔ ⵓ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","ⵉⵙⵙⴰⵔⵙ ⵅⴰⵙ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⵙⵙⴻⵄⴷⵓ ⴰⵙ ⵍⵓⵎⵓⵔ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵙ ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵙ ⵜⵙⴻⵅⵅⴰⵔⵜ ⵏ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“ⵓⵎⵓⵔ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵉⵏⵉ ⴰⵙⴻⵏ: ‘ⵉⵜⵜⵅⴻⵚⵚⴰ ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⵜⴻⵃⴹⴰⵎ ⵅ ⵜⵖⴰⵔⵚⵟ ⵉⵏⵓ, ⵎⴰⵛⵛⴰ ⵉⵏⵓ ⵉ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵉⵏⵓ ⵏ ⵜⵎⴻⵙⵙⵉ, ⵉⵛⵜ ⵏ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵉⵜⵜⴼⵓⵃⴻⵏ ⵉ ⵏⴻⵛⵛ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴰⵢⵉ ⵜⴻⵏⵜ ⵜⵇⴻⴷⴷⵎⴻⵎ ⴷⵉ ⵍⵡⴻⵇⵜ ⵏⵏⴻⵙ ⵉⵜⵜⵡⴰⴳⴳⴻⵏ.’ ");
INSERT INTO rift_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","ⴰⴷ ⴰⵙⴻⵏ ⵜⵉⵏⵉⴷ: ‘ⴰⵇⴰ ⵜⴰ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ ⵉ ⵉⵜⵜⵅⴻⵚⵚⴰⵏ ⴰⴷ ⵜⵇⴻⴷⴷⵎⴻⵎ: ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵣⵎⴰⵔⴻⵏ ⵉⵛⵏⴰⵏ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ, ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵍⴻⴱⴷⴰ. ");
INSERT INTO rift_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","ⵉⵊⵊ ⵏ ⵉⵣⵎⴰⵔ ⴰⴷ ⵜ ⵜⴻⵙⵙⵡⴻⵊⴷⴻⴷ ⴷⵉ ⵚⵚⴱⴻⵃ ⵓⵛⴰ ⵉⵣⵎⴰⵔ ⵏⵏⴻⵖⵏⵉ ⴰⴷ ⵜ ⵜⴻⵙⵙⵡⴻⵊⴷⴻⴷ ⵊⴰⵔ ⴱⴻⴷⴷⵓ ⵏ ⵡⴻⵣⵢⴻⵏ ⵏ ⵡⴰⵙⵙ ⴰⵍ ⴷⴷ-ⵜⴻⵡⴹⴰ ⵜⵎⴻⴷⴷⵉⵜ ");
INSERT INTO rift_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","ⵓⵛⴰ ⴰⴽ-ⴷ ⵎⴰⵏ ⴰⵢⴰ ⴰⵎ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵉⵛⵜ ⵏ ⵜⴻⵄⵛⴰⵔⵜ ⵏ ⵢⵉⵊⵊ ⵏ ⵉⴼⴰ ⵏ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵅⴻⴵⴹⴻⵏ ⵙ ⵢⵉⵊⵊ ⵏ ⴰⵔⴱⴻⵄ ⵏ ⵉⵊⵊ ⵏ ⵓⵀⵉⵏⵓ ⵏ ⵣⵣⴻⵛⵜ, ⵜⵜⵡⴰⴷⴷⵣⴻⵏ ⵜ-ⵉ-ⴷⴷ ⵣⵉ ⵣⵣⵉⵜⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","ⴰⵇⴰ-ⵜⵜ ⴷ ⵜⴰⵖⴰⵔⵚⵟ ⵏ ⵡⴻⵛⵎⴰⴹ ⵏ ⵍⴻⴱⴷⴰ, ⵜⴻⵏⵏⵉ ⵜⵓⵖⴰ ⵉⵜⵜⵡⴰⴳⴳⴻⵏ ⴷⴻⴳ ⵡⴻⴷⵔⴰⵔ ⵏ ⵙⵉⵏⴰ ⴰⵎ ⵢⵉⵛⵜ ⵏ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵉⵜⵜⴼⵓⵃⴻⵏ, ⴰⵇⴰ-ⵜⵜ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","ⵜⴰⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵏ ⵓⵙⴻⵢⵢⴻⴱ ⴰⴷ ⵜⵉⵍⵉ ⴷ ⵉⵊⵊ ⵏ ⴰⵔⴱⴻⵄ ⵏ ⵉⵊⵊ ⵏ ⵓⵀⵉⵏⵓ ⵉ ⵢⵉⵊⵊ ⵏ ⵉⵣⵎⴰⵔ. ⵙⴻⵢⵢⴻⴱ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵓⵙⴻⵢⵢⴻⴱ ⵏ ⵛⵛⵔⴰⴱ ⴷⵉ ⵣⵣⴰⵡⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵣⵣⴰⵜ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","ⴰⴷ ⵜⴻⵙⵙⵡⴻⵊⴷⴻⴷ ⵉⵣⵎⴰⵔ ⵏⵏⴻⵖⵏⵉ ⵊⴰⵔ ⴱⴻⴷⴷⵓ ⵏ ⵡⴻⵣⵢⴻⵏ ⵏ ⵡⴰⵙⵙ ⴰⵍ ⴷⴷ-ⵜⴻⵡⴹⴰ ⵜⵎⴻⴷⴷⵉⵜ. ⴰⴷ ⵜ ⵜⴻⵙⵙⵡⴻⵊⴷⴻⴷ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⴻⵙⵙⵡⴻⵊⴷⴻⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⴷⵉ ⵚⵚⴱⴻⵃ ⵓ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⴻⵙⵙⵡⴻⵊⴷⴻⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵓⵙⴻⵢⵢⴻⴱ ⵏⵏⴻⵙ, ⴰⵎ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ, ⵉⵛⵜ ⵏ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵉⵜⵜⴼⵓⵃⴻⵏ ⵉ ⵙⵉⴷⵉ.’” ");
INSERT INTO rift_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“ⴷⴻⴳ ⵡⴰⵙⵙ ⵏ ⵙⵙⴻⴱⵜ ⴰⴷ ⵜⴻⵙⵙⵡⴻⵊⴷⴻⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵣⵎⴰⵔⴻⵏ ⵉⵛⵏⴰⵏ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵄⵛⵓⵔⵉⵏ ⵏ ⵢⵉⵊⵊ ⵏ ⵉⴼⴰ ⵏ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⴰⵎ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵉⵅⴻⴵⴹⴻⵏ ⵙ ⵣⵣⴻⵛⵜ ⴰⴽ-ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵏ ⵓⵙⴻⵢⵢⴻⴱ. ");
INSERT INTO rift_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","ⴰⵇⴰ-ⵜⵜ ⴷ ⵜⴰⵖⴰⵔⵚⵟ ⵏ ⵡⴻⵛⵎⴰⴹ ⵏ ⵙⵙⴻⴱⵜ ⵉ ⵎⴽⵓⵍ ⵙⵙⴻⴱⵜ, ⴰⴷ ⵜⵜ ⵜⴰⵔⵏⵉⴷ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵏ ⵍⴻⴱⴷⴰ ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵏ ⵓⵙⴻⵢⵢⴻⴱ.” ");
INSERT INTO rift_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“ⴷⴻⴳ ⵓⵎⴻⵣⵡⴰⵔ ⵏ ⴽⵓⵍ ⵉⵊⵊ ⵏ ⵉⵢⵓⵔⴻⵏ ⵏⵡⴻⵎ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜⵇⴻⴷⴷⵎⴻⵎ ⵉⵛⵜ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵉ ⵙⵉⴷⵉ: ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⴼⵓⵏⴰⵙⴻⵏ - ⵉⵎⴻⵥⵢⴰⵏⴻⵏ ⵏ ⵉⵛⵜ ⵏ ⵜⴼⵓⵏⴰⵙⵜ - ⵉⵊⵊ ⵏ ⵉⵛⴰⵔⵔⵉ, ⵙⴻⴱⵄⴰ ⵏ ⵉⵣⵎⴰⵔⴻⵏ ⵉⵛⵏⴰⵏ ⵇⴰⵄ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ ");
INSERT INTO rift_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","ⵓⵛⴰ ⴰⴽ-ⴷ ⵎⴰⵏ ⴰⵢⴰ ⵜⵍⴰⵜⴰ ⵏ ⵜⴻⵄⵛⵓⵔⵉⵏ ⵏ ⵉⵊⵊ ⵏ ⵉⴼⴰ ⵏ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⴰⵎ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵉⵅⴻⴵⴹⴻⵏ ⵙ ⵣⵣⴻⵛⵜ ⵉ ⵢⵉⵊⵊ ⵏ ⵓⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ ⵓ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵄⵛⵓⵔⵉⵏ ⵏ ⵢⵉⵊⵊ ⵏ ⵉⴼⴰ ⵏ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⴰⵎ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵉⵅⴻⴵⴹⴻⵏ ⵙ ⵣⵣⴻⵛⵜ ⵉ ⵢⵉⵊⵊ ⵏ ⵉⵛⴰⵔⵔⵉ ");
INSERT INTO rift_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","ⵓⵛⴰ ⴰⵔⵏⵉ ⵉⵛⵜ ⵏ ⵜⴻⵄⵛⴰⵔⵜ ⵏ ⵢⵉⵊⵊ ⵏ ⵉⴼⴰ ⵏ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⴰⵎ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵉⵅⴻⴵⴹⴻⵏ ⵙ ⵣⵣⴻⵛⵜ ⵉ ⵢⵉⵊⵊ ⵏ ⵉⵣⵎⴰⵔ. ⴰⵇⴰ-ⵜⵜ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵙ ⵉⵛⵜ ⵏ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵉⵜⵜⴼⵓⵃⴻⵏ, ⴰⵇⴰ-ⵜⵜ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","ⵜⵉⵡⵀⵉⴱⵉⵏ ⵏⵙⴻⵏ ⵏ ⵓⵙⴻⵢⵢⴻⴱ ⴰⴷ ⵉⵍⵉⵏⵜ ⴷ ⴰⵣⵢⴻⵏ ⵏ ⵓⵀⵉⵏⵓ ⵏ ⴱⵉⵏⵓ ⴰⴽ-ⴷ ⵓⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ ⴷ ⵉⵛⵜ ⵏ ⵜⵜⵓⵍⵓⵜ ⵏ ⵉⵊⵊ ⵏ ⵓⵀⵉⵏⵓ ⴰⴽ-ⴷ ⵉⵛⴰⵔⵔⵉ ⴷ ⵢⵉⵊⵊ ⵏ ⴰⵔⴱⴻⵄ ⵏ ⵉⵊⵊ ⵏ ⵓⵀⵉⵏⵓ ⴰⴽ-ⴷ ⵉⵣⵎⴰⵔ. ⵜⴰ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵏ ⴽⵓⵍ ⴰⵢⵓⵔ, ⵉ ⴽⵓⵍ ⴰⵢⵓⵔ ⵣⴻⴳ ⵉⵢⵓⵔⴻⵏ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜⴻⵙⵙⵡⴻⵊⴷⴻⴷ ⵉⵊⵊ ⵏ ⵓⵎⵢⴰⵏ ⵣⴻⴳ ⵉⵖⴰⵢⴹⴻⵏ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⵉ ⵙⵉⴷⵉ, ⴰⴷ ⵜⵜ ⵜⴰⵔⵏⵉⴷ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵏ ⵍⴻⴱⴷⴰ ⴰⴽ-ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵏ ⵓⵙⴻⵢⵢⴻⴱ.” ");
INSERT INTO rift_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","ⴷⴻⴳ ⵓⵢⵓⵔ ⴰⵎⴻⵣⵡⴰⵔⵓ, ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⴰⵔⴱⴻⵄⵟⴰⵛ ⵏ ⵓⵢⵓⵔ, ⴰⴷ ⵜⵉⵍⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵓⵙⴻⵄⴷⵓ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵅⴻⵎⵎⴻⵙⵟⴰⵛ ⵏ ⵙⵉⵎⴰⵏⵜ ⵏ ⵓⵢⵓⵔ ⴰⴷ ⵢⵉⵍⵉ ⵍⵄⵉⴷ. ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⴰⴷ ⵛⵛⴻⵏ ⴰⵖⵔⵓⵎ ⴱⵍⴰ ⴰⵏⵜⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","ⴷⴻⴳ ⵡⴰⵙⵙ ⴰⵎⴻⵣⵡⴰⵔⵓ ⵏ ⵍⵄⵉⴷ ⴰⴷ ⵢⵉⵍⵉ ⵢⵉⵊⵊ ⵏ ⵓⵎⵓⵏⵉ ⵉⵇⴻⴷⴷⵙⴻⵏ. ⵡⴰⵔ ⵜⵜⴻⴳⴳⴻⵎ ⵓⵍⴰ ⴷ ⵉⵛⵜ ⵍⵅⴻⴷⵎⴻⵜ ⵉ ⵉⵜⵜⵅⴻⵚⵚⴰⵏ ⴰⴷ ⵜᵉⵜⵜⵡⴰⴳⴳ. ");
INSERT INTO rift_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","ⴰⴷ ⵜⵇⴻⴷⴷⵎⴻⵎ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵉ ⵙⵉⴷⵉ: ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⴼⵓⵏⴰⵙⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⴻⵏ ⴷ ⵉⵊⵊ ⵏ ⵉⵛⴰⵔⵔⵉ ⴷ ⵙⴻⴱⵄⴰ ⵏ ⵉⵣⵎⴰⵔⴻⵏ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ. ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵉⵍⵉⵏ ⵛⵏⴰⵏ ⵇⴰⵄ. ");
INSERT INTO rift_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","ⴰⴷ ⵜⵉⵍⵉ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵏ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵅⴻⴵⴹⴻⵏ ⵙ ⵣⵣⴻⵛⵜ. ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵜⴻⵙⵙⵡⴻⵊⴷⴻⵎ ⵜⵍⴰⵜⴰ ⵏ ⵜⴻⵄⵛⵓⵔⵉⵏ ⵏ ⵢⵉⵊⵊ ⵏ ⵉⴼⴰ ⵉ ⵢⵉⵊⵊ ⵏ ⵓⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵄⵛⵓⵔⵉⵏ ⵏ ⵢⵉⵊⵊ ⵏ ⵉⴼⴰ ⵉ ⵢⵉⵊⵊ ⵏ ⵉⵛⴰⵔⵔⵉ. ");
INSERT INTO rift_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","ⴰⴷ ⵜⴻⵙⵙⵡⴻⵊⴷⴻⴷ ⵉⵛⵜ ⵏ ⵜⴻⵄⵛⴰⵔⵜ ⵏ ⵢⵉⵊⵊ ⵏ ⵉⴼⴰ ⵉ ⵢⵉⵊⵊ ⵏ ⵉⵣⵎⴰⵔ, ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⵎⴰⵔⵔⴰ ⵙⴻⴱⵄⴰ ⵏ ⵉⵣⵎⴰⵔⴻⵏ ⵏⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","ⵙⴻⵡⵊⴻⴷ ⵄⴰⵡⴻⴷ ⵉⵊⵊ ⵏ ⵓⵎⵢⴰⵏ ⵣⴻⴳ ⵉⵖⴰⵢⴹⴻⵏ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⵜⵜⵡⴰⴳⴳ ⵡⴻⵚⵍⴰⵃ ⵉ ⴽⴻⵏⵏⵉⵡ. ");
INSERT INTO rift_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","ⴰⴷ ⵜⴻⵙⵙⵡⴻⵊⴷⴻⵎ ⵎⴰⵏ ⴰⵢⴰ ⵙⴻⵏⵏⴻⵊ ⵉ ⵓⵙⴻⵡⵊⴻⴷ ⵏ ⵜⵖⴰⵔⵚⵜ ⵡⴻⵛⵎⴰⴹ ⴷⵉ ⵚⵚⴱⴻⵃ ⵏⵏⵉ ⵉⴵⴰⵏ ⴷ ⵉⵛⵜ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵉ ⵍⴻⴱⴷⴰ. ");
INSERT INTO rift_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵓⵢⴰ ⴰⴷ ⵜⴻⵙⵙⵡⴻⵊⴷⴻⵎ ⵎⴰⵛⵛⴰ ⵏ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵏ ⵜⵎⴻⵙⵙⵉ ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ, ⴷⵉ ⴽⵓⵍ ⴰⵙⵙ ⵣⵣⴰⵢⵙⴻⵏ, ⴰⵎ ⵉⵛⵜ ⵏ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵉⵜⵜⴼⵓⵃⴻⵏ ⵉ ⵙⵉⴷⵉ. ⴰⴷ ⵉⵜⵜⵡⴰⵙⵙⴻⵡⵊⴻⴷ ⵙⴻⵏⵏⴻⵊ ⵉ ⵓⵙⴻⵡⵊⴻⴷ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵏ ⵍⴻⴱⴷⴰ ⴰⴽ-ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵏ ⵓⵙⴻⵢⵢⴻⴱ. ");
INSERT INTO rift_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ ⴰⴷ ⵜⴻⴳⴳⴻⵎ ⵉⵊⵊ ⵏ ⵓⵎⵓⵏⵉ ⵉⵇⴻⴷⴷⵙⴻⵏ. ⵡⴰⵔ ⵜⵜⴻⴳⴳⴻⵎ ⵓⵍⴰ ⴷ ⵉⵛⵜ ⵍⵅⴻⴷⵎⴻⵜ ⵉ ⵉⵜⵜⵅⴻⵚⵚⴰⵏ ⴰⴷ ⵜᵉⵜⵜⵡⴰⴳⴳ.” ");
INSERT INTO rift_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“ⴷⴻⴳ ⵡⴰⵙⵙ ⵏ ⵜⵎⴻⵏⵣⵓⵜ ⵏ ⵚⵚⴰⴱⴻⵜ ⴷⵉ ⵍⵄⵉⴷ ⵏ ⵙⵙⵉⵎⴰⵏⴰⵜ, ⵅⵎⵉ ⴷⴷ ⵖⴰ ⵜⵇⴻⴷⴷⵎⴻⵎ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵍⵖⵉⴵⴻⵜ ⵏ ⵊⴷⵉⴷ ⵖⴰⵔ ⵙⵉⴷⵉ, ⴰⴷ ⵜⴻⴳⴳⴻⵎ ⵉⵊⵊ ⵏ ⵓⵎⵓⵏⵉ ⵉⵇⴻⴷⴷⵙⴻⵏ. ⵡⴰⵔ ⵜⵜⴻⴳⴳⴻⵎ ⵓⵍⴰ ⴷ ⵉⵛⵜ ⵏ ⵍⵅⴻⴷⵎⴻⵜ ⵉ ⵉⵜⵜⵅⴻⵚⵚⴰⵏ ⴰⴷ ⵜᵉⵜⵜⵡⴰⴳⴳ. ");
INSERT INTO rift_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","ⴰⴷ ⵜⵇⴻⴷⴷⵎⴻⵎ ⵉⵛⵜ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⴰⵎ ⵢⵉⵛⵜ ⵏ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵉⵜⵜⴼⵓⵃⴻⵏ ⵉ ⵙⵉⴷⵉ: ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⴼⵓⵏⴰⵙⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⴻⵏ ⵉ ⵢⵉⵊⵊ ⵏ ⵉⵛⴰⵔⵔⵉ ⴷ ⵙⴻⴱⵄⴰ ⵏ ⵉⵣⵎⴰⵔⴻⵏ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ ");
INSERT INTO rift_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","ⴰⴽ-ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵏ ⵍⵖⵉⴵⴻⵜ ⵏ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵅⴻⴵⴹⴻⵏ ⵙ ⵣⵣⴻⵛⵜ: ⵜⵍⴰⵜⴰ ⵏ ⵜⴻⵄⵛⵓⵔⵉⵏ ⵏ ⵢⵉⵊⵊ ⵏ ⵉⴼⴰ ⵉ ⵢⵉⵊⵊ ⵏ ⵓⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵄⵛⵓⵔⵉⵏ ⵏ ⵢⵉⵊⵊ ⵏ ⵉⴼⴰ ⵉ ⵢⵉⵊⵊ ⵏ ⵉⵛⴰⵔⵔⵉ ");
INSERT INTO rift_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","ⵓⵍⴰ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵄⵛⴰⵔⵜ ⵏ ⵢⵉⵊⵊ ⵏ ⵉⴼⴰ ⵉ ⴽⵓⵍ ⵉⵣⵎⴰⵔ, ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⵎⴰⵔⵔⴰ ⵙⴻⴱⵄⴰ ⵏ ⵉⵣⵎⴰⵔⴻⵏ ⵏⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","ⵙⵡⴻⵊⴷⴻⵎ ⵄⴰⵡⴻⴷ ⵉⵊⵊ ⵏ ⵓⵎⵢⴰⵏ ⵣⴻⴳ ⵉⵖⴰⵢⴹⴻⵏ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⵜⵜⵡⴰⴳⴳ ⵡⴻⵚⵍⴰⵃ ⵉ ⴽⴻⵏⵏⵉⵡ. ");
INSERT INTO rift_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","ⴰⴷ ⵜⴻⵏ ⵜⴻⵙⵙⵡⴻⵊⴷⴻⵎ ⵙⴻⵏⵏⴻⵊ ⵉ ⵓⵙⴻⵡⵊⴻⴷ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵏ ⵍⴻⴱⴷⴰ ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵏ ⵍⵖⵉⴵⴻⵜ. ⴰⴷ ⵉⵍⵉⵏ ⵛⵏⴰⵏ ⵇⴰⵄ ⵉ ⴽⴻⵏⵏⵉⵡ ⴰⴽ-ⴷ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵏⵙⴻⵏ ⵏ ⵓⵙⴻⵢⵢⴻⴱ.” ");
INSERT INTO rift_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“ⴷⴻⴳ ⵓⵢⵓⵔ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ, ⴷⴻⴳ ⵡⴰⵙⵙ ⴰⵎⴻⵣⵡⴰⵔⵓ ⵏ ⵓⵢⵓⵔ, ⴰⴷ ⵜⴻⴳⴳⴻⵎ ⵉⵊⵊ ⵏ ⵓⵎⵓⵏⵉ ⵉⵇⴻⴷⴷⵙⴻⵏ. ⵡⴰⵔ ⵜⵜⴻⴳⴳⴻⵎ ⵓⵍⴰ ⴷ ⵉⵛⵜ ⵏ ⵍⵅⴻⴷⵎⴻⵜ ⵉ ⵉⵜⵜⵅⴻⵚⵚⴰⵏ ⴰⴷ ⵜᵉⵜⵜⵡⴰⴳⴳ. ⴰⴷ ⴰⵡⴻⵎ ⵢⵉⵍⵉ ⴷ ⵉⵊⵊ ⵏ ⵡⴰⵙⵙ ⵏ ⵓⵙⵓⴹⵉ ⵙ ⵡⴻⵙⵔⵓⴷⴷⴻⵃ ⴷⴻⴳ ⵓⵢⵉⵛⵛ ⵏ ⵉⵛⴰⵔⵔⵉ. ");
INSERT INTO rift_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","ⴰⴷ ⵜⴻⵙⵙⵡⴻⵊⴷⴻⵎ ⵉⵛⵜ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⴰⵎ ⵢⵉⵛⵜ ⵏ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵉⵜⵜⴼⵓⵃⴻⵏ ⵉ ⵙⵉⴷⵉ: ⵉⵊⵊ ⵏ ⵓⴼⵓⵏⴰⵙ - ⴰⵎⴻⵥⵢⴰⵏ ⵏ ⵉⵛⵜ ⵏ ⵜⴼⵓⵏⴰⵙⵜ - ⴷ ⵢⵉⵊⵊ ⵏ ⵉⵛⴰⵔⵔⵉ ⴷ ⵙⴻⴱⵄⴰ ⵏ ⵉⵣⵎⴰⵔⴻⵏ ⵉⵛⵏⴰⵏ ⵇⴰⵄ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ ");
INSERT INTO rift_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","ⴰⴽ-ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵙⴻⵏ ⵏ ⵍⵖⵉⴵⴻⵜ ⵣⴻⴳ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵅⴻⴵⴹⴻⵏ ⵙ ⵣⵣⴻⵛⵜ: ⵜⵍⴰⵜⴰ ⵏ ⵜⴻⵄⵛⵓⵔⵉⵏ ⵏ ⵢⵉⵊⵊ ⵏ ⵉⴼⴰ ⵉ ⵓⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵄⵛⵓⵔⵉⵏ ⵏ ⵢⵉⵊⵊ ⵏ ⵉⴼⴰ ⵉ ⵉⵛⴰⵔⵔⵉ ");
INSERT INTO rift_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","ⴰⴽ-ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵄⵛⴰⵔⵜ ⵏ ⵢⵉⵊⵊ ⵏ ⵉⴼⴰ ⵉ ⴽⵓⵍ ⵉⵣⵎⴰⵔ, ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⵙⴻⴱⵄⴰ ⵏ ⵉⵣⵎⴰⵔⴻⵏ ⵎⴰⵔⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","ⵙⵡⴻⵊⴷⴻⵎ ⵄⴰⵡⴻⴷ ⵉⵊⵊ ⵏ ⵓⵎⵢⴰⵏ ⵣⴻⴳ ⵉⵖⴰⵢⴹⴻⵏ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⵜⵜⵡⴰⴳⴳ ⵡⴻⵚⵍⴰⵃ ⵉ ⴽⴻⵏⵏⵉⵡ. ");
INSERT INTO rift_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","ⵙⴻⵏⵏⴻⵊ ⵉ ⵓⵙⴻⵡⵊⴻⴷ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⴰⴽ-ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵏ ⵍⵖⵉⴵⴻⵜ ⴷ ⵙⴻⵏⵏⴻⵊ ⵉ ⵓⵙⴻⵡⵊⴻⴷ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵏ ⵍⴻⴱⴷⴰ ⴰⴽ-ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵏ ⵍⵖⵉⴵⴻⵜ ⴷ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵏⵙⴻⵏ ⵏ ⵓⵙⴻⵢⵢⴻⴱ, ⵄⵍⴰⵃⵙⴰⴱ ⵍⴼⴰⵔⵉⴹⴰ ⵏⵙⴻⵏⵜ, ⴰⵎ ⵢⵉⵛⵜ ⵏ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵉⵜⵜⴼⵓⵃⴻⵏ, ⵉⵛⵜ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵜⵎⴻⵙⵙⵉ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵄⴻⵛⵔⴰ ⴰⴷ ⵜⴻⴳⴳⴻⵎ ⵉⵊⵊ ⵏ ⵓⵎⵓⵏⵉ ⵉⵇⴻⴷⴷⵙⴻⵏ ⵓⵛⴰ ⴰⴷ ⵜⴻⵙⵙⵡⴰⴹⵄⴻⵎ ⵉⵅⴻⴼ ⵏⵡⴻⵎ. ⵡⴰⵔ ⵜⵜⴻⴳⴳⴻⵎ ⵓⵍⴰ ⴷ ⵉⵛⵜ ⵏ ⵍⵅⴻⴷⵎⴻⵜ ⵉ ⵉⵜⵜⵅⴻⵚⵚⴰⵏ ⴰⴷ ⵜᵉⵜⵜⵡⴰⴳⴳ. ");
INSERT INTO rift_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","ⴰⴷ ⵜⵇⴻⴷⴷⵎⴻⵎ ⵉⵛⵜ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⴰⵎ ⵢⵉⵛⵜ ⵏ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵉⵜⵜⴼⵓⵃⴻⵏ ⵉ ⵙⵉⴷⵉ: ⵉⵊⵊ ⵏ ⵓⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ ⴷ ⵢⵉⵊⵊ ⵏ ⵉⵛⴰⵔⵔⵉ ⴷ ⵙⴻⴱⵄⴰ ⵏ ⵉⵣⵎⴰⵔⴻⵏ ⵉⵛⵏⴰⵏ ⵇⴰⵄ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ. ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⴰⵡⴻⵎ ⵉⵍⵉⵏ ⵛⵏⴰⵏ ⴰⵟⵟⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","ⵄⴰⵡⴻⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵙⴻⵏ ⵏ ⵍⵖⵉⴵⴻⵜ ⵏ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵅⴻⴵⴹⴻⵏ ⵙ ⵣⵣⴻⵛⵜ: ⵜⵍⴰⵜⴰ ⵏ ⵜⴻⵄⵛⵓⵔⵉⵏ ⵏ ⵢⵉⵊⵊ ⵏ ⵉⴼⴰ ⵉ ⵢⵉⵊⵊ ⵏ ⵓⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ, ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵄⵛⵓⵔⵉⵏ ⵏ ⵢⵉⵊⵊ ⵏ ⵉⴼⴰ ⵉ ⵢⵉⵊⵊ ⵏ ⵉⵛⴰⵔⵔⵉ ");
INSERT INTO rift_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","ⵓ ⵉⵛⵜ ⵏ ⵜⴻⵄⵛⴰⵔⵜ ⵏ ⵢⵉⵊⵊ ⵏ ⵉⴼⴰ ⵉ ⴽⵓⵍ ⵉⵣⵎⴰⵔ, ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⵙⴻⴱⵄⴰ ⵏ ⵉⵣⵎⴰⵔⴻⵏ ⵎⴰⵔⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","ⵙⵡⴻⵊⴷⴻⵎ ⵄⴰⵡⴻⴷ ⵉⵊⵊ ⵏ ⵓⵎⵢⴰⵏ ⵣⴻⴳ ⵉⵖⴰⵢⴹⴻⵏ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ, ⵙⴻⵏⵏⴻⵊ ⵉ ⵓⵙⴻⵡⵊⴻⴷ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ ⵉ ⵣⵉ ⵜᵉⵜⵜⵡⴰⴳⴳ ⵡⴻⵚⵍⴰⵃ ⵓⵛⴰ ⵓⵍⴰ ⴷ ⵜⴰⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵏ ⵍⴻⴱⴷⴰ ⴰⴽ-ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵏ ⵍⵖⵉⴵⴻⵜ ⴷ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵏⵙⴻⵏ ⵏ ⵓⵙⴻⵢⵢⴻⴱ. ");
INSERT INTO rift_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵅⴻⵎⵎⴻⵙⵟⴰⵛ ⵏ ⵓⵢⵓⵔ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ ⴰⴷ ⵜⴻⴳⴳⴻⵎ ⵉⵊⵊ ⵏ ⵓⵎⵓⵏⵉ ⵉⵇⴻⴷⴷⵙⴻⵏ. ⵡⴰⵔ ⵜⵜⴻⴳⴳⴻⵎ ⵓⵍⴰ ⴷ ⵉⵛⵜ ⵏ ⵍⵅⴻⴷⵎⴻⵜ ⵉ ⵉⵜⵜⵅⴻⵚⵚⴰⵏ ⴰⴷ ⵜᵉⵜⵜⵡⴰⴳⴳ. ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⴰⴷ ⵜⵄⴻⵢⵢⴷⴻⵎ ⵍⵄⵉⴷ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","ⴰⴷ ⵜⵇⴻⴷⴷⵎⴻⵎ ⵉⵛⵜ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⴰⵎ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ, ⴰⵎ ⵉⵛⵜ ⵏ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵉⵜⵜⴼⵓⵃⴻⵏ ⵉ ⵙⵉⴷⵉ: ⵜⵍⴻⵟⵟⴰⵛ ⵏ ⵉⴼⵓⵏⴰⵙⴻⵏ - ⵉⵎⴻⵥⵢⴰⵏⴻⵏ ⵏ ⵉⵛⵜ ⵏ ⵜⴼⵓⵏⴰⵙⵜ - ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ ⵓ ⴰⵔⴱⴻⵄⵟⴰⵛ ⵏ ⵉⵣⵎⴰⵔⴻⵏ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ. ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵉⵍⵉⵏ ⵛⵏⴰⵏ ⵇⴰⵄ. ");
INSERT INTO rift_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","ⵄⴰⵡⴻⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏⵙⴻⵏ ⵏ ⵍⵖⵉⴵⴻⵜ ⵏ ⵡⴰⵔⴻⵏ ⴰⵣⴷⴰⴷ ⵉⵅⴻⴵⴹⴻⵏ ⵙ ⵣⵣⴻⵛⵜ: ⵜⵍⴰⵜⴰ ⵏ ⵜⴻⵄⵛⵓⵔⵉⵏ ⵏ ⵢⵉⵊⵊ ⵏ ⵉⴼⴰ ⵉ ⵢⵉⵊⵊ ⵏ ⵓⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ, ⵉ ⵎⴰⵔⵔⴰ ⵜⵍⴻⵟⵟⴰⵛ ⵏ ⵉⴼⵓⵏⴰⵙⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⴻⵏ, ⵓ ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⴻⵄⵛⵓⵔⵉⵏ ⵏ ⵢⵉⵊⵊ ⵏ ⵉⴼⴰ ⵉ ⵢⵉⵊⵊ ⵏ ⵓⵛⴰⵔⵔⵉ, ⵉ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ ⵏⵏⵉ ");
INSERT INTO rift_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","ⵓⵍⴰ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵄⵛⴰⵔⵜ ⵏ ⵢⵉⵊⵊ ⵏ ⵉⴼⴰ ⵉ ⴽⵓⵍ ⵉⵣⵎⴰⵔ, ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⵎⴰⵔⵔⴰ ⴰⵔⴱⴻⵄⵟⴰⵛ ⵏ ⵉⵣⵎⴰⵔⴻⵏ ⵏⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","ⵙⵡⴻⵊⴷⴻⵎ ⵄⴰⵡⴻⴷ ⵉⵊⵊ ⵏ ⵉⵊⵊ ⵏ ⵓⵎⵢⴰⵏ ⵣⴻⴳ ⵉⵖⴰⵢⴹⴻⵏ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ, ⵙⴻⵏⵏⴻⵊ ⵉ ⵓⵙⴻⵡⵊⴻⴷ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵏ ⵍⴻⴱⴷⴰ ⴰⴽ-ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵏ ⵍⵖⵉⴵⴻⵜ ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵏ ⵓⵙⴻⵢⵢⴻⴱ. ");
INSERT INTO rift_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵜⵏⴰⵢⴻⵏ: ⵜⴻⵏⵄⴰⵛ ⵏ ⵉⴼⵓⵏⴰⵙⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⴻⵏ ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ ⴷ ⴰⵔⴱⴻⵄⵟⴰⵛ ⵏ ⵉⵣⵎⴰⵔⴻⵏ ⵉⵛⵏⴰⵏ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ, ");
INSERT INTO rift_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","ⴰⴽ-ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵙⴻⵏ ⵏ ⵍⵖⵉⴵⴻⵜ ⴷ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵏⵙⴻⵏ ⵏ ⵓⵙⴻⵢⵢⴻⴱ ⵉ ⵉⴼⵓⵏⴰⵙⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⴻⵏ, ⵉ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ ⵓ ⵉ ⵉⵣⵎⴰⵔⴻⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵍⵇⴻⴷⴷ ⵏⵙⴻⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵍⴼⴰⵔⵉⴹⴰ. ");
INSERT INTO rift_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","ⵙⵡⴻⵊⴷⴻⵎ ⵄⴰⵡⴻⴷ ⵉⵊⵊ ⵏ ⵓⵎⵢⴰⵏ ⵣⴻⴳ ⵉⵖⴰⵢⴹⴻⵏ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ, ⵙⴻⵏⵏⴻⵊ ⵉ ⵓⵙⴻⵡⵊⴻⴷ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵏ ⵍⴻⴱⴷⴰ ⴰⴽ-ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵏ ⵍⵖⵉⴵⴻⵜ ⴷ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵏⵙⴻⵏ ⵏ ⵓⵙⴻⵢⵢⴻⴱ. ");
INSERT INTO rift_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵜⵍⴰⵜⴰ: ⵃⵉⵟⴰⵛ ⵏ ⵉⴼⵓⵏⴰⵙⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⴻⵏ ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ ⴷ ⴰⵔⴱⴻⵄⵟⴰⵛ ⵏ ⵉⵣⵎⴰⵔⴻⵏ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ, ⵉⵛⴰⵏ ⵇⴰⵄ, ");
INSERT INTO rift_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","ⴰⴽ-ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵙⴻⵏ ⵏ ⵍⵖⵉⴵⴻⵜ ⴷ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵏⵙⴻⵏ ⵏ ⵓⵙⴻⵢⵢⴻⴱ ⵉ ⵉⴼⵓⵏⴰⵙⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⴻⵏ, ⵉ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ ⵓ ⵉ ⵉⵣⵎⴰⵔⴻⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵍⵇⴻⴷⴷ ⵏⵙⴻⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵍⴼⴰⵔⵉⴹⴰ. ");
INSERT INTO rift_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","ⵙⵡⴻⵊⴷⴻⵎ ⵄⴰⵡⴻⴷ ⵉⵊⵊ ⵏ ⵓⵎⵢⴰⵏ ⵣⴻⴳ ⵉⵖⴰⵢⴹⴻⵏ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ, ⵙⴻⵏⵏⴻⵊ ⵉ ⵓⵙⴻⵡⵊⴻⴷ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵏ ⵍⴻⴱⴷⴰ ⴰⴽ-ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵏ ⵍⵖⵉⴵⴻⵜ ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵏ ⵓⵙⴻⵢⵢⴻⴱ. ");
INSERT INTO rift_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⴰⵔⴻⴱⵄⴰ: ⵄⴻⵛⵔⴰ ⵏ ⵉⴼⵓⵏⴰⵙⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⴻⵏ ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ ⴷ ⴰⵔⴱⴻⵄⵟⴰⵛ ⵏ ⵉⵣⵎⴰⵔⴻⵏ ⵉⵛⵏⴰⵏ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ, ");
INSERT INTO rift_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","ⴰⴽ-ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵙⴻⵏ ⵏ ⵍⵖⵉⴵⴻⵜ ⴷ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵏⵙⴻⵏ ⵏ ⵓⵙⴻⵢⵢⴻⴱ ⵉ ⵉⴼⵓⵏⴰⵙⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⴻⵏ, ⵉ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ ⵓ ⵉ ⵉⵣⵎⴰⵔⴻⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵍⵇⴻⴷⴷ ⵏⵙⴻⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵍⴼⴰⵔⵉⴹⴰ. ");
INSERT INTO rift_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","ⵙⵡⴻⵊⴷⴻⵎ ⵄⴰⵡⴻⴷ ⵉⵊⵊ ⵏ ⵓⵎⵢⴰⵏ ⵣⴻⴳ ⵉⵖⴰⵢⴹⴻⵏ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ, ⵙⴻⵏⵏⴻⵊ ⵉ ⵓⵙⴻⵡⵊⴻⴷ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵏ ⵍⴻⴱⴷⴰ ⴰⴽ-ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵏ ⵍⵖⵉⴵⴻⵜ ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵏ ⵓⵙⴻⵢⵢⴻⴱ. ");
INSERT INTO rift_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵅⴻⵎⵙⴰ: ⵜⴻⵙⵄⴰ ⵏ ⵉⴼⵓⵏⴰⵙⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⴻⵏ ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ ⴷ ⴰⵔⴱⴻⵄⵟⴰⵛ ⵏ ⵉⵣⵎⴰⵔⴻⵏ ⵉⵛⵏⴰⵏ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ, ");
INSERT INTO rift_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","ⴰⴽ-ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵙⴻⵏ ⵏ ⵍⵖⵉⴵⴻⵜ ⴷ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵏⵙⴻⵏ ⵏ ⵓⵙⴻⵢⵢⴻⴱ ⵉ ⵉⴼⵓⵏⴰⵙⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⴻⵏ, ⵉ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ ⵓ ⵉ ⵉⵣⵎⴰⵔⴻⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵍⵇⴻⴷⴷ ⵏⵙⴻⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵍⴼⴰⵔⵉⴹⴰ. ");
INSERT INTO rift_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","ⵙⵡⴻⵊⴷⴻⵎ ⵄⴰⵡⴻⴷ ⵉⵊⵊ ⵏ ⵓⵎⵢⴰⵏ ⵣⴻⴳ ⵉⵖⴰⵢⴹⴻⵏ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ, ⵙⴻⵏⵏⴻⵊ ⵉ ⵓⵙⴻⵡⵊⴻⴷ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵏ ⵍⴻⴱⴷⴰ ⴰⴽ-ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵏ ⵍⵖⵉⴵⴻⵜ ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵏ ⵓⵙⴻⵢⵢⴻⴱ. ");
INSERT INTO rift_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⵜⵜⴰ: ⵜⵎⴻⵏⵢⴰ ⵏ ⵉⴼⵓⵏⴰⵙⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⴻⵏ ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ ⴷ ⴰⵔⴱⴻⵄⵟⴰⵛ ⵏ ⵉⵣⵎⴰⵔⴻⵏ ⵉⵛⵏⴰⵏ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ, ");
INSERT INTO rift_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","ⴰⴽ-ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵙⴻⵏ ⵏ ⵍⵖⵉⴵⴻⵜ ⴷ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵏⵙⴻⵏ ⵏ ⵓⵙⴻⵢⵢⴻⴱ ⵉ ⵉⴼⵓⵏⴰⵙⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⴻⵏ, ⵉ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ ⵓ ⵉ ⵉⵣⵎⴰⵔⴻⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵍⵇⴻⴷⴷ ⵏⵙⴻⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵍⴼⴰⵔⵉⴹⴰ. ");
INSERT INTO rift_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","ⵙⵡⴻⵊⴷⴻⵎ ⵄⴰⵡⴻⴷ ⵉⵊⵊ ⵏ ⵓⵎⵢⴰⵏ ⵣⴻⴳ ⵉⵖⴰⵢⴹⴻⵏ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ, ⵙⴻⵏⵏⴻⵊ ⵉ ⵓⵙⴻⵡⵊⴻⴷ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵏ ⵍⴻⴱⴷⴰ ⴰⴽ-ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵏ ⵍⵖⵉⴵⴻⵜ ⴷ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵏⵏⴻⵙ ⵏ ⵓⵙⴻⵢⵢⴻⴱ. ");
INSERT INTO rift_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ: ⵙⴻⴱⵄⴰ ⵏ ⵉⴼⵓⵏⴰⵙⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⴻⵏ ⴷ ⵜⵏⴰⵢⴻⵏ ⵏ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ ⴷ ⴰⵔⴱⴻⵄⵟⴰⵛ ⵏ ⵉⵣⵎⴰⵔⴻⵏ ⵉⵛⵏⴰⵏ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ, ");
INSERT INTO rift_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","ⴰⴽ-ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵙⴻⵏ ⵏ ⵍⵖⵉⴵⴻⵜ ⴷ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵏⵙⴻⵏ ⵏ ⵓⵙⴻⵢⵢⴻⴱ ⵉ ⵉⴼⵓⵏⴰⵙⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⴻⵏ, ⵉ ⵉⵛⴰⵔⵔⵉⵢⵢⴻⵏ ⵓ ⵉ ⵉⵣⵎⴰⵔⴻⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵍⵇⴻⴷⴷ ⵏⵙⴻⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵍⴼⴰⵔⵉⴹⴰ. ");
INSERT INTO rift_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","ⵙⵡⴻⵊⴷⴻⵎ ⵄⴰⵡⴻⴷ ⵉⵊⵊ ⵏ ⵓⵎⵢⴰⵏ ⵣⴻⴳ ⵉⵖⴰⵢⴹⴻⵏ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ, ⵙⴻⵏⵏⴻⵊ ⵉ ⵓⵙⴻⵡⵊⴻⴷ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵏ ⵍⴻⴱⴷⴰ ⴰⴽ-ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵏ ⵍⵖⵉⴵⴻⵜ ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵏ ⵓⵙⴻⵢⵢⴻⴱ. ");
INSERT INTO rift_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵜⵎⴻⵏⵢⴰ ⴰⴷ ⵜⴻⴳⴳⴻⵎ ⵉⵊⵊ ⵏ ⵓⵎⵓⵏⵉ ⵉⴼⴰⵔⵣⴻⵏ. ⵡⴰⵔ ⵜⵜⴻⴳⴳⴻⵎ ⵓⵍⴰ ⴷ ⵉⵛⵜ ⵍⵅⴻⴷⵎⴻⵜ ⵉ ⵉⵜⵜⵅⴻⵚⵚⴰⵏ ⴰⴷ ⵜᵉⵜⵜⵡⴰⴳⴳ. ");
INSERT INTO rift_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","ⴰⴷ ⵜⵇⴻⴷⴷⵎⴻⵎ ⵉⵛⵜ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⴰⵎ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵜⵎⴻⵙⵙⵉ, ⴰⵎ ⵉⵛⵜ ⵏ ⵍⴻⴼⵡⴰⵃⴻⵜ ⵉⵜⵜⴼⵓⵃⴻⵏ ⵉ ⵙⵉⴷⵉ: ⵉⵊⵊ ⵏ ⵓⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ ⴷ ⵢⵉⵊⵊ ⵏ ⵉⵛⴰⵔⵔⵉ ⴷ ⵙⴻⴱⵄⴰ ⵏ ⵉⵣⵎⴰⵔⴻⵏ ⵉⵛⵏⴰⵏ ⵏ ⵉⵊⵊ ⵏ ⵓⵙⴻⴳⴳⵯⴰⵙ ");
INSERT INTO rift_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","ⴰⴽ-ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵙⴻⵏ ⵏ ⵍⵖⵉⴵⴻⵜ ⴷ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵏⵙⴻⵏ ⵏ ⵓⵙⴻⵢⵢⴻⴱ ⵉ ⵓⴼⵓⵏⴰⵙ ⴰⵎⴻⵥⵢⴰⵏ, ⵉ ⵉⵛⴰⵔⵔⵉ ⵓ ⵉ ⵉⵣⵎⴰⵔⴻⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵍⵇⴻⴷⴷ ⵏⵙⴻⵏ, ⵄⵍⴰⵃⵙⴰⴱ ⵍⴼⴰⵔⵉⴹⴰ. ");
INSERT INTO rift_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","ⵙⵡⴻⵊⴷⴻⵎ ⵄⴰⵡⴻⴷ ⵉⵊⵊ ⵏ ⵓⵎⵢⴰⵏ ⵣⴻⴳ ⵉⵖⴰⵢⴹⴻⵏ ⴰⵎ ⵜⵖⴰⵔⵚⵜ ⵏ ⴷⴷⴻⵏⴱ, ⵙⴻⵏⵏⴻⵊ ⵉ ⵓⵙⴻⵡⵊⴻⴷ ⵏ ⵜⵖⴰⵔⵚⵜ ⵏ ⵡⴻⵛⵎⴰⴹ ⵏ ⵍⴻⴱⴷⴰ ⴰⴽ-ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵏ ⵍⵖⵉⴵⴻⵜ ⴷ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵏⴻⵙ ⵏ ⵓⵙⴻⵢⵢⴻⴱ. ");
INSERT INTO rift_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","ⴰⴷ ⵜⴻⴳⴳⴻⵎ ⵜⵉⵎⴻⵙⵍⴰⵢⵉⵏ-ⴰ ⵉ ⵙⵉⴷⵉ ⴷⵉ ⵍⴻⵄⵢⵓⴷⴰⵜ ⵏⵡⴻⵎ ⵉⵜⵜⵡⴰⴳⴳⴻⵏ ⵙⴻⵏⵏⴻⵊ ⵉ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵏ ⵍⴻⵡⵄⵓⴷ ⵏⵡⴻⵎ ⴷ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵏⵡⴻⵎ ⵙ ⵍⵅⴰⴹⴰⵔ ⵉ ⵉⵜⵜⵔⴰⵃⴻⵏ ⴰⴽ-ⴷ ⵜⵖⴰⵔⵚⴰ ⵏ ⵡⴻⵛⵎⴰⴹ ⵏⵡⴻⵎ ⴷ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵏⵡⴻⵎ ⵏ ⵍⵖⵉⴵⴻⵜ ⴷ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵏⵡⴻⵎ ⵏ ⵓⵙⴻⵢⵢⴻⴱ ⴷ ⵜⴻⵡⵀⵉⴱⵉⵏ ⵏⵡⴻⵎ ⵏ ⵍⴻⵀⵏⴰ.” ");
INSERT INTO rift_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","ⵓⵛⴰ ⵉⵙⵙⵉⵡⴻⵍ ⵎⵓⵙⴰ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵄⵍⴰⵃⵙⴰⴱ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","ⵉⵙⵙⵉⵡⴻⵍ ⵎⵓⵙⴰ ⴰⴽ-ⴷ ⵉⵣⴻⴵⵉⴼⴻⵏ ⵏ ⵜⵇⴻⴱⴱⴰⵍ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵉⵏⵏⴰ: “ⴰⵇⴰ ⴷ ⵜⴰ ⵎⵉⵏ ⵅⴻⴼ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ: ");
INSERT INTO rift_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","‘ⵅⵎⵉ ⵖⴰ ⵜⴰⴼⴻⴷ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵉⵡⵛⴰ ⴰⵡⴰⵍ ⵏⵉⵖ ⵉⵊⵊⵓⴵ ⵉⵛⵜ ⵏ ⵜⵊⴰⴵⵉⵜ ⵃⵉⵎⴰ ⴰⴷ ⵉⵇⵇⴻⵏ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵙ ⵢⵉⵊⵊ ⵏ ⵍⵄⴰⵀⴷ, ⵅⴻⵏⵏⵉ ⵡⴰⵔ ⵉⵜⵜⴰⵔⴻⵥⵥⵉ ⴰⵡⴰⵍ ⵏⵏⴻⵙ. ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⵙ ⴰⴷ ⵉⴳⴳ ⵄⵍⴰⵃⵙⴰⴱ ⵎⵉⵏ ⴷⴷ-ⵉⴼⴼⵖⴻⵏ ⵣⴻⴳ ⵓⵇⴻⵎⵎⵓⵎ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","ⵅⵎⵉ ⵖⴰ ⵜⴰⴼⴻⴷ ⵉⵛⵜ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⵜⴻⵡⵛⴰ ⴰⵡⴰⵍ ⵏⵏⴻⵙ ⵉ ⵙⵉⴷⵉ ⵓⵛⴰ ⴰⴷ ⵜⴻⵇⵇⴻⵏ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵙ ⵢⵉⵊⵊ ⵏ ⵍⵄⴰⵀⴷ ⴷⵉ ⵜⴻⵎⵥⵉ ⵏⵏⴻⵙ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⴱⴰⴱⴰⵙ, ");
INSERT INTO rift_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","ⵓⵛⴰ ⴱⴰⴱⴰⵙ ⵉⵙⵍⴰ ⵉ ⵡⴰⵡⴰⵍ ⵏ ⵍⵡⴰⵄⴷ ⵏⵏⴻⵙ ⴷ ⵍⵄⴰⵀⴷ ⵏⵏⴻⵙ ⵉ ⵣⵉ ⵜⴻⵇⵇⴻⵏ ⵉⵅⴻⴼ ⵏⵏⴻⵙ, ⵓⵛⴰ ⴱⴰⴱⴰⵙ ⵉⵙⵇⴰⵔ ⵣⵣⴰⵜⴻⵙ, ⵅⴻⵏⵏⵉ ⵎⴰⵔⵔⴰ ⵍⵡⵓⵄⵓⴷ ⵏⵏⴻⵙ ⴰⴷ ⵉⵍⵉⵏ ⵚⴻⵍⵃⴻⵏ ⴷ ⴽⵓⵍ ⴰⵇⵇⴰⵏ ⵏⵏⴻⵙ ⴰⴷ ⵢⵉⵍⵉ ⵉⵚⵍⴻⵃ. ");
INSERT INTO rift_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⴱⴰⴱⴰⵙ ⵉⵙⵙⴱⴻⴷⴷ ⵉ-ⵜⵜ ⵣⵉ ⵎⴰⵏ ⴰⵢⴰ ⴷⴻⴳ ⵡⴰⵙⵙ ⵏⵏⵉ ⴷⵉ ⵉⵙⵍⴰ ⴰⵢⴰ, ⵅⴻⵏⵏⵉ ⵓⵍⴰ ⴷ ⵉⵊⵊ ⵣⵉ ⵍⵡⵓⵄⵓⴷ ⵏⵏⴻⵙ ⵓ ⵓⵍⴰ ⴷ ⵉⵊⵊ ⵣⴻⴳ ⵡⴰⵇⵇⴰⵏ ⵏⵏⴻⵙ ⵉ ⵣⵉ ⵜⴻⵇⵇⴻⵏ ⵉⵅⴻⴼ ⵏⵏⴻⵙ, ⵡⴰⵔ ⵉⵚⴻⴵⴻⵃ ⵛⴰ. ⵙⵉⴷⵉ ⴰⴷ ⴰⵙ ⵉⵖⴼⴰⵔ, ⵎⵉⵏⵣⵉ ⴱⴰⴱⴰⵙ ⵉⵙⵙⴱⴻⴷⴷ ⵉ-ⵜⵜ ⵅ ⵎⴰⵏ ⴰⵢⴰ. ");
INSERT INTO rift_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","ⵎⴰⵍⴰ ⵜⵓⵖⴰ-ⵜⵜ ⵜⴻⵎⵍⴻⵛ ⴰⴽ-ⴷ ⵢⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵓⵛⴰ ⵅⴰⵙ ⵍⵡⵓⵄⵓⴷ ⵏⵉⵖ ⵏⴻⵜⵜⴰⵜ ⵜⵓⵖⴰ ⵜⴻⵇⵇⴻⵏ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵙ ⵢⵉⵊⵊ ⵏ ⵡⴰⵡⴰⵍ ⵉⴼⴼⴻⵖ-ⴷⴷ ⵙ ⵜⵛⴰⵔⴼⴰⵢⴻⵃ ⵣⴻⴳ ⵉⵢⴻⵏⵛⵉⵛⴻⵏ ⵏⵏⴻⵙ, ");
INSERT INTO rift_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","ⵓⵛⴰ ⴰⵔⵢⴰⵣ ⵏⵏⴻⵙ ⵉⵙⵍⴰ ⴰⵙ ⵓⵛⴰ ⵉⵙⵇⴰⵔ ⵣⵣⴰⵜⴻⵙ ⴷⴻⴳ ⵡⴰⵙⵙ ⵉ ⴷⵉ ⵉⵙⵍⴰ ⴰⵢⴰ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵙⴻⵍⵃⴻⵏ ⵍⵡⵓⵄⵓⴷ ⵏⵏⴻⵙ ⴷ ⴽⵓⵍ ⴰⵇⵇⴰⵏ ⵏⵏⴻⵙ ⴰⴷ ⵢⵉⵍⵉ ⵉⵚⵍⴻⵃ. ");
INSERT INTO rift_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⴰⵔⵢⴰⵣ ⵏⵏⴻⵙ ⴷⴻⴳ ⵡⴰⵙⵙ ⵏⵏⵉ ⴷⵉ ⵉⵙⵍⴰ ⴰⵢⴰ, ⵉⵏⵀⴰⵔ ⵉ-ⵜⵜ, ⵅⴻⵏⵏⵉ ⵏⴻⵜⵜⴰ ⵉⵙⵙⴻⴱⴹⴻⵍ ⵍⵡⴰⵄⴷ ⵏⵏⵉ ⵅⴰⵙ ⵓⵍⴰ ⴷ ⴰⵡⴰⵍ ⵙ ⵜⵛⴰⵔⴼⴰⵢⴻⵃ ⵣⴻⴳ ⵉⵢⴻⵏⵛⵉⵛⴻⵏ ⵏⵏⴻⵙ ⵉ ⵣⵉ ⵜⵓⵖⴰ ⵜⴻⵇⵇⴻⵏ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵓⵛⴰ ⴰⵔⴻⴱⴱⵉ ⴰⴷ ⴰⵙ ⵉⵖⴼⴰⵔ ⴰⵢⴰ.’” ");
INSERT INTO rift_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“ⵅ ⵍⵡⴰⵄⴷ ⵏ ⵜⴰⵊⵊⴰⵍⵜ ⵏⵉⵖ ⵏ ⵜⴻⵏⵏⵉ ⵉⵜⵜⵡⴰⴵⴼⴻⵏ: ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵣⵉ ⵜⵓⵖⴰ ⵜⴻⵇⵇⴻⵏ ⵉⵅⴻⴼ ⵏⵏⴻⵙ, ⴰⴷ ⵢⵉⵍⵉ ⵉⵚⴻⴵⴻⵃ. ");
INSERT INTO rift_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","ⵎⴰⵍⴰ ⵜⵓⵖⴰ ⵜⴻⵡⵛⴰ ⴰⵡⴰⵍ ⵏⵉⵖ ⵜⴻⵇⵇⴻⵏ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵙ ⵉⵛⵜ ⵏ ⵜⵊⴰⴵⵉⵜ ⵉ ⵢⵉⵊⵊ ⵏ ⵍⵄⴰⵀⴷ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵡⴻⵔⵢⴰⵣ ⵏⵏⴻⵙ, ");
INSERT INTO rift_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","ⵓⵛⴰ ⴰⵔⵢⴰⵣ ⵏⵏⴻⵙ ⵉⵙⵍⴰ ⵉ ⵓⵢⴰ ⵓⵛⴰ ⵉⵙⵇⴰⵔ ⵣⵣⴰⵜⴻⵙ ⵓⵛⴰ ⵡⴰⵔ ⵜⵜ ⵉⵙⵙⴱⴻⴷⴷ ⵅ ⵎⴰⵏ ⴰⵢⴰ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵚⴻⵍⵃⴻⵏ ⵎⴰⵔⵔⴰ ⵍⵡⵓⵄⵓⴷ ⵏⵏⴻⵙ ⵓ ⴽⵓⵍ ⴰⵇⵇⴰⵏ ⵏⵏⴻⵙ ⵉ ⵣⵉ ⵜⵓⵖⴰ ⵜⴻⵇⵇⴻⵏ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⴰⴷ ⵢⵉⵍⵉ ⵉⵚⵍⴻⵃ. ");
INSERT INTO rift_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⴰⵔⵢⴰⵣ ⵏⵏⴻⵙ ⵉⵙⵙⴻⴱⴹⴻⵍ ⴰⵢⴰ ⵇⴰⵄ ⴷⴻⴳ ⵡⴰⵙⵙ ⵉ ⴷⵉ ⵉⵙⵍⴰ, ⵅⴻⵏⵏⵉ ⵡⴰⵔ ⵉⵜⵜⵉⵍⵉ ⵉⵚⴻⴵⴻⵃ ⵛⴰ ⵇⴰⵄ ⵣⵉ ⵎⵉⵏ ⴷⴷ-ⵉⴼⴼⵖⴻⵏ ⵣⴻⴳ ⵉⵢⴻⵏⵛⵉⵛⴻⵏ ⵏⵏⴻⵙ ⵏ ⵍⵡⵓⵄⵓⴷ ⵏⵉⵖ ⵏ ⵡⴰⵇⵇⴰⵏ. ⴰⵔⵢⴰⵣ ⵏⵏⴻⵙ ⵉⵙⵙⴻⴱⴹⴻⵍ ⴰⵢⴰ ⵓⵛⴰ ⴰⵔⴻⴱⴱⵉ ⴰⴷ ⴰⵙ ⵉⵖⴼⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","ⴽⵓⵍ ⵍⵡⴰⵄⴷ ⴷ ⴽⵓⵍ ⴰⵇⵇⴰⵏ ⵙ ⵉⵛⵜ ⵏ ⵜⵊⴰⴵⵉⵜ ⵉ ⵓⵎⵉ ⵖⴰ ⵜⴻⵙⵙⵡⴰⴹⴻⵄ ⵉⵅⴻⴼ ⵏⵏⴻⵙ, ⴰⵔⵢⴰⵣ ⵏⵏⴻⵙ ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵜ ⵉⵙⵙⴻⵎⵜⴻⵏ ⵏⵉⵖ ⴰⵔⵢⴰⵣ ⵏⵏⴻⵙ ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵜ ⵉⵙⵙⴻⴱⴹⴻⵍ. ");
INSERT INTO rift_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","ⵎⴰⵍⴰ ⴰⵔⵢⴰⵣ ⵏⵏⴻⵙ ⵉⵙⵇⴰⵔ ⵇⴰⵄ ⵣⴻⴳ ⵡⴰⵙⵙ ⵅ ⵡⴰⵙⵙ, ⵅⴻⵏⵏⵉ ⵉⵙⵙⴻⵎⵜⴻⵏ ⵎⴰⵔⵔⴰ ⵍⵡⵓⵄⵓⴷ ⵏⵏⴻⵙ ⵏⵉⵖ ⴽⵓⵍ ⴰⵇⵇⴰⵏ ⵏⵏⴻⵙ ⵉ ⵅⴰⵙ ⵉⴵⴰⵏ. ⴰⵇⴰ ⵉⵙⵙⴻⵎⵜⴻⵏ ⵉ-ⵜⴻⵏ ⵎⵉⵏⵣⵉ ⵉⵙⵇⴰⵔ ⵣⵣⴰⵜⴻⵙ ⴷⴻⴳ ⵡⴰⵙⵙ ⵉ ⴷⵉ ⵜⴻⵏ ⵉⵙⵍⴰ. ");
INSERT INTO rift_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","ⵎⴰⵍⴰ ⵏⴻⵜⵜⴰ, ⴰⵡⴰⵔⵏⵉ ⵍⴰⵎⵉ ⴷ ⴰⵙⴻⵏ ⵉⵙⵍⴰ, ⴰⴷ ⵜⴻⵏ ⵉⵙⵙⴻⴱⴹⴻⵍ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵢⴰⵔⴱⵓ ⵏⴻⵜⵜⴰ ⵍⵎⵓⵄⵚⵉⵢⵢⴻⵜ ⵏ ⵜⴻⵎⵖⴰⵔⵜ ⵏⵏⴻⵙ.” ");
INSERT INTO rift_vpl VALUES ("NU30_17","005_30_17","NUM","30","17","17","ⴰⵇⴰ ⴷ ⵜⵉⵏⴰ ⴷ ⵜⵉⵡⴻⵚⵚⴰ ⵉ ⵣⵉ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ, ⵉ ⵉⴵⴰⵏ ⵊⴰⵔ ⵡⴻⵔⵢⴰⵣ ⴷ ⵜⴻⵎⵖⴰⵔⵜ, ⵊⴰⵔ ⴱⴰⴱⴰⵙ ⴷ ⵢⴻⵙⵙⵉⵙ, ⵜⴻⵏⵏⵉ ⵉⵇⵇⵉⵎⴻⵏ ⴷⵉ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⴱⴰⴱⴰⵙ ⴷⵉ ⵜⴻⵎⵥⵉ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“ⵏⵜⴰⵇⴻⵎ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵅ ⵉⵎⵉⴷⵢⴰⵏⵉⵢⵢⴻⵏ. ⴰⵡⴰⵔⵏⵉ ⴰⵙ ⴰⴷ ⵜᵉⵎⵎⴰⵔⵏⵉⴷ ⵖⴰⵔ ⵍⴳⴻⵏⵙ ⵏⵏⴻⵛ.” ");
INSERT INTO rift_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","ⵉⵙⵙⵉⵡⴻⵍ ⵎⵓⵙⴰ ⴰⴽ-ⴷ ⵍⴳⴻⵏⵙ, ⵉⵏⵏⴰ: “ⵙⵡⴻⵊⴷⴻⵎ ⵣⵉ ⵖⴰⵔⵡⴻⵎ ⵉⵔⵢⴰⵣⴻⵏ ⵉ ⵓⵎⴻⵏⵖⵉ ⴹⵉⴷⴷ ⵉ ⵎⵉⴷⵢⴰⵏ ⵓ ⵏⵉⵜⵏⵉ ⴰⴷ ⵉⵍⵉⵏ ⴹⵉⴷⴷ ⵉ ⵎⵉⴷⵢⴰⵏ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵙⵙⵉⵡⴹⴻⵏ ⵏⵏⴻⵇⵎⴻⵜ ⵏ ⵙⵉⴷⵉ ⵅ ⵎⵉⴷⵢⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⵡⴻⵎ ⴰⴷ ⵜⴻⵙⵙⴻⴽⴽⴻⵎ ⴰⵍⴻⴼ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ ⵣⵉ ⴽⵓⵍ ⵜⴰⵇⴱⵉⵍⵜ ⵖⴰⵔ ⵓⵎⴻⵏⵖⵉ, ⵣⵉ ⴽⵓⵍ ⵉⵛⵜ ⵣⵉ ⵎⴰⵔⵔⴰ ⵜⵉⵇⴻⴱⴱⴰⵍ ⵏ ⵉⵙⵔⴰⵉⵍ.” ");
INSERT INTO rift_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","ⴰⵎⵎⵓ ⵉ ⵜⵜⵡⴰⴼⴰⵔⵣⴻⵏ ⵣⵉ ⵍⵓⵍⵓⴼ ⵏ ⵉⵙⵔⴰⵉⵍ ⴰⵍⴻⴼ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ ⵣⵉ ⴽⵓⵍ ⵜⴰⵇⴱⵉⵍⵜ, ⴰⵇⴰ ⴰⵜⴻⵏ ⵊⵎⵉⵄ ⵜⴻⵏⵄⴰⵛ-ⵏ-ⵍⵓⵍⵓⴼ ⵏ ⵢⴻⵔⴰⵣⴻⵏ ⵉⵡⴻⵊⴷⴻⵏ ⵉ ⵓⵎⴻⵏⵖⵉ. ");
INSERT INTO rift_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","ⵎⵓⵙⴰ ⵉⵙⵙⴻⴽⴽ ⵉ-ⵜⴻⵏ ⵖⴰⵔ ⵓⵎⴻⵏⵖⵉ, ⴰⵍⴻⴼ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ ⵣⵉ ⴽⵓⵍ ⵜⴰⵇⴱⵉⵍⵜ. ⵏⴻⵜⵜⴰ ⵉⵙⵙⴻⴽⴽ ⵉ-ⵜⴻⵏ ⵖⴰⵔ ⵓⵎⴻⵏⵖⵉ ⴰⴽ-ⴷ ⴼⵉⵏⴰⵃⴰⵙ, ⵎⵎⵉⵙ ⵏ ⵓⴽⴻⵀⵀⴰⵏ ⴰⵍⵉⵄⴰⵣⴰⵔ, ⵓ ⵏⴻⵜⵜⴰ ⵖⴰⵔⴻⵙ ⵍⴻⵇⵛⵓⵄ ⵉⵇⴻⴷⴷⵙⴻⵏ ⴷ ⵍⴻⴱⵡⴰⵇ ⵉ ⵓⵙⵓⴹⵉ ⵙ ⵡⴻⵙⵔⵓⴷⴷⴻⵃ ⵉ ⵓⵎⴻⵏⵖⵉ ⴷⴻⴳ ⵓⴼⵓⵙ ⵏⵏⴻⵙ ");
INSERT INTO rift_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","ⵓⵛⴰ ⵎⵎⴻⵏⵖⴻⵏ ⴹⵉⴷⴷ ⵉ ⵉⵎⵉⴷⵢⴰⵏⵉⵢⵢⴻⵏ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ ⵓⵛⴰ ⵏⵖⵉⵏ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⴵⴰⵏ ⴷ ⴰⵡⵜⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","ⵙⴻⵏⵏⴻⵊ ⵉ ⵢⵉⵏⵏⵉ ⵣⵣⴰⵢⵙⴻⵏ ⵉⵜⵜⵡⴰⵙⵙⵏⵓⵇⵇⴱⴻⵏ, ⵏⵖⵉⵏ ⵄⴰⵡⴻⴷ ⵉⵊⴻⴵⵉⴷⴻⵏ ⵏ ⵎⵉⴷⵢⴰⵏ: ⵉⵡⵉ, ⵔⴰⵇⵉⵎ, ⵚⵓⵔ, ⵃⵓⵔ ⴷ ⵔⴰⴱⴰⵄ, ⵅⴻⵎⵙⴰ ⵏ ⵉⵊⴻⴵⵉⴷⴻⵏ ⵏ ⵎⵉⴷⵢⴰⵏ, ⵓⵍⴰ ⴱⴰⵍⵄⴰⵎ, ⵎⵎⵉⵙ ⵏ ⴱⴰⵄⵓⵔ, ⵏⵖⵉⵏ ⵜ ⵙ ⵙⵙⵉⴼ. ");
INSERT INTO rift_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵃⴻⴱⴱⵙⴻⵏ ⵜⵉⵎⵖⴰⵔⵉⵏ ⵏ ⵎⵉⴷⵢⴰⵏ ⴷ ⵜⴰⵔⵡⴰ ⵏⵙⴻⵏ, ⵓ ⴽⴻⵛⵛⴹⴻⵏ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏⵙⴻⵏ ⴷ ⵜⵃⵉⵎⵔⵉⵡⵉⵏ ⵏⵙⴻⵏ ⴷ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵖⴰⵔⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","ⵙⵙⵛⴻⵎⴹⴻⵏ ⵙ ⵜⵎⴻⵙⵙⵉ ⵎⴰⵔⵔⴰ ⵜⵉⵏⴻⴷⴷⴰⵎ ⵏⵙⴻⵏ ⵎⴰⵏⵉ ⵜⵓⵖⴰ ⵣⴻⴷⴷⵖⴻⵏ ⴷ ⵎⴰⵔⵔⴰ ⵍⵇⴻⵍⵄⴰⵜ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","ⴽⵙⵉⵏ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴽⴻⵛⵛⴹⴻⵏ, ⵎⴰⵔⵔⴰ ⵜⴰⴽⴻⵛⵛⴰⴹⵜ ⵏ ⵉⵡⴷⴰⵏ ⴷ ⵍⴻⴱⵀⴰⵢⴻⵎ ");
INSERT INTO rift_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","ⵓⵛⴰ ⵉⵡⵢⴻⵏ-ⴷⴷ ⵉⵎⴻⵃⴱⴰⵙ ⴷ ⵎⴰⵔⵔⴰ ⵜⴰⴽⴻⵛⵛⴰⴹⵜ ⵖⴰⵔ ⵎⵓⵙⴰ ⵓ ⵖⴰⵔ ⵓⴽⴻⵀⵀⴰⵏ ⴰⵍⵉⵄⴰⵣⴰⵔ ⵓ ⵖⴰⵔ ⵜⵎⴻⵙⵎⵓⵏⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⴷⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ, ⴷⵉ ⵍⴻⵡⴹⴰⵜ ⵏ ⵎⵓ’ⴰⴱ, ⵖⴰⵔ ⵍ’ⵓⵔⴷⵓⵏ, ⴰⵔⴻⵏⴷⴰⴷ ⵏ ⴰⵔⵉⵃⴰ. ");
INSERT INTO rift_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","ⵓⵛⴰ ⵉⴼⴼⴻⵖ-ⴷⴷ ⵎⵓⵙⴰ ⴰⴽ-ⴷ ⵓⴽⴻⵀⵀⴰⵏ ⴰⵍⵉⵄⴰⵣⴰⵔ ⴷ ⵎⴰⵔⵔⴰ ⵍⵃⵓⴽⴽⴰⵎ ⵏ ⵜⵎⴻⵙⵎⵓⵏⵜ ⴱⴰⵔⵔⴰ ⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⴻⵏ ⵎⵎⵙⴰⴳⴰⵔⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","ⵉⴼⴼⵓⴳⴻⵎ ⵎⵓⵙⴰ ⴰⵟⵟⴰⵙ ⵅ ⵉⵎⴳⴻⵡⵡⴰⴷⴻⵏ ⵏ ⵍⵄⴻⵙⴽⴰⵔ, ⵅ ⵉⵎⴻⵇⵇⵔⴰⵏⴻⵏ ⵅ ⵡⴰⵍⴻⴼ ⵓ ⵅ ⵉⵎⴻⵇⵇⵔⴰⵏⴻⵏ ⵅ ⵎⵢⴰ, ⵉⵏⵏⵉ ⴷⴷ-ⵉⵄⴻⵇⴱⴻⵏ ⵣⴻⴳ ⵓⵎⴻⵏⵖⵉ. ");
INSERT INTO rift_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","ⵉⵏⵏⴰ ⴰⵙⴻⵏ ⵎⵓⵙⴰ: “ⵎⴰ ⵜⴻⵊⵊⵉⵎ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⴵⴰⵏ ⴷ ⵜⴰⵡⵜⴻⵏⵜ ⵉⴷⴷⴰⵔ? ");
INSERT INTO rift_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","ⵅⵣⴰⵔ, ⵙ ⵡⴻⵙⵛⴰⵏ ⵏ ⴱⴰⵍⵄⴰⵎ, ⵜⵉⵎⵖⴰⵔⵉⵏ-ⴰ ⵜⵓⵖⴰ ⴰⵜⴻⵏⵜ ⴷ ⵍⴻⵙⴱⴰⴱ ⴰⵇⴰ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵖⴷⴰⵔⴻⵏ ⵙⵉⴷⵉ ⴷⵉ ⵜⵎⴻⵙⵍⴰⵛⵜ ⵏ ⴼⴰⵖⵓⵔ ⵓⵛⴰ ⵜⴻⵡⴹⴰ-ⴷⴷ ⵊⵊⵔⵉⵃⴻⵛⵜ ⵅ ⵜⵎⴻⵙⵎⵓⵏⵜ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","ⵍⴻⵅⵅⵓ ⵅⴻⵏⵏⵉ, ⵏⵖⴻⵎ ⵎⴰⵔⵔⴰ ⵉⵡⴻⵜⵎⴰⵏ ⵏⵏⵉ ⵊⴰⵔ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵉⵎⴻⵥⵢⴰⵏⴻⵏ ⵓⵛⴰ ⵏⵖⴻⵎ ⵎⴰⵔⵔⴰ ⵜⴰⵎⵖⴰⵔⵜ ⵏⵏⵉ ⵉⵎⵓⵏⴻⵏ ⴰⴽ-ⴷ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⴰⵎ ⵜᵉⵟⵟⴻⵚ ⵏⴻⵜⵜⴰⵜ ⴰⴽ-ⴷ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ. ");
INSERT INTO rift_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","ⵎⴰⵛⴰ ⵎⴰⵔⵔⴰ ⵜⵉⵃⴻⵏⵊⵉⵔⵉⵏ ⵊⴰⵔ ⵜⴻⵎⵖⴰⵔⵉⵏ ⵏⵏⵉ ⵡⴰⵔ ⵉⵎⵓⵏⴻⵏ ⴰⴽ-ⴷ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⴰⵎ ⴰⴽⵉⴷⴻⵙ ⵟⵟⵚⴻⵏⵜ, ⵊⵊⴻⵎ ⵜⴻⵏⵜ ⵉ ⵢⵉⵅⴻⴼ ⵏⵡⴻⵎ ⴰⴷ ⴷⴷⴰⵔⴻⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⵡⴻⵎ ⴰⴷ ⵜⴻⵡⵜⴻⵎ ⵉⵇⵉⴹⴰⵏ ⵏⵡⴻⵎ ⴱⴰⵔⵔⴰ ⵉ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵍⵎⵉⵊⴰⵍ ⵏ ⵙⴻⴱⵄⴰ ⵏ ⵡⵓⵙⵙⴰⵏ. ⴽⵓⵍ ⵉⵊⵊⴻⵏ, ⵡⴻⵏⵏⵉ ⵉⵏⵖⵉⵏ ⵉⵊⵊ ⵏ ⵍⴻⵄⵎⴰⵔ ⵏ ⴱⵏⴰⴷⴻⵎ, ⵓ ⴽⵓⵍ ⵉⵊⵊⴻⵏ, ⵡⴻⵏⵏⵉ ⵉⵃⴰⴷⴰⵏ ⵉⵊⵊⴻⵏ ⵉ ⵉⵜⵜⵡⴰⵙⵙⵏⵓⵇⵇⴱⴻⵏ, ⴰⴷ ⵢⴻⵊⵊ ⴰⴷ ⴽⴽⵙⴻⵏ ⴷⴷⴻⵏⴱ ⵅ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵙ ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵜⵍⴰⵜⴰ ⵓ ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙ ⵙⴻⴱⵄⴰ, ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵜⴻⴳⴳⴻⵎ ⴽⴻⵏⵏⵉⵡ ⵓⵍⴰ ⴷ ⵉⵎⴻⵃⴱⴰⵙ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜⴻⴽⴽⵙⴻⵎ ⴷⴷⴻⵏⴱ ⵄⴰⵡⴻⴷ ⵅ ⵎⴰⵔⵔⴰ ⴰⵔⵔⵓⴹ ⴷ ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ ⵏ ⵉⵍⵎⴰⵡⴻⵏ ⴷ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⵜⵜⵡⴰⴳⴳⴻⵏ ⵙ ⵜⵀⵉⴹⵓⵔⵜ ⵏ ⵉⵖⴰⵢⴹ ⴷ ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ ⵏ ⵓⴽⴻⵛⵛⵓⴹ.” ");
INSERT INTO rift_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","ⴰⵍⵉⵄⴰⵣⴰⵔ, ⴰⴽⴻⵀⵀⴰⵏ, ⵉⵏⵏⴰ ⵉ ⵉⵄⴻⵙⴽⴰⵔⵉⵢⵢⴻⵏ ⵏⵏⵉ ⴷⴷ-ⵉⴼⴼⵖⴻⵏ ⵖⴰⵔ ⵓⵎⴻⵏⵖⵉ: “ⵜⴰ ⴷ ⵜⴰⵡⵚⴻⵢⵢⴻⵜ ⵣⵉ ⵛⵛⴰⵔⵉⵄⴰ ⵏⵏⵉ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ: ");
INSERT INTO rift_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","ⵎⵖⵉⵔ ⵓⵔⴻⵖ ⴷ ⵏⵏⵓⵇⴰⵔⵜ ⴷ ⵏⵏⵃⴰⵙ ⴷ ⵓⵣⵣⴰⵍ ⴷ ⵉⵙⵜⴰⵏⵢⵓ ⴷ ⵍⴻⵅⴼⵉⴼ, ");
INSERT INTO rift_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵉⵣⴻⵎⵎⴰⵔⴻⵏ ⵉ ⵜⵎⴻⵙⵙⵉ, ⵅ ⵜⵎⴻⵙⵙⵉ ⴰⴷ ⵜ ⵜⴻⵙⵙⴻⴽⴽⴻⵎ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵢⵉⵍⵉ ⵉⵣⴷⵉⴳ, ⵎⴰⵛⴰ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵣⵣⴰⵢⴻⵙ ⵜⴻⴽⴽⵙⴻⵎ ⴷⴷⴻⵏⴱ ⵙ ⵡⴰⵎⴰⵏ ⵏ ⵡⴻⵄⵣⴰⵍ. ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⵡⴰⵔ ⵉⵣⴻⵎⵎⴰⵔⴻⵏ ⵉ ⵜⵎⴻⵙⵙⵉ, ⴰⴷ ⵜ ⵜⴻⵙⵙⴻⴽⴽⴻⵎ ⵅ ⵡⴰⵎⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵙⴻⴱⵄⴰ ⴰⴷ ⵜⵚⴻⴱⴱⵏⴻⵎ ⴰⵔⵔⵓⴹ ⵏⵡⴻⵎ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜⵉⵍⵉⵎ ⴷ ⵉⵎⴻⵣⴷⴰⴳⴻⵏ. ⴰⵡⴰⵔⵏⵉ ⵓⵢⴰ ⵜⵣⴻⵎⵎⴰⵔⴻⵎ ⴰⴷ ⵜⴰⴷⴼⴻⵎ ⵖⴰⵔ ⵍⵎⴰⵔⴳⴻⵃ ⵏ ⵍⵄⴻⵙⴽⴰⵔ.” ");
INSERT INTO rift_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“ⵟⵟⴻⴼ ⵍⴻⵄⴱⴰⵔ ⵏ ⵜⴽⴻⵛⵛⴰⴹⵜ ⵏ ⵉⵡⴷⴰⵏ ⴷ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏⵏⵉ ⵜᵉⵜⵜⵡⴰⵃⴻⴱⴱⴻⵙ, ⵛⴻⴽ ⵊⵎⵉⵄ ⴰⴽ-ⴷ ⵓⴽⴻⵀⵀⴰⵏ ⴰⵍⵉⵄⴰⵣⴰⵔ ⵓ ⴰⴽ-ⴷ ⵉⵣⴻⴵⵉⴼⴻⵏ ⵏ ⵜⵓⴷⵔⵉⵏ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏ ⵜⵎⴻⵙⵎⵓⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","ⴱⴹⴰ ⵜⴰⴽⴻⵛⵛⴰⴹⵜ ⵅ ⵜⵏⴰⵢⴻⵏ ⵊⴰⵔ ⵉⵏⵏⵉ ⵉⵛⴰⵔⵛⴻⵏ ⴷⴻⴳ ⵓⵎⴻⵏⵖⵉ ⴷ ⵢⵉⵏⵏⵉ ⵉⴼⴼⵖⴻⵏ ⴰⴽ-ⴷ ⵍⵄⴻⵙⴽⴰⵔ ⵣⴻⴳ ⵉⵛⵜ ⵏ ⵊⵊⵉⵀⴻⵜ ⴷ ⵎⴰⵔⵔⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⵣⵉ ⵊⵊⵉⵀⴻⵜ ⵏⵏⴻⵖⵏⵉⵜ. ");
INSERT INTO rift_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","ⵙⴳⴻⵄⵄⴷⴻⵜ ⵉⵛⵜ ⵏ ⵚⵚⴻⴷⵇⴻⵜ ⵉ ⵙⵉⴷⵉ ⵣⴻⴳ ⵉⵄⴻⵙⴽⴰⵔⵉⵢⵢⴻⵏ ⵏⵏⵉ ⴷⴷ-ⵉⴼⴼⵖⴻⵏ ⵖⴰⵔ ⵓⵎⴻⵏⵖⵉ ⴰⴽ-ⴷ ⵍⵄⴻⵙⴽⴰⵔ: ⵉⵊⵊ ⵏ ⵍⴻⵄⵎⴰⵔ ⵣⵉ ⵅⴻⵎⵙⴰ ⵎⵢⴰ ⵏ ⵉⵡⴷⴰⵏ ⵓⵛⴰ ⴰⵎⴻⵏⵏⵉ ⵣⴻⴳ ⵉⴼⵓⵏⴰⵙⴻⵏ ⴷ ⵜⴼⵓⵏⴰⵙⵉⵏ ⵓ ⵣⴻⴳ ⵉⵖⵢⴰⵍ ⵓ ⵣⴻⴳ ⵡⵓⴵⵉ. ");
INSERT INTO rift_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","ⵣⴻⴳ ⵡⴻⵣⵢⴻⵏ ⵏⵙⴻⵏ ⵏ ⵜⴽⴻⵛⵛⴰⴹⵜ ⴰⴷ ⵜⴻⴽⵙⵉⴷ ⵚⵚⴻⴷⵇⴻⵜ-ⴰ ⵓⵛⴰ ⴰⴷ ⵜⵜ ⵜⴻⵡⵛⴻⴷ ⵉ ⵓⴽⴻⵀⵀⴰⵏ ⴰⵍⵉⵄⴰⵣⴰⵔ ⴰⵎ ⵉⵛⵜ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏ ⵓⵙⴳⴻⵄⵄⴻⴷ ⵉ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","ⵣⴻⴳ ⵡⴻⵣⵢⴻⵏ ⵏ ⵜⴽⴻⵛⵛⴰⴹⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴰⴷ ⵜⴻⴽⵙⵉⴷ ⵉⵊⵊ ⵣⵉ ⴽⵓⵍ ⵅⴻⵎⵙⵉⵏ: ⵣⴻⴳ ⵉⵡⴷⴰⵏ, ⵣⴻⴳ ⵉⴼⵓⵏⴰⵙⴻⵏ ⴷ ⵜⴼⵓⵏⴰⵙⵉⵏ, ⵣⴻⴳ ⵉⵖⵢⴰⵍ ⵓ ⵣⴻⴳ ⵡⵓⴵⵉ, ⵡⴰⵀ, ⵣⵉ ⵎⴰⵔⵔⴰ ⵍⴻⴱⵀⴰⵢⴻⵎ. ⴰⴷ ⵜⴻⵡⵛⴻⴷ ⴰⵢⴰ ⵉ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⵏⵏⵉ ⵉⵟⵟⴼⴻⵏ ⴰⵛⴱⴰⵔ ⵅ ⵜⵣⴻⴷⴷⵉⵖⵜ ⵏ ⵙⵉⴷⵉ.” ");
INSERT INTO rift_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","ⵓⵛⴰ ⵉⴳⴳⴰ ⵎⵓⵙⴰ ⴷ ⵓⴽⴻⵀⵀⴰⵏ ⴰⵍⵉⵄⴰⵣⴰⵔ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","ⴰⵡⴰⵔⵏⵉ ⴰⵙ ⵜⵓⵖⴰ ⵍⴻⴽⵙⵉⴱⴻⵜ ⵏⵏⵉ ⵉⵇⵇⵉⵎⴻⵏ ⵏ ⵜⴽⴻⵛⵛⴰⴹⵜ ⵏⵏⵉ ⵉⴽⴻⵛⵛⴻⴹ ⵍⴳⴻⵏⵙ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵙⴻⵜⵜⴰ-ⵎⵢⴰ ⵓ-ⵅⴻⵎⵙⴰ ⵓ-ⵙⴻⴱⵄⵉⵏ-ⴰⵍⴻⴼ ⵏ ⵡⵓⴵⵉ. ");
INSERT INTO rift_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","ⵜⵏⴰⵢⴻⵏ ⵓ-ⵙⴻⴱⵄⵉⵏ-ⴰⵍⴻⴼ ⵏ ⵉⴼⵓⵏⴰⵙⴻⵏ ⴷ ⵜⴼⵓⵏⴰⵙⵉⵏ, ");
INSERT INTO rift_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","ⵡⴰⵃⵉⵜ ⵓ-ⵙⴻⵜⵜⵉⵏ-ⴰⵍⴻⴼ ⵏ ⵉⵖⵢⴰⵍ ");
INSERT INTO rift_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","ⵓⵛⴰ ⵣⵉ ⵊⵊⵉⵀⴻⵜ ⵏ ⵍⴻⵄⵎⴰⵔ ⵏ ⴱⵏⴰⴷⴻⵎ, ⵣⵉ ⵜⴻⵎⵖⴰⵔⵉⵏ ⵏⵏⵉ ⵡⴰⵔ ⵉⵟⵟⵉⵚⴻⵏ ⴷⵉ ⵇⴰⵎⴰ ⴰⴽ-ⴷ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ, ⴰⵇⴰ ⴰⵜⴻⵏⵜ ⵎⴰⵔⵔⴰ ⵜⵏⴰⵢⴻⵏ ⵓ-ⵜⵍⴰⵜⵉⵏ-ⴰⵍⴻⴼ. ");
INSERT INTO rift_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","ⵉⵊⵊ ⵏ ⵡⴻⵣⵢⴻⵏ, ⵜⴰⵙⵖⴰⵔⵜ ⵏ ⵢⵉⵏⵏⵉ ⴷⴷ-ⵉⴼⴼⵖⴻⵏ ⴰⴽ-ⴷ ⵍⵄⴻⵙⴽⴰⵔ, ⴰⵇⴰ-ⵜ ⴷⵉ ⵜⴻⵍⵜ-ⵎⵢⴰ ⵓ-ⵙⴻⴱⵄⴰ ⵓ-ⵜⵍⴰⵜⵉⵏ-ⴰⵍⴻⴼ ⵏ ⵡⵓⴵⵉ. ");
INSERT INTO rift_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","ⵚⵚⴻⴷⵇⴻⵜ ⵉ ⵙⵉⴷⵉ ⵏ ⵡⵓⴵⵉ ⵜⵓⵖⴰ-ⵜⵜ ⴷⵉ ⵙⴻⵜⵜⴰ-ⵎⵢⴰ ⵓ-ⵅⴻⵎⵙⴰ ⵓ-ⵙⴻⴱⵄⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","ⵓⵛⴰ ⵜⵓⵖⴰ ⴷⵉⵏ ⵙⴻⵜⵜⴰ ⵓ-ⵜⵍⴰⵜⵉⵏ-ⴰⵍⴻⴼ ⵏ ⵉⴼⵓⵏⴰⵙⴻⵏ ⴷ ⵜⴼⵓⵏⴰⵙⵉⵏ ⵓⵛⴰ ⵚⵚⴻⴷⵇⴻⵜ ⵣⵣⴰⵢⵙⴻⵏ ⵉ ⵙⵉⴷⵉ ⵜⵓⵖⴰ-ⵜⵜ ⴷⵉ ⵜⵏⴰⵢⴻⵏ ⵓ-ⵙⴻⴱⵄⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","ⵓⵛⴰ ⵜⵓⵖⴰ ⴷⵉⵏ ⵜⵍⴰⵜⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⵅⴻⵎⵙⴰ-ⵎⵢⴰ ⵏ ⵉⵖⵢⴰⵍ ⵓⵛⴰ ⵚⵚⴻⴷⵇⴻⵏ ⵣⵣⴰⵢⵙⴻⵏ ⵉ ⵙⵉⴷⵉ, ⵡⴰⵃⵉⵜ ⵓ-ⵙⴻⵜⵜⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","ⵓⵛⴰ ⵣⵉ ⵊⵊⵉⵀⴻⵜ ⵏ ⵍⴻⵄⵎⵓⵔ ⵏ ⴱⵏⴰⴷⴻⵎ ⵜⵓⵖⴰ ⴷⵉⵏ ⵙⴻⵟⵟⴰⵛ-ⴰⵍⴻⴼ ⵏ ⵜⴻⵎⵖⴰⵔⵉⵏ ⵓ ⴰⵚⴻⴷⴷⴻⵇ ⵣⵣⴰⵢⵙⴻⵏⵜ ⵉ ⵙⵉⴷⵉ ⴰⵇⴰ ⵜⵏⴰⵢⴻⵏ ⵓ-ⵜⵍⴰⵜⵉⵏ ⵏ ⵜⴻⵎⵖⴰⵔⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","ⵉⵡⵛⴰ ⵎⵓⵙⴰ ⵚⵚⴻⴷⵇⴻⵜ, ⵜⴻⵏⵏⵉ ⴷ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵓⵙⴳⴻⵄⵄⴻⴷ ⵉ ⵙⵉⴷⵉ, ⵉ ⵓⴽⴻⵀⵀⴰⵏ ⴰⵍⵉⵄⴰⵣⴰⵔ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","ⵣⴻⴳ ⵡⴻⵣⵢⴻⵏ ⵏⵏⴻⵖⵏⵉ ⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵡⴻⵏⵏⵉ ⵉⴼⴰⵔⵣ ⵎⵓⵙⴰ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏⵙⴻⵏ ⵣⴻⴳ ⵢⴻⵔⵢⴰⵣⴻⵏ ⵏⵏⵉ ⵜⵓⵖⴰ ⵉⵎⵎⴻⵏⵖⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","- ⴰⵣⵢⴻⵏ ⵏⵏⵉ ⵏ ⵜⴻⵙⵖⴰⵔⵜ ⵉ ⵜⵎⴻⵙⵎⵓⵏⵜ ⵜⵓⵖⴰ-ⵜ ⴷⵉ ⵜⴻⵍⵜ-ⵎⵢⴰ ⵓ-ⵙⴻⴱⵄⴰ ⵓ-ⵜⵍⴰⵜⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⵅⴻⵎⵙⴰ ⵎⵢⴰ ⵏ ⵡⵓⴵⵉ, ");
INSERT INTO rift_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","ⵙⴻⵜⵜⴰ ⵓ-ⵜⵍⴰⵜⵉⵏ-ⴰⵍⴻⴼ ⵏ ⵉⴼⵓⵏⴰⵙⴻⵏ ⴷ ⵜⴼⵓⵏⴰⵙⵉⵏ, ");
INSERT INTO rift_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","ⵜⵍⴰⵜⵉⵏ-ⴰⵍⴻⴼ ⵓ-ⵅⴻⵎⵙⴰ-ⵎⵢⴰ ⵏ ⵢⴻⵖⵢⴰⵍ ");
INSERT INTO rift_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","ⵓⵛⴰ ⵙⴻⵟⵟⴰⵛ-ⴰⵍⴻⴼ ⵏ ⵍⴻⵄⵎⵓⵔ ⵏ ⵉⵡⴷⴰⵏ - ");
INSERT INTO rift_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","ⵣⴻⴳ ⵡⴻⵣⵢⴻⵏ ⵏⵏⵉ ⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵉⴽⵙⵉ ⵎⵓⵙⴰ ⵉⵊⵊ ⵣⵉ ⴽⵓⵍ ⵅⴻⵎⵙⵉⵏ, ⴰⵎⵎⵓ ⵣⴻⴳ ⵉⵡⴷⴰⵏ ⴰⵎ ⵣⵉ ⵍⴻⴱⵀⴰⵢⴻⵎ, ⵓⵛⴰ ⵉⵡⵛⴰ ⴰⵢⴰ ⵉ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ, ⵉⵏⵏⵉ ⵉⵟⵟⴼⴻⵏ ⴰⵛⴱⴰⵔ ⵅ ⵜⵣⴻⴷⴷⵉⵖⵜ ⵏ ⵙⵉⴷⵉ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","ⵅⴻⵏⵏⵉ ⵓⵙⵉⵏ-ⴷⴷ ⵉⴽⵓⵎⴰⵏⴷⴰⵔⴻⵏ ⵅ ⵍⵓⵍⵓⴼ ⵏ ⵍⵄⴻⵙⴽⴰⵔ, ⵉⵎⴻⵇⵇⵔⴰⵏⴻⵏ ⵅ ⵡⴰⵍⴻⴼ ⴷ ⵉⵎⴻⵇⵇⵔⴰⵏⴻⵏ ⵅ ⵎⵢⴰ, ⵖⴰⵔ ⵎⵓⵙⴰ, ");
INSERT INTO rift_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","ⵏⵏⴰⵏ ⵉ ⵎⵓⵙⴰ: “ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵛ ⴰⵇⴰ ⵃⴻⵙⴱⴻⵏ ⵎⴰⵔⵔⴰ ⵉⵄⴻⵙⴽⴰⵔⵉⵢⵢⴻⵏ ⵏⵏⵉ ⵙⴰⴷⵓ ⵓⴼⵓⵙ ⵏⵏⴻⵖ ⵓ ⵡⴰⵔ ⴷ ⴰⵏⴻⵖ ⵉⵔⵓⵃ ⵓⵍⴰ ⴷ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ. ");
INSERT INTO rift_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","ⵙ ⵓⵢⴰ ⵏⵉⵡⵉ ⵜⴰⵡⵀⵉⴱⵜ ⵏ ⵙⵉⴷⵉ, ⴽⵓⵍ ⵉⵊⵊ ⵎⵉⵏ ⵢⵓⴼⴰ: ⵉⵛⵜ ⵏ ⵍⵇⴻⵛⵄⴻⵜ ⵏ ⵡⵓⵔⴻⵖ, ⵉⵛⵜ ⵏ ⵜⵅⴻⵍⵅⴰⵍⵜ, ⵉⵛⵜ ⵏ ⵜⵎⴻⵇⵢⴰⵙⵜ, ⵉⵛⵜ ⵏ ⵜⵅⴰⵜⴻⵏⵜ ⵏ ⵓⵛⴻⵎⵎⵉⵄ, ⵉⵛⵜ ⵏ ⵜⴻⵅⵔⴰⵣⵜ ⵏⵉⵖ ⵉⵛⵜ ⵏ ⵜⵙⴻⴷⴷⴻⵛⵜ ⵙ ⵡⴻⴷⵎⴰⵎ ⵏ ⵡⵓⵔⴻⵖ, ⵃⵉⵎⴰ ⴰⴷ ⵣⵣⴰⵢⵙⴻⵏⵜ ⵉⵜⵜⵡⴰⴳⴳ ⵡⴻⵚⵍⴰⵃ ⵅ ⵍⴻⵄⵎⵓⵔ ⵏⵏⴻⵖ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ.” ");
INSERT INTO rift_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","ⵎⵓⵙⴰ ⴷ ⵓⴽⴻⵀⵀⴰⵏ ⴰⵍⵉⵄⴰⵣⴰⵔ ⴽⵙⵉⵏ ⵣⵣⴰⵢⵙⴻⵏ ⵓⵔⴻⵖ ⵏⵙⴻⵏ, ⵎⴰⵔⵔⴰ ⵍⴻⵇⵛⵓⵄ ⵉ ⴳⴳⵉⵏ ⵙ ⵍⴼⴻⵏⵏ. ");
INSERT INTO rift_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","ⵎⴰⵔⵔⴰ ⵓⵔⴻⵖ ⵏ ⵜⴻⵡⵀⵉⴱⵜ ⵏⵏⵉ ⵙⵙⴳⴻⵄⵄⴷⴻⵏ ⵉ ⵙⵉⴷⵉ ⵣⴻⴳ ⵉⵎⴻⵇⵇⵔⴰⵏⴻⵏ ⵅ ⵡⴰⵍⴻⴼ ⵓ ⵣⴻⴳ ⵉⵎⴻⵇⵇⵔⴰⵏⴻⵏ ⵅ ⵎⵢⴰ ⵜⵓⵖⴰ ⴷⵉ ⵙⴻⵟⵟⴰⵛ-ⴰⵍⴻⴼ ⵓ-ⵙⴻⴱⵄⴰ-ⵎⵢⴰ ⵓ-ⵅⴻⵎⵙⵉⵏ ⵛⵉⵇⵍⵓ. ");
INSERT INTO rift_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","ⵉⵄⴻⵙⴽⴰⵔⵉⵢⵢⴻⵏ ⴰⵇⴰ ⴽⴻⵛⵛⴹⴻⵏ ⴽⵓⵍ ⵉⵊⵊ ⵉ ⵢⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵎⵉⵏ ⵅⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","ⵎⵓⵙⴰ ⴷ ⵓⴽⴻⵀⵀⴰⵏ ⴰⵍⵉⵄⴰⵣⴰⵔ ⵟⵟⴼⴻⵏ ⵓⵔⴻⵖ ⵏⵏⵉ ⵏ ⵉⵎⴻⵇⵇⵔⴰⵏⴻⵏ ⵅ ⵡⴰⵍⴻⴼ ⵓ ⵅ ⵎⵢⴰ ⵓⵛⴰ ⵉⵡⵢⴻⵏ ⵜ ⵖⴰⵔ ⵓⵇⵉⴹⵓⵏ ⵏ ⵓⵎⵙⴰⴳⴰⵔ, ⴰⵎ ⵢⵉⵛⵜ ⵏ ⵍⵉⴷⴰⵔⴻⵜ ⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵏ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","ⴰⵢⵜ ⵏ ⵔⵓⴱⵉⵏ ⵖⴰⵔⵙⴻⵏ ⴰⵟⵟⴰⵙ ⵏ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵓ ⴰⵢⵜ ⵏ ⵊⴰⴷ ⵖⴰⵔⵙⴻⵏ ⴰⵟⵟⴰⵙ ⵙ ⵡⴰⵟⵟⴰⵙ ⵏ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵓⵛⴰ ⵏⵉⵜⵏⵉ ⵥⵔⵉⵏ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵢⴰⵄⵣⵉⵔ ⴷ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵊⵉⵍⵄⴰⴷ, ⵓⵛⴰ ⵅⵣⴰⵔ, ⵊⵊⵉⵀⴻⵜ ⵏⵏⵉ ⵜⴻⵛⵏⴰ ⵉ ⵍⴻⴱⵀⴰⵢⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","ⵓⵙⵉⵏ-ⴷⴷ ⴰⵢⵜ ⵏ ⵊⴰⴷ ⵓ ⴰⵢⵜ ⵏ ⵔⵓⴱⵉⵏ, ⵙⵙⵉⵡⵍⴻⵏ ⴰⴽ-ⴷ ⵎⵓⵙⴰ ⴷ ⵓⴽⴻⵀⵀⴰⵏ ⴰⵍⵉⵄⴰⵣⴰⵔ ⵓ ⴰⴽ-ⴷ ⵍⵃⵓⴽⴽⴰⵎ ⵏ ⵜⵎⴻⵙⵎⵓⵏⵜ, ⵏⵏⴰⵏ: ");
INSERT INTO rift_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“ⵄⴰⵟⴰⵔⵓⵜ, ⴷⵉⴱⵓⵏ, ⵢⴰⵄⵣⵉⵔ, ⵏⵉⵎⵔⴰ, ⵃⴰⵛⴱⵓⵏ, ⴰⵍⵉⵄⴰⵍⴰ, ⵛⴰⴱⴰⵎ, ⵏⴰⴱⵓ ⴷ ⴱⴰⵄⵓⵏ, ");
INSERT INTO rift_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","ⵜⴰⵎⵎⵓⵔⵜ ⵏⵏⵉ ⵅ ⵉⵖⵍⴻⴱ ⵙⵉⴷⵉ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵜⵎⴻⵙⵎⵓⵏⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⴰⵇⴰ-ⵜⵜ ⴷ ⵉⵛⵜ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵜⴻⵛⵏⴰ ⵉ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵓ ⵏⴻⵛⵛⵉⵏ, ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵛ ⵖⴰⵔⵙⴻⵏ ⵍⴻⴱⵀⴰⵢⴻⵎ.” ");
INSERT INTO rift_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","ⵏⵏⴰⵏ: “ⵎⴰⵍⴰ ⵏⵓⴼⴰ ⴰⵔⴹⴰ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵏⴻⵛ, ⵎⴰ ⵣⴻⵄⵎⴰ ⴰⴷ ⵜⴻⵎⵎⴻⵡⵛ ⵜⴻⵎⵎⵓⵔⵜ-ⴰ ⴷ ⴰⴳⵍⴰ ⵉ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵛ ⵓ ⵡⴰⵔ ⴷ ⴰⵏⴻⵖ ⵜⵜⴻⵊⵊⵉ ⴰⴷ ⵏⴻⵥⵡⴰ ⵍ’ⵓⵔⴷⵓⵏ.” ");
INSERT INTO rift_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","ⵢⴰⵔⵔⴰ-ⴷⴷ ⵎⵓⵙⴰ ⵅ ⴰⵢⵜ ⵏ ⵊⴰⴷ ⵓ ⵅ ⴰⵢⵜ ⵏ ⵔⵓⴱⵉⵏ: “ⵎⴰⵍⴰ ⴰⵢⵜⵎⴰⵜⵡⴻⵎ ⴰⴷ ⴷⴷ-ⴼⴼⵖⴻⵏ ⵖⴰⵔ ⴳⴰⵔⵔⴰ, ⵎⴰ ⵅⴻⵏⵏⵉ ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⵜⴻⵇⵇⵉⵎⴻⵎ ⴷⴰ? ");
INSERT INTO rift_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","ⵎⴰⵢⴻⵎⵎⵉ ⵖⴰ ⵜⴻⵙⵙⵄⴻⴳⵣⴻⵎ ⵓⵍ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵎⴰⵃⴻⵏⴷ ⵡⴰⵔ ⵥⴻⴽⴽⵯⵉⵏ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵉ ⴷ ⴰⵙⴻⵏ ⵉⵡⵛⴰ ⵙⵉⴷⵉ? ");
INSERT INTO rift_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","ⴰⵎⵎⵓ ⵉ ⴳⴳⵉⵏ ⵍⴻⵊⴷⵓⴷ ⵏⵡⴻⵎ ⵓⵎⵉ ⵜⴻⵏ ⵙⵙⴻⴽⴽⴻⵖ ⵣⵉ ⵇⴰⴷⴰⵛ-ⴱⴰⵔⵏⵉⵄ ⵃⵉⵎⴰ ⵅⴻⵏⵏⵉ ⴰⴷ ⵥⴰⵔⴻⵏ ⵜⴰⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","ⵉⵡⴹⴻⵏ ⵏⵉⵜⵏⵉ ⵖⴰⵔ ⵜⴻⵖⵣⵓⵔⵜ ⵏ ⵜⴻⵖⵣⴰⵔⵜ ⵏ ⵉⵛⴽⵓⵍ ⵓⵛⴰ ⵥⵔⵉⵏ ⵜⴰⵎⵎⵓⵔⵜ ⵓⵛⴰ ⵇⴻⵍⴱⴻⵏ ⵓⵍⴰⵡⴻⵏ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵎⴰⵃⴻⵏⴷ ⵡⴰⵔ ⵜⵜⵉⴷⴼⴻⵏ ⵛⴰ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵉ ⴷ ⴰⵙⴻⵏ ⵉⵡⵛⴰ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","ⴷⴻⴳ ⵡⴰⵙⵙ ⵏⵏⵉ ⵢⴰⵔⵖⴰ ⵡⴻⵖⴹⴰⴱ ⵏ ⵙⵉⴷⵉ ⵓⵛⴰ ⵉⵊⵊⵓⴵ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘ⵉⵔⵢⴰⵣⴻⵏ ⵏⵏⵉ ⴷⴷ-ⵉⴼⴼⵖⴻⵏ ⵣⵉ ⵎⵉⵚⵔⴰ, ⵣⵉ ⵄⵉⵛⵔⵉⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵙⴻⵏⵏⴻⵊ, ⵡⴰⵔ ⵥⴰⵔⵔⴻⵏ ⵜⴰⵎⵎⵓⵔⵜ ⵏⵏⵉ ⵅ ⵊⵊⵓⴵⴻⵖ ⴰⴷ ⵜⵜ ⵡⵛⴻⵖ ⵉ ⵉⴱⵔⴰⵀⵉⵎ ⴷ ⵉⵙⵃⴰⵇ ⴷ ⵢⴰⵄⵇⵓⴱ, ⵎⵉⵏⵣⵉ ⵏⵉⵜⵏⵉ ⵡⴰⵔ ⴷ ⴰⵢⵉ ⴹⴼⴰⵔⴻⵏ ⵏⵉⵛⴰⵏ, ");
INSERT INTO rift_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","ⵎⵖⵉⵔ ⴽⴰⵍⵉⴱ, ⵎⵎⵉⵙ ⵏ ⵢⴰⴼⵓⵏⵏⵉ, ⴰⵇⵉⵏⵉⵣⵉ, ⴷ ⵢⴰⵛⵓⵡⴰ, ⵎⵎⵉⵙ ⵏ ⵏⵓⵏ, ⵎⵉⵏⵣⵉ ⵏⵉⵜⵏⵉ ⴹⴼⴰⵔⴻⵏ ⵏⵉⵛⴰⵏ ⵉ ⵙⵉⴷⵉ.’ ");
INSERT INTO rift_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","ⵓⵛⴰ ⴰⵎⵎⵓ ⵢⴰⵔⵖⴰ ⵡⴻⵖⴷⴰⴱ ⵏ ⵙⵉⴷⵉ ⵅ ⵉⵙⵔⴰⵉⵍ ⵓⵛⴰ ⵉⴳⴳⴰ ⵉ-ⵜⴻⵏ ⴰⴷ ⵜⴻⵍⵍⵄⴻⵏ ⴷⵉ ⵍⴻⵅⵍⴰ ⴰⵔⴻⴱⵄⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ, ⴰⵍⴰⵎⵉ ⵉⴼⵏⴰ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍ ⵏⵏⵉ ⵉⴳⴳⵉⵏ ⵍⵖⴰⵔ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵙⵉⴷⵉ, ");
INSERT INTO rift_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","ⵓⵛⴰ ⵅⵣⴰⵔ, ⴽⴻⵏⵏⵉⵡ ⵜⵖⴻⵡⵡⵖⴻⵎ ⴰⵎ ⵍⴻⵊⴷⵓⴷ ⵏⵡⴻⵎ, ⴽⴻⵏⵏⵉⵡ ⴷ ⵉⵊⵊ ⵏ ⵓⴱⴰⵔⵔⵓ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ ⴷ ⵉⵎⴻⴷⵏⴰⴱ, ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵜⴰⵔⵏⵉⵎ ⵄⴰⴷ ⵍⵃⴰⴷⵓⵇ ⵏ ⵡⴻⵖⴹⴰⴱ ⵏ ⵙⵉⴷⵉ ⵅ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","ⵎⴰⵍⴰ ⵜⴷⴻⵡⵍⴻⵎ-ⴷⴷ ⴽⴻⵏⵏⵉⵡ ⵣⵉ ⴹⴻⴼⴼⴰⵔ ⵏⵏⴻⵙ, ⵏⴻⵜⵜⴰ ⴰⴷ ⵢⴻⵊⵊ ⵍⴳⴻⵏⵙ ⴷⵉ ⵍⴻⵅⵍⴰ ⵄⴰⵡⴻⴷ ⵓⵛⴰ ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵜⴻⵊⵊⴻⵎ ⵎⴰⵔⵔⴰ ⵍⴳⴻⵏⵙ ⴰⵢⴰ ⴰⴷ ⵉⵀⴻⵍⵍⴻⴽ.” ");
INSERT INTO rift_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","ⵅⴻⵏⵏⵉ ⵇⴰⵔⵔⴱⴻⵏ-ⴷⴷ ⵖⴰⵔⴻⵙ, ⵏⵏⴰⵏ: “ⴰⴷ ⵏⴻⴱⵏⴰ ⴷⴰ ⵍⴽⵓⵔⵉⵢⵢⴰⵜ ⵉ ⵡⵓⴵⵉ ⵏⵏⴻⵖ ⵓ ⵜⵉⵏⴻⴷⴷⴰⵎ ⵉ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵖ, ");
INSERT INTO rift_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","ⵎⴰⵛⴰ ⵏⴻⵛⵛⵉⵏ ⴰⴷ ⴷⴷ-ⵏⴻⴼⴼⴻⵖ ⵏⴻⵡⵊⴻⴷ ⵉ ⵓⵎⴻⵏⵖⵉ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵙ ⵍⴻⵙⵏⴰⵃ ⵏⵏⴻⵖ, ⴰⵍⴰⵎⵉ ⵜⴻⵏ ⵏⴻⵙⵙⵉⵡⴻⴹ ⵖⴰⵔ ⵡⴻⵎⵛⴰⵏ ⵏⵙⴻⵏ. ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵖ ⴰⴷ ⵇⵇⵉⵎⴻⵏ ⴷⵉ ⵜⵏⴻⴷⴷⴰⵎ ⵉⴼⴰⵔⵢⴻⵏ ⵣⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏ ⵉⵎⴻⵣⴷⴰⵖ ⵏ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","ⵡⴰⵔ ⵏᵉⴷⴷⴻⴽⴽⵡⵉⵍ ⵖⴰⵔ ⵜⵓⴷⵔⵉⵏ ⵏⵏⴻⵖ ⴰⵍ ⵉ ⵖⴰ ⵜⴻⵎⵎⴻⵡⵛ ⵜⴻⵙⵖⴰⵔⵜ ⵏ ⵍⵡⴰⵔⵜ ⵉ ⴽⵓⵍ ⵉⵊⵊ ⵣⴻⴳ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","ⵎⵉⵏⵣⵉ ⵡⴰⵔ ⵏⵜⴻⵟⵟⴻⴼ ⴷⵉ ⵍⵡⴰⵔⵜ ⴰⴽⵉⴷⵙⴻⵏ ⵖⴰⵔ ⵜⵎⴰ ⵏⵏⴻⵖⵏⵉ ⵏ ⵍ’ⵓⵔⴷⵓⵏ ⵓⵍⴰ ⵖⴰⵔ ⵣⵣⴰⵜ, ⵎⵉⵏⵣⵉ ⵜⴰⵙⵖⴰⵔⵜ ⵉ ⴷ ⴰⵏⴻⵖ ⴷⴷ-ⵉⵜⵜⴰⵙⴻⵏ ⴰⵇⴰ-ⵜⵜ ⵖⴰⵔ ⵜⵎⴰ-ⵢⴰ ⵜⴰⵏⵉⵜⴰ ⵏ ⵍ’ⵓⵔⴷⵓⵏ, ⵖⴰⵔ ⵛⵛⴰⵔⵇ.” ");
INSERT INTO rift_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⴰⵙⴻⵏ ⵎⵓⵙⴰ: “ⵎⴰⵍⴰ ⵜⴻⴳⴳⵉⵎ ⴰⵎⵎⵓ, ⵎⴰⵍⴰ ⵜⴻⵙⵙⵡⴻⵊⴷⴻⵎ ⵉⵅⴻⴼ ⵏⵡⴻⵎ ⵉ ⵓⵎⴻⵏⵖⵉ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ, ");
INSERT INTO rift_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","ⵓ ⴽⵓⵍ ⵉⵊⵊ, ⵡⴻⵏⵏⵉ ⵉⵙⵙⵡⴻⵊⴷⴻⵏ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵉ ⵓⵎⴻⵏⵖⵉ, ⴰⴷ ⵉⵥⵡⴰ ⵍ’ⵓⵔⴷⵓⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ, ⴰⵍ ⵏⴻⵜⵜⴰ ⴰⴷ ⵢⴰⵥⵥⴻⵍ ⵅ ⵍⵄⴻⴷⵢⴰⵏ ⵏⵏⴻⵙ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏⵏⴻⵙ ⵣⵉ ⵜⴻⵙⵖⴰⵔⵜ ⵏⵙⴻⵏ ⵏ ⵍⵡⴰⵔⵜ, ");
INSERT INTO rift_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","ⵓ ⴰⴷ ⵜⵉⵍⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵜᵉⵜⵜⵡⴰⵅⴹⴻⵄ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ, ⵅⴻⵏⵏⵉ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⴷⴷ-ⵜⴷⴻⵡⵍⴻⵎ ⵓ ⴰⴷ ⵜⵉⵍⵉⵎ ⵜⴱⴻⴷⴷⴻⵎ ⵣⵣⴰⵜ ⵉ ⵙⵉⴷⵉ ⵓ ⵣⵣⴰⵜ ⵉ ⵉⵙⵔⴰⵉⵍ ⴱⵍⴰ ⴰⵎⴰⵔⵡⴰⵙ ⵓ ⴰⴷ ⵜⵉⵍⵉ ⵜⴻⵎⵎⵓⵔⵜ-ⴰ ⴷ ⴰⴳⵍⴰ ⵏⵡⴻⵎ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ");
INSERT INTO rift_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⵡⴰⵔ ⵜⴻⴳⴳⵉⵎ ⴰⵎⵎⵓ, ⵅⴻⵏⵏⵉ ⴰⵇⴰ ⵜⴻⵅⴹⴰⵎ ⴹⵉⴷⴷ ⵉ ⵙⵉⴷⵉ ⵓⵛⴰ ⴰⴷ ⵜⴻⵙⵙⵏⴻⵎ ⴰⵇⴰ ⴷⴷⴻⵏⴱ ⵏⵡⴻⵎ ⴰⴷ ⴽⴻⵏⵏⵉⵡ ⵢⴰⴼ. ");
INSERT INTO rift_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","ⴱⵏⴰⵎ ⵜⵉⵏⴻⴷⴷⴰⵎ ⵉ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵡⴻⵎ ⴷ ⵍⴽⵓⵔⵉⵢⵢⴰⵜ ⵉ ⵡⵓⴵⵉ ⵏⵡⴻⵎ ⵓⵛⴰ ⴳⴳⴻⵎ ⵎⵉⵏ ⴷⴷ-ⵉⴼⴼⵖⴻⵏ ⵣⴻⴳ ⵓⵇⴻⵎⵎⵓⵎ ⵏⵡⴻⵎ.” ");
INSERT INTO rift_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","ⵅⴻⵏⵏⵉ ⵙⵙⵉⵡⵍⴻⵏ ⴰⵢⵜ ⵏ ⵊⴰⴷ ⴷ ⴰⵢⵜ ⵏ ⵔⵓⴱⵉⵏ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵏⵏⴰⵏ: “ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵛ ⴰⴷ ⴳⴳⴻⵏ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⴻⵏ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉⵏⵓ. ");
INSERT INTO rift_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","ⵜⴰⵔⵡⴰ ⵏⵏⴻⵖ, ⵜⵉⵎⵖⴰⵔⵉⵏ ⵏⵏⴻⵖ, ⵍⴻⴽⵙⵉⴱⴻⵜ ⵏⵏⴻⵖ ⴷ ⵎⴰⵔⵔⴰ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏⵏⴻⵖ ⴰⴷ ⵇⵇⵉⵎⴻⵏ ⴷⵉ ⵜⵏⴻⴷⴷⴰⵎ ⵏ ⵊⵉⵍⵄⴰⴷ, ");
INSERT INTO rift_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","ⵎⴰⵛⴰ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵛ ⴰⴷ ⵥⵡⴰⵏ ⵉ ⵓⵎⴻⵏⵖⵉ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ, ⵎⴰⵔⵔⴰ ⵉⵏⵏⵉ ⵉⵙⵙⵡⴻⵊⴷⴻⵏ ⵉⵅⴻⴼ ⵏⵙⴻⵏ ⵉ ⵓⵎⴻⵏⵖⵉ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⵉⵏⵓ.” ");
INSERT INTO rift_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","ⵓⵛⴰ ⵢⵓⵎⵓⵔ ⵅⴰⵙⴻⵏ ⵎⵓⵙⴰ ⵉ ⵓⴽⴻⵀⵀⴰⵏ ⴰⵍⵉⵄⴰⵣⴰⵔ ⵓ ⵉ ⵢⴰⵛⵓⵡⴰ, ⵎⵎⵉⵙ ⵏ ⵏⵓⵏ, ⵓ ⵉ ⵉⵣⴻⴵⵉⴼⴻⵏ ⵏ ⵜⵓⴷⵔⵉⵏ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏ ⵜⵇⴻⴱⴱⴰⵍ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ");
INSERT INTO rift_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","ⵉⵏⵏⴰ ⴰⵙⴻⵏ ⵎⵓⵙⴰ: “ⵎⴰⵍⴰ ⴰⵢⵜ ⵏ ⵊⴰⴷ ⴷ ⴰⵢⵜ ⵏ ⵔⵓⴱⵉⵏ ⴰⴷ ⴽⵉⵡⴻⵎ ⵥⵡⴰⵏ ⵍ’ⵓⵔⴷⵓⵏ, ⴽⵓⵍ ⵉⵊⵊ ⵡⴻⵏⵏⵉ ⵉⵙⵙⵡⴻⵊⴷⴻⵏ ⵉⵅⴻⴼ ⵏⵏⴻⵙ ⵉ ⵓⵎⴻⵏⵖⵉ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ, ⵓ ⵎⴰⵍⴰ ⵅⴻⵏⵏⵉ ⵜⴰⵎⵎⵓⵔⵜ ⴰⴷ ⵜⵉⵍⵉ ⵜᵉⵜⵜⵡⴰⵅⴹⴻⵄ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏⵡⴻⵎ, ⴰⴷ ⵜⴰⴼ ⴰⴷ ⴰⵙⴻⵏ ⵜⴻⵡⵛⴻⵎ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⵊⵉⵍⵄⴰⴷ ⴷ ⴰⴳⵍⴰ. ");
INSERT INTO rift_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⵡⴰⵔ ⴽⵉⵡⴻⵎ ⵥⴻⴽⴽⵯⵉⵎ ⵡⴻⵊⴷⴻⵏ ⵉ ⵓⵎⴻⵏⵖⵉ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵟⵟⴼⴻⵏ ⴰⴳⵍⴰ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏⵡⴻⵎ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ.” ");
INSERT INTO rift_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","ⴰⵢⵜ ⵏ ⵊⴰⴷ ⴷ ⴰⵢⵜ ⵏ ⵔⵓⴱⵉⵏ ⴰⵔⵔⵉⵏ-ⴷⴷ, ⵏⵏⴰⵏ: “ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵉⵎⵙⴻⵅⵅⴰⵔⴻⵏ ⵏⵏⴻⵛ, ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵏⴻⴳⴳ. ");
INSERT INTO rift_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","ⵏⴻⵛⵛⵉⵏ ⴰⴷ ⵏⴻⵥⵡⴰ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ ⴰⴷ ⵏⵉⵍⵉ ⵏⴻⵡⵊⴻⴷ ⵉ ⵓⵎⴻⵏⵖⵉ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ, ⵎⴰⵛⴰ ⵜⴰⵙⵖⴰⵔⵜ ⵏⵏⴻⵖ ⵏ ⵍⵡⴰⵔⵜ ⴰⴷ ⵜⵉⵍⵉ ⵖⴰⵔ ⵜⵎⴰ-ⵢⴰ ⵡⴰⵏⵉⵜⴰ ⵏ ⵍ’ⵓⵔⴷⵓⵏ.” ");
INSERT INTO rift_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","ⵓ ⵉⵡⵛⴰ ⴰⵙⴻⵏ ⵎⵓⵙⴰ, ⵉ ⴰⵢⵜ ⵏ ⵊⴰⴷ ⵓ ⵉ ⴰⵢⵜ ⵏ ⵔⵓⴱⵉⵏ ⵓ ⵉ ⵡⴻⵣⵢⴻⵏ ⵏ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⵎⴰⵏⴰⵙⵙⴰ, ⵎⵎⵉⵙ ⵏ ⵢⵓⵙⵓⴼ, ⵜⴰⴳⴻⵍⴷⵉⵜ ⵏ ⵙⵉⵃⵓⵏ, ⴰⵊⴻⴵⵉⴷ ⵏ ⵉⵎⵓⵔⵉⵢⵢⴻⵏ, ⴷ ⵜⴳⴻⵍⴷⵉⵜ ⵏ ⵄⵓⵊ, ⴰⵊⴻⴵⵉⴷ ⵏ ⴱⴰⵛⴰⵏ, ⵜⴰⵎⵎⵓⵔⵜ ⵙ ⵜⵏⴻⴷⴷⴰⵎ ⵏⵏⴻⵙ ⵏⵏⵉ ⵉⴵⴰⵏ ⴷⵉ ⵊⵊⵡⴰⵢⴻⵀ ⵏⵏⴻⵙ ⵓⵍⴰ ⴷ ⵜⵉⵏⴻⴷⴷⴰⵎ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵉ ⴷ ⴰⵙ ⴷⴷ-ⵉⵏⵏⴹⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","ⴰⵢⵜ ⵏ ⵊⴰⴷ ⴱⵏⴰⵏ ⴷⵉⴱⵓⵏ, ⵄⴰⵟⴰⵔⵓⵜ, ⵄⴰⵔⵓⵄⵉⵔ, ");
INSERT INTO rift_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","ⵄⴰⵟⵔⵓⵜ-ⵛⵓⴼⴰⵏ, ⵢⴰⵄⵣⵉⵔ, ⵢⵓⵊⴱⴰⵀⴰ, ");
INSERT INTO rift_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","ⴱⴰⵢⵜ-ⵏⵉⵎⵔⴰ ⴷ ⴱⴰⵢⵜ-ⵀⴰⵔⴰⵏ, ⵜⵉⵏⴻⴷⴷⴰⵎ ⵉⴼⴰⵔⵢⴻⵏ ⴷ ⵍⴽⵓⵔⵉⵢⵢⴰⵜ ⵉ ⵡⵓⴵⵉ. ");
INSERT INTO rift_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","ⴰⵢⵜ ⵏ ⵔⵓⴱⵉⵏ ⴱⵏⴰⵏ ⵃⴰⵛⴱⵓⵏ, ⴰⵍⵉⵄⴰⵍⴰ, ⵇⴰⵔⵢⴰⵜⴰⵢⵉⵎ, ");
INSERT INTO rift_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","ⵏⴰⴱⵓ, ⴱⴰⵄⵍ-ⵎⴰⵄⵓⵏ, ⵜⴻⵏⵏⵉ ⵣⵉ ⵉⵜⵜⵡⴰⴱⴻⴷⴷⴻⵍ ⵉⵙⴻⵎ ⵏⵙⴻⵏ, ⴷ ⵙⵉⴱⵎⴰ, ⵓⵛⴰ ⵍⴰⵖⴰⵏ ⵉⵙⵎⴰⵡⴻⵏ ⵏ ⵜⵏⴻⴷⴷⴰⵎ ⵉ ⴱⵏⴰⵏ ⵄⴰⵡⴻⴷ ⵙ ⵢⵉⵙⴻⵎ ⵏⵏⴻⵖⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","ⴰⵢⵜ ⵏ ⵎⴰⴽⵉⵔ, ⵎⵎⵉⵙ ⵏ ⵎⴰⵏⴰⵙⵙⴰ, ⵔⵓⵃⴻⵏ ⵖⴰⵔ ⵊⵉⵍⵄⴰⴷ ⵓⵛⴰ ⵟⵟⴼⴻⵏ ⵜⵜ ⵓⵛⴰ ⵓⵥⵥⵍⴻⵏ ⵅ ⵉⵎⵓⵔⵉⵢⵢⴻⵏ ⵏⵏⵉ ⴷⵉⵏ ⵉⴵⴰⵏ ⵣⵉ ⵍⵡⴰⵔⵜ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","ⵓⵛⴰ ⵎⵓⵙⴰ ⵉⵡⵛⴰ ⵊⵉⵍⵄⴰⴷ ⵉ ⵎⴰⴽⵉⵔ, ⵎⵎⵉⵙ ⵏ ⵎⴰⵏⴰⵙⵙⴰ, ⵓⵛⴰ ⵉⵔⵓⵃ ⵏⴻⵜⵜⴰ ⴰⴷ ⵉⵣⴷⴻⵖ ⴷⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","ⵓⵛⴰ ⵢⴰ’ⵉⵔ, ⵎⵎⵉⵙ ⵏ ⵎⴰⵏⴰⵙⵙⴰ, ⵉⵔⵓⵃ ⵓⵛⴰ ⵉⵟⵟⴻⴼ ⴷⵛⵓⵔⴰⵜ ⵏⵏⴻⵙ ⵓⵛⴰ ⵉⵍⴰⵖⴰ ⴰⵙⴻⵏⵜ ⴷⵛⵓⵔⴰⵜ ⵏ ⵢⴰ’ⵉⵔ. ");
INSERT INTO rift_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","ⴰⵎⴻⵏⵏⵉ ⵉⵔⵓⵃ ⵏⵓⴱⴰⵃ ⵓⵛⴰ ⵉⵟⵟⴻⴼ ⵇⵉⵏⴰⵜ ⴷ ⵜⵏⴻⴷⴷⴰⵎ ⵉ ⵖⴰⵔⴻⵙ ⴷⴷ-ⵉⵇⵇⵏⴻⵏ ⵓⵛⴰ ⵉⵙⴻⵎⵎⴰ ⴰⵙ ⵏⵓⴱⴰⵃ ⵙ ⵢⵉⵙⴻⵎ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","ⴰⵎⵎⵓ ⵉ ⵙⵙⵎⵎⵓⵟⵟⵉⵢⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵉⵏⵏⵉ ⴷⴷ-ⵉⴼⴼⵖⴻⵏ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ, ⵣⴻⴳ ⵡⴻⵎⵛⴰⵏ ⵖⴰⵔ ⵡⴻⵎⵛⴰⵏ, ⴰⵎ ⵜⵜⵡⴰⵙⴻⵜⵜⴼⴻⵏ ⵏⵉⵜⵏⵉ ⵄⵍⴰⵃⵙⴰⴱ ⵜⵉⵔⴱⵉⵄⵉⵏ ⵏ ⵍⵄⴻⵙⴽⴰⵔ ⵏⵙⴻⵏ, ⵙ ⵓⴼⵓⵙ ⵏ ⵎⵓⵙⴰ ⴷ ⵀⴰⵔⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","ⵅ ⵍⵓⵎⵓⵔ ⵏ ⵙⵉⴷⵉ ⵢⵓⵔⴰ ⵎⵓⵙⴰ ⵉⵎⵓⵛⴰⵏ ⵎⴰⵏⵉⵙ ⴷⴷ-ⴼⴼⵖⴻⵏ ⴰⴽ-ⴷ ⵉⵔⴻⵃⵃⴰⵍⴻⵏ ⵏⵙⴻⵏ. ⵉⵏⴰ ⴷ ⵉⵔⴻⵃⵃⴰⵍⴻⵏ ⵏⵙⴻⵏ ⴰⴽ-ⴷ ⵉⵎⵓⵛⴰⵏ ⵎⴰⵏⵉⵙ ⴷⴷ-ⴼⴼⵖⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⵔⴰⵄⴰⵎⵙⵉⵙ ⴷⴻⴳ ⵓⵢⵓⵔ ⴰⵎⴻⵣⵡⴰⵔⵓ, ⴷⴻⴳ ⵡⴰⵙⵙ ⵡⵉⵙⵙ ⵅⴻⵎⵎⴻⵙⵟⴰⵛ ⵏ ⵓⵢⵓⵔ ⴰⵎⴻⵣⵡⴰⵔⵓ. ⴷⵉ ⵚⵚⴱⴻⵃ, ⴷⴻⵖⵢⴰ ⴰⵡⴰⵔⵏⵉ ⵉ ⵜⵖⴰⵔⵚⵜ ⵏ ⵓⵙⴻⵄⴷⵓ ⴼⴼⵖⴻⵏ-ⴷⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵙ ⵢⵉⵊⵊ ⵏ ⵓⴼⵓⵙ ⵉⵜⵜⵡⴰⵙⵙⴳⴻⵄⵄⴷⴻⵏ ⵣⵣⴰⵜ ⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏ ⵎⴰⵔⵔⴰ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","ⵓⵎⵉ ⵜⵓⵖⴰ ⵛⴻⵖⵍⴻⵏ ⵉⵎⵉⵚⵔⵉⵢⵢⴻⵏ ⵏⴻⵟⵟⵍⴻⵏ ⵎⴰⵔⵔⴰ ⵉⵎⴻⵏⵣⴰ ⵏⵙⴻⵏ, ⵉⵏⵏⵉ ⵉⵡⵜⴰ ⵙⵉⴷⵉ ⵙ ⵍⵎⴻⵡⵜ ⵊⴰⵔ ⴰⵙⴻⵏ. ⵄⴰⵡⴻⴷ ⵉⵙⵙⵉⵡⴻⴹ ⵙⵉⴷⵉ ⵍⴻⵃⴽⴰⵎ ⵏⵏⴻⵙ ⵅ ⵉⵔⴻⴱⴱⵉⵜⴻⵏ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","ⴼⴻⵙⵢⴻⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⵔⴰⵄⴰⵎⵙⵉⵙ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⵙⵓⴽⴽⵓⵜ. ");
INSERT INTO rift_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⵙⵓⴽⴽⵓⵜ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⵉⵜⴰⵎ ⵖⴰⵔ ⵜⵎⴰ ⵏ ⵍⴻⵅⵍⴰ. ");
INSERT INTO rift_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⵉⵜⴰⵎ ⵓⵛⴰ ⴷⴻⵡⵍⴻⵏ-ⴷⴷ ⵖⴰⵔ ⴱⵉ-ⵀⴰⵃⵉⵔⵓⵜ ⵏⵏⵉ ⵉⴵⴰⵏ ⴰⵔⴻⵏⴷⴰⴷ ⵏ ⴱⴰⵄⵍ-ⵚⴰⴼⵓⵏ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵎⴰⵊⴷⴰⵍ. ");
INSERT INTO rift_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⴱⵉ-ⵀⴰⵃⵉⵔⵓⵜ ⵓⵛⴰ ⵛⵓⴽⴽⴻⵏ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏ ⵍⴻⴱⵃⴰⵔ ⵖⴰⵔ ⵍⴻⵅⵍⴰ ⵓⵛⴰ ⵓⵢⵓⵔⴻⵏ ⵜⵉⵛⵍⵉ ⵏ ⵜⵍⴰⵜⴰ ⵏ ⵡⵓⵙⵙⴰⵏ ⴷⵉ ⵍⴻⵅⵍⴰ ⵏ ⵉⵜⴰⵎ, ⵅⴻⵏⵏⵉ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⵎⴰⵔⴰ. ");
INSERT INTO rift_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⵎⴰⵔⴰ ⵓⵛⴰ ⵉⵡⴹⴻⵏ ⵖⴰⵔ ⵉⵍⵉⵎ, ⵎⴰⵏⵉ ⵉⴵⴰ ⵜⴻⵏⵄⴰⵛ ⵏ ⵉⵖⴱⴰⵍⵓⵜⴻⵏ ⵏ ⵡⴰⵎⴰⵏ ⴷ ⵙⴻⴱⵄⵉⵏ ⵏ ⵜⵛⴻⵊⵊⵓⵔⴰ ⵏ ⵜⵉⵏⵉ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⵉⵍⵉⵎ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⵖⴰⵔ ⵍⴻⴱⵃⴰⵔ ⵏ ⵜⴻⵍⴳⴰ. ");
INSERT INTO rift_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⵍⴻⴱⵃⴰⵔ ⵏ ⵜⴻⵍⴳⴰ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⵍⴻⵅⵍⴰ ⵏ ⵙⵉⵏ. ");
INSERT INTO rift_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⵍⴻⵅⵍⴰ ⵏ ⵙⵉⵏ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⴷⵓⴼⵇⴰ. ");
INSERT INTO rift_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⴷⵓⴼⵇⴰ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⴰⵍⵓⵛ. ");
INSERT INTO rift_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⴰⵍⵓⵛ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⵔⴰⴼⵉⴷⵉⵎ, ⵎⴰⵏⵉ ⵡⴰⵔ ⵢⵓⴼⵉ ⴰⵎⴰⵏ ⵉ ⵍⴳⴻⵏⵙ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵙⵡⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⵔⴰⴼⵉⴷⵉⵎ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⵍⴻⵅⵍⴰ ⵏ ⵙⵉⵏⴰ. ");
INSERT INTO rift_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⵍⴻⵅⵍⴰ ⵏ ⵙⵉⵏⴰ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⵇⴰⴱⴰⵔⵓⵜ-ⵀⴰⵜⴰ’ⴰⵡⴰⵜ. ");
INSERT INTO rift_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⵇⴰⴱⴰⵔⵓⵜ-ⵀⴰⵜⴰ’ⴰⵡⴰⵜ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⵃⴰⴹⴰⵢⵔⵓⵜ. ");
INSERT INTO rift_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⵃⴰⴹⴰⵢⵔⵓⵜ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⵔⵉⵜⵎⴰ. ");
INSERT INTO rift_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⵔⵉⵜⵎⴰ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⵔⵉⵎⵎⵓⵏ-ⴼⴰⵔⵉⵚ. ");
INSERT INTO rift_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⵔⵉⵎⵎⵓⵏ-ⴼⴰⵔⵉⵚ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⵍⵉⴱⵏⴰ. ");
INSERT INTO rift_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⵍⵉⴱⵏⴰ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⵔⵉⵙⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⵔⵉⵙⵙⴰ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⵇⵉⵀⴰⵢⵍⴰⵜⴰ. ");
INSERT INTO rift_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⵇⵉⵀⴰⵢⵍⴰⵜⴰ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⵡⴻⴷⵔⴰⵔ ⵏ ⵛⴰⴼⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⴻⴳ ⵡⴻⴷⵔⴰⵔ ⵏ ⵛⴰⴼⴰⵔ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⵃⴰⵔⴰⴷⴰ. ");
INSERT INTO rift_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⵃⴰⵔⴰⴷⴰ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⵎⴰⵇⵀⴰⵢⵍⵓⵜ. ");
INSERT INTO rift_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⵎⴰⵇⵀⴰⵢⵍⵓⵜ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⵜⴰⵃⴰⵜ. ");
INSERT INTO rift_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⵜⴰⵃⴰⵜ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⵜⴰⵔⴰⵃ. ");
INSERT INTO rift_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⵜⴰⵔⴰⵃ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⵎⵉⵜⵇⴰ. ");
INSERT INTO rift_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⵎⵉⵜⵇⴰ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⵃⴰⵛⵎⵓⵏⴰ. ");
INSERT INTO rift_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⵃⴰⵛⵎⵓⵏⴰ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⵎⵓⵙⵉⵔⵓⵜ. ");
INSERT INTO rift_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⵎⵓⵙⵉⵔⵓⵜ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⴱⴰⵏⵉ-ⵢⴰⵄⵇⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⴱⴰⵏⵉ-ⵢⴰⵄⵇⴰⵏ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⵃⵓⵔ-ⵊⵉⴷⵊⴰⴷ. ");
INSERT INTO rift_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⵣⵉ ⵀⵓⵔ-ⵊⵉⴷⵊⴰⴷ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⵢⵓⵜⴱⴰⵜ. ");
INSERT INTO rift_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⵣⵉ ⵢⵓⵜⴱⴰⵜ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⵄⴰⴱⵔⵓⵏⴰ. ");
INSERT INTO rift_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⵣⵉ ⵄⴰⴱⵔⵓⵏⴰ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⵄⵉⵚⵢⵓⵏ-ⵊⴰⴱⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⵣⵉ ⵄⵉⵚⵢⵓⵏ-ⵊⴰⴱⴰⵔ ⵓⵛⴰ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⵍⴻⵅⵍⴰ ⵏ ⵚⵉⵏ ⵏⵏⵉ ⵢⴻⴵⴰ ⵇⴰⴷⴰⵛ. ");
INSERT INTO rift_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⵇⴰⴷⴰⵛ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⵖⴰⵔ ⵡⴻⴷⵔⴰⵔ ⵏ ⵀⵓⵔ, ⵖⴰⵔ ⵜⵎⴰ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵉⴷⵓⵎ. ");
INSERT INTO rift_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","ⵢⵓⵍⵉ ⵓⴽⴻⵀⵀⴰⵏ ⵀⴰⵔⵓⵏ ⴰⴷⵔⴰⵔ ⵏ ⵀⵓⵔ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵙ ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵓⵛⴰ ⵉⵎⵎⵓⵜ ⴷⵉⵏ ⴷⴻⴳ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵡⵉⵙⵙ ⴰⵔⴻⴱⵄⵉⵏ ⴰⵡⴰⵔⵏⵉ ⵉ ⵓⴼⴼⵓⵖ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ, ⴷⴻⴳ ⵓⵢⵓⵔ ⵡⵉⵙⵙ ⵅⴻⵎⵙⴰ, ⴷⴻⴳ ⵡⴰⵙⵙ ⴰⵎⴻⵣⵡⴰⵔⵓ ⵏ ⵓⵢⵓⵔ. ");
INSERT INTO rift_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","ⵜⵓⵖⴰ ⵀⴰⵔⵓⵏ ⵖⴰⵔⴻⵙ ⵎⵢⴰ ⵓ-ⵜⵍⴰⵜⴰ ⵓ-ⵄⵉⵛⵔⵉⵏ ⵏ ⵉⵙⴻⴳⴳⵯⵓⵙⴰ ⵓⵎⵉ ⵉⵎⵎⵓⵜ ⴷⴻⴳ ⵡⴻⴷⵔⴰⵔ ⵏ ⵀⵓⵔ. ");
INSERT INTO rift_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","ⵓⵛⴰ ⴰⴽⴻⵏⵄⴰⵏⵉ, ⴰⵊⴻⴵⵉⴷ ⵏ ⵄⴰⵔⴰⴷ, ⵡⴻⵏⵏⵉ ⵜⵓⵖⴰ ⵉⵣⴻⴷⴷⵖⴻⵏ ⴷⵉ ⵍⵊⴰⵏⵓⴱ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ, ⵉⵙⵍⴰ ⵙ ⵜⵡⴰⵙⵉⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⴻⴳ ⵡⴻⴷⵔⴰⵔ ⵏ ⵀⵓⵔ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⵚⴰⵍⵎⵓⵏⴰ. ");
INSERT INTO rift_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⵚⴰⵍⵎⵓⵏⴰ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⴼⵓⵏⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⴼⵓⵏⵓⵏ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⵓⴱⵓⵜ. ");
INSERT INTO rift_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⵓⴱⵓⵜ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⵍⵅⵉⵔⴱⴰⵜ ⵏ ⵄⴰⴱⴰⵔⵉⵎ ⴷⵉ ⵊⵊⵡⴰⵢⴻⵀ ⵏ ⵡⴻⵢⵎⵉⵔ ⴰⴽ-ⴷ ⵎⵓ’ⴰⴱ. ");
INSERT INTO rift_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⵍⵅⵉⵔⴱⴰⵜ ⵏ ⵄⴰⴱⴰⵔⵉⵎ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⴷⵉⴱⵓⵏ-ⵊⴰⴷ. ");
INSERT INTO rift_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⴷⵉⴱⵓⵏ-ⵊⴰⴷ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⵄⴰⵍⵎⵓⵏ-ⴷⵉⴱⵍⴰⵜⴰⵢⵉⵎ. ");
INSERT INTO rift_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⵉ ⵄⴰⵍⵎⵓⵏ-ⴷⵉⴱⵍⴰⵜⴰⵢⵉⵎ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⴻⴳ ⵉⴷⵓⵔⴰⵔ ⵏ ⵄⴰⴱⴰⵔⵉⵎ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵡⴻⴷⵔⴰⵔ ⵏ ⵏⴰⴱⵓ. ");
INSERT INTO rift_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","ⴼⴻⵙⵢⴻⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ, ⴼⴼⵖⴻⵏ ⵣⴻⴳ ⵉⴷⵓⵔⴰⵔ ⵏ ⵄⴰⴱⴰⵔⵉⵎ ⵓⵛⴰ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⴷⵉ ⵍⴻⵡⴹⴰⵜ ⵏ ⵎⵓ’ⴰⴱ ⵖⴰⵔ ⵍ’ⵓⵔⴷⵓⵏ ⴰⵔⴻⵏⴷⴰⴷ ⵉ ⴰⵔⵉⵃⴰ. ");
INSERT INTO rift_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","ⵏⵉⵜⵏⵉ ⵡⵜⵉⵏ ⵉⵇⵉⴹⴰⵏ ⵏⵙⴻⵏ ⵖⴰⵔ ⵍ’ⵓⵔⴷⵓⵏ ⵣⵉ ⴱⴰⵢⵜ-ⵢⴰⵛⵉⵎⵓⵜ ⴰⵍ ⴰⴱⴰⵍ-ⵛⵉⵟⵟⵉⵎ ⴷⵉ ⵍⴻⵡⴹⴰⵜ ⵏ ⵎⵓ’ⴰⴱ. ");
INSERT INTO rift_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ ⴷⵉ ⵍⴻⵡⴹⴰⵜ ⵏ ⵎⵓ’ⴰⴱ ⵖⴰⵔ ⵍ’ⵓⵔⴷⵓⵏ ⴰⵔⴻⵏⴷⴰⴷ ⵏ ⴰⵔⵉⵃⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“ⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵛⴰ ⵉⵏⵉ ⴰⵙⴻⵏ: ‘ⵅⵎⵉ ⵉ ⵖⴰ ⵜⴻⵥⵡⴰⵎ ⵍ’ⵓⵔⴷⵓⵏ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ, ");
INSERT INTO rift_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","ⵅⴻⵏⵏⵉ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⵜⴻⵙⵙⵓⴼⴼⵖⴻⵎ ⵎⴰⵔⵔⴰ ⵉⵎⴻⵣⴷⴰⵖ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵣⵣⴰⵜ ⵉ ⵓⵖⴻⵎⴱⵓⴱ ⵏⵡⴻⵎ ⴷ ⵎⴰⵔⵔⴰ ⵍⴻⵅⵢⴰⵍⴰⵜ ⵏⵙⴻⵏ ⵉⵏⴻⵇⵛⴻⵏ ⴰⴷ ⵜⴻⵏⵜ ⵜⴰⵔⴻⴷⴵⴻⵎ. ⵄⴰⵡⴻⴷ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⵜᵉⵜⴻⵃⵃⴰⵎ ⵎⴰⵔⵔⴰ ⵍⴻⵅⵢⴰⵍⴰⵜ ⵉⴼⴻⵙⵢⴻⵏ ⵏⵙⴻⵏ ⴷ ⵎⴰⵔⵔⴰ ⵍⴻⴳⵄⵓⴷⵉ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","ⴰⴷ ⵜᵉⵟⵟⴼⴻⵎ ⵜⴰⵎⵎⵓⵔⵜ ⴷ ⵍⵡⴰⵔⵜ ⵓⵛⴰ ⴰⴷ ⴷⴰⵢⴻⵙ ⵜⵣⴻⴷⵖⴻⵎ, ⵎⵉⵏⵣⵉ ⵏⴻⵛⵛ ⵡⵛⵉⵖ ⴰⵡⴻⵎ ⵜⴰⵎⵎⵓⵔⵜ ⵏⵏⵉ ⴷ ⴰⴳⵍⴰ. ");
INSERT INTO rift_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","ⴰⴷ ⵜⴻⴱⴹⴰⵎ ⵜⴰⵎⵎⵓⵔⵜ ⵙ ⵜⵇⴻⴷⴷⵓⵃⵜ ⴰⵎ ⵍⵡⴰⵔⵜ ⵅ ⵍⴰⴵⴰⵜ ⵏⵡⴻⵎ. ⵡⵉ ⵖⴰⵔ ⵉⴵⴰ ⴰⵟⵟⴰⵙ, ⴰⴷ ⴰⵙ ⵜⴻⵡⵛⴻⵎ ⴰⵟⵟⴰⵙ, ⵓ ⵡⴻⵏⵏⵉ ⵖⴰⵔ ⵉⴵⴰ ⴷⵔⵓⵙ, ⴰⴷ ⴰⵙ ⵜⴻⵡⵛⴻⵎ ⴷⵔⵓⵙ. ⵎⴰⵏⵉ ⴷ ⴰⵙ ⴷⴷ-ⵜⵓⵙⴰ ⵜⵇⴻⴷⴷⵓⵃⵜ, ⴰⴷ ⵢⵉⵍⵉ ⵏⵏⴻⵙ. ⵄⵍⴰⵃⵙⴰⴱ ⵜⵉⵇⴻⴱⴱⴰⵍ ⵏ ⵍⴻⵊⴷⵓⴷ ⵏⵡⴻⵎ ⴰⴷ ⵜⵡⴰⵔⵜⴻⵎ ⵜⴰⵙⵖⴰⵔⵜ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⴽⴻⵏⵏⵉⵡ ⵡⴰⵔ ⵜⴻⵙⵙⵓⴼⴼⵓⵖⴻⵎ ⵛⴰ ⵉⵎⴻⵣⴷⴰⵖ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏⵡⴻⵎ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⵎⵙⴰⵔ ⴰⵇⴰ ⵉⵏⵏⵉ ⵉ ⵖⴰ ⵜⴻⵊⵊⴻⵎ ⴰⴷ ⵇⵇⵉⵎⴻⵏ, ⴰⴷ ⴷⴻⵡⵍⴻⵏ ⴷ ⵉⵙⴻⵏⵏⴰⵏⴻⵏ ⴷⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵡⴻⵎ ⴷ ⵉⵡⴻⵣⵡⵉⵣⴻⵏ ⴷⴻⴳ ⵉⵖⴻⵣⴷⵉⵙⴻⵏ ⵏⵡⴻⵎ ⵓⵛⴰ ⵏⵉⵜⵏⵉ ⴰⴷ ⴽⴻⵏⵏⵉⵡ ⵃⵚⴰⵔⴻⵏ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⵉ ⵎⴰⵏⵉ ⵜⵣⴻⴷⴷⵖⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","ⵓⵛⴰ ⵅⴻⵏⵏⵉ ⴰⴷ ⵉⵎⵙⴰⵔ ⴰⴷ ⴰⵡⴻⵎ ⴳⴳⴻⵖ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⵓⵖⴰ ⵅⴰⵔⵔⵚⴻⵖ ⴰⴷ ⴰⴽⵉⴷⵙⴻⵏ ⴳⴳⴻⵖ.” ");
INSERT INTO rift_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“ⵓⵎⵓⵔ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵛⴰ ⵉⵏⵉ ⴰⵙⴻⵏ: ‘ⵅⵎⵉ ⵖⴰ ⵜⴰⴷⴼⴻⵎ ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ, ⵅⴻⵏⵏⵉ ⵜⴰ ⴷ ⵜⴰⵎⵎⵓⵔⵜ ⵉ ⴷ ⴰⵡⴻⵎ ⵖⴰ ⵢⵉⵍⵉⵏ ⴷ ⵍⵡⴰⵔⵜ, ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ ⴰⴽ-ⴷ ⵉⵢⵎⵉⵔⴻⵏ ⵏⵏⴻⵙ ⴰⴷ ⵜⵉⵍⵉ ⴰⵎⵎⵓ: ");
INSERT INTO rift_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","ⵊⵊⵉⵀⴻⵜ ⵏ ⵍⵊⴰⵏⵓⴱ ⴰⴷ ⵖⴰⵔⵡⴻⵎ ⵜⵉⵍⵉ ⵣⵉ ⵍⴻⵅⵍⴰ ⵏ ⵚⵉⵏ ⴰⵍ ⴰⵢⵎⵉⵔ ⵏ ⵉⴷⵓⵎ ⵓⵛⴰ ⴰⵢⵎⵉⵔ ⵏ ⵍⵊⴰⵏⵓⴱ ⴰⴷ ⵖⴰⵔⵡⴻⵎ ⵢⵉⵍⵉ ⵣⵉ ⵟⵟⴰⵔⴼ ⴰⵏⴻⴳⴳⴰⵔⵓ ⵏ ⵍⴻⴱⵃⴰⵔ ⴰⵎⴻⴵⴰⵃ ⴷⵉ ⵛⵛⴰⵔⵇ ");
INSERT INTO rift_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","ⵓⵛⴰ ⴰⵢⵎⵉⵔ ⴰⴷ ⵉⵎⴻⵢⵢⴻⵍ ⵣⵉ ⵍⵊⴰⵏⵓⴱ ⵖⴰⵔ ⵜⵙⵓⵏⵜⴰ ⵏ ⵜⵖⴰⵔⴹⵎⵉⵡⵉⵏ ⵓⵛⴰ ⴰⴷ ⵉⵄⴷⵓ ⵖⴰⵔ ⵚⵉⵏ ⵓⵛⴰ ⵟⵟⵔⵓⴼⴰ ⵏⵏⴻⵙ ⴰⴷ ⴷⴷ-ⴰⵡⴹⴻⵏ ⵊⵊⵉⵀⴻⵜ ⵏ ⵍⵊⴰⵏⵓⴱ ⵏ ⵇⴰⴷⴰⵛ-ⴱⴰⵔⵏⵉⵄ ⵓⵛⴰ ⴰⴷ ⵉⵄⴷⵓ ⵖⴰⵔ ⵃⴰⵚⴰⵔ-ⴰⴷⴷⴰⵔ ⵓⵛⴰ ⴰⴷ ⵉⵥⵡⴰ ⵖⴰⵔ ⴰⵚⵎⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","ⴰⴷ ⵉⵏⵏⴻⴹ ⵡⴻⵢⵎⵉⵔ ⵣⵉ ⴰⵚⵎⵓⵏ ⵖⴰⵔ ⵜⴻⵖⵣⴰⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⵓⵛⴰ ⵟⵟⵔⵓⴼⴰ ⵏⵏⴻⵙ ⴰⴷ ⴰⵡⴹⴻⵏ ⴰⵍ ⵍⴻⴱⵃⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","ⵓⵛⴰ ⴰⵢⵎⵉⵔ ⵏ ⵍⵖⴰⵔⴱ ⴰⴷ ⴰⵡⴻⵎ ⵢⵉⵍⵉ ⵍⴻⴱⵃⴰⵔ ⴰⵎⴻⵇⵇⵔⴰⵏ. ⵡⴰ ⴰⴷ ⴰⵡⴻⵎ ⵢⵉⵍⵉ ⴷ ⴰⵢⵎⵉⵔ ⵏ ⵍⵖⴰⵔⴱ.” ");
INSERT INTO rift_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","ⵡⴰ ⴰⴷ ⴰⵡⴻⵎ ⵢⵉⵍⵉ ⴷ ⴰⵢⵎⵉⵔ ⵏ ⵛⵛⴰⵎⴰⵍ: ⴰⴷ ⵜ ⵜⴰⵔⵛⵎⴻⵎ ⵉ ⵢⵉⵅⴻⴼ ⵏⵡⴻⵎ ⵣⴻⴳ ⵍⴻⴱⵃⴰⵔ ⴰⵎⴻⵇⵇⵔⴰⵏ ⴰⵍ ⴰⴷⵔⴰⵔ ⵏ ⵀⵓⵔ. ");
INSERT INTO rift_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","ⵣⴻⴳ ⵡⴻⴷⵔⴰⵔ ⵏ ⵀⵓⵔ ⴰⴷ ⵜ ⵜⴰⵔⵛⵎⴻⵎ ⴰⵍ ⵎⴰⵏⵉ ⵖⴰ ⵜⴰⵡⴹⴻⴷ ⵖⴰⵔ ⵃⴰⵎⴰⵜ ⵓⵛⴰ ⵟⵟⵔⵓⴼⴰ ⵏ ⵡⴻⵢⵎⵉⵔ ⴰⴷ ⴰⵡⴹⴻⵏ ⴰⵍ ⵚⴰⴷⴰⴷ. ");
INSERT INTO rift_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","ⴰⴷ ⵢⴻⵄⴷⵓ ⵡⴻⵢⵎⵉⵔ ⴰⵍ ⵣⵉⴼⵔⵓⵏ ⵓⵛⴰ ⵟⵟⵔⵓⴼⴰ ⵏⵏⴻⵙ ⴰⴷ ⴰⵡⴹⴻⵏ ⴰⵍ ⵃⴰⵚⴰⵔ-ⵄⵉⵏⴰⵏ. ⵡⴰ ⴰⴷ ⴰⵡⴻⵎ ⵢⵉⵍⵉ ⴷ ⴰⵢⵎⵉⵔ ⵏ ⵛⵛⴰⵎⴰⵍ. ");
INSERT INTO rift_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","ⴰⴷ ⵜⴰⵔⵛⵎⴻⵎ ⴰⵢⵎⵉⵔ ⵏⵡⴻⵎ ⵏ ⵛⵛⴰⵔⵇ ⵣⵉ ⵃⴰⵚⴰⵔ-ⵄⵉⵏⴰⵏ ⵖⴰⵔ ⵛⴰⴼⴰⵎ ");
INSERT INTO rift_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","ⵓⵛⴰ ⴰⴷ ⴷⴷ-ⵉⵀⵡⴰ ⵡⴻⵢⵎⵉⵔ ⵣⵉ ⵛⴼⴰⵎ ⴰⵍ ⵔⵉⴱⵍⴰ, ⵛⵛⴰⵔⵇ ⵏ ⵄⴰⵢⵏ. ⵅⴻⵏⵏⵉ ⴰⴷ ⴷⴷ-ⵉⵀⵡⴰ ⵡⴻⵢⵎⵉⵔ ⵄⴰⴷ ⴽⵜⴰⵔ ⵓⵛⴰ ⴰⴷ ⵉⵎⵓⵏ ⴰⴽ-ⴷ ⵜⵎⴰ ⵏ ⵛⵛⴰⵔⵇ ⵏ ⵍⴻⴱⵃⴰⵔ ⵏ ⴽⵉⵏⵏⴰⵔⴰⵜ. ");
INSERT INTO rift_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","ⵅⴻⵏⵏⵉ ⴰⴷ ⴷⴷ-ⵉⵀⵡⴰ ⵡⴻⵢⵎⵉⵔ ⵖⴰⵔ ⵍ’ⵓⵔⴷⵓⵏ ⵓⵛⴰ ⵟⵟⵔⵓⴼⴰ ⵏⵏⴻⵙ ⴰⴷ ⴰⵡⴹⴻⵏ ⴰⵍ ⵍⴻⴱⵃⴰⵔ ⴰⵎⴻⴵⴰⵃ. ⵜⴰ ⴰⴷ ⴰⵡⴻⵎ ⵜⵉⵍⵉ ⴷ ⵜⴰⵎⵎⵓⵔⵜ ⴰⴽ-ⴷ ⵉⵢⵎⵉⵔⴻⵏ ⵏⵏⴻⵙ ⵉ ⴷ ⴰⵙ ⴷⴷ-ⵉⵏⵏⴹⴻⵏ.” ");
INSERT INTO rift_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","ⵓⵛⴰ ⵎⵓⵙⴰ ⵢⵓⵎⵓⵔ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵉⵏⵏⴰ: “ⵜⴰ ⴷ ⵜⴰⵎⵎⵓⵔⵜ ⵏⵏⵉ ⵉ ⵖⴰ ⵜⴻⴱⴹⴰⵎ ⵊⴰⵔ ⴰⵡⴻⵎ ⵙ ⵜⵇⴻⴷⴷⵓⵃⵜ, ⵜⴻⵏⵏⵉ ⵅ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⴰⴷ ⵜⴻⵎⵎⴻⵡⵛ ⵉ ⵜⴻⵙⵄⴰ ⵏ ⵜⵇⴻⴱⴱⴰⵍ ⵓ ⵉ ⵡⴻⵣⵢⴻⵏ ⵏ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⵎⴰⵏⴰⵙⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","ⵎⵉⵏⵣⵉ ⵜⴰⵇⴱⵉⵍⵜ ⵏ ⴰⵢⵜ ⵏ ⵔⵓⴱⵉⵏ ⵜᵉⵜⵜⵡⴰⵙⴻⵜⵜⴻⴼ ⵄⵍⴰⵃⵙⴰⴱ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵙⴻⵏ ⵓ ⵜⴰⵇⴱⵉⵍⵜ ⵏ ⵊⴰⴷ ⵜᵉⵜⵜⵡⴰⵙⴻⵜⵜⴻⴼ ⵄⵍⴰⵃⵚⴰⴱ ⵜⴰⴷⴷⴰⵔⵜ ⵏ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏⵙⴻⵏ, ⴰⵇⴰ ⵏⵉⵜⵏⵉ ⵟⵟⴼⴻⵏ ⵄⴰⴷ ⵜⴰⵙⵖⴰⵔⵜ ⵏⵙⴻⵏ, ⵓ ⴰⵣⵢⴻⵏ ⵏ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⵎⴰⵏⴰⵙⵙⴰ ⵜᵉⵟⵟⴻⴼ ⵓⵍⴰ ⴷ ⵏⴻⵜⵜⴰⵜ ⵜⴰⵙⵖⴰⵔⵜ ⵏⵏⴻⵙ ⵏ ⵍⵡⴰⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","ⵜⵏⴰⵢⴻⵏ ⵏ ⵜⵇⴻⴱⴱⴰⵍ ⴷ ⵡⴻⵣⵢⴻⵏ ⴰⵇⴰ ⵟⵟⴼⴻⵏⵜ ⵍⵡⴰⵔⵜ ⵏⵙⴻⵏⵜ ⵖⴰⵔ ⵓⵊⴻⵎⵎⴰⴹ ⵏ ⵍ’ⵓⵔⴷⵓⵏ, ⵣⵉ ⴰⵔⵉⵃⴰ ⵖⴰⵔ ⵛⵛⴰⵔⵇ ⵖⴰⵔ ⵎⴰⵏⵉⵙ ⴷⴷ-ⵜⵏⴻⵇⵇⴰⵔ ⵜⴼⵓⵛⵜ.” ");
INSERT INTO rift_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“ⵉⵏⴰ ⴷ ⵉⵙⵎⴰⵡⴻⵏ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ ⵉⵏⵏⵉ ⵉ ⵖⴰ ⵉⴱⴹⴰⵏ ⵜⴰⵎⵎⵓⵔⵜ ⵊⴰⵔ ⴰⵡⴻⵎ: ⴰⴽⴻⵀⵀⴰⵏ ⴰⵍⵉⵄⴰⵣⴰⵔ ⴷ ⵢⴰⵛⵓⵡⴰ, ⵎⵎⵉⵙ ⵏ ⵏⵓⵏ. ");
INSERT INTO rift_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","ⴰⴷ ⵜⴻⴽⵙⵉⵎ ⵄⴰⵡⴻⴷ ⵉⵊⵊ ⵏ ⵍⵃⴰⴽⴻⵎ ⵣⵉ ⴽⵓⵍ ⵜⴰⵇⴱⵉⵍⵜ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⴻⴱⴹⴰⵎ ⵜⴰⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","ⵉⵏⴰ ⴷ ⵉⵙⵎⴰⵡⴻⵏ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ: ⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⵢⴰⵀⵓⴷⴰ, ⴽⴰⵍⵉⴱ, ⵎⵎⵉⵙ ⵏ ⵢⴰⴼⵓⵏⵏⵉ ");
INSERT INTO rift_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","ⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⴰⵢⵜ ⵏ ⵛⵉⵎⵄⵓⵏ, ⵛⵉⵎⵓⵡⵉⵍ, ⵎⵎⵉⵙ ⵏ ⵄⴰⵎⵎⵉⵀⵓⴷ, ");
INSERT INTO rift_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","ⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⴱⵉⵏⵢⴰⵎⵉⵏ, ⵉⵍⵉⴷⴰⴷ, ⵎⵎⵉⵙ ⵏ ⴽⴰⵙⵍⵓⵏ, ");
INSERT INTO rift_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","ⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⴰⵢⵜ ⵏ ⴷⴰⵏ, ⵍⵃⴰⴽⴻⵎ ⴱⵓⵇⵇⵉ, ⵎⵎⵉⵙ ⵏ ⵢⵓⵊⵍⵉ, ");
INSERT INTO rift_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","ⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⴰⵢⵜ ⵏ ⵢⵓⵙⵓⴼ: ⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⴰⵢⵜ ⵏ ⵎⴰⵏⴰⵙⵙⴰ, ⵍⵃⴰⴽⴻⵎ ⵃⴰⵏⵏⵉⵢⵉⵍ, ⵎⵎⵉⵙ ⵏ ⵉⴼⵓⴷ, ");
INSERT INTO rift_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","ⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⴼⵔⴰⵢⵉⵎ, ⵍⵃⴰⴽⴻⵎ ⵇⵉⵎⵓⵢⵉⵍ, ⵎⵎⵉⵙ ⵏ ⵛⵉⴼⵟⴰⵏ, ");
INSERT INTO rift_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","ⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⴰⵢⵜ ⵏ ⵣⴰⴱⵓⵍⵓⵏ, ⵍⵃⴰⴽⴻⵎ ⵉⵍⵉⵚⴰⴼⴰⵏ, ⵎⵎⵉⵙ ⵏ ⴼⴰⵔⵏⴰⵅ, ");
INSERT INTO rift_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","ⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵙⴰⴽⴰⵔ, ⵍⵃⴰⴽⴻⵎ ⴼⴰⵍⵟⵉⵢⵉⵍ, ⵎⵎⵉⵙ ⵏ ⵄⴰⵣⵣⴰⵏ, ");
INSERT INTO rift_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","ⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⴰⵢⵜ ⵏ ⴰⵛⵉⵔ, ⵍⵃⴰⴽⴻⵎ ⴰⵅⵉⵀⵓⴷ, ⵎⵎⵉⵙ ⵏ ⵛⴰⵍⵓⵎⵉ, ");
INSERT INTO rift_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","ⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⴰⵢⵜ ⵏ ⵏⴰⴼⵜⴰⵍⵉ, ⵍⵃⴰⴽⴻⵎ ⴼⴰⴷⴰⵀⵢⵉⵍ, ⵎⵎⵉⵙ ⵏ ⵄⴰⵎⵎⵉⵀⵓⴷ.” ");
INSERT INTO rift_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","ⵉⵏⴰ ⴷ ⵉⵏⵏⵉ ⵅ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⴰⴷ ⴱⴹⴰⵏ ⵍⵡⴰⵔⵜ ⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ ⴷⵉ ⵍⴻⵡⴹⴰⵜ ⵏ ⵎⵓ’ⴰⴱ ⵖⴰⵔ ⵍ’ⵓⵔⴷⵓⵏ ⴰⵔⴻⵏⴷⴰⴷ ⵏ ⴰⵔⵉⵃⴰ ⵓⵛⴰ ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“ⵓⵎⵓⵔ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵃⵉⵎⴰ ⴰⴷ ⵡⵛⴻⵏ, ⵣⵉ ⵍⵡⴰⵔⵜ ⵏⵙⴻⵏ ⵉ ⵟⵟⴼⴻⵏ, ⵜⵉⵏⴻⴷⴷⴰⵎ ⵉ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴷⴰⵢⵙⴻⵏⵜ ⵣⴻⴷⵖⴻⵏ. ⴰⴷ ⵜⴻⵡⵛⴻⵎ ⵉ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⵄⴰⵡⴻⴷ ⴷⴷⵎⴰⵏⵉ ⵏ ⵜⴰⵔⴻⵡⵙⴰ, ⵉⵏⵏⵉ ⴷ ⴰⵙⴻⵏ ⴷⴷ-ⵉⵏⵏⴹⴻⵏ ⵉ ⵜⵏⴻⴷⴷⴰⵎ. ");
INSERT INTO rift_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","ⵜⵉⵏⴻⴷⴷⴰⵎ-ⴰ ⴰⴷ ⵉⵍⵉⵏⵜ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴷⴰⵢⵙⴻⵏⵜ ⵣⴻⴷⵖⴻⵏ, ⵓⵛⴰ ⴷⴷⵎⴰⵏⵉ ⵏ ⵜⴰⵔⴻⵡⵙⴰ ⴰⴷ ⵉⵍⵉⵏ ⵉ ⵍⴻⴱⵀⴰⵢⴻⵎ ⵏⵙⴻⵏ ⵓ ⵉ ⵡⴰⴳⵍⴰ ⵏⵙⴻⵏ ⵓ ⵉ ⵎⴰⵔⵔⴰ ⵉⵎⵓⴷⴷⴰⵔⴻⵏ ⵏⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","ⵓⵛⴰ ⴷⴷⵎⴰⵏⵉ ⵏ ⵜⴰⵔⴻⵡⵙⴰ ⵉ ⵉⴵⴰⵏ ⵖⴰⵔ ⵜⵏⴻⴷⴷⴰⵎ ⵏⵏⵉ ⵉ ⵖⴰ ⵜⴻⵡⵛⴻⵎ ⵉ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ, ⴰⴷ ⵉⵍⵉⵏ ⵣⴻⴳ ⵡⴻⵖⴱⴰⵔ ⵏ ⵜⴻⵏⴷⵉⵏⵜ ⵖⴰⵔ ⴱⴰⵔⵔⴰ ⴰⵍⴻⴼ ⵏ ⵉⵖⴰⴵⴻⵏ ⵓⵛⴰ ⴰⵎⴻⵏⵏⵉ ⵖⴰⵔ ⵎⴰⵔⵔⴰ ⵉⵖⴻⵣⴷⵉⵙⴻⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","ⴱⴰⵔⵔⴰ ⵏ ⵜⴻⵏⴷⵉⵏⵜ ⵖⴰⵔ ⵛⵛⴰⵔⵇ ⴰⴷ ⵜⵄⴻⴱⴱⴰⵔⴻⵎ ⴰⵍⴼⴰⵢⴻⵏ ⵏ ⵉⵖⴰⴵⴻⵏ ⵓ ⵖⴰⵔ ⵍⵊⴰⵏⵓⴱ ⴰⵍⴼⴰⵢⴻⵏ ⵏ ⵉⵖⴰⴵⴻⵏ ⵓ ⵖⴰⵔ ⵍⵖⴰⵔⴱ ⴰⵍⴼⴰⵢⴻⵏ ⵏ ⵉⵖⴰⴵⴻⵏ ⵓ ⵖⴰⵔ ⵛⵛⴰⵎⴰⵍ ⴰⵍⴼⴰⵢⴻⵏ ⵏ ⵉⵖⴰⴵⴻⵏ ⵓⵛⴰ ⵜⴰⵏⴷⵉⵏⵜ ⴰⴷ ⵜⵉⵍⵉ ⴷⵉ ⵍⵡⴻⵙⵟ. ⵉⵏⴰ ⴰⴷ ⴰⵙⴻⵏ ⵉⵍⵉⵏ ⴷ ⴷⴷⵎⴰⵏⵉ ⵏ ⵜⴰⵔⴻⵡⵙⴰ ⵏ ⵜⵏⴻⴷⴷⴰⵎ. ");
INSERT INTO rift_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","ⵜⵉⵏⴻⴷⴷⴰⵎ ⵉ ⵖⴰ ⵜⴻⵡⵛⴻⵎ ⵉ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⴰⴷ ⵉⵍⵉⵏⵜ ⵙⴻⵜⵜⴰ ⵏ ⵜⵏⴻⴷⴷⴰⵎ ⵏ ⵜⴰⵔⴻⵡⵍⴰ. ⴰⴷ ⵜⴻⵏⵜ ⵜⴻⵡⵛⴻⵎ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴷⵉⵏ ⵢⴰⵔⵡⴻⵍ ⵓⵇⴻⵜⵜⴰⵍ. ⵙⴻⵏⵏⴻⵊ ⵉ ⵎⴰⵏ ⴰⵢⴰ ⴰⴷ ⵜⴻⵏⵜ ⵜⴻⵡⵛⴻⵎ ⵄⴰⴷ ⵜⵏⴰⵢⴻⵏ ⵓ-ⵔⴻⴱⵄⵉⵏ ⵏ ⵜⵏⴻⴷⴷⴰⵎ. ");
INSERT INTO rift_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","ⵎⴰⵔⵔⴰ ⵜⵉⵏⴻⴷⴷⴰⵎ ⵉ ⵖⴰ ⵜⴻⵡⵛⴻⵎ ⵉ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ, ⴰⴷ ⵉⵍⵉⵏⵜ ⵜⵎⴻⵏⵢⴰ ⵓ-ⵔⴻⴱⵄⵉⵏ ⵏ ⵜⵏⴻⴷⴷⴰⵎ, ⵜⵉⵏⴰ ⵙⵉⵎⴰⵏⵜ ⵏⵙⴻⵏⵜ ⴷ ⴷⴷⵎⴰⵏⵉ ⵏⵙⴻⵏⵜ ⵏ ⵜⴰⵔⴻⵡⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","ⵅ ⵜⵏⴻⴷⴷⴰⵎ ⵉ ⵖⴰ ⵜⴻⵡⵛⴻⵎ ⵣⴻⴳ ⵡⴰⴳⵍⴰ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⴰⴷ ⵜⴻⵏⵜ ⵜⴻⴽⵙⵉⵎ ⴽⵜⴰⵔ ⵣⴻⴳ ⵡⴻⵏⵏⵉ ⵖⴰⵔ ⵉⴵⴰ ⵡⴰⵟⵟⴰⵙ ⵓ ⵣⴻⴳ ⵡⴻⵏⵏⵉ ⵖⴰⵔ ⵉⴵⴰ ⴷⵔⵓⵙ, ⴰⴷ ⵜⴻⴽⵙⵉⴷ ⴷⵔⵓⵙ. ⴽⵓⵍ ⵉⵊⵊ ⴰⴷ ⵉⵡⵛ ⵣⵉ ⵜⵏⴻⴷⴷⴰⵎ ⵏⵏⴻⵙ ⵉ ⵉⵍⴰⵡⵉⵢⵢⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵍⵇⴻⴷⴷ ⵏ ⵜⴻⵙⵖⴰⵔⵜ ⵏⵏⴻⵙ ⵣⵉ ⵍⵡⴰⵔⵜ ⵉ ⵉⵟⵟⴻⴼ.” ");
INSERT INTO rift_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽ-ⴷ ⵎⵓⵙⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“ⵙⵉⵡⴻⵍ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵛⴰ ⵉⵏⵉ ⴰⵙⴻⵏ: ‘ⵅⵎⵉ ⵖⴰ ⵜⴻⵥⵡⴰⵎ ⵍ’ⵓⵔⴷⵓⵏ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ, ");
INSERT INTO rift_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","ⴰⴷ ⵜⵏⴻⵢⵢⵛⴻⵎ ⵉ ⵢⵉⵅⴻⴼ ⵏⵡⴻⵎ ⵜⵉⵏⴻⴷⴷⴰⵎ ⵏⵏⵉ ⴷ ⴰⵡⴻⵎ ⵉ ⵖⴰ ⵉⵍⵉⵏⵜ ⴷ ⵜⵉⵏⴻⴷⴷⴰⵎ ⵏ ⵜⴰⵔⴻⵡⵍⴰ, ⵃⵉⵎⴰ ⴰⵇⴻⵜⵜⴰⵍ, ⵡⴻⵏⵏⵉ ⵉⵏⵖⵉⵏ ⵃⴻⴷ ⵣⴻⴳ ⵓⵡⴻⴷⴷⴰⵔ, ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⴷⵉⵏ ⵢⴰⵔⵡⴻⵍ. ");
INSERT INTO rift_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","ⵜⵉⵏⴻⴷⴷⴰⵎ-ⴰ ⴰⴷ ⴰⵡⴻⵎ ⵉⵍⵉⵏⵜ ⵉ ⵜⴰⵔⴻⵡⵍⴰ ⵣⴻⴳ ⵓⵏⴻⵇⵇⴰⵎ ⵏ ⵉⴷⴰⵎⵎⴻⵏ, ⵃⵉⵎⴰ ⵡⴰⵔ ⵉⵜⵜⵎⴻⵜⵜⵉ ⵓⵇⴻⵜⵜⴰⵍ ⵇⴱⴻⵍ ⵎⴰ ⴰⴷ ⵉⴱⴻⴷⴷ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵜⵎⴻⵙⵎⵓⵏⵜ ⵉ ⵍⵃⵓⴽⵎ. ");
INSERT INTO rift_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","ⵣⵉ ⵜⵏⴻⴷⴷⴰⵎ ⵉ ⵖⴰ ⵜⴻⵡⵛⴻⵎ, ⴰⴷ ⵣⵣⴰⵢⵙⴻⵏⵜ ⵉⵍⵉⵏⵜ ⵙⴻⵜⵜⴰ ⴷ ⵜⵉⵏⴻⴷⴷⴰⵎ ⵏ ⵜⴰⵔⴻⵡⵍⴰ ⵉ ⴽⴻⵏⵏⵉⵡ. ");
INSERT INTO rift_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","ⵜⵍⴰⵜⴰ ⵏ ⵜⵏⴻⴷⴷⴰⵎ ⴰⴷ ⵜⴻⵏⵜ ⵜⴻⵡⵛⴻⵎ ⵖⴰⵔ ⵓⵊⴻⵎⵎⴰⴹ ⵏ ⵍ’ⵓⵔⴷⵓⵏ ⵓ ⵜⵍⴰⵜⴰ ⵏ ⵜⵏⴻⴷⴷⴰⵎ ⴰⴷ ⵜⴻⵏⵜ ⵜⴻⵡⵛⴻⵎ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⴽⴻⵏⵄⴰⵏ. ⴰⴷ ⵉⵍⵉⵏⵜ ⴷ ⵜⵉⵏⴻⴷⴷⴰⵎ ⵏ ⵜⴰⵔⴻⵡⵍⴰ. ");
INSERT INTO rift_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","ⵙⴻⵜⵜⴰ ⵏ ⵜⵏⴻⴷⴷⴰⵎ-ⴰ ⴰⴷ ⵉⵍⵉⵏⵜ ⵉ ⵜⴰⵔⴻⵡⵍⴰ ⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵓⵍⴰ ⵉ ⵓⴱⴰⵔⵔⴰⵏⵉ ⴷ ⵓⵎⵄⴻⵣⵣⴻⴱ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏⵙⴻⵏ, ⵃⵉⵎⴰ ⵡⴻⵏⵏⵉ ⵉⵏⵖⵉⵏ ⵃⴻⴷ ⵣⴻⴳ ⵓⵡⴻⴷⴷⴰⵔ, ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⴷⵉⵏ ⵢⴰⵔⵡⴻⵍ. ");
INSERT INTO rift_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","ⵎⴰⵍⴰ ⵉⵡⵡⴻⵜ ⵉ-ⵜ ⵙ ⵉⵛⵜ ⵏ ⵍⵇⴻⵛⵄⴻⵜ ⵏ ⵡⵓⵣⵣⴰⵍ ⵓⵛⴰ ⵉⵎⵎⵓⵜ, ⵅⴻⵏⵏⵉ ⴰⵇⴰ ⵏⴻⵜⵜⴰ ⴷ ⴰⵇⴻⵜⵜⴰⵍ. ⴰⵇⴻⵜⵜⴰⵍ ⴰⴷ ⵉⵜⵜⵡⴰⵏⴻⵖ ⵏⵉⵛⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","ⵎⴰⵍⴰ ⵉⵡⵡⴻⵜ ⵉ-ⵜ ⵙ ⵉⵊⵊ ⵏ ⵡⴻⵥⵔⵓ ⴷⴻⴳ ⵓⴼⵓⵙ ⵉ ⵣⵉ ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵉⵎⵎⴻⵜ ⵓⵛⴰ ⵅⴻⵏⵏⵉ ⵉⵎⵎⵓⵜ, ⴰⵇⴰ ⵏⴻⵜⵜⴰ ⴷ ⴰⵏⴻⵇⵇⴰⵎ. ⴰⵏⴻⵇⵇⴰⵎ ⴰⴷ ⵉⵜⵜⵡⴰⵏⴻⵖ ⵏⵉⵛⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","ⵏⵉⵖ ⵎⴰⵍⴰ ⵉⵡⵡⴻⵜ ⵉ-ⵜ ⵙ ⵉⵛⵜ ⵏ ⵍⵇⴻⵛⵄⴻⵜ ⵏ ⵓⴽⴻⵛⵛⵓⴹ ⴷⴻⴳ ⵓⴼⵓⵙ ⵉ ⵣⵉ ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵉⵎⵎⴻⵜ ⵓⵛⴰ ⵅⴻⵏⵏⵉ ⵉⵎⵎⵓⵜ, ⴰⵇⴰ ⵏⴻⵜⵜⴰ ⴷ ⴰⵇⴻⵜⵜⴰⵍ. ⴰⵇⴻⵜⵜⴰⵍ ⴰⴷ ⵉⵜⵜⵡⴰⵏⴻⵖ ⵏⵉⵛⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","ⴰⵏⴻⵇⵇⴰⵎ ⵏ ⵉⴷⴰⵎⵎⴻⵏ ⴰⴷ ⵉⵏⴻⵖ ⴰⵇⴻⵜⵜⴰⵍ. ⵎⴰⵍⴰ ⴰⴷ ⵜ ⵉⵍⵇⴰ, ⴰⴷ ⵜ ⵉⵏⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","ⵓ ⵎⴰⵍⴰ ⵉⵄⴰⵔⵏ ⵉ-ⵜ ⵙ ⵡⴻⵛⵔⴰⵀ, ⵏⵉⵖ ⵉⵏⴹⴰⵔ ⵖⴰⵔⴻⵙ ⵛⴰ ⵙ ⵏⴻⵄⵎⴰⴷⴰ ⴰⵍⴰⵎⵉ ⵣⵣⴰⵢⴻⵙ ⵉⵎⵎⵓⵜ, ");
INSERT INTO rift_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","ⵏⵉⵖ ⵉⵡⵡⴻⵜ ⵉ-ⵜ ⵙ ⵍⴻⵄⴷⴰⵡⴻⵜ ⵙ ⵓⴼⵓⵙ ⵏⵏⴻⵙ, ⴰⵍⴰⵎⵉ ⵣⵣⴰⵢⴻⵙ ⵉⵎⵎⵓⵜ, ⵅⴻⵏⵏⵉ ⵡⴻⵏⵏⵉ ⵜ ⵉⵏⵖⵉⵏ ⴰⴷ ⵉⵜⵜⵡⴰⵏⴻⵖ ⵏⵉⵛⴰⵏ. ⴰⵇⴰ-ⵜ ⴷ ⴰⵇⴻⵜⵜⴰⵍ. ⴰⵏⴻⵇⵇⴰⵎ ⵏ ⵉⴷⴰⵎⵎⴻⵏ ⴰⴷ ⵉⵏⴻⵖ ⴰⵇⴻⵜⵜⴰⵍ ⵅⵎⵉ ⵜ ⵖⴰ ⵉⵍⵇⴰ. ");
INSERT INTO rift_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⵜⵓⵖⴰ ⵉⵄⴰⵔⵔⴻⵏ ⵉ-ⵜ ⴰⵎⴻⵏⵏⵉ ⴷⴻⴳ ⵡⴻⵔⵎⴰⵛ ⵏ ⵡⴰⴱⵍⵉⵡⴻⵏ ⴱⵍⴰ ⵍⴻⵄⴷⴰⵡⴻⵜ, ⵏⵉⵖ ⵉⵏⴹⴰⵔ ⵖⴰⵔⴻⵙ ⵛⴰ ⵏ ⵍⵇⴻⵛⵄⴻⵜ ⴰⵎ ⵉⵡⴻⴷⴷⴰⵔ, ");
INSERT INTO rift_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","ⵏⵉⵖ ⴰⵎ ⵡⴰⵔ ⵜ ⵉⵥⵔⵉ, ⵉⴳⴳⴰ ⴰⴷ ⵅⴰⵙ ⴷⴷ-ⵉⵡⴹⴰ ⵛⴰ ⵏ ⵡⴻⵥⵔⵓ ⵉ ⵣⵉ ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵉⵎⵎⴻⵜ, ⵓⵛⴰ ⵅⴻⵏⵏⵉ ⵉⵎⵎⵓⵜ ⴰⵎ ⵡⴰⵔ ⵜⵓⵖⵉ ⴷ ⵍⴻⵄⴷⵓ ⵏⵏⴻⵙ ⵓ ⵏⴻⵜⵜⴰ ⵜⵓⵖⴰ ⵡⴰⵔ ⴷ ⴰⵙ ⵢⴰⵔⴻⵣⵣⵓ ⵍⵖⴰⵔ, ");
INSERT INTO rift_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","ⵅⴻⵏⵏⵉ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⴰⴷ ⵜⴻⵃⴽⴻⵎ ⵊⴰⵔ ⵓⵇⴻⵜⵜⴰⵍ ⴷ ⵓⵏⴻⵇⵇⴰⵎ ⵏ ⵉⴷⴰⵎⵎⴻⵏ ⵄⵍⴰⵃⵙⴰⴱ ⵍⴼⴰⵔⴰⵢⵉⴹ-ⴰ. ");
INSERT INTO rift_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⴰⴷ ⵜⴼⴻⴽⴽ ⴰⵇⴻⵜⵜⴰⵍ ⵣⴻⴳ ⵓⴼⵓⵙ ⵏ ⵓⵏⴻⵇⵇⴰⵎ ⵏ ⵉⴷⴰⵎⵎⴻⵏ ⵓⵛⴰ ⵜⴰⵎⴻⵙⵎⵓⵏⵜ ⴰⴷ ⵜⴻⵊⵊ ⵏⴻⵜⵜⴰ ⴰⴷ ⵉⵄⵇⴻⴱ ⵖⴰⵔ ⵜⴻⵏⴷⵉⵏⵜ ⵏⵏⴻⵙ ⵏ ⵜⴰⵔⴻⵡⵍⴰ. ⴰⴷ ⴷⵉⵏ ⵉⵇⵇⵉⵎ ⴰⵍ ⵍⵎⴻⵡⵜ ⵏ ⴰⵔⵔⴰⵢⵙ ⵏ ⵉⴽⴻⵀⵀⴰⵏⴻⵏ, ⵡⴻⵏⵏⵉ ⴷⴻⵀⵏⴻⵏ ⵏⵉⵜⵏⵉ ⵙ ⵣⵣⴻⵛⵜ ⵉⵇⴻⴷⴷⵙⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","ⵎⴰⵛⴰ ⵎⴰⵍⴰ ⴰⵇⴻⵜⵜⴰⵍ ⵉⴼⴼⴻⵖ ⴱⴰⵔⵔⴰ ⵏ ⵉⵢⵎⵉⵔⴻⵏ ⵏ ⵜⴻⵏⴷⵉⵏⵜ ⵏ ⵜⴰⵔⴻⵡⵍⴰ ⵎⴰⵏⵉ ⵢⴰⵔⵡⴻⵍ, ");
INSERT INTO rift_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","ⵓⵛⴰ ⴰⵏⴻⵇⵇⴰⵎ ⵏ ⵉⴷⴰⵎⵎⴻⵏ ⵢⵓⴼⴰ ⵉ-ⵜ ⴱⴰⵔⵔⴰ ⵏ ⵉⵢⵎⵉⵔⴻⵏ ⵏ ⵜⴻⵏⴷⵉⵏⵜ ⵏ ⵜⴰⵔⴻⵡⵍⴰ ⵓⵛⴰ ⴰⵏⴻⵇⵇⴰⵎ ⵏ ⵉⴷⴰⵎⵎⴻⵏ ⵉⵏⵖⴰ ⵡⴻⵏⵏⵉ ⵉⵏⵖⵉⵏ, ⵡⴰⵔ ⵅⴰⵙ ⵛⴰ ⵉⴷⴰⵎⵎⴻⵏ ⵅⴻⵏⵏⵉ. ");
INSERT INTO rift_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","ⵎⵉⵏⵣⵉ ⵜⵓⵖⴰ ⵅⴰⵙ ⴰⴷ ⵉⵇⵇⵉⵎ ⴷⵉ ⵜⴻⵏⴷⵉⵏⵜ ⵏⵏⴻⵙ ⵏ ⵜⴰⵔⴻⵡⵍⴰ ⴰⵍ ⵍⵎⴻⵡⵜ ⵏ ⴰⵔⵔⴰⵢⵙ ⵏ ⵉⴽⴻⵀⵀⴰⵏⴻⵏ. ⵎⴰⵛⴰ ⴰⵡⴰⵔⵏⵉ ⵍⵎⴻⵡⵜ ⵏ ⴰⵔⵔⴰⵢⵙ ⵏ ⵉⴽⴻⵀⵀⴰⵏⴻⵏ ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵉⵄⵇⴻⴱ ⵓⵇⴻⵜⵜⴰⵍ ⵖⴰⵔ ⵜⴻⵎⵎⵓⵔⵜ ⵏⵏⵉ ⵉⴵⴰⵏ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","ⴰⵢⴰ ⴰⴷ ⴰⵡⴻⵎ ⵜⵉⵍⵉ ⴷ ⵜⴰⵡⵚⴻⵢⵢⴻⵜ ⵏ ⵍⵃⴻⵇⵇ ⵉ ⵎⴰⵔⵔⴰ ⵊⵊⵉⵍⴰⵜ ⵏⵡⴻⵎ ⵎⴰⵏⵉ ⵎⴰ ⵖⴰ ⵜⵣⴻⴷⵖⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","ⴽⵓⵍ ⵉⵊⵊ, ⵡⴻⵏⵏⵉ ⵉⵏⵖⵉⵏ ⵃⴻⴷ, ⴰⵇⴰ ⴰⵇⴻⵜⵜⴰⵍ ⴰⴷ ⵉⵜⵜⵡⴰⵏⴻⵖ ⵄⵍⴰⵃⵙⴰⴱ ⴰⵇⴻⵎⵎⵓⵎ ⵏ ⵍⴻⵛⵀⵓⴷ, ⵎⴰⵛⴰ ⵉⵊⵊ ⵏ ⵓⵛⴻⵀⵀⴰⴷ ⵡⴰⵀⴰ, ⵡⴰⵔ ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵉⵛⵀⴻⴷ ⵅ ⵉⵛⵜ ⵏ ⵏⵏⴻⴼⵙ ⵙ ⵍⵎⴻⵡⵜ. ");
INSERT INTO rift_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","ⵡⴰⵔ ⴽⴻⵙⵙⵉⵎ ⴷⴷⴻⵢⵢⴻⵜ ⵅ ⵍⴻⵄⵎⴰⵔ ⵏ ⵓⵇⴻⵜⵜⴰⵍ ⵏⵏⵉ ⵅ ⵉⵜⵜⵡⴰⵃⴽⴻⵎ ⵙ ⵍⵎⴻⵡⵜ, ⵎⴰⵖⴰⵔ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵉⵜⵜⵡⴰⵏⴻⵖ ⵏⵉⵛⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","ⵡⴰⵔ ⴽⴻⵙⵙⵉⵎ ⴷⴷⴻⵢⵢⴻⵜ ⵅ ⵡⴻⵏⵏⵉ ⵢⴰⵔⴻⵡⵍⴻⵏ ⵖⴰⵔ ⵜⴻⵏⴷⵉⵏⵜ ⵏⵏⴻⵙ ⵏ ⵜⴰⵔⴻⵡⵍⴰ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏ ⵡⴻⵄⵇⴰⴱ ⵏⵏⴻⵙ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⵣⴷⴻⵖ ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵇⴱⴻⵍ ⵍⵎⴻⵡⵜ ⵏ ⴰⵔⵔⴰⵢⵙ ⵏ ⵉⴽⴻⵀⵀⴰⵏⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","ⵡⴰⵔ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⵜⴻⵙⵙⴻⵅⵙⴰⵔⴻⵎ ⵜⴰⵎⵎⵓⵔⵜ ⵎⴰⵏⵉ ⵜⴻⴵⴰⵎ, ⵎⵉⵏⵣⵉ ⵉⴷⴰⵎⵎⴻⵏ ⵙⵙⴻⵅⵙⴰⵔⴰⵏ ⵜⴰⵎⵎⵓⵔⵜ ⵓⵛⴰ ⵡⴰⵔ ⵉⵣⴻⵎⵎⴰⵔ ⴰⴷ ⵉⵜⵜⵡⴰⴳⴳ ⵡⴻⵚⵍⴰⵃ ⵉ ⵜⴻⵎⵎⵓⵔⵜ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏ ⵉⴷⴰⵎⵎⴻⵏ ⵉ ⴷⴰⵢⴻⵙ ⵉⵜⵜⵡⴰⵙⵙⵉⵣⵍⴻⵏ, ⵎⵖⵉⵔ ⵙ ⵉⴷⴰⵎⵎⴻⵏ ⵏ ⵡⴻⵏⵏⵉ ⵜⴻⵏ ⵉⵙⵙⵉⵣⵣⵍⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","ⵡⴰⵔ ⵙⵅⴻⵎⵎⵉⵊⴻⵎ ⵜⴰⵎⵎⵓⵔⵜ ⵎⴰⵏⵉ ⵖⴰ ⵜⵣⴻⴷⵖⴻⵎ ⴽⴻⵏⵏⵉⵡ, ⴷⵉ ⵍⵡⴻⵙⵟ ⵏⵏⴻⵙ ⵉ ⵖⴰ ⵣⴻⴷⵖⴻⵖ ⵏⴻⵛⵛ, ⵎⵉⵏⵣⵉ ⵏⴻⵛⵛ ⴷ ⵙⵉⴷⵉ, ⵡⴻⵏⵏⵉ ⵉⵣⴻⴷⴷⵖⴻⵏ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ.” ");
INSERT INTO rift_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","ⵣⵉ ⵍⴰⴵⴰⵜ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵢⵓⵙⵓⴼ ⵇⴰⵔⵔⴱⴻⵏ-ⴷⴷ ⵉⵣⴻⴵⵉⴼⴻⵏ ⵊⴰⵔ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏ ⵍⴰⴵ ⵏ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵊⵉⵍⵄⴰⴷ, ⵎⵎⵉⵙ ⵏ ⵎⴰⴽⵉⵔ, ⵎⵎⵉⵙ ⵏ ⵎⴰⵏⴰⵙⵙⴰ ⵓⵛⴰ ⵏⵉⵜⵏⵉ ⵙⵙⵉⵡⵍⴻⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵎⵓⵙⴰ ⵓ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵍⵃⵓⴽⴽⴰⵎ, ⵉⵣⴻⴵⵉⴼⴻⵏ ⵏⵏⴻⵖⵏⵉ ⵅ ⵉⴱⴰⴱⴰⵜⴻⵏ ⵏ ⵍⴰⴵⴰⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ");
INSERT INTO rift_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","ⵓⵛⴰ ⵏⵉⵜⵏⵉ ⵏⵏⴰⵏ: “ⵙⵉⴷⵉ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉⵏⵓ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵉⵡⵛ ⵜⴰⵎⵎⵓⵔⵜ ⵙ ⵜⵇⴻⴷⴷⵓⵃⵜ ⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴷ ⵍⵡⴰⵔⵜ. ⵓⵛⴰ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵙⵉⴷⵉ ⵉⵏⵓ ⴰⴷ ⵉⵡⵛ ⵜⴰⵙⵖⴰⵔⵜ ⵏ ⵍⵡⴰⵔⵜ ⵏ ⵓⵎⴰⵜⵏⴻⵖ ⵚⴰⵍⵓⴼⵃⴰⴷ ⵉ ⵢⴻⵙⵙⵉⵙ. ");
INSERT INTO rift_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","ⵎⴰⵍⴰ ⴷⴻⵡⵍⴻⵏⵜ ⵏⵉⵜⴻⵏⵜⵉ ⴷ ⵜⵉⵏⴻⵎⵍⴰⵍⵜ ⴰⴽ-ⴷ ⵉⵊⵊⴻⵏ ⵣⴻⴳ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵜⵇⴻⴱⴱⴰⵍ ⵏⵏⴻⵖⵏⵉ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜᵉⵜⵜⵡⴰⴽⴽⴻⵙ ⵜⴻⵙⵖⴰⵔⵜ ⵏⵙⴻⵏⵜ ⴷⵉ ⵍⵡⴰⵔⵜ ⵏ ⵍⴻⵊⴷⵓⴷ ⵏⵏⴻⵖ ⵓⵛⴰ ⴰⴷ ⵜᵉⵜⵜⵡⴰⵔⵏⵉ ⵜⴰⵙⵖⴰⵔⵜ ⵏⵙⴻⵏⵜ ⵉ ⵜⴻⵙⵖⴰⵔⵜ ⵏ ⵜⴻⵇⴱⵉⵍⵜ ⵉ ⵖⴰⵔ ⵖⴰ ⵎⵓⵏⴻⵏⵜ ⵓⵛⴰ ⴰⵎⵎⵓ ⴰⴷ ⵉⵜⵜⵡⴰⵙⵙⴻⵎⵥⵉ ⵎⵉⵏ ⵉⴵⴰⵏ ⴷ ⵜⴰⵙⵖⴰⵔⵜ ⵏⵏⴻⵖ ⵙ ⵜⵇⴻⴷⴷⵓⵃⵜ. ");
INSERT INTO rift_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","ⵅⵎⵉ ⴷⴷ ⵖⴰ ⵢⴰⵙ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵏ ⵓⵙⵍⵉⵡⵍⴻⵡ ⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵅⴻⵏⵏⵉ ⴰⴷ ⵜᵉⵜⵜⵡⴰⵎⴰⵔⵏⵉ ⵜⴻⵙⵖⴰⵔⵜ ⵏⵙⴻⵏⵜ ⵉ ⵜⴻⵙⵖⴰⵔⵜ ⵏ ⵜⴻⵇⴱⵉⵍⵜ ⴰⴽ-ⴷ ⵡⵉ ⵖⴰ ⵎⵓⵏⴻⵏⵜ. ⴰⵎⵎⵓ ⵉ ⵖⴰ ⵜᵉⵜⵜⵡⴰⴽⴽⴻⵙ ⵅⴻⵏⵏⵉ ⵜⴻⵙⵖⴰⵔⵜ ⵏⵙⴻⵏⵜ ⴷⵉ ⵍⵡⴰⵔⵜ ⵏ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⵍⴻⵊⴷⵓⴷ ⵏⵏⴻⵖ.” ");
INSERT INTO rift_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","ⵅⴻⵏⵏⵉ ⵢⵓⵎⵓⵔ ⵎⵓⵙⴰ ⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵄⵍⴰⵃⵙⴰⴱ ⵍⵓⵎⵓⵔ ⵏ ⵙⵉⴷⵉ, ⵉⵏⵏⴰ: “ⴰⵇⴰ ⴷ ⵜⵉⴷⴻⵜⵜ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⴻⵙⵙⵉⵡⴻⵍ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⴰⵢⵜ ⵏ ⵢⵓⵙⵓⴼ. ");
INSERT INTO rift_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","ⵡⴰ ⴷ ⴰⵡⴰⵍ ⵉ ⵣⵉ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵅ ⵢⴻⵙⵙⵉⵙ ⵏ ⵚⴰⵍⵓⴼⵃⴰⴷ, ⵉⵇⵇⴰⵔ: ‘ⴻⵊⵊ ⵉ-ⵜⴻⵏⵜ ⴰⴷ ⵎⴻⵍⵛⴻⵏⵜ ⴰⴽ-ⴷ ⵡⴻⵏⵏⵉ ⴷ ⴰⵙⴻⵏⵜ ⵢⴰⵔⴻⵛⵇⴻⵏ. ⵉⵜⵜⵅⴻⵚⵚⴰ ⵎⵖⵉⵔ ⴰⴷ ⵎⴻⵍⵛⴻⵏⵜ ⴷⵉ ⵍⴰⴵ ⵏ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⴱⴰⴱⴰⵜⵙⴻⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","ⵡⴰⵔ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⵜⵔⴰⵃ ⵜⴻⵙⵖⴰⵔⵜ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵣⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵖⴰⵔ ⵜⴻⵇⴱⵉⵍⵜ ⵏⵏⴻⵖⵏⵉ, ⵎⵉⵏⵣⵉ ⴽⵓⵍ ⴰⵔⵢⴰⵣ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴰⴷ ⵉⵇⵇⵉⵎ ⵉⵟⵟⴻⴼ ⴷⵉ ⵜⴻⵙⵖⴰⵔⵜ ⵏ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⵍⴻⵊⴷⵓⴷ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","ⵢⴻⴵⵉⵙ ⵏ ⴽⵓⵍ ⵉⵊⵊ ⵉ ⵖⴰ ⵉⵟⵟⴼⴻⵏ ⵉⵛⵜ ⵏ ⵜⴻⵙⵖⴰⵔⵜ ⵣⴻⴳ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ, ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⵙ ⴰⴷ ⵜⴻⵎⵍⴻⵛ ⴰⴽ-ⴷ ⵉⵊⵊ ⵣⴻⴳ ⵉⵊⵊ ⵏ ⵍⴰⴵ ⵣⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⴱⴰⴱⴰⵙ, ⵃⵉⵎⴰ ⴽⵓⵍ ⵉⵊⵊ ⵣⴻⴳ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴰⴷ ⵉⵡⴰⵔⵜ ⵜⴰⵙⵖⴰⵔⵜ ⵏ ⵍⴻⵊⴷⵓⴷ ⵏⵏⴻⵙ. ");
INSERT INTO rift_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","ⵡⴰⵔ ⵉⵄⴻⴷⴷⴻⵍ ⴰⴷ ⵜⵔⴰⵃ ⵜⴻⵙⵖⴰⵔⵜ ⵏ ⵉⵛⵜ ⵏ ⵜⴻⵇⴱⵉⵍⵜ ⵖⴰⵔ ⵜⴻⵇⴱⵉⵍⵜ ⵏⵏⴻⵖⵏⵉ, ⵎⵉⵏⵣⵉ ⵉⵜⵜⵅⴻⵚⵚⴰ ⵉ ⴽⵓⵍ ⵉⵛⵜ ⵣⵉ ⵜⵇⴻⴱⴱⴰⵍ ⵏ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴰⴷ ⵉⵇⵇⵉⵎ ⵉⵟⵟⴻⴼ ⴷⵉ ⵜⴻⵙⵖⴰⵔⵜ ⵏⵏⴻⵙ.’” ");
INSERT INTO rift_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","ⵢⴻⵙⵙⵉⵙ ⵏ ⵚⴰⵍⵓⴼⵃⴰⴷ ⴳⴳⵉⵏⵜ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵉ ⵎⵓⵙⴰ. ");
INSERT INTO rift_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","ⵎⴰⵃⵍⴰ, ⵜⵉⵔⵚⴰ, ⵃⵓⵊⵍⴰ, ⵎⵉⵍⴽⴰ ⴷ ⵏⵓⵄⴰ, ⵢⴻⵙⵙⵉⵙ ⵏ ⵚⴰⵍⵓⴼⵃⴰⴷ, ⴷⴻⵡⵍⴻⵏⵜ ⴷ ⵜⵉⵏⴻⵎⵍⴰⵍⵜ ⴰⴽ-ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏ ⵄⴻⵎⵎⵉⵜⵙⴻⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","ⴷⴻⵡⵍⴻⵏⵜ ⴷ ⵜⵉⵏⴻⵎⵍⴰⵍⵜ ⴷⵉ ⵍⴰⴵⴰⵜ ⵏ ⴰⵢⵜ ⵏ ⵎⴰⵏⴰⵙⵙⴰ, ⵎⵎⵉⵙ ⵏ ⵢⵓⵙⵓⴼ. ⴰⵎⵎⵓ ⵉ ⵜⴻⵇⵇⵉⵎ ⵜⴻⵙⵖⴰⵔⵜ ⵏⵙⴻⵏⵜ ⴷⵉ ⵜⴻⵇⴱⵉⵍⵜ ⵏ ⴱⴰⴱⴰⵜⵙⴻⵏⵜ. ");
INSERT INTO rift_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","ⵜⵉⵏⴰ ⴷ ⵜⵉⵡⴻⵚⵚⴰ ⴷ ⵍⴼⴰⵔⴰⵢⵉⴹ ⵏⵏⵉ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ ⵙ ⵜⵙⴻⵅⵅⴰⵔⵜ ⵏ ⵎⵓⵙⴰ ⵉ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⴷⵉ ⵍⴻⵡⴹⴰⵜ ⵏ ⵎⵓ’ⴰⴱ, ⵖⴰⵔ ⵍ’ⵓⵔⴷⵓⵏ ⴰⵔⴻⵏⴷⴰⴷ ⵏ ⴰⵔⵉⵃⴰ. ");
INSERT INTO rift_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","ⵉⵏⴰ ⴷ ⴰⵡⴰⵍⴻⵏ ⵏⵏⵉ ⵉⵙⵙⵉⵡⴻⵍ ⵎⵓⵙⴰ ⵉ ⵎⴰⵔⵔⴰ ⵉⵙⵔⴰⵉⵍ ⵅ ⵓⵊⴻⵎⵎⴰⴹ ⵏ ⵍ’ⵓⵔⴷⵓⵏ, ⴷⵉ ⵍⴻⵅⵍⴰ, ⴷⵉ ⵍⴻⵡⴹⴰ ⴰⵔⴻⵏⴷⴰⴷ ⵏ ⵚⵓⴼ, ⵊⴰⵔ ⴼⴰⵔⴰⵏ ⴷ ⵜⵓⴼⴰⵍ ⴷ ⵍⴰⴱⴰⵏ ⴷ ⵃⴰⴹⴰⵢⵔⵓⵜ ⴷ ⴷⵉ-ⴷⴰⵀⴰⴱ. ");
INSERT INTO rift_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","ⵣⵉ ⵃⵓⵔⵉⴱ ⵅ ⵡⴻⴱⵔⵉⴷ ⵏ ⵉⴷⵓⵔⴰⵔ ⵏ ⵙⴰⵄⵉⵔ ⴰⵍ ⵇⴰⴷⴰⵛ-ⴱⴰⵔⵏⵉⵄ ⴰⵇⴰ-ⵜⵜ ⴷ ⵉⵛⵜ ⵏ ⵜⵉⵛⵜⵉ ⵏ ⵃⵉⵟⴰⵛ ⵏ ⵡⵓⵙⵙⴰⵏ. ");
INSERT INTO rift_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","ⵉⵎⵙⴰⵔ ⴷⴻⴳ ⵓⵙⴻⴳⴳⵯⴰⵙ ⵡⵉⵙⵙ ⴰⵔⴻⴱⵄⵉⵏ, ⴷⴻⴳ ⵓⵢⵓⵔ ⵡⵉⵙⵙ ⵃⵉⵟⴰⵛ, ⴷⴻⴳ ⵡⴰⵙⵙ ⴰⵎⴻⵣⵡⴰⵔⵓ ⵏ ⵓⵢⵓⵔ, ⵉⵙⵙⵉⵡⴻⵍ ⵎⵓⵙⴰ ⴰⴽ-ⴷ ⴰⵢⵜ ⵏ ⵉⵙⵔⴰⵉⵍ ⵄⵍⴰⵃⵙⴰⴱ ⵎⴰⵔⵔⴰ ⵎⵉⵏ ⴷ ⴰⵙ ⵉⵡⴻⵚⵚⴰ ⵙⵉⴷⵉ ⵣⵉ ⵊⵊⵉⵀⴻⵜ ⵏⵙⴻⵏ, ");
INSERT INTO rift_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","ⴰⵡⴰⵔⵏⵉ ⵓⵎⵉ ⵉⵖⵍⴻⴱ ⴷⵉ ⵉⴷⵔⴰⵄⵉ ⵅ ⵙⵉⵃⵓⵏ, ⴰⵊⴻⴵⵉⴷ ⵏ ⵉⵎⵓⵔⵉⵢⵢⴻⵏ ⵡⴻⵏⵏⵉ ⵜⵓⵖⴰ ⵉⵣⴻⴷⴷⵖⴻⵏ ⴷⵉ ⵃⴰⵛⴱⵓⵏ, ⵓ ⵅ ⵄⵓⵊ, ⴰⵊⴻⴵⵉⴷ ⵏ ⴱⴰⵛⴰⵏ, ⵡⴻⵏⵏⵉ ⵜⵓⵖⴰ ⵉⵣⴻⴷⴷⵖⴻⵏ ⴷⵉ ⵄⴰⵛⵜⴰⵔⵓⵜ. ");
INSERT INTO rift_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","ⵅ ⵓⵊⴻⵎⵎⴰⴹ ⵏ ⵍ’ⵓⵔⴷⵓⵏ, ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵓ’ⴰⴱ, ⵉⴱⴷⴰ ⵎⵓⵙⴰ ⴰⴷ ⵉⴼⴻⵙⵙⴰⵔ ⵛⵛⴰⵔⵉⵄⴰ-ⵢⴰ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","“ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵖ, ⵉⵙⵙⵉⵡⴻⵍ ⴰⴽⵉⴷⵏⴻⵖ ⵖⴰⵔ ⵃⵓⵔⵉⴱ, ⵉⵏⵏⴰ: ‘ⴽⴻⵏⵏⵉⵡ ⵜⴻⵇⵇⵉⵎⴻⵏ ⴰⵟⵟⴰⵙ ⵖⴰⵔ ⵡⴻⴷⵔⴰⵔ-ⴰ, ⴰⵇⴰ ⴷ ⴰⵟⵟⴰⵙ. ");
INSERT INTO rift_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","ⴷⴻⵡⵍⴻⵎ, ⴽⴽⵙⴻⵎ ⵉⵇⵉⴹⴰⵏ ⵏⵡⴻⵎ ⵓⵛⴰ ⴰⴷⴼⴻⵎ ⵖⴰⵔ ⵉⴷⵓⵔⴰⵔ ⵏ ⵉⵎⵓⵔⵉⵢⵢⴻⵏ ⵓ ⵖⴰⵔ ⵎⴰⵔⵔⴰ ⵉⵎⵓⵛⴰⵏ ⵢⵓⴷⵙⴻⵏ ⴷⵉ ⵍⴻⵡⴹⴰ, ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵉⴷⵓⵔⴰⵔ, ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵉⵡⴰⵟⴰⵏ, ⴷⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵍⵊⴰⵏⵓⴱ ⵓ ⵖⴰⵔ ⵜⵎⴰ ⵏ ⵍⴻⴱⵃⴰⵔ, ⵜⴰⵎⵎⵓⵔⵜ ⵏ ⴰⵢⵜ ⵏ ⴽⴻⵏⵄⴰⵏ, ⴷ ⵍⵓⴱⵏⴰⵏ ⴰⵍ ⵉⵖⵣⴰⵔ ⴰⵎⴻⵇⵇⵔⴰⵏ, ⵉⵖⵣⴰⵔ ⵏ ⵍⴼⵓⵔⴰⵟ. ");
INSERT INTO rift_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","ⵅⵣⴰⵔ, ⵏⴻⵛⵛ ⵡⵛⵉⵖ ⴰⵡⴻⵎ ⵜⴰⵎⵎⵓⵔⵜ ⵉ ⵉⴵⴰⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏⵡⴻⵎ. ⴰⴷⴼⴻⵎ ⵖⴰⵔⴻⵙ, ⵜᵉⵟⵟⴼⴻⵎ ⵜⴰⵎⵎⵓⵔⵜ ⵏⵏⵉ ⵅ ⵉⵊⵊⵓⴵ ⵙⵉⴷⵉ ⴰⴷ ⵜⵜ ⵉⵡⵛ ⵉ ⵍⴻⵊⴷⵓⴷ ⵏⵡⴻⵎ, ⵉ ⵉⴱⵔⴰⵀⵉⵎ, ⵉⵙⵃⴰⵇ ⴷ ⵢⴰⵄⵇⵓⴱ, ⵓ ⵉ ⵣⵣⴰⵔⵉⵄⴻⵜ ⵏⵙⴻⵏ ⴰⵡⴰⵔⵏⵉ ⴰⵙⴻⵏ.’ ");
INSERT INTO rift_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","ⴷⵉ ⵍⵡⴻⵇⵜ ⵏⵏⵉ ⵙⵙⵉⵡⵍⴻⵖ ⵏⴻⵛⵛ ⴰⴽⵉⴷⵡⴻⵎ, ⵏⵏⵉⵖ: ‘ⵏⴻⵛⵛ ⵡⴰⵀⴰ ⵡⴰⵔ ⵣⴻⵎⵎⴰⵔⴻⵖ ⴰⴷ ⴰⵔⴱⵓⵖ ⴰⵎⵏⵓⵙ ⵉ ⴽⴻⵏⵏⵉⵡ. ");
INSERT INTO rift_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ, ⵉⴳⴳⴰ ⴽⴻⵏⵏⵉⵡ ⴷ ⴰⵟⵟⴰⵙ, ⵓⵛⴰ ⵅⵣⴰⵔ, ⴽⴻⵏⵏⵉⵡ ⵍⴻⵅⵅⵓ ⴷ ⴰⵟⵟⴰⵙ ⴰⵎ ⵢⵉⵜⵔⴰⵏ ⵏ ⵓⵊⴻⵏⵏⴰ. ");
INSERT INTO rift_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","ⴰⴷ ⵜⴰⴼ ⴰⴷ ⴷⴰⵢⵡⴻⵎ ⵉⵎⵎⴰⵔⵏⵉ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏ ⵍⴻⵊⴷⵓⴷ ⵏⵡⴻⵎ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴽⴻⵏⵏⵉⵡ ⵜⴻⴵⴰⵎ ⵍⴻⵅⵅⵓ ⴰⵍⴻⴼ ⵏ ⵜⵡⴰⵍⴰⵡⵉⵏ ⵓⵛⴰ ⴰⴷ ⵜⴰⴼ ⴰⴷ ⴽⴻⵏⵏⵉⵡ ⵉⴱⴰⵔⴻⴽ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵜⵓⵖⴰ ⵖⴰⵔⵡⴻⵎ ⴷⴷ-ⵉⵙⵙⵉⵡⴻⵍ. ");
INSERT INTO rift_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","ⵎⴰⵎⵎⴻⵛ ⵣⴻⵎⵎⴰⵔⴻⵖ ⵏⴻⵛⵛ ⵡⴻⵃⵃⴷⵉ ⵡⴰⵀⴰ ⴰⴷ ⴰⵔⴱⵓⵖ ⵉⵙⵃⴻⵙⵙⵉⴼⴻⵏ ⵏⵡⴻⵎ ⴷ ⴷⴷⵇⵓⵍⴰⵜ ⵏⵡⴻⵎ ⴷ ⵉⵎⵛⵓⴱⴱⴻⵛⴻⵏ ⵏⵡⴻⵎ? ");
INSERT INTO rift_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","ⴽⵙⵉⵎ ⵣⵉ ⵊⴰⵔ ⵜⴻⵇⴱⵉⵍⵜ ⵏⵡⴻⵎ ⵉⵔⵢⴰⵣⴻⵏ ⵉⵎⵉⵖⵉⵙⴻⵏ, ⵉⴼⴻⵀⵀⵎⴻⵏ, ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵙⵙⵏⴻⵏ ⵉⵛⵏⴰⵏ, ⵃⵉⵎⴰ ⴰⴷ ⵜⴻⵏ ⴳⴳⴻⵖ ⴷ ⵉⵣⴻⴵⵉⴼⴻⵏ ⵅⴰⵡⴻⵎ.’ ");
INSERT INTO rift_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","ⵅⴻⵏⵏⵉ ⴽⴻⵏⵏⵉⵡ ⵜⴰⵔⵔⵉⵎ-ⴷⴷ ⵅⴰⴼⵉ, ⵜⴻⵏⵏⴰⵎ ⴰⵢⵉ: ‘ⴰⵡⴰⵍ ⵉ ⵜⴻⵙⵙⵉⵡⵍⴻⴷ, ⴰⵇⴰ ⵉⴱⴰⵏ-ⴷⴷ ⵉⵛⵏⴰ, ⵃⵉⵎⴰ ⴰⴷ ⵜ ⵏⴻⴳⴳ.’ ");
INSERT INTO rift_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","ⵓⵛⴰ ⴽⵙⵉⵖ ⵉⵣⴻⴵⵉⴼⴻⵏ ⵏ ⵜⴻⵇⴱⵉⵍⵜ ⵏⵡⴻⵎ, ⵉⵔⵢⴰⵣⴻⵏ ⵉⵎⵉⵖⵉⵙⴻⵏ, ⵉⴼⴻⵀⵀⵎⴻⵏ, ⵉⵏⵏⵉ ⵉⵜⵜⵡⴰⵙⵙⵏⴻⵏ ⵉⵛⵏⴰⵏ, ⵓⵛⴰ ⴳⴳⵉⵖ ⵜⴻⵏ ⴷ ⵉⵣⴻⴵⵉⴼⴻⵏ ⵅⴰⵡⴻⵎ, ⴰⵎ ⵉⵎⴻⵇⵇⵔⴰⵏⴻⵏ ⵅ ⵡⴰⵍⴻⴼ, ⵉⵎⴻⵇⵇⵔⴰⵏⴻⵏ ⵅ ⵎⵢⴰ, ⵉⵎⴻⵇⵇⵔⴰⵏⴻⵏ ⵅ ⵅⴻⵎⵙⵉⵏ ⴷ ⵉⵎⴻⵇⵇⵔⴰⵏⴻⵏ ⵅ ⵄⴻⵛⵔⴰ, ⵓ ⴰⵎ ⵉⵎⴻⵃⴹⴰⵢⴻⵏ ⵅ ⵜⵇⴻⴱⴱⴰⵍ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","ⴷⵉ ⵍⵡⴻⵇⵜ ⵏⵏⵉ ⵓⵎⵓⵔⴻⵖ ⵉ ⵍⵇⵓⴹⴰⵜ ⵏⵡⴻⵎ ⵓⵛⴰ ⵏⵏⵉⵖ: ‘ⵙⵍⴻⵎ ⵖⴰⵔ ⴰⵢⵜⵎⴰⵜⵡⴻⵎ ⵓⵛⴰ ⵃⴻⴽⵎⴻⵎ ⵙ ⵢⵉⵊⵊ ⵏ ⵍⵃⵓⴽⵎ ⵉⵙⴻⴳⴳⴷⴻⵏ ⵊⴰⵔ ⵡⴻⵔⵢⴰⵣ ⴷ ⵓⵎⴰⵙ ⴷ ⵓⴱⴰⵔⵔⴰⵏⵉ ⵏⵏⵉ ⴽⵉⴷⴻⵙ ⵉⴵⴰⵏ.    ");
INSERT INTO rift_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","ⵡⴰⵔ ⵜⵜⴻⴳⴳⴻⵎ ⵙ ⵡⵓⴷⵎⴰⵡⴻⵏ ⴷⵉ ⵍⴻⵃⴽⴰⵎ. ⴰⴷ ⵜⴻⵙⵍⴻⵎ ⵖⴰⵔ ⵓⵎⴻⵥⵢⴰⵏ ⴷ ⵓⵎⴻⵇⵇⵔⴰⵏ. ⵡⴰⵔ ⵜⴻⴳⴳⵯⴷⴻⵎ ⵣⴻⴳ ⵡⵓⴷⴻⵎ ⵏ ⵛⴰ ⵏ ⵢⵉⵊⵊⴻⵏ, ⵎⵉⵏⵣⵉ ⵍⴻⵃⴽⴰⵎ ⵖⴰⵔ ⴰⵔⴻⴱⴱⵉ. ⵜⴰⵎⴻⵙⵍⴰⵛⵜ ⵏⵏⵉ ⵜⴻⵡⵄⴰⵔ ⵅⴰⵡⴻⵎ, ⴰⵡⵢⴻⵎ ⵜⵜ-ⵉ-ⴷⴷ ⵖⴰⵔⵉ ⵓⵛⴰ ⵏⴻⵛⵛ ⴰⴷ ⵜⵜ ⵙⵍⴻⵖ.’ ");
INSERT INTO rift_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","ⴰⵎⵎⵓ ⵉ ⴽⴻⵏⵏⵉⵡ ⵓⵎⵓⵔⴻⵖ ⴷⵉ ⵍⵡⴻⵇⵜ ⵏⵏⵉ ⵎⴰⵔⵔⴰ ⵜⵉⵎⴻⵙⵍⴰⵢⵉⵏ ⵏⵏⵉ ⵅⴰⵡⴻⵎ ⴰⴷ ⵜⴻⵏⵜ ⵜⴻⴳⴳⴻⵎ.” ");
INSERT INTO rift_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","“ⵅⴻⵏⵏⵉ ⵏⴻⴼⵙⵉ ⵉⵇⵉⴹⴰⵏ ⵏⵏⴻⵖ ⵓⵛⴰ ⵏⴻⴼⴼⴻⵖ ⵣⵉ ⵃⵓⵔⵉⴱ ⵓⵛⴰ ⵏⴻⵥⵡⴰ ⵎⴰⵔⵔⴰ ⵍⴻⵅⵍⴰ ⴰⵎⴻⵇⵇⵔⴰⵏ ⵉⵙⵙⴰⴳⴳⵯⴰⴷⴻⵏ ⵏⵏⵉ ⵜⴻⵥⵔⵉⵎ, ⵏⵓⵢⵓⵔ ⴷⴻⴳ ⵡⴻⴱⵔⵉⴷ ⵏ ⵉⴷⵓⵔⴰⵔ ⵏ ⵉⵎⵓⵔⵉⵢⵢⴻⵏ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵏⴻⵖ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵖ, ⵓⵛⴰ ⵏⵉⵡⴻⴹ ⵖⴰⵔ ⵇⴰⴷⴰⵛ-ⴱⴰⵔⵏⵉⵄ. ");
INSERT INTO rift_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","ⵅⴻⵏⵏⵉ ⵏⵏⵉⵖ ⴰⵡⴻⵎ: ‘ⴰⵇⴰ ⵜⵉⵡⴹⴻⵎ ⵖⴰⵔ ⵉⴷⵓⵔⴰⵔ ⵏ ⵉⵎⵓⵔⵉⵢⵢⴻⵏ ⵏⵏⵉ ⵉ ⴷ ⴰⵏⴻⵖ ⵖⴰ ⵉⵡⵛ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵖ. ");
INSERT INTO rift_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","ⵅⵣⴰⵔ, ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵛ, ⴰⵇⴰ ⵉⵡⵛⴰ ⴰⵙ ⵜⴰⵎⵎⵓⵔⵜ ⵉ ⴷⵉⵏ ⵉⴵⴰⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏⵏⴻⵛ. ⴳⴻⵄⵄⴻⴷ, ⵟⵟⴻⴼ ⵉ-ⵜⵜ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵖⴰⵔⴻⴽ ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏ ⵍⴻⵊⴷⵓⴷ ⵏⵡⴻⵎ. ⵡⴰⵔ ⵜⵜⴻⴳⴳⵯⴻⴷ ⵓ ⵡⴰⵔ ⵜⵜⴻⵊⵊⵉ ⴰⴷ ⵉⵄⴳⴻⵣ ⵡⵓⵍ ⵏⵏⴻⵛ.’ ");
INSERT INTO rift_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","ⵜⵓⵙⵉⵎ-ⴷⴷ ⵖⴰⵔⵉ ⵎⴰⵔⵔⴰ ⴽⴻⵏⵏⵉⵡ, ⵜⴻⵏⵏⴰⵎ: ‘ⴻⵊⵊ ⴰⵏⴻⵖ ⴰⴷ ⵏⴻⵙⵙⴻⴽⴽ ⵉⵔⵢⴰⵣⴻⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏⵏⴻⵖ ⵃⵉⵎⴰ ⴰⴷ ⴱⴻⵔⴳⴰⴳⴻⵏ ⵜⴰⵎⵎⵓⵔⵜ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴰⵏⴻⵖ ⵅⴻⴱⴱⴰⵔⴻⵏ ⵅ ⵎⴰⵏ ⴰⴱⵔⵉⴷ ⵉ ⵣⵉ ⵖⴰ ⵏⴳⴻⵄⵄⴻⴷ ⴷⵉ ⵜⴰⵎⵎⵓⵔⵜ ⵓ ⵎⴰⵎⵎⴻⵛ ⴵⴰⵏⵜ ⵜⵏⴻⴷⴷⴰⵎ ⵉ ⵖⴰⵔ ⴷⴷ ⵖⴰ ⵏⴰⵙ.’ ");
INSERT INTO rift_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","ⵜⵓⵖⴰ ⴰⵡⴰⵍ-ⴰ ⴷ ⵍⴻⵎⵍⵉⵃ ⵉ ⵏⴻⵛⵛ ⵓⵛⴰ ⴽⵙⵉⵖ ⵜⴻⵏⵄⴰⵛ ⵏ ⵢⴻⵔⵢⴰⵣⴻⵏ ⵣⵉ ⵍⵡⴻⵙⵜ ⵏⵡⴻⵎ, ⵣⵉ ⴽⵓⵍ ⵜⴰⵇⴱⵉⵍⵜ ⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ. ");
INSERT INTO rift_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","ⵏⵏⴹⴻⵏ ⵏⵉⵜⵏⵉ ⵓⵛⴰ ⵓⵢⵓⵔⴻⵏ ⵅ ⵡⴻⴱⵔⵉⴷ ⵖⴰⵔ ⵉⴷⵓⵔⴰⵔ ⵓⵛⴰ ⵓⵙⵉⵏ-ⴷⴷ ⵖⴰⵔ ⵜⴻⵖⵣⵓⵔⵜ ⵏ ⵉⵛⴽⵓⵍ ⵓⵛⴰ ⴱⴻⵔⴳⴰⴳⴻⵏ ⵜⴻⵎⵎⵓⵔⵜ. ");
INSERT INTO rift_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","ⴽⵙⵉⵏ ⵙ ⵉⴼⴰⵙⵙⴻⵏ ⵏⵙⴻⵏ ⵍⵖⵉⴵⴻⵜ ⵏ ⵜⴻⵎⵎⵓⵔⵜ ⵓⵛⴰ ⵀⵡⴰⵏ-ⴷⴷ ⵖⴰⵔⵏⴻⵖ. ⵉⵡⵢⴻⵏ ⴰⵏⴻⵖ-ⴷⴷ ⵍⴻⵅⴱⴰⵔ, ⵏⵏⴰⵏ: ‘ⵜⴰⵎⵎⵓⵔⵜ ⵉ ⴷ ⴰⵏⴻⵖ ⵖⴰ ⵉⵡⵛ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵖ, ⵜⴻⵚⴱⴻⵃ.’” ");
INSERT INTO rift_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","“ⵇⴰⵄ ⴰⵎⴻⵏⵏⵉ, ⵡⴰⵔ ⵜⴻⵅⵙⴻⵎ ⴰⴷ ⵜⴳⴻⵄⵄⴷⴻⵎ ⵓⵛⴰ ⵜⵖⴻⵡⵡⵖⴻⵎ ⴹⵉⴷⴷ ⵉ ⵍⵓⵎⵓⵔ ⵏ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","ⵓⵛⴰ ⵜⵏⴻⴷⵇⴻⵎ-ⴷⴷ ⴷⴻⴳ ⵉⵇⵉⴹⴰⵏ ⵏⵡⴻⵎ, ⵜⴻⵏⵏⴰⵎ: ‘ⴷⴻⴳ ⵡⴻⵇⵍⴰⴱ ⵏⵏⴻⵙ ⵅⴰⵏⴻⵖ, ⴰⵇⴰ ⵉⵙⵙⵓⴼⴼⴻⵖ ⴰⵏⴻⵖ ⵙⵉⴷⵉ ⵣⵉ ⵜⴻⵎⵎⵓⵔⵜ ⵏ ⵎⵉⵚⵔⴰ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴰⵏⴻⵖ ⵢⴰⵔⵔ ⵖⴰⵔ ⵉⴼⴰⵙⵙⴻⵏ ⵏ ⵉⵎⵓⵔⵉⵢⵢⴻⵏ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴰⵏⴻⵖ ⵢⴰⵔⴻⴷⴷⴻⴵ. ");
INSERT INTO rift_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","ⵎⴰⵏⵉ ⵅⴻⵏⵏⵉ ⵉ ⵖⴰ ⵏⴳⴻⵄⵄⴻⴷ? ⴰⵢⵜⵎⴰⵜⵏⴻⵖ ⵙⵙⴼⴻⵙⵙⵢⴻⵏ ⵓⵍⴰⵡⴻⵏ ⵏⵏⴻⵖ, ⵏⵏⴰⵏ: ⵍⴳⴻⵏⵙ ⵉⵎⵖⴰⵔ ⵓⵛⴰ ⵣⵣⵓⴳⴰⵔⴻⵏ ⵅⴰⵏⴻⵖ. ⵜⵉⵏⴻⴷⴷⴰⵎ ⵎⵖⴰⵔⴻⵏⵜ ⵓⵛⴰ ⵜⵜⵡⴰⴼⴰⵔⵢⴻⵏⵜ ⴰⵍ ⴰⵊⴻⵏⵏⴰ ⵓⵛⴰ ⵏⴻⵥⵔⴰ ⴷⵉⵏ ⵓⵍⴰ ⴷ ⴰⵢⵜ ⵏ ⵄⴰⵏⴰⵇ.’ ");
INSERT INTO rift_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","ⵏⴻⵛⵛ ⵏⵏⵉⵖ ⴰⵡⴻⵎ: ‘ⵡⴰⵔ ⵜⴰⵔⵊⵉⵊⴻⵎ ⵛⴰ ⵓ ⵡⴰⵔ ⵣⵣⴰⵢⵙⴻⵏ ⵜⵜⴻⴳⴳⵯⴷⴻⵎ. ");
INSERT INTO rift_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ, ⵡⴻⵏⵏⵉ ⵉⴳⴳⵓⵔⴻⵏ ⵣⵣⴰⵜⵡⴻⵎ, ⴰⴷ ⵉⵎⵎⵏⴻⵖ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏⵡⴻⵎ, ⴰⵎⵎⵓ ⵏⵉⵛⴰⵏ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⵉⴳⴳⴰ ⵣⵣⴰⵜ ⵉ ⵜⵉⵟⵟⴰⵡⵉⵏ ⵏⵡⴻⵎ ⴷⵉ ⵟⵟⵡⴻⵄ ⵏⵡⴻⵎ ⴷⵉ ⵎⵉⵚⵔⴰ ");
INSERT INTO rift_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","ⵓⵍⴰ ⴷⵉ ⵔⴻⵅⵍⴰ, ⵎⴰⵏⵉ ⵜⴻⵥⵔⵉⴷ ⵎⴰⵎⵎⴻⵛ ⵜⵓⵖⴰ ⵛⴻⴽ ⵢⴰⵔⴻⴱⴱⵓ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵛ, ⵎⴰⵔⵔⴰ ⴰⴱⵔⵉⴷ ⵏⵏⵉ ⵜⵓⵢⵓⵔⴻⴷ, ⴰⵎ ⵢⵉⵊⵊ ⵏ ⵡⴻⵔⵢⴰⵣ ⵢⴰⵔⴻⴱⴱⵓⵏ ⵎⵎⵉⵙ, ⴰⵍⴰⵎⵉ ⴷⴷ-ⵜⵉⵡⴹⴻⵎ ⵖⴰⵔ ⵡⴻⵎⵛⴰⵏ-ⴰ.’ ");
INSERT INTO rift_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","ⵎⴰⵛⴰ ⴽⴻⵏⵏⵉⵡ ⵄⴰⴷ ⵡⴰⵔ ⵜⵓⵎⵉⵏⴻⵎ ⵛⴰ ⵙ ⵡⴰⵡⴰⵍ-ⴰ ⴷⵉ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵡⴻⵎ, ");
INSERT INTO rift_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","ⵡⴻⵏⵏⵉ ⵜⵓⵖⴰ ⵉⴳⴳⵓⵔⴻⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏⵡⴻⵎ ⴷⴻⴳ ⵡⴻⴱⵔⵉⴷ, ⵃⵉⵎⴰ ⴰⴷ ⴰⵡⴻⵎ ⵢⴰⵔⵣⵓ ⵎⴰⵏⵉ ⵖⴰ ⵜⴻⵡⵜⴻⵎ ⵉⵇⵉⴹⴰⵏ ⵏⵡⴻⵎ, ⵓ ⵡⴻⵏⵏⵉ ⵜⵓⵖⴰ ⵉⴳⴳⵓⵔⴻⵏ, ⵙ ⴵⵉⵍⴻⵜ ⴷⵉ ⵜⵎⴻⵙⵙⵉ, ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⴰⵡⴻⵎ ⵉⵙⵙⵛⴻⵏ ⴰⴱⵔⵉⴷ ⵎⴰⵏⵉ ⴽⴻⵏⵏⵉⵡ ⵉⵜⵜⵅⴻⵚⵚⴰ ⴰⴷ ⵜⵓⵢⵓⵔⴻⵎ, ⵓ ⵙ ⵓⵣⵉⵍ ⴷⴻⴳ ⵉⵊⵊ ⵏ ⵓⵙⴻⵢⵏⵓ. ");
INSERT INTO rift_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","ⵙⵉⴷⵉ ⵉⵙⵍⴰ ⵍⵃⴻⵙⵙ ⵏ ⵡⴰⵡⴰⵍⴻⵏ ⵏⵡⴻⵎ ⵓⵛⴰ ⵉⵊⵊⴰ ⴰⵖⴹⴰⴱ ⵏⵏⴻⵙ ⴰⴷ ⵉⴷⴷⵓⵇⵇⴻⵣ, ⵉⵊⵊⵓⴵ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","‘ⵓⵍⴰ ⴷ ⵉⵊⵊ ⵣⴻⴳ ⵢⴻⵔⵢⴰⵣⴻⵏ-ⴰ ⵏ ⵊⵊⵉⵍ-ⴰ ⴰⵄⴻⴼⴼⴰⵏ ⵡⴰⵔ ⵉⵥⴰⵔⵔ ⵜⴰⵎⵎⵓⵔⵜ ⵉⵛⵏⴰⵏ ⵏⵏⵉ ⵅ ⵊⵊⵓⴵⴻⵖ ⵎⴰⵃⴻⵏⴷ ⴰⴷ ⵜⵜ ⵡⵛⴻⵖ ⵉ ⵍⴻⵊⴷⵓⴷ ⵏⵡⴻⵎ, ");
INSERT INTO rift_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","ⵎⵖⵉⵔ ⴽⴰⵍⵉⴱ, ⵎⵎⵉⵙ ⵏ ⵢⴰⴼⵓⵏⵏⵉ, ⵏⴻⵜⵜⴰ ⴰⴷ ⵜⵜ ⵉⵥⴰⵔ ⵓⵛⴰ ⵉ ⵏⴻⵜⵜⴰ ⴷ ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵏⴻⵙ ⴰⴷ ⵡⵛⴻⵖ ⵜⴰⵎⵎⵓⵔⵜ ⵏⵏⵉ ⵅ ⵉⴳⴳⴰ ⵉⴹⴰⵔⴻⵏ ⵏⵏⴻⵙ, ⵎⵉⵏⵣⵉ ⵏⴻⵜⵜⴰ ⵜⵓⵖⴰ ⵉⴹⴻⴼⴼⴰⵔ ⵙⵉⴷⵉ ⵏⵉⵛⴰⵏ.’ ");
INSERT INTO rift_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","ⵉⵙⵄⴰⵔ ⵅⴰⴼⵉ ⵙⵉⴷⵉ ⴷⵉ ⵙⵙⵉⴱⴱⴻⵜ ⵏⵡⴻⵎ, ⵉⵏⵏⴰ: ‘ⵓⵍⴰ ⴷ ⵛⴻⴽ ⵡⴰⵔ ⵖⴰⵔⴻⵙ ⵜⵜⵉⴷⴼⴻⴷ ⵛⴰ! ");
INSERT INTO rift_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","ⵢⴰⵛⵓⵡⴰ, ⵎⵎⵉⵙ ⵏ ⵏⵓⵏ, ⵡⴻⵏⵏⵉ ⵉⴱⴻⴷⴷⴻⵏ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏⵏⴻⵛ, ⴰⴷ ⵖⴰⵔⴻⵙ ⵢⴰⴷⴻⴼ. ⵙⵊⴻⵀⴷ ⵉ-ⵜ, ⵎⵉⵏⵣⵉ ⵏⴻⵜⵜⴰ ⴷ ⵡⴻⵏⵏⵉ ⵜⵜ ⵖⴰ ⵉⵡⵛⴻⵏ ⴷ ⵍⵡⴰⵔⵜ ⵉ ⵉⵙⵔⴰⵉⵍ. ");
INSERT INTO rift_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","ⵓⵛⴰ ⵜⴰⵔⵡⴰ ⵏⵡⴻⵎ ⵉ ⵅ ⵜⴻⵏⵏⴰⵎ: ⴰⴷ ⴷⴻⵡⵍⴻⵏ ⴷ ⵜⴻⵢⵎⴰⵔⵜ!, ⵉⵃⴻⵏⵊⵉⵔⴻⵏ ⵏⵡⴻⵎ ⵏⵏⵉ ⵡⴰⵔ ⵙⵙⵉⵏⴻⵏ ⵄⴰⴷ ⵍⵅⴰⵔ ⵏⵉⵖ ⵍⵖⴰⵔ, ⵏⵉⵜⵏⵉ ⴰⴷ ⵖⴰⵔⴻⵙ ⴰⴷⴼⴻⵏ ⵓⵛⴰ ⵏⴻⵛⵛ ⴰⴷ ⴰⵙⴻⵏ ⵜⵜ-ⵉ-ⴷⴷ-ⵡⵛⴻⵖ ⵓⵛⴰ ⵏⵉⵜⵏⵉ ⴰⴷ ⵜⵜ ⵡⴰⵔⵜⴻⵏ. ");
INSERT INTO rift_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","ⵎⴰⵛⴰ ⴽⴻⵏⵏⵉⵡ ⴰⴷ ⴷⴷ-ⵜⴷⴻⵡⵍⴻⵎ, ⴰⴷ ⵜⴻⴽⴽⵙⴻⵎ ⵉⵇⵉⴹⴰⵏ ⵏⵡⴻⵎ ⵙⵙⴰ ⵓⵛⴰ ⴰⴷ ⵜⵓⵢⵓⵔⴻⵎ ⵖⴰⵔ ⵍⴻⵅⵍⴰ ⵖⴰⵔ ⵍⴻⴱⵃⴰⵔ ⵏ ⵜⴻⵍⴳⴰ.’ ");
INSERT INTO rift_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","ⴽⴻⵏⵏⵉⵡ ⵜⴰⵔⵔⵉⵎ-ⴷⴷ, ⵜⴻⵏⵏⴰⵎ ⴰⵢⵉ: ‘ⴰⵇⴰ ⵏⴻⵅⴹⴰ ⴰⴽ-ⴷ ⵙⵉⴷⵉ. ⴰⴷ ⵏⴳⴻⵄⵄⴻⴷ ⵓⵛⴰ ⴰⴷ ⵏⴻⵎⵎⵏⴻⵖ ⵇⴰⵄ ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵏⴻⵖ ⵢⵓⵎⵓⵔ ⵙⵉⴷⵉ, ⴰⵔⴻⴱⴱⵉ ⵏⵏⴻⵖ.’ ⵅⴻⵏⵏⵉ ⵜⴱⴻⵢⵙⴻⵎ, ⴽⵓⵍ ⵉⵊⵊ ⵙ ⵍⴻⵙⵏⴰⵃ ⵏⵏⴻⵙ ⵏ ⴳⴰⵔⵔⴰ ⵓ ⴽⴻⵏⵏⵉⵡ ⵙ ⵣⵣⵄⴰⵎⴻⵜ ⵏⵡⴻⵎ ⵜⴱⴻⴷⴷⴻⵎ ⴰⴷ ⵜⴳⴻⵄⵄⴷⴻⵎ ⵖⴰⵔ ⵡⴻⴷⵔⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","ⵅⴻⵏⵏⵉ ⵉⵏⵏⴰ ⴰⵢⵉ ⵙⵉⴷⵉ: ‘ⵉⵏⵉ ⴰⵙⴻⵏ: ⵡⴰⵔ ⵜⵜⴳⴻⵄⵄⴷⴻⵎ, ⵡⴰⵔ ⵜⵜⵎⴻⵏⵖⵉⵎ, ⵎⵉⵏⵣⵉ ⵏⴻⵛⵛ ⵡⴰⵔ ⴵⵉⵖ ⴷⵉ ⵍⵡⴻⵙⵟ ⵏⵡⴻⵎ, ⵃⵉⵎⴰ ⵡⴰⵔ ⵜⵅⴻⵚⵚⴰⵔⴻⵎ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵍⵄⴻⴷⵢⴰⵏ ⵏⵡⴻⵎ.’ ");
INSERT INTO rift_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","ⴰⵎⵎⵓ ⵉ ⴽⵉⵡⴻⵎ ⵙⵙⵉⵡⵍⴻⵖ, ⵎⴰⵛⴰ ⴽⴻⵏⵏⵉⵡ ⵡⴰⵔ ⵜⵜⴻⵙⵍⵉⵎ ⵓⵛⴰ ⵜⵖⴻⵡⵡⵖⴻⵎ ⴹⵉⴷⴷ ⵉ ⵍⵓⵎⵓⵔ ⵏ ⵙⵉⴷⵉ ⵓⵛⴰ ⵜⴻⴳⴳⵉⵎ ⵙ ⵜⵓⴼⴼⴻⵜ, ⵜⴳⴻⵄⵄⴷⴻⵎ ⵖⴰⵔ ⵉⴷⵓⵔⴰⵔ. ");
INSERT INTO rift_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","ⵓⵛⴰ ⴼⴼⵖⴻⵏ ⵉⵎⵓⵔⵉⵢⵢⴻⵏ ⵏⵏⵉ ⵜⵓⵖⴰ ⵉⵣⴻⴷⴷⵖⴻⵏ ⴷⴻⴳ ⵉⴷⵓⵔⴰⵔ ⵓⵛⴰ ⵓⵥⵥⵍⴻⵏ ⵅⴰⵡⴻⵎ, ⴰⵎ ⵜⵜⴻⴳⴳⴻⵏⵜ ⵜⵣⵉⵣⵡⴰ, ⵓⵛⴰ ⵍⴻⴱⵣⴻⵏ ⴽⴻⵏⵏⵉⵡ ⴷⵉ ⵚⴰⵄⵉⵔ ⴰⵍ ⵃⵓⵔⵎⴰ. ");
INSERT INTO rift_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","ⵜⴷⴻⵡⵍⴻⵎ-ⴷⴷ, ⵜⴻⵙⵙⵖⵓⵢⴻⵎ ⵣⵣⴰⵜ ⵉ ⵡⵓⴷⴻⵎ ⵏ ⵙⵉⴷⵉ. ⵙⵉⴷⵉ ⵡⴰⵔ ⵉⵙⵍⵉ ⵉ ⵜⵎⵉⵊⵊⴰ ⵏⵡⴻⵎ, ⵡⴰⵔ ⴷ ⴰⵡⴻⵎ ⵉⵡⵛⵉ ⴰⵎⴻⵣⵣⵓⵖ, ");
INSERT INTO rift_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","ⵓⵛⴰ ⵜⴻⵇⵇⵉⵎⴻⵎ ⴷⵉ ⵇⴰⴷⴰⵛ ⵉⵛⵜ ⵏ ⵍⵡⴻⵇⵜ ⴷ ⴰⵣⵉⵔⴰⵔ, ⵓⵙⵙⴰⵏ ⴰⵟⵟⴰⵙ ⵉ ⴷⵉⵏⵏⵉ ⵜⴻⵇⵇⵉⵎⴻⵎ.” ");
INSERT INTO rift_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","“ⵅⴻⵏⵏⵉ ⵏⴻⴷⵡⴻⵍ-ⴷⴷ ⵓⵛⴰ ⵏⴻⴼⵙⵉ ⵉⵇⵉⴹⴰⵏ ⵓⵛⴰ ⵏⵓⵢⵓⵔ ⵖⴰⵔ ⵍⴻⵅⵍⴰ, ⴷⴻⴳ ⵡⴻⴱⵔⵉⴷ ⵖⴰⵔ ⵍⴻⴱⵃⴰⵔ ⵏ ⵜⴻⵍⴳⴰ, ⴰⵎ ⵎⴰⵎⵎⴻⵛ ⴷ ⴰⵢⵉ ⵉⵏⵏⴰ ⵙⵉⴷⵉ ⵓⵛⴰ ⵏⴻⵏⵏⴻⴹ ⴰⵟⵟⴰⵙ ⵏ ⵡⵓⵙⵙⴰⵏ ⵉ ⵉⴷⵓⵔⴰⵔ ⵏ ⵙⴰⵄⵉⵔ. ");
INSERT INTO rift_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","ⵅⴻⵏⵏⵉ ⵉⵙⵙⵉⵡⴻⵍ ⵙⵉⴷⵉ ⴰⴽⵉⴷⵉ, ⵉⵏⵏⴰ: ");
INSERT INTO rift_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","‘ⴰⵟⵟⴰⵙ ⵉ ⵜⴻⵏⵏⴹⴻⵎ ⵉ ⵡⴻⴷⵔⴰⵔ-ⴰ, ⴰⵇⴰ ⵛⴼⴰ. ⴰⵔⵔⴻⵎ ⴰⵣⴻⴵⵉⴼ ⵖⴰⵔ ⵛⵛⴰⵎⴰⵍ ");
INSERT INTO rift_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","ⵓⵛⴰ ⵓ